﻿USE sofia;
DROP TABLE IF EXISTS sofia.biv_vpl;
CREATE TABLE biv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES biv_vpl WRITE;
INSERT INTO biv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","A Yesu Kɩrɩsɩto sãakpãmɩne nɩ nyã, wʊ yin a Nãa David nɩ Abraham bal pɔ, ");
INSERT INTO biv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham lɛ ɩ Isaakɩ sãa, ka Isaakɩ mɩ ɩ Jekɔb sãa, ka Jekɔb mɩ dɔ̃ɔ ɩ Juda sãa nɩ a wʊ yɛɛr, ");
INSERT INTO biv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ka Juda mɩ ɩ Perejɩ nɩ Jera sãa, ka ba ma di Tamar, nɩ Perejɩ na ɩ Hejoron sãa, ka Hejoron mɩ ɩ Aram sãa, ");
INSERT INTO biv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ka Aram mɩ ɩ Aminadab sãa, ka Aminadab mɩ ɩ Nason sãa, ka Nason mɩ ɩ Salmon sãa, ");
INSERT INTO biv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ka Salmon mɩ ɩ Boajɩ sãa, ka a wʊ ma di Worahab, ka Boajɩ mɩ ɩ Obed sãa, a wʊ ma lɛ Wʊruf, ka Obed mɩ ɩ Jesɩ sãa, ");
INSERT INTO biv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ka Jesɩ mɩ ɩ a Nãa David sãa. David lɛ ɩ a Solomon sãa, ka a wʊ ma dɔ̃ɔ ɩ a Yurɩya pɔɔ. ");
INSERT INTO biv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ka a Solomon mɩ ɩ Wʊrehobom sãa, ka Wʊrehobom mɩ ɩ Abija sãa, ka Abija mɩ ɩ Asa sãa, ");
INSERT INTO biv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ka Asa mɩ ɩ Jehosafatɩ sãa, ka a Jehosafatɩ mɩ ɩ Jehoram sãa, ka Jehoram mɩ ɩ Yujiya sãa, ");
INSERT INTO biv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ka Yujiya mɩ ɩ Jotam sãa, ka Jotam mɩ ɩ Ahajɩ sãa, ka Ahajɩ mɩ ɩ Hɛjɩkiya sãa, ");
INSERT INTO biv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ka Hɛjɩkiya mɩ ɩ Manasɛ sãa, ka Manasɛ mɩ ɩ Amɔn sãa, ka Amɔn mɩ ɩ Josiya sãa, ");
INSERT INTO biv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ka Josiya mɩ ɩ Jekoniya sãa, nɩ a wʊ yɛɛr a sɔ̃ɔ 'lɔ ban bar a ba tẽe tɩ chen tɩ kpɩɛrɛ Babilon tẽe. ");
INSERT INTO biv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ban wa tɩ be a Babilon tẽe pɔ, Jekoniya lɛ ɩ a Sealtɩɛl sãa, ka Sealtɩɛl ɩ Jerubabel sãa, ");
INSERT INTO biv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ka Jerubabel mɩ ɩ Abiud sãa, ka Abiud mɩ ɩ Eliyakim sãa, ka Eliyakim mɩ ɩ Ajor sãa, ");
INSERT INTO biv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ka Ajor mɩ ɩ Jadɔk sãa, ka Jadɔk mɩ ɩ Achɩm sãa, ka Achɩm mɩ ɩ Ɛliud sãa, ");
INSERT INTO biv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ka Ɛliud mɩ ɩ Elɩyajar sãa, ka Elɩyajar mɩ ɩ Matan sãa, ka Matan mɩ ɩ Jekɔb sãa, ");
INSERT INTO biv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekɔb mɩ lɛ ɩ a Josefʊ sãa na ɩ Mɛɛr sɩrɛ 'lɔ lɛ ɩ a Yesu ma, a Yesu nyã lɛ ɩ a Nɩ-iraa. ");
INSERT INTO biv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","An yi Abraham tɩ ta a Nãa David, a Yesu sãakpãmɩne ɩ naa pie nɩ anaar, an yi Nãa David tɩ tãn a sɔ̃ɔ 'lɔ a ba dɔ̃dɔ̃mɔ̃sɩ na nyɔɔr ba chiin a Babilon wɛr pɔ ba mɩ ɩ naa pie nɩ anaar, an lɛ yi a ba gbãgbaar ɩfʊ a Babilon wɛr pɔ tɩ tãn a Nɩ-iraa a ba mɩ ɩ pie nɩ anaar. ");
INSERT INTO biv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nɩtɔ̃ lɛ a Yesu Kɩrɩsɩto dɔɔfʊ yele tu. A wʊ ma Mɛɛr ŋmaan na Josefʊ baraa tɩchɛ baa kul taa sɛrɛ ɛ, ka Nãaŋmɩn Sɩɛ vɛ̃ ka wʊ tara pʊɔ. ");
INSERT INTO biv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A wʊ baraa Josefʊ na ɩ nɩtor jũu, ba bʊɔrɔ ɩka wʊ su wʊ vĩ nɩyɔɔ pɔ ɛ, ka wʊ tɩɛr ɩka wʊ sɔɔl bar wʊ jaa jomm. ");
INSERT INTO biv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wʊn wa tɩɛr a yele nyã maalfʊ, ka a Nãaŋmɩn malaka wa a wʊ sɛ̃ jãn pɔ wa 'yɛr, “Josefʊ, David bie, ta joro dãbãɛ ɩka fʊ de a Mɛɛr ka wʊ ɩ a fʊ pɔɔ ɛ, a bie na be a wʊ pʊɔm yin a Nãaŋmɩn Sɩɛ kpɛ̃ɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wʊn dɔɔn dabile ka fʊ na bʊɔlɔ a wʊ yuor Yesu, 'lɔ lɛ na faa a wʊ nɩbɛ yin a ba yeldɛbɛ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Anyã a jaa ɩ naa ka a wiil a sɩ Soro 'yɛrbie wʊn dɔ̃ɔ 'yɛr tu a wʊ 'yɛ'yɛrɛ pɔ ɩ yelmãɛ, ");
INSERT INTO biv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nyɛ a pɔɔsarbile na tara na pʊɔ dɔɔ dabile, ban 'yɔ̃ɔn a wʊ yuor Emanuwɛl,” a par lɛ, Nãaŋmɩn ben a sɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josefʊ na wa jɛɔ a gʊ̃ɔ pɔ, wʊ ɩn a lɛ jaa a Nãaŋmɩn malaka na 'yɛr ɩka wʊ ɩ. Ka wʊ de a Mɛɛr ka wʊ ɩ a wʊ pɔɔ, ");
INSERT INTO biv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","tɩchɛ baa lɔɔ sɔ̃ɔ ɛ, tɩ tãn a sɔ̃ɔ 'lɔ wʊn dɔɔ a dabile, na wʊ 'yɔ̃ɔ a wʊ yuor Yesu. ");
INSERT INTO biv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu ban wa dɔɔ Bɛtɩlɛhɛm tẽe a Judiya paal pɔ a Nãa Hɛrɔd sɔ̃ɔ, yɛ̃ dẽme yin be a Jerusalɛm sapar wa, ");
INSERT INTO biv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","na ba wa sʊrɔ, “Nyɩnɛ lɛ a bie be ban dɔɔ ka wʊ ɩ a Juu nɩbɛ nãa? Sɩ nyɛ naa a wʊ ŋmɛrbir a sapar ɩka sɩ wa puor wʊ.” ");
INSERT INTO biv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","A Nãa Hɛrɔd na wa wõ a lɛ wʊ pʊɔ sɔ̃ɔ naa, ka Jerusalɛm nɩyɔɔ pʊʊr mɩ sɔ̃ɔ, ");
INSERT INTO biv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","be lɛ wʊ bʊɔl a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a nɛɛ wiwiilbe sʊʊr bʊɔrɔ ɩka wʊ bɔ̃ɔ a jie 'lɔ ban na dɔɔ a Nɩ-iraa. ");
INSERT INTO biv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ka ba 'yɛr kʊ wʊ, “Bɛtɩlɛhɛm na be Judiya, lɛ lɛ a Nãaŋmɩn 'yɛ'yɛrɛ dɔ̃ɔ sɛb bin, ");
INSERT INTO biv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Fʊ̃ʊ Bɛtɩlɛhɛm na be a Judiya paal pɔ, fʊ̃ʊ lɛ ɩ jaa pʊʊrbile a Juda kpãɛn dẽme pɔ, fʊ pɔ lɛ a kpɛ̃ɔ sʊɔ na yi kaara a n nɩbɛ Isɩral.’ ” ");
INSERT INTO biv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Be lɛ ka Hɛrɔd sɔɔl bʊɔl a yɛ̃ dẽme bala sʊʊr ba a sɔ̃ɔ 'lɔ a ŋmɛrbir na pur wa. ");
INSERT INTO biv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Be lɛ wʊ tara ba chiin Bɛtɩlɛhɛm tɩ 'yɛr, “Yɩ chen tɩ yɔbɔ a bie kaa nɛ nɛ, yin wa nyɛ wʊ yɩ lɩɛb wa 'yɛr kʊ ma ka n mɩ chen tɩ puor wʊ.” ");
INSERT INTO biv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ban wa chɛl a nãa 'yɛr baar, ba yin lo a sɔr chiine, a ŋmɛrbir 'lɔ ban nyɛ a sapar de ban nie tɩ ara a jie 'lɔ a bie na be. ");
INSERT INTO biv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ban wa nyɛ ka a ŋmɛrbir ara nʊ̃ɔ kpɛ ban yɔɔ jaa. ");
INSERT INTO biv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ban kpɛ a yir pɔ, ba nyɛn a bie nɩ a wʊ ma Mɛɛr, na ba gbur dumo puor wʊ. Be lɛ ba tũ a ba wʊʊr pɔ ir kʊfʊsɩ na ɩ sɛlma, nyɩnyɩbɩ kãa nyũu nʊ̃ɔ nɩ kãnyũu ala ban bʊɔlɔ sɩmura kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tɩchɛ Nãaŋmɩn dɔ̃ɔ kpãa ba a jãn pɔ, ɩka ba ta lɛ lɩɛb chen a Nãa Hɛrɔd sɛ̃ ɛ, ka ba tu jiyuo kul a ba tẽe. ");
INSERT INTO biv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","A yɛ̃ bɔ̃ɔnbɔ na wa chen baar, a Nãaŋmɩn malaka wan Josefʊ sɛ̃ jãn pɔ wa 'yɛr kʊ wʊ, “Vaa ir 'mɔɔ a bie nɩ a wʊ ma, na fʊ jo chiin be Ijipitɩ wɛr pɔ, na fʊ tɩ be a be wa tɩ tãn a sɔ̃ɔ 'lɔ ɩn na 'yɛr kʊ fʊ, bojũu a Hɛrɔd nɩ a wʊ nɩbɛ bʊɔrɔ na a bie kʊfʊ.” ");
INSERT INTO biv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ka a Josefʊ ir 'mɔɔ a bie nɩ a wʊ ma a tãsɔɔ bãɩn jo chiin be a Ijipitɩ. ");
INSERT INTO biv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Be lɛ wʊ tɩ jãnɛ tɩ tãn a sɔ̃ɔ 'lɔ a Nãa Hɛrɔd na wa kpi. A yelsɩ anyã ɩ naa lɛ ka a na ɩ yelmãɛ ɩka a lɛ a sɩ Soro 'yɛ'yɛrɛ na dɔ̃ɔ 'yɛr ɩka, “Ijipitɩ pɔ lɛ ɩn bʊɔl a n bie yin.” ");
INSERT INTO biv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","A Nãa Hɛrɔd na wa bɔ̃ɔn ɩka a yɛ̃ dẽme banyã na yɩ a sapar bɛl wʊ naa a suur kpɛ wʊ a wʊ 'yɛr kʊ a wʊ sojasɩ ɩka ba chen tɩ kʊ dabile jaa na be a Bɛtɩlɛhɛm na ta yuom ayi bɩɩ na ba ta sɛrɛ ɛ, yi a sɔ̃ɔ 'lɔ jaa wʊn sʊʊr bɔ̃ɔn yi a yɛ̃ bɔ̃ɔnbɔ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","A lɛ jaa a Nãaŋmɩn 'yɛ'yɛrɛ Jeremiya na dɔ̃ɔ 'yɛr ɩ yelmãɛ, ");
INSERT INTO biv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ba wõn kɔkɔr be a Wurama tẽe pɔ, kõyiel nɩ wuur kpãɛn, Wurachɛl lɛ kõnõ a wʊ bibiir 'yɔ̃ɔ. Ba kpi na, waa lɛ bʊɔrɔ 'maalfʊ ɛ bojũu baa lɛ chɛnɛ go ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hɛrɔd na wa kpi, Nãaŋmɩn malaka wan Josefʊ sɛ̃ be a Ijipitɩ jãn pɔ wa 'yɛr, ");
INSERT INTO biv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Vaa ir 'mɔɔ a bie nɩ a wʊ ma na fʊ chiin a Isɩral wɛr pɔ, a bala na dɔ̃ɔ bʊɔrɔ a bie kʊfʊ kpi naa.” ");
INSERT INTO biv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josefʊ vaan ir 'mɔɔ a bie nɩ a wʊ ma chiin a Isɩral wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tɩchɛ wʊn wa wõ ɩka Archelaus lɛ di a nãa a Judiya a wʊ sãa kũu puor, wʊ joro na dãbãɛ ɩka wʊ lɛ chen a be. Ka a Nãaŋmɩn wa kpãa wʊ a jãn pɔ ɩka wʊ chen be Galilee paal pɔ. ");
INSERT INTO biv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Be lɛ wʊ chen Najaretɩ tɩ kpɩɛrɛ a be, ka a lɛ Nãaŋmɩn 'yɛ'yɛrɛ na dɔ̃ɔ 'yɛr ɩ yelmãɛ, “Ban bʊɔl wʊ naa Najaretɩ nɩrɛ.” ");
INSERT INTO biv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sɔ̃ɔ kɔ̃ɔ lɛ a Jɔɔn kɔ̃suor mʊɔlɔ a Judiya mɔgɔ̃ɔ pɔ ");
INSERT INTO biv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","'yɛrɛ, “Yɩ lɩɛb a yɩ befʊ, a Nãaŋmɩn nãalʊ̃ʊ ta na.” ");
INSERT INTO biv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jɔɔn nyã 'yɛr lɛ a Nãaŋmɩn 'yɛ'yɛrɛ Isaiya dɔ̃ɔ 'yɛr a wʊ 'yɛr, “Kɔkɔr kɔ̃ɔ lɛ gɔ̃nɔ̃ 'yɛrɛ be a mɔgɔ̃ɔ pɔ, chɔɔr a sɩ Soro sɔr, maal a wʊ sɔbie ka a tor.” ");
INSERT INTO biv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nyɔɔma kɔɔlʊ fuu lɛ Jɔɔn ma su tɩ de gãn a lũn a sɩɛ. Soor nɩ sɩkãa lɛ ɩ a wʊ bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nɩyɔɔ yin a Jerusalɛm nɩ Judiya chiine a wʊ sɛ̃ nɩ a bala na yi a Jordan man koor. ");
INSERT INTO biv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ba woro naa a ba yeldɛbɛ tɩ wʊ suoro ba a Nãaŋmɩn kʊ̃ɔ be a Jordan man pɔ. ");
INSERT INTO biv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jɔɔn na wa nyɛ a Faraseemɩne nɩ a Saduseemɩne na waara a Nãaŋmɩn kʊ̃ɔ sofʊ jie, ka wʊ 'yɛr kʊ ba, “Yɩn waa bibiir, an n 'yɛr kʊ yɩ ɩka yɩ jo yi a Nãaŋmɩn suur na waara mɔ̃? ");
INSERT INTO biv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yɩ vɛ̃ ka a yɩ lɛ befʊ wiil ɩka yɩ lɩɛb a yɩ tɩɛr. ");
INSERT INTO biv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yɩ ta chɛnɛ ŋmara jir 'yɔ̃ɔn yɩ mãɛ ɩka, ‘Abraham lɛ ɩ a sɩ sãa ɛ.’ N 'yɛrɛ na kʊrɔ yɩ ɩka Nãaŋmɩn na tʊ̃ɔn maal a kʊsɩbɛ anyãna ka a lɩɛb ɩ a Abraham bibiir. ");
INSERT INTO biv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A 'lar dɔɔl a tɩɛ pĩlem gu a ŋmaafʊ, tɩɛ jaa ba wa wɔ̃nɔ̃ wɔ̃ sʊ̃n ɛ ban ŋmaa wʊn lɔb 'yɔ̃ɔ bũu pɔ. ");
INSERT INTO biv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Maa 'lɔ suoro yɩn nɩ kʊ̃ɔ ka yɩ na lɩɛb a yɩ befʊ, tɩchɛ nɩrɛ ãsʊɔ na tara kpɛ̃ɔ gar ma ben a n puor waara, a wʊ nafɔɔr gba ba sɛɛ ɩka n tuo ɛ. 'Lɔ lɛ na de a Nãaŋmɩn Sɩɛ nɩ bũu son yɩ. ");
INSERT INTO biv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A ŋmayɩɛlaa ben a wʊ nũu pɔ, ka wʊ na yɩɛl a mʊ̃ɩ a vafʊ jie na wʊ kpaar a bie 'yɔ̃ɔ a boor pɔ tɩ chʊm a sɔ̃sɔɔr nɩ bũu 'lɔ na ba tara kpĩinfʊ bar.” ");
INSERT INTO biv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesu yin a be a Galilee chen a Jordan man pɔ, ka a Jɔɔn na tɩ so wʊ a kʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jɔɔn ba ta bʊɔrɔ ɩka wʊ so wʊ ɛ, na wʊ 'yɛr fʊ̃ʊ lɛ sɛɛ ɩka fʊ so ma tɩchɛ ka fʊ lɛ wa a n sɛ̃ go? ");
INSERT INTO biv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tɩchɛ ka Yesu 'yɛr kʊ wʊ, “Vɛ̃ ka a ɩ a lɛ a pʊ̃pãanyã, a vɩɛl na ɩka sɩ ɩ a lɛ jaa Nãaŋmɩn na bʊɔrɔ.” Ka Jɔɔn sɔɔ lɛ a Yesu na 'yɛr. ");
INSERT INTO biv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","A lɛ wʊn wa so a Yesu a kʊ̃ɔ baar, a wʊ yi a kʊ̃ɔ pɔ, a sɔ̃ɔ 'lɔ̃nɔ̃ lɛ wʊ nyɛ a saaju na yuo a wʊ nyɛ a Nãaŋmɩn Sɩɛ na kaara ŋmam kaar suu wa mar a Yesu ju. ");
INSERT INTO biv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tɩ a kɔkɔr yɩ a Nãaŋmɩn sɛ̃ a saaju 'yɛrɛ, “A anyãna lɛ ɩ a n binʊ̃nãa ka a n 'yɔ̃ɔ ma 'maa nɩ wʊ.” ");
INSERT INTO biv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","A Nãaŋmɩn Sɩɛ tara na Yesu kpɛ̃n a mɔgɔ̃ɔ pɔ, ka a tɩɩ tɩ bɛɛr wʊ kaa. ");
INSERT INTO biv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Waa di bon jaa ber lɩjaayi nɩ tãsɔɔ gbulo lɩjaayi ɛ, ka kɔ̃ kpɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","A 'yɛr kʊ wʊ, “Ala ɩ fʊ̃ʊ lɛ a Nãaŋmɩn Bie, 'yɛr kʊ a kʊsɩbɛ a nyãna ka a lɩɛb bʊ̃diir.” ");
INSERT INTO biv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tɩchɛ ka Yesu 'yɛr kʊ wʊ, “A sɛb a Nãaŋmɩn gãn pɔ ɩka, bʊ̃diir tɛɛ kʊ̃ tʊ̃ɔ kʊ nɩrɛ nyɛvʊr ɛ, tɩchɛ 'yɛrbir jaa na yi Nãaŋmɩn nɛɛ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","A bɛɛr kaa sʊɔ lɛ tara wʊn don a Jerusalɛm, tɩ wiil wʊ a puorfʊ jie na do gar a jaa, ");
INSERT INTO biv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tɩ 'yɛr kʊ wʊ, “Ala ɩ fʊ̃ʊ lɛ a Nãaŋmɩn Bie, ɔɔ lo a tẽe. A sɛb ɩka, wʊn vɛ̃n ka a wʊ malakasɩ gu fʊ na ba nyɔɔ fʊ nɩ a ba nuur ka fu gbɛr kʊ ŋme kʊsɩr ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ka a Yesu mɩ 'yɛr kʊ wʊ, “A mɩ sɛb a Nãaŋmɩn gãn pɔ ɩka, ta bɛɛr a yɩ Nãaŋmɩn kaa ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","A tɩɩ lɛ tara wʊn don tɔ̃ɔ ju tɩ wiil wʊ a nãa di jiir a jaa na be ka a wɛr pɔ, na a bʊ̃vɩɛlsɩ lɛ an be. ");
INSERT INTO biv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ka wʊ 'yɛr kʊ wʊ, “Ɩn kʊ fʊ naa anyãna a jaa, ala ɩ fʊ gbur dumo puor ma.” ");
INSERT INTO biv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu 'yɛr kʊ wʊ, “Fʊ̃ʊ Satan nyã tɔɔ yi be. A sɛb a Nãaŋmɩn gãn pɔ ɩka, a sɩ Soro Nãaŋmɩn tɛɛ lɛ a sɛɛ ɩka yɩ puoro na yɩ tʊ̃nɔ̃ kʊrɔ a 'lɔ tɛɛ.” ");
INSERT INTO biv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","A tɩɩ bar wʊn tɩ chen, tɩchɛ ka a Nãaŋmɩn malakasɩ wa sʊ̃ʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu na wa wõ ɩka ba nyɔɔn Jɔɔn na ba pɔɔ, wʊ chen Galilee. ");
INSERT INTO biv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wʊ yin Najaretɩ na wʊ tɩ kpɩɛrɛ be a Kapenahum a man nɛɛ be Jebulun nɩ Naftalɩ wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ka a lɛ jaa a Nãaŋmɩn 'yɛ'yɛrɛ Isaiya na dɔ̃ɔ 'yɛr ɩ yelmãɛ, ");
INSERT INTO biv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Jebulun wɛr, Naftalɩ wɛr, a man sɔr a Jordan man gɔ̃ɔn. Galilee be a nɩyor na kpɩɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","A nɩbɛ na dɔ̃ɔ be libe pɔ nyɛn chãa, nɩbɛ bala na ba dɔ̃ɔ tara nyɛvʊr Nãaŋmɩn pɔ ɛ, nyɛn Nãaŋmɩn chãa kpɛ̃ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A sɔ̃ɔ 'lɔ̃nɔ̃ Yesu piel na wʊ mʊɔlɔ 'yɛrɛ, “Yɩ lɩɛb a yɩ befʊ a saaju nãalʊ̃ʊ ta na.” ");
INSERT INTO biv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu na wa de a Galilee man gogoro lana, wʊ nyɛn yɛɛr ayi Simon ban bʊɔlɔ Pita nɩ a wʊ yɛbɛ Andiru na lɔɔrɔ lɔyaar 'yɔ̃ɔnɔ̃ a kʊ̃ɔ pɔ. Ba dɔ̃ɔ ɩ jãnyɔɔrbɔ. ");
INSERT INTO biv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ka wʊ 'yɛr kʊ ba, “Yɩ turo ma, n vɛ̃ naa ka yɩ nyɔɔrɔ nɩbɛ 'yɔ̃ɔnɔ̃ a Nãaŋmɩn nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ka ba tɔ̃ɔ tãɛ a lɔyaarsɩ bar tɩ na ba turo wʊ. ");
INSERT INTO biv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Wʊn lɛ yɩ a be chiine, wʊ lɛ nyɛn yɛɛr ayi, Jemesɩ na ɩ Jebedee bidaba naa a wʊ yɛbɛ Jɔɔn ka ba be a gboro pɔ nɩ a ba sãa Jebedee, maala a ba lɔyaarsɩ ka wʊ bʊɔl ba. ");
INSERT INTO biv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","A ba tɔ̃ɔ tɩɛ a gboro bar nɩ a ba sãa tɩ turo wʊ. ");
INSERT INTO biv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu yɔn a Galilee wile ba a lɔ̃ɔfʊ jiir tɩ mʊɔlɔ a Nãaŋmɩn nãalʊ̃ʊ 'yɛr nʊ̃ɔ tɩ sãana nɩrɛ jaa baal. ");
INSERT INTO biv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ka a wʊ yele yaar a Siriya ka ba tara a baalsɩ ba jaa waan a wʊ sɛ̃, bala a baalsɩ nɩ ãgãn ɔbɔ na nyɔɔ, bala na tara a sɩdɛbɛ, banyã baal tãanaa na nyɔɔ nɩ gbɛrfʊ jaa bʊrɔ, ka wʊ sãa a ba baalsɩ. ");
INSERT INTO biv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nɩyɔɔ yin Galilee, nɩ Dekapolisɩ, nɩ Jerusalɛm, nɩ Judiya nɩ a Jordan man gɔ̃ɔn wa turo wʊ. ");
INSERT INTO biv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu na wa nyɛ a nɩyɔɔ, wʊ don tɔ̃ɔ ju, wʊn wa tɩ jɛ̃ baar ka a wʊ poturbo wa a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A wʊ piel wile ba 'yɛrɛ, ");
INSERT INTO biv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Pʊpɛl lɛ kʊ a yɩn banyãna na ba tara bon jaa ɛ, tɩ bʊɔrɔ lɛ a Nãaŋmɩn na bʊɔrɔ. Yɩn lɛ so a saaju nãalʊ̃ʊ. ");
INSERT INTO biv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Pʊpɛl lɛ kʊ a yɩn na kõnõ, Nãaŋmɩn na 'maan a yɩ nyãa. ");
INSERT INTO biv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Pʊpɛl lɛ kʊ a yɩn na siir a yɩ mãɛ. Nãaŋmɩn na kʊ ban bon jaa na be a wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Pʊpɛl lɛ kʊ banyã kɔ̃ nɩ kɔ̃nyũur na kpɛ yeltorsɩ jũu, ban tɩɩ naa. ");
INSERT INTO biv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Pʊpɛl lɛ kʊ yɩn banyã na kaara nɩrɛ nɩbaal, Nãaŋmɩn mɩ na kãan a yɩ nɩbaal. ");
INSERT INTO biv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Pʊpɛl lɛ kʊ banyã na nʊ̃ Nãaŋmɩn sɩrɛ, nɩ a ba nyãa wʊ jaa, bala lɛ na nyɛ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Pʊpɛl lɛ kʊ banyã na bʊɔrɔ nyã'maar, ban bʊɔlɔ ban Nãaŋmɩn bibiir. ");
INSERT INTO biv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pʊpɛl lɛ kʊ yɩn bala nɩbɛ na ge yeltorsɩ jũu, yɩn lɛ so a saaju nãalʊ̃ʊ. ");
INSERT INTO biv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Pʊpɛl lɛ kʊ yɩn a sɔ̃ɔ 'lɔ nɩbɛ na tʊrɔ yɩ, na ba gere yɩ, tɩ ŋmara jirsɩ 'yɛrɛ 'yɛr dɛbɛ 'yɔ̃ɔnɔ̃ yɩ, a maa jũu. ");
INSERT INTO biv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yɩ tara pʊpɛl, a yɩ sãyar bɛrma naa a saaju, lɛ nɩ wʊ ju lɛ ba dɔ̃ɔ ge a Nãaŋmɩn 'yɛ'yɛrbɛ na dɔ̃ɔ be be. ");
INSERT INTO biv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yɩ kaara fɩka nyaar a wɛr pɔ, tɩchɛ a nyaar nʊ̃ɔ wa baar, ŋmɩnɛ ban lɛ ɩ wʊ ka wʊ lɛ nʊ̃mɔ̃ go? A maa lɛ tara tɔ̃nɔ̃ kʊ bon jaa ɛ, ba ma kpaar bar ka nɩbɛ nɛɛrɛ nɩ gbɛɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Yɩ kaara fɩka chãa a wɛr pɔ. Yir ban mɛ tɔ̃ɔ ju kʊ̃ tʊ̃ɔ sɔɔl ɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nɩrɛ maa chʊm fãtɩn de pɩɛ pɔɔ ɛ tɩchɛ wʊ ma bin a kuorgbe ju kʊ chaar yɔ̃ɔ nɩrɛ jaa a yir pɔ. ");
INSERT INTO biv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lɛ nɩ wʊ ju mɩ lɛ, yɩn lɛ ɩ chãa a yɩ taaba sɛ̃, ka ba na nyɛ a yɩ tʊ̃vɩɛlsɩ na ba pɛɛ a yɩ Sãa Nãaŋmɩn na be a saaju. ");
INSERT INTO biv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Yɩ ta tɩɛr ɩka n wan ɩka n wa sɔ̃ɔ a nɛbinãa bɩɩ, a Nãaŋmɩn 'yɛ'yɛrbɛ wiilfʊ bar ɛ, n ba wa ɩka n wa sɔ̃ɔ yaa bar ɛ, n wan ɩka n vɛ̃ ka a ɩ yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, ɩka a saaju nɩ a wɛr ba wa baar ɛ, a sɛbir bile bʊ̃'yen gba kʊ̃ ir a nɛbinãa pɔ ɛ, tɩ ta a lɛ yele jaa na ɩ yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","A lɛ jũu, nɩrɛ jaa wa sɔ̃ɔ a nɛbinsɩ anyãna ãsʊɔ jaa tɩ wiil a wʊ taaba ka ba mɩ maala a lɛ, na ɩn a bile a saaju nãalʊ̃ʊ pɔ, tɩchɛ nyã jaa na maala tɩ wile bamɩne ka ba mɩ maala a lɛ, na ɩn kpɛ̃ɛ a saaju nãalʊ̃ʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","N 'yɛrɛ na kʊrɔ yɩ, a yɩ yeltorsɩ ba wa tɩ gar a nɛɛ wiwiilbe nɩ a Faraseemɩne ɛ, yɩn ba be na wa kpɛ a saaju nãalʊ̃ʊ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Yɩ wõn ban dɔ̃ɔ 'yɛr kʊ a sɩ sãakpãmɩne, ‘Ta kʊ nɩrɛ ɛ,’ nɩrɛ nyã na kʊ nɩrɛ na nyɛn 'yɛr tɔɔrfʊ. ");
INSERT INTO biv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tɩchɛ n 'yɛrɛ na kʊrɔ yɩ, ala ɩ fʊ nyɛn na yɛbɛ suur, wʊn nyɛn 'yɛr tɔɔrfʊ, ala ɩ fʊ tʊ̃n yɛbɛ na nyɛn 'yɛr tɔɔrfʊ a nɩbɛrɛ niem, fʊ̃ʊ wa 'yɛr nɩrɛ ɩka, jɔl nyã, na kpɛ̃n a bũu dagel 'lɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ala wa ɩ fʊ waara nɩ naa a fʊ kʊfʊ, a Nãaŋmɩn bɔɔr lofʊ jie na fʊ wa tɩɛr tɔ ɩka fʊ̃ʊ nɩ a yɛbɛ tara na 'yɛr, ");
INSERT INTO biv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bar a fʊ bon a Nãaŋmɩn bɔɔr lofʊ jie tɩ lɩɛb chen tɩ 'maal a fʊ yɛbɛ tɩ pãa wa de a fʊ bon kʊ a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“An ɩ yɩn nɩ a yɩ sãn sʊɔ lɛ chiine a 'yɛr tɔɔrfʊ jie, yɩ mʊlɔ wʊ a sɔr pɔ, ka lɛ ba lɛ ɛ, wʊn de yɩn 'yɔ̃ɔ a 'yɛr tɔɔrɔ nũu pɔ, ka wʊ de yɩ kʊ a nɩpɔɔraa ka wʊ mɩ pɔɔ yɩ bar. ");
INSERT INTO biv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ala be a lɛ, faa be na wa yi ka fʊ̃ʊ ba wa yab a sãn baar ɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Yɩ dɔ̃ɔ wõ ban 'yɛr ɩka ta gãn nɩrɛ pɔɔ bɩɩ sɩrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tɩchɛ n 'yɛrɛ na kʊrɔ yɩ, nɩrɛ nyã jaa na wa kaa pɔɔ jaa tãɩɩ tɩ bʊɔrɔ na gãn wʊ, a nɩrɛ 'lɔ gãn wʊ naa a wʊ tɩɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ala ɩ a fʊ nũsʊ̃ɔ nɩbir vɛ̃ naa ka fʊ ɩ yelbier, 'loo wʊ bar, a fʊ ãgãn lõboor ãsʊɔ na ba be be ɛ, sa naa a fʊ ãgãn wʊ jaa na kpɛ bũu pɔ. ");
INSERT INTO biv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ala ɩ a fʊ nũsʊ̃ɔ nũu mɩ lɛ vɛ̃ ka fʊ ɩ yelbier ɛ, ŋmaa wʊ 'lɔ bar, a fʊ ãgãn lõboor ãsʊɔ na ba be be ɛ, sa naa a fʊ ãgãn wʊ jaa na kpɛ bũu pɔ. ");
INSERT INTO biv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“A mɩ dɔ̃ɔ 'yɛr ɩka, nɩrɛ nyã jaa na tɔr a wʊ pɔɔ bar, wʊ kʊ wʊ a pɔɔ bar gãn. ");
INSERT INTO biv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tɩchɛ n 'yɛrɛ na kʊrɔ yɩ ɩka, nɩrɛ nyã jaa na tɔr a wʊ pɔɔ bar, ala baa ɩ wʊ sɛ̃nɛ naa ɛ, vɛ̃n kʊ ɩ sɛ̃sɛ̃nɛ, nɩrɛ nyã jaa na kul a pɔɔ 'lɔ mɩ ɩn sɛ̃sɛ̃nɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Yɩ mɩ lɛ wõn ban dɔ̃ɔ 'yɛr kʊ a sɩ sãakpãmɩne, ‘Yɩ taa sɔ̃ɔnɔ̃ a nɛɛ 'lɔ yɩn põl 'yɔ̃ɔ a yɩ mãɛ ɛ, tɩchɛ yɩ tara a lɛ yɩn põl 'yɔ̃ɔ a sɩ Soro.’ ");
INSERT INTO biv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tɩchɛ n 'yɛrɛ na kʊrɔ yɩ, yɩ ta pɔ jaa ɛ, yɩ ta pɔn a saaju gba ɛ, bojũu Nãaŋmɩn jaa jie lɛ, ");
INSERT INTO biv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","bɩɩ a wɛr ju, a wʊ gbɛr dɔɔlfʊ jie lɛ bɩɩ Jerusalɛm ɛ, bojũu be lɛ a Nãkpɛ̃ɛ kpɩɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ta pɔn a fʊ ju ɛ, fʊ kʊ̃ tʊ̃ɔ vɛ̃ ka a fʊ jukɔɔl ãsʊɔ pɛl bɩɩ sɔb ɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yɩ vɛ̃ ka a yɩ ɔ̃ɔ ɩ ɔ̃ɔ ka a yɩ kai ɩ kai, bon 'lɔ na gar a nɩtɔ̃ yin a dɛɛr sʊɔ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Yɩ dɔ̃ɔ wõ ban 'yɛr ɩka nɩbir na yãan nɩbir sãn, ka nyɩm mɩ yaa nyɩm sãn. ");
INSERT INTO biv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tɩchɛ maa 'yɛrɛ na kʊrɔ yɩ, ta pii a nɩrɛ 'lɔ na sɔ̃ɔ fʊ sɔr ɛ. Tɩchɛ nɩrɛ wa 'ma fʊ a tʊkpal nyã pɔ, lɩɛb a nyã lɛ 'yɔ̃ɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ka nɩrɛ wa bʊɔrɔ ɩka wʊ sɛb fʊ nãa yir tɩ de a fʊ fuu, kʊ wʊ a 'lɔ fʊn su, na fʊ yaa a pʊɔm bon pʊɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nɩkpɛ̃ɛ wa fɩr fʊ ɩka fʊ de a wʊ tuor tuo chiin niem bãlãa, tuo chiin tɛɛr jaa. ");
INSERT INTO biv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kʊ nɩrɛ jaa na sʊɔr fʊ, ta mɔ̃ɔ nɩrɛ nyã mɩ na bʊɔrɔ ɩka wʊ pɛ̃ɛ a fʊ bon ɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Yɩ wõn ban dɔ̃ɔ 'yɛr ɩka, yɩ nʊ̃ a yɩ tɔ sʊɔ tɩ 'laar a yɩ dɔ̃sʊɔ. ");
INSERT INTO biv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tɩchɛ maa 'lɔ 'yɛrɛ na kʊrɔ yɩ, nʊ̃ a yɩ dɔ̃dẽme tɩ sʊɔrɔ Nãaŋmɩn kʊrɔ a bala na gere yɩ, ");
INSERT INTO biv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ka yɩ na ɩ Nãaŋmɩn bibiir bojũu 'lɔ lɛ ma vɛ̃ ka a mɔ̃tɔ̃ɔ pur 'yɔ̃ɔ a nɩdɛbɛ nɩ a nɩsʊ̃n tɩ na wʊ ma vɛ̃ ka saa wa 'yɔ̃ɔ a bala na tor nɩ a bala na ba tor ɛ. ");
INSERT INTO biv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yɩn nʊ̃ a bala na nʊ̃ yɩ tɛɛ, bo sãyar lɛ yɩn nyɛ? A lõpodierbe maa mɩ ɩ a lɛ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yɩn ma puoro a bala tɛɛ na ɩ a yɩ nɩbɛ, bo tɔ̃nɔ̃ lɛ be be? A bala na ba ɩ a Juu nɩbɛ ɛ, maa mɩ ɩ a lɛ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yɩ ɩ nɩmɩn a lɛ a yɩ sãa Nãaŋmɩn na be a saaju kaar. ");
INSERT INTO biv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Yɩ bɔ̃ɔnɔ̃ sʊ̃, na yɩ taa mʊɔlɔ a yɩ yeltorsɩ a nɩbɛ niem ɛ, ka ba na bɔ̃ɔn ɛ, yɩn wa ɩrɛ a lɛ, yɩ kʊ̃ nyɛ sãyar a yɩ sãa Nãaŋmɩn na be a saaju sɛ̃ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“A lɛ jũu, fʊ̃ʊ wa de bon kʊ nɩrɛ na ba tara ɛ, ta vɛ̃ ka nɩbɛ bɔ̃ɔn ɛ, fɩka lɛ a nɛɛr ayi dẽme na ma maala a lɔ̃ɔfʊ yie nɩ a tẽn pɔ ɛ, ka nɩbɛ na pɛɛ ba ɛ. Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, bala nyɛn a ba sãyar baar. ");
INSERT INTO biv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A lɛ jũu, fʊ̃ʊ wa de bon kʊ nɩrɛ na ba tara ɛ, ta vɛ̃ ka a gubaa nũu bɔ̃ɔn a bon 'lɔ a nũsʊ̃ɔ na maala ɛ, ");
INSERT INTO biv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ka nɩrɛ ta bɔ̃ɔn a bon fʊn maala ɛ, tɩchɛ a fʊ Sãa Nãaŋmɩn na nyɛrɛ yelsɔɔlsɩ na kʊ fʊn a sãyar. ");
INSERT INTO biv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Yɩn maa wa sʊɔrɔ a Nãaŋmɩn, yɩ ta ma kaara a nɛɛr ayi dẽme kaar ɛ, ba ma nʊ̃n ɩka ba puoro a lɔ̃ɔfʊ yie pɔ, nɩ a tẽbɛrɛ pɔ, nɩ a sɔchara pɔ, ka nɩbɛ na nyɛ ba. Yelmãɛ jaa lɛ n 'yɛrɛ kʊrɔ yɩ, ɩka ba nyɛn a ba sãyar baar. ");
INSERT INTO biv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tɩchɛ fʊ̃ʊ maa wa sʊɔrɔ a Sãa Nãaŋmɩn nyã sɩn ba nyɛrɛ ɛ, kpɛ a fʊ die pɔ, tɩ pɔɔ a pãn, tɩ sʊɔr a Sãa Nãaŋmɩn na nyɛrɛ bon jaa, na yab fʊn a sãyar. ");
INSERT INTO biv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yɩn maa wa sʊɔrɔ a Nãaŋmɩn, yɩ ta ma 'yɛrɛ 'yɛrbie ala na ba tara tɔ̃nɔ̃ ɛ, lɛ lɛ a bala na ba bɔ̃ɔ Nãaŋmɩn ma maala, ba tɩɛr ɩka Nãaŋmɩn na wõn a ba sʊɔrfʊ a ba 'yɛrbiyɔɔ jũu. ");
INSERT INTO biv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yɩ ta kaara a ba kaar ɛ, a yɩ Sãa den nie bɔ̃ɔn bon 'lɔ yɩn bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Nɩtɔ̃ lɛ yɩn ma sʊɔr a Nãaŋmɩn. Sɩ Sãa na be a saaju. Sɩ kʊ naa a fʊ yuor tɩɩr. ");
INSERT INTO biv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A fʊ nãalʊ̃ʊ wʊ wa. A fʊ bɔfʊ wʊ ɩ a wɛr pɔ, nɩtãa lɛ a fʊ bɔfʊ na ɩrɛ be a saaju. ");
INSERT INTO biv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kʊ sɩ a dɩna bʊ̃diir ka a sɛɛn sɩ. ");
INSERT INTO biv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Vɛ̃ a sɩ yeldɛbɛ bar, nɩtãa lɛ sɩn ma vɛ̃ kʊ a sɩ taaba yeldɛbɛ bar ba. ");
INSERT INTO biv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ta sɔɔ ka bɛɛr kaa nyɔɔ sɩ ɛ, faa sɩ yin a dɛɛr sʊɔ nũu pɔ. ");
INSERT INTO biv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Yɩn wa vɛ̃ a yɩ taaba yeldɛbɛ bar ba, a yɩ Sãa Nãaŋmɩn na be a saaju mɩ na vɛ̃n bar yɩ. ");
INSERT INTO biv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yɩn ba wa vɛ̃ a yɩ taaba yeldɛbɛ kʊ ba ɛ, a yɩ Sãa Nãaŋmɩn mɩ kʊ̃ vɛ̃ a yɩ yeldɛbɛ kʊ yɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Yɩn wa gal kɔ̃, yɩ ta sɔ̃ a yɩ nin a nɛɛr ayi dẽme kaar ɛ, ba ma sɔ̃n a ba nin ka a ba taaba nyɛ bɔ̃ɔ ka ba gal kɔ̃. Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka ba nyɛn a ba sãyar baar. ");
INSERT INTO biv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yɩn wa gal kɔ̃, yɩ lor a yɩ nie maal a yɩ mãɛ, ");
INSERT INTO biv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ka nɩbɛ ta bɔ̃ɔn yɩn gal kɔ̃ ɛ, tɩchɛ a yɩ Sãa Nãaŋmɩn nyã sɩn ba nyɛrɛ ɛ, a Sãa Nãaŋmɩn nyã na nyɛrɛ yelsɔɔlsɩ na yab yɩn a sãyar. ");
INSERT INTO biv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Yɩ ta bine a yɩ nãbonsɩ ka a wɛr ju be kpolo, nɩ sɔrɔ, nɩ na sɔ̃ɔ bar ɛ, nɩ be nãnyisɩ nɩ naa kpɛ ju ɛ. ");
INSERT INTO biv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tɩchɛ yɩ bʊɔrɔ nãbonsɩ bine a saaju, be lɛ a kpolo nɩ sɔrɔ na kʊ̃ tʊ̃ɔ sɔ̃ɔ bar ɛ, nɩ be a nãnyisɩ na kʊ̃ tʊ̃ɔ kpɛ ju ɛ. ");
INSERT INTO biv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","A jie 'lɔ a fʊ nãbonsɩ na be, be lɛ a fʊ tɩɛr mɩ ma be. ");
INSERT INTO biv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“A fʊ nɩbir lɛ ɩ a fʊ ãgãn chãa. A fʊ nɩbir wa ɩ a fʊ ãgãn wʊ jaa ma sɛɛn na chãa. ");
INSERT INTO biv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tɩchɛ a fʊ nɩbir ba wa ɩ ɛ, a fʊ ãgãn wʊ jaa ma ɩn libe. Ala ɩ a chãa 'lɔ na be a fʊ pɔ ɩn libe, nyɛ lɛ a libe na jã. ");
INSERT INTO biv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nɩrɛ kʊ̃ tʊ̃ɔ tʊ̃ nɩbɛrɛ ayi tʊ̃mɔ̃ ɛ. Wʊn nʊ̃n ãsʊɔ, tɩ 'laar ãsʊɔ, bɩɩ wõnõ a ãsʊɔ toor, tɩ ba wõnõ ãsʊɔ toor ɛ. Yɩ kʊ̃ tʊ̃ɔ tʊ̃ kʊ Nãaŋmɩn nɩ libie ɛ. ");
INSERT INTO biv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“A lɛ jũu, n 'yɛrɛ na kʊrɔ yɩ ɩka, yɩ ta vɛ̃ ka a yɩ nyɛvʊr yele wõnõ yɩ ka yɩ 'yɛrɛ ɩka, bo lɛ yɩn di, bɩɩ bo lɛ yɩn nyũ ɛ. Bɩɩ waala ɩka, bo lɛ yɩn su pɔɔ a ãgãn ɛ. A nyɛvʊr ba fɛr gar a bʊ̃diir ɛ, ka a ãgãn mɩ fɛr gar a bʊ̃sursɩ ɛ? ");
INSERT INTO biv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yɩ kaa a lubil na be a saaju. Ba maa bʊr ɛ, bɩɩ ŋma ɛ, bɩɩ tara boor ma bin ɛ, tɩchɛ Nãaŋmɩn lɛ guolo ba. Yaa fɛr gar a lubil bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A yɩ buor sʊɔ lɛ na waal na wʊ tʊ̃ɔ de bɩbir bʊ̃'yen pʊɔ a wʊ nyɛvʊr pɔ? ");
INSERT INTO biv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ka bo lɛ vɛ̃ ka yɩ tɩɛrɛ a bʊ̃sursɩ 'yɔ̃ɔ? Yɩ kaa nyɛ a mɔpuul lɛ an ma nʊ̃ɔ, ba maa tʊ̃ ɛ, bɩɩ wob fuu su ɛ, ");
INSERT INTO biv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","a Nãa Solomon gba nɩ a wʊ tɩɩr wʊ jaa ba dɔ̃ɔ su fuu ka wʊ vɩɛlɛ gar a mɔpuul a nyãna ɛ. ");
INSERT INTO biv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ala ɩ Nãaŋmɩn maal a mɔpuul ka a vɩɛlɛ, tɩchɛ a maa kor ɛ. Nɩbɛ ma chʊm ka a di. A Nãaŋmɩn na ma maal a mɔpuul a nɩtɔ̃, wʊ kaara a yɩn na ɩ a wʊ nɩbɛ gar a mɔpuul anyãna. A yɩ sɔɔfʊ lɛ ba jã bon ɛ. ");
INSERT INTO biv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","A lɛ jũu, yɩ ta waala 'yɛrɛ ɩka, bo lɛ yɩn di bɩɩ nyũ ɛ, bɩɩ bo lɛ yɩn su ɛ? ");
INSERT INTO biv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","A bala na ba puor ɛ, lɛ de a ba tɩɛr 'yɔ̃ɔ a anyãna pɔ, a yɩ Sãa bɔ̃ɔ naa ɩka yɩ bʊɔrɔ naa a bonsɩ anyãna a jaa. ");
INSERT INTO biv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yɩ de nie bɔ a Nãaŋmɩn nãalʊ̃ʊ nɩ a wʊ yeltorsɩ, tɩchɛ a anyãna a jaa, wʊn den pʊɔ yɩ. ");
INSERT INTO biv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","A lɛ jũu, yɩ ta waala a bio 'yɔ̃ɔ ɛ, bio lɛ na waala a wʊ mãɛ 'yɔ̃ɔ. Bɩbir jaa tara na a wʊ yelwõnsɩ. ");
INSERT INTO biv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Yɩ ta tɔɔr nɩrɛ jaa 'yɛr ɛ, ka Nãaŋmɩn mɩ wa tɔɔr a yɩ 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nãaŋmɩn na tɔɔr a yɩ 'yɛr nɩtãa lɛ yɩn tɔɔr a yɩ tɔ sʊɔ 'yɛr. Lɛ fʊn man tɩr, lɛ mɩ lɛ ban man kʊ fʊ. ");
INSERT INTO biv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ŋmɩnɛ a fʊ nyɛ dabile na be a fʊ yɛbɛ nɩbir pɔ tɩ ba chɛlɛ a dakpɛ̃ɛ na be a fʊ̃ʊ nɩbir pɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bɩɩ ŋmɩnɛ fʊn ɩ 'yɛr kʊ a fʊ yɛbɛ vɛ̃ ka ir a dabile na be a fʊ nɩbir pɔ bar tɩ ba chɛlɛ a dakpɛ̃ɛ na be a fʊ nɩbir pɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yɩn nɛɛr ayi dẽme, de nie ir a dakpɛ̃ɛ a fʊ nɩbir pɔ bar na fʊ pãa nyɛrɛ tʊ̃ɔ ir a dabile a fʊ yɛbɛ nɩbir pɔ mɩ bar. ");
INSERT INTO biv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ta de bon na ɩ chɛchɛ 'yɔ̃ɔ baar ɛ, bɩɩ lɔb a fʊ bʊ̃vɩɛlsɩ 'yɔ̃ɔ dor ɛ, ban nɛb na nɩ gbɛɛ tɩ lɩɛb nyɔɔ fʊ. ");
INSERT INTO biv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Yɩ sʊɔr, Nãaŋmɩn na kʊ yɩ naa. Yɩ yɔbɔ, yɩn nyɛ naa, yɩ kpoor a pãn, wʊn yuo naa. ");
INSERT INTO biv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nɩrɛ 'lɔ na sʊɔr na nyɛ naa, ka a 'lɔ mɩ na yɔbɔ nyɛ, ka a pãn mɩ yuo kʊ a nɩrɛ 'lɔ na kpoor. ");
INSERT INTO biv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“A yɩn na ɩ a sãamɩne, buor sʊɔ bie lɛ na sʊɔr a wʊ sãa bʊ̃diir, ka wʊ de kʊsɩr kʊ wʊ? ");
INSERT INTO biv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bɩɩ ka a bie sʊɔr jãm, ka wʊ de waa kʊ wʊ? ");
INSERT INTO biv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ala ɩ a yɩn na ɩ a yelbe-ɩrbɛ bɔ̃ɔn bʊ̃vɩla ma maal kʊ a yɩ bibiir, ŋmɩnɛ lɛ an ɩ ka a yɩ Sãa na be a saaju, kʊ̃ de bʊ̃vɩɛl kʊ a bala na sʊɔr wʊ ɛ? ");
INSERT INTO biv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","A lɛ yɩn ma bʊɔrɔ ɩka a nɩbɛ ba ma maala kʊrɔ yɩ, yɩ mɩ ma maala a lɛ ban bʊɔrɔ kʊrɔ ba, a nyã lɛ ɩ a Nɛbinãa nɩ a 'Yɛ'yɛrbɛ Wiilfʊ. ");
INSERT INTO biv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Yɩ tu a dɔ̃dɔr fɩɩl pɔ kpɛ, bojũu a dɔ̃dɔr yal sɔr ɩn jaa kɔ̃mɔ̃kɔ̃mɔ̃ tɩ ɩ sɔ̃ɔfʊ sɔr tɩchɛ ka nɩyɔɔ turo. ");
INSERT INTO biv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","A dɔ̃dɔr ɩn jaa fɩɩl ka nyɛvʊr sɔr mɩ ɩ jaa kãrakãra ka nɩbɛ bãlãa na tʊ̃ɔ tu. ");
INSERT INTO biv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Yɩ bɔ̃ɔn a jire 'yɛ'yɛrbɛ, ba ma bal ba mãɛ piir kaar tɩchɛ ba ɩn mɔdʊ̃ be be na sɔ̃ɔnɔ̃. ");
INSERT INTO biv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","A ba wɔ̃mɔ̃ lɛ yɩn bɔ̃ɔn a lɛ ban be. Ba ma pɔr 'wɔ̃rɔ gʊtɩɛ ju bɩɩ pɔr kɔ̃kɔ̃ɔ nyaartɩɛ ju ɔ? ");
INSERT INTO biv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Lɛ mɩ lɛ tɩsʊ̃ jaa ma wɔ̃n wɔ̃sʊ̃n ka tɩdɛɛr mɩ ma wɔ̃ wɔ̃dɛbɛ. ");
INSERT INTO biv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tɩsʊ̃ ba wɔ̃nɔ̃ wɔ̃dɛbɛ ɛ bɩɩ tɩdɛɛr mɩ ba wɔ̃nɔ̃ wɔ̃sʊ̃n ɛ. ");
INSERT INTO biv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tɩɛ jaa baa wa wɔ̃nɔ̃ wɔ̃sʊ̃n ɛ, ban ŋmaa wʊn lɔb 'yɔ̃ɔ bũu pɔ. ");
INSERT INTO biv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","A ba wɔ̃mɔ̃ lɛ yɩn de bɔ̃ɔn ba. ");
INSERT INTO biv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“A ba ɩ nɩrɛ jaa na bʊɔlɔ ɩka n Soro, n Soro, lɛ na kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ ɛ, tɩchɛ nɩrɛ nyã na maala a lɛ a n Sãa Nãaŋmɩn na be a saaju na bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","A bɩbir 'lɔ daar, nɩyɔɔ na 'yɛr kʊ ma n Soro, n Soro, saa 'yɛr Nãaŋmɩn 'yɛr a fʊ yuor pɔ ɛ, na sɩ diin a sɩdɛbɛ ka a yɩ a fʊ yuor pɔ ɛ, na sɩ tʊ̃ nɛ'maa tʊ̃mɔ̃ a fʊ yuor pɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","A daar 'lɔ̃nɔ̃ ɩn 'yɛr kʊ ba, n ba bɔ̃ɔ yɩ ɛ, yɩ tɔɔ chen be, yɩn yelbe-ɩrbɛ. ");
INSERT INTO biv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“A lɛ jũu, nɩrɛ jaa na wõ a n 'yɛrbie anyãna tɩ maala a lɛ na kaara fɩka yɛ̃ sʊɔ na mɛ a wʊ yir dɔɔl pie ju. ");
INSERT INTO biv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Saa wa naa, ka a kʊ̃ɔ yɩ yaar jilʊ̃ a yir ka a sɛsɛbɛ fu ŋme a yir tɩchɛ waa lo ɛ, bojũu wʊ ara na kʊsɩr ju. ");
INSERT INTO biv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tɩchɛ, nɩrɛ jaa na wõ a n 'yɛrbie anyãna tɩ na waa maal ɛ, kaara fɩka jɔl na mɛ a wʊ yir dɔɔl bire ju. ");
INSERT INTO biv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Saa wa naa, ka a kʊ̃ɔ yɩ yaar jilʊ̃ a yir, ka a sɛsɛbɛ fu ŋme a yir kʊ lo ka a wʊ lofʊ ɩ dɛɛr.” ");
INSERT INTO biv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu na wa 'yɛr a 'yɛrbie anyãna baar nɛɛ 'maan a nɩyɔɔ nɩ a wʊ wiilfʊ, ");
INSERT INTO biv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","bojũu wʊ wile ban nɩ kpɛ̃ɔ gar a ba nɛbinãa wiwiilbe. ");
INSERT INTO biv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu na wa yɩ a tɔ̃ɔ ju suu nɩyɔɔ turo wʊ naa, ");
INSERT INTO biv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","a nɩyɔɔ na turo wʊ, ka daba ãsʊɔ na tara kɔ̃kɔ̃mɔ̃ baal wa gbur dumo a wʊ niem tɩ 'yɛr, “N Soro fʊ̃ʊ sɔɔ sãa ma.” ");
INSERT INTO biv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ka Yesu tur a wʊ nũu sɩɩr a daba tɩ 'yɛr, “N sɔɔ naa, sa.” Ajienaa ka a daba kɔ̃kɔ̃mɔ̃ baal bar wʊ. ");
INSERT INTO biv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Be lɛ ka Yesu 'yɛr kʊ wʊ, taa 'yɛrɛ kʊrɔ nɩrɛ ɛ, tɩchɛ chen tɩ wiil a fʊ mãɛ kʊ a Juu nɩbɛ bɔɔrloro na fʊ chiin a fʊ kʊfʊ tɩ ir a nɛɛ 'lɔ a Mosesɩ na dɔ̃ɔ 'yɛr ka a di dãasɩɛ. ");
INSERT INTO biv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu na wa kpɛ a Kapenahum a sojasɩ nɩdiere chen a wʊ sɛ̃ tɩ sʊɔr wʊ 'yɛr, ");
INSERT INTO biv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“N Soro, a n tʊ̃tʊ̃nɔ̃ lɛ gã a yir ba tʊɔrɔ ire ɛ, na wʊ wõnõ a ãgãn tuo.” ");
INSERT INTO biv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ka Yesu 'yɛr kʊ wʊ, “Ɩ̃n wa sa naa a wʊ baal kʊ wʊ.” ");
INSERT INTO biv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ka a sojasɩ nɩdiere 'yɛr, “N Soro n ba sɛɛ ɩka fʊ wa a n yir ɛ, 'yɛr a 'yɛrbir tɛɛ, a n tʊ̃tʊ̃nɔ̃ na sa naa. ");
INSERT INTO biv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","A maa mãɛ tara na nɩbɛrɛ ɩn joro dãbãɛ, naa mɩ tara a sojasɩ ka ba mɩ be a n pĩlem, maa 'yɛr kʊ nyã ɩka wʊ, chen, wʊ ma chen naa, bɩɩ ãsʊɔ ɩka, wa, wʊ ma wa naa, bɩɩ ka n 'yɛr kʊ a n gbãgbaa, maal nyã, wʊ ma maal naa.” ");
INSERT INTO biv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu na wa wõ a nɩtɔ̃, nɛɛ 'maa wʊ naa ka wʊ 'yɛr kʊ a bala na turo wʊ, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ. A Isɩral nɩbɛ pɔ gba, n ba nyɛ a sɔɔfʊ nyã tɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","N 'yɛrɛ na kʊrɔ yɩ ɩka nɩyɔɔ na yin jie jaa wa na ba wa lɔ̃ɔ din a Abraham nɩ a Isaakɩ nɩ a Jekɔb a Nãaŋmɩn nãalʊ̃ʊ pɔ, ");
INSERT INTO biv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","tɩchɛ a bala na so a Nãaŋmɩn nãalʊ̃ʊ, wʊn lɔb ban bar yõo a jilibe pɔ, be lɛ ban kõnõ ɔɔrɔ nɩ nyɩmɛ.” ");
INSERT INTO biv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu 'yɛr kʊ a sojasɩ nɩdiere, “Kulo, a ɩ a lɛ kʊ fʊ, fʊn tara a sɔɔfʊ jũu.” A tʊ̃tʊ̃nɔ̃ sa naa a sɔ̃ɔ 'lɔ̃nɔ̃ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu na kpɛ a Pita yir, wʊ nyɛn a Pita dãɛ ma ãgãn na tɔ kʊ gã. ");
INSERT INTO biv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Wʊ sɩɩr a pɔɔ nũu, ka a ãgãn tʊl baar a wʊ ir maal bʊ̃diir kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","A jãanʊɔr 'lɔ̃nɔ̃ ba waan na nɩyɔɔ a sɩdɛbɛ na tara a Yesu sɛ̃, ka wʊ de a 'yɛrbir diin a sɩdɛbɛ ka a yi tɩ sãa a bala jaa an ɔɔrɔ. ");
INSERT INTO biv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ka a lɛ jaa a Nãaŋmɩn 'yɛ'yɛrɛ Isaiya na dɔ̃ɔ 'yɛr ɩ yelmãɛ, “Ɩka wʊ den a sɩn baalsɩ a jaa bar.” ");
INSERT INTO biv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu na wa nyɛ a nɩyɔɔ na ŋmaa jilʊ̃ wʊ, ka wʊ 'yɛr kʊ a wʊ poturbo yɩ gɔ̃ɔ a man gɔ̃ɔn. ");
INSERT INTO biv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","A nɛɛ wiwiilbe ãsʊɔ tɔɔn ta wʊ tɩ 'yɛr, “Wiwile, jie jaa fʊn chiine ɩn turo fʊ naa.” ");
INSERT INTO biv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ka a Yesu 'yɛr, “Mɔbaar tara naa bɔɔr ka lubil mɩ tara choor tɩchɛ maa Nɩsaal Bie ba tara jie na bin a n ju ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ka a wʊ poturo ãsʊɔ mɩ 'yɛr kʊ wʊ, “N Soro kʊ ma sɔr ka n kul tɩ ũu a n sãa baar.” ");
INSERT INTO biv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tɩchɛ ka Yesu 'yɛr kʊ a daba, “Turo ma tɩ bar ka a kũn ũno a ba mãɛ kũn.” ");
INSERT INTO biv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu na wa kpɛ a gboro pɔ a wʊ poturbo mɩ tu wʊn kpɛ. ");
INSERT INTO biv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kɔ̃sɛbɛ ir a man pɔ, ka a gboro sɛɛ kʊ̃ɔ ɩrɛ na mʊr tɩchɛ ka a Yesu gã gur. ");
INSERT INTO biv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Be lɛ ba chen tɩ sãɩ wʊ na ba 'yɛr, “Sɩ Soro faa sɩ, a kʊ̃ɔ dire sɩ naa!” ");
INSERT INTO biv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ka wʊ sʊʊr ba, “Bo lɛ so ka yɩ joro a dãbãɛ? A yɩ sɔɔfʊ lɛ ba jã bon ɛ.” Ka a Yesu ir tãn ka a sɛsɛbɛ na ta furo ŋmaa vʊʊr ka a kʊ̃ɔ mɩ na ta ɔɔrɔ lo jaa jomm. ");
INSERT INTO biv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nɛɛ 'maan a nɩbɛ ka ba sʊrɔ taa, nɩ an lɛ a nyã ka a sɛsɛbɛ nɩ a kʊ̃ɔ tu a wʊ nɛɛ? ");
INSERT INTO biv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu na wa ta a Gadara paal pɔ, dɔɔr ayi na tara sɩdɛbɛ yɩn a yar par tuor wʊ. Ban ɩ a nɩbebe jũu, nɩrɛ jaa maa 'la tu a sɔr 'lɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ban wa nyɛ a Yesu ba ŋmen chɛlma tɩ 'yɛrɛ, “Bo lɛ fʊ bʊɔrɔ ka a sɩ sɛ̃, fʊ̃ʊ Nãaŋmɩn Bie? Fʊ wan ɩka fʊ wa ge sɩ tɩchɛ ka a 'yɛr tɔɔrfʊ bɩbir wa ta bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Do yɔɔ mɩ dɔ̃ɔ ara gbʊr ba dire. ");
INSERT INTO biv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ka a sɩdɛbɛ sʊɔr wʊ, “Ala ɩ fʊn dii sɩn bar, sɔɔ ka sɩ chen tɩ kpɛ a dor anyã pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ka wʊ 'yɛr kʊ ba, “Yɩ chen!” Be lɛ a sɩdɛbɛ yi naa kpɛ a dor pɔ, ka a dor a jaa jo tĩgbil suu tɩ kpɛ a man kʊ̃ɔ pɔ gbʊ̃m kpi kpi. ");
INSERT INTO biv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A bala na kaara a dor jon kul, ban wa tɩ kpɩɛrɛ a tẽe pɔ, ba man bon 'lɔ jaa na ɩ a bala na tara a sɩdɛbɛ nɩ a lɛ jaa na ɩ a dor. ");
INSERT INTO biv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A tẽe wʊ jaa nɩbɛ yɩn wa a Yesu sɛ̃; ban wa nyɛ wʊ ba sʊɔr wʊn ɩka wʊ yɩ a ba wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu na wa kpɛ a gboro pɔ, wʊ gɔ̃ɔn a man chen a wʊ mãɛ tẽe be a Kapenahum. ");
INSERT INTO biv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dɔɔr bamɩne tuon daba nɩ fɔbaa nuur nɩ a gbɛɛ na kpi waan wa kpɛ̃n wʊ gaal a Yesu niem. Yesu na wa nyɛ lɛ ban sɔɔ de wʊ, ka wʊ 'yɛr kʊ a baalaa, “N bie ta joro dãbãɛ ɛ, a fʊ yeldɛbɛ vɛ̃n bar.” ");
INSERT INTO biv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ka a nɛɛ wiwiilbe bamɩne pãa jɛ̃ bʊlɔ 'yɔ̃ɔnɔ̃ pʊʊr pɔ, “A daba nyã fere na sɔ̃ɔnɔ̃ Nãaŋmɩn yuor.” ");
INSERT INTO biv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu bɔ̃ɔn a lɛ ban tɩɛr, ka wʊ sʊʊr ba, “Ŋmɩnɛ lɛ yɩ tɩɛrɛ dɛɛr a yɩ pʊʊr pɔ? ");
INSERT INTO biv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","'Yɛr buor sʊɔ lɛ ɩ kɔ̃mɔ̃kɔ̃mɔ̃? N 'yɛr ɩka a wʊ yeldɛbɛ vɛ̃n bar bɩɩ n 'yɛr ɩka wʊ ir chiine? ");
INSERT INTO biv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tɩchɛ pʊ̃pãanyã ɩn wiil yɩ naa ka yɩ bɔ̃ɔn ɩka maa Nɩsaal Bie tara na kpɛ̃ɔ a wɛr pɔ, na vɛ̃ nɩrɛ yeldɛbɛ bar.” Tɩ pãa 'yɛr kʊ a gbɛrɛ, “Ir 'mɔɔ a fʊ bʊ̃gãnaa kulo nɩ.” ");
INSERT INTO biv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ka a daba vaa ir kulo. ");
INSERT INTO biv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","A nɩbɛ na nyɛ a lɛ nɛɛ 'maa ban ka ba pɛɛrɛ Nãaŋmɩn na kʊ nɩsaal a kpɛ̃ɔ nyã. ");
INSERT INTO biv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu na wa yi a be chiine, wʊ nyɛn daba na di Matiu na jãnɛ a lõpoo defʊ jie, ka wʊ 'yɛr kʊ wʊ, “Ir turo ma,” ka a Matiu ir turo wʊ. ");
INSERT INTO biv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ka ba 'mataa kul a wʊ yir tɩ jɛ̃ dire ka a lõpodiere nɩ a yelbe-ɩrbɛ yɔɔ wa pʊɔ ba nɩ a Yesu poturbo ka ba 'mataa dire. ");
INSERT INTO biv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","A Faraseemɩne na wa nyɛ a nɩtɔ̃ ba sʊʊr a Yesu poturbo, “Bo lɛ so ka a yɩ wiwile 'mataa dire nɩ a lõpodierbe nɩ a yelbe-ɩrbɛ?” ");
INSERT INTO biv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu wõn a lɛ ban 'yɛr, ka wʊ 'yɛr kʊ ba, “Nɩrɛ na kpɛ̃mɛ ba chiine tɩtɩlɛ jie ɛ, tɩchɛ baalaa lɛ ma chen. ");
INSERT INTO biv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tɩchɛ yɩ kul tɩ tɩɛr a yele nyã kaa, ‘N bʊɔrɔ na nɩbaal a ba ɩ dʊ̃n bɔɔr lofʊ ɛ.’ N ba wa ɩka n wa bʊɔl a bala na tor ɛ, tɩchɛ n wan ɩka n wa bʊɔl a yelbe-ɩrbɛ.” ");
INSERT INTO biv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ka a Jɔɔn poturbo wa a wʊ sɛ̃ wa sʊrɔ, “Ŋmɩnɛ a sɩn nɩ a Faraseemɩne ma gal kɔ̃ tɩchɛ ka a fʊ poturbo 'lɔ maa gal kɔ̃ ɛ?” ");
INSERT INTO biv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ka a Yesu sʊʊr ba, “Fʊn tʊ̃ɔ maal a bala ban bʊɔl a pɔɔ paalaa jie ka ba tara pʊsɔ̃ɔ a pɔɔ paalaa sɩrɛ na chɛnɛ be a ba sɛ̃ ɔ, ban tʊ̃ɔ naa? Sɔ̃ɔ waara naa ka a nɩbɛ na wa nyɔɔ ma chiin, a ber ala pɔ lɛ a n poturbo pʊɔ na sɔ̃ɔ ka ba gal kɔ̃. ");
INSERT INTO biv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Nɩrɛ maa ŋmaa fɔpaalaa sɛ choo fɔkoraa pɔ ɛ, 'lɔ be ɩ a lɛ a fɔpaalaa na tɔɔn a fɔkoraa chɩɛr. Ka a chɩɛrfʊ na ɩ dɛɛr. ");
INSERT INTO biv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bɩɩ nɩrɛ ma den dãbãɩn 'yɔ̃ɔ dãa wɔkoraa pɔ ɛ, 'lɔ be ɩ a lɛ a dãbãɩn na pur naa a wʊɔ ka a dãa kpaar ka a wʊɔ mɩ sɔ̃ɔ. Ba ma den dãbãɩn 'yɔ̃ɔ a dãa wɔpaalaa pɔ, ka a ta sɔ̃ɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","A Yesu na chɛnɛ 'yɛrɛ a anyãna kʊrɔ ba, a lɔ̃ɔfʊ yir nɩdiere wa gbur dumo a wʊ niem tɩ 'yɛr, “A n bipɔɔ lɛ kpi ajienaa, wa lɩɛb a fʊ nuur sɩɩr wʊ tɩ wʊn sa naa.” ");
INSERT INTO biv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ka a Yesu nɩ a wʊ poturbo ir turo wʊ. ");
INSERT INTO biv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ban wa de a sɔr chiine ka pɔɔ na lo sɩɛ suoro faara yuom pie nɩ ayi, wʊ gʊɔr a Yesu puor tɩ sɩɩr a fuu nɛɛ, ");
INSERT INTO biv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","bojũu wʊ tɩɛr a wʊ pʊɔm ɩka 'lɔ sɩɩr a Yesu fuu wʊn sa naa. ");
INSERT INTO biv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu na lɩɛb nyɛ a pɔɔ wʊ 'yɛr naa, “Ta joro dãbãɛ ɛ n yɛpɔɔ, a fʊ sɔɔfʊ sãa fʊ naa.” A dẽdẽe daa a pɔɔ jãɩ ŋmaa naa. ");
INSERT INTO biv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","A Yesu na wa kpɛ a lɔ̃ɔfʊ nɩdiere yir na wʊ nyɛ a ɩɩlpɛɛlbɛ nɩ a nɩyɔɔ na pɔɔrɔ gɔ̃mɔ̃, ");
INSERT INTO biv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ka wʊ 'yɛr, “Yɩ tɔɔ chen be a pɔɔbile ba kpi ɛ, wʊ gur naa.” Ka ba laara wʊ. ");
INSERT INTO biv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","A nɩyɔɔ na wa yɩ a yõo baar, wʊ kpɛ̃n tɩ nyɔɔ a wʊ nũu, ka a pɔɔbile vaa ir. ");
INSERT INTO biv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ka a yele ŋme yaar a paal 'lɔ wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu na wa yi a be chiine, jɔ̃n ayi turo wʊ naa, na ba gboolo bʊɔlɔ, “Kaa sɩ nɩbaal, David Bie.” ");
INSERT INTO biv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wʊn wa kpɛ a yir, a jɔ̃n wan a wʊ sɛ̃, ka Yesu sʊʊr ba, “Yɩ sɔɔn de ɩka ɩn tʊ̃ɔ sa a yɩ baal ɔ?” Ka ba 'yɛr kʊ wʊ, “Ɔ̃ɔ, sɩ Soro.” ");
INSERT INTO biv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ka wʊ sɩɩr a ba nɩbie tɩ 'yɛr, “A yɩ sɔɔfʊ jũu yɩn nyɛrɛ naa.” ");
INSERT INTO biv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ka a ba nɩbie tɔ̃ɔ yuo yuor. Tɩchɛ ka Yesu kpãkpãan ba ɩka ba taa vɛ̃ ka nɩrɛ jaa bɔ̃ɔn ɛ. ");
INSERT INTO biv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tɩchɛ ba yin tɩ ŋme a wʊ yele yaar a tẽe 'lɔ̃nɔ̃ wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","A jɔ̃n ayi bala na wa lɩɛb chen baar, ba tara na daba na tara sɩdɛbɛ na wʊ ɩ wõo waan a Yesu sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","A sɩdɛbɛ na wa yɩ a daba pɔ baar, wʊ piel 'yɛrɛ, ka nɛɛr 'maa a nɩyɔɔ ka ba 'yɛrɛ, “Saa dɔ̃ɔ nyɛ a nɩtɔ̃ a Isɩral jaa ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tɩchɛ ka a Faraseemɩne 'yɛr, “A sɩdɛbɛ nãa lɛ kʊ wʊ a kpɛ̃ɔ ka wʊ dire nɩ a sɩdɛbɛ ka a yire.” ");
INSERT INTO biv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu yɔn a tẽbɛrɛ nɩ a tẽbil a jaa pɔ, wile a nɩbɛ a lɔ̃ɔfʊ yie pɔ, tɩ mʊɔlɔ a Nãaŋmɩn nãalʊ̃ʊ 'yɛr nʊ̃ɔ sãana nɩ baal jaa bʊrɔ. ");
INSERT INTO biv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wʊn wa nyɛ a nɩyɔɔ, nɩbaal kpɛ wʊ naa bojũu baa bɔ̃ɔ a ba ju tɩɛr ɛ, na baa mɩ lɛ tara sʊ̃nɔ̃ ɛ, fɩka piir na ba tara chɩnɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ka wʊ 'yɛr kʊ a wʊ poturbo, “A pʊɔ bɛrma naa tɩchɛ ka a ŋmaŋmarba ba waa ɛ, ");
INSERT INTO biv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","a lɛ jũu yɩ sʊɔr a pʊɔ sʊɔ ka wʊ bar tʊ̃tʊ̃nbɔ ka ba wa a pʊɔ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu bʊɔl a wʊ poturbo pie nɩ ayi na wʊ kʊ ba kpɛ̃ɔ ɩka ba dii a sɩdɛbɛ ka a yi, na ba sãana nɩ baal jaa bʊrɔ. ");
INSERT INTO biv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","A poturbo pie nɩ ayi na ɩ a nɩtʊ̃nsɩ yoe lɛ a anyãna, Simon ban bʊɔlɔ Pita, nɩ a wʊ yɛbɛ Andiru, Jemesɩ na ɩ Jebedee bidaba, nɩ a wʊ yɛbɛ Jɔɔn. ");
INSERT INTO biv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip nɩ Batolomi, Tomasɩ nɩ Matiu na ɩ a lõpodiere. Jemesɩ na ɩ Alfayasɩ bidaba nɩ Tadius. ");
INSERT INTO biv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon na mʊ̃ɔ nɩbir nɩ a wʊ wɛr yele, nɩ Judas Isɩkariyot 'lɔ lɛ wa gar 'yɔ̃ɔ a Yesu. ");
INSERT INTO biv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","A poturbo pie nɩ ayi banyã lɛ a Yesu tʊ̃ nɩ a kpãafʊ anyãna. “Yɩ ta kpɛ a nɩyor bɩɩ a Samariya tẽn pɔ ɛ, ");
INSERT INTO biv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","tɩchɛ yɩ chen a Isɩral nɩbɛ bala na bɔr a piir kaar sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yɩ chen tɩ mʊɔl a 'yɛr nʊ̃ɔ na yɩ 'yɛrɛ, a Nãaŋmɩn nãalʊ̃ʊ ta na. ");
INSERT INTO biv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yɩ sãana a baalsɩ, na yɩ sãnɛ a kũusɩ, na yɩ sãana a kɔ̃kɔ̃mɔ̃ baalsɩ na yɩn maal ba ka ba ɩ nɩsʊ̃n, na yɩ dire a sɩdɛbɛ ka a yire. Yɩ nyɛn pɔrɔ, yɩ mɩ tɩ tɩr pɔrɔ. ");
INSERT INTO biv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yɩ ta de sɛlma ɛ bɩɩ diere libie 'yɔ̃ɔnɔ̃ a yɩ wʊʊr pɔ ɛ, ");
INSERT INTO biv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","bɩɩ 'mɔɔ wʊɔ tara a sɔr pɔ ɛ, bɩɩ 'mɔɔ fuusɩ ayi ɛ, bɩɩ de nafɔbɔ pʊ̃ɔ ɛ, bɩɩ dadiiraa ɛ, bojũu tʊ̃tʊ̃nɔ̃ jaa sɛɛn naa wʊ sãyar. ");
INSERT INTO biv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Yɩn wa kpɛ tẽe jaa pɔ, yɩ sʊʊr kaa nɩrɛ 'lɔ nɩ na de yɩ, yɩ kpɩɛrɛ a wʊ 'yɛr na yɩ wa tɩ yɩn a be. ");
INSERT INTO biv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yɩn wa kpɛ a yir, yɩ puor a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","A yir 'lɔ nɩbɛ wa sɔɔ de yɩ, yɩ vɛ̃ ka a yɩ nyã'maar be a ba sɛ̃, tɩchɛ bala ba wa sɔɔ de yɩ ɛ, yɩ lɩɛb a yɩ nyã'maar. ");
INSERT INTO biv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nɩrɛ jaa baa wa sɔɔ de yɩ ɛ bɩɩ chɛl a yɩ 'yɛr ɛ, yɩ kpoor a yɩ gbɛɛ tã-uul bar yɩn wa yire be a tẽe 'lɔ bɩɩ a yir 'lɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, Nãaŋmɩn na kãan a Sodom nɩbɛ nɩ a Gomora nɩbɛ nɩbaal a 'yɛr tɔɔrfʊ bɩbir gar a nɩbɛ bala a tẽe 'lɔ̃nɔ̃ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yɩ nyɛ, n tʊ̃nɔ̃ yɩ naa fɩka piir na kpɛ jubɛrɛ pɔ kaar, yɩ ɩ yɛ̃n dẽme waba kaar, na yɩ kaara fɩka ŋmama na ba maala dɛɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Yɩ gu a yɩ mãɛ, ban nyɔɔr yɩn chiin tɩ kʊ a nɩbɛrɛ na ba fɔb yɩ a ba lɔ̃ɔfʊ jiir, ");
INSERT INTO biv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ban fɩr yɩn chiin a paal nɩbɛrɛ jie nɩ a nãmɩne yie a n yuor jũu, ka yɩ na di dãasɩɛ kʊ a bala na ɩ a nɩyor. ");
INSERT INTO biv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ba la wa nyɔɔr yɩ chiin a 'yɛr tɔɔr fʊ jie, yɩ ta vɛ̃ ka a wõnõ yɩ a lɛ yɩn tɩ 'yɛrɛ ɛ nɩ a lɛ yɩn na 'yɛr ɛ; bon 'lɔ yɩn na 'yɛr Nãaŋmɩn na wiil yɩ naa a sɔ̃ɔ 'lɔ nɔ̃. ");
INSERT INTO biv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","A ba ɩ yɩn lɛ na 'yɛr ɛ tɩchɛ a yɩ Sãa Nãaŋmɩn Sɩɛ na wiil yɩn a lɛ yɩn na 'yɛr. ");
INSERT INTO biv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Yɛbɛ na gar 'yɔ̃ɔ yɛbɛ ka ba kʊ wʊ, ka a sãa mɩ gar 'yɔ̃ɔ a wʊ bie. Bibiir kʊ lɛ wõnõ a ba sãamɩne toor ɛ, na ba vɛ̃ ka ba kʊ ba. ");
INSERT INTO biv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nɩrɛ jaa na 'laar yɩ naa yɩn sɔɔ ma jũu, tɩchɛ nɩrɛ 'lɔ na sɔɔ ara tɩ ta a baaraa, na nyɛn faafʊ. ");
INSERT INTO biv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","A tẽe 'lɔ nɩbɛ wa gere yɩ, yɩ yi a be fɔɔ chen tẽyuo; yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, yɩ kʊ yɔ a Isɩral tẽn bar ɛ, tɩchɛ ka a Nɩsaal Bie wa ɛ. ");
INSERT INTO biv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Jãjãna ba gar a wʊ wiwile ɛ bɩɩ ka gbãgbaa gar a wʊ nɩkpɛ̃ɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A sɛɛn ɩka a jãjãna wʊ nyɛtãan a wʊ wiwile, ka a gbãgbaa mɩ nyɛtãan a wʊ nɩkpɛ̃ɛ. Ɩ ba bʊɔlɔ na a yir sʊɔ Beeljebul, yodɛɛr buor lɛ ban pãa bʊɔlɔ a yir dẽme! ");
INSERT INTO biv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Yɩ ta joro nɩbɛ dãbãɛ ɛ, bon jaa ba be be pɔɔ ka ba kʊ̃ yuo ɛ, bɩɩ bon jaa ba be be sɔɔl ka ba kʊ̃ bɔ̃ɔn ɛ. ");
INSERT INTO biv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bon 'lɔ n 'yɛr kʊ yɩ libe pɔ yɩ 'yɛr wʊ chãa pɔ, bon 'lɔ yɩn wʊ ka ba bʊl 'yɛr yɔ̃ɔ pʊɔm 'yɛr mʊɔl wʊ a gaɩ jur. ");
INSERT INTO biv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yɩ ta joro a bala na kʊ a ãgãn tɩ kʊ tʊ̃ɔ kʊ a sɩɛ ɛ, tɩchɛ yɩ joro a 'lɔ nɩ na tʊ̃ɔ kʊ a sɩɛ nɩ a ãgãn a bũu dagel 'lɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ba ma dãn tiitasɩ ayi kobsɩ ayi. Tɩchɛ ãsʊɔ kʊ lo tẽe ɛ, ala baa ɩ a yɩ Sãa Nãaŋmɩn bɔfʊ lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nãaŋmɩn sɔr a yɩ jukɔɔl a jaa bɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","A lɛ jũu, yɩ ta joro dãbãɛ ɛ, yɩ tara na tɔ̃nɔ̃ gar a tiitasɩ. ");
INSERT INTO biv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nɩrɛ jaa na wa 'yɛr ɩka wʊ bɔ̃ɔ ma naa a nɩbɛ niem, 'lɔ lɛ n mɩ na 'yɛr ɩka n bɔ̃ɔ naa a n Sãa na be a saaju niem, ");
INSERT INTO biv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","tɩchɛ nɩrɛ 'lɔ na chiir ma a nɩbɛ niem, 'lɔ lɛ n mɩ na chiir a n Sãa na be a saaju niem. ");
INSERT INTO biv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yɩ ta tɩɛr ɩka nyã'maar lɛ n waan a wɛr pɔ ɛ; n ba waan nyã'maar ɛ tɩchɛ ootaa lɛ n waan. ");
INSERT INTO biv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","N wan ɩka n wa vɛ̃ ka ‘Bie nɩ sãa ootaa, ka bipɔɔ oo a ma, pɔɔ na oo naa a wʊ bidaba pɔɔ ka a bidaba pɔɔ mɩ oo a wʊ sɩrɛ ma. ");
INSERT INTO biv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yir dẽme na lɩɛb ɩ dɔ̃dẽme.’ ");
INSERT INTO biv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nɩrɛ jaa na nʊ̃ a wʊ sãa bɩɩ a wʊ ma gar ma wʊ kʊ̃ tʊ̃ɔ ɩ a n poturo ɛ, nɩrɛ jaa mɩ na nʊ̃ a wʊ bie bɩɩ bipɔɔ gar ma, wʊ kʊ tʊ̃ɔ ɩ a n poturo ɛ. ");
INSERT INTO biv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nɩrɛ 'lɔ mɩ na ba de a wʊ daa tuo turo nɩ ma ɛ, wʊ kʊ̃ tʊ̃ɔ ɩ a n poturo ɛ. ");
INSERT INTO biv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bala na bʊɔrɔ a ba nyɛvʊr na bɔr wʊ naa tɩchɛ bala mɩ na bɔr a ba nyɛvʊr a maa jũu na nyɛ wʊ naa. ");
INSERT INTO biv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nɩrɛ 'lɔ jaa na sɔɔ de yɩ, sɔɔn de ma, nɩrɛ 'lɔ jaa mɩ na sɔɔ de ma sɔɔn de a nɩrɛ 'lɔ na tʊ̃ ma. ");
INSERT INTO biv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nɩrɛ 'lɔ jaa na sɔɔ de a Nãaŋmɩn 'yɛ'yɛrɛ wʊn ɩ Nãaŋmɩn 'yɛ'yɛrɛ jũu na nyɛn a wʊ sãyar. Nɩrɛ jaa mɩ na sɔɔ de nɩrɛ na ɩ nɩtor wʊn ɩ nɩtor jũu na nyɛn a nɩtor sãyar. ");
INSERT INTO biv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nɩrɛ 'lɔ jaa na kʊ a bʊ̃bile banyãna ãsʊɔ kɔ̃'maar nɩ ŋmele wʊ̃n ɩ a n poturbo jũu, yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka a nɩnyɩnɛ kʊ̃ faa a wʊ sãyar ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu na wa wiil a wʊ poturbo pie nɩ ayi baar, wʊ yin a be chen a Juu nɩbɛ tẽn tɩ wile na wʊ mʊɔlɔ a 'yɛr nʊ̃ɔ a tẽn ala na be a Galilee paal pɔ. ");
INSERT INTO biv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jɔɔn na be a nɩpɔɔ die pɔ, tɩ wa wõ lɛ a Yesu Kɩrɩsɩto na maala, wʊ tʊ̃n a wʊ poturbo bamɩne ");
INSERT INTO biv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ɩka ba tɩ sʊʊr, “Fʊ̃ʊ lɛ a nɩrɛ 'lɔ nɩ na wa bɩɩ, sɩ chɛlɛ nɩyuo?” ");
INSERT INTO biv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ka Yesu 'yɛr kʊ ba, “Yɩ lɩɛb kul tɩ 'yɛr kʊ a Jɔɔn, a lɛ yɩn wõ tɩ nyɛ. ");
INSERT INTO biv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jɔ̃n nyɛrɛ naa, ka a gbɛrsɩ mɩ chiine, ka kɔ̃kɔ̃n mɩ sa, ka wõn mɩ wõnõ jaa chɛchɛ, ka kũusɩ jɛɔ, ka 'yɛr nʊ̃ɔ mɩ ta a nɔ̃n dẽme. ");
INSERT INTO biv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pʊpɛl sʊɔ lɛ a 'lɔ na ba baala ma ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ban wa chen baar, Yesu piel 'yɛrɛ a Jɔɔn 'yɛr kʊrɔ a nɩyɔɔ, “Bo lɛ yɩ dɔ̃ɔ kpɛ a mɔgɔ̃ɔ pɔ ɩka yɩ tɩ kaa? A jɩmur a sɛsɛbɛ na dɔ̃ɔnɔ̃ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kai, ka bo lɛ yɩ chen ɩka yɩ tɩ kaa? Daba na su bʊ̃vɩɛl lɛ yɩ chen ɩka yɩ tɩ kaa bɩɩ? Nyɛ a bala na ma su bʊ̃vɩɛl ɛ, nãmɩne yie lɛ ba ma be. ");
INSERT INTO biv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tɩchɛ bo lɛ yɩ chen ɩka yɩ tɩ kaa? Nãaŋmɩn 'yɛ'yɛrɛ bɩɩ? Ɔ̃ɔ, n 'yɛrɛ na kʊrɔ yɩ ɩka wʊ gar Nãaŋmɩn 'yɛ'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","A nyã yele lɛ sɛb a Nãaŋmɩn gãn pɔ ɩka ɩn tʊ̃ naa a n tʊ̃tʊ̃nɔ̃ ka wʊ de a fʊ nie na wʊ tɩ chɔɔr a fʊ sɔr kʊ fʊ. ");
INSERT INTO biv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka bala jaa pɔɔ na dɔɔ ka a wɛr pɔ, ba ɩ kpɛ̃ɛ gar a Jɔɔn kɔ̃suor ɛ, tɩchɛ 'lɔ mɩ na ɩ a pʊʊr a Nãaŋmɩn nãalʊ̃ʊ pɔ gar wʊ naa. ");
INSERT INTO biv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","An yi a Jɔɔn Kɔ̃suoro sɔ̃ɔ wa tɩ tãn a dɩna a Nãaŋmɩn Nãalʊ̃ʊ nʊ̃ɔnɔ̃ naa ka a kpãɛn dẽme sɔ̃ɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","A Nãaŋmɩn 'yɛ'yɛrbɛ ba jaa nɩ a nɛbinãa dɔ̃ɔ 'yɛr a Nãaŋmɩn nãalʊ̃ʊ 'yɛr tɩ tãn a Jɔɔn sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ala ɩ yɩn sɔɔn de, a anyãna 'lɔ lɛ ɩ a Elaija nɩ naa lɩɛb wa. ");
INSERT INTO biv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nɩrɛ 'lɔ na tara toor wʊ chɛlɛ. ");
INSERT INTO biv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Tɩchɛ bo lɛ ɩn de a dɩna nɩbɛ man? Ba nyɛntãan bibiir na ma jãnɛ a ba dãɛn jiir na ba bʊɔlɔ taa, ");
INSERT INTO biv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","sɩ pɛɛl a ɩlɛ tɩ yaa sɛɛrɛ bãnɛ ɛ, na sɩ kõnõ kõyiel yaa ŋmara nɩbikʊ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","A Jɔɔn na wa, waa dire ɛ, na waa lɛ nyuro go ɛ, ka ba 'yɛr ɩka sɩdɛɛr lɛ wʊ ɩ. ");
INSERT INTO biv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tɩchɛ ka a Nɩsaal Bie wa na wʊ ma dire tɩ nyuro ka ba 'yɛr ɩka di dire nɩ dãburo lɛ wʊ ɩ, na wʊ ɩ a lõpodierbe nɩ a yelbe-ɩrbɛ baraa. A ma wiil a lɛ Nãaŋmɩn na tor, bala wa nyɛ lɛ a wʊ nɩbɛ na kpɩɛrɛ nɩ yɛ̃.” ");
INSERT INTO biv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu pʊɔ sɔ̃ɔn naa a tẽn bala nɩbɛ a be a wʊ nɛ'maa tʊ̃mɔ̃ na tʊ̃, tɩchɛ ka baa sɔɔ de wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Nɛbier ben a yɩn Korajin dẽme sɛ̃. Nɛbier mɩ ben a yɩn Betɩsaida dẽme sɛ̃. A a ɩ a nɛ'maa tʊ̃mɔ̃ ala ɩn tʊ̃ a yɩ jie, mɩ ta tʊ̃n be a lɛ a Tire nɩ a Sidon tẽn pɔ, ban taa lɩɛb a ba tɩɛr na ba su bʊ̃jarsɩ jɛn tãpɩɛl pɔ. ");
INSERT INTO biv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tɩchɛ n 'yɛrɛ na kʊrɔ yɩ ɩka a 'yɛr tɔɔrfʊ daar Nãaŋmɩn na kãan a Tire nɩ a Sidon nɩbɛ nɩbaal gar a yɩn. ");
INSERT INTO biv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A yɩn Kapenahum dẽme, ban 'mɔɔ yɩn don saaju bɩɩ? Kai, ban suun yɩn a kpĩisɩ tẽe. Ala ɩ a nɛ'maa tʊ̃mɔ̃ na tʊ̃ a yɩ pɔ mɩ ta tʊ̃n a Sodom pɔ, a tẽe anyãna naa chɛnɛ na wa tɔ dɩna. ");
INSERT INTO biv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tɩchɛ n 'yɛrɛ na kʊrɔ yɩ ɩka a 'yɛr tɔɔrfʊ daar Nãaŋmɩn na kãan Sodom nɩbɛ nɩbaal gar a yɩn.” ");
INSERT INTO biv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","A daar 'lɔ̃nɔ̃ Yesu 'yɛr naa, “N dãn a n Sãa Nãaŋmɩn na ɩ a saaju nɩ a tẽe wʊ jaa Soro, bojũu fʊ sɔɔl a yele anyãna a yɛ̃n dẽme sɛ̃ tɩ ir wiil bibiir. ");
INSERT INTO biv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɔ̃ɔ, n Sãa lɛ lɛ ɩ a fʊ pʊpɛl ka fʊ maal. ");
INSERT INTO biv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“N Sãa den a yele a jaa kʊ, nɩrɛ jaa ba bɔ̃ɔ a Bie ɛ, ka a Sãa ba lɛ ɛ, nɩrɛ jaa mɩ ba bɔ̃ɔ a Sãa ɛ, ka a Bie ba lɛ ɛ, nɩ a bala a Nãaŋmɩn Bie na ir, na wiil ban a Sãa. ");
INSERT INTO biv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Yɩ wa a n sɛ̃, yɩn banyã na bal na yɩ tuo tuor ka a wõnõ yɩ, ɩn too yɩn a yɩ pɛ̃n. ");
INSERT INTO biv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yɩ de a n daa tuo na yɩ jãn yi a n sɛ̃, bojũu n ɩn jomm sʊɔ, naa siir a n mãɛ a n nyãa pɔ, yɩn nyɛn pɛ̃nfʊ kʊ a yɩ sɩɩr. ");
INSERT INTO biv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bojũu a n daa ɩn kɔ̃mɔ̃kɔ̃mɔ̃, ka yɩn tʊ̃ɔ tuo a tuor ala ɩn na kʊ yɩ.” ");
INSERT INTO biv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","A ba kor ɛ tɩchɛ ka Yesu kpɛ a pʊɔ sãlsɔɔ tala a Pɛ̃nfʊ Bɩbir Daar. Kɔ̃ kpɛ̃n a wʊ poturbo, ka ba piel fɔrɔ a bʊ̃bie ɔɔrɔ. ");
INSERT INTO biv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","A Faraseemɩne na wa nyɛ a lɛ, ba sʊʊr a Yesu, “Fʊ nyɛn lɛ na ba tu a nɛbinãa a fʊ poturbo na ɩrɛ a Pɛ̃nfʊ Bɩbir Daar ɔ?” ");
INSERT INTO biv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ka a Yesu 'yɛr kʊ ba, “Yaa kar a Nãaŋmɩn gãn pɔ nyɛ a lɛ a Nãa David na dɔ̃ɔ ɩ nɩ a wʊ nɩbɛ a kɔ̃ na kpɛ ɛ? ");
INSERT INTO biv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wʊ kpɛ̃n a Nãaŋmɩn yir ka 'lɔ nɩ a wʊ nɩbɛ tɩ de a paanʊ̃ɔ 'lɔ ban ben kʊ Nãaŋmɩn na ba 'wɔb na ba tara sɔr ɛ, ka ala ba ɩ a Juu nɩbɛ bɔɔrloro tɛɛ ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bɩɩ yaa kar a Mosesɩ nɛbinãa pɔ lɛ a Juu nɩbɛ bɔɔrlorbo a Pɛ̃nfʊ Bɩbir Daar a puorfʊ yir pɔ na ma tʊ̃ tɩ na baa bʊɔlɔ a lɛ bier ɛ? ");
INSERT INTO biv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, nɩrɛ kɔ̃ɔ ben ka na gar a puorfʊ yir. ");
INSERT INTO biv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","A Nãaŋmɩn 'yɛr a, ‘Nɩbaal lɛ n bʊɔrɔ, a ba ɩ dʊ̃n yɩn kʊ chʊm kʊ ma ɛ.’ Yɩn ta bɔ̃ɔ a yele nyã par, yɩ kʊ naa bʊɔlɔ nɩbɛ na ba maal dɛɛr ɛ, ɩka bier lɛ ba maal ɛ. ");
INSERT INTO biv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","A maa Nɩsaal Bie lɛ ɩ a Pɛ̃nfʊ Bɩbir Soro.” ");
INSERT INTO biv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu yin a be chen a ba lɔ̃ɔfʊ yir pɔ, ");
INSERT INTO biv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","tɩ nyɛ daba kɔ̃ɔ nũu na kpi. Ka ba sʊʊr wʊ, “A tara na sɔr ɩka fʊ sãa baal a Pɛ̃nfʊ Bɩbir Daar ɔ?” Ba sʊʊr a lɛ bʊɔrɔ ɩka ba nyɛ a wʊ pɔ 'yɛr 'yɛr. ");
INSERT INTO biv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu sʊʊr naa, “Ala ɩ a yɩ ãsʊɔ tara na pɛr ka wʊ lo bulo pɔ a Pɛ̃nfʊ Bɩbir Daar, ŋmɛ lɛ fʊn ɩ? A ba ɩ fʊn ir wʊn a bɔɔ pɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A nɩsaal gar pɛr. A lɛ jũu a sɩ nɛbinãa bar sɔr ɩka fʊ maal vɩla kʊ nɩrɛ a Pɛ̃nfʊ Bɩbir Daar.” ");
INSERT INTO biv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wʊ 'yɛr kʊ a daba 'lɔ nũu na kpi, “Tur a fʊ nũu.” A wʊ tur ka a nũu wʊ jaa sa kaara a nũu nyã sʊɔ kaar. ");
INSERT INTO biv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A Faraseemɩne yin na ba piel guoro a Yesu kʊfʊ. ");
INSERT INTO biv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu na wa bɔ̃ɔn a lɛ ban piel guoro ɩka ba ɩ wʊ, wʊ yin a jie 'lɔ ka nɩyɔɔ jaa turo wʊ. Wʊ sãan a bala an ɔɔrɔ. ");
INSERT INTO biv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tɩ 'yɛr kʊ ba ɩka ba ta 'yɛr a wʊ yele kʊ nɩrɛ jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Wʊ maal a nɩtɔ̃, ka a lɛ a Nãaŋmɩn na dɔ̃ɔ 'yɛr tu a 'yɛ'yɛrɛ Isaiya na ɩ yelmãɛ, ");
INSERT INTO biv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“A n tʊ̃tʊ̃nɔ̃ lɛ a nyã ɩn kaa ir, a 'lɔ n na nʊ̃, a 'lɔ a n pʊɔ na pɛlʊ. Ɩn yɔ̃ɔ wʊn a n Sɩɛ, ka wʊ mʊɔl a n 'yɛr tɔɔrfʊ yele kʊ a nɩbɛ ba jaa. ");
INSERT INTO biv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wʊ kʊ tara nɛchɩrɛ bɩɩ ŋmiere chɛlsɩ bɩɩ pɔɔrɔ gɔ̃mɔ̃ yõo ɛ. ");
INSERT INTO biv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wʊn siir wʊ mãɛ kʊ a bala na siir a ba mãɛ, tɩ na wʊ maal vɩla kʊ a bala na ba tara sʊ̃nɔ̃ ɛ. Wʊn ara na kpɛ̃ɔ tɩ tãn a sɔ̃ɔ 'lɔ wʊn na vɛ̃ ka a nɩbɛ sɔɔ de a Nãaŋmɩn yeltorsɩ. ");
INSERT INTO biv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","A wʊ yuor pɔ lɛ a nɩbɛ ba jaa na tara tɩɛrtɔ fʊ jie.” ");
INSERT INTO biv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ba waan na daba na ɩ jɔ̃ɔ tɩ ɩ wõo na tara sɩdɛbɛ Yesu sɛ̃. Wʊ sãn a daba baal, ka wʊ nyɛrɛ tɩ lɛ 'yɛrɛ jaa chɛchɛ. ");
INSERT INTO biv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nɛɛr 'maan a nɩyɔɔ ka ba sʊrɔ taa ɩka, kaa 'lɔ lɛ ɩ a Nãa David Bie bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tɩchɛ a Faraseemɩne na wa wõ a lɛ ba 'yɛr naa, “Wʊ dire na sɩdɛbɛ ka a yire bojũu, a sɩdɛbɛ nãa Beeljebul lɛ kʊ wʊ a kpɛ̃ɔ ka wʊ dire nɩ a sɩdɛbɛ.” ");
INSERT INTO biv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu na bɔ̃ɔn a lɛ ban tɩɛrɛ, a wʊ 'yɛr kʊ ba, “Tẽe 'lɔ na ŋma dẽdẽme jɛɛrɛ taa kʊ kor ɛ. Tẽe 'lɔ bɩɩ yir kpɛ̃ɛ 'lɔ na ŋma dẽdẽme jɛɛrɛ taa kʊ ara ɛ. ");
INSERT INTO biv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ala ɩ a Satan diin Satan kʊ yi na wʊ ŋma dẽdẽme ŋmɛ lɛ a wʊ nãalʊ̃ʊ na ɩ ara? ");
INSERT INTO biv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ala ɩ Beeljebul lɛ kʊ ma a kpɛ̃ɔ ka dire nɩ a sɩdɛbɛ, tɩ a bala na ɩ a yɩ poturbo, bo lɛ ba tara dire nɩ a sɩdɛbɛ? A lɛ jũu bala lɛ na ɩ a yɩ 'yɛr tɔɔrbɔ. ");
INSERT INTO biv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ala ɩ Satan diin Satan kʊ yi na wʊ ŋma dẽdẽme ŋmɛ lɛ a wʊ nãalʊ̃ʊ na ɩ ara? Ala ɩ Nãaŋmɩn Sɩɛ lɛ kʊ ma a kpɛ̃ɔ ka dire nɩ a sɩdɛbɛ ka a yire wiil ɩka a Nãaŋmɩn nãalʊ̃ʊ ta yɩ naa. ");
INSERT INTO biv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ŋmɩnɛ lɛ nɩrɛ na tʊ̃ɔ ɩ kar kpɛ gãdaa yir de a wʊ bonsɩ, 'lɔ ba de nie lũ a gãdaa nyã tɩ de a wʊ bonsɩ ɛ? ");
INSERT INTO biv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Nɩrɛ 'lɔ na ba be a n sɛ̃ ɛ, tara man nɩ 'yɛr, nɩrɛ 'lɔ na ba pʊɔ ma a sɩ kaal lɔ̃ɔ taa ɛ wʊ ma yɛ̃yɛl bar. ");
INSERT INTO biv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","A lɛ jũu n 'yɛrɛ na kʊrɔ yɩ ɩka nɩbɛ na nyɛn yelbier jaa nɩ 'yɛrdɛɛr jaa ban 'yɛr vɛ̃ kʊ fʊ, tɩchɛ nɩrɛ 'lɔ na 'yɛr 'yɛrdɛɛr 'yɔ̃ɔ a Nãaŋmɩn Sɩɛ kʊ nyɛ yelbier vɛ̃ kʊ fʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nɩrɛ 'lɔ jaa na 'yɛr 'yɛrdɛɛr 'yɔ̃ɔ a maa Nɩsaal Bie na nyɛn yelbier vɛ̃ kʊfʊ, tɩchɛ nɩrɛ 'lɔ na 'yɛr 'yɛrdɛɛr 'yɔ̃ɔ a Nãaŋmɩn Sɩɛ kʊ nyɛ yelbier vɛ̃ kʊ fʊ ɛ. Dɩna nɩ daar kɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ala ɩ tɩɛ vɩɛlɛ na wʊ ma wɔ̃n wɔ̃vɩɛl, ala ɩ tɩɛ ɩn tɩdɛɛr wʊ ma wɔ̃n wɔ̃dɛbɛ. Tɩɛ jaa a wʊ wɔ̃mɔ̃ lɛ ba ma de bɔ̃ɔn wʊ. ");
INSERT INTO biv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yɩn waa bibiir! Ŋmɩnɛ lɛ yɩn tʊ̃ɔ 'yɛr 'yɛr vɩɛlsɩ ala ɩ yɩ ɩn yelbe-ɩrbɛ? A ala na sɛɛ a pʊɔ lɛ a nɛɛ ma 'yɛr. ");
INSERT INTO biv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A nɩsʊ̃ a yelsʊ̃n ala na be a wʊ pʊɔm lɛ wʊ ma 'yɛr, ka a nɩdɛɛr mɩ ma 'yɛr a yeldɛbɛ ala na be a wʊ pʊɔm. ");
INSERT INTO biv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Yelmãɛ jaa lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, a 'yɛr tɔɔrfʊ daar, nɩrɛ jaa na man 'yɛrdɛɛr 'lɔ jaa bʊrɔ na dɔ̃ɔ yi a wʊ nɛɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","A fʊ 'yɛrbie lɛ na wiil a lɛ fʊn be, naa wiil a fʊ sɔ̃ɔnaa.” ");
INSERT INTO biv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Be lɛ ka a nɛɛ wiwiilbe nɩ a Faraseemɩne bamɩne 'yɛr, “Wiwile, sɩ bʊɔrɔ na ɩka sɩ nyɛ nɛ'maa tʊ̃mɔ̃ na ɩ jãnɛ a fʊ jie.” ");
INSERT INTO biv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tɩchɛ ka wʊ 'yɛr kʊ ba, “A yɩn banyãna na ɩ a putudẽme nɩ sɛ̃sɛ̃nbɛ tɩ bʊɔrɔ ɩka n tʊ̃ nɛ'maa tʊ̃mɔ̃ ka a na ɩ jãnɛ, tɩchɛ yɩ kʊ̃ nyɛ ãsʊɔ jaa ɛ ka a Nãaŋmɩn 'yɛ'yɛrɛ Jona jãnɛ ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nɩtãa lɛ a Jona na dɔ̃ɔ gã a jãnele pʊɔm ber ata nɩ tãsɔɔ gbulo ata lɛ mɩ lɛ a Maa Nɩsaal Bie mɩ na gã a yaa pɔ ber ata nɩ tãsɔɔ gbulo ata. ");
INSERT INTO biv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","A 'yɛr tɔɔrfʊ daar Ninive nɩbɛ na yin 'yɔ̃ɔ a yɩn dɩna nɩbɛ 'yɛr, bojũu ba lɩɛb a ba tɩɛr a Jona na dɔ̃ɔ 'yɛr a Nãaŋmɩn 'yɛr kʊ ba, tɩchɛ yɩ kaa, a 'lɔ na gar a Jona ben ka. ");
INSERT INTO biv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","A pɔɔ nãa na yin be a par a 'yɛr tɔɔrfʊ daar na wʊ wa 'yɔ̃ɔ a yɩn dɩna nɩbɛ 'yɛr, bojũu wʊ dɔ̃ɔ yi be a tẽtɛɛr wa chɛl a Nãa Solomon yɛ̃ 'yɛr, tɩchɛ yɩ kaa a 'lɔ na gar a Solomon ben ka. ");
INSERT INTO biv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Sɩdɛɛr wa yɩ nɩrɛ pɔ, wʊ ma chen dãlpʊʊr pɔ tɩ bʊɔrɔ pɛ̃nfʊ jie 'lɔ baa wa nyɛ ɛ, ");
INSERT INTO biv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","wʊ ma 'yɛr naa ɩn lɩɛb kul a yir 'lɔ pɔ ɩn dɔ̃ɔ yɩ. Wʊ wa nyɛn a yir ka wʊ ɩ yirkpolo na wʊ vɩɛlɛ, ");
INSERT INTO biv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ka wʊ chen tɩ bʊɔl sɩdɛbɛ ayopõi na tara a putuo gar wʊ ka ba tɩ kpɩɛrɛ a be. Ka a nɩrɛ nyã pãa ɩ dɛɛr gar a lɛ wʊn dɔ̃ɔ be. Lɛ lɛ an kaara a yɩn putudẽme a dɩna.” ");
INSERT INTO biv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Wʊn chɛnɛ 'yɛrɛ nɩ a nɩyɔɔ, a wʊ ma nɩ a wʊ yɛɛr wa ben yõo bʊɔrɔ ɩka ba nyɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nɩrɛ ãsʊɔ 'yɛr kʊ wʊ, “Nyɛ a fʊ ma nɩ a fʊ yɛɛr lɛ be yõo bʊɔrɔ ɩka ba nyɛ fʊ.” ");
INSERT INTO biv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tɩchɛ Yesu sʊʊr a nɩrɛ 'lɔ na 'yɛr a 'yɛr kʊ wʊ, “An lɛ a ɩ ma nɩ ba boo lɛ ɩ a n yɛɛr?” ");
INSERT INTO biv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Wʊ lɩɛb tur a wʊ poturbo nũu tɩ 'yɛr, “Nyɛ a n ma nɩ a n yɛɛr! ");
INSERT INTO biv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nɩrɛ 'lɔ jaa na maala a lɛ a n Sãa na be a saaju na bʊɔrɔ lɛ ɩ a n yɛɛr nɩ a n ma.” ");
INSERT INTO biv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A daar 'lɔ̃nɔ̃ Yesu yin a yir pɔ tɩ jãnɛ a man kõkoor. ");
INSERT INTO biv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","A nɩyɔɔ na lɔ̃ɔ jũu wʊ kpɛ̃n jɛ̃ a gboro pɔ, tɩchɛ ka a nɩyɔɔ ara a man kõkoor. ");
INSERT INTO biv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sʊkpar lɛ wʊ lɔɔrɔ wile nɩ ba yelyɔɔ, “Yɩ chɛlɛ, kʊɔraa lɛ yin wʊ bʊ̃bʊrɔ bʊrfʊ jie. ");
INSERT INTO biv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wʊ tɩ yaara na yʊɔrɔ nɩ ka amɩne lo sɔr pɔ, ka lubil tuur di. ");
INSERT INTO biv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A bʊ̃bie amɩne mɩ lon kʊsɩr pãn ju naa bul tɩ kpi bojũu tãn ba waa ɛ. ");
INSERT INTO biv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tɩchɛ a mɔ̃tɔ̃ɔ na wa nyãa, a bʊ̃bulo jʊɔl naa kpi, bojũu a ba ba nyɩbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ka amɩne mɩ lo gʊʊr pɔ 'mataa bul ka a gʊʊr nʊ̃ɔ fãɩn ba. ");
INSERT INTO biv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tɩchɛ amɩne mɩ lon kɔjɔ̃ pɔ bul dɔɔ jur kɔbaa, amɩne lɩjaata amɩne lɩjɛr nɩ pie. ");
INSERT INTO biv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nɩrɛ 'lɔ na tara toor wʊ chɛlɛ.” ");
INSERT INTO biv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","A poturbo wan a wʊ sɛ̃ wa sʊʊr, “Bo lɛ so fʊn ma lɔɔrɔ a sʊkpar kʊrɔ ba?” ");
INSERT INTO biv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ka wʊ 'yɛr kʊ ba, “Yɩn 'lɔ ɩn vɛ̃ naa ka yɩ bɔ̃ɔ a Nãaŋmɩn nãalʊ̃ʊ yelsɔɔlsɩ tɩchɛ a bala na chɛ sʊkpar lɛ n lɔɔrɔ kʊrɔ ba. ");
INSERT INTO biv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nɩrɛ 'lɔ jaa na tara Nãaŋmɩn tɩɛr, Nãaŋmɩn na vɛ̃n ka a nɩnyɩnɛ bɔ̃ɔfʊ pʊɔ 'yɔ̃ɔ, tɩchɛ a bala jaa na ba bʊɔrɔ a wʊ bɔ̃ɔfʊ ɛ, Nãaŋmɩn na pɔɔn a ba tɩɛr. ");
INSERT INTO biv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","A par nɩ nyã ɩn lɔɔrɔ a sʊkpar kʊrɔ ba, ba ma kaa naa tɩ maa nyɛ ɛ, na ba ma wõ tɩ maa bɔ̃ɔ a par ɛ. ");
INSERT INTO biv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bala 'lɔ an ɩn yelmãɛ ɩka a lɛ a Nãaŋmɩn 'yɛ'yɛrɛ Isaiya na dɔ̃ɔ 'yɛr ɩka, ‘A nɩbɛ banyã na ma wõ naa tɩ ba kʊ̃ bɔ̃ɔ a par ɛ, ban ma kaa naa tɩ ba kʊ̃ nyɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","A nɩbɛ banyã nyãn dar naa ka a ba tobo pɔɔ baa wõnõ ɛ, na ba ũu a ba nɩbie, ka lɛ ba lɛ ɛ, ban taa kãan naa a ba nɩbie na ba wõn a ba tobo, na ba bɔ̃ɔ a par, na ba lɩɛb wa ka n sãa ba.’ ");
INSERT INTO biv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tɩchɛ yɩn 'lɔ, yɩ ɩn bɔɔsʊ̃n dẽme, a yɩ nɩbie na nyɛ, ka a yɩ tobo mɩ wõ. ");
INSERT INTO biv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka Nãaŋmɩn 'yɛ'yɛrbɛ yɔɔ nɩ nɩtorsɩ yɔɔ ta bʊɔrɔ na ɩka ba nyɛ bon 'lɔ yɩn nyɛ tɩchɛ baa nyɛ ɛ, na ba ta wõ bon 'lɔ yɩn wõ tɩchɛ baa tʊ̃ɔ wõ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Yɩ pãa chɛlɛ a kʊɔraa sʊkpa par, ");
INSERT INTO biv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nɩrɛ 'lɔ jaa na wõ a Nãaŋmɩn nãalʊ̃ʊ 'yɛr tɩ ba bɔ̃ɔ a par ɛ, a dɛɛr sʊɔ ma wan wa ir a bon 'lɔ na bʊr a wʊ nyãa pɔ, a bʊ̃bie anyã lɛ, a ala na lo a sɔr pɔ. ");
INSERT INTO biv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ala mɩ na lo a kʊsɩr pãn ju lɛ a nɩrɛ 'lɔ na wõ a 'yɛr sɔɔ de fɔfɔɔ jaa nɩ pʊpɛl, ");
INSERT INTO biv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","tɩchɛ a nɩrɛ nyã ba ba nyɩbɛ ɛ, na wʊ di kãnyir ara bãlãa, a lɛ jũu wõm bɩɩ bɛɛr kaa wa pɔɔ wʊ a 'yɛr jũu, a nɩrɛ nyã ma lo naa. ");
INSERT INTO biv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A bʊ̃bie ala mɩ na lo a gʊʊr pɔ, 'lɔ lɛ a nɩrɛ 'lɔ na wõ a 'yɛr tɩ nʊ̃ a wɛr ju nyɛvʊr yelwõnsɩ nɩ a wɛr ju bʊ̃bʊɔrsɩ fãɩn a 'yɛr ka waa dɔɔ bie ɛ. ");
INSERT INTO biv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tɩchɛ a bʊ̃bie ala na lo a kɔjɔ̃ pɔ lɛ a nɩrɛ nyã na wõ a 'yɛr bɔ̃ɔ a par, 'lɔ lɛ wɔ̃ wɔ̃mɔ̃ dɔɔ jur, amɩne kɔbaa, amɩne lɩjaata amɩne mɩ lɩjɛr nɩ pie.” ");
INSERT INTO biv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu lɛ lɔb a sʊkpa ãsʊɔ kʊ ba, “Nɩtɔ̃ lɛ ɩn de a Nãaŋmɩn nãalʊ̃ʊ man. Nɩrɛ ãsʊɔ lɛ bʊr bʊ̃bivɩɛl a wʊ pʊɔ pɔ, ");
INSERT INTO biv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","nɩrɛ jaa na wa gã gur baar, a dɔ̃sʊɔ wan wa bʊr mɔɩ 'yɔ̃ɔ a chi pɔ tɩ na wʊ kul. ");
INSERT INTO biv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","A sɔ̃ɔ 'lɔ a chi na wa tɩ bulo ka a mɔɩ mɩ bul puro. ");
INSERT INTO biv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“A daba tʊ̃tʊ̃nbɔ wan wa sʊʊr wʊ, ‘Nɩkpɛ̃ɛ, a ba ɩ bʊ̃bivɩɛl lɛ fʊ bʊr a pʊɔ pɔ ɛ; tɩ nyɛ a mɔɩ mɩ yi?’ ");
INSERT INTO biv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ka wʊ 'yɛr kʊ ba, ‘Dɔ̃sʊɔ lɛ tʊ̃ a lɛ.’ A tʊ̃tʊ̃nbɔ sʊʊr wʊ, ‘Fʊ bʊɔrɔ na ɩka sɩ chen tɩ vɔ̃ a mɔɩ bar bɩɩ?’ ");
INSERT INTO biv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ka wʊ 'yɛr kʊ ba, ‘Kai, yɩn be vɔ̃nɔ̃ a mɔɩ, yɩn wa vɔ̃n a chi mɩ bar. ");
INSERT INTO biv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yɩ bar ka a 'mataa nʊ̃ɔ tɩ tãn a ŋmafʊ daar, ɩn 'yɛr kʊ a ŋmaŋmarba ka ba dɔ̃ɔ vɔ̃ a mɔɩ lũ lũ chʊm bar tɩ ŋma a chi 'yɔ̃ɔ a n boor pɔ.’ ” ");
INSERT INTO biv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu lɛ lɔb a sʊkpa ãsʊɔ kʊ ba go, “A Nãaŋmɩn nãalʊ̃ʊ kaara naa fɩka kɔ̃kɔ̃ɔ bir nɩrɛ na de bʊr a wʊ pʊɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","'Lɔ lɛ a bʊ̃bie a jaa pɔ bʊ̃bile tɩchɛ 'lɔ wa nʊ̃ɔ, 'lɔ lɛ ma ɩ a tɩɩr a jaa pɔ tɩkpɛ̃ɛ, ka lubil ma 'yɔ̃ɔ choor a wʊ ju.” ");
INSERT INTO biv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wʊ lɛ lɔb a sʊkpa ãsʊɔ kʊ ba, “A Nãaŋmɩn nãalʊ̃ʊ kaara naa fɩka dãbɩl pɔɔ na de 'yɔ̃ɔ jɔ̃ yɔɔ pɔ ka a ir vʊ̃.” ");
INSERT INTO biv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu den sʊkpar 'yɛrɛ kʊrɔ nɩ a nɩyɔɔ a yelsɩ anyã, wʊ maa 'yɛr 'yɛr kʊ ba ka waa lɔb sʊkpa ɛ. ");
INSERT INTO biv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A nyã lɛ na wiil ɩka a lɛ a Nãaŋmɩn 'yɛ'yɛrɛ na dɔ̃ɔ 'yɛr ɩn yelmãɛ, “Ɩka ɩn ma den a n nɛɛ lɔɔrɔ nɩ sʊkpar naa wiil yɩ yelsɩ ala na sɔɔl a wɛr pielfʊ daar.” ");
INSERT INTO biv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Wʊ yin a nɩyɔɔ pɔ kpɛ a yir, ka a wʊ poturbo wa a wʊ sɛ̃ wa 'yɛrɛ, wiil sɩ a mɔɩ na be a pʊɔ pɔ sʊkpa par. ");
INSERT INTO biv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ka wʊ 'yɛr kʊ ba, “A nɩrɛ 'lɔ na bʊr a bʊ̃bivɩɛl lɛ a maa Nɩsaal Bie. ");
INSERT INTO biv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A pʊɔ lɛ ɩ a wɛr. A bʊ̃bivɩɛl lɛ a Nãaŋmɩn nãalʊ̃ʊ bibiir. A mɔɩ lɛ a bala na ɩ a dɛɛr sʊɔ bibiir. ");
INSERT INTO biv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","A dɔ̃sʊɔ 'lɔ mɩ na bʊr lɛ ɩ a tɩɩ. A ŋmafʊ lɛ ɩ a wɛr baarfʊ daar, a ŋmaŋmarba lɛ ɩ a Nãaŋmɩn malakasɩ. ");
INSERT INTO biv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Lɛ ban na chʊm a mɔɩ bũu pɔ ka a di, lɛ mɩ lɛ na ɩ a wɛr baarfʊ daar. ");
INSERT INTO biv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","A maa Nɩsaal Bie na tʊ̃n a n malakasɩ ka ba wa tuur a nɩsʊ̃n a nãalʊ̃ʊ pɔ, tɩchɛ a bala jaa na vɛ̃ ka a nɩbɛ maala yelbier nɩ yelbe-ɩrbɛ ba jaa 'mataa bar. ");
INSERT INTO biv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ka ba lɔb ba 'yɔ̃ɔ bũu dagel pɔ, be lɛ ban kõnõ ɔɔrɔ nɩ nyɩmɛ. ");
INSERT INTO biv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A bala na tor na chaar naa mɔ̃tɔ̃ɔ kaar a ba Sãa nãalʊ̃ʊ pɔ. Nɩrɛ 'lɔ na tara tobo wʊ chɛlɛ. ");
INSERT INTO biv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“A Nãaŋmɩn nãalʊ̃ʊ kaara naa fɩka nɩrɛ na nyɛ nãbonsɩ pʊɔ pɔ 'mɔɔ sɔɔl tɩchɛ ka a wʊ pʊɔ pɛl, ka wʊ tɩ da a wʊ bonsɩ a jaa wʊn tara tɩ dãn a puo. ");
INSERT INTO biv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“A Nãaŋmɩn nãalʊ̃ʊ lɛ kaara naa fɩka nɩrɛ na yʊɔrɔ bʊɔrɔ kʊsɩvɩɛl, ");
INSERT INTO biv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","wʊn wa nyɛ a ãsʊɔ daa na be tuo, wʊ tɩ dãn a wʊ bonsɩ a jaa tɩ dãn. ");
INSERT INTO biv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“A Nãaŋmɩn nãalʊ̃ʊ lɛ nyɛntãan fɩka lɔyaar ban lɔb 'yɔ̃ɔ man pɔ, kʊ nyɔɔr jãdẽdẽme. ");
INSERT INTO biv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","A lɔyaar na wa sɛɛ ba tɔɔn yin a gogoro ju, tɩ jãnɛ tuur a jãsʊ̃n 'yɔ̃ɔ a pɛr pɔ, tɩ lɔb a jãdɛbɛ bar. ");
INSERT INTO biv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Lɛ lɛ an be a wɛr baarfʊ daar. A Nãaŋmɩn na tʊ̃n a wʊ malakasɩ ka ba wa tuur a nɩdɛbɛ yin a nɩmɩn pɔ, ");
INSERT INTO biv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","tɩ na ba lɔb a nɩdɛbɛ 'yɔ̃ɔ a bũu dagel pɔ, be lɛ ban kõnõ tɩ ɔɔrɔ nyɩmɛ. ");
INSERT INTO biv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Yɩ bɔ̃ɔn a yelsɩ anyã na a jaa par ɔ?” Ka ba 'yɛr, “Ɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ka wʊ 'yɛr kʊ ba, “A nɛɛ wile ãsʊɔ jaa ban wiil ka wʊ bɔ̃ɔ a Nãaŋmɩn nãalʊ̃ʊ yele kaara naa fɩka yir sʊɔ na de bʊ̃paalaa nɩ bʊ̃koro yin a wʊ boor pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu na wa wiil a sʊkpar anyã par, wʊ yin a be. ");
INSERT INTO biv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Wʊ wan a wʊ mãɛ paal pɔ tɩ piel wile a nɩbɛ a ba lɔ̃ɔfʊ jiir, ka nɛɛr 'maa ba ka ba 'yɛr, “Nyɛ lɛ a daba nyã nyɛ a yɛ̃ nyã nɩ a nɛ'maa tʊ̃mɔ̃ a nyã? ");
INSERT INTO biv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","A ba ɩ a mɩmɩɛrɛ bidaba lɛ ɛ? A ba ɩ a wʊ ma lɛ ba bʊɔlɔ a Mɛɛr ɛ? A ba ɩ a wʊ yɛɛr nɩ Jemesɩ nɩ Josefʊ nɩ Simon nɩ Judas ɛ? ");
INSERT INTO biv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A ba ɩ sɩn nɩ a wʊ yɛpɔbɔ ba jaa lɛ 'mataa be a ka ɛ? Nyɩnɛ lɛ a daba nyã nyɛ a kpɛ̃ɔ nyã?” ");
INSERT INTO biv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tɩ na ba tɔr a wʊ yele. Tɩchɛ ka a Yesu 'yɛr kʊ ba, “Nãaŋmɩn 'yɛ'yɛrɛ nyɛrɛ na 'yɔ̃ɔfʊ jie jaa tɩchɛ a wʊ mãɛ tẽe nɩ a wʊ mãɛ yir pɔ, wʊ maa nyɛ 'yɔ̃ɔfʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ban ba sɔɔ de wʊ jũu, waa tʊ̃ɔ tʊ̃ nɛ'maa tʊ̃yɔɔ a be ɛ. ");
INSERT INTO biv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A ber ala pɔ, a Hɛrɔd na ɩ a Galilee nãa wõn a Yesu yele ");
INSERT INTO biv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","na wʊ 'yɛr kʊ a wʊ tʊ̃tʊ̃nbɔ, “Jɔɔn Kɔ̃suor lɛ tɔ̃ɔ ir ɩ vʊr, ala lɛ so ka wʊ tara a kpɛ̃ɔ tʊ̃nɔ̃ nɩ a nɛ'maa tʊ̃mɔ̃ anyãna.” ");
INSERT INTO biv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","A Nãa Hɛrɔd vɛ̃n ka ba nyɔɔ Jɔɔn lũ 'yɔ̃ɔ nɩpɔɔ die pɔ a wʊ yɛbɛ Filip pɔɔ Hɛrɔdiyas jũu. ");
INSERT INTO biv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Bojũu Jɔɔn ma 'yɛrɛ na kʊrɔ wʊ ɩka, “A ba tara sɔr ka fʊ kul wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hɛrɔd ta bʊɔrɔ na a wʊ kʊ fʊ tɩ joro a Juu nɩbɛ dãbãɛ bojũu ba sɔɔn ɩka wʊ ɩn Nãaŋmɩn 'yɛ'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","A Hɛrɔd dɔɔfʊ bɩbir dãɛn daar, a Hɛrɔdiyas bipɔɔ sɛn bãnɛ a nɩyɔɔ niem, ka a Hɛrɔd pʊɔ pɛl ");
INSERT INTO biv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yɔɔ jaa ka wʊ 'yɔ̃ɔ nɛɛ kʊ a pɔɔbile, “Sʊɔr ma bon jaa fʊn bʊɔrɔ ɩn kʊ fʊ naa.” ");
INSERT INTO biv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A wʊ ma wiil wʊn a bon 'lɔ wʊn na sʊɔr, ka wʊ 'yɛr, “N bʊɔrɔ na ɩka fʊ 'yɔ̃ɔ a Jɔɔn Kɔ̃suor ju a la'yɛlma pɔ kʊ ma a pʊ̃pãanyãna.” ");
INSERT INTO biv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","A nãa pʊɔ sɔ̃ɔ naa, tɩchɛ wʊn faa 'yɔ̃ɔ a nɛɛ a nɩyɔɔ niem ɩka a lɛ a pɔɔbile na bʊɔrɔ a ɩ. ");
INSERT INTO biv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Wʊ tʊ̃n ka ba ŋmaa a Jɔɔn ju a nɩpɔɔ die pɔ. ");
INSERT INTO biv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ba 'yɔ̃ɔn a ju a la'yɛlma pɔ wa kʊ a pɔɔbile, ka wʊ de kʊ a wʊ ma. ");
INSERT INTO biv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jɔɔn poturbo wan wa 'mɔɔ a ãgãn tɩ ũu tɩ na ba tɩ 'yɛr kʊ a Yesu. ");
INSERT INTO biv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","A Yesu na wa wõ a nɩtɔ̃, wʊ kpɛ̃n a gboro chen jiyuo 'lɔ wʊ yõ. Tɩchɛ a nɩyɔɔ na wa wõ a nɩtɔ̃ ba yin a tẽn ala pɔ bɩɛr wʊ nɩ gbɛɛ chen a be. ");
INSERT INTO biv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wʊn wa yi a gboro pɔ, wʊ nyɛn nɩyɔɔ ka nɩbaal kpɛ wʊ tɩchɛ ka wʊ sãa a ba baalsɩ. ");
INSERT INTO biv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mɔ̃tɔ̃ɔ na wa mʊrɔ, a poturbo wa 'yɛr kʊ wʊ, “A ka ɩn mɔgɔ̃ɔ pɔ ka a sɔ̃ɔ mɩ po, bar a nɩbɛ sɔr ka ba chen a tẽbil pɔ, tɩ da bʊ̃diir di.” ");
INSERT INTO biv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu 'yɛr kʊ ba, “A ba sɛɛ ɩka ba chen ɛ, yɩ kʊ ba bʊ̃kɔ̃ɔ ka ba di.” ");
INSERT INTO biv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ka ba 'yɛr kʊ wʊ, “Paanʊ̃ɔsɩ anũu nɩ jãmɛ ayi tɛɛ lɛ sɩ tara.” ");
INSERT INTO biv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ka wʊ 'yɛr kʊ ba, “Yɩ de wa kʊ ma.” ");
INSERT INTO biv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wʊ vɛ̃n ka a nɩyɔɔ banyãna jɛ̃ tẽe. Wʊ den a paanʊ̃ɔsɩ anũu nɩ a jãmɛ ayi ala dʊl kaa saaju tɩ puor Nãaŋmɩn yãan tɩ na wʊ ŋma de kʊ a poturbo ɩka ba de põ a nɩbɛ. Ka a poturbo de põ a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ba jaa din tɩɩ tɩchɛ ka a poturbo wob a bʊ̃ŋmaarsɩ ala na chɛ sɛɛ pɛr pie nɩ ayi. ");
INSERT INTO biv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A bala na di tɩɩ tɛɛ ɩn dɔɔr tur anũu ka pɔbɔ nɩ bibiir ba pʊɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ajienaa lɛ, wʊ vɛ̃n ka a poturbo kpɛ a gboro gɔ̃ɔ a man gɔ̃ɔn tɩchɛ ka wʊ vɛ̃ ka a nɩbɛ yaar. ");
INSERT INTO biv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wʊn wa wɛl a nɩbɛ baar, wʊ don a tɔ̃ɔ ju ɩka wʊ tɩ sʊɔr Nãaŋmɩn. Jãanʊɔr na wa ta, wʊ chɛnɛ na be a be a wʊ yõ. ");
INSERT INTO biv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tɩchɛ a kɔ̃sɛbɛ ŋmen a gboro dãdaal chiin tɛɛr ka wʊ jãan a man nɛɛ, bojũu a kɔ̃sɛbɛ fɔ̃ɔ gar ba naa. ");
INSERT INTO biv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","A wɛr na wa chaara wa la la la ba nyɛn a Yesu na chiine a kʊ̃ɔ ju waara a ba sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","A poturbo na wa nyɛ a Yesu na chiine a kʊ̃ɔ ju waara a ba sɛ̃, dãbãɛ kpɛ ba naa, ka ba kõ 'yɛr, “Kpĩin lɛ!” ");
INSERT INTO biv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tɩchɛ ka a Yesu 'yɛr kʊ ba, “Yɩ tara kãnyir, maa lɛ, yɩ ta joro dãbãɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita 'yɛr kʊ wʊ, “N Soro, ala ɩ fʊ̃ʊ lɛ vɛ̃ ka chiine a kʊ̃ɔ ju wa a fʊ sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ka wʊ 'yɛr wʊ, “Wa,” ka Pita yi a gboro pɔ piel chiine a kʊ̃ɔ ju waara a Yesu sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pita na nyɛ a sɛsɛbɛ na furo yɔɔ dãbãɛ kpɛ wʊ naa, ka wʊ piel mʊrɔ a kʊ̃ɔ pɔ, ka wʊ bʊɔl, “N Soro, faa ma.” ");
INSERT INTO biv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ajienaa lɛ, a Yesu tur a wʊ nũu nyɔɔ wʊ tɩ 'yɛr, “Fʊ̃ʊ sɔɔfʊ na ba jã bon ɛ, bo so ka fʊ baala?” ");
INSERT INTO biv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ban wa kpɛ a gboro pɔ baar ka a sɛsɛbɛ ŋmaa jaa jomm. ");
INSERT INTO biv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A bala na be a gboro pɔ gbur dumo puor wʊ tɩ 'yɛrɛ, “Yelmãɛ, fʊ̃ʊ lɛ ɩ a Nãaŋmɩn Bie.” ");
INSERT INTO biv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ban wa gɔ̃ɔ a man baar ba chen a Genesaretɩ wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","A tẽe 'lɔ dẽme na wa wõ a wʊ yele ba 'yɛr lʊɔr a paal 'lɔ wʊ jaa na ba waan bala jaa an ɔɔrɔ, ");
INSERT INTO biv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","na ba wa sʊɔrɔ ɩka ba sɩɩr a wʊ fuu nɛɛ, a bala jaa na sɩɩr a fuu nɛɛ sa naa. ");
INSERT INTO biv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","A Faraseemɩne nɩ a nɛɛ wiwiilbe bamɩne na yi a Jerusalɛm wan a Yesu sɛ̃ wa sʊʊr wʊ, ");
INSERT INTO biv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ŋmɩnɛ a fʊ poturbo ba turo a sɩ sãakpãmɩne wiilfʊ ɛ? Ba maa pɛɛ a ba nuur tɩ di ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ka a Yesu 'yɛr kʊ ba, “Ŋmɩnɛ ka yɩ sɔ̃ɔ a Nãaŋmɩn nɛbinsɩ tɩ na yɩ turo a yɩ mãɛ wiilfʊ? ");
INSERT INTO biv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nãaŋmɩn 'yɛr naa, ‘'Yɔ̃ɔnɔ̃ a fʊ sãa nɩ a fʊ ma,’ ka ‘Nɩrɛ jaa wa pɔ 'yɔ̃ɔ a wʊ sãa bɩɩ a wʊ ma, ba kʊ wʊ.’ ");
INSERT INTO biv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tɩchɛ yɩn 'yɛr ɩka nɩrɛ 'lɔ jaa na 'yɛr a wʊ sãa bɩɩ ma ɩka, sʊ̃ʊfʊ 'lɔ jaa ɩn tara naa kʊ fʊ, n den kʊ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tɩchɛ na waa de a wʊ bʊ̃tarsɩ 'yɔ̃ɔnɔ̃ nɩ a a wʊ sãa ɛ, yɩn ɩ a lɛ, yɩ sɔ̃ɔn Nãaŋmɩn nɛɛ, tɩ na yɩ turo a yɩ mãɛ binfʊ. ");
INSERT INTO biv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yɩn nɛɛr ayi dẽme! Isaiya 'yɛr yelmãɛ nɩ wʊn dɔ̃ɔ 'yɛr ɩka, ");
INSERT INTO biv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘A nɩbɛ banyãna den a ba nɛɛr 'yɔ̃ɔnɔ̃ nɩ ma tɩchɛ a ba nyãn pɔ, ba tɔɔn jãan ma. ");
INSERT INTO biv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","A ba puorfʊ ba tara tɔ̃nɔ̃ kʊ ma ɛ, nɩsaal wiilfʊ lɛ ba wile.’ ” ");
INSERT INTO biv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu bʊɔl a nɩyɔɔ a ba wa a wʊ sɛ̃, ka wʊ 'yɛr kʊ ba, “Yɩ chɛlɛ na yɩ bɔ̃ɔ a par. ");
INSERT INTO biv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A ba ɩ bon 'lɔ na ma tu a nɩsaal nɛɛ pɔ kpɛ lɛ ma sɔ̃ɔ wʊ ɛ, tɩchɛ bon 'lɔ na ma yɩ a nɩsaal nɛɛ pɔ lɛ ma sɔ̃ɔ wʊ.” ");
INSERT INTO biv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","A poturbo wa 'yɛr kʊ wʊ, “Fʊ bɔ̃ɔn naa an kpɛ a Faraseemɩne ban wõ a 'yɛr nyã fʊn 'yɛr ɔ?” ");
INSERT INTO biv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ka wʊ 'yɛr, “Tɩɛ 'lɔ jaa a n Sãa na be a saaju na ba sɛl ɛ, ɩn vʊ̃ɔ wʊn bar. ");
INSERT INTO biv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yɩ bar ba, jɔ̃n lɛ tɔɔrɔ jɔ̃n. Jɔ̃ɔ wa tɔɔrɔ a wʊ jɔ̃ɔ tɔ sʊɔ ba jaa ma lon bɔɔ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tɩchɛ ka Pita 'yɛr kʊ wʊ, “Wiil a sʊkpa nyã par kʊ sɩ.” ");
INSERT INTO biv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Be lɛ wʊ 'yɛr, “A yɩn mɩ na ɩ a n poturbo ba bɔ̃ɔ a par ɛ? ");
INSERT INTO biv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yaa bɔ̃ɔ ka bon 'lɔ jaa na tu a nɛɛ pɔ kpɛ a pʊɔ pɔ ma tun a par bɔɔ pɔ yi bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tɩchɛ bon 'lɔ na ma yi a nɛɛ pɔ, yin a tɩɛr pɔ, anyãna lɛ ma sɔ̃ɔ a nɩsaal. ");
INSERT INTO biv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","A nɩsaal tɩɛr pɔ lɛ a tɩɛr dɛbɛ ma yi, nɩrɛ kʊfʊ, pɔɔdeyele, sɛ̃sɛ̃yele, nãnyiyele, jir dãasɩɛ, nɩ a gagaryele ma be. ");
INSERT INTO biv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","A anyãna lɛ a bonsɩ ala na ma sɔ̃ɔ a nɩsaal tɩchɛ nɩrɛ na din nũdɛbɛ ba sɔ̃ɔnɔ̃ wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu yin a be chen a Tire paal nɩ Sidon paal pɔ. ");
INSERT INTO biv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Be lɛ a pɔɔ na yi a Kanaan paal pɔ yi piel ŋmiere chɛlsɩ, “N Soro kaa a n nɩbaal David Bie, a sɩdɛɛr lɛ tara a n bipɔɔ.” ");
INSERT INTO biv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tɩchɛ a Yesu ba 'yɛr 'yɛr jaa kʊ wʊ ɛ. Ka a wʊ poturbo wa 'yɛr kʊ wʊ, “Dii wʊ bar, wʊ pɔɔrɔ sɩn gɔ̃mɔ̃.” ");
INSERT INTO biv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ka wʊ 'yɛr, “A piir ala na bɔr a Isɩral nɩbɛ pɔ tɛɛ 'yɔ̃ɔ lɛ ba tʊ̃ ma.” ");
INSERT INTO biv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tɩchɛ ka a pɔɔ wa gbur dumo a wʊ niem 'yɛr, “N Soro, sʊ̃ʊ ma.” ");
INSERT INTO biv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ka a Yesu 'yɛr, “A ba sɛɛ ɩka fʊ de bibiir bʊ̃diir lɔb 'yɔ̃ɔ baar ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ka a pɔɔ 'yɛr, “Ɔ̃ɔ, n Soro, a baar gba ma dire na a bʊ̃di pʊr pʊr ala na ma ŋmara loro a ba nɩkpɛ̃ɛ dakɔɔ pĩlem.” ");
INSERT INTO biv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ka Yesu 'yɛr kʊ a pɔɔ, “Pɔɔ, a fʊ sɔɔfʊ bɛrma naa! A ɩ kʊ fʊ a lɛ fʊn bʊɔrɔ.” A wʊ bipɔɔ sa naa a dẽdẽe daa 'lɔ̃nɔ̃. ");
INSERT INTO biv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu na wa yi a be, wʊ den a Galilee man yal kõkoor 'lana, na wʊ tɩ do tɔ̃ɔ ju jãnɛ. ");
INSERT INTO biv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","A nɩyɔɔ tara na a nɩbɛ gbɛɛ na kpi kpi, nɩ jɔ̃n, nɩ a gbɛrsɩ, nɩ a wõn 'matãan baalsɩ yɔɔ waan a wʊ sɛ̃. Ba wa bin ban a wʊ niem a wʊ sãa a ba jaa baalsɩ. ");
INSERT INTO biv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nɛɛr 'maan a nɩbɛ ban wõ ka a wõn 'yɛrɛ, ka a gbɛrsɩ sa chiine ka a bala a gbɛɛ nɩ na kpi kpi mɩ sa ka a jɔ̃n mɩ nyɛrɛ. Ka ba dãna a Isɩral nɩbɛ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu bʊɔl a wʊ poturbo wa 'yɛr kʊ ba, “Nɩbaal kpɛ ma naa nɩ a nɩyɔɔ banyãna bojũu ba ben a n sɛ̃ ber ata tɩ ba di bon jaa ɛ, n ba bʊɔrɔ ɩka n vɛ̃ ka ba lɩɛb chiine kɔ̃ ɛ, amɩne ban wa lon sɔr pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ka a wʊ poturbo 'yɛr kʊ wʊ, “Nyɛ lɛ sɩn nyɛ paanʊ̃ɔ a dãlpʊɔ nyã pɔ tʊ̃ɔ kãan a nɩyɔɔ banyãna?” ");
INSERT INTO biv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ka Yesu sʊʊr ba, “Paanʊ̃ɔ aŋmɩnɛ lɛ yɩ tara?” Ka ba 'yɛr, “Ayopõi nɩ jãmɛ bãlãa.” ");
INSERT INTO biv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Wʊ vɛ̃n ka a nɩbɛ jãnɛ tẽe. ");
INSERT INTO biv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ka wʊ pãa de a paanʊ̃ɔsɩ ayopõi nɩ a jãbãlãa ala na wʊ puor Nãaŋmɩn yãan, tɩ na wʊ ŋma de kʊ a wʊ poturbo, ka ba de põ a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ba jaa din tɩɩ, ka a poturbo wob a bʊ̃ŋmaar 'yɔ̃ɔ pɛr ayopõi. ");
INSERT INTO biv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A bala na di ɩn dɔɔr tur anaar, ka pɔbɔ nɩ bibiir nũu ba pʊɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Wʊn wa vɛ̃ ka a nɩbɛ yaar baar wʊ kpɛ̃n a gboro na wʊ chen Magadan paal pɔ. ");
INSERT INTO biv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A Faraseemɩne nɩ a Saduseemɩne wan ɩka ba bɛɛr Yesu kaa na ba 'yɛrɛ, “Wiil sɩ nɛ'maa tʊ̃mɔ̃ na ɩ jãnɛ na yi a saaju.” ");
INSERT INTO biv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ka wʊ 'yɛr kʊ ba, “Ala wa ɩ jãanʊɔr lɛ, yɩ ma 'yɛr ɩka a wɛr chaar naa bojũu a saaju mʊ̃ɔ naa. ");
INSERT INTO biv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ala wa ɩ bibio lɛ, yɩ ma 'yɛr ɩka saa na wan a dɩna, a julõjuur sɔb naa ka saa koro. Yɩ ma kãan a saaju tɩ 'yɛr ɩka saa na wan bɩɩ wʊ kʊ̃ wa ɛ, yɩ bɔ̃ɔn a tẽe nɩ a saaju 'yɛr ma 'yɛr, ŋmɩnɛ a yɩ kʊ̃ tʊ̃ɔ bɔ̃ɔ a jãnsɩ a dɩna ɛ? ");
INSERT INTO biv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yɩn yelbe-ɩrbɛ nɩ sɛ̃sɛ̃nbɛ lɛ bʊɔrɔ ɩka n tʊ̃ nɛ'maa tʊ̃mɔ̃ ka yɩ kaa, yɩ kʊ̃ nyɛ nɛ'maa tʊ̃mɔ̃ ka a Jona nɛ'maa tʊ̃mɔ̃ ba lɛ ɛ.” Be lɛ wʊ bar ba tɩ chen. ");
INSERT INTO biv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","A poturbo ĩin ba tʊ̃ɔ de paanʊ̃ɔ ɛ, tɩ na ba gɔ̃ɔ a man gɔ̃ɔn. ");
INSERT INTO biv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ka Yesu 'yɛr kʊ ba, “Yɩ gu yɩ mãɛ a Faraseemɩne nɩ a Saduseemɩne dãbɩl pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ba piel mana kʊrɔ taa, “Sɩn ba waan paanʊ̃ɔ jaa lɛ so.” ");
INSERT INTO biv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu na wa bɔ̃ɔn wʊ 'yɛr naa, “Yɩn sɔɔfʊ na ba jã bon ɛ, ŋmɩnɛ a yɩ 'yɛrɛ ɩka yaa tara paanʊ̃ɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yaa nyɛ bɔ̃ɔ a par sɛrɛ bɩɩ? Yaa tɩɛrtɔ a paanʊ̃ɔsɩ anũu a nɩbɛ tur anũu na di faa tɩ yɩ wob a bʊ̃ŋmaar 'yɔ̃ɔ a pɛr pie nɩ ayi bɩɩ? Yaa tɩɛrtɔ a paanʊ̃ɔsɩ anũu a nɩbɛ tur anũu na di faa tɩ yɩ wob a bʊ̃ŋmaar 'yɔ̃ɔ a pɛr pie nɩ ayi bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bɩɩ a paanʊ̃ɔsɩ ayopõi a nɩbɛ tur anaar na di faa tɩ yɩ wob 'yɔ̃ɔ pɛr ayopõi bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bo lɛ so ka yaa tɩɛr bɔ̃ɔ ɩka a ba ɩ paanʊ̃ɔ lɛ n 'yɛrɛ ɛ? Yɩ gu yɩ mãɛ a Faraseemɩne nɩ a Saduseemɩne dãbɩl yele pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Be lɛ ba pãa tɩɛr bɔ̃ɔn ɩka a ba ɩ a paanʊ̃ɔ dãbɩl lɛ ɛ tɩchɛ ba bɔ̃ɔn a Faraseemɩne nɩ a Saduseemɩne wiilfʊ. ");
INSERT INTO biv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","A Yesu na wa kpɛ a Sisariya Filipai paal pɔ, wʊ sʊʊr a wʊ poturbo, “An lɛ a nɩbɛ 'yɛr ɩka a maa Nɩsaal Bie ɩ naa?” ");
INSERT INTO biv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ka ba 'yɛr, “Bamɩne 'yɛr ɩka Jɔɔn Kɔ̃suoro, ka bamɩne mɩ 'yɛr ɩka Elaija lɛ, ka bamɩne mɩ 'yɛr ɩka Jeremiya bɩɩ a Nãaŋmɩn 'yɛ'yɛrɛ ãsʊɔ lɛ.” ");
INSERT INTO biv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tɩchɛ a wʊ sʊʊr ba, “An lɛ yɩn 'yɛr ɩka n ɩ naa?” ");
INSERT INTO biv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ka Simon Pita 'yɛr, “Fʊ̃ʊ lɛ a Nɩ-iraa, a Nãaŋmɩn Vʊr Bie.” ");
INSERT INTO biv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ka Yesu 'yɛr kʊ wʊ, “Fʊ ju nʊ̃mɔ̃ na Simon, Jona bie! A ba ɩ nɩsaal nɩ nɩrɛ lɛ ir wiil fʊ ɛ, tɩchɛ a n Sãa na be a saaju lɛ. ");
INSERT INTO biv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Maa lɛ 'yɛrɛ kʊrɔ fʊ, a fʊ̃ʊ Pita, a par lɛ kʊsɩr pie, a fʊ 'yɛr nyãna pɔ lɛ, ɩn tu bʊɔl nɩbɛ a ba wa sɔɔ de ma ka a kpĩi tẽe kʊ̃ tʊ̃ɔ ba ɛ. ");
INSERT INTO biv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ɩn kʊ fʊn a saaju nãalʊ̃ʊ pãn bie, bon 'lɔ jaa fʊn lũ ka a wɛr pɔ, a mɩn lũn a be a saaju, bon 'lɔ jaa fʊn for bar ka a wɛr pɔ, a mɩn for bar a be a saaju.” ");
INSERT INTO biv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ka wʊ pãa kpãkpãan a wʊ poturbo ɩka ba taa 'yɛrɛ kʊrɔ nɩrɛ jaa ɩka 'lɔ lɛ ɩ a Nɩ-iraa ɛ. ");
INSERT INTO biv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","An piel a sɔ̃ɔ 'lɔ̃nɔ̃ a Yesu piel 'yɛrɛ kʊrɔ ba ɩka wʊn chen Jerusalɛm tɩ di dɔɔyɛ a nɩbɛrɛ nɩ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a nɛɛ wiwiilbe nuur pɔ, ka ba kʊ wʊ, ka a ber ata daar a wʊ lɛ ir ɩ vʊr. ");
INSERT INTO biv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ka Pita tɔɔ wʊ yin chɛ̃chɛ̃ɛ na wʊ tɩ piel 'yɛrɛ, “N Soro, Nãaŋmɩn kʊ sɔɔ ka a yele nyã ɩ fʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tɩchɛ a Yesu lɩɛb 'yɛr kʊ a Pita, “Tɔɔ lan ka tɩ chɛ ma. Fʊ ɩn Satan, na fʊ ɩ gbɛr ŋme bon kʊ ma. Faa tara Nãaŋmɩn bonsɩ tɩɛr ɛ, tɩchɛ nɩsaal bonsɩ tɩɛr lɛ fʊ tara.” ");
INSERT INTO biv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ka a Yesu pãa 'yɛr kʊ a wʊ poturbo, “Ala ɩ ãsʊɔ jaa bʊɔrɔ na ɩka wʊ ɩ a n poturo, wʊ 'laar a wʊ mãɛ tɩ 'mɔɔ a wʊ daa tuo turo nɩ ma. ");
INSERT INTO biv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","A nɩrɛ 'lɔ na bʊɔrɔ ɩka wʊ faa a wʊ nyɛvʊr na bɔr wʊ naa, tɩchɛ nɩrɛ 'lɔ mɩ na bɔr a wʊ nyɛvʊr a maa jũu, na nyɛ wʊ naa. ");
INSERT INTO biv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ala ɩ nɩrɛ tara naa a wɛr ju bonsɩ a jaa, tɩ bɔr a wʊ nyɛvʊr, bo tʊ̃nɔ̃ lɛ wʊn nyɛ? Bɩɩ bo lɛ wʊn de tɛɛn a wʊ nyɛvʊr? ");
INSERT INTO biv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","A maa Nɩsaal Bie na waan naa Nãaŋmɩn tɩɩr nɩ a wʊ malakasɩ wa yab nɩrɛ jaa bon 'lɔ wʊn maal. ");
INSERT INTO biv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka a yɩ bamɩne na ara a ka kʊ̃ kpi ɛ, tɩ na yɩ nyɛ a maa Nɩsaal Bie na waara a n nãa difʊ jie.” ");
INSERT INTO biv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","A ber ayʊɔb daar, Yesu tara na Pita nɩ Jemesɩ nɩ a wʊ yɛbɛ Jɔɔn don tɔ̃wõo ju a ba tɛɛ. ");
INSERT INTO biv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wʊ chil wʊ mãɛ a ba niem, ka a wʊ nie nyɩlɛ mɔ̃tɔ̃ɔ kaar, ka a fuu pɛl nyɩlɛ bũu kaar. ");
INSERT INTO biv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mosesɩ nɩ Elaija mɩ wa dũun yɩ ara a wʊ sɛ̃, ka ba wa 'mataa 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita 'yɛr kʊ Yesu, “N Soro, a vɩla na ka sɩn kpɩɛrɛ a ka. Ala ɩ fʊ sɔɔ naa, ɩn 'yɔ̃ɔn sɛɛr ata a ka na, ka fʊ so a ãsʊɔ, ka Mosesɩ mɩ so a ãsʊɔ, ka Elaija mɩ so a ãsʊɔ.” ");
INSERT INTO biv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wʊn chɛnɛ 'yɛrɛ ka a julõjupɩla wa pɔɔ ba naa, ka Nãaŋmɩn kɔkɔr 'yɛr be a julõjuur pɔ, “Nyã lɛ a n Binʊ̃nãa, a n pʊɔ pɛl wʊ naa, yɩ chɛlɛ a wʊ 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","A poturbo na wa wõ a nɩtɔ̃ dãbãɛ kpɛ ba naa ka ba lo kpa tẽe. ");
INSERT INTO biv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tɩchɛ ka Yesu wa sɩɩr ba tɩ 'yɛrɛ, “Yɩ ir, yɩ ta joro dãbãɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ban wa dʊɔ kaa, baa nyɛ nɩrɛ jaa ka a Yesu tɛɛ ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ban wa yi a tɔ̃ɔ ju suro, Yesu kpãa ba naa, “Yɩ taa 'yɛrɛ kʊrɔ nɩrɛ jaa a bon 'lɔ yɩn nyɛ ɛ, tɩ tãn a daar 'lɔ a maa Nɩsaal Bie na lɩɛb ir a kũu pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ka a wʊ poturbo sʊʊr wʊ, “Ŋmɩnɛ lɛ a ɩ ka a nɛɛ wiwiilbe 'yɛr ɩka Elaija lɛ na de nie wa?” ");
INSERT INTO biv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ka Yesu 'yɛr, “Sɩrɛ jaa lɛ, ɩka Elaija wa naa wa chɔɔr a bonsɩ a jaa. ");
INSERT INTO biv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tɩchɛ yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka Elaija den nie wa ka baa bɔ̃ɔ wʊ ɛ, tɩchɛ ba ɩ wʊn a lɛ na pɛl a ba pʊɔ. Lɛ mɩ lɛ a maa Nɩsaal Bie mɩ na di a dɔɔyɛ a ba nuur pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Be lɛ a poturbo pãa bɔ̃ɔn ɩka Jɔɔn Kɔ̃suoro 'yɛr lɛ wʊ 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu nɩ a wʊ poturbo na wa chen a nɩyɔɔ sɛ̃, daba wa gbur dumo a wʊ niem, ");
INSERT INTO biv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","tɩ 'yɛr, “N Soro, kaa a n bie nɩbaal, kpũgul lɛ wʊ loro na wʊ dire dɔɔyɛ yɔɔ, sɔ̃ɔ ãsʊɔ wʊ ma lon bũu pɔ bɩɩ kʊ̃ɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N tara wʊn waan a fʊ poturbo sɛ̃, tɩchɛ baa tʊ̃ɔ sãa wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ka a Yesu 'yɛr, “Yɩn dɩna nɩbɛ babãma dẽme, a yɩ sɔɔfʊ na ba jã bon ɛ, n be a yɩ sɛ̃ naa tɩ tãn dabor? N tara nɩ yɩ kãnyir jã ŋmɩnɛ?” Tɩ 'yɛr a daba, “Tɔɔ a bie wa kʊ ma.” ");
INSERT INTO biv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu tãn a sɩdɛɛr ka wʊ yi a bie pɔ, a dẽdẽe daa ka a bie sa. ");
INSERT INTO biv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","A poturbo wan a Yesu tɛɛ sɛ̃ wa sʊʊr, “Ŋmɩnɛ a ɩ ka sɩn ba tʊ̃ɔ dii a sɩdɛɛr bar ɛ?” ");
INSERT INTO biv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wʊ 'yɛr kʊ ba, “Bojũu a yɩ sɔɔfʊ ba jã bon ɛ. Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, yɩn tara sɔɔfʊ kʊ jã a kɔ̃kɔ̃ɔ bir, yɩn 'yɛr kʊ a tɔ̃ɔ nyãna, ir a ka chen a be; wʊn ir chen. Tɩ yele jaa kʊ ɩ kpɛ̃ɔ kʊ yɩ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ban wa lɔ̃ɔ taa a Galilee, Yesu 'yɛr kʊ ba, “Ban gar 'yɔ̃ɔ a maa Nɩsaal Bie ka n di dɔɔyɛ a nɩbɛ nuur pɔ. ");
INSERT INTO biv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ban kʊ maa naa, ka a ber ata daar ka n lɩɛb ir ɩ vʊr.” Ban wõ a nɩtɔ̃, ba pʊʊr sɔ̃ɔ naa. ");
INSERT INTO biv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","A Yesu nɩ a wʊ poturbo na wa ta a Kapenahum, a puorfʊ yir lõpodierbe wa 'yɛr a Pita, “A yɩ wiwile maa yab a puorfʊ yir lõpoo bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ka wʊ 'yɛr, “Ɔ̃ɔ, wʊ ma yab naa.” Pita na wa ta a yir, Yesu lɛ de nie sʊʊr Simon, “Bo lɛ fʊ tɩɛr?” Ba boo lɛ ma yab a lõpoo kʊ a wɛr ju nãmɩne? A ba bibiir lɛ bɩɩ nɩyor lɛ ma yab? ");
INSERT INTO biv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita na 'yɛr ɩka nɩyor sɛ̃, lɛ Yesu 'yɛr kʊ wʊ, “A lɛ a bibiir son ba mãɛ. ");
INSERT INTO biv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tɩchɛ saa bʊɔrɔ ɩka sɩ sɔ̃ɔ a nɩbɛ banyãna pʊɔ ɛ, yɩ chen a man pɔ tɩ lɔb a jãpãɩ, yin wa ir a jãdɔ̃ɔ 'lɔ yɩ yuo a nɛɛ, yɩn nyɛn libir, yɩ de ya a sɩ lõpoo. De a jãm 'lɔ fʊn dɔ̃ɔ nie nyɔɔ, fʊ̃ʊ wa haa a wʊ nɛɛ fʊn nyɛn libibir, de a 'lɔ yab a sɩ lõpoo.” ");
INSERT INTO biv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A sɔ̃ɔ 'lɔ̃nɔ̃ lɛ a poturbo wa a Yesu sɛ̃ na ba wa sʊʊr, “An lɛ ɩ kpɛ̃ɛ gar ba jaa a Nãaŋmɩn nãalʊ̃ʊ pɔ?” ");
INSERT INTO biv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Wʊ bʊɔl bibile na wʊ vɛ̃ a wʊ ara a ba pɔ, ");
INSERT INTO biv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","tɩ wʊ 'yɛr, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, yɩn baa lɩɛb na yɩ kaara fɩka bibiir kaar ɛ, yɩ kʊ̃ tʊ̃ɔ kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","A lɛ jũu, nɩrɛ 'lɔ na sɩɩr wʊ mãɛ a bibile nyãna kaar, lɛ ɩ a kpɛ̃ɛ gar ba jaa a Nãaŋmɩn nãalʊ̃ʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Nɩrɛ 'lɔ jaa na de a bibile nyãna a n jũu, maa lɛ wʊ de. ");
INSERT INTO biv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tɩchɛ, ala ɩ ãsʊɔ jaa mɩ vɛ̃ naa a bʊ̃bile nyãna na sɔɔ ma ɩ yelbier, a nɩnyɩnɛ 'lɔ̃nɔ̃, bala 'mɔɔ nɩɛr lũ yɔɔl a wʊ nyĩe pɔ daa 'yɔ̃ɔ a man pɔ, ala sa. ");
INSERT INTO biv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Nɛbier lɛ kʊ a wɛr, a bɛɛr kaa na vɛ̃ ka ba ɩ yelbier. Bɛɛr kaa na wa naa, tɩchɛ nɛbier lɛ kʊ a nɩrɛ 'lɔ 'yɔ̃ɔ an tu wa! ");
INSERT INTO biv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ala ɩ a fʊ nũu bɩɩ gbɛr vɛ̃ naa ka fʊ ɩ yelbier, ŋmaa wʊ lɔb bar. Fʊn tɩ kpɛ a nyɛvʊr pɔ nɩ nũŋmaa bɩɩ gbɛŋmaa sãn fʊn tara a nuur nɩ a gbɛɛ a jaa ayi tɩ na fʊ tɩ kpɛ a wõm jie a be a bũu na ba kpĩine ɛ. ");
INSERT INTO biv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ala ɩ a fʊ nɩbir mɩ vɛ̃ naa ka fʊ ɩ yelbier, 'loo lɔb bar. Fʊn tɩ kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ nɩ nɩbifɩɛ sa naa fʊn tara a nɩbie ayi tɩ na fʊ tɩ kpɛ wõm jie. ");
INSERT INTO biv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Yɩ bɔ̃ɔn sʊ̃ na yɩ taa kaara a bʊ̃bil banyãna ãsʊɔ pɔrɔ ɛ, yelmãɛ jaa lɛ n 'yɛrɛ kʊrɔ yɩ a ba malakasɩ ben a saaju ma kaara a n Sãa niem. ");
INSERT INTO biv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Bo lɛ yɩ tɩɛr? Ala ɩ a nɩrɛ ãsʊɔ tara na piir kɔbaa, ka bʊ̃'yen wa bɔr, a ba ɩ wʊn bar a kɔbaa forbir ala a pɛchiin baa pɔ, tɩ yʊɔrɔ bʊɔrɔ a bʊ̃'yen 'lɔ tɩ tãn a sɔ̃ɔ 'lɔ jaa wʊn na tɩ nyɛ wʊ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, 'lɔ wa nyɛ wʊ, nʊ̃ɔ ma kpɛ wʊ naa gar a kɔbaa forbir ala na ba bɔr ɛ. ");
INSERT INTO biv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lɛ nɩ wʊ ju mɩ lɛ ɩka a ba ɩ a yɩ Sãa saaju bɔfʊ ɩka a bʊ̃bil banyãna ãsʊɔ wʊ bɔr ɛ. ");
INSERT INTO biv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ala ɩ a fʊ yɛbɛ ãsʊɔ ɩ fʊn yelbier, chen tɩ wiil wʊ a wʊ sɔ̃ɔnaa fʊ̃ʊ nɩ a 'lɔ tɛɛ. 'Lɔ wa sɔɔ a wʊ bɔrfʊ, yɩ lɛ ɩn yɛɛr go. ");
INSERT INTO biv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tɩchɛ 'lɔ ba wa sɔɔ a fʊ 'yɛr ɛ, tara nɩbʊ̃'yen bɩɩ nɩbɛ ayi chiin, ka a nɩbɛ ayi bɩɩ nɩbɛ ata di a 'yɛr dãasɩɛ. ");
INSERT INTO biv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","'Lɔ wa tɔr a nɩbɛ bala niem, 'yɛr kʊ a pupuorbiir, ka 'lɔ wa chɛnɛ tɔr na waa tu a ba nɛɛ ɛ, fʊ maal wʊ fɩka a lɛ fʊn na maal a nɩyuo, bɩɩ a lõpodier kaar. ");
INSERT INTO biv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, bon 'lɔ jaa yɩn lũ ka a wɛr pɔ, mɩ lũn a saaju bon 'lɔ yɩn lor bar a wɛr pɔ a mɩ lor bar a saaju. ");
INSERT INTO biv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, a yɩ nɩbɛ ayi tara sɔɔfʊ sʊɔr bon jaa, a n Sãa na be a saaju na kʊ yɩ naa. ");
INSERT INTO biv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jie 'lɔ nɩbɛ ayi bɩɩ ata na ara nɩ a maa yuor, n ben a ba pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita wan wa sʊʊr wʊ, “N Soro, ala ɩ a n tɔ sʊɔ ɩ man yelbier gbɛɛ aŋmɩnɛ lɛ ɩn vɛ̃ bar wʊ? Gbɛɛ ayopõi (7) bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ka a Yesu 'yɛr kʊ wʊ, “N 'yɛrɛ na kʊrɔ fʊ a ba ɩ gbɛɛ ayopõi ɛ, tɩchɛ gbɛɛ lɩjaata nɩ pie nɩ ayopõi gbɛɛ ayopõi (77).” ");
INSERT INTO biv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“A lɛ jũu a Nãaŋmɩn nãalʊ̃ʊ na nyɛntaa fɩka nãa na bʊɔr ɩka 'lɔ nɩ a wʊ tʊ̃tʊ̃nbɔ ba guor a ba libie kaa. ");
INSERT INTO biv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wʊn wa tɩ piel guoro a libie yele ba nyɔɔn ãsʊɔ na di wʊ turo pie sãn waan a wʊ sɛ̃, ");
INSERT INTO biv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","wʊn kʊ̃ tʊ̃ɔ yab a sãn ɛ, a wʊ nɩkpɛ̃ɛ 'yɛr ɩka ba da 'lɔ nɩ a wʊ pɔɔ nɩ a bibiir nɩ a wʊ bonsɩ a jaa yab a sãn. ");
INSERT INTO biv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ka a tʊ̃tʊ̃nɔ̃ lo gbur dumo a wʊ niem lɔɔrɔ nuur 'yɛrɛ, ‘Tara nɩ ma kãnyir, ɩn yab a fʊ sãma a jaa.’ ");
INSERT INTO biv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A nɩkpɛ̃ɛ kãan a wʊ nɩbaal tɩ vɛ̃ a wʊ sãma kʊ wʊ, tɩ bar wʊ. ");
INSERT INTO biv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tɩchɛ, a daba nyã nɩ wʊ ju na wa yɩ a yõo nyɛ a wʊ tʊ̃tʊ̃tɔ sʊɔ na di wʊ toofar kɔbaa sãn, wʊ chɩm a daba kɔkɔr pɔ tɩ 'yɛr, ‘Yab ma a sãn fʊn di.’ ");
INSERT INTO biv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ka a tʊ̃tʊ̃nɔ̃ nyã mɩ lo gbur dumo tɩ sʊɔrɔ, ‘Tara nɩ ma kãnyir, tɩ ɩn yab fʊn a sãn.’ ");
INSERT INTO biv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ka wʊ tɔr, tɩ nyɔɔ wʊ chiin tɩ pɔɔ tɩ tãn a sɔ̃ɔ 'lɔ wʊn yab a sãn. ");
INSERT INTO biv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","A wʊ tʊ̃tʊ̃taaba na wa nyɛ a lɛ wʊn ɩ, ba pʊɔ sɔ̃ɔ naa, ka ba chen tɩ man a jaa kʊ a nɩkpɛ̃ɛ a lɛ jaa na ɩ. ");
INSERT INTO biv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ka a wʊ nɩkpɛ̃ɛ bʊɔl wʊ wa sʊʊr wʊ, ‘Fʊ̃ʊ tʊ̃tʊ̃putuo sʊɔ. Fʊn sʊɔr ma jũu lɛ so ka n vɛ̃ a sãn bar fʊ. ");
INSERT INTO biv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Fʊ mɩ kʊ̃ naa kaa a fʊ tʊ̃tʊ̃tɔ sʊɔ nyã nɩbaal nɩtãa a lɛ ɩn kaa a fʊ nɩbaal ɛ?’ ");
INSERT INTO biv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A wʊ nɩkpɛ̃ɛ suur ir naa ka wʊ de wʊ tɩr ɩka ba tɩ pɔɔ wʊ ge wʊ tɩ tãn a daar 'lɔ wʊn yab a sãn a jaa. ");
INSERT INTO biv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Lɛ mɩ lɛ a n Sãa na be a saaju na ɩ yɩ mɩ, yɩn baa vɛ̃ a yɩ yɛbɛ yelbier bar ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu na wa 'yɛr a anyã baar, wʊ yin a Galilee chen Judiya paal pɔ, a Jordan man gɔ̃ɔn. ");
INSERT INTO biv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nɩyɔɔ turo wʊ naa, ka wʊ sãa a ba baalsɩ a be. ");
INSERT INTO biv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Faraseemɩne bamɩne wan a wʊ sɛ̃ ɩka ba wa bɛɛr wʊ kaa, na ba sʊʊr wʊ, “Sɔr ben be ɩka daba wʊ bar a wʊ pɔɔ yele kɔ̃ɔ jũu bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ka Yesu 'yɛr, “Yaa kar a be a nɩrɛ 'lɔ na maal ba a pielfʊ daar ‘Maal daba nɩ pɔɔ’ ”, ");
INSERT INTO biv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","na wʊ 'yɛr, “A lɛ jũu, daba na bar a wʊ sãa nɩ a wʊ ma, tɩchɛ ka 'lɔ nɩ a wʊ pɔɔ ɩ bʊ̃'yen, ka ba jaa ayi ɩ ãgãn bʊ̃'yen? ");
INSERT INTO biv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Baa lɛ chɛnɛ ɩ ayi ɛ, tɩchɛ ba ɩn ãgãn bʊ̃'yen. A lɛ jũu, bon 'lɔ Nãaŋmɩn na 'mataa, nɩrɛ wʊ ta oor aa ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ka ba sʊʊr wʊ, “Ŋmɩnɛ ka a Mosesɩ 'yɛr ɩka sɩ kʊ wʊ pɔɔ bar gãn, tɩ bar wʊ?” ");
INSERT INTO biv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ka wʊ 'yɛr kʊ ba, “Bojũu a yɩ nyãkpãɛn jũu lɛ so ka a Mosesɩ bar a sɔr ɩka, yɩ bar a yɩ pɔbɔ, tɩchɛ a pielfʊ daar a ba dɔ̃ɔ be a lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A lɛ jũu, n 'yɛrɛ na kʊrɔ yɩ, nɩrɛ 'lɔ jaa na bar a wʊ pɔɔ, ka ala ba ɩ sɛ̃fʊ jũu tɩ kul pɔɔ yuo, wʊ sɔ̃ɔn a kul taa.” ");
INSERT INTO biv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A wʊ poturbo 'yɛr kʊ wʊ, ala ɩ lɛ lɛ a be a daba nɩ a wʊ pɔɔ, a ba sɛɛ ɩka nɩrɛ wʊ kul pɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tɩchɛ ka wʊ 'yɛr kʊ ba, “Nɩrɛ jaa kʊ̃ tʊ̃ɔ sɔɔ a wiilfʊ nyã ka a bala a Nãaŋmɩn na vɛ̃ a ba bɔ̃ɔ a par tɛɛ ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bamɩne ben be na ba dɔɔr ɛ, an ɩ lɛ lɛ ba dɔɔ ba ka be, ka bamɩne mɩ a ba taaba lɛ maal ba ka baa dɔɔr ɛ, ka bamɩne mɩ tɔr a kul taa a Nãaŋmɩn nãalʊ̃ʊ jũu, 'lɔ jaa nɩ na tʊ̃ɔ sɔɔ a wiilfʊ nyã, wʊ sɔɔ.” ");
INSERT INTO biv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nɩbɛ waan na bibiir ɩka wʊ dɔɔl ba a wʊ nũu na wʊ sʊɔr Nãaŋmɩn kʊ ba. Tɩchɛ a poturbo mɩɩn 'yɔ̃ɔ a bala na waan ba. ");
INSERT INTO biv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ka a Yesu 'yɛr, “Yɩ bar a bibiir sɔr ka ba wa a n sɛ̃, yɩ ta pii ba sɔr ɛ, a banyã taaba lɛ so a Nãaŋmɩn nãalʊ̃ʊ.” ");
INSERT INTO biv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wʊ dɔɔl ban a wʊ nuur sʊɔr Nãaŋmɩn kʊ ba, tɩ chen. ");
INSERT INTO biv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Be lɛ ka nɩrɛ ãsʊɔ wa a wʊ sɛ̃ wa sʊʊr, “Wiwile, bo yelvɩla lɛ ɩn ɩ naa nyɛ nyɛvʊr na ba tara baarfʊ ɛ?” ");
INSERT INTO biv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ka a Yesu sʊʊr, “Ŋmɩnɛ a fʊ sʊrɔ ma bon 'lɔ na ɩ vɩla? Nɩbʊ̃'yen tɛɛ lɛ ɩ nɩbie. Ala ɩ fʊ bʊɔrɔ na ɩka fʊ nyɛ nyɛvʊr turo a nɛbinsɩ.” ");
INSERT INTO biv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ka daba sʊʊr wʊ, “A boo?” Ka Yesu 'yɛr, “Ta kʊ nɩrɛ ɛ, ta sɛ̃ ɛ, ta ju ɛ, ta di jir dãasɩɛ ɛ, ");
INSERT INTO biv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","'yɔ̃ɔnɔ̃ a fʊ sãa nɩ a fʊ ma, na fʊ mɩ lɛ nʊ̃ a fʊ tɔ sʊɔ a fʊ mãɛ kaar.” ");
INSERT INTO biv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ka a daba 'yɛr kʊ wʊ, “N tu naa anyãna a jaa, bo lɛ chɛ ma?” ");
INSERT INTO biv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ka a Yesu 'yɛr kʊ wʊ, “Ala ɩ fʊ bʊɔrɔ na ɩka fʊ ɩ chɛchɛ, tɩ de a fʊ bʊ̃tarsɩ a jaa da, na fʊ de a libie kʊ a nɔ̃n dẽme, fʊn nyɛn a Nãaŋmɩn nãalʊ̃ʊ tɩ na fʊ wa turo ma.” ");
INSERT INTO biv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","A daba na wa wõ a nɩtɔ̃, wʊ chiin naa pʊsɔ̃ɔ bojũu wʊ tara na bʊ̃tarsɩ. ");
INSERT INTO biv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ka Yesu 'yɛr kʊ a wʊ poturbo, “Yelmãɛ lɛ n 'yɛrɛ yɩ, an ɩn kpɛ̃ɔ tara sʊɔ na kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sɩrɛ jaa lɛ n 'yɛrɛ kʊrɔ yɩ go, an ɩn kɔ̃mɔ̃kɔ̃mɔ̃ ka nyɔɔma na kpɛ kparpĩi bɔɔ pɔ gar tara sʊɔ na kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","A poturbo na wa wõ a nɩtɔ̃, nɛɛ 'maa ba naa ka ba sʊrɔ, “An lɛ na pãa nyɛ faafʊ?” ");
INSERT INTO biv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ka Yesu kaa ba tɩ 'yɛr, “Ala na ɩ tuo nɩrɛ sɛ̃, Nãaŋmɩn sɛ̃ yele jaa ba ɩ tuo ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","A Pita 'yɛr kʊ wʊ, “Nyɛ sɩn bar bonsɩ a jaa tɩ wa turo fʊ? Bo sãyar lɛ sɩn nyɛ?” ");
INSERT INTO biv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, a bonsɩ a jaa bʊ̃paalaa lɩɛbfʊ daar, a maa Nɩsaal Bie na jãnɛ naa a tɩɩr nãalʊ̃ʊ dakɔɔ ju. Ka a yɩn bala mɩ na turo ma mɩ jãnɛ a nãa dakɔɔ pie nɩ ayi ju, tɔɔrɔ a Isɩral bala pie nɩ ayi 'yɛr. ");
INSERT INTO biv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nɩrɛ nyã jaa na bar a wʊ yir bɩɩ yɛɛr bɩɩ yɛpɔbɔ, bɩɩ sãa, bɩɩ ma, bɩɩ bibiir, bɩɩ puo a maa jũu na nyɛn dɔɔltaa gbɛɛ kɔbaa tɩ tara nyɛvʊr na ba tara baar fʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tɩchɛ a nɩyɔɔ na de a nie na wa ben puor, tɩchɛ ka a puor dẽme nɩ wa de a nie. ");
INSERT INTO biv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Nãaŋmɩn nãalʊ̃ʊ nyɛntãan fɩka daba kɔ̃ɔ na dɔ̃ɔ ŋmaa ir bibio jaa pipi yi ɩka wʊ tɩ bɔ nɩbɛ ka ba chen tɩ kɔ wʊ puo pɔ. ");
INSERT INTO biv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wʊ sɔɔ naa ɩka wʊn yab ba naa a lɛ ban na de a bɩbir gbul ka wʊ tara ba chiin a wʊ puo pɔ. ");
INSERT INTO biv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“A mɔ̃tɔ̃ɔ nɩ lɛ wa do bãlãa wʊ yɩn tɩ nyɛ a nɩbɛ bamɩne na ara a daa pɔ na baa maala bon jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ka wʊ 'yɛr kʊ ba, ‘Yɩ mɩ chen a n puo pɔ tɩ ɩn yab yɩn naa a lɛ jaa na sɛɛn.’ ");
INSERT INTO biv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ka ba sɔɔ chen. Tɩ wʊ lɛ yɩ go a mɔ̃tɔ̃ɔ na wa vɩrʊ̃ gar ju sãlsɔɔ nɩ a mɔ̃tɔ̃ɔ na wa suro a tɩɩr pɔ na wʊ tɩ bɔ a nɩbɛ bamɩne mɩ. ");
INSERT INTO biv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A jãanɔ'maar sɔ̃ɔ, wʊ lɛ yin tɩ nyɛ bamɩne mɩ na chɛnɛ jɛ̃ pɔrɔ jaa. Ka wʊ sʊʊr ba, ‘Bo lɛ so a dɩna yɩn jãnɛ ba maala bon jaa ɛ?’ ");
INSERT INTO biv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","A ba 'yɛr, ‘Nɩrɛ jaa ba sʊɔr sɩ kɔb ɛ.’ Ka wʊ 'yɛr kʊ ba, ‘Yɩ wa a sɩ chen a n puo pɔ a yɩ tɩ kɔ.’ ");
INSERT INTO biv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Jãanʊɔr na wa ta, a puo sʊɔ 'yɛr kʊ a nɩrɛ 'lɔ na kaara a wʊ puo, ‘Bʊɔl a tʊ̃tʊ̃nbɔ kʊ ba a ba libie, de nie piel a bala na bɩɛr wa tɩ tãn a bala na dɔ̃ɔ nie wa.’ ");
INSERT INTO biv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“A bala na wa bɩɛr wa ãsʊɔ jaa den a bɩbir gbul libir. ");
INSERT INTO biv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","A dɔ̃ɔ nie dẽme na wa tɩ wa, ba tɩɛr ɩka ban nyɛn gar a lɛ, tɩchɛ a wʊ kʊ ãsʊɔ jaa mɩ bɩbir gbul libir. ");
INSERT INTO biv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tɩchɛ ban wa de a lɛ baar, ba vʊ̃n nɛɛr 'yɔ̃ɔ a puo sʊɔ, ");
INSERT INTO biv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","na ba gɔ̃ɔnɔ̃ a puo sʊɔ 'yɛrɛ, ‘A nɩbɛ banyãna wa bɩɛr wa tɩ fʊ yab sɩ jãtaa, nɩ sɩn na ŋmaa ir nɩ ɔɔr wa tʊ̃ lɛ̃ɛɛ ka mɔ̃tɔ̃ɔ ŋme sɩ tɩ mʊrʊ̃.’ ");
INSERT INTO biv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ka wʊ lɩɛb sʊʊr a ba ãsʊɔ, ‘N badaba, n ba ɩ fʊ dɛɛr ɛ, a ba ɩ yɩn lɛ sɔɔ ɩka yɩn den a bɩbir gbul libir ɛ? ");
INSERT INTO biv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","De a fʊ libir chiine. Maa lɛ nʊ̃ naa kʊ a puor dẽme nɩtãa a lɛ ɩn kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","N ba tara sɔr na de a n libie ɩn a lɛ ɩn bʊɔrɔ bɩɩ? Bɩɩ fʊ tara nyuur nɩ a n maal vɩla?’ ");
INSERT INTO biv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“A lɛ jũu, a puor dẽme na wa ben niem ka a nie dẽme mɩ wa be a puor.” ");
INSERT INTO biv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu na wa pãa duoro a Jerusalɛm, wʊ tara na a poturbo pie nɩ ayi yin chɛ̃chɛ̃ɛ na wʊ tɩ 'yɛr kʊ ba, ");
INSERT INTO biv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nyɛ, sɩ ben duoro a Jerusalɛm ka ban tɩ de a maa Nɩsaal Bie 'yɔ̃ɔ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a nɛɛ wiwiilbe nuur pɔ. ");
INSERT INTO biv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ban de man kʊ a bala na ba ɩ a Juu nɩbɛ ɛ, ka ba la ma, tʊrɔ ma, chɩrɛ nataar 'yɔ̃ɔnɔ̃ ma, na ba ge ma, tɩ kʊ ma, ka a ber ata daar ka n ir ɩ vʊr go.” ");
INSERT INTO biv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Be lɛ ka Jebedee pɔɔ tara a wʊ bibiir ayi waan a wʊ sɛ̃ wa lo gbur dumo a wʊ niem na wʊ sʊɔrɔ bon kɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ka a Yesu sʊʊr wʊ, “Bo lɛ fʊ bʊɔrɔ?” Ka wʊ 'yɛr, “Vɛ̃ ka a n bibiir banyã ayi ka ãsʊɔ jãnɛ a fʊ nũsʊ̃ɔ ka ãsʊɔ mɩ jãnɛ a fʊ gʊbaa jie a fʊ nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ka a Yesu 'yɛr, “Faa bɔ̃ɔ a bon 'lɔ fʊn sʊɔrɔ ɛ. Ban tʊ̃ɔ nyũn a dɔɔyɛ ŋmele 'lɔ ɩn na nyũn ɔ?” Ka ba 'yɛr, “Sɩn tʊ̃ɔ naa.” ");
INSERT INTO biv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ka a Yesu 'yɛr kʊ ba, “Yɩn tʊ̃ɔ nyũn a n ŋmele tɩchɛ maa kʊ̃ tʊ̃ɔ 'yɛr a buor sʊɔ na jãnɛ a n nũsʊ̃ɔ bɩɩ a n gʊbaa jie ɛ, ka a bala a n Sãa na chɔɔr kʊ tɛɛ ba lɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","A poturbo pie bala na wa wõ a nɩtɔ̃, ba nyɛn naa a yɛɛr ayi bala suur. ");
INSERT INTO biv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ka a Yesu bʊɔl ba waan wa 'yɛr, “Yɩ bɔ̃ɔn na ɩka a bala na kaara a nɩbɛ bala na ba ɩ a Juu nɩbɛ lɛ kaara ba bon jaa pɔ, ka a ba nɩbɛrɛ tʊ̃ɔ ba. ");
INSERT INTO biv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","A kʊ̃ tʊ̃ɔ be a lɛ a yɩ pɔ ɛ, tɩchɛ nɩrɛ 'lɔ na bʊɔrɔ ɩka wʊ ɩ a yɩ kpɛ̃ɛ, wʊ ɩ a yɩ tʊ̃tʊ̃nɔ̃. ");
INSERT INTO biv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nɩrɛ 'lɔ mɩ na bʊɔrɔ ɩka wʊ ɩ a yɩ nɩdiere, wʊ ɩ a yɩ gbãgbaa. ");
INSERT INTO biv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nɩtãa lɛ a maa Nɩsaal Bie na ba wa ɩka ba tʊ̃nɔ̃ kʊrɔ ma ɛ, tɩchɛ ka wʊ ɩ a tʊ̃tʊ̃nɔ̃ na wʊ de a n nyɛvʊr faan nɩyɔɔ yelbier bar.” ");
INSERT INTO biv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu nɩ a wʊ poturbo na wa yire a Jeriko nɩyɔɔ turo wʊ naa. ");
INSERT INTO biv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ka a jɔ̃n ayi jãnɛ a sɔr kõkoor. Ban wa wõ ɩka Yesu lɛ tala, ka ba gboolo, “Sɩ Soro, David Bie wooo ɩ, kaa a sɩ nɩbaal.” ");
INSERT INTO biv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ka a nɩyɔɔ 'yɛr ɩka ba bar gɔ̃mɔ̃ tɩchɛ ka ba chɛnɛ gboolo, “Sɩ Soro, David Bie wooo ɩ, kaa a sɩ nɩbaal.” ");
INSERT INTO biv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu ara na tɩ bʊɔl ba sʊrɔ, “Bo lɛ yɩ bʊɔrɔ ɩka n maal kʊ yɩ?” ");
INSERT INTO biv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ka ba 'yɛr kʊ wʊ, “Sɩ Soro, sɩ bʊɔrɔ na ɩka sɩ nyɛrɛ.” ");
INSERT INTO biv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nɩbaal kpɛ̃n a Yesu, ka wʊ sɩɩr a ba nɩbie, ka ba nyɛrɛ na ba turo wʊ. ");
INSERT INTO biv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ban wa gbʊrɔ a Jerusalɛm nɩ a Betefagɩ a Olive Tɩɩr Tɔ̃ɔ ju, Yesu tʊ̃n a wʊ poturbo ayi, ");
INSERT INTO biv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na wʊ 'yɛr kʊ ba, “Yɩ chen a tẽbile 'lɔ na be a yɩ niem, yɩn tɩ nyɛn bʊ̃ɔ ban lũ ka a bʊ̃pɔl ara kɔɔ wʊ, yɩ for yaa waan. ");
INSERT INTO biv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ala ɩ nɩrɛ wa sʊʊr yɩ naa, ‘Ŋmɩnɛ a yɩ foro a bʊ̃ɔ?’ Yɩ 'yɛr kʊ wʊ, ‘A Sɩ Soro lɛ bʊɔrɔ yaa.’ Wʊn bar sɔr ka yɩ foraa waan fɔɔ jaa.” ");
INSERT INTO biv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","A yele anyã ɩ na ka a na ɩ yelmãɛ a lɛ a Nãaŋmɩn 'yɛ'yɛrɛ na dɔ̃ɔ 'yɛr na wʊ 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“'Yɛr kʊ a Jerusalɛm nɩbɛ, ‘Nyɛ, a yɩ nãa waara na a yɩ sɛ̃. Wʊ siir wʊ mãɛ na wʊ do bʊ̃ɔ. Bʊ̃pɔl bile lɛ wʊ do waara nɩ.’ ” ");
INSERT INTO biv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A poturbo chen tɩ tʊ̃ a lɛ a Yesu na 'yɛr ɩka ba ɩ. ");
INSERT INTO biv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba waan na a bʊ̃ɔ nɩ a bʊ̃pɔl bile na ba de a ba fɔɔr 'yɩɛr dɔɔl, ka wʊ do jãnɛ a bʊ̃pɔl ju. ");
INSERT INTO biv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nɩyɔɔ 'yɩɛr a ba fɔɔr a sɔr pɔ ka bamɩne mɩ 'mɛl vaɩ 'yɩɛr a sɔr pɔ. ");
INSERT INTO biv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A nɩyɔɔ bala na be a niem nɩ a bala na turo a puor chɩlɛ na 'yɛrɛ, “Yãan yooo, Nãa David Bie! Nãaŋmɩn wʊ sʊ̃ʊ a 'lɔ wʊn tʊ̃! Yãan yooo, dãnfʊ wʊ ta a saaju Nãaŋmɩn.” ");
INSERT INTO biv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wʊn wa kpɛ a Jerusalɛm tẽe pɔ, a nɩbɛ ba jaa ɩrɛ na yulõbʊmm, na ba sʊrɔ, “An lɛ a nyã?” ");
INSERT INTO biv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka a nɩyɔɔ bala na turo wʊ 'yɛr, “Nyã lɛ ɩ a Nãaŋmɩn 'yɛ'yɛrɛ, Yesu na yi a Najaretɩ na be Galilee.” ");
INSERT INTO biv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu kpɛ naa a Nãaŋmɩn puorfʊ yir bɛchaar pɔ, na wʊ dire a bala na chiin a bonsɩ tɩ daara nɩ a bala na daara baraa, tɩ na wʊ dara a libitɛɛrbɛ tɛɛbʊlsɩ nɩ a bala na daara a papar dakɔɔr lɔɔrɔ. ");
INSERT INTO biv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wʊ 'yɛr kʊ ba, “A sɛb a Nãaŋmɩn gãn pɔ ɩka, ‘A n yir na ɩ naa Nãaŋmɩn sʊɔrfʊ jie,’ tɩchɛ ‘Ka yɩn maal wʊ ka wʊ ɩ nãnyisɩ sɔɔlfʊ jie.’ ” ");
INSERT INTO biv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jɔ̃n nɩ gbɛrsɩ chen a be a Nãaŋmɩn puorfʊ yir ka wʊ sãa ba. ");
INSERT INTO biv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tɩchɛ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a nɛɛ wiwiilbe na nyɛ a nɛ'maa tʊ̃mɔ̃ wʊn tʊ̃ nɩ a bibiir na ɩrɛ a gɔ̃mɔ̃ a Nãaŋmɩn puorfʊ yir pɔ ɩka, “Yãan yooo! Nãa David Bie.” Ka a ba pʊʊr sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ba sʊɔr a Yesu, “Fʊ wõn a lɛ a bibiir banyãna na 'yɛrɛ ɔ?” Ka wʊ 'yɛr, “Ɔ̃ɔ, yaa dɔ̃ɔ kar ɩka, ‘A bibiir nɩ bipɩlɛ nɛgãma pɔ lɛ yɩ bʊɔrɔ pɛɛfʊ ɛ?’ ” ");
INSERT INTO biv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wʊ bar ba naa tɩ yi chen a Betanɩ tẽe pɔ tɩ gã a be. ");
INSERT INTO biv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wʊn wa lɩɛb chen a tẽkpɛ̃ɛ pɔ a bibio, kɔ̃ kpɛ wʊ naa. ");
INSERT INTO biv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Wʊ nyɛn kɔ̃kɔ̃ɔ tɩɛ na ara a sɔr kõkoor, a wʊ chen tɩ ta ka wɔ̃mɔ̃ ba be be ɛ, tɩ wʊ ɩ va nara tɛɛ. Ka Yesu 'yɛr kʊ a tɩɛ, “Fʊ kʊ̃ lɛ wɔ̃ wɔ̃mɔ̃ go ɛ!” Ka a tɩɛ juɔl kpi ajienaa. ");
INSERT INTO biv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","A poturbo na wa nyɛ a tɩɛ na kpi, nɛɛr 'maa ba naa ka ba 'yɛrɛ, “Ŋmɩnɛ lɛ a tɩɛ ɩ juɔl ajienaa a lɛ?” ");
INSERT INTO biv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ka Yesu 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, yɩn tara sɔɔfʊ na yaa baal ɛ, a ba ɩ a lɛ na tʊ̃ kʊ a tɩɛ nyã tɛɛ lɛ yɩn tʊ̃ ɛ, tɩchɛ yɩn gba 'yɛr kʊ a tɔ̃ɔ nyãna, ‘Ir suu a man pɔ,’ tɩ wʊ̃n ir naa. ");
INSERT INTO biv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yɩn wa sʊɔr bon jaa tɩ tara sɔɔfʊ, yɩn nyɛ naa.” ");
INSERT INTO biv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu na wa tɩ kpɛ a Nãaŋmɩn puorfʊ yir bɛchaar pɔ na wʊ wile, ka a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Juu nɩbɛrɛ wa a wʊ sɛ̃ a sɔ̃ɔ 'lɔ wʊn wile wa sʊʊr wʊ, “Bo kpɛ̃ɔ lɛ fʊ de tʊ̃nɔ̃ nɩ a anyã nɩ an lɛ kʊ fʊ a sɔr ɩka fʊ tʊ̃nɔ̃ nɩ a anyã?” ");
INSERT INTO biv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ka a Yesu 'yɛr kʊ ba, “N mɩ na sʊʊr yɩn sʊʊrfʊ bʊ̃'yen. Yɩn wa tʊ̃ɔ wiil ma a par, n mɩ na wiil yɩ naa a nɩrɛ 'lɔ na kʊ ma a kpɛ̃ɔ ka tʊ̃nɔ̃ nɩ a anyãna. ");
INSERT INTO biv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A Jɔɔn na dɔ̃ɔ suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ, Nãaŋmɩn lɛ kʊ wʊ a sɔr bɩɩ nɩbɛ lɛ kʊ wʊ a sɔr? Yɩ 'yɛr n kaa?” Ka ba piel chɩrɛ taa, “Sɩn be 'yɛr ɩka Nãaŋmɩn lɛ tʊ̃ wʊ wʊn sʊʊr sɩ naa ka bo lɛ so ka saa sɔɔ de wʊ ɛ? ");
INSERT INTO biv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tɩchɛ sɩn mɩ 'yɛr ɩka nɩrɛ lɛ tʊ̃ wʊ a ba ɩ ɛ, sɩ joro naa a nɩbɛ dãbãɛ bojũu nɩrɛ jaa sɔɔ naa ɩka a Jɔɔn ɩn Nãaŋmɩn 'yɛ'yɛrɛ.” ");
INSERT INTO biv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Be lɛ a ba 'yɛr kʊ a Yesu, “Saa bɔ̃ɔ ɛ.” Ka a Yesu mɩ 'yɛr kʊ ba, “N mɩ kʊ̃ 'yɛr kʊ yɩ a nɩrɛ 'lɔ na kʊ ma a kpɛ̃ɔ ka n tʊ̃nɔ̃ nɩ a anyãna ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ka a Yesu 'yɛr kʊ ba, “Ŋmɩnɛ lɛ yɩ tɩɛr? Daba lɛ tara bibiir ayi, na wʊ chen tɩ 'yɛr kʊ a dɔ̃ɔ sʊɔ, ‘N Bie chen tɩ tʊ̃ a n puo tʊ̃mɔ̃ a dɩna.’ ");
INSERT INTO biv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ka wʊ 'yɛr, ‘N kʊ̃ chen ɛ,’ tɩchɛ na wʊ ta sɔ̃ɔ lɩɛb a wʊ tɩɛr na wʊ chen. ");
INSERT INTO biv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","A sãa lɛ chen tɩ 'yɛr kʊ a ayi sʊɔ a lɛ nɩ wʊ ju mɩ, ka wʊ 'yɛr, ‘N chen naa,’ tɩ na wʊ tɔr. ");
INSERT INTO biv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“A bibiir banyãna ayi, buor sʊɔ lɛ tʊ̃ a wʊ sãa bɔfʊ?” Ka ba 'yɛr, “A dɔ̃ɔ sʊɔ lɛ.” Ka Yesu 'yɛr kʊ ba, “Yelmãɛ jaa lɛ n 'yɛrɛ kʊrɔ yɩ a lõpodierbe nɩ a pɔɔ baar na dɔ̃ɔ yɩn nie kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jɔɔn Kɔ̃suoro wan wa wile yɩ a yelmãɛ sɔr ka yaa sɔɔ de wʊ ɛ, tɩchɛ a lõpodierbe nɩ a pɔɔ baar sɔɔn de wʊ, yɩn sɔɔ wa nyɛ gba yaa lɩɛb a yɩ tɩɛr sɔɔ de wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Yɩ lɛ chɛlɛ a sʊkpa ãsʊɔ. Daba lɛ kɔ wʊ puo na wʊ. Wʊ wɔɔn a puo wʊ jaa jilʊ̃, na wʊ tuu bɔɔ ka ban ma pɔr a wɔ̃mɔ̃ 'yɔ̃ɔnɔ̃ na ba nɛŋmɛr ir a kʊ̃ɔ. Wʊ mɛn jie ãsʊɔ na do ka nɩrɛ na ma do jãnɛ a be kaara a puo. Wʊ den a puo kʊ nɩbɛ ɩka ba kaara tɩ na wʊ yɔ chen paal yuo pɔ. ");
INSERT INTO biv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","A pɔrfʊ sɔ̃ɔ na wa ta, wʊ tʊ̃n a wʊ gbãgbaar ɩka ba chen a nɩbɛ bala sɛ̃ tɩ pɔr a tɩɛ wɔ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Tɩchɛ ka a nɩbɛ bala nyɔɔ a wʊ gbãgbaar ŋme a ãsʊɔ, na ba kʊ a ãsʊɔ tɩ na ba lɔb a ãsʊɔ nɩ kʊsɩbɛ kʊ. ");
INSERT INTO biv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Be lɛ wʊ lɛ tʊ̃ a gbãgbaar bamɩne ka ba ge ba a lɛ nɛ nɩ wʊ ju. ");
INSERT INTO biv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","A baaraa lɛ wʊ tʊ̃ a wʊ mãɛ bie a ba sɛ̃ na wʊ 'yɛr, ‘Ban 'yɔ̃ɔ naa a n bie.’ ");
INSERT INTO biv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Tɩchɛ a pokaarba na wa nyɛ a bie, ba 'yɛr kʊ taa, ‘Nyã lɛ ɩ a bʊ̃dire, yɩ ɩ a sɩ kʊ wʊ tɩ de a bonsɩ.’ ");
INSERT INTO biv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Be lɛ ba nyɔɔ wʊ kʊ lɔb bar a puo kõkoor. ");
INSERT INTO biv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Pʊ̃pãanyã a puo sʊɔ wa wa, ŋmɩnɛ lɛ wʊn ɩ a pokaarba banyãna?” ");
INSERT INTO biv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ka ba 'yɛr kʊ wʊ, “Wʊn wan wa kʊ a pokaarba banyã ba jaa tɩ de a puo kʊ nɩyor, a bala na ma sɔɔ ka ba põ a puo bonsɩ a ŋmafʊ sɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu 'yɛr kʊ ba, “Yaa kar a jie nyã a Nãaŋmɩn gãn na 'yɛr ɩka a, ‘A kʊsɩr 'lɔ a mɩmɩɛrbɛ na tɔr bar lɛ ɩ a kʊsɩr ju. A sɩ Soro lɛ tʊ̃ a nɩtɔ̃ ka a sɔb sɩ a nɩbie.’ ");
INSERT INTO biv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“A lɛ jũu n 'yɛrɛ na kʊrɔ yɩ, Nãaŋmɩn na faan a wʊ nãalʊ̃ʊ yin a yɩ sɛ̃ kʊ a nɩyor bala na sɔɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nɩrɛ nyã na lo a kʊsɩr nyã ju na pʊrpʊr a, tɩchɛ a wʊ mɩ na kʊ nɩrɛ nyã ju wʊn lo dɔɔl.” ");
INSERT INTO biv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","A Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Faraseemɩne na wa wõ a wʊ sʊkpar anyãna, ba bɔ̃ɔn naa ɩka bala lɛ wʊ lɔɔrɔ a sʊkpar gbɛɛrɛ nɩ. ");
INSERT INTO biv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ka ba bʊɔrɔ na sɔr ɩka ba nyɔɔ wʊ, tɩ na ba joro a nɩyɔɔ dãbãɛ bojũu ba nyɛn ka wʊ ɩ Nãaŋmɩn 'yɛ'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu lɛ lɔɔrɔ na sʊkpar kʊrɔ a nɩbɛ na wʊ 'yɛrɛ, ");
INSERT INTO biv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A Nãaŋmɩn nãalʊ̃ʊ nyɛntãan fɩka nãa kɔ̃ɔ na maal a wʊ bidaba na kulo pɔɔ paalaa bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wʊ tʊ̃n a wʊ tʊ̃tʊ̃nbɔ ɩka ba tɩ 'yɛr a bala wʊn bʊɔl a pɔɔ paalaa jie, tɩchɛ a bala wʊn bʊɔl ka ba tɔr. ");
INSERT INTO biv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Wʊ lɛ tʊ̃n nɩyor ɩka ba tɩ 'yɛr a bala wʊn bʊɔl, ‘Nyɛ, n maal a pɔɔ paalaa bʊ̃diir baar, n kʊn a n nadar nɩ a napɔl ka yele jaa chɔɔr baar, yɩ wa a pɔɔ paalaa jie.’ ");
INSERT INTO biv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Tɩchɛ ka ba tɔr ka nyã jaa ma chen wʊ chenfʊ jie, ka ãsʊɔ mɩ chen a wʊ puo pɔ, ka ãsʊɔ mɩ chen a wʊ yar jie. ");
INSERT INTO biv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tɩchɛ ka a bala na chɛ nyɔɔr a wʊ tʊ̃tʊ̃nbɔ ge ba tɩ na ba kʊ ba. ");
INSERT INTO biv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A nãa suur ir naa ka wʊ tʊ̃ a wʊ sojasɩ ɩka ba tɩ kʊ a nɩkʊrbɔ bala tɩ chʊm a ba tẽe. ");
INSERT INTO biv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Tɩ na wʊ pãa 'yɛr kʊ a wʊ tʊ̃tʊ̃nbɔ, ‘Yele jaa chɔɔr baar, tɩchɛ a bala ɩn bʊɔl ba sɛɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yɩ yi a tẽe pɔ tɩ bʊɔl nɩrɛ jaa yɩn nyɛ ka wʊ wa a pɔɔ paalaa jie.’ ");
INSERT INTO biv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Lɛ lɛ, a tʊ̃tʊ̃nbɔ yin a tẽe pɔ tɩ bʊɔl nɩrɛ jaa ban nyɛ, a nɩmɩn nɩ a nɩdɛbɛ ka a yir wa sɛɛn nɩbɛ wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tɩchɛ a nãa na wa kpɛ ɩka wʊ kaa a nɩbɛ, wʊ nyɛn daba ãsʊɔ na ba su a pɔɔbɩɛl fuu ɛ, ");
INSERT INTO biv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ka wʊ suur wʊ, ‘N badaba, ŋmɩnɛ fʊ ɩrɛ wa kpɛ a ka tɩ ba su a pɔɔ paalaa fuu ɛ?’ Ka a daba kpal a nɛɛ. ");
INSERT INTO biv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ka a nãa 'yɛr kʊ a wʊ tʊ̃tʊ̃nbɔ, ‘Yɩ lũ a wʊ gbɛɛ naa nuur na yɩ lɔb wʊ bar yõo a libe pɔ, be lɛ nɩbɛ na kõnõ tɩ ɔɔrɔ nyɩmɛ.’ ");
INSERT INTO biv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Nɩyɔɔ lɛ ba bʊɔl, tɩchɛ bãlãa lɛ ban chɛl ir.” ");
INSERT INTO biv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Be lɛ ka a Faraseemɩne guor taa na ba wa bɛɛr Yesu kaa na ba na nyɔɔ wʊ a wʊ 'yɛrbie pɔ. ");
INSERT INTO biv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Be lɛ ba tʊ̃ a ba poturbo nɩ a nɩbɛ bamɩne na yi a Nãa Hɛrɔd sɛ̃, na ba 'yɛr, “Wiwile, sɩ bɔ̃ɔ naa ɩka fʊ ɩn yelmãɛ sʊɔ, na fʊ wile Nãaŋmɩn sɔr nɩ yelmãɛ, bojũu faa kaara lɛ nɩbɛ na 'yɛrɛ bɩɩ oor ɛ. ");
INSERT INTO biv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","'Yɛr kʊ sɩ a lɛ fʊn tɩɛr. A tara na sɔr ɩka sɩ yab a lõpoo kʊ a Nãkpɛ̃ɛ Siisa bɩɩ sɩ ta yab ɛ?” ");
INSERT INTO biv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tɩchɛ a Yesu na bɔ̃ɔn a ba pʊtɩdɛɛr jũu, ka ka wʊ sʊʊr ba, “Yɩn nɛɛr ayi dẽme. Bo lɛ yɩ bʊɔrɔ ɩka yɩ bɛɛr ma kaa? ");
INSERT INTO biv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yɩ wiil ma a libir n kaa.” Be lɛ ba de a libikur waan. ");
INSERT INTO biv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ka wʊ sʊʊr ba, “An foto nɩ an yuor lɛ be a libir pɔ?” ");
INSERT INTO biv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ka ba 'yɛr, “A Nãkpɛ̃ɛ Siisa lɛ.” Lɛ lɛ ka a Yesu 'yɛr kʊ ba, “Yɩ de a 'lɔ na ɩ a Nãkpɛ̃ɛ Siisa sofʊ na yɩ kʊ wʊ, na yɩ mɩ de a 'lɔ na ɩ a Nãaŋmɩn sofʊ mɩ kʊ a Nãaŋmɩn.” ");
INSERT INTO biv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ban wa wõ a nɩtɔ̃, nɛɛ 'maa ba naa ka ba bar wʊ tɩ chen jaa jomm. ");
INSERT INTO biv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A bɩbir 'lɔ̃nɔ̃, a Saduseemɩne na 'yɛr ɩka a kũu pɔ irfʊ ba be be ɛ, ba wan a Yesu sɛ̃ wa sʊʊr wʊ, ");
INSERT INTO biv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Wiwile, Mosesɩ sɛb ɩka yɛbɛ wa kpi tɩ bar pɔɔ na ba tara bie ɛ, a wʊ yɛbɛ wʊ kul a pɔɔkʊɔr 'lɔ na wʊ dɔɔ bibiir kʊ a wʊ yɛbɛ 'lɔ na kpi. ");
INSERT INTO biv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yɛɛr ayopõi lɛ dɔ̃ɔ be a ka a sɩ sɛ̃ ka a ba kpɛ̃ɛ kul pɔɔ na waa dɔɔ bie ɛ, tɩ kpi tɩchɛ a pɔɔkʊɔr bar ka a yɛbɛ de kul. ");
INSERT INTO biv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ka a ayi sʊɔ mɩ de a pɔɔkʊɔr kul baa mɩ dɔɔ bie, tɩchɛ ka wʊ mɩ kpi. A lɛ nɛ nɩ wʊ ju mɩ lɛ ata tɩ tãn a ayopõi sʊɔ. ");
INSERT INTO biv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ba jaa na wa kul a pɔɔkʊɔr nyã lʊɔr taa baar a pɔɔkʊɔr nyã mɩ baar kpi. ");
INSERT INTO biv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bala wa ir yi a kũu pɔ, a nɩbɛ banyã ayopõi an pɔɔ, lɛ wʊn ɩ, an ɩ ba jaa kul wʊn lʊɔr taa?” ");
INSERT INTO biv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ka a Yesu 'yɛr kʊ ba, “Yaa nyɛ yɩn bɔr, bojũu yaa bɔ̃ɔ a Nãaŋmɩn gãma nɩ a wʊ kpɛ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nɩbɛ wa ir a kũu pɔ, ba kʊ̃ lɛ kul taa ɛ, tɩ ban kaara fɩka malakasɩ na be a saaju. ");
INSERT INTO biv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tɩchɛ a kũu pɔ ir fʊ yele, yaa kar a lɛ a Nãaŋmɩn na dɔ̃ɔ 'yɛr kʊ yɩ ɩka, ");
INSERT INTO biv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","n ɩ naa a Abraham Nãaŋmɩn nɩ a Isaakɩ Nãaŋmɩn nɩ a Jekɔb Nãaŋmɩn ɛ? Wʊ ɩn Nãaŋmɩn vʊr, waa ɩ Nãaŋmɩn kũu ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","A nɩbɛ na wa wõ a nɩtɔ̃ nɛɛr 'maa ba naa nɩ a wʊ wiilfʊ. ");
INSERT INTO biv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","A Faraseemɩne na wa wõ ɩka Yesu 'yɛr tʊ̃ɔ a Saduseemɩne, ba mɩ lɔ̃ɔn taa. ");
INSERT INTO biv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ka a ba ãsʊɔ na ɩ a nɛɛ wiwile sʊʊr 'yɛrbir bʊɔrɔ ɩka wʊ bɛɛr a Yesu kaa, ");
INSERT INTO biv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Wiwile, A Mosesɩ nɛbinsɩ a jaa pɔ, buor lɛ ɩ kpɛ̃ɛ?” ");
INSERT INTO biv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ka a Yesu 'yɛr kʊ wʊ, “ ‘Nʊ̃ a fʊ Soro Nãaŋmɩn nɩ a fʊ nyãa wʊ jaa, nɩ a fʊ nyɛvʊr wʊ jaa, nɩ a fʊ tɩɛr wʊ jaa.’ ");
INSERT INTO biv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nyã lɛ ɩ a kpɛ̃ɛ nɩ a nɛdɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A ayi sʊɔ mɩ nɩ nyã, ‘Nʊ̃ a fʊ tɔ sʊɔ a fʊ kaar.’ ");
INSERT INTO biv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","A Mosesɩ nɛɛr a jaa nɩ a Nãaŋmɩn 'yɛ'yɛrbɛ wiilfʊ kpãkpãana na a binfʊ nyãna.” ");
INSERT INTO biv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","A Faraseemɩne na wa 'mataa, Yesu sʊʊr ba naa. ");
INSERT INTO biv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ŋmɩnɛ lɛ yɩ tɩɛr a Nɩ-iraa yele? An bie lɛ wʊ ɩ?” Ka ba 'yɛr kʊ wʊ, “David bie lɛ.” ");
INSERT INTO biv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ka a Yesu sʊʊr ba, “Ŋmɩnɛ lɛ ka a nãa David a Nãaŋmɩn Sɩɛ na dɔ̃ɔ kpɛ, a wʊ bʊɔl wʊ ɩka, ‘N Soro’? Bojũu wʊ 'yɛr naa ɩka, ");
INSERT INTO biv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘A Soro 'yɛr kʊ a n Soro, “Jãnɛ a n nũsʊ̃ɔ jie, ka n wa de a fʊ dɔ̃dẽme ka ba ɩ a fʊ gbɛɛ dɔɔlfʊ jie.” ’ ");
INSERT INTO biv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ala ɩ David bʊɔl wʊn wʊ ɩka, ‘N Soro,’ ŋmɩnɛ wʊn ɩrɛ wa ɩ a wʊ bie?” ");
INSERT INTO biv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","An yɩ a daar 'lɔ̃nɔ̃ chiine, nɩrɛ jaa ba lɛ haa nɛɛ 'yɛr 'yɛr ɛ bɩɩ lɛ 'la sʊʊr sʊʊrfʊ jaa go ɛ. ");
INSERT INTO biv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu pãa 'yɛr kʊ a nɩyɔɔ bala nɩ a wʊ poturbo, ");
INSERT INTO biv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“A nɛɛ wiwiilbe nɩ a Faraseemɩne jãnɛ na a Mosesɩ dakɔɔ ju. ");
INSERT INTO biv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","A lɛ jũu, yɩ maala a lɛ ban wile tɩ na yɩ turo, tɩ yɩ ta maala a lɛ ban maala ɛ, bojũu ba maa turo a lɛ ban wile ɛ. ");
INSERT INTO biv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ba ma lũn tuor tɩɩr tuo nɩbɛ, tɩ maa sɔɔ de a ba nubir sɩɩr ɛ. ");
INSERT INTO biv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Yele jaa ban tʊ̃nɔ̃, ba ma bʊɔrɔ naa ɩka nɩbɛ ba nyɛ ba, na ba ma lũ a fɔɔr a ba jur pɔ, tɩ na ba ma su fuusɩ ban ma sɛ bonsɩ 'yɔ̃ɔ jaa vɛvɛɛ. ");
INSERT INTO biv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bala wa lɔ̃ɔ taa dire, a ji'yɔ̃ɔnsɩ jie lɛ ba ma nʊ̃ ɩka ba jãnɛ, nɩ a ba lɔ̃ɔfʊ jiir a jibɛrɛ jiir. ");
INSERT INTO biv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ala tɩ na ba ma bʊɔrɔ ɩka bama puoro ba a dar pɔ, na ba ma bʊɔrɔ ɩka nɩbɛ ba bʊɔlɔ ba, Wiwiilbe. ");
INSERT INTO biv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Yɩ ta sɔɔ ka ba bʊɔlɔ yɩ, Wiwiilbe ɛ, nɩkpɛ̃ɛ bʊ̃'yen tɛɛ lɛ yɩ tara. Yɩ jaa ɩn yɛɛr. ");
INSERT INTO biv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yɩ ta bʊɔl nɩrɛ jaa yɩ, sãa a wɛr pɔ ɛ, bojũu yɩ tara na Sãa bʊ̃'yen na be a saaju. ");
INSERT INTO biv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bɩɩ yɩ ta bʊɔl nɩrɛ jaa wiwile ɛ, bojũu yɩ tara na Wiwile bʊ̃'yen tɛɛ na ɩ a Nɩ-iraa. ");
INSERT INTO biv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","A 'lɔ na bʊɔrɔ ɩka wʊ ɩ a yɩ kpɛ̃ɛ wʊ ɩ a yɩ tʊ̃tʊ̃nɔ̃. ");
INSERT INTO biv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nɩrɛ 'lɔ na 'mɔɔrɔ a wʊ mãɛ ire nɩ, Nãaŋmɩn na suun wʊn pĩlem tɩchɛ nɩrɛ 'lɔ mɩ na siir wʊ mãɛ Nãaŋmɩn na 'mɔɔ wʊn ka wʊ do. ");
INSERT INTO biv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Tɩchɛ nɛbier ben a yɩn nɛɛ wiwiilbe nɩ a Faraseemɩne na ɩ a nɛɛr ayi dẽme sɛ̃. Yɩ pɔɔn a nɩbɛ var bar a Nãaŋmɩn nãalʊ̃ʊ pɔ. Yɩn mãɛ ba kpɩɛrɛ ɛ, tɩ na yɩ pɔɔ var a bala na bʊɔrɔ a kpɛfʊ bar. ");
INSERT INTO biv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nɛbier ben a yɩn nɛɛ wiwiilbe nɩ a Faraseemɩne na ɩ a nɛɛr ayi dẽme sɛ̃. Yɩ ma yɔn jitɛbɛ nɩ a man pɔ na yɩ tɩ 'yɛr lɩɛb nɩrɛ tɩɛr, yɩn wa tʊ̃ɔ wʊ ka wʊ kaara a yɩ kaar, yɩ ma lɩɛb wʊ naa ka wʊn di dɔɔyɛ a bũu dagel pɔ a yɩ kaar. ");
INSERT INTO biv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nɛbier ben a bala na ɩ jɔ̃n tɩ na ba tɔɔrɔ a jɔ̃n, na ba ma 'yɛr ɩka, ‘Nɩrɛ 'lɔ na pɔn a Nãaŋmɩn puorfʊ yir a ba ɩ tuo ɛ, tɩchɛ nɩrɛ 'lɔ na pɔn a sɛlma 'lɔ na be a Nãaŋmɩn puorfʊ yir a lũ wʊ naa.’ ");
INSERT INTO biv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yɩ ɩn jɔ̃n na yɩ ɩ jɔlɔ. Buor lɛ ɩ kpɛ̃ɛ, a sɛlma bɩɩ a Nãaŋmɩn yir 'lɔ na maal a sɛlma ka wʊ ɩ a chɛchɛ? ");
INSERT INTO biv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yɩ mɩ 'yɛr naa, ‘Ala ɩ nɩrɛ pɔn na a Nãaŋmɩn bɔɔr lofʊ jie, a ba tuo ɛ, tɩchɛ ala ɩ nɩrɛ pɔn na a Nãaŋmɩn kʊfʊ 'lɔ na dɔɔl a jie, a lũ wʊ naa.’ ");
INSERT INTO biv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yɩn jɔ̃n banyã. Buor lɛ ɩ kpɛ̃ɛ, a kʊfʊ bɩɩ a Nãaŋmɩn bɔɔr lofʊ jie na ma vɛ̃ ka wʊ ɩ chɛchɛ? ");
INSERT INTO biv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","A lɛ jũu, nɩrɛ 'lɔ jaa na pɔn a Nãaŋmɩn bɔɔr lofʊ jie, pɔn wʊ naa nɩ bon jaa na dɔɔl a wʊ ju. ");
INSERT INTO biv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nɩrɛ 'lɔ mɩ na pɔn a Nãaŋmɩn yir, pɔn wʊ naa nɩ a nɩrɛ 'lɔ na jãnɛ a be. ");
INSERT INTO biv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nɩrɛ 'lɔ mɩ na pɔn a saaju, pɔn naa a Nãaŋmɩn nãkɔɔ nɩ a nɩrɛ 'lɔ mɩ na jãnɛ a be. ");
INSERT INTO biv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nɛbier ben a yɩn nɛɛ wiwiilbe nɩ a Faraseemɩne na ɩ a nɛɛr ayi dẽme sɛ̃. Yɩ ma ir a bonsɩ pɔ jiir pie pɔ bʊ̃'yen lɔ̃ɔn badʊʊ gba vaar kʊ Nãaŋmɩn, tɩ na yɩ tɔr a Nãaŋmɩn nɛɛr ala na tɩrɛ bar na ɩ yelmãɛ sɔr tufʊ, nɩbaal kaafʊ nɩ yelmãɛ tarfʊ. A anyã lɛ a sɛɛ ɩka yɩ turo tɩ na yɩ taa ire amɩne bara ɛ. ");
INSERT INTO biv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yɩn jɔ̃tɔɔrbɔ ba nyã. Yɩ ma chuor a jãajubil bar tɩ ma vɔl a nyɔɔma. ");
INSERT INTO biv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nɛbier ben a yɩn nɛɛ wiwiilbe nɩ a Faraseemɩne na ɩ a nɛɛr ayi dẽme sɛ̃. Yɩ ma pɛɛn a ŋmanyuraa nɩ a ladiraa a yõo tɩchɛ ka a pʊɔ sɛɛn bɔgar nɩ nyuur. ");
INSERT INTO biv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yɩn Faraseemɩne na ɩ jɔ̃n. Yɩ ma dɔ̃ɔ pɛɛ a ŋmanyuraa pʊɔ tɩchɛ ka a yõo mɩ pãa pɛɛ a yõo ka a vɩɛlɛ. ");
INSERT INTO biv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nɛbier ben a yɩn nɛɛ wiwiilbe nɩ a Faraseemɩne na ɩ a nɛɛr ayi dẽme sɛ̃. Yɩ kaara fɩka yar ban pãɛ ka a vɩɛlɛ, tɩchɛ ka a pʊɔ pɔ tara nɩbɛ kɔbɔ nɩ dɛɛr jaa bʊrɔ. ");
INSERT INTO biv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lɛ nɩ wʊ ju mɩ lɛ a yɩn a yõo, yɩ ɩn nɩtor a yɩ taaba sɛ̃, tɩchɛ a yɩ pʊɔm, yɩ tara na nɛɛr ayi nɩ putuyele. ");
INSERT INTO biv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nɛbier ben a yɩn nɛɛ wiwiilbe nɩ a Faraseemɩne na ɩ a nɛɛr ayi dẽme sɛ̃. Yɩ mɛn a Nãaŋmɩn 'yɛ'yɛrbɛ yar, tɩ na chɔɔr a bala na tor yar, ");
INSERT INTO biv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","tɩ na yɩ 'yɛr ɩka, ‘Sɩn ta be be a sɩ sãakpãmɩne sɔ̃ɔ, sɩ kʊ̃ naa ta pʊɔ ba kʊ a Nãaŋmɩn 'yɛ'yɛrbɛ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","A nɩtɔ̃ jũu yɩ din a yɩ mãɛ dãasɩɛ ɩka yɩ ɩn a nɩbɛ bala na kʊ a Nãaŋmɩn 'yɛ'yɛrbɛ bibiir. ");
INSERT INTO biv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yɩ baar baar a lɛ a yɩ sãakpãmɩne na dɔ̃ɔ ɩ. ");
INSERT INTO biv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Yɩn waa bibiir, ŋmɩnɛ yɩn ɩrɛ wa chãɛ a bũu dagel kũu. ");
INSERT INTO biv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","A lɛ jũu ɩn tʊ̃n Nãaŋmɩn 'yɛ'yɛrbɛ, yɛ̃n dẽme, nɩ a wiwiilbe, ka yɩ kʊ bamɩne yɔɔl a daa ju, yɩn pɔɔn bamɩne na yɩ fɔb ba a yɩ lɔ̃ɔfʊ jiir, tɩ na yɩ pãa tulo yʊɔrɔ bʊɔrɔ ba a tẽn a jaa. ");
INSERT INTO biv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ka a na di yɩ a nɩbɛ bala na ɩ a nɩtor ba bɔ̃ɔ yele jaa yɩn kʊ, piel a Abel jãɩ sɔ̃ɔ tɩ tãn a Jekariya bidaba Barakiya ban kʊ a Nãaŋmɩn bɔɔr lofʊ jie nɩ a puorfʊ jie chara pɔ. ");
INSERT INTO biv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, a yɩn dɩna nɩbɛ na nyɛn gefʊ a yele anyãna jũu. ");
INSERT INTO biv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Pa yɩn Jerusalɛm nɩbɛ, a yɩn na ma kʊrɔ a Nãaŋmɩn 'yɛ'yɛrbɛ na yɩ lɔɔrɔ a bala a Nãaŋmɩn na tʊ̃ a yɩ sɛ̃ nɩ kʊsɩbɛ, nyɛ lɛ an ma ɩrɛ ma vɔlaa jã ka n ma bʊɔrɔ ɩka n kaal a fʊ bibiir 'mataa fɩka nʊ̃ɔ na ma ũun a wʊ bil, tɩchɛ ka faa bʊɔrɔ ɩka fʊ maal a lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","A lɛ jũu n bar a fʊ tẽe kʊ fʊ ka wʊ ɩ dakpolo. ");
INSERT INTO biv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka yɩ kʊ̃ lɛ nyɛ ma go ɛ, wa tɩ tãn yɩn na 'yɛr ɩka, ‘Nãaŋmɩn wʊ sʊ̃ʊ a 'lɔ wʊn tʊ̃.’ ” ");
INSERT INTO biv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu na wa yi a Nãaŋmɩn puorfʊ yir pɔ na wʊ chiine, a wʊ poturbo turo wile ɩka wʊ nyɛ lɛ ban mɛ a Nãaŋmɩn puorfʊ yir ka wʊ kaara. ");
INSERT INTO biv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Be lɛ a Yesu 'yɛr kʊ ba, “Mɩ yɩ mɩ nyɛ naa anyãna a jaa? Yelmãɛ jaa lɛ n 'yɛrɛ kʊrɔ yɩ, a kʊsɩvɩɛl anyãna ãsʊɔ jaa kʊ lɛ wa chɛnɛ dɔɔl a wʊ tɔ ju ɛ. Ban wa dãn a jaa lɔb.” ");
INSERT INTO biv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu na wa do jãnɛ a Olive Tɔ̃ɔju, a poturbo wan a wʊ sɛ̃ a ba tɛɛ wa sʊʊr wʊ, “'Yɛr kʊ sɩ a daar 'lɔ̃nɔ̃ a anyãna nɩ na ɩ. Bo lɛ na ɩ a jãnɛ a fʊ waa sɔ̃ɔ nɩ a wɛr baarfʊ daar?” ");
INSERT INTO biv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ka a Yesu 'yɛr kʊ ba, “Yɩ bɔ̃ɔn sʊ̃ ka nɩrɛ jaa ta wa bɛl yɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bojũu, nɩyɔɔ na de naa maa yuor waan wa 'yɛrɛ, ‘Maa lɛ a Nɩ-iraa,’ na ban bɛl nɩyɔɔ. ");
INSERT INTO biv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yɩn wa wõn tam, ka ba 'yɛrɛ a tam 'yɛr, yɩ ta mɩrɛ ɛ. A lɛ na ɩ naa, tɩchɛ a wɛr baarfʊ chɛnɛ na be puor. ");
INSERT INTO biv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Paal dẽdẽme na yin tam, ka a nãmɩne mɩ yɩ tam ka kɔ̃ mɩ lo ka a tẽe jiir amɩne dɔ̃ɔnɔ̃. ");
INSERT INTO biv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","A dɔɔyɛ anyãna, an kaara fɩka a pɔɔ na ma dɔɔrɔ ka a wõnõ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ban pãa nyɔɔr yɩn chiin na ba tɩ pɔb yɩ na ba kʊ yɩ, ka a paalsɩ a jaa 'laar yɩ, yɩn sɔɔ ma jũu. ");
INSERT INTO biv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nɩyɔɔ na bar a ba sɔɔfʊ, na ba gar 'yɔ̃ɔ taa na ba 'laar taa. ");
INSERT INTO biv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jir ŋmarba 'yɛ'yɛrbɛ na wan wa 'yɛrɛ bɛlɛ nɩyɔɔ. ");
INSERT INTO biv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nɩyɔɔ nɩ na tɔr Nãaŋmɩn nɛɛ, ba kʊ̃ nʊ̃ taa ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tɩchɛ nɩrɛ nyã na ara tɩ tãn a baaraa Nãaŋmɩn na faa wʊ naa. ");
INSERT INTO biv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ban mʊɔl a Nãaŋmɩn nãalʊ̃ʊ 'yɛr nʊ̃ɔ nyã a wɛr wʊ jaa ka a ɩ dãasɩɛ a paalsɩ a jaa pɔ, tɩchɛ ka a wɛr pãa baar. ");
INSERT INTO biv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Yɩn wa nyɛ naa a yele 'lɔ a Nãaŋmɩn na 'laar na waara nɩ sɔ̃ɔfʊ ka wʊ be a jichɛchɛ 'lɔ nɩtãa lɛ a Nãaŋmɩn 'yɛ'yɛrɛ Danɩɛl na dɔ̃ɔ 'yɛr. Vɛ̃ ka a nyã na kara bɔ̃ɔ a par. ");
INSERT INTO biv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yɩn wa nyɛ a lɛ a nɩbɛ bala na kpɩɛrɛ a Juda, ba jo do a tɔ̃ɔ ju. ");
INSERT INTO biv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nɩrɛ jaa na be gar ju, wʊ ta suu a die pɔ tɩ de bon jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","'Lɔ mɩ na be a puo pɔ wʊ ta kul a yir tɩ de a wʊ fuu ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","A bɩbir nyãna wa vɩɛ an ɩn tuo kʊ a pɔɔpʊʊr nɩ a bala na tara a bi'yɛnsɩ. ");
INSERT INTO biv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yɩ sʊɔrɔ Nãaŋmɩn ka a yɩ jofʊ ta ɩ sãɛ ɛ, bɩɩ a Pɛ̃nfʊ Bɩbir Daar ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nãaŋmɩn na maal a wɛr wa tãn a pʊ̃pãanyã, baa di a dɔɔyɛ nyã bʊrɔ ɛ, bɩɩ dɔɔyɛ kʊ̃ lɛ wa jã wʊ go ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ala ɩ a Nãaŋmɩn ba ŋmaa a ber ala bar ɛ, nɩrɛ kʊ̃ lɛ chɛnɛ go ɛ. Tɩchɛ a bala wʊn chɛl ir jũu wʊn ŋmaan a ber bar. ");
INSERT INTO biv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","A lɛ daar nɩrɛ wa 'yɛr yɩ ɩka, ‘Nyɛ a Nɩ-iraa,’ bɩɩ ‘'Lɔ nɩ nyã,’ yɩ ta sɔɔ de ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bojũu jirsɩ Nɩ-irsɩ nɩ jirsɩ 'yɛ'yɛrbɛ na wa naa wa tʊ̃nɔ̃ nɛ'maa tʊ̃mɔ̃ na ba bɛl nɩbɛ bamɩne ala ɩ ba tʊ̃ɔ naa ban 'mantaa bɛl a bala a Nãaŋmɩn na chɛl ir. ");
INSERT INTO biv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yɩ nyɛ, n den nie 'yɛrɛ kʊrɔ yɩ. ");
INSERT INTO biv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“A lɛ jũu, bala wa 'yɛr kʊ yɩ ɩka, ‘Nyɛ 'lɔ nɩ nyã a dãlpʊɔ ju,’ yɩ ta yi a be ɛ. ‘Bala wa 'yɛr nyɛ, 'lɔ nɩ nyã a die pɔ,’ yɩ ta sɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","A lɛ a saa nyɩɩrfʊ na ma yi a mɔ̃tɔ̃ɔ purfʊ jie na wʊ chaar 'yɔ̃ɔ a mɔ̃tɔ̃ɔ mʊrfʊ jie, lɛ lɛ a maa Nɩsaal Bie waa mɩ na kaara. ");
INSERT INTO biv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jie 'lɔ jaa bʊ̃kũu na be, be lɛ a sɩdumo ma 'laara. ");
INSERT INTO biv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ajienaa, a ber anyãna a dɔɔyɛ baarfʊ puor, ‘A mɔ̃tɔ̃ɔ na lii naa, ka a chuu mɩ kʊ̃ lɛ chaar ɛ, ka a ŋmɛrbie pɔrɔ yire a saaju loro, ka a saaju bonsɩ a jaa dɔ̃ɔnɔ̃.’ ");
INSERT INTO biv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“A sɔ̃ɔ 'lɔ̃nɔ̃ lɛ ban nyɛ a maa Nɩsaal Bie na waara a julõjuur pɔ, ka a paalsɩ a jaa na be ka a wɛr pɔ kõnõ. Ka ba nyɛ a maa Nɩsaal Bie na yi a saaju a julõjuur pɔ, waara nɩ kpɛ̃ɔ nɩ tɩɩr. ");
INSERT INTO biv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wʊn tʊ̃n a wʊ malakasɩ ka ba pɛɛl a ɩɩl kpɛ̃ɔ jaa na ba bʊɔl a nɩbɛ bala wʊn chɛl ir a wɛr wʊ jaa 'mataa. ");
INSERT INTO biv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Yɩ de a pɔlpɔl tɩɛr yele jãn yɛ̃. 'Lɔ wa tʊɔrɔ a vaar, yɩ bɔ̃ɔn ɩka a tʊl sɔɔ gbʊr naa. ");
INSERT INTO biv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","A lɛ nɩ wʊ ju mɩ lɛ, yɩn wa nyɛ a yelsɩ anyãna, yɩ bɔ̃ɔn ɩka a maa Nɩsaal Bie waa gbʊr naa jaa yɛ̃yɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, a pʊ̃pãanyã nɩbɛ kʊ̃ kpi baar ɛ, wa tɩ tãn a yelsɩ anyãna na ɩ. ");
INSERT INTO biv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A saaju nɩ a wɛr na wa baaraa, tɩchɛ maa 'yɛrbie 'lɔ kʊ̃ wa baar ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nɩrɛ jaa ba bɔ̃ɔ a bɩbir nyã ɛ, bɩɩ a sɔ̃ɔ ɛ, a malakasɩ mɩ gba na be a saaju ba bɔ̃ɔ ɛ, bɩɩ a Bie ɛ, ka a Sãa tɛɛ ba lɛ bɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","A lɛ an dɔ̃ɔ kaara a Nowa sɔ̃ɔ, lɛ lɛ an mɩ na kaara a maa Nɩsaal Bie waa sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bojũu sɛrɛ, tɩchɛ ka a kɔ̃paalaa wa nɩbɛ dire na, tɩ nyuro, ka dɔɔr nɩ pɔbɔ kulo taa, tɩ tãn a bɩbir 'lɔ a Nowa na kpɛ a daka bulomtum pɔ. ");
INSERT INTO biv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Baa bɔ̃ɔn ɛ, tɩ tãn a sɔ̃ɔ 'lɔ a kɔ̃paalaa na wa di ba, lɛ mɩ lɛ an kaara a maa Nɩsaal Bie waa daar. ");
INSERT INTO biv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nɩbɛ ayi na ben puo pɔ, ka a Nãaŋmɩn wa de a ãsʊɔ chiin tɩ bar a ãsʊɔ. ");
INSERT INTO biv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pɔbɔ ayi na 'mantaa nɩɛnɛ jɔ̃ ka a Nãaŋmɩn wa de a ãsʊɔ chiin tɩ bar a ãsʊɔ. ");
INSERT INTO biv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“A lɛ jũu yɩ kaara sʊ̃, bojũu yaa bɔ̃ɔ a bɩbir 'lɔ a yɩ Soro nɩ na wa ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tɩchɛ yɩ bɔ̃ɔn a yele anyã par, a yir sʊɔ ta bɔ̃ɔn a sɔ̃ɔ 'lɔ a nãnyie na waara a tãsɔɔ, wʊ kʊ̃ naa gur ɛ, ka a nãnyie wa kar kpɛ wʊ a yir ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","A lɛ jũu, yɩ mɩ guro a yɩ mãɛ, bojũu a maa Nɩsaal Bie na wan a sɔ̃ɔ 'lɔ yɩn kʊ̃ bɔ̃ɔn ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“An lɛ a nɩrɛ 'lɔ na ɩ a yɛ̃ nɩ a yelmãɛ sʊɔ a wʊ nɩkpɛ̃ɛ na 'yɔ̃ɔ ka wʊ kaara wʊ a yir na wʊ kʊrɔ a tʊ̃tʊ̃nbɔ a ba bʊ̃diir a sɔ̃ɔ 'lɔ wʊn 'yɔ̃ɔ wʊ? ");
INSERT INTO biv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","An ɩn bɔɔsʊ̃n kʊ a tʊ̃tʊ̃nɔ̃ nyãna a wʊ nɩkpɛ̃ɛ na wa nyɛ ka wʊ ɩrɛ a lɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, wʊn vɛ̃n ka wʊ kaara a wʊ bonsɩ a jaa. ");
INSERT INTO biv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tɩchɛ ala ɩ a tʊ̃tʊ̃nɔ̃ nyãna ɩn putusʊɔ na wʊ tɩɛr a wʊ nyãa pɔ ɩka, a n nɩkpɛ̃ɛ kor naa, ");
INSERT INTO biv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","tɩ piel gere a tʊ̃tʊ̃nbɔ bala na be a yir tɩ pãa ma di na wʊ ma pʊɔ a dãnyurbo pɔ, ");
INSERT INTO biv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","a wʊ nɩkpɛ̃ɛ na wa dũu wʊ naa a bɩbir 'lɔ wʊn ba tɩɛr nɩ a sɔ̃ɔ 'lɔ wʊn ba bɔ̃ɔn ɛ. ");
INSERT INTO biv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wʊn ŋma wʊn gbʊl gbʊl 'yɔ̃ɔ a nɛɛr ayi dẽme pɔ, be lɛ ban kõnõ tɩ ɔɔrɔ nyɩmɛ. ");
INSERT INTO biv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“A sɔ̃ɔ 'lɔ̃nɔ̃, a Nãaŋmɩn nãalʊ̃ʊ na kaara fɩka pɔɔsarsɩ pie na de a ba fãtɩnɛ ɩka ba tɩ tuor a pɔɔ paalaa nɩ a wʊ sɩrɛ. ");
INSERT INTO biv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ka a ba anũu ɩ jɔlɔ, tɩchɛ ka a ba anũu mɩ ɩ yɛ̃ dẽme. ");
INSERT INTO biv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","A jɔlɔ bala den a ba fãtɩnɛ tɩchɛ baa de kãa pʊɔ ɛ, ");
INSERT INTO biv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","tɩchɛ ka a ba anũu bala mɩ na ɩ a yɛ̃ dẽme, de kãa pʊɔ a ba fãtɩnɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A pɔɔ paalaa sɩrɛ na wa kor a waa jũu, gʊ̃ɔ kpɛ ba naa ka ba gã gur. ");
INSERT INTO biv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“A tãsɔɔ bãɩn lɛ ba ŋme chɛlma tãna 'yɛrɛ, ‘A pɔɔ paalaa sɩrɛ waara, yɩ yi wa tuor wʊ yooo.’ ");
INSERT INTO biv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“A pɔɔsarsɩ pie banyãna vaan ir tɩɛ tɩɛ a ba gonsɩ 'yɔ̃ɔ a ba fãtɩnɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A jɔlɔ bala 'yɛr kʊ a yɛ̃ dẽme, ‘Yɩ pʊr a yɩ kãa amɩne kʊ sɩ, a sɩ bonsɩ kpĩine naa.’ ");
INSERT INTO biv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Be lɛ ka a yɛ̃ dẽme bala 'yɛr kʊ ba, ‘Kai, a kʊ̃ ta sɩ nɩ a yɩn ɛ. Yɩ chen a be ban daara na yɩ tɩ da.’ ");
INSERT INTO biv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Tɩchɛ, ban lɩɛb chiine a dafʊ jie, a pɔɔ paalaa sɩrɛ wa naa, ka a bala jaa na chɔɔr 'mataa kpɛ a pɔɔ paalaa kulfʊ jie, tɩ na ba nyɔɔ a pãn pɔɔ. ");
INSERT INTO biv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“A jɔlɔ anũu bala mɩ wa bɩɛr wa na ba mɩ wa kpooro a pãn 'yɛr, ‘Nɩkpɛ̃ɛ, nɩkpɛ̃ɛ, yuo a pãn ka sɩ kpɛ.’ ");
INSERT INTO biv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Tɩchɛ ka wʊ 'yɛr kʊ ba, ‘Yelmãɛ jaa, n ba bɔ̃ɔ yɩ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“A lɛ jũu yɩ gu yɩ mãɛ bojũu yaa bɔ̃ɔ a bɩbir bɩɩ a sɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“A mɩ lɛ nyɛntãan go fɩka daba kɔ̃ɔ na bʊɔrɔ yɔfʊ na wʊ bʊɔl a wʊ gbãgbaar 'mataa de a wʊ bonsɩ põ ba. ");
INSERT INTO biv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wʊ kʊn ãsʊɔ sɛlbie anũu, na wʊ kʊ ãsʊɔ mɩ sɛlbie ayi na wʊ kʊ ãsʊɔ mɩ sɛlbir bʊ̃'yen. Wʊ ma kʊn ãsʊɔ jaa man a wʊ fɔ̃ɔ, tɩ na wʊ yɔ. ");
INSERT INTO biv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","A 'lɔ na de a sɛlbie anũu tɩ yar nyɛ sɛlbie anũu tʊ̃nɔ̃ dɔɔl. ");
INSERT INTO biv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","A 'lɔ mɩ na de a sɛlbie ayi tɩ yar mɩ nyɛ sɛlbie ayi tʊ̃nɔ̃ dɔɔl. ");
INSERT INTO biv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tɩchɛ a 'lɔ na de a sɛlbir bʊ̃'yen tɩ tuun bɔɔ de a wʊ nɩkpɛ̃ɛ sɛlbir ũu. ");
INSERT INTO biv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“An wa kor bãlãa ka a gbãgbaar bala nɩkpɛ̃ɛ wa wa ɩka ba guor a sɛlbie yele. ");
INSERT INTO biv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","A 'lɔ na de a sɛlbie anũu waan na sɛlbie anũu wa 'yɛr, ‘Nɩkpɛ̃ɛ, sɛlbie anũu lɛ fʊ dɔ̃ɔ kʊ ma, nyɛ sɛlbie anũu tɔ̃nɔ̃ lɛ n nyɛ dɔɔl.’ ");
INSERT INTO biv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ka a wʊ nɩkpɛ̃ɛ 'yɛr kʊ wʊ, ‘Fʊ tʊ̃n vɩla, gbãgbamãɛ lɛ fʊ ɩ. Fʊ tara na yelmãɛ a bʊ̃bile pɔ, ɩn 'yɔ̃ɔ fʊn ka fʊ kaara bʊ̃yɔɔ. Wa pʊɔ ma ka sɩ 'mataa dire a nʊ̃ɔ.’ ");
INSERT INTO biv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“A 'lɔ mɩ wʊn kʊ a sɛlbie ayi wa 'yɛr kʊ a wʊ nɩkpɛ̃ɛ, ‘Fʊ dɔ̃ɔ kʊ ma sɛlbie ayi, nyɛ sɛlbie ayi tʊ̃nɔ̃ lɛ n nyɛ dɔɔl.’ ");
INSERT INTO biv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ka a wʊ nɩkpɛ̃ɛ 'yɛr kʊ wʊ, ‘Fʊ tʊ̃n vɩla, gbãgbamãɛ lɛ fʊ ɩ. Fʊ tara na yelmãɛ a bʊ̃bile pɔ, ɩn 'yɔ̃ɔ fʊn ka fʊ kaara bʊ̃yɔɔ. Wa pʊɔ ma ka sɩ 'mataa dire a nʊ̃ɔ.’ ");
INSERT INTO biv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“A 'lɔ mɩ wʊn kʊ a sɛlbir bʊ̃'yen wa 'yɛr naa, ‘Nɩkpɛ̃ɛ, n bɔ̃ɔn na fʊn ɩ nɩbikõo sʊɔ na fʊ ma ŋma a be fʊn ba bʊr ɛ, na fʊ ma wob a be fʊn maa yaar bar ɛ. ");
INSERT INTO biv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ala lɛ so ka dãbãɛ kpɛ ma ka de a fʊ sɛlbir tɩ ũu bar. Nyɛ a fʊ sɛlbir.’ ");
INSERT INTO biv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ka a wʊ nɩkpɛ̃ɛ 'yɛr kʊ wʊ, ‘Fʊ̃ʊ gbãgbaputuo nɩ koro sʊɔ nyã. Fʊn ben bɔ̃ɔn ɩka n ma ŋman a be ɩn maa bʊr ɛ, naa wob a jie 'lɔ ɩn maa yaar bar ɛ, ");
INSERT INTO biv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","a ta sɛɛn ɩka fʊ ta de a n sɛlbir tɩ yɔ̃ɔ a libie yir pɔ, ka maa ta wa lɩɛb wa ka n nyɛ tʊ̃nɔ̃ dɔɔl ɛ? ");
INSERT INTO biv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Yɩ faa a sɛlbir bʊ̃'yen a wʊ sɛ̃ na yɩ kʊ a nɩrɛ 'lɔ na tara a sɛlbie pie. ");
INSERT INTO biv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nɩrɛ 'lɔ jaa na tara yɔɔ, ban kʊ wʊn yɔɔ pʊɔ ka ba tara yɔɔ tɩchɛ a nɩrɛ 'lɔ na ba tara bon jaa ɛ, a bãlãa 'lɔ wʊn tara gba ban faan yin a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","A gbãgbaburbur nyã 'lɔ, yɩ de wʊ lɔb bar yõo be lɛ ban kõnõ tɩ ɔɔrɔ nyɩmɛ.’ ");
INSERT INTO biv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“A maa Nɩsaal Bie wa wa a n tɩɩr pɔ, nɩ a n malakasɩ ba jaa, ɩn wa jãnɛ naa, a n tɩɩr nãalʊ̃ʊ dakɔɔ ju. ");
INSERT INTO biv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","A paalsɩ a jaa na pãa lɔ̃ɔ taa a n niem, ka n pãa oor a nɩbɛ nɩtãa lɛ pɛchinɛ na ma oor a piir nɩ a bʊʊr. ");
INSERT INTO biv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ɩn oon a piir bar a n nũsʊ̃ɔ jie, tɩchɛ ka a bʊʊr mɩ ara a n gʊbaa jie. ");
INSERT INTO biv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ka n pãa 'yɛr kʊ a bala na be a n nũsʊ̃ɔ jie, ‘Yɩ wa, yɩn a n Sãa Nãaŋmɩn na sʊ̃ʊ. Yɩ wa kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ, de a yɩ nãbomo wʊn chɔɔr bin gun yɩ a wɛr pielfʊ sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bojũu kɔ̃ dɔ̃ɔ kpɛ ma, ka yɩ kʊ ma ka n di, kɔ̃nyũur dɔ̃ɔ kpɛ ma, ka yɩ kʊ ma kʊ̃ɔ ka n nyũ, n dɔ̃ɔ ɩ sãan ka yɩ ir ma sãan. ");
INSERT INTO biv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","N ba dɔ̃ɔ tara bʊ̃sursɩ ɛ, ka yɩ kʊ ma fuu ka n su, n dɔ̃ɔ bɩɛrɛ ka yɩ sãa ma. N dɔ̃ɔ be pɔɔfʊ die pɔ, ka yɩ wa piir ma kaa.’ ");
INSERT INTO biv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“A nɩmɩn na pãa lɩɛb sʊʊr wʊ, ‘Sɩ Soro, nyɩnɛ lɛ sɩ nyɛ fʊ, ka a kɔ̃ kpɛ fʊ, ka sɩ kʊ fʊ bʊ̃diir a fʊ di, bɩɩ ka kɔ̃nyũur kpɛ fʊ, ka sɩ kʊ fʊ kʊ̃ɔ a fʊ nyũ? ");
INSERT INTO biv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Sɔ̃ɔ buor lɛ sɩ nyɛ fʊ, ka fʊ ɩ sãan ka sɩ ir fʊ a sãan, bɩɩ ka faa tara bʊ̃sursɩ ɛ, ka sɩ kʊ fʊ fuu a fʊ su? ");
INSERT INTO biv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Sɔ̃ɔ buor lɛ sɩ nyɛ fʊ, ka fʊ bɩɛrɛ, ka sɩ tɩ piir fʊ kaa, bɩɩ sɔ̃ɔ buor lɛ ba nyɔɔ fʊ pɔɔ ka sɩ chen tɩ piir fʊ kaa?’ ");
INSERT INTO biv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“A nãa na 'yɛr kʊ ba, ‘Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, a lɛ yɩn dɔ̃ɔ maal kʊ a nɩba'yɔ̃ɔnsɩ bala na ɩ a n sofʊ, maa lɛ yɩ maal kʊ.’ ");
INSERT INTO biv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Tɩchɛ na wʊ pãa 'yɛr kʊ a bala mɩ na be a wʊ gʊbaa jie, ‘Pɔ 'yɔ̃ɔfʊ turo yɩ naa, yɩ tɔɔ chen be na yɩ tɩ kpɛ a bũu 'lɔ a Nãaŋmɩn na gbɔɔ gun a tɩɩ nɩ a wʊ malakasɩ. ");
INSERT INTO biv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bojũu kɔ̃ dɔ̃ɔ kpɛ ma, ka yaa kʊ ma bon jaa ka n di ɛ. Kɔ̃nyũur dɔ̃ɔ kpɛ ma, ka yaa kʊ ma kʊ̃ɔ ka n nyũ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","N dɔ̃ɔ ɩ sãan, ka yaa kaa ma sãan kaa fʊ ɛ, n ba tara bon jaa na su ɛ, ka yaa kʊ ma fuu ka su ɛ, ka n bɩɛrɛ, bɩɩ be pɔɔfʊ die pɔ, ka yaa wa piir ma kaa ɛ.’ ");
INSERT INTO biv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ka ba pãa mɩ lɩɛb sʊʊr wʊ, ‘Sɩ Soro, sɔ̃ɔ buor lɛ sɩ nyɛ fʊ, ka a kɔ̃ kpɛ fʊ, bɩɩ ka a kɔ̃nyũur kpɛ fʊ, bɩɩ ka fʊ ɩ sãan, bɩɩ ka faa tara bon jaa na su ɛ, bɩɩ ka fʊ bɩɛrɛ, bɩɩ ka fʊ be pɔɔfʊ die pɔ, ka saa kaa fʊ ɛ?’ ");
INSERT INTO biv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Wʊ 'yɛr kʊ ba, ‘Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, yɩn ba maal kʊ a nɩba'yɔ̃ɔnsɩ bala ãsʊɔ ɛ, maa lɛ yaa maal kʊ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“A nɩbɛ banyãna na chen a dɔɔyɛ 'lɔ na ba tara baarfʊ jie, tɩchɛ ka a nɩmɩn mɩ chen a nyɛvʊr na ba tara baarfʊ jie.” ");
INSERT INTO biv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","A Yesu na wa 'yɛr a anyãna a jaa baar, wʊ 'yɛr kʊ a wʊ poturbo, ");
INSERT INTO biv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Yɩ bɔ̃ɔn ɩka a chɛn ber ayi ka a Gõl Bar Difʊ na ta, ka ba na de a maa Nɩsaal Bie tɩr ka ba kpa ma a daa ju.” ");
INSERT INTO biv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a nɩbɛrɛ lɔ̃ɔ taa a bɔɔrlo nɩkpɛ̃ɛ yir na di Kayafasɩ, ");
INSERT INTO biv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","na ba bʊɔrɔ vuo ban na tu nyɔɔ a Yesu na ba kʊ. ");
INSERT INTO biv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tɩchɛ ka ba 'yɛr, a ta ɩ a Gõl Bar Difʊ sɔ̃ɔ ɛ, ka jɛɛr taa ɩrɛ wa ir a chara pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu na wa be a Betanɩ a Simon 'lɔ na dɔ̃ɔ ɩ a kɔ̃kɔ̃mɔ̃ yir, ");
INSERT INTO biv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ban wa jɛ̃ dire, pɔɔ kɔ̃ɔ waan na pãrtɔvɩla nɩ kãnyũu kɔ̃ɔ dafʊ na ba wõnõ ɛ, na wʊ kpaar dɔɔl a Yesu ju. ");
INSERT INTO biv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","A poturbo na wa nyɛ a lɛ, ba nyɛn suur na ba 'yɛr, “Bo lɛ so ka wʊ sɔ̃ɔnɔ̃ a kãnyũu nyã bar a nɩtɔ̃? ");
INSERT INTO biv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Fʊn taa den a kãnyũu anyãna da libiyɔɔ de kʊ a nɔ̃n dẽme.” ");
INSERT INTO biv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu na bɔ̃ɔn a ba tɩɛr, wʊ 'yɛr kʊ ba, “Bãa 'yɔ̃ɔ lɛ yɩ mii 'yɔ̃ɔ wʊ? Wʊ maal vɩla kʊ ma. ");
INSERT INTO biv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A nɔ̃n dẽme 'lɔ, yɩn nɩ bala ben ka tɩchɛ maa kʊ be a yɩ sɛ̃ sɔ̃ɔ jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wʊn kpaar a kãnyũu anyãna 'yɔ̃ɔ ma, wʊ maal a lɛ chɔɔr ma gun a n ũufʊ. ");
INSERT INTO biv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, jie jaa ban wa mʊɔl a 'yɛr nʊ̃ɔ nyãna a wɛr wʊ jaa pɔ, ban 'yɛr naa a lɛ a pɔɔ nyã na ɩ na ba chɛnɛ tara a wʊ tɩɛr.” ");
INSERT INTO biv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","A Pie Nɩ Ayi bala ãsʊɔ ban bʊɔlɔ Judas Isɩkariyot chen a Juu nɩbɛ bɔɔrlo nɩbɛrɛ sɛ̃ ");
INSERT INTO biv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","tɩ sʊʊr ba, “Bo lɛ yɩn kʊ ma ala ɩ n de wʊn 'yɔ̃ɔ a yɩ nuur pɔ?” Ba sɔr sɛlbie lɩjɛr nɩ pie kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","An yɩ a sɔ̃ɔ 'lɔ̃nɔ̃ wʊ bʊɔrɔ na vuo wʊn na tu de a Yesu 'yɔ̃ɔ a ba nuur pɔ. ");
INSERT INTO biv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","A bɩbir dɔ̃ɔ 'lɔ̃nɔ̃ ɩ naa a Paanʊ̃kõo Lɔ̃ɔfʊ, ka a Yesu poturbo wa sʊʊr wʊ, “Nyɩnɛ lɛ fʊ bʊɔrɔ ɩka sɩ chen tɩ chɔɔr a Gõl Bar nyã Difʊ bar ka sɩ tɩ di?” ");
INSERT INTO biv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ka wʊ 'yɛr kʊ ba, “Yɩ chen a tẽe pɔ, daba kɔ̃ɔ sɛ̃ na yɩ tɩ 'yɛr kʊ wʊ, ‘A wiwile 'yɛr naa, a n sɔ̃ɔ gbʊr naa, ka maa nɩ a n poturbo na di a Gõl Bar Difʊ a fʊ yir.’ ” ");
INSERT INTO biv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A poturbo ɩn a lɛ jaa a Yesu na 'yɛr ɩka ba ɩ. Ka ba maal a Gõl Bar bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","A jãanʊɔr na wa ta, Yesu nɩ a wʊ poturbo Pie nɩ Ayi wa jɛ̃n jil a bʊ̃diir na di. ");
INSERT INTO biv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ban wa dire, wʊ 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, a yɩ ãsʊɔ na gar 'yɔ̃ɔ ma.” ");
INSERT INTO biv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Be lɛ ka ba jaa pʊʊr sɔ̃ɔ ka ba sʊrɔ wʊ bʊ̃'yen 'yen, “An ɩn maa lɛ ɔ, n Soro?” ");
INSERT INTO biv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ka a Yesu 'yɛr, “A 'lɔ ɩn 'mataa tun ala bʊ̃'yen pɔ lɛ na gar 'yɔ̃ɔ ma. ");
INSERT INTO biv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A maa Nɩsaal Bie na kpi naa nɩtãa lɛ ban sɛb a Nãaŋmɩn gãn pɔ. Tɩchɛ nɛbier ben a nɩrɛ 'lɔ na gar 'yɔ̃ɔ a maa Nɩsaal Bie wʊn din dɔɔyɛ gar nɩrɛ jaa. Bala ta ba dɔɔ wʊ ɛ, ala sa.” ");
INSERT INTO biv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas a 'lɔ na gar 'yɔ̃ɔ wʊ sʊʊr, “An ɩn maa lɛ ɔ, Wiwile?” Ka a Yesu sɔɔ, “Ɔ̃ɔ, fʊ̃ʊ lɛ.” ");
INSERT INTO biv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ban wa dire, Yesu den a paanʊ̃ɔ puor Nãaŋmɩn yãan na wʊ ŋma de kʊ a wʊ poturbo, tɩ na wʊ 'yɛr, “Yɩ de 'wɔb, a maa ãgãn lɛ.” ");
INSERT INTO biv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wʊ lɛ den a ŋmele 'lɔ ban nyuro nɩ, na wʊ puor Nãaŋmɩn yãan tɩ lɛ de kʊ ba, “Yɩ jaa yɩ de nyũ. ");
INSERT INTO biv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","A anyãna lɛ ɩ a n jãɩ na ɩ a nɛtɩraa ɩn tara nɩ yɩ na tara kpɛ̃ɔ. An kpaar na a faa nɩyɔɔ ka yelbier vɛ̃ kʊfʊ be be. ");
INSERT INTO biv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","N 'yɛrɛ na kʊrɔ yɩ ɩka, n kʊ̃ lɛ nyũ a dãa anyãna ɛ, wa tɩ tãn a daar 'lɔ̃nɔ̃ ɩn na 'mataa nyũn yɩ a dãpaalaa a n Sãa nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ban wa yiel a yiel dãn Nãaŋmɩn, ba suun chen a Olive Tɩɩr Tɔ̃ɔ ju. ");
INSERT INTO biv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu 'yɛr kʊ ba, “Yɩ jaa na jon a tãsɔɔ nyãna tɩ bar ma a n yõ, a maa jũu. A sɛb a Nãaŋmɩn gãn pɔ ɩka, ‘Ɩn ŋme naa pɛchinɛ kʊ ka a piir yɛ̃yɛl.’ ");
INSERT INTO biv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tɩchɛ maa wa ir a kũu pɔ, ɩn dɔ̃ɔ yɩn nie chen a Galilee.” ");
INSERT INTO biv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ka a Pita 'yɛr kʊ wʊ, “Ala ɩ ba jaa sɔɔn bar fʊ a fʊ jũu, maa 'lɔ kʊ̃ bar fʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu 'yɛr kʊ a Pita, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ fʊ, ɩka a tãsɔɔ nyãna a nɔrdɔ̃ɔ kʊ̃ kõ ɛ, tɩchɛ ka fʊ chiir ma gbɛɛ ata.” ");
INSERT INTO biv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tɩchɛ ka a Pita 'yɛr kʊ wʊ ɩka, “Ala ɩ maa nɩ fʊ̃ʊ na 'mataa kpi gba, tɩ n kʊ̃ 'yɛr ɩka n ba bɔ̃ɔ fʊ ɛ.” Ka a poturbo bala mɩ na chɛ 'yɛr a lɛ nɛ. ");
INSERT INTO biv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu nɩ a wʊ poturbo chen a jie 'lɔ ban bʊɔlɔ a Getɩsemanɩ, ka wʊ 'yɛr kʊ ba, “Yɩ jãnɛ a kana tɩchɛ ka n chen tɩ sʊɔr Nãaŋmɩn.” ");
INSERT INTO biv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Be lɛ wʊ tara Pita nɩ Jebedee bibiir ayi ka a wʊ pʊɔ sɔ̃ɔ yɔɔ jaa ka tɩɛr nyɔɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ka wʊ 'yɛr kʊ ba, “N tɩɛr sɔ̃ɔ naa, tɩ nyɛtãan kũn, yɩ jãnɛ a ka na gu ma.” ");
INSERT INTO biv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wʊ chen a niem bãlãa tɩ lo kpa tẽe sʊɔrɔ Nãaŋmɩn 'yɛrɛ, “N Sãa ala ɩ a tara naa ɩfʊ kɔ̃ɔ, vɛ̃ ka a dɔɔyɛ ŋmele nyãna po ma. Tɩchɛ a ta ɩ lɛ maa na bʊɔrɔ ɛ, tɩ a ɩ a lɛ fʊ̃ʊ na bʊɔrɔ.” ");
INSERT INTO biv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wʊ lɩɛb wa a poturbo sɛ̃ wa nyɛ ka ba guro. Ka wʊ 'yɛr kʊ ba, “A mɔ̃ yɩ kʊ̃ tʊ̃ɔ jɛ̃ bãlãa jaa gu ma ɛ? ");
INSERT INTO biv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yɩ jɛɔ chɛlɛ, na yɩ sʊɔrɔ Nãaŋmɩn ka a bɛɛr kaa ta wa nyɔɔ yɩ ɛ. A ba tɩɛr bʊɔrɔ naa tɩchɛ ka a ba ãgãma ba tʊɔr ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wʊ lɛ chen a gbɛɛ ayi sʊɔ tɩ sʊɔr Nãaŋmɩn. “N Sãa, ala ɩ a dɔɔyɛ ŋmele nyã kʊ̃ tʊ̃ɔ po ma ɛ, ka maa ba nyũn wʊ ɛ, fʊ̃ʊ bɔfʊ wʊ ɩ.” ");
INSERT INTO biv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wʊ lɛ wan wa nyɛ ka ba chɛnɛ guro, bojũu gʊ̃ɔ kpɛ ba naa. ");
INSERT INTO biv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Be lɛ wʊ lɛ bar ba tɩ chen a gbɛɛ ata sʊɔ tɩ sʊɔr Nãaŋmɩn a lɛ nɛ nɩ wʊ ju. ");
INSERT INTO biv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wʊ lɩɛb wa a poturbo sɛ̃ wa sʊʊr ba, “Yɩ chɛnɛ na gã guro na yɩ pɛnɛ wɛ? Nyɛ, a sɔ̃ɔ ta naa ka ban gar 'yɔ̃ɔ a maa Nɩsaal Bie de wʊ kʊ a yelbe-ɩrbɛ. ");
INSERT INTO biv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yɩ vaa ir ka sɩ chen. Yɩ nyɛ a gagaraa na waara.” ");
INSERT INTO biv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","A Yesu na chɛnɛ 'yɛrɛ, ka Judas na ɩ a wʊ poturbo Pie nɩ Ayi ãsʊɔ, tɩ daasãa nɩ nɩbɛ na yi a Juu nɩbɛ bɔɔrlo nɩbɛrɛ sɛ̃ waara nɩ sɔbɛrɛ nɩ dakʊrsɩ a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A Judas dɔ̃ɔ man ba ɩka, a 'lɔ wʊn tɩ puor tɩ mʊʊr a kɔtɩr 'lɔ lɛ, yɩ nyɔɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ban wa tɩ ta, Judas pɔɔn chen tɩ 'yɛr, “Wiwile, n puor fʊ naa,” tɩ mʊʊr a Yesu kɔtɩr. ");
INSERT INTO biv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ka Yesu 'yɛr kʊ wʊ, “N badaba, tʊ̃ a lɛ fʊn bʊɔrɔ ɩka fʊ tʊ̃.” Be lɛ ba wa nyɔɔ a Yesu. ");
INSERT INTO biv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Be lɛ ka a Yesu poturbo ãsʊɔ na ara gbʊr wʊ vʊ̃ɔ a sʊɔ chen a Juu dẽme bɔɔrlo nãa gbãgbaa toor ŋmaa. ");
INSERT INTO biv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Be lɛ ka a Yesu 'yɛr kʊ wʊ, “De a sʊɔ su a sʊkpa pɔ, bala na jɛɛrɛ nɩ a sʊɔ na kpin a sʊɔ kũu. ");
INSERT INTO biv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Fʊ tɩɛr ɩka n kʊ̃ tʊ̃ɔ bʊɔl a n Sãa ka wʊ sʊ̃ʊ ma nɩ a malakasɩ gbulo pie nɩ ayi bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tɩchɛ ŋmɩnɛ lɛ an ɩrɛ wa ɩ yelmãɛ a lɛ a Nãaŋmɩn gãma na 'yɛr ɩka a nɩtɔ̃ lɛ na ɩ?” ");
INSERT INTO biv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A sɔ̃ɔ 'lɔ̃nɔ̃, a Yesu sʊʊr a nɩyɔɔ bala, “A mɔ̃ nɩbier lɛ n ɩ ka yɩ waan sʊʊr nɩ dakʊrsɩ a n nyɔɔ fʊ jie wɛ? Bɩbir jaa lɛ n ma jãnɛ wile yɩ a puorfʊ yir bɛchaar pɔ, tɩ yaa nyɔɔ ma ɛ. ");
INSERT INTO biv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tɩchɛ a ɩ naa a lɛ ka a lɛ a Nãaŋmɩn 'yɛ'yɛrbɛ na dɔ̃ɔ 'yɛr a Nãaŋmɩn gãma pɔ ɩ yelmãɛ.” Be lɛ ka a Yesu poturbo ba jaa bar wʊ tɩ jo. ");
INSERT INTO biv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","A bala na nyɔɔ a Yesu, chiin wʊ naa a Juu nɩbɛ bɔɔrlo nãa Kayafasɩ sɛ̃, ka a nɛɛ wiwiilbe nɩ a nɩbɛrɛ ba jaa wa lɔ̃ɔ taa. ");
INSERT INTO biv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tɩchɛ ka Pita be a puor jaa turo, na wʊ tɩ kpɛ a bɔɔrlo nãa yir bɛchaar pɔ, tɩ lɔ̃ɔ jãnɛ nɩ a gugurbo, ɩka wʊ nyɛ lɛ an na baar. ");
INSERT INTO biv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ka a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a 'yɛr tɔɔrfʊ nɩbɛrɛ pãa bʊɔrɔ jir ŋmarba ka ba na ŋmaa jire 'yɔ̃ɔ wʊ, ka ba na tu a be kʊ a Yesu. ");
INSERT INTO biv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tɩchɛ baa nyɛ yele jaa a wʊ 'yɔ̃ɔ ɛ. Nɩyɔɔ daan yi ŋma jiryɔɔ 'yɔ̃ɔ wʊ, tɩchɛ ka a ba 'yɛrbie ɩ jirsɩ. A baaraa nɩbɛ ayi daan yi ");
INSERT INTO biv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na ba 'yɛr ɩka, “A daba nyãna lɛ 'yɛr ɩka, ‘Ɩn tʊ̃ɔ ŋmɛr a Nãaŋmɩn puorfʊ yir nyãna bar tɩ de ber ata lɛ mɛn wʊ.’ ” ");
INSERT INTO biv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A be lɛ ka a Juu nɩbɛ bɔɔrlo nãa ir ara tɩ sʊʊr a Yesu, “Faa tara 'yɛr jaa na 'yɛr bɩɩ? Bo dãasɩɛ lɛ a anyã ban dire dɔɔlɔ fʊ?” ");
INSERT INTO biv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tɩchɛ ka a Yesu ɩ jaa gbul. Be lɛ ka a Juu nɩbɛ bɔɔrlo nãa 'yɛr, “N sʊrɔ fʊ naa a Nãaŋmɩn nyã na ɩ a vʊr niem, ɩka fʊ 'yɛr kʊ sɩ, ala ɩ fʊ̃ʊ lɛ ɩ a Nɩ-iraa na ɩ a Nãaŋmɩn Bie.” ");
INSERT INTO biv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ka a Yesu 'yɛr kʊ wʊ, “Ɔ̃ɔ, a lɛ nɛ fʊn 'yɛr lɛ. Tɩchɛ yɩ jaa lɛ n 'yɛrɛ kʊrɔ ɩka daar kɔ̃ɔ, yɩn nyɛn a maa Nɩsaal Bie na jãnɛ a Kpɛ̃ɔ Sʊɔ nũsʊ̃ɔ jie. Yɩ mɩ na lɛ nyɛ ma naa ka n yɩ a julõjuur pɔ waara.” ");
INSERT INTO biv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ka a bɔɔrlo nãa tɔɔ a fuu chɩɛr tɩ 'yɛr, “Wʊ sɔ̃ɔn Nãaŋmɩn yuor. Bo lɛ so sɩn chɛnɛ bʊɔrɔ dãasɩdirbe? Yɩ wõn wʊ tʊ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ŋmɩnɛ lɛ yɩ tɩɛr?” Ka ba 'yɛr, “Wʊ sɛɛn kũu.” ");
INSERT INTO biv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ba chir nataar 'yɔ̃ɔ wʊ a nie pɔ, tɩ ma gbul nũu ŋmen wʊ, ka bamɩne mɩ ma 'ma wʊ, ");
INSERT INTO biv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tɩ sʊʊr, “Nɩ-iraa, ala ɩ fʊ bɔ̃ɔn yele jaa wiil sɩ a nɩrɛ 'lɔ na ŋme fʊ?” ");
INSERT INTO biv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita jãnɛ naa a yõo a bɛchaar pɔ. Ka a gbãgbapɔɔbile ãsʊɔ wa a wʊ sɛ̃ wa 'yɛr, “Fʊ mɩ dɔ̃ɔ turo a Yesu na yi a Galilee.” ");
INSERT INTO biv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tɩchɛ ka wʊ chiir a ba jaa niem tɩ 'yɛr, “N ba bɔ̃ɔ a 'yɛr 'lɔ par fʊn 'yɛrɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wʊn wa tɩ ara a dɔ̃dɔr nɛɛ, a pɔɔbile ãsʊɔ nyɛ wʊ naa na wʊ 'yɛr kʊ a nɩbɛ na ara a be, “A daba nyã mɩ dɔ̃ɔ turo a Yesu na yi a Najaretɩ.” ");
INSERT INTO biv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Be lɛ a Pita lɛ chiir pɔ tɩ 'yɛr ɩka, “N ba bɔ̃ɔ a daba nyãna ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A ba kor ɛ, ka a bala na ara gbʊr a Pita mɩ 'yɛr, “Sɩrɛ jaa lɛ, fʊ ɩ naa a ba ãsʊɔ. A fʊ kɔkɔr yin fʊn chãa pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Be lɛ ka a Pita pɔrɔ 'yɔ̃ɔnɔ̃ a wʊ mãɛ tɩ mɩ pɔrɔ kʊrɔ ba 'yɛrɛ ɩka, “N ba bɔ̃ɔ a daba nyãna ɛ.” Ka a nɔraa mɩ tɔ̃ɔ kõ. ");
INSERT INTO biv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Be lɛ ka Pita tɩɛr tɔ a lɛ a Yesu na dɔ̃ɔ 'yɛr, “Fʊn chiir ma naa gbɛɛ ata tɩchɛ ka a nɔraa kõ.” Ka a Pita ir yi a yõo tɩ kõ nɩbaal kõn. ");
INSERT INTO biv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","A wɛr na wa chaar bibio, a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a nɩbɛrɛ ba jaa lɔ̃ɔ taa guor lɛ ban na ɩ kʊ a Yesu. ");
INSERT INTO biv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba lũ wʊn tara chiin a paal Nãkpɛ̃ɛ Pilate sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas na gar 'yɔ̃ɔ wʊ na wa nyɛ ɩka ba tɔɔr a Yesu 'yɛr guor a wʊ kʊfʊ, wʊ pʊɔ sɔ̃ɔ naa ka wʊ lɛ lɩɛb a libibie lɩjɛr nɩ pie na wʊ tɩ kʊ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a nɩbɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tɩ na wʊ 'yɛr, “N maal yelbier nɩ ɩn gar 'yɔ̃ɔ nɩrɛ na ba maal yelbier jaa ɛ.” Tɩchɛ ka ba 'yɛr, “Sɩ baka ba lɛ ɛ? Fʊ 'yɛr a ɩ.” ");
INSERT INTO biv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wʊ den a libie lɔb bar a Nãaŋmɩn puorfʊ yir pɔ, tɩ na wʊ yi tɩ yɔɔl miir. ");
INSERT INTO biv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ka a Juu nɩbɛ bɔɔrlo nɩbɛrɛ wob a libie na ba 'yɛr ɩka a ba sɛɛ ɩka sɩ de yaa 'yɔ̃ɔ a Nãaŋmɩn puorfʊ yir libie pɔ ɛ, bojũu a ɩn jãɩ libie. ");
INSERT INTO biv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ban wa guor taa baar, ba den a libie dãn a lamɩɛr wɛr a jie ban ma ũno sãanba. ");
INSERT INTO biv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Lɛ lɛ so ka nɩbɛ bʊɔlɔ a jie nyã, “Jãɩ Wɛr,” wa tãn dɩna. ");
INSERT INTO biv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","A ɩn yelmãɛ nɩ a lɛ a Nãaŋmɩn 'yɛ'yɛrɛ Jeremiya na dɔ̃ɔ 'yɛr, “Ba den a libibie lɩjɛr nɩ pie a lɛ a Isɩral nɩbɛ na sɔɔ de, ");
INSERT INTO biv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na ba dãn a lamɩɛr wɛr nɩtãa lɛ a sɩ Soro na 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu na wa ara a Nãkpɛ̃ɛ Pilate niem, wʊ sʊʊr wʊ naa, “Fʊ̃ʊ lɛ ɩ a Juu nɩbɛ nãa ɔ?” Ka a Yesu 'yɛr “Ɔ̃ɔ, a lɛ nɛ fʊn 'yɛr lɛ.” ");
INSERT INTO biv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","A bɔɔrlo nɩbɛrɛ nɩ a nɩbɛrɛ na sɔ̃ɔnɔ̃ a wʊ yuor, waa 'yɛr 'yɛr jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Be lɛ a Pilate sʊʊr wʊ, faa 'yɛrɛ 'yɛr jaa wɛ? Nyɛ lɛ ban sɔ̃ɔnɔ̃ a fʊ yuor jã? ");
INSERT INTO biv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tɩchɛ a Yesu ba haa nɛɛ sɔɔ wʊ nɩ a ala a jaa ban 'yɛrɛ dɔɔlɔ wʊ ɛ, ka a 'maa a Pilate nɛɛ. ");
INSERT INTO biv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","A lɔ̃ɔ difʊ sɔ̃ɔ wa ta, ba ma 'yɛr ɩka a Nãkpɛ̃ɛ Pilate wʊ ir nɩrɛ 'lɔ a nɩbɛ na bʊɔrɔ a pɔɔ fʊ die pɔ bar. ");
INSERT INTO biv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A sɔ̃ɔ 'lɔ̃nɔ̃, ba pɔɔn daputuo sʊɔ kɔ̃ɔ nɩrɛ jaa na bɔ̃ɔ ka wʊ di Barabasɩ. ");
INSERT INTO biv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","A lɛ a nɩyɔɔ na wa lɔ̃ɔ taa, Pilate sʊʊr ba naa, “An lɛ yɩ bʊɔrɔ ɩka n yuo kʊ yɩ, Barabasɩ bɩɩ Yesu, a 'lɔ ban bʊɔlɔ a Nɩ-iraa?” ");
INSERT INTO biv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bojũu wʊ bɔ̃ɔn naa ɩka a nyuur ban tara nɩ a Yesu lɛ so ban nyɔɔ wʊ waan a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","A Pilate na wa jãnɛ a 'yɛr tɔɔrfʊ dakɔɔ ju, a wʊ pɔɔ tʊ̃n 'yɛr wʊ, “Taa ɩrɛ wa ɩrɛ a daba 'lɔ̃nɔ̃ na ba maal bon jaa yele jaa ɛ, bojũu jãa, n din dɔɔyɛ jãn pɔ nɩ a wʊ yele.” ");
INSERT INTO biv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tɩchɛ a bɔɔrlo nɩbɛrɛ nɩ a nɩbɛrɛ 'yɛr kʊ a nɩyɔɔ ɩka ba sʊɔr ka wʊ yuo Barabasɩ bar, tɩ kʊ a Yesu. ");
INSERT INTO biv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ka a Nãa Pilate lɛ bɔ̃ɔ sʊʊr ba go, “A nɩbɛ banyã ayi, buor lɛ yɩ bʊɔrɔ ɩka n yuo kʊ yɩ?” Ka ba 'yɛr, “Barabasɩ.” ");
INSERT INTO biv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ka a Nãa Pilate sʊʊr ba, “Tɩ n ɩ ŋmɩnɛ nɩ a 'lɔ yɩn bʊɔlɔ a Nɩ-iraa?” Ka ba jaa 'yɛr, “Kpa wʊ a daa ju.” ");
INSERT INTO biv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ka wʊ sʊʊr ba, “Bo yelbier lɛ wʊ ɩ? Bo dɛɛr lɛ wʊ maal?” Tɩchɛ ka ba tãna kpɛ̃ɔ jaa 'yɛrɛ, “Kpa wʊ a daa ju.” ");
INSERT INTO biv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","A Pilate na wa nyɛ bɔ̃ɔn ɩka wʊ kʊ̃ tʊ̃ɔ yele jaa ɩ ɛ, tɩchɛ ka a nɩbɛ wɩlɛwɩlɛ jaa tɩ gar, ka wʊ de kʊ̃ɔ pɛɛn a wʊ nuur a nɩyɔɔ niem, tɩ na wʊ 'yɛr, “Maa ba pʊɔ a daba nyã kũu pɔ ɛ. Yɩn sɛ̃ lɛ a be.” ");
INSERT INTO biv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Be lɛ ka a nɩbɛ ba jaa 'mataa 'yɛr, “Vɛ̃ ka a wʊ jãɩ dɔɔl a sɩn nɩ a sɩ bibiir ju.” ");
INSERT INTO biv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Be lɛ wʊ yuo a Barabasɩ kʊ ba. Wʊ vɛ̃ naa ka ba fɔb a Yesu tɩ wʊ de wʊ kʊ a sojasɩ ka ban tɩ kpa a daa ju. ");
INSERT INTO biv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Be lɛ ka a sojasɩ tara a Yesu tɩ kpɛ̃n a nãa yir kpɛ̃ɛ 'lɔ pɔ, tɩ bʊɔl a ba taaba sojasɩ lɔ̃ɔ taa. ");
INSERT INTO biv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ba yaar a wʊ bonsɩ bar tɩ de fuu jɩɛ su wʊ, ");
INSERT INTO biv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","na ba lɛ de gʊʊr wob nãa jupil kaar su wʊ. Ba den dãgbal 'yɔ̃ɔ wʊ a nũsʊ̃ɔ pɔ, na ba gbur dumo a wʊ niem laara wʊ, “Yãan yooo, Juu nɩbɛ nãa!” ");
INSERT INTO biv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba ma chɩr nataar 'yɔ̃ɔ wʊ tɩ de daa ŋmen wʊ a ju pɔ. ");
INSERT INTO biv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ban wa la wʊ a nɩtɔ̃ wa baar, ba yãan a fuu jie 'lɔ bar tɩ de a wʊ mãɛ fuu su wʊ, na ba pãa de wʊ chiin ɩka ba tɩ kpa a daa ju. ");
INSERT INTO biv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ban wa yi a sɔr pɔ, ba nyɛn daba na yi Sirenɩ ka a wʊ yuor di Simon, ka ba nyɔɔ wʊ fɩr wʊ ka wʊ tuo a Yesu daa. ");
INSERT INTO biv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ba tɩ tãn jie ban bʊɔlɔ Gɔlgɔta, a par lɛ ɩka, Julaa Jie. ");
INSERT INTO biv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ba den tãɩtuo 'yɔ̃ɔ dãa pɔ ɩka a Yesu wʊ nyũ, tɩ wʊn wa lɛm kaa, wʊ tɔr bar. ");
INSERT INTO biv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ban wa kpa wʊ a daa ju baar, ba põ naa a wʊ fɔɔr ŋmen gbãm bɔ̃ɔn ala ãsʊɔ jaa nɩ na di, ");
INSERT INTO biv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","tɩ na ba jãnɛ a jie pire wʊ. ");
INSERT INTO biv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ba sɛb a yele 'lɔ jũu ban kʊn wʊ mar a daa ju ɩka, NYƐ A YESU, A JUU NƖBƐ NÃA. ");
INSERT INTO biv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ba mɩ kpan nɩfarba ayi a dabãbãnsɩ mɩ ju, ka ãsʊɔ be a Yesu nũsʊ̃ɔ jie ka ãsʊɔ mɩ be a wʊ gubaa jie. ");
INSERT INTO biv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A bala na tala a be tʊrɔ wʊ, na ba vavire jur ");
INSERT INTO biv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","'yɛrɛ, “A fʊ̃ʊ na 'yɛr ɩka fʊn ŋmɛr a Nãaŋmɩn puorfʊ yir tɩ de ber ata mɛn, faa a fʊ mãɛ. Ala ɩ fʊ ɩ naa a Nãaŋmɩn Bie, wa suu a daa ju.” ");
INSERT INTO biv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Lɛ nɩ wʊ ju mɩ lɛ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a nɛɛ wiwiilbe nɩ a nɩbɛrɛ mɩ laara wʊ, ");
INSERT INTO biv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","na ba 'yɛrɛ, “Wʊ faan nɩbɛ bamɩne, tɩ wʊ kʊ̃ tʊ̃ɔ faa a wʊ mãɛ ɛ. 'Lɔ lɛ ɩ a Isɩral Nãa, wʊ wa suu a daa ju a pʊ̃pãanyãna, ka sɩ sɔɔ de wʊ. ");
INSERT INTO biv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Wʊ sɔɔn Nãaŋmɩn. Vɛ̃ ka Nãaŋmɩn faa wʊ a pʊ̃pãanyãna, bojũu wʊ 'yɛr naa ɩka wʊ ɩn Nãaŋmɩn Bie.” ");
INSERT INTO biv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Lɛ nɩ wʊ ju mɩ lɛ a nɩfarba ayi bala mɩ ban kpa gbʊr wʊ, mɩ tʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","A mɔ̃tɔ̃ɔ na wa ara gar ju sãlsɔɔ, a wɛr wʊ jaa sɔb naa tɩ tãn a mɔ̃tɔ̃ɔ balfʊ sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A sɔ̃ɔ 'lɔ̃nɔ̃ a Yesu chɩɩr kpɛ̃ɔ jaa na wʊ 'yɛr, “Ɛloɩ, Ɛloɩ, lama sabakatanɩ.” A par lɛ ɩka “N Nãaŋmɩn, n Nãaŋmɩn, bo lɛ so fʊn lɩɛb puor 'yɔ̃ɔ ma?” ");
INSERT INTO biv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","A nɩbɛ bala na ara gbʊr wʊ, na wa wõ a lɛ wʊn 'yɛr, ka ba 'yɛr ɩka, “Elaija lɛ wʊ bʊɔlɔ.” ");
INSERT INTO biv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ajienaa ka a daba ãsʊɔ jo chen tɩ 'mɔɔ sapɔ 'lɔr a dãmiir amɩne pɔ, na wʊ char daa pɔ, de kʊ a Yesu ɩka wʊ mʊʊr. ");
INSERT INTO biv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tɩchɛ ka bamɩne 'yɛr, “Yɩ bar a sɩ kaara, Elaija na wa yɔɔ wʊ naa bɩɩ.” ");
INSERT INTO biv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Be lɛ a Yesu chɩɩr kpɛ̃ɔ jaa tɩ ŋmaa a vʊʊr. ");
INSERT INTO biv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ka a Nãaŋmɩn puorfʊ yir pɔ, ban lũ fɔbaa chɩɛr a saaju tɩ gbem a par. Ka a tẽe dãm, ka a kʊsɩbɛ mɩ ŋmɛr ŋmɛr. ");
INSERT INTO biv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","A yar mɩ yuo yuor, ka a Nãaŋmɩn nɩbɛ bamɩne na dɔ̃ɔ kpi, jɛɔ. ");
INSERT INTO biv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ban wa yi a ba yar pɔ a lɛ, ka a Yesu na wa ir a kũu pɔ baar, ka ba pãa kpɛ a tẽchɛchɛ pɔ, ka nɩyɔɔ jaa tɩ nyɛ ba. ");
INSERT INTO biv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","A sojasɩ nɩkpɛ̃ɛ nɩ a bala wʊn ara nɩ na ba pire a Yesu, nyɛn a wɛr na dãm nɩ a lɛ jaa na ɩ, ka dãbãɛ kpɛ ba, ka ba 'yɛr, “Yelmãɛ jaa lɛ, a daba nyã ɩn a Nãaŋmɩn Bie.” ");
INSERT INTO biv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pɔɔ yɔɔ mɩ dɔ̃ɔ be a be ara tɛɛr jaa kaara, bala lɛ dɔ̃ɔ tu wʊ yin a Galilee na ba sʊ̃nɔ̃ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","A pɔbɔ banyãna pɔ lɛ Mɛɛr na yi Magdala, nɩ Mɛɛr na ɩ Jemesɩ nɩ Josefʊ ma, nɩ a Jebedee bibiir ma. ");
INSERT INTO biv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","A jãanʊɔr na wa ta, a taraa sʊɔ kɔ̃ɔ na yɩ Arimatɩya ban bʊɔlɔ Josefʊ, wʊ mɩ dɔ̃ɔ ɩ a Yesu poturo. ");
INSERT INTO biv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wʊ chen a Pilate sɛ̃ tɩ sʊɔr a Yesu ãgãn. Ka a Pilate bar sɔr ka ba yɔɔ a Yesu kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","A Josefʊ yɔɔn a ãgãn pil fɔpɩla, ");
INSERT INTO biv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kul tɩ ũu a wʊ mãɛ yaa paalaa pɔ wʊn chɩ a kʊsɩr pɔ. Wʊ bil kʊsɩr wa pɔɔ a yaa nɛɛ tɩ na wʊ kul. ");
INSERT INTO biv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mɛɛr na yi Magdala nɩ a Mɛɛr ãsʊɔ ben be jãnɛ a yaa puor. ");
INSERT INTO biv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A Chɔɔrfʊ Bɩbir ka a wɛr na chaar ka a ɩ a Pɛ̃nfʊ Bɩbir lɛ, a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Faraseemɩne chen tɩ 'yɛr a Nãkpɛ̃ɛ Pilate, ");
INSERT INTO biv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Nɩkpɛ̃ɛ, sɩ lɛ tɩɛr a lɛ a jir ŋmara 'lɔ̃nɔ̃ na dɔ̃ɔ 'yɛr wʊn dɔ̃ɔ chɛnɛ, ‘Ɩka ber ata daar ɩn lɛ lɩɛb ir ɩ vʊr.’ ");
INSERT INTO biv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","A lɛ jũu vɛ̃ ka ba gu a yaa tɩ tãn a ber ata daar, ka ala ba ɩ lɛ ɛ, a wʊ poturbo na chen tɩ ju a ãgãn a yaa pɔ, tɩ 'yɛr kʊ a nɩbɛ ɩka, 'lɔ lɛ ir a kũu pɔ, ka a bɛlfʊ taa ɩ dɛɛr gar a lɛ wʊn dɔ̃ɔ 'yɛr ɛ.” ");
INSERT INTO biv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ka a Pilate 'yɛr, “Yɩ de gugurbo ka ba tɩ gu a yaa a lɛ yɩn bɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Be lɛ ba tara a gugurbo chiin ka ba tɩ bɛ a yaa bɔɔ pɔɔ, tɩ na ba 'yɔ̃ɔ a kʊsɩr jãnɛ, tɩ 'yɔ̃ɔ ka a gugurbo ara gu. ");
INSERT INTO biv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","A Pɛ̃nfʊ Bɩbir na wa baar, ka a na ɩ a Pɛ̃nfʊ divɩɛ bio daar a wɛr na wa chaara wa la la la, Mɛɛr na yi a Magdala nɩ a Mɛɛr ãsʊɔ yin chen ɩka ba tɩ kaa a yaa. ");
INSERT INTO biv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Be lɛ ka a tẽe dãm kpɛ̃ɔ jaa, ka a ɩ Nãaŋmɩn malaka lɛ yi a saaju suu wa bil a kʊsɩr bar a yaa nɛɛ tɩ do jãnɛ. ");
INSERT INTO biv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A wʊ nie nyɩlɛ saa nyɩɩrfʊ kaar, ka a wʊ bʊ̃sursɩ pɛl jaa pɩlpɩl. ");
INSERT INTO biv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dãbãɛ kpɛ̃n a bala na ara kaara, ka ba gĩem ara kũn kaar. ");
INSERT INTO biv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A malaka 'yɛr kʊ a pɔbɔ, “Yɩ ta joro dãbãɛ ɛ, n bɔ̃ɔn naa ɩka a Yesu 'lɔ ban kpa a daa ju lɛ yɩ bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Waa be ka ɛ. Wʊ ir naa ɩ vʊr nɩtãa a lɛ wʊn dɔ̃ɔ 'yɛr. Yɩ wa muul kaa a jie wʊn gã. ");
INSERT INTO biv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yɩ chen fɔɔ jaa na yɩ tɩ 'yɛr kʊ a wʊ poturbo, ‘Wʊ lɩɛb ir a kũu pɔ, na wʊ de yɩ nie chiine a Galilee. Be lɛ yɩn tɩ nyɛ wʊ.’ N pãa 'yɛr kʊ yɩ.” ");
INSERT INTO biv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","A pɔbɔ banyãna yin a yaa par nɩ dãbãɛ jo fɔɔ jaa nɩ pʊpɛl chen ɩka ba tɩ 'yɛr kʊ a wʊ poturbo. ");
INSERT INTO biv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Be lɛ ka ajienaa, ka a ɩ Yesu lɛ tuor puor ba, ka ba lo kpa a wʊ niem nyɔɔ a wʊ gbɛɛ puor wʊ. ");
INSERT INTO biv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Be lɛ a Yesu 'yɛr kʊ ba, yɩ ta joro dãbãɛ ɛ, “Yɩ tɩ 'yɛr kʊ a n yɛɛr ɩka ba chen a Galilee, be lɛ ban tɩ nyɛ ma.” ");
INSERT INTO biv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","A pɔbɔ na wa chiine, a sojasɩ bamɩne na dɔ̃ɔ guro a yaa kpɛ̃n a tẽkpɛ̃ɛ pɔ, tɩ 'yɛr kʊ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ a lɛ jaa na ɩ. ");
INSERT INTO biv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","A bɔɔrlo nãa nɩ a wʊ nɩbɛrɛ na wa lɔ̃ɔ taa, ba guor taa de libiyɔɔ kʊ a sojasɩ ");
INSERT INTO biv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tɩ na ba 'yɛr kʊ ba, “Yɩ 'yɛr ɩka, ‘A wʊ poturbo lɛ wa ju a wʊ ãgãn a sɔ̃ɔ 'lɔ sɩn chɛnɛ gã guro.’ ");
INSERT INTO biv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ala ɩ a 'yɛr nyã wa lon a Nãa Pilate toor pɔ, sɩn maal wʊ naa ka a wʊ pʊɔ pɛl a sɩ ir yɩ yin wõm pɔ.” ");
INSERT INTO biv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","A sojasɩ den a libie tɩ na ba ɩ a lɛ ban 'yɛr ɩka ba ɩ. A Juu nɩbɛ ma chɛnɛ na 'yɛr a yele nyãna a dɩna. ");
INSERT INTO biv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A poturbo pie nɩ bʊ̃'yen chen a Galilee a tɔ̃ɔ 'lɔ ju a Yesu na wiil ba ɩka ba do. ");
INSERT INTO biv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ban wa nyɛ wʊ, ba gbur dumo na ba puor wʊ tɩchɛ ka bamɩne chɛnɛ baala. ");
INSERT INTO biv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ka a Yesu wa 'yɛr kʊ ba, “A n Sãa den a kpãɛn ala a jaa na be a saaju, nɩ a kpãɛn ala a jaa na be a wɛr pɔ kʊ ma. ");
INSERT INTO biv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","A lɛ jũu, yɩ yɔ a wɛr wʊ jaa na yɩ tɩ 'yɔ̃ɔ paalsɩ ka ba wa turo ma, na yɩ suoro ba a Nãaŋmɩn kʊ̃ɔ, a Sãa yuor, nɩ a Bie yuor, nɩ a Nãaŋmɩn Sɩɛ yuor 'yɔ̃ɔ, ");
INSERT INTO biv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","tɩ na yɩ wile ba ka ba sɔɔ de, tɩ turo bon jaa ɩn 'yɛr kʊ yɩ. Yɩ bɔ̃ɔn ɩka ɩn ma ben a yɩ sɛ̃ sɔ̃ɔ jaa, tɩ tãn a wɛr baarfʊ daar.”");
INSERT INTO biv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Kɩrɩsɩto na ɩ a Nãaŋmɩn Bie 'yɛr nʊ̃ɔ pielfʊ. ");
INSERT INTO biv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","'Yɛ'yɛrɛ kɔ̃ɔ yuor na di Isaiya sɛb naa, “Nyɛ, ɩn tʊ̃ naa a n tʊ̃tʊ̃nɔ̃ ka wʊ de nie tɩ chɔɔr a sɔr kʊ fʊ.” ");
INSERT INTO biv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Kɔkɔr tãna naa a dãlpʊɔ ju, ‘Chɔɔr a sɔr kʊ a sɩ Soro na fʊ maal a wʊ sɔr ka wʊ tor.’ ” ");
INSERT INTO biv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Lɛ lɛ a Jɔɔn wa, na wʊ wa suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ be a dãlpʊɔ ju, na wʊ mʊɔl 'yɛr, “Yɩ lɩɛb yi a yɩ tɩɛr dɛɛr pɔ so a Nãaŋmɩn kʊ̃ɔ, ka wʊ vɛ̃ a yelbebe kʊ yɩ.” ");
INSERT INTO biv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ka a nɩbɛ yire a tẽn ala a jaa na be a Judiya wɛr pɔ, ka a bamɩne mɩ yire a Jerusalɛm. Ba chire naa a ba pʊʊr 'yɛrɛ a ba yelbebe kʊrɔ wʊ tɩchɛ ka wʊ suoro ba jaa a Nãaŋmɩn kʊ̃ɔ a Jordan man pɔ. ");
INSERT INTO biv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nyɔɔma kɔɔlʊ fuu lɛ Jɔɔn ma su tɩ de gãn lũn a sɩɛ. Soor nɩ sɩkãa lɛ ɩ a wʊ bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wʊ 'yɛr naa, “N puor sʊɔ ben be, na wʊ gar ma. A wʊ nafɔɔr mibe gba n ba sɛɛ ɩka n guun for ɛ. ");
INSERT INTO biv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Maa suoro yɩ naa nɩ a Nãaŋmɩn kʊ̃ɔ tɩchɛ 'lɔ na so yɩ naa nɩ a Nãaŋmɩn Sɩɛ.” ");
INSERT INTO biv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A sɔ̃ɔ 'lɔ Yesu yi naa Najaretɩ na be a Galilee wɛr pɔ wa, ka a Jɔɔn so wʊ a Nãaŋmɩn kʊ̃ɔ a Jordan man pɔ. ");
INSERT INTO biv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","A Yesu na wa yire a kʊ̃ɔ pɔ, wʊ nyɛ naa a saaju na tɔɔ yuo ka a Nãaŋmɩn Sɩɛ wa suro fɩka papa wa kpɛ a Yesu pɔ. ");
INSERT INTO biv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tɩ a kɔkɔr yi a Nãaŋmɩn sɛ̃ 'yɛrɛ, “Fʊ̃ʊ lɛ ɩ a n binʊ̃nãa, ka a n 'yɔ̃ɔ ma 'maa nɩ fʊ.” ");
INSERT INTO biv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ka a Nãaŋmɩn Sɩɛ de wʊ fɔɔ jaa chiin a dãlpʊɔ ju, ");
INSERT INTO biv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ka wʊ tɩ be be ber lɩjaayi ka a Satan bɛɛr wʊ kaa. 'Lɔ nɩ a mɔdʊ̃n lɛ dɔ̃ɔ be be, ka a malakasɩ wa sʊ̃nɔ̃ wʊ. ");
INSERT INTO biv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jɔɔn ban wa nyɔɔ pɔɔ baar, Yesu chen naa a Galilee na wʊ tɩ mʊɔlɔ 'yɛrɛ a Nãaŋmɩn 'yɛr nʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wʊ 'yɛr naa, “A sɔ̃ɔ ta naa ka a Nãaŋmɩn di a wʊ nãalʊ̃ʊ. Yɩ lɩɛb yi a tɩɛr dɛɛr pɔ na yɩ sɔɔ de a 'yɛr nʊ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A lɛ a Yesu na wa de a Galilee man lana, wʊ nyɛ naa Simon nɩ a wʊ yɛbile Andiru ka ba lɔɔrɔ lɔyaar, jãnyɔɔrbɔ lɛ ba ɩ, ");
INSERT INTO biv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ka wʊ bʊɔl ba, “Yɩ wa turo ma, ka n lɩɛb yɩ ka yɩ nyɔɔrɔ nɩbɛ 'yɔ̃ɔnɔ̃ Nãaŋmɩn nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ka ba tɔ̃ɔ tɩɛ a jãmɛ nyɔɔrfʊ bar tɩ turo wʊ. ");
INSERT INTO biv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wʊn wa chen a niem bãlãa, wʊ nyɛ naa Jemesɩ nɩ Jɔɔn, Jebedee bibiir, a ba be a gboro pɔ chɔɔrɔ a lɔyaarsɩ. ");
INSERT INTO biv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Wʊn wa nyɛ ba, wʊ bʊɔl ba naa, ka ba bar a ba sãa nɩ a gboro nɩ a bala ban yara tɩ turo a Yesu. ");
INSERT INTO biv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Be lɛ ba wa chen a Kapenahum ka a Pɛ̃nfʊ Bɩbir wa ta, ka a Yesu chen tɩ kpɛ a lɔ̃ɔfʊ jie tɩ piel wile. ");
INSERT INTO biv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A nɩbɛ nɛɛr 'maa naa nɩ a wʊ wiilfʊ, bojũu wʊ wile ba naa nɩ Nãaŋmɩn sɔr. Waa ɩ fɩka a Mosesɩ Nɛɛ wiwiilbe ɛ. ");
INSERT INTO biv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","A sɩdɛɛr sʊɔ kɔ̃ɔ mɩ chen tɩ kpɛ a ba lɔ̃ɔfʊ jie tãna 'yɛrɛ nɩ, ");
INSERT INTO biv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Bãa lɛ a fʊ̃ʊ Yesu na yi a Najaretɩ bʊɔrɔ a sɩ sɛ̃? Fʊ wa naa ɩka fʊ wa sɔ̃ɔ sɩ bar bɩɩ? N bɔ̃ɔ naa a nɩrɛ 'lɔ fʊn ɩ, fʊ ɩ naa a chɛchɛ 'lɔ na yi a Nãaŋmɩn sɛ̃!” ");
INSERT INTO biv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ka a Yesu tãn wʊ, “Pɔɔ a fʊ nɛɛ tɩ wa yi a daba pɔ!” ");
INSERT INTO biv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ka a sɩdɛɛr daa a daba lɔb tẽe nɩtãa kpũgul loro tɩ ŋme chɛlma tɩ wa yi a daba pɔ. ");
INSERT INTO biv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ka a nɛɛr 'maa a nɩbɛ ka ba lɩɛb sʊrɔ taa, “Bo lɛ? Wiil paal bo mɩ nɩ nyã, na tara kpɛ̃ɔ lɛ! Wʊ ma 'yɛr 'yɛr, ka a sɩdɛbɛ ma tu a wʊ nɛɛ.” ");
INSERT INTO biv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ka a wʊ yele yaar a Galilee wɛr wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ban wa yi a lɔ̃ɔfʊ jie, 'lɔ nɩ Jemesɩ nɩ Jɔɔn chen naa a Simon nɩ Andiru yir, ");
INSERT INTO biv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ka a ãgãn tɔ a Simon dãɛ pɔɔ ka ba 'yɛr kʊ a Yesu. ");
INSERT INTO biv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu kpɛ naa a wʊ sɛ̃ tɩ nyɔɔ a wʊ nũu sʊ̃ʊ wʊ ka wʊ ir. A ãgãn tʊl baar wʊ, ka wʊ ir maal bʊ̃diir kʊ ba. ");
INSERT INTO biv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","A jãanʊɔr 'lɔ̃nɔ̃ a mɔ̃tɔ̃ɔ na wa mʊr, a nɩbɛ waan na baalsɩ nɩ a bala a sɩdɛbɛ na tara a Yesu sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ka a tẽe nɩbɛ ba jaa wa lɔ̃ɔ a dɔ̃dɔ̃rʊ, ");
INSERT INTO biv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ka a Yesu sãa nɩyɔɔ na tara baal jaa bʊrɔ. Wʊ mɩ dii naa a sɩdɛbɛ yɔɔ ka a yi, tɩ maa sɔɔ ka a sɩdɛbɛ 'yɛr 'yɛr ɛ, bojũu ba bɔ̃ɔ naa a nɩrɛ 'lɔ wʊn ɩ. ");
INSERT INTO biv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","A wɛr na chaara a bibio pipi tɩ chɛnɛ sɔb, Yesu ir na wʊ yi a yir na wʊ chen a jie ãsʊɔ ɩka wʊ tɩ sʊɔr Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon nɩ a wʊ taaba mɩ yin bʊɔrɔ wʊ na ba wa nyɛ wʊ, ");
INSERT INTO biv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","na ba 'yɛr, “Nɩbɛ ba jaa yʊɔrɔ na bʊɔrɔ fʊ!” ");
INSERT INTO biv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ka a Yesu 'yɛr, “Yɩ ɩ ka sɩ chen jiyuo, a tẽn anyã na gbʊr, ka n tɩ mʊɔl 'yɛr a Nãaŋmɩn 'yɛr a be, ala 'yɔ̃ɔ lɛ n wa.” ");
INSERT INTO biv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wʊ yɔ naa a Galilee wɛr wʊ jaa na wʊ 'yɛrɛ a Nãaŋmɩn 'yɛr a ba lɔ̃ɔfʊ yie pɔ tɩ na wʊ dire a sɩdɛbɛ mɩ ka a yire. ");
INSERT INTO biv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ka a daba ãsʊɔ mɩ na ɩ kɔ̃kɔ̃mɔ̃ wa gbur dumo sʊɔr wʊ, “Fʊ̃ʊ sɔɔ, sãa ma.” ");
INSERT INTO biv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ka nɩbaal kpɛ a Yesu ka wʊ tur a wʊ nũu sɩɩr a daba tɩ 'yɛr, “N sɔɔ naa. Sa!” ");
INSERT INTO biv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ajienaa ka a kɔ̃kɔ̃mɔ̃ sa. ");
INSERT INTO biv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu kpãa wʊ naa kpãkpãan wʊ ɩka, ");
INSERT INTO biv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Taa ɩrɛ wa 'yɛrɛ kʊrɔ nɩrɛ ɛ. Chen tɩ wiil a fʊ mãɛ kʊ a Juu nɩbɛ bɔɔrloro tɩ ir a nɛɛ 'lɔ a Mosesɩ na 'yɛr ka a ɩ dãasɩɛ.” ");
INSERT INTO biv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tɩchɛ a daba na wa yi wʊ piel naa na wʊ ŋme a Yesu yele yaar, ka a lɛ jũu Yesu ba lɛ tʊ̃ɔ yʊɔrɔ chãa pɔ a tẽe pɔ ɛ. Wʊ ma be naa a tẽe kõkoor, a nɩbɛ chɛnɛ yire jiir jaa waara a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","A anyã puor, Yesu lɩɛb wa a Kapenahum, ka nɩbɛ wõ ka wʊ be naa a yir. ");
INSERT INTO biv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nɩyɔɔ wan wa duo na ba sɛɛ a die wa tɩ yin a yõo. Ka wa 'yɛrɛ a Nãaŋmɩn 'yɛr kʊrɔ ba. ");
INSERT INTO biv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Be lɛ ka daba ãsʊɔ mɩ bɩɛrɛ, a wʊ nuur nɩ a wʊ gbɛɛ kpi naa, ka nɩbɛ anaar jɛ̃jɛl wʊ na ba waan a Yesu sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ka ba wa ta, ka jie ba be be a ba na tu kpɛ̃n a be a Yesu na be ɛ, a nɩyɔɔ jũu. Be lɛ ba do a gar ju na ba tɩ ŋmaa puo a jie 'lɔ a Yesu na ara, tɩ na ba de a daba nɩ a fɔbaa 'lɔ ban 'mɔɔn wʊ waan tur bar ka wʊ suu tɩ gã a Yesu niem. ");
INSERT INTO biv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Be lɛ a Yesu na wa nyɛ a lɛ ban sɔɔ de wʊ, wʊ 'yɛr kʊ a dabaala, “N bie, n vɛ̃ naa fʊ yelbebe bar.” ");
INSERT INTO biv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ka be lɛ ka a Mosesɩ Nɛɛ wiwiilbe bamɩne na be be tɩɛrɛ, ");
INSERT INTO biv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ka nyɛ daba na ara fere na wʊ sɔ̃ɔnɔ̃ Nãaŋmɩn yuor tɛɛ. An lɛ na tʊ̃ɔ nɩrɛ yelbebe vɛ̃ bar, ka Nãaŋmɩn tɛɛ ba lɛ ɛ?” ");
INSERT INTO biv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ajienaa Yesu bɔ̃ɔn naa a lɛ ban tɩɛrɛ a ba pʊʊr pɔ, ka wʊ 'yɛr kʊ ba, “Bãa lɛ yɩ tɩɛrɛ a lɛ a yɩ pʊʊr pɔ? ");
INSERT INTO biv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Buor sʊɔ lɛ ɩ kɔ̃mɔ̃kɔ̃mɔ̃, n 'yɛr ɩka n vɛ̃ naa wʊ yelbebe bar, bɩɩ, n 'yɛr ɩka a daba nyã wʊ ir, 'mɔɔ a wʊ bʊ̃gãnaa, na wʊ kulo nɩ? ");
INSERT INTO biv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","N bʊɔrɔ naa ɩka yɩ bɔ̃ɔ ɩka a Nɩsaal Bie tara naa kpɛ̃ɔ a wɛr pɔ na vɛ̃ nɩrɛ yelbebe kʊ wʊ.” Be lɛ wʊ 'yɛr kʊ a daba 'lɔ nuur nɩ a gbɛɛ na kpi, ");
INSERT INTO biv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Fʊ̃ʊ lɛ n 'yɛrɛ, ir, na fʊ 'mɔɔ a bʊ̃gãnaa, na fʊ kulo nɩ.” ");
INSERT INTO biv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Be lɛ, ka wʊ vaa ir 'mɔɔ a bʊ̃gãnaa yin a nɩbɛ ba jaa niem. Nɛɛr 'maa ba naa ka ba dãna Nãaŋmɩn 'yɛrɛ, “Saa dɔ̃ɔ nyɛ a lɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu lɩɛb chen a man nɛɛ ka nɩyɔɔ wa a wʊ sɛ̃ ka wʊ wile ba. ");
INSERT INTO biv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A Yesu na wa chiine wʊ nyɛ naa a Alfayasɩ bie, Levi, ka wʊ jãnɛ a lõpo defʊ jie, ka Yesu 'yɛr kʊ wʊ, “Ir turo ma,” ka wʊ ir turo wʊ. ");
INSERT INTO biv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","A lõpodierbe nɩ a yelbetʊ̃nbɔ yɔɔ turo naa a Yesu, ka 'lɔ nɩ a bamɩne nɩ a wʊ poturbo 'mataa dire a Levi yir. ");
INSERT INTO biv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","A Mosesɩ Nɛɛ wiwiilbe na ɩ a Faraseemɩne nyɛ a lɛ wʊn jãnɛ nɩ a lõpodierbe nɩ a yelbetʊ̃nbɔ 'mataa dire, ka ba sʊʊr a wʊ poturbo, “Bãa lɛ so a daba nyã na 'mataa dire nɩ a lõpodierbe nɩ a yelbetʊ̃nbɔ?” ");
INSERT INTO biv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu wõ naa a lɛ ban 'yɛr, ka wʊ 'yɛr kʊ ba, “Nɩrɛ na kpɛ̃mɛ waa chiine tɩtɩlɛ jie ɛ. Baalaa lɛ ma chen. N ba wa ɩka n wa bʊɔl a nɩtorsɩ ɛ. N wa naa ɩka n wa bʊɔl a yelbebe tʊ̃nbɔ ka ba wa lɩɛb a tɩɛr.” ");
INSERT INTO biv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jɔɔn poturbo nɩ a Faraseemɩne nɩbɛ gal kɔ̃, ka nɩbɛ wa sʊʊr a Yesu, “Ŋmɩnɛ lɛ a Jɔɔn poturbo nɩ a Farasee poturbo ma gal kɔ̃, tɩchɛ ka a fʊ̃ʊ poturbo maa gal kɔ̃ ɛ?” ");
INSERT INTO biv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A Yesu 'yɛr kʊ ba, “Ŋmɩnɛ lɛ an ɩ ka nɩbɛ be a pɔɔ paalaa sɩrɛ jie tɩ tʊ̃ɔ kɔ̃ gal? Wʊn chɛnɛ be a ba sɛ̃, ba kʊ̃ tʊ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","A daar 'lɔ ban wa de a pɔɔ paalaa sɩrɛ, ban gal a kɔ̃. ");
INSERT INTO biv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Nɩrɛ maa ŋmaa fɔpaalaa sɛ 'yɔ̃ɔ fɔkoraa pɔ ɛ. 'Lɔ be sɛ 'yɔ̃ɔ a lɛ, a fɔpaalaa na tɔɔ naa a fɔkoraa chɩɛr. ");
INSERT INTO biv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nɩrɛ maa de dãbãɩn 'yɔ̃ɔ wɔkoraa pɔ ɛ. 'Lɔ 'yɔ̃ɔ, a wʊɔ na pur naa, ka a dãa nɩ a wʊɔ sɔ̃ɔ. Wʊ ma 'yɔ̃ɔ naa dãbãɩn wɔpaalaa pɔ.” ");
INSERT INTO biv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","A Pɛ̃nfʊ Bɩbir Daar, Yesu nɩ a wʊ poturbo kpɛ̃n tala puo sãlsɔɔ, ka a wʊ poturbo piel fɔrɔ a bʊ̃bie. ");
INSERT INTO biv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ka a Faraseemɩne 'yɛr kʊ a Yesu, “Nyɛ lɛ a fʊ poturbo na ɩrɛ. Bo lɛ so ka ba tʊ̃nɔ̃ a Pɛ̃nfʊ Bɩbir? A ba tara sɔr ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ka a Yesu 'yɛr kʊ ba, “Yaa bɔ̃ɔ a par a lɛ yɩn kar kaa a Nãaŋmɩn gãn pɔ a nãa David nɩ a wʊ nɩbɛ na ba dɔ̃ɔ tara bon na di ɛ! ");
INSERT INTO biv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A ber ala pɔ Abiyata lɛ ɩ a Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ, kɔ̃ dɔ̃ɔ kpɛ ba, ka wʊ kpɛ a Nãaŋmɩn yir, ka a Abiyata de a paanʊ̃ɔ ala ban bin kʊ Nãaŋmɩn kʊ wʊ, ka wʊ 'wɔb. A paanʊ̃ɔ ala a Juu nɩbɛ bɔɔrlorbo tɛɛ lɛ ma 'wɔb, a ba tara sɔr ɩka nɩyuo wʊ 'wɔb ɛ, tɩchɛ ka David 'wɔb tɩ de kʊ a bala na be a wʊ sɛ̃, ka ba mɩ 'wɔb.” ");
INSERT INTO biv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Be lɛ ka a Yesu 'yɛr kʊ ba, “A Pɛ̃nfʊ Bɩbir ben be a nɩbɛ 'yɔ̃ɔ, a ba ɩ a nɩbɛ ben be a Pɛ̃nfʊ Bɩbir 'yɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ala lɛ so ka a Nɩsaal Bie ɩ a Soro lɔ̃ɔn a Pɛ̃nfʊ Bɩbir gba.” ");
INSERT INTO biv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sɔ̃ɔ ãsʊɔ go Yesu chen tɩ kpɛ a lɔ̃ɔfʊ jie, ka a daba kɔ̃ɔ mɩ be be ka a wʊ nũpɛl kpi. ");
INSERT INTO biv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ka a nɩbɛ bamɩne na be be bʊɔrɔ ɩka ba gar a Yesu, be lɛ ba tɔɔ gbʊr kaara wʊ. Ka wʊn sãa naa a daba nũu baal a Pɛ̃nfʊ Bɩbir bɩɩ. ");
INSERT INTO biv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu 'yɛr kʊ a daba nũpɛl na kpi, “Ir ara a sɩ jaa nyɛ fʊ.” ");
INSERT INTO biv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Be lɛ ka a Yesu sʊʊr ba, “Tʊ̃buor sʊɔ lɛ tara sɔr a Pɛ̃nfʊ Bɩbir daar ɩka fʊ tʊ̃, a fʊ maal vɩla bɩɩ dɛɛr, fʊ faa nyɛvʊr bɩɩ fʊ kʊ wʊ?” Ka ba ɩ jaa gbulo gbulo. ");
INSERT INTO biv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Wʊ kaa naa ba jaa gʊɔr nɩ suur, ka a wʊ pʊɔ sɔ̃ɔ a ba bachɛlfʊ jũu. Wʊ 'yɛr kʊ a daba 'lɔ nũpɛl na kpi, “Tur a fʊ nũu.” Wʊ tur naa ka a nũpɛl wʊ jaa sa. ");
INSERT INTO biv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Be lɛ ka a Faraseemɩne yi chen a Hɛrɔd nɩbɛ sɛ̃, a ba tɩ 'mataa guoro a Yesu, bʊɔrɔ sɔr 'lɔ ban na tu kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu nɩ a wʊ poturbo yin chen a man pɔ ka a nɩyɔɔ na yi Galilee wɛr tu ba. ");
INSERT INTO biv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nɩyɔyɔɔ mɩ yi naa Judiya wɛr, Jerusalɛm, Idumea wɛr nɩ a Jordan man gɔ̃ɔn, nɩ a tẽn na be Tire nɩ Sidon wɛr pɔ, wa a wʊ sɛ̃ bojũu ba wõ naa a lɛ jaa wʊn tʊ̃. ");
INSERT INTO biv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A nɩyɔɔ jũu, Yesu 'yɛr kʊ a wʊ poturbo, “Yɩ kaa nyɛ gboro kʊ ma ka n sɛr bãlãa.” Wʊ 'yɛr naa a lɛ bojũu waa bʊɔrɔ ɩka a nɩbɛ ba mɩl pɔɔ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","A nɩbɛ yɔɔ wʊn sãa lɛ so, a baalsɩ dara taa bʊɔrɔ ɩka ba sɩɩr wʊ. ");
INSERT INTO biv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","A sɩdɛbɛ na ma wa nyɛ a Yesu ba ma da naa a nɩrɛ 'lɔ 'yɔ̃ɔ ban be lɔb tẽe tɩ tãna 'yɛrɛ nɩ, “Fʊ̃ʊ lɛ a Nãaŋmɩn Bie!” ");
INSERT INTO biv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tɩchɛ wʊ kpaal ban jũu, ka ba taa ɩrɛ wa 'yɛrɛ a nɩrɛ 'lɔ wʊn ɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu do naa a tɔ̃ɔ ju tɩ bʊɔl a bala wʊn bʊɔrɔ ka ba do wa a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A ba pɔ lɛ wʊ kaa ir pie nɩ ayi, bʊɔlɔ ba nɩtʊ̃nsɩ, ka ba na be a wʊ sɛ̃, ka wʊ ma tʊ̃ ba ka ba chen tɩ mʊɔl 'yɛr a Nãaŋmɩn 'yɛr, ");
INSERT INTO biv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","tɩ tara kpɛ̃ɔ dire nɩ sɩdɛbɛ ka a yire. ");
INSERT INTO biv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A nɩbɛ pie nɩ ayi bala wʊn ir yoe lɛ a anyã. Simon, wʊn lɛ kʊ wʊ yopaalaa Pita. ");
INSERT INTO biv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jemesɩ, nɩ a wʊ yɛbile Jɔɔn, a ba sãa yuor lɛ Jebedee, wʊ bʊɔlɔ ba naa Bɔɔnɛgasɩ, a par lɛ sa tãna bibiir. ");
INSERT INTO biv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andiru, Filip, Batolomi, Matiu, Tomasɩ, Jemesɩ na ɩ Alfayasɩ bidaba, Tadius, Simon na mʊ̃ɔ nɩbir nɩ a wʊ wɛr yele, ");
INSERT INTO biv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nɩ a Judas Isɩkariyot, 'lɔ lɛ na wa de a Yesu tɩr. ");
INSERT INTO biv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A Yesu na lɩɛb wa a yir, nɩyɔɔ wa naa wa lɔ̃ɔ go, ka 'lɔ nɩ a wʊ poturbo ba tara jaa gba na di ɛ. ");
INSERT INTO biv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Be lɛ a wʊ yir dẽme na wa wõ a lɛ, ba chen naa ɩka ba tɩ ka wʊ, bojũu ba 'yɛr naa ɩka, “Burbur kpɛ wʊ naa.” ");
INSERT INTO biv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ka a Mosesɩ Nɛɛr wiwiilbe bamɩne na yi a Jerusalɛm mɩ 'yɛrɛ, “A Beeljebul, lɛ pɔb wʊ! A sɩdɛbɛ nãa lɛ wʊ ma de dire nɩ a sɩdɛbɛ ka a yire.” ");
INSERT INTO biv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu bʊɔl naa a nɩbɛ na wʊ lɔb sʊkpar kʊ ba, “Ŋmɩnɛ lɛ a Satan na ɩ lɛ dii a Satan? ");
INSERT INTO biv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ala ɩ nãa ir jɛɛrɛ nɩ a wʊ mãɛ nãalʊ̃ʊ, ŋmɩnɛ lɛ wʊn ɩ ara? ");
INSERT INTO biv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yir nɩbɛ mɩ ir jɛɛrɛ taa, a yir 'lɔ nɩbɛ kʊ̃ tʊ̃ɔ 'mataa kpɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ala ɩ a Satan ir naa na wʊ jɛɛrɛ nɩ a wʊ mãɛ, wʊ mɩ kʊ̃ tʊ̃ɔ ara ɛ, a wʊ baaraa lɛ. ");
INSERT INTO biv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yelmãɛ, nɩrɛ jaa kʊ̃ tʊ̃ɔ kpɛ gãdaa yir tɩ ju a wʊ bonsɩ ka waa de nie lũ wʊ ɛ. 'Lɔ wa lũ wʊ a lɛ wa baar, wʊn pãa tʊ̃ɔ naa a wʊ yir bonsɩ ju. ");
INSERT INTO biv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Sɩrɛ lɛ n 'yɛrɛ kʊrɔ yɩ, yeldɛbɛ nɩ ferfʊ a jaa nɩbɛ na fere sɔ̃ɔnɔ̃ nɩ Nãaŋmɩn yuor ban nyɛn vɛ̃ kʊfʊ. ");
INSERT INTO biv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tɩchɛ nɩrɛ 'lɔ na fere nɩ a Nãaŋmɩn Sɩɛ kʊ̃ nyɛ vɛ̃ kʊfʊ ɛ, bojũu wʊ lo naa a yeldɛɛr 'lɔ pɔ, na ba tara baarfʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ban 'yɛr ɩka wʊ tara naa a sɩdɛɛr lɛ so ka wʊ 'yɛr a lɛ. ");
INSERT INTO biv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Be lɛ ka a Yesu ma nɩ a wʊ yɛɛr wa. Ba ara naa a yõo tɩ tʊ̃ nɩrɛ ka wʊ bʊɔl wʊ. ");
INSERT INTO biv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nɩyɔɔ jãnɛ naa jilʊ̃ a Yesu tɩ ba 'yɛr wʊ, “A fʊ ma nɩ a fʊ yɛɛr be naa a yõo bʊɔrɔ fʊ.” ");
INSERT INTO biv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ka wʊ sʊʊr ba, “An lɛ ɩ a n ma nɩ a n yɛɛr?” ");
INSERT INTO biv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Be lɛ wʊ kaa a bala na jãnɛ jilʊ̃ wʊ tɩ 'yɛr, “Banyã lɛ ɩ a n ma nɩ a n yɛɛr! ");
INSERT INTO biv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nɩrɛ 'lɔ jaa na turo a Nãaŋmɩn sɔr, 'lɔ lɛ a n yɛbɛ nɩ a n yɛpɔɔ nɩ a n ma.” ");
INSERT INTO biv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sɔ̃ɔ kɔ̃ɔ go, Yesu piel wile a man nɛɛ. A nɩyɔyɔɔ na wa lɔ̃ɔ jũu, wʊ kpɛ naa a gboro pɔ jãnɛ, tɩchɛ ka a nɩbɛ ara kɔɔ a kʊ̃ɔ nɛɛ. ");
INSERT INTO biv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sʊkpar lɛ wʊ lɔɔrɔ wile nɩ ba yelyɔɔ, sʊkpa ãsʊɔ nɩ nyã: ");
INSERT INTO biv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yɩ chɛlɛ! Kʊɔraa lɛ yi chen ɩka wʊ tɩ yaar a wʊ bʊ̃bʊrɔ. ");
INSERT INTO biv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wʊ yaar naa ka amɩne lo a sɔr pɔ ka a lubil wa tuur di. ");
INSERT INTO biv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ka amɩne mɩ lo a jie 'lɔ a kʊsɩbɛ na waa gar a tãna, na a bul fɔɔ, a tãna na ba tɩrɛ jũu. ");
INSERT INTO biv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tɩchɛ a mɔ̃tɔ̃ɔ na wa nyãa, a jʊɔl naa na a kpi, bojũu a ba tara nyɩbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Amɩne mɩ tɩ lo naa gʊʊr pɔ, tɩchɛ ka a gʊʊr bul fãɩn naa tara, a ba tʊ̃ɔ dɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ka amɩne mɩ tɩ lo a kɔjɔ̃ vɩla pɔ, na a dɔɔ yɔɔ. Ka amɩne dɔɔ a lɩjɛr nɩ pie, amɩne lɩjaata ka amɩne mɩ kɔbaa.” ");
INSERT INTO biv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ka wʊ 'yɛr kʊ ba, “Nɩrɛ jaa na tara toor, wʊ chɛlɛ!” ");
INSERT INTO biv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","A nɩyɔyɔɔ bala na wa chen tɩ chɛ a nɩbɛ bala na turo wʊ nɩ a wʊ poturbo pie nɩ a ayi bala wʊn ir, ka a ba sʊʊr wʊ a sʊkpar par. ");
INSERT INTO biv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Be lɛ ka wʊ 'yɛr kʊ ba, “Yɩn 'lɔ Nãaŋmɩn kʊ yɩ naa a Nãaŋmɩn nãalʊ̃ʊ yelsɔɔlaa, tɩchɛ a banyã 'lɔ na ba pʊɔ ɛ, a yelsɩ a jaa ɩ naa sʊkpar kʊ ba. ");
INSERT INTO biv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","A lɛ jũu, ‘Ba ma kãan lɛ̃ɛɛ tɩ ba maa nyɛ ɛ, na ba ma chɛl lɛ̃ɛɛ tɩ ba maa wõ ɛ. Ala ba ɩ lɛ ɛ ban lɩɛb a ba tɩɛr ka Nãaŋmɩn vɛ̃ kʊ ba.’ ” ");
INSERT INTO biv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ka Yesu sʊʊr ba, “Yaa bɔ̃ɔ a sʊkpa nyã par ɛ? Ŋmɩnɛ lɛ yɩn ɩ wa bɔ̃ɔ sʊkpa jaa par? ");
INSERT INTO biv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yɩ kaa, a kʊɔraa lɛ a nɩrɛ 'lɔ na yaara a Nãaŋmɩn 'yɛr. ");
INSERT INTO biv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nɩbɛ bamɩne kaara naa fɩka a bʊ̃bie ala ban yaar ka a lo a sɔr pɔ. Bala wa wõ a 'yɛr wa baar, a Satan ma wa naa, wa de a Nãaŋmɩn 'yɛrbir ban bʊr a ba nyãa pɔ. ");
INSERT INTO biv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ala mɩ na lo a jie 'lɔ a kʊsɩbɛ na waa gar a tãna ɩ naa a bala na wõ a 'yɛr na ba ma sɔɔ de fɔɔ jaa nɩ pʊpɛl, ");
INSERT INTO biv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","tɩchɛ baa tara nyɩbɛ ɛ, ba maa kor ɛ. A 'yɛr jũu, wõm bɩɩ gefʊ wa wa a ba sɛ̃, ba ma lɩɛb puor fɔɔ jaa. ");
INSERT INTO biv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","A ala mɩ na lo a gʊʊr pɔ ɩ naa a bala na wõ a 'yɛr, ");
INSERT INTO biv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tɩchɛ ka a ãgãn nyã wõm, nɩ a bʊ̃tarsɩ bɛlfʊ, nɩ a bʊ̃bʊɔrsɩ fãɩn a 'yɛr, ka waa tʊ̃ɔ dɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A anyã mɩ na lo a kɔjɔ̃ pɔ ɩ naa a bala na wõ a 'yɛr na ba sɔɔ de na ba dɔɔ jur, ka amɩne ɩ lɩjɛr nɩ pie, amɩne lɩjaata, amɩne mɩ kɔbaa.” ");
INSERT INTO biv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wʊ sʊʊr ba naa, “Ba ma chʊm fãtɩn na ba de laa kpa pɔɔ bɩɩ de su gado pĩlem bɩɩ? A ba ɩ a jie 'lɔ wʊn na chaar nɩrɛ jaa lɛ ba ma dɔɔl ɛ? ");
INSERT INTO biv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bon jaa na pɔɔ ban yuo wʊ naa, ka ala a jaa mɩ na sɔɔl yi chãa pɔ. ");
INSERT INTO biv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nɩrɛ jaa na tara toor, wʊ chɛlɛ!” ");
INSERT INTO biv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ka wʊ 'yɛr kʊ ba, “Yɩ bɔ̃ɔ chɛlɛ sʊ̃ a lɛ yɩn wõnõ. A lɛ fʊn man tɩr, lɛ mɩ lɛ ban man kʊ fʊ, tɩ dɔɔl gba. ");
INSERT INTO biv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nɩrɛ jaa na tara, Nãaŋmɩn ma vɛ̃ naa ka wʊ nyɛrɛ dɔɔlɔ, nɩrɛ nyã mɩ na ba tara ɛ, a bãlãa ala gba wʊn tara, Nãaŋmɩn na de naa a wʊ sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Tɩ lɛ bɔ̃ɔ 'yɛr kʊ ba, “A Nãaŋmɩn nãalʊ̃ʊ nɩtɔ̃ lɛ wʊ kaara. Daba ma yaar a wʊ bʊ̃bʊrɔ bar. ");
INSERT INTO biv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tãsɔɔ nɩ mɔ̃tɔ̃ɔ, ka wʊ gãn bɩɩ wʊ ir naa, a bʊ̃bie ma bulaa naa nʊ̃ɔ, tɩchɛ a wʊ mãɛ gba maa bɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A bʊ̃bie ma bul naa a tẽe naa tɔ vaar tɩ dɔɔ jur, bɩ a bie. ");
INSERT INTO biv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ala wa bɩ baar, wʊ ma chiin nɩ sʊɔ tɩ ŋman bojũu a ŋmab sɔ̃ɔ ta naa.” ");
INSERT INTO biv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ka Yesu lɛ 'yɛr, “Bo lɛ sɩn de man a Nãaŋmɩn nãalʊ̃ʊ bɩɩ sʊkpa buor lɛ sɩn lɔb gbɛb wʊ? ");
INSERT INTO biv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wʊ kaara fɩka a kɔ̃kɔ̃ɔ bir, 'lɔ lɛ ɩ a bʊ̃bie a jaa pɔ bʊ̃bile. ");
INSERT INTO biv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tɩchɛ wʊ ma bul ɩ tɩkpɛ̃ɛ na wʊ tɛ wilbɛrɛ, ka a lubil ma wa mara a wʊ 'maar pɔ.” ");
INSERT INTO biv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu de naa sʊkpayɔɔ na nyɛtaa na wʊ 'yɛr a 'yɛr kʊ ba, a lɛ an na ɩ ka ba tʊ̃ɔ bɔ̃ɔ a par. ");
INSERT INTO biv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sʊkpar tɛɛ lɛ wʊ ma de 'yɛrɛ nɩ a 'yɛr kʊrɔ ba. Tɩchɛ ala wa ɩ 'lɔ nɩ a wʊ poturbo tɛɛ lɛ, wʊ ma wiil naa a jaa par kʊ ba. ");
INSERT INTO biv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","A daar 'lɔ̃nɔ̃ jãanʊɔr, wʊ 'yɛr kʊ a wʊ poturbo, “Yɩ ɩ a sɩ gɔ̃ɔ chen a man gɔ̃ɔn.” ");
INSERT INTO biv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ba bar naa a nɩyɔyɔɔ bala tɩchɛ ka a wʊ poturbo tara wʊ, ka ba 'matãan a gborsɩ amɩne gɔ̃ɔnɔ̃. ");
INSERT INTO biv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ka a man kʊ̃ɔ sɛkpɛ̃ɛ 'lɔ ire ka a kʊ̃ɔ kpɛ a gboro pɔ ɩrɛ na sɛɛ ");
INSERT INTO biv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","tɩchɛ ka a Yesu be a gboro par gã kɔɔl wʊ ju guro. Ka a wʊ poturbo sãɩ wʊ na ba sʊrɔ wʊ, “Wiwile, a ba bã fʊ sɩn mʊrɔ bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Be lɛ ka wʊ ir tãn a sɛsɛbɛ nɩ a man, “Yɩ ŋmaa vʊʊr! Yɩ ara a lɛ nɛ!” Ka a sɛsɛbɛ ŋmaa vʊʊr ka a man ara jomm. ");
INSERT INTO biv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ka wʊ sʊʊr a wʊ poturbo, “Bo lɛ so ka yɩ joro a dãbãɛ? Yɩ chɛnɛ na ba sɔɔ ma bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ka a dãbãɛ kpɛ ba ka ba lɩɛb sʊrɔ taa, “An lɛ a nyã ka a sɛsɛbɛ nɩ a man tu a wʊ nɛɛ?” ");
INSERT INTO biv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu nɩ a wʊ poturbo gɔ̃ɔ naa a man, a Gerasenɩ nɩbɛ wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu na wa yi a gboro pɔ, daba na gele yi naa a yar par wa tuor wʊ. ");
INSERT INTO biv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A gẽgelaa nyã kpɩɛrɛ naa a yar par ka nɩrɛ jaa ba be be na tʊ̃ɔ lũ wʊ nɩ bɔ̃jɔrsɩ gba ɛ. ");
INSERT INTO biv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ba ma lũ naa a wʊ gbɛɛ nɩ a nuur tɩchɛ ka wʊ ŋma, tɩ kar a kue ala bar. Nɩrɛ jaa ba be be na tʊ̃ɔ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tãsɔɔ nɩ mɔ̃tɔ̃ɔ, wʊ ma be naa a yar par nɩ a tɔ̃n ju tãna tɩ ŋmara a wʊ mãɛ nɩ kʊsɩbɛ. ");
INSERT INTO biv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wʊn wa nyɛ a Yesu na be tɛɛr, wʊ jo naa tɩ lo gbur dumo a wʊ niem, ");
INSERT INTO biv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","tɩ na wʊ ŋme chɛlma 'yɛrɛ, “Bo fʊ bʊɔrɔ ɩka fʊ ɩ ma? Fʊ ɩ naa a Nãaŋmɩn nyã na gar a jaa Bie pɔn Nãaŋmɩn ɩka fʊ kʊ̃ ge ma ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bojũu Yesu dɔ̃ɔ 'yɛrɛ kʊrɔ wʊ ɩka, “A fʊ̃ʊ sɩdɛɛr wa yi a daba pɔ.” ");
INSERT INTO biv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Be lɛ ka Yesu sʊʊr wʊ, “Bãa a fʊ yuor di?” Ka wʊ 'yɛr, “Sɩyɔɔ, bojũu sɩ waa naa.” ");
INSERT INTO biv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ka wʊ sʊɔr a Yesu yãayãabɩlɛ ɩka wʊ ta dii wʊ bar a jie 'lɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Doyɔɔ mɩ ara na gbʊr a tɔ̃ɔ, dire. ");
INSERT INTO biv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ka a sɩdɛbɛ sʊɔr a Yesu, “Ir sɩ 'yɔ̃ɔ a dor ala pɔ na fʊ sɔɔ ka sɩ tɩ kpɛ a ba pɔ.” ");
INSERT INTO biv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Wʊ sɔɔ naa ka a sɩdɛbɛ yi tɩ kpɛ a dor ala. A ɩ naa dor tur ayi (2,000) ka a jaa tĩgbil suu tɩ kpɛ a man pɔ gbʊ̃m kpi kpi. ");
INSERT INTO biv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","A bala na kaara a dor jon kul a tẽe pɔ nɩ a tẽbil ala na gbʊr tɩ 'yɛr a lɛ na ɩ. Ka a nɩbɛ yi chen ɩka ba tɩ kaa. ");
INSERT INTO biv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ba wa naa a Yesu sɛ̃ wa nyɛ a daba 'lɔ na dɔ̃ɔ tara a sɩdɛyɔɔ gele ka wʊ chɩ su bonsɩ jãnɛ, ka a dãbãɛ kpɛ ba. ");
INSERT INTO biv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","A bala na nyɛ 'yɛr kʊ a nɩbɛ a lɛ na ɩ a daba na dɔ̃ɔ tara a sɩdɛbɛ nɩ a dor 'yɛr, ");
INSERT INTO biv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ka a nɩbɛ piel sʊɔrɔ a Yesu ka wʊ yi a ba wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu na wa kpɩɛrɛ a gboro pɔ ka a daba 'lɔ 'yɔ̃ɔ a sɩdɛbɛ na yi sʊɔr wʊ ɩka wʊ ɩ a ba 'mataa chen. ");
INSERT INTO biv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ka a Yesu ba sɔɔ ɛ, tɩ 'yɛr wʊ, “Kul a fʊ yir dẽme sɛ̃ tɩ 'yɛr kʊ ba a lɛ a Soro na ɩ kʊ fʊ, nɩ a lɛ wʊn jo a fʊ nɩbaal.” ");
INSERT INTO biv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","A daba chen na wʊ tɩ piel 'yɛrɛ a lɛ a Yesu na maal kʊ wʊ a wɛr 'lɔ pɔ ban bʊɔlɔ a Dekapolisɩ. Ka a nɛɛr 'maa a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu na wa gɔ̃ɔ a man gɔ̃ɔn go, nɩyɔyɔɔ lɔ̃ɔ naa na ba jilʊ̃ wʊ. Wʊ chɛnɛ na ara a man nɛɛ, ");
INSERT INTO biv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ka a ba lɔ̃ɔfʊ jie nɩkpɛ̃ɛ ãsʊɔ ban bʊɔlɔ Jairusɩ wa a be. Wʊn wa nyɛ a Yesu, ");
INSERT INTO biv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","wʊ gbur dumo a Yesu niem tɩ sʊɔr wʊ, “Yãayãabɩlɛ, a n bipɔɔbile lɛ ɩ baal ɩrɛ na kpi. Wa dɔɔl wʊ a fʊ nũu ka wʊ sa ta kpi ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ka a Yesu nɩ a daba 'mataa chiine. Nɩyɔyɔɔ turo naa dara taa tɩɛrɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pɔɔ kɔ̃ɔ mɩ ben be lo sɩɛ suoro faara yuomo pie nɩ ayi. ");
INSERT INTO biv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wʊ bal di dɔɔyɛ yɔɔ a tɩtɩɩlbɛ jie na wʊ sɔ̃ɔ bon jaa wʊn tara tɩ ba sa ɛ. Ka a baal tʊ̃ɔnɔ̃ wʊ. ");
INSERT INTO biv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Wʊn wa wõ a Yesu yele, wʊ tu naa a puor tɩ sɩɩr a wʊ fuu, ");
INSERT INTO biv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","bojũu wʊ 'yɛr kʊ a wʊ mãɛ. “Maa tʊ̃ɔ sɩɩr a wʊ fuu gba, ɩn sa naa, na n pɛ̃n.” ");
INSERT INTO biv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wʊn wa sɩɩr a Yesu fuu nɛɛ wa baar, a jãɩ ŋmaa naa a dẽdẽe daa ka wʊ bɔ̃ɔn ɩka a wʊ wʊʊr baar naa. ");
INSERT INTO biv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ka a Yesu mɩ bɔ̃ɔn a fɔɔ 'lɔ̃nɔ̃ a kpɛ̃ɔ na yi a wʊ sɛ̃. Ka a wʊ lɩɛb a nɩyɔɔ bala pɔ sʊʊr, “An lɛ sɩɩr a n fuu?” ");
INSERT INTO biv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ka a wʊ poturbo 'yɛr, “Nyɛ a lɛ a nɩyɔyɔɔ banyã na dara taa tɩɛrɛ fʊ, tɩchɛ a fʊ sʊrɔ a sʊɔ 'lɔ na sɩɩr fʊ!” ");
INSERT INTO biv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tɩchɛ ka a Yesu chɛnɛ kaara gʊɔrɔ ɩka wʊ nyɛ a nɩrɛ 'lɔ na sɩɩr wʊ. ");
INSERT INTO biv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ka a pɔɔ na bɔ̃ɔn a lɛ na ɩ, dãbãɛ kpɛ wʊ naa ka wʊ mɩrɛ na wʊ wa gbur dumo a Yesu niem tɩ 'yɛr a lɛ jaa na ɩ. ");
INSERT INTO biv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ka a Yesu 'yɛr kʊ wʊ, “N yɛpɔɔ, fʊn sɔɔ ma jũu, fʊ sa naa. Kulo nɩ ãgãn 'maar, a fʊ dɔɔyɛ baar naa.” ");
INSERT INTO biv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","A Yesu ba 'yɛr baar ɛ, tɩchɛ nɩbɛ kɔ̃ɔ yi a Jairusɩ yir wa 'yɛr wʊ, “A fʊ bie kpi naa. Bãa 'yɔ̃ɔ fʊ dɔ̃ɔnɔ̃ a wiwile go?” ");
INSERT INTO biv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu ba chɛlɛ a lɛ ban 'yɛrɛ ɛ, tɩ na wʊ 'yɛr kʊ a daba, “Taa joro dãbãɛ ɛ. Sɔɔ ma dɛ.” ");
INSERT INTO biv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu ba sɔɔ ka nɩrɛ jaa tu wʊ ɛ, ka Pita nɩ Jemesɩ nɩ a wʊ yɛbile Jɔɔn tɛɛ ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ban wa ta a Jairusɩ yir, Yesu nyɛ naa a nɩbɛ na kõnõ ŋmiere chɛlsɩ. ");
INSERT INTO biv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ka wʊ kpɛ tɩ sʊʊr ba, “Bãa lɛ yɩ kõnõ ŋmiere nɩ a chɛlsɩ a lɛ? A bie ba kpi ɛ. Wʊ gur naa.” ");
INSERT INTO biv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A ba laara tʊrɔ nɩ wʊ. Wʊ dii naa a nɩbɛ ba jaa bar ka ba yi tɩ wʊ tara a bie sãa nɩ a ma nɩ a wʊ poturbo bala wʊn 'mataa chiin, a ba kpɛ a jie 'lɔ a bikũu na be. ");
INSERT INTO biv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ka wʊ tɩ nyɔɔ a pɔɔbile nũu tɩ 'yɛr, “Talita kum!” A par lɛ a Yesu nɩbɛ kɔkɔr pɔ, “Pɔɔbile, ir!” ");
INSERT INTO biv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ka wʊ vaa ir chiine. Yuomo pie nɩ ayi bie lɛ. Ka a yele 'maa ba nɛɛ. ");
INSERT INTO biv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu kpaal ba naa jũu ka ba taa vɛ̃ ka a nɩrɛ jaa wõ naa ɛ. Tɩ 'yɛr ɩka ba kʊ a pɔɔbile bʊ̃diir ka wʊ di. ");
INSERT INTO biv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu yi naa a be ka a wʊ poturbo tu wʊ ka a ba 'mataa kul a Najaretɩ na ɩ a wʊ tẽe. ");
INSERT INTO biv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ka a Pɛ̃nfʊ Bɩbir wa ta, ka wʊ kpɛ be a ba lɔ̃ɔfʊ jie tɩ piel wile, ka a nɩyɔɔ bala na wõ nɛɛr 'maa. Ka ba sʊrɔ, “Nyɩnɛ lɛ a daba nyã nyɛ a bɔ̃ɔfʊ nyã? Yɛ̃ buor lɛ a nyã wʊn tara na wʊ gba tʊ̃nɔ̃ nɩ a nɛ'maa tʊ̃mɔ̃? ");
INSERT INTO biv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A ba ɩ a mɩmɩɛrɛ lɛ ɛ? A ba ɩ a Mɛɛr bie lɛ ɛ, a wʊ yɛbil ɩ Jemesɩ nɩ Josesɩ nɩ Judas nɩ Simon ɛ? Ka a wʊ yɛpɔbɔ mɩ be ka a sɩ sɛ̃ ɛ?” ");
INSERT INTO biv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ka a Yesu 'yɛr kʊ ba, “Nãaŋmɩn 'yɛ'yɛrɛ nyɛrɛ na 'yɔ̃ɔfʊ jie jaa, tɩchɛ a wʊ mãɛ tẽe nɩ a wʊ yir dẽme nɩ a wʊ nɩbɛ sɛ̃ lɛ waa nyɛrɛ 'yɔ̃ɔfʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Waa tʊ̃ɔ tʊ̃ nɛ'maa tʊ̃mɔ̃ yɔɔ a be ɛ, tɩ wʊ dɔɔl a wʊ nũu baalsɩ bãlãa a ba sa. ");
INSERT INTO biv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu nɛɛ 'maa wʊ naa bojũu baa sɔɔ de wʊ ɛ. Wʊ yɔn gʊɔr a tẽn na wʊ wile. ");
INSERT INTO biv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wʊ bʊɔl naa a wʊ poturbo Pie nɩ Ayi bala wʊn dɔ̃ɔ ir, ka ba wa a wʊ sɛ̃ ka wʊ tʊ̃ ba ayir yir, na wʊ kʊ ba kpɛ̃ɔ ka ba tʊ̃ɔ sɩdɛbɛ. ");
INSERT INTO biv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Wʊ 'yɛr kʊ ba, “Yɩ ta de bon jaa ɛ, yɩ tara dadiirsɩ tɛɛ. Yɩ ta tara bʊ̃diir ɛ, bɩɩ wʊʊr ɛ, bɩɩ yɔ̃ɔ libie a yɩ sɩɩr gãma pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yɩ ãsʊɔ jaa wʊ su nafɔbɔ nɩ fuu bʊ̃'yen tɛɛ. ");
INSERT INTO biv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yir jaa pɔ yɩn wa kpɛ, yɩ be a be tɩ ta a sɔ̃ɔ 'lɔ yɩn wa yi a tẽe 'lɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tẽe jaa pɔ yɩn wa kpɛ ka baa de yɩ ɛ, bɩɩ sɔɔ a 'yɛr ɛ, yɩn wa yire yɩ kpoor a yɩ gbɛɛ tã-uul ka a di a ba dɛɛr dãasɩɛ.” ");
INSERT INTO biv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ba yin chen tɩ mʊɔlɔ 'yɛrɛ a Nãaŋmɩn 'yɛr ɩka a nɩbɛ ba lɩɛb ba tɩɛr. ");
INSERT INTO biv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba diin a sɩdɛbɛ ka a yi, tɩ 'lɩɩ baalsɩ kãa ka ba sa. ");
INSERT INTO biv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","A nãa Hɛrɔd mɩ wõ naa a anyã, bojũu nɩrɛ jaa wõ naa a Yesu yuor. Ka a bamɩne 'yɛrɛ, “A Jɔɔn 'lɔ na ɩ a kɔ̃suoro, 'lɔ lɛ tɔ̃ɔ yi a yaa pɔ, ala lɛ so ka wʊ tʊ̃nɔ̃ a nɛ'maa tʊ̃mɔ̃ a lɛ.” ");
INSERT INTO biv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ka a banyã mɩ 'yɛrɛ, “Elaija lɛ.” Ka a bamɩne mɩ chɛnɛ 'yɛrɛ, “Wʊ ɩ naa a Nãaŋmɩn 'yɛ'yɛrɛ ãsʊɔ nɩtãa a bala na dɔ̃ɔ be be a kõro jaa.” ");
INSERT INTO biv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tɩchɛ a Hɛrɔd na wa wõ, wʊ 'yɛr naa, “A Jɔɔn 'lɔ ɩn vɛ̃ ka ba ŋmaa a wʊ ju lɛ, yi.” ");
INSERT INTO biv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","A Hɛrɔd mãɛ lɛ dɔ̃ɔ vɛ̃ ka ba nyɔɔ a Jɔɔn waan, wa lũ 'yɔ̃ɔ a pɔɔfʊ die pɔ. Wʊ ɩ naa a nɩtɔ̃, a wʊ yɛbile Filip pɔɔ Hɛrɔdiyas wʊn de jũu. ");
INSERT INTO biv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jɔɔn 'yɛr kʊ a Hɛrɔd, “A ba tara sɔr ɩka fʊ de a fʊ yɛbil vʊr pɔɔ kul ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ka a Hɛrɔdiyas tara nɩ a Jɔɔn jɛɛr bʊɔrɔ ɩka wʊ kʊ wʊ, tɩchɛ waa tʊ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","A Hɛrɔd bɔ̃ɔ naa a Jɔɔn na ɩ nɩsʊ̃ nɩ chɛchɛ, na wʊ joro a Jɔɔn dãbãɛ, na wʊ gu wʊ tara. A Hɛrɔd wa wõ a Jɔɔn 'yɛr a ma sɔb wʊn nɩbir, tɩchɛ wʊ ma bʊɔrɔ naa ɩka wʊ chɛlɛ a wʊ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tɩchɛ sɔr wa yuon kʊ a Hɛrɔdiyas a sɔ̃ɔ 'lɔ a nãa na wa maala a wʊ dɔɔfʊ bɩbir yele. A wʊ dɔɔfʊ bɩbir nyãna daar, wʊ bʊɔl naa a nɩbɛrɛ bala na turo a wʊ puor, nɩ a sojasɩ nɩbɛrɛ, nɩ a nɩbɛrɛ na be a Galilee pɔ. ");
INSERT INTO biv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","A Hɛrɔdiyas bipɔɔ wa kpɛ naa, na wʊ sɛ a bãnɛ ka a pɛl a nãa Hɛrɔd nɩ a wʊ nɩbɛrɛ bala ba jaa pʊɔ. Ka wʊ 'yɛr kʊ a pɔɔbile, “Sʊɔr ma bon jaa fʊn bʊɔrɔ, ɩn kʊ fʊ naa.” ");
INSERT INTO biv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Be lɛ wʊ põl kʊ a pɔɔbile, “Bon jaa fʊn sʊɔr ala ɩ a n nãalʊ̃ʊ ŋmaa gba lɛ, n na kʊ fʊ naa.” ");
INSERT INTO biv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ka wʊ yi chen tɩ sʊʊr a wʊ ma, “Bo lɛ ɩn sʊɔr?” Ka a wʊ ma 'yɛr wʊ, “Tɩ sʊɔr a Jɔɔn Kɔ̃suor ju.” ");
INSERT INTO biv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ka a pɔɔbile yi pɔɔ fɔɔ lɛ kpɛ a nãa sɛ̃ tɩ 'yɛr, “N bʊɔrɔ naa ɩka fʊ 'yɔ̃ɔ a Jɔɔn Kɔ̃suor ju a la'yɛlma pɔ kʊ ma a pʊ̃pãanyã.” ");
INSERT INTO biv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A nãa pʊɔ sɔ̃ɔ naa, tɩchɛ a nɩbɛ bala wʊn bʊɔl na wʊn põl kʊ a pɔɔbile jũu, waa bʊɔrɔ ɩka wʊ tɔr ɛ. ");
INSERT INTO biv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ka wʊ tʊ̃ a nɩkʊrɔ ãsʊɔ a dẽdẽe daa ɩka wʊ chen tɩ ŋmaa a Jɔɔn ju waan. A daba chen tɩ ŋmaa a Jɔɔn ju a pɔɔfʊ die pɔ ");
INSERT INTO biv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","'yɔ̃ɔ a la'yɛlma pɔ waan, wa kʊ a pɔɔbile ka wʊ de kʊ a wʊ ma. ");
INSERT INTO biv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","A Jɔɔn poturbo na wõ a lɛ, ba chen tɩ 'mɔɔ wʊ na ba ũu. ");
INSERT INTO biv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A Yesu nɩtʊ̃nsɩ lɩɛb wa lɔ̃ɔ taa a wʊ sɛ̃, na ba wa man a lɛ jaa ban tʊ̃ tɩ wiil a nɩbɛ, na ba kʊ a Yesu. ");
INSERT INTO biv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A nɩbɛ yɔɔ na waara tɩ chiine jũu, jaa gba ba be be a ban di ɛ. Be lɛ ka Yesu 'yɛr kʊ ba, “Yɩ wa a sɩn tɛɛ chen a jie 'lɔ a nɩbɛ na ba be ɛ, a yɩ tɩ jãnɛ pɛ̃n.” ");
INSERT INTO biv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ba kpɛ naa a gboro bala tɛɛ chen a jie 'lɔ̃nɔ̃. ");
INSERT INTO biv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tɩchɛ a nɩbɛ na wa nyɛ ban chiine ba bɔ̃ɔ ba naa. A ba yi a tẽn a jaa de nie jon gbɛɛ tɩ ara a be. ");
INSERT INTO biv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","A Yesu na wa tɩ ta, na wʊ nyɛ a nɩyɔɔ a ba ɩrɛ nɩbaal a wʊ sɛ̃, ban kaara fɩka piir na ba tara chɩnɛ jũu, wʊ piel wile ba yelyɔɔ. ");
INSERT INTO biv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mɔ̃tɔ̃ɔ na wa mʊrɔ a wʊ poturbo wa naa wa 'yɛr kʊ a Yesu, “A ka ɩ naa mɔgɔ̃ɔ, tɩ a mɔ̃tɔ̃ɔ mɩ mʊrɔ; ");
INSERT INTO biv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","wɛl a nɩbɛ bar a ba chen a por nɩ a tẽn na gbʊr tɩ bɔ bʊ̃diir da di.” ");
INSERT INTO biv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ka be lɛ a Yesu 'yɛr sɔɔ ba, “Yɩn mãɛ yɩ kʊ ba bʊ̃kɔ̃ɔ a ba di.” Ka a poturbo 'yɛr ɩka, “Nyɩnɛ lɛ sɩn nyɛ a libie anyãna? Nɩbʊ̃'yen ŋmɛrsɩ aniin sãyar gba! Ŋmɩnɛ lɛ sɩn ɩ kʊ ba jaa bʊ̃diir?” ");
INSERT INTO biv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A be lɛ a Yesu sʊʊr ba, “Paanʊ̃ɔsɩ aŋmɩnɛ lɛ yɩ tara? Yɩ chen tɩ kaa.” Be lɛ ba chen tɩ kaa tɩ wa 'yɛr kʊ wʊ, “Paanʊ̃ɔsɩ anũu, nɩ jãmɛ ayi.” ");
INSERT INTO biv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","A Yesu 'yɛr kʊ a poturbo a ba ɩ a nɩbɛ ba jaa a ba jɛ̃ gbulsɩ a mɔ'yɔlɔ ju. ");
INSERT INTO biv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Be lɛ a nɩbɛ jãnɛ jãnɛ, a gbulsɩ gbulsɩ. Bamɩne jãnɛ naa kɔɔr kɔɔr, ka bamɩne mɩ jãnɛ lɩjaayi nɩ piir. ");
INSERT INTO biv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","A Yesu de naa a paanʊ̃ɔsɩ anũu nɩ a jãmɛ ayi ala na wʊ kaa saaju tɩ dʊl puor Nãaŋmɩn yãan. Wʊ de naa a paanʊ̃ɔsɩ ŋma ŋma tɩ de kʊ a wʊ poturbo tɩ 'yɛr, “Yɩ de põ a nɩbɛ.” Tɩ lɛ de a jãmɛ ayi ala mɩ ŋma põ a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","A nɩbɛ ba jaa din, na ba tɩɩ, ");
INSERT INTO biv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","tɩchɛ ka a poturbo wob a bʊ̃ŋmaara 'yɔ̃ɔ pɛr pie nɩ ayi. ");
INSERT INTO biv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A nɩbɛ bala na dɔ̃ɔ di a bʊ̃diir ala, dɔɔr tɛɛ ɩ naa tur anũu. ");
INSERT INTO biv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ajienaa, ka a Yesu 'yɔ̃ɔ a wʊ poturbo a ba kpɛ a gboro na ba de nie chiine a Betɩsaida tɩ wʊ na wɛl a nɩbɛ bar. ");
INSERT INTO biv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wʊn wa bar ba wa baar, wʊ do naa a tɔ̃ɔ ju ɩka wʊ tɩ puor. ");
INSERT INTO biv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","A wɛr na wa sɔɔrɔ, a gboro be naa a man sãlsɔɔ, tɩchɛ ka wʊ be a wɛyõo, 'lɔ tɛɛ. ");
INSERT INTO biv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wʊ nyɛ naa a wʊ poturbo ka ba mɔ̃nɔ̃ a gboro faara bojũu a sɛsɛbɛ furo na tuoro ba. A wɛr na wa gbʊrɔ a chaarfʊ, wʊ yin chiine a kʊ̃ɔ ju waara a ba sɛ̃, ta bʊɔrɔ ɩka wʊ po ba. ");
INSERT INTO biv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ban wa nyɛ wʊn chiine a kʊ̃ɔ ju a lɛ, ba tɩɛr ɩka kpĩin lɛ, na ba ŋme chɛlsɩ, ");
INSERT INTO biv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","bojũu ba jaa nyɛ wʊ naa ka dãbãɛ kpɛ ba. Ajienaa, ka a Yesu tãn, “Yɩ nyɔɔ nyãa! Maa lɛ! Yɩ taa joro dãbãɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tɩ pãa kpɛ a gboro pɔ ka a sɛsɛbɛ ŋmaa vʊʊr. Ka a nɛɛr 'maa ba yɔɔ jaa. ");
INSERT INTO biv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Baa dɔ̃ɔ bɔ̃ɔ a paanʊ̃ɔsɩ ala par ɛ, bojũu a ba ju ba wõnõ nyaar ɛ. ");
INSERT INTO biv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ban wa gɔ̃ɔ a man do lũ a gboro a Genesaretɩ gɔ̃ɔn, ");
INSERT INTO biv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","tɩ tɔ̃ɔ yi a gboro pɔ, nɩbɛ nyɛ naa a Yesu bɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A nɩbɛ jon yɔ a wɛr 'lɔ wʊ jaa na ba tuo a ba baalsɩ nɩ sɔ̃n chiin jie jaa ban wõ ɩka wʊ be naa. ");
INSERT INTO biv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jie jaa wʊn chen, tẽkpɛ̃ɛ pɔ bɩɩ, tẽbile pɔ bɩɩ, ka a tẽe kõkoor lɛ̃ɛɛ, ba ma gaal naa a ba baalsɩ a chãa pɔ. Ba ma sʊɔrɔ naa a Yesu ɩka wʊ sɔɔ ka ba sɩɩr a wʊ fuu nɛɛ gba, bala jaa na sɩɩr, ma sa naa. ");
INSERT INTO biv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","A Faraseemɩne nɩ a Mosesɩ Nɛɛ wiwiilbe bamɩne yi naa a Jerusalɛm wa lɔ̃ɔ a Yesu sɛ̃, ");
INSERT INTO biv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","na ba nyɛ a wʊ poturbo ka ba dire nɩ nũdɛbɛ. Ka a lɛ wiil ɩka baa pɛɛ a ba nuur a, “Puorfʊ pɛɛfʊ 'lɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","A Faraseemɩne nɩ a Juu nɩbɛ ba maa di ka bala ba pɛɛ a ba puorfʊ pɛɛfʊ 'lɔ ɛ, na ba turo a lɛ a ba nɩbɛrɛ na bin. ");
INSERT INTO biv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bala wa yi daa wa, ba maa di ka bala ba pɛɛ a pɛɛfʊ 'lɔ ɛ. Ban turo a ba bin yɔɔ ala jũu, ba ma pɛɛn a ŋmama, dʊʊr nɩ a kulaar. ");
INSERT INTO biv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ala lɛ so ka a Faraseemɩne nɩ a Mosesɩ Nɛɛ wiwiilbe sʊʊr a Yesu, “Bo lɛ so ka a fʊ poturbo ba turo a lɛ a sɩ nɩbɛrɛ na bin ɛ, na baa pɛɛ a ba nuur ɛ tɩ dire nɩ nũdɛbɛ!” ");
INSERT INTO biv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ka a Yesu 'yɛr, “Sɩrɛ jaa lɛ a Isaiya dɔ̃ɔ 'yɛr a yɩn nɛɛr ayi dẽme 'yɛr na wʊ sɛb. Nãaŋmɩn 'yɛr naa, ‘A yɩn nɩbɛ banyãna 'yɔ̃ɔnɔ̃ ma naa nɩ a yɩ nɛɛ, tɩchɛ ka a yɩ pʊtɩɛr jãa a n sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pɔrɔ lɛ yɩ puoro ma, bojũu yɩ wile naa nɩsaal nɛbinsɩ tɩ tɩɛr ɩka maa nɛɛ lɛ.’ ");
INSERT INTO biv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yɩ bar naa a Nãaŋmɩn Nɛɛ tɩ turo a lɛ a yɩ nɩbɛrɛ na bin. ");
INSERT INTO biv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“A ba ɩ ka yɩ de yɛ̃ bar a Nãaŋmɩn Nɛɛ tufʊ tɩ turo a lɛ a yɩn mãɛ na bin ɛ. ");
INSERT INTO biv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesɩ 'yɛr naa a Nãaŋmɩn gãn pɔ, ‘'Yɔ̃ɔnɔ̃ a fʊ sãa nɩ a fʊ ma.’ Na wʊ mɩ lɛ 'yɛr, ‘Ɩ̃sʊɔ jaa wa pɔ 'yɔ̃ɔ a wʊ sãa bɩɩ a wʊ ma, ba kʊ wʊ.’ ");
INSERT INTO biv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tɩchɛ ka yɩn 'yɛr ɩka a sɛɛ na, nɩrɛ wa 'yɛr kʊ a wʊ sãa bɩɩ a wʊ ma, ‘Bon jaa ɩn naa kʊ fʊ, n den kʊ Nãaŋmɩn.’ ");
INSERT INTO biv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yɩ maa lɛ vɛ̃ ka wʊ maal bon jaa kʊ a wʊ sãa bɩɩ a wʊ ma ɛ. ");
INSERT INTO biv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yɩn ɩrɛ a nɩtɔ̃ jũu, ka yɩ kaara a Nãaŋmɩn Nɛɛ pɔrɔ tɩ turo a lɛ yɩn mãɛ na bin. Yelyɔɔ mɩ ben be yɩn ɩrɛ nɩ nyɛtaa a nɩtɔ̃.” ");
INSERT INTO biv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A Yesu lɛ bɔ̃ɔ bʊɔl a nɩyɔɔ ka ba lɩɛb wa a wʊ sɛ̃. Ka wʊ 'yɛr, “Yɩ ãsʊɔ jaa wʊ chɛl wõ ɩn 'yɛrɛ tɩ na yɩ bɔ̃ɔ a par. ");
INSERT INTO biv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bon jaa ba be ka a yõo ka nɩrɛ na de di ka a bʊ̃nyɩnɛ vɛ̃ ka wʊ dɛɛ ɛ, tɩchɛ bon 'lɔ na yi a nɩrɛ pʊtɩɛr pɔ lɛ na vɛ̃ ka wʊ dɛɛ.” ");
INSERT INTO biv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sɔ̃ɔ 'lɔ wʊn wa bar a nɩyɔɔ bala tɩ kpɛ a yir, a wʊ poturbo sʊʊr wʊ naa a sʊkpa par. ");
INSERT INTO biv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ka a Yesu sʊʊr ba, “Yɩ mɩ ɩ naa a nɩbɛ bala na ba bɔ̃ɔ a par bɩɩ? Yaa bɔ̃ɔ ɩka bon jaa ba be be ka nɩrɛ na de di na wʊ dɛɛ ɛ, ");
INSERT INTO biv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","bojũu wʊ maa kpɛ a wʊ tɩɛr pɔ ɛ, tɩchɛ pʊɔm lɛ wʊ ma suu na wʊ tɩ yi.” Yesu 'yɛr a nɩtɔ̃ na wʊ wiil ɩka a bʊ̃diir a jaa sɛɛn difʊ. ");
INSERT INTO biv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na wʊ mɩ lɛ 'yɛr ɩka, “Bon nyã na yi a nɩrɛ pʊtɩɛr pɔ lɛ ma tʊ̃ɔ vɛ̃ ka wʊ dɛɛ. ");
INSERT INTO biv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ala na ma yi a nɩrɛ pʊtɩɛr pɔ lɛ, tɩɛr dɛbɛ, nɩ a sɛ̃sɛ̃yele, nɩ a nãnyuur, nɩ nɩrɛ kʊfʊ, nɩ sɛ̃fʊ, ");
INSERT INTO biv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nɩ a nyuur, nɩ a putuo, nɩ jire, nɩ kakaba, nɩ bɔbier, nɩ yosɔ̃ɔ, nɩ pɔlyele nɩ a jɔlyele. ");
INSERT INTO biv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","A yeldɛbɛ anyãna a jaa lɛ ma yi a nɩrɛ pʊtɩɛr pɔ, vɛ̃ ka wʊ dɛɛ.” ");
INSERT INTO biv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Be lɛ ka a Yesu yi a be na wʊ chen a Tire wɛr pɔ. Wʊ tɩ kpɛ naa a yir ãsʊɔ pɔ, tɩ waa bʊɔrɔ ɩka nɩrɛ jaa wʊ bɔ̃ɔ ka wʊ ben be ɛ. Tɩchɛ wʊ kʊ̃ tʊ̃ɔ sɔɔl ɛ. ");
INSERT INTO biv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ala a pɔɔ na tara wʊ bipɔɔ ka a sɩdɛɛr tara, ajienaa wʊn wʊ wõ a Yesu 'yɛr, wʊ wan wa lo gbur dumo a wʊ niem. ");
INSERT INTO biv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A pɔɔ ba dɔ̃ɔ ɩ a Juu nɩrɛ ɛ, na wʊ dɔ̃ɔ yi be a Siriya Fonisiya paal pɔ. Wʊ sʊɔr naa a Yesu ɩka, wʊ dii a sɩdɛɛr bar a wʊ bipɔɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ka a Yesu 'yɛr, “Bar ka a bibiir di a lɛ ban bʊɔrɔ, taa de a bibiir bʊ̃diir kʊ baar ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ka a pɔɔ mɩ 'yɛr, “Sɩrɛ lɛ, n Soro, tɩchɛ a baar mɩ ma dire naa a bʊ̃ pʊr pʊr ala a bibiir na ma dire, tɩchɛ ka a loro a tẽe.” ");
INSERT INTO biv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ka a Yesu 'yɛr kʊ wʊ, “A nɩtɔ̃ fʊn 'yɛr jũu, kulo. A sɩdɛɛr bar naa a fʊ bipɔɔ.” ");
INSERT INTO biv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wʊ kul tɩ nyɛ a bie na gã a gado ju, tɩ a sɩdɛɛr yi. ");
INSERT INTO biv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu lɛ yi naa a Tire wɛr pɔ, na wʊ tu a Sidon suu a Galilee man pɔ, na wʊ tɩ chen a Dekapolisɩ paal pɔ. ");
INSERT INTO biv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Be lɛ ka nɩbɛ bamɩne waan daba na ɩ wõo, na waa tʊ̃ɔnɔ̃ 'yɛrɛ sʊ̃ ɛ. Ba sʊɔr a Yesu ka wʊ sɩɩr a daba nɩ a wʊ nũu na wʊ sãa wʊ. ");
INSERT INTO biv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ka Yesu tara a daba yin chɛ̃chɛ̃ɛ, na wʊ de a wʊ nubie su a daba tobɔɔr pɔ, be lɛ wʊ chɩr nataar tɩ sɩɩr a daba jãlbir. ");
INSERT INTO biv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na wʊ dʊl kaa a saaju tɩ vʊʊr na wʊ 'yɛr kʊ a daba, “Efata!”, a par lɛ a Yesu nɩbɛ kɔkɔr pɔ, yuo. ");
INSERT INTO biv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ajienaa ka a daba tobo yuo ka a jãlbir lɩɛb ka wʊ piel 'yɛrɛ jaa chɛchɛ. ");
INSERT INTO biv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu kpaal ban jũu ɩka ba taa ɩrɛ wa 'yɛrɛ kʊrɔ nɩrɛ jaa ɛ. Tɩchɛ a lɛ wʊn kpãa ba lɛ lɛ ba mɩ 'yɛrɛ yʊɔrɔ nɩ a jie wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","A nɩbɛ nɛɛ 'maan yɔɔ jaa ka ba 'yɛrɛ, “Wʊ ɩn yele jaa sʊ̃. Wʊ gba ma vɛ̃ naa ka wõo wõnõ, tɩ jãlbir lɩɛb 'yɛrɛ chɛchɛ.” ");
INSERT INTO biv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A sɔ̃ɔ 'lɔ̃nɔ̃ pɔ, nɩyɔɔ lɛ lɔ̃ɔn taa go a Yesu sɛ̃, tɩ baa tara bon na di ɛ. Yesu bʊɔl a wʊ poturbo ka ba wa a wʊ sɛ̃ ka wʊ 'yɛr, ");
INSERT INTO biv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“A nɩbɛ banyã ɩrɛ naa nɩbaal, bojũu ber ata nɩ nyã ban be a n sɛ̃, baa lɛ tara bon na di ɛ. ");
INSERT INTO biv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Maa mɩ bar ba ka ba kulo nɩ a kɔ̃, ban tɩ lon sɔr pɔ, bojũu bamɩne yin tɛɛr.” ");
INSERT INTO biv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ka a wʊ poturbo 'yɛr, “Tɩchɛ nyɩnɛ lɛ a kanaa a mɔgɔ̃ɔ pɔ nɩrɛ na nyɛ bʊ̃diir kʊ ba?” ");
INSERT INTO biv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ka a Yesu sʊʊr ba, “Paanʊ̃ɔsɩ aŋmɩnɛ lɛ yɩ tara?” Ka ba 'yɛr, “Paanʊ̃ɔsɩ ayopõi.” ");
INSERT INTO biv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wʊ 'yɛr naa a nɩbɛ, ka ba jãnɛ tẽe, tɩ na wʊ de a paanʊ̃ɔsɩ ayopõi ala puor Nãaŋmɩn yãan, tɩ ŋma ŋma de kʊ a wʊ poturbo ka ba de põ a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ba tara naa a jãbil amɩne, ka wʊ de a ala mɩ puor Nãaŋmɩn yãan, tɩ 'yɛr ɩka a poturbo ba de põ a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ba di naa tɩɩ tɩ chɛ. Ka a wʊ poturbo wob a bʊ̃ŋmaara ala ban di faa 'yɔ̃ɔ pɛr ayopõi. ");
INSERT INTO biv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ba ɩ naa tur anaar. Ka wʊ bar ba a sɔr. ");
INSERT INTO biv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ajienaa, 'lɔ nɩ a wʊ poturbo 'mantaa kpɛ a gboro pɔ, na ba chen a Dalmanuta paal pɔ. ");
INSERT INTO biv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Be lɛ a Faraseemɩne wa sʊrɔ wʊ yelsʊʊrsɩ, bʊɔrɔ ɩka ba bɛɛr wʊ kaa, na ba 'yɛr ɩka wʊ wiil ba jãnɛ kɔ̃ɔ ka ba bɔ̃ɔ ɩka wʊ yin a Nãaŋmɩn sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ka wʊ vʊʊr lɛ fãa tɩ 'yɛr, “Bo lɛ so ka a yɩn pʊ̃pãanyã nɩbɛ bʊɔrɔ jãnɛ ɩka yɩ nyɛ? Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, yɩ kʊ̃ nyɛ jãnɛ jaa ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wʊ bar ba naa tɩ kpɛ a gboro gɔ̃ɔnɔ̃ a man gɔ̃ɔn. ");
INSERT INTO biv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A wʊ poturbo ĩin naa ba tara paanʊ̃ɔ ɛ, tɩ tara bʊ̃'yen tɛɛ a gboro pɔ. ");
INSERT INTO biv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ka a Yesu 'yɛr kʊ ba, “Yɩ bɔ̃ɔn a Faraseemɩne paanʊ̃ɔ dãbɩl nɩ a Hɛrɔd paanʊ̃ɔ dãbɩl mɩ.” ");
INSERT INTO biv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ka a wʊ poturbo guor taa 'yɛrɛ, “Sɩn ba tara a paanʊ̃ɔ lɛ so.” ");
INSERT INTO biv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu na bɔ̃ɔn a lɛ ban 'yɛrɛ, wʊ sʊʊr ba naa, “Bãa 'yɔ̃ɔ lɛ yɩ 'yɛrɛ ɩka yaa tara paanʊ̃ɔ ɛ? Yaa bɔ̃ɔ a par sɛrɛ ɛ? A yɩ nyãa kpɛ̃mɛ na mɩ? ");
INSERT INTO biv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yɩ tara na nɩbie tɩ ba nyɛrɛ ɛ, na yɩ tara tobo tɩ ba wõnõ ɛ. Yɩ ĩin bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","A paanʊ̃ɔsɩ anũu ɩn dɔ̃ɔ de ŋma kʊ a dɔɔr tur anũu, pɛr aŋmɩnɛ lɛ yɩ wob a bʊ̃ŋmaar na chɛ 'yɔ̃ɔ?” Ka ba 'yɛr, “Pɛr pie nɩ ayi.” ");
INSERT INTO biv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ka a Yesu lɛ bɔ̃ɔ 'yɛr, “Ɩn lɛ de a paanʊ̃ɔsɩ ayopõi na n ŋma kʊ a nɩbɛ tur anaar, pɛr aŋmɩnɛ lɛ yɩ lɛ wob 'yɔ̃ɔ?” Ka ba 'yɛr, “Pɛr ayopõi.” ");
INSERT INTO biv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ka wʊ 'yɛr kʊ ba, “Yaa bɔ̃ɔ a par sɛrɛ ɛ?” ");
INSERT INTO biv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ba wa ta na a Betɩsaida tẽe pɔ, ka a nɩbɛ bamɩne tara jɔ̃ɔ waan a Yesu sɛ̃ wa sʊɔr wʊ, ka wʊ sɩɩr a jɔ̃ɔ ka wʊ nyɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu nyɔɔ naa a jɔ̃ɔ nũu tɩ tɔɔ wʊ yin a tẽe chɛchɛ. Wʊ tɩ chɩr nataar 'yɔ̃ɔ a daba nɩbie pɔ tɩ dɔɔl wʊ a nũu tɩ sʊʊr wʊ, “Fʊ nyɛn bon bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ka a daba dʊɔ kaa tɩ 'yɛr, “N nyɛn nɩbɛ na kaara tɩɩr kaar na ba vire yʊɔrɔ.” ");
INSERT INTO biv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ka a Yesu lɛ de a wʊ nuur pɔɔ a daba nɩbie, ka a wʊ nɩbie yuo, ka wʊ nyɛrɛ pãa nyɛ bomo a jaa chɛchɛ. ");
INSERT INTO biv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ka a Yesu 'yɛr kʊ wʊ, “Kulo, ta lɛ kpɛ a tẽe pɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu nɩ a wʊ poturbo chen naa a tẽn ala naa gbʊr Sisariya Filipai. A sɔr pɔ ban be chiine, a Yesu sʊʊr ba naa, “An lɛ a nɩbɛ 'yɛrɛ ɩka n ɩ naa?” ");
INSERT INTO biv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ka ba 'yɛr, “Bamɩne 'yɛr naa ɩka fʊ̃ʊ lɛ a Jɔɔn 'lɔ na dɔ̃ɔ suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ. Ka bamɩne mɩ 'yɛr ɩka Elaija. Ka a bamɩne mɩ chɛnɛ 'yɛrɛ ɩka fʊ ɩ naa Nãaŋmɩn 'yɛ'yɛrɛ ãsʊɔ na dɔ̃ɔ be be.” ");
INSERT INTO biv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ka a Yesu sʊʊr ba, “Tɩchɛ an lɛ yɩ mɩ 'yɛr ɩka n ɩ naa?” Ka a Pita 'yɛr, “Fʊ̃ʊ lɛ a Nɩ-iraa, a Nãaŋmɩn na tʊ̃ ɩka fʊ faa a wʊ nɩbɛ.” ");
INSERT INTO biv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ka a Yesu kpãa ba, “Yɩ taa ɩrɛ wa 'yɛrɛ a n 'yɛr kʊrɔ nɩrɛ jaa ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu piel wile ba na wʊ 'yɛrɛ ɩka a Nɩsaal Bie na din dɔɔyɛ yele yɔɔ pɔ, ka a Juu nɩbɛrɛ, nɩ a ba bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe tɔr wʊ bar, na ba kʊ wʊ. Tɩchɛ a ber ata daar wʊn ir naa a kũu pɔ ɩ vʊr. ");
INSERT INTO biv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wʊ 'yɛr naa anyã chãa pɔ, ka a Pita tara wʊ yin chɛ̃chɛ̃ɛ tɩ piel mii 'yɔ̃ɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tɩchɛ ka a Yesu lɩɛb kaa a wʊ poturbo tɩ mɩ mii 'yɔ̃ɔ a Pita 'yɛrɛ, “Tɔɔ chen be, Satan! A fʊ tɩɛr ɩn nɩrɛ tɩɛr, waa ɩ Nãaŋmɩn tɩɛr ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Be lɛ wʊ bʊɔl a nɩyɔɔ nɩ a poturbo ka ba wa a wʊ sɛ̃, ka wʊ 'yɛr kʊ ba, “Nɩrɛ 'lɔ jaa na bʊɔrɔ ɩka wʊ turo ma, a nɩnyɩnɛ na 'laara a wʊ mãɛ tɩ de a daa na ɩ dɔɔyɛ nɩ kũu, tɩ turo ma. ");
INSERT INTO biv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nɩrɛ 'lɔ jaa na bʊɔrɔ a wʊ nyɛvʊr, a wʊ nyɛvʊr na bɔr na, tɩ nɩrɛ 'lɔ na sɔɔ a wʊ nyɛvʊr bɔrfʊ a maa nɩ a 'yɛr nʊ̃ɔ nyã jũu, na faa wʊ naa. ");
INSERT INTO biv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ala ɩ nɩrɛ tara naa a wɛr nyã bonsɩ a jaa tɩ a wʊ sɩɛ wɛ, bo tɔ̃nɔ̃ lɛ be be? ");
INSERT INTO biv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bɩɩ bo lɛ nɩrɛ na de tɛɛn a wʊ sɩɛ? ");
INSERT INTO biv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ala ɩ nɩrɛ mɩ nyɛ naa a maa nɩ a n 'yɛrbie ka a ɩ vã yele a nɩbɛ banyã na tɔr Nãaŋmɩn bar, nɩ a putudẽme sɛ̃, a Nɩsaal Bie mɩ na kaa naa a nɩnyɩnɛ 'lɔ ka wʊ ɩ vĩ sʊɔ a sɔ̃ɔ 'lɔ wʊn wa lɩɛb wa nɩ a wʊ Sãa tɩɩr 'matãan a malaka chɛchɛsɩ.” ");
INSERT INTO biv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ka a Yesu 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, bamɩne ara naa a kana na ba kʊ̃ kpi ɛ, tɩchɛ na ba nyɛ a Nãaŋmɩn nãalʊ̃ʊ na na wa nɩ kpɛ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","A ber ayʊɔb puor, Yesu tara naa Pita nɩ Jemesɩ nɩ Jɔɔn tɛɛ na wʊ de ba nie ka ba 'mataa do tɔ̃wõo kɔ̃ɔ ju. Be lɛ wʊ tɩ chil a ba niem. ");
INSERT INTO biv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A wʊ fuu pɛl nyɩlɛ gar bʊ̃pɩla jaa nɩrɛ na maal a ka a wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ka a Elaija nɩ a Mosesɩ, wa daa yi a ba sɛ̃. Ka bala nɩ a Yesu 'mataa 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ka a Pita 'yɛr kʊ a Yesu, “Wiwile, a sɛɛ naa sɩn be a ka. Sɔɔ, ka sɩ maal sɛɛr ata: fʊ̃ʊ ãsʊɔ, Mosesɩ ãsʊɔ, Elaija mɩ ãsʊɔ.” ");
INSERT INTO biv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita ba bɔ̃ɔ ŋmɩnɛ wʊ na 'yɛr ɛ, bojũu dãbãɛ kpɛ ba naa. ");
INSERT INTO biv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ka a julõjuur wa pɔɔ ba, tɩ kɔkɔr 'yɛr a be a julõjuur pɔ, “N binʊ̃nãa lɛ a nyãna. Yɩ chɛlɛ a wʊ 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ajienaa ban ɩka ba kaa, baa lɛ nyɛ nɩrɛ jaa ɛ, tɩ nyɛ a Yesu tɛɛ. ");
INSERT INTO biv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ban wa yi a tɔ̃ɔ ju suro, ka a Yesu kpãa ba ɩka ba taa wa 'yɛrɛ a lɛ ban nyɛ kʊrɔ nɩrɛ jaa ɛ, wa tɩ tãn a lɛ a Nɩsaal Bie na ir yi a wʊ kũu pɔ. ");
INSERT INTO biv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Baa 'yɛr kʊ nɩrɛ jaa ɛ, tɩ 'yɛrɛ na ba sʊrɔ taa a kũu pɔ irfʊ par. ");
INSERT INTO biv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ka ba sʊʊr wʊ, “Bo lɛ so ka a Mosesɩ Nɛɛ wiwiilbe 'yɛr ɩka Elaija lɛ na de nie wa?” ");
INSERT INTO biv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ka a Yesu 'yɛr, “Sɩrɛ jaa lɛ a Elaija de nie wa chɔɔr a yele jaa. Tɩ ba mɩ sɛb ɩka a Nɩsaal Bie na din dɔɔyɛ yɔɔ ka ba tɔr wʊ bar. ");
INSERT INTO biv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tɩchɛ n 'yɛrɛ na kʊrɔ yɩ ɩka a Elaija wa naa ka ba ɩ a lɛ jaa ban bʊɔrɔ kʊ wʊ nɩtãa a lɛ ban sɛb a Nãaŋmɩn gãn pɔ.” ");
INSERT INTO biv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ban wa ta a poturbo ŋmaa bala sɛ̃, ba nyɛn nɩyɔɔ na ara jilʊ̃ ba ka a bala nɩ a Mosesɩ Nɛɛ wiwiilbe chɩrɛ taa. ");
INSERT INTO biv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ka nɩbɛ na wa nyɛ a Yesu na waara, ka ba nɛɛ 'maa ka ba jo tuor puor wʊ. ");
INSERT INTO biv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ka a Yesu sʊʊr a wʊ poturbo, “Bo lɛ yɩ chɩrɛ taa a lɛ?” ");
INSERT INTO biv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ka nɩrɛ ãsʊɔ 'yɛr a be a nɩyɔɔ pɔ, “Wiwile, n bidaba lɛ sɩdɛɛr nyɔɔ ka wʊ maa tʊ̃ɔ 'yɛr ɛ, ka n waan a fʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","'Lɔ wa ir wʊ, wʊ ma daa wʊn lɔb tẽe ka wʊ furo a natafuul tɩ ɔɔrɔ a nyɩmɛ tɩ tãa. Ka n wa sʊɔr a fʊ poturbo ɩka ba dii a sɩdɛɛr nyãna bar, ka baa tʊ̃ɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ka a Yesu 'yɛr, “Aa, a yɩn nɩbɛ banyã na ba tara sɔɔfʊ ɛ, n be a yɩ sɛ̃ kor ta ŋmɩnɛ? N tara kãnyir ŋmɩnɛ kʊ yɩ? Waan a bie wa kʊ ma.” ");
INSERT INTO biv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ka ba waan a bie. A sɩɛ na wa nyɛ a Yesu, wʊ ir tãa a bie ka wʊ lo tẽe, mɩrɛ tɩ bile tɩ furo a natafuul. ");
INSERT INTO biv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Be lɛ a Yesu sʊʊr a bie sãa, “Sɔ̃ɔ buor lɛ a piel wʊ a nɩtɔ̃?” Ka a sãa 'yɛr, “A bibile daar jaa lɛ a piel wʊ. ");
INSERT INTO biv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wʊ ma daa wʊn lɔb bũu pɔ bɩɩ kʊ̃ɔ pɔ bʊɔrɔ ɩka wʊ kpi. Ala ɩ fʊn tʊ̃ɔ ɩ yele kɔ̃ɔ, kaa a sɩ nɩbaal tɩ na fʊ sʊ̃ʊ sɩ.” ");
INSERT INTO biv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ka a Yesu mɩ 'yɛr, “Bo lɛ so ka a fʊ 'yɛr ɩka ala ɩ ɩn tʊ̃ɔ naa? Yele jaa ɩn kɔ̃mɔ̃kɔ̃mɔ̃ kʊ a bala na sɔɔ de ma.” ");
INSERT INTO biv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ajienaa lɛ a bie sãa chɩɩr, “N sɔɔn de fʊ! Sʊ̃ʊ ma, a n sɔɔfʊ ba bɛrma ɛ!” ");
INSERT INTO biv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu na wa nyɛ a nɩyɔɔ na joro lɔ̃ɔnɔ̃ taa a jie, wʊ tãn a sɩdɛɛr, “Fʊ̃ʊ sɩdɛɛr na ma vɛ̃ ka nɩbɛ ɩ wõn, wa yi a bie pɔ na fʊ taa lɛ ɩrɛ wa kpɩɛrɛ a wʊ pɔ go ɛ!” ");
INSERT INTO biv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ka a sɩɛ ŋme chɛlma tɩ dɔ̃ɔnɔ̃ a bie yɔɔ tɩ yi, ka a bie gã kaara fɩka kũu. Ka a nɩbɛ 'yɛr, “Wʊ kpi naa!” ");
INSERT INTO biv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tɩchɛ ka a Yesu nyɔɔ a wʊ nũu tɔɔ, ka wʊ ir ara. ");
INSERT INTO biv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu na wa kpɛ a yir 'lɔ nɩ a wʊ poturbo tɛɛ, ka ba sʊʊr wʊ, “Bãa lɛ so ka sɩn ba tʊ̃ɔ a sɩdɛɛr nyã dii bar ɛ?” ");
INSERT INTO biv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ka a Yesu 'yɛr, “Nãaŋmɩn sʊɔrfʊ tɛɛ lɛ na vɛ̃ a fʊ dii a sɩɛ nyã ka wʊ yi.” ");
INSERT INTO biv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ba yin a jie 'lɔ tɩ tu a Galilee tal. Yesu ba bʊɔrɔ ɩka nɩrɛ jaa wʊ bɔ̃ɔ a jie ban be ɛ, ");
INSERT INTO biv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","bojũu wʊ wile naa a wʊ poturbo, “Ban de naa a Nɩsaal Bie kʊ a nɩbɛ, ka ba kʊ wʊ. Ka a ber ata daar wʊn ir naa, na wʊ tara nyɛvʊr.” ");
INSERT INTO biv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tɩchɛ baa bɔ̃ɔ a par a lɛ wʊn 'yɛrɛ ɛ, tɩ joro dãbãɛ ɩka ba sʊʊr wʊ. ");
INSERT INTO biv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu nɩ a wʊ poturbo wa ta na a Kapenahum. Ban wa kpɛ a yir, a Yesu sʊʊr ba naa, “Bãa 'yɔ̃ɔ lɛ yɩ chɩrɛ taa a sɔr pɔ a lɛ?” ");
INSERT INTO biv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ka ba ɩ jaa gbulo, bojũu a sɔr pɔ ba chɩrɛ na taa ɩka an lɛ ɩ a kpɛ̃ɛ. ");
INSERT INTO biv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu na wa jãnɛ wʊ bʊɔl naa a wʊ poturbo Pie nɩ Ayi na wʊ 'yɛr kʊ ba, “A yɩ ãsʊɔ wa bʊɔrɔ ɩka wʊ de nie, a nɩnyɩnɛ 'lɔ wʊ ɩ a yɩ jaa bile, na wʊ ɩ a yɩ jaa tʊ̃tʊ̃nɔ̃.” ");
INSERT INTO biv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesu vɛ̃ naa ka bibile kɔ̃ɔ ir ara a ba jaa sãlsɔɔ. Wʊ 'mɔɔn a bie tɩ 'yɛr kʊ ba, ");
INSERT INTO biv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nɩrɛ 'lɔ jaa na de a bibiir banyãna taaba a n jũu, maa lɛ wʊ de. Nɩrɛ 'lɔ jaa mɩ na de ma, a ba ɩ maa lɛ wʊ de ɛ, tɩchɛ a nɩrɛ 'lɔ na tʊ̃ ma lɛ wʊ de.” ");
INSERT INTO biv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ka a Jɔɔn 'yɛr kʊ wʊ, “Wiwile, sɩ nyɛ naa nɩrɛ ãsʊɔ mɩ na de a fʊ yuor na wʊ dire nɩ a sɩdɛbɛ ka a yire. Ka sɩ 'yɛr ɩka wʊ bar bojũu waa ɩ a sɩ ãsʊɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ka a Yesu 'yɛr kʊ ba, “Yɩ ta dii wʊ bar ɛ. Nɩrɛ 'lɔ jaa na de a n yuor tʊ̃nɔ̃ nɩ nɛ'maa tʊ̃mɔ̃ kʊ̃ 'yɛr ma 'yɛrdɛɛr go ɛ. ");
INSERT INTO biv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nɩrɛ jaa na ba jɛɛr nɩ sɩ ɛ, pʊɔ sɩ naa. ");
INSERT INTO biv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, nɩrɛ 'lɔ jaa na kʊ yɩ kɔ̃'maar nɩ ŋmele, yɩn ɩ a maa sofʊ jũu, a nɩnyɩnɛ kʊ̃ wa faa a wʊ sãyar ɛ. ");
INSERT INTO biv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ala ɩ ãsʊɔ jaa mɩ vɛ̃ naa a bʊ̃bil banyãna ãsʊɔ na sɔɔ ma ɩ yelbier, a nɩnyɩnɛ 'lɔ̃nɔ̃, bala 'mɔɔ nɩɛr lũ yɔɔl a wʊ nyĩe pɔ daa 'yɔ̃ɔ a man pɔ, ala sa. ");
INSERT INTO biv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ala ɩ a fʊ nũu vɛ̃ naa ka fʊ ɩ yelbier, ŋmaa bar. Fʊn tɩ kpɛ nyɛvʊr pɔ nɩ nũŋmaa sa naa fʊn tara a nuur a jaa ayi tɩ tɩ kpɛ a wõm jie a be a bũu na ba kpĩine ɛ. ");
INSERT INTO biv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ala ɩ a fʊ gbɛr mɩ vɛ̃ naa ka fʊ ɩ yelbier, ŋmaa bar fʊn tɩ kpɛ nyɛvʊr pɔ nɩ gbɛŋmaa sa naa fʊn tara a gbɛɛ a jaa ayi tɩ tɩ kpɛ a wõm jie. ");
INSERT INTO biv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ala ɩ a fʊ nɩbir mɩ vɛ̃ naa ka fʊ ɩ yelbier, 'loo bar. Fʊn tɩ kpɛ Nãaŋmɩn nãalʊ̃ʊ pɔ nɩ nɩbifɩɛ sa naa fʊn tara a nɩbie ayi tɩ tɩ kpɛ a wõm jie. ");
INSERT INTO biv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Be lɛ a ‘Bufulo ba kpire ɛ, ka a bũu mɩ ba kpĩine ɛ.’ ");
INSERT INTO biv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Dɔɔyɛ difʊ na lɩɛb nɩrɛ jaa nɩtãa lɛ nyaar na ma wõ bʊ̃diir ka a nʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Nyaar ɩ naa, tɩchɛ a nʊ̃ɔ wa baar, ban lɛ bʊɔl wʊn nyaar ɔ? Yɩ ɩ nyaar, na yɩ tara nyã'maar kʊ taa.” ");
INSERT INTO biv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu pãa yin a jie 'lɔ na wa chen a Judiya paal, na wʊ tɩ gɔ̃ɔ a Jordan man. Nɩyɔɔ lɛ wa naa a wʊ sɛ̃ go, ka wʊ wile ba nɩtãa a lɛ wʊn ma wile ba. ");
INSERT INTO biv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A Faraseemɩne bamɩne wa naa ɩka ba wa bɛɛr wʊ kaa, na ba sʊʊr wʊ, “Sɔr ben be ka daba na tɔr a wʊ pɔɔ bar bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ka a Yesu mɩ sʊʊr ba, “Ŋmɩnɛ lɛ a Mosesɩ dɔ̃ɔ 'yɛr?” ");
INSERT INTO biv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ka ba 'yɛr, “Mosesɩ bar sɔr ɩka daba wʊ sɛb dãasɩɛ gãn tɩ na wʊ tɔr a wʊ pɔɔ bar.” ");
INSERT INTO biv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ka a Yesu 'yɛr kʊ ba, “A yɩ nyãkpãɛn jũu lɛ so ka wʊ sɛb a lɛ. ");
INSERT INTO biv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tɩchɛ a wɛr pielfʊ, Nãaŋmɩn maal daba nɩ pɔɔ. ");
INSERT INTO biv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","A lɛ jũu, daba na bar a wʊ sãa nɩ a wʊ ma tɩchɛ ka 'lɔ nɩ a wʊ pɔɔ ɩ bʊ̃'yen, ");
INSERT INTO biv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ka ba jaa ayi ɩ ãgãn bʊ̃'yen. Baa lɛ ɩ ayi ɛ, tɩ ɩ bʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","A lɛ jũu, bon 'lɔ jaa Nãaŋmɩn na 'mataa, nɩrɛ wʊ ta nyɔɔ wɛl ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ban wa lɩɛb kul a yir, a Yesu poturbo sʊʊr wʊ naa a 'yɛr nyã go. ");
INSERT INTO biv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ka wʊ 'yɛr kʊ ba, “Daba jaa na tɔr wʊ pɔɔ bar tɩ kul pɔɔ yuo, wʊ maal yelbier. ");
INSERT INTO biv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Lɛ mɩ lɛ, pɔɔ wa tɔr a wʊ sɩrɛ bar tɩ kul dayuo wʊ mɩ maal yelbier.” ");
INSERT INTO biv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nɩbɛ dɔ̃ɔ waara nɩ a ba bibiir ɩka Yesu wʊ dɔɔl ba a wʊ nũu, tɩchɛ ka a wʊ poturbo mii 'yɔ̃ɔ ba. ");
INSERT INTO biv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu na wa nyɛ a lɛ a wʊ poturbo na ɩ, wʊ nyɛn suur na wʊ 'yɛr kʊ ba, “Yɩ bar a bibiir ka ba wa a n sɛ̃, na yɩ ta ŋmaa ba sɔr ɛ. A ba nyãna taaba lɛ so a Nãaŋmɩn nãalʊ̃ʊ. ");
INSERT INTO biv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, nɩrɛ jaa na ba sɔɔ de a Nãaŋmɩn nãalʊ̃ʊ nɩtãa a bibile ɛ, wʊ kʊ̃ tʊ̃ɔ kpɛ be ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Be lɛ wʊ 'mɔɔr a bibiir, tɩ dɔɔl ba nuur na wʊ sʊɔr Nãaŋmɩn 'yɔ̃ɔ ba. ");
INSERT INTO biv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu na wa de a sɔr chiine, daba jon var gbur dumo a Yesu niem tɩ sʊʊr wʊ, “Wiwiilmãɛ, bo lɛ ɩn maal, naa nyɛ nyɛvʊr na ba tara baarfʊ ɛ?” ");
INSERT INTO biv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ka a Yesu 'yɛr kʊ wʊ, “Bãa 'yɔ̃ɔ lɛ fʊ bʊɔl ma nɩmãɛ? Nɩrɛ jaa ba ɩ mãɛ ɛ, ka Nãaŋmɩn tɛɛ ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Fʊ bɔ̃ɔ naa a Nãaŋmɩn Nɛɛ. Taa kʊ nɩrɛ ɛ. Taa sɛ̃nɛ ɛ. Taa juro ɛ. Taa dire dãasɩjirɩ ɛ. Taa fɔlɔ ɛ. 'Yɔ̃ɔnɔ̃ a fʊ sãa nɩ a fʊ ma.” ");
INSERT INTO biv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ka wʊ 'yɛr, “Wiwile, n bile sɔ̃ɔ jaa lɛ n turo a Nɛɛ anyãna wa tãn a dɩna.” ");
INSERT INTO biv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu kaa naa a daba nɩ nʊ̃fʊ, tɩ 'yɛr kʊ wʊ, “A chɛ fʊn yelbʊ̃'yen. Kul tɩ da a fʊ bonsɩ a jaa de põ nɔ̃n dẽme, ala lɛ fʊn tara bʊ̃mãɛ a Nãaŋmɩn sɛ̃. Tɩ na fʊ pãa wa turo ma.” ");
INSERT INTO biv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A 'yɛr nyã vɛ̃ naa ka a daba sɔ̃ nie na wʊ kul pʊsɔ̃ɔ, bojũu tara sʊɔ lɛ wʊ ɩ. ");
INSERT INTO biv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Be lɛ ka a Yesu kaa gʊɔr na wʊ 'yɛr kʊ a wʊ poturbo, “A tara sʊɔ kpɛfʊ a Nãaŋmɩn nãalʊ̃ʊ pɔ ɩn kpɛ̃ɔ!” ");
INSERT INTO biv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A 'yɛrbie anyãna vɛ̃ naa ka ba nɛɛr 'maa, tɩchɛ ka wʊ lɛ 'yɛr go, “Bibiir, a ɩn kpɛ̃ɔ kʊ nɩrɛ jaa na na kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ! ");
INSERT INTO biv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","An ɩn kɔ̃mɔ̃kɔ̃mɔ̃, nyɔɔma na na kpɛ kparpĩi bɔɔ pɔ gar tara sʊɔ na na kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ka a poturbo pãa ɩ chĩcham, tɩ lɩɛb sʊrɔ taa, “An lɛ na pãa tʊ̃ɔ nyɛ faafʊ?” ");
INSERT INTO biv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ka a Yesu kaa ba tɩ 'yɛr, “Nɩrɛ sɛ̃ 'lɔ, a ɩn tuo, tɩchɛ Nãaŋmɩn sɛ̃ ba lɛ ɛ. Nãaŋmɩn sɛ̃ yele jaa ba ɩ tuo ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Be lɛ Pita 'yɛr kʊ wʊ, “Nyɛ, sɩn bar bon jaa tɩ wa turo fʊ!” ");
INSERT INTO biv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ka Yesu 'yɛr, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, nɩrɛ 'lɔ jaa na bar a wʊ yir bɩɩ yɛɛr, bɩɩ yɛpɔbɔ bɩɩ a wʊ sãa bɩɩ a wʊ ma, bɩɩ bibiir bɩɩ wɛr, tɩ 'la maa nɩ a 'yɛr nʊ̃ɔ nyã jũu, ");
INSERT INTO biv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wʊn nyɛn yɔɔ a dɩna. Wʊn nyɛn yie, yɛɛr, yɛpɔbɔ, mamɩne, bibiir nɩ wɛr dɔɔl gbɛɛ kɔbaa, nɩ a gefʊ! Tɩ a sɔ̃ɔ 'lɔ na waara, ka wʊ nyɛ nyɛvʊr na ba tara baarfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tɩchɛ a nɩyɔɔ bala na de nie na wa ben puor, ka a nɩyɔɔ bala na be a puor mɩ wa de a nie.” ");
INSERT INTO biv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ba dɔ̃ɔ de a sɔr duoro a Jerusalɛm ka Yesu de a nie, tɩ a wʊ poturbo nɛɛr 'maa ka bala mɩ na turo joro dãbãɛ. Wʊ tɔɔ naa a Pie Nɩ Ayi yin chɛ̃chɛ̃ 'yɛr kʊ ba a lɛn na wa a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yesu 'yɛr naa, “Sɩn chiine a Jerusalɛm tẽe pɔ, be lɛ ban tɩ de a Nɩsaal Bie kʊ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe, ka ba ɩka wʊ sɛɛn kũu, na ba nyɔɔ wʊ kʊ a nɩbɛ na ba ɩ a Juu nɩbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","A banyãna na la wʊ naa, na ba chɩr nataar 'yɔ̃ɔ wʊ, na ba fɔb wʊ tɩ kʊ wʊ. Ka a ber ata daar wʊn ir naa a kũu pɔ ɩ vʊr.” ");
INSERT INTO biv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Be lɛ a Jebedee bibiir Jemesɩ nɩ Jɔɔn tɔɔ gbʊr a Yesu na ba 'yɛr, “Wiwile, sɩ bʊɔrɔ na ɩka sɩ sʊɔr fʊ yele kɔ̃ɔ ka fʊ maal kʊ sɩ.” ");
INSERT INTO biv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ka a Yesu sʊʊr ba, “Bãa lɛ yɩ bʊɔrɔ ɩka n maal kʊ yɩ?” ");
INSERT INTO biv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ka ba 'yɛr, “Vɛ̃ ka a sɩ ãsʊɔ jãnɛ a fʊ nũsʊ̃ɔ loor, ka 'yen mɩ jãnɛ a fʊ gʊba loor a fʊ nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ka a Yesu 'yɛr kʊ ba, “Yaa bɔ̃ɔ a bon yɩn sʊɔrɔ ɛ. Yɩn tʊ̃ɔ nyũn a dɔɔyɛ ŋmele 'lɔ ɩn wa nyũn, bɩɩ kpɛ a dɔɔyɛ 'lɔ pɔ ɩn wa kpɛ a Nãaŋmɩn kʊ̃ɔ sofʊ kaar ɔ?” ");
INSERT INTO biv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ka a ba 'yɛr, “Ɔ̃ɔ.” Ka a Yesu 'yɛr, “Yɩn nyũn a ŋmele 'lɔ ɩn na nyũn, na yɩ so a kʊ̃ɔ 'lɔ ɩn na so, ");
INSERT INTO biv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","tɩchɛ a n nũsʊ̃ɔ loor nɩ a n gʊba loor 'lɔ n ba tara sɔr ɩka n kʊ yɩ ɛ. Nãaŋmɩn tɛɛ lɛ tara sɔr ɩka wʊ de a jiir anyãna kʊ a bala wʊn chɔɔr.” ");
INSERT INTO biv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","A poturbo pie bala na chɛ na wa wõ a yele, ba nyɛn suur 'yɔ̃ɔ a Jemesɩ nɩ a Jɔɔn. ");
INSERT INTO biv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ka a Yesu bʊɔl ba jaa 'mataa tɩ na wʊ 'yɛr kʊ ba, “Yɩ bɔ̃ɔn naa a bala na ɩ a nãmɩne a bala na ba ɩ a Juu nɩbɛ ɛ, ma fɩrɛ naa a nɩbɛ, ka a nɩbɛrɛ ma wile a ba kpãɛn. ");
INSERT INTO biv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","A ba ɩ lɛ lɛ a yɩ sɛ̃ ɛ. Nɩrɛ 'lɔ jaa na bʊɔrɔ ɩka wʊ ɩ a yɩ nɩkpɛ̃ɛ, wʊ ɩ a yɩ jaa tʊ̃tʊ̃nɔ̃, ");
INSERT INTO biv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ka a 'lɔ mɩ na bʊɔrɔ ɩka wʊ ɩ a nɩdiere, wʊ ɩ a yɩ jaa gbãgbaa. ");
INSERT INTO biv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","A Nɩsaal Bie mɩ gba ba wa, ɩka ba wa tʊ̃nɔ̃ kʊrɔ wʊ ɛ, tɩchɛ wʊ wa naa ɩka wʊ wa tʊ̃ kʊ ba, na wʊ de a wʊ nyɛvʊr lɩɛ faan nɩyɔɔ.” ");
INSERT INTO biv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ba pãa wa naa a Jeriko. Ban wa kpɛ a Jeriko tɩ yire, nɩyɔɔ turo naa Yesu nɩ a wʊ poturbo, ka a jɔ̃ɔ kɔ̃ɔ ban bʊɔlɔ Batimayus, Timeyus bidaba, jãnɛ a sɔr kõkoor sʊɔrɔ bomo. ");
INSERT INTO biv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wʊn wa wõ ka a Yesu na yi a Najaretɩ lɛ, ka wʊ piel gboolo, “Yesu, David Bie, kaa n nɩbaal!” ");
INSERT INTO biv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ka a nɩbɛ bamɩne ɩka wʊ pɔɔ a nɛɛ, tɩchɛ ka wʊ pãa chɛnɛ mal gboolo, “David Bie, kaa n nɩbaal!” ");
INSERT INTO biv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Be lɛ a Yesu tɛɛ ara tɩ 'yɛr, “Yɩ bʊɔl wʊ.” Ka ba bʊɔl a jɔ̃ɔ 'yɛr wʊ, “'Maa nyãa! Ir ara, wʊ bʊɔlɔ fʊ naa.” ");
INSERT INTO biv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ka wʊ vaa ir lɔb a fɔbaa bar tɩ wa a Yesu sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ka a Yesu sʊʊr wʊ, “Bãa fʊ bʊɔrɔ ɩka n maal kʊ fʊ?” Ka wʊ 'yɛr, “Wiwile, n bʊɔrɔ naa ɩka n nyɛrɛ.” ");
INSERT INTO biv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ka a Yesu 'yɛr, “Chiine! Fʊ sa naa, fʊn sɔɔ ma jũu.” Ajienaa, wʊ nyɛrɛ naa, na wʊ turo a Yesu ka ba de a sɔr. ");
INSERT INTO biv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","A lɛ ban wa gbʊrɔ a Jerusalɛm, ba ta naa a tẽn ayi, Betefagɩ nɩ Betanɩ na be a Olive tɔ̃ɔ par, ka Yesu tʊ̃ wʊ poturbo ayi. ");
INSERT INTO biv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Wʊ 'yɛr kʊ ba, “Yɩ chen a tẽbile 'lɔ na be a yɩ niem, Yɩn wa kpɩɛrɛ a tẽe pɔ, yɩn nyɛn bʊ̃bile nɩrɛ jaa na ba do wʊ sɛrɛ ɛ, ban lũ. Yɩ for waan. ");
INSERT INTO biv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ka nɩrɛ wa sʊʊr yɩ ɩka bãa lɛ yɩ ɩrɛ a lɛ, yɩ 'yɛr wʊ ɩka, a yɩ Soro lɛ bʊɔrɔ wʊ, tɩ wʊn lɩɛb waan fɔɔ.” ");
INSERT INTO biv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ba chen tɩ nyɛ a bʊ̃bile ban lũ a yõo dɔ̃dɔr nɛɛ. Ban wa foro, ");
INSERT INTO biv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nɩbɛ bamɩne na ara a be sʊʊr ba naa, “Bãa lɛ yɩ foro a bʊ̃bile ɩrɛ nɩ?” ");
INSERT INTO biv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ka ba 'yɛr a lɛ a Yesu na ɩka ba 'yɛr, ka a nɩbɛ bar ba. ");
INSERT INTO biv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Be lɛ ba waan a bʊ̃bile wa kʊ a Yesu, na ba de a ba fɔɔr 'yɩɛr dɔɔl a bʊ̃bile ju, ka wʊ do jãnɛ. ");
INSERT INTO biv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nɩyɔɔ na bʊɔrɔ ɩka ba 'yɔ̃ɔ a Yesu jũu, ba den fɔɔr 'yɩɛr a sɔr pɔ, ka bamɩne mɩ kar vaɩ a por pɔ wa 'yɩɛr a sɔr pɔ. ");
INSERT INTO biv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ka a bala na be a niem nɩ a bala na be a puor, pãa chɩlɛ gɔ̃nɔ̃ 'yɛrɛ, “Yãan yooo! Nãaŋmɩn wʊ sʊ̃ʊ a 'lɔ wʊn tʊ̃! ");
INSERT INTO biv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nãaŋmɩn wʊ sʊ̃ʊ a sɩ sãa David nãalʊ̃ʊ na waara! Yãan yooo! Sɩ dãn Nãaŋmɩn yɔɔ jaa!” ");
INSERT INTO biv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu na wa ta a Jerusalɛm, wʊ chen tɩ kpɛ a Nãaŋmɩn Puorfʊ Yir kaa a bomo a jaa. A wɛr na sɔɔrɔ jũu, 'lɔ nɩ a wʊ poturbo pie nɩ ayi yin chen a Betanɩ. ");
INSERT INTO biv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A wɛr na wa chaar ka a Yesu nɩ a wʊ poturbo lɩɛb yi a Betanɩ waara a Jerusalɛm, kɔ̃ kpɛ naa a Yesu. ");
INSERT INTO biv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Be lɛ wʊ nyɛ a kɔ̃kɔ̃ɔ tɩɛ na tɔ vaar ara a niem, ka wʊ chen ɩka wʊ tɩ kaa wɔ̃mɔ̃ ben be bɩɩ. Wʊ chen tɩ ta ka a ɩ wɔ̃mɔ̃ ba be be ɛ, vaar tɛɛ lɛ, bojũu a ba ɩ a wɔ̃mɔ̃ sɔ̃ɔ lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ka a Yesu 'yɛr kʊ a tɩɛ, “Nɩrɛ jaa kʊ̃ lɛ wa pɔr a fʊ wɔ̃mɔ̃ di ɛ.” A wʊ poturbo wõ naa a lɛ wʊn 'yɛr. ");
INSERT INTO biv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ban wa ta a Jerusalɛm, Yesu chen tɩ kpɛ a Nãaŋmɩn Puorfʊ Yir bɛchaar pɔ dire a nɩbɛ bala na chiin a bonsɩ tɩ daara nɩ a bala na daara. Wʊ daa naa libitɛɛrbɛ tɛɛbʊlsɩ lɩɛb kpa, tɩ da a bala mɩ na daara a papasɩ dakɔɔr lɔb. ");
INSERT INTO biv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Waa sɔɔ ka a nɩrɛ jaa tuo bon jaa tun a bɛchaar 'lɔ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Be lɛ ka wʊ pãa wile ba na wʊ 'yɛr, “A Nãaŋmɩn 'yɛr naa a wʊ gãn pɔ, ‘N yir ɩ naa a yir a nɩbʊrɔ ba jaa na wa puor ma,’ tɩchɛ ka a yɩn 'lɔ maal wʊ a nɩfarba jie.” ");
INSERT INTO biv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ka a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe nɩ wa wõ a nɩtɔ̃ bʊɔrɔ sɔr 'lɔ ban tu kʊ wʊ, tɩ na ba joro wʊ dãbãɛ bojũu a nɩyɔɔ nɛɛr 'maa ba naa a wʊ wiilfʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","A jãanʊɔr na wa ta, Yesu nɩ a wʊ poturo lɩɛb chen a Betanɩ. ");
INSERT INTO biv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","A wɛr na wa chaar bibio ka ba lɩɛb chiine a Jerusalɛm, ba nyɛ naa ka ɩ a kɔ̃kɔ̃tɩɛ na kpi lɔ̃ɔn a nyɩbɛ. ");
INSERT INTO biv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Be lɛ ka a Pita tɩɛr a lɛ a Yesu na 'yɛr kʊ a tɩɛ, na wʊ 'yɛr kʊ wʊ, “Wiwile, nyɛ a tɩɛ 'lɔ fʊn pɔ 'yɔ̃ɔ! Wʊ kpi naa!” ");
INSERT INTO biv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ka a Yesu 'yɛr kʊ ba, “Yɩ sɔɔ de Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sɩrɛ lɛ n 'yɛrɛ kʊrɔ yɩ, ala ɩ yɩ ãsʊɔ sɔɔ naa de Nãaŋmɩn na waa baala a wʊ tɩɛr pɔ ɛ, 'lɔ gba na tʊ̃ɔ 'yɛr kʊ a tɔ̃ɔ nyãna, ‘Ir tɩ lo a man pɔ,’ a Nãaŋmɩn na sɔɔ naa ka a lɛ ɩ. ");
INSERT INTO biv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ala lɛ n 'yɛrɛ kʊrɔ yɩ, fʊ̃ʊ puor Nãaŋmɩn sʊɔr bon jaa tɩ sɔɔ ɩka, wʊn ɩn kʊ fʊ, wʊn ɩ naa. ");
INSERT INTO biv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Fʊ̃ʊ wa ɩka fʊ puor, tɩ tara nɩrɛ nɩ 'yɛr, vɛ̃ kʊ a nɩnyɩnɛ. A fʊ Sãa na be a saaju mɩ na vɛ̃ naa a fʊ yelbier kʊ fʊ.” ");
INSERT INTO biv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ba lɛ wa naa a Jerusalɛm go, ka a Yesu tɩ kpɛ yʊɔrɔ a Nãaŋmɩn Puorfʊ Yir bɛchaar pɔ. A Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe nɩ a nɩbɛrɛ wa naa a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ba wa sʊʊr wʊ naa, “An lɛ kʊ fʊ a sɔr ka fʊ tʊ̃nɔ̃ nɩ a anyã? Fʊ tara naa a sɔr ɩka fʊ tʊ̃nɔ̃ nɩ a anyã ɔ?” ");
INSERT INTO biv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ka a Yesu 'yɛr kʊ ba, “N sʊʊr yɩ sʊʊrfʊ bʊ̃'yen. Yɩn wa tʊ̃ɔ wiil ma a par, n mɩ na wiil yɩ naa a nɩrɛ 'lɔ na kʊ ma a sɔr ka n tʊ̃nɔ̃ nɩ a anyã. ");
INSERT INTO biv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jɔɔn na dɔ̃ɔ suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ, Nãaŋmɩn lɛ kʊ wʊ a sɔr bɩɩ, nɩbɛ lɛ kʊ wʊ a sɔr? Yɩ 'yɛr n kaa!” ");
INSERT INTO biv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A ba lɩɛb chɩrɛ taa, “Sɩn be 'yɛr ɩka Nãaŋmɩn lɛ tʊ̃ wʊ, wʊn sʊʊr sɩ naa, ka bo lɛ so ka saa sɔɔ wʊ ɛ? ");
INSERT INTO biv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tɩchɛ sɩn mɩ 'yɛr ɩka nɩrɛ lɛ tʊ̃ wʊ, a ba ɩ ɛ.” Ba joro naa a nɩbɛ dãbãɛ, bojũu nɩrɛ jaa sɔɔ naa ɩka a Jɔɔn ɩn Nãaŋmɩn 'yɛ'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Lɛ lɛ ba 'yɛr kʊ a Yesu, “Saa bɔ̃ɔ ɛ.” Ka a Yesu mɩ 'yɛr kʊ ba, “N mɩ kʊ̃ 'yɛr kʊ yɩ a nɩrɛ 'lɔ na kʊ ma a sɔr ka n tʊ̃nɔ̃ nɩ a anyãna ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ka a Yesu lɛ piel 'yɛrɛ kʊrɔ ba nɩ sʊkpa. Wʊ 'yɛr naa, “Daba lɛ kɔ wʊ puo na wʊ bʊr tɩwɔ̃nsɩ. Wʊ wɔɔ naa a puo wʊ jaa jilʊ̃, na wʊ tuu bɔɔ ka ban ma pɔr a wɔ̃mɔ̃ 'yɔ̃ɔ na ba nɛŋmɛr ir a kʊ̃ɔ. Wʊ mɛn jie ãsʊɔ na do ka nɩrɛ na ma do jɛ̃ a be kaara a puo. Wʊ de naa a puo na wʊ kʊ nɩbɛ ɩka ba kaara tɩ na wʊ yɔ chen paal yuo pɔ. ");
INSERT INTO biv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","A wɔ̃fʊ sɔ̃ɔ wa ta naa ka wʊ tʊ̃ a wʊ gbãgbaa ãsʊɔ ɩka wʊ chen a nɩbɛ bala sɛ̃ tɩ de a wɔ̃mɔ̃ amɩne. ");
INSERT INTO biv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tɩchɛ ka ba nyɔɔ wʊ ŋme bar ka wʊ kul nũjaal. ");
INSERT INTO biv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Be lɛ wʊ lɛ tʊ̃ a gbãgbaa ãsʊɔ ka ba lɛ ŋme wʊ a ju puo tɩ 'yɔ̃ɔ wʊ vĩ. ");
INSERT INTO biv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wʊ lɛ tʊ̃n ãsʊɔ ka ba kʊ a 'lɔ. Ka wʊ lɛ bɔ̃ɔ tʊ̃ bamɩne, ka ba pɔb bamɩne tɩ kʊ a bamɩne. ");
INSERT INTO biv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Wʊ chen nɩbʊ̃'yen wʊn na tʊ̃, 'lɔ lɛ a wʊ bibʊ̃'yen wʊn nʊ̃. 'Lɔ lɛ wʊ wa tʊ̃ a baaraa jaa na wʊ 'yɛr, ‘Ban 'yɔ̃ɔ naa a n bie.’ ");
INSERT INTO biv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Tɩchɛ a pokaarba na wa nyɛ a bie, ba 'yɛr kʊ taa, ‘A nyã lɛ ɩ a bʊ̃dire! Yɩ ɩ a sɩ kʊ wʊ, tɩ chɛ ka a bonsɩ ɩ a sɩ sofʊ.’ ");
INSERT INTO biv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Be lɛ ba nyɔɔ wʊ kʊ lɔb bar a puo kõkoor. ");
INSERT INTO biv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ŋmɩnɛ lɛ yɩ tɩɛr ɩka a puo sʊɔ na ɩ naa? Wʊn wan wa kʊ a pokaarba banyãna ba jaa tɩ de a puo kʊ nɩyor! ");
INSERT INTO biv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yaa kar a jie nyã a Nãaŋmɩn gãn pɔ ɛ? Wʊ 'yɛr ɩka, ‘A kʊsɩr 'lɔ a mɩmɩɛrbɛ na tɔr bar lɛ ɩ a kʊsɩr ju. ");
INSERT INTO biv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A sɩ Soro lɛ tʊ̃ a nɩtɔ̃ ka sɔb sɩ a nɩbie.’ ” ");
INSERT INTO biv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Be lɛ a Juu nɩbɛrɛ bʊɔrɔ sɔr ɩka ba nyɔɔ a Yesu, bojũu ba bɔ̃ɔ naa ɩka bala lɛ wʊ lɔb a sʊkpa gbɛb. Tɩchɛ ba joro naa a nɩyɔɔ bala dãbãɛ, na ba bar wʊ tɩ lɩɛb chen. ");
INSERT INTO biv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ba lɛ tʊ̃ naa a Faraseemɩne bamɩne nɩ nɩbɛ bamɩne na yi a nãa Hɛrɔd sɛ̃, ka ba wa bɛr Yesu nɛɛ nyɔɔ wʊ, a wʊ 'yɛrbie pɔ. ");
INSERT INTO biv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ba wa na wa 'yɛr kʊ wʊ, “Wiwile, sɩ bɔ̃ɔ naa ɩka fʊ ɩn yelmãɛ sʊɔ. Nɩbɛ 'yɛrbie maa tʊ̃ɔ a fʊ pʊtɩɛr lɩɛb ɛ, bojũu fʊ maa chɛlɛ a lɛ nɩrɛ jaa na be ɛ. Tɩchɛ fʊ wile na a Nãaŋmɩn sɔr nɩ yelmãɛ. A tara naa sɔr ɩka sɩ yab a lõpo kʊ a nãkpɛ̃ɛ Siisa bɩɩ? ");
INSERT INTO biv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sɩ yab bɩɩ sɩ ta yab ɛ?” Tɩchɛ ka a Yesu bɔ̃ɔn a ba nɛbɛr yele ban waan, na wʊ sʊʊr ba, “Bo lɛ yɩ bʊɔrɔ ɩka yɩ bɛɛr ma kaa? Yɩ de a libir ãsʊɔ waan ka n kaa.” ");
INSERT INTO biv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Be lɛ ba de a libir kur ãsʊɔ waan, ka wʊ sʊʊr ba, “An foto nɩ a yuor lɛ be a libir pɔ?” Ka ba 'yɛr, “Siisa lɛ.” ");
INSERT INTO biv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Lɛ lɛ ka Yesu 'yɛr kʊ ba, “Yɩ de a 'lɔ na ɩ a Siisa sofʊ na yɩ yab wʊ, na yɩ mɩ de a 'lɔ na ɩ a Nãaŋmɩn sofʊ na yɩ mɩ kʊ a Nãaŋmɩn.” Ka ba faa tɩ nyɔɔr a nɛɛr ara nɩ. ");
INSERT INTO biv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","A nɩbɛ bamɩne ban bʊɔlɔ a Saduseemɩne na 'yɛr ɩka kũu pɔ irfʊ ba be be ɛ, mɩ wa naa wa sʊʊr wʊ, ");
INSERT INTO biv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Wiwile, Mosesɩ sɛb kʊ sɩ ɩka nɩrɛ yɛbɛ wa kpi tɩ bar pɔɔ na ba tara bie ɛ, a wʊ yɛbɛ wʊ kul a pɔɔkʊɔr 'lɔ na wʊ dɔɔ bibiir kʊ a wʊ yɛbɛ 'lɔ na kpi. ");
INSERT INTO biv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yɛɛr ayopõi lɛ dɔ̃ɔ be be, ka ba kpɛ̃ɛ kul pɔɔ kpi tɩ chɛ bar, waa tara bie ɛ. ");
INSERT INTO biv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ka a wʊ turo de a pɔɔkʊɔr kul, baa mɩ dɔɔ bie ɛ, tɩchɛ ka wʊ mɩ kpi. A lɛ nɛ nɩ wʊ ju mɩ lɛ a turo ata sʊɔ. ");
INSERT INTO biv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Yelmãɛ jaa a yɛɛr ayopõi banyãna ba jaa kulnaa a pɔɔ 'lɔ̃nɔ̃, tɩ waa dɔɔ bie ɛ, a baaraa jaa ka a pɔɔ mɩ kpi. ");
INSERT INTO biv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bala wa ir yi a kũu pɔ, an pɔɔ lɛ wʊn ɩ, an ɩ ba jaa kul wʊn lʊɔr taa?” ");
INSERT INTO biv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ka a Yesu 'yɛr, “Yaa nyɛ yɩn bɔr, bojũu yaa bɔ̃ɔ a Nãaŋmɩn sɛbɛ nɩ a wʊ kpɛ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nɩbɛ wa ir a kũu pɔ ba kʊ̃ lɛ kul taa ɛ, tɩ ban kaara naa fɩka a malakasɩ, baa kulo taa ɛ. ");
INSERT INTO biv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A kũu pɔ irfʊ yele yɩ kar a Mosesɩ gãn pɔ a sɔ̃ɔ 'lɔ wʊn nyɛ a tɩbile na 'lɩrɛ bũu, ka a Nãaŋmɩn 'yɛr kʊ wʊ, ‘N ɩ naa a Abraham Nãaŋmɩn nɩ a Isaakɩ Nãaŋmɩn nɩ a Jekɔb Nãaŋmɩn.’ ");
INSERT INTO biv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wʊ ɩ naa vʊr Nãaŋmɩn, waa ɩ kũn Nãaŋmɩn ɛ. Yɩ tul naa.” ");
INSERT INTO biv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","A Mosesɩ Nɛɛ wile ãsʊɔ wa ara na chɛl a lɛ a Yesu nɩ a nɩbɛ na 'mataa 'yɛrɛ. Ka wʊ nyɛ ka a Yesu 'yɛr nʊ̃mɔ̃. Ka wʊ mɩ sʊʊr a Yesu, “A Nãaŋmɩn nɛɛr a jaa pɔ, buor sʊɔ lɛ ɩ kpɛ̃ɛ?” ");
INSERT INTO biv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ka Yesu 'yɛr kʊ wʊ, “A 'lɔ na ɩ kpɛ̃ɛ gar a jaa nɩ nyã, ‘A Isɩral nɩbɛ, yɩ chɛlɛ! A sɩ Soro Nãaŋmɩn, wʊ ɩ naa Soro bʊ̃'yen tɛɛ. ");
INSERT INTO biv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nʊ̃ a fʊ Soro Nãaŋmɩn nɩ a fʊ nyãa, nɩ a fʊ nyɛvʊr wʊ jaa, nɩ a fʊ tɩɛr wʊ jaa, nɩ a fʊ kpɛ̃ɔ wʊ jaa.’ ");
INSERT INTO biv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A 'lɔ na tu nɩ nyã, ‘Nʊ̃ a fʊ tɔ sʊɔ nɩtãa lɛ fʊn nʊ̃ a fʊ mãɛ.’ Nɛɛ jaa ba be be ɩ kpɛ gar a anyã ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ka a daba 'yɛr, “Wiwile, fʊ 'yɛr yelmãɛ, a lɛ fʊn 'yɛr ɩka Nãaŋmɩn bʊ̃'yen tɛɛ lɛ be be, ka ãsʊɔ jaa ba lɛ be be pʊɔ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A fʊ nʊ̃ wʊ nɩ a fʊ nyãa, nɩ a fʊ tɩɛr wʊ jaa, nɩ a fʊ kpɛ̃ɔ wʊ jaa, na fʊ lɛ nʊ̃ a fʊ tɔ sʊɔ nɩtãa a fʊ mãɛ, a yele anyãna tufʊ ɩn gar dʊ̃n fʊn kʊ chʊm kʊ Nãaŋmɩn nɩ bɔɔrlorsɩ a jaa.” ");
INSERT INTO biv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu na nyɛ a lɛ a daba na 'yɛr nɩ yɛ̃ ka wʊ 'yɛr kʊ wʊ, “Faa jãa nɩ a Nãaŋmɩn nãalʊ̃ʊ ɛ.” An yi a be chiine nɩrɛ jaa ba lɛ 'la sʊʊr wʊ sʊʊrfʊ go ɛ. ");
INSERT INTO biv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","A lɛ a Yesu na wile a Puorfʊ Yir bɛchaar pɔ, wʊ sʊʊr naa a nɩbɛ, “Ŋmɩnɛ lɛ a ta ka a Mosesɩ Nɛɛ wiwiilbe 'yɛr ɩka David bie lɛ a Nɩ-iraa? ");
INSERT INTO biv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","A ba ɩ a David mãɛ pɔ lɛ a Nãaŋmɩn Sɩɛ, ka wʊ 'yɛr ɩka, ‘A n Soro Nãaŋmɩn 'yɛr kʊ a n Soro nyã wʊn ir, “Jãnɛ a n nũsʊ̃ɔ loor ka n wa de a fʊ dɔ̃dẽme bin a fʊ gbɛɛ pĩlem.” ’ ");
INSERT INTO biv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ala ɩ David mãɛ bʊɔl wʊ naa a wʊ Soro, ŋmɩnɛ lɛ wʊn lɛ ɩ a wʊ bie tɛɛ?” Ka a nɩyɔɔ bala ara chɛlɛ wʊ nɩ pʊpɛl. ");
INSERT INTO biv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu wile naa tɩ na wʊ kpãa ba, “Yɩ gu yɩ mãɛ a Mosesɩ Nɛɛ wiwiilbe sɛ̃, ba ma su naa a fuu vɛɛsɩ ala yʊɔrɔ ɩka ba puor ba a dar pɔ. ");
INSERT INTO biv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bala be wa kpɛ a lɔ̃ɔfʊ jie, a niem lɛ ba ma jãnɛ. ");
INSERT INTO biv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ba mɩ ma fɔlɔ naa a pɔɔkɔɛ, na ba mɩ ma puor Nãaŋmɩn kor, bʊɔrɔ ɩka nɩbɛ ba kaara ba. A nɩbɛ banyãna 'yɛr tɔɔrfʊ na kpɛ̃mɛ naa.” ");
INSERT INTO biv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu jɛ̃n gbʊr a jie ban 'yɔ̃ɔnɔ̃ a libie a Nãaŋmɩn Puorfʊ Yir pɔ, na wa kaara a lɛ a nɩyɔɔ na 'yɔ̃ɔnɔ̃ a ba libie. Taraa dẽme yɔɔ jaa lɔɔrɔ naa yɔɔ. ");
INSERT INTO biv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Be lɛ ka a pɔɔkɔnɔ̃ɔ sʊɔ mɩ be be na wʊ mɩ waan libikue ayi na ɩ kobo wa 'yɔ̃ɔ a libie pɔ. ");
INSERT INTO biv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ka Yesu bʊɔl a wʊ poturbo ka ba tɔɔ gbʊr wʊ ka wʊ 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, a pɔɔkɔnɔ̃ɔ sʊɔ nyã lɔb gar ba jaa. ");
INSERT INTO biv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","A tara dẽme ma 'yɔ̃ɔn tɩ chɛ a libiyɔɔ amɩne, tɩchɛ a pɔɔkɔnɔ̃ɔ sʊɔ nyã 'lɔ, a jaa lɛ wʊ de 'yɔ̃ɔ. Waa lɛ tara bon jaa go ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu na wa yire a Nãaŋmɩn Puorfʊ Yir pɔ, a wʊ poturo ãsʊɔ 'yɛr kʊ wʊ, “Wiwile, nyɛ a kʊsɩbɛ ban mɛn a yir kpɛ̃ɛ nyã ka wʊ kaara ka!” ");
INSERT INTO biv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ka a Yesu 'yɛr sɔɔ wʊ, “Mɩ fʊ nyɛ naa a lɛ ban mɛ a yir kpɛ̃ɛ nyãna? A kʊsɩvɩɛl anyãna 'yen jaa kʊ̃ lɛ wa chɛnɛ dɔɔl wʊ tɔ ju ɛ. Ban dãn a jaa lɔb.” ");
INSERT INTO biv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu na wa jãnɛ a Olive Tɩɩr Tɔ̃ɔ ju, a Nãaŋmɩn Puorfʊ Yir nidaa, Pita nɩ Jemesɩ nɩ Jɔɔn nɩ Andiru sʊʊr wʊ naa a ba tɛɛ, ");
INSERT INTO biv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“'Yɛr kʊ sɩ a daar 'lɔ a anyã na ɩ. Bo lɛ na ɩ a jãnɛ sɛrɛ tɩ chɛ ka a wa ɩ?” ");
INSERT INTO biv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ka a Yesu 'yɛr kʊ ba, “Yɩ bɔ̃ɔn ka nɩrɛ jaa ta wa bɛl yɩ ɛ! ");
INSERT INTO biv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nɩyɔɔ na de naa maa yuor waan wa 'yɛrɛ, ‘Maa lɛ a Yesu,’ na ba wa bɛlɛ nɩyɔɔ. ");
INSERT INTO biv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yɩn wa wõn tam, ka ba 'yɛrɛ a tam 'yɛr, yɩ taa mɩrɛ ɛ. A lɛ na ɩ naa, tɩchɛ a wɛr baarfʊ chɛnɛ na be puor. ");
INSERT INTO biv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nɩbʊr dẽdẽme na yin tam, ka a nãmɩne mɩ yi tam. Ka a tẽgãn dɔ̃ɔnɔ̃ jiir yɔɔ, ka kɔ̃ mɩ lo. A dɔɔyɛ anyãna lɛ ɩ a pielfʊ. ");
INSERT INTO biv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Yɩ bɔ̃ɔn, ɩka ban ma nyɔɔr yɩn chiin a 'yɛr tɔɔrfʊ jie, na ba lɛ pɔb yɩ, a lɔ̃ɔfʊ jiir. A maa yɩn sɔɔ jũu, ban tara yɩn chiin a tẽe nɩbɛrɛ nɩ a nãmɩne jie, ɩka ba tɩ tɔɔr a yɩ 'yɛr, tɩ yɩn tu naa a be 'yɛr a Nãaŋmɩn 'yɛr nʊ̃ɔ kʊ ba. ");
INSERT INTO biv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","A 'yɛr nʊ̃ɔ nyã na den nie ta a nɩbʊrɔ ba jaa. ");
INSERT INTO biv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bala wa nyɔɔr yɩ chiin a 'yɛr tɔɔrfʊ jie, yɩ ta vɛ̃ ka tɩɛr nyɔɔ yɩ a lɛ yɩn tɩ 'yɛr ɛ. Lɛ jaa a Nãaŋmɩn na wiil yɩ a 'yɛr tɔɔrfʊ sɔ̃ɔ, 'yɛr wʊ. A ba ɩ yɩn lɛ 'yɛr ɛ, tɩchɛ a 'yɛrbie yi naa a Nãaŋmɩn Sɩɛ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Yɛbɛ na gar 'yɔ̃ɔ yɛbɛ, ka ba kʊ wʊ, ka a sãa mɩ gar 'yɔ̃ɔ bie, ka ba kʊ wʊ. Bibiir kʊ̃ lɛ wõnõ a ba sãamɩne toor ɛ, na ba vɛ̃ ka ba kʊ a ba sãamɩne. ");
INSERT INTO biv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nɩrɛ jaa na 'laar yɩ naa, yɩn sɔɔ ma jũu, tɩ 'lɔ na sɔɔ tɩ ta a baaraa, na nyɛn Nãaŋmɩn faafʊ. ");
INSERT INTO biv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Yɩn nyɛ naa a yele 'lɔ a Nãaŋmɩn na 'laar na be a jie 'lɔ an ba sɛɛ ɛ, na wʊ sɔ̃ɔ a jie, na wʊ vɛ̃ ka a wʊ suur dire. A fʊ̃ʊ nyã na kara bɔ̃ɔ a par. Yɩn wa nyɛ a lɛ, nɩbɛ na be a Judiya ba jo do a tɔ̃ɔ ju. ");
INSERT INTO biv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nɩrɛ jaa na be gar ju, ta suu a die pɔ tɩ de bon jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","'Lɔ mɩ na be a puo pɔ, ta lɛ chen tɩ de a wʊ fɔbaa ɛ. ");
INSERT INTO biv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","A bɩbir nyãna an ɩn tuo kʊ a pɔɔpʊʊr nɩ a bala na tara a bi'yɛnsɩ. ");
INSERT INTO biv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yɩ sʊɔrɔ Nãaŋmɩn ka a ta wa ɩ uon ɛ. ");
INSERT INTO biv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","A ber ala pɔ, nɩbɛ na din dɔɔyɛ yɔɔ. Nãaŋmɩn na maal a wɛr baa di a dɔɔyɛ nyã bʊrɔ ɛ, tɩ ba mɩ kʊ̃ lɛ wa di wʊ go ɛ. ");
INSERT INTO biv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ala ɩ a Nãaŋmɩn ba ŋmaa a ber ala bar ɛ, nɩrɛ jaa kʊ̃ chɛ ɛ. Tɩchɛ a bala wʊn chɛl ir jũu, wʊ ŋmaan bar. ");
INSERT INTO biv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","A sɔ̃ɔ 'lɔ̃nɔ̃, nɩrɛ wa 'yɛr kʊ yɩ ɩka yɩ nyɛ a Nɩ-iraa a ka, bɩɩ kasɛn lɛ wʊ be, yɩ taa sɔɔrɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bojũu a jire Nɩ-iraa nɩ a jire 'yɛ'yɛrbɛ na wa na wa tʊ̃nɔ̃ a lɛ a nɩbɛ na ba dɔ̃ɔ nyɛ ɛ, na ba maala yelbɛrɛ fɩka Nãaŋmɩn lɛ kʊ ba a kpɛ̃ɔ. Na ba bʊɔrɔ ɩka ba bɛl a bala a Nãaŋmɩn na chɛl ir, ala ɩ ban tʊ̃ɔ naa. ");
INSERT INTO biv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yɩ bɔ̃ɔn! N den nie 'yɛr kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Tɩchɛ a dɔɔyɛ nyã baarfʊ sɔ̃ɔ, ‘Mɔ̃tɔ̃ɔ na lii naa, ka a ŋmɛraa kʊ̃ mɩ lɛ chaar ɛ, ");
INSERT INTO biv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ka a ŋmɛrbie pɔrɔ yire a saaju loro, tɩ a saaju wʊ jaa dɔ̃ɔnɔ̃.’ ");
INSERT INTO biv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“A sɔ̃ɔ 'lɔ̃nɔ̃, ban nyɛn a Nɩsaal Bie na waara a julõjuur pɔ, nɩ kpɛ̃ɔ nɩ tɩɩr. ");
INSERT INTO biv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wʊn tʊ̃ naa a wʊ malakasɩ, ka ba wa lɔ̃ɔ taa a bala wʊn chɛl ir a wɛr wʊ jaa, tɩ yin a mɔ̃tɔ̃ɔ purfʊ jie tɩ tɔ a mʊrfʊ jie. ");
INSERT INTO biv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Yɩ de a pɔlpɔl tɩɛ yele jãn yɛ̃. 'Lɔ wa tʊɔrɔ a vaar yɩ bɔ̃ɔn ɩka a tʊl sɔ̃ɔ gbʊr naa. ");
INSERT INTO biv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","A lɛ mɩ nɩ wʊ ju lɛ, yɩn wa nyɛ a lɛ n 'yɛr kʊ yɩ na ɩrɛ, yɩ bɔ̃ɔn ɩka a sɔ̃ɔ gbʊr naa jaa yɛ̃yɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","N 'yɛrɛ naa yelmãɛ kʊrɔ yɩ, ɩka a pʊ̃pãanyã nɩbɛ kʊ̃ kpi baar ɛ, tɩ yɩ nyɛ a yele anyãna ka a ɩ. ");
INSERT INTO biv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A saaju nɩ a wɛr na wa baar naa tɩchɛ maa 'yɛrbie dɔ̃ɔ kʊ̃ wa baar ɛ. ");
INSERT INTO biv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nɩrɛ jaa ba bɔ̃ɔ a bɩbir nyã ɛ, bɩɩ a sɔ̃ɔ ɛ, a malakasɩ gba na be a saaju ba bɔ̃ɔ ɛ, a Bie mɩ ba bɔ̃ɔ ɛ, a Sãa tɛɛ lɛ bɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yɩ gu yɩ mãɛ vɩla! Yɩ kaar sʊ̃! Yaa bɔ̃ɔ a sɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","An kaar naa fɩka yir sʊɔ na wa yʊɔrɔ tɩ de a wʊ yir 'yɔ̃ɔ a wʊ tʊ̃tʊ̃nbɔ nuur pɔ, na wʊ kʊ ãsʊɔ jaa nɩ wʊ tʊ̃mɔ̃, tɩ mɩ 'yɛr kʊ a dɔ̃dɔr guro ka wʊ kaara. ");
INSERT INTO biv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","A lɛ jũu yɩ kaara tɩ guro wʊ, bojũu yaa bɔ̃ɔ a sɔ̃ɔ 'lɔ a yir sʊɔ na na lɩɛb wa ɛ. Amɩne kɔ̃ɔ a wa ɩ jãanʊɔr, bɩɩ tãsɔɔ bãɩn, bɩɩ nɔrsɩ na kõnõ, bɩɩ bibio pipi. ");
INSERT INTO biv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yɩ ta wa vɛ̃ ka wʊ wa dũu yɩ a yɩ be gʊ̃ɔ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A lɛ n 'yɛr kʊ yɩ, nɩrɛ jaa lɛ n 'yɛr kʊ yɩ kaar sʊ̃!” ");
INSERT INTO biv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A chen ber ayi ka ban di a Gõl Bar Difʊ nɩ a Paanʊ̃kõo Lɔ̃ɔfʊ, ka a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe bʊɔrɔ vuo 'lɔ ban na tu sɔɔl nyɔɔ a Yesu kʊ. ");
INSERT INTO biv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tɩchɛ ka ba 'yɛr, “A ta ɩ a lɔ̃ɔfʊ sɔ̃ɔ ɛ, ka a jɛɛr taa ir a chara pɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu na wa be a Betanɩ a Simon 'lɔ na dɔ̃ɔ ɩ a kɔ̃kɔn yir, ka ba 'mataa dire, pɔɔ kɔ̃ɔ wa waan na pãrtɔvɩla nɩ kãnyũu kɔ̃ɔ dafʊ na ba wõnõ ɛ. A pɔɔ kpɩr naa a pãrtʊɔ nyĩe tɩ kpaar a kãnyũu ala dɔɔl a Yesu ju. ");
INSERT INTO biv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ka a nɩbɛ bala na be be nyɛ suur tɩ 'yɛrɛ kʊrɔ taa, “Bo lɛ so ka wʊ sɔ̃ɔ a kãnyũu nyã bar a nɩtɔ̃? ");
INSERT INTO biv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wʊn taa den da nɩbʊ̃'yen yuon gbul sãyar libie na wʊ de kʊ nɔ̃n dẽme.” Tɩ mii 'yɔ̃ɔ a pɔɔ. ");
INSERT INTO biv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ka a Yesu 'yɛr kʊ ba, “Yɩ bar wʊ! Bãa 'yɔ̃ɔ lɛ yɩ mii 'yɔ̃ɔ wʊ? Wʊ maal vɩla kʊ ma. ");
INSERT INTO biv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A nɔ̃n dẽme 'lɔ, yɩn nɩ bala ben ka. Yɩn tʊ̃ɔ sʊ̃ʊ ba sɔ̃ɔ 'lɔ jaa yɩn bʊɔrɔ, tɩchɛ maa kʊ̃ be a yɩ sɛ̃ sɔ̃ɔ jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wʊ ɩ naa a lɛ wʊn tʊ̃ɔ. Wʊ kpaar a kãnyũu 'yɔ̃ɔ ma tɩ chɛ ka n ba kpi sɛrɛ ɛ, na wʊ chɔɔr ma guro nɩ a n ũufʊ. ");
INSERT INTO biv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, jie jaa ban wa 'yɛr a 'yɛr nʊ̃ɔ nyãna a wɛr wʊ jaa pɔ, ban 'yɛr naa a lɛ a pɔɔ nyã na ɩ na ba chɛnɛ tara a wʊ tɩɛr.” ");
INSERT INTO biv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","A Pie nɩ Ayi bala wʊn kaa ir ãsʊɔ ban bʊɔlɔ a Judas Isɩkariyot chen a Juu nɩbɛ bɔɔrlo nɩbɛrɛ sɛ̃ tɩ 'yɛr ba ɩka wʊ bʊɔrɔ na ɩka wʊ de a Yesu 'yɔ̃ɔ a ba nuur pɔ. ");
INSERT INTO biv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ban wa wõ a lɛ wʊn 'yɛr ka a nʊ̃mɔ̃ ba, ka ba 'yɛr ɩka ban kʊ wʊn libie. Ka a Judas pãa bʊɔrɔ vuo 'lɔ wʊn na tu de a Yesu kʊ ba. ");
INSERT INTO biv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A bɩbir dɔ̃ɔ 'lɔ̃nɔ̃ ɩ naa a Paanʊ̃kõo Lɔ̃ɔfʊ, ka ban na kʊ a pele na ba di a Gõl Bar Difʊ, Yesu poturbo sʊʊr wʊ naa, “Nyɩnɛ lɛ fʊ bʊɔrɔ ɩka sɩ chen tɩ chɔɔr a Gõl Bar nyã bʊ̃diir a fʊ tɩ di?” ");
INSERT INTO biv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wʊ tʊ̃ naa a wʊ poturbo ayi, na wʊ 'yɛr kʊ ba, “Yɩ chen a tẽe pɔ, daba na tuo kʊ̃ɔ nɩ dʊʊ na tuor yɩ naa. Yɩ turo wʊ. ");
INSERT INTO biv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","A yir 'lɔ pɔ wʊn wa tɩ kpɛ, yɩ sʊʊr a yir sʊɔ, ‘A Wiwile ɩka sɩ wa sʊʊr fʊ, “Nyɩnɛ lɛ a 'lɔ nɩ a wʊ poturbo na wa 'mataa di a Gõl Bar Difʊ?” ’ ");
INSERT INTO biv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wʊn wiil yɩ naa bɔɔpɩɛ ban chɔɔr. Yɩ maal a bʊ̃diir a be.” ");
INSERT INTO biv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ba yin chen a tẽe tɩ nyɛ a lɛ jaa a Yesu na 'yɛr kʊ ba. Ka ba maal a Gõl Bar bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jãanʊɔr na wa ta, Yesu nɩ a wʊ poturbo Pie nɩ Ayi wa naa. ");
INSERT INTO biv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ban wa dire, wʊ 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, a yɩ ãsʊɔ na tɩ gar 'yɔ̃ɔ ma; ãsʊɔ sɩn 'mataa dire nɩ a labʊ̃'yen pɔ.” ");
INSERT INTO biv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Be lɛ ka ba jaa pʊɔ sɔ̃ɔ ka ba sʊrɔ wa bʊ̃'yen 'yen, “Maa lɛ ɔ?” ");
INSERT INTO biv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ka a Yesu 'yɛr, “A yɩ Pie nɩ Ayi ãsʊɔ lɛ! A yɩ ãsʊɔ sɩn 'mataa tũno a labʊ̃'yen pɔ lɛ. ");
INSERT INTO biv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A Nɩsaal Bie na kpi naa nɩtãa lɛ ban sɛb a Nãaŋmɩn gãn pɔ. Tɩchɛ a nɩrɛ 'lɔ na gar 'yɔ̃ɔ a Nɩsaal Bie na din dɔɔyɛ gar nɩrɛ jaa! Ka bala ta ba dɔɔ wʊ ɛ, ala sa.” ");
INSERT INTO biv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ban wa dire ka a Yesu de a paanʊ̃ɔ puor Nãaŋmɩn yãan, tɩ ŋmaa de kʊ a wʊ poturbo, na wʊ 'yɛr, “Yɩ de, a n ãgãn lɛ.” ");
INSERT INTO biv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wʊ lɛ den a ŋmele 'lɔ ban nyuro nɩ, na wʊ puor Nãaŋmɩn yãan tɩ lɛ de kʊ ba, ka ba jaa nyũ. ");
INSERT INTO biv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Be lɛ a Yesu 'yɛr kʊ ba, “N jãɩ lɛ a anyã na vɛ̃ a Nãaŋmɩn nɛtɩraa na tara kpɛ̃ɔ, an chir naa, na a faa nɩyɔɔ. ");
INSERT INTO biv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, n kʊ̃ lɛ nyũ a dãa anyãna ɛ, wa tɩ tãn a daar 'lɔ ɩn na nyũ a bʊ̃paalaa a Nãaŋmɩn nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ban wa yiel yiel dãn Nãaŋmɩn, ba suun chen a Olive Tɩɩr Tɔ̃ɔ ju. ");
INSERT INTO biv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu 'yɛr kʊ ba, “Yɩ jaa na jon tɩ bar ma, nɩtãa lɛ a Nãaŋmɩn na 'yɛr a wʊ gãn pɔ, Ɩn ŋme naa pɛchinɛ kʊ ka a piir yɛ̃yɛl. ");
INSERT INTO biv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tɩchɛ maa wa ir a kũu pɔ, ɩn de yɩn nie chen a Galilee.” ");
INSERT INTO biv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ka a Pita chɛ nyãa 'yɛr, “Ala ɩ gba, ba jaa sɔɔn bar fʊ tɩ maa 'lɔ kʊ̃ bar fʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu 'yɛr kʊ a Pita, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ fʊ, dɩna tãsɔɔ, a nɔrdɔ̃ɔ kʊ̃ kõ gbɛɛ ayi sɛrɛ ɛ, tɩ fʊ 'yɛr gbɛɛ ata ɩka faa bɔ̃ɔ ma ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tɩchɛ ka a Pita 'yɛr kpɛ̃ɔ jaa ɩka, “Maa nɩ fʊ̃ʊ na 'mantaa kpi gba, tɩ n kʊ̃ 'yɛr ɩka n ba bɔ̃ɔ fʊ ɛ.” Ka a bala mɩ na chɛ 'yɛr a lɛ nɛ. ");
INSERT INTO biv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu nɩ a wʊ poturbo chen naa a jie 'lɔ ban bʊɔlɔ Getɩsemanɩ, ka wʊ 'yɛr kʊ ba, “Yɩ jãnɛ a kana, tɩ ka n chen tɩ puor Nãaŋmɩn.” ");
INSERT INTO biv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Be lɛ wʊ tara Pita nɩ Jemesɩ nɩ Jɔɔn 'mataa chiin ka a wʊ pʊɔ sɔ̃ɔ yɔɔ jaa, ka tɩɛr nyɔɔ wʊ yɔɔ. ");
INSERT INTO biv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ka wʊ 'yɛr kʊ ba, “N tɩɛr sɔ̃ɔ naa, tɩ nyɛtãan kũu. Yɩ jãnɛ a kana gu ma tɩ na yɩ taa guro ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wʊ chen naa a niem bãlãa tɩ lo kpa tẽe sʊɔrɔ Nãaŋmɩn ɩka ala ɩ a tara naa ɩfʊ kɔ̃ɔ, wʊ vɛ̃ ka a sɔ̃ɔ nyãna po wʊ. ");
INSERT INTO biv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wʊ 'yɛr naa, “N Sãa, yele jaa ba gar a fʊ maalfʊ ɛ. De a dɔɔyɛ ŋmele nyãna bar a n sɛ̃, tɩchɛ a ta tu maa bɔfʊ ɛ, a tu a lɛ fʊ̃ʊ na bʊɔrɔ.” ");
INSERT INTO biv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wʊ lɩɛb chen a poturbo sɛ̃ tɩ nyɛ ka a ɩ ba gur naa. Ka wʊ 'yɛr kʊ a Simon Pita, “Simon, fʊ guro naa ɔ? A fʊ kʊ̃ lɛ tʊ̃ɔ jɛ̃ bãlãa gu ma ɛ? ");
INSERT INTO biv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yɩ jɛ̃ gu chɛlɛ, na yɩ sʊɔrɔ Nãaŋmɩn ka a bɛɛrkaa ta wa tʊ̃ɔ yɩ ɛ. A yɩ tɩɛr 'lɔ bʊɔrɔ naa tɩchɛ ka a yɩ ãgãma ba tʊɔr ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wʊ lɛ chen naa tɩ puor a Nãaŋmɩn a lɛ nɛ nɩ wʊ ju. ");
INSERT INTO biv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wʊ lɩɛb wa nyɛ ba go ka a ɩ ba gur naa bojũu gʊ̃ɔ kpɛ ba naa. Baa bɔ̃ɔ ŋmɩnɛ ban lɛ 'yɛr kʊ a Yesu ɛ. ");
INSERT INTO biv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wʊ lɩɛb wa a ba sɛ̃ a gbɛɛ ata sɔ̃ɔ wa sʊʊr ba, “Yɩ chɛnɛ na gã guro na yɩ pɛ̃nɛ ɔ? A sɛɛ naa! A sɔ̃ɔ ta naa. Nyɛ, ba gar 'yɔ̃ɔ a Nɩsaal Bie kʊ a yelbe-ɩrbɛ! ");
INSERT INTO biv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yɩ vaa ir, ka sɩ chen a ba sɛ̃. Nyɛ, a n gagaraa na waara!” ");
INSERT INTO biv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu na chɛnɛ 'yɛrɛ lɛ ka Judas na ɩ a wʊ poturo pie nɩ ayi ãsʊɔ tɩ daasãa, nɩ nɩbɛ na tara sɔbɛrɛ nɩ dakʊrsɩ waara nɩ a Yesu nyɔɔfʊ jie. A Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe nɩ a nɩbɛrɛ lɛ tʊ̃ ba. ");
INSERT INTO biv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas dɔ̃ɔ wiil a nɩbɛ mana ɩka, “A 'lɔ ɩn na tɩ puor mʊʊr a kɔtɩr yɩ nyɔɔ a 'lɔ, na yɩ bɔ̃ɔ tara wʊ chiin.” ");
INSERT INTO biv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ban wa ta, Judas pɔɔn chen a Yesu sɛ̃ tɩ 'yɛr, “Wiwile!” Tɩ puor wʊ nɩ mʊʊrfʊ. ");
INSERT INTO biv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ka a bala wʊn chiin nyɔɔ a Yesu. ");
INSERT INTO biv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Be lɛ ka a bala ãsʊɔ na ara gbʊr a Yesu vʊ̃ɔ a wʊ sʊɔ chɛn a Juu nɩbɛ bɔɔrlo nãa gbãgbaa toor ŋmaa. ");
INSERT INTO biv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ka a Yesu sʊʊr ba, “A mɔ̃ nɩbier lɛ n ɩ ka yɩ waan sɔbɛrɛ, nɩ dakʊrsɩ a n nyɔɔfʊ jie ɔ? ");
INSERT INTO biv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Bɩbir jaa lɛ n ma dɔ̃ɔ be a yɩ sɛ̃, na n wile yɩ a Puorfʊ Yir pɔ, tɩ yaa nyɔɔ ma ɛ. Tɩchɛ a ɩ naa a lɛ ɩka a tu a lɛ a Nãaŋmɩn gãn na 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Be lɛ a Yesu poturbo ba jaa bar wʊ tɩ jo. ");
INSERT INTO biv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pɔlbile kɔ̃ɔ mɩ na vaar fɔbaa tɛɛ turo nɩ a Yesu, ba nyɔɔ wʊ naa. ");
INSERT INTO biv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ka wʊ mɩɩr a fɔbaa 'yɔ̃ɔ ba tɩ jon sal'mʊɔr. ");
INSERT INTO biv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Be lɛ ba chiin a Yesu a Juu nɩbɛ bɔɔrlo nãa yir, ka a Juu nɩbɛ bɔɔrlo nɩbɛrɛ ba jaa nɩ a nɩbɛrɛ 'matãan a Mosesɩ Nɛɛ wiwiilbe, na ɩ a 'yɛr tɔɔrfʊ nɩbɛrɛ, wa lɔ̃ɔ taa. ");
INSERT INTO biv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita mɩ turo naa a puor jaa na wʊ wa tɩ kpɛ a bɔɔrlo nãa yir bɛchaar pɔ, na wʊ 'mataa jãnɛ nɩ a bala na kara a Puorfʊ Yir uoro bũu. ");
INSERT INTO biv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ka a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a 'yɛr tɔɔrfʊ nɩbɛrɛ na chɛ bʊɔrɔ yele kɔ̃ɔ na wiil ɩka Yesu sɛɛn kũu, tɩ baa nyɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nɩyɔɔ mɩ ŋman jirsɩ 'yɔ̃ɔ wʊ, tɩchɛ a ba 'yɛrbie ŋma taa poe. ");
INSERT INTO biv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ka a bamɩne mɩ ir ŋmaa jire 'yɛr ɩka, ");
INSERT INTO biv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“A ba sɛ̃, wʊ 'yɛr naa ɩka, ‘A Puorfʊ Yir nyãna a nɩrɛ nũu na mɛ, ɩn ŋmɛr wʊ naa tɩ na n de ber ata mɛn 'lɔ na ba ɩ nɩrɛ nũu bʊ̃mɩɛraa ɛ.’ ” ");
INSERT INTO biv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tɩchɛ a ba 'yɛr mɩ ba ɩ bʊ̃'yen ɛ. ");
INSERT INTO biv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Be lɛ ka a Juu nɩbɛ bɔɔrlo nãa ir ara tɩ sʊʊr a Yesu, “Faa 'yɛrɛ 'yɛr sɔɔrɔ ba bɩɩ? Bo dãasɩɛsɩ lɛ anyãna ban dire dɔɔlɔ fʊ. A ɩn yelmãɛ ɔ?” ");
INSERT INTO biv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tɩchɛ ka a Yesu ɩ jaa gbul, waa 'yɛr sɔɔ wʊ ɛ. Ka a bɔɔrlo nãa lɛ sʊʊr wʊ go, “Fʊ̃ʊ lɛ ɩ a Nãaŋmɩn 'lɔ sɩn 'Yɔ̃ɔnɔ̃ Bie na ɩ a Nɩ-iraa ɔ?” ");
INSERT INTO biv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ka a Yesu 'yɛr, “Maa lɛ. Yɩn nyɛ naa a Nɩsaal Bie na jãnɛ a Tʊ̃ɔfʊ Sʊɔ nũsʊ̃ɔ loor. Yɩ mɩ na lɛ nyɛn wʊn waara a julõjuur pɔ.” ");
INSERT INTO biv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ka a bɔɔrlo nãa tɔɔ a fuu chɩɛr nɩ suur, tɩ sʊʊr, “Bãa lɛ sɩn lɛ bʊɔrɔ nɩrɛ ɩka wʊ lɛ 'yɛr a wʊ 'yɛr go? ");
INSERT INTO biv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yɩn mãɛ wõ naa a lɛ wʊn fere. Ŋmɩnɛ lɛ yɩ tɩɛr?” Ka ba jaa 'yɛr ɩka wʊ sɛɛn kũu. ");
INSERT INTO biv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Be lɛ a bamɩne piel chɩrɛ nataar 'yɔ̃ɔnɔ̃ wʊ, ka a bamɩne mɩ pɔɔ a wʊ nɩbie tɩ ŋme wʊ, tɩ sʊʊr wʊ, “Wiil sɩ a nɩrɛ 'lɔ na ŋme fʊ.” Ka a bala mɩ na guro a Puorfʊ Yir mɩ ŋme ŋme wʊ. ");
INSERT INTO biv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita jãnɛ naa a be a bɛchaar pɔ, ka a bɔɔrlo nãa gbãgbapɔɔbile ãsʊɔ wa wa. ");
INSERT INTO biv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wʊn wa nyɛ a Pita na uoro a bũu, wʊ kaa wʊ naa lɛ̃ɛɛ tɩ 'yɛr, “Fʊ mɩ dɔ̃ɔ turo a Yesu na yi a Najaretɩ.” ");
INSERT INTO biv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ka a Pita chɩɩr tɩ 'yɛr, “N ba bɔ̃ɔ a lɛ fʊn 'yɛrɛ par ɛ.” Tɩ na wʊ tɔɔ chen tɩ ara a dɔ̃dɔr nɛɛ. ");
INSERT INTO biv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","A pɔɔbile na wa nyɛ a Pita a be, wʊ lɛ 'yɛr kʊ a nɩbɛ na ara a be, “A nyã mɩ ɩ naa a ba ãsʊɔ.” ");
INSERT INTO biv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ka a Pita lɛ chɩɩr go. A ba kor ɛ, tɩ a bala na ara gbʊr a Pita mɩ 'yɛr, “Sɩrɛ jaa lɛ, fʊ ɩ naa a ba ãsʊɔ, bojũu Galilee lɛ fʊ mɩ yi.” ");
INSERT INTO biv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ka a Pita pɔrɔ 'yɔ̃ɔnɔ̃ a wʊ mãɛ, tɩ pɔrɔ kʊrɔ ba 'yɛrɛ ɩka, “N ba bɔ̃ɔ a daba nyã 'yɛr yɩn 'yɛr ɛ.” ");
INSERT INTO biv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ajienaa lɛ ka a nɔraa mɩ tɔ̃ɔ kõ a gbɛɛ ayi sʊɔ. Ka a Pita pãa tɩɛrtɔ a lɛ a Yesu na dɔ̃ɔ 'yɛr kʊ wʊ, “Fʊn chɩɩr ma naa gbɛɛ ata, tɩ ka a nɔrdɔ̃ɔ kõ gbɛɛ ayi.” Pita na wa tɩɛr bɔ̃ɔn a lɛ, ka wʊ kõ yɔɔ jaa. ");
INSERT INTO biv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","A wɛr na wa chaar bibio, a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe nɩ a nɩbɛrɛ ba jaa nɩ a 'yɛr tɔɔrfʊ nɩbɛrɛ na chɛ, lɔ̃ɔn guor taa lũ a Yesu tara wʊ chiin tɩ kʊ a nãa Pilate. ");
INSERT INTO biv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ka a Pilate sʊʊr wʊ, “Fʊ̃ʊ lɛ ɩ a Juu nɩbɛ nãa ɔ?” Ka a Yesu 'yɛr, “Ɔ̃ɔ, a ɩn a lɛ fʊn 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ka a bɔɔrlo nɩbɛrɛ sɔ̃ɔnɔ̃ a Yesu yuor. ");
INSERT INTO biv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Be lɛ a Pilate sʊʊr a Yesu, “Faa 'yɛrɛ 'yɛr jaa ɛ, nyɛ lɛ ban sɔ̃ɔnɔ̃ fʊ a yuor jã!” ");
INSERT INTO biv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tɩchɛ Yesu ba haa nɛɛ ɛ, ka a 'maa a Pilate nɛɛ. ");
INSERT INTO biv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A mɩ ɩ naa a ba tʊ̃mɔ̃ lɛ ka bala wa lɔ̃ɔ taa dire a Gõl Bar Difʊ, a ba nãa ma ir nɩrɛ 'lɔ a nɩbɛ na bʊɔrɔ a pɔɔfʊ die pɔ bar. ");
INSERT INTO biv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Barabasɩ mɩ dɔ̃ɔ pʊɔ a nɩbɛ bamɩne pɔ, na dɔ̃ɔ ir jɛɛr nɩ a paal nɩkpɛ̃ɛ na ba kʊ nɩbɛ, ka ba nyɔɔr ba pɔɔ. ");
INSERT INTO biv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nɩyɔɔ wa naa a Pilate sɛ̃ wa sʊɔr wʊ ɩka, wʊ ɩ kʊ ba a lɛ wʊn ma ɩ. ");
INSERT INTO biv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ka a Pilate sʊʊr ba, “Yɩ bʊɔrɔ naa ɩka n ir a Juu nɩbɛ nãa kʊ yɩ bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilate bɔ̃ɔn naa ɩka a nyuur ban tara nɩ a Yesu lɛ vɛ̃ ban nyɔɔ wʊ waan a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tɩchɛ ka a bɔɔrlo nɩbɛrɛ dʊ̃ a nɩbɛ toor ɩka, ba 'yɛr ɩka, wʊ yuo a Barabasɩ bar. ");
INSERT INTO biv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ka a Pilate sʊʊr ba go, “Tɩ n ɩ ŋmɩnɛ nɩ a 'lɔ yɩn bʊɔlɔ a Juu nɩbɛ nãa?” ");
INSERT INTO biv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ka ba tãn, “Kpa wʊ a daa ju!” ");
INSERT INTO biv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Be lɛ ka a Pilate sʊʊr ba, “Bãa wʊ ɩ? Bo tʊ̃dɛɛr lɛ wʊ tʊ̃?” Tɩchɛ ka ba tãna kpɛ̃ɔ jaa, “Kpa wʊ a daa ju!” ");
INSERT INTO biv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate na bʊɔrɔ ɩka wʊ pɛl a nɩbɛ pʊɔ jũu, wʊ yuo naa a Barabasɩ kʊ ba. Wʊ vɛ̃ naa ka ba fɔb a Yesu yɔɔ jaa, tɩ de wʊ kʊ a sojasɩ ɩka, ba tɩ kpa wʊ a daa ju, ka wʊ kpi. ");
INSERT INTO biv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Be lɛ a sojasɩ tara a Yesu kpɛ̃n a nãa yir kpɛ̃ɛ 'lɔ pɔ, tɩ bʊɔl a ba taaba sojasɩ lɔ̃ɔ taa. ");
INSERT INTO biv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ba den fuu jɩɛ nãa fuu kaar su wʊ, na ba lɛ de gʊʊr vil nãa jupil kaar su wʊ. ");
INSERT INTO biv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tɩ pãa piel laara wʊ, “Yãan yooo, Juu nɩbɛ nãa!” ");
INSERT INTO biv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tɩ ma de daa ŋmen wʊ a jũu tɩ chɩrɛ nataar 'yɔ̃ɔnɔ̃ wʊ. Ba gbur dumo a wʊ niem puoro wʊ. ");
INSERT INTO biv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ban wa la wʊ a nɩtɔ̃ wa baar, ba yaa naa a fuu 'lɔ̃nɔ̃ bar, tɩ de a wʊ mãɛ fuu su wʊ, na ba pãa de wʊ chiin ɩka ba tɩ kpa wʊ a daa ju. ");
INSERT INTO biv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","A sɔr pɔ, ba nyɛn Simon na yi Sirenɩ tẽe pɔ, Aleksanda nɩ Worofʊs sãa lɛ. Mʊɔ pɔ lɛ wʊ yi tala, ka ba nyɔɔ wʊ fɩr ka wʊ de a Yesu daa tuo. ");
INSERT INTO biv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ba chiin naa a Yesu tɩ tãn a be ban bʊɔlɔ a Yesu nɩbɛ kɔkɔr pɔ, Gɔlgɔta. A par lɛ ɩka, Julaa Jie. ");
INSERT INTO biv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ka ba pãa de tãɩ kɔ̃ɔ 'yɔ̃ɔ a dãa pɔ, ɩka wʊ nyũ, tɩ wʊ tɔr. ");
INSERT INTO biv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Be lɛ ba kpa wʊ a daa ju. Ba põ naa a wʊ fɔɔr na ba ŋme gbãm bɔ̃ɔ a ala ãsʊɔ jaa na na de. ");
INSERT INTO biv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bibipɔl lɛ ba kpa wʊ. ");
INSERT INTO biv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ba sɛb naa a yele 'lɔ jũu ban kʊn wʊ mar a daa jũu ɩka, “A JUU NƖBƐ NÃA.” ");
INSERT INTO biv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ba mɩ kpan nãnyisɩ ayi a dabãbãnsɩ mɩ ju, ka ãsʊɔ be a Yesu nũsʊ̃ɔ loor ka a ãsʊɔ mɩ be a wʊ gʊba loor. ");
INSERT INTO biv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","A bala na tala a be a wʊ kpafʊ jie tʊrɔ wʊ, vavire a ba jur 'yɛrɛ, “Wooo, a fʊ̃ʊ nyã na 'yɛr ɩka fʊn sɔ̃ɔ naa a Nãaŋmɩn Puorfʊ Yir nyã bar tɩ mɛ wʊ a ber ata, ");
INSERT INTO biv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","wa suu a daa ju, na fʊ faa a fʊ mãɛ!” ");
INSERT INTO biv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Lɛ nɩ wʊ ju lɛ, a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe mɩ laara wʊ, na ba 'yɛrɛ kʊrɔ taa, “Nyɛ, wʊ faan bamɩne, tɩ wʊ kʊ̃ tʊ̃ɔ a wʊ mãɛ faa ɛ! ");
INSERT INTO biv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Vɛ̃ a 'lɔ na 'yɛr ɩka, 'lɔ lɛ ɩ a Nɩ-iraa, na wʊ ɩ a Isɩral nɩbɛ nãa, suu a daa ju a sɩ kaa, tɩ na sɩ pãa sɔɔ.” A bala mɩ ban kpa gbʊr wʊ, lɛ lɛ ba mɩ tʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A mɔ̃tɔ̃ɔ na wa ara a gar ju sãlsɔɔ, a wɛr wʊ jaa sɔb naa wa tɩ tãn a mɔ̃tɔ̃ɔ balfʊ sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","A sɔ̃ɔ 'lɔ̃nɔ̃ pɔ lɛ, ka a Yesu chɩɩr bʊɔl, “Eloi, eloi, lama sabakatanɩ.” A par lɛ a Yesu nɩbɛ kɔkɔr pɔ ɩka, “N Nãaŋmɩn, n Nãaŋmɩn, bo lɛ so ka fʊ lɩɛb puor 'yɔ̃ɔ ma?” ");
INSERT INTO biv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","A bala na ara gbʊr a be wõ na ba 'yɛr, “Yɩ chɛlɛ! Elaija lɛ wʊ bʊɔlɔ.” ");
INSERT INTO biv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ka a daba ãsʊɔ jo chen tɩ 'mɔɔ sapɔ 'lɔr a dãmiir amɩne pɔ, na wʊ chab daa tur a Yesu ɩka wʊ mʊʊr, tɩ na wʊ lɛ 'yɛr, “Yɩ vɛ̃ a sɩ kaara, Elaija na wa yɔɔ wʊ naa bɩɩ.” ");
INSERT INTO biv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Be lɛ a Yesu chɩɩr tɩ ŋmaa a vʊʊr. ");
INSERT INTO biv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ka a Juu Nɩbɛ Puorfʊ Yir pɔ, ban lũ a fɔbaa var a die chɩɛr a saaju tɩ gbem a par. ");
INSERT INTO biv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","A sojasɩ nɩkpɛ̃ɛ na ara a be a Yesu niem na wõ a wʊ chɩɩrfʊ, tɩ nyɛ a lɛ mɩ wʊn ŋmaa a vʊʊr, wʊ 'yɛr naa, “Yelmãɛ jaa, a daba nyã ɩ naa a Nãaŋmɩn Bie.” ");
INSERT INTO biv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","A pɔbɔ bamɩne lɔ̃ɔn Mɛɛr na yi Magdala tẽe pɔ, nɩ Salome, nɩ a Mɛɛr na ɩ a Jemesɩ bile, nɩ Josesɩ ma mɩ ara na tɛɛr jaa tɩ kaar wʊ. ");
INSERT INTO biv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","A Galilee pɔ, a pɔbɔ banyãna lɛ turo wʊ, na ba sʊ̃nɔ̃ wʊ. Ka a pɔbɔ bamɩne mɩ na 'matãan wʊ wa a Jerusalɛm, mɩ be be. ");
INSERT INTO biv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","A daar 'lɔ ɩ naa a ba Chɔɔrfʊ Bɩbir ban na chɔɔr a ba mãɛ, bojũu a mɔ̃tɔ̃ɔ wa mʊr, a Pɛ̃nfʊ Bɩbir piel naa. A jãanʊɔr na wa tara ");
INSERT INTO biv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","a Josefʊ na yi a Arimatɩya tẽe pɔ, na ɩ a nɩkpɛ̃ɛ ãsʊɔ ban 'yɔ̃ɔnɔ̃, tɩ mɩ dɔ̃ɔ chɛlɛ a Nãaŋmɩn Nãalʊ̃ʊ, nyɔɔn nyãa chen a Pilate sɛ̃, tɩ sʊɔr a Yesu ãgãn ɩka wʊ ũu. ");
INSERT INTO biv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate na wa wõ ɩka a Yesu kpi naa, a 'maa wʊn nɛɛ. Be lɛ wʊ bʊɔl a sojasɩ nɩkpɛ̃ɛ ka wʊ wa, ka wʊ sʊʊr wʊ, “A Yesu kpin bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ka a sojasɩ nɩkpɛ̃ɛ 'yɛr, “Ɔ̃ɔ, wʊ kpi naa.” Ka a Pilate sɔɔ ɩka a Josefʊ wʊ tɩ yɔɔ a Yesu ãgãn. ");
INSERT INTO biv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josefʊ dãn fɔbaa na wʊ tɩ yɔɔ a Yesu ãgãn vil wʊ chiin tɩ ũu, a yaa ban chɩ kʊsɩr pɔ. Ba bil kʊsɩr wa pɔɔ a yaa nɛɛ. ");
INSERT INTO biv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","A Mɛɛr na yi a Magdala, nɩ a Mɛɛr na ɩ a Josesɩ ma, nyɛ naa a jie 'lɔ ban ũu wʊ. ");
INSERT INTO biv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","A Pɛ̃nfʊ Bɩbir na wa baar, Mɛɛr na yi a Magdala, nɩ Salome, nɩ a Mɛɛr na ɩ a Jemesɩ ma, ba dãn a kãnyũur ala ɩka ba chiin tɩ jɛ a Yesu ãgãn. ");
INSERT INTO biv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","A Pɛ̃nfʊ divɩɛ bio daar, bibio mɔ̃tɔ̃ɔ na pur baar, ba chen naa a yaa par. ");
INSERT INTO biv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","A kʊsɩr na pɔɔ a yaa nɛɛ ba gbʊr ɛ, ka ba sʊrɔ taa, “An lɛ na tɩ bil a kʊsɩr bar sɩ a yaa nɛɛ?” ");
INSERT INTO biv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tɩchɛ ban dʊɔ kaa a ba nidaa, a kʊsɩr 'lɔ bil yi a yaa nɛɛ. ");
INSERT INTO biv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ban tɩ kpɩɛrɛ a yaa pɔ, ba nyɛn pɔlbile na su fuu pɩla jãnɛ nɩ a nũsʊ̃ɔ loor, ka pɩla ɔɔ ba. ");
INSERT INTO biv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A pɔlbile 'yɛr kʊ ba, “Yɩ ta vɛ̃ ka yɩ pɩla ɔɔrɔ ɛ. Yɩ bʊɔrɔ naa a Yesu 'lɔ na yi a Najaretɩ ban kpa a daa ju. Wʊ ir naa ɩ vʊr! Waa be a ka ɛ! Yɩ nyɛ a jie 'lɔ ban gaal wʊ. ");
INSERT INTO biv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yɩ lɩɛb kul tɩ 'yɛr a wʊ poturbo nɩ a Pita ɩka, wʊ de yɩn nie chiine a Galilee, be lɛ yɩn tɩ nyɛ wʊ, nɩtãa a lɛ wʊn dɔ̃ɔ 'yɛr kʊ yɩ.” ");
INSERT INTO biv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chĩcham kpɛ ba naa ka ba nɛɛ 'maa, ka ba jo yi a yaa par. Baa 'yɛr 'yɛr kʊ nɩrɛ jaa ɛ, bojũu dãbãɛ kpɛ ba naa. ");
INSERT INTO biv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","A Pɛ̃nfʊ divɩɛ bio daar bibio, Yesu na wa ir a kũu pɔ, wʊ den nie dũu a Mɛɛr na yi a Magdala, a 'lɔ pɔ wʊn dɔ̃ɔ dii a sɩdɛbɛ ayopõi bar ka a yi. ");
INSERT INTO biv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","A Mɛɛr chen tɩ 'yɛr kʊ a bala na dɔ̃ɔ be a Yesu sɛ̃, a bala a nie na sɔb ka baa kõnõ. ");
INSERT INTO biv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ban wa wõ ka wʊ 'yɛr ɩka a Yesu ir naa kũu pɔ ɩ vʊr, ka wʊ nyɛ wʊ, baa sɔɔ de ɛ. ");
INSERT INTO biv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","A anyã puor lɛ, a Yesu lɩɛb nɩyuo na wʊ dũu a ba ayi na de sɔr chiine a tẽe ãsʊɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ba lɩɛb chen a Jerusalɛm tɩ 'yɛr kʊ a ba taaba, tɩchɛ baa sɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","A ba kor ɛ, tɩ a Yesu lɛ dũu a Pie nɩ Bʊ̃'yen na 'mataa dire. Wʊ miin 'yɔ̃ɔ ba a ba ba sɔɔfʊ pɔ, nɩ a ba nyãkpãɛn jũu, bojũu baa sɔɔ de a bala na nyɛ wʊn ir a kũu pɔ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wʊ 'yɛr kʊ ba, “Yɩ yɔ a wɛr wʊ jaa, na yɩ mʊɔl 'yɛr a 'yɛr nʊ̃ɔ nyã kʊ a nɩbʊrɔ ba jaa. ");
INSERT INTO biv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nɩrɛ 'lɔ jaa na sɔɔ de a 'yɛr nʊ̃ɔ nyã, ka ba so wʊ a Nãaŋmɩn kʊ̃ɔ, wʊn nyɛn a Nãaŋmɩn faafʊ, tɩchɛ nɩrɛ 'lɔ jaa na ba sɔɔ de a 'yɛr nʊ̃ɔ nyã ɛ, a nɩnyɩnɛ na wɛ naa. ");
INSERT INTO biv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A jãnsɩ anyã na turo naa bala na sɔɔ. Ban de naa n yuor diin sɩdɛbɛ ka a yi, na ba lɛ bɔ̃ɔ 'yɛrbʊlsɩ 'yɛrfʊ. ");
INSERT INTO biv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ban ma 'mɔɔr waba. Bala wa nyũ bon na tara lɔɔ, tɩ a kʊ̃ ɩ ba yele ɛ. Baalaa ban dɔɔl a ba nũu, wʊn sa naa.” ");
INSERT INTO biv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","A Soro Yesu na wa 'yɛr a nɩtɔ̃ kʊ a wʊ poturbo, Nãaŋmɩn vɛ̃ naa ka wʊ do a saaju tɩ jãnɛ a wʊ nũsʊ̃ɔ loor. ");
INSERT INTO biv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Be lɛ ka a poturbo yi chen tɩ mʊɔlɔ a 'yɛr nʊ̃ɔ jie jaa. Be lɛ ka a Soro 'mataa tʊ̃nɔ̃ nɩ ba, ka a wʊ nɛ'maa tʊ̃mɔ̃ anyã ban tʊ̃nɔ̃ wiil ɩka a wʊ 'yɛr nʊ̃ɔ ɩn yelmãɛ.");
INSERT INTO biv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nɩtãa lɛ a nɩyɔɔ na mɔ̃ man a lɛ na ɩ a sɩ ber anyã pɔ, ");
INSERT INTO biv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","a lɛ ɩn yelmãɛ, ba dɔ̃ɔ be be na ba nyɛn nɩbir a pielfʊ, na ba ɩ a 'yɛr nyã gbãgbaar. ");
INSERT INTO biv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","A lɛ jũu n baraa Teofilusɩ, n mɩ mɔ̃n vɩɛr a 'yɛr tɩ tãn a pielfʊ nyɛ ka a ɩ yelmãɛ lɛ, ka n bʊɔrɔ ɩka n sɛb a lɛ na tu taa kʊ fʊ. ");
INSERT INTO biv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ka fʊ na tʊ̃ɔ bɔ̃ɔ ɩka a lɛ ban wiil fʊ ɩn yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","A Judiya Nãa Hɛrɔd sɔ̃ɔ, a Juu nɩbɛ bɔɔrloro ãsʊɔ ben be ban bʊɔlɔ Jekariya wʊ pʊɔ naa a Abija gbul pɔ ka a wʊ pɔɔ yuor di Elijabetɩ na yi a Aaron bʊrɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ba jaa ayi yele tor Nãaŋmɩn sɛ̃ ka ba turo a lɛ a Nãaŋmɩn nɛɛ na 'yɛr na baa tara chɛfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tɩchɛ baa tara bie ɛ, bojũu a Elijabetɩ abbaa ka 'lɔ naa sɩrɛ jaa nyɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","A mɩ lʊɔr wa ta a Jekariya ka wʊ̃n tʊ̃ a bɔɔr lofʊ tʊ̃mɔ̃ kʊ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Gbãm lɛ ba gba ir wʊ nɩtãa lɛ a ba bɔɔrlo tʊ̃mɔ̃ na be, ka wʊn ma kpɛ a puorfʊ yir tɩ chʊm a tãɩ nyũu vɩla ala. ");
INSERT INTO biv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ka a sɔ̃ɔ na wa ta ɩka wʊ chʊm a tãɩ nyũu vɩla anyãna, a nɩbɛ ara naa a yõo puoro. ");
INSERT INTO biv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Be lɛ a Nãaŋmɩn malaka wa dũu wʊ be a tãɩ nyũu vɩla chʊmfʊ jie a nũsʊ̃ɔ jie. ");
INSERT INTO biv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jekariya na wa nyɛ wʊ a lɛ, pɩla ɔɔ wʊ naa ka dãbãɛ kpɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tɩchɛ ka a malaka 'yɛr kʊ wʊ, “Jekariya ta joro dãbãɛ ɛ, Nãaŋmɩn wõn a fʊ sʊɔrfʊ, a fʊ pɔɔ Elijabetɩ na dɔɔn dabile ka fʊ 'yɔ̃ɔ a wʊ yuor Jɔɔn. ");
INSERT INTO biv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","A wʊ yele na ɩn nʊ̃ɔ kpɛ fʊ ka fʊ chɩlɛ ka nɩyɔɔ mɩ chɩlɛ a wʊ dɔɔfʊ jũu. ");
INSERT INTO biv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","An ɩ wʊn ɩn kpɛ̃ɛ a Nãaŋmɩn niem, wʊ kʊ̃ nyũ dãa ban 'yɔ̃ɔ dãbɩl ɛ, bojũu Nãaŋmɩn Sɩɛ na sɛɛ wʊn be a ma pʊɔm. ");
INSERT INTO biv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wʊn lɩɛb naa a Isɩral nɩbɛ yɔɔ jie waan a ba Nãaŋmɩn sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wʊn den a sɩ Soro nie nɩ a sɩɛ nɩ a kpɛ̃ɔ 'lɔ na dɔ̃ɔ be a Elaija 'yɔ̃ɔ, na wʊ lɩɛb sãamɩne ka ba tara a ba bibiir tɩɛr. Ka bawõnsɩ mɩ nyɛ yɛ̃ na ba maala yeltorsɩ na wʊ vɛ̃ ka nɩbɛ mɩ chɔɔr ba mãɛ gun a sɩ Soro.” ");
INSERT INTO biv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ka a Jekariya sʊʊr a malaka, “Ŋmɩnɛ ɩn ɩrɛ wa sɔɔ a nɩtɔ̃ fʊn 'yɛr? Maa nɩ n pɔɔ jaa kor naa.” ");
INSERT INTO biv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ka a malaka 'yɛr kʊ wʊ, “Maa lɛ a Gabɩrɛl na ma ara a Nãaŋmɩn niem, 'lɔ lɛ tʊ̃ ma nɩ a 'yɛr nyã ɩka n wa 'yɛr a 'yɛr nʊ̃ɔ nyã kʊ fʊ. ");
INSERT INTO biv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A lɛ jũu fʊn ɩn wõo fʊ kʊ̃ lɛ tʊ̃ɔ 'yɛr 'yɛr ɛ, wa tãn a bɩbir 'lɔ a anyãna na ɩ bojũu faa sɔɔ de a 'yɛr ala na wa ɩ a sɔ̃ɔ 'lɔ na sɛɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A nɩbɛ bala na be a yõo chɛlɛ a Jekariya wʊ̃n kor a lɛ a Nãaŋmɩn puorfʊ yir, ka chĩcham kpɛ ba. ");
INSERT INTO biv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Be lɛ ka wʊ wa yi tɩ wʊ kʊ̃ lɛ tʊ̃ɔ 'yɛr 'yɛr ɛ, ka a nɩbɛ bɔ̃ɔn ɩka wʊ nyɛn nyɛfʊ kɔ̃ɔ bojũu nuur kaalfʊ lɛ wʊ mana nɩ ba tɩ kʊ̃ tʊ̃ɔ 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","A lɛ a wʊ tʊ̃mɔ̃ bɩbie na wa baar be a Nãaŋmɩn puorfʊ yir, wʊ lɩɛb kul a wʊ yir. ");
INSERT INTO biv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","A anyã puor lɛ ka wʊ pɔɔ Elijabetɩ tara pʊɔ na wʊ sɔɔl ŋmɛrsɩ anũu. ");
INSERT INTO biv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Na wʊ pãa 'yɛrɛ, “Nyɛ lɛ a Nãaŋmɩn na maal ma, a wʊ maal vɩla bɩbir vɩɛ naa ka wʊ ir ma a vĩ yin a nɩbɛ niem bar.” ");
INSERT INTO biv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elijabetɩ pʊɔ na wa ta ŋmɛrsɩ ayʊɔb, Nãaŋmɩn tʊ̃ naa a Gabɩrɛl a tẽe na be a Galilee paal pɔ ban bʊɔlɔ Najaretɩ, ");
INSERT INTO biv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","be lɛ pɔɔsarbile kɔ̃ɔ be, ka daba ban bʊɔlɔ Josefʊ na ɩ a Nãa David yɔ̃ɔ ŋmaa baraa na kul ka a pɔɔbile yuor di Mɛɛr. ");
INSERT INTO biv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A malaka chen a wʊ sɛ̃ tɩ 'yɛr, “N puorfʊ naa, fʊ ɩn nɩ'yɔ̃ɔ naa, Nãaŋmɩn ben a fʊ sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ka dãbãɛ nyɔɔ a Mɛɛr nɩ a puorfʊ nyã bʊrɔ, na wʊ sʊrɔ wʊ mãɛ a puorfʊ nyã par. ");
INSERT INTO biv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tɩchɛ ka a malaka 'yɛr kʊ wʊ, “Ta joro dãbãɛ ɛ, fʊ ɩn nɩ'yɔ̃ɔ naa Nãaŋmɩn niem. ");
INSERT INTO biv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Fʊn tara na pʊɔ dɔɔ dabile, na fʊ 'yɔ̃ɔ a wʊ yuor Yesu. ");
INSERT INTO biv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wʊn ɩn kpɛ̃ɛ, ka ba bʊɔlɔ wʊ a Nãaŋmɩn na be a Saaju Bie. A sɩ Soro Nãaŋmɩn na den a wʊ sãa David nãalʊ̃ʊ kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","'Lɔ lɛ na di a Jekɔb yir nãa jaa kpo kpo, a wʊ nãa kʊ̃ wa baar ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ka a Mɛɛr sʊʊr a malaka, “N ba ta daba sɛrɛ ɛ, tɩ ŋmɩnɛ ɩn ɩrɛ wa dɔɔ a bie?” ");
INSERT INTO biv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ka a malaka 'yɛr kʊ wʊ, “Nãaŋmɩn Sɩɛ na wa kpɛ fʊ naa, ka a Nãaŋmɩn kpɛ̃ɔ wa ger pɔɔ fʊ a bichɛchɛ 'lɔ fʊn na dɔɔ, ban bʊɔlɔ wʊ̃n Nãaŋmɩn Bie. ");
INSERT INTO biv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nyɛ a fʊ yɛbɛ Elijabetɩ gba na ɩ a pɔɔ abbaa na wʊ nyɔ̃ɔ tɩ wʊ tara na pʊɔ na dɔɔ bie, chuur ayʊɔb nɩ nyã wʊn gal. ");
INSERT INTO biv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yele jaa ba ɩ tuo Nãaŋmɩn sɛ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Be lɛ a Mɛɛr 'yɛr, “Nyɛ, Nãaŋmɩn gbãgbaa lɛ n ɩ, a ɩ a lɛ kʊ ma fʊn 'yɛr?” Ka a malaka bar wʊ tɩ chen. ");
INSERT INTO biv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A sɔ̃ɔ 'lɔ̃nɔ̃ lɛ a Mɛɛr pɔɔ yi do a tɔ̃ɔ ju a Judiya tẽe pɔ. ");
INSERT INTO biv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wʊ tɩ kpɛ naa a Jekariya yir na wʊ puor a Elijabetɩ. ");
INSERT INTO biv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elijabetɩ na wõ a Mɛɛr puorfʊ ka a bie ɔɔ lɩɛb be a wʊ pʊɔm ka a Nãaŋmɩn Sɩɛ sɛɛ a Elijabetɩ. ");
INSERT INTO biv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ka wʊ ŋme chɛlma 'yɛrɛ, “Nãaŋmɩn sʊ̃ʊ fʊn gar a pɔbɔ ba jaa, na wʊ mɩ sʊ̃ʊ a bie 'lɔ na be a fʊ pʊɔm. ");
INSERT INTO biv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tɩchɛ nyɛ 'yɔ̃ɔfʊ na kaara, ka a n Soro ma wa a n sɛ̃? ");
INSERT INTO biv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ɩ̃n wa wõ a fʊ puorfʊ a bie na gã a n pʊɔm ɔɔn lɩɛb nɩ pʊpɛl. ");
INSERT INTO biv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pʊpɛl sʊɔ lɛ fʊ ɩ an ɩ fʊ sɔɔn de a lɛ a n Soro na tʊ̃, ka ba wa 'yɛr fʊ ɩka an ɩ naa a lɛ.” ");
INSERT INTO biv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ka a Mɛɛr 'yɛr, “N pɛɛn Nãaŋmɩn nɩ a pʊɔ wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","A n sɩɛ chɩlɛ naa a Nãaŋmɩn na ɩ a n Fafaara 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","An ɩ wʊ tɩɛrtɔ a wʊ gbãgbapɔɔbile mãɛ siirfʊ. An yi dɩna chiine, a dɔɔ tu taa ba jaa na bʊɔlɔ ma naa bɔɔsʊ̃n sʊɔ. ");
INSERT INTO biv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","An ɩ a Tʊ̃ɔfʊ Sʊɔ lɛ maal a lɛ kʊ ma. A wʊ yuor ɩn chɛchɛ. ");
INSERT INTO biv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A wʊ nɩbaal be naa a bala na joro wʊ dãbãɛ sɛ̃, yi a yɔn tɩ tãn a yɔn suulsɩ. ");
INSERT INTO biv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A wʊ nũu tʊ̃n tʊ̃bɛrɛ, wʊ yɛ̃yɛl naa a bala na bʊɔrɔ a yuor a ba tɩɛr pɔ bar. ");
INSERT INTO biv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wʊ dɔɔn nãmɩne a ba nãa dakɔɔr jur bar, tɩchɛ na wʊ 'mɔɔr a bala na siir a ba mãɛ ka ba do saaju. ");
INSERT INTO biv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wʊ kʊ naa a kɔ̃ dẽme bʊ̃sʊ̃n, tɩ dii a tara dẽme bar nũjaalsɩ. ");
INSERT INTO biv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Wʊ sʊ̃ʊn a wʊ gbãgbaa Isɩral tɩ tɩɛrtɔ ɩka wʊ kaa Abraham nɩ a wʊ yɔn nɩbaal bɩbir jaa, nɩtãa lɛ wʊn dɔ̃ɔ 'yɛr kʊ a sɩ sãamɩne.” ");
INSERT INTO biv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mɛɛr jãnɛ na a Elijabetɩ sɛ̃ ŋmɛrsɩ ata tɩ lɩɛb kul a wʊ tẽe. ");
INSERT INTO biv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elijabetɩ dɔɔfʊ bɩbir wa vɩɛ naa ka wʊ dɔɔ dabile. ");
INSERT INTO biv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ka a bala na kpɩɛrɛ gbʊr a Elijabetɩ nɩ a wʊ yir dẽme na wõ lɛ a Nãaŋmɩn na maal vɩla kʊ wʊ ba pʊɔ mɩ pɛl naa a wʊ kaar. ");
INSERT INTO biv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","A ber aniin daar ba wa naa ɩka ba wa ŋmaa a bie yʊɔr, na ba ta bʊɔrɔ ɩka ba de a sãa yuor 'yɔ̃ɔ wʊ bʊɔlɔ a Jekariya. ");
INSERT INTO biv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tɩchɛ ka a ma ba sɔɔ ɛ, tɩ 'yɛr, “A bie yuor din Jɔɔn.” ");
INSERT INTO biv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","A ba 'yɛr kʊ wʊ, “Fʊ bal nɩrɛ jaa ba di a yuor nyã ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tɩ na ba pãa 'lɩɩr sʊʊr a sãa a yobuor wʊn bʊɔrɔ ɩka ba 'yɔ̃ɔ a bie. ");
INSERT INTO biv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ka wʊ man ba ɩka ba kʊ wʊ bon ka wʊ sɛb, wʊn ben wa de a bon na wʊ sɛb, “A bie yuor din Jɔɔn.” Ka nɛɛr 'maa ba jaa. ");
INSERT INTO biv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ajienaa lɛ a Jekariya nɛɛ mɩ 'laa ka a jãlbir bal ka wʊ tʊ̃ɔ 'yɛrɛ na wʊ pɛɛrɛ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ka dãbãɛ kpɛ a bala jaa na gbʊr a be ka nɩbɛ 'yɛrɛ ka a yaar de a Judiya tẽn ala na be a tɔ̃n ju. ");
INSERT INTO biv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nɩrɛ jaa na wõ a nɩtɔ̃ a ma 'maa wʊn nɛɛ ka wʊ ma sʊʊr, “Ŋmɩnɛ lɛ a bie nyã na wa kaara?” Bojũu a Soro nũu dɔɔl naa a bie. ");
INSERT INTO biv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jekariya na ɩ a sãa, Nãaŋmɩn Sɩɛ sɛɛ wʊ naa ka wʊ 'yɛrɛ, ");
INSERT INTO biv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pɛɛfʊ wʊ ta a Isɩral Nãaŋmɩn, bojũu wʊ wa naa wa faa a wʊ nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wʊ kʊ sɩn gãdaa ɩka wʊ faa sɩ na yi a wʊ gbãgbaa Nãa David yir, ");
INSERT INTO biv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","nɩtãa lɛ wʊn dɔ̃ɔ tu a wʊ 'yɛ'yɛrbɛ chɛchɛ bala sɛ̃ a kõr jaa ka ba 'yɛr, ");
INSERT INTO biv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ɩka wʊ faa sɩ a sɩ dɔ̃dẽme sɛ̃, na wʊ faa sɩ a bala na laar sɩ nuur pɔ. ");
INSERT INTO biv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Wʊ maal a nɩtɔ̃ ɩka wʊ wiil nɩbaal kʊ a sɩ sãamɩne, na wʊ lɛ tɩɛr a wʊ nɛtɩr chɛchɛ 'lɔ, ");
INSERT INTO biv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","a lɛ wʊn pɔ kʊ a sɩ sãakpã Abraham. ");
INSERT INTO biv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Wʊ pɔn 'yɛr ɩka, wʊn faa sɩ naa a sɩ dɔ̃dẽme nuur pɔ, ka sɩ puoro wʊ kʊ̃ lɛ joro dãbãɛ ɛ, ");
INSERT INTO biv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","na sɩ ɩ chɛchɛ nɩ nɩtorsɩ a wʊ niem a ber a jaa. ");
INSERT INTO biv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A fʊ̃ʊ na ɩ a n bie ban bʊɔlɔ fʊ naa a saaju Nãaŋmɩn 'yɛ'yɛrɛ, an ɩ fʊ̃ʊ lɛ na de a sɩ Soro nie chɔɔr a wʊ sɔr, ");
INSERT INTO biv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","na fʊ vɛ̃ ka wʊ nɩbɛ bɔ̃ɔ a faafʊ sɔr, na ba nyɛ yelbier vɛ̃ kʊfʊ. ");
INSERT INTO biv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nãaŋmɩn na tara nɩ sɩ nɩbaal jũu, wʊ vɛ̃ naa ka a fafaara pur chaar 'yɔ̃ɔ sɩ yi a saaju, ");
INSERT INTO biv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na wʊ chaar 'yɔ̃ɔ a bala na kpɩɛrɛ a libe pɔ, tɩ be a kũu gãagiel pĩlem, na wʊ wiil a sɩ gbɛɛ ka a de nyã'maar sɔr.” ");
INSERT INTO biv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A bie nʊ̃ɔ naa ka a sɩɛ kpɛ̃ɔ be a wʊ sɛ̃. Mɔgɔ̃ɔ pɔ lɛ wʊ kpɩɛrɛ tɩ tãn a bɩbir 'lɔ wʊn na wiil a wʊ mãɛ kʊ a Isɩral nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","A ber ala pɔ, a paal Nãkpɛ̃ɛ Siisa Agustus 'yɛr naa ɩka ba sɔr a nɩbɛ ba jaa na be a Worom paal pɔ. ");
INSERT INTO biv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","A sɔrfʊ nyã lɛ ɩ a sɔrdɔ̃ɔ ban sɔr a nɩbɛ ka a Kiriniyus mɩ ɩ a Siriya nãa. ");
INSERT INTO biv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nɩrɛ jaa kul a wʊ mãɛ tẽe ka ban tɩ sɔr wʊ. ");
INSERT INTO biv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ala lɛ so ka a Josefʊ mɩ na yi a Najaretɩ tẽe na be a Galilee wɛr pɔ, na wʊ chen a Judiya wɛr pɔ, a Nãa David tẽe ban bʊɔlɔ a Bɛtɩlɛhɛm, bojũu a Nãa David yir lɛ wʊ yi tɩ lɛ ɩ a wʊ bal nɩrɛ. ");
INSERT INTO biv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josefʊ tara na a Mɛɛr na tara a pʊɔ wʊn bʊɔrɔ a kulfʊ 'mataa chiin ka ban tɩ sɔr ba. ");
INSERT INTO biv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","A lɛ ban be a Bɛtɩlɛhɛm ka a Mɛɛr bie dɔɔfʊ daar ta. ");
INSERT INTO biv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ka wʊ dɔɔ a pɔɔsarbie ka wʊ ɩ dabile a wʊ vil wʊ a fɔbaa gaal a dʊ̃n mʊɔr 'wɔfʊ jie bojũu baa nyɛ jie na kpɛ a sãanba kpɛfʊ jie ɛ. ");
INSERT INTO biv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pɛchiinbɛ mɩ dɔ̃ɔ gbʊr a tẽe na ba gãn a ba piir be a mʊ̃ɔ pɔ kaara. ");
INSERT INTO biv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ka a Nãaŋmɩn malaka yi a saaju wa a ba sɛ̃, ka Nãaŋmɩn tɩɩr chaar pɔɔ ba, ka dãbãɛ kpɛ ba. ");
INSERT INTO biv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tɩchɛ a malaka 'yɛr kʊ ba, “Yɩ ta joro dãbãɛ ɛ, 'yɛr nʊ̃ɔ lɛ n waan a yɩ sɛ̃, an ɩn chɩlfʊ kpɛ̃ɛ kʊ a nɩbɛ ba jaa. ");
INSERT INTO biv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","A dɩna tãsɔɔ ba dɔɔ naa a Fafaara a yɩ 'yɔ̃ɔ a Nãa David tẽe pɔ. Wʊ ɩ naa a sɩ Soro nɩ a Nɩ-iraa. ");
INSERT INTO biv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jãnɛ yɩn na de bɔ̃ɔn wʊ nɩ nyã. Yɩn nyɛ naa a bipɩla ban vil a fɔbaa gaal wʊ a dʊ̃n mʊɔr 'wɔfʊ jie.” ");
INSERT INTO biv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ajienaa a saaju malakasɩ yɔɔ wa naa wa 'matãan a malaka 'lɔ a ba dãna a Nãaŋmɩn 'yɛrɛ nɩ, ");
INSERT INTO biv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Tɩɩr wʊ ta a Nãaŋmɩn na be a saaju, ka nyã'maar mɩ be a nɩbɛ bala na pɛlɛ a wʊ pʊɔ a wɛr pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","A malakasɩ na wa bar ba tɩ lɩɛb do a saaju, ka a pɛchiinbɛ 'yɛrɛ kʊrɔ taa, “Yɩ ɩ a sɩ chen a Bɛtɩlɛhɛm tẽe pɔ, tɩ kaa a yelnyɩnɛ na ɩ ka a Nãaŋmɩn tʊ̃ 'yɛr sɩ.” ");
INSERT INTO biv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Be lɛ ba pɔɔ chen tɩ nyɛ a Mɛɛr nɩ a Josefʊ nɩ a bipɩla na gã a dʊ̃n mʊɔr 'wɔfʊ jie. ");
INSERT INTO biv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","A lɛ ban wa nyɛ wʊ, ba 'yɛr naa a lɛ a malaka na 'yɛr kʊ ba a bibile yele. ");
INSERT INTO biv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","A bala ba jaa na wõ a lɛ a pɛchiinbɛ na 'yɛr a bie 'yɛr kʊ ba, ka nɛɛr 'maa ba jaa. ");
INSERT INTO biv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tɩchɛ ka a Mɛɛr 'yɔ̃ɔ a anyãna a wʊ pʊɔm tara tɩɛrɛ. ");
INSERT INTO biv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A pɛchiinbɛ lɩɛb chen a piir jie tɩ dãna Nãaŋmɩn na ba pɛɛrɛ wʊ a ala a jaa ban wõ tɩ nyɛ a lɛ a malaka na 'yɛr kʊ ba. ");
INSERT INTO biv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","A ber aniin na wa ta, ba ŋmaa wʊn a yʊɔr tɩ 'yɔ̃ɔ wʊ a yuor Yesu, a yuor nyã lɛ a malaka 'yɛr kʊ a Mɛɛr tɩ ka wʊ wa tara a pʊɔ. ");
INSERT INTO biv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mɛɛr na wa baar a padɔɔr a lɛ a Mosesɩ nɛɛ na 'yɛr, Josefʊ nɩ a Mɛɛr den a bie chiin a Jerusalɛm na tɩ kʊ a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nɩtãa lɛ a Soro na 'yɛr, “Yɩ de dabil dɔ̃ɔ jaa kʊ a Soro.” ");
INSERT INTO biv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ba den a bɔɔrlo bomo ala a Soro na 'yɛr ɩka, “Ŋmama ayi bɩɩ papa pɔlɔ ayi tɩ pɔl a ba mãɛ.” ");
INSERT INTO biv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Daba kɔ̃ɔ dɔ̃ɔ be a Jerusalɛm ban bʊɔlɔ Simeon na wʊ ɩ nɩtor na waa baala Nãaŋmɩn ɛ. Wʊ mɩ dɔ̃ɔ chɛlɛ a Isɩral nɩbɛ faafʊ bɩbir ka a Nãaŋmɩn Sɩɛ be a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A Nãaŋmɩn Sɩɛ 'yɛr kʊ wʊ ɩka wʊn nyɛ naa a Nɩ-iraa 'lɔ a Soro na tʊ̃ nɩ nɩbir tɩ kpi. ");
INSERT INTO biv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","A Nãaŋmɩn Sɩɛ vɛ̃n ka Simeon chen be a Nãaŋmɩn puorfʊ yir bɛchaar pɔ, ka a ɩ a Josefʊ nɩ a Mɛɛr mɩ waan naa a ba bie Yesu a be na wa ir a nɛɛ. ");
INSERT INTO biv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ka a Simeon de a bie 'yɔ̃ɔ a wʊ nũu pɔ tɩ puor Nãaŋmɩn yãan 'yɛrɛ, ");
INSERT INTO biv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tʊ̃ɔnɔ̃ sʊɔ, nɩtãa lɛ fʊn tɩr a fʊ nɛɛ kʊ a maa na ɩ a fʊ gbãgbaa, fʊn tʊ̃ɔ bar ma sɔr nɩ nyã'maar. ");
INSERT INTO biv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Bojũu n nɩbir nyɛ naa a fafaara, ");
INSERT INTO biv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","'lɔ fʊn chɔɔr ka nɩrɛ jaa nyɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wʊn ɩn chãa wiil a nɩbɛ bala na ba ɩ a Juu nɩbɛ ɛ, tɩ na wʊ ɩ tɩɩr kʊ a fʊ nɩbɛ Isɩral.” ");
INSERT INTO biv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ka a Yesu sãa nɩ a ma nɛɛ 'maa a lɛ a Simeon na 'yɛr a wʊ yele. ");
INSERT INTO biv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ka a Simeon pãa 'yɛr nɛvɩla 'yɔ̃ɔ ba, tɩ 'yɛr kʊ a Mɛɛr na ɩ a ma, “A bie nyãna lɛ Nãaŋmɩn kʊ a Isɩral nɩbɛ, ka ba yɔɔ na ŋme gbɛr lo tɩ ir, na wʊ ɩ jãnɛ ka ban 'yɛrɛ kpɛrɛ nɩ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nɩbɛ yɔɔ pʊtɩɛr na gãn chãa pɔ, ka a fʊ̃ʊ mɩ pʊɔ sɔ̃ɔ fɩka sʊɔ ban chɔr fʊ.” ");
INSERT INTO biv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pɔɔ na ɩ a Nãaŋmɩn 'yɛ'yɛrɛ ben be ban bʊɔlɔ Ana na wʊ ɩ Fanuwɛl bie na wʊ ɩ Aserɩ bal nɩrɛ, na wʊ ɩ pɔɔ nyɔ̃ɔ. Wʊ kul sɩrɛ maal yuomo ayopõi. ");
INSERT INTO biv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ka a sɩrɛ kpi tɩ wʊ ɩ a pɔɔkʊɔr maal yuomo lɩjaanaar nɩ anaar (84). Waa gala a Nãaŋmɩn puorfʊ yir ɛ, tɩchɛ wʊ ma ben be na wʊ ma gal bʊ̃diir tɩ sʊɔrɔ Nãaŋmɩn tãsɔɔ nɩ a mɔ̃tɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A sɔ̃ɔ 'lɔ̃nɔ̃ lɛ wʊ wa a ba sɛ̃ tɩ dãn Nãaŋmɩn tɩ na wʊ 'yɛr a bie 'yɛr kʊ a bala jaa na chɛlɛ a Jerusalɛm faafʊ bɩbir. ");
INSERT INTO biv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","A lɛ a Josefʊ nɩ a Mɛɛr na wa ir a nɛɛ maal a lɛ a Soro na bin, ba lɩɛb kul a Najaretɩ na ɩ a ba tẽe na be a Galilee wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Be lɛ a bie tɩ nʊ̃ɔnɔ̃ nɩ fɔ̃ɔ na wʊ sɛɛn yɛ̃ ka a Nãaŋmɩn wãɛfʊ be a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yuon jaa a sãa naa ma ma chen a Jerusalɛm tɩ lɔ̃ɔ na ba di a Gõl Bar Difʊ. ");
INSERT INTO biv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu na wa nyɛ yuomo pie nɩ ayi ba tara wʊn don a Difʊ nyã jie nɩtãa lɛ ban ma ɩrɛ. ");
INSERT INTO biv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","A Gõl Bar Difʊ ber na wa baar, ba lɩɛb kulo a ba tẽe tɩchɛ a Yesu bar a Jerusalɛm ka baa bɔ̃ɔn ɛ. ");
INSERT INTO biv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ba tɩɛr ɩka wʊ taa pɔɔ a ba nɩbɛ kulo nɩ tɩ chen bɩbir bʊ̃'yen baa nyɛ wʊ ɛ, na ba pãa yʊɔrɔ bʊɔrɔ wʊ a ba nɩbɛ nɩ a ba nɩbɔ̃ɔnsɩ nɩ a ba barmɩne sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ban ba wa nyɛ wʊ ɛ, ba lɩɛb chen a Jerusalɛm a wʊ bɔfʊ jie. ");
INSERT INTO biv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","A ber ata daar lɛ a ba tɩ nyɛ wʊ a be a Nãaŋmɩn puorfʊ yir bɛchaar pɔ, ka wʊ jãnɛ a wiwiilbe chara pɔ chɛlɛ a lɛ ban 'yɛrɛ na wʊ sʊrɔ ba sʊʊrfʊsɩ. ");
INSERT INTO biv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nɩrɛ jaa na wõ a lɛ wʊn ire a 'yɛrsɩ par a chɔ̃ chɔ̃ nɛɛ 'maa ba naa. ");
INSERT INTO biv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","A sãa nɩ a ma na wa nyɛ wʊ a ba nɛɛ mɩ 'maa ba naa ka a ma sʊʊr, “Pa n bie, bo lɛ fʊ maal sɩ a nɩtɔ̃, ka maa nɩ a fʊ sãa yɔbɔ fʊ lɛ̃ɛɛ wa faa?” ");
INSERT INTO biv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ka Yesu sʊʊr a ma, “Bãa 'yɔ̃ɔ lɛ yɩ yʊɔrɔ bʊɔrɔ ma? Yaa bɔ̃ɔ ɩka ɩn be naa a n Sãa yir ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tɩchɛ baa bɔ̃ɔ a anyãna wʊn 'yɛr kʊ ba par ɛ. ");
INSERT INTO biv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A wʊ ir pɔɔ ba, a ba pãa kul a Najaretɩ a wʊ tɩ wõnõ a ba toor, tɩchɛ ka a ma 'yɔ̃ɔ a 'yɛr anyãna a jaa a wʊ pʊɔm. ");
INSERT INTO biv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ka a Yesu nʊ̃ɔnɔ̃ nɩ yɛ̃ nɩ a kpɛ̃ɛ ka wʊ yele nʊ̃mɔ̃ a Nãaŋmɩn sɛ̃ nɩ a nɩbɛ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yuon pie nɩ anũu lɛ a Tiberiyus Siisa di a nãkpɛ̃ɛ ka a Pontius Pilate mɩ ɩ a Judiya paal nɩkpɛ̃ɛ ka a Hɛrɔd mɩ di a Galilee nãa ka a wʊ yɛbɛ Filip mɩ ɩ a Ituriya nɩ a Tɩrakonɩtɩs nãa. Ka a Lisaniyasɩ mɩ di a Abilenɩ nãa. ");
INSERT INTO biv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasɩ nɩ Kayafasɩ bala lɛ ɩ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ. Ka a Nãaŋmɩn de a wʊ 'yɛr kʊ a Jekariya bidaba Jɔɔn be a mɔgɔ̃ɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wʊ yɔn a tẽn ala a jaa na jilʊ̃ a Jordan man na wʊ 'yɛrɛ kʊrɔ a nɩbɛ, “Yɩ lɩɛb a yɩ tɩɛr na yɩ so a Nãaŋmɩn kʊ̃ɔ, ka Nãaŋmɩn vɛ̃ a yɩ yeldɛbɛ kʊ yɩ.” ");
INSERT INTO biv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nɩtãa lɛ a Isaiya na sɛb a wʊ gãn pɔ, “Nɩrɛ 'yɛrɛ naa be a mɔgɔ̃ɔ pɔ, ‘Yɩ chɔɔr a sɩ Soro sɔr, na yɩ maal a wʊ sɔr ka wʊ tor. ");
INSERT INTO biv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Na yɩ 'mʊr a kʊlsɩ, na yɩ ŋmɛr a tɔ̃n nɩ a gbẽgbẽnsɩ ka a jãtaa. Yɩ maal a sɔgɔ̃rsɩ a jaa ka a tor, na yɩ maal a sɔr nyara nyara ka wʊ sal. ");
INSERT INTO biv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nɩsaal bʊrɔ ba jaa na nyɛn Nãaŋmɩn faafʊ.’ ” ");
INSERT INTO biv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ka a nɩyɔɔ bala na waara a Jɔɔn sɛ̃ a Nãaŋmɩn kʊ̃ɔ sofʊ 'yɔ̃ɔ, ka wʊ sʊʊr ba, “Yɩn waa bibiir, an lɛ 'yɛr kʊ yɩ ɩka yɩ jo yi a Nãaŋmɩn suur na waara a yɩ sɛ̃? ");
INSERT INTO biv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yɩ vɛ̃ ka yɩ befʊ wiil ɩka yɩ lɩɛb a yɩ tɩɛr. Yɩ ta chɛnɛ 'yɛrɛ kʊrɔ a yɩ mãɛ ɩka, Abraham lɛ ɩ a sɩ sãa, n 'yɛrɛ na kʊrɔ yɩ ɩka Nãaŋmɩn na tʊ̃ɔn maal a kusɩbɛ anyãna a ba lɩɛb ɩ a Abraham bibiir. ");
INSERT INTO biv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A 'lar dɔɔl a tɩɛ nyɩbɛ ju, tɩɛ jaa ba wa wɔ̃nɔ̃ wɔ̃ sʊ̃n ɛ, ban ŋmaa wʊn lɔb 'yɔ̃ɔ bũu pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ka a nɩyɔɔ bala sʊʊr wʊ, “Ŋmɩnɛ sɩn pãa ɩ?” ");
INSERT INTO biv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ka Jɔɔn 'yɛr kʊ ba, “Ɩ̃sʊɔ jaa na tara fuusɩ ayi, wʊ ir ãsʊɔ kʊ a wʊ tɔ sʊɔ na ba tara ɛ, nyã mɩ na tara bʊ̃diir wʊ ɩ a lɛ.” ");
INSERT INTO biv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lõpodierbe mɩ wan a Jɔɔn sɛ̃ ɩka wʊ so ba a Nãaŋmɩn kʊ̃ɔ, na ba mɩ sʊʊr wʊ, “Wiwile sɩ mɩ ɩ ŋmɩnɛ?” ");
INSERT INTO biv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ka wʊ 'yɛr kʊ ba, “Yɩ ta ma de dɔɔl a lɛ ban ɩka yɩ de ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sojasɩ bamɩne mɩ wan wa sʊʊr wʊ, “Sɩn mɩ, sɩ ɩ ŋmɩnɛ?” Ka wʊ 'yɛr kʊ ba, “Yɩ ta fɩr nɩrɛ de libir ɛ, yɩ ta mɩ ŋmaa jir kara dɔɔl nɩrɛ ɛ, na yɩ vɛ̃ ka a yɩ sãyar sɛɛn yɩ.” ");
INSERT INTO biv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ka a nɩbɛ mɩ na dɔ̃ɔ 'yɔ̃ɔ toor chɛlɛ, pãa tɩɛrɛ ɩka a Jɔɔn lɛ tɔ̃ɔ ɩ a Nɩ-iraa. ");
INSERT INTO biv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","A Jɔɔn 'yɛr kʊ ba, “Maa 'lɔ kʊ̃ɔ lɛ n suoro yɩ, tɩchɛ nɩrɛ ãsʊɔ na gar ma na wa naa, a wʊ nafɔɔr mibe gba, n ba sɛɛ ɩka n for ɛ. 'Lɔ lɛ na de Nãaŋmɩn Sɩɛ nɩ bũu son yɩ. ");
INSERT INTO biv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A ŋmayɩɛl naa ben a wʊ nũu pɔ, a wʊ na yɩɛl a mʊ̃ɩ a vafʊ jie na wʊ kpaar a bie 'yɔ̃ɔ a boor pɔ tɩ chʊm a sɔ̃sɔɔr nɩ bũu 'lɔ na ba tara kpĩinfʊ bar.” ");
INSERT INTO biv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jɔɔn kpãa ban nɩ yelyɔɔ na wʊ 'yɛr a Nãaŋmɩn 'yɛr kʊ ba. ");
INSERT INTO biv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tɩchɛ a nãa Hɛrɔd na de a wʊ yɛbɛ pɔɔ Hɛrɔdiyas kul, Jɔɔn 'yɛr wʊ naa ɩka a ba tara sɔr ka wʊ kul wʊ ɛ, tɩ 'yɛr wʊ a dɛbɛ amɩne wʊn ɩ. ");
INSERT INTO biv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hɛrɔd lɛ maal dɛɛr wʊn vɛ̃ ka ba nyɔɔ Jɔɔn tɩ 'yɔ̃ɔ a pɔɔfʊ die pɔ. ");
INSERT INTO biv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ban ba nyɔɔ a Jɔɔn pɔɔ sɛrɛ ɛ, wʊ so naa a nɩbɛ a Nãaŋmɩn kʊ̃ɔ na wʊ mɩ so a Yesu a Nãaŋmɩn kʊ̃ɔ. Ka a Yesu sʊɔrɔ Nãaŋmɩn ka a saaju yuo. ");
INSERT INTO biv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ka a Nãaŋmɩn Sɩɛ de papa ãgãn suu wa 'mar a Yesu ju, tɩ a kɔkɔr yi be a saaju 'yɛr, “Fʊ̃ʊ lɛ ɩ a n Bidanʊ̃naa ka fʊ yele pɛl a n pʊɔ.” ");
INSERT INTO biv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu nyɛn yuon lɩjɛr nɩ pie tɩ piel a wʊ tʊ̃mɔ̃, ka nɩbɛ tɩɛr ɩka wʊ ɩ naa a Josefʊ bidaba, na ɩ a Heli bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matatɩ bidaba, Levi bidaba, Melki bidaba, Janai bidaba, Josefʊ bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatiyasɩ bidaba, Amosɩ bidaba, Nahum bidaba, Esili bidaba, Nagai bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maat bidaba, Matatiyasɩ bidaba, Semeyin bidaba, Josekɩ bidaba, Joda bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanan bidaba, Aresa bidaba, Jerubabel bidaba, Sealtɩɛl bidaba, Neri bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melki bidaba, Adi bidaba, Kosam bidaba, Elmadam bidaba, Erɩ bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josua bidaba, Eliyeja bidaba, Jorim bidaba, Matatɩ bidaba, Levi bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeon bidaba, Juda bidaba, Josefʊ bidaba, Jonam bidaba, Eliyakim bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea bidaba, Mena bidaba, Matata bidaba, Natan bidaba, David bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesɩ bidaba, Obed bidaba, Boajɩ bidaba, Salmon bidaba, Nason bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab bidaba, Aram bidaba, Hejoron bidaba, Perejɩ bidaba, Juda bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jekɔb bidaba, Isaakɩ bidaba, Abraham bidaba, Tera bidaba, Nahor bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serugu bidaba, Wɛru bidaba, Peleg bidaba, Eber bidaba, Sela bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kainan bidaba, Afakadɩ bidaba, Sem bidaba, Nowa bidaba, Lamekɩ bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusela bidaba, Enok bidaba, Jared bidaba, Mahalaleel bidaba, Kenan bidaba, ");
INSERT INTO biv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enosɩ bidaba, Setɩ bidaba, Adama bidaba, Nãaŋmɩn bidaba. ");
INSERT INTO biv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nãaŋmɩn Sɩɛ sɛɛn a Yesu na wʊ lɩɛb wʊ yin a Jordan man jie kpɛ̃n wʊ a mɔgɔ̃ɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Be lɛ a tɩɩ bɛɛr wʊ kaa ber lɩjaayi, waa di bon jaa a ber anyãna pɔ ɛ, ka a kɔ̃ kpɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A tɩɩ 'yɛr kʊ wʊ, “Ala ɩ fʊ̃ʊ lɛ a Nãaŋmɩn Bie, 'yɛr kʊ a kʊsɩbɛ anyãna, ka a lɩɛb bʊ̃diir.” ");
INSERT INTO biv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ka a Yesu 'yɛr kʊ wʊ ɩka, a sɛb a Nãaŋmɩn gãn pɔ ɩka, “Bʊ̃diir tɛɛ kʊ̃ tʊ̃ɔ kʊ nɩrɛ nyɛvʊr ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","A tɩɩ lɛ tara wʊn don tɔ̃ɔ ju tɩ wiil wʊ a nãa di jiir a jaa na be ka a wɛr pɔ ");
INSERT INTO biv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","tɩ 'yɛr, “Ɩn kʊ fʊ naa anyãna a jaa fɔ̃ɔ nɩ a ba nãyele, maa lɛ ba de a ba fɔ̃ɔ kʊ, ka n mɩ na de kʊ nɩrɛ 'lɔ jaa ɩn bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ala ɩ, fʊ gbur dumo puor ma fʊ̃ʊ lɛ so.” ");
INSERT INTO biv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ka Yesu 'yɛr wʊ, “A sɛb a Nãaŋmɩn gãn pɔ ɩka, Nãaŋmɩn tɛɛ lɛ a sɛɛ ɩka fʊ puor, na fʊ tʊ̃nɔ̃ kʊrɔ a 'lɔ tɛɛ.” ");
INSERT INTO biv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","A tɩɩ lɛ tara wʊn chiin a Jerusalɛm ka wʊ tɩ do a puorfʊ yir jie 'lɔ na do na wʊ 'yɛr kʊ a Yesu, “Ala ɩ fʊ̃ʊ lɛ a Nãaŋmɩn Bie ɔɔ lo a tẽe, ");
INSERT INTO biv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","bojũu a sɛb a Nãaŋmɩn gãn pɔ ɩka, ‘Nãaŋmɩn na vɛ̃ naa ka a wʊ malakasɩ wa gu fʊ taa lɛɛ, ");
INSERT INTO biv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na ba nyɔɔ fʊ nɩ a ba nuur ka a fʊ gbɛr kʊ̃ ŋme kʊsɩr ɛ.’ ” ");
INSERT INTO biv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ka a Yesu 'yɛr kʊ a tɩɩ, a mɩ sɛb a Nãaŋmɩn gãn pɔ ɩka, “Ta bɛɛr a fʊ Nãaŋmɩn kaa ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","A tɩɩ na wa baar a bɛɛr kaa anyãna wʊ bar wʊn tɩ chen, tɩ lɛ guro nɩ sɔ̃ɔ kɔ̃ɔ wʊn lɛ wa nyɛ jie. ");
INSERT INTO biv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu lɩɛb kul a Galilee nɩ a Nãaŋmɩn Sɩɛ kpɛ̃ɔ ka a wʊ yele yaar a wɛr 'lɔ wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wʊ tɩ wile naa a nɩbɛ a ba lɔ̃ɔfʊ jiir ka a nɩrɛ jaa pɛɛrɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu lɩɛb chen a Najaretɩ be wʊn nʊ̃ɔ, a Pɛ̃nfʊ Bɩbir Daar wʊ tɩ kpɛ̃n a ba lɔ̃ɔfʊ yir an ɩ lɛ lɛ wʊ ma ɩrɛ na wʊ ir ara na wʊn kar gãn. ");
INSERT INTO biv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ka ba de Isaiya gãn kʊ wʊ, ka wʊ nyɔɔ 'yɩɛr a jie 'lɔ ban sɛb, ");
INSERT INTO biv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nãaŋmɩn Sɩɛ be naa a n 'yɔ̃ɔ, bojũu wʊ ir ma naa ɩka n tɩ 'yɛr a 'yɛr nʊ̃ɔ kʊ a nɔ̃n dẽme, naa mɩ tɩ 'yɛr kʊ gbãgbaar ka ban so ba mãɛ, naa 'yɛr kʊ jɔ̃n ka ba yuo, naa 'yɛr faa a bala ban gere, ");
INSERT INTO biv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","naa 'yɛr a Nãaŋmɩn maal vɩla yuon kʊ ba.” ");
INSERT INTO biv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Be lɛ wʊ pilʊ̃ a gãn de kʊ a tʊ̃tʊ̃nɔ̃ tɩ jãnɛ, ka a nɩbɛ ba jaa na be a lɔ̃ɔfʊ yir kpa a nɩbie 'yɔ̃ɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ka wʊ piel 'yɛrɛ kʊrɔ ba, “Dɩna a lɛ yɩn wõ a Nãaŋmɩn gãn pɔ, a ɩ naa a lɛ.” ");
INSERT INTO biv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ba jaa 'yɛrɛ naa a wʊ sʊ̃ 'yɛr ka ba nɛɛr 'maa a 'yɛr vɩɛlsɩ na yire a wʊ nɛɛ pɔ ka ba sʊrɔ taa, “A ba ɩ a Josefʊ bidaba lɛ a nyã ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ka a Yesu 'yɛr kʊ ba, “Sɩrɛ jaa lɛ, yɩn sʊʊr ma naa nɩ a sʊkpa nyã, ‘Tɩtɩlɛ, tɩɩl a fʊ mãɛ, maal a ala fʊn maal a Kapenahum ka a fʊ tẽe.’ ” ");
INSERT INTO biv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","A wʊ 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, ba maa de Nãaŋmɩn 'yɛ'yɛrɛ a wʊ mãɛ tẽe pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka pɔɔkɔyɔɔ ben a Isɩral nɩbɛ wɛr pɔ a Elaija sɔ̃ɔ, a war bũu 'lɔ na dɔ̃ɔ ŋmaa a yuom ata nɩ ŋmɛrsɩ ayʊɔb a wɛr wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tɩchɛ Nãaŋmɩn ba tʊ̃ a Elaija a pɔɔkɔɛ ba nyã ãsʊɔ jaa sɛ̃ ɛ, tɩ tʊ̃ wʊ a pɔɔkʊɔr na be a Jarefat na be a Sidon wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","A Nãaŋmɩn 'yɛ'yɛrɛ Elisa sɔ̃ɔ, kɔ̃kɔ̃n mɩ ben a Isɩral nɩbɛ wɛr pɔ tɩ ãsʊɔ jaa ba sa ɛ, ka Naaman na yi a Siriya wɛr pɔ ba lɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","A nɩyɔɔ bala na be a lɔ̃ɔfʊ yir 'lɔ pɔ, ka suur kpɛ ba jaa. ");
INSERT INTO biv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ba ir da wʊ yin a tẽe pɔ don a tɔ̃ɔ 'lɔ ju a ba tẽe na mɛ bʊɔrɔ ɩka ba daa wʊ lɔb a tɔ̃ɔ koro pɔ. ");
INSERT INTO biv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tɩchɛ ka wʊ fʊɔl yi a nɩyɔɔ bala sãlsɔɔ a lɛ na wʊ chen. ");
INSERT INTO biv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Be lɛ wʊ suu chen a Kapenahum na be a Galilee wɛr pɔ, ka a Pɛ̃nfʊ Bɩbir Daar ka wʊ piel wile a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ka a wʊ wiilfʊ 'maa ba nɛɛ bojũu a wʊ 'yɛr tara na kpɛ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Daba mɩ ben a be a lɔ̃ɔfʊ yir na tara a dɛɛr sʊɔ, ka a sɩdɛɛr be a wʊ 'yɔ̃ɔ, a wʊ ŋme chɛlma sʊʊr, ");
INSERT INTO biv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ai, a fʊ̃ʊ Yesu na yi a Najaretɩ, bo fʊ bʊɔrɔ ka a sɩ sɛ̃? Fʊ wa naa ɩka fʊ wa sɔ̃ɔ sɩ bar bɩɩ? N bɔ̃ɔ naa a nɩnyɩnɛ fʊn ɩ, fʊ ɩ naa a Nãaŋmɩn nɩchɛchɛ 'lɔ.” ");
INSERT INTO biv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ka Yesu tãn wʊ, “Pɔɔ a nɛɛ tɩ wa yi a daba 'yɔ̃ɔ.” A sɩdɛɛr daan a daba lɔb a nɩbɛ niem tɩ na wʊ yi a daba 'yɔ̃ɔ tɩ waa 'yɔ̃ɔ wʊ baal ɛ. ");
INSERT INTO biv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ka a nɛɛr 'maa a nɩbɛ ka ba sʊrɔ taa, “Wiilbuor mɩ nɩ nyã? Wʊ den kpɛ̃ɔ nɩ tʊ̃ɔfʊ 'yɛr kʊ a sɩdɛbɛ ka a yi.” ");
INSERT INTO biv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ka a wʊ yele yaar de a tẽn ala na jilʊ̃ a be. ");
INSERT INTO biv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu yi naa a lɔ̃ɔfʊ yir na wʊ chen a Simon yir. Ka ãgãn tɔ a Simon dãɛ ma ka ba sʊɔr a Yesu ɩka wʊ sʊ̃ʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ka wʊ guun ger a pɔɔ na wʊ tãn a ãgãn tʊl ka wʊ bar a pɔɔ, ka wʊ sa na wʊ ir maal bʊ̃diir kʊ ba. ");
INSERT INTO biv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","A mɔ̃tɔ̃ɔ na wa mʊrɔ nɩbɛ waan naa ba baalsɩ a Yesu sɛ̃, ka wʊ dɔɔl ba a wʊ nũu na wʊ sãa baal jaa bʊrɔ ban waan. ");
INSERT INTO biv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sɩdɛbɛ yin a nɩyɔɔ 'yɔ̃ɔ tãna 'yɛrɛ, “Fʊ ɩn Nãaŋmɩn Bie.” Tɩchɛ ka a Yesu tãn ba ka ba ta 'yɛrɛ ɛ, an ɩ ba bɔ̃ɔn naa ɩka 'lɔ lɛ ɩ a Nɩ-iraa. ");
INSERT INTO biv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","A wɛr na wa chaar Yesu yin tɩ jãnɛ a jie ãsʊɔ wʊ yõ, ka a nɩbɛ yɔbɔ wʊ tɩ nyɛ a jie wʊn be ba lɛ bʊɔrɔ ɩka wʊ bar ba tɩ chen ɛ. ");
INSERT INTO biv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tɩchɛ ka wʊ 'yɛr kʊ ba, “A sɛɛ naa ɩka n 'yɛr a Nãaŋmɩn nãalʊ̃ʊ 'yɛr kʊ a tẽn anyã mɩ bojũu a lɛ 'yɔ̃ɔ lɛ a Nãaŋmɩn tʊ̃ ma.” ");
INSERT INTO biv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tɩ na wʊ chɛnɛ 'yɛrɛ a Nãaŋmɩn 'yɛr be a a ba lɔ̃ɔfʊ yie a Juu nɩbɛ tẽe pɔ. ");
INSERT INTO biv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bɩbir ãsʊɔ Yesu be naa a Genesaretɩ man nɛɛ, ka nɩyɔɔ ara jilʊ̃ wʊ chɛlɛ a Nãaŋmɩn 'yɛr. ");
INSERT INTO biv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wʊ nyɛn gborsɩ ayi a gogoro nɛɛ a jãnyɔɔrbɔ na bar tɩ suu pɛɛrɛ a ba lɔyaarsɩ. ");
INSERT INTO biv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ka wʊ kpɛ a gboro ãsʊɔ pɔ na ɩ Simon bon tɩ sʊɔr wʊ ɩka wʊ daa wʊ ka wʊ jãan a gogoro bãlãa. Wʊ pãa jãnɛ naa a gboro pɔ tɩ wile a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wʊn wa baar a 'yɛr ka wʊ 'yɛr a Simon, “Daa a gboro chiin a kɔ̃die pɔ na fʊ tɩ lɔb a fʊ lɔyaar.” ");
INSERT INTO biv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ka a Simon 'yɛr, “Kpãkpãana, tãsɔɔ jaa lɛ sɩ lɔb lɛ̃ɛɛ tɩ saa nyɔɔ bon ɛ, tɩchɛ fʊn 'yɛr go, ɩn lɔbaa.” ");
INSERT INTO biv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ban wa lɔb, ba nyɔɔr jãyɔɔ ka a lɔyaarsɩ ɩrɛ na chɩɛr. ");
INSERT INTO biv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ka ba 'lɩɩr a ba taaba na be a gboro ãsʊɔ pɔ, ka ba wa sʊ̃ʊ ba. Ba wa naa ka a gborsɩ a jaa ayi wa sɛɛ ka ba ɩrɛ na mʊr. ");
INSERT INTO biv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Pita na wa nyɛ a lɛ, wʊ lon kpa a Yesu niem tɩ 'yɛr, “N Soro sɛr chen tɩ bar ma yelbe-ɩrɛ lɛ n ɩ.” ");
INSERT INTO biv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A jãyɔɔ anyã ban nyɔɔr jũu, 'lɔ nɩ a wʊ taaba nɛɛr 'maa naa. ");
INSERT INTO biv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Lɛ lɛ a Jemesɩ nɩ Jɔɔn na ɩ a Jebedee bibiir na ɩ a Simon taaba. Ka Yesu 'yɛr kʊ a Simon, “Ta joro dãbãɛ ɛ, an yi dɩna chiine fʊn nyɔɔrɔ na nɩbɛ 'yɔ̃ɔnɔ̃ Nãaŋmɩn nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Be lɛ ba tɔɔ a gborsɩ waan a gogoro nɛɛ wa bar bomo a jaa tɩ turo a Yesu. ");
INSERT INTO biv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu na wa be a tẽe ãsʊɔ pɔ, daba kɔ̃kɔ̃mɔ̃ baal na de a ãgãn wʊ jaa nyɛn a Yesu na wʊ lo kpa tẽe a Yesu niem tɩ sʊɔr wʊ, “N Soro, fʊ̃ʊ sɔɔ, sãa ma.” ");
INSERT INTO biv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ka Yesu tur a wʊ nũu sɩɩr a daba tɩ 'yɛr, “N sɔɔ naa sa.” Ajienaa ka a kɔ̃kɔ̃mɔ̃ baal bar wʊ. ");
INSERT INTO biv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Be lɛ a Yesu 'yɛr kʊ wʊ, “Taa 'yɛrɛ kʊrɔ nɩrɛ ɛ, tɩ chen tɩ wiil a fʊ mãɛ kʊ a Juu nɩbɛ bɔɔrloro na fʊ ir a nɛɛ 'lɔ a Mosesɩ na dɔ̃ɔ 'yɛr ka a di dãasɩɛ ɩka fʊ ɩn nɩsʊ̃.” ");
INSERT INTO biv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tɩchɛ ka a wʊ yele chɛnɛ ŋme yaar a jie wʊ jaa ka a nɩyɔɔ wa chɛlɛ a wʊ 'yɛr ka wʊ sãa a ba baalsɩ. ");
INSERT INTO biv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tɩchɛ wʊ ma chɛnɛ na tɔɔ wʊ mãɛ yin chɛ̃chɛ̃ tɩ sʊɔrɔ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Bɩbir ãsʊɔ Yesu na wile ka a ɩ a Faraseemɩne nɩ a Mosesɩ Nɛɛ wiwiilbe na yi a Galilee tẽbil a jaa nɩ a Judiya ka bamɩne yi a Jerusalɛm mɩ ben be jãnɛ. Ka a Soro kʊ a Yesu kpɛ̃ɔ ɩka wʊ sãan baalsɩ. ");
INSERT INTO biv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dɔɔr bamɩne tuon nɩrɛ nɩ sɔ̃ɔ a nuur nɩ a gbɛɛ na kpi waan bʊɔrɔ ɩka ba kpɛ̃n wʊ tɩ gaal a Yesu niem. ");
INSERT INTO biv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ban ba wa nyɛrɛ sɔr a nɩyɔɔ jũu, ba don naa gar ju tɩ yuo bɔɔ tur bar ka wʊ suun a sɔ̃ɔ a nɩbɛ sãlsɔɔ tɩ gã a Yesu niem. ");
INSERT INTO biv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu na nyɛ a lɛ ban sɔɔ de, ka wʊ 'yɛr kʊ a baalaa, “N baraa, a fʊ yeldɛbɛ vɛ̃n bar.” ");
INSERT INTO biv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ka a nɛɛ wiwiilbe nɩ a Faraseemɩne pãa jɛ̃ tɩɛrɛ, “An lɛ a nyã na jãnɛ fere sɔ̃ɔnɔ̃ a Nãaŋmɩn yuor a nɩtɔ̃? An lɛ na tʊ̃ɔ nɩrɛ yelbier vɛ̃ bar ka Nãaŋmɩn tɛɛ ba lɛ ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu bɔ̃ɔn a lɛ ban tɩɛrɛ ka wʊ sʊʊr ba, “Bo lɛ yɩ tɩɛrɛ a anyã a lɛ a yɩ pʊɔm? ");
INSERT INTO biv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","'Yɛr buor lɛ ɩ kɔ̃mɔ̃kɔ̃mɔ̃? N 'yɛr ɩka a wʊ yeldɛbɛ vɛ̃n bar bɩɩ n 'yɛr ɩka wʊ ir chiine? ");
INSERT INTO biv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tɩchɛ nɩtɔ̃ lɛ yɩn bɔ̃ɔ ɩka a maa Nɩsaal Bie tara na kpɛ̃ɔ a wɛr pɔ na vɛ̃ yeldɛbɛ bar.” Ka wʊ 'yɛr kʊ a dagbɛrɛ, “Fʊ̃ʊ lɛ n 'yɛrɛ nɩ ir 'mɔɔ a fʊ sɔ̃ɔ kulo nɩ.” ");
INSERT INTO biv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ajienaa ka wʊ vaa ir ara a ba niem, 'mɔɔ a wʊ bʊ̃gãnaa pɛɛrɛ Nãaŋmɩn kulo nɩ. ");
INSERT INTO biv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ka nɩrɛ jaa nɛɛ 'maa ka ba dãna Nãaŋmɩn. Ka dãbãɛ kpɛ ba ka ba 'yɛrɛ, “Sɩ nyɛn yelkal bala dɩna.” ");
INSERT INTO biv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","A anyã puor Yesu yin tɩ nyɛ lõpodiere ban bʊɔlɔ Levi na jãnɛ diere wʊ lõposɩ, ka wʊ bʊɔl wʊ, “Ir turo ma.” ");
INSERT INTO biv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ka a Levi vaa ir bar bomo a jaa tɩ turo wʊ. ");
INSERT INTO biv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi maal bʊ̃diir kʊ a Yesu a be a wʊ yir na wʊ bʊɔl a taaba lõpodierbe nɩ nɩyɔɔ ka ba wa 'mataa dire. ");
INSERT INTO biv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tɩchɛ a Faraseemɩne nɩ a Mosesɩ Nɛɛ wiwiilbe hũhũnõ nɩ a yele nyã sʊrɔ a Yesu poturbo, “Bo lɛ so ka yɩ 'mataa dire nɩ a lõpodierbe nɩ a tʊ̃dɛbɛ tʊ̃nbɔ?” ");
INSERT INTO biv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ka Yesu 'yɛr kʊ ba, “A ba ɩ nɩrɛ na kpɛ̃mɛ lɛ chiine tɩtɩlɛ jie ɛ, tɩchɛ baalaa lɛ ma chen. ");
INSERT INTO biv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","N ba wa ɩka n wa bʊɔl a nɩtorsɩ ɛ, n wa naa ɩka n wa bʊɔl a tʊ̃dɛbɛ tʊ̃nbɔ ka ba wa lɩɛb tɩɛr.” ");
INSERT INTO biv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ka ba lɛ sʊʊr a Yesu, “Ŋmɩnɛ a ɩ ka Jɔɔn poturbo nɩ a Faraseemɩne poturbo ma jɛ̃n kɔ̃ sʊɔrɔ Nãaŋmɩn, tɩchɛ ka a fʊ̃ʊ poturbo ma tɔ̃ɔ kpal a dib nɩ a nyũfʊ a lɛ a tɔ̃tɔ̃?” ");
INSERT INTO biv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ka a Yesu sʊʊr ba, “Fʊn tʊ̃ɔ maal a bala ban bʊɔl a pɔɔ paalaa jie ka ba jɛ̃n kɔ̃ a pɔɔ paalaa sɩrɛ na chɛnɛ be a ba sɛ̃ ɔ? ");
INSERT INTO biv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tɩchɛ bɩbir kɔ̃ɔ na wa vɩɛ naa ka a pɔɔ paalaa sɩrɛ yi a ba sɛ̃, a ber ala pɔ 'lɔ ban jɛ̃n nɩ kɔ̃.” ");
INSERT INTO biv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sʊkpa nyã lɛ wʊ lɔb kʊ ba, “Nɩrɛ maa ŋmaa fɔpaalaa sɛ choo fɔkoraa pɔ ɛ, 'lɔ be ɩ a lɛ a fɔpaalaa na chɩɛraa a fɔkoraa, bʊ̃paalaa nɩ bʊ̃koraa kʊ̃ tʊ̃ɔ 'mataa ɛ. ");
INSERT INTO biv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nɩrɛ maa 'yɔ̃ɔ dãbãɩn a dãa wɔkoraa pɔ ɛ, 'lɔ be ɩ a lɛ a dãbãɩn na pur naa a wʊɔ ka a dãa kpaar ka a wʊɔ mɩ sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ba ma den dãbãɩn 'yɔ̃ɔ a dãa wɔpaalaa pɔ. ");
INSERT INTO biv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nɩrɛ wa nyũ a dãgaa wʊ maa lɛ bʊɔrɔ a dãbãɩn ɛ, wʊ ma 'yɛr ɩka a dãgaa ɩn gar a dãbãɩn.” ");
INSERT INTO biv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","A Pɛ̃nfʊ Bɩbir ãsʊɔ daar, Yesu nɩ a wʊ poturbo kpɛ̃n tala a puo sãlsɔɔ, ka a wʊ poturbo piel fɔrɔ a bʊ̃bie na ba ŋmɩɛnɛ nɩ a nuur ɔɔrɔ. ");
INSERT INTO biv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ka a Farasee bamɩne sʊʊr ba, “Bo lɛ yɩ ɩrɛ a lɛ na ba tara sɔr a Pɛ̃nfʊ Bɩbir Daar ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ka a Yesu 'yɛr kʊ ba, “Yaa kar a Nãaŋmɩn gãn pɔ nyɛ a lɛ a David na dɔ̃ɔ ɩ nɩ a wʊ nɩbɛ a kɔ̃ na kpɛ ba ɛ? ");
INSERT INTO biv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wʊ kpɛ̃n a Nãaŋmɩn yir tɩ de a paanʊ̃ɔ ala ban bin kʊ Nãaŋmɩn na wʊ 'wɔb an ba tara sɔr ɛ, ka a Nãaŋmɩn bɔɔrlorbo tɛɛ ba lɛ ɛ. Tɩ de amɩne mɩ kʊ a wʊ nɩbɛ.” ");
INSERT INTO biv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ka a Yesu pãa 'yɛr kʊ ba, “Maa Nɩsaal Bie lɛ ɩ a Pɛ̃nfʊ Bɩbir Soro.” ");
INSERT INTO biv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A Pɛ̃nfʊ Bɩbir Daar ãsʊɔ, wʊ ben a ba lɔ̃ɔfʊ yir na wʊ wile, ka a daba ãsʊɔ be be a nũsʊ̃ɔ na kpi. ");
INSERT INTO biv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A Faraseemɩne nɩ a nɛɛ wiwiilbe bʊɔrɔ sɔr na gar 'yɔ̃ɔ a Yesu, lɛ lɛ ba tɔɔ gbʊr kaara wʊ ɩka ba kaa ala ɩ wʊn sãan a baal a Pɛ̃nfʊ Bɩbir ɔ. ");
INSERT INTO biv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tɩchɛ Yesu bɔ̃ɔn a lɛ ban tɩɛrɛ na wʊ 'yɛr kʊ a daba 'lɔ nũu na kpi, “Ir ara ka nɩrɛ jaa nyɛ fʊ.” Ka a daba ir ara. ");
INSERT INTO biv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ka a Yesu pãa 'yɛr kʊ ba, “N sʊʊr yɩ kaa, bo lɛ sɛɛ ɩka a maal a Pɛ̃nfʊ Bɩbir Daar, fʊ maal vɩla bɩɩ fʊ maal dɛɛr? Fʊ kʊ nɩrɛ bɩɩ fʊ faa nɩrɛ, bɩɩ fʊ sɔ̃ɔ bar?” ");
INSERT INTO biv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wʊ kãan ba jaa gʊɔr tɩ 'yɛr a daba, “Tur a fʊ nũu.” A wʊ tur ka a nũu wʊ jaa sa. ");
INSERT INTO biv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tɩchɛ ka a suur kpɛ ba ka ba guoro taa a lɛ ban na ɩ a Yesu. ");
INSERT INTO biv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","A ber ala ãsʊɔ pɔ, Yesu don a tɔ̃ɔ ju Nãaŋmɩn sʊɔrfʊ jie, wʊ sʊɔr Nãaŋmɩn a tãsɔɔ 'lɔ wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","A wɛr na wa chaar a bibio, wʊ bʊɔl naa a poturbo ka ba wa a wʊ sɛ̃, ka wʊ ir a ba pɔ pie nɩ ayi bʊɔlɔ ba nɩtʊ̃nsɩ. ");
INSERT INTO biv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","A bala wʊn ir lɛ, Simon wʊn lɛ kʊ yopaalaa Pita, nɩ a wʊ yɛbɛ Andiru, Jemesɩ, Jɔɔn, Filip, Batolomi, ");
INSERT INTO biv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu, Tomasɩ, Jemesɩ na ɩ Alfayasɩ bidaba, Simon na mʊ̃ɔ nɩbir nɩ a wʊ wɛr yele, ");
INSERT INTO biv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemesɩ bidaba Judas, nɩ a Judas Isɩkariyot 'lɔ lɛ wa ɩ a gagaraa. ");
INSERT INTO biv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu tara ban suun ka ba tɩ ara a jie 'lɔ na jãtaa, kaa poturbo yɔɔ be be, ka a nɩyɔɔ mɩ yi Judiya, Jerusalɛm, ka bamɩne mɩ yi a Tire tẽe nɩ a Sidon tẽe na be a man koor. ");
INSERT INTO biv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ba wa naa ɩka ba wa chɛl a wʊ 'yɛr tɩ wʊ sãa a ba baalsɩ. Wʊ sãan a bala ba jaa na tara a sɩdɛbɛ. ");
INSERT INTO biv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ka a nɩyɔɔ bala dɔ̃ɔnɔ̃ taa bʊɔrɔ a Yesu sɩɩrfʊ bojũu kpɛ̃ɔ yire naa a wʊ pɔ sãana a ba jaa baalsɩ. ");
INSERT INTO biv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu kaara naa a wʊ poturbo tɩ 'yɛr, “Pʊpɛl lɛ kʊ a yɩn banyãna na ɩ a nɔ̃n dẽme. Yɩn lɛ so a Nãaŋmɩn nãalʊ̃ʊ. ");
INSERT INTO biv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Pʊpɛl lɛ kʊ a yɩn a kɔ̃ na kpɛ pʊ̃pãanyã yɩn lɛ na wa tɩɩ. Pʊpɛl lɛ kʊ a yɩn na kõnõ a pʊ̃pãanyã, yɩn wa laara naa. ");
INSERT INTO biv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Pʊpɛl lɛ kʊ yɩ a nɩbɛ na wa 'laar yɩ, na ba oo yɩ bar, tɩ tʊrɔ yɩ na ba sɔ̃ɔnɔ̃ a yɩ yuor fɩka bʊ̃dɛɛr a maa Nɩsaal Bie jũu. ");
INSERT INTO biv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","A bɩbir nyã wa vɩɛ yɩ chɩlɛ nɩ pʊpɛl, bojũu a yɩ sãyar waa naa na be a saaju. Lɛ lɛ a ba sãakpãmɩne dɔ̃ɔ maal a Nãaŋmɩn 'yɛ'yɛrbɛ. ");
INSERT INTO biv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nɛbier pɔɔn a yɩn na ɩ a tara dẽme, yɩn 'lɔ nyɛn a yɩ 'maalfʊ. ");
INSERT INTO biv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nɛbier kpɛ̃n a yɩn na tɩɩ a pʊ̃pãanyã kɔ̃ na kpɛ yɩ naa. Nɛbier kpɛ̃n a yɩn na laara a pʊ̃pãanyã, yɩn lɛ nɩbaal na wa kpɛ a yɩ kõnõ. ");
INSERT INTO biv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nɛbier kpɛ̃n a yɩn nɩbɛ jaa na bʊɔlɔ yɩ yo sʊ̃, lɛ lɛ a ba sãakpãmɩne mɩ dɔ̃ɔ bʊɔlɔ a jir 'yɛ'yɛrbɛ a yosʊ̃n. ");
INSERT INTO biv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Tɩchɛ n 'yɛrɛ na kʊrɔ a yɩn na chɛlɛ a n 'yɛr, yɩ nʊ̃ a yɩ dɔ̃dɔ̃mɔ̃sɩ na yɩ maal vɩla kʊ a bala na 'laar yɩ. ");
INSERT INTO biv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yɩ 'yɛr nɛvɩla 'yɔ̃ɔ a bala na pɔ 'yɔ̃ɔ yɩ, na yɩ sʊɔrɔ Nãaŋmɩn kʊrɔ a bala na gere yɩ. ");
INSERT INTO biv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nɩrɛ wa 'ma fʊ tʊkpal pɔ, lɛ lɩɛb a bʊ̃'yen ka wʊ lɛ 'ma, nɩrɛ wa de a fʊ fuu kpɛ̃ɛ ta mɔ̃ɔ wʊ a fuu bile ɛ. ");
INSERT INTO biv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nɩrɛ jaa wa sʊɔr fʊ bon de kʊ wʊ, nɩrɛ wa de a fʊ bon taa lɛ wa sʊrɔ wʊ go ɛ. ");
INSERT INTO biv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","A lɛ yɩn bʊɔrɔ ɩka a nɩbɛ ba maal kʊ yɩ, yɩ mɩ maal a lɛ kʊ ba. ");
INSERT INTO biv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ala ɩ yɩ nʊ̃ naa a bala na nʊ̃ yɩ, yobuor lɛ yɩ nyɛ? A yelbetʊ̃nbɔ gba mɩ nʊ̃n a bala na nʊ̃ ba. ");
INSERT INTO biv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ala ɩ yɩ maala na vɩla kʊrɔ a bala na maal yɩ a vɩla, yobuor lɛ yɩn nyɛ? A yelbetʊ̃nbɔ gba mɩ ɩrɛ naa a lɛ. ");
INSERT INTO biv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ka ala ɩ fʊ pɛ̃ɛn a bala fʊn tɩɛr ɩka ban wa yab fʊ naa, yobuor lɛ yɩn wa nyɛ? A yelbetʊ̃nbɔ ma pɛ̃ɛn a ba taaba tɩɛrɛ ɩka ban wa yab a jaa. ");
INSERT INTO biv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tɩchɛ yɩ nʊ̃ a yɩ dɔ̃dɔ̃mɔ̃sɩ na yɩ maal vɩla kʊ ba, yɩ pɛ̃ɛ ba na yɩ taa chɛlɛ ɩka ba lɛ wa yab yɩ ɛ. Ala lɛ a yɩ sãyar na waa, ka yɩ na ɩ a saaju Nãaŋmɩn bibiir, bojũu 'lɔ lɛ maala vɩla kʊrɔ a nɩhayasɩ nɩ putudẽme. ");
INSERT INTO biv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yɩ ɩ nɩbibaal dẽme nɩtãa lɛ a yɩ Sãa na ɩ a nɩbibaal sʊɔ. ");
INSERT INTO biv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Yɩ ta tɔɔr nɩrɛ 'yɛr ɛ, ka Nãaŋmɩn mɩ wa tɔɔr a yɩ 'yɛr ɛ. Yɩ ta 'yɔ̃ɔ nɩrɛ 'yɛr ɛ, ka Nãaŋmɩn mɩ ta 'yɔ̃ɔ yɩ 'yɛr ɛ. Yɩ vɛ̃ kʊ nɩrɛ ka Nãaŋmɩn mɩ vɛ̃ kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yɩ de tɩr, Nãaŋmɩn mɩn kʊ yɩ naa, man vɩla tɩ dib 'yɔ̃ɔ tɩ yɛ yɛɛ ka a yaara, an kpaar dɔɔl a yɩ gbɛɛ ju. A bon 'lɔ yɩn man tɩr, 'lɔ mɩ lɛ a Nãaŋmɩn na man kʊ yɩ.” ");
INSERT INTO biv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sʊkpa nyã lɛ a Yesu lɛ lɔb kʊ ba, “Jɔ̃ɔ na tʊ̃ɔn jɔ̃ɔ tɔɔ? Ba jaa ayi kʊ̃ lo bɔɔ pɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nɩrɛ na jãna wʊ kʊ̃ tʊ̃ɔ gar a wʊ wiwile ɛ, tɩ 'lɔ wa jãn baar wʊn tʊ̃ɔ kaara a wʊ wiwile kaar. ");
INSERT INTO biv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ŋmɩnɛ a fʊ kaara a dabile na be a fʊ yɛbɛ nɩbir pɔ, tɩ ba chɛlɛ a dakpɛ̃ɛ na be a fʊ̃ʊ nɩbir pɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bɩɩ Ŋmɩnɛ a ɩ ka fʊ 'yɛr kʊ a fʊ yɛbɛ, n yɛbɛ vɛ̃ ka n ir a a dabile bar a fʊ nɩbir pɔ, tɩ ba ire a dakpɛ̃ɛ na be a fʊ̃ʊ nɩbir pɔ ɛ? Fʊ̃ʊ nɩbɛlɛ nyã, de nie ir a dakpɛ̃ɛ a fʊ nɩbir pɔ bar na fʊ pãa nyɛrɛ tʊ̃ɔ ir a dabile a fʊ yɛbɛ nɩbir pɔ bar. ");
INSERT INTO biv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Tɩsʊ̃ ba wɔ̃nɔ̃ bidɛbɛ ɛ, bɩɩ tɩdɛɛr mɩ ba wɔ̃nɔ̃ bisʊ̃n ɛ. ");
INSERT INTO biv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tɩɛ jaa a wʊ wɔ̃mɔ̃ lɛ ba ma de bɔ̃ɔn wʊ. Ba maa pɔr kɔ̃kɔ̃ɔ gʊtɩɛ ju ɛ, bɩɩ pɔr 'wɔ̃rɔ tamiir tɩɛ ju ɛ. ");
INSERT INTO biv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nɩsʊ̃ a yelsʊ̃ ala na be a wʊ pʊɔm lɛ wʊ ma 'yɛrɛ, ka a nɩdɛɛr mɩ ma 'yɛrɛ a yeldɛbɛ ala na be a wʊ pʊɔm. Ala na sɛɛ a pʊɔ lɛ a nɛɛ ma 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ŋmɩnɛ a yɩ bʊɔlɔ ma ɩka Soro, tɩ na yaa turo a lɛ ɩn 'yɛr ɛ? ");
INSERT INTO biv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nɩrɛ jaa na wa a n sɛ̃ na wʊ wõ a n 'yɛr tɩ maala, ɩn wiil yɩ naa a lɛ wʊn be. ");
INSERT INTO biv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wʊ kaara fɩka nɩrɛ na mɩɛrɛ yir na wʊ tuu a dachin par kparaa bɔɔ tɩ pɔɔn kʊsɩr na mɛ a dachin dɔɔl. Kʊ̃ɔ wa yaar yi jilʊ̃ a yir, ka a kɔ̃sɛbɛ ŋmiere a yir tɩ waa dam ɛ, bojũu ba mɛ wʊn sʊ̃. ");
INSERT INTO biv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tɩchɛ nɩrɛ 'lɔ na wõ a n 'yɛr tɩ na waa maala ɛ, wʊ kaara fɩka nɩrɛ na mɛ yir dɔɔl a tãn mʊɔr ju, waa tuu tɩ mɛ ɛ. A kɔ̃sɛbɛ wa yin ŋme a dachin, ka a dachin wʊ jaa lo ŋmɛr.” ");
INSERT INTO biv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","A lɛ a nɩbɛ na wõ a 'yɛrsɩ anyãna a Yesu na 'yɛr kʊ ba baar wʊ chen a Kapenahum. ");
INSERT INTO biv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Be lɛ a soja nɩdiere gbãgbaa wʊn nʊ̃ yɔɔ jaa bɩɛrɛ ɩrɛ na ŋmaa vʊʊr. ");
INSERT INTO biv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Soja nɩdiere na wõ a Yesu yele, wʊ tʊ̃n a Juu nɩbɛ nɩdierbe bamɩne ka ba tɩ sʊɔr a Yesu ka wʊ wa sãa a wʊ gbãgbaa. ");
INSERT INTO biv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ba wan a Yesu sɛ̃ wa sʊɔr wʊ yãayãabɩlɛ 'yɛrɛ, “A daba nyã sɛɛ naa ɩka fʊ tɩ sʊ̃ʊ wʊ, ");
INSERT INTO biv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","bojũu wʊ nʊ̃n a sɩ nɩbɛ na vɛ̃ ka ba mɛ a sɩ lɔ̃ɔfʊ jie.” ");
INSERT INTO biv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu pɔɔ ba naa ka ba 'mataa chiine tɩ gbʊrɔ a daba yir, ka wʊ tʊ̃ a wʊ barmɩne ka ba tuor 'yɛr a Yesu ɩka. “N Soro, ta bal a fʊ mãɛ ɛ, bojũu n ba sɛɛ ka fʊn wa kpɛ a n yir ɛ. ");
INSERT INTO biv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ala lɛ so gba maa mãɛ na ba 'la wa a fʊ sɛ̃ ɛ. Tɩchɛ 'yɛr bir tɛɛ an sãan a n gbãgbaa. ");
INSERT INTO biv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bojũu maa mãɛ tara na nɩbɛrɛ ɩn joro dãbãɛ, naa mɩ tara a sojasɩ ka ba mɩ be a n pĩlem. Maa 'yɛr kʊ ãsʊɔ ɩka wʊ, chen wʊ ma chen naa, bɩɩ ãsʊɔ ɩka wʊ wa, wʊ ma wa naa. N ma 'yɛr kʊ a n gbãgbaa, maal anyã, ka wʊ ma maal.” ");
INSERT INTO biv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","A lɛ a Yesu na wõ a nɩtɔ̃ a daba nyã na ba ɩ a Juu nɩrɛ na 'yɛr, ka nɛ'maa wʊ, ka wʊ lɩɛb 'yɛr kʊ a nɩyɔɔ bala. “A Isɩral nɩbɛ pɔ gba, n ba nyɛ a sɔɔfʊ nyã bʊrɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ka a wʊ barmɩne bala wʊn tʊ̃ lɩɛb kpɛ a yir tɩ nyɛ ka a gbãgbaa sa. ");
INSERT INTO biv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ala lɛ a wɛr chaar ka Yesu nɩ a wʊ poturbo 'matãan nɩyɔɔ na turo wʊ ka ba 'mantaa chen a tẽe ban bʊɔlɔ Nain. ");
INSERT INTO biv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wʊn wa gbʊr a tẽe dɔ̃dɔr kpɩɛraa ba tuon kũu wa yin na ɩ a pɔɔ bidabʊ̃'yen tɩ wʊ ɩ pɔɔkʊɔr. Ka a tẽe 'lɔ nɩbɛ yɔɔ mɩ pʊɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","A lɛ a Soro na wa nyɛ a pɔɔ, nɩbaal kpɛ wʊ naa ka wʊ 'yɛr kʊ a pɔɔ, “Ta kõnõ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tɩ na wʊ chen tɩ sɩɩr a kũu ban tuo, ka a bala na tuo a ba ara. Ka a Yesu 'yɛr, “Pɔlbile, fʊ̃ʊ lɛ n 'yɛrɛ nɩ ir.” ");
INSERT INTO biv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ka a kũu vaa ir jãnɛ tɩ piel na wʊ 'yɛrɛ ka Yesu de wʊ kʊ a ma. ");
INSERT INTO biv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dãbãɛ kpɛ̃n ba jaa ka ba pɛɛrɛ Nãaŋmɩn 'yɛrɛ nɩ, “Nãaŋmɩn 'yɛ'yɛrkpɛ̃ɛ ãsʊɔ lɛ yi sɩ, Nãaŋmɩn wan ɩka wʊ wa sʊ̃ʊ a wʊ nɩbɛ.” ");
INSERT INTO biv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ka a Yesu yele ŋme yaar a Judiya paal wʊ jaa nɩ a tẽn ala na gbʊr. ");
INSERT INTO biv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jɔɔn poturbo tɩ man a yele anyã a jaa kʊ wʊ, ka wʊ bʊɔl a ba ayi ");
INSERT INTO biv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na wʊ tʊ̃ ba a Soro sɛ̃ ka ba tɩ sʊʊr wʊ kaa, “Fʊ̃ʊ ɩ a 'lɔ na wa bɩɩ sɩ chɛlɛ nɩyuo?” ");
INSERT INTO biv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ka a nɩbɛ bala wa a Yesu sɛ̃ wa 'yɛr, “A Jɔɔn kɔ̃suor lɛ tʊ̃ sɩ a fʊ sɛ̃ ɩka sɩ wa sʊʊr fʊ kaa, fʊ̃ʊ lɛ ɩ a 'lɔ na wa bɩɩ sɩ chɛlɛ nɩyuo?” ");
INSERT INTO biv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A sɔ̃ɔ 'lɔ̃nɔ̃ mɩ lɛ Yesu sãa baalsɩ, bala na tara a sɩdɛbɛ na wʊ yuon jɔ̃n nɩbie. ");
INSERT INTO biv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ka wʊ 'yɛr kʊ a bala a Jɔɔn na tʊ̃, “Yɩ lɩɛb kul tɩ man kʊ a Jɔɔn a lɛ yɩn nyɛ tɩ wõ, jɔ̃n nyɛrɛ naa ka gbɛrsɩ chiine ka kɔ̃kɔ̃n sa, ka wõn wõnõ, ka kũusɩ ir ɩ vʊɛ, ka a 'yɛr nʊ̃ɔ mɩ ta a nɔ̃n dẽme. ");
INSERT INTO biv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pʊpɛl sʊɔ lɛ a 'lɔ a n yele na ba bãr wʊ lɔb ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","A bala a Jɔɔn na tʊ̃ na wa chen baar, Yesu piel 'yɛrɛ a Jɔɔn 'yɛr kʊrɔ a nɩyɔɔ bala, “Bo lɛ yɩ dɔ̃ɔ kpɛ a mɔgɔ̃ɔ pɔ a kaafʊ jie? A jɩmur a sɛsɛbɛ na dɔ̃ɔnɔ̃ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ala ba ɩ lɛ ɛ, bo yɩ chen tɩ nyɛ? Daba na su bʊ̃pɩɛl ɔ? Kai, a bala na suro a bʊ̃sʊ̃n, na ba dire a bʊ̃sʊ̃n nãa yir lɛ ba ma be. ");
INSERT INTO biv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tɩchɛ bo lɛ yɩ tɩ nyɛ? Nãaŋmɩn 'yɛ'yɛrɛ ɔ. Ɔ̃ɔ, n 'yɛrɛ na kʊrɔ yɩ ɩka wʊ gar Nãaŋmɩn 'yɛ'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","A anyã yele lɛ sɛb a Nãaŋmɩn gãn pɔ ɩka, ‘Ɩn tʊ̃ naa a n tʊ̃tʊ̃nɔ̃ ka wʊ de a fʊ nie na wʊ tɩ chɔɔr a fʊ sɔr kʊ fʊ.’ ");
INSERT INTO biv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","N 'yɛrɛ na kʊrɔ yɩ ɩka bala pɔɔ na dɔɔ ka a wɛr pɔ ba ɩ kpɛ̃ɛ gar a Jɔɔn ɛ, tɩchɛ 'lɔ mɩ na ɩ jaa pʊʊr a Nãaŋmɩn nãalʊ̃ʊ pɔ gar wʊ naa.” ");
INSERT INTO biv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ka a nɩbɛ ba jaa lɔ̃ɔn a lõpodierbe gba na wõ a lɛ a Yesu na 'yɛr, ba sɔɔ naa ɩka Nãaŋmɩn yele tor naa, na ba sɔɔ ka a Jɔɔn so ba a Nãaŋmɩn kʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tɩchɛ a Faraseemɩne nɩ a bala na bɔ̃ɔ a Mosesɩ Nɛɛ, bala mãɛ tɔr naa a lɛ a Nãaŋmɩn na bʊɔrɔ, bojũu baa sɔɔ ka a Jɔɔn so ba a Nãaŋmɩn kʊ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ka a Yesu 'yɛr kʊ ba, “Ba boo lɛ ɩn de a dɩna nɩbɛ naa man? Bo lɛ ba nyɛtãan? ");
INSERT INTO biv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ba nyɛntãan bibiir na jãnɛ daa pɔ bʊɔlɔ taa, ‘Sɩ pɛɛlɛ naa a laa 'lɩr tɩ yaa sɛɛrɛ bãnɛ ɛ, na sɩ kõnõ kõyiel tɩ yaa ŋmara nɩbikʊ̃ɔ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","A Jɔɔn kɔ̃suor na wa, waa dire bʊ̃diir ɛ, waa nyuro dãa ɛ, ka yɩ 'yɛr ɩka sɩdɛɛr lɛ wʊ tara. ");
INSERT INTO biv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ka a maa Nɩsaal Bie wa na n dire na n nyuro ka yɩ lɛ 'yɛr, ‘Wʊ dire na ba gala ɛ, na wʊ nyuro dãa, na wʊ ɩ a lõpodierbe nɩ a tʊ̃dɛtʊ̃nbɔ baraa.’ ");
INSERT INTO biv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tɩchɛ a yɛ̃ ma wiil a lɛ wʊn tor a wʊ bibiir pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","A Farasee nɩrɛ ãsʊɔ bʊɔl a Yesu ɩka wʊ wa di bʊ̃diir a wʊ yir, ka wʊ chen a Farasee nɩrɛ 'lɔ yir tɩ jãnɛ a bʊ̃diir difʊ jie. ");
INSERT INTO biv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pɔɔ ben a tẽe pɔ na wʊ tʊ̃nɔ̃ tʊ̃dɛbɛ, wʊn wa wõ ɩka a Yesu ben a Farasee yir, wʊ den a kãnyũvɩla na sɛɛ pãrtɔbile na wʊ chiin. ");
INSERT INTO biv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wʊ tɩ kpɛ̃n naa na wʊ ara a Yesu gbɛɛ par kõnõ. Wʊ soor a nɩbikʊ̃ɔ 'maan a Yesu gbɛɛ tɩ nyɔɔ a jukɔɔl fɩɛl bar, tɩ mʊʊr a gbɛɛ tɩ kpaar a kãnyũvɩla ala 'yɔ̃ɔ a Yesu gbɛɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ka a Farasee nɩrɛ 'lɔ na bʊɔl wʊ ka wʊ tɩ dire, na nyɛ a lɛ ka wʊ tɩɛr, “Ala ɩ a daba nyãna ta ɩn Nãaŋmɩn 'yɛ'yɛrɛ wʊn taa bɔ̃ɔn naa a pɔɔ nyãna tɔ sʊɔ na sɩrɛ wʊ, wʊ tʊ̃nɔ̃ na tʊ̃dɛbɛ.” ");
INSERT INTO biv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ka a Yesu 'yɛr sɔɔ wʊ, “Simon, n tara na 'yɛr na sʊʊr fʊ.” Ka a Simon 'yɛr, “Wiwile, sʊʊr ma.” ");
INSERT INTO biv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ka a Yesu 'yɛr, “Nɩbɛ ayi kɔ̃ɔ lɛ tɩ pɛ̃ɛ nɩrɛ ãsʊɔ libie, ãsʊɔ pɛ̃ɛn kɔɔr anũu (500) ka ãsʊɔ mɩ pɛ̃ɛ lɩjaayi nɩ pie (50). ");
INSERT INTO biv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","A nɩbɛ ayi banyãna ãsʊɔ jaa ba tara a libie na yab wʊ ɛ, ka a 'lɔ na so a libie 'yɛr, ‘Yɩ ta lɛ yab go ɛ, a sãn baar naa.’ Buor sʊɔ lɛ na nʊ̃ wʊ yɔɔ?” ");
INSERT INTO biv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ka a Simon 'yɛr, “N tɩɛr ɩka a 'lɔ sãn na waa lɛ.” Ka a Yesu 'yɛr, “Sɩrɛ fʊ 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu lɩɛb tor a pɔɔ tɩ pãa 'yɛr kʊ a Simon, “Fʊ nyɛn a pɔɔ nyãna? Ɩn wa kpɛ a fʊ yir, faa kʊ ma kʊ̃ɔ ɩka n pɛɛ gbɛɛ ɛ, tɩchɛ a pɔɔ pɛɛn a n gbɛɛ nɩ a wʊ nɩbikʊ̃ɔ tɩ de a wʊ jukɔɔl fɩɛl bar. ");
INSERT INTO biv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Faa sʊʊr ma kpãɛn ɛ, tɩchɛ a sɔ̃ɔ 'lɔ jaa ɩn wa kpɛ a pɔɔ nyã ba bar ma kpãɛn sʊʊrfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Faa pur kãa 'yɔ̃ɔ ma a ju pɔ ɛ, tɩchɛ a pɔɔ kpaar a kãnyũvɩla 'yɔ̃ɔ ma a gbɛɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","A lɛ jũu n 'yɛrɛ na kʊrɔ fʊ ɩka a wʊ tʊ̃dɛbɛ ala a jaa vɛ̃n kʊ wʊ, bojũu a wʊ nʊ̃fʊ waa naa. Tɩchɛ a 'lɔ Nãaŋmɩn na vɛ̃ jaa pʊʊr kʊ a wʊ nʊ̃fʊ mɩ ɩn jaa pʊʊr.” ");
INSERT INTO biv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","A Yesu pãa 'yɛr kʊ a pɔɔ, “A fʊ yeldɛbɛ vɛ̃n bar.” ");
INSERT INTO biv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ka a bala na lɔ̃ɔ jɛ̃n wʊ 'yɛrɛ kʊrɔ taa, “An lɛ anyã, na wʊ mɩ ma vɛ̃ nɩrɛ yeldɛɛr bar?” ");
INSERT INTO biv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A Yesu 'yɛr kʊ a pɔɔ, “A fʊ sɔɔfʊ faa fʊ naa, chiine nɩ nyã'maar.” ");
INSERT INTO biv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A anyãna puor, Yesu yɔn a tẽbɛrɛ nɩ a tẽbil 'yɛrɛ a Nãaŋmɩn nãalʊ̃ʊ 'yɛr kʊrɔ ba ka a wʊ nɩtʊ̃nsɩ Pie nɩ Ayi pʊɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ka a pɔbɔ bamɩne mɩ pʊɔ wʊ, bala lɛ wʊ dɔ̃ɔ dii a sɩdɛbɛ ka a yi na wʊ sãa a ba baalsɩ, ãsʊɔ lɛ ba bʊɔlɔ Mɛɛr na yi a Magdala 'lɔ lɛ wʊ dii a sɩdɛbɛ ayopõi ka a yi, ");
INSERT INTO biv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana lɛ a ãsʊɔ na ɩ a Kuja na kaara a Hɛrɔd yir pɔɔ, Susana lɛ a ãsʊɔ nɩ a pɔbɔ yɔɔ bamɩne. Banyãna lɛ de a ba bomo sʊ̃nɔ̃ nɩ a Yesu nɩ a wʊ poturbo. ");
INSERT INTO biv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nɩyɔɔ yin tẽn tẽn waara a Yesu sɛ̃, a nɩyɔɔ banyãna na wa duo, sʊkpa nyã lɛ wʊ lɔb kʊ ba, ");
INSERT INTO biv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kʊɔraa lɛ yin wʊ bʊ̃bʊrɔ bʊrfʊ jie. Wʊ tɩ yaara naa yʊɔrɔ nɩ ka amɩne tɩ lo sɔr pɔ, ka ba nɛ nɛb ka lubil wa tuur di. ");
INSERT INTO biv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ka amɩne mɩ tɩ lo kʊsɩr pãn ju naa bul tɩ kpi bojũu tãn ba be be ɛ. ");
INSERT INTO biv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ka amɩne mɩ lo gʊʊr pɔ 'mataa bul ka a gʊʊr nʊ̃ɔ fãɩn ba. ");
INSERT INTO biv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tɩchɛ ka amɩne mɩ lo a kɔjɔ̃ pɔ bul dɔɔ jur kɔɔkɔɔr naa gar a lɛ wʊn bʊr.” Yesu na wa 'yɛr a nɩtɔ̃ baar, wʊ 'yɛr kpɛ̃ɔ jaa, “Nɩrɛ 'lɔ na tara tuor wõnõ nɩ wʊ chɛlɛ.” ");
INSERT INTO biv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ka a wʊ poturbo sʊʊr wʊ a sʊkpa nyã par. ");
INSERT INTO biv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A wʊ 'yɛr kʊ ba, “Yɩn 'lɔ, n vɛ̃ naa ka yɩ bɔ̃ɔ a Nãaŋmɩn nãalʊ̃ʊ yelsɔɔlsɩ, tɩchɛ a bala na chɛ, sʊkpar lɛ n 'yɛrɛ kʊrɔ ba, ‘Ba ma kaa naa tɩ maa nyɛ ɛ, na ba ma wõnõ tɩ ba bɔ̃ɔ a par ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“A sʊkpa par nɩ nyã. Nãaŋmɩn 'yɛr lɛ ɩ a bʊ̃bie. ");
INSERT INTO biv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A ala na lo a sɔr pɔ ɩn a bala na wõ a Nãaŋmɩn 'yɛr, tɩchɛ ka a tɩɩ wa ir naa a ba nyãa pɔ, ka ba ta sɔɔ de nyɛ faafʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ala mɩ na lo a kʊsɩr pãn ju ɩn a bala na wõ a 'yɛr den pʊpɛl, tɩchɛ baa tara nyɩbɛ ɛ. Ba sɔɔn ara bãlãa tɩchɛ bɛɛr kaa wa wa ba ma lo naa. ");
INSERT INTO biv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A bʊ̃bie ala na lo a gʊʊr pɔ ɩn a bala na wõ a 'yɛr, tɩchɛ ka a ãgãn nyã vɔlaa nɩ bʊ̃tarsɩ nɩ a bʊ̃bʊɔrsɩ fãɩn ba ka baa tʊ̃ɔ dɔɔ bie ɛ. ");
INSERT INTO biv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tɩchɛ a bʊ̃bie ala na lo a kɔjɔ̃ pɔ, ɩn a bala na wõ a 'yɛr na ba sɔɔ den nyãa ara nɩ pʊpɛl, ka a kãnyir vɛ̃ ka ba dɔɔ jur. ");
INSERT INTO biv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nɩrɛ jaa maa chʊm fãtɩn de laa kpa pɔɔ ɛ, bɩɩ de su gado pĩlem ɛ. Tɩchɛ wʊ ma den dɔɔl a dɔɔlfʊ jie ka a bala na kpɩɛrɛ nyɛ a chãa. ");
INSERT INTO biv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bojũu bon jaa ba be be na sɔɔl ka ba kʊ̃ nyɛ wʊ ɛ, bɩɩ bon jaa ba be be sɔɔl ka ba kʊ̃ bɔ̃ɔn ɛ, bɩɩ kʊ̃ yi chãa pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","A lɛ jũu, yɩ bɔ̃ɔnɔ̃ sʊ̃ a lɛ yɩn chɛlɛ. Nɩrɛ 'lɔ na bɔ̃ɔ a par Nãaŋmɩn na lɛ kʊ wʊn dɔɔl, nɩrɛ 'lɔ mɩ na ba bɔ̃ɔ a par ɛ, Nãaŋmɩn na den a bãlãa 'lɔ wʊn tɩɛr ɩka wʊ bɔ̃ɔn a par.” ");
INSERT INTO biv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu ma nɩ a wʊ yɛɛr wan ɩka ba wa nyɛ wʊ, tɩchɛ a nɩyɔɔ jũu ba kʊ̃ tʊ̃ɔ kpɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ka nɩrɛ ãsʊɔ 'yɛr wʊ, “A fʊ ma nɩ a fʊ yɛɛr lɛ be a yõo bʊɔrɔ ɩka ba nyɛ fʊ.” ");
INSERT INTO biv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A Yesu 'yɛr, “N ma nɩ a n yɛɛr lɛ a bala na wõ a Nãaŋmɩn 'yɛr na ba turo.” ");
INSERT INTO biv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bɩbir ãsʊɔ lɛ a Yesu 'yɛr kʊ a wʊ poturbo, “Yɩ ɩ a sɩ gɔ̃ɔ a kasɛn a manyal gɔ̃ɔn.” Be lɛ ba kpɛ a gboro na ba gɔ̃ɔnɔ̃. ");
INSERT INTO biv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ban gɔ̃ɔnɔ̃ tɩ wʊ gã gur. Ka a kɔ̃sɛkpɛ̃ɛ ire a man pɔ ka a kʊ̃ɔ ɔɔrɔ kpɩɛrɛ a gboro pɔ, ka ba ɩrɛ na mʊr. ");
INSERT INTO biv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ka a poturbo tɩ sãɩ wʊ 'yɛrɛ, “Kpãkpãana, a kʊ̃ɔ na di sɩ naa.” Ka a Yesu ir tãn a sɛsɛbɛ nɩ a kʊ̃ɔ na ɔɔrɔ, ka a sɛsɛbɛ ŋmaa vʊʊr ka a kʊ̃ɔ mɩ lo jaa jomm.... ");
INSERT INTO biv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tɩ pãa sʊʊr a wʊ poturbo, “Nyɩnɛ a yɩ sɔɔfʊ be?” Ka ba mɩ de dãbãɛ sʊrɔ nɩ taa, “Nɩ an lɛ anyã, na 'yɛr ka a sɛsɛbɛ nɩ kʊ̃ɔ tu a wʊ nɛɛ?” ");
INSERT INTO biv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ba yin a Galilee gɔ̃ɔn na ba gɔ̃ɔ a Gerasenɩ gɔ̃ɔn. ");
INSERT INTO biv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu na wa yire a gogoro ju wʊ tuor daba na tara sɩdɛbɛ na wʊ gele yi a tẽe 'lɔ pɔ. Bojũu a kor wʊn yi a yir na wʊ maa su fuu ɛ, tɩ na wʊ gãna a yar par. ");
INSERT INTO biv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wʊn wa nyɛ a Yesu wʊ ŋmen chɛlma tɩ lo a Yesu niem na wʊ tãna 'yɛrɛ nɩ, “Bo lɛ fʊ bʊɔrɔ ka a n sɛ̃, a fʊ̃ʊ na ɩ a saaju Nãaŋmɩn Bie? N sʊɔrɔ fʊ naa, ta ge ma ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Bojũu Yesu dɔ̃ɔ 'yɛr kʊ a sɩdɛɛr ɩka wʊ yi a daba 'yɔ̃ɔ. Gbɛɛ yɔɔ jaa lɛ a ma ir a daba ka ba ma gbar a nuur nɩ a gbɛɛ nɩ bɔ̃jɔrsɩ kaara wʊ, tɩ wʊ ma kar a bɔ̃jɔrsɩ bar ka a sɩdɛɛr ma dii wʊ bar be a mɔgɔ̃ɔ pɔ wʊ yõ. ");
INSERT INTO biv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ka a Yesu sʊʊr wʊ, “A fʊ yuor lɛ di bo?” Ka wʊ 'yɛr, “Nɩyɔɔ.” Bojũu sɩdɛyɔɔ lɛ kpɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ka a sɩdɛbɛ sʊɔrɔ a Yesu ɩka wʊ ta dii ba 'yɔ̃ɔ be a bɔɔ fulom 'lɔ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Doyɔɔ mɩ dɔ̃ɔ ara be a tɔ̃ɔ kõkoor dire, ka a sɩdɛbɛ sʊɔr a Yesu ɩka wʊ sɔɔ ka ba yi tɩ kpɛ a dor ala pɔ, ka wʊ sɔɔ kʊ ba sɔr. ");
INSERT INTO biv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","A sɩdɛbɛ yin a daba pɔ tɩ kpɛ a dor pɔ, ka a tĩgbil suu tɩ kpɛ a man kʊ̃ɔ pɔ tɩ gbʊ̃m kpi kpi. ");
INSERT INTO biv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","A bala na kaara a dor na wa nyɛ a lɛ na ɩ, ba jon kul a tẽe pɔ, nɩ a tẽbil ala na gbʊr tɩ 'yɛr a lɛ na ɩ. ");
INSERT INTO biv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ka a nɩbɛ yi chen ɩka ba tɩ kaa a lɛ na ɩ. Ba chen a Yesu sɛ̃ tɩ nyɛ a dagẽgelaa a sɩdɛbɛ na yi tɩ chɛ bar ka wʊ chɩ na wʊ su a fuu jãnɛ a Yesu gbɛɛ par, ka a dãbãɛ kpɛ ba. ");
INSERT INTO biv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","A nɩbɛ bala na dɔ̃ɔ nyɛ a lɛ an ɩ ka a gẽgelaa sa pãa mana kʊrɔ a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ka a Gerasenɩ paal nɩbɛ ba jaa sʊɔrɔ a Yesu ɩka wʊ yi a be, bojũu dãbãɛ kpɛ ba naa. Lɛ lɛ wʊ kpɛ a gboro yi a be chen. ");
INSERT INTO biv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ka a daba 'lɔ pɔ a sɩdɛbɛ na yi sʊɔr a Yesu ɩka ba 'mataa chen, tɩchɛ a Yesu lɩɛb wʊ bar tɩ 'yɛr kʊ wʊ, ");
INSERT INTO biv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Lɩɛb kul a fʊ yir tɩ man a lɛ a Nãaŋmɩn na ɩ kʊ fʊ.” Lɛ lɛ ka a daba kul a tẽe pɔ tɩ mana kʊrɔ a nɩbɛ a lɛ a Yesu na ɩ kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu na wa lɩɛb wa, a nɩyɔɔ tuor de wʊ, bojũu ba dɔ̃ɔ chɛlɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ka daba ban bʊɔlɔ Jairusɩ na ɩ a lɔ̃ɔfʊ yir nɩdier, wa gbur dumo a Yesu niem sʊɔrɔ wʊ yãayãabɩlɛ ɩka wʊ wa a wʊ yir, ");
INSERT INTO biv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","bojũu a wʊ bipɔɔ bʊ̃'yen tɛɛ na nyɛ yuom pie nɩ ayi lɛ kpire. Yesu na de a sɔr chiine ka a nɩyɔɔ mɩl pɔɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ka pɔɔ mɩ be be na lo sɩɛ suoro faara yuom pie nɩ ayi, nɩrɛ jaa ba tʊ̃ɔ wʊ sãa ɛ. ");
INSERT INTO biv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A wʊ turo a puor tɩ sɩɩr a Yesu fuu nɛɛ ka a jãɩ ŋmaa ajienaa. ");
INSERT INTO biv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ka a Yesu sʊʊr, “An lɛ sɩɩr ma?” Ka ba jaa chiir ɩka baa sɩɩr wʊ ɛ, tɩchɛ ka a Pita 'yɛr, “N Soro, a nɩbɛ waa naa na dara taa tɩɛr fʊ.” ");
INSERT INTO biv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tɩchɛ ka a Yesu 'yɛr, “Nɩrɛ kɔ̃ɔ lɛ sɩɩr ma na wʊ sa ka n bɔ̃ɔn.” ");
INSERT INTO biv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A pɔɔ na wa nyɛ ka ɩ wʊ kʊ̃ lɛ tʊ̃ɔ sɔɔl ɛ, wʊ mɩrɛ naa wa lo gã a Yesu niem. A nɩyɔɔ bala niem tɩ na wʊ 'yɛr a lɛ jũu wʊn sɩɩr wʊ na wʊ sa ajienaa. ");
INSERT INTO biv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ka a Yesu 'yɛr kʊ wʊ, “N bipɔɔ, a fʊ sɔɔfʊ sa fʊ naa, kulo nɩ nyã'maar.” ");
INSERT INTO biv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu na chɛnɛ 'yɛrɛ, nɩrɛ kɔ̃ɔ yin a lɔ̃ɔfʊ nɩdier Jairusɩ yir wa 'yɛrɛ, “A fʊ bipɔɔ kpi naa ta lɛ fɩrɛ a wiwile go ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu na wõ a lɛ ka wʊ 'yɛr kʊ a Jairusɩ, “Ta joro dãbãɛ ɛ. Sɔɔ ma dɛ. Wʊn sa naa.” ");
INSERT INTO biv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wʊn wa ta a Jairusɩ yir waa sɔɔ ka nɩyuo kpɛ be ɛ, tɩ tara Pita, Jɔɔn nɩ Jemesɩ nɩ a bi sãa nɩ a ma kpɛ̃n. ");
INSERT INTO biv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ka a nɩyɔɔ bala na kõnõ ŋmiere a chɛlsɩ, Yesu 'yɛr kʊ ba, “Yɩ bar a kõn waa kpi ɛ, wʊ gur naa.” ");
INSERT INTO biv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ka ba laara wʊ ban bɔ̃ɔn ɩka a bie kpi naa. ");
INSERT INTO biv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tɩchɛ ka a Yesu nyɔɔ a bie nũu tɩ 'yɛr, “N bie, ir.” ");
INSERT INTO biv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ka wʊ sɩɛ lɩɛb wa kpɛ ka wʊ vaa ir. Ka a Yesu pãa 'yɛr, yɩ kʊ wʊ bʊ̃kɔ̃ɔ ka wʊ di. ");
INSERT INTO biv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ka a sãa naa ma nyɔɔ nɛɛ, tɩchɛ ka a Yesu kpãkpãan ba ɩka ba taa ɩrɛ wa 'yɛrɛ kʊrɔ nɩrɛ jaa a lɛ na ɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu na wa bʊɔl a wʊ nɩtʊ̃nsɩ pie nɩ ayi lɔ̃ɔ taa, wʊ kʊ ban kpɛ̃ɔ nɩ tʊ̃ɔfʊ ka ban diin sɩdɛbɛ ka a yi tɩ sãa baalsɩ. ");
INSERT INTO biv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wʊ tʊ̃ ba naa ka ba chen tɩ 'yɛr a Nãaŋmɩn nãalʊ̃ʊ 'yɛr tɩ sãa baal. ");
INSERT INTO biv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wʊ 'yɛr kʊ ba, “Yɩ taa tara bon jaa chiine ɛ. Yɩ ta de dãgbal ɛ, bɩɩ wʊɔ ɛ, bɩɩ bʊ̃diir ɛ, bɩɩ libie ɛ, bɩɩ de fuusɩ ayi ɛ. ");
INSERT INTO biv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yir jaa pɔ yɩn tɩ kpɛ, yɩ jãnɛ a be tɩ tãn a daar 'lɔ yɩn na yi a tẽe 'lɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ala ɩ nɩbɛ ba wa de yɩ ɛ, yɩ yi a tẽe 'lɔ pɔ, tɩ yɩn wa yire yɩ pĩ pĩ a yɩ gbɛɛ tã-uul ka a di a ba dãasɩɛ.” ");
INSERT INTO biv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Be lɛ ba yi lʊɔrɔ a tẽn tẽn 'yɛrɛ a 'yɛr nʊ̃ɔ nyã sãa na nɩ a nɩbɛ baalsɩ a jie wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","A Nãa Hɛrɔd na wõ a nɩtɔ̃ na ɩrɛ, ka tɩɛr nyɔɔ wʊ, bojũu bamɩne 'yɛrɛ naa ɩka Jɔɔn lɛ tɔ̃ɔ ir ɩ vʊr. ");
INSERT INTO biv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ka bamɩne mɩ 'yɛrɛ ɩka a Elaija lɛ tɔ̃ɔ yi, ka bamɩne mɩ chɛnɛ 'yɛrɛ ɩka a Nãaŋmɩn 'yɛ'yɛrɛ ãsʊɔ lɛ tɔ̃ɔ ir ɩ vʊr. ");
INSERT INTO biv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tɩchɛ ka a Hɛrɔd 'yɛr, “N ŋmaan Jɔɔn ju, tɩ an 'yɛr lɛ a nyã ɩn wõnõ?” Na wʊ mʊɔrɔ ɩka wʊ nyɛ a Yesu. ");
INSERT INTO biv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","A nɩtʊ̃nsɩ lɩɛb wa na ba wa man kʊ a Yesu a lɛ ban tʊ̃. Ka wʊ pãa tara a bala tɛɛ ka ba 'mataa chen a tẽe ban bʊɔlɔ Betɩsaida. ");
INSERT INTO biv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tɩchɛ ka a nɩyɔɔ chɛnɛ bɔ̃ɔn na ba bɩɛr chen a jie. Wʊ de ba naa na wʊ 'yɛr a Nãaŋmɩn nãalʊ̃ʊ 'yɛr kʊ ba, tɩ sãa a bala na bʊɔrɔ a sãafʊ. ");
INSERT INTO biv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mɔ̃tɔ̃ɔ na wa mʊrɔ, a nɩtʊ̃nsɩ pie nɩ ayi tɩ 'yɛr kʊ wʊ, “Wɛl a nɩbɛ bar a ba chen a tẽbil anyã nɩ a por anyã na gbʊr na ba tɩ bɔ gaa jie nɩ bʊ̃diir di bojũu a ka ɩn mɔgɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ka wʊ 'yɛr sɔɔ ba, “Yɩn lɛ na kʊ ba bʊ̃kɔ̃ɔ ka ba di.” Ka ba 'yɛr, “Paanʊ̃ɔsɩ anũu nɩ jãbie ayi tɛɛ lɛ sɩ tara, ka a ba ɩ sɩ chen tɩ da bʊ̃diir wa kʊ a nɩyɔɔ ba nyãna ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A nɩyɔɔ bala, dɔɔr tɛɛ ɩn tur anũu (5,000). Tɩchɛ ka wʊ 'yɛr kʊ a poturbo, “Yɩ ŋma a nɩbɛ ka ba jãnɛ jãnɛ gbulsɩ lɩjaayi nɩ pie pie.” ");
INSERT INTO biv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A poturbo ɩn a lɛ ka nɩrɛ jaa jɛ̃ tẽe. ");
INSERT INTO biv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu den a paanʊ̃ɔsɩ a nũu nɩ a jãmɛ ayi ala dʊl kaa saaju tɩ puor Nãaŋmɩn yãan, tɩ na wʊ ŋma ŋma, de kʊ a poturbo ɩka ba de põ a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ba jaa din tɩɩ, ka a poturbo wob a bʊ̃ŋmaar ala na chɛ sɛɛ pɛr pie nɩ ayi. ");
INSERT INTO biv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Daar kɔ̃ɔ lɛ a Yesu tɛɛ wa sʊɔrɔ Nãaŋmɩn ka wʊ poturbo be be ka wʊ sʊʊr ba, “An lɛ a nɩbɛ 'yɛrɛ ɩka n ɩ naa?” ");
INSERT INTO biv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ka ba 'yɛr, “Bamɩne 'yɛr ɩka fʊ ɩn a Jɔɔn 'lɔ na dɔ̃ɔ suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ, ka bamɩne mɩ 'yɛr ɩka Elaija lɛ, ka bamɩne mɩ 'yɛr ɩka a Nãaŋmɩn 'yɛ'yɛrɛ ãsʊɔ kɔ̃ɔ lɛ lɩɛb wa.” ");
INSERT INTO biv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ka wʊ sʊʊr ba, “Tɩchɛ yɩn mɩ, an lɛ yɩ 'yɛr ɩka n ɩ naa?” Ka a Pita 'yɛr, “Fʊ ɩ naa a Nɩ-iraa yi a Nãaŋmɩn sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ka a Yesu kpãkpãan ba ɩka ba taa 'yɛrɛ kʊrɔ nɩrɛ jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tɩ na wʊ 'yɛr, “A maa Nɩsaal Bie na din dɔɔyɛ yɔɔ ka a nɩbɛrɛ nɩ a bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ nɛɛ wiwiilbe tɔr ma bar, ka ba kʊ ma, ka a ber ata daar ka n ir ɩ vʊr.” ");
INSERT INTO biv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Be lɛ wʊ 'yɛr kʊ ba jaa, “Ala ɩ nɩrɛ na turo ma naa, wʊ 'laar a wʊ mãɛ tɩ tuo a wʊ daa turo nɩ ma. ");
INSERT INTO biv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bojũu nɩrɛ 'lɔ jaa na bʊɔrɔ ɩka wʊ faa a wʊ nyɛvʊr a wʊ nyɛvʊr na bɔr naa, tɩchɛ nɩrɛ 'lɔ jaa na lɔb a wʊ nyɛvʊr bar a maa jũu na faa wʊ naa. ");
INSERT INTO biv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ala ɩ nɩrɛ tara naa a wɛr wʊ jaa bonsɩ tɩ bɔr bɩɩ ka a wʊ sɩɛ wɛ, bo tɔ̃nɔ̃ wʊ nyɛ? ");
INSERT INTO biv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ala ɩ nɩrɛ nyɛ naa maa nɩ a n 'yɛr ka a ɩ vĩ yele a wʊ sɛ̃, a maa Nɩsaal Bie mɩ na kaa naa nɩnyɩnɛ ka wʊ ɩ vĩ sʊɔ maa wa lɩɛb waara nɩ a n tɩɩr nɩ a Sãa tɩɩr nɩ a malaka chɛchɛ bala. ");
INSERT INTO biv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka a yɩ bamɩne gba ara naa kana kʊ̃ kpi ɛ, tɩ na ban nyɛ a Nãaŋmɩn nãalʊ̃ʊ.” ");
INSERT INTO biv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu na 'yɛr a 'yɛrbie anyãna baar a maal ber aniin tɩ wʊ tara Pita, Jɔɔn nɩ Jemesɩ don a tɔ̃ɔ ju Nãaŋmɩn sʊɔrfʊ jie. ");
INSERT INTO biv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wʊn tɩ sʊɔrɔ a Nãaŋmɩn ka a nie lɩɛb, ka a fuu pɛl nyɩlɛ bũu 'lɩraa kaar. ");
INSERT INTO biv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ka a dɔɔr ayi, Mosesɩ nɩ Elaija wa naa a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ba wa yin naa a saaju tɩɩr 'yɛrɛ nɩ a Yesu. Ba 'mantaa 'yɛrɛ a kũu a Yesu na tɩ kpi a Jerusalɛm 'yɛr. ");
INSERT INTO biv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Gʊ̃ɔ kpɛ̃n a Pita nɩ a wʊ taaba, tɩchɛ ban wa jɔɔ ir ba nyɛn a wʊ tɩɩr nɩ a dɔɔr ayi bala a ba ara a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","A dɔɔr bala na lɩɛb chiine ka Pita 'yɛr, “N Soro, a sɛɛn ka sɩn kpɩɛrɛ a ka. Bar a sɩ 'yɔ̃ɔ sɛɛr ata, fʊ̃ʊ so ãsʊɔ, Mosesɩ ãsʊɔ Elaija mɩ ãsʊɔ.” Waa bɔ̃ɔ a lɛ wʊn 'yɛrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wʊn chɛnɛ 'yɛrɛ a julõjuur wa pɔɔn ba jaa ka a dãbãɛ kpɛ a Pita, Jɔɔn nɩ Jemesɩ. ");
INSERT INTO biv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ka a kɔkɔr yi be a julõjuur pɔ 'yɛrɛ, “Nyã lɛ ɩ a n Bie ɩn ir, yɩ chɛlɛ a wʊ 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","A kɔkɔr na wa 'yɛr baar, ba nyɛn a Yesu tɛɛ na ara. Ka a poturbo ba 'la man kʊ nɩrɛ a lɛ ban nyɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A wɛr na wa chaar, ba yin a tɔ̃ɔ ju suu, a nɩyɔɔ wa lɔ̃ɔ a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ka a daba bʊɔl be a nɩyɔɔ bala pɔ, “Wiwile, n sʊɔrɔ fʊ naa, kaa a n bidaba, 'lɔ tɛɛ lɛ ɩ a n bie. ");
INSERT INTO biv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sɩɛ kɔ̃ɔ lɛ tara wʊ, ma ire wʊ ba gala ɛ. Wʊ maa ŋmen a chɛlma tɩ tãanaa tɩ furo a natafuul a nɛɛ pɔ. Wʊ maa bara wʊ ɛ, na wʊ bʊɔrɔ a wʊ sɔ̃ɔfʊ. ");
INSERT INTO biv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","N sʊɔr a fʊ poturbo ɩka ba dii a sɩɛ nyã bar tɩchɛ baa tʊ̃ɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ka a Yesu 'yɛr, “Yɩn babãma dẽme na ba tara sɔɔfʊ ɛ, n be a yɩ sɛ̃ naa tara yɩ nɩ kãnyir tɩ tãn dabor?” Tɩ 'yɛr a daba, “Tɔɔ a bie wa kʊ ma!” ");
INSERT INTO biv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","A bie na chɛnɛ waara ka a sɩdɛɛr ir a bie tãa lɔb a tẽe, tɩchɛ ka a a Yesu tãn a sɩdɛɛr na wʊ sãa a bie de kʊ a sãa. ");
INSERT INTO biv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nɩbɛ ba jaa nɛ'maa naa ban nyɛ a Nãaŋmɩn kpɛ̃ɔ. A nɩbɛ na chɛnɛ kpire a lɛ a Yesu na ɩ, tɩ wʊ 'yɛr kʊ a poturbo, ");
INSERT INTO biv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Yɩ chɛlɛ a lɛ ɩn 'yɛrɛ kʊrɔ yɩ, ban gar naa maa Nɩsaal Bie 'yɔ̃ɔ a nɩbɛ nuur pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tɩchɛ baa bɔ̃ɔ a anyãna wʊn 'yɛr par ɛ, a lii ba naa, ka ba bɔ̃ɔ faa, tɩ joro dãbãɛ ba 'la sʊʊr wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nɛchɩrɛ ir naa a Yesu poturbo pɔ ɩka a ba buor sʊɔ lɛ na ɩ a ba kpɛ̃ɛ. ");
INSERT INTO biv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu na bɔ̃ɔ a ba tɩɛr, wʊ tɔɔn bibile wa lan a wʊ lõboor. ");
INSERT INTO biv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tɩ pãa 'yɛr kʊ ba, “Nɩrɛ jaa na de a bibile nyãna a maa jũu maa lɛ wʊ de. Nɩrɛ jaa mɩ na de ma wʊ mɩ den a 'lɔ na tʊ̃ ma. Bojũu nɩrɛ 'lɔ na ɩ a yɩ jaa bile, 'lɔ lɛ ɩ kpɛ̃ɛ gar yɩ jaa.” ");
INSERT INTO biv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ka a Jɔɔn 'yɛr, “N Soro, sɩ nyɛn nɩrɛ na de a fʊ yuor dire nɩ a sɩdɛbɛ ka a yire, ka sɩ 'yɛr wʊ ɩka wʊ ta ɩrɛ a lɛ ɛ, bojũu waa ɩ a sɩ ãsʊɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ka a Yesu 'yɛr, “Yɩ ta ŋmaa wʊ sɔr ɛ, bojũu nɩrɛ 'lɔ na ba kpɛrɛ yɩ ɛ, wʊ pʊɔ yɩ naa.” ");
INSERT INTO biv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Lɛ a sɔ̃ɔ na wa gbʊrɔ ka Yesu na lɩɛb do a saaju, wʊ ŋmen nyãa a Jerusalɛm chenfʊ. ");
INSERT INTO biv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wʊ den nie tʊ̃ nɩbɛ ka ba de nie chen a Samariya tẽbile ãsʊɔ pɔ, na ban tɩ chɔɔr a jie bar wʊ. ");
INSERT INTO biv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tɩchɛ a tẽe 'lɔ nɩbɛ ba sɔɔ de wʊ ɛ, bojũu Jerusalɛm lɛ wʊ chiine. ");
INSERT INTO biv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ka a wʊ poturbo Jemesɩ nɩ Jɔɔn na wa nyɛ a lɛ, ka ba sʊʊr a Yesu, “Sɩ Soro, fʊ bʊɔrɔ naa ɩka sɩ bʊɔl bũu ka ayi saaju suu wa di ba bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tɩchɛ ka a Yesu lɩɛb tãn ba ɩka ba ta ɩ a lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tɩ na ba chen tẽyuo pɔ. ");
INSERT INTO biv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","A sɔr ban chɛnɛ de chiine ka daba ãsʊɔ 'yɛr kʊ a Yesu, “Jie jaa fʊn chiine ɩn turo fʊ naa!” ");
INSERT INTO biv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ka a Yesu 'yɛr, “Mɔbaar tara naa bɔɔr ka a lubil mɩ tara choor, tɩchɛ maa Nɩsaal Bie ba tara jie na bin a n ju ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wʊ 'yɛr kʊ a daba ãsʊɔ, “Turo ma.” Tɩchɛ ka a daba 'yɛr, “N Soro, bar ma sɔr ka n kul tɩ ũu a n sãa baar.” ");
INSERT INTO biv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ka a Yesu 'yɛr kʊ a daba, “Bar ka a kũn ũno ba mãɛ kũn tɩchɛ fʊ̃ʊ 'lɔ, chen tɩ mʊɔlɔ a Nãaŋmɩn nãalʊ̃ʊ 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ka ãsʊɔ mɩ 'yɛr, “N Soro, ɩn turo fʊ naa tɩ bar ma sɔr ka n kul tɩ 'yɛr a n yir dẽme.” ");
INSERT INTO biv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ka a Yesu 'yɛr, “Nɩrɛ na nyɔɔ niin kuur tɩ lɩɛb kaara a puor ba sɛɛn a Nãaŋmɩn nãalʊ̃ʊ tʊ̃mɔ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","A nyã puor Yesu lɛ ir naa nɩbɛ lɩjaata nɩ pie nɩ ayi (72) bamɩne go, na wʊ tʊ̃ ba ayir yir ka ba de nie chen a tẽn nɩ a jiir ala a jaa wʊn na yɔ. ");
INSERT INTO biv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wʊ 'yɛr kʊ ba, “A puo bɛr ma naa, tɩchɛ ka a bala na ŋmara ba waa ɛ, a lɛ jũu yɩ sʊɔr a puo sɔɔ ka wʊ waan tʊ̃tʊ̃nbɔ wa 'yɔ̃ɔ a puo pɔ. ");
INSERT INTO biv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yɩ chen, yɩ kaara na fɩka piir ɩn tʊ̃nɔ̃ ka yɩn tɩ kpɛ gbõgborosɩ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yɩ taa de libie ɛ, bɩɩ wʊɔ ɛ, bɩɩ na fɔɔr ɛ, na yɩ puor nɩrɛ taa wa jaa a sɔr pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Yir jaa pɔ yɩn wa kpɛ, yɩ de nie 'yɛr, ‘Nyã'maar wʊ be a yir nyã pɔ.’ ");
INSERT INTO biv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ala ɩ nyã'maar sʊɔ ben a yir pɔ, a yɩ nyã'maar na be naa a wʊ sɛ̃, ala ba ɩ lɛ ɛ, an lɩɛb wa a yɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yɩ jãnɛ a yir nyɩnɛ pɔ dire na yɩ nyuro bon jaa ban wa kʊ yɩ, tʊ̃tʊ̃nɔ̃ sãyar sɛɛn wʊ naa. Yɩ taa lʊɔrɔ yie yʊɔrɔ nɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tẽe jaa pɔ yɩn wa kpɛ, ka ba de yɩ, yɩ dire bon jaa ban kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yɩ sãana a baalsɩ bala na be be tɩ na yɩ 'yɛr kʊ ba, ‘A Nãaŋmɩn nãalʊ̃ʊ gbʊr yɩ naa.’ ");
INSERT INTO biv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tɩchɛ tẽe jaa pɔ yɩn wa kpɛ, ka baa de yɩ ɛ, yɩ yi de a tẽe sãlsɔɔ tɩ 'yɛr, ");
INSERT INTO biv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘A yɩ tẽe tã-uul gba na mar a sɩ gbɛɛ, sɩ kpoor 'yɔ̃ɔ yɩ. Yɩ bɔ̃ɔn a nyãna ɩka a Nãaŋmɩn nãalʊ̃ʊ gbʊr naa.’ ");
INSERT INTO biv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","N 'yɛr kʊ yɩ ɩka a Nãaŋmɩn 'yɛr tɔɔrfʊ bɩbir, Sodom na sa naa a tẽe 'lɔ̃nɔ̃. ");
INSERT INTO biv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Nɛbier ben a yɩn Korajin dẽme sɛ̃, nɛbier mɩ ben a yɩn Betɩsaida dẽme mɩ sɛ̃. A nɛ'maa tʊ̃mɔ̃ ala ɩn tʊ̃ a yɩ jie, ala ɩ a mɩ ta tʊ̃n a lɛ a Tire nɩ Sidon tẽe pɔ, ban taa sun bʊ̃jarsɩ jɛ̃n tãpɩɛl pɔ lɩɛb ba tɩɛr. ");
INSERT INTO biv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tɩchɛ a 'yɛr tɔɔrfʊ daar, a Tire nɩ a Sidon na sa yɩ naa. ");
INSERT INTO biv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A yɩn Kapenahum dẽme, ban 'mɔɔ yɩn don saaju bɩɩ? Kai, ban suun yɩ naa kpĩisɩ tẽe. ");
INSERT INTO biv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nɩrɛ 'lɔ na chɛlɛ a yɩn na ɩ a n poturbo na chɛl naa a n 'yɛr, nɩrɛ 'lɔ na tɔr yɩ mɩ tɔr ma naa. Tɩchɛ nɩrɛ 'lɔ na tɔr ma mɩ tɔr naa a 'lɔ na tʊ̃ ma.” ");
INSERT INTO biv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","A nɩbɛ lɩjaata nɩ pie nɩ ayi bala wʊn tʊ̃ lɩɛb wa a wʊ sɛ̃ chɩlɛ 'yɛrɛ, “Sɩ Soro, a fʊ yuor jũu a sɩdɛbɛ tu naa a sɩ nɛɛ na be yire a nɩbɛ pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ka Yesu 'yɛr sɩrɛ jaa lɛ, “N nyɛn Satan na yi saaju lo fɩka saa na nyɩɩr. ");
INSERT INTO biv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","N kʊ yɩn kpɛ̃ɔ ka yɩn nɛɛrɛ waba nɩ lɔ̃n na yɩ tʊ̃ɔ a yɩ dɔ̃dɔ̃mɔ̃ Satan, bon jaa kʊ̃ ɩ yɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yɩ ta chɩlɛ a sɩdɛbɛ na tu a yɩ nɛɛ ɛ, tɩchɛ yɩ chɩlɛ a yɩ yuor sɛb bin be a saaju.” ");
INSERT INTO biv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A daar 'lɔ̃nɔ̃ lɛ a Nãaŋmɩn Sɩɛ nʊ̃ɔ kpɛ a Yesu ka wʊ 'yɛr, “N dãn a fʊ̃ʊ n Sãa na ɩ a saaju nɩ a tẽe Soro, bojũu fʊ̃ʊ lɛ sɔɔl a yele anyãna bar ka a bala na ɩ a yɛ̃ dẽme nɩ a bala na jãn ba bɔ̃ɔ ɛ, tɩ na fʊ de wiil kʊ bibiir. Ɔ̃ɔ, n Sãa lɛ lɛ nʊ̃mɔ̃ fʊ ka fʊ maal. ");
INSERT INTO biv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Maa lɛ a n Sãa kʊ a yele a jaa, nɩrɛ jaa ba bɔ̃ɔ a Bie ka a Sãa ba lɛ ɛ. Nɩrɛ jaa mɩ ba bɔ̃ɔ a Sãa ka a Bie ba lɛ ɛ, tɩchɛ a bala a maa Nãaŋmɩn Bie na ir, na wiil naa a sãa kʊ ba. Ka ba bɔ̃ɔ lɛ a Nãaŋmɩn na be.” ");
INSERT INTO biv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tɩ pãa lɩɛb 'yɛr kʊ a wʊ poturbo tɛɛ, “Pʊpɛl dẽme lɛ a bala nɩbir na nyɛ a anyã yɩn nyɛ. ");
INSERT INTO biv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bojũu n 'yɛrɛ na kʊrɔ yɩ ɩka a Nãaŋmɩn 'yɛ'yɛrbɛ nɩ a nãmɩne dɔ̃ɔ bʊɔrɔ ɩka ba nyɛ a anyã yɩn nyɛ, tɩ ba nyɛ ɛ, na ba ta wõ a anyã yɩn wõ tɩ ba wõ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nɩrɛ ãsʊɔ na bɔ̃ɔ a Mosesɩ Nɛɛ bʊɔrɔ naa ɩka wʊ bɛɛr a Yesu kaa na wʊ ir sʊʊr, “Wiwile, ŋmɩnɛ lɛ ɩn ɩ naa nyɛ nyɛvʊr kpo kpo?” ");
INSERT INTO biv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ka a Yesu sʊʊr wʊ, “Bo ba sɛb a Nãaŋmɩn gãn pɔ bin? Ŋmɩnɛ fʊ ma kar?” ");
INSERT INTO biv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ka a daba 'yɛr, “Nʊ̃ a fʊ Nãaŋmɩn nɩ a fʊ nyãa wʊ jaa, nɩ a fʊ nyɛvʊr wʊ jaa, nɩ a fʊ kpɛ̃ɔ wʊ jaa, nɩ a fʊ tɩɛr wʊ jaa. Na fʊ nʊ̃ a fʊ tɔ sʊɔ nɩtãa a fʊ mãɛ.” ");
INSERT INTO biv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Be lɛ a Yesu 'yɛr, “Fʊ 'yɛr vɩla, tɩ ɩrɛ a lɛ, fʊn ben be kpo kpo.” ");
INSERT INTO biv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tɩchɛ wʊn ba ɩrɛ a lɛ ɛ, tɩ bʊɔrɔ ɩka wʊ sɔɔl a wʊ mãɛ bar jũu, wʊ sʊʊr naa Yesu, “Nɩbuor lɛ ɩ a n tɔ sʊɔ?” ");
INSERT INTO biv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ka a Yesu 'yɛr, “Daba kɔ̃ɔ lɛ dɔ̃ɔ yi Jerusalɛm chiine Jeriko ka a nãnyisɩ tɩ var wʊ be a sɔr pɔ. Ba yaar naa fuusɩ tɩ ŋme ŋme wʊ, ka wʊ vɔɔ chɛ bãlãa naa kpi, ka ba bar wʊ tɩ chen. ");
INSERT INTO biv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","A Juu nɩbɛ bɔɔrloro ãsʊɔ mɩ de a sɔr 'lɔ̃nɔ̃, wʊn tɩ nyɛ a daba, wʊ gõl bar tɩ chen. ");
INSERT INTO biv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ka a Nãaŋmɩn Puorfʊ yir tʊ̃tʊ̃nbɔ nɩrɛ ãsʊɔ mɩ waara wa nyɛ, na wʊ mɩ gõl tu jiyuo chen. ");
INSERT INTO biv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tɩchɛ ka a nɩrɛ ãsʊɔ na ɩ a Samariya nɩrɛ mɩ tu a sɔr 'lɔ a daba na gã, wʊn wa nyɛ wʊ, nɩbaal kpɛ wʊ naa. ");
INSERT INTO biv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ka wʊ tɔɔ ta a daba pʊr dãa pɛɛn a natɩɛ bar, tɩ maal kãa fɔ, tɩ de fɔbaa lũ pɔɔ. Na wʊ 'mɔɔ a daba dɔɔl a wʊ bʊ̃ɔ ju chiin a sãanba gaa jie tɩ gãn. ");
INSERT INTO biv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wɛr na wa chaar, wʊ den a kpãna libikue ayi kʊ a nɩrɛ 'lɔ na kaara a sãanba tɩ 'yɛr, ‘Kaara wʊ, maa wa lɩɛb gɔr, ala ba wa ta ɛ, ɩn lɛ yab kʊ fʊ.’ ” ");
INSERT INTO biv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ka a Yesu sʊʊr a daba, “A nɩbɛ ata banyãna, buor sʊɔ lɛ ɩ a daba nyã, a nãnyisɩ na ŋme tɔ sʊɔ?” ");
INSERT INTO biv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A wʊ 'yɛr, “Nɩrɛ 'lɔ na kaa a wʊ nɩbaal.” Ka a Yesu 'yɛr, “Mɩ chen tɩ maal a lɛ nɛ.” ");
INSERT INTO biv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu nɩ a wʊ poturbo na chiine ba vɩɛn kpɛ tẽbile kɔ̃ɔ pɔ, ka pɔɔ ban bʊɔlɔ Mata ka wʊ de ba na ir ba sãan. ");
INSERT INTO biv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A Mata tara na yɛbɛ ban bʊɔlɔ Mɛɛr, ka 'lɔ jãnɛ a Soro gbɛɛ par chɛlɛ a lɛ wʊn 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tɩchɛ ka a Mata wʊ yõ sõsoro nɩ a tʊ̃mɔ̃, na wʊ wa tɔɔ ta a Yesu sɛ̃ 'yɛr, “N Soro, a ba bã fʊ a n yɛbɛ na bar a tʊ̃mɔ̃ 'yɔ̃ɔ ma ka n sõsoro nɩ ɛ? 'Yɛr wʊ ka wʊ ir wa sʊ̃ʊ ma.” ");
INSERT INTO biv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ka a Soro 'yɛr, “Mata, Mata fʊ fɩrɛ na fʊ mãɛ ka suur kʊrɔ fʊ. ");
INSERT INTO biv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tɩchɛ yelbʊ̃'yen tɛɛ lɛ fɛr, Mɛɛr ir naa a bʊ̃sʊ̃ nɩrɛ na kʊ̃ tʊ̃ɔ faa wʊ yin a wʊ sɛ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bɩbir ãsʊɔ Yesu ben a jie kɔ̃ɔ na wʊ sʊɔrɔ Nãaŋmɩn, wʊn wa sʊɔr baar, ka a wʊ poturbo ãsʊɔ 'yɛr kʊ wʊ, “Sɩ Soro, wiil sɩ a Nãaŋmɩn sʊɔrfʊ, nɩtãa lɛ a Jɔɔn na wiil a wʊ poturbo.” ");
INSERT INTO biv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A wʊ 'yɛr kʊ ba, “Yɩn ma wa sʊɔrɔ a Nãaŋmɩn yɩ 'yɛr, Sɩ Sãa, sɩ kʊ naa a fʊ yuor tɩɩr. A fʊ nãalʊ̃ʊ wʊ wa. ");
INSERT INTO biv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Na fʊ kʊ sɩ a sɩ bɩbir jaa bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Vɛ̃ a sɩ maal dɛbɛ bar, bojũu sɩ mɩ vɛ̃n kʊ a bala jaa na maal sɩ a dɛɛr. Ta sɔɔ ka bɛɛr kaa nyɔɔ sɩ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Be lɛ wʊ pãa 'yɛr kʊ ba. “Ala ɩ a yɩ ãsʊɔ tara na baraa na wʊ wa ir chen a wʊ sɛ̃ tãsɔɔ bãɩn tɩ 'yɛr, ‘Pɛ̃ɛ ma jɔ̃ nɩ ŋmele, ");
INSERT INTO biv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","bojũu n baraa ãsʊɔ lɛ wa suu a tãsɔɔ nyãna tɩ n ba tara bon na maal kʊ wʊ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ka wʊ gã be a die pɔ tɩ 'yɛr, ‘Ta dɔ̃ɔnɔ̃ ma ɛ, a pãn pɔɔ naa ka maa naa bibiir be gã, n kʊ̃ lɛ tʊ̃ɔ ir kʊ fʊ bon go ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","N 'yɛrɛ na kʊrɔ yɩ, a wʊ baraa na ba sɔɔ ir kʊ wʊ a jɔ̃ ɛ, tɩchɛ wʊn chɛnɛ ara kpãkpãana, wʊn wa ir kʊ wʊ jã a lɛ wʊn bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Lɛ lɛ n 'yɛrɛ kʊrɔ yɩ, yɩ sʊɔr, Nãaŋmɩn na kʊ yɩ naa. Yɩ kaa yɩn nyɛ naa, yɩ kpoor a pãn wʊn yuo naa. ");
INSERT INTO biv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nɩrɛ 'lɔ na sʊɔr, wʊn nyɛ naa, ka a 'lɔ mɩ na kaara nyɛ, ka a pãn mɩ yuo kʊ a 'lɔ na kpoor. ");
INSERT INTO biv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","A yɩn na ɩ a sãamɩne, buor sʊɔ bie lɛ na sʊɔr wʊ jãm ka wʊ de waa kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bɩɩ sʊɔr najɛl ka wʊ de lɔ̃ɔ kʊ wʊ? ");
INSERT INTO biv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ala ɩ a yɩn gba na ɩ nɩdɛbɛ bɔ̃ɔn vɩla ma ɩ kʊ a yɩ bibiir, ŋmɩnɛ lɛ an ɩ ka yɩ Sãa na be a saaju kʊ̃ de a Sɩɛ kʊ a bala na sʊɔr wʊ ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu dire naa a sɩdɛɛr na be daba yɔ̃ɔ vɛ̃ ka wʊ ɩ wõo. A sɩdɛɛr na wa yi a daba 'yɔ̃ɔ, ka wʊ tʊ̃ɔ 'yɛrɛ, ka nɛ'maa a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tɩchɛ ka a bamɩne 'yɛrɛ, “A sɩdɛbɛ nãa Beeljebul lɛ wʊ de dire nɩ a sɩdɛbɛ.” ");
INSERT INTO biv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ka a bamɩne mɩ bɛɛr wʊ kaara na ba bʊɔrɔ jãnɛ na yi saaju. ");
INSERT INTO biv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu bɔ̃ɔn a lɛ ban tɩɛrɛ na wʊ 'yɛr kʊ ba, “Nãa jaa na jɛɛrɛ nɩ a wʊ mãɛ a wʊ nãa na sɔ̃ɔ naa. Yir nɩbɛ mɩ na ir jɛɛrɛ taa kʊ̃ tʊ̃ɔ 'mataa kpɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Lɛ mɩ lɛ, ala ɩ a Satan lɩɛb jɛɛrɛ nɩ a wʊ mãɛ, ŋmɩnɛ a wʊ nãalʊ̃ʊ na ɩ ara? N 'yɛr naa nɩtɔ̃ bojũu yɩ 'yɛr ɩka a Beeljebul lɛ n de dire nɩ a sɩdɛbɛ. ");
INSERT INTO biv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ala ɩ a Beeljebul lɛ n tara dire nɩ a sɩdɛbɛ, tɩ a bala na ɩ a yɩ poturbo bo lɛ ba tara dire nɩ a sɩdɛbɛ? A lɛ jũu, bala lɛ na ɩ a yɩ 'yɛr tɔɔrbɔ. ");
INSERT INTO biv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tɩchɛ ala ɩ Nãaŋmɩn kpɛ̃ɔ lɛ n dire nɩ a sɩdɛbɛ ka a yire wiil yɩn ɩka a Nãaŋmɩn nãalʊ̃ʊ wa naa a yɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Gãdaa na gu a wʊ yir nɩ jɛɛr bomo, a wʊ bonsɩ maa dam ɛ. ");
INSERT INTO biv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tɩchɛ ala ɩ nɩrɛ ãsʊɔ wa wa naa na wʊ kpɛ̃mɛ gar wʊ, wʊn faan a wʊ jɛɛr bomo ala wʊn dɩɛl tɩ de a wʊ bonsɩ põn nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nɩrɛ 'lɔ na ba be a n sɛ̃ ɛ, wʊ tara man nɩ 'yɛr, nɩrɛ 'lɔ na ba pʊɔ ma a sɩ kaala lɔ̃ɔnɔ̃ taa ɛ, wʊ ma yɛ̃yɛl bar. ");
INSERT INTO biv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Sɩdɛɛr ban wa dii bar ka wʊ yi nɩrɛ pɔ, wʊ ma chen dal pʊɔ ju tɩ bʊɔrɔ pɛ̃nfʊ jie, na waa nyɛ ɛ, na wʊ pãa wa 'yɛr, ‘Ɩn lɩɛb kul a nɩrɛ 'lɔ pɔ ɩn yi tɩ chɛ bar.’ ");
INSERT INTO biv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wʊn wa lɩɛb wa, wʊ nyɛn a nɩrɛ 'lɔ na kaara yir kaar ban pɩɩr tɩ chɔɔr wʊ sʊ̃. ");
INSERT INTO biv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ka wʊ pãa tɩ bɔ sɩɩr ayopõi na tara putuo gar wʊ ka ba chen tɩ kpɩɛrɛ a be. Ka a daba pãa ɩ dɛɛr gar a lɛ wʊn dɔ̃ɔ be.” ");
INSERT INTO biv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","A nyãna lɛ a Yesu 'yɛrɛ ka a pɔɔ ŋme chɛlma be a nɩyɔɔ pɔ tɩ 'yɛr, “Pʊpɛl lɛ kʊ a fʊ ma 'lɔ na dɔɔ fʊ, nɩ a wʊ bɩr fʊn 'yɛn.” ");
INSERT INTO biv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ka a Yesu 'yɛr, “Lɛ ba lɛ ɛ, a bala na wõ a Nãaŋmɩn 'yɛr na ba turo, bala lɛ ɩ a pʊpɛl dẽme.” ");
INSERT INTO biv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","A nɩbɛ na waara 'yɔ̃ɔnɔ̃ ka Yesu 'yɛr, “A dɩna nɩbɛ banyãna ɩn putudẽme tɩ bʊɔrɔ nɛ'maa tʊ̃mɔ̃ ka a na ɩ jãnɛ, tɩchɛ ba kʊ̃ nyɛ ãsʊɔ jaa ɛ, ka a Jona jãnɛ ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bojũu, lɛ a Jona na dɔ̃ɔ ɩ jãnɛ kʊ a Ninive dẽme, lɛ mɩ lɛ a maa Nɩsaal Bie na ɩ a jãnɛ kʊ a dɩna nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","A Siba Pɔɔ Nãa na yin a 'yɛr tɔɔrfʊ daar na wʊ wa 'yɔ̃ɔ a yɩn dɩna nɩbɛ 'yɛr, bojũu wʊ dɔ̃ɔ yi be a tẽtɛɛr wa chɛl a Nãa Solomon yɛ̃ 'yɛr, tɩchɛ yɩ kaa a 'lɔ na gar a Solomon ben ka. ");
INSERT INTO biv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","A 'yɛr tɔɔrfʊ daar Ninive nɩbɛ na ir 'yɔ̃ɔ a yɩn dɩna nɩbɛ 'yɛr, bojũu ba lɩɛb ba tɩɛr a Jona na dɔ̃ɔ 'yɛr a Nãaŋmɩn 'yɛr kʊ ba, yɩ kaa a 'lɔ na gar a Jona ben ka. ");
INSERT INTO biv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nɩrɛ jaa ba be na chʊm fãtɩn na wʊ sɔɔl bar ɛ, bɩɩ de laa kpa pɔɔ ɛ. Wʊ ma dɔɔl bar a dɔɔl fʊ jie, ka a bala na kpɩɛrɛ nyɛ a chãa. ");
INSERT INTO biv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A fʊ nɩbir ɩn a ãgãn fãtɩn. A fʊ nɩbie wa ɩ, a fʊ ãgãn wʊ jaa ma sɛɛn nɩ chãa. Tɩchɛ ala ba wa ɩ ɛ, a fʊ ãgãn wʊ jaa ma ɩn libe. ");
INSERT INTO biv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yɩ kaara sʊ̃ ka a chãa 'lɔ na be a yɩ pɔ, taa lɩɛb libe ɛ, ");
INSERT INTO biv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","A lɛ jũu, ala ɩ a chãa sɛɛn a fʊ ãgãn wʊ jaa ka a libe bãlãa jaa ba be be ɛ, wʊ jaa na ɩn chãa nɩtãa lɛ a fãtɩn na ma chaar fʊ a wʊ chãa.” ");
INSERT INTO biv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu na wa 'yɛr baar, Farasee nɩrɛ ãsʊɔ bʊɔl wʊ naa ka wʊ tɩ di bʊ̃diir, lɛ lɛ wʊ chen tɩ kpɛ jãnɛ a bʊ̃diir par. ");
INSERT INTO biv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tɩchɛ ka a Farasee nɩrɛ jʊrɔ a Yesu ka a ɩ waa pɛɛ a ba pɛɛfʊ ɛ, ka nɛɛ 'maa wʊ. ");
INSERT INTO biv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Be lɛ a Soro pãa 'yɛr kʊ wʊ, “Faa nyɛ, a yɩn Faraseemɩne ma pɛɛr naa a ŋmama nɩ a laar dũkur, tɩchɛ ka a yɩ pʊɔ sɛɛn fɔlfʊ nɩ putuo. ");
INSERT INTO biv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Jɔlɔ banyã, a ba ɩ a 'lɔ na maal a yõo 'lɔ lɛ mɩ maal a pʊɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tɩchɛ a ala na be a laa pʊɔm, yɩ de kʊ a nɔ̃n dẽme ka a bonsɩ a jaa pãa vɩɛlɛ kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nɛbier ben a yɩn Faraseemɩne sɛ̃, bojũu bʊ̃bile jaa yɩn da lɔ̃ɔn badʊʊ gba vaar, yɩ ma ir a da ŋmaa tɩ na yɩ ĩin vɩla maalfʊ nɩ Nãaŋmɩn nʊ̃fʊ bar. Ala lɛ yɩn taa irɛ na yɩ ta ĩin a ala na de nie bar ba maal ɛ. ");
INSERT INTO biv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nɛbier ben a yɩn Faraseemɩne sɛ̃, bojũu yɩ nʊ̃ naa a nɩbɛrɛ jaa jie a yɩ lɔ̃ɔfʊ yie pɔ na yɩ mɩ nʊ̃ a daa pɔ puorfʊ. ");
INSERT INTO biv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nɛbier ben a yɩ sɛ̃, bojũu yɩ kaara naa fɩka yar nɩbɛ na ba bɔ̃ɔ ɛ, tɩ do yʊɔrɔ.” ");
INSERT INTO biv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ka a Mosesɩ Nɛɛ wiwile ãsʊɔ 'yɛr, “Wiwile, a anyãna fʊn 'yɛr, sɩ jaa lɛ fʊ 'mataa tʊrɔ.” ");
INSERT INTO biv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Be lɛ a Yesu 'yɛr wʊ, “A yɩn Mosesɩ Nɛɛ wiwiilbe nɛbier ben a yɩ sɛ̃, bojũu yɩ ma tuon nɩbɛ tuor na tɩrɛ tɩ na yɩ maa ir a yɩ nubir gba tɩɛ 'yɔ̃ɔ ba ɛ. ");
INSERT INTO biv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nɛbier ben a yɩ sɛ̃, bojũu a Nãaŋmɩn 'yɛ'yɛrbɛ bala a yɩ sãamɩne na kʊ, yɩn lɛ mɛ a ba yar. ");
INSERT INTO biv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","A lɛ yɩn maal din dãasɩɛ ɩka a yɩ sãamɩne lɛ. Bala lɛ kʊ a Nãaŋmɩn 'yɛ'yɛrbɛ ka yɩ mɩ mɛ a ba yar. ");
INSERT INTO biv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","A nɩtɔ̃ jũu lɛ a Nãaŋmɩn na ɩ yɛ̃ sʊɔ 'yɛr, ‘N tʊ̃n a n 'yɛ'yɛrbɛ nɩ a n nɩtʊ̃nsɩ a ba sɛ̃, ka ban ir bamɩne kʊ tɩ ge bamɩne.’ ");
INSERT INTO biv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","A lɛ jũu, yele tuon a yɩn dɩna nɩbɛ. A Nãaŋmɩn 'yɛ'yɛrbɛ bala ban kʊ a kõr jaa, yɩn lɛ na yab a ba sãn. ");
INSERT INTO biv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Piel a Abel jãɩ sɔ̃ɔ tɩ tãn a Jekariya ban kʊ a Nãaŋmɩn bɔɔr lofʊ jie nɩ a puorfʊ jie chara pɔ. Ɔ̃ɔ, n 'yɛrɛ na kʊrɔ yɩ ɩka a yɩn dɩna nɩbɛ lɛ na yab a jaa sãn. ");
INSERT INTO biv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nɛbier ben a yɩn Mosesɩ Nɛɛ wiwiilbe sɛ̃, bojũu yɩn lɛ tara a bɔ̃ɔfʊ pãn bir, yɩn mãɛ ba kpɩɛrɛ ɛ, tɩ pɔɔ var a bala na bʊɔrɔ a kpɛfʊ.” ");
INSERT INTO biv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu yin a be wʊn 'yɛr a anyãna, ka a Faraseemɩne nɩ a Mosesɩ Nɛɛ wiwiilbe kpãkpãana wʊ nɩ suur sʊrɔ nɩ wʊ 'yɛr yɔɔ. ");
INSERT INTO biv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Na ba bʊɔrɔ ɩka wʊ 'yɛr 'yɛr lɩɛb nyɔɔ wʊ mãɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","A sɔ̃ɔ 'lɔ̃nɔ̃ pɔ lɛ, a nɩyɔɔ turo turo tire taa na ba nɛɛrɛ taa, ka Yesu piel kpãana a wʊ poturbo na wʊ 'yɛrɛ, “Yɩ gu yɩ mãɛ a Faraseemɩne dãbɩl pɔ, ala lɛ ɩ a ba nɛɛr ayi. ");
INSERT INTO biv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bon jaa ba be be na pɔɔ naa kʊ̃ wa yuo ɛ, bɩɩ sɔɔl ka ba kʊ̃ bɔ̃ɔn ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ala yɩn 'yɛr libe pɔ, na yin chãa pɔ, ka ba wõ naa, ka a ala yɩn bʊl 'yɛr be a die pɔ, ban mʊɔl 'yɛr be a gar ju. ");
INSERT INTO biv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“N 'yɛrɛ na kʊrɔ a yɩn na ɩ a n barmɩne ɩka, yɩ ta joro a bala na kʊ a yɩ ãgãn ɛ, tɩ na ba kʊ̃ lɛ tʊ̃ɔ yele jaa ɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tɩchɛ ɩn wiil yɩ naa a 'lɔ yɩn na joro. Yɩ joro a 'lɔ na tʊ̃ɔ kʊ yɩ, tɩ lɛ tʊ̃ɔ lɔb yɩ 'yɔ̃ɔ a dɔɔyɛ jie. Ɔ̃ɔ, 'lɔ lɛ n 'yɛrɛ ɩka yɩ joro. ");
INSERT INTO biv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","A ba ɩ kobsɩ ayi lɛ ba ma dãn tiitasɩ anũu ɛ? Tɩchɛ Nãaŋmɩn maa ĩin a ba bʊ̃'yen bar ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Sɩrɛ jaa, Nãaŋmɩn sɔr a yɩ jukɔɔl a jaa bɔ̃ɔ, yɩ ta joro dãbãɛ ɛ, yɩ gar tiita yɔɔ. ");
INSERT INTO biv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“N 'yɛrɛ na kʊrɔ yɩ ɩka, nɩrɛ 'lɔ jaa na wa 'yɛr chã a nɩbɛ niem, ɩka wʊ bɔ̃ɔ naa a maa Nɩsaal Bie, 'lɔ lɛ n mɩ na 'yɛr chã ɩka, n bɔ̃ɔ wʊ naa a Nãaŋmɩn malakasɩ niem. ");
INSERT INTO biv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tɩchɛ 'lɔ mɩ na chiir ma a nɩbɛ niem, 'lɔ lɛ n mɩ na chiir a Nãaŋmɩn malakasɩ niem. ");
INSERT INTO biv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nɩrɛ jaa na 'yɛr 'yɛr kpɛ̃n a maa Nɩsaal Bie na chɛnɛ na nyɛ vɛ̃ kʊ fʊ, tɩchɛ nɩrɛ 'lɔ na 'yɛr 'yɛrdɛɛr 'yɔ̃ɔ a Nãaŋmɩn Sɩɛ kʊ̃ nyɛ vɛ̃ kʊ fʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Bala wa nyɔɔr yɩ chiin a lɔ̃ɔfʊ yie nɩbɛrɛ nɩ a kpãɛn dẽme sɛ̃, yɩ ta vɛ̃ ka a ɩ yɩ tɩɛr a lɛ yɩn na tɩ 'yɛr faa yɩ mãɛ ɛ, bɩɩ a lɛ yɩn na 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bojũu a daar 'lɔ̃nɔ̃ Nãaŋmɩn Sɩɛ na wiil yɩ naa a lɛ yɩn na 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ka nɩrɛ kɔ̃ɔ na be a nɩyɔɔ bala pɔ 'yɛr kʊ wʊ, “Wiwile 'yɛr a n yɛbɛ ka wʊ ɩ a sɩ põ a kpĩi bonsɩ.” ");
INSERT INTO biv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A Yesu 'yɛr wʊ, “Daba, an 'yɔ̃ɔ ma ɩka n ɩ 'yɛr tɔɔrɔ naa põnõ yɩ kpĩi bomo?” ");
INSERT INTO biv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tɩ na wʊ 'yɛr kʊ ba, “Yɩ kaara sʊ̃, na yɩ gu yɩ mãɛ a bʊ̃yɔɔ bɔfʊ pɔ, nɩrɛ bʊ̃yɔɔ ba kʊrɔ wʊ nyɛvʊr ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Be lɛ wʊ lɔb a sʊkpa nyã kʊ ba, “Danãa kɔ̃ɔ lɛ dɔ̃ɔ be be, na wʊ kɔ chɛ yɔɔ jaa a wʊ puo pɔ. ");
INSERT INTO biv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Na wʊ piel tɩɛrɛ ɩka ŋmɩnɛ lɛ wʊn ɩ, ‘Ɩn ba tara jie na bin a bonsɩ ɛ?’ ");
INSERT INTO biv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nɩtɔ̃ lɛ ɩn ɩ, ‘Ɩn ŋmɛr a bobo anyãna bar, tɩ naa mɛ bʊ̃bɛrɛ naa su a chi 'yɔ̃ɔn a bonsɩ a be. ");
INSERT INTO biv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tɩ pãa 'yɛr kʊ n mãɛ, ãgãn, pɛnɛ, n tara na bʊ̃yɔɔ ɩn bin kʊ n mãɛ yuon kʊ̃ bɔ̃ɔ sɔr ɛ. Ɩn dire naa, na n nyuro, na n chɩlɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tɩchɛ ka a Nãaŋmɩn 'yɛr kʊ wʊ, ‘Jɔl nyã, fʊn kpin a tãsɔɔ nyãna, tɩ a bonsɩ ala fʊn bin kʊ a fʊ mãɛ, an lɛ na de?’ ");
INSERT INTO biv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nɩtɔ̃ lɛ an be nɩrɛ jaa na bin bonsɩ kʊ a wʊ mãɛ, tɩ ba ɩ tara sʊɔ Nãaŋmɩn sɛ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kaa Yesu pãa 'yɛr kʊ a wʊ poturbo, “A lɛ jũu, n 'yɛrɛ na kʊrɔ yɩ ɩka, yɩ ta waala a yɩ nyɛvʊr 'yɔ̃ɔ ɛ, 'yɛrɛ ɩka bo lɛ yɩn di ɛ. Bɩɩ waala ɩka bo lɛ yɩn su pɔɔ a ãgãn ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A nyɛvʊr gar naa a bʊ̃diir, ka a ãgãn mɩ gar a fɔɔr. ");
INSERT INTO biv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yɩ kaa a gagasɩ, ba maa bʊr ɛ, bɩɩ ŋma ɛ, bɩɩ tara boor ma bin ɛ, tɩchɛ Nãaŋmɩn lɛ guolo ba. Yɩn, yɩ gar a lubil. ");
INSERT INTO biv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A yɩ buor sʊɔ lɛ na waal na wʊ wa de bɩbir bʊ̃'yen pʊɔ a wʊ nyɛvʊr pɔ? ");
INSERT INTO biv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ala ɩ yɩ kʊ̃ tʊ̃ɔ a yelbile nyãna ɩ ɛ, ŋmɩnɛ a yɩ tɩɛrɛ a ala na chɛ? ");
INSERT INTO biv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Yɩ kaa nyɛ a lɛ a bonsɩ puul na ma nʊ̃ɔ. Ba maa tʊ̃ ɛ, bɩɩ wob fuu su ɛ, tɩchɛ a nãa Solomon gba nɩ a wʊ bʊ̃tarsɩ ba dɔ̃ɔ su fuu ka wʊ vɩɛlɛ gar naa ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ala ɩ nɩtɔ̃ lɛ a Nãaŋmɩn ma pãɛ a bonsɩ puul a mʊ̃ɔ pɔ ka a vɩɛlɛ a dɩna tɩchɛ ka a wɛr chaar ka a bũu di, wʊ kʊ̃ pãɛ a yɩn gar a lɛ ɛ? Yɩn sɔɔfʊ na ba jã bon ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yɩ ta ir nyãa 'yɔ̃ɔ a ala yɩn na di bɩɩ nyũ pɔ ɛ, yɩ ta vɛ̃ ka a yɩ pɩla ɔɔrɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nɩrɛ jaa, ala puor lɛ ba turo, tɩchɛ a yɩ Sãa bɔ̃ɔ naa ɩka yɩ bʊɔrɔ naa a bonsɩ anyãna. ");
INSERT INTO biv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yɩ de nie bɔ a Nãaŋmɩn nãalʊ̃ʊ, ka anyãna a jaa wʊn den pʊɔ yɩ. ");
INSERT INTO biv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Yɩn piir na ba jã bon ɛ, yɩ ta joro dãbãɛ ɛ, bojũu a yɩ Sãa pʊɔ pɛl naa wʊn kʊ yɩ a wʊ nãalʊ̃ʊ. ");
INSERT INTO biv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yɩ da a yɩ bonsɩ de a libie põ nɔ̃n dẽme, yɩn tara naa a libie wʊʊr ala na ba sɔ̃ɔnɔ̃ ɛ. Ka a yɩ bʊ̃tarsɩ be a saaju, naa kʊ̃ wur ɛ. Nãnyie kʊ̃ gbʊr be ɛ, kpolo ba be be na mʊʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bojũu, a jie a yɩ bʊ̃tarsɩ na be, be lɛ a yɩ nyãa mɩ ma gã. ");
INSERT INTO biv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Yɩ chɔɔr yɩ mãɛ gu tɩ chʊm a yɩ fãtɩnsɩ ka a lɩrɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yɩ kaara fɩka tʊ̃tʊ̃nbɔ na chɛlɛ a ba nɩkpɛ̃ɛ ka wʊn yi a pɔɔ kulfʊ jie wa. 'Lɔ wa kpoor a pãn ban yuo wʊn a pãn ajienaa ka wʊ kpɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","An ɩn bɔɔsʊ̃n kʊ a tʊ̃tʊ̃nbɔ banyãna a ba nɩkpɛ̃ɛ na wa nyɛ ba ka ba chɛnɛ jɛ̃ gu wʊ. Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka wʊn chɔɔr naa a wʊ mãɛ ka ba 'mataa jãnɛ a bʊ̃diir jie ka wʊ põ ba a bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","An ɩn bɔɔsʊ̃n kʊ a tʊ̃tʊ̃nbɔ bala a ba nɩkpɛ̃ɛ na wa nyɛ ban chɔɔr, ala ɩ gba ka tãsɔɔ põn lɛ bɩɩ, ka nɔrsɩ kõnõ naa. ");
INSERT INTO biv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tɩchɛ yɩ bɔ̃ɔ a par, ɩka ala ɩ a yir sʊɔ bɔ̃ɔ naa a sɔ̃ɔ 'lɔ a nãnyie na waara, wʊ kʊ̃ sɔɔ ka a nãnyie kar a pãn tɩ kpɛ a yir ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","A yɩn mɩ yɩ chɔɔr gu, bojũu a maa Nɩsaal Bie na lɩɛb wa a sɔ̃ɔ 'lɔ yɩn ba lɛ tɩɛrɛ ma ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ka a Pita sʊʊr wʊ, “N Soro, sɩn lɛ fʊ lɔb a sʊkpa nyã kʊ bɩɩ nɩrɛ jaa lɛ?” ");
INSERT INTO biv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ka a Yesu 'yɛr, “An lɛ pãa ɩ a yelmãɛ nɩ a yɛ̃ sʊɔ, a wʊ nɩkpɛ̃ɛ na 'yɔ̃ɔ ka wʊ kaara wʊ a yir, na wʊ kʊrɔ a tʊ̃tʊ̃nbɔ a ba bʊ̃diir a sɔ̃ɔ 'lɔ na sɛɛ? ");
INSERT INTO biv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","An ɩn bɔɔsʊ̃n kʊ a tʊ̃tʊ̃nɔ̃ nyãna a wʊ nɩkpɛ̃ɛ na wa nyɛ wʊn ɩrɛ a lɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, wʊn vɛ̃n ka wʊ kaara a wʊ bonsɩ a jaa. ");
INSERT INTO biv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tɩchɛ ala ɩ a tʊ̃tʊ̃nɔ̃ nyãna tɩɛr a wʊ nyãa pɔ ɩka, a n nɩkpɛ̃ɛ kor a waa, tɩ piel pɔɔrɔ a tʊ̃tʊ̃nbɔ bala na be a yir, tɩ pãa ma di na wʊ nyũ buu. ");
INSERT INTO biv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","A tʊ̃tʊ̃nɔ̃ nyãna, a wʊ nɩkpɛ̃ɛ na wa dũu wʊ naa a bɩbir 'lɔ wʊn ba tɩɛrɛ nɩ a sɔ̃ɔ 'lɔ wʊn ba bɔ̃ɔ ɛ. Wʊn ŋma wʊn jaa gbʊl gbʊl, tɩ lɔb wʊ 'yɔ̃ɔ a bala na ba sɔɔ de pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A tʊ̃tʊ̃nɔ̃ 'lɔ na bɔ̃ɔ lɛ a wʊ nɩkpɛ̃ɛ na bʊɔrɔ tɩ na waa chɔɔr tʊ̃n a lɛ a nɩkpɛ̃ɛ na bʊɔrɔ ɛ, wʊn nyɛn ŋmefʊ yɔɔ. ");
INSERT INTO biv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tɩchɛ a 'lɔ na ba bɔ̃ɔ ɛ, tɩ maal bɔr ban ŋme wʊn jaa bãlãa. Nɩrɛ 'lɔ ban kʊ yɔɔ ban bʊɔrɔ na yɔɔ yi a wʊ sɛ̃, fʊ̃ʊ nũu pɔ ban 'yɔ̃ɔ yɔɔ, fʊ̃ʊ lɛ ban sʊʊr yɔɔ. ");
INSERT INTO biv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Bũu lɛ n waan ɩka n wa 'yɔ̃ɔ a wɛr pɔ, ɩn taa bʊɔrɔ naa ala ɩ a ben ta 'lɩrɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tɩchɛ n chɛnɛ tara yele ɩn na ɩ Nãaŋmɩn kʊ̃ɔ sofʊ kaar ka a ɩ ma tɩɛr tɩ tãn ɩn na wa baar. ");
INSERT INTO biv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yɩ maa tãan nɛbʊ̃'yen yele lɛ n waan a wɛr pɔ bɩɩ? Kai, n 'yɛr kʊ yɩ, tɩchɛ ootaa lɛ n waan. ");
INSERT INTO biv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","An yi a dɩna nɩbɛ anũu na kpɩɛrɛ yir na ŋman jiir ayi. Ka ata jɛɛrɛ nɩ a ayi ka ayi mɩ jɛɛrɛ nɩ a ata. ");
INSERT INTO biv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ban ooro nɩ taa, sãa na oon bie ka a bie mɩ oo a sãa, ka a ma oo a bipɔɔ ka a bipɔɔ mɩ oo a ma. Pɔɔ na oo naa a wʊ bidaba pɔɔ, ka a bidaba pɔɔ mɩ oo a wʊ sɩrɛ ma.” ");
INSERT INTO biv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ka a Yesu 'yɛr kʊ a nɩyɔɔ bala, “Yɩn wa nyɛ julõjuur na ire a mɔ̃tɔ̃ɔ mʊrfʊ jie yɩ ma 'yɛr ɩka saa na wa naa, ka a ma ɩ a lɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yɩn wa nyɛ sɛsɛbɛ mɩ na furo duoro jũu, yɩ ma 'yɛr ɩka tʊl na wa naa. Ka a ma ɩ a lɛ. ");
INSERT INTO biv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","A yɩn nɛɛr ayi dẽme banyãna. Yɩ bɔ̃ɔn a tẽe nɩ a saaju 'yɛr ma 'yɛr, ŋmɩnɛ a yɩ kʊ̃ tʊ̃ɔ a dɩna 'yɛr 'yɛr ɛ? ");
INSERT INTO biv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Bo lɛ so ka yɩn mãɛ kʊ̃ tʊ̃ɔ tɔɔr a lɛ na tor ɛ? ");
INSERT INTO biv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","An ɩ a yɩn nɩ a yɩ sãn sʊɔ lɛ 'mataa chiine, yɩ mʊlɔ wʊ a sɔr pɔ, ka lɛ ba lɛ ɛ, wʊn de yɩn 'yɔ̃ɔ a 'yɛr tɔɔrɔ nũu pɔ, ka wʊ de yɩ kʊ a nɩpɔɔrɔ ka wʊ mɩ pɔɔ yɩ bar. ");
INSERT INTO biv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","N 'yɛrɛ na kʊrɔ yɩ ɩka, ala be ɩ a lɛ, faa be na wa yi ka faa yab a fʊ sãn baar ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nɩbɛ bamɩne mɩ ben be a sɔ̃ɔ 'lɔ̃nɔ̃, na ba pãa mana kʊrɔ a Yesu a lɛ a paal nɩkpɛ̃ɛ Pilate na dɔ̃ɔ kʊ a Galilee dɔɔr bamɩne, a sɔ̃ɔ 'lɔ ban be a bɔɔr lofʊ jie. ");
INSERT INTO biv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A Yesu 'yɛr kʊ ba, “Yɩ tɩɛr ɩka bala lɛ maal dɛɛr gar a Galilee nɩbɛ ba jaa, ala lɛ so ban di a dɔɔyɛ nyã bɩɩ? ");
INSERT INTO biv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A ba ɩ lɛ lɛ ɛ, tɩchɛ n 'yɛrɛ na kʊrɔ yɩ ɩka yɩn ba wa lɩɛb a yɩ tɩɛr ɛ, yɩ mɩ na wɛ naa. ");
INSERT INTO biv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bɩɩ a nɩbɛ pie nɩ aniin (18) bala a jiwõo 'lɔ na kar lo kʊ a Siloam, yɩ tɩɛr ɩka bala lɛ maal yeldɛɛr gar a bala jaa na kpɩɛrɛ a Jerusalɛm bɩɩ? ");
INSERT INTO biv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","N 'yɛrɛ na kʊrɔ yɩ ɩka lɛ ba lɛ ɛ, tɩchɛ yɩn mɩ baa lɩɛb a yɩ tɩɛr ɛ, yɩ mɩ na wɛ naa.” ");
INSERT INTO biv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","A sʊkpa nyã lɛ Yesu pãa lɔb kʊ ba, “Daba kɔ̃ɔ lɛ tara kɔ̃kɔ̃tɩɛ a wʊ puo pɔ, a wʊ wa chen ɩka wʊ tɩ kaa a tɩɛ wɔ̃n bɩɩ, tɩchɛ a tɩɛ ba wɔ̃ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Be lɛ wʊ 'yɛr kʊ a nɩrɛ 'lɔ wʊn vɛ̃ ka wʊ kaara a puo, ‘Bojũu, yuom ata nɩ nyã ɩn yɔ ka, ma bʊɔrɔ a wɔ̃mɔ̃ ɩka n pɔr tɩ ma wa bɔ faa. Ŋmaa wʊ lɔb, ŋmɩnɛ an ɩ ka wʊ pii a wɛr ara nɩ?’ ");
INSERT INTO biv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ka a 'lɔ na kaara a puo 'yɛr, ‘Nɩkpɛ̃ɛ, bar wʊ ka n tuu jilʊ̃ 'yɔ̃ɔ pʊɔr ka yuon waara, ");
INSERT INTO biv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","'lɔ wa wɔ̃ go, tɩ 'lɔ ba wa wɔ̃ ɛ, ka n ŋmaa wʊ lɔb.’ ” ");
INSERT INTO biv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","A Pɛ̃nfʊ Bɩbir Daar Yesu ben a lɔ̃ɔfʊ yir ãsʊɔ pɔ wile ba, ");
INSERT INTO biv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","be lɛ a pɔɔ be a sɩdɛbɛ na maal ka wʊ kab gʊ̃mɔ̃ yuom pie nɩ aniin (18), wʊ maa tʊ̃ɔ dɔl ɛ. ");
INSERT INTO biv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu na nyɛ a pɔɔ a lɛ, wʊ bʊɔl wʊ naa ka wʊ wa a wʊ sɛ̃, ka wʊ 'yɛr kʊ wʊ, “Pɔɔ, a fʊ baal bar fʊ naa.” ");
INSERT INTO biv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tɩ na wʊ pãa de a wʊ nũu dɔɔl a pɔɔ, ka a pɔɔ dɔl ajienaa na wʊ pɛɛrɛ a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tɩchɛ ka a suur kpɛ a lɔ̃ɔfʊ yir nɩdier Yesu na sãa a baalaa a Pɛ̃nfʊ Bɩbir Daar jũu, ka wʊ 'yɛr kʊ a nɩbɛ, “Bibie ayʊɔb ben be ka nɩrɛ na de tʊ̃n tʊ̃mɔ̃, yɩ ma wa ka wʊ sãana yɩ a ber ala pɔ, yɩ ta ma waara a Pɛ̃nfʊ Daar ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ka a Soro 'yɛr kʊ wʊ, “Yɩn nɛɛr ayi dẽme banyãna, a yɩ buor sʊɔ lɛ maa yuo a wʊ niin bɩɩ a wʊ bon chiin tɩ 'yɔ̃ɔ kʊ̃ɔ a Pɛ̃nfʊ Bɩbir ɛ? ");
INSERT INTO biv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ka a pɔɔ nyãna na ɩ a Abraham bipɔɔ, a tɩɩ na lũ yuom pie nɩ aniin (18), a ba sɛɛ ɩka wʊ for a Pɛ̃nfʊ Bɩbir Daar bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wʊn wa 'yɛr a nɩtɔ̃ ka a vĩ kpɛ a bala jaa na bɛrɛ wʊ a nɛɛ, tɩchɛ ka a nɩbɛ chɩlɛ a tʊ̃vɩɛlɛ ala wʊn tʊ̃. ");
INSERT INTO biv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","A Yesu pãa 'yɛr, “Bo lɛ a Nãaŋmɩn nãalʊ̃ʊ nyɛtãan? Bo lɛ ɩn de man? ");
INSERT INTO biv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wʊ kaara fɩka kɔ̃kɔ̃ɔ bir nɩrɛ na de bʊr a puo pɔ ka wʊ bul na wʊ ɩ tɩɛ, ka a lubil wa 'yɔ̃ɔ choor a wilsɩ ju.” ");
INSERT INTO biv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wʊ lɛ sʊʊr ban go, “Bo lɛ ɩn de a Nãaŋmɩn nãalʊ̃ʊ man? ");
INSERT INTO biv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wʊ kaara fɩka dãbɩl pɔɔ na de 'yɔ̃ɔ jɔ̃ yɔɔ pɔ ka a ir vʊ̃.” ");
INSERT INTO biv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu wile naa nɩbɛ be a tẽbɛrɛ nɩ a tẽbil ala pɔ tɩ na wʊn chen Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Be lɛ a nɩrɛ ãsʊɔ sʊʊr wʊ, “N Soro, nɩbɛ bãlãa tɛɛ lɛ na nyɛ faafʊ bɩɩ?” Ka wʊ 'yɛr kʊ ba, ");
INSERT INTO biv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Yɩ mɔ̃ tu a dɔ̃dɔ̃ bile pɔ kpɛ, n 'yɛrɛ na kʊrɔ yɩ ɩka nɩyɔɔ lɛ na mʊɔrɔ bʊɔrɔ ɩka ba kpɛ tɩ kʊ̃ tʊ̃ɔ kpɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A yir sʊɔ na wa ir pɔɔ a pãn var yɩ bar be a yõo, ka yɩ ara kpooro sʊɔrɔ, ‘Nɩkpɛ̃ɛ, yuo sɩ a pãn.’ Tɩchɛ ka wʊ 'yɛr kʊ yɩ, ‘N ba bɔ̃ɔ yɩ ɛ, bɩɩ a jie yɩn yi ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ka yɩ pãa 'yɛrɛ, ‘Sɩn nɩ fʊ̃ʊ jaa 'mantaa di tɩ nyũ, a fʊ wiil sɩ be a sɩ tẽe sãlsɔɔ.’ ");
INSERT INTO biv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tɩchɛ ka wʊn 'yɛr, ‘N ba bɔ̃ɔ yɩ ɛ, bɩɩ a jie yɩn yi ɛ, yɩ tɔɔ yi tɩ chɛ ma a yɩn na tʊ̃nɔ̃ a dɛbɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Be lɛ yɩn kõnõ ɔɔrɔ a nyɩmɛ, yɩn wa nyɛ a Abraham, Isaakɩ nɩ Jekɔb nɩ a Nãaŋmɩn 'yɛ'yɛrbɛ ba jaa be a Nãaŋmɩn nãalʊ̃ʊ pɔ, tɩchɛ ka a yɩn 'lɔ be a yõo. ");
INSERT INTO biv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nɩbɛ na yin a mɔ̃tɔ̃ɔ purfʊ jie, a mʊrfʊ jie, a jũu nɩ a par na ba wa jãnɛ dire be a Nãaŋmɩn nãalʊ̃ʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sɩrɛ jaa, nɩbɛ ben puor tɩ na ban wa de nie, ka a bala mɩ na be a niem mɩ wa be a puor.” ");
INSERT INTO biv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A sɔ̃ɔ 'lɔ̃nɔ̃ pɔ lɛ a Faraseemɩne bamɩne wa a Yesu sɛ̃ wa 'yɛr kʊ wʊ, “Yi a ka chen jiyuo. A Hɛrɔd bʊɔrɔ na a fʊ kʊfʊ.” ");
INSERT INTO biv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ka a Yesu 'yɛr kʊ ba, “Yɩ chen tɩ 'yɛr a mɔbaa 'lɔ̃nɔ̃, ɩn dii naa a sɩdɛbɛ ka a yi ka n sãa a nɩbɛ baalsɩ a dɩna nɩ bio ka a dayere daar ka n baar a n tʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Lɛ jaa an ɩ, ɩn chɛnɛ na chiine a dɩna nɩ bio nɩ a dayere. Sɩrɛ jaa lɛ, Nãaŋmɩn 'yɛ'yɛrɛ kʊ̃ kpi ka Jerusalɛm ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Gboo yɩn Jerusalɛm dẽme, yɩn lɛ ma kʊrɔ a Nãaŋmɩn 'yɛ'yɛrbɛ tɩ lɔɔrɔ a bala Nãaŋmɩn na tʊ̃ a yɩ sɛ̃ nɩ kʊsɩbɛ. N ma bʊɔrɔ naa ɩka n kaal a fʊ bibiir 'mataa nɩtãa lɛ nʊ̃ɔ na ma kaal a wʊ bil 'mataa a wʊ pɩrɛ pɔ, tɩ yɩ maa sɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yɩ nyɛ, a yɩ yir na lɩɛb dakpolo, tɩ ka n 'yɛrɛ kʊrɔ yɩ ɩka yɩ kõ lɛ nyɛ ma go ɛ, tɩ tãn a daar 'lɔ yɩn na 'yɛr, ‘Nãaŋmɩn wʊ sʊ̃ʊ a 'lɔ wʊn tʊ̃!’ ” ");
INSERT INTO biv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A Pɛ̃nfʊ Bɩbir ãsʊɔ daar, Yesu chen a Faraseemɩne nɩdiere ãsʊɔ yir difʊ jie ka ba jʊrɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Be lɛ ka daba kɔ̃ɔ na tara a baal vʊ̃ naa ara a wʊ niem. ");
INSERT INTO biv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ka a Yesu sʊʊr a Faraseemɩne nɩ a Mosesɩ nɛɛ bɔ̃ɔnbɔ, “A tara na sɔr ka fʊn sãa nɩrɛ na bɩɛrɛ a Pɛ̃nfʊ Bɩbir bɩɩ a ba tara sɔr ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tɩchɛ ka ba ɩ jaa gbulo, ka Yesu de a nũu dɔɔl a daba sãa a wʊ baal tɩ bar wʊ sɔr. ");
INSERT INTO biv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tɩ na wʊ pãa sʊʊr ba, “Ala ɩ a yɩ ãsʊɔ bie bɩɩ a wʊ nadar lon bulo pɔ a Pɛ̃nfʊ Bɩbir, wʊ kʊ̃ chen tɩ ir wʊ fɔfɔɔ jaa bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Baa lɛ tara 'yɛr na 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu nyɛn a nɩbɛ bala ban bʊɔl ɩka ba wa di, ka ba tuur a nɩbɛrɛ jaa jiir jãnɛ, ka wʊ lɔb a sʊkpa nyã kʊ ba, ");
INSERT INTO biv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nɩrɛ wa bʊɔl fʊ pɔɔ kulfʊ jie, fʊ̃ʊ wa chen ta tɩ jãnɛ a nɩbɛrɛ jaa jie ɛ, amɩne wʊ bʊɔl nɩrɛ na gar fʊ ka wʊn wa. ");
INSERT INTO biv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ala wa ɩ a lɛ, wʊn wa 'yɛr fʊ naa, ‘Ir, ka a daba nyã jãnɛ a fʊ jaa jie.’ Vĩ lɛ fʊn ir tɩ jãnɛ nɩ a puor. ");
INSERT INTO biv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tɩchɛ bala wa bʊɔl fʊ, tɩ jãnɛ a puor, ka a 'lɔ na bʊɔl fʊ wa 'yɛr, ‘N badaba wa jãnɛ ka a niem, be lɛ fʊn pãa vʊ̃ a fʊ taaba niem.’ ");
INSERT INTO biv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bojũu, nɩrɛ jaa na 'mɔɔrɔ wʊ mãɛ saaju, Nãaŋmɩn na siir wʊ naa, 'lɔ mɩ na siir a wʊ mãɛ, Nãaŋmɩn na 'mɔɔ wʊn saaju.” ");
INSERT INTO biv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ka Yesu pãa 'yɛr kʊ a 'lɔ na bʊɔl wʊ, “Fʊ̃ʊ wa bʊɔl nɩrɛ ɩka wʊ wa di, taa wa bʊɔlɔ a fʊ barmɩne, bɩɩ a fʊ yɛɛr, bɩɩ a fʊ bal nɩbɛ, bɩɩ a fʊ tɔ dẽme bala na ɩ tara dẽme ɛ. Ala ɩ fʊ ɩn a lɛ, ban bʊɔl fʊn daar kɔ̃ɔ tɩ yaa a sãn. ");
INSERT INTO biv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tɩchɛ fʊ̃ʊ wa bʊɔlɔ nɩbɛ ɩka ba wa di, bʊɔl a nɔ̃n dẽme, nɩ a gbɛrsɩ, nɩ a nɩbaalsɩ, nɩ a jɔ̃n. ");
INSERT INTO biv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Fʊ̃ʊ lɛ Nãaŋmɩn na sʊ̃ʊ. Ban ba tara bon na yab fʊ ɛ, fʊ̃ʊ lɛ na nyɛ sãyar a lɛ a nɩtʊ̃nsɩ na wa ir a kũu pɔ ɩ vʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ka a bala na lɔ̃ɔ dire ãsʊɔ na wõ a nɩtɔ̃, na wʊ 'yɛr kʊ a Yesu, “An ɩn bɔɔsʊ̃n kʊ a 'lɔ na wa jãnɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ dire.” ");
INSERT INTO biv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Be lɛ a Yesu lɔb a sʊkpa nyã, “Nɩkpɛ̃ɛ kɔ̃ɔ lɛ dɔ̃ɔ chɔɔrɔ na wʊ bʊɔlɔ nɩyɔɔ ɩka ba wa di. ");
INSERT INTO biv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","A sɔ̃ɔ na wa ta, wʊ tʊ̃n a wʊ tʊ̃tʊ̃nɔ̃ ɩka wʊ chen tɩ 'yɛr a bala wʊn bʊɔl ɩka wʊ maal yele a jaa baar. ");
INSERT INTO biv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tɩchɛ ka a ba ãsʊɔ jaa 'yɛr ɩka ba kʊ̃ nyɛ jie ɛ. Ka a 'lɔ ban dɔ̃ɔ ta ka wʊ 'yɛr, ‘N dãn popaalaa naa chiine ɩka n tɩ kaa, n kʊ̃ tʊ̃ɔ tɩ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ka a ãsʊɔ mɩ 'yɛr, ‘N dãn narkʊɔrsɩ pie naa jãna n kʊ̃ tʊ̃ɔ tɩ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ka a ãsʊɔ mɩ 'yɛr, ‘Pɔɔ lɛ n de n kʊ̃ tʊ̃ɔ tɩ be ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“A tʊ̃tʊ̃nɔ̃ lɩɛb wa 'yɛr a nɩtɔ̃ kʊ a wʊ nɩkpɛ̃ɛ, ka a suur kpɛ a nɩkpɛ̃ɛ ka wʊ 'yɛr kʊ a tʊ̃tʊ̃nɔ̃, ‘Lɩɛb chen fɔfɔɔ jaa a tẽe sãlsɔɔ nɩ a kõkorsɩ pɔ, na fʊ tɩ bʊɔl a nɔ̃n dẽme, a gbɛrsɩ, jɔ̃n nɩ a nɩbaalsɩ waan.’ ");
INSERT INTO biv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ka a tʊ̃tʊ̃nɔ̃ wa 'yɛr, ‘Nɩkpɛ̃ɛ, n ɩ naa a lɛ fʊn 'yɛr ɩka n ɩ, tɩchɛ ka a jie chɛnɛ be be.’ ");
INSERT INTO biv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Be lɛ a nɩkpɛ̃ɛ pãa lɛ 'yɛr kʊ a tʊ̃tʊ̃nɔ̃, ‘Yi chen a sɔɩ pɔ, nɩ a sɛɛr pɔ tɩ bʊɔl nɩbɛ waan ka n yir wa sɛɛ. ");
INSERT INTO biv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","N 'yɛrɛ na kʊrɔ yɩ ɩka ãsʊɔ jaa kʊ̃ lɛ̃ maa ɛ.’ ” ");
INSERT INTO biv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesu nɩ a nɩyɔɔ 'mantaa chiine, ka wʊ lɩɛb kaa ba tɩ 'yɛr, ");
INSERT INTO biv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ala ɩ nɩrɛ na wa naa a n sɛ̃, na waa 'laar a wʊ sãa nɩ a wʊ ma, nɩ a wʊ pɔɔ, a wʊ bibiir, a wʊ yɛɛr nɩ a wʊ yɛpɔbɔ 'matãan a wʊ mãɛ nyɛvʊr ɛ, wʊ kʊ̃ tʊ̃ɔ ɩ a n poturo ɛ. ");
INSERT INTO biv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nɩrɛ 'lɔ mɩ na ba de a wʊ daa tuo turo nɩ ma ɛ, wʊ kʊ̃ tʊ̃ɔ ɩ a n poturo ɛ. ");
INSERT INTO biv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ala ɩ a yɩ ãsʊɔ bʊɔrɔ na yir kpɛ̃ɛ mɛfʊ, a ba ɩ wʊn den nie jãnɛ guor kaa ala ɩ wʊ tara naa a libie na tʊ̃ɔ mɛn baar ɛ? ");
INSERT INTO biv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Na wʊ taa kpar a yir tɩ ba tʊ̃ɔ baar ɛ, ka a wʊ taaba nyɛ laara wʊ ");
INSERT INTO biv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","'yɛrɛ, ‘Jaal piel a mɛfʊ tɩ na waa baar ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Bɩɩ nãbuor lɛ bʊɔrɔ ɩka wʊ tɩ jɛb a wʊ nãa tɔ sʊɔ na waa de nie jãnɛ kaa ɩka wʊn tʊ̃ɔ de a wʊ nɩbɛ turo pie (10,000) tɩ jɛb a 'lɔ na waara nɩ a wʊ nɩbɛ turo lɩjɛr (20,000) ɔ? ");
INSERT INTO biv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ala ɩ wʊ kʊ̃ tʊ̃ɔ ɛ, wʊn tʊ̃n nɩbɛ ka ba chen tɩ 'maal a nãa 'lɔ na chɛnɛ be a tɛɛr. ");
INSERT INTO biv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Lɛ mɩ lɛ, a yɩ ãsʊɔ jaa baa bar a wʊ bonsɩ a jaa ɛ, wʊ kʊ̃ tʊ̃ɔ ɩ a n poturo ɛ. ");
INSERT INTO biv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nyaar ɩ naa, tɩchɛ a wʊ nʊ̃ɔ wa baar, ŋmɩnɛ ban lɛ ɩ wʊ ka wʊ lɛ nʊ̃mɔ̃ go? ");
INSERT INTO biv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wa vɩɛl kʊ a tãpuor tãna ɛ, ban lɔb bar. Nɩrɛ 'lɔ na tara toor wõnõ, vɛ̃ ka wʊ wõ naa.” ");
INSERT INTO biv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","A lõpodierbe nɩ a tʊ̃dɛtʊ̃nbɔ lɔ̃ɔn taa na chɛl a Yesu 'yɛr. ");
INSERT INTO biv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tɩchɛ ka a Faraseemɩne nɩ a Mosesɩ nɛɛ wiwiilbe hũhũnõ 'yɛrɛ, “A daba nyã diere naa tʊ̃dɛtʊ̃nbɔ ka ba 'mataa dire.” ");
INSERT INTO biv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","A Yesu pãa lɔb a sʊkpa nyã kʊ ba, ");
INSERT INTO biv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ala ɩ a yɩ ãsʊɔ tara na piir kɔbaa ka a bʊ̃'yen wa bɔr, a ba ɩ wʊn bar a kɔbaa forbir ala a pɛchiin baa pɔ, tɩ yʊɔrɔ bʊɔrɔ a bʊ̃'yen 'lɔ tɩ tãn a sɔ̃ɔ 'lɔ jaa wʊn wa tɩ nyɛ wʊ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","'Lɔ wa nyɛ a pɛr nʊ̃ɔ ma kpɛ wʊ naa ka wʊ 'mɔɔ dɔɔl bɔɔ ju ");
INSERT INTO biv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","kulo nɩ a yir, tɩ pãa bʊɔlɔ a wʊ barmɩne nɩ a wʊ taaba lɔ̃ɔ taa tɩ 'yɛr, ‘Yɩ pʊɔ ma chɩlɛ, bojũu n nyɛ naa a n pɛr 'lɔ na bɔr.’ ");
INSERT INTO biv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","N 'yɛrɛ na kʊrɔ yɩ ɩka a lɛ nɛ nɩ wʊ ju mɩ lɛ, chɩl kpɛ̃ɛ na ben a saaju a tʊ̃dɛtʊ̃nɔ̃ bʊ̃'yen na lɩɛb a wʊ tɩɛr gar a kɔbaa forbir bala na ba tara tɩɛr lɩɛb fʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Bɩɩ pɔɔ buor lɛ tara libibie pie ka ãsʊɔ bɔr, wʊ kʊ̃ chʊm bũu den saar pɩɩr a die wʊ jaa na wʊ wa tɩ nyɛ wʊ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","'Lɔ wa nyɛ wʊ, wʊ ma bʊɔl a wʊ barmɩne nɩ a wʊ taaba lɔ̃ɔ taa tɩ 'yɛr, ‘Yɩ pʊɔ ma chɩlɛ, n nyɛ naa a n libir na bɔr.’ ");
INSERT INTO biv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Lɛ nɛ nɩ wʊ ju mɩ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, nʊ̃ɔ mɩ na kpɛ naa a Nãaŋmɩn malakasɩ ala ɩ a tʊ̃dɛtʊ̃nɔ̃ bʊ̃'yen lɩɛb a wʊ tɩɛr.” ");
INSERT INTO biv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu chɛnɛ na 'yɛrɛ kʊrɔ ba, “Daba lɛ tara wʊ dabil ayi. ");
INSERT INTO biv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ka a bile sʊɔ wa 'yɛr kʊ a sãa, ‘N sãa, põ a fʊ kpĩi bomo ir a n bon kʊ ma.’ Ka a sãa de a wʊ kpĩi bomo põ ba. ");
INSERT INTO biv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A ba kor ɛ, ka a bile 'lɔ lɔ̃ɔ taa a wʊ bonsɩ a jaa yi chiin tẽyuo pɔ, na wʊ tɩ bũbur a bonsɩ sɔ̃ɔ a jaa bar. ");
INSERT INTO biv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wʊn wa sɔ̃ɔ a jaa baar, ka a kɔ̃ lo a tẽe 'lɔ pɔ, ka a wõm piel kpɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wʊ chen a tẽe 'lɔ pɔ nɩrɛ ãsʊɔ yir tɩ bɔ tʊ̃mɔ̃, ka a nɩrɛ 'lɔ ma tʊ̃ wʊ ka wʊ chen a puo pɔ tɩ 'yɔ̃ɔ a wʊ dor bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A jɔ̃ pɛbɛ ala ma ɩrɛ wʊn vɔlaa ka wʊ bʊɔrɔ ɩka wʊ 'wɔb tɩɩ, tɩchɛ nɩrɛ jaa maa kʊ wʊ bon ɛ. ");
INSERT INTO biv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ka a yɛ̃ wa wʊ ka wʊ 'yɛr, ‘N sãa tara na tʊ̃tʊ̃nbɔ a ŋmɩnɛ a ba ma di bʊ̃diir faa, tɩchɛ ka a maa wa kpire nɩ kɔ̃ ka? ");
INSERT INTO biv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ɩn lɩɛb kul a n sãa sɛ̃ naa tɩ 'yɛr wʊ, n maal dɛɛr Nãaŋmɩn sɛ̃ nɩ a fʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","N ba lɛ chɛnɛ sɛɛ ka ban bʊɔl ma a fʊ bie ɛ, maal ma ka n ɩ a fʊ tʊ̃tʊ̃nɔ̃ ãsʊɔ.’ ");
INSERT INTO biv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Lɛ wʊ ir kulo a sãa sɛ̃. Tɩchɛ wʊn chɛnɛ be a nɩdaa waara, a sãa nyɛ wʊ naa ka nɩbaal kpɛ wʊ ka wʊ jotuor a bie kõr tɩ puor wʊ. ");
INSERT INTO biv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ka a bidaba 'yɛr kʊ wʊ, ‘N sãa, n maal dɛɛr Nãaŋmɩn sɛ̃ nɩ a fʊ sɛ̃, n ba lɛ sɛɛn ka ban bʊɔl ma a fʊ bie go ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tɩchɛ ka a sãa 'yɛr kʊ a gbãgbaar, ‘Yɩ pɔɔ fɔɔ tɩ de fuu nyã na vɩɛlɛ wa su wʊ, na yɩ de bɔ̃bile 'yɔ̃ɔ wʊ a nubir pɔ, na yɩ de nafɔbɔ wa su wʊ. ");
INSERT INTO biv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yɩ tɩ kaa nele na 'wɔr na yɩ waan wa kʊ ka sɩ 'wɔb tɩ chɩlɛ. ");
INSERT INTO biv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bojũu a n bidaba nyãna dɔ̃ɔ kpi tɩ lɛ ir ɩ vʊr, wʊ dɔ̃ɔ bɔr tɩ sɩ lɛ nyɛ wʊ.’ Ka ba piel chɩlɛ. ");
INSERT INTO biv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tɩchɛ ka a bidakpɛ̃ɛ 'lɔ be a puo pɔ, na wʊ wa ir waara, wʊn wa gbʊrɔ a yir wʊ wõn bãnɛ nɩ chɛlsɩ. ");
INSERT INTO biv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Be lɛ wʊ bʊɔl a gbãgbaa ãsʊɔ na wʊ sʊʊr a yelnyɩnɛ na be be. ");
INSERT INTO biv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ka a gbãgbaa 'yɛr kʊ wʊ, ‘A fʊ yɛbile lɛ wa ka a fʊ sãa ɩ a ba kʊ nel'wɔr jaa, bojũu wʊ nyɛn a wʊ bie na lɩɛb wa nɩ lãafɩɛ tɩ chɛnɛ kpɛ̃mɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","A suur kpɛ a yɛkarma ka wʊ jɛ, waa kpɛ ɛ. Ka a sãa yi 'maala wʊ ɩka wʊ kpɛ. ");
INSERT INTO biv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tɩchɛ ka wʊ 'yɛr kʊ a sãa, ‘Nyɛ lɛ ɩn wõnõ a fʊ toor naa tʊ̃nɔ̃ kʊrɔ fʊ a yuom anyãna a jaa, n ba gɔ̃ɔ fʊ nɛɛ jaa ɛ. Tɩchɛ faa mɩ wa kʊ ma bule gba ɩka, n mɩ kʊ ka maa nɩ a n barmɩne mɩ 'mataa di tɩ chɩlɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tɩchɛ a fʊ bibawõno nyãna na de a fʊ bonsɩ yin ka a 'lɔ nɩ a pɔɔ baar tɩ 'mataa sɔ̃ɔ bar, tɩ lɩɛb wa a yir ka fʊ ir kʊ nel'wɔr kʊ wʊ.’ ");
INSERT INTO biv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ka a sãa 'yɛr, ‘Fʊ̃ʊ 'lɔ, fʊ ben a n sɛ̃, ka a bomo a jaa ɩn tara ɩ a fʊ bonsɩ. ");
INSERT INTO biv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tɩchɛ a sɛɛ naa ka sɩn dãɛnɛ na sɩ chɩlɛ bojũu a fʊ yɛbile nyãna dɔ̃ɔ kpi tɩ lɛ ɩ vʊr go, na wʊ dɔ̃ɔ bɔr tɩ sɩ lɛ nyɛ wʊ.’ ” ");
INSERT INTO biv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu 'yɛr kʊ a wʊ poturbo ɩka, “Taraa sʊ̃ɔ kɔ̃ɔ lɛ dɔ̃ɔ be be, na wʊ tara nɩrɛ na kaara wʊ a bonsɩ, na wʊ pʊ̃pʊrɔ bara. ");
INSERT INTO biv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ka wʊ bʊɔl wʊ waan wa sʊʊr, ‘N wõn ban 'yɛrɛ a fʊ 'yɛr yʊɔrɔ nɩ, man a lɛ fʊn tʊ̃ kʊ ma, bojũu fʊ kʊ̃ lɛ tʊ̃ɔ tʊ̃ a tʊ̃mɔ̃ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ka a tʊ̃tʊ̃nɔ̃ 'yɛr kʊ a wʊ mãɛ, ‘Ŋmɩnɛ lɛ ɩn pãa ɩ a pʊ̃pãanyã? A n nɩkpɛ̃ɛ faa man a tʊ̃mɔ̃, n mɩ ba lɛ kpɛ̃mɛ na tʊ̃ɔ kɔ ɛ, a mɩ na ɩn vĩ ɩn na sʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","N bɔ̃ɔ lɛ ɩn na ɩ maa ba lɛ wa tara tʊ̃mɔ̃ ɛ, tɩchɛ ka nɩbɛ chɛnɛ de ma a ba yie.’ ");
INSERT INTO biv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Be lɛ wʊ bʊɔl a wʊ nɩkpɛ̃ɛ sãma dẽme ba jaa na wʊ sʊʊr a 'lɔ na de nie, ‘A ŋmɩnɛ lɛ fʊ di a n nɩkpɛ̃ɛ sãn?’ ");
INSERT INTO biv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ka wʊ 'yɛr, ‘Kãlaar kɔbaa (100) lɛ n di a sãn.’ Ka a 'lɔ na kaara a bonsɩ 'yɛr, ‘De a gãn nyãna jɛn fɔɔ jaa na fʊ sɛb lɩjaayi nɩ pie (50).’ ");
INSERT INTO biv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tɩ na wʊ lɛ sʊʊr a ayi sʊɔ, ‘A ŋmɩnɛ fʊ mɩ di a n nɩkpɛ̃ɛ sãn?’ Ka wʊ 'yɛr, ‘Chi bɔtɔr kɔbaa (100) sãn lɛ n di.’ Ka wʊ 'yɛr, ‘De a fʊ gãn na fʊ sɛb lɩjaa naar 'yɔ̃ɔ (80).’ ");
INSERT INTO biv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ka a nɩkpɛ̃ɛ dãn a tʊ̃tʊ̃nɔ̃ nyãna na ba tara yelmãɛ ɛ, bojũu wʊ tɩɛr nɩdaar. A wɛr nyã nɩbɛ tara na yɛ̃ a ba taaba jie gar a chãa nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“N 'yɛr na kʊrɔ yɩ ɩka, yɩ de a wɛr nyã bʊ̃tarsɩ na yɩ ŋman barmɩne ala wa baar, Nãaŋmɩn na de yɩn kpɛ̃n a yir kpo kpo 'lɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nɩrɛ 'lɔ jaa na tara yelmãɛ nɩ a bʊ̃bile, wʊn tara naa yelmãɛ nɩ a bʊ̃yɔɔ. Nɩrɛ 'lɔ jaa mɩ na ba tara yelmãɛ nɩ a bʊ̃bile ɛ, wʊ kʊ̃ mɩ tara yelmãɛ nɩ a bʊ̃yɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ala ɩ yaa tara yelmãɛ nɩ a wɛr bʊ̃tarsɩ ɛ, an lɛ na sɔɔ de a yelmãɛ bomo kʊ yɩ? ");
INSERT INTO biv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ala ɩ yaa tara yelmãɛ nɩ nɩrɛ kɔ̃ɔ bon ɛ, an lɛ na kʊ yɩ a yɩ bon? ");
INSERT INTO biv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Gbãgbaa kʊ̃ tʊ̃ɔ tʊ̃ kʊ nɩbɛrɛ ayi ɛ, wʊn nʊ̃n ãsʊɔ tɩ 'laar ãsʊɔ, bɩɩ wʊn wõnõ na ãsʊɔ toor tɩ ba wõnõ ãsʊɔ toor ɛ. Yɩ kʊ̃ tʊ̃ɔ tʊ̃ kʊ Nãaŋmɩn nɩ libie ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","A Faraseemɩne na nʊ̃ libie na wõ a lɛ a Yesu na 'yɛr, ka ba laara wʊ. ");
INSERT INTO biv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A Yesu 'yɛr kʊ ba, “Yɩ ma maal yɩ mãɛ nɩtorsɩ a nɩbɛ niem, tɩchɛ Nãaŋmɩn bɔ̃ɔn a yɩ tɩɛr. Bon 'lɔ nɩbɛ na 'yɔ̃ɔnɔ̃ ɩn Nãaŋmɩn bʊ̃chiiraa. ");
INSERT INTO biv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“A Mosesɩ Nɛɛ nɩ a Nãaŋmɩn 'yɛ'yɛrbɛ 'yɛr wa tãn a Jɔɔn sɔ̃ɔ. An yi a sɔ̃ɔ 'lɔ wʊ jaa, ba 'yɛr naa a Nãaŋmɩn nãalʊ̃ʊ 'yɛr sʊ̃n ka a ãsʊɔ jaa mʊɔrɔ wʊ sɔr, ɩka wʊ kpɛ. ");
INSERT INTO biv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","An ɩn kɔ̃mɔ̃kɔ̃mɔ̃ kʊ a saaju nɩ a tẽe ka a po tal, gar a Nɛɛ 'yɛr bir na yi lo. ");
INSERT INTO biv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nɩrɛ jaa na dii a wʊ pɔɔ bar tɩ kul pɔɔ yuo, wʊ maal dɛɛr, ka a daba 'lɔ mɩ na kul a pɔɔ a sɩrɛ na dii bar, mɩ maal dɛɛr. ");
INSERT INTO biv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Tara sʊɔ kɔ̃ɔ lɛ dɔ̃ɔ be be, na wʊ ma su kparsɩ nɩ fuu pɩɛl na wʊ dire bʊ̃nʊ̃n bɩbir jaa. ");
INSERT INTO biv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ka a sʊsʊɔrɔ kɔ̃ɔ yuor na di Lajarusɩ mɩ be be na ɩ natɩnara ma jãnɛ a tara sʊɔ dɔ̃dɔr nɛɛ. ");
INSERT INTO biv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Na wʊ ma bʊɔrɔ ɩka wʊ nyɛ a bʊ̃di pʊr pʊr ala a tara sʊɔ na dire ka a ŋmara loro, ka a baar gba ma wa lɛnɛ a wʊ natɩɛ. ");
INSERT INTO biv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","A sʊsʊɔrɔ nyãna wa kpi naa, ka a malakasɩ wa de wʊ chiine tɩ bin a Abraham sɛ̃. Ka a tara sʊɔ 'lɔ mɩ wa kpi ka ba ũu wʊ. ");
INSERT INTO biv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“A be a kpĩisɩ tẽe, ka a ɩ dɔɔyɛ jie lɛ, ka wʊ gbã nyɛ Abraham tɛɛr jaa ka a Lajarusɩ jãnɛ a wʊ lõboor. ");
INSERT INTO biv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Be lɛ wʊ bʊɔl, ‘N sãa Abraham, kaa n nɩbaal tɩ na fʊ tʊ̃ a Lajarusɩ ka wʊ 'me kʊ̃ɔ nɩ nubir wa 'maan ma jãlbir, bojũu a wõnõ ma naa ka a bũu pɔ.’ ");
INSERT INTO biv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tɩchɛ ka a Abraham 'yɛr, ‘N bie, tɩɛr kaa fʊn dɔ̃ɔ be a wɛr pɔ dire nʊ̃ɔ, tɩchɛ ka a Lajarusɩ mɩ dire dɔɔyɛ, pʊ̃pãanyã, wʊ mɩ dire naa a nʊ̃ɔ tɩchɛ ka fʊ mɩ dire a dɔɔyɛ. ");
INSERT INTO biv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","A nyã gba ba ɩ yele ɛ, a bɔɔ kpɛ̃ɛ nyã na be a sɩ chara pɔ, ka a bala na bʊɔrɔ ɩka ba yi a ka tɩ a yɩ sɛ̃ kʊ̃ tʊ̃ɔ ɛ, ãsʊɔ jaa kʊ̃ tʊ̃ɔ yi a be tɩ mɩ wa a sɩ sɛ̃ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ka wʊ lɔb nũu 'yɛr, ‘Yãayãaabɩlɛ lɛ n sʊɔrɔ, n sãa, tʊ̃ a Lajarusɩ ka wʊ kul a be a sãa yir, ");
INSERT INTO biv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","n tara na yɛɛr anũu wʊ tɩ kpãa ba ka ba taa ɩrɛ mɩ wa wa a dɔɔyɛ nyã pɔ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ka Abraham 'yɛr, ‘Mosesɩ nɩ a Nãaŋmɩn 'yɛ'yɛrbɛ a lɛ ban sɛb bin ben a ba sɛ̃, ba chɛlɛ a ala ban 'yɛrɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ka wʊ 'yɛr, ‘Kai n sãa Abraham, ala ɩ nɩrɛ lɛ ir a kũu pɔ tɩ 'yɛr kʊ ba ban lɩɛb a ba tɩɛr.’ ");
INSERT INTO biv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ka a Abraham 'yɛr kʊ wʊ, ‘Ala ɩ ba kʊ̃ chɛl a lɛ a Mosesɩ nɩ a Nãaŋmɩn 'yɛ'yɛrbɛ na 'yɛr lɩɛb a ba tɩɛr ɛ, nɩrɛ sɔɔ ir kũu pɔ tɩ 'yɛr an ɩn pɔrɔ.’ ” ");
INSERT INTO biv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu 'yɛr kʊ a wʊ poturbo, “Yelsɩ ala na vɛ̃ ka nɩrɛ ɩ bier ben be na wa, tɩchɛ nɩrɛ 'lɔ jie an tu wa ben pɔ'yɔ̃ɔ fʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A nɩnyɩnɛ 'lɔ̃nɔ̃, bala 'mɔɔ nɩɛr lũ yɔɔl a nyĩe pɔ daa lɔb a man kʊ̃ɔ pɔ, ala sa wʊn na vɛ̃ ka a bʊ̃bil banyãna ãsʊɔ ɩ bier. ");
INSERT INTO biv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yɩ guro yɩ mãɛ, ala ɩ fʊ yɛbɛ maal fʊn dɛɛr gɔ̃ wʊ, 'lɔ wa de a bɔrfʊ vɛ̃ kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ala ɩ a bɩbir bʊ̃'yen pɔ lɛ wʊ maal fʊ dɛɛr gbɛɛ ayopõi tɩ mɩ lɩɛb wa a gbɛɛ ayopõi wa de bɔrfʊ, vɛ̃ kʊ wʊ.” ");
INSERT INTO biv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ka a nɩtʊ̃nsɩ 'yɛr, “Sɩ Soro, pʊɔ sɩ sɔɔfʊ.” ");
INSERT INTO biv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ka a Soro 'yɛr kʊ ba, “Yɩn tara sɔɔfʊ jaa pʊʊr fɩka kɔ̃kɔ̃ɔ bir, yɩn tʊ̃ɔ 'yɛr kʊ a tɩkpɛ̃ɛ nyãna, ‘Vʊ̃ɔ tɩ ba man pɔ, ka wʊ tu a lɛ yɩn 'yɛr.’ ");
INSERT INTO biv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ala ɩ a yɩ ãsʊɔ tara na gbãgbaa ka wʊ kʊɔrɔ bɩɩ ŋmaara piir, 'lɔ wa yi a tʊ̃mɔ̃ jie wa, fʊn 'yɛr wʊ naa ɩka wʊ wa jãnɛ di ɔ? ");
INSERT INTO biv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A ba ɩ fʊn 'yɛr wʊ naa, ‘Maal a bʊ̃diir fɔɔ na fʊ chɔɔr a fʊ mãɛ wa ara gu ma, ka n di tɩ nyũ baar ka fʊ mɩ pãa di tɩ nyũ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wʊn puor naa a gbãgbaa nyãna wʊn 'yɔ̃ɔ ka wʊ maal bɩɩ? ");
INSERT INTO biv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","A yɩn mɩ lɛ lɛ, yɩn wa maal ala a jaa Nãaŋmɩn na 'yɔ̃ɔ yɩ, yɩn 'yɛr naa, ‘Saa sɛɛn ɛ, gbãgbaar lɛ sɩ ɩ na sɩ maal a lɛ na ɩ a sɩ tʊ̃mɔ̃.’ ” ");
INSERT INTO biv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu den a sɔr chiine a Jerusalɛm, wʊ kpɛ̃n a Samariya nɩ a Galilee chara pɔ. ");
INSERT INTO biv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Na wʊ chiine kpɛ a tẽbile ãsʊɔ pɔ, ka a kɔ̃kɔ̃n pie tuor wʊ a be. Ba ara na tɛɛr jaa ");
INSERT INTO biv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","tɩ gboolo bʊɔlɔ, “Nɩkpɛ̃ɛ Yesu, kaa sɩ nɩbaal.” ");
INSERT INTO biv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wʊn nyɛ ba a lɛ, na wʊ 'yɛr kʊ ba, “Yɩ chen tɩ wiil a yɩ mãɛ kʊ a Juu nɩbɛ bɔɔrlorbo.” Ban chen a lɛ, ka a ɩ ba sa naa. ");
INSERT INTO biv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","A ba ãsʊɔ na nyɛ ka a ɩ wʊ sa naa, wʊ lɩɛb wa de nɛkpɛ̃ɛ na wʊ pɛɛrɛ nɩ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wʊ lon kpa a Yesu gbɛɛ par tɩ puor wʊ, Samariya lɛ wʊ yi. ");
INSERT INTO biv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ka a Yesu sʊʊr, “A ba ɩ pie lɛ sa ɛ? Ka nyɩnɛ a pie forbir be? ");
INSERT INTO biv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ɩ̃sʊɔ jaa ba lɩɛb wa ɩka wʊ wa puor Nãaŋmɩn yãan ka a sãan nyã ba lɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tɩ pãa 'yɛr kʊ wʊ, “Ir kulo, a fʊ sɔɔfʊ sa fʊ naa.” ");
INSERT INTO biv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","A Faraseemɩne lɛ sʊʊr naa Yesu ɩka dabor lɛ a Nãaŋmɩn nãalʊ̃ʊ na wa, ka a Yesu 'yɛr, “Nãaŋmɩn nãalʊ̃ʊ kʊ̃ wa ka ba bɔ̃ɔn ɛ. ");
INSERT INTO biv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Bɩɩ ka nɩbɛ 'yɛr, yɩ nyɛ wʊ ka, bɩɩ yɩ nyɛ wʊ kasɛn, bojũu Nãaŋmɩn nãalʊ̃ʊ ben a yɩ pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tɩ pãa 'yɛr kʊ a poturbo, “Sɔ̃ɔ kɔ̃ɔ waara na a yɩn wa bʊɔrɔ ɩka yɩ nyɛ a maa Nɩsaal Bie nɩ nɩbir, tɩchɛ yɩ kʊ̃ nyɛ ma ɛ. ");
INSERT INTO biv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nɩbɛ na 'yɛr yɩ naa, ‘Kasɛn lɛ wʊ be,’ bɩɩ ‘Ka lɛ wʊ be.’ Yɩ taa ɩrɛ wa joro turo ba chiine be ɛ. ");
INSERT INTO biv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","A maa Nɩsaal Bie bɩbir na kaara naa fɩka a saa na ma nyɩɩr a saaju yi a lõboor nyã tɩ gbem a lõboor ãsʊɔ. ");
INSERT INTO biv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tɩchɛ ɩn den nie di dɔɔyɛ yele yɔɔ jaa pɔ, ka a dɩna nɩbɛ tɔr ma. ");
INSERT INTO biv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Lɛ an dɔ̃ɔ kaara a Nowa sɔ̃ɔ, lɛ mɩ lɛ an kaara a maa Nɩsaal Bie sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nɩbɛ dire naa na ba nyuro ka dɔɔr nɩ pɔbɔ kulo taa, tɩ tãn a bɩbir 'lɔ a Nowa na kpɛ a gbor kpɛ̃ɛ pɔ, ka a kʊ̃ɔ paal wa sɔ̃ɔ ba jaa bar. ");
INSERT INTO biv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lɛ mɩ lɛ a kaara a Lotɩ sɔ̃ɔ, nɩbɛ dire naa, na ba nyuro, na ba daara lɩɛb daara, na ba bʊrɔ na ba mɩɛrɛ nɩ yie. ");
INSERT INTO biv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tɩchɛ a bɩbir 'lɔ a Lotɩ nɩ wa yi a Sodom bũu nɩ kʊsɩlirsɩ yin saaju lo pɔɔ a nɩbɛ ka ba jaa kpi. ");
INSERT INTO biv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lɛ lɛ a maa Nɩsaal Bie bɩbir mɩ na kaara. ");
INSERT INTO biv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“A bɩbir 'lɔ̃nɔ̃, nɩrɛ na be a wʊ gar ju, ka a wʊ bonsɩ be a die pɔ, wʊ kʊ̃ suu tɩ de ɛ. Lɛ mɩ lɛ nɩrɛ na be puo pɔ kʊ̃ kul tɩ de bon ɛ. ");
INSERT INTO biv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yɩ tɩɛr a Lotɩ pɔɔ. ");
INSERT INTO biv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ɩ̃sʊɔ jaa na bʊɔrɔ ɩka wʊ faa a wa nyɛvʊr na bɔr wʊ naa, nɩrɛ 'lɔ na lɔb a wʊ nyɛvʊr bar, wʊn tara wʊ naa. ");
INSERT INTO biv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“N 'yɛrɛ na kʊrɔ yɩ ɩka a tãsɔɔ 'lɔ̃nɔ̃, nɩbɛ ayi na gãn gaa jie, ka a Nãaŋmɩn wa de bʊ̃'yen tɩ chɛ bʊ̃'yen bar. ");
INSERT INTO biv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ka a pɔbɔ ayi nɩɛnɛ jɔ̃, ka a Nãaŋmɩn de bʊ̃'yen tɩ chɛ bʊ̃'yen bar. ");
INSERT INTO biv_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dɔɔr ayi mɩ na ben puo pɔ, ka a Nãaŋmɩn wa de ãsʊɔ tɩ chɛ bʊ̃'yen bar.” ");
INSERT INTO biv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ka ba sʊʊr wʊ, “Sɩ Soro, nyɩnɛ?” Ka wʊ 'yɛr, “Jie bʊ̃kũu na be, be lɛ sɩdumosɩ ma loro.” ");
INSERT INTO biv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu pãa lɔb sʊkpa kʊ a wʊ poturbo na wʊ wiil ba a lɛ ban na sʊɔrɔ Nãaŋmɩn taa baala ɛ. ");
INSERT INTO biv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Wʊ 'yɛr naa, “A tẽe kɔ̃ɔ pɔ, 'yɛr tɔɔrɔ kɔ̃ɔ dɔ̃ɔ be be, waa joro Nãaŋmɩn dãbãɛ ɛ, waa mɩ kaara nɩrɛ nɩbaal ɛ. ");
INSERT INTO biv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ka a pɔɔ kʊɔr kɔ̃ɔ mɩ be be a tẽe pɔ, na wʊ ma waara a wʊ sɛ̃ wa 'yɛrɛ, ‘'Yɛr faa ma a n sãn sʊɔ sɛ̃.’ ");
INSERT INTO biv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Bojũu, gbɛɛ aŋmɩnɛ jaa lɛ wʊ ma tɔr, tɩ wa 'yɛr kʊ wʊ mãɛ, ‘N gba ba joro Nãaŋmɩn dãbãɛ ɛ, bɩɩ kaara nɩrɛ nɩbaal lɛ. ");
INSERT INTO biv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Tɩchɛ bojũu, a pɔɔ kʊɔr nyãna na yʊɔrɔ dɔ̃ɔnɔ̃ ma, ɩn tɔɔr a wʊ 'yɛr kʊ wʊ ka wʊ ta yʊɔrɔ bala ma ɛ.’ ” ");
INSERT INTO biv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ka a Soro 'yɛr, “Yɩ nyɛ lɛ a 'yɛr tɔɔr filefile nyã na 'yɛr. ");
INSERT INTO biv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nãaŋmɩn mɩ kʊ̃ 'yɛr faa a wʊ nɩ-irsɩ na kõnõ kʊrɔ wʊ mɔ̃tɔ̃ɔ nɩ tãsɔɔ jaa ɛ? Bɩɩ wʊn lɩɛrɛ ban bara? ");
INSERT INTO biv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","N 'yɛrɛ na kʊrɔ yɩ ɩka Nãaŋmɩn na tɔɔr a ba 'yɛr fɔɔ jaa kʊ ba. A maa Nɩsaal Bie wa lɩɛb wa a wɛr pɔ, ɩn nyɛn nɩbɛ ka ba tara sɔɔfʊ ɔ?” ");
INSERT INTO biv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu lɛ lɔb sʊkpa de man a nɩbɛ bamɩne na tɩɛr ɩka ba ɩn nɩtorsɩ tɩ kaara a ba taaba pɔrɔ. ");
INSERT INTO biv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nɩbɛ ayi lɛ dɔ̃ɔ do a Nãaŋmɩn puorfʊ yir ɩka ba tɩ sʊɔr Nãaŋmɩn. Ɩ̃sʊɔ ɩn Farasee nɩrɛ, ka a ãsʊɔ mɩ ɩ lõpodiere. ");
INSERT INTO biv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ka a Farasee nɩrɛ 'lɔ ir ara, tɩ sʊɔrɔ a Nãaŋmɩn 'yɛrɛ nɩ, ‘Nãaŋmɩn n puor fʊn yãan, nɩ ɩn ba kaara a nɩbɛ bamɩne kaar ɛ, nɩfarba, tʊ̃dɛtʊ̃nbɔ, sɛ̃sɛ̃nbɛ, bɩɩ a lõpodiere nyã kaar gba ɛ. ");
INSERT INTO biv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Maa 'lɔ, n ma gal kɔ̃ gbɛɛ ayi daa jaa pɔ, n bonsɩ pie jaa pɔ, n ma ir naa a bʊ̃'yen.’ ");
INSERT INTO biv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tɩchɛ ka a lõpodiere 'lɔ mɩ ara tɛɛr jaa na wʊ 'wor nuur, waa 'la dʊɔ kaa saaju ɛ, tɩ na wʊ 'yɛr, ‘Nãaŋmɩn kaa n nɩbaal, yelbe-ɩrɛ lɛ n ɩ.’ ");
INSERT INTO biv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","A lõpodiere nyã yele tor naa a Nãaŋmɩn sɛ̃, ka wʊ lɩɛb kul gar, a Farasee nɩrɛ 'lɔ. Bojũu nɩrɛ jaa na 'mɔɔrɔ wʊ mãɛ saaju, Nãaŋmɩn na siir wʊ naa, tɩ nɩrɛ nyã mɩ na siir a wʊ mãɛ, Nãaŋmɩn na 'mɔɔ wʊn saaju.” ");
INSERT INTO biv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nɩbɛ dɔ̃ɔ waara nɩ bibibil a Yesu sɛ̃ ɩka wʊ sɩɩr ba, ka a poturbo na nyɛ a lɛ na ba mĩi 'yɔ̃ɔ ba. ");
INSERT INTO biv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tɩchɛ ka a Yesu bʊɔl a bibiir ka ba wa a wʊ sɛ̃, ka wʊ 'yɛr, “Yɩ bar a bibiir sɔr ka ba wa a n sɛ̃, na yɩ ta ŋmaa ba sɔr ɛ, bojũu banyãna taaba lɛ so a Nãaŋmɩn nãalʊ̃ʊ. ");
INSERT INTO biv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, ãsʊɔ jaa ba wa de a Nãaŋmɩn nãalʊ̃ʊ nɩtãa a bibibile nyãna kaar ɛ, wʊ kʊ̃ tʊ̃ɔ kpɛ be ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","A nɩdiere kɔ̃ɔ sʊʊr a Yesu, “Wiwiilsʊ̃, bo lɛ ɩn ɩ naa nyɛ nyɛvʊr na ba tara baarfʊ ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ka a Yesu sʊʊr wʊ, “Bãa 'yɔ̃ɔ lɛ fʊ bʊɔl ma nɩsʊ̃? Nɩrɛ jaa ba ɩ nɩsʊ̃ ka Nãaŋmɩn tɛɛ ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Fʊ bɔ̃ɔ naa a Nãaŋmɩn Nɛɛ. Taa sɛ̃nɛ ɛ, taa kʊrɔ nɩrɛ ɛ, taa juro ɛ, taa ŋmaa jir kara 'yɔ̃ɔ nɩrɛ ɛ, na fʊ 'yɔ̃ɔnɔ̃ a fʊ sãa nɩ a fʊ ma.” ");
INSERT INTO biv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ka a daba 'yɛr, “A anyãna a jaa lɛ n turo a n bile sɔ̃ɔ wa tãn dɩna.” ");
INSERT INTO biv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu na wõ a nɩtɔ̃ ka wʊ 'yɛr kʊ wʊ, “A chɛ fʊn yelbʊ̃'yen, tɩ da a fʊ bonsɩ a jaa, de põ nɔ̃n dẽme ka a fʊ tara bomo be a saaju, tɩ na fʊ pãa wa turo ma.” ");
INSERT INTO biv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","A daba na wõ a nɩtɔ̃ wʊ pʊɔ sɔ̃ɔ naa, bojũu tara sʊɔ lɛ wʊ ɩ. ");
INSERT INTO biv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu kaa wʊn tɩ 'yɛr, “An ɩn kpɛ̃ɔ a tara sʊɔ na kpɛ Nãaŋmɩn nãalʊ̃ʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sɩrɛ jaa lɛ, an ɩn kɔ̃mɔ̃kɔ̃mɔ̃ nyɔɔma na kpɛ kparpĩi bɔɔ pɔ, gar tara sʊɔ na kpɛ Nãaŋmɩn nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ka a bala na wõ a nɩtɔ̃ sʊʊr a Yesu, “An lɛ na pãa nyɛ faafʊ?” ");
INSERT INTO biv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ka a Yesu 'yɛr, “Ala na ɩ tuo nɩrɛ sɛ̃, Nãaŋmɩn sɛ̃ yele jaa ba ɩ tuo ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","A Pita 'yɛr kʊ wʊ, “Sɩn bar bonsɩ a jaa, tɩ wa turo fʊ.” ");
INSERT INTO biv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ka a Yesu 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, nɩrɛ na bar a wʊ yir, bɩɩ pɔɔ, bɩɩ yɛɛr, bɩɩ a wʊ sãa naa ma, bɩɩ bibiir a Nãaŋmɩn nãalʊ̃ʊ jũu, ");
INSERT INTO biv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wʊn nyɛn dɔɔl taa a dɩna nɩ daar kɔ̃ɔ na wa lɔɔn nyɛvʊr na ba tara baarfʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu tɔɔn a Pie nɩ Ayi yin chɛ̃chɛ̃ɛ, tɩ 'yɛr kʊ ba, “Sɩ ben duoro a Jerusalɛm, ala a jaa a Nãaŋmɩn 'yɛ'yɛrbɛ na sɛb 'yɛr a maa Nɩsaal Bie 'yɛr, an tɩ ɩ naa. ");
INSERT INTO biv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ban tɩ nyɔɔ man kʊ a nɩbɛ bala na ba ɩ a Juu nɩbɛ ɛ, ka ba la ma, tʊrɔ ma, na ba chɩr nataar 'yɔ̃ɔ ma, na ba ge ma, tɩ kʊ ma. ");
INSERT INTO biv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ka a ber ata daar ka n ir ɩ vʊr go.” ");
INSERT INTO biv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","A poturbo ba bɔ̃ɔ a anyãna wʊn 'yɛr par bãlãa jaa ɛ. A liin ba jaa, baa bɔ̃ɔ a ala wʊn 'yɛrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu na wa gbʊrɔ a Jeriko, jɔ̃ɔ jɛ̃n be a sɔr kõkoor na wʊ sʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wʊn wa wõ a nɩyɔɔ na chiine tala, a wʊ sʊrɔ, ɩka bo lɛ ɩrɛ. ");
INSERT INTO biv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ka ba 'yɛr kʊ wʊ, “Yesu na yi Najaretɩ lɛ tala.” ");
INSERT INTO biv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A wʊ gboolo, “Yesu, David Bidaba, kaa a n nɩbaal.” ");
INSERT INTO biv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ka a bala na de a nie tãn wʊ 'yɛrɛ pɔɔ a nɛɛ, tɩchɛ ka wʊ chɛnɛ gboolo bʊɔlɔ, “Yesu, David Bidaba, kaa n nɩbaal.” ");
INSERT INTO biv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ka Yesu tɛɛ ara tɩ 'yɛr ɩka ba tara a daba waan. Lɛ a jɔ̃ɔ na wa gbʊr a Yesu ka wʊ sʊʊr wʊ, ");
INSERT INTO biv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Bo lɛ fʊ bʊɔrɔ ɩka n ɩ kʊ fʊ?” Ka a jɔ̃ɔ 'yɛr, “N Soro n bʊɔrɔ naa ɩka n nyɛrɛ.” ");
INSERT INTO biv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ka a Yesu 'yɛr, “Nyɛrɛ a fʊ sɔɔfʊ sa fʊ naa.” ");
INSERT INTO biv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ajienaa ka a ɩ wʊ nyɛrɛ naa, na wʊ dãna Nãaŋmɩn turo nɩ a Yesu. A nɩbɛ ba jaa na wa nyɛ a lɛ, ba mɩ dãna naa a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu kpɛ̃n a Jeriko tẽe pɔ tala. ");
INSERT INTO biv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ka a daba kɔ̃ɔ be be ban bʊɔlɔ Jakiyas, 'lɔ lɛ ɩ a lõpodierbe nɩkpɛ̃ɛ na wʊ ɩ tara sʊɔ. ");
INSERT INTO biv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wʊ bʊɔrɔ naa ɩka wʊ nyɛ Yesu nɩ nɩbir, tɩchɛ ka a nɩbɛ waa, a wʊ kʊ̃ tʊ̃ɔ nyɛ wʊ ɛ, bojũu nɩŋmaa lɛ wʊ ɩ. ");
INSERT INTO biv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Be lɛ wʊ de nie jo chen tɩ do kɔ̃kɔ̃ɔ tɩɛ ju ɩka wʊ nyɛ a Yesu an ɩ a be lɛ wʊ tu tala. ");
INSERT INTO biv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu na wa ta a tɩɛ pĩlem, wʊ dʊɔn bʊɔl wʊ, “Jakiyas wa suu fɔɔ, a fʊ yir lɛ ɩn gã dɩna.” ");
INSERT INTO biv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ka a Jakiyas suu fɔɔ jaa na wʊ tuor de a Yesu nɩ pʊpɛl. ");
INSERT INTO biv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","A nɩbɛ ba jaa nyɛn a lɛ na ba piel hũhũnõ 'yɛrɛ, “Wʊ ben na tɩ kpɛ a yelbe-ɩrɛ nyãna sãan.” ");
INSERT INTO biv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tɩchɛ ka a Jakiyas ir ara tɩ 'yɛr kʊ a Yesu, “Nyɛ n Soro, ɩn põ naa a n bʊ̃tarsɩ ŋmaa, naa kʊ a nɔ̃n dẽme, ala ɩ n mɩ fɔl nɩrɛ jaa bon, ɩn yab a lɛ dɔɔl gbɛɛ anaar.” ");
INSERT INTO biv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A Yesu 'yɛr kʊ wʊ, “Dɩna faafʊ wan a yir nyã pɔ, bojũu a daba nyã mɩ ɩn a Abraham bie. ");
INSERT INTO biv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bojũu a maa Nɩsaal Bie wa naa ɩka n wa bɔ na n faa a bala na bɔr.” ");
INSERT INTO biv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ban chɛlɛ a anyãna ka wʊ lɔb sʊkpa kʊ ba, bojũu ba gbʊrɔ naa a Jerusalɛm ka nɩbɛ tɩɛr ɩka a Nãaŋmɩn nãalʊ̃ʊ na tɔɔn daa yi ajienaa. ");
INSERT INTO biv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wʊ 'yɛr kʊ ba, “Nãbie ãsʊɔ lɛ ir na chen a tẽtɛɛr ãsʊɔ ka ba tɩ su wʊ nãa, ka wʊ lɩɛb wa. ");
INSERT INTO biv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na wʊ bʊɔl a wʊ gbãgbaar pie na wʊ de a sɛlbie pie na wʊ kʊ ba tɩ 'yɛr, ‘Yɩ de a libie anyãna tʊ̃nɔ̃ nɩ, wa tãn a sɔ̃ɔ 'lɔ ɩn na lɩɛb wa.’ ");
INSERT INTO biv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tɩchɛ ka a wʊ tẽe dẽme 'laar wʊ, ir nɩbɛ tʊ̃ wʊn chen baar ka ba tɩ 'yɛr ɩka, ‘Baa bʊɔrɔ a daba nyã ɩka wʊ wa ɩ a ba nãa ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Wʊ din a nãa na wʊ lɩɛb wa a wʊ tẽe, wʊ wa tʊ̃n bʊɔl a wʊ gbãgbaar bala wʊn kʊ a libie ka ba wa a wʊ sʊʊr kaa a lɛ ban tʊ̃n a libie. ");
INSERT INTO biv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A 'lɔ na de nie wa 'yɛr naa, ‘Nɩkpɛ̃ɛ, a fʊ libir dɔɔn pie dɔɔl.’ ");
INSERT INTO biv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ka a nɩkpɛ̃ɛ 'yɛr, ‘Fʊ maal vɩla fʊn ben tara yelmãɛ nɩ a bʊ̃bile nyã, ɩn vɛ̃ naa ka fʊ kaara tẽn pie.’ ");
INSERT INTO biv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","A ayi sʊɔ wa 'yɛr, ‘Nɩkpɛ̃ɛ, a fʊ libir mɩ dɔɔn anũu dɔɔl.’ ");
INSERT INTO biv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ka a wʊ nɩkpɛ̃ɛ 'yɛr, ‘Mɩ kaara tẽn anũu.’ ");
INSERT INTO biv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ka ata sʊɔ mɩ wa 'yɛr, ‘Nɩkpɛ̃ɛ nyɛ a fʊ libir ɩn lũ 'yɔ̃ɔ fɔbaa pɔ bin. ");
INSERT INTO biv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","N joro fʊn dãbãɛ, bojũu a fʊ yele kpɛ̃mɛ naa. Fʊ ma den a jie 'lɔ fʊn ba bin ɛ, na fʊ ŋma a jie 'lɔ fʊn ba bʊr ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ka a wʊ nɩkpɛ̃ɛ 'yɛr, ‘A fʊ nɛɛ 'yɛrbie lɛ ɩn de tɔɔr a fʊ 'yɛr, gbãgbadɛɛr lɛ fʊ ɩ. Fʊ̃ʊ mãɛ bɔ̃ɔn naa ɩka a n yele kpɛ̃mɛ naa, ma de a be ɩn ba bin ɛ, na n ma ŋmara a jie 'lɔ ɩn ba bʊr ɛ. ");
INSERT INTO biv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bo lɛ so ka faa de a n libir tɩ 'yɔ̃ɔ a be a libie binfʊ jie ɛ, ɩn ben ta wa, n kʊ̃ naa de ka bon dɔɔl ɛ?’ ");
INSERT INTO biv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tɩ pãa 'yɛr kʊ a bala na ara a be, ‘Yɩ faa a libir 'lɔ a wʊ sɛ̃, na yɩ kʊ a 'lɔ na tara a libie pie.’ ");
INSERT INTO biv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ka ba 'yɛr, ‘Nɩkpɛ̃ɛ, pie lɛ wʊ tara.’ ");
INSERT INTO biv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wʊ 'yɛr naa, ‘N 'yɛrɛ yɩ naa ɩka nɩrɛ 'lɔ na tara wʊn lɛ nyɛn dɔɔl, tɩchɛ nɩrɛ 'lɔ na ba tara ɛ, tɩ tara bãlãa ban den a bãlãa ala. ");
INSERT INTO biv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tɩchɛ a n dɔ̃dẽme bala na ba bʊɔrɔ ma ɩka n ɩ a ba nãa ɛ, yɩ nyɔɔr ba waan wa kʊ a ka a n niem.’ ” ");
INSERT INTO biv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu na 'yɛr a anyãna baar wʊ de ban nie ka ba duoro a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","A lɛ wʊn wa gbʊrɔ a Betefagɩ nɩ a Betanɩ, tɔ̃ɔ ben be ka ba bʊɔlɔ Olive Tɩɩr Tɔ̃ɔ, wʊ tʊ̃ naa a wʊ poturbo ayi tɩ 'yɛr kʊ ba. ");
INSERT INTO biv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Yɩ chen a tẽbile 'lɔ a yɩ niem, yɩn wa kpɩɛrɛ a tẽe pɔ yɩn nyɛn bʊ̃pɔlbile ban lũ, baa do wʊ jaa sɛrɛ ɛ, yɩ for wʊ waan. ");
INSERT INTO biv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ala ɩ nɩrɛ wa sʊʊr yɩ naa, ‘Ŋmɩnɛ a yɩ foro a bʊ̃pɔlbile?’ Yɩ 'yɛr wʊ, ‘A sɩ Soro lɛ bʊɔrɔ wʊ.’ ” ");
INSERT INTO biv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","A bala wʊn tʊ̃ chen tɩ nyɛ a lɛ nɛ wʊn 'yɛr ba. ");
INSERT INTO biv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ban wa foro a bʊ̃pɔlbile, a bʊ̃pɔlbile dẽme sʊʊr ba naa, “Ŋmɩnɛ a yɩ foro a bʊ̃pɔlbile?” ");
INSERT INTO biv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A ba 'yɛr, “A sɩ Soro lɛ bʊɔrɔ wʊ.” ");
INSERT INTO biv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ba waan naa a bʊ̃pɔlbile wa kʊ a Yesu, na ba 'yɩɛr a ba fɔɔr dɔɔl a bʊ̃pɔlbile ju, tɩ nyɔɔ a Yesu ka wʊ do jãnɛ. ");
INSERT INTO biv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A lɛ wʊn chiine, lɛ mɩ lɛ a nɩbɛ 'yɩɛrɛ a fɔɔr den a sɔr. ");
INSERT INTO biv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wʊn chen wa gbʊrɔ a jie a sɔr na suu a Olive Tɩɩr Tɔ̃ɔ ju, a nɩyɔɔ bala na turo wʊ piel chɩlɛ nɩ nɛkpɛ̃ɛ na ba pɛɛrɛ Nãaŋmɩn a nɛ'maa tʊ̃mɔ̃ ala a jaa ban nyɛ jũu. ");
INSERT INTO biv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Nãaŋmɩn wʊ sʊ̃ʊ a nãa 'lɔ wʊn tʊ̃! Nyã'maar ben a saaju, ka a tɩɩr be a saaju jaa saaju.” ");
INSERT INTO biv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ka a Faraseemɩne na be a nɩyɔɔ bala pɔ, 'yɛr kʊ a Yesu, “Wiwile tãn a fʊ poturbo a ba bar a gɔ̃n.” ");
INSERT INTO biv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A Yesu 'yɛr kʊ ba, “Ala ɩ ba bar a gɔ̃n, kʊsɩbɛ na pɔɔrɔ naa gɔ̃mɔ̃.” ");
INSERT INTO biv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu na wa tara a Jerusalɛm na wʊ nyɛ a tẽe wʊ kõn kʊ wʊ, ");
INSERT INTO biv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","tɩ 'yɛr, “Ala ɩ a fʊ̃ʊ, fʊ̃ʊ gba ta bɔ̃ɔ a bon 'lɔ a dɩna bɩbir nɩ taa waan nyã'maar, tɩchɛ a sɔɔl naa a fʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","A bɩbir na wa vɩɛ yɩ naa, ka a yɩ dɔ̃dẽme wa jilʊ̃ yɩ gʊɔr gʊɔr a jie wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ban nɛb yɩn ŋmɛr nɩ a yɩ bibiir nɩ a yɩ tẽe ba kʊ̃ wa bar kʊsɩr ka wʊ dɔɔl wʊ tɔ ju ɛ, bojũu yaa tɩɛr tɔ a sɔ̃ɔ a Nãaŋmɩn na waara a yɩ sɛ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Wʊ pãa tɩ kpɛ naa a Nãaŋmɩn puorfʊ yir bɛchaar pɔ na wʊ piel dire a bala na daara bara. ");
INSERT INTO biv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Na wʊ 'yɛr kʊ ba, “A sɛb a Nãaŋmɩn gãn pɔ ɩka, ‘A n yir na ɩ naa a puorfʊ jie,’ tɩchɛ ka a yɩn maal wʊ a ‘nãnyisɩ sɔɔlfʊ jie.’ ” ");
INSERT INTO biv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bɩbir jaa lɛ wʊ wile ba be a Nãaŋmɩn puorfʊ yir, tɩchɛ ka a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe nɩ a nɩbɛrɛ bʊɔrɔ a wʊ kʊfʊ. ");
INSERT INTO biv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tɩchɛ baa bɔ̃ɔ lɛ ban na ɩ ɛ, bojũu nɩbɛ ba jaa 'yɔ̃ɔn toor chɛlɛ a wʊ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","A bɩbir ãsʊɔ Yesu ben a Nãaŋmɩn puorfʊ yir bɛchaar pɔ, wile a nɩbɛ 'yɛrɛ a Nãaŋmɩn 'yɛr nʊ̃ɔ kʊrɔ ba. Ka a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe nɩ a nɩbɛrɛ wa a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Na ba sʊʊr wʊ, “'Yɛr kʊ sɩ a jie fʊn nyɛ a sɔr maala nɩ a anyãna, an kʊ fʊ a sɔr nyã?” ");
INSERT INTO biv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ka a Yesu mɩ 'yɛr, “N tara na sʊʊrfʊ na sʊʊr yɩ. ");
INSERT INTO biv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","A Jɔɔn na dɔ̃ɔ suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ an lɛ 'yɔ̃ɔ wʊ, Nãaŋmɩn lɛ 'yɔ̃ɔ bɩɩ nɩrɛ lɛ 'yɔ̃ɔ wʊ?” ");
INSERT INTO biv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A ba lɩɛb guor taa 'yɛrɛ, “Ala ɩ sɩ ben 'yɛr ɩka Nãaŋmɩn lɛ 'yɔ̃ɔ wʊ, wʊn lɩɛb sʊʊr sɩ, ŋmɩnɛ a saa sɔɔ de wʊ ɛ? ");
INSERT INTO biv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tɩchɛ sɩn mɩ 'yɛr ɩka nɩrɛ lɛ 'yɔ̃ɔ wʊ, a nɩbɛ ba jaa na lɔb sɩn nɩ kʊsɩbɛ, bojũu ba jaa sɔɔn de ɩka Nãaŋmɩn 'yɛ'yɛrɛ lɛ wʊ ɩ.” ");
INSERT INTO biv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Be lɛ a ba 'yɛr, “Saa bɔ̃ɔ a jie an yi ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A Yesu mɩ 'yɛr kʊ ba, “N mɩ kʊ̃ 'yɛr kʊ yɩ a jie ɩn nyɛ a sɔr maala nɩ a anyãna ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu chɛnɛ na 'yɛrɛ nɩ a nɩbɛ na wʊ lɔb a sʊkpa nyã kʊ ba, “Daba lɛ bʊr a tɩwɔ̃nsɩ de kʊ tʊ̃tʊ̃nbɔ a ba kaara, tɩ yɔ chen tɛɛr na wʊ tɩ kor be jaa. ");
INSERT INTO biv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ka a tɩɩr wɔ̃mɔ̃ mʊɔfʊ sɔ̃ɔ wa ta ka wʊ ir a tʊ̃tʊ̃nɔ̃ ãsʊɔ tʊ̃ a bala na kaara wʊ a puo ka ba pɔr a wɔ̃mɔ̃ amɩne tɩr. Tɩchɛ ka a nɩbɛ bala ŋme wʊ bar ka wʊ kul nũjaal. ");
INSERT INTO biv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ka wʊ lɛ tʊ̃ a tʊ̃tʊ̃nɔ̃ ãsʊɔ go, tɩchɛ a 'lɔ mɩ ba lɛ ŋme ŋme naa tɩ tu tu wʊ bar, ka wʊ mɩ lɩɛb kul a nũjaala. ");
INSERT INTO biv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ka wʊ lɛ maal tʊ̃ a ata sʊɔ ka ba ŋme a 'lɔ 'yɔ̃ɔ baal 'mɔɔ lɔb bar a yõo. ");
INSERT INTO biv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“A puo sʊɔ pãa 'yɛr, ‘Ŋmɩnɛ lɛ ɩn ɩ? Ɩn tʊ̃n a n bidanʊ̃naa amɩne sɛ̃ ban jo wʊn vĩ.’ ");
INSERT INTO biv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tɩchɛ a tʊ̃tʊ̃nbɔ na wa nyɛ a bidaba na waara a ba guor taa 'yɛr, ‘Nyã lɛ ɩ a bʊ̃dire, yɩ ɩ a sɩ kʊ wʊ bar tɩ de a bonsɩ.’ ");
INSERT INTO biv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Na ba nyɔɔ wʊ vu yin a puo kõkoor na ba tɩ kʊ wʊ. Bo lɛ a puo sʊɔ na wa ɩ a nɩbɛ banyãna? ");
INSERT INTO biv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wʊn wa kʊ naa a nɩbɛ banyãna bar, tɩ de a puo kʊ nɩyor.” Lɛ a nɩbɛ na wa wõ a 'yɛrbir nyã a ba 'yɛr, “A kʊ̃ tʊ̃ɔ ɩ a lɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ka a Yesu kaa ba a lɛ a tãɩɩ tɩ sʊʊr, “Ala ɩ a kʊ̃ ɩ a lɛ ɛ, a par nɩ bo an sɛb a Nãaŋmɩn gãn pɔ ɩka, ‘A kʊsɩr 'lɔ a mɩmɩɛrbɛ na tɔr lɛ ɩ a kʊsɩr ju?’ ");
INSERT INTO biv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ɩ̃sʊɔ jaa wa lo a kʊsɩr nyã ju na kar kara, tɩchɛ 'lɔ mɩ wa lo dib ãsʊɔ wʊn pʊrpʊr wʊ naa.” ");
INSERT INTO biv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ka a Mosesɩ nɛɛ wiwiilbe nɩ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ kaara sɔr 'lɔ ban na tu nyɔɔ wʊ fɔɔ, bojũu ba bɔ̃ɔn naa ɩka bala lɛ wʊ lɔb a sʊkpa gbɛb, tɩchɛ na ba joro a nɩbɛ dãbãɛ. ");
INSERT INTO biv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ba jʊrɔ naa Yesu, na ba ir nɩbɛ tʊ̃ ka ba tɩ maala fɩka nɩsʊ̃n tɩ jʊrɔ wʊ. Ba bʊɔrɔ naa ɩka ba wõ a wʊ nɛɛ 'yɛrbie de nyɔɔn wʊ 'yɔ̃ɔ kpɛ̃ɔ sʊɔ nũu pɔ, na ɩ a paal nɩkpɛ̃ɛ. ");
INSERT INTO biv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","A nɛbɛr nɩbɛ banyãna sʊʊr wʊ naa, “Wiwile sɩ bɔ̃ɔ naa ɩka fʊ ma 'yɛr naa na fʊ wiil a lɛ na tor, faa 'yɔ̃ɔnɔ̃ nɩbɛ gar taa ɛ, tɩchɛ na fʊ wile a nɩbɛ Nãaŋmɩn sɔr nɩ yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sɔr ben be a sɩn yab a lõpo kʊ a Nãkpɛ̃ɛ Siisa bɩɩ sɔr ba be be ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu nyɛn a ba yɛ̃ na wʊ 'yɛr kʊ ba, ");
INSERT INTO biv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Yɩ wiil ma a libikur. An ju ŋmaa nɩ a wʊ yuor lɛ be be?” ");
INSERT INTO biv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A ba 'yɛr, “A Nãkpɛ̃ɛ Siisa lɛ.” A wʊ 'yɛr kʊ ba. “Yɩ kʊ a Nãkpɛ̃ɛ Siisa a ala na ɩ a Nãkpɛ̃ɛ Siisa bon na yɩ mɩ de a ala na ɩ a Nãaŋmɩn bon mɩ kʊ a Nãaŋmɩn.” ");
INSERT INTO biv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ba bɛr wʊn a nɛɛ faa a anyãna wʊn 'yɛr a chãsara, ka nɛɛr 'maa ba nɩ a 'yɛr nyãna wʊn 'yɛr, a ba ɩ gbulo gbulo. ");
INSERT INTO biv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","A Saduseemɩne na 'yɛr ɩka a kũu pɔ irfʊ ba be be ɛ, bamɩne wan a Yesu sɛ̃ wa sʊʊr wʊ. ");
INSERT INTO biv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Wiwile, Mosesɩ sɛb 'yɔ̃ɔ a wʊ gãn pɔ kʊ sɩ ɩka, ala ɩ daba kul pɔɔ na wʊ wa kpi, tɩchɛ ka a pɔɔ ba dɔɔ bie ɛ, a yɛbɛ wʊ de a pɔɔ kʊɔr kul na wʊ dɔɔ bie kʊ a yɛbɛ. ");
INSERT INTO biv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yɛɛr ayopõi lɛ dɔ̃ɔ be be, ka a ba kpɛ̃ɛ kul pɔɔ na wʊ kpi, tɩ baa dɔɔ bie ɛ. ");
INSERT INTO biv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ka a wʊ turo ");
INSERT INTO biv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","nɩ a ata sʊɔ mɩ kul a pɔɔ, tɩ kpi, lɛ a yɛɛr ayopõi bala mɩ, kul a pɔɔ tɩ kpi baa dɔɔ bie ɛ. ");
INSERT INTO biv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A baaraa jaa ka a pɔɔ mɩ kpi. ");
INSERT INTO biv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","An be a lɛ, bala wa ir a kũu pɔ, buor sʊɔ pɔɔ lɛ wʊn ɩ, an ɩ ba jaa ayopõi kul wʊ naa?” ");
INSERT INTO biv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","A Yesu 'yɛr kʊ ba, “Nɩbɛ na be ka a wɛr pɔ, kulo nɩ taa. ");
INSERT INTO biv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tɩchɛ a bala na sɛɛn na ir a kũu pɔ a bɩbir 'lɔ, bala ba kulo taa ɛ. ");
INSERT INTO biv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bala kʊ̃ lɛ kpi go ɛ, nɩtãa lɛ a malakasɩ na ba kpire ɛ. Ba ɩ naa Nãaŋmɩn bibiir an ɩ bala lɛ ɩ a kũu pɔ irfʊ bibiir. ");
INSERT INTO biv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A kũu pɔ irfʊ, Mosesɩ mɩ wiil sɩ naa ɩka a ɩn yelmãɛ a lɛ wʊn sɛb a wʊ gãn pɔ, a Nãaŋmɩn na 'yɛrɛ nɩ wʊ a tɩbile na 'lɩrɛ a bũu, ka wʊ sɛb ɩka Nãaŋmɩn bʊɔl wʊ mãɛ, Abraham, Isaakɩ nɩ a Jekɔb Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Waa ɩ kũn Nãaŋmɩn ɛ, tɩchɛ wʊ ɩn a vʊɛ Nãaŋmɩn a wʊ 'yɔ̃ɔ lɛ ba jaa ɩ vʊɛ.” ");
INSERT INTO biv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ka a Mosesɩ nɛɛ wiwiilbe bamɩne 'yɛr, “Wiwile, fʊ 'yɛr vɩla.” ");
INSERT INTO biv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nɩrɛ jaa ba lɛ 'la sʊʊr wʊ go ɛ. ");
INSERT INTO biv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu pãa sʊʊr ba naa, “Ŋmɩnɛ lɛ a ɩ ka a nɩbɛ 'yɛrɛ ɩka a Kɩrɩsɩto ɩn a Nãa David Bidaba? ");
INSERT INTO biv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","A Nãa David mãɛ 'yɛr a wʊ yiel gãn pɔ, ‘A n Soro Nãaŋmɩn 'yɛr kʊ a n Soro nyã wʊn ir, “Jãnɛ a n nũsʊ̃ɔ jie, ");
INSERT INTO biv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ka n wa de a fʊ dɔ̃dẽme bin a fʊ gbɛɛ pĩlem.” ’ ");
INSERT INTO biv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A Nãa David bʊɔl wʊ naa a wʊ Soro, ŋmɩnɛ wʊn lɛ ɩrɛ wa ɩ a wʊ bie?” ");
INSERT INTO biv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","A nɩbɛ na chɛlɛ a lɛ wʊn 'yɛrɛ, ka Yesu 'yɛr kʊ a poturbo. ");
INSERT INTO biv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Yɩ gu yɩ mãɛ a Mosesɩ nɛɛ wiwiilbe 'yɔ̃ɔ. Ba nʊ̃ naa fuu vɛɛsɩ sufʊ, na ba nʊ̃ ɩka ba puoro ba a dar pɔ. A ba lɔ̃ɔfʊ yie a niem lɛ ba ma jãnɛ na ba jãnɛ a jibɛrɛ jie bala wa lɔ̃ɔ dire. ");
INSERT INTO biv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bala lɛ ma fɔlɔ a pɔɔ kɔɛ yie na ba ma sʊɔr Nãaŋmɩn kor bʊɔrɔ ɩka a nɩbɛ ba kaara ba. Ban nyɛn ge dɛɛr.” ");
INSERT INTO biv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu dʊɔn kaa nyɛ a tara dẽme na 'yɔ̃ɔnɔ̃ a ba libie be a Nãaŋmɩn puorfʊ yir. ");
INSERT INTO biv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wʊ nyɛn pɔɔ kʊɔr nɔ̃ɔ sʊɔ mɩ na 'yɔ̃ɔ kobsɩ ayi. ");
INSERT INTO biv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","A Yesu 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka a pɔɔ kʊɔr nɔ̃ɔ sʊɔ nyã 'yɔ̃ɔn gar ba jaa. ");
INSERT INTO biv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","A nɩbɛ banyãna ma ir 'yɔ̃ɔ tɩ chɛ a libie amɩne, tɩchɛ a pɔɔ nyã bon jaa wʊn tara lɛ wʊ de 'yɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","A Yesu poturbo bamɩne 'yɛrɛ na a lɛ ban maal a Nãaŋmɩn puorfʊ yir nɩ a kʊsɩr vɩɛlsɩ, nɩ a kʊfʊsɩ ban kʊ Nãaŋmɩn. Tɩchɛ ka Yesu 'yɛr kʊ ba, ");
INSERT INTO biv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“A kʊsɩbɛ anyãna yɩn nyɛ a kana, sɔ̃ɔ waara naa, ãsʊɔ jaa kʊ̃ dɔɔl a wʊ tɔ ju ɛ, a jaa na wɛl gã tẽe.” ");
INSERT INTO biv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ka ba sʊʊr wʊ, “Wiwile, dabor lɛ an ɩ? Bo lɛ na ɩ a jãnɛ ala wa bʊɔrɔ a ɩfʊ?” ");
INSERT INTO biv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A wʊ 'yɛr kʊ ba, “Yɩ gu yɩ mãɛ ka nɩrɛ taa bɛl yɩ ɛ. Bojũu nɩyɔɔ lɛ na de a n yuor waan wa 'yɛrɛ ɩka, ‘Maa lɛ ba ɩ,’ ka a ɩ, ‘Sɔ̃ɔ gbʊr naa.’ Yɩ taa turo ba ɛ. ");
INSERT INTO biv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yɩn wa wõ jɛɛr nɩ faa taa, yɩ ta vɛ̃ ka dãbãɛ kpɛ yɩ ɛ. A anyãna lɛ na de nie wa, tɩchɛ a ba ɩ a baarfʊ lɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tɩ pãa 'yɛr kʊ ba, “Nɩbɛ na ir tɩ jɛɛr nɩ a tẽe ãsʊɔ nɩbɛ, ka a nãmɩne mɩ ir jɛɛrɛ taa. ");
INSERT INTO biv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A tẽe na mɩr naa a jie wʊ jaa ka a kɔ̃ lo ka a baal dɛbɛ de jiir a jaa ka a dãbãɛ nɩ jãnɛ yi saaju. ");
INSERT INTO biv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Sɛrɛ tɩchɛ ka anyãna na wa ɩ ban ge yɩ naa, na ba nyɔɔr yɩ chiin a lɔ̃ɔfʊ jiir na ba fɩr yɩ chiin tɩ pɔɔ. Ban fɩr yɩn chiin a nãmɩne yie nɩ a paal nɩbɛrɛ jie a n yuor jũu. ");
INSERT INTO biv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","A anyãna na kʊ yɩn sɔr ka yɩ di a n dãasɩɛ kʊ ba. ");
INSERT INTO biv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tɩchɛ yɩ ta ɩ ka a ɩ yɩ tɩɛrɛ a lɛ yɩn na tɩ 'yɛr faa yɩ mãɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bojũu maa lɛ na kʊ yɩ a 'yɛr nɩ a yɛ̃ ka a yɩ sãma dẽme kʊ̃ tʊ̃ɔ nyɛ jie chɩɩr yɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A yɩ sãamɩne nɩ a yɩ mamɩne, yɛɛr nɩ a yɩ bal nɩbɛ nɩ a yɩ barmɩne na gar 'yɔ̃ɔ yɩ ka ba kʊ a yɩ bamɩne. ");
INSERT INTO biv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nɩbɛ ba jaa na 'laar yɩ naa a maa jũu. ");
INSERT INTO biv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tɩchɛ a yɩ jukɔɔlbir kʊ̃ wa wɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yɩn chɛnɛ sɔɔ Nãaŋmɩn nɩ yelmãɛ yɩn faan yɩ mãɛ. ");
INSERT INTO biv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Yɩn wa nyɛ a sojasɩ a ba wa ŋmaa jilʊ̃ a Jerusalɛm, yɩ bɔ̃ɔ ɩka a wʊ wɛlfʊ gbʊr jaa yɛ̃yɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ka a bala na pãa be a Judiya ba joro duoro a tɔ̃n jur. A bala mɩ na be a a Jerusalɛm tẽe pɔ, yɩ joro yire, ka a bala mɩ na be a tẽe kõkoor ba ta lɛ kpɛ a tẽe pɔ go ɛ. ");
INSERT INTO biv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","A sɔ̃ɔ nyãna lɛ a Nãaŋmɩn na kpãa a Isɩral nɩbɛ, a kpãafʊ nyã na ɩn a lɛ ban sɛb a Nãaŋmɩn gãn pɔ. ");
INSERT INTO biv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","A bɩbir nyã na ɩn wõm kʊ a pɔɔ pʊʊr nɩ a bipɩlɛ dẽme, dɔɔyɛ kpɛ̃ɛ na ben a wɛr pɔ, bojũu Nãaŋmɩn suur lɛ dire a wʊ nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sɔkpɛ̃ɛ lɛ ban kʊn ba, tɩ nyɔɔr ba nɩpɔɔrsɩ kaar kʊ a paalsɩ. Ka a bala na ba ɩ a Juu nɩbɛ na nɛɛrɛ naa a Jerusalɛm wa tɩ tãn a sɔ̃ɔ 'lɔ a Nãaŋmɩn na 'yɔ̃ɔ kʊ ba. ");
INSERT INTO biv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Yɩn nyɛn jãnsɩ a mɔ̃tɔ̃ɔ pɔ, ŋmɛra pɔ nɩ a ŋmɛrbie pɔ. Tuo na pɔɔn nɩbʊrɔ jaa na be ka wɛr ju, ka dãbãɛ kpɛ a nɩbɛ, a man kpɛ̃ɛ kʊ̃ɔ na kara na a ɔɔrɔ. ");
INSERT INTO biv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Dãbãɛ nyã na vɛ̃ naa ka a nɩbɛ pɛl, bojũu ba bɔ̃ɔn naa a dɔɔyɛ nyã na waara a wɛr pɔ, a saaju bomo a jaa na dɔ̃ɔnɔ̃ naa. ");
INSERT INTO biv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A daar 'lɔ̃nɔ̃ lɛ ban nyɛ a maa Nɩsaal Bie na yi a julõjuur pɔ, waara nɩ a kpɛ̃ɔ nɩ a tɩɩr kpɛ̃ɛ. ");
INSERT INTO biv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","A yele anyãna wa ɩrɛ, yɩ ir ara tɩ jɛɛr a yɩ jur, bojũu a yɩ faafʊ gbʊrɔ naa.” ");
INSERT INTO biv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sʊkpa nyã lɛ a Yesu lɔb kʊ ba, na wa 'yɛr, “Yɩ kaa a pɔlpɔl tɩɛ nɩ a tɩɩr a jaa. ");
INSERT INTO biv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yɩn wa nyɛ ka a tʊɔrɔ a vaar yɩ ma bɔ̃ɔn naa ɩka tʊl tara naa. ");
INSERT INTO biv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","A lɛ mɩ lɛ, yɩn wa nyɛ a yelsɩ anyãna ka a ɩrɛ, yɩ bɔ̃ɔn ɩka a Nãaŋmɩn nãalʊ̃ʊ gbʊr naa. ");
INSERT INTO biv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Yelmãɛ jaa lɛ n 'yɛrɛ kʊrɔ yɩ ɩka nɩsaal jaa kʊ̃ kpi baar ɛ, tɩchɛ ka a yelsɩ anyãna ɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A saaju nɩ a tẽe, a jaa na wa baaraa, tɩchɛ a maa 'yɛrbie kʊ̃ wa baar ɛ. ");
INSERT INTO biv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Yɩ guro yɩ mãɛ, ka a yɩ nyãa taa pɔɔ ɛ, nɩ dãa kuolfʊ nɩ a ãgãn nyã bʊ̃bʊɔrsɩ ka a bɩbir nyã taa wa dũu yɩ fɩka chɛbaa na tɛb ɛ. ");
INSERT INTO biv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bojũu a lɛ na ɩ ɩn na wa, pɔɔn nɩrɛ jaa na be ka a wɛr nyã pɔ. ");
INSERT INTO biv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yɩ kaara na yɩ sʊɔrɔ Nãaŋmɩn, na yɩ tʊ̃ɔ jo yi a ala a jaa na wa wa ɩ pɔ, na yɩn tʊ̃ɔ ara a maa Nɩsaal Bie niem.” ");
INSERT INTO biv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","A Yesu ma wile naa a nɩbɛ be a Nãaŋmɩn puorfʊ yir, tɩchɛ ka a tãsɔɔ ka wʊ ma do a tɔ̃ɔ 'lɔ ban bʊɔlɔ a Olive Tɩɩr Tɔ̃ɔ tɩ gã a be. ");
INSERT INTO biv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ka a nɩbɛ ma chɛnɛ ŋmaa ir a bibio wa be a Nãaŋmɩn puorfʊ yir ɩka ba wa chɛl a wʊ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","A Paanʊ̃kõo Lɔ̃ɔfʊ ban bʊɔlɔ a Gõl Bar Difʊ gbʊrɔ naa. ");
INSERT INTO biv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ka a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe bʊɔrɔ sɔr 'lɔ ban na tu nyɔɔ a Yesu jaa jom, bojũu ba joro naa a nɩbɛ dãbãɛ. ");
INSERT INTO biv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ka a Satan pãa kpɛ a Judas na yi a Isɩkariyot na ɩ a nɩtʊ̃nsɩ pie nɩ ayi ãsʊɔ. ");
INSERT INTO biv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wʊ ir chen a bɔɔrlo nɩbɛrɛ nɩ a Nãaŋmɩn puorfʊ yir gugurbo sɛ̃, ka ba tɩ man taa lɛ wʊn na ɩ, ka ba nyɔɔ a Yesu. ");
INSERT INTO biv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ba pʊɔ pɛl naa ka ba sɔɔ ɩka ban kʊ wʊ naa libie. ");
INSERT INTO biv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas sɔɔ naa na wʊ kaara bʊɔrɔ sɔr 'lɔ wʊn na nyɔɔ a Yesu kʊ ba ka a nɩyɔɔ ba be be ɛ. ");
INSERT INTO biv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","A Paanʊ̃kõo bɩbir vɩɛ naa, ka ban kʊ a Gõl Bar Difʊ pɛr. ");
INSERT INTO biv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu tʊ̃n a Pita nɩ Jɔɔn na wʊ 'yɛr, “Yɩ chen tɩ chɔɔr jie ka sɩ chen tɩ di a Gõl Bar Difʊ.” ");
INSERT INTO biv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ka ba sʊʊr wʊ, “Nyɩnɛ lɛ fʊ bʊɔrɔ ɩka sɩ chen tɩ chɔɔr?” ");
INSERT INTO biv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A wʊ 'yɛr, “Yɩn wa tɩ kpɛ a tẽe pɔ, yɩn tuor daba na tuo kʊ̃ɔ nɩ yuor yɩ turo wʊ tɩ kpɛ̃n a yir 'lɔ pɔ wʊn kpɛ. ");
INSERT INTO biv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Na yɩ tɩ 'yɛr a yir sʊɔ, a wiwile lɛ 'yɛr ɩka sɩ wa sʊʊr fʊ kaa, ka nyɩnɛ lɛ a sãanba die be, ka 'lɔ naa wʊ poturbo na wa di a Gõl Bar Difʊ? ");
INSERT INTO biv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wʊn wiil yɩn bɔɔpɩɛ dikpɛ̃ɛ ban chɔɔr yɩ maal a bʊ̃diir a be.” ");
INSERT INTO biv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ba chen tɩ nyɛ a lɛ nɛ a Yesu na 'yɛr na ba chɔɔr a bʊ̃diir a be. ");
INSERT INTO biv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A sɔ̃ɔ na wa ta Yesu nɩ a wʊ nɩtʊ̃nsɩ wa jãnɛ naa a bʊ̃diir par. ");
INSERT INTO biv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Be lɛ wʊ 'yɛr kʊ ba, “N bʊɔrɔ na yɔɔ jaa ɩka n 'mataa din yɩ a Gõl Bar nyã bʊ̃diir tɩ na n di a dɔɔyɛ. ");
INSERT INTO biv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bojũu n 'yɛrɛ na kʊrɔ yɩ ɩka n kʊ̃ lɛ di yaa go ɛ, wa tɩ tãn yele jaa na maal baar a Nãaŋmɩn nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wʊn wa de a dãa naa ŋmele wʊ puor Nãaŋmɩn yãan tɩ 'yɛr kʊ a wʊ nɩtʊ̃nsɩ, “Yɩ de a anyã nyũ lʊɔr taa. ");
INSERT INTO biv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bojũu n 'yɛrɛ na kʊrɔ yɩ ɩka n kʊ̃ lɛ nyũ a dãa anyãna go ɛ, tɩ tãn a Nãaŋmɩn nãalʊ̃ʊ waa daar.” ");
INSERT INTO biv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wʊ lɛ den a paanʊ̃ɔ puor Nãaŋmɩn yãan tɩ na wʊ ŋma de kʊ ba tɩ 'yɛr, “A maa ãgãn lɛ a nyãna ɩn diere kʊrɔ yɩ, yɩ maala a nɩtɔ̃ tɩɛrɛ nɩ ma.” ");
INSERT INTO biv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Lɛ nɩ wʊ ju lɛ ban wa di baar wʊ den a ŋmele tɩ 'yɛr, “A ŋmele nyã ɩn a nɛtɩr paalaa na ɩ a maa jãɩ na kpaar a yɩ jũu. ");
INSERT INTO biv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Tɩchɛ a 'lɔ na garʊ 'yɔ̃ɔ ma lɛ n 'mataa dire nɩ a bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A maa Nɩsaal Bie na chen naa nɩtãa lɛ a Nãaŋmɩn na bin, tɩchɛ nɛbier ben a nɩrɛ 'lɔ na garʊ 'yɔ̃ɔ ma.” ");
INSERT INTO biv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","A ba piel sʊrɔ taa ɩka a ba buor sʊɔ lɛ na pãa tʊ̃ a nɩtɔ̃. ");
INSERT INTO biv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ka nɛchɩrɛ mɩ ir a nɩtʊ̃nsɩ pɔ, a ba chɩrɛ taa bʊɔrɔ ɩka ba bɔ̃ɔ buor sʊɔ lɛ na ɩ a ba jaa nɩkpɛ̃ɛ. ");
INSERT INTO biv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A Yesu 'yɛr kʊ ba, “A bala na ba ɩ a Juu nɩbɛ nãmɩne ɛ, ma fɩrɛ naa a nɩbɛ, ka a bala mɩ na wile a ba kpãɛn bʊɔlɔ ba mãɛ, nɩsʊ̃nbɔ. ");
INSERT INTO biv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tɩchɛ yɩn 'lɔ a ba ɩ lɛ lɛ ɛ, a 'lɔ na ɩ a yɩ kpɛ̃ɛ, 'lɔ lɛ na ɩ a yɩ jaa bibile, a 'lɔ na kaara yɩ, 'lɔ lɛ na tʊ̃nɔ̃ kʊrɔ yɩ. ");
INSERT INTO biv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nɩbuor sʊɔ lɛ ɩ kpɛ̃ɛ, a 'lɔ na jãnɛ a bʊ̃diir par, bɩɩ a 'lɔ na põnõ? A ba ɩ a 'lɔ na jãnɛ a bʊ̃diir par ɛ? Tɩchɛ a maa na ɩ a yɩ nɩkpɛ̃ɛ ben a yɩ sɛ̃, ɩ a yɩ bʊ̃ põnõ. ");
INSERT INTO biv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yɩn lɛ ɩ a nɩbɛ bala na chɛnɛ ara gu ma a n wõm pɔ. ");
INSERT INTO biv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","N kʊ yɩn a nãalʊ̃ʊ nɩtãa lɛ a n Sãa na kʊ ma a nãalʊ̃ʊ. ");
INSERT INTO biv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ka maa nɩ yɩn lɔ̃ɔ di tɩ nyũ be a n nãalʊ̃ʊ pɔ, na yɩ jãnɛ a nãa dakɔɔ ju tɔɔrɔ a Isɩral balsɩ pie nɩ ayi 'yɛr. ");
INSERT INTO biv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon, a Satan sʊɔr sɔr Nãaŋmɩn sɛ̃ ɩka wʊ yɩɛl yɩ chi kaar. ");
INSERT INTO biv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tɩchɛ a fʊ̃ʊ Pita n sʊɔr Nãaŋmɩn kʊ fʊ ɩka, a fʊ sɔɔfʊ ta bʊ̃bʊr ɛ, a fʊ̃ʊ wa lɩɛb puor, fʊ 'yɔ̃ɔ a fʊ taaba ãkpãɛn.” ");
INSERT INTO biv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tɩchɛ ka a Simon 'yɛr, “N Soro, n chɔɔr naa ɩka maa nɩ fʊ̃ʊ lɛ na lɔ̃ɔ kpɛ a pɔɔfʊ die pɔ, na sɩ 'mataa kpi.” ");
INSERT INTO biv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","A Yesu 'yɛr, “A fʊ̃ʊ Pita, sɛrɛ ka a nɔraa kõ a dɩna fʊn chɩɩr gbɛɛ ata ɩka faa bɔ̃ɔ ma ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Be lɛ a Yesu pãa sʊʊr ba, “Ɩn dɔ̃ɔ tʊ̃ yɩ a nũjaala, yaa tara libie ɛ, bɩɩ wʊɔ nɩ nafɔɔr ɛ, yɩ dɔ̃ɔ bɔ bon faa bɩɩ?” A ba 'yɛr ɩka baa bɔ bon jaa faa ɛ. ");
INSERT INTO biv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A wʊ 'yɛr kʊ ba, “Tɩchɛ pʊ̃pãanyã, fʊ̃ʊ nyã na tara libie de, fʊ̃ʊ nyã mɩ na tara wʊɔ de, fʊ̃ʊ nyã na ba wa tara sɔkpɛ̃ɛ ɛ, de a fʊ fuu da na fʊ dãn a sɔkpɛ̃ɛ. ");
INSERT INTO biv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","A sɛb a Nãaŋmɩn gãn pɔ ɩka, ‘Ba sɔr wʊn 'yɔ̃ɔ a tʊ̃dɛbɛ dẽme pɔ.’ N 'yɛrɛ na kʊrɔ yɩ ɩka maa lɛ ban maal a lɛ nɛ, ɔ̃ɔ, a lɛ ban sɛb a n yele a gbʊrɔ na tafʊ.” ");
INSERT INTO biv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ka a poturbo 'yɛr, “Sɩ Soro nyɛ sɔbɛrɛ ayi.” A wʊ 'yɛr, “A sɛɛ naa.” ");
INSERT INTO biv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu yin duoro a Olive Tɩɩr Tɔ̃ɔ ju, nɩtãa lɛ wʊn ma ɩrɛ ka a wʊ poturbo turo wʊ. ");
INSERT INTO biv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wʊn wa ta a jie wʊ 'yɛr kʊ ba, “Yɩ sʊɔrɔ Nãaŋmɩn na yɩ taa lo a bɛɛr kaa pɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wʊ tɔɔn jãa ba bãlãa fɩka kʊsɩr fʊn na lɔb ka wʊ ta, na wʊ gbʊr dumo sʊɔrɔ Nãaŋmɩn 'yɛrɛ, ");
INSERT INTO biv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“N Sãa, ala ɩ fʊ bʊɔrɔ naa, de a dɔɔyɛ ŋmele nyãna bar ma, a ɩ a fʊ bɔfʊ a ta ɩ a maa bɔfʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Be lɛ a malaka yi be a saaju wa a wʊ sɛ̃ wa 'yɔ̃ɔ wʊ ãkpɛ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","A nɩbaal na kpɛ wʊ a lɛ, ka wʊ sʊɔrɔ Nãaŋmɩn kpɛ̃ɔ jaa ka a nyĩe hãna wʊ loro tẽe fɩka jãɩ. ");
INSERT INTO biv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wʊn wa ir a Nãaŋmɩn sʊɔrfʊ jie lɩɛb chen tɩ nyɛ ka a wʊ poturbo gã gur nɩ pʊsɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ka wʊ sʊʊr ba, “Ŋmɩnɛ a yɩ gã guro? Yɩ ir sʊɔrɔ Nãaŋmɩn na yɩ taa lo a bɛɛr kaa pɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wʊn chɛnɛ 'yɛrɛ a lɛ ka a ɩ a nɩyɔɔ daan sãa, ka a 'lɔ ban bʊɔlɔ a Judas a Pie Nɩ Ayi ãsʊɔ lɛ de ba a nie. Wʊ tɔɔn ta a Yesu puor wʊ. ");
INSERT INTO biv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tɩchɛ ka a Yesu sʊʊr wʊ, “Judas, fʊ ben de puorfʊ garʊ 'yɔ̃ɔ a maa Nɩsaal Bie?” ");
INSERT INTO biv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesu poturbo na nyɛ a lɛ na ɩrɛ ka ba sʊʊr wʊ, “Sɩ Soro, sɩ chɩɛrɛ nɩ a sɔbɛrɛ bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ka a ba ãsʊɔ chɛ a Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ gbãgbaa nũsʊ̃ɔ toor ŋmaa. ");
INSERT INTO biv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tɩchɛ ka a Yesu 'yɛr, “Yɩ ta lɛ maal a lɛ ɛ.” Tɩ na wʊ sɩɩr a daba toor ka wʊ choo. ");
INSERT INTO biv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","A Yesu pãa sʊʊr a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Nãaŋmɩn puorfʊ yir gugurbo nɩbɛrɛ nɩ a Juu nɩbɛ nɩdierbe, “A mɔ̃ nɩbier lɛ n ɩ ka yɩ waan sɔbɛrɛ nɩ dakʊrsɩ a n nyɔɔfʊ jie bɩɩ? ");
INSERT INTO biv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Maa nɩ yɩn lɛ be be bɩbir jaa be a Nãaŋmɩn puorfʊ yir bɛchaar pɔ, yaa nyɔɔ ma ɛ, tɩchɛ a yɩ bɩbir vɩɛ naa ka a libe mɩ di nãa.” ");
INSERT INTO biv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ba nyɔɔ naa Yesu, na ba chiine a bɔɔrlo nãa yir, ka a Pita mɩ be a puor na wʊ turo. ");
INSERT INTO biv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ban tɩ ta ba gbɔɔn bũu be a bɛchaar sãlsɔɔ 'mataa jãnɛ ka a Pita mɩ tɩ pʊɔ ba ka ba 'mataa jãnɛ. ");
INSERT INTO biv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ka a gbãgbapɔɔbile nyɛ wʊ a bũu na chaar na wʊ kaara wʊ jaa tãɩɩ tɩ wa 'yɛr, “A daba nyã mɩ ɩn a wʊ poturo ãsʊɔ.” ");
INSERT INTO biv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tɩchɛ ka a Pita chiir 'yɛr, “Pɔɔ, n ba bɔ̃ɔ wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A ba kor ɛ ka a nɩrɛ ãsʊɔ nyɛ wʊ na wʊ 'yɛr, “Fʊ mɩ ɩn a ba ãsʊɔ.” Ka a Pita 'yɛr, “Daba, n ba ɩ a ba ãsʊɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A ba lɛ kor ɛ, ka a nɩrɛ ãsʊɔ mɩ 'yɛr, “A ba ɩ baal ɛ, a daba nyã ɩn a ba ãsʊɔ bojũu Galilee lɛ wʊ yi.” ");
INSERT INTO biv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ka a Pita 'yɛr, “Daba, n ba bɔ̃ɔ a ala fʊn 'yɛrɛ ɛ.” Ka a nɔraa mɩ tɔ̃ɔ kõ a lɛ nɛ. ");
INSERT INTO biv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ka a Yesu lɩɛb na wʊ kaa a Pita, a wʊ tɔ̃ɔ tɩɛr tɔ a lɛ a Yesu na 'yɛr kʊ wʊ ɩka, “Sɛrɛ tɩchɛ ka a nɔraa kõ a dɩna fʊn chiir man gbɛɛ ata.” ");
INSERT INTO biv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ka a Pita ir yi a yõo na wʊ tɩ kõ nɩbaal kõn. ");
INSERT INTO biv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","A dɔɔr bala na nyɔɔ a Yesu, piel na ba ɩrɛ wʊ laara tɩ ŋmiere wʊ. ");
INSERT INTO biv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ba pɔɔ wʊ naa nɩbie tɩ sʊʊr, “Bɔ̃ɔ na fʊ 'yɛr kʊ sɩ a nɩnyɩnɛ na ŋme fʊ?” ");
INSERT INTO biv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ba lɛ den 'yɛrbidɛbɛ yɔɔ tʊ tʊn wʊ. ");
INSERT INTO biv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","A wɛr na wa chaar, a Juu nɩbɛ nɩdierbe nɩ a ba bɔɔrlo nɩbɛrɛ, nɩ a Mosesɩ Nɛɛ wiwiilbe lɔ̃ɔn taa, ka ba tara a Yesu waan a be. ");
INSERT INTO biv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","A ba sʊʊr wʊ, “Ala ɩ fʊ̃ʊ lɛ a Nɩ-iraa 'lɔ, 'yɛr kʊ sɩ.” Ka a Yesu 'yɛr, “Maa 'yɛr, yɩ kʊ̃ sɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ala ɩ n sʊʊr yɩn 'yɛr yɩ kʊ̃ haa ma nɛɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tɩchɛ an yi a dɩna chiine, a maa Nɩsaal Bie na jãnɛ naa Nãaŋmɩn kpɛ̃ɔ sɔɔ nũsʊ̃ɔ jie.” ");
INSERT INTO biv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ka ba sʊʊr wʊ, “Fʊ̃ʊ lɛ ɩ a Nãaŋmɩn Bie ɔ?” Kaa a Yesu 'yɛr, “Yɩn lɛ 'yɛr ɩka lɛ n ɩ.” ");
INSERT INTO biv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ka ba pãa 'yɛrɛ kʊrɔ taa, “Bãa 'yɔ̃ɔ lɛ sɩ lɛ bʊɔrɔ dãasɩɛ go? Sɩ wõn yi a wʊ mãɛ nɛɛ pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Be lɛ a nɩyɔɔ bala pãa tara a Yesu chiin a be a paal nɩkpɛ̃ɛ Pilate sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na ba tɩ piel 'yɛrɛ a 'yɛrsɩ anyãna dɔɔlɔ wʊ, “Sɩ nyɛn a daba nyãna ka wʊ 'yɔ̃ɔnɔ̃ a nɩbɛ 'yɛr, a ba ta yab a lõpo kʊ a Nãa Siisa ɛ, na wʊ lɛ 'yɛr ɩka 'lɔ lɛ ɩ a Nɩ-iraa na ɩ a nãa.” ");
INSERT INTO biv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ka a Pilate sʊʊr a Yesu, “Fʊ̃ʊ lɛ ɩ a Juu nɩbɛ nãa ɔ?” Ka a Yesu 'yɛr, “Ɔ̃ɔ, fʊ̃ʊ baa 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ka a Pilate pãa 'yɛr kʊ a bɔɔrlo nɩbɛrɛ nɩ a nɩbɛ, “N ba nyɛ chɛfʊ jaa a daba nyã jie ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tɩchɛ ka a nɩbɛ tɔr tɩ chɛnɛ 'yɛrɛ, “Wiilfʊ nyãna lɛ wʊ tara dɔ̃ɔnɔ̃ nɩ a nɩbɛ be a Judiya. Galilee lɛ wʊ piel a yele nyãna be wa tãn a ka.” ");
INSERT INTO biv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilate na wõ a nɩtɔ̃ ka wʊ sʊrɔ, Galilee lɛ a daba yi bɩɩ? ");
INSERT INTO biv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wʊn wa bɔ̃ɔn ka a Hɛrɔd paal nɩrɛ lɛ, wʊ vɛ̃ naa ka ba tara wʊ chiin tɩ kʊ a Hɛrɔd, ka ɩ a Jerusalɛm lɛ wʊ mɩ be a sɔ̃ɔ 'lɔ̃nɔ̃. ");
INSERT INTO biv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hɛrɔd na wa nyɛ a Yesu, wʊ pʊɔ pɛl naa, bojũu a kor wʊn wõ a Yesu yele na wʊ bʊɔrɔ a wʊ nyɛfʊ, ka wʊ tʊ̃ a nɛ'maa tʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Na wʊ sʊʊr a Yesu sʊʊr yɔɔ tɩ waa haa wʊ nɛɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ka a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a Mosesɩ Nɛɛ wiwiilbe na ara a be 'yɛrɛ 'yɛr kpãɛn dɔɔlɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hɛrɔd nɩ a wʊ sojasɩ maal a Yesu dɛɛr na ba ɩrɛ wʊ laara. Ba su wʊ naa a nãa fuu tɩ lɩɛb wʊ chiin a Pilate sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hɛrɔd nɩ a Pilate dɔ̃ɔ tara taa nɩ 'yɛr, tɩ a daar 'lɔ̃nɔ̃ lɛ ba maal a 'yɛr. ");
INSERT INTO biv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Be lɛ a Pilate bʊɔl a bɔɔrlo nɩbɛrɛ, nɩ a tẽe nɩbɛrɛ, nɩ a nɩbɛ ba jaa lɔ̃ɔ taa. ");
INSERT INTO biv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Na wʊ 'yɛr kʊ ba, “Yɩn lɛ waan a daba nyãna a n sɛ̃ wa 'yɛr ɩka wʊ sɔ̃ɔnɔ̃ naa a nɩbɛ. N vɩɛr naa a wʊ 'yɛr a yɩ jaa niem ka a ala yɩn 'yɛr dɔɔl wʊ ba ɩ yelmãɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hɛrɔd mɩ ba nyɛ yele jaa a wʊ jie ɛ, ala lɛ so ka wʊ lɛ lɩɛb wʊ wa kʊ sɩ, yɩn mãɛ nyɛ naa wʊn ba maal yele jaa na sɛɛn kũu ɛ. ");
INSERT INTO biv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","A lɛ jũu ɩn vɛ̃ naa ka ba fɔb wʊ tɩchɛ kaa n bar wʊ.” ");
INSERT INTO biv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ka ba jaa ŋme chɛl daa 'yɛrɛ, “Ŋmaa daba nyã ju tɩ na fʊ yuo a Barabasɩ na fʊ kʊ sɩ.” ");
INSERT INTO biv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ba pɔɔ naa a Barabasɩ, bojũu 'yɛr dɔ̃ɔ lo be a tẽe pɔ, ka wʊ kʊ nɩrɛ. ");
INSERT INTO biv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate na bʊɔrɔ ɩka wʊ bar a Yesu wʊ lɛ 'yɛr kʊ a nɩbɛ go. ");
INSERT INTO biv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tɩchɛ ka ba chɛnɛ ŋmiere a chɛlsɩ 'yɛrɛ, “Kpa wʊ a daa ju, kpa wʊ a daa ju.” ");
INSERT INTO biv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Gbɛɛ ata lɛ wʊ sʊʊr ba, “Bo? Bãa dɛɛr lɛ wʊ ɩ? Maa ba nyɛ dɛɛr jaa wʊn sɛɛn kũu ɛ. A lɛ jũu ɩn vɛ̃n ka ba fɔb wʊ tɩ bar wʊ.” ");
INSERT INTO biv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tɩchɛ ka ba chɛnɛ tãna bʊɔrɔ ɩka wʊ kpa wʊ a daa ju, ka a ba gɔ̃mɔ̃ wa tʊ̃ɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Lɛ lɛ a Pilate 'yɛr ɩka wʊn ɩ naa a lɛ ban 'yɛr. ");
INSERT INTO biv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A Barabasɩ 'lɔ na dɔ̃ɔ dam a tẽe na wʊ kʊn nɩrɛ ka ba nyɔɔ wʊ pɔɔ, wʊ yuo wʊn bar tɩ kʊ ba a Yesu. ");
INSERT INTO biv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","A lɛ ban chiine a Yesu, ba nyɔɔn daba yuor na di Simon, Sirenɩ lɛ wʊ yi na wʊ yi a yõo tɩ kpɩɛrɛ a tẽe pɔ. Ba fɩr wʊn de a Yesu daa tuo wʊ ka wʊ turo nɩ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nɩyɔɔ turo wʊ naa lɔ̃ɔn pɔbɔ, bala lɛ kõnõ waala kʊrɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ka a Yesu lɩɛb 'yɛr kʊ ba, “Jerusalɛm pɔɔbil, yɩ ta kõnõ kʊrɔ ma ɛ, yɩ kõnõ kʊrɔ a yɩ mãɛ nɩ a yɩ bibiir. ");
INSERT INTO biv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bojũu bɩbir kɔ̃ɔ na wa vɩɛ naa ka yɩ 'yɛr, ‘Pʊpɛl lɛ kʊ a pɔbɔ bala na ab nɩ pɔɔ 'lɔ jaa na ba dɔɔ bie ɛ, bɩɩ bɩrɛ ala jaa na ba 'yɛn kaa ɛ.’ ");
INSERT INTO biv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","‘A ban pãa 'yɛrɛ kʊrɔ a tɔ̃bɛrɛ, “Yɩ lo pɔɔ sɩ, na yɩ ũu sɩ.” ’ ");
INSERT INTO biv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ala ɩ nɩbɛ maala naa a nɩtɔ̃nɔ̃ kʊ a tɩɛ na chɛnɛ ɩ a 'maar, ŋmɩnɛ ban ɩ wʊ 'lɔ wa ko?” ");
INSERT INTO biv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Dɔɔr ayi na maal dɛɛr, ka ba nyɔɔr ba 'matãan a Yesu chiine a kʊfʊ jie. ");
INSERT INTO biv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ba chiin ban tɩ tãn a jie ban bʊɔlɔ Julaa, be lɛ ba kpa ãsʊɔ jaa a wʊ daa ju, ka a nɩdɛbɛ ayi bala ka a ãsʊɔ be a Yesu nũsʊ̃ɔ jie, tɩchɛ ka a ãsʊɔ mɩ be a wʊ gʊbaa jie. ");
INSERT INTO biv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Be lɛ a Yesu 'yɛr, “N Sãa, vɛ̃ kʊ ba, baa bɔ̃ɔ a lɛ ban ɩrɛ ɛ.” Gbãm lɛ ba gba na ba põn a wʊ fuusɩ. ");
INSERT INTO biv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ka a nɩbɛ ara kaara wʊ, ka a Juu nɩbɛ nɩbɛrɛ ara kpɛrɛ wʊ na ba 'yɛrɛ, “Wʊ ma faan bamɩne, vɛ̃ a wʊ faa a wʊ mãɛ ala ɩ 'lɔ lɛ ɩ a Nɩ-iraa 'lɔ a Nãaŋmɩn na ir.” ");
INSERT INTO biv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ka a sojasɩ mɩ wa ɩrɛ wʊ laara, na ba de a dãmiir kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tɩ na ba 'yɛrɛ, “Ala ɩ fʊ̃ʊ lɛ ɩ a Juu nɩbɛ nãa, faa a fʊ mãɛ.” ");
INSERT INTO biv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ba sɛb sɛbie mar be a wʊ ju pɔ ka a 'yɛr, “Nyãna lɛ ɩ a Juu Nɩbɛ Nãa”. ");
INSERT INTO biv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","A nɩdɛbɛ bala ban lɔ̃ɔ kpan wʊ, ãsʊɔ tʊrɔ wʊn 'yɛrɛ, “A ba ɩ fʊ̃ʊ lɛ ɩ a Nɩ-iraa ɛ? Faa a fʊ mãɛ tɩ mɩ faa sɩ.” ");
INSERT INTO biv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tɩchɛ ka a wʊ tɔ sʊɔ 'lɔ gɔ̃nɔ̃ wʊ 'yɛrɛ, “Faa joro Nãaŋmɩn dãbãɛ ɛ, an ɩ a kũu 'lɔ lɛ fʊ mɩ kpire. ");
INSERT INTO biv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sɩn gefʊ sɛɛn sɩ naa, sɩ nyɛn a lɛ na sɛɛ sɩn maal, tɩchɛ a daba nyã 'lɔ ba maal dɛɛr jaa ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tɩ pãa 'yɛr kʊ a Yesu, “Tɩɛr tɔ ma fʊ̃ʊ wa kpɛ a fu nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ka a Yesu 'yɛr, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ fʊ, dɩna maa nɩ fʊ̃ʊ lɛ a Nãaŋmɩn tẽvɩla pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A mɔ̃tɔ̃ɔ dɔ̃ɔ gbʊrɔ a garju sãlsɔɔ tɩchɛ ka a chãa ɩ jaa gbɛb, ka a mɔ̃tɔ̃ɔ wa tɩ vɩr. ");
INSERT INTO biv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","A mɔ̃tɔ̃ɔ ba lɛ chaar go ɛ, ka a fɔbaa 'lɔ ban lũ var a Nãaŋmɩn puorfʊ yir die pɔ 'mar ayi. ");
INSERT INTO biv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Be lɛ a Yesu tãn kpɛ̃ɔ jaa 'yɛr, “N Sãa, fʊ nũu pɔ lɛ n de a n sɩɛ 'yɔ̃ɔ.” Wʊn wa 'yɛr a nɩtɔ̃ baar, tɩ vʊʊr a wʊ vʊʊr baaraa. ");
INSERT INTO biv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","A sojasɩ nɩkpɛ̃ɛ na nyɛ a lɛ na ɩ wʊ dãn Nãaŋmɩn tɩ 'yɛr, “Sɩrɛ jaa a daba nyã ɩn nɩtor.” ");
INSERT INTO biv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ka a nɩbɛ ba jaa na lɔ̃ɔ taa a be nyɛn a lɛ na ɩ ka ba lɩɛb pʊsɔ̃ɔ, na ba waala kulo. ");
INSERT INTO biv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tɩchɛ a wʊ nɩbɔ̃ɔnsɩ pʊɔn a pɔbɔ bala na tu wʊ yi a Galilee ara tɛɛr tɩ kaara a lɛ na ɩrɛ. ");
INSERT INTO biv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Daba ãsʊɔ mɩ ben be ban bʊɔlɔ Josefʊ, wʊ pʊɔ naa a nɩbɛrɛ pɔ, na wʊ ɩ nɩsʊ̃ nɩ nɩtor. ");
INSERT INTO biv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Wʊ tɔr naa a lɛ ban 'yɛr nɩ a lɛ ban ɩrɛ. Wʊ yi naa a Judiya paal pɔ tẽe ban bʊɔlɔ Arimatɩya, wʊ mɩ dɔ̃ɔ chɛlɛ a Nãaŋmɩn nãalʊ̃ʊ. ");
INSERT INTO biv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","'Lɔ lɛ chen a Pilate sɛ̃ tɩ sʊɔr a Yesu ãgãn ɩka wʊ ũu. ");
INSERT INTO biv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na wʊ pãa yɔɔ a kũu suun tɩ vil wʊ a fɔpɩla pɔɔ tɩ ũu wʊ a yaa ban chɩ kʊsɩr pɔ, ban ba ũu nɩrɛ sɛrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A daar 'lɔ̃nɔ̃ lɛ ba mɩ chɔɔrɔ ka a Pɛ̃nfʊ Bɩbir na piel. ");
INSERT INTO biv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","A pɔbɔ bala nɩ a Yesu na 'mataa yi a Galilee wa, ba tu naa a Josefʊ tɩ nyɛ a yaa nɩ a lɛ ban ũu a Yesu. ");
INSERT INTO biv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tɩ na ba pãa lɩɛb kul tɩ chɔɔr a tãɩ nɩ a kãnyũu vɩla na tɩ fɔ a Yesu ãgãn, tɩchɛ a Pɛ̃nfʊ Bɩbir jũu, baa dam ɛ, ba pɛ̃n naa a lɛ a Mosesɩ Nɛɛ na 'yɛr. ");
INSERT INTO biv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","A Pɛ̃nfʊ Bɩbir divɩɛ bio bibio, a pɔbɔ den a kãnyũur vɩla ala ban chɔɔr chiin a be a yaa par. ");
INSERT INTO biv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba tɩ nyɛn ka a kʊsɩr bil yi a yaa nɛɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ka ba kpɛ tɩchɛ baa nyɛ a Yesu ãgãn ɛ. ");
INSERT INTO biv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","A ba ara bẽne a lɛ nɛ ka a dɔɔr ayi wa dũu ba ka a ba bʊ̃sursɩ pɛl saa nyɩɩrfʊ kaar. ");
INSERT INTO biv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ka a dãbãɛ kpɛ a pɔbɔ, ka ba kpa kpa jur a tẽe, tɩchɛ ka a dɔɔr sʊʊr ba, “Bo so ka yɩ bʊɔrɔ a vʊr a kũusɩ pɔ? ");
INSERT INTO biv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Waa be ka ɛ. Wʊ ir naa. Yɩ tɩɛr a lɛ wʊn 'yɛr kʊ yɩ a sɔ̃ɔ 'lɔ wʊn be a yɩ sɛ̃, be a Galilee. ");
INSERT INTO biv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Ban nyɔɔ naa a maa Nɩsaal Bie 'yɔ̃ɔ a nɩdɛbɛ nuur pɔ, ka ba kʊ ma a daa ju, tɩchɛ a ber ata daar, ka n lɛ ir ɩ vʊr.’ ” ");
INSERT INTO biv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Be lɛ ba pãa tɩɛr tɔ a wʊ 'yɛrbie. ");
INSERT INTO biv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ban wa yi a yaa par kul, ba tɩ man a anyãna kʊ a Pie Nɩ Bʊ̃'yen nɩ nɩrɛ jaa. ");
INSERT INTO biv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mɛɛr na yi Magdala, nɩ Joana nɩ a Jemesɩ ma Mɛɛr nɩ a bamɩne na pʊɔ ba lɛ man a anyãna kʊ a nɩtʊ̃nsɩ. ");
INSERT INTO biv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tɩchɛ baa sɔɔ de a pɔbɔ 'yɛr ɛ, bojũu a ba 'yɛr nyɛntãan jire. ");
INSERT INTO biv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","An be a lɛ ka Pita vaa ir jo chen a yaa par, na wʊ tɩ guun muul kaa na wʊ nyɛ a fɔpɩla na for gã wʊ yõ, ka wʊ lɩɛb yi tɩ bẽne a lɛ na ɩ. ");
INSERT INTO biv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A daar 'lɔ̃nɔ̃ a wʊ poturbo ayi chiine naa a tẽbile ãsʊɔ ban bʊɔlɔ Emayusɩ na ba jãan a Jerusalɛm ɛ. ");
INSERT INTO biv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ka ba pãa 'yɛrɛ kʊrɔ taa a lɛ jaa na ɩ. ");
INSERT INTO biv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","A lɛ ban 'yɛrɛ na ba mana a anyãna kʊrɔ taa, ka a Yesu mãɛ wa pʊɔ ba a ba 'mataa chiine. ");
INSERT INTO biv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tɩchɛ ka a lɩɩ ba a baa bɔ̃ɔ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ka wʊ sʊʊr ba, “Bo lɛ yɩ chiine mana kʊrɔ taa a lɛ mɔ̃?” Ka a nɩbaal kpɛ ba a ba tɛɛ ara. ");
INSERT INTO biv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ka ba ãsʊɔ yuor na di Kɩleopasɩ sʊʊr wʊ, “Fʊ̃ʊ tɛɛ lɛ ɩ sãan be a Jerusalɛm na faa bɔ̃ɔ lɛ na ɩ a be a ber ayi anyãna ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A wʊ sʊʊr, “Bo yele?” Ka ba 'yɛr, “A Yesu na yi a Najaretɩ, Nãaŋmɩn 'yɛ'yɛrɛ lɛ wʊ ɩ, ka a wʊ 'yɛr nɩ a wʊ maalfʊ kpɛ̃mɛ a Nãaŋmɩn nɩ a nɩbɛ niem. ");
INSERT INTO biv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","A bɔɔrlo nɩbɛrɛ nɩ a sɩ nɩbɛrɛ nyɔɔ wʊn tɩr ɩka ba kʊ, ka ba kpa wʊ a daa ju. ");
INSERT INTO biv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tɩchɛ 'lɔ lɛ sɩn mɩ tɩɛrɛ ɩka wʊn faan a Isɩral nɩbɛ. A ala na ɩ dɛɛr jaa nɩ nyã, ber ata nɩ nyã a lɛ na ɩ. ");
INSERT INTO biv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","A sɩ pɔbɔ bamɩne lɛ wa 'maa sɩ nɛɛ, a bibio nyãna lɛ ba chen a yaa par, ");
INSERT INTO biv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tɩchɛ baa tɩ nyɛ a wʊ ãgãn ɛ. Na ba wa 'yɛr kʊ sɩ ɩka ba nyɛn malakasɩ ka ba 'yɛr ɩka wʊ ir ɩ vʊr. ");
INSERT INTO biv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ka a sɩ taaba bamɩne pãa mɩ chen a yaa par tɩ nyɛ ka ɩ a lɛ nɛ a pɔbɔ na 'yɛr lɛ, tɩchɛ a 'lɔ mãɛ baa nyɛ wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ka wʊ 'yɛr kʊ ba, “Ŋmɩnɛ lɛ yɩ faa tɩɛr lɛ, na yaa tʊ̃ɔ tɩɛr tɔ na yɩ sɔɔ de a lɛ a Nãaŋmɩn 'yɛ'yɛrbɛ na 'yɛr ɛ? ");
INSERT INTO biv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A ba ɩ a Nɩ-iraa na din a dɔɔyɛ anyãna tɩ na wʊ pãa kpɛ a wʊ tɩɩr pɔ ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Wʊ piel naa Mosesɩ nɩ a lɛ a Nãaŋmɩn 'yɛ'yɛrbɛ ba jaa, na wʊ pãa wiil ba a par a lɛ a Nãaŋmɩn gãn na 'yɛr a wʊ mãɛ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","A lɛ ban wa tara a tẽe 'lɔ pɔ ban chiine, a Yesu po naa fɩka tɛɛr wʊn chiine. ");
INSERT INTO biv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tɩchɛ ka ba sʊɔr wʊ yãayãabɩlɛ 'yɛrɛ, “Lɩɛb kpɛ wa gã a sɩ sɛ̃, bojũu mɔ̃tɔ̃ɔ 'mʊr baar.” Ka wʊ lɩɛb kpɛ na gã a ba sɛ̃. ");
INSERT INTO biv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Be lɛ a ba tɩ 'mataa jãnɛ a bʊ̃diir par na di, ka wʊ de a paanʊ̃ɔ na puor Nãaŋmɩn yãan, tɩ piel ŋmara põnõ ba. ");
INSERT INTO biv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ka a ba nɩbie pãa yuo, ka ba bɔ̃ɔn ɩka a Yesu lɛ, tɩ wʊ bɔr a ba niem. ");
INSERT INTO biv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ka ba 'yɛrɛ kʊrɔ taa, “Ala lɛ so wʊn 'yɛrɛ nɩ sɩ a sɔr pɔ ka a nʊ̃ɔ kpɛ sɩ a lɛ, wʊn wiil sɩ a lɛ na sɛb a Nãaŋmɩn gãn pɔ.” ");
INSERT INTO biv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Be lɛ ba vaa ir fɔɔ jaa lɩɛb chen a Jerusalɛm tɩ nyɛ a Pie Nɩ Bʊ̃'yen nɩ a Yesu poturbo bamɩne na lɔ̃ɔ taa. ");
INSERT INTO biv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na ba 'yɛr kʊ ba, “Sɩrɛ jaa lɛ a sɩ Soro ir ɩ vʊr, na wʊ ir a wʊ mãɛ wiil a Simon.” ");
INSERT INTO biv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A ba ayi bala pãa man a lɛ na ɩ a sɔr pɔ nɩ a lɛ ban de bɔ̃ɔn ɩka a Yesu lɛ wʊn wa ŋma a paanʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","A anyãna ban chɛnɛ 'yɛrɛ ka a Yesu mãɛ wa ara a ba sɛ̃ tɩ 'yɛr kʊ ba, “Nyã'maar wʊ be a yɩ sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ka a dãbãɛ kpɛ ba a ba mii a lɛ a gbɛ gbɛ, tɩɛr ɩka kpĩin lɛ ba nyɛ. ");
INSERT INTO biv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A wʊ sʊʊr ba, “Bo lɛ so ka a dãbãɛ kpɛ yɩ a lɛ, a nɩ bo lɛ so ka yɩ baala a lɛ? ");
INSERT INTO biv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yɩ kaa nyɛ a n nuur nɩ a gbɛɛ, maa mãɛ lɛ, yɩ sɩɩr ma kaa, kpĩin ba lɛ ɛ. Kpĩin maa tara ãgãn nʊ̃n nɩ kɔɔr nɩtãa lɛ yɩn nyɛ ma ɩn tara ɛ.” ");
INSERT INTO biv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wʊn 'yɛr a nɩtɔ̃ baar, wʊ wiil ban a wʊ nuur nɩ a wʊ gbɛɛ. ");
INSERT INTO biv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tɩchɛ baa chɛnɛ sɔɔ de sɛrɛ ɛ, nʊ̃ɔ kpɛ ba naa ka a nɛɛr 'maa ba, ka wʊ sʊʊr ba, “Yaa tara bon na kʊ ma ka n di ɛ?” ");
INSERT INTO biv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Be lɛ ba kʊ wʊ jãŋmaa ban wɔ̃, ");
INSERT INTO biv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ka wʊ 'wɔb be a ba niem. ");
INSERT INTO biv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wʊ pãa 'yɛr kʊ ba, “A anyãna lɛ n 'yɛrɛ kʊrɔ yɩ ɩn dɔ̃ɔ chɛnɛ be a yɩ sɛ̃. Yele a jaa na sɛb a Mosesɩ nɛɛ pɔ, nɩ a ala na sɛb a Nãaŋmɩn 'yɛ'yɛrbɛ gãn pɔ, nɩ a yiel gãn pɔ, a n jũu na ɩ naa lɛ.” ");
INSERT INTO biv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Be lɛ wʊ pãa yuo a ba tɩɛr ka ba tʊ̃ɔ bɔ̃ɔ a Nãaŋmɩn 'yɛr ala na sɛb a wʊ gãn pɔ. ");
INSERT INTO biv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Wʊ 'yɛr kʊ ba, “A anyãna lɛ sɛb a Nãaŋmɩn gãn pɔ, a Nɩ-iraa na din dɔɔyɛ na wʊ kpi na wʊ lɛ ir ɩ vʊr a ber ata daar. ");
INSERT INTO biv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ban den a wʊ yuor mʊɔl kʊ nɩbʊrɔ ba jaa, ka ãsʊɔ jaa wa lɩɛb a wʊ tɩɛr, Nãaŋmɩn na vɛ̃ naa a wʊ yeldɛɛr bar, Jerusalɛm lɛ an piel. ");
INSERT INTO biv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yɩn lɛ ɩ a anyãna dãasɩɛ dẽme. ");
INSERT INTO biv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A maa na tɩ tʊ̃ naa a 'lɔ a n Sãa na tɩr a nɛɛ kʊ yɩ, tɩchɛ yɩ chɛnɛ jãnɛ a Jerusalɛm, ka a kpɛ̃ɔ 'lɔ wa yi a saaju wa pɔɔ yɩ.” ");
INSERT INTO biv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wʊ tara ban yin tɩ gbʊrɔ nɩ a Betanɩ na wʊ tur a nuur saaju sʊɔr Nãaŋmɩn 'yɔ̃ɔ ba. ");
INSERT INTO biv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","A lɛ wʊn sʊɔr a Nãaŋmɩn kʊ ba, wʊ bar ba naa ka Nãaŋmɩn 'mɔɔ wʊ don be a saaju. ");
INSERT INTO biv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","A ba pãa gbʊr dumo puor wʊ tɩ lɩɛb pʊpɛl kul a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bɩbir jaa lɛ ba ma chen be a Nãaŋmɩn puorfʊ yir tɩ dãna a Nãaŋmɩn.");
INSERT INTO biv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","A pielfʊ daar a 'lɔ ban bʊɔlɔ a 'Yɛr ben be, ka a 'Yɛr be a Nãaŋmɩn sɛ̃, ka a 'Yɛr ɩ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Wʊ dɔ̃ɔ be a Nãaŋmɩn sɛ̃ a pielfʊ daar. ");
INSERT INTO biv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","A 'Yɛr nyã lɛ Nãaŋmɩn maal bomo a jaa. Bon jaa ba maal ka a ba tu a 'Yɛr nyã pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A wʊ pɔ lɛ nyɛvʊr be, a wʊ nyɛvʊr nyã lɛ kʊrɔ bomo a jaa chãa. ");
INSERT INTO biv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A chãa nyã lɛ chaara a libe pɔ, ka libe ba tʊ̃ɔ wʊ kpĩin ɛ. ");
INSERT INTO biv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nãaŋmɩn tʊ̃n daba na di Jɔɔn. ");
INSERT INTO biv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","'Lɔ lɛ wa di a dãasɩɛ na wʊ 'yɛr a chãa nyã 'yɛr, ka a nɩrɛ jaa na tu a wʊ sɛ̃ sɔɔ de a chãa. ");
INSERT INTO biv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jɔɔn ba ɩ a chãa ɛ, tɩ wʊ wa naa ɩka wʊ wa 'yɛr a chãa 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A yelmãɛ chãa nyã lɛ chaara 'yɔ̃ɔnɔ̃ nɩrɛ jaa na waara a wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A 'yɛr dɔ̃ɔ be a wɛr pɔ, ka a Nãaŋmɩn gba maal a wɛr tu a wʊ 'yɔ̃ɔ, tɩchɛ ãsʊɔ jaa ba bɔ̃ɔ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wʊ wa naa a wʊ mãɛ paal pɔ, tɩchɛ a wʊ mãɛ nɩbɛ ba de wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tɩchɛ nɩbɛ bamɩne de wʊ naa, na ba sɔɔ de a wʊ yuor, ka wʊ kʊ ba sɔr ka ba ɩ Nãaŋmɩn bibiir. ");
INSERT INTO biv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Baa ɩ Nãaŋmɩn bibiir nɩrɛ dɔɔfʊ kaar ɛ, bɩɩ nɩrɛ bɔfʊ pɔ ɛ, tɩchɛ Nãaŋmɩn mãɛ lɛ maal ba a wʊ bibiir. ");
INSERT INTO biv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A 'yɛr wa ɩ naa nɩrɛ na wʊ jãnɛ a sɩ sɛ̃. Sɩ nyɛ naa a wʊ tɩɩr, a tɩɩr nyã na ɩ a Sãa Bidabʊ̃'yen tɛɛ. 'Lɔ lɛ yi a Sãa sɛ̃ wa, na wʊ tara wãɛfʊ nɩ yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jɔɔn 'yɛr a wʊ 'yɛr, na wʊ tãna 'yɛrɛ, “Nyã lɛ n 'yɛr yɩ ɩka wʊn wa naa, 'lɔ na be a n puor waara gar ma naa, bojũu wʊ dɔ̃ɔ be be tɩ ba wa dɔɔ ma.” ");
INSERT INTO biv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","A wãɛfʊ sɛɛ wʊ naa, ka a wʊ maal vɩla lʊɔr sɩ jaa bʊ̃'yen 'yen dɔɔlɔ taa waara a sɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bojũu, Mosesɩ lɛ dɔ̃ɔ waan a nɛɛ, tɩchɛ Yesu Kɩrɩsɩto mɩ lɛ waan a wãɛfʊ nɩ yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nɩbʊ̃'yen jaa ba nyɛ Nãaŋmɩn ɛ, tɩchɛ a Bidabʊ̃'yen tɛɛ 'lɔ na be a Sãa lõboor lɛ wiil sɩ a lɛ Nãaŋmɩn na be. ");
INSERT INTO biv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A nɩbɛrɛ na be a Jerusalɛm tʊ̃n a Juu nɩbɛ bɔɔrlorbo nɩ a Juu nɩbɛ puorfʊ jie sʊ̃sʊ̃nbɔ ka ba tɩ sʊʊr Jɔɔn, nɩbuor lɛ wʊ ɩ, ");
INSERT INTO biv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ka a Jɔɔn 'yɛr ba, “N ba ɩ a Nãaŋmɩn Nɩ-iraa 'lɔ wʊn tʊ̃ ɩka wʊ wa faa a wʊ nɩbɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ka ba lɛ sʊʊr wʊ ɩka 'lɔ lɛ ɩ a Elaija bɩɩ? Ka wʊ 'yɛr, “N ba ɩ wʊ ɛ.” Ka ba lɛ sʊʊr wʊ ka 'lɔ lɛ a Nãaŋmɩn 'yɛ'yɛrɛ ɔ? Ka wʊ ɩka, “Kai.” ");
INSERT INTO biv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ka ba sʊʊr wʊ, “Tɩ an lɛ fʊ pãa ɩ? A sɩn tɩ 'yɛr kʊ a bala na tʊ̃ sɩ, 'yɛr sɩ a nɩrɛ 'lɔ fʊn ɩ.” ");
INSERT INTO biv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jɔɔn den a lɛ a Isaiya na dɔ̃ɔ sɛb na wʊ 'yɛr, “Maa lɛ a kɔkɔr 'lɔ na tãna a dãlpʊɔ pɔ, ɩka yɩ chɔɔr a Soro sɔr.” ");
INSERT INTO biv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A Faraseemɩne tʊ̃n nɩbɛ bamɩne a Jɔɔn sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ba wa sʊʊr wʊ naa, “Ala ɩ fʊ̃ʊ baa ɩ a Nãaŋmɩn Nɩ-iraa ɛ, bɩɩ a Elaija ɛ, bɩɩ a Nãaŋmɩn 'yɛ'yɛrɛ ãsʊɔ ɛ, ŋmɩnɛ a fʊ suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ?” ");
INSERT INTO biv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Be lɛ a Jɔɔn 'yɛr ba, “Maa den kʊ̃ɔ suoro nɩ a nɩbɛ, tɩchɛ nɩrɛ kɔ̃ɔ ben a yɩ pɔ, yɩn ba bɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","An ɩ maa lɛ de nie wa gba, n ba sɛɛ ɩka n for a wʊ nafɔbɔ mibe gba ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jɔɔn be naa a mɔ̃tɔ̃ɔ puorfʊ jie suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ, a Jordan man gɔ̃ɔn na be a Betanɩ, be lɛ wʊ 'yɛr a 'yɛr anyãna. ");
INSERT INTO biv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wɛr na wa chaar, Jɔɔn nyɛn a Yesu na tor wʊ waara ka wʊ 'yɛr, “Nyɛ a Nãaŋmɩn Pɛraabile, 'lɔ lɛ na de a wɛr nɩbɛ yeldɛbɛ bar. ");
INSERT INTO biv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wʊ ɩ naa a 'lɔ ɩn 'yɛr ɩka, ‘nɩrɛ ãsʊɔ na wa naa, wʊ gar ma naa, bojũu 'lɔ dɔ̃ɔ be be tɩ ba wa dɔɔ ma.’ ");
INSERT INTO biv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Maa ba bɔ̃ɔ a nɩnyɩnɛ wʊn ɩ ɛ, tɩ naa wa suoro yɩ nɩ kʊ̃ɔ ka bala jaa na be a Isɩral na nyɛ wʊ.” ");
INSERT INTO biv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","A Jɔɔn dãasɩɛ nɩ nyã, “N ben be nyɛ a Nãaŋmɩn Sɩɛ na yi saaju fɩka ŋmam, wa 'mar wʊ, ka a Sɩɛ be a wʊ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","N ba dɔ̃ɔ bɔ̃ɔ a nɩnyɩnɛ wʊn ɩ ɛ. A 'lɔ na tʊ̃ ma ɩka n wa suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ 'yɛr kʊ ma, ‘A nɩrɛ 'lɔ 'yɔ̃ɔ fʊn wa nyɛ a Sɩɛ na suu wa 'mar na waa yi ɛ, 'lɔ lɛ na suoro a nɩbɛ nɩ a Sɩɛ.’ ");
INSERT INTO biv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","N nyɛn a anyã na ɩ, 'yɛrɛ kʊrɔ yɩ ɩka 'lɔ lɛ a Nãaŋmɩn Bidabʊ̃'yen.” ");
INSERT INTO biv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","A wɛr na chaar go, Jɔɔn ara na a be nɩ a wʊ poturbo ayi. ");
INSERT INTO biv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Be lɛ wʊ nyɛ Yesu na tala, ka wʊ 'yɛr, “Yɩ nyɛ a Nãaŋmɩn Pɛraabile.” ");
INSERT INTO biv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","A Jɔɔn poturbo ayi bala na wõ a lɛ wʊn 'yɛr, ka ba turo a Yesu chiine. ");
INSERT INTO biv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu na wa lɩɛb nyɛ ba, wʊ sʊʊr ba naa, “Bo yɩ bʊɔrɔ?” Ka ba 'yɛr, “Wiwile nyɩnɛ fʊ kpɩɛrɛ?” ");
INSERT INTO biv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ka a Yesu 'yɛr, “Yɩ wa bɔ̃ɔ a jie.” Ba jãnɛ naa a wʊ sɛ̃, bojũu mɔ̃tɔ̃ɔ bal baar a daar 'lɔ̃nɔ̃. ");
INSERT INTO biv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","A nɩbɛ ayi bala na wõ a lɛ Jɔɔn na 'yɛr ka ba turo a Yesu, ãsʊɔ lɛ Andiru na ɩ a Simon Pita yɛbɛ. ");
INSERT INTO biv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Lɛ a Andiru na de nie ɩ lɛ, wʊ bɔ naa a wʊ yɛbɛ Simon 'yɛr wʊ, “Sɩ nyɛn a Nɩ-iraa 'lɔ na wa faa a wʊ nɩbɛ ban bʊɔlɔ a Kɩrɩsɩto.” ");
INSERT INTO biv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andiru tara naa a yɛbɛ waan a Yesu sɛ̃. Yesu na wa nyɛ wʊ, ka wʊ 'yɛr, “Jɔɔn bidaba Simon, ban bʊɔlɔ fʊ naa Sɩfasɩ.” A wʊ par lɛ Pita. ");
INSERT INTO biv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A ber anaar daar, Yesu chiine naa a Galilee, be lɛ wʊ nyɛ Filip na wʊ bʊɔl wʊ ɩka wʊ wa turo wʊ. ");
INSERT INTO biv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","A Filip yin Betɩsaida, Andiru nɩ Pita tẽe. ");
INSERT INTO biv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip mɩ chen tɩ nyɛ Natanɩɛl 'yɛr kʊ wʊ, “Sɩ nyɛn a 'lɔ a Mosesɩ nɩ a Nãaŋmɩn 'yɛ'yɛrbɛ na sɛb a wʊ yele, 'lɔ lɛ ɩ a Yesu na yi a Najaretɩ, Josefʊ bidaba.” ");
INSERT INTO biv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Be lɛ a Natanɩɛl sʊʊr wʊ, “Yelsʊ̃ na tʊ̃ɔ yi a Najaretɩ tẽe ɔ?” Ka a Filip 'yɛr, “Wa kaa.” ");
INSERT INTO biv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu na wa nyɛ a Natanɩɛl na tor wʊ waara, wʊ 'yɛr naa, “Yɩ nyɛ a sɩ sãakpã Isɩral yɔ̃ɔ na ba tara bɛlfʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ka a Natanɩɛl sʊʊr a Yesu, “Ŋmɩnɛ fʊ ɩrɛ wa bɔ̃ɔ ma?” Ka a Yesu 'yɛr, “Filip na wa bʊɔlɔ fʊ, ka n nyɛ fʊ naa a kɔ̃kɔ̃ɔ tɩɛ pĩlem.” ");
INSERT INTO biv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Be lɛ a Natanɩɛl 'yɛr, “Wiwile, fʊ ɩn Nãaŋmɩn Bie nɩ a Isɩral Nãa.” ");
INSERT INTO biv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ka a Yesu 'yɛr sɔɔ wʊ, “Fʊ sɔɔ ma naa, bojũu ɩn 'yɛr ɩka n nyɛ fʊ naa a kɔ̃kɔ̃ɔ tɩɛ pĩlem ɔ? Fʊn nyɛn yelbɛrɛ ka a gar lɛ. ");
INSERT INTO biv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na wʊ 'yɛr, sɩrɛ jaa lɛ n 'yɛrɛ kʊrɔ fʊ ɩka fʊn nyɛn saaju na yuo ka a Nãaŋmɩn malakasɩ suro tɩ duoro a maa Nɩsaal Bie 'yɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A ber a nyã puor, Yesu ma Mɛɛr be naa a pɔɔ ban kulo a tẽe na be a Galilee paal pɔ, ka ba bʊɔlɔ Keena. ");
INSERT INTO biv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ba bʊɔl Yesu nɩ a wʊ poturbo ka ba mɩ be be a pɔɔ kulfʊ jie. ");
INSERT INTO biv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","A dãa na wa baar, Mɛɛr 'yɛr kʊ Yesu, “A nɩbɛ dãa baar naa.” ");
INSERT INTO biv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ka a Yesu 'yɛr, “N ma, n sɔ̃ɔ ba ta ɛ, ta wiil ma a lɛ ɩn na ɩ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mɛɛr lɩɛb 'yɛr kʊ a tʊ̃tʊ̃nbɔ, “Yɩ ɩ lɛ Jaa a Yesu na wa 'yɛr ɩka yɩ ɩ.” ");
INSERT INTO biv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kʊsɩɛ dʊʊr ayʊɔb ben be, be lɛ a nɩbɛ ma ɔ̃ɔ a kʊ̃ɔ pɛɛ a ba mãɛ lɛ a ba puorfʊ na ɩka ba ɩ. Yoi anaar bɩɩ anũu lɛ ma sɛɛ ãsʊɔ jaa. ");
INSERT INTO biv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu 'yɛr a tʊ̃tʊ̃nbɔ ɩka ba ɔ̃ɔ kʊ̃ɔ sɛɛ a dʊʊr. ");
INSERT INTO biv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","An wa sɛɛ ka wʊ 'yɛr kʊ ba, “Yɩ pãa ɔ̃ɔ a kʊ̃ɔ amɩne kʊ a nɩkpɛ̃ɛ 'lɔ na kaara a pɔɔ paalaa yele.” Ka a tʊ̃tʊ̃nbɔ ɩ a lɛ a Yesu na 'yɛr ba. ");
INSERT INTO biv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ka a nɩkpɛ̃ɛ 'lɔ na wa nyũ a kʊ̃ɔ ala na lɩɛb ɩ dãa, waa bɔ̃ɔ a jie a dãa na yi ɛ. A tʊ̃tʊ̃nbɔ 'lɔ bɔ̃ɔ naa. Be lɛ wʊ bʊɔl a pɔɔ paalaa sɩrɛ yin chɛ̃chɛ̃ɛ, ");
INSERT INTO biv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na wʊ 'yɛr, “Nɩbɛ ma den nie waan a dãnʊ̃ɔ, bala wa nyũ tɩɩ baar, ka ba pãa waan a ala na ba bɔ̃ɔ nʊ̃mɔ̃ ɛ. Tɩchɛ fʊ̃ʊ 'lɔ bin a dãnʊ̃ɔ bar wa ta a baaraa.” ");
INSERT INTO biv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","A nɛ'maa yele nyã lɛ de nie Yesu na ɩ a Keena na be a Galilee paal pɔ. Be lɛ Yesu wiil a wʊ tɩɩr, ka a wʊ poturbo sɔɔ de wʊ. ");
INSERT INTO biv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","A nyã puor, 'lɔ naa ma nɩ a wʊ yɛbil naa poturbo 'mantaa chen Kapenahum ɩka ba tɩ jɛ̃ bãlãa. ");
INSERT INTO biv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","A kʊ̃ lɛ kor ɛ, ka a Juu nɩbɛ Gõl Bar Difʊ ta, Yesu don a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Be lɛ wʊ tɩ nyɛ nɩbɛ na daara niin, piir nɩ papar, a Juu nɩbɛ puorfʊ yir bɛchaar pɔ. Wʊ nyɛn bamɩne mɩ na jɛ̃n tɛɛbʊlsɩ tɛɛrɛ libie. ");
INSERT INTO biv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wʊ den miir maal kpaara diin ba bar a puorfʊ yir bɛchaar pɔ, nɩ a ba piir nɩ a niin. Wʊ tɩɛ naa a libitɛɛrbɛ tɛɛbʊlsɩ lɔb ka a libie yɛ̃yɛl. ");
INSERT INTO biv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Yesu 'yɛr kʊ a bala na daara a papar, “Yɩ yin a papar a ka, na yɩ ta maal ma a Sãa yir daa difʊ jie ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ka a poturbo pãa tɩɛr tɔ lɛ a Nãaŋmɩn gãn na 'yɛr, “Lɛ ɩn nʊ̃ a fʊ yir 'moro man fɩka bũu.” ");
INSERT INTO biv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","A Juu nɩbɛrɛ pãa sʊʊr a Yesu, “Jãnɛ buor lɛ fʊn maal wiil sɩ ka a ɩ fʊ tara na sɔr fʊn maal a lɛ?” ");
INSERT INTO biv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ka Yesu 'yɛr, “Yɩ ŋmɛr a puorfʊ yir nyãna, tɩ ka n de ber ata mɛn wʊ go.” ");
INSERT INTO biv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ka a nɩbɛrɛ 'yɛr, “Yuom lɩjaayi nɩ ayʊɔb lɛ ba de mɛn a puorfʊ yir nyã, ŋmɩnɛ fʊ̃ʊ na ɩ de ber ata tɛɛ mɛn wʊ?” ");
INSERT INTO biv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tɩchɛ a puorfʊ yir nyã a Yesu na 'yɛrɛ, ɩ naa a wʊ ãgãn lɛ wʊ 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yesu na wa ir a kũu pɔ, ka a wʊ poturbo tɩɛr yuo a lɛ wʊn 'yɛr, na ba pãa sɔɔ de lɛ a Nãaŋmɩn gãn na 'yɛr nɩ lɛ mɩ a Yesu na 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","A be a Jerusalɛm a Gõl Bar Difʊ na wa ta, nɩyɔɔ sɔɔn de a wʊ yuor, bojũu ba nyɛn a nɛ'maa tʊ̃mɔ̃ wʊn tʊ̃. ");
INSERT INTO biv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tɩchɛ Yesu na bɔ̃ɔ nɩrɛ jaa tɩɛr, waa sɔɔ de wʊ mãɛ kʊ ba ɛ. ");
INSERT INTO biv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","A ba ɩ nɩrɛ lɛ na 'yɛr wʊ lɛ nɩbɛ na be ɛ, bojũu wʊ bɔ̃ɔn nɩrɛ jaa tɩɛr. ");
INSERT INTO biv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Daba dɔ̃ɔ be be a Faraseemɩne pɔ, ka a wʊ yuor di Nikodimasɩ, wʊ mɩ ɩ naa a Juu nɩbɛ nɩdiere ãsʊɔ. ");
INSERT INTO biv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wʊ dɔ̃ɔ chen a Yesu sɛ̃ tãsɔɔ na wʊ tɩ 'yɛr, “Wiwile, sɩ bɔ̃ɔn naa ɩka Nãaŋmɩn lɛ tʊ̃ fʊ ɩka, fʊ wa wiil sɩ. Fʊ kʊ̃ naa tʊ̃ɔ a nɛ'maa tʊ̃mɔ̃ anyãna tʊ̃ ɛ, ka Nãaŋmɩn ba be a fʊ sɛ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ka a Yesu haa 'yɛr, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ fʊ, fʊ̃ʊ ba nyɛ dɔɔ paalaa ɛ, fʊ kʊ̃ tʊ̃ɔ kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","A Nikodimasɩ sʊʊr wʊ, “Ŋmɩnɛ lɛ ban lɛ ɩ dɔɔ nɩkoraa gbɛɛ ayi? Wʊ kʊ̃ lɛ tʊ̃ɔ kpɛ a wʊ ma pʊɔ pɔ ka wʊ lɛ bɔ̃ɔ dɔɔ wʊ go ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ka a Yesu 'yɛr, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ fʊ, fʊ̃ʊ na kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ, ka baa dɔɔ wʊ nɩ a kʊ̃ɔ nɩ a Sɩɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","A 'lɔ a nɩrɛ na dɔɔ ɩ naa nɩrɛ bie, Nãaŋmɩn Sɩɛ mɩ lɛ na tʊ̃ɔ nɩrɛ lɩɛb ka wʊ ɩ Nãaŋmɩn bie. ");
INSERT INTO biv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ta ɩ a nɛɛ 'maa fʊ ɩn 'yɛr ɩka a sɛɛ naa ka ba dɔɔfʊ dɔɔ paalaa ɛ. ");
INSERT INTO biv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nãaŋmɩn Sɩɛ tɛɛ lɛ tɩrɛ a nyɛvʊr paalaa. A Sɩɛ kaar naa sɛsɛbɛ na furo chiine jie 'lɔ wʊn bʊɔrɔ, fʊn tʊ̃ɔn wõ a dɔɔn, tɩchɛ fʊ kʊ̃ tʊ̃ɔ bɔ̃ɔ a jie wʊn yi ɛ, bɩɩ a jie wʊn chiine ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ka a Nikodimasɩ sʊʊr wʊ, “Ŋmɩnɛ an ɩ wa ɩ a lɛ?” ");
INSERT INTO biv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ka a Yesu haa 'yɛr, “Ŋmɩnɛ fʊ ɩ a Isɩral nɩbɛ wiwile tɩ ba bɔ̃ɔ a anyãna ɛ? ");
INSERT INTO biv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ fʊ, sɩ 'yɛrɛ naa ala sɩn bɔ̃ɔ, na sɩ di a ala sɩn 'yɛrɛ dãasɩɛ, tɩchɛ yɩ ãsʊɔ jaa ba de a lɛ sɩn 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ala ɩ yaa sɔɔ de a wɛr nyã bonsɩ 'yɛr ɛ, ŋmɩnɛ yɩn ɩrɛ wa sɔɔ de ala ɩ, n 'yɛr naa saaju bonsɩ 'yɛr? ");
INSERT INTO biv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nɩrɛ ba do saaju jaa ɛ, ka a Nɩsaal Bie na yi a be wa tɛɛ ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","A Nɩsaal Bie na 'mɔɔn saaju nɩtãa lɛ a Mosesɩ na maal a kur jɩɛ 'mɔɔ a mɔgɔ̃ɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ka nɩrɛ 'lɔ jaa na pãa sɔɔ de a Nɩsaal Bie na tara na nyɛvʊr 'lɔ na ba tara baarfʊ ɛ, Nãaŋmɩn sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Nãaŋmɩn nʊ̃ naa a nɩbɛ na be ka a wɛr pɔ yɔɔ jaa, na wʊ de a wʊ Bidabʊ̃'yen tɛɛ kʊ sɩ, nɩrɛ jaa wa sɔɔ de wʊ, wʊ kʊ̃ wɛ ɛ, tɩ tara a nyɛvʊr 'lɔ na ba tara baarfʊ ɛ, Nãaŋmɩn sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bojũu, Nãaŋmɩn ba tʊ̃ a wʊ Bidabʊ̃'yen nyã a wɛr pɔ ɩka wʊ wa sɔ̃ɔ a nɩbɛ ɛ, tɩchɛ wʊ wa naa ɩka wʊ wa faa ba. ");
INSERT INTO biv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nɩrɛ 'lɔ jaa na wa sɔɔ de a Nãaŋmɩn Bidabʊ̃'yen nyã, wʊ kʊ̃ sɔ̃ɔ wʊ ɛ, tɩchɛ nɩrɛ 'lɔ jaa na ba wa sɔɔ de wʊ ɛ, wʊn sɔ̃ɔ wʊn bar, bojũu waa sɔɔ de a Nãaŋmɩn Bidabʊ̃'yen tɛɛ nyã yuor ɛ. ");
INSERT INTO biv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A baaraa nɩ nyã, chãa wan ka a wɛr pɔ, tɩchɛ a nɩbɛ nʊ̃n libe gar a chãa, bojũu a ba maalfʊ ɩn bier. ");
INSERT INTO biv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","A nɩbɛ bala na ɩrɛ a bier 'laar chãa, ba kʊ̃ sɔɔ yi chãa pɔ ɛ, bojũu a chãa na wiil naa a lɛ ban be. ");
INSERT INTO biv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tɩchɛ ãsʊɔ jaa na be be nɩ yelmãɛ ma wan chãa pɔ, bojũu ba bʊɔrɔ naa ɩka a ba taaba ba bɔ̃ɔ ɩka Nãaŋmɩn lɛ maala a lɛ ban maala.” ");
INSERT INTO biv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","A nyã puor, Yesu nɩ a wʊ poturbo 'mantaa chen Judiya be lɛ wʊ jɛ̃n ba bãlãa, na wʊ suoro nɩbɛ a Nãaŋmɩn kʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jɔɔn mɩ dɔ̃ɔ suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ be a Ainon, a be ba jãa naa Salim ɛ, bojũu kʊ̃ɔ dɔ̃ɔ be be yɔɔ. Nɩbɛ dɔ̃ɔ chiine a wʊ sɛ̃ ka wʊ suoro ba a Nãaŋmɩn kʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Baa na nyɔɔ a Jɔɔn pɔɔ sɛrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jɔɔn poturbo bamɩne nɩ a Juu nɩrɛ ãsʊɔ chɩrɛ nɩ taa nɩ a ãgãn pɛɛfʊ yele. ");
INSERT INTO biv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ba chen a Jɔɔn sɛ̃ tɩ 'yɛr, “Wiwile, fʊ 'yɛr a daba 'lɔ sɛ̃ fʊn dɔ̃ɔ be a Jordan man gɔ̃ɔn. Wʊ suoro na nɩbɛ a Nãaŋmɩn kʊ̃ɔ ka nɩrɛ jaa chiine a wʊ sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ka Jɔɔn haa 'yɛr, “Nɩrɛ jaa kʊ̃ tʊ̃ɔ ɩ bon jaa ɛ, ka Nãaŋmɩn na be a saaju baa sɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yɩn mãɛ chɛnɛ na tɩɛr a ŋmɩnɛ ɩn dɔ̃ɔ 'yɛr yɩ ɩka n ba ɩ a Nɩ-iraa ɛ. Tɩchɛ wʊ tʊ̃ ma naa ka n de a wʊ nie. ");
INSERT INTO biv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A 'lɔ na kulo a pɔɔ, 'lɔ lɛ ɩ a pɔɔ sʊɔ. A wʊ bɩbɩɛlɛ pʊɔ ma pɛl naa wʊn ara a be wõnõ a pɔɔ sʊɔ kɔkɔr. Ala lɛ so ka a n pʊɔ mɩ pɛl. ");
INSERT INTO biv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A sɛɛ naa ɩka Yesu wʊ do, tɩchɛ ka maa suu. ");
INSERT INTO biv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Nãaŋmɩn Bie nyã lɛ yi a saaju, 'lɔ lɛ gar ba jaa, nɩrɛ na yi ka a tẽe ɩn a tẽe tʊɔr na wʊ ma 'yɛrɛ a tẽe bomo 'yɛr. A 'lɔ na yi a saaju wa gar a bomo a jaa. ");
INSERT INTO biv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Wʊ ma 'yɛr naa a lɛ wʊn nyɛ nɩ a lɛ wʊn wõ tɩ ãsʊɔ jaa maa sɔɔ de wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nɩrɛ 'lɔ jaa na wa sɔɔ de, a wiil naa ɩka Nãaŋmɩn ɩ naa yelmãɛ sʊɔ. ");
INSERT INTO biv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Bojũu, Nãaŋmɩn tʊ̃ naa a wʊ Bie ka wʊ wa 'yɛr a wʊ 'yɛr. Nãaŋmɩn vɛ̃ naa ka a wʊ Sɩɛ sɛɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","A Sãa nʊ̃ naa Bie na wʊ de yele a jaa 'yɔ̃ɔ a wʊ nũu pɔ. ");
INSERT INTO biv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nɩrɛ jaa na sɔɔ de a Bie tara na nyɛvʊr 'lɔ na ba tara baarfʊ ɛ, Nãaŋmɩn sɛ̃, tɩchɛ nɩrɛ 'lɔ na tɔr wʊ, ba tara a nyɛvʊr nyã ɛ, tɩ Nãaŋmɩn suur be a wʊ sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu bɔ̃ɔn naa ɩka a Faraseemɩne wõ naa wʊn nyɛrɛ nɩbɛ suoro ba a Nãaŋmɩn kʊ̃ɔ, ka a bala na turo wʊ gar a bala na turo a Jɔɔn. ");
INSERT INTO biv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tɩchɛ Yesu poturbo lɛ dɔ̃ɔ suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ, a ba ɩ Yesu mãɛ lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu bar naa Judiya tɩ lɩɛb chiine a Galilee go. ");
INSERT INTO biv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ka a ɩ Samariya lɛ a sɛɛ ɩka wʊ tu. ");
INSERT INTO biv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","A sɔr 'lɔ wʊn tu tɩ yi naa a Saika tẽe pɔ, na wʊ gbʊr a wɛr 'lɔ a Jekɔb na dɔ̃ɔ de kʊ a wʊ bidaba Josefʊ a kõr jaa. ");
INSERT INTO biv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A lɔ-ɔ̃ɔ a Jekɔb na dɔ̃ɔ tuu chɛnɛ na be be, ka a Yesu jɛ̃ gbʊr a lɔ-ɔ̃ɔ bojũu wʊ chen bal. Mɔ̃tɔ̃tuo sɔ̃ɔ lɛ. ");
INSERT INTO biv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ka a Samariya pɔɔ suu a lɔ-ɔ̃ɔ pɔ kʊ̃ɔ ɔ̃ɔfʊ jie. Ka a Yesu sʊɔr wʊ, “Pɔɔ yãayãabɩlɛ, ɔ̃ɔ a kʊ̃ɔ kʊ ma ka n nyũ.” ");
INSERT INTO biv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","A Yesu poturbo mɩ kpɛ̃n a tẽe pɔ ɩka ba tɩ da bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ka a Samariya pɔɔ 'yɛr, “Fʊ̃ʊ Juu nɩrɛ, maa mɩ Samariya pɔɔ, taa ɩ ŋmɩnɛ ka fʊ ɩka n kʊ fʊ kʊ̃ɔ ka fʊ nyũ,” sɩn nɩ Juu nɩbɛ na ba mʊɔrɔ taa bũu ɛ? ");
INSERT INTO biv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","A Yesu 'yɛr wʊ, “Faa bɔ̃ɔ a bon a Nãaŋmɩn na bʊɔrɔ ɩka wʊ kʊ fʊ ɛ. Faa mɩ bɔ̃ɔ a nɩrɛ 'lɔ na sʊɔrɔ fʊ a kʊ̃ɔ ɩka wʊ nyũ ɛ, fʊ̃ʊ ta bɔ̃ɔ, fʊn taa sʊɔr man a kʊ̃ɔ 'lɔ na kʊrɔ nyɛvʊr.” ");
INSERT INTO biv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A pɔɔ 'yɛr, “Nɩkpɛ̃ɛ, faa tara bʊ̃-ɔ̃ɔnaa ɛ, ka a lɔ-ɔ̃ɔ mɩ yulʊ̃, nyɩnɛ lɛ fʊn nyɛ a kʊ̃ɔ ala na kʊrɔ a nyɛvʊr? ");
INSERT INTO biv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","A sɩ sãakpã Jekɔb lɛ tuu a lɔ-ɔ̃ɔ nyãna kʊ sɩ, ka wʊ yɔn nɩ a wʊ dʊ̃n nyuro. Fʊ̃ʊ bɛrma gar a Jekɔb bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ka Yesu 'yɛr, “Ɩ̃sʊɔ jaa na nyũ a kʊ̃ɔ nyãna, kɔ̃nyũur na kpɛ wʊ̃n go. ");
INSERT INTO biv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tɩchɛ ãsʊɔ jaa na nyũ a kʊ̃ɔ ala ɩn na kʊ wʊ, kɔ̃nyũur kʊ̃ lɛ kpɛ wʊ go ɛ. A kʊ̃ɔ ala ɩn na kʊ wʊ kaara kɔ̃bulaa na yire, naa kʊrɔ nyɛvʊr na ba tara baarfʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ka a pɔɔ 'yɛr, “Nɩkpɛ̃ɛ yãayãabɩlɛ, kʊ ma a kʊ̃ɔ ala ka n nyũ, ka a kɔ̃nyũur ta lɛ nyɔɔ ma ka n suu a lɔ-ɔ̃ɔ nyã pɔ go ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","A Yesu 'yɛr wʊ, “Kul tɩ tara a fʊ sɩrɛ waan.” ");
INSERT INTO biv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ka a pɔɔ 'yɛr, “N ma tara sɩrɛ ɛ.” A Yesu 'yɛr, “Yelmãɛ fʊ 'yɛr ɩka faa tara sɩrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Fʊ dɔ̃ɔ kul sɩrbɛ anũu, tɩ a daba 'lɔ sɛ̃ fʊn be a pʊ̃pãanyã ba ɩ a fʊ sɩrɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ka a pɔɔ 'yɛr, “Nɩkpɛ̃ɛ n nyɛ naa a fʊ ɩ Nãaŋmɩn 'yɛ'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","A sɩ sãakpãmɩne, a tɔ̃ɔ nyã ju lɛ ba ma do tɩ puor a Nãaŋmɩn tɩchɛ a yɩn Juu nɩbɛ 'yɛr ɩka Jerusalɛm tɛɛ lɛ ɩ a puorfʊ jie.” ");
INSERT INTO biv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ka a Yesu 'yɛr kʊ wʊ, “Pɔɔ sɔɔ de ma, sɔ̃ɔ waara an kʊ̃ ɩ a tɔ̃ɔ nyã ju bɩɩ Jerusalɛm yɩn do tɩ puor a Sãa Nãaŋmɩn go ɛ. ");
INSERT INTO biv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","A yɩn Samariya nɩbɛ ba bɔ̃ɔ a 'lɔ yɩn puoro ɛ, a sɩn Juu nɩbɛ bɔ̃ɔ naa a Nãaŋmɩn 'lɔ sɩn puoro. Bojũu a sɩ jie lɛ Nãaŋmɩn na tu faa nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tɩchɛ a sɔ̃ɔ waara, wʊ gɔr ta baar, a bala na puoro a Nãaŋmɩn sɩrɛ jaa, a sɩɛ na wiil ba naa ka ba puor a Sãa Nãaŋmɩn nɩ yelmãɛ. Ba nyãna puorfʊ lɛ a Sãa Nãaŋmɩn bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nãaŋmɩn ɩn sɩɛ, bala na puoro wʊ a sɩɛ pɔ wʊn wiil ba naa ka ba puor wʊ nɩ yelmãɛ pɔ.” ");
INSERT INTO biv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ka a pɔɔ 'yɛr, “N bɔ̃ɔ naa ɩka a Nɩ-iraa na wa naa, a 'lɔ sɩn na bʊɔlɔ a Kɩrɩsɩto. 'Lɔ wa wa, wʊn wiil sɩ naa yele a jaa par.” ");
INSERT INTO biv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ka a Yesu 'yɛr kʊ a pɔɔ, “Maa lɛ a nɩrɛ 'lɔ nɩ fʊ̃ʊ na 'yɛrɛ a pʊ̃pãanyã.” ");
INSERT INTO biv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ka a ɩ a poturbo mɩ tɔ̃ɔ ta nyɛ wʊn 'yɛrɛ nɩ a pɔɔ ka a nɛɛr 'maa ba. Tɩchɛ ba ãsʊɔ jaa ba 'la sʊʊr wʊ bo lɛ wʊ bʊɔrɔ bɩɩ bãa 'yɔ̃ɔ lɛ wʊ 'yɛrɛ nɩ a pɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A jie lɛ a pɔɔ bar a yuor tɩ jo kul a tẽe pɔ tɩ 'yɛr kʊ a nɩbɛ, ");
INSERT INTO biv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Yɩ wa nyɛ daba na 'yɛr ma ala a jaa n na dɔ̃ɔ maal. Kaa 'lɔ lɛ ɩ a Nɩ-iraa naa 'lɔ bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nɩrɛ jaa na be a tẽe pɔ yin chen na tɩ kaa a Yesu. ");
INSERT INTO biv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","An wa ɩrɛ a lɛ ka a poturbo sʊɔr a Yesu. “Wiwile yãayãabɩlɛ, di bʊ̃diir.” ");
INSERT INTO biv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tɩchɛ ka a Yesu 'yɛr kʊ ba, “N tara na bʊ̃diir yɩn ba bɔ̃ɔ a yele ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ka wʊ poturbo piel sʊrɔ taa, “Nɩrɛ kɔ̃ɔ lɛ tɔ̃ɔ waan bon kɔ̃ɔ wa kʊ wʊ ka wʊ di bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A Yesu 'yɛr, “N bʊ̃diir lɛ ka n ɩ a lɛ Nãaŋmɩn na bʊɔrɔ, 'lɔ lɛ tʊ̃ ma, ka n baar a tʊ̃mɔ̃ 'lɔ wʊn kʊ ma ɩka n tʊ̃. ");
INSERT INTO biv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yɩn 'lɔ 'yɛr naa ɩka a chɛn ŋmɛrsɩ anaar ka a ŋmab ta, maa 'yɛr kʊ yɩ ɩka, yɩ kaa yɩn nyɛn a por bonsɩ na mʊ̃ɔ sɛɛ ŋmab. ");
INSERT INTO biv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pʊ̃pãanyã gba, a tʊ̃tʊ̃nbɔ bala na ŋmara nyɛrɛ naa a ba sãyar, ban lɔ̃ɔnɔ̃ a bʊ̃ŋmarsɩ waara nɩ nyɛvʊr na ba tara baarfʊ ɛ Nãaŋmɩn sɛ̃. Ka a bala na bʊr a bʊ̃bie nɩ a ŋmaŋmarba pãa 'mataa chɩlɛ. ");
INSERT INTO biv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","A sʊkpa na ɩ yelmãɛ ɩka, bamɩne lɛ bʊr ka bamɩne mɩ ŋma. ");
INSERT INTO biv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Maa tʊ̃nɔ̃ yɩ naa ɩka, yɩ chen tɩ ŋma a puo 'lɔ pɔ a bamɩne na tʊ̃ hãn.” ");
INSERT INTO biv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nɩyɔɔ na yi a Samariya tẽe pɔ sɔɔn de Yesu, bojũu a pɔɔ 'yɛr kʊ ba ɩka, “A daba nyã 'yɛr naa a lɛ jaa n na dɔ̃ɔ maal.” ");
INSERT INTO biv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ba wan wa sʊɔr wʊ ɩka wʊ jãnɛ a ba tẽe, ka wʊ jɛ̃ be ber ayi. ");
INSERT INTO biv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","A Samariya tẽe dẽme yɔɔ jie mɩ lɛ sɔɔn de Yesu bojũu ba wʊn a lɛ wʊn 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Be a ba 'yɛr kʊ a pɔɔ, “A ba ɩ lɛ fʊn 'yɛr kʊ sɩ jũu sɩ sɔɔ de a Yesu ɛ, sɩn mãɛ wõ naa a lɛ wʊn 'yɛr kʊ sɩ, ka sɩ bɔ̃ɔ ɩka 'lɔ lɛ na faa a wɛr nɩbɛ.” ");
INSERT INTO biv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","A ber ayi na po, wʊ yin a be na wʊ chen Galilee. ");
INSERT INTO biv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu 'yɛr naa, “Nãaŋmɩn 'yɛ'yɛrbɛ nyɛrɛ na 'yɔ̃ɔfʊ jie jaa, tɩchɛ a ba tẽe dẽme ba 'yɔ̃ɔnɔ̃ ba ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wʊn wa ta a Galilee, a nɩbɛ de wʊn nuur ayi a be, bojũu ba mɩ dɔ̃ɔ chen a Jerusalɛm a Gõl Bar Difʊ jie tɩ nyɛ a lɛ jaa wʊn maal. ");
INSERT INTO biv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu na wa be a Galilee, wʊ lɩɛb chen a Keena tẽe pɔ be wʊn dɔ̃ɔ lɩɛb a kʊ̃ɔ ka a ɩ a dãa. Nɩkpɛ̃ɛ kɔ̃ɔ ben Kapenahum ka a wʊ bie bɩɛrɛ. ");
INSERT INTO biv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wʊn wa wõ ɩka a Yesu yin a Galilee wa a Judiya, wʊ chen tɩ sʊɔr wʊ ɩka wʊ sãa a wʊ bie na kpire. ");
INSERT INTO biv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ka a Yesu 'yɛr kʊ a nɩkpɛ̃ɛ, “Yɩn baa nyɛ jãnɛ nɩ nɛ'maa yele ɛ, yɩ kʊ̃ sɔɔ de ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ka a daba 'yɛr, “Nɩkpɛ̃ɛ, yãayãabɩlɛ, wa ka a n bie ta kpi ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","A Yesu pãa 'yɛr, “A fʊ bie sa naa, kulo a yir.” A daba sɔɔn de a lɛ a Yesu na 'yɛr na wʊ lɩɛb kulo a yir. ");
INSERT INTO biv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ka a tʊ̃tʊ̃nbɔ na yi a nɩkpɛ̃ɛ yir tuor wʊ a sɔr pɔ 'yɛr, “A fʊ bie sa naa.” ");
INSERT INTO biv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A wʊ sʊʊr ba a sɔ̃ɔ buor a bie na sa, ka ba 'yɛr, “Jãa mɔ̃tɔ̃ɔ na vɩrʊ̃ lɛ a ãgãn tul bar wʊ.” ");
INSERT INTO biv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ka a bie sãa tɩɛr tɔ an ɩ a mɔ̃tɔ̃ɔ vɩr naa a jãa, a Yesu na 'yɛr, “A fʊ bie sa naa.” A daba naa bala ba jaa na be a wʊ yir sɔɔn de a Yesu. ");
INSERT INTO biv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","A nɛ'maa yelsɩ ayi lɛ anyã Yesu na tʊ̃ wʊn yi a Judiya na wʊ chen a Galilee. ");
INSERT INTO biv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","A anyã puor, a Juu nɩbɛ tara na lɔ̃ɔ di ka a Yesu chen a be a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A tẽe pɔ, gbatarbile ben be ka a jɛ̃bɛrsɩ anũu be be. A jie gbʊr a be ban bʊɔlɔ a piir dɔ̃dɔr, ka a Juu nɩbɛ kɔkɔr pɔ a ba bʊɔlɔ Betesda. ");
INSERT INTO biv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A jɛ̃bɛrsɩ ala pɔ baal bʊrsɩ ben be, jɔ̃n, bamɩne gbɛɛ na kpi kpi nɩ gbɛrsɩ ka ba gã kɔɔ a kʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A gbatarbile 'lɔ̃nɔ̃ koor mɩ lɛ nɩbaala na bɛ yuom lɩjɛr nɩ pie nɩ aniin (38) na wʊ gã a be. ");
INSERT INTO biv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu na wa nyɛ a daba, wʊ bɔ̃ɔn naa wʊn gbɛr kor, ka wʊ sʊʊr wʊ, “Fʊ bʊɔrɔ naa ɩka fʊ sa bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ka a daba 'yɛr, “Nɩkpɛ̃ɛ, n ba tara nɩrɛ na 'mɔɔ ma 'yɔ̃ɔ a kʊ̃ɔ pɔ 'lɔ wa dɔ̃ɔnɔ̃ ɛ, n ma mʊɔrɔ naa ɩka n kpɛ, tɩchɛ ka a nɩrɛ ma dɔ̃ɔ ma nie kpɛ.” ");
INSERT INTO biv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","A Yesu pãa 'yɛr wʊ, “'Mɔɔ a fʊ bʊ̃gãnaa chiine.” ");
INSERT INTO biv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ajienaa ka a daba sa, na wʊ 'mɔɔ a sɔ̃ɔ chiine. A Pɛ̃nfʊ Bɩbir daar lɛ a anyãna ɩ. ");
INSERT INTO biv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","A Juu nɩbɛrɛ na wa nyɛ a daba na tuo a sɔ̃ɔ, ka ba 'yɛr kʊ wʊ, “Pɛ̃nfʊ Bɩbir lɛ, nɩrɛ jaa ba tara sɔr ɩka wʊ tuo a wʊ sɔ̃ɔ a Pɛ̃nfʊ Bɩbir ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tɩchɛ ka wʊ 'yɛr, “A daba 'lɔ na sa ma lɛ 'yɛr kʊ ma ɩka n 'mɔɔ a sɔ̃ɔ chiine.” ");
INSERT INTO biv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ka ba sʊʊr wʊ, “Nɩbuor lɛ 'yɛr fʊ ɩka fʊ 'mɔɔ a sɔ̃ɔ tuo chiine?” ");
INSERT INTO biv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","A daba ba dɔ̃ɔ bɔ̃ɔ a Yesu a nɩbuor wʊn ɩ ɛ, Yesu kpɛ̃n a nɩyɔɔ bala pɔ. ");
INSERT INTO biv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","A nyã puor, a Yesu nyɛn a daba a Nãaŋmɩn puorfʊ yir pɔ na wʊ 'yɛr wʊ, “Fʊ pãa sãn pʊ̃pãanyã, taa wa ɩrɛ yeldɛɛr go ɛ, ka amɩne wa pɔɔ fʊ gar a lɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ka a daba chen tɩ 'yɛr kʊ a Juu nɩbɛrɛ, Yesu lɛ ɩ a nɩrɛ 'lɔ na sa ma. ");
INSERT INTO biv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ba piel bʊɔrɔ sɔɩ na ɩ Yesu yele bojũu wʊ ma tʊ̃nɔ̃ naa a anyãna a Pɛ̃nfʊ Bɩbir Daar. ");
INSERT INTO biv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ka a Yesu 'yɛr ba, “N Sãa ba vɛ̃ anyãna tʊ̃fʊ ɛ, ala lɛ so ka n mɩ tʊ̃nɔ̃.” ");
INSERT INTO biv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","A nɩbɛrɛ tara na yele ayi ban bʊɔrɔ ɩka ba kõn Yesu. Wʊ sɔ̃ɔ naa a Pɛ̃nfʊ Bɩbir yele, tɩchɛ a dɛɛr 'lɔ jaa lɛ wʊn 'yɛr ɩka Nãaŋmɩn ɩ naa a wʊ Sãa, na wʊ de a wʊ mãɛ ka 'lɔ nɩ Nãaŋmɩn ɩ bʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A Yesu 'yɛr kʊ a nɩbɛ, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka a Bie kʊ̃ tʊ̃ɔ maal bon jaa ɛ. Wʊn tʊ̃ɔ ɩ a lɛ tɛɛ wʊn nyɛ a Sãa na maala, bojũu a Bie ma maal naa a lɛ nɛ wʊn nyɛ a Sãa na maala. ");
INSERT INTO biv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","A Sãa nʊ̃n a Bie na wʊ wiil wʊ a yele a jaa wʊn maal. A Sãa gba na wiil wʊn yelbɛrɛ ka yɩ nɛɛr 'maa. ");
INSERT INTO biv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","A lɛ a Sãa na ma sãɩ a kũu na wʊ kʊ wʊ nyɛvʊr, lɛ lɛ a Bie mɩ na kʊ a ãsʊɔ jaa wʊn bʊɔrɔ a nyɛvʊr. ");
INSERT INTO biv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","A Sãa gba ba tɔɔrɔ nɩrɛ jaa 'yɛr ɛ, tɩchɛ wʊ ɩka a Bie wʊ tɔɔr nɩrɛ jaa 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","A Sãa bʊɔrɔ naa ɩka ba 'yɔ̃ɔnɔ̃ a Bie nɩtãa lɛ ban 'yɔ̃ɔnɔ̃ wʊ. Ɩ̃sʊɔ jaa wa tɔr ba 'yɔ̃ɔ a Bie ɛ, lɛ mɩ lɛ wʊ tɔr, ba 'yɔ̃ɔ a Sãa na tʊ̃ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, ãsʊɔ jaa na wõ a lɛ ɩn na 'yɛr tɩ sɔɔ de a 'lɔ na tʊ̃ ma, tara na nyɛvʊr 'lɔ na ba tara baarfʊ ɛ, Nãaŋmɩn sɛ̃. Ba kʊ̃ 'yɔ̃ɔ wʊ 'yɛr ɛ. Wʊ yin kũu pɔ, tɩ kpɛ nyɛvʊr pɔ. ");
INSERT INTO biv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, sɔ̃ɔ waara, wʊ ben ta ka a kũn na wõ a Nãaŋmɩn Bie kɔkɔr. A bala na wõ naa, na ir tara nyɛvʊr. ");
INSERT INTO biv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bojũu a Sãa tara na kpɛ̃ɔ kʊrɔ nyɛvʊr. Wʊ den a kpɛ̃ɔ 'lɔ kʊ a Bie ka wʊ mɩ tara nyɛvʊr. ");
INSERT INTO biv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wʊ kʊ wʊn sɔr ɩka wʊ tɔɔr nɩrɛ jaa 'yɛr, bojũu wʊ ɩ naa Nɩsaal Bie. ");
INSERT INTO biv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Yɩ ta vɛ̃ ka a 'maa yɩ nɛɛ ɛ. A sɔ̃ɔ na wa naa, ka a kũn wõ a Nɩsaal Bie kɔkɔr, ");
INSERT INTO biv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na ba yire a ba yar pɔ. Ɩ̃sʊɔ jaa na maal vɩla, na yin kpɛ nyɛvʊr pɔ, ka a ãsʊɔ jaa mɩ na maal dɛɛr na yin kpɛ sɔ̃ɔfʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","N kʊ̃ tʊ̃ɔ maal bon jaa nɩ maa mãɛ kpɛ̃ɔ ɛ. 'Lɔ lɛ 'yɛr ma a lɛ ɩn na tɔɔrɔ ka a n tɔɔrfʊ tara sɔr bojũu n turo naa a wʊ nɛɛ, a ba ɩ n ɩrɛ na lɛ ɩn bʊɔrɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Maa 'yɛrɛ 'yɔ̃ɔnɔ̃ a n mãɛ, sɔr jaa ba be be na wiil ɩka yelmãɛ lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nɩrɛ kɔ̃ɔ ben be na 'yɛrɛ 'yɔ̃ɔnɔ̃ ma, ka n mɩ bɔ̃ɔ ɩka a lɛ wʊn 'yɛrɛ ɩn yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Yɩ tʊ̃n nɩbɛ a Jɔɔn sɛ̃ ka wʊ tɩ 'yɛr ba a yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","N ba dɩɛl lɛ nɩbɛ na 'yɛrɛ a n 'yɛr ɛ, tɩchɛ n 'yɛrɛ yɩ naa anyãna ka yɩ na tʊ̃ɔ nyɛ faafʊ. ");
INSERT INTO biv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jɔɔn dɔ̃ɔ ɩ fɩka fãtɩn na chaar yɔ̃ɔ ka yɩ pʊɔ pɛl, a yɩ chɩl a chãa nyã pɔ bãlãa. ");
INSERT INTO biv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Bon kɔ̃ɔ na tɩrɛ gar a lɛ a Jɔɔn na dɔ̃ɔ 'yɛr a n 'yɛr, naa tʊ̃mɔ̃ ala a Sãa na kʊ ma ɩka n tʊ̃. A anyãna a jaa 'yɛrɛ na kʊrɔ ma, naa wiil ɩka a Sãa lɛ tʊ̃ ma. ");
INSERT INTO biv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","A Sãa mɩ na tʊ̃ ma 'yɛrɛ na kʊrɔ ma, tɩchɛ yaa wõ a wʊ kɔkɔr bɩɩ nyɛ a wʊ nie jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yaa sɔɔ a wʊ 'yɛr ɛ, bojũu yɩ tɔr na yaa sɔɔ de a 'lɔ wʊn tʊ̃ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yɩ ma chɛ̃pɛ̃ naa a Nãaŋmɩn gãma, bojũu yɩ tɩɛr naa ɩka be lɛ yɩn nyɛ nyɛvʊr na ba tara baarfʊ ɛ. Maa 'yɛr lɛ a gãma anyãna 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tɩchɛ yɩ tɔr naa na wa a n sɛ̃ wa nyɛ nyɛvʊr 'lɔ na ba tara baarfʊ ɛ Nãaŋmɩn sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“N baka ba be nɩrɛ pɛɛfʊ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tɩchɛ n bɔ̃ɔn naa ɩka a yɩ ãsʊɔ jaa ba nʊ̃ Nãaŋmɩn ɛ. ");
INSERT INTO biv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Maa waan naa a n Sãa yuor, ka yaa de ma ɛ. Tɩchɛ yɩn den nɩbɛ na waan ba mãɛ yuor. ");
INSERT INTO biv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ŋmɩnɛ yɩn ɩrɛ wa sɔɔ? Yɩn na bʊɔrɔ ɩka a yɩ barmɩne ba pɛɛrɛ yɩ, ka yɩ baka ba be a pɛɛfʊ 'lɔ a Nãaŋmɩn tɛɛ na kʊ yɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Tɩchɛ, yɩ taa tɩɛr ɩka ɩn 'yɔ̃ɔ yɩn 'yɛr a Sãa niem ɛ. Yɩ den a yɩ tɩɛr dɔɔl Mosesɩ, 'lɔ nɩ wʊ ju lɛ na 'yɔ̃ɔ yɩ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Maa 'yɛr lɛ a Mosesɩ na dɔ̃ɔ sɛb, ala ɩ yɩn ta sɔɔ wʊ, yɩn taa sɔɔ ma naa. ");
INSERT INTO biv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tɩchɛ yɩn ba sɔɔ a lɛ a Mosesɩ na dɔ̃ɔ sɛb ɛ, ŋmɩnɛ yɩn ɩrɛ wa sɔɔ a lɛ ɩn 'yɛr?” ");
INSERT INTO biv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","A anyã puor, Yesu gɔ̃ɔ naa a Galilee man gɔ̃ɔn be ban bʊɔlɔ a Tiberiyas. ");
INSERT INTO biv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nɩyɔɔ tu wʊn chen ban nyɛ wʊn tʊ̃ nɛ'maa tʊ̃mɔ̃ na wʊ sãa baalsɩ. ");
INSERT INTO biv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ka a Yesu pãa do a tɔ̃ɔ ju, na wʊ tɩ jãnɛ nɩ a wʊ poturbo. ");
INSERT INTO biv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ka a Juu nɩbɛ Gõl Bar Difʊ mɩ gbʊr. ");
INSERT INTO biv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu na wa nyɛ a nɩyɔɔ ka ba waara a wʊ sɛ̃, wʊ sʊʊr Filip, “Nyɩnɛ lɛ sɩn nyɛ bʊ̃diir kʊ a nɩbɛ banyãna?” ");
INSERT INTO biv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Wʊ sʊʊr a nɩtɔ̃ ɩka wʊ bɛɛr a Filip kaa, tɩ bɔ̃ɔn a lɛ wʊn na ɩ. ");
INSERT INTO biv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ka a Filip 'yɛr, “Faa bɔ̃ɔ ka an den ŋmɛrsɩ aniin sãyar a fʊn dãn paanʊ̃ɔ jaa pʊʊr kʊ a nɩbɛ banyãna ɛ?” ");
INSERT INTO biv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andiru na ɩ a Simon Pita yɛbɛ, a Yesu poturo ãsʊɔ lɛ, ka wʊ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Dabile ben ka na wʊ tara a chi jɔ̃n paanʊ̃ɔ anũu nɩ jãmɛ ayi, tɩ bo an maal a nɩyɔɔ banyãna?” ");
INSERT INTO biv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mʊɔr pɔɔn a tẽe wʊ jaa, ka a Yesu 'yɛr kʊ a poturbo ka ba ɩ a nɩbɛ jãnɛ jãnɛ. A nɩbɛ bala dɔ̃ɔ ɩ tur anũu (5,000). ");
INSERT INTO biv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu den a paanʊ̃ɔ 'yɔ̃ɔ a wʊ nũu pɔ tɩ puor Nãaŋmɩn yãan, tɩ de a paanʊ̃ɔ põ a nɩbɛ, na wʊ lɛ de a jãmɛ mɩ põ ba. ");
INSERT INTO biv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ka a nɩbɛ di lɛ ban bʊɔrɔ, ka a Yesu 'yɛr kʊ a poturbo ɩka ba wob a bʊ̃ŋmaara ala na chɛ, ka a bon jaa ta wɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Lɛ lɛ ba wob a ala na chɛ 'yɔ̃ɔ pɛr pie nɩ ayi a chi paanʊ̃ɔ anũu ala. ");
INSERT INTO biv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","A nɩbɛ na wa nyɛ a anyã baar lɛ a Yesu na tʊ̃ a nɛ'maa tʊ̃mɔ̃, ba piel 'yɛrɛ, “A nyã lɛ tɔ̃ɔ ɩ a Nãaŋmɩn 'yɛ'yɛrɛ 'lɔ na wa a wɛr pɔ.” ");
INSERT INTO biv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu na wa bɔ̃ɔn ɩka ba bʊɔrɔ naa na fɩr wʊ ka wʊ ɩ a ba nãa, wʊ don a tɔ̃ɔ ju wʊ yõ. ");
INSERT INTO biv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","A jãanʊɔr 'lɔ̃nɔ̃, a Yesu poturbo lɩɛb suu a man pɔ. ");
INSERT INTO biv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Na ba tɩ kpɛ a gboro pɔ piel gɔ̃ɔnɔ̃ a Kapenahum. A jãanɔ'maar 'lɔ̃nɔ̃ Yesu ba wa a ba sɛ̃ sɛrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A sɛsɛkpɛ̃ɛ furo na ka a kʊ̃ɔ dãdaala. ");
INSERT INTO biv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ka a poturbo na wa mɔ̃ kpɛ sɔɔ jaa, ba nyɛn a Yesu na chiine a kʊ̃ɔ ju waara a gboro par ka dãbãɛ kpɛ ba. ");
INSERT INTO biv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tɩchɛ ka wʊ 'yɛr kʊ ba, “Maa lɛ, yɩ ta joro dãbãɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ka ba ta ɩka ba de wʊ 'yɔ̃ɔ a gboro pɔ, tɩ ajienaa ka a gboro mɩ ta a gogoro nɛɛ a jie 'lɔ ban chiine. ");
INSERT INTO biv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","A wɛr na wa chaar, a nɩyɔɔ bala na jãnɛ a man gɔ̃ɔn bɔ̃ɔn na ɩka gboro bʊ̃'yen tɛɛ lɛ dɔ̃ɔ be be. Ka Yesu naa poturbo ba 'mataa kpɛ wʊ ɛ, tɩchɛ bala tɛɛ lɛ chiine. ");
INSERT INTO biv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ka gboi amɩne na yi Tiberiyas wa ara gbʊr a be a Yesu na dɔ̃ɔ puor Nãaŋmɩn yãan tɩ ka a nɩbɛ di a bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","A nɩbɛ na wa nyɛ ka a Yesu bɩɩ a wʊ poturbo ba be be ɛ, ba kpɛ̃n a gboi ala chiine a Kapenahum na tɩ bɔ a Yesu. ");
INSERT INTO biv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ban wa tɩ nyɛ wʊ a manyal gɔ̃ɔn, ba sʊʊr wʊ naa, “Wiwile, dabor fʊ wa ka?” ");
INSERT INTO biv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ka a Yesu 'yɛr, “Yelmãɛ lɛ n 'yɛrɛ kʊ̃rɔ yɩ, yɩ yʊɔrɔ na bʊɔrɔ ma a ba ɩ a nɛ 'maa tʊ̃mɔ̃ yɩn nyɛ ɩn tʊ̃ ɛ, tɩchɛ a bʊ̃diir yɩn di tɩɩ jũu. ");
INSERT INTO biv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yɩ ta tʊ̃nɔ̃ bʊɔrɔ bʊ̃diir anyã na sɔ̃ɔ ɛ, tɩ yɩ tʊ̃nɔ̃ bʊɔrɔ bʊ̃diir anyã na kʊ yɩ nyɛvʊr 'lɔ na ba tara baarfʊ ɛ, ala lɛ a maa Nɩsaal Bie na kʊ yɩ. Bojũu 'lɔ lɛ a Sãa Nãaŋmɩn kʊ sɔr ɩka wʊ ɩ a lɛ.” ");
INSERT INTO biv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Be lɛ ba sʊʊr wʊ, “Bãa lɛ sɩn na ɩ na sɩ tʊ̃ a lɛ a Nãaŋmɩn na bʊɔrɔ?” ");
INSERT INTO biv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ka a Yesu 'yɛr, “Nãaŋmɩn tʊ̃mɔ̃ nɩ nyã ɩka yɩ sɔɔ de a 'lɔ wʊn tʊ̃.” ");
INSERT INTO biv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Lɛ lɛ ba sʊʊr wʊ, “Nɛ'maa tʊ̃buor lɛ fʊn tʊ̃ ka sɩ nyɛ tɩ sɔɔ de fʊ? Bo lɛ fʊn ɩ? ");
INSERT INTO biv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","A sɩ sãakpãmɩne din a maana a mɔgɔ̃ɔ pɔ nɩtãa lɛ an sɛb. Wʊ kʊ ba naa a bʊ̃diir na yi saaju ka ba di.” ");
INSERT INTO biv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ka a Yesu 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, a ba ɩ Mosesɩ lɛ dɔ̃ɔ kʊ yɩ a bʊ̃diir ala na yi a saaju ɛ, tɩchɛ a n Sãa lɛ dɔ̃ɔ kʊ yɩ a yelmãɛ bʊ̃diir ala na yi a saaju. ");
INSERT INTO biv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","A Nãaŋmɩn bʊ̃diir ɩ naa a 'lɔ na yi a saaju wa, na wʊ wa kʊrɔ a wɛr nɩbɛ nyɛvʊr.” ");
INSERT INTO biv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ka ba 'yɛr, “Nɩkpɛ̃ɛ, an yi a dɩna tɩ chiine, kʊrɔ sɩ a bʊ̃diir ala.” ");
INSERT INTO biv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Be a Yesu pãa 'yɛr, “Maa lɛ a bʊ̃diir ala na kʊrɔ nyɛvʊr, 'lɔ jaa na wa n sɛ̃ kʊ̃ lɛ chiin kɔ̃ ɛ. 'Lɔ jaa mɩ na sɔɔ de ma, kɔ̃nyũur kʊ̃ lɛ kpɛ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tɩchɛ a lɛ n na 'yɛr kʊ yɩ, yɩ nyɛ ma naa tɩ yaa sɔɔ de ma ɛ. ");
INSERT INTO biv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bala ba jaa a Sãa na kʊ ma, ban wan a n sɛ̃. Ɩ̃sʊɔ jaa mɩ wa wa a n sɛ̃, n kʊ̃ dii wʊ bar ɛ. ");
INSERT INTO biv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bojũu, n ba yi a saaju wa ɩka n wa ɩ a n bɔfʊ ɛ, tɩ n wa naa ɩka n wa ɩ a Sãa bɔfʊ. 'Lɔ lɛ tʊ̃ ma. ");
INSERT INTO biv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A nyã lɛ ɩ a 'lɔ na tʊ̃ ma bɔfʊ, ka n taa ɩrɛ wa vɛ̃ ka bala jaa wʊn kʊ ma bɔr ɛ, tɩchɛ ka n sãɩ ba, ka ba ir ɩ vʊɛ a ber baaraa daar. ");
INSERT INTO biv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bojũu, a n Sãa bɔfʊ nɩ nyã ɩka, nɩrɛ jaa na kaa a Bie na wʊ sɔɔ de wʊ, ban tara naa a nyɛvʊr 'lɔ na ba tara baarfʊ ɛ, ka n sãɩ ba, ka ba ir ɩ vʊɛ a ber baaraa daar.” ");
INSERT INTO biv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ka a Juu nɩbɛ piel hũhũnõ bojũu a Yesu 'yɛr ɩka, 'lɔ lɛ ɩ a bʊ̃diir 'lɔ na yi a saaju wa. ");
INSERT INTO biv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ka ba 'yɛrɛ, “A ba ɩ a Yesu lɛ a nyã ɛ, a Josefʊ bidaba, a wʊ sãa nɩ a wʊ ma sɩn bɔ̃ɔ ɛ? Ŋmɩnɛ wʊ ɩrɛ wa 'yɛr ɩka saaju lɛ n yi wa?” ");
INSERT INTO biv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ka a Yesu 'yɛr ba, “Yɩ bar a hũhũfʊ. ");
INSERT INTO biv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nɩrɛ jaa kʊ̃ tʊ̃ɔ wa a n sɛ̃ ɛ, ka a Sãa na tʊ̃ ma baa tɔɔ wʊ waan ɛ, ka n sãɩ wʊ ka wʊ ir ɩ vʊr a ber baaraa daar. ");
INSERT INTO biv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","A Nãaŋmɩn 'yɛ'yɛrbɛ ãsʊɔ dɔ̃ɔ sɛb, ‘Nãaŋmɩn na wiil ba jaa.’ Ɩ̃sʊɔ jaa na chɛlɛ a Sãa sɛ̃, na wʊ jãn yi a wʊ sɛ̃, na wa naa a n sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nɩrɛ jaa ba nyɛ a Sãa ɛ, a nɩrɛ 'lɔ na yi a Nãaŋmɩn sɛ̃, 'lɔ tɛɛ lɛ nyɛ a Sãa. ");
INSERT INTO biv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, nɩrɛ 'lɔ na sɔɔ de ma tara na nyɛvʊr 'lɔ na ba tara baarfʊ ɛ, Nãaŋmɩn sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Maa lɛ ɩ a bʊ̃diir ala na tara nyɛvʊr. ");
INSERT INTO biv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","A yɩ sãakpãmɩne dɔ̃ɔ di a maana a mɔgɔ̃ɔ pɔ tɩ chɛnɛ kpi. ");
INSERT INTO biv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tɩchɛ a bʊ̃diir 'lɔ na yi a saaju wa nɩ nyã, 'lɔ lɛ nɩrɛ na di na wʊ kʊ̃ kpi ɛ. ");
INSERT INTO biv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Maa lɛ ɩ a nyɛvʊr bʊ̃diir 'lɔ na yi a saaju wa. Ala ɩ nɩrɛ di naa a bʊ̃diir nyãna, wʊn ben be jaa kpo kpo. A bʊ̃diir nyã ɩ naa a n ãgãn ɩn de kʊrɔ a nɩbɛ na be a wɛr pɔ, ka ba na nyɛ nyɛvʊr.” ");
INSERT INTO biv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ka a Juu nɩbɛ piel chɩrɛ taa nɩ suur na ba 'yɛrɛ, “Ŋmɩnɛ lɛ a daba nyãna na ɩrɛ wa kʊ sɩ a wʊ ãgãn ka sɩ 'wɔb?” ");
INSERT INTO biv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","A Yesu 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ. Yɩn baa 'wɔb a Nɩsaal Bie ãgãn na yɩ nyũ a wʊ jãɩ ɛ, yaa tara nyɛvʊr ɛ. ");
INSERT INTO biv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nɩrɛ 'lɔ jaa na 'wɔb a n ãgãn na wʊ nyũ a n jãɩ tara na a nyɛvʊr 'lɔ na ba tara baarfʊ ɛ, tɩ ka n sãɩ wʊ a wʊ ir ɩ vʊr a ber baaraa daar. ");
INSERT INTO biv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","A n ãgãn ɩ naa bʊ̃dimãɛ, ka n jãɩ mɩ ɩ bʊ̃nyũmãɛ. ");
INSERT INTO biv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nɩrɛ 'lɔ jaa na 'wɔb a n ãgãn na wʊ nyũ a n jãɩ, be naa a n 'yɔ̃ɔ ka n mɩ be a wʊ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nɩtãa lɛ a Sãa na ɩ a nyɛvʊr sʊɔ na tʊ̃ ma ka n be be a Sãa jũu, nɩrɛ 'lɔ mɩ na 'wɔb ma mɩ na ben be a maa jũu. ");
INSERT INTO biv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","A bʊ̃diir nyã lɛ yi a saaju wa. Sɩ sãakpãmɩne dɔ̃ɔ di a maana tɩ kpi, tɩchɛ nɩrɛ 'lɔ na di a bʊ̃diir nyã na ben be kpo kpo.” ");
INSERT INTO biv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu na dɔ̃ɔ wile ba a Juu nɩbɛ lɔ̃ɔfʊ yir a Kapenahum ala lɛ wʊ 'yɛr a nyãna. ");
INSERT INTO biv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesu poturbo yɔɔ na wa wõ a lɛ wʊn 'yɛr, ka ba 'yɛr, “A fʊ wiilfʊ nyã kpɛ̃mɛ na kpɛ, an lɛ na tʊ̃ɔ de?” ");
INSERT INTO biv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu na bɔ̃ɔn a lɛ a poturbo na hũhũnõ, ka wʊ sʊʊr ba, “A nɩtɔ̃ chɛ yɩn bɩɩ? ");
INSERT INTO biv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ŋmɩnɛ an pãa kaara, yɩn wa nyɛ a Nɩsaal Bie na duoro a jie 'lɔ wʊn dɔ̃ɔ be? ");
INSERT INTO biv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","'Lɔ na kʊrɔ a nɩrɛ nyɛvʊr ɩ naa Nãaŋmɩn Sɩɛ. Nɩrɛ mãɛ fɔ̃ɔ kʊ̃ tʊ̃ɔ maal bon jaa ɛ. A 'yɛr ala ɩn 'yɛr yɩ, ɩ naa Nãaŋmɩn Sɩɛ 'yɛr, naa ɩ Nyɛvʊr. ");
INSERT INTO biv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tɩchɛ a yɩ bamɩne ba sɔɔ ɛ.” Bojũu, Yesu bɔ̃ɔn naa a pielfʊ a 'lɔ na ba sɔɔ de wʊ ɛ, nɩ a 'lɔ na gar 'yɔ̃ɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Be lɛ wʊ 'yɛr, “Nɩtɔ̃ lɛ so ka n 'yɛr ɩka ãsʊɔ jaa kʊ̃ tʊ̃ɔ wa a n sɛ̃ ɛ, ka a Sãa baa waan wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","An yi a daar 'lɔ̃nɔ̃ a poturbo yɔɔ ŋmaan yi na baa lɛ turo wʊ go ɛ. ");
INSERT INTO biv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ka a Yesu sʊʊr a Pie Nɩ Ayi bala, “A yɩn mɩ, yɩ bʊɔrɔ naa ɩka yi ŋmaa yi bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Be a Simon Pita 'yɛr, “N Soro, an sɛ̃ lɛ sɩn chen? An ɩ fʊ̃ʊ tɛɛ lɛ tara a nyɛvʊr 'lɔ na ba tara baarfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Sɩ sɔɔn de na sɩ bɔ̃ɔ ɩka fʊ ɩ naa a chɛchɛ sʊɔ 'lɔ a Nãaŋmɩn na tʊ̃.” ");
INSERT INTO biv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ka a Yesu haa 'yɛr, “A ba ɩ maa lɛ ir a yɩ Pie Nɩ Ayi ɛ? Tɩchɛ ka a yɩ ãsʊɔ ɩ Satan tʊɔr.” ");
INSERT INTO biv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Wʊ 'yɛrɛ naa a Judas na ɩ a Pie Nɩ Ayi ãsʊɔ na wa gar 'yɔ̃ɔ wʊ. Wʊ ɩ naa a Simon bidaba na yi Isɩkariyot. ");
INSERT INTO biv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","A anyã puor, Yesu yi naa Judiya tɩ yʊɔrɔ a Galilee paal pɔ, bojũu a Juu nɩbɛ bʊɔrɔ naa a wʊ kʊfʊ. ");
INSERT INTO biv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tɩchɛ a Juu nɩbɛ sɛɛr pɔ lɔ̃ɔ di bɩbir na wa gbʊrɔ, ");
INSERT INTO biv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","a Yesu yɛbil 'yɛr wʊ naa, “Yi a ka chen a Judiya ka a fʊ poturbo mɩ tɩ nyɛ a fʊ nɛ 'maa tʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nɩrɛ jaa na bʊɔrɔ ɩka ba bʊɔlɔ a wʊ yuor ba sɔɔlɔ ɛ. Fʊn maala a nyãna, wiil a fʊ mãɛ ka nɩbɛ jaa nyɛ fʊ.” ");
INSERT INTO biv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bojũu a wʊ mãɛ yɛbil ba sɔɔ de wʊ gba ɛ. ");
INSERT INTO biv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","A lɛ jũu, a Yesu 'yɛr ba, “A n bɩbir ba vɩɛ ɛ, yɩn bɩbir vɩɛ naa. ");
INSERT INTO biv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","A wɛr nɩbɛ kʊ̃ tʊ̃ɔ 'laar yɩ ɛ, tɩchɛ ba 'laar ma naa bojũu n 'yɛr ba naa ɩka a lɛ ban ɩrɛ ɩn dɛɛr. ");
INSERT INTO biv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yɩn, yɩ chiine a lɔ̃ɔ di jie. Maa ba chiine a lɔ̃ɔ di jie sɛrɛ ɛ, bojũu n bɩbir ba vɩɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Wʊ 'yɛr naa lɛ tɩ chɛnɛ jãnɛ a Galilee. ");
INSERT INTO biv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","A wʊ yɛbil na wa chen a lɔ̃ɔ di jie baar ka wʊ mɩ ir sɔɔl chen. ");
INSERT INTO biv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A lɔ̃ɔ di jie lɛ a Juu nɩbɛ jʊrɔ wʊ tɩ sʊrɔ taa, “Nyɩnɛ lɛ a daba 'lɔ̃nɔ̃ be?” ");
INSERT INTO biv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A nɩyɔɔ bala bʊlɔ na 'yɛrɛ kʊ̃rɔ taa, “A Yesu ɩn nɩsʊ̃.” Ka bamɩne mɩ 'yɛrɛ, “Nɩbɛlɛ lɛ wʊ ɩ.” ");
INSERT INTO biv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tɩchɛ baa 'lara 'yɛrɛ ka a yire chãa pɔ ɛ, bojũu ba joro naa a Juu nɩbɛrɛ dãbãɛ. ");
INSERT INTO biv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","A lɔ̃ɔfʊ na wa põ jãtaa, Yesu don kpɛ a Juu nɩbɛ puorfʊ jie na wʊ tɩ piel wile. ");
INSERT INTO biv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ka a nɛɛr 'maa a Juu nɩbɛrɛ ka ba sʊrɔ taa, “Ŋmɩnɛ a daba nyã ɩrɛ wa bɔ̃ɔ a nɩtɔ̃ wʊn ba jãn ɛ?” ");
INSERT INTO biv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","A Yesu 'yɛr kʊ ba, “A wiilfʊ nyã ba yi a n sɛ̃ ɛ, a yi naa a nɩrɛ 'lɔ na tʊ̃ ma sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nɩrɛ 'lɔ na kaa ir ɩka wʊn ɩ naa Nãaŋmɩn bɔfʊ, wʊn bɔ̃ɔ naa ɩka a wiilfʊ nyã yin Nãaŋmɩn sɛ̃ bɩɩ n mãɛ lɛ n wile. ");
INSERT INTO biv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nɩrɛ 'lɔ na 'yɛrɛ a wʊ mãɛ 'yɛr, bʊɔrɔ na 'yɔ̃ɔfʊ kʊrɔ a wʊ mãɛ. Tɩchɛ nɩrɛ 'lɔ na tʊ̃nɔ̃ bʊɔrɔ 'yɔ̃ɔfʊ kʊrɔ a 'lɔ na tʊ̃ wʊ, a nɩnyɩnɛ ɩn yelmãɛ sʊɔ ka a bɛlfʊ ba be a wʊ jie ɛ. ");
INSERT INTO biv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosesɩ baa dɔ̃ɔ bin a Nɛɛ kʊ yɩ ɛ? Tɩ yɩ ãsʊɔ jaa ba tʊ̃ɔ tu ɛ. Bo 'yɔ̃ɔ lɛ yɩ bʊɔrɔ ɩka yɩ kʊ ma?” ");
INSERT INTO biv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ka a nɩyɔɔ bala 'yɛr, “Sɩdɛɛr lɛ fʊ tara, an bʊɔrɔ fʊ kʊfʊ?” ");
INSERT INTO biv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A Yesu 'yɛr kʊ ba, “Gbɛbʊ̃'yen tɛɛ lɛ n be tʊ̃, tɩchɛ ka a be 'maa yɩ a nɛɛ a nɩtɔ̃? ");
INSERT INTO biv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesɩ lɛ dɔ̃ɔ wiil yɩ a yʊɔr ŋmaafʊ an ba ɩ 'lɔ sɛ̃ lɛ a dɔ̃ɔ yi ɛ, tɩ yi a sãakpãmɩne sɛ̃, ka ba ma ŋmaa yʊɔr a Pɛ̃nfʊ Bɩbir Daar. ");
INSERT INTO biv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ala ɩ yɩn tʊ̃ɔ ŋmaa bibile yʊɔr a Pɛ̃nfʊ Bɩbir Daar tɩ ka a Mosesɩ nɛɛ 'lɔ wʊn bin ba sɔ̃ɔ ɛ, bo lɛ so ka yɩ nyɛ suur 'yɔ̃ɔ ma nɩrɛ ɩn sa a Pɛ̃nfʊ Bɩbir Daar? ");
INSERT INTO biv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yɩ ta bʊ̃nɔ̃ tɔɔr ɛ, tɩ yɩ tɔɔrɔ a lɛ na tor.” ");
INSERT INTO biv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nɩbɛ bamɩne na yi Jerusalɛm piel sʊrɔ taa, “A ba ɩ a daba nyã lɛ ba bʊɔrɔ a kʊfʊ ɛ, ");
INSERT INTO biv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","nyɛ wʊn ara 'yɛrɛ chãa pɔ, ka baa 'yɛrɛ 'yɛr ɛ? A nɩbɛrɛ bɔ̃ɔn naa ɩka 'lɔ lɛ a Nɩ-iraa bɩɩ? ");
INSERT INTO biv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tɩchɛ sɩn bɔ̃ɔ naa a jie 'lɔ a daba nyãna na yi. A Nɩ-iraa 'lɔ wa wa, nɩrɛ jaa kʊ̃ bɔ̃ɔ a jie wʊn na yi ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu chɛnɛ na wile a be a Nãaŋmɩn puorfʊ yir bɛchaar pɔ, na wʊ tãna 'yɛrɛ, “Ɔ̃ɔ yɩ bɔ̃ɔ ma naa, na yɩ lɛ bɔ̃ɔ a jie 'lɔ n na yi. N ba be ka nɩ n mãɛ kpɛ̃ɔ ɛ, tɩchɛ a nɩrɛ 'lɔ na tʊ̃ ma ɩn yelmãɛ sʊɔ, yɩn ba bɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tɩchɛ maa bɔ̃ɔ wʊ naa, wʊ sɛ̃ lɛ n yi, 'lɔ lɛ tʊ̃ ma.” ");
INSERT INTO biv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","A anyã lɛ ba ta bʊɔrɔ a wʊ nyɔɔfʊ, tɩchɛ nɩrɛ jaa ba lɩɛb wʊ nũu sɩɩr wʊ ɛ, bojũu a wʊ bɩbir ba vɩɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","A nɩyɔɔ bala pɔ, bamɩne chɛnɛ na sɔɔ de wʊ na ba 'yɛrɛ, “A Nɩ-iraa 'lɔ wa wa, wʊn tʊ̃n nɛ'maa tʊ̃mɔ̃ gar a daba nyã bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Faraseemɩne wõn a lɛ a nɩyɔɔ bala na bʊlɔ 'yɛrɛ a Yesu 'yɛr, ka a bala naa Juu nɩbɛ bɔɔrlo nɩbɛrɛ tʊ̃ a puorfʊ yir kakaarba ka ba tɩ nyɔɔ wʊ waan. ");
INSERT INTO biv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Be a Yesu 'yɛr kʊ ba, “N be naa yɩ sɛ̃ bãlãa, tɩ naa pãa lɛ lɩɛb chen a 'lɔ na tʊ̃ ma sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yɩn wa yʊɔrɔ na bʊɔrɔ ma, tɩchɛ yɩ kʊ̃ nyɛ ma ɛ, a be n na be yɩ kʊ̃ tʊ̃ɔ wa be ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ka a Juu nɩbɛ pãa sʊrɔ taa, “Nyɩnɛ lɛ a daba nyã na pãa chen ka sɩ kʊ̃ nyɛ wʊ ɛ? Wʊn chen naa be a sɩ nɩbɛ na yaar jɛr a bala na ba ɩ a Juu nɩbɛ tɩ wile ba bɩɩ? ");
INSERT INTO biv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ŋmɩnɛ lɛ wʊ 'yɛr ɩka, yɩn wa yʊɔrɔ na bʊɔrɔ ma tɩ yɩ kʊ̃ nyɛ ma ɛ, a be n na be yɩ kʊ̃ tʊ̃ɔ wa be ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","A bɩbir baaraa daar na ɩ a lɔ̃ɔ di bɩbir kpɛ̃ɛ, Yesu ir ara tɩ tãn 'yɛr, “Kɔ̃nyũur wa kpɛ nɩrɛ, wʊ wa a n sɛ̃ wa nyũ. ");
INSERT INTO biv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nɩrɛ 'lɔ jaa na sɔɔ de ma nɩtãa lɛ a Nãaŋmɩn gãn na 'yɛr, nyɛvʊr kʊ̃ɔ na joro na yire a wʊ 'yɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nãaŋmɩn Sɩɛ 'yɛr lɛ wʊ dɔ̃ɔ 'yɛrɛ, a bala na sɔɔ de wʊ ka wʊn kʊ ba. A Sɩɛ ba dɔ̃ɔ wa ɛ, an ɩ a Yesu ba nyɛ a tɩɩr sɛrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","A nɩbɛ na wa wõ a lɛ wʊn 'yɛr, ka bamɩne 'yɛr, “A daba nyã ɩn Nãaŋmɩn 'yɛ'yɛrɛ yelmãɛ.” ");
INSERT INTO biv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ka bamɩne mɩ 'yɛrɛ, “A nyã lɛ ɩ a Nãaŋmɩn Nɩ-iraa.” Ka bamɩne mɩ 'yɛr, “Ŋmɩnɛ lɛ a Nɩ-iraa 'lɔ na ɩrɛ wa yi Galilee? ");
INSERT INTO biv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nãaŋmɩn gãn ba 'yɛr ɩka David yɔ̃ɔ lɛ wʊn ɩ na wʊ yi Bɛtɩlɛhɛm, a tẽe 'lɔ a David na dɔ̃ɔ kpɩɛrɛ ɛ?” ");
INSERT INTO biv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ka a nɩbɛ ŋma dẽ dẽ a Yesu juu. ");
INSERT INTO biv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bamɩne mɩ ta bʊɔrɔ na ɩka ba nyɔɔ wʊ tɩchɛ nɩrɛ jaa ba 'la sɩɩr wʊ nɩ wʊ nũu ɛ. ");
INSERT INTO biv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","A puorfʊ yir gugurbo lɩɛb chen a Farasee nɩ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ sɛ̃, ka ba sʊʊr ba, “Ŋmɩnɛ wʊ ɩ ka yaa waan wʊ ɛ?” ");
INSERT INTO biv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ka a bala ban tʊ̃, ka ba 'yɛr, “Nɩrɛ jaa ba 'yɛr 'yɛr a daba nyã kaar ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ka a Faraseemɩne sʊʊr ba, “Wʊ mɩ ben bɛl yɩ wɛ? ");
INSERT INTO biv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yɩ nyɛn a Faraseemɩne nɩ a nɩbɛrɛ ka ba sɔɔ de wʊ? ");
INSERT INTO biv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kai, tɩchɛ a nɩyɔɔ ba nyãna ba bɔ̃ɔ a Nãaŋmɩn nɛɛ ɛ, ba ben pɔ 'yɔ̃ɔfʊ pɔ gba.” ");
INSERT INTO biv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimasɩ na dɔ̃ɔ chen a Yesu sɛ̃ mɩ ɩ naa a ba ãsʊɔ sʊʊr ba, ");
INSERT INTO biv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“A nɛɛ ba kʊ sɩ sɔr ɩka sɩ 'yɔ̃ɔ nɩrɛ yele ka saa wõ a lɛ wʊn 'yɛr bɩɩ maala ɛ?” ");
INSERT INTO biv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ka ba sʊʊr wʊ, “Fʊ mɩ yin Galilee bɩɩ? Jʊʊr kaa, a la ɩ fʊ nyɛn Nãaŋmɩn 'yɛ'yɛrɛ na yi Galilee.” ");
INSERT INTO biv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ka ba jaa yaar kul a ba yie. ");
INSERT INTO biv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tɩchɛ ka a Yesu mɩ do a Olive Tɩɩr Tɔ̃ɔ ju. ");
INSERT INTO biv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wɛr na wa chaar bibio pipi, Yesu lɩɛb wa kpɛ a Nãaŋmɩn puorfʊ yir bɛchaar pɔ, be lɛ a nɩbɛ ŋmaa jilʊ̃ wʊ tɩ wʊ jãnɛ wile ba. ");
INSERT INTO biv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Be lɛ a Mosesɩ Nɛɛ wiwiilbe, nɩ a Faraseemɩne wa 'mataa waan pɔɔ ban nyɔɔ na gãn daba. Ba vɛ̃n ka a pɔɔ ir ara a ba jaa niem, ");
INSERT INTO biv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","tɩ ba 'yɛr kʊ a Yesu, “Wiwile, a pɔɔ nyãna lɛ gãn daba ka sɩ nyɔɔ. ");
INSERT INTO biv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A Mosesɩ Nɛɛ 'lɔ 'yɛr ɩka sɩ lɔb wʊ nɩ kʊsɩɛ kʊ.” ");
INSERT INTO biv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ba 'yɛr naa a lɛ bʊɔrɔ ɩka ba bɛɛr Yesu kaa na ba tʊ̃ɔ nyɛ 'yɛr, 'yɛr a wʊ yele. Tɩchɛ ka a Yesu guun de a nubir sɛɛrɛ nɩ a tẽe. ");
INSERT INTO biv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tɩ ba chɛnɛ sʊrɔ wʊ, ka wʊ dɔl 'yɛr kʊ ba, “Ala ɩ a yɩ ãsʊɔ jaa ben ka ba maal dɛɛr ɛ, a nɩnyɩnɛ wʊ de nie lɔb a pɔɔ nɩ a kʊsɩr.” ");
INSERT INTO biv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tɩ na wʊ lɛ guun sɛɛrɛ a tẽe go. ");
INSERT INTO biv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","A anyãna ban wõ, ba piel yire bʊ̃'yen 'yen, a danyɔ̃n lɛ de nie. A wa tɩ chɛ naa a Yesu nɩ a pɔɔ tɛɛ na ara a be. ");
INSERT INTO biv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu dɔl ir sʊʊr a pɔɔ, “Nyɛ ba be? Ɩ̃sʊɔ jaa ba 'yɔ̃ɔ fʊ yele ɛ?” ");
INSERT INTO biv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ka a pɔɔ 'yɛr, “Kai nɩkpɛ̃ɛ.” Ka Yesu mɩ pãa 'yɛr wʊ, “Maa mɩ kʊ̃ 'yɔ̃ɔ fʊ yele ɛ, chiine, taa lɛ wa maala yeldɛɛr go ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu lɛ bɔ̃ɔ 'yɛr kʊ a nɩbɛ na wʊ 'yɛr, “Maa lɛ a wɛr nyã chãa, nɩrɛ 'lɔ jaa na turo ma kʊ̃ lɛ chen libe pɔ ɛ, tɩ wʊn tara na nyɛvʊr na ɩ chãa.” ");
INSERT INTO biv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ka a Faraseemɩne chɩrɛ wʊ 'yɛrɛ, “Fʊ bʊɔrɔ na yuor 'yɔ̃ɔnɔ̃ fʊ mãɛ, ka a fʊ yobɔ ɩ pɔrɔ.” ");
INSERT INTO biv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ka a Yesu 'yɛr, “Ala ɩ n bʊɔrɔ naa yuor 'yɔ̃ɔnɔ̃ a n mãɛ, a n yobɔ tara na sɔr. Bojũu n bɔ̃ɔ naa jie ɩn yi wa, naa lɛ bɔ̃ɔ a jie ɩn chiine. Tɩchɛ yɩn, yaa bɔ̃ɔ a jie ɩn yi wa ɛ, yaa lɛ bɔ̃ɔ a jie ɩn chiine ɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yɩ den nɩsaal tɩɛrsɩ tɔɔrɔ nɩ 'yɛr, maa ba tɔɔrɔ nɩrɛ jaa 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tɩchɛ ala ɩ ɩn tɔɔr naa 'yɛr, a lɛ ɩn na tɔɔr na tor naa bojũu n ba ɩ n yõ ɛ, a Sãa na tʊ̃ ma pʊɔ ma naa. ");
INSERT INTO biv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A sɛb a yɩ nɛɛr pɔ ɩka, nɩbɛ ayi 'yɛr ɩn yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","N 'yɛrɛ na 'yɔ̃ɔnɔ̃ a n mãɛ, ka a Sãa mɩ na tʊ̃ ma 'yɛrɛ 'yɔ̃ɔnɔ̃ ma.” ");
INSERT INTO biv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ka ba sʊʊr wʊ, “Nyɩnɛ a fʊ Sãa be?” Ka Yesu 'yɛr “Yaa bɔ̃ɔ ma ɛ, bɩɩ a n Sãa ɛ, ala ɩ yɩ ta bɔ̃ɔ ma naa, yɩn taa bɔ̃ɔ naa n Sãa mɩ.” ");
INSERT INTO biv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu 'yɛr naa a 'yɛr nyã wʊn wile ba a puorfʊ yir bɛchaar pɔ gbʊr a libie lɔb fʊ jie. Tɩ nɩrɛ jaa ba nyɔɔ wʊ ɛ, an ɩ a wʊ bɩbir ba vɩɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu 'yɛr kʊ ba go, “N chiine na, yɩn wa yʊɔrɔ na bʊɔrɔ ma tɩ na yɩ kpin a yɩ yelbier. Jie ɩn chiine, yɩ kʊ̃ tʊ̃ɔ wa be ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ka a Juu nɩbɛ pãa sʊrɔ taa, “Wʊn kʊn wʊ mãɛ bɩɩ? Ala lɛ so wʊn 'yɛr ɩka, ‘A jie ɩn chiine yɩ kʊ̃ tʊ̃ɔ wa be ɛ.’ ” ");
INSERT INTO biv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tɩchɛ ka a Yesu chɛnɛ 'yɛrɛ, “Yɩn yin ka tẽe, maa yin saaju. A wɛr nyã pɔ lɛ yɩ yi, maa mɩ ba yi a wɛr nyã pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","N 'yɛr kʊ yɩ ɩka yɩn kpin naa yɩ yelbier, ala ɩ yaa sɔɔ de ma nɩ a lɛ ɩn 'yɛr ɩka n ɩ naa ɛ, sɩrɛ jaa lɛ, yɩn kpin naa yɩ yelbier.” ");
INSERT INTO biv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ka a nɩbɛ sʊʊr wʊ, “An fʊ ɩ?” A Yesu 'yɛr ba, “N ɩ naa a 'lɔ ɩn 'yɛr kʊ yɩ a kõr jaa. ");
INSERT INTO biv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","N tara na yɔɔ ɩn taa 'yɛr tɔɔr a yɩ 'yɛr, tɩchɛ a 'lɔ na tʊ̃ ma ɩn yelmãɛ sʊɔ, ala ɩn wõ yi a wʊ sɛ̃ lɛ n 'yɛrɛ kʊrɔ a wɛr nɩbɛ.” ");
INSERT INTO biv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Baa bɔ̃ɔ a par ɩka a wʊ Sãa 'yɛr lɛ wʊ dɔ̃ɔ 'yɛrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Be a Yesu 'yɛr, “Yɩn wa 'mɔɔ a Nɩsaal Bie a saaju yɩn bɔ̃ɔ naa a nɩrɛ 'lɔ ɩn ɩ, na yɩ mɩ bɔ̃ɔ ɩka n ba ɩrɛ yele nɩ maa kpɛ̃ɔ ɛ, tɩchɛ n 'yɛrɛ naa a lɛ a Sãa na wiil ma. ");
INSERT INTO biv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","A 'lɔ na tʊ̃ ma be naa n sɛ̃, waa bar ma n yõ ɛ, bojũu n ma ɩrɛ naa lɛ na pɛlɛ a wʊ pʊɔ.” ");
INSERT INTO biv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wʊn 'yɛrɛ a lɛ tɩ nɩyɔɔ sɔɔn de wʊ. ");
INSERT INTO biv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu 'yɛr kʊ a Juu nɩbɛ bala na sɔɔ de wʊ, “Ala ɩ yɩ sɔɔn turo a lɛ ɩn wiil yɩ, yɩn ɩ naa a n poturbo yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yɩn bɔ̃ɔn a yelmãɛ, ka a yelmãɛ for yɩ bar ka yɩ so yɩ mãɛ.” ");
INSERT INTO biv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ka ba 'yɛr, “Sɩn ɩ naa Abraham yɔn, na saa ɩ nɩrɛ jaa gbãgbaar ɛ, ŋmɩnɛ lɛ fʊ 'yɛr ɩka ban for sɩn bar ka sɩ so sɩ mãɛ?” ");
INSERT INTO biv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","A Yesu 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, nɩrɛ jaa na maal dɛɛr ɩn a dɛɛr gbãgbaa. ");
INSERT INTO biv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Gbãgbaa maa be a yir kor ɛ, a bie 'lɔ ma ben be kor. ");
INSERT INTO biv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ala wa ɩ a Bie for fʊn bar, fʊn son fʊ mɩ sɩrɛ jaa. ");
INSERT INTO biv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","N bɔ̃ɔn na yɩn ɩ Abraham yɔn tɩ bʊɔrɔ ɩka yɩ kʊ ma, bojũu yaa sɔɔ a n 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Maa 'yɛrɛ yɩ naa a lɛ ɩn nyɛ a n Sãa sɛ̃, ka yɩn mɩ ɩrɛ a lɛ yɩn wõ a yɩ sãa sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ka ba 'yɛr, “Abraham lɛ ɩ a sɩ sãa.” Be a Yesu 'yɛr, “Ala ɩ Abraham bibiir lɛ yɩ ta ɩ, yɩn taa maal a lɛ a Abraham na dɔ̃ɔ maal. ");
INSERT INTO biv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yɩ ben bʊɔrɔ ɩka yɩ kʊ ma a nɩrɛ na 'yɛr yɩ a yelmãɛ ɩn wõ a Nãaŋmɩn sɛ̃. Abraham ba dɔ̃ɔ maal lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yɩ ɩrɛ naa a lɛ a yɩ sãa mãɛ na dɔ̃ɔ ɩ.” Ka ba 'yɛr, “Saa ɩ sɛ̃sɛ̃ bibiir ɛ, sɩn Sãa tɛɛ sɩn tara lɛ Nãaŋmɩn.” ");
INSERT INTO biv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ka a Yesu 'yɛr kʊ ba, “Ala ɩ Nãaŋmɩn lɛ ta ɩ a yɩ Sãa, yɩn taa nʊ̃ ma naa. Nãaŋmɩn sɛ̃ lɛ n yi naa be be ka a pʊ̃pãanyã. N ba waan a n mãɛ yuor ɛ, 'lɔ lɛ tʊ̃ ma. ");
INSERT INTO biv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bo lɛ so ka a lɛ ɩn 'yɛr ba chaar kʊ yɩ ɛ? Bojũu yaa tʊ̃ɔ wõ a lɛ ɩn 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","A yɩ sãa ɩn tɩɩ, a yɩ bʊɔrɔ ɩka yɩ maal a lɛ wʊn bʊɔrɔ. An yi a pielfʊ jaa nɩkʊrɔ lɛ wʊ ɩ, waa tara yelmãɛ ɛ, yelmãɛ bãlãa jaa ba be a wʊ 'yɔ̃ɔ ɛ. 'Lɔ wa ŋmaara a jire, lɛ wʊ be, jir ŋmara lɛ wʊ ɩ, na wʊ ɩ a jie a jaa sãa. ");
INSERT INTO biv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Tɩchɛ maa na 'yɛrɛ a yelmãɛ yaa sɔɔ de ma ɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","A yɩ ãsʊɔ na 'yɛr ɩka wʊ nyɛn ɩn maal dɛɛr ɔ? Ala ɩ yelmãɛ lɛ n 'yɛrɛ, bo lɛ so ka yaa sɔɔ de ma ɛ? ");
INSERT INTO biv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nɩrɛ 'lɔ na ɩ Nãaŋmɩn tʊɔr wõnõ naa a lɛ wʊn 'yɛrɛ. Yɩn ba ɩ a Nãaŋmɩn tʊɔr ɛ, yaa wõnõ a lɛ wʊn 'yɛrɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ka a Juu nɩbɛ 'yɛr, “Yelmãɛ lɛ sɩ 'yɛrɛ ɩka Samariya lɛ fʊ yi na fʊ tara a sɩdɛɛr.” ");
INSERT INTO biv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","A Yesu 'yɛr, “Maa ba sɩdɛɛr ɛ, tɩchɛ n 'yɔ̃ɔnɔ̃ naa a n Sãa, tɩ yɩn ba 'yɔ̃ɔnɔ̃ ma ɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","N ba bʊɔrɔ tɩɩr kʊrɔ a n mãɛ ɛ, tɩchɛ nɩrɛ kɔ̃ɔ bʊɔrɔ naa a lɛ. 'Lɔ Lɛ ɩ a 'yɛr tɔɔrɔ. ");
INSERT INTO biv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, ala ɩ nɩrɛ turo naa maa 'yɛr, wʊ kʊ̃ lɛ bɔ̃ɔ kũu ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","A anyãna lɛ ka a Juu nɩbɛ pãa 'yɛrɛ, “Pʊ̃pãanyã, sɩ bɔ̃ɔn naa fʊn tara a sɩdɛɛr. Abraham kpi naa, ka a Nãaŋmɩn 'yɛ'yɛrbɛ kpi, tɩchɛ ka fʊ 'yɛr ɩka ala ɩ nɩrɛ turo naa a fʊ 'yɛr wʊ kʊ̃ bɔ̃ɔ kũu ɛ. ");
INSERT INTO biv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Fʊ̃ʊ bɛrma gar a sɩ sãa Abraham bɩɩ? Wʊ kpi naa, ka a Nãaŋmɩn 'yɛ'yɛrbɛ mɩ kpi. An fʊ tɩɛr ɩka fʊ pãa ɩ naa?” ");
INSERT INTO biv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ka a Yesu 'yɛr, “Ala ɩ n ben 'yɔ̃ɔnɔ̃ a n mãɛ tɩɩr, a n tɩɩr na ɩn pɔrɔ. A n Sãa 'lɔ yɩn 'yɛrɛ ɩka a yɩ Nãaŋmɩn lɛ, 'lɔ lɛ kʊrɔ ma a tɩɩr. ");
INSERT INTO biv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yɩn ba bɔ̃ɔ wʊ gba ɛ, maa bɔ̃ɔ wʊ naa. Ala ɩ n 'yɛr naa ɩka n ba bɔ̃ɔ wʊ ɛ, ɩn ɩ naa jir ŋmara a yɩ kaar. Tɩchɛ maa bɔ̃ɔ wʊ naa, naa turo a wʊ 'yɛr bie. ");
INSERT INTO biv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","A yɩ sãa Abraham dɔ̃ɔ chɩlɛ tɩɛr ɩka wʊn taa nyɛ naa a n bɩbir. Wʊ nyɛn ka nʊ̃ɔ nyɔɔ wʊ.” ");
INSERT INTO biv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ka a Juu nɩbɛ sʊʊr wʊ, “Faa ta yuom lɩjaayi nɩ pie (50) sɛrɛ ɛ, tɩ na fʊ nyɛ Abraham?” ");
INSERT INTO biv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ka a Yesu 'yɛr, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, sɛrɛ tɩ ba wa dɔɔ Abraham, ka maa dɔ̃ɔ be be.” ");
INSERT INTO biv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","A nyãna, ka ba wob kʊsɩbɛ ɩka ba lɔb wʊ kʊ, tɩchɛ ka a Yesu sɔɔl fʊɔl na wʊ yi a be a ba puorfʊ yir pɔ. ");
INSERT INTO biv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu na chiine a lɛ, wʊ nyɛn daba ban dɔɔ ka wʊ ɩ jɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ka a poturbo sʊʊr wʊ, “Wiwile, an lɛ maal dɛɛr, a dajɔ̃ɔ bɩɩ a wʊ sãa naa ma lɛ maal dɛɛr, a dajɔ̃ɔ bɩɩ a wʊ sãa naa ma lɛ maal a dɛɛr dɔɔn wʊ, ka wʊ ɩ a jɔ̃ɔ?” ");
INSERT INTO biv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","A Yesu 'yɛr kʊ ba, “A daba nyã ba maal dɛɛr ɛ, a wʊ sãa naa ma mɩ ba maal dɛɛr ɛ, tɩchɛ a ɩn a lɛ ka Nãaŋmɩn tʊ̃mɔ̃ na tʊ̃ a wʊ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","An chɛnɛ ɩ mɔ̃tɔ̃ɔ, sɩn tʊ̃ naa a 'lɔ na tʊ̃ ma tʊ̃mɔ̃. Wɛr na sɔb naa ka nɩrɛ kʊ̃ lɛ tʊ̃ɔ tʊ̃mɔ̃ tʊ̃ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ɩn chɛnɛ be a wɛr pɔ, maa lɛ a wɛr chãa.” ");
INSERT INTO biv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wʊn wa 'yɛr a lɛ baar, wʊ chir nataar bun tãn a tẽe na wʊ bɛ a daba nɩbie. ");
INSERT INTO biv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tɩ na wʊ 'yɛr kʊ a daba, “Chen, tɩ pɛɛ a Siloam kʊ̃ɔ pɔ.” A Siloam par lɛ, Tʊ̃fʊ. Wʊ chen tɩ pɛɛ nyɛrɛ wa a yir. ");
INSERT INTO biv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ka a nɩbɔ̃ɔnsɩ bala na dɔ̃ɔ ma nyɛ wʊ na sʊɔrɔ, ka ba sʊrɔ taa, “A ba ɩ a daba nyãna lɛ ma sʊɔrɔ ɛ?” ");
INSERT INTO biv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bamɩne 'yɛr ɩka 'lɔ lɛ, ka bamɩne mɩ 'yɛr, “Nɩnyɛtaa lɛ.” Tɩchɛ ka wʊ 'yɛr, “Maa lɛ.” ");
INSERT INTO biv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ka ba sʊʊr wʊ, “Ŋmɩnɛ a nɩbie ɩrɛ wa yuo fʊ?” ");
INSERT INTO biv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ka a daba 'yɛr kʊ ba. “Daba ban bʊɔlɔ Yesu lɛ bu tãn bɛ ma a nɩbie tɩ 'yɛr ma ɩka n chen a Siloam tɩ pɛɛ. Lɛ lɛ n chen tɩ pɛɛ naa nyɛrɛ.” ");
INSERT INTO biv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ka ba sʊʊr wʊ, “Nyɩnɛ lɛ wʊ be?” Ka wʊ 'yɛr, “N ba bɔ̃ɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Be lɛ ba tara a daba 'lɔ na dɔ̃ɔ ɩ a jɔ̃ɔ chiin a Faraseemɩne sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","A bɩbir 'lɔ a Yesu na dɔ̃ɔ bu a tãn na wʊ yuon a daba nɩbie ɩn a Pɛ̃nfʊ Bɩbir Daar. ");
INSERT INTO biv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ka Faraseemɩne sʊʊr a daba lɛ wʊn ɩrɛ wa nyɛrɛ. Ka wʊ 'yɛr, “Tãn lɛ wʊ bɛ ma a nɩbie ka n pɛɛ be nyɛrɛ.” ");
INSERT INTO biv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ka a Faraseemɩne bamɩne 'yɛr, “A daba nyã ba yi Nãaŋmɩn sɛ̃ ɛ, waa sɔ̃nɔ̃ a Pɛ̃nfʊ Bɩbir ɛ.” Tɩchɛ ka a bamɩne mɩ sʊʊr, “Ŋmɩnɛ lɛ yelbe-ɩrɛ na tʊ̃ɔ tʊ̃ a nɛ'maa yele nyã?” Na ba ŋma jiir ayi. ");
INSERT INTO biv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ka ba lɩɛb sʊʊr a daba, “Bo fʊ tara na 'yɛr a wʊ 'yɛr? Fʊ nɩbie ba lɛ wʊ yuo.” Ka a daba 'yɛr, “Nãaŋmɩn 'yɛ'yɛrɛ lɛ wʊ ɩ.” ");
INSERT INTO biv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ka a Juu nɩbɛrɛ ba sɔɔ de ɛ ɩka a daba dɔ̃ɔ jɔ̃ɔ tɩ wa nyɛrɛ ɛ, ka ba bʊɔl a sãa naa ma. ");
INSERT INTO biv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ba sʊʊr ba naa, “A yɩ bie lɛ a nyã ɔ? A nyã lɛ yɩ dɔɔ ka wʊ ɩ a jɔ̃ɔ? Ka ŋmɩnɛ wʊ ɩrɛ wa nyɛrɛ?” ");
INSERT INTO biv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ka a sãa naa ma 'yɛr, “Sɩ bɔ̃ɔn naa ɩka sɩ bie lɛ, a sɩ dɔɔ wʊ ka wʊ ɩ jɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tɩchɛ lɛ wʊn ɩrɛ wa nyɛrɛ a pʊ̃pãanyã saa bɔ̃ɔ ɛ, bɩɩ nɩrɛ 'lɔ na yuo wʊ a nɩbie saa bɔ̃ɔ ɛ. Waa ɩ bibile ɛ, yɩ sʊʊr wʊ, wʊn 'yɛr kʊ wʊ mãɛ.” ");
INSERT INTO biv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A sãa naa ma 'yɛr naa nɩtɔ̃ bojũu ba joro naa a Juu nɩbɛ dãbãɛ, ba den nie 'yɛr ɩka nɩrɛ jaa wa 'yɛr ɩka a Yesu lɛ a Nɩ-iraa 'lɔ, ka ban dii wʊn bar a ba lɔ̃ɔfʊ jie. ");
INSERT INTO biv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ala lɛ so ka a sãa naa ma 'yɛr, “Waa ɩ bibile ɛ, yɩ sʊʊr wʊ.” ");
INSERT INTO biv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","A Faraseemɩne lɛ bʊɔl naa a daba 'lɔ na dɔ̃ɔ ɩ a jɔ̃ɔ a gbɛɛ ayi sʊɔ 'yɛr wʊ, “'Yɛr yelmãɛ kʊ Nãaŋmɩn, sɩn bɔ̃ɔn naa a daba nyã na ɩ yelbe-ɩrɛ.” ");
INSERT INTO biv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ka a daba 'yɛr, “Ala ɩ wʊ ɩn yelbe-ɩrɛ bɩɩ waa ɩ ɛ, n ba bɔ̃ɔ ɛ, yelbʊ̃'yen ɩn bɔ̃ɔ nɩ nyã. N dɔ̃ɔ ɩ jɔ̃ɔ tɩchɛ pʊ̃pãanyã, n nyɛrɛ naa.” ");
INSERT INTO biv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Be lɛ ba sʊʊr wʊ, “Bo lɛ wʊ ɩ fʊ? Ŋmɩnɛ lɛ wʊ ɩ yuo fʊ a nɩbie?” ");
INSERT INTO biv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ka a daba 'yɛr, “N ba dɔ̃ɔ 'yɛr tɩ yaa chɛlɛ ɛ. Bo yɩ bʊɔrɔ ɩka yɩ lɛ wõ ka a ɩ go? Yɩ bʊɔrɔ naa ɩka yɩ mɩ lɩɛb a wʊ poturbo bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","A ba tʊrɔ wʊ 'yɛrɛ, “Fʊ̃ʊ lɛ ɩ a wʊ poturo, sɩn ɩ naa Mosesɩ poturbo. ");
INSERT INTO biv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sɩ bɔ̃ɔn na ɩka Nãaŋmɩn 'yɛr 'yɛr kʊ Mosesɩ, tɩchɛ a daba 'lɔ saa bɔ̃ɔ jie wʊn yi gba ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ka a daba 'yɛr, “A 'maa man nɛɛ yɩn ba bɔ̃ɔ jie wʊn yi ɛ, tɩ yuo ma a nɩbie. ");
INSERT INTO biv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Sɩ bɔ̃ɔ naa ɩka Nãaŋmɩn ba chɛlɛ a yelbe-ɩrbɛ ɛ. Wʊ ma chɛlɛ naa a bala na joro wʊ tɩ maala a lɛ wʊn bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nɩrɛ jaa ba dɔ̃ɔ wõ ɩka ba yuon nɩrɛ ban lɔ̃ɔ dɔɔn jɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ala ɩ a daba nyã ba ta yi Nãaŋmɩn sɛ̃ ɛ, wʊ kʊ̃ naa tʊ̃ɔ bon jaa maal ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ka a Juu nɩbɛrɛ 'yɛr kʊ a daba, “A fʊ̃ʊ, yelbier pɔ lɛ ba dɔɔ fʊ, ŋmɩnɛ fʊn ɩrɛ wa wiil sɩ,” tɩ dii wʊ bar a ba pɔ. ");
INSERT INTO biv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu na wõ ɩka ba dii naa a daba bar, wʊ bɔ wʊn wa nyɛ wʊ, na wʊ sʊʊr wʊ, “Fʊ sɔɔn de a Nɩsaal Bie ɔ?” ");
INSERT INTO biv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ka a daba sʊʊr wʊ, “Nɩkpɛ̃ɛ an lɛ, wiil ma ka n sɔɔ de wʊ.” ");
INSERT INTO biv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","A Yesu 'yɛr, “Fʊ nyɛ wʊ naa pʊ̃pãanyã, sɩrɛ jaa, 'lɔ lɛ 'yɛrɛ nɩ fʊ.” ");
INSERT INTO biv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ka a daba pãa 'yɛr, “N Soro n sɔɔn de,” tɩ gbur dumo puor wʊ. ");
INSERT INTO biv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Be lɛ a Yesu 'yɛr, “'Yɛr tɔɔrfʊ jie lɛ n wa ka a wɛr pɔ. Jɔ̃n na nyɛrɛ naa ka nɩbinyɛrɛ mɩ lɩɛb ɩ jɔ̃n.” ");
INSERT INTO biv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ka a Faraseemɩne bamɩne na be a wʊ sɛ̃ wõ a lɛ na ba sʊʊr, “Bo ya! A sɩn mɩ ɩn a jɔ̃n ɔ?” ");
INSERT INTO biv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","A Yesu 'yɛr ba, “Ala ɩ yɩ ta ɩn jɔ̃n, yɩ kʊ naa tara chɛfʊ a dɛɛr pɔ ɛ. Tɩchɛ, yɩn ben 'yɛr ɩka yɩ nyɛrɛ naa, yɩ chɛnɛ na be a yɩ dɛɛr pɔ.” ");
INSERT INTO biv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ka a Yesu 'yɛr, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, nɩrɛ 'lɔ jaa na maa tu a piir jɔɔ dɔ̃dɔr nɛɛ tɩ do a dachin kpɛ, ɩn nãnyie nɩ nɩfara. ");
INSERT INTO biv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nɩrɛ 'lɔ na tu a dɔ̃dɔr nɛɛ kpɛ 'lɔ lɛ ɩ a pɛchinɛ. ");
INSERT INTO biv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A dɔ̃dɔ̃guro ma yuon a pãn kʊ a pɛchinɛ, ka a piir chɛlɛ a wʊ kɔkɔr. Wʊ maa bʊɔl naa a wʊ piir yoe, na wʊ ŋmaa ba yin. ");
INSERT INTO biv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","'Lɔ wa ŋmaa a wʊ piir a jaa ka a yi, wʊ ma den nie ka a turo wʊ, bojũu ba bɔ̃ɔ naa a wʊ kɔkɔr. ");
INSERT INTO biv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tɩchɛ ba kʊ̃ wa tu sãan jaa ɛ, ban jon yi a wʊ sɛ̃ bojũu baa bɔ̃ɔ sãan kɔkɔr ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu lɔb a sʊkpa nyã tɩchɛ baa bɔ̃ɔ a par a lɛ wʊn 'yɛrɛ ba ɛ. ");
INSERT INTO biv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","A lɛ jũu lɛ a Yesu 'yɛr ba go, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, maa lɛ a piir dɔ̃dɔr nɛɛ. ");
INSERT INTO biv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","A bala ba jaa na dɔ̃ɔ ma nie wa ɩn nãnyisɩ nɩ nɩfarba, tɩchɛ a piir ba chɛlɛ ba ɛ. ");
INSERT INTO biv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Maa lɛ a dɔ̃dɔr, nɩrɛ jaa na tu ma kpɛ, wʊn nyɛn faafʊ. Wʊn ma kpɛ̃n tɩ yi na wʊ nyɛrɛ bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nãnyie ma wa naa ɩka wʊ wa ju, na wʊ kʊ, tɩ sɔ̃ɔ bar. Maa wa naa ka ban nyɛ nyɛvʊr, na ba nyɛ wʊ tɩ põn bar. ");
INSERT INTO biv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Maa lɛ a pɛchiin sʊ̃, a pɛchiin sʊ̃ sɔɔn kpi a wʊ piir 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","A pɛchinɛ 'lɔ ban yara, waa so a piir ɛ. 'Lɔ wa nyɛ gbõgboro na waara, wʊ ma tɛɛn a piir bar tɩ jo, ka a gbõgboro yɛ̃yɛl a piir tɩ nyɔɔr amɩne. ");
INSERT INTO biv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wʊ ma jon a lɛ an ɩ libie tʊ̃mɔ̃ lɛ wʊ tʊ̃nɔ̃, a piir yele ba bã wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Maa ɩ naa a pɛchiin sʊ̃, n bɔ̃ɔ naa a n piir, ka n piir mɩ bɔ̃ɔ ma. ");
INSERT INTO biv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nɩtãa lɛ a Sãa na bɔ̃ɔ ma ka n mɩ bɔ̃ɔ a Sãa, ɩn sɔɔn kpi a piir 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","N tara na piir amɩne na ba be a jɔɔ nyã pɔ ɛ, ɩn waan ba naa, ka ba mɩ wa chɛlɛ a n kɔkɔr, ka ba ɩ pɛgbul bʊ̃'yen na ba tara pɛchiin bʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","A n Sãa na nʊ̃ ma par nɩ nyã, n sɔɔ naa na kpi tɩ lɛ ir ɩ vʊr go. ");
INSERT INTO biv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nɩrɛ baa faara wʊ ɛ, tɩchɛ maa mãɛ lɛ sɔɔ na kpi. N tara na kpɛ̃ɔ na bar a nyɛvʊr naa lɛ tara kpɛ̃ɔ na de wʊ go. A nyã lɛ a n Sãa 'yɛr ma ɩka n ɩ.” ");
INSERT INTO biv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","A 'yɛr nyã lɛ vɛ̃ ka a Juu nɩbɛ ŋma dẽ dẽ. ");
INSERT INTO biv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ka a ba yɔɔ 'yɛrɛ ɩka, “Sɩdɛɛr lɛ wʊ tara, na wʊ gele, bo 'yɔ̃ɔ yɩ chɛlɛ a lɛ wʊn 'yɛrɛ?” ");
INSERT INTO biv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tɩchɛ ka a bamɩne 'yɛrɛ, “A nyãna ba ɩ nɩrɛ na tara sɩdɛɛr 'yɛr ɛ, a sɩdɛɛr na tʊ̃ɔn yuo jɔ̃ɔ nɩbie ɔ?” ");
INSERT INTO biv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","A ɩ naa uon ka ba maala a ba puorfʊ yir Pɔlfʊ lɔ̃ɔ di be a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ka Yesu be be a Nãaŋmɩn puorfʊ yir bɛchaar ãsʊɔ pɔ, na wʊ yʊɔrɔ a be ban bʊɔlɔ a Solomon Jɛ̃bɛr. ");
INSERT INTO biv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Be a Juu nɩbɛrɛ bamɩne ŋmaa jilʊ̃ wʊ sʊrɔ, “A baalfʊ nyã fʊn 'yɔ̃ɔ sɩ, dabor an wa baar? Ala ɩ fʊ̃ʊ lɛ ɩ a Nɩ-iraa 'lɔ, 'yɛr kʊ sɩ chãa pɔ.” ");
INSERT INTO biv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ka a Yesu 'yɛr, “N dɔ̃ɔ 'yɛr yɩ, yɩn lɛ ba sɔɔ de ɛ. A nɛ'maa tʊ̃mɔ̃ ɩn tʊ̃ nɩ a n Sãa yuor, 'yɛr naa n 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tɩchɛ yɩn lɛ ba sɔɔ de ɛ, bojũu yaa ɩ a n piir ɛ. ");
INSERT INTO biv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","A n piir ma chɛlɛ naa a n kɔkɔr, n bɔ̃ɔ ba naa ka ba ma turo ma. ");
INSERT INTO biv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","N kʊ ban nyɛvʊr na ba tara baarfʊ ɛ. Ba kʊ̃ wɛ ɛ, nɩrɛ jaa kʊ̃ tʊ̃ɔ ba 'loo faa a n nũu pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","A n Sãa 'lɔ na de ba kʊ ma, wʊ gar bomo a jaa. Nɩrɛ jaa kʊ̃ tʊ̃ɔ ba 'loo faa a n Sãa nũu pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Maa naa n Sãa jaa ɩn bʊ̃'yen.” ");
INSERT INTO biv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ka a Juu nɩbɛrɛ wob kʊsɩbɛ ɩka ba lɔb wʊ go. ");
INSERT INTO biv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tɩchɛ ka a Yesu sʊʊr ba, “N tʊ̃n nɛ'maa tʊ̃yɔɔ yi a Sãa sɛ̃, buor sʊɔ 'yɔ̃ɔ yɩ pãa be lɔɔrɔ ma?” ");
INSERT INTO biv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ka ba 'yɛr, “Saa lɔɔrɔ fʊ a anyã ãsʊɔ jaa 'yɔ̃ɔ ɛ, tɩ fʊn fere sɔ̃ɔnɔ̃ a Nãaŋmɩn yuor, tɩ mɩ ɩ nɩsaal.” ");
INSERT INTO biv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","A Yesu 'yɛr ba, “A ba sɛb a yɩ Nɛɛ pɔ ɩka, ‘N 'yɛr naa ɩka, yɩ ɩn ŋmɩmɛ ɛ?’ ");
INSERT INTO biv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ala ɩ Nãaŋmɩn bʊɔl naa a bala a wʊ 'yɛr, na wa a ba sɛ̃, ŋmɩmɛ, Nãaŋmɩn sɛɛr ba be na wa sɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ŋmɩnɛ lɛ a 'lɔ a Sãa na kaa ir a wʊ bɔfʊ pɔ, na wʊ tʊ̃ ka a wɛr pɔ. Bo lɛ so ka yaa bara ma ɛ, bojũu n 'yɛr ɩka Nãaŋmɩn Bie lɛ n ɩ? ");
INSERT INTO biv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yɩ taa sɔɔ de ma ɛ, ala ɩ n ba maala a lɛ a Sãa na maala ɛ. ");
INSERT INTO biv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tɩchɛ ala ɩ n tʊ̃ naa, yɩn gba ba sɔɔ de ma ɛ, yɩ sɔɔ de a nɛ'maa tʊ̃mɔ̃, yɩn bɔ̃ɔn a par ɩka a Sãa ben a n 'yɔ̃ɔ ka n mɩ be a Sãa 'yɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ka ba lɛ bʊɔrɔ a wʊ nyɔɔfʊ go, tɩ chɛ ka wʊ fʊɔl yi. ");
INSERT INTO biv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Be lɛ a Yesu lɩɛb gɔ̃ɔ a Jordan man gɔ̃ɔn, a jie 'lɔ a Jɔɔn na dɔ̃ɔ suoro a nɩbɛ a Nãaŋmɩn kʊ̃ɔ na wʊ jɛ̃ a be, ");
INSERT INTO biv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ka nɩyɔɔ wa a wʊ sɛ̃ wa 'yɛrɛ, “Jɔɔn gba ba dɔ̃ɔ tʊ̃ nɛ 'maa tʊ̃mɔ̃ ɛ, a ala a jaa wʊn 'yɛr a daba nyã 'yɛr, ɩn yelmãɛ.” ");
INSERT INTO biv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Be lɛ a nɩyɔɔ sɔɔ de wʊ. ");
INSERT INTO biv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Daba ban bʊɔlɔ Lajarusɩ dɔ̃ɔ bɩɛrɛ, wʊ ɩn Mɛɛr nɩ Mata yɛdaba na ba kpɩɛrɛ a Betanɩ tẽe pɔ. ");
INSERT INTO biv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","A Mɛɛr nyã na dɔ̃ɔ kpaar a kãnyũu 'yɔ̃ɔ a Yesu tɩ de a wʊ jukɔɔl fɩɛl, a wʊ yɛdaba Lajarusɩ lɛ a nyã na bɩɛrɛ. ");
INSERT INTO biv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ka a yɛpɔbɔ tʊ̃ 'yɛr a Yesu, “Sɩ Soro, a fʊ baraa bɩɛrɛ naa.” ");
INSERT INTO biv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu na wõ a lɛ, a wʊ 'yɛr, “A baal nyã ba ɩ kũu baal ɛ, tɩ an wiil Nãaŋmɩn tɩɩr tɩ mɩ vɛ̃ ka Nãaŋmɩn Bie yuor yi.” ");
INSERT INTO biv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu nʊ̃n Mata nɩ a wʊ yɛbɛ nɩ a ba yɛdaba Lajarusɩ. ");
INSERT INTO biv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tɩchɛ wʊn wõ a Lajarusɩ baal tɩ na wʊ chɛnɛ jãnɛ a be wʊn be ber ayi. ");
INSERT INTO biv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tɩ pãa 'yɛr kʊ a wʊ poturbo, “Yɩ ɩ a sɩ lɩɛb chen a Judiya.” ");
INSERT INTO biv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tɩchɛ ka a poturbo 'yɛr, “Wiwile, daar yɛ̃ yɛ̃ nyãna ba lɛ a Juu nɩbɛrɛ ta bʊɔrɔ ɩka ba lɔb fʊ ɛ, tɩchɛ a fʊ lɛ chiine a be go?” ");
INSERT INTO biv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ka a Yesu 'yɛr kʊ ba, “A ba ɩ a bɩbir tara na a wʊ mɔ̃tɔ̃ɔ chaarfʊ sɔ̃ɔ ɛ? Nɩrɛ wa chiine a mɔ̃tɔ̃ɔ wʊ maa ŋme gbɛr ɛ, wʊ nyɛ naa a mɔ̃tɔ̃ɔ chãa. ");
INSERT INTO biv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bojũu ala ɩ tãsɔɔ lɛ wʊ chiine, wʊn ŋmen gbɛr, bojũu waa tara chãa ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Wʊn wa 'yɛr a lɛ baar, wʊ 'yɛr kʊ ba, “A sɩ baraa Lajarusɩ gur naa, tɩchɛ ɩn chen tɩ sãɩ wʊ.” ");
INSERT INTO biv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ka a wʊ poturbo 'yɛr, “Sɩ Soro, ala ɩ wʊ gur naa, wʊn ir naa.” ");
INSERT INTO biv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu 'lɔ 'yɛr naa ɩka wʊ kpi naa, tɩchɛ ka a poturbo 'lɔ tɩɛr ɩka a gʊ̃ɔ sʊ̃ɔ lɛ wʊ 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ala lɛ so a Yesu pãa 'yɛr ka a chaar ɩka, “Lajarusɩ kpi naa. ");
INSERT INTO biv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","A yɩ jũu, a nʊ̃mɔ̃ ma naa ɩn ba be be ɛ, ka yɩ na sɔɔ de ma. Tɩchɛ, yɩ ɩ a sɩ chen a wʊ sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","A wʊ poturo ãsʊɔ ban bʊɔlɔ Tomasɩ na ba lɛ bʊɔlɔ wʊ Naa 'yɛr kʊ a bala na chɛ, “Yɩ ɩ a sɩ 'mataa chiin wʊ mɩ tɩ kpi.” ");
INSERT INTO biv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu na wa ta a be, wʊ nyɛn ka a ɩ ba ũu naa Lajarusɩ maal ber anaar. ");
INSERT INTO biv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanɩ nɩ a Jerusalɛm mɩ ba jãa ɛ. ");
INSERT INTO biv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ka a Juu nɩbɛ yɔɔ chen ɩka ba tɩ puor a Mata nɩ a Mɛɛr a ba yɛdaba kuor. ");
INSERT INTO biv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata na wa wõ ɩka Yesu waara naa, wʊ yin tɩ tuor wʊ, tɩchɛ kaa Mɛɛr 'lɔ jãnɛ a yir. ");
INSERT INTO biv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Be lɛ a Mata 'yɛr kʊ a Yesu, “N Soro, fʊ̃ʊ ta dɔ̃ɔ be ka, a n yɛdaba kʊ̃ naa kpi ɛ. ");
INSERT INTO biv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tɩchɛ n bɔ̃ɔ naa pʊ̃pãanyã gba ɩka, bon jaa fʊn sʊɔr a Nãaŋmɩn sɛ̃, wʊn kʊ fʊ naa.” ");
INSERT INTO biv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","A Yesu 'yɛr kʊ wʊ, “A fʊ yɛdaba na ir naa a kũu pɔ ɩ vʊr.” ");
INSERT INTO biv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Be lɛ a Mata 'yɛr kʊ a Yesu, “N bɔ̃ɔn na wʊn na ir a kũn irfʊ daar, a ber baaraa sɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","A Yesu 'yɛr kʊ wʊ, “Maa lɛ ɩ a kũu pɔ irfʊ, nɩ nyɛvʊr, nɩrɛ 'lɔ na sɔɔ de ma, 'lɔ kpi gba, tɩ wʊn tara na nyɛvʊr. ");
INSERT INTO biv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nɩrɛ 'lɔ na ba kpi ɛ, tɩ na wʊ sɔɔ de ma, kʊ̃ lɛ kpi ɛ, fʊ sɔɔ naa a lɛ ɔ?” ");
INSERT INTO biv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ka a Mata 'yɛr, “Ɔ̃ɔ, n Soro, n sɔɔn de ɩka fʊ̃ʊ lɛ ɩ a Nɩ-iraa na ɩ Nãaŋmɩn Bie, 'lɔn na wa ka a wɛr pɔ.” ");
INSERT INTO biv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Wʊn wa 'yɛr a lɛ baar wʊ lɩɛb kul tɩ bʊl 'yɛr kʊ a yɛbile Mɛɛr, “A wiwile ben ka tɩ sʊrɔ fʊ.” ");
INSERT INTO biv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","A Mɛɛr na wa wõ a lɛ, ka wʊ vaa ir chen a Yesu sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu ba kpɛ a tẽe pɔ sɛrɛ ɛ, tɩ chɛnɛ ara a be a Mata na tuor wʊ. ");
INSERT INTO biv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","A Juu nɩbɛ bala na wa a kuor puorfʊ jie be a Mɛɛr sɛ̃ a yir, na nyɛ a lɛ wʊn vaa ir yire, ka ba turo wʊ tɩɛr ɩka a yaa par lɛ wʊ chiine a kõn jie. ");
INSERT INTO biv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mɛɛr na tɩ ta a jie nyɛ a Yesu a be, wʊ gbur dumo a Yesu niem tɩ 'yɛr, “N Soro, fʊ̃ʊ ta dɔ̃ɔ be ka, a n yɛdaba kʊ̃ naa kpi ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu na nyɛ a lɛ wʊn kõnõ ka a Juu nɩbɛ bala na bɩɛl wʊ mɩ kõnõ, nɩbaal kpɛ wʊ naa ka a suur nyɔɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","A wʊ sʊʊr ba, “Nyɩnɛ yɩ ũu wʊ?” Ka ba 'yɛr, “N Soro, wa nyɛ a jie.” ");
INSERT INTO biv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ka Yesu kõ. ");
INSERT INTO biv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ka a Juu nɩbɛ pãa 'yɛrɛ kʊrɔ taa, “Nyɛ lɛ wʊn nʊ̃ a Lajarusɩ.” ");
INSERT INTO biv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tɩchɛ ka bamɩne pãa 'yɛr, “Wʊn dɔ̃ɔ yuo a jɔ̃ɔ nɩbie, kaa ɩ wʊ kʊ̃ naa tʊ̃ɔ vɛ̃ ka a Lajarusɩ ta kpi bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ka nɩbaal kpɛ a Yesu, ka wʊ tɔɔ ta a yaa par. Kʊsɩr bɔɔ lɛ, ka ba 'mɔɔ a kʊsɩr ãsʊɔ pɔɔ a nɛɛ. ");
INSERT INTO biv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","A Yesu 'yɛr, “Yɩ bil a kʊsɩr bar.” Tɩchɛ a Mata an ɩ a wʊ yɛdaba lɛ kpi, ka wʊ 'yɛr, “N Soro, wʊn nyuro naa, ber anaar nɩ dɩna ban ũu wʊ.” ");
INSERT INTO biv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ka Yesu 'yɛr, “N ba 'yɛr fʊ ɩka fʊ̃ʊ sɔɔ de, fʊn nyɛn Nãaŋmɩn tɩɩr ɛ?” ");
INSERT INTO biv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Be lɛ ba bil a kʊsɩr bar, a Yesu kaa saaju tɩ 'yɛr, “N Sãa, fʊ son puorfʊ, fʊn wõ a n sʊɔrfʊ. ");
INSERT INTO biv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","N bɔ̃ɔn naa fʊn wõnõ a n sʊɔrfʊ, tɩchɛ n 'yɛr naa ka a na sʊ̃ʊ a nɩbɛ banyãna na ara a ka, a ba sɔɔ de ɩka, fʊ̃ʊ lɛ tʊ̃ ma.” ");
INSERT INTO biv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu na 'yɛr a nɩtɔ̃ wʊ bʊɔl kpɛ̃ɔ jaa, “Lajarusɩ, wa yi.” ");
INSERT INTO biv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ka a kũu yi, ka a gbɛɛ naa nuur ban vil a fɔpɩɛl pɔɔ ka a fɔbaa mɩ pɔɔ a ju. A Yesu 'yɛr kʊ ba, “Yɩ yaar a kũu fɔɔr bar wʊ ka wʊ chen.” ");
INSERT INTO biv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ala lɛ so ka a Juu nɩbɛ bala na wa ɩka ba wa puor a Mɛɛr, nyɛn a lɛ a Yesu na ɩ, a ba sɔɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tɩchɛ ka a bamɩne chen a Faraseemɩne sɛ̃ tɩ man a lɛ a Yesu na maal. ");
INSERT INTO biv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Be lɛ a Faraseemɩne nɩ a bɔɔrlo nɩbɛrɛ bʊɔl taa lɔ̃ɔfʊ na ba 'yɛr, “Ŋmɩnɛ sɩn ɩ, a daba nyã na ben tʊ̃nɔ̃ a nɛ'maa tʊ̃mɔ̃ a nɩtɔ̃? ");
INSERT INTO biv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ala ɩ sɩn be bar wʊ ka wʊ maala lɛ, nɩrɛ jaa na sɔɔn a wʊ yele, a Worom nɩbɛ wa wõ a yele ban wa wɛl sɩ naa a jisʊ̃ nɩ a tẽe bar.” ");
INSERT INTO biv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ka a ba ãsʊɔ ban bʊɔlɔ Kayafasɩ na ɩ a bɔɔrlo nɩkpɛ̃ɛ a yuon 'lɔ̃nɔ̃ 'yɛr, “Yaa tara tɩɛr jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yaa bɔ̃ɔ ɩka a sɛɛ naa ka nɩbʊ̃'yen na kpi kʊ a nɩyɔɔ gar a nɩyɔɔ ba jaa na wɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A nyã ba yi a wʊ mãɛ sɛ̃ ka wʊ 'yɛr ɛ, tɩchɛ wʊn ɩ a bɔɔrlo nɩkpɛ̃ɛ a yuon 'lɔ, ala lɛ wʊ de nie dɔ̃ɔ 'yɛr ɩka a Yesu na kpin kʊ a Juu nɩbʊrɔ ba jaa. ");
INSERT INTO biv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","A ba ɩ bala tɛɛ ɛ, tɩchɛ ka wʊ lɔ̃ɔ taa a Nãaŋmɩn bibiir bala na yɛ̃yɛl na wʊ maal ba a ba ɩ bʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","An yi a daar 'lɔ̃nɔ̃ ba bʊɔrɔ na sɔr na kʊ a Yesu. ");
INSERT INTO biv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","A lɛ juu Yesu ba lɛ yʊɔrɔ chãa pɔ a Juu nɩbɛ jie ɛ, tɩ chen jiyuo na gbʊr a mɔgɔ̃ɔ na wʊ tɩ kpɩɛrɛ a tẽbile ban bʊɔlɔ Eferɛm, be lɛ wʊ tɩ 'mataa jɛ̃n a wʊ poturbo. ");
INSERT INTO biv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A Juu nɩbɛ Gõl Bar Difʊ gbʊr naa, ka ba yɔɔ yi a tẽbil do a Jerusalɛm tɩ pɔlɔ a ba mãɛ chɛlɛ nɩ a bɩbir. ");
INSERT INTO biv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ba kaara na bʊɔrɔ a Yesu a be a Nãaŋmɩn puorfʊ yir, sʊrɔ taa, “Ŋmɩnɛ yɩ tɩɛr, wʊn wa naa a lɔ̃ɔfʊ jie bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tɩchɛ ka a bɔɔrlo nɩbɛrɛ nɩ a Faraseemɩne 'yɛr, “Nɩrɛ jaa wa bɔ̃ɔ a jie a Yesu na be, wʊ 'yɛr ka ba tɩ nyɔɔ wʊ.” ");
INSERT INTO biv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","A chɛn ber ayʊɔb ka a Gõl Bar Difʊ bɩbir ta. Yesu chen a Betanɩ na ɩ a Lajarusɩ 'lɔ na kpi ka wʊ sãɩ kpɩɛrɛ. ");
INSERT INTO biv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ba maal bʊ̃diir kʊ wʊ a be, ka a Mata põnõ a bʊ̃diir. Lajarusɩ pʊɔ naa a nɩbɛ bala na lɔ̃ɔ jɛ̃n Yesu a bʊ̃diir jie. ");
INSERT INTO biv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Be lɛ Mɛɛr de kãnyũu vɩla daa na ɩ tuo wa pʊr 'yɔ̃ɔ a Yesu gbɛɛ pɔ, tɩ lɩɛb a jukɔɔl fɩɛlɛ nɩ ka a nyũu de a yir wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tɩchɛ a wʊ poturo ãsʊɔ ban bʊɔlɔ Judas na yi a Isɩkariyot, 'lɔ lɛ na wa gar 'yɔ̃ɔ a Yesu sʊʊr, ");
INSERT INTO biv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bo lɛ so ka baa da a kãnyũu nyãna ɛ, a libie na tãn nɩrɛ yuon gbul sãyar na ba de kʊ nɔ̃n dẽme ɛ?” ");
INSERT INTO biv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A nɔ̃n dẽme yele ba bã wʊ ɛ, bojũu nãnyie lɛ wʊ ɩ an ɩ 'lɔ lɛ tara a ba libie wʊɔ, na wʊ ma juro a ala ban 'yɔ̃ɔ a be sʊ̃nɔ̃ nɩ wʊ mãɛ. ");
INSERT INTO biv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","A Yesu 'yɛr, “Bar a pɔɔ jaa jomm, wʊ bin a kãnyũu nyãna gun a n ũufʊ bɩbir. ");
INSERT INTO biv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","A nɔ̃n dẽme na ben a yɩ sɛ̃ bɩbir jaa, tɩchɛ maa kʊ̃ be a yɩ sɛ̃ bɩbir jaa ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","A Juu yɔɔ jie na wõ ɩka Yesu be naa a Betanɩ, ba wa naa a ba ɩ a 'lɔ tɛɛ 'yɔ̃ɔ ɛ, tɩchɛ ba bʊɔrɔ na ɩka ba nyɛ a Lajarusɩ 'lɔ wʊn sãɩ a kũu pɔ, ka wʊ ir ɩ vʊr. ");
INSERT INTO biv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","A lɛ 'yɔ̃ɔ, a bɔɔrlo nɩbɛrɛ mɩ guoro nɩ taa ɩka ba mɩn kʊ naa a Lajarusɩ. ");
INSERT INTO biv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","A wʊ jũu lɛ a Juu nɩbɛ yɔɔ jie tɔr a ba nɩbɛrɛ wiilfʊ tɩ sɔɔrɔ a Yesu. ");
INSERT INTO biv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wɛr na wa chaar, a nɩyɔɔ bala na wa a Gõl Bar Difʊ jie, wõ naa ɩka Yesu ben a sɔr pɔ waara a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ba 'mɛl bɛ vaɩ yi tuoro nɩ wʊ pãa chɩlɛ gɔ̃nɔ̃, “Yãan yooo, Nãaŋmɩn wʊ sʊ̃ʊ a 'lɔ wʊn tʊ̃. Nãaŋmɩn wʊ sʊ̃ʊ a 'lɔ na ɩ a Isɩral nãa.” ");
INSERT INTO biv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu nyɛn a bʊ̃pɔl na wʊ do jãnɛ nɩtãa lɛ an sɛb a Nãaŋmɩn gãn pɔ, ");
INSERT INTO biv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“A yɩn Jerusalɛm nɩbɛ, yɩ ta joro dãbãɛ ɛ, Yɩ nyɛ a yɩ nãa na do bʊ̃pɔl waara nɩ.” ");
INSERT INTO biv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","A wʊ poturbo ba dɔ̃ɔ bɔ̃ɔ a anyãna a jaa par ɛ, tɩ a Yesu na wa ir ɩ vʊr, ba tɩɛr yuo ɩka anyãna lɛ ba dɔ̃ɔ sɛb a Nãaŋmɩn gãn pɔ a wʊ 'yɔ̃ɔ ka ba mɩ maal a lɛ kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A nɩyɔɔ bala na dɔ̃ɔ be a wʊ sɛ̃ na ba nyɛ a lɛ wʊn bʊɔl a Lajarusɩ ka wʊ yi a yaa pɔ ɩ vʊr, ba chɛnɛ na mana kʊrɔ a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ala lɛ so ka a nɩyɔɔ yi tuoro wʊ, bojũu ba wõ naa ɩka wʊ tʊ̃n nɛ'maa tʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Be lɛ ka a Faraseemɩne pãa 'yɛrɛ kʊrɔ taa, “Yɩ nyɛ, saa lɛ tʊɔrɔ bon jaa maala ɛ. Nyɛ, a nɩbɛ ba jaa ben turo wʊ.” ");
INSERT INTO biv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","A nɩbɛ bamɩne mɩ na ba ɩ a Juu nɩbɛ ɛ, pʊɔ naa bala na do a puorfʊ jie a Jerusalɛm a Gõl Bar Difʊ sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ba chen a Filip na yi a Betɩsaida na be a Galilee wɛr pɔ sɛ̃ tɩ 'yɛr, “Nɩkpɛ̃ɛ, sɩ bʊɔrɔ naa ɩka sɩ nyɛ a Yesu.” ");
INSERT INTO biv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip chen tɩ 'yɛr kʊ Andiru ka ba 'mataa chen tɩ 'yɛr a Yesu. ");
INSERT INTO biv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","A Yesu 'yɛr ba, “A sɔ̃ɔ ta naa ka Nãaŋmɩn na kʊ a Nɩsaal Bie tɩɩr. ");
INSERT INTO biv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, chibir baa ũu tẽe ɛ, wʊn chɛnɛ na ɩ a chibir bʊ̃'yen. Tɩchɛ 'lɔ wa lo tẽe kpi, wʊ ma dɔɔn chibiyɔɔ. ");
INSERT INTO biv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nɩrɛ 'lɔ na nʊ̃ a wʊ nyɛvʊr na bɔr wʊ naa, tɩchɛ 'lɔ na 'laar a wʊ nyɛvʊr a wɛr nyã pɔ, wʊn tara na a nyɛvʊr 'lɔ na ba tara baarfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ala ɩ ãsʊɔ jaa bʊɔrɔ naa ɩka wʊ sʊ̃ʊ ma tʊ̃, wʊ turo ma, jie jaa ɩn be a nɩrɛ 'lɔ na sʊ̃nɔ̃ ma tʊ̃nɔ̃ mɩ na ben be. Ka a n Sãa 'yɔ̃ɔnɔ̃ a 'lɔ na sʊ̃nɔ̃ ma tʊ̃nɔ̃. ");
INSERT INTO biv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Pʊ̃pãanyã, n pʊɔ sɔ̃ɔ naa, tɩ n 'yɛr bo? N 'yɛr ɩka a Sãa wʊ faa ma a sɔ̃ɔ nyãna pɔ bɩɩ? Kai, a sɔ̃ɔ nyãna 'yɔ̃ɔ lɛ n wa. ");
INSERT INTO biv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Sãa, kʊ a fʊ yuor tɩɩr.” Be lɛ a kɔkɔr pãa 'yɛr yi saaju, “N dɔ̃ɔ kʊ wʊ a tɩɩr, ɩn lɛ kʊ wʊ naa a tɩɩr go.” ");
INSERT INTO biv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ka a nɩyɔɔ bala na ara a be wõ naa na ba 'yɛr, saa lɛ tãna, ka bamɩne mɩ 'yɛr malaka ãsʊɔ lɛ 'yɛrɛ nɩ wʊ. ");
INSERT INTO biv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","A Yesu 'yɛr ba, “A ba ɩ maa 'yɔ̃ɔ lɛ a kɔkɔr 'yɛr ɛ, tɩ yɩn 'yɔ̃ɔ lɛ. ");
INSERT INTO biv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Pʊ̃pãanyã a sɔ̃ɔ ta naa ka a wɛr nyã 'yɛr na tɔɔr. Pʊ̃pãanyã, ban ir naa wɛr nyã nãa Satan bar. ");
INSERT INTO biv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tɩchɛ maa, bala wa 'mɔɔ ma a saaju, ɩn tɔɔn nɩbɛ ba jaa waan a n sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wʊ 'yɛr a lɛ na wʊ wiil kũu 'lɔ tɔ wʊn na kpi. ");
INSERT INTO biv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ka a nɩyɔɔ bala 'yɛr, “Sɩ wõn yi a Nɛɛ pɔ ɩka, a Nɩ-iraa naa 'lɔ na ben be kpo kpo, tɩ ŋmɩnɛ a ɩ a fʊ 'yɛr ɩka ban 'mɔɔn a Nɩsaal Bie a saaju? An lɛ a Nɩsaal Bie 'lɔ?” ");
INSERT INTO biv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","A Yesu pãa 'yɛr ba, “Ber bãlãa lɛ a chãa na be a yɩ sɛ̃, yɩ chiine a chãa pɔ wʊn chɛnɛ be be ka a libe taa pɔɔ yɩ ɛ. Nɩrɛ na be libe pɔ ba bɔ̃ɔ a jie wʊn chiine ɛ. ");
INSERT INTO biv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yɩ sɔɔ de a chãa, yɩn chɛnɛ tara wʊ na yɩ tʊ̃ɔ ɩ a chãa bibiir.” Yesu na wa 'yɛr a lɛ baar, wʊ yin chen a baa nyɛ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu gba, wʊn tʊ̃ a nɛ'maa tʊ̃mɔ̃ a ba sɛ̃, tɩ baa chɛnɛ sɔɔ de wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ka a Isaiya 'yɛr ɩ yelmãɛ. Lɛ wʊn 'yɛr a kõr jaa, “Sɩ Soro an lɛ sɔɔ de a sɩ 'yɛr, an lɛ a Soro mɩ wiil a wʊ kpɛ̃ɔ?” ");
INSERT INTO biv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ban ba tʊɔrɔ sɔɔrɔ ɛ, bojũu a Isaiya 'yɛr jie ãsʊɔ, ");
INSERT INTO biv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Wʊ jɔ̃ɔn a ba nɩbie bar. Na wʊ pɔɔ a ba tɩɛr bar, baa lɛ nyɛrɛ ɛ. Ba kʊ̃ mɩ lɛ bɔ̃ɔ a par a ba tɩɛr pɔ ɛ, na ba lɩɛb wa a n sɛ̃ ka n sãa ba ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiya 'yɛr naa nɩtɔ̃, bojũu wʊ dɔ̃ɔ nyɛ a Yesu tɩɩr na wʊ 'yɛrɛ a wʊ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","An sɔɔ be a lɛ tɩ nɩbɛrɛ yɔɔ bamɩne sɔɔn de wʊ. Tɩchɛ a Faraseemɩne dãbãɛ jũu baa 'lara 'yɛrɛ ɛ, ka ba taa dii ba bar a ba lɔ̃ɔfʊ jie ɛ. ");
INSERT INTO biv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bojũu ba nʊ̃n nɩrɛ pɛɛfʊ gar Nãaŋmɩn pɛɛfʊ. ");
INSERT INTO biv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Be lɛ a Yesu 'yɛr kpɛ̃ɔ jaa, “Nɩrɛ 'lɔ na sɔɔ de ma a ba ɩ maa tɛɛ lɛ wʊ sɔɔ de ɛ, tɩchɛ wʊ sɔɔn de a 'lɔ na tʊ̃ ma. ");
INSERT INTO biv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nɩrɛ 'lɔ na nyɛ ma mɩ nyɛn a 'lɔ na tʊ̃ ma. ");
INSERT INTO biv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","N wan a wɛr pɔ nɩtãa chãa, ka nɩrɛ 'lɔ na sɔɔ de ma kʊ̃ lɛ be libe pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“A nɩrɛ 'lɔ na wõ a n 'yɛr, tɩ na waa tu ɛ, n kʊ̃ tɔɔr a wʊ 'yɛr ɛ. N ba wa ɩka n wa tɔɔr a wɛr 'yɛr ɛ, tɩ n wa faa wʊ. ");
INSERT INTO biv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","A 'yɛr tɔɔrɔ ben be, nɩrɛ 'lɔ na tɔr ma na waa de a n 'yɛr bie ɛ, a 'yɛr 'lɔ̃nɔ̃ nɩ wʊ ju ɩn 'yɛr lɛ na 'yɔ̃ɔ wʊ a 'yɛr a ber baaraa daar. ");
INSERT INTO biv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","N ba 'yɛrɛ n mãɛ 'yɛr ɛ, tɩchɛ n 'yɛr naa a lɛ a Sãa na tʊ̃ ma 'yɛr ma ɩka n 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","N bɔ̃ɔ naa ɩka a wʊ 'yɛr kʊrɔ na nyɛvʊr na ba tara baarfʊ ɛ. Ala lɛ so ka n 'yɛr yɩ a lɛ nɛ a Sãa na 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A kʊ̃ lɛ kor ɛ, tɩ a Gõl Bar Difʊ ta, Yesu bɔ̃ɔn naa ɩka a wʊ bɩbir vɩɛ naa ka wʊn yi ka a wɛr nyã pɔ lɩɛb chen a Sãa sɛ̃. Wʊ nʊ̃ naa bala na ɩ a wʊ tʊɔr a wɛr nyã pɔ, wʊ nʊ̃ ban tɩ tãn a wʊ kũu. ");
INSERT INTO biv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ba põn a jãanʊɔr bʊ̃diir, ka a ɩ tɩɩ de nie kpɛ Judas na ɩ Simon na yi Isɩkariyot bidaba ka wʊ tɩ gar 'yɔ̃ɔ a Yesu. ");
INSERT INTO biv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu bɔ̃ɔn naa ɩka a Sãa den bomo a jaa 'yɔ̃ɔ a wʊ nũu pɔ, an ɩ a Nãaŋmɩn sɛ̃ lɛ wʊ yi na wʊ lɛ lɩɛb chiine a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Be lɛ wʊ bar a bʊ̃diir tɩ ir na wʊ yaa a fuu bar tɩ de fɔfɩɛlaa sɛ a sɩɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Na wʊ pʊr kʊ̃ɔ 'yɔ̃ɔ la'yɛlma pɔ piel pɛɛrɛ a wʊ poturbo gbɛɛ tɩ ma fɩɛl a fɔfɩɛlaa 'lɔ wʊn sɛ a sɩɛ pɔ bar. ");
INSERT INTO biv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wʊn wa ta a Simon Pita ka wʊ 'yɛr, “N Soro, fʊ̃ʊ lɛ na pɛɛ a maa gbɛɛ ɔ?” ");
INSERT INTO biv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","A Yesu 'yɛr wʊ, “Faa bɔ̃ɔ a lɛ ɩn ɩrɛ a pʊ̃pãanyã ɛ, tɩchɛ fʊn wa bɔ̃ɔn daar kɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ka a Pita 'yɛr, “Kai, faa be na wa pɛɛ a n gbɛɛ ɛ.” A Yesu 'yɛr kʊ wʊ, “Maa ba pɛɛ a fʊ gbɛɛ ɛ, saa lɛ be taa ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ka Simon Pita pãa 'yɛr, “N Soro ala be lɛ, a ta ɩ a gbɛɛ tɛɛ ɛ, pɛɛ a nuur nɩ a ju mɩ.” ");
INSERT INTO biv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A Yesu 'yɛr, “Nɩrɛ na so kʊ̃ɔ baar gbɛɛ tɛɛ lɛ wʊ ma wa pɛɛ, a wʊ ãgãn wʊ jaa yi naa. A yɩn mɩ yi naa an ba ɩ yɩ jaa lɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu bɔ̃ɔn a lɔn na gar 'yɔ̃ɔ wʊ, ala lɛ so ka wʊ 'yɛr ɩka a ba ɩ ba jaa lɛ yi ɛ. ");
INSERT INTO biv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Wʊn wa pɛɛ a ba jaa gbɛɛ baar, wʊ lɛ den a fuu su tɩ jãnɛ nɩ a wʊ jie, tɩ sʊʊr ba, “Yɩ bɔ̃ɔn a nɩtɔ̃ ɩn ɩ par ɔ? ");
INSERT INTO biv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yɩ ma bʊɔl ma naa Wiwile bɩɩ Soro, yelmãɛ yɩ 'yɛr an ɩ a lɛ n ɩ. ");
INSERT INTO biv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ala ɩ maa na ɩ a yɩ Soro nɩ a yɩ Wiwile pɛɛn a yɩ gbɛɛ, yɩ mɩ pɛɛrɛ taa gbɛɛ. ");
INSERT INTO biv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","N maal wiil yɩ ɩka yɩ maala a lɛ ɩn ɩ kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, gbãgbaa ba ɩ kpɛ̃ɛ gar a wʊ soro ɛ. Tʊ̃tʊ̃nɔ̃ mɩ ba ɩ kpɛ̃ɛ gar a 'lɔ na tʊ̃ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Pʊ̃pãanyã yɩn bɔ̃ɔ a anyãna, an ɩn sʊ̃ʊfʊ ala ɩ yɩ ɩrɛ yaa naa. ");
INSERT INTO biv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Yɩ jaa ba lɛ n 'yɛrɛ ɛ, n bɔ̃ɔ naa a bala ɩn ir. Tɩchɛ lɛ an sɛb a Nãaŋmɩn gãn pɔ na ɩ naa a lɛ an sɛb, ‘A 'lɔ ɩn lɔ̃ɔ dire nɩ na lɩɛb ɩ ma bier.’ ");
INSERT INTO biv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“N 'yɛr yɩn a pʊ̃pãanyã tɩchɛ ka a ba ta sɛrɛ ɛ, ala wa ta ka yɩ sɔɔ de ma ɩka Maa lɛ. ");
INSERT INTO biv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, nɩrɛ 'lɔ na sɔɔ de a 'lɔ ɩn tʊ̃, maa lɛ wʊ sɔɔ de. Nɩrɛ 'lɔ mɩ na sɔɔ de ma mɩ sɔɔn de a 'lɔ na tʊ̃ ma.” ");
INSERT INTO biv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu na 'yɛr a nɩtɔ̃ baar a wʊ pʊɔ sɔ̃ɔ naa ka wʊ 'yɛr kʊ ba, “Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, a yɩ ãsʊɔ na tɩ gar 'yɔ̃ɔ ma.” ");
INSERT INTO biv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ka a poturbo kaara taa bʊɔrɔ ɩka ba bɔ̃ɔ a buor sɔɔ wʊn 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","A Yesu poturo ãsʊɔ wʊn nʊ̃ na jɛ̃ gbɛb wʊ, ");
INSERT INTO biv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","'lɔ lɛ a Simon Pita 'lɩɩr 'yɛr, “Sʊʊr wʊ kaa, an lɛ wʊ 'yɛrɛ?” ");
INSERT INTO biv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ka a poturo 'lɔ dɩɛl a Yesu tɩ sʊʊr wʊ, “N Soro, an lɛ fʊ 'yɛrɛ?” ");
INSERT INTO biv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A Yesu 'yɛr, “A 'lɔ ɩn na ŋmaa a paanʊ̃ɔ suun a jɩɛr kʊ, 'lɔ lɛ.” Wʊ ŋmaa naa a paanʊ̃ɔ suun a jɩɛr de kʊ a Judas na yi Isɩkariyot na ɩ Simon bie. ");
INSERT INTO biv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas na 'wɔb a paanʊ̃ɔ baar ka Satan kpɛ wʊ. Ka Yesu 'yɛr wʊ, “A lɛ fʊn bʊɔrɔ ɩka fʊ maal, pɔɔ fɔɔ maal.” ");
INSERT INTO biv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tɩchɛ a bala na be a bʊ̃diir jie, ãsʊɔ jaa ba bɔ̃ɔ a par a lɛ Yesu na 'yɛr kʊ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","An ɩ a Judas lɛ tara a ba libie wʊɔ, ka bamɩne tɩɛr ɩka Yesu tɔ̃ɔ 'yɛrɛ wʊ ɩka wʊ da bon kɔ̃ɔ waan a ba wa maal a lɔ̃ɔ di jie bɩɩ wʊ kʊ nɔ̃n dẽme bon kɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","A lɛ a Judas na wa de a paanʊ̃ɔ baar wʊ yi naa, tãsɔɔ mɩ lɛ. ");
INSERT INTO biv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Wʊn wa yi baar, Yesu 'yɛr naa, “Pʊ̃pãanyã maa Nɩsaal Bie nyɛn tɩɩr ka Nãaŋmɩn mɩ nyɛ tɩɩr tu a wʊ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ala ɩ Nãaŋmɩn nyɛn tɩɩr tu a wʊ 'yɔ̃ɔ, Nãaŋmɩn na kʊ naa a Bie tɩɩr, wʊn maal naa lɛ ajienaa. ");
INSERT INTO biv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“N bibiir, n kʊ̃ lɛ be a yɩ sɛ̃ kor ɛ. Yɩn wa yʊɔrɔ na bʊɔrɔ ma tɩ a lɛ ɩn 'yɛr kʊ a Juu nɩbɛ, lɛ mɩ lɛ n 'yɛr kʊ yɩ a pʊ̃pãanyã. A jie 'lɔ ɩn chiine yɩ kʊ̃ tʊ̃ɔ wa be ɛ. ");
INSERT INTO biv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Bin paalaa lɛ n kʊrɔ yɩ, yɩ nʊ̃ taa nɩtãa lɛ ɩn nʊ̃ yɩ. Yɩ mɩ nʊ̃ taa. ");
INSERT INTO biv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yɩn wa nʊ̃ taa, nɩbɛ ba jaa na bɔ̃ɔn naa ɩka yɩn lɛ ɩ a n poturbo.” ");
INSERT INTO biv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ka a Simon Pita sʊʊr wʊ, “N Soro, nyɩnɛ fʊ chiine?” A Yesu 'yɛr, “A jie ɩn chiine, fʊ kʊ̃ tʊ̃ɔ tu a pʊ̃pãanyã ɛ, tɩchɛ daar kɔ̃ɔ fʊn tu naa.” ");
INSERT INTO biv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ka a Pita sʊʊr wʊ, “N Soro, bo lɛ so ka n kʊ̃ tʊ̃ɔ tu fʊ a pʊ̃pãanyã ɛ? Ɩn sɔɔn kpi a fʊ jũu?” ");
INSERT INTO biv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","A Yesu 'yɛr wʊ, “Fʊn sɔɔn kpi kʊ ma? Yelmãɛ lɛ n 'yɛrɛ kʊrɔ fʊ ɩka nɔraa kʊ̃ kõ sɛrɛ ɛ, tɩ fʊ chiir gbɛɛ ata ɩka faa bɔ̃ɔ ma ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu 'yɛr kʊ a poturbo, “Yɩ ta vɛ̃ ka a yɩ pʊtɩɛr vavire ɛ, yɩ sɔɔ de Nãaŋmɩn na yɩ mɩ sɔɔ de ma. ");
INSERT INTO biv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","De yɔɔ be na a n Sãa yir, ala ba ta ɩ lɛ ɛ, n kʊ̃ naa 'yɛr kʊ yɩ ɛ. N chiine naa na tɩ chɔɔr a jie kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Maa wa chen tɩ chɔɔr a jie baar, ɩn lɩɛb wa de yɩ ka yɩ tɩ be a n sɛ̃, ka yɩ mɩ tɩ be a jie 'lɔ ɩn be. ");
INSERT INTO biv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yɩ bɔ̃ɔn a jie 'lɔ ɩn chiine sɔr.” ");
INSERT INTO biv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ka Tomasɩ sʊʊr wʊ, “N Soro, sɩn ba bɔ̃ɔ a jie fʊn chiine ɛ, ŋmɩnɛ sɩn ɩrɛ wa bɔ̃ɔ a sɔr?” ");
INSERT INTO biv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","A Yesu 'yɛr, “Maa lɛ a sɔr, a yelmãɛ, nɩ a nyɛvʊr. Nɩrɛ jaa kʊ̃ tʊ̃ɔ chen a Sãa sɛ̃, na waa tu a n jie ɛ. ");
INSERT INTO biv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ala ɩ yɩ bɔ̃ɔ ma naa, yɩn bɔ̃ɔn a Sãa mɩ. An be yi a dɩna yɩ bɔ̃ɔ wʊ naa, na yɩ nyɛ wʊ mɩ.” ");
INSERT INTO biv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ka Filip 'yɛr, “N Soro, wiil sɩ a Sãa a lɛ na sɛɛ sɩ naa.” ");
INSERT INTO biv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","A Yesu 'yɛr, “Filip, a mɔ̃ faa bɔ̃ɔ ma ɔ, a kõr jaa ɩn be a yɩ sɛ̃? Nɩrɛ 'lɔ jaa na nyɛ ma nyɛn a Sãa. Ŋmɩnɛ fʊ 'yɛr ɩka n wiil yɩ a Sãa? ");
INSERT INTO biv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Faa sɔɔ de ɩka n ben a Sãa 'yɔ̃ɔ ka a Sãa mɩ be a n 'yɔ̃ɔ ɛ? A 'yɛrbie ala ɩn 'yɛr kʊ yɩ a ba ɩ maa mãɛ 'yɛr ɛ, tɩ a Sãa na be a n 'yɔ̃ɔ lɛ tʊ̃nɔ̃ a wʊ tʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yɩ sɔɔ de a lɛ ɩn 'yɛr ɩka n be naa a Sãa 'yɔ̃ɔ ka a Sãa mɩ be a n 'yɔ̃ɔ, bɩɩ yɩ sɔɔ de a nɛ'maa tʊ̃mɔ̃ ala. ");
INSERT INTO biv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ, nɩrɛ 'lɔ jaa na sɔɔ de ma, wʊn tʊ̃nɔ̃ naa a tʊ̃mɔ̃ ala ɩn tʊ̃nɔ̃. Wʊn tʊ̃n tʊ̃bɛrɛ gar anyãna, bojũu n chiine naa a Sãa sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bon jaa yɩn de a yuor sʊɔr, ɩn maal wʊn kʊ yɩ, ka a Sãa nyɛ tɩɩr tu a Bie 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yɩ de a n yuor sʊɔr ma bon jaa, ɩn maal wʊ naa. ");
INSERT INTO biv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ala ɩ yɩ nʊ̃ ma naa, yɩn tu naa a lɛ ɩn 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ka n sʊɔr a Sãa ka wʊ kʊ yɩ a Sʊ̃nɔ̃ ãsʊɔ, ka wʊ be a yɩ sɛ̃ jaa kpo kpo. ");
INSERT INTO biv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","A yelmãɛ Sɩɛ 'lɔ, a wɛr nɩbɛ na kʊ̃ tʊ̃ɔ de wʊ ɛ, bojũu baa nyɛ wʊ ɛ, bɩɩ bɔ̃ɔ wʊ ɛ. Tɩchɛ yɩn 'lɔ bɔ̃ɔ wʊ naa an ɩ wʊ kpɩɛrɛ naa a yɩ sɛ̃, na wʊn be a yɩ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","N kʊ̃ bar yɩ nɩtãa kpɩɩr ɛ, ɩn lɩɛb wa a yɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A chɛn bãlãa a wɛr nɩbɛ kʊ̃ lɛ nyɛ ma go ɛ, tɩchɛ yɩn 'lɔ na nyɛ ma naa. Bojũu ɩn tara na nyɛvʊr ka yɩn mɩ na a nyɛvʊr. ");
INSERT INTO biv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A bɩbir 'lɔ wa vɩɛ, yɩn bɔ̃ɔ ɩka n be naa a n Sãa 'yɔ̃ɔ, ka yɩ mɩ be a n 'yɔ̃ɔ, ka n mɩ be a yɩ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nɩrɛ 'lɔ jaa na de a n 'yɛr na wʊ turo, 'lɔ lɛ ɩ nɩrɛ 'lɔ na nʊ̃ ma. 'Lɔ jaa mɩ na nʊ̃ ma, a n Sãa mɩ na nʊ̃ wʊ naa, ka maa mɩ nʊ̃ a nɩnyɩnɛ, naa wiil wʊ a n mãɛ.” ");
INSERT INTO biv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Be lɛ ka a Judas, a ba ɩ a Judas 'lɔ na yi a Isɩkariyot ɛ, 'lɔ lɛ 'yɛr, “Tɩchɛ, n Soro bo lɛ so ka fʊ wiil a fʊ mãɛ kʊ sɩ, tɩ na faa wile a fʊ mãɛ kʊrɔ a wɛr nɩbɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","A Yesu 'yɛr, “Ala ɩ ãsʊɔ jaa nʊ̃ ma naa, wʊn turo naa a n wiilfʊ. A n Sãa na nʊ̃ wʊ naa, ka sɩ wa be a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nɩrɛ 'lɔ na ba nʊ̃ ma ɛ, wʊ kʊ̃ tʊ̃ɔ tu a n wiilfʊ ɛ. A 'yɛrbie anyãna yɩn wõ ba ɩ maa mãɛ 'yɛr ɛ, a yin a Sãa na tʊ̃ ma sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“A anyãna a jaa lɛ n 'yɛr kʊ yɩ, ɩn chɛnɛ be a yɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tɩchɛ a Sʊ̃nɔ̃ 'lɔ na ɩ a Nãaŋmɩn Sɩɛ, 'lɔ lɛ a Sãa na tʊ̃n a n yuor. Wʊn wiil yɩ naa a yele a jaa, na wʊ mɩ jɛɔ yɩ ala a jaa ɩn dɔ̃ɔ 'yɛr yɩ. ");
INSERT INTO biv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nyã'maar pɔ lɛ n bar yɩ, a maa mãɛ nyã'maar lɛ n bar kʊ yɩ. N ba kʊ yɩ nɩtãa lɛ a wɛr nɩbɛ na ma kʊ ɛ. Yɩ ta vɛ̃ ka yɩ tɩɛr vavire ɛ, ka yɩ joro dãbãɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Yɩ wõn a lɛ ɩn 'yɛr ɩka n chiine naa tɩ ɩn lɩɛb wa a yɩ sɛ̃. Ala ɩ yɩ ta nʊ̃ ma naa, yɩ pʊɔ naa pɛl naa ɩn chiine a Sãa sɛ̃ an ɩ a n Sãa lɛ bɛrma gar ma. ");
INSERT INTO biv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","N den nie 'yɛrɛ kʊrɔ yɩ, tɩchɛ ka a na wa ɩ, ala wa ɩ, yɩn sɔɔn de. ");
INSERT INTO biv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Maa nɩ yɩn kʊ̃ lɛ 'yɛr kor ɛ, bojũu a wɛr nyã nãa Satan waara naa, tɩ waa tara kpɛ̃ɔ a n 'yɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tɩchɛ a wɛr nɩbɛ na bɔ̃ɔn ɩka n nʊ̃ naa n Sãa naa maal a lɛ nɛ a n Sãa na 'yɔ̃ɔ ma. Yɩ ir a sɩ chen.” ");
INSERT INTO biv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","A Yesu 'yɛr, “Maa lɛ ɩ a tɩwɔ̃n sʊ̃ ka a n Sãa mɩ ɩ a tɩkaara. ");
INSERT INTO biv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Wʊ ma ŋman a wilsɩ ala na be a n 'yɔ̃ɔ tɩ ba wɔ̃nɔ̃ ɛ. A wilsɩ ala mɩ na wɔ̃nɔ̃, wʊ ma chɔɔr 'mɛl bar ka a wɔ̃ yɔɔ. ");
INSERT INTO biv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yɩn 'lɔ, a 'yɛr ɩn 'yɛr kʊ yɩ chɔɔr yɩ naa. ");
INSERT INTO biv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yɩ mar a n 'yɔ̃ɔ, ka n mɩ mar a yɩ 'yɔ̃ɔ. Wile jaa kʊ̃ wɔ̃ wɔ̃mɔ̃ a wʊ mãɛ ɛ, ka waa mar a tɩwɔ̃naa 'yɔ̃ɔ ɛ. Yɩn mɩ kʊ̃ tʊ̃ɔ wɔ̃mɔ̃ wɔ̃ ɛ. Yɩn mɩ kʊ̃ tʊ̃ɔ wɔ̃mɔ̃ wɔ̃ ɛ, ka yaa mar a n 'yɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Maa lɛ ɩ a tɩɛ, yɩn mɩ lɛ a wilsɩ, ala ɩ nɩrɛ be naa a n 'yɔ̃ɔ ka n mɩ be a wʊ 'yɔ̃ɔ, wʊn wɔ̃n wɔ̃mɔ̃ yɔɔ. Maa ba be a yɩ sɛ̃ ɛ, yɩ kʊ̃ tʊ̃ɔ bon jaa ɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ala ɩ ãsʊɔ jaa ba be a n 'yɔ̃ɔ ɛ, wʊ nyɛntãan a wile ban lɔb bar ka wʊ ko. Ba ma wob a wilbie anyãna lɔb 'yɔ̃ɔ bũu pɔ ka a di. ");
INSERT INTO biv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ala ɩ yɩ be naa a n 'yɔ̃ɔ, ka a n 'yɛr be a yɩ 'yɔ̃ɔ, yɩ sʊɔr bon jaa yɩn bʊɔrɔ, yɩn nyɛ naa. ");
INSERT INTO biv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","A nyã lɛ ɩ a n Sãa tɩɩr yɩn wa wɔ̃nɔ̃ wɔ̃mɔ̃ yɔɔ, a mɩ nɩ wiil naa ɩka yɩ ɩ naa n poturbo. ");
INSERT INTO biv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Lɛ a Sãa na nʊ̃ ma, lɛ mɩ lɛ n nʊ̃ yɩ. Yɩ ara a n nʊ̃fʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ala ɩ yɩ tu naa a lɛ ɩn 'yɛr, yɩn be naa a n nʊ̃fʊ pɔ, nɩtãa lɛ ɩn tu a n Sãa 'yɛr naa be a wʊ nʊ̃fʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","A anyãna lɛ n 'yɛr kʊ yɩ ka n pʊpɛl be a yɩ sɛ̃, ka a yɩ chɩlfʊ mɩ sɛɛ. ");
INSERT INTO biv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","A n 'yɛr ɩn kʊrɔ yɩ nɩ nyã. Yɩ nʊ̃ taa nɩtãa lɛ ɩn nʊ̃ yɩ. ");
INSERT INTO biv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","A nʊ̃fʊ 'lɔ na gar a nʊ̃fʊ a jaa lɛ nɩrɛ na sɔɔ kpi kʊ a wʊ barmɩne. ");
INSERT INTO biv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yɩn lɛ ɩ a n barmɩne ala ɩ yɩ ɩrɛ naa a lɛ ɩn 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","N ba lɛ bʊɔlɔ yɩ gbãgbaar go ɛ, bojũu tʊ̃tʊ̃nɔ̃ ba bɔ̃ɔ lɛ a wʊ nɩkpɛ̃ɛ na ɩrɛ ɛ. N bʊɔlɔ yɩ naa n barmɩne, bojũu n 'yɛr yɩn a lɛ jaa ɩn wõ yi a n Sãa sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yɩn baa ir ma ɛ, tɩchɛ maa lɛ ir yɩ ɩka yɩ tɩ wɔ̃ wɔ̃mɔ̃, a wɔ̃mɔ̃ ala na kʊ̃ sɔ̃ɔ ɛ. A Sãa na pãa kʊ yɩ naa bon jaa yɩn sʊɔr a n yuor pɔ. ");
INSERT INTO biv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","A nyãna lɛ n 'yɛr ɩka, yɩ nʊ̃ taa. ");
INSERT INTO biv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ala wa ɩ a wɛr nɩbɛ 'laar yɩ naa, yɩ bɔ̃ɔ ɩka ba dɔ̃ɔ de nie 'laar ma. ");
INSERT INTO biv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ala ɩ yɩ ta ɩ naa a wɛr nɩbɛ, a wɛr nɩbɛ naa nʊ̃ yɩ naa nɩtãa a wʊ bon. Yaa ɩ a wɛr nyã tʊɔr ɛ. Tɩchɛ an ɩ n oo yɩn ir a wɛr nɩbɛ pɔ, ala lɛ so a ba 'laar yɩ. ");
INSERT INTO biv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yɩ tɩɛr tɔ a 'yɛr 'lɔ ɩn 'yɛr kʊ yɩ. Gbãgbaa ba ɩ kpɛ̃ɛ gar a wʊ soro ɛ. Ala ɩ ba ge ma naa, ba mɩ na ge yɩ naa. Ala ɩ ba tu naa a n wiilfʊ, ba mɩ a n tu naa a yɩ wiilfʊ mɩ. ");
INSERT INTO biv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ban maal yɩ naa a nɩtɔ̃nɔ̃ a n yuor jũu, bojũu baa bɔ̃ɔ a nɩrɛ 'lɔ na tʊ̃ ma ɛ. ");
INSERT INTO biv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ala ɩ n ba ta wa 'yɛr 'yɛr kʊ ba ɛ, ba kʊ̃ naa tara yeldɛɛr ɛ, pʊ̃pãanyã baa tara a ba yeldɛɛr lɩɛb tunfʊ jie ɛ. ");
INSERT INTO biv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","A 'lɔ na 'laar ma mɩ 'laara a n Sãa mɩ. ");
INSERT INTO biv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Maa ta ba tʊ̃tʊ̃mɔ̃ na ba sɔ̃ɔ nɩrɛ jaa na ba ɩ ɛ, ba kʊ̃ naa tara yeldɛɛr ɛ. Tɩchɛ pʊ̃pãanyã ba nyɛn a nɛ'maa tʊ̃mɔ̃ ɩn tʊ̃, tɩ chɛnɛ 'laar ma nɩ a n Sãa. ");
INSERT INTO biv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tɩchɛ a anyã ɩ naa ka a ɩ yelmãɛ a lɛ an sɛb a Nɛɛ pɔ, ‘Ba 'laar man pɔrɔ.’ ");
INSERT INTO biv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“A Sʊ̃nɔ̃ na wa na, a 'lɔ na yi a Sãa sɛ̃. A yelmãɛ Sɩɛ 'lɔ wʊ yin a Sãa sɛ̃, wʊn 'yɛr yɩ naa a n 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yɩ mɩ na 'yɛr naa a n 'yɛr bojũu yɩ ben a n sɛ̃ a pielfʊ jaa.” ");
INSERT INTO biv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","A Yesu 'yɛr, “A anyãna a jaa lɛ n 'yɛrɛ kʊrɔ yɩ, ka yɩ taa bar yi a sɔɔfʊ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ban dii yɩn bar a ba lɔ̃ɔfʊ jie. Bɩbir kɔ̃ɔ na vɩɛ naa, ka ba kʊ yɩ tɩ tɩɛr ɩka Nãaŋmɩn tʊ̃mɔ̃ lɛ ba tʊ̃. ");
INSERT INTO biv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ban ɩ naa anyãna, bojũu baa bɔ̃ɔ a Sãa ɛ, bɩɩ a maa ɛ. ");
INSERT INTO biv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","N 'yɛrɛ yɩ naa anyãna ka a bɩbir wa vɩɛ yɩn tɩɛr tɔ, ɩka n dɔ̃ɔ kpãa yɩ. N ba dɔ̃ɔ 'yɛr kʊ yɩ ɛ, bojũu n be naa a yɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Pʊ̃pãanyã n chiine naa a 'lɔ na tʊ̃ ma sɛ̃, tɩchɛ a ãsʊɔ jaa ba sʊʊr ma a jie ɩn chiine ɛ. ");
INSERT INTO biv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","A anyãna ɩn 'yɛr kʊ yɩ jũu lɛ a yɩ pʊʊr sɔ̃ɔ ɔ? ");
INSERT INTO biv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tɩchɛ yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, a yɩ jũu a sɛɛ naa ɩka n chen. Maa ba chen ɛ, a Sʊ̃nɔ̃ kʊ̃ wa a yɩ sɛ̃ ɛ, tɩchɛ maa chen ɩn tʊ̃ wʊn ka wʊ wa a yɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","'Lɔ wa wa, wʊn wiil a wɛr nɩbɛ a ba bɔ̃ɔ ɩka ba bɔr naa, lɛ a yeldɛɛr nɩ yeltorsɩ na be, nɩ lɛ wʊn na tɔɔr a ba 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wʊn vɛ̃ naa a ba bɔ̃ɔ a ba yeldɛɛr ban ba sɔɔ de ma ɛ. ");
INSERT INTO biv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ba bɔr naa nɩ a yeltorsɩ, bojũu n chiine naa a Sãa sɛ̃, yɩ kʊ̃ lɛ nyɛ ma go ɛ. ");
INSERT INTO biv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ba mɩ bɔr naa nɩ a 'yɛr tɔɔrfʊ yele, bojũu a wɛr nyã nãa Satan 'yɛr tɔɔr naa. ");
INSERT INTO biv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“N chɛnɛ na tara 'yɛr yɔɔ nɩ taa 'yɛr yɩ tɩchɛ a pʊ̃pãanyã, yɩ kʊ̃ tʊ̃ɔ bɔ̃ɔ a par ɛ. ");
INSERT INTO biv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tɩchɛ a yelmãɛ Sɩɛ 'lɔ wa wa, wʊn wiil yɩ naa a yelmãɛ wʊ jaa par. Wʊ kʊ̃ 'yɛr a wʊ mãɛ 'yɛrɛ ɛ, tɩ wʊn 'yɛr naa a lɛ tɛɛ wʊn wõ, na wʊ lɛ 'yɛr yɩ a ala na wa. ");
INSERT INTO biv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wʊn waan na tɩɩr wa kʊ ma, na wʊ vɛ̃ ka yɩ bɔ̃ɔ a ala na ɩ a n bon. ");
INSERT INTO biv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ala a jaa a Sãa na so ɩ naa a n bon. Ala lɛ so ka n 'yɛr ɩka a Sɩɛ na vɛ̃ naa ka yɩ bɔ̃ɔ a ala na ɩ a n bon. ");
INSERT INTO biv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“A chɛn bãlãa yɩ kʊ̃ nyɛ ma go ɛ, ka a pãa lɛ ɩ bãlãa ka yɩ nyɛ ma go.” ");
INSERT INTO biv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ka a poturbo bamɩne sʊrɔ taa, “A par nɩ bo wʊn 'yɛr ɛ ɩka, ‘A chɛn bãlãa yɩ kʊ̃ lɛ nyɛ ma go ɛ, ka a pãa lɛ ɩ bãlãa ka yɩ lɛ nyɛ wʊ go, nɩ wʊn lɛ 'yɛr ɩka, n chiine naa a Sãa sɛ̃?’ ” ");
INSERT INTO biv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ba chɛnɛ na sʊrɔ taa, “A chɛn bãlãa par nɩ bo? ‘Sãa bɔ̃ɔ a par a lɛ,’ wʊn 'yɛrɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu bɔ̃ɔn naa ban bʊɔrɔ ɩka ba sʊʊr wʊ ka wʊ 'yɛr kʊ ba, “Yɩ sʊrɔ nɩ taa a lɛ ɩn 'yɛr ɩka, ‘A chɛn bãlãa yɩ kʊ̃ nyɛ ma go ɛ, ka a lɛ ɩ bãlãa ka yɩ nyɛ ma go’? ");
INSERT INTO biv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka yɩn kõnõ na ka yɩ pʊʊr sɔ̃ɔ, tɩchɛ ka a wɛr nɩbɛ chɩlɛ. Yɩ pʊʊr na sɔ̃ɔ naa, tɩchɛ ka a yɩ pʊsɔ̃ɔ na lɩɛb pʊpɛl. ");
INSERT INTO biv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pɔɔ wa dɔɔrɔ ãgãn ma chɩrɛ wʊ naa ka a ɔɔrɔ wʊ bojũu a wʊ dɔɔfʊ bɩbir vɩɛ naa. Tɩchɛ 'lɔ wʊ dɔɔ baar, wʊ ma ĩin naa a wʊ dɔɔyɛ bojũu wʊ dɔɔn nɩrɛ a wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lɛ nɩ wʊ ju lɛ a yɩn mɩ, yɩ pʊʊr na sɔ̃ɔ naa a pʊ̃pãanyã, tɩchɛ ɩn lɛ wa nyɛ yɩn go ka yɩ pʊʊl pɛl, ka a nɩrɛ jaa kʊ̃ tʊ̃ɔ faa wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","A bɩbir 'lɔ wa vɩɛ, yɩ kʊ̃ lɛ sʊʊr ma bon go ɛ. Yelmãɛ lɛ n 'yɛrɛ kʊrɔ yɩ ɩka, a n Sãa na kʊ yɩn bon jaa yɩn sʊɔr a n yuor pɔ. ");
INSERT INTO biv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","An wa ta a pʊ̃pãanyã, yaa de a n yuor sʊɔr bon gba ɛ. Yɩ sʊɔr, yɩn nyɛ naa, ka yɩ pʊpɛl na sɛɛ. ");
INSERT INTO biv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Sʊkpar lɛ n lɔɔrɔ 'yɛrɛ nɩ yɩ a anyãna, a bɩbir wa vɩɛ, n kʊ̃ lɛ lɔb sʊkpar go ɛ, tɩchɛ ɩn 'yɛr yɩ naa a n Sãa 'yɛr chãa pɔ. ");
INSERT INTO biv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","A bɩbir 'lɔ̃nɔ̃, yɩn sʊɔr naa nɩ a n yuor. N ba 'yɛrɛ ɩka maa lɛ na sʊɔr a Sãa kʊ yɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","An ɩ a Sãa nʊ̃ yɩ naa bojũu yɩ nʊ̃ ma naa na yɩ sɔɔ de ɩka a Nãaŋmɩn sɛ̃ lɛ n yi. ");
INSERT INTO biv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","A Sãa sɛ̃ lɛ n yi wa ka a wɛr pɔ, pʊ̃pãanyã n lɛ bara naa a wɛr tɩ lɩɛb chiine a Sãa sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ka a Yesu poturbo pãa 'yɛr kʊ wʊ, “Pʊ̃pãanyã fʊ pãa 'yɛr ka a chaar faa lɛ lɔɔrɔ sʊkpar go ɛ. ");
INSERT INTO biv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Pʊ̃pãanyã sɩ nyɛn ɩka fʊ bɔ̃ɔn yele a jaa, na faa lɛ bʊɔrɔ ɩka nɩrɛ wʊ sʊʊr fʊ sʊʊrfʊsɩ ɛ. Ala lɛ so ka sɩ sɔɔ de ɩka Nãaŋmɩn sɛ̃ lɛ fʊ yi.” ");
INSERT INTO biv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ka a Yesu sʊʊr ba, “Yɩ pãa sɔɔn de a pʊ̃pãanyã ɔ? ");
INSERT INTO biv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tɩchɛ bɩbir kɔ̃ɔ na wa vɩɛ naa, wʊ ben ta, ka yɩ jaa na yɛ̃yɛl ka ãsʊɔ jaa kul a wʊ yir tɩ chɛ ma bar a n yõ. Tɩ n ba ɩ a n yõ ɛ, a n Sãa be naa n sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“N 'yɛr yɩ naa anyãna ka yɩ na tara nyã'maar an ɩ yɩ ben a n 'yɔ̃ɔ. A wɛr nyã pɔ yɩn din dɔɔyɛ, tɩchɛ yɩ nyɔɔ nyãa, bojũu n tʊ̃ɔn a wɛr.” ");
INSERT INTO biv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","A Yesu na wa 'yɛr a anyãna baar, wʊ kãan saaju tɩ 'yɛr, “N Sãa, a bɩbir vɩɛ naa, kʊ a fʊ Bie a tɩɩr ka a fʊ Bie mɩ kʊ fʊ a tɩɩr. ");
INSERT INTO biv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bojũu, fʊ̃ʊ lɛ kʊ wʊ sɔr ka wʊ tʊ̃ɔ a nɩbɛ ba jaa na wʊ kʊ ba a nyɛvʊr 'lɔ na ba tara baarfʊ ɛ, a bala ba jaa fʊn de kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A nyɛvʊr 'lɔ na ba tara baarfʊ nɩ nyã, ka ban bɔ̃ɔ a fʊ̃ʊ Nãaŋmɩn tɛɛ, na ɩ yelmãɛ sʊɔ, nɩ a Yesu 'lɔ fʊn tʊ̃. ");
INSERT INTO biv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","N waan na tɩɩr wa kʊ fʊ a ka a wɛr pɔ, naa baar a tʊ̃mɔ̃ ala fʊn kʊ ma ɩka n tʊ̃. ");
INSERT INTO biv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pʊ̃pãanyã, n Sãa kʊ ma a tɩɩr a fʊ niem, a tɩɩr 'lɔ ɩn dɔ̃ɔ tara tɩchɛ na fʊ wa maal a wɛr. ");
INSERT INTO biv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“N wiil fʊn kʊ a bala fʊn de kʊ ma ka a wɛr pɔ, fʊ̃ʊ lɛ dɔ̃ɔ so ba tɩ na fʊ wa de ba kʊ ma, ba tu naa a fʊ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Pʊ̃pãanyã ba bɔ̃ɔ naa ɩka bon jaa ɩn tara yin a fʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bojũu, a 'yɛr ala fʊn kʊ ma, n 'yɛr kʊ ba, ka ba sɔɔ de. Ba bɔ̃ɔn yelmãɛ jaa ɩka fʊ̃ʊ sɛ̃ lɛ n yi naa wa, na ba sɔɔ de ɩka fʊ̃ʊ lɛ tʊ̃ ma. ");
INSERT INTO biv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Bala 'yɔ̃ɔ lɛ n sʊɔrɔ fʊ, n ba sʊɔrɔ fʊ kʊrɔ a wɛr nɩbɛ ɛ, tɩchɛ a bala fʊn kʊ ma an ɩ fʊ̃ʊ lɛ so ba. ");
INSERT INTO biv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bon jaa ɩn tara ɩ naa a fʊ sofʊ, ka bon jaa fʊn mɩ na tara ɩ a n sofʊ. N nyɛn tɩɩr yi a ba jie. ");
INSERT INTO biv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Maa kʊ̃ lɛ be ka a wɛr pɔ go ɛ, tɩchɛ bala 'lɔ chɛnɛ na be ka a wɛr pɔ, n waara a fʊ sɛ̃. Sãa sʊ̃, gu ba nɩ a fʊ yuor kpɛ̃ɔ 'lɔ pɔ, a yuor 'lɔ fʊn kʊ ma ka ban ɩ bʊ̃'yen, nɩtãa lɛ maa nɩ fʊ̃ʊ na ɩ bʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ɩn be a ba sɛ̃, n gu ban naa kpɛ̃ɔ 'lɔ fʊn kʊ ma. Ɩ̃sʊɔ jaa ba bɔr ɛ, ala ba ɩ a 'lɔ tɛɛ an sɛɛ ɩka wʊ bɔr ka a lɛ na sɛb a Nãaŋmɩn gãn pɔ na ɩ yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“N waara naa a fʊ sɛ̃ a pʊ̃pãanyã, tɩchɛ ɩn chɛnɛ be ka a wɛr pɔ lɛ n 'yɛrɛ a anyãna ka ban tara a n pʊpɛl wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","N kʊ ban a fʊ 'yɛr, ala lɛ so ka a wɛr nɩbɛ 'laar ba, baa lɛ chɛnɛ pʊɔ ba go ɛ, nɩtãa maa na ba pʊɔ ba ɛ. ");
INSERT INTO biv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","N ba sʊɔrɔ fʊ ɩka fʊ ir ba yin ka a wɛr pɔ ɛ, tɩchɛ fʊ guro ba a dɛɛr sʊɔ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Baa lɛ pʊɔ a wɛr nɩbɛ pɔ ɛ, nɩtãa n mɩ na ba pʊɔ ba ɛ. ");
INSERT INTO biv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Oo ba nɩ a fʊ yelmãɛ, a fʊ 'yɛr ɩn yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nɩtãa lɛ fʊn tʊ̃ ma a wɛr nɩbɛ sɛ̃, lɛ lɛ n mɩ tʊ̃ ba a wɛr nɩbɛ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","A ba 'yɔ̃ɔ lɛ n oo a n mãɛ kʊ fʊ, ka ba mɩ na oo a ba mãɛ sɩrɛ jaa kʊ fʊ. ");
INSERT INTO biv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“A ba ɩ bala tɛɛ 'yɔ̃ɔ lɛ n sʊɔrfʊ ɛ, n mɩ sʊɔrɔ na kʊrɔ a bala na wa sɔɔ de ma tu a ba 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","N sʊɔrɔ fʊ naa ɩka fʊ vɛ̃ ka ba jaa ɩ bʊ̃'yen. N Sãa, nɩtãa lɛ fʊn be a n 'yɔ̃ɔ, ka n mɩ be a fʊ 'yɔ̃ɔ. Ba mɩ be a sɩ 'yɔ̃ɔ ka a wɛr nɩbɛ na sɔɔ de ɩka fʊ̃ʊ lɛ tʊ̃ ma. ");
INSERT INTO biv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","N kʊ ban a tɩɩr 'lɔ̃nɔ̃ nɩ wʊ ju fʊn kʊ ma, ka ba na ɩ bʊ̃'yen nɩtãa maa nɩ fʊ̃ʊ na ɩ bʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","N ben a ba 'yɔ̃ɔ, ka fʊ mɩ be a n 'yɔ̃ɔ. Ka ba jaa mɩ na 'mataa ɩ bʊ̃'yen ka a wɛr nɩbɛ bɔ̃ɔ ɩka fʊ̃ʊ lɛ tʊ̃ ma na fʊ nʊ̃ ba gba nɩtãa a lɛ fʊn nʊ̃ ma. ");
INSERT INTO biv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“N Sãa, n bʊɔrɔ naa ɩka a bala fʊn kʊ ma, ba mɩ be a jie 'lɔ ɩn na be, na ba nyɛ a n tɩɩr. A tɩɩr 'lɔ fʊn de nie kʊ ma, bojũu fʊ nʊ̃ ma naa tɩ na fʊ wa maal a wɛr. ");
INSERT INTO biv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“N Sãa, a fʊ yele tor naa, tɩ a wɛr nɩbɛ ba bɔ̃ɔ fʊ ɛ, maa bɔ̃ɔ fʊ naa, ka a n poturbo mɩ bɔ̃ɔ ɩka fʊ̃ʊ lɛ tʊ̃ ma. ");
INSERT INTO biv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","N vɛ̃n ka ba bɔ̃ɔ fʊ, ɩn chɛnɛ na maal ba ka ba bɔ̃ɔnɔ̃ fʊ pʊɔrɔ ka a nʊ̃fʊ 'lɔ fʊn nʊ̃ ma na be a ba 'yɔ̃ɔ ka n mɩ be a ba 'yɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu na sʊɔr a Sãa a nɩtɔ̃ baar, 'lɔ naa poturbo gɔ̃ɔ naa a Kidɩrɔn kʊla gɔ̃ɔn. 'Lɔ nɩ a wʊ poturbo chen a jie a kãa tɩɩr na be. ");
INSERT INTO biv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas na gar 'yɔ̃ɔ wʊ mɩ bɔ̃ɔn a jie nyã, bojũu Yesu naa wʊ poturbo ba gala a be lɔ̃ɔfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Be lɛ Judas tara a Worom sojasɩ, nɩ a puorfʊ die gugurbo bala a bɔɔrlo nɩbɛrɛ nɩ a Faraseemɩne na tʊ̃ chiin a jie 'lɔ. Ba tara na bũusɩ, fãtɩnsɩ nɩ jɛɛr bomo. ");
INSERT INTO biv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu na bɔ̃ɔ lɛ na waara a wʊ sɛ̃, wʊ tuor sʊʊr ba, “An yɩ bʊɔrɔ?” ");
INSERT INTO biv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ka ba 'yɛr, “Yesu na yi Najaretɩ lɛ sɩ bʊɔrɔ.” Ka a Yesu 'yɛr, “Maa lɛ.” Ka a Judas 'lɔ na gar 'yɔ̃ɔ wʊ lɔ̃ɔn ba ara. ");
INSERT INTO biv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu na wa 'yɛr ɩka, “Maa lɛ.” Ba lɩɛb puor lo lo tẽe. ");
INSERT INTO biv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wʊ lɛ sʊʊr ban go, “An lɛ yɩ bʊɔrɔ?” A ba 'yɛr, “Yesu na yi Najaretɩ.” ");
INSERT INTO biv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","A Yesu 'yɛr, “N ba 'yɛr yɩ ɩka ‘Maa lɛ.’ Ala ɩ maa lɛ yɩ bʊɔrɔ, yɩ ɩ ka a nɩbɛ banyã chiine.” ");
INSERT INTO biv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu 'yɛr a nɩtɔ̃ ka a lɛ wʊn dɔ̃ɔ 'yɛr ɩ yelmãɛ ɩka, “A bala fʊn kʊ ma, n ba vɛ̃ ka ãsʊɔ jaa bɔr ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Be lɛ a Simon Pita na tara sʊɔ na wʊ vʊ̃ɔ chɛn a bɔɔrlo nɩkpɛ̃ɛ gbãgbaa nũsʊ̃ɔ toor ŋmaa. A gbãgbaa yuor din Malkusɩ. ");
INSERT INTO biv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","A Yesu 'yɛr kʊ a Pita, “Su a sʊɔ a sʊkpa pɔ, n ta nyũn a dɔɔyɛ ŋmele 'lɔ a Sãa na kʊ ma bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ka a sojasɩ nɩ a ba nɩkpɛ̃ɛ 'matãan a gugurbo bala ban tʊ̃, nyɔɔ a Yesu na ba lũ. ");
INSERT INTO biv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ba den nie tara wʊ chiin Anasɩ sɛ̃, wʊ ɩ naa a Kayafasɩ dãɛ na wʊ mɩ ɩ bɔɔrlo nãa a yuon 'lɔ̃nɔ̃. ");
INSERT INTO biv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","A Kayafasɩ nyãna lɛ dɔ̃ɔ 'yɛr kʊ a Juu nɩbɛ ɩka a ɩn sʊ̃, ka nɩbʊ̃'yen na kpi kʊ a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pita nɩ a poturo ãsʊɔ turo naa a Yesu, bojũu a poturo nyã bɔ̃ɔn a bɔɔrlo nãa ala lɛ so ka wʊ tu a Yesu kpɛ a bɔɔrlo nãa bɛchaar pɔ. ");
INSERT INTO biv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tɩchɛ ka a Pita 'lɔ ara a yõo dɔ̃dɔr nɛɛ. A poturo nyã a bɔɔrlo nãa na bɔ̃ɔ, yin wa 'yɛr a pɔɔbile 'lɔ na kaara a dɔ̃dɔr nɛɛ tɩ tara a Pita kpɛ̃n. ");
INSERT INTO biv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ka a pɔɔbile 'lɔ na kaara a dɔ̃dɔr nɛɛ, sʊʊr a Pita, “A fʊ̃ʊ, faa mɩ ɩ a daba nyã poturo ãsʊɔ ɛ?” Ka a Pita 'yɛr, “N ba ɩ a wʊ poturo ãsʊɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ɔɔr kʊrɔ naa ka a gbãgbaar nɩ a gugurbo bala gbɔɔ saalaa bũu ara uoro ka a Pita mɩ tɩ ara uoro. ");
INSERT INTO biv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","A bɔɔrlo nãa sʊʊr naa a Yesu, ba boo lɛ ɩ a wʊ poturbo nɩ bo lɛ wʊ ma wile? ");
INSERT INTO biv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","A Yesu 'yɛr kʊ wʊ, “Chãa pɔ lɛ n ma 'yɛrɛ a n 'yɛr kʊrɔ a nɩbɛ. N ma wile ba naa a ba lɔ̃ɔfʊ jie nɩ a ba Nãaŋmɩn puorfʊ jiir, be lɛ a Juu nɩbɛ ba jaa ma lɔ̃ɔ. N ba sɔɔl 'yɛr 'yɛr jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bo lɛ so ka fʊ sʊrɔ ma a lɛ? Sʊʊr a bala na wõ a n 'yɛr, ba bɔ̃ɔn a lɛ ɩn 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu na 'yɛr a nɩtɔ̃ ka a guguro ãsʊɔ na ara gbʊr wʊ 'ma wʊ tɩ 'yɛr, “Lɛ lɛ a sɛɛ ɩka fʊ 'yɛr kʊ a bɔɔrlo nãa ɔ?” ");
INSERT INTO biv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","A Yesu 'yɛr, “Ala ɩ a lɛ ɩn 'yɛr n bɔr naa, wiil a n bɔrfʊ jie. Tɩchɛ ala ɩ yelmãɛ lɛ n mɩ 'yɛr, bo 'yɔ̃ɔ fʊ 'ma ma?” ");
INSERT INTO biv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Wʊ chɛnɛ na lũ tɩchɛ ka a Anasɩ vɛ̃ a ba tara wʊ chiin a bɔɔrlo nãa Kayafasɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","A Simon Pita na chɛnɛ ara uoro a bũu, ba sʊʊr wʊ naa, “A fʊ̃ʊ, fʊ ɩ naa a daba nyã poturo ãsʊɔ ɔ?” Ka Pita chiir 'yɛr, “N ba ɩ a wʊ poturo ãsʊɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","A bɔɔrlo nãa gbãgbaa ãsʊɔ, wʊ nɩrɛ ãsʊɔ toor lɛ a 'lɔ a Pita na dɔ̃ɔ chɛ ŋmaa 'yɛr, “A ba ɩ n nyɛ fʊ naa fʊn be a wʊ sɛ̃ a kãa tɩɩr jie 'lɔ ɛ?” ");
INSERT INTO biv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ka a Pita lɛ chiir, ka a nɔraa mɩ tɔ̃ɔ kõ ajienaa. ");
INSERT INTO biv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Be lɛ ba tara a Yesu yin a Kayafasɩ yir bibio pipi na ba chiin a Worom nɩkpɛ̃ɛ yir. A Juu nɩbɛ mãɛ ba kpɛ be ɛ, bojũu baa bʊɔrɔ ɩka ba sɔ̃ɔ ba mãɛ na ba kʊ̃ tʊ̃ɔ di a Gõl Bar Difʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Lɛ lɛ a Pilate yi a yõo tɩ sʊʊr ba, “Bo yelbier yɩ ɩka a daba nyã ɩ naa?” ");
INSERT INTO biv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ka ba 'yɛr, “'Lɔ ba ta maal yelbier ɛ, sɩ kʊ̃ naa tara wʊ waan a fʊ sɛ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ka Pilate 'yɛr kʊ ba, “Yɩn mãɛ, yɩ de wʊ tɩ tɔɔr a wʊ 'yɛr, a lɛ a yɩn mãɛ nɛɛ na 'yɛr bin.” Tɩchɛ ka a Juu nɩbɛ 'yɛr, “Saa tara sɔr na kʊ nɩrɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A ɩn a lɛ a Yesu na dɔ̃ɔ 'yɛr wiil a kũu 'lɔ tɔ wʊn na kpi. ");
INSERT INTO biv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate lɩɛb kpɛ tɩ bʊɔl a Yesu sʊʊr, “Fʊ̃ʊ lɛ ɩ a Juu nɩbɛ nãa bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","A Yesu sʊʊr wʊ, “Fʊ̃ʊ lɛ tɩɛr a lɛ bɩɩ nɩbɛ lɛ 'yɛr a n 'yɛr kʊ fʊ?” ");
INSERT INTO biv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ka a Pilate 'yɛr, “Fʊ tɩɛr ɩka n ɩn Juu nɩrɛ bɩɩ? A fʊ mãɛ nɩbɛ nɩ a bɔɔrlo nɩbɛrɛ baa nyɔɔ fʊ waan a n sɛ̃, bo fʊ̃ʊ ɩ?” ");
INSERT INTO biv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","A Yesu 'yɛr, “A n nãalʊ̃ʊ ba yi ka a wɛr pɔ ɛ, ala ɩ a wɛr pɔ lɛ wʊ dɔ̃ɔ yi, a n poturbo naa jɛb faa ma ka a Juu nɩbɛrɛ ta nyɔɔ ma ɛ. Tɩchɛ a n nãalʊ̃ʊ ba yi a ka ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ka a Pilate pãa sʊʊr wʊ, “Ka ala ɩ a lɛ, nãa lɛ fʊ ɩ wɛ?” Ka Yesu 'yɛr, “Fʊ 'yɛr vɩla fʊn 'yɛr ɩka nãa lɛ n ɩ, ala 'yɔ̃ɔ lɛ ba dɔɔ ma ka n wa ka a wɛr pɔ, naa wa 'yɛr a yelmãɛ 'yɛr. Nɩrɛ 'lɔ jaa na ɩ yelmãɛ sʊɔ chɛlɛ naa lɛ ɩn 'yɛrɛ.” ");
INSERT INTO biv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ka Pilate sʊʊr wʊ, “Bo lɛ ɩ a yelmãɛ?” Wʊn sʊʊr a nɩtɔ̃ baar, wʊ yin a yõo a Juu nɩbɛrɛ sɛ̃ tɩ 'yɛr, “N ba nyɛ yelsɔ̃ɔnaa jaa a wʊ 'yɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tɩchɛ a yɩ binfʊ lɛ ɩka n ma ir nɩrɛ a pɔɔfʊ die pɔ kʊ yɩ a Gõl Bar Difʊ daar. Yɩ bʊɔrɔ naa ɩka n yuo a yɩ nãa kʊ yɩ bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","A ba tãna 'yɛrɛ, “Kai, saa bʊɔrɔ wʊ ɛ, Barabasɩ lɛ sɩ bʊɔrɔ.” Tɩchɛ a Barabasɩ mɩ ɩn nɩkʊrɔ. ");
INSERT INTO biv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilate vɛ̃ naa ka ba nyɔɔ a Yesu chiin tɩ fɔb. ");
INSERT INTO biv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ka a sojasɩ de gʊʊr wob jupil su a Yesu, tɩ mɩ de fuu jã ile ile na ba su wʊ. ");
INSERT INTO biv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tɩ pãa ma tɔɔ ta a wʊ sɛ̃ 'yɛrɛ, “Sɩ puor fʊ naa Juu nɩbɛ nãa,” tɩ ma 'ma 'ma wʊ. ");
INSERT INTO biv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate lɛ yin wa a Juu nɩbɛrɛ sɛ̃ go wa 'yɛr kʊ ba, “Yɩ nyɛ, ɩn vɛ̃n ka ba yi waan wʊ, ka yɩn mãɛ nyɛ ɩka, n ba nyɛ yelbier jaa a wʊ 'yɔ̃ɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ban wa yin a Yesu, wʊ sun a gʊʊr jupil nɩ a fuu jã ile ile 'lɔ, ka a Pilate 'yɛr kʊ ba, “Yɩ nyɛ a daba.” ");
INSERT INTO biv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","A bɔɔrlo nɩbɛrɛ nɩ a puorfʊ yir gugurbo, ban wa nyɛ a Yesu, ka ba tãna 'yɛrɛ, “Kpa wʊ a daa ju. Kpa wʊ a daa ju.” Tɩchɛ ka a Pilate 'yɛr kʊ ba, “Yɩn, yɩ de wʊ tɩ kpa wʊ a daa ju, maa 'lɔ n ba nyɛ yelbier jaa a wʊ 'yɔ̃ɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tɩchɛ ka a Juu nɩbɛrɛ 'yɛr, “Sɩ tara na nɛɛ, sɩn 'yɛr, ka a nɛɛ 'lɔ ɩka wʊ sɛɛn kũu, bojũu wʊ bʊɔlɔ naa wʊ mãɛ Nãaŋmɩn Bie.” ");
INSERT INTO biv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilate na wõ a nɩtɔ̃ ka dãbãɛ gba kpɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ka wʊ lɩɛb kpɛ na wʊ tɩ sʊʊr a Yesu, “Nyɩnɛ fʊ yi?” Tɩchɛ Yesu ba haa nɛɛ sɔɔ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","A Pilate sʊʊr wʊ, “Faa haar ma nɛɛ ɛ? Faa bɔ̃ɔ ɩka n tara na sɔr na vɛ̃ ka ba kʊ fʊ, naa lɛ tara sɔr na faar fʊ bar ɛ?” ");
INSERT INTO biv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Be lɛ a Yesu 'yɛr wʊ, “Faa tara kpɛ̃ɔ bãlãa jaa a n jie ɛ, ala ɩ Nãaŋmɩn ba de yin saaju kʊ fʊ ɛ. A lɛ jũu nɩrɛ 'lɔ na nyɔɔ ma wa kʊ fʊ, wʊ lon yeldɛɛr pɔ gar fʊ.” ");
INSERT INTO biv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","An yi a be chiine, ka Pilate pãa mʊɔrɔ ɩka wʊ faar a Yesu, tɩchɛ ka a Juu nɩbɛrɛ tãna 'yɛrɛ, “Fʊ̃ʊ vɛ̃ ka a daba nyã chen, faa ɩ a Siisa baraa go ɛ. Nɩrɛ jaa na ɩka nãa lɛ wʊ ɩ, wʊ jɛɛrɛ nɩ naa a Siisa.” ");
INSERT INTO biv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilate na wõ a nɩtɔ̃, wʊ yin naa Yesu tɩ jãnɛ nɩ a 'yɛr tɔɔrfʊ dakɔɔ ju, a jie ban bʊɔlɔ Kʊsɩpãn. Ka a Juu nɩbɛrɛ mɩ bʊɔlɔ a jie Gabata. ");
INSERT INTO biv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A Gõl Bar Difʊ bãnsɩ daar mɔ̃tɔ̃tuo sɔ̃ɔ, Pilate 'yɛr kʊ a Juu nɩbɛrɛ, “Yɩ nyɛ a yɩ nãa.” ");
INSERT INTO biv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tɩchɛ ka ba tãna 'yɛrɛ, “Kʊ wʊ. Kʊ wʊ. Kpa wʊ yɔɔl a daa ju.” Ka a Pilate sʊʊr ba, “N kpa a yɩ nãa?” A ba 'yɛrɛ, “Saa tara nãa jaa ka nãa Siisa ba lɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ka Pilate vɛ̃ a ba nyɔɔ a Yesu chiin na tɩ kpa ka a sojasɩ tara wʊ. ");
INSERT INTO biv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu yin tuo a wʊ mãɛ daa chiin a jie 'lɔ ban bʊɔlɔ a Julaa Jie. Tɩchɛ ka a Juu nɩbɛ mɩ bʊɔlɔ a jie, Gɔlgɔta. ");
INSERT INTO biv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Be lɛ ba kpa wʊ 'matãan nɩbɛ ayi, ka bala be a lõbobo tɩchɛ ka a Yesu be a sãlsɔɔ. ");
INSERT INTO biv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate sɛb sɛbie 'mar a daa ju ɩka, YESU NA YI NAJARETƖ, A JUU NƖBƐ NÃA. ");
INSERT INTO biv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kɔkɔɛ ata lɛ wʊ sɛb, a Juu nɩbɛ kɔkɔr, Worom nɩbɛ kɔkɔr nɩ a Greek dẽme kɔkɔr. Ka a Juu nɩbɛ yɔɔ kar a sɛbie bojũu a jie ban kpa wʊ ba jãan a yir ɛ. ");
INSERT INTO biv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ka a bɔɔrlo nɩbɛrɛ 'yɛr kʊ a Pilate, “Ta sɛb ɩka a Juu nɩbɛ nãa ɛ, fʊn taa sɛb ɩka a daba nyã 'yɛr ɩka 'lɔ lɛ ɩ a Juu nɩbɛ nãa.” ");
INSERT INTO biv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ka a Pilate 'yɛr, “A lɛ ɩn sɛb n sɛb baar.” ");
INSERT INTO biv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","A sojasɩ na wa kpa a Yesu baar, ba põn a wʊ fuusɩ jiir anaar ka ãsʊɔ jaa 'mɔɔ wʊ bon. A wa chɛn a fuu wõo 'lɔ na ba tara nɛɛ ɛ, bʊ̃bʊ̃'yen lɛ ba wob yin a saaju tɩ baar a gbɛɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ka ba 'yɛrɛ kʊrɔ taa, “Yɩ ta ɩ a sɩ chɩɛr a fuu nyã ɛ, yɩ ɩ a sɩ gba gbãm kaa an lɛ na di?” Ba ɩn a lɛ ka a ala na sɛb a Nãaŋmɩn gãn pɔ na ɩ yelmãɛ, “Ba põn a n fuur tɩ de a n fuu gbãn gbãm.” Lɛ lɛ a sojasɩ ɩ. ");
INSERT INTO biv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu ma nɩ a wʊ ma yɛbɛ, Klopasɩ pɔɔ Mɛɛr nɩ a Mɛɛr 'lɔ mɩ na yi a Magdala ara naa be a wʊ daa par. ");
INSERT INTO biv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","A Yesu na nyɛ a wʊ ma na ara, ka a poturo 'lɔ wʊn nʊ̃ mɩ ara gbʊr wʊ, ka wʊ 'yɛr kʊ a ma, “A fʊ bie lɛ a 'lɔ.” ");
INSERT INTO biv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Na wʊ mɩ 'yɛr kʊ a poturo 'lɔ mɩ, “A fʊ ma lɛ.” Ala lɛ so ka a poturo 'lɔ tara a Yesu ma kul a wʊ yir. ");
INSERT INTO biv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu bɔ̃ɔn naa pʊ̃pãanyã ɩka yele a jaa pãa baar naa ka a lɛ na sɛb a Nãaŋmɩn gãn pɔ, na ɩ yelmãɛ, ka wʊ 'yɛr, “Kɔ̃nyũur kpɛ ma naa.” ");
INSERT INTO biv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Dʊʊ ben be ka a dãmiir sɛɛ ka ba de sapɔ 'lɔr ir chab urbanyũu daa pɔ tur a Yesu. ");
INSERT INTO biv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wʊn wa mʊʊr a dãmiir ala baar, ka wʊ 'yɛr, “A baar naa,” tɩ sur a ju na wʊ ŋmaa a vʊʊr. ");
INSERT INTO biv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A bɩbir chiiraa Chɔɔrfʊ Bɩbir Daar lɛ ka a wɛr na chaar ɩ Bɩbir Kpɛ̃ɛ, ala lɛ so ka a Juu nɩbɛ ba bʊɔrɔ ɩka a kũn a chɛnɛ be a daar jur ɛ. Ba sʊɔr a Pilate ɩka wʊ vɛ̃ ka ba kar a ba gbɛɛ tɩ yɔɔ ba. ");
INSERT INTO biv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Be lɛ a sojasɩ chen tɩ kar a bala ban lɔ̃ɔ kpan a Yesu gbɛɛ. ");
INSERT INTO biv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tɩchɛ ban wa ta a Yesu sɛ̃, ba nyɛn ka a ɩ wʊ kpi naa ka baa kar a wʊ gbɛɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ka a sojasɩ ãsʊɔ de a pĩi wõo 'lɔ chɔr a Yesu lõboor ka jãɩ nɩ kʊ̃ɔ yi ajienaa. ");
INSERT INTO biv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","A nɩrɛ 'lɔ na nyɛ a anyãna lɛ di a dãasɩɛ, ka wʊ dãasɩɛ ɩ yelmãɛ. Wʊ bɔ̃ɔ naa ɩka a lɛ wʊn 'yɛr ɩn yelmãɛ, ka yɩ mɩ na sɔɔ de. ");
INSERT INTO biv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","A anyãna ɩ naa ka a lɛ na sɛb a Nãaŋmɩn gãn pɔ ɩ yelmãɛ ɩka, “A wʊ kɔɔr kʊ̃ kab ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ka ba lɛ sɛb a Nãaŋmɩn gãn jie ãsʊɔ ɩka, “Ban kaa naa a 'lɔ ban chɔr.” ");
INSERT INTO biv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","A Josefʊ na yi Arimatɩya, ɩ naa a Yesu poturo, tɩ a Juu nɩbɛrɛ dãbãɛ jũu, waa dɔ̃ɔ vɛ̃ ka ba bɔ̃ɔn ɛ. 'Lɔ lɛ sʊɔr a Yesu a Pilate sɛ̃. Pilate sɔɔ naa ka wʊ tɩ yɔɔ a Yesu. ");
INSERT INTO biv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","A 'lɔ nɩ a Nikodimasɩ nyã na dɔ̃ɔ chen a Yesu sɛ̃ a tãsɔɔ pʊɔ wʊ naa, na wʊ mɩ waan a kãnyũur ala ban bʊɔlɔ sɩmura nɩ alosɩ. An tãn nũgbulo lɩjaata nɩ pie nɩ a nũu (75). ");
INSERT INTO biv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","A ba jaa ayi den a Yesu vil wʊ a fɔpɩla tɩ jɛ wʊ a kãnyũu ala tu a lɛ a Juu nɩbɛ na ma ɩ tɩ ũu a nɩrɛ. ");
INSERT INTO biv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","A jie 'lɔ ban kpa a Yesu, pobile ben be, ka yaa paalaa mɩ ban ba ũu nɩrɛ jaa ɛ, mɩ be be. ");
INSERT INTO biv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bojũu an ɩ a bɩbir chiiraa Chɔɔrfʊ Bɩbir Daar lɛ, tɩchɛ ka a yaa mɩ gbʊr a be jũu, ba ũun a Yesu a be. ");
INSERT INTO biv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","A daa gbul bɩbir dɔ̃ɔ daar wɛr na chaara wa la la la, Mɛɛr na yi a Magdala chen naa a yaa par tɩ nyɛ ka ɩ a kʊsɩr 'lɔ ban pɔɔ a yaa yuo naa. ");
INSERT INTO biv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wʊ jon chen a Simon Pita nɩ a poturo 'lɔ a Yesu na nʊ̃ sɛ̃ tɩ 'yɛr, “Ba ir naa a Soro ãgãn a yaa pɔ, ka saa bɔ̃ɔ a jie ban bin wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ka a Pita nɩ a poturo yi na chen a yaa par. ");
INSERT INTO biv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ba jaa 'mantaa joro, tɩchɛ ka a poturo 'lɔ jo vɩɛ a Pita bar tɩ de nie ta a yaa par. ");
INSERT INTO biv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Na wʊ muul nyɛ a fɔpɩla 'lɔ na gã, tɩ waa kpɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Be lɛ ka a Pita na turo a puor mɩ ta, na wʊ kpɛ a yaa pɔ, na wʊ nyɛ a fɔpɩla mɩ na gã. ");
INSERT INTO biv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ka a fɔ-ũu naa 'lɔ ban vil a Yesu ju mɩ pil yi a fɔpɩla pɔ gã wʊ yõ. ");
INSERT INTO biv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","A poturo 'lɔ na dɔ̃ɔ de nie ta a yaa par mɩ pãa kpɛ, na wʊ nyɛ a lɛ tɩ sɔɔ de. ");
INSERT INTO biv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Baa na bɔ̃ɔ a par sɛrɛ ɛ, ɩka lɛ a Nãaŋmɩn gãn na 'yɛr ɩka a Yesu na ir naa a kũu pɔ, ɩ vʊr ɛ. ");
INSERT INTO biv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","A poturbo ayi bala lɩɛb kul a ba taaba sɛ̃. ");
INSERT INTO biv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tɩchɛ ka a Mɛɛr ara a yaa par kõnõ. Wʊ kõn wa muul kaa a yaa pɔ, ");
INSERT INTO biv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","na wʊ nyɛ a malakasɩ ayi na su fuu pɩɛl be a yaa pɔ, ka a ãsʊɔ jãnɛ a ju jie, ka a ãsʊɔ mɩ jãnɛ a gbɛɛ jie, a jie ban dɔ̃ɔ gaal a Yesu. ");
INSERT INTO biv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ka ba sʊʊr wʊ, “Pɔɔ, bãa 'yɔ̃ɔ lɛ fʊ kõnõ?” A wʊ 'yɛr ba, “Ba ir naa a n Soro, ka n ba bɔ̃ɔ a jie ban bin wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A nɩtɔ̃ wʊn 'yɛr, tɩ lɩɛb nyɛ a Yesu na ara, tɩchɛ waa bɔ̃ɔ ɩka 'lɔ lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ka Yesu sʊʊr wʊ, “Pɔɔ, bãa 'yɔ̃ɔ lɛ fʊ kõnõ? An lɛ fʊ bʊɔrɔ?” Mɛɛr tɩɛr naa ɩka a jikaara lɛ, tɩ 'yɛr, “Nɩkpɛ̃ɛ, ala ɩ fʊ̃ʊ lɛ ir wʊ, wiil ma a jie fʊn bin, ka n chen tɩ 'mɔɔ wʊ.” ");
INSERT INTO biv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","A Yesu bʊɔl, “Mɛɛr!” Ka wʊ lɩɛb 'yɛr nɩ a Juu nɩbɛ kɔkɔr, “Woroboni.” A par lɛ, Wiwile. ");
INSERT INTO biv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","A Yesu 'yɛr, “Ta gɔɔ ma ɛ, n ba chen a n Sãa sɛ̃ sɛrɛ ɛ. Chen a n poturbo sɛ̃ tɩ 'yɛr ba, n lɩɛb chiine a n Sãa Nãaŋmɩn mɩ na ɩ a yɩ Sãa Nãaŋmɩn sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ka a Mɛɛr na yi a Magdala chen a poturbo sɛ̃ tɩ 'yɛr, “N nyɛn a Soro,” na wʊ mɩ man a ala a Yesu na 'yɛr kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A daa gbul bɩbir dɔ̃ɔ daar jãanʊɔr, a poturbo lɔ̃ɔn taa a die pɔ, tɩ kpal a pãma a Juu nɩbɛ dãbãɛ jũu. A Yesu tɩ kpɛ ara a ba sɛ̃ tɩ puor ba 'yɛr, “Nyã'maar wʊ be a yɩ sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wʊn 'yɛr a nɩtɔ̃, wʊ wiil ba naa a nuur nɩ a lõboor. Nʊ̃ɔ kpɛ̃n a poturbo ban nyɛ a Soro. ");
INSERT INTO biv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu lɛ 'yɛr kʊ ba go, “Nyã'maar wʊ be a yɩ sɛ̃, lɛ a Sãa na tʊ̃ ma, lɛ lɛ n mɩ tʊ̃nɔ̃ yɩ.” ");
INSERT INTO biv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tɩ pãa vʊʊr 'yɔ̃ɔ ba tɩ 'yɛr, “Yɩ de a Nãaŋmɩn Sɩɛ.” ");
INSERT INTO biv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ala ɩ yɩ vɛ̃n nɩrɛ yeldɛɛr bar, Nãaŋmɩn mɩ na vɛ̃n bar wʊ. Ala ɩ yaa mɩ wa vɛ̃ bar ɛ, Nãaŋmɩn mɩ kʊ̃ vɛ̃ bar ɛ. ");
INSERT INTO biv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasɩ ban lɛ bʊɔlɔ Naa na ɩ a Poturo Pie Nɩ Ayi ãsʊɔ ba dɔ̃ɔ be be a Yesu na wa ɛ. ");
INSERT INTO biv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ka a poturbo bala na be be nyɛ a Yesu 'yɛr kʊ wʊ, “Sɩ nyɛn a Soro,” tɩ wʊ 'yɛr, “Maa ba nyɛ a natɩɛ a wʊ nũu pɔ ɛ, naa de a n nubir tũ a kpafʊ jie ɛ, naa mɩ lɛ de nũu tũ a lõboor bɔɔ pɔ ɛ, n kʊ̃ sɔɔ de jaa ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","A ber aniin daar, a wʊ poturbo ba jaa lɛ lɔ̃ɔn taa a yir pɔ, ka a Tomasɩ mɩ be be. A pãma kpal naa, tɩchɛ ka a Yesu wa ara a ba sɛ̃ puor ba tɩ 'yɛr, “Nyã'maar wʊ be a yɩ sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tɩ pãa 'yɛr kʊ a Tomasɩ, “Tur a fʊ nubir a ka, nyɛ a n nuur na fʊ tur a fʊ nũu su a n lõboor bɔɔ pɔ, na fʊ bar a baal tɩ sɔɔ de.” ");
INSERT INTO biv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ka a Tomasɩ 'yɛr, “N Soro nɩ n Nãaŋmɩn.” ");
INSERT INTO biv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","A Yesu pãa sʊʊr wʊ, “Fʊn nyɛ ma jũu lɛ fʊ sɔɔ de ɔ? Pʊpɛl dẽme lɛ a bala na ba nyɛ ɛ, tɩ sɔɔ de.” ");
INSERT INTO biv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu tʊ̃n nɛ'maa tʊ̃ yɔɔ a wʊ poturbo niem, ban ba sɛb 'yɔ̃ɔ a gãn nyã pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tɩchɛ a anyãna sɛb naa ka yɩn sɔɔ de ɩka, a Yesu lɛ a Nɩ-iraa, na ɩ a Nãaŋmɩn Bie. Yɩn sɔɔ de jũu, yɩn tara naa nyɛvʊr yin a wʊ yuor pɔ. ");
INSERT INTO biv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","A anyã puor, Yesu lɛ ir wʊ mãɛ wiil kʊ a wʊ poturbo be a Tiberiyas man pɔ. Nɩtɔ̃ lɛ a tu. ");
INSERT INTO biv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Pita, Tomasɩ ban bʊɔlɔ Naa, Natanɩɛl na yi Keena na be a Galilee paal pɔ, Jebedee bibiir ayi pʊɔn a poturbo ayi bamɩne 'mantaa. ");
INSERT INTO biv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ka a Simon Pita 'yɛr kʊ ba, “Maa chiine naa jãmɛ nyɔɔrfʊ jie.” Ka ba mɩ 'yɛr, “Sɩn 'mantaa chen!” Ba yin kpɛ a gboro chen, tɩchɛ a tãsɔɔ 'lɔ̃nɔ̃ baa nyɔɔ bon ɛ. ");
INSERT INTO biv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bibio pipi Yesu ben a gogoro ju ara, tɩchɛ a poturbo ba bɔ̃ɔ ɩka 'lɔ lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ka wʊ bʊɔl ba sʊʊr, “Barmɩne, yaa nyɔɔ jãm ɛ?” Ka ba 'yɛr “Kai.” ");
INSERT INTO biv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","A Yesu 'yɛr ba, “Yɩ lɔb a lɔyaar 'yɔ̃ɔ a gboro nũsʊ̃ɔ jie, yɩn nyɔɔr amɩne.” Ban lɔb a lɔyaar 'yɔ̃ɔ, baa lɛ tʊ̃ɔnɔ̃ tɔɔrɔ ɛ, bojũu wʊ nyɔɔr jãyɔɔ. ");
INSERT INTO biv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ka a poturo 'lɔ a Yesu na nʊ̃ 'yɛr kʊ a Simon Pita, “A sɩ Soro lɛ.” A lɛ a Pita na wõ ɩka, “A sɩ Soro lɛ,” wʊ sun a fuu wʊn dɔ̃ɔ yaa bar na wʊ ɔɔ lon a kʊ̃ɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ka a poturbo ba nyã na chɛ turo nɩ a gboro tɔɔrɔ a lɔyaar na sɛɛn a jãmɛ. Baa jãan a gogoro ɛ, an ɩn gbɛɛ kɔɔr ata (300). ");
INSERT INTO biv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ban wa do a gogoro ju, ba nyɛn saalaa bũu jãmɛ na be be nɩ paanʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","A Yesu 'yɛr kʊ ba, “Yɩ ir a jãmɛ ala yɩn nyɔɔr a pʊ̃pãanyã amɩne waan.” ");
INSERT INTO biv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ka a Simon Pita kpɛ a gboro pɔ, tɩ tɔɔ a lɔyaar na sɛɛn a jãbɛrɛ don a gogoro ju. A ɩn jãmɛ kɔbaa lɩjaayi nɩ pie nɩ ata (153), an ɩ a yɔɔ a lɛ, tɩchɛ a lɔyaar ba chɩɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","A Yesu 'yɛr kʊ ba, “Yɩ wa suor nɛɛ.” Tɩ a poturbo ãsʊɔ jaa ba 'la sʊʊr wʊ ɩka, “An lɛ fʊ ɩ?” Ba jaa bɔ̃ɔn naa ɩka a Soro lɛ. ");
INSERT INTO biv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu ir a paanʊ̃ɔ na wʊ kʊ ba, tɩ lɛ ir a jãmɛ mɩ kʊ ba. ");
INSERT INTO biv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","A nyã lɛ ɩ gbɛɛ ata Yesu na ir a wʊ mãɛ wiil a poturbo wʊn ir a kũu pɔ ɩ vʊr. ");
INSERT INTO biv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ban di baar ka Yesu sʊʊr a Simon Pita, “Simon, Jɔɔn bie, fʊ nʊ̃ man gar a banyãna ɔ?” Ka wʊ 'yɛr, “Ɔ̃ɔ, n Soro, fʊ bɔ̃ɔ naa ɩn nʊ̃ fʊ.” A Yesu 'yɛr wʊ, “Kʊrɔ a n pelsɩ a bʊ̃diir.” ");
INSERT INTO biv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu lɛ sʊʊr go, “Simon, Jɔɔn bie, fʊ nʊ̃ man sɩrɛ jaa?” Ka wʊ 'yɛr, “Ɔ̃ɔ, n Soro, fʊ bɔ̃ɔn naa ɩn nʊ̃ fʊ.” Ka a Yesu 'yɛr kʊ wʊ, “Bɔ̃ɔ kaara ma a piir.” ");
INSERT INTO biv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu lɛ sʊʊr wʊn gbɛɛ ata, “Simon Jɔɔn bie, fʊ nʊ̃ ma naa?” Ka a Pita pʊɔ sɔ̃ɔ bojũu gbɛɛ ata nɩ nyã a Yesu na sʊʊr wʊ, ɩka wʊ, “Nʊ̃ wʊ naa?” Tɩ 'yɛr, “N Soro fʊ bɔ̃ɔn yele a jaa, fʊ bɔ̃ɔ naa ɩn nʊ̃ fʊ.” A Yesu 'yɛr kʊ wʊ, “Kʊrɔ ma a piir bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yelmãɛ lɛ n 'yɛrɛ kʊrɔ fʊ, a fʊ pɔlbile daar fʊ mãɛ ma sun fʊ fuusɩ na fʊ chiin jie 'lɔ jaa fʊn bʊɔrɔ. Tɩchɛ fʊ̃ʊ wa kor baar, fʊ ma jãn a nuur ka nɩrɛ kɔ̃ɔ su fʊ a fuu tɩ tɔɔ fʊ chiin a jie 'lɔ fʊn ba bʊɔrɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu 'yɛr a nɩtɔ̃ na wʊ wiil a kũu 'lɔ tɔ Pita na wa kpi 'yɔ̃ɔ Nãaŋmɩn yuor tɩɩr. Tɩ pãa 'yɛr kʊ a Pita, “Turo ma.” ");
INSERT INTO biv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita lɩɛb nyɛ a poturo 'lɔ a Yesu na nʊ̃ ka wʊ turo ba. A poturo nyã lɛ dɔ̃ɔ dɩɛl a Yesu lɛ ban dire a di baaraa, na dɔ̃ɔ sʊʊr a Yesu, “N Soro, an lɛ na gar 'yɔ̃ɔ fʊ?” ");
INSERT INTO biv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita na nyɛ wʊn turo ba, ka wʊ sʊʊr, “N Soro, tɩ nyã mɩ?” ");
INSERT INTO biv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","A Yesu 'yɛr, “Maa nʊ̃ ɩka wʊ be be tɩ tãn ɩn na lɩɛb wa, a ɩ bo a fʊ sʊrɔ? Fʊ̃ʊ turo ma.” ");
INSERT INTO biv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A anyãna jũu lɛ a poturbo 'yɛr yʊɔrɔ nɩ ɩka a poturo 'lɔ kʊ̃ kpi ɛ. Tɩchɛ Yesu ba 'yɛr ɩka wʊ kʊ̃ kpi ɛ, wʊ 'yɛr ɩka, “Maa nʊ̃ ɩka wʊ be be tɩ tãn ɩn na lɩɛb wa, a ɩ bo a fʊ sʊrɔ?” ");
INSERT INTO biv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A poturo nyãna lɛ di a anyãna dãasɩɛ na wʊ sɛb bin, ka sɩ bɔ̃ɔn a wʊ dãasɩɛ na ɩ yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu tʊ̃n tʊ̃yɔɔ mɩ, ala ɩ a jaa ta sɛb bʊ̃'yen 'yen, a wɛr wʊ jaa kʊ̃ naa tara jie bin a ala na sɛb ɛ.");
INSERT INTO biv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilusɩ a n gãn dɔ̃ɔ 'lɔ pɔ, n sɛb a ala a jaa a Yesu na dɔ̃ɔ piel maal tɩ na wʊ wiil a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Yesu tu naa a Nãaŋmɩn Sɩɛ pɔ na wʊ wiil a nɩtʊ̃nsɩ bala wʊn ir lɛ ban na ɩrɛ tɩ a Nãaŋmɩn de wʊ don a saaju. ");
INSERT INTO biv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A wʊ dɔɔyɛ difʊ puor, wʊ wiil wʊ mãɛ kʊ a nɩbɛ banyãna, ka a chaar ba nie ɩka wʊ ir naa na wʊ ɩ vʊr. A ber lɩjaayi daar lɛ wʊ wa dũu ba, na wʊ 'yɛr a Nãaŋmɩn nãalʊ̃ʊ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wʊn wa lɔ̃ɔn ba ka ba 'mataa dire, ka wʊ kpãkpãan ba nɩ a 'yɛr bir nyã, “Yɩ taa ɩrɛ wa yire a Jerusalɛm ɛ, yɩ chɛlɛ a kʊfʊ 'lɔ a n Sãa na põl ka n 'yɛr kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jɔɔn 'lɔ, kʊ̃ɔ lɛ wʊ de son a nɩbɛ, tɩchɛ yɩn 'lɔ, a kʊ̃ lɛ kor ɛ, Nãaŋmɩn na so yɩ naa nɩ a wʊ Sɩɛ.” ");
INSERT INTO biv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ba lɛ wa lɔ̃ɔn naa a Yesu go, na ba sʊʊr wʊ, “Sɩ Soro, a sɔ̃ɔ nyãna pɔ lɛ fʊn lɩɛb a Isɩral nãalʊ̃ʊ kʊ ba bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A wʊ 'yɛr kʊ ba, “A ba ɩ yɩ 'yɛr ɛ, ɩka yɩ bɔ̃ɔ a sɔ̃ɔ bɩɩ a bɩbir a Sãa na bin a wʊ kpɛ̃ɔ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tɩchɛ yɩn nyɛn kpɛ̃ɔ a Nãaŋmɩn Sɩɛ wa wa a yɩ sɛ̃, ka yɩ ɩ a n dãasɩɛ dẽme, a Jerusalɛm, nɩ a Judiya paal wʊ jaa, nɩ a Samariya paal tɩ tãn a wɛr tɛɛfʊ jie.” ");
INSERT INTO biv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","A anyãna lɛ wʊ 'yɛr baar tɩ duoro a saaju a lɛ nɛ a ba nɩbiru ka a julõjuur tɩ pɔɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ka ba chɛnɛ dʊl kaara a saaju a lɛ nɛ wʊn duoro, be lɛ a dɔɔr ayi na su fuu pɩɛl wa dũu ba a lɛ nɛ ara a ba sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na ba sʊʊr ba, “Galilee dɔɔr, bãa lɛ so a yɩ kaara a saaju a lɛ mɔ̃? A Yesu nyãna nɩ wʊ ju yɩn nyɛ na duoro a saaju, na lɩɛb a lɛ nɛ nɩ wʊ ju wa, nɩtãa a lɛ nɛ yɩn nyɛ wʊn duoro a saaju.” ");
INSERT INTO biv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","A ba yi a tɔ̃ɔ ban bʊɔlɔ a Olive Tɩɩr Tɔ̃ɔ lɩɛb kul a Jerusalɛm na ba jãan a tẽe ɛ, a fʊn tʊ̃ɔ chen a Pɛ̃nfʊ Bɩbir Daar. ");
INSERT INTO biv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ban wa ta, ba don a bɔɔpɩɛ pɔ, be lɛ ba dɔ̃ɔ lɔ̃ɔ taa. Ka a bala na dɔ̃ɔ be be lɛ Pita, Jɔɔn, Jemesɩ nɩ Andiru. Filip, Tomasɩ, Batolomi nɩ Matiu nɩ Alfayasɩ bidaba Jemesɩ nɩ Simon na mʊ̃ɔ nɩbir nɩ a wʊ wɛr yele, nɩ a Jemesɩ bidaba Judas. ");
INSERT INTO biv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","A banyãna ba jaa lɛ lɔ̃ɔ taa nɩ nɛbʊ̃'yen sʊɔrɔ a Nãaŋmɩn, ka a pɔbɔ bamɩne pʊɔ ba ka a Yesu yɛɛr nɩ a wʊ ma Mɛɛr mɩ be be. ");
INSERT INTO biv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Bɩbir ãsʊɔ lɛ a wʊ poturbo wa lɔ̃ɔ taa na ba ɩ nɩbɛ kɔbaa dɔɔl lɩjɛr. Ka Pita ir ara a ba pɔ ");
INSERT INTO biv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","tɩ 'yɛr, “Yɛɛr, a sɛɛ naa ka sɩn maal a lɛ a Nãaŋmɩn Sɩɛ na dɔ̃ɔ tu a Nãa David nɛɛ pɔ, a wʊ 'yɛr na wʊ sɛb bin a kõr jaa nɩtãa lɛ a Judas nyã na dɔ̃ɔ de a nɩbɛ nie a ba wa nyɔɔ a Yesu. ");
INSERT INTO biv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Wʊ dɔ̃ɔ ɩ a sɩ ãsʊɔ na wʊ pʊɔ sɩ a tʊ̃mɔ̃ nyã pɔ.” ");
INSERT INTO biv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas putuyar wʊn nyɛ lɛ ɩka wʊ dãn wɛr, be lɛ wʊ chʊr ju pur ka a nyaba a jaa yi. ");
INSERT INTO biv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nɩrɛ jaa na be ka a Jerusalɛm lɛ wõ a 'yɛr nyã na ba bʊɔlɔ a jie a ba kɔkɔr pɔ ɩka, Akeldama. A par lɛ, Jãɩ Wɛr. ");
INSERT INTO biv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ka a Pita 'yɛr, “Nɩtɔ̃ lɛ a Nãa David sɛb a wʊ yiel gãn pɔ, ‘A wʊ jie wʊ lɩɛb dãlpʊɔ, ka a nɩrɛ jaa taa kpɩɛrɛ be ɛ,’ ka, ‘A nɩrɛ ãsʊɔ, wʊ de a wʊ jie.’ ");
INSERT INTO biv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“A lɛ jũu, nɩyuo lɛ sɩn ir ka a nɩnyɩnɛ ɩ a 'lɔ na dɔ̃ɔ pʊɔ sɩ 'mataa yʊɔrɔ nɩ a Yesu. ");
INSERT INTO biv_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Piel a Jɔɔn Nãaŋmɩn kʊ̃ɔ sofʊ sɔ̃ɔ wa tãn a sɔ̃ɔ nyã a Yesu na yi a sɩ sɛ̃ do a saaju. A nɩrɛ 'lɔ lɛ na pʊɔ sɩ dire a wʊ kũu pɔ irfʊ dãasɩɛ.” ");
INSERT INTO biv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Be lɛ ba tɩɛr 'yɔ̃ɔ nɩbɛ ayi. Josefʊ ban bʊɔlɔ Basabasɩ na ba lɛ bʊɔlɔ wʊ Jusɩtusɩ nɩ Matɩyasɩ. ");
INSERT INTO biv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Na ba pãa sʊɔrɔ Nãaŋmɩn 'yɛrɛ, “Sɩ Soro, fʊ̃ʊ lɛ bɔ̃ɔ nɩrɛ jaa pʊtɩɛr, wiil sɩ a nɩbɛ ayi banyãna ãsʊɔ fʊn na ir. ");
INSERT INTO biv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ka wʊn de a nɩtʊ̃nsɩ tʊ̃mɔ̃ jie a Judas na bar, tɩ chen a jie wʊn pʊɔ.” ");
INSERT INTO biv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","A ba pãa gba gbãm ka a gbãbie tɩ ir Matɩyasɩ a wʊ pʊɔ a nɩtʊ̃nsɩ pie nɩ bʊ̃'yen pɔ. ");
INSERT INTO biv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","A Pentikosɩ na wa ta, ba jaa ben a jibʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ajienaa lɛ ka a damfʊ na kaara fɩka sɛsɛkpɛ̃ɛ na furo yi a saaju wa sɛɛ a die 'lɔ pɔ ban jãnɛ. ");
INSERT INTO biv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Be lɛ ba nyɛ bũu 'lɩraa na ŋmara jaa pʊrpʊr dɔɔlɔ ãsʊɔ jaa bʊ̃'yen 'yenɩ. ");
INSERT INTO biv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ka ba jaa sɛɛn a Nãaŋmɩn Sɩɛ na ba piel 'yɛrɛ kɔkɔyor lɛ a Sɩɛ na kʊ ba. ");
INSERT INTO biv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A Juu nɩbɛ na joro a Nãaŋmɩn dãbãɛ na ba yi a tẽn tẽn wa kpɩɛrɛ a be a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ban wa wõ a gɔ̃mɔ̃ nyã, a nɩyɔɔ ba nyãna ba jaa wa lɔ̃ɔn taa na ba ɩ chĩcham, bojũu ãsʊɔ ma wõn ban 'yɛrɛ a wʊ kɔkɔr. ");
INSERT INTO biv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ka a ɩ yel dũu naa, na a 'maa ba jaa nɛɛ ka ba sʊrɔ taa, “A ba ɩ Galilee dẽme lɛ a banyãna na 'yɛrɛ ɛ? ");
INSERT INTO biv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tɩ ŋmɩnɛ a ɩ ka a sɩ ãsʊɔ jaa wõnõ ban 'yɛrɛ nɩ a sɩ kɔkɔɛ? ");
INSERT INTO biv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parti dẽme, Mede dẽme, nɩ a Elam dẽme. Bamɩne mɩ yin Mesopotamiya, Judiya, Kapadosiya nɩ Pontus nɩ Asɩya. ");
INSERT INTO biv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ka bamɩne mɩ yi Fɩrgɩya, nɩ Pamfiliya, nɩ Ijipitɩ, nɩ a Libiya dẽme na gbʊr a Sirenɩ wɛr nɩ a sãanba na yi a Worom, ");
INSERT INTO biv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","a Juu nɩbɛ mãɛ nɩ a bala na lɩɛb a Juu nɩbɛ, bamɩne yin Kɩrete nɩ a Arabɩya dẽme. Sɩ wõn ban de a sɩ mãɛ kɔkɔr 'yɛrɛ nɩ a Nãaŋmɩn tʊ̃bɛrɛ wʊn tʊ̃.” ");
INSERT INTO biv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ka a anyãna sɔb ba nɩbir ka ba nɛɛr 'maa a ba sʊrɔ taa, “A anyãna par nɩ bo?” ");
INSERT INTO biv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tɩchɛ ka a bamɩne kpɛrɛ 'yɛrɛ, “Dãa lɛ maal ba a lɛ nɛ.” ");
INSERT INTO biv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ka a Pita nɩ a Pie Nɩ Bʊ̃'yen pãa ir ara ka wʊ 'yɛr kpɛ̃ɔ jaa kʊ a nɩbɛ, “Juu nɩbɛ nɩ nɩrɛ jaa na kpɩɛrɛ ka a Jerusalɛm, yɩ vɛ̃ ka n wiil yɩ a par. Yɩ chɛlɛ a lɛ ɩn na 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","A nɩbɛ banyãna ba nyũ dãa ɛ, nɩtãa a lɛ yɩn tɩɛr ɛ, a chɛnɛ na ɩ bibi'maar. ");
INSERT INTO biv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nɩtɔ̃nɔ̃ lɛ a Nãaŋmɩn 'yɛ'yɛrɛ Joɛl dɔ̃ɔ 'yɛr, ");
INSERT INTO biv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nãaŋmɩn 'yɛr ɩka a ber baaraa daar, wʊn kpaaraa a wʊ Sɩɛ 'yɔ̃ɔ a nɩbɛ ba jaa. Ka a yɩ dabil nɩ a pɔɔbil 'yɛrɛ a 'yɛrsɩ ala a Nãaŋmɩn na kʊ ba, ka a yɩ dabil nyɛrɛ nyɛfʊsɩ, ka a yɩ danyɔ̃n mɩ jãna jãnsɩ. ");
INSERT INTO biv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","A bala gba na ɩ a n gbãgbadɔɔr nɩ a pɔbɔ, ba jaa pɔ lɛ ɩn kpaar a n Sɩɛ 'yɔ̃ɔ ba a ber ala pɔ, ka ba 'yɛrɛ a n 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ɩn wiil ban yelfɛrsɩ na yi saaju ka a jãnsɩ mɩ be ka a tẽe, jãɩ, bũu nɩ jʊʊr na den jie wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ka a mɔ̃tɔ̃ɔ lɩɛb lĩi ka a ŋmɛra mɩ lɩɛb jãɩ kaar tɩchɛ ka a sɩ Soro bɩbir 'lɔn na chaar pãa wa. ");
INSERT INTO biv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Be lɛ nɩrɛ jaa na pãa bʊɔlɔ a sɩ Soro yuor na nyɛn faafʊ.’ ");
INSERT INTO biv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Isɩral nɩbɛ yɩ chɛlɛ ka, A Yesu nyã na yi a Najaretɩ 'lɔ lɛ a Nãaŋmɩn ir kʊ yɩ, na wʊ de wʊ tʊ̃n a nɛ'maa tʊ̃mɔ̃, nɩ tʊ̃fɛrsɩ, nɩ jãnsɩ tʊ̃mɔ̃ a yɩ pɔ, ka yɩ mãɛ bɔ̃ɔn. ");
INSERT INTO biv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ba nyɔɔn a daba nyãna 'yɔ̃ɔ a yɩ nuur pɔ nɩtãa lɛ a Nãaŋmɩn na dɔ̃ɔ tu a wʊ bɔfʊ nɩ a wʊ bɔ̃ɔfʊ pɔ, de nie 'yɛr bin, ka a putudẽme sʊ̃ʊ yɩ ka yɩ kpa wʊ a daa ju a wʊ kpi. ");
INSERT INTO biv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tɩchɛ ka a Nãaŋmɩn sãɩ wʊ a kũu pɔ, na wʊ faa wʊ a kũu wõm pɔ, bojũu a kũu ba tara kpɛ̃ɔ na nyɔɔ wʊ taa lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“A Nãa David dɔ̃ɔ 'yɛr a wʊ 'yɛr, ‘Bɩbir jaa lɛ n nyɛrɛ a n Soro, bojũu wʊ ben a n nũsʊ̃ɔ jie, n kʊ̃ wa lɔɔ gbɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ala lɛ so ka n pʊɔ pɛl ka n jãlbir chɩlɛ, ka a n ãgãn mɩ tara tɩɛr tɔfʊ jie. ");
INSERT INTO biv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bojũu fʊ kʊ̃ wa bar ma be a yaa pɔ ɛ, bɩɩ ka fʊ bar a fʊ Chɛchɛ Sʊɔ 'lɔ ka wʊ pʊ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fʊ wiil man a nyɛvʊr sɔr, fʊn vɛ̃n ka nʊ̃ɔ kpɛ ma a fʊ niem.’ ");
INSERT INTO biv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“N yɛɛr, n 'yɛr chãa pɔ kʊ yɩ ɩka a sɩ sãakpã David kpi naa a ba ũu, a wʊ yaa lɛ anyãna na be ka dɩna. ");
INSERT INTO biv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tɩchɛ wʊ dɔ̃ɔ 'yɛr a lɛ a Nãaŋmɩn na tɩr nɛɛ kʊ wʊ ɩka, wʊn vɛ̃ naa ka 'lɔ David yɔ̃ɔ jãnɛ a wʊ nãa dakɔɔ ju. ");
INSERT INTO biv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David den nie nyɛ a lɛ na be a wʊ niem, ala lɛ so ka wʊ 'yɛr a Kɩrɩsɩto kũu pɔ irfʊ 'yɛr, na wʊ 'yɛr ɩka wʊ kʊ̃ gã be a yaa pɔ ɛ, bɩɩ ka a wʊ ãgãn pʊ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Nãaŋmɩn sãɩ naa a Yesu nyãna ka wʊ ir ɩ vʊr, sɩn lɛ ɩ a anyãna a jaa dãasɩɛ dẽme. ");
INSERT INTO biv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","'Lɔ lɛ wʊ 'mɔɔ don bin a wʊ nũsʊ̃ɔ jie, ka a Sãa kʊ a Yesu a wʊ Sɩɛ 'lɔ wʊn tɩr a nɛɛ kʊ wʊ. A Sɩɛ nyã lɛ wʊ kpaar 'yɔ̃ɔ sɩ ka yɩ nyɛ tɩ be wõnõ. ");
INSERT INTO biv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David ba dɔ̃ɔ do a saaju ɛ, tɩ wʊ 'yɛr naa, ‘A Soro 'yɛr kʊ a n Soro, “Jãnɛ a n nũsʊ̃ɔ jie, ");
INSERT INTO biv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ka n wa de a fʊ dɔ̃dẽme ka ba ɩ a fʊ gbɛɛ dɔɔlfʊ jie.” ’ ");
INSERT INTO biv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“A lɛ jũu, vɛ̃ ka a Isɩral nɩbɛ ba jaa bɔ̃ɔ sɩrɛ jaa ɩka Nãaŋmɩn maal naa Yesu nyã yɩn kpa a daa ju ka wʊ ɩ a sɩ Soro nɩ a Nɩ-iraa.” ");
INSERT INTO biv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","A nɩbɛ na wõ a nɩtɔ̃, ka a ŋmara ba a nyãn, ka ba sʊʊr a Pita nɩ a nɩtʊ̃nsɩ, “N yɛɛr, ŋmɩnɛ sɩn ɩ?” ");
INSERT INTO biv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ka a Pita 'yɛr kʊ ba, “Yɩ lɩɛb a yɩ tɩɛr, ka ba de a Yesu yuor son yɩ a Nãaŋmɩn kʊ̃ɔ, ka a yɩ yelbier baar. Ka a Nãaŋmɩn kʊ yɩ a wʊ Sɩɛ. ");
INSERT INTO biv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yɩn nɩ a yɩ bibiir lɛ a Nãaŋmɩn tɩr a wʊ nɛɛ kʊ, yɩn nɩ a bala ba jaa na be a tɛɛr, nɩ a bala ba jaa a sɩ Soro Nãaŋmɩn na wa bʊɔl.” ");
INSERT INTO biv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita den 'yɛr yɔɔ kpãan ba, na wʊ kpãkpãan ba 'yɛrɛ, “Yɩ faa yɩ mãɛ yin a dɩna nɩfɩlefɩlesɩ pɔ.” ");
INSERT INTO biv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ka a bala na sɔɔ de a wʊ 'yɛr, ba so naa a Nãaŋmɩn kʊ̃ɔ, ka nɩbɛ tur ata (3,000) pʊɔ ba a daar 'lɔ̃nɔ̃. ");
INSERT INTO biv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ba den ba mãɛ kʊ a nɩtʊ̃nsɩ wiilfʊ, na ba tara nɛbʊ̃'yen lɔ̃ɔ dire, na ba lɔ̃ɔ puoro a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Dãbãɛ kpɛ̃n nɩrɛ jaa a lɛ ban nyɛ ka a nɩtʊ̃nsɩ tʊ̃ a tʊ̃fɛrsɩ nɩ a nɛ'maa tʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A bala na sɔɔ de, ba jaa lɔ̃ɔn taa jibʊ̃'yen na ba sʊ̃nɔ̃ taa. ");
INSERT INTO biv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Na ba daara a ba bʊ̃tarsɩ na ba ma põ ir kʊ taa lɛ jaa ãsʊɔ na bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bɩbir jaa lɛ ba ma lɔ̃ɔnɔ̃ taa be a Nãaŋmɩn puorfʊ yir bɛchaar pɔ, na ba yʊɔrɔ taa yie ŋmara a paanʊ̃ɔ dire nɩ pʊpɛl nɩ pʊtɩɛr bʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ba pɛɛrɛ naa Nãaŋmɩn ka a nɩbɛ ba jaa mɩ ara a ba puor. A sɩ Soro ma vɛ̃ naa ka a bala na nyɛ faafʊ, pʊɔ ba bɩbir jaa. ");
INSERT INTO biv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Bɩbir ãsʊɔ Pita nɩ Jɔɔn duoro naa a Nãaŋmɩn puorfʊ yir kpɛ̃ɛ pɔ, a puorfʊ jie mɔ̃tɔ̃ɔ na gɔr. ");
INSERT INTO biv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ka a daba ban lɔ̃ɔ dɔɔn a wʊ gbɛr, a ba ma tuo wʊ tɩ bin a be a Nãaŋmɩn puorfʊ yir dɔ̃dɔr nɛɛ 'lɔ ban bʊɔlɔ, Vɩla. Be lɛ ba ma tuo wʊ tɩ bin bɩbir jaa a wʊ ma sʊɔrɔ a bala na kpɩɛrɛ a Nãaŋmɩn yir bɛchaar pɔ libie. ");
INSERT INTO biv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wʊn wa nyɛ a Pita nɩ a Jɔɔn na kpɩɛrɛ, a wʊ sʊɔrɔ ba a libir. ");
INSERT INTO biv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ka a Pita nɩ a Jɔɔn kaara wʊ a lɛ a tãɩɩ, ka a Pita wa 'yɛr, “Kaara sɩ.” ");
INSERT INTO biv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ka a daba tɔ̃ɔ fur a nɩbir a lɛ chir chir chir 'yɔ̃ɔ ba tɩɛrɛ ɩka wʊn nyɛn bon. ");
INSERT INTO biv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","A Pita pãa 'yɛr, “N ba tara libir bɩɩ, sɛlma kʊrɔ fʊ ɛ, tɩchɛ a 'lɔ ɩn tara lɛ ɩn kʊ fʊ. Yesu Kɩrɩsɩto na yi a Najaretɩ yuor pɔ, ir chiine.” ");
INSERT INTO biv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tɩ na wʊ nyɔɔ a daba nũsʊ̃ɔ sʊ̃ʊ wʊ ka wʊ ir ka a ɩ a gbɛpɛlɛ nɩ a nakɔɔtɩɛ kpɛ̃mɛ naa. ");
INSERT INTO biv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ka a daba ɔɔ chʊr a gbɛɛ na wʊ piel chiine, na wʊ pãa tu ba kpɛ̃n be a Nãaŋmɩn puorfʊ yir bɛchaar pɔ. Be lɛ wʊ tɩ ɔɔrɔ yʊɔrɔ na wʊ pɛɛrɛ a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","A nɩbɛ ba jaa na wa nyɛ wʊ, a lɛ wʊn chiine pɛɛrɛ a Nãaŋmɩn, ");
INSERT INTO biv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ba bɔ̃ɔ wʊ naa an ɩ 'lɔ lɛ ma jãnɛ sʊɔrɔ libie be a Nãaŋmɩn puorfʊ yir dɔ̃dɔr 'lɔ ban bʊɔlɔ a, Vɩla. Ka a ɩ ba chĩcham naa 'maa ba nɛɛ a lɛ na ɩ. ");
INSERT INTO biv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","An ɩ a daba chɛnɛ na pɔɔ a Pita nɩ a Jɔɔn ka a nɩbɛ nɛɛr 'maa a ba jo wa titaa a be ban bʊɔlɔ a Solomon Bɛchaar pɔ. ");
INSERT INTO biv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita na nyɛ a lɛ ka wʊ 'yɛr kʊ a nɩbɛ, “Isɩral dɔɔr woɩ, bãa lɛ so ka a nɛɛr 'maa yɩ a lɛ mɔ̃? Bãa lɛ yɩ fur a nɩbir 'yɔ̃ɔ sɩ fɩka sɩn mãɛ kpɛ̃ɔ bɩɩ sɩn mãɛ maal vɩla lɛ sɩ maal a daba nyã ka wʊ chiine? ");
INSERT INTO biv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","A Nãaŋmɩn nyã na ɩ a Abraham, Isaakɩ nɩ a Jekɔb Nãaŋmɩn nɩ a sɩ sãakpãmɩne Nãaŋmɩn lɛ 'yɔ̃ɔ a wʊ tʊ̃tʊ̃nɔ̃ Yesu yuor. Yɩn lɛ nyɔɔ wʊ tɩr ɩka ba kʊ wʊ, ka a Pilate ŋme nyãa na bar wʊ tɩ yɩ 'yɛr ɩka yaa bɔ̃ɔ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yɩ 'yɛr naa ɩka yaa bɔ̃ɔ a chɛchɛ sʊɔ nɩ a yelmãɛ sʊɔ ɛ, tɩ na yɩ sʊɔr ka ba yuo a nɩkʊrɔ kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yɩn lɛ kʊ a nyɛvʊr sʊɔ, tɩchɛ ka a Nãaŋmɩn sãɩ wʊ a kũu pɔ. Sɩn lɛ nyɛ anyãna nɩ nɩbir. ");
INSERT INTO biv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","A daba nyãna nɩ a sɩn na 'mataa sɔɔ a Yesu lɛ sa a daba nyãna baal yɩn nyɛ na yɩ bɔ̃ɔ, sɩrɛ jaa sɩn sɔɔ de a Yesu yuor lɛ wʊ sa, a daba nyãna yɩn ben nyɛ. ");
INSERT INTO biv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Pʊ̃pãanyã, yɛɛr, n bɔ̃ɔ naa ɩka ba bɔ̃ɔ fʊ lɛ vɛ̃ ka yɩ tʊ̃ a lɛ nɛ a yɩ nɩbɛrɛ na dɔ̃ɔ tʊ̃. ");
INSERT INTO biv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tɩchɛ Nãaŋmɩn ɩ naa a lɛ wʊn dɔ̃ɔ vɛ̃ ka a wʊ 'yɛ'yɛrbɛ 'yɛr ɩka, a wʊ Nɩ-iraa na din dɔɔyɛ. ");
INSERT INTO biv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yɩ pãa lɩɛb a yɩ tɩɛr, na yɩ lɩɛb wa a Nãaŋmɩn sɛ̃, ka wʊ fɩɛl a yɩ yeldɛbɛ bar. A ãkpɛ̃ɔ paalaa yɩn na nyɛ na yin a sɩ Soro sɛ̃, ");
INSERT INTO biv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ka wʊ gba na tʊ̃ a Yesu Kɩrɩsɩto 'lɔ wʊn dɔ̃ɔ ir bin kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wʊn chɛnɛ na jãnɛ be a saaju, tɩ tãn a sɔ̃ɔ 'lɔ Nãaŋmɩn na 'mataa a bonsɩ a jaa nɩtãa lɛ wʊn tɩr a nɛɛ a kõr jaa tu, a wʊ 'yɛ'yɛrbɛ chɛchɛsɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Bojũu Mosesɩ dɔ̃ɔ 'yɛr, ‘A Soro Nãaŋmɩn na ir 'yɛ'yɛrɛ a n kaar ka wʊ ɩ a yɩ mãɛ nɩrɛ, a yɩ chɛlɛ a ala a jaa wʊn na 'yɛrɛ kʊrɔ yɩ. ");
INSERT INTO biv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ɩ̃sʊɔ jaa ba wa chɛlɛ a lɛ wʊn na 'yɛrɛ ɛ, ban ir wʊ nũu bar a wʊ nɩbɛ pɔ.’ ");
INSERT INTO biv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Sɩrɛ jaa, a Nãaŋmɩn 'yɛ'yɛrbɛ ba jaa na yi a Samuwɛl sɔ̃ɔ mɩ 'yɛr naa a bɩbie anyãna 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yɩn lɛ ɩ a Nãaŋmɩn 'yɛ'yɛrbɛ banyãna bibiir nɩ a nɛtɩraa 'lɔ a Nãaŋmɩn na tara nɩ a sɩ sãamɩne. Wʊ 'yɛr kʊ a Abraham, ‘An tu naa a fʊ yɔn pɔ, ka a nɩbɛ ba jaa na be ka a tẽe na nyɛ sʊ̃ʊfʊ.’ ");
INSERT INTO biv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nãaŋmɩn na wa ir a wʊ tʊ̃tʊ̃nɔ̃, yɩn sɛ̃ lɛ wʊ de nie tʊ̃ wʊ ka wʊ tɩ sʊ̃ʊ yɩ na wʊ lɩɛb a yɩ ãsʊɔ jaa yin a wʊ putusɔr pɔ.” ");
INSERT INTO biv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","A lɛ a Pita nɩ a Jɔɔn na chɛnɛ 'yɛrɛ nɩ a nɩbɛ, a Juu nɩbɛ bɔɔrlorbo nɩ a puorfʊ yir nɩdiere 'matãan a Saduseemɩne wan a ba sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ba wa nyɛn suur, bojũu ba wile naa a nɩbɛ ɩka Yesu jũu nɩrɛ jaa na ir naa kũu pɔ. ");
INSERT INTO biv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Be lɛ ba nyɔɔ a Pita nɩ a Jɔɔn na ba 'yɔ̃ɔ ba pɔɔfʊ die pɔ bar ka wɛr na chaar, bojũu mɔ̃tɔ̃ɔ mʊr baar. ");
INSERT INTO biv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tɩchɛ a bala na wõ a lɛ a Pita na 'yɛr a Yesu 'yɛr na ba sɔɔ de na ɩn dɔɔr tur anũu (5,000). ");
INSERT INTO biv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","A wɛr na wa chaar, a ba nɩdierbe nɩ a ba nɩbɛrɛ 'matãan a Mosesɩ nɛɛ wiwiilbe lɔ̃ɔn taa be a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ka Anasɩ na ɩ a Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ nɩ Kayafasɩ, Jɔɔn nɩ Aleksanda 'matãan a Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ nɩbɛ bamɩne. ");
INSERT INTO biv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","A ba tɩ yuo a Pita nɩ a Jɔɔn waan a ba wa sʊrɔ ba, “Kpɛ̃ɔ buor nɩ yobuor lɛ yɩ de tʊ̃nɔ̃ nɩ a anyãna?” ");
INSERT INTO biv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ka a Pita na sɛɛn a Nãaŋmɩn Sɩɛ 'yɛr kʊ ba, “A yɩn nɩdierbe nɩ a yɩn nɩbɛrɛ, ");
INSERT INTO biv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ala ɩ yɩ ben bʊɔl sɩ dɩna ɩka sɩ wa man a maal vɩla nyã na vɛ̃ ka a gbɛrɛ sa. ");
INSERT INTO biv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yɩ pãa bɔ̃ɔ ɩka yaa, a yɩn nɩ nɩrɛ jaa na be a Isɩral, ɩka a Yesu Kɩrɩsɩto nyã na yi a Najaretɩ yuor pɔ, a 'lɔ yɩn kʊ a daa ju, tɩchɛ ka a Nãaŋmɩn sãɩ wʊ a kũu pɔ, ka wʊ ɩ vʊr, lɛ sa a daba nyãna na ben ara a kana. ");
INSERT INTO biv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Wʊ ɩ naa ‘A kʊsɩr 'lɔ a yɩn mɩmɩɛrbɛ na tɔr bar, 'lɔ lɛ wa ɩ a kʊsɩr ju.’ ");
INSERT INTO biv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Fafaara jaa ba lɛ be be ɛ, bojũu yuor jaa ba lɛ be ka a tẽe pɔ, na tʊ̃ɔ nɩrɛ faa ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ban nyɛ a lɛ a Pita nɩ a Jɔɔn na ba joro dãbãɛ ɛ, tɩ mɩ bɔ̃ɔn ban ba jãn gãn chen tɛɛr ɛ, ka nɛ'maa ba. Ka ba tɩɛrtɔ ban dɔ̃ɔ be a Yesu sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tɩchɛ ba mɩ nyɛn a daba 'lɔ na sa 'mataa ara nɩ ba, baa lɛ tara 'yɛr na 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Lɛ lɛ ba 'yɛr ba a ba yi chɛ̃chɛ̃ɛ, tɩ ba pãa guoro taa 'yɛrɛ, ");
INSERT INTO biv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ŋmɩnɛ lɛ sɩn ɩ a nɩbɛ banyãna? Nɩrɛ jaa na be ka a Jerusalɛm bɔ̃ɔn naa a nɛ'maa tʊ̃mɔ̃ ban tʊ̃ a sɩ kʊ̃ tʊ̃ɔ chiir ɛ. ");
INSERT INTO biv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tɩchɛ ala ɩ sɩn pɔɔ naa a yele nyãna sɔr ka nɩrɛ kʊ̃ lɛ wõ naa ɛ, yɩ ɩ a sɩ fuu ba ka ba taa ɩrɛ wa pʊrɔ a yuor nyãna kʊrɔ nɩrɛ jaa ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Be lɛ ba bʊɔl ba a ba kpɛ ka ba kpãkpãan ba ɩka, ba taa ɩrɛ wa 'yɛrɛ bɩɩ wile nɩ a Yesu yuor go ɛ. ");
INSERT INTO biv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tɩchɛ ka a Pita nɩ a Jɔɔn 'yɛr kʊ ba, “Yɩn mãɛ yɩ pɛ kaa, a sɛɛn Nãaŋmɩn sɛ̃ ka sɩn tu a yɩ nɛɛ gar a Nãaŋmɩn bɩɩ? ");
INSERT INTO biv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bojũu sɩn 'lɔ kʊ̃ tʊ̃ɔ bar a 'yɛr sɩn nyɛn nɩbir tɩ wõ 'yɛrfʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Lɛ lɛ ba vuur ba tɩ bar ba a ba chen. Baa bɔ̃ɔ kpãa buor lɛ ban kpãa ba ɛ, bojũu a nɩbɛ ba jaa pɛɛrɛ naa Nãaŋmɩn a lɛ na ɩ. ");
INSERT INTO biv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Bojũu a daba nyãna na sa a nɛ'maa safʊ nyãna kor gar yuomo lɩjaayi (40). ");
INSERT INTO biv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ban wa bar a Pita nɩ a Jɔɔn, ba chen a ba taaba sɛ̃ tɩ man ala a jaa a bɔɔrlo nɩbɛrɛ nɩ a nɩbɛrɛ na 'yɛr kʊ ba. ");
INSERT INTO biv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","A ba taaba na wõ a nɩtɔ̃nɔ̃, ba jaa 'mantaa nɩ nɛbʊ̃'yen puor Nãaŋmɩn na ba 'yɛrɛ, “Tʊ̃ɔnɔ̃ Sʊɔ, fʊ̃ʊ lɛ maal a saaju nɩ a tẽe nɩ a man kpɛ̃ɛ nɩ bon jaa na be a pɔ. ");
INSERT INTO biv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fʊ̃ʊ lɛ dɔ̃ɔ vɛ̃ ka a fʊ Sɩɛ haa a fʊ gbãgbaa na ɩ a sɩ sãa David nɛɛ ka wʊ 'yɛr, ‘Bo lɛ so ka a paalsɩ nyɛ suur, ka a nɩbɛ ŋmara a dɔɔl pɔrsɩ? ");
INSERT INTO biv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","A wɛr nãmɩne tʊɔrɔ naa gbɛchile, ka a nɩbɛrɛ mɩ lɔ̃ɔ taa jɛɛrɛ nɩ a Soro nɩ a fʊ Nɩ-iraa.’ ");
INSERT INTO biv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sɩrɛ jaa lɛ a Hɛrɔd nɩ a Pontius Pilate lɔ̃ɔ taa nɩ a bala na ba ɩ a Juu nɩbɛ ɛ, nɩ a Juu nɩbɛ a tẽe nyãna pɔ, na ba jɛb a fʊ tʊ̃tʊ̃chɛchɛ Yesu, a 'lɔ fʊn ir. ");
INSERT INTO biv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ba maal naa a lɛ fʊn kaa ir na ɩ a fʊ pʊtɩɛr, nɩ a fʊ kpɛ̃ɔ, nɩ a fʊ bɔfʊ fʊn dɔ̃ɔ de nie chɔɔr tɩ a wa ɩ. ");
INSERT INTO biv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Pʊ̃pãanyã sɩ Soro, kaa lɛ ban fuu sɩ, tɩ na fʊ sʊ̃ʊ a fʊ gbãgbaar a sɩ mʊɔl a fʊ 'yɛr nɩ 'lafʊ. ");
INSERT INTO biv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tur a fʊ nũu sãan baalsɩ, na fʊ tʊ̃ nɛ'maa tʊ̃mɔ̃ nɩ a fʊ tʊ̃tʊ̃chɛchɛ Yesu yuor.” ");
INSERT INTO biv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ban wa puor baar, a jie 'lɔ ban lɔ̃ɔ taa damaa. Ka ba jaa sɛɛn a Nãaŋmɩn Sɩɛ, na ba 'yɛrɛ a Nãaŋmɩn 'yɛr nɩ 'lafʊ. ");
INSERT INTO biv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ka a bala na sɔɔ de, ba jaa tara na tɩɛr bʊ̃'yen nɩ nyãbʊ̃'yen. Ɩ̃sʊɔ jaa maa 'yɛr ɩka a wʊ bonsɩ ɩ naa a 'lɔ tɛɛ bon ɛ, ba ma põn bon jaa ban tara. ");
INSERT INTO biv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","A nɩtʊ̃nsɩ den kpɛ̃ɔ mana nɩ a sɩ Soro Yesu kũu pɔ irfʊ 'yɛr, ka a Nãaŋmɩn wãɛfʊ be a ba jaa sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ba ãsʊɔ jaa ba dɔ̃ɔ faa bon ɛ, sɔ̃ɔ jaa lɛ a bala na tara por nɩ yie ma da na ba ma waan a libie, ");
INSERT INTO biv_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","wa bin a nɩtʊ̃nsɩ sɛ̃, ka ba ma põ ir kʊ ãsʊɔ jaa lɛ an sɛɛn wʊ. ");
INSERT INTO biv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Josefʊ na yi Sipurusɩ na wʊ ɩ a Levi bal nɩrɛ, kaa a nɩtʊ̃nsɩ bʊɔlɔ wʊ Banabasɩ. A par lɛ nɩrɛ na 'yɔ̃ɔnɔ̃ ãkpãɛn. ");
INSERT INTO biv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wʊ dãn a wʊ puo, na wʊ de a libie waan wa bin a nɩtʊ̃nsɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ka a daba ãsʊɔ na be be di Ananias ka a wʊ pɔɔ mɩ di Safira. Ba mɩ den a ba pobile da. ");
INSERT INTO biv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wʊ ir naa libie amɩne bin ka a pɔɔ bɔ̃ɔn, tɩchɛ na wʊ chiin a ŋmaa tɩ bin a nɩtʊ̃nsɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ka a Pita sʊʊr a Ananias, “Bo lɛ so ka a Satan sɛɛ fʊ a nyãa a fʊ ŋmaa jir kara yɔ̃ɔ a Nãaŋmɩn Sɩɛ, na fʊ ir a libie amɩne a lɛ fʊn da a puo bin? ");
INSERT INTO biv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","A ba ɩ fʊ̃ʊ lɛ so na fʊ de da ɛ? Fʊn wa da baar a ba ɩ fʊ̃ʊ lɛ so a libie ɛ? Bo lɛ ɩ a fʊ tɩɛr a fʊ maal a nɩtɔ̃? Nɩrɛ ba lɛ fʊ ŋmaa a jir nyã 'yɔ̃ɔ ɛ, tɩchɛ Nãaŋmɩn lɛ.” ");
INSERT INTO biv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias na wõ a nɩtɔ̃nɔ̃ na wʊ lo kpi a jie. Ka a dãbãɛ kpɛ a bala jaa na wõ naa. ");
INSERT INTO biv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ka a pɔlbil ir a ba pɔ 'mɔɔ a kũu lũ tuo yin tɩ ũu. ");
INSERT INTO biv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","An wa kor bãlãa ka a wʊ pɔɔ mɩ wa bʊ̃n dɔɔl ba bɔ̃ɔ a lɛ na ɩ ɛ, ");
INSERT INTO biv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ka a Pita sʊʊr a pɔɔ, “A libie a jaa lɛ a anyãna a fʊ̃ʊ nɩ a Ananias na da a puo nyɛ ɔ? 'Yɛr kʊ ma.” A wʊ 'yɛr, “Ɔ̃ɔ, lɛ lɛ.” ");
INSERT INTO biv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","A Pita 'yɛr kʊ wʊ, “Ŋmɩnɛ lɛ a ɩ a yɩ guor taa ɩka yɩ bɛɛr a sɩ Soro Sɩɛ kaa? Nyɛ a nɩbɛ bala a dɔ̃dɔr nɛɛ bala lɛ tuo a fʊ sɩrɛ yin tɩ ũu, ba mɩn tuo fʊn yin.” ");
INSERT INTO biv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ajienaa ka a ɩ wʊ mɩ lon kpi be a Pita niem. A pɔlbil bala na ben wa kpɛ nyɛ ka a ɩ wʊ kpi naa, ka ba tuo wʊ yin tɩ ũu lan a sɩrɛ. ");
INSERT INTO biv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ka a dãbãɛ kpɛ a pupuorbiir ba jaa nɩ nɩrɛ jaa na wõ naa. ");
INSERT INTO biv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","A nɩtʊ̃nsɩ tʊ̃n nɛ'maa tʊ̃ yɔɔ a nɩbɛ sɔ̃ɔ. Ka a bala na sɔɔ de, ba jaa tara na nɛbʊ̃'yen ma lɔ̃ɔ taa a be a Solomon Bɛchaar pɔ. ");
INSERT INTO biv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nɩrɛ jaa kpire ba naa, tɩ ãsʊɔ jaa maa 'la lɔ̃ɔn ba ɛ. ");
INSERT INTO biv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tɩchɛ nɩyɔɔ jaa chɛnɛ na waara, ka dɔɔr nɩ pɔbɔ na sɔɔ de a sɩ Soro pʊɔrɔ 'yɔ̃ɔnɔ̃. ");
INSERT INTO biv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","A lɛ vɛ̃ naa ka a nɩbɛ yin a ba baalsɩ tɩ gaal ba a gador ju nɩ a sɔ̃n pɔ a sɔr kõkoor chɛlɛ nɩ a Pita, ɩka 'lɔ wa tala a wʊ gãagiel wʊ pɔɔ ba. ");
INSERT INTO biv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nɩyɔɔ yin a tẽbil ala na jilʊ̃ a Jerusalɛm waan a ba baalsɩ wa lɔ̃ɔn 'matãan a bala a sɩdɛbɛ na tara, ka ba jaa sa. ");
INSERT INTO biv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ka a nyuur kpɛ a Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ nɩ a wʊ taaba bala na pʊɔ a Saduseemɩne gbul pɔ. ");
INSERT INTO biv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","A ba nyɔɔr a nɩtʊ̃nsɩ 'yɔ̃ɔ pɔɔfʊ die pɔ bar. ");
INSERT INTO biv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tɩchɛ a tãsɔɔ a sɩ Soro tʊ̃ naa a wʊ malaka ka wʊ wa yuo a pɔɔfʊ die pãn na wʊ tɔɔ ba yin ");
INSERT INTO biv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","tɩ 'yɛr, “Yɩ chen a Nãaŋmɩn puorfʊ yir bɛchaar pɔ na yɩ tɩ 'yɛr a nyɛvʊr paalaa nyã 'yɛr kʊ a nɩbɛ.” ");
INSERT INTO biv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","A wɛr na wa chaar ba kpɛ̃n be a Nãaŋmɩn puorfʊ yir bɛchaar pɔ, nɩtãa lɛ a malaka na 'yɛr ba tɩ piel wile a nɩbɛ. A Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ nɩ a wʊ taaba mɩ wa lɔ̃ɔn taa na ba bʊɔl a Juu nɩbɛ nɩdierbe ba jaa lɔ̃ɔ taa na ba na guor a 'yɛr, na ba pãa tʊ̃ ɩka ba chen a pɔɔfʊ die pɔ tɩ yuo a nɩtʊ̃nsɩ waan. ");
INSERT INTO biv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tɩchɛ ban wa tɩ ta a pɔɔfʊ die pɔ baa nyɛ nɩrɛ jaa ɛ. A ba lɩɛb chen tɩ mana kʊrɔ ba, ");
INSERT INTO biv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Sɩ chen tɩ nyɛ a pɔɔfʊ die dɔ̃dɔr na chɛnɛ kpal, ka a nɩrɛ 'lɔ na ara gu chɛnɛ ara a dɔ̃dɔr nɛɛ, tɩchɛ sɩn wa yuo a pãn nɩrɛ jaa ba be be a die pɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ban wa wõ a anyãna ban man ka a Nãaŋmɩn puorfʊ yir guguro nɩkpɛ̃ɛ nɩ a Juu nɩbɛ bɔɔrlo nãmɩne ka a ɩ ba chĩcham, a ba baala baa bɔ̃ɔ lɛn na ɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ka a nɩrɛ ãsʊɔ wa 'yɛr kʊ ba, “Yɩ nyɛ a nɩbɛ bala yɩn nyɔɔr pɔɔ, ba ben be a Nãaŋmɩn puorfʊ yir bɛchaar pɔ wile a nɩbɛ.” ");
INSERT INTO biv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ka a Nãaŋmɩn puorfʊ yir guguro nɩkpɛ̃ɛ tara a wʊ tʊ̃tʊ̃nbɔ chiin tɩ tara a nɩtʊ̃nsɩ jaa jom waan. Baa tɩ fɩr ba ɛ, bojũu ba joro na dãbãɛ ɩka a nɩbɛ na lɔb ban nɩ kʊsɩbɛ. ");
INSERT INTO biv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ban wa waan ba, ba vɛ̃n ka ba ara a nɩbɛrɛ niem, ka a Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ na sʊʊr ba 'yɛr, ");
INSERT INTO biv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Saa kpãkpãan yɩ jaa 'yɛr ɩka, yɩ taa lɛ ɩrɛ wa pʊrɔ a yuor nyãna wile nɩ nɩrɛ jaa go ɛ? Tɩchɛ a yɩ chɛnɛ tɔr tɩ sɛɛ a Jerusalɛm nɩ a yɩ wiilfʊ nyãna, na yɩ bʊɔrɔ ɩka yɩ de a daba nyãna jãɩ yele dɔɔl sɩ.” ");
INSERT INTO biv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ka a Pita nɩ a nɩtʊ̃nsɩ bala na chɛ 'yɛr, “Sɩn tun Nãaŋmɩn nɛɛ gar nɩsaal. ");
INSERT INTO biv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","A sɩ sãakpãmɩne Nãaŋmɩn lɛ sãɩ a Yesu a kũu pɔ, a 'lɔ yɩn yɔɔl a daa ju ka wʊ kpi. ");
INSERT INTO biv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nãaŋmɩn 'mɔɔ wʊn don bin be a wʊ nũsʊ̃ɔ jie, ka wʊ ɩ Nãa nɩ Fafaara ɩka wʊ kʊ a Isɩral nɩbɛ sɔr ka ba lɩɛb ba tɩɛr, na ba nyɛ vɛ̃ kʊfʊ. ");
INSERT INTO biv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sɩn lɛ ɩ a anyãna dãasɩɛ dẽme nɩ a Nãaŋmɩn Sɩɛ 'lɔ wʊn de kʊ a bala na tu a wʊ nɛɛ.” ");
INSERT INTO biv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ban wa wõ a anyãna, ba suur ir naa ka ba bʊɔrɔ a ba kʊfʊ. ");
INSERT INTO biv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tɩchɛ ka a Farasee ãsʊɔ ban bʊɔlɔ Gamaliel na ɩ a Mosesɩ Nɛɛ wiwile, nɩrɛ jaa 'yɔ̃ɔnɔ̃ wʊ naa, ka wʊ ir ara a nɩdierbe pɔ tɩ 'yɛr ɩka, ba vɛ̃ ka a dɔɔr bala yi yõo bãlãa. ");
INSERT INTO biv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tɩ na wʊ pãa 'yɛr kʊ ba, “Isɩral dɔɔr, yɩ bɔ̃ɔnɔ̃ sʊ̃ a lɛ yɩn bʊɔrɔ ɩka yɩ maal a nɩbɛ banyãna. ");
INSERT INTO biv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sɔ̃ɔ kɔ̃ɔ lɛ a Tiudasɩ dɔ̃ɔ ir 'yɛr gãdaa 'yɛr ɩka nɩkpɛ̃ɛ lɛ wʊ ɩ ka a dɔɔr kɔɔr anaar (400) ir turo wʊ. Ba kʊ wʊ naa ka a nɩbɛ bala yɛ̃yɛl ka a jaa ɩ pɔrɔ. ");
INSERT INTO biv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ala puor lɛ ka a Judas na yi a Galilee a nɩbɛ sɔrfʊ yuon ir nɩyɔɔ ka ba turo wʊ. Ba mɩ kʊ wʊ naa ka a bala jaa na turo wʊ mɩ bũbur. ");
INSERT INTO biv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","A lɛ jũu, maa na 'yɛr yɩ naa ɩka yɩ ir nũu, tɩchɛ a nɩbɛ ba nyã bar. Yɩ bar ba a ba chiine. Ala ɩ a lɛ ban maala ɩn nɩrɛ lɛ bin an ɩn pɔrɔ. ");
INSERT INTO biv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tɩchɛ ala ɩ Nãaŋmɩn sɛ̃ lɛ a yi, yaa be jaa na wa tʊ̃ɔ ŋmaa a nɩbɛ banyãna sɔr ɛ, yɩn wa bɔ̃ɔn naa ka a ɩ Nãaŋmɩn mãɛ lɛ yɩ jɛɛrɛ nɩ.” ");
INSERT INTO biv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","A nɩbɛrɛ tu naa a lɛ a Gamaliel na 'yɛr, tɩ na ba bʊɔl a nɩtʊ̃nsɩ fɔb ba tɩ kpãkpãan ba ɩka ba taa lɛ ɩrɛ wa 'yɛrɛ 'yɛr pʊrɔ nɩ a Yesu yuor go ɛ, tɩ bar ba a ba chen. ");
INSERT INTO biv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","A nɩtʊ̃nsɩ na wa yi a nɩbɛrɛ banyãna niem, ba chɩlɛ naa, bojũu ba sɛɛn naa a dɔɔyɛ nɩ a vã difʊ a Yesu yuor jũu. ");
INSERT INTO biv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bɩbir jaa lɛ ba ma be a be a Nãaŋmɩn puorfʊ yir bɛchaar pɔ wile a nɩbɛ na ba mɩ yʊɔrɔ a yie ba gala ɛ, na ba wile a nɩbɛ tɩ 'yɛrɛ a 'yɛr nʊ̃ɔ ɩka a Yesu lɛ ɩ a Nɩ-iraa. ");
INSERT INTO biv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A ber ala pɔ, a poturbo na waara pʊɔrɔ a bala ban dɔɔ a paal yuo pɔ, ka baa tʊɔrɔ 'yɛrɛ a Juu kɔkɔr ɛ, hũhũnõ na 'yɔ̃ɔnɔ̃ a bala na ɩ a Juu nɩbɛ, bojũu a ba pɔɔkɔɛ maa nyɛ a bɩbir jaa bʊ̃diir ban ma põ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Be lɛ a nɩtʊ̃nsɩ pie nɩ ayi bʊɔl a poturbo ba jaa lɔ̃ɔ taa wa 'yɛr, “A ba tara sɔr ka sɩn bar a Nãaŋmɩn 'yɛr 'yɛrfʊ tɩ põnõ bʊ̃diir ɛ. ");
INSERT INTO biv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","A lɛ jũu yɛɛr, yɩ kaa a yɩ pɔ na yɩ ir dɔɔr ayopõi, bala yɩn bɔ̃ɔ ka ba sɛɛn a Nãaŋmɩn Sɩɛ tɩ mɩ tara yɛ̃, ka sɩn de a tʊ̃mɔ̃ nyã kʊ ba. ");
INSERT INTO biv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tɩchɛ a sɩn 'lɔ mʊ̃ɔ nɩbir nɩ a Nãaŋmɩn sʊɔrfʊ nɩ a wʊ 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","A 'yɛr nyã pɛl ba jaa na duo a be pʊɔ, ka ba ir a nɩbɛ banyãna. Sɩteven a Nãaŋmɩn Sɩɛ na sɛɛ ka wʊ mɩ tara sɔɔfʊ, nɩ Filip, nɩ Porokorusɩ, nɩ Nɩkanor, nɩ Tɩmon, nɩ Pamenasɩ, nɩ Nikolasɩ na yi Antiok na wʊ lɩɛb kpɛ a Juu nɩbɛ puorfʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","A nɩbɛ banyãna lɛ ba ir waan a nɩtʊ̃nsɩ sɛ̃, ka ba dɔɔl ba nuur sʊɔr Nãaŋmɩn kʊ ba. ");
INSERT INTO biv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ka a Nãaŋmɩn 'yɛr yaar, ka a poturbo mɩ na be a Jerusalɛm pʊɔrɔ 'yɔ̃ɔnɔ̃. A Juu nɩbɛ bɔɔrlorbo yɔɔ jie mɩ sɔɔn de a 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nãaŋmɩn wãɛfʊ ben a Sɩteven sɛ̃ ka wʊ tara kpɛ̃ɔ tʊ̃nɔ̃ nɩ a nɛ'maa tʊ̃yɔɔ a nɩbɛ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","A nɩbɛ bamɩne na yi a ba lɔ̃ɔfʊ jie a ba bʊɔl ba, Mãɛ Sorbo, nɩ a Juu nɩbɛ bamɩne na yi a Sirenɩ nɩ a Aleksandiriya, ka bamɩne mɩ yi a Sɩlɩsɩya nɩ Asɩya. A nɩbɛ banyãna lɛ piel a nɛchɩrɛ na ba chɩrɛ nɩ a Sɩteven. ");
INSERT INTO biv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tɩchɛ baa tʊɔrɔ wʊ ɛ, a yɛ̃ 'lɔ a Nãaŋmɩn Sɩɛ na kʊ wʊ a wʊ 'yɛrɛ nɩ. ");
INSERT INTO biv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","A ba pãa sɔɔl tʊ̃ nɩbɛ bamɩne ka ba ŋmaa jir 'yɛr ɩka, “Sɩn lɛ wõ a Sɩteven na fere 'yɛrɛ 'yɛrdɛɛr 'yɔ̃ɔnɔ̃ a Mosesɩ nɩ a Nãaŋmɩn.” ");
INSERT INTO biv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tɩ tɔ a nɩbɛ nɩ a nɩbɛrɛ nɩ a Mosesɩ nɛɛ wiwiilbe 'yɔ̃ɔ ka ba nyɔɔ a Sɩteven chiin a ba 'yɛr tɔɔrbɔ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Be lɛ ba waan jir ŋmarba ka ba wa 'yɛr, “A daba nyãna ba gala 'yɛr dɛbɛ wʊn 'yɛrɛ 'yɔ̃ɔnɔ̃ a Nãaŋmɩn puorfʊ yir chɛchɛ nyãna ɛ, nɩ a Mosesɩ nɛɛ wʊn bin ɛ. ");
INSERT INTO biv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sɩn mãɛ lɛ wõ wʊn 'yɛr ɩka a Yesu na yi a Najaretɩ na ŋmɛr a jie nyãna, tɩ na wʊ lɩɛb a binfʊ ala a Mosesɩ na dɔ̃ɔ bin kʊ sɩ.” ");
INSERT INTO biv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ka a bala jaa na jãnɛ a be a 'yɛr tɔɔrfʊ jie, kãan a Sɩteven nie ka wʊ kaara fɩka a malaka nie. ");
INSERT INTO biv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Be lɛ ka a Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ sʊʊr wʊ, “Sɩrɛ lɛ a anyãna ban 'yɛr bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ka a Sɩteven haa 'yɛr, “Yɛɛr nɩ sãamɩne, yɩ chɛlɛ. A Nãaŋmɩn tɩɩr sʊɔ dɔ̃ɔ yi a sɩ sãa Abraham lɛ wʊn dɔ̃ɔ chɛnɛ be a Mesopotamiya wɛr pɔ sɛrɛ tɩ wa chen a Haran. ");
INSERT INTO biv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","A Nãaŋmɩn 'yɛr kʊ wʊ, ‘Yi a fʊ tẽe na fʊ bar a fʊ nɩbɛ tɩ na fʊ chen wɛr yuo pɔ ɩn na wiil fʊ.’ ");
INSERT INTO biv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“A wʊ yi a Chaldea wɛr pɔ na wʊ chen tɩ jãnɛ a Haran wɛr pɔ. A wʊ sãa na wa kpi baar lɛ a Nãaŋmɩn waan wʊ a kana yɩn ben kpɩɛrɛ. ");
INSERT INTO biv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nãaŋmɩn ba kʊ wʊ bon jaa a kana ɛ, waa kʊ wʊ jibile jaa gba ɛ, bɩɩ gbɛr nɛfʊ jie ɛ. Tɩchɛ Nãaŋmɩn tɩr nɛɛ kʊ wʊ ɩka 'lɔ nɩ a wʊ yɔn lɛ na so a jie, tɩ waa tara bie gba ɛ. ");
INSERT INTO biv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nɩtɔ̃ lɛ a Nãaŋmɩn 'yɛr kʊ a Abraham, ‘A fʊ yɔn na ɩ naa sãanba paal sãan pɔ, na ba ɩ gbãgbaar ka ba ge ba yuom kɔɔr anaar (400). ");
INSERT INTO biv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tɩchɛ Nãaŋmɩn 'yɛr naa, ɩka wʊn yaa naa a sãn a paal 'lɔ na maal ba a gbãgbaar. A anyã puor lɛ ban wa puor ma a jie nyãna.’ ");
INSERT INTO biv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nãaŋmɩn tɩr nɛɛ kʊ a Abraham a yʊɔr ŋmaafʊ yele. Abraham na wa dɔɔ a Isaakɩ, wʊ ŋmaa wʊn a yʊɔr a ber aniin daar. Ka a Isaakɩ mɩ dɔɔ a Jekɔb, ka a Jekɔb mɩ dɔɔ a sɩ sãamɩne pie nɩ ayi. ");
INSERT INTO biv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“A sɩ sãamɩne banyãna na tara nɩ a ba yɛbile Josefʊ nɩ nyuur jũu, na ba nyɔɔ wʊ da kʊ a Ijipitɩ dẽme. Tɩchɛ ka a Nãaŋmɩn be a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Na wʊ faa wʊ yin a wʊ wõm a jaa pɔ. Wʊ kʊ naa a Josefʊ yɛ̃ na wʊ sʊ̃ʊ wʊ a wʊ nyɛ 'yɔ̃ɔfʊ a Faaro na ɩ a Ijipitɩ nãa niem, na wʊ maal wʊ ka wʊ ɩ a Ijipitɩ nɩ a nãa jie wʊ jaa nɩkpɛ̃ɛ. ");
INSERT INTO biv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ka a kɔ̃ lo Ijipitɩ nɩ a Kanaan wɛr wʊ jaa waan dɔɔyɛ, ka a sɩ sãamɩne ba nyɛrɛ bʊ̃diir ɛ. ");
INSERT INTO biv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jekɔb na wa wõ ɩka bʊ̃diir ben a be Ijipitɩ, wʊ tʊ̃n a sɩ sãamɩne ka ba chen. ");
INSERT INTO biv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A gbɛɛ ayi sʊɔ ban chen lɛ a Josefʊ wiil a wʊ mãɛ kʊ ba, ka a Faaro mɩ pãa bɔ̃ɔ a Josefʊ yir nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","A anyã puor lɛ a Josefʊ tʊ̃ bʊɔl a wʊ sãa Jekɔb nɩ a wʊ yir dẽme, a ba jaa ɩ nɩbɛ lɩjaata nɩ pie nɩ anũu (75). ");
INSERT INTO biv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jekɔb chen a be a Ijipitɩ nɩ a sɩ sãamɩne be lɛ ba jaa tɩ kpi. ");
INSERT INTO biv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ba tuo naa a ba ãgãma waan a Sekem wa ũu ba a yaa 'lɔ pɔ a Abraham na da a Hamor bibiir sɛ̃ a be a Sekem. ");
INSERT INTO biv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“A sɔ̃ɔ na wa gbʊr ka a Nãaŋmɩn na maal a lɛ wʊn tɩr a nɛɛ kʊ a Abraham, a sɩ nɩbɛ na be a Ijipitɩ dɔɔn paal. ");
INSERT INTO biv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ala lɛ ka a nãyuo wa di na wʊ kaara a Ijipitɩ na waa bɔ̃ɔ a Josefʊ yele ɛ. ");
INSERT INTO biv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wʊ maal naa a sɩ nɩbɛ putuyele na wʊ ge ba, na wʊ ma fɩr a pɔɔ pʊʊr ka bala wa dɔɔ bipɩlɛ ba lɔb ba 'yɔ̃ɔ a kʊ̃ɔ pɔ a ba kpi. ");
INSERT INTO biv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“A sɔ̃ɔ nyãna lɛ ba dɔɔ a Mosesɩ, ka wʊ ɩ bivɩla a Nãaŋmɩn niem. A ba guol wʊ ŋmɛrsɩ ata be a wʊ sãa yir. ");
INSERT INTO biv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ban wa yin wʊ tɩ bar a yõo, Faaro bipɔɔ de wʊn guol ka wʊ ɩ a wʊ mãɛ bidaba. ");
INSERT INTO biv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ba jãn naa Mosesɩ a Ijipitɩ tẽe yɛ̃ a jaa, ka wʊ kpɛ̃mɛ a wʊ 'yɛr nɩ a wʊ tʊ̃mɔ̃ pɔ. ");
INSERT INTO biv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“A lɛ a Mosesɩ na wa ta yuom lɩjaayi (40), wʊ tɩɛr naa a wʊ yɛɛr Isɩral nɩbɛ na wʊ ɩka wʊ chen tɩ piir ba kaa. ");
INSERT INTO biv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wʊ tɩ nyɛn a ba ãsʊɔ a Ijipitɩ nɩrɛ ãsʊɔ na gere ka wʊ ŋmaa de na wʊ kʊ a Ijipitɩ nɩrɛ 'lɔ. ");
INSERT INTO biv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosesɩ tɩɛr lɛ ɩka a wʊ mãɛ nɩbɛ na bɔ̃ɔn naa ɩka 'lɔ lɛ a Nãaŋmɩn na de faan ba, tɩchɛ baa tɩɛrtɔ a lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","A wɛr na wa chaar, wʊ tɩ nyɛn a Isɩral nɩbɛ ayi mɩ na jɛɛrɛ taa. Ka wʊ 'maal ba tɩ sʊrɔ ba, ‘Yɩn yɛɛr nara, bo lɛ so a yɩ jɛɛrɛ taa?’ ");
INSERT INTO biv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tɩchɛ a 'lɔ sʊɔ na tʊ̃ɔ a wʊ tɔ sʊɔ daan a Mosesɩ bar tɩ sʊʊr wʊ, ‘An tʊ̃ fʊ ɩka fʊ wa kaara sɩ na fʊ tɔɔrɔ a sɩ 'yɛr? ");
INSERT INTO biv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Fʊ bʊɔrɔ naa ɩka fʊ mɩ kʊ ma nɩtãa lɛ fʊn kʊ a Ijipitɩ nɩrɛ a jãa wɛ?’ ");
INSERT INTO biv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mosesɩ na wõ a 'yɛr nyãna ka wʊ jo chen tɩ kpɩɛrɛ a Midiyan, be lɛ wʊ be na wʊ wa dɔɔ dabil ayi. ");
INSERT INTO biv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Yuom lɩjaayi (40) na wa po, malaka wa lɩɛb bũu lɩrɛ tɩbile pɔ, na wʊ dũu a Mosesɩ be a mɔgɔ̃ɔ pɔ na gbʊr a Sinai tɔ̃ɔ par. ");
INSERT INTO biv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Wʊn wa nyɛ a lɛ ka a nɛ'maa wʊ, a wʊ tɔɔ gbʊr ɩka wʊ kaa. Be lɛ wʊ wõ a Soro kɔkɔr na 'yɛr, ");
INSERT INTO biv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘'Maa lɛ ɩ a fʊ sãamɩne Nãaŋmɩn, Abraham, Isaakɩ nɩ a Jekɔb Nãaŋmɩn.’ Ka a dãbãɛ kpɛ a Mosesɩ waa lɛ 'lara na kaa ɛ. ");
INSERT INTO biv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ka a sɩ Soro pãa 'yɛr kʊ wʊ, ‘Yaa a fʊ nafɔɔr bar, a jie fʊn ara ɩ naa jichɛchɛ. ");
INSERT INTO biv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","N nyɛ naa a n nɩbɛ be a Ijipitɩ pɔ ban gere, n wõ naa ba hʊ̃ʊnfʊ naa suu ɩka n wa faa ba. Wa, ka n tʊ̃ fʊ a be a Ijipitɩ.’ ");
INSERT INTO biv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“A Mosesɩ nyãna nɩ wʊ ju ban tɔr bar tɩ sʊʊr wʊ, ‘An lɛ 'yɔ̃ɔ fʊ ɩka fʊ kaara sɩ na fʊ tɔɔrɔ a sɩ 'yɛr?’ 'Lɔ lɛ a Nãaŋmɩn mãɛ tʊ̃ a sɔ̃ɔ 'lɔ a malaka na wa dũu wʊ 'lɩrɛ a bũu a tɩbile pɔ, ɩka wʊ tɩ ɩ a ba nɩkpɛ̃ɛ nɩ a ba fafaara. ");
INSERT INTO biv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","'Lɔ lɛ tɩ de ba nie na wʊ tʊ̃ tʊ̃ yɔɔ be a Ijipitɩ tẽe pɔ, nɩ a Man Jɩɛ par nɩ a mɔgɔ̃ɔ pɔ ban be a yuom lɩjaayi (40). ");
INSERT INTO biv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","A Mosesɩ nyãna nɩ wʊ ju lɛ 'yɛr kʊ a Isɩral nɩbɛ ɩka, ‘Nãaŋmɩn na tʊ̃ naa a 'yɛ'yɛrɛ ãsʊɔ a maa kaar ka wʊ yi a yɩ mãɛ nɩbɛ pɔ.’ ");
INSERT INTO biv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wʊ dɔ̃ɔ pʊɔ a nɩyɔɔ bala pɔ be a mɔgɔ̃ɔ pɔ, 'matãan a sɩ sãakpãmɩne ka a malaka 'yɛr 'yɛr kʊ wʊ be a Sinai Tɔ̃ɔ par na ɩ nyɛvʊr 'yɛr ka wʊ 'yɛr kʊ sɩ. ");
INSERT INTO biv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Tɩchɛ a sɩ sãakpãmɩne tɔr wʊ naa, na baa tu a wʊ nɛɛ ɛ. Ba tɔr wʊn bar ka a ba tɩɛr lɩɛb chen be a Ijipitɩ. ");
INSERT INTO biv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ba 'yɛr kʊ a Aaron, ‘Maal ŋmɩmɛ kʊ sɩ ka a ma de sɩ nie, a Mosesɩ 'lɔ̃nɔ̃ na yin sɩ a Ijipitɩ saa bɔ̃ɔ bo nɩ tara wʊ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","A ba mɛ bʊtɩɩ a daar 'lɔ̃nɔ̃ ka wʊ nyɛtãan nele, na ba waan bomo wa lon bɔɔr a jie na ba dãɛn 'yɔ̃ɔn a ba nũu bʊ̃maalaa nyãna. ");
INSERT INTO biv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tɩchɛ ka a Nãaŋmɩn lɩɛb puor 'yɔ̃ɔ ba, na wʊ bar ba ka ba puoro a saaju bomo. Ka anyãna tɩ tuor a lɛ a Nãaŋmɩn 'yɛ'yɛrɛ ãsʊɔ na dɔ̃ɔ sɛb, wʊ sʊʊr naa, ‘A yɩn Isɩral nɩbɛ, yɩn be a mɔgɔ̃ɔ pɔ a yuom lɩjaayi (40) na yɩ dɔ̃ɔ waan a bɔɔrlo bomo maa lɛ yɩ wa kʊ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kai, tɩ a bʊtɩbɛ ala yɩn kaara lɛ a Molokɩ nɩ ŋmɛrbir ŋmɩn Arefan, a tɩbɛ anyãna lɛ yɩ dɔ̃ɔ maal puoro. A lɛ jũu, ɩn vɛ̃ naa ka ba nyɔɔr yɩ chiin a Babilon puor ka yɩ tɩ kpɩɛrɛ a be.’ ");
INSERT INTO biv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“A sɩ sãakpãmɩne dɔ̃ɔ maal gãma yir be a mɔgɔ̃ɔ pɔ ka a ɩ dãasɩɛ, ba maal wʊ naa nɩtãa lɛ a Nãaŋmɩn na man wiil a Mosesɩ ka wʊ nyɛ. ");
INSERT INTO biv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","A gãma yir nyã lɛ a sɩ sãakpãmɩne tara ka a Josua de ba a nie ka ba waan, a ba wa faa a wɛr nyã pɔ a nɩyor na dɔ̃ɔ kpɩɛrɛ ka a Nãaŋmɩn dii ba bar. A gãn yir nyã ben be lɛ̃ɛɛ tɩ tãn a Nãa David sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nãaŋmɩn maal vɩla kʊ wʊ ka wʊ ɩka wʊn mɛn yir kʊ a Jekɔb Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tɩchɛ Solomon lɛ wa mɛ a yir kʊ a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Fʊ̃ʊ kaa, a Nãaŋmɩn nyã na ɩ a saaju sʊɔ, ba kpɩɛrɛ a yie anyã nɩbɛ na mɛ ɛ. Nɩtãa lɛ a Nãaŋmɩn 'yɛ'yɛrɛ ãsʊɔ na dɔ̃ɔ 'yɛr, ");
INSERT INTO biv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Saaju lɛ ɩ a maa nakɔɔ, ka a tẽe ɩ a n gbɛɛ dɔɔlfʊ jie. Ka a sɩ Soro sʊʊr, yir bo tɔ lɛ yɩn mɛ kʊ ma? Bɩɩ nyɩnɛ lɛ na ɩ a n pɛ̃nfʊ jie? ");
INSERT INTO biv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","A ba ɩ a maa nũu lɛ maal anyãna a jaa ɛ?’ ");
INSERT INTO biv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Yɩn nyãkpãɛn dẽme na ɩ nɩbɛ na ba wõnõ 'yɛr ɛ, yɩ kaara a yɩ sãamɩne kaar. Yɩ maa sɔɔ kʊ a Nãaŋmɩn Sɩɛ sɔr ɛ. ");
INSERT INTO biv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nãaŋmɩn 'yɛ'yɛrɛ jaa ba be be ka a yɩ sãamɩne ba ge wʊ ɛ. Ba gba kʊ naa bala na de nie mʊɔl 'yɛr a Torfʊ Sʊɔ 'lɔ waa 'yɛr. A pʊ̃pãanyã, yɩn gba lɛ gar 'yɔ̃ɔ wʊ na yɩ kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yɩn lɛ de a Nãaŋmɩn nɛɛ wʊn kʊ a malaka a wʊ wa kʊ yɩ ka yɩ de tʊ̃nɔ̃ nɩ, tɩchɛ a yɩ tɔr bar.” ");
INSERT INTO biv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","A 'yɛr nyãna ban wa wõ, ka ba suur ir a ba kpar kparaa jur 'yɔ̃ɔnɔ̃ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tɩchɛ a Sɩteven a Nãaŋmɩn Sɩɛ na sɛɛ a wʊ dʊl kaa saaju na wʊ nyɛ a Nãaŋmɩn tɩɩr, ka a Yesu ara a Nãaŋmɩn nũsʊ̃ɔ jie. ");
INSERT INTO biv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ka wʊ 'yɛr, “Yɩ nyɛ ka, n nyɛ naa saaju na yuo ka a Nɩsaal Bie ara a Nãaŋmɩn nũsʊ̃ɔ jie.” ");
INSERT INTO biv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","A anyãna ban wõ ba pɔɔn a tobo tɩ ŋme chɛlma na ba tɩ mɩl wʊ, ");
INSERT INTO biv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","na ba tɔɔ wʊ yin a tẽe chɛ̃chɛ̃ɛ tɩ piel lɔɔrɔ wʊ nɩ kʊsɩbɛ. Ka a bala na di dãasɩɛ yaar a ba fuusɩ bin pɔlbile kɔ̃ɔ ban bʊɔlɔ Sɔɔl sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ban lɔɔrɔ wʊ a lɛ nɛ na kʊ ka wʊ sʊɔr Yesu, “N Soro Yesu de a n sãɛ.” ");
INSERT INTO biv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wʊ lon gbur dumo tɩ pãa ŋme chɛlma 'yɛr, “N Soro taa ɩrɛ wa yaara ba sãn ɛ.” A anyãna lɛ wʊ 'yɛr baar tɩ ŋmaa vʊʊr. ");
INSERT INTO biv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A Sɔɔl mɩ dɔ̃ɔ sɔɔ ɩka ba kʊ a Sɩteven. A daar 'lɔ̃nɔ̃ jaa lɛ ba piel gere a Nãaŋmɩn puorbo be a Jerusalɛm. Ka ba jaa ŋma yaar a bamɩne chen Judiya a bamɩne mɩ chen Samariya tɩchɛ a nɩtʊ̃nsɩ tɛɛ be a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nɩbɛ bamɩne na joro a Nãaŋmɩn 'mɔɔn a Sɩteven ũu tɩ na ba kõ a kuor. ");
INSERT INTO biv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tɩchɛ ka a Sɔɔl mʊ̃ɔ nɩbir bur buro a pupuorbiir gbulsɩ bara, na wʊ yʊɔrɔ kpɩɛrɛ a yie nyɔɔrɔ dɔɔr nɩ pɔbɔ tɩ 'yɔ̃ɔnɔ̃ a pɔɔfʊ die pɔ. ");
INSERT INTO biv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","A bala na jo ŋma a dẽdẽme chɛnɛ na mʊɔlɔ a Nãaŋmɩn 'yɛr jie jaa ban chen. ");
INSERT INTO biv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip chen Samariya tẽe pɔ, na wʊ tɩ 'yɛr ɩka Yesu lɛ a Nɩ-iraa a be. ");
INSERT INTO biv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","A nɩyɔɔ na wa wõ a lɛ a Filip na 'yɛr tɩ mɩ nyɛ a nɛ'maa tʊ̃mɔ̃ wʊn tʊ̃, a ba yuo toor chɛlɛ a lɛ wʊn 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","A sɩdɛbɛ ala na dɔ̃ɔ pɔɔrɔ a nɩbɛ ŋmen chɛlsɩ wa yin a nɩbɛ pɔ, ka a gbɛkũn nɩ a gbɛrsɩ yɔɔ jaa sa. ");
INSERT INTO biv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ka a tẽe 'lɔ dẽme ba jaa chɩlɛ. ");
INSERT INTO biv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Daba kɔ̃ɔ dɔ̃ɔ be be ban bʊɔlɔ Simon na wʊ ma tʊ̃nɔ̃ tãsɔɔ tʊ̃mɔ̃ ka a 'maa a Samariya nɩbɛ nɛɛ, na wʊ ma wile a wʊ mãɛ ɩka nɩkpɛ̃ɛ lɛ wʊ ɩ. ");
INSERT INTO biv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","A nɩbɛ ba jaa, a bɛrɛ nɩ a bil ba jaa ma yuon toor chɛlɛ wʊ tɩ 'yɛrɛ, “A daba nyã 'lɔ kpɛ̃ɔ ɩ naa a gãdaa sʊɔ kpɛ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ba turo wʊ naa bojũu a kor naa wʊn tʊ̃nɔ̃ a tãsɔɔ tʊ̃mɔ̃ ka a 'maa ba nɛɛ. ");
INSERT INTO biv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tɩchɛ a lɛ ban wa sɔɔ de a lɛ a Filip na 'yɛr a 'yɛr nʊ̃ɔ nyã na ɩ a Nãaŋmɩn nãalʊ̃ʊ 'yɛr, nɩ a Yesu na ɩ a Nɩ-iraa yuor, dɔɔr nɩ pɔbɔ ba jaa son a Nãaŋmɩn kʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","A Simon mɩ sɔɔ naa ka ba so wʊ a Nãaŋmɩn kʊ̃ɔ a wʊ turo a Filip yʊɔrɔ, a nɛ'maa tʊ̃yɔɔ wʊn nyɛ wʊn tʊ̃. ");
INSERT INTO biv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","A nɩtʊ̃nsɩ na be a Jerusalɛm na wa wõ ɩka a Samariya nɩbɛ mɩ sɔɔn de a Nãaŋmɩn 'yɛr, ba tʊ̃n Pita nɩ Jɔɔn a ba sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ban tɩ ta, ba sʊɔr Nãaŋmɩn kʊ a nɩbɛ ka ban nyɛ a Nãaŋmɩn Sɩɛ. ");
INSERT INTO biv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bojũu Nãaŋmɩn Sɩɛ ba kpɛ ãsʊɔ jaa sɛrɛ ɛ, tɩchɛ a Nãaŋmɩn kʊ̃ɔ lɛ ba so ba, nɩ a sɩ Soro Yesu yuor. ");
INSERT INTO biv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ka a Pita nɩ a Jɔɔn pãa dɔɔl ba a nuur a ba nyɛ a Nãaŋmɩn Sɩɛ. ");
INSERT INTO biv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon na nyɛ a lɛ a nɩtʊ̃nsɩ na dɔɔl ba a nũu ka ba nyɛ a Nãaŋmɩn Sɩɛ, a wʊ de libie kʊ ba, ");
INSERT INTO biv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","tɩ 'yɛr, “Yɩ mɩ kʊ ma a kpɛ̃ɔ nyãna ka maa wa dɔɔl nɩrɛ jaa a n nũu, a wʊ mɩ ma nyɛ a Nãaŋmɩn Sɩɛ.” ");
INSERT INTO biv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ka a Pita 'yɛr kʊ wʊ, “Fʊ̃ʊ nɩ a fʊ libie jaa yɩ wɛ, bojũu fʊ tɩɛr ɩka fʊn tʊ̃ɔ da a Nãaŋmɩn kʊfʊ nɩ libie. ");
INSERT INTO biv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Faa tara sɔr na lɔ̃ɔ tʊ̃n sɩ ɛ, bojũu a fʊ nyãa ba tor a Nãaŋmɩn sɛ̃ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Lɩɛb a fʊ pututɩɛr nyãna na fʊ sʊɔr a sɩ Soro amɩne sɛ̃ wʊn vɛ̃n kʊ fʊ a fʊ tɩɛr dɛɛr nyãna fʊn tara. ");
INSERT INTO biv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","N nyɛn bɔ̃ɔn fʊn ɩ pubier sʊɔ ka a yelbier nyɔɔ fʊ pɔɔ.” ");
INSERT INTO biv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","A Simon pãa 'yɛr, “Yɩ sʊɔr a Nãaŋmɩn kʊ ma ka ala yɩn 'yɛr taa waara a n sɛ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","A lɛ Pita nɩ a Jɔɔn na wa man 'yɛr a Nãaŋmɩn 'yɛr baar, ba lɩɛb kulo a Jerusalɛm ba 'yɛrɛ naa a 'yɛr nʊ̃ɔ nyãna a tẽbil ala na chɛɛl a Samariya. ");
INSERT INTO biv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nãaŋmɩn malaka 'yɛr kʊ a Filip, “Ir suu de a sɔr 'lɔ na yi a mɔgɔ̃ɔ pɔ tu a Jerusalɛm chen a Gaja.” ");
INSERT INTO biv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Lɛ lɛ wʊ ir chiine, na wʊ tɩ tuor a Etiyopiya daba ãsʊɔ ban maal ka wʊ ab na wʊ ɩ nɩkpɛ̃ɛ kaara a Etiyopiya nãpɔɔ ban bʊɔlɔ Kandasɩ libie. Jerusalɛm lɛ wʊ chen tɩ puor, ");
INSERT INTO biv_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","na wʊ lɩɛb kulo jãnɛ a wʊ wii torko pɔ na wʊ kara a Nãaŋmɩn 'yɛ'yɛrɛ Isaiya gãn. ");
INSERT INTO biv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ka a Nãaŋmɩn Sɩɛ 'yɛr a Filip, “Chen tɩ gbʊr a torko par.” ");
INSERT INTO biv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","A Filip jo chen a be a torko par na wʊ wõ a daba na kara a Isaiya gãn a wʊ sʊʊr wʊ, “Fʊ bɔ̃ɔ naa lɛ par fʊn kara ɔ?” ");
INSERT INTO biv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ka a daba 'yɛr, “Ŋmɩnɛ ɩn ɩrɛ wa bɔ̃ɔ a par, ka nɩrɛ baa wiil ma ɛ?” Tɩ na wʊ bʊɔl a Filip ka wʊ do jãnɛ a torko pɔ. ");
INSERT INTO biv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A anyãna lɛ a da-abbaa 'lɔ̃nɔ̃ dɔ̃ɔ kara a Nãaŋmɩn gãn pɔ, “Ba nyɔɔ wʊn chiine fɩka pɛr na tɩ kʊ, Wʊ ɩn jaa gbul fɩka pele ban põnõ a kɔɔl na waa haa nɛɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wʊ siir a wʊ mãɛ a lɛ ban ba tɔɔr a wʊ 'yɛr kaa tor ɛ. An lɛ na tʊ̃ɔ 'yɛr a wʊ bal nɩbɛ 'yɛr? A wʊ nyɛvʊr ba tal tɛɛr a ka a wɛr pɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ka a da-abbaa nyã sʊɔr a Filip, “Yãayãabɩlɛ, 'yɛr kʊ ma, an 'yɛr lɛ a Nãaŋmɩn 'yɛ'yɛrɛ nyã 'yɛrɛ? Wʊ mãɛ 'yɛr lɛ wʊ 'yɛrɛ bɩɩ nɩrɛ kɔ̃ɔ 'yɛr lɛ wʊ 'yɛrɛ?” ");
INSERT INTO biv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","A Filip pãa piel na wʊ de a Nãaŋmɩn gãn 'yɛr nyãna man a Yesu 'yɛr nʊ̃ɔ kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ban 'mataa chiine tɩ ta kʊ̃ɔ kɔ̃ɔ par a sɔr pɔ, ka a da-abbaa 'lɔ 'yɛr, “Nyɛ kʊ̃ɔ, bãa lɛ so ka fʊ kʊ̃ so ma a Nãaŋmɩn kʊ̃ɔ ɛ?” ");
INSERT INTO biv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tɩ na wʊ tɔɔ a torko a wʊ ara, ka a 'lɔ nɩ a Filip 'mataa kpɛ a kʊ̃ɔ pɔ, ka a Filip so wʊ a Nãaŋmɩn kʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ban wa yi a kʊ̃ɔ pɔ, Nãaŋmɩn Sɩɛ wa jaa naa a Filip chiin ka a da-abbaa 'lɔ ba lɛ nyɛ wʊ go ɛ. Tɩ de wʊ sɔr chɩlɛ kulo. ");
INSERT INTO biv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tɩchɛ ka a Filip tɩ yi naa Ajotusɩ na wʊ 'yɛrɛ a Nãaŋmɩn 'yɛr a tẽn ala a jaa tɩ tãn Sisariya. ");
INSERT INTO biv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A sɔ̃ɔ 'lɔ̃nɔ̃ lɛ a Sɔɔl chɛnɛ pʊrɔ a sɩ Soro poturbo ju, na wʊ bʊɔrɔ ɩka wʊ kʊ ba. Wʊ chen naa a Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ sɛ̃, ");
INSERT INTO biv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","na wʊ tɩ sʊɔr sɔr de gãn na chiin a ba lɔ̃ɔfʊ jiir ala na be a Damaskus ɩka 'lɔ wa tɩ nyɛ nɩrɛ na turo a Sɔr nyã, ka pɔɔ lɛ bɩɩ daba lɛ wʊ tʊ̃ɔ nyɔɔr ba waan a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ala lɛ wʊ de a sɔr chiine tɩ gbʊrɔ a Damaskus ka chãa yi be a saaju ajienaa wa nyɩɩr jil wʊ. ");
INSERT INTO biv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ka wʊ lo tẽe tɩ wõ kɔkɔr na bʊɔlɔ wʊ sʊrɔ, “Sɔɔl, Sɔɔl, bo lɛ so a fʊ gere ma a lɛ?” ");
INSERT INTO biv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ka a Sɔɔl sʊʊr, “An lɛ fʊ ɩ Soro?” Ka wʊ 'yɛr, “Maa lɛ ɩ a Yesu fʊn gere. ");
INSERT INTO biv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Pʊ̃pãanyã, ir na fʊ kpɛ be a tẽe pɔ, ban wiil fʊ naa a lɛ fʊn na ɩ.” ");
INSERT INTO biv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ka a dɔɔr bala nɩ a Sɔɔl na 'mataa chiine gĩe ara, na ba wõ a dɔɔn, tɩchɛ baa nyɛ nɩrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ka a Sɔɔl ir a tẽe ara na wʊ yuo a nɩbie tɩ waa lɛ nyɛrɛ ɛ. A ba nyɔɔ wʊ a nũu tɔɔ kpɛ̃n be a Damaskus. ");
INSERT INTO biv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Wʊ maal ber ata waa lɛ nyɛrɛ ɛ, waa di bʊ̃diir bɩɩ nyũ kʊ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tɩchɛ a poturo ãsʊɔ ben a be Damaskus a ba bʊɔlɔ wʊ Ananias ka a sɩ Soro wa bʊɔl wʊ a jãna pɔ, “Ananias.” A wʊ sɔɔ, “Ɔ̃ɔ, n Soro.” ");
INSERT INTO biv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ka a Soro 'yɛr kʊ wʊ, “Ir de a Sɔr Dẽdẽe chiine na fʊ tɩ ta a Judas yir sʊʊr daba na yi Tasusɩ a ba bʊɔlɔ Sɔɔl, be lɛ wʊ be sʊɔrɔ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","A wʊ jãna pɔ, wʊ nyɛn daba ban bʊɔlɔ Ananias na dɔɔl wʊ nũu ka wʊ lɛ nyɛrɛ.” ");
INSERT INTO biv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","A Ananias 'yɛr, “N Soro, n wõn a daba nyã yelyɔɔ a lɛ wʊn ge a fʊ nɩsʊ̃n a be a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A ka mɩ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ mɩ kʊ wʊn sɔr ɩka wʊ wa nyɔɔr a bala jaa na bʊɔlɔ a fʊ yuor.” ");
INSERT INTO biv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tɩchɛ ka a Soro 'yɛr kʊ a Ananias, “Chen, a daba nyãna lɛ ɩ a n bʊ̃-iraa ka wʊn tuo a maa yuor chiin a bala na ba ɩ a Juu nɩbɛ pɔ, nɩ a ba nãmɩne sɛ̃, lɔ̃ɔn a Isɩral nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ɩ̃n wiil wʊ naa a lɛ wʊn na di dɔɔyɛ a n yuor jũu.” ");
INSERT INTO biv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Be lɛ a Ananias ir chen tɩ kpɛ be a yir, na wʊ tɩ dɔɔl wʊ a nũu tɩ 'yɛr kʊ wʊ, “N yɛbɛ Sɔɔl, a sɩ Soro Yesu na yi fʊ be a sɔr pɔ fʊn waara lɛ tʊ̃ ma a fʊ sɛ̃ ka fʊn lɛ nyɛrɛ go, na fʊ sɛɛn a Nãaŋmɩn Sɩɛ.” ");
INSERT INTO biv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ajienaa ka bʊ̃nyɩnsɩ 'lɔɔr a Sɔɔl nɩbie pɔ lo a wʊ lɛ nyɛrɛ go. Wʊ ir naa a ba tɔ̃ɔ so wʊ a Nãaŋmɩn kʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wʊn wa di a bʊ̃diir baar wʊ lɛ nyɛn kpɛ̃ɔ, na wʊ jãnɛ a poturbo bala sɛ̃ a be a Damaskus bãlãa. ");
INSERT INTO biv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ajienaa, wʊ piel 'yɛrɛ a Nãaŋmɩn 'yɛr be a ba lɔ̃ɔfʊ jiir, na wʊ 'yɛrɛ ɩka a Yesu ɩ naa Nãaŋmɩn Bie. ");
INSERT INTO biv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bala jaa na wõ a wʊ 'yɛr ka a 'maa ba nɛɛ a ba sʊrɔ, “A ba ɩ a daba nyãna lɛ ir gere a bala a be a Jerusalɛm na bʊɔlɔ a yuor nyãna ɛ? Na wʊ wa a ka mɩ ɩka wʊ wa nyɔɔr a bala mɩ chiin tɩ kʊ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ ɛ?” ");
INSERT INTO biv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tɩchɛ ka a Sɔɔl kpɛ̃ɔ chɛnɛ pʊɔrɔ 'yɔ̃ɔnɔ̃ ka wʊ 'yɛr tʊ̃ɔ a Juu nɩbɛ na kpɩɛrɛ a Damaskus na wʊ wiil ba ɩka a Yesu lɛ ɩ a Nɩ-iraa. ");
INSERT INTO biv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ber yɔɔ na wa po, a Juu nɩbɛ guor taa ɩka ba kʊ a Sɔɔl, ");
INSERT INTO biv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","tɩchɛ kaa a Sɔɔl bɔ̃ɔn a ba guorfʊ. Mɔ̃tɔ̃ɔ nɩ tãsɔɔ jaa lɛ ba mʊ̃ɔ nɩbir guro wʊ a tẽe dɔ̃dɔɩ nɛɛr, bʊɔrɔ a wʊ kʊ̃ fʊ. ");
INSERT INTO biv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tɩchɛ ka a bala na turo wʊ 'mɔɔ wʊ 'yɔ̃ɔ pɩɛ pɔ tãsɔɔ na ba tur wʊ bar ka wʊ tu a dãpuor dachin pɔ suu. ");
INSERT INTO biv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wʊn tɩ ta Jerusalɛm, wʊ bʊɔrɔ naa ɩka wʊ lɔ̃ɔnɔ̃ nɩ a poturbo tɩchɛ a ba joro wʊ dãbãɛ, baa sɔɔ ɩka wʊ ɩ naa a poturo ãsʊɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tɩchɛ ka a Banabasɩ tara wʊ chiin be a nɩtʊ̃nsɩ sɛ̃. 'Lɔ lɛ pãa man kʊ ba a lɛ a Sɔɔl na nyɛ a sɩ Soro a sɔr pɔ, ka a Soro 'yɛr 'yɛr kʊ wʊ. Wʊ 'yɛr ɩka a be a Damaskus wʊ mʊɔl 'yɛr a Yesu yuor 'yɛr, na wʊ ta jo dãbãɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","A Sɔɔl jãnɛ a be a ba sɛ̃ na wʊ so wʊ mãɛ yʊɔrɔ be a Jerusalɛm na wʊ mʊɔlɔ a sɩ Soro Yesu yuor 'yɛrɛ ba joro dãbãɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Wʊ ma 'yɛrɛ naa ka a 'lɔ nɩ a Juu nɩbɛ bala ban dɔɔ a paal yuo pɔ ka baa tʊɔrɔ 'yɛrɛ a Juu kɔkɔr ɛ, ma chɩrɛ taa, ka ba bʊɔrɔ a wʊ kʊfʊ. ");
INSERT INTO biv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","A poturbo na wa wõ a nɩtɔ̃ ba tara wʊn chiin a Sisariya tɩ bar ka wʊ chen Tasusɩ. ");
INSERT INTO biv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Damfʊ ba lɛ be a bala na puoro be a Judiya, Galilee nɩ a Samariya, ka a nyã'maar. Ba kpɛ̃mɛ naa ka a Nãaŋmɩn Sɩɛ 'yɔ̃ɔ ba ãkpɛ̃ɔ ka ba nʊ̃ɔnɔ̃ na ba joro a sɩ Soro dãbãɛ. ");
INSERT INTO biv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ka a Pita yʊɔrɔ a tẽn na wʊ wa chen Lida ɩka wʊ tɩ piir a Nãaŋmɩn puorbo kaa. ");
INSERT INTO biv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Be lɛ wʊ tɩ nyɛ daba ban bʊɔlɔ Ainɩyas na gbɛr gã yuomo aniin. ");
INSERT INTO biv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ka a Pita bʊɔl wʊ, “Ainɩyas, Yesu yuor pɔ, sa. Ir saaju na fʊ pilʊ̃ a fʊ bʊ̃gãnaa.” Ajienaa lɛ a Ainɩyas ir saaju. ");
INSERT INTO biv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ka a Lida nɩbɛ ba jaa nɩ a Saron nɩbɛ na nyɛ a lɛ, a ba lɩɛb puoro a sɩ Soro. ");
INSERT INTO biv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pɔɔ kɔ̃ɔ mɩ na dɔ̃ɔ puoro ben a be Jopa, ka ba bʊɔlɔ wʊ Tabita, a yo bʊ̃'yen 'lɔ̃nɔ̃ lɛ ba lɩɛb bʊɔlɔ Dɔɔkas. Wʊ ma maala na vɩla na wʊ sʊ̃nɔ̃ a nɔ̃n dẽme. ");
INSERT INTO biv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A sɔ̃ɔ 'lɔ̃nɔ̃ lɛ wʊ ɩ baal na wʊ kpi, a ba so wʊ a kʊ̃ɔ don gaal be a bɔɔpɩɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida nɩ a Jopa mɩ ba jãa ɛ, kaa a pupuorbo wõ ɩka a Pita ben a Lida, a ba tʊ̃ nɩbɛ ayi ka ba tɩ sʊɔr wʊ, “Yãayãabɩlɛ a wʊ wa fɔɔ.” ");
INSERT INTO biv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ka bala naa Pita jaa 'mataa chen, wʊn wa ta ba de wʊn don be a bɔɔpɩɛ die pɔ. A pɔɔkɔɛ ba jaa ara na jilʊ̃ wʊ kõnõ na ba wile a Pita a fuusɩ nɩ a fɔɔr a Dɔɔkas na maal wʊn dɔ̃ɔ chɛnɛ be a ba sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita diin ba jaa a ba yi a be a die pɔ, tɩ na wʊ gbur dumo sʊɔr Nãaŋmɩn, na wʊ lɩɛb tor a kũu tɩ 'yɛr, “Tabita ir.” A wʊ yuo a nɩbie nyɛ a Pita na wʊ ir jãnɛ. ");
INSERT INTO biv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ka a Pita nyɔɔ wʊ a nũu sʊ̃ʊ wʊ a wʊ ir ara, tɩ pãa bʊɔl a bala na sɔɔ nɩ a pɔɔkɔɛ ka ba kpɛ wa nyɛ a wʊ ɩ nɩ nɩbir. ");
INSERT INTO biv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ka a yele nyãna yaar a Jopa wʊ jaa ka a nɩbɛ yɔɔ jie wa sɔɔ a sɩ Soro. ");
INSERT INTO biv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","A Pita jɛ̃n be a Jopa bãlãa a daba kɔ̃ɔ ban bʊɔlɔ Simon na ma nɔ̃nɔ̃ gãma yir. ");
INSERT INTO biv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Be a Sisariya, daba kɔ̃ɔ dɔ̃ɔ be be a ba bʊɔlɔ wʊ Konɩlɩyɔs, wʊ be naa a sojasɩ gbul 'lɔ pɔ a Itali nɩbɛ na bʊɔlɔ a sojasɩ kɔbaa nɩkpɛ̃ɛ. ");
INSERT INTO biv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","'Lɔ naa wʊ yir dẽme ba jaa puoro naa na ba joro Nãaŋmɩn dãbãɛ, na wʊ ma kʊrɔ a nɩbɛ bala an wõnõ pɔrɔ, na wʊ mɩ ma sʊɔrɔ a Nãaŋmɩn ba gala ɛ. ");
INSERT INTO biv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Bɩbir ãsʊɔ lɛ a mɔ̃tɔ̃ɔ na wa bal, a wʊ gã jãn jaa chɛchɛ nyɛ a Nãaŋmɩn malaka a wʊ wa ara a wʊ sɛ̃ tɩ bʊɔl wʊ, “Konɩlɩyɔs.” ");
INSERT INTO biv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ka wʊ chaal a lɛ 'yɔ̃ɔ wʊ tɩ sʊʊr, “Bo lɛ N Soro?” Ka a malaka 'yɛr, “A fʊ puorfʊ nɩ a kʊfʊ fʊn kʊrɔ a nɔ̃n dẽme don tɩ pɔɔ a Nãaŋmɩn ka wʊ tara a fʊ tɩɛr. ");
INSERT INTO biv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pʊ̃pãanyã, tʊ̃ nɩbɛ ka ba chen a Jopa tɩ tara daba kɔ̃ɔ na di Simon tɩ ba bʊɔlɔ wʊ Pita a wʊ wa. ");
INSERT INTO biv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wʊ kpɩɛrɛ naa a daba na nɔ̃nɔ̃ gãma mɩ na di a Simon yir, ka a wʊ yir gbʊr a man kpɛ̃ɛ gogoro.” ");
INSERT INTO biv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","A malaka na wa chen baar, Konɩlɩyɔs bʊɔl naa a wʊ tʊ̃tʊ̃nbɔ ayi nɩ a soja ãsʊɔ mɩ na puoro na ma sʊ̃nɔ̃ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Wʊ man a lɛ jaa na ɩ tɩ tʊ̃ ba a Jopa. ");
INSERT INTO biv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","A wɛr na wa chaar mɔ̃tɔ̃tuo sʊ̃ɔ, ka ba be a sɔr pɔ chiine tɩ gbʊrɔ a tẽe, a Pita mɩ don a gar ju Nãaŋmɩn sʊɔrfʊ jie. ");
INSERT INTO biv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ka a kɔ̃ kpɛ wʊ a wʊ bʊɔrɔ bʊ̃kɔ̃ɔ na di, ban chɛnɛ maala a bʊ̃diir ka a dedee kpɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A wʊ nyɛ saaju na yuo a wʊ nyɛ bʊ̃kɔ̃ɔ fɩka fɔkpɛ̃ɛ na gbũ jiir anaar ka wʊ suro wa gbʊrɔ a tẽe. ");
INSERT INTO biv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ka a dʊ̃gbɛɛ anaar a jaa bʊrɔ be be nɩ a tẽe bʊ̃vʊʊrsɩ nɩ a lubilɔɔrsɩ a jaa. ");
INSERT INTO biv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Be lɛ a kɔkɔr pãa 'yɛr kʊ wʊ, “Pita, ir kʊ 'wɔb.” ");
INSERT INTO biv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tɩchɛ ka a Pita 'yɛr, “Sɩrɛ jaa, kai. N Soro, n ba 'wɔb a dʊ̃dɛbɛ anyãna nɩ a dʊ̃chiirsɩ anyãna ãsʊɔ jaa ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ka a kɔkɔr lɛ 'yɛr go, “Ta bʊɔl bon jaa bʊ̃dɛɛr 'lɔ a Nãaŋmɩn na maal a wʊ ɩ bʊ̃sʊ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Gbɛɛ ata lɛ a ɩ, tɩchɛ ka a fɔbaa lɛ jaa a lɛ nɛ don a saaju ajienaa. ");
INSERT INTO biv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lɛ a Pita na chɛnɛ pɛrɛ a nyɛfʊ nyã par, ka a dɔɔr bala a Konɩlɩyɔs na tʊ̃ mɩ nyɛn a Simon yir na ba ara a dɔ̃dɔr nɛɛ. ");
INSERT INTO biv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ba bʊɔl sʊʊr, “Daba na di Simon tɩ ba bʊɔlɔ wʊ Pita ka lɛ wʊ kpɩɛrɛ ɔ?” ");
INSERT INTO biv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Lɛ a Pita na chɛnɛ tɩɛrɛ a nyɛfʊ nyãna ka a Nãaŋmɩn Sɩɛ 'yɛr kʊ wʊ, “Simon, dɔɔr ata lɛ bʊɔrɔ fʊ sʊrɔ. ");
INSERT INTO biv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ir suu a ba sɛ̃, taa ɩrɛ wa baala fʊn na lɔ̃ɔ chiin ba ɛ, maa lɛ tʊ̃ ba.” ");
INSERT INTO biv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ka a Pita ir suu tɩ nyɛ a nɩbɛ na wʊ 'yɛr, “Maa lɛ ɩ a nɩrɛ yɩn bʊɔrɔ, bãa 'yɔ̃ɔ yɩ wa?” ");
INSERT INTO biv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","A ba 'yɛr, “Konɩlɩyɔs na ɩ a sojasɩ nɩkpɛ̃ɛ sɛ̃ lɛ sɩ yi. A wʊ yele tor naa ka wʊ ɩ nɩrɛ na joro Nãaŋmɩn dãbãɛ ka a Juu nɩbɛ ba jaa 'yɔ̃ɔnɔ̃ wʊ. A Nãaŋmɩn malaka wa 'yɛr kʊ wʊ ɩka wʊ bʊɔl fʊ a fʊ wa be a wʊ yir a wʊ wõ lɛ jaa fʊn na man.” ");
INSERT INTO biv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","A Pita pãa tara ba kpɛ̃n tɩ gaal. Ka a wɛr chaar, a bala nɩ a Pita nɩ a pupuorbiir bamɩne na yi a Jopa pʊɔ ba a ba 'mataa chen. ");
INSERT INTO biv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ba chen ka a wɛr tɩ chaar a ba ta a Sisariya, ka a ɩ a Konɩlɩyɔs mɩ chɛlɛ ba naa na wʊ bʊɔl a wʊ yir dẽme nɩ a wʊ barmɩne ba jaa lɔ̃ɔ taa a ba jɛ̃ gu. ");
INSERT INTO biv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Lɛ a Pita na ta kpɩɛrɛ a Konɩlɩyɔs yir wʊ ir tuor a Pita gbur dumo a wʊ niem na wʊ puor wʊ nɩ 'yɔ̃ɔfʊ. ");
INSERT INTO biv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tɩchɛ ka a Pita nyɔɔ wʊ a wʊ ir, ka wʊ 'yɛr, “Ara, a maa mɩ nɩsaal lɛ n mɩ ɩ.” ");
INSERT INTO biv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Wʊ 'yɛr wʊ naa lɛ tɩ kpɛ a die pɔ tɩ nyɛ nɩyɔɔ na duo. ");
INSERT INTO biv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","A wʊ 'yɛr kʊ ba, “Yɩn mãɛ bɔ̃ɔn naa an ba tara sɔr ɩka a sɩn Juu nɩbɛ ba lɔ̃ɔnɔ̃ nɩ a yɩn bala na ba ɩ a Juu nɩbɛ ɛ. Tɩchɛ Nãaŋmɩn wiil ma naa ɩka n taa bʊɔl nɩrɛ jaa nɩdɛɛr ɛ, bɩɩ nɩsɔ̃ɔ naa ɛ. ");
INSERT INTO biv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ala lɛ so yɩn wa bʊɔl ma n ba baala ɛ, bɩɩ 'yɛr ɩka n kʊ̃ wa ɛ, bo 'yɔ̃ɔ lɛ yɩ bʊɔl ma?” ");
INSERT INTO biv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ka a Konɩlɩyɔs 'yɛr, “Ber anaar nɩ dɩna ɩn be a die pɔ sʊɔrɔ Nãaŋmɩn a mɔ̃tɔ̃ɔ na bal baar. Ajienaa lɛ ka a ɩ daba na su fuu ka wʊ nyɩlɛ wa ara a n sɛ̃, ");
INSERT INTO biv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","tɩ na wʊ bʊɔl ma, ‘Konɩlɩyɔs, Nãaŋmɩn wõn a fʊ sʊɔrfʊ na wʊ tɩɛr a fʊ kʊfʊ fʊn kʊrɔ a nɔ̃n dẽme. ");
INSERT INTO biv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tʊ̃ nɩrɛ a wʊ chen a Jopa tɩ bʊɔl Simon ban lɛ bʊɔlɔ Pita, wʊ be naa a daba ban bʊɔlɔ a Simon na nɔ̃nɔ̃ gãma ka a yir gbʊr man gogoro.’ ");
INSERT INTO biv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ala lɛ so ka n mɩ tʊ̃ a fɔɔ a lɛ nɛ bʊɔl fʊ, a fʊ mɩ pɛl pʊɔ tɩ wa. Pʊ̃pãanyã, Nãaŋmɩn niem lɛ sɩ jaa jãnɛ tɩ na chɛl bon jaa a sɩ Soro na tʊ̃n fʊ ɩka fʊ wa 'yɛr kʊ sɩ.” ");
INSERT INTO biv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ka a Pita pãa piel na wʊ 'yɛrɛ, “Pʊ̃pãanyã n pãa bɔ̃ɔn naa ɩka Nãaŋmɩn ba ooro ɛ. ");
INSERT INTO biv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tɩchɛ wʊ ma den nɩbʊrɔ ba jaa na joro wʊ dãbãɛ tɩ maal a lɛ na tor. ");
INSERT INTO biv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","A 'yɛr nʊ̃ɔ nyã lɛ a Nãaŋmɩn tɩr kʊ a Isɩral nɩbɛ nɩ a nyã'maar 'yɛr na tu a Yesu Kɩrɩsɩto na ɩ a bon jaa Soro sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yɩ bɔ̃ɔn naa ala na ɩ a Judiya paal wʊ jaa na piel a Galilee a lɛ a Jɔɔn na wa mʊɔl a Nãaŋmɩn kʊ̃ɔ sofʊ 'yɛr baar. ");
INSERT INTO biv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Lɛ a Nãaŋmɩn na ir a Yesu na yi Najaretɩ na wʊ de a wʊ Sɩɛ nɩ a wʊ kpɛ̃ɔ kʊ wʊ. Wʊ yɔn a ka wʊ jaa jilʊ̃ na wʊ maala vɩla sãana nɩ baalsɩ nɩ a bala jaa a dɛɛr sʊɔ na tara, bojũu Nãaŋmɩn ben a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Sɩn lɛ nyɛn nɩbir, a ala a jaa wʊn tʊ̃ a Juu nɩbɛ tẽn pɔ, nɩ a Jerusalɛm. Ba nyɔɔ wʊn kpa yɔɔl a daa ju ka wʊ kpi. ");
INSERT INTO biv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tɩchɛ Nãaŋmɩn sãɩ wʊ naa a kũu pɔ, a ber ata daar a wʊ ir ɩ vʊr na wʊ vɛ̃ a ba nyɛ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nɩbɛ ba jaa ba lɛ nyɛ wʊ ɛ, tɩchɛ a sɩn na ɩ a dãasɩɛ dẽme a Nãaŋmɩn na de nie ir, sɩn nɩ 'lɔ 'mantaa di tɩ nyũ wʊn wa ir a kũu pɔ baar. ");
INSERT INTO biv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","'Lɔ lɛ kpãkpãan sɩ ɩka sɩ mʊɔl 'yɛr kʊ a nɩbɛ ɩka 'lɔ lɛ a Nãaŋmɩn ir ka wʊ ɩ a vʊɛ nɩ a kpĩisɩ 'yɛr tɔɔrɔ. ");
INSERT INTO biv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","'Lɔ lɛ a Nãaŋmɩn 'yɛ'yɛrbɛ ba jaa 'yɛr a wʊ 'yɛr ɩka, nɩrɛ jaa wa sɔɔ de wʊ, wʊn nyɛn yelbier vɛ̃ kʊfʊ tu a wʊ yuor pɔ.” ");
INSERT INTO biv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lɛ a Pita na chɛnɛ 'yɛrɛ a anyãna, ka a Nãaŋmɩn Sɩɛ wa kpɛ a bala jaa na wõnõ a 'yɛr nyãna. ");
INSERT INTO biv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ka a Juu nɩbɛ bala na sɔɔ de na tu a Pita wa, nɛɛ 'maa ba naa a lɛ ban nyɛ a Nãaŋmɩn na pʊr a wʊ Sɩɛ 'yɔ̃ɔ a bala na ba ɩ a Juu nɩbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","A ba wõ ban 'yɛrɛ kɔkɔyor na ba pɛɛrɛ nɩ a Nãaŋmɩn. Ka a Pita pãa 'yɛr, ");
INSERT INTO biv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Nɩrɛ na tʊ̃ɔ ŋmaa a nɩbɛ banyãna sɔr ka ba ta so a Nãaŋmɩn kʊ̃ɔ ɛ? Ba mɩ nyɛn a Nãaŋmɩn Sɩɛ nɩtãa a sɩn.” ");
INSERT INTO biv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Wʊ 'yɔ̃ɔ ba naa ka ba so a Nãaŋmɩn kʊ̃ɔ nɩ Yesu Kɩrɩsɩto yuor, a ba pãa sʊɔr a Pita ka wʊ be a ba sɛ̃ bãlãa. ");
INSERT INTO biv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","A nɩtʊ̃nsɩ nɩ a yɛɛr na be a Judiya wõ naa ɩka a bala na ba ɩ a Juu nɩbɛ ɛ, mɩ sɔɔn a Nãaŋmɩn 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lɛ a Pita na wa lɩɛb chen a Jerusalɛm a bala na ŋmaa a yʊɔr tɩ sɔɔl mii 'yɔ̃ɔ wʊ 'yɛrɛ, ");
INSERT INTO biv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Fʊ ben chen a bala na ba ŋmaa a yʊɔr yir tɩ lɔ̃ɔ din ba wɛ?” ");
INSERT INTO biv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ka a Pita pãa piel mana a lɛ jaa na ɩ na wʊ kʊ ba, ");
INSERT INTO biv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“N ben a Jopa tẽe pɔ naa sʊɔrɔ Nãaŋmɩn ka a wa ɩ ma jaa de dee, ka n nyɛ nyɛfʊ kɔ̃ɔ. N nyɛn bʊ̃kɔ̃ɔ fɩka fɔkpɛ̃ɛ ban tur bar ka wʊ yi saaju suu na wʊ gbũ jiir anaar ka wʊ suu wa ara a be ɩn be. ");
INSERT INTO biv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Be lɛ n muul kaa naa nyɛ dʊ̃gbɛɛ anaar jaa bʊrɔ na be ka a wɛr pɔ, mɔdʊ̃n, bʊ̃vʊʊrsɩ lɔ̃ɔn a lubil. ");
INSERT INTO biv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ka n wõ kɔkɔr na 'yɛr, ‘Pita ir na fʊ kʊ 'wɔb.’ ");
INSERT INTO biv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ka n haa 'yɛr, ‘Kai, n Soro bon jaa na ɩ dɛɛr na ba vɩɛlɛ ɛ, ba kpɛ n nɛɛ pɔ jaa ɛ.’ ");
INSERT INTO biv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ka a kɔkɔr lɛ 'yɛr yi a saaju go, ‘Ta bʊɔl bon jaa Nãaŋmɩn na maal a wʊ vɩɛlɛ bʊ̃dɛɛr ɛ.’ ");
INSERT INTO biv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A anyãna ɩ naa nɩtɔ̃nɔ̃ gbɛɛ ata tɩ lɛ tɔɔ a jaa don be a saaju go. ");
INSERT INTO biv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ajienaa, ka a ɩ a nɩbɛ ata ban tʊ̃ a n sɛ̃ na yi Sisariya mɩ tãn a yir 'lɔ pɔ ɩn kpɩɛrɛ dɔ̃dɔr nɛɛ. ");
INSERT INTO biv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ka a Nãaŋmɩn Sɩɛ 'yɛr kʊ ma ka n tu ba chen naa taa baala ɛ. Maa nɩ a yɛɛr ayʊɔb banyãna lɛ 'mataa chen na sɩ tɩ kpɛ a daba yir. ");
INSERT INTO biv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","A wʊ man kʊ sɩ a lɛ a malaka na wa a wʊ yir wa 'yɛr, ‘Tʊ̃ nɩbɛ a Jopa ka ba tɩ bʊɔl daba na di Simon ban lɛ bʊɔlɔ Pita. ");
INSERT INTO biv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","'Lɔ lɛ na waan 'yɛr wa 'yɛr kʊ fʊ ka a fʊ̃ʊ nɩ a fʊ yir dẽme ba jaa tu a 'yɛr 'lɔ pɔ nyɛ faafʊ.’ ");
INSERT INTO biv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ala lɛ ka n piel a 'yɛr naa 'yɛrɛ, ka a Nãaŋmɩn Sɩɛ wa a ba sɛ̃ a lɛ wʊn dɔ̃ɔ wa a sɩ sɛ̃ a pielfʊ. ");
INSERT INTO biv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ka n pãa tɩɛrtɔ a lɛ a sɩ Soro na dɔ̃ɔ 'yɛr, ‘Jɔɔn den kʊ̃ɔ son, tɩchɛ yɩn 'lɔ Nãaŋmɩn na den a wʊ Sɩɛ son yɩ.’ ");
INSERT INTO biv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ala ɩ Nãaŋmɩn lɛ kʊ ba, a kʊfʊ bʊ̃'yen 'lɔ̃nɔ̃ wʊn dɔ̃ɔ kʊ sɩ a sɔ̃ɔ 'lɔ sɩn sɔɔ de a sɩ Soro Yesu Kɩrɩsɩto, maa mɩ nɩ ana, na ŋmaa Nãaŋmɩn sɔr?” ");
INSERT INTO biv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ban wõ a anyãna, baa lɛ haa nɛɛ ɛ, tɩ pɛɛrɛ Nãaŋmɩn 'yɛrɛ, “Nãaŋmɩn pãa yuon sɔr kʊ a bala na ba ɩ a Juu nɩbɛ ɛ, ka ban lɩɛb a ba tɩɛr nyɛ nyɛvʊr.” ");
INSERT INTO biv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","A sɔ̃ɔ 'lɔ̃nɔ̃ ban kʊ a Sɩteven ka a pupuorbo bamɩne yɛ̃yɛl tɩ yi Fonisiya, Sipurusɩ nɩ Antiok, na ba mana a 'yɛr kʊrɔ a Juu nɩbɛ tɛɛ. ");
INSERT INTO biv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ka a pupuorbo bamɩne na yi a Sipurusɩ nɩ a Sirenɩ, chen a Antiok na ba mɩ tɩ piel 'yɛrɛ a sɩ Soro Yesu Kɩrɩsɩto 'yɛr nʊ̃ɔ nyã kʊrɔ a bala na ba ɩ a Juu nɩbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","A sɩ Soro nũu dɔ̃ɔ pʊɔ ba ka a nɩyɔɔ dɔ̃ɔ sɔɔ de na ba lɩɛb turo a sɩ Soro. ");
INSERT INTO biv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ka a 'yɛr nyã lo a pupuorbo na be a Jerusalɛm toor pɔ, a ba ir Banabasɩ tʊ̃ a be Antiok. ");
INSERT INTO biv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wʊn tɩ ta nyɛ a lɛ Nãaŋmɩn na wãɛ ba, nʊ̃ɔ kpɛ wʊ naa ka wʊ 'yɔ̃ɔ ba ãkpɛ̃ɔ tɩ 'yɛr, ka ba ara nɩ yelmãɛ nɩ a ba nyãa wʊ jaa kʊ a sɩ Soro. ");
INSERT INTO biv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasɩ mɩ dɔ̃ɔ ɩ nɩsʊ̃ na sɛɛn a Nãaŋmɩn Sɩɛ na wʊ tara sɔɔfʊ na wʊ mɩ tɔɔ nɩyɔɔ waan a ba wa turo a sɩ Soro. ");
INSERT INTO biv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ala puor lɛ ka a Banabasɩ pãa yɩ a be tu Tasusɩ tɩ bʊɔrɔ a Sɔɔl. ");
INSERT INTO biv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wʊn tɩ nyɛ wʊ, ba lɩɛb wa Antiok na ba be be yuon gbul, ka a Banabasɩ naa Sɔɔl wile a nɩyɔɔ bala. Be a Antiok lɛ a pupuorbo nyɛ a yuor, “Kɩrɩsɩto turbo.” ");
INSERT INTO biv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A sɔ̃ɔ nyãna lɛ a Nãaŋmɩn 'yɛ'yɛrɛ yi be a Jerusalɛm wa Antiok. ");
INSERT INTO biv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","A ba ãsʊɔ yuor na di Agabus ir ara, ka Nãaŋmɩn Sɩɛ kpɛ wʊ a wʊ 'yɛr, “Kɔ̃kpɛ̃ɛ na lon a Worom wɛr wʊ jaa.” A kɔ̃ nyãna wa lo naa a sɔ̃ɔ 'lɔ a Kɩlaudiyus na di a nãa. ");
INSERT INTO biv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","A poturbo banyãna mɔ̃ naa na ba ir bʊ̃kɔ̃ɔ lɛ a ba fɔ̃ɔ na jã na ba sʊ̃ʊn a yɛɛr bala na be a Judiya. ");
INSERT INTO biv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ban wa ir a kʊfʊ anyãna, Banabasɩ nɩ a Sɔɔl lɛ ba tʊ̃n a ba tɩ kʊ a nɩbɛrɛ. ");
INSERT INTO biv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","A sɔ̃ɔ nyãna lɛ a Nãa Hɛrɔd nyɔɔr a pupuorbo bamɩne na wʊn ge. ");
INSERT INTO biv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wʊ vɛ̃ naa ka ba ŋmaa Jemesɩ na ɩ a Jɔɔn yɛbɛ ju. ");
INSERT INTO biv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","A Hɛrɔd nyɛn a lɛ ka a pɛl a Juu nɩbɛ pʊɔ, ka wʊ nyɔɔ a Pita mɩ. A anyãna ɩ naa a sɔ̃ɔ 'lɔ ban tara a Paanʊ̃kõo Lɔ̃ɔfʊ. ");
INSERT INTO biv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wʊn nyɔɔ a Pita a lɛ, a pɔɔfʊ die pɔ lɛ wʊ tɩ pɔɔ wʊ, tɩ na wʊ 'yɔ̃ɔ sojasɩ jiir anaar ka ba jʊrɔ taa kaara nɩ wʊ. Bojũu wʊ bʊɔrɔ naa ɩka a Gõl Bar Difʊ wʊ po baar tɩchɛ ka wʊ tɔɔr a wʊ 'yɛr ka nɩrɛ jaa nyɛ. ");
INSERT INTO biv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Lɛ lɛ ba gu a Pita be a pɔɔfʊ die pɔ, tɩchɛ ka a pupuorbiir mʊ̃ɔ nɩbir sʊɔrɔ Nãaŋmɩn kʊrɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A tãsɔɔ 'lɔ̃nɔ̃ a wɛr na chaar ka a Hɛrɔd na vɛ̃ ka ba waan a Pita ka wʊ tɔɔr a wʊ 'yɛr, bɔ̃jɔrsɩ ayi lɛ ba 'yɔ̃ɔ a Pita gbɛb sojasɩ ayi ka wʊ be a ba sãlsɔɔ gã guro, ka a sojasɩ bamɩne ara a pɔɔfʊ die dɔ̃dɔr nɛɛ gu. ");
INSERT INTO biv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ajienaa lɛ a sɩ Soro malaka wa kpɛ ara a wʊ sɛ̃ be a pɔɔfʊ die pɔ, ka a die wʊ jaa chaar. Ka a malaka ŋme a Pita jaa 'mɛ 'mɛ 'mɛ, sãɩ wʊ 'yɛr, “Pɔɔ fɔɔ jaa ir,” ka a bɔ̃jɔrsɩ for a Pita nũ'yɔ̃ɔ pɔ lo. ");
INSERT INTO biv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Be lɛ a malaka 'yɛr kʊ a Pita, “Su a fuu nɩ a nafɔbɔ na fʊ 'mɔɔ a fɔbaa vaar na fʊ turo nɩ ma.” Ka a Pita ɩ a lɛ a malaka na 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita tu wʊn a lɛ tɩ yin a pɔɔfʊ die pɔ, tɩchɛ nɩbir ba yuo wʊ a wʊ bɔ̃ɔn ɩka a lɛ a malaka na 'yɔ̃ɔ a wʊ maala ɩn sɩrɛ ɛ, wʊ tɩɛr man tãa jãn lɛ wʊ jãna. ");
INSERT INTO biv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ba tɩ yin a dɔ̃dɔr dɔ̃ɔ 'lɔ pɔ, na ba lɛ tɩ yi a dɔ̃dɔr ayi sʊɔ pɔ, tɩ pãa ta a yõo dɔ̃dɔr a kur pãn na pɔɔ. Ban wa ta a wʊ yuo wʊ yõ a ba yi. A malaka tara na a Pita den a sɔr dẽdẽe ãsʊɔ chiin bãlãa tɩ bar wʊ tɩ chen ajienaa. ");
INSERT INTO biv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ka Pita tɩɛr pãa yuo a wʊ 'yɛr, “Pʊ̃pãanyã n bɔ̃ɔn naa an ba ɩ baal ɛ, ɩka a Nãaŋmɩn lɛ tʊ̃ a wʊ malaka a wʊ wa 'loo ma faa a Hɛrɔd nũu pɔ, nɩ a lɛ jaa a Juu nɩbɛ na tɩɛr ɩka ba ge ma.” ");
INSERT INTO biv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","A anyãna wʊn wa tɩɛr yuo, wʊ chen a Mɛɛr na ɩ a Jɔɔn Maakɩ ma yir, be lɛ a pupuorbiir yɔɔ lɔ̃ɔ taa sʊɔrɔ Nãaŋmɩn kʊrɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita wa kpoor a yõo dɔ̃dɔr pãn, ka a gbãgbaa pɔɔbile ban bʊɔlɔ Woroda chen a pãn yuofʊ jie. ");
INSERT INTO biv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Wʊn wa wõ ka a ɩ Pita kɔkɔr lɛ ka a nʊ̃ɔ kpɛ wʊ tɩ põn bar, waa yuo a pãn ɛ, tɩ lɩɛb jo kpɛ a die pɔ tɩ 'yɛrɛ, “Pita lɛ be a yõo dɔ̃dɔr nɛɛ!” ");
INSERT INTO biv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","A ba tãn wʊ pĩpĩi bar tɩ 'yɛr kʊ wʊ, “Gelfʊ baal lɛ kpɛ fʊ!” Tɩ wʊ chɛnɛ mʊ̃ɔ nɩbir 'yɛrɛ ɩka sɩrɛ jaa lɛ, ka ba 'yɛr, “A wʊ malaka tɔ̃ɔ lɛ.” ");
INSERT INTO biv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tɩchɛ ka a Pita chɛnɛ kpooro a pãn, ka ba tɩ yuo nyɛ ka a ɩ 'lɔ lɛ ka a nɛɛ 'maa ba. ");
INSERT INTO biv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ka a Pita wɩlwɩl ba a nũu a ba bar gɔ̃n tɩchɛ ka wʊ man a lɛ a sɩ Soro na yin wʊ a pɔɔfʊ die pɔ. Wʊ 'yɛr kʊ ba ɩka ba tɩ 'yɛr kʊ a Jemesɩ nɩ a yɛɛr, na wʊ bar ba tɩ yi chen jiyuo. ");
INSERT INTO biv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","A wɛr na chaar bibio, ka a sojasɩ ɩ chĩcham na ba sʊrɔ taa, “Bo lɛ na tara a Pita?” ");
INSERT INTO biv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hɛrɔd vɛ̃n ka ba yɔbɔ wʊ faa na baa nyɛ wʊ ɛ, na wʊ kpãkpãan a sojasɩ mɩ faa tɩ 'yɛr ɩka ba kʊ ba. Ka a Hɛrɔd pãa yi a Judiya na wʊ chen a Sisariya na wʊ tɩ jãnɛ a be bãlãa. ");
INSERT INTO biv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","A Hɛrɔd dɔ̃ɔ tara a Tire nɩbɛ nɩ a Sidon nɩbɛ nɩ jɛɛr, ka ba nyɛtaa nɛɛ na wa a nãa 'maalfʊ jie. Blastus na ɩ a nãa gbãgbaa wʊn 'yɔ̃ɔnɔ̃ sɛ̃ lɛ ba tʊ̃ ɩka wʊ 'maal a nãa kʊ ba bojũu a wʊ wɛr pɔ lɛ ba nyɛrɛ a ba bʊ̃diir. ");
INSERT INTO biv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Bɩbir kɔ̃ɔ, a Nãa Hɛrɔd sun a wʊ nafɔɔr jãnɛ nɩ a nãa dakɔɔ ju, na wʊn 'yɛr 'yɛr kʊ a nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ka a nɩbɛ ŋmiere chɛlsɩ 'yɛrɛ, “Ŋmɩn kɔkɔr lɛ a nyãna na 'yɛrɛ, nɩrɛ ba lɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ajienaa lɛ ka a sɩ Soro malaka wa 'yɔ̃ɔ wʊ baal bojũu waa de a 'yɔ̃ɔfʊ kʊ a Nãaŋmɩn ɛ, ka a bufulo 'wɔb a nyaba ŋma ka wʊ kpi. ");
INSERT INTO biv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tɩchɛ ka a Nãaŋmɩn 'yɛr chɛnɛ yaara. ");
INSERT INTO biv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lɛ a Banabasɩ nɩ a Sɔɔl na wa tʊ̃ a ba tʊ̃mɔ̃ baar a Jerusalɛm, ba tara naa Jɔɔn Maakɩ 'mataa chiin. ");
INSERT INTO biv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","A Nãaŋmɩn puorbo bala na be a Antiok, ba tara naa bamɩne ka ba 'yɛrɛ a Nãaŋmɩn 'yɛr ka a bamɩne mɩ ɩ wiwiilbe, Banabasɩ nɩ Simeon ban bʊɔlɔ Nɩsɔɔlaa, Lusiyusɩ na yi a Sirenɩ tẽe pɔ, nɩ Manayen ban dɔ̃ɔ 'mataa guol a Nãa Hɛrɔd, nɩ a Sɔɔl. ");
INSERT INTO biv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","A lɛ ban gal a kɔ̃ na ba sʊɔrɔ a sɩ Soro, ka a Nãaŋmɩn Sɩɛ 'yɛr kʊ ba, “Yɩ ir a Banabasɩ nɩ a Sɔɔl kʊ ma ka ba tʊ̃ a tʊ̃mɔ̃ 'lɔ 'yɔ̃ɔ ɩn bʊɔl ba.” ");
INSERT INTO biv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","A lɛ ban gal a kɔ̃ ba di bon jaa ɛ, ba dɔɔl ban a nuur sʊɔr Nãaŋmɩn kʊ ba tɩ bar ba sɔr ka ba chen. ");
INSERT INTO biv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","A nɩbɛ ayi banyãna den a sɔr ka a Nãaŋmɩn de ba nie suun be a Selusiya na ba tɩ kpɛ a gboro chiine a Sipurusɩ. ");
INSERT INTO biv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Lɛ ban tɩ ta a Salamis, ba mʊɔl a Nãaŋmɩn 'yɛr a be a Juu nɩbɛ lɔ̃ɔfʊ jiir. Ka a Jɔɔn Maakɩ be a ba sɛ̃ na wʊ sʊ̃nɔ̃ ba. ");
INSERT INTO biv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ba yɔn a man dõdol wʊ jaa tɩ ta Pafos, be lɛ ba tuor a Juu nɩrɛ jɩbʊrɔ ãsʊɔ na ma ŋmara jirsɩ ka a wʊ yuor di Bar-Yesu. ");
INSERT INTO biv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wʊ dɔ̃ɔ be a Segiyusɩ Pɔɔlusɩ na kaara a dõdol na ɩ yɛ̃ sʊɔ, a tẽkaara nyãna lɛ bʊɔl a Banabasɩ nɩ a Sɔɔl bʊɔrɔ ɩka wʊ wõ a Nãaŋmɩn 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Tɩchɛ a Elimasɩ na ɩ a jɩbʊrɔ a wʊ yuor par lɛ a lɛ nɛ, ŋmaan a Banabasɩ nɩ a Sɔɔl sɔr ba bʊɔrɔ ɩka a tẽkaara nyãna wʊ sɔɔ a Yesu ɛ. ");
INSERT INTO biv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ka a Sɔɔl nyãna ban bʊɔlɔ a Pɔɔl na sɛɛn a Nãaŋmɩn Sɩɛ kaara a Elimasɩ jaa tãɩɩ tɩ wa 'yɛr kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Fʊ ɩn Satan bie na fʊ ɩ bʊ̃sʊ̃n a jaa dɔ̃dɔ̃mɔ̃. A fʊ pʊɔ sɛɛn naa bɛlfʊ nɩ bɛlfʊ 'yɛr bie, fʊ kʊ̃ bar a jir fʊn bʊɔrɔ ɩka fʊ sɔ̃ɔn a sɩ Soro sɔr dẽdẽe bar ɛ? ");
INSERT INTO biv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Pʊ̃pãanyã a sɩ Soro na ŋme fʊ naa ka fʊ jɔ̃ɔ tɩ tãn sɔ̃ɔ kɔ̃ɔ, fʊ kʊ̃ lɛ tʊ̃ɔ nyɛ mɔ̃tɔ̃ɔ chãa ɛ.” Ajienaa lɛ a Elimasɩ nɩbie de, ka a libe pɔɔ wʊ, ka wʊ bɔɔlɔ bʊɔrɔ nɩrɛ na nyɔɔ wʊ nũu. ");
INSERT INTO biv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","A lɛ a tẽkaara na nyɛ a lɛ na ɩ, wʊ sɔɔn de, bojũu nɛɛ 'maa wʊ naa a lɛ ban wile a sɩ Soro yele. ");
INSERT INTO biv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔɔl nɩ a wʊ taaba kpɛ̃n a gboro yi a Pafos chen be a Perga na be a Pamfiliya be lɛ a Jɔɔn Maakɩ tɩ bar ba tɩ lɩɛb chen a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ka ba yi a Perga chen Antiok na gbʊr a Pisidiya, a Pɛ̃nfʊ Bɩbir daar ba kpɛ̃n a lɔ̃ɔfʊ jie na ba tɩ jãnɛ. ");
INSERT INTO biv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ban wa kar a Mosesɩ Nɛɛ nɩ a ala a Nãaŋmɩn 'Yɛ'yɛrbɛ na sɛb baar, a lɔ̃ɔfʊ jie nɩbɛrɛ sʊʊr naa Pɔɔl nɩ a wʊ taaba, “Yɛɛr, yɩn tara 'yɛr na sʊ̃ʊn a nɩbɛ sɩ kʊ yɩn sɔr, yɩ 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ka a Pɔɔl vaa ir wɩlwɩl ba a nũu tɩ 'yɛrɛ, “Isɩral nɩbɛ woɩ, nɩ a yɩn na ba ɩ a Isɩral nɩbɛ ɛ, na puoro a Nãaŋmɩn, yɩ chɛlɛ a lɛ ɩn 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","A Nãaŋmɩn nyã a sɩn Isɩral nɩbɛ na puoro lɛ dɔ̃ɔ chɛl ir a sɩ sãakpãmɩne na wʊ vɛ̃ ka ba dɔɔ paal be a Ijipitɩ pɔ. Kpɛ̃ɔ lɛ wʊ de faan ba yin a paal 'lɔ pɔ, ");
INSERT INTO biv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","na wʊ bɔ̃ɔ tara ba be a mɔgɔ̃ɔ pɔ yuom lɩjaayi (40). ");
INSERT INTO biv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Paal bʊrsɩ ayopõi lɛ a Nãaŋmɩn dii bar be a Kanaan tɩ de a wɛr 'lɔ kʊ a wʊ nɩbɛ ka a ɩ ba sofʊ. ");
INSERT INTO biv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“A anyãna a jaa lɔ̃ɔn taa ɩ yuom kɔɔr anaar dɔɔl lɩjaayi nɩ pie (450). A anyã puor, Nãaŋmɩn kʊ ban 'yɛr tɔɔrbɔ tɩ tãn a Samuwɛl na ɩ a Nãaŋmɩn 'yɛ'yɛrɛ sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Be lɛ ka a nɩbɛ pãa wa sʊɔr Samuwɛl a wʊ bɔ nãa kʊ ba, ka Nãaŋmɩn de a Sɔɔl na ɩ a Kɩsɩ bidaba kʊ ba na ɩ a Benjamin bal nɩrɛ a wʊ ɩ a ba nãa yuom lɩjaayi (40). ");
INSERT INTO biv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Wʊn wa ir a Sɔɔl bar, wʊ den a David ka wʊ ɩ a ba nãa. Nãaŋmɩn 'yɛr naa, ‘N nyɛn a David na ɩ a Jesɩ bidaba ka a n ãgãn 'maa, wʊn maal yele a jaa ɩn bʊɔrɔ ɩka wʊ ɩ.’ ");
INSERT INTO biv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“A Nãa David nyãna bal par pɔ lɛ a Nãaŋmɩn ir a Fafaara Yesu kʊ a Isɩral nɩbɛ nɩtãa lɛ wʊn dɔ̃ɔ tɩr a nɛɛ. ");
INSERT INTO biv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sɛrɛ tɩchɛ ka a Yesu wa, Jɔɔn mʊɔlɔ naa a tɩɛr lɩɛbfʊ 'yɛr na wʊ suoro a Isɩral nɩbɛ ba jaa a Nãaŋmɩn kʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Lɛ a Jɔɔn na wa baaraa a wʊ tʊ̃mɔ̃, wʊ 'yɛr kʊ ba, ‘An lɛ yɩ tɩɛr ɩka n ɩ naa? N ba ɩ a 'lɔ yɩn tɩɛr ɛ, tɩchɛ wʊ ben a n puor waara, n ba sɛɛ ɩka n for a wʊ nafɔbɔ ɛ.’ ");
INSERT INTO biv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Maa yɛɛr na ɩ Abraham yɔn nɩ a yɩn na joro a Nãaŋmɩn dãbãɛ na ɩ a bala na ba ɩ a Juu nɩbɛ ɛ, sɩn 'yɔ̃ɔ lɛ a faafʊ nyãna wa. ");
INSERT INTO biv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bojũu, a nɩbɛ na be a Jerusalɛm nɩ a ba nɩbɛrɛ ba chɛl a Yesu ɛ, na ba 'yɔ̃ɔ wʊ 'yɛr ka a lɛ a Nãaŋmɩn 'yɛ'yɛrbɛ na sɛb a ba ma kara a Pɛ̃nfʊ Bɩbir jaa ɩ. ");
INSERT INTO biv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ba gban ba dɔ̃ɔ nyɛ yele jaa na wiil ɩka wʊ sɛɛn kũu ɛ, tɩ ba sʊɔr a Pilate ɩka wʊ vɛ̃ ka ba kʊ a Yesu. ");
INSERT INTO biv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ban wa maal a lɛ jaa ban sɛb a wʊ yele baar, a wʊ poturbo yɔɔ wʊn a daa ju na ba tɩ ũu a yaa pɔ. ");
INSERT INTO biv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tɩchɛ ka a Nãaŋmɩn ir wʊ a kũu pɔ. ");
INSERT INTO biv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","A ber yɔɔ na wa po, a bala wʊn dɔ̃ɔ lɔ̃ɔ yɔn yin a Galilee tɩ tãn a Jerusalɛm, ba nyɛ wʊ naa, bala lɛ ɩ a dãasɩɛ dẽme a pʊ̃pãanyã kʊ a sɩ nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Sɩn 'yɛrɛ naa a 'yɛr nʊ̃ɔ nyãna kʊrɔ yɩ, a Nãaŋmɩn na dɔ̃ɔ tɩr a nɛɛ kʊ a sɩ sãakpãmɩne. ");
INSERT INTO biv_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nãaŋmɩn maal kʊ a sɩn na ɩ a yɔn a lɛ wʊn dɔ̃ɔ tɩr a nɛɛ kʊ a sɩ sãakpãmɩne, na wʊ sãɩ a Yesu yin a kũu pɔ. Nɩtãa lɛ an sɛb a Yiel Gãma ayi pɔ, ‘Fʊ ɩ naa a maa bie, dɩna n lɩɛb a fʊ sãa.’ ");
INSERT INTO biv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Lɛ a Nãaŋmɩn na sãɩ wʊ a kũu pɔ nɩ nyã, wʊ kʊ̃ lɛ kpi pʊ̃ɔ go ɛ, a 'yɛr nyãna lɛ wʊ 'yɛr, ‘Ɩn kʊ yɩ naa a yelsʊ̃n nɩ a sʊ̃ʊfʊ 'lɔ ɩn tɩr a nɛɛ kʊ a David.’ ");
INSERT INTO biv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","A jie ãsʊɔ lɛ 'yɛr ɩka, ‘Fʊ kʊ̃ vɛ̃ ka a fʊ Chɛchɛ Sʊɔ kpɛ pʊ̃ɔfʊ jie ɛ.’ ");
INSERT INTO biv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“A Nãa David na wa tʊ̃ lɛ a Nãaŋmɩn na bʊɔrɔ a wʊ sɔ̃ɔ, wʊ kpi naa ka ba ũu wʊ be a wʊ sãamɩne yar par, ka a wʊ ãgãn pʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Tɩchɛ a 'lɔ a Nãaŋmɩn na sãɩ a kũu pɔ, ba kpɛ pʊ̃ɔfʊ jie ɛ. ");
INSERT INTO biv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“A lɛ jũu n yɛɛr, n bʊɔrɔ naa ɩka yɩ bɔ̃ɔ ka a tu naa a Yesu 'yɔ̃ɔ ka ba mʊɔl yelbier vɛ̃ kʊfʊ kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","A tu naa a wʊ 'yɔ̃ɔ ɩka nɩrɛ jaa na sɔɔ de, Nãaŋmɩn na faa wʊn yin a ala a jaa a Mosesɩ Nɛɛ na kʊ̃ naa tʊ̃ɔ faa wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yɩ bɔ̃ɔnɔ̃ sʊ̃, ka a lɛ a Nãaŋmɩn 'yɛ'yɛrbɛ na dɔ̃ɔ 'yɛr taa wa a yɩ sɛ̃ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Nyɛ a yɩn na kpɛrɛ, yɩ bʊ̃bʊr na yɩ wɛ, bojũu ɩn maal yele kɔ̃ɔ a yɩ sɔ̃ɔ yɩn ba be na sɔɔ de ɛ, ala ɩ nɩrɛ ãsʊɔ gba 'yɛr kʊ yɩ.’ ” ");
INSERT INTO biv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Lɛ a Pɔɔl nɩ a Banabasɩ na wa yire a ba lɔ̃ɔfʊ jie, a nɩbɛ lɛ sʊɔr ba naa ɩka ba lɛ wa a Pɛ̃nfʊ Bɩbir Daar wa 'yɛr a 'yɛr nyãna go. ");
INSERT INTO biv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Lɛ a lɔ̃ɔfʊ dẽme na wa yaar, a Juu nɩbɛ yɔɔ jie nɩ a bala na lɩɛb a Juu nɩbɛ turo naa Pɔɔl nɩ a Banabasɩ na ba bʊrɔ nɩ ba kpãkpãana ba 'yɛrɛ ka ba mʊ̃ɔ nɩbir nɩ a Nãaŋmɩn wãɛfʊ nyã pɔ. ");
INSERT INTO biv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","A Pɛ̃nfʊ Bɩbir na lɛ wa ta, a tẽdẽme yɔɔ jie tɩ lɔ̃ɔn taa na wõ a sɩ Soro 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Lɛ a Juu nɩbɛ na nyɛ a nɩyɔɔ ba nyãna, nyuur kpɛ ba naa ka ba tʊrɔ chɩrɛ nɩ lɛ a Pɔɔl na 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ka a Pɔɔl nɩ a Banabasɩ ba jo ba dãbãɛ ɛ, tɩ 'yɛr kʊ ba, “Sɩn 'lɔ, sɩn den nie 'yɛr a Nãaŋmɩn 'yɛr kʊ yɩ. Tɩchɛ yɩn ben tɔr bar na yaa kaa a yɩ mãɛ ɩka yɩ sɛɛn naa a nyɛvʊr na ba tara baarfʊ ɛ, pʊ̃pãanyã 'lɔ sɩn lɩɛb chen a bala na ba ɩ a Juu nɩbɛ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nɩtɔ̃ lɛ a sɩ Soro kpãkpãan sɩ ɩka sɩ ɩ, ‘Ɩn maal fʊ naa ka fʊ ɩ chãa kʊ a bala na ba ɩ a Juu nɩbɛ ɛ, ka fʊn chiin a faafʊ 'yɛr tɩ tãn a tẽe baaraa.’ ” ");
INSERT INTO biv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","A lɛ a bala na ba ɩ a Juu nɩbɛ ɛ, na wõ a 'yɛr ba pʊɔ pɛl naa ka ba de 'yɔ̃ɔfʊ kʊ a sɩ Soro 'yɛr, ka a bala jaa a Nãaŋmɩn na ir ɩka ba nyɛ a nyɛvʊr na ba tara baarfʊ ɛ, sɔɔ de. ");
INSERT INTO biv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ka a sɩ Soro 'yɛr yaar a paal 'lɔ wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tɩchɛ ka a Juu nɩbɛ dam a pɔbɔ bala na turo a Juu nɩbɛ puorfʊ tɩ ba ɩ a Juu nɩbɛ ɛ, nɩ a tẽe nɩdierbe 'yɔ̃ɔ ka ba dii a Pɔɔl nɩ a Banabasɩ bar a paal 'lɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ka ba pãpã a ba gbɛɛ tã-uul 'yɔ̃ɔ ba ka a wiil ɩka Nãaŋmɩn na ge ba naa tɩ na ba chen a Ikoniyum. ");
INSERT INTO biv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ka a nʊ̃ɔ kpɛ a poturbo bala ka ba sɛɛn a Nãaŋmɩn Sɩɛ. ");
INSERT INTO biv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Be a Ikoniyum lɛ a Pɔɔl nɩ a Banabasɩ ma chen a Juu nɩbɛ lɔ̃ɔfʊ jie, be lɛ ba man a 'yɛr jaa nɛ nɛ nɛ ka a nɩyɔɔ bamɩne na ɩ a Juu nɩbɛ nɩ a bala na ba ɩ a Juu nɩbɛ ɛ, sɔɔ de a 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tɩchɛ ka a Juu nɩbɛ bala na ba sɔɔ de ɛ, dam a bala na ba ɩ a Juu nɩbɛ ɛ, sɔ̃ɔ a ba tɩɛr ka baa bara a yɛɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔɔl nɩ a Banabasɩ jɛ̃n a be na ba kor bãlãa, na ba 'yɛrɛ a sɩ Soro 'yɛr ba joro dãbãɛ ɛ, ka a sɩ Soro mãɛ wiil ɩka a wʊ wãɛfʊ 'yɛr ɩn yelmãɛ na wʊ sʊ̃ʊ ba a ba tʊ̃ɔ tʊ̃ yelwiilsɩ nɩ nɛ'maa tʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ka a tẽdẽme ŋma jiir ayi, a bamɩne pʊɔ a Juu nɩbɛ, ka a bamɩne mɩ pʊɔ a nɩtʊ̃nsɩ. ");
INSERT INTO biv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nɛchɩrɛ lon a Juu nɩbɛ nɩ a bala na ba ɩ a Juu nɩbɛ ɛ nɩ a ba nɩbɛrɛ chara pɔ, ka ban maal Pɔɔl nɩ a Banabasɩ dɛɛr lɔb ba nɩ kʊsɩbɛ. ");
INSERT INTO biv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Tɩchɛ a ba bɔ̃ɔn na ba jo chen a tẽn anyãna na be a Likoniya paal pɔ, Lɩstɩra nɩ a Debi nɩ a tẽn ala na jilʊ̃ a be. ");
INSERT INTO biv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Be lɛ ba chɛnɛ mʊ̃ɔ nɩbir na ba mʊɔlɔ a 'yɛr nʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","A be a Lɩstɩra, dagbɛrɛ kɔ̃ɔ ben be ban lɔ̃ɔ dɔɔn ka waa chen kaa jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wʊ chɛlɛ naa lɛ a Pɔɔl na 'yɛrɛ ka a Pɔɔl kaa wʊ jaa tãɩɩ nyɛ na wʊ bɔ̃ɔn wʊn tara sɔɔfʊ na sa. ");
INSERT INTO biv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","A wʊ bʊɔl a daba 'yɛr, “Ir ara naa fʊ gbɛɛ.” Ka a daba vaa ir na wʊ piel chiine. ");
INSERT INTO biv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lɛ a nɩbɛ na wa nyɛ a lɛ a Pɔɔl na ɩ, ka ba ŋme chɛlma nɩ a Likoniya kɔkɔr pɔ, “A ŋmɩmɛ lɩɛb nɩbɛ suu wa a sɩ sɛ̃!” ");
INSERT INTO biv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ba bʊɔlɔ naa a Banabasɩ “Jeyusɩ,” na ba bʊɔlɔ a Pɔɔl mɩ “Hɛmɩsɩ,” bojũu 'lɔ lɛ dɔ̃ɔ ɩ a 'yɛ'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ka a Jeyusɩ nyã puorfʊ yir na dɔ̃ɔ ara a tẽe kõkoor bɔɔrloro waan nɩ nadai nɩ a vapuulsɩ bojũu 'lɔ nɩ a nɩyɔɔ bala bʊɔrɔ naa ɩka ba lo bɔɔr kʊ ba. ");
INSERT INTO biv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tɩchɛ lɛ a nɩtʊ̃nsɩ, Banabasɩ nɩ a Pɔɔl na wa wõ a lɛ, ba tɔɔn a ba fuusɩ chɩɛr tɩ jo kpɛ be a nɩyɔɔ bala pɔ tɩ tãna, ");
INSERT INTO biv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nɩbɛ, bãa lɛ yɩ maala a lɛ? Sɩn mɩ ɩn nɩbɛ, nɩsaalba a yɩ kaar. Sɩn waan naa a 'yɛr nʊ̃ɔ nyã wa kʊ yɩ, na sɩ 'yɛrɛ yɩ ɩka, yɩ lɩɛb yi a yelpɔrsɩ anyãna pɔ, tɩ turo a Nãaŋmɩn vʊr. 'Lɔ lɛ maal a saaju, nɩ a tẽe, nɩ a man kpɛ̃ɛ, nɩ bon jaa na be be. ");
INSERT INTO biv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","A kõr jaa wʊ dɔ̃ɔ bar ka nɩrɛ jaa turo a wʊ sɔr. ");
INSERT INTO biv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tɩchɛ wʊ ma wiil a lɛ wʊn ɩ maal vɩla sʊɔ, na wʊ ma wiil a wʊ maal vɩla vɛ̃ ka a saa yi saaju waara, ka a bʊ̃bʊɔrsɩ sɔ̃ɔ mɩ be be. Wʊ ma kʊ yɩn a bʊ̃diir yɔɔ ka yɩ pʊɔ pɛl.” ");
INSERT INTO biv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","A 'yɛr nyãna gba ban 'yɛr, tɩchɛ a chɛnɛ na ɩ tuo ka ban ŋmaa a nɩbɛ sɔr ka ban bar a bɔɔr lofʊ. ");
INSERT INTO biv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ka a Juu nɩbɛ bamɩne na pãa yi a Antiok nɩ a Ikoniyum wa tɔ̃n a nɩyɔɔ bala 'yɔ̃ɔ ka ba lɔb a Pɔɔl nɩ kʊsɩbɛ vu yin bar a tẽe kõkoor tɩɛr man tãa wʊ kpi naa. ");
INSERT INTO biv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tɩchɛ ka a Nãaŋmɩn puorbo tɩ ŋmaa jilʊ̃ wʊ ara nɩ ka wʊ ir kpɛ a tẽe pɔ. A wɛr na wa chaar ka 'lɔ naa Banabasɩ chen a Debi. ");
INSERT INTO biv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Be lɛ ba tɩ mʊɔl a 'yɛr nʊ̃ɔ a tẽe 'lɔ pɔ, ka a nɩyɔɔ jaa sɔɔ turo a Yesu. A ba pãa lɩɛb chen a Lɩstɩra, Ikoniyum nɩ a Antiok, ");
INSERT INTO biv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","tɩ mʊlɔ a pupuorbiir 'yɔ̃ɔn ba ãkpãɛn ka ba ara nɩ yelmãɛ a sɔɔfʊ pɔ, na ba 'yɛrɛ, “Dɔɔyɛ yɔɔ pɔ lɛ sɩn tu tɩ kpɛ a Nãaŋmɩn nãalʊ̃ʊ pɔ.” ");
INSERT INTO biv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pɔɔl nɩ a Banabasɩ ir nɩdierbe kʊ ba a ba kaara a puorfʊ dẽme ãsʊɔ jaa. Ba gal kɔ̃ na ba sʊɔr Nãaŋmɩn tɩ de ba 'yɔ̃ɔ a sɩ Soro ban sɔɔ nũu pɔ. ");
INSERT INTO biv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ba kpɛ̃n tala a Pisidiya, ba wa ta naa Pamfiliya, ");
INSERT INTO biv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ban wa mʊɔl a 'yɛr a Perga, ba suun chen be a Ataliya. ");
INSERT INTO biv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Be a Ataliya lɛ ba yi tɩ kpɛ a gboro chen a Antiok. Be lɛ ba dɔ̃ɔ de ba 'yɔ̃ɔ a Nãaŋmɩn nũu pɔ ka wʊ sʊ̃ʊ ba, a ba tʊ̃ɔ a tʊ̃mɔ̃ a be tʊ̃ baar. ");
INSERT INTO biv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ban tɩ tara jaa lɛ ba bʊɔl a pupuorbiir lɔ̃ɔ taa na ba man a lɛ jaa a Nãaŋmɩn na de ba tʊ̃n nɩ a lɛ mɩ wʊn yuo sɔr kʊ a bala na ba ɩ a Juu nɩbɛ ɛ, ka ba tʊ̃ɔ sɔɔ de. ");
INSERT INTO biv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ba jɛ̃n a be kor bãlãa nɩ a poturbo. ");
INSERT INTO biv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nɩbɛ bamɩne yin be a Judiya suun wa a Antiok wa wile a yɛɛr 'yɛrɛ, “Yɩn baa sɔɔ ka ba ŋmaa yɩ a yʊɔr nɩtãa lɛ a Mosesɩ na bin ɛ, yɩ kʊ̃ nyɛ faafʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","A anyãna vɛ̃ naa ka a Pɔɔl nɩ a Banabasɩ nɩ a nɩbɛ mĩi 'yɔ̃ɔ taa ka a ɩ nɛchɩrɛ. Be lɛ a ba ir Pɔɔl nɩ a Banabasɩ nɩ a pupuorbiir bamɩne 'yɔ̃ɔ ɩka ba chen a Jerusalɛm tɩ nyɛ a nɩtʊ̃nsɩ nɩ a nɩbɛrɛ nɩ a 'yɛr nyãna. ");
INSERT INTO biv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","A pupuorbiir na wa bar ba a sɔr, ba chen tɩ yi a Fonisiya nɩ a Samariya na ba man a lɛ a bala na ba ɩ a Juu nɩbɛ ɛ, na lɩɛb puoro a Nãaŋmɩn. Ka a yɛɛr ba jaa pʊɔ pɛl nɩ a 'yɛr nyã. ");
INSERT INTO biv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ban wa ta Jerusalɛm, a pupuorbiir nɩ a nɩtʊ̃nsɩ nɩ a nɩbɛrɛ de ban nuur ayi, ka ba man a lɛ jaa a Nãaŋmɩn na de ba tʊ̃n. ");
INSERT INTO biv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ka a pupuorbiir bamɩne na chɛnɛ tara a Farasee wiilfʊ ir ara tɩ 'yɛr, “A nɩyor banyãna, a sɛɛ naa ka ban ŋma a ba yɔɩ na ba tu a lɛ a Mosesɩ na bin.” ");
INSERT INTO biv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","A nɩtʊ̃nsɩ nɩ a nɩbɛrɛ lɔ̃ɔn taa na ban guor a 'yɛr nyãna. ");
INSERT INTO biv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","A lɛ ban mana taa tɩ ta sɔ̃ɔ, Pita ir 'yɛr kʊ ba, “Yɛɛr, yɩ bɔ̃ɔ naa ɩka sɔ̃ɔ kɔ̃ɔ Nãaŋmɩn ir man a yɩ pɔ, ka a bala na ba sɩ a Juu nɩbɛ ɛ, mɩ na wõ a faafʊ 'yɛr nʊ̃ɔ 'yɛr yi a n nɛɛ pɔ, na ba sɔɔ de. ");
INSERT INTO biv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nãaŋmɩn na bɔ̃ɔ nɩrɛ jaa nyãa lɛ wiil ɩka wʊ sɔɔn de ba na wʊ kʊ ba a wʊ Sɩɛ nɩtãa lɛ wʊn kʊ sɩ. ");
INSERT INTO biv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Waa maal a sɩn nɩ a bala ka sɩ tɛɛ taa ɛ, wʊ pɛɛn a ba nyãa ban sɔɔ jũu. ");
INSERT INTO biv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","A lɛ jũu, bãa 'yɔ̃ɔ lɛ yɩ mʊɔrɔ ɩka yɩ bɛɛr Nãaŋmɩn kaa, na yɩ tuo a poturbo tuor a sɩ sãakpãmɩne na ba dɔ̃ɔ tʊ̃ɔ tuo ɛ? ");
INSERT INTO biv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kai, sɩn sɔɔ naa ɩka a tu naa a sɩ Soro Yesu wãɛfʊ jũu lɛ sɩ nyɛ faafʊ nɩtãa a bala kaar.” ");
INSERT INTO biv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ka a nɩyɔɔ bala na duo ɩ jaa gbulo, tɩ chɛlɛ a lɛ a Pɔɔl nɩ a Banabasɩ na mana a yelfɛrsɩ nɩ a nɛ'maa tʊ̃mɔ̃ a Nãaŋmɩn na de ba tʊ̃n a bala na ba ɩ a Juu nɩbɛ bala pɔ. ");
INSERT INTO biv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ban wa 'yɛr baar ka a Jemesɩ mɩ 'yɛr, “Yɛɛr, yɩ chɛlɛ ka. ");
INSERT INTO biv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon man kʊ sɩ a lɛ a Nãaŋmɩn na dɔ̃ɔ tɩɛrtɔ a bala na ba ɩ a Juu nɩbɛ ɛ ɩka wʊn ir nɩbɛ a ba pɔ, kʊ a wʊ mãɛ. ");
INSERT INTO biv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ka a lɛ na dɔ̃ɔ sɛb a Nãaŋmɩn gãn pɔ nɩ a 'yɛr nyã ɩ yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘A anyã puor, ɩn lɩɛb tɩ mɛ a Nãa David yir 'lɔ na lo. Ɩn mɛn a 'lɔ na ŋmɛr, naa lɛ maal wʊ. ");
INSERT INTO biv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ka a nɩbɛ bala na chɛ pãa na yɔ bɔ a Soro nɩ a bala na ba ɩ a Juu nɩbɛ ɛ na bʊɔlɔ a n yuor, lɛ lɛ a sɩ Soro 'yɛr na maal a yele anyãna,’ ");
INSERT INTO biv_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ka ba bɔ̃ɔn a kõr jaa jaa. ");
INSERT INTO biv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Maa 'yɛr nɩ nyã ɩka sɩ ta vɛ̃ ka a ɩ tuo kʊ a nɩyor banyãna na lɩɛrɛ waara a Nãaŋmɩn sɛ̃ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tɩchɛ yɩ ɩ a sɩ sɛb kʊ ba ɩka yaa, ba taa dire tɩɩ bon ɛ, na ba taa sɛ̃nɛ ɛ, dʊ̃ɔ na var kpi ba taa ɔɔrɔ ɛ, na ba taa ɔɔrɔ jãɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bojũu, lɛ lɛ a Mosesɩ bin a nɛɛ ka a Juu nɩbɛ ma mʊɔlɔ a 'yɛr nyãna a tẽn a jaa ka ba mɩ ma kar naa a ba lɔ̃ɔfʊ jiir a Pɛ̃nfʊ Bɩbir Daar jaa.” ");
INSERT INTO biv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ka a nɩtʊ̃nsɩ nɩ a nɩbɛrɛ lɔ̃ɔn a pupuorbiir ba jaa pãa kaa ir nɩbɛ a ba pɔ, ka ban 'matãan a Pɔɔl nɩ a Banabasɩ tʊ̃ ka ba chen a Antiok. Judas ban bʊɔlɔ Basabasɩ nɩ Silasɩ lɛ ba ir, a nɩbɛ ayi banyãna mɩ dɔ̃ɔ ɩ nɩbɛrɛ pʊɔ a yɛɛr. ");
INSERT INTO biv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bala lɛ ba tʊ̃n a gãn nyãna, “A sɩn nɩtʊ̃nsɩ nɩ a nɩbɛrɛ na ɩ a yɩ yɛɛr puor naa a yɩn na ba ɩ a Juu nɩbɛ ɛ, na ɩ a sɩ yɛɛr be a Antiok nɩ a Siriya nɩ a Sɩlɩsɩya paal pɔ. ");
INSERT INTO biv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Sɩ wõn a bamɩne na yi a sɩ sɛ̃ sɩn ba kʊ ba sɔr ɛ, tɩ vuro yɩ dɔ̃ɔnɔ̃ nɩ yɩ 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ala lɛ so ka sɩ jaa sɔɔ ir nɩbɛ bamɩne tʊ̃ ka ban wa a yɩ sɛ̃, 'matãan a sɩ barmɩne Pɔɔl nɩ a Banabasɩ, ");
INSERT INTO biv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","a nɩbɛ banyãna lɛ sɔɔ kũu a sɩ Soro Yesu Kɩrɩsɩto yuor jũu. ");
INSERT INTO biv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","A lɛ jũu lɛ sɩ tʊ̃n a Judas nɩ a Silasɩ ka ban tɩ man a ba nɛɛ a lɛ sɩn sɛb. ");
INSERT INTO biv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","A vɩɛlɛ na kʊ a Nãaŋmɩn Sɩɛ nɩ a sɩn mɩ sɛ̃, ka sɩ kʊ̃ lɛ tuo yɩ tuor dɔɔl a anyãna ju ɛ. ");
INSERT INTO biv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Yɩ taa dire tɩɩ bon ɛ, yɩ taa ɔɔrɔ jãɩ ɛ, na yɩ taa ɔɔrɔ dʊ̃ɔ na var kpi nʊ̃n ɛ, bɩɩ sɛ̃nɛ ɛ. Yɩ mɔ̃ na yɩ nyɔɔ yɩ mãɛ a yelsɩ anyãna pɔ. Yɩ jɛ̃ vɩla.” ");
INSERT INTO biv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ban wa bar a Pɔɔl, nɩ a Banabasɩ, nɩ a Judas nɩ a Silasɩ sɔr, ka ba suu chen be a Antiok, be lɛ ba tɩ lɔ̃ɔ taa a bala na puoro ba jaa na ba de a gãn kʊ ba. ");
INSERT INTO biv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","A nɩbɛ na wa kar a gãn a 'yɔ̃ɔ ban ãkpãɛn ka ba pʊɔ pɛl. ");
INSERT INTO biv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas nɩ a Silasɩ mɩ na ɩ a Nãaŋmɩn 'yɛ'yɛrbɛ 'yɛr 'yɛr yɔɔ 'yɔ̃ɔn a yɛɛr ãkpãɛn. ");
INSERT INTO biv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ban wa jɛ̃ a be kor bãlãa, ka a yɛɛr lɛ bar ba sɔr nɩ nyã'maar ka ba lɩɛb chen a bala na tʊ̃ ba sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Tɩchɛ ka a Pɔɔl nɩ a Banabasɩ jɛ̃ be a Antiok, be lɛ a bala nɩ a ba taaba bamɩne wile tɩ mʊɔlɔ a sɩ Soro 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","A mɩn lɛ wa kor bãlãa ka a Pɔɔl 'yɛr kʊ a Banabasɩ, “Vɛ̃ ka sɩ lɛ chen tɩ piir a yɛɛr kaa a tẽn ala pɔ sɩn mʊɔl a sɩ Soro 'yɛr na sɩ kaa ŋmɩnɛ lɛ ba irɛ.” ");
INSERT INTO biv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ka a Banabasɩ bʊɔrɔ ɩka wʊ de a Jɔɔn Maakɩ ka ba 'mataa chen. ");
INSERT INTO biv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Tɩchɛ ka a Pɔɔl ba tɩɛr ɩka a ba tara sɔr ɛ, bojũu wʊ dɔ̃ɔ bar ba be a Pamfiliya ba lɛ pɔɔ ba chen a tʊ̃mɔ̃ jie ɛ. ");
INSERT INTO biv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Be lɛ ba tãn tãn taa na ba ŋma dẽdẽme, ka a Banabasɩ de a Jɔɔn Maakɩ na wʊ kpɛ̃n a gboro chiin be a Sipurusɩ. ");
INSERT INTO biv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Tɩchɛ ka a Pɔɔl mɩ ir a Silasɩ ka a yɛɛr de ba 'yɔ̃ɔ a sɩ Soro nũu pɔ, ka wʊn sʊ̃ʊ ba. ");
INSERT INTO biv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Wʊ tun a Siriya nɩ a Sɩlɩsɩya 'yɔ̃ɔnɔ̃ a bala na puoro ãkpãɛn. ");
INSERT INTO biv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔɔl tɩ chen a Debi na wʊ tɩ po chen a Lɩstɩra, be lɛ wʊ tɩ nyɛ a pupuoro ãsʊɔ ban bʊɔlɔ Timoti ka a wʊ ma ɩ Juu nɩrɛ na wʊ puoro, tɩchɛ ka a wʊ sãa ba ɩ a Juu nɩrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ka a yɛɛr na be a Lɩstɩra nɩ a Ikoniyum pʊr a Timoti yovɩla. ");
INSERT INTO biv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","A Pɔɔl bʊɔrɔ ɩka wʊ tara wʊ 'mataa chiine na wʊ ŋmaa wʊ a yʊɔr, bojũu a Juu nɩbɛ na kpɩɛrɛ a be bɔ̃ɔn naa a Timoti sãa na ba ɩ a Juu nɩrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","A lɛ ban lʊɔrɔ a tẽn, lɛ mɩ lɛ ba mana kʊrɔ ba lɛ a nɩtʊ̃nsɩ nɩ a nɩdierbe na be a Jerusalɛm na 'yɛr bin ka nɩbɛ ba turo. ");
INSERT INTO biv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ba 'yɔ̃ɔn a pupuorbiir ãkpãɛn ka a nɩbɛ mɩ waara pʊɔrɔ bɩbir jaa. ");
INSERT INTO biv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔɔl nɩ a wʊ taaba tun a Fɩrgɩya nɩ a Galatiya paal pɔ, ka a Nãaŋmɩn Sɩɛ ŋmaa ba sɔr a ba taa mʊɔlɔ a 'yɛr a be a Asɩya ɛ. ");
INSERT INTO biv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ban wa gbʊr a Misiya wɛr pɔ, ba ta mʊɔrɔ naa ɩka ba chen a Bitiniya tɩchɛ a Nãaŋmɩn Sɩɛ ba kʊ ba sɔr ɛ. ");
INSERT INTO biv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","A ba vɩɛ a Misiya bar tɩ suu chen be a Toroyas. ");
INSERT INTO biv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A tãsɔɔ lɛ a Pɔɔl nyɛ jãna pɔ, daba na yi Masedonɩya ara sʊɔrɔ wʊ 'yɛrɛ, “Gɔ̃ɔ wa ka a Masedonɩya wa sʊ̃ʊ sɩ.” ");
INSERT INTO biv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔɔl na nyɛ a nyɛfʊ nyãna, sɩ ir chɔɔr a lɛ nɛ na sɩ chen a Masedonɩya, na sɩ bɔ̃ɔn ɩka Nãaŋmɩn lɛ bʊɔl sɩ a sɩ tɩ mʊɔl a wʊ 'yɛr nʊ̃ɔ kʊ ba. ");
INSERT INTO biv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","A Toroyas sɩn yi tɔ̃ɔ kpɛ a gboro a dẽdẽe a lɛ nɛ chen a Samotɩrasɩ, ka a wɛr na wa chaar, sɩ tãn a Neapolis. ");
INSERT INTO biv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Be lɛ sɩ yin gbɛɛ chiin a Filipai, Worom dẽme lɛ dɔ̃ɔ kpɩɛrɛ a be na wʊ mɩ ɩ a Masedonɩya jikpɛ̃ɛ, be lɛ sɩ jãnɛ maal ber aŋmɩnɛ jaa. ");
INSERT INTO biv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","A Pɛ̃nfʊ Bɩbir Daar, sɩ yin a tẽe pɔ suu a põn pɔ, be lɛ sɩ tɩɛr ɩka sɩn nyɛn jie ban ma sʊɔrɔ Nãaŋmɩn. Sɩ jãnɛ naa be na sɩ piel 'yɛrɛ 'yɛr kʊrɔ pɔbɔ na lɔ̃ɔ a be. ");
INSERT INTO biv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","A pɔbɔ banyãna na chɛlɛ ãsʊɔ yuor din Lidiya na yara fɔjɩɩr, na wʊ yi a Tayatira tẽe pɔ, wʊ mɩ puoro naa Nãaŋmɩn. A sɩ Soro yuon a wʊ tɩɛr ka wʊ sɔɔ de a lɛ a Pɔɔl na 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","'Lɔ nɩ a wʊ yir dẽme ba jaa na wa so a Nãaŋmɩn kʊ̃ɔ, wʊ bʊɔl sɩ naa a sɩ wa a wʊ yir a wʊ wa 'yɛr, “Ala ɩ yɩ sɔɔ naa ɩka n sɔɔn de a sɩ Soro, sɩrɛ jaa yɩ wa jɛ̃ a n yir.” Lɛ lɛ wʊ mʊlɔ sɩ. ");
INSERT INTO biv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Daar kɔ̃ɔ sɩn lɛ chiine a jie 'lɔ̃nɔ̃ a Nãaŋmɩn sʊɔrfʊ jie, sɩ tuor gbãgbapɔɔbile na tara a sɩdɛɛr na wʊ ma 'yɛrɛ yele na ɩ daar kɔ̃ɔ. A lɛ wʊn 'yɛrɛ na wʊ nyɛrɛ libiyɔɔ kʊrɔ a bala na so wʊ. ");
INSERT INTO biv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ka a pɔɔbile nyãna turo a Pɔɔl na wʊ turo sɩ tãna 'yɛrɛ, “A nɩbɛ banyãna ɩ naa a Nãaŋmɩn nyã na be saaju tʊ̃tʊ̃nbɔ na ba wile yɩ a faafʊ sɔr.” ");
INSERT INTO biv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Lɛ lɛ a pɔɔbile mar bɩbir jaa ka a Pɔɔl wa vʊʊr faa tɩ lɩɛb 'yɛr kʊ a sɩɛ 'lɔ na be a pɔɔbile pɔ ɩka, “Yesu Kɩrɩsɩto yuor pɔ, n 'yɛr kʊ fʊ ɩka fʊ wa yi a pɔɔbile pɔ.” Ajienaa ka a sɩɛ yi tɩchɛ wʊ bar. ");
INSERT INTO biv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","A pɔɔbile sorbo na wa bɔ̃ɔn ɩka baa lɛ nyɛrɛ tɔ̃nɔ̃ a pɔɔbile sɛ̃ ɛ, ba nyɔɔn a Pɔɔl nɩ a Silasɩ tɔɔ chiin be a daa pɔ a nɩbɛrɛ niem. ");
INSERT INTO biv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ba chiin ban tɩ kʊ a 'yɛr tɔɔrbɔ tɩ 'yɛr, “A nɩbɛ banyãna ɩ naa a Juu nɩbɛ na ba wa kpɛ dɔ̃ɔnɔ̃ sɩ a tẽe. ");
INSERT INTO biv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ba tara na yelsɩ kɔ̃ɔ an ba tara sɔr kʊ a sɩn Worom nɩbɛ a sɩn sɔɔ bɩɩ maal ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ka a nɩyɔɔ bala ir pʊɔ na baa bara a Pɔɔl nɩ a Silasɩ ɛ, ka a 'yɛr tɔɔrbɔ vɛ̃ ka ba yaar a Pɔɔl nɩ a Silasɩ fuusɩ bar tɩ 'yɔ̃ɔ a ba fɔb ba. ");
INSERT INTO biv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","A lɛ ban wa fɔb ba sɛɛ, ba nyɔɔr ban 'yɔ̃ɔ a pɔɔfʊ die pɔ, tɩ 'yɛr kʊ a 'lɔ na guro a pɔɔfʊ die, a wʊ bɔ̃ɔ kaara ba. ");
INSERT INTO biv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wʊn wõ a nɩtɔ̃, wʊ tɩɛ ban 'yɔ̃ɔ a die 'lɔ na be a sãlsɔɔ tɩ lũ a ba gbɛɛ mar daa. ");
INSERT INTO biv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","A tãsɔɔ bãɩn lɛ a Pɔɔl nɩ a Silasɩ sʊɔrɔ Nãaŋmɩn, na ba yiele nɩ a Nãaŋmɩn yiel, ka a ba taaba ban lɔ̃ɔ pɔɔn ba chɛlɛ. ");
INSERT INTO biv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ajienaa ka a tẽe dam kpɛ̃ɔ jaa, ka a pɔɔfʊ yir par kparaa mɩ dam. Ka a pɔɔfʊ der dɔ̃dɔɩ yuo yuor a jaa, ka nɩrɛ jaa bɔ̃jɔrma ban lũn wʊ for for. ");
INSERT INTO biv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ka a 'lɔ na guro a pɔɔfʊ die jɛɔ ir na wʊ nyɛ a lɛ a pɔɔfʊ der dɔ̃dɔɩ na yuor, ka wʊ vʊ̃ɔ sɔɔ ɩka wʊ kʊ̃n wʊ mãɛ, bojũu wʊ man tãa a pɔɔfʊ dẽme yin jo. ");
INSERT INTO biv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Tɩchɛ ka a Pɔɔl tãn, “Ta ge fʊ mãɛ ɛ, sɩ jaa ben ka.” ");
INSERT INTO biv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","A wʊ bʊɔl a ba waan fãtɩn wa kʊ wʊ a wʊ pɔɔ kpɛ̃n be a die pɔ, na wʊ tɩ lo gbur dumo mɩrɛ a Pɔɔl nɩ a Silasɩ niem. ");
INSERT INTO biv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tɩ pãa ir tara ba yin tɩ sʊʊr, “Nɩbɛrɛ, ŋmɩnɛ lɛ ɩn ɩrɛ wa nyɛ faafʊ?” ");
INSERT INTO biv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","A ba 'yɛr kʊ wʊ, “Sɔɔ de a sɩ Soro Yesu, fʊ̃ʊ nɩ a fʊ yir dẽme na nyɛn faafʊ.” ");
INSERT INTO biv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Be lɛ ba pãa 'yɛr a sɩ Soro 'yɛr kʊ wʊ nɩ a bala jaa na be a wʊ yir. ");
INSERT INTO biv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","A sɔ̃ɔ 'lɔ̃nɔ̃ lɛ a pɔɔfʊ die guguro de ba yin a tãsɔɔ 'lɔ̃nɔ̃ na wʊ tɩ pɛɛ a ba natɩɛ tɩchɛ a ba mɩ tɔ̃ɔ so a 'lɔ nɩ a wʊ yir dẽme ba jaa a Nãaŋmɩn kʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ka a pɔɔfʊ die guguro tara ba kpɛ̃n a wʊ yir tɩ maal bʊ̃diir kʊ ba, ka nʊ̃ɔ kpɛ a wʊ yir dẽme, bojũu 'lɔ nɩ a wʊ yir dẽme ba jaa sɔɔn de a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wɛr na wa chaar a 'yɛr tɔɔrbɔ ir a ba tʊ̃tʊ̃nbɔ tʊ̃ na ba 'yɛr kʊ ba, “Yɩ chen tɩ 'yɛr kʊ a 'lɔ na guro a pɔɔfʊ die ɩka, a wʊ yuo a dɔɔr bala bar.” ");
INSERT INTO biv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ka a pɔɔfʊ die guguro 'yɛr kʊ a Pɔɔl, “A 'yɛr tɔɔrbɔ tʊ̃n ɩka n yuo a fʊ̃ʊ nɩ a Silasɩ bar. A lɛ pʊ̃pãanyã yɩn tʊ̃ɔ chiine, yɩ chiine nɩ nyã'maar.” ");
INSERT INTO biv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Tɩchɛ ka a Pɔɔl 'yɛr kʊ a bala ban tʊ̃, “Chãa pɔ jaa lɛ ba vɛ̃ a ba fɔb sɩ, baa tɔɔr a sɩ 'yɛr ɛ, sɩ gba ɩ naa a Worom dẽme tɩ ba 'yɔ̃ɔ sɩ a pɔɔfʊ die pɔ. Pʊ̃pãanyã a ba lɛ bʊɔrɔ ɩka ba sɔɔl yuo sɩ bar? Bala mãɛ ba wa yuo sɩ bar.” ");
INSERT INTO biv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","A tʊ̃tʊ̃nbɔ na tɩ man a lɛ kʊ a 'yɛr tɔɔrbɔ, ban wa wõ ɩka a Pɔɔl nɩ a Silasɩ ɩ naa Worom dẽme, dãbãɛ kpɛ ba naa. ");
INSERT INTO biv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ka a bala mãɛ pãa chen tɩ 'maal ba yin a pɔɔfʊ die pɔ, tɩ sʊɔr ba ɩka ba yi a tẽe 'lɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɔɔl nɩ a Silasɩ na wa yi a pɔɔfʊ die pɔ, ba chen a Lidiya yir, be lɛ ba tɩ tuor a yɛɛr ka ba 'yɔ̃ɔ ba ãkpãɛn tɩ pãa yi a be chen. ");
INSERT INTO biv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ba tun a Amfipolis nɩ Apoloniya na ba wa a Tɛsalonika, be lɛ a Juu nɩbɛ lɔ̃ɔfʊ yir be. ");
INSERT INTO biv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Lɛ a Pɔɔl na ma irɛ lɛ wʊ chen be a lɔ̃ɔfʊ yir, Pɛ̃nfʊsɩ gbɛɛ ata jaa lɛ wʊ kpɛ a be ka a 'lɔ nɩ a bala vɩɛrɛ a Nãaŋmɩn gãma. ");
INSERT INTO biv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Wʊ mana na wile a lɛ an sɛɛ a Nɩ-iraa na di dɔɔyɛ tɩ na wʊ ir a kũu pɔ ɩ vʊr, “A Yesu nyãna ɩn ben 'yɛrɛ a wʊ 'yɛr, lɛ ɩ a Nɩ-iraa.” ");
INSERT INTO biv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ka a Juu nɩbɛ bamɩne sɔɔ a lɛ na ba pʊɔ a Pɔɔl nɩ a Silasɩ, 'matãan a bala na ba ɩ a Juu nɩbɛ na dɔ̃ɔ puoro a Nãaŋmɩn lɔ̃ɔn pɔɔ 'yɔ̃ɔnsɩ. ");
INSERT INTO biv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tɩchɛ ka a nyuur kpɛ a Juu nɩbɛ, ka ba bɔ a ba taaba nɩbomo be a daa pɔ lɔ̃ɔ taa, na ba piel gɔ̃mɔ̃ be a tẽe pɔ. Ba tɩ sɛɛn a Jason yir bʊɔrɔ a Pɔɔl nɩ a Silasɩ ɩka ba yin chiin ba a nɩyɔɔ bala niem. ");
INSERT INTO biv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Tɩchɛ ban ba wa tɩ nyɛ ba ɛ, ba nyɔɔn a Jason nɩ a yɛɛr bamɩne chiin a tẽe nɩbɛrɛ niem tɩ tãna 'yɛrɛ. “A dɔɔr banyãna lɛ dɔ̃ɔnɔ̃ a wɛr wʊ jaa, ba wa tãn ka pʊ̃pãanyã ");
INSERT INTO biv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ka a Jason tuor de ba 'yɔ̃ɔ a wʊ yir. Ba sɔ̃ɔnɔ̃ naa a Nãa Siisa chire na ba 'yɛrɛ ɩka nãa ãsʊɔ ben be ban bʊɔlɔ Yesu.” ");
INSERT INTO biv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","A lɛ a tẽe nɩbɛrɛ nɩ a nɩyɔɔ bala na wõ a 'yɛr nyãna, a dam ba naa. ");
INSERT INTO biv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","A ba pãa 'yɔ̃ɔ a Jason nɩ a yɛɛr bala a ba yab libie tɩ ba bar ba sɔr. ");
INSERT INTO biv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","A lɛ a wɛr na wa tɔ̃ɔ sɔb, ka a yɛɛr bar a Pɔɔl nɩ Silasɩ sɔr ka ba chen be a Beriya. Ban tɩ ta, ba chen be a Juu nɩbɛ lɔ̃ɔfʊ yir. ");
INSERT INTO biv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","A Juu nɩbɛ bala na be a Beriya ɩn chɛchɛlbɛ gar a bala na be a Tɛsalonika, bojũu ba den a 'yɛr nɩ chɩlfʊ na ba vɩɛrɛ a Nãaŋmɩn gãma kaara bɩbir jaa ɩka ba kaa lɛ a Pɔɔl na 'yɛrɛ ɩn yelmãɛ bɩɩ. ");
INSERT INTO biv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","A Juu nɩbɛ yɔɔ jie sɔɔn de a 'yɛr lɔ̃ɔn a bala na ba ɩ Juu nɩbɛ dɔɔr yɔɔ jie, nɩ a pɔɔ 'yɔ̃ɔnsɩ bamɩne yɔɔ jie. ");
INSERT INTO biv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","A Juu nɩbɛ na be a Tɛsalonika na wa bɔ̃ɔn ɩka a Pɔɔl ben a Beriya mʊɔlɔ a Nãaŋmɩn 'yɛr, ba chen a be tɩ chãgbala a nɩbɛ dɔ̃ɔnɔ̃ nɩ ba. ");
INSERT INTO biv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ka a yɛɛr mɩ tɔ̃ɔ 'yɔ̃ɔ a Pɔɔl a man sɔr a wʊ chen, tɩchɛ ka a Silasɩ nɩ a Timoti 'lɔ jɛ̃ be a Beriya. ");
INSERT INTO biv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","A nɩbɛ bala na bɩɛl a Pɔɔl ba tɩ tãn wʊn a Atensɩ, bala lɛ wʊ lɩɛb tʊ̃ ɩka a Silasɩ nɩ a Timoti a ba wa fɔɔ a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","A lɛ wʊn chɛnɛ chɛlɛ ba be a Atensɩ, suur wa tɩ kpɛ wʊ naa a lɛ wʊn nyɛ a tẽe na sɛɛn a tɩbɛ. ");
INSERT INTO biv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Lɛ lɛ 'lɔ nɩ a Juu nɩbɛ nɩ a Greek bala na puoro a Nãaŋmɩn ma mana taa be a ba lɔ̃ɔfʊ yir, nɩ a bala wʊn ma pɔɔ a daa pɔ bɩbir jaa nɩ nɩrɛ jaa wʊn tuor. ");
INSERT INTO biv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ka a bɔ̃bɔ̃ɔnbɔ bamɩne na yi a Epikuriya nɩ a Sɩtoyik gbul pɔ piel chɩrɛ nɩ a Pɔɔl. Ka a bamɩne sʊrɔ, “Bo lɛ a dabʊlɔbʊlɔ nyãna ara 'yɛrɛ?” Ka a bamɩne mɩ 'yɛrɛ, “Ŋmɩn sãansɩ kɔ̃ɔ 'yɛr lɛ wʊ 'yɛrɛ.” Ba 'yɛrɛ naa nɩtɔ̃ bojũu, Pɔɔl mʊɔlɔ naa a Yesu 'yɛr nʊ̃ɔ nɩ a kũu pɔ irfʊ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Be lɛ ba pãa bʊɔl wʊ chiin be a lɔ̃ɔfʊ jie a Areyopagusɩ na ba 'yɛr, “Fʊn tʊ̃ɔ wiil sɩ a fʊ wiil paalaa nyãna fʊn wile a sɩ bɔ̃ɔ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","'Yɛr sãan lɛ a nyã fʊn waan a sɩ wõnõ na sɩ bʊɔrɔ ɩka sɩ bɔ̃ɔ a par.” ");
INSERT INTO biv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atensɩ dẽme ba jaa lɔ̃ɔn a sãanba na kpɩɛrɛ a be, baa tara tʊ̃mɔ̃ lɛ pʊɔ a 'yɛr paalaa ban ma 'yɛrɛ na ba chɛlɛ nɩ yelpaalaa na ɩrɛ. ");
INSERT INTO biv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Lɛ lɛ a Pɔɔl pãa ir a nɩbɛ na lɔ̃ɔ a Areyopagusɩ na wʊ 'yɛr, “Atensɩ dɔɔr, n nyɛn bɔ̃ɔn yɩn nʊ̃ ŋmɩmɛ puorfʊ. ");
INSERT INTO biv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Bojũu ɩn yʊɔrɔ kaara a yɩ tɩbɛ jiir, n tɩ nyɛn a bɔɔr lofʊ jie ãsʊɔ yɩn sɛb 'yɔ̃ɔ, ŊMƖN 'LƆ SƖN BA BƆ̃Ɔ Ɛ. A Nãaŋmɩn 'lɔ gba yɩn mãɛ na puoro tɩ ba bɔ̃ɔ wʊ ɛ, 'lɔ lɛ n waan ɩka n wa mʊɔl kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“A Nãaŋmɩn 'lɔ na maal a wɛr nɩ a bomo a jaa na be a pɔ, 'lɔ lɛ ɩ a saaju nɩ a tẽe jaa Soro, na waa gãna a yie ala a nɩbɛ na mɛn a ba nuur kʊ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Waa dɩɛl nɩrɛ nũu tʊ̃mɔ̃ ala ɩ wʊ bʊɔrɔ na bon kɔ̃ɔ ɛ, bojũu 'lɔ mãɛ lɛ kʊ nɩrɛ nyɛvʊr, ka wʊ vʊrɔ nɩ bon jaa. ");
INSERT INTO biv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Dabʊ̃'yen pɔ lɛ wʊ tu na wʊ maal a nɩbʊrsɩ, ka ba kpɩɛrɛ a wɛr wʊ jaa. A wʊ man a sɔ̃ɔsɩ kʊ ba, nɩ a jiir ala ban na kpɩɛrɛ. ");
INSERT INTO biv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nãaŋmɩn maal naa nɩtɔ̃ ka nɩrɛ na tʊ̃ɔ yɔbɔ wʊ, amɩne sɛ̃ ban nyɛ wʊ naa, bojũu waa jãan a sɩ ãsʊɔ jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Bojũu, a wʊ 'yɔ̃ɔ lɛ sɩ chɛnɛ na sɩ be ka a tẽe pɔ,’ na sɩ yʊɔrɔ nɩtãa lɛ a yɩn mãɛ nɩbɛ bamɩne na dɔ̃ɔ 'yɛr, ‘A wʊ bibiir lɛ sɩ ɩ.’ ");
INSERT INTO biv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Sɩn ɩ a Nãaŋmɩn bibiir jũu, yɩ taa ɩ a sɩ tɩɛr ɩka a Nãaŋmɩn nyã kaara naa fɩka bon nɩrɛ na de wʊ yɛ̃ bɩɩ bɔ̃ɔfʊ mɛn, sɛlma, bɩɩ libipɩla, bɩɩ kʊsɩr kaar ɛ. ");
INSERT INTO biv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","A kõr jaa 'lɔ, Nãaŋmɩn lɩɛb puor 'yɔ̃ɔ a sɩ ba bɔ̃ɔfʊ, tɩchɛ pʊ̃pãanyã 'lɔ, wʊ kpãkpãana na nɩrɛ jaa jie jaa ɩka, ba lɩɛb ba tɩɛr. ");
INSERT INTO biv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bojũu wʊ ir bɩbir bin wʊn na de a daba 'lɔ wʊn ir, na wʊ tɔɔr a wɛr 'yɛr nɩ yeltorsɩ pɔ. Wʊ vɛ̃n ka a chaar kʊ nɩrɛ jaa wʊn sãɩ wʊ a kũu pɔ.” ");
INSERT INTO biv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ban wa wõ a kũu pɔ irfʊ 'yɛr, bamɩne lan wuol, tɩchɛ ka bamɩne mɩ 'yɛr, “Sɩn bʊɔrɔ naa ɩka sɩ lɛ wõ a 'yɛr nyã nɩdaar.” ");
INSERT INTO biv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","A lɛ, Pɔɔl bar ba naa a lɔ̃ɔfʊ jie. ");
INSERT INTO biv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tɩchɛ ka a nɩbɛ bãlãa turo a Pɔɔl na ba sɔɔ de a 'yɛr, a ba ãsʊɔ lɛ Diyonɩsɩs na ɩ a Areyopagusɩ lɔ̃ɔfʊ nɩrɛ, ka a pɔɔ ãsʊɔ mɩ na pʊɔ yuor di Damarisɩ nɩ bamɩne mɩ na pʊɔ. ");
INSERT INTO biv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","A anyã puor, Pɔɔl yin a Atensɩ na wʊ chen be a Korɩntɩ. ");
INSERT INTO biv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Be lɛ wʊ tuor a Juu nɩrɛ na di Akuila na wʊ ɩ Pontus bal nɩrɛ, 'lɔ nɩ a wʊ pɔɔ Pɩrɩsɩla na yi a Itali wa a ba kor ɛ, bojũu a Nãa Kɩlaudiyus 'yɛr naa ɩka a Juu nɩrɛ jaa wʊ yi a Worom. Ka a Pɔɔl chen ɩka wʊ piir ba kaa. ");
INSERT INTO biv_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Wʊ tɩ jɛ̃n a be a ba 'mataa tʊ̃nɔ̃ bojũu ba jaa bɔ̃ɔn a gãma tʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","A Pɛ̃nfʊ Bɩbir Daar jaa Pɔɔl ma chen a ba lɔ̃ɔfʊ yir ma tɩ 'yɛrɛ a 'yɛr bʊɔrɔ ɩka wʊ lɩɛb a Juu nɩbɛ nɩ a bala na ba ɩ a Juu nɩbɛ tɩɛr. ");
INSERT INTO biv_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Lɛ a Silasɩ nɩ a Timoti na wʊ yi a Masedonɩya wa a Korɩntɩ, Pɔɔl den a wʊ sɔ̃ɔ wʊ jaa na wʊ mʊɔlɔ mana kʊrɔ a Juu nɩbɛ ɩka a Yesu lɛ a Nɩ-iraa. ");
INSERT INTO biv_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Tɩchɛ ka Juu nɩbɛ 'yɛrɛ a Pɔɔl kpõkpoor 'yɛr, a wʊ pãpã a fɔbaa 'yɔ̃ɔ ba tɩ 'yɛr kʊ ba, “A yɩ jãɩ a lɩɛb dɔɔl a yɩ ju, a ba lɛ ɩ maa 'yɛr ɛ, an yi dɩna chiine, n chiine naa a bala na ba ɩ a Juu nɩbɛ jie.” ");
INSERT INTO biv_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pɔɔl yin be a lɔ̃ɔfʊ yir na wʊ gʊɔr a daba ãsʊɔ na di Titiyusɩ Jusɩtusɩ na ba ɩ a Juu nɩrɛ ɛ na puoro ka a wʊ yir gbʊr a lɔ̃ɔfʊ yir. ");
INSERT INTO biv_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ka a Kɩrɩsɩpusɩ na ɩ a lɔ̃ɔfʊ yir nɩdiere nɩ a wʊ yir dẽme ba jaa sɔɔ de a sɩ Soro 'yɛr nɩ a Korɩntɩ dẽme yɔɔ na wõ a lɛ wʊn 'yɛr, a ba sɔɔ a wʊ so ba jaa a Nãaŋmɩn kʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","A tãsɔɔ ãsʊɔ, a sɩ Soro 'yɛr 'yɛr kʊ a Pɔɔl jãna pɔ ɩka, “Taa joro dãbãɛ ɛ, mʊ̃ɔ nɩbir mʊɔlɔ a 'yɛr ta pɔɔ nɛɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Bojũu, ɩn pʊɔ fʊ naa, nɩrɛ jaa kʊ̃ nyɔɔ fʊ bɩɩ maal fʊ dɛɛr ɛ, bojũu n chɛnɛ na tara nɩyɔɔ a tẽe nyã pɔ.” ");
INSERT INTO biv_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Be lɛ a Pɔɔl jɛ̃ a be a Korɩntɩ yuon gbul nɩ bʊ̃ŋmaa na wʊ wile ba a Nãaŋmɩn 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","A sɔ̃ɔ 'lɔ̃nɔ̃ lɛ a Galio ɩ a Akaya nɩkpɛ̃ɛ, ka a Juu nɩbɛ guor taa na ba nyɔɔ a Pɔɔl chiin be a 'yɛr tɔɔrfʊ jie. ");
INSERT INTO biv_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Be lɛ ba tɩ 'yɛr, “A daba nyãna lɛ bʊɔrɔ ɩka wʊ lɩɛb a nɩbɛ tɩɛr ka ba puoro Nãaŋmɩn na ba tu a lɛ a sɩ nɛbinsɩ na 'yɛr ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ka a Pɔɔl haa nɛɛ ɩka wʊ 'yɛr 'yɛr, tɩchɛ ka a Galio 'yɛr kʊ a Juu nɩbɛ, “A yɩn, ala ta ɩ yeldɛɛr bɩɩ yelbier kɔ̃ɔ 'yɔ̃ɔ lɛ, ɩn taa 'maan ãgãn chɛlɛ. ");
INSERT INTO biv_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Tɩchɛ an ben wa lɔ̃ɔ taa nɩ a yɩ 'yɛr bie nɩ yoe 'matãan a yɩ nɛbinãa yɩn mãɛ yɩ maal, maa kʊ̃ tʊ̃ɔ a 'yɛr nyãna tɔɔr ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Lɛ lɛ wʊ vɛ̃ a ba dii ba bar be a 'yɛr tɔɔrfʊ jie. ");
INSERT INTO biv_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","A ba lɩɛb nyɔɔ a Sosetenesɩ na ɩ a lɔ̃ɔfʊ jie nɩkpɛ̃ɛ na ba ŋme be a 'yɛr tɔɔrfʊ yir dɔ̃dɔr nɛɛ, tɩchɛ a Galio baka ba be be ɛ. ");
INSERT INTO biv_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔɔl jɛ̃n be a Korɩntɩ tẽe kor bãlãa, tɩ pãa bar a yɛɛr na wʊ kpɛ a gboro chiine a Siriya ka a Pɩrɩsɩla nɩ a Akuila pɔɔ wʊ. Sɛrɛ tɩchɛ ka wʊ chen, wʊ vɛ̃n ka ba põ wʊ a ju be a Senkereya, bojũu wʊ dɔ̃ɔ põl 'yɔ̃ɔ a wʊ mãɛ. ");
INSERT INTO biv_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ba tãn be a Efesus tẽe pɔ, ka a Pɔɔl bar a Pɩrɩsɩla nɩ a Akuila tɩ na wʊ mãɛ chen be a lɔ̃ɔfʊ jie ka a 'lɔ naa Juu nɩbɛ tɩ mana taa. ");
INSERT INTO biv_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","A ba sʊɔr wʊ ka wʊ jãnɛ a be bãlãa tɩ waa sɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Tɩchɛ wʊn wa chiine wʊ tɩr nɛɛ kʊ ba, “Ala ɩ Nãaŋmɩn wa sɔɔ naa, ɩn lɩɛb wa.” Be lɛ wʊ kpɛ a gboro yi a be a Efesus tẽe pɔ. ");
INSERT INTO biv_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Wʊn tɩ ta a Sisariya wʊ don be a Jerusalɛm na wʊ tɩ puor a bala na puoro, tɩ pãa suu chen a Antiok. ");
INSERT INTO biv_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pɔɔl na tɩ jɛ̃ a be a Antiok kor bãlãa, wʊ pãa yin yʊɔrɔ a Galatiya paal 'lɔ wʊ jaa nɩ a Fɩrgɩya na wʊ 'yɔ̃ɔnɔ̃ a poturbo ãkpãɛn. ");
INSERT INTO biv_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ka a Juu nɩrɛ ãsʊɔ yuor na di Apolosɩ yin be a Aleksandiriya na wʊ wa a Efesus tẽe pɔ. Wʊ ɩ naa nɩrɛ na jãn na wʊ bɔ̃ɔ a Nãaŋmɩn gãma tɩ bɔ̃ɔ 'yɛr sʊ̃. ");
INSERT INTO biv_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apolosɩ nyã dɔ̃ɔ jãn a sɩ Soro sɔr defʊ, na wʊ 'yɛrɛ nɩ nɩbijɩɛ na wʊ wile nɩ Yesu yele ka a tor, tɩchɛ ka a ɩ Jɔɔn Nãaŋmɩn kʊ̃ɔ sofʊ tɛɛ lɛ wʊ bɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Wʊ piel na wʊ 'yɛrɛ nɩ nyãa be a Juu nɩbɛ lɔ̃ɔfʊ yir. A Pɩrɩsɩla nɩ a Akuila na wa wõ a wʊ 'yɛr, ba bʊɔl wʊn be a ba yir na ba pãa wiil wʊ a Nãaŋmɩn sɔr jaa dẽ dẽ. ");
INSERT INTO biv_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolosɩ wa bʊɔrɔ naa Akaya chenfʊ, ka a yɛɛr 'yɔ̃ɔ wʊ ãkpɛ̃ɔ tɩ sɛb gãn kʊ a bala na puoro a be a ba de wʊ. Wʊn tɩ ta a be a ɩn sʊ̃ʊfʊ kpɛ̃ɛ kʊ a bala a Nãaŋmɩn wãɛfʊ na vɛ̃ ka ba sɔɔ de a Yesu. ");
INSERT INTO biv_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Wʊ 'yɛr kpɛ̃ɔ jaa lɔb a Juu nɩbɛ chãa pɔ, na wʊ chɩrɛ ba yuoro nɩ a Nãaŋmɩn gãma wile ba ɩka a Yesu lɛ ɩ a Nɩ-iraa. ");
INSERT INTO biv_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Lɛ a Apolosɩ na chɛnɛ be a Korɩntɩ, Pɔɔl den a mɔgɔ̃ɔ sɔr na wʊ tɩ ta a Efesus tẽe pɔ. Be lɛ wʊ nyɛ a poturbo bamɩne, ");
INSERT INTO biv_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","na wʊ sʊʊr ba, “A sɔ̃ɔ 'lɔ yɩn sɔɔ de a Yesu, yɩ nyɛn a Nãaŋmɩn Sɩɛ bɩɩ?” Ka ba 'yɛr, “Kai, saa gba wõ ɩka Nãaŋmɩn Sɩɛ ben be ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ka a Pɔɔl sʊʊr ba, “Tɩ kɔ̃buor lɛ yɩ so?” Ka ba 'yɛr, “Jɔɔn kʊ̃ɔ lɛ sɩ so.” ");
INSERT INTO biv_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","A Pɔɔl 'yɛr kʊ ba, “A bala na lɩɛb a ba tɩɛr lɛ a Jɔɔn so ba Nãaŋmɩn kʊ̃ɔ, tɩ na wʊ 'yɛr kʊ a nɩbɛ ɩka ba sɔɔ de a 'lɔ na waara a wʊ puor, 'lɔ lɛ ɩ a Yesu.” ");
INSERT INTO biv_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","A nɩbɛ na wa wõ a anyãna ba sɔɔ naa ka wʊ so ba a Nãaŋmɩn kʊ̃ɔ, nɩ a sɩ Soro Yesu yuor. ");
INSERT INTO biv_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ka a Pɔɔl dɔɔl ba a wʊ nuur ka Nãaŋmɩn Sɩɛ wa kpɛ ba a ba 'yɛrɛ kɔkɔyor, na ba ma piel 'yɛrɛ lɛ Nãaŋmɩn na wiil ba. ");
INSERT INTO biv_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ban ɩn dɔɔr pie nɩ ayi. ");
INSERT INTO biv_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ŋmɛrsɩ ata lɛ wʊ be a be na wʊ ma kpɩɛrɛ a ba lɔ̃ɔfʊ jie na wʊ ma kpɩrkpɩrɛ ba wile ba a Nãaŋmɩn nãalʊ̃ʊ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Tɩchɛ a bamɩne kpɛ̃mɛ naa a ba nyãa na ba tɔr baa sɔɔ ɛ, tɩ na ba kpɛrɛ a Sɔr. Ka a Pɔɔl bar ba, tɩ na wʊ ma tara a bala na sɔɔ de, ma kpɛ̃n be a Tiranusɩ jãnfʊ diyal 'lɔ pɔ, a ba ma tɩ mana taa. ");
INSERT INTO biv_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Lɛ lɛ wʊ tara tɩ tãn yuom ayi, ka a Juu nɩbɛ nɩ a bala na ba ɩ a Juu nɩbɛ, bala jaa na be a Asɩya paal pɔ wõn a sɩ Soro 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nãaŋmɩn den a Pɔɔl tʊ̃n nɛ'maa tʊ̃yɔɔ. ");
INSERT INTO biv_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","A Pɔɔl fɔbile wʊn ma fɩɛlɛ nɩ nyĩe nɩ a wʊ pẽpele ala wa sɩɩr baalaa, a baalsɩ ba jaa ma sa naa, ka a sɩdɛbɛ ma yire a nɩbɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ka a Juu nɩbɛ bamɩne mɩ yi yʊɔrɔ na dii a sɩdɛbɛ ka a yi na ba fere de a sɩ Soro Yesu yuor 'yɛrɛ kʊrɔ a bala na tara a sɩdɛbɛ, “A Yesu 'lɔ a Pɔɔl na mʊɔlɔ, a wʊ yuor pɔ lɛ sɩ 'yɛrɛ kʊrɔ yɩ, yɩ wa yi.” ");
INSERT INTO biv_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","A Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ na di Sekeva dabil ayopõi lɛ dɔ̃ɔ maala a lɛ nɛ. ");
INSERT INTO biv_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Daar kɔ̃ɔ a sɩdɛɛr sʊʊr ba naa, “N bɔ̃ɔn Yesu naa bɔ̃ɔ Pɔɔl, tɩchɛ a yɩn mɩ ba boo yɩ ɩ?” ");
INSERT INTO biv_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ka a daba 'lɔ na tara a sɩ dɛɛr pãa ɔɔ nyɔɔr ba jaa, na wʊ ŋme ba jaa pɩrpɩr tɔɔr a ba bonsɩ chɩɛr ka ba jo yi a die pɔ nɩ sal'mɔi. ");
INSERT INTO biv_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","A Juu nɩbɛ nɩ a bala na ba ɩ a Juu nɩbɛ, na kpɩɛrɛ a be Efesus tẽe pɔ, ba jaa bɔ̃ɔn naa a yele nyãna, ka dãbãɛ kpɛ ba a baa lɛ tara a sɩ Soro Yesu yuor dãɛnɛ nɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ka a nɩyɔɔ bala na sɔɔ de, yi chãa pɔ, na ba 'yɛrɛ a ba maal dɛbɛ. ");
INSERT INTO biv_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","A jɩbʊʊrbɔ bala mɩ na sɔɔ, waan naa a ba jɩbʊʊrgãma wa chʊm a nɩbɛ ba jaa niem, ban wa sɔr a gãma ala ban chʊm libie ka a ɩ libipɩla turo ayi dɔɔl lɩjaayi nɩ pie (50,000). ");
INSERT INTO biv_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","A sɔr nyãna lɛ a sɩ Soro 'yɛr yaar de jie wʊ jaa nɩ kpɛ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","A anyãna a jaa na wa ɩ, Pɔɔl ŋmen nyãa ɩka wʊn chen a Jerusalɛm na wʊn tu a Masedonɩya nɩ Akaya, “Maa wa ta a be baar, ɩn chen a Worom mɩ.” ");
INSERT INTO biv_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Wʊ tʊ̃ naa a nɩbɛ ayi a bala na sʊ̃nɔ̃ wʊ Timoti nɩ Erastus ka ba chen a Masedonɩya, tɩchɛ ka a 'lɔ jãnɛ be a Asɩya paal pɔ kor bãlãa. ");
INSERT INTO biv_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","A sɔ̃ɔ nyãna lɛ a damfʊ ir a Sɔr tʊfʊ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sãa kuro kɔ̃ɔ yuor na di Demetirus, wʊ ma den a kpãna na wʊ kur a Atemisɩ puorfʊ yirbil ka a bala na ɩ a tʊ̃tʊ̃nbɔ nyɛrɛ libie. ");
INSERT INTO biv_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","A Demetirus bʊɔl a wʊ tʊ̃tʊ̃nbɔ ba jaa lɔ̃ɔ taa nɩ a bala jaa mɩ na bɔ̃ɔ a maalfʊ na wʊ 'yɛr kʊ ba, “Yɛɛr, yɩ bɔ̃ɔn naa tɔ̃nɔ̃ sɩn nyɛrɛ a tʊ̃mɔ̃ nyã pɔ. ");
INSERT INTO biv_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Yɩn mãɛ nyɛ naa na yɩ wõ a lɛ a Pɔɔl nyãna na 'yɛrɛ na wʊ lɩɛrɛ a nɩyɔɔ tɩɛrsɩ a ka Efesus tẽe pɔ, nɩ a Asɩya wɛr wʊ jaa. Wʊ 'yɛr naa ɩka a ŋmɩmɛ ala ban maal nuur ba ɩ ŋmɩmɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","A ba ɩ a sɩ yara na lo tɛɛ lɛ ɛ, tɩchɛ ba kʊ̃ lɛ 'yɔ̃ɔnɔ̃ a Atemisɩ puorfʊ yir kpɛ̃ɛ go ɛ. Ka a Asɩya nɩ a wɛr wʊ jaa kʊ̃ lɛ puoro a ŋmɩn pɔɔ nyã go ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ban wõ lɛ a Demetirus na 'yɛr, ka a suur nyɔɔ ba a ba tãna 'yɛrɛ, “A sɩn Efesus ŋmɩn Atemisɩ bɛrma naa.” ");
INSERT INTO biv_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ajienaa lɛ a tẽe wʊ jaa pɔɔn gɔ̃mɔ̃, ka a nɩbɛ nyɔɔ a Gayus nɩ Aristakus, Pɔɔl tʊ̃tʊ̃taaba lɛ a ba 'mataa yi a Masedonɩya na ba ŋmʊr ba a lɛ chiin a jie 'lɔ a tẽe nɩbɛ na ma lɔ̃ɔ dãɛnɛ. ");
INSERT INTO biv_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ka a Pɔɔl mɩ ta bʊɔrɔ ɩka wʊ daa yi a be a nɩyɔɔ bala pɔ, tɩchɛ ka a poturbo ba sɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","A nɩbɛrɛ bamɩne gba na yi a paal 'lɔ pɔ na ɩ a Pɔɔl barmɩne, tʊ̃n nɩbɛ ka ba sʊɔr wʊ ɩka wʊ taa ɩrɛ wa yire be a dãɛn jie ɛ. ");
INSERT INTO biv_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Burbur kpɛ̃n a nɩyɔɔ bala na duo a be, ka bamɩne 'yɛrɛ turo nɩ ka sɛn, ka bamɩne mɩ 'yɛrɛ turo nɩ jã yuo, ka bamɩne mɩ gba ba bɔ̃ɔ bo 'yɔ̃ɔ ban be be ɛ. ");
INSERT INTO biv_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ka a Juu nɩbɛ daa Aleksanda 'yɔ̃ɔ be a niem, ka a nɩyɔɔ bala tãna mana wʊ lɛ wʊn na 'yɛr. Wʊ wɩlwɩl ban nuur ɩka, ba bar gɔ̃n tɩ wʊ 'yɛr a ba kaa. ");
INSERT INTO biv_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tɩchɛ ban wa bɔ̃ɔn ɩka Juu nɩrɛ lɛ wʊ ɩ, ba jaa ŋmen chɛl bʊ̃'yen lɛ̃ɛɛ tɩ na ba 'yɛrɛ, “A sɩn Efesus ŋmɩn Atemisɩ bɛrma naa.” ");
INSERT INTO biv_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","A tẽe gãn sɛɛrɛ vɛ̃n ka a nɩyɔɔ bala ŋmaa vʊʊr tɩ wʊ 'yɛr kʊ ba, “Efesus dẽme woɩ, a wɛr wʊ jaa bɔ̃ɔn naa ɩka a Efesus tẽe lɛ kaara a Atemisɩ kpɛ̃ɛ nyã puorfʊ yir a wʊ kʊsɩr 'lɔ na yi a saaju lo. ");
INSERT INTO biv_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","A nɩtɔ̃nɔ̃ jũu, nɩrɛ kʊ̃ tʊ̃ɔ chɩɩr ɛ, yɩ ɩ jaa gbul na yɩ ta pɔɔrɔ yelsɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","A nɩbɛ banyãna yɩn waan a kana ba ju bon jaa a puorfʊ yir ɛ, bɩɩ 'yɛr 'yɛrdɛɛr jaa 'yɔ̃ɔ a sɩ ŋmɩn pɔɔ nyã ɛ. ");
INSERT INTO biv_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ala ɩ a Demetirus nɩ a wʊ tʊ̃tʊ̃nbɔ wa tara nɩrɛ nɩ 'yɛr, a 'yɛr tɔɔrfʊ bɩbie ben be nɩ a nɩbɛrɛ ban tʊ̃ɔ chen a be tɩ bʊɔl taa. ");
INSERT INTO biv_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ala ɩ yele kɔ̃ɔ mɩ ben be a yɩ bʊɔrɔ ɩka yɩ 'yɛr, ban tʊ̃ɔ maal a be a nɩyɔɔ ba jaa niem. ");
INSERT INTO biv_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","A lɛ an sɩ ben 'yɛr pɔ, a damfʊ nyã na dam a dɩna jũu. A 'yɛr nyãna jũu, saa be jaa na tʊ̃ɔ wiil a par ɛ, bojũu a ba tara par ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","A anyãna wʊn 'yɛr baar tɩ na wʊ wɛl a nɩyɔɔ bala bar. ");
INSERT INTO biv_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Lɛ a gɔ̃mɔ̃ na wa baar, Pɔɔl tʊ̃n bʊɔl a poturbo ka ba wa, a wʊ 'yɔ̃ɔ ba ãkpãɛn tɩ bar ba tɩ chen a Masedonɩya. ");
INSERT INTO biv_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Be lɛ wʊ tu a tẽn ala pɔ na wʊ 'yɛr 'yɛr yɔɔ 'yɔ̃ɔn a bala na puoro ãkpãɛn na wʊ tɩ tãn a Greek wɛr pɔ, ");
INSERT INTO biv_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","wʊ jɛ̃n a be ŋmɛrsɩ ata. Bojũu a Juu nɩbɛ dɔ̃ɔ guoro taa a wʊ yele, ala lɛ so waa lɛ kpɛ a gboro chen a Siriya ɛ, tɩ na wʊ lɩɛb tu a Masedonɩya sɔr nɩ gbɛɛ. ");
INSERT INTO biv_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ka a bala na pʊɔ wʊ a ba 'mataa chen lɛ, Sopater a wʊ sãa lɛ Pirihusɩ na yi Beriya, Aristakus nɩ Sekundusɩ mɩ na yi Tɛsalonika, Gayus na yi Debi nɩ Timoti nɩ Tɩchɩkusɩ nɩ a Torofimusɩ na yi a Asɩya paal pɔ. ");
INSERT INTO biv_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","A nɩbɛ banyãna lɛ de nie tɩ chɛlɛ sɩ be a Toroyas. ");
INSERT INTO biv_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tɩchɛ a Paanʊ̃kõo Lɔ̃ɔfʊ di na wa baar, sɩ kpɛ̃n a gboro yi be a Filipai tẽe pɔ na sɩ maal ber anũu tɩ na sɩ pɔɔ ba a be Toroyas jãnɛ a be ber ayopõi. ");
INSERT INTO biv_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","A Pɛ̃nfʊ divɩɛ bio daar jãanʊɔr, sɩ jaa lɔ̃ɔn taa na sɩn 'mataa di. Pɔɔl 'yɛrɛ naa a Nãaŋmɩn 'yɛr kʊrɔ a nɩbɛ bojũu wɛr wa chaar, wʊn chen naa. Wʊ 'yɛr kor jaa ka wɛr tɩ põ. ");
INSERT INTO biv_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","A be a bɔɔpɩɛ pɔ sɩn lɔ̃ɔ ba chʊm fãtɩnsɩ yɔɔ bin. ");
INSERT INTO biv_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pɔlbile kɔ̃ɔ yuor na di Yutikus jãnɛ naa a tokoro nɛɛ ka a gʊ̃ɔ kpɛ wʊ. Lɛ a Pɔɔl na 'yɛr kor a wʊ gur jaa chãɩɩ na wʊ yi a be a saaju faa lo a be tẽe, bojũu ba mɛn a bɔɔpɩɛ dɔɔl taa ata ka ba suu 'mɔɔ ka ɩ wʊ kpi naa. ");
INSERT INTO biv_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","A Pɔɔl suun tɩ lo bib a kũu tɩ kõr wʊ tɩ 'yɛr kʊ a nɩbɛ, “Yɩ ta kõnõ ɛ, wʊ chɛnɛ na vʊrɔ.” ");
INSERT INTO biv_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Wʊ pãa don be a bɔɔpɩɛ pɔ, ka wʊ tɩ ŋma a paanʊ̃ɔ ka ba 'mataa di tɩ wʊ lɛ 'yɛr lɛ̃ɛɛ ka wɛr tɩ chaar ka wʊ yi a be chen. ");
INSERT INTO biv_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Tɩchɛ ka pɔlbile ir kpɛ̃mɛ ka ba ãgãn 'maa a ba tara wʊ kul a yir. ");
INSERT INTO biv_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Sɩn den nie kpɛ a gboro na sɩ chiine a Asosɩ, be lɛ sɩn tɩ 'mɔɔ a Pɔɔl, lɛ lɛ wʊ dɔ̃ɔ man sɩ tɩ chiine nɩ gbɛɛ a be. ");
INSERT INTO biv_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Lɛ wʊn tɩ tuor sɩ a be Asosɩ, sɩ 'mɔɔ wʊn 'yɔ̃ɔ a gboro pɔ na sɩ chiine be a Mitilene. ");
INSERT INTO biv_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wɛr na wa chaar, sɩ yin a be tɩ ta Kiyosɩ ka a wɛr lɛ bɔ̃ɔ chaar sɩ go kaa ɩ sɩ vɩɛn Samosɩ bar. A ber ata daar lɛ sɩ pãa ta a Miletusɩ. ");
INSERT INTO biv_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔɔl bʊɔrɔ naa ɩka wʊ po a Efesus tẽe bar na wʊ ta gã be a Asɩya paal pɔ ɛ, bojũu wʊ bʊɔrɔ na fɔɔ ɩka 'lɔ tʊ̃ɔ, wʊ ta a Jerusalɛm a Pentikosɩ bɩbir daar. ");
INSERT INTO biv_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pɔɔl na chɛnɛ be a Miletusɩ lɛ wʊ tʊ̃ bʊɔl a bala na puoro a be a Efesus, a ba nɩdierbe ka ba wa. ");
INSERT INTO biv_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ban wa ta, wʊ 'yɛr kʊ ba, “Yɩ bɔ̃ɔ lɛ ɩn be dɔ̃ɔ kpɩɛrɛ a yɩ sɛ̃, yi a daar 'lɔ̃nɔ̃ jaa ɩn wa a Asɩya paal pɔ. ");
INSERT INTO biv_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mãɛ siirfʊ nɩ nɩbikʊ̃ɔ lɛ n tʊ̃nɔ̃ nɩ a sɩ Soro tʊ̃mɔ̃, bojũu a Juu nɩbɛ ba maal ma vɩla ɛ. ");
INSERT INTO biv_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Yɩn mãɛ bɔ̃ɔn naa ɩka n ba sɔɔl yɩ yele jaa na sʊ̃ʊ yɩ ɛ, tɩchɛ n wile yɩn chãa pɔ, nɩ a yɩ yie pɔ. ");
INSERT INTO biv_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","N kpãkpãan naa a Juu nɩbɛ nɩ a bala na ba ɩ a Juu nɩbɛ ɛ, ɩka ba lɩɛb wa a Nãaŋmɩn sɛ̃, na ba lɩɛb a ba tɩɛr sɔɔ de a sɩ Soro Yesu. ");
INSERT INTO biv_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Pʊ̃pãanyã 'lɔ, Nãaŋmɩn Sɩɛ 'yɛr man ka n chiine a Jerusalɛm, n ba bɔ̃ɔ lɛn na tɩ pɔɔ ma a be ɛ. ");
INSERT INTO biv_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Yelbʊ̃'yen tɛɛ lɛ n bɔ̃ɔ ɩka, tẽe jaa pɔ, a Nãaŋmɩn Sɩɛ ma vɛ̃n ka n bɔ̃ɔn ɩka die pɔ pɔɔfʊ, nɩ wõm lɛ ɩn tɩ tuor. ");
INSERT INTO biv_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Tɩchɛ a anyãna maa bã ma ɛ, ala ɩ ɩn tʊ̃ɔ jo ta a baaraa naa tʊ̃ a lɛ a sɩ Soro Yesu na kʊ ma a tʊ̃mɔ̃, ɩka n 'yɛr a Nãaŋmɩn wãɛfʊ 'yɛr nʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Yɩ nyɛ, pʊ̃pãanyã a yɩn bala jie ɩn yɔ naa mʊɔl a Nãaŋmɩn nãalʊ̃ʊ 'yɛr, yɩ kʊ̃ lɛ nyɛ ma go ɛ. ");
INSERT INTO biv_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","A lɛ jũu, n 'yɛrɛ na kʊrɔ yɩ a dɩna ɩka ãsʊɔ jaa wa bɔr, n nũu ba pʊɔ be ɛ. ");
INSERT INTO biv_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Bojũu n ba dɔ̃ɔ sɔɔl yɩ yele jaa ɛ, tɩ man a lɛ jaa a Nãaŋmɩn na bʊɔrɔ kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Yɩ gu yɩ mãɛ nɩ a nɩbɛ bala 'yɔ̃ɔ a Nãaŋmɩn Sɩɛ na maal yɩ a yɩ ɩ a nɩdierbe. Yɩ kaara a Nãaŋmɩn pupuorbiir bala wʊn dãn a wʊ mãɛ jãɩ. ");
INSERT INTO biv_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","N bɔ̃ɔn naa ɩka maa wa chen baar, nɩbɛ na lɩɛb gbõgboi kpɛ a yɩ pɔ, ba kʊ̃ bar yɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bamɩne na yin a yɩn mãɛ pɔ gba, na ba jɛr a yelmãɛ bɛl nɩbɛ ka ba turo ba. ");
INSERT INTO biv_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","A lɛ jũu yɩ guro yɩ mãɛ na yɩ tɩɛr kaa, yuom ata nɩ nyã ɩn ba vɛ̃ a yɩ ãsʊɔ jaa wiilfʊ ɛ, nɩbikʊ̃ɔ lɛ n wile nɩ yɩ mɔ̃tɔ̃ɔ nɩ tãsɔɔ. ");
INSERT INTO biv_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Pʊ̃pãanyã, n de yɩn 'yɔ̃ɔ a Nãaŋmɩn nũu pɔ, nɩ a wʊ wãɛfʊ 'yɛr bie pɔ, a yɩ na tʊ̃ɔ nʊ̃ɔ a wʊ kʊ yɩ a bʊ̃sʊ̃n ala wʊn tara kʊ a wʊ nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","N ba tara nyuur nɩ ãsʊɔ jaa libir, bɩɩ sɛlma, bɩɩ a fɔɔr ɛ. ");
INSERT INTO biv_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Yɩn mãɛ bɔ̃ɔn naa ɩka a n bʊ̃bʊɔrsɩ, a n nũu pɔ lɛ a yi, naa sʊ̃ʊ a bala ɩn lɔ̃ɔ tʊ̃nɔ̃ nɩ. ");
INSERT INTO biv_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Bon jaa ɩn maal, n wiil yɩ naa ɩka a tʊ̃kpãɛn a nɩtɔ̃nɔ̃ pɔ lɛ, sɩn tu na sɩ sʊ̃ʊ a nɩbaalsɩ, yɩ tɩɛrɛ a lɛ a sɩ Soro Yesu na dɔ̃ɔ 'yɛr, ‘An ɩn bɔɔsʊ̃n kʊ a 'lɔ na de bon kʊ nɩrɛ, gar a 'lɔ na de.’ ” ");
INSERT INTO biv_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Wʊn 'yɛr a anyãna baar, wʊ gbur dumo ka ba jaa 'mataa sʊɔr a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ba jaa ŋman nɩbikʊ̃ɔ tɩ na ba kõr kõr wʊ. ");
INSERT INTO biv_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","A lɛ na maal sɔ̃ɔ a ba pʊɔ nɩ nyã, a lɛ wʊn 'yɛr ɩka ba kʊ̃ lɛ nyɛ wʊ go ɛ, tɩ na ba bɩɛl wʊ suun a gboro jie. ");
INSERT INTO biv_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Sɩn wa bar taa baar, sɩ kpɛ̃n a gboro na sɩ tor a Kos a dẽdẽe a lɛ nɛ, a wɛr na wa chaar ka a ɩ sɩ tãn a Worodesɩ yi a be chen a Patara. ");
INSERT INTO biv_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Sɩ nyɛn a gboro ãsʊɔ na chiine a Fonisiya ka sɩ kpɛ chiine. ");
INSERT INTO biv_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Sɩn wa nyɛrɛ a Sipurusɩ tẽe sɩ lan wʊn bar a guba jie tɩ ta a Siriya tẽe pɔ. Tire lɛ sɩ ta ara an ɩ be lɛ a gboro na wɛl a tuor wʊn tuo. ");
INSERT INTO biv_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Be lɛ sɩ nyɛ a poturbo bamɩne na sɩ jãnɛ a ba sɛ̃ ber ayopõi. Ka a Nãaŋmɩn Sɩɛ tu a ba 'yɔ̃ɔ a ba 'yɛr kʊ a Pɔɔl ɩka wʊ taa chiine a Jerusalɛm ɛ. ");
INSERT INTO biv_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Tɩchɛ a sɩ bɩbie na wa ta, sɩ yin de a sɩ sɔr. Ka a poturbo bala ba jaa nɩ a ba pɔbɔ nɩ a ba bibiir ba jaa bɩɛl sɩ yin a tẽe pɔ, tɩ tãn a man gogoro nɛɛ, ka sɩ gbur dumo sʊɔr Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Sɩn wa bar taa baar, sɩ kpɛ̃n a gboro pɔ, tɩ ba mɩ lɩɛb kulo a yir. ");
INSERT INTO biv_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","A Tire sɩn be yi, a man pɔ lɛ sɩ chen bãlãa tɩ ta a Tolemaisɩ be lɛ sɩ puor a yɛɛr bamɩne na be be na sɩ gã a be bɩbir bʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Sɩn ir a be chiine sɩ tãn be a Sisariya na sɩ chen a Filip na mʊɔlɔ a Nãaŋmɩn 'yɛr nʊ̃ɔ na wʊ mɩ ɩ a nɩbɛ ayopõi bala ãsʊɔ ban dɔ̃ɔ ir be a Jerusalɛm yir. ");
INSERT INTO biv_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Wʊ dɔ̃ɔ tara pɔɔsarsɩ anaar na ba kul sɩrbɛ ɛ, ka Nãaŋmɩn ma kʊ ba a wʊ 'yɛr a ba 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Sɩ jɛ̃n a be kor bãlãa ka a Agabus yi be a Judiya na, ");
INSERT INTO biv_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","wʊn wa a sɩ sɛ̃. Wʊ den a Pɔɔl sɩɛ gãn na wʊ lũn a wʊ mãɛ nuur nɩ a gbɛɛ tɩ na wʊ 'yɛr. “A Nãaŋmɩn Sɩɛ 'yɛr naa, ‘Nɩtɔ̃nɔ̃ lɛ a Juu nɩbɛ na be a Jerusalɛm na lũ a nɩrɛ 'lɔ na so a sɩɛ gãn nyãna, na ba 'yɔ̃ɔ a bala na ba ɩ a Juu nɩbɛ nuur pɔ.’ ” ");
INSERT INTO biv_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","A lɛ sɩn wõ a nɩtɔ̃nɔ̃ ka a sɩn nɩ a nɩbɛ bala na be a be 'mataa sʊɔr a Pɔɔl ɩka wʊ taa chiine a Jerusalɛm ɛ. ");
INSERT INTO biv_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Tɩchɛ ka a Pɔɔl 'yɛr, “Bãa 'yɔ̃ɔ lɛ yɩ kõnõ na yɩ chɩrɛ ma a ãgãn a lɛ? N sɔɔ naa, a ta ɩ a lũfu tɛɛ ɛ, tɩchɛ n kpi be a Jerusalɛm a sɩ Soro Yesu yuor jũu.” ");
INSERT INTO biv_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","A lɛ sɩn sʊɔr wʊ faa sɩ mɩ bar naa tɩ 'yɛr “A sɩ Soro bɔfʊ a ɩ.” ");
INSERT INTO biv_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","A anyã puor lɛ sɩ chɔɔr na sɩ do be a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ka a poturbo bala na be a Sisariya bɩɛl sɩ na ba waan sɩ a daba 'lɔ na di a Minason yir be lɛ sɩn wa kpɩɛrɛ, Sipurusɩ tẽe pɔ lɛ wʊ yi tɩ na wʊ ɩ a poturo kor. ");
INSERT INTO biv_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","A lɛ sɩn wa ta a Jerusalɛm, a yɛɛr de sɩn nuur ayi. ");
INSERT INTO biv_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ka a wɛr na wa chaar, sɩn nɩ a Pɔɔl jaa 'mantaa chen ɩka sɩ tɩ nyɛ a Jemesɩ ka a ɩ be lɛ a nɩbɛrɛ ba jaa lɔ̃ɔ taa. ");
INSERT INTO biv_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔɔl na puor ba jaa baar, wʊ man naa yele a jaa kʊ ba, a lɛ a Nãaŋmɩn na de wʊ tʊ̃n be a bala na ba ɩ a Juu nɩbɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","A lɛ ban wõ anyãna ba jaa pɛɛn Nãaŋmɩn tɩ na ba pãa 'yɛr kʊ a Pɔɔl, “Yɛbɛ faa nyɛ, a Juu nɩbɛ turo turo na sɔɔ de, tɩchɛ ba chɛnɛ na tara nɩbijɩɛ nɩ a nɛbinãa. ");
INSERT INTO biv_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ba man kʊ ba ɩka fʊ̃ʊ lɛ wile a Juu nɩbɛ bala na kpɩɛrɛ a bala na ba ɩ a Juu nɩbɛ pɔ, ka ba taa turo a Mosesɩ ɛ, na fʊ lɛ wile ɩka ba taa ŋmara a ba bibiir yɔɩ ɛ, na ba taa ɩrɛ a lɛ a Juu nɩbɛ na ma ɩrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ban wõn ɩka fʊ wan a ka, ŋmɩnɛ sɩn ɩ? ");
INSERT INTO biv_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Fʊ̃ʊ bʊɔrɔ fʊ tu a lɛ sɩn na 'yɛr. Dɔɔr anaar ben ka a sɩ sɛ̃ na ba põl 'yɔ̃ɔ a ba mãɛ. ");
INSERT INTO biv_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","De a nɩbɛ banyãna na fʊ pʊɔ ba, a yɩ tɩ pɔl a fʊ yab a ba jur põfʊ sãma. Ka nɩrɛ jaa na pãa bɔ̃ɔn ɩka a lɛ ban man 'yɔ̃ɔfʊ ba ɩ yelmãɛ ɛ, tɩchɛ a fʊ̃ʊ mãɛ mɩ turo naa a nɛbinãa. ");
INSERT INTO biv_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tɩchɛ a nɩyor bala na sɔɔ de, sɩ sɛb gãn kʊ ba a lɛ sɩn 'yɛr ɩka, ba taa dire tɩbɛ bomo ɛ, bɩɩ ɔɔrɔ jãɩ ɛ, bɩɩ 'wɔb dʊɔ na var kpi ɛ, na ba taa sɛ̃nɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Wɛr na wa chaar, Pɔɔl den a dɔɔr anaar bala ka ba 'mataa tɩ pɔl a ba mãɛ. Tɩ na wʊ pãa chen be a Nãaŋmɩn puorfʊ yir na tɩ 'yɛr a bɩbie ala a ba pɔlfʊ na baar nɩ a bɔɔrlo bomo ala a ba ãsʊɔ jaa na ir. ");
INSERT INTO biv_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","A lɛ a ber ayopõi na wa gbʊrɔ a baarfʊ, a Juu nɩbɛ bamɩne na yi a Asɩya paal pɔ nyɛn a Pɔɔl a be Nãaŋmɩn puorfʊ yir, na ba dam a nɩyɔɔ bala a ba nyɔɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ba gboolo naa, “Isɩral nɩbɛ woɩ, yɩ wa sʊ̃ʊ sɩ yooo. A daba lɛ anyãna na wile a nɩbɛ jie jaa ka ba kpɛrɛ a sɩ nɩbɛ nɩ a nɛbinãa lɔ̃ɔn a jie nyãna. Lɛ tɛɛ gba ba lɛ ɛ, wʊ tara na a bala na ba ɩ a Juu nɩbɛ ɛ, kpɛ̃n ka a Nãaŋmɩn puorfʊ yir na wʊ sɔ̃ɔ a jivɩla nyãna.” ");
INSERT INTO biv_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ba dɔ̃ɔ nyɛ a Torofimusɩ na yi a Efesus nɩ a Pɔɔl a ba tɩɛr man tãa a Pɔɔl tara wʊn kpɛ̃n be a Nãaŋmɩn puorfʊ yir. ");
INSERT INTO biv_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","A tẽdaa wʊ jaa kab, ka a nɩbɛ yire a tẽe wʊ jaa joro waara na ba wa nyɔɔ a Pɔɔl. Ba nyɔɔ wʊn a lɛ tɔɔ yin a Nãaŋmɩn puorfʊ yir jie tɩ pɔɔ a pãma ajienaa. ");
INSERT INTO biv_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ka ba ta bʊɔrɔ ɩka ba kʊ a Pɔɔl ka a yele tɩ ta a Worom sojasɩ ba jaa nɩkpɛ̃ɛ ɩka a Jerusalɛm wʊ jaa dɔ̃ɔnɔ̃ naa. ");
INSERT INTO biv_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","A wʊ vaa ir a lɛ na wʊ tara a nɩbɛrɛ bamɩne nɩ a sojasɩ na wʊ suu chiin be a nɩyɔɔ bala pɔ. Lɛ ban wa nyɛ a nɩkpɛ̃ɛ nɩ a wʊ sojasɩ a ba bar a Pɔɔl ŋmefʊ. ");
INSERT INTO biv_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Lɛ a sojasɩ ba jaa nɩkpɛ̃ɛ na wa ta wʊ tɩ nyɔɔn a Pɔɔl na wʊ vɛ̃ ka ba gbãr wʊ nɩ bɔ̃jɔrsɩ ayi. Tɩ pãa sʊʊr ɩka nɩ ana lɛ, nɩ bo lɛ wʊ maal. ");
INSERT INTO biv_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bamɩne na be a nɩyɔɔ bala pɔ 'yɛrɛ na turo nɩ jiyuo ka bamɩne mɩ 'yɛrɛ turo nɩ jiyuo a sojasɩ ba jaa nɩkpɛ̃ɛ na ba nyɛ a yelmãɛ ɛ, a gɔ̃mɔ̃ jũu, wʊ vɛ̃n ka ba tara a Pɔɔl gʊɔr be a sojasɩ kpɛfʊ jie. ");
INSERT INTO biv_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Lɛ a Pɔɔl na wa ta a dofʊ jie a nɩbɛ pir pirfʊ jaa waa naa ka a sojasɩ 'mɔɔ a Pɔɔl. ");
INSERT INTO biv_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ka a nɩyɔɔ bala na turo tãna 'yɛrɛ, “Yɩ kʊ wʊ.” ");
INSERT INTO biv_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Lɛ a sojasɩ na wa ɩka ba kpɛ̃n a Pɔɔl a be a ba kpɛfʊ jie wʊ sʊɔr naa a sojasɩ ba jaa nɩkpɛ̃ɛ ɩka, “N 'yɛr 'yɛr kɔ̃ɔ kʊ fʊ bɩɩ?” Ka a nɩkpɛ̃ɛ sʊʊr wʊ, “Fʊn tʊ̃ɔn 'yɛr a Greek kɔkɔr bɩɩ? ");
INSERT INTO biv_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","A ba ɩ fʊ̃ʊ lɛ a Ijipitɩ nɩrɛ 'lɔ na dɔ̃ɔ ŋmaa a jɛɛr na fʊ tɔɔ dɔɔr turo anaar (4,000) kpɛ̃n be a mɔgɔ̃ɔ pɔ ɛ?” ");
INSERT INTO biv_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ka a Pɔɔl 'yɛr, “N ɩ naa Juu nɩrɛ naa yi a Tasusɩ na be a Sɩlɩsɩya paal pɔ, naa yi a tẽe nyãna pɔ nɩrɛ jaa na bɔ̃ɔn, yãayãabɩlɛ sɔɔ ka n 'yɛr 'yɛr kʊ a nɩbɛ.” ");
INSERT INTO biv_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","A sojasɩ ba jaa nɩkpɛ̃ɛ kʊn a Pɔɔl sɔr, ka a wʊ ir ara a dofʊ jie, na wʊ wɩlwɩl a nɩyɔɔ bala a nuur ka ba bar gɔ̃mɔ̃. A lɛ ban wa ŋmaa a vʊʊr wʊ den a ba Juu nɩbɛ kɔkɔr na 'yɛrɛ nɩ. ");
INSERT INTO biv_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“N yɛɛr nɩ n sãamɩne yɩ chɛlɛ a n 'yɛr ɩn 'yɛrɛ a pʊ̃pãanyã.” ");
INSERT INTO biv_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","A lɛ ban wa wõ wʊn 'yɛrɛ nɩ a ba mãɛ Juu nɩbɛ kɔkɔr ka ba jaa ŋma vʊrɔ, tɩ a Pɔɔl pãa 'yɛrɛ, ");
INSERT INTO biv_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Maa ɩn Juu nɩrɛ ka ba dɔɔ ma a Tasusɩ na be a Sɩlɩsɩya paal pɔ, tɩchɛ a kana a Jerusalɛm lɛ ba guol ma. A wiwile Gamaliel pĩlem lɛ n jãnɛ ka wʊ wiil ma a nɛɛr ala a sɩ sãakpãmɩne na dɔ̃ɔ turo ka n mɩ turo a Nãaŋmɩn nɩ a n nyãa wʊ jaa, nɩtãa a yɩ ãsʊɔ jaa na be turo a dɩna. ");
INSERT INTO biv_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","N gen a nɩbɛ bala na turo a Sɔr nyãna naa kʊ, n nyɔɔr dɔɔr nɩ pɔbɔ jaa 'yɔ̃ɔ a pɔɔfʊ die pɔ. ");
INSERT INTO biv_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","A bɔɔrlo nɩkpɛ̃ɛ nɩ a nɩbɛrɛ na tʊ̃ɔn di ma dãasɩɛ, ba sɛ̃ lɛ n de gãma na chiin a ba yɛɛr sɛ̃ be a Damaskus, n chen ɩka n tɩ nyɔɔr a nɩbɛ banyãna waan a Jerusalɛm ka ba kpãa ba. ");
INSERT INTO biv_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Mɔ̃tɔ̃tuo sɔ̃ɔ lɛ n chiine tɩ gbʊrɔ a Damaskus, ajienaa ka ɩ chãa yin be a saaju na wʊ wa chaar jilʊ̃ ma. ");
INSERT INTO biv_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ka a n tɔ̃ɔ lo a tẽe a lɛ nɛ tɩ naa wõ kɔkɔr na sʊrɔ ma, ‘Sɔɔl, Sɔɔl, bo lɛ fʊ gere ma a lɛ?’ ");
INSERT INTO biv_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ka n sʊʊr, ‘Soro, an lɛ fʊ ɩ?’ Ka a kɔkɔr 'yɛr, ‘Maa lɛ a Yesu na yi a Najaretɩ a 'lɔ fʊn gere.’ ");
INSERT INTO biv_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","A maa nɩ a bala na lɔ̃ɔ chiine ba nyɛn a chãa, tɩchɛ baa bɔ̃ɔ a nɩnyɩnɛ kɔkɔr lɛ wʊn 'yɛrɛ nɩ ma par ɛ. ");
INSERT INTO biv_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ka n sʊʊr, ‘Soro, ŋmɩnɛ lɛ ɩn ɩ?’ Ka a Soro 'yɛr, ‘Ir na fʊ kpɛ be a Damaskus tẽe pɔ, be lɛ ban tɩ man fʊ a lɛ ɩn bʊɔrɔ ɩka fʊ ɩ.’ ");
INSERT INTO biv_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ka n lɔ̃ɔturbo bala nyɔɔ ma a nũu tɔɔ kpɛ̃n be a Damaskus tẽe pɔ, bojũu a chãa 'lɔ̃nɔ̃ na chaar 'yɔ̃ɔ ma a lɛ nɛ n ba lɛ nyɛrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Daba kɔ̃ɔ yuor na di Ananias wan ɩka wʊ wa nyɛ ma, wʊ ɩn Nãaŋmɩn puoro na wʊ turo a nɛbinãa ka a Juu nɩbɛ ba jaa na kpɩɛrɛ a be 'yɔ̃ɔnɔ̃ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Wʊ wa ara na gbɛb ma tɩ 'yɛr, ‘N yɛbɛ Sɔɔl, lɛ nyɛrɛ,’ ka a ɩ ajienaa ka a ɩ n nyɛ wʊ naa. ");
INSERT INTO biv_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Be lɛ wʊ pãa 'yɛr kʊ ma, ‘A sɩ sãakpãmɩne Nãaŋmɩn lɛ ir fʊ ɩka fʊ bɔ̃ɔ a lɛ wʊn bʊɔrɔ, na fʊ lɛ nyɛ a chɛchɛ sʊɔ 'lɔ, na fʊ wõ a 'yɛr bie yi a wʊ nɛɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Fʊ̃ʊ lɛ na ɩ a dãasɩɛ sʊɔ na fʊ kʊ a nɩbɛ ba jaa, a ala fʊn nyɛ, nɩ a ala fʊn wõ. ");
INSERT INTO biv_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Pʊ̃pãanyã, bo lɛ fʊ lɛ chɛlɛ go? Ir a ba so fʊ a Nãaŋmɩn kʊ̃ɔ, ka a na pɛɛ a fʊ yeldɛbɛ bar a fʊ bʊɔlɔ a sɩ Soro yuor.’ ");
INSERT INTO biv_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“A lɛ ɩn lɩɛb wa a Jerusalɛm naa tɩ sʊɔrɔ Nãaŋmɩn be a puorfʊ yir, ka a wa kaara ma jãna kaar. ");
INSERT INTO biv_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ka n nyɛ a sɩ Soro na 'yɛrɛ 'yɛr kʊrɔ ma. Wʊ 'yɛr naa, ‘Pɔɔ fɔɔ na fʊ yi ka a Jerusalɛm ajienaa, bojũu nɩrɛ jaa kʊ̃ sɔɔ a lɛ fʊn na 'yɛr a n 'yɛr ɛ.’ ");
INSERT INTO biv_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ka n 'yɛr sɔɔ wʊ, ‘N Soro a nɩbɛ banyãna bɔ̃ɔn naa a lɛ ɩn yʊɔrɔ a lɔ̃ɔfʊ jiir naa nyɔɔrɔ ba pɔɔrɔ tɩ ŋmiere a bala na sɔɔ de fʊ. ");
INSERT INTO biv_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","A daar 'lɔ̃nɔ̃ ban kʊrɔ a fʊ dãasɩ dire Sɩteven maa nɩ bala jaa ɩn nɛbʊ̃'yen ka n kaara a ba fuusɩ tɩ ba kʊ wʊ.’ ");
INSERT INTO biv_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ka a sɩ Soro pãa 'yɛr kʊ ma, ‘Chen, ɩn tʊ̃ fʊn tɛɛr jaa be a bala na ba ɩ a Juu nɩbɛ pɔ.’ ” ");
INSERT INTO biv_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","A nɩyɔɔ bala chɛlɛ naa lɛ a Pɔɔl na 'yɛrɛ wa tãn a jie wʊn 'yɛr a nɩyor pɔ chenfʊ 'yɛr, a ba pãa tãna 'yɛrɛ, “Yɩ ŋmaa wʊ ju, a ba sɛɛ ɩka wʊ lɛ chɛnɛ vʊrɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Lɛ lɛ ba pɔɔrɔ a gɔ̃mɔ̃ tɩ lɔɔrɔ a ba fɔɔr ɔ̃ɔnɔ̃ a tãna lɔɔrɔ a saaju. ");
INSERT INTO biv_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ka a sojasɩ ba jaa nɩkpɛ̃ɛ vɛ̃ ka ba tara a Pɔɔl kpɛ̃n be a sojasɩ yir. Wʊ 'yɛr ɩka ba fɔb a Pɔɔl a wʊ wiil ba bãa lɛ so a nɩbɛ pɔɔrɔ a gɔ̃mɔ̃ 'yɔ̃ɔnɔ̃ wʊ a lɛ. ");
INSERT INTO biv_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","A lɛ ban lũ a Pɔɔl ɩka ba fɔb, ka wʊ sʊʊr a sojasɩ nɩdier na ara a be, “A tara na sɔr ka yɩn fɔb a Worom nɩrɛ na yaa sʊʊr kaa a yelnyɩnɛ wʊn ɩ ɛ?” ");
INSERT INTO biv_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Lɛ a sojasɩ nɩdier na wa wõ a nɩtɔ̃ wʊ chen a ba jaa nɩkpɛ̃ɛ sɛ̃ tɩ 'yɛr, “Ŋmɩnɛ lɛ fʊn ɩ? A daba nyã ɩn Worom nɩrɛ.” ");
INSERT INTO biv_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ka a sojasɩ ba jaa nɩkpɛ̃ɛ chen a Pɔɔl sɛ̃ tɩ sʊʊr wʊ, “'Yɛr kʊ ma, Worom nɩrɛ lɛ fʊ ɩ ɔ?” Ka a Pɔɔl 'yɛr ɩka, “Ɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","A sojasɩ ba jaa nɩkpɛ̃ɛ pãa 'yɛr, “Maa 'lɔ, libiyɔɔ lɛ n yab tɩ jãnɛ a ka.” Tɩchɛ ka a Pɔɔl 'yɛr, “Maa 'lɔ, ka lɛ ba dɔɔ ma.” ");
INSERT INTO biv_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ka a bala na ara gu a wʊ fɔbfʊ mɩ tɔɔ yaar ajienaa. Dãbãɛ mɩ kpɛ̃n a sojasɩ ba jaa nɩkpɛ̃ɛ a lɛ wʊn wa bɔ̃ɔn ɩka a Pɔɔl ɩn Worom nɩrɛ tɩchɛ ka wʊ vɛ̃ a ba lũ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","A wɛr na wa chaar, a sojasɩ ba jaa nɩkpɛ̃ɛ bʊɔrɔ naa ɩka wʊ bɔ̃ɔ bãa 'yɔ̃ɔ lɛ a Juu nɩbɛ ba bara a Pɔɔl ɛ. Wʊ for wʊn bar tɩ bʊɔl a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a 'yɛr tɔɔrbɔ nɩbɛrɛ ka ba jaa lɔ̃ɔ taa. Tɩ wʊ pãa suu waan a Pɔɔl a wʊ wa ara a ba niem. ");
INSERT INTO biv_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔɔl kãan a nɩbɛrɛ a lɛ a dẽdẽe tɩ 'yɛr, “N yɛɛr, n tʊ̃n a lɛ na sɛɛ kʊ Nãaŋmɩn wa ta a dɩna tɩ n nyãa ba dɔ̃ɔnɔ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","A anyãna wʊn 'yɛr ka a Ananias na ɩ a Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ 'yɛr kʊ a bala na ara gbʊr a Pɔɔl ɩka ba 'ma wʊ a nɛɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ka a Pɔɔl pãa 'yɛr kʊ wʊ, “Nãaŋmɩn na 'ma fʊ naa a fʊ̃ʊ na ɩ a tãpɩɛl dachin nyã. Fʊ jɛ̃n a be ɩka fʊ tɔɔr a n 'yɛr a lɛ a nɛɛ na bin tɩ na fʊ̃ʊ mãɛ lɛ sɔ̃ɔnɔ̃ a nɛɛ, na fʊ 'yɛr ɩka ba 'ma ma.” ");
INSERT INTO biv_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","A bala na ara gbʊr a Pɔɔl 'yɛr kʊ, “Aa! Bɔɔrlo nɩkpɛ̃ɛ lɛ fʊ tʊrɔ ɔ?” ");
INSERT INTO biv_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ka a Pɔɔl 'yɛr, “Yɛɛr n ba bɔ̃ɔ ɩka a bɔɔrlo nɩkpɛ̃ɛ lɛ wʊ ɩ ɛ, bojũu a sɛb a Nãaŋmɩn gãn pɔ ɩka, ‘Taa ɩrɛ wa 'yɛrɛ 'yɛrdɛɛr 'yɔ̃ɔnɔ̃ a fʊ nɩbɛ nɩdier ɛ.’ ” ");
INSERT INTO biv_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔɔl na wa bɔ̃ɔn ɩka a Saduseemɩne jɛr naa Faraseemɩne pɔ ka wʊ tãn kpɛ̃ɔ jaa be a nɩbɛrɛ pɔ na wʊ 'yɛr, “N yɛɛr, Farasee lɛ n ɩ, ka a Farasee nɩrɛ dɔɔ ma. N ara naa kana a ban tɔɔr a n 'yɛr, bojũu n sɔɔ naa ɩka kũu pɔ irfʊ ben be.” ");
INSERT INTO biv_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","A lɛ wʊn wa 'yɛr a nɩtɔ̃nɔ̃ ka a nɛchɩrɛ lo a Faraseemɩne nɩ a Saduseemɩne chara pɔ, ka a lɔ̃ɔfʊ ŋma jiir ayi. ");
INSERT INTO biv_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduseemɩne 'yɛr ɩka kũu pɔ irfʊ ba be be ɛ, malakasɩ nɩ a nɩsɩɩr mɩ ba be be ɛ, tɩchɛ ka a Faraseemɩne 'lɔ sɔɔn ɩka a jaa ben be. ");
INSERT INTO biv_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","A gɔ̃mɔ̃ pɔɔfʊ tɩ gar naa ka a Mosesɩ nɛɛ wiwiilbe bamɩne na ɩ a Faraseemɩne ir ara tɩ chɩɩr kpɛ̃ɔ jaa ɩka, “Sɩn 'lɔ ba nyɛ a daba nyã chɛfʊ jie ɛ, tɩ ala wa ɩ sɩɛ kɔ̃ɔ bɩɩ malaka lɛ 'yɛr 'yɛr kʊ wʊ?” ");
INSERT INTO biv_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","A nɛchɩrɛ wa tɩ gar naa, ka a dãbãɛ kpɛ a sojasɩ ba jaa nɩkpɛ̃ɛ a wʊ man tãa ban wa tɔɔr a Pɔɔl 'mɛl, ala lɛ so ka wʊ vɛ̃ a sojasɩ suu tɩ faa a Pɔɔl don be a sojasɩ yir. ");
INSERT INTO biv_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","A tãsɔɔ 'lɔ̃nɔ̃, a sɩ Soro wa ara na gbʊr a Pɔɔl tɩ 'yɛr, “Nyɔɔ nyãa, a lɛ fʊn man a n yelmãɛ a ka a Jerusalɛm mɩ tɩ man a lɛ nɛ a be a Worom tẽe pɔ.” ");
INSERT INTO biv_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Wɛr na wa chaar bibio, a Juu nɩbɛ bamɩne jɛ̃n guor taa na ba pɔ'yɔ̃ɔ a ba mãɛ 'yɛrɛ ɩka ba kʊ̃ di bon jaa ɛ, bɩɩ nyũ bon jaa ɛ, ka bala baa kʊ a Pɔɔl ɛ. ");
INSERT INTO biv_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ba gar dɔɔr lɩjaayi na guor a guorfʊ nyãna. ");
INSERT INTO biv_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ba chen a bɔɔrlo nɩkpɛ̃ɛ nɩ a nɩbɛrɛ sɛ̃, na ba tɩ 'yɛr, “Sɩ bin nɛɛ ɩka sɩ kʊ̃ di bon jaa ɛ, ka sɩn baa kʊ a Pɔɔl baar ɛ. ");
INSERT INTO biv_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Pʊ̃pãanyã, yɩn nɩ a 'yɛr tɔɔrbɔ nɩbɛrɛ yɩ tʊ̃ 'yɛr a sojasɩ ba jaa nɩkpɛ̃ɛ a wʊ waan a Pɔɔl a yɩ sʊʊr yele kɔ̃ɔ bɔ̃ɔ a par. Sɩn na var gu be a sɔr pɔ kʊ wʊ ka waa ta a be a yɩ sɛ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Tɩchɛ ka a Pɔɔl arbile wõ a guorfʊ nyã na wʊ chen be a sojasɩ yir na wʊ tɩ 'yɛr kʊ a Pɔɔl. ");
INSERT INTO biv_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ka a Pɔɔl bʊɔl a sojasɩ nɩkpɛ̃ɛ ãsʊɔ na wʊ 'yɛr, “Tara a pɔlbile nyãna chiin a yɩ jaa nɩkpɛ̃ɛ sɛ̃ wʊ tara na 'yɛr na 'yɛr kʊ wʊ.” ");
INSERT INTO biv_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Lɛ lɛ wʊ tara a pɔlbile chiin a ba nɩkpɛ̃ɛ sɛ̃ na wʊ tɩ 'yɛr, “A Pɔɔl na be a pɔɔfʊ die pɔ lɛ tʊ̃ bʊɔl ma na wʊ 'yɛr ɩka n tara a pɔlbile nyãna waan a fʊ sɛ̃, ka wʊ tara na 'yɛr na 'yɛr kʊ fʊ.” ");
INSERT INTO biv_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ka a sojasɩ ba jaa nɩkpɛ̃ɛ nyɔɔ a pɔlbile nũu tɔɔ yin chɛ̃chɛ̃ɛ tɩ sʊʊr wʊ, “Baa lɛ fʊ bʊɔrɔ ɩka fʊ 'yɛr kʊ ma?” ");
INSERT INTO biv_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","A wʊ 'yɛr, “A Juu nɩbɛ guor taa na ban sʊɔr fʊ ka fʊn waan a Pɔɔl a 'yɛr tɔɔrbɔ sɛ̃ a bio ka a kaara fɩka ba bʊɔrɔ naa ɩka ba sʊʊr wʊ yele kɔ̃ɔ bɔ̃ɔ a par. ");
INSERT INTO biv_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ta sɔɔ ɛ, bojũu ba gar nɩbɛ lɩjaayi na var gu wʊ, ba pɔn 'yɔ̃ɔ a ba mãɛ ɩka ba kʊ̃ di bon ɛ, bɩɩ nyũ bon jaa ɛ, ka bala ba kʊ wʊ ɛ. Bala ben chɔɔr baar a pʊ̃pãanyã tɩ chɛlɛ a fʊ nɛɛ.” ");
INSERT INTO biv_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ka a nɩkpɛ̃ɛ bar a pɔlbile sɔr tɩ kpãa wʊ 'yɛr, “Taa ɩrɛ wa vɛ̃ ka nɩrɛ jaa bɔ̃ɔn ɩka fʊ wan a n sɛ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tɩ pãa bʊɔl a wʊ nɩbɛrɛ ayi na wʊ 'yɛr kʊ ba, “Yɩ chɔɔr sojasɩ kɔɔr ayi (200) na yɩ lɛ chɔɔr a sojasɩ lɩjaata nɩ pie (70) na bɔ̃ɔ wiisɩ dofʊ, nɩ sojasɩ kɔɔr ayi (200) mɩ na bɔ̃ɔ a pãɩ woor ala lɔbfʊ ka yɩ chen a Sisariya a tãsɔɔ nyãna. ");
INSERT INTO biv_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Yɩ bɔ a wii ãsʊɔ kʊ a Pɔɔl a wʊ do jãnɛ a yɩ chiin wʊ vɩla tɩ kʊ a paal nɩkpɛ̃ɛ Feliksɩ.” ");
INSERT INTO biv_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","A gãn wʊn sɛb 'lɔ nɩ nyã, ");
INSERT INTO biv_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Maa Kɩlaudiyus Lisiyasɩ lɛ sɛɛrɛ a gãn nyãna kʊrɔ a fʊ̃ʊ Feliksɩ a paal nɩkpɛ̃ɛ 'yɔ̃ɔ naa, n puor fʊ naa. ");
INSERT INTO biv_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","A daba nyãna lɛ a Juu nɩbɛ nyɔɔ na ba ta ɩka ba kʊ, tɩchɛ ɩn wa bɔ̃ɔn ɩka Worom nɩrɛ lɛ wʊ ɩ, n chiin naa a n sojasɩ tɩ faan wʊ. ");
INSERT INTO biv_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","N ta bʊɔrɔ na ɩka n bɔ̃ɔ a yele 'lɔ jũu ban ba bara wʊ ɛ, naa de wʊ chiin be a 'yɛr tɔɔrbɔ nɩbɛrɛ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Naa tɩ nyɛ ka ɩ a yele ɩ naa a ba nɛbinãa yele lɛ. Tɩchɛ saa lɛ nyɛ yele jaa wʊn maal na wʊ sɛɛn kũu bɩɩ die pɔ pɔɔfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Lɛ ban wa man kʊ ma ban guoro a daba nyã yele, ala lɛ so ka n vɛ̃ ka ba tara wʊ a fɔɔ a lɛ nɛ waan a fʊ sɛ̃. N mɩ 'yɛr kʊ a bala na tuoro wʊ a yele ɩka ba wa a fʊ sɛ̃ wa 'yɛr a fʊ mɩ kaa.” ");
INSERT INTO biv_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","A sojasɩ tun a lɛ a ba nɩkpɛ̃ɛ na 'yɛr na ba de a Pɔɔl a tãsɔɔ 'lɔ̃nɔ̃ jaa na ba tɩ tãn Antɩpatɩrsɩ tẽe pɔ. ");
INSERT INTO biv_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Wɛr na wa chaar, ba vɛ̃n ka a wiir dẽme tara a Pɔɔl chiine, tɩchɛ ka a gbɛɛ dẽme lɩɛb wa a sojasɩ yir. ");
INSERT INTO biv_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Lɛ ban tɩ ta a Sisariya tẽe pɔ ba den a gãn na ba kʊ a nɩkpɛ̃ɛ tɩ de a Pɔɔl mɩ 'yɔ̃ɔ a wʊ nũu pɔ. ");
INSERT INTO biv_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ka a paal nɩkpɛ̃ɛ kar a gãn tɩ na wʊ sʊʊr a Pɔɔl a tẽbuor wʊn yi, wʊn wa bɔ̃ɔn ɩka a Sɩlɩsɩya lɛ wʊ yi. ");
INSERT INTO biv_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Ka a nɩkpɛ̃ɛ 'yɛr, “A bala na tuo fʊ a yele wa ta ala lɛ ɩn wõ a fʊ 'yɛr.” Wʊ vɛ̃n ka ba tara a Pɔɔl kpɛ̃n be a yir kpɛ̃ɛ 'lɔ pɔ a Nãa Hɛrɔd na dɔ̃ɔ mɛ tɩ guro wʊ. ");
INSERT INTO biv_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","A ber anũu puor lɛ ka a Juu nɩbɛ bɔɔrlo nɩkpɛ̃ɛ Ananias suun chen be a Sisariya nɩ a nɩbɛrɛ bamɩne, ka a Tɛtulusɩ na ɩ a 'yɛr tɔɔrɔ pʊɔ ba a ba 'mataa chen na tɩ 'yɛr a Pɔɔl 'yɛr a nɩkpɛ̃ɛ niem. ");
INSERT INTO biv_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ban bʊɔl a Pɔɔl kpɛ̃n ka a Tɛtulusɩ na man a wʊ yele kʊ a Feliksɩ na wʊ 'yɛrɛ, “Sɩ din nʊ̃ɔ kor a fʊ jũu, ka a fʊ yɛ̃ lɩɛr yelvɩɛlsɩ kʊ a fʊ paal. ");
INSERT INTO biv_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Jie jaa nɩ sɔr jaa pɔ fʊ ɩn nɩkpɛ̃vɩla, a sɩ sɔɔ de fʊ nɩ nuur ayi nɩ pʊpɛl. ");
INSERT INTO biv_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Tɩchɛ n ba bʊɔrɔ ɩka n dam fʊ yɔɔ ɛ, yelbʊ̃'yen tɛɛ lɛ n bʊɔrɔ ɩka n sʊɔr jaa bãlãa ka fʊ di kãnyir kʊ sɩ. ");
INSERT INTO biv_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Sɩ nyɛn a daba nyãna ka wʊ ɩ gɔ̃bʊɔrɔ, a Juu nɩbɛ ba jaa lɛ wʊ ma tɔ a ba jur gbõtaa a wɛr wʊ jaa, na wʊ ɩ a nɩbɛ bala na turo a Najaretɩ nɩrɛ 'lɔ̃nɔ̃ nɩdiere. ");
INSERT INTO biv_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Na wʊ bʊɔrɔ a Nãaŋmɩn puorfʊ yir sɔ̃ɔ barfʊ, ala lɛ so ka sɩ nyɔɔ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Fʊ̃ʊ mãɛ fʊ sʊʊr wʊ kaa fʊn nyɛn bɔ̃ɔ ɩka a ala sɩn 'yɛrɛ dɔɔlɔ wʊ ɩn yelmãɛ.” ");
INSERT INTO biv_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ka a Juu nɩbɛ ba jaa na be be 'yɛr ɩka a lɛ a Tɛtulusɩ na 'yɛr ɩn yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","A paal nɩkpɛ̃ɛ kʊn a Pɔɔl sɔr a wʊ 'yɛr, ka a Pɔɔl 'yɛr, “N bɔ̃ɔn naa an ɩ yuom yɔɔ lɛ fʊ kaa a paal nyãna, a nʊ̃mɔ̃ ma naa ka n na 'yɛr a n 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Fʊ̃ʊ sʊʊr ban 'yɛr ɩka a ba gar ber pie nɩ ayi ɩn chen be a Jerusalɛm ɩka n tɩ puor Nãaŋmɩn ɛ. ");
INSERT INTO biv_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ba ãsʊɔ jaa ba nyɛ ma ka n chɩrɛ nɩ nɩrɛ jaa be a Nãaŋmɩn puorfʊ yir ɛ, bɩɩ dɔ̃ɔnɔ̃ nɩyɔɔ be a ba lɔ̃ɔfʊ jiir ɛ, bɩɩ a tẽe pɔ jie jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","A anyãna ban 'yɛrɛ 'yɔ̃ɔnɔ̃ ma ãsʊɔ jaa kʊ̃ tʊ̃ɔ wiil ma a yelmãɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Tɩchɛ n sɔɔ naa ɩka n puoro naa a Nãaŋmɩn 'lɔ a sɩ sãakpãmɩne na dɔ̃ɔ puoro naa lɛ turo a Sɔr 'lɔ ban bʊɔlɔ a sɔr yuo. N sɔɔn de a ala a jaa, na a sɔɔ lɛ a nɛɛ na sɔɔ nɩ a ala a jaa a Nãaŋmɩn 'yɛ'yɛrbɛ na dɔ̃ɔ sɛb. ");
INSERT INTO biv_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","N mɩ tara naa a tɩɛrtɔ bʊ̃'yen 'lɔ̃nɔ̃ a Nãaŋmɩn 'yɔ̃ɔ nɩtãa a ba kaar ɩka nɩsʊ̃n nɩ a putudẽme na ir ɩ vʊɛ. ");
INSERT INTO biv_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ala lɛ so ka n mʊɔrɔ sɔ̃ɔ jaa ɩka a n pʊtɩɛr wʊ chaar Nãaŋmɩn nɩ a nɩrɛ niem. ");
INSERT INTO biv_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“N yin kor, tɩ naa lɛ lɩɛb wa a Jerusalɛm nɩ libie ɩka n wa kʊ a nɔ̃n dẽme tɩ naa mɩ lo bɔɔr kʊ a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","N dɔ̃ɔ pɔl a n mãɛ baar a lɛ ban nyɛ ma a Nãaŋmɩn puorfʊ yir bɛchaar pɔ. Nɩyɔɔ ba dɔ̃ɔ pʊɔ ma ɛ, n mɩ ba dɔ̃ɔnɔ̃ damfʊ jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Tɩchɛ a Juu nɩbɛ bamɩne na yi a Asɩya paal pɔ wa, bala mɩ lɛ a ta sɛɛ ɩka ba be ka na ba 'yɛr a n 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bɩɩ a banyãna na be ka a ba wiil a yelnyɩnɛ ban nyɛ ɩn maal, a lɛ ɩn ara a 'yɛr tɔɔrbɔ niem. ");
INSERT INTO biv_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ala ba ɩ a 'yɛr bir bʊ̃'yen nyãna tɛɛ ɩn 'yɛr kpɛ̃ɔ jaa a lɛ ɩn ara a ba niem naa 'yɛr, ‘A kũn na ir ɩ vʊɛ, naa be ara a yɩ niem a yɩn tɔɔr a n 'yɛr a dɩna.’ ” ");
INSERT INTO biv_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","A Feliksɩ na wa pãa bɔ̃ɔn a Sɔr yele wʊ wɛl a nɩbɛ bar tɩ 'yɛr, “A Lisiyasɩ na ɩ a sojasɩ nɩkpɛ̃ɛ wa wa ala lɛ ɩn 'yɛr a fʊ 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Wʊ den a Pɔɔl kʊ a sojasɩ nɩkpɛ̃ɛ tɩ 'yɛr ɩka a wʊ ma kʊ wʊ sɔr tɩ sɔɔ ka a Pɔɔl barmɩne ma sʊ̃nɔ̃ wʊ nɩ a wʊ bʊ̃bʊɔrsɩ. ");
INSERT INTO biv_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","A maal ber aŋmɩnɛ jaa tɩchɛ ka a Feliksɩ tara a wʊ pɔɔ Durusila na ɩ a Juu nɩrɛ waan. Wʊ tʊ̃n ka ba waan a Pɔɔl a wʊ chɛlɛ a lɛ wʊn mana a lɛ fʊn na sɔɔ de a Yesu Kɩrɩsɩto. ");
INSERT INTO biv_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pɔɔl 'yɛr naa a lɛ nɛ wa pʊr yeltorsɩ yuor nɩ mãɛ nyɔɔfʊ nɩ lɛ a 'yɛr tɔɔrfʊ na waara. Ka a dãbãɛ kpɛ a Feliksɩ a wʊ 'yɛr, “Pʊ̃pãanyã a sɛɛn lɛ, chiine maa wa tara jaa ɩn tʊ̃n bʊɔl fʊ.” ");
INSERT INTO biv_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Wʊ tɩɛr man taa Pɔɔl na kʊ wʊn libie, na wʊ ma bʊɔlɔ a Pɔɔl jaa tɔ̃tɔ̃ ma 'yɛrɛ nɩ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Yuom ayi na wa po Pɔsɩyusɩ Festus den a Feliksɩ jie, tɩchɛ a Feliksɩ na bʊɔrɔ ɩka wʊ pɛl a Juu nɩbɛ pʊɔ jũu, wʊ bar a Pɔɔl a be a pɔɔfʊ die pɔ. ");
INSERT INTO biv_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus na de a wʊ tʊ̃mɔ̃ maal ber ata wʊ yin be a Sisariya chen a Jerusalɛm. ");
INSERT INTO biv_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Be lɛ a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a ba nɩdierbe man a 'yɛr ala ban tara nɩ, a Pɔɔl kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ba sʊɔr a Festus nɩbijɩɛ jaa ɩka a lɛ ban sʊɔrɔ wʊ a wʊ sɔɔ na wʊ vɛ̃ a ba tara a Pɔɔl waan be a Jerusalɛm an ɩ ba chɔɔr ũu gu na kʊ a Pɔɔl a be a sɔr pɔ. ");
INSERT INTO biv_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ka a Festus 'yɛr, “A Pɔɔl ben a be a Sisariya a maa mãɛ a kʊ̃ kor ɛ, tɩchɛ ka n chen a be. ");
INSERT INTO biv_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Yɩ vɛ̃ ka a yɩ nɩbɛrɛ bamɩne pʊɔ ma a sɩ 'mataa chen, ala ɩ wʊ maal yeldɛɛr a yɩ 'yɛr n kaa.” ");
INSERT INTO biv_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Wʊn wa maal a be ber aniin bɩɩ pie wʊ chen a Sisariya, wʊn tɩ gã ir wʊ jãnɛ naa a 'yɛr tɔɔrfʊ jie tɩ na wʊ 'yɛr ɩka ba waan a Pɔɔl. ");
INSERT INTO biv_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ban wa waan a Pɔɔl a Juu nɩbɛ bala na yi a Jerusalɛm wa ara na jilʊ̃ wʊ ŋmara jir kara dɔɔlɔ wʊ tɩchɛ ba maa tʊ̃ɔ wiil a par ɛ. ");
INSERT INTO biv_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","A Pɔɔl pãa 'yɛr, “Maa ba maal dɛɛr jaa ɛ, naa sɔ̃ɔ a Juu nɩbɛ nɛbinãa nɩ a Nãaŋmɩn puorfʊ yir ɛ, bɩɩ 'yɛr 'yɛrdɛɛr 'yɔ̃ɔ a Nãkpɛ̃ɛ Siisa ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus bʊɔrɔ naa ɩka wʊ pɛl a Juu nɩbɛ pʊɔ na wʊ sʊʊr a Pɔɔl, “Fʊ bʊɔrɔ naa ɩka fʊ do a Jerusalɛm ka a 'yɛr anyãna ban 'yɛr dɔɔl fʊ ka n tɩ tɔɔr a be bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","A Pɔɔl 'yɛr, “Pʊ̃pãanyã, n ben ara a Nãkpɛ̃ɛ Siisa 'yɛr tɔɔrfʊ jie a be an sɛɛ ɩka ba tɔɔr a n 'yɛr. N mɩ ba maal yeldɛɛr jaa a Juu nɩbɛ sɛ̃ ɛ, a lɛ a fʊ̃ʊ mãɛ na bɔ̃ɔn. ");
INSERT INTO biv_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Maa ta maal dɛɛr naa sɛɛn kũu n kʊ̃ naa tɔr ɩka n kpi ɛ. Tɩchɛ a 'yɛr anyãna a Juu nɩbɛ na 'yɛr dɔɔl ma na ba ɩ yelmãɛ ɛ, nɩrɛ jaa ba tara sɔr na fɩr ma kʊ ba ɛ. Siisa sɛ̃ lɛ ɩn chen ka wʊ tɩ tɔɔr a n 'yɛr.” ");
INSERT INTO biv_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Lɛ a Festus nɩ a wʊ nɩbɛrɛ na wa man taa baar wʊ 'yɛr kʊ a Pɔɔl, “Fʊ̃ʊ lɛ sʊɔr ɩka a Siisa sɛ̃ lɛ fʊn chen, be lɛ fʊn chen.” ");
INSERT INTO biv_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","A kor bãlãa ka a Nãa Agripa nɩ a wʊ yɛpɔɔ Bernisɩ wa be a Sisariya ɩka ba wa puor a Nɩkpɛ̃ɛ Festus. ");
INSERT INTO biv_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","An ɩ ban jɛ̃n a be kor jũu, Festus mana naa a Pɔɔl yele kʊrɔ a Nãa Agripa 'yɛrɛ, “Daba kɔ̃ɔ lɛ be a pɔɔfʊ die pɔ a Feliksɩ na pɔɔ. ");
INSERT INTO biv_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","A lɛ ɩn chen a Jerusalɛm, a Juu nɩbɛ bɔɔrlo nɩbɛrɛ nɩ a ba nɩdierbe den yelyɔɔ dɔɔl wʊ na ba sʊɔr ma ɩka n tɔɔr a wʊ 'yɛr ge wʊ. ");
INSERT INTO biv_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Ka n 'yɛr kʊ ba a Worom nɩbɛ maa tɔɔr nɩrɛ 'yɛr ala ɩ a nɩnyɩnɛ ban 'yɛr a 'yɛr dɔɔl ba wa ara a bala na tara nɩ wʊ a 'yɛr niem na wʊ 'yɛr a wʊ nɛɛ 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ala lɛ so ka ba pɔɔ ma a sɩ 'mataa wa a ka, n ba wa jɛ̃n a 'yɛr ɛ, a wɛr na wa chaar n jɛ̃ naa na tɔɔr a 'yɛr naa vɛ̃ ka ba waan a daba. ");
INSERT INTO biv_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","A bala na tara nɩ wʊ a 'yɛr na wa ir ara na 'yɛr, baa 'yɛr 'yɛr jaa na ɩ dɛɛr nɩtãa lɛ ɩn tɩɛr ban taa 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Tɩchɛ a ba 'yɛr tɩ ɩ naa a ba puorfʊ yele lɛ nɩ daba kɔ̃ɔ na di Yesu na kpi ka a Pɔɔl 'yɛr ɩka wʊ ir naa na wʊ ɩ vʊr. ");
INSERT INTO biv_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ka a yele nyã sɔb ma nɩbir, n ba bɔ̃ɔ ŋmɩnɛ ɩn na ɩ vɩɛr a yele nyã ɛ, ala lɛ so ka n sʊʊr wʊ ala ɩ wʊn bʊɔrɔ naa ɩka wʊ chen a Jerusalɛm ka ba tɩ tɔɔr a 'yɛr anyãna a be. ");
INSERT INTO biv_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pɔɔl 'lɔ bʊɔrɔ naa ɩka a Nãkpɛ̃ɛ Siisa wʊ tɔɔr a wʊ 'yɛr, n vɛ̃n a ba tara wʊ tɩ tãn a lɛ ɩn na bar sɔr ka ba tara wʊ chiin a Siisa sɛ̃.” ");
INSERT INTO biv_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ka a Nãa Agripa pãa 'yɛr kʊ a Festus, “Maa mãɛ naa bʊɔrɔ naa ɩka n wõ a daba mɩ kɔkɔr.” Ka a Festus 'yɛr, “Bio fʊn wõn a wʊ kɔkɔr.” ");
INSERT INTO biv_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","A wɛr na wa chaar, a Nãa Agripa nɩ a Bernisɩ wa naa ka a nɩbɛ de 'yɔ̃ɔfʊ kʊ ba ka ba tɩ kpɛ̃n be a dikpɛ̃ɛ 'lɔ pɔ ban ma lɔ̃ɔnɔ̃ nɩ a sojasɩ nɩbɛrɛ nɩ a tẽe nɩbɛrɛ. Ka a Festus vɛ̃ a sojasɩ tara a Pɔɔl waan. ");
INSERT INTO biv_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ka a Festus 'yɛr, “Nãa Agripa nɩ a yɩn bala jaa na be ka a sɩ sɛ̃, yɩ nyɛ a daba nyãna, a Juu nɩbɛ ba jaa 'yɛr a wʊ 'yɛr kʊ ma be a Jerusalɛm nɩ a ka a Sisariya tãna 'yɛrɛ ɩka a ba sɛɛ ka wʊ lɛ chɛnɛ go ɛ. ");
INSERT INTO biv_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","N mɩ ba nyɛ yele jaa wʊn ɩ ka a tara sɔr ka sɩn kʊ wʊ ɛ, tɩchɛ bojũu wʊ sʊɔr sɔr ɩka wʊ chen a Nãkpɛ̃ɛ Siisa sɛ̃, n mɩ na bar wʊn sɔr ka wʊ chen a Worom. ");
INSERT INTO biv_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Tɩchɛ n ba tara a wʊ yele ala na sɛɛ ka n na sɛb kʊ a Nãkpɛ̃ɛ ɛ. A lɛ jũu n waan wʊ naa a yɩ jaa niem nɩ a fʊ̃ʊ Nãa Agripa niem a fʊ mɩ jʊʊr a wʊ yele kaa, ka n bɔ̃ɔ a lɛ ɩn na sɛb. ");
INSERT INTO biv_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Bojũu, a ba sɛɛn ma ɛ, ka n na vɛ̃ ka ba tara nɩrɛ ban pɔɔ chiine naa ba wiil a yelnyɩnɛ wʊn maal ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Kaa Agripa pãa 'yɛr kʊ a Pɔɔl, “Fʊ tara na sɔr na 'yɛr a fʊ nɛɛ 'yɛr.” Pɔɔl tur naa a nũu tɩ piel mana a wʊ mãɛ yele, ");
INSERT INTO biv_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Nãa Agripa, a ɩ man bɔɔsʊ̃n ɩn ara a fʊ niem a dɩna naa na man a n yele ala a jaa a Juu nɩbɛ na 'yɛr dɔɔl ma. ");
INSERT INTO biv_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Yelmãɛ jaa lɛ, a fʊ̃ʊ mãɛ jaa bɔ̃ɔn naa a Juu nɩbɛ yelbinsɩ a jaa nɩ a ba nɛchɩrɛ, a lɛ jũu n sʊɔr fʊ naa ka fʊ di kãnyir chɛlɛ ma. ");
INSERT INTO biv_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“A Juu nɩbɛ ba jaa bɔ̃ɔn a lɛ ɩn be a bibile daar jaa, a maa paal pɔ nɩ a ka a Jerusalɛm mɩ. ");
INSERT INTO biv_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ba bɔ̃ɔ man kor na ban tʊ̃ɔ di a lɛ dãasɩɛ ala ɩ ba bʊɔrɔ naa. Ba bɔ̃ɔn ma naa ɩn turo yele jaa nɛ nɛ nɛ a sɩ puorfʊ pɔ, naa ɩ a Farasee nɩrɛ. ");
INSERT INTO biv_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","A pʊ̃pãanyã a lɛ a Nãaŋmɩn na dɔ̃ɔ tɩr a nɛɛ kʊ a sɩ sãakpãmɩne ka n tara a tɩɛr jũu lɛ so ka n 'yɛr be tɔɔrɔ a dɩna. ");
INSERT INTO biv_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","A nɛ tɩra anyãna jũu lɛ a sɩn bʊrɔ pie nɩ ayi ɩ a sɩ tɩɛrtɔ fʊ jie, ka a na wa ɩ a sɩ mʊ̃ɔ nɩbir puoro a Nãaŋmɩn mɔ̃tɔ̃ɔ nɩ tãsɔɔ. A fʊ̃ʊ nãa a tɩɛrtɔ nyãna jũu, a Juu nɩbɛ 'yɔ̃ɔnɔ̃ ma a 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Bo lɛ so ka yɩ tɩɛr ɩka Nãaŋmɩn kʊ̃ tʊ̃ɔ sãɩ kũu ɛ? ");
INSERT INTO biv_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“A maa mɩ dɔ̃ɔ ŋme nyãa naa ɩka ɩn ɩ naa lɛ jaa ɩn na tʊ̃ɔ naa sɔ̃ɔ a Yesu na yi a Najaretɩ yuor. ");
INSERT INTO biv_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nɩtɔ̃ lɛ n ɩ be a Jerusalɛm. A Juu nɩbɛ bɔɔrlo nɩbɛrɛ kʊ man sɔr ka n nyɔɔr a Nãaŋmɩn puorbo yɔɔ naa pɔɔ, bala wa kʊrɔ ba n ma sɔɔ naa. ");
INSERT INTO biv_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Sɔ̃ɔ yɔɔ jaa, n ma chen a be a ba lɔ̃ɔfʊ jiir naa tɩ ge ge ba, naa ma fɩrɛ ba 'yɛr 'yɛr dɛbɛ tɩchɛ a maa tʊ̃ɔ ɩ a lɛ ɛ. A lɛ a ba yele na dire ma a suur n ma chen a wɛr yuo pɔ tɩ ge ba a be. ");
INSERT INTO biv_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ala jũu lɛ a bɔɔrlo nɩbɛrɛ dɔ̃ɔ kʊ ma a sɔr ka n chiine a Damaskus. ");
INSERT INTO biv_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mɔ̃tɔ̃tuo sɔ̃ɔ lɛ fʊ̃ʊ nãa, a lɛ ɩn be a sɔr pɔ, n nyɛn chãa na yi saaju chaar mɔ̃tɔ̃ɔ na wʊ jilʊ̃ ma nɩ a bala ɩn lɔ̃ɔ chiine. ");
INSERT INTO biv_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Sɩ jaa lon tẽe tɩchɛ ka n wõ nɩrɛ na sʊrɔ ma nɩ a Heburu kɔkɔr, ‘Sɔɔl, Sɔɔl bo lɛ fʊ gere ma a lɛ? Fʊ wõn tuo fʊn tɛb a dakʊra.’ ");
INSERT INTO biv_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Be lɛ n pãa sʊʊr, ‘Fʊ̃ʊ nɩ ana, Soro?’ A wʊ 'yɛr, ‘Maa lɛ a Yesu 'lɔ fʊn gere. ");
INSERT INTO biv_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Pʊ̃pãanyã ir ara, n yi fʊ naa, naa ir fʊ a fʊn ɩ a n tʊ̃tʊ̃nɔ̃ na fʊ mʊɔlɔ a ala fʊn nyɛ a dɩna nɩ a ala ɩn na wiil fʊ. ");
INSERT INTO biv_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ɩn faa fʊ naa a fʊ̃ʊ mãɛ nɩbɛ nuur pɔ, nɩ a bala na ba ɩ a Juu nɩbɛ nuur pɔ. Maa lɛ tʊ̃nɔ̃ fʊ, ");
INSERT INTO biv_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","tɩ yuo a ba nɩbie na fʊ tɔɔ ba yin a libe pɔ, waan a chãa pɔ, na fʊ yin a Satan kpɛ̃ɔ pɔ, waan a Nãaŋmɩn sɛ̃, a wʊ vɛ̃ a ba yelbier kʊ ba ka ba mɩ nyɛ jie nɩ a bala na sɔɔ de ma, ka n faa ba.’ ");
INSERT INTO biv_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“A lɛ jũu, Nãa Agripa, n ba tɔr a nyɛfʊ nyã na yi a saaju ɛ. ");
INSERT INTO biv_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","N den nie man kʊ a Damaskus dẽme, nɩ a Jerusalɛm dẽme, nɩ a Judiya wɛr wʊ jaa, nɩ a bala na ba ɩ a Juu nɩbɛ mɩ. N mʊɔl kʊ ba ɩka ba lɩɛb a ba tɩɛr, na ba lɩɛb wa Nãaŋmɩn sɛ̃, na ba vɛ̃ ka ba tʊ̃mɔ̃ wiil ɩka ba lɩɛb a ba tɩɛr. ");
INSERT INTO biv_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ala lɛ so a Juu nɩbɛ nyɔɔ ma a ba puorfʊ yir bɛchaar pɔ bʊɔrɔ ɩka ba kʊ ma. ");
INSERT INTO biv_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Tɩchɛ Nãaŋmɩn lɛ sʊ̃ʊ ma wa tãn a dɩna, ka n be ara na man kʊ nɩrɛ jaa. N ba 'yɛr 'yɛr jaa tɩ põn a lɛ a Nãaŋmɩn 'yɛ'yɛrbɛ nɩ a Mosesɩ na 'yɛr ɩka an ɩ naa ɛ, ");
INSERT INTO biv_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ɩka a Nɩ-iraa na din dɔɔyɛ na wʊ mɩ ɩ nɩrɛ na de nie ir a kũu pɔ, na wʊ man a chãa 'yɛr kʊ a wʊ nɩbɛ nɩ a bala na ba ɩ a Juu nɩbɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Kana lɛ a Pɔɔl ta ka a Festus kpɛ tãn wʊ tɩ 'yɛr, “Pɔɔl a tɩɛr bɔr fʊ naa, a jãn yɔɔ vɛ̃n ka fʊ gele.” ");
INSERT INTO biv_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ka a Pɔɔl 'yɛr, “Nɩkpɛ̃ɛ Festus n ba gele ɛ, ala ɩn 'yɛrɛ ɩn yelmãɛ nɩ yɛ̃ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","A nãa bɔ̃ɔn a yele anyãna ala lɛ so ka n lɔb yãan bar tɩ 'yɛrɛ nɩ wʊ. N sɔɔ naa ɩka a yele anyãna ba sɔɔl wʊ ɛ, bojũu a yele nyã ba ɩ libe pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Nãa Agripa, fʊ sɔɔn a Nãaŋmɩn 'yɛ'yɛrbɛ bɩɩ? N bɔ̃ɔn naa ɩka fʊ sɔɔ naa.” ");
INSERT INTO biv_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ka a Nãa Agripa pãa sʊʊr a Pɔɔl, “Fʊ tɩɛr man tãa a dɩna tɛɛ lɛ fʊn lɩɛb ma ka n ɩ a Kɩrɩsɩto turo bɩɩ?” ");
INSERT INTO biv_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","A Pɔɔl 'yɛr, “Ka dɩna tɛɛ lɛ bɩɩ daar kɔ̃ɔ lɛ yo, n sʊɔrɔ naa Nãaŋmɩn ɩka a ta ɩ a fʊ̃ʊ tɛɛ ɛ, tɩ nɩrɛ jaa na chɛlɛ a 'yɛr nyãna a dɩna ka yɩ kaara a n kaar tɩ na ba taa 'yɔ̃ɔnɔ̃ yɩ a bɔ̃jɔrsɩ anyãna ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ka a nãa vaa ir nɩ a wʊ nɩbɛrɛ nɩ a Bernisɩ lɔ̃ɔn a bala wʊn 'mataa jãnɛ nɩ. ");
INSERT INTO biv_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ba yin a die pɔ, pãa 'yɛrɛ 'yɛr kʊrɔ taa na ba 'yɛrɛ, “A daba nyãna ba maal yele jaa na sɛɛn kũu bɩɩ pɔɔfʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ka a Agripa 'yɛr kʊ a Festus, “Fʊn taa tʊ̃ɔ bar a daba nyãna ala ɩ waa ta sʊɔr sɔr ɩka wʊn chen a Nãkpɛ̃ɛ Siisa sɛ̃ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","An wa ta ɩka sɩn chen a Itali, ba den a Pɔɔl nɩ a bamɩne ban pɔɔ kʊ a sojasɩ nɩkpɛ̃ɛ ban bʊɔlɔ Julius, wʊ ɩ naa a nãkpɛ̃ɛ soja kpɛ̃ɛ ãsʊɔ. ");
INSERT INTO biv_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Sɩ kpɛ̃n a gboro kpɛ̃ɛ na yi a Adɩramatiyum ka wʊ ir an ɩ Asɩya kõkoor lɛ wʊn lana. Aristakus na ɩ a Masedonɩya paal nɩrɛ na wʊ yi a Tɛsalonika pʊɔ sɩ naa. ");
INSERT INTO biv_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","A wɛr na wa chaar, sɩ tãn a Sidon tẽe pɔ, ka a Julius maal a Pɔɔl vɩla na wʊ bar wʊ sɔr ka wʊ chen a wʊ barmɩne sɛ̃ ka ba tɩ sʊ̃nɔ̃ wʊ. ");
INSERT INTO biv_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Be lɛ sɩ lɛ yin a gboro lana a Sipurusɩ bojũu a sɛsɛbɛ furo na tuoro sɩ. ");
INSERT INTO biv_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","A lɛ sɩn wa gɔ̃ɔ a man sãlsɔɔ Sɩlɩsɩya nɩ a Pamfiliya kõkoor lɛ sɩ wa ara nɩ a Mira na be a Lisiya wɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Be lɛ a soja nɩkpɛ̃ɛ nyɛ a Aleksandiriya gboro kpɛ̃ɛ na chiine a Itali ka wʊ wɛl sɩ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","A ber waa naa sɩn maal a sɔr pɔ, jaa vɛ̃ nɛ nɛ nɛ lɛ sɩ chiine ka a wõ sɩ tɩ sɩ tɩ ta a Sɩnidusɩ tẽe pɔ. Lɛ a sɛsɛbɛ na ba sɔɔrɔ a sɩ chiine a dẽdẽe ɛ, a gboro tun sɩ naa a Kɩrete a Salmone tẽe puor. ");
INSERT INTO biv_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","A man kõkoor lɛ sɩ lana ka a wõ sɩ tɩ tãn a jie ban bʊɔlɔ a Gboro Juvɩla Ara A Jie na gbʊr a Lasea tẽe. ");
INSERT INTO biv_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Sɩ sɔ̃ɔn sɔ̃ɔ yɔɔ a sɔr pɔ a sɛsɛbɛ na furo jũu, ka a gboro chenfʊ mɩ kʊrɔ dãbãɛ bojũu Kɔ̃ Galfʊ sɔ̃ɔ 'lɔ mɩ po naa, ka a Pɔɔl kpãana ba 'yɛrɛ, ");
INSERT INTO biv_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Nɩbɛ, n kãan nyɛ ka a dãbãɛ be a sɩ chenfʊ pɔ, yelyɔɔ na sɔ̃ɔ naa, a gboro tuor nɩ a sɩn mãɛ mɩ.” ");
INSERT INTO biv_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Tɩchɛ a sojasɩ nɩkpɛ̃ɛ ba chɛlɛ a lɛ a Pɔɔl na 'yɛrɛ ɛ, tɩ sɔɔ a lɛ a gboro mɔ̃nɔ̃ nɩ lɛ a gboro sʊɔ na 'yɛr. ");
INSERT INTO biv_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","A gboro ara a jie ba sɛɛn ban na ara a be a ɔɔr sɔ̃ɔ ɛ, a ba yɔɔ jaa 'yɛr naa ɩka ba po chiine, tɩɛrɛ ɩka ban tãn a Fonɩksɩ na ba ara a be. A Kɩrete gboro ara a jie lɛ na tor a mɔ̃tɔ̃ɔ purfʊ jie guba nɩ a nũsʊ̃ɔ jie. ");
INSERT INTO biv_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Lɛ a sɛsɛbaalʊ̃ʊ na wa furo yire a guba jie, ba tɩɛr ɩka ba nyɛn a lɛ ban bʊɔrɔ, ba for a kur nɛbie bara tɩ lana nɩ a gboro a Kɩrete gogoro. ");
INSERT INTO biv_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","An wa kor bãlãa, ka a sɛsɛbɛ kpɛ̃ɔ 'lɔ ban bʊɔlɔ a mɔ̃tɔ̃ɔ purfʊ jie guba sɛsɛbɛ fun yi a be wa. ");
INSERT INTO biv_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","A sɛsɛbɛ tʊ̃ɔn a gboro a waa lɛ tʊ̃ɔnɔ̃ chiine a niem ɛ, ka a sɛsɛbɛ pãa tara sɩ chiine. ");
INSERT INTO biv_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","A lɛ sɩn wa pã a dõdolbile ãsʊɔ ban bʊɔlɔ Kawuda, a ɩn tuo kʊ sɩ ka sɩn 'mɔɔ a gborbile. ");
INSERT INTO biv_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Lɛ a nɩbɛ na wa 'mɔɔ a gborbile ka wʊ do, ba den miir lũ gbɛb a gborkpɛ̃ɛ. Sɩ joro na dãbãɛ ɩka sɩ taa ɩrɛ wa tɩ mʊr a Sirtisɩ bire pɔ ɛ, ka ba bar a kur nɛbie ka a gboro pãa tɔɔrɔ. ");
INSERT INTO biv_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","A sɛsɛkpɛ̃ɛ nyã mɔ̃n sɩn jaa ka wɛr wa chaar ka ba piel wɛlɛ a tuor lɔɔrɔ 'yɔ̃ɔnɔ̃ a kʊ̃ɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","A ber ata daar a gboro dẽme mãɛ foro naa a gboro bomo nɩ a ba mãɛ nuur lɔɔrɔ 'yɔ̃ɔnɔ̃ a kʊ̃ɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Lɛ a mɔ̃tɔ̃ɔ nɩ a ŋmarbie na ba lɛ wa nyɩr ɛ, a ber waa naa tɩchɛ ka a sɛkpɛ̃ɛ chɛnɛ ire ka a sɩ chãɛfʊ tɩɛrtɔ jie baar. ");
INSERT INTO biv_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","A ber wa po naa tɩ baa di bon jaa ɛ, ka a Pɔɔl ir ara a ba sãlsɔɔ tɩ 'yɛr kʊ ba, “Nɩbɛ, yɩn ta sɔɔ tu a n nɛɛ ka sɩ ta chɛnɛ be a be Kɩrete a wõm nyãna kʊ̃ naa pɔɔ sɩ ɛ, ka a bonsɩ be wɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Tɩchɛ n sʊɔrɔ yɩ naa, yɩ nyɔɔ nyãa bojũu ãsʊɔ jaa kʊ̃ bɔr ɛ, a gboro tɛɛ lɛ na wɛ. ");
INSERT INTO biv_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Jãa tãsɔɔ a Nãaŋmɩn nyã na so ka n tʊ̃nɔ̃ a wʊ tʊ̃mɔ̃ tʊ̃n a wʊ malaka ka wʊ wa ara a n lõboor, ");
INSERT INTO biv_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","na wʊ 'yɛr kʊ ma, ‘Pɔɔl taa joro dãbãɛ ɛ, fʊn nyɛn a Nãkpɛ̃ɛ Siisa nɩ nɩbir ka wʊ tɔɔr a fʊ 'yɛr. Ka a bala jaa fʊn lɔ̃ɔ chiin Nãaŋmɩn den a ba nyɛvʊr 'yɔ̃ɔ a fʊ nũu pɔ.’ ");
INSERT INTO biv_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","A lɛ jũu yɩ nyɔɔ nyãa nɩbɛ, n sɔɔn de Nãaŋmɩn ɩka wʊn ɩ naa a lɛ wʊn 'yɛr kʊ ma. ");
INSERT INTO biv_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Tɩchɛ sɩn don dõdol kɔ̃ɔ ju ara.” ");
INSERT INTO biv_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","A ber pie nɩ anaar daar, a sɛsɛbɛ chɛnɛ na mʊɔrɔ nɩ sɩ be a Adiriya man yal pɔ, a tãsɔɔ bãɩn ka a bala na kaara a gboro tɩɛr man tãa ba gbʊrɔ na gogoro. ");
INSERT INTO biv_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ba den a bon 'lɔ ban ma mana nɩ a kʊ̃ɔ, man ka a man yulʊ̃fʊ ɩ gbɛɛ kɔbaa dɔɔl lɩjɛr (120). Ban wa chen bãlãa ba lɛ man kaa ka a yulʊ̃fʊ lɛ ɩ gbɛɛ lɩjaanaar nɩ pie (90). ");
INSERT INTO biv_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ba joro na dãbãɛ ɩka a gboro wʊ taa tɔ̃n sɩ kʊsɩr ɛ, a ba wɛl a nɛbie ala anaar na ma nyɔɔ a gboro lɔb 'yɔ̃ɔ a man pɔ tɩ pãa sʊɔrɔ ɩka wɛr wʊ chaar fɔɔ. ");
INSERT INTO biv_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ka a gboro dẽme bʊɔrɔ sɔr ban na yi a gboro pɔ jo na ba for a gborbile bar ka wʊ suu a man pɔ tɩ maala fɩka a nɛbinyɔɔrsɩ ala lɛ ba foro bara a niem. ");
INSERT INTO biv_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","A Pɔɔl pãa 'yɛr kʊ a sojasɩ nɩkpɛ̃ɛ nɩ a sojasɩ, “Yɩn baa vɛ̃ ka a gboro dẽme banyãna be a gboro pɔ ɛ, sɩ wɛ naa a lɛ nɛ.” ");
INSERT INTO biv_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ka a sojasɩ ŋmaa a miir 'lɔ na nyɔɔ a gborbile taa lɛ ka wʊ lo. ");
INSERT INTO biv_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Lɛ a wɛr na ɩrɛ a wa lalala, Pɔɔl sʊɔr ba jaa na wʊ 'yɛr kʊ ba, “Yɩ di a bʊ̃diir bojũu ber pie nɩ anaar nɩ nyã yɩn jɛ̃n baal na yaa di bon jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Pʊ̃pãanyã, n sʊɔrɔ yɩ naa ɩka yɩ di a bʊ̃diir na yɩ tara kpɛ̃ɔ, a yɩ ãsʊɔ jaa jukɔɔlbir kʊ̃ vʊ̃ɔ a wʊ ju pɔ ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","A anyãna lɛ wʊ 'yɛr baar tɩ na wʊ de a paanʊ̃ɔ amɩne puor Nãaŋmɩn yãan a ba jaa niem, tɩ pãa ŋmaa na wʊ ɔɔrɔ. ");
INSERT INTO biv_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ka a 'yɔ̃ɔ ba jaa ãkpɛ̃ɛ ka a ba mãɛ di a bʊ̃diir amɩne. ");
INSERT INTO biv_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","A sɩn bala na be a gboro pɔ ɩ naa nɩbɛ kɔɔr ayi dɔɔl lɩjaata nɩ pie nɩ ayʊɔb (276). ");
INSERT INTO biv_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Lɛ ban wa di tɩɩ baar, ba wɛl a bʊ̃diir ala na chɛ lɔb 'yɔ̃ɔ a man pɔ tɩchɛ ka a gboro ɩ dẽfere. ");
INSERT INTO biv_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Lɛ a wɛr na wa chaar, baa bɔ̃ɔ a jie ban be ɛ, tɩchɛ na ba nyɛ a jie na gɔr ka a bire be be a ba bʊɔrɔ ɩka ala ɩ ba tʊ̃ɔ naa a ba tɩ ara. ");
INSERT INTO biv_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ba ŋman a mibe ala na nyɔɔr a nɛbinyɔɔrsɩ ala bar, na ba mɩ lɛ for a vuulsɩ ala na ma dɛnɛ a gboro tɩ pãa yɛr a fɔbaa bar a gboro niem ka a sɛsɛbɛ pãa tɔɔrɔ ba chiine a bire pɔ. ");
INSERT INTO biv_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Tɩchɛ ka a gboro tɩ tɔ a bire na duo a jie ãsʊɔ, ka a gboro niem mʊr wʊ jaa na wʊ kʊ̃ tʊ̃ɔ chen ɛ. Ka a kɔ̃sɛbɛ ŋmiere a gboro pãa wɛlɛ. ");
INSERT INTO biv_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ka a sojasɩ ɩ nɛbʊ̃'yen bʊɔrɔ ɩka ba kʊ a bala ban pɔɔ ka a ãsʊɔ jaa taa dũu yi jo ɛ. ");
INSERT INTO biv_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Tɩchɛ a sojasɩ nɩkpɛ̃ɛ na bʊɔrɔ ɩka wʊ faa a Pɔɔl jũu, waa sɔɔ ɩka ba ɩ a lɛ ɛ. Wʊ 'yɔ̃ɔ naa a bala na bɔ̃ɔ a dũufʊ ka ba ɔɔ lo a kʊ̃ɔ pɔ de nie dũu do a gogoro ju. ");
INSERT INTO biv_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ka a bala na chɛ mɩ nyɔɔr a gboro daar bɩɩ a gboro da'mɛlɛ ala, nɩtɔ̃nɔ̃ lɛ ba ɩ ka ba ãsʊɔ tɩ jaa do a gogoro ju ka yele ba tara ba ɛ. ");
INSERT INTO biv_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Sɩ jaa na wa do baar, ba 'yɛr ɩka a dõdol yuor din Malta. ");
INSERT INTO biv_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","A nɩbɛ bala na be a be maal sɩn vɩla, ba gbɔɔn bũu na ba bʊɔl sɩ a sɩ tɩ uoro, bojũu saa lɛ waara ka ɔɔr kʊrɔ. ");
INSERT INTO biv_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ka a Pɔɔl mɩ vaar delsɩ wa 'yɔ̃ɔnɔ̃ a bũu pɔ, ka a dʊ̃pãn na be a delsɩ pɔ, a bũu tʊl kpɛ ka wʊ yi dʊ̃ a Pɔɔl nũu mar taalɛ. ");
INSERT INTO biv_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Lɛ a gogoro dẽme bala na wa nyɛ a lɛ a waa na mar a Pɔɔl nũu pɔ jɔ̃jɔlɔ, ka ba 'yɛrɛ kʊrɔ taa, “A daba nyãna na ɩn nɩkʊrɔ, a man na ba di wʊ gba ɛ, tɩchɛ yeltorsɩ kʊ̃ sɔɔ ka wʊ be be ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Tɩchɛ ka a Pɔɔl mɩr a waa 'yɔ̃ɔ a bũu pɔ tɩ yele jaa ba tara wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","A nɩbɛ tɩɛr man tãa a nũu na mɔr wʊ naa bɩɩ a wʊ vaa lo kpi. Tɩchɛ ban chɛl lɛ̃ɛɛ wa faa ka a yele jaa ba ɩrɛ ɛ, ba lɩɛb a ba tɩɛr 'yɛrɛ kʊrɔ taa, “Ŋmɩn lɛ wʊ ɩ.” ");
INSERT INTO biv_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","A dõdol 'lɔ nɩkpɛ̃ɛ ban bʊɔlɔ Pubilusɩ tara na jie na gbʊr a be a wʊ de sɩ sãan, na wʊ kʊ sɩ bʊ̃diir ber ata. ");
INSERT INTO biv_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","A Pubilusɩ sãa bɩɛrɛ na gã, ãgãn tʊl nɩ masʊmɔ̃ lɛ wʊ nyɩɛrɛ. Pɔɔl kpɛ̃n tɩ nyɛ wʊ, wʊn wa sʊɔr Nãaŋmɩn baar wʊ dɔɔl wʊ naa nũu sãa wʊ. ");
INSERT INTO biv_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Lɛ a anyãna na wa ɩ, baalsɩ bala jaa na be a jie 'lɔ mɩ wa naa ka Pɔɔl sãa ba jaa baalsɩ. ");
INSERT INTO biv_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ba den 'yɔ̃ɔfʊ kʊ sɩ sɔɩ jaa pɔ, a lɛ sɩn wa chɔɔr na yi, ba kʊ sɩn bon jaa sɩn na bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Sɩ maal a be ŋmɛrsɩ ata tɩ na sɩ lɛ kpɛ a gboro ãsʊɔ na ara a be a sãɛ. A gboro yin Aleksandiriya na wʊ tara ŋmɩn yɩbɛ Kasɩtor nɩ Poluksɩ. ");
INSERT INTO biv_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sɩ tɩ ara naa Sɩrakusɩ maal ber ata a be. ");
INSERT INTO biv_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Be lɛ a gboro yin sɩ tãn a be a Wuregiyum. Wɛr na wa chaar ka a ɩ a guba jie sɛsɛbɛ furo naa, a ber ayi daar ka sɩ ta a be Puteyoli na sɩ suu a be. ");
INSERT INTO biv_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Be lɛ sɩ pɔɔ a Nãaŋmɩn puorbo bamɩne ka ba bʊɔl sɩ ka sɩ tɩ maal daa gbul a ba sɛ̃. Lɛ lɛ a ɩ tɩ sɩ pãa wa ta a Worom. ");
INSERT INTO biv_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","A Nãaŋmɩn puorbo na be a Worom na wa wõ ɩka sɩ waara naa, ba yin tuor sɩ tɩ ta Apiyusɩ Daa pɔ na ba pɔɔ sɩ a Sãanba Kpɛfʊ Jiir Ata. A lɛ a Pɔɔl na wa nyɛ a nɩbɛ banyãna wʊ puor Nãaŋmɩn yãan ka a 'yɔ̃ɔ wʊ ãkpɛ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Lɛ sɩn wa ta a Worom, ba sɔɔ naa ka a Pɔɔl kpɩɛrɛ a wʊ yõ tɩchɛ ka a soja kaara wʊ. ");
INSERT INTO biv_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pɔɔl na wa maal ber ata, wʊ bʊɔl naa a Juu nɩbɛ nɩdierbe lɔ̃ɔ taa. Lɛ ban wa duo ka wʊ 'yɛr kʊ ba, “N yɛɛr, n gba na ba maal yele jaa bɔr a sɩ nɩbɛ sɛ̃ ɛ, bɩɩ 'mab a sɩ sãakpãmɩne yel-ɩrsɩ ɛ, tɩ ba nyɔɔ ma naa be a Jerusalɛm na ba kʊ a Worom nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ba chɛ̃pɛ̃n a yele faa na ba ta bʊɔrɔ ɩka ba bar ma bojũu n ba maal yele jaa na sɛɛn kũu ɛ. ");
INSERT INTO biv_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Tɩchɛ ka a Juu nɩbɛ na ba sɔɔ ɛ, ka n faa tɩ sʊɔr sɔr ka ba chiin ma a Nãkpɛ̃ɛ Siisa sɛ̃. A ba ɩ n tara na yele kɔ̃ɔ na de dɔɔl a n nɩbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","A lɛ jũu lɛ so ka n bʊɔrɔ ɩka n nyɛ yɩ naa 'yɛr yɩ. Bojũu a Isɩral nɩbɛ tɩɛrtɔfʊ jie jũu lɛ ba gbar ma nɩ a bɔ̃jɔrsɩ anyãna.” ");
INSERT INTO biv_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ka ba 'yɛr, “Saa nyɛ gãn jaa yi a Judiya dẽme sɛ̃ ɛ, ka a sɩ yɛɛr bala mɩ na yi a be wa ba 'yɛr a fʊ 'yɛrdɛɛr jaa kʊ sɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Tɩchɛ sɩn bʊɔrɔ naa ɩka sɩ bɔ̃ɔ a lɛ fʊn nyɔɔ, bojũu sɩ bɔ̃ɔn naa ɩka jie jaa nɩbɛ 'laar naa a yele nyãna.” ");
INSERT INTO biv_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ba 'yɔ̃ɔn bɩbir ban lɛ wa a Pɔɔl sɛ̃, a bɩbir na wa vɩɛ ba wan yɔɔ jaa a be wʊn kpɩɛrɛ. An yi a bibio tɩ tãn a jãanʊɔr na wʊ mana a Nãaŋmɩn nãalʊ̃ʊ kʊrɔ ba, na wʊ de a Mosesɩ nɛɛ nɩ lɛ a Nãaŋmɩn 'yɛ'yɛrbɛ na sɛb bʊɔrɔ ɩka wʊ lɩɛb a ba tɩɛr ka ba sɔɔ a Yesu. ");
INSERT INTO biv_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bamɩne lɩɛb ba tɩɛr a lɛ wʊn 'yɛr, tɩchɛ ka a bamɩne ba sɔɔ de ɛ. ");
INSERT INTO biv_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ba chɩrɛ nɩ taa na ba piel yire lɛ a Pɔɔl na wa 'yɛr a wʊ 'yɛr baaraa na wʊ 'yɛr, “A Nãaŋmɩn Sɩɛ 'yɛr yelmãɛ kʊ a yɩ sãakpãmɩne a lɛ wʊn de a wʊ 'yɛ'yɛrɛ Isaiya nɛɛ ");
INSERT INTO biv_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","'yɛr, ‘Chen a nɩbɛ banyãna sɛ̃ tɩ 'yɛr kʊ ba, “Yɩn wõn lɛ̃ɛɛ tɩ yɩ kʊ̃ wa bɔ̃ɔ a par ɛ, yɩn fur nɩbir 'yɔ̃ɔ tɩ yɩ kʊ wa nyɛ bon jaa ɛ.” ");
INSERT INTO biv_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Bojũu a nɩbɛ banyãna nyãn kpɛ̃mɛ naa, baa wõnõ ɛ, ba ma ũun a ba nɩbie, ka lɛ ba lɛ ɛ, ban taa nyɛn naa ba nɩbie na ba wõn a ba tobo bɔ̃ɔ a par na ba lɩɛb wa a n sɛ̃ ka n sãa ba.’ ");
INSERT INTO biv_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","A lɛ jũu, n bʊɔrɔ naa ɩka yɩ bɔ̃ɔ ɩka a Nãaŋmɩn den a wʊ faafʊ 'yɛr tɩ kʊ a bala na ba ɩ a Juu nɩbɛ ɛ na chɛlɛ naa.” ");
INSERT INTO biv_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔɔl yab a yir 'lɔ pɔ wʊn kpɩɛrɛ yuom ayi, tɩ ma de nɩrɛ jaa na ma wa a wʊ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Yele jaa ba ŋmaa wʊ sɔr ɛ, ka wʊ 'lara na wʊ mʊɔlɔ a Nãaŋmɩn nãalʊ̃ʊ 'yɛr na wʊ wile ba nɩ a sɩ Soro Yesu Kɩrɩsɩto 'yɛr.");
INSERT INTO biv_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Maa Pɔɔl na ɩ a Yesu Kɩrɩsɩto gbãgbaa, Nãaŋmɩn na kaa ir bʊɔl ka n ɩ a wʊ nɩtʊ̃nãa naa ɩ a wʊ 'yɛr nʊ̃ɔ 'yɛrɛ, lɛ sɛɛrɛ kʊrɔ a yɩn na be a Worom. ");
INSERT INTO biv_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","A 'yɛr nʊ̃ɔ nyã wʊn dɔ̃ɔ tɩr nɛɛ a kõr jaa tu a wʊ 'yɛ'yɛrbɛ sɛ̃ ka ba sɛb 'yɔ̃ɔ a Nãaŋmɩn gãn pɔ, ");
INSERT INTO biv_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","na ɩ a wʊ Bie 'yɛr, ban dɔɔ ka wʊ ɩ a Nãa David bal nɩrɛ. ");
INSERT INTO biv_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","A tu naa a Nãaŋmɩn Sɩɛ pɔ wiil kpɛ̃ɔ ɩka a Nãaŋmɩn Bie lɛ, na wʊ ir yi a kũn pɔ ɩ vʊr, 'lɔ lɛ ɩ a Yesu Kɩrɩsɩto na ɩ a sɩ Soro. ");
INSERT INTO biv_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","A tun a wʊ 'yɔ̃ɔ nɩ a wʊ yuor jũu, sɩ nyɛn wãɛfʊ nɩ a nɩtʊ̃nsɩ tʊ̃mɔ̃ na sɩn bʊɔl nɩrɛ jaa, ka ba wa wõnõ a wʊ toor nɩ sɔɔfʊ. ");
INSERT INTO biv_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Yɩn mɩ pʊɔn a bala a Nãaŋmɩn na bʊɔl ka yɩ ɩ a Yesu Kɩrɩsɩto sofʊ. ");
INSERT INTO biv_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","N sɛɛrɛ na kʊrɔ a yɩn bala jaa na be a Worom a Nãaŋmɩn na nʊ̃, na wʊ bʊɔl yɩ a yɩ ɩ a wʊ nɩbɛ. Wãɛfʊ nɩ nyã'maar na yi a sɩ Sãa Nãaŋmɩn nɩ a sɩ Soro Yesu Kɩrɩsɩto jie a be a yɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","N den nie puor a maa Nãaŋmɩn yãan a yɩ jaa jũu tu a Yesu Kɩrɩsɩto 'yɔ̃ɔ, bojũu a yɩ sɔɔfʊ ŋmen yaar a wɛr wʊ jaa. ");
INSERT INTO biv_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","A Nãaŋmɩn nyã ɩn tʊ̃nɔ̃ kʊrɔ nɩ a n nyãa wʊ jaa, naa mʊɔlɔ a 'yɛr nʊ̃ɔ nyã na ɩ a wʊ Bie 'yɛr, di man dãasɩɛ lɛ ɩn ma tɩɛrɛ a yɩ yele. ");
INSERT INTO biv_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","N ma sʊɔrɔ naa Nãaŋmɩn ba gala ɛ, naa sʊɔrɔ ɩka a wʊ bɔfʊ a ɩ, ka wʊ yuo sɔr a pʊ̃pãanyã kʊ ma ka n wa a yɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","N bʊɔrɔ naa yɩ nyɛfʊ naa na tʊ̃ɔ wiil yɩ a Nãaŋmɩn Sɩɛ kʊfʊ amɩne ka a 'yɔ̃ɔ yɩ ãkpɛ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Lɛ lɛ, a yɩn nɩ maa na pãa nʊ̃ɔ kpɛ̃mɛ a sɩ sɔɔfʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","N yɛɛr, n bʊɔrɔ naa ɩka yɩ bɔ̃ɔ a lɛ ɩn mʊɔrɔ sɔ̃ɔ yɔɔ jaa, ɩka n wa a yɩ sɛ̃ tɩchɛ ka a sɔr pɔɔ wa tãn dɩna. Ɩn taa nyɛn a yɩ bamɩne a ba puoraa nɩtãa lɛ ɩn nyɛ a yɩ bamɩne na ba ɩ a Juu nɩbɛ ɛ, tɩ puoro. ");
INSERT INTO biv_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","N din a Juu nɩbɛ nɩ a bala mɩ na ba ɩ a Juu nɩbɛ ɛ, nɩ a yɛ̃ dẽme nɩ a jɔlɔ sãn. ");
INSERT INTO biv_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ala lɛ so ka n mʊɔrɔ ɩka n mʊɔl a 'yɛr nʊ̃ɔ kʊ a yɩn mɩ na be a Worom. ");
INSERT INTO biv_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Vã ba kʊrɔ ma nɩ a 'yɛr nʊ̃ɔ nyãna 'yɛrfʊ ɛ, bojũu a ɩ naa a Nãaŋmɩn kpɛ̃ɔ wʊn de faara nɩ nɩrɛ jaa na sɔɔ, a Juu nɩbɛ lɛ de nie, ka bala mɩ na ba ɩ a Juu nɩbɛ ɛ, mɩ tu. ");
INSERT INTO biv_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Bojũu a 'yɛr nʊ̃ɔ nyã na wiil nɩrɛ lɛ wʊn na tor Nãaŋmɩn sɛ̃, torfʊ 'lɔ na yi sɔɔfʊ pɔ, yi a pielfʊ tɩ tãn a baaraa nɩtãa lɛ an sɛb a Nãaŋmɩn gãn pɔ, “Nɩrɛ 'lɔ na tara sɔɔfʊ, tor naa, wʊn tara na nyɛvʊr na ba tara baarfʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nãaŋmɩn vɛ̃n ka a wʊ suur yele yi a saaju gã chãa pɔ, ɩka wʊ nyɛn suur 'yɔ̃ɔ a bala na ba puoro ɛ, nɩ putudẽme bala na pɔɔ a yelmãɛ nɩ a ba putuyele. ");
INSERT INTO biv_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","An ɩ a ala ban na de bɔ̃ɔn a Nãaŋmɩn gãn chãa pɔ, bojũu Nãaŋmɩn mãɛ lɛ ir wiil ba. ");
INSERT INTO biv_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Bojũu, an yi a lɛ daar jaa a Nãaŋmɩn na mɛ a wɛr, nɩbɛ na tʊ̃ɔ bɔ̃ɔ ɩka a Nãaŋmɩn kpɛ̃ɔ ba tara baarfʊ ɛ, ka wʊ ɩ Nãaŋmɩn mãɛ nɩ a bonsɩ ala wʊn maal, a lɛ jũu, tu yifʊ jie ba lɛ be be go ɛ. ");
INSERT INTO biv_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Bojũu, ban sɔɔ bɔ̃ɔn a Nãaŋmɩn a nɩtɔ̃nɔ̃, tɩ baa kʊ wʊ tɩɩr ɛ, bɩɩ dãna wʊ ɛ, tɩchɛ a ba tɩɛrsɩ ɩn burbur, ka a ba jɔl nyãn ala pãa lii. ");
INSERT INTO biv_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ban sɔɔ 'yɛr ɩka yɛ̃ bɔ̃ɔnbɔ lɛ ba ɩ, ba ɩn jɔlɔ, ");
INSERT INTO biv_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","an ɩ ba lɩɛb a tɩɩr 'lɔ ban taa kʊ a Nãaŋmɩn nyã na ba kpire ɛ, na ba kʊ a bʊtɩbɛ ala ban pɛ̃n, ka a kaara a nɩbɛ kaar na kpire, nɩ lubil, nɩ dʊ̃n, nɩ dʊ̃gbɛɛ anaar jaa bʊrɔ. ");
INSERT INTO biv_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ala lɛ so ka Nãaŋmɩn ir nũu tɩchɛ ba bar be a ba vɔldɛɛr pɔ, ka ba bʊ̃nɔ̃ gãna nɩ taa, sɔ̃ɔnɔ̃ taa nɩ a ba ãgãma. ");
INSERT INTO biv_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ba den a Nãaŋmɩn yelmãɛ tɛɛn jire, na ba puoro tɩ tʊ̃nɔ̃ kʊrɔ a bonsɩ ala a Nãaŋmɩn na maal, tɩ bar a Nãaŋmɩn na ɩ a ma maala 'lɔ a pɛɛfʊ na sɛɛn bɩbir jaa. A ɩ a lɛ. ");
INSERT INTO biv_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","A anyãna jũu, Nãaŋmɩn de ban bar be a vã vɔlaa pɔ. Ka a ba pɔbɔ gba ma lɩɛb gãna nɩ a ba pɔɔ taa ba. ");
INSERT INTO biv_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","A lɛ nɩ wʊ ju lɛ a dɔɔr mɩ bar a pɔbɔ bɔfʊ, ka a vɔlaa vɛ̃ ka ba lɩɛb bʊɔrɔ a ba taa dɔɔr. Dɔɔr na lɩɛb tʊ̃nɔ̃ a vã tʊ̃mɔ̃ nyãna nɩ a ba taa dɔɔr ba nyɛn a ba tʊ̃dɛɛr toor tɔɔfʊ. ");
INSERT INTO biv_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Baa nyɛ a Nãaŋmɩn bɔ̃ɔfʊ a wʊ sɛɛn ba ɛ, ka a Nãaŋmɩn bar ba a be a ba tɩɛr sɔ̃ɔnaa pɔ, ka ba maala a ala na ba sɛɛn maalfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ba sɛɛn naa putuo jaa bʊrɔ, bier ɩfʊ, bɔgar dẽme, nɩ bier maalfʊ. Nyuur sɛɛn ba naa, na ba ɩ nɩkʊrbɔ, bʊɔrɔ jɛɛr, na ba bɛlɛ taa, na ba tɩɛrɛ taa sɔ̃ɔfʊ. Ba ɩn gagarsɩ, ");
INSERT INTO biv_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","sɔ̃ɔnɔ̃ nɩ taa yoe, 'laar Nãaŋmɩn, kpɛrɛ taa, mãɛ 'mɔɔfʊ nɩ yobɔyele. Ba bɔ̃ɔn sɔɩ ban ma tu maal bier, baa turo a nɩbɛ bala na dɔɔ ba nɛɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Baa tara tɩɛr ɛ, baa tara yelmãɛ ɛ, baa tara nʊ̃fʊ ɛ, baa kaara nɩrɛ nɩbaal ɛ. ");
INSERT INTO biv_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ban sɔɔ bɔ̃ɔ a Nãaŋmɩn toraa nyãna binfʊ, ɩka a nɩbɛ bala na maala a anyãna sɛɛn nɩ kũu, bala mãɛ tɛɛ ba lɛ maala a anyãna ɛ, tɩchɛ ba ma sɔɔ naa a bala na tʊ̃nɔ̃ a anyãna. ");
INSERT INTO biv_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Yɩn a lɛ jũu, yaa mɩ tara tu yifʊ jie ɛ, a yɩn bala na ma tɔɔrɔ a bamɩne 'yɛr. Yele jaa pɔ fʊn tɔɔr a fʊ tɔ sʊɔ 'yɛr fʊ mɩ 'yɔ̃ɔn fʊ mãɛ 'yɛr, bojũu fʊ mɩ ɩn a yele 'lɔ̃nɔ̃ a fʊ tɔ sʊɔ na ɩ, a fʊ tɔɔr a wʊ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Pʊ̃pãanyã, sɩ bɔ̃ɔ naa ɩka Nãaŋmɩn na tɔɔr naa a bala na ɩrɛ a yelsɩ anyãna 'yɛr tun yelmãɛ sɔr pɔ. ");
INSERT INTO biv_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","A lɛ a fʊ̃ʊ nɩsaal mɩ na tɔɔrɔ nɩbɛ 'yɛr, tɩ na fʊ mɩ maal a yele ala nɩ a ju, fʊ tɩɛr ɩka fʊn pɔl yi a Nãaŋmɩn 'yɛr tɔɔrfʊ pɔ ɔ? ");
INSERT INTO biv_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Bɩɩ yɩ nyɛ naa Nãaŋmɩn yɛ̃ bɔ̃ɔn yɔɔ jũu, nɩ a wʊ maalvɩla, nɩ a wʊ kãnyir, na yaa bɔ̃ɔn ɩka a Nãaŋmɩn maalvɩla wile yɩn tɩɛr lɩɛb fʊ sɔr ɛ? ");
INSERT INTO biv_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Tɩchɛ a yɩ nyãkpãɛn nɩ yɩn ba lɩɛb a yɩ tɩɛr jũu, yɩ guoro naa a Nãaŋmɩn sutuo bine kʊrɔ a yɩ mãɛ guro nɩ a wʊ suur bɩbir 'lɔ wʊn na tɔɔr nɩrɛ jaa 'yɛr nɩ torfʊ. ");
INSERT INTO biv_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Nãaŋmɩn “na yab nɩrɛ jaa lɛ wʊn tũ jã.” ");
INSERT INTO biv_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Bala na mar ara na ba tʊ̃nɔ̃ vɩla bʊɔrɔ tɩɩr, nɩ 'yɔ̃ɔfʊ, nɩ a ala na ba pʊ̃ɔnɔ̃ ɛ, wʊn kʊ ban nyɛvʊr na ba tara baarfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Tɩchɛ bala na bʊɔrɔ a ba mãɛ bɔb, na ba tɔr a yelmãɛ tɩ turo dɛɛr, Nãaŋmɩn suur nɩ a wʊ kpãafʊ gãn kʊ ba. ");
INSERT INTO biv_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Wõm nɩ tuo difʊ na ben be kʊ nɩsaal jaa na ɩrɛ yelbier. An piel naa a Juu nɩbɛ sɛ̃, tɩ mɩ lʊ̃ɔ a bala na ba ɩ a Juu nɩbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Tɩchɛ tɩɩr nɩ 'yɔ̃ɔfʊ nɩ nyã'maar na ben be kʊ nɩrɛ jaa na maala vɩla, a Juu nɩbɛ nɩ a bala na ba ɩ a Juu nɩbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Bojũu Nãaŋmɩn ba tara kaa gar taa ɛ. ");
INSERT INTO biv_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Bala jaa na ba bɔ̃ɔ a Mosesɩ nɛɛ tɩ tʊ̃ dɛɛr, mɩn wɛ naa ban ba bɔ̃ɔ a nɛɛ jũu, ka bala jaa mɩn bɔ̃ɔ a Mosesɩ nɛɛ tɩ tʊ̃ a dɛɛr Nãaŋmɩn na den a nɛɛ nyã tɔɔr a ba 'yɛr. ");
INSERT INTO biv_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Bojũu a ba ɩ a bala na wõnõ a nɛɛ lɛ tor a Nãaŋmɩn niem ɛ, tɩchɛ a bala na turo a lɛ a nɛɛ na 'yɛr bala lɛ a Nãaŋmɩn na 'yɛr ɩka ba tor naa. ");
INSERT INTO biv_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Sɩrɛ jaa a bala jaa na ba ɩ a Juu nɩbɛ ɛ, na baa tara a Mosesɩ nɛbinãa ɛ, ba gba ma ɩ naa a yelsɩ a nɛɛ na 'yɛr, bojũu bala mãɛ ɩn a nɛɛ ban sɔɔ ba tara a nɛɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ba wiil ɩka a lɛ a nɛɛ na bʊɔrɔ sɛb 'yɔ̃ɔ be a ba nyãa pɔ, ka a ba tɩɛr mɩ di dãasɩɛ ma gɔ̃nɔ̃ ba bɩɩ 'yɛrɛ pʊɔrɔ ba. ");
INSERT INTO biv_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","A anyãna na ɩ naa a daar 'lɔ̃nɔ̃ a Nãaŋmɩn na tu a Yesu Kɩrɩsɩto 'yɔ̃ɔ na wʊ tɔɔr nɩrɛ jaa yelsɔɔlsɩ nɩtãa lɛ ɩn 'yɛrɛ a n 'yɛr nʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Pʊ̃pãanyã a fʊ̃ʊ, ala ɩ fʊ bʊɔlɔ na a fʊ mãɛ Juu nɩrɛ, na fʊ dɩɛl a Mosesɩ nɛɛ na fʊ jɩrɛ lɛ fʊ̃ʊ nɩ a Nãaŋmɩn na tara nɛbʊ̃'yen, ");
INSERT INTO biv_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ala ɩ fʊ bɔ̃ɔ naa a wʊ bɔfʊ na fʊ bɔ̃ɔ a 'lɔ na gar a jaa bojũu a nɛɛ lɛ wiil fʊ, ");
INSERT INTO biv_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ala ɩ fʊ chɛn nyãa ɩka jɔ̃tɔɔrɔ lɛ fʊ ɩ, na fʊ ɩ chãa chaara a bala na be a libe pɔ, ");
INSERT INTO biv_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","na fʊ wile a jɔlɔ, na fʊ wile a bibiir, bojũu a Mosesɩ nɛɛ pɔ lɛ fʊ nyɛ a bɔ̃ɔfʊ nɩ a yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Fʊ̃ʊ nyã na wile a fʊ taaba, faa wiil a fʊ mãɛ ɛ? Fʊ̃ʊ nyã na ma 'yɛrɛ ɩka jufʊ ba ɩ ɛ, fʊ ma ju naa ɔ? ");
INSERT INTO biv_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Fʊ̃ʊ na ma 'yɛrɛ ɩka nɩbɛ ba ta sɛ̃nɛ ɛ, fʊ ma sɛ̃n bɩɩ? Fʊ̃ʊ nyã na kpɛrɛ a tɩbɛ tɩ fʊ ma juro naa a tɩbɛ der bonsɩ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Fʊ̃ʊ nyã na jɩrɛ nɩ a Mosesɩ nɛɛ nyã, fʊ ma 'yɔ̃ɔn Nãaŋmɩn vã fʊn sɔ̃ɔnɔ̃ a nɛɛ ɔ? ");
INSERT INTO biv_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Nɩtãa lɛ an sɛb a Nãaŋmɩn gãn pɔ, “A yɩ jũu lɛ a bala na ba ɩ a Juu nɩbɛ ɛ, sɔ̃ɔnɔ̃ a n yuor.” ");
INSERT INTO biv_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Yʊɔr ŋmaafʊ tara na tɔ̃nɔ̃ ala ɩ fʊ turo naa lɛ a nɛɛ na 'yɛr, tɩchɛ ala ɩ fʊ̃ʊ baa turo a nɛɛ ɛ, fʊn kaara fɩka faa ŋmaa yʊɔr ɛ. ");
INSERT INTO biv_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ala ɩ a bala na ba ŋmaa a yʊɔr ɛ, turo na lɛ a nɛɛ na bin, ba kʊ̃ kaara fɩka yɔŋmarba lɛ ba ɩ ɛ? ");
INSERT INTO biv_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Nɩrɛ 'lɔ na ba ŋmaa a yʊɔr a ãgãn pɔ ɛ, tɩchɛ na wʊ turo a nɛɛ jaa nɛ nɛ nɛ na 'yɔ̃ɔ yɩn 'yɛr, a yɩn bala gba na tara a nɛbinsɩ gãn na fʊ ŋmaa a yʊɔr tɩ faa turo a nɛbinsɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Nɩrɛ na ɩ a Juu nɩrɛ ba ɩ a ãgãn nyã yele tɛɛ lɛ ɛ, bɩɩ a yʊɔr ŋmaafʊ na ɩ a ãgãn yele ɛ. ");
INSERT INTO biv_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Kai, wʊ ɩn a Juu nɩrɛ na be a pʊɔm, ka a wʊ yʊɔr ŋmaafʊ ɩ a Nãaŋmɩn Sɩɛ na ŋmaa a wʊ nyãa yʊɔr a ba yi a nɛbinsɩ gãn pɔ ɛ. A nɩrɛ nyãna pɛɛfʊ ba yire nɩbɛ sɛ̃ ɛ, tɩchɛ a yin Nãaŋmɩn sɛ̃. ");
INSERT INTO biv_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Bo tɔ̃nɔ̃ lɛ a Juu nɩrɛ tara, bɩɩ bo tɔ̃nɔ̃ lɛ be be a yʊɔr ŋmaafʊ pɔ? ");
INSERT INTO biv_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Sɔr jaa pɔ, ala na de nie lɛ ɩka bala lɛ Nãaŋmɩn de nie kʊ a wʊ 'yɛrbie. ");
INSERT INTO biv_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Bo lɛ na ɩ ala ɩ bamɩne ba tara sɔɔfʊ ɛ? A ba ba sɔɔfʊ na tʊ̃ɔn sɔ̃ɔ a Nãaŋmɩn yelmãɛ bar bɩɩ? ");
INSERT INTO biv_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kai, sɔr ba be be ɛ! Vɛ̃ a Nãaŋmɩn ɩ yelmãɛ sʊɔ, tɩchɛ ka a nɩrɛ jaa ɩ jir ŋmara. Nɩtãa lɛ an sɛb a Nãaŋmɩn gãn pɔ, “Lɛ lɛ na wiil ɩka fʊ tor naa a fʊ 'yɛrbie pɔ, na fʊ tʊ̃ɔ a 'yɛr tɔɔrfʊ jie.” ");
INSERT INTO biv_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Tɩchɛ ala ɩ a sɩ ba torfʊ vɛ̃n ka Nãaŋmɩn torfʊ gã chãa pɔ, sɩ lɛ 'yɛr bo? Sɩ 'yɛr ɩka Nãaŋmɩn ba tor ɛ, wʊn vɛ̃ ka a wʊ sutuo dire sɩ ɔ? Nɩsaal nɛchɩrɛ lɛ a nyãna. ");
INSERT INTO biv_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Sɩrɛ jaa ba lɛ ɛ. Ala ɩ lɛ lɛ, ŋmɩnɛ lɛ a Nãaŋmɩn na ɩ tɔɔr a wɛr nɩbɛ 'yɛr? ");
INSERT INTO biv_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Nɩrɛ ãsʊɔ na chɩrɛ na, “Ka ala ɩ a n ba torfʊ wiil naa ɩka a Nãaŋmɩn ɩn yelmãɛ sʊɔ ka a wʊ tɩɩr pʊɔ 'yɔ̃ɔ, bãa 'yɔ̃ɔ lɛ a Nãaŋmɩn na lɛ 'yɔ̃ɔ ma 'yɛr ɩka yelbe-ɩrɛ lɛ n ɩ?” ");
INSERT INTO biv_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Bo lɛ so ka sɩ kʊ̃ 'yɛr nɩtãa lɛ a yosɔ̃ɔnbɔ na 'yɛr ka a bamɩne mɩ 'yɛrɛ ɩka sɩ 'yɛr ɩka, “Yɩ ɩ a sɩ maala dɛɛr tɩ ka a lɩɛrɛ vɩla?” A ba sɔ̃ɔfʊ sɛɛn ba naa. ");
INSERT INTO biv_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Bãa lɛ sɩn pãa de baar? Sɩn lɛ sa ba bɩɩ? Kai, sɔr ba be be ɛ. Sɩ den nie 'yɛr ɩka a Juu nɩbɛ nɩ a bala na ba ɩ a Juu nɩbɛ ɛ, ba jaa nyɛntaa na ba be a yelbier pɔ. ");
INSERT INTO biv_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Nɩtãa lɛ ban sɛb a ba yele 'yɔ̃ɔ a Nãaŋmɩn gãn pɔ, “Nɩtoraa jaa ba be be ɛ, nɩbʊ̃'yen gba ba be be ɛ. ");
INSERT INTO biv_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nɩbʊ̃'yen jaa ba be be bɔ̃ɔnɔ̃ 'yɛr par ɛ, nɩbʊ̃'yen jaa ba yʊɔrɔ bʊɔrɔ Nãaŋmɩn ɛ. ");
INSERT INTO biv_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ba jaa lɩɛb puor, ka ba jaa lɩɛb ɩ nɩsɔ̃ɔnsɩ. Ɩ̃sʊɔ jaa ba maala vɩla ɛ, nɩbʊ̃'yen gba ba be be ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“A ba kɔkɔbɔɔr yuon fɩka yar, ka a ba jãlbie bɔ̃ɔ bɛlfʊ.” “Dʊ̃pãn lɔɔ jɛlaa a ba nɛgãma.” ");
INSERT INTO biv_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Pɔ'yɔ̃ɔfʊ nɩ 'yɛr bitor lɛ ma yire a ba nɛɛr pɔ.” ");
INSERT INTO biv_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“A ba gbɛɛ ma pɔɔrɔ naa jãɩ kpaarfʊ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Sɔr jaa ban de, sɔ̃ɔfʊ nɩ dɔɔyɛ lɛ ma ɩ a jãnɛ. ");
INSERT INTO biv_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Baa bɔ̃ɔ nyã'maar sɔr ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“A ba nɩbie ba joro Nãaŋmɩn dãbãɛ ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Pʊ̃pãanyã, sɩ bɔ̃ɔn naa ɩka lɛ jaa a Mosesɩ nɛɛ na 'yɛr, wʊ 'yɛr kʊ a bala na be a nɛɛ pɔ ɩka, a kpal nɩrɛ jaa nɛɛ, ka a wɛr nɩbɛ ba jaa wa man a ba nɛɛ 'yɛr kʊ a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","A lɛ jũu, nɩrɛ jaa kʊ̃ ɩ nɩtor a Nãaŋmɩn niem wʊn turo a nɛɛ jũu ɛ, an ɩ a tun a nɛɛ nyã pɔ, ka sɩ bɔ̃ɔ bier. ");
INSERT INTO biv_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Tɩchɛ pʊ̃pãanyã, a chaar naa ɩka a torfʊ na yi a Nãaŋmɩn sɛ̃, ba yi a Mosesɩ nɛɛ pɔ ɛ, ala lɛ a nɛɛ nɩ a Nãaŋmɩn 'yɛ'yɛrbɛ di dãasɩɛ. ");
INSERT INTO biv_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","A torfʊ nyã na yi a Nãaŋmɩn sɛ̃, ɩn a sɔɔfʊ na tu a Yesu Kɩrɩsɩto 'yɔ̃ɔ, kʊ a bala jaa na sɔɔ de. Tɛɛ taa jaa ba be be ɛ. ");
INSERT INTO biv_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Bojũu nɩrɛ jaa maal dɛɛr na baa ta a Nãaŋmɩn tɩɩr ɛ. ");
INSERT INTO biv_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","A Nãaŋmɩn wãɛfʊ jũu, wʊ vɛ̃n ka sɩ tor na wʊ 'yɛrfaa sɩ pɔrɔ tu a faafʊ 'lɔ na yi a Yesu Kɩrɩsɩto sɛ̃. ");
INSERT INTO biv_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Nãaŋmɩn de wʊn a wʊ ɩ a bɔɔrlo bon, a wʊn de a wʊ jãɩ pɛɛn nɩrɛ jaa tu a sɔɔfʊ jũu. Nãaŋmɩn maal a anyã na wʊ wiil a wʊ torfʊ, bojũu a wʊ kãnyir vɛ̃ naa ka wʊ bar a ba yeldɛbɛ ala ban dɔ̃ɔ maal gefʊ. ");
INSERT INTO biv_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Wʊ maal naa lɛ na wiil a wʊ torfʊ a pʊ̃pãanyã, na wʊ ma vɛ̃ ka nɩrɛ jaa na sɔɔ de a Yesu yele, tor. ");
INSERT INTO biv_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nyɩnɛ lɛ a yobɔyele lɛ be? A ba pʊɔ be ɛ. Yelbuor jũu? A Mosesɩ nɛɛ ban turo jũu bɩɩ? Kai, sɔɔfʊ jũu lɛ. ");
INSERT INTO biv_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ala lɛ so ka sɩn chɛnɛ sɔɔ ɩka nɩrɛ yele ma tor naa wʊn tara sɔɔfʊ a ba ɩ wʊn turo a nɛbinãa jũu ɛ. ");
INSERT INTO biv_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Nãaŋmɩn ɩn a Juu nɩbɛ tɛɛ Nãaŋmɩn bɩɩ? Waa ɩ a bala na ba ɩ a Juu nɩbɛ mɩ Nãaŋmɩn ɛ? Ɔ̃ɔ, wʊ ɩn a bala na ba ɩ a Juu nɩbɛ mɩ tʊɔr. ");
INSERT INTO biv_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","An ɩ a Nãaŋmɩn bʊ̃'yen tɛɛ lɛ be be, 'lɔ lɛ na vɛ̃ ka a yɔŋmarba yele tor sɔɔfʊ jũu, na wʊ mɩ vɛ̃ ka a bala na ba ŋmaa a yʊɔr ɛ, yele mɩ tor a sɔɔfʊ jũu. ");
INSERT INTO biv_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Sɩ pãa den a sɔɔfʊ nyã sɔ̃ɔn a nɛbinãa bar bɩɩ? Kai, sɔr ba be be ɛ. Sɩn lɛ pãa bɔ̃ɔ turo wʊ. ");
INSERT INTO biv_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ŋmɩnɛ lɛ sɩn pãa 'yɛr a sɩ sãakpã Abraham 'yɛr, a yele nyãna pɔ? ");
INSERT INTO biv_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ala ɩ sɩrɛ jaa Abraham yele dɔ̃ɔ tor a wʊ tʊ̃mɔ̃ jũu, wʊn taa tara na yele kɔ̃ɔ bʊɔrɔ nɩ yuor, tɩchɛ a kʊ̃ naa ɩ a Nãaŋmɩn niem lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Bo lɛ a Nãaŋmɩn gãn 'yɛr? Wʊ 'yɛr ɩka, “Abraham sɔɔn de Nãaŋmɩn ka a lɛ vɛ̃ ka wʊ ɩ nɩtor.” ");
INSERT INTO biv_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Pʊ̃pãanyã nɩrɛ wa tʊ̃tʊ̃mɔ̃, a wʊ sãyar ba ɩ kʊfʊ ɛ, tɩchɛ a wʊ tʊ̃mɔ̃ sãyar lɛ. ");
INSERT INTO biv_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ala lɛ so nɩrɛ 'lɔ an ba ɩ tʊ̃mɔ̃ lɛ ɛ, tɩchɛ wʊn sɔɔ a Nãaŋmɩn 'lɔ na ma vɛ̃ ka a putudẽme yele tor, a wʊ sɔɔfʊ lɛ ma vɛ̃ ka wʊ ɩ a nɩtor. ");
INSERT INTO biv_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","A Nãa David mɩ dɔ̃ɔ 'yɛr a 'yɛr bir nyãna nɩ wʊ ju, na wʊ 'yɛr ɩka, bɔɔsʊ̃n sʊɔ lɛ a 'lɔ a Nãaŋmɩn na vɛ̃ a wʊ ɩ nɩtor ka tʊ̃mɔ̃ ba pʊɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Bɔɔsʊ̃n dẽme lɛ a Nãaŋmɩn na vɛ̃ a ba bɔrfʊsɩ kʊ ba, ka a ba yelbebe ala pɔɔ. ");
INSERT INTO biv_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Bɔɔsʊ̃n lɛ a 'lɔ a sɩ Soro na ba lɛ sɔrɔ a wʊ yelbier dɔɔlɔ wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","A bɔɔsʊ̃n nyãna ɩn a yɔŋmarba tɛɛ bon bɩɩ, a mɩ ɩn a bala na ba ŋmaa a yʊɔr ɛ, bon? Sɩ 'yɛr ɩka Abraham sɔɔfʊ vɛ̃n ka wʊ ɩ nɩtor. ");
INSERT INTO biv_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ŋmɩnɛ lɛ anyãna dɔ̃ɔ ɩ kʊ wʊ? Wʊn ŋmaa a yʊɔr baar lɛ bɩɩ wʊn ba ŋmaa sɛrɛ lɛ? A ba ɩ wʊn ŋmaa baar ɛ, tɩchɛ wʊn dɔ̃ɔ ba ŋmaa sɛrɛ lɛ. ");
INSERT INTO biv_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Nãaŋmɩn wa bɩɛr man wʊ a yʊɔr ŋmaafʊ yele, ka a ɩ jãnɛ ɩka a wʊ yele tor naa a wʊ sɔɔfʊ jũu wʊn dɔ̃ɔ ba ŋmaa a yʊɔr sɛrɛ ɛ. Lɛ lɛ wʊ pãa ɩ a bala jaa na sɔɔ de sãa, tɩchɛ na baa ŋmaa a ba yɔɩ ɛ, ka a Nãaŋmɩn vɛ̃ a ba ɩ nɩtorsɩ. ");
INSERT INTO biv_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Wʊ mɩ ɩ naa bala jaa na ŋma a yɔɩ sãa. A ba ɩ yʊɔr ŋmaafʊ tɛɛ 'yɔ̃ɔ lɛ ɛ, tɩchɛ ban tara a sɔɔfʊ na ba turo nɩ a lɛ a sɩ sãa Abraham na dɔ̃ɔ turo tɩ wa ŋmaa a yʊɔr. ");
INSERT INTO biv_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","A ba ɩ a nɛbinãa jũu lɛ a Nãaŋmɩn dɔ̃ɔ tɩr a nɛɛ kʊ a Abraham nɩ a wʊ yɔn ɩka bala lɛ na so a wɛr ɛ, tɩchɛ wʊn ɩ nɩtor a wʊ sɔɔfʊ jũu lɛ. ");
INSERT INTO biv_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ala ɩ a bala na turo a nɛbinãa lɛ so a wɛr ɛ, sɔɔfʊ ba lɛ tara tɔ̃nɔ̃ ɛ, ka Nãaŋmɩn nɛɛ wʊn tɩr mɩ ɩ pɔrɔ. ");
INSERT INTO biv_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Bojũu a nɛbinãa waara nɩ naa Nãaŋmɩn suur. A jie 'lɔ mɩ a nɛbinãa na ba be ɛ, a nɛɛ bɔrfʊsɩ mɩ ba be be ɛ. ");
INSERT INTO biv_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","A lɛ jũu, a nɛtɩraa wa naa a sɔɔfʊ jũu, ka a Nãaŋmɩn wãɛfʊ na sʊ̃ʊ a Abraham yɔn ba jaa, a ba ɩ a bala na turo a nɛɛ tɛɛ ɛ, tɩchɛ a bala na tara a Abraham sɔɔfʊ, 'lɔ lɛ ɩ a sɩ jaa sãa. ");
INSERT INTO biv_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Nɩtãa an sɛb a Nãaŋmɩn gãn pɔ, “N maal fʊ naa a fʊ ɩ a paal yɔɔ sãa.” 'Lɔ lɛ ɩ a sɩ sãa a Nãaŋmɩn sɛ̃, a 'lɔ wʊn sɔɔ de, a Nãaŋmɩn nyã na ma vɛ̃ ka kũn ɩ vʊɛ, na wʊ ma bʊɔl bonsɩ ala na ba dɔ̃ɔ be be ɛ, ka a be be. ");
INSERT INTO biv_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Tɩɛrtɔfʊ jie ba lɛ be be ɛ, tɩ Abraham tara tɩɛrtɔ jie, na wʊ sɔɔ de ka a lɛ vɛ̃ ka wʊ ɩ a paal yɔɔ sãa, nɩtãa lɛ a Nãaŋmɩn na dɔ̃ɔ 'yɛr kʊ wʊ, “Lɛ lɛ a fʊ yɔn na wa be.” ");
INSERT INTO biv_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Waa bal a wʊ sɔɔfʊ pɔ ɛ, wʊ mãɛ nyɛn bɔ̃ɔn a wʊ ãgãn na kor jʊɔl, bojũu yuom kɔbaa lɛ wʊ nyɛ ka a Saara mɩ ab. ");
INSERT INTO biv_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Tɩchɛ Abraham ba tara baal a wʊ sɔɔfʊ pɔ, nɩ lɛ a Nãaŋmɩn na tɩr a wʊ nɛɛ ɛ, tɩchɛ wʊ nyɛn kpɛ̃ɔ a wʊ sɔɔfʊ pɔ, na wʊ de tɩɩr kʊ a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Wʊ sɔɔn de nuur ayi ɩka Nãaŋmɩn tara na kpɛ̃ɔ na maal a lɛ wʊn tɩr a wʊ nɛɛ. ");
INSERT INTO biv_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","A anyãna lɛ so ka a Nãaŋmɩn, vɛ̃ a wʊ ɩ nɩtor. ");
INSERT INTO biv_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","A 'yɛrbir na 'yɛr ɩka, Nãaŋmɩn vɛ̃n a wʊ ɩ nɩtor, a ba sɛb a 'lɔ tɛɛ 'yɔ̃ɔ ɛ, ");
INSERT INTO biv_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","tɩchɛ a mɩ ɩn a sɩ bon, Nãaŋmɩn mɩ na vɛ̃n a sɩ yele ka a tor, sɩn bala jaa na sɔɔ ɩka, 'lɔ lɛ sãɩ a Yesu na ɩ a sɩ Soro a kũu pɔ. ");
INSERT INTO biv_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","A sɩ yelbebe jũu lɛ ba dɔ̃ɔ kʊn wʊ, tɩchɛ ka a Nãaŋmɩn sãɩ wʊ a kũu pɔ a wʊ ɩ vʊr, na wʊ vɛ̃ ka sɩ tor. ");
INSERT INTO biv_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Wʊn ben vɛ̃ a sɩ tor a sɩ sɔɔfʊ jũu, sɩ tara na nyã'maar Nãaŋmɩn sɛ̃ tu a sɩ Soro Yesu Kɩrɩsɩto 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","A wʊ 'yɔ̃ɔ lɛ sɩ tu nyɛ sɔr a sɩ sɔɔfʊ jũu kpɛ a Nãaŋmɩn wãɛfʊ nyã pɔ sɩn ben ara a pʊ̃pãanyã, na sɩ chɩlɛ a Nãaŋmɩn tɩɩr tɩɛrtɔ nyã jũu. ");
INSERT INTO biv_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","A ba ɩ lɛ tɛɛ ɛ, tɩchɛ sɩ mɩ chɩlɛ na a sɩ dɔɔyɛ pɔ, bojũu sɩ bɔ̃ɔn naa ɩka a dɔɔyɛ lɛ na waan kãnyir, ");
INSERT INTO biv_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ka a kãnyir wiil a lɛ fʊn be, ka a lɛ fʊn be mɩ waan tɩɛrtɔfʊ jie. ");
INSERT INTO biv_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ka a tɩɛrtɔfʊ jie kʊ̃ 'yɔ̃ɔ sɩ vã ɛ, bojũu Nãaŋmɩn kpaar naa a wʊ nʊ̃fʊ 'yɔ̃ɔ a sɩ nyãn pɔ, tu a wʊ Sɩɛ 'lɔ wʊn de kʊ sɩ. ");
INSERT INTO biv_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Yaa nyɛ, a sɔ̃ɔ 'lɔ na sɛɛ lɛ, sɩn sɔɔ chɛnɛ ba tara kpɛ̃ɔ ɛ, tɩ Kɩrɩsɩto kpin kʊ a bala na ba puoro ɛ. ");
INSERT INTO biv_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","An kpɛ̃mɛ naa ɩka nɩrɛ na sɔɔn kpi kʊ nɩrɛ yele na tor, amɩne nɩrɛ ãsʊɔ na tʊ̃ɔn sɔɔ kpi kʊ nɩrɛ na ɩ nɩsʊ̃. ");
INSERT INTO biv_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Tɩchɛ Nãaŋmɩn wiil a wʊ mãɛ nʊ̃fʊ a nɩtɔ̃ kʊ sɩ, a sɔ̃ɔ 'lɔ sɩn chɛnɛ ɩ yelbe-ɩrbɛ, Kɩrɩsɩto kpin kʊ sɩ. ");
INSERT INTO biv_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","An ben ɩka pʊ̃pãanyã wʊ ben vɛ̃ a sɩ tor a wʊ jãɩ jũu, ŋmɩnɛ lɛ an pãa kaara wʊn faa sɩ yin a Nãaŋmɩn suur pɔ. ");
INSERT INTO biv_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Bojũu ala ɩ a lɛ sɩn dɔ̃ɔ ɩ a Nãaŋmɩn dɔ̃dẽme, ka a wʊ Bie kũu wa 'maal wʊ kʊ sɩ, a lɛ wʊn ben 'maal sɩ, wʊn faa sɩ naa tu a wʊ nyɛvʊr pɔ. ");
INSERT INTO biv_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","A ba ɩ anyã tɛɛ lɛ ɛ, tɩchɛ sɩ chɩlɛ naa a Nãaŋmɩn 'yɔ̃ɔ tu a sɩ Soro Yesu Kɩrɩsɩto 'yɔ̃ɔ, tu a 'lɔ 'yɔ̃ɔ sɩn ben nyɛ a 'maalfʊ a pʊ̃pãanyã. ");
INSERT INTO biv_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Nɩtɔ̃ jũu lɛ a yelbier kpɛ a wɛr pɔ tu nɩbʊ̃'yen 'yɔ̃ɔ, ka a kũu mɩ tu a yelbier 'yɔ̃ɔ mɩ wa, sɔr nyã lɛ a kũu mɩ tu pɔɔ nɩrɛ jaa, bojũu ba jaa maal yelbier. ");
INSERT INTO biv_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Sɛrɛ tɩchɛ ka a Mosesɩ wa bin a nɛɛ, yelbier den nie be ka a wɛr pɔ, tɩchɛ lɛ a nɛbinãa na ba dɔ̃ɔ be be ɛ, ba maa de yelbier maal bon ɛ. ");
INSERT INTO biv_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Tɩchɛ kũu din nãa yi a Adama sɔ̃ɔ tɩ tãn a Mosesɩ sɔ̃ɔ, na wʊ gba mɩ tʊ̃ɔ a bala na ba maal a yelbier sɔ̃ɔ a nɛɛ a Adama kaar ɛ, Adama lɛ dɔ̃ɔ ɩ a 'lɔ na wa wa gãagiel. ");
INSERT INTO biv_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Tɩchɛ a kʊfʊ ba kaara a bɔrfʊ kaar ɛ, bojũu ala ɩ nɩyɔɔ kpi naa nɩbʊ̃'yen bɔrfʊ jũu, Nãaŋmɩn wãɛfʊ nɩ a wʊ kʊfʊ ala na wa tu a nɩbʊ̃'yen Yesu Kɩrɩsɩto wãɛfʊ jũu, na yaar kʊ nɩyɔɔ gar a lɛ. ");
INSERT INTO biv_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","A Nãaŋmɩn kʊfʊ gba ba nyɛtãan a nɩbʊ̃'yen yelbier 'lɔ ɛ. 'Yɛr tɔɔrfʊ tun a yelbe bʊ̃'yen 'lɔ na wʊ waan sɔ̃ɔfʊ, tɩchɛ a kʊfʊ mɩ tun a bɔrfʊsɩ yɔɔ pɔ, naa waan torfʊ. ");
INSERT INTO biv_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Bojũu ala ɩ a nɩbʊ̃'yen bɔrfʊ jũu kũu din nãa tu a nɩbʊ̃'yen 'lɔ 'yɔ̃ɔ, ŋmɩnɛ lɛ a bala na nyɛ a Nãaŋmɩn wãɛfʊ nɩ a kʊfʊ 'lɔ na ɩ a torfʊ, na din nãa a ba nyɛvʊr pɔ tu a nɩbʊ̃'yen Yesu Kɩrɩsɩto 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","An ɩ nɩbʊ̃'yen bɔrfʊ jũu lɛ waan sɔ̃ɔfʊ wa 'yɔ̃ɔ a nɩbɛ ba jaa, lɛ lɛ so nɩbʊ̃'yen mɩ na maal ka a tor, mɩ lɛ vɛ̃ ka a nɩbɛ ba jaa tor na ba nyɛ nyɛvʊr. ");
INSERT INTO biv_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Nɩtãa lɛ a bawõno bʊ̃'yen na vɛ̃ ka a nɩyɔɔ ɩ yelbe-ɩrbɛ, lɛ mɩ lɛ a tu nɩbʊ̃'yen na tu Nãaŋmɩn nɛɛ mɩ vɛ̃, ka a nɩyɔɔ mɩ ɩ nɩtorsɩ. ");
INSERT INTO biv_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","A nɛɛ pʊɔn 'yɔ̃ɔ, ka a bɔrfʊsɩ mɩ waa. Tɩchɛ jie 'lɔ a yelbier na pʊɔ 'yɔ̃ɔ, Nãaŋmɩn wãɛfʊ ma pʊɔn 'yɔ̃ɔ gar a lɛ. ");
INSERT INTO biv_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Nɩtãa lɛ a yelbier na di nãa a kũu pɔ, lɛ mɩ lɛ a Nãaŋmɩn wãɛfʊ na di a nãa tu a yeltorsɩ pɔ, na wʊ waan nyɛvʊr na ba tara baarfʊ ɛ, tu a Yesu Kɩrɩsɩto na ɩ a sɩ Soro 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Sɩ pãa 'yɛr ɩka bo? Sɩ chɛnɛ ɩrɛ a yelbier tɩchɛ ka a Nãaŋmɩn wãɛfʊ pʊɔrɔ 'yɔ̃ɔnɔ̃? ");
INSERT INTO biv_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Kai, sɔr ba be be ɛ! Sɩ kpin kʊ yelbier, ŋmɩnɛ lɛ a ɩ a sɩn lɛ chɛnɛ be a pɔ? ");
INSERT INTO biv_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Bɩɩ yaa bɔ̃ɔ ɩka a sɩn bala jaa na so a Nãaŋmɩn kʊ̃ɔ, wʊ pɔl sɩ 'yɔ̃ɔ a Yesu Kɩrɩsɩto pɔ, a sɩ lɔ̃ɔ kpin wʊ nɩ a wʊ kũu pɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","A lɛ jũu, ba ũu sɩ naa a kʊ̃ɔ pɔ, a kũu kaar, ka a lɛ a Kɩrɩsɩto na dɔ̃ɔ ir a kũu pɔ, tu a Sãa tɩɩr pɔ, ka sɩ mɩ na be be tara nyɛvʊr paalaa. ");
INSERT INTO biv_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ala ɩ sɩn nɩ 'lɔ 'mantaa a wʊ kũu pɔ, sɩn nɩ 'lɔ na 'mantaa ir a kũu pɔ. ");
INSERT INTO biv_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Sɩ bɔ̃ɔn naa ɩka a sɩ ãgãn koraa pʊɔ naa a Kɩrɩsɩto 'yɔ̃ɔ, a ba kpan wʊ a be a daa ju, ka a yelbier ãgãn ba lɛ tara kpɛ̃ɔ a sɩ 'yɔ̃ɔ, saa lɛ ɩ a yelbier gbãgbaar ɛ. ");
INSERT INTO biv_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Bojũu nɩrɛ 'lɔ jaa na kpi, wʊ yin yelbier pɔ. ");
INSERT INTO biv_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ala ɩ sɩn nɩ Kɩrɩsɩto lɛ 'mataa kpi, sɩ sɔɔ naa ɩka sɩn nɩ 'lɔ lɛ na 'mataa be be tara a nyɛvʊr. ");
INSERT INTO biv_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Bojũu sɩ bɔ̃ɔn naa ɩka a Kɩrɩsɩto na ir a kũu pɔ, wʊ kʊ̃ lɛ kpi go ɛ, kũu ba lɛ tʊ̃ɔ wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","A kũu wʊn kpi, wʊ kpin kʊ yelbier gbɛbʊ̃'yen kʊ nɩrɛ jaa, tɩchɛ a wʊ nyɛvʊr pɔ wʊn be, wʊ ben be kʊ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","A lɛ nɛ nɩ wʊ ju mɩ lɛ ɩka, yɩ kaa a yɩ mãɛ ɩka, yɩ kpin kʊ yelbier, tɩ be be kʊ Nãaŋmɩn, Yesu Kɩrɩsɩto jũu. ");
INSERT INTO biv_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","A lɛ jũu, yɩ ta sɔɔ ka yelbier lɛ di nãa a yɩ ãgãn nyãn na kpi ka yɩ turo a wʊ dɛɛr bɔfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Yɩ taa ɩrɛ wa diere a yɩ ãgãn jie ãsʊɔ jaa kʊrɔ yelbier maalfʊ ɛ, ka a ɩ putuyele tʊ̃tʊ̃bomo ɛ. Tɩchɛ yɩ sɔɔ de a yɩ mãɛ kʊ a Nãaŋmɩn, nɩtãa nɩbɛ na yi kũu pɔ tara nyɛvʊr, na yɩ sɔɔ de a yɩ ãgãn jiir kʊ wʊ, ka a ɩ yeltorsɩ tʊ̃tʊ̃bomo. ");
INSERT INTO biv_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Bojũu, yelbier ba lɛ ɩ a yɩ nɩkpɛ̃ɛ ɛ, bojũu yaa chɛnɛ be a Mosesɩ nɛbinãa pĩlem ɛ, tɩchɛ yɩ ben a Nãaŋmɩn wãɛfʊ pĩlem. ");
INSERT INTO biv_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ka bo go? Sɩ chɛnɛ ɩrɛ a yelbier bojũu sɩn ba lɛ chɛnɛ be a nɛɛ pĩlem ɔ, tɩ be a wãɛfʊ pĩlem bɩɩ? Kai, sɔr ba be be ɛ! ");
INSERT INTO biv_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Yaa bɔ̃ɔ ɩka ala ɩ fʊ wa den fʊ mãɛ kʊ nɩrɛ na fʊ turo a wʊ nɛɛ gbãgbaa kaar, fʊ ɩn gbãgbaa kʊ a nɩrɛ 'lɔ nɛɛ fʊn turo, ka yelbier gbãgbaa lɛ fʊ ɩ a 'lɔ na chiine a kũu pɔ, bɩɩ a Nãaŋmɩn nɛɛ tufʊ 'lɔ mɩ na chiine nɩ fʊ a yeltorsɩ jie. ");
INSERT INTO biv_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Tɩchɛ n puor Nãaŋmɩn yãan, yɩn dɔ̃ɔ gba ɩ a yelbier gbãgbaar, tɩ yɩ wa sɔɔn naa a yɩ nyãa wʊ jaa na yɩ de a yɩ mãɛ 'yɔ̃ɔ a wiilfʊ nyã pɔ. ");
INSERT INTO biv_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Nãaŋmɩn faa yɩn yin a yelbier pɔ a yɩ so yɩ mãɛ, na yɩ lɩɛb yeltorsɩ gbãgbaar. ");
INSERT INTO biv_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Nɩsaal 'yɛr lɛ n de man a yɩ ãgãma yɩn ba tʊ̃ɔnɔ̃ nyɔɔrɔ jũu. Nɩtãa lɛ yɩn dɔ̃ɔ ma de a yɩ ãgãn jiir ka a ɩ gbãgbaar kʊ a ala na ba vɩɛl ɛ, naa ma pʊɔrɔ putuyele 'yɔ̃ɔnɔ̃, pʊ̃pãanyã 'lɔ, yɩ de a yɩ mãɛ ka a ɩ yeltorsɩ nɩ chɛchɛ ɩfʊ gbãgbaar. ");
INSERT INTO biv_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Yɩn dɔ̃ɔ ɩ a yelbier gbãgbaar, a yeltorsɩ ba so yɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Tɔ̃nɔ̃ buor lɛ yɩ nyɛ yin a sɔ̃ɔ 'lɔ a yelsɩ ala na ben ɩ vã a pʊ̃pãanyã? A bomo ala baarfʊ daar ɩn kũu. ");
INSERT INTO biv_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Tɩchɛ pʊ̃pãanyã, Nãaŋmɩn na ben faa yɩ yin a yelbier pɔ a yɩ ɩ a wʊ gbãgbaar, a tɔ̃nɔ̃ yɩn nyɛ ɩn chɛchɛ ɩfʊ ka a baaraa ɩ nyɛvʊr na ba tara baarfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Bojũu yelbier sãyar ɩn kũu, tɩchɛ ka a Nãaŋmɩn kʊfʊ ɩ nyɛvʊr na ba tara baarfʊ ɛ, tu a Yesu Kɩrɩsɩto na ɩ a sɩ Soro 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Yaa be bɔ̃ɔ ɛ, yɛɛr, n 'yɛrɛ na kʊrɔ a bala na bɔ̃ɔ a nɛbinãa ɩka a nɛbinãa ma tʊ̃ɔn nɩrɛ na chɛnɛ nɩ nɩbir ɛ? ");
INSERT INTO biv_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","De man pɔɔ na kul sɩrɛ, a nɛɛ lũ wʊn mar a sɩrɛ ka wʊ chire dayuo na gãn wʊ, a sɩrɛ na chɛnɛ ba kpi ɛ, tɩchɛ a sɩrɛ wa kpi, a kul taa nɛɛ 'lɔ ba lɛ lũ wʊ go ɛ. ");
INSERT INTO biv_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","'Lɔ wa tɩ ir dayuo a sɩrɛ na chɛnɛ vʊrɔ, ban 'yɛr naa ɩka wʊ sɔ̃ɔ naa. Tɩchɛ ala ɩ a sɩrɛ kpi naa, a nɛɛ ba lɛ lũ wʊ go ɛ, ala ɩ wʊ gba na kul dayuo, waa sɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Lɛ lɛ, n yɛɛr yɩ mɩ kpin kʊ a nɛbinãa tu a Kɩrɩsɩto ãgãn pɔ, ka yɩn be be kʊ nɩyuo, a 'lɔ na ir a kũu pɔ ka sɩn tʊ̃ɔ wɔ̃ wɔ̃mɔ̃ kʊ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Bojũu a sɔ̃ɔ 'lɔ a yelbier ãgãn na so sɩ, ka a yelbier vɔlaa ma de a nɛbinãa tʊ̃nɔ̃ nɩ tʊ̃mɔ̃ a sɩ ãgãn pɔ a sɩ wɔ̃nɔ̃ kũu wɔ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Tɩchɛ pʊ̃pãanyã, sɩ kpin kʊ a 'lɔ na dɔ̃ɔ lũ sɩ, sɩ son sɩ mãɛ yi a nɛbinãa 'lɔ pɔ, na sɩ pãa tʊ̃nɔ̃ a sɔpaalaa nyã pɔ na ɩ a Nãaŋmɩn Sɩɛ na ba ɩ a sɔkoraa ban sɛb 'yɔ̃ɔ a gãn pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Bo lɛ sɩn lɛ 'yɛr go? A nɛbinãa ɩn yeldɛɛr bɩɩ? Kai, sɔr ba be be ɛ! Waa ɩ yeldɛɛr ɛ. Sɩrɛ jaa n kʊ̃ naa bɔ̃ɔ yelbier ɛ, ala ɩ a nɛbinãa ba be be ɛ. Bojũu n kʊ̃ naa bɔ̃ɔ jɩɛlfʊ ɛ, ala ɩ a nɛbinãa ba ta 'yɛr ɩka, “Taa jɩɛlɛ nɩrɛ bon ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Tɩchɛ a yelbier far kpɛ na wʊ nyɛ sɔr a nɛbinãa sɛ̃ vɛ̃ ka n wɔ̃ jɩɛlfʊ jaa bʊrɔ vɔlaa. A nɛbinãa baa be be ɛ, yelbier ɩn bʊ̃kũu. ");
INSERT INTO biv_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ɩn dɔ̃ɔ be be ba bɔ̃ɔ a nɛbinãa ɛ, tɩchɛ a nɛbinãa na wa wa, yelbier faan a nyɛvʊr, ka a kũu kʊ ma. ");
INSERT INTO biv_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Be lɛ n nyɛ ɩka a nɛbinãa 'lɔ naa waan nyɛvʊr, kũu lɛ wʊ bar tɩ waan. ");
INSERT INTO biv_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Bojũu a yelbier nyɛn sɔr a nɛbinãa na kʊ wʊ, a wʊ far kpɛ na wʊ bɛl ma, ka a tu a nɛbinãa nyã pɔ, ka a kũu kʊ ma. ");
INSERT INTO biv_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","A lɛ jũu, a nɛbinãa ɩn chɛchɛ, ka a nɛbinãa 'yɛr mɩ ɩ chɛchɛ, naa tor ɩ vɩla. ");
INSERT INTO biv_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Bon 'lɔ na ɩ bʊ̃vɩla pãa lɩɛb kũu wa kʊ ma? A ba ɩ lɛ lɛ ɛ. Tɩchɛ n bɔ̃ɔn naa ɩka a ɩn yelbier, na a lɩɛb kũu kʊ ma tu a bon 'lɔ na ɩ vɩla pɔ. A tu naa 'yɛr binãa pɔ, ka bier na ɩ yelbier sɩrɛ jaa. ");
INSERT INTO biv_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Sɩn bɔ̃ɔn naa ɩka a nɛbinãa ɩn Nãaŋmɩn Sɩɛ bon lɛ, tɩchɛ ka a maa ɩ ãgãn yelbier na da ka n ɩ a wʊ gbãgbaa. ");
INSERT INTO biv_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","N maa bɔ̃ɔ a lɛ ɩn maala ɛ, bojũu a ala ɩn bʊɔrɔ ɩka n maal n maa maal ɛ, tɩchɛ a ala ɩn 'laar lɛ n ma maala. ");
INSERT INTO biv_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ala ɩ n ma maala naa ala ɩn ba bʊɔrɔ ɩka n maala ɛ, n sɔɔ naa ɩka a nɛbinãa ɩn vɩla. ");
INSERT INTO biv_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","An ben be a lɛ, a ba ɩ maa mãɛ lɛ bɔ̃ɔn tɩ ɩrɛ ɛ, tɩchɛ a yelbier 'lɔ̃nɔ̃ na be a n pɔ lɛ ɩrɛ. ");
INSERT INTO biv_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","N bɔ̃ɔn naa ɩka yelvɩla jaa ba be a n 'yɔ̃ɔ ɛ, a maa yelbier ãgãn tɛɛ lɛ. Bojũu n ma bʊɔrɔ naa ɩka n maal vɩla tɩ naa maa tʊ̃ɔ maal ɛ. ");
INSERT INTO biv_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Bojũu a ala ɩn maala ba ɩ a vɩla ala ɩn bʊɔrɔ a maalfʊ ɛ. Kai, a bier ala ɩn ba bʊɔrɔ a maalfʊ lɛ, ala lɛ n ma maala. ");
INSERT INTO biv_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Pʊ̃pãanyã, ala ɩ n maala naa a ala ɩn ba bʊɔrɔ ɩka n maal ɛ, a ba lɛ ɩ maa lɛ lɛ maala go ɛ, tɩchɛ a yelbier 'lɔ̃nɔ̃ na be a n 'yɔ̃ɔ lɛ maala. ");
INSERT INTO biv_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Lɛ lɛ, n nyɛn a lɛ a nɛbinãa na tʊ̃nɔ̃, maa wa bʊɔrɔ ɩka n maal vɩla, a yelbier lɛ ma tɔɔ gbʊr ma jaa yɛ̃ yɛ̃. ");
INSERT INTO biv_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","N bʊɔrɔ naa Nãaŋmɩn nɛbinãa nɩ a n pʊɔ wʊ jaa, ");
INSERT INTO biv_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","tɩchɛ n nyɛ naa a nɛbinãa ãsʊɔ na tʊ̃nɔ̃ nɩ a n ãgãn jiir amɩne. Wʊ jɛɛrɛ nɩ naa a n tɩɛr na wʊ maal ma ka n ɩ a yelbier nɩpɔɔraa a n ãgãn jiir pɔ. ");
INSERT INTO biv_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Nɩjarma lɛ n pãa ɩ! An lɛ na faa ma yin a yelbier ãgãn nyã na chiine ma a kũu jie? ");
INSERT INTO biv_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Nãaŋmɩn son puorfʊ tu a Yesu Kɩrɩsɩto na ɩ a sɩ Soro 'yɔ̃ɔ! A maa mãɛ a n tɩɛr pɔ, n ɩn a Nãaŋmɩn nɛɛ gbãgbaa, tɩchɛ a n yelbier ãgãn mɩ ɩ gbãgbaa kʊ a yelbier nɛɛ. ");
INSERT INTO biv_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","A lɛ jũu pʊ̃pãanyã, yele ba pɔɔrɔ a bala na be a Yesu Kɩrɩsɩto 'yɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","A tun a Yesu Kɩrɩsɩto 'yɔ̃ɔ jũu, a nɛɛ 'lɔ na ɩ a Nãaŋmɩn Sɩɛ nyɛvʊr faa man yin a nɛɛ 'lɔ na ɩ yelbier nɩ kũu pɔ. ");
INSERT INTO biv_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Bojũu a bon 'lɔ a Mosesɩ nɛɛ na ba dɔ̃ɔ tara kpɛ̃ɔ na maal ɛ, a sɩ yelbier ãgãn na bal bar, Nãaŋmɩn maal naa na wʊ tʊ̃ a wʊ mãɛ Bie a wʊ nyɛtãan a sɩn na maala a yelbier kaar a wʊ wa ɩ a yelbier bɔɔrlo bon. Lɛ lɛ wʊ sɔ̃ɔ yelbier a nɩsaal pɔ bar, ");
INSERT INTO biv_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ka a lɛ a Mosesɩ nɛbinãa na bʊɔrɔ ka a sɛɛ a sɩ 'yɔ̃ɔ, a sɩ kʊ̃ lɛ turo a lɛ a yelbier ãgãn na bʊɔrɔ ɛ, tɩ turo a lɛ a Nãaŋmɩn Sɩɛ na bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","A bala na turo a ba yelbier ãgãn, ba den a ba tɩɛr 'yɔ̃ɔ a ala na ɩ a ãgãn vɔlaa pɔ, tɩchɛ a bala mɩ na turo a lɛ a Nãaŋmɩn Sɩɛ na bʊɔrɔ, mɩ den a ba tɩɛr 'yɔ̃ɔ a ala a Nãaŋmɩn Sɩɛ na bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Yelbier sʊɔ tɩɛr ɩn kũu, tɩchɛ a tɩɛr 'lɔ a Nãaŋmɩn Sɩɛ na so ɩn nyɛvʊr nɩ nyã'maar. ");
INSERT INTO biv_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","A yelbe-ɩrɛ tɩɛr ma 'laar Nãaŋmɩn, wʊ maa siir wʊ mãɛ kʊ a Nãaŋmɩn nɛɛ ɛ, wʊ mɩ kʊ̃ tʊ̃ɔ ɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Bala na turo a lɛ a ba ãgãn na bʊɔrɔ, kʊ̃ tʊ̃ɔ pɛl Nãaŋmɩn pʊɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Yɩn 'lɔ ba lɛ turo a lɛ a yelbier ãgãn na bʊɔrɔ ɛ, tɩchɛ yɩ turo naa a lɛ a Nãaŋmɩn Sɩɛ na bʊɔrɔ, ala ɩ a Nãaŋmɩn Sɩɛ ben a yɩ 'yɔ̃ɔ. Ala ɩ ãsʊɔ jaa ba wa tara a Kɩrɩsɩto Sɩɛ ɛ, waa ɩ a Kɩrɩsɩto tʊɔr ɛ. ");
INSERT INTO biv_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Tɩchɛ ala ɩ Kɩrɩsɩto ben a yɩ 'yɔ̃ɔ, a yɩ ãgãn kpi naa a yelbier jũu, tɩchɛ ka a yɩ sɩɩr tara nyɛvʊr a yeltorsɩ jũu. ");
INSERT INTO biv_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ala ɩ a Nãaŋmɩn Sɩɛ 'lɔ na sãɩ a Yesu a kũu pɔ, ben a yɩ 'yɔ̃ɔ, 'lɔ na sãɩ a Kɩrɩsɩto a kũu pɔ, na kʊn a yɩ ãgãn kũn nyɛvʊr tu a wʊ Sɩɛ pɔ, a 'lɔ na be a yɩ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","A lɛ jũu n yɛɛr, sɩ din sãn, tɩchɛ a ba ɩ a sɩ yelbier ãgãn nyã lɛ ɛ, a sɩn turo a lɛ wʊn bʊɔrɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Bojũu ala ɩ yɩ turo naa a lɛ a yɩ yelbier ãgãn na bʊɔrɔ, yɩn kpi naa, tɩchɛ ala ɩ yɩ den a Nãaŋmɩn Sɩɛ kʊ̃n a ãgãn ma maal bidɛbɛ bar, yɩ ben a nyɛvʊr sɔr pɔ. ");
INSERT INTO biv_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Bojũu bala jaa a Nãaŋmɩn Sɩɛ na chiine, bala lɛ ɩ a Nãaŋmɩn bibiir. ");
INSERT INTO biv_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","A ba ɩ a Nãaŋmɩn Sɩɛ wʊn kʊ yɩ, waa maala yɩ gbãgbaar ka a dãbãɛ kʊrɔ yɩ go ɛ, tɩchɛ wʊ kʊ yɩn a wʊ Sɩɛ a yɩ lɩɛb a wʊ bibiir. A Sɩɛ nyã lɛ sɩ ma de bʊɔlɔ wʊ, “N Sãa Nãaŋmɩn.” ");
INSERT INTO biv_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","A Nãaŋmɩn Sɩɛ mãɛ din dãasɩɛ nɩ a sɩ sɩɩr ɩka sɩ ɩn Nãaŋmɩn bibiir. ");
INSERT INTO biv_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Pʊ̃pãanyã, ala ɩ sɩ ɩ naa Nãaŋmɩn bibiir, sɩn lɛ so a bʊ̃sʊ̃n ala a Nãaŋmɩn na tɩr a wʊ nɛɛ, 'matãan a Kɩrɩsɩto. Ala ɩ sɩrɛ jaa, sɩ lɔ̃ɔn wʊn di a wʊ dɔɔyɛ, lɛ lɛ sɩ mɩn 'matãan wʊ põ a wʊ tɩɩr. ");
INSERT INTO biv_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","N man nyɛ a sɩ dɩna dɔɔyɛ ka waa jã bon ɛ, ɩn de man a Nãaŋmɩn tɩɩr 'lɔ na wa nyɩr a sɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","A bʊ̃maalsɩ a jaa nyʊnyʊlɔ naa chɩlɛ nɩ a Nãaŋmɩn bibiir wʊn wa vɛ̃ a ba nyɩrɛ. ");
INSERT INTO biv_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Bojũu a bʊ̃maalsɩ a jaa ben a ãgãn sal pĩlem an ba ɩ a ba mãɛ bɔfʊ ɛ, ");
INSERT INTO biv_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","tɩ ɩ a 'lɔ na maal ba bɔfʊ, na wʊ chɛnɛ tara ba nɩ tɩɛr sʊ̃, ɩka a Nãaŋmɩn na wa faa ban yin a gbãgbaa 'lɔ na sɔ̃ɔnɔ̃ kpɛ a mãɛ sofʊ 'lɔ na ɩ a Nãaŋmɩn bibiir tɩɩr pɔ. ");
INSERT INTO biv_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Bojũu sɩ bɔ̃ɔn naa a bʊ̃maalsɩ a jaa na hʊ̃nɔ̃, ka a ɔɔrɔ ba fɩka pɔɔ na dɔɔrɔ yi a lɛ daar jaa wa tãn a dɩna. ");
INSERT INTO biv_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","A ba ɩ lɛ tɛɛ lɛ ɛ, tɩchɛ a sɩn mãɛ lɛ tara a Nãaŋmɩn Sɩɛ kʊfʊ bidɔ̃ɔ, mɩ ʊrɔ a sɩ pʊɔm na sɩ nyʊnyʊlɔ chɛlɛ nɩ wʊn wa lɩɛb sɩ a wʊ bibiir, nɩ a faafʊ wʊn wa faan a sɩ ãgãma. ");
INSERT INTO biv_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","A tɩɛrtɔ nyãna jũu lɛ sɩ nyɛn a faafʊ. Tɩchɛ bon fʊn nyɛn nɩbir, fʊ maa lɛ tara a wʊ tɩɛr go ɛ. An lɛ ma tɩɛrɛ bon wʊn tara baar? ");
INSERT INTO biv_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Tɩchɛ ala ɩ sɩ tɩɛrɛ na bon sɩn ba tara sɛrɛ ɛ, sɩ ma din kãnyir chɛlɛ. ");
INSERT INTO biv_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","A lɛ nɩ wʊ ju mɩ lɛ a Nãaŋmɩn Sɩɛ ma sʊ̃nɔ̃ sɩ a sɩ balfʊ pɔ. Saa bɔ̃ɔ a lɛ sɩn taa ma sʊɔr a Nãaŋmɩn ɛ, a Nãaŋmɩn Sɩɛ mãɛ lɛ ma de hʊ̃ʊnfʊ 'lɔ sɩn kʊ̃ tʊ̃ɔ man a 'yɛrbie ɛ, na wʊ ma sʊɔrɔ kʊrɔ sɩ. ");
INSERT INTO biv_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Nɩrɛ 'lɔ na ma chɛl a sɩ nyãa bɔ̃ɔn a Nãaŋmɩn Sɩɛ tɩɛr, bojũu a Nãaŋmɩn Sɩɛ nyãna lɛ sʊɔrɔ a Nãaŋmɩn kʊrɔ a wʊ nɩbɛ nɩ a lɛ wʊn bʊɔrɔ. ");
INSERT INTO biv_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Sɩ bɔ̃ɔn naa ɩka a yele a jaa pɔ, Nãaŋmɩn ma tʊ̃n ka a ɩ sʊ̃ kʊ a bala na nʊ̃ wʊ, a bala wʊn tu a wʊ tɩɛr pɔ bʊɔl. ");
INSERT INTO biv_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Bojũu bala a Nãaŋmɩn na de nie bɔ̃ɔn na wʊ chɛl ir ka ba lɩɛb kaara a wʊ Bie kaar, ka wʊn ɩ a yɛɛr ba jaa pɔ Bidadɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","A bala wʊn de nie ir, bala lɛ wʊ bʊɔl, a bala wʊn bʊɔl, bala lɛ wʊ vɛ̃ ka a ba yele tor, a bala mɩ wʊn vɛ̃ ka a ba yele tor, bala mɩ lɛ wʊ 'yɔ̃ɔ tɩɩr. ");
INSERT INTO biv_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Bo lɛ sɩn pãa 'yɛr nɩ a yele nyãna? Ala ɩ Nãaŋmɩn ben a sɩ sɛ̃, an lɛ na tʊ̃ɔ jɛb sɩ? ");
INSERT INTO biv_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","A 'lɔ na ba mɔ̃ɔ sɩ a wʊ mãɛ bie ɛ, tɩchɛ na wʊ sɔɔ bar sɔr ka ba kʊ wʊ a sɩ jũu, bo lɛ na ŋmaa wʊ sɔr ka wʊ kʊ̃ de a wʊ wãɛfʊ 'matãan a bomo a jaa kʊ sɩ ɛ? ");
INSERT INTO biv_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","An lɛ na tʊ̃ɔ 'yɛr 'yɛr dɔɔl a bala a Nãaŋmɩn na ir? Nãaŋmɩn mãɛ lɛ maal ba a ba tor. ");
INSERT INTO biv_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","An 'lɔ lɛ na tʊ̃ɔ 'yɔ̃ɔ ba 'yɛr? Nɩrɛ jaa ba be be ɛ. A Yesu Kɩrɩsɩto nyã na kpi, 'lɔ lɛ a Nãaŋmɩn mɩ sãɩ ka wʊ ir ɩ vʊr na wʊ ara Nãaŋmɩn nũsʊ̃ɔ jie, 'lɔ lɛ sʊɔrɔ a Nãaŋmɩn kʊrɔ sɩ. ");
INSERT INTO biv_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","An lɛ na tʊ̃ɔ tɔɔ sɩ yin a Kɩrɩsɩto nʊ̃fʊ nyã pɔ? Wõm, bɩɩ wʊʊr, bɩɩ gefʊ, bɩɩ kɔ̃, bɩɩ sal'mʊɔr, bɩɩ dɔɔyɛ, bɩɩ ban na kʊ sɩ nɩ sʊɔ? ");
INSERT INTO biv_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Nɩtãa lɛ an sɛb a Nãaŋmɩn gãn pɔ, “A yɩ jũu, sɩ ma tuor kũu bɩbir jaa. Ba ma kaa sɩn fɩka piir ban chiine nɩ kɔkɔɛ ŋmafʊ jie.” ");
INSERT INTO biv_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Kai, a anyãna a jaa pɔ, sɩ ɩ naa tʊ̃tʊ̃ɔnbɔ tu a 'lɔ na nʊ̃ sɩ 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Bojũu n bɔ̃ɔn sɩrɛ jaa ɩka kũu, bɩɩ nyɛvʊr, bɩɩ malakasɩ, bɩɩ a sɩdɛbɛ, bɩɩ ka dɩna lɛ, bɩɩ nɩdaar, bɩɩ ka kpãɛn dẽme lɛ, ");
INSERT INTO biv_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ka dofʊ lɛ, bɩɩ suufʊ lɛ, bɩɩ bon jaa na be a bʊ̃maalsɩ pɔ lɛ, ãsʊɔ jaa kʊ̃ tʊ̃ɔ tɔɔ sɩ yin a nʊ̃fʊ a Nãaŋmɩn na nʊ̃ sɩ a sɩ Soro Yesu Kɩrɩsɩto 'yɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Yelmãɛ lɛ n 'yɛrɛ a Kɩrɩsɩto 'yɔ̃ɔ, n ba ŋmara jirsɩ ɛ, a n tɩɛr mɩ din dãasɩɛ a Nãaŋmɩn Sɩɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Nɩbaal kpɛ man tɩ põn bar, ka wʊʊr sɛɛ ma a nyãa. ");
INSERT INTO biv_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","An taa nʊ̃mɔ̃ ma naa ɩka n ben pɔ'yɔ̃ɔfʊ pɔ naa ba lɛ pʊɔ a Kɩrɩsɩto pɔ ɛ, a n yɛɛr Isɩral nɩbɛ jũu, bala lɛ ɩ a n mãɛ nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","A Isɩral nɩbɛ bala lɛ a Nãaŋmɩn de ka ba ɩ a wʊ bibiir, na wʊ kʊ ba a wʊ tɩɩr nɩ a nɛtɩrsɩ wʊn pɔn ba, na wʊ kʊ ba a nɛbinãa, nɩ a lɛ ban na puoro wʊ a wʊ puorfʊ yir nɩ a nɛɛr wʊn tɩr kʊ ba. ");
INSERT INTO biv_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Bala lɛ ɩ a sãakpãmɩne, a ba pɔ lɛ ba bɩɛr a Kɩrɩsɩto mɩ na ɩ a nɩsaal yi, na wʊ ɩ a Nãaŋmɩn kaara a bomo a jaa, 'lɔ lɛ ban pɛɛrɛ bɩbir jaa. A ɩ a lɛ. ");
INSERT INTO biv_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","A ba ɩ fɩka a Nãaŋmɩn 'yɛr ɩn faa ɛ, bojũu a ba ɩ a bala jaa ban dɔɔ a Isɩral nɩbɛ pɔ, ba jaa lɛ ɩ a Isɩral nɩbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","A ba ɩ baa yi a wʊ par pɔ ɛ, ba jaa baa ɩ Abraham bibiir ɛ, tɩchɛ Nãaŋmɩn dɔ̃ɔ tɩr nɛɛ kʊ a Abraham ɩka, “Isaakɩ 'yɔ̃ɔ lɛ a fʊ yɔn na yi.” ");
INSERT INTO biv_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","A ba ɩ a ãgãn vaar bibiir lɛ ɩ a Nãaŋmɩn bibiir ɛ, tɩchɛ a bibiir bala a Nãaŋmɩn na tɩr a nɛɛ a wʊ dɔɔ, bala lɛ wʊ kaa a ba ɩ Abraham bibiir. ");
INSERT INTO biv_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Bojũu nɩtɔ̃ lɛ a Nãaŋmɩn dɔ̃ɔ tɩr a nɛɛ 'yɛr, “A daar wa ta, ɩn lɩɛb wa ka a Saara dɔɔ dabile.” ");
INSERT INTO biv_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","A ba ɩ anyã tɛɛ lɛ ɛ, tɩchɛ a Worbɛka dɔɔn dabil ayi ka ba sãa ɩ bʊ̃'yen tɛɛ na ɩ a sɩ sãakpã Isaakɩ. ");
INSERT INTO biv_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Sɛrɛ tɩ ka wʊ wa dɔɔ a yɩbɛ banyãna, baa mɩ maal yele jaa vɩla bɩɩ dɛɛr ɛ, tɩ nɩtɔ̃ lɛ a ɩ ɩka a Nãaŋmɩn bɔfʊ pɔ lɛ wʊ ma tu ir a nɩrɛ. ");
INSERT INTO biv_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","A kʊ̃ ɩ a fʊ tʊ̃mɔ̃ jũu ɛ, tɩchɛ a 'lɔ na bʊɔl fʊ. Nãaŋmɩn 'yɛr kʊ a Worbɛka, “A yɛkarma na tʊ̃nɔ̃ na kʊrɔ a yɛbile.” ");
INSERT INTO biv_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Lɛ mɩ lɛ a sɛb a Nãaŋmɩn gãn pɔ, “N nʊ̃n Jekɔb tɩchɛ naa 'laar a Esau.” ");
INSERT INTO biv_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Bo lɛ sɩn pãa lɛ 'yɛr? Nãaŋmɩn ɩn nɩfɩlefɩle bɩɩ? Kai. Sɔr ba be be ɛ! ");
INSERT INTO biv_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Bojũu wʊ 'yɛr kʊ a Mosesɩ, “Nɩrɛ 'lɔ ɩn na kaa nɩbaal lɛ ɩn na kaa nɩbaal, naa maal vɩla kʊ a 'lɔ ɩn na maal vɩla kʊ.” ");
INSERT INTO biv_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","A lɛ jũu a ba ɩ lɛ nɩrɛ na bʊɔrɔ ɛ, bɩɩ na tʊ̃nɔ̃ lɛ ɛ, tɩchɛ a yin Nãaŋmɩn nɩbaal kaafʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Bojũu Nãaŋmɩn dɔ̃ɔ 'yɛr kʊ a Ijipitɩ nãa Faaro ɩka yaa, “Maa lɛ bin fʊ a yele nyãna jũu, ɩka n wiil a n kpɛ̃ɔ a fʊ 'yɔ̃ɔ, ka ban bʊɔl a n yuor a wɛr wʊ jaa.” ");
INSERT INTO biv_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","A lɛ jũu, Nãaŋmɩn ma kãan nɩrɛ 'lɔ wʊn bʊɔrɔ nɩbaal, a 'lɔ wʊ mɩn bʊɔrɔ, wʊ ma vɛ̃n ka a wʊ nyãa kpɛ̃mɛ. ");
INSERT INTO biv_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Ɩ̃sʊɔ na sʊʊr ma naa ɩka, “Bo lɛ so ka a Nãaŋmɩn na de yele dɔɔl sɩ? Bojũu nɩrɛ jaa kʊ̃ tʊ̃ɔ tɔr a lɛ a Nãaŋmɩn na bʊɔrɔ ɛ?” ");
INSERT INTO biv_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Tɩchɛ fʊ̃ʊ mɩ nɩ ana, nɩsaal na fʊn 'yɛr lɩɛr Nãaŋmɩn? “Laa na tʊ̃ɔn sʊʊr a 'lɔ na mɛ wʊ ɩka, ‘Bo lɛ fʊ mɛ ma a nɩtɔ̃ ɔ?’ ” ");
INSERT INTO biv_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","A lamɩɛrɛ ba tara sɔr ɩka wʊ de a yɔɔr bʊ̃'yen 'lɔ̃nɔ̃ mɛn bʊ̃ʊdʊʊ tɩchɛ mɛn ladiraa ɛ? ");
INSERT INTO biv_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Bo lɛ, ala ɩ Nãaŋmɩn lɛ kaa ir ɩka wʊ wiil a wʊ suur na wʊ vɛ̃ a ba bɔ̃ɔn a wʊ kpɛ̃ɔ, tɩ na wʊ chɛnɛ tara kãnyir nɩ a bonsɩ ala wʊn chɔɔr gun a sɔ̃ɔ barfʊ? ");
INSERT INTO biv_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Bo lɛ, ala ɩ wʊ maal a nɩtɔ̃ ɩka a bonsɩ ala na ɩ a wʊ nɩbaal bomo, ka a bɔ̃ɔn a wʊ tɩɩr tɔ̃nɔ̃, a bala wʊn de nie chɔɔr gun a wʊ tɩɩr, ");
INSERT INTO biv_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","a sɩn gba wʊ mɩ na bʊɔl, na ba ɩ a Juu nɩbɛ tɛɛ ɛ, tɩchɛ na wʊ bʊɔl a bala na ba ɩ a Juu nɩbɛ mɩ? ");
INSERT INTO biv_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nɩtãa lɛ a Nãaŋmɩn na vɛ̃ ka a wʊ 'yɛ'yɛrɛ Hosea sɛb a wʊ gãn pɔ, “Ɩn bʊɔl ban a maa nɩbɛ, a bala na ba ɩ a n nɩbɛ ɛ, naa bʊɔl wʊ a n nɩ nʊ̃ naa, 'lɔ na ba dɔ̃ɔ ɩ a n nɩ nʊ̃ naa ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ka wʊ sɛb a nɩtɔ̃nɔ̃ an ɩ a jie 'lɔ̃nɔ̃ wʊn 'yɛr ɩka, “Yaa ɩ a n nɩbɛ ɛ, bala naa lɛ ban lɛ bʊɔl a Nãaŋmɩn vʊr bibiir.” ");
INSERT INTO biv_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isaiya mɩ dɔ̃ɔ mʊɔl a Isɩral nɩbɛ na wʊ 'yɛr, “Ala ɩ a Isɩral nɩbɛ gba waan fɩka man nɛɛ bire, a bãlãa bala na wa chɛ, lɛ na nyɛ faafʊ. ");
INSERT INTO biv_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Bojũu a sɩ Soro na pɔɔn naa a wʊ 'yɛr tɔɔrfʊ na wʊ ŋmaa a ju.” ");
INSERT INTO biv_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Isaiya dɔ̃ɔn de nie 'yɛr, “Ala ba ɩ a sɩ Soro na ɩ a gãdaa jaa gãdaa sʊɔ lɛ dɔ̃ɔ bar a sɩ par ŋmaa ɛ, sɩn taa mɩ nyʊɔl kaara a Sodom nɩ a Gomora tẽn kaar.” ");
INSERT INTO biv_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Bo lɛ sɩn pãa lɛ 'yɛr? A bala na ba ɩ a Juu nɩbɛ ɛ, na ba dɔ̃ɔ turo a yeltorsɩ ɛ, bala lɛ be tara yaa. A ba yele tor naa ban tara sɔɔfʊ jũu. ");
INSERT INTO biv_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Tɩchɛ a Isɩral nɩbɛ na turo a yeltorsɩ ba tara yaa ɛ, ");
INSERT INTO biv_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Bo lɛ so? Bojũu baa turo nɩ sɔɔfʊ ɛ, tɩ turo nɩ tʊ̃mɔ̃, na ba bãr a kʊsɩr bãraa. ");
INSERT INTO biv_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Nɩtãa lɛ na sɛb a Nãaŋmɩn gãn pɔ a wʊ 'yɛr, “Nyɛ, n bin a kʊsɩr be a Jiyon ka nɩbɛ na bãra nɩ a pie 'lɔ na vɛ̃ ka ba loro, ka nɩrɛ 'lɔ jaa na sɔɔ de wʊ, vã kʊ̃ kpɛ wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","N yɛɛr, lɛ a n nyãa na bʊɔrɔ ka n sʊɔrɔ nɩ Nãaŋmɩn lɛ ɩka, a Isɩral nɩbɛ ba nyɛ faafʊ. ");
INSERT INTO biv_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Bojũu ɩn tʊ̃ɔn di a ba dãasɩɛ ɩka ba tara na nɩbijɩɛ nɩ a Nãaŋmɩn yele, tɩchɛ bɔ̃ɔfʊ lɛ ba pʊɔ a ba nɩbijɩɛ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ban ba bɔ̃ɔ a Nãaŋmɩn yeltorsɩ ɛ, tɩ na ba bʊɔrɔ ɩka ba bin a ba mãɛ yeltorsɩ, baa siir ba mãɛ kʊ a Nãaŋmɩn yeltorsɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kɩrɩsɩto lɛ ɩ a nɛbinãa tɛɛfʊ jie, ka nɩrɛ jaa na sɔɔ de wʊ, wʊn vɛ̃n ka a nɩnyɩnɛ yele tor. ");
INSERT INTO biv_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Nɩtɔ̃ lɛ a Mosesɩ man a lɛ a nɛbinãa na ma vɛ̃ ka nɩrɛ yele tor, “A nɩrɛ 'lɔ na maala a lɛ a nɛbinãa na 'yɛr, na tara na nyɛvʊr.” ");
INSERT INTO biv_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Tɩchɛ a yeltorsɩ ala na yire a sɔɔfʊ pɔ 'yɛr naa, “Ta tɩɛr a fʊ nyãa pɔ sʊʊr ɩka, ‘An lɛ na do a saaju?’ Ka a lɛ wiil ɩka, tɩ tara a Kɩrɩsɩto suu waan. ");
INSERT INTO biv_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Bɩɩ sʊʊr a fʊ mãɛ ɩka, ‘An lɛ na chen a kpĩi tẽe?’ ” Ka a lɛ wiil ɩka, tɩ ir a Kɩrɩsɩto a kũu pɔ waan. ");
INSERT INTO biv_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Tɩchɛ bo lɛ a 'yɛr a Nãaŋmɩn gãn pɔ? “A 'yɛr gbʊr fʊ naa, a ben a fʊ nɛɛ pɔ, naa be a fʊ nyãa pɔ.” Ala lɛ ɩ a sɔɔfʊ 'yɛr nyã sɩn mʊɔlɔ. ");
INSERT INTO biv_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Ala ɩ fʊ haan a fʊ nɛɛ chiir a fʊ pʊɔ 'yɛr ɩka, “A Kɩrɩsɩto lɛ ɩ a Soro,” na fʊ sɔɔn a fʊ nyãa wʊ jaa ɩka, Nãaŋmɩn ir wʊn a kũu pɔ, fʊn nyɛn faafʊ. ");
INSERT INTO biv_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Bojũu a fʊ nyãa 'lɔ fʊn sɔɔ den lɛ na vɛ̃ ka a fʊ yele tor, ka a fʊ nɛɛ 'lɔ fʊn haan 'yɛr lɛ na faafʊ. ");
INSERT INTO biv_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Nɩtãa lɛ an sɛb a Nãaŋmɩn gãn pɔ, “Nɩrɛ 'lɔ jaa na sɔɔ de wʊ, vã kʊ̃ kpɛ wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Bojũu tɛɛ taa ba be a Juu nɩrɛ nɩ a 'lɔ na ba ɩ a Juu nɩrɛ ɛ. A Soro bʊ̃'yen 'lɔ̃nɔ̃ lɛ ɩ ba jaa Soro, na wʊ sʊ̃nɔ̃ a bala jaa na bʊɔlɔ a wʊ yuor. ");
INSERT INTO biv_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Bojũu a sɛb a Nãaŋmɩn gãn pɔ ɩka, “Bala jaa na bʊɔlɔ a Soro yuor ɩka wʊ sʊ̃ʊ ba, na nyɛn faafʊ.” ");
INSERT INTO biv_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ŋmɩnɛ lɛ ban ɩrɛ wa bʊɔl a Nãaŋmɩn 'lɔ ban ba sɔɔ ɛ? Ŋmɩnɛ lɛ ban ɩ wa sɔɔ a nɩrɛ 'lɔ ban ba wõ a wʊ 'yɛr ɛ? Ŋmɩnɛ lɛ ban ɩrɛ wa wõ a wʊ 'yɛr ka nɩrɛ kɔ̃ɔ ba wa mʊɔl a wʊ 'yɛr kʊ ba ɛ? ");
INSERT INTO biv_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Ŋmɩnɛ lɛ ban ɩrɛ wa mʊɔl ka baa tʊ̃ ba ɛ? Nɩtãa lɛ an sɛb a Nãaŋmɩn gãn pɔ, “Nyɛ lɛ a bala na waara nɩ a 'yɛr nʊ̃ɔ gbɛɛ na vɩɛlɛ ka.” ");
INSERT INTO biv_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Tɩchɛ a ba ɩ a Isɩral nɩbɛ ba jaa lɛ lɩɛb kaa a 'yɛr nʊ̃ɔ nyã ɛ. Bojũu Isaiya dɔ̃ɔ sʊʊr, “Sɩ Soro, an lɛ sɔɔ de a sɩ 'yɛr?” ");
INSERT INTO biv_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Sɩrɛ jaa lɛ ɩka 'yɛr fʊn ma wõ pɔ lɛ fʊ ma sɔɔ, ka a 'yɛrbie ala ban wõ ɩn a Kɩrɩsɩto 'yɛr. ");
INSERT INTO biv_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Tɩchɛ ka n sʊʊr, a mɔ̃ baa wõ naa ɛ? Sɩrɛ jaa lɛ ba wõ naa naa. “A ba kɔkɔr yin de jie wʊ jaa, ka a ba 'yɛr tɩ ta a wɛr tɛɛfʊ jie.” ");
INSERT INTO biv_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","N lɛ sʊʊr kaa go, a mɔ̃ a Isɩral nɩbɛ ba bɔ̃ɔ a par ɛ? Mosesɩ dɔ̃ɔ de nie 'yɛr, “A bala na ba ɩ paal ɛ, ɩn maal ba naa ka nyuur kpɛ yɩ, naa lɛ maal a paal 'lɔ na ba bɔ̃ɔ bon jaa ɛ, ka suur kpɛ yi.” ");
INSERT INTO biv_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ka Isaiya mɩ ba dɔ̃ɔ jo dãbãɛ ɛ, tɩ 'yɛr ɩka, “A bala na ba dɔ̃ɔ yʊɔrɔ bʊɔrɔ ma ɛ, ba nyɛ ma naa, n wiil naa n mãɛ kʊ a bala na ba dɔ̃ɔ sʊrɔ ma ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Tɩchɛ a Isɩral nɩbɛ 'lɔ, nɩtɔ̃ lɛ wʊ 'yɛr, “Bɩbir jaa lɛ n ma tur a n nuur bʊɔlɔ a bibawõnsɩ nɩ a nɩdɛbɛ, na turo a sɔɩ ala na ba vɩɛlɛ ɛ bʊɔrɔ a ba mãɛ tɩɛrsɩ bʊ̃bʊɔrsɩ.” ");
INSERT INTO biv_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","N pãa sʊʊr naa, a Nãaŋmɩn ben tɔr a wʊ nɩbɛ bar bɩɩ? Kai! A maa mãɛ ɩn a Isɩral nɩrɛ, naa ɩ a Abraham yɔ̃ɔ yi a Benjamin bʊrɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Nãaŋmɩn ba tɔr a wʊ nɩbɛ bar ɛ, bala lɛ wʊ de nie bɔ̃ɔ. Yaa bɔ̃ɔ a lɛ a Nãaŋmɩn gãn na 'yɛr, lɛ a Elaija na dɔ̃ɔ sʊɔrɔ Nãaŋmɩn waala dɔɔlɔ a Isɩral nɩbɛ, ");
INSERT INTO biv_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“N Soro, ba kʊn a fʊ 'yɛ'yɛrbɛ, na ba wɛl a fʊ bɔɔr lofʊ jiir bar. Maa tɛɛ lɛ chɛ, tɩ a ba bʊɔrɔ a n kʊfʊ.” ");
INSERT INTO biv_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Bo lɛ a Nãaŋmɩn 'yɛr kʊ a Elaija? Wʊ 'yɛr naa, “N chɛnɛ na tara nɩbɛ tur ata kɔɔr anũu (7,000) na ba gbur dumo puor a tɩɩ Baal ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Lɛ mɩ lɛ a dɩna, nɩbɛ bamɩne chɛ naa ka Nãaŋmɩn na ir ba a wʊ wãɛfʊ jũu. ");
INSERT INTO biv_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Ala be ɩ a wãɛfʊ jũu lɛ, a ba lɛ ɩ tʊ̃mɔ̃ 'yɔ̃ɔ lɛ go ɛ, ka lɛ ba lɛ ɛ, a wãɛfʊ kʊ̃ lɛ ɩ wãɛfʊ lɛ go ɛ. ");
INSERT INTO biv_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Bo pãa lɛ? A ala a Isɩral nɩbɛ na bʊɔrɔ nɩbijɩɛ baa nyɛ ɛ, tɩchɛ a bala a Nãaŋmɩn na ir lɛ nyɛ. Ka a bala na chɛ kpɛ̃mɛ a ba nyãa. ");
INSERT INTO biv_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Nɩtãa lɛ an sɛb a Nãaŋmɩn gãn pɔ, “Nãaŋmɩn vɛ̃n ka ba ɩ jaa bũrtũm wa tãn a dɩna. A ba nɩbie ala maa tʊ̃ɔ nyɛ bon ɛ, ka a ba tobo ala maa tʊ̃ɔ wõ 'yɛr ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","A Nãa David mɩ dɔ̃ɔ 'yɛr a ba 'yɛr a wʊ gãn pɔ, “Vɛ̃ ka a ba bʊ̃diir difʊ jie ka a lɩɛb bʊ̃nyɔɔrsɩ nɩ chɛɛr, ka a ɩ a ba bãr lofʊ jie nɩ a ba sãyar. ");
INSERT INTO biv_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","A ba nɩbie a jɔ̃ɔ, a ba kʊ̃ tʊ̃ɔ nyɛ jaa ɛ, na ba kab gʊ̃mɔ̃ kʊ̃ lɛ tʊ̃ɔ dɔl ɛ.” ");
INSERT INTO biv_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","N lɛ sʊʊr go, ba ben bãr na lo na ba kʊ̃ tʊ̃ɔ ir jaa ɛ? A ba ɩ lɛ ɛ. A ba maal bɔrfʊ jũu, a bala na ba ɩ a Juu nɩbɛ ɛ, nyɛn faafʊ ka nyuur na kpɛ a Isɩral nɩbɛ. ");
INSERT INTO biv_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Tɩchɛ ala ɩ a ba maal bɔrfʊ vɛ̃n ka a wɛr wʊ jaa le, ka a ba bɔrfʊ mɩ le a bala na ba ɩ a Juu nɩbɛ ɛ, a bala mãɛ wa pʊɔ ŋmɩnɛ lɛ an kaara! ");
INSERT INTO biv_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Yɩn na ba ɩ a Juu nɩbɛ lɛ n 'yɛrɛ kʊrɔ, an ben ɩka maa lɛ a Nãaŋmɩn ir tʊ̃ a yɩ pɔ, ka n ɩ a nɩtʊ̃nãa a yɩn na ba ɩ a Juu nɩbɛ pɔ. N mʊ̃ɔn nɩbir nɩ a tʊ̃mɔ̃ nyã. ");
INSERT INTO biv_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","A maa tɩɛr lɛ ɩka nyuur wʊ kpɛ a maa mãɛ nɩbɛ ka n tʊ̃ɔ a bamɩne faa. ");
INSERT INTO biv_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Bojũu ala ɩ a ba tɔr barfʊ ɩn 'maalfʊ kʊ a wɛr, ka a Nãaŋmɩn lɛ wa de ba, ŋmɩnɛ lɛ an kaara, a kʊ̃ kaara fɩka nɩrɛ na yi kũu pɔ tara nyɛvʊr ɛ? ");
INSERT INTO biv_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Ala ɩ fʊ den a paanʊ̃dɔ̃ɔ kʊ Nãaŋmɩn, a paanʊ̃ɔ ala na chɛ, a jaa ɩn chɛchɛ. Ala ɩ fʊ den a tɩɛ nyɩɩr kʊ Nãaŋmɩn, a tɩɛ wilsɩ mɩ ɩn chɛchɛ. ");
INSERT INTO biv_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ala ɩ ba 'mɛl a tɩɛ mãɛ wile ãsʊɔ bar tɩ ŋmaa a yɩn na ɩ a mʊɔ pɔ tɩɛ wile wa mar ka yɩ 'mataa tɔɔrɔ nyuro a kɔ̃bʊ̃'yen yire a tɩɛ ãgãn pɔ nʊ̃ɔnɔ̃, ");
INSERT INTO biv_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","taa tɩɛr ɩka fʊ sa naa a wilsɩ ala ɛ. Fʊ̃ʊ wa 'mɔɔrɔ fʊ mãɛ, lɩɛb tɩɛr kaa ɩka a ba ɩ a fʊ̃ʊ na ɩ a wile lɛ tuo a nyɩbɛ ɛ, tɩ a nyɩbɛ lɛ tuo a fʊ̃ʊ na ɩ a wile. ");
INSERT INTO biv_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Yɩn 'yɛr yɩn pãa na 'yɛr nɩ nyã, “Ba 'mɛl a wilsɩ ala bar tɩ pãa na de ma mar.” ");
INSERT INTO biv_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","A lɛ ɩn yelmãɛ, tɩchɛ ba dɔ̃ɔ 'mɛl ba bar a ba ba sɔɔfʊ jũu, tɩchɛ ka a yɩn ara nɩ sɔɔfʊ. Yɩ ta bʊɔrɔ yuor ɛ, tɩchɛ yɩ joro dãbãɛ. ");
INSERT INTO biv_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Bojũu ala ɩ Nãaŋmɩn ba dɔ̃ɔ bar a tɩɛ mãɛ wilsɩ ɛ, wʊ kʊ̃ bar a yɩn mɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Yɩ tɩɛr kaa lɛ a Nãaŋmɩn na ɩ a maal vɩla sʊɔ ka a wʊ yele mɩ kpɛ̃mɛ, a wʊ yele kpɛ̃mɛ na kʊ a bala na lo, tɩchɛ na wʊ maal vɩla kʊ a yɩn, ala ɩ yɩ chɛnɛ na chiine a wʊ maal vɩla pɔ. Ka lɛ ba lɛ ɛ, wʊn ŋmaa yɩn bar. ");
INSERT INTO biv_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ala wa ɩ ba tɛɛn a ba baal bar, Nãaŋmɩn na tʊ̃ɔn de ba lɛ mar a tɩɛ 'yɔ̃ɔ, Nãaŋmɩn na tʊ̃ɔn lɛ de ba mar a lɛ go. ");
INSERT INTO biv_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Yɩ kaa, ala ɩ a yɩn ban ŋmaa yin a mʊɔ pɔ tɩɛ pɔ wa mar a yir tɩɛ ban sɛl, an lɛ ɩn tuo a yir tɩɛ wilsɩ ala ban dɔ̃ɔ 'mɛl bar marfʊ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","N ba bʊɔrɔ ɩka n vɛ̃ ka a yelsɔɔlaa nyã sɔɔl a yɩn na ɩ a n yɛɛr tɩ ba ɩ a Isɩral nɩbɛ ɛ, ka yɩ taa bʊɔrɔ yuor nɩ a yele nyã ɛ. A Isɩral nɩbɛ tara na a nyãkpãɛn a lɛ nɛ na tɩ tãn a sɔ̃ɔ 'lɔ a bala na ba ɩ a Isɩral nɩbɛ ɛ, na wa tɩ nyɛ a faafʊ baar. ");
INSERT INTO biv_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Lɛ lɛ na ɩ tɩ a Isɩral nɩbɛ ba jaa pãa nyɛ faafʊ nɩtãa lɛ na sɛb a Nãaŋmɩn gãn pɔ, “Fafaara na yin be a Jiyon wa, na wʊ wa lɩɛb tɩɛr jaa na ba vɩɛlɛ ɛ, yin a Jekɔb bal nɩbɛ pɔ bar. ");
INSERT INTO biv_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","A nɛtɩraa lɛ a nyãna ɩn na tara nɩ ba, a sɔ̃ɔ 'lɔ ɩn wa de a ba yeldɛbɛ a jaa bar.” ");
INSERT INTO biv_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Fʊ̃ʊ kaa, a 'yɛr nʊ̃ɔ nyã vɛ̃n ka ba ɩ Nãaŋmɩn dɔ̃dẽme a yɩn na sɔɔ de jũu. Tɩchɛ ala ɩ a irfʊ pɔ mɩ lɛ, bala lɛ a Nãaŋmɩn nʊ̃ yɔɔ a ba sãakpãmɩne jũu. ");
INSERT INTO biv_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Bojũu Nãaŋmɩn kʊfʊ nɩ a wʊ bʊɔlfʊ kʊ̃ tʊ̃ɔ lɩɛb jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Nɩtãa lɛ a yɩn mɩ na ba ɩ a Juu nɩbɛ ɛ, na yaa dɔ̃ɔ wõnõ a Nãaŋmɩn toor ɛ, tɩchɛ pʊ̃pãanyã yɩ nyɛn a wʊ nɩbaal a ba bawõfʊ jũu. ");
INSERT INTO biv_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Lɛ lɛ a bala mɩ na ɩ a Juu nɩbɛ, ba mɩ lɩɛb ɩ bawõnsɩ, na ba pãa mɩ na nyɛ a Nãaŋmɩn nɩbaal a pʊ̃pãanyã, nɩtãa lɛ a sɩn mɩ na nyɛ a Nãaŋmɩn nɩbaal. ");
INSERT INTO biv_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Bojũu Nãaŋmɩn pɔɔn a nɩbɛ ba jaa a bawõnsɩ die pɔ, na wʊn tʊ̃ɔ kaa ba jaa nɩbaal. ");
INSERT INTO biv_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Nyɛ lɛ a Nãaŋmɩn lefʊ na suu jã. A wʊ yɛ̃ nɩ a wʊ bɔ̃ɔfʊ ba gbʊr ɛ! A wʊ 'yɛr tɔɔrfʊ ba be bɔ̃ɔfʊ ɛ. A wʊ sɔɩ mɩ ba be bɩɛrfʊ ɛ! ");
INSERT INTO biv_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“An lɛ dɔ̃ɔ bɔ̃ɔ a sɩ Soro tɩɛr? Bɩɩ an lɛ mɩ dɔ̃ɔ ɩ a wʊ 'yɛr sʊ̃nɔ̃.” ");
INSERT INTO biv_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","“An lɛ dɔ̃ɔ de nie kʊ Nãaŋmɩn bon, ka wʊ pãa wa yara a sãn?” ");
INSERT INTO biv_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Bojũu wʊ jie lɛ a bomo a jaa yi. 'Lɔ lɛ maal a jaa, na wʊ so a bonsɩ a jaa. 'Lɔ lɛ so a tɩɩr bɩbir nɩ bɩbir jaa. A ɩ a lɛ. ");
INSERT INTO biv_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","A lɛ jũu, n sʊɔrɔ yɩ naa yɛɛr, a Nãaŋmɩn nɩbaal nyã jũu, yɩ de a yɩ mãɛ na ɩ bʊ̃nɩbie lon bɔɔr kʊ Nãaŋmɩn. A ɩn chɛchɛ naa pɛlɛ a Nãaŋmɩn pʊɔ. Lɛ lɛ ɩ a puorfʊ na tara par. ");
INSERT INTO biv_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Yɩ taa lɛ wa lɩɛrɛ maala a lɛ a wɛr nɩbɛ na maala go ɛ, tɩchɛ yɩ maala a lɛ na lɩɛrɛ yɩ a tɩɛr paalaa nyã yɩn nyɛ. Yɩn pãa tʊ̃ɔn bɛɛr na yɩ bɔ̃ɔ a Nãaŋmɩn bɔfʊ, a ala na ɩ vɩla naa pɛlɛ a wʊ pʊɔ naa ɩ chɛchɛ. ");
INSERT INTO biv_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","A Nãaŋmɩn wãɛfʊ nyã wʊn wãɛ ma jũu, n sʊɔrɔ naa a yɩ ãsʊɔ jaa ɩka, ta tɩɛr a yɩ mãɛ tɩ põn bar a lɛ yɩn taa tɩɛr ɛ, tɩchɛ yɩ ma tɩɛr a yɩ mãɛ 'yɛr tɔɔrfʊ nɩbijɩɛ jaa jã a sɔɔfʊ 'lɔ a Nãaŋmɩn na kʊ yɩ. ");
INSERT INTO biv_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Nɩtãa lɛ a sɩ ãsʊɔ jaa na tara ãgãn tɩ ka a tara jidẽdẽme, a jidẽdẽme anyãna ba tʊ̃nɔ̃ tʊ̃bʊ̃'yen ɛ. ");
INSERT INTO biv_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Lɛ mɩ lɛ a Kɩrɩsɩto pɔ, a sɩn bala na ɩ yɔɔ tɩ lɔ̃ɔ ãgãn bʊ̃'yen pɔ, a jidẽdẽme anyã a jaa 'mantaa tʊ̃nɔ̃. ");
INSERT INTO biv_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Sɩ jaa tara na kʊfʊsɩ na tɛɛ taa, tu a lɛ a Nãaŋmɩn wãɛfʊ wʊn wãɛn sɩ. Ala ɩ a ãsʊɔ kʊfʊ ɩn a Nãaŋmɩn 'yɛr 'yɛrfʊ lɛ, wʊ ma 'yɛrɛ jã a lɛ a wʊ sɔɔfʊ na ta. ");
INSERT INTO biv_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ka ala ɩ tʊ̃mɔ̃ tʊ̃fʊ mɩ lɛ, vɛ̃ ka wʊ ma tʊ̃nɔ̃, ala ɩ wiilfʊ mɩ lɛ, vɛ̃ ka wʊ ma wile. ");
INSERT INTO biv_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Ala ɩ ãkpɛ̃ɔ 'yɔ̃ɔfʊ lɛ, vɛ̃ ka wʊ ma 'yɔ̃ɔnɔ̃ a ãkpãɛn. Ka ala ɩ a wʊ kʊfʊ lɛ nɩbaalsɩ sʊ̃ʊfʊ, vɛ̃ ka wʊ ma sʊ̃nɔ̃ ba nɩ pʊpɛl. Ala ɩ nɩdiere tʊ̃mɔ̃ lɛ, vɛ̃ a wʊ ma mʊ̃ɔ nɩbir nɩ a tʊ̃mɔ̃. Ala wa ɩ nɩbɛ 'maalfʊ tʊ̃mɔ̃ lɛ, wʊ ma maala a lɛ nɩ chɩlfʊ. ");
INSERT INTO biv_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Nʊ̃fʊ wʊ ɩ yelmãɛ nʊ̃fʊ. 'Laar bon 'lɔ na ɩ dɛɛr, tɩ 'mar bon 'lɔ na ɩ sʊ̃. ");
INSERT INTO biv_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Yɩ chɛlɛ taa yele, na yɩ de a yɛɛr nʊ̃fʊ nʊ̃n taa. Yɩ 'yɔ̃ɔnɔ̃ a yɩ taaba gar a yɩ mãɛ. ");
INSERT INTO biv_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Yɩ ta ɩ nɩ tũtũlsɩ ɛ, tɩchɛ yɩ vɛ̃ ka a nʊ̃mɔ̃ yɩ a yɩ mʊ̃ɔ nɩbir nɩ a sɩ Soro tʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Yɩ chɩlɛ nɩ a yɩ tɩɛrtɔfʊ jie, na yɩ tara kãnyir a yɩ wõm pɔ, na yɩ tara yelmãɛ nɩ a yɩ Nãaŋmɩn sʊɔrfʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Yɩ ma lɔ̃ɔ põn a Nãaŋmɩn nɩbɛ bala na ba tara bon jaa ɛ, na yɩ ma diere sãanba a yɩ yie pɔ. ");
INSERT INTO biv_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Na yɩ 'yɛrɛ nɛvɩla 'yɔ̃ɔnɔ̃ a bala na gere yɩ, na yɩ 'yɛr nɛvɩla 'yɔ̃ɔ ba, yɩ ta pɔ 'yɔ̃ɔ ba ɛ. ");
INSERT INTO biv_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Yɩ chɩlɛ nɩ a bala na chɩlɛ, na yɩ mɩ pʊɔ a bala na kõnõ na yɩ kõnõ. ");
INSERT INTO biv_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","A yɩn nɩ a bala na kpɩɛrɛ, yɩ tara tɩɛr bʊ̃'yen. Yɩ ta kaara ba pɔrɔ ɛ, tɩchɛ yɩ sɔɔ 'matãan a nɩbɛ bala na ba jã yɩ ɛ. Yɩ ta kaa ɩka yɩn ɩn yɛ̃ dẽme ɛ. ");
INSERT INTO biv_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Yɩ ta de bier yãan bier sãn ɛ. Yɩ bɔ̃ɔnɔ̃ sʊ̃, na yɩ maala a ala na vɩɛlɛ nɩrɛ jaa niem. ");
INSERT INTO biv_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Ala ɩ an tʊ̃ɔ naa, an ɩ yɩn mãɛ lɛ, yɩ tara nyã'maar nɩ a bala jaa yɩn lɔ̃ɔ kpɩɛrɛ nɩ. ");
INSERT INTO biv_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","N barmɩne, yɩ taa ɩrɛ wa yaara taa sãn ɛ, tɩchɛ yɩ baraa kʊ a Nãaŋmɩn suur. Bojũu a sɛb a Nãaŋmɩn gãn pɔ ɩka, “Maa lɛ so a sãn yaafʊ, ɩn lɩɛb yaa a sãn.” Lɛ lɛ a Soro 'yɛr. ");
INSERT INTO biv_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Lɛ an na ɩ lɛ ɩka, “Ala ɩ kɔ̃ kpɛ̃n a fʊ dɔ̃sʊɔ, kʊ wʊ bʊ̃diir a wʊ di. Ala ɩ kɔ̃nyũur wa kpɛ wʊ naa, kʊ wʊ kʊ̃ɔ a wʊ nyũ. Fʊ̃ʊ be maala a nɩtɔ̃, an kaara fɩka bũu saalbie lɛ fʊ mʊ̃ɔ dɔɔl wʊ a jum.” ");
INSERT INTO biv_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Yɩ ta vɛ̃ ka bier tʊ̃ɔ yɩ ɛ, tɩchɛ yɩ de vɩla tʊ̃ɔn bier. ");
INSERT INTO biv_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","A yɩ ãsʊɔ jaa wʊ ma siir a wʊ mãɛ kʊ a paal nɩbɛrɛ, bojũu kpɛ̃ɔ jaa ba be be ka a ba ɩ Nãaŋmɩn lɛ bin ɛ. Kpɛ̃ɔ sʊɔ jaa ba be be ka Nãaŋmɩn ba lɛ bin wʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","A lɛ jũu, nɩrɛ 'lɔ jaa na chɩrɛ nɩ a kpãɛn dẽme ba nyãna, a Nãaŋmɩn na bin ba lɛ wʊ chɩrɛ nɩ, ka a bala na ɩrɛ a lɛ na 'yɔ̃ɔn ba mãɛ 'yɛr. ");
INSERT INTO biv_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Bojũu a kpãɛn dẽme maa diere bier dɔɔlɔ a bala na maala vɩla ɛ, tɩchɛ a bala na maala a dɛɛr lɛ ba ma de yele dɔɔlɔ. Fʊ bʊɔrɔ naa ɩka fʊ ta joro a kpãɛn dẽme dãbãɛ bɩɩ? Fʊ pãa maala a lɛ na vɩɛlɛ, ban dãna fʊ naa. ");
INSERT INTO biv_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Bojũu wʊ ɩn Nãaŋmɩn tʊ̃tʊ̃nɔ̃ ɩka wʊ maal fʊ vɩla. Tɩchɛ fʊ̃ʊ wa maal dɛɛr 'lɔ, vɛ̃ ka dãbãɛ kʊrɔ fʊ, a ba ɩ pɔrɔ 'yɔ̃ɔ lɛ wʊ tara a sʊɔ ɛ. Nãaŋmɩn tʊ̃tʊ̃nɔ̃ lɛ wʊ ɩ na ara kʊ yeltorsɩ ɩka wʊ kpãana a bala na maala dɛɛr. ");
INSERT INTO biv_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","A lɛ jũu, a tara na sɔr ka yɩ siir yɩ mãɛ kʊ a kpãɛn dẽme, a ba ɩ ban na kpãa yɩ tɛɛ jũu ɛ, tɩchɛ an ɩ a yɩn mãɛ mɩ bɔ̃ɔ nyɔɔfʊ jũu. ");
INSERT INTO biv_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","A anyãna jũu lɛ so yɩn yara lõpoo kʊrɔ a kpãɛn dẽme na ɩ a Nãaŋmɩn tʊ̃tʊ̃nbɔ na de a ba sɔ̃ɔ wʊ jaa tʊ̃nɔ̃ nɩ. ");
INSERT INTO biv_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Nɩrɛ jaa sãn fʊn wa di, yab wʊ. Ka ala ɩ lõpoo lɛ faa yab ɛ, yab. Ka tẽmaal libie yabfʊ lɛ bɩɩ, yɩ ma yab, na yɩ joro a 'lɔ a jofʊ na sɛɛn, tɩ 'yɔ̃ɔnɔ̃ a 'lɔ mɩ a 'yɔ̃ɔfʊ na sɛɛn. ");
INSERT INTO biv_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Yɩ taa pɛ̃nɛ taa libie ka sãn ma gã a yɩ chara pɔ ɛ, a sãn 'lɔ tɛɛ na gã a yɩ chara pɔ lɛ, nʊ̃fʊ yɩn na nʊ̃ nʊ̃ taa, bojũu nɩrɛ 'lɔ jaa na nʊ̃ a wʊ tɔ sʊɔ tun a lɛ a nɛbinãa na 'yɛr a jaa. ");
INSERT INTO biv_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","A 'yɛrbinsɩ lɛ a anyãna, “Ta sɛ̃ ɛ.” “Ta kʊ nɩrɛ ɛ.” “Ta ju nɩrɛ bon ɛ.” “Ta jɩɛlɛ nɩrɛ bon ɛ.” A 'yɛrbinsɩ ala a jaa nɩ pãa chɛ, ba den a jaa 'yɛr 'yɛr bir bʊ̃'yen ɩka, “Nʊ̃ a fʊ tɔ sʊɔ nɩtãa a fʊ mãɛ.” ");
INSERT INTO biv_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Fʊ̃ʊ wa nʊ̃ nɩrɛ, faa maala wʊ bier ɛ. Ala lɛ so, fʊ̃ʊ wa tara nʊ̃fʊ, fʊ tu naa a lɛ jaa a Mosesɩ nɛɛ na 'yɛr. ");
INSERT INTO biv_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Yɩ maala a nɩtɔ̃, bojũu yɩ bɔ̃ɔn naa lɛ a dɩna sɔ̃ɔ nyã na kaara. A sɔ̃ɔ ta naa ɩka yɩ jɛɔ ir a yɩ gʊ̃ɔ pɔ, bojũu a sɩ faafʊ gbʊr jaa yɛ̃yɛ̃ gar a bɩbir 'lɔ sɩn dɔ̃ɔ sɔɔ de. ");
INSERT INTO biv_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","A chɛn bãlãa ka a tãsɔɔ baar, tɩchɛ ka a ɩ a wɛr mɩ tɔ̃ɔ chaar a lɛ nɛ. Yɩ ɩ a sɩ yaar a tãsɔɔ bomo bar tɩ de a chãa bomo su. ");
INSERT INTO biv_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Yɩ ɩ a sɩ kpɩɛrɛ jaa kãkar fɩka a mɔ̃tɔ̃ɔ nɩbɛ, na sɩ ir sɩ mãɛ yin dãɛn bɔyuor pɔ, dãa buufʊ pɔ, sɛ̃sɛ̃yele pɔ, nɩ folaa ɩfʊ pɔ, bɩɩ gɔ̃mɔ̃ bɔfʊ nɩ nyuur pɔ. ");
INSERT INTO biv_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Tɩchɛ yɩ de a sɩ Soro Yesu Kɩrɩsɩto na yɩ su pɔɔ a yɩ mãɛ, na yɩ ta lɛ tɩɛrɛ ɩka yɩ ɩrɛ a lɛ a yɩ ãgãn vɔlaa na bʊɔrɔ go ɛ. ");
INSERT INTO biv_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Nɩrɛ 'lɔ sɔɔfʊ na ba jã bon ɛ, yɩ ma sɔɔ de wʊ na yɩ ta tɔɔrɔ a wʊ yelbil 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Ɩ̃sʊɔ sɔɔfʊ ma vɛ̃n ka waa chire bon jaa ɛ, ka a ãsʊɔ sɔɔfʊ mɩ na bal ka 'lɔ mɩ dire jɛvai tɛɛ. ");
INSERT INTO biv_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","A nɩrɛ 'lɔ na ba chire bon jaa ɛ, wʊ ta kaara a 'lɔ na ba dire a jaa pɔrɔ ɛ, a fʊ̃ʊ nyã mɩ na ba dire a jaa ɛ, ta kpɛrɛ a 'lɔ na dire a jaa ɛ, bojũu Nãaŋmɩn de wʊ naa. ");
INSERT INTO biv_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Fʊ̃ʊ mɩ nɩ ana na fʊn tɔɔr nɩrɛ kɔ̃ɔ tʊ̃tʊ̃nɔ̃ 'yɛr? A wʊ mãɛ nɩkpɛ̃ɛ sɛ̃ ka wʊ ara na bɩɩ wʊ lo naa, wʊn lɛ ara na, bojũu a wʊ Soro na tʊ̃ɔn maal wʊ a wʊ ara. ");
INSERT INTO biv_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Nɩrɛ ma kãan a bɩbir ãsʊɔ a wʊ gar ãsʊɔ, ka ãsʊɔ kaa a bɩbie a jaa ka a ɩ bʊ̃'yen. Ɩ̃sʊɔ jaa wʊ ma tɩɛr kaa a wʊ mãɛ tɩɛr pɔ. ");
INSERT INTO biv_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Nɩrɛ 'lɔ na de a bɩbir ãsʊɔ a wʊ gar a jaa, wʊ ɩrɛ a lɛ a sɩ Soro jũu. 'Lɔ na ɔɔrɔ a nʊ̃n, wʊ ɔɔrɔ a sɩ Soro jũu, bojũu wʊ ma sʊɔr Nãaŋmɩn 'yɔ̃ɔ. A 'lɔ mɩ na ba ɔɔrɔ ɛ, wʊ mɩ ɩrɛ a lɛ a sɩ Soro jũu, wʊ mɩ ma puor Nãaŋmɩn yãan. ");
INSERT INTO biv_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Bojũu nɩrɛ ãsʊɔ jaa ba be be kʊ a wʊ mãɛ tɛɛ 'yɔ̃ɔ ɛ. Nɩrɛ ãsʊɔ jaa mɩ ba kpi kʊ a wʊ mãɛ tɛɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Ala ɩ sɩ ben ka, sɩ ben be kʊ a sɩ Soro. Ala ɩ sɩ mɩ kpi naa, sɩ kpin kʊ a sɩ Soro. Ka sɩ chɛnɛ na vʊrɔ, bɩɩ sɩ kpi naa, a sɩ Soro lɛ so sɩ. ");
INSERT INTO biv_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","A anyãna jũu lɛ a Kɩrɩsɩto kpi tɩ na wʊ lɛ ir ɩ vʊr, ɩka a wʊ ɩ a kũn nɩ a vʊɛ ba jaa Soro. ");
INSERT INTO biv_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Fʊ̃ʊ mɩ, baa 'yɔ̃ɔ lɛ fʊ tɔɔrɔ a fʊ yɛbɛ 'yɛr, bɩɩ bo lɛ so ka fʊ kaara a fʊ yɛbɛ pɔrɔ? Bojũu sɩ jaa lɛ na ara a Nãaŋmɩn 'yɛr tɔɔrfʊ dakɔɔ par. ");
INSERT INTO biv_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","A sɛb a Nãaŋmɩn gãn pɔ ɩka, “A sɩ Soro lɛ 'yɛr, ɩn ɩ vʊr jũu, a gbɛdumo a jaa na gbur a n niem, ka a kɔkɔr jaa haa 'yɛr ɩka maa lɛ ɩ a Nãaŋmɩn.” ");
INSERT INTO biv_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Be lɛ a sɩ ãsʊɔ jaa na pãa 'yɛr a sɩ mãɛ 'yɛr kʊ a Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","A lɛ jũu, yɩ ɩ a sɩ bar a sɩ taaba 'yɛr tɔɔrfʊ, na sɩ lɩɛb a sɩ tɩɛr na sɩ ta ɩrɛ kʊsɩr bãraa kʊrɔ a sɩ taaba sɔɩ pɔ a ba ŋmiere loro ɛ. ");
INSERT INTO biv_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","A maa na be a sɩ Soro Yesu 'yɔ̃ɔ, n sɔɔn sɩrɛ jaa ɩka bʊ̃diraa jaa ba ɩ dɛɛr a wʊ mãɛ ɛ. Tɩchɛ ala ɩ a nɩrɛ ãsʊɔ jaa wa kãan bon ɩka wʊ ɩn bʊ̃dɛɛr, a bʊ̃nyɩnɛ ɩn bʊ̃dɛɛr kʊ wʊ. ");
INSERT INTO biv_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ala wa ɩ a chɛn a fʊ yɛbɛ bʊ̃diraa kɔ̃ɔ fʊn di jũu, faa maala wile nɩ nʊ̃fʊ ɛ. Ta vɛ̃ ka a fʊ bʊ̃dirsɩ sɔ̃ɔ a fʊ yɛbɛ 'lɔ 'yɔ̃ɔ a Kɩrɩsɩto na kpi ɛ. ");
INSERT INTO biv_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Ta vɛ̃ ka a bon 'lɔ fʊ̃ʊ na bʊɔlɔ bʊ̃vɩla, ka nɩrɛ bʊɔl wʊ bʊ̃dɛɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Bojũu a Nãaŋmɩn nãalʊ̃ʊ yele ba ɩ bʊ̃diir nɩ bʊ̃nyursɩ yele ɛ, tɩchɛ a ɩn torfʊ, nɩ nyã'maar nɩ a pʊpɛl na yi a Nãaŋmɩn Sɩɛ pɔ yele lɛ, ");
INSERT INTO biv_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","bojũu nɩrɛ jaa na tʊ̃nɔ̃ kʊrɔ a Kɩrɩsɩto tu a sɔr nyã pɔ, wʊ maala na a lɛ na pɛlɛ a Nãaŋmɩn pʊɔ, ka a nɩbɛ mɩ 'yɛrɛ a nɩnyɩnɛ 'yɛr vɩla. ");
INSERT INTO biv_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","A lɛ jũu, yɩ ɩ a sɩ mʊ̃ɔ nɩbir, na sɩ maala a lɛ na waan nyã'maar a sɩ 'yɔ̃ɔn taa ãkpãɛn. ");
INSERT INTO biv_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Yɩ ta de bʊ̃diir yele sɔ̃ɔn a Nãaŋmɩn tʊ̃mɔ̃ bar ɛ. Bʊ̃diraa a jaa vɩɛlɛ naa, tɩchɛ a ɩn dɛɛr ala ɩ nɩrɛ din bon na vɛ̃ ka a wʊ tɔ sʊɔ lo. ");
INSERT INTO biv_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","A lɛ a sɛɛ naa ka nɩrɛ ta 'wɔb nʊ̃n ɛ, bɩɩ nyũ dãa ɛ, bɩɩ maal yele kɔ̃ɔ na vɛ̃ ka a wʊ tɔ sʊɔ lo ɛ. ");
INSERT INTO biv_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Lɛ jaa fʊn bɔ̃ɔ a yelsɩ anyãna pɔ, bar ka a be a fʊ̃ʊ nɩ Nãaŋmɩn chara pɔ. Pʊpɛl sʊɔ lɛ a 'lɔ tɩɛr na ba 'yɔ̃ɔ wʊ yele nɩ a bonsɩ ala a 'lɔ mãɛ na 'yɛr ɩka a ɩ naa ɛ. ");
INSERT INTO biv_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Tɩchɛ nɩrɛ 'lɔ na dire nɩ baal, 'yɔ̃ɔn a wʊ mãɛ 'yɛr, bojũu waa dire nɩ sɔɔfʊ ɛ. Bon jaa mɩ na ba wa yi sɔɔfʊ pɔ ɛ, a ɩn bier. ");
INSERT INTO biv_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Sɩn bala na kpɛ̃mɛ, a sɛɛ naa ka sɩ tuo a bala na ba kpɛ̃mɛ ɛ, na loro tuor, na sɩ ta pɛlɛ a sɩn mãɛ pʊʊr ɛ. ");
INSERT INTO biv_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","A sɩ ãsʊɔ jaa wʊ ma pɛlɛ a wʊ tɔ sʊɔ pʊɔ, na sɩ sʊ̃ʊ wʊ a wʊ mɩ ba nyɩbɛ. ");
INSERT INTO biv_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Bojũu a Kɩrɩsɩto mãɛ gba mɩ ba dɔ̃ɔ pɛl a wʊ mãɛ pʊɔ ɛ, tɩchɛ a lɛ an sɛb a Nãaŋmɩn gãn pɔ ɩka, “A tʊbie ala a bala na tʊfʊ, a wa dɔɔl a n ju.” ");
INSERT INTO biv_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Bojũu a ala a jaa na dɔ̃ɔ sɛb a Nãaŋmɩn gãn pɔ, a kõr jaa bin, a sɛb a sɩn wiilfʊ 'yɔ̃ɔ, ka a gãma anyãna kʊ sɩ kãnyir 'yɔ̃ɔn sɩ ãkpãɛn ka sɩ tara tɩɛrtɔfʊ jie. ");
INSERT INTO biv_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","A Nãaŋmɩn na kʊrɔ yɩ a kãnyir na wʊ 'yɔ̃ɔnɔ̃ yɩ a ãkpãɛn, wʊ kʊ yɩ nɛbʊ̃'yen ka yɩ turo nɩ a Yesu Kɩrɩsɩto. ");
INSERT INTO biv_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Ka yɩ jaa 'mataa tara tɩɛr bʊ̃'yen na yɩ de nɛbʊ̃'yen 'yɔ̃ɔn a Nãaŋmɩn tɩɩr na ɩ a sɩ Soro Yesu Kɩrɩsɩto Sãa. ");
INSERT INTO biv_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Yɩ sɔɔ diere taa nɩtãa lɛ a Kɩrɩsɩto mɩ na sɔɔ de yɩ, ka yɩn tʊ̃ɔ waan pɛɛfʊ wa kʊ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","N 'yɛrɛ na kʊrɔ yɩ ɩka, a Kɩrɩsɩto wa lɩɛb naa a Juu nɩbɛ tʊ̃tʊ̃nɔ̃ a Nãaŋmɩn yelmãɛ jũu, na wʊ vɛ̃ ka a lɛ a Nãaŋmɩn na tɩr a nɛɛ kʊ a sɩ Sãakpãmɩne ɩ yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Ka a bala na ba ɩ a Juu nɩbɛ ɛ, mɩ na tʊ̃ɔ kʊ Nãaŋmɩn tɩɩr a wʊ nɩbaal jũu. Nɩtãa lɛ na sɛb a Nãaŋmɩn gãn pɔ ɩka, “A lɛ jũu, ɩn dãnfʊ naa a bala na ba ɩ a Juu nɩbɛ sɛ̃, naa yiel yiel kʊ a fʊ yuor.” ");
INSERT INTO biv_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","A lɛ sɛb go, “A yɩn na ba ɩ a Juu nɩbɛ ɛ, yɩ 'matãan a Nãaŋmɩn nɩbɛ chɩlɛ.” ");
INSERT INTO biv_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","A lɛ sɛb go, “A yɩn na ba ɩ a Juu nɩbɛ ɛ, yɩ pɛɛrɛ a sɩ Soro, na yɩ yiele pɛɛfʊ yiel kʊrɔ wʊ, a yɩn nɩbɛ ba jaa.” ");
INSERT INTO biv_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Isaiya gba mɩ lɛ 'yɛr go a wʊ gãn pɔ, “A Jesɩ nyɩɩr na lɛ tɔ naa. 'Lɔ lɛ na ir na wʊ kaara a paalsɩ a jaa, na wʊ mɩ ɩ a bala na ba ɩ a Juu nɩbɛ ɛ, tɩɛrtɔfʊ jie.” ");
INSERT INTO biv_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","A Nãaŋmɩn na ɩ a yɩ tɩɛrtɔfʊ sʊɔ, wʊ sɛɛ a yɩ nyãn nɩ chɩlfʊ, nɩ nyã'maar a lɛ yɩn sɔɔ wʊ, ka a yɩ tɩɛrtɔfʊ pãa ŋme yaar nɩ a Nãaŋmɩn Sɩɛ kpɛ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","N yɛɛr, maa mãɛ sɔɔ naa ɩka yɩ sɛɛn naa vɩla maalfʊ, na yɩ tara yɛ̃ na yɩ bɔ̃ɔ taa wiilfʊ. ");
INSERT INTO biv_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","N sɛb a da sɛɛr amɩne 'yɔ̃ɔ kʊ yɩ, ka a kaara fɩka n lɛ bɔ̃ɔ tɩɛr yɩ go, a Nãaŋmɩn wãɛfʊ wʊn kʊ ma ");
INSERT INTO biv_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ka n ɩ a Yesu Kɩrɩsɩto tʊ̃tʊ̃nɔ̃ naa tʊ̃nɔ̃ a bala na ba ɩ a Juu nɩbɛ pɔ jũu, naa sʊ̃nɔ̃ mʊɔlɔ a Nãaŋmɩn 'yɛr nʊ̃ɔ. Lɛ lɛ a bala na ba ɩ a Juu nɩbɛ ɛ, puorfʊ na tara par ka a Nãaŋmɩn sɔɔ de na wʊ oon ba nɩ a wʊ Sɩɛ. ");
INSERT INTO biv_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Ɩn be a Yesu Kɩrɩsɩto 'yɔ̃ɔ jũu, a tʊ̃mɔ̃ ɩn tʊ̃nɔ̃ kʊrɔ a Nãaŋmɩn yin yuor. ");
INSERT INTO biv_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","N kʊ̃ wa 'la 'yɛr 'yɛr jaa ɛ, ka a ala a Kɩrɩsɩto na maal baar ba lɛ ɛ, tu a n 'yɔ̃ɔ ka a bala na ba ɩ a Juu nɩbɛ ɛ, lɩɛrɛ wa wõnõ a Nãaŋmɩn toor, tu a lɛ ɩn 'yɛr nɩ a lɛ ɩn tʊ̃, ");
INSERT INTO biv_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","wʊ den kpɛ̃ɔ tʊ̃n nɛ'maa tʊ̃mɔ̃ nɩ tʊ̃fɛrsɩ tun a Nãaŋmɩn Sɩɛ kpɛ̃ɔ pɔ. Lɛ lɛ, n yin a Jerusalɛm chen lɛ̃ɛɛ tɩ gʊɔr a Ilirikum tẽe naa man a Kɩrɩsɩto 'yɛr nʊ̃ɔ nyãna jaa nɛ nɛ nɛ. ");
INSERT INTO biv_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Maa nɩbijɩɛ yele lɛ ɩka n mʊɔl 'yɛr a 'yɛr nʊ̃ɔ jie 'lɔ jaa ban ba wõ a Kɩrɩsɩto yele ɛ, naa ta ɩrɛ wa mɛ dɔɔl nɩrɛ kɔ̃ɔ dachin par kparaa ju ɛ. ");
INSERT INTO biv_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Nɩtãa lɛ an dɔ̃ɔ sɛb a Nãaŋmɩn gãn pɔ ɩka, “A bala ban ba dɔ̃ɔ 'yɛr a wʊ 'yɛr kʊ ɛ, na nyɛ naa, ka a bala mɩ na ba dɔ̃ɔ wõ naa ɛ, na bɔ̃ɔn a par.” ");
INSERT INTO biv_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","A yele nyãna lɛ var ma a sɔr ka n ba tʊɔrɔ waara a yɩ sɛ̃ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Tɩchɛ pʊ̃pãanyã 'lɔ, n ba lɛ tara jipaalaa ka a paalsɩ anyã pɔ na lɛ tʊ̃ go ɛ, n mɩn dɔ̃ɔ bʊɔrɔ a yɩ nyɛfʊ a yuon yɔ̃ɔ na po jũu. ");
INSERT INTO biv_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","N guor naa ɩka n chen Sɩpẽen, maa wa tala ɩn ara na piir yɩ kaa, naa jɛ̃ a yɩ sɛ̃ bãlãa a yɩ sʊ̃ʊ ma ka n chen. ");
INSERT INTO biv_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Pʊ̃pãanyã 'lɔ, Jerusalɛm lɛ n chiine nɩ a sʊ̃ʊfʊ ɩka n tɩ kʊ a Nãaŋmɩn puorbo a be. ");
INSERT INTO biv_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Bojũu a Masedonɩya dẽme nɩ a Akaya dẽme man taa ɩka ba chɩɛr chɩɛrfʊ sʊ̃ʊn a Nãaŋmɩn puorbo bamɩne na be a Jerusalɛm na ba tara bon jaa ɛ. ");
INSERT INTO biv_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Ba nyɛn a lɛ ka a ɩ sãn kʊ ba a ba de a lɛ dɔɔl a ba mãɛ. Ala ɩ a bala na ba ɩ a Juu nɩbɛ ɛ, põn naa a Juu nɩbɛ a Nãaŋmɩn sʊ̃ʊfʊsɩ, ala lɛ so ka a mɩ sɛɛ ɩka ba mɩ lɔ̃ɔn a Juu nɩbɛ põn a ba bʊ̃tarsɩ. ");
INSERT INTO biv_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Maa wa tʊ̃ a nɩtɔ̃, naa de a chɩɛrfʊsɩ anyã kʊ ba baar, ala lɛ ɩn chen a Sɩpẽen naa tɩ 'lɔɔ piir yɩ kaa. ");
INSERT INTO biv_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","N bɔ̃ɔn naa ɩka maa wa waara, ɩn waan naa a Kɩrɩsɩto sʊ̃ʊfʊ na bɛrma. ");
INSERT INTO biv_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","N sʊɔrɔ yɩ naa n yɛɛr, nɩ a sɩ Soro Yesu Kɩrɩsɩto nɩ a Nãaŋmɩn Sɩɛ nʊ̃fʊ ɩka, yɩ pʊɔ ma a n mɔ̃fʊ nyã pɔ, sʊɔrɔ Nãaŋmɩn kʊrɔ ma. ");
INSERT INTO biv_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Yɩ sʊɔr Nãaŋmɩn, a wʊ faa ma yin a bala na ba sɔɔ be a Judiya, ka a lɛ mɩ ɩn chiine a Jerusalɛm ka a Nãaŋmɩn puorbo mɩ tɩ sɔɔ de, ");
INSERT INTO biv_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ka ala ɩka Nãaŋmɩn bɔfʊ lɛ, ka n wa a yɩ sɛ̃ nɩ pʊpɛl a sɩ 'mataa 'yɔ̃ɔ taa ãkpãɛn. ");
INSERT INTO biv_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Nãaŋmɩn na ɩ a nyã'maar sʊɔ, wʊ be a yɩ jaa sɛ̃. A ɩ a lɛ. ");
INSERT INTO biv_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","N pʊrɔ naa a sɩ yɛpɔɔ Fiibi yovɩla kʊrɔ yɩ, a pɔɔ nyã ɩn tʊ̃tʊ̃nɔ̃ be a Kenkɩrya tẽdẽme pupuorbiir pɔ. ");
INSERT INTO biv_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","N sʊɔrɔ yɩ naa ɩka 'lɔ wa tɩ, yɩ de wʊ nɩ a sɩ Soro yuor, na yɩ maal wʊ a lɛ na sɛɛn a Nãaŋmɩn puoro, na yɩ mɩ kʊ wʊ sʊ̃ʊfʊ jaa wʊn na bʊɔrɔ yi a yɩ sɛ̃. Bojũu wʊ mɩ dɔ̃ɔ sʊ̃ʊ nɩyɔɔ nɩ a maa mãɛ. ");
INSERT INTO biv_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Yɩ puor a Pɩrɩsɩla nɩ Akuila kʊ ma. Ba ɩ naa a n tʊ̃tʊ̃taaba a Yesu Kɩrɩsɩto tʊ̃mɔ̃ pɔ. ");
INSERT INTO biv_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Ba tʊ̃n kũu tʊ̃mɔ̃ kʊ ma. A ba ɩ maa tɛɛ gba lɛ ɛ, tɩchɛ a pupuorbo bala ba jaa na ba ɩ a Juu nɩbɛ ɛ, ãgãn mɩ 'maan ba naa. ");
INSERT INTO biv_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Puor a pupuorbiir bala na ma lɔ̃ɔ puor a ba yir. Puor a n badaba Epainɩtʊsɩ, 'lɔ lɛ de nie turo a Kɩrɩsɩto be a Asɩya paal pɔ. ");
INSERT INTO biv_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Yɩ puor a Mɛɛr mɩ na ir nyãa 'yɔ̃ɔ tʊ̃nɔ̃ kʊrɔ yɩ, ");
INSERT INTO biv_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","na yɩ mɩ puor a Andirunɩkasɩ nɩ a Junɩyasɩ. Ba ɩn a n bʊr nɩbɛ ka maa nɩ bala jaa mɩ dɔ̃ɔ 'mataa be a pɔɔfʊ die pɔ. A nɩtʊ̃nsɩ bɔ̃ɔ ban jaa chɛchɛ, bala mɩ lɛ de nie turo a Kɩrɩsɩto tɩchɛ ka a maa wa bɩɛr. ");
INSERT INTO biv_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Yɩ puor Ampɩlatusɩ kʊ ma, n nʊ̃ wʊ naa a Kɩrɩsɩto tufʊ jũu, ");
INSERT INTO biv_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","na yɩ mɩ puor Urbanusɩ na pʊɔ sɩ tʊ̃nɔ̃ a Kɩrɩsɩto tʊ̃mɔ̃ pɔ nɩ a n badaba Sɩtachɩsɩ. ");
INSERT INTO biv_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Yɩ puor Apelesɩ nɩrɛ jaa na sɔɔ ɩka wʊ turo naa a Kɩrɩsɩto sɔr jaa nɛ nɛ nɛ, na yɩ mɩ puor Aristobulus nɩ a wʊ yir dẽme ba jaa. ");
INSERT INTO biv_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Yɩ puor a Hɛrɔdiyɔn na ɩ a n bʊr nɩrɛ, na yɩ mɩ puor a Narsɩsusɩ nɩ a wʊ yir dẽme ba jaa na turo a sɩ Soro. ");
INSERT INTO biv_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Yɩ puor a Tɩrafaina nɩ Tɩrafosa, a pɔbɔ ba nyãna mʊ̃ɔn nɩbir nɩ a sɩ Soro tʊ̃mɔ̃, na yɩ puor a Persis mɩ na ɩ a pɔɔ ãsʊɔ na mʊ̃ɔ nɩbir nɩ a sɩ Soro tʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Yɩ puor a Worofʊs ban ir a sɩ Soro pɔ nɩ a wʊ ma, a wʊ ma mɩ ɩn a n ma. ");
INSERT INTO biv_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Yɩ puor Asɩnkirtusɩ, nɩ Filegon, nɩ Hɛmɩsɩ nɩ Patrobas nɩ Hermasɩ nɩ a yɛɛr bala jaa na be a ba sɛ̃. ");
INSERT INTO biv_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Yɩ puor a Filologusɩ nɩ Juliya nɩ Nereyus nɩ a wʊ yɛpɔɔ nɩ Olinpasɩ nɩ a Nãaŋmɩn puorbo ba jaa na be a ba sɛ̃. ");
INSERT INTO biv_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Yɩ puor puor taa nɩ pʊpɛl. A pupuorbiir ba jaa puor yɩ naa nɩ a Kɩrɩsɩto yuor. ");
INSERT INTO biv_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","N kpãkpãana yɩ naa yɛɛr ɩka yɩ guro yɩ mãɛ sʊ̃ nɩ a bala na ma waara nɩ a ootaa, na ba ma vɛ̃ ka yɩ bãra loro a wiilfʊ nyã yɩn jãn pɔ. Yɩ tɔɔ 'laa tɩ bar ba. ");
INSERT INTO biv_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Bojũu a nɩbɛ ba nyãna a ba ɩ a sɩ Soro Kɩrɩsɩto tʊ̃mɔ̃ lɛ ba tʊ̃nɔ̃ ɛ, tɩchɛ a bala mãɛ vɔlaa bomo lɛ ba tʊ̃nɔ̃ bʊɔrɔ. Ba ma 'yɛrɛ na jaa hɛ lɛ lɛ lɛ na ba de nɛnʊ̃ɔ bɛl a nɩbɛ bala tɩɛr na ba chen niem ɛ. ");
INSERT INTO biv_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Nɩrɛ jaa wõn a lɛ yɩn turo a Nãaŋmɩn 'yɛr nɛ nɛ nɛ, ka nʊ̃ɔ kpɛ sɩ a yɩ yele jũu. Tɩchɛ n bʊɔrɔ naa ɩka yɩ maala vɩla nɩ yɛ̃, na yɩ ta bɔ̃ɔ yelbier maalfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","A Nãaŋmɩn nyã na ɩ a nyã'maar sʊɔ, a kʊ̃ lɛ kor ɛ, tɩchɛ ka a wʊ ŋmãɛ a Satan a yɩ gbɛɛ pĩlem. A wãɛfʊ na yi a sɩ Soro Yesu sɛ̃ a be a yɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timoti na ɩ a n tʊ̃tʊ̃tɔ sʊɔ puor yɩ naa, ka a Lusiyusɩ nɩ Jason nɩ Sosipater na ɩ a n bʊr nɩbɛ mɩ puoro yɩ naa. ");
INSERT INTO biv_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Maa mɩ na ɩ Tɛrtɩyɔsɩ na sɛɛrɛ a Pɔɔl gãn nyã mɩ puoro yɩ naa nɩ a sɩ Soro yuor. ");
INSERT INTO biv_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus yir maa nɩ pupuorbiir na kpɩɛrɛ a wʊ kaara sɩ mɩ puoro yɩ naa. Erastus na ɩ a tẽe libikaara nɩkpɛ̃ɛ nɩ a sɩ yɛbɛ Kuwartusɩ mɩ puoro yɩ naa. ");
INSERT INTO biv_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Pʊ̃pãanyã, tɩɩr wʊ ta a Nãaŋmɩn nyã na sʊ̃ʊ yɩ a yɩ tʊ̃ɔ ara tu a n 'yɛr nʊ̃ɔ nyã ɩn mʊɔl na ɩ a Yesu Kɩrɩsɩto, naa chaar a yelsɔɔlaa nyãna na sɔɔl a kõr jaa na po. ");
INSERT INTO biv_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Tɩchɛ pʊ̃pãanyã, a yelsɔɔlaa chaar naa tu a lɛ a Nãaŋmɩn 'yɛ'yɛrbɛ a lɛ a Nãaŋmɩn vʊr nyã na 'yɛr ba, ka a paalsɩ ba jaa na sɔɔ de, na ba turo wʊ. ");
INSERT INTO biv_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","A Nãaŋmɩn nyã tɛɛ lɛ ɩ a yɛ̃ sʊɔ, wʊ nyɛrɛ tɩɩr bɩbir nɩ bɩbir jaa tu a Yesu Kɩrɩsɩto 'yɔ̃ɔ. A ɩ a lɛ.");
INSERT INTO biv_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Maa Pɔɔl a Nãaŋmɩn na bʊɔl a wʊ bɔfʊ pɔ ɩka n ɩ a Yesu Kɩrɩsɩto nɩtʊ̃nãa nɩ a sɩ yɛbɛ Sosetenesɩ, ");
INSERT INTO biv_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","lɛ sɛɛrɛ a gãn nyã kʊrɔ a yɩn na puoro a Nãaŋmɩn be a Korɩntɩ tẽe pɔ. A yɩn na oo be a Yesu Kɩrɩsɩto 'yɔ̃ɔ na yɩ ɩ a wʊ nɩ chɛchɛsɩ lɔ̃ɔn a bala na be jie jaa na bʊɔlɔ a sɩ Soro Yesu Kɩrɩsɩto yuor na ɩ a sɩn nɩ a ba jaa Soro. ");
INSERT INTO biv_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Wãɛfʊ nɩ nyã'maar na yi a sɩ Sãa Nãaŋmɩn nɩ a sɩ Soro Yesu Kɩrɩsɩto sɛ̃ a be a yɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","N ma puor Nãaŋmɩn yãan kʊ yɩ bojũu wʊ wãɛ yɩ naa tu a Yesu Kɩrɩsɩto 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","A wʊ jũu lɛ yɩ le yele a jaa pɔ, a yɩ 'yɛrbie nɩ a yɩ bɔ̃ɔfʊ a jaa pɔ, ");
INSERT INTO biv_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","bojũu a Kɩrɩsɩto dãasɩɛ sɩn di, yɩ sɔɔn de. ");
INSERT INTO biv_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","A lɛ jũu, yaa faa a Nãaŋmɩn Sɩɛ kʊfʊ ãsʊɔ jaa ɛ, na yɩ pãa mʊ̃ɔ nɩbir chɛlɛ a lɛ a sɩ Soro Yesu Kɩrɩsɩto na lɛ lɩɛb wa. ");
INSERT INTO biv_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Wʊn 'yɔ̃ɔ yɩn ãkpãɛn tɩ tãn a baaraa, ka yɩ kʊ̃ tara chɛfʊ ɛ, tɩ tãn a sɩ Soro Yesu Kɩrɩsɩto waa bɩbir. ");
INSERT INTO biv_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","A Nãaŋmɩn nyã na bʊɔl yɩ wa lɔ̃ɔn a wʊ Bie Yesu Kɩrɩsɩto na ɩ a sɩ Soro ɩn yelmãɛ sʊɔ. ");
INSERT INTO biv_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","N yɛɛr, n den a sɩ Soro Yesu Kɩrɩsɩto yuor naa sʊɔrɔ nɩ yɩ ɩka yɩ jaa yɩ ta ŋma dẽdẽ ka ootaa be a yɩ pɔ ɛ, a lɛ na vɛ̃ naa ka yɩ pãa tara nɛbʊ̃'yen nɩ tɩɛr bʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","N yɛɛr, nɩbɛ bamɩne na yi a Kɩloe yir wa man kʊ ma ɩka nɛchɩrɛ ben a yɩ chara pɔ. ");
INSERT INTO biv_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","A lɛ par lɛ ɩka, a yɩ ãsʊɔ jaa ma 'yɛr ɩka, Pɔɔl lɛ maa turo, ka ãsʊɔ mɩ 'yɛr, Apolosɩ lɛ maa turo, ka a ãsʊɔ mɩ 'yɛr, Sɩfasɩ lɛ n turo, ka a ãsʊɔ mɩ 'yɛr ɩka, Kɩrɩsɩto lɛ n turo. ");
INSERT INTO biv_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","A Kɩrɩsɩto ŋman dẽdẽme bɩɩ? Pɔɔl lɛ ba kpa a daa ju bɩɩ? Bɩɩ Pɔɔl yuor lɛ yɩ son a Nãaŋmɩn kʊ̃ɔ? ");
INSERT INTO biv_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","N pʊɔ pɛl naa ɩn ba so a yɩ ãsʊɔ jaa Nãaŋmɩn kʊ̃ɔ ɛ, ka ala ba ɩ Kɩrɩsɩpusɩ nɩ Gayus tɛɛ ba lɛ ɛ, ");
INSERT INTO biv_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ka nɩrɛ jaa kʊ̃ tʊ̃ɔ 'yɛr ɩka maa yuor lɛ n son yɩ a Nãaŋmɩn kʊ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ɔ̃ɔ, n mɩ dɔ̃ɔ so a Sɩtɛfanas nɩ a wʊ yir dẽme ba jaa a Nãaŋmɩn kʊ̃ɔ. A anyã puor n ba tɩɛr nɩrɛ jaa ɩn lɛ so a Nãaŋmɩn kʊ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Bojũu Yesu Kɩrɩsɩto ba tʊ̃ ma ɩka n tɩ suoro nɩbɛ Nãaŋmɩn kʊ̃ɔ ɛ, tɩchɛ n tɩ mʊɔl a 'yɛr nʊ̃ɔ na ba ɩ nɩsaal yɛ̃ 'yɛr ɛ. Ka a Kɩrɩsɩto kũu wʊn kpi a daa taa ɩ pɔrɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Bojũu a daa 'yɛr ɩn dãbol 'yɛr kʊ a bala na wɛrɛ, tɩchɛ a ɩn Nãaŋmɩn kpɛ̃ɔ kʊ a sɩn bala na nyɛ a faafʊ. ");
INSERT INTO biv_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Bojũu a sɛb a Nãaŋmɩn gãn pɔ ɩka, “Ɩn sɔ̃ɔ naa a yɛ̃ dẽme yɛ̃ bar, naa bʊ̃bʊr a bɔ̃ɔfʊ dẽme bɔ̃ɔfʊ bar.” ");
INSERT INTO biv_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Nyɩnɛ lɛ a yɛ̃ dẽme be? Nyɩnɛ lɛ a bɔ̃ɔfʊ sʊɔ be? Nyɩnɛ lɛ chɩbɛ dẽme mɩ be a dɩna? A ba ɩ Nãaŋmɩn lɩɛb a wɛr nyã yɛ̃ a wʊ ɩ jɔl ɛ? ");
INSERT INTO biv_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Bojũu a Nãaŋmɩn yɛ̃ kʊ vɛ̃ ka a wɛr de a wʊ yɛ̃ bɔ̃ɔn wʊ ɛ, Nãaŋmɩn pʊɔ pɛl naa nɩ a jɔl mʊɔl ban mʊɔl ka a na faa a bala na sɔɔ de. ");
INSERT INTO biv_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","A Juu nɩbɛ ma bʊɔrɔ naa nɛ'maa yele, ka a bala na ba ɩ a Juu nɩbɛ ɛ, mɩ bʊɔrɔ yɛ̃. ");
INSERT INTO biv_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Tɩchɛ sɩn mʊɔl naa Yesu Kɩrɩsɩto ban kpa a daa ju, ka a ɩ gbɛr bãrfʊ kʊ a Juu nɩbɛ tɩ mɩ ɩ jɔl yele kʊ a bala na ba ɩ a Juu nɩbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Tɩchɛ a bala a Nãaŋmɩn na lɔ̃ɔ bʊɔl a Juu nɩbɛ nɩ a bala na ba ɩ a Juu nɩbɛ ɛ, Kɩrɩsɩto lɛ ɩ a Nãaŋmɩn kpɛ̃ɔ nɩ a Nãaŋmɩn yɛ̃. ");
INSERT INTO biv_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Bojũu Nãaŋmɩn jɔlʊ̃ ɩn yɛ̃ gar a nɩrɛ yɛ̃, ka a Nãaŋmɩn balfʊ tara kpɛ̃ɔ gar a nɩrɛ kpɛ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","N yɛɛr, yɩ tɩɛr a lɛ yɩn dɔ̃ɔ be tɩ a Nãaŋmɩn wa bʊɔl yɩ, nɩsaal kaafʊ pɔ, a yɩ yɔɔ ba dɔ̃ɔ ɩ yɛ̃ dẽme ɛ, a yɩ yɔɔ ba dɔ̃ɔ ɩ yuor dẽme ɛ, yaa ɩ nãmɩne bibiir ɛ. ");
INSERT INTO biv_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Tɩchɛ Nãaŋmɩn ir naa a wɛr nyã jɔl bon 'yɔ̃ɔn a yɛ̃ dẽme vã, Nãaŋmɩn lɛ ir naa a wɛr nyã bʊ̃balaa na wʊ 'yɔ̃ɔn a kpãɛn dẽme vã. ");
INSERT INTO biv_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Nãaŋmɩn ma ir naa a wɛr bon ba 'yɔ̃ɔnaa, a ala a nɩbɛ na kaara pɔrɔ, nɩ a nɩbɛ bala gba nɩrɛ jaa na ba 'yɔ̃ɔnɔ̃ ɛ, wʊ ɩ naa nɩtɔ̃ ka a bon 'lɔ a wɛr na 'yɔ̃ɔnɔ̃ ka wʊ ɩ pɔrɔ, ");
INSERT INTO biv_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ka nɩrɛ jaa taa bʊɔrɔ yuor a wʊ niem ɛ. ");
INSERT INTO biv_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","A wʊ jũu lɛ yɩ be a Yesu Kɩrɩsɩto 'yɔ̃ɔ, 'lɔ lɛ ɩ a yɛ̃ yi a Nãaŋmɩn sɛ̃ kʊ sɩ, na wʊ ɩ a sɩ torfʊ nɩ chɛchɛ nɩ a faafʊ. ");
INSERT INTO biv_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","A lɛ jũu, nɩtãa lɛ an sɛb a Nãaŋmɩn gãn pɔ, “Vɛ̃ ka a 'lɔ na bʊɔrɔ yuor, wʊ bʊɔrɔ a yuor a sɩ Soro 'yɔ̃ɔ.” ");
INSERT INTO biv_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","N yɛɛr, ɩn dɔ̃ɔ wa a yɩ sɛ̃, n ba waan nɛbɔ̃ɔn bɩɩ yɛ̃ 'yɛr naa wa man a Nãaŋmɩn dãasɩɛ kʊ yɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Bojũu a lɛ ɩn dɔ̃ɔ be a yɛ sɛ̃, n ba lɛ bɔ̃ɔ bon jaa pʊɔ a Yesu Kɩrɩsɩto ban kpa a daa ju ɛ. ");
INSERT INTO biv_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Balfʊ, dãbãɛ nɩ mĩifʊ lɛ n dɔ̃ɔ ben a yɩ sɛ̃. ");
INSERT INTO biv_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","A n 'yɛr nɩ a n mʊɔlfʊ ba ɩ yɛ̃ 'yɛrbie ɛ, tɩchɛ a ɩ naa a Nãaŋmɩn Sɩɛ kpɛ̃ɔ wiilfʊ lɛ, ");
INSERT INTO biv_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ka a yɩ sɔɔfʊ taa dɩɛl a nɩrɛ yɛ̃ ɛ, tɩchɛ a dɩɛl a Nãaŋmɩn kpɛ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Faa nyɛ, sɩn ma 'yɛr a sɩ 'yɛr nɩ yɛ̃ kʊ a bala na nʊ̃ɔ a Nãaŋmɩn sɔr pɔ, a ba ɩ a wɛr nyã bɩɩ a kpãɛn dẽme yɛ̃ na wa ɩ pɔrɔ daar kɔ̃ɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Kai, sɩn 'yɛrɛ naa a Nãaŋmɩn yɛ̃ sɔɔlaa, a yɛ̃ 'lɔ na dɔ̃ɔ sɔɔl a Nãaŋmɩn na kaa ir a sɩ daar kɔ̃ɔ tɩɩr jũu sɛrɛ na wʊ wa maal a wɛr. ");
INSERT INTO biv_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","A wɛr nyã kpãɛn dẽme ba dɔ̃ɔ bɔ̃ɔ a par ɛ, ala ɩ bala ta bɔ̃ɔ ba kʊ̃ naa kpa a tɩɩr Soro a daa ju ɛ. ");
INSERT INTO biv_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Tɩchɛ a lɛ an sɛb a Nãaŋmɩn gãn pɔ ɩka, “Nɩbir jaa ba nyɛ ɛ, toor jaa ba wõ ɛ, tɩɛr jaa mɩ ba bɔ̃ɔn a ala a Nãaŋmɩn na chɔɔr kʊ a bala na nʊ̃ wʊ ɛ.” ");
INSERT INTO biv_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Tɩchɛ anyãna lɛ a Nãaŋmɩn Sɩɛ wiil kʊ sɩ, Nãaŋmɩn Sɩɛ ma bɩɛr naa a yelsɩ a jaa, na wʊ gba ma bɔ̃ɔ a ala na be a Nãaŋmɩn pʊɔm. ");
INSERT INTO biv_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Nɩbuor lɛ bɔ̃ɔ lɛ na be a wʊ tɔ sʊɔ tɩɛr pɔ, ka a nɩrɛ 'lɔ mãɛ ba lɛ ɛ? A lɛ mɩ lɛ nɩrɛ ba bɔ̃ɔ lɛ na be a Nãaŋmɩn tɩɛr pɔ ɛ, ka a Nãaŋmɩn mãɛ Sɩɛ ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","A ba ɩ a wɛr nyã sɩɛ lɛ sɩ tara ɛ, tɩchɛ a Sɩɛ 'lɔ na yi a Nãaŋmɩn sɛ̃ a sɩ de bɔ̃ɔn a ala a Nãaŋmɩn na kʊ sɩ a pɔrɔ. ");
INSERT INTO biv_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","A anyãna lɛ sɩ 'yɛrɛ, a ba ɩ nɩrɛ 'yɛrbie sɩn jãn ɛ, tɩchɛ 'yɛrbie ala sɩn jãn a Nãaŋmɩn Sɩɛ sɛ̃ na sɩ wile nɩ a Nãaŋmɩn Sɩɛ yelmãɛ nɩ a Sɩɛ 'yɛrbie. ");
INSERT INTO biv_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Nɩrɛ 'lɔ jaa na ba tara a Nãaŋmɩn Sɩɛ ɛ, maa sɔɔ a ala na yi a Nãaŋmɩn Sɩɛ sɛ̃ ɛ, bojũu a ɩn dãbol yele kʊ wʊ a wʊ maa bɔ̃ɔ a par ɛ, bojũu nɩrɛ na tʊ̃ɔn bɔ̃ɔ ala ɩ wʊ tara naa Nãaŋmɩn Sɩɛ. ");
INSERT INTO biv_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","A nɩrɛ 'lɔ na tara a Nãaŋmɩn Sɩɛ ma vɩɛr naa a yele a jaa kaa, tɩchɛ nɩrɛ 'lɔ na ba tara a Nãaŋmɩn Sɩɛ ɛ, wʊ kʊ̃ bɔ̃ɔ a nɩrɛ 'lɔ na tara a Nãaŋmɩn Sɩɛ tɩɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Bojũu a sɛb a Nãaŋmɩn gãn pɔ ɩka, “An lɛ bɔ̃ɔ a sɩ Soro tɩɛr, na wʊn kpãa wʊ?” Tɩchɛ sɩn lɛ tara a Yesu Kɩrɩsɩto tɩɛr. ");
INSERT INTO biv_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","N yɛɛr, n kʊ̃ tʊ̃ɔ 'yɛrɛ nɩ yɩ fɩka nɩbɛ na tara a Nãaŋmɩn Sɩɛ ɛ, tɩchɛ n 'yɛrɛ nɩ yɩ naa fɩka a wɛr nɩbɛ na yɩ ɩ bibiir a Kɩrɩsɩto sɔr pɔ. ");
INSERT INTO biv_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Bɩrkʊ̃ɔ tɛɛ lɛ n kʊ yɩ a ba ɩ saa yɩn ba ta na tʊ̃ɔ di ɛ. Sɩrɛ jaa lɛ yɩ chɛnɛ ba ta ɛ. ");
INSERT INTO biv_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Yɩ chɛnɛ na ɩrɛ fɩka nɩbɛ na ba bɔ̃ɔ Nãaŋmɩn ɛ, bojũu nyuur nɩ nɛchɩrɛ chɛnɛ na be a yɩ pɔ, yaa chɛnɛ ɩ a wɛr nɩbɛ ɛ? Na yɩ maala a lɛ ban maala ɛ? ");
INSERT INTO biv_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","A yɩ ãsʊɔ na ma 'yɛr, maa turo na Pɔɔl, ka a ãsʊɔ mɩ 'yɛr ɩka, maa turo na Apolosɩ. Yaa chɛnɛ ɩrɛ fɩka nɩbɛ na ba bɔ̃ɔ Nãaŋmɩn ɛ? ");
INSERT INTO biv_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","A anyãna a jaa pɔ, Pɔɔl nɩ a Apolosɩ, bo ba ɩ? Tʊ̃tʊ̃nbɔ lɛ sɩn ɩ a yɩ tu a be wa sɔɔ de ka a sɩ Soro kʊ ãsʊɔ jaa nɩ wʊ tʊ̃mɔ̃. ");
INSERT INTO biv_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Maa lɛ bʊr ka a Apolosɩ mɩ chɔr a kʊ̃ɔ, tɩchɛ Nãaŋmɩn lɛ so an nʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Lɛ a 'lɔ na bʊr, nɩ a 'lɔ na chɔr a kʊ̃ɔ, ba ɩ bon jaa ɛ, tɩchɛ a Nãaŋmɩn 'lɔ tɛɛ na vɛ̃ ka a bonsɩ a jaa nʊ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","A nɩrɛ 'lɔ na bʊr nɩ a nɩrɛ 'lɔ na chɔr a kʊ̃ɔ ba jaa tara na tɩɛr bʊ̃'yen ka a ãsʊɔ jaa na nyɛ a lɛ wʊn tʊ̃ sãyar. ");
INSERT INTO biv_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Bojũu, sɩn ɩ naa Nãaŋmɩn tʊ̃tʊ̃taaba, yɩn mɩ lɛ ɩ a Nãaŋmɩn puo, a Nãaŋmɩn yir wʊn mɩɛrɛ. ");
INSERT INTO biv_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","A wãɛfʊ a Nãaŋmɩn na kʊ ma lɛ so ka n kpar a dachin par kparaa nɩtãa bɔ̃ɔ mɩɛrɛ, ka a bamɩne mɩ mɩɛrɛ dɔɔlɔ. Tɩchɛ ãsʊɔ jaa wʊ bɔ̃ɔ kaara a lɛ wʊn mɩɛrɛ dɔɔlɔ. ");
INSERT INTO biv_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","A yele lɛ ɩka, nɩrɛ jaa kʊ̃ lɛ tʊ̃ɔ kpar a dachin par kpar yuo lɛ pʊɔ a 'lɔ na be be ɛ, 'lɔ lɛ ɩ a Yesu Kɩrɩsɩto. ");
INSERT INTO biv_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Ala ɩ nɩrɛ den sɛlma, kpãna, kʊsɩr kpãɛn, daar, mʊɔr bɩɩ kakɩɛ, ");
INSERT INTO biv_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","nɩrɛ jaa na nyɛ naa a wʊ tʊ̃mɔ̃, bojũu a bɩbir 'lɔ̃nɔ̃ a jaa na gãn chãa pɔ. Bũu lɛ na vuul nɩrɛ jaa tʊ̃mɔ̃ na wʊ bɛɛr ãsʊɔ jaa tʊ̃mɔ̃ kaa. ");
INSERT INTO biv_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Ala ɩ a lɛ wʊn mɛ dɔɔl ba sɔ̃ɔ ɛ, wʊn nyɛn a wʊ sãyar. ");
INSERT INTO biv_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ala ɩ a wa di naa a nɩnyɩnɛ kʊ̃ nyɛ bon jaa ɛ, wʊn nyɛn faafʊ, tɩchɛ wʊn kaara naa fɩka nɩrɛ bũu na vuul. ");
INSERT INTO biv_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Yaa bɔ̃ɔ ɩka yɩn mãɛ lɛ a Nãaŋmɩn puorfʊ yir ka a wʊ Sɩɛ kpɩɛrɛ a yɩ 'yɔ̃ɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Ala ɩ ãsʊɔ jaa wa sɔ̃ɔ naa a Nãaŋmɩn puorfʊ yir nyã, Nãaŋmɩn na sɔ̃ɔ naa a nɩnyɩnɛ, bojũu a Nãaŋmɩn puorfʊ yir ɩn chɛchɛ. Yɩn mãɛ lɛ a puorfʊ yir nyã. ");
INSERT INTO biv_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Yɩ ta bɛlɛ a yɩ mãɛ ɛ. Ala ɩ a yɩ ãsʊɔ tɩɛr naa ɩka wʊ ɩ naa yɛ̃ sʊɔ a wɛr nyã pɔ, wʊ lɩɛb ɩ “Jɔl” na wʊ pãa tʊ̃ɔ lɩɛb yɛ̃ sʊɔ. ");
INSERT INTO biv_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Bojũu a wɛr nyã yɛ̃ ɩ naa jɔl yele a Nãaŋmɩn niem, nɩtãa lɛ an sɛb a Nãaŋmɩn gãn pɔ, “Wʊ ma nyɔɔ naa a yɛ̃ sʊɔ a wʊ yɛ̃ yele pɔ.” ");
INSERT INTO biv_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","A lɛ sɛb go, “A Soro bɔ̃ɔ naa a yɛ̃ dẽme tɩɛr ka a ɩ pɔrɔ.” ");
INSERT INTO biv_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","A lɛ jũu, nɩrɛ wʊ ta lɛ 'mɔɔrɔ a wʊ mãɛ nɩ nɩrɛ yele ɛ! Yɩn lɛ so a bonsɩ a jaa, ");
INSERT INTO biv_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ka maa Pɔɔl lɛ bɩɩ, Apolosɩ lɛ bɩɩ, Sɩfasɩ lɛ bɩɩ, a wɛr lɛ bɩɩ, nyɛvʊr lɛ bɩɩ, kũu lɛ bɩɩ, dɩna lɛ bɩɩ, ka daar kɔ̃ɔ lɛ, yɩn lɛ so a jaa. ");
INSERT INTO biv_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","A Yesu Kɩrɩsɩto mɩ so yɩ, ka Nãaŋmɩn mɩ so a Yesu Kɩrɩsɩto. ");
INSERT INTO biv_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","A lɛ jũu, yɩ ma kaa sɩ a sɩ ɩ a Yesu Kɩrɩsɩto tʊ̃tʊ̃nbɔ a Nãaŋmɩn na de a wʊ yelsɔɔlsɩ 'yɔ̃ɔ a sɩ nuur pɔ. ");
INSERT INTO biv_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Pʊ̃pãanyã, a lɛ na gã lɛ ɩka a bala ban de bon 'yɔ̃ɔ a ba nuur pɔ, ba tara yelmãɛ. ");
INSERT INTO biv_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","A ba bã ma ɛ, ala ɩ ka yɩn lɛ bɩɩ a wɛr nɩrɛ lɛ tɔɔrɔ a n 'yɛr sɩrɛ jaa a maa mãɛ kʊ̃ tɔɔr a n 'yɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","N ba tɩɛr yele jaa ɩn ɩ bɔr ɛ, tɩchɛ a ba wiil ɩka n ba tara yele ɛ. A sɩ Soro lɛ na tɔɔr a n 'yɛr. ");
INSERT INTO biv_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","A lɛ jũu, yɩ ta de nie tɔɔrɔ a 'yɛr ka a bɩbir ba ta ɛ. Yɩ chɛlɛ ka a sɩ Soro wa. 'Lɔ lɛ na yin yele a jaa na sɔɔl a libe pɔ, chãa pɔ, na wʊ mɩ wiil a ala na sɔɔl a nɩbɛ tɩɛr pɔ. A bɩbir 'lɔ̃nɔ̃ lɛ ãsʊɔ jaa na nyɛ a wʊ pɛɛfʊ a Nãaŋmɩn sɛ̃. ");
INSERT INTO biv_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Pʊ̃pãanyã, n yɛɛr, a yɩn jũu lɛ n de a yele anyãna naa man a maa nɩ a Apolosɩ, ka yɩn jãn a par yi a sɩ sɛ̃ a lɛ ban 'yɛr ɩka, “Taa ɩrɛ wa chen po a lɛ ban sɛb ɛ.” Ka a yɩ ãsʊɔ jaa taa pãa 'yɔ̃ɔnɔ̃ nɩbɛ gara taa ɛ. ");
INSERT INTO biv_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Ana lɛ maal yɩ a yɩ be yɩ yõ gar nɩrɛ jaa? Bo yɩ tara, ka a ba ɩ Nãaŋmɩn lɛ kʊ yɩ ɛ? Ala ɩ a Nãaŋmɩn lɛ kʊ yɩ, ŋmɩnɛ a ɩ a yɩ bʊɔrɔ yuor fɩka yaa ɩ lɛ ɛ? ");
INSERT INTO biv_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Yɩ ben tara bon jaa yɩn bʊɔrɔ! Na yɩ be ɩ taraa dẽme! Yɩ ben lɩɛb nãmɩne ka sɩn ba ɩ ɛ! Maa bɔfʊ lɛ fɩka yɩ ta ɩ a nãmɩne sɩrɛ jaa, ka a sɩ mɩ ta pʊɔ yɩ ɩ a nãmɩne. ");
INSERT INTO biv_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Bojũu maa sɛ̃, a kaara naa fɩka a Nãaŋmɩn den a sɩn na ɩ a nɩtʊ̃nsɩ a sɩ pii a nɩyɔɔ puor, a ban kʊ sɩ chãa pɔ. Ka a sɩ ɩ bʊ̃manãa kʊ a wɛr nɩ a malakasɩ nɩ a nɩbɛ ba jaa. ");
INSERT INTO biv_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Sɩn ɩn jɔlɔ a Yesu Kɩrɩsɩto jũu tɩchɛ ka a yɩn ɩ yɛ̃n dẽme a wʊ pɔ. Sɩn ɩn nɩbaalsɩ tɩchɛ ka a yɩn ɩ kpãɛn dẽme. Ba 'yɔ̃ɔnɔ̃ yɩ naa tɩ kpɛrɛ sɩn. ");
INSERT INTO biv_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Wa tãn dɩna gba, kɔ̃ nɩ kɔ̃nyũur lɛ sɩ ma chiine, ka a sɩ bʊ̃sursɩ chɩɛr chɩɛr ka ba pɔɔrɔ sɩ, saa tara yir kpɩɛrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Tʊ̃ kpãɛn lɛ sɩ ma tʊ̃n a sɩ mãɛ nuur, bala wa tʊ sɩ, sɩ ma 'yɛr nɛvɩla 'yɔ̃ɔ ba, bala sɔɔ gere sɩ, tɩ sɩ ma tara na kãnyir. ");
INSERT INTO biv_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Bala wa sɔ̃ɔnɔ̃ a sɩ yuor, sɩ maa 'yɛr tuo ɛ, wa tãn dɩna, baa bʊɔlɔ sɩ bon jaa ɛ, ka a sɩ ɩ a wɛr wʊ jaa tãpuor ju sɔɔr. ");
INSERT INTO biv_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","N ba sɛɛrɛ a anyãna ɩka n su yɩ vã ɛ, tɩchɛ ka n kpãa yɩ maa mãɛ bi'yɔ̃ɔnsɩ kaar. ");
INSERT INTO biv_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Yɩn gba tara nɩbɛ turo pie (10,000) na kaara yɩ a Yesu 'yɔ̃ɔ, tɩ yaa tara sãamɩne yɔɔ ɛ, maa na wa mʊɔl a Yesu Kɩrɩsɩto 'yɛr nʊ̃ɔ kʊ yɩ lɛ ɩ a yɩ sãa. ");
INSERT INTO biv_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Ala lɛ so ka n pãa sʊɔrɔ yɩ ɩka yɩ turo a lɛ ɩn turo. ");
INSERT INTO biv_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","A anyãna jũu mɩ lɛ so ka n tʊ̃nɔ̃ a Timoti na ɩ a n bie ɩn nʊ̃, wʊ tara na yelmãɛ a sɩ Soro pɔ. Wʊn tɩ jɛɔ yɩ naa a lɛ a n befʊ na be a Yesu Kɩrɩsɩto pɔ, na n mɩ wile nɩ a pupuorbiir gbulsɩ a jiir a jaa. ");
INSERT INTO biv_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","A yɩ bamɩne chɩɛrɛ nɩ nyãa ɩrɛ fɩka n kʊ̃ lɛ wa be go ɛ. ");
INSERT INTO biv_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Tɩchɛ a kʊ̃ lɛ kor ɛ, ala ɩ a sɩ Soro sɔɔ naa, ɩn wan a yɩ sɛ̃, naa tɩ kaa a ba ɩ a bala na chɩɛrɛ a nyãa 'yɛrɛ tɛɛ ɛ, tɩchɛ ka n tɩ kaa a kpɛ̃ɔ buor ban tara. ");
INSERT INTO biv_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Bojũu Nãaŋmɩn nãalʊ̃ʊ yele ba ɩ nɛɛ 'yɛr ɛ, tɩchɛ wʊ ɩn kpɛ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Buor sʊɔ lɛ yɩ bʊɔrɔ? Maa wa tɩrɛ, n tɩn kpaara bɩɩ nʊ̃fʊ nɩ jomm sɩɛ? ");
INSERT INTO biv_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Ba wa man kʊ ma sɩrɛ jaa ɩka sɛ̃sɛ̃yele ben a yɩ pɔ, a lɛ gba na ba ɩrɛ a bala na ba puoro pɔ ɛ. Bie na na gãn a wʊ sãa pɔɔ. ");
INSERT INTO biv_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Tɩ a yɩ chɛnɛ bʊɔrɔ yuor, vã kʊ̃ naa nyɔɔ yɩ ka yɩ dii a nɩrɛ nyãna na maal a nɩtɔ̃ bar a yɩ pɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","A maa mãɛ gba na ba be a yɩ sɛ̃ ɛ, tɩchɛ a maa tɩɛr wʊ jaa ben a yɩ sɛ̃, naa gba tɔɔr a daba 'yɛr fɩka n ben be. ");
INSERT INTO biv_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Yɩn wa lɔ̃ɔn a sɩ Soro Yesu yuor, a n tɩɛr mɩ ben a yɩ sɛ̃, ka a sɩ Soro Yesu kpɛ̃ɔ mɩ be be, ");
INSERT INTO biv_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","yɩ de a daba nyãna 'yɔ̃ɔ Satan nũu pɔ, ka wʊ sɔ̃ɔ a wʊ ãgãn bar, tɩchɛ ka a Nãaŋmɩn faa a wʊ sɩɛ a sɩ Soro bɩbir daar. ");
INSERT INTO biv_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","A yɩ yuor bɔfʊ nyã ba tara tɔ̃nɔ̃ ɛ. Yaa bɔ̃ɔ ɩka a dãbɩl jaa pʊʊr lɛ ma vɛ̃ ka a paanʊ̃ɔ vʊ̃ a yɔɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Yɩ kpaar a dãbɩl koraa bar, tɩ na yɩ ɩ paanʊ̃ɔ paalaa na ba tara a dãbɩl ɛ. Lɛ lɛ yɩ kaara sɩrɛ jaa. Bojũu Kɩrɩsɩto na ɩ a sɩ Gõl Bar Pɛɛraabile lon a sɩ bɔɔr. ");
INSERT INTO biv_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","A lɛ jũu, yɩ ta ɩ a sɩ dire a Gõl Bar Difʊ nɩ a dãbɩl koraa ɛ, a dãbɩl koraa na ɩ yosɔ̃ɔ nɩ putuyele, tɩchɛ a ɩ a paanʊ̃ɔ na ba tara a dãbɩl ɛ. A paanʊ̃ɔ na ɩ chɛchɛ ɩfʊ nɩ yelmãɛ tarfʊ. ");
INSERT INTO biv_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","A gãn 'lɔ ɩn dɔ̃ɔ sɛb kʊ yɩ, n 'yɛr ɩka yɩ taa ɩrɛ wa lɔ̃ɔnɔ̃ nɩ a sɛ̃sɛ̃nbɛ ɛ, ");
INSERT INTO biv_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","n ba 'yɛrɛ a bala na ba puoro na sɛ̃nɛ ɛ, bɩɩ a bɔgar dẽme, bɩɩ a nɩfɔlbɔ bɩɩ a tɩpuorbo ɛ. Ala ɩ lɛ lɛ, yɩ kʊ̃ naa yi a ka a wɛr nyã pɔ. ");
INSERT INTO biv_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Tɩchɛ pʊ̃pãanyã, n sɛɛrɛ na kʊrɔ yɩ, a lɛ ɩn dɔ̃ɔ bʊɔrɔ ɩka yɩ ɩ nɩ nyã. Yɩ taa ɩrɛ wa lɔ̃ɔnɔ̃ nɩ a 'lɔ na bʊɔlɔ, a wʊ mãɛ a yɩ yɛbɛ tɩ na wʊ sɛ̃nɛ, nɩ bɔgar sʊɔ, na wʊ puoro tɩbɛ, nɩ yosɔ̃ɔnɔ̃, na wʊ ɩ dãburo, nɩ nɩfɔlɔ. A nɩrɛ nyãna tɔ sʊɔ, yɩ taa ɩrɛ wa 'mataa wʊ gba dire ɛ. ");
INSERT INTO biv_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","N tʊ̃mɔ̃ lɛ ɩka n tɔɔrɔ a bala na puoro 'yɛr, tɩchɛ yɩn 'lɔ yɩ kpãa a nɩbɛ bala yɩn 'mataa puoro nɩ na tʊ̃nɔ̃ a yelsɩ anyãna. ");
INSERT INTO biv_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Nãaŋmɩn lɛ na tɔɔr a bala na ba puoro ɛ 'yɛr. “Yɩ dii a putusʊɔ 'lɔ̃nɔ̃ bar a yɩ pɔ.” ");
INSERT INTO biv_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Ala ɩ a yɩ ãsʊɔ nɩ a wʊ tɔ sʊɔ wa nyɛn 'yɛr, ŋmɩnɛ a ɩ a wʊ na tara a 'yɛr chiin a 'yɛr tɔɔrbɔ bala na ba puoro ɛ jie, tɩ bar a Nãaŋmɩn puorbo jie? ");
INSERT INTO biv_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Yaa bɔ̃ɔ ɩka a Nãaŋmɩn puorbo lɛ na wa tɔɔr a bala na ba puoro 'yɛr ɛ? Ka ala ɩ yɩn lɛ na wa tɔɔr a bala na ba puoro 'yɛr, ŋmɩnɛ a yɩ kʊ̃ tʊ̃ɔ maal a yɩ mãɛ yelbil ɛ? ");
INSERT INTO biv_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Yaa bɔ̃ɔ ɩka sɩn lɛ na tɔɔr a malakasɩ gba 'yɛr ɛ? Wa 'yɛrɛ nɩ a sɩ mãɛ yelbil? ");
INSERT INTO biv_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","A lɛ jũu, yɩn wa tara a 'yɛrbil anyãna taaba, yɩ ma ir a pupuorbo bamɩne gba yɛ̃ na ba tal tɛɛr ɛ, ka ba tɔɔr a 'yɛr. ");
INSERT INTO biv_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","N 'yɛr naa anyãna na 'yɔ̃ɔ yɩ vã, a ɩn sɩrɛ ɩka a yɩ pɔ ãsʊɔ jaa ba tara yɛ̃ jaa pʊʊr na wʊn maal a wʊ taaba 'yɛr ɛ? ");
INSERT INTO biv_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Tɩchɛ ka a yɛbɛ ma tara a yɛbɛ chiin a 'yɛr tɔɔrfʊ jie, a bala na ba ɩ a Yesu turbo sɛ̃. ");
INSERT INTO biv_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Sɩrɛ jaa lɛ ɩka yɩ ben maal bɔr, bojũu yɩ ma nyɔɔr taa chiin a 'yɛr tɔɔrfʊ jie. Bo lɛ so ka yɩ kʊ̃ naa sɔɔ ka a nɩbɛ maal yɩ dɛɛr ɛ? Bɩɩ sɔɔ ka ba fɔl yɩ ɛ? ");
INSERT INTO biv_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Tɩchɛ a yɩn mãɛ fɔlɔ nɩ taa na yɩ maala taa dɛbɛ, na yɩ maala a anyãna kʊrɔ a yɩ yɛɛr. ");
INSERT INTO biv_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Yaa bɔ̃ɔ ɩka a putudẽme kʊ̃ kpɛ be a Nãaŋmɩn nãalʊ̃ʊ pɔ ɛ? Yɩ ta bɛlɛ yɩ mãɛ ɛ. Sɛ̃sɛ̃nbɛ, tɩpuorbo, a bala na fol bɩɩ a dɔɔr na lɩɛb gãna nɩ taa, ");
INSERT INTO biv_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","bɩɩ nãnyisɩ, bɩɩ a bɔgar dẽme, bɩɩ a dãburbo, bɩɩ a yosɔ̃ɔnbɔ, bɩɩ a nɩfɔlbɔ, ba ãsʊɔ jaa kʊ̃ kpɛ be a Nãaŋmɩn nãalʊ̃ʊ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Lɛ lɛ a yɩ bamɩne mɩ dɔ̃ɔ kaara, tɩchɛ ka a Nãaŋmɩn pɛɛ yɩ bar, na wʊ oo yɩ ka yɩ ɩ chɛchɛ tu a sɩ Soro Yesu Kɩrɩsɩto yuor nɩ a sɩ Nãaŋmɩn Sɩɛ pɔ. ");
INSERT INTO biv_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","A yɩ bamɩne 'yɛr naa ɩka, n ba chire bon jaa maalfʊ ɛ. Yele jaa ba chɩre maalfʊ ɛ. Tɩchɛ a ba ɩ yele a jaa lɛ vɩɛlɛ maalfʊ ɛ. Maa kʊ̃ sɔɔ ka bon jaa so ma ɛ. ");
INSERT INTO biv_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Bamɩne mɩ ma lɛ 'yɛr naa ɩka, bʊ̃diir ben be puor 'yɔ̃ɔ, ka a puor mɩ be be a bʊ̃diir 'yɔ̃ɔ. Tɩchɛ Nãaŋmɩn na sɔ̃ɔn a jaa ayi bar. Sɛ̃sɛ̃yele jũu ba lɛ a ãgãn be be ɛ, tɩchɛ a sɩ Soro jũu lɛ, ka a sɩ Soro mɩ be be a ãgãn jũu. ");
INSERT INTO biv_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","A kpɛ̃ɔ nyãna lɛ a Nãaŋmɩn sãɩn a sɩ Soro a kũu pɔ, ka wʊ mɩ na sãɩ sɩ a kũu pɔ. ");
INSERT INTO biv_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Yaa bɔ̃ɔ ɩka a yɩ ãgãma ɩn bʊ̃'yen nɩ a Kɩrɩsɩto ãgãn ɛ? N pãa de a n ãgãn na ɩ bʊ̃'yen nɩ a Kɩrɩsɩto ãgãn naa tɩ 'mar pɔɔ baa pɔ? N kʊ̃ ɩ a lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Yaa bɔ̃ɔ ɩka nɩrɛ 'lɔ na de a wʊ ãgãn tɩ 'mar a pɔɔ baa pɔ, ɩn bʊ̃'yen nɩ a wʊ ãgãn ɛ? Bojũu a sɛb a Nãaŋmɩn gãn pɔ ɩka, “Ka ba jaa ayi ɩ ãgãn bʊ̃'yen.” ");
INSERT INTO biv_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Tɩchɛ nɩrɛ 'lɔ na de wʊ mãɛ 'mar a sɩ Soro, 'lɔ nɩ a wʊ Sɩɛ ɩn bʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Yɩ tɔɔ yi a sɛ̃sɛ̃yele pɔ. Yelbier jaa nɩrɛ na ɩrɛ ma ben a wʊ ãgãn yõo, tɩchɛ nɩrɛ 'lɔ na sɛ̃nɛ, a wʊ ãgãn lɛ wʊ maala a yelbier 'yɔ̃ɔnɔ̃. ");
INSERT INTO biv_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Yaa bɔ̃ɔ ɩka a yɩ ãgãn ɩn a Nãaŋmɩn Sɩɛ puorfʊ yir ɛ? A 'lɔ na be a yɩ 'yɔ̃ɔ. A 'lɔ yɩn nyɛ yi a Nãaŋmɩn sɛ̃ ɔ? Yaa so yɩ mãɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Nãaŋmɩn da yɩn so. A lɛ jũu, yɩ 'yɔ̃ɔnɔ̃ Nãaŋmɩn nɩ a yɩ ãgãma. ");
INSERT INTO biv_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Pʊ̃pãanyã, a yele ala yɩn sɛb kʊ ma, an taa vɩɛlɛ na ka daba ta kul pɔɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Tɩchɛ an ɩ a sɛ̃sɛ̃yele na be be jũu, daba jaa wʊ kul a wʊ mãɛ pɔɔ, ka a pɔɔ jaa mɩ kul a wʊ mãɛ sɩrɛ. ");
INSERT INTO biv_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Ka a sɩrɛ nɩ a wʊ mãɛ pɔɔ na ma lɔ̃ɔ sɔ̃ɔ, lɛ nɩ wʊ ju mɩ lɛ a pɔɔ nɩ a wʊ mãɛ sɩrɛ mɩ ma lɔ̃ɔ a sɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","A pɔɔ tɛɛ ba lɛ so a wʊ mãɛ ãgãn ɛ, tɩchɛ a wʊ sɩrɛ lɛ so. A lɛ nɛ nɩ wʊ ju mɩ lɛ, a daba tɛɛ mɩ ba so a wʊ ãgãn ɛ, tɩchɛ a wʊ pɔɔ lɛ so. ");
INSERT INTO biv_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Yɩ taa ɩrɛ wa mɔ̃ɔnɔ̃ taa a gaa jie ɛ, ka ala ba wa ɩ yɩ man taa na yɩ kʊ taa sɔ̃ɔ Nãaŋmɩn sʊɔrfʊ jũu ɛ. Ka yɩn wa sʊɔr a Nãaŋmɩn baar, a yɩ lɛ lɔ̃ɔ taa go, ka a Satan taa nyɛ yɩn kʊ̃ lɛ wa tʊɔrɔ a yɩ mãɛ nyɔɔrɔ bɛl yɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","N 'yɛr naa ɩka anyã tara na sɔr, a ba ɩ binfʊ lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","N naa bʊɔrɔ naa fɩka a dɔɔr ba ta be a n kaar. Tɩchɛ nɩrɛ ãsʊɔ jaa tara na a lɛ a Nãaŋmɩn na kʊ wʊ, ãsʊɔ jaa bon ma tɛɛ naa a wʊ tɔ sʊɔ bon. ");
INSERT INTO biv_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Pʊ̃pãanyã, a yɩn bala na ba kul taa ɛ, nɩ a pɔɔkɔɛ, a vɩɛlɛ naa ba taa kulo taa ɛ, na ba jãnɛ nɩtãa lɛ ɩn jãnɛ. ");
INSERT INTO biv_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Tɩchɛ bala ba wa tʊ̃ɔnɔ̃ nyɔɔrɔ a ba mãɛ ɛ, ba kul taa. Ala ɩ ba kul taa, a sãn ban jɛ̃ ka a vɔlaa kʊrɔ ba. ");
INSERT INTO biv_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","A bala na kul taa, a nɛbinãa lɛ a nyã, a ba ɩ maa lɛ 'yɛr ɛ, tɩchɛ a sɩ Soro lɛ 'yɛr. A pɔɔ wʊ taa ɩrɛ wa bara a wʊ sɩrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Tɩchɛ 'lɔ wa bar a wʊ sɩrɛ, wʊ taa lɛ kulo daba go ɛ, bɩɩ wʊ lɩɛb tɩ 'maal a wʊ sɩrɛ. Daba mɩ wʊ taa dire a wʊ pɔɔ bara ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","A anyã 'lɔ, maa lɛ 'yɛrɛ, a ba ɩ a sɩ Soro lɛ ɛ. Ala ɩ a Yesu turo ãsʊɔ pɔɔ ba ɩ a Yesu turo ɛ, tɩ sɔɔ ɩka wʊn jɛ̃n wʊ naa wʊ taa ɩrɛ wa dire wʊ bara ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Ala ɩ a pɔɔ mɩ lɛ ɩ a Yesu turo, tɩchɛ ka a wʊ sɩrɛ ba ɩ a Yesu turo ɛ, tɩ mɩ sɔɔ ɩka wʊn jɛ̃n wʊ naa, a pɔɔ nyɩnɛ mɩ wʊ taa bara a sɩrɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Bojũu Nãaŋmɩn kãan a danyɩnɛ na ba ɩ a Yesu turo ɛ, ka wʊ ɩ nɩsʊ̃ a wʊ pɔɔ na ɩ a Yesu turo jũu, ka a pɔɔ mɩ na ba ɩ a Yesu turo ɛ, mɩ ɩ nɩsʊ̃ a sɩrɛ na ɩ a Yesu turo jũu. Ka lɛ ba lɛ ɛ, a ba bibiir na ɩn bidɛbɛ, tɩchɛ a lɛ jũu ba ɩn bisʊ̃n. ");
INSERT INTO biv_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Tɩchɛ a 'lɔ na ba ɩ a Yesu turo ɛ, 'lɔ wa chiine wʊ chiine. Fʊn ɩ a Yesu turo, ka daba lɛ, bɩɩ pɔɔ lɛ, ta ŋmaa wʊ sɔr ɛ. Nãaŋmɩn bʊɔl sɩ naa ka sɩ kpɩɛrɛ nɩ nyã'maar. ");
INSERT INTO biv_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Ŋmɩnɛ lɛ a ɩ a fʊ̃ʊ pɔɔ, ba bɔ̃ɔ ɩka fʊn tʊ̃ɔ faa a fʊ sɩrɛ ɛ? Bɩɩ a daba, faa bɔ̃ɔ ɩka fʊ mɩn tʊ̃ɔ faa a fʊ pɔɔ ɛ? ");
INSERT INTO biv_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Ɩ̃sʊɔ jaa wʊ mɔ̃ be a jie 'lɔ a sɩ Soro na bin wʊ, nɩ a lɛ a Nãaŋmɩn na bʊɔl wʊ. A binfʊ nyãna lɛ n bin kʊ a pupuorbiir gbulsɩ ba jaa. ");
INSERT INTO biv_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Nɩrɛ ŋmaan yʊɔr tɩchɛ ka a Nãaŋmɩn wa bʊɔl wʊ bɩɩ? Wʊ taa ɩrɛ wa sɔɔlɔ a wʊ yʊɔr ŋmaafʊ ɛ. Nɩrɛ mɩ a Nãaŋmɩn na bʊɔl, ba ŋmaa a wʊ yʊɔr bɩɩ? Wʊ taa lɛ ŋmaara go ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Yʊɔr ŋmaafʊ ɩn pɔrɔ, ka a yʊɔr ba ŋmaafʊ mɩ ɩ pɔrɔ, Nãaŋmɩn yelbinsɩ fʊn turo lɛ ɩ yelkpɛ̃ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Ɩ̃sʊɔ jaa wʊ chɛnɛ a lɛ nɛ wʊn be tɩ a Nãaŋmɩn wa bʊɔl wʊ. ");
INSERT INTO biv_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Gbãgbaar lɛ yɩ dɔ̃ɔ ɩ tɩchɛ ka a Nãaŋmɩn bʊɔl yɩ bɩɩ? Yɩ ta vɛ̃ ka a ɩ tuo kʊ yɩ ɛ, ala ɩ yɩ tara na sɔr na so yɩ mãɛ, yɩn tʊ̃ɔ ɩ a lɛ. ");
INSERT INTO biv_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Bojũu ala ɩ nɩrɛ ɩn gbãgbaa tɩchɛ ka a sɩ Soro wa bʊɔl wʊ, a nɩnyɩnɛ son wʊ mãɛ a sɩ Soro jũu. Lɛ mɩ lɛ, nɩrɛ na so wʊ mãɛ tɩchɛ ka a sɩ Soro wa bʊɔl wʊ, a nɩnyɩnɛ mɩ ɩ naa Yesu Kɩrɩsɩto gbãgbaa. ");
INSERT INTO biv_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Nãaŋmɩn da yɩn da tuo, yɩ ta ɩ nɩrɛ jaa gbãgbaa ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Yɛɛr, ãsʊɔ jaa ben Nãaŋmɩn niem, ãsʊɔ jaa wʊ chɛnɛ a lɛ nɛ wʊn be tɩchɛ ka a Nãaŋmɩn wa bʊɔl wʊ. ");
INSERT INTO biv_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Pʊ̃pãanyã a bala na ba kul taa sɛrɛ ɛ, n ba tara yele jaa a sɩ Soro na kʊ ma ɩka n 'yɛr ɛ, tɩchɛ n tara na 'yɛr ɩn na 'yɛr an ɩ a sɩ Soro nɩbaal jũu, n sɔɔ naa ɩka n ɩn yelmãɛ sʊɔ ka yɩn sɔɔ de. ");
INSERT INTO biv_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","A dɩna yelwõnsɩ jũu, n tɩɛraa ɩka a ɩn vɩla ka nɩrɛ jaa kpɩɛrɛ wʊ yõ. ");
INSERT INTO biv_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Fʊ kul pɔɔ bɩɩ? Taa ɩrɛ wa dire wʊ bara ɛ. Dakʊɔr lɛ fʊ ɩ bɩɩ, pɔɔ kʊɔr lɛ fʊ ɩ? Taa tɩɛrɛ pɔɔ bɩɩ sɩrɛ kulfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Tɩchɛ ala wa ɩ fʊ kul pɔɔ, faa maal yelbier ɛ, ka ala ɩ pɔɔsaraa mɩ kul sɩrɛ, waa maal yelbier ɛ. Tɩchɛ a bala na kul taa na kpɛ̃n yelwõnsɩ pɔ ka n kʊ̃ sɔɔl yɩ a yele nyãna ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Yɛɛr, bon ɩn 'yɛrɛ lɛ ɩka, a sɔ̃ɔ ɩn jaa ŋmaa. An yi a dɩna chiine, bala na tara pɔbɔ, ba maala fɩka baa tara pɔbɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Bala na kõnõ, ba maala fɩka baa kõnõ ɛ, bala mɩ pʊɔ na pɛl, ba mɩ maala fɩka ba pʊɔ ba pɛl ɛ. Ka bala mɩ na da bon, ba maala fɩka a ba ɩ bala lɛ so bin ɛ. ");
INSERT INTO biv_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Bala mɩ na tʊ̃nɔ̃ nɩ a wɛr nyã bonsɩ, ba ta de ba mãɛ 'yɔ̃ɔ a ala pɔ ɛ, bojũu a wɛr nɩ a wʊ bonsɩ a jaa poro na chiine. ");
INSERT INTO biv_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Maa bɔfʊ lɛ ɩka yɩ ta tara yele jaa tɩɛr ɛ. An ɩ daba baa tara pɔɔ ɛ, a sɩ Soro yele lɛ wʊ ma tɩɛrɛ, lɛ wʊn na ɩ pɛl a sɩ Soro pʊɔ. ");
INSERT INTO biv_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Tɩchɛ daba na tara pɔɔ a wɛr nyã yelsɩ lɛ wʊ ma tɩɛrɛ, lɛ wʊn na ɩ pɛl a pɔɔ pʊɔ. ");
INSERT INTO biv_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Ka a wʊ tɩɛr maa gã jibʊ̃'yen ɛ. Ka a pɔɔ mɩ na ba kul sɩrɛ ɛ, bɩɩ pɔɔsarbile ma tɩɛrɛ a sɩ Soro yele. A wʊ bɔfʊ lɛ ɩka wʊ de a wʊ ãgãn nɩ a wʊ sɩɛ kʊ a sɩ Soro. Tɩchɛ pɔɔ na tara sɩrɛ, a wɛr nyã bonsɩ tɩɛr lɛ wʊ ma tara, lɛ wʊn na pɛl a wʊ sɩrɛ pʊɔ. ");
INSERT INTO biv_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Yɩ mãɛ sʊ̃ʊfʊ jũu lɛ n 'yɛrɛ nɩ a anyãna, a ba ɩ yele lɛ n bine kʊrɔ yɩ ɛ. N bʊɔrɔ naa ɩka yɩ kpɩɛrɛ a lɛ na tor na yɩ tara tɩɛr bʊ̃'yen kʊ a sɩ Soro. ");
INSERT INTO biv_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Ala ɩ ãsʊɔ jaa wa tɩɛr ɩka waa maal a lɛ na sɛɛ nɩ a pɔɔsarbile wʊn ŋmaan a bara ɛ, ka a pɔɔbile mɩ jɛ̃ kor, ka a sɛɛ ɩka ba kul taa, wʊ ɩ a lɛ wʊn tɩɛr, a ba ɩ bier ɛ. Ba kul taa. ");
INSERT INTO biv_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Tɩchɛ nɩrɛ 'lɔ tɩɛr na ba vavire ɛ, a wʊ tɩɛr ba fɩrɛ wʊ ka wʊ tʊ̃ɔnɔ̃ a tɩɛr nyɔɔrɔ na wʊ 'yɛr a wʊ tɩɛr pɔ ɩka wʊ kʊ̃ kul a pɔɔsarbile ɛ, a nɩrɛ nyã mɩ maal a lɛ na tor. ");
INSERT INTO biv_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","A lɛ jũu, nɩrɛ 'lɔ na kul a pɔɔsarbile wʊ maal vɩla, tɩchɛ a 'lɔ na ba kul ɛ, 'lɔ lɛ maal vɩla gar. ");
INSERT INTO biv_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Pɔɔ wa kul sɩrɛ, 'lɔ nɩ a sɩrɛ ben taa, tɩchɛ a sɩrɛ wa kpi wʊ tara na sɔr ɩka wʊ kul daba 'lɔ jaa wʊn bʊɔrɔ, tɩchɛ a danyɩnɛ wʊ ɩ Yesu turo. ");
INSERT INTO biv_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Lɛ ɩn nyɛ lɛ ɩka, ala ɩ waa kul sɩrɛ ɛ, tɩ na wʊ jãnɛ, wʊn ɩn bɔɔsʊ̃n sʊɔ. N tɩɛr ɩka n mɩ tara na a Nãaŋmɩn Sɩɛ. ");
INSERT INTO biv_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Pʊ̃pãanyã, a bomo ala ban ma lon bɔɔr kʊ a tɩbɛ 'yɛr lɛ n bʊɔrɔ ɩka n 'yɛr. Sɩ bɔ̃ɔn naa ɩka sɩ jaa tara na bɔ̃ɔfʊ, ka a bɔ̃ɔfʊ ma wile wʊ mãɛ, tɩchɛ nʊ̃fʊ ma vɛ̃n ka sɩ baa. ");
INSERT INTO biv_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Nɩrɛ na tɩɛr ɩka wʊ bɔ̃ɔn bon kɔ̃ɔ, waa bɔ̃ɔ bon jaa sɛrɛ ɛ, a lɛ wʊn tɩɛr ɩka wʊ bɔ̃ɔ naa ɛ. ");
INSERT INTO biv_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Tɩchɛ nɩrɛ 'lɔ na nʊ̃ Nãaŋmɩn, Nãaŋmɩn bɔ̃ɔn naa nɩnyɩnɛ. ");
INSERT INTO biv_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","A bomo ala ban lon a tɩbɛ bɔɔr nʊ̃nɔ̃ 'wɔfʊ yele. Sɩ bɔ̃ɔn naa ɩka a tɩɩ ba ɩ bon jaa a ka a wɛr pɔ ɛ, ka Nãaŋmɩn ba lɛ be be go ɛ, ka a Nãaŋmɩn bʊ̃'yen nyã tɛɛ ba lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Ka ba gba bʊɔlɔ ŋmɩnsɩ, ka saaju lɛ, bɩɩ a ka a tẽe lɛ, sɩrɛ jaa lɛ ɩka ŋmɩn yɔɔ ben be, nɩ sorbo yɔɔ. ");
INSERT INTO biv_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","Tɩchɛ sɩn sɛ̃ 'lɔ, Nãaŋmɩn bʊ̃'yen, na ɩ a Sãa bʊ̃'yen, 'lɔ sɛ̃ lɛ a bonsɩ a jaa yi, 'lɔ jũu lɛ sɩ be be, Soro bʊ̃'yen tɛɛ na ɩ a Yesu Kɩrɩsɩto, a wʊ 'yɔ̃ɔ lɛ bonsɩ a jaa tu wa, ka sɩ mɩ be be a wʊ jũu. ");
INSERT INTO biv_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Tɩchɛ nɩrɛ jaa ba lɛ bɔ̃ɔ a anyãna ɛ. Nɩbɛ bamɩne chɛnɛ na mɩlʊ̃ nɩ a tɩbɛ, bala wa ɔɔrɔ nʊ̃n jaa, ba ma tɩɛr ɩka tɩɩ nʊ̃n lɛ, ka a ba tɩɛr na bal a lɛ jũu, ba ma sɔ̃ɔ naa. ");
INSERT INTO biv_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Tɩchɛ bʊ̃diir kʊ̃ vɛ̃ ka sɩ gbʊr Nãaŋmɩn ɛ, sɩn di yele jaa ba ɩrɛ sɩ ɛ. Sɩn mɩ baa di ɛ, yele jaa ba ɩrɛ sɩ mɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Yɩ bɔ̃ɔnɔ̃ sʊ̃ ka a lɛ yɩn maala nɩ a yɩ mãɛ sofʊ taa lɩɛb kʊsɩr bãraa kʊ a bala na ba kpɛ̃mɛ a ba sɔɔfʊ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Ala wa ɩ nɩrɛ ãsʊɔ na ba kpɛ̃mɛ a wʊ sɔɔfʊ pɔ ɛ, wa nyɛ naa a fʊ̃ʊ na tara a bɔ̃ɔfʊ nyãna a fʊ tɩ dire a tɩɩ yir, a mɩ kʊ̃ 'yɔ̃ɔ wʊ ãkpɛ̃ɔ ka wʊ tɩ dire a ala ban lon a bɔɔr kʊ a tɩbɛ ɛ? ");
INSERT INTO biv_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Ka a fʊ yɛbɛ nyã a wʊ sɔɔfʊ na ba kpɛ̃mɛ ɛ, 'lɔ a Kɩrɩsɩto na kpi kʊ, fʊ sɔ̃ɔ wʊ naa nɩ a fʊ bɔ̃ɔfʊ nyã bar. ");
INSERT INTO biv_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Fʊ̃ʊ wa maal a bier nyã tɔ kʊ a fʊ yɛɛr, fʊ 'yɔ̃ɔn a ba tɩɛrsɩ baal, Yesu Kɩrɩsɩto mãɛ lɛ fʊ maal a bier a lɛ nɛ. ");
INSERT INTO biv_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","A lɛ jũu, ala ɩ bon ɩn na di na vɛ̃n ka a n yɛbɛ lo yelbier pɔ, n kʊ̃ lɛ 'wɔb nʊ̃n jaa ɛ, na n taa wa vɛ̃ ka wʊ lo ɛ. ");
INSERT INTO biv_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","N ba so n mãɛ bɩɩ? N ba ɩ a nɩtʊ̃nãa ãsʊɔ bɩɩ? N mɩ ba nyɛ a sɩ Soro Yesu nɩ nɩbir bɩɩ? A ba ɩ yɩn lɛ ɩ a sɩ Soro tʊ̃mɔ̃ ɩn tʊ̃, tɔ̃nɔ̃ ɛ? ");
INSERT INTO biv_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Ala ɩ gba, n ba ɩ a nɩtʊ̃nãa bamɩne sɛ̃ ɛ, tɩ yɩn sɛ̃ 'lɔ, sɩrɛ jaa n ɩ naa! Bojũu yɩn lɛ ɩ a jãnɛ wiil sɩrɛ jaa ɩka n ɩ naa a nɩtʊ̃nãa a sɩ Soro 'yɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","A anyãna lɛ na ɩ a maa 'yɛr ɩn na 'yɛr kʊ a bala na wa bɛrɛ ma a nɛɛ. ");
INSERT INTO biv_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","A mɔ̃ sɩn tɛɛ lɛ ba tara sɔr ɩka yɩ kʊ sɩ bʊ̃diir nɩ bʊ̃nyursɩ ɛ? ");
INSERT INTO biv_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Sɩn tɛɛ lɛ ba tara sɔr ɩka sɩ ma tara a sɩ pɔbɔ 'mataa yʊɔrɔ nɩ nɩtãa lɛ a sɩ Soro yɛɛr nɩ a Sɩfasɩ na ɩ a nɩtʊ̃nsɩ ɛ? ");
INSERT INTO biv_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Bɩɩ maa nɩ Banabasɩ tɛɛ lɛ a sɛɛ ɩka sɩ tʊ̃nɔ̃ tɩ yɩ kʊ̃ kʊ sɩ bon jaa ɛ? ");
INSERT INTO biv_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Nɩbuor lɛ ba de soja tɩ wʊ lɩɛb yara wʊ mãɛ? An lɛ ma sɛl tɩɛ tɩ ba dire a wʊ wɔ̃mɔ̃ ɛ? Bɩɩ an lɛ ɩ nachĩnɛ tɩ maa pɛ̃ a bɩr di ɛ? ");
INSERT INTO biv_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Nɩsaal kaafʊ pɔ 'yɛr lɛ a nyã ɩn 'yɛr bɩɩ? A Mosesɩ nɛbinãa ba 'yɛr a lɛ nɩ wʊ ju ɛ? ");
INSERT INTO biv_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Bojũu nɩtɔ̃ lɛ a Mosesɩ nɛbinãa dɔ̃ɔ 'yɛr, “Ta lũ a nadar 'lɔ fʊn 'yɔ̃ɔ a wʊ vara fʊ a chi nɛɛ pɔɔ ɛ.” A nadai yele lɛ fɛr a Nãaŋmɩn bɩɩ? ");
INSERT INTO biv_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Sɩrɛ jaa a ba ɩ sɩn jũu lɛ wʊ 'yɛr a anyãna ɛ? Ɔ̃ɔ, sɩn jũu lɛ ba sɛb a yelsɩ anyãna, bojũu a bala na kʊɔrɔ nɩ a bala na vara tara na tɩɛr ɩka ban nyɛn bon kɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Ala ɩ sɩ bʊr a Nãaŋmɩn Sɩɛ bʊ̃bʊrɔ a yɩ sɛ̃, an ɩn tuo ala ɩ yɩ mɩ kʊ sɩ naa a yɩ bʊ̃tarsɩ bɩɩ? ");
INSERT INTO biv_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Ala ɩ bamɩne tara na sɔr ka yɩ ma sʊ̃ʊ ba, sɩn ba lɛ a sɛɛ ɩka sɩ nyɛ gar ba ɛ? Tɩchɛ sɩn ba kpãkpãana nɩ a yele nyãna ɛ. Sɩ ma bar yele jaa ka a po, a sɩ taa pɔɔ a Kɩrɩsɩto 'yɛr nʊ̃ɔ nyãna sɔr ɛ. ");
INSERT INTO biv_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Yaa bɔ̃ɔ ɩka a bala na tʊ̃nɔ̃ a be a Nãaŋmɩn puorfʊ yir, a Nãaŋmɩn puorfʊ yir pɔ lɛ ba dire ɛ? Ka a bala mɩ na ɩ a Nãaŋmɩn bɔɔrlorbo mɩ dire a bɔɔrlo bomo ala ɛ? ");
INSERT INTO biv_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","A lɛ nɩ wʊ ju mɩ lɛ a sɩ Soro 'yɛr ɩka a bala na mʊɔlɔ a wʊ 'yɛr nʊ̃ɔ, ba mɩ dire yire a 'yɛr nʊ̃ɔ mʊɔlfʊ pɔ. ");
INSERT INTO biv_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Tɩchɛ maa ba dɩɛl a anyãna ɛ, n mɩ ba sɛɛrɛ a anyãna tɩ tara tɩɛr ɩka yɩ maal a lɛ kʊ ma ɛ. Maa kpin kɔ̃ a sa naa nɩrɛ na wa kaa a n yo bɔ yele nyãna pɔrɔ. ");
INSERT INTO biv_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Tɩchɛ maa wa mʊɔl a 'yɛr nʊ̃ɔ nyã, n kʊ̃ tʊ̃ɔ bɔ yuor ɛ, bojũu Nãaŋmɩn lɛ 'yɔ̃ɔ ma ɩka n mʊɔl. Yele na pɔɔ ma naa ala ɩ n ba wa mʊɔl a 'yɛr nʊ̃ɔ nyã ɛ. ");
INSERT INTO biv_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Maa mʊɔl a 'yɛr nyã pɔrɔ, n tara na sãyar, ala ba ɩ pɔrɔ gba lɛ ɛ, Nãaŋmɩn na kaa ir ma 'yɛr lɛ n 'yɛrɛ. ");
INSERT INTO biv_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Bo lɛ ɩ a n sãyar? Ala lɛ a anyã ɩka, n mʊɔl a 'yɛr nʊ̃ɔ pɔrɔ kʊ a nɩbɛ, naa taa bʊɔrɔ tɔ̃nɔ̃ yin a 'yɛr nʊ̃ɔ nyã mʊɔlfʊ pɔ ɛ. ");
INSERT INTO biv_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","N gba na so n mãɛ ka nɩrɛ jaa ba so ɛ, tɩ n maal n mãɛ gbãgbaa kʊ nɩrɛ jaa lɛ an na ɩ ka n tʊ̃ɔ nɩyɔɔ tɔɔ wa kʊ Yesu Kɩrɩsɩto. ");
INSERT INTO biv_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Maa wa ta a Juu nɩbɛ sɛ̃, n ma lɩɛb n mãɛ a Juu nɩrɛ, na tʊ̃ɔ ba nyɛ. A bala na be a nɛbinãa pɔ, n ma lɩɛb a ba kaar, n gba na ba be a nɛbinãa pɔ ɛ, lɛ ɩn na ɩ tʊ̃ɔ ba tɔɔ wa kʊ a Yesu Kɩrɩsɩto. ");
INSERT INTO biv_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","A bala mɩ na ba be a nɛbinãa pɔ ɛ, maa wa ta a ba sɛ̃, n mɩ ma maal fɩka n ba be a nɛbinãa pɔ ɛ, ka n na tʊ̃ɔ ba tɔɔ wa kʊ a Yesu Kɩrɩsɩto. N gba na ba so n mãɛ yi a Nãaŋmɩn nɛbinãa pɔ ɛ, tɩchɛ n be a Yesu Kɩrɩsɩto nɛbinãa pɔ. ");
INSERT INTO biv_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Maa wa ta a bala sɔɔfʊ na ba kpɛ̃mɛ ɛ, n ma lɩɛb a ba kaar lɛ ɩn na ɩ tʊ̃ɔ 'yɔ̃ɔ ba ãkpãɛn. N ma lɩɛb bon jaa kʊ nɩrɛ jaa, ala ɩ n tʊ̃ɔ naa ka n faa a bamɩne. ");
INSERT INTO biv_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","A 'yɛr nʊ̃ɔ nyãna jũu lɛ n maala nɩ a anyãna, naa mɩ na tʊ̃ɔ nyɛ a sʊ̃ʊfʊ. ");
INSERT INTO biv_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Yaa bɔ̃ɔ ka a bala na ma joro dɔ̃ɔnɔ̃ taa a joa pɔ, tɩchɛ nɩbʊ̃'yen tɛɛ lɛ ma jo na wʊ nyɛ bon ɛ? Yɩ mɩ mʊ̃ɔ nɩbir joro a lɛ na yɩ nyɛ bon. ");
INSERT INTO biv_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Nɩrɛ jaa na pʊɔ a jo dɔ̃ɔtaa nyã pɔ, wʊ ma nyɔɔrɔ naa a wʊ mãɛ yele a jaa pɔ sʊ̃. Ba ma ɩn a lɛ na ba de a vaar ban maal nãa jupil na maa kor ɛ, tɩchɛ sɩn ɩrɛ naa na nyɛ a nãa jupil 'lɔ na ba tara sɔ̃ɔfʊ ɛ. ");
INSERT INTO biv_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Ala lɛ so, n ba joro fɩka nɩrɛ na bʊ̃n joro ɛ, ŋmetaa kaar, n ba bʊ̃n lɔɔrɔ a n nuur ɛ. ");
INSERT INTO biv_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Kai, n ma ŋmen a n ãgãn na n maal wʊ a wʊ lɩɛb a n gbãgbaa, ka n taa 'yɛr Nãaŋmɩn 'yɛr ka a nɩyɔɔ wa nyɛ tɔ̃nɔ̃ tɩchɛ ka Nãaŋmɩn 'yɛr ɩka maa ba sɛɛ ɛ. N ba bʊɔrɔ a lɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Bojũu n ba bʊɔrɔ ɩka a yele nyã wʊ sɔɔl yɩ ɛ, n yɛɛr. A julõjuur dɔ̃ɔ geru pɔɔ a sɩ sãakpãmɩne ba jaa ka ba jaa tɩ kpɛ a man jɩɛ pɔ gɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Ba jaa tun a Mosesɩ puor ka a julõjuur geru pɔɔ ba, a ba tɩ kpɛ a man jɩɛ gɔ̃ɔ. ");
INSERT INTO biv_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Ba jaa lɛ di a Nãaŋmɩn Sɩɛ bʊ̃dibʊ̃'yen 'lɔ̃nɔ̃, ");
INSERT INTO biv_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","na ba nyũ a Nãaŋmɩn Sɩɛ bʊ̃nyũ bʊ̃'yen 'lɔ̃nɔ̃, bojũu ba jaa nyũn yi a Nãaŋmɩn Sɩɛ 'lɔ̃nɔ̃ na dɔ̃ɔ ɩ a kʊsɩr pie 'mataa chiine ba, a kʊsɩr pie 'lɔ̃nɔ̃ lɛ ɩ a Yesu Kɩrɩsɩto. ");
INSERT INTO biv_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","A anyã a jaa pɔ, tɩ Nãaŋmɩn pʊɔ ba pɛl ba ɛ, na wʊ nyɛ suur kʊn ba, ka a ba kũn yɛ̃yɛl be a mɔgɔ̃ɔ pɔ. ");
INSERT INTO biv_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Pʊ̃pãanyã, a yele anyãna ɩn kpãafʊ gã, ɩka sɩ taa de a sɩ tɩɛr 'yɔ̃ɔ yelbier pɔ ɛ, nɩtãa lɛ ban dɔ̃ɔ ɩ ɛ. ");
INSERT INTO biv_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Yɩ taa puoro tɩbɛ nɩtãa lɛ a bamɩne na dɔ̃ɔ puor a tɩɩ ɛ, nɩtãa lɛ an sɛb a Nãaŋmɩn gãn pɔ, “A nɩbɛ jɛ̃n na ba di na ba nyũ, tɩ pãa ir sɛ bãnɛ.” ");
INSERT INTO biv_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Yɩ taa vɛ̃ nɛ ka sɩ wa sɛ̃nɛ nɩtãa lɛ a bamɩne na dɔ̃ɔ sɛ̃ kaar ɛ. A ba nɩbɛ turo lɩjaata (23,000) dɔ̃ɔ lo kpi bɩbir bʊ̃'yen. ");
INSERT INTO biv_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Yɩ taa vɛ̃ nɛ ka sɩ wa bɛɛrɛ a sɩ Soro kaara nɩtãa lɛ a bamɩne na dɔ̃ɔ ɩ, a wʊ vɛ̃ ka a waba dʊ̃ ba kʊ ɛ, ");
INSERT INTO biv_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","na yɩ taa vʊ̃ nɛɛr 'yɔ̃ɔ Nãaŋmɩn ɛ, nɩtãa lɛ a bamɩne na dɔ̃ɔ vʊ̃n wʊ a nɛɛ ka wʊ vɛ̃ ka kũu malaka wa sɔ̃ɔ ba jaa. ");
INSERT INTO biv_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","A yele anyãna pɔɔ ba naa, naa ɩ kpãafʊ gã, ka ba sɛb bin ka a na ɩ kpãafʊ kʊ sɩ. Bojũu a ber baaraa gbʊrɔ sɩ naa. ");
INSERT INTO biv_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","A lɛ jũu, ala ɩ fʊ tɩɛr ɩka fʊ bɔ̃ɔn ara, bɔ̃ɔnɔ̃ sʊ̃, na fʊ taa lo ɛ. ");
INSERT INTO biv_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Bɛɛrkaa tuo jaa ba wa a yɩ sɛ̃, ka a ba ɩ a ala mɩn ma wa a nɩrɛ jaa sɛ̃ lɛ ɛ. Nãaŋmɩn ɩn yelmãɛ sʊɔ, wʊ kʊ̃ sɔɔ ka a bɛɛrkaa tuo 'lɔ yɩn kʊ̃ tʊ̃ɔ ɛ, wa nyɔɔ yɩ ɛ. Tɩchɛ bɛɛrkaa wa nyɔɔ yɩ, wʊn wiil yɩn a sɔr ka yɩ tu yi, na yɩ tʊ̃ɔ ara. ");
INSERT INTO biv_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","A lɛ jũu n taa Yesu turbo, yɩ taa ɩrɛ wa puoro tɩbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","N bɔ̃ɔn naa yɩn ɩ yɛ̃ dẽme ka n 'yɛrɛ a nɩtɔ̃ kʊrɔ yɩ, yɩn mãɛ yɩ pɛkaa a lɛ ɩn 'yɛr. ");
INSERT INTO biv_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","A ŋmele 'lɔ sɩn ma de puor a Nãaŋmɩn yãan, a Yesu kũu bʊ̃diir sɔ̃ɔ ma vɛ̃n ka sɩ lɔ̃ɔ põ a Yesu Kɩrɩsɩto jãɩ. Ka a paanʊ̃ɔ 'lɔ sɩ mɩn ma ŋma, ma vɛ̃ ka sɩ lɔ̃ɔ põ a Yesu Kɩrɩsɩto ãgãn. ");
INSERT INTO biv_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Bojũu paanʊ̃ɔ bʊ̃'yen tɛɛ lɛ, sɩn sɔɔ waa tɩ sɩ ɩn ãgãn bʊ̃'yen, sɩ jaa lɛ a paanʊ̃ɔ bʊ̃'yen 'lɔ̃nɔ̃ ma ta. ");
INSERT INTO biv_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Yɩ tɩɛr kaa a Isɩral nɩbɛ pɔ. A ba ɩ a bala na ma di a Nãaŋmɩn bɔɔrlo bomo ma pʊɔn a bɔɔr lofʊ jie ɛ? ");
INSERT INTO biv_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","N pãa 'yɛrɛ na ɩka a bomo ban lon bɔɔr kʊ a tɩɩ ɩn bon bɩɩ a tɩɩ ɩn bon? ");
INSERT INTO biv_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Kai, tɩchɛ a bɔɔrlo bomo ala a tɩbɛ dẽme na ma lon a ba bɔɔr, a sɩdɛbɛ lɛ ba ma lon a bɔɔr kʊ a ba ɩ Nãaŋmɩn lɛ ɛ, ala lɛ so n ba bʊɔrɔ ɩka yɩ 'matãan a sɩdɛbɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Yɩ kʊ̃ tʊ̃ɔ lɔ̃ɔn a sɩ Soro nyũn a wʊ ŋmele, tɩ lɛ lɔ̃ɔn a sɩdɛbɛ nyũn a ba ŋmele ɛ. Yɩ kʊ̃ tʊ̃ɔ lɔ̃ɔn a sɩ Soro a wʊ bʊ̃diir difʊ jie, tɩ lɛ 'mataa lɔ̃ɔn a sɩdɛbɛ bʊ̃diir difʊ jie go ɛ. ");
INSERT INTO biv_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Sɩ bʊɔrɔ naa ɩka a ɩrɛ a sɩ Soro nyuur bɩɩ? Bɩɩ sɩn lɛ tara kpɛ̃ɔ gar wʊ? ");
INSERT INTO biv_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Yɩ ma 'yɛr ɩka, saa chire yele jaa maalfʊ ɛ. Tɩchɛ a ba ɩ yele a jaa lɛ vɩɛlɛ maalfʊ ɛ. Yele jaa ba chire ɛ, tɩchɛ a ba ɩ yele jaa lɛ sʊ̃nɔ̃ ɛ. ");
INSERT INTO biv_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Nɩrɛ jaa wʊ ta bʊɔrɔ a wʊ mãɛ tɛɛ vɩla ɛ, tɩchɛ wʊ mɩ ma bʊɔrɔ a wʊ taaba vɩla. ");
INSERT INTO biv_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Nʊ̃n jaa ban daara a daa pɔ, fʊ̃ʊ wa da ɔɔrɔ ta sʊʊr ɛ, ka a taa ɩ fʊ tɩɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Bojũu a sɛb a Nãaŋmɩn gãn pɔ ɩka, “A sɩ Soro lɛ so a tẽe nɩ bon jaa na be a pɔ.” ");
INSERT INTO biv_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Ala ɩ nɩrɛ ba ɩ Yesu turo ɛ, wa maal bʊ̃diir bʊɔl fʊ, a fʊ bʊɔrɔ a chenfʊ, fʊ̃ʊ wa chen, bon jaa wʊn wa bin a fʊ niem, dire, ta sʊʊr ɛ, ka a taa ɩ fʊ tɩɛr ɛ. ");
INSERT INTO biv_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Tɩchɛ ala ɩ nɩrɛ wa 'yɛr kʊ fʊ ɩka tɩɩ nʊ̃n lɛ, ta lɛ di a bʊ̃diir ala ɛ, a fʊ̃ʊ nɩ a nɩnyɩnɛ tɩɛr jũu. ");
INSERT INTO biv_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","A nɩrɛ 'lɔ na 'yɛr kʊ fʊ tɩɛr lɛ n 'yɛrɛ, a ba ɩ fʊ̃ʊ tɩɛr ɛ. Bãa 'yɔ̃ɔ lɛ nɩbɛ na jɛ̃ kporo ma nɩ a maa mãɛ so fʊ? ");
INSERT INTO biv_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Ala ɩ n puor Nãaŋmɩn yãan 'yɔ̃ɔ a bʊ̃diir ala ɩn dire, bãa 'yɔ̃ɔ lɛ nɩrɛ na lɛ kporo ma a bon ɩn puor Nãaŋmɩn yãan tɩ dire? ");
INSERT INTO biv_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","A lɛ jũu ka yɩ nyuro na bɩɩ yɩ dire naa, bon jaa yɩn maala, yɩ maala a jaa kʊrɔ Nãaŋmɩn tɩɩr. ");
INSERT INTO biv_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Yɩ taa wa maala ka ãsʊɔ jaa wa bãr lo ɛ, ka Juu nɩrɛ lɛ bɩɩ waa ɩ Juu nɩrɛ ɛ, bɩɩ a Nãaŋmɩn puorbo ɛ. ");
INSERT INTO biv_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Lɛ gba lɛ n mʊɔrɔ naa maala pɛlɛ nɩrɛ jaa pʊɔ yele a jaa pɔ. Bojũu n ba bʊɔrɔ a maa mãɛ vɩla ɛ, tɩchɛ a lɛ mɩ na ɩ vɩla kʊ a nɩyɔɔ ka ban tʊ̃ɔ nyɛ faafʊ. ");
INSERT INTO biv_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Yɩ kaara ma na yɩ turo nɩtãa lɛ ɩn mɩ na kaara a Yesu Kɩrɩsɩto naa turo wʊ. ");
INSERT INTO biv_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","N ma kpir yɩn jaa a lɛ yɩn chɛnɛ tara a n tɩɛr na yɩ turo a yele ala a jaa ɩn dɔ̃ɔ wiil yɩ. ");
INSERT INTO biv_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Pʊ̃pãanyã n bʊɔrɔ naa ɩka yɩ bɔ̃ɔn ɩka, daba jaa ju lɛ a Yesu Kɩrɩsɩto, ka a pɔɔ jaa ju mɩ ɩ a wʊ sɩrɛ, ka a Yesu Kɩrɩsɩto ju mɩ ɩ Nãaŋmɩn. ");
INSERT INTO biv_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Daba jaa wa sʊɔrɔ Nãaŋmɩn bɩɩ 'yɛrɛ Nãaŋmɩn 'yɛr tɩ na wʊ pɔɔ a ju wʊ 'yɔ̃ɔn a ju vã. ");
INSERT INTO biv_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Ka pɔɔ jaa mɩ wa sʊɔrɔ Nãaŋmɩn bɩɩ 'yɛrɛ Nãaŋmɩn 'yɛr tɩ mɩ ba pɔɔ a wʊ ju mɩ 'yɔ̃ɔn a ju vã, a kaara fɩka wʊ põn jukpãakpol. ");
INSERT INTO biv_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Ala ɩ a pɔɔ kʊ̃ pɔɔ a ju ɛ, wʊ ŋma a ju, ala ɩ a mɩ ɩn vã pɔɔ na põ jukpãakpol wʊ ma pɔɔ a ju. ");
INSERT INTO biv_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Daba ba sɛɛ ɩka wʊ pɔɔ a wʊ ju ɛ, bojũu 'lɔ lɛ nyɛtãan a Nãaŋmɩn nɩ a wʊ tɩɩr. Tɩchɛ ka a pɔɔ mɩ ɩ a sɩrɛ tɩɩr. ");
INSERT INTO biv_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Bojũu daba baa dɔ̃ɔ yi a pɔɔ pɔ ɛ, tɩchɛ pɔɔ lɛ dɔ̃ɔ yɩ a daba pɔ. ");
INSERT INTO biv_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Nãaŋmɩn mɩ ba dɔ̃ɔ mɛ daba pɔɔ jũu ɛ, tɩchɛ wʊ mɛn pɔɔ daba jũu. ");
INSERT INTO biv_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","A nɩtɔ̃nɔ̃ jũu nɩ a malakasɩ jũu, a pɔɔ sɛɛn ɩka wʊ tara a tʊ̃ɔfʊ jãnɛ a wʊ ju pɔ. ");
INSERT INTO biv_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","A sɩ Soro 'yɔ̃ɔ, pɔɔ ba so wʊ mãɛ ɛ, daba mɩ ba so wʊ mãɛ ɛ. ");
INSERT INTO biv_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Bojũu daba pɔ lɛ a pɔɔ yi, ka pɔɔ mɩ ma dɔɔ daba. Tɩchɛ a yele a jaa yin Nãaŋmɩn sɛ̃. ");
INSERT INTO biv_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Yɩn mãɛ yɩ pɛkaa. A sɛɛn ka pɔɔ na sʊɔrɔ Nãaŋmɩn tɩ ba pɔɔ a ju bɩɩ? ");
INSERT INTO biv_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","A befʊ nyãna mɩ ba wiil yɩ ɩka ala ɩ daba mɩ tur jukɔɔl, a ɩn vã kʊ wʊ ɛ? ");
INSERT INTO biv_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Tɩchɛ ala ɩ pɔɔ lɛ wa bar a wʊ jukɔɔl ka a wooro a ba ɩ wʊ danʊ̃ɔ lɛ ɛ? Bojũu Nãaŋmɩn lɛ kʊ wʊ a jukɔɔl ka a ɩ a wʊ bʊ̃pɔɔraa. ");
INSERT INTO biv_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Ala ɩ nɩrɛ wa chɩrɛ na a yele anyãna, sɩn nɩ a Nãaŋmɩn puorbo ba lɛ tara yele jaa go ɛ. ");
INSERT INTO biv_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","A ala na tu ka ɩn wiil yɩ, tɩ n kʊ̃ tʊ̃ɔ dãn yɩ ɛ, bojũu a yɩ lɔ̃ɔ taa ma maal yɩn dɛɛr gar a vɩla. ");
INSERT INTO biv_vpl VALUES ("C111_18"