﻿USE sofia;
DROP TABLE IF EXISTS sofia.big_vpl;
CREATE TABLE big_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES big_vpl WRITE;
INSERT INTO big_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yisu Kilisigi yeligagangmekki yeikyeng kapiya yeikyengkirikke lende miza. Yisu King Ngai Tawitigi marekngangwiliyaga nak, keya Abalamgi marekngangwiliyaga nak. ");
INSERT INTO big_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalamgi marekpek Isak, keya Isakki marekpek Yakop. Yakopgi marekwili Yura keya pigi si keya sakwili. ");
INSERT INTO big_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuragi marekyau Perese keya Sara, piyaugi panumele Tema. Peresegi marekpek Eserong, keya Eserongki marekpek Lam. ");
INSERT INTO big_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamgi marekpek Aminarap, keya Aminarapgi marekpek Nasong, keya Nasongki marekpek Salemong. ");
INSERT INTO big_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Keya Salemongki marekpek Powasi, pigi panumele Leyap. Powasigi marekpek Obek, pigi panumele Lutu. Obekki marekpek Yesi, ");
INSERT INTO big_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","keya Yesigi marekpek Tawiti Yudawiligi King Ngai wiziyabek. King Ngai Tawitigi marekpek Solomon, pigi panumele were yombu Uraya meibek weiya wiziyamele. ");
INSERT INTO big_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Keya Solomongi marekpek Liyabowa, keya Liyabowagi marekpek Abaisa, keya Abaisagi marekpek Esa. ");
INSERT INTO big_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Keya Esagi marekpek Siyosapak, keya Siyosapakki marekpek Yora, keya Yoragi marekpek Usaya. ");
INSERT INTO big_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Keya Usayagi marekpek Yotam, keya Yotamgi marekpek Eyasa, keya Eyasagi marekpek Esekaya. ");
INSERT INTO big_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Keya Esekayagi marekpek Manase, keya Manasegi marekpek Amoso, keya Amosogi marekpek Yosaya. ");
INSERT INTO big_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Keya Yosayagi marekwili Sekonaya keya pigi si keya sakwili. Sekonaya wik wizigeya yombanu ngabelak Pabilong meibekka ngai mizi yongomo miziwiligu kayima logo Isileiliwili kiling ngai kela logo Isileili yongkambanu mabuwili pongo ngabelak Pabilong meibekke iza orowei kambela logo pulogo puwili yombanu ngaiwiliyegi yawe kunengkeyeng yeik mizageya koya. ");
INSERT INTO big_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Isileili yongkambanuwili pongo ngabelak Pabilong meibekke kanda pulogo puwili koya logo Sekonayagi marekpekki yeikta Siyatiyek meibek wazamiya. Keya Siyatiyekki marekpek Serabebek. ");
INSERT INTO big_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Keya Serabebekki marekpek Abayak, keya Abayakki marekpek Elayakim, keya Elayakimgi marekpek Eso. ");
INSERT INTO big_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Keya Esogi marekpek Serok, keya Serokki marekpek Ekim, keya Ekimgi marekpek Elayata. ");
INSERT INTO big_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Keya Elayatagi marekpek Eliyasa, keya Eliyasagi marekpek Matang, keya Matangki marekpek Yakop. ");
INSERT INTO big_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Keya Yakopgi marekpek Yosep, Yosep pok Maliyagi kerekpubek, Maliyamolo Yisugi panumele. Keya Yisu Kilisibek meibek, Mesiya Anotogo yawe pigi teni yaliya wazayagi pura miziweki sawiyabek. ");
INSERT INTO big_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Togo yombu pongo Abalamyaga paka Tawitiyegi puwiligu mango keya koyang wazaya puwili meleyau keya pongo ingenazikka mangobektau ono. Keya yombu Tawiti wazamiyaraga Isileili yongkambanuwili ngabelak Pabilong meibekke ngaiwiliyegi yawe kunengkeyeng yeik miziweki iza orowei kambela puwekke mango keya koyang wazaya puwili mabilik meleyau keya pongo ingenazikka mangobektau ono. Keya puraga Yisu wazamiyaragi pulogo mango keya koyang wazaya puwili meleyau keya pongo ingenazikka mangobektau ono mabilik. ");
INSERT INTO big_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yisu Kilisigi wazamiyara pelik lewagela, Pigi panumele Maliya Yosep weiweki yawi sawiyamele kapura piyau weiyagine were Anotogi Kung Walekpokko pi mandik kogo sibene kelemiya. ");
INSERT INTO big_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pilik kelemiya logo ngago Maliya mandik kogo kisi puragi Yosep pigi yawi sawiyabokko kerewiya logo piyaugi sawiya pura pi ngeliweki miza kapura Yosep pangkabek keya yongkambanuwiligi wirege Maliyayegi kendek ngago meiyagirikki pi kiyebuk kopong piyaugi yawi sawiya purik liwik ngeliweki nobiyeng miza. ");
INSERT INTO big_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pi pilik mizagirikki kumulageya wiziya logo iwek kola logo wangakka Yemizibekki angelawiliyaga nak piyegi tabunda logo angelabokko piyegi pelik meiya, Yosep, Tawitigi yeligagangmekkabek, kerewiye. Maliya yongok nugumele weiyagirikki kiyebuk mizi nagani, purik Anotogi Kung Walekpokko yenge pigi yaga mandikpek wazamiya kani. ");
INSERT INTO big_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Pi mandik nak wazamiyagi kani logo nugu yeik pugura Yisu meimo. Yeik Yisu mei puragi solorik, Yaliya wazayibek, kai, logo pi yongkambanu puguwili kaile puwiligiyengki kozandaga yaliya wazayagi logo puwili ngereke Anotoyegi iza orowei wiriyagibek legi nugu yeik pugura Yisu meimo, meiya. ");
INSERT INTO big_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pilik lewagela piyeng mabiyeng ngago koka walaka Anoto Yemizibokko Isaya mana logo Isayago yongkambanuwiliyegi kozak yeiya piyeng logo weik ngizi wameik lewagelaweki mizi. ");
INSERT INTO big_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Kerewiyi, yongok nawekke yombu nak kilindau iwek kola ono namele mandik nak kogo sagi, logo mandik nak wazamiyagi, logo yongkambanuwiligu yeik pugura Emanuwele meiyagi. Yeik Emanuwele puragi solorik pelik, Anoto teni kiling yolu. ");
INSERT INTO big_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Togo Yosep yangalektawekke Yemizibekki angelabokko piyegi mizimo meiya pilik pi miza logo Maliya weiya. ");
INSERT INTO big_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kapura pi Maliya kiling piyau yongkambu miza ono, piyau yeik koya weik pi mandikpek wazamiya, logo Yosepgu yeik pugura Yisu meiya. ");
INSERT INTO big_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yisu ngabelak Yudaya meibekke yereng Petelem meirage wazamiya. Yisu wazamiyawekkerik King Ngai Elodogo ngabelak Yudaya meibekkewiliyegi ngai wiziya. Keya Elodogo ngai wizigeya yombu yemane kangka yemaneyeng kiling nawili logo pelewewiliyegi iwaka panuwili, panga koweige yokmek lewagela laga panga yereng Yirusalem meiragi kayima logo pelik nguk yeiya, Mandik yaka wazamiya logo Yudawiliyegi King Ngaigibok talege? ");
INSERT INTO big_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Purik tonuwa yawe pelewewiliyegi pakelira mizageya tagogei tonuwago pelewe yemane namele paka yokmek lewagela laga yabekelege pakela logo ngai nak wazamiya purik tonuwago iwaka logo teni pigi ingewerege ingeyeng laliya logo yeik pugura yongolok meiweki, keya piyegi ya kumuliweki kayimawili, legi tonuwa pi talege yolu miza purikki iwakaweki, yeiya. ");
INSERT INTO big_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pulaga King Ngai Elodo ngago puragi langai kerewiya logo pi wilek ngelek kumula, purik nakko yawe pugura weiyagi purikki pi kulili legi pi wilek ngelek kumula. Keya yongkambanu Yirusalem pulogowili mabuwili mabilik miza. ");
INSERT INTO big_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tegi Elodogo Yudawiligi yombu Anotoyegi kolak miziwiligi ngaiwili keya yombu Mosegi lo piyengki waligeleyiwili menalege ngago yeiya logo puwili wawere ula logo pulaga pugu puwiliyegi pelik nguk yeiya, Kilisibek talege wazamiyagi? ");
INSERT INTO big_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pilik kai legi puwiligu pelik meiya to mela, Pi ngabelak Yudaya meibekke yereng Petelem meirage wazamiyagi, purik yombu Anotoyaga ngagora weiya logo kozak kisawiliyaga nak yeikta Maika meiyabokko Kapiya Walektikke lende mizarik pelik, ");
INSERT INTO big_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ngabelak Yudaya meibekke yereng Petelem meiraga ngai yemane ngaigi nak lewagi kani. Pok Isileili yongkambanu nogowiliyegi ngaigibek. Piliktikki wiyeke ni yereng Petelem meira, yerengyeng mabiyengka yemane panu wiziyagi. Maikago pelik lende miza, meiya. ");
INSERT INTO big_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pulaga Elodogo yaka yombu yemane kangka yemaneyeng kiling puwili menalege ngago yeiya logo puwili pi kiling liwik wawere ula logo pugu puwiliyegi talikwekke pelewemele lewagela wizigeya puwiligu pakela miza purikki nguk yeiya. ");
INSERT INTO big_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tegi puwiligu piyegi kanga nara meiya to mela logo pugu puwiliyegi pelik yeiya, Mena, inuwa pongo Petelem yerengke kambelizo logo mandikpekyegi waberek panu welizo logo inuwago pi yolok ngela puwekke purik mabura ngereke yorik neyegi kozak neizo, logo nogorau kanda pigi ingewerege ingeyau laliya logo yeik pugura yongolok meiweki kani, yeiya. Pilik yeiya logo pugu puwili weik wezayela. ");
INSERT INTO big_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Togo puwili weik kambela logo puwili tagoneige puwiligu pelewe yemane puwiligu ulogo paka yokmek lewagela laga yabekelege pakelamele ngereke pakela logo pelewemolo puwiligi ngalengale kanda i mandikpek yolumakke ngalege wila wiya yolu. ");
INSERT INTO big_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Puwiligu pelewemele wila wiyarikki pakelawekke puwili wilikwilik yemane panu miza. ");
INSERT INTO big_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pilik miza logo puwili imakke yeke ige kiliya la logo mandikpek yali panu Maliya koyilege pakela logo yeik pugura yongolok meiweki puwili ingegere puwiligiyeng laliya logo piyegi ya kumula koya. Pilik miza logo puwili kik puwiligiyengka watabi managi nayeng weiya logo mana, logo koli nayeng keya kamba kukngizi keli nayeng keya weli kukngizi keli nayendau mana. ");
INSERT INTO big_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Puwili pilik miza logo pulogo wokpok iwek kola. Puwili iwek kola koyigeya Anotogo puwili wangak nara yana logo wangak puraga Anotogo puwiliyegi Elodoyegi kando nagani, yeiya legi puwili kazing namek neing yereng ngezewiligirage kandobela. ");
INSERT INTO big_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Puwili kuna wizigeya Yosep iwek kola tawizeige wangakka Anotogi angelawiliyaga nak piyegi tabunda logo piyegi pelik meiya, Kerewiye, Elodogo ami puguwili wezayelagi logo mandikpek uliweki welagi legi nguk namizi yangalek meiya logo mandikpek yali panu iza orowei pongo ngabelak Isip meibekke kazi kambele. Pulogo wiziya nogo pulumeng wizamiweki kai puwekke ngabelak Isip meibek wiya logo yo, kayimi nangine, meiya. ");
INSERT INTO big_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tegi Yosep nguk namizi yangalek meiya logo kusarikke mandikpek yali panu iza orowei ngabelak koweige Isip meibekke kangweki kambela. ");
INSERT INTO big_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kanda pulogo morok koya Elodo ibeng. Togo pilik miza pura ngago koka walaka Anoto Yemizibokko yombu ngagora Anotoyaga weiya logo kozak kisawiliyaga nak Osiya meiyabek mana logo Osiyago kozak kaiya pura logo weik ngizi wameik lewagela, Nogo negi Marekpek ngabelak Isip meibekka ngago meiya logo pi kayima. ");
INSERT INTO big_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Togo yombu yemane kangka yemaneyeng kiling puwili kazing kalogomok naleweng neing kandobelarikku piyegi ikuyogorik kelemiya logo Elodogo purikki keriyawekke pi sisik panu miza logo Yisu uliweki kumula wizimowei pugu amiwiliyegi ngago nara yana logo mandik yereng Petelem meiragewili keya yereng mereke piyengke kirisimasi neyau keya songono kulengke ngai miza yolu puwili mabuwili yeliweki yeiya, purik pugu yombu yaka kangka yemaneyeng kiling puwiliyegi pelewemele talikwekke pakela yeiyawekke puwiligu kanga meiya to mela puragi, iwaka wizimowei kopong Elodogo mandik kirisimasi neyau keya songono kulengke ngai miza yolu puwili yelizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Togo kazing mabilikmekke ngago yombu Anotoyaga ngagora weiya logo kozak kisawiliyaga nak Seremaya meiyabokko koka walaka ngago kaiya pura weik ngizi lewagela. ");
INSERT INTO big_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Yereng Lama meirage ngago si meiya meli pilik ngago si meiya meli purik ingkeya ngabik miziwiligu. Yongok Iresel meimelegi yango keya marekngangwiligu puwiligi marekngangwiliyegi ingkeya ngabik mizi. Nawiligu puwiliyegi yalek ngago yei kapura pangka ono, purik mandik puwiligiwili mabuwili weik ibeng. Koka walaka Seremayago pilik lende mizara kele kapura weik mandikwili yela puwekke ngago pura ngizi lewagela. ");
INSERT INTO big_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Togo Yosep keya Maliya keya Yisu ngabelak Isip meibekke koyima logo koya King Ngai Elodo ibeng. Pi ibeng wizigeya wok nakka Yosep iwek kola tawizeige Yemizibekki angelawiliyaga nak ngabelak Isip meibekke piyegi wangakka tabunda wizigeya pelik meiya, ");
INSERT INTO big_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kerewiye, yombu ulogo mandikpek uliweki mizibok ulogo ibeng mena yangalek meiya logo mandikpek yali panu iza orowei paka ngabelak Isileili meibekke kang yongobele, meiya. ");
INSERT INTO big_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tegi Yosep yangalek meiya logo watabi orowei kangkiyeng kangkere miza logo mandikpek yali panu kiling ngereke Isileili ngabelakpekke kang yongobela. ");
INSERT INTO big_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kapura pi ngago King Ngai Elodogi marekpek yeikta Akeleya meibokko pigi mangobekki yawe ngabelak Yudaya meibekki ngai wiziya pura weiya puragi kerewiyawekke pi pulogo yolugirikki kulili miza. Angelabokko Yosepyegi wangakka ngereke Petelem yerengke yo nagani meiya legi pi ngabelak koweige yeikta Kalili meibekke ");
INSERT INTO big_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","yereng Nasarete meirage kambela logo kanda pulogo wiziya. Pugu pilik miza logo ngago yombanu Anotoyaga ngagoyeng weiya logo kozak kisawiligu koka walaka kisa pura weik ngizi lewagela. Puwiligu piyegi langai pelik kisagi, Pi yereng Nasarete meiragabek, kisagi. ");
INSERT INTO big_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Togo puwekke Yowan kaimelibek ngabelak Yudaya meibekke paka kurung yeikwekke lewagela logo weik yongkambanuwiliyegi ngagora yana. ");
INSERT INTO big_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Pugu puwiliyegi pelik kozak yeiya, Anotogo ngai pugumekki ngai wiziyagi pura weik mereke, legi ini kaile inugu miziyengki kuneng mizizo keya kazing kaile inuguyengka kowiti mizizo keya wilek kang inuguyeng Anotoyegi sawelizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Koka walaka Isaya yombanu Anotoyaga ngagora weiya logo kozak kisawili logo Poropekwili meiwiliyaga nakko ngago yombu nakyegi langai pera pelik kaiya, Yombu nak lewagelagi logo paka kurung yeikwekke wizimowei ngalizi pelik yeiyagi, Yemizibek lewa legi kazing inugu miziyeng waberek mizizo keya wilek kang inuguyeng pangka pangka mizizo. Kazing pilikmekke inugu kazing Yemizibekkimek kangkere mizi, yeiyagi, kaiya. Togo yombu Isayago kaiyabok Yowanyegi kaiya. ");
INSERT INTO big_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Keya Yowan poropek kokawiligu nalik koya mabilik wiziya. Kagorik pugu wakiyayeng pelik, pi liyeng Kamelmek meimekki lekpekka narik walamiya logo wakiya, keya pugu wata korik narikka pikang nak keremiza logo wangka waliya. Ngeragi puguyeng komuwili keya ngirung yengelei ngezege piyeng logo pi pilik wizagoma. ");
INSERT INTO big_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yongkambanu yereng yemane Yirusalem meiragawili keya ngabelak Yudaya meibekke yereng piyengkawili keya kai Yolodang meilingke mereke yereng piyengkawili Yowanyegi kambela. ");
INSERT INTO big_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Piyegi kanda pugu kairagi puwili kerewiya logo puwiligu kaile mizayengki Anotoyegi kimeike kozak meiya logo Yowangu puwili pongo kai Yolodang meilingke kaimela. ");
INSERT INTO big_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Togo yongkambanu kolokngagonowili piyegi kaimeliweki kayima kapura pugu yombu Palisiwili meiwili keya yombu Sadusi mei kolokngagonowilirau piyegi kaile kumulayeng kiling kayimarikki pakelawekke pi sisik miza. Yombu Palisiwili meiwili yombu Yuda kangka yemane Mosegi lo mabiyengki waberek panu kiriwei keya puwiligi yelibungang kokawiligi ngago yogongyengkirau kozang panu kiriwei mizi miziwili. Keya yombu Sadusiwili meiwili yombu Yuda Mosegi loragi kiriwei mizi kapura puwili pelik kisiwili, Yombanu nak ibeng purik kung pugubektau ibeng logo pi ngereke yangalektagi ono, kisiwili. Togo Yowangu Palisi keya Sadusi puwiliyegi pelik yeiya, Igali. Ini mabuwili kemale yenge kuzingikyengke yungke tagogei yeziyengko ngora mela nelegi kazi kangwili kelik. Takko iniyegi Anotogo kalike yombanu mamokki kazing miziyengki ngagozak keleyagi yeiya logo kaile mizayengki sisik pugura yemane kopong ngangang yanagirikki kozak yeiya logo inugu kumularik Anotogo ini ngangang yana nelegi ini neyegi kaimeliweki kayima ma talik? ");
INSERT INTO big_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ini pilik mizagi keli purik were ini kaile inugu mizi piyengki kuneng miza logo kazing kaile inuguyengka kowiti miza logo Anotoyegi sawela koyimowei Anotoyegi kazing wazono mizi piyeng mizi logo teni mabuwili kimeike pakela logo nogo ini kaimelagi. ");
INSERT INTO big_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Keya ini makngezego nakko nakyegi meiya yongomo mizi, Teni Abalamyaga kayimawili legi teni ulogo Anotoyegi sawela, kisi nagani. Anotogo king peyeng ngizi Abalamgi yango keya marekngangwili miziweki kowitagi keli kesak pi pangka. Abalamyaga kayima purikki ngago ono kapura were kaile inuguyengki kezanga mana logo wilek kangyeng Anotoyegi saweli. ");
INSERT INTO big_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ini yengeleiyeng kelik, yombanu nak ngezebokko pakeliraige yengelei nalei yengelei wilek wazonoyeng wira meli ono puwekke purik mabura pi yenge sologe winilekko kira logo panga yezizikke waliya wezamiyagi. Anotogo iniyegi pilik mizagirik mereke. ");
INSERT INTO big_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nogo yongkambanu wilek kang puwiligiyeng kaile miziyengka Anotoyegi kowitawili kai yeikpokko kaimeli kapura kalike yombanu nak lewagi. Kozang pugura keya yawe pugurago nogo mizi peyeng ulagi. Ne pokyaga kulengke logo nogo kumularik yeik nogora yeik puguraga kulengke panu, keya yeik pugura nogoraga ngalege panu. Pokko ini Anotoyegi kowita puwili Anotogi Kung Walekpokko yenge yungke kola wizeibene keleyagi keya ini nawili Anotoyegirau kowita ono puwili, pugu yezizikke yenge yungke wezayelagi. ");
INSERT INTO big_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pugu yombanuwiliyegi mizagirik iwing yaweleigi mangobokko iwing yawe puguleige mizagi mabilik. Yaweleigi mangobek iwiyeng menalege kili tiya logo limiza logo iwing ngiziyeng kebangkelagi kapura lekyeng wezamelagi. Mabilik kalike lewagibok yombanu ngizi puguwili kebangkelagi kapura yombanu pigi onowili panga yezi kusagi onozikke wezayelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Pilik mizageya keya Yisu ngabelak Kalili meibek wiya logo kai Yolodang meilingke Yowangu pi kaimeliweki kambela. ");
INSERT INTO big_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kapura Yowangu Yisu piyegi lewarikki pakelawekke Yowangu Yisuyegi pelik meiya, Nogo ni kaimeli purik pangka ono, nugu kele, ne kaimeli purik pangka. ");
INSERT INTO big_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pugu pilik kai legi Yisugu kanga pelik meiya to mela, Mabilik, weik nogo kai puragi kiriwei mize. Pilik mizi purago towa Anotogo miziweki kai piyengki kiriwei panu mizagi, meiya. Tegi Yowangu, Ei, meiya logo Yisu kaimela. ");
INSERT INTO big_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yisu kailingka tabunda yo yabekeya ngizige pugu tapakeleige pura paka ngalege lemengki kandik tiya logo Anotogi Kung Walekpek winak Kuwemimimek kelikmek piyegi yerageya logo kanda piyegi wiziya. ");
INSERT INTO big_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pulaga Anotogi kilirago paka ngalega pelik kai, Pok negi Marek nogo keli panubek. Ne piyegi wilik, kaiya. ");
INSERT INTO big_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pulaga Anotogi Kung Walekpokko Yisu miza orowei paka kurung yeik nawekke Sadang kerewawiliyegi ngaibokko Yisu kaile mizibene yang kelemiweki miza orowei kambela. ");
INSERT INTO big_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pakalege kanda pi pulogo wok yombu neyau tikinda piyeng keya kusage piyendau pi ngeragi na ono wizagoma logo Yisu weik yagasi miza. ");
INSERT INTO big_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pi yagasi legi Sadangko piyegi kanda pelik yang kelemiya, Ni Anotogi Marekpek mabura nugu king peyengki yeiya logo ngeragi wezayeng niweki kowite, purik mabura ni Anotogi Marek ngizi panubek purik ne iwakagi, meiya. ");
INSERT INTO big_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kapura Yisugu pelik meiya to mela, Anotogi Kapiya Walektikke yungke lende mizarik pelik kai, Yombanubek ngeragi nirikku keke wik yolugi ono, pilik segeya yombanubek ngago Anotogo kai piyeng mabiyengki kiriwei purik pi wik yolugi, kai kani logo ne kingyengki yeiyagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pulaga Sadangko Yisu paka Yirusalem yereng yemane Yudawiligu yereng walekta mizirage miza orowei kambela logo paka ngalege panu Anotogi i walek yemanemakke pi luweza wazamiya ");
INSERT INTO big_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","logo pelik meiya, Ni Anotogi Marekpek mabura pelega pongo ngabelakke perakta kawiye wale, purik Anotogi Kapiya Walektikke yungke lende mizarik pelik kai, Anotogo angela puguwili niyegi waberek ngaiweki wezayelagi. Keya mabeliktau kai, Inge panuyaurau ngangang miza nelegi puwiligu ni kebangkelagi. Pilik kai legi pelega perakta kawiye wale logo angelawiligu ni kebangkeli purikki nogo pakela logo ni Anotogi Marek panubek miziweki, meiya. ");
INSERT INTO big_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kapura Yisugu piyegi pelik meiya to mela, Anotogi Kapiya Walektikkerau mabilik lende mizarik pelik kai, Nugu Anoto nigi Yemizibekyegi yang kelemi nagani, kai kani logo ne perakta kawiye walagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pulaga Sadangko Yisu miza orowei lewak ngalege panu nakke kambela logo kanda pulogo ngabelakpekke piyeng mabiyeng keya yongkambanu piyengke yoluwili keya yombu ngai puwiliyegi ngaiwili kiling watabi wazonoyengki waligelemiya logo Yisugu pakela. ");
INSERT INTO big_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Pilik miza logo Sadangko Yisuyegi pelik meiya, Tamizeige yeik nogora yongolok meiweki ni neyegi ingegereyau laliyi keya neyegi ya kumuli puwekke purik mabura nogo ni watabi nugu pakeli piyeng mabiyeng nanagi, meiya. ");
INSERT INTO big_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kapura Yisugu piyegi pelik meiya to mela, Anotogi Kapiya Walektikke yungke pelik kai, Ni Anoto Yemizi nugubekki yeikta yongolok meiweki ingeyau laliyi keya piyegi ya kumulimo keya yawe pi wamenakpekki pura keke mizimo, kai kani logo Sadang, ne ngago nugu kai pura mizagi ono legi kazi kune, meiya. ");
INSERT INTO big_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pulaga Sadang Yisu wezamiya logo weik wizigeya Anotogi angelawili kanda Yisuyegi waberek ngai koya. ");
INSERT INTO big_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Togo Yowan kaimelibokko King Ngai Elodoyegi kaile pugu mizayengki kozang kozak meiyarikki wiyeke Elodogo Yowan wigirimakke wazamiya. Yisu purikki kerewiyawekke pi ngabelak Yudaya meibek wiya logo pongo ngabelak Kalili meibekke kambela. ");
INSERT INTO big_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pi yereng Nasareterage yoluweki kambela ono, pi yereng Kapaneyam meirage yoluweki kambela. Yereng pura kai kolamiya Kalili meibekke mereke yolura keya pulogo koka walaka yombu Sebulongki yeligagangmek keya yombu Natalaigi yeligagangmek koya kopong kabelak puragi yeikta Sebulong keya Natalai mei. ");
INSERT INTO big_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Togo Yisugu pulogo pilik kang pura ngago koka walaka yombu ngagora Anotoyaga weiya logo kozak kisawiliyaga nak Isaya meibokko pelik kaiya pura weik ngizi lewagela, ");
INSERT INTO big_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ngabelak Sebulong keya Natalai mei, kai kolamiyabekki mereke wizigeya, ngabelak kai Yolodang meilingka pangazuwage pulumengke, Kalili meibekke yombanu Yuda onowili yolu. ");
INSERT INTO big_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yongkambanu pulumengke yolu puwili kusa panurikke yoluwiligu wilangka ngaiwak yemane narik pakela logo wilangka purik yongkambanu kazing kumbekki Anotoyegi leweng ibeng puwiliyegi ngaiwak wiya yolu. Togo Yisu pulumengke yoluweki kambelawekke, ngago Isayago kaiya pura weik ngizi lewagela. ");
INSERT INTO big_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pulagarik Yisu weik pulogo yongkambanuwiliyegi ngagora yani. Pugu puwiliyegi pelik yeiya, Anotogo ngai pugumekki ngai wiziyagi pura weik mereke mena ini kaile inugu mizayengki kuneng mizizo keya kazing kaile inuguyengka kowiti mizizo keya wilek kang inuguyeng Anotoyegi sawelizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Wok nakke Yisu kai kolamiya Kalili meibekke kerelemekke wei mizi tagoneige, pugu yombu ingini neyau pakela, piyau Simong yeik nara Pita, keya pigi sakpek Enduru logo piyau kaibekke kik kawekkik wezamelageya koyilege, purik piyau yawe kik kawek yemaneyengke watabisi uli keya kingyengki ngane yanirage miziyau. ");
INSERT INTO big_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yisugu piyauyegi pelik yeiya, Ne kiling saweliweki kiriwei koli, nogo yaliyegi yawe yongkambanuwili neyegi ngizi panu kumulibene iza oroweigi puragi waligeleyiweki. ");
INSERT INTO big_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pilik yeiya logo piyau nguk namizi kik kawekyeng wila mela logo Yisu kiling saweliwei kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Puwili pulaga songono nangezi kanda pura pugu Sebetigi marekyau Jems keya Yowan pakela. Piyaugi mangobek Sebeti piyau kiling wangleige ngalege kik kawek puwiligiyeng keremizageya koyilege. Yisugu pakela logo piyauyegi, Ne kiling yawe miziweki koli, yeiya ");
INSERT INTO big_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","logo piyaugi mangobek nguk namizi wangleige ngalege mabulogo wezamiya logo piyau Yisu kiling saweliwei kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Togo Yisu puwili kiling ngabelak Kalili mabokko yongomo mizageya wizimowei Yudawiligi i walek songonoyengki la logo Yisugu yongkambanu wawere uliwiliyegi ngago wazono Anotogo ngai pugumekki ngai puragi kiliyagi puragi kozak yeiya, Keya pugu yongkambanu kemegeme nalangai nalangai mizi puwili keya ngangang mizi puwili yombiyangai wazaya. ");
INSERT INTO big_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Togo Yisugu miziyengki wiyeke yenge ngabelak Siriya meibekke yeik pugura yemane lewagela logo ululu miza mela. Piliktikki kandik yongkambanuwiligu piyegi yombanu kemegeme nalangaiyengko mizi puwili keya yombanu ngangang mizi puwili keya yombanu kerewa yenge puwiligi yungke ngaiweki kiliya yolu puwili keya kemegeme piyeng keya walimekka mizi puwili keya yombanu inge keya meleyeng ibeng puwili mabuwili iza orowei lewa logo Yisugu puwili mabuwili yombiyangai wazaya. ");
INSERT INTO big_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Togo yongkambanu kolokngagono panu pelege ngabelak Kalili meibekke yerengyengka keya panga ngabelak Tekapoli meibekke yerengyengka keya paka ngabelak Yudaya meibekke yerengyengka keya yereng yemane Yirusalem puragarau keya kabelak kai Yolodang meilingka pangazuwage lemengke yerengyengkawili Yisuyegi kiriwei kelemi kambela. ");
INSERT INTO big_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pulaga Yisugu yongkambanu kolokngagonowiliyegi pakela logo paka lewakpekke yabela. Kanda paka pulogo pi mogosa logo yombanu Yisu ngezebokko waligeleyiwili piyegi mereke kanda mogosa ");
INSERT INTO big_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","logo pugu puwiliyegi weik pelik kozak yeiya, ");
INSERT INTO big_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ini yombanu kazing kung inuguwiligi leweng watabiyengki yeik purikki keriyi puwili wilikwilik miziweki, purik Anoto weik ngai inugubek logo ini ngai pugu ngai yolu puragawili legi. ");
INSERT INTO big_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ini yombanu ya kuneng logo ingkisageya yolu puwili wilikwilik miziweki, purik Anotogo iniyegi yalekta yanagi legi. ");
INSERT INTO big_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ini yombanu yeik ngezewiligiyeng yongolok mei ono puwili wilikwilik miziweki, purik ini inigi Mangobekki yeikta kilingwili logo kalike ini inigi Mangobekki ngabelakpek weiyagi legi. ");
INSERT INTO big_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ini yombanu kazing pangka panu pumok miziweki kozang keli puwili wilikwilik miziweki, purik ini Anotogi pangka piyengko kola yolugi legi. ");
INSERT INTO big_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ini yombanu, yombanu nazuwagawiliyegi yalek keli mizi puwili wilikwilik miziweki, purik Anotogo iniyegi mabilik yalek mizagi legi. ");
INSERT INTO big_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ini yombanu Anotoyegi wilek neyau ono puwili wilikwilik miziweki, purik kalike inugu Anotoyegi pakelagi legi. ");
INSERT INTO big_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ini yombanu nakko nakyegi ya kuzige sara koyibene keleyi puwili wilikwilik miziweki, purik ini Anotogo pigi yango keya marekngangwili yeiyagi legi. ");
INSERT INTO big_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ini yombanu Anotogi kazing pangkamekki kiriwei mizirikki wiyeke nawiligu ngangang keleyi ma kuneng yani puwili wilikwilik miziweki, purik Anoto weik ngai inugubek logo ini ngai pugu ngai yolu puragawili pigi legi. ");
INSERT INTO big_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kalike neyegi weraga yongkambanuwiligu iniyegi yang yei ma ngangang keleyi ma kuneng yani ma ngago kaile iniyegi kuneng yaniweki ngaigu kisi piyeng kisi puwekke ini wilikwilik miziweki. ");
INSERT INTO big_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Koka puwiligi yelibungangwiligu mabilik panura yombanu Anotoyaga ngagora weiya logo kozak kisawiliyegi keleya. Keya puwiligu iniyegi pilik mizagi kani. Logo puwekke ini wilik miziweki keya wilikwilikmokko kolawili mizi, purik paka ngalege inugu watabi miza piyengki wiyeke kanga wazono weiyagiyeng yemane legi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Togo Yisugu puwiliyegi mawinda pelik yeiya, Ini neyegi kiriwei miziwili wizandik kelik. Wizandikki yawera ngeragiyeng kolok kelibene wiyagira keya kazing mabilikmekke yawe inugura ngabelakpekke yongkambanuwili kiling kuzige sara koyimowei puwiliyegi Anotogi kazing pangkamekki waligeleyagira. Kapura tamizeige wizandikki kolok keli pura yeik puwekkerik kazing ngereke kolok kelibene keremizagi namektau ono, yawe pugura weik yeik. Logo wizang piliktik weik kailerikku logo wezamelagirikku logo yombanuwili purikki ngalege wei yongomo mizi. Keya kazing mabilikmekke ini neyegi kiriweiwekke kiyebuk sende logo wiyi purik yawe inugu neyegi mizagira weik yeik. ");
INSERT INTO big_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Keya ini neyegi kiriwei miziwili ngaiwaktik kelik logo ngaiwak wiyageya koyimowei yongkambanuwiligu kazing nogomekki pakeliweki. Yombanuwiligu yereng yemane lewakpekke ngiza pura watabi nayengkorau liwik momane meiyara wiziyagi ono. ");
INSERT INTO big_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Keya yombanu nakko lang nak langiya logo kaimirage yenge yungke liwik wiyagi ono, pilik segeya paka lalektage ngalege kimeike wiya wiziyagi logo ngaiwaktikke yombanu ige yolu puwili watabiyengki pangka pakeliweki. ");
INSERT INTO big_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yongkambanuwiligu lambekki ngaiwaktikki pakeli pilik, kazing mabilikmekke neyegi weraga ini kazing pangkamekki mizi kang purik yongkambanuwiligu kazing wazono inugu miziyengki pakelagi logo Anoto tenigi Mango paka ngalege yolubekki yeikta yongolok meiyagi. ");
INSERT INTO big_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Togo inuwago neyegi langai kumulirik ne lewa purik Anotogi lo Mosego lende miza piyeng keya ngago yombanu Anotoyaga weiya logo kozak kisawiligu waligeleya piyeng wezameliweki lewabek sawiyi nagani, a’a’. Pilik segeya ne lo piyengki kemenak kiriwei miziweki lewabek keya watabi yombanu Anotoyaga ngagora weiya logo kozak kisawiligu kisa piyeng weik ngizi lewageliweki kelemiweki lewabek. ");
INSERT INTO big_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kerewiyi, ngilumbek keya ngabelakpek mabilik koyigeya Mosegi lo piyengka ngago lang lende miza piyengka lang songono narikpang kakwelagi ono kani. Were mabiyeng ngizi lewagela logo pulaga ngilumbek keya ngabelakpek yeik sagi. ");
INSERT INTO big_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mosegi lo mabiyeng yemane legi tamizeige namele keya nakko lo piyengka nara songonora miza logo ngela logo yombanu nawiliyegi pugu mabilik miziweki kozak yeiya purik mabura kalike pilik mologabok paka ngalege Anotogo ngai pugumekki ngai yolu puragi kang puwekkerik yeik pugura songono sawiyagi. Kapura namele keya nak Mosegi loyengki kiriwei mizi logo yombanu nawiliyegi pugu mabilik miziweki kozak yeiya purik mabura kalike pilik mologabok paka ngalege Anotogo ngai pugumekki ngai yolu puragi kang puwekkerik yeik pugura yemane sawiyagi. ");
INSERT INTO big_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kapura nogo pera kozak kaiweki, yombanu Mosegi loyengki waligeleyiwili keya yombanu Palisiwili meiwiligu pelik kisi, Teni Mosegi loyengki waberek kiriwei mizi kopong teni pangkawili kisi kapura puwili pangkaraga yolu ono. Logo tamizeige kazing inugu miziyeng kazing puwiligu mizi piyengka lewege panu ono purik mabura inirau paka ngalege Anotogo ngai pugumekki ngai yolu puragi kiliya logo wik wizagomagira weiyagi ono. ");
INSERT INTO big_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Koka tenigi yelibungangwili Mosegi loyengki kerewiya, keya mabek ngoluk yombanu Mosegi loyengki waligeleyiwiligu piyengki kozak kisi keya inirau kerewiyi logo piyengka nara pelik, Yombanu uli nagani, purik tamizeige nakko yombanu nak ula logo ibeng mabura yombanu pilikpok ngagozak miza logo ngangang weiyagi. ");
INSERT INTO big_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kapura lo nogoragarik pelik, Yombanu namele keya nakyegi sisik panu mizi nagani, purik tamizeige nakko yombanu nakyegi sisik panu mizi mabura pilik mologabok ngagozak miza logo ngangang weiyagi. Keya tamizeige nakko nakyegi ngago kaile meiya mabura pilikpok yombanu ngagozak piyengki kerewiyiwiligi wirege luwezagi. Keya tamizeige nakko nak kiling ngalik keliwekke, Ni ibeng se, meiya purik mabura pilikpok yereng yezi yemane kusagi onozik ngoriraga wezamelagi. ");
INSERT INTO big_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Pilik tegi tamizeige nugu king nayeng Anotoyegi opa maniweki orowei paka alatarage wiyiweki mizi kapura namele keya nak ni kiling ngalik kelarikki kumuli ");
INSERT INTO big_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mabura oparik wiyi nagani, were ni kiling ngalik kela mologabokki ngalik yaka pura pangka pangka miza logo waberek miziweki kunimo. Were pilik miza logo yeke i walekmakke kiliya logo nugu king piyeng Anotoyegi opa maniweki orowei paka alatarage wiyimo. ");
INSERT INTO big_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Keya iniyaga nak yombanu nakko ngagozak kelemiweki miza orowei kang purik mabura ngagora nguk namizi pi kiling pangka pangka mizimo. Kazingke mabulogo pi kiling kunimowei yali ngagora waberek kozak kela logo yeik sa wiyizo, purik pugu ni yombanu ngagozakta kerewiyagibekyegi niza orowei kuna nelegi, keya pugu wagelawiliyegi niza yana logo puwiligu i wigirimakke wigira wazaniya nelegi. ");
INSERT INTO big_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kerewiyi, pilik miza puwekke purik ni i wigiri pumakka welagela yeragiyagi ono wiziya wiziya nugu ni ngagozak keleniyagibekyegi watabi kaile nugu mizi kayima piyengki kangayeng mabiyeng mana purik mabura kele. ");
INSERT INTO big_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Keya yombanu Mosegi loyengki waligeleyiwiligu piyengka nararau iniyegi kozak yeiya logo ini pelik kerewiya, Yongkambu weiya puwili nigi kerekpu onobek ma nigi yongokpu onomele kiling iwek koli nagani. ");
INSERT INTO big_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kapura lo nogoragarik pelik, Tamizeige nakko yongok nameleyegi pakela logo pi kiling iwek koliweki kira orowei mizi purik mabura yaka wilek kang pugubekke pugu kumula purago pi weik yongok pumolo kiling iwek kolabek kelemi yagenda logo pi yombanu yongok ngezebekkemele weiya wizimowei ngereke namele kiling iwek kolibok kelik mizi yagenda. ");
INSERT INTO big_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tegi tamizeige wire nuguyauga nakko ni ulumiya logo ni kaile mizibene keleniyageya purik mabura kazing kaileyengki pumok ngela melibene wirebok tiya mela logo wezamelagibokko, purik wire wamenak kiling purik kaile kele kapura korik nuguwek mabuwek kiling ni kaile mizageyara yereng yezi yemane kusagi onozik ngoriraga kangki purik kaile panu. ");
INSERT INTO big_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Keya mele nuguzikku ni ulumiya logo ni kaile mizibene keleniyageya purik mabura kazing kaileyengki pumok ngela melibene mele puzik ngela mela logo wezamelagizikku, purik mele wamenazik kiling purik kaile kele kapura korik nuguwek mabuwek kiling ni kaile mizageyara yereng yezi yemane kusagi onozik ngoriraga kangki purik kaile panu. ");
INSERT INTO big_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Keya yombanu Mosegi loyengki waligeleyiwiligu nararau iniyegi pelik yeiya, Tamizeige yombu nak yongok pugumele wezameli mabura pugu pigi yongokpumeleyegi kapiya narik lende miza maniweki logo kapiyarikku yongokmeleyegi ni weik yongok nogomele ono kai purik pugu pi wezameli. ");
INSERT INTO big_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kapura lo nogoragarik pelik, Yombanu nakki yongokpumele yombu nak kiling iwek kolarikki wiyeke pugu wezameli purik pangka, kapura yombanu nakki yongokpumele yombu nak kiling iwek kola onomele wezameli purik pangka ono. Yombu pilik mizibokko yongok pugumele kaile miziweki kelemi yagenda, purik tamizeige yaka yongokmele ngereke yombu nak wei purik pi yongok yombu ngezemelegibek weiya wizimowei ngereke nak kiling iwek kolimolo kelik mizi yagenda. Keya yombu nak yongok nakko wezamelamele wei purik pirau mabilik yombanu yongok ngezebekkimele weiya wizimowei ngereke namele kiling iwek kolibok kelik mizi yagenda. ");
INSERT INTO big_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Keya lo nararau koka tenigi yelibungangwiligu kozak kisi kayima pura logo ulogo inugurau kerewiya logo pura pelik, Ngago sawiya nugu kozang kelemiweki paka ngalegebekyegi kai pura ngeli nagani, keya nugu ngago pilik kaiya puragi Yemizibekki wirege kiriwei mabilik panu mizimo. ");
INSERT INTO big_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kapura lo nogoragarik pelik, Ni ngago nara kaiya logo puwiligu ngago nugu kairagi ngizi panu kumulagirikki nugu keli purik mabura Anotogi wirege ma nakki wiregerau wameik panu kai nagani, ngago nugura yeik kai. Ma Anotogi yeikta ma nakki yeikta ma watabi nayengki yeiktagirau ngago ngago kai nagani logo nogo wameik panu kai, kai nagani, ngago nugura yeik kai. Ma ngago nara kozang kelemiweki paka ngalegebekyegi kai nagani, purik paka ngalege lemeng tung Anotogi mogosirik legi. ");
INSERT INTO big_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma ngago nara kozang kelemiweki pongo ngabelakpekki langai, ngago ngago kai nagani, purik Anotogo ngabelakpek keremiza logo ngabelak mabok piyegi kulengkebek legi. Ma ngago nara kozang kelemiweki yereng yemane Yirusalem meiragi ngago ngago kai nagani, purik yereng pura King Ngaibekkira legi. ");
INSERT INTO big_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma nugu ne kebi nogorage wameik panu kai, kai nagani, purik nugu kebi nuguraga kebi nganelek wilangke nak kusabanu lewageliweki kelemiyagirik pangka ono legi, ma kebi nganelek kusabanu nak wilangke lewageliweki kelemiyagirik pangka ono legi. ");
INSERT INTO big_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Anotogo kebi nugura keremiza legi kebiragi ngago ngago kai nagani, yeik pelik kai, Ei, mabura kaimo ma yeik kai. Ngago purago lewagela piyeng Sadangko kaibene keleniyeng kani. ");
INSERT INTO big_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Keya puwiligu iniyegi lo nararau pelik kozak yeiya, Tamizeige yombanu nakko wire nugubek kaile kelemiya purik mabura nugurau wire pugubek mabilik kanga kelemimo, ma tamizeige yombanu nakko kili nugubek tukula purik mabura nugurau mabilik kanga kelemimo. ");
INSERT INTO big_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kapura lo nogoragarik pelik, Nakko niyegi kaile nayeng miza mabura nugu piyegi kanga kelemi nagani. Tamizeige yombanu nakko wiregawere nuguraga nazuwaga melegozok neli mabura nugu wiregawere pugura melegozok uli nagani, segeya ni tolikta sa logo pugu ngereke wiregawere nuguraga nazuwaga melegozok nelibene kelemimo. ");
INSERT INTO big_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Keya tamizeige yombanu ni ngagozak keleniyagibokko melewangke nugurik orowei purik mabura melewang purik orowei kuni pani kelemimo keya kagorik nigi yeke ngalege waliyariktau manimo. ");
INSERT INTO big_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Keya tamizeige yombanu nakko yali pongo kazingke wang songono narik kangweki kai purik mabura pi kiling kunimo. Ei, nugu pongo kazingke wang yokolong yaka yali wiriya pilik nariktau mawinda kunimo. ");
INSERT INTO big_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Keya tamizeige yombanu nakko niyegi watabi nayeng maniweki kai purik mabura nugu pi manimo, keya tamizeige yombanu nakko watabi nigi nayeng wangki kanga nanagine nguk kai purik mabura wilik kagowinda kiling nugu pi manimo. ");
INSERT INTO big_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Puwiligu iniyegi ngago pera ulogo pelik yeiya, Ni nigi ingembungangwiliyegi kelimo, kapura nazuwagawiliyegi kumbak mizimo. ");
INSERT INTO big_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kapura lo nogoragarik pelik, Nugu nazuwagawiliyegirau kelimo. Keya niyegi watagak ngeli puwiliyegi wazono keleyimo. Keya yombanu niyegi kaile keleni puwiliyegirau wazono keleyimo. Keya Anotogo yombanu niyegi kaile keleni ma niyegi kuneng nani puwiliyegi sawelibene waberek mizimo. ");
INSERT INTO big_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kazing pangka pilik pumokkomekke ini inigi Mango paka ngalege yolubokki yango keya marekngangwili purikki walimizagi, purik Anotogo yok pugumek yombanu kaile miziwili keya wazono mizi puwili mabuwiligi yaweyengke pangka pangka ngela manibene kelemi mizi. Keya Anotogo koboyau yombanu kaile miziwili keya pangka miziwili mabuwiligi yaweyengke pangka pangka kobo kulibene kelemi mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Keya Yisugu mawinda pelik yeiya, Yongkambanu mabuwiligu mizirik yombanu puwiligu keli puwiliyegi puwili keli. Yombanu king takis wei piyengka nayeng ngowei mizi puwilirau pilik miziwili. Tamizeige ini yombanu iniyegi keli puwiliyegi inugu keke keli purik kalike pilik puragi weraga kanga wazono weiyagiyeng yeik. ");
INSERT INTO big_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Keya yongkambanu mabuwiligu mizirik yombanu ngezewiligi ingembuwiliyegi keke ngagozakke mizi. Yombanu Anotoyegi iwaka onowilirau pilik miziwili. Tamizeige inugu ini makngezegi ingembuwiliyegi keke ngagozakke mizi purik inugu kazing miziyengko yongkambanu Anotoyegi iwaka onowiligu kazing mizi piyengka lewege mizagi ono. ");
INSERT INTO big_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pilik tegi iniyegirik inigi Mango paka ngalege yolubokko kazing pangkamekke yolu pilik inirau mabilik kazing pangkamekke yoluweki, yeiya. ");
INSERT INTO big_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Keya Yisugu mawinda pelik yeiya, Ini watabi wazono inugu mizagiyeng mizi logo yongkambanuwiligu keriya logo yeik inuguyeng yongolok meibene mizi nagani ini ngai waberek panu, purik yombanu pilik miziwili kalike puwiligi Mango paka ngalege yolubokko puwili watabi puwiligu mizayengki wiyeke kanga wazono weiyagiyeng yanagi onowili. ");
INSERT INTO big_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pilik legi nugu yombanu watabiyengki yeik nakyegi watabi nayeng mani puwekkerik yombanu mabuwiliyegi kozak yei nagani, ngagoluk mani. Yombanu kiligang neyau lewawiligu i walek songonoyengke opa mani puwekkerik puwiligu nawiliyegi kozak yei logo yongkambanuwiligu mele korokkorok ulibene, keya yeik puwiligiyeng yongolok meibene, logo puwiligi kanga wazono weiyagiyeng mabiyeng, kalike mawinda Anotoyaga kanga wazonoyeng weiyagi ono. Keya yombanu kiligang neyau lewawiligu yerengyengke yombanu watabiyengki yeikwili nakyegi watabi nayeng mani puwekkerik puwiligu nawiliyegi kozak yei logo yongkambanuwiligu yeik puwiligiyeng yongolok meibene. Nogo wameik kai, logo watabi puwiligu mizayengki wiyeke kanga wazono weiyagiyeng mabiyeng, kalike mawinda Anotoyaga kanga wazonoyeng weiyagi ono. ");
INSERT INTO big_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kapura nugu yombanu watabiyengki yeikwiliyaga nakyegi watabi nayeng managi keli puwekke mabura kazing ngagoluk panu nigi ingembu ma mereke niyegi yolu pilikpokko keriyagi langai ono pilik pumokko mizimo logo ");
INSERT INTO big_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kazing yalek nigi pumok liwik wizeibene logo nigi Mangobokko watabi wazono nugu nazuwagawiliyegi liwik miza piyengki keriya puwekke watabi nugu mizayengki wiyeke kanga wazonoyeng nanagi. ");
INSERT INTO big_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Keya yombanu kiligang neyau lewawili Anotoyegi waberek miziwekkerik puwili i walek songonoyeng keya yerengyengke yongkambanuwiligi wirege yongkambanuwiligu pakeli keya yeik puwiligiyeng yongolok meibene waberek miziweki keliwili. Kerewiyi, puwiligu yaka watabi puwiligu mizayengki wiyeke kanga wazono weiyagiyeng mabiyeng, mawinda paka ngalege weiyagi ono. Puwili kelik nagani, ngai waberek panu. ");
INSERT INTO big_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Keya ni Anotoyegi waberek mizi puwekke purik mabura ni makngeze liwik miziweki kunimo logo Anoto nigi Mango nugurau keriyi onobekyegi waberek mizimo logo Anoto nigi Mangobokko watabi nugu liwik miziyengki keriya logo watabi nugu mizayengki wiyeke kanga wazonoyeng nanagi. ");
INSERT INTO big_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Keya yombanu Anotoyegi iwaka onowiligu anoto puwiligiwiliyegi waberek miziwekkerik puwili ngago yeikyeng mei keya ngago lang pilikyeng meiyageya mizi. Puwiligu kumulirik teni waberek yokolong mizi purik mabura puwiligu teniyegi kerewiyagi langai, mizi. Kapura ini pilik mizi nagani, a’a’. ");
INSERT INTO big_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Purik Anoto inigi Mangobek inugu piyegi nguk meiweki mizi piyengki pi yaka iwaka legi kazing puwiligu ngago pilikyeng meiyageya mizi pumokki ini kiriwei mizi nagani. ");
INSERT INTO big_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kazing waberek mizagimek pemek, O Peba, tenigi Mango paka ngalege yolubek, niyegi kazing korowali nayendau ono, legi teni wizageya koyi kambelimok mamok yeik nugura yongolok meiweki. ");
INSERT INTO big_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yongkambanu mamok panga nigi ngaimekki yungke kiliya logo nugu ngaiweki wiriyibene keleye. Keya keli nuguraga puwili paka ngalege kiriwei mizi mabilik tenirau pelege ngabelakpekke kiriwei miziweki keleye. ");
INSERT INTO big_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Wok pekki pangka ngeragi nagi piyeng teni yane. ");
INSERT INTO big_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nugu kaile tonugu miza piyeng tumule logo keremareke wezamele, purik tenirau mabilik kaile nawiligu teniyegi keleya piyendau tumula logo weik keremareke wezamela legi. ");
INSERT INTO big_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Watabi teni yang keleyagi piyengko mizagewiyege teni kaile miziweki keleya nagani. Kapura Sadang kaile mabiyengki mangobekki melezikka teni yaliya wazaye. Keya niyegirik, ni yombanu kozang yemane wizagomagira kilimbek keya yeik yemane wizagomagira kilimbek keya nugu teni nigi ngaimekkiwiliyegi ngai yemane panu wizagomagi. Wameik panu. ");
INSERT INTO big_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Keya Yisugu puwiliyegi mawinda pelik yeiya, Kerewiyi, tamizeige inugu kaile yongkambanuwiligu iniyegi keleya piyeng tumula logo keremareke wezameli purik mabura Anoto inigi Mango paka ngalege yolubokkorau kaile inugu mizayeng tumula logo keremareke wezamelagi. ");
INSERT INTO big_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kapura tamizeige inugu kaile yongkambanuwiligu miza piyeng tumula logo keremareke wezameli ono purik mabura Anoto inigi Mangobokkorau kaile inugu mizayeng tumula logo keremareke wezamelagi ono. ");
INSERT INTO big_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Keya kazing wilek kang mabiyeng Anotoyegi waberek mizagirikki tiya maniweki ngeragi ni ono mizi pumok mizi puwekkerik, yombanu kiligang neyau lewawili kazing pumok mizi puwekke puwili wiregawereyeng yalek keya yagasi sowei yongomo mizi logo yongkambanuwiligu puwiligu Anotoyegi waberek miziweki ngeragi ni ono purikki pakela logo yeik puwiligiyeng yongolok meibene. Kerewiyi, yongkambanuwiligu mabelege yeik puwiligiyeng yongolok mei purikku watabi puwiligu miza piyengki wiyeke kanga wazono weiyagiyeng mabiyeng logo Anotogo kalike mawinda paka ngalege yanagi ono. ");
INSERT INTO big_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kapura kazing wilek kang mabiyeng Anotoyegi waberek mizagirikki tiya maniweki ngeragi ni ono mizimekke mizi puwekkerik ngeragi ni ono wizimowei Anotoyegi ni makngeze kuyangka wizimowei waberek mizi. ");
INSERT INTO big_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Togo nawili ni pilik mizi purikki iwaka ono, Anoto nigi Mango nugu pakeli onobokko keke iwaka, logo nigi Mangobek nugu liwik mizi piyengki pakelibokko kanga wazono nanagiyeng nanagi. ");
INSERT INTO big_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Teni ngabelakpekke pelege koyigeya king keya watabi tonuguyeng yeikki, purik wata koru watabiyeng ni namokko korowali kelemiyagi ma yombanu ngoweiwiligu watabiyeng ngoweiyagi ma koboyaugu korowali kelemiyagi, legi inigi kingyeng keya watabi wazonoyeng ngezeyeng kilisagelega wiyi kambeli nagani. ");
INSERT INTO big_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pilik segeya king inuguyeng keya watabi inuguyeng yongkambanu watabiyengki yeik puwiliyegi sawelizo. Pilik mizi purago kanga inigi wazonoyeng paka ngalege yowiyagi, keya paka ngalege kanga inigi wazonoyeng yeikki ono, purik yombanu ngoweiwili ngoweiweki yabelagi ono ma wata koru watabiyeng ni namokko korowali kelemiyagi ono. ");
INSERT INTO big_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tegi inugu paka ngalege Anotoyaga kanga wazono weiyagi piyengki kumulizo, purik inugu kumuli piyeng wilek kang inuguyeng mabiyeng tiya mani piyeng. ");
INSERT INTO big_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Wire nuguyau korik nuguwekki lambek. Wire piyaugu kazing nigi yoklongko wei mizi yo keya to mizagimek waligeleni. Kazing mabilikmekke wilek kang nugubokko kazing ni wiziyagimek waligeleniweki Yisugi wilangkarik nigi yungke wiriyi pani kelemi. Tamizeige wilek kang nugubek pangka purik kazing nugu yolu pumok pangka. ");
INSERT INTO big_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kapura tamizeige wilek kang nugubek kaile purik korik nuguwek mabuwek kusabanurikku kola logo kazing nugu yolumek kaile. Tegi tamizeige nugu kumularik nigi yungkerik wilangka yolu nobiyeng miza kapura nigi yungkerik kusabanu yolu purik nugu kumuliyeng kaile logo kusabanu purik yemane panu wizinda. ");
INSERT INTO big_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yombanu nakko yombanu ngai neyauyegi kemenak yawe mizagi langai ono. Kazing mabilikmekke ini Anotoyegi keli keya watabi king keya pulangai ngabelakpekkeyengkirau kemenak kelagi langai ono, purik ini nakyegi keli keya nakyegi kiyebuk mizagi legi. Keya ini nakki keliragi kiriwei keya nakki keliragi kezanga mani mizagi legi. ");
INSERT INTO big_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Piliktikki wiyeke nogo iniyegi pelik yei, ngeragi keya kai wik ini wik yoluweki nagi piyengki wilek ngelek kumuli nagani, ma kagorik korikwekke wakiyagi piyengki wilek ngelek kumuli nagani. Purik wilek kang inuguyeng pangka yolu pura ngeragi keremungke nagi puraga ngalege panu kani, keya korikwekke kagorik wik wakiyi piyengka ngalege panu kani. Tegi ngeragi inugu nagi piyengki weli keya kagorik inugu wakiyagi piyengki wilek ngelek kumuli nagani. ");
INSERT INTO big_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Winakwiligu yolu puragi pakeli. Winakwili yawe ngeriyi onowili, ma ngeragi wawiya logo i namakke ngeragiyeng kalike niweki wiyi onowili kani, kapura Anoto inigi Mango paka ngalege yolubokko ngoluk puwili ngeragi yani kani. Winak songonowiliyegi wiyeke Anotogo ngairik yemane kapura pugu iniyegi ngairik yemane panu. ");
INSERT INTO big_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Watabi pilik piyengki wilek ngelek kumuli pumokko ini puwiliyaga nakki ngabelak pobokko wik yolugi pura yokolong panu kelemiyagi ma yeik? A’a’, yeik. Mena wilek ngelek kumuli pumokko wik yolugi pura yokolong panu kelemiweki sawelagi langai ono legi ini watabi nayengkirau wilek ngelek kumula meli nagani, yeik Anotoyegi wilekyeng ngalege wiyi. ");
INSERT INTO big_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Keya ini korikwekke kagorik wakiyagiyengki wilek ngelek kumulira nangki? Purukpuruk Kailiyawamerekke kumuli. Pumorok yawe mizi onomerek ma ngezemerekki wakiyagiyeng keremizi onomerek. ");
INSERT INTO big_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kapura kerewiyi, Anotogo Kailiyawa purukpurukmerek palumu panu wakiyagiyeng mani. Koka walaka King Ngaibek Solomon meiyabek watabi keremungkeyeng kilimbek watabi palumu panu puguyeng wakiya kapura purukpuruk peyengko Solomongu watabi wakiya piyengki ngaira ula. ");
INSERT INTO big_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Anoto Kailiyawa songono mabek wokpekke yolu keya wangkowapekke ngoliyagi piyengki pi ngai yolu mizi legi pugu iniyegi mabilik waberek ngai wiziyagi kani logo pugu pilik mizagi kapura inugu purikki ngizi panu kumuli inugura songono panu. ");
INSERT INTO big_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Togo ngeragi nogoyeng talaga lewagi ma kairi nogobek talaga lewagi mizi ma kagorik nogoyeng talaga lewagi miza purikki wilek ngelek kumuli nagani. ");
INSERT INTO big_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yongkambanu Anotoyegi iwaka ono puwili kang mabiyeng watabi pilik piyengki wilek kang tiya maniwili. Anoto inigi Mango paka ngalege yolubek ini ngeragi keya kai wik yolugiyeng wei keya kagorik wakiyagiyeng weiyagi purik pugu iwaka mena wilek ngelek kumuli nagani. ");
INSERT INTO big_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kapura tamizeige were ini Anotoyegi wilek kang tiya mani keya inugu pi iniyegi ngai wizeibene kelemi keya pigi kazing pangka mizi pumokki wilek kang tiya mani mizi puwekke purik mabura pugu ini watabi ngoluk wik yolugi piyeng mabiyeng yanagi kani. ");
INSERT INTO big_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tegi watabi wangkowapekke mizagi piyengki wilek ngelek kumuli nagani. Wok wangkowapek watabi wangkowapekkeyengki keke kumulagibek. Watabi kuneng yokopekki piyeng kuneng yokopekkiyeng, wangkowapekkiyeng ono, Yisugu pilik yeiya. ");
INSERT INTO big_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Keya Yisugu puwiliyegi mawinda pelik yeiya, Namele keya nakyegi melebek yowi nagani, purik Anotogo niyegi melebek yowa nelegi. ");
INSERT INTO big_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Purik kazing nugu nazuwagawiliyegi meleyeng yowi mabilikmekke Anotogo niyegi melebek yowagi. Keya kazing nugu nazuwagawiliyegi pilik keleyi pumokki pangka Anotogo mabilik keleniyagi kani. ");
INSERT INTO big_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ni yombanu nakki wirebekke kulugulurik pakela mowiyi kapura ni makngezegi wirebekke wak yolu puleigi pakeli onora nangki? ");
INSERT INTO big_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ma ni wire ni makngezegibekke wakleigu talik pakelagi mizageya wizimowei ni nangki nakyegi pelik mei, Koli, nogo kulugulu wire nugubekke yolu purik wameliweki mena, mei? ");
INSERT INTO big_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ni yombanu kiligang neyau lewabek kani. Wak wire ni makngezegibekke yolu pulei were wamela logo ni wireyau pangka ngai panu wizimowei nakki kulugulu wirebekki purik wameli mangine. ");
INSERT INTO big_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nugu keri wizing ngai mizimekyegi ngeragi mani ma yeik? A’a’, purik nugu ngeragi mana logo pulaga keri pilikmok yoweza sa logo ni limitagi. Kazing mabilikmekke nugu yombanu ngago ngizi panuragi kumbakwiliyegi Anotogi ngago walekta yani nagani, purik puwiligu niyegi yeik ngago ngalik sanga kisi piyengko kanga nanagi. Nugu liyengwiligi ingewerege kingyeng wiyi ma yeik? A’a’, purik puwiligu kingyengki iwaka ono logo yeik momane mei kunagi. Kazing mabilikmekke nugu yombanu kangka kaile kumuli wilibek miziyeng kilingwiliyegi Anotogi ngago yemanera kozak yei nagani, purik puwiligu yeik ngago kaile sanga kisi piyengko kezanga nanagi. ");
INSERT INTO big_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tamizeige ni Anotoyegi waberek mizi puwekke purik mabura mawiyarekka mei purik Anotogo nanagi, keya ni piyegi welageya purik mabura ni piyegi yolok ngelagi, keya kang pugurikke ngago mei mizageya purik mabura pugu kerewiya logo koli neiyagi. ");
INSERT INTO big_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Purik Anotoyegi nguk mei mologabok watabi pugu nguk mei piyeng weik wei penanging keya piyegi weli mologabok purik piyegi weik yolok ngeli penanging, keya kang pugurikke ngago mei mizi mologabok purik Anotogo kerewiya logo weik koli mei penanging. ");
INSERT INTO big_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tamizeige ini mandikki mangowiliyaga nakki marekpokko niyegi kambek nazik niweki nguk nei puwekke purik nugu nigi marekpek kimbek niweki managi ma yeik? ");
INSERT INTO big_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma pugu niyegi kobulemek niweki nguk nei puwekke purik nugu nigi marekpek kemale Kuluwekmek niweki managi ma yeik? A’a’, yeik. ");
INSERT INTO big_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ini yombanuwili kaile miziwili kele kapura inugu inigi marekngangwili ngeragi keya watabi wazono piyengka yani miziwili. Mena, Anoto inigi Mango paka ngalege kaile nayendau mizi onobok ini piyegi nguk mei puwili watabi kolokngagono wazono piyeng yanagi ma yeik? ");
INSERT INTO big_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Togo kazing yongkambanuwiligu iniyegi keleyibene inugu keli pumokko inugu mabilik puwiliyegi keleyizo. Pilik pura Anotogi lo Mosego lende miza piyeng keya ngago yombanu Anotoyaga weiya logo kozak kisiwiligu waligeleyayengki solorik. ");
INSERT INTO big_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Keya kazing neyaugirik kazing panga ibeng wizagomagiragimekki kang kiliyarikki kandik unatuba panu, keya yereng puragi kazingmek kimeike yolurikki wiyeke yongkambanu kolokngagonowili puluweng yolok ngeli logo yeke ige kang. ");
INSERT INTO big_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kapura kazing panga wik wizagomagiragimekki kang kiliyarikki kandik koru panu keya yereng puragi kazingmekke kangkirik yawe unatubarikki wiyeke yongkambanu ngelek onowili puluweng yolok ngeli logo yeke ige kang. Togo nogo ngago pera iniyegi kozang yei, Ini wik wizagomagiraga kang koru panurik neing kiliya lizo. ");
INSERT INTO big_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Keya yombanuwili kanda ngaigu pelik kisagi, Anotogo teni wezayela logo tonugu ngago pugura iniyegi kozak yeiweki kisagi. Puwiligi korikyengki yeke ngalegerik liyeng sipsip ini ngangang yanagi langai ono puwili kelik kapura nogo puwiliyegi yeirik keri wizing ngai miziwili yei, purik yenge wilek kang puwiligiyeng kazing king wei keya kozanda weiyagi pumokki kerezi mizi keya kaile mizi piyengko wilak panu kani waberek panu. Puwiligu kisi piyengki ngizi kumuli nagani. Ngai panu koyizo. ");
INSERT INTO big_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Keya inugu pewiliyegi iwaka sagirik kazing puwiligu miziyeng keya watabi puwiligu kisi piyengka inugu iwaka sagi. Yengeleiyengki kumuli. Yengeleileigi wilekyengko yengeleilei ngenangailei mizi, purik teni yongkambanuwili were yengelei wilekyengki pakeli, wazonolei ma kailelei miza legi. Teni ngoyei wilekyeng mabung ingakmerekka tiyi ono kani ma kopi wilekyeng ingakmerekka tiyi ono kani. ");
INSERT INTO big_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mabilik yengelei wazonoleigu wilek wazonoyeng keke wiragi, kapura yengelei kaileleigu wilek korowaliyeng keke wiragi. ");
INSERT INTO big_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mabilik yengelei wazonoleigu wilek korowaliyeng wiragi ono, ma yengelei kaileleigu wilek wazonoyeng wiragi ono. ");
INSERT INTO big_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yombanu nakko pakeliraige yengelei nalei yengelei wilek wazonoyeng wira meli ono puwekke purik pi yenge sologe winilekko kira logo panga yezizikke waliya wazamiyagi. ");
INSERT INTO big_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yongkambanuwili yengeleiyeng kelik. Keya watabi puwiligu mizi keya kisi piyeng yengelei wilekyeng kelik. Pilik legi yombanuwiligu ngaigu kisi keya ngizi kisi piyengko puwili Anotoyaga lewawili purik ngaigu ma ngizi purikki inugu iwaka sagi. ");
INSERT INTO big_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yongkambanu neyegi, Yemizibek, Yemizibek, kisi kambeli puwili mabuwili Anotogi ngaimekki pugu ngai yolu puragi kiliyagiwili ono. Pilik kisi puwiliyaga negi Mango paka ngalege yolubekki kelira mizi puwili keke ngai pugumekke kiliyagiwili. ");
INSERT INTO big_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Keya wok kalike Anotogo yongkambanuwili ngagozak keleyagibokko kolokngagonowiligu neyegi pelik kisagi, Yemizibek. Yemizibek, yeik nugurage tonugu ulogo Anotogi ngagora kozak kisa, keya yeik nugurage tonugu ulogo yongkambanuwiligi yenge yungkeyengka kerewa kolokngagonowili welagela wezayela, keya yeik nuguraga Anotogo keke miziyeng tonugu kolokngagono miza mela kani legi teni kiliya liweki, kisagi. ");
INSERT INTO big_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kapura puwekkerik nogo puwiliyegi pelik yeiya to melagi, Ulogorik keya mabek periktau ini nogowiliyaga nak ono purik ne iwaka. Ini kaile kaile miziwili mena neyaga kazi kuni, yeiyagi. ");
INSERT INTO big_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ne kazing saweliwei pemek yombanu ngago nogoyengki kerewiyi keya ngago piyengko miziweki kai piyeng mizi pumologabok talik melegabek miza purikki kozak yeiweki. Yombanu pumologabok yombu i namak ngiziweki mizibok kelik. Pi i pugumak paka ngabelak kingyeng kilimbekke ngalege ngiza. ");
INSERT INTO big_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pilik ngiza logo kobo unatuba panuyau kula wiziga kailing kai ngai unatuba kaiyageyarik kebarek kozambokko imak ula yo keya to kelemiya logo i pumak topela melagi nobiyeng kelemiya kapura imaktau urukang mizi ono, purik imak kingyengki ngalege ngiza kopong kozang wiziya. Yombu yakabok kangkabek kilimbek. ");
INSERT INTO big_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kapura yombanu ngago nogoragi kerewiya kapura purago miziweki kai piyengki kiriwei miza ono pumologabokyegirik pelik, pi i pugumak paka ngabelak kingyeng kilimbekke ngiza ono, pi kaingimbekke yeik ngiza. ");
INSERT INTO big_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pulaga kobo unatuba panuyau kula wiziga kailing kai ngai unatuba kaiyageyarik kebarek kozambokko imak ula yo keya to kelemiya logo i pumak urukang kelemiya logo nguk namizi kawiye wala logo kemenak neneng ngela mela. Yombu pok kangkabek kiling onobek. Kapura ini yombu kangkabek kilimbokko miza pilik mizizo logo ngago nogoyeng mabiyengki kiriwei mizi mizi purik ini kawiye wala logo neneng ngela melagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yisugu ngagora weik yeik sawiya wiziga yongkambanu piyegi kerewiyawiligu pugu waligeleyiyengki lelengkira. ");
INSERT INTO big_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Purik pi Yudawiligi lo piyengki waligeleyiwiligu waligeleyilik keleyi ono, segeya ngago pugura kozang yemanera kiling kozak kai logo pi ngai yemane yeikta kiling nakko kozak kailik kai. ");
INSERT INTO big_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pulaga Yisu paka lewakpekka yerageya logo yongkambanu kolokngagonowili piyegi kalika kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Keya yombu kemegeme Leposimek meimek kiling nak Yisuyegi weik lewa. Kemegeme Leposimek mei pumok korikwek sok mizimek keya korikwekke wizing lewa meli mizimek logo yongkambanuwiligu wizing piyeng kuming kelemiya purik puwilirau kemegeme leposi pumokka yela managi, legi yongkambanuwiligu kulili panu mizimek logo puwili nak leposimek kiling purik pilikpok kezanga mani mizimek. Logo yombanu pilikmek kilimbek Yisuyegi kayima logo Yisugi yeikta yongolok meiweki pi Yisugi ingewerege panga ngabelakke ingeyau laliya logo pelik nguk meiya, Yemizibek, tamizeige nugu keli mabura nugu ne yombiyangai wazaniye logo yongkambanuwiligu neyegi kezanga nanagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Logo Yisu melezik tungkula logo pi kebangkela logo Yisugu pelik meiya to mela, Nogo mizagi keli. Ni yombiyangai se, meiya. Nguk namizi mabuwekke yombanubek weik yombiyangai sa. ");
INSERT INTO big_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pulaga Yisugu piyegi pelik meiya, Nugu niyegi keleniya peragi namele keya nakyegi kozak mei nagani, kapura tenigi lo Mosego kaiya puragi kiriwei mizimo. Ni Anotogi i walek yemanemakki yombu Anotoyegi kolak mizibokko ni yombiyangai sa wazaniyarikki pakelibene kune keya pulaga nugu pi wata namek Anotoyegi kolak mizagirikki wiyeke mana logo pugu ula logo waliya logo ni weik yombiyangai wazaniya puragi yongkambanuwiligu iwakagi, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yisu panga yereng Kapaneyam meirage kambela. Pi yerengke kiliya lawekke Rom Amiwiligi ngai nak Yisuyegi wiriya logo piyegi saweliweki pelik kelegele meiya, ");
INSERT INTO big_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Yemizibek, yombu neyegi yawe mizibek panga ige kemegeme yemane mizageya. Inge keya mele puguyeng mabiyeng ibeng logo pi yongomo mizagi langai ono keya pi ngangang yemane panu mizi, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Pilik kai legi Yisugu piyegi pelik meiya to mela, Nogo pi yombiyangai wazamiweki kangweki, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pulaga Rom Amiwiligi ngaibokko Yisuyegi pelik meiya, Ne pangkabek ono logo ni i nogomakke wiriyagi purik pangka ono. Kapura mabelaga wizimowei yeik ngagorago kai logo kemegeme neyegi yawe mizibekyegi pumok yeik sibene. ");
INSERT INTO big_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Purik nerau ngai yemizibekyegi kulengke yolu logo ne watabi pugu kai piyeng mizi mizibek keya ami nawili neyegi kulengke yoluwili. Logo nogo nakyegi, Kune, mei purik pi kang. Keya nogo pangabokyegi, Ni koli, mei purik pi lewa. Keya nogo neyegi yawe mizibekyegi, Pera mize, mei purik pi mizi. Kazing mabilikmekke ngago nugura kozanda kiling logo nugu yeik ngago yeiktago kai purik yombanu neyegi yawe mizibek yombiyangai kelemiyagi, legi yeik ngago yeiktago kai, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yisu ngago puragi kerewiya logo lelengkira logo yongkambanu piyegi kalika kiriwei wiriya puwiliyegi pelik yeiya, Kerewiyi. Yombu Yuda ono pobokko neyegi kozang ngizi panu kumuli kapura yongkambanu nalagawiliyaga nak ma Isileili mabuwiliyaga nakkorau neyegi pilik ngizi panu kumuli ono, yeik. ");
INSERT INTO big_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ini kerewiya koyizo. Kalike yongkambanu Yuda ono kolokngagonowili pobokko neyegi ngizi panu kumuli pilik kumuliwili ngabelak panga yokmek lewagelayeng mabiyeng keya ngabelak panga yokmek kiliyayeng mabiyengkarau lewagi logo yereng Anotogo pigi ngaimekki ngai purage kiliya lagi logo inigi yelibungang kokawili Abalam keya Isak keya Yakop kiling mogosa logo ngeragi yemane miza ni nangai. ");
INSERT INTO big_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kapura Anotogo ini Yudawili yereng puragi kangkirikki kangkere miza yowiya kele kapura ini kolokngagono puwiligu neyegi ngizi panu kumuli onorikki wiyeke ini yenge yerengke kusabanurikke wezayelagi logo pulogo kusabanurikke ini ingkeya kelele yemane panu kisi keya kili inuguyeng ngiliti mizagiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yisugu puwiliyegi pilik yeiya logo pugu Rom Amiwiligi ngaibekyegi pelik meiya, Panga ige kambele. Nugu ngizi panu kumuli purikku nogo nugu kai pura miza nowiyagi mena, meiya. Logo mabuwekke Rom Amiwiligi ngaibekyegi yawe mizibek ngereke yombiyangai sa. ");
INSERT INTO big_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Togo Yisu Pitagi imakke yeke ige lawekke pulogo Pitagi yongokpumelegi panumele kemegeme korikwek yezingei panu mizimekka mizi logo lalektage iwek wizilege Yisugu pakela. ");
INSERT INTO big_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tegi Yisu piyegi kanda mele puguzik kebangkela logo kemegeme korikwek yezingeimek piyaga yeik. Pi yangalek meiya logo Yisugi ngeragiyeng miza mowiya. ");
INSERT INTO big_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pilik miza logo ibengke yokmek kiliyawekke yongkambanu kolokngagonowili puwiligi ingembungang kemegeme kerewawili yenge yongkambanuwiligi yungke ngaiweki kiliya yolu puwili Yisuyegi iza orowei wiriya logo Yisugu ngago landikku kerewawili welagela wezayela. Keya nawilirau kemegeme nalangaimokko mizi mizi puwili mabuwili yombiyangai wazaya. ");
INSERT INTO big_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Togo pilik miza pura koka walaka yombu Anotoyaga ngagora weiya logo kozak kaibek Isaya meibokko kaiya pura weik ngizi lewagela, Pi ngezebokko kemegeme tonuguyeng weiya yowiya. Keya ngangang tonuguyeng ngezebokko wagela yowiya. Koka walaka Isayago pilik lende miza kapura Yisugu kemegeme yongkambanuwili yombiyangai wazaya puwekke ngago pura weik ngizi lewagela. ");
INSERT INTO big_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Keya Yisugu yongkambanu kolokngagono pi yawereng kelemirikki pakelawekke pugu yombu ngezebokko waligeleyiwiliyegi pelik yeiya, Kai kolamiyabek wala uwei lalu pangazuwagawekke kangweki, yeiya. ");
INSERT INTO big_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mabuwekke yombu Mosegi loyengki waligeleyi nak Yisuyegi kanda pelik meiya, Kiriwagabek, nugu kang wale kang piyeng mabiyengke nerau niyegi sawela logo kiriwei kangkibek kani, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yisugu piyegi pelik meiya to mela, Watawili yengelei mele inguriya piyengki yungke iwekwili keya winak porora wei mizi puwili iyeng ngiza logo iwekwili, kapura ne yombanu paka ngalega kayimabek yolumek yareksa logo kumanagi nariktau onobek logo tamizeige ni ne kiling kangki purik towa mabiyaugi yolugi nariktau ono. Tegi ni were waberek kumula logo neyegi saweliweki kaiyagirikki kai, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pulaga yombanu Yisugi ngago piyengki kerewiyawiliyaga nakko Yisuyegi pelik meiya, Ne niyegi sawelagi keli kapura ne were negi mangobekyegi ngai yolu wizigeya pi ibeng logo waliyi keya miza logo purik ne niyegi sawelagi, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kapura Yisugu pelik meiya to mela, A’a’, yombanu ngago nogoragi kerewiyi ono puwili ibeng wezawiligu, puwiligu yombanu ibengkiwili waliyi nangai. Kapura ni kele neyegi saweli koli, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pulaga Yisu wangleige tameneng meiya. Keya pugu waligeleyiwilirau pi kiling kuna. ");
INSERT INTO big_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Puwili tagoneige nguk namizi kebarek unatubabek kaibekke uli yongomo mizi logo wanglei kaibokko kolamiweki mizi kapura Yisu iwek kola wiziya. ");
INSERT INTO big_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yisugu waligeleyiwiligu pi waliya kelemiya logo piyegi pelik meiya, Yemizibek, teni kaiyaga niweki mizi mena teni yaliya wazaye, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tegi Yisugu puwiliyegi pelik yeiya to mela, Ini wilek ngelek kumulira nangki? Nogo iniyegi ngaigi langai purikki ngizi panu kumuli inugura songono panu, yeiya. Pulaga Yisu yangalek meiya logo kebarekpek keya kaibektau ngalik yeiya logo kebarekpek weik yeik sawiya keya kaibektau weik yelakkelek wiziya. ");
INSERT INTO big_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Pilik mizawekke puwili lelengkirara koya keya nakko nakyegi pelik meiya, Yombanubek talikpek logo kebarekpek keya kaibektau pugu kairagi kerewiya logo kiriwei mizi, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pilik miza logo wangleige ngalengale kuna logo waleleige puwili Kai Kalili lalu pangazuwagawekke ngabelak Kegesa meibekke kanda wila wiya. Yisu wangleiga yangalekta panga kaingimbekke luwezara tawizeige pura pi yombanu kerewawiligu kebangkela yolu logo mosindaga yolu neyau yoromaure miza. Piyau kozang panu keya wizing panu logo yongkambanuwili kazing piyaugu yolu puluweng neing kunagi langai ono. ");
INSERT INTO big_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nguk namizi kerewa puwiligu kemenak ngalizi pelik kek kisa, Yisu Anotogi Marekpek, nugu teniyegi nangaiyeng keleyiweki mizi? Wok ngangang pilik yanagibek ngoluk kapura nugu pelege lewa purik teni were ngangang yaniweki ma talik, kisa. ");
INSERT INTO big_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Panga koweige liyeng kabe kolokngagono namek ngeragi ni yo keya to mizageya koyilege. ");
INSERT INTO big_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kerewawiligu Yisuyegi pelik kelegele meiya, Tamizeige nugu yombuyauyaga teni welagela wezayeli purik mabura teni liyeng kabe panga pumokyegi kiliya wezayele, meiya. ");
INSERT INTO big_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tegi Yisugu puwiliyegi pelik yeiya, Ini welagela kuni, yeiya. Pulaga kerewawili yombuyauyaga welagela panga liyengwiliyegi kiliya yabela. Nguk namizi liyeng kabe pumok mamok lewakpekka nginda kanda wilekwekka yenge kaibekke kiliya logo kaiyaga na. ");
INSERT INTO big_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yombu liyengwiliyegi yaka ngai koyimawili yaka miza puragi pakela logo kazi yereng yemanerage kambela. Pulogo puwiligu yaka liyengwiligu miza puragi kozak yeiya, keya yombu kerewawiligu kebangkela wiziya piyauyegi keleya puragi kozak yei miza. ");
INSERT INTO big_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nguk namizi yongkambanu yereng puragemek mamok Yisu yoromaure miziweki kambela. Kanda puwiligu pakela logo puwili kulilimokko kolarikki wiyeke puwiligu Yisu nalege kangweki kelegele meiya. ");
INSERT INTO big_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pulaga Yisu ngereke wangleige tameneng meiya logo kai kolamiyabekke pezuwage wala uwei yo. Pi yereng ngezebekkirage kang yongobela. ");
INSERT INTO big_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kanda pulogo nguk namizi yombanu nawili Yisuyegi yombu inge keya mele ibeng nak yolumek puguyeng kiling lalektikke ngalege wageliwei wiriya. Puwili Yisugu pi yombiyangai wazamiyagi langai purikki piyegi ngizi kumulirikki pugu pakela logo yombu inge keya meleyau ibembekyegi pelik meiya, Aik, kazi mizi wak, kozang wizimo purik nogo kaile nuguyeng weik tumula logo keremareke wezameli kani, meiya. ");
INSERT INTO big_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yisu pilik kai legi yombanu Mosegi loyengki waligeleyi pulogo mogosa koya puwili ngezewili pelik kumula, Yombanu pobok pilik kaiyagi onobek, purik pugu kai purik pi Anoto kiling pangka pangka kai yagenda legi, miza. ");
INSERT INTO big_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Keya Yisu puwiligu liwik kumula piyengki iwaka wiziga pelik yeiya, Inuwa ya inuguyengke kaile pera kumulira nangki? ");
INSERT INTO big_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yawe nangaira yemane onora, kaileyeng tumula logo wezamelagira ma yombu inge keya meleyau ibeng nak yombiyangai wazamiyagi pura? Tamizeige ne yaka inge keya meleyau ibembekyegi pelik mei, Nogo kaile nuguyeng tumula logo wezamela, mei purik ini pi wameik kai ma ngaigu kai kisagi, kapura tamizeige ne yombu inge keya meleyau ibembekyegi pelik mei, Yangalek meiya logo kune, mei purik ini ne wameikpek ma ngaigubek miza legi iwakaweki. ");
INSERT INTO big_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ne yombanu paka ngalega kayimabek logo yongkambanu ngabelakpekkewiligi kaileyeng tumuliweki pangkara kilimbek logo ini purikki iwakaweki nogo yaka yombu inge keya meleyau ibembekyegi pelik mei yagenda, Ni yangalek meiya logo yolumek nuguyeng weiya logo i nugumakke kambele, mei yagenda. ");
INSERT INTO big_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mabuwekke yombanubek luweza logo panga i ngezebekkimakke kuna. ");
INSERT INTO big_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Keya yongkambanu kolokngagonowiligu pilik miza puragi pakela logo kazi mizageya koyimowei Anotogi yeikta yongolok meiya, purik pugu weik yombanuwiliyegi kozang pilikyeng miziwekira yana kopong. ");
INSERT INTO big_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yisu pulumeng wiya logo pi ngabelak libu kang kunimowei tapakeleige yombu king takis weibek, yeikta Matiyu meibek, opis pugumakke mogosa wizilege Yisugu piyegi pelik meiya, Ni ne kiling saweliweki kiriwei koli, meiya. Logo Matiyu yangalek meiya logo Yisu kiling saweliweki kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kalike wok nakke Yisu kiling pugu waligeleyiwili panga Matiyugi imakke ngeragi nageya tagogei yombanu kolokngagono king takis wei piyengka nayeng ngowei miziwili keya yombanu kaile mizi nawilirau kanda logo puwili kiling mogosa logo ngeragi na. ");
INSERT INTO big_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Yombanu Palisiwili meiwiliyaga nawili Yisu kiling puwili ngeragi nirikki pakela logo puwili sisik sara koyimowei kalike Yisugi yombu ngezebokko waligeleyi puwiliyegi pelik nguk yeiya, Inuwagi yemanebek yombu yaka king takis wei piyengka nayeng ngowei miziwili keya yombanu kaile mizi nawili kiling ngeragi ni mizira nangki? Pi pilik mizi purik pangka ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yisugu puragi kerewiya logo pelik yeiya to mela, Yongkambanu wazonowili totayegi kang ono, kemegemewili keke totayegi pakeli kangwili. ");
INSERT INTO big_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Anotogi Kapiya Walek Osiyago lende mizarikki sangkela logo ngago peragi solorikki iwakaweki kambelizo, Inugu neyegi watawili kolak kelibene waliya nani puwekke purik ne wilik kapura inugu yongkambanuwiliyegi yalek miza logo wazono mizi puwekke purik ne wilik panu. Togo inugu purikka iwaka siweki ne kayimarik ne yongkambanu ngezewiligu ngezewiliyegi pangkawili mizi puwiliyegi kayima ono, ne yombanu kaile mizi puwiliyegi kayima logo puwiligi kazing kaile miziyengka kowitibene yeiweki kayimabek, yeiya. ");
INSERT INTO big_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kang narage Yowan kaimelibekyegi kiriweiwili Yisuyegi kayima logo pelik nguk meiya, Teni kazing wilek kang mabiyeng Anotoyegi waberek mizagirikki tiya maniweki ngeragi ni ono mizimek mizi keya yombanu Palisiwili meiwiliyegi kiriwei puwilirau mabilik mizi kapura yombu ni makngezego waligeleyiwili kazing pumok mizi onora nangki? ");
INSERT INTO big_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Pilik meiya logo Yisugu pelik yeiya to mela, Yek tek nangezi yombanu yongok weiweki mizi nakyegi langai kumuli. Yongkambu weiwekkerik yombu yongok weiyagibokko ingenazewili ngeragi miza yaniweki miza logo yani. Puwili wilik kagowindikku mizagewiyege pi kiling mogosa logo ni. Kazing mabilikmekke neyegi kiriweiwili ne kiling koyimowei menalege ngeragi ni kapura kalike yombanu neyegi kumbak mizi puwiligu neyegi kiriweiwiliyaga niza orowei puwekke puwili ya kunengmokko mizagewiyege kazing wilek kang mabiyeng Anotoyegi waberek mizagirikki tiya maniweki ngeragi ni ono mizimek mizagi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Keya kazing yombanu Palisiwili meiwiligi weremek keya Yisugi kazing wikmek sawela nelegi puwili waligeleyiweki Yisugu ngago saweliwei pera puwiliyegi kozak yeiya, Nakko melewangka wik narikka walerik ngela logo paka melewangka were koliyarikke lolo ulagi ono. Tamizeige pi pilik mizi purik melewangka wiktik kaile mizagi keya melewangka wererik ngoluk sobok wiziyagi. ");
INSERT INTO big_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Keya yombanuwiligu kai waing wikpek keremiziwekkerik were puwili kik wata korik wikyeng keremizi logo kai waing wikpek kubuli. Puwili kai waing wikpek panga kik wata korik wereyengke kubulagi ono. Puwili pilik miza purik kai waing wikpek sibesibe wari lewawekke wata korik wereyeng potora logo waimbek panga ngabelakke kubula welagi keya kik wata korikyeng yeikki. Piliktikki wiyeke kai waing wikpek panga kik wata korik wikyengke kubuliweki. Kazing mabilikmekke negi kazing wikmok kazing weremekke sawelagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisu ngoluk puwiliyegi yaka pura kozak yeiyageya tawizeige pura Yudawiligi i walek songonomakki ngai nak Yisuyegi kanda pigi ingewerege pulogo yeik pugura yongolok meiweki ingeyau laliya logo pelik meiya, Kolomandik negi yangomele mabek ngolukku ibeng. Kapura nugu mele nuguzik pigi ngalege walamiweki koli, purik pi ngereke wik yolugi, meiya. ");
INSERT INTO big_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tegi Yisu yangalekta piyegi kiriwei kuna keya pugu waligeleyiwilirau piyau kiling kuna. ");
INSERT INTO big_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yisu yagoneigeya yongok namele wok iwi walayeng weik yeik ono, kirisimasi meleyau keya pongo ingenazikka neyau piyeng iwi walageya wizagomimele wiriya logo Yisuyegi kalika kiriwei kuna logo kagorik pugu yeke ngalege wakiyarikki pongo walemekka kuming kelemiya. ");
INSERT INTO big_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ngezemologo kumularaga pelik kaiya, Ne korik puguwek ma kagorik yeke ngalege wakiya puriktau mele nogozikku kuming kelemiya mabura ne yombiyangai wiziyagi, miza. Tegi yongokmolo kagorik yeke ngalegerikki pongo walemek kuming kelemiya. ");
INSERT INTO big_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yisu kowita to mela logo piyegi pakela logo pugu piyegi pelik meiya, Yongokpanumele, kazi mizi wak, kozang wizimo, nugu neyegi ngizi panu kumulirikku ni weik yombiyangai wazaniya mena, meiya. Nguk namizi mabuwekke yongokmele yombiyangai sa. ");
INSERT INTO big_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pulaga Yisu yeke Yudawiligi i walek songonomakki ngaibekki imakke lewagela logo pugu yongkambanu pulogo yeke ige kolomandikmeleyegi wiyeke kolanduwewek uli keya ingkeya ngabik yemane miziwiliyegi pakelawekke ");
INSERT INTO big_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","pugu pelik yeiya, Ini mabuwili yenge yerengke welagela kuli. Kolomandikmele ibeng ono, pi yeik ngoluk iwek kola wizinda, yeiya. Kapura puwiligu piyegi ngizi panu kumula ono kopong puwili Yisuyegi songomeiya mena. ");
INSERT INTO big_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Togo yongkambanuwili yenge yerengke welagela wezayela logo pulaga Yisu yeke ige kolomandikmele wazamiyamakke la logo pugu kolomandikmelegi melezikka weiya logo kolomandikmele yangalek kelemiya. ");
INSERT INTO big_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pilik miza logo ngago yawe kozang mabek miza puragira ngabelakpokko ululu miza mela. ");
INSERT INTO big_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pulaga Yisu yereng pura wiya logo pi yagoneiga yombu wireyau kusa neyau piyegi kalika kiriwei kuna. Piyaugu pelik ngalizi kek meiya, Yisu, ni tenigi yelibu koka ngai yemane Tawiti meiyabokki marekngangwiliyagabek logo Anotogo teni Yudawiliyegi wiyeke wezanelabok purik togo iwaka legi teyegi yalek mize, mei keya mizi kai kang kuna. ");
INSERT INTO big_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Togo Yisu i namakke yeke ige kiliya lawekke yombu wireyau kusa piyaurau yeke ige kiliya la. Piyegi kanda logo Yisugu piyauyegi pelik nguk yeiya, Yaligu nogo yali yombiyangai wazayagi langai purikki neyegi ngizi kumuli ma yeik, yeiya. Piyaugu Yisuyegi pelik meiya to mela, Ei, Yemizibek, nugu pilik mizagi langai purikki togo ngizi kumuli, meiya. ");
INSERT INTO big_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Togo Yisugu wire piyaugiyau kuming kelemiya logo pelik yeiya, Yaligu neyegi ngizi panu kumuli legi yaliyegi pilik lewageliweki, yeiya. ");
INSERT INTO big_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mabuwekke wire piyaugiyau weik ngaiwila. Pulaga Yisugu piyauyegi kozang pelik yeiya, Yaligu peragi namele keya nakyegi kozak mei nagani, yeiya. ");
INSERT INTO big_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kapura yombanu yaka piyau pulumeng wiyawekke piyau ngagoluk kambela ono, yongkambanuwiliyegi ngago Yisugu yombiyangai wazaya pura kozak yei yongomo miza logo Yisugi yeikta ngabelakpokko ululu miza mela. ");
INSERT INTO big_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Keya yombanu yaka piyau Yisu wezamiya logo yombanu nawiligu yombu nak kerewabokko yenge yungke kiliya logo kilira waliya mowiya kopong ngago kaiyagi langai ono, ngagoluk yolu nak Yisuyegi miza orowei kayima. ");
INSERT INTO big_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yisugu kerewabek yombanubekyaga welagela wezamela mabuwekke yombanubektau weik ngago kai. Yongkambanu wawere ulamek mamok pakela logo lelengkira logo nawiligu pelik kisa, Tonugu yawe kozang pilik nararau ngabelak tenigibek mabokko ulogorau pakela ono, kisa. ");
INSERT INTO big_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kapura puwiliyaga yombanu Palisiwili mei puwiligu pelik kisa, Talik miza logo Yisu kerewawili welagela wezayeli? Takko pi kozanda mana? Kerewawiligi yemanebek, Sadang, pugu Yisu kerewawili welagela wezayeliweki kozanda mani kani, kisa. ");
INSERT INTO big_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Togo Yisu yereng songono keya yemaneyengke pakeliwei yongomo mizi kai kambela. Keya pi puwiligi i walek songonoyengke yeke ige la logo pugu yongkambanuwiliyegi Anotogi ngagora waligeleyi keya ngago wazono Anotogo pigi ngaimekki ngai yolu puragi kiliyagira yani miza. Keya pugu yongkambanu kolokngagono kemegeme nak nalangaimek keya ngangangyeng kilingwili miza puwili mabuwili yombiyangai wazayi mizi kai kambela. ");
INSERT INTO big_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yisugu yongkambanu kolokngagono panuwiliyegi pakelawekkerik pi yalek panu miza. Puwili kuneng kolokngagonoyengko kola kapura sawelagi naktau ono purikki pugu pakela logo pelik kumula, puwili liyeng memeng puwiliyegi ngaigi naktau onowili kelik, purik liyeng memeng pilik puwili yeik wazewaze wei mizi logo koweige kelemi kanda suwei mizi. Logo yongkambanu kolokngagono pewilirau mabilik. ");
INSERT INTO big_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pilik kumula logo pugu waligeleyiwiliyegi pelik yeiya, Watabi kolokngagono weik yaweyengke kuk wizinda kapura watabi piyeng menalege wawiyagiwili keremungke ono. ");
INSERT INTO big_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tegi ini yaweleigi mangobekyegi waberek mizizo logo pugu yawe puguleige ngeragi kuk piyeng menalege wawiyagi nawilirau wezayelibene nguk meizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pulaga wok nakke Yisugu ngezebokko waligeleyi meleyau keya pongo inge nazikka neyau puwili piyegi wiriyiweki yeiya. Logo puwili weik kanda logo pugu puwili kerewawili yongkambanuwiliyaga wezayeli, keya yongkambanu kemegeme nak nalangaimek keya ngangangyeng kilingwili yombiyangai wazayiweki pangkara keya kozang pugura yana logo yawe pugura mizi kambelibene. ");
INSERT INTO big_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yombanu meleyau keya pongo ingenazikka neyau puwili Aposolowili meiwili, puwiligi yeikyeng peyeng, werebek Simong yeik nara Pita meibok, keya pigi sakpek Enduru, keya neyau Jems keya pigi sakpek Yowan Sebetigi marekyau. ");
INSERT INTO big_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Keya Pilip keya Patolomiyu, keya Tomasi keya Matiyu ulogo king takis weiyabek, keya Alapiyagi marekpek Jems, keya Tariyasi. ");
INSERT INTO big_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Keya Saimon yombu Selete Yudawili Romwiliyaga yaliya wazayiweki liwik yawe miziwiliyaga nak logo puwiligu pi Saimon Seletebek meibek, keya nak Yuras Isaliyoto, yombu kalike Yisu ulagiwiliyegi miza yanagibek. ");
INSERT INTO big_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisugu meleyau keya pongo ingenazikka neyau puwili ngago kiriwei mizagi peyeng kiling kang wezayela, Yawe nogora mizageya koyimowei ini Yuda onowiligi ngabelakpekke kang nagani, keya yongkambanu ngabelak Sameriya meibekke yoluwiliyegirau kang nagani. ");
INSERT INTO big_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Purik segeya yongkambanu Yudawiliyegi kunizo, purik puwili liyeng memeng ngai puwiligibek wezamiya logo piyaga koweige koyimi puwili kelikwili, legi puwiliyegi kambelizo. ");
INSERT INTO big_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Puwiliyegi kanda pelik kozak yeizo, Mabek wokpekke Anotogo weik pigi ngaimekki ngai yolu legi kiliyiweki koli logo Anotogo iniyegi ngaiweki kelemi, yeizo. ");
INSERT INTO big_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Keya inugu pura kozak yeiyageya koyimowei kemegemewili yombiyangai wazayizo, keya yombanu kemegeme Leposimek meimek kiling puwilirau yombiyangai wazayizo, keya ibengwili yangalekta wik wazayizo, keya kerewa yongkambanuwiliyegi ngai yolu puwili welagela wezayeli mizizo. Ini kozang piyeng mizagira yeik weiya legi mabilik peyeng yeik mizizo. ");
INSERT INTO big_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Watabi orowei kelemi kangki nayeng wari nagani, keya king ma koli ma siliba nayeng ");
INSERT INTO big_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","kik kalokyengke wari nagani. Ma kagorik yeke ngalege wakiyagi nariktau kikkikke wawela logo wari nagani, ma ingegangyau ma lukunglei wari nagani, yeik inugu wakiyagi mabiyeng kiling kambelizo. Purik yombu yawe mizibek yawe pugu miziragi wiyeke ngeragi keya pulangaiyeng mani purik pangka. ");
INSERT INTO big_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ini yereng yemane narage ma songono narage kiliya la logowekke yombanu pangkawiligu koli keleya logo ini iza orowei i puwiligiyengke yolu puwekke purik mabura i mabumakke koyi kanda kangki puwekke yereng pura wiya logo kang mizizo. ");
INSERT INTO big_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Keya ini i namakke yeke ige kang puwekke purik mabura were yongkambanu i pumakke yoluwiliyegi pelik yeizo, Wilek kang inuwagiyeng ngezege sara koyimiweki, yeiya logo Anotogi ngago wazonora yanizo. ");
INSERT INTO big_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tamizeige yombu wilek kang ngezege saragi kelibek i pumakke wizilege purik wilek kang pugubek ngezege sara weiyagi. Kapura tamizeige pilik naktau ono purik mabura ngago ngezege saragi pura ngereke ni makngezeyegi yogi. ");
INSERT INTO big_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tamizeige ini yereng narage lewa logo pulogowili iniyegi koli keleyi ono keya ngago wazono puragi kerewiya logo wilek kang puwiligiyengko wei ono puwekke purik mabura yereng pura wiya wazamizo logo puwiliyaga mele inuguyeng kaigesizo logo puwili Anotogo puwiliyegi wilik ono keya inugu ngereke yereng purage puwiliyegi ngago wazonora kozak yeiweki yogi ono purikki puwili iwaka si nangai kani. ");
INSERT INTO big_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kerewiyi, nogo iniyegi ngizi panu kozak yei, Wok kalike Anotogo ngagozak mizagibekke purik yongkambanu yereng Sorong meiraga keya Komola meiraga koka walaka kaile unatuba miza puwili ngangang weiyagi kapura yongkambanu yereng puraga iniyegi koli keleya ono puwili keya ngago inuguragi kerewiya logo wei ono puwili wokpokko ngangang yemane panu weiyagi. ");
INSERT INTO big_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Togo ini nogo wezayeliwili mena kambelizo. Keya kerewiyi. Nogo ini koloyakamandik songonowili kelik yombanu kaile iniyegi ngangang keleyi keya kuneng yanagiwiliyegi wezayeli purik nogo iwaka wizinda, legi ini kazing kemalewiligu mizi pilikmekke mizizo, purik pilik watabi inugu mizagiyengki waberek panu kumulizo. Keya kazing winak Kuwemimiwiligi pilikmekke mizizo, purik pilik yongomo mizi kunimowei nak kilindau ngai keli nagani, mabuwili kiling kuzige sara koyizo. ");
INSERT INTO big_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ini ngai waberek panu, purik ini yawe nogora mizirikki wiyeke yombanuwili iniyegi kumbak mizagi logo ini kebangkela logo puwili ini ngagozakyengki kerewiyiwiliyegi iza orowei kunagi, keya nawiligu ini i walek songono puwiligiyengke yeke ige wizale yelagi kani. ");
INSERT INTO big_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Keya ini kapmanwiligi ngai yemanewili keya Yuda ono King Ngaiwiligi wiregerau neyegi kiriwei mizirikki weraga luwe wazayagi. Puwekke ini puwiliyegi neyegi langai kozak yei keya ngago nogo iniyegi waligeleyaragi langai kozak yeiyagi. ");
INSERT INTO big_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kapura puwiligu ini kebangkela logo iza orowei ngagozak miziweki kangwekke were pobilik wilek ngelek kumuli nagani, Teni ngago talikyeng kisagi, pilik kumuli nagani. ");
INSERT INTO big_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Purik puwekke Anotogi Kung Walekpokko iniyegi ngago inugu kisagi pura wazono kisiweki kangka wazonobek yanagi legi. ");
INSERT INTO big_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Keya yombanuwiligi si keya sakwiligu ngezewiligi si keya sakwili yombanu puwili yelagiwiliyegi iza yanagi. Keya yombanuwiligu puwiligi yango keya marekngangwiliyegi mabilik keleyagi, keya koloyakongwiligu puwiligi panu keya mangowiliyegi mabilik keleyagi. ");
INSERT INTO big_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Keya ini yeik nogoraga yawe mizirikki wiyeke yongkambanu mabuwiligu iniyegi kumbak mizagi kani, kapura yombanu kunengyeng keya ngangang wagelageya wizimowei neyegi ngizi kumuli pura kozang kebangkeli kanda wila wiyi ngizige mologabok Anotogo wik wizagomagiragi yaliya wazayagimelegabek. ");
INSERT INTO big_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Keya tamizeige puwiligu ini yereng narage ngangang keleyi ma kuneng yani mabura yereng narage kazi kambelizo. Nogo inuwayegi ngago wameik pera kozak yeiweki mizi, ini Isileiliwiligi ngabelakpekke yereng piyengke yawe nogo yana pura ngoluk mizi yagoneiga ne yombanu paka ngalega kayimabek ngereke yogi kani. ");
INSERT INTO big_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Keya puwiligu ini ngangang yanagirikki nogo ngago saweliwei nara pelik kozak yei, Mandik kapiya mizi nak waligeleyi pugubekyaga ngalege ono, ma yombanu yawe mizi nak ngai pugubekyaga ngalege ono. ");
INSERT INTO big_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kapura mandik kapiya mizi nak waligeleyi pugubek kelik pilikweki mizi purik pangka. Keya yombanu yawe mizi nak ngai pugubek kelik pilikweki mizi purik pangka. Tamizeige yombanu neyegi kumbak miziwiligu ne, imakki mangobekyegi pelik kisi, Ni kerewawiligi ngaibek, kisi purik mabura puwiligu mabilik ini, yombanu i nogomakka yolu puwili mabuwiliyegi ngago kaile panu yeiyagi. ");
INSERT INTO big_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Pilikta miziweki mizagi legi ini yongkambanuwiligu iniyegi mizagirikki kulili mizi nagani, purik puwiligu kazing kaile mizi piyeng Anotoyaga liwik wiyagi langai ono. Purik kazing kaile puwiligu ngokmorokta wiya piyeng kalike kimeike walimizagiyeng keya kazing kaile puwiligu mizi wizigeya liwik yolu piyeng wangki kalike kimeike kawela wiyagiyeng kani. ");
INSERT INTO big_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngago nogo iniyegi tonuwa ngezera kekewekke kozak yei pura inugu yongkambanuwiliyegi kimeike kozak yeizo, keya ngago nogo iniyegi yeke ige ngezege kozak yei pura kalike inugu yongkambanu mamokki kelengke ngalizi kozak kisizo. ");
INSERT INTO big_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Keya nogo miziweki yeiya piyeng mizagirikkirik yombanu korik yeikwek ula logo ibengki kapura wilek kambek keya kumbekki nayendau kaile kelemiyagi langai ono puwiliyegi ini kulili mizi nagani, purik segeya Anotoyegi purik pi korikwek weiya logo wilek kambek keya kumbek pongo yereng yezi kusagi onozik ngoriraga yomizora wezamelagibokyegi kele ini kulili mizizo. ");
INSERT INTO big_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yongkambanuwili winak songono winak Kemengiwili kelikwili neyau king korok nalikki ngane wei logo Anotoyegi wata kolak kelibene miziweki purik ini iwaka. Winakwili yeik songonowili kapura tamizeige Anoto inigi Mangobekki kelira ono purik mabura winak songono pilikmek pongo ngabelakke kawiye walagi ono. ");
INSERT INTO big_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kapura ini yombanuwiliyegirik, kebi inuguyengka kebi nganelek piyeng mabiyeng pugu sangkela. ");
INSERT INTO big_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Purikku walimizi purik yombanu wamenak winak kolokngagono puwiliyaga ngalege mizi yagenda. Tegi Anotogo iniyegi ngai wizinda legi kazi mizi nagani. ");
INSERT INTO big_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yongkambanu mamokki wirege yeik nogora kawela wiyimologabok kalike ne Anoto negi Mangobek paka ngalege yolubekki wirege pilik kawela wiyabokki yeikta nogo kawela wiyagi. ");
INSERT INTO big_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kapura tamizeige yombanu nak yongkambanuwiligi wirege neyegi kezanga nani purik mabura kalike ne Anoto negi Mangobek paka ngalege yolubekki wirege piyegirau kezanga managi. ");
INSERT INTO big_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Inuwago kumularik ne ngabelakpekke kazing yombiyangai yongomo mizagimek keremiziweki kayima nobiyeng? A’a’. Ne pelege yawe yongkambanuwili ngai neyauge sanga mizagi pura miziweki kayima, purik nawili ngago nogoragi ngizi panu kumulagi keya nawili ngago nogoragi ngizi panu kumulagi ono legi. ");
INSERT INTO big_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yombanu nak ibuwili pelik sanga mizagi, koyambek mangoyegi ngai mizagi, keya kolomele panuyegi ngai mizagi, keya koyambekki yongokpumele pigi palikmeleyegi ngai mizagi kani. ");
INSERT INTO big_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Logo yombanu nakko neyegi kelirikki wiyeke pigi ingembuwiligu piyegi ngai mizagi. ");
INSERT INTO big_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tamizeige nak neyegi keli logo neyegi kiriwei mizagi kai purik mabura pigi keli pura neyegi yemane panu keya panu keya mangoyegi keli pura songonoweki kapura tamizeige pi pilik mizi ono purik mabura pok yombanu neyegi pangka kiriwei mizagi onobek. Keya tamizeige nak neyegi keli logo neyegi kiriwei mizagi kai purik mabura neyegi keli pura pigi yango keya marekwiliyegi keli puraga yemaneweki, kapura tamizeige pi pilik mizi ono purik mabura pok yombanu neyegi pangka kiriwei mizagi onobek. ");
INSERT INTO big_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Keya tamizeige nak neyegi keli logo neyegi kiriwei mizagi kai mabura ngago nogora kerewiyi keya negi wiyeke ibengkirikki kulili ono keya ne kiling kazing nogo kangmokko kuniweki, kapura tamizeige pi pilik mizi ono purik mabura pok yombanu neyegi pangka kiriwei mizagi onobek. ");
INSERT INTO big_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kapura yombanu neyegi wiyeke ibengkirikki kazi mizi logo ngezebekki kelira keya ngezebekki wik yolugira kozang kebangkeli mizibok pi Anotogi wiregerik ibeng logo wik wizagomagira weiyagi ono, kapura yombanu neyegi ngizi panu kumula logo pulaga wilek kang pugubek keya wik yolugi pugura neyegi tiya mani mizibok ibeng wizagomagi ono, pi paka ngalege wik wizagomagira weiyagi. ");
INSERT INTO big_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Weik nogo ini wezayeli logo yombanu ini nogo wezayeliwiliyegi koli keleyi puwili iniyegi koli keleyi purik neyegirau keleni yagenda, keya yombanu neyegi koli keleni puwili ne wezanelabokyegirau koli kelemi yagenda. ");
INSERT INTO big_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nogo yombanu nak wezamela kopong pi ngagora kozak kai logo pok ngagora kozak kairikki wiyeke koli kelemiya puwili, pokko kanga weiyagi mabilikta puwilirau weiyagi. Keya yombanu pangkabek yarolege pakela logo pi ne pangkabekyegi sawela kopong piyegi wazono kelemiyabok purik pok pangkabokko kanga weiyagi mabilikta weiyagi. ");
INSERT INTO big_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Keya nakko yombanu neyegi kiriweiwiliyaga nak yarolege pakela logo pi neyegi yawe mizirikki wiyeke pi yeik kai wik songono nangezi nibene mani puriktau pugu wazono miza puragi wiyeke Anotogo pi kanga managiyeng wei penanging, yeiya. ");
INSERT INTO big_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Togo Yisugu yombanu meleyau keya pongo ingenazikka neyau ngezebokko waligeleyiwiliyegi ngago kiriwei mizagi piyeng kozak yeiya logo pi pulumeng wizamiya logo yereng pulogo merekeyengki kambela. Kanda pulogo pugu yongkambanuwiliyegi Anotogi ngagora waligeleyi keya yana. ");
INSERT INTO big_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wok nakke Yowan kaimelibek wigirimakka wigira wizigeya pugu waligeleyiwiligu piyegi Yisu Kilisibokko Anotogo keke miziyeng mizirikki kozak meiya. Tegi Yowan kaimelibokko yombanu pi ngezebokko waligeleyiwiliyaga nawili Yisuyegi nguk meibene ngago pelikta kiling wezayela, Ma ni yombanu yemizi ulogo kalike lewagi kaiya mabok ma teni ngoluk nakyegi yuke yolugi, meibene wezayela. ");
INSERT INTO big_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Puwili Yisuyegi kandawekke Yisugu Anotogo keke miziyeng mizageya wizilege puwiligu pakela. Puwiligu Yisuyegi pelik meiya, Yowan kaimelibokko niyegi pilik nguk neiweki teni wezayela logo pugu pelik kai, Ni yombanu yemizi ulogo kalike lewagi kaiya mabok ma teni ngoluk nakyegi yuke yolugi ma talik, kai, meiya. ");
INSERT INTO big_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tegi Yisugu puwiliyegi pelik yeiya to mela, Yowanyegi inuwago mabek pakeli keya kerewiyi miza piyengki kozak meizo. ");
INSERT INTO big_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Piyeng pelikyeng, wireyeng kusawili ngereke pakeli, keya inge keya melegawere ibengwili keya inge koruwili ngereke yongomo mizi, keya kemegeme Leposimek meimek kilingwili ngereke korikyeng yombiyangai wazayi, keya kerangangyeng waliyawili ngereke kerewiyi, keya ibengwili ngereke yangalekta wik yolu keya yongkambanu watabiyengki yeik puwili Anotogi ngago wazono puragi kerewiyi. Inuwago Yowanyegi piyengki kozak meiweki kandobeli. ");
INSERT INTO big_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Keya perarau inuwago piyegi kozak meizo, Ne yombanu kalike lewagi kaiya mabok logo ngizi panu kumuli keya purikki kangka neyau onobekyegi wilikwilikta yolu, meizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yombanu ngago Yowangira weiyawili weik kuna wizigeya Yisugu Yowanyegi langai yongkambanu wawere ulawiliyegi pelik yeiya, Ini kurung yeik Yowan kaimelibokko wizagomawekke kambela puwekkerik ini nangaiyengki pakeliweki kambela? Ini Yowan yengelik kebarekpokko orowei mizi piyeng kelik kozang ono nobiyeng pakeliweki kambela? A’a’. ");
INSERT INTO big_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mabura ini nangaiyengki panga pulogo pakeliweki kambela? Ma yombu nak watabi wik wazono nayeng wakiyabekyegi pakeliweki kambela? A’a’. Yombu wik pilik piyeng wakiyi keya watabi kolokngagono piyeng kiling puwili yombanu ngai yemanewiligi i wazono yemane piyengki keke yoluwili. ");
INSERT INTO big_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Logo ini yombu pilikpok pakeliweki kambela ono mena, takyegi ini pakeliweki kambela? Ma ini yombu Poropek mei, yombu Anotoyaga ngagora weiya logo yongkambanuwiliyegi kozak kai nakyegi pakeliweki kambela? Ei, wameik. Kerewiyi. Yowan yombu Anotogi poropek pilikpek kele kapura pi poropekwiliyaga ngalegebek. ");
INSERT INTO big_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Purik pi mabokyegi langai Anotogi Kapiya Walektikku Ne pigi Marekpekyegi pelik kaiya, Kerewiye, ni kalika kangkine kapura nogo were ngago nogora oroweibek wezamelagi. Pi nigi kazing kunagimek kangkere mizagi kaiya, yeiya. ");
INSERT INTO big_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yisugu mawinda pelik yeiya, Ngago nogora wameik panu kani kerewiya koyizo. Yongkambanu ngabelakpekke wizageya koyi kayimi pewiliyaga Yowan kaimelibek ngalege panubek kapura pewekka yombanu yeiktarau ono nak ngago nogoragi kerewiya logo nogo piyegi ngaiweki keleni mologabok Yowanyaga ngalege panumelegabek mizagi. ");
INSERT INTO big_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Weik Yowan kaimelibokko weik solo ngago yana puraga kang kang mabek pewekkerik Anotogo pigi ngaimekki ngairik kozang lewagela keya yongkambanu solo wamenarikki wiyekemek mamok nak nak panga Anotogi ngaimekki kiliya kuniweki kozang yawe mizi. ");
INSERT INTO big_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Koka walaka Anotogi lo Mosego lende miza mabiyeng keya yombanu Anotoyaga ngagora weiya logo kozak kisawili mabuwiligu yombu Anotoyaga ngagora weiya logo kozak kai Ilaya kelik nak Anotogo pigi ngaimekki weik solo ngai puwekke lewagi kisa. ");
INSERT INTO big_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Logo tamizeige ini ngago puwiligi piyengki ngizi panu kumulagi purik mabura yombanu Ilaya kelik pek weik lewagela logo pi Yowan pok legi purikki ngizi panu kumuli. ");
INSERT INTO big_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yombanu kerangang kerewiyagiyeng kilingwili mabura waberek kerewiyizo. ");
INSERT INTO big_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mena, nogo ini yongkambanu mabek perage ngabelakpekke yolu pewili watabi nangaiyeng kelik kaiyagi? Nogo iwaka logo nogo kozak yeiweki. Ini koloyakamandik songono yerengke karagare miziwili kelik. ");
INSERT INTO big_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nawiligu nawiliyegi pelik yei, Teni yongolo uliwekke ingimei kapura ini teni kiling yongolo uli ono. Keya teni ingi yalekkiyeng mei kapura ini purikkirau kiyebuk kopong teni kiling ingi yalekkiyeng mei ono, yei. Logo pilik mizi purikku kai pura ini Yowan kaimelibokko ngago kaiyeng ma nogo ngago kai piyeng ma mizi piyengki kiyebuk. ");
INSERT INTO big_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Purik Yowan kayimawekke pi pereksik keya kai waimbek inugu ni pilik na ono purikki ini kiyebuk keya inugu pi Anotogo wezamelabek kisagirikki kiyebuk kopong inugu kerewa nak pigi yungke yolu, kisa. ");
INSERT INTO big_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Keya mabek ne yombanu paka ngalegabek kayima logo ne ngeragi ni keya kai waimbek ni puriktau ini kiyebuk keya inugu pelik kisi, Keriyi, pi ngeragi momanengka nibek keya kai waing kolokngagono nibek, kisi. Keya peliktau kisi, Pi yombanu king takis wei piyengka nayeng ngoweiwili keya kaile mizi nawili kilindau kewengke mizibek, kisi. Ini te Yowangu kisi piyengki kezanga mani kele kapura, Anoto iwakaragi mangobek legi pigi yango keya marekngang pugu kaiyeng mizi mabuwiligu piyegi pelik kisi, Anoto wameik pangka mizibokko, kisi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yisugu puwiliyegi piyeng kozak yeiya logo pulaga pugu yereng ulogo ngezebokko Anotogo keke miziyeng kolokngagono kozang mizayengke ngalik kai, purik yongkambanu yereng piyengke yoluwiligu Anotogo keke miziyeng pugu mizarikki pakela kele kapura kaile puwiligu miziyengka kowita ono logo purikki wiyeke pugu pelik ngalik kai, ");
INSERT INTO big_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yomono, wok Anotogo ngagozak kalike mizagibekke ini Yuda yongkambanu yereng Korasin meirage yolu puwiliyegi ngangang yemane panura lewagi, keya ini Yuda yongkambanu yereng Pesaita meirage yolu puwiliyegirau ngangang yemane panura lewagi. Purik nogo Anotogo keke miziyeng yereng inuguyauge miza kapura ini neyegi saweli ono. Kapura tamizeige nogo Anotogo keke miziyeng yereng inuguyauge miza piyeng panga Taya keya Sairong Yuda onowiligu yereng yoluyauge pilik piyeng miza kesak yongkambanu yereng piyaugiwiligu yaka kaile puwiligiyengke nguk namizi kuneng miza logo kaile puwiligiyengka kowita logo wilek kang puwiligiyeng neyegi saweli kak. ");
INSERT INTO big_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wameik panu, wok Anotogo ngagozak kalike mizagibekke purik yongkambanu yereng Taya keya Sairongyauge koka walaka kaile unatuba miza puwili ngangang weiyagi kapura ini kele ngangang yemane panu weiyagi kani. ");
INSERT INTO big_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yomono. Ini yongkambanu yereng Kapaneyam meiragawili, ini paka ngalegi kangki purikki kumuli ma talik? A’a’, yeik. Inugu ngago nogoragi kerewiyarik kolokngagono kapura neyegi saweli ono, legi ini pongo yereng yezi kusagi onozik ngori puraga yomizora wezayelagiwili kani. Tamizeige nogo Anotogo keke miziyeng yereng inugurage miza piyeng panga Sorong yerengke pilik piyeng miza kesak puwiligu kaile puwiligiyengka kowita logo Anotogo yereng Soronda neneng ngeli kak ono, yereng pura ngoluk wizagomi kak. ");
INSERT INTO big_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Wameik panu, wok Anotogo ngagozak kalike mizagibekke purik yongkambanu yereng Sorong meiraga koka walaka kaile unatuba miza puwili ngangang weiyagi kapura yongkambanu yereng Kapaneyam puragawili ngangang yemane panu weiyagi, kai. ");
INSERT INTO big_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mabuwekke Yisu Anotoyegi waberek pemek pelik meiya, O Peba, ni ngilumbek keya ngabelakpekki Yemizibek, nogo niyegi wazono nei, purik nugu yongkambanu iwaka kumuli keya kangka yemaneyeng kiling kumuli puwiliyegi wameik ngiziyeng waligeleyi ono kapura nugu yongkambanu neyegi yeik ngizi kumuli koloyakamandik songonowili kelik puwiliyegi piyeng waligeleyi. ");
INSERT INTO big_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ei, Peba, pera kumuli nugura keya keli ni makngezegirago legi nogo yeik nugura yongolok mei, meiya. ");
INSERT INTO big_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yisugu Anotoyegi pilik meiya logo pugu yongkambanu koyilegewiliyegi pelik yeiya, Negi Mangobokko ulogo watabi mabiyeng neyegi nana. Nakko neyegi ngizi panu iwaka ono, kapura ne negi Mangobekki Marekpek legi negi Mangobek ngezebek kele neyegi iwaka, keya nakkorau negi Mangobekyegi ngizi panu iwaka ono kapura ne Koyambokko kele piyegi iwaka, keya yongkambanu Koyambokko Mangoyegi langai waligeleyiweki mizi puwili kele negi Mangobekyegi iwaka. ");
INSERT INTO big_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ini yongkambanu mabuwili wilek kuneng mizi keya kunengyeng wagela logo kiyebuk sende mizi puwili neyegi koli logo nogo kele iniyegi kazing kumanagimek yaniweki mena. ");
INSERT INTO big_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ne kazing kuzigemek mizibek keya ne makngezego ne makngeze kulengkebek mizibek legi neyegi sawela logo nogo miziyengka iwaka siweki logo teni menalege kazing nogomekke kunagi. Pilik mizageya koyimowei ini wilek kang inuguyengki kazing kumanagimek yolok ngelagi. ");
INSERT INTO big_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Purik kazing nogomek yombiyangai panu keya yawe nogo iniyegi miziweki yani piyeng inugu miziwekkerik iniyegi yemanegi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pilik yeiya logo waleleige wok Yudawili yawe mizi ono puwiligu Anotoyegi ya kumulibek logo wok Sabatpek meibekke Yisu kiling yombu ngezebokko waligeleyiwili yawe pandi wit nalei neing wei kambela. Yombu puguwili weik yagasi legi puwili kunimowei wit wire pandiyeng kelikyengki wireyeng tiya logo ni mizi kuna. ");
INSERT INTO big_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Puwiligu pilik miza purikki yombu Palisi mei nawiligu pakela logo Yisuyegi pelik ngalik meiya, Keriye, nugu waligeleyiwiligu lo tenigi wok Sabatpekke yawe mizi nagani kaiya pura ngelira nangki, meiya. ");
INSERT INTO big_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tegi Yisugu puwiliyegi pelik yeiya to mela, Inuwago Anotogi Kapiya Walektikke tenigi yelibungangwiligi ngaibek Tawitigu koka walaka miza purikki sangkela puragi kumuli. Wok nakke Tawiti keya pi kiling puwili ngeragiyengki yeik wizigeya yagasi miza, legi ");
INSERT INTO big_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tawiti Anotogi imakki yeke ige la logo ngaibekyegi nguk meiya logo iwing perek Anotogi mowiya piyengka weiya logo na keya yombu pi kilingwilirau yani miza. Puragi ini sangkela kapura ini ngizi iwaka ono. Lorago pelik kai, Iwing perek piyeng yombu yeikwili ni nagani, yombu Anotoyegi kolak miziwili keke nagiyeng, kai. Kapura Anoto Tawitigu yagasi miza logo miza puragi ngalik meiya ono, legi inuwarau negi yombu ne makngezego waligeleyiwiliyegi ngalik yei nagani. ");
INSERT INTO big_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Keya inuwago Anotogi Kapiya Walektikke Anotogi lo Mosego lende miza piyengke yombanu Anotoyegi kolak miziwiligu wok Sabatpekke yawe puwiligira mizi puwekke purik puwili Mosegi lo pura ngela meli purik teni iwaka, kapura purik kaile mizi yagenda ono. ");
INSERT INTO big_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mena, nogo kozak yeiweki mizi puragi kerewiya koyi, Yawe Anotogo ne miziweki wezanela pura yawe yombanu Anotogi i walek yemanemakke piyegi wata kolak kelibene miziraga yemane kani. ");
INSERT INTO big_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Logo Kapiya Walektikke yungke pelik kaiyarikki kumuli, Inugu neyegi watawili kolak kelibene waliya nani puwekke purik ne wilik kapura inugu yongkambanuwiliyegi yalek miza logo wazono mizi puwekke purik ne wilik panu, kaiya. Togo tamizeige inuwa puragi solorikke iwaka panu kesak inuwago yombanu neyegi yawe miziwili kaile nara mizi yagenda mizi kak ono, inuwago puwiliyegi yalek miza logo wazono keleyi kak. ");
INSERT INTO big_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Keya ne yombanu paka ngalega kayimabek, ne wok yawe mizi onobekki ngaibek keya ne watabi yongkambanuwiligu wok yawe mizi onobekke mizagi piyengki kaiyagibek, yeiya. ");
INSERT INTO big_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pulaga Yisu Yudawiligi i walek songono namakke yeke ige la logo ");
INSERT INTO big_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","pulogo yombu melelora koru miza nak wizilege. Yombanu Yisuyegi kiyebuk mizi nawili Yisugu kazing korowali mizi nayeng mizi purik kebangkelagiwili pulogo piyegi pakelara ngai koyilege. Tegi puwiligu Yisuyegi pelik nguk meiya, Wok yawe mizi onobekke yombanu kemegeme nak yombiyangai wazamiyagi purik pangka ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tegi Yisugu puwiliyegi pelik yeiya to mela, Tamizeige iniyaga nak liyeng memeng namek logo pumok wok yawe mizi onobekke pongo kawik yemanerikke kiliya purik nugu kumulagirik wokpok wok teni yawe mizi onobek legi liyeng memengmek mabilik wizi pani mizagi ono, a’a’, nugu liyeng memeng pumokyegi sawelagi logo yomizora wazamiyagi logo purik pangka. ");
INSERT INTO big_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Keya wok yawe mizi onobekke tonugu yombanuwiliyegi saweli puriktau pangka, purik yombanu nak liyeng memeng namekka lewege panubek kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pulaga Yisugu yombu melelora koru mizabekyegi melelora tungkule meiya. Logo pi mele puguzik tungkula logo weik ngereke mele nazik kelik mabilik yombiyangai sa. ");
INSERT INTO big_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pilik miza logo waleleige yombanu Palisiwili mei puwili i walek songonomakka welagela yerageya logo puwili kiling nawilirau wawere ula logo kazing Yisu ula logo ibengki namekki kozak kela. ");
INSERT INTO big_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Togo Yisu puwiligu pilik kozak kela puragi kerewiyawekke pi yereng pura wiya logo kambela. Kapura yongkambanu kolokngagono piyegi kalika kiriwei kambela. Pugu yombanu kemegeme puwili mabuwili yombiyangai wazaya. ");
INSERT INTO big_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kapura puwiligu pi Anotogi Marekpek purikki yongkambanuwiliyegi kozak yeiya nelegi Yisugu kozang ngago yeiya. ");
INSERT INTO big_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Logo kazing mabilikmekke ngago yombu Anotoyaga ngagora weiya logo kozak kaibek Isaya meibokko koka walaka kaiya pura weik ngizi lewagela. ");
INSERT INTO big_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Anotogo pelik kai, Keriyi, pok neyegi yawe mizibek, nogo sawiyabek. Pi nogo yagolok panu kelibek keya wilek kang nogobek piyegi wilik panu. Nogo negi Kung Walekpek piyegi mani logo pugu ngago kazing pangka nogomekkira keya ngago nogo ngagozak keleyagiragi yongkambanu ngabelak mabiyengke Anotoyaga koweige yolu mabuwiliyegi kozak yeiweki wezamelagi. ");
INSERT INTO big_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kapura pi ngalik keli yongomo mizagi ono, ma ngago ngalizi kaiyagi ono, ma pi kazingyengke wangka kek kairikki nakko kerewiyagi ono. ");
INSERT INTO big_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yombanu merek liyembo mizabok kelikwiliyegi pugu yalek miza logo puwili liya melagi ono, pugu puwili yombiyangai wazayagi. Keya yombanu yezi wilek kusaweki mizi puzik kelikwiliyegi pugu yalek miza logo purik kusa melagi ono, pugu puwili yaliya wazayagi. Pi yawe mizi kai kanda kazing pangka pumokko lewegegi. ");
INSERT INTO big_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pi yawe mizi kai kanda yongkambanu Anotoyegi iwaka onowili piyegi wilekyeng ngalege wiyagi, kai, kaiya. Koka walaka Isayago pilik kaiya kapura Yisu yawe pugura miza puwekke ngago pura weik ngizi lewagela. ");
INSERT INTO big_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wok nakke yombanu nawiligu yombanu kerewa nak yenge yungke kiliya kopong wireyau kusa keya kiligawere waliya logo ngago kaiyagi langai ono nak miza orowei Yisuyegi wiriya. Yisugu kerewabek yombanubekyaga welagela wezamela logo yombanubek yombiyangai wazamiya logo yakabok weik ngago kai keya wireyau ngaiwili miza. ");
INSERT INTO big_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yongkambanu wawere ulamek mamok pakela logo lelengkira logo nakko nakyegi pelik mei yongomo miza, Yombu pilik mizi pobok Tawitigi marekngangwiliyaga Anotogo teni Yudawiliyegi ngaiweki wezamelagi kaiyabok ma talik? Keya nawiligu pelik yeiya to mela, Mabok ma talikne. ");
INSERT INTO big_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kapura puwiliyaga Palisiwili meiwiligu pelik kisi, Talik miza logo pek kerewawili welagela wezayeli? Takko pi kozang mani? Kerewawiligi ngaibek Sadang, yeik pigi nara Piyesebu, pugu pok kerewawili welagela wezayeliweki kozang mani kani, kisi. ");
INSERT INTO big_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kapura Yisu kangka puwiligiyengki iwaka legi pugu pelik yeiya, Nogo kazing saweliwei pemekke purikki langai kozak yeiweki mena kerewiya koyi. Tamizeige kapmanwili ngezewiligi tepekke ngai keli puwekke purik kozang koyagi ono logo kawiyegi. Ma tamizeige yerengkewili ngezewiligi tepekke ngai keli puwekke purik sanga miza logo nawili narikke miza melagi. Ma tamizeige yombu nak ibuwili ngezewiligi tepekke ngai keli puwekke purik sanga miza logo nawili narikke mizagi. ");
INSERT INTO big_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kazing mabilikmekke tamizeige Sadang pi ngezebek yongkambanuwiliyaga welagela wezameli purik ngai pugumek sanga miza logo kozang wizei penangai ono, yeikki. ");
INSERT INTO big_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Keya ne kerewawili kozang Sadangkirago welagela wezayeli kesak iniyegi kiriweiwilirau kozang Sadangkirago kerewawili welagela wezayeli. Togo inuwayegi kiriweiwili kerewa welagela wezayeli puwiligu ngago inuwagira ngaigu kisi mizi. ");
INSERT INTO big_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sadangko ne kozang nana ono, pilik segeya Anotogi Kung Walekpokko ne kozang pugura nana. Logo nogo kerewawili welagela wezayeli logo purikku walimizi purik Anotogo pigi ngaimekki ngai pura iniyegi weik kanda ngai wizinda. ");
INSERT INTO big_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nogo kazing saweliwei pemekke ne makngezegi kozang panu puragi langai kozak yeiweki mizi. Nakkorau yombanu kozambekki imakki yeke ige yabela logo watabiyeng ngoweiyagi langai ono, kapura tamizeige pi were yombanu kozambek wigira wazamiya mabura kele pi pangka watabi pugu kelagi mabiyeng ngoweiyagi langai. Togo purikku kai purik Sadang kozang kapura ne kozang panu kani, logo nogo pangka Sadangki kerewawili yongkambanuwiliyaga welagela wezayelagi. ");
INSERT INTO big_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Togo yongkambanu namele keya nak ne kiling sawela ono purik pi neyegi ngai mizi yagenda, keya namele keya nakko yongkambanuwili menalege wawere keleya nowiyi ono purik pugu puwili kazi kambeli keleyi yagenda. ");
INSERT INTO big_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Puragi weraga legi nogo pera yei, yongkambanuwiligu kaile miza piyeng mabiyeng keya ngago kaile puwiligu kisa piyeng mabiyeng puwiligu Anotoyegi kozak mei purik Anotogo tumulagi kapura nakko Anotogi Kung Walekpekyegi langai ngago kaile kaiya purik Anotogo tumulagi ono. ");
INSERT INTO big_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yombanu nakko ne yombanu paka ngalega kayimabekyegi langai ngago kaile nara kaiya purik Anotogo pura tumulagi kapura nakko Anotogi Kung Walekpekyegi langai ngago kaile kaiya purik Anotogo mabek ngabelakpekke pewekkerau pura tumulagi ono ma wangki kalike paka ngalege wizageya kayimagi puriktau pura tumulagi ono. ");
INSERT INTO big_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yengeleiyengki kumuli. Tamizeige yengeleilei wazono purik mabura wilekyendau mabilik wazono. Tamizeige yengeleilei wazono ono purik mabura wilekyendau mabilik wazono ono. Yengeleileigi iwakagirik wilek pugu wiri piyengki pakela logo. Kazing mabilikmekke ini Palisiwiligu yawe nogo mizi piyengki pakeli logo tamizeige inugu yawe pugura wazono kisi mabura pura Anotogi kozandago miza, kisagi. ");
INSERT INTO big_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kapura ini inigi mangobek kemalemek Sadangyaga lewawili kani ini yombanu kailewili, legi talik miza logo ini ngago wazonoyeng kisagi, purik kilirago kai piyeng yenge yaga kolokngagono yolulikyengka kaiyengko. ");
INSERT INTO big_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yombanu wazonobek kumuli wazonoyeng yenge ya puguraga wara yolu. Pilik kopong pi kazing wazonoyeng mizi mizi. Kapura yombanu korowalibek kumuli korowaliyeng yenge ya puguraga wara yolu kopong pi kazing korowaliyeng mizi mizi. ");
INSERT INTO big_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kerewiya koyizo. Wameik panu, wok Anotogo ngagozak mizagibokko purik yongkambanu mamok nak nak ngago wazewaze yeik wezamela piyengki Anotogo nguk yeiyagi kani. ");
INSERT INTO big_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Purik ni makngezego kaiyayengko Anotogo ni wazonobek ma ni kailebek neiyagi legi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pulaga yombanu Mosegi loyengki waligeleyi nawili keya yombanu Palisi mei nawili Yisuyegi pelik meiya, Kiriwagabek, teniyegi Anotogo keke mizi nara waligeleye logo ni Anotoyaga kayimabek purik teni iwakaweki, meiya. ");
INSERT INTO big_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pilik kisi legi Yisugu puwiliyegi pelik yeiya to mela, Ini yongkambanu mabek peragewili kaile panu logo Anoto wezamela, yombu pigi yongokpumele wezamela logo yongok namele ngereke weibok kelikwili kopong inugu nogo Anotogo keke mizi nara miziweki nguk nei. A’a’, nogorau Anotogo wik keke mizi naragi ini pakelibene waligeleyagi ono, purik ulogo Anotogo keke mizi kozang nara yombu Yona meibekyegi kimeike miza legi. ");
INSERT INTO big_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Logo pugu keke miza pura pelik, koka walaka Yona Anotoyaga ngagora weiya logo kozak kaiyabek watabisi yemanemokko nguk tiya logo wok neyau watabisi yemanemekke yungke wiziya logo pulaga wok kalikebekke watabisi yemanemokko kungiza mela logo Yona ngereke wik wizagoma. Pilik miza purikku yongkambanu yereng Ninibe meiragawiliyegi Anotogo Yona puwiliyegi wezamela purikki waligeleya. Kazing mabilikmekke ne yombanu paka ngalega kayimabek wok neyau yenge ngabelakpekke yungke wiziyagi logo pulaga wok kalikebekke yangalek meiyagi logo purikku iniyegi Anotogo ne iniyegi wezanela purikki waligeleyagi. ");
INSERT INTO big_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Wok kalike panu Anotogo yongkambanuwili ngagozak keleyagibokko yongkambanu mabuwili yangalek meiya logo Ninibe yongkambanu Yuda onowiligu ini yongkambanu Yuda mabek perage pewiliyegi pelik yeiyagi, Ini kaile miza wiziga ini ngangang mizagi, purik teni Yonagi ngago Anotoyagaragi kerewiya logo kaile tonuguyengka kowita kapura ini yombu Yonayaga ngalegebokki ngago Anotoyagaragi kerewiya ono kopong ini ngangang mizagi, yeiyagi. ");
INSERT INTO big_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Keya wok kalike panu Anotogo ngagozak keleyagibokko purik yongok Kuwin Ngai yongkambanu Yuda ono ngabelak lewe Saut Siba meibekkawiliyegi koka walaka ngai wiziyamologo ini yongkambanu Yuda mabek perage pewiliyegi pelik yeiyagi, Ini kaile miza wiziga ini ngangang mizagi, purik ne King Ngai Solomongu ngago iwaka wazono puguyeng kozak kairikki kerewiyiweki koweige kambela kapura ini yombu Solomonyaga ngalege inuwa kiling wizagomabokko ngago iwaka wazono puguyeng kozak kairikki kerewiya ono kopong ini ngangang mizagi, yeiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yisugu yeke langak pelik yeiya, Ne kazing saweliwei pemek iniyegi kalike mizagi purikki kozak yeiweki, Kerewabek yombanu nakki yenge yungka nakko welagela wezameliwekkerik pi paka yengelei ngezege pi yolugilege pakeliwei kang. ");
INSERT INTO big_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Pi yolugi narik yolok ngela ono purik pi ngezebokko ngezebekyegi pelik mei, Ne ya ne makngezego ulogo wizamiya logo kayima puragi ngereke toweki, mei. Togo pi kandobela logo tapakeleige pura yombanu yakabokki yenge yungkera watabi nayendau ono wizilege. ");
INSERT INTO big_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Pi morik kerewa korowali panu melenazik keya nazikka neyauwili iza wara logo puwili mabuwili kanda yombanubekki yenge yungke kiliya logo pulogo koyima. Togo yombanubok koka kaile wiziya kapura mabek weik pi kaile panu yolu. Ini Yuda yongkambanu kaile mizi mabek pewekke pewiliyegi kazing mabilikmek lewagelagi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yisu ngoluk yongkambanuwiliyegi ngago yanageya tawizeige pura pigi panumele keya sakwili piyegi keriyiweki kanda logo imakka yenge yerengke luweza koyimowei ngago nara yeke ige piyegi pi yeragibene wezamela. ");
INSERT INTO big_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yongkambanu kolokngagono Yisuyegi yawereng kelemiyara mogosa logo koyawili nakko piyegi pelik meiya, Nigi panumele keya sakwili yenge yerengke yuke koyimowei niyegi ngago kisi, meiya. ");
INSERT INTO big_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tegi Yisugu pelik meiya to mela, Negi panumele tamele keya negi sakwili tawili? ");
INSERT INTO big_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pilik meiya logo pugu yombu ngezebokko waligeleyi puwiliyegi langai melezik walimizageya wizimowei pelik yeiya, Kerewiyi, pelege negi kelengke pewili negi panu keya sakwili kani. ");
INSERT INTO big_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Purik negi Mango paka ngalege yolubokko mizagi keliyeng mizi mologabok negi sakpek keya negi sakmele keya negi panumele, yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wok mabokko Yisu imakka welagela kuna logo kai kolamiyabekke kerelege kambela. Kanda pulogo pi mogosa logo yongkambanuwili waligeleyiweki. ");
INSERT INTO big_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kapura yongkambanu wawere ulawili kolokngagono panu logo puwiligu pi tektek kangane kelemiyageya koyimowei yawereng kelemi, legi Yisu wang naleige tameneng meiya logo mogosa, logo wanglei panga kaibekke songono nangezi kuna logo pugu wangleiga wizimowei yongkambanu pulogo kaingimbekke wawere ula koya puwiliyegi ngagoyeng waligeleya. ");
INSERT INTO big_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Keya pi puwiliyegi ngago saweliweiyengko ngago ngizi kolokngagonoyengki waligeleya. Pugu ngago saweliwei nara pelik yeiya, Wok nakke yombu nak pandi wilekyeng yawege wezameli kambela. ");
INSERT INTO big_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pi wezameli kunarik wilek nayeng ngabelak kozang yongkambanuwiligu wei mizibekke wala logo winakwiligu kanda na. ");
INSERT INTO big_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Keya wilek nayeng ngabelak kingyeng kilimbekke ngalege wala kapura ngabelak songonobek kopong pengyeng nguk namizi lewagela. ");
INSERT INTO big_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kapura yokmek ngaiwekke yokmokko pak meiya logo ngoliya keya puliliyendau songono kopong pengyendau ibeng sa. ");
INSERT INTO big_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Keya wilek nayeng ibek ingakyeng kilingyengki tepekke wala kapura ingak piyengko momanenda wiya logo pengyeng ibeng sa logo wilek wiri ono. ");
INSERT INTO big_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Keya wilek nayeng ngabelak yombiyangaibekke ngalege wala kopong marekyeng lewa wizigeya yemane sa logo wilek wazonoyeng wira. Kang nayeng wilek songono wiri, keya kang nayeng wilek yemane wiri, keya kang nayeng wilek yemane panu wiri, yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yisugu ngago saweliwei pura kozak yeiya logo pugu puwiliyegi pelik yeiya, Ini kerangangyeng kilingwili mabura waberek kerewiyi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Togo waleleige yombanu Yisu ngezebokko waligeleyi puwiligu piyegi kanda pelik nguk meiya, Nugu yongkambanuwiliyegi ngagoyeng kozak yeiwekke ni ngago saweliweiyengke kozak yeira nangki? ");
INSERT INTO big_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tegi Yisugu puwiliyegi pelik kanga yeiya to mela, Anotogo ini ne kiling sawela puwiliyegi watabi Anotogo pigi ngaimekki ngai yolu puragi koka iwaka ono piyeng kimeike kelemiweki keli logo nogo iniyegi saweliwei purago kai puragi kozak yeiweki mizi, kapura yongkambanu ne kiling saweli ono puwili peyengki iwaka koyimagi ono. ");
INSERT INTO big_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tegi nogo ngago kai puragi waberek kerewiya panu keya ngagoragi kumula panu, purik tamizeige yombanu nak Anotogi ngagora kebangkela logo kiriwei yolubok Anotogo pi ngizira mawiyarek managi keya pugu pokyegi ngizira ngoluk mak mawiyarekka managi logo pugu ngizira unatuba weiyagi kani kapura tamizeige namele keya nak ngago puragi kiriwei ono purik Anotogo ngago pilik mologabokko songono kebangkela yolu nobiyeng miza pura piyaga weiya mowiyagi kani. ");
INSERT INTO big_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nogo yongkambanu ne kiling saweli ono puwiliyegi ngago saweliweiyengki kozak yei purikki solorik pelik, puwiligu wire puwiligiyengko yawe nogo miziyengki kabelak kangka pakeli mizi kapura puwili ngizi pakeli ono, keya puwili ngago nogo kai puragi kerewiyi kapura puwili kerangang mani ono keya ngizi panu kumuli ono. ");
INSERT INTO big_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Togo yombanu Anotoyaga ngagora weiya logo kozak kai yeikta Isaya meibokko koka walaka pilik kaiyara puwiliyegi weik ngizi lewagela, Yongkambanuwiligu Anotogi ngago ngizira mazeng keya kerewiyi kele kapura ngizi kumulagi ono. Keya puwiligu wireyengko Anotogi yawe miziyengki mazeng keya pakelagi kele kapura ngizi pakelagi ono. ");
INSERT INTO big_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Purik yombanu pewiligi kangkayeng kingyeng kelik kopong puwili ngezewiligi kerangangyeng weik waliya keya ngezewiligi wireyeng weik kusa koya. Puwili peyeng miza, purik wire puwiligiyengko Anotogi yawe miziyengki pakela nelegi, keya kerangang puwiliyengko Anotogi ngago wameikta kerewiya nelegi. Purik tamizeige puwili pilik miza kesak puwiligi wilek kangyeng neyegi kowita logo nogo yombiyangai wazayi kak, kaiya. Koka walaka Isayago Anotogi Kapiya Walektikke yungke pura pilik lende miza kapura weik ngizi lewagela. ");
INSERT INTO big_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kapura ini puwili kelik onowili, inugu wireyengko yawe nogo miziyengki pakela logo iwaka, keya ini ngago nogo kai puragi kerangangyeng mana logo ngizi panu kumuliwili legi ini wilik miziweki. ");
INSERT INTO big_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kerewiyi, wameik panu, yombanu kolokngagono Anotoyaga ngagora weiya logo kozak kisawili keya Anotogi kazing pangkamek mizawili koka walakarik watabi Anotogo keke mizi nogo mabek mizi wizigeya inugu pakeli piyeng pakelagiweki miza kapura puwiligu pakela ono, keya mabek nogo weik kai logo inugu kerewiyi piyeng puwili kerewiyiweki miza kapura puwili kerewiya ono. ");
INSERT INTO big_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ini ngago saweliwei yombu nak pandi wilekyeng yawege wezameli kambelaragi nogo yaka kaiya puragi solorikki kerewiya koyizo. ");
INSERT INTO big_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yombu pandi wilekyeng yaka wezamelabok yombanu ngago Anotogo pigi ngaimekki ngai yolu puragi yongkambanuwiliyegi kozak yei nak kelikpek. Keya ngabelakpek yongkambanu ngago pura kerewiyi puwili kelik. Keya ngabelak kozang wilek nayeng wala logo winakwiligu kanda nabok yongkambanu ngago puragi kerewiyi kapura ngizi kumuli ono puwili kelik. Sadang korowalibokko nguk namizi kanda ngago pura puwiliyaga yogok meiya yowiya logo wezameli. ");
INSERT INTO big_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Keya ngabelak kingyeng kilimbok yongkambanu kerewiyi nawili kelik logo pura nguk namizi weiyagirikki wilik keya wilek marekyengki puliliyeng yenge ngabelakke kiliya kula logo mabilik puwili ngago puragi kumula ");
INSERT INTO big_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kapura wilek kang puwiligiyengke yenge yungke kiliya panu ono, logo puwili ngagoragi ngizi kumuli purikki wiyeke kunengyeng yani ma ngangang keleyi puwekkerik puwili nguk namizi Anotoyegi kezanga mani logo puwiligi ngizi kumulara yeikki. ");
INSERT INTO big_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Keya ngabelak ibek ingakyeng kilimbok yongkambanu kerewiyi nawili kelik logo puwili Anotogi ngagora kerewiya kele kapura kazing ngabelakpekki kunengyengki kumuli pumok, keya kingyengki ngora keli pumokko Anotogi ngagora waliya logo kazing puwiligu Anotoyegi mizi piyeng ngizi onowili. ");
INSERT INTO big_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kapura yongkambanu nawili ngabelak wazono wilekyeng walabok kelikwili. Puwili Anotogi ngago wazonora kerewiyi logo ngizi kumuli logo pura wilek kang puwiligiyengke kozang kebangkela yoluwili. Logo puwiligu miziyengki ngiziyeng weik kimeike lewagela. Nawiligu purikki ngizirik walimizirik songono, keya nawiligu purikki ngizirik walimizirik yemane, keya nawiligu purikki ngizirik walimizirik yemane panu, yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Pulaga Yisugu puwiliyegi ngago saweliwei nararau pelik kozak yeiya, Anotogo pigi ngaimekki ngai yolu pura yombu yawe puguleige wilek pandi wit wazonoyeng wezamelabok kelik. ");
INSERT INTO big_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Logo wok nakke kusage yongkambanu mamok iwek kola koyigeya yawe puleigi mangobekyegi kumbak mizibek yawe puleige kayima logo pandi wit wilek wazono ulogo wezamelayengki tepekke ibek wilekyendau wezamela logo pi kambela. ");
INSERT INTO big_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yombanu yaweleigi mangobekyegi yawe miziwili yaweleigi ngai koyima logo kalike pandi wityengki pengyeng pundawekke puwiligu ibekyendau pandi wityengke tepekke lewagela wizilege pakela. ");
INSERT INTO big_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Togo yaweleigi mangobekyegi yawe miziwili piyegi kanda pelik nguk meiya, Peba, pandi wit wilek wazonoyeng nugu yawe nuguleige wezamela kapura ibek peyeng talaga lewayeng, meiya. ");
INSERT INTO big_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Pugu pelik kanga yeiya, Yombu neyegi kumbak mizibokko pelik miza, yeiya. Puwiligu piyegi pelik nguk meiya, Nugu kelirik tonugu yawege kanda ibek piyeng puliya logo wezameliweki keli ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kapura pugu puwiliyegi pelik kanga yeiya, A’a’. Inugu ibek piyeng menalege puliya wiyiraige pandi wit nayendau puliya nera, mabilik. ");
INSERT INTO big_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pandi wit piyeng keya ibek piyeng mabiyeng menalege lewagela yali pani. Kalike pandi wit piyeng ngelagirage puwekke nogo neyegi yawe miziwiliyegi pelik kozak yeiyagine, Were ibek piyeng puliya logo nayeng koli miza logo panga yezizikke wezameli kapura pandi wit piyeng menalege wawiya logo i nogomakke orowei wiriyizo, yeiyagine, yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Pulaga Yisugu puwiliyegi ngago saweliwei nararau pelik kozak yeiya, Anotogo pigi ngaimekki ngai yolu pura yengelei wilek Mastet mei nak kelik. Yengelei wilek Mastet meiyeng wilek nayeng kelik yemane ono, yengelei Mastet puleigi wilekyeng songono panu kapura yombanu nakko Mastet nak ngeriya puwekkerik kalike purik yengelei nayengka yemane panu lewagi. Keya puleigi meleyeng yemane panu logo winakwiligu kanda yengelei meleyengke igazi mizagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pulaga Yisugu puwiliyegi ngago saweliwei nararau pelik kozak yeiya, Anotogi ngaimek ngeragi Yis meirik kelik. Yongok namologo yis songono narik weiya logo kaimi yemane nakke iwing palewa narik kiling ngelaming kelemiya purik kalike iwing palewa purik maburik weik yisrikku mizagewiyege wilak wara wizei penangai, yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ngago ngizi Anotogo pigi ngaimekki ngai yolu puragiyeng mabiyeng Yisugu yongkambanuwiliyegi ngago saweliweiyengko kozak yeiya. Pugu puwiliyegi kazing namekkerau kozak yeiya ono, pugu puwiliyegi ngago saweliweiyengko keke kozak yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Togo yombanu Anotoyaga ngagora weiya logo kozak kaibokko koka walaka pelik kaiyara weik ngizi lewagela, Nogo puwiliyegi ngagora yani purik nogo puwiliyegi ngago saweliweiyengko kozak yeiyagi, Kazing pilikmekke nogo puwiliyegi ngago koka solo ngabelakpek keremiza pulaga kang kayimeige yokopekke iwaka ono piyeng kozak yeiyagi. Ngago pura koka walaka lende mizara kapura Yisugu yongkambanuwiliyegi ngago saweliweiyeng kozak yeiya puwekke pura weik ngizi panu lewagela. ");
INSERT INTO big_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pulaga Yisu yongkambanu pulogo wawere ulawili wezaya logo panga ige la. Yombanu Yisugu waligeleyiwiligu piyegi kanda pelik meiya, Ngago saweliwei ibek keya pandi wit piyeng yaweleige menalege lewagela puragi yaka nugu kai puragi solorik teniyegi kozak yei, meiya. ");
INSERT INTO big_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tegi Yisugu puwiliyegi pelik yeiya to mela, Yombu yawe puguleige pandi wit wilek wazonoyeng wezamela kaibok ne makngeze, yombanu paka ngalega kayimabekyegi kai yagenda. ");
INSERT INTO big_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Keya yawelei kai purik ngabelakpek mabok, keya peng pundayeng kai purik yongkambanu Anotogi ngaimekki kiliya puwiliyegi kai yagenda. Ibekyengki kai purik yongkambanu korowalibekki ngaimekkiwiliyegi kai yagenda. ");
INSERT INTO big_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Keya yombu yaweleigi mangobekyegi kumbak mizibokko ibek wilekyeng wezamela kai purik korowalibek Sadang ngezebekyegi kai yagenda. Pandi wit piyeng ngelagira kai pura ngabelakpek mabokki wok kalike panubekki kai yagenda keya pandi wit piyeng ngelagiwili kai puwili Anotogi angelawiliyegi kai yagenda. ");
INSERT INTO big_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Togo kazing ibek piyeng menalege wawiya logo panga yezizikke waliya wazamiyagi pumok kazing mabilik wangki wok kalike panubekke lewagelagimek. ");
INSERT INTO big_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Wokpokko ne yombanu paka ngalega kayimabokko negi angelawili wezayelagi logo puwili ngabelak mabiyengki kangki logo ngabelakpekke yombanu nawili kaile mizibene keleyi puwili mabuwili izagi keya yombanu kaile miziwili mabuwili izagi. ");
INSERT INTO big_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Pilik miza logo angelawiligu puwili mabuwili pongo yungu yezizik yolu purikke wezayelagi. Pulogo puwili ingkeya kelele yemane panu kisi keya kili puwiligiyeng ngiliti mizagiyagi. ");
INSERT INTO big_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kapura yombanu Anotogo pangka wazaya puwili paka puwiligi mangobekki yereng pugu ngai yolu purage yokmek kelik ngela manageyara koyagi. Tamizeige ini kerangangyeng kilingwili mabura ngago peragi waberek kerewiyizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Pulaga Yisugu ngago nararau puwiliyegi pelik yeiya, Anotogo pigi ngaimekki ngai yolu pura king lopong king keremungke wakiya nalei kelik. King lopong pulei koka were nakko ngabelakpekke kawik yokora wiya logo kingyengki mangobek ibeng wiziga nakkorau lopong puleigi iwaka ono. Wok nakke yombu nakko ngabelak king loponglei yokora wiyabekke yawe miziweki yokoriraige king lopong pulei yolok ngela. Nguk namizi pugu ngereke liwik momane meiya wiya. Pi wilikwilikmokko kola logo pelik kumula, Nogo watabi nogoyeng mabiyeng nawiligu weibene yanagi logo ngabelakpekki mangobekyegi kanda ngabelakpek weiweki meiyagi. Pi pilik miza logo king lopong king keremungke wakiya pulei weik pi ngezebekkilei. ");
INSERT INTO big_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Mabilik, Anotogo pigi ngaimekki ngai yolu pura saliyek yemane yombiyangai panu narik kelik. ");
INSERT INTO big_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Logo yombanu nak saliyek purikki pakelawekke pi yagolok miza, legi pi watabi puguyeng mabiyeng saliyektikki mangobekyegi mana logo saliyek purik weiweki. Pi pilik mizarikku saliyek yemane yombiyangai panurik weik pi ngezebekki. ");
INSERT INTO big_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mabilik, Anotogo pigi ngaimekki ngai yolu pura kik kawek panga kai tangelabekke wezamela logo watabisi nalangai nalangaiwili koli pugik kelik. ");
INSERT INTO big_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Logo kik kawekkik wilak purik yombanu yawe miziwiligu kikkik ulumi wageliwei panga laluge kanda mogosa logo watawili sanga mizi, yombiyangaiwili panga kaimirage wawiyi kapura nagi langai ono puwili yo wezameli. ");
INSERT INTO big_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Logo wangki wok kalike panubekke purik mabilik panu mizagi. Wokpokko negi angelawili kanda yongkambanuwili sanga mizagi, yongkambanu kazing kaile mizimekke yoluwili yongkambanu kazing pangka mizimekke yoluwiliyaga izagi logo ");
INSERT INTO big_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","puwili pongo yungu yezizik yolu purikke wezayelagi. Pulogo puwili ingkeya kelele yemane panu kisi keya kili puwiligiyeng ngiliti mizagiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pulaga Yisugu puwiliyegi pelik nguk yeiya, Ini ngago saweliwei peyeng mabiyeng iwaka ma yeik, yeiya logo puwiligu piyegi pelik kanga meiya to mela, Ei, meiya. ");
INSERT INTO big_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tegi pugu pelik yeiya, Ei, ini iwaka keya yombanu ulogo ngago Mosegi loyengkiragi iwakawili logo weik ngago kazing Anotogi ngaimekki kiliyimekkiragirau iwaka puwili yombanu i namakki mangobek kelik. Pi yeke ige kanda watabi were yombiyangaiyengka wei keya wik yombiyangaiyengka wei miza logo yongkambanuwiliyegi waligeleyiweki welagela lewa. Kazing mabilikmekke inugu yongkambanuwiliyegi Anotogi wazono werera keya negi wazono wiktagi kozak yei kambelizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pulaga Yisugu ngago saweliwei piyeng kozak yeiya logo weik yeikwekke pi yereng pura wiya logo panga yereng ngezebekkira Nasarete meirage kandobela. ");
INSERT INTO big_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","56","Kanda pulogo pi Yudawiligi i walek songonomakke yeke ige la logo yongkambanuwiliyegi Anotogi ngagora waligeleya. Logo yongkambanu ngago pugu waligeleyiragi kerewiyawili Yisugi kangkabek yemane panu purikki lelengkira logo nakko nakyegi pelik meiya yongomo miza, Teni pobokyegi iwaka. Pi yawe iyeng ngizira mizibek. Pigi panumelegi yeikta Maliya. Keya pigi mandik sakwili Jems keya Yosisi keya Saimon keya Yuras puwili teni iwaka. Keya pigi kolomandik sakwili pelege yoluwili. Pi yombu yeikpek kapura ngago pugu kai piyeng pi talaga weiya? Keya pigi kangkabok takko mana? Keya takyaga kozanda weiya logo Anotogo keke mizi piyeng mizibene mana, kela. ");
INSERT INTO big_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Puwili pilik kumula logo puwiligu piyegi kezanga mana. Togo Yisugu puwiliyegi pelik yeiya, Yombanu Anotogi ngagora kozak kaibok yongkambanu ngabelak kalogomokpekkewiliyegirik yeikta kiling keya puwiligu ngago pugu kai piyengki kerewiya kapura ngabelak ngezebekkibekkewiliyegirik yeiktarau ono keya ngezebekyaga puwili pugu ngago kai piyengkirau kerewiyagi ono logo purik wameik panu, yeiya. ");
INSERT INTO big_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Togo yongkambanu Nasarete yerengke koya puwiligu Yisuyegi ngizi panu kumuli ono kopong pulogo pugu Anotogo keke miziyeng keremungke miza ono. ");
INSERT INTO big_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Togo watabi Yisugu mizi piyengki wiyeke Yisugi yeikta weik yemane sawiya. Keya King Ngai Elodo panga Kalili ngabelakpekki ngaibek, Yisugu watabi pilik mizi piyengki kerewiyawekkerik pi kazi miza logo ");
INSERT INTO big_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","pugu yombanu piyegi yawe miziwiliyegi pelik yeiya, Pok ngizi Yowan kaimelibek yombu nogo koka kalokpek ngela logo ibembok ngereke ibendaga yangalekta wik yolu, legi kozang purago mizagewiyege mele puguzikku watabi kozang piyeng mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Elodogo Yowan kai melibekki kalokpek ngelaragi ngagora pelik, Ulogo Yowan kaimelibek ngoluk wik yoluwekke pi Elodoyegi kambela logo ngalik kozangka pelik meiya, Kazing kaile nugu nigi sak ngoluk wik yolubekki yongokpumele Elodiya meimele weiya yolu pumok pangka ono, meiya, legi Elodiya Yowanyegi sisik panu logo purikki wiyeke Elodogo yombu nawili wezayela logo Yowan kebangkela logo wigira wazamiya. ");
INSERT INTO big_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Elodogo pi ulagi keli kapura pi Yudawiliyegi kazi miza, purik puwiligu kumularik Yowan Anotoyaga ngagora weiya logo kozak kai, poropek meibek purikki kumularikki wiyeke, legi Elodo Yowan ulagirikki kazi miza. ");
INSERT INTO big_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pulaga wok Elodo wazamiyabekke pugu ngeragi yemane miza niweki nara miza logo puwili ngeragi nageya tagogei pura Elodiyagi yango kailemekkimele yombanu wawere ulamekki wirege ngezemele yongolo yombuwiligu kelagi langaimekke uli yarolege. Elodo piyegi pakela logo wilik yemane panu miza. ");
INSERT INTO big_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Pilik miza logo Elodogo kolomandikmeleyegi pelik meiya, Watabi nugu keli piyeng nogo nanagi. Nogo niyegi Anotogi wirege wameik panu nei, nugu neyegi nguk nei piyeng nogo ni nanagi, meiya. ");
INSERT INTO big_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Togo kolomandikmele pigi panumele kiling ngagozakke miza logo pulaga mangoyegi kanda pelik meiya, Peba, Yowan kaimelibekki kalokpek ngela logo nugu kebira pelengwekke ngalege wiya logo mabelege weik nane, meiya. ");
INSERT INTO big_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pilik kai legi King Ngaibek kuneng panu miza. Kapura ngago pugu yaka yemane ngeragi niweki kayimawili keya Anotogi wiregerau kaiya puragi weraga pi ngago pugu sawiya pura ngelagi ono. ");
INSERT INTO big_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tegi pigi ngai kulengkewiliyaga nak wezamela logo Yowangi kalokpek ngela logo kebira orowei yo wiriyibene. ");
INSERT INTO big_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Logo yombu ngaibek kambela logo i wigirawiligimakke Yowangi kalokpek ngela logo kebira pelengwekke ngalege wiya logo orowei yorik kolomandikmeleyegi mana logo kolomandikmologo kebira pigi panumele Elodiyayegi mana. ");
INSERT INTO big_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pulaga Yowanyegi kiriweiwili ngago puragi kerewiyawekke puwili kambela logo Yowangi yasurik weiya logo mosindage waliya. Logo pulaga puwili kanda Yisuyegi kozak meiya. ");
INSERT INTO big_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yisugu ngago puragi kerewiyawekke pi ngezebek keke leng miziweki kelirikki wiyeke pi wang naleige tameneng meiya logo kai kolamiyabekki lalu pangazuwagawekke kabelak kuyangka ngagoluk yombanu naktau ono, yeiktikke wangleige ngalengale kuna. Kapura yongkambanu kolokngagonowiligu puragi kerewiya logo puwili yereng puwiligiyeng wiya logo piyegi kalike kiriwei ngabelak libu nginda kuna. Togo Yisu kanda pangazuwage pura yombanu ngabelak libuwiligu yaka were lewagela wizilege. ");
INSERT INTO big_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Logo Yisu wangleiga welagela logo yongkambanu wawere ulawiliyegi pakelawekke wilek kang pugubek puwiliyegi yalekmokko kola logo pugu yongkambanuwiligi tepekke kemegeme mizi puwili yombiyangai wazaya. ");
INSERT INTO big_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pilik mizageya tawizeige yokmek kiliyawekke yombu Yisu ngezebokko waligeleyiwili piyegi kanda logo pelik meiya, Pelemeng kabelak ngeragi keya iyeng yeik lemeng keya weik kusa mena nugu puwili ngeragi ngezewiligiyeng yereng mereke piyengka weibene kang wezayele, meiya. ");
INSERT INTO big_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kapura Yisugu puwiliyegi pelik yeiya, Puwili pelemeng wiya logo kangki ono. Inuwa ngezego puwili ngeragi yanagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Puwiligu piyegi pelik kanga meiya to mela, Kapura tonuwago wara yolu peyeng perek marek songono melenazik keya watabisi waliya neyau, meiya. ");
INSERT INTO big_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yisugu puwiliyegi pelik yeiya, Piyeng pelege neyegi orowei koli, yeiya. ");
INSERT INTO big_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Togo Yisugu yongkambanuwili pulogo yengelik wazono mogosagibekke mogosa wazaya. Logo pulaga pugu perek melenazik yaka piyeng wei keya watabisi yaka piyaurau wei miza logo paka ngalege langai pakela wizimowei Anotoyegi ngeragi piyengki wazono meiya. Pilik miza logo pugu perekyeng sikila logo ngezebokko waligeleyiwiliyegi yana logo puwiligu yongkambanuwili mabuwili yani miza. ");
INSERT INTO big_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Puwili mabuwili na logo weik ngekyengko. Pilik miza logo pulaga yombu Yisu ngezebokko waligeleyiwili kik meleyau keya pongo ingenazikka neyau piyengke ngeragi perekyeng keya watabisiyauga wale wazono wiyayeng mereng miza. ");
INSERT INTO big_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yombu pulogo ngeragi nawili sangkelarik tausen melenazik tikinda, yongok keya mandikwilirau sangkela ono. ");
INSERT INTO big_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Togo pulaga Yisugu yombu pi ngezebokko waligeleyiwili wangleige tameneng meibene keleya logo kai kolamiyabekke pangazuwage puwili were yo wezayela. Pi yolu keya yongkambanuwiliyegi kambeli yeiya logo wezayela. ");
INSERT INTO big_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Puwili kuna logo pulaga pi panga lewakpekke waberek miziweki ngezebek kambela. Keya yokmek kiliya logo weik kusawekkerik Yisu ngezebek keke pulogo waberek mizageya wiziya. ");
INSERT INTO big_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Puwekkerik yombu Yisu ngezebokko waligeleyiwili wangleige panga kaibekke libuge ngalengale kunarik yawe yemane miza, purik kebarekpek puwiligu kunagimekke lewa logo yemane uli keya kailauriktau yemane lewa kopong wanglei yo keya to mizi logo puwili yawe yemane miza. ");
INSERT INTO big_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Togo wangkotazi kang ngizige tek purikke Yisu puwiliyegi kaibekke ngalengale lewagela wiriya. ");
INSERT INTO big_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Keya yombu ngezebokko waligeleyiwili pi panga kaibekke ngalengale yawerelege keriyawekke puwili leli ula logo pelik kisa, Pi kerewabek kani, kisa logo kulili miza kopong ngalizi kek kisa mela. ");
INSERT INTO big_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tegi Yisugu puwiliyegi nguk namizi pelik yeiya, Kulili mizi wak. Nogo mena kozang sara koyi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pulaga Pitago piyegi pelik ngago meiya, Yemizibek tamizeige wameik panu ni mabura ne niyegi kaibekke ngalengale wiriyibene koli nei, meiya. ");
INSERT INTO big_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tegi Yisugu koli meiya logo Pita wangleiga welagela weik panga kaibekke ngalengale Yisuyegi kuna. ");
INSERT INTO big_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kapura Pita kebarek yemanebek ulirikki pakelawekke kulili mizagela weik yenge kaibekke kiliya moweki mizi wiziga pugu Yisuyegi ngalizi pelik kek meiya, Yemizibek, ne kaiyaga na nera yaliya wazaniye, meiya. ");
INSERT INTO big_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tegi nguk namizi Yisugu melezik wezamela logo Pita kebangkeliweirik ngalege ulumiya logo piyegi pelik meiya, Ni kangka neyau kumulira nangki? Nogo ni kozanda nanagi langai purikki ngizi panu kumuli nugura songono panu, meiya. ");
INSERT INTO big_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pulaga piyau mabiyau panga wangleige tameneng meiya logo kebarekpek weik yeik sawiya. ");
INSERT INTO big_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Logo pulogo yombanu ngezebokko waligeleyi wangleige mogosa puwili kebiyeng morogulunda koyimowei Yisuyegi ya kumula koya logo pelik meiya, Wameik panu, ni Anotogi Marekpek, meiya. ");
INSERT INTO big_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Puwili weik kai kolamiyabekke pangazuwage ngabelak Kenesare meibekke lewagela. ");
INSERT INTO big_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pulogo yongkambanuwiligu pi Yisu mamiza. Logo ngagora yereng mereke pulogo piyengke wezamela logo yombanuwiligu kemegeme miziwili piyegi iza orowei wiriya. ");
INSERT INTO big_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Piyegi kanda puwiligu Yisuyegi pelik kelegele mei miza, Yombanu kemegemewiligu melewangka nugurikki walemek yeik kuming kelemi purik pangka ma yeik, mei miza. Logo pugu, Ei, yei purik yombanu kemegemewiligu melewangka pugurikki walemek kuming kelemi mizi logo puwili mabuwili weik yombiyangai wazayi miza. ");
INSERT INTO big_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pulaga yombu Yuda kangka yemane Mosegi loyeng mabiyengki waberek panu kiriwei keya kazing puwiligi yelibungang kokawiligu miziyengkirau kozang kiriwei mizi Palisiwili meiwiliyaga nawili kiling Mosegi lo piyengki waligeleyiwiliyaga nawili paka Yirusalem puraga Yisuyegi kayima. Puwiligu kazing kiriwei miziyengka naleweng pelik, meleyeng kaigesa ono purik puwili ngeragi nagi ono. Puwiligu kumularik ngeragi ni puwekke purik kaile miza nelegi purik were meleyeng Yudawiligi kazing mizimekke kaigesi. ");
INSERT INTO big_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Yombanu Yisugu waligeleyiwili kazing piyengki kiriwei mizi ono legi Palisi keya loyengki waligeleyi puwiligu Yisuyegi pelik nguk meiya, Yombanu nugu waligeleyiwili tenigi yelibungang kokawiligi ngago yogongyeng ngeli mizira nangki? Purik puwili were ngeragi nagine meleyeng waberek kaigesi ono, meiya. ");
INSERT INTO big_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tegi Yisugu puwiliyegi pelik yeiya to mela, Keya ini Anotogi ngagorago miziweki kai piyeng ngeli logo ini makngezegi ngago yogongyengki kiriwei miziweki mizi pura nangki? ");
INSERT INTO big_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Purik Anotogi ngagorago miziweki kai piyengka nara pelik, Inigi panu keya mangowiliyegi panga yungke mizizo. Nak pigi panu keya mangoyauyegi kaile kai purik mabura nawiligu pok ula logo ibeng wazamizo, kai. ");
INSERT INTO big_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kapura inugu ngago pura wezamela logo puragi tundikke pelik kisi, Nak pigi panu keya mangoyauyegi watabi nayeng yanagi purik pugu piyauyegi, Watabi nogo yaliyegi sawelagi nobiyeng yali yaniweki miza peyeng nogo Anoto maniweki mizi yei purik pangka, kisi, logo pi panu keya mangoyauyegi panga yungke mizi ono. ");
INSERT INTO big_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Logo kazing pilikmokko ini yawe panu keya mangowiliyegi ngaigira wezameli logo inigi ngago yogong pilik yongkambanuwiliyegi waligeleyi piyengko ini Anotogi ngagorago miziweki kai piyeng ngela meli. ");
INSERT INTO big_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ini yombu kiligang neyau lewawili, koka walaka yombu Anotoyaga ngagora weiya logo kozak kaiyabek Isaya meibokko iniyegi langai Anotogi Kapiya Walektikke pelik lende miza, ");
INSERT INTO big_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Anotogo pelik kai, Yombanu pewiligi kiliyengko yeik nogora yongolok mei kapura wilek kangyeng neyegirau kumula ono. ");
INSERT INTO big_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ngago yogong ngezewiligu keremiza piyeng Anotogi wameiktagi ngizi kumuliweki piyeng kisageya koyimowei waligeleyi kopong puwili yeik nogora yeik ulak yongolok mei, kai. Inirau mabilik kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Togo waleleige Yisugu yongkambanuwili piyegi ngago yeiya logo puwiliyegi pelik yeiya, Kerewiya logo ngago pera weizo. ");
INSERT INTO big_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ini meleyeng waberek kaigesi ono puwekkerik ngeragi nagirikki kazi kapura watabi yombanubekyegi yenge yungke kang piyengko mizagewiyege yombanubek kailegi ono, segeya watabi yombanubekyaga welagela kang piyengko mizagewiyege yombanubek kailegi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pulaga kalike yombu Yisu ngezebokko waligeleyiwiligu Yisuyegi kanda pelik meiya, Yombanu Palisiwili meiwili ngago nugu kai piyengki kerewiya logo kiyebuk mizi purikki ni iwaka ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kapura Yisugu puwiliyegi pelik yeiya to mela, Puwiliyegirik puwili watabi negi Mango paka ngalege yolubokko ngeriya ono, ngezeyeng yeik lewagela piyeng kelik logo kalike pugu puliliyeng kiling puliyagi mena koyi pani. ");
INSERT INTO big_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Puwili yombanu yemane wire kusa wizigeya yombanu wire kusa mabilikwili iza orowei keleyi puwili kelikwili keya tamizeige yombu wire kusa neyau nakko nak miza orowei kang purik mabiyau kawiye walagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pulaga Pitago Yisuyegi pelik meiya, Ngago saweliwei nugu yaka were kaiya puragi solorik teniyegi kozak yei, meiya. ");
INSERT INTO big_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tegi Yisugu puwiliyegi pelik yeiya, Igali, inuwarau Palisiwili kelik kangkayeng waliya? ");
INSERT INTO big_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ma inuwa ngoluk iwaka ono? Yombanu nakko watabi na logo korage yungke kiliya kang piyeng ya imakke yangela meli. ");
INSERT INTO big_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kapura ngago yenge yombanubekki wilek kambekka yorik kiliraga lewagela piyengko mizagewiyege yombanubek kaile mizi. ");
INSERT INTO big_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Purik watabi yenge yombanubekki wilek kangyengka lewagela wali piyeng peyeng, kaile kumuliyeng, ma kazing yombanu ula logo ibeng miziyeng, ma kazing yongkambu weiya puwili namelegi kerekpu onobek ma nakki yongokpu onomele kiling iwek koliyeng, ma kazing yongkambu weiya ono puwili namele ma nak kiling iwek koliyeng, ma kazing yombanu nakki watabiyeng purik ngowei miziyeng, ma kazing ngaigu kisiyeng, ma kazing Anotoyegi ma nazuwagawiliyegi langai kaile kisimek. ");
INSERT INTO big_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kazing pilikyeng mizi piyengko yombanubek ngezebek kaile kelemi, kapura kazing meleyeng waberek kaigesi ono wizigeya ngeragiyeng ni, Palisiwiligu iniyegi pilik miziweki kisi piyengko yombanubek kaile kelemi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pulaga Yisu kiling yombanu ngezebokko waligeleyiwili yereng pura wiya logo panga yereng Taya keya Sairong mei Yuda onowili yolu piyaugi ngabelakpokko kambela. ");
INSERT INTO big_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Puwili pangalege kanda pura yongok namele Yisuyegi wiriya. Pi Kanang yongok pelege Taya keya Sairong lemengke yolumele, pi Yuda onomele. Pi wiriya logo pugu piyegi pelik ingkelemiya, Yemizibek, ni King Ngai Tawitigi yeligagangmekkabek, Anotogo Yudawiliyegi wezamelabek, ni neyegi yalek mize. Negi yangomele kerewa nak yenge pigi yaga kiliya kopong pi wazono yolu ono, meiya. ");
INSERT INTO big_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kapura Yisugu piyegi ngago nara meiya ono. Yeik. Yombanu Yisu ngezebokko waligeleyiwiligu Yisuyegi pelik meiya, Yongok pemele teniyegi kiriwei kai lewa keya ngago piyeng kaiya meli mena kazi kune meimo, meiya. ");
INSERT INTO big_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Puwiligu pilik meiya logo Yisugu puwiliyegi pelik kanga yeiya to mela, Anotogo ne yongkambanu Isileili liyeng memengwili kelik ngai puwiligibek wezamiya logo piyaga koweige koyimi puwiliyegi keke wezanela, yeiya. ");
INSERT INTO big_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pulaga yongok yakamolo kanda Yisugi ingewerege ingeyau laliya logo pelik meiya, Yemizibek, nogo yeik nugura yongolok meiweki. Ni neyegi sawele keya negi yangomele yombiyangai kelemiye, meiya. ");
INSERT INTO big_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kapura yongokmolo Yuda onomele keya Yudawiligu Yuda onowili keriwili mei purik Yisugu iwaka legi pugu yongokmeleyegi ngago pera pelik meiya, Ne koloyakamandik songonowiligi ngeragiyeng weiya logo keriwiliyegi yani purik pangka ono kani, meiya. ");
INSERT INTO big_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Logo yongokmologo pelik kanga meiya, Yemizibek, ngago nugura ngizi panu, kapura keriwili ngeragi wale puwiligi mangowiliyaga ngabelakke wali piyeng weiya logo niwiligu, meiya. ");
INSERT INTO big_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pi pilik mei legi Yisugu kanga pelik meiya, Ni yongok neyegi ngizi panu kumulirikku kolamele. Watabi nugu keli piyeng niyegi ngizi panu mizagi. Logo nguk namizi mabuwekke pigi yangomele yombiyangai sa logo weik wazono yolu. ");
INSERT INTO big_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yisu ngabelak Taya keya Sairong meiyau wiya logo kai kolamiya Kalili meibekke saweliwei kambela. Pi lewak songono nakke ngalege songono nangezi tabereta yabela logo kanda mogosa wiziya. ");
INSERT INTO big_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yongkambanu kolokngagonowiligu yongkambanu kemegemewili iza orowei Yisuyegi wiriya. Puwiligu yombanu inge korowali mizawili keya yombanu wireyeng kusawili keya yombanu inge koru mizawili keya yombanu kiligawere waliyawili keya yombanu kemegeme nalangai nalangaiyengko mizi pilik puwili Yisuyegi iza orowei kanda Yisugi ingezikke mereke pulogo wezaya logo pugu yombiyangai wazaya. ");
INSERT INTO big_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Weik yombanu inge korowali mizawili yombiyangai yongomo mizi, keya yombanu kiligawere waliyawili weik ngago kisi keya yombanu inge koru mizawili weik ngereke koru ono, yombiyangai yongomo mizi, keya yombanu wireyeng kusawili weik ngereke wireyeng ngaiwila logo pakeli mizirikki yongkambanuwiligu pakelawekke puwili lelengkira. Togo puwiligu pakela logo Anoto yombanu Yuda Isileiliwili meiwiligibekki yeikta yongolok meiya. ");
INSERT INTO big_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pulaga Yisugu pugu waligeleyiwili piyegi mereke wiriyiweki ngago yeiya logo puwili piyegi kanda logo pugu puwiliyegi pelik yeiya, Ne yongkambanu pewiliyegi yalek keli. Puwili weik ne kiling wok neyauganak koya kopong puwiligi ngeragi nagiyeng weik yeik. Keya puwili yereng puwiligiyengke kangweki tagoneige purik puwili yagasimokko ulu walagi logo puwili ngeragi nayeng yani ono, yeik kang wezayeli purikki ne kiyebuk keli, yeiya. ");
INSERT INTO big_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Pilik kai legi yombu ngezebokko waligeleyiwiligu piyegi pelik nguk meiya, Kabelak kurung yeik panu pewekke takko ngeragi nayeng talaga weiya logo yongkambanu pewili pangka yanagi, meiya. ");
INSERT INTO big_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tegi Yisugu puwiliyegi pelik nguk yeiya, Inuwago perek talik talik wara, yeiya logo puwiligu pelik meiya to mela, Perek melenazik keya nazikka neyau, keya watabisi songono keremungke ono waliya nawilirau, meiya. ");
INSERT INTO big_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pulaga Yisugu yongkambanuwili ngabelakke mogosibene yeiya. ");
INSERT INTO big_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yongkambanuwili weik mogosa logo pulaga pugu perek melenazik keya nazikka neyau piyeng keya watabisi waliyawili weiya logo piyeng Anotoyegi wazono meiya logo sikila logo pugu ngezebokko waligeleyiwili yana logo puwiligu yongkambanuwili yana. ");
INSERT INTO big_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Puwiligu pilik miza logo yongkambanuwili mabuwili na logo weik ngekyengko. Pulaga yombu Yisu ngezebokko waligeleyiwili kik melenazik keya nazikka neyauyengke ngeragi wale wazono wiya piyengka mereng miza. ");
INSERT INTO big_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yombu pulogo ngeragi nawili sangkelarik tausen mangobektau ono tikinda, yongok keya mandikwilirau sangkela ono. ");
INSERT INTO big_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Togo piyeng miza logo Yisugu yongkambanuwili kang wezayela logo pi panga wangleige tameneng meiya logo panga Magarang mei lemengke kambela. ");
INSERT INTO big_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kanda pangalege pura yombanu Palisi mei nawili kiling yombu Mosegi loyengki waligeleyi nawilirau miza logo Yisuyegi kanda logo pi yang kelemiweki puwiligu piyegi pelik nguk meiya, Teniyegi Anotogo keke mizi nara waligeleye logo ni Anotoyaga kayimabek purik teni iwakaweki, meiya. ");
INSERT INTO big_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kapura Yisugu pelik kanga yeiya, Kusarikke ini kilili mizi keya pelewewili ngaiwak yemane panu wiya yolu purik inugu pelik kisi, Wangko wangane yokmek yemanegi kisi. ");
INSERT INTO big_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma inugu kozainung kusabanurik yokmek ngokmorokta wiyi purikki pakeli purik inugu pelik kisi, Koboyau lewa mena, kisi. Ini kiligang neyau lewawili kani, purik ini ngabelakpekki pakeli piyengki iwaka keya paka ngilumbekki pakeli piyengki iwaka kapura inugu kisirik watabi mabek pewekke neyegi langai mizi logo pakeli piyengki iwaka ono kisi. ");
INSERT INTO big_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ini yongkambanu mabek peragewili kaile panu logo Anoto wezamela, yombu nakko pigi yongokpumele wezamela logo yongok namele wei nak kelikwili, purik inugu nogo Anotogo keke mizi nara miziweki nguk nei. A’a’, nogorau Anotogo keke mizi wik naragi ini pakelibene waligeleyagi ono. Kapura koka Anotogo keke mizi nara yombu poropek Yona meibekyegi miza logo mabilikta Anotogo neyegi mizagirikki keke inugu pakelagi, yeiya. Togo Yisu puwili wezaya logo ngezebokko waligeleyiwili kiling ngereke wangleige tameneng meiya logo kai kolamiyabek wala uwei lalu pangazuwagawekke kuna. ");
INSERT INTO big_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yombanu Yisu ngezebokko waligeleyiwili wangleige tameneng meiyawekke puwili perek wik nayeng oroweigirikki keremareke miza. ");
INSERT INTO big_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Puwili wangleigi ngalengale kunimowei Yisugu puwiliyegi pelik yeiya, Yombu Palisiwili meiwiligi ngeragi Yis meirik keya yombu Sadusiwili meiwiligi ngeragi Yis meirikki yaweragi inuwa ngezeyegi kani yomono, yeiya. ");
INSERT INTO big_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Puwili ngago pugu kai puragi iwaka ono kopong puwili ngezewili ngagozakke pelik keli yongomo kela, Teni perekyengki yeik kopong pi yisyengki kai yagenda ma talik, kela. ");
INSERT INTO big_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kapura Yisu puwiligu kozak keli piyengki iwaka logo pi puwiliyegi pelik yeiya, Inuwago kozang nogoragi ngizi panu kumulirik ngoluk songono panu. Perekyengki yeiktikki wiyeke inuwa kozak kelira nangki? ");
INSERT INTO big_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nogo ngeragi inuwago nagi piyeng Anotogo keke mizi purago yanagi purik inuwa iwaka ono ma talik? Keya Anotogo keke mizi nogo miza piyengki inuwa keremareke miza ma talik? Nogo perek melenazik piyengka yombu sangkelarik tausen melenazik tikindawiligi sikila puwekke inuwago wale wiyayeng kik meleyau keya pongo ingenazikka neyauyengke mereng miza purikki keremareke miza ma talik? ");
INSERT INTO big_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma nogo perek melenazik keya nazikka neyau piyengka yombu sangkelarik tausen mangobektau ono tikindawiligi sikila puwekke inuwago wale wiyayeng kik mele nazik keya nazikka neyauyengke mereng miza purikkirau keremareke miza ma talik? ");
INSERT INTO big_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Inuwa yawe Anotogo keke miza piyau pakela kapura nogo inuwayegirau mabilik miza yowiyagi purik pangka purik inuwa ngoluk iwaka ono. Nogo inuwayegi pereksikki kozak yeiya ono, Palisiwili keya Sadusiwiligi ngeragi Yis meirikki yaweragi inuwa ngezauyegi ngai waberek panugirikki yei yagenda, yeiya. ");
INSERT INTO big_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yisugu pilik yeiya logo yombu ngezebokko waligeleyi puwili weik iwaka, purik Yisugu kaiyarik ngeragi yisrik pereksikki meli purikki kaiya ono, Palisiwili keya Sadusiwiligi kazing kokowa puwiligu waligeleyi piyeng ngeragi yisrik kelik, purik perek keremiziwekkerik yis songono narik palewarik kiling ngelaming wiya puwekke purik perek yemane nazik lewagelagi logo mabilik kazing puwiligu kaile mizi pumok inigi tepekke songono wiriya logo kazing pumok inigi tepekke yemane lewagela sa nelegi waberek panu. ");
INSERT INTO big_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Wok nakke Yisu yombu pi ngezebokko waligeleyiwili kiling ngabelak Sisariya Pilipai meibek neing kunimowei Yisu ngezebokko waligeleyiwiliyegi pelik nguk yeiya, Yongkambanuwiligu ne yombanu paka ngalega kayimabekyegi langai kozak kisirik puwiligu ne tak kisi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Logo yombu ngezebokko waligeleyiwiligu pelik meiya to mela, Yongkambanu nawiligu kisirik ni Yowan kaimelabek ibendaga yangalekta yo kisi, kapura nawiligu kisirik ni Ilaya Anotogo paka ngalege korikwek kiling wik miza orowei kambelabok ngereke yo kisi, keya nawiligu kisirik ni koka walaka yombu Anotoyaga ngagora weiya logo kozak kisawiliyaga nak Seremaya meibek ngereke wik yo kayima ma Anotoyaga ngagora weiya logo kozak kaiya nak kisi, meiya. ");
INSERT INTO big_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Togo Yisugu puwiliyegi pelik yeiya, Nawiligu pilik kumuli kapura inuwago sawiyarik ne tak, yeiya. ");
INSERT INTO big_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tegi Simong Pitago pelik meiya to mela, Ni Kilisibek, Anoto wik yolubekki Marekpek, pugu yawe pigi teni Yudawili yaliya wazayagi pura miziweki sawiyabek, meiya. ");
INSERT INTO big_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Togo Yisugu piyegi pelik meiya to mela, Simong, Yonagi marekpek, Anotogo niyegi wazono miza. Purik ngago ne Anotogi Marekpek purikki nugu ngolukku kai pura yombanu ngabelakke pelaga nakko niyegi kawela wiya ono, segeya negi Mango paka ngalege yolubokko ngago ngizi pura niyegi kawela wiya kani. ");
INSERT INTO big_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nugu kairik ne Kilisibek keya nogo neirik ni Pita, logo purikku kai purik kimbek kai yagenda. Keya ngago ngizi nugu ngolukku kaiya pura king imak kebangkela yolu piyeng kelik. I kingyengki ngalege ngiza pumak pilik kozang wizagomagi, kazing mabilikmekke yombanu ngago ngizi ni Kilisibek, Mesiya Anotogo puwili yaliya wazayiweki sawiyabek kai puragi ngizi panu kumuli puwili ngai nogomekke kiliya logo yeikta I Walekmak mei logo puwili kozang koyimagi. Watabi kozang nayeng ma Sadang ma ibenda ngezeragi kozandagorau yongkambanu neyegi ngizi panu kumuli logo I Walek nogomak mei puwili neneng ngelagi ono. ");
INSERT INTO big_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Keya Pita, nogo ni kazing negi ngaimekki kiliya kunagimekki ngai wazani yagenda. Kazing pumok ki nak kelik. Logo nugu kandik kibokko waliyi keya tiyi mizi mabilik nugu yongkambanuwiliyegi kazing negi ngaimekki kiliya kunagimekki waligeleya purago nugu yombanu neyegi ngizi panu kumuliwiliyegi negi ngaimekki kandik tiyi keya yombanu neyegi ngizi panu kumuli onowiliyegi negi ngaimekki kandik waliyi mizagi. Keya yombanu ngabelakkewiligu kazing mizi nugu pangka kai piyeng Anoto paka ngalege yolubokkorau mabilik pangka kaiyagi keya yombanu ngabelakkewiligu kazing mizi nugu pangka ono kai piyeng Anoto paka ngalege yolubokkorau mabilik pangka ono kaiyagi, meiya. ");
INSERT INTO big_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Togo Yisugu yombanu ngezebokko waligeleyi puwiliyegi pi Kilisibek Mesiya Anotogo yawe pugura miziweki sawiyabek purikki yongkambanu nawiliyegirau kozak yeiya nelegi kozang yeiya. ");
INSERT INTO big_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pilik yeiya logo pulagawekkerik Yisugu yombanu ngezebokko waligeleyiwiliyegi kuneng kalike piyegi lewagelagi piyengki weik pelik kozak yeiya, Kalike purik ne paka Yirusalem yerengke kangki kani. Logo kanda pakalege purik Yudawiligi yemanewili keya yombu Anotoyegi kolak miziwiligi ngaiwili keya yombu Mosegi loyengki waligeleyiwiligu ne ngangang yemane panu keleniyagi logo puwiligu ne nelagi logo ne ibeng wizigeya kawiktikke waliyagi, kapura wok neyau wiziya logo wok kalikebekke ngereke wik yangalektagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kapura Pita kiyebuk legi pugu Yisu songono nangezi miza orowei kuna logo piyegi pelik ngalik meiya, Yemizibek, ni pilik kai wak, pilik pura niyegi lewagelagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kapura Yisu kowita to mela logo Pitayegi pelik ngalik meiya, Nugu Sadangki kumulira kaiyarikki wiyeke mena neyaga kazi koweige kune, purik nugu kumulara kazing Anotogo kumulimek kelik ono, nugu kumulara kazing yongkambanuwiligu kumulimek kelik kumula mena kune, meiya. ");
INSERT INTO big_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pulaga Yisugu yombu pi ngezebokko waligeleyiwiliyegi pelik yeiya, Tamizeige ni yombanu nak neyegi sawelagi keli mabura ni keli korik ni makngezegiwekkiragi kezanga mane keya ngago nogoragi kerewiye keya negi wiyeke ibengkirikki kazi ono wizimowei ne kiling kazing nogo kangmokko kune. ");
INSERT INTO big_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Purik yombanu ngezebekki kelira keya ngezebekki wik yolugira kozang kebangkelibok pi Anotogi wiregerik ibeng logo paka ngalege wik wizagomagi ono, kapura yombanu neyegi ngizi panu kumula logo wilek kang pugubek neyegi tiya manibok pi kemenak ibengki ono, paka ngalege wik wizagomagi. ");
INSERT INTO big_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Keya tamizeige yombanu nak yawe king keya watabiyeng weiyagi naragi wilek kang tiya mana logo pi watabi ngabelakpekkiyeng mabiyengko kola logo pi ibeng purik pi pongo Anoto yolu onolege kaile wizagomagi logo puwekke watabi pigi piyengko piyegi sawelagi ma yeik? Yeikki kani. Piyengko piyegi sawelagi ono. Ma pi watabi nayengki ngane kazing Anotogimek weiyagi ono. ");
INSERT INTO big_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Purik ne yombanu paka ngalega kayimabek negi angelawili kiling ngaiwak Pebagirikke ngereke yogi. Puwekke purik nogo yongkambanu mamok nak nak watabi pugu miza piyengki wiyeke kangayeng mana to melagi. ");
INSERT INTO big_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kerewiyi. Nogo inuwayegi wameik panu yei, yombanu pelege yolu pewiliyaga nawili ngoluk mabilik wik koyigeya ne yombanu paka ngalega kayimabokko negi ngaimekki wilek kangyengki ngai keya puwiligi King Ngaibektikki puwili pakelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wok melenazik keya nazikka nak miza logo Yisugu Pita keya Jems keya pigi sakpek Yowan iza logo pi kiling paka lewak ngalege panu nakka kambela. ");
INSERT INTO big_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kanda pakalege puwili Yisuyegi pakela tagogei pura Yisugi korikwek nalik si lewa, purik wiregawere pugura yokmek kelik ngela mani keya melewangka keya pugu wakiya piyendau wilangka ngaiwaktikku kola legi. ");
INSERT INTO big_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pilik miza logo nguk namizi puwiligu yombu yemane koka walaka koyimayau Ilaya keya Mose paka ngalega lewagela logo kanda Yisu kiling ngagozakke mizirikki pakela. ");
INSERT INTO big_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pumorok pakela logo Pita lebukka ngane mizagela nguk namizi Yisuyegi pelik meiya, Yemizibek, teni pelege yolu purik pangka panu kani. Tamizeige nugu keli mabura tonugu i menang yolugi neyauganamak ngiziweki nigi namak keya Mosegi namak keya Ilayagi namak, meiya. ");
INSERT INTO big_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pi ngoluk pilik meiyageya tawizeige pura kozainung simbele langiya narik kanda yokmek waliya logo kili narago paka kozainumbekka pelik kai, Pok negi Marek nogo keli panubek. Ne piyegi wilik kani pugu kai piyengki kerewiya logo kiriwei mizizo, kai. ");
INSERT INTO big_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yombu Yisugu waligeleyiwiligu kiliragi kerewiyawekke puwili kulili miza kopong puwili ngabelakpekke wala logo wiregawereyeng liwik momanenda koya. ");
INSERT INTO big_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yisugu pakelawekke puwiliyegi kanda kuming keleya logo pelik yeiya, Kulili mizi wak. Yangalek mei, yeiya. ");
INSERT INTO big_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tegi Pita kiling pigi kewengkeyau yangalek meiya logo puwiligu pakela to melawekkerik naktau Yisu kiling ono, yeik, pi ngezebek keke wizilege. ");
INSERT INTO big_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pulaga Yisu keya pugu waligeleyi neyauganak puwili lewakpekka yerageyamowei pugu puwiliyegi kozang pelik yeiya, Inuwago yaka pakela piyengki inuwago nakyegi kozak mei nagani, wiziya kalike ne yombanu paka ngalega kayimabek ibeng sa logo yangalekta puwekke inuwago yongkambanuwiliyegi kozak yei nangane, yeiya. ");
INSERT INTO big_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Logo Yisugu waligeleyiwiligu piyegi pelik nguk meiya, Mosegi loyengki waligeleyiwiligu yombanu Anotogo teni yaliya wazayiweki sawiyabek lewagine yombu Ilaya kelik nak were lewagi kani, kisara nangki, meiya. ");
INSERT INTO big_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tegi Yisugu puwiliyegi pelik yeiya to mela, Ei, Kapiya Walektikke yungke pelik kai, Yombanu Ilaya kelik nak lewagi kani logo kazing Anotogo sawiyabokki lewagimek pangka pangka miziweki, kai. ");
INSERT INTO big_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kapura nogo inuwayegi pera kozak yei, pok ulogo kayima kapura yongkambanuwiligu piyegi mabok mane miza ono, legi puwiligu keli kaile ngezewiligiragi kiriwei miza logo puwiligu pi ula logo ibeng. Kazing piyegi kelemiya mabilikmekke ne yombanu paka ngalega kayimabektau ngangandik yemane panu wagelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Togo Yisugu Yowan kaimelibekyegi langai kozak yei yagenda mamiza purik pugu waligeleyiwiligu weik iwaka. ");
INSERT INTO big_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pulaga puwili lewakpekka yerageya logo puwili yongkambanu kolokngagono wawere ulawiliyegi wiriyawekkerik yombu nak Yisuyegi kanda Yisugi ingewerege ingegere puguyau laliya logo pelik meiya, ");
INSERT INTO big_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Yemizibek, negi marekpek lelewe mizibek logo kerewabek yenge pigi yungke kiliya kopong pi wazono yolu ono, pi ngangang wageli wilibek, purik kang kolokngagono pi yezizikke kawiye wali keya panga kailingke kawiye walimizi. Tegi piyegi yalek miza logo yombiyangai wazamiye. ");
INSERT INTO big_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ulogo ne mandikpek yombu nugu waligeleyi puwiliyegi miza orowei kuna logo puwiligu yombiyangai wazamiyagi nobiyeng miza kapura puwili pangka ono, meiya. ");
INSERT INTO big_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Pilik kai legi Yisugu pulogo koyawiliyegi pelik yeiya to mela, Oyo, ini yongkambanu mabek pewekkewili inugu kumuliyeng kokowa mizi keya ne mabiyeng pangka mizagi langaibek purikki ini ngizi kumuli onowili kani, legi ne iniyegi kiyebuk sende. Tek taliktikke ne ini kiling yoluweki keya kuneng inuguyeng wageliweki? Pilik yeiya logo mandikpekki mangobekyegi pelik meiya, Nigi marekpek neyegi pelege miza orowei koli, meiya. ");
INSERT INTO big_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Pilik mei legi mangogo mandikpek Yisuyegi miza orowei wiriya. Kanda Yisugu kerewabekyegi ngalik meiya logo welagela kuna logo mandikpek mabuwekka mabulogo weik yombiyangai sa. ");
INSERT INTO big_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Togo waleleige Yisu pugu waligeleyiwili kiling kekewekke puwiligu Yisuyegi pelik meiya, Tonuwago kerewabek mandikpekyaga welagela wezamelagi langai ono purik nangki, meiya. ");
INSERT INTO big_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tegi Yisugu puwiliyegi pelik yeiya to mela, Nogo inuwa kozanda yana puragi ngizi panu kumuli ono kopong inuwa pangka ono. Kapura kerewiyi, yengelei Mastetlei mei puleigi kumuli. Yengelei Mastet puleigi wireyeng songono panu kapura ngeriyi puwekkerik nguk namizi lewa logo yengelei yemane keremizagi. Tegi inuwago kozang nogoragi ngizi kumuli purago yengelei Mastet puleigi wireyengka nak kelik lewibene kelemi. Purik tamizeige inuwago neyegi ngizi kumuli pura Mastet wilekpek kelik songono pilik kesak watabi nalangai piyeng mabiyeng inuwago mizagi langai, keya yawe kozang inuwago lewak pobokki pobilik meiyagi pelik piyendau mizagi, Somiyora koli logo panga pulogo kune, meiyagi logo lewakpok nugu kaiyaragi kiriwei mizi penanging kani. ");
INSERT INTO big_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kapura inuwago kerewa nak yombanu nakyaga welagela wezamelagirik kazing inuwago wilek kang mabiyeng Anotoyegi waberek mizagirikki tiya maniweki ngeragi ni ono mizimokko keke watabi kaile pilik piyeng welagela wezamelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wok nakke puwili ngoluk ngabelak Kalili meibekke koyigeyawekke Yisugu pugu waligeleyiwiliyegi pelik yeiya, Ne yombanu paka ngalega kayimabek yombu ne nelagiwiligi meleyengke niza yaniweki mereke kani. ");
INSERT INTO big_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pilik miza logo puwiligu ne nela logo ne ibengki kapura wok neyau wiziya logo wok kalikebekke ngereke wik yangalektagi, yeiya. Pilik yeiya logo yombu Yisu ngezebokko waligeleyi puwili wilek kuneng yemane miza. ");
INSERT INTO big_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wok nakke Yisu kiling pugu waligeleyiwili kambela logo puwili weik yereng Kapaneyam meiraga lewagela. Kanda pulogo yombu Anotogi i walek yemanemakki king takis weiwili Pitayegi kanda logo pelik nguk meiya, Kiriwaga nugubektau i walek yemanemakki king takis wiyi mizibek ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tegi Pitago pelik meiya to mela, Ei, pi wiyi mizibek, meiya kapura pugu Yisuyegi kalike piliktikki nguk meiyagine miza. Togo Pita panga i puwili yolumakke kiliya kuna logo Yisu Pitago kumulira iwaka legi pugu were piyegi pelik nguk meiya, Simong, nugu kumularik talik? Yombu King Ngai ngabelakkewiligu takyaga king takis yawe puwiligiyeng miziwekiyeng wei mizi? Puwiligi marekngangwiliyaga wei ma nazuwagawiliyaga wei mizi, meiya. ");
INSERT INTO big_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tegi Pitago pelik kanga meiya to mela, Puwiligu nazuwagawiliyaga wei, meiya. Togo Yisugu pelik meiya, Ei, wameik. Tegi King Ngaiwiligi marekngangwili king takis wiyi ono miziwili wiziga ne Anotogi Marekpek legi ne Anotogi i walek yemanemakki king takis wiyagi onobek. ");
INSERT INTO big_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kapura towago puwili ngalik kisibene keleyagirik pangka ono. Tegi nugu panga kai kolamiyabekke yongono wigak manimo. Logo wata yongono were nugu kola pumok ulumiya logo kili pugura tiyimo logo king towa mabiyaugi Anotogi i walek yemanemakki king takis wiyagirikki pangka nalik wizilege pakelagi kani logo oroweirik towagi king takis paka i walek yemanemakke wiyimo, meiya. ");
INSERT INTO big_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mabuwekke yombu Yisu ngezebokko waligeleyiwiligu Yisuyegi kanda pelik nguk meiya, Anotogi ngaimekke takki yeikta lewege, meiya. ");
INSERT INTO big_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tegi Yisugu mandik songono yeikta yemane ono nakyegi pelege koli meiya logo pi puwiligi wirege luwe wazamiya. ");
INSERT INTO big_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Logo Yisugu puwiliyegi pelik yeiya, Nogo kai puragi kerewiyizo. Inuwago kumulara kokowa miza wiziga tamizeige inuwa wilek kang inuwagiyeng kowita logo mandik songono kulengke yoluwili kelik ono purik mabura inuwa Anotogi ngai pugu ngai yolumekki kiliya kangki ono. ");
INSERT INTO big_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Keya yombanu ngezebekyegi keremareke miza logo yengezege tung ngabelakka panurik weiyagi purikki mandik songono pobok kelik wilik mizibok Anotogo ngai pugumekki tung mabiyengka yemanerik pi managi. ");
INSERT INTO big_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Keya yombanu nakko neyegi kelirikki weraga yombanu neyegi ngizi panu kumuli pura songono pilik pekyegi sawelibok mabura pi neyegirau saweli yagenda. ");
INSERT INTO big_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kapura yombanu neyegi ngizi panu kumuli logo ngoluk kazing kumbekki lewengke songono puwiliyaga nak kaile miziweki ulumiyabokyegi Anotogo ngangang yemane panura managi. Logo pilikpoktau ono kesak pangka, purik kazing yombanu nakko nak kaile miziweki ulumowei kangmok korowali panumokko. Logo inugu nak kaile mizibene ulumowei kuna nagani waberek panu. ");
INSERT INTO big_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ini yombanu ngabelakpekke yongkambanu nawili kaile miziweki ulumi kambeli puwili ini waberek ngaiweki, purik Anotogo iniyegi ngangang panu keleyagi. Watabi nalangai nalangaiyengko yongkambanuwili kaile miziweki ulumi kapura yombanu puwili kaile miziweki ulumiyabok pi waberek ngaiweki, purik Anotogo piyegi ngangang panu kelemiyagi legi. ");
INSERT INTO big_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Pilik legi tamizeige mele nuguzikku ma inge nuguzikku ni ulumiya logo ni kaile mizibene keleniyageya purik mabura kazing kaileyengki pumok ngela melibene mele puzik ma inge puzik ngela melagizikku, purik ni melenazik ma ingenazik kiling paka ngalege wik wizagomagirage kang purik kaile kapura tamizeige ni mele mabiyau ma inge mabiyau kiling kaile mizageya logo yezi yemane kusagi onozik ngoriraga kangki purik kaile panu. ");
INSERT INTO big_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Keya tamizeige wire nuguyauga nakko ni ulumiya logo ni kaile mizibene keleniyageya purik mabura kazing kaileyengki pumok ngela melibene wirebok tiya melagibokko, purik ni wire nak kiling paka ngalege wik wizagomagirage kang purik kaile kapura tamizeige Anotogo ni wire mabiyau kiling kaile mizageyarikki wiyeke yereng yezi yemane kusagi onozik ngoriraga wezanelagi purik kaile panu. ");
INSERT INTO big_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Inuwago kazing kumbekki lewengke songono nogowiliyaga nakyegi kiyebuk miza nagani waberek ngai panu. Kerewiyi, angela puwiliyegi waberek ngaiwili paka ngalege kang mabiyeng negi Mango paka ngalege yolubekki wirege kiliya kanda pi kiling puwiliyegi langai kozak keli mizi. ");
INSERT INTO big_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Keya ne yombanu paka ngalega kayimabek yongkambanu Anotogi kazingmekka koweige kuna puwili yaliya wazayiweki kayimabek. ");
INSERT INTO big_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ngago saweliwei nogoragi mabilik kerewiya koyi. Tamizeige yombu liyeng memengwiliyegi ngaiwiliyaga nak liyeng memeng kolokngagono 100 nawili kiling logo puwili yengelik ngela nageya keya pi ngai tawizeige liyeng memengwiliyaga namek nawiliyaga koweige kuna purik mabura pi liyeng memeng mabuwili yengelik ngela nageyara wezayi logo pi memeng yaka koweige kuna pumokyegi paka lewakyengke weli kangki. ");
INSERT INTO big_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pi weli kanda tamizeige pugu koweige kunamok yolok ngela mabura pi wilikwilikta kiling miza orowei yogi. Nogo inuwayegi wameik kozak yei, liyeng memeng koweige kuna ono puwili mabuwiliyegi pi wilik mizi kapura liyeng memeng koweige kuna logo pugu yolok ngela wizigeya miza orowei yo pumokyegi pi wilikwilikmokko yemane panu. ");
INSERT INTO big_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kazing mabilikmekke inigi Mango paka ngalege yolubok kazing kumbekki lewengke songono nogowiliyaga naktau piyaga koweige kunagi purikki keli ono kani, legi inuwago puwiliyegi waberek ngai panu. ");
INSERT INTO big_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ini neyegi sawela puwili, tamizeige ngizi kumuli nakko niyegi kaile nara miza mabura ni piyegi kunimo logo nugu piyegi pelik meimo, Nugu neyegi kaile nara miza, mena towa ngagora waberek miziweki, meimo. Tamizeige pi ni kiling ngagora waberek miza logo ngagora yeik sawiya purik mabura yali weik wazono mogosa koyagi. ");
INSERT INTO big_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kapura tamizeige pugu a’a’ nei purik mabura yombanu pugu kaile niyegi mizaragi pakelawiliyaga nak ma neyau ni kiling iza orowei kunimo. Keya ngereke pelik mei, Towa ngagora waberek miziweki, mei logo yombanu piyau ngago yaligu kisagiragi kerewiyiweki. ");
INSERT INTO big_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kapura tamizeige pugu piyauyegi a’a’ yei purik mabura waleleige yongkambanu neyegi ngizi panu kumuli puwili mabuwiliyegi ngagora kozak yeizo. Keya waleleige tamizeige pi puwiligu kisiragi kezanga mani purik mabura puwili piyegi pelik meiyagiwiligu, Nugu kazing yombanu Anotoyegi lusuweibokko miza kelikmekke mizi yagenda, legi ni teni kiling Anotoyegi ingimei keya waberek miziweki wawere ulageyagi ono kapura tamizeige ni kaile miza puragi kuneng miza logo pelik kai, Ne yaka kaile miza logo ne kuneng wiziga ini pura tumula logo keremareke wezameliweki, kai puwekke purik mabura teni tumula logo keremareke wezamela logo ni ngereke teni kiling wawere ulagi, meiyagiwiligu. ");
INSERT INTO big_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tegi nogo inuwa yombu nogo waligeleyi puwili mabuwiliyegi pera yei, Nogo inuwa kozang pelikta yani, yombanu ngabelakpekkewiligu kazing mizi inuwago pangka ono mei piyeng Anoto paka ngalege yolubokko mabilik pangka ono kaiyagi, keya yombanu ngabelakpekkewiligu kazing mizi inuwago pangka mei piyeng Anoto paka ngalege yolubokko mabilik pangka kaiyagi. ");
INSERT INTO big_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Keya nogo ngago yeke langak nararau yei, ini yombanu ngabelakpekke neyegi ngizi kumuli puwiliyaga neyau kangka wamenak koyimowei Anotoyegi watabi nayengki yaligu waberek mizi puwekke purik mabura negi Mango paka ngalegebokko yaligi miza yowiyagi. ");
INSERT INTO big_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Purik yombanu neyau ma neyauganak yeik nogorage wawere uli purik ne puwili kiling wizinda, yeiya. ");
INSERT INTO big_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pulaga Pita Yisuyegi kanda pelik nguk meiya, Yemizibek, yombanu ne kiling niyegi ngizi kumuliwiliyaga nakko neyegi langai kaile miza logo nogo pugu miza piyeng tumula logo keremareke wezamelagirik kang talik talik? Ne pilik mizagirik, kang melenazik keya nazikka neyau pangka ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tegi Yisugu pelik meiya to mela, A’a’, kang melenazik keya nazikka neyau piyeng pangka ono, kapura pi niyegi langai ngoluk kaile mizageya mabura nugu kaile niyegi miza piyeng tumula logo keremareke wezamelageya wizimo. ");
INSERT INTO big_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Purik Anotogo ngai pugumekki ngai yolu pura yombu King Ngai nak piyegi yawe miziwili piyaga king kanga managi nayeng weiya puwili kiling pangka pangka miziweki mizibok kelik kani. ");
INSERT INTO big_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pi puwili kiling pangka pangka mizageya wizigeya yombu king miliyon Kina meleyau kanga managine piyaga weiya nak piyegi miza orowei lewa. ");
INSERT INTO big_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kapura pi kingki yeik legi king kangayeng managi langai ono. Tegi ngai pugubokko pelik kozang kai, Yombanu ngai watabi kolokngagonoyeng kiling nakko pi keya pigi yongokpumele keya pigi yango keya marekngangwili keya watabi pugu wara yolu piyendau weiya logo king piyengki ngane weiya piyengko pigi king kanga melagiyeng mabiyeng meliweki, kai. ");
INSERT INTO big_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pilik kai legi yombu yawe mizibek ngai pugubekki wirege ingeyau laliya logo pugu pelik kozang nguk meiya, Yemizibek, ni neyegi yelakkelek mize logo yeik wizei logo nogo ni watabi mabiyeng kanga nanagine, meiya. ");
INSERT INTO big_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Togo ngai pugubokko piyegi yalek miza logo pigi yeikta kapiyarikka tumula logo piyegi pelik meiya, Mabilik, nogo nugu kanga yemane nanagiyeng tumula logo keremareke wezameli mena ni yeik kambele, meiya. ");
INSERT INTO big_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pulaga yombu yakabok imakka welagela logo kang tagoneige pugu yombu pi kiling ngaibekyegi yawe mizi nak ulogo piyaga king 100 Kina kanga managine weiyabek pakela logo pi kalok pugubek kozang kebangkela wizimowei pelik meiya, Nugu king ulogo neyaga weiya piyeng weik kanga nane, meiya. ");
INSERT INTO big_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tegi pi yombu kingyeng kanga managine ulogo weiyabokki wirege ingeyau laliya logo pugu pelik kozang nguk meiya, Ni neyegi yelakkelek mize logo yeik wizei logo nogo ni watabi mabiyeng kanga nanagine, meiya. ");
INSERT INTO big_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kapura pi kiyebuk miza logo pi miza oroweirik panga wigirimakke wigira wazamiya wizigeya pi kingyeng kanga meli puwekke wila wazamiyagine miza. ");
INSERT INTO big_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pilik miza logo yombanu ngaibekyegi yawe mizi nawiligu puragi keriyawekke puwili yalek miza logo puwili ngai puwiligibekyegi kanda watabi yaka miza piyeng mabiyeng kozak meiya. ");
INSERT INTO big_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tegi ngaibokko yombu were piyegi yawe mizabokyegi koli meiya logo pugu piyegi pelik meiya, Oyo, ni yawe korowali mizibek kani. Nugu neyegi nguk kairikki wiyeke nugu king yemane ne kanga nanagi langai piyeng mabiyeng nogo tumula logo keremareke wezamela. ");
INSERT INTO big_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nogo niyegi yalek miza pilik nugu nigi kewengkebokyegi mabilik yalek mizi kakpek. Nugu pilik miza onora nangki, meiya. ");
INSERT INTO big_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Logo ngaibek sisikmokko yemane panu logo yawe mizibek yombanu pi ngangang yemane kelemiyagiwiliyegi miza yana wizigeya pi king kanga melagi piyeng kanga meli puwekke yeikkine. ");
INSERT INTO big_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Togo negi Mango paka ngalege yolubokko mabilik mizagi. Tamizeige yombanu ni kiling Yisuyegi ngizi kumuliwiliyaga nakko niyegi watabi kaile miza piyeng wilek kang nugubekka tumula logo keremareke wezameli ono purik mabura negi Mangobokko niyegi pilik mizagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yisu ngago piyeng kaiya logo waleleige pi kiling yombu ngezebokko waligeleyiwili ngabelak Kalili meibek wiya logo kai Yolodang meilingka pangazuwage ngabelak Yudaya meibekke kambela. ");
INSERT INTO big_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yongkambanu kolokngagonowili piyegi kalika kiriwei kambela logo pulogo pugu kemegeme miziwili yombiyangai wazaya. ");
INSERT INTO big_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yombanu Palisi mei nawili Yisuyegi wiriya logo puwili ngago puguyeng yang kelemiweki logo puwiligu pelik nguk meiya, Ma lo tonugurago kairik nakko yongok pugumele pugu kelirikki wiyeke piyaugi weiya pura ngela logo pigi yongokpumele wezameli purik pangka kai ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pilik kisi legi Yisugu puwiliyegi pelik nguk yeiya to mela, Ma ini Anotogi Kapiya Walektik sangkela ono ma talik? Purik Mosego Anotogi Kapiya Walektikke lende mizarik pelik kai, Anotogo solo panu watabi mabiyeng keremizawekke pugu yombubek keya yongokmele keremiza. ");
INSERT INTO big_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Piliktikki wiyeke yombubek yongokmele weiyagi purik yombubek pigi panu keya mangoyau wezayagi logo pigi yongokpumele kiling menalege yoluweki logo piyau weik wamenakweki, kai. ");
INSERT INTO big_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Togo Anotogi wirege piyau weik neyau ono, segeya pugu piyau wamenak mizi. Tegi yombubek yongokmele wei puwekke Anotogo piyau yongkambu weiya kai legi yombanubokko yongkambu weiya pura ngela logo pigi yongokpumele wezamelagi ono, a’a’, yeiya. ");
INSERT INTO big_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pulaga Palisi puwiligu piyegi pelik nguk meiya, Pilik mabura Mosego pelik kaiya pura nangki pangka kai, Yombu nak pigi yongokpumele wezameli mabura pugu pigi yongokpumeleyegi kapiya narik lende miza maniweki logo kapiyarikku yongokmeleyegi, Ni weik yongok nogomele ono, kai logo pugu pi wezameli purik pangka, meiya. ");
INSERT INTO big_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Logo Yisugu pelik kanga yeiya, Ini yongokwili wezayelagi purikki Mosego pangka kaiya purik kangka inuwagiyeng kingyeng kelik kopong pugu pilik yeiya kapura Anotogo solo panu watabi mabiyeng keremizawekke pugu kazing pilik namektau miza ono. ");
INSERT INTO big_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kerewiya koyizo, yombanu nak yongok pugumele nak kiling iwek kolimele wezameli purik pangka, kapura yombanu nak yongok pugumele nak kiling iwek kola onomele wezameli purik pangka ono. Yombu pilik mizabek ngereke yongok namele wei purik pi yombanu yongok ngezebekkemele weiya wizimowei ngereke namele kiling iwek kolibok kelik mizi yagenda. Ma yombu nakko yongok wezamela namele wei purik pirau mabilik yombanu yongok ngezebekkimele weiya wizimowei ngereke namele kiling iwek kolibok kelik mizi yagenda logo purik kaile, yeiya. ");
INSERT INTO big_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pulaga yombu Yisu ngezebokko waligeleyi puwiligu piyegi pelik meiya, Kazing pilikmek miziweki mizi legi yombanuwili yongok wei ono purik wazonogi, meiya. ");
INSERT INTO big_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tegi Yisugu pelik yeiya to mela, Ei, kapura yombanu mamok pilik mizagi langai ono, kapura yombu Anotogo kangka yana puwilirau yongkambu weiyagi ono, yeik keke yolugiwili. ");
INSERT INTO big_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yombu yongok weiyagi ono puwili pilik peyengki wiyeke, yombu nawili kazing yongok weiyagi onomekke wazayawili kopong yeik yolu, keya yombu nawiligi ngaiwiligu puwili yawe puwiligira miziweki kazing pilikmekke keleya kopong yongkambu wei ono, keya yombu nawili wilek kangyeng Anotogi yaweragi tiya managi keli kopong yongkambu wei ono. Yombu kazing pilikmekke kiriweiweki kangka pilikpek kilingwili mabura kiriwei mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wok nakke yongkambanu nawili puwiligi yango keya marekngangwili Yisuyegi iza orowei wiriya logo mele puguzik koloyakamandikwiligi kebiyengke walamiya logo puwiligi wiyeke Anotoyegi waberek miziweki. Kapura Yisugu waligeleyiwiligu koloyakamandikwiligi panu keya mangowiliyegi ngalik yeiya. ");
INSERT INTO big_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kapura Yisugu pugu waligeleyiwiliyegi pelik yeiya, Koloyakamandikwili neyegi wiriyi pani. Puwili neyegi lewa nelegi waliyi nagani, purik koloyakamandik pilikwilirau Anotogo puwiliyegi ngaiweki ngai pugumekki kiliya wiriyagi purik pangka, yeiya. ");
INSERT INTO big_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Togo Yisugu mele puguyau koloyakamandikwiligi ngalege walamiya logo Anotogo puwiliyegi wazono keleyibene nguk meiya logo waleleige Yisu pulumeng wiya logo kambela. ");
INSERT INTO big_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wok nakke yombu nak Yisuyegi kanda pelik nguk meiya, Kiriwaga wazonobek yawe wazono talikta miza logo ne weik wik wizagomagira weiyagi, meiya. ");
INSERT INTO big_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tegi Yisugu piyegi pelik meiya to mela, Nugu neyegi wazonobek kaira nangki? Nugu ne keriyirik ne Anoto, purik Anoto wamenak wazonobek, naktau wazono ono. Kapura tamizeige ni Anotogi yereng wik wizagomagirage kiliya kangki keli mabura Mosegi lo piyengko kai piyengki kiriwei mizi mizimo, meiya. ");
INSERT INTO big_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Togo yombu yakabokko pelik nguk meiya, Loyengka tayeng, meiya legi Yisugu pelik meiya to mela, Lo piyeng pelik, Yombanu uli nagani. Keya yongkambu weiya puwili nigi kerekpu onobek ma nigi yongokpu onomele kiling iwek koli nagani. Keya yombanu nakki watabiyeng purik ngowei nagani. Keya yombanu nakyegi langai ngaigu kai nagani. ");
INSERT INTO big_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Keya nigi panu keya mangoyauyegi panga yungke mizimo, keya ni makngezego ni makngezeyegi keli mabilik nakyegirau mabilik kelimo, meiya. ");
INSERT INTO big_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tegi yombu nawekkebokko Yisuyegi pelik meiya, Lo nugu neyegi yaka kozak nei piyeng mabiyeng ne mandik songonowekkerikka kiriwei mizi kayima. Logo nayendau ne ngoluk mizagi ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tegi Yisugu piyegi pelik meiya, Ni wik wizagomagira pangka weiyagi mabura watabi nigi piyengko nigi kazing wik wizagomagira weiyagimek waliya legi watabi nigi piyeng mabiyeng yombanuwiligu weibene yani kune logo king piyengki ngane weiya piyeng yongkambanu watabiyengki yeik puwili yanimo. Pilik miza logo purik nugu lewege panu kelira paka ngalege wik wizagomagira purikki iwakagi. Logo mabiyeng pilik yana logo neyegi saweliweki kiriwei koli, meiya. ");
INSERT INTO big_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kapura yombu nawekkebek Yisugu pilik kai puragi kerewiyawekke wilek kang pugubek kuneng, purik pi watabi puguyeng kolokngagono panu logo yanagirikki kiyebuk kopong. Tegi pi yeik kambela. ");
INSERT INTO big_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pulaga Yisugu yombu pi ngezebokko waligeleyi puwiliyegi pelik yeiya, Wameik panu, yongkambanu watabiyengko kola puwiliyegirik Anotogo puwiliyegi ngaiweki Anotoyegi panga yungke kunagirik yawe unatuba panu kani. ");
INSERT INTO big_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kerewiya koyizo, liyeng Kamelmek meimok nili kagorik lolo ulibekki yungurikke kiliya kang purik yawe unatuba kapura yombanu watabi kolokngagono puguyengki kozang kumulibokko Anotogo piyegi ngaiweki kelemiyagirik yawe unatuba panu, yeiya. ");
INSERT INTO big_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Togo yombu ngezebokko waligeleyiwiligu ngago puragi kerewiyawekke puwili lebuk panu miza logo puwiligu pelik kisa, Tonugu yombanu watabiyengko kolokngagono puwili Anotogo puwiliyegi wazono miza nobiyeng miza kapura tamizeige nugu kaira wameik purik mabura yongkambanu wik wizagomagiragi wiyeke yaliya wazayagi langai puwili tawili? Nakkorau pangka mizagi ono, kisa. ");
INSERT INTO big_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kapura Yisugu puwiliyegi ngai yuke panu wizimowei pelik yeiya to mela, Ei, yombanu nak ngezebokkorau ngezebek wik wizagomagiragi wiyeke pangka yaliya wazamiyagi ono, kapura Anoto watabi mabiyeng pangka mizibek legi Anotogo yombanu nalik miza keya pilik puwili mabuwili pangka yaliya wazayagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pulaga Pitago Yisuyegi pelik meiya to mela, Kerewiye, teni yereng keya watabi tenigi piyeng mabiyeng wizamiya logo niyegi saweliweki kiriwei miza, wiziga teni wik wizagomagira weiyagi ma yeik, meiya. ");
INSERT INTO big_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tegi Yisugu puwiliyegi pelik yeiya, Ei, wameik, keya nogo inuwayegi pera kozak yeiweki, Wangki kalike watabi mabiyeng wik lewagelawekke purik ne yombanu paka ngalega kayimabek negi tung mogosiraga ngaiwaktik kiling mogosa wiziyagi logo puwekke nogo inuwa neyegi sawela puwilirau tung meleyau keya pongo ingenazikka neyauyengke mogosa wazayagi logo yongkambanu Isileiliwiligi ngai meleyau keya pongo ingenazikka neyau piyengki inuwago ngaiweki keleyagi. ");
INSERT INTO big_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Keya yombanu neyegi sawela logo yawe nogora mizagirikki wiyeke i puwiligiyeng wiyi, keya yereng puwiligiyeng wiyi, ma puwiligi si keya sakwili wezayi, ma puwiligi panu keya mangowili wezayi, ma koloyakamandik puwiligiwili wezayi ma ngabelak puwiligiyendau wiyi kang pilik puwili, Anotogo kanga yanagi piyeng watabi puwiligu wiya piyengka ngoluk lewegeyeng kolokngagono panuyeng keya puwilirau wik wizagomagira yanagi. ");
INSERT INTO big_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kapura mabek yombanu yemane yolu puwili tonugu weik yemanewili mizi kapura kalike Anotogo puwiliyegi keriya logo puwiliyaga kolokngagonowili yeikwili keleyagi, keya mabek yombanu tonugu yeikwili mizi puwili kalike Anotogo puwiliyegi keriya logo puwiliyaga kolokngagono yemanewili keleyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Togo Yisugu pugu waligeleyiwiliyegi ngago saweliwei pera pelik kozak yeiya, Anotogo ngai pugumekki ngai yolu pura yombanu waing yawe naleigi mangobokko yombanu waing yawe puguleige yawe mizagiwili iza wari kambok kelik. ");
INSERT INTO big_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wangane panu pi kambela logo nawiliyegi kanda puwiliyegi pelik yeiya, Yawe nogoleige yawe mizi koli keya nogo wok nakke inuwa nak nakyegi king Kina nalik yanagine, yeiya logo puwiligu piyegi, Ei, purik pangka meiya logo puwili yawe puguleige weik yawe mizi kambela. ");
INSERT INTO big_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Togo wok mabokko wangane yokmek panga luwegewekke yaweleigi mangobek ngereke yombanu yawe puguleige yawe mizagi nawili iza wariweki pakeli kambela logo panga pundage kanda pangalege nawili yeik ngagozakke koyilege. ");
INSERT INTO big_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tegi pugu puwiliyegi pelik yeiya, Inuwarau waing nogoleige yawe mizizo logo nogo inuwa yaka inuwago yawe miza purikki pangka pangka king yanagine, yeiya. ");
INSERT INTO big_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tegi puwiligu piyegi, Ei, purik pangka meiya logo puwili yawe puguleige weik yawe mizi kambela. Togo waleleige yokmek libuge pilikwekke pugu mabilik miza, keya waleleige yokmek panga wangka pilikwekke pugu mawinda mabilik miza. ");
INSERT INTO big_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Keya waleleige yokmek weik kiliyaweki mereke pilikwekke pi ngereke panga pundage kambela logo yombanu nawili ngoluk yeik ngagozakke koyilege. Pugu pakela logo puwiliyegi pelik yeiya, Inuwa wokpek mabok yawe namizi logo yeik pelege pilik koyimira nangki, yeiya. ");
INSERT INTO big_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tegi puwiligu piyegi pelik meiya to mela, Purik nakkorau teni yawe mizagi nayendau yana ono kopong, meiya. Tegi pugu puwiliyegi pelik yeiya, Mena inuwarau mabilik waing yawe nogoleige yawe mizi nangine kambeli, yeiya. ");
INSERT INTO big_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Togo waleleige kusaweki miziwekke yaweleigi mangobokko yombu pugu yawe miziwiliyegi ngai wazamiyabekyegi pelik meiya, Yombu yawe nogoleige yawe miziwiliyegi ngago yeiya logo king puwiligiyeng yane. Yombanu mabek kalike iza puwiliyaga solo yani kang were iza puwiliyegi kune, meiya. ");
INSERT INTO big_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Togo ngaibokko yombu yokmek weik kiliyaweki merekewekke yawe mizi puwili nak nak king Kina nalik yana. ");
INSERT INTO big_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tegi yombanu were yawe mizi kambela puwili king puwiligiyeng weiweki lewa wizigeya puwiligu kumularik puwili kingyeng ngalege sa weiyagi nobiyeng miza kapura puwilirau mabilik nak nak king Kina nalik weiya. ");
INSERT INTO big_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Puwili king puwiligiyeng weiya logo puwili yaweleigi mangobekyegi sisik miza logo weik munumunu kela. ");
INSERT INTO big_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Puwili yaweleigi mangobekyegi kanda puwiligu piyegi pelik meiya, Yombanu mabek kalike iza logo puwili awa wamenakke yawe mizawili keya teni wokpek mabok yok yemane yezingaibekke yawe mizi kayima logo yokpokko teni kak ngora kapura nugu puwili king yana pilik tenirau mabilik yana, meiya. ");
INSERT INTO big_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tegi yaweleigi mangobokko puwiliyaga nakyegi pelik meiya to mela, Negi kewengkebek kerewiye, nogo niyegi korowali keleni ono. Nogo ni king Kina nalik yawe mizirikki wiyeke nanagi neiya logo nugu neyegi, Ei, purik pangka neiya purikki kumule. ");
INSERT INTO big_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tegi ni king nuguyeng weiya logo i nugumakke kune. Nogo king ni nana mabilik yombanu kalika panu pebok maniweki mizi mena. ");
INSERT INTO big_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Logo purik nangki? King nogoyeng nogoyeng legi nogo king nogoyeng kang tamekke wezameli miza purik pangka. Kapura nogo nakyegi kazing wazonomek miziwekke nugu kiyebuk miza logo sisik mizira nangki, meiya. ");
INSERT INTO big_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Togo Yisugu yombu pugu waligeleyiwiliyegi ngago saweliwei purago kai puragi solorik pelik yeiya, Kazing mabilikmekke yombanu Anotogo pigi ngaimekki ngai yolu purage were kiliya kunawili yombanu kalike kiliya kunagiwiliyaga lewegegi ono, puwili Anotogi ngaimekki pangka pangka kunagiwili, yeiya. ");
INSERT INTO big_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pulaga Yisu kiling yombu pi ngezebokko waligeleyiwili kazing paka Yirusalem yerengke kang leweng neing kuna. Puwili kunimowei Yisugu yombu meleyau keya pongo ingenazikka neyau pi ngezebokko waligeleyiwili lewe narikke iza oroweirik pelik kozak yeiya, ");
INSERT INTO big_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Kerewiyi, tonuwa paka Yirusalem kangweki logo pungezige pulogo yombu nakko ne yombanu paka ngalega kayimabek nawiliyegi niza yanagi logo puwiligu ne niza oroweirik Yudawiligi yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwiliyegi niza yanagi. Keya puwiligu ne ngagozak keleniyagi logo ngagoyeng neyegi yowagi logo pelik kisagi, Pi ibengkibek, kisagi. ");
INSERT INTO big_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Togo puwiligu ne Yuda onowiliyegi niza yanagi. Logo puwiligu neyegi ngago wageliwei neiyagi keya ne wizale nelagi logo ne panga yengeleileige nili ulagi logo ne ibengki kapura wok neyau wiziya logo wok kalikebekke ne ngereke wik yangalektagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Togo Yisu kiling pugu waligeleyiwili weik ngereke paka Yirusalem kangweki kambela. Puwili yagoneigeya yombu yeikta Sebeti meibekki marekyaugi panumele pigi marekyau kiling Yisuyegi mereke kandarik Yisugi ingewerege ingeyau laliya wizimowei piyegi ya kumula wiziya logo pugu piyegi watabi pugu nguk mei piyeng miziweki nguk meiya. ");
INSERT INTO big_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tegi Yisugu piyaugi panumeleyegi pelik meiya, Ni watabi nangaiyeng niyegi mizagi keli, meiya. Tegi pugu piyegi pelik meiya to mela, Kalike ni ngai nugurage nigi tung mogosirikke mogosa logo ngai nugumekki ngai puwekke negi marekyau tung yeik lewegera kilingyaugu mogosi piyauge niyegi saweliwei mogosiweki keleyimo. Piyauyaga nak nigi mele ngaigezuwagezikke keya nak nigi mele koranengkezikke mogosiweki keleyimo, meiya. ");
INSERT INTO big_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kapura Yisugu mandikyauyegi pelik yeiya to mela, Yaligu nguk kisi piyeng yali iwaka ono. Ma kuneng yemane nogo wageliweki mizi piyeng kelikyeng yaligu wageliwekirik pangka? Ma ngangang yemane panu nogo wageliweki mizi pilikta yaligu wageliwekirik pangka ma yeik? Pilik nguk yeiya logo piyaugu pelik meiya to mela, Te pangka, meiya. ");
INSERT INTO big_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Togo Yisugu piyauyegi pelik yeiya, Ei, wameik, kuneng nogo wagelagi pura kelik nara yalirau wagelagi. Keya ngangang nogo wagelagi pura kelik nara yalirau wagelagi. Puwiligu neyegi watabi kaile keleniyagi pilik piyeng puwiligu yaliyegirau mabilik keleyagi. Kapura nogo yali nak mele ngaige nogozikke mogosi keya nak mele koranengke nogozikke mogosiweki keleyagi purik ne pilik keleyagi puragi ngaibek ono, Anoto negi Mangobek ngezebokko tung mogosagi piyau yombanu pugu sawiya piyau yanagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Togo yombu meleyau Yisu ngezebokko waligeleyiwili puragi kerewiyawekke puwiligu weik puwiligi kewengkeyauyegi sisik miza. ");
INSERT INTO big_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tegi Yisugu puwili mabuwili piyegi mereke wiriyiweki ngago yeiya logo pelik yeiya, Ngabelakyengki ngai yemiziwili yongkambanuwili puwiligi kulengke wazaya logo puwiliyegi ngai kozang yolu keya yemanewiligu yongkambanu yeikwili yaweyeng miziweki yani purik ini iwaka. ");
INSERT INTO big_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kapura ini kazing pilik pumokki kiriwei mizi nagani, segeya iniyaga nak yeikta lewegeweki kelibok purik pi ini nawiliyegi yawe mizibekweki. ");
INSERT INTO big_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Keya iniyaga nak iniyegi orozarikke wiziyagi kelibok purik pi ini nawiliyegi kulengke yawe mizibekweki. ");
INSERT INTO big_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Purik nerau, ne yombanu paka ngalega kayimabek kayimarik ne yongkambanuwili neyegi yawe miziweki kayima ono, ne yongkambanu puwili mabuwiliyegi yawe mizi keya saweliweki kayima, logo yongkambanuwiligu kaile miziyengki weraga Anotogo puwiliyegi ngangang yanagi ono, pilik segeya Anotogo neyegi ngangang puwiligiyeng nanagirik nogo ne makngezebek ne nelagiwiliyegi ngaungaugu niza yanagi logo yongkambanu kolokngagonowili kaile puwiligiyengko wigirawili kaile puwiligiyengka wila wazayiweki, yeiya. ");
INSERT INTO big_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Togo Yisu kiling pugu waligeleyiwili kambela logo yereng Yeriko mei puragi kayima. Keya puwili Yeriko yerenda neing kuna logo wiyi ngizige yongkambanu kolokngagonowili Yisuyegi kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yombu wireyau kusa neyau kazingmekke kerelege mogosa koyimowei yongkambanu ngabelak libu kangwiliyegi ngeragi keya kingyengki nguk yeiyageya koyilege. Yombu wireyau kusayau Yisu kiling yongkambanuwili kandikki kerewiyawekke piyaugu pelik ngalizi kek kisa, Yemizibek, ni tegi yelibu koka King Ngai Tawiti meiyabokki marekngangwiliyagabek logo Anotogo teni Yudawiliyegi wiyeke wezanelabok purik togo iwaka, legi teyegi yalek mize, kisa. ");
INSERT INTO big_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Piyaugu pilik kisi legi yongkambanu kolokngagonowili piyauyegi pelik yeiya, Yali ngagoluk koyi, yeiya. Kapura piyaugu mazeng keya pelik ngalizi panu kek kisi, O Yemizibek, ni King Ngai Tawitigi marekngangwiliyagabek legi teyegi yalek mize, kisi. ");
INSERT INTO big_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tegi Yisu leng miza logo pugu piyauyegi pelik nguk yeiya, Nangaiyeng nogo yaliyegi miziweki yali keli, yeiya. ");
INSERT INTO big_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Logo piyaugu pelik meiya to mela, Tegi Yemizibek, te nugu wire togoyau ngaiwila wazayiweki keli, meiya. ");
INSERT INTO big_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Togo Yisugu piyauyegi yalek keli legi pugu wire piyaugiyau kuming keleya logo nguk namizi mabuwekke wire piyaugiyau weik ngaiwila logo weik pakelagi langai logo piyau Yisuyegi kiriwei kambela. ");
INSERT INTO big_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Togo Yisu kiling pugu waligeleyiwili Yirusalem lemengki merekewekke lewak Olip meibekke wiriya. Lewak pokko yengelei olipyeng lewarikki wiyeke yeik pura meiya logo yereng Petepasi mei nara lewakpekke ngezege wizilege. Puwili Petepasi meiragi mereke kandawekke Yisugu yombu ngezebokko waligeleyi neyau were ngago pelikta kiling wezayela, ");
INSERT INTO big_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Yereng mereke paka purage kunizo. Yali pulogo kanda pakeliraige purik nguk namizi liyeng tongki nakko wakleige wibokko tariya namek kong pugumek kiling wizi penanging kani. Wi tariya piyeng wila mowiya logo neyegi iza orowei koli. ");
INSERT INTO big_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Keya Tamizeige nakko yaliyegi ngago nara kai purik mabura pelik meizo, Yemizibek peyauyege yawe nara legi te iza orowei kang. Were yawe pura miza logo pulaga pugu nguk namizi iza orowei yogine, meizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Togo pilik miza pura ngago koka walaka yombu ngagora Anotoyaga weiya logo kozak kaiyabokko kaiya pura wameik ngizi lewagelaweki miza, pura Yisu panga Yirusalem lewagirikki kaiya pura logo pelik kaiya, ");
INSERT INTO big_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Yereng Saiyong meiragewiliyegi kozak yeizo, Pakeli, King Ngai nugubek weik niyegi lewarikki. Pi ya kuzigebek logo pi liyeng tongkimekki kongmekke ngalege mogosa logo lewa, yeizo, kaiya. ");
INSERT INTO big_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Togo yombu Yisugu waligeleyi piyau were kambela logo Yisugu yaka piyauyegi kozak yeiya pilik miza logo ");
INSERT INTO big_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","piyau liyeng tongkimek yali marek iza orowei wiriya. Pilik miza logo pugu waligeleyiwiligu kagorik yeke ngalege waliya piyengka panga liyeng tongkiyaugi ngalege wiya logo Yisu tongki kongmekke ngalege mogosa logo wiriya. ");
INSERT INTO big_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pulaga Yisu tongki kongmekke ngalengale yagoneigeya yongkambanu kolokngagono pi kilingwiligu pi King Ngai Yemizi puwiligibek sawiya logo kagorik puwiligi yeke ngalege waliya piyeng kazingmekke welelagelega wiya. Nawili kirekkirek mele keya pulangaiyeng kira logo kazingmekke laga wiya. ");
INSERT INTO big_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Keya yongkambanu piyaga werewili keya kalike piyegi kiriwei nawili miza puwiligu yeik pugura yongolok mei wirimowei pelik ngalizi kek kisa, Pok King Ngai Tawitigi yeligagangmekkabek teni yaliya wazayagibek logo teni yeik pugura yongolok meiweki. Pok Anotogo teniyegi wezamelabek legi Anotogo pi kozanda maniweki. Anoto paka ngalege panu yolubek weik teni yaliya wazayiweki, kisa. ");
INSERT INTO big_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Togo Yisu paka Yirusalem yerengke kiliya lawekke yongkambanu Yirusalem yerengkewiliyaga kolokngagonowili lebukka ngane yemane miza logo puwiligu yombanu Yisu kiling puwiliyegi pelik nguk yeiya, Yombu pobok tak, yeiya. ");
INSERT INTO big_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Logo yongkambanu Yisu kiling puwiligu puwiliyegi pelik yeiya to mela, Pobok Anotoyaga ngagora weiya logo kozak kaibek Yisu meibek ngabelak Kalili meibekke yereng Nasarete meiragabek, yeiya. ");
INSERT INTO big_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Togo Yisu Anotogi i walek yemanemakki yerembekke kanda yongkambanuwili kingyengki ngane liyeng kau keya liyeng memeng keya winakwiliyegi pulogo pundik keremizageya koyilege keya nawili lalekyengki mogosa wizigeya yombanu nalagawiligi king nalangai piyeng Yudawiligi king piyengke kowita to mela logo watabi pulogo piyengka weiweki mizageya koyilege. Logo yombanu kingyengki ngane watabi yaniwiligu pelik kumuli, Tonuwa king yemane weiweki mena mizi. Logo Yisu kazing kaile pumokki pakela logo kiyebuk, legi pugu yongkambanu kingyengki ngane watabi wei keya yani mizageya puwili keleyayela logo yombanu kingyeng kowitageya puwiligi lalekyeng kowitagelega wezamela logo yombanu winak Kuwemimiwili wiyiwiligiyeng kowitagelega wezameli kang keya kelemiya. ");
INSERT INTO big_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Pilik miza logo Yisugu yongkambanuwiliyegi pelik yeiya, Anotogi Kapiya Walektikke lende mizarik pelik, I Anotogimak i yongkambanuwiligu piyegi waberek mizagimak, kapura inugu pung wezarik keremizarikku i Anotogimakki yeikta kaile sawiya logo weik yombanu king ngoweiwiligu king ururu yolu piyeng kelik keremiza, kai, yeiya. ");
INSERT INTO big_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pulaga Anotogi i walek yemanemakke pulogo yombanu wireyau kusawili keya yombanu inge koru sawilirau Yisuyegi wiriya logo pugu puwili yombiyangai wazaya. ");
INSERT INTO big_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Keya yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwili Yisugu watabi kozang wazonoyeng mizirikki keriyawekke puwili sisik miza. Keya Yisugu pilik mizageyarikki koloyakamandikwili pakelara koyilege logo puwili i walek yemanemakke pulogo wilikwilik mizageya koyimowei pelik kek kisi, Pok King Ngai Tawitigi yeligagangmekkabek teni yaliya wazayagibek logo teni yeik pugura yongolok meiweki, kisi. Logo yombu yaka puwiligu puragi kerewiyawekke puwili sisik yemane miza. ");
INSERT INTO big_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tegi puwiligu Yisuyegi pelik meiya, Koloyakamandikwiligu niyegi langai kisi purikki nugu kerewiya ma talik? Ni puwili ngagoluk koyibene yei onobek ma meiya logo Yisugu pelik yeiya to mela, Ei, ne kerewiya kapura ini Anotogi Kapiya Walektikke ngago pelik kaiya pura ngoluk sangkela ono ma talik? Anotogo mandik songonowiliyegi iwaka wazonora yanagi logo puwiligu wilikwilik mizageya koyimowei yeik nugura yongolok meiyagi. ");
INSERT INTO big_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yisugu pura yeiya logo pi puwili wezaya logo yerendaga welagela kuna logo yereng Petani meirage kandobela logo pulogo iwek kola. ");
INSERT INTO big_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Iwek kola logo wangane panu pura Yisu kiling pugu waligeleyiwili yereng Petanira wiya logo paka Yirusalem kang yongowekke Yisu yagasi miza. ");
INSERT INTO big_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pugu yengelei Fik mei nalei panga kazingmekke kerelege wizilege pakela logo pi yengeleilei wira nobiyeng pi panga puleigi kuna kapura wilekyendau yolok ngela ono, lekyeng keke wizilege. Tegi pugu puleigi pelik meiya, Ni mawinda ngereke kalikerau wilekyeng wiragi ono, yeikki, meiya logo nguk namizi yengeleilei weik ngoliya. ");
INSERT INTO big_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pilik miza logo yombu Yisu ngezebokko waligeleyiwiligu yengelei ngoliyaleigi pakelawekke puwili lelengkira logo puwiligu Yisuyegi pelik nguk meiya, Talik miza logo yengelei Fik pulei nguk namizi ngoliya? ");
INSERT INTO big_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tegi Yisugu puwiliyegi pelik yeiya to mela, Nogo inuwayegi ngago wameik pera kozak yei kani kumulizo. Tamizeige inuwa negi kozandagi ngizi panu kumuli keya kangka neyau ono purik mabura nogo yaka yengelei Fik panga puleigi miza pilik inuwagorau yawe kozang pelik mizagi, keya puleigi keke ono, inuwago lewak pobokki pelik mei puwekke purik, Ni somiyora koli logo panga kai wizambekke wale, mei purik pi pilik ngizi mizagi. ");
INSERT INTO big_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tamizeige inuwa Anotoyegi waberek mizageya koyimowei ngizi panu kumuli purik inugu weiweki nguk mei piyeng inuwa weiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yisu ngereke Anotogi i walek yemanemakke yeke ige la logo pulogo pugu yongkambanuwili waligeleyageya tawizeige Yudawiligi yemanewili keya yombu Anotoyegi kolak miziwiligi ngaiwilirau Yisuyegi wiriya logo puwiligu piyegi pelik nguk meiya, Ni yeik talikta kilimbokko yawe pera mizi? Keya takko ni yawe pera miziweki pangkara nana? ");
INSERT INTO big_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Pilik kisi legi Yisugu puwiliyegi pelik yeiya to mela, Mena, nerau inuwayegi ngago naragi nguk yeiweki. Tamizeige inuwago neyegi kangara neiya yo meli mabura nogo takko ne yawe pera miziweki pangkara nana miza purikki inuwayegi kozak yeiyagine. ");
INSERT INTO big_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Neyegi kozak nei, Yowan kaimelabek kayima logo yongkambanuwili kaimela puwekke yawe kaimela pura Anotogi yawera ma yombu ngabelakpekkewiliyaga nakki yawera miza purikki, yeiya. Togo puwili ngezewili pulogo pelik kozak keli yongomo miza, Teni talik meiyagi? Tamizeige tonugu pelik mei, Anotogira, mei purik mabura pugu pelik nguk yeiyagi, Inuwa watabi Yowangu kai piyengki ngizi kumula onora nangki, yeiyagi. ");
INSERT INTO big_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kapura yongkambanu pewili Yowan Anotoyaga kayima logo ngago piyagayeng kozak kaiyageya wiziyabektikki ngizi panu kumulawili kopong tonugu pelik mei, Yombanu ngabelakpekkewiliyaga nakkira, mei purik mabura yongkambanuwiligu teniyegi sisik mizagi, kela. ");
INSERT INTO big_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Togo puwili yongkambanuwiliyegi kazi miza kopong puwiligu Yisuyegi pelik meiya to mela, Yawe Yowangira talaga kayimara miza purik teni lusuwei. Pilik meiya logo Yisugu puwiliyegi pelik yeiya to mela, Pilik mabura, nogorau inuwayegi takko ne yawe pera miziweki pangkara nana miza purikki kozak yeiyagi ono. ");
INSERT INTO big_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kapura ngago saweliwei peragi kerewiya koyizo. Yombu nak mandik neyau. Togo pi pigi marek kalogolibekyegi kanda pelik meiya, Mandikpek, ni weik panga waing yaweleige yawe mizi kambele, meiya. ");
INSERT INTO big_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kapura koyambokko pigi mangobekyegi pelik meiya, Ne kiyebuk, meiya kapura kalike pi kuneng miza logo kangkabek kowita logo pi panga waing yaweleige yawe mizi kambela. ");
INSERT INTO big_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pulaga mango sakpekyegi kanda yaka sibekyegi meiya mabilik meiya, Mandikpek, ni weik panga waing yaweleige yawe mizi kambele, meiya logo sakpokko mangoyegi pelik meiya to mela, Ei, Peba, ne kangki, meiya. Kapura pi yawe mizi kambela ono, pi ngezebokko keli piyengki mizi kambela. ");
INSERT INTO big_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Togo inuwago kumularik talik, Yombanubokki marekyauyaga takko piyaugi mangobokko kelira miza? Yisugu pilik yeiya legi Yudawiligi ngaiwiligu piyegi pelik meiya to mela, Koyang kalogolibokko pigi mangobekki kelira miza, meiya. Tegi Yisugu puwiliyegi pelik yeiya, Ei, wameik. Keya nogo iniyegi wameik pera kozak yeiweki, Yombu king takis weiya logo piyengka nayeng ngoweiwili keya yongok kazingke miziwili inuwayaga lewege panuwili logo Anotogi ngaimekki weik iniyaga were kiliya kuna. ");
INSERT INTO big_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Purik Yowan kaimelabek kayima logo yongkambanuwiliyegi kazing pangka Anotoyegi kangkimek waligeleya. Inuwago ngago puguragi kerewiya puwekke inuwa ngizi kumula logo kiriwei miza ono. Kapura yombu king takis weiya piyengka ngoweiwili keya yongok kazingke miziwili ngago puguragi kerewiya puwekke puwiligu ngizi kumula logo kuneng miza logo kazing kaile puwiligiyengka kowita logo ngagoragi kiriwei mizawili koyang kalogolibokko miza pilik miza. Kapura inuwa pewiliyegirik inuwago puwili kowita purikki pakela kapura inuwarau kuneng miza logo kaile inuwagiyengka kowita logo ngago puguragi kiriwei miza ono. Logo inuwa koyang kalikebek kelikwili purik inuwarau Anotogi kelira miza ono. ");
INSERT INTO big_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nogo iniyegi ngago saweliwei nararau kozak yeiweki mena kerewiyizo. Yombanu nak ngabelak pugubekke waing yawe nalei ngeriya logo lemeng kozang namek yawereng kelemiya logo kawik watabi waing wilekyeng wambulagirik wiziyagirik yokora logo i yokolong ngai yawe puleigi ngaiwekibek wiziyagi namak ngiza. Togo pugu nawili yawe puleigi ngai koyibene wazaya logo puwiliyegi pelik yeiya, Yawe nogoleigi yawe mizageya koyimowei waberek ngai koyizo. Keya waing wilekyeng weik kuk puwekke purik mabura piyeng tiyizo logo waing keremizizo. Pilik yeiya logo yawe puleigi mangobek nalege koweige kambela. ");
INSERT INTO big_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Togo waing wilekyeng weik kuk wizigeya wilekyeng tiyagiwekke pugu yombu ngagora oroweiwili, nak were, nak kalike, nak kalik panuge, keleya logo yaweleigi ngai wazayawiliyegi wezayela logo yaweleige waing wilek piyengka waing keremiza nayeng weiweki. ");
INSERT INTO big_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kapura nak nak kandawekkerik ngai wazaya puwiligu ngagora oroweiwili kebangkela logo werebek wizale uli, keya kalikebek ula logo ibeng, keya kalik panugebek kingyengko ula logo ibeng miza. ");
INSERT INTO big_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pulaga yaweleigi mangobokko ngereke yombu kolokngago ngagora oroweiwili wezayela, kapura puwiligu kazing yaka werewili keleya mabilikmekke puwilirau mabilik keleya. ");
INSERT INTO big_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kapura kalik panuge yaweleigi mangobokko pelik kumula, Nogo ne makngezegi marekpek puwiliyegi wezamelagi, purik puwiligu negi marekpekki ngagoragi kerewiyagi. ");
INSERT INTO big_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pilik kumula logo pi wezamela kapura puwiligu yaweleigi mangobekki marekpekyegi pakelawekke puwili nakko nakyegi pelik mei yongomo miza, Pobok yaweleigi mangobekki marekpek kani. Kalike pigi mangobek ibeng puwekke pi yawe pelei weiyagibek. Tegi teni pi ula logo mango ibeng purik waing yawelei teni makngezegiweki mena, kela. ");
INSERT INTO big_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Logo puwiligu pi kebangkela logo pi panga waing yaweleige yomizora wezamela logo pi ula logo ibeng. ");
INSERT INTO big_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Togo yaweleigi mangobek yo puwekkerik yaweleigi ngai wazayawiligu pilik miza purikki yaweleigi mangobek puwiliyegi talik mizagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pilik kai legi yongkambanu ngago piyengki kerewiya puwiligu pelik meiya to mela, Yaweleigi mangobokko kanda yombanu korowali yaweleigi ngai wazaya puwili wizale yemane yela logo ibeng wazayagi logo pugu waing yawe pugulei ngereke yombanu nawiliyegi yana logo puwiligu waberek ngaigi. Logo puwili yengelei wilekyeng kukwekke puwiligu pi yaweleige waing wilek piyengka waing keremiza nayeng mani mizagi, meiya. ");
INSERT INTO big_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Pulaga Yisugu pelik yeiya, Ei, inugu Anotogi Kapiya Walektikke neyegi langai pelik sangkeli purikki kumulizo. Purikku pelik kai, King yombu imak ngiziwiligu kiyebuk miza logo wezamela pura ngereke king panu imak mamak kebangkela yolu pura kani. Pilik yolu pura Anoto Yemizibek ngezebokko pilik wazamiya logo tonugu purikki pakela logo purik yombiyangai panu miza. ");
INSERT INTO big_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yisugu mawinda pelik yeiya, Ne king panu pura kelikpek. Nugu neyegi kiyebuk mizi logo wezanelagi legi Anotogo ini Yudawiliyaga yawe ngabelakke pelege ngai pugumekke ngai koyibene wazayagira weiya yo wiyagi logo yongkambanu Yuda onowiliyegi yanagi. Pilik miza logo waleleige puwili yawe mizageya puwekke yongkambanu kolokngagonowili ngago wameiktagi ngizi panu kumula logo Anotogi ngaimekki kiliya kangki logo Anotogo puwiliyegi ngaiweki. ");
INSERT INTO big_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Keya king yaka panu puragirik yombanu king puragi ngalege wala puwili narik narik ngela melagi. Keya tamizeige king purago yombanu nakki ngalege kawiye wala purik, king purago pi neneng ngela logo kozobek kelik keremizagi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Keya yombu Anotoyegi kolak miziwiligi ngaiwili keya yombu Palisi puwili Yisugu ngago saweliwei kai piyengki kerewiyawekke Yisugu puwiliyegi langai kozak kairikki puwiligu pakela. ");
INSERT INTO big_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tegi puwiligu Yisu kebangkeliweki miza kapura yongkambanuwiligu kumulirik Yisu Anotoyaga ngagora weiya logo kozak kaibek miza legi puwili watabi yongkambanuwiligu mizagi piyengki kazi miza. ");
INSERT INTO big_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Togo Yisugu ngereke yongkambanuwiliyegi ngago saweliwei nararau pelik kozak yeiya, ");
INSERT INTO big_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Yongkambanuwili Anotogi ngaimekki pelik kiliya, Wok nakke King Ngai nakki marekpek yongok weiweki mizi legi ngeragi miza ni nara miza logo yongkambanu kolokngagono ngeragi piyengka niweki ngago yeiya. ");
INSERT INTO big_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Logo watabi mabiyeng pangka pangka miza logo pugu yombu piyegi yawe miziwili yongkambanu ulogo ngago yeiyawiliyegi lewaweki ngago yei wezayela logo watabi mabiyeng weik pangka miza mena koli yeizo, yeiya. Puwili pilik miza kapura puwili mabuwili nak nak lewagi ono kisa. ");
INSERT INTO big_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tegi pugu piyegi yawe mizi nawili mawinda ngeragiraga nagiwiliyegi ngago pelikta kiling kang wezayela, Ngeragi yemane nogo mizara weik ngayek miza mena koli. Neyegi yawe mizi puwiligu liyeng pulumakau kerek nogomek keya liyeng koloko nogowili yaka yela logo watabi mabiyeng wiregak miza logo niweki yuke legi yombu yongok weiyagirage ngeragi miza niweki koli yeizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Puwili pilik miza kapura yombanu lewaweki ngago yeiyawili ngago King Ngaibokko kai puragi kerewiya ono, puwili yawe ngezewiligi kingyeng ulumiyagi piyengke yawe mizi kang. Nak yawe puguleige wei kang, keya nak sutuwa ngezebekkimakke wei kang. ");
INSERT INTO big_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Keya nawiligu King Ngaibekyegi yawe miziwili kebangkela logo puwiliyegi kaile kaile miza logo yela logo ibeng sa wazaya. ");
INSERT INTO big_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pilik miza logo King Ngaibek sisikmokko yemane panu logo ami puguwili kang wezayela logo puwiligu yombanu yaka yombanu yela puwili yeli keya yereng puwiligira ulu waliyibene wezayela. ");
INSERT INTO big_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pulaga pugu yombanu piyegi yawe mizi nawiliyegi pelik yeiya, Nogo ngeragi yemane mizara weik niweki yuke kapura yombanu nogo were ngago yeiya puwili pangka lewagi langai onowiligu, ");
INSERT INTO big_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","legi kambeli logo kazing yemaneyengke yombanu kolokngagono inugu yolok ngeli puwili mabuwili yombu yongok weiyagiragi ngeragi niweki iza orowei wiriyizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tegi piyegi yawe miziwili kazing yemaneyengke kambela logo yongkambanu kolokngagonowili, wazonowili keya kaile puwiligu yolok ngela puwili mabuwili iza orowei lewa logo yongok weiweki ngeragi yemane miza ni pumak mabumak yongkambanugu wilak. ");
INSERT INTO big_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pilik miza logo King Ngaibek yongkambanu yaka lewa puwiliyegi pakeliweki yeke ige kiliya la logo keriyiwei yongomo mizageya tawizeige pura nak kagorik ngeragi yemane pilik nirage pugu wakiyiweki yana piyengka narik wakiya ono, yeik wizilege pakela. ");
INSERT INTO big_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pugu pakela logo piyegi pelik meiya, Yombanubek, talik miza logo ni pelege ige kagorik ngeragi yemane pilik nirage nogo wakiyiweki nanarik wakiya ono yeik wiriya, meiya. Kapura yombanubokko piyegi nara meiya ono. ");
INSERT INTO big_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Togo mabuwekke King Ngaibokko piyegi yawe miziwiliyegi pelik yeiya, Yombubok kebangkela logo inge keya mele puguyeng wigira logo yenge yerengke kusabanurikke wezameli logo pulogo kusabanurikke pi yombanu pulogowili kiling ingkeya kelele yemane panu kai keya kili pugura ngiliti mizagiyagi. ");
INSERT INTO big_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kazing mabilikmekke yongkambanu Anoto ngezebokko ngago yeiwili kolokngagono kapura puwiliyaga pugu nogowili yei miziwili mele sangkela, yeiya. ");
INSERT INTO big_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pulaga yombu Palisiwili mei puwili Yisu wezamiya logo kazing Yisuyegi ikuyogorik mizagimek kozak keli kambela. ");
INSERT INTO big_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Puwili kozak kela logo puwiligu yombu ngezewiliyegi kiriweiwiliyaga nawili keya yombu Ngai Elodoyegi kiriweiwiliyaga nawili Yisuyegi wezayela. Togo puwili kunimowei nakko nakyegi pelik meiya, Tonuwa Yisuyegi pelik meiyagine, Nugu kumularik talik? Teni king takisyeng Romwiligi King Ngaibek Sisa meibokyegi managi purik pangka ma yeik meiyagine. Tamizeige pugu, Ei, mani, kai purik mabura yongkambanuwili king takisyeng managirikki kiyebuk mizi nangai legi puwiligu pi kingyengko ulagi. Tamizeige pugu, A’a’, mani nagani, kai purik mabura tonuwa pi Romwiligi ngaiwiliyegi miza orowei kangkine logo puwiligu pi ngagozak kelemibene, kela. Togo puwili Yisuyegi kanda piyegi pelik meiya, Kiriwagabek, nugu kaiyeng keya miziyeng wameik ngizi panuyeng purik tonugu iwaka. Keya ni yongkambanuwili kazing Anotogi ngizi panumekki waligeleyibek purik tonuwa iwaka. Keya ni nakyegirau kulili mizi onobek, ma ni yewizek mizi onobek puriktau tonuwa iwaka. ");
INSERT INTO big_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kapura nugu tonuwayegi poburikki kozak yei, Lo tonugurago talik kai, teni king takisyeng Sisayegi managi kai ma managi ono kai, pelik nguk meiya. ");
INSERT INTO big_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kapura Yisu puwiligu ikuyogorik mizi puragi iwaka logo pugu puwiliyegi pelik yeiya, Inuwa kiligang neyau lewawili, inuwago neyegi ikuyogorik kelenira nangki? ");
INSERT INTO big_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","King keke nalik neyegi orowei koli logo nogo pakeliweki, yeiya. Legi puwiligu piyegi nalik orowei kanda logo ");
INSERT INTO big_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","pugu pelik nguk yeiya, Wiregawere king pelikke pera takkara keya yeik takkara wizine pakeli, yeiya. ");
INSERT INTO big_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Legi puwiligu pelik meiya to mela, Romwiligi King Ngaibek Sisagiyau, meiya, legi Yisugu pelik yeiya, Mena watabi King Ngaibekkiyeng purik King Ngaibekyegi manizo, keya watabi Anotogiyeng purik Anotoyegi manizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Logo puwiligu ngago pugu wazono kaiya yo meliyengki kerewiyawekke puwili lebuk miza logo puwili pi wezamiya logo kambela. ");
INSERT INTO big_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Keya pulaga wok mabokko yombanu Sadusiwili meiwiliyaga nawili Yisuyegi ikuyogorik kelemi wiriya. Sadusiwili yombanu pelik kisiwili, Yombanu nak ibeng purik kung pugubektau ibeng logo pi ngereke yangalektagi ono, kisiwili. ");
INSERT INTO big_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Puwiligu piyegi kanda Yisuyegi pelik nguk meiya, Kiriwagabek, Mosego lo tenigi lende miza nara pelik, Tamizeige yombanu nak yongok weiya logo mandik wazami ono wiziya yombubok ibeng purik yombubokki sakpek ngereke yongok komatemolo weiyagi logo piyaugu yombu yaka ibembokki yango keya marekngang nawili wazayiweki. ");
INSERT INTO big_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yereng tonuguraga tenigi tepekke yombu ingini melenazik keya nazikka neyauwili yolu. Logo kalogolibek were yongok weiya logo mandik wazamiya ono wiziya pi ibeng. Logo yongok pugumele pigi sakpokko weibene wezamiya. ");
INSERT INTO big_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Keya pulaga waleleige kalogolibekki kelengkebokko ngereke yongok komatemele weiya kapura piyaurau mandik wazamiya ono koya pi ibeng. Keya pulaga pokki kelengkebokko komatemele ngereke weiya logo yombu melenazik keya nazikka neyau puwili mabuwili pilik miza kapura mandik wazaya ono koya ibeng. ");
INSERT INTO big_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Logo kalik panuge yongok komatemelerau ibeng. ");
INSERT INTO big_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mena, teni niyegi ngago peragi nguk neiweki, tamizeige wok kalik panubekke yongkambanu ulogo ibeng puwili nugu kai pilik yangalekta wik yolugi mabura, yombu puwili mabuwili yongokpumolo weiyawili legi tamizeige kalike ibengwili ngereke yangalekta puwekkerik yongok yaka pumolo takki yongokpumele mizagi, meiya. ");
INSERT INTO big_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Legi Yisugu puwiliyegi pelik yeiya to mela, Inuwa Anotogi Kapiya Walektik keya pigi kozanda lusuwei kopong inuwago watabi pilik piyengki kumulirik kokowa. ");
INSERT INTO big_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Purik ibengwili yangalekta wikwekke puwili Anotogi angela paka ngalegewili kelikki logo yombuwili keya yongokwili yongkambu weiyagi ono, ma panu keya mangogo kolomele yombu weiyagi nakyegi miza managi ono. ");
INSERT INTO big_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ibengwili ngereke yangalekta wazayagirik nogo Anotogi Kapiya Walektikke yungke inuwayegi pilik kairikki kozak yeiweki mizi. Mosego Anotogo piyegi meiyaragi lende mizarik pelik, ");
INSERT INTO big_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ne Anoto Abalamgibek keya ne Anoto Isakkibek keya ne Anoto Yakopgibek, meiyara lende miza. Keya Anotogo pelik kaiyawekkerik, Abalam keya pigi marekpek Isak keya Isakki marekpek Yakop ulogo ibengwiliyegi pi pilik kaiya kapura Anotogo puwili wik kai yagenda. Ulogo puwiligi korikyeng ibeng kele kapura wilek kang puwiligiyeng wik yolu. Logo inuwayegirik puwili ibeng kapura Anotoyegirik puwili wik yolu, legi pi Anoto wik yoluwiligi ngaibek, yeiya. ");
INSERT INTO big_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Togo yongkambanu kolokngagonowili ngago Yisugu kaiya pura ululu miza melirikki kerewiyawekke puwili pugu pangka waligeleyi puragi lelengkira. ");
INSERT INTO big_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kapura yombu Palisiwili meiwili lelengkira ono. Logo Yisugu ngago purago Sadusiwiligi kiligangyeng waliya wazaya logo puragi yombu Palisiwiligu kerewiyawekke puwili piyegi wiriya logo ngereke piyegi nguk meiya narago ikuyogorik kelemiweki. ");
INSERT INTO big_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Togo puwiliyaga Mosegi loyengki waligeleyiwiliyaga nakko ngago naragi nguk meiya. ");
INSERT INTO big_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Pugu Yisugi ngago lewayeng yang kelemiyagi nobiyeng pugu piyegi pelik nguk meiya, Kiriwagabek, lo Anotogo teni yanayengka lo talikta ngalege panura, meiya. ");
INSERT INTO big_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tegi Yisugu pelik meiya to mela, Lo ngalege panura pelikta, Ni Anoto nigi Yemizi ngaibekyegi wilek kang nugubek mabokko ngizi panu kelimo, keya kangka nugubokko piyegi wilibek kumuli mizimo. ");
INSERT INTO big_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lo pilikta yemane panura keya ngalege panura. ");
INSERT INTO big_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Keya lo puragi kelengkera pelikta, Ni makngezego ni makngezeyegi keli mabilik nakyegirau mabilik kelimo. ");
INSERT INTO big_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lo piyau Mosegi lo piyeng mabiyeng keya yombu Anotoyaga ngagora weiya logo kozak kisawiligu waligeleyi piyeng mabiyeng lo piyaugu yenge kulengka tomanenda wizinda, legi tamizeige nugu piyaugi kiriwei mizi purik mabura nugu lo mabiyengkirau kiriwei miziweki kelagi, Yisugu puwiliyegi pilik yeiya. ");
INSERT INTO big_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yombu Palisiwili meiwili menalege wawere ulara koyigeya Yisugu puwiliyegi pelik nguk yeiya, ");
INSERT INTO big_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Inuwago kumularik talik, Kilisibek Mesiya Anotogo teni yaliya wazayiweki wezamelagibek takki marekngangwiliyaga nak, yeiya. Legi puwiligu Yisuyegi pelik meiya to mela, Anotogi Mesiyabek koka King Ngai Tawitigi marekngangwiliyaga nak, meiya. ");
INSERT INTO big_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Legi Yisugu puwiliyegi pelik nguk yeiya, Mena, nangki wiyeke Tawitigu Kilisibekyegi Yemizibek meiya, purik koka walaka Anotogi Kung Walekpokko Ngai Tawitigu kaibene kelemiya logo Tawitigu Anotogi Kapiya Walektikke Kilisibekyegi langai lende mizarik pelik kaiya, ");
INSERT INTO big_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Anoto Yemizibokko Kilisibek Yemizi nogobekyegi pelik meiya, Nogo niyegi kiyebuk miziwili nigi kulengke nugu ngaiweki wazayirikka negi ngaigezuwaga pelaga mogosi koli, kaiya. ");
INSERT INTO big_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tawitigu Kilisibekyegi Anoto Yemizibek meiya legi talik miza logo Kilisibek Tawitigi marekngangwiliyaga nak? Pilik mabura Kilisibek mabok yombanubek keya Anoto wizinda, yeiya. ");
INSERT INTO big_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Togo nakkorau ngago puragi Yisuyegi ngago kanga nara mana ono. Keya wokpokka wizageya wiriyariktau nakkorau Yisuyegi mawinda ngago nara nguk meiyarau ono, puwili weik kazi miza. ");
INSERT INTO big_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pulaga Yisugu yongkambanu kolokngagonowili keya yombu pugu waligeleyi wawere ula puwiliyegi pilik yeiya. ");
INSERT INTO big_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mosegi loyengki waligeleyiwili keya yombu Palisiwili meiwili yeikta kilingwili logo Mosegi loyengki iwakaweki keya ini yongkambanuwiliyegi waligeleyiweki kani. ");
INSERT INTO big_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tegi ini puwiligu ngago ini mizizo kisi piyengki kiriwei mizizo, kapura kazing puwiligu mizi piyengki kiriwei mizi nagani, purik puwili ngago kolokngagono kisi kapura ngeze mabuwilirau kiriwei mizi onowili kani. ");
INSERT INTO big_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Purik puwiligu ini lo kolokngagono yani logo weik watabi kuneng talik miza logo wagelagi miza piyeng kelik kapura puwili ngezewilirau iniyegi sawela logo Anotogo inugu miziweki keli piyengkirau kozak yei ono. ");
INSERT INTO big_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Keya watabi puwiligu mizi piyeng mabiyeng yongkambanuwiligu pakela logo yeik puwiligiyeng yongolok meibene miziyengko. Puwiligu Anotogi ngago nayeng kapiyalekyengke lende miza logo sukumeng miza logo luwagoza puwiligiyengke ma mele puwiligiyengke tariya wari miziwili. Keya puwiligu melewangka yokolongyeng yokolong panu keremizi logo yongkambanuwiligu puwili yemanewili mizibene miziwili. ");
INSERT INTO big_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Keya puwili ngeragi yemane miza ni piyengke tung yeikyeng kilingwiligu mogosi piyengke mogosiweki keliwili. Keya puwili i walek songonoyengke paka orozarikke yongkambanuwiligi wirege yongkambanuwiligu pakelibene mogosiweki keliwili. ");
INSERT INTO big_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Keya puwili pundikke yongkambanu mamokki wirege puwiliyegi pelik yeiweki miziwili, Wangane Ngaibek ma Wangane Kiriwagabek, miziwili. ");
INSERT INTO big_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kapura inuwarau puwili kelik nagani. Yongkambanuwiligu inuwayegi, Kiriwagawili, kisiweki keleyi nagani, purik inuwa mabuwili kapiya miziwili kelik keya ini waligeleyi wamenak yolu, pok Kilisibek. ");
INSERT INTO big_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Keya Mango wamenak yolu keya pi inuwagi Mango paka ngalege yolubek legi inuwago yombu ngabelakke pelege nakyegi, Peba, mei nagani. ");
INSERT INTO big_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Keya yongkambanuwiligu inuwayegi Yemizi ngaiwili, kisiweki keleyi nagani, purik Yemizi ngai wamenak yolu kani, Pok Kilisibek, Mesiya Anotogo inuwa yaliya wazayibene wezamelabek. ");
INSERT INTO big_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kapura inuwayaga nak yeikta lewegebok inuwa nawiliyegi yenge kulengke yolu keya yawe miza yowiyagibek. ");
INSERT INTO big_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Keya yombanu ngezebokko ngezebekki yeikta yongolok meibok Anotogo yeik pugura songono sawiyagi keya yombanu yeik ngezebekkira songono sawiyibok Anotogo yeik pugura ngalege wiyagi. ");
INSERT INTO big_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yomono, ini Mosegi loyengki waligeleyiwili keya ini Palisiwili, waberek panu, purik kalike Anotogo ini yombanu kiligang neyau lewawili ngangang yemane yanagi. Purik inugu kazing yongkambanuwili Anotogi ngaimekki kiliya kangkimek waliyi. Ini makngeze yeke ige kiliya kang ono keya inugu yongkambanu yeke ige kiliya liweki keli puwili yeke ige kiliya li pani keleyi ono, legi ini ngangang yemane weiyagi. ");
INSERT INTO big_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yomono, ini Mosegi loyengki waligeleyiwili keya ini Palisiwili waberek panu purik kalike Anotogo ini yombanu kiligang neyau lewawili ngangang yemane yanagi. Purik ini yongok komatewiligi iyengki kanda purik ini yongok komatewili purikki iwaka koyimowei ngaigu king i walekmakkiyeng meliweki yeiya logo kalike ngereke ini makngezegi liwik wawiyiwili. Keya waleleige purik inugu kaile ini makngezegiyeng momane meibene Anotoyegi waberek miziyeng yokolong panu mei. Kapura kalike Anotogo yongkambanuwili kaile puwiligiyengki wiyeke ngagozak keleyi puwekke puwili ngangang weiyagi, kapura ini Mosegi loyengki waligeleyiwili keya ini Palisiwili inugu kaile panu mizi piyengki wiyeke ngangang yemane panu weiyagi. ");
INSERT INTO big_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Yomono, ini Mosegi loyengki waligeleyiwili keya ini Palisiwili waberek panu, purik kalike Anotogo ini yombanu kiligang neyau lewawili ngangang yanagi. Purik ini kai wizambekke ngalengale kang keya ngabelak koweigeyengke kang logo yombanuwiliyaga nak iniyegi sawelagirikki yolok ngeliweki. Pi iniyegi sawela logo inugu pi kazing inugu miziyengki waligelemiya logo waleleige kazing kaile puguyengko kazing kaile inuguyeng ulagi logo pi ini kiling pongo yereng yezi kusagi onozik ngoriraga kang wezamelagi. ");
INSERT INTO big_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ini yomono, purik ini ngai wireyeng kusawili logo yongkambanuwili kazing kailemekke iza orowei kangwili legi Anotogo ini ngangang yanagi. Purik ini pelik kisiwili, Ngago nara kai puwekkerik tamizeige yombanunak Anotogi i walek yemanemakki yeiktaga ngago pugura kozang kelemi purik mabura ngago pura ngeli purik pangka kapura yombanu nak watabi Anotogi i walek yemanemakka yeke ige koliyengka keremiza yolu piyengki yeiktaga ngago pura kozang kelemi purik mabura pugu ngago pura ngelagi ono, kisiwili. ");
INSERT INTO big_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kapura ini wireyeng kusawili keya kangka yeikwili. Anotogi i yemane inugu piyegi ya kumuli mizimak walekmak, keya piliktikki wiyeke watabi imakke yeke ige koliyengka keremiza piyeng keya nalangai piyendau walekyeng kani legi ngago pura ngelagi onora. ");
INSERT INTO big_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Inugurau mabilik yongkambanuwiliyegi pelik waligeleyi, tamizeige yombanu nak i walek yemanemakke alataragi yeiktaga ngago pugura kozang kelemi purik mabura ngago pura ngeli purik pangka kapura yombanu nak opa alatarage ngalege wiyi piyengko ngago pugura kozang kelemi purik mabura pugu ngago pura ngelagi ono, kisiwili. ");
INSERT INTO big_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kapura ini wireyeng kusawili keya kangka yeikwili. Anotogi i yemane walekmakke alatara walekta, keya piliktikki wiyeke opa alatarage ngalege wiyi piyendau walekyeng kani. ");
INSERT INTO big_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Logo yombanu nak alataragi yeiktaga ngago pugura kozang kelemi puwekke purik mabura pi weik alatara keya mabilik watabi opa alatarage ngalege wiya piyengkorau ngago pugura kozang kelemi yagenda. ");
INSERT INTO big_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Keya yombanu nak Anotogi i walek yemanemakki yeiktaga ngago nara kai puwekke purik mabura pi weik i walek yemanemak keya mabilik Anoto i pumakke yolubokkorau ngago pugura kozang kelemi yagenda. ");
INSERT INTO big_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Keya yombanu nak paka ngalegebekki yeiktage ngago nara kai puwekke purik mabura pi weik paka ngalegebekki yeikta keya paka ngalege tung mogosira keya Anoto tung purikke mogosibokki yeiktago ngago pugura kozang kelemi yagenda. ");
INSERT INTO big_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yomono, ini Mosegi loyengki waligeleyiwili keya ini Palisiwili waberek panu, purik kalike Anotogo ini yombanu kiligang neyau lewawili ngangang yanagi. Purik ini panga yawega ngeragi inigi nayeng wawiyi puwekke purik inugu Anotogi lo naragi kiriwei miza logo inugu mabiyeng sanga miza logo limak meleyau keremizi logo narik Anotoyegi waberek panu mani miziwili. Purik pangka kapura ini Anotogi lo yemane panuyeng yomizora wezameli, purik pelik, kazing yongkambanuwiliyegi pangka mizi pumok, keya kazing yongkambanuwiliyegi yalek mizi pumok, keya kazing ngiziragi ngizi panu kiriwei mizi pumok mizi onowili kani, legi kalike Anotogo iniyegi ngangang yanagi. ");
INSERT INTO big_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ini ngai wireyeng kusawili, ini Anotogi kazing pangkamek kokowa mizi legi talik miza logo inugu yongkambanuwiliyegi pumok waligeleyagi? Ini yombanu sibumek kairi pugubekka wara wezameli kapura watamek mamok kairibek kiling yeik nguk tiya melibok kelik purik ini lo songonoyengki inugu waberek kiriwei mizi mizi kapura lo yemaneyeng inugu yeik keremareke wezameli mizi. ");
INSERT INTO big_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Yomono, ini Mosegi loyengki waligeleyiwili keya ini Palisiwili waberek panu, purik kalike Anotogo ini yombanu kiligang neyau lewawili ngangang yanagi. Purik kazing kak keya pelengyeng kaigesagimek inugu waberek kiriwei mizi kapura ini yombanu kak keya pelengyengki ngalegemek keke kaigesi kapura yenge yungke sipengyeng kaigesi onobok kelikwili. Ini korik yeik yeke ngalege piyeng keke kaigesi kapura yenge wilek kang inuguyeng kazing ngowei mizi keya korikyengki keli mizi piyengko wilak panu kani. ");
INSERT INTO big_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ni Palisi wireyau kusabek, ni yenge yungke sipengyengki pakelagi langai ono ma talik? Kapura kerewiye, kakpekke yenge yungkemek were kaigese pulaga kakpekki ngalegemektau kaigese. ");
INSERT INTO big_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Yomono, ini Mosegi loyengki waligeleyiwili keya ini Palisiwili waberek panu, purik kalike Anotogo ini yombanu kiligang neyau lewawili ngangang yanagi. Purik ini yombu longyeng kelikwili kani, puwiligu yombu longyengke yengelei kabu wazonoyeng wiya logo palumu kapura yenge yungkerik yombanu ibengwiligi kozayeng keya watabi kagorik puwiligi piyengka sok putiya wala piyeng kelikwili. ");
INSERT INTO big_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kazing mabilikmekke yongkambanuwiligu iniyegi pakela logo pelik kumuli, puwili pangkawili mizi, kapura yenge inigi yungkerik ini kazing kili neyau lewa pumok mizi keya kazing kaile mizi piyengko wilak panu kani. ");
INSERT INTO big_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yomono, ini Mosegi loyengki waligeleyiwili keya ini Palisiwili waberek panu, purik kalike Anotogo ini yombanu kiligang neyau lewawili ngangang yanagi. Purik ini yombanu Anotoyaga ngagora weiya logo kozak kisawiligi longyeng yengelei simengyengkayeng keremizi keya ulogo yombanu kazing pangkamek miza logo ibengwiligi longyengki yengelei kabu wazonoyeng wiyi keya purukpuruk marekyeng ngeriyi miziwili. ");
INSERT INTO big_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Keya ini pelik kisiwili, Tamizeige teni koka tenigi yeligagangmekkawili koyima purage teni pewili koyima kesak tonugurau yombanu Anotoyaga ngagora weiya logo kozak kisawili yela logo ibeng si kak ono, kisiwili. ");
INSERT INTO big_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Logo ini makngezego kisi purikku ini yombanu Anotoyaga ngagora weiya logo kozak kisawili yela puwiligi yango keya marekngangwili ini, kisi yagenda. ");
INSERT INTO big_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mena kazing inigi yelibungangwiligu koka miza piyengki pangka inugu mizi. ");
INSERT INTO big_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ini kemale yenge kuzingikyengke yungke tagogei yeziyengko ngora nelegi kazi kangwili kelik. Ei, ini kemale Kuluwekmekki marekwili. Kapura kaile inugu mizayengki wiyeke kanga yanagiyengka ini kazi kangki langai ono, Anotogo ini yereng yezi kusagi onozik ngoriraga wezayelagi. ");
INSERT INTO big_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Togo nogo kozak yei peragi kerewiyi, Nogo yombanu Anotoyaga ngagora weiya logo kozak kisi nawili ini Yudawiliyegi wezayelagi, keya nogo yombanu Anotogi ngagora iwaka nawili keya Anotogi ngagoragi waligeleyi nawilirau wezayelagi kapura ini Palisiwili keya Mosegi loyengki waligeleyiwiligu puwiliyaga nawili yela logo ibengki, keya nawili yengeleiyengke ngalege nili ula logo ibengki, keya nawili i walek songonoyengke wizale yelagi keya nawili yeliweki yereng naraga naragi kiriwei kang keleyagi. ");
INSERT INTO big_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Koka solo panuwekka kang kayimeige yokopekke perik inigi yelibungangwiligu Anotogo yombanu pangka wezayela puwili mabuwili yela. Solo panu ulabek yombu pangkabek Abele meiyabek keya piyaga uli kayimeige Perekayagi marekpek Sakaraya i walek yemanemakka alataragi keya walek panumakkirau tepekke ula kapura ini kele weik mazenda kaile ngalege panu narik miziweki mereke logo purik ini weik ne neliweki mizi, legi purikki wiyeke ini Palisiwili keya Mosegi loyengki waligeleyiwili ngangang inugura keya inigi yelibungangwiligi purarau ini kemenak weiyagi. ");
INSERT INTO big_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ei, piyeng mabiyengki ngangandik ini yongkambanu Yuda perage pewili wagelagi kani, Yisugu puwiliyegi pilik yeiya. ");
INSERT INTO big_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Pulaga Yisu yereng Yirusalem puragi kumula logo yongkambanu pulogo yolu puwiliyegi yalek miza logo ingi ngaungaumek kiling pelik kai, O ini Yirusalem yerendaga yoluwili, inugu yombu Anotoyaga ngagora weiya logo kozak kisiwili keya inugu Anotogo yombu iniyegi wezayeliwili kiyengko yeli mizi. Keya winakmokko luguwili yenge sabengyauge kiliya wazayi pilik, kang kolokngagono nogo iniyegi waberek ngaiweki miza kapura inugu neyegi kezanga nana. ");
INSERT INTO big_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kerewiyi, Anotogo weik ini wezaya, i yombu naktau onomak kelik keya yombanu ini kiling ngai kelagiwili lewa puwekke Anotogo iniyegi sawelagi ono. ");
INSERT INTO big_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Purik nogo iniyegi pera pelik yei, Inugu ngereke neyegi pakelagi ono wiziya ne wameik yombu Anotogo iniyegi wezanelabok mizi puwekke inugu pelik kisagi, Pok Anotogo teniyegi wezamelabek legi Anotogo pi kozanda maniweki, kisi puwekke inugu ngereke neyegi pakelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pulaga Yisu Anotogi i walek yemanemak wiya logo welagela tagoneige yombu pugu waligeleyiwili piyegi kanda logo puwiligu pi Anotogi i walek yemanemak kailemekkimaktikki kozak meiya. ");
INSERT INTO big_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Legi Yisugu puwiliyegi pelik yeiya, Ei, nogo pakela, kapura nogo iniyegi pera pelik yei, I yemane inugu pakeli pemak mamak wok nakke yombanu Yudawiliyegi ngai miziwiligu yo wela melagi keya kingyeng sugusugu miza melagi, king neyau pulogo menalege nakki ngalege nak wiziyagi ono, puwiligu yowela melagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kalike Yisu lewak yengelei Olip meilei lewi logo lewak Olip meibekke mogosa tawizeige yombu pugu waligeleyiwili piyegi keke liwik kanda piyegi pelik meiya, Tonuwayegi kozak yei, puwiligu Anotogi i walek yemanemak yowela melagi purik talikwekke pilik mizagi? Keya kazing talikmokko ni weik yogirikki tonuwayegi waligeleyagi keya kazing talikmokko ngabelakpek weik yeikkirikki tonuwayegi waligeleyagi, puwiligu piyegi pilik nguk meiya. ");
INSERT INTO big_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Legi Yisugu puwiliyegi pelik yeiya to mela, Watabi lewagelagi piyengki nogo kozak yei pei. Inuwa yombu inuwayegi ngaigu kisi puwiliyegi kiriwei miza nagani, waberek panu. ");
INSERT INTO big_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Purik yombanu kolokngagono yeik nogorage lewagi kani logo pelik kisi wiriyi nangai, Ne Kilisibek, kisa logo yombanu kolokngagonowili puwiliyegi kiriwei kuni nangai. ");
INSERT INTO big_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Keya inuwa ngai mereke keli piyeng keya ngai yemane koweige keli lewa piyengki kerewiyi purik kulili mizi nagani. Watabi pilik piyeng mabiyeng were lewagelagiyeng kani kapura piyengko mizi purik ngabelakpek weik yeikkirikki mizi yagenda ono. ");
INSERT INTO big_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Purik were, yongkambanu ngabelak nakkewili kiling yongkambanu ngabelak nakkawili ngai kelagi, keya kapman ngabelak nakkebek kiling kapman ngabelak nakkabek ngai kelagi, keya yongkambanu ngabelak nayengkewili kiling yongkambanu ngabelak nayengkawili ngai kelagi, keya puwekkerik ngabelak nayengke ngaba ibeng yemane mizagi, keya ngabelak kolokngagonoyengke kuburuk unatuba panuyeng ulagi. ");
INSERT INTO big_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Peyeng weik solo lewagela purik weik kuneng keya ngangang yemane panu pura weik mereke lewa legi. ");
INSERT INTO big_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pulaga inuwa yeik nogoraga yawe mizirikki wiyeke yongkambanu ngabelak mabiyengke yoluwiligu inuwayegi kumbak mizagi logo puwiligu inuwa kebangkela logo inuwa ngangang keleya logo inuwa ibengweki keleyagi kani. ");
INSERT INTO big_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Puraga purik yongkambanu kolokngagonowili neyegi ngizi panu kumuli puwiligira wezamela logo kazing kaile mizi pumokki yo mizagi. Keya puwili nawiligu nawiliyegi kumbak mizagi logo yombanu puwili ngangang keleyagiwiligi meleyengke iza yani mizagi. ");
INSERT INTO big_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Keya yombanu kolokngagonowili tabunda logo nak nak ngaigu pelik kisagi, Teni Anotoyaga ngagora weiya logo pugu iniyegi kozak yeiweki wezayela, kisagi logo yongkambanu kolokngagonowiligu puragi ngizi kumula logo puwiliyegi kiriwei mizagi. ");
INSERT INTO big_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kazing korowali pilikyeng yemane ululu miza meli kanda ngabelak mabok kaileyengko kolagi logo purikki wiyeke kazing yongkambanu neyegi ngizi panu kumuliwiligu yongkambanu neyegi ngizi panu kumuli puwiliyegi kelagimek yongkambanu kolokngagonowiliyegirik weik yeik sawiyagi. ");
INSERT INTO big_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kapura yombanu kunengyeng keya ngangang wagelageya wizimowei neyegi ngizi kumuli pura kozang kebangkeli kanda wila wiyi ngizige mologabok Anotogo wik wizagomagiragi yaliya wazayagimelegabek. ");
INSERT INTO big_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Logo neyegi yawe miziwiligu ngabelak mabekke yongkambanu mabuwiliyegi ngago wazono kazing Anotogo pigi ngaimekki ngaigimekkiragi kozak yei yongomo mizagi logo ngabelak mabekke yongkambanu mamok peragi kerewiya puwekke mabura ngabelakpek weik yeikki, yeiya. ");
INSERT INTO big_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ini kapiya perik mei puwili ngago peragi solorikki kumulizo. Yisugu ngago nayendau mawinda pelik kozak yeiya, Koka walaka yombu Taniyele mei Anotoyaga ngagora weiya logo kozak kisawiliyaga nak Anotogi Kapiya Walektikke yungke Sadangki korowali Anotogi i walek yemanemak kaile kaile kelemiya melagi nayengki lende miza. ");
INSERT INTO big_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Togo wok nakke inugu Sadangki korowali Anotogi i walek yemanemak kaile kaile kelemiya melagi piyengko Anotogi i walek yemanemakke wiziyagi onorikke wizilege pakeli puwekke purik mabura ngago peragi kumula logo pelik kisizo, Teni ngabelak Yudaya mei pobok wiya logo kazi paka lewakyengke liwik siweki kangweki, kisizo. ");
INSERT INTO big_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Keya imakka welagelabok ngereke yeke ige yongorik watabi puguyeng oroweiweki wawari yongo nagani, yeik kunimo mei. ");
INSERT INTO big_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma yombanu panga yawege yawe mizageya wiziyabok kik kalok pugugik weiweki yo kowiti nagani, yeik kunimo mei. ");
INSERT INTO big_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Togo wok piyengke yongok mandik kogo puwili keya yongok mandik yebili yani puwiliyegi ne yalek panu mizagi, purik puwili nguk namizi paka lewakyengke liwik siweki kunagi langai onowili legi. ");
INSERT INTO big_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Keya inugu kumularik teni kabelakta kililiwekke ma wok Sabatpekke kazi kangki onorikki kumuli nelegi ini Anotoyegi watabi kuneng keya ngangang peyeng teng kilili kelirage ma wok Sabatpekke wiriyiweki kelemiya nelegi puragi waberek mizizo. ");
INSERT INTO big_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Purik wok piyengke kuneng korowali yemane panuyeng keya ngangang yemane panuyeng lewagelagi logo koka walaka solowekke Anotogo watabi keremizawekka wizageya kayimeige mabek pewekke pilik nayendau lewagela ono keya kalike ngereke pilik nayeng lewagelagi ono. ");
INSERT INTO big_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Keya Anotogo wok piyeng ngerewalek sa wazamiya ono kesak nak wik yolugi ono. Kapura yongkambanu Anotoyegi sawela logo pugu iza puwiliyegi pugu kumula logo puwiliyegi wiyeke Anotogo wok kunengyeng ngela logo ngerewalek sa wazamiyagi. ");
INSERT INTO big_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Togo tamizeige nak iniyegi pelik kai, Pakeli, Kilisibek, Mesiya teni yaliya wazayiwekibek weik lewa, kai mabura piyegi ngizi panu kumuli nagani. Ma nakko iniyegi pelik kai, pi panga pulogo yolubek, kai mabura piyegi ngizi kumuli nagani. ");
INSERT INTO big_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Purik yombanuwili tabunda logo nak nak ngaigu pelik kisagi, Ne Kilisibek, neyegi kiriwei koli, kisagi. Keya nawilirau kanda ngaigu pelik kisagi, Anotogo teni wezayela logo tonugu ngago piyaga weiyara iniyegi kozak yeiweki, kisagi. Keya ini puwili Anotoyaga kayima nobiyeng mizibene keleyiweki puwiligu watabi Anotogo keke miziyeng mizi keya wirangai nayeng mizi nangai. Logo tamizeige puwili pangka kesak puwiligu yongkambanu Anotogo piyegi saweliweki iza puwiligi neyegi ngizi panu kumuli pura wiyibene keleyiweki mizi nangai. ");
INSERT INTO big_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kerewiyi, nogo weik watabi piyeng ngoluk lewagela ono wizigeya kozak yei yagenda logo ini ngai panu koyiweki. ");
INSERT INTO big_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ma ngereke tamizeige yongkambanu nawiligu pelik kisi, Kilisibek paka kurung yeikwekke yolu mena pakeli koli, kisi purik mabura pulogo pakeli kang nagani. Ma tamizeige nawiligu pelik kisi, Kilisibek pelege liwik sa yolubek mena pakeli koli, kisi purik mabura puragi ngizi kumuli nagani. ");
INSERT INTO big_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Purik lengka wililiktikku mizi puwekke purik paka ngilumbek mabok pangazuwaga pezuwage ngela manirikki teni mabuwiligu pakeli mizi. Kazing mabilikmekke ne yombanu paka ngalega kayimabek ngereke yogi logo puwekke mabuwiligu neyegi pakelagi kani. ");
INSERT INTO big_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Keya peyeng lewagelagirik wale watabi ibeng piyengki korik sokyeng wizilege winak Yezigokwiligu kanda pura menalege niweki wawere ulageya pulogo. Keya kazing mabilikmekke yereng yongkambanu kazing kumbekki Anotoyegi leweng ibengwili koyagi pulogo Anotogo ngangang yaniweki lewagi. ");
INSERT INTO big_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Togo wok kuneng korowali yemane panu piyeng keya ngangang yemane panu piyeng lewagelagiyeng miza logo pulaga nguk namizi yokmek kusa sagi keya ngombek ngele managi ono. Keya paka ngilumbekke watabi kozang piyeng urukang mizagi logo pelewewili paka ngilumbekka tiya walagi. ");
INSERT INTO big_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pulaga kazing ne yombanu paka ngalega kayimabek weik yogirikki waligeleyi pumok paka ngilumbekke lewagela wiriyi penanging puwekke purik yongkambanu ngabelakpekke neyegi kumuli ono wiza kambeli pemek mamok ingkisagi keya puwiligu ne yombanu paka ngalega kayimabek ngereke kozainumbekke kozanda keya ngaiwak unatubarik kiling tabunda lewarikki pakelagi. ");
INSERT INTO big_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Keya sangubek unatuba kaiya melageya keya nogo negi angelawiliyegi pelik yeiyagi, Ngabelak mabiyengki kunizo. Iniyaga nawili ngabelak panga yokmek lewagelayengki kunizo, keya nawili ngabelak panga yokmek kiliyayengki kunizo, keya nawili ngabelak paka yongoleigeyengki kunizo, keya nawili ngabelak pongo moleigeyengki kunizo, yeiyagi. Logo puwili kunagi logo yongkambanu Anotogo iza logo puguwili kaiya puwili wawere ula logo neyegi iza orowei lewaweki. ");
INSERT INTO big_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ini ngago saweliwei peragi iwaka sizo. Kusayeng kabeneng panu keya kilili keya kebarek yemane uli puwekke ini iwaka yokpek seliweki mereke mamizi. ");
INSERT INTO big_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kazing mabilikmekke inugu watabi nogo iniyegi kozak yeiya piyeng mabiyeng weik mizirikki pakeli puwekke purik mabura negi yogirik weik mereke panu mamizagi purik inugu iwakagi. ");
INSERT INTO big_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Wameik panu, yombanu ini Yudawiliyegi ngai mizi puwiligu ini mabuwili neneng ngeliweki lewagi kapura ini kemenak neneng ngelagi ono. Iniyagawili ngoluk yolugi logo nawiligu watabi nogo kozak yeiya peyeng mabiyeng ngizi lewagelagirikki keriyagi. ");
INSERT INTO big_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ngilumbek keya ngabelakpek yeik sagi kapura ngago nogorarau yeik sagi ono, ngago nogora wizagomagi. ");
INSERT INTO big_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ne yogirik wok takka ma yokmek talikwekke miza purik nakko iwaka ono, keya Anotogi angela paka ngalege yoluwili mabilik iwaka ono, ma ne, Anotogi Marekpektau mabilik iwaka ono, Anoto, negi Mangobek ngezebokko keke iwaka. ");
INSERT INTO big_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ne yombanu paka ngalega kayimabek ngereke yo puwekkerik yongkambanuwili ngereke koka walaka kazing yongkambanu Nowagi tendaga koya puwiligu mizageya koya mabilik mizi nangai. ");
INSERT INTO big_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nowa wiziya puwekke yongkambanuwili Anotoyegi langai kumula ono keya Nowago ngago watabi lewagelagi piyengki langai kai piyengki kerewiya ono logo watabi ngezewiligiyengki mizageya koya. Logo puwili ngeragi ni keya kai ni keya yongkambu wei keya panu keya mangogo kolomele yombu weiyagi nakyegi miza mani kaiyageya koya ");
INSERT INTO big_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","weik wok Nowa yeke sikmakke kiliya lagibekke logo kai ngai yemaneyaugu kanda yongkambanu nawili mabuwili yela. Puwekke puwiligu pilik miza pilik ne yombanu paka ngalega kayimabek lewa puwekkeriktau yongkambanuwiligu kazing mabilikmekke mizagi. ");
INSERT INTO big_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wok ne yo lewagibokko yombanu neyau panga yawege menalege yawe mizageya koyagi, logo neyegi ngizi kumulibok angelawiligu miza orowei kangki kapura nak mabulogo yawe mizageyara wezamiyagi kani. ");
INSERT INTO big_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yongok neyau yeke ige menalege yawe mizageya koyagi, logo neyegi ngizi kumulimolo angelawiligu miza orowei kangki kapura namele mabulogo yawe mizageyara wezamiyagi kani. ");
INSERT INTO big_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Togo wok takka ma yokmek talikwekke ne, Yemizi inugubek yo lewagi miza purikki ini lusuwei legi waberek panu. Neyegi ngai yuke koyizo. ");
INSERT INTO big_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kapura nogo ngago saweliwei kozak yei peragi solorikki iwaka panu, tamizeige yombu i namakke mangobokko yombu ngoweiyagibek lewagi pura iwaka purik pi wirere yolugi logo yombu ngoweiyagibek yeke ige watabiyeng ngoweibene kelemiyagi ono. ");
INSERT INTO big_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pilik tegi inirau kazing pilikmekke wirere kangkere miza koyizo. Purik ne yombanu paka ngalega kayimabek inugu lewagi ono miza purage ngereke lewagibek kani, legi ini kangkere miza koyizo. ");
INSERT INTO big_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ne kang logo inuwa yawe nogora pangka iwaka keya mizi wilibekwili mizagi ma talik? Inuwa yombu yawe mizi pangka panu kazing pangkamek keya iwakamekke mizi logo ngai yemanebokko nawiliyegi ngai wazamiyabek kelik miziweki. Ngai yemanebokko yombu yawera pangka mizibekyegi pakeli puwekkerik pugu piyegi pelik meiyagi, Ne weik kang keya nogo ni ngai wazani keya yombu negi yawe mizi nawiliyegirau ni ngai wazaniyagi keya ni ngeragiyeng puwiliyegi yanagibek, pilik meiya logo ngai yemanebek kangki. ");
INSERT INTO big_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kambela logo kalike yowekke tamizeige pugu yombu ngai wazamiyabok yawe pugu kozak meiya pura mizageya wizilege pakela purik ngai wazamiyabok wilikwilikmokko unatuba panu mizagi. ");
INSERT INTO big_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Purik ngai yemanebokko pelik meiyagi, Ni yawe wazono mizibek keya ngoluk yombu negi yawe mizi nawiliyegi ngai keya weik watabi negi piyeng mabiyengkirau waberek ngai wizeimo, meiyagi. ");
INSERT INTO big_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kapura tamizeige yombu ngai wazamiyabok kaile logo pelik kumuli, Ngai yemane nogobek ngoluk lewa ono, watabi nayengko waliya logo pi nguk namizi lewagelagi ono mena, miza logo ");
INSERT INTO big_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","pi weik yongkambanu yawe miziwili yeli keya keleyi keya yombanu kai nameli keya miza meliwili kiling pirau ngeragi kolokngagono ni keya kai nameli keya miza mela purik mabura ");
INSERT INTO big_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kalike ngai yemane pugubek wok nakke lewagi purik wok ngai wazamiyabek piyegi yukegi ono, kapura wok pi lewagi ono, mizabokko ngai yemanebek weik lewagi. ");
INSERT INTO big_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pi weik lewa logo pugu ngai wazamiyabekki kazing kaile mizimekki pakela logo piyegi ngangang yemane kelemiya logo pi pongo lemengke yongkambanu kiligang neyau lewawili kiling wezamelagi logo pulogo puwili ingkeya kelele yemane panu kisi keya kili puwiligiyeng ngiliti mizagiyagi. ");
INSERT INTO big_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ne yo puwekke kazing Anotogo ngai pugumekki ngaigi pura talik miza purikki nogo iniyegi ngago saweliwei nara kozak yeiweki mizi. Inugu ne yogirikki yuke yolugira yongok nawekke yawe mizi yombu nak yongok weiweki mizibekyegi yuke yolu puwili kelik. Yombubok pigi yongok sawiyamelegi imakke lewa wizigeya yongok nawekke meleyau imakke mangobekyegi yawe miziwili lam puwiligiyeng kiling yombu yongok weiyagibek panga kazingke yoromaure miza logo panga ige miza oroweiweki kambela. ");
INSERT INTO big_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yongok yawe miziwiliyaga melenazik kangkayeng kilingwili keya melenazik kangkayendau onowili. ");
INSERT INTO big_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kolomandik kangka yeik puwili lam puwiligiyeng wara kapura puwili kai nayendau mela wara ono, ");
INSERT INTO big_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kapura kolomandik kangkayeng kiling puwili lam puwiligiyeng keya palastik kai nayendau wilak pela wari miza. ");
INSERT INTO big_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yombu yongok weiyagibok nguk namizi lewa ono logo kolomandikwili wirekne miza logo iwek kola. ");
INSERT INTO big_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Puwili iwek kola koyigeya kusa libuge weik pelik kek kisi, Aik, yombu yongok weiyagibek wei lewa mena pi yoromaure miziweki kunizo, kisi. ");
INSERT INTO big_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pilik kisi legi kolomandik meleyau yawe miziwili yangalek meiya logo lam puwiligiyeng ngaiwak wiyibene wikyeng ngalege kelemiweki kelemiya. ");
INSERT INTO big_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pulaga kolomandik kangka yeik puwiligu kolomandik kangkayeng kiling puwiliyegi pelik yeiya, Lam tonuwagiyeng kaiyengki yeik wizigeya kusa mena inuwago tonuwa kai nayeng pela yani, yeiya. ");
INSERT INTO big_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kapura kolomandik kangkayeng kiling puwiligu pelik kanga yeiya to mela, A’a’, kai peyeng lam tonuwagiyengki pangka logo kokowa nayendau ono mena panga sutuwamakka kai nayeng inuwa ngezegi wawari kambeli, yeiya. ");
INSERT INTO big_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tegi kolomandik kangka yeik puwili panga sutuwamakke kanda kai nayeng wawari kambela. Puwili yagonei keya yombu yongok weiyagibek tabunda logo kolomandik melenazik kangkere mizara pulogo yuke koya puwili pi kiling yeke ige ngeragi yongok weiweki nirage la logo imakki kandik weik waliya. ");
INSERT INTO big_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Togo waleleige kolomandik melenazik yaka kai nayeng wawari tobela puwili lewagela logo puwiligu kandik waliyarikki pakela logo puwiligu pelik ngalizi kek meiya, Yemizibek. Yemizibek, kandik tonuwayegi tiya yowiye, meiya. ");
INSERT INTO big_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kapura yombu yongok weiyagibokko pelik yeiya to mela, Wameik panu, ne inuwayegi lusuwei, yeiya. ");
INSERT INTO big_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kazing mabilikmekke wok takka ma yokmek talikwekke ne yombanu paka ngalege kayimabek ngereke yogi miza purik ini lusuwei legi ini kangkere mizizo logo neyegi ngai yuke koyizo. ");
INSERT INTO big_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nogo iniyegi ngago saweliwei perarau kazing Anotogo ngai pugumekki ngaigi puragi kozak yeiweki mizi. Anotogo ngai pugumekki ngai yolu pura yombu nak yereng pugura wizamiya logo kabelak koweige narage kangweki mizibok kelik. Pi kangkine were yombu piyegi yawe miziwiliyegi ngago yeiya logo pugu puwili watabi puguyengki ngai wazaya. ");
INSERT INTO big_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pugu puwiligu kazing miziyengki pakela logo pugu nak nakyegi kangka puwiligiyengke pangka pangka kingyeng yana. Logo nakyegi king tausen Kina melenazik mana, keya nakyegi king tausen Kina neyau mana, keya nakyegi king tausen Kina wamenak mana. Keya pugu yanageya wizimowei pelik yeiya, Ne kang keya inuwa nak nak king nogo yana piyengki pangka pangka yawe kingyeng ulumiyagi nara mizizo logo pulaga ne yo puwekke nogo inuwa king talik talik piyengka yeke langak negi keremiza miza purikki nogo pakelagi, yeiya logo pi weik kambela. ");
INSERT INTO big_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pulaga yombanu yawe mizi yaka king tausen Kina melenazik manabok yawe nara mizi kanda king yaka mana piyengko ngereke king tausen Kina melenazik mabilik ulumiya. ");
INSERT INTO big_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kazing mabilikmekke ngaibokko yombanu yawe mizi yaka king tausen Kina neyau manabok yawe nara mizi kanda king yaka mana piyengko ngereke king tausen Kina neyau mabilik ulumiya. ");
INSERT INTO big_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kapura pugu yombanu yawe mizi yaka king tausen Kina wamenak manabok pi kingyeng pangka ono mizarikki wiyeke kanda kawiktik yokora logo ngai pugubekki kingyeng liwik mowiya. ");
INSERT INTO big_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Teng yokolong nara wizagoma logo pulaga yawe miziwiligi ngaibek ngereke yo. Pi kanda yombu pugu king yanawiliyegi ngago yeiya logo ngago yawe puwiligiyengkiragi kerewiyiweki. ");
INSERT INTO big_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yombu yawe mizi king tausen Kina melenazik manabokko kanda pigi ngaibekyegi pelik meiya, Yemizibek, king tausen Kina melenazik nugu koka neyegi nanayeng pelegi mena ya. Keya pakele, nogo mabilik king tausen Kina melenazik ulumiya piyeng mena ya, meiya. ");
INSERT INTO big_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tegi ngai pugubokko pelik meiya, Wazono panu, ni yawe wazono mizibek keya ni yombu yawe nugura pangka mizi wilibekpek. Ni watabi songono pilikyengki ngai waberek panu miza legi nogo ni watabi yemane panuyengki ngai wazaniyagi mena ne nigi ngaibek kiling wilikwilik mizi mangaiweki mena koli, meiya. ");
INSERT INTO big_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pulaga yombu yawe mizi king tausen Kina neyau manabok kanda pigi ngaibekyegi pelik meiya, Yemizibek, king tausen Kina neyau nugu koka neyegi nanayeng pelegi mena ya. Keya pakele, nogo mabilik king tausen Kina neyau ulumiya piyeng pelegi mena ya, meiya. ");
INSERT INTO big_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tegi ngai pugubokko pelik meiya, Wazono panu, ni yawe wazono mizibek keya ni yombu yawe nugura pangka mizi wilibekpek. Ni watabi songono pilikyengki ngai waberek panu miza legi nogo ni watabi yemane panuyengki ngai wazaniyagi mena ne nigi ngaibek kiling wilikwilik mizi mangaiweki mena koli, meiya. ");
INSERT INTO big_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pulaga yombu yawe mizi king tausen Kina wamenak manabok kanda pigi ngaibekyegi pelik meiya, Yemizibek, ni yombanu yalek mizi onobek keya ni yawe mabiyeng pangka panu miziweki kai wilibekpek purikki nogo iwaka wiziga ne kulili miza. ");
INSERT INTO big_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tegi nogo yawe nara miza logo king nuguyeng yeik nelegi ne kulili miza logo ne kanda king nuguyeng kawiktikke yokora logo liwik wiya wazamiya. Mena watabi nuguyeng pelegi mena ya, meiya. ");
INSERT INTO big_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tegi ngai pugubokko pelik meiya to mela, Ni yawe korowali mizibek keya yawe namizibek. Ngago ngaigu nuguyengko mizagewiyege nogo niyegi yalek mizagi langai ono. Keya nugu kairik ne yombanu yawe mabiyeng pangka panu miziweki kai wilibekpek kai ");
INSERT INTO big_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","logo ni piliktikki iwaka mabura ni nangki king nogoyeng panga pendikke nowiyi ono, kesak waleleige ne yowekke king piyeng kiling kokowa nayendau wei kak kani, meiya. ");
INSERT INTO big_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ngaibokko piyegi pilik meiya logo yawe mizi nawili pulogo luweza koyilegewiliyegi pelik yeiya, Yombu neyegi yawe mizi pobok korowali mizarikki wiyeke mena, inugu king tausen Kina nogo mana piyeng piyaga mongoni logo yombu yawe mizi king tausen Kina meleyau kilimbok mani. ");
INSERT INTO big_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Purik yombanu nak yawe nogo miziweki manira pangka panu mizibok nogo pi ngoluk yaweyeng mawinda managi logo pugu yawe yemaneyeng weiyagi kani kapura tamizeige yawe mizi nak yawe nogo miziweki manira yawe namizi purik nogo yawe songonorarau piyaga mongonagi. ");
INSERT INTO big_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Togo yawe mizi yeik ulak pobok yenge yerengke kusabanurikke welagela wezamela logo pulogo kusabanurikkewili kiling ingkeya kelele yemane panu kisi keya kili puwiligiyeng ngiliti mizagiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kazing pilikmekke ne yombanu paka ngalega kayimabek ngaiwak nogorik kiling keya Anotogi angela walekwili mabuwili kiling King Ngaibek miziweki ngereke yo puwekke nogo yongkambanu mabuwili sanga mizagi. ");
INSERT INTO big_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nogo negi tung mogosiraga ngaiwaktik kiling mogosagi logo negi ingewerege yongkambanu ngabelak mabiyengkewili mabuwili wawere ulagi. Pulaga liyeng memengwiliyegi ngaibokko memeng puguwili liyeng Got mei pigi onowiliyaga sanga mizi pilik nogo ini yongkambanu mabuwili mabilik sanga mizagi. ");
INSERT INTO big_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nogo yongkambanu pangka nogowili mele ngaige nogozikke wazayagi keya yongkambanu kaile negi ono puwili mele koranengke nogozikke wazayi mizagi. ");
INSERT INTO big_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pulaga ne King Ngaibokko yongkambanu pangka mele ngaige nogozikke puwiliyegi pelik yeiyagi, Negi Mangobokko iniyegi wazono miza mena koli. Tung Anotogo koka solo ngabelakpek keya ngilumbek keremiza purik yereng yombiyangairaga ini ngai pugumekkiwiligi kangkere miza yowiyayeng weiweki mena ne kiling koli. ");
INSERT INTO big_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Purik peliktikki wiyeke ne yagasirikki inugu pakela logo inugu ne ngeragi nana, keya ne kai wik nagi kelirikki inugu pakela logo inugu ne kai wik niweki nana, keya inugu ne yombanu nalagabekyegi pakelawekke inugu koli, teni kiling yoluweki neiya. ");
INSERT INTO big_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Keya ne kagorikyengki yeikwekke inugu kagorik wakiyagiyeng nana, keya ne kemegeme mizawekke inugu neyegi waberek keleniya, keya ne wigirimakke wigira wiziyawekke inugu neyegi saweli kayima, yeiyagi. ");
INSERT INTO big_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kapura yongkambanu pangka puwiligu neyegi pelik nguk neiyagi, Yemizibek, talikwekke tonugu ni yagasi mizarikki keriya logo ni ngeragi nana, ma ni kai wik nagi kelirikki keriya logo ni kai wik nana? ");
INSERT INTO big_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma talikwekke tonugu ni yombu nalagabek purik keriya logo tonugu teni kiling koli keleniya, ma ni kagorikyengki yeik wiziya tonugu ni kagorik wakiyagiyeng nana? ");
INSERT INTO big_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma talikwekke tonugu ni kemegeme wiziya pakela, ma ni wigirimakke wigira wiziya keriya logo niyegi saweli wiriya, meiyagi. ");
INSERT INTO big_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pilik kisi legi ne, puwiligi King Ngaibokko puwiliyegi pelik yeiya to melagi, Nogo iniyegi wameik kozak yei, Inugu yombanu negi sak pewili mabuwiliyaga yeikta songono panu nakyegi koka watabi songono nayeng miza puwekke purik inugu neyegi miza pilik miza wizinda, yeiyagi. ");
INSERT INTO big_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Pulaga nogo yongkambanu kailewili mele koranengke nogozikke puwiliyegi pelik yeiyagi, Ini ngangang weiyagiwiligu neyaga panga yezi kusagi ono, Pebago Sadang kiling angela puguwiligi kangkere miza yowiya puzikke kazi kuni. ");
INSERT INTO big_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Purik peliktikki wiyeke koka ne yagasirikki inugu pakela kapura inugu ne ngeragi nana ono, keya ne kai wik nagi kelirikki inugu pakela kapura inugu ne kai wik nana ono. ");
INSERT INTO big_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Keya ne nalagabekyegi pakelawekke inugu teni kiling yoluweki koli neiya ono. Keya ne kagorikyengki yeikwekke inugu kagorik wakiyagiyeng nana ono, keya ne kemegeme wiziyawekke inugu neyegi sawela ono, keya ne wigirimakke wigira wiziyawekke inugu neyegi pakeli wiriya ono, yeiyagi. ");
INSERT INTO big_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kapura yongkambanu kailewiligu neyegi pelik nguk neiyagi, Yemizibek, talikwekke tonugu ni yagasi mizarikki keriya kapura niyegi sawela ono, ma talikwekke tonugu ni kai wik nagi kelirikki keriya, ma ni nalagabekyegi pakela, ma ni kagorikyengki yeikpekyegi pakela, ma ni kemegeme wiziyabek, ma ni wigirimakke wigira wiziya kapura tonugu niyegi sawela ono, pilik nguk neiyagi. ");
INSERT INTO big_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pilik kisi legi nogo puwiliyegi pelik yeiya to melagi, Nogo iniyegi wameik kozak yei, Koka inugu yombanu pewili mabuwiliyaga yeikta songono panu nakyegi sawela ono purik inugu neyegirau sawela ono wizinda, yeiyagi. ");
INSERT INTO big_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Togo yongkambanu kaile pewili yereng ngangang korowali wizagomagiragi kunagiwili kapura yongkambanu pangka puwili yereng wik wizagomagiragi kunagiwili, Yisugu puwiliyegi pilik yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Togo Yisu ngago piyeng mabiyeng waligeleya logo pulaga pugu yombu pi ngezebokko waligeleyi puwiliyegi pelik yeiya, ");
INSERT INTO big_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Wok neyau miza logo teni Yudawiligu wok Pasobabek meibek ngeragi yemane miza nageya koyimowei walaka Anotogo tenigi yelibungang kokawiligi iyengki kangyengke iwirik pukmela wizilege keriya logo puwiligi koloyakamandik kalogoliwili ibengkirikka yaliya wazaya puragi kumulibek pakelagi purik teni iwaka. Keya puwekkerik nakko ne yombanu paka ngalega kayimabek yombanu yengeleileige nili ulagiwiliyegi niza yanagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yisugu pilik kozak yeiyageyarik Yudawiligi yemanewili keya yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwili mabuwili yombu Anotoyegi kolak miziwiligi ngai yemane panubek Kayapasi meibekki imakke wawere ula. ");
INSERT INTO big_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Puwili ngago kazing ikuyogorik Yisu kebangkela logo ulagimekkira kozak kela. ");
INSERT INTO big_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Puwili pelik kela, Teni Yisu ngeragi yemane miza nagi puraga kebangkelagi ono, purik yongkambanuwili sisik miza logo teniyegi ngai mizane, kela. ");
INSERT INTO big_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yisu paka Petani yerengke yombu Saimon meibek kiling wiziya. Saimon ulogo kemegeme korikwek sok mizi Leposimek meimok mizabek kapura weik wazono. ");
INSERT INTO big_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yisu pulogo tawizeige yongok namele weli kelebak wazono kukngizi keli, king yemane wezamela nak kiling piyegi wiriya. Kanda Yisu ngeragi nageya tawizeige yongokmologo welibek yeke kebi Yisugirage kubula mela. ");
INSERT INTO big_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yombu Yisu ngezebokko waligeleyiwiligu yongok yakamologo pilik miza purikki pakelawekke puwili sisik miza logo nakko nakyegi pelik nguk meiya, Weli kukngizi kelibek yeik ulak kubula melira nangki? ");
INSERT INTO big_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Purik tamizeige tonugu welibok yombu nakko kingyengki ngane weiya kesak king yemane weiya logo yongkambanu watabiyengki yeik puwili yani kak, kisa. ");
INSERT INTO big_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yisugu puwiligu kozak keli puragi iwaka wizigeya puwiliyegi pelik yeiya, Inuwa yongok pemeleyegi kuneng manira nangki? Pi neyegi yombiyangai mizi keya wazono mizi miza wizinda. ");
INSERT INTO big_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Purik ini koyimowei purik wok mabiyeng yombanu watabiyengki yeik puwili yanageya koyimagi langai kapura ne wok mabiyeng ini kiling pelege wizagomagi ono kopong inuwago wok mabiyeng neyegi keli inuwagira walimizageya koyimagi langai ono. ");
INSERT INTO big_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Logo yongok pemologo weli kukngizi kelibek negi ngalege kubula purikku korik nogowek kawiktikke waliyiweki kangkere keleni yagenda. ");
INSERT INTO big_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kerewiyi, ngabelakpek mabokko puwiligu Anotogi wazono neyegi langai pura kozak kisagi logo puwekke purik puwiligu yongok yakamologo wazono miza puragirau kozak kisagi logo yongkambanu puragi kerewiya puwiligu piyegi kumulibene, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pulaga yombu meleyau keya pongo ingenazikka neyau Yisugu waligeleyiwiliyaga nak, Yuras Isaliyoto meibok, yombu Anotoyegi kolak miziwiligi ngaiwiliyegi kambela. ");
INSERT INTO big_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Pi kanda pugu puwiliyegi pelik nguk yeiya, Tamizeige nogo Yisu mele inuguyengke miza yaniwekkerik inuwago king talik talik ne nanagi? Pilik kai legi puwiligu king siliba ngele neyauganarik mana. ");
INSERT INTO big_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Togo puwekkarik Yuras weik kazing liwik Yisu yombu ulagi puwiliyegi miza yanagi namekki weik welageya wiziya. ");
INSERT INTO big_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pilik mizageyara wok Yudawiligu perek ngeragi Yis meiriktau onoyeng keremiza logo nagibek weik lewagela. Wokpokko yombu Yisu ngezebokko waligeleyi puwili piyegi kanda logo pelik meiya, Teni talege kangki keya i takkimakke ngeragi nugu Pasobaragi kumuliweki nagiyeng ngayek mizagi keli, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tegi pugu pelik yeiya to mela, Paka Yirusalem yerendage kiliya kuni logo yombanu nogo iwakabokyegi kanda logo piyegi pelik meizo, Kiriwagabokko kaira, Teng ne ibengkira weik mereke lewa, legi ne kiling yombu nogo waligeleyiwili ngeragi yemane miza ni Pasobara mei pura i nugumakke niweki mizi meizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Togo yombu pugu waligeleyiwili kambela logo Yisugu yaka kaiya pilik miza logo weik i pumakke ngeragi Pasobaragi kumuliweki nagiyeng ngayek miza wiya. ");
INSERT INTO big_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pilik miza logo yokmek kiliya pura Yisu kiling yombu meleyau keya pongo ingenazikka neyau pi ngezebokko waligeleyiwili weik i pumakke kanda logo lalektaga niweki mogosa. ");
INSERT INTO big_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Togo puwili ngeragi nageya koyimowei Yisugu puwiliyegi pelik yeiya, Wameik, inuwayaga nakko ne panga yombanu nelagiwiliyegi niza yanagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pilik kai legi yombu pugu waligeleyi puwili ngago puragi kerewiya logo ya kuneng panu miza logo weik nak nak piyegi nguk mei kuna, Yemizibek, nogo ma talik, mei kuna. ");
INSERT INTO big_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tegi pugu puwiliyegi pelik yeiya to mela, Yombu ne kiling mele pereksik kebangkelizik peleng ngeragi kolokpek kilingwekke yenge yungke pukmelibok ne yombanu nelagiwiliyegi niza yanagibek. ");
INSERT INTO big_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ei, wameik panu, ne yombanu paka ngalega kayimabek ibengki Kapiya Anotogi Walektikku kaiyalik, kapura yombu ne yombanu nelagiwiliyegi niza yanagibekyegi yalek unatuba keli, purik Anotogo pi ngangang yemane panu managi. Yombanubokki panumologo pi wazamiya ono kesak piyegi yombiyangai panu, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Logo Yuras yombu Yisu yombanu ulagiwiliyegi miza yanagibokko Yisuyegi pelik nguk meiya, Kiriwagabek, wameik panu nogo ma talik? Pilik kai legi Yisugu pelik meiya to mela, Ni makngezego pilik kai, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Togo puwili ngeragiyeng nageya koyigeya Yisugu pereksik weiya logo Anotoyegi wazono meiya logo sikila logo yombu pugu waligeleyi puwili yanageya wizimowei pelik yeiya, Ya, weiya logo ni. Pobuzikku walimizi purik korik nogowekki walimizi yagenda mena ni, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Togo pulaga kalike pugu kai waing kakpek weiya logo Anotoyegi wazono meiya logo yombu pugu waligeleyiwili yanageya wizimowei pelik yeiya, Ya, weiya logo ini mabuwili ni, ");
INSERT INTO big_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","purik kai waing kak pobokko walimizi purik iwi nogobekki walimizi yagenda. Pokko walimizi purik Anotogo yongkambanu kolokngagonowiligi kaileyeng tumula logo kemenak ibengkiraga yaliya wazayagi puragi langai ngago wik silok tiya pura ngelagi ono, kapura negi iwi kubula walagibokko kozang kelemiyagi. ");
INSERT INTO big_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kerewiyi, nogo mawinda waimbek nagi ono wiziya kazing wikmekke yereng wazono negi Mangobokko pigi ngaimekki ngai purage ne inuwa kiling ngereke nagine, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Togo pulaga puwili Anotoyegi Ingi Sam narik ingi meiya logo pulaga puwili imakka welagelarik lewak Olip meibekke kambela. ");
INSERT INTO big_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Keya puwili lewak Olip meibekke kunimowei Yisugu puwiliyegi pelik yeiya, Anotogi Kapiya Walektikke yungke pelik kai, Anoto ngezebokko liyeng memengwiliyegi ngaibek ulagi logo liyeng memeng kabe namek mamok kazi luwa ula melagi, kai. Togo mabek kusarikke ngago pura ngizi mizagi, purik neyegi lewagelagi puragi wiyeke inuwa mabuwiligu neyegi ngizi kumuli pura kawiye walagi logo inuwa kazi kunagi. ");
INSERT INTO big_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kapura ne ngereke wik yangalek meiya logo pulaga purik ne were ngabelak Kalili meibekke kangki logo inuwa kalika lewagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kapura Pitago Yisuyegi pelik kozang meiya, Niyegi lewagelagi puragi wiyeke puwili mabuwili kele ni wezani kunagi kapura nogo niyegi ngizi panu kumula pura kawiye walagi ono logo nerau ni wezani kunagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pilik kai legi Yisugu Pitayegi pelik meiya, Kerewiye, nogo wameik panura kozak nei, mabek kusage winak talekmek kaiyagine ni were kang neyauganara yeik nogora liwik wiyagi logo ni neyegi lusuwei panu kaiyagi kani, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kapura Pitago pelik meiya to mela, A’a’. Puwiligu ne nelagi puriktau ngoluk ne niyegi lusuwei kaiyagi ono, meiya. Keya Yisugu waligeleyi nawiligurau mabilik kisa. ");
INSERT INTO big_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Togo pulaga Yisu kiling pugu waligeleyiwili Lewak Olippekke yawe Kesemani meileige wiriya logo Yisugu puwiliyegi pelik yeiya, Pelege mogosa koyi ne pangazuwa nangezi Anotoyegi waberek mizigeya, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Togo yombu pi ngezebokko waligeleyiwiliyaga neyauganak Pita keya Sebetigi marekyau Jems keya Yowan iza orowei kuna. Logo weik ya pugura kuneng keya wilek kang pugubek kuneng yemane panu keli. ");
INSERT INTO big_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tegi pugu purayegi pelik yeiya, Wilek kang nogobek kuneng panu logo ne ibengki langai pilikmekki keli mena, inuwa mabelege koyimowei neyegi wirere ngai yuke koyi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pilik yeiya logo pi panga keke nangezi kuna logo pulogo ngezebek panga ngabelakke ulu wala logo Anotoyegi pelik waberek miza, O Peba nogobek, tamizeige pangka purik nugu neyegi ngangang wiriyagi pura keya ibengki pura yeik sa wazamiye kapura keli nogoraga mizi nagani, pilik segeya keli ni makngezegiragi kiriwei mizimo, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pilik waberek miza logo Yisu yangalek meiya logo pi yombu pugu waligeleyi neyauganakwiliyegi to kuna logo morok iwek koyilege pakela. Tegi pugu Pitayegi pelik meiya, Pita ni iwek kola yolura nangki? Ni tek nangezi wirere wiziya logo neyegi ngai yuke wiziwekirik pangka ono ma? ");
INSERT INTO big_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Wirere ngai koyimowei waberek mizizo. Inuwayegi yang keleyiweki lewagi piyengko inuwa kawiye walibene keleya nelegi waberek mizizo. Wameik panu, wilek kang inuwagiyengko mizagi keli kapura korik inuwagiyeng kozang panu ono, kuzige, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Togo pi ngereke panga keke kuna logo Anotoyegi waberek miza logo pelik meiya, O Peba nogobek, tamizeige nugu neyegi ngangang wiriyagi pura keya ibengki pura yeik sa wazamiyagi ono mabura nogo wagelagi, kapura nugu keliragi kiriwei mizimo, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pilik miza logo pi panga ngezebekko waligeleyiwiliyegi to kuna kapura puwili iwek koyilege purik puwili wireyeng kuneng panu kopong iwek kola. ");
INSERT INTO big_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Togo pi kang neyauganara panga keke kuna logo Anotoyegi yaka nguk meiya mabilik waberek miza. ");
INSERT INTO big_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pilik miza logo yowekke puwili iwek kola koyilege legi pugu puwiliyegi pelik yeiya, Inuwa ngoluk iwek kola keya ngoluk mabilik kumana yolu. Kerewiyi, teng nogora pugu ne yombanu paka ngalega kayimabek yombanu kailewiligi meleyengke niza yanagira weik lewa. ");
INSERT INTO big_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pakeli, yombanu ne nelagiwiliyegi niza yanagibek pelege weik lewa. Luwezi, tonuwa piyegi kambi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisu ngoluk ngago kaiyageya wizigeya Yuras, yombu meleyau keya pongo ingenazikka neyau Yisu ngezebokko waligeleyiwiliyagabok wiriya. Pi kiling yombanu kolokngagono lang keya kilikkilikyeng orowei lewa logo puwili Yudawiligi yemanewili keya yombu Anotoyegi wata kolak kelibene waliya maniwiligi ngaiwiligu wezayelawili. ");
INSERT INTO big_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yombu Yisu miza yanagibokko yombanu lang keya kilikkilikyeng warawiliyegi yaka pelik yeiya, Yombanu nogo negi kewengke wezalikpek songok kulibok, Yisu kani logo inugu pi kebangkelizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Togo Yuras lewagelawekke, pi Yisuyegi nguk namizi wiriya logo pelik meiya, Kiriwagabek, kusa, meiya logo pugu Yisu songok kula. ");
INSERT INTO big_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tegi Yisugu piyegi pelik meiya, Negi kewengkebek, yawe nugu miziweki mizi pura ngezangai mize, meiya. Togo pulaga puwili Yisu kozang kebangkela. ");
INSERT INTO big_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mabuwekke nguk namizi Yisu kiling puwiliyaga nakko lang yokolong puguwek pugusa logo yombu Anotoyegi kolak miziwiligi ngai yemanebekyegi yawe mizibek ula logo pigi kerelik namek peto moleige wezamela. ");
INSERT INTO big_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pilik miza logo Yisugu yombu pilik mizabokyegi pelik meiya, Lang nuguwek meli pulumengke langwek mela to mele, logo ngai mizi nagani purik yombanu lawekko ngai mizi puwili wangki lawekko yela logo ibengkiwili. ");
INSERT INTO big_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kapura nogo kumularik ni ngoluk iwaka ono purik nogo negi Mangobekyegi nguk mei kesak pugu nguk namizi pigi angela tausen kolokngagonowili wezayela logo neyegi saweli kak. ");
INSERT INTO big_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kapura tamizeige puwiligu neyegi saweli kesak talik miza logo Anotogi ngago Kapiya Walek pugurikke neyegi langai pura ngizi lewagelagi? Tegi kazing pilikmekke pilik mizi pani, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Togo pulaga Yisugu yombanu pi miza orowei wiriyawiliyegi pelik yeiya, Ini mabektik ne yombanu ngowei wezalik pekyegi lang keya kilikkilikyeng kiling ne niza wari yawerenda. Wok mabiyeng ne Anotogi i walek yemanemakke mogosa wizimowei yongkambanuwiliyegi waligeleya kapura inugu ne kebangkeliweki miza ono. ");
INSERT INTO big_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kapura peyeng mabiyeng mizi yagenda logo ngago yombanu Anotoyaga ngagora weiya logo kozak kisawiligu Anotogi Kapiya Walektikke yenge yungke lende mizara weik ngizi panu lewageliweki kani, yeiya. Pulaga Yisugu waligeleyiwili mabuwili pi wezamiya logo kaziwei kambela. ");
INSERT INTO big_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Togo yombanu kolokngagono yaka Yisu kebangkela puwiligu pi miza orowei yombu Anotoyegi kolak miziwiligi ngai yemane panubek yeikta Kayapasi meibekki imakki kuna. Pulogo Yudawiligi yemanewili keya Mosegi loyengki waligeleyiwili menalege koyilege. ");
INSERT INTO big_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kapura Pita ngereke yorik Yisuyegi kalika koweige kiriwei kuna. Pi yaka ngai yemane panubokki imakke yerengke yabela logo pulogo pi wagelawili kiling mogosa wiziya, talik mizi miza legi pakeliweki. ");
INSERT INTO big_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Weik yombu Anotoyegi kolak miziwiligi ngai puwili keya Yudawiligi yombu ngagozak ngezewiligiyeng kerewiyiwili mabuwili watabi Yisugu mizayengki yombanu nawiligu ngaigu kozak kisibene ngago yeiya. Puwili ngago Yisugu kaile miza naragi kerewiyagi keli logo Yisu ula logo ibengwekiragi yolok ngeliweki. ");
INSERT INTO big_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Keya yombu kolokngagonowili Yisuyegi langai ngaiguyeng kozak kisa kele kapura puwiligu nayeng kerewiya ono. Kalik panuge yombu neyau luweza ");
INSERT INTO big_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","logo Yisuyegi langai ngago ngaigu pera pelik kisa, Te ulogo kerewiyawekkerik pugu pelik kai, Nogo Anotogi i walek yemanemak topela logo wok neyauganakke nogo ngereke ngiziwekirik pangka, kaiyabek, kisa. ");
INSERT INTO big_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Togo yombu Anotoyegi kolak miziwiligi ngai yemane panubek luweza logo pugu Yisuyegi pelik nguk meiya, Ni nararau kozak kaiya yo meli onora nangki? Kolokngagonowiligu niyegi ngagoyeng yowa logo ni kerewiya. Puwiligu wameik kisi ma yeik? Nugu weik kai logo teni kerewiyiweki, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kapura Yisu ngago nararau kaiya ono. Ngereke yombu Anotoyegi kolak miziwiligi ngai yemane panubokko piyegi pelik meiya, Teni Anotogi wirege wiziga nogo niyegi Anoto wik yolubekki yeiktage pelik nguk nei, Nugu teniyegi, ni Kilisibek Mesiya Anotogo yawe pigi teni yaliya wazayagi pura miziweki sawiyabek ma talik? Ni Anotogi Marekpek ma yeik, purik kozak kai. ");
INSERT INTO big_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Pilik kai legi Yisugu pelik meiya to mela, Ni makngezego nebok kai yagenda. Kapura ini kerewiyi, mabek teng peraga kang purik ne yombanu paka ngalega kayimabek ngereke paka ngalegi yongorik Anoto watabi mabiyengki kozandagi mangobekki ngaigezuwage mogosa yolugi logo pi kiling ngaiweki. Keya kalike inugu ne ngereke paka ngalege kozainumbekka tabunda lewarikki pakelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pulaga yombu Anotoyegi kolak miziwiligi ngai yemane panubek pura kerewiyawekke pi sisik panu miza logo Yisugu yaka kai puragi kiyebuk legi walimiziweki melewangka ngezebekkirik koliya. Logo pugu yombu ngagozak piyengki kerewiyawiliyegi pelik yeiya, Pugu pi Anoto kiling pangka pangka kai yagenda. Teni makngezego weik kili ngezebekki panurago kairikki kerewiya legi teni ngereke ngago nararau kerewiyagi ono. Legi teni mawinda yombu piyegi ngagozak kelemiyagiwiliyegirau ngago yeiyagi ono, a’a’. Pugu pi Anoto kiling pangka pangka kairikki inuwa weik kerewiya mena ");
INSERT INTO big_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","inugu piyegi kumulagirik talik, yeiya. Pilik yeiya logo puwili mabuwiligu pelik kisa, Pi Anoto kiling pangka pangka kai legi pi weik ula logo ibengkibek, kisa. ");
INSERT INTO big_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Togo pulaga yombu ngagozak piyengki kerewiya puwiliyaga nawiligu wiregawere pugurage sibilak ngiza mana keya nawiligu wiregawere pugurage melegozok ula. ");
INSERT INTO big_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Keya nawiligu pi ulageya koyimowei pelik meiya, Ni Kilisi, nugu ni Anotoyaga ngagoyeng weiya logo kozak kaibek kai mena takko ni melegozok nela miza purik kozak kai logo tonugu ni wameik Anotoyaga ngagoyeng weiya logo kozak kaibek miziweki mena, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pilik mizageya keya Pita imakke pongo yerengke yezizikke mogosa tawizeige pura kolomandik Anotoyegi kolak miziwiligi ngai yemane panubekyegi yawe mizi namele Pitayegi kanda pugu pelik meiya, Wameik panu, nirau Yisu ngabelak Kalili meibekkabek kiling yongomo mizageya wiziyabek kani, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kapura yombanuwiligi wirege Pitago ngaigu, A’a’, nugu kozak kai piyeng nogo iwaka ono, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pitago pilik meiya logo pi yezizik wiya logo yereng puragi kandikke mereke kuna logo pulogo wiziya. Kolomandik mabilik yawe mizi namologo piyegi pakela logo yombanu pulogo mereke luwe koyilegewiliyegi pelik kozak yeiya, Yombubok Yisu yereng Nasareteragabek kiling wiziyabek kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kapura Pitago ngereke ngaiguraga pelik kaiya, Anotogi Yeiktage nogo wameik kai, Ne yombu yakabekyegi lusuwei, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Keya songono nangezi wiziya logo yombanu pulogo mereke luwe koyilegewiliyaga nawiligu Pitayegi pelik meiya, Wameik panu, nirau Yisugi yombanuwiliyaga nak, purik ngago nugurago ni welawekke wazaniya kani, meiya. ");
INSERT INTO big_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tegi Pitago pelik yeiya, Anotogi wirege ne wameik panu kai. Ne yombu yakabekyegi lusuwei. Tamizeige ne ngaigu kai purik mabura Anotogo neyegi ngangang naniweki, yeiya logo Pitago pilik yei ngizige winak talekmek kai. ");
INSERT INTO big_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mabuwekke Pita weik ulogo Yisugu piyegi pelik meiya, Winak talekmek ngago kaiyagine ni were kang neyauganara neyegi lusuwei kaiyagi kani, meiyaragi kumula logo pi kuneng yemane miza logo yenge yerengke welagela kanda ingi yemane panu keiya. ");
INSERT INTO big_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wangkoti pura Yudawiligi yemanewili kiling yombu Anotoyegi wata kolak kelibene miziwiligi ngaiwili mabuwili miza logo puwili Yisu ulagimekki kozak kela. ");
INSERT INTO big_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pulaga puwili Yisu wigira logo pi miza oroweirik Rom Kapman Yudaya ngabelakpekki ngai yemanebek Pontiya Pailet meibekyegi miza mana. ");
INSERT INTO big_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Togo Yuras Yisu ulagiwiliyegi miza yanabokko ngagozaktago Yisuyegi lewege kelemirikki pakelawekke pugu kumularik tamizeige nogo puwiliyegi Yisu miza yana ono kesak purik pangka mena pilik kumula logo pi kangka pugubek kowita logo king siliba ngele neyauganarik piyeng Yudawiligi yemanewili keya yombu Anotoyegi kolak miziwiligi ngaiwiliyegi orowei mo kuna. ");
INSERT INTO big_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Puwiliyegi kanda Yurasgu puwiliyegi pelik yeiya, Nogo yombu kaile nayendau onobek inuwayegi miza yana logo pi ula logo ibengweki mizirikki wiyeke ne weik kaile panu miza, legi king inuguyeng peyeng mena ya, yeiya. Kapura puwiligu pelik meiya to mela, Ni tonuwago talik mizagi keli? Watabi tonuwagiyeng ono, watabi nuguyeng, meiya. ");
INSERT INTO big_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tegi pulogo Anotogi i walek yemanemakke yeke ige Yuras king siliba piyeng wezamela logo yombanu ngai yemanewili wezaya logo pi kanda kalok wi tiya logo ibeng. ");
INSERT INTO big_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yombu Anotogi i walek yemanemakke yongkambanuwiligi yeiktaga Anotoyegi wata kolak kelibene waliya maniwiligi ngaiwili king siliba piyeng weiya logo pelik kisa, King peyeng yombanu ula logo ibengkirikki ngane manayeng legi tamizeige tonuwago king Anotoyegi opa manayeng kiling wiya purik pangka ono logo king peyengki tonuwago talik mizagi, kisa. ");
INSERT INTO big_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Togo puwili ngago king piyengki mizagi nara kozak kela logo waleleige puwili king piyengki ngane yombanu kaimiyeng keremizibekki ngabelak narik weiya logo kumularik ngabelak purik yombanu koweiga kayimawili pelege kanda logo ibeng puwekke pulogo waliyagirik, kisa. ");
INSERT INTO big_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Purikki wiyeke ngabelak purikki yeikta, Ngabelak kingyengki ngane yombu ula logo ibengweki piyengko weiyarik, mei. Logo mabek perage yongkambanuwiligu ngabelak purik yeik pura ngoluk mei yagenda. ");
INSERT INTO big_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Togo kazing mabilikmekke ngago yombu Anotoyaga ngagora weiya logo kozak kaibek Seremaya meiyabokko koka walaka kaiya pura weik ngizi lewagela. Pugu pelik kaiya, Yongkambanu Isileiliwiligu kisara pigi ngane weiyagiyeng king siliba ngele neyauganarik piyeng kisa. ");
INSERT INTO big_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Togo king peyengki ngane puwiligu yombanu kaimiyeng keremizibekki ngabelaktik weiya. Togo Yemizibokko neyegi kozak neiya pilik, puwili mabilik miza, kaiya. Koka walaka Seremayago pilik kaiya kapura puwiligu ngabelak purik weiya puwekke ngago pura weik ngizi lewagela. ");
INSERT INTO big_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pulaga Yudawiligi ngai yemane puwiligu Yisu miza oroweirik Yisu Rom Kapman Yudaya ngabelakpekki ngai yemane Pailet meibekki wirege luweza logo ngai yemanebokko Yisuyegi pelik nguk meiya, Ni Yudawiligi King Ngaibek ma yeik, meiya. Tegi Yisugu pelik meiya to mela, Ni makngezego kai mabura, meiya. ");
INSERT INTO big_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Keya Yudawiligi yemanewili kiling yombu Anotoyegi kolak miziwiligi ngaiwiligu ngagoyeng piyegi yowa kele kapura pugurau kanga nayendau yeiya to mela ono. ");
INSERT INTO big_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pulaga Pailetgu Yisuyegi mazenda pelik nguk meiya, Puwiligu niyegi ngago kolokngagonoyeng yowirikki nugu kerewiyi mena ni ngago nara kaiya yo meli onora nangki, meiya. ");
INSERT INTO big_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kapura Yisu mawinda ngago kaiyagirikki kiyebuk wiziga pugu ngai yemane Pailetyegi ngago lang songono narik pandau kanga meiya ono, legi ngaibek leleng yemane panu kira. ");
INSERT INTO big_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Togo kirisimasi mabiyeng wok Pasoba meibek puwili pakeli puwekke ngai yemane Pailetgu yombanu wigirawiliyaga yongkambanuwiligu keli nak wila wazami mizi. ");
INSERT INTO big_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kirisimasi purage yombanu korowali miza nak wigira wazamiya logo mamokko iwakabek keya yeik pugura Yisu Parabas. ");
INSERT INTO big_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yongkambanu kolokngagonowili menalege wawere ulawekke Pailet Yisu wila wazamiyagiweki kazing namek weli kopong pugu puwiliyegi pelik nguk yeiya, Inugu kelirik talik? Tak nogo wigirimakka wila wazamiyagirikki ini keli? Ne yombu Yisu Parabas meibok ma Yisu yombu Kilisibek meibok wila wazamiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Logo Pailetgu pelik kumula, Yombu Yudawiligi ngai yemane puwili yongkambanuwili mabuwili Yisuyegi kiriwei mizi purikki yagolok kopong puwiligu neyegi Yisu miza orowei wiriya wizinda miza. ");
INSERT INTO big_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Keya nariktau Pailet ngagozak piyengki kerewiyara mogosa tawizeige pigi yongokpumologo ngago nara wezamela logo pelik meiya, Yombu kaile nayendau miza onobekyegi watabi nayeng kelemi nagani, purik yaka kusage ne iwek kolawekke ne piyegi langai wangak miza logo ne weik kulili panu miza kani, meiya. ");
INSERT INTO big_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Togo yongkambanuwiliyegirik, Yudawiligi yemanewili kiling yombu Anotoyegi kolak miziwiligi ngaiwiligu yongkambanuwiligi wilek kangyeng kowita wazaya logo puwiligu yongkambanuwiliyegi pelik yeiya, Pailetyegi pelik nguk mei, Teniyegi Parabas miza yane, kapura Yisu ula logo ibeng wazame, meizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Logo ngai yemanebek Pailetgu mawinda yongkambanuwiliyegi pelik nguk yeiya, Peyauyaga tak nogo wila wazamiyagirikki ini keli, yeiyawekke puwiligu kemenak pelik kanga kisa, Parabas, kisa. ");
INSERT INTO big_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pulaga Pailetgu yongkambanuwiliyegi mazenda pelik nguk yeiya, Tamizeige keli inugura pilik purik mabura Yisu Kilisibek meibokyegi nogo talik mizagi, yeiya. Tegi puwili mabuwiligu kemenak pelik kek kisa, Pi yengeleileige nili uliweki kelemi, kisa. ");
INSERT INTO big_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tegi Pailetgu puwiliyegi pelik yeiya, Pi nangki uliweki, pugu korowali talikyeng miza, yeiya. Kapura yongkambanuwiligu ngoluk mazengkeya ngalizi panu pelik kek kisa, Pi yengeleileige nili uliweki kelemi, kisa. ");
INSERT INTO big_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pulaga Pailetgu weik iwaka, ngago pugura pangka ono, kapura ngai yemanera lewagelaweki mizi. Tegi pi yongkambanu wawere ulawiligi wirege pelengwekke kai wik narik kola logo mele puguyau kaigesa melageya wizimowei pelik yeiya, Yombanu pobok ulagirik watabi nogoyengko ono, inuguyengko keke ulagi legi yombu kaile nayendau miza onobek ula logo ibengkirikki wiyeke ngangang kanga weiyagiyeng neyegi lewagi ono, segeya iniyegi lewagi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tegi yongkambanuwili mabuwiligu pelik meiya to mela, Ei, wameik. Puragi kangara teni keya tenigi yango keya marekngangwiliyegi lewa purik pangka, meiya. ");
INSERT INTO big_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Togo pulaga Pailetgu Parabas wila wazamiya logo puwiliyegi yana. Keya Yisu ulagi purik pangka kelemiya logo pugu ami nawiliyegi Yisu were pikang yemane ngai kozang piyengko wizale ula logo puwiligu pi yengeleileige nili ulibene kozak yeiya. ");
INSERT INTO big_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pulaga Rom Kapman Yudaya ngabelakpekki ngai yemanebek Pailetgi ami nawiligu Yisu miza orowei ngai yemanebekki imakke kiliya kuna logo puwiligu ami mabuwiliyegi ngago yeiya. ");
INSERT INTO big_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Puwili kanda pulogo puwili mabuwiligu Yisu yawereng kelemiya logo kagorik puguyeng pugusa mela logo puwiligu Yisu melewangka King Ngaiwiligu wakiyi langai wago yokolong narik wakiya wazamiya. ");
INSERT INTO big_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Keya puwiligu mabung ingak ngai merek kilulung wezabek keremiza logo Yisugi kebiraga ngalege wiya, keya puwiligu wireng nak mele ngai puguzikke kebangkela wazamiya. Puwiligu peyeng miza logo ngaigu Yisu King Ngaibek miziweki. Togo pulaga ami puwiligu pigi ingewerege ingiyeng laliya logo puwiligu piyegi yang meiya logo pelik meiya, Aiya, ni wik yokolong yoluweki, ni Yudawiligi King Ngaibek. ");
INSERT INTO big_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pilik kisa logo puwiligu piyegi sibilak ngiza mani, keya wirembek weiya logo mabokko mabung ingak Yisugi kebiraga ngalege wiya pura ulageya koya. ");
INSERT INTO big_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Puwiligu Yisuyegi yang meiya logo pulaga melewangka wagorik pugusa mowiya logo ngezebekkiyeng ngereke wakiya wazamiya. Logo weik puwiligu Yisu yengeleileige nili uliweki miza orowei kuna. ");
INSERT INTO big_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Puwili tagoneige pura kazingmekke yombu Saimon yereng Sairini meiragabek logo Yirusalem yerengke yolubek lewa logo paka Yirusalem yerengke kuniweki wizilege. Kapura amiwiligu pi kebangkela logo Yisugi yengeleilei wagela wazamiya. ");
INSERT INTO big_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Togo amiwiligu Yisu miza orowei kuna, weik kanda ngabelak wale yeikta Kologata meirikke logo yeiktago kai purik kebi kozarik kai yagenda. ");
INSERT INTO big_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Keya pulogo kandawekke puwili kai waing keya marasing ngelaming miza logo pi ngangang yemane panu kela nelegi nibene mana kapura pi kolokulawekke pi na ono. ");
INSERT INTO big_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Togo Rom Amiwiligu kologata pulogo Yisu yengeleileige ngalege nili ula logo yengeleilei luwe lewamiya. Pilik miza logo amiwili takko Yisugi kagorikyeng weiyagi miza legi puwili yengelei lek uli. ");
INSERT INTO big_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pilik miza logo amiwili pulogo mogosa logo piyegi ngai yuke koya. ");
INSERT INTO big_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Togo puwiligu ngago lang pugu watabi kokowa miza piyengkiyeng paka pigi kebi wilekta yolulege ngalege pelang korokwekke pilik lende miza logo ula wazamiya, Pobok Yisu, Yudawiligi King Ngaibek, miza. ");
INSERT INTO big_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pulaga Rom Amiwiligu yombanu kazing kaile watabiyeng ngoweimekke miza logo wigira wazayayaurau yengeleiyauge nili ula logo nak Yisugi mele ngaigezuwagezikke wazami keya nak pigi mele koranengkezikke wazami miza. ");
INSERT INTO big_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yongkambanu mereke kang yongomo miziwiligu Yisuyegi yang meiya logo piyegi kebi puwiligiyeng ngulang kelemi mizageya koyimowei pelik meiya, Ni Anotogi i walek yemanemak topela logo wok neyauganak piyengke ngereke i pumak ngizagi kaiyabek purik mabura purikku kozandago ni makngezego ni makngeze yaliya wazame. ");
INSERT INTO big_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tamizeige ni Anotogi Marekpek purik mabura yengeleileiga yo kule, meiya. ");
INSERT INTO big_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kazing mabilikmekke Yudawiligi yemanewili kiling yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwili puwilirau ngezewili nakko nakyegi pelik mei yongomo mizi, ");
INSERT INTO big_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Pi nawili ibendaga pangka yaliya wazaya kapura pi ngezebek pangka yaliya wazamiyagi ono. Pugu pelik kai, Ne yongkambanu Isileiliwiligi King Ngaibek, kai legi tamizeige pi yengeleileiga yo kula purik mabura teni pura wameik purikki ngizi panu kumulagi. ");
INSERT INTO big_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Pugu Anotoyegi wilekpek ngalege wiya keya pi Anotogi Marekpek kaibek, mena tonugu pakeliweki, Anotogo piyegi mabek saweli penangai makne, mei. ");
INSERT INTO big_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Keya yombu yaka Yisu kiling yengeleiyauge nili ula piyaugurau Yisuyegi mabilik ngago kaile meiya. ");
INSERT INTO big_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yokmek weik paka ngilumbekke libuge 12 kilok si ngizige yokmek kusa logo ngabelakpek mabok weik kusa logo wiziya yokmek panga luwege neyauganakwekke yokmek ngereke ngaiwila. ");
INSERT INTO big_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Togo yokmek panga luwege neyauganakwekke Yisu ngezebekki ngago yeiktage ngalizi pelik kek kaiya, Eli, Eli, lama sabatani. Ngago lang purik pelik kai yagenda, Anoto nogobek, Anoto nogobek, ni ne wezanira nangki, kai yagenda. ");
INSERT INTO big_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yombanu mereke koya nawiligu pugu pilik kairagi kerewiya logo Ilayayegi kai nobiyeng pelik kisa, Pok Ilayayegi ngago mei kani, kisa. ");
INSERT INTO big_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Togo puwili wiyalowei miza logo puwiliyaga nak nginda kambela logo kapuk wezarik narik ngo nakke mela logo purik kai waing walekpekke yungke mela logo Yisu nibene mana. ");
INSERT INTO big_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kapura nawiligu yakabokyegi pelik meiya, Yek yuke, Ilaya kanda Yisu ibendaga yaliya wazamiyagi ma yeik miza purikki teni yuke, meiya. ");
INSERT INTO big_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Togo Yisu mawinda ngalizi kek kaiya logo kung pugubek weik pi wezami kang logo weik pi ibeng. ");
INSERT INTO big_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Togo pulaga nguk namizi kagorik Anotogi i walek yemanemakke ngalege wiramiyarik paka ngalega pongo ngabelakke libuga koliyara narik narik miza. Keya ngabelakpek kuburuk ulageya keya king yemaneyeng kotora wala mela. ");
INSERT INTO big_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Keya Yirusalem pulogo Anotogo yombanu long kolokngagonoyeng tiya logo pugu yombanu piyegi ngizi panu kumula logo ulogo ibeng puwiliyaga kolokngagonowili wik yangalekta wazaya. ");
INSERT INTO big_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Puwili long puwiligiyeng wizamiya logo Yisu ibendaga wik yangalek meiya logo pulaga puwili yereng Yudawiligi walekta Yirusalem meirage kiliya logo pulogo yongkambanu kolokngagonowiligu puwiliyegi pakela. ");
INSERT INTO big_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Togo Rom Amiwili Yisuyegi ngai yuke puwili kiling puwiligi ngaibek Yisuyegi mereke pulogo luwe wiziyabek, puwiligu kuburukpek keya watabi yaka lewagela mela piyengki pakelawekke puwili kulili yemane miza logo pelik kisa, Wameik panu pok Anotogi Marek panubek, kisa. ");
INSERT INTO big_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pulogo yongok kolokngagono koka Yisu kiling pongo Kalili koyawili logo Yisuyegi paka Yirusalem kiriwei saweli keya kelemi kayimawili tek nangezi koweiga pakela koya. ");
INSERT INTO big_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Puwiliyaga namele Maliya Matalena keya namele Maliya, Yosisi keya pigi sakpek Jemsgi panumele, keya namele Sebetigi marekyaugi panumele. ");
INSERT INTO big_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yokmek kiliyagi merekewekke yombanu watabiyengko keremungke nak yereng Arimatiya meiragabek Pailetyegi kuna. Yeik pugura Yosep keya pirau yombanu Yisuyegi kiriwei puwiliyaga nak. ");
INSERT INTO big_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pi Pailetyegi kanda luweza wizimowei Yisugi yasurik wawiyiweki meiya. Tegi Pailetgu ami puguwiligu pi Yisugi yasurik wawiyi pani kelemiweki kozak yeiya. ");
INSERT INTO big_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Togo Yosep yengeleileige kanda Yisugi yasurik yengeleileiga orowei yerageya logo kagorik wilangka wazono pugu weiyarikku sape miza. ");
INSERT INTO big_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Logo Yosep kilingwiligu yasurik wagela logo mosindage kanda puwiligu mosindage king ururu yombanu waliyiweki keremizamek logo Yosep ngezebokko ngezebekki keremizamekke wiya. Togo Yosep kilingwiligu king yemane panu nara ulumowei kanda Yisugi londagi kandikke waliya wazamiya logo kambela. ");
INSERT INTO big_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya Matalena keya Maliya namelerau, panga Yisugi londaga mogosara yuke koyima. ");
INSERT INTO big_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Wok melenazikpekke piyeng pilik miza. Wokpok yongkambanuwili watabi Yudawiligi wok yawe mizi onobek Sabatpek meibekkiyeng ngayek mizibek. Keya yokmek kiliya logo weik kusa logo Yudawiligi wok wikpek Sarerebek Sabatpek meibek weik lewagela. Togo wokpokko yombu Anotoyegi kolak miziwiligi ngaiwili keya yombanu Palisi mei nawili Pailet kiling wawere ula. ");
INSERT INTO big_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Pilik miza logo puwiligu Pailetyegi pelik meiya, Yemanebek, Yisu, yombu ngaigu kaibok ulogo ngoluk wikwekke pugu pelik kaiya, Ne ibengki kapura wok neyau wiziya logo wok kalikebekke ngereke wik yangalektagi, kaiya purik tonuwago kumula. ");
INSERT INTO big_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pi ngoluk wik wiziyawekke pugu ngaigu kaiya, Ne Anotogi Marekpek, kaiya purik kaile. Kapura mabek tamizeige yombu pugu waligeleya puwiligu kanda pigi yasurik ngoweiya logo nalege liwik wiya logo puwiligu yongkambanuwiliyegi, Pi ibendaga wik yangalekta, yei purik mabura purik kaile panugi. Tegi nugu ngagora wezamela logo nugu amiwiliyaga nawili Yisugi londage wok neyau keya nak piyengke ngai waberek yuke koyibene kang wezayele. Purik tamizeige puwiligu Yisugi yasurik ngoweiya logo pelik kisi, Pi wik yangalekta, kisi purik mabura ngago ngaigu kalike kaiya purago ngago ngaigu were kaiya pura ulagi, meiya. ");
INSERT INTO big_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailetgu pura kerewiya logo pelik yeiya to mela, Ei, nogo ngagora wezamela wizinda logo ami ngaigi nawili iza logo kunizo keya kanda Yisugi londage waberek panu ngai yuke koyizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tegi puwili kiling ami nawili kambela logo londagi kanda londagi kandik waliya panuweki puwiligu king yemane panu nara londagi kandikke waliya wazamiya logo yengelei yulung ngai kalagalo kelemiyagibokko ngai kalagalo kelemiya logo amiwili pulogo ngai koyibene wazaya. ");
INSERT INTO big_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Wok Sabatpek miza logo waleleige wok Sondabekke wangane panu Maliya Matalena keya Maliya namele piyau Petani yerenda wiya logo Yisugi londagi pakeli kambela. ");
INSERT INTO big_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Togo nguk namizi kuburuk yemane nak uli keya Yemizibekki angelawiliyaga nak paka ngalega kanda pugu king yemane ulogo kandikke waliyabek towilizamiya logo king maburage ngalege mogosa wizilege. ");
INSERT INTO big_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wiregawere pugura lengka wililiktik kelik keya kagorik pugu wakiyayeng wilangka panu piyeng kelik logo kozainung wilangkayeng kelik. ");
INSERT INTO big_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Keya ami pulogo Yisugi londage ngai koyimawili angelabekyegi pakelawekke puwili kulili yemane miza logo leli ula mela logo kawiye wala logo ibengwili kelik koya. ");
INSERT INTO big_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yongok piyau Yisugi londage kanda piyaugu angelabekyegi pakelawekke piyaurau kazi miza kapura angelabokko yongok piyauyegi pelik yeiya, Yali kulili mizi wak. Yali Yisu puwiligu yengeleileige nili ulabokyegi weli purik ne iwaka. ");
INSERT INTO big_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kapura pi pelege yolu ono, pi yaka yangalekta, pi ngezebokko kaiya pilik. Pakeli koli, pelege puwiligu pi ulogo wiya wazamiya kapura pi weik yangalekta. ");
INSERT INTO big_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mena, yali ngezangai kambeli, logo pugu waligeleyawiliyegi ngago peragi pelik kozak yei mizizo, Pi ibendaga yangalekta logo pi were ngabelak Kalili meibekke kangki pulogo inugu piyegi pakelagilege, yeizo. Nogo yaliyegi peragi kozak yeiya logo yaligu puwiliyegi kozak yeizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Togo piyau Yisugi londaga welagela kanda kulili mizi kapura wilikwilikmek kiling piyau yombu pugu waligeleyawiliyegi kozak yeiweki nginda kambela ");
INSERT INTO big_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","logo nguk namizi Yisugu piyau yoromaure keleya wizigeya pelik yeiya, Wangane, yeiya. Piyau Yisugi ingewerege inge piyaugiyeng laliya logo piyegi ya kumula. ");
INSERT INTO big_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Togo Yisugu piyauyegi pelik yeiya, Kulili mizi wak. Yali kambelizo, logo negi si keya sakkawili nobiyeng miza puwiliyegi ngabelak Kalilibekke kangweki yeizo logo pulogo puwiligu neyegi pakelibene, kozak yeizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Togo yongokyau yagoneigeya amiwili Yisugi londage ngai koyimawiliyaga nawili panga yerendage kandorik yombu Anotoyegi kolak miziwiligi ngaiwiliyegi watabi yaka lewagela mela piyengki kozak yeiya. ");
INSERT INTO big_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Togo puwiligu Yudawiligi yemanewili keya ngagozak piyengki kerewiyiwiliyaga nawilirau wawere uliweki ngago yeiya logo puwili ngago nara kozak kela. Togo puwiligu ami puwiliyegi king yemane yana ");
INSERT INTO big_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","logo pelik yeiya, Inugu yongkambanuwiliyegi pelik kozak yeizo, Teni iwek koyigeya yombu pugu waligeleyawiligu kusarikke kayima logo yasu pugurik ngoweiya logo kambela kisizo. ");
INSERT INTO big_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Keya tamizeige Rom Kapman Yudaya ngabelakpekki ngai yemanebek Pailetgu peragi kerewiya logo pugu ngago nara kai purik mabura tonuwago piyegi ngago nara meiya to melagi logo inuwa ngagozak mizagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tegi ami puwili king piyeng weiya logo ngago Yudawiligi ngai yemane puwiligu kisa puragi kiriwei miza. Togo ngago ngaigura Yudawili mabuwiliyegi ululu miza mela keya mabilik mabek pewekkerau ngoluk mizageya koyinda. ");
INSERT INTO big_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yombu meleyau keya pongo ingenazikka nak Yisu ngezebokko waligeleya puwili Yirusalem yerenda wiya logo pongo ngabelak Kalili meibekke kambela. Kanda pulogo puwili paka lewak Yisu ngezebokko ulogo kangweki kozak yeiyabekke kambela. ");
INSERT INTO big_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kanda pakalege puwiligu Yisu pakelawekke puwili kebiyeng morogulunda koyimowei piyegi ya kumula koya. Kapura puwiliyaga nawiligu pi wameik Yisu panu purik kangka neyau koya. ");
INSERT INTO big_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tegi Yisu puwiliyegi mereke kanda pelik yeiya, Anotogo ne kozang paka ngalegiyeng mabiyeng keya ngabelakpekkiyeng mabiyengkirau ngaiweki pangkara nana legi nogo inuwa yaweyeng miziweki yani. ");
INSERT INTO big_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Togo yongkambanu ngabelak mabiyengkiwili mabuwiliyegi kambelizo logo watabi nogo inuwayegi waligeleya piyeng mabiyeng inuwago puwiliyegi waligeleyizo, logo piyengki kerewiya logo puwili nogo waligeleyiwili sagi. Keya inuwago puwili Pebagi yeikta, keya ne, pigi Marekpekki yeikta, keya pigi Kung Walekpekki yeiktage kaimelizo. ");
INSERT INTO big_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Keya inugu puwiliyegi ngago nogo inuwago miziweki kozak yeiya maburagi kiriwei mizizo kai purikki kozak yeizo. Keya kumula, inuwa koyi kang keya ne inuwa kiling wizageya kuna ngabelak pobok weik yeik puwekkegine kani, yeiya. Togo ngago pera yombu Matiyu meibokko lende mizara logo weik pulogo yeik. ");
INSERT INTO big_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ngago wazono pera Yisu Kilisi Anotogi Marekpekyegi langaira logo solowekkerik pilik lewagela. ");
INSERT INTO big_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Koka walaka Isaya Anotoyaga ngagora weiya logo kozak kisawili logo Poropekwili meiwiliyaga nakko Anotogi Kapiya Walektikke lende mizarik pelik, Anotogo pigi Marekpekyegi pelik meiya, Kerewiye, Ni kalika kangkine kapura nogo were ngago nogora oroweibek wezamelagi. Pi nigi kazing kunagimek kangkere mizagi. ");
INSERT INTO big_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yombu yakabok lewagelagi logo paka kurung yeikwekke wizimowei ngalizi pelik yeiyagi, Yemizibek lewa legi kazing i——nugu miziyeng waberek mizizo keya wilek kang inuguyeng pangka pangka mizizo. Kazing pilikmekke inugu kazing Yemizibekkimek kangkere mizi, yeiyagi, kaiya. ");
INSERT INTO big_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Togo weik ngago pura ngizi lewagela. Logo yombu yakabok paka kurung yeikwekke lewagela logo weik yongkambanuwiliyegi ngagora yana. Yeik pugura Yowan. Pugu yongkambanuwiliyegi pelik kozak yeiya, Ini kaile inugu miziyengki kuneng mizizo keya kazing kaile inuguyengka kowiti mizizo keya wilek kang inuguyeng Anotoyegi sawelizo. Pilik miza logo purik nogo ini kaimelagi logo Anotogo kaile inuguyeng tumula logo keremareke wezamelagi. ");
INSERT INTO big_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yowangu pilik kozak yeiya wizigeya yongkambanu yereng yemane Yirusalem meiragawili keya ngabelak Yudaya meibekke yereng piyengkawilirau piyegi kambela logo pugu kairagi puwili kerewiya logo puwiligu kaile mizayengki Anotoyegi kimeike kozak meiya logo Yowangu puwili pongo kai Yolodang meilingke kaimela. ");
INSERT INTO big_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Keya Yowan poropek kokawiligu koyalik pi kazing namekke wiziya. Kagorik pugu wakiyayeng pelik, pi liyeng Kamelmek meimekki lekpekka narik walamiya logo wakiya, keya pugu wata korik narikka pikang nak keremiza logo wangka waliya. Ngeragi puguyeng komuwili keya ngirung yengelei ngezege piyeng logo pi pilik wizagoma. ");
INSERT INTO big_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Keya pugu yongkambanuwiliyegi ngago pelikta kozak yei miza, Kalike yombanu nak lewagi. Kozang pugura keya yawe pugurago nogo mizi peyeng ulagi. Ne pokyaga kulengke logo nogo kumularik yeik nogora yeik puguraga kulengke panu, keya yeik pugura nogoraga ngalege panu. ");
INSERT INTO big_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nogo ini kai yeikpokko kaimeli kapura pokko ini Anotoyegi kowita puwili Anotogi Kung Walekpokko yenge yungke kola wizeibene keleyagi, Yowangu yongkambanuwiliyegi pilik yeiya. ");
INSERT INTO big_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yowan pilik mizageyara wok nakke Yisu ngabelak Kalili meibekke yereng Nasarete meira wiya logo Yowanyegi kayima logo Yowangu Yisu kai Yolodang meilingke kaimela, ");
INSERT INTO big_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","logo Yisu kailingka tabunda yo yabekkeya ngizige pugu tapakeleige pura paka ngalege lemengki kandik tiya logo Anotogi Kung Walekpek winak Kuwemimimek kelikmek piyegi yerageya logo kanda piyegi wizigeya ");
INSERT INTO big_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Anotogi kilirago paka ngalega pelik mei, Ni negi Marek nogo keli panubek. Ne niyegi wilik, meiya. ");
INSERT INTO big_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pilik meiya logo nguk namizi Anotogi Kung Walekpokko Yisu paka kurung yeik nawekke kuniweki kelemiya. ");
INSERT INTO big_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pakalege kanda pi pulogo wok yombu neyau tikinda piyeng wiziya keya Sadang kerewawiliyegi ngaibokko Yisu kaile mizibene yang kelemiya. Pi ngezebek keke, wata ngai miziwiligu yolu lemengke wiziya. Sadangko pi yang kelemiya logo weik wizigeya Anotogi angelawili kanda Yisuyegi waberek ngai koya. ");
INSERT INTO big_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Togo Yowan kaimelibokko ngoluk yongkambanuwiliyegi kaile puwiligu mizayengki kozak yeiyageya wizimowei pugu King Ngai Elodoyegirau kaile pugu mizayengki kozak meiyarikki wiyeke Elodogo Yowan wigira wazamiya. Yowan wigira wizigeyarik Yisu ngabelak Kalili meibekke kambela logo pulogo pi yongkambanuwiliyegi Anotogi ngago wazonoragi pelik kozak yeiya, ");
INSERT INTO big_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Teng Anotogo sawiya pura weik lewa. Anotogo iniyegi ngaigi pura weik mereke mena ini kaile inugu mizayengki kuneng mizizo keya kazing kaile inuguyengka kowiti mizizo keya wilek kang inuguyeng Anotoyegi sawelizo logo Anotogi ngago wazonoragi kerewiya logo puragi ngizi panu kumula logo kiriwei mizizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wok nakke Yisu kai kolamiya Kalili meibekke kerelemekke wei mizi tagoneige, pugu yombu watabisi uli neyau pakela. Piyau Simong keya pigi sakpek Enduru logo piyau kaibekke kik kawekkik wezamelageya koyilege, purik piyau yawe kik kawek yemaneyengke watabisi uli keya kingyengki ngane yanirage miziyau. ");
INSERT INTO big_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yisugu piyauyegi pelik yeiya, Ne kiling saweliweki kiriwei koli, nogo yaliyegi yawe yongkambanuwili neyegi ngizi panu kumulibene iza oroweigi puragi waligeleyiweki. ");
INSERT INTO big_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pilik yeiya logo piyau nguk namizi kik kawekyeng wila mela logo Yisu kiling saweliweki kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yisu songono nangezi kanda pura pugu Sebetigi marekyau Jems keya Yowan pakela. Piyau panga wang piyaugileige ngalege kik kawek piyaugiyeng keremizageya koyilege. ");
INSERT INTO big_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yisugu pakela logo nguk namizi piyauyegi, Ne kiling yawe miziweki koli yeiya, logo piyaugi mangobek keya piyegi yawe miziwili wangleige ngalege mabulogo wezaya logo piyau Yisu kiling saweliweki kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Keya pulaga puwili yereng Kapaneyam meirage tabunda logo koya logo wok Yudawili yawe mizi ono, puwiligu Anotoyegi ya kumulibek wok Sabatpek meibekke Yisu puwiligi i walek songonomakke kiliya la logo yongkambanuwiliyegi Anotogi ngago wazonora waligeleya. ");
INSERT INTO big_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yongkambanu piyegi kerewiyawili pugu waligeleyiyengki lelengkira. Purik pi Yudawiligi loyengki waligeleyiwiligu waligeleyilik keleyi ono, segeya pi kozang yemanera kiling kozak kai logo pi yeikta kiling nakko waligeleyilik keleyi. ");
INSERT INTO big_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mabuwekke i walek songonomakke ige pulogo yombanu kerewa nakko yenge yaga ngai yolu nak wiziya logo kerewabokko ngalizi pelik kek kai, ");
INSERT INTO big_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Aik, ni Yisu paka yereng Nasaretegabek. Ni teniyegi nangai miziweki mizi? Ni teni yeliweki pelege lewa logo teni kemenak yeik sa wazayiweki ma? Ni kaile nayendau ono Anotoyaga kayimabok purik ne iwaka, kai. ");
INSERT INTO big_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kapura Yisugu kerewabekyegi pelik ngalik meiya, Ngagoluk wizei, keya yombubekyaga kazi welagela kule, meiya. ");
INSERT INTO big_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pilik meiya logo kerewabokko yombanubek piyeng keya walibene kelemiya logo ngalizi kek kaiya logo welagelabela. ");
INSERT INTO big_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yongkambanu pura pakela puwili yemane lelengkira logo puwili nakko nakyegi pelik mei yongomo miza, Pera nangaira? Pera wik waligeleyi nara ma talik? Yombu pobokki ngago kozang perago kerewawili kazi kunibene yeiya logo puwilirau pugu kairagi kerewiya logo kiriwei mizi, mei. ");
INSERT INTO big_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Keya pulaga ngago Yisugu miziyengki langaira yenge ngabelak Kalili meibekke yereng mabiyengke nguk namizi ululu miza mela logo yeik pugura yemane lewagela. ");
INSERT INTO big_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Togo nguk namizi Yisu keya pugu waligeleyiwili Yudawiligi i walek songono pumakka welagela. Pulaga Yisu kiling Jems keya Yowan pongo Simong keya Endurugi imakki kambela. ");
INSERT INTO big_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pi kanda yeke ige Simongki yongokpumelegi panumele kemegeme korikwek yezingei panu mizimekka mizi logo lalektage iwek wizilege logo Yisu pulogo tabung mei ngizige puwiligu piyegi kemegeme pugumekki nguk namizi kozak meiya. ");
INSERT INTO big_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tegi Yisu piyegi kanda mele puguzik weiya logo yangalekta wazamiya logo kemegeme korikwek yezingeimek piyaga yeik logo pi weik puwiligi ngeragi keya watabi miza yowiya. ");
INSERT INTO big_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pilik miza logo kepileige yokmek kiliya logo yongkambanuwiligu Yisuyegi kemegemewili keya yombanu kerewawili yenge yungke ngai yoluwili iza orowei wiriya. ");
INSERT INTO big_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Yereng purage yongkambanu yoluwili mabuwili i pumakke yerengke tiya mana. ");
INSERT INTO big_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Togo Yisugu yongkambanu kolokngagono kemegeme nak nalangaimek kilingwili miza puwili yeik wazaya keya kerewa kolokngagonowili yongkambanuwiliyaga welagela wezayela. Yisu Anotogo sawiyabek purik kerewawili iwaka kopong Yisugu kerewawili ngago pi tak miza pura yongkambanuwiliyegi kawela kisa nelegi keleya. ");
INSERT INTO big_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Togo wangane panu pura Yisu yangalek meiya logo yereng pura wiya logo pi ngezebek kabelak kuyangka ngagoluk nangezige waberek miziweki kambela. ");
INSERT INTO big_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Waleleige pi talege miza legi Simong keya pi kiling puwili Yisuyegi suwei wela. ");
INSERT INTO big_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Logo puwiligu pi yolok ngelawekke pelik meiya, Yongkambanuwili mabuwili niyegi suwei weli, meiya. ");
INSERT INTO big_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kapura Yisugu pelik yeiya to mela, Mabilik, teni yereng nayengke kangweki. Ne yongkambanu yereng piyengke yolu puwiliyegirau Anotogi ngago wazonora kozak yeiweki. Ne pilik miziweki kayimabek legi ne kangweki, yeiya. ");
INSERT INTO big_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tegi pi ngabelak Kalili mabokko yongomo mizageya wizimowei Yudawiligi i walek songonoyengki la logo Anotogi ngagora yani keya kerewawili yongkambanuwiliyaga welagela wezayeli miza. ");
INSERT INTO big_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Togo wok nakke yombu kemegeme Leposimek meimek kiling nak Yisuyegi weik lewa. Kemegeme Leposimek mei pumok korikwek sok mizimek keya korikwekke wizing lewa meli mizimek logo yongkambanuwiligu wizing piyeng kuming kelemiya purik puwilirau kemegeme leposi pumokka yela managi, legi yongkambanuwiligu kulili panu mizimek logo puwili nak leposimek kiling purik pilikpok kezanga mani mizimek. Logo yombanu pilikmek kilimbek Yisuyegi kayima logo Yisugi yeikta yongolok meiweki pi Yisugi ingewerege panga ngabelakke ingeyau laliya logo pelik kelegele meiya, Tamizeige nugu keli mabura nugu ne yombiyangai wazaniye logo yongkambanuwiligu neyegi kezanga nanagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Togo Yisu piyegi yalek panu miza legi Yisu melezik tungkula logo pi kebangkela logo Yisugu pelik meiya to mela, Nogo mizagi keli. Ni yombiyangai se, meiya. ");
INSERT INTO big_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nguk namizi mabuwekke yombubekyegi wizing leposi lewamek weik yeik logo pi weik yombiyangai sa. ");
INSERT INTO big_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pilik miza logo Yisugu piyegi pelik kozang meiya, ");
INSERT INTO big_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Nugu peragi namele keya nakyegi kozak mei nagani, kapura tenigi lo Mosego kaiya puragi kiriwei mizimo. Ni Anotogi i walek yemanemakki yombu Anotoyegi kolak mizibokko ni yombiyangai sa wazaniyarikki pakelibene kune keya pulaga nugu pi wata namek Anotoyegi kolak mizagirikki wiyeke mana logo pugu ula logo waliya logo ni weik yombiyangai wazaniya puragi yongkambanuwiligu iwakagi, meiya. ");
INSERT INTO big_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kapura yombanu yakabok ngagoluk kambela ono, pi yongkambanuwiliyegi ngago Yisugu yombiyangai wazamiya puragira kozak yeiyageya wiziyarikki kandik yongkambanu kolokngagono panu Yisuyegi nginda lewa logo Yisu weik yerengke yongkambanuwiligi wirege kimeike kunagi langai ono, logo pi yerengyengka yenge keke wiziya. Kapura yongkambanuwili lewe mabiyengka ngoluk piyegi lewagelageya koya. ");
INSERT INTO big_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pilik miza logo waleleige wok nakke Yisu ngereke yereng Kapaneyam meirage yo. ");
INSERT INTO big_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Logo pi i namakke yolu purikki yongkambanu mabuwili kerewiya logo yongkambanu kolokngagono tiya mani, logo kolokngagono panu yeke ige lemeng liya keya yenge yerengke lemendau liya miza. Yisugu puwiliyegi Anotogi ngago wazonora kozak yeiya. ");
INSERT INTO big_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pi pilik mizageya keya yombanu nawili wiriya logo puwiliyaga yombanu mangobektau onowiligu yombu inge keya meleyeng ibeng nak lalektikke ngalege wageliwei kanda ");
INSERT INTO big_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","puwili yeke ige Yisuyegi saweliwei wazamiyagi nobiyeng miza kapura yongkambanu kolokngagono liya kopong puwili kemegemebek yeke ige wageliwei lagi langai ono, legi puwili pi yeke imakke ngalege ngilirik neing wageliwei la logo lewelimbekke yungu narik tiya logo wibek lalektikka ngane miza logo yenge yongkambanuwiligi tepekke kemegemebek lalektikke wibekka Yisugi ingewerege kula. ");
INSERT INTO big_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Puwili Yisugu kemegemebek yombiyangai wazamiyagi langai purikki ngizi panu kumulirikki pugu pakela logo pugu yombu inge keya meleyau ibembekyegi pelik meiya, Ei, nogo kaile nuguyeng weik tumula logo keremareke wezameli kani, meiya. ");
INSERT INTO big_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yisu pilik kai legi yombanu Mosegi loyengki waligeleyi pulogo mogosa koya puwiligu ya puwiligiyengke pelik kumula, ");
INSERT INTO big_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Yombanu pobok pilik kaiyagi onobek, purik pugu kai purik pi Anoto kiling pangka pangka kai yagenda legi. Yombanu ngabelakpekke nakkorau kaileyeng tumula logo wezamelagi ono, Anoto wamenakko mizagi mena miza. ");
INSERT INTO big_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nguk namizi Yisugu yenge wilek kang pugubekke puwiligu liwik kumula piyengki iwaka legi pelik yeiya, Inuwa ya inuguyengke pilik kumulira nangki? ");
INSERT INTO big_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Yawe nangaira yemane onora, kaileyeng tumula logo wezamelagira ma yombu inge keya meleyeng ibeng nak yombiyangai wazamiyagi pura? Tamizeige ne yaka inge keya meleyeng ibembekyegi pelik mei, Nogo kaile nuguyeng tumula logo wezamela, mei purik ini pi wameik kai ma ngaigu kai kisagi, kapura tamizeige ne yombu inge keya meleyeng ibembekyegi pelik mei, Yangalek meiya logo kune, mei purik ini ne wameikpek ma ngaigubek miza legi iwakaweki. ");
INSERT INTO big_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ne yombanu paka ngalega kayimabek logo yongkambanu ngabelakpekkewiligi kaileyeng tumuliweki pangkara kilimbek logo ini purikki iwakaweki nogo yaka yombu inge keya meleyeng ibembekyegi pelik mei yagenda, ");
INSERT INTO big_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ni yangalek meiya logo yolumek nuguyeng weiya logo i nugumakki kambele, mei yagenda. ");
INSERT INTO big_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mabuwekke yombanubek puwiligi wirege yangalekta luweza logo yolumek puguyeng weiya logo imakka welagela kuna. Pilik miza logo pakela pumok mamok lelengkirageya koyimowei Anotogi yeikta yongolok meiya logo pelik kisa, Teni pilik nararau ulogo pakela ono, kisa. ");
INSERT INTO big_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Keya pulaga Yisu ngereke pongo kai kolamiya Kalili meibekke kambela logo pulogo yongkambanu kolokngagonowili piyegi wawere ula logo pugu puwiliyegi mawinda Anotogi ngagora waligeleya. ");
INSERT INTO big_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pilik miza logo Yisu wei mizi kunimowei tapakeleige yombu king takis weibek, Alapiyagi marekpek Lebi, opis pugumakki mogosa wizilege Yisugu piyegi pelik meiya, Ni ne kiling saweliweki kiriwei koli, meiya. Pulaga Lebi kerewiya logo yangalek meiya logo Yisu kiling saweliweki kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kalike wok nakke puwili Lebigi imakke kanda ngeragi niweki mogosa keya Yisu keya pugu waligeleyiwili kiling Yudawiligi yombanu kolokngagono kapmanbekyegi king takis wei logo piyengka nayeng ngowei miziwili keya yombanu kaile mizi nawilirau menalege Lebigi imakke ngeragi nageya koya purik yombanu kolokngagono pilikwili Yisuyegi kiriwei legi. ");
INSERT INTO big_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yombu Mosegi loyengki waligeleyiwiligi ngai Palisi meimekka nawili Yisu kiling puwili nirikki pakela logo puwili sisik miza. Yombu Palisiwili meiwili yombu Yuda kangka yemane Mosegi lo mabiyengki waberek panu kiriwei keya puwiligi yelibungang kokawiligi ngago yogongyengkirau kozang panu kiriwei mizi miziwili. Logo puwili sisik sara koyimowei kalike pigi yombu ngezebokko waligeleyi puwiliyegi pelik nguk yeiya, Inuwagi yemanebek yombu king takis wei piyengka nayeng ngowei miziwili keya yombanu kaile mizi nawili kiling ngeragi ni mizira nangki? Pi pilik mizi purik pangka ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yisugu puragi kerewiya logo puwiliyegi pelik yeiya to mela, Yongkambanu wazonowili totayegi kang ono, kemegemewili keke totayegi pakeli kangwili. Kazing mabilikmekke ne yongkambanu ngezewiligu ngezewiliyegi pangkawili mizi puwiliyegi kayima ono, ne yombanu kaile mizi puwiliyegi kayima logo puwili kazing kaile miziyengka kowitibene ngago yeiwekibek, yeiya. ");
INSERT INTO big_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kang narage Yowan kaimelibekyegi kiriweiwili keya yombanu Palisiwili meiwili kazing wilek kang mabiyeng Anotoyegi waberek mizagirikki tiya maniweki ngeragi ni onomek mizageya koya. Yongkambanu nawili Yisuyegi kayima logo pelik nguk meiya, Yowan kai melibekyegi kiriweiwili keya yombanu Palisiwili meiwiliyegi kiriweiwilirau kazing wilek kang mabiyeng Anotoyegi waberek mizagirikki tiya maniweki ngeragi ni ono mizimek mizi kapura yombu ni makngezogo waligeleyiwili kazing pumok mizi onora nangki? ");
INSERT INTO big_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Pilik meiya logo Yisugu pelik yeiya to mela, Yek tek nangezi yombanu yongok weiweki mizi nakyegi langai kumuli. Yongkambu weiwekkerik yombu yongok weiyagibokko ingenazewili ngeragi miza yaniweki miza logo yani wizigeya puwili wilik kagowindikku mizagewiyege pi kiling mogosa logo ni. ");
INSERT INTO big_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kazing mabilikmekke neyegi kiriweiwili ne kiling koyimowei menalege ngeragi ni kapura kalike yombanu neyegi kumbak mizi puwiligu neyegi kiriweiwiliyaga niza orowei puwekke puwili ya kunengmokko mizagewiyege kazing wilek kang mabiyeng Anotoyegi waberek mizagirikki tiya maniweki ngeragi ni ono mizimek mizagi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Keya kazing yombanu Palisiwili meiwiligi weremek keya Yisugi kazing wikmek sawela nelegi puwili waligeleyiweki Yisugu ngago saweliwei pera puwiliyegi kozak yeiya, Nakko melewangka wik narikka walerik ngela logo paka melewangka were koliyarikke lolo ulagi ono. Tamizeige pi pilik mizi purik melewangka wiktik kaile mizagi keya melewangka wererik ngoluk sobok wiziyagi. ");
INSERT INTO big_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Keya nakko kai waing wikpek keremiziwekkerik were pi kik wata korik wikyeng keremiza logo kai waing wikpek kubuli. Pi kai waing wikpek panga kik wata korik wereyengke kubulagi ono. Pi pilik miza purik kai waing wikpek sibesibe wari lewawekke wata korik wereyeng potora logo waimbek panga ngabelakke kubula welagi keya kik wata korikyeng yeikki. Piliktikki wiyeke kai waing wikpek panga kik wata korik wikyengke kubuliweki. Kazing mabilikmekke negi kazing wikmok kazing weremekke sawelagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wok nakke Yudawili yawe mizi ono puwiligu Anotoyegi ya kumulibek logo wok Sabatpek meibekke Yisu kiling yombu ngezebokko waligeleyiwili yawe pandi wit nalei neing wei kambela logo yombu puguwili kunimowei wit wire pandiyeng kelikyengki wireyeng tiya logo ni mizi kuna. ");
INSERT INTO big_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Puwiligu pilik miza purikki yombu Palisi mei nawiligu pakela logo Yisuyegi pelik ngalik meiya, Keriye, Lo tonugurago wok Sabatpekke yawe mizi nagani kaiyara puwiligu ngelira nangki, meiya. ");
INSERT INTO big_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tegi Yisugu puwiliyegi pelik yeiya to mela, Inuwago Anotogi Kapiya Walektikke tenigi yelibungang kokawiligi ngaibek Tawitigu koka walaka miza purikki sangkela puragi kumuli. Wok nakke Abiyata yombu Anotoyegi kolak miziwiligi ngai yemane panubek wiziyawekke Tawiti keya pi kiling puwili ngeragiyengki yeik wizigeya yagasi miza, legi ");
INSERT INTO big_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tawiti Anotogi imakke yeke ige la logo Abiyatayegi nguk meiya logo iwing perek Anotogi mowiya piyengka weiya logo na keya yombu pi kilingwilirau yani miza. Puragi ini sangkela kapura ini ngizi iwaka ono. Lorago pelik kai, Iwing perek piyeng yombu yeikwili ni nagani, yombu Anotoyegi kolak miziwili keke nagiyeng, kai. Kapura Anotogo puragi ngalik kai ono, legi inuwarau negi yombu ne makngezogo waligeleyiwiliyegi ngalik yei nagani, yeiya. ");
INSERT INTO big_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pugu pilik yeiya logo pugu mawinda pelik yeiya, Anotogo were yongkambanuwili keremiza logo kalike puwiliyegi wiyeke wok yawe mizi onobek puwiliyegi sawelibene keremiza. ");
INSERT INTO big_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Keya ne yombanu paka ngalega kayimabek, ne wok yawe mizi onobekki ngaibek keya ne watabi yongkambanuwiligu wok yawe mizi onobekke mizagi piyengki kaiyagibek, yeiya. ");
INSERT INTO big_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pulaga wok Yudawiligi yawe mizi onobekke Yisu ngereke Yudawiligi i walek songonomakki yeke ige la logo pulogo yombu melelora koru miza nak wizilege. ");
INSERT INTO big_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yombu Yisuyegi kiyebuk miza nawili pulogo piyegi pakelara ngai koyilege. Puwili Yisugu kazing korowali nayeng mizi purik kebangkelagiwili. Tamizeige pugu pi wok yawe mizi onobekke yombanu kemegeme nak yombiyangai wazamiyagi ma talik miza legi puwili mereke panu ngai koya. ");
INSERT INTO big_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Togo Yisugu yombu melelora koru mizabekyegi pelik meiya, Welawekke pelege koli, meiya ");
INSERT INTO big_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","logo Yisugu kumula puwiligiyengki iwaka legi puwiliyegi pelik nguk yeiya, Wok yawe mizi onobekke lo tonuwagirago pangka miziweki kaiyayeng nangaiyeng? Teni yombanuwiliyegi wazono miziweki kai ma kaile miziweki kai? Ma teni yombanuwiliyegi sawela logo wazono yolugiweki kai ma yela logo ibeng wazayiweki kai? Pilik nguk yeiya kapura puwili nakko ngago nara kisa ono. ");
INSERT INTO big_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Togo Yisugu puwiliyegi sisikta kiling pakeliwei miza keya ngereke pi puwiliyegirau yalek miza, purik ya puwiligiyeng kozang kopong yalek kelirarau ya puwiligiyengke ono. Kapura pugu yombubekyegi melelo nugura tungkule meiya. Logo pi melelo pugura tungkula logo weik ngereke yombiyangai sa. ");
INSERT INTO big_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Togo nguk namizi yombanu Palisiwili meiwili i walek songonomakka welagela yerageya logo puwili kiling yombu ngai Elodoyegi kiriwei nawilirau wawere ula logo kazing Yisu ula logo ibengki namekki kozak kela. ");
INSERT INTO big_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Togo Yisu kiling yombu ngezebokko waligeleyiwili pulumeng wiya logo pongo kai kolamiya Kalili meibekke kambela. Keya yongkambanu kolokngagono ngabelak Kalili meibekkawili piyegi kalika kiriwei kambela. Yongkambanu nawilirau piyegi wiriya. Puwiliyaga nawili paka ngabelak Yudaya meibekki yereng nayengkawili ");
INSERT INTO big_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","keya paka Yirusalem yereng yemaneragawili keya yenge ngabelak Idumiya meibekki yereng nayengkawili keya kabelak kai Yolodang meilingka pangazuwage purikkawili keya pongo Taya keya Sairong yereng kai wizambekkiyaugawili kiling yereng piyaugi ngezege piyengkawili. Puwili mabuwili Yisugu miziyengki kerewiya kopong puwili piyegi pakeliweki wiriya. ");
INSERT INTO big_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yongkambanu kolokngagono panuwili piyegi tektek kangane mizi legi yongkambanuwiligu pi momane meiya nelegi Yisugu yombu ngezebokko waligeleyiwiliyegi pigi wang nalei kangkere miziweki yeiya logo puleige mogosa logo yongkambanuwili waligeleyibene. ");
INSERT INTO big_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yisugu yongkambanu kolokngagono kemegemewili yombiyangai wazayarikki wiyeke ngoluk kemegeme kolokngagono nawilirau Yisuyegi tektek kangane mizi lewa logo pugu puwili yombiyangai wazayibene. ");
INSERT INTO big_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Keya kerewa yombanuwiligi yenge yungke koya puwiligu Yisuyegi pakelawekke yombanu puwiligu kiliya yolu puwili Yisugi ingewerege ulu wala logo pelik kek kisibene keleyi, Ni Anotogi Marekpek kisibene keleyi miza. ");
INSERT INTO big_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kapura Yisu kiyebuk legi pugu kerewawiliyegi kozang ngago yeiya pi Anotogi Marekpek purikki yongkambanuwiliyegi kozak yeiya nelegi. ");
INSERT INTO big_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pulaga Yisu paka lewege kambela logo pugu yombanu piyegi yawe miziweki izagiweki miziwili piyegi wiriyibene ngago yeiya logo puwili piyegi wiriya. ");
INSERT INTO big_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Togo puwiliyaga pi meleyau keya pongo ingenazikka neyauwili iza logo pi kiling koyiweki keya kalike pi puwili wezayela logo puwili yongkambanuwiliyegi Anotogi ngagoragi kozak yeiweki ");
INSERT INTO big_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","keya puwili kerewawili yongkambanuwiliyaga welagela wezayelagi puragi kozanda keya pangkara yaniweki. ");
INSERT INTO big_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yisugu yombanu izawiligi yeikyeng peyeng, nak Simong Yisugu Pita meibek, ");
INSERT INTO big_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","neyau Jems keya pigi sakpek Yowan Sebetigi marekyau Yisugu yeikta wik Powanesi meiyayau. Yeik pura lendikki marekyau kai yagenda purik kazing piyaugiyeng lendik kelik legi. ");
INSERT INTO big_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Keya Enduru, keya Pilip keya Patolomiyu, keya Matiyu keya Tomasi, keya Alapiyagi marekpek Jems, keya Tariyasi, keya Saimon. Saimon yombu Selete Yudawili Romwiliyaga yaliya wazayiweki liwik yawe miziwiliyaga nak logo puwiligu pi Saimon Seletebek meibek, ");
INSERT INTO big_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","keya nak Yuras Isaliyoto kalike Yisu ulagiwiliyegi miza yanagibek. Pilik miza logo Yisu i namakki kambela. ");
INSERT INTO big_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Keya yongkambanu kolokngagonowili ngereke menalege piyegi wawere uli mizi logo Yisurau pangka ngeragi nagi langai ono. ");
INSERT INTO big_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Keya yongkambanu nawiligu pelik kisi, Pi lelewe mizi, kisi legi ingini puguwili puragi kerewiya logo puwili pi miza wariweki kayima. ");
INSERT INTO big_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Keya yombanu Mosegi loyengki waligeleyi nawili paka Yirusalemga lewawili i pumakke koyimowei pelik kisi, Yisu kerewawiligi ngaibek Sadang, yeik pigi nara Piyesebu, logo Piyesebu piyegi yenge yungke ngai yolu. Keya pokko Yisu kerewawili yongkambanuwiliyaga welagela wezayeliweki kozang mani. ");
INSERT INTO big_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pilik kisi legi Yisugu puwiliyegi piyegiweki ngago yeiya logo pugu puwiliyegi ngago saweliwei pera pelik kozak yeiya, Inugu kumularik Sadangko pi ngezebek yongkambanuwiliyaga welagela wezamelagi ma talik? Yeik. ");
INSERT INTO big_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tamizeige kapmanwili ngezewiligi tepekke ngai keli puwekke purik kozang koyagi ono logo kawiyegi. ");
INSERT INTO big_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma tamizeige yombu nak ibuwili ngezewiligi tepekke ngai keli puwekke purik sanga miza logo nawili narikke miza melagi. ");
INSERT INTO big_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kazing mabilikmekke tamizeige Sadangki kerewawili ngezewiligi tepekke ngai keli purik Sadangki ngaimek kozang wizei penangai ono, yeikki. ");
INSERT INTO big_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Keya nakkorau yombanu kozambekki imakke yeke ige yabela logo watabiyeng ngoweiyagi langai ono, kapura tamizeige pi were yombanu kozambek wigira wazamiya mabura kele pi pangka watabi pugu kelagi mabiyeng ngoweiyagi langai. Togo purikku kai purik Sadang kozang kapura ne kozang panu kani, logo nogo pangka Sadang keya pigi ngaimek yongkambanuwiliyaga welagela wezayelagi. ");
INSERT INTO big_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kerewiyi. Wameik panu. Yongkambanu ngabelakkewiligu kaile mizayeng mabiyeng keya ngago kaile puwiligu kisa piyeng mabiyeng puwiligu Anotoyegi kozak mei purik Anotogo tumulagi ");
INSERT INTO big_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kapura nakko Anotogi Kung Walekpekyegi langai ngago kaile kaiya purik Anotogo pura tumulagi ono, Anotogo pugu kaile kaiya pura kebangkela wizagomagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yisugu pura kozak yeiya purik nawiligu pi kerewa nak yenge yungke yolu kisi legi. ");
INSERT INTO big_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mabuwekke Yisugi panumele keya sakwili wiriya logo imakka yenge yerengke luweza koyimowei ngago nara yeke ige piyegi pi yeragibene wezamela. ");
INSERT INTO big_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yongkambanu kolokngagono Yisu yawereng kelemiyara mogosara koyawili nakko piyegi pelik meiya, Nigi panumele keya sakwili yenge yerengke yuke koyimowei niyegi ngago kisi, meiya. ");
INSERT INTO big_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tegi Yisu pelik meiya to mela, Negi panumele tamele keya negi sakwili tawili, yeiya. ");
INSERT INTO big_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Togo pugu mogosawiliyegi pakeli yongomo miza logo pelik yeiya, Kerewiyi, ini pewili negi panumele keya sakwili kani. ");
INSERT INTO big_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Keya Anotogo mizagi keliyeng mizi mologabok negi sakpek keya negi sakmele keya negi panumele, yeiya. ");
INSERT INTO big_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pulaga Yisu ngereke pongo kai kolamiya Kalili meibekke kerelege luweza wizimowei weik ngago wazonora yongkambanuwili waligeleyi. Keya yongkambanu kolokngagono panuwiligu piyegi tektek kangane kelemiyageya koyimowei yawereng kelemi, legi Yisu wang naleige tameneng meiya logo mogosa, logo wanglei panga kaibekke songono nangezi kuna logo pugu wangleiga wizimowei yongkambanu pulogo kaingimbekke wawere ula koya puwili waligeleya. ");
INSERT INTO big_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Keya pi puwiliyegi ngago saweliweiyengko ngago ngizi kolokngagonoyeng waligeleya. ");
INSERT INTO big_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Pugu ngago saweliwei nara pelik yeiya, Kerewiyi, wok nakke yombu nak pandi wilekyeng yawege wezameli kambela. ");
INSERT INTO big_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pi wezameli kunarik wilek nayeng ngabelak kozang yongkambanuwiligu wei mizibekke wala logo winakwiligu kanda na. ");
INSERT INTO big_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Keya wilek nayeng ngabelak kingyeng kilimbekke ngalege wala kapura ngabelak songonobek kopong pengyeng nguk namizi lewagela logo ");
INSERT INTO big_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","yokmek ngaiwekke yokmokko pak meiya logo ngoliya keya puliliyendau songono kopong peyendau ibeng sa. ");
INSERT INTO big_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Keya wilek nayeng ibek ingakyeng kilingyengki tepekke wala kapura ingak piyengko momanenda wiya logo pengyeng ibeng sa logo wilek wiri ono. ");
INSERT INTO big_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Keya wilek nayeng ngabelak yombiyangaibekke ngalege wala kopong marekyeng lewa wizigeya yemane sa logo wilek wazonoyeng wira. Kang nayeng wilek songono wiri, keya kang nayeng wilek yemane wiri, keya kang nayeng wilek yemane panu wiri. ");
INSERT INTO big_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yisugu saweliwei pura kozak yeiya logo pugu puwiliyegi pelik yeiya, Ini kerangangyeng kilingwili mabura waberek kerewiyi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kalike mamok wei miza mela wizigeya Yisu keke wiziyawekke yombu meleyau keya pongo ingenazikka neyau Yisu ngezebokko waligeleyiwili kiling yombanu piyegi kiriwei nawilirau piyegi wiriya logo puwili Yisuyegi pelik nguk meiya, Ngago saweliwei yaka nugu kai puragi solorik taliktik, meiya. ");
INSERT INTO big_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Legi Yisugu puwiliyegi pelik yeiya to mela, Anotogo ini ne kiling sawela puwiliyegi watabi Anotogo pigi ngaimekki ngai yolu puragi koka iwaka ono piyeng kimeike kelemiweki keli logo nogo iniyegi saweliwei purago kai puragi kozak yeiweki mizi. Kapura yongkambanu Anotogo puwiliyegi ngaiweki keleyi ono puwiliyegi nogo ngago saweliweiyeng kozak yei kopong puwili lusuwei. ");
INSERT INTO big_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Pilik mizi pura Isayago Anotogi Kapiya Walektikke pobilik kaiya puragi kiriwei, Purik puwiligu wire puwiligiyengko yawe nogo miziyengki pakeli kele kapura puwili ngizi pakeli ono, keya puwili ngago nogo kai puragi kerewiyi kele kapura ngizi panu kumuli ono. Purik tamizeige puwili ngizi kumuli kesak puwiligi wilek kangyeng neyegi kowita logo nogo kaile puwiligu mizayeng tumulagi, kaiya. ");
INSERT INTO big_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Keya Yisu puwiliyegi mawinda pelik yeiya, Ini ngago saweliwei nogo yaka kaiya puragi solorik lusuwei, legi ngago saweliwei nogo kalike kozak yeiyagi piyengki soloyeng ini nguk namizi iwakagi ono. Kapura ini ngago saweliwei nogo yaka kaiya puragi solorikki iwaka si nangaiweki kerewiyi. ");
INSERT INTO big_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yombu pandi wilekyeng yaka wezamelabok yombanu Anotogi ngago wazonora yongkambanuwiliyegi kozak yeibok kelikpek. ");
INSERT INTO big_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Keya ngabelakpek yongkambanu Anotogi ngago wazonoragi kerewiyi puwili kelik. Logo ngabelak kozang wilek nayeng wala logo winakwiligu kanda nabok yongkambanu Anotogi ngago wazonoragi kerewiyi kapura ngizi kumuli ono puwili kelik logo puwili ngagora kerewiyi puwekkerik Sadangko nguk namizi kanda ngago pura puwiliyaga weiya logo wezameli. ");
INSERT INTO big_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Keya ngabelak kingyeng kilimbok yongkambanu kerewiyi nawili kelik logo pura nguk namizi weiyagirikki wilik ");
INSERT INTO big_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","keya wilek marekyengki puliliyeng yenge ngabelakke kiliya kula ono mabilik puwili ngago puragi kumula kapura wilek kang puwiligiyengke yenge yungke kiliya panu ono, logo puwili Anotogi ngago wazonoragi ngizi kumuli purikki wiyeke kunengyeng yani ma ngangang keleyi puwekkerik puwili nguk namizi Anotoyegi kezanga mani logo puwiligi ngizi kumulara yeikki. ");
INSERT INTO big_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Keya ngabelak ibek ingakyeng kilimbek yongkambanu kerewiyi nawili kelik logo puwili Anotogi ngagora kerewiya kele ");
INSERT INTO big_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kapura kazing ngabelakpekki kunengyengki kumuli pumok, keya kingyengki ibeng si pumok, keya korikwekko keli piyengki kira orowei mizi pumokko Anotogi ngagora waliya logo kazing puwiligu Anotoyegi mizi piyeng ngizi onowili. ");
INSERT INTO big_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kapura yongkambanu nawili ngabelak wazono wilekyeng walabok kelikwili. Puwili Anotogi ngagoragi kerewiyi logo wei logo pura wilek kang puwiligiyengke kozang kebangkela yoluwili. Logo puwiligu miziyengki ngiziyeng weik kimeike lewagela. Nawiligu purikki ngizirik walimizimek songono, keya nawiligu purikki ngizirik walimizirik yemane, keya nawiligu purikki ngizirik walimizirik yemane panu, yeiya. ");
INSERT INTO big_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Keya ngereke Yisugu ngago saweliwei pera pelik yeiya, Yombanu nak lambek langiya logo yeke ige oroweirik kaimirage kulengke wiyi ma lalektage yenge kulengke wiyagi ono, a’a’. Nakkorau pilik mizagi ono, pilik segeya pi orowei paka ngalege kimeike wirami wazamiyagi. ");
INSERT INTO big_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kazing mabilikmekke watabi mabek Anotogo pigi ngaimekki ngai yolu puragi langai liwik wiya piyeng kalike kimeike kawela wiyagiyeng, keya watabi mabek Anotogo pigi ngaimekki ngai yolu puragi langai ngokmana piyeng kalike ngokmana piyengka lewagela wiriyagi logo yongkambanuwiligu piyeng iwakaweki. ");
INSERT INTO big_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yombanu kerangang kerewiyagiyeng kiling puwili mabura kerewiyizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Keya Yisugu mawinda pelik yeiya, Ngago nogo kai puragi waberek kerewiya panu logo wilek kang inuguyeng puragi tiya mani. Purik yombanu ngagoragi wilek kang puguyeng songono tiya manibokyegi Anotogo ngizira songono managi. Kapura yombanu ngagoragi wilek kang puguyeng unatuba tiya manibokyegi Anotogo ngizira unatuba managi keya Anotogo pokyegi ngoluk ngago ngizira mawiyarekka managi. ");
INSERT INTO big_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Purik tamizeige yombanu namele keya nak Anotogi ngagora kebangkela logo kiriwei yolu mologabok Anotogo pi ngizira mawinda managi kani kapura tamizeige namele keya nak ngago puragi kiriwei ono purik Anotogo ngago pilik mologabokko songono kebangkela yolu nobiyeng miza pura piyaga weiya mowiyagi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Keya Yisugu puwiliyegi mawinda pelik yeiya, Anotogo pigi ngaimekki ngai yolu pura yombanu ngeragi wilekyeng yaweleige ngeriyi pok kelik. ");
INSERT INTO big_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Yombu nak wilekyeng yawe puguleige ngeriya logo wok mabiyeng pi kusage iwek koli keya yoklongko wei mizi logo wilekyeng lewagela kapura talik mizi miza purik pi lusuwei. ");
INSERT INTO big_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ngabelakpek ngezebokko yawe pura miza logo were pendik lewagela keya pulaga kaburik keya pungeziga pura kaburik weik wilekyengko kola. ");
INSERT INTO big_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wilekyeng kuk puwekke yaweleigi mangobek lawek kiling yaweleige kunimowei pelik kai, Wilekyeng wawiyagira weik lewa. Kazing mabilikmekke Anotogo pigi ngaimekki ngai pura kozang teni pakelagi ma iwakagi langai onorago yemane sibene kelemi lewa, yeiya. ");
INSERT INTO big_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Keya Yisugu pelik yeiya, Nogo Anotogo pigi ngaimekki ngai yolu pura nangaiyeng kelik kaiyagi? Keya ngago saweliwei taliktago ngai pumokki langai kozak kaiyagi? ");
INSERT INTO big_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anotogo pigi ngaimekki ngai yolu pura yengelei wilek Mastet mei nak kelik. Yengelei wilek Mastet meiyeng wilek nayeng kelik yemane ono, yengelei Mastet puleigi wilekyeng songono panu ");
INSERT INTO big_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kapura yombanu nakko Mastet nak ngeriya puwekkerik kalike purik yengelei nayengka yemane panu lewagi. Keya puleigi meleyeng yemane panu logo winakwiligu kanda yengelei meleyengke igazi mizagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Keya Yisugu ngago wazonora yongkambanuwiliyegi kozak yei kunarik ngago saweliwei kolokngagonoyengko Anotogi ngagora kozak yei miza. ");
INSERT INTO big_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pugu puwiliyegi puwiligu kumula puragi pangka pangka kozak yeiya. Pugu puwiliyegi ngago saweliweiyengke keke kozak yeiya kapura kang nayengke pi yombanu ngezebokko waligeleyiwili iza orowei lewe narikke kuna logo kimeike panu ngago saweliwei piyengki soloyeng kozak yei miza. ");
INSERT INTO big_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wok mabokko ibengke yokmek kiliyawekke Yisu yombanu ngezebokko waligeleyiwili kiling wangleige mogosa koyimowei pugu puwiliyegi pelik yeiya, Teni kai kolamiyabek wala uwei lalu pangazuwagawekke kangweki, yeiya. ");
INSERT INTO big_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Togo puwili yongkambanuwili wezayela logo weik pi kiling puwili wang naleige kuna keya wang nayendau puwili kiling menalege kambela. ");
INSERT INTO big_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Puwili kaibekki ngalengale tagoneige kebarek unatubabek kaibekke uli yongomo mizi logo kaibek wangleige wilakweki mereke. ");
INSERT INTO big_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yisu yaka mabura wangleige yeke kalike ngandektikke kebi pugura wiya logo pi iwek kola. Yombanu ngezebokko waligeleyiwiligu pi waliya kelemiya logo pelik meiya, Kiriwagabek, teni weik kaiyaga niweki mizi. Ni mizi perikki keriyi ono, yeik karagare iwek kola yolura nangki? ");
INSERT INTO big_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Logo Yisu yangalek meiya logo kebarekpek ngalik meiya logo kaibekki pelik meiya, Yek wizei, meiya. Togo kebarekpek weik yeik keya kaibektau weik yelakkelek wiziya. ");
INSERT INTO big_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Togo Yisugu puwiliyegi pelik nguk yeiya, Ini wilek ngelek kumulira nangki? Ini nogo iniyegi ngaigi langai purikki neyegi ngizi kumuli ono ma talik, yeiya. ");
INSERT INTO big_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kapura puwili kazi miza keya lelengkira keya nakko nakyegi pelik meiya, Yombanubek talikpek logo kebarekpek keya kaibektau pugu kairagi kerewiya logo kiriwei mizi, meiya. ");
INSERT INTO big_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pilik miza logo puwili wangleige ngalengale kuna logo waleleige puwili Kai Kalilibekki lalu pangazuwagawekke ngabelak Kegesa meibekke kanda wila wiya. ");
INSERT INTO big_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pulogo yombanu lelewe kerewa nak yenge yungkebek yolu keya yombanubok yombanu mosindage iwek keya yolubek. ");
INSERT INTO big_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nakkorau pi sengyengkorau wigiragi langai ono. ");
INSERT INTO big_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kang kolokngagono inge keya mele puguyeng sengyengko wigira wazamiya kapura kang mabiyeng kerewabekki kozandago seng inge keya mele puguyeng wigirayeng ngela. Kozang pugura yemane panu logo yombanu nakkorau pi waliyagi ono. ");
INSERT INTO big_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kusaga yoklongko pi yombanu mosinda keya lewakyengke ingkeya kelele kaiyageya wizimowei kingyengki ngalege kawiye walimizibek logo korik puguwek lamiti wilibekpek. ");
INSERT INTO big_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pugu koweiga wizimowei Yisu wangleiga welagelarikki pakelawekke pi nginda kanda Yisugi inge werege ulu wala logo Yisugi yeikta yongolok meiya. ");
INSERT INTO big_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Tegi Yisugu kerewabekyegi pelik meiya, Kerewabek, ni yombanubekyaga welagela kune, meiya kapura kerewabok Yisu Anotogi Marekpek purik pi iwaka kopong pi ngalizi pelik kek meiya, Yisu, Anoto Yemizi Ngizi Lewege Panubekki Marekpek, nugu neyegi nangaiyeng keleniweki mizi? Nogo Anotogi wirege niyegi pelik nguk nei ne ngangang keleni nagani, meiya. ");
INSERT INTO big_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tegi Yisugu piyegi pelik nguk meiya, Yeik nugura talik mei? Pilik mei legi pugu pelik meiya to mela, Yeik nogora Ngelekpek, purik teni kolokngagonowili legi, meiya. ");
INSERT INTO big_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Keya pi Yisuyegi pelik mazeng keya nguk meiya, Nugu teni kerewawili ngabelak nakke kang wezayeli nagani, meiya. ");
INSERT INTO big_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lewak songono mereke pulogo wizilegebekke liyeng kabe kolokngagono namek ngeragi ni yo keya to mizageya koyilege. ");
INSERT INTO big_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Togo kerewawiligu Yisuyegi pelik kelegele meiya, Nugu teni liyeng puwiliyegi kiliya wezayele, meiya. ");
INSERT INTO big_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tegi Yisugu puwili liyeng puwiliyegi kiliya wezayela. Togo kerewawili yombanubekyaga welagela panga liyengwiliyegi kiliya logo liyengwili sangkelarik tausen neyau tikinda puwili lelewe miza logo lewakpekka nginda kanda wilekwekka yenge kaibekke kiliya logo kaiyaga na. ");
INSERT INTO big_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yombu liyengwiliyegi yaka ngai koyimawili yaka miza puragi pakela logo puwili nginda kambela logo ngago yaka miza puragira yongkambanu yereng yemaneyeng keya songonoyeng keya yaweyengke yawe miziwiliyegi kozak yei miza. Logo yongkambanu ngago puragi kerewiyawili yaka miza puragi pakeli kambela. ");
INSERT INTO big_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Puwili Yisuyegi kanda pura yombu yaka kerewa ngelekwili piyaga welagela wezayelabok lelewemek yeik wizigeya kagorik tiya logo Yisu kiling mogosara wizilege pakela logo puwili kulili panu miza, purik kozang yemanera kiling piyeng miza purikki puwili iwaka kopong. ");
INSERT INTO big_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Togo yongkambanu yaka miza puragi pakela puwiligu yongkambanu yaka miza puragi napakeli puwiliyegi Yisugu miza logo yombubek yombiyangai wazamiya keya liyengwiliyegi miza puragi kozak yeiya. ");
INSERT INTO big_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Togo yongkambanu panga Kegesa pulumengka puwili mabuwili kulili panu miza. Logo piliktikki wiyeke puwiligu Yisu nalege kangweki kelegele meiya. ");
INSERT INTO big_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tegi Yisu panga wangleige ngalege yabela logo kangweki miza kapura yombu yaka kerewawili piyaga welagela wezamelabokko Yisuyegi pelik kozang nguk meiya, Ne ni kiling kangweki, meiya. ");
INSERT INTO big_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kapura Yisugu piyegi, Ei, meiya ono segeya pelik meiya, Yereng ni makngezegirage kambele logo nigi ingembuwiliyegi ne Yemizibokko niyegi yalek miza logo ni wazono keleniya purikki kozak yeimo, meiya. ");
INSERT INTO big_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Togo yombanubek pulumeng wiya logo ngabelak Tekapoli meiyabekke kambela. Ngabelak Tekapoli meibekke yereng meleyauyeng yolu logo yeik Tekapoli purago kai purik yereng meleyauyeng kai yagenda, legi puwiligu ngabelakpek Tekapoli mei. Logo pulogo yombanu yakabokko Yisugu yaka wazono piyegi miza piyengki kozak yei kai kambela. Logo yongkambanu puragi kerewiyawili lelengkira. ");
INSERT INTO big_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yisu kiling yombu ngezebokko waligeleyiwili wangleige kai kolamiyabekke pezuwaga wala uwei yowekke yongkambanu kolokngagonowili laluwekke pi yawereng kelemiya. ");
INSERT INTO big_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Logo Yudawiligi i walek songonomakki ngai nak, yeikta Yaira meiyabek wiriya logo Yisuyegi pakela logo pi Yisugi ingeyauge ulu wala logo ");
INSERT INTO big_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","pelik kozang nguk meiya, Negi yangomele kemegeme yemane panu mizi logo ibengweki mizi. Ni ne kiling ngezangai i nogomakke kangweki koli. Yek mele nuguzikku piyegi walamiya logo pi wik wazono yoluweki, meiya. ");
INSERT INTO big_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Togo Yisu pi kiling weik kambela. Keya yongkambanu kolokngagonowilirau piyau kiling kambela keya puwiligu Yisuyegi yekezuwaga yengezuwaga kelemi kambela. ");
INSERT INTO big_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Keya yongkambanuwiliyaga yongok namele wok iwi walayeng weik yeik ono, kirisimasi meleyau keya pongo ingenazikka neyau piyeng iwi walageya wizagomimelerau wiziya. ");
INSERT INTO big_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Koka pi tota kolokngagonowiliyegi pakeliweki kambela kapura king puguyeng mabiyeng yeik wezamela, purik totawiligu yombiyangaigi nobiyeng kelemiya kapura nakkorau pi pangka wazamiyagi langai ono, kemegeme pugumek yolu keya mawiyarekka yemane si kang. ");
INSERT INTO big_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yongok yakamolo ngago Yisuyegi langai puragi kerewiya logo pi yongkambanuwili kiling Yisuyegi kalika kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Logo kumula ngezemelegiraga pelik kaiya, Ne korik puguwek ma kagorik puguriktau mele nogozikku kuming kelemiya mabura ne yombiyangai wazaniyagi, kaiya. Tegi yongokmolo kagorik pugurik kuming kelemiya ");
INSERT INTO big_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","logo pigi iwi walibok weik nguk namizi yeik. Pilik miza logo yongokmele ngezemologo pi Yisugu wazono kelemiya purikki iwaka. ");
INSERT INTO big_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yisugu kozang pugubek yaka piyaga namele keya nak yombiyangai wazamiweki welagela kang purik iwaka, legi Yisu kowita to mela logo pugu yongkambanuwili mabuwiliyegi pelik yeiya, Takko kagorik nogorik kuming kelemiya, yeiya. ");
INSERT INTO big_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Logo yombu Yisu ngezebokko waligeleyiwiligu pelik meiya to mela, Yongkambanu kolokngagono kani. Logo ni takko kuming keleniya kaira nangki, meiya. ");
INSERT INTO big_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kapura Yisu ngoluk pakeliwei mizi, takko miza miza legi. ");
INSERT INTO big_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Togo yongokmele Yisu pi yaka yombiyangai wazamiya purik iwaka, legi pi kulili keya leli uli kanda Yisugi ingewerege pulogo inge puguyau laliya logo Yisuyegi kemegememek keya pi kuming kelemiya ngizige pugu pi yombiyangai sa wazamiya pura maburagi kozak meiya. ");
INSERT INTO big_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Pilik miza logo Yisugu piyegi pelik meiya, Yongokpanumele, nugu neyegi ngizi panu kumulirikku ni weik yombiyangai wazaniya mena, ni wilek kang ngezege sara kiling kambele. Kemegeme nugumek weik yeik. ");
INSERT INTO big_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yisu ngoluk pura kaiyageya wizigeya yombu ngago oroweiwili Yaira ngaibekki imakka piyegi lewa logo Yairayegi pelik meiya, Nigi yangomele yaka ibeng, legi Kiriwagabek yeik ulak kambela nera wizi pani, meiya. ");
INSERT INTO big_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yisu puwiligu kisi puragi kezanga mana logo Yairayegi pelik meiya, Ni kazi mizi nagani, ni neyegi yeik ngizi kumula wizeimo, meiya. ");
INSERT INTO big_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Togo Yisugu yongkambanuwili pi kiling kangki ono yeiya kapura Pita keya Jems keya Jemsgi sakpek Yowan morok keke pi kiling Yairagi imakke kambela. ");
INSERT INTO big_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Puwili yeke Yaira i walek songonomakki ngaibekki imakke kanda pulogo Yisugu yongkambanuwili meiya meli keya miza melageyarikki pakela keya yongkambanu yeke ige kolomandikmeleyegi wiyeke ingkeya ngabik ngalizi mizirikki kerewiya. ");
INSERT INTO big_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yisu yeke ige la logo puwiliyegi pelik yeiya, Ini wirangaiyau meiya meli kang keya mizi piyeng nangaiyengki weraga? Keya ini ingkeya ngabik mizira nangki? Kolomandikmele ibeng ono, pi yeik ngoluk iwek kola wizinda, yeiya. ");
INSERT INTO big_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kapura puwiligu piyegi ngizi panu kumula ono kopong puwili Yisuyegi songomeiya mana. Tegi pugu puwili yenge yerengke welagela wezayela logo pugu kolomandikmelegi panu keya mangoyau keya pi kiling ngezebokko waligeleyi puwili keke yeke ige kolomandikmele wazamiyamakke la. ");
INSERT INTO big_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Logo pugu kolomandikmelegi melezikka weiya logo piyegi Yudawiligi ngago yeiktage pelik meiya, Talita kumi, meiya logo purik pelik mei yagenda, Kolomandikmele, yangalek mei, mei yagenda. ");
INSERT INTO big_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mabuwekke kolomandikmele weik yangalekta logo weik wei miza. Kolomandikmolo kirisimasi meleyau keya pongo ingenazikka neyaumele. Pilik miza logo nguk namizi puwili yemane panu lelengkira keya mele puwiligiyeng kilige mana. ");
INSERT INTO big_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kapura Yisugu puwiliyegi yawe kozang mabek miza puragi nawiliyegi kozak yeiya nelegi, yeiya. Togo pugu puwiliyegi, Ngeragi nayeng kolomandikmele nibene manizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pulaga Yisu yereng pura wiya logo panga yereng ngezebekkira Nasarete meirage kandobela. Yombu Yisu ngezebokko waligeleyiwili piyegi kiriwei kambela. ");
INSERT INTO big_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Logo kanda pulogo keya wok Yudawili yawe mizi ono Anotoyegi ya kumulibek wok Sabat meibekke pi Yudawiligi i walek songonomakke yeke ige la logo weik yongkambanuwiliyegi Anotogi ngagora waligeleya. Yongkambanu kolokngagono pulogo koya puwili ngago pugu kaiyengki kerewiyawekke puwili Yisugi kangkabek yemane panu purikki lelengkira. Logo nakko nakyegi pelik meiya yongomo miza, Teni pobokyegi iwaka. Pi yawe iyeng ngizira mizibek. Pigi panumele, Maliya keya pigi mandik sakwili Jems keya Yosisi keya Yuras keya Saimon puwili teni iwaka. Keya pigi kolomandik sakwili pelege yoluwili. Pi yombu yeikpek kapura ngago pugu kai piyeng pi talaga weiya? Keya pigi kangkabok takko mana? Keya takyaga kozanda weiya logo Anotogo keke mizi piyeng mizibene mana, meiya. Togo puwili pilik kumula logo puwiligu piyegi kezanga mana. ");
INSERT INTO big_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tegi Yisugu puwiliyegi pelik yeiya, Yombanu Anotogi ngagora kozak kaibok yongkambanu ngabelak kalogomokpekkewiliyegirik yeikta kiling keya puwiligu ngago pugu kai piyengki kerewiyi kapura ngabelak ngezebekkibekkewiliyegirik yeiktarau ono keya ngezebekyaga puwiligu ngago pugu kai piyengkirau kerewiyagi ono, keya pigi ingembungawilirau kerewiyagi ono, keya pigi panu keya mango keya si keya sakwilirau pugu kai puragi kerewiyagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Togo yongkambanu Nasarete yerengke koya puwili Yisuyegi ngizi panu kumuli ono kopong pulogo Yisugu Anotogo keke mizi nayendau mizagi langai ono, kapura pugu kemegeme mizi keremungke onowiliyegi keke mele puguzik walamiya logo yombiyangai wazaya. ");
INSERT INTO big_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Logo yongkambanuwiligu piyegi ngizi panu kumuli ono purikki pi lebuk miza. Togo yongkambanuwili pilik mizirikki wiyeke pi yereng nayengke kambela logo yongkambanuwiliyegi Anotogi ngagora waligeleya. ");
INSERT INTO big_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pulaga wok nakke Yisugu ngezebokko waligeleyi meleyau keya pongo ingenazikka neyau puwili piyegi wiriyiweki yeiya. Logo puwili weik kanda logo pugu puwiliyegi pelik yeiya, Inuwa neyau neyau kambeli yeiya, keya pugu puwili kerewawili yongkambanuwiliyaga wezayeliweki pangkara keya kozanda yana logo yawe pugura mizi kambelibene. ");
INSERT INTO big_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Keya pugu puwiliyegi ngago kiriwei mizagiyeng pelik yeiya, Kambeli kapura ngeragi ma kik ma king keya pilik orowei kelemi kangki nayendau wari nagani. ");
INSERT INTO big_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kapura lukunglei wari keya inge kangyau wakiyi, keya yeik inugu wakiya mabiyeng kiling kambelizo. Purik yongkambanu inugu i yolugi piyengkiwiligu iniyegi waberek ngaigi keya iniyegi saweli mizagi. ");
INSERT INTO big_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Keya ini yereng narage lewa puwekke i yombanu ini iza orowei kang puwiligiyengke yolu puwekke purik mabura i mabumakke koyi kanda kangki puwekke yereng pura wiya logo kang mizizo. ");
INSERT INTO big_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tamizeige ini yereng narage lewa logo pulogowili iniyegi koli keleyi ono keya ngago wazono puragi kerewiya logo wilek kang puwiligiyengko wei ono puwekke purik mabura yereng pura wiya wazamizo logo puwiliyaga mele inuguyeng kaigesizo logo puwili Anotogo puwiliyegi wilik ono keya inugu ngereke yereng purage puwiliyegi ngago wazonora kozak yeiweki yogi ono purikki puwili iwaka si nangai kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Togo puwili Yisu wezamiya logo puwili yongkambanuwiliyegi ngago kaile puwiligiyengki kuneng mizi keya kaile puwiligu miza piyengka kowita logo wilek kang puwiligiyeng Anotoyegi sawelagi puragi kozak yei kambela. ");
INSERT INTO big_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Puwiligu kerewa kolokngagonowili yongkambanuwiliyaga welagela wezayela keya kemegeme miziwiliyegi weli mela wazaya logo yombiyangai wazaya. ");
INSERT INTO big_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Togo ngago Yisu keya yombu pi ngezebokko waligeleyi puwiligu mizi piyengki langai pura ngabelakpekke ululu miza logo Yisugi yeikta weik yemane sawiya. Keya King Ngai Elodo panga Kalili ngabelakpekki ngaibek ngago pura kerewiyawekkerik pi kangka pugubek Yisuyegi langai wiyalowei miza, purik yongkambanu nawiligu Yisuyegi langai pelik kisa, Yowan kaimelibek ngereke ibendaga yangalekta wik yolu, legi kozang purago mizagewiyege mele puguzikku watabi kozang piyeng mizi, kisa. ");
INSERT INTO big_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nawiligu kisarik, Ilaya yombu Anotoyaga ngagora weiya logo kozak kaiyabek Poropek meibek walaka Anotogo korikwek kiling paka ngalege miza orowei kambelabok ngereke yo kisa, keya nawiligu kisarik pi poropek koka walakawiliyaga nak kelikpek, kisa. ");
INSERT INTO big_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kapura Elodo ngago pilik kisi piyengki kerewiyawekke pugu pelik kaiya, Pi Yowan yombu nogo koka kalokpek ngela logo ibembok ngereke weik wik yo wizinda kaiya. ");
INSERT INTO big_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Elodogo Yowan kaimelibekki kalokpek ngela purikki ngagora pelik, Ulogo Yowan kaimelibek ngoluk wik yoluwekke pi Elodoyegi kambela logo ngalik kozangka pelik meiya, Kazing kaile nugu nigi sak ngoluk wik yolubekki yongokpumele Elodiya meimele weiya yolu pumok pangka ono, meiya, legi Elodiya Yowanyegi sisik panu logo purikki wiyeke Elodogo yombu nawili wezayela logo Yowan kebangkela logo i wigirawiligimakke wigira wazamiya. ");
INSERT INTO big_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kapura Elodiya ngoluk Yowanyegi wilek kaile kumula logo pi uliweki keli kapura Elodo kiyebuk kai. ");
INSERT INTO big_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Purik Elodo iwaka, Yowan yombu pangkabek keya Anotoyegi keke yawe mizibek logo Elodo Yowanyegi kulili kopong pugu piyegi waberek panu ngai wiziya. Elodo Yowangu ngago wazono kaiyengki kerewiyawekke pi kangka neyau kumula. Logo pi kangka ngelek kumula mela kele kapura pi ngago pugura kerewiyagirikki wilik miza. ");
INSERT INTO big_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Togo wok nakke Elodogi yongokpumele Elodiya kazing Yowan ulagimek weik wok Elodo wazamiyabekke pugu ngeragi yemane miza niwekibekke yolok ngela. Ngeragi miza niweki pura ngaiwili keya amiwiligi yemane ngaiwili keya ngabelak Kalili meibekki yemanewiligira. ");
INSERT INTO big_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Puwili ngeragi nageya tagogei pura Elodiyagi yango kailemekkimele mereke kanda logo ngezemele yongolo yombuwiligu kelagi langaimekke uli. Elodo keya yemanewili piyegi pakela logo wilik yemane panu miza. Pilik miza logo King Ngai Elodogo kolomandikmeleyegi pelik meiya, Ni nangaiyeng weiyagi keli? Watabi nugu keli piyeng nogo ni nanagi. ");
INSERT INTO big_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nogo niyegi yombu yemane pewili mabuwiligi wirege keya Anotogi wirege wameik panu nei, nugu neyegi nguk nei piyeng nogo ni nanagi. Wameik, nogo ni watabi negi piyengka lewe nariktau nanagi, meiya. ");
INSERT INTO big_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pugu pilik kai legi kolomandikmele welagela kanda pigi panumeleyegi pelik nguk meiya, Nangaiyengki ne pebayegi nguk meiyagi, meiya logo panugu pelik meiya to mela, Nugu nigi mangobekyegi pelik mei, Nugu niyegi yawe mizibek i wigirimakke wezamele logo pulogo pugu Yowan kaimelibekki kalokpek ngela logo Yowangi kebira ne nanagi purikki ne keli meimo, meiya. ");
INSERT INTO big_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tegi kolomandikmele Elodoyegi nguk namizi nginda kanda pelik meiya, Peba, Yowan kaimelibekki kalokpek ngela logo nugu kebira pelengwekke ngalege wiya logo nguk namizi ne nanagi purikki ne keli, meiya. ");
INSERT INTO big_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Togo King Ngai Elodo pura kerewiyawekke pi kuneng yemane panu miza. Kapura ngago pugu yaka yemane ngeragi niweki kayimawili keya Anotogi wiregerau kaiya puragi weraga kopong pi ngago pugu sawiya pura ngelagi ono. ");
INSERT INTO big_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tegi pigi ngai kulengkewiliyaga nak wezamela logo Yowangi kalokpek ngela logo kebira orowei yo wiriyibene. Togo yombu ngaibek kuna logo i wigirawiligimakke Yowangi kalokpek ngela logo ");
INSERT INTO big_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kebira pelengwekke ngalege wiya logo orowei yorik kolomandikmeleyegi mana logo kolomandikmologo kebira pigi panumele Elodiyayegi mana. ");
INSERT INTO big_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pulaga Yowanyegi kiriweiwili pura kerewiyawekke puwili kambela logo Yowangi yasurik weiya logo mosindage waliya. ");
INSERT INTO big_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yombu meleyau keya pongo ingenazikka neyau Yisugu waligeleyi logo Aposolowili meiwili logo Yisugu ngago wazonoragi kozak yeiweki wezayela puwili yorik Yisuyegi wiriya logo puwiligu piyegi mizayeng keya yongkambanuwiliyegi kozak yeiya piyeng mabiyengki kozak meiya. ");
INSERT INTO big_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yongkambanu kolokngagonowili Yisu keya ngezebokko waligeleyiwiliyegi pakeli lewa keya kando keya nawili ngereke lewa keya kando mizi logo puwili leng mizi keya ngeragi niweki tek nariktau ono kopong Yisugu puwiliyegi pelik yeiya, Ne kiling koli, tonuwa ngezerau panga kabelak kuyangka ngagoluk yombanu naktau ono, yeiktaga leng miziweki kangweki mena, yeiya. ");
INSERT INTO big_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Togo puwili ngezewili wale kuyangka kai kolamiyabekki lalu pangazuwagawekke wang naleige ngalengale kuna. ");
INSERT INTO big_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kapura yongkambanu kolokngagono yereng piyeng mabiyengkawiligu puwili kang purikki pakela logo puwiliyegi iwaka logo puwili ngabelak libu nginda kuna. Togo Yisu keya ngezebokko waligeleyiwili kanda pangazuwage pura yombanu ngabelak libuwili yaka were lewagela koyilege. ");
INSERT INTO big_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Logo Yisu yombanu kolokngagonowiliyegi pakela logo pi yalek miza logo pelik kumula, puwili liyeng memengwili kelik. Purik liyeng memengwili puwiliyegi ngai naktau ono puwekke purik mabura puwili yeik wazewaze wei mizi logo koweige kelemi kanda suwei mizi. Logo yongkambanu kolokngagono pewilirau mabilik. Pilik kumula logo Yisugu puwiliyegi ngago keya watabi kolokngagonoyeng weik waligeleya logo puwiligu kerewiya koyigeya ngago kolokngagonoyeng weik kozak yeiya. ");
INSERT INTO big_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pilik mizageyara yokmek kiliyiweki merekewekke yombu Yisu ngezebokko waligeleyiwili piyegi kanda logo pelik meiya, Pelemeng kabelak ngeragi keya iyeng yeik lemeng keya weik ibengke. ");
INSERT INTO big_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tegi nugu puwili wezayelimo yereng mereke piyengka ngeragi nagiyeng weibene, meiya. ");
INSERT INTO big_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kapura Yisugu pelik yeiya to mela, Inuwa ngezego puwili ngeragi nagiyeng yani, yeiya. Logo yombu Yisugu ngezebokko waligeleyiwiligu piyegi pelik meiya, Talaga weiya logo pilik mizagi? Teni wok andet neyaugi yawe niza piyengki ngane king weiya logo ngeragi pewiligiyeng wei kangki ma yeik, meiya. ");
INSERT INTO big_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tegi Yisugu puwiliyegi pelik nguk yeiya, Ini perek talik talik wara? Yeik were pakeli kuni, yeiya. Togo puwili kuna logo pakela logo yorik piyegi pelik meiya, Perek melenazik keya watabisi waliya neyau. ");
INSERT INTO big_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Togo Yisugu pelik yeiya, Yongkambanu pewili limak narik narikke pulogo yengelik wazono mogosagibekke mogosa wazaye, yeiya logo ");
INSERT INTO big_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","yongkambanuwili yombu melenazik tikinda narikke mogosi keya yombu neyau keya meleyau tikinda narikke mogosi kai kuna. ");
INSERT INTO big_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pulaga Yisugu perek melenazik yaka piyeng wei keya watabisi yaka piyaurau wei miza logo paka ngalege langai pakela wizimowei Anotoyegi ngeragi piyengki wazono meiya logo perekyeng sikila logo ngezebokko waligeleyiwiliyegi yana logo puwiligu yongkambanuwili mabuwili yani miza. Pugu watabisiyaurau mita logo mabuwili yana. ");
INSERT INTO big_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Puwili mabuwili na logo ngekyengko. ");
INSERT INTO big_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pulaga yombu Yisu ngezebokko waligeleyiwili kik meleyau keya pongo inge nazikka neyau piyengke ngeragi perekyeng keya watabisiyengka wale wazono wiyayeng mereng miza. ");
INSERT INTO big_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yombu pulogo perek piyengka nawili sangkelarik tausen melenazik tikinda. ");
INSERT INTO big_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Togo pulaga nguk namizi Yisugu yombu pi ngezebokko waligeleyiwili wang naleige tameneng meibene keleya logo kai kolamiyabekke pangazuwaga yereng Pesaita meiragi puwili were wezayela. Pi yolu keya yongkambanuwiliyegi kambeli yeiya logo wezayela. ");
INSERT INTO big_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pilik miza logo pi panga lewakpekke waberek miziweki kambela. ");
INSERT INTO big_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yokmek kiliya logo weik kusarik Yisu ngezebokko waligeleyi puwili wangleige panga kaibekke libuge ngalengale kunarik keya Yisu ngezebek lewakpekke waberek mizageya wiziyarik. ");
INSERT INTO big_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yisu panga kaibekke pakeliraige pura yombu pi ngezebokko waligeleyiwili wangleige yawe yemane mizageya koyilege. Kebarekpek puwiligu kunagimekke lewa logo yemane uli kopong wanglei yo keya to mizi logo puwili yawe yemane mizi. Togo wangkotazi kang ngizige tek purikke Yisu puwiliyegi kaibekke ngalengale lewagela wiriya. Yisu puwili wezayi kang kunagi nobiyeng ");
INSERT INTO big_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kapura puwiligu pi kaibekke ngalengale yawerelege keriyawekke puwiligu kumularik pi kerewabek nobiyeng ngalizi kek kisa. ");
INSERT INTO big_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Purik puwili mabuwiligu piyegi pakela logo leli uli keya kulili miza. Logo Yisugu puwiliyegi nguk namizi pelik yeiya, Kulili mizi wak. Nogo mena, kozang sara koyi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Togo Yisu puwili kiling wangleige tameneng meiya logo kebarekpek weik yeik sawiya. Pilik miza logo puwiligu lelengkirarik yemane panu keya kumula melarik yemane. ");
INSERT INTO big_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Purik puwiligu yaka ibengke perek melenazikyeng sikila logo kolokngagono sa purikki pakela kele kapura Yisugi kozandagi solo purik puwili iwaka ono, purik kangka puwiligiyeng yeik. ");
INSERT INTO big_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Puwili weik kai kolamiyabekke pangazuwage ngabelak Kenesare meibekke lewagela logo puwili wangleiga welagela logo puwiligu wanglei paka kaingimbekke ngalege wiya logo pilik mizageyarik yongkambanu yereng puragawili Yisu mamiza logo ");
INSERT INTO big_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","puwili yereng mabiyengke nginda kambela logo kemegemewili piyegi iza orowei wiriya. ");
INSERT INTO big_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Togo puwili kemegemewili lalekyengki ngalege yarek wazaya logo wageliwei wiriya logo yereng songono ma yemaneyeng ma yawege ma panga pundaga Yisu wizilege purik puwiligu piyegi kemegemewili wageliwei kang miza keya piyegi pelik kelegele mei miza, Yombanu kemegemewiligu melewangka nugurikki walemek yeik kuming kelemi purik pangka ma yeik, mei miza. Logo pugu, Ei, yei purik yombanu kemegemewiligu melewangka pugurikki walemek kuming kelemi miza logo puwili mabuwili weik yombiyangai wazayi miza. ");
INSERT INTO big_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Wok nakke yombu Yuda kangka yemane Mosegi loyeng mabiyengki waberek panu kiriwei keya kazing puwiligi yelibungang kokawiligi ngago yogongyengkirau kozang panu kiriwei mizi Palisiwili meiwiliyaga nawili kiling Mosegi loyengki waligeleyiwiliyaga nawili paka Yirusalem puraga Yisuyegi kayima logo menalege koya. Puwiligu ngago yogong kiriwei miziyengka nara pelik, meleyeng kaigesa ono purik puwili ngeragi nagi ono. Puwiligu kumularik ngeragi ni puwekke purik kaile miza nelegi purik were meleyeng Yudawiligi ngago yogongyengko kairagi kiriwei kaigesi. Keya puwiligu kumulariktau puwili panga pundaga yowekke puwili ngezewili kaigesi, purik Yudawili watabi Yuda onowiligu kebangkela piyeng kebangkeli purik kaile, legi puwiligu Yuda onowiligi kailera puwiliyaga kaigesa meli logo ngeragi kaigesayeng ni mizi. Keya nayendau kakyeng keya pelengyeng keya tingyeng keya lalektarau kaigesi mizi. ");
INSERT INTO big_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Togo yombu Yisuyegi kayimawiligu yombu ngezebokko waligeleyi nawili Yudawiligi ngago yogong meleyeng waberek kaigesa logo ngeragi nimekki kiriwei mizi onorikki pakela, logo puwiligu Yisuyegi pelik nguk meiya, Yombanu nugu waligeleyiwili tenigi yelibungang kokawiligi ngago yogong piyengke mizi ono yeik mele kaileyengko ngeragiyeng weiya ni pura nangki, meiya. ");
INSERT INTO big_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Logo Yisugu puwiliyegi pelik yeiya to mela, Ini yombu kiligang neyau lewawili, koka walaka Isaya yombu Anotoyaga ngagora weiya logo kozak kaiyabokko iniyegi langai Anotogi Kapiya Walektikke pelik lende miza, Anotogo pelik kai, Yombanu pewiligi kiliyengko yeik nogora yongolok mei kapura wilek kangyeng neyegirau kumula ono. ");
INSERT INTO big_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ngago yogong ngezewiligu keremiza piyeng Anotogi wameiktagi ngizi kumuliweki piyeng kisageya koyimowei waligeleyi kopong puwili yeik nogora yeik ulak yongolok mei, kai. ");
INSERT INTO big_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yisugu mawinda pelik yeiya, Inirau mabilik. Ini Anotogi ngagorago miziweki kai piyengki kezanga mani keya kazing yombanuwiligu waligeleyiyengki kele waberek panu mizi. ");
INSERT INTO big_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ini kazing Anotogi ngagorago miziweki kai piyeng keta wezamelagi pumokki iwaka panu logo ngago yogong inigi yelibungang kokawiligu waligeleyayeng kozang kaloko wirara koyagirikki kele. ");
INSERT INTO big_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Keya Anotogi ngagorago miziweki kai piyengka nara pelik, Mosego pelik lende miza, Inigi panu keya mangowiliyegi panga yungke mizizo. Nak pigi panu keya mangoyauyegi kaile kai purik mabura nawiligu pok ula logo ibeng wazamizo, kai. ");
INSERT INTO big_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kapura inugu ngago pura wezamela logo puragi tundikke pelik kisi, Nak pigi panu keya mangoyauyegi watabi nayeng yanagi purik pugu piyauyegi pelik yei, Watabi nogo yaliyegi sawelagi nobiyeng yali yaniweki miza peyeng nogo Anoto maniweki mizi, yei purik pangka, kisi. ");
INSERT INTO big_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Logo kazing pilikmokko pi pigi panu keya mangoyauyegi sawelagimok waliyi. ");
INSERT INTO big_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Togo inigi kazing pilik yongkambanuwiliyegi waligeleyi piyengko ini Anotogi ngagora ngela meli. Keya ngago yogong kolokngagono pilik nayengkirau ini kiriwei mizi, Yisugu pilik yeiya. ");
INSERT INTO big_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Togo waleleige Yisugu yongkambanuwili piyegi ngago yeiya logo puwiliyegi pelik yeiya, Ini mabuwili neyegi kerewiya logo ngago pera weizo. ");
INSERT INTO big_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ini watabi Yuda onowiligu kebangkela piyeng nagirikki kazi kapura watabi yombanubekyegi yenge yungke kang piyengko mizagewiyege yombanubek kailegi ono, segeya watabi yombanubekyaga welagela kang piyengko mizagewiyege yombanubek kailegi. ");
INSERT INTO big_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ini kerangang kerewiyagiyeng kilingwili mabura kerewiyizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pulaga Yisu yombanu wawere ula pumok wazaya logo imakke yeke ige lawekke yombu Yisu ngezebokko waligeleyiwiligu ngago saweliwei pugu yaka ngolukku kaiya puragi talik kai yagenda miza legi nguk meiya, ");
INSERT INTO big_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","legi Yisugu puwiliyegi pelik yeiya, Inuwarau Palisiwili kelik kangkayeng waliya ma talik? Yombanu nakki kaile kumulayengko mizagewiyege pi kaile mizi, keya yombanu nakko ngeragi na piyengko mizagewiyege pi kaile mizi ono. ");
INSERT INTO big_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yombanu nak ngeragi na logo ngeragi piyeng kangkabekke kiliya kang ono, korage yungke kiliya kang logo ya imakke yangela meliyeng, yeiya. Pugu pilik kai purik ngeragiyeng mabiyeng wazono nagiyendikki kai yagenda. ");
INSERT INTO big_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Keya Yisugu ngago yeke langakta pelik yeiya, Watabi yenge yombanubekyaga lewagela wali piyengko mizagewiyege yombanubek kaile mizi. ");
INSERT INTO big_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Purik watabi yenge yombanubekki wilek kambekka lewagela wali piyeng peyeng, kaile kumuliyeng, ma kazing yongkambu weiya ono puwili namele ma nak kiling iwek koliyeng, ma kazing yombanu nakki watabiyeng purik ngowei miziyeng, ma kazing yombanu ula logo ibeng miziyeng, ma kazing yongkambu weiya puwili namelegi kerekpu onobek ma nakki yongokpu onomele kiling iwek koliyeng, ");
INSERT INTO big_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ma kazing yombanu nakki watabiyeng ma yongok pugumele weiweki ngora kelimok, ma kazing kaile nalangai nalangai miziyeng, ma kazing ngaigu kisiyeng, ma kazing inigi tepekke pangka ono mizi ma kerewiyi ma kozak kelagi langai ono piyeng, ma kazing nazuwagawiligi watabiyengki sisik kameneng mizimek, ma kazing Anotoyegi ma nazuwagawiliyegi langai kaile kisimek, ma kazing ngezewiligu ngezewiliyegi lewegewili mizimek, ma kazing lelewe mizagela kangkabek kumula logo mizi onomek. ");
INSERT INTO big_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kaile pilik piyeng mabiyeng yombanuwiliyegi yungke kopong yombanuwiliyaga lewagela wali logo piyengko mizagewiyege yombanuwili kaile, yeiya. ");
INSERT INTO big_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pulaga Yisu yereng pura wiya logo panga yereng Taya keya Sairong mei ngabelak Yuda onowili yolubokko ngabelak libu kambela. Kanda pi i namakke yeke ige la logo pulogo nakko piyegi iwakagirikki pi kiyebuk kapura pilik mizagi langai ono. ");
INSERT INTO big_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yongok namele pigi yangomele kerewa nak yenge yaga kiliya logo kebangkela logo pugu Yisu pulogo yolurikki kerewiya logo piyegi nguk namizi kayima logo pigi ingewerege ingeyau laliya. ");
INSERT INTO big_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yongokmolo Yudamele ono, pi Kirik ngago yeikta kaimele keya pi ngabelak Siriya meibekkamele logo ngai Pinisiya meimekkamele kapura pulogo Taya keya Sairong yolumele. Pugu kanda Yisuyegi kerewa yenge pigi yangomelegi yungke yolubek welagela wezamelibene nguk meiya. ");
INSERT INTO big_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kapura yongokmolo Yuda onomele keya Yudawiligu Yuda onowili keriwili mei purik Yisugu iwaka legi pugu yongokmeleyegi pelik meiya, Teni koloyakamandikwili were ngeragi yaniweki, purik teni koloyakamandik songonowiligi ngeragiyeng weiya logo keriwiliyegi yaniwekirik purik pangka ono kani, meiya. ");
INSERT INTO big_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Logo yongokmologo pelik meiya to mela, Yemizibek, ni wameik kai, kapura keriwili ngeragi wale koloyakamandik songonowiliyaga pongo ngabelakke wali piyeng weiya logo niwiligu, meiya. ");
INSERT INTO big_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pi pilik kai legi Yisugu yongokmeleyegi pelik meiya, Ngago nugu yaka kaiya purago nigi neyegi ngizi panu kumuli puragi waligeleni legi yeke ige yongobele, kerewabek nigi yangomeleyaga yaka welagela mena, meiya. ");
INSERT INTO big_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Togo pi yeke ige kang yongobela logo pigi yangomele pulogo kerewabek piyaga welagela kambela logo panga yolumektikke yeik iwek wizilege pakela. ");
INSERT INTO big_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pulaga Yisu Taya mei pulumeng wiya logo panga Sairong mei lemeng neing kambela logo panga lemeng wiya logo yeke Tekapoli mei lemeng neirik pongo kai Kalili meibekke kambela. ");
INSERT INTO big_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pi kanda pulogo pura yombanu nawili piyegi yombu kerangangyau waliya logo talik ngago kaiyagi miza nak miza orowei wiriya logo Yisuyegi pelik nguk meiya, Mele nuguzikku piyegi walamiya logo pi yombiyangai wazamiweki, meiya. ");
INSERT INTO big_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Togo pi ngezebek keke Yisugu miza orowei koweige kuna logo melegong puguyau yombanubekki kerangangyauge wiya keya sibilak ngizi keya mele puguzik yombanubekki longokpekke walamiya. ");
INSERT INTO big_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pilik miza logo Yisu paka ngalege pakela purik pi yalek legi pugu, Eye, meiya logo yombanubekyegi ngago yeik puwiligirage pelik meiya, Epata, pura pelik, Tiyimo, mei yagenda. ");
INSERT INTO big_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mabuwekke yombanubekki kerangangyau weik kerewiya keya longok waliyabek wilora logo pi weik watabi nayeng waberek kai. ");
INSERT INTO big_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pulaga yombanubek Yisu kiling yongkambanuwiliyegi yo logo Yisugu puwiliyegi kozang ngago yeiya nawiliyegi kozak yeiya nelegi keya pugu puwiliyegi mawiyarekka kozang yei, yei, miza kapura puwili pura mawiyarekka kozak kisi, kisi, miza. ");
INSERT INTO big_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Keya yongkambanu puragi keriya keya kerewiya puwili mabuwili yemane panu lelengkira logo puwiligu pelik kisa, Watabi pugu miziyeng yombiyangai panu mizi. Pugu kerangang waliyawilirau ngago kerewiyi keya kili waliyawilirau ngago kisibene keleya, kisa. Togo puwiligu yeik pugura yongolok meiya. ");
INSERT INTO big_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Piyeng miza logo wok nakke yongkambanu kolokngagono nawili ngereke Yisuyegi wawere ula. Puwili watabi nagiyeng weik yeik legi Yisugu pugu waligeleyiwili piyegi mereke wiriyiweki ngago yeiya logo puwili piyegi kanda logo pugu pelik yeiya, ");
INSERT INTO big_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ne yongkambanu pewiliyegi yalek keli. Puwili weik ne kiling wok neyauganak koya kopong puwiligi ngeragi nagiyeng weik yeik. ");
INSERT INTO big_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tamizeige ne puwili yereng puwiligiyengke wezayeli purik nawili koweiga lewawili kopong puwili yagasimokko ulu wali kambeli nangai. ");
INSERT INTO big_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Logo yombu ngezebokko waligeleyiwiligu piyegi pelik meiya to mela, Kabelak kurung yeik panu pewekke takko ngeragi nayeng talaga weiya logo yongkambanu pewili pangka yanagi. ");
INSERT INTO big_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tegi Yisugu pelik nguk yeiya, Inuwago perek talik talik wara, yeiya logo puwiligu pelik meiya to mela, Melenazik keya nazikka neyau. ");
INSERT INTO big_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pulaga Yisugu yongkambanuwiliyegi ngabelakke mogosibene yeiya logo puwili ngabelakke mogosa. Logo pugu perek melenazik keya nazikka neyauyeng weiya logo piyeng Anotoyegi wazono meiya logo sikila logo pugu ngezebokko waligeleyiwili yana logo puwiligu yongkambanuwili yana. ");
INSERT INTO big_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Puwiligu mabilik watabisi songono keremungke ono waliya nawiliyegirau mabilik miza. Logo Yisugu watabisi puwiliyegirau Anotoyegi wazono meiya logo ngezebokko waligeleyiwiliyegi yana logo yongkambanuwili yaniweki. ");
INSERT INTO big_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Puwiligu pilik miza logo yongkambanuwili mabuwili na logo weik ngekyengko. Yongkambanuwili sangkelarik tausen mangobektau ono tikinda. Pulaga yombu Yisu ngezebokko waligeleyiwili kik melenazik keya nazikka neyauyengke ngeragi wale wazono wiya piyengka mereng miza. ");
INSERT INTO big_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Togo weik Yisugu yongkambanuwili kang wezayela logo nguk namizi yombu ngezebokko waligeleyiwili kiling pi panga wangleige tameneng meiya logo panga ngabelak Talamanutu meibekke kambela. ");
INSERT INTO big_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kanda pangalege pura yombanu Palisi mei nawili kanda logo Yisu kiling ngagozakka miza logo pi yang kelemiweki. Puwiligu piyegi pelik nguk meiya, Teniyegi Anotogo keke mizi nara waligeleye logo ni Anotoyaga kayimabek purik teni iwakaweki, meiya. ");
INSERT INTO big_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pilik kisi legi Yisu wilek kang pugubek kuneng miza logo pelik yeiya, Oyo, ini yongkambanu mabek peragewiligu nogo Anotogo keke mizi nara miziweki nguk neira nangki? Kerewiyi, nogorau Anotogo keke mizi wik naragi ini pakelibene waligeleyagi ono. ");
INSERT INTO big_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yisugu pilik yeiya logo puwili wezaya logo ngezebokko waligeleyiwili kiling ngereke wangleige tameneng meiya logo kai kolamiyabek wala uwei lalu pangazuwagaweki kuna. ");
INSERT INTO big_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yombanu Yisu ngezebokko waligeleyi puwili perek wamenaksik wangleige purik puwili perek wik nayendau oroweigirikki keremareke miza. ");
INSERT INTO big_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Puwili wangleigi ngalengale kunimowei Yisugu puwiliyegi kazing Palisiwili meiwiligu kaile miziyengki langai waligeleyiweki miza legi pugu pelik yeiya, Palisiwili meiwiligi ngeragi Yis meirik keya Ngai Elodogi ngeragi Yis meirikki yaweragi inuwa ngezeyegi kani yomono, yeiya. ");
INSERT INTO big_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Puwili ngago pugu kai puragi iwaka ono kopong puwili ngezewili ngagozakka pelik keli yongomo kela, Teni perekyengki yeik kopong pi yisyengki kai yagenda ma talik, kela. ");
INSERT INTO big_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kapura Yisu puwiligu kozak keli piyengki iwaka logo pi puwiliyegi pelik yeiya, Perekyengki yeiktikki wiyeke inuwa kozak kelira nangki? Nogo ngeragi inugu nagi piyeng Anotogo keke mizi purago yanagi purik iwaka ono ma talik? Ma inuwa ngoluk kangkayendau ono? ");
INSERT INTO big_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Inuwa kozang nogoragi iwaka ma yeik, keya inuwa ngago nogoragi iwaka ma yeik, keya Anotogo keke mizi nogo miza piyengki inuwa keremareke miza ma talik? ");
INSERT INTO big_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nogo perek melenazik piyengka yombu sangkelarik tausen melenazik tikindawiligi sikila puwekke inuwago wale wiyayeng kik talik talikke mereng miza, yeiya. Puwiligu pelik meiya to mela, Kik meleyau keya pongo ingenazikka neyauyengke mereng miza, meiya. ");
INSERT INTO big_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Logo Yisugu ngereke pelik nguk yeiya, Keya nogo perek melenazik keya nazikka neyau piyengka yombu sangkelarik tausen mangobektau ono tikinda puwiligi sikila puwekke inuwago wale wiyayeng kik talik talikke mereng miza wiya, yeiya. Puwiligu pelik meiya to mela, Teni kik melenazik keya nazikka neyauyengke mereng miza, meiya. ");
INSERT INTO big_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Togo pugu puwiliyegi pelik yeiya, Inuwa yawe Anotogo keke miza piyau pakela kapura nogo inuwayegirau mabilik miza yowiyagi purik pangka purik inuwa ngoluk iwaka ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Puwili wangleige ngalengale kai kang panga yereng Pesaita meirage lewagela. Pulogo pura yongkambanu nawili Yisuyegi yombu wireyau kusa nak miza orowei wiriya logo puwiligu Yisuyegi pelik kelegele meiya, Nugu yombanubekyegi mele nuguzik walamiye logo pi pakelibene, meiya. ");
INSERT INTO big_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tegi Yisugu yombanu wireyau kusabek melezikka weiya logo yerendaga welagela miza orowei kuna. Logo pulogo Yisugu wire puguyauge sibilak ngiza mana. Pilik miza logo Yisugu mele puguyau yombanubekki ngalege walamiya logo piyegi pelik nguk meiya, Nugurau watabi nayeng pakela ma yeik, meiya. ");
INSERT INTO big_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Logo yombanubek pakela logo pelik meiya, Nogo yombanu nawili pakeli kapura puwili yengeleiyeng kelik wei mizi, meiya. ");
INSERT INTO big_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pulaga Yisugu mazenda mele puguyau yombanubekki wireyauge walamiya logo yombanubek weik ngayang panu pakelageyarik wireyau weik yombiyangai si lewa logo pi weik watabi mabiyeng waberek panu pakela. ");
INSERT INTO big_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Togo Yisugu piyegi pelik meiya, Ni pongo yerendage libulibu kiliya kang nagani, i ni makngezegimakki ngizi kunimo, meiya. ");
INSERT INTO big_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pulaga Yisu yombu pi ngezebokko waligeleyiwili kiling ngabelak Sisariya Pilipai meibekki yerengyeng neing kambela. Logo pongo kazingke kunimowei Yisu ngezebokko waligeleyiwiliyegi pelik nguk yeiya, Yongkambanuwiligu neyegi langai kozak kisirik puwiligu ne tak kisi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Logo yombu ngezebokko waligeleyiwiligu pelik meiya to mela, Yongkambanu nawiligu kisirik ni Yowan kaimelabek ibendaga yangalekta yo kisi, kapura nawiligu kisirik ni Ilaya Anotogo paka ngalege korikwek kiling wik miza orowei kambelabok ngereke yo kisi, keya nawiligu kisirik ni koka walaka yombu Anotoyaga ngagora weiya logo kozak kisawiliyaga nak ngereke wik yo kayima kisi, meiya. ");
INSERT INTO big_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Togo Yisugu puwiliyegi pelik yeiya, Nawiligu pilik kumuli kapura inuwago sawiyarik ne tak, yeiya. Tegi Pitago pelik meiya to mela, Ni Kilisibek Mesiya Anotogo yawe pigi teni Yudawili yaliya wazayagi pura miziweki sawiyabek, meiya. ");
INSERT INTO big_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tegi Yisugu puwiliyegi ngago piyegi langai puragi yongkambanu nawiliyegirau kozak yeiya nelegi kozang yeiya. ");
INSERT INTO big_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Togo Yisugu yombanu ngezebokko waligeleyiwiliyegi pelik yeiya, Kalike purik ne yombanu paka ngalega kayimabek nganganda yemane panu wagelagi kani logo Yudawiligi yemanewili keya yombu Anotoyegi kolak miziwiligi ngaiwili keya yombu Mosegi loyengki waligeleyiwiligu neyegi kezanga nanagi logo ne nelagi logo ne ibeng wizigeya kawiktikke waliyagi, kapura wok neyau wiziya logo wok kalikebekke ngereke wik yangalektagi. ");
INSERT INTO big_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yisugu pura kimeike yeiya kapura Pita kiyebuk, legi pugu Yisu songono nangezi miza orowei kuna logo piyegi pelik ngalik meiya, Ni pilik kai wak, purik ngizi lewagelagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kapura Yisu kowita to mela logo yombu ngezebokko waligeleyiwiliyegi pakela logo Pitayegi pelik ngalik meiya, Nugu Sadangki kumulira kaiyarikki wiyeke mena neyaga kazi koweige kune, purik nugu kumulara kazing Anotogo kumulimek kelik ono, nugu kumulara kazing yongkambanuwiligu kumulimek kelik kumula mena kune, meiya. ");
INSERT INTO big_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pulaga Yisugu yongkambanu kolokngagonowiliyegi yombu pi ngezebokko waligeleyiwiliyegi, mereke wiriyibene yeiya, logo puwili mabuwiliyegi pelik yeiya, Tamizeige ni yombanu nak neyegi sawelagi keli mabura ni keli korik ni makngezegiwekkiragi kezanga mane keya ngago nogoragi kerewiye keya negi wiyeke ibengkirikki kazi ono wizimowei ne kiling kazing nogo kangmokko kune. ");
INSERT INTO big_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Purik yombanu ngezebekki kelira keya ngezebekki wik yolugira kozang kebangkelibok pi Anotogi wiregerik ibeng logo paka ngalege wik wizagomagi ono, kapura yombanu neyegi ngizi panu kumula logo wilek kang pugubek ne keya ngago wazono nogoragi tiya manibok pi kemenak ibengki ono, paka ngalege wik wizagomagi. ");
INSERT INTO big_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Keya tamizeige yombanu nak yawe king keya watabiyeng weiyagi naragi wilek kang tiya mana logo pi watabi ngabelakpekkiyeng mabiyengko kola logo pi ibeng purik pi pongo Anoto yolu onolege kaile wizagomagi logo puwekke watabi pigi piyengko piyegi sawelagi ma yeik? Yeikki kani. Piyengko piyegi sawelagi ono. ");
INSERT INTO big_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ma pi watabi nayengki ngane kazing Anotogimek weiyagi ono. ");
INSERT INTO big_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tamizeige yombanu nak neyegi kendek mizi ma yongkambanu kaile miziwili keya yongkambanu ne wezaniya logo anoto nawiliyegi kangwiliyegi ngago nogora yanagirikki kendek mizi purik mabura ne yombanu paka ngalega kayimabek angela walekwili kiling ngaiwak Pebagirikke ngereke yo puwekke purik ne yombanu paka ngalega kayimabektau piyegi kazing mabilikmekke kendek mizagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Keya Yisugu ngago yeke langak nara puwiliyegi pelik yeiya, Nogo inuwayegi wameik panu yei, Yongkambanu pelege yolu pewiliyaga nawili ngoluk mabilik wik koyigeya Anotogi kozandago pigi ngaimekki wilek kangyengki ngairikki pakelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wok melenazik keya nazikka nak miza logo Yisugu Pita keya Jems keya Yowan iza logo pi kiling paka lewak ngalege panu nakka kambela. Kanda pakalege puwili pakeliraige Yisugi korikwek kowita logo nalik si lewa ");
INSERT INTO big_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","keya melewangka keya pugu wakiya piyendau wilangka ngaiwaktikku kola legi. Yombanu ngabelakka nakkorau melewangkarik kaigesa logo Yisugi purik kelik wilangka panugi langai ono. ");
INSERT INTO big_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Logo puwiligu yombu yemane koka walaka koyimayau Ilaya keya Mose paka ngalega lewagela logo kanda Yisu kiling ngagozakka mizirikki pakela. ");
INSERT INTO big_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Pumorok pakela logo Pita kiling pigi kewengkeyau lebukka ngane mizagela Pitago watabi yaka pakela piyeng mabiyengki iwaka panu ono kopong, pugu Yisuyegi waze yeik pelik meiya, Kiriwagabek, teni pelege yolu purik pangka panu kani, tonugu i menang yolugi neyauganamak ngiziweki, nigi namak keya Mosegi namak keya Ilayagi namak, meiya. ");
INSERT INTO big_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Togo kozainumbek kanda yokmek waliya logo kili narago paka kozainumbekka pelik kai, Pok negi Marek nogo keli panubek kani. Pugu kai piyengki kerewiya logo kiriwei mizizo, kai. ");
INSERT INTO big_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Togo nguk namizi Pita kiling pigi kewengkeyau pakela to melawekkerik naktau pi kiling ono, yeik, Yisu ngezebek keke wizilege. ");
INSERT INTO big_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pulaga Yisu keya pugu waligeleyi neyauganak puwili lewakpekka yerageyamowei pugu puwiliyegi kozang pelik yeiya, Inuwago yaka pakela piyengki inuwago nakyegi kozak mei nagani, wiziya kalike ne yombanu paka ngalega kayimabek ibeng sa logo yangalekta puwekke inuwago yongkambanuwiliyegi kozak yei nangine, yeiya. ");
INSERT INTO big_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pugu pilik kai pura puwiligu kebangkela wara koya, kapura ngago pugu pelik kai pura, Ne ibeng sa logo yangalekta kai puragi puwili kumula mela logo nakko nakyegi nguk meiya. ");
INSERT INTO big_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Togo puwiligu Yisuyegi pelik nguk meiya, Mosegi loyengki waligeleyiwiligu yombanu Anotogo teni yaliya wazayiweki sawiyabek lewagine yombanu Ilaya kelik nak were lewagi kani, kisara nangki, meiya. ");
INSERT INTO big_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Tegi Yisugu puwiliyegi pelik yeiya to mela, Ei, Kapiya Walektikke yungke pelik kai, Yombanu Ilaya kelik nak lewagi kani logo kazing Anotogo sawiyabokki lewagimek pangka pangka miziweki, kai logo nogo inuwayegi pera kozak yei, pok ulogo kayima logo puwiligu keli kaile ngezewiligiragi kiriwei miza logo puwiligu pi ula logo ibeng. Pilik miza pura Kapiya Walektikku pobilik kaiya puragi kiriwei. Keya kazing mabilikmekke Kapiya Walektikke yungke pelik kai, Ne yombanu paka ngalega kayimabek ngangandik yemane panu wagelagi logo yongkambanu neyegi kezanga nanagi, kai. Togo pura pilik lewagela wali penangai, yeiya. ");
INSERT INTO big_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Togo puwili yombanu ngezebokko waligeleyi nawiliyegi wiriyawekkerik puwiligu yongkambanu kolokngagonowili puwili yawereng keleyageya koyilege pakela. Keya Mosegi loyengki waligeleyi nawiligu yombanu ngezebokko waligeleyiwili kiling ngago si kela yongomo mizageya. ");
INSERT INTO big_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kapura yongkambanuwili mabuwili Yisuyegi pakela logo wilik miza logo loyengki waligeleyiwili nguk namizi wazaya logo nginda kanda Yisuyegi koli kelemiya. ");
INSERT INTO big_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Togo Yisugu yombanu ngezebokko waligeleyiwiliyegi pelik nguk yeiya, Inuwa Mosegi loyengki waligeleyiwili kiling nangaiyengki kozak keli, yeiya. ");
INSERT INTO big_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Logo yongkambanu kolokngagonowiliyaga nakko pelik meiya to mela, Kiriwagabek, ne niyegi negi marekpek miza orowei lewa, purik kerewa nak pigi yungke kiliya logo kerewabokko mandikpekki kiliganda waliya logo mandikpek ngago kai ono. ");
INSERT INTO big_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Keya kerewabokko pi kozang kebangkela yoluwekkerik kerewabokko pi pongo ngabelakpekke wezameli logo sibilakpek kiliraga lewa keya pi kilira ni keya korik puguwek kozang sameli mizi. Nogo yombu nugu waligeleyiwiliyegi nguk yeiya, puwiligu kerewabek welagela wezamelagi nobiyeng kapura puwili pangka ono, meiya. ");
INSERT INTO big_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Pilik kai legi Yisugu pulogo koyawiliyegi pelik yeiya to mela, Oyo, ini yongkambanu mabek pewekkewili ne mabiyeng pangka mizagi langaibek purikki ini ngizi kumuli onowili kani, legi ne iniyegi kiyebuk sende. Tek taliktikke ne ini kiling yoluweki keya kuneng inuguyeng wageliweki? Pilik yeiya logo mandikpekki mangobekyegi pelik meiya, Nigi marekpek neyegi pelege miza orowei koli, meiya. ");
INSERT INTO big_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Togo puwiligu mandikpek Yisuyegi miza orowei kuna kapura kerewabokko Yisuyegi keriyawekke pugu mandikpek yomizora wezamelibene kelemiya logo pongo ngabelakpekke wezamela logo piyeng meli keya sibilakpek kiliraga lewa. ");
INSERT INTO big_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pilik miza logo Yisugu mandikpekki mangobekyegi pelik meiya, Talikwekka pi pelik mizi, meiya. Tegi pugu pelik meiya to mela, Pi songonowekka. ");
INSERT INTO big_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Keya kang kolokngagono kerewabokko mandikpek yezizikke waliya wazami keya kailingke kaiyaga niweki wezameli miza. Kapura ni pangka mabura ni teyegi yalek miza logo teyegi sawele, meiya. ");
INSERT INTO big_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tegi Yisugu mandikpekki mangobekyegi pelik meiya, Nugu ni pangka mabura kaira nangki? Nogo mizi purik pangka. Yombanu ngizi kumulira kiling koyimowei nogo pangka mizagi miza puwiligi mizagi keli piyeng nogo pangka mizagi. ");
INSERT INTO big_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Logo mandikpekki mangobokko nguk namizi ingi ngaungaumek kiling pelik kai, Nogo niyegi ngizi kumuli kapura negi ngizi kumuli pura pangka ono legi nugu mazenda neyegi ne niyegi ngizi panu kumulibene sawele, meiya. ");
INSERT INTO big_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pilik miza logo Yisugu yongkambanu kolokngagono nawilirau kilitiyi lewarikki pakela logo nguk namizi Yisugu kerewabekyegi pelik ngalik meiya, Kerewabek yombanu kili waliyi keya kerangang waliyi mizabek nogo niyegi nei, Mandikpekyaga welagela kule keya piyegi ngereke kiliya yongo nagani, meiya. ");
INSERT INTO big_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Togo kerewabek ngalizi kek kaiya logo mandikpek pongo ngabelakpekke yomizora wezamela logo pi wazami kang. Logo mandikpek ibembek kelik yolu legi yongkambanu kolokngagono nawiligu, Pi ibeng, kisa. ");
INSERT INTO big_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kapura Yisugu mele mandikpekkizikka weiya logo yangalekta luwe wazamiya logo pi luweza. ");
INSERT INTO big_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pulaga Yisu panga ige kuna logo yombanu pi ngezebokko waligeleyiwili kiling kekewekke puwiligu Yisuyegi pelik nguk meiya, Tonuwago kerewabek mandikpekyaga wezamelagi langai ono purik nangki, meiya. ");
INSERT INTO big_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tegi Yisugu puwiliyegi pelik yeiya to mela, Tamizeige inuwa Anotoyegi waberek mizageya koyimowei kerewabek wezameliweki yamiza kesak kerewabek mandikpekyaga welagela logo pi wezami kuni kak. Waberek Anotoyegi miza pumok ngezemokko watabi kaile pilik piyeng wezamelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Puwili pulumeng wiya logo ngabelak Kalili meibek neing kuna. Yisu yombu pi ngezebokko waligeleyiwili waligeleyageya kopong pi pulogo purik nakko iwaka nelegi pi kiyebuk. Yisugu puwiliyegi pelik yeiya, Ne yombanu paka ngalega kayimabek yombu ne nelagiwiligi meleyengke niza yaniweki mereke kani. Ne ibengki kapura wok neyau wiziya logo wok kalikebekke ngereke wik yangalektagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kapura ngago purago pilik kai purikki puwili iwaka ono. Togo puwili ngago puragi solorik talik miza purikki meiyagi keli kapura puwili kazi. ");
INSERT INTO big_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Puwili kang kunimowei yombu Yisu ngezebokko waligeleyiwili ngezewiligi tepekke tak yeikta lewege miza legi kozak keli yongomo mizi, keya ngalik keli kuna. Logo puwili weik yereng Kapaneyam meiraga lewagela logo puwili i namakke yabela. Puwili yabela logo Yisugu yombu pi ngezebokko waligeleyiwiliyegi pelik nguk yeiya, Inuwago yaka pongo kazingmekke kozak keli yongomo mizi piyeng nangaiyengki, yeiya. Kapura puwili kendek kopong puwiligu piyegi ngago nara meiya to mela ono. ");
INSERT INTO big_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tegi Yisu mogosa logo puwiliyegi mereke pelege koli yeiya logo pelik yeiya, Yombanu nak mabuwiliyegi orozarikke wiziyagi keli purik mabura pi yongkambanu mabuwiliyegi kulengke yolu keya mabuwiliyegi yawe mizibekweki, yeiya. ");
INSERT INTO big_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Togo Yisu mandik songono yeikta yemane ono nak miza logo puwiligi wirege luwe wazamiya logo pi mele puguyau mandikpek yawereng kelemiya logo kebangkela logo puwiliyegi pelik yeiya, ");
INSERT INTO big_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Mandikpekyegi pakeli. Yombanu nakko neyegi kelirikki weraga mandik songono pilik pokyegi sawelibok mabura, pi neyegirau saweli yagenda. Keya neyegi sawelibok mabilik Anoto ne ngabelakpekke wezanelabokyegi saweli yagenda, yeiya. ");
INSERT INTO big_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pulaga Yowangu Yisuyegi pelik meiya, Kiriwagabek, yombu nak yeik nugurage kerewawili welagela wezayelirikki tonugu pakela. Pi teni kiling yongomo mizi onobek legi tonugu pilik mizi nagani, meiya. ");
INSERT INTO big_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kapura Yisugu puwiliyegi pelik yeiya, Piyegi pilik mizi wak, mei nagani, purik yombanu nak Anotogo keke miziyeng yeik nogorage mizibok, pi neyegi ngago kaileyeng nguk namizi kaiyagi ono. ");
INSERT INTO big_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Purik yombanu yawe tonuguragi ngai mizi onobok teniyegi saweli yagenda kani. ");
INSERT INTO big_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Togo inuwa neyegi yawe mizi puragi wiyeke yombu nakko inuwa kai wik nibene yani mabura pugu wazono miza puragi wiyeke Anotogo pi kanga managiyeng managi purik wameik panu. ");
INSERT INTO big_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kapura yombanu neyegi ngizi panu kumuli logo ngoluk kazing kumbekki lewengke songono puwiliyaga nak kaile miziweki ulumiyabokyegi Anotogo ngangang yemane panura managi. Logo pilikpoktau ono kesak pangka, purik kazing yombanu nakko nak kaile miziweki ulumowei kangmok korowali panumokko. Logo inugu nak kaile mizibene ulumowei kuna nagani waberek panu. ");
INSERT INTO big_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tamizeige mele nuguzikku ni ulumiya logo ni kaile mizibene keleniyageya purik mabura kazing kaileyengki pumok ngela melibene mele puzik ngela melagizikku, purik ni melenazik kiling paka ngalege wik wizagomagirage kang purik kaile kapura tamizeige ni mele mabiyau kiling kaile mizageya logo yereng yezi yemane kusagi onozik ngoriraga kangki purik kaile panu. ");
INSERT INTO big_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Yezi puzikke pulogo, ngik korik sokyeng niwili ibengki ono keya yezi puzik kusagi ono. ");
INSERT INTO big_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tamizeige inge nuguzikku ni ulumiya logo ni kaile mizibene keleniyageya purik mabura kazing kaileyengki pumok ngela melibene inge puzik ngela melagizikku, purik ni ingenazik kiling paka ngalege wik wizagomagirage kang purik kaile kapura tamizeige ni inge mabiyau kiling kaile mizageya logo yereng yezi yemane kusagi onozik ngoriraga kangki purik kaile panu. ");
INSERT INTO big_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Yezi puzikke pulogo, ngik korik sokyeng niwili ibengki ono keya yezi puzik kusagi ono. ");
INSERT INTO big_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Keya tamizeige wire nuguyauga nakko ni ulumiya logo ni kaile mizibene keleniyageya purik mabura kazing kaileyengki pumok ngela melibene wirebok tiya melagibokko, purik ni wire nak kiling yereng Anotogo ngai purage kiliya purik kaile kapura tamizeige Anotogo ni wire mabiyau kiling kaile mizageyarikki wiyeke yereng yezizik kusagi onozik ngoriraga wezanelagi purik kaile panu. ");
INSERT INTO big_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yezi puzikke pulogo, ngik korik sokyeng niwili ibengki ono keya yezi puzik kusagi ono. Togo inge keya mele keya wire inigi pilik piyengko ini kaile mizibene keleyageya koya nagani, waberek panu. ");
INSERT INTO big_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wizandikki yawera keya yezizikki yawera wazono panu. Logo yezizikku wini keya lang keya pulangaiyengki wale kolokolok miza pilik piyeng pangka kelemi pilik kunengyengko kazing tonugu yolumok waberek kelemi. ");
INSERT INTO big_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Wizandik wazono panurikku logo ngeragiyeng kolok kelibene wiyirik kapura tamizeige pigi kolok keli pura yeik puwekkerik kazing ngereke kolok kelibene keremizagi namektau ono, yawe pugura weik yeik. Logo wizandikku ngeragiyeng kolok kelibene kelemi legi nogo inugu yolu pura wizandikku ngeragiyeng kolok kelibene kelemi pilik kolok kelibene kelemiweki mena ne wilek kang inugu yengke wiriyi pei, logo inigi tepekke ngezege sara wizeibene logo inigi tepekke tak yeikta lewege miza purikki kumula melagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yisu kiling yombu ngezebokko waligeleyiwili yeke iga welagela logo yereng Kapaneyam pura wiya logo kai Yolodang meilingka pangazuwage ngabelak Yudaya meibekke kuna. Puwili kanda yongkambanu kolokngagono Yisuyegi wawere uli keya kaiyageya logo pugu were mizilik puwili waligeleya. ");
INSERT INTO big_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Yombanu Palisi mei nawili Yisuyegi wiriya logo puwili pi yang kelemiweki keli logo puwiligu pelik nguk meiya, Ma lo tonugurago kairik nakko yongok pugumele piyaugi weiya pura ngela logo pigi yongokpumele wezameli purik pangka kai ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tegi Yisugu puwiliyegi pelik nguk yeiya to mela, Lo Mosego lende miza purago ini miziweki kozak kairik talik kai, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Togo puwiligu pelik kisa, Mosego pelik purik pangka kai, Yombu nak pigi yongokpumele wezameli mabura pugu pigi yongokpumeleyegi kapiya narik lende miza maniweki logo kapiyarikku yongokmeleyegi, Ni weik yongok nogomele ono, kai logo pugu pi wezameli purik pangka, kai, kisa. ");
INSERT INTO big_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kapura Yisugu pelik yeiya, Kangka inuwagiyeng kingyeng kelik kopong Mosego inuwayegi pelik lende miza, ");
INSERT INTO big_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","kapura Mosego Anotogi Kapiya Walektikke perarau lende mizarik pelik kai, Anotogo solo panu watabi mabiyeng keremizawekke Anotogo yombubek keya yongokmele keremiza. ");
INSERT INTO big_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Piliktikki wiyeke yombubek yongokmele weiyagi purik yombubek pigi panu keya mangoyau wezayagi logo pigi yongokpumele kiling menalege yoluweki ");
INSERT INTO big_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","logo piyau weik wamenakweki, kai. Togo Anotogi wirege piyau weik neyau ono, segeya pugu piyau wamenak mizi. ");
INSERT INTO big_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tegi yombubek yongokmele wei puwekke Anotogo piyau yongkambu weiya kai, legi yombubokko yongkambu weiya pura ngela logo pigi yongokpumele wezamelagi ono, a’a’, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pulaga puwili i namakke ige la logo Yisuyegi ngezebokko waligeleyiwiligu ngago yaka pugu kai puragi nguk meiya. ");
INSERT INTO big_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tegi Yisugu puwiliyegi pelik yeiya, Yombanu nakko pigi yongokpumele wezamela logo ngereke namele wei purik pi yombanu yongok ngezebekkimele weiya wizimowei ngereke namele kiling iwek kolibok kelik mizi yagenda. ");
INSERT INTO big_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma yongokmologo pigi kerekpubek wezamela logo ngereke nak wei purik pi yongok yombu ngezemelegibek weiya wizimowei ngereke yombu nak kiling iwek kolimolo kelik mizi yagenda. ");
INSERT INTO big_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wok nakke yongkambanu nawili puwiligi yango keya marekngangwili Yisuyegi iza orowei wiriya logo mele puguzik koloyakamandikwiligi kebiyengke walamiya logo Anotogo puwiliyegi wazono keleyibene, kapura Yisugu waligeleyiwiligu koloyakamandikwiligi panu keya mangowiliyegi ngalik yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kapura Yisugu purikki pakela logo pugu ngezebokko waligeleyiwiliyegi pelik kozang yeiya, Koloyakamandikwili neyegi wiriyi pani. Puwili neyegi lewa nelegi waliyi nagani, purik koloyakamandik pilikwilirau Anotogo puwiliyegi ngaiweki ngai pugumekki kiliya wiriyagi purik pangka. ");
INSERT INTO big_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kerewiyi, tamizeige nak Anotogo piyegi ngai wizeibene kazing koloyakamandik songonowili mizi mabilikmekke kelemi ono purik mabura pok Anotogo pigi ngaimekki ngai yolu puragi kiliya wiriyagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Togo Yisugu mandikwili ngezebekki ingewerege nak nak wazaya logo Anotogo puwiliyegi wazono keleyibene nguk meiya. ");
INSERT INTO big_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ngereke Yisu weik kazing libu tagoneige yombanu nak nginda kanda Yisugi ingewerege ingeyau laliya logo pelik nguk meiya, Kiriwaga wazonobek, yawe talikta miza logo ne wik wizagomagira weiyagi, meiya. ");
INSERT INTO big_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tegi Yisugu piyegi pelik meiya to mela, Nugu neyegi wazonobek kaira nangki? Nugu ne keriyirik ne Anoto, purik naktau wazono ono, Anoto wamenak wazonobek. ");
INSERT INTO big_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ni Mosegi lo piyengki iwaka. Lo piyeng pelik, Yombanu uli nagani. Yongkambu weiya puwili nigi kerekpu onobek ma nigi yongokpu onomele kiling iwek koli nagani. Yombanu nakki watabiyeng purik ngowei nagani. Yombanu nakyegi langai ngaigu kai nagani. King weiyagirikki weraga ngaigu kai nagani. Keya nigi panu keya mangoyauyegi panga yungke mizimo, meiya. ");
INSERT INTO big_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tegi yombubokko Yisuyegi pelik meiya, Lo nugu neyegi yaka kozak nei piyeng mabiyeng ne mandik songonowekkerikka kiriwei mizi kayima, meiya. ");
INSERT INTO big_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Logo Yisu piyegi pakela logo piyegi keli legi pelik meiya, Purik wazono kapura ni ngoluk watabi nayendau miziweki. Watabi nigi piyengko nigi kazing wik wizagomagira weiyagimek waliya legi watabi nigi piyeng mabiyeng yombanuwiligu weibene yani kune logo king piyengki ngane weiya piyeng yongkambanu watabiyengki yeik puwili yanimo. Pilik miza logo purik nugu lewege panu kelira paka ngalege wik wizagomagira purikki iwakagi. Logo mabiyeng pilik yana logo neyegi saweliweki kiriwei koli, meiya. ");
INSERT INTO big_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yombanubek pilik kai puragi kerewiyawekke wiregawerera yalekke sara wiziya keya wilek kang pugubek kuneng, purik pi watabi puguyeng kolokngagono panu logo yanagirikki kiyebuk kopong. ");
INSERT INTO big_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yisu pakeliwei miza logo pugu yombu ngezebokko waligeleyiwiliyegi pelik yeiya, Yongkambanu watabiyengko kola puwili Anotogo puwiliyegi ngaiweki Anotoyegi panga yungke kunagirik yawe unatuba panu kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pigi waligeleyiwili ngago puragi lelengkiri legi ngereke Yisugu puwiliyegi pelik yeiya, Mandikwili, kerewiyi, yongkambanu king keya watabiyeng yemane panuyeng mizi puwili Anotogo puwiliyegi ngaiweki keleyagirik yawe unatuba panu kani. ");
INSERT INTO big_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kerewiyi, liyeng Kamelmek meimok nili kagorik lolo ulibekki yungurikke kiliya kang purik yawe unatuba kapura yombanu watabi kolokngagono puguyengki kozang kumulibokko Anotogo piyegi ngaiweki kelemiyagirik yawe unatuba panu, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Togo yongkambanu ngago puragi kerewiyawili lebuk panu miza logo Yisuyegi pelik nguk meiya, Tamizeige pilik purik mabura yongkambanu wik wizagomagiragi wiyeke yaliya wazayagi langai puwili tawili? Nakkorau pangka mizagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tegi Yisugu puwiliyegi ngai yuke panu wizimowei pelik yeiya, Ei, yombanu nak ngezebokkorau ngezebek wik wizagomagiragi wiyeke pangka yaliya wazamiyagi ono, kapura Anotogo yombanu nalik miza keya pilik puwili mabuwili pangka yaliya wazayagi purik Anoto watabi mabiyeng pangka mizibek, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita pilik kerewiya logo pi wik wizagomagira weiyagi ma yeik miza wizimowei Yisuyegi pelik meiya, Kerewiye, teni yereng keya watabi tenigi piyeng mabiyeng wizamiya logo niyegi saweliweki kiriwei mizi, meiya. ");
INSERT INTO big_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tegi Yisugu puwiliyegi pelik yeiya to mela, Ei, wameik, keya nogo inuwayegi pera kozak yeiweki, Yombanu nak neyegi saweli keya nazuwagawiliyegi Anotogi ngago wazonora kozak yeiyagirikki wiyeke i pugumak wiyi keya yereng pugura wiyi, ma pigi si keya sakwili wezayi, ma pigi panu keya mangoyau wezayi, ma koloyakamandik puguwili wezayi ma ngabelak pugubek wiyi kang pilik pok ");
INSERT INTO big_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mabek ngoluk wik wizigeya Anotogo kanga managi piyeng kolokngagonogi, iyeng keya yerengyeng, keya si keya sakwili keya panu keya mangowili keya koloyakamandikwili keya watabi pugu wiya piyengka ngoluk lewegeyeng managi kapura nawiligu pilik pok neyegi wiyeke kunengyeng managi keya ngangang kelemiyagi. Kapura teng kalike lewagi purage Anotogo pi wik wizagomagira managi. ");
INSERT INTO big_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mabek yombanu yemane yolu puwili tonugu weik yemanewili mizi kapura kalike Anotogo puwiliyegi keriya logo puwiliyaga kolokngagonowili yeikwili keleyagi, keya mabek yombanu tonugu yeikwili mizi puwili kalike Anotogo puwiliyegi keriya logo puwiliyaga kolokngagono yemanewili keleyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pulaga Yisu kiling yombu pi ngezebokko waligeleyiwili kazing paka Yirusalem yerengke kang leweng neing kuna. Yisu were kapura pugu waligeleyiwiligu Yisu Yirusalem kangweki mizi purikki kumula meli keya yongkambanu kiriwei kangwili kazi mizi purik yawe kuneng nara paka pulogo lewagelagi ma talikki miza legi. Tegi Yisugu yombu meleyau keya pongo ingenazikka neyau pi ngezebokko waligeleyiwili lewe narikke iza oroweirik weik puwiliyegi watabi kalike yombanuwiligu piyegi kelemiyagi piyengki pelik kozak yeiya, ");
INSERT INTO big_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kerewiyi, tonuwa paka Yirusalem kangweki logo pungezige yombu nakko ne yombanu paka ngalega kayimabek nawiliyegi niza yanagi logo puwiligu ne niza oroweirik Yudawiligi yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwiliyegi niza yanagi. Keya puwiligu ne ngagozak keleniyagi logo neyegi ngagoyeng yowagi logo pelik kisagi, Pi ibengkibek, kisagi. Togo puwiligu ne Yuda onowiliyegi niza yanagi. ");
INSERT INTO big_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Togo Yuda onowiligu neyegi ngago wageliwei neiyagi keya ne sibilak ngiza nanagi keya puwiligu ne wizale nelagi keya ne ibengki kapura wok neyau wiziya logo wok kalikebekke ne ngereke wik yangalektagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Pulaga Sebetigi marekyau Jems keya Yowan piyau Yisuyegi mereke kandarik pelik meiya, Kiriwagabek, togo kelirik te nugu watabi togo niyegi nguk nei piyeng teyegi mizagi keli, meiya. ");
INSERT INTO big_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tegi Yisugu piyauyegi pelik yeiya, Yali nogo watabi nangaiyeng yaliyegi mizagi keli, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Togo piyaugu Yisuyegi pelik meiya to mela, Kalike ni ngai nugurage nigi tung ngaiwaktik kilindikke mogosa logo ngai nugumekki kozang nugurago ngai puwekke te tung yeik lewegera kilingyaugu mogosi piyauge niyegi saweliwei mogosiweki keleyimo. Teyaga nak nigi mele ngaigezuwagezikke keya nak nigi mele koranengkezikke mogosiweki keleyimo, meiya. ");
INSERT INTO big_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tegi Yisugu piyauyegi pelik yeiya, Yaligu nguk kisi piyeng yali iwaka ono. Ma kuneng yemane nogo wageliweki mizi piyeng kelikyeng yaligu wageliwekirik pangka? Ma ngangang yemane panu nogo wageliweki mizi pelikta yaligu wageliwekirik pangka ma yeik? ");
INSERT INTO big_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Piyaugu pelik meiya to mela, Te pangka, meiya. Togo Yisugu piyauyegi pelik yeiya, Ei, wameik, kuneng nogo wagelagi pura kelik nara yalirau wagelagi. Keya ngangang yemane panu nogo wagelagi pura kelik nara yalirau wagelagi. Puwiligu neyegi watabi keleniyagi pilik piyeng puwiligu yaliyegirau keleyagi. ");
INSERT INTO big_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kapura nogo yali nak mele ngaige nogozikke mogosi keya nak mele koranengke nogozikke mogosiweki keleyagi purik ne pilik keleyagi puragi ngaibek ono, Anoto ngezebokko tung mogosagi piyau yombanu pugu sawiya piyau yanagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Togo yombu meleyau Yisu ngezebokko waligeleyiwili puragi kerewiyawekke puwiligu weik Jems keya Yowanyegi sisik miza. ");
INSERT INTO big_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tegi Yisugu puwili mabuwili piyegi mereke wiriyiweki ngago yeiya logo pelik yeiya, Ngabelakyengki ngai yemiziwili yongkambanuwili puwiligi kulengke wazaya logo puwiliyegi ngai kozang yolu keya yemanewiligu yongkambanu yeikwili yaweyeng miziweki yani purik ini iwaka. ");
INSERT INTO big_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kapura kazing pilik pumokki kiriwei mizi nagani, segeya iniyaga nak yeikta lewegeweki kelibok purik pi ini nawiliyegi yawe mizibekweki, ");
INSERT INTO big_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","keya iniyaga nak iniyegi orozarikke wiziyagi kelibok purik pi yongkambanuwili mabuwiliyegi kulengke yawe mizibekweki. ");
INSERT INTO big_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Purik nerau, ne yombanu paka ngalega kayimabek kayimarik ne yongkambanuwili neyegi yawe miziweki kayima ono, ne yongkambanu puwili mabuwiliyegi yawe mizi keya saweliweki kayima, logo yongkambanuwiligu kaile miziyengki weraga Anotogo puwiliyegi ngangang yanagi ono, pilik segeya Anotogo neyegi ngangang puwiligiyeng nanagirik nogo ne makngezebek ne nelagiwiliyegi ngaungaugu niza yanagi logo yongkambanu kolokngagonowili kaile puwiliyengko wigirawili kaile puwiligiyengka wila wazayiweki, yeiya. ");
INSERT INTO big_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Togo Yisu kiling pugu waligeleyiwili keya yongkambanu kolokngagonowili weik ngereke paka Yirusalem kangweki kambela logo yereng Yeriko mei puragi kayima logo puwili yereng pura wiyiweki mizi tagoneige yombu wireyau kusa nak kazingmekke kerelege mogosa wizimowei yongkambanu ngabelak libu kangwiliyegi ngeragi keya kingyengki nguk yeiyageya wizilege. Pi Timiya meibekki marekpek logo Patimai meibek. ");
INSERT INTO big_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Patimai wireyau kusabek Yisu yereng Nasaretegabok kiling yongkambanu paka Yirusalem kangkiwiligu kandikki pi kerewiyawekke pugu pelik ngalizi kek kaiya, Yisu, ni negi yelibu koka King Ngai Tawiti meiyabokki marekngangwiliyagabek logo Anotogo teni Yudawiliyegi wiyeke wezanelabok purik nogo iwaka, legi neyegi yalek mize, kaiya. ");
INSERT INTO big_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pilik kai legi yongkambanu kolokngagonowili piyegi pelik meiya, Ni ngagoluk wizei, meiya. Kapura pi mazeng keya pelik kek kaiyageya, Ni King Ngai Tawitigi marekngangwiliyagabek legi neyegi yalek mize, kaiyageya. ");
INSERT INTO big_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tegi Yisu leng miza logo nawiliyegi pelik yeiya, Pi neyegi koli mei, yeiya. Togo puwiligu wireyau kusabekyegi ngago meiya logo pelik meiya, Wilik mize, luweze. Pugu koli nei yagenda mena koli, meiya. ");
INSERT INTO big_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Togo pi kagorik yeke ngalegerik pela mela logo nguk namizi yangalekta Yisuyegi wiriya. ");
INSERT INTO big_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Togo Yisugu piyegi pelik nguk meiya, Nangaiyeng nogo niyegi miziweki ni keli, meiya logo wireyau kusabokko pelik meiya to mela, Negi Yemizibek, ne ngereke wireyaugu pakelagi keli, meiya. ");
INSERT INTO big_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Pilik kai legi Yisugu piyegi pelik meiya, Ni yombiyangai keleniyagi purik pangka purikki ngizi kumuli nugurikku mizagewiyege nogo mizi yagenda mena kambele, meiya logo wire puguyau nguk namizi ngaiwila logo Patimai Yisuyegi kiriwei kazing leweng neing kambela. ");
INSERT INTO big_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Togo Yisu kiling pugu waligeleyiwili Yirusalem lemengki merekewekke lewak Olip meibekke wiriya. Lewak pokko yengelei olipyeng lewarikki wiyeke yeik pura meiya logo yereng neyau lewakpekke ngezege wizilege. Yereng nara Petepasi meira keya yereng nara Petani meira. Puwili yereng piyaugi mereke kandawekke Yisugu yombu ngezebokko waligeleyi neyau were ngago pelikta kiling wezayela, ");
INSERT INTO big_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Yereng mereke paka purage kunizo. Yali pulogo kiliya tagoneige purik liyeng tongki kong namek nakko wakleige wibokko tariya logo wizi penanging kani, ngoluk nakkorau mogosa onomek logo wei yongomo miza onomek. Pumokko wi tariya piyeng wila mowiya logo pelege miza orowei koli. ");
INSERT INTO big_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Keya tamizeige nakko yaliyegi pelik kai, Nangki yali pumokki wibek wili, kai purik mabura piyegi pelik kozak meizo, Yemizibek pemekyegi yawe nara legi te miza orowei kang. Were yawe pura miza logo pugu nguk namizi miza orowei yogine, meizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Togo piyau kambela logo kanda liyeng tongki kongmek i namakka kandikke wakleige tariya logo kazingmekke luwe wizilege yolok ngela. ");
INSERT INTO big_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Logo piyau liyeng tongki kongmekki wi tariyabek wilageya tagogei pura yombanu mereke koya nawiligu piyauyegi pelik yeiya, Yali liyeng tongki kongmek wili pura nangki, yeiya. ");
INSERT INTO big_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tegi Yisugu yaka kaiya pilik piyaugu yeiya to mela, logo yombanuwiligu piyau kunibene keleya. ");
INSERT INTO big_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Togo piyau liyeng tongki kongmek Yisuyegi miza orowei wiriya. Pilik miza logo pugu waligeleyiwiligu kagorik yeke ngalege waliya piyengka panga liyeng tongki kongmekke ngalege wiya logo Yisu tongki kongmekke ngalege mogosa logo wiriya. ");
INSERT INTO big_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yisu tongki kongmekke ngalengale yagoneigeya yongkambanu kolokngagono pi kilingwiligu pi King Ngai Yemizi puwiligibek sawiya logo kagorik puwiligi yeke ngalege waliya piyeng kazingmekke welelagelega wiya. Keya nawili kirekkirek mele keya pulangaiyeng kira logo kazingmekke laga wiya. ");
INSERT INTO big_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yongkambanu piyaga werewili keya kalike piyegi kiriwei nawili miza puwiligu yeik pugura yongolok mei wirimowei pelik ngalizi kek kisa, Pok teni yaliya wazayagibek, teni yeik pugura yongolok meiweki. Pok Anotogo wezamelabek legi Anotogo pi kozanda maniweki. ");
INSERT INTO big_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tenigi yelibu kokabek Tawitigi yeligagangmekkabokko teniyegi ngai yoluweki mizi, Anotogo pi kozanda maniweki. Anoto paka ngalege panu yolubek weik teni yaliya wazayiweki, kisa. ");
INSERT INTO big_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Togo Yisu Yirusalem yerengke kiliya la logo Anotogi i walek yemanemakke yeke ige kiliya logo pi watabi mabiyengki pakeliwei kaiyageyara yokmek weik kiliyaweki mizi, legi pi yombu meleyau keya pongo ingenazikka neyau pi ngezebokko waligeleyiwili kiling welagela logo pongo yereng Petaniraga iwek koliweki kambela. ");
INSERT INTO big_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wangane panu pura puwili yereng Petanira wiya logo paka Yirusalem kang yongowekke Yisu yagasi miza. ");
INSERT INTO big_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Pi koweige songono nangezi tapakaleige pura pugu yengelei Fik mei nalei lekpokko kola wizilege pakela. Pi yengeleilei wira nobiyeng miza kapura pi mereke wiriyawekke pugu lekyeng keke pakela, purik teng wiriwekira ono kopong. ");
INSERT INTO big_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tegi Yisugu yengelei Fik puleigi pelik meiya, Ni mawinda wilekyeng wiragi ono logo nakkorau nugu wirayeng ngereke nagi ono yeikki, meiya. Pugu waligeleyiwili Yisugu yaka kai puragi kerewiya. ");
INSERT INTO big_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Puwili paka Yirusalem lewagela logo Anotogi i walek yemanemakke kuna. Pi imakki yerembekke kanda yongkambanuwili kingyengki ngane liyeng kau keya liyeng memeng keya winakwiliyegi pulogo pundik keremizageya koyilege keya nawili lalekyengki mogosa wizigeya yombanu nalagawiligi king nalangai piyeng Yudawiligi king piyengke kowita to mela logo watabi pulogo piyengka weiweki mizageya koyilege. Logo yombanu kingyengki ngane watabi yaniwiligu pelik kumuli, Tonuwa king yemane weiweki mena miza. Logo Yisu kazing kaile pumokki pakela logo kiyebuk, legi pugu yongkambanu kingyengki ngane watabi wei keya yani mizageya puwili keleyayela logo yombanu kingyeng kowitageya puwiligi lalekyeng kowita kela wezamela logo yombanu winak Kuwemimiwili wiyiwiligiyeng kowitagelega wezameli kang keya kelemiya. ");
INSERT INTO big_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Keya pugu kozang pelik kaiya, Pemak Anotogi i walek yemanemak legi nakkorau ting kai kolayeng ma watabi yawe mizagi pilik piyeng Anotogi i walek yemanemakki yerembek neing orowei kang nagani, kaiya. ");
INSERT INTO big_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pilik miza logo Yisugu yongkambanuwiliyegi ngago pelik yana, Anotogi Kapiya Walektikke lende mizarik pelik, I Anotogimak i yongkambanu ngabelakyeng mabiyengkawili mabuwiligu piyegi waberek mizagimak, kapura inugu pung wezarik keremizarikku i Anotogimakki yeikta kaile sawiya logo weik yombanu king ngoweiwiligu king ururu yolu piyeng kelik keremiza, kai, yeiya. ");
INSERT INTO big_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Keya pulaga yombu Anotoyegi kolak miziwiligi ngaiwili, keya Mosegi loyengki waligeleyiwili watabi Yisugu miza piyengki kerewiya logo kumularik yongkambanuwili mabuwiligu ngago Yisugu yaniragi lelengkiri legi puwiligu kumularik yongkambanuwiligu puwiliyegi kezanga yanagi mamiza. Tegi ngai yemanewili Yisuyegi sisik panu logo puwili kazing talikmekke Yisu ulagi miza legi kumula. ");
INSERT INTO big_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Togo yokmek kiliyawekke Yisu kiling pugu waligeleyiwili Yirusalem yerenda wiya logo kambela. ");
INSERT INTO big_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wangane pura puwili kazing libu kang kunimowei puwili yengelei Fik Yisugu ulogo ngago mana puleigi pakela. Puleigi meleyeng keya lekyeng keya pulili yeke ngalegeyeng keya pulili yengezegeyeng mabiyeng ngoliya logo ibeng wizilege. ");
INSERT INTO big_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita ulogo mizayengki kumula logo Yisuyegi pelik meiya, Kiriwagabek pakele, yengelei Fik ulogo nugu ngago mana pulei ngoliya logo ibeng pelei, meiya. ");
INSERT INTO big_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tegi Yisugu puwiliyegi pelik yeiya to mela, Inuwa Anotogo watabi mabiyeng pangka mizagi langai purikki ngizi panu kumulizo. ");
INSERT INTO big_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kerewiyi, nogo inuwayegi ngago wameik pera kozak yei, tamizeige yombanu nakko lewak pobokki pelik mei, somiyora koli logo panga kai wizambekke wale, mei logo tamizeige yombanu pok Anotoyegi ngizi panu kumula logo kangka neyau ono purik mabura pokko kaiyara ngizi mizagi. ");
INSERT INTO big_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Purik pilik legi nogo inuwayegi pelik yei, inuwayaga nak Anotoyegi waberek mizageya wizimowei piyegi watabi nayengki nguk mei puwekke purik ni Anotoyaga weiyagirikki ngizi panu kumulimo, logo Anotogo ni nanagi. ");
INSERT INTO big_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Keya ni Anotoyegi waberek miziwekke tamizeige nakko niyegi kaile miza logo ni ngoluk piyegi sisik mizi purik mabura were ni kaile pugu niyegi mizayeng tumula logo keremareke wezamelimo logo Anoto nigi Mango paka ngalege yolubokko nugu watabi kaile miza piyeng tumula logo keremareke wezameliweki logo Anotogo ni watabi nugu piyegi nguk mei piyeng nanagi. ");
INSERT INTO big_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kapura tamizeige nugu nawiliyegi kaile puwiligu niyegi miza piyeng kebangkela logo tumula wezameli ono purik mabura Anoto nigi Mangobek paka ngalege yolubokkorau kaile nugu mizayeng tumula wezamelagi ono, kebangkelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Togo puwili ngereke Yirusalem yerengke yo logo Yisu Anotogi i walek yemanemakke wei mizageya tawizeige Yudawiligi yemanewili keya yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwilirau Yisuyegi wiriya ");
INSERT INTO big_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","logo piyegi pelik nguk meiya, Ni yeik talikta kilimbokko yawe pera mizi? Keya takko ni yawe pera miziweki pangkara nana? ");
INSERT INTO big_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Pilik kisi legi Yisugu puwiliyegi pelik yeiya to mela, Mena, nerau inuwayegi ngago naragi nguk yeiweki. Tamizeige inuwago neyegi kangara neiya yo meli mabura nogo takko ne yawe pera miziweki pangkara nana miza purikki inuwayegi kozak yeiyagine. ");
INSERT INTO big_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Neyegi kozak nei, Yowan kaimelabek kayima logo yongkambanuwili kaimela puwekke yawe kaimela pura Anotogi yawera ma yombu ngabelakpekkewiliyaga nakki yawera miza purikki, yeiya. ");
INSERT INTO big_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Togo puwili ngezewili pulogo pelik kozak keli yongomo miza, Teni talik meiyagi? Tamizeige tonugu pelik meiya to meli, Anotogira, mei purik mabura pugu pelik nguk yeiyagi, Inuwa watabi Yowangu kai piyengki ngizi kumula onora nangki, yeiyagi, ");
INSERT INTO big_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","kapura yongkambanu pewili Yowan ngizi Anotoyaga kayima logo ngago piyagayeng kozak kaiyageya wiziyabektikki ngizi panu kumuliwili kopong tonugu pelik mei, Yombanu ngabelakpekkewiliyaga nakkira, mei purik mabura yongkambanuwiligu teniyegi sisik mizagi, kela. ");
INSERT INTO big_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Togo puwili yongkambanuwiliyegi kazi miza kopong puwiligu Yisuyegi pelik meiya to mela, Yawe Yowangira talaga kayimara miza purik teni lusuwei, meiya logo Yisugu puwiliyegi pelik yeiya to mela, Pilik mabura, nogorau inuwayegi takko ne yawe pera miziweki pangkara nana miza purikki kozak yeiyagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Togo Yisugu ngago pura yeiya logo yongkambanu pulogo wawere ula puwiliyegi ngago saweliwei nayengki weik kozak yeiya. Pugu puwiligi yemanewiliyegi langai saweliwei pera pelik yeiya, Yombanu nak waing yawe nalei ngeriya logo lemeng kozang namek yawereng kelemiya logo kawik watabi waing wilekyeng wambulagirik wiziyagirik yokora logo i yokolong ngai yawe puleigi ngaiwekibek wiziyagi namak ngiza. Togo pugu nawili yawe puleigi ngai koyibene wazaya logo puwiliyegi pelik yeiya, Yawe nogoleigi yawe mizageya koyimowei waberek ngai koyizo. Keya waing wilekyeng weik kuk puwekke purik mabura piyeng tiyizo logo waing keremizizo. Pilik yeiya logo yawe puleigi mangobek nalege koweige kambela. ");
INSERT INTO big_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Togo waing wilekyeng weik kuk wizigeya wilekyeng tiyagiwekke pugu yombu ngagora orowei nak yaweleigi ngai wazayawiliyegi wezamela logo yaweleige waing wilek piyengka waing keremiza nayeng weiweki, ");
INSERT INTO big_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","kapura ngai wazaya puwiligu ngagora oroweibek kebangkela logo wizale ula logo yeik wezayongomela. ");
INSERT INTO big_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tegi yaweleigi mangobokko ngereke ngagora orowei nak mazenda wezamela, kapura puwiligu pokki kebira ngandek uli keya ngago kaile meiya logo mabilik yeik wezayongomela. ");
INSERT INTO big_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pulaga pugu mazenda ngagora orowei naktau wezamela, kapura puwiligu pok ula logo ibeng keya yombu kolokngagono ngagora orowei wezayela puwilirau puwiligu mabilik keleya. Nawili ngangang yana keya nawili yela logo ibeng. ");
INSERT INTO big_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pilik miza logo weik wamenak wezamelagi langaibek yolu logo pok ngezebekki marek wamenak pugu keli panubek. Logo kalik panuge mangobokko kumularik pelik, Nogo ne makngezegi marekpek puwiliyegi wezamelagi, purik puwiligu negi marekpekki ngagoragi kerewiyagi, pilik kumula logo pi wezamela ");
INSERT INTO big_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","kapura yaweleigi ngai wazayawiligu pigi marekpekyegi pakelawekke puwili nakko nakyegi pelik meiya, Pek yaweleigi mangobekki marekpek kani. Kalike pigi mangobek ibeng puwekke pi yawe pelei weiyagibek. Tegi teni pi ula logo mango ibeng purik waing yawelei teni makngezegiweki mena, kela. ");
INSERT INTO big_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Togo puwiligu mandikpek miza logo ula logo ibeng. Togo puwiligu yasu pugurik panga yaweleige yenge wilingke wezamela. ");
INSERT INTO big_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Togo yaweleigi ngai wazayawiligu pilik miza purikki yaweleigi mangobek puwiliyegi talik mizagi? Yaweleigi mangobokko kanda yaweleigi ngai wazaya puwili neneng ngela logo yawe pura ngereke nawiliyegi yanagi. ");
INSERT INTO big_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Inugu Anotogi Kapiya Walektikke neyegi langai pelik sangkeli purikki kumulizo, purik purikku pelik kai, King yombu imak ngiziwiligu kiyebuk miza logo wezamela pura ngereke king panu imak mamak kebangkela yolu pura kani. ");
INSERT INTO big_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Pilik yolu pura Anoto Yemizibek ngezebokko pilik wazamiya logo tonugu purikki pakela logo purik yombiyangai panu miza. ");
INSERT INTO big_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yudawiligi ngai yemanewili Yisugu ngago saweliwei yaka kozak kai puragi puwiliyegi langai kozak kairikki iwaka logo puwiligu Yisu kebangkeliweki miza kapura puwili watabi yongkambanuwiligu mizagi piyengki kazi legi puwili weik pi wezamiya logo wei kang kuna. ");
INSERT INTO big_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pulaga yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwiligu yombu Palisi mei nawili keya yombu Ngai Elodoyegi kiriweiwiliyaga nawili Yisuyegi ikuyogorik miziweki wezayela. Togo puwili kunimowei nakko nakyegi pelik meiya, Tonuwa Yisuyegi pelik meiyagi, Nugu kumularik talik? Teni king takisyeng Romwiligi King Ngaibek Sisa meibokyegi managi purik pangka ma yeik, meiyagine. Tamizeige pugu, Ei, mani, kai purik mabura yongkambanuwili king takisyeng managirikki kiyebuk mizi nangai legi puwiligu pi kingyengko ulagi. Tamizeige pugu, A’a’, mani nagani, kai purik mabura tonuwa pi Romwiligi ngaiwiliyegi miza orowei kangkine logo puwiligu pi ngagozak kelemibene, kela. ");
INSERT INTO big_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Togo puwili Yisuyegi kanda piyegi pelik meiya, Kiriwagabek, nugu kaiyeng keya waligeleyiyeng wameik ngizi panuyeng purik tonuwa iwaka. Keya ni nakyegirau kazi mizi onobek ma ni yewizek mizi onobek, ni yongkambanuwili mabuwiliyegi kazing Anotogi ngizi panumekki waligeleyibek purik tonuwa iwaka. Kapura nugu tonuwayegi poburikki kozak yei, Lo tonugurago talik kai, teni king takisyeng Sisayegi managi kai ma managi ono kai ");
INSERT INTO big_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","keya managi purik pangka ma pangka ono kai, pilik nguk meiya. Kapura Yisu puwili yombu kiligang neyau lewawili purik iwaka logo pugu puwiliyegi pelik yeiya, Inuwago neyegi ikuyogorik kelenira nangki? King keke nalik neyegi orowei koli logo nogo pakeliweki, yeiya. ");
INSERT INTO big_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Logo puwiligu piyegi nalik orowei kanda logo pugu pelik nguk yeiya, Wiregawere king pelikke pera takkara keya yeik takkara wizine pakeli, yeiya. Tegi puwiligu pelik meiya to mela, Romwiligi King Ngaibek Sisagiyau, meiya, ");
INSERT INTO big_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","legi Yisugu pelik yeiya, Mena, watabi King Ngaibekkiyeng purik King Ngaibekyegi manizo, keya watabi Anotogiyeng purik Anotoyegi manizo, yeiya logo puwili ngago pugu wazono kaiya yo meliyengki lelengkira. ");
INSERT INTO big_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Keya pulaga yombanu Sadusiwili meiwiliyaga nawili Yisuyegi ikuyogorik kelemi wiriya. Sadusiwili yombanu pelik kisiwili, Yombanu nak ibeng purik kung pugubektau ibeng logo pi ngereke yangalektagi ono, kisiwili. ");
INSERT INTO big_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Puwiligu Yisuyegi pelik meiya, Kiriwagabek, Mosego lo tenigi lende miza nara pelik, Tamizeige yombanu nak yongok weiya logo mandik wazami ono wiziya yombubok ibeng purik yombubokki sakpek ngereke yongok komatemolo weiyagi logo piyaugu yombu yaka ibembokki yango keya marekngang nawili wazayiweki. ");
INSERT INTO big_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yombu ingini melenazik keya nazikka neyauwili koya. Logo kalogolibek were yongok weiya logo mandik wazamiya ono wiziya pi ibeng. ");
INSERT INTO big_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Keya pulaga waleleige kalogolibekki kelengkebokko ngereke yongok komatemele weiya kapura piyaurau mandik wazamiya ono koya pi ibeng. Keya pulaga pokki kelengkebokko komatemele ngereke weiya. ");
INSERT INTO big_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Logo yombu melenazik keya nazikka neyau puwili mabuwili pilik miza kapura mandik wazamiya ono koya ibeng. Logo kalik panuge yongok komatemelerau ibeng. ");
INSERT INTO big_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mena, teni niyegi ngago peragi nguk neiweki, Tamizeige wok kalik panubekke yongkambanu ulogo ibeng puwili nugu kai pilik yangalekta wik yolugi mabura yongok komatemolo yombu melenazik keya nazikka neyau puwili mabuwili weiyamele legi tamizeige kalike ibengwili ngereke yangalekta puwekkerik yongok yaka pumolo takki yongokpumele mizagi, meiya. ");
INSERT INTO big_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Legi Yisugu puwiliyegi pelik yeiya to mela, Inuwa Anotogi Kapiya Walektik keya pigi kozanda lusuwei kopong inuwago watabi pilik piyengki kumulirik kokowa. ");
INSERT INTO big_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Purik ibengwili yangalekta wikwekke puwili Anotogi angela paka ngalegewili kelikki logo yombuwili keya yongokwili yongkambu weiyagi ono, ma panu keya mangogo kolomele yombu weiyagi nakyegi miza managi ono. ");
INSERT INTO big_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ibengwili ngereke yangalekta wazayagirik nogo Anotogi Kapiya Walektikke yungke inuwayegi pilik kairikki kozak yeiweki mizi. Mosego Anotogo ibek solo ngori purikki yungka piyegi meiyaragi lende mizarik pelik, Ne Anoto Abalamgibek keya ne Anoto Isakkibek keya ne Anoto Yakopgibek, meiyara lende miza. Anotogo pilik kaiyawekkerik, Abalam keya pigi marekpek Isak keya Isakki marekpek Yakop ulogo ibengwiliyegi pi pilik kaiya kapura Anotogo puwili wik kai yagenda. ");
INSERT INTO big_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ulogo puwiligi korikyeng ibeng kele kapura wilek kang puwiligiyeng wik yolu. Logo inuwayegirik puwili ibeng kapura Anotoyegirik puwili wik yolu, legi pi Anoto wik yoluwiligi ngaibek. Togo inuwago kumula purik kokowa panu, yeiya. ");
INSERT INTO big_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mosegi loyengki waligeleyiwiliyaga nak wiriya logo Yisu Sadusiwili kiling ngago kelageya koyilege kerewiya logo pi Yisugu puwiliyegi ngago wazonoyeng yeiya to meli purikki pakela. Tegi pi Yisuyegi ngago naragi nguk meiya, Lo Anotogo teni yanayengka lo talikta yemane panura, meiya. ");
INSERT INTO big_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tegi Yisugu pelik meiya to mela, Ini Isileiliwili mabuwili kerewiyi. Lo yemane panura pelikta, Anoto tenigibek Yemizibek keya pi Yemizi wamenakpek. ");
INSERT INTO big_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Logo ni Anoto nigi Yemizi ngaibekyegi wilek kang nugubek mabokko ngizi panu kelimo, keya kangka nugubokko piyegi wilibek kumuli mizimo, keya piyegi kozang nugura mabura manimo. ");
INSERT INTO big_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Keya lo puragi kelengkera pelikta, Ni makngezogo ni makngezeyegi keli mabilik nakyegirau mabilik kelimo. Lo nayengko piyauyaga ngalege panu ono, meiya. ");
INSERT INTO big_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Togo Mosegi loyengki waligeleyibokko Yisuyegi pelik meiya, Kiriwagabek, wameik, watabi yaka kai piyeng wameik panu. Ei, Anoto wamenak, naktau wizinda ono, Anoto keke. ");
INSERT INTO big_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Keya wilek kang tonuguyeng mabiyengko piyegi ngizi panu kelizo keya kangka tonuguyengko piyegi kumuli mizizo, keya kozang tonuguyeng mabiyeng piyegi manizo. Keya teni makngezogo teni makngezeyegi keli mabilik nazuwagawiliyegirau mabilik kelizo. Pilik mizi piyengko teni Anotoyegi watawili yezizikke waliya mani ma watabi piyegi kolak kelibene wazamiya piyeng ula, meiya. ");
INSERT INTO big_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Togo Mosegi loyengki waligeleyibokko ngago yaka meiya piyeng pangka meiya purik Yisugu pakela logo Yisugu piyegi pelik meiya, Ni weik Anotogo niyegi ngai wizeibene kelemiweki mereke, meiya. Keya pulaga nakkorau Yisuyegi mawinda ngago nara nguk meiyarau ono, puwili weik kazi. ");
INSERT INTO big_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Wok nakke Yisugu yongkambanuwiliyegi Anotogi i walek yemanemakke waligeleyageya wizimowei pugu ngago nara pelik nguk yeiya, Mosegi loyengki waligeleyiwiligu Kilisibek koka King Ngai Tawitigi marekngangwiliyaga nak kisira nangki? Puwiligu ngago pilik kisirago Kilisibek yeik yombanubek kisi yagenda. ");
INSERT INTO big_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kapura koka walaka Anotogi Kung Walekpokko Ngai Tawitigu kaibene kelemiya logo Tawitigu kaiyara pelik, Anoto Yemizibokko Kilisibek Yemizi nogobekyegi pelik meiya, Nogo niyegi kiyebuk miziwili nigi kulengke nugu ngaiweki wazayirikka negi ngaigezuwaga pelaga mogosi koli, kaiya. ");
INSERT INTO big_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tawitigu Kilisibekyegi Anoto Yemizibek meiya legi talik miza logo Kilisibek Tawitigi marekngangwiliyaga nak? Pilik mabura Kilisibek mabok yombanubek keya Anoto wizinda. Yisugu puwiliyegi pilik yeiya logo yongkambanu kolokngagono Yisuyegi kerewiya puwili wilik. ");
INSERT INTO big_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Keya Yisugu puwiliyegi mawinda ngagoraga pelik waligeleya, Inuwa yombu Mosegi loyengki waligeleyiwili kelik nagani, puwiliyegi kani waberek panu. Purik puwili kagorik wazonoyeng keya melewangka yokolongyeng wakiya logo wei miziweki keliwili, logo yongkambanuwiligu puwili yemanewili mizibene. Keya puwili pundikke yongkambanu mamokki wirege puwiliyegi pelik yeiweki miziwili, Wangane Ngaibek, miziwili. ");
INSERT INTO big_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Keya puwili i walek songonoyengke paka orozarikke yongkambanuwiligi wirege yongkambanuwiligu pakelibene mogosiweki keliwili. Keya puwili ngeragi yemane miza ni piyengke tung yeikyeng kilingwiligu mogosi piyengke mogosiweki keliwili. ");
INSERT INTO big_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Puwili yongok komatewiligi iyengki kanda purik puwili yongok komatewili purikki iwaka koyimowei ngaigu king i walekmakkiyeng weiweki yeiya logo kalike ngereke ngezewiligi liwik wawiyiwili. Keya waleleige purik puwili kaile ngezewiligiyeng momane meibene Anotoyegi waberek miziyeng yokolong panu meiwili. Togo kalike Anotogo yongkambanuwili kaile puwiligiyengki wiyeke ngagozak keleyi puwekke puwili ngangang weiyagi, kapura yombanu loyengki waligeleyi puwiligu kaile panu mizi piyengki wiyeke ngangang yemane panu weiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pulaga Yisu yangalek meiya logo peleng kingyengkiwekka koweige songono nangezi mogosa logo yombanu kolokngagonowili Anotoyegi opa maniweki king nayeng yeke ige pelengwekke wiyirikki pakela. Yombanu kingyengko kola kolokngagonowili king yemaneyeng wiya. ");
INSERT INTO big_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Keya yongok komate watabiyengki yeik panu namele kanda korok neyau wiya. ");
INSERT INTO big_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Togo Yisugu waligeleyiwili ngago yeiya logo puwiliyegi pelik yeiya, Nogo inuwayegi wameik panu kozak yei, yongok komate watabiyengki yeik pemologo wiya piyengko yombanu mabuwiligu wiya piyengka ngalege panu kani, ");
INSERT INTO big_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","purik puwili mabuwili king kolokngagonoyengka Anotoyegi puwiligu songono mani keya ngoluk kolokngagono yolu, kapura pemele, pi watabiyengki yeikmele kele kapura pugu wara yoluyeng mabiyeng yaka wiya logo pi ngeragiyeng weiyagi nayendau ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yisu Anotogi i walek yemanemakka welagela tagoneige yombu pugu waligeleyiwiliyaga nakko piyegi pelik meiya, Kiriwagabek pakele, puwiligu i walek yombiyangai pemak king yemane palumuyengko ngiza. ");
INSERT INTO big_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Togo Yisugu piyegi pelik meiya to mela, Kerewiye, i yemane nugu pakeli pemak mamak wok nakke yombanu Yudawiligyegi ngai miziwiligu yo wela melagi keya kingyeng sugusugu miza melagi, king neyau pulogo menalege nakki ngalege nak wiziyagi ono, puwiligu yowela melagi, meiya. ");
INSERT INTO big_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kalike Yisu lewak yengelei Olip meilei lewi logo lewak Olip meibekke mogosa logo pongo Anotogi i walek yemanemakki pakelageya wiziya logo Pita keya Jems keya Yowan keya Enduru puwili pi kiling keke koyimowei piyegi pelik nguk meiya, ");
INSERT INTO big_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Tonuwayegi kozak yei, puwiligu Anotogi i walek yemanemak yowela melagi purik talikwekke pilik mizagi? Keya kazing talikmokko pilik mizagi pura lewagelagirikki were teniyegi walimizagi, meiya. ");
INSERT INTO big_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tegi Yisugu puwiliyegi pelik yeiya to mela, Watabi lewagelagi piyengki nogo kozak yei pei. Inuwa yombu inuwayegi ngaigu kisi puwiliyegi kiriwei miza nagani, waberek panu. ");
INSERT INTO big_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Purik yombanu kolokngagono yeik nogorage lewagi kani logo pelik kisi wiriyi nangai, Ne Kilisibek, kisa logo yombanu kolokngagonowili puwiliyegi kiriwei kuni nangai. ");
INSERT INTO big_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Keya inuwa ngai mereke keli piyeng keya ngai yemane koweige keli lewa piyengki kerewiyi purik kulili mizi nagani. Watabi pilik piyeng mabiyeng were lewagelagiyeng kani kapura piyengko mizi purik ngabelakpek weik yeikkirikki mizi yagenda ono. ");
INSERT INTO big_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Purik were, yongkambanu ngabelak nakkewili kiling yongkambanu ngabelak nakkawili ngai kelagi, keya kapman ngabelak nakkebek kiling kapman ngabelak nakkabek ngai kelagi, keya yongkambanu ngabelak nayengkewili kiling yongkambanu ngabelak nayengkawili ngai kelagi, keya puwekkerik ngabelak kolokngagonoyengke kuburuk unatuba panuyeng ulagi, keya ngabelak nayengke ngaba ibeng yemane mizagi. Peyeng weik solo lewagela purik weik kuneng keya ngangang yemane panu pura weik mereke lewa legi. ");
INSERT INTO big_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Togo inuwa ngai koyizo, purik yombanu neyegi wiyeke iniyegi kiyebuk puwiligu inuwa kebangkela logo inuwa ngagozakyengki kerewiyiwiliyegi iza orowei kunagi, keya nawiligu inuwa i walek songonoyengke yeke ige wizale yelagi kani. Keya inuwa kapmanwiligi ngai yemanewili keya ngabelakpekki King Ngaiwiligi wirege neyegi kiriwei mizirikki weraga luweza wazayagi kani. Puwekke inuwa puwiliyegi neyegi langai kozak yei keya ngago nogo iniyegi waligeleyaragi langai kozak yeiyagi. ");
INSERT INTO big_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Keya Anotogi ngago wazono neyegi langaira yongkambanu ngabelak mabiyengkewiliyegi were kozak yei mizizo logo pulaga purik ngabelakpek weik yeikki. ");
INSERT INTO big_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Togo inuwayegi kiyebuk miziwiligu inuwa kebangkela logo iza orowei ngagozak miziweki kangwekke were pobilik wilek ngelek kumuli nagani, Teni ngago talikyeng kisagi, pilik kumuli nagani. Purik puwekke Anotogi Kung Walekpokko inuwa kangka ngago inuwago kisagi pura wazono kisiwekibek yanagi legi. ");
INSERT INTO big_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Keya puwekkerik yombanuwiligi si keya sakwiligu ngezewiligi si keya sakwili yombanu puwili yelagiwiliyegi iza yanagi. Keya yombuwiligu puwiligi yango keya marekngangwiliyegi mabilik keleyagi, keya koloyakongwiligu puwiligi panu keya mangowiliyegi mabilik keleyagi. ");
INSERT INTO big_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Keya inuwa yeik nogoraga yawe mizirikki wiyeke yongkambanu mabuwiligu inuwayegi kumbak mizagi kani. Kapura yombanu kunengyeng keya ngangang wagelageya wizimowei neyegi ngizi kumuli pura kozang kebangkeli kanda wila wiyi ngizige mologabok Anotogo wik wizagomagiragi yaliya wazayagimele keya pek, yeiya. ");
INSERT INTO big_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ini kapiya perik mei puwili ngago peragi solorikki kumulizo. Yisugu ngago nayendau mawinda pelik kozak yeiya, Koka walaka yombu Taniyele mei Anotoyaga ngagora weiya logo kozak kisawiliyaga nak Anotogi Kapiya Walektikke yungke Sadangki korowali Anotogi i walek yemanemak kaile kaile kelemiya melagi nayengki lende miza. Togo wok nakke inugu Sadangki korowali Anotogi i walek yemanemak kaile kaile kelemiya melagi piyengko Anotogi i walek yemanemakke wiziyagi onorikke wizilege pakeli puwekke purik mabura ngago peragi kumula logo pelik kisizo, Teni ngabelak Yudaya mei pobok wiya logo kazi paka lewakyengke liwik siweki kangweki, kisizo. ");
INSERT INTO big_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Keya imakka welagelabok ngereke yeke ige yongorik watabi puguyeng pi kiling oroweiweki wawari yongo nagani, yeik kunimo mei. ");
INSERT INTO big_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma yombu panga yawege yawe mizageya wiziyabok kik kalok pugugik weiweki yo kowiti nagani, yeik kunimo mei. ");
INSERT INTO big_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Togo wok piyengke yongok mandik kogo puwili keya yongok mandik yebili yani puwiliyegi ne yalek panu mizagi, purik puwili nguk namizi paka lewakyengke liwik siweki kunagi langai onowili legi. ");
INSERT INTO big_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Keya inuwago kumularik teni kabelakta kililiwekke kazi kangki onorikki kumuli nelegi inuwa Anotoyegi watabi kuneng keya ngangang peyeng teng kilili kelirage wiriyiweki kelemiya nelegi puragi waberek mizizo. ");
INSERT INTO big_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Purik wok piyengke kuneng korowali yemane panuyeng keya ngangang yemane panuyeng lewagelagi logo koka walaka solowekke Anotogo watabi keremizawekka wizageya kayimeige mabek pewekke pilik nayendau lewagela ono keya kalike ngereke pilik nayeng lewagelagi ono. ");
INSERT INTO big_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Keya Anotogo wok piyeng ngerewalek sa wazamiya ono kesak nak wik yolugi ono. Kapura yongkambanu Anotoyegi sawela logo pugu iza puwiliyegi pugu kumula logo puwiliyegi wiyeke Anotogo wok kunengyeng ngela logo ngerewalek sa wazamiyagi. ");
INSERT INTO big_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Togo tamizeige nak iniyegi pelik kai, Pakeli, Kilisibek Mesiya teni yaliya wazayiwekibek weik lewa. Pi mabelege yolubek, kai mabura piyegi ngizi kumuli nagani. Ma nakko iniyegi pelik kai, Pakeli, pi panga pulogo yolubek, kai mabura piyegi ngizi kumuli nagani. ");
INSERT INTO big_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Purik yombanuwili tabunda logo nak nak ngaigu pelik kisagi, Ne Kilisibek, neyegi kiriwei koli, kisagi. Keya nawilirau kanda ngaigu pelik kisagi, Anotogo teni wezayela logo tonugu ngago piyaga weiyara iniyegi kozak yeiweki, kisagi. Keya ini puwili Anotoyaga kayima nobiyeng mizibene keleyiweki puwiligu watabi Anotogo keke miziyeng mizi keya wirangai nayeng mizi nangai. Logo tamizeige puwili pangka kesak puwiligu yongkambanu Anotogo piyegi saweliweki iza puwiligi neyegi ngizi panu kumuli pura wiyibene keleyiweki mizi nangai. ");
INSERT INTO big_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tegi waberek panu. Nogo weik watabi piyeng ngoluk lewagela ono wizigeya kozak yei yagenda logo ini ngai panu koyizo. ");
INSERT INTO big_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Togo wok kuneng korowali yemane panu piyeng keya ngangang yemane panu piyeng lewagelagiyeng miza logo pulaga yokmek kusa sagi keya ngombek ngele managi ono. ");
INSERT INTO big_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Keya paka ngilumbekke watabi kozang piyeng urukang mizagi logo pelewewili paka ngilumbekka tiya walagi. ");
INSERT INTO big_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pulaga yongkambanuwiligu ne yombanu paka ngalega kayimabek ngereke kozainumbekke kozanda keya ngaiwak unatubarik kiling tabunda lewarikki pakelagi. ");
INSERT INTO big_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Togo nogo negi angelawiliyegi pelik yeiyagi, Ngabelak mabiyengki kunizo. Iniyaga nawili ngabelak panga yokmek lewagelayengki kunizo, keya nawili ngabelak panga yokmek kiliyayengki kunizo, keya nawili ngabelak paka yongoleigeyengki kunizo, keya nawili ngabelak pongo moleigeyengki kunizo, yeiyagi. Logo puwili kunagi logo yongkambanu Anotogo iza logo nogowili kaiya puwili wawere ula logo neyegi iza orowei lewaweki. ");
INSERT INTO big_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ini ngago saweliwei peragi iwaka sizo. Kusayeng kabeneng panu keya kilili keya kebarek yemane uli puwekke ini iwaka yokpek seliweki mereke mamizi. ");
INSERT INTO big_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kazing mabilikmekke inugu watabi nogo iniyegi kozak yeiya piyeng weik mizirikki pakeli puwekke purik mabura negi yogirik weik mereke panu mamizagi purik inugu iwakagi. ");
INSERT INTO big_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Wameik panu, yombanu ini Yudawiliyegi ngai mizi puwiligu ini mabuwili neneng ngeliweki lewagi kapura ini kemenak neneng ngelagi ono. Iniyagawili ngoluk yolugi logo nawiligu watabi nogo kozak yeiya peyeng mabiyeng ngizi lewagelarikki keriyagi. ");
INSERT INTO big_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ngilumbek keya ngabelakpek yeik sagi kapura ngago nogorarau yeik sagi ono, ngago nogora wizagomagi. ");
INSERT INTO big_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ne yogirik wok takka ma yokmek talikwekke miza purik nakko iwaka ono, keya Anotogi angela paka ngalege yoluwili mabilik iwaka ono, ma ne, Anotogi Marekpektau mabilik iwaka ono, Anoto negi Mangobek ngezebokko keke iwaka. ");
INSERT INTO big_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Keya inirau talikwekke ne yo lewagi miza purik iwaka ono legi waberek panu. Ngai yuke koyizo. ");
INSERT INTO big_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ne yogirik yombu koweige kambela logo yobok kelik yogi. Yombu nak i pugumak wizamiya logo koweige nalege kangweki mizi logo pugu were yombu piyegi yawe miziwiliyegi watabi puguyengki ngaiweki pangkara yana logo yaweyeng sanga miza logo nak nara keleya logo yawe mizi nakyegi kandikki ngai waberek wizeibene kozak meiya logo weik kambela. ");
INSERT INTO big_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Togo inuwarau pilik mizizo. Neyegi ngai yuke koyizo. Purik talikwekke ne ngereke yo lewagi miza purik inuwa lusuwei kani. Ne kepileige lewagi ma kusa libulibu lewagi ma winakwili ngago kisi puwekke lewagi ma wangane lewagi miza purik inuwa lusuwei, legi ne nguk namizi kanda inuwa neyegi kangkere mizi ono koyilege nelegi ngai yuke koyizo, logo ne kanda ne kangkere miza koyilege pakeliweki kani. ");
INSERT INTO big_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ngago nogo inuwayegi yei pura yongkambanu mabuwiliyegirau mabilik yei yagenda legi ini mabuwili ngai yuke koyizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wok neyau miza logo Yudawiligu wok Pasobabek meibek pakelagi. Wokpok ngeragi yemane miza nibek. Logo wokpokkorik Yudawili perek ngeragi yisriktau onoyeng keremiza logo nibek logo nageya koyimowei walaka Anotogo puwiligi yelibungang kokawiligi iyengki kangyengke iwirik pukmela wizilege keriya logo puwiligi koloyakamandik kalogoliwili ibengkirikka yaliya wazaya puragi kumulibek. Yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwili kazing ikuyogorik Yisu kebangkela logo ulagimekki weli. ");
INSERT INTO big_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Puwili pelik kela, Teni Yisu ngeragi yemane miza nagi puraga kebangkelagi ono, purik yongkambanuwili sisik miza logo teniyegi ngai mizane, kela. ");
INSERT INTO big_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Puwekke Yisu paka Petani yerengke yombu Saimon meibek kiling wiziya. Saimon ulogo kemegeme korikwek sok mizi Leposimek meimok mizabek kapura weik wazono. Yisu ngeragi nageya tawizeige yongok namele weli kelebak wazono kukngizi keli, king yemane wezamela nak kiling ige lewa. Pugu kelebakpekki kilimek sopela logo weli kukngizi kelibek Yisugi kebirage kubula. ");
INSERT INTO big_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pugu pilik miza kapura yombu pulogo koya nawili sisik panu miza logo nakko nakyegi pelik meiya yongomo miza, Weli kukngizi kelibek yeik ulak kubula melira nangki? ");
INSERT INTO big_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Purik tamizeige tonugu welibok yombu nakko weibene mana kesak king yemane panu weiya logo yongkambanu watabiyengki yeik puwili yani kak, kisa purik welibok kirisimasi naraga yawe mizi purikki ngane king weiya piyengki weiyagi langaibek logo puwiligu yongok yakamoloyegi ngalik meiya. ");
INSERT INTO big_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Puwili pilik kisa legi Yisugu puwiliyegi pelik yeiya, Pi yeik wizi pani. Inuwa piyegi kuneng manira nangki? Pi neyegi yombiyangai mizi keya wazono mizi miza wizinda. ");
INSERT INTO big_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Purik yongkambanu watabiyengki yeik pilikwili ini kiling wilibek yoluwili keya kang inugu keliraga ini puwiliyegi saweliweki wazono mizi nangine, kapura ne ini kiling wok mabiyeng yolugibek ono kopong inuwago wok mabiyeng neyegi keli inuwagira walimizageya koyimagi langai ono. ");
INSERT INTO big_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yongokmologo pangka mizagi langaiyeng pugu miza wizinda. Pugu were neyegi keli pugura walimiza. Togo pugu weli kukngizi kelibek negi ngalege kubula purikku korik nogowek kawiktikke waliyiweki kangkere keleni yagenda. ");
INSERT INTO big_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kerewiyi, ngabelakpek mabokko puwiligu Anotogi wazono neyegi langai pura kozak kisagi logo puwekke purik puwiligu yongok yakamologo wazono miza puragirau kozak kisagi logo yongkambanu puragi kerewiya puwiligu piyegi kumulibene, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Togo pulaga yombu meleyau keya pongo ingenazikka neyau Yisugu waligeleyiwiliyaga nak, Yuras Isaliyoto meibek, yombu Anotoyegi kolak miziwiligi ngaiwiliyegi kambela logo pelik yeiya, Nogo kazing Yisu mele inuguyengke miza yanagimekki weliweki mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yombu yaka puwili puragi kerewiya logo wilik miza logo puwiligu pi king managi sawiya. Togo Yuras weik kazing liwik Yisu yombu ulagi puwiliyegi mizi yanagi namekki weik welageya wiziya. ");
INSERT INTO big_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wok Yudawiligu perek ngeragi Yis meiriktau onoyeng keremiza logo nagibek weik lewagela. Wokpok i namakkiwiligu liyeng memeng marek namek ula logo ngeragi yemane miza nageya koyimowei Pasobaragi kumulibek. Yisugu waligeleyiwiligu piyegi pelik meiya, Teni talege kangki keya i takkimakke ngeragi nugu Pasobaragi kumuliweki nagiyeng ngayek mizagi keli, meiya. ");
INSERT INTO big_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Togo Yisugu waligeleyiwiliyaga neyau ngago pelik yeiya logo wezayela, Yali paka Yirusalem yerendage kiliya kunizo. Keya yombu kaimi narage kai nak kola warabek yaligu paka kazingke yoromaure mizagi kani. ");
INSERT INTO big_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Piyegi kiriwei kunizo, i pugu kiliya kang pumakke yalirau kiriwei lizo, logo imakki mangobekyegi pelik meizo, Kiriwagabokko kaira, Ne kiling yombu nogo waligeleyiwili ngeragi Pasobaragi kumuliweki ngeragi nagimak tamak, meizo. ");
INSERT INTO big_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pulaga pugu yaliyegi yeke ngalege i kawegawe watabi Pasobara ngayek miziweki weiyagi pilik piyeng waligeleyi penanging kani. Pulogo yali ngeragi tonuguyeng ngayek mizizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Togo piyau kambela logo yerengke lewagela logo watabi mabiyeng Yisugu yaka piyauyegi kozak yeiya mabilik miza wizilege piyau weik i pumakke ngeragi Pasobaragi kumuliweki nagiyeng ngayek miza wiya. ");
INSERT INTO big_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pilik miza logo yokmek kiliya pura Yisu kiling yombu meleyau keya pongo ingenazikka neyau pi ngezebokko waligeleyiwili weik i pumakke kanda ");
INSERT INTO big_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","logo lalektaga mogosa logo ngeragi nageya koyimowei Yisugu puwiliyegi pelik yeiya, Wameik, inuwayaga nakko ne panga yombanu nelagiwiliyegi niza yanagi. Pok ne kiling ngeragi nibek. ");
INSERT INTO big_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yisugu pilik yeiya logo pugu waligeleyiwili ngago puragi kerewiya logo weik ya kuneng logo nak nak piyegi nguk mei kuna, Nogo ma talik, mei kuna. ");
INSERT INTO big_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Togo Yisugu puwiliyegi pelik yeiya, Inuwa meleyau keya pongo ingenazikka neyau ne makngezogo waligeleyiwiliyaga nakko, yombu ne kiling pereksik peleng ngeragi kolokpek kilingwekke yenge yungke pukmelibokko. ");
INSERT INTO big_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ei, wameik panu, ne yombanu paka ngalega kayimabek ibengki Anotogi Kapiya Walektikku kaiyalik, kapura yombu ne yombanu nelagiwiliyegi niza yanagibekyegi yalek unatuba keli, purik Anotogo pi ngangang yemane panu managi. Yombubokki panumologo pi wazamiya ono kesak piyegi yombiyangai panu, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Puwili ngeragiyeng nageya koyigeya Yisugu pereksik weiya logo Anotoyegi wazono meiya logo sikila logo puwili yanageya wizimowei pelik yeiya, Ya, weiya logo ni. Pobuzikku walimizi purik korik nogowekki walimizi yagenda. Pilik yeiya logo puwili puzik na. ");
INSERT INTO big_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pulaga Yisu kai waing kakpek weiya logo Anotoyegi wazono meiya logo yombu pugu waligeleyiwili yana logo puwili mabuwili kakpokka na. ");
INSERT INTO big_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Pugu puwiliyegi pelik yeiya, Kai waing kak pobokko walimizi purik iwi nogobekki walimizi yagenda. Pokko walimizi purik Anotogo yongkambanu kolokngagonowili kemenak ibengkiraga yaliya wazayagi puragi langai ngago wik silok tiya pura ngelagi ono, kapura negi iwi kubula walagibokko kozang kelemiyagi. ");
INSERT INTO big_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kerewiyi, wameik panu nogo mawinda waimbek nagi ono wiziya kazing wikmekke yereng Anotogo pigi ngaimekki ngai purage ne ngereke nagine, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pulaga puwili Anotoyegi Ingi Sam narik ingi meiya logo pulaga puwili imakka welagelarik lewak Olip meibekke kambela. ");
INSERT INTO big_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Keya puwili lewak Olip meibekke kunimowei Yisugu puwiliyegi pelik yeiya, Anotogi Kapiya Walektikke yungke pelik kai, Anoto ngezebokko liyeng memengwiliyegi ngaibek ulagi logo liyeng memengwili kazi luwa ula melagi, kai. Togo mabek kusarikke ngago pura ngizi mizagi, purik inuwa mabuwiligu neyegi ngizi kumuli pura kawiye walagi logo inuwa kazi kunagi. ");
INSERT INTO big_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kapura ne ngereke wik yangalek meiya logo pulaga purik ne were ngabelak Kalili meibekke kangki keya inuwa kalika lewagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pitago piyegi pelik meiya to mela, Puwili mabuwili kele ni wezani kunagi kapura nogo niyegi ngizi panu kumula pura kawiye walagi ono logo nerau ni wezani kunagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pilik kai legi Yisugu Pitayegi pelik meiya, Kerewiye, nogo wameik panura kozak nei, mabek kusage winak talekmek kang neyau kaiyagine ni were kang neyauganara yeik nogora liwik wiyagi logo ni neyegi lusuwei panu kaiyagi kani, meiya. ");
INSERT INTO big_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kapura Pitago mawinda kozang pelik meiya to mela, A’a’, puwiligu nerau nelagi puriktau ngoluk ne niyegi lusuwei kaiyagi ono, meiya. Keya Yisugu waligeleyi nawiligurau mabilik kisa. ");
INSERT INTO big_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pulaga puwili Lewak Olippekke yawe Kesemani meileige wiriya logo Yisugu yombu pugu waligeleyiwiliyegi pelik yeiya, Pelege mogosa koyi ne pangazuwa nangezi Anotoyegi waberek mizigeya, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Togo yombu pi ngezebokko waligeleyiwiliyaga neyauganak Pita keya Jems keya Yowan iza orowei kuna, logo Yisu weik wilek kang pugubek kuneng yemane panu keli. ");
INSERT INTO big_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tegi pugu puwiliyegi pelik yeiya, Wilek kang nogobek kuneng panu logo ne ibengki langai pilikmekki keli mena, inuwa mabelega koyimowei wirere ngai yuke koyi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pilik yeiya logo pi panga keke nangezi kuna logo pulogo ngezebek panga ngabelakke ulu wala logo Anotoyegi pelik waberek miza, Tamizeige pangka purik nugu neyegi ngangang wiriyagi pura yeik sa wazamiye. ");
INSERT INTO big_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Peba, O Peba nogobek, nugu watabi mabiyeng pangka mizagi legi nugu neyegi ngangang wiriyagi pura keya ibengki pura yeik sa wazamiye kapura keli nogoraga mizi nagani, pilik segeya keli ni makngezegiragi kiriwei mizimo, meiya. ");
INSERT INTO big_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pilik waberek miza logo Yisu yangalek meiya logo pi yombu pugu waligeleyi neyauganakwiliyegi to kuna logo morok iwek koyilege pakela logo Pitayegi pelik meiya, Simong Pita ni iwek kola yolura nangki? Ni tek nangezi wirere wiziya logo ngai yuke wiziwekirik pangka ono ma? ");
INSERT INTO big_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Wirere ngai koyimowei waberek mizizo. Inuwayegi yang keleyiweki lewagi piyengko inuwa kawiye walibene keleya nelegi waberek mizizo. Wameik panu, wilek kang inuwagiyengko mizagi keli kapura korik inuwagiyeng kozang ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Togo pi ngereke panga keke kuna logo yaka were nguk meiya mabilik waberek miza. ");
INSERT INTO big_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pilik miza logo pi panga ngezebokko waligeleyiwiliyegi to kuna kapura puwili iwek koyilege purik puwili wireyeng kuneng panu kopong iwek kola logo ngago talikta piyegi meiyagi miza pura puwili iwaka ono legi puwili kendek miza. ");
INSERT INTO big_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Togo Yisu kuna logo kang neyauganara mabilik miza logo yowekke puwili iwek kola koyilege legi pugu puwiliyegi pelik yeiya, Inuwa ngoluk iwek kola keya ngoluk mabilik kumana yolu. Weik mena luweza koyi. Teng pugu ne yombanu paka ngalega kayimabek yombanu kailewiligi meleyengke niza yanagira weik lewa. ");
INSERT INTO big_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pakeli, yombanu ne nelagiwiliyegi niza yanagibek pelege weik lewa. Luwezi, tonuwa piyegi kambi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yisu ngoluk ngago kaiyageya wizigeya Yuras yombu meleyau keya pongo ingenazikka neyau Yisu ngezebokko waligeleyiwiliyagabok nguk namizi wiriya. Pi kiling yombanu kolokngagono lang keya kilikkilikyeng orowei lewa logo puwili Yudawiligi yemanewili keya yombu Anotoyegi wata kolak kelibene waliya maniwiligi ngaiwili keya Mosegi loyengki waligeleyiwiligu wezayelawili. ");
INSERT INTO big_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yombu Yisu miza yanagibokko yombanu lang keya kilikkilikyeng warawiliyegi yaka pelik yeiya, Yombanu nogo negi kewengke wezalikpek songok kulibok, Yisu kani. Inugu pi kebangkeli kapura waberek panu miza orowei piyegi ngai kunizo, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Togo Yuras lewagelawekke, pi Yisuyegi nguk namizi wiriya logo pelik meiya, Kiriwagabek, meiya logo Yisu songok kula logo ");
INSERT INTO big_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","puwili Yisu kozang panu kebangkela. ");
INSERT INTO big_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pilik miza logo Yisu kilingwiliyaga mereke luweza nakko lang yokolong puguwek pugusa logo yombu Anotoyegi kolak miziwiligi ngai yemane panubekyegi yawe mizibek ula logo pigi kerelik namek peto ula mela. ");
INSERT INTO big_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Pulaga Yisugu yombanu kolokngagonowiliyegi pelik yeiya, Ini mabektik ne yombanu ngowei wezalikpekyegi lang keya kilikkilikyeng kiling ne niza wari yawerenda. ");
INSERT INTO big_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wok mabiyeng ne ini kiling Anotogi i walek yemanemakke wizimowei yongkambanuwiliyegi waligeleya kapura inugu ne kebangkeliweki miza ono. Kapura Anotogi ngago Kapiya Walek pugurikke neyegi langai lende miza pura ngizi panu lewagela wali pani, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pilik mizageya keya Yisugu waligeleyiwili mabuwili pi wezamiya logo kazi wei kambela. ");
INSERT INTO big_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Yombu nawekke nak, kagorik narik keke waliyabek Yisuyegi kalika kiriwei kuna. Logo puwili pirau kebangkela ");
INSERT INTO big_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kapura pi kagoriktik wizamiya logo komozilik kazi kambela. ");
INSERT INTO big_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Togo yombanu yaka kolokngagono puwiligu Yisu kebangkela logo pi miza orowei yombu Anotoyegi kolak miziwiligi ngai yemane panubekki imakki kuna. Pulogo Yudawiligi yemanewili keya yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwilirau menalege pulogo wawere ula. ");
INSERT INTO big_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Logo Pita ngereke yorik Yisuyegi kalika koweige kiriwei kuna. Pi yaka ngai yemane panubokki imakke yerengke kanda kiliya yabela logo pulogo pi wagelawili kiling mogosa logo yezimele sageya wiziya. ");
INSERT INTO big_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Weik yombu Anotoyegi kolak miziwiligi ngai puwili keya Yudawiligi yombu ngagozak ngezewiligiyeng kerewiyiwili mabuwili watabi Yisugu mizayengki yombanu nawiligu kozak kisibene ngago yeiya. Puwili ngago Yisugu kaile miza naragi kerewiyagi keli logo Yisu ula logo ibengwekiragi yolok ngeliweki, kapura puwiligu nayeng kerewiya ono. ");
INSERT INTO big_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Purik yombu kolokngagonowili Yisuyegi langai ngaiguyeng kozak kisa kele kapura nak nalikta kozak kai keya nak nalikta kozak kai, logo ngago wamenara ono, ngago kolokngagono. ");
INSERT INTO big_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Togo yombu nawili luweza logo Yisuyegi langai ngago ngaigu pera pelik kisa, ");
INSERT INTO big_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Teni ulogo kerewiyawekkerik pugu pelik kai, Nogo Anotogi i walek yombanuwiligu ngiza pemak topelagi logo wok neyauganakke nogo i nalik namak ngizagi, kaiyabek, kisa. ");
INSERT INTO big_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kapura yaka ngago purarau kisa puwiligu kozak kisira wamenara ono, nak nalikta kozak kai keya nak nalikta kozak kai. ");
INSERT INTO big_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Togo yombu Anotoyegi kolak miziwiligi ngai yemane panubek puwili mabuwiligi tepekke luweza logo Yisuyegi pelik nguk meiya, Ni nararau kozak kaiya yo meli onora nangki? Kolokngagonowiligu niyegi ngagoyeng yowa logo ni kerewiya. Puwiligu wameik kisi ma yeik? Nugu weik kai logo teni kerewiyiweki, meiya. ");
INSERT INTO big_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kapura Yisu ngagoluk wiziya pi ngago nararau kaiya ono. Ngereke yombu Anotoyegi kolak miziwiligi ngai yemane panubokko piyegi pelik nguk meiya, Ni Kilisibek Mesiya Anotogo yawe pigi teni yaliya wazayagi pura miziweki sawiyabek ma talik? Ni Anoto tonugu yeikta yongolok meibokki Marekpek ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Legi Yisugu pelik meiya to mela, Ei, ne pi. Keya ne yombanu paka ngalega kayimabek ngereke paka ngalegi yongorik Anoto watabi mabiyengki kozandagi mangobekki ngaigezuwage mogosa yolugi logo pi kiling ngaiweki. Keya kalike inugu ne ngereke paka ngalege kozainumbekka tabunda lewarikki pakelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pulaga yombu Anotoyegi kolak miziwiligi ngai yemane panubek pura kerewiyawekke pi sisik panu miza logo Yisugu yaka kai puragi kiyebuk legi walimiziweki melewangka ngezebekkirik koliya. Logo pugu yombu ngagozak piyengki kerewiyawiliyegi pelik yeiya, Teni makngezogo weik kili ngezebekki panurago kairikki kerewiya legi teni ngereke ngago nararau kerewiyagi ono. Legi teni mawinda yombu piyegi ngagozak kelemiyagiwiliyegirau ngago yeiyagi ono, a’a’. ");
INSERT INTO big_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pugu pi Anoto kiling pangka pangka kairikki inuwa weik kerewiya mena inugu piyegi kumulagirik talik, yeiya logo puwili mabuwiligu mele puwiligiyeng piyegi mizara koyimowei pelik kisa, Pi Anoto kiling pangka pangka kai legi pi weik ula logo ibengkibek, kisa. ");
INSERT INTO big_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Togo nawiligu weik Yisu sibilak ngiza mana logo puwiligu wiregawere pugura kagorik walerikku ngokmana logo melegozok ulageya koyimowei pelik meiya, Nugu ni Anotoyaga ngagoyeng weiya logo kozak kaibek kai mena takko ni melegozok nela miza purik kozak kai logo tonugu ni wameik Anotoyaga ngagoyeng weiya logo kozak kaibek miziweki mena, meiya. Pulaga wagelawili pi uli kunimowei miza orowei kuna. ");
INSERT INTO big_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pilik mizageya keya Pita ngoluk imakke pongo yerengke yezizikke mogosa tawizeige pura kolomandik Anotoyegi kolak miziwiligi ngai yemane panubekyegi yawe mizi namele lewa ");
INSERT INTO big_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","logo pugu Pita yezimele sageya wizilege pakela logo pugu piyegi pakela wizimowei pelik meiya, Wameik panu, nirau Yisu yereng Nasareteragabek kiling wiziyabek kani, meiya. ");
INSERT INTO big_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kapura Pitago ngaigu, A’a’, ne piyegi lusuwei. Nugu kozak kai piyeng nogo iwaka ono, meiya logo pi pongo yezizik wiya logo yerendikki kandikke mereke kuna. Pilik mizi ngizige winak talekmek kai. ");
INSERT INTO big_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pulaga kolomandik yawe mizimologo Pita ngereke pakela logo yaka kaiya mabilik yombanu pulogo mereke luwe koyilegewiliyegi pelik kozak yeiya, Yombubok Yisugi yombanuwiliyaga nak kani, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kapura Pitago ngereke ngaigu, A’a’, meiya. Keya songono nangezi wiziya logo ngereke yombanu pulogo mereke luwe koyilegewiliyaga nawiligu Pitayegi pelik meiya, Wameik panu, nirau Yisugi yombanuwiliyaga nak, purik ngago nugurago ni pongo ngabelak Kalili meibekkabek mizi kani, meiya. ");
INSERT INTO big_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tegi Pitago pelik yeiya, Anotogi wirege ne wameik panu kai. Yombanu inuwago kozak kisibokyegi ne lusuwei. Tamizeige ne ngaigu kai purik mabura Anotogo neyegi ngangang naniweki, yeiya. ");
INSERT INTO big_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Togo Pitago pilik yei ngizige winak talekmek ngereke ngago kai. Mabuwekke Pita weik ulogo Yisugu piyegi pelik meiya, Winak talekmek kang neyau kaiyagine ni were kang neyauganara neyegi lusuwei kaiyagi kani, meiyaragi kumula logo pi kuneng yemane miza logo ingkeiya. ");
INSERT INTO big_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wangkoti pura Yudawiligi yemanewili kiling yombu Anotoyegi wata kolak kelibene miziwiligi ngaiwili keya yombu Mosegi loyengki waligeleyiwili keya yombu ngezewiliyaga ngagozakyengki kerewiyi puwili mabuwili ngago kozak kela. Pulaga puwili Yisu wigira logo pi miza oroweirik yombu ngabelak Yudaya meibekki Rom Kapman ngaibek Pailet meibekyegi miza mana. ");
INSERT INTO big_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Togo Pailetgu Yisuyegi pelik nguk meiya, Ni Yudawiligi King Ngaibek ma yeik, meiya. Tegi Yisugu pelik meiya to mela, Ni makngezogo kai mabura, meiya. ");
INSERT INTO big_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Togo yombu Anotoyegi kolak miziwiligi ngaiwiligu ngago kolokngagonoyeng piyegi yowa. ");
INSERT INTO big_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Keya Pailetgu mazenda piyegi pelik nguk meiya, Ni ngago nara kaiya yo meli onora nangki? Puwiligu niyegi ngago kolokngagonoyeng yowirikki kerewiye, meiya. ");
INSERT INTO big_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kapura Yisu mawinda ngago kaiyagirikki kiyebuk legi Pailet piyegi lelengkira. ");
INSERT INTO big_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Togo kirisimasi mabiyeng wok Pasoba meibek puwili pakeli puwekke Pailetgu yombanu wigirawiliyaga puwiligu keli nak wila wazami mizi. ");
INSERT INTO big_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Logo wokpokko yombanu ulogo Romwiligi Kapman ngaiwiliyegi ngai miza logo yombanu nak ula logo ibendikki wiyeke wigira wazayawiliyaga nak Parabas mei. ");
INSERT INTO big_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Togo yongkambanuwili wawere ula logo Pailetyegi nguk meiya pugu kazing puwiligu mizimekke kiriwei mizibene logo yombu wigira nak wila wazamibene. ");
INSERT INTO big_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Logo Pailetgu pelik kumula, Yombu Anotoyegi kolak miziwiligi ngai puwili yongkambanuwili mabuwili Yisuyegi kiriwei mizi purikki yagolok kopong puwiligu neyegi Yisu miza orowei wiriya wizinda miza. Togo Pailetgu puwiliyegi pelik nguk yeiya, Inugu kelirik talik? Ne ini Yudawiligi King Ngaibek iniyegi wila wazamiyagi keli ma, yeiya. ");
INSERT INTO big_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kapura yombu Anotoyegi kolak miziwiligi ngaiwiligu yongkambanuwiligi wilek kangyeng kowita wazaya logo puwiligu pelik kisa, Pi wila wazami nagani, segeya yombu Parabas meibok kele wila wazame, kisa. ");
INSERT INTO big_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pulaga Pailetgu yongkambanuwiliyegi mazenda pelik nguk yeiya, Tamizeige keli inugura pilik purik mabura yombu inugu teni Yudawiligi King Ngaibek meibokyegi nogo talik mizagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Togo yongkambanuwiligu ngereke pelik kek kisa, Pi yengeleileige nili ule, kisa. ");
INSERT INTO big_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tegi Pailetgu puwiliyegi pelik yeiya, Pi nangki uliweki, pugu korowali talikyeng miza, yeiya. Kapura yongkambanuwiligu ngoluk mazeng keya ngalizi panu pelik kek kisa, Pi yengeleileige nili ule, kisa. ");
INSERT INTO big_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Togo yongkambanuwili wilik mizibene Pailetgu Parabas wila wazamiya logo Yisu ulagi purik pangka kelemiya. Togo pugu ami nawiliyegi Yisu were pikang yemane ngai kozang piyengko wizale ula logo puwiligu pi yengeleileige nili ulibene kozak yeiya. ");
INSERT INTO big_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Keya pulaga weik Rom Ami nawiligu Yisu miza orowei Rom Kapmanwiligi ngai yemanebekki imakke kiliya kuna logo puwiligu ami mabuwiliyegi ngago yeiya. ");
INSERT INTO big_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Puwili kanda pulogo puwiligu Yisu melewangka King Ngaiwiligu wakiyi langai wago yokolong narik wakiya wazamiya keya puwiligu mabung ingakmerek kilulung wezabek keremiza logo Yisugi kebiraga ngalege wiya logo ngaigu pi King Ngaibek miziweki. ");
INSERT INTO big_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pulaga puwiligu piyegi pelik meiya, Aiya, ni wik yokolong yoluweki, ni Yudawiligi King Ngai Yemizibek. ");
INSERT INTO big_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pilik kisa logo puwiligu Yisu kebirage wirembokko ula keya piyegi sibilak ngiza mani keya puwiligu ingegereyeng laliya logo ngaigu yeik pugura yongolok meiweki. ");
INSERT INTO big_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Logo puwiligu piyegi yang meiya logo pulaga melewangka wagorik pugusa mowiya logo ngezebekkiyeng ngereke wakiya wazamiya. Pulaga weik puwiligu Yisu yengeleileige nili uliweki miza orowei kuna. ");
INSERT INTO big_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Puwili tagoneige pura kazingmekke yombu Saimon yereng Sairini meiragabek logo Yirusalem yerengke yolubek logo Alesenda keya Lupa meiyaugi mangobek paka yawega lewa logo paka Yirusalem yerengki kuniweki wizilege. Amiwiligu pi kebangkela logo Yisugi yengeleilei wagela wazamiya. ");
INSERT INTO big_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Togo puwiligu Yisu miza orowei kuna, weik kanda ngabelak wale yeikta Kologata meirikke logo yeiktago kai purik kebi kozarik kai yagenda. ");
INSERT INTO big_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Keya pulogo kandawekke puwili kai waing keya marasing ngelaming miza logo pi ngangang yemane panu kela nelegi nibene mana kapura Yisu na ono. ");
INSERT INTO big_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Togo Rom Amiwiligu Kologata pulogo Yisu yengeleileigi ngalege nili ula logo yengeleilei luwe lewamiya. Pilik miza logo amiwili takko Yisugi kagorikyeng weiyagi miza legi puwili yengelei lek uli. ");
INSERT INTO big_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yokmek melenazik keya nazikka mangobektau onowekke wangane puwiligu Yisu yengeleileige nili ula. ");
INSERT INTO big_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Keya ngago lang pugu watabi kokowa miza piyengkiyeng paka pigi ngalege pelang korokwekke pelik lende miza, Pek Yudawiligi King Ngaibek, miza. ");
INSERT INTO big_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Togo Rom Amiwiligu yombanu kazing kaile watabiyeng ngoweimekke miza logo wigira wazayayaurau yengeleiyauge nili ula logo nak Yisugi mele ngaigezuwagezikke wazami keya nak pigi mele koranengkezikke wazami miza. ");
INSERT INTO big_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Pilik miza pura Isayago Anotogi Kapiya Walektikke pobilik kaiya puragi kiriwei, Puwiligu pi yombanu kaile miziwiliyaga nak mena miza, ");
INSERT INTO big_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Togo yongkambanu mereke kang yongomo miziwiligu piyegi yang meiya logo Yisuyegi kebi puwiligiyeng ngulang kelemi mizageya koyimowei pelik meiya, Aiya, ni Anotogi i walek yemanemak topela logo wok neyauganak piyengke ngereke i pumak ngizagi kaiyabek purik, ");
INSERT INTO big_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mabura purikku kozandago ni makngezogo ni makngeze yaliya wazame keya yengeleileiga yo kule, meiya. ");
INSERT INTO big_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kazing mabilikmekke yombu Anotoyegi kolak miziwiligi ngaiwili kiling Mosegi loyengki waligeleyiwiligurau ngezewili nakko nakyegi pelik mei yongomo mizi, Pi nawili ibendaga pangka yaliya wazaya kapura pi ngezebek pangka yaliya wazamiyagi ono. ");
INSERT INTO big_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Pugu pelik kai, Ne Kilisibek, Isileiliwiligi King Ngaibek, kai legi tamizeige pi yengeleileiga yo kula purik mabura teni pakelagi logo teni pugu kai pura wameik purikki ngizi panu kumulagi, mei. Keya yombu yaka Yisu kiling yengeleiyauge nili ula piyaugurau Yisuyegi mabilik ngago kaile meiya. ");
INSERT INTO big_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yokmek weik paka ngilumbekke libuge 12 kilok si ngizige yokmek kusa logo ngabelakpek mabok weik kusa logo wiziya yokmek panga luwege neyauganakwekke yokmek ngereke ngaiwila. ");
INSERT INTO big_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Togo yokmek panga luwege neyauganakwekke Yisu ngezebekki ngago yeiktage ngalizi pelik kek kaiya, Eli, Eli, lama sabatani. Ngago lang purik pelik kai yagenda, Anoto nogobek, Anoto nogobek, ni ne wezanira nangki, kai yagenda. ");
INSERT INTO big_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yombanu mereke koya nawiligu pugu pilik kairagi kerewiya logo pelik kisa, Kerewiyi, pi Ilayayegi ngago mei kani, kisa. ");
INSERT INTO big_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Togo puwili wiyalowei miza logo puwiliyaga nak nginda kambela logo kapuk wezarik narik ngo nakke mela logo purik kai waing walekpekke yungke mela logo Yisu nibene manageya wizimowei pugu pelik yeiya, Yek yuke, Ilaya kanda Yisu yengeleileiga pugusiyaga ma yeik miza purikki pakelagine, yeiya. ");
INSERT INTO big_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Togo Yisu ngalizi kek kaiya logo weik ibeng. ");
INSERT INTO big_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Togo pulaga kagorik Anotogi i walek yemanemakke ngalege wiramiyarik paka ngalega pongo ngabelakke libuga koliyara narik narik miza. ");
INSERT INTO big_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Togo yombu amiwiliyegi ngaibek Yisuyegi mereke pulogo luwe wiziyabokko Yisu ibendikki pakela logo pelik kaiya, Wameik panu yombu pobok Anotogi Marek panubek, kaiya. ");
INSERT INTO big_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Yongok nawilirau pulogo tek nangezi koweiga pakela koya. Puwiliyaga namele Maliya Matalena keya namele Maliya, Yosisi keya pigi sakpek Jemsgi panumele, keya namele Salomo keya yongok kolokngagono nawilirau. ");
INSERT INTO big_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Puwili koka Yisu kiling pongo Kalili koyawili logo Yisuyegi paka Yirusalem kiriwei saweli keya kelemi kayimawili. ");
INSERT INTO big_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Pilik mizarik wok melenazikpekke logo wokpok Yudawili watabi puwiligi wok yawe mizi onobek meibekkiyeng ngayek mizibek. Logo yokmek kiliyagi merekewekke yombanu Yosep mei yereng Arimatiya meiragabek Pailetyegi kuna. Yosep, pi yeik wazonora kilimbek keya pi yombu ngagozakyengki kerewiyiwiliyaga nak, pi teng Anotogo pigi ngaimekki ngaigi puragi yuke yolubek. Pugu kumularik wok Sabatpek yawe mizi onobek weik mereke legi pi Yisugi yasurik wawiya logo waliyiweki miza. Togo pi kozang sa logo panga Pailetyegi kanda luweza wizimowei Yisugi yasurik wawiyiweki meiya. ");
INSERT INTO big_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailet Yisu weik ibendikki kerewiyawekke pi kumula mela logo pugu pigi amiwiligi ngaibekyegi ngago meiya logo pelik meiya, Yisu yaka ibeng ma ngoluk, meiya. ");
INSERT INTO big_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ngaibokko yaka ibendikki kozak meiya to mela logo Pailetgu Yosepyegi pelik meiya, Yisugi yasurik wawiyi purik pangka, meiya. ");
INSERT INTO big_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Togo Yosep kagorik wilangka wazono narik weiya logo pi Yisugi yasurik orowei yerageya logo kagoriktikku sape miza logo mosindaga king ururu yombanu waliyiweki keremiza namekke wiya. Togo Yosep kilingwiligu king yemane panu nara ulumowei kanda Yisugi londagi kandikke waliya wazamiya. ");
INSERT INTO big_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya Matalena keya Maliya, Yosisigi panumele Yosepgu Yisugi yasurik pulogo wiya wazamirikki piyaugu pakela. ");
INSERT INTO big_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Wok Sabatpek meibek miza logo waleleige Maliya Matalena kiling Maliya Jemsgi panumele keya namele Salomo meimele weli keya watabi pulangai kukngizi keliyeng weiya logo Yisugi yasurikki weli meliweki kuna. ");
INSERT INTO big_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Togo Sonda wangane panubekke yokmek lewagelageya keya yongokwili weik Yisugi londagi kuna. ");
INSERT INTO big_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Puwili kang kunimowei namologo nameleyegi pelik meiya, Takko tonuwayegi sawela logo king yemane panu kandikke waliyabek yomizora wezamelagi logo kandik tiyiweki, kela. ");
INSERT INTO big_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Togo puwili pakeliraige pura king yemane panu ulogo kandikke waliyabek weik yomizora wezamela wizilege. ");
INSERT INTO big_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Togo puwili yeke ige kiliya yabela logo pulogo puwiligu yombu nawekke melewangka wilangka yokolondik wakiya nak king ururumekki wale ngaigezuwagarikke mogosa wizilege pakela logo puwili kazi miza. ");
INSERT INTO big_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Togo pugu puwiliyegi pelik yeiya, Inuwa kazi mizi wak. Inuwa Yisu yereng Nasareteragabek puwiligu yengeleileige nili ulabokyegi weli purik ne iwaka. Kapura pi pelege yolu ono, pi yaka yangalekta kani. Pakeli, pelege puwiligu pi ulogo wiya wazamiya kapura pi weik yangalekta. ");
INSERT INTO big_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Togo inuwa kambeli, logo Pita kiling pugu waligeleyawiliyegi ngago peragi pelik kozak yei mizizo, Pi were ngabelak Kalili meibekke kangki logo pulogo inugu piyegi pakeliweki koka pugu kozak yeiya pilik, yeiya. ");
INSERT INTO big_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pilik kai legi puwili welagela kanda lebuk keya wiyalowei kopong puwili londaga nginda kambela. Togo puwiligu nawiliyegirau kozak yeiya ono purik puwili kulilimokko pangka ono kopong. ");
INSERT INTO big_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Togo Yisu Sonda wangane panubekke yangalek meiya logo waleleige pi Maliya Matalena koka pugu kerewa melenazik keya nazikka neyauwili welagela wezayelameleyegi were tabunda. ");
INSERT INTO big_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliya kambela logo yombanu Yisu kiling ulogo yongomo mizawili ingkeya ngabik miza koyilegewiliyegi watabi lewagela piyengki kozak yeiya. ");
INSERT INTO big_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maliyago puwiliyegi pelik kozak yeiya, Yisu ngereke wik wizilege nogo piyegi pakela, yeiya kapura puwili piyegi ngizi kumula ono. ");
INSERT INTO big_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Keya pulaga yombu puwiliyaga neyau yereng naragi kangweki tagoneige Yisu korikwek nalik sa logo piyauyegi tabunda. ");
INSERT INTO big_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Togo piyau kang yongobela logo nawiliyegi watabi lewagela piyengki kozak yeiya kapura puwili ngago puragirau ngizi panu kumula ono. ");
INSERT INTO big_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Piyeng mabiyeng miza logo kang narage yombu meleyau keya pongo ingenazikka nak pugu waligeleyawili mogosara ngeragi nageya tagogei Yisu puwiliyegi tabunda logo puwiliyegi pelik ngalik yeiya, Ini neyegi ngizi panu kumuli onora nangki? Kangka inuguyeng yeik kani. Ne yangalek meiya logo nawiligu neyegi pakela logo iniyegi kozak yeiya kapura inugu puwiliyegi ngizi panu kumuli ono, yeiya. ");
INSERT INTO big_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Togo pugu ngago yeke langakta pelik yeiya, Inugu yongkambanu ngabelakpek mabokkowili mabuwiliyegi Anotogi ngago wazono neyegi langai pura kozak yeiweki kambelizo. ");
INSERT INTO big_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Keya tamizeige yombanu nak ngago puragi kerewiya logo neyegi ngizi panu kumuli logo kaimelibok Anotogo ibeng wizagomagiraga yaliya wazamiyagi logo wik wizagomagira managi, kapura tamizeige yombanu nak ngago puragi kerewiya logo neyegi ngizi panu kumuli ono keya neyegi kezanga nani purik mabura ne pilikpok ngagozak kelemiyagi keya ngagoyeng piyegi yowa logo Anotogo yereng yezi kusagi onozik ngori purage wezamela logo pulogo pi wizagomagi. ");
INSERT INTO big_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Togo neyegi ngizi panu kumuli puwiligu Anotogi kozandago watabi Anotogo keke mizi piyeng miziweki pangka mizagi. Piyeng pelik, puwili yeik nogorage kerewawili yongkambanuwiliyaga welagela wezayelagi, keya puwili ngago yeik puwiligu lusuwei nayeng kisagi, ");
INSERT INTO big_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","keya tamizeige puwili kemalewili mele puwiligiyengko kebangkelagi mabura puwili ibengki ono, ma tamizeige puwili kai walek yombu ulagi pilikyeng ni mabura puwili ibengki ono, keya puwiligu mele puwiligiyengko kemegemewiliyegi walami puwekke purik, kemegemewili yombiyangai sagi, yeiya. ");
INSERT INTO big_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Keya pulaga Yemizi Yisugu puwiliyegi ngago pura kozak yeiya logo pulaga, Anotogo pi miza orowei paka ngalege kang yongo logo Anotogi mele ngaigezikke pi kiling ngaiweki mogosa yolu. ");
INSERT INTO big_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Togo pugu waligeleyawiligu yereng mabiyengke ngago Yisuyegi langai pura yongkambanuwiliyegi kozak yei miza. Keya ngagora ngizira miziweki Yemizibokko puwili kozanda yana logo puwili watabi Anotogo keke miziyeng miza. Togo yongkambanu piyengki pakelawiligu pelik kisa, Ngago pura wameik ngizi panu, kisa. Togo ngago pera yombu Mak meibokko lende mizara logo weik pulogo yeik. ");
INSERT INTO big_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Ei, yemanebek Tiyopila, yombu nawili watabi Yisugu miza piyeng mabiyeng wawara logo lende miziweki miza purik ni iwaka legi ne, Lukarau, niyegi lende mizi purik wazono. Puwiligu lende mizarik watabi ngizi lewagelayeng wire ngezewiligiyengko pakela pilikwiligu solo panu pakelawekke kozak kisa piyeng lende miza. Togo nogo lende mizi perik nogo piyeng koka solo panuwekkerikka waberek panu pakeliwei miza kopong ne mabiyeng pangka pangka miza logo niyegi lende miza nani. Nogo niyegi pilik mizi purik watabi puwiligu niyegi kozak neiya piyeng wameik ngizi panuyeng purikki ni iwakaweki. ");
INSERT INTO big_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ngago wameik panu pura pelik. King Ngai Elodogo ngabelak Yudaya meibekke ngaiwekkerik yombu yeikta Sakaraya meibek wizagoma. Pi yombu Abaisa meibekki ngaimekka Anotogi i walek yemanemakke yawe yongkambanuwiligi yeiktaga Anotoyegi wata kolak kelibene waliya mani pura mizi nak. Sakarayagi yongokpumelegi yeikta Ilisapete. Pi yongok Along yawe Anotoyegi kolak mizi pura solo panu mizabekki yeligagangmekka namele. ");
INSERT INTO big_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakaraya keya Ilisapete mabiyau Anotogi wirege pangka panu yoluyau keya Anotogi lo Mosego lende miza piyeng mabiyeng keya pugu yongkambanu puguwiliyegi miziweki kozak yei mabiyengki kiriwei miziyau. ");
INSERT INTO big_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Keya Ilisapete kabilimele kopong piyau koloyakamandik nawilirau ono keya piyau mabiyau yongkambusi panuyau. ");
INSERT INTO big_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Togo Abaisagi ngaimekkawiligu yawe mizagirik weik lewa logo puwili Anotogi i walek yemanemakki yawe miziwili ngezewiligu kazing mizimekke yawera sanga miza logo Sakaraya pi yawe Anotogi i walek yemanemakke alatarage Anotoyegi kukngizi keliyeng waliya mani pura mizi kangweki sawiya. Tegi pi yeke ige yabela. ");
INSERT INTO big_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pi yeke ige pilik mizageya wizigarik Yuda kolokngagonowili Anotoyegi yenge yerengke waberek mizi. ");
INSERT INTO big_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Puwili pilik mizageya koyigeya Yemizibekki angelawiliyaga nak Sakarayayegi tabunda logo pi alata kukngizi keliyeng waliyirage mele ngaigezikke luwe wizilege. ");
INSERT INTO big_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Angelabek tabundawekke Sakaraya pakela logo pi lebuk keya kulili miza. ");
INSERT INTO big_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kapura angelabokko piyegi pelik meiya, Kulili mizi wak. Anotogo waberek nugumekki yaka kerewiya kani logo nigi yongokpumele Ilisapete nigi marek nak wazamiyagi. Keya nugu yeik pugura Yowan meimo. ");
INSERT INTO big_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Keya wilek kang nugubek wilik kagowing mizagi keya yongkambanu kolokngagonowilirau pi wazamiyagi purikki wilik kagowing mizagi, ");
INSERT INTO big_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","purik pi yombu yemane panu Anotogi wiregebek legi. Pi kai nagi ono ma kai kozang nayengkarau nagi onobek. Pi ngoluk panugi yenge yaga yolu puwekke Anotogi Kung Walekpokko yenge ya pugura kolagi. ");
INSERT INTO big_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pi Isileili yongkambanu kolokngagono Yemizi Anoto puwiligibekyegi iza orowei yogibek. ");
INSERT INTO big_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pi kazing keya kozang Ilayago miza pilikmekke Anotogi ngagora orowei mizagi logo Yemizibekki kazingmek tiya mowiyiwekibek. Pi koloyakawili kiling puwiligi mangongangwili menalege iza orowei yogibek. Pi yongkambanu Anotoyegi nagerewiyi mizi puwili kazing wazono kumulagimekke iza orowei yogibek. Pugu pilik miziyengko yongkambanuwili Yemizibek lewagi purikki puwili kangkere miza logo yukeweki, meiya. ");
INSERT INTO big_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Anotogi angelabokko pilik meiya logo Sakarayago piyegi pelik nguk meiya, Ne yombusibek keya negi yongokpumelerau mabilik legi talik miza logo ngago pura ngizi mizagi. Nogorik te mandik wazamiyagi langai onoyau miza, meiya. ");
INSERT INTO big_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Logo Anotogi angelabokko pelik meiya to mela, Ne Gebirel kani. Ne Anotogi wirege luwe yolu logo pugu ne ngago wazono pera niyegi kozak neiweki wezanela. Piliktikki wiyeke ne kayima. ");
INSERT INTO big_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Logo ne kanda ngago ngizi lewagiragi nogo niyegi kozak neiya kapura ni nogo kairikki ngizi panu kumuli ono. Ni ngizi panu kumuli ono legi ni ngago kaiyagi langaigi ono kani. Ni ngagoluk wizagomeige wok ngago pera ngizi mizagibokko purik ni ngago kaiyagi kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pilik miza logo Sakaraya yeke Anotogi i walek yemanemakke yokolong panu yolu legi yongkambanu Sakarayayegi yuke koyawili wilek ngelek kumula mela. ");
INSERT INTO big_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Keya pi yeke iga welagelawekkerik pugu puwiliyegi ngago yeiyagi langai ono legi puwili iwaka, pi yaka yeke Anotogi i walek yemanemakke yeke ige iwek wangakyeng kelik paka ngalega nara pakela mane mena miza. Ngagora kaiyagi langai ono legi mele ngezebekkiyaugu ngagoyeng puwiliyegi waligeleya. ");
INSERT INTO big_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pi pilik miza logo yawe pigi yeke Anotogi i walek yemanemakke waberek mizara weik yeik logo Sakaraya pongo ige kandobela. ");
INSERT INTO big_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pongo ige kanda wiziya waleleige pura Ilisapete yongok pugumele weik mandik kogo logo pi yenge yerengke wei miza ono, pi ngong mele nazik yeke ige wizagoma. ");
INSERT INTO big_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ilisapetego pelik kaiya, Yemizibokko yaka neyegi wazono miza legi mabek nogo yongkambanuwiliyegi ne kabili logo negi kendek mizi purik weik yeik, kaiya. ");
INSERT INTO big_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Togo pulaga waleleige Ilisapete ngong mele nazik keya nazikka nakke mandik kogo wiziyawekke Anotogo pigi angelawiliyaga nak ngabelak Kalili meibekke yereng yeikta Nasarete meiragi wezamela. Angelabekki yeikta Gebirel meibek. ");
INSERT INTO big_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pi yongok nawekke nameleyegi ngago nara kozak mei kayima. Molo yombu nak kilindau iwek kola onomele. Yeik pugura Maliya. Pi yombu yeikta Yosep meibekyegi yawi sawiyamele. Yosep pi Tawitigi yeligagangmekkabek logo Maliya keya Yosep ngoluk weiya ono. ");
INSERT INTO big_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anotogi angelabek Maliyayegi kanda pelik meiya, Ei, Maliya wazonomele, wilik mize. Anotogo niyegi wazono panu kumuli. Yemizibek ni kiling yolu, meiya. ");
INSERT INTO big_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliya angelabekki ngago pura kerewiya logo wilek kuneng panu keya pugu kai puragi taliktikki kai miza legi kumula meli. ");
INSERT INTO big_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Keya Anotogi angelabokko piyegi pelik meiya, Maliya kulili mizi wak. Anotogo niyegi keli panu kani. ");
INSERT INTO big_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kerewiye, ni mandik nak kogogi logo ni mandikpek wazami puwekke nugu yeik pugura Yisu meimo. ");
INSERT INTO big_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pok yemane panu wiziyagi keya Anoto Yemizi Lewege Panubokko piyegi pelik meiyagi, Ni negi Marekpek, meiyagi. Keya Yemizi Anotogo mizagewiyege pi yongkambanu mamokyegi ngaigi, pigi yelibungang kokawiliyagabek Tawitigu wiziya pilik. ");
INSERT INTO big_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Keya pi Yakopgi yango keya marekngang mabuwiliyegi ngai wiza kayimagibek. Ngai pugura yeikki ono wiza kayimagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Pulaga Maliyago Anotogi angelabekyegi pelik meiya, Ne yongok ngoluk yombu wei onomele legi talik miza logo pura neyegi mizagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Logo Anotogi angelabokko pelik meiya to mela, Anotogi Kung Walekpek niyegi kiliyagirik Anoto paka ngalege yolubekki kozandago mandik kogo keleniyagi. Piliktikki wiyeke yongkambanuwiligu piyegi kisagirik pi kaileyendau ono legi pi walek, pi Anotogi Marekpek, kisagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kerewiye, nigi panumelegi si Ilisapete ulogo kabilimele, pi yongoksi kele kapura pirau mandik nak kogo keya pi mandik kogorik ngong mele nazik keya nazikka nak kani, ");
INSERT INTO big_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anoto watabi mabiyeng pangka mizibek kopong, meiya. ");
INSERT INTO big_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Logo Maliyago pelik meiya to mela, Ne Yemizibekyegi yawe mizimele, ne piyegi panga yungke kiliya logo ngago yaka nugu neyegi kozak neiya pura pilik mizagi. Maliyago pilik meiya logo angelabek weik pi wezami kang. ");
INSERT INTO big_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pilik miza logo Maliya nguk namizi kangkere miza logo ngezangai paka ngabelak Yudaya meibekke lewak nakke yereng naragi kambela. ");
INSERT INTO big_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pi kambela logo pi Sakarayagi imakke yeke ige kiliya kanda Ilisapeteyegi, Isi, ni wazono yolu ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ilisapete Maliyago ngago kai puragi kerewiyawekke mandikpek weik yenge yaga wilik kagowing yemane mizi keya Anotogi Kung Walekpokko weik Ilisapeteyegi yenge yungke kiliya logo kola wizimowei ");
INSERT INTO big_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ngalizi ngago pelik kai, Anotogo ni yongok mabuwiliyaga lewege keleniya logo niyegi wazono miza keya mandik yenge nigi yungkeboktau Anotogo pi yombu mabuwiliyaga lewege kelemiya logo piyegi wazono mizi. ");
INSERT INTO big_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ni Yemizi nogobekki panumele neyegi pakeli kayima logo Anotogo yeik nogora yongolok meirikki, ne lebuk mizi. ");
INSERT INTO big_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ni kanda ne ngago nugu neyegi nei pura kerewiya mabuwekke nguk namizi mandik yenge negi yaga yolubek wilik kagowing yemane miza. ");
INSERT INTO big_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ngago Anotogo niyegi mizagi neiya pura ngizigi purikki ni ngizi panu kumuli legi wilek kang nugubek wilikwilikmokko si wiziyagi, meiya, Ilisapetego. ");
INSERT INTO big_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Pulaga Maliyago pelik kaiya, Ya nogora Yemizibekki yeikta yongolok mei. ");
INSERT INTO big_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Keya Anoto ne yaliya wazanibek kopong wilek kang nogobek wilikwilikmokko pangka ono. ");
INSERT INTO big_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ne Anotoyegi yawe mizimele. Ne yongok yeikmele, kapura pi neyegi pakela logo neyegi yalek miza logo neyegi wazono mizarikki wiyeke mabek yongkambanu mabuwiligu pelik kisagi, Anotogo piyegi wilik kagowing yemanera mana, pilik kisagi. Ngoluk wik yolu puwili keya kalike yolugi puwilirau pilik kisagi. ");
INSERT INTO big_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Puwili pilik kisagi purik Anotogi kozang yemanebokko neyegi watabi wazono unatuba panuyeng keleniya. Pi kaileyendau onobek legi yeik pugura Walekta. ");
INSERT INTO big_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yalek pugura yongkambanu piyegi panga yungke kiliya puwiliyegi yolu keya puwiligi yango keya marekngang puwiligu wazayagi puwili keya puwiligi yango keya marekngang puwiligu wazaya puwili keya ngoluk mabilik wiza kangki. ");
INSERT INTO big_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yongkambanu lewegewili miziwili yawe nalangaiyeng mizagi keliwili yeik ngezewiligiyeng yongolok meiwekiwili kozang pugurago wezayela. ");
INSERT INTO big_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pugu yaka yongkambanu ngai yemizi panu puwili kawiye walibene keleya keya yongkambanu yeikwiligi yeikyeng ngalege yongolok meiya. ");
INSERT INTO big_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pugu yaka yongkambanu yagasiwili watabi wazonoyeng yana logo ngekyengko wizigeya yongkambanu watabi keremungkeyeng kiling puwili yana ono logo yeik wezayela. ");
INSERT INTO big_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Koka walaka pugu tenigi yelibungang kokawili keya Abalam keya teni pigi yango keya marekngangwiliyegi kaiya pura pi ngela ono keya pigi yalekta pi keremareke ono logo pugu yaka Isileiliwili piyegi yawe miziwiliyegi sawela logo wiza kayimagi, kaiya. ");
INSERT INTO big_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliya ngago pura pilik kaiya logo ngong neyauganak Ilisapete kiling wizagoma logo weik panga i ngezemelegimakki kandobela. ");
INSERT INTO big_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ilisapete mandik wazamiyagira weik lewa logo pi mandik nak wazamiya. ");
INSERT INTO big_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ilisapetegi yerendagawili keya pigi ingembungangwili Yemizibokko wazono pura piyegi kelemiyarikki kerewiyawekke puwili mabuwili pi kiling wilik kagowing miza. ");
INSERT INTO big_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Keya mandikpek wok melenazik keya nazikka neyau wiziya logo wok kalikebekke yombu nawilirau mandikpek yombu korikwekki korik yeke ngalege puwek ngeliweki kayima. Yombu korikwekki korik yeke ngalegewek ngeli purikku pi Anotogibek miziweki. Yeke ige kanda puwiligu yeik pugura mango ngezebekkira kelik Sakaraya meiyagi nobiyeng miza ");
INSERT INTO big_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kapura panugu, A’a’, yeik pugura Yowan meiyagibek kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Keya pulaga puwiligu piyegi pelik meiya, Kapura nigi namele keya nak yeik pura meiya ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Togo Sakaraya pangka ngago kaiyagi ono legi puwiligu meleyengko mangoyegi keli pugurik mandikpekki yeikta tak meiyagi kelemiya. ");
INSERT INTO big_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakarayago puwiliyegi kapiya nanging piyegi maniweki nguk yeiya logo mandikpekki yeik Yowan pura lende miza. Piliktikki wiyeke puwiligu lelengkirarik yemane. ");
INSERT INTO big_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sakarayago yeik pugura Yowan miza ngizige pi weik ngereke ngago kai keya yeik Anotogira yongolok meiya logo piyegi ngago wilik kagowing meiya. ");
INSERT INTO big_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Togo yongkambanu yereng puguragawili kulili panu keya yawe pilik mizi puragi ngagora Yudaya ngabelakpekke yereng mabiyengke weik yei yongomo miza. ");
INSERT INTO big_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yongkambanu puragi kerewiyawili kumuli keya nakko nakyegi pelik nguk mei yongomo mizi, Mandik pok talikkibek. Yemizibekki kozanda pi kiling yolu kani, kisi. ");
INSERT INTO big_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Anotogi Kung Walekpek Yowangi mangobek Sakarayayegi kola wizigeya pugu Anotoyaga ngago pera pelik kaiya, ");
INSERT INTO big_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Teni Yemizibek Anoto Isileiliwiligibekki yeikta yongolok meiweki, purik pi teni yongkambanu puguwiliyegi saweliweki kayimabek keya teni wila wazayiweki kayimabek legi. ");
INSERT INTO big_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anotogo weik yombanu kozang panu nak King Ngai Tawiti piyegi yawe mizabekki yeligagangmekka tabunda wazamiya logo pi teni yaliya wazayagibek. ");
INSERT INTO big_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pura Anotogo koka walaka yombu Anotoyegi sawela panu logo Anotoyaga ngagora weiya logo kozak kisawiligu kozak kisa logo weik pelik miza. ");
INSERT INTO big_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Pugu teni yongkambanu teniyegi ngai miziwili keya yongkambanu nawili teniyegi kumbak miziwiliyaga yaliya wazayagirikki kozak kai. ");
INSERT INTO big_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pugu tenigi yelibungang kokawiliyegi yalek miza keya Anotogi ngago walek silok tiya koka walaka Abalamyegi kozak meiya pura pi keremareke ono. ");
INSERT INTO big_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ngago sawiya pura pugu koka tenigi yelibubek Abalamyegi ngago yeik ngezebekkiraga kozang kelemiyara logo pugu koka kaiya pura weik mabek mizagi. ");
INSERT INTO big_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ei, purik pelik, pugu teniyegi ngai miziwiliyaga yaliya wazaya logo teni kulili mizagi ono koyimowei yawe pugura kozang kebangkeli ");
INSERT INTO big_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","keya teni pigi wirege kazing kaileyendau onomekke yoluweki keya kazing pangkamekke kiriweiweki wok teni wik yolugi piyeng mabiyengke, kaiya. ");
INSERT INTO big_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sakarayago pura kaiya logo mawinda pelik kaiya, Keya ni negi marekpek, kalike yongkambanuwiligu pelik kisagi, Pi Anoto Yemizi Lewege Panubokki yombu Anotoyaga ngagora weiya logo kozak kaibok kisagi purik Yemizibek kalika kangkine kapura ni were pigi kazing kunagimek kangkere miziweki kangkibek legi. ");
INSERT INTO big_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Nugu Anotogi yongkambanuwiliyegi kazing yaliya wazayagimekki iwaka siweki keleyagi. Teni yaliya wazayagirik Anoto tonugubekki yalektago kaile kaile tonuguyeng tumulagi logo pilik mizagirik yombanu paka ngalegabek ngabelakpekke lewagelawekke. ");
INSERT INTO big_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Pigi lewagirik yokmek wok wikpekke tabunda mabilik logo pugu yongkambanu kusabanurikke yolu logo puwiligi kazing kumbekki Anotoyegi leweng ibeng puwiliyegi wilangka wezarik wiziyagi keya teniyegi kazing yombiyangai yongomo mizagimekki yolok ngeliweki, waligeleyiweki, kaiya. ");
INSERT INTO big_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Togo kalike mandik Yowan pok weik yemane lewagela keya kazing kumbekki lewengke weik kozang sa. Pi ngezebek keke paka kurung yeikwekke wiziya pi yongkambanu Isileiliwiligi wirege lewagela wiriyagi puwekkegine. ");
INSERT INTO big_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Togo puwekke Romwiligi King Ngaibek Sisa Agustago lo wik nara wiya logo yongkambanuwiliyegi kozak yeiya. Lo pura yongkambanu ngabelakpek mabokki puwili mabuwili yeik puwiligiyeng kapiyarikke lende miziwekira. ");
INSERT INTO big_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yawe yeikyeng kapiyarikke lende mizi pura solo lewagelawekkerik Sairiniyago ngabelak Siriya meibekke ngaiwekke. ");
INSERT INTO big_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tegi puwili mabuwili nak nak yeik ngezewiligiyeng kapiyarikke lende miziweki yereng ngezewiligi yelibungangwiligiyengke kambela. ");
INSERT INTO big_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosep Tawiti kokabekki yeligagangmekka nak kopong pi pongo ngabelak Kalili meibekke yereng Nasarete meira wiya logo paka ngabelak Yudaya meibekke Tawitigi yereng koweige Petelem meiragi kambela. Yereng pura Tawiti King Ngaibek wazamiyara. ");
INSERT INTO big_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Maliya yongok Yosepgi yawi sawiyamele weik mandik kogomele kiling Yosep kapiyarikke yeik piyaugiyau lende miziweki kambela. ");
INSERT INTO big_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Piyau kanda Petelem yerengke lewagela logo pulogo tagogei Maliya pigi mandik wazamiyagira weik lewa. ");
INSERT INTO big_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Keya i koweiga lewawili iwekmak weik wilak kopong piyau liyengwiligi imakke iwek kola logo Maliya weik mandik kalogoli pugubek wazamiya logo kagorik lewerikku sukumeng miza logo lowak liyeng pulumakauwiligu ngeragi niwekke yenge yungke wazamiya. ");
INSERT INTO big_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Togo yereng Petelem puraga mereke yombu nawili liyeng memeng ngezewiligiwiliyegi ngai koya. ");
INSERT INTO big_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Keya wokpokko puwili kusage ngai koyawekke Anotogi angelawiliyaga nak puwiliyegi tabunda keya Anoto Yemizibekki ngaiwaktikku puwiliyegi ngalege ngaiwak wiya logo puwili kazi kulili panu miza. ");
INSERT INTO big_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kapura angelabokko puwiliyegi pelik yeiya, Kulili mizi wak. Kerewiyi, ne iniyegi ngago wazono panura orowei lewabek kani. Pura yongkambanu Isileili mabuwili wilikwilik miziweki keleyagira. ");
INSERT INTO big_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mabek kusa pobokko panga yereng King Ngai Tawiti wazamiya puraga ini yaliya wazayagibek weik wazamiya. Pi Kilisibek, Mesiya Anotogo yawe pigi yongkambanuwili yaliya wazayagi pura miziweki sawiyabek, pi Kilisi Yemizibek. ");
INSERT INTO big_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Keya inugu kazing wameik ngago yaka kai peragi iwakawekimek pemek. Mandikpek kagoriktikku sukumeng miza logo lowak liyeng pulumakauwiligu ngeragi niwekke iwek wizilege pakelagi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Angelabek pilik yeiya logo mabuwekke Anotogi angelawili kolokngagono amiwili kelik yaka werebok kiling nguk namizi tabunda logo Anotogi yeikta yongolok mei keya pelik ingi meiya, ");
INSERT INTO big_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Teni Anoto paka ngalege panu yolubekki yeikta yongolok mei keya yongkambanu ngabelakpekke Anotogo keli puwiliyegi ngezege sara wizei pani, meiya. ");
INSERT INTO big_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Togo angelawili puwili wezaya logo weik paka ngalege yongowekke yombu liyeng memengwiliyegi ngaiwili nakko nakyegi pelik mei yongomo miza, Teni panga Petelem yerengke watabi yaka lewagela logo mabek Anoto Yemizibokko teniyegi kozak yeiya piyengki pakeli kangweki, kela. ");
INSERT INTO big_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Togo puwili ngezangai kambela logo panga yerengke kanda Maliya keya Yosep koyilege pakela keya mandikpek lowak liyeng pulumakauwiligu ngeragi niwekke iwek wizilege pakela. ");
INSERT INTO big_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Keya pilik pakela logo yombu liyeng memengwiliyegi ngaiwiligu puwiliyegi angelawiligu yaka mandikpekyegi langai kozak yeiya pura kozak yeiya. ");
INSERT INTO big_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Keya yongkambanu kerewiyawiligu yombu liyeng memengwiliyegi ngaiwiligu kozak kisi puragi wilek kumula meli. ");
INSERT INTO big_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kapura Maliyago watabi pakela piyeng keya ngago kerewiya piyeng mabiyengki wilek kang pugubekke kumula panu wizagoma. ");
INSERT INTO big_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Keya yombu liyeng memengwiliyegi ngaiwili kambelarik puwiligu kerewiyi keya pakeli miza piyeng angelawiligu kozak yeiya mabilik legi Anotogi yeikta yongolok mei keya Anotoyegi wilik kagowing mei kambela. ");
INSERT INTO big_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Togo pulaga mandikpek wok melenazik keya nazikka neyau wiziya logo wok kalikebekke puwili mandikpekki yombu korikwekki korik yeke ngalegewek ngelawekkerik puwili yeik pugura Yisu meiya. Yeik pura angelabokko Maliyayegi were kozak meiyara logo yeik pugura Yisu meimo, meiyara. ");
INSERT INTO big_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Togo pulogo koya Anotogi lo Mosego lende mizarago weik pangka kaiyara weik wizigeya piyau mandikpek paka Yirusalem Anoto Yemizibekyegi miza maniweki miza orowei kambela. ");
INSERT INTO big_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pura Mosego Anoto Yemizibekki loraga lende miza pelik, Panu keya mangowili mandik kalogoli puwiligiwili iza orowei kanda puwili Anoto Yemizibekyegi yawe pugura keke miziweki maniweki, lende miza. ");
INSERT INTO big_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Keya Anoto Yemizibekki lo nararau pelik kaiya, Winak Kuwemimi neyau ma winak Kuwemimi luguwili kelikyau Anoto Yemizibekyegi opa miziweki manizo, kaiya. Anoto Yemizibekki loragi kiriwei piyau mandikpek paka Yirusalem Anotogi i walek yemanemakke miza orowei kambela. ");
INSERT INTO big_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kanda pakalege pura yombu yeikta Simiyong meibok wizilege. Pi Yirusalem yerengke yolubek. Yereng yemane pura Yudawiligi ngaiwili yolura. Pi pangka panu yolubek keya pi Anotoyegi keli kopong pi Anotogi lo mabiyengki kiriwei yolubek. Pi Anotogo yongkambanu Isileiliwiligi kuneng mabiyeng wezameliweki sawiyabekyegi yuke yolubek. Anotogi Kung Walekpek piyegi kiliya yolu. ");
INSERT INTO big_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Keya koka Anotogi Kung Walekpokko Simiyongyegi pelik meiya, Nugu were Yemizibekki Kilisi Mesiyabek Anotogo yawe pigi yongkambanuwili yaliya wazayagi pura miziweki sawiyabekyegi pakela logo wizagoma weik ni ibengki, meiya. ");
INSERT INTO big_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Keya Anotogi Kung Walekpek Simiyong miza orowei Anotogi i walek yemanemakke yeke ige kiliya la. Keya panu keya mango mandikpek Yisu kazing loragi kiriwei pumokki miziweki miza orowei yeke ige kiliya la puwekke ");
INSERT INTO big_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyongku mandikpek mele puguyaugu miza logo Anotogi yeikta yongolok meiya logo piyegi ngago wilik kagowing pelik meiya, ");
INSERT INTO big_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Anoto negi Yemizibek, ngago koka nugu kaiya pura weik ngizira lewagela legi weik wilek kang nogobek wilikwilik keya ne yombiyangai ibengki. ");
INSERT INTO big_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Purik wire nogoyaugu weik yombu nugu teni yaliya wazayiweki wezamelabekyegi pakela mena. ");
INSERT INTO big_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Keya nugu pi yongkambanu ngabelakpekkewiliyegi miza yana. ");
INSERT INTO big_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pi wilangka yongkambanu Yuda onowiligu kazing nigi wameik pumokki pakeliweki mizagirik keya pugu yeik teni Isileili nuguwiligira yongolok meiyagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Pi Anotoyegi pilik meiya logo mandikpekki panu keya mangoyau ngago Simiyongku piyegi meiya puragi lelengkira. ");
INSERT INTO big_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pilik miza logo Simiyongku piyauyegi pelik yeiya, Anotogo inuwayegi wazono mizagi. Pi pilik yeiya logo mandikpekki panumele, Maliyayegi ngago kalike mizagiragi pelik meiya, Kerewiye, Anotogo mandik pobok sawiya logo piyegi weraga yongkambanu Isileili kolokngagonowili Anotoyegi kezanga managi keya nawilirau mabilik Anotoyegi koli kelemiyagi kani. Keya pi kazing yongkambanuwili Anotogi kozanda keya ngai puragi iwakawekimek kapura yongkambanu kolokngagonowiligu piyegi kaile ngago meiyagi kani. ");
INSERT INTO big_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Piliktikki wiyeke yongkambanu kolokngagonowiligu kumuliyeng kimeike lewagelagi kani. Keya nugurau piyengki pakela logo kuneng yemane nugu piyegi kelagira wizang wezalik ya nuguraga yowagi kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Togo Simiyongku pilik meiya wizigeya mabuwekke yongok Anotoyaga ngagora weiya logo kozak kai namele lewagela. Yeik pugura Ana keya pigi mangobek Panuwele, Asagi yeligagangmekka nak. Ana koka yombu nak weiya logo kirisimasi melenazik keya nazikka neyau pi kiling wiziya ");
INSERT INTO big_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","logo pi ibeng wizigeya pi yombu nawei wiziya pi weik kirisimasi puguyeng yombu mangobektau ono keya mangorarau ono pilik kopong pi yongoksi panu. Pi Anotogi i walek yemanemakki Anotoyegi ingeyau laliyi keya piyegi ya kumuliweki kang mizimele. Pi Anotoyegi ya kumulirik kusaga yoklongko wok piyeng mabiyeng wilek kang mabiyeng Anotoyegi waberek mizagirikki tiya maniweki pi ngeragi ni ono mizimele. ");
INSERT INTO big_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana kanda mandikpekyegi pakela logo Anotoyegi wazono meiya. Keya pugu weik ngago mandikpekyegi langaira yongkambanu Isileili Rom Kapmanbokko ngairaga wila wazayagibekyegi yuke yolu puwili mabuwiliyegi kozak yei yongomo miza. ");
INSERT INTO big_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Togo panu keya mango lo Anoto Yemizibekkirago miziweki kaiya piyeng miza logo weik yeik wizigeya morok paka ngabelak koweige Kalili meibekke yereng ngezemerekki yeikta Nasarete mei purage kang yongobela. ");
INSERT INTO big_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Morok kanda pakalege koyimeige mandikpek weik yemane keya weik kozang keya kumuli puguyeng Anotogi kelira keya yongkambanuwiliyegi ngai puragi iwaka sirikku kola keya Anotogo piyegi wazono pugura mana. ");
INSERT INTO big_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Togo kirisimasi mabiyengke pigi panu keya mangoyau paka Yirusalem ngeragi yemane miza ni Pasoba meirage pakeli kambeli mizi. Pasoba pura Yudawili ngeragi yemane miza nageya koyimowei walaka Anotogo puwiligi yelibungang kokawiligi iyengki kangyengke iwirik pukmela wizilege keriya logo puwiligi koloyakamandik kalogoliwili ibengkirikka yaliya wazaya puragi kumulira. ");
INSERT INTO big_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Togo Yisu kirisimasi puguyeng meleyau keya ingenazikka neyau pilik puwekke piyaugu pi paka Pasoba ngeragi miza nirage miza orowei kambela. ");
INSERT INTO big_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Morok kambela logo Pasobara pakela logo pulaga yo kayimarik mandikpektau kayima ono paka Yirusalem mabulogo wizagoma kapura pigi panu keya mangoyau iwaka ono, ");
INSERT INTO big_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","logo weik mandikpek yaka yongkambanu nawili kiling ngabelak libu were nobiyeng weik wok nak kambela logo pigi ingembungangwili keya yerengkewiliyegi weli yongomo miza koyima ");
INSERT INTO big_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","kapura pi yolok ngela ono legi piyau paka Yirusalem mandikpekyegi weliweki kang yongobela. ");
INSERT INTO big_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wok neyauganakpekke piyaugu pi Anotogi i walek yemanemakke Yuda waligeleyiwili kiling mogosara puwiligu kozak keliyengki kerewiyi keya nguk yei mizageya wizilege yolok ngela. ");
INSERT INTO big_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Keya yombanu pugu kaiyengki kerewiyawili iwaka pugura keya ngago wazono pugu yeiya to meliyengki lelengkiri. ");
INSERT INTO big_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Keya pigi panu keya mangoyau piyegi pakelawekke piyau lelengkira logo pigi panumologo pelik ngalik meiya, Mandikpek, nugu teyegi pelik keleyira nangki? Te peba wilek ngelek kumulageya koyimowei niyegi weli kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Keya pugu piyauyegi pelik yeiya to mela, Nangki wiyeke yali neyegi weli? Yali ngoluk ne yeke negi Mangobekki imakke pigi yawera mizagirikki mizi purikki yali iwaka ono ma yeik? ");
INSERT INTO big_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kapura piyau ngoluk pugu piyauyegi yei puragi ngizi iwaka ono. ");
INSERT INTO big_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Togo Yisu piyau kiling pongo Nasarete yerengke kandobela. Pulogo pi panu keya mangogo kaiyengki kiriwei mizi keya piyauyegi yeik panga yungke kiliya wizimowei mizi. Keya pigi panumele watabi mabiyeng wilek kang pugubekke wara wiziya keya ngoluk kangka pugubekke kumula. ");
INSERT INTO big_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Togo Yisu wizagomeige weik korikwek keya iwaka miziyendau unatuba si lewa logo Anoto keya yongkambanuwiligurau piyegi pakelirik yombiyangai panu. ");
INSERT INTO big_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Wok nakke Yowan Sakarayagi marekpek, paka kurung yeikwekke wiziyawekke Anotogo pulogo piyegi ngagora mana. Puwekkerik kirisimasi meleyau keya ingenazik Romwiligi King Ngaibek Taibiriya Sisago ngai wiziya logo Pontiya Pailetgu ngabelak Yudaya meibekke ngai, keya Elodogo ngabelak Kalili meibekke ngai, keya pigi sakpek Pilipgu ngabelak Ituriya keya Terekonaiti meiyauge ngai, keya Laiseniyago ngabelak Abilini meibekke ngai, keya Anasa keya Kayapasi yombu Anotoyegi kolak miziwiligi ngai yemane panu koya. ");
INSERT INTO big_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Puwili ngai koyawekke Yowangu Anotogi ngagora kerewiya logo pi yangalekta pongo kai Yolodang meilingke kabelakke pulogo yongomo miza keya yongkambanu piyegi kayimawiliyegi ngagora yana. Pugu puwiliyegi pelik kozak yeiya, Ini kaile inugu miziyengki kuneng mizizo keya kazing kaile inuguyengka kowiti mizizo keya wilek kang inuguyeng Anotoyegi sawelizo. Pilik miza logo purik nogo ini kaimelagi logo Anotogo kaile inuguyeng tumula logo keremareke wezamelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yowangu pilik miza purik koka walaka yombu Isaya meibek Anotoyaga ngagora weiya logo kozak kisawili logo Poropekwili meiwiliyaga nakko Anotogi Kapiya Walektikke mabilik lende miza pelik, Yombanu nak lewagelagi logo paka kurung yeikwekke wizimowei ngalizi pelik yeiyagi, Yemizibek lewa legi kazing inugu miziyeng waberek mizizo keya wilek kang inuguyeng pangka pangka mizizo. Kazing pilikmekke inugu kazing Yemizibekkimek kangkere mizi. ");
INSERT INTO big_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Keya lewakpek sopela logo kosauwekke ngabelak kola mana logo kolang keremizizo. Keya kazing wikyeng keremizibene wale kolok kelik piyeng pangka pangka mizizo keya kingyeng tukula logo kazingmek wazono mizizo. ");
INSERT INTO big_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pilik miza logo teni yombanu ngabelakpekki mabuwiligu yawe Anotogo teni yaliya wazayagira pakelagi, pilik lende miza. ");
INSERT INTO big_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yowangu Anotogi ngagora kozak yeiya logo yombanu kolokngagonowili piyegi kaimeliweki kayima. Pugu purikki pakela logo pelik yeiya, Igali. Ini mabuwili kemale yenge kuzingikyengke yungke tagogei yeziyengko ngora mela nelegi kazi kangwili kelik. Takko iniyegi Anotogo kalike yombanu mamokki kazing miziyengki ngagozak keleyagi logo kaile mizayengki sisik pugura yemane kopong ngangang yanagirikki kozak yeiya logo inugu kumularik Anotogo ini ngangang yana nelegi ini neyegi kaimeliweki kayima ma talik? ");
INSERT INTO big_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ini pilik mizagi keli purik were ini kaile inugu mizi piyengki kuneng miza logo kazing kaile inuguyengka kowiti miza logo Anotoyegi sawela koyimowei Anotoyegi kazing wazono mizi piyeng mizi logo teni mabuwili kimeike pakela logo nogo ini kaimelagi. Keya ini makngezego nakko nakyegi meiya yongomo mizi, Teni Abalamyaga kayimawili legi teni ulogo Anotoyegi sawela, kisi nagani. Anotogo king peyeng ngizi Abalamgi yango keya marekngangwili miziweki kowitagi keli kesak pi pangka. Abalamyaga kayima purikki ngago ono kapura were kaile inuguyengki kezanga mana logo wilek kangyeng Anotoyegi saweli. ");
INSERT INTO big_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ini yengeleiyeng kelik. Yombanu nak ngezebokko pakeliraige yengelei nalei yengelei wilek wazonoyeng wira mela ono puwekke purik mabura pi yenge sologe winilekko kira logo panga yezizikke waliya wezamiyagi. Anotogo iniyegi pilik mizagirik mereke, yeiya. ");
INSERT INTO big_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Togo yongkambanuwiligu ngago pura kerewiya logo piyegi pelik nguk meiya, Teni talik miza logo yengelei wilek wazonoyeng wiragi? ");
INSERT INTO big_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Pugu puwiliyegi pelik yeiya to mela, Tak melewangka neyau purik mabura narik yombanu yeikpok manimo keya tak ngeragi nayeng purik mabura sanga miza nimo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Keya pulaga yombanu king takis wei piyengka nayeng ngowei nawilirau piyegi kaimeliweki kayima logo piyegi pelik nguk meiya, Kiriwagabek, teni talik mizagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Pilik kisi legi pugu puwiliyegi pelik yeiya, King takisyeng kapmanbokko weiweki sawiya pilik keke weizo keya ini piyengka kokowa nayendau wei nagani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Keya pulaga ami nawilirau mabilik piyegi pelik nguk meiya, Keya teniyegirik talik mizagi? Pilik mei legi pugu puwiliyegi pelik yeiya, Yombanu inugu yeli puwiligi watabiyeng ngowei mizi nagani ma onanga kisa logo kingyeng ngowei mizi nagani kapura king inuguyeng keke yawe inugurage yani piyeng wei keya king ngane sa weiyagi purikki keli nagani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yowangu pilik miza logo yongkambanu Kilisibek Mesiya Anotogo yawe pigi teni yaliya wazayagi pura miziweki sawiyabekyegi waberek yuke puwili ngago Yowangu yei puragi kerewiyawekke puwili Yowanyegi wilek kang yemane kumula mela logo pelik kisa, Pi Kilisibek ma talikpek? ");
INSERT INTO big_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tegi Yowan kerewiya logo pugu puwili mabuwiliyegi pelik yeiya, Yeik. Ne yombu yeikpek. Nogo ini kai yeikpokko kaimeli kapura kozanda keya yawe nogo mizi peyeng ulagi nak lewagi. Ne pokyaga kulengke logo nogo kumularik yeik nogora yeik puguraga kulengke panu, keya yeik pugura nogoraga ngalege panu. Pokko ini Anotoyegi kowita puwili Anotogi Kung Walekpokko yenge yungke kola wizeibene keleyagi keya ini nawili Anotoyegirau kowita ono puwili, pugu yezizikke yenge yungke wezayelagi. ");
INSERT INTO big_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pugu yombanuwiliyegi mizagirik iwing yaweleigi mangobokko iwing yawe puguleige mizagi mabilik. Yaweleigi mangobek iwiyeng menalege kili tiya logo limiza logo iwing ngiziyeng kebangkelagi kapura lekyeng wezamelagi. Mabilik kalike lewagibok yombanu ngizi puguwili kebangkelagi kapura yombanu pigi onowili panga yezi kusagi onozikke wezayelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Togo Yowangu yombanuwiliyegi kozang kozak yeiyageya wiziyarik kazing pangkamekke koyagirikki keya Anotogi ngago wazonoragi kozak yeiyageya wiziya. ");
INSERT INTO big_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Keya Yowan ngoluk yongkambanuwiliyegi kaile puwiligu mizayengki kozak yeiyageya wizimowei ngaibek Elodoyegirau kazing kaile pugu sibek ngoluk wikpekki yongokpumele, Elodiya meimele weiyarikki ngalik kozang mei keya yawe kolokngagono kaile mizi nayengkirau meiya. ");
INSERT INTO big_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Togo watabi kaile pugu miza piyengki ngalege mazenda kaile panu nararau miza logo pura pugu Yowan wigira wazamiyara. ");
INSERT INTO big_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yowangu ngoluk kozak yeiya logo yongkambanu kolokngagono pulogo kaimeliweki kayima wizigeya Yisurau piyegi kayima logo mabilik kaimela. Yisu kaimela logo waberek mizageya tawizeige paka ngalege lemengki kandik tiya ");
INSERT INTO big_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","logo Anotogi Kung Walekpek winak Kuwemimimek kelikmek piyegi yerageya logo kanda piyegi wizigeya Anotogi kilirago paka ngalega pelik mei, Ni negi Marek nogo keli panubek. Ne niyegi wilik, meiya. ");
INSERT INTO big_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Keya perage kirisimasi puguyeng yombu nak keya meleyau logo pi yawe pugura weik solo mizi. Keya yongkambanuwiligu kumularik pi Yosepgi marekpek mena miza. Keya Yosepgi mangobek Elai, ");
INSERT INTO big_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Keya Elaigi mangobek Matak keya Matakki mangobek Lebi keya Lebigi mangobek Melekai keya Melekaigi mangobek Yanai keya Yanaigi mangobek Yosep, ");
INSERT INTO big_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Keya Yosepgi mangobek Matatiya keya Matatiyagi mangobek Amoso keya Amosogi mangobek Neyam keya Neyamgi mangobek Eselai keya Eselaigi mangobek Nagai keya Nagaigi mangobek Meyak, ");
INSERT INTO big_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Keya Meyakki mangobek Matataya keya Matatayagi mangobek Semeng keya Semengki mangobek Yosek keya Yosekki mangobek Yora, ");
INSERT INTO big_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Keya Yoragi mangobek Yowanang keya Yowanangki mangobek Lesa keya Lesagi mangobek Serababe keya Serababegi mangobek Siyatiyek keya Siyatiyekki mangobek Nerai, ");
INSERT INTO big_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Keya Neraigi mangobek Melekai keya Melekaigi mangobek Ari keya Arigi mangobek Kosam keya Kosamgi mangobek Elemaram keya Elemaramgi mangobek Eya, ");
INSERT INTO big_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Keya Eyagi mangobek Yosuwa keya Yosuwagi mangobek Eliyese keya Eliyesegi mangobek Yorim keya Yorimgi mangobek Matak keya Matakki mangobek Lebi, ");
INSERT INTO big_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Keya Lebigi mangobek Simiyong keya Simiyongki mangobek Yura keya Yuragi mangobek Yosep keya Yosepgi mangobek Yonam keya Yonamgi mangobek Elayakim, ");
INSERT INTO big_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Keya Elayakimgi mangobek Meliya keya Meliyagi mangobek Mena keya Menagi mangobek Matata keya Matatagi mangobek Natang keya Natangki mangobek Tawiti, ");
INSERT INTO big_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Keya Tawitigi mangobek Yesi keya Yesigi mangobek Obek keya Obekki mangobek Powas keya Powasgi mangobek Salemong keya Salemongki mangobek Nasong, ");
INSERT INTO big_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Keya Nasongki mangobek Aminarap keya Aminarapgi mangobek Areming keya Aremingki mangobek Anai keya Anaigi mangobek Eserong keya Eserongki mangobek Perese keya Peresegi mangobek Yura, ");
INSERT INTO big_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Keya Yuragi mangobek Yakop keya Yakopgi mangobek Isak keya Isakki mangobek Abalam keya Abalamgi mangobek Tera, ");
INSERT INTO big_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Keya Teragi mangobek Neyo keya Neyogi mangobek Serak keya Serakki mangobek Liyu keya Liyugi mangobek Pelek keya Pelekki mangobek Iba keya Ibagi mangobek Sila, ");
INSERT INTO big_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Keya Silagi mangobek Kenang keya Kenangki mangobek Apasata keya Apasatagi mangobek Sem keya Semgi mangobek Nowa keya Nowagi mangobek Lemek, ");
INSERT INTO big_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Keya Lemekki mangobek Metusala keya Metusalagi mangobek Inok keya Inokki mangobek Yerete keya Yeretegi mangobek Malalali keya Malalaligi mangobek Kenang, ");
INSERT INTO big_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keya Kenangki mangobek Inoso keya Inosogi mangobek Sek keya Sekki mangobek Aram keya Aramgi mangobek Anoto. ");
INSERT INTO big_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Togo Yowangu Yisu kaimelawekke Anotogi Kung Walekpokko piyegi yenge yungke kiliya logo kola logo wizagoma. Keya pulaga Yisu pongo kai Yolodang mei puling wiya logo yongobelawekke Anotogi Kung Walekpokko pi miza orowei paka kurung yeik nawekke kambela. ");
INSERT INTO big_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Pakalege kanda pi ngabelakpokko wiziyarik wok yombu neyau logo Sadang kerewawiliyegi ngaibokko Yisu kaile mizagiyengki yang kelemiya. Puwekkerik Yisu ngeragi na ono wiziya wiziya wok yombu neyau tikinda piyeng mabiyeng moleige keya Yisu weik ngaba ibengmek lewagela. ");
INSERT INTO big_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yisu yagasi legi Sadangko piyegi pelik meiya, Ni Anotogi Marekpek mabura nugu king pobokki meiya logo ngeragi wezazik niweki kowite, purik mabura ni Anotogi Marek ngizi panubek purik ne iwakagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Logo Yisugu pelik meiya to mela, Anotogi Kapiya Walektikke yungke lende mizarik pelik kai, Yombanubek ngeragi nirikku keke wik yolugi ono, kai kani logo ne kimbekki meiyagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Keya pulaga Sadangko Yisu paka lewege miza orowei la logo ngabelakpekke piyeng mabiyeng keya yongkambanu piyengke yoluwili keya yombu ngai puwiliyegi ngaiwili kiling watabi wazonoyengki nguk namizi waligelemiya. ");
INSERT INTO big_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Pilik miza logo Yisuyegi pelik meiya, Anotogo yaka ne ngabelak mabiyeng ngaiweki pangkara nana purikki wiyeke watabi ngabelakpekke piyeng mabiyeng nogoyeng logo nogo managi kelibok managiyeng. Tamizeige ni yeik nogora yongolok meiweki ingeyau laliyi keya neyegi ya kumuli purik mabura nogo ni watabi piyeng mabiyeng yeik yemanera kiling ngaiweki pangkara nanagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pilik kai legi Yisugu pelik meiya to mela, Anotogi Kapiya Walektikke pelik kai, Ni Anoto Yemizi nugubekki yeikta yongolok meiweki ingeyau laliyi keya piyegi ya kumulimo keya yawe pi wamenakpekki pura keke mizimo, kai kani logo ne ngago nugu kai pura mizagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Keya pulaga Sadangko pi paka Yirusalem yerengke miza orowei kambela logo paka ngalege panu Anotogi i walek yemanemakke pi luweza wazamiya logo pelik meiya, Ni Anotogi Marekpek mabura pelaga pongo ngabelakke perakta kawiye wale, ");
INSERT INTO big_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","purik Anotogi Kapiya Walektikke yungke lende mizarik pelik kai. Anotogo angela puguwili niyegi waberek ngaiweki wezayelagi, ");
INSERT INTO big_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Keya mabeliktau kai, Inge panuyaurau ngangang miza nelegi puwiligu ni kebangkelagi. Pilik kai legi pelaga perakta kawiye wale logo angelawiligu ni kebangkeli purikki nogo pakela logo ni Anotogi Marek panubek miziweki, meiya. ");
INSERT INTO big_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sadangko pilik mei legi Yisugu piyegi pelik meiya to mela, Anotogi Kapiya Walektikke mabeliktau kai, Nugu Anoto nigi Yemizibekyegi yang kelemi nagani, kai kani logo ne perakta kawiye walagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Keya Sadangko Yisuyegi watabi nalangai mabiyengki yang kelemirik weik yeikwekke pi kambela logo pi ngereke Yisuyegi yang kelemiyagiragi yuke yolu. ");
INSERT INTO big_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Togo Anotogi Kung Walekpekki kozambokko piyegi kola wizigeya Yisu pongo ngabelak Kalili meibekke kandobela. Keya ngago piyegi langaira pulumengke yereng mabiyengke ululu miza meli. ");
INSERT INTO big_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Keya pugu kanda Yudawiligi i walek songonoyengke waligeleyarikki wiyeke puwili mabuwiligu yeik pugura yongolok meiya. ");
INSERT INTO big_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Togo pulaga Yisu panga yereng Nasarete mei koka pi mandik songonowekke wiziya keya yemane sa puragi kambela. Keya kanda pulogo wok Yudawili yawe mizi ono Anotoyegi ya kumulibek wok Sabatpek meibekke pi Yudawiligi i walek songonomakke ngezebokko were mizilik yeke ige la logo mogosa. Pi mogosa logo pi Anotogi Kapiya Walektikka ngago lang narik meiweki luweza. ");
INSERT INTO big_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pi luweza logo paka orozarikke kuna logo nakko pi Isaya Anotoyaga ngagora weiya logo kozak kaibokko kapiya lende mizarik mana. Pi kapiyarik welela logo ngago lang perik lende miza wizilege weik ngalizi pelik sangkela, ");
INSERT INTO big_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Anotogi Kung Walekpokko neyegi yolu purikki wiyeke pugu ne yongkambanu yeik puwiliyegi ngago pigi wazonora kozak yeiweki sawiya. Keya pugu ne yongkambanu wigira yolu puwiliyegi wezanela logo nogo ngago pelikta yei, Ini weik i wigirimak wiya logo kuni, yei. Keya pugu ne yongkambanu wire kusa puwiliyegi wezanela logo nogo ngago pelikta yei, Ini ngereke pakeli, yei. Keya pugu ne yongkambanu ya kunengyeng kiling yolu puwiliyegi wezanela logo nogo ngago pelikta yei, Kuneng inigi piyeng weik yeik, yei. ");
INSERT INTO big_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Keya pugu ne yongkambanu mabuwiliyegi wezanela logo nogo pelik yei, Pera Anoto Yemizibokko iniyegi wazono mizagira, yei. ");
INSERT INTO big_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pilik sangkela logo pi kapiyarik waliya logo yombu kapiya purikki ngaibekyegi mana yo mela logo pulogo waligeleyiweki mogosa. Pi pilik miza logo weik yongkambanu pulogowiligi wireyeng piyegi ngai yuke panu. ");
INSERT INTO big_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Togo Yisu weik puwiliyegi pelik kozak yeiya, Anotogi ngago lang ini kerewiya koyigeya mabek nogo sangkela perik weik wameik ngizi lewagela, yeiya. ");
INSERT INTO big_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Puwili ngago pugura kerewiya logo puwiligu piyegi wilik ngago kisa logo ngago puragi wilek kumula meli. Tegi puwiligu pelik kisa, Yombu pobok yeik Yosepgi marekpek kapura talik miza logo ngago wazono pera kozak kai, kisa. ");
INSERT INTO big_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Pulaga pugu puwiliyegi pelik yeiya to mela, Inugu weik neyegi pelik kisagi, Ni Tota mabura ni makngezego korik ni makngezegiwek yombiyangai keleme. Keya teni yaka watabi pugu pongo yereng Kapaneyam meirage miza piyengki kerewiya mena yereng ni makngezegi peragerau watabi pilik piyeng mize, kisagi purik ne iwaka, yeiya. ");
INSERT INTO big_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Keya ngereke pugu yeiya, Nogo wameik kai, yombanu Anotogi ngagora kozak kaibok ngabelak kalogomokpekkerik yeikta kiling keya yongkambanu pulogowiligu ngago pugu kai piyengki ngizi kumuli kapura ngabelak ngezebekkibekkerik yeiktarau ono keya pugu puwiliyegi Anotogi ngagora kozak yeiwekkerik puwiligu ngago pugu kai piyengkirau ngizi kumuli ono. ");
INSERT INTO big_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kapura ini kerewiya koyi, koka walaka yombu yeikta Ilaya Anotogi ngagora kozak kaiyabek pelege tenigi ngabelak Isileili meibekke wiziyawekkerik Yuda yongok komatewilirau kolokngagono koya purik wameik panu. Puwekkerik pulogo kirisimasi neyauganara keya walerik kobo namani logo ngabelakpok mabokko ngaba ibenda lewagela. ");
INSERT INTO big_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Anotogo Ilayayegi Yuda yongok komate puwiliyegi saweli kangweki meiya ono, pi panga ngabelak Sairong meibekke yereng Sarepata meiragi yongok Yuda ono komate ngela nameleyegi saweli kangweki meiya. ");
INSERT INTO big_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pulaga kirisimasi nayeng miza logo kalike yombu nak yeikta Elisa Anotogi ngagora kozak kaibek wiziyawekkerik tenigi ngabelak pelege Isileili meibekke yongkambanu kemegeme Leposimek meimek logo korikwek sok miza logo potoga walimekka miziwili kolokngagono koyima. Keya Anotogo Elisayegi yongkambanu pelege Isileili kemegeme leposimek kilingwili yombiyangai keleyiweki kozak meiya ono, pi panga ngabelak koweige Siriya meibekke yombu Yuda ono yeikta Neyaman meibek logo kemegeme leposimek kilimbek logo piyegi kayimabek yombiyangai kelemiweki meiya, yeiya. ");
INSERT INTO big_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yisu pilik yeiya logo yongkambanu i walek songonomakke ige pulogowili ngago puragi kerewiya logo kumularik Yudawili piyegi koli kelemi ono purik Anotogo pi Yuda onowiliyegi wezamelagi miza logo purikki weraga ya puwiligiyeng sisikmokko unatuba panu miza. ");
INSERT INTO big_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sisik miza logo puwili mabuwili luweza logo Yisu yerendaga yenge wilingke ulumi wageliwei kuna logo puwiligu yenge wilekkewekke wezameliweki. ");
INSERT INTO big_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kapura pi yongkambanuwiligi tepek neing kanda weik kazing ngezebekkimek neing kuna. ");
INSERT INTO big_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Togo pulaga pi pongo yereng Kapaneyam meiyaragi kambela. Yereng pura ngabelak Kalili meibekkera. Kanda pulogo wok puwili yawe mizi ono, puwiligu Anotoyegi ya kumulibek wok Sabatpek meibekke pi yongkambanuwili waligeleyagilege. ");
INSERT INTO big_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Keya pugu ngago waligeleyi pura kozanda kiling kopong puwili lelengkira logo pelik kisa, Pi ngai nak wezalik kozak kai kani, kisa. ");
INSERT INTO big_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Keya i walek songonomakke ige pulogo yombu kerewa nakko yenge yaga ngai yolu nak wiziya logo kerewabokko ngalizi pelik kek kai, ");
INSERT INTO big_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Aik, ni Yisu paka yereng Nasaretegabek. Ni teniyegi nangai miziweki mizi? Ni teni yeliweki pelege lewa logo teni kemenak yeik sa wazayiweki ma? Ni kaile nayendau ono Anotoyaga kayimabek purik ne iwaka, kai. ");
INSERT INTO big_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kapura Yisugu kerewabekyegi pelik ngalik meiya, Ngagoluk wizei, keya yombubekyaga kazi welagela kule, meiya. Keya yongkambanu pulogo ngai puwili kerewabokko yombubek pongo ngabelakke yomizora wezameli purikki pakela. Pilik miza logo kerewabek piyaga welagela kang kapura yombubekyegi watabi nayeng kelemiya ono. ");
INSERT INTO big_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yongkambanu pura pakela puwili yemane lelengkira logo puwili nakko nakyegi pelik mei yongomo mizi, Ngago pilik pera nangaira? Yombanu pobokki ngago kozang pangkara kiling perago kerewawili kazi kunibene yeiya logo puwili welagela kazi kang mizi pera, mei. ");
INSERT INTO big_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Keya pulaga ngago Yisuyegi langaira panga pulumengke yereng mabiyengke weik ululu miza mela. ");
INSERT INTO big_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Togo Yisu Yudawiligi i walek songono pumakka welagela logo pongo Simongki imakki kambela. Pi kanda yeke ige Simongki yongokpumelegi panumele kemegeme korikwek yezingei panu mizimekka mizi logo mizageya wizilege logo puwiligu Yisuyegi kemegeme pugumekki kozak meiya. ");
INSERT INTO big_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pi kerewiya logo piyegi saweliwei luweza logo pugu kemegeme korikwek yezingei mizi pumokki ngalik meiya logo kemegememek piyaga yeik logo pi nguk namizi yangalek meiya logo weik puwiligi ngeragi miza yowiya. ");
INSERT INTO big_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pilik miza logo yokmek kiliyawekke yongkambanu puwiligi ingembungang kemegeme nak nalangaimek kilingwili miza puwili mabuwili Yisuyegi iza orowei kanda pugu yongkambanu kemegeme mamokki ngalege mele puguyaugu walamiya logo puwili mabuwili yombiyangai sibene keleya. ");
INSERT INTO big_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Keya kerewawilirau weik yenge yongkambanuwiligi yungke ngaiweki kiliya yolu puwili yongkambanuwiliyaga welagela logo ngalizi pelik kisa, Ni Anotogi Marekpek kani. Pilik kisi legi Yisugu puwiliyegi ngago kisi nagani, yeiya purik Yisu pi Kilisibek Mesiya Anotogo yawe pigi yongkambanuwili yaliya wazayagi pura miziweki sawiyabek purik puwiligu iwaka kopong. ");
INSERT INTO big_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Togo wangane panu pura Yisu yangalek meiya logo yereng pura wiya logo pi ngezebek kabelak kuyangka ngagoluk nangezige waberek miziweki kambela. Pi talege miza legi yongkambanuwili piyegi suwei weli logo puwiligu pi yolok ngelawekke pelik meiya, Ni kang purik pangka ono legi teni kiling pelege yoluweki, meiya. ");
INSERT INTO big_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kapura pugu puwiliyegi pelik yeiya to mela, Ne yereng nayengkerau kangweki keya piyengke ngago wazono Anotogo ngai pugumekki ngai puragi kiliyagi puragira mabilik kozak yeiweki Anotogo ne pilik miziweki sawiya logo wezanelabek legi ne weik kang, yeiya. ");
INSERT INTO big_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tegi pi Anotogi ngago wazono pura Yudaya ngabelakpekke Yudawiligi i walek songonoyengke kozak yei yongomo miza. ");
INSERT INTO big_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Togo wok nakke Yisu panga kai kolamiya Kenesare meibekke ngezege luwe tawizeige yongkambanu kolokngagono pugu Anotogi ngagora kozak kairikki kerewiyagirikki wiyeke piyegi panga yungke mizi kayima. ");
INSERT INTO big_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pilik mizageya tawizeige pugu wang neyau kaingimbekke wizilege pakela logo yombanu watabisi uli puwili pulogo wangyau wiya logo kik kawek puwiligiyeng kaigesageya koyilege. ");
INSERT INTO big_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Puwili kaigesa logo Yisu nawili kiling wang naleige tameneng meiya logo wang pulei Simongkilei logo Yisugu Simongyegi pelik meiya, Wanglei panga kaibekke langai songono nangezi ulumiya to mele, meiya. Logo Yisu mogosa logo panga wang puleiga yongkambanu pulogo kaingimbekke wawere ula puwili waligeleya. ");
INSERT INTO big_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pi ngagora kozak yeiyageyara weik pugu Simongyegi pelik meiya, Ni panga kai kulakkabekke wanglei ulumiya to mele logo kik kawek inuguyeng yenge kaibekke watabisi uliweki wezameli, yeiya. ");
INSERT INTO big_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Logo Simongku pelik meiya to mela, Kiriwagabek, teni yaka kusage yawe mizageya koyima logo watabisi nawilirau ula ono kele kapura nugu pilik kai legi ne kik kawek tonuguyeng yenge kaibekke yungke kiliya wezamelagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Puwili pilik mizawekkerik watabisi keremungke ula logo kik kawekyendau koliweki mizi. ");
INSERT INTO big_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tegi puwiligi kewengke panga wang naleige koya puwiliyegi ngago yeiya, Ini kik kawekyeng ulumiweki teniyegi saweli koli, yeiya. Puwili kanda mabuwili ulumiya logo wangyau mabiyau watabisiwili mereng miza logo wilak logo kuneng kopong puwili kiling wang neyau yenge kaibekke kiliyaroweki mizi. ");
INSERT INTO big_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Tegi Simong keya Sebetigi marekyau Jems keya Yowan Simongki kewengkeyau kiling yombuwili purikki pakela logo lelengkira. Simong Pita lelengkira logo Yisugi wirege ulu wala logo pelik meiya, O Yemizibek, ne yombu kailebek mena ne wezaniya logo kazi kune, meiya. Kapura Yisugu Simongyegi pelik meiya, Kazi mizi nagani, watabisi uliweki yawe mizi purik segeya mabek weik nugu yongkambanuwili neyegi iza oroweiweki yawe mizagi kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Keya pulaga puwiligu wangyau paka kaingimbekke ngalege ulumiya wiya logo watabi mabiyeng wiya logo Yisu kiling saweliweki kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Togo kalike Yisu yereng narage pulogo tawizeige yombu kemegeme Leposimek meimokko kolabek weik lewa. Kemegeme Leposimek mei pumok korikwek sok mizimek keya korikwekke wizing lewa meli mizimek logo yongkambanuwiligu wizing piyeng kuming kelemiya purik puwilirau kemegeme leposi pumokka yela managi, legi yongkambanuwiligu kulili panu mizimek logo puwili nak leposimek kiling purik pilikpok kezanga mani mizimek. Yombanu pilikmek kilimbokko Yisu pakelawekke pigi wirege panga ngabelakke ingeyau laliya logo pelik kelegele meiya, Yemizibek, tamizeige nugu keli mabura nugu ne yombiyangai wazaniye logo yongkambanuwiligu neyegi kezanga nanagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Logo Yisu mele puguzik tungkula logo pi kebangkela logo Yisugu pelik meiya to mela, Nogo mizagi keli. Ni yombiyangai se, meiya. Logo nguk namizi mabuwekke yombubekyegi wizing leposi lewamek weik yeik logo pi weik yombiyangai sa. ");
INSERT INTO big_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pilik miza logo Yisugu piyegi pelik kozang meiya, Nugu peragi namele keya nakyegi kozak mei nagani, kapura tenigi lo Mosego kaiya puragi kiriwei mizimo. Ni Anotogi i walek yemanemakki yombu Anotoyegi kolak mizibokko ni yombiyangai sa wazaniyarikki pakelibene kune keya pulaga nugu pi wata namek Anotoyegi kolak mizagirikki wiyeke mana logo pugu ula logo waliya logo ni weik yombiyangai wazaniya puragi yongkambanuwiligu iwakagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kapura yombanu yakabok ngagoluk kambela ono logo ngereke ngago Yisuyegi langai pura weik yemane panu ululu miza logo yongkambanu kolokngagono kanda wawere uli logo ngago puguragi kerewiyiweki keya yombanu kemegeme nalangaiyengko mizi puwili yombiyangai wazayiweki. ");
INSERT INTO big_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kapura pi ngezebek yeke tek ngagoluk yongkambanuwili yolu onorikki kuna logo kanda pi waberek miza. ");
INSERT INTO big_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Togo wok nakke Yisugu yeke ige yongkambanuwili waligeleyageya wiziyarik Mosegi loragi waligeleyi nawili keya Palisi mei nawilirau mogosa koya. Palisiwili mei puwili yombanu Yuda kangka yemane Mosegi lo mabiyengki waberek panu kiriwei mizi keya puwiligi yelibungang kokawiligi ngago yogongyengkirau kozang panu kiriwei miza miziwili. Puwiliyaga nawili ngabelak Kalili meibekke yereng nayengka kayimawili keya nawili paka ngabelak Yudaya meibekke yereng nayengka kayimawili keya nawili paka Yirusalem yerendaga kayimawili. Anoto Yemizibekki kozanda Yisu kiling wizigeya Yisugu kemegemewili yombiyangai keleyi. ");
INSERT INTO big_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Keya yombanu nawili yombunak inge keya mele ibeng nak lalektikke ngalege wageliwei kanda puwili yeke ige Yisuyegi saweliwei wazamiyagi nobiyeng miza. ");
INSERT INTO big_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kapura yongkambanu kolokngagono liya kopong puwili kemegemebek yeke ige wageliwei lagi langai ono, legi puwili pi yeke imakke ngalege ngilirik neing wageliwei la logo lewelimbekke yungu narik tiya logo wibek lalektikka ngane miza logo yenge yongkambanuwiligi tepekke kemegemebek lalektikke wibekka Yisugi ingewerege kula. ");
INSERT INTO big_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pilik miza logo puwili Yisugu kemegemebek yombiyangai wazamiyagi langai purikki ngizi panu kumulirikki pugu pakela logo pugu kemegemebekyegi pelik meiya, Ei, nogo kaile nuguyeng weik tumula logo keremareke wezameli kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yisu pilik kai legi yombanu Mosegi loyengki waligeleyiwili keya yombanu Palisiwili meiwili ngezewili pelik kumula, Yombanu pobok tak? Yombanu ngabelakpekke nakkorau kaileyeng tumula logo wezamelagi ono, Anoto wamenakko keke mizagi. Tegi pugu kai purikku pi Anoto kiling pangka pangka kai yagenda, miza. ");
INSERT INTO big_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kapura Yisu puwiligu liwik kumula piyengki iwaka wiziga puwiliyegi pelik yeiya, Inuwa ya inuguyengke nangki pilik kumuli? ");
INSERT INTO big_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yawe nangaira yemane onora, kaileyeng tumula logo wezamelagira ma yombu inge keya meleyeng ibeng nak yombiyangai wazamiyagi pura? Tamizeige ne yaka inge keya meleyeng ibembekyegi pelik mei, Nogo kaile nuguyeng tumula logo wezamela, mei purik ini pi wameik kai ma ngaigu kai kisagi, kapura tamizeige ne yombu inge keya meleyeng ibembekyegi pelik mei, Yangalek meiya logo kune, mei purik ini ne wameikpek ma ngaigubek miza legi iwakaweki. ");
INSERT INTO big_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ne yombanu paka ngalega kayimabek logo yongkambanu ngabelakpekkewiligi kaileyeng tumuliweki pangkara kilimbek logo ini purikki iwakaweki nogo yaka yombu inge keya meleyeng ibembekyegi pelik mei yagenda, Ni yangalek meiya logo yolumek nuguyeng weiya logo i nugumakki kambele, mei yagenda. ");
INSERT INTO big_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nguk namizi mabuwekke yombanubek puwiligi wirege yangalekta luweza logo yolumek puguyeng weiya logo panga i ngezebekkimakke kunimowei Anotogi yeikta yongolok mei kuna. ");
INSERT INTO big_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pilik miza logo pakela pumok mamokko unatuba panu lelengkira logo puwili leli ulageya koyimowei Anotogi yeikta yongolok meiya logo pelik kisa, Mabek wokpekke pelege tonugu yaka watabi wazono panu nayengki pakela, kisa. ");
INSERT INTO big_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Keya pulaga waleleige Yisu ngabelak libu kang kunimowei tapakeleige yombu king takis weibek, yeikta Lebi meibek, opis pugumakke mogosa wizilege Yisugu piyegi pelik meiya, Ni ne kiling saweliweki kiriwei koli, meiya. ");
INSERT INTO big_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Logo Lebi yangalek meiya logo watabi pugu mizageya wiziya piyeng mabiyeng wiya wazamiya logo Yisu kiling saweliweki kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kalike wok nakke Yisuyegi weraga panga Lebigi imakke ngeragi yemane miza ni keya piyau kiling yombanu kolokngagono king takis wei piyengka nayeng ngowei miziwili keya yombanu kaile mizi nawilirau ngeragi niweki mogosa. ");
INSERT INTO big_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Yombu Mosegi loyengki waligeleyiwiligi ngai Palisi meimekka nawili Yisu kiling puwili nirikki pakela logo puwili sisik sara koyimowei kalike Yisugi yombu ngezebokko waligeleyi puwiliyegi munumunu yeiya logo puwiligu pelik nguk yeiya, Ini yombu king takis wei piyengka nayeng ngowei miziwili keya yombanu kaile mizi nawili kiling ngeragi ni mizira nangki? Ini pilik mizi purik pangka ono, yeiya. ");
INSERT INTO big_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Keya Yisugu puwiliyegi pelik yeiya to mela, Yongkambanu wazonowili totayegi kang ono, kemegemewili keke totayegi pakeli kangwili. ");
INSERT INTO big_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kazing mabilikmekke ne yongkambanu ngezewiligu ngezewiliyegi pangkawili mizi puwiliyegi kayima ono, ne yombanu kaile mizi puwiliyegi kayima logo puwili kazing kaile miziyengki kuneng miza logo kazing kaile puwiligi piyengka kowiti miza logo neyegi saweliweki ngago yeiweki kayima, yeiya. ");
INSERT INTO big_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Keya ngereke puwiligu piyegi pelik meiya, Yowan kaimelibekyegi kiriweiwili kazing wilek kang mabiyeng Anotoyegi waberek mizagirikki tiya maniweki ngeragi ni ono mizimek mizi keya yombanu Palisiwili meiwiliyegi kiriweiwilirau mabilik mizi kapura yombu ni makngezego waligeleyiwili kazing pumok mizi ono, puwili yeik ngeragi keya kai wik ni mizi. ");
INSERT INTO big_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Pilik meiya logo Yisugu pelik yeiya to mela, Yek tek nangezi yombanu yongok weiweki mizi nakyegi langai kumuli. Yongkambu weiwekkerik yombu yongok weiyagibokko ingenazewili ngeragi miza yaniweki miza logo yani wizigeya puwili wilik kagowindikku mizagewiyege pi kiling mogosa logo ni. ");
INSERT INTO big_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kazing mabilikmekke neyegi kiriweiwili ne kiling koyimowei menalege ngeragi ni kapura kalike yombanu neyegi kumbak mizi puwiligu neyegi kiriweiwiliyaga niza orowei puwekke puwili ya kunengmokko mizagewiyege kazing wilek kang mabiyeng Anotoyegi waberek mizagirikki tiya maniweki ngeragi ni ono mizimek mizagi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Keya kazing yombanu Palisiwili meiwiligi weremek keya Yisugi kazing wikmek sawela nelegi puwili waligeleyiweki Yisugu ngago saweliwei pera puwiliyegi kozak yeiya, Nakko melewangka wik narikka walerik ngela logo paka melewangka were koliyarikke lolo ulagi ono. Tamizeige pi pilik mizi purik melewangka wiktik kaile mizagi keya melewangka wererik ngoluk sobok wiziyagi. ");
INSERT INTO big_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Keya nakko kai waing wikpek keremiziwekkerik were pi kik wata korik wikyeng keremiza logo kai waing wikpek kubuli. Pi kai waing wikpek panga kik wata korik wereyengke kubulagi ono. Pi pilik miza purik kai waing wikpek sibesibe wari lewawekke wata korik wereyeng potora logo waimbek panga ngabelakke kubula welagi keya kik wata korikyeng yeikki. ");
INSERT INTO big_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Piliktikki wiyeke kai waing wikpek panga kik wata korik wikyengke kubuliweki. ");
INSERT INTO big_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Keya nakko yaka kai waing werebek na puwekke purik kai waing wikpek nagi keli ono pugu kaiyagirik, Kai waing werebek pangka mena, kaiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wok nakke wok Yudawiligi yawe mizi ono puwiligu Anotoyegi ya kumulibek logo wok Sabatpek meibekke Yisu kiling yombu ngezebokko waligeleyiwili yawe pandi wit nalei neing wei kambela logo yombu puguwili kunimowei wit wire pandiyeng kelikyengki wireyeng tiya logo mele puwiligiyengke pazipazi ngela logo wireyeng ni mizi kuna. ");
INSERT INTO big_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Puwiligu pilik miza purikki yombu Palisi mei nawiligu pakela logo pelik ngalik yeiya, Lo tonugurago wok Sabatpekke yawe mizi nagani kaiyara inuwago ngelira nangki, yeiya. ");
INSERT INTO big_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tegi Yisugu puwiliyegi pelik yeiya to mela, Inuwago Anotogi Kapiya Walektikke tenigi yelibungang kokawiligi ngaibek Tawitigu koka walaka miza purikki sangkela puragi kumuli. Wok nakke Tawiti keya pi kiling puwili yagasi miza, legi ");
INSERT INTO big_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tawiti Anotogi imakke yeke ige la logo ngaibekyegi nguk meiya logo iwing perek Anotogi mowiya piyengka weiya logo na keya yombu pi kilingwilirau yani miza. Puragi ini sangkela kapura ini ngizi iwaka ono. Lorago pelik kai, Iwing perek piyeng yombu yeikwili ni nagani, yombu Anotogi i walek yemanemakke Anotoyegi wata kolak kelibene miziwiligu keke nagiyeng, kai. Kapura Anotogo puragi ngalik kai ono, legi inuwarau negi yombu ne makngezego waligeleyiwiliyegi ngalik yei nagani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pugu pilik yeiya logo pugu mawinda pelik yeiya, Ne yombanu paka ngalega kayimabek, ne wok yawe mizi onobekki ngaibek keya ne watabi yongkambanuwiligu wok yawe mizi onobek Sabatpek meibekke mizagi piyengki kaiyagibek, yeiya. ");
INSERT INTO big_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pulaga wok Sabat nakke Yisu Yudawiligi i walek songonomakki yeke ige la logo yongkambanuwiliyegi kazing Anotogimek waligeleya. Pulogo yombu melelo ngaigera koru miza nak wizilege. ");
INSERT INTO big_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Keya Palisi pulogo koyilegewili keya Mosegi loyengki waligeleyi pulogo koyilegewilirau Yisuyegi ngai koya. Puwili Yisugu ngago kaile kai ma kazing korowali nayeng mizi purik kebangkelagiwili. Tamizeige pugu yombanu kemegeme nak wok yawe mizi onobekke yombiyangai wazamiyagi ma talik miza legi puwili mereke panu ngai koya. ");
INSERT INTO big_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kapura Yisugu kumula puwiligiyengki iwaka logo yombu melelora koru mizabekyegi pelik meiya, Yangalek meiya logo pewiligi wirege pelege koli, meiya logo yombubek yangalek meiya logo pulogo yongkambanuwiligi tepekke luweza. ");
INSERT INTO big_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Togo Yisugu puwiliyegi pelik yeiya, Nogo iniyegi nara nguk yeiweki, wok yawe mizi onobekke lo tonuwagirago pangka miziweki kaiyayeng nangaiyeng? Teni yombanuwiliyegi wazono miziweki kai ma kaile miziweki kai? Ma teni yombanuwiliyegi sawela logo wazono yolugiweki kai ma yela logo ibeng wazayiweki kai? Yisugu pilik yeiya logo puwili nakko ngago kanga nararau kaiya ono. ");
INSERT INTO big_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Togo pugu yombanuwiliyegi pakeli wei miza logo yombanubekyegi pelik meiya, Melelora tungkule, meiya. Pi pugu kai pilik miza logo mele puguzik weik ngereke yombiyangai sa. ");
INSERT INTO big_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kapura puwili sisikmokko kola logo Yisu talik kelemiyagi miza legi ngezewili kozak keli yongomo mizi. ");
INSERT INTO big_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pulaga Yisu paka lewakpekke waberek miziweki kambela logo kusabok mabok pi Anotoyegi waberek mizageya wizagoma. ");
INSERT INTO big_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wangane pura pugu piyegi kiriweiwiliyegi wiriyibene ngago yeiya logo pugu puwiliyaga meleyau keya pongo inge nazikka neyauwili yawe pugura miziweki iza. Pugu puwili yeik, Aposolo pura yana logo purikku kai purik ngago pugura orowei miziwili, kai yagenda. ");
INSERT INTO big_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Puwiligi yeikyeng peyeng, nak Simong Yisugu Pita meibek, keya pigi sakpek Enduru, keya neyau Jems keya Yowan, keya Pilip keya Patolomiyu, ");
INSERT INTO big_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","keya Matiyu, keya Tomasi, keya Alapiyagi marekpek Jems, keya Saimon. Saimon yombu Selete Yudawili Romwiliyaga yaliya wazayiweki liwik yawe miziwiliyaga nak logo puwiligu pi Saimon Seletebek mei. ");
INSERT INTO big_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Keya Yuras Jemsgi marekpek, keya nak Yuras Isaliyoto kalike Yisu ulagiwiliyegi miza yanagibek. ");
INSERT INTO big_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Keya pulaga Yisu paka lewakpekka puwili kiling yerageya logo kanda ngabelak kolangkabekke piyegi kiriwei nawilirau koyilege puwili kiling luwe wiziya. Yongkambanu kolokngagono nawilirau pulogo koya. Puwiliyaga nawili paka ngabelak Yudaya meibekke yereng nayengkawili keya paka Yirusalem yerendaga keya pongo Taya keya Sairong yereng kai wizambekkiyaugamektau logo mamok pulogo koya. Puwili ngago puguragi kerewiyi keya yombiyangai wazayiweki kayimawili ");
INSERT INTO big_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","keya yombanu kerewawiligu lelewe keleyi puwilirau kayima logo pugu yombiyangai keleya. ");
INSERT INTO big_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kozang Anotogira Yisuyaga kemegemewiliyegi kuna logo puwili yombiyangai keleyagi legi yongkambanuwili mele puwiligiyengko piyegi sawelagi nobiyeng miza. ");
INSERT INTO big_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pilik miza logo Yisugu yombanu pugu waligeleyiwiliyegi pakela logo pelik yeiya, Ini yombanu watabiyengki yeik puwili ini wilikwilik miziweki, purik Anoto weik ngai inugubek logo ini ngai pugu ngai yolu puragawili legi. ");
INSERT INTO big_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ini yombanu mabek yagasi yolu puwili wilikwilik miziweki, purik ini kalike wilakkiwili legi. Ini yombanu mabek ingkisageya yolu puwili wilikwilik miziweki, purik kalike ini songomeiyagiwili legi. ");
INSERT INTO big_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kalike ne yombanu paka ngalega kayimabekki weraga yombanuwili iniyegi kumbak mizi ma iniyegi kezanga yani ma iniyegi korowali kaile yei ma yeik inuguyengki kaile keleyi puwekke ini wilikwilik miziweki. ");
INSERT INTO big_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Koka puwiligi yelibungangwiligu mabilik panura yombanu Anotoyaga ngagora weiya logo kozak kisawiliyegi keleya. Keya puwiligu iniyegi pilik mizagi kani. Logo puwekke ini wilikwilik yemane panu miziweki, purik paka ngalege inugu watabi miza piyengki wiyeke kanga wazono weiyagiyeng yemane legi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yisu pilik yeiya logo yombanu nawiliyegirau pakela logo puwiliyegi pelik yeiya, Kapura ini yombanu mabek watabi keremungkeyeng kiling puwili ini waberek ngaiweki, purik ini watabi inugu miza piyengki kanga wazonoyeng weik mabiyeng mabelege weiyageya koyinda, paka ngalegerau weiyagi ono legi. ");
INSERT INTO big_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ini yombanu mabek weik wilak yolu puwili ini waberek ngaiweki, purik ini kalike yagasi mizagi legi. Keya ini yombanu mabek weik songomeiyageya puwili ini waberek ngaiweki, purik ini kalike ingkisagi keya wireyengka ingkilakyeng walagi legi. ");
INSERT INTO big_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kokarik inigi yelibungangwiligu yombanu pobilik ngaigu kisa puwili, Teni Anotoyaga ngago iniyegi yeiyagira weiya, kisa puwiligi yeikyeng yongolok meiya purik ngago ngizi ono puwiligu kozak kisayengko puwili wilik kagowing keleya kopong, keya tamizeige yombanu mamokko weik pilik yeik inuguyeng yongolok mei mabura ini waberek ngaiweki. Purik purikku walimizi purik ini Anoto wilik kagowing kelemi ono. ");
INSERT INTO big_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kapura nogo ini ngago nogora kerewiyagi mabuwiliyegi pelik yei, Ini yombanu iniyegi ngai miziwiliyegi kelizo. Keya inugu yombanu iniyegi kumbak mizi puwiliyegi wazonoyeng keke mizizo. ");
INSERT INTO big_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Keya inugu yombanu iniyegi watagak ngeli puwiliyegi wazono mizizo. Keya puwiliyegi langai wazono yeizo. Keya inugu yombanu iniyegi kaile keleyi ma iniyegi langai kaile kisiwiliyegi Anotogo sawelibene waberek mizizo. ");
INSERT INTO big_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tamizeige nakko wiregawere nuguraga nazuwaga melegozok neli mabura ni tolikta sa logo pugu ngereke wiregawere nuguragarau nazuwaga melegozok nelibene kelemimo. Tamizeige nakko kagorik yeke ngalege nigi waliya purik orowei purik mabura melewangkariktau weibene kelemimo. ");
INSERT INTO big_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tamizeige nawiligu niyegi watabi nayeng yaniweki kisi mabura nugu puwili yanimo ma tamizeige yombanu nakko watabi nigi nayeng orowei purik mabura ngereke weiweki nguk mei nagani. ");
INSERT INTO big_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kazing yongkambanuwiligu iniyegi keleyibene inugu keli pumokko inugu mabilik puwiliyegirau keleyizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Keya Yisugu mawinda pelik yeiya, Yongkambanu mabuwiligu mizirik yombanu puwiligu keli puwiliyegi puwili keli. Yongkambanu kaile miziwilirau pilik miziwili. Tamizeige ini yombanu iniyegi keli puwiliyegi inugu keke keli purik Anotogo ini wazono miza yeiyagi ono. Inugu yombanu iniyegi keli ono puwiliyegirau kelizo. ");
INSERT INTO big_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yongkambanu mabuwiligu mizirik yombanu puwiliyegi wazono mizi puwiliyegi puwili wazono mizi. Yongkambanu kaile miziwilirau mabilik miziwiligu keya tamizeige ini yombanu iniyegi wazono mizi puwiliyegi inugu wazonoyeng keke mizi purik, Anotogo ini wazono miza yeiyagi ono. Inugu yombanu iniyegi wazono mizi ono puwiliyegirau wazono mizizo. ");
INSERT INTO big_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yombanu kaile miziwiligu nawili watabi yanirik puwiligu teniyegi pangka pangka kanga yo melagi miza koyimowei watabiyeng yani. Kapura tamizeige ini yombanu ini kanga yanagi langai pilik puwiliyegi keke yani purik, Anotogo ini wazono mizi yeiyagi ono. Ini yeik yanizo. ");
INSERT INTO big_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Inugu yombanu iniyegi ngai miziwiliyegi kelizo. Keya puwiliyegi wazono keleyizo. Keya kangayeng weiweki miza yolu nagani, puwili watabiyeng yeik yani logo kalike ini Anotoyaga inugu watabi mizayengki wiyeke kanga wazono weiyagiyeng unatuba panu weiyagi. Keya inigi kazing miziyengko ini Anoto Yemizi Lewege Panubekki yango keya marekngangwili yolu mizagi. Purik pi yongkambanu kaile piyegi wazono mei ono keya kaile kaile mizi puwiliyegirau wazono mizibek. ");
INSERT INTO big_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Inugu nazuwagawiliyegi yalek panu mizizo Anotogo iniyegi yalek panu mizi mabilik. ");
INSERT INTO big_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nugu nakyegi melebek yowi purik Anotogo niyegi melebek yowagi, legi nakyegi melebek yowi nagani. Keya nugu nakyegi pakela logo pelik mei, Nugu kaile miza legi ni ngangang mizagi mei purik, Anotogo niyegi mabilik kaiyagi legi nugu pilik mei nagani. Kapura nugu nawiligi kaile mizi piyeng keremareke wezameli purik, Anotogo kaile nugu mizi piyeng keremareke wezamelagi kani. ");
INSERT INTO big_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nugu nazuwagawiliyegi keleyi pilik Anotogo niyegi keleniyagi kani. Anotogo nugu keleyi piyengki pangka pangka keleniyagi keya mawiyarekka miza logo niyegi yemane panu keleniyagi. Tegi kazing nugu nazuwagawiliyegi pilik keleyi pumokki pangka Anotogo mabilik niyegirau keleniyagi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pulaga Yisu puwiliyegi ngago saweliwei perarau pelik kozak yeiya, Yombanu wireyau kusa nakko yombanu wireyau mabilik kusa nak miza orowei kunagi ma yeik? A’a’. Tamizeige piyau pilik kuna purik mabiyau kawiye walagi. ");
INSERT INTO big_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mandik kapiya mizi nakko waligeleyi pugubekyegi lewege mizagi ono, a’a’. Pi were kemenak waligelemiya logo purik mabura pi waligeleyi pugubek kelikki. Pilik mena waligeleyi inugubek kelik sizo logo inugu yombanu wireyau kusabekyegi pangka sawelagiweki. ");
INSERT INTO big_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ni yombanu nakki wirebekke kulugulurik pakela mowiyi kapura ni makngezegi wirebekke wak yolu puleigi pakeli onora nangki? ");
INSERT INTO big_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ma ni wire ni makngezegibekke wakleigu talik pakelagi mizageya wizimowei ni nangki nakyegi pelik mei, Koli, nogo kulugulu wire nugubekke yolu purik wameliweki mena, mei? Ni yombanu kiligang neyau lewabek kani. Wak wire ni makngezegibekke yolu pulei were wamela logo ni wireyau pangka ngai panu wizimowei nakki kulugulu wirebekki purik wameli mangine. ");
INSERT INTO big_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yengelei wazonoleigu wilek korowaliyeng wiragi ono, ma yengelei kaileleigu wilek wazonoyeng wiragi ono. ");
INSERT INTO big_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yengeleileigi wilekyengko yengeleilei ngenangailei mizi, purik teni yongkambanuwili were yengelei wilekyengki pakeli, wazonolei ma kailelei miza legi. Teni ngoyei wilekyeng mabung ingakmerekka tiyi ono kani ma kopi wilekyeng ingakmerekka tiyi ono kani. ");
INSERT INTO big_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pilik tegi yombanu wazonobek kumuli wazonoyeng yenge ya puguraga wara yolu. Pilik kopong pi kazing wazonoyeng mizi mizi kapura yombanu korowalibek kumuli korowaliyeng yenge ya puguraga wara yolu kopong pi kazing korowaliyeng mizi mizi. Togo kilirago kai piyeng yenge yaga kolokngagono yolulikyengka kaiyengko, yeiya. ");
INSERT INTO big_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yisugu pilik yeiya logo yeke langak pelik yeiya, Inugu neyegi, Yemizibek, Yemizibek, kisi kambeli kapura kili nogorago ini mizizo kaiya piyeng ini waberek kerewiya logo mizi ono. Ini pilik pura nangki? ");
INSERT INTO big_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ne kazing saweliwei pemek yombanu neyegi lewa logo ngago nogoyengki kerewiyi keya ngago piyengko miziweki kai piyeng mizi pumologabok talik melegabek miza purikki kozak yeiweki mena kerewiya koyi. ");
INSERT INTO big_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yombanu pumologabok yombu i namak ngiziweki mizibok kelik. Pi i pugumak paka ngabelak kingyeng kilimbekke ngalege ngiza. Pilik ngiza logo kailing unatuba kai ngai kaiyageyara i pumak topela melagi nobiyeng kelemiya kapura imaktau urukang mizi ono, purik imak kingyengki ngalege ngiza kopong kozang wiziya. ");
INSERT INTO big_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kapura yombanu ngago nogoragi kerewiya kapura purago miziweki kai piyengki kiriwei miza ono pumologabokyegirik pelik, pi i pugumak paka ngabelak kingyeng kilimbekke ngiza ono, pi kaingimbekke yeik ngiza logo kailing unatuba kai ngai kaiyageyara imak urukang kelemiraige nguk namizi kawiye wala logo kemenak neneng ngela mela. Pilik legi ngago nogoyengki wazono kiriwei mizi ono puwili kawiye wala logo neneng ngela melagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yisugu yongkambanuwiliyegi ngago kerewiyagiyeng mabiyeng kozak yeiya logo pi panga Kapaneyam yerengke kambela. ");
INSERT INTO big_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Panga pulogo Rom Amiwiligi ngai nakyegi yawe mizibek logo ngaibokko keli panubek kemegeme mizi logo ibengweki mizi. ");
INSERT INTO big_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Togo Rom Amiwiligi ngaibek Yisu weik lewa purikki kerewiyawekke, pugu Yudawiligi yemane nawili wezayela logo Yisuyegi nguk meiya logo pugu kanda piyegi yawe mizibek yombiyangai wazamibene. ");
INSERT INTO big_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Puwili Yisuyegi kanda puwiligu piyegi yaka purikki kozang panu nguk meiya logo piyegi peliktarau meiya, Rom Ami ngai pobok yombu wazono panubek logo ni piyegi pangka sawelagi langaibek, ");
INSERT INTO big_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","purik pi Yuda onobek kele kapura pi teni Yudawiliyegi kelibek keya mabilik teni Yudawiligi i walek namak ngiziweki king wiyabek togo nugu piyegi saweli purik pangka. ");
INSERT INTO big_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tegi Yisu puwili kiling Rom Ami ngaibekki imakke kambela. Yisu imakke ngezege mereke lewagela pura Rom Ami ngaibokko nawili Yisuyegi ngago pelikta kiling wezayela, Yemizibek, mabilik wizei. Ne pangkabek ono logo ni i nogomakke wiriyagi purik pangka ono. ");
INSERT INTO big_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Keya nogo kumularik ne yombiyangaibek ono logo ne niyegirau kangki ono kapura nugu mabulaga wizimowei yeik ngago yeiktago kai logo kemegeme neyegi yawe mizibekyegi pumok yeik sibene mei. ");
INSERT INTO big_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Purik nerau ngai yemizibekyegi kulengke yolu logo ne watabi pugu kai piyeng mizi mizibek keya ami nawili neyegi kulengke yoluwili. Logo nogo nakyegi, Kune, mei purik pi kang. Keya nogo pangabokyegi, Ni koli, mei purik pi lewa. Keya nogo neyegi yawe mizibekyegi, Pera mize, mei purik pi mizi. Kazing mabilikmekke ngago nugura kozanda kiling logo nugu yeik ngagorago kai purik yombanu neyegi yawe mizibek yombiyangai kelemiyagi, legi yeik ngagorago kai, meiya. ");
INSERT INTO big_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yisu ngago puragi kerewiya logo lelengkira logo pugu yongkambanu piyegi kalika kiriwei wiriya puwiliyegi langai kowita logo pelik yeiya, Kerewiyi. Yombu Yuda ono pobokko neyegi kozang ngizi panu kumuli kapura yongkambanu nalagawiliyaga nak ma Isileili mabuwiliyaga nakkorau neyegi pilik ngizi panu kumuli ono, yeik, yeiya. ");
INSERT INTO big_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pilik miza logo yombanu ngagora orowei kambelawili Rom Ami ngaibekki imakke kandobela logo puwiligu yombu ngaibekyegi yawe mizi kemegeme wiziyabek weik yombiyangai wizilege pakela. ");
INSERT INTO big_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pura pilik miza logo waleleige Yisu panga yereng yeikta Nen meirage kambela. Yombanu pugu waligeleyiwili keya yongkambanu kolokngagonowilirau pi kiling kambela. ");
INSERT INTO big_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Puwili yereng puragi kawaktage tabunda pura yombu yereng puragawili yombu nawekke ibeng nak waliyiweki wageliwei lewa puwili miza. Yombu ibembek yongok komate namelegi marek wamenakpek. Keya yongkambanu kolokngagono yerendage pulogowili yongok komatemolo kiling koyilege. ");
INSERT INTO big_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Logo Yemizibokko yongokmoloyegi pakelawekke pugu piyegi yalek miza logo pugu piyegi pelik meiya, Ingkei wak, meiya. ");
INSERT INTO big_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pugu pilik meiya logo panga mereke kuna logo lopongleige kebangkela logo yombanu loponglei wageliweiwili weik leng miza. Keya Yisugu pelik meiya, Mandikpek. Yangalek mei, meiya. ");
INSERT INTO big_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yombu ibembek yangalek meiya logo mogosa wizimowei weik ngago kai. Togo Yisugu yongok komatemeleyegi pelik meiya, Nigi marekpek wik wizinda mena ya, meiya. ");
INSERT INTO big_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pilik miza logo pakela pumok mamok lelengkira logo leli ulageya koyimowei Anotogi yeikta yongolok meiya logo pelik kisa, Yombu Anotoyaga ngagora weiya logo kozak kai yemane nak tenigi tepekka lewagela, kisa keya peliktau kisa, Anoto teni yongkambanu puguwiliyegi saweli keya yaliya wazayiweki weik lewa. ");
INSERT INTO big_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Togo ngago Yisuyegi langai pera Yudaya ngabelakpek keya pulumengke yereng piyengke weik ululu miza mela. ");
INSERT INTO big_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Pulaga Yowan kaimelibek wigirimakka wigira wizigeya pugu waligeleyiwiligu piyegi yaka miza piyengki kozak meiya. ");
INSERT INTO big_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tegi Yowan kaimelibokko puwiliyaga neyau piyegi wiriyibene ngago yeiya logo piyau Yemizibekyegi nguk meibene ngago pelikta kiling wezayela, Ma ni yombanu yemizi ulogo kalike lewagi kaiya mabok ma teni ngoluk nakyegi yuke yolugi, meiya. ");
INSERT INTO big_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Piyau Yisuyegi kandawekke Yisugu yongkambanu kolokngagono kemegeme nalangai nalangai mizi puwili yombiyangai wazayageya wizilege piyaugu pakela. Keya piyaugu Yisugu kerewawili yongkambanuwiliyaga welagela wezayelageya wizilege pakela, keya yongkambanu wireyeng kusawili weik pakeliweki keleyageya wizilege piyaugu pakela. Piyaugu Yisuyegi pelik meiya, Yowan kaimelibokko niyegi pilik nguk neiweki te wezayela logo pugu pelik kai, Ni yombanu yemizi ulogo kalike lewagi kaiya mabok ma teni ngoluk nakyegi yuke yolugi ma talik, kai, meiya. ");
INSERT INTO big_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tegi Yisugu piyauyegi pelik yeiya to mela, Yowanyegi yaligu mabek pakeli keya kerewiyi miza piyengki kozak meizo. Piyeng pelikyeng, wireyeng kusawili ngereke pakeli, keya inge keya melegawere ibengwili keya inge koruwili ngereke yongomo mizi, keya kemegeme Leposimek meimek kilingwili ngereke korikyeng yombiyangai wazayi, keya kerangangyeng waliyawili ngereke kerewiyi, keya ibengwili ngereke yangalekta wik yolu keya yongkambanu watabiyengki yeik puwili Anotogi ngago wazono puragi kerewiyi. Yaligu Yowanyegi piyengki kozak meiweki kandobeli. ");
INSERT INTO big_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Keya perarau yaligu piyegi kozak meizo, Ne yombanu kalike lewagi kaiya mabok logo ngizi panu kumuli keya purikki kangka neyau onobekyegi wilikwilikta yolu, meizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yombanu ngago Yowangira weiyayau weik kuna wizigeya Yisugu Yowanyegi langai yongkambanu wawere ulawiliyegi pelik kozak yeiya, Ini kurung yeik Yowan kaimelibokko wizagomawekke kambela puwekkerik ini nangaiyengki pakeliweki kambela? Ini Yowan yengelik kebarekpokko orowei mizi piyeng kelik kozang ono nobiyeng pakeliweki kambela? A’a’. ");
INSERT INTO big_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mabura ini nangaiyengki panga pulogo pakeliweki kambela? Ma yombu nak watabi wik wazono nayeng wakiyabekyegi pakeliweki kambela? A’a’. Yombu wik pilik piyeng wakiyi keya watabi kolokngagono piyeng kiling puwili yombanu ngai yemanewiligi i wazono yemane piyengki keke yoluwili. ");
INSERT INTO big_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Logo ini yombu pilikpok pakeliweki kambela ono mena, takyegi ini pakeliweki kambela? Ma ini yombu Poropek mei, yombanu Anotoyaga ngagora weiya logo yongkambanuwiliyegi kozak kai nakyegi pakeliweki kambela? Ei, wameik. Kerewiyi. Yowan yombu Anotogi poropek pilikpek kele kapura pi poropekwiliyaga ngalegebek. ");
INSERT INTO big_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Purik pi mabokyegi langai Anotogi Kapiya Walektikku ne pigi Marekpekyegi pelik kaiya, Kerewiye, ni kalika kangkine kapura nogo were ngago nogora oroweibek wezamelagi. Pi nigi kazing kunagimek kangkere mizagi, kaiya, yeiya. ");
INSERT INTO big_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yisugu mawinda pelik yeiya, Ngago nogora wameik kani kerewiya koyizo. Yongkambanu ngabelakpekke wizageya koyi kayimi pewiliyaga Yowan ngalege panubek kapura pewekka yombanu yeiktarau ono nak ngago nogoragi kerewiya logo nogo piyegi ngaiweki keleni mologabok Yowanyaga ngalege panumele keya pek mizagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Puwili mabuwili Yisugu kai puragi kerewiyawekkerik yongkambanu yeikwili keya yombu king takis weiwilirau Yisugu kai puragi wilik. Togo puwiligu pelik kisa, Wameik, Anotogo kazing tenigi keremizi pumok pangkamek, kisa. Puwili ulogo Yowangi ngagoragi ngizi panu kumula logo kaile puwiligiyengka kowita logo Yowangu kaimelawili. ");
INSERT INTO big_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kapura yombu Palisiwili meiwili keya Mosegi loragi waligeleyiwili Yisugu kai puragi kiyebuk, purik puwili Anotogo Yowan wezamela ono miza logo pugu kazing wazono waligeleya pumokki kiyebuk keya kezanga mana kopong Yowangu kaimela onowili. ");
INSERT INTO big_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Togo Yisugu puwiliyegi pelik yeiya, Mena, nogo ini yongkambanu mabek perage ngabelakpekke yolu pewili watabi nangaiyeng kelik kaiyagi? Nogo iwaka logo nogo kozak yeiweki. ");
INSERT INTO big_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ini koloyakamandik songono yerengke karagare miziwili kelik. Nawiligu nawiliyegi pelik yei, Teni yongolo uliwekke ingimei kapura ini teni kiling yongolo uli ono. Keya teni ingi yalekkiyeng mei kapura ini purikkirau kiyebuk kopong teni kiling ingi yalekkiyeng mei ono, yei. Logo pilik mizi purikku kai pura ini Yowan kaimelibokko ngago kaiyeng ma nogo ngago kai piyeng ma mizi piyengki kiyebuk. ");
INSERT INTO big_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Purik Yowan kayimawekke pi pereksik keya kai waimbek ini Palisiwiligu ni pilik na ono purikki ini kiyebuk keya inugu pi Anotogo wezamelabek kisagirikki kiyebuk kopong inugu kerewa nak pigi yungke yolu kisa. ");
INSERT INTO big_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Keya mabek ne yombanu paka ngalegabek kayima logo ne ngeragi ni keya kai waimbek ni puriktau ini kiyebuk keya inugu pelik kisi, Keriyi, pi ngeragi momanengka nibek keya kai waing kolokngagono nibek, kisi. Keya peliktau kisi, Pi yombanu king takis wei piyengka nayeng ngoweiwili keya kaile mizi nawili kilindau kewengke mizibek, kisi. ");
INSERT INTO big_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ini te Yowangu kisi piyengki kezanga mani kele kapura, Anoto iwakaragi mangobek legi pigi yango keya marekngang pugu kaiyeng mizi mabuwiligu piyegi pelik kisi, Anoto wameik pangka mizibokko, kisi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wok nakke yombu Palisi yeikta Saimon mei nakko Yisu i pugumakke pi kiling ngeragi niweki lewaweki meiya logo Yisu pi kiling i pugumakke kambela logo ngeragi lalektage mogosa. ");
INSERT INTO big_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yereng perage yongok kazingke namele yolu. Pi Yisu yombu Palisibekki imakke ngeragi nirikki kerewiyawekke pugu weli kelebak wazono kukngizi keli king yemane wezamela nak weiya logo pi i Yisu mogosa pumakke yabela ");
INSERT INTO big_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","logo pi Yisugi ingeyauge ngezege luweza wizimowei ingkeiya. Ingkilak wala mabokko inge puguyau kaigesa wazamiya. Pilik miza logo morogulung meiya logo sakela inge Yisugiyaugebek kebi nganelek yokolong ngezemelegirago tumula logo inge puguyau songok kuli keya weli kukngizi keli yakabokka inge puguyauge weli mela wazami kelemiya. ");
INSERT INTO big_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pilik miza logo yombu Palisi Saimon yaka Yisuyegi lewaweki meiyabokko yongok pumologo mizi puragi pakelawekke pi ngezebokko ngezebekyegi pelik kumula, Tamizeige yombu pobok wameik ngizi ngagora Anotoyaga weiya logo kozak kaibek kesak pugu yongokmolo talik mologo pi kuming kelemi miza purikki moloyegi iwaka si kak keya pi yongok pumolo kaile kaile mizimele purikki iwaka si kak, pilik kumula. ");
INSERT INTO big_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yisu Saimongu kumula yolu puragi iwaka legi pugu yombanubokko kumula yolu puragi langai pelik meiya to mela, Saimon, ne ngago niyegi kozak neiyagi nara, meiya logo Saimongu pelik meiya to mela, Ei, Kiriwagabek, pangka mena kozak nei, meiya. ");
INSERT INTO big_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tegi Yisugu ngago saweliwei nara piyegi pelik meiya, Yombu neyau nakyaga king wangki kanga managi nayeng weiya, logo nak 100 Kina weiya keya nak 10 Kina wei miza. ");
INSERT INTO big_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pilik miza logo kalike teng kanga managira lewagela kapura piyau kingki yeik legi king kangayeng managi langai ono. Togo yombu yaka piyauyegi kingyeng yanabokko piyau mabiyaugi yeikyau kapiyarikka tumula logo piyauyegi, Mabilik, yeiya. Nogo yaligi yeikyau tumula logo keremareke wezamela, yeiya. Pi pilik kai legi yombu piyau piyegi wilik miza. Pulaga Yisugu Saimonyegi pelik nguk meiya, Mena, yombuyauyaga takko kingyengki mangobekyegi wilik yemane panu mizagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tegi Saimongu pelik meiya to mela, Nogo kumularik yombu king yemane kanga managiyeng tumulabok, meiya. Togo Yisugu pelik meiya, Wameik. Ngizira nugu kaiya yo meli pura, meiya. ");
INSERT INTO big_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Togo Yisu kowita logo yongok yakamoloyegi keriya logo Saimonyegi pelik meiya, Yongok pemeleyegi pakele. Ne i nugumakke yabekeya pewekke nugu kazing tonugumekke kiriwei kai wik inge nogoyau kaigesagi nak nana ono, kapura yongok pemelegi ingkilakpokko inge nogoyau kaigesa nowiya logo kebi nganelek pugurago sakelabek tumula nowiya. ");
INSERT INTO big_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Keya ne i nugumakka yabekeya pewekke nugu kazing tonugumekke kiriwei ne songok kula ono kapura ne ige pelege yabekeya logo yolu perik pi ngoluk inge nogoyau songok kulageya yolu pera. ");
INSERT INTO big_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Keya ne yabekeya pewekke nugu kazing tonugumekke kiriwei kebi nogorage weli nakko pukmela wazaniya ono kani, kapura pugu weli kukngizi kelibokko inge nogoyau mabiyau weli mela wazaniya kani. ");
INSERT INTO big_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tegi kerewiye, yongok pemeleyegirik, keli unatuba pigi neyegi purago kaile kolokngagono pugu miza piyeng tumula logo keremareke wezamela purikki walimizi yagenda. Kapura yombanu kaile pugu mizayeng songono miza logo pugu miza piyeng tumula logo keremareke wezamela mologabok pugu kaile miza piyeng tumulabekyegi kelirik mabilik songono, meiya. ");
INSERT INTO big_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yisugu Saimonyegi pilik meiya logo yongok yakamoloyegi pelik meiya, Nogo kaile nuguyeng tumula logo keremareke wezamela kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yisu pilik kai legi yongkambanu pi kiling ngeragi lalektage pulogo mogosa koyawili ngezewiligi tepekke pelik kela yongomo mizi, Yombu pobok tak logo pugu kaileyeng tumula logo wezameli purarau mizi, kisa. ");
INSERT INTO big_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kapura Yisugu yongokmeleyegi pelik meiya, Nugu neyegi ngizi kumulirikku kaileyengki kozandaga yaliya wazaniya kani ni weik wilek kang ngezege sabek kiling kambele, meiya. ");
INSERT INTO big_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wok nayeng miza logo Yisu yereng songonoyeng keya yemaneyengke yongkambanuwiliyegi ngago wazono Anotogo pigi ngaimekki ngai yolu puragi kozak yei yongomo mizi kambela. Keya yombanu meleyau keya pongo ingenazikka neyau ngezebokko waligeleyi puwili pi kiling kambela. ");
INSERT INTO big_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Keya yongok kolokngagonowilirau puwili kiling kambela. Yongok puwiliyaga nawili ulogo kemegeme mizawili keya nawili ulogo kerewawili yenge ya puwiligiyengki yungke ngai koyawili kapura Yisugu kerewawili wezayela logo yongokwili mabuwili weik wazonowili. Puwiliyaga namele Maliya Matalena ulogo Yisugu kerewa melenazik keya nazikka neyauwili piyaga welagela wezamelamele. ");
INSERT INTO big_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Keya namelerau Jowana, Susagi yongokpumele. Susa pok Elodogi i yemanemakke ngaibek. Keya namelerau Susana. Puwili Yisu keya yombu pi kilingwiliyegi king keya watabi ngezewiligiyengka sawela logo puwiliyegi waberek ngai kayimawili. ");
INSERT INTO big_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yereng mabiyengka yongkambanuwili Yisuyegi lewageyageyara weik kolokngagonomek wawere ula wizigeya Yisugu ngago saweliwei nara pelik yeiya, ");
INSERT INTO big_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Wok nakke yombu nak pandi wilek puguyeng yawege wezameli kambela. Pi wilekyeng wezameli kunarik wilek nayeng ngabelak kozang yongkambanuwiligu wei mizibekke wala logo yongkambanuwiligi ingeyengko momaneng kelemiya logo pulaga winakwiligu na. ");
INSERT INTO big_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Keya wilek nayeng ngabelak king yemaneyeng kilimbekke ngalege wala logo lewa kapura ngabelakpek putiya ono kopong ibeng. ");
INSERT INTO big_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Keya wilek nayeng ibek ingakyeng kilingyengki tepekke wala logo lewa kapura ingak piyengko momanenda wiya logo pengyeng ibeng sa. ");
INSERT INTO big_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Keya wilek nayeng ngabelak yombiyangaibekke ngalege wala kopong marekyeng lewa wizigeya yemane sa logo wilek wazonoyeng wira. Wilek wirayeng yemane panu wiri miza, yeiya. Yisugu pilik yeiya logo mawinda pelik yeiya, Ini kerangangyeng kilingwili mabura kerewiyi. ");
INSERT INTO big_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yombu Yisu ngezebokko waligeleyiwiligu piyegi pelik nguk meiya, Ngago saweliwei yaka nugu kai puragi solorik taliktik, meiya puwekke, ");
INSERT INTO big_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yisugu puwiliyegi pelik yeiya to mela, Anotogo ini ne kiling sawela puwiliyegi watabi Anotogo pigi ngaimekki ngai yolu puragi koka iwaka ono piyeng kimeike kelemiweki keli logo nogo iniyegi saweliwei purago kai puragi kozak yeiweki mizi. Kapura yongkambanu ne kiling sawela ono puwiliyegi nogo ngago saweliweiyengke kozak yei. Purik puwiligu wire puwiligiyengko yawe nogo miziyengki pakeli kele kapura puwili ngizi pakeli ono keya puwili ngago nogo kai puragi kerewiyi kele kapura ngizi panu kumuli ono, yeiya. ");
INSERT INTO big_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Togo pugu kiriweiwiliyegi pelik yeiya, Ngago saweliwei puragi solorik pelik, Pandi wilek yaka wezamela piyeng Anotogi ngagora kani. ");
INSERT INTO big_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Keya ngabelakpek yongkambanu ngago wazonora kerewiyi puwili kelik. Logo ngabelak kozang wilek nayeng wala logo winakwiligu kanda nabok yongkambanu Anotogi ngagora kerewiyi kapura ngizi kumuli ono puwili kelik logo puwili ngagora kerewiya logo pulaga Sadangko kanda ngago pura kangka puwiligiyengka puwili Anotoyegi ngizi panu kumula logo pugu yaliya wazaya nelegi ngagora weiya logo wezameli. ");
INSERT INTO big_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Keya ngabelak kingyeng kilimbok yongkambanu Anotogi ngagoragi kerewiyi nawili kelik logo pura weiyagirikki wilik keya wilek marekyengki puliliyeng yenge ngabelakke kiliya kula ono mabilik puwili ngago puragi kumula kapura wilek kang puwiligiyengke yenge yungke kiliya panu ono, logo kunengyeng lewa ma Sadangko puwiliyegi yang keleyiweki lewa puwekkerik puwili Anotoyegi kezanga mani logo puwiligi ngizi kumulira yeikki. ");
INSERT INTO big_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Keya ngabelak ibek ingakyeng kilimbok, yongkambanu Anotogi ngagora kerewiya nawili kelik logo puwili Anotogi ngagora kerewiya kele kapura puwili koyi kang kunimowei wilek kang mabiyeng king keya watabi kolokngagonoyeng keya wilek ngelek kumuliyeng keya korik kang ngabelakpekke wilikwilik miza meli pilik piyengki tiya mani kopong puwiligu Anotogi ngagora wezameli. Pilik legi kazing puwiligu mizi piyeng ngizi ono. ");
INSERT INTO big_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kapura yongkambanu nawili ngabelak wazono wilekyeng walabok kelikwili. Puwili Anotogi ngagoragi kerewiyi logo ngizi kumuli logo pura wilek kang pangka puwiligiyengke kozang kebangkela yoluwili logo weik puwiligu miziyengki ngiziyeng weik punda, yeiya. ");
INSERT INTO big_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Pilik yeiya logo Yisugu ngago saweliwei nararau pelik yeiya, Yombanu nak lambek langiya logo yeke ige oroweirik kaimirago liwik ngokmana wiyi ma lalektage yenge kulengke wiyi ono, a’a’. Pilik segeya pi orowei paka kimeike wiramiya wazamiyagi logo yongkambanu ige kangwiligu lambekki ngaiwaktikki pakelibene. ");
INSERT INTO big_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kazing mabilikmekke watabi mabek neyegi langai liwik yolu piyeng kalike kimeike kawela wiyagiyeng keya watabi mabek neyegi langai ngokmana piyeng kalike ngokmana piyengka lewagela wiriyagi logo yongkambanuwiligu piyeng iwakaweki. ");
INSERT INTO big_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pilik tegi ngago nogo kai puragi waberek kerewiya panu keya ngagoragi kumula panu. Purik tamizeige yombanu namele keya nak Anotogi ngagora kebangkela logo kiriwei yolu mologabok Anotogo pi ngizira mawinda managi kani kapura tamizeige namele keya nak ngago puragi kiriwei ono purik Anotogo ngago pilik mologabokko songono kebangkela yolu nobiyeng miza purarau piyaga weiya mowiyagi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pulaga Yisugi panumele keya sakwili piyegi keriyiweki wiriya logo puwili piyegi mereke wiriyagi nobiyeng miza kapura yongkambanu wawere ulamek kolokngagono kopong piyegi mereke wiriyagi langai ono. ");
INSERT INTO big_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yombanu nakko Yisuyegi pelik meiya, Nigi panumele keya sakwili niyegi pakeliweki yenge yerengke pelege luwe yuke yolu, meiya. ");
INSERT INTO big_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kapura Yisugu puwili mabuwiliyegi pelik yeiya to mela, Anotogi ngagoragi kerewiya logo kiriwei mizi pilik puwili negi panumele keya sakwili kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wok nakke Yisu yombanu ngezebokko waligeleyiwili kiling wangleige tameneng meiya logo mogosa. Pugu puwiliyegi pelik yeiya, Teni kai kolamiyabek wala uwei lalu pangazuwagawekke kangweki, yeiya logo weik puwili kambela. ");
INSERT INTO big_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Puwili wangleige kaibekki ngalengale tagoneigeya Yisu weik iwek. Pi iwek kola wizigeya kebarek unatubabek kaibekke uli yongomo mizi logo weik wanglei kaibokko kolamiya logo wilak wizigeya puwili weik wanglei kiling yenge kaibekke kiliyaroweki mizi. ");
INSERT INTO big_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tegi Yisugu waligeleyiwiligu pi waliya kelemiya logo pelik meiya, Kiriwagabek. Kiriwagabek. Teni weik kaiyaga niweki mizi. Pilik kisi legi Yisu yangalek meiya logo kebarekpek keya kaibektau ngalik yeiya logo kebarekpek weik yeik sawiya keya kaibektau weik yelakkelek wiziya. ");
INSERT INTO big_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Togo Yisugu yombanu ngezebokko waligeleyiwiliyegi pelik yeiya, Ini wilek ngelek kumulira nangki? Ini nogo iniyegi ngaigi langai purikki neyegi ngizi kumuli ono ma talik, yeiya. Keya puwili kozang puguragi pakelawekke puwili kazi miza keya lelengkira keya nakko nakyegi pelik meiya, Yombanubek talikpek logo kebarekpek keya kaibektau pugu kairagi kerewiya logo kiriwei mizi, meiya. ");
INSERT INTO big_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pilik miza logo puwili wangleige ngalengale kuna logo waleleige puwili kanda lalu pangazuwagawekke ngabelak Kegesa meibekke wila wiya. Ngabelak pok Kalili kaibekka pangazuwage yolubek. ");
INSERT INTO big_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yisu wangleiga yangalekta panga kaingimbekke luweziraige pura yombu yereng puraga nak wizilege. Yombubok kerewawili piyegi yenge yungke yolubek logo komozilik yolubek wizigeya pi yerengke ige yolu onobek, pi yombanu mosindaga yolubek. ");
INSERT INTO big_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Kang mabiyeng kerewabokko pi kebangkela yolu mizirikki wiyeke kang mabiyeng yombanuwili inge keya mele puguyeng sengyengko wigira wazamiya logo piyegi ngai yolu mizi. Kapura kerewabekki kozandago sengyeng ngela mela logo kerewabokko pi kurung yeikwekkebekke kiriwei kelemi kang mizi. Yisugu kerewabek yombanubekyaga welagela kunibene meiya logo yombubokko Yisuyegi pakeli keya kemenak ngalizi kek kaiya logo pigi ingewerege ulu wala logo pelik meiya, Yisu, Anoto Yemizi Ngizi Lewege Panubekki Marekpek. Nugu neyegi nangaiyeng keleniweki mizi? Nogo niyegi nguk nei ne ngangang keleni nagani, meiya. ");
INSERT INTO big_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Pilik meiya logo Yisugu yombubekyegi pelik nguk meiya, Yeik nugura talik mei meiya, legi pugu pelik meiya to mela, Yeik nogora Ngelekpek, meiya, purik kerewa kolokngagonowili piyegi kiliya yabela legi. ");
INSERT INTO big_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kerewa puwiligu Yisuyegi pelik mazeng keya nguk meiya, Nugu teni yungu yenge yungke kambeli purikke wezayeli nagani, meiya. ");
INSERT INTO big_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lewak songono mereke pulogo wizilegebekke liyeng kabe kolokngagono namek ngeragi ni yo keya to mizageya koyilege. Togo kerewawiligu Yisuyegi pelik kelegele meiya, Nugu teni liyeng puwiliyegi kiliya wezayele, meiya. Tegi Yisugu puwili liyeng puwiliyegi kiliya wezayela. ");
INSERT INTO big_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yisu pilik miza logo kerewawili yombubekyaga welagela panga liyengwiliyegi kiliya logo liyengwili lelewe miza logo lewakpekke nginda kanda wilekwekka yenge kaibekke kiliya logo kaiyaga na. ");
INSERT INTO big_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yombu liyengwiliyegi yaka ngai koyimawili yaka miza puragi pakela logo puwili nginda kambela logo ngago yaka miza puragira yongkambanu yereng yemaneyeng keya songonoyeng keya yaweyengke yawe miziwiliyegi kozak yei miza. ");
INSERT INTO big_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Togo yongkambanu ngago puragi kerewiyawili yaka miza puragi pakeli kambela. Puwili Yisuyegi kanda pura yombu yaka kerewawili piyaga welagela wezayelabok lelewemek yeik wizigeya kagoriktik tiya logo Yisu kiling mogosara wizilege pakela. Puwili pura pakela logo mabuwili kazi panu miza, purik kozang yemanera kiling piyeng miza purikki puwili iwaka kopong. ");
INSERT INTO big_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Togo yongkambanu yaka miza puragi pakela puwiligu yongkambanu yaka miza puragi napakeli puwiliyegi Yisugu miza logo yombu kerewawiligu kebangkela yolubek yombiyangai wazamiya puragi kozak yeiya. ");
INSERT INTO big_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Togo yongkambanu panga Kegesa pulumengka pulogo wawere ula puwili mabuwili kazi panu miza. Logo piliktikki wiyeke puwiligu Yisu kangweki nguk meiya logo pelik meiya, Kambele, meiya. Pilik kisi legi Yisu panga wangleige ngalege yabela logo kangweki miza ");
INSERT INTO big_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","kapura yombu yaka kerewawili piyaga welagela wezamelabokko Yisuyegi pelik kozang nguk meiya, Ne ni kiling kangweki, meiya. ");
INSERT INTO big_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Kapura Yisugu pi wezayomela logo pelik meiya, Yereng ni makngezegirage kambele logo watabi wazono Anotogo niyegi keleniya piyeng mabiyengki yongkambanuwiliyegi kozak yeimo, meiya. Tegi pi Yisugu kai pura miziweki kambela logo yongkambanu mabuwiliyegi i kangka kambelimowei Yisugu yaka wazono piyegi miza piyengki kozak yei kai kambela. ");
INSERT INTO big_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pulaga Yisu weik pulumeng wiya logo ngereke kai kolamiyabekke pezuwaga wala uwei yowekke yongkambanu kolokngagono pi lewarikka wawere ulara yuke koyimawili wilikwilik miza logo piyegi ni weik lewa purik wazono, meiya. ");
INSERT INTO big_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Logo Yudawiligi i walek songonomakki ngai nak, yeikta Yaira meiyabek wiriya. Pi pongo kaibekke kanda Yisugi ingeyauge ulu wala logo pelik kozang nguk meiya, Negi yangomele ibengweki mizi legi ni ne kiling ngezangai i nogomakke kangweki koli, meiya. Kolomandikmolo pigi yango wamenamele keya kirisimasi meleyau keya ingenazikka neyaumele. Togo Yisu kuna kapura yongkambanu kolokngagono piyegi yekezuwaga yengezuwage kelemi kopong pi yelakkelek kuna. ");
INSERT INTO big_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Keya yongkambanuwiliyaga yongok namele wok iwi walayeng weik yeik ono, kirisimasi meleyau keya ingenazikka neyau piyeng iwi walageya wizagomimelerau wiziya. Togo pi totawiliyegi king puguyeng mabiyeng yeik wezamela. Totawiligu yombiyangai wazamiyagi nobiyeng miza kapura nakkorau pi pangka wazamiyagi langai ono. ");
INSERT INTO big_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yongok yakamolo yongkambanuwili kiling Yisuyegi kalika kiriwei kuna logo kagorik pugu yeke ngalege wakiyarikki pongo walemekka kuming kelemiya logo pigi iwi walibok weik nguk namizi yeik. ");
INSERT INTO big_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pilik miza puwekke Yisu leng miza logo pelik nguk yeiya, Takko neyegi kuming keleniya, yeiya kapura puwili mabuwiligu yeik kisi, legi Pitago pelik meiya to mela, Kiriwagabek, yongkambanuwiligu ni yawereng keleni keya niyege panga yungke keleni purikku, meiya. ");
INSERT INTO big_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kapura Yisugu pelik yeiya, Namele keya nakko kagorik nogorik melezikku ngaungaugu kuming kelemiya logo kozang nogobek neyaga namele keya nak yombiyangai wazamiweki welagela kandikki nogo iwaka kopong ne kai yagenda, yeiya. ");
INSERT INTO big_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Togo yongok pumologo pi Yisuyaga liwik mizagi ono purik weik iwaka, legi pi leli uli kanda Yisugi ingewerege pulogo ingeyau laliya logo yongkambanu mabuwiligi wirege puwiligu kerewiya koyigeya pugu kemegeme pugumekki kozak mei keya pugu Yisu kuming kelemiya ngizige Yisugu pi yombiyangai sa wazamiya puragi kozak meiya. ");
INSERT INTO big_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pilik miza logo Yisugu piyegi pelik meiya, Yongokpanumele, nugu neyegi ngizi panu kumulirikku ni weik yombiyangai wazaniya mena, ni wilek kang ngezege sara kiling kambele, meiya. ");
INSERT INTO big_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yisu ngoluk pura kaiyageya wizigeya yombu ngago orowei nak Yaira ngaibekki imakka piyegi lewa logo Yairayegi pelik meiya, Nigi yangomele yaka ibeng, legi Kiriwagabek yeik ulak kambela nera wizi pani, meiya. ");
INSERT INTO big_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kapura Yisugu ngago puragi kerewiya logo Yairayegi pelik meiya, Ni kulili mizi nagani, ni neyegi yeik ngizi kumula wizeimo. Pi ngereke yangalek meiya logo yombiyangai sagi kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Pulaga Yisu yeke Yairagi imakke lewagelawekke pugu yongkambanu yeke ige kolomandikmeleyegi wiyeke ingkeya ngabik miziwiliyegi pakela logo pelik yeiya, Ingkisi wak, kolomandikmele ibeng ono, pi yeik ngoluk iwek kola wizinda, yeiya. Kapura puwiligu kolomandikmele ibeng purik iwaka kopong puwili Yisuyegi songomeiya. Togo Yisugu yongkambanu namele keya naktau pi kiling yeke kolomandikmeleyegi yeke ige la nelegi, yeiya. Kapura Pita keya Yowan keya Jems keya kolomandikmelegi panu keya mangoyau miza logo puwili keke yeke ige liweki, yeiya. ");
INSERT INTO big_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yisu yekelege kanda pugu kolomandikmelegi melezikka weiya logo pelik meiya, Kolomandikmele, yangalek mei, meiya ");
INSERT INTO big_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","logo kung pugubek yenge yungke ngereke yorik pi weik nguk namizi mabuwekke yangalekta. Tegi Yisugu puwiliyegi pelik yeiya, Ngeragi nayeng pi nibene mani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pilik miza logo kolomandikmelegi panu keya mangoyau lelengkiririkki wiyeke Yisugu piyauyegi yawe kozang mabek miza puragi nawiliyegi kozak yeiya nelegi, yeiya kapura mabulaga koyimowei Anotogo yaka miza puragi wiyeke yeik pugura yongolok meizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pulaga wok nakke Yisugu yombu ngezebokko waligeleyi meleyau keya pongo ingenazikka neyau puwili menalege ngago yeiya logo pugu puwili kerewawili yongkambanuwiliyaga wezayeli keya yongkambanu kemegeme nak nalangaimek kilingwili yombiyangai wazayiweki kozanda keya pangkara yana. ");
INSERT INTO big_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pilik miza logo pugu weik puwili ngago Anotogo pigi ngaimekki ngai yolu puragi langai pura yongkambanuwiliyegi kozak yei keya kemegemewili yombiyangai wazayi kambelibene wezayela. ");
INSERT INTO big_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Keya pugu puwiliyegi ngago kiriwei mizagiyeng pelik yeiya, Ini kambeli kapura watabi orowei kelemi kangki nayendau wari nagani, yeik kambelizo. Ini lukungyeng wari nagani, kik nayendau ma ngeragi nayendau wari nagani, ma king nayendau ma kagorik yeke ngalege wakiyagi nariktau wari nagani, yeik inugu wakiya mabiyeng kiling kambelizo. Purik yongkambanu inugu i yolugi piyengkiwiligu iniyegi waberek ngaigi keya iniyegi saweli mizagi. ");
INSERT INTO big_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Keya ini yereng narage lewa puwekke i yombanu ini iza orowei kang puwiligiyengke yolu puwekke purik mabura i mabumakke koyi kanda kangki puwekke yereng pura wiya logo kambelizo. ");
INSERT INTO big_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Keya tamizeige yongkambanu yereng naragewiligu iniyegi, Ini lewa purik wazono mena teni kiling yoluweki koli yei ono keya ngago wazono puragi kerewiya logo ya puwiligiyengko wei ono puwekke purik mabura yereng pura wiya wazamizo logo puwiliyaga mele inuguyeng kaigesizo logo puwili Anotogo puwiliyegi wilik ono keya inugu ngereke yereng purage puwiliyegi ngago wazonora kozak yeiweki yogi ono purikki puwili iwaka si nangai kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Puwili Yisu wezamiya logo puwili pulumeng wiya wizigeya yerengyeng neing ngago wazono Kilisibekyegi langaira kozak yei kambela keya yongkambanu kemegemeyeng kilingwili yombiyangai wazayi kelemi kambela. ");
INSERT INTO big_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Togo King Ngai Elodo, panga Kalili ngabelakpekki ngaibek Yisugu watabi pilik mizi piyengki kerewiyawekkerik pi kangka pugubek Yisuyegi langai wiyalowei miza. Purik nawiligu Yisuyegi langai pilik kisa Yowan kaimelibek ngereke ibendaga yangalekta wik yolu ");
INSERT INTO big_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","kisa keya nawiligu kisarik Ilaya yombu ngagora Anotoyaga weiya logo kozak kaiya walaka Anotogo korikwek kiling paka ngalege miza orowei kambelabok ngereke yo kisa keya nawiligu kisarik yombanu Anotoyaga ngagora weiya logo kozak kisa koka walaka ibengwiliyaga nak ngereke yangalekta wik yolu kisarikki wiyeke. ");
INSERT INTO big_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Elodo ngago pilik kisi piyengki kerewiyarikki wiyeke pi Yisuyegi langai wiyalowei miza logo pelik kaiya, Yowan yombu nogo koka kalokpek ngela logo ibembek kapura yombu watabi pobiyeng mizi legi nogo kerewiyibek tak, kaiya. Togo pi Yisuyegi pakeliweki miza. ");
INSERT INTO big_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yombu meleyau keya pongo ingenazikka neyau Yisugu waligeleyi logo Aposolowili meiwili logo Yisugu ngago wazonoragi yeiweki wezayela puwili yorik, puwiligu Yisuyegi watabi mizayeng mabiyengki kozak meiya logo Yisu kiling puwili ngezewili keke, yeke yereng yeikta Pesaita meirage mereke kambela. ");
INSERT INTO big_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kapura yongkambanu kolokngagonowiligu puwili talege yolu miza purikki kerewiya wizigeya puwili Yisuyegi kiriwei kambela. Kanda Yisugu puwiliyegi pelik yeiya, Ini kayima purik wazono, yeiya logo puwiliyegi ngago wazono Anotogo pigi ngaimekki ngai puragi langai pura kozak yeiya keya yongkambanu kemegeme puwili yombiyangai wazayi keleya. ");
INSERT INTO big_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Waleleige ibengke yokmek kiliyaweki merekewekke yombu meleyau keya pongo ingenazikka neyau ngezebokko waligeleyiwili Yisuyegi pelik meiya, Tonugu yolu pelemeng kabelak ngeragi keya iyeng yeik lemeng mena yongkambanuwili kang wezayele logo puwili yereng mereke piyengka ngeragi wei keya iwek kolagiyengki welibene, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pilik kisi legi pugu puwiliyegi pelik yeiya to mela, Inuwa ngezego puwili ngeragi nagiyeng yani, yeiya logo puwiligu pelik meiya to mela, Kapura teni ngeragi kolokngagono wara ono, teni perek melenazik keya watabisi waliya neyau miza logo mabiyeng wara yolu peyeng. Ma, teni yongkambanu pewiligi ngeragi nayeng wei kangkirikki ni keli, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yombu pulogo sangkelawili tausen melenazik tikinda keya Yisu ngezebokko waligeleyiwiliyegi pelik yeiya, Inugu yongkambanuwili yombu neyau keya meleyau tikinda narikke mogosibene keleye, mena yeiya. ");
INSERT INTO big_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yisugu waligeleyiwiligu pilik keleya logo yongkambanuwili pilik mogosa wazaya. ");
INSERT INTO big_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pulaga Yisugu perek melenazik yaka piyeng wei keya watabisi yaka piyaurau wei miza logo paka ngalege langai pakela wizimowei Anotoyegi ngeragiyengki wazono meiya. Pilik miza logo pura perekyeng sikila logo ngezebokko waligeleyiwiliyegi yana logo puwiligu yongkambanuwili mabuwili yani miza. ");
INSERT INTO big_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Puwili mabuwili na logo weik ngekyengko. Pulaga Yisugu waligeleyiwili kik meleyau keya pongo inge nazikka neyau piyengke ngeragi perekyeng keya watabisiyauga wale wazono wiyayeng mereng miza. ");
INSERT INTO big_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kang narage Yisu ngezebek waberek miza logo kandorik pugu yombu ngezebokko waligeleyiwili pulogo koyilege puwiliyegi pelik nguk yeiya, Yongkambanuwiligu neyegi langai kozak kisirik puwiligu ne tak kisi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Logo puwiligu pelik meiya to mela, Yongkambanu nawiligu kisirik ni Yowan kaimelibek ibendaga yangalekta yo kisi, kapura nawiligu kisirik ni Ilaya Anotogo paka ngalege korikwek kiling wik miza orowei kambelabok ngereke yo kisi keya nawiligu kisirik ni koka walaka yombu Anotoyaga ngagora weiya logo kozak kisawiliyaga nak ibendaga yangalekta yo kisi, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Pilik meiya logo Yisugu puwiliyegi pelik yeiya, Nawiligu pilik kumuli kapura inuwago sawiyarik ne tak, yeiya. Tegi Pitago pelik meiya to mela, Ni Kilisi Anotogibek Mesiya Anotogo yawe pigi teni Yudawili yaliya wazayagi pura miziweki sawiyabek, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pilik kai legi Yisugu puwiliyegi ngago kozanda yeiya nawiliyegi puragi kozak yeiya nelegi logo Yudawiligi ngaiwiligu puragi kerewiya logo sisik miza wizigeya nguk namizi pi ula ne. ");
INSERT INTO big_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pulaga pugu puwiliyegi pelik yeiya, Ne yombanu paka ngalega kayimabek nganganda yemane panu wagelagi kani logo Yudawiligi yemanewili keya yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwiligu neyegi kezanga nana logo ne nelagi logo ne ibeng wizigeya kawiktikke waliyagi, kapura wok neyau wiziya logo wok kalikebekke ngereke wik yangalektagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Togo pugu puwili mabuwiliyegi pelik yeiya, Tamizeige ni yombanu nak neyegi sawelagi keli mabura ni keli korik ni makngezegiwekkiragi kezanga mane logo wok mabiyeng ngago nogoragi kerewiye keya negi wiyeke ibengkirikki kulili onobok ne kiling kazing nogo kangmokko kunimo. ");
INSERT INTO big_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Purik yombanu ngezebekki kelira keya ngezebekki wik yolugira kozang kebangkelibok pi Anotogi wiregerik ibeng logo paka ngalege wik wizagomagi ono, kapura yombanu neyegi ngizi panu kumula logo wilek kang pugubek neyegi tiya manibok pi kemenak ibengki ono, paka ngalege wik wizagomagi. ");
INSERT INTO big_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Keya tamizeige yombanu nak yawe king keya watabiyeng weiyagi naragi wilek kang tiya mana logo pi watabi ngabelakpekkiyeng mabiyengko kola logo pi ibeng purik pi pongo Anotogo yolu onolege kaile wizagomagi logo puwekke watabi pigi piyengko piyegi sawelagi ma yeik? Yeikki kani. Piyengko piyegi sawelagi ono. ");
INSERT INTO big_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tamizeige yombanu nak neyegi kendek mizi keya ngago nogora yanagirikki kendek mizi purik mabura ne ngaiwak nogorik keya ngaiwak Pebagirik keya ngaiwak angela walekwiligirikkke ngereke yo puwekke purik, ne yombanu paka ngalega kayimabektau piyegi kazing mabilikmekke kendek mizagi. ");
INSERT INTO big_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kerewiyi. Nogo inuwayegi wameik panu yei, yongkambanu pelege yolu pewiliyaga nawili ngoluk mabilik wik koyigeya Anotogo pigi ngaimekki wilek kangyengki ngairikki pakelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pilik yeiya logo Sonda nara keya wok nak miza logo waleleige Yisugu Pita keya Yowan keya Jems iza logo pi kiling paka lewakpekke waberek miziweki kambela. ");
INSERT INTO big_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kanda pakalege pi waberek mizageyarik wiregawere pugura nalik si lewa keya melewangka keya pugu wakiya piyendau wilangka ngaiwaktikku kola miza. ");
INSERT INTO big_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Keya pi pulogo mabilik miza wizigeya yombu yemane koka walaka koyima neyau paka ngalege ngaiwaktikka lewagela logo kanda Yisu kiling ngagozakka mizi. Yombu piyau Mose keya Ilaya. Puwili Yisu ngezebek Anotogo yawe sawiyaragi kiriwei paka Yirusalem yerengke ibeng sa logo pulaga paka ngalegi kangkiragi kozak keli. ");
INSERT INTO big_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita kiling pigi kewengkeyau iwek kola logo yangalekta Yisugi ngaiwaktik keya yombu neyau Yisu kiling luwe koyilege pakela. ");
INSERT INTO big_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Keya yombuyau yongo yabeleiga Pitago watabi yaka pakela piyeng mabiyengki iwaka panu ono kopong pugu Yisuyegi waze yeik pelik meiya, Kiriwagabek, teni pelege yolu purik pangka panu kani, tonugu i menang yolugi neyauganamak ngiziweki nigi namak keya Mosegi namak keya Ilayagi namak, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pi ngoluk pilik meiyageya tawizeige kozainumbek kanda yokmek waliya logo morokki ngalege ngokmani yagenda puwili kulili miza. ");
INSERT INTO big_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kili narago paka kozainumbekka pelik kai, Pok negi Marekpek nogo sawiyabek logo iniyegi wiyeke wezamelabek kani pugu kai piyengki kerewiya logo kiriwei mizizo, kai. ");
INSERT INTO big_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kilira ngagoluk si ngizige ngereke Yisu ngezebek keke wizilege. Yisugu waligeleyiwiligu yaka pakela piyengki yongkambanu namele keya nakyegi yaka lewagela puragi mabuwekke songono nangezi nawiliyegirau kozak yeiya ono. ");
INSERT INTO big_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wok wanganebekke puwili lewakpekka kandorik pongo kazingke Yisugu yongkambanu kolokngagono yoromaure miza. ");
INSERT INTO big_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yongkambanu wawere ula puwiliyaga yombu nakko Yisuyegi pelik kek meiya, Kiriwagabek, negi marekpekyegi pakeli, koli. Ni piyegi yalek mize, purik pi negi marek wamenak panubek ");
INSERT INTO big_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","logo kang nayeng kerewa nakko pi kebangkela yolu mizi keya pi kerewabokko kelele kaibene kelemi, keya pi yomizo keya wezameli mizi logo sibilakpek kiliraga lewa mizi. Pilik miziyengko korik puguwek korowali panu keya kerewabek mandikpekyaga kunagirikki kiyebuk mizi. ");
INSERT INTO big_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nogo yombu nugu waligeleyiwiliyegi nguk yeiya, puwiligu kerewabek welagela wezamelagi nobiyeng kapura puwili pangka ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Pilik kai legi Yisugu pulogo koyawiliyegi pelik yeiya to mela, Oyo, ini yongkambanu mabek pewekkewili wilek kang inuguyeng pangka yolu ono keya ne mabiyeng pangka mizagi langaibek purikki ini ngizi kumuli onowili kani, legi ne iniyegi kiyebuk sende. Tek taliktikke ne ini kiling yoluweki keya kuneng inuguyeng wageliweki? Pilik yeiya logo mandikpekki mangobekyegi pelik meiya, Nigi marekpek neyegi pelege miza orowei koli, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mandikpek tawereige kerewabokko yomizora pongo ngabelakke wezamela logo piyengka walibene kelemiya logo kaile panu miza wala kapura Yisugu kerewabekyegi ngalik meiya logo welagela koli meiya logo mandikpek yombiyangai wazamiya wizigeya mangoyegi miza mana. ");
INSERT INTO big_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yongkambanu mamok Anotogi kozang yemane panu puragi pakela logo lelengkira. Yongkambanuwili watabi Yisugu mizi piyeng mabiyengki kumula melageya koyigeya Yisugu yombu ngezebokko waligeleyiwiliyegi pelik yeiya, ");
INSERT INTO big_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Neyegi kerewiya logo nogo inuwayegi kozak yeiweki mizi peragi keremareke mizi nagani. Puwili lelengkiri kele kapura puwiligu ne yombanu paka ngalega kayimabek yombu ne nelagiwiligi meleyengke niza yaniweki mereke kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kapura ngago purago pilik kai purikki puwili iwaka ono. Puwiligu weik iwaka nelegi Anotogo ngago pura puwiliyaga liwik wiya. Togo puwili ngago puragi solorikki talik meiyagi miza purikki keli kapura puwili kazi. ");
INSERT INTO big_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wok nakke weik Yisugu waligeleyiwili ngezewiligi tepekke tak yeikta lewege miza legi kozak keli yongomo miza. ");
INSERT INTO big_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yisugu iwaka puwiligu kumula yolu puragi keya puragi wilik ono legi pi mandik songono yeikta yemane ono nak miza logo piyegi saweliwei luwe wazamiya ");
INSERT INTO big_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","logo pugu waligeleyiwiliyegi pelik yeiya, Mandikpekyegi pakeli. Yombanu nakko neyegi kelirikki weraga mandik songono pilik pokyegi sawelibok mabura, pi neyegirau saweli yagenda. Keya neyegi sawelibok pi mabilik Anoto ne ngabelakpekke wezanelabokyegi saweli yagenda. Togo inuwayaga pelik kaibok, ne yombu yeikta kiling onobek mizi purikki wilik logo yombu nak kele yeik yemanera wei pani kaibok, Anotogi wirege yeik yemanera kilimbek kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yowangu Yisuyegi pelik meiya, Kiriwagabek. Yombunak yeik nugurage kerewawili welagela wezayelirikki tonugu pakela. Pi teni kiling yongomo mizi onobek legi tonugu pilik mizi nagani, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kapura Yisugu piyegi pelik meiya keya ngezebokko waligeleyi puwiliyegirau pelik yeiya, Piyegi pilik mizi wak, mei nagani, purik yombanu yawe tonuguragi ngai mizi onobok teniyegi saweli yagenda kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Teng Yisu paka Yirusalem yerengke ibeng logo Anotogo paka ngalege miza orowei kangkira weik mereke purik pi iwaka legi pi paka Yirusalem kangweki kumula logo weik kambela. Togo pugu yombu ngagora orowei nawili were wezayela. ");
INSERT INTO big_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Puwili ngabelak Sameriya meibekke yereng narage kanda i iwek kolagimakki welagiwili. ");
INSERT INTO big_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Puwili were weli kambela kapura yongkambanu Sameriyawiligu puwiliyegi pelik yeiya, A’a’, inuwa yereng tonuguraga yolu nagani, yeiya. Purik Yisu paka Yirusalem yerengke kangkibek purikki puwiligu iwaka keya puwili Yudawili keya yereng Yirusalem puragi kumbak miziwili kopong. ");
INSERT INTO big_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pilik kisi legi Yisugu waligeleyiyau, Jems keya Yowan puragi kerewiya logo piyaugu Yisuyegi pelik meiya, Yemizibek, te yezi paka ngalegazikki ngago meiya logo yongkambanu Sameriya pewili ngora kelibene ngago meiweki mizi peragi ni keli ma kiyebuk, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kapura Yisu piyauyegi langai kowita logo ngalik yeiya. ");
INSERT INTO big_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Logo morok kang mabilik yereng narage iwek ngai kambela. ");
INSERT INTO big_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Togo puwili kazingmekke tagoneige yombu nakko Yisuyegi pelik meiya, Nugu kang wale kang piyeng mabiyengke nerau niyegi sawela logo kiriwei kangkibek kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yisugu piyegi pelik meiya to mela, Kerewiye, watawili yengelei mele inguriya piyengki yungke iwekwili keya winak porora wei mizi puwili iyeng ngiza logo iwekwili, kapura ne yombanu paka ngalega kayimabek yolumek yareksa logo kumanagi nariktau onobek logo tamizeige ni ne kiling kangki purik towa mabiyaugi yolugi nariktau ono. Tegi were waberek kumula logo neyegi kiriwei koli, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pilik miza logo Yisugu ngereke yombu nakyegi pelik meiya, Neyegi saweli koli, meiya. Kapura pugu pelik meiya, Yemizibek, ne niyegi sawelagi keli kapura ne were negi mangobekyegi ngai yolu wizigeya pi ibeng logo waliyi keya miza logo purik ne niyegi sawelagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kapura Yisugu pelik meiya to mela, A’a’, yombanu ngago nogoragi kerewiyi ono puwili ibeng wezawiligu, puwiligu yombanu ibengkiwili waliyi nangai, kapura niyegirik yawe nugura yongkambanuwiliyegi ngago puwili Anotogo puwiligu yolu puragi ngai wizeibene kelemi purik puwili ngizi panu wik koyimagi puragi langai kozak yei kambelagira, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Keya ngereke yombu nakko Yisuyegi pelik meiya, Yemizibek, ne niyegi saweliweki keli kapura ne were yereng nogorage negi ingembungangwiliyegi, Ne weik kang mena, ini koyimi, yei kuni pei, meiya. ");
INSERT INTO big_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Logo Yisugu pelik meiya to mela, Yombanu nak Anotogi yawera miza logo pulaga kalike ngereke pugu wizamiya piyengki kumulibok neyegi pangka yawe mizagi langai onobek, yeiya. ");
INSERT INTO big_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pulaga Yemizibokko yombanu yombu neyauganak keya meleyauwilirau iza logo puwili neyau neyau yawe pugura miziweki wezayela. Puwili yereng Yisu ngezebokko kangweki mizi piyeng mabiyengke were kang wezayela. ");
INSERT INTO big_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pugu puwili ngago kiriwei mizagi pelikyeng kiling wezayela, Watabi kolokngagono weik yaweyengke kuk wizinda kapura watabi piyeng menalege wawiyagiwili keremungke ono legi ini yaweleigi mangobekyegi waberek mizizo logo pugu yaweleige ngeragi kuk piyeng menalege wawiyagi nawilirau wezayelibene. ");
INSERT INTO big_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ini ngeragiyeng wawiyi pilikwili mena, weik kambeli keya nogo ini koloyakamandik songonowili kelik yombanu kaile iniyegi ngangang keleyi keya kuneng yanagiwiliyegi wezayeli purik nogo iwaka wizinda, legi yawe Anotogira yeik mizi kambeli. ");
INSERT INTO big_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Keya ini king nayendau wari nagani ma kik kalok watabiyeng kiling nagik ma inge kangyau wari nagani, ma kazingmekke tagoneige yongkambanuwili yoromaure mizi puwekke puwili kiling ngagogeya mizi nagani, yeik kambelizo. ");
INSERT INTO big_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Keya ini i namakke yeke ige kang puwekke purik mabura were yongkambanu i pumakke yoluwiliyegi pelik yeizo, Wilek kang inuwagiyeng ngezege sara koyimiweki, yeiya logo Anotogi ngago wazonora yanizo. ");
INSERT INTO big_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tamizeige yombu wilek kang ngezege saragi kelibek i pumakke wizilege purik wilek kang pugubek ngezege sara weiyagi. Kapura tamizeige pilik naktau ono purik mabura ngago ngezege saragi pura ngereke ni makngezeyegi yogi. ");
INSERT INTO big_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Keya i mabumakke yolu keya ngeragi keya kai i pumakki mangobokko ini niweki yani piyengka ni mizizo. Purik yombu yawe mizibek yawe pugu miziragi wiyeke kanga maniyeng wei purik pangka. Tegi ini yongkambanu i pumakkiwiliyegi yawe yemane yani miza logo i namakka namakki wei mizi nagani. A’a’, i mabumakke panu koyimizo. ");
INSERT INTO big_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ini yereng narage kanda yerendagewiligu, koli keleya logo ini iza orowei i puwiligiyengke yolu puwekke purik mabura puwili kiling kandarik puwiligu ngeragi inigi ingewerege wiyi piyeng nizo. ");
INSERT INTO big_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Keya yereng purage kemegeme puwili yombiyangai wazayizo. Keya yongkambanuwiliyegi pelik yeizo, Mabek wokpekke Anotogo weik pigi ngaimekki ngai wiziga kiliyiweki koli logo Anotogo iniyegi ngaiweki kelemizo, yeizo. ");
INSERT INTO big_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kapura ini yereng narage kanda yereng puragewili iniyegi koli keleyi ono puwekke purik mabura yereng puragi kazing kawaktaga koyimowei pelik yeizo, ");
INSERT INTO big_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Teni iniyaga mele tonuguyeng kaigesi, purik Anotogo iniyegi wilik ono kopong. Teni weik ini wezayi kapura kumula, Anotogo pigi ngaimekki ngai pura yaka iniyegi mereke wiriya kapura ini weik kezanga mani, yeizo. ");
INSERT INTO big_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nogo iniyegi ngizi panu kozak yei, Wok kalike Anotogo ngagozak mizagibekke purik yongkambanu yereng Sorong meiraga koka walaka kaile unatuba miza puwili ngangang weiyagi kapura yongkambanu yereng puraga iniyegi koli keleyi ono puwili keya ngago inuguragi kerewiya logo wei ono puwili wokpokko ngangang yemane panu weiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Pulaga Yisugu yereng ulogo ngezebokko Anotogo keke miziyeng kolokngagono kozang mizayengke pelik ngalik kai, Yomono. Wok Anotogo ngagozak kalike mizagibekke ini Yuda yongkambanu yereng Korasin meirage yolu puwiliyegi ngangang yemane panura lewagi, keya ini Yuda yongkambanu yereng Pesaita meirage yolu puwiliyegirau ngangang yemane panura lewagi. Purik nogo Anotogo keke miziyeng yereng inuguyauge miza kapura ini neyegi saweli ono. Kapura tamizeige nogo Anotogo keke mizi yereng inuguyauge miza piyeng panga Taya keya Sairong Yuda onowiligu yereng yoluyauge miza kesak yongkambanu yereng piyaugiwiligu yaka kaile puwiligiyengke nguk namizi kuneng miza logo kaile puwiligiyengka kowita logo wilek kang puwiligiyeng neyegi saweli kak. ");
INSERT INTO big_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Logo wok Anotogo ngagozak kalike mizagibekke purik yongkambanu yereng Taya keya Sairongyauge koka walaka kaile unatuba miza puwili ngangang weiyagi kapura ini kele ngangang yemane panu weiyagi kani. ");
INSERT INTO big_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yomono. Ini yongkambanu yereng Kapaneyam meiragawili, ini paka ngalegi kangki purikki kumuli ma talik? A’a’, yeik. Inugu ngago nogoragi kerewiyarik kolokngagono kapura neyegi saweli ono, legi ini pongo yereng yezi kusagi onozik ngori purage yomizora wezayelagiwili kani, kaiya. ");
INSERT INTO big_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Pilik kaiya logo Yisugu yombanu meleyau keya pongo ingenazikka neyau ngezebokko waligeleyiwiliyegi ngago nararau pelik yeiya, Namele keya nak ngago inuguyengki kerewiya logo wei mologabok ngago nogoyengkirau kerewiya logo wei yagenda. Kapura namele keya nak iniyegi kezanga yani mologabok neyegirau kezanga nani yagenda kani, keya namele keya nak neyegi kezanga nani mologabok ne wezanelabokyegirau kezanga mani yagenda kani, yeiya. Yisugu pilik yeiya logo puwili yawe pugura miziweki wezayela. ");
INSERT INTO big_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Puwili pilik mizi kambela logo wok nakke yombu Yisugu wezayelawili yo kayimarik wilikwilikmokko kola. Togo puwiligu Yisuyegi pelik meiya, Yemizibek, tonugu Anotogo keke miziyeng kolokngagono miza keya kerewawilirau tonugu puwiliyegi yeik nuguragi ngane yeiyawekke puwiligu tonugu ngalik yeirikki kerewiya logo yongkambanuwiliyaga welagela kang, meiya. ");
INSERT INTO big_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yisugu puwiliyegi pelik yeiya to mela, Ma, inugu pilik miza, purik Sadang kerewawiligi ngaibek paka ngalega pongo ngabelakki lang wezarik kawiye walirikki nogo pakela, logo purikku Sadangki kozanda weik yeik purikki walimizi yagenda. ");
INSERT INTO big_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kerewiyi. Nogo ini kozang nogobek yana logo kozang nogorago mizagewiyege kemale Kuluwekmek limiti purik mabura ini ibengki ono, ma kozangaingmek limiti purik mabura korik inuguyendau waragi ono. Teniyegi ngai mizibek, Sadang, kozang panu kapura kozang nogo yani pura Sadangki kozandaga lewegera logo watabi nayengkorau ini ngangang yanagi ono. ");
INSERT INTO big_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nogo ini kozanda yani logo kerewawili inugu yeiragi kerewiyi purikki ini wilik kele kapura Anotogo yaka yeik inuguyeng kapiya paka ngalegerikke lende miza purikki kele wilik yemane mizizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mabuwekke Yisu Kung Walekpokko kelemiya logo wilikwilikmokko kola logo Anotoyegi pelik meiya, O Peba, ni ngilumbek keya ngabelakpekki Ngai Yemizibek, nogo niyegi wazono nei, purik nugu yongkambanu iwaka kumuli keya kangka yemaneyeng kiling kumuli puwiliyegi wameik ngiziyeng waligeleyi ono kapura nugu yongkambanu neyegi yeik ngizi kumuli koloyakamandik songonowili kelik puwiliyegi piyeng waligeleyi, Ei, Peba, pera kumuli nugura keya keli ni makngezegirago legi nogo yeik nugura yongolok mei, meiya. ");
INSERT INTO big_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yisugu Anotoyegi pilik meiya logo pugu yongkambanu koyilegewiliyegi pelik yeiya, Negi Mangobokko ulogo watabi mabiyeng neyegi nana. Nakko neyegi ngizi panu iwaka ono, kapura ne negi Mangobekki Marekpek legi negi Mangobek ngezebek kele neyegi iwaka, keya nakkorau negi Mangobekyegi ngizi panu iwaka ono kapura ne Koyambokko kele piyegi iwaka, keya yongkambanu Koyambokko Mangoyegi langai waligeleyiweki mizi puwili kele negi Mangobekyegi iwaka, yeiya. ");
INSERT INTO big_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pulaga Yisugu ngezebokko waligeleyiwiliyegi langai kowita logo puwiliyegi keke kozak yeiya, Ini watabi inugu pakela piyengki pakelirikki wiyeke ini wilikwilik mizagirikki kai. ");
INSERT INTO big_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Purik yombanu koka Anotoyaga ngagora weiya logo kozak kisawili keya King Ngai koka walakawili watabi nogo mabek mizi wizigeya inugu pakeli piyengki pakelagiweki miza kapura puwili pakela ono, keya mabek nogo kai logo inugu kerewiyi piyeng kerewiyagiweki miza kapura puwili kerewiya ono, yeiya. ");
INSERT INTO big_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pilik miza logo kalike yombu loyengki wazono iwaka nak kanda Yisugi ngago lewayeng yang kelemiweki pelik meiya, Kiriwagabek, talik miza logo ne paka ngalege wik wizagomagira weiyagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Pilik mei legi Yisugu piyegi pelik meiya to mela, Nugu Mosegi loyengki kapiyarikke lende miza piyeng meiwekke ngago piyengko kairik talik, meiya. ");
INSERT INTO big_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yombanubokko pelik meiya to mela, Mosegi loyengko Anotoyegi langai pelik kai, Ni Anoto nigi Ngai Yemizibekyegi wilek kang nugubek mabokko ngizi panu kelimo, keya piyegi kozang nugura mabura manimo, keya wizimowei kangka nugubokko piyegi wilibek kumuli mizimo, keya ni makngezego ni makngezeyegi keli mabilik nakyegirau mabilik kelimo, kai, meiya. ");
INSERT INTO big_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Logo Yisugu pelik meiya to mela, Nugu kaiya yo meli pura wameik ngizi panura kani, wik wizagomagiweki ngago piyengki kiriwei mizimo, meiya. ");
INSERT INTO big_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pugu puragi kumula kapura yombu loyengki wazono iwakabok pi yongkambanuwiligi wirege yombiyangaibek miziweki keli legi pi Yisuyegi nguk meiya, Ne makngezeyegi keli mabilik nakyegirau keliweki kaibok takyegi, meiya. ");
INSERT INTO big_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Pilik nguk mei legi Yisugu ngago saweliwei nara pelik meiya to mela, Yombu Yuda nak Yirusalem yerengka pongo Yeriko kandobela kapura yombanu ngowei nawiligu kanda watabi puguyeng ngoweiweki ula logo pongo kazingke wezamiya, logo yombubok ibengweki mizi. ");
INSERT INTO big_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Togo tek nangezi miza wizigeya yombu Anotoyegi wata kolak kelibene mizi nak kazing pumok neing kazing libu wiriya logo pugu yombu ibengweki mizibekyegi wirebek kelemiya logo mabilik wizi pani miza logo pi nazuwaga neing kuna. ");
INSERT INTO big_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Keya ngereke yombu Anotogi i walekmakki yawe mizi Lebigi ngaimekka naktau kazing mabumek neing wiriya logo yombubekyegi wirebek kelemiya logo pirau mabilik wizi pani miziwei nazuwaga neing kuna. ");
INSERT INTO big_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kapura yombu Yudawiligu kiyebuk miziwiliyagabek ngabelak Sameriyabekka nak kazing libu wiriya logo yombu ibengweki mizibek wizilege pakelawekke ya puguraga piyegi yalek panu miza. ");
INSERT INTO big_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tegi pi panga mereke piyegi kanda lamita piyengke kai waimbek kubula mani keya welibek mela logo wizingyeng tariya wazamiya. Pi pilik miza logo panga liyeng tongki pugumekke ngalege yombanubek mogosa wazamiya logo miza orowei i yongkambanu nalaga lewawili pura iwek mizimakke wezamiya logo pulogo waberek ngai wiziya. ");
INSERT INTO big_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wangane pura yombu Sameriyabokko yombu i pumakke ngaibek king wok neyaugi ngane yawe miza logo wei piyengki pangkayeng mana logo piyegi pelik meiya, Pobokyegi waberek ngai wizeimo. Ne kazing pemek neing ngereke yo puwekke nugu pigi wiyeke nayendau wezamelageya wiziya mabura piyeng nogo kanga nanagine, meiya. ");
INSERT INTO big_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yisugu pura pilik meiya logo yombu loyengki wazono iwakabekyegi pelik meiya, Nugu kumularik talik, yombu neyauganak puwiliyaga takko nakyegirau keli mabilik pi ngezebekyegirau mabilik kela, meiya. ");
INSERT INTO big_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tegi pugu Yisuyegi pelik meiya to mela, Yombu ngoweiwiligu ulabekyegi yalek mizabok, meiya. Togo Yisugu piyegi pelik meiya, Wameik. Mabilik mizi mangine kambele, meiya. ");
INSERT INTO big_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pulaga Yisu kiling yombu ngezebokko waligeleyiwili kelemi kanda yereng naraga kiliya logo yongok pulogo yolu namele yeik pugura Mata meiyamele Yisugi ngeragi kaimiziweki Yisu i pugumakke yeke ige miza orowei yabela. ");
INSERT INTO big_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Matagi sakmele yeikta Maliya meiyamele Yemizibekke ngezege mogosa wizimowei ngago wazono puguyengki kerewiya wiziya. ");
INSERT INTO big_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kapura Matago ngeragi kaimizagiyeng kolokngagonorikki pakela logo kangka ngelek ngelek kumula meli. Tegi pi kanda Yisuyegi pelik meiya, Yemizibek, nugu peragi kumule, negi sakmologo yawe ngeragi mizagi pera ne nana logo ne yawe kolokngagono. Piyegi meiya logo neyegi saweliweki mei, meiya. ");
INSERT INTO big_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kapura Yisugu Matayegi pelik meiya to mela, Mata, O Mata, yawe kolokngagono piyengki ni wilek kuneng keya wilek ngelek kumula meli purikki nogo pakela ");
INSERT INTO big_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kapura yawe wamenaragi ni ngoluk kumuli ono logo pura ngago nogora kerewiyagira. Maliya watabi pangka piyeng miziweki weiya legi nakkorau watabi wazono piyeng piyaga mongonagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kang narage Yisu nalege waberek mizageya wiziya. Pi waberek miza logo yombu ngezebokko waligeleyiwiliyaga nakko piyegi pelik meiya, Yemizibek, nugu teniyegi waberek mizagimekki waligeleye, mabilik Yowan kaimelibokko yombu pugu waligeleyawiliyegi waligeleya pilik meiya. ");
INSERT INTO big_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yisugu puwiliyegi pelik yeiya, Ini waberek mizi puwekke inugu Anotoyegi waberek mizagimek pobilik, O Peba, niyegi kazing korowali nayendau ono, legi teni wizageya koyi kambelimok mamok yeik nugura yongolok meiweki. Yongkambanu mamok panga nigi ngaimekki yungke kiliya logo nugu ngaiweki wiriyibene keleye. ");
INSERT INTO big_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wok mabiyeng wok nakki pangka ngeragi nagi piyeng teni yane. ");
INSERT INTO big_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nugu kaile tonugu miza piyeng tumula logo keremareke wezamele, purik tenirau kaile nawiligu teniyegi keleya piyendau tumula logo weik keremareke wezamela. Watabi teni yang keleyagi piyengko mizagewiyege teni kaile miziweki keleya nagani. Inugu Anotoyegi pilik meizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Pilik yeiya logo puwiliyegi ngago saweliwei nara pelik yeiya, Tamizeige nigi ingembu nak kusa libuge kazing koweigemek neing niyegi kayima logo ni ngeragiyengki yeik purik mabura ni panga nigi ingembu nakki imakke kunagi logo piyegi pelik nguk meiyagi, Nana, towagi ingembu koweiga lewabek panga i nogomakke yagasi yolu kapura ne ngeragi pi managiyengki yeik legi nugu ngeragi nayeng nane, meiyagi. ");
INSERT INTO big_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kapura yeke igabokko pelik kaiya yo melagi, Nugu ne yawe yemane nani nagani. Kandik yaka waliya keya ne iyakong weik iwek koyinda. Togo ne yangalek meiya logo watabiyendau ni weiya nanagi ono, pugu pilik neiyagi. ");
INSERT INTO big_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Togo purik talik mizagi? Nogo iniyegi kozak yeiweki, Pugurau ni ngeragiyeng weiya naniweki yangalek meiyagi ono, pi nigi ingembubek kele kapura. Kapura tamizeige nugu mawiyarekka nguk mei mizageya puwekkerik pi yangalek meiya logo pugu nugu nguk kai piyeng mabiyeng nanagi. ");
INSERT INTO big_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Pilik tegi tamizeige ni Anotoyegi waberek mizi puwekke purik mabura mawiyarekka nguk mei purik Anotogo nanagi, keya ni piyegi welageya purik mabura ni piyegi yolok ngelagi, keya kang pugurikke ngago mei mizageya purik mabura pugu kerewiya logo koli neiyagi. ");
INSERT INTO big_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Purik Anotoyegi nguk mei mologabok watabi pugu nguk mei piyeng weik wei penanging keya piyegi weli mologabok purik piyegi yolok ngeli penanging, keya kang pugurikke ngago mei mizi mologabok purik Anotogo kerewiya logo weik koli mei penanging. ");
INSERT INTO big_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tamizeige ini mandikki mangowiliyaga nakki marekpokko niyegi kobulemek niweki nguk nei puwekke purik nugu nigi marekpek kemale Kuluwekmek niweki managi ma yeik? A’a’, yeik. ");
INSERT INTO big_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma pugu niyegi winak talek ngekpek niweki nguk nei purik nugu nigi marekpek kozangaingmek niweki managi ma yeik? A’a’, yeik. ");
INSERT INTO big_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ini yombanuwili kaile mizi kele kapura inugu inigi marekngangwili ngeragi keya watabi wazono piyengka yani miziwili. Mena, Anoto inigi Mango paka ngalege kaile nayendau mizi onobekyegi inugu nguk mei piyeng pugu yanagi, ma yeik? Ei, keya pugu lewege narik yanagi. Yongkambanu Anotoyegi pigi Kung Walekpekki nguk mei puwili Anotogo yanagi logo puwili weiyagi. Yisugu pilik ngago piyeng pugu waligeleyiwiliyegi yeiya. ");
INSERT INTO big_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Togo kerewa kiligawere waliyibek yombanubekki yenge yungke kiliya kopong yombanubek ngago kaiyagirik pangka ono, ngagoluk yolu kapura Yisugu kerewabek yombanubekyaga welagela wezamela mabuwekke yombanubek weik ngago kai. Yongkambanu wawere ulamek mamok pakela logo lelengkira. ");
INSERT INTO big_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kapura puwiliyaga nawiligu pelik kisi, Talik miza logo pek kerewawili welagela wezayeli? Takko pi kozang mani? Kerewawiligi ngaibek Sadang, yeik pigi nara Piyesebu, logo pugu pok kerewawili welagela wezayeliweki kozang mani kani, kisi. ");
INSERT INTO big_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Keya nawili kozang pugubek yang kelemiyagi keliwili piyegi Anotogo keke mizi paka ngilumbekka nara mizibene nguk meiya logo puwili iwakaweki. ");
INSERT INTO big_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kapura Yisu kangka puwiligiyengki iwaka legi pugu ngago saweliwei nara pelik yeiya, Tamizeige Kapmanwili ngezewiligi tepekke ngai keli puwekke purik kozang koyagi ono logo kawiyegi. Ma tamizeige yombu nak ibuwili ngezewiligi tepekke ngai keli puwekke purik sanga miza logo nawili narikke miza melagi. ");
INSERT INTO big_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kazing mabilikmekke tamizeige Sadangko ngaiwili ngezewiligi tepekke ngai keli purik Sadangki ngaimek kozang wizei penangai ono, yeikki. Inuwago ne Sadangko kozang pugubek nana logo nogo kerewawili welagela wezayeli kisi. ");
INSERT INTO big_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kapura tamizeige ne kerewawili kozang Sadangkirago welagela wezayeli kesak iniyegi kiriweiwilirau kozang Sadangkirago kerewawili welagela wezayeli. Togo inuwayegi kiriweiwili kerewa welagela wezayeli puwiligu ngago inuwagira ngaigu kisi mizi. ");
INSERT INTO big_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sadangko ne kozang nana ono, pilik segeya Anotogo ne kozang pugura nana logo nogo kerewawili welagela wezayeli logo purikku walimizi purik Anotogo pigi ngaimekki ngai pura iniyegi weik kanda ngai wizinda, yeiya. ");
INSERT INTO big_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Keya ngereke Yisugu kazing pemekke saweliwei ngezebekki kozang panu puragi langai pelik yeiya, Yombanu ngai yemane nak lei keya wizang puguyeng kiling ngai yolu puwekke purik i pugumak keya watabi pigi pulogo piyeng yombiyangai wiziyagi. ");
INSERT INTO big_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kapura yombu ngai yemane panubokko piyegi ngai yaroya logo piyegi lewege miza logo puwekke purik pugu watabiyengki mangobekki lei keya wizang piyeng wageliwei kangki keya watabi pugu ngoweiya piyeng sanga mizagi. Togo purikku kai purik Sadang kozang kapura ne kozang panu kani, logo nogo pangka Sadangki kerewawili welagela wezayelagi. ");
INSERT INTO big_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Togo yongkambanu namele keya nak ne kiling sawela ono purik pi neyegi ngai mizi yagenda, keya namele keya nakko yongkambanuwili menalege wawere keleya nowiyi ono purik pugu puwili kazi kambeli keleyi yagenda, yeiya. ");
INSERT INTO big_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Keya ngereke Yisugu ngago saweliwei nara pelik yeiya, kerewabek yombanu nakki yenge yungka nakko welagela wezameliwekkerik pi paka yengelei ngezege pi yolugilege pakeliwei kang. Pi yolugi narik yolok ngela ono purik pi ngezebokko ngezebekyegi pelik mei, Ne ya ne makngezego ulogo wizamiya logo kayima puragi ngereke toweki, mei. ");
INSERT INTO big_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Togo pi kandobela logo tapakeleige pura yombanu yakabokki yenge yungkera watabi nayendau ono wizilege. ");
INSERT INTO big_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Pi morik kerewa korowali panu melenazik keya nazikka neyauwili iza wara logo puwili mabuwili kanda yombanubekki yenge yungke kiliya logo pulogo koyima. Togo yombanubok koka kaile wiziya kapura mabek weik pi kaile panu yolu. Togo purikku kai pura Yemizibek yombanu nakki yenge yaga yolu ono purik mabura Sadang ngereke yolugiweki yogi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yisu pura kozak kairaige pura yongok namologo yongkambanu lembekka piyegi ngalizi pelik mei, Nigi panu, ni wazaniya logo yebili nanamolo, wilik kagowing mizimele, meiya. ");
INSERT INTO big_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kapura Yisugu pelik meiya to mela, Purik kele kapura yongkambanu Anotogi ngagoragi kerewiya logo kiriwei miziwili wilik kagowing yemane panu miziwili kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yongkambanu nawilirau Yisuyegi pakeliweki kayima. Yisu yongkambanu kolokngagono wawere ulageya koyawiligi tepekke luweza logo pelik kaiya, Yongkambanu mabek peragewili kaile panuwili. Puwiligu neyegi kisirik pelik, Teniyegi Anotogo keke mizi nara waligeleye logo ni Anotoyaga kayimabek purik teni kimeike pakeliweki, kisi kapura nogorau Anotogo wik keke mizi nara ini pakelibene waligeleyagi ono, purik ulogo Anotogo keke mizi kozang nara yombu Yona meibekyegi kimeike miza legi. ");
INSERT INTO big_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Logo pugu keke miza pura pelik, koka walaka Yona Anotoyaga ngagora weiya logo kozak kaiyabek watabisi yemanemokko nguk tiya logo wok neyau watabisi yemanemekki yungke wiziya logo pulaga wok kalikebekke watabisi yemanemokko kungiza mela logo Yona ngereke wik wizagoma. Pilik miza purikku yongkambanu yereng Ninibe meiragawiliyegi Anotogo Yona puwiliyegi wezamela purikki waligeleya. Togo kazing mabilikmekke watabi Anotogo neyegi mizagi piyengko ini yongkambanu mabek perage pewiliyegi Anotogo ne yombanu paka ngalega kayimabek iniyegi wezanela purikki waligeleyagi. ");
INSERT INTO big_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Wok kalike panu Anotogo yongkambanuwili ngagozak keleyagibokko yongkambanu mabuwili yangalek meiya logo Ninibe yongkambanu Yuda onowiligu ini yongkambanu Yuda mabek perage pewiliyegi pelik yeiyagi, Ini kaile miza wiziga ini ngangang mizagi, purik teni Yonagi ngago Anotoyagaragi kerewiya logo kaile tonuguyengka kowita kapura ini yombu Yonayaga ngalegebokki ngago Anotoyagaragi kerewiya ono kopong ini ngangang mizagi, yeiyagi. Keya wok kalike panu Anotogo ngagozak keleyagibokko purik yongok Kuwin Ngai yongkambanu Yuda ono ngabelak lewe Saut Siba meibekkawiliyegi koka walaka ngai wiziyamologo ini yongkambanu Yuda ono mabek perage pewiliyegi pelik yeiyagi, Ini kaile miza wiziga ini ngangang mizagi, purik ne King Ngai Solomongu ngago iwaka wazono puguyeng kozak kairikki kerewiyiweki koweige kambela kapura ini yombu Solomonyaga ngalege inuwa kiling wizagomabokko ngago iwaka wazono puguyeng kozak kairikki kerewiya ono kopong ini ngangang mizagi, yeiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yisugu yeke langak pelik yeiya, Nakko lang nak langiya logo kaimirage yenge yungke liwik wiyagi ono ma kawiktikke yenge yungke liwik wiyagi ono, pilik segeya paka lalektage ngalege kimeike wiya wiziga yeke imak lambekki ngaiwaktikku kola wizibene logo yongkambanu ige lewawiligu lambekki ngaiwaktikki pakelibene. ");
INSERT INTO big_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Wire nuguyau korik nuguwekki lambek. Wire piyaugu kazing nigi yoklongko wei mizi yo keya to mizagimek waligeleni. Kazing mabilikmekke wilek kang nugubokko kazing ni wiziyagimek waligeleniweki Yisugi wilangkarik nigi yungke wiriyi pani kelemi. Tamizeige wilek kang nugubek pangka purik kazing nugu yolu pumok pangka. Kapura tamizeige wilek kang nugubek kaile purik korik nuguwek mabuwek kusabanurikku kola logo kazing nugu yolumek kaile. ");
INSERT INTO big_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tegi ni ni makngezego waberek ngai panu, nugurik nigi yungkerik wilangka yolu nobiyeng miza kapura nigi yungkerik kusabanu yolu nelegi. ");
INSERT INTO big_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tamizeige wilek kang nugubek mabok wilangkarikku kola keya kusabanu nangezirau ono purik mabura Anotoyaga yawe kozang nara nugu ne kimeike pakelibene niyegi wiriyagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yisu ngagoyeng kozak kaiyageya wizigeya yombu Palisi nakko Yisu pi kiling ngeragi niweki ngago meiya wiziga pi yeke ige yabela logo ngeragi niweki mogosa. ");
INSERT INTO big_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yisu ngeragi nagine were kaigesa logo ngeragi ni onorikki Palisibokko pakela logo pi lebuk miza mela. Purik Yisu Palisiwiligi kazing waberek kaigesa logo ngeragi nimekki kiriwei mizi ono kopong. ");
INSERT INTO big_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yisu Palisibokko kumula piyengki iwaka legi piyegi pelik meiya, Inugu mizira kak keya pelengyengki ngalegemek keke kaigesi kapura yenge yungke sipengyeng kaigesi ono pilik mizi. Purik ini Palisiwili korik yeik yeke ngalege piyeng keke kaigesi kapura yenge wilek kang inuguyeng kazing kerezi mizi keya kaile mizi piyengko wilak panu kani. ");
INSERT INTO big_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ini Palisiwili yombanu kangka yeikwili. Anoto korik inuguyeng keremizabok mabilik yenge wilek kang inuguyendau keremiza purik ini iwaka ma yeik? Pugu mabiyau keremiza legi mabiyau kaigesagirikki kai. ");
INSERT INTO big_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yenge wilek kang inuguyeng kaigesa logo puwekkerik yongkambanu watabiyengki yeik puwiliyegi ini yalek kelagi logo watabi inigi piyengka yanagi logo nawiligu ini weik yenge wilek kang inuguyengka yeke korik inuguyendau kaigesarikki pakelagi. ");
INSERT INTO big_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kapura ini Palisiwili yomono, ini waberek panu purik kalike Anotogo iniyegi ngangang yanagi legi. Purik ini panga yawega ngeragi inuguyeng mabiyeng wawiyi puwekke purik waberek sanga miza logo limak meleyau keremizi logo narik Anotoyegi waberek panu mani miziwili. Purik pangka kapura ini kazing Anotogi yemane panumek yomizora wezameli, purik pelik, ini kazing yongkambanuwiliyegi pangka mizi pumok keya kazing Anotoyegi keli pumok mizi onowili kani. Pilik legi kalike Anotogo iniyegi ngangang yanagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ini Palisiwili yomono, ini waberek panu purik kalike Anotogo iniyegi ngangang yanagi legi. Purik ini yombanu kiligang neyau lewawili keya ini i walek songonomakke mogosiyengke paka orozarikke mogosi purikki keli panuwili keya pundikke yongkambanuwiligu mamokki wirege iniyegi yemanebek wangane keya pilik yei piyengki ini keli panuwili kani. Pilik legi kalike Anotogo iniyegi ngangang yanagi. ");
INSERT INTO big_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ei, nganganda iniyegi yuke yolu. Ini yengebekke yungke kawik yombanu waliyarikki ngalengale yongkambanuwili lusuweiwili ngabelak yeiktik nobiyeng wei yongomo mizi piyeng kelikwili. Logo purik pelik, yenge inigi yungkeyeng korowali kapura yongkambanu yeikwili purikki lusuwei kopong puwili inuwago lo keremizi piyengki kiriwei mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pilik yeiya logo yombu Mosegi loyengki wazono iwakawiliyaga nakko Yisuyegi pelik meiya, Kiriwaga, nugu pilik kai purago teni Mosegi lo piyengki waligeleyiwiliyegirau ngago korowali nara yowa yo meli yagenda kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pilik kai legi Yisugu pelik meiya to mela, Ini waligeleyi Mosegi lo piyengkiwili inirau waberek panu purik kalike Anotogo iniyegirau ngangang yanagi kani. Purik inugu yongkambanuwili lo kolokngagono yani logo weik watabi kuneng talik miza logo waragi miza piyeng kelik kapura inuwa ngezerau yongkambanuwiliyegi sawela logo Anotogo puwiligu miziweki keli piyengkirau kozak yei ono legi Anotogo inirau ngangang yanagi. ");
INSERT INTO big_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Ini Mosegi lo piyengki waligeleyiwili waberek ngai panu. Purik kalike Anotogo iniyegi ngangang yanagi. Purik inuwa inuwagi yelibungang koka walaka yombanu Anotoyaga ngagora weiya logo kozak kisawili yela puwiligi yombu longyengke yengelei simengyengkayeng keremiza keya yengelei kabu wazonoyengka wiya logo ngokmana wiya wiziga inuwago pilik mizi purikku kazing korowali inuwagi yelibungang kokawiligu pilik miza pumok pangka nobiyeng mizi legi ini nganganda weiyagi. ");
INSERT INTO big_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Koka walaka Anoto, watabi kalike mizagiyeng mabiyengki iwakabokko pelik kaiya, Nogo yombanu ngago kalike mizagiyeng kozak kisiwili keya yombu ngago nogora kozak kisi Aposolowili meiwili yombanuwiliyegi wezayelagi kapura puwiligu yombanu wezayelawiliyaga nawili ngangang yanagi keya nawili yela logo ibengki, kaiya. Ngago pura kozak kaiya mabilik ngizi lewagela. ");
INSERT INTO big_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Koka solo panuwekka kai kayimeige yokopekke perik inigi yelibungang kokawiligu Anotogo wezayela puwili mabuwili yela. Solo panu ulabek Abele keya piyaga uli kayimeige Sakaraya i walek yemanemakka alataragi keya walek panumakkirau tepekke ula kapura ini kele weik mazenda kaile ngalege panu narik miziweki mereke logo purik ini weik ne neliweki mizi, legi purikki wiyeke ini yongkambanu perage puwili ngangang inugura keya inigi yelibungang kokawiligi purarau ini kemenak weiyagi. ");
INSERT INTO big_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ini Mosegi loragi waligeleyiwili waberek panu, purik kalike Anotogo iniyegi ngangang yanagi. Purik ini Anotogi ngago wameik Kapiya Walektikke kazing yombanu yaliya wazayagi pumokki langai kozak kai puragi ini ngizi kumulagirikki kiyebuk kopong yongkambanuwiligu kerewiya nelegi inugu kozak yeiya ono. Keya ini makngezego iwaka sarik kokowa lewengke kopong ini makngezerau nogo ngago wameik kozak kai pura wei ono logo yongkambanu wameikta weiweki miziwiligi kazingmek inugu waliyi legi ini waligeleyi Mosegi loragawili ngangang yemane weiyagi. ");
INSERT INTO big_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yisugu puwiliyegi ngago piyeng yeiyarikki wiyeke puwili sisik yemane miza logo puwili piyegi kiriwei i pumak wiya logo yenge yerengke welagela kula. Mosegi loyengki waligeleyiwili keya yombanu Palisiwili meiwili ngago ngaigu nayeng Yisuyaga kerewiyagi nobiyeng watabi kolokngagonoyengki nguk mei keya mizarik yawe yemane panu miza. ");
INSERT INTO big_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Puwili ngago korowali pi ngagozak kelemiyagi nara kili puguraga kaiyagi nobiyeng, puwili puragi ngai yuke panu koya. ");
INSERT INTO big_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pilik mizageya koyarik yongkambanu kolokngagono puwili kiling menalege wawere ulageya koyawili tektek tiya wizigeya kang tamekke yaung tiyagi miza logo nakko nak ingeyengko momane mei kang keya mizi. Pewekke Yisugu puwiliyegi ngago yana kapura were pugu yombu ngezebokko waligeleyiwiliyegi ngago nara pelik yeiya, Yombanu Palisiwili meiwiligi ngeragi Yis meirikki yaweragi kani ini ngai waberek panu koyi kunizo. Palisiwili yombanu kiligang neyau lewawili kani, purik puwili Anotogi loyeng kazing kokowa lewengke langai iwaka kopong puwiligu ngaigu pelik kisi, Teni Anotoyegi yawe miziweki, kisi kapura kazing puwiligu miziyeng kaile kani, waberek panu. Kazing puwiligu mizi pumok ngeragi yisrik kelik. Purik perek keremiziwekkerik yis songono narik palewarik kiling ngelaming wiya puwekke purik perek yemane nazik lewagelagi logo mabilik kazing yombanu kiligang neyau lewawiligi pumok inigi tepekke songono wiriya logo kazing pumok inigi tepekke yemane lewagela sa nelegi waberek panu. ");
INSERT INTO big_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kapura puwiligu kazing kaile mizi piyeng liwik wiyagi langai ono. Purik kazing kaile puwiligu ngokmorokta wiya piyeng kalike kimeike walimizagiyeng keya kazing kaile puwiligu mizi wizigeya liwik yolu piyeng wangki kalike kimeike kawela wiyagiyeng kani. ");
INSERT INTO big_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Togo ngago inugu ini kekewekke kisi piyeng kalike yongkambanuwili mabuwili kimeike kerewiyagi kani. Keya ngago i inuguyengke yeke ige ngago ngezengezege kozak kela piyeng kalike yongkambanu mamokki wirege ngalizi kozak kisagi kani. Tegi inugu kisagi piyeng keya mizagi piyengki waberek panu. ");
INSERT INTO big_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ini negi kewengkewili legi ne iniyegi pelik yeiweki, Yombanu korik yeikwek ula logo ibengki kapura wilek kambek keya kumbekki kaile nayendau kelemiyagi langai ono puwiliyegi ini kulili mizi nagani. ");
INSERT INTO big_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nogo inugu keke kulili mizagibekyegi yeiweki, Anotoyegi purik pi korikwek ibeng wazamiya logo wilek kambek keya kumbek pongo yereng yezi kusagi onozik ngoriraga yomizora wezamelagi logo pokyegi kele ini kulili mizizo. Legi kerewiyi, pura wameik kani. Piyegi kulili miza logo kazing pangkamekke piyeng mizizo. ");
INSERT INTO big_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Yombanuwili winak songono winak Kemengiwili kelikwili melenazik king korok neyaugi ngane wei logo Anotoyegi wata kolak kelibene miziweki purik ini iwaka. Winakwili yeik songonowili kapura Anotogorau winak songono puwiliyaga namekyegi keremareke ono kani. ");
INSERT INTO big_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Keya iniyegirau Anotogo keremareke ono. Kerewiyi. Kebi inuguyengka kebi nganelek piyeng mabiyeng pugu sangkela. Purikku walimizi purik yombanu wamenak winak kolokngagono puwiliyaga ngalege mizi yagenda. Tegi Anotogo iniyegi ngai wizinda legi kazi mizi nagani. ");
INSERT INTO big_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ini yeik kerewiya koyi. Yongkambanu mamokki wirege yeik nogora kawela wiyi mologabok kalike ne yombanu paka ngalega kayimabek Anotogi angelawiligi wirege pilik kawela wiya pumologabokki yeikta nogo kawela wiyagi. ");
INSERT INTO big_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kapura tamizeige yombanu nak yongkambanuwiligi wirege neyegi kezanga nani purik mabura kalike ne Anotogi angelawiligi wirege piyegirau kezanga managi. ");
INSERT INTO big_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yombanu nakko ne yombanu paka ngalega kayimabekyegi langai ngago kaile nara kaiya purik Anotogo pura tumulagi kapura nakko Anotogi Kung Walekpekyegi langai ngago kaile kaiya purik Anotogo pura tumulagi ono. ");
INSERT INTO big_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Keya tamizeige neyegi kiriwei mizirikki wiyeke puwiligu ini kebangkela logo i walek songonoyengke ma yerengke ma kapman ngaiwiliyegi ngagozak keleyiweki iza orowei purik mabura ini were wilek ngelek kumuli nagani ma talik kaiya to melagi mizi nagani ma ngago talikyeng kisagi mizi nagani. ");
INSERT INTO big_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Purik Anotogi Kung Walekpokko mabuwekke inugu kisagiyeng iniyegi kozak yei penanging kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pulaga yombu pulogo wawere ulawiliyaga nakko Yisuyegi pelik meiya, Kiriwaga, nugu negi sibekyegi watabi tegi mangobokko wizami kambela piyeng sanga miza logo ne nogoyeng nane, mei, meiya. ");
INSERT INTO big_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kapura Yisugu pelik meiya to mela, Yombanubek, takko ne watabi pilik piyeng pangka pangka mizi ma watabi piyeng yaliyegi sanga miza yanagibek kai? Yawe pura nogora ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tegi Yisugu mabuwiliyegi mazenda kozak yei keya pelik yeiya, Yombanu nak watabi kolokngagono pigi piyengko mizagewiyege yombiyangaigi ma ngizi wirere wiziyagi ono kani, pi yombu watabiyengko kolabek kele kapura. Tegi waberek ngai panu. Watabi kolokngagono weiyagi purikki keli nagani ma kazing nakki watabiyengki ngora kelimek mizi nagani. ");
INSERT INTO big_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Togo puwili purikku kai pura ngizi iwaka sibene Yisugu ngago saweliwei pera pelik kozak yeiya, Wok nakke yombu watabiyengko kola nak wizagoma. Keya yawe puguleige ngeragi wazonoyeng kolokngagono. ");
INSERT INTO big_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Piyengki pakela logo pi weik ngezebek pulogo kumuli, I songono nogomak wilak. Ne i keya watabi keya ngeragi nogoyeng ngezara wiyagi namaktau ono. Legi ne talik mizagi? ");
INSERT INTO big_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Logo pi ngezebokko ngezebekyegi pelik kaiyageya wiziya, Ne pelik mizagi. Ne i songono nogomak topela logo unatuba panu ngiziweki logo pulogo ne ngeragi nogoyeng keya watabi kolokngagono nogoyeng pulogo wiyiweki, kaiya. ");
INSERT INTO big_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Togo pi pilik miza logo waleleige wilek kang pugubekke pelik miza, Ne kangka yemane, purik ne ngeragi kolokngagono wazono nagiyeng keya watabi wazono kirisimasi kolokngagonoyengke wiziyagiyeng kiling mena, ne weik kumaniweki logo ngeragi ni keya kai ni keya wilek kang nogobek wilikwilikmokko kolaweki, pilik kumula. ");
INSERT INTO big_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kapura Anotogo piyegi pelik meiya, Ni kangka yeikpek kani. Mabek wokpekke kusage ni ibengki logo nogo wilek kang nugubek weiyagi kani. Togo takko watabi nugu wawiya piyeng weiyagi? Nugu piyeng ni kiling orowei kangki ono. Anotogo piyegi pilik meiya. ");
INSERT INTO big_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Togo nogo iniyegi pera yei, Kazing mabilikmekke yombanu watabiyeng kolokngagono ngezewiligi wawiyi kambeliwili watabi korikwekki kekeyeng kilingwili kapura Anotogi wireyaugerik, puwili watabi kumbekkiyengki yeikwili kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pulaga Yisugu yombu ngezebokko waligeleyiwiliyegi pelik yeiya, Piliktikki wiyeke nogo iniyegi pelik yei, Ngeragi ini wik yoluweki nagi piyengki wilek ngelek kumuli nagani ma kagorik korikwekke wakiyagi piyengki wilek ngelek kumuli nagani. ");
INSERT INTO big_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Purik wilek kang inuguyeng pangka yolu pura ngeragi keremungke nagi puraga ngalege panura kani, keya korikwek kagorik wik wakiyi piyengka ngalege panu kani. Tegi ngeragi inugu nagi piyengki weli keya kagorik inugu wakiyagi piyengki wilek ngelek kumuli nagani. ");
INSERT INTO big_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Winakwiligu yolu puragi pakeli. Winakwili yawe ngeriyi onowili, ma ngeragi wawiya logo i namakke ngeragiyeng kalike niweki wiyi onowili kani, kapura Anotogo puwili ngeragi yani kani. Winak songonowiliyegi wiyeke Anotogo ngairik yemane kapura pugu iniyegi ngairik yemane panu. ");
INSERT INTO big_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Watabi pilik piyengki wilek ngelek kumuli pumokko ini puwiliyaga nakki ngabelak pobokko wik yolugi pura yokolong panu kelemiyagi ma yeik? A’a’, yeik. ");
INSERT INTO big_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mena wilek ngelek kumuli pumokko wik yolugi pura yokolong panu kelemiweki sawelagi langai ono legi ini watabi nayengkirau wilek ngelek kumula meli nagani, yeik Anotoyegi wilekyeng ngalege wiyi. ");
INSERT INTO big_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Keya purukpuruk Kailiyawamerekke kumuli. Pumorok yawe mizi onomerek ma ngezemerekki wakiyagiyeng keremizi onomerek, kapura kerewiyi, Anotogo Kailiyawa purukpurukmerek palumu panu wakiyagiyeng mani. Koka walaka King Ngaibek Solomon meiyabek watabi keremungkeyeng kilimbek watabi palumu panu puguyeng wakiya kapura purukpuruk peyengko Solomongu watabi wakiya piyengki ngaira ula. ");
INSERT INTO big_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Anoto kailiyawa songono mabek wokpekke yolu keya wangkopekke ngoliyagi piyengki pi ngai yolu mizi legi pugu iniyegi mabilik waberek ngai wiziyagi kani logo pugu pilik mizagi kapura inugu purikki ngizi kumuli inugura songono panu. ");
INSERT INTO big_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Togo kang mabiyeng korik inuguyengko weiyagi piyengki tiya mani nagani ma wilek ngelek kumula meli nagani. ");
INSERT INTO big_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yongkambanu ngabelakpekke Anotoyegi iwaka ono puwili kang mabiyeng watabi pilik piyengki wilek kang tiya maniwili. Anoto inigi Mangobek ini ngeragi keya kai wik yolugiyeng wei keya kagorik wakiyagiyeng weiyagi purik pugu iwaka mena wilek ngelek kumuli nagani. ");
INSERT INTO big_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kapura tamizeige ini Anotoyegi wilek kang tiya mani keya inugu pi iniyegi ngai wizeibene kelemi keya pigi kazing pangka mizi pumokki wilek kang tiya mani mizi puwekke purik mabura pugu ini watabi ngoluk wik yolugi piyeng mabiyeng yanagi kani. ");
INSERT INTO big_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ini neyegi kiriweiwili keremungke ono kele kapura kazi mizi nagani, liyeng memengwiligu nguk namizi kazi mizi pilik ini mabilik kazi mizi nagani, purik kalike wok nakke Anoto inigi Mangobokko yongkambanu puguwiliyegi ngai puwekke keli pugurago inirau ngaiwili mizibene keleyagi. ");
INSERT INTO big_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Inugu watabi inigi piyeng nawiligu weibene yani logo kingyeng weiya logo yongkambanu watabiyengki yeik puwili yanizo. Pilik mizi purago kanga inigi wazonoyeng paka ngalege yolugi logo paka ngalege kanga inigi wazonoyeng yeikki ono, purik yombanu ngoweiwili ngoweiweki yabelagi ono ma wata koru watabiyeng ni namokko korowali kelemiyagi ono. ");
INSERT INTO big_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tegi inugu paka ngalege Anotoyaga kanga wazono weiyagi piyengki kumulizo, purik inugu kumuli piyeng wilek kang inuguyeng mabiyeng tiya mani piyeng, yeiya. ");
INSERT INTO big_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Pulaga Yisugu mawinda pelik yeiya, Ne lewarikki kani kagorik inuguyeng kozang waliyizo keya lang inuguyeng langiyageya koyizo logo wok mabiyeng kangkere mizageya koyizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Pilik yeiya logo ngago saweliwei pera kozak yeiya, Wok nakke yombu ngai yemane nak ngeragi yemane yongkambu weiweki miza niraga kambela logo piyegi yombu yawe miziwili i pugumakke kagorik wakiyi keya lang langiyi keya pi yorikka ngai yuke koyima. Yombu yemanebek kanda ngago yeiwekke pigi yawe miziwiligu nguk namizi kandik tiya mowiyagi. Yombu yawe miziwiligu puwiligi ngaibek yogirikki kangkere miza koyima pilik ini ne yogirikki mabilik kangkere miza koyizo. ");
INSERT INTO big_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tamizeige yombu yawe miziwili ngoluk wirere keya kangkere mizara tagogei yombu ngai puwiligibek yo purik puwili wilikwilikmokko unatuba panu mizagi. Kerewiyi. Wameik panu, ngaibokko puwiliyegi wilik mizagi logo pugu kagorik yawe mizi puguyeng wakiya logo puwili mogosibene yeiyagi. Togo puwili piyegi yawe miziwili kele kapura pi ngezebokko puwili ngeragi miza niweki yanagi. ");
INSERT INTO big_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tamizeige ngaibok kusa libuge weik lewa ma kusage winakmokko were ngago kaiwekke weik lewa logo tapakeleige yawe miziwili pilik wirere kangkere miza koyilege purik puwili wilikwilik yemane panu mizagi. ");
INSERT INTO big_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Keya pilik kumulizo. Tamizeige yombu i namakki mangobokko yombu ngoweiyagibek lewagi pura iwaka purik pugu ngoweiyagibek watabiyeng ngoweibene kelemiyagi ono. ");
INSERT INTO big_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pilik tegi inirau kazing pilikmekke wirere kangkere miza koyizo. Purik ne yombanu paka ngalega kayimabek lewagi ono miza purage ngereke lewagibek kani, legi ini kangkere miza koyizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yisugu pilik yeiya logo pulaga Pitago Yisuyegi pelik meiya, Yemizibek, ni ngago saweliwei kozak kai pura tonuwayegi keke kozak kaira ma ni yongkambanu mabuwiliyegirau kozak kai yagenda, meiya. ");
INSERT INTO big_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Logo Yemizibokko pelik meiya to mela, Ei, nogo kozak kai perik ni keya yongkambanu yawe nogora pangka iwaka keya mizi wilibek puwiliyegi langai kozak kai yagenda. Yombu yawe mizi pangka panu kazing pangkamek keya iwakamekke mizi logo ngai yemanebokko nawiliyegi ngai wazamiyabek kelik miziweki. Ngai yemanebokko yombu yawera pangka mizibekyegi pakeli puwekkerik pugu piyegi pelik meiyagi, Ni negi ngai nak mizagi keya yombu negi yawe mizi nawiliyegirau ni ngai wazaniyagi keya ni watabi keya ngeragiyeng puwiliyegi pela yanagibek, pilik meiyagi. ");
INSERT INTO big_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pilik miza logo ngai yemanebek kangki. Kalike yowekke tamizeige pugu yombanu ngai wazamiyabok yawe pugu kozak meiya pura mizageya wizilege pakela purik ngai wazamiyabok wilikwilikmokko unatuba panu mizagi. ");
INSERT INTO big_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Purik ngai yemanebokko pelik meiyagi, Ni yawe wazono mizibek, ni ngoluk yombu negi yawe mizi nawiliyegi ngai keya weik watabi negi piyeng mabiyengkirau waberek ngai wizeimo, meiyagi. ");
INSERT INTO big_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kapura tamizeige ngai wazamiyabokko pelik kumuli, Ngai yemane nogobek nguk namizi lewagelagi ono mena, miza logo pi weik yongkambanu yawe miziwili yeli keya keleyi keya ngeragi kolokngagono ni keya kai nameli keya miza mela purik ");
INSERT INTO big_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kalike ngai yemanebek wok nakke lewagi purik wok ngai wazamiyabek piyegi yuke ono, ma pi lewagi ono, mizabokko ngai yemanebek weik lewa logo pugu ngai wazamiyabekki kazing kaile mizimekki pakela logo piyegi ngangang yemane kelemiya logo pugu pi pongo lemengke yongkambanu Anotogi ngago puragi kerewiya logo kiriwei mizi ono puwili kiling pulogo wazamiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Yisugu ngago saweliwei pura yeiya logo purikku kai pura pelik yeiya, Yombanu ngaibekyegi yawe mizi nak ngai pugubokko yawe miziweki meiya piyeng iwaka kapura pi yawe pura miza ono keya ngai pugubokko keli piyeng miza onobok, ngai pugubokko wizale yemane panu ulagi. ");
INSERT INTO big_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kapura yombanu yawe mizi nak ngai pugubokko kaira iwaka onobok, kazing pugu kaile miziyengki wiyeke ngangang mizagi kapura ngai pugubokko wizale songono ulagi, yeiya. Togo tamizeige Anotogo ni yawe yemane nara ngaiweki nana purik mabura Anotogi kelirik ni yawe puraga yawe kozang panu miziweki keli. Keya yombanuwiligu nakyegi mawiyarekka pangkabek mizibok yombanuwiligu pi mawiyarekka kazing pangkamekke mizi kunibene yuke koyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Pulaga Yisugu mawinda pelik kai, Ne kayima purik pelege ngabelakpekke yezizik waliyiweki keya ulogo langiya kesak nogo keli. ");
INSERT INTO big_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kapura ne were ngangang mizagiraga kiliya kuna logo, keya wilek nogobek kuneng panu wiziya weik nogo yaka kai pura miza logo puwekke yeikkine, yeiya. Togo purikku kai pura Yisu nganganda wagela logo ibengki puragi kai yagenda. ");
INSERT INTO big_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Inuwago kumularik ne ngabelakpekke kazing yombiyangai yongomo mizagimek keremiziweki kayima nobiyeng? Pilik ono kani. Ne pelege yawe yongkambanuwili ngai neyauge sanga mizagi pura miziweki kayima, purik nawili ngago nogoragi ngizi panu kumulagi keya nawili ngago nogoragi ngizi panu kumulagi ono legi. ");
INSERT INTO big_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mabek pewekka purik neyegi weraga yombu nak ibuwili sanga miza logo neyauganak neyegi ngizi panu kumulagi keya neyau neyegi ngizi panu kumulagi ono. Ma pilik sanga miza logo neyau neyegi ngizi panu kumulagi keya neyauganak neyegi ngizi panu kumulagi ono. ");
INSERT INTO big_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Puwili pelik sanga mizagi, mango koyambekyegi ngai mizagi, keya panu kolomeleyegi ngai mizagi, keya panu koyambekki yongokpumeleyegi ngai mizagi kani. Ne pilik miziweki kayima, yeiya. ");
INSERT INTO big_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Keya pugu yeke langak peyendau yongkambanuwiliyegi pelik yeiya, Inugu kozainung kusabanurik yokmek ngokmorokta wiyi purikki pakeli purik inugu nguk namizi pelik kisi, Koboyau lewa mena, kisi logo weik kobo kuli. ");
INSERT INTO big_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Keya ini kusarikke kilili mizi keya pelewewili ngaiwak yemane panu wiya yolu purik inugu pelik kisi, Wangkopek yokmek ngai panugi kisi, logo yokmek weik ngai panugi. ");
INSERT INTO big_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ini yombanu kiligang neyau lewawili, purik ini ngabelakpekki pakeli piyengki iwaka keya ngilumbekki pakeli piyengki iwaka kapura inugu kisirik watabi mabek pewekke neyegi langai mizi logo pakeli piyengki iwaka ono kisi legi. Inugu pilik kisira nangki? ");
INSERT INTO big_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Keya inuwa ngezego kazing pangka piyengki miziweki waberek kozak keli onora nangki? ");
INSERT INTO big_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nguk namizi kazing inugu kaile miziyeng waberek mizi, ini ngagozak keleyagibek lewa nera. Keya pi lewa logo ini panga kazingke yombu ini ngagozak keleyagibok kiling kunimowei puwekke purik mabura pi kiling inugu kaile miza piyeng kozak kela logo yeik sa wiyizo purik pugu ini ngagozakta kebangkelagibekyegi iza orowei kuna nelegi, keya pugu wagelawiliyegi iza yana logo puwiligu i wigirimakke wigira wazaya nelegi. ");
INSERT INTO big_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kerewiyi. Pilik miza puwekke purik ini i wigiri pumakka welagela yeragiyagi ono wiziya wiziya inugu ini ngagozak keleyagibekyegi watabi kaile inugu mizi kayima piyengki kangayeng mabiyeng mana purik mabura kele, yeiya. ");
INSERT INTO big_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mabuwekkerik yombanu nawili ngago nara Yisuyegi kozak meiweki kayima. Kanda Yisuyegi kozak meiya, Yombanu Yuda Kalili ngabelakpekka nawili yereng Yirusalem yemane puragi kambela logo Anotogi i walek yemanemakke pulumakau ula logo Anotoyegi iwiyeng kolak miziweki, keya pilik mizageya koyigeya yombu ngabelak Yudaya meibekki Rom Kapman ngaibek Pailet meibokko pigi ami nawiligu puwili yeliweki wezayela. Pilik miza logo puwili ibeng purikki kozak meiya. ");
INSERT INTO big_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yisu purikki kerewiya logo pugu puwiliyegi pelik yeiya to mela, Inugu kumularik yombanu ibengwiligu kaile mizayeng ini Kalili yongkambanu nawiliyaga ngalege panu ma talik? Pilik ono kani. ");
INSERT INTO big_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kerewiyi, iniyegirik ini kaile inuguyengki kuneng miza logo kaile inugu miziyengka kowitizo keya wilek kang inuguyeng Anotoyegi sawelizo. Tamizeige pilik mizi ono purik inirau ibeng koyimagi. ");
INSERT INTO big_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Keya periktau, inuwago kumularik talik? Nangki wiyeke yombanu meleyau keya pongo ingenazik keya nazikka neyauganak yereng Yirusalem mei puragawili, i yemane yokolong ngalege yereng Silom mei puraga yolu pumakko puwiligi ngalege topelora wala logo puwili ibeng. Inugu kumularik yombanu ibengwiligu kaile mizayeng yongkambanu Yirusalem yolu nawiliyaga ngalege panu nobiyeng? Pilik ono kani. ");
INSERT INTO big_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kerewiyi, iniyegirik ini kaile inuguyengki kuneng miza logo kaile inugu miziyengka kowitizo keya wilek kang inuguyeng Anotoyegi sawelizo. Tamizeige pilik mizi ono purik inirau ibeng koyimagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yisugu yeiya logo waleleige ngago saweliwei pera puwiliyegi kozak yeiya, Yombanu nak yengelei Fik mei nalei yawe waing puguleige ngeriya wazamiya. Wok nakke pi wilekyeng yengelei puleiga tiyiweki kambela. Pi kanda wilekyengki yengeleileige ngalege pakela kapura nayendau wira ono. ");
INSERT INTO big_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tegi pugu yaweleige yawe mizibekyegi pelik meiya, Pakele, kirisimasi neyauganara ne yengelei Fik peleigi kanda pelege pakeli mizageya wiziya, kapura nogorau wilek nayeng tiya ono. Tegi kira mele. Pugu ngabelakpekki kolokpek nageya yolu nelegi yengelei wilekyeng wiri ono pulei kira melimo, meiya. ");
INSERT INTO big_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yaweleigi yawe mizibokko pelik meiya to mela, O Peba, kirisimasi wamenara perarau wizi pani logo nogo yengeleileigi sologomek ngabelak kira logo liyeng pulumakauwiligi yayengka kola wiyiweki mizi mena. ");
INSERT INTO big_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pilik miza logo waleleige tamizeige kirisimasi kalike narage wilekyeng wira purik wazono kapura tamizeige yeik purik mabura nugu nogo kiriweki kozak nei mangine logo nogo kiragine, meiya. Kazing mabilikmekke ini yengeleiyeng kelik. Anotogo kaile inuguyengki pakela logo yengeleiyeng kelik kira mela nelegi kuneng miza logo kowiti mizizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wok nakke wok Yudawiligi yawe mizi onobek, wok Sabatpek meibekke Yisugu yongkambanu Yudawiliyegi ngagora i walek songono puwiligi namakke yeke ige waligeleyageya wiziya. ");
INSERT INTO big_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Logo yongok namele pulogo wiziya, logo moloyegi kerewa nak yolu. Togo kerewabokko piyegi kemegememek mana logo pi wizagomara kirisimasi meleyau keya pongo ingenazik keya nazikka neyauganara logo purik yongokmologi koza yeke kezangabekke pok weik kolok kolik miza logo luwe tungkulagi ono. ");
INSERT INTO big_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Logo Yisugu piyegi pakela logo piyegi yarobene ngago meiya logo pelik meiya, Yongokmele, nogo weik kemegeme nugumekka wila wazaniya kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Logo Yisugu mele puguyau yongok kemegememelegi ngalege walamiya ngizige pi weik luwe tungkula logo luweza logo Anotogi yeikta yongolok meiya. ");
INSERT INTO big_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pilik miza logo i walek songonomakki ngaibek Yisuyegi sisik miza, Yisugu wok yawe mizi onobekke yongokmele yombiyangai wazamiyarikki wiyeke. Tegi i walek songonomakki ngaibokko yongkambanu pulogo koyawiliyegi pelik ngalik yeiya, Wok melenazik keya nazikka nak teni yawe mizagiyengko logo wok piyengke yombiyangai wazayiweki lewa purik pangka kapura wok teni yawe mizi onobekke yombiyangai wazayiweki lewa nagani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ngaibokko pilik yeiya legi Yisu Yemizibokko piyegi pelik meiya to mela, Ini ngaiwili kiligang neyau lewawili. Ini puwili mabuwili nak nak liyeng pulumakau ma tongkiwili i puwiligiyengka iza orowei panga kaige kai nibene wok yawe mizi onobekke iza orowei kang miziwili kani, logo purik pangka. ");
INSERT INTO big_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Keya nogo yongok pemeleyegi wok yawe mizi onobekke sawela puriktau pangkarikku. Yongokwili liyengwiliyaga lewege panuwili purik teni iwaka. Yongok pemele Abalam kelik Anotoyegi kiriwei mizimele, kapura kemegeme pemokko pi wi wezabek tariya keya Sadangko pi kirisimasi meleyau keya pongo ingenazik keya nazikka neyauganarayeng kebangkela wizagoma kani. Pilik tegi wok yawe mizi onobekke nogo wi pi kebangkela wara yolubekka wila wazami yagenda, pi yombiyangai wazamibene purik kaile ma, pilik nguk meiya. ");
INSERT INTO big_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yisugu ngaibekyegi meiya to melarago Yisuyegi kiyebuk mizi puwili kendek mizibene keleya logo yongkambanu pulogo Anotoyegi ya kumuli kayima pumok mamok watabi wazono panu Yisugu miza piyengki wilikwilik miza. ");
INSERT INTO big_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Keya Yisugu ngoluk yongkambanu Anotoyegi inge laliyi keya ya kumuliweki kayimawiliyegi ngagora pelik yana, Nogo Anotogo pigi ngaimekki ngai yolu pura nangaiyeng kelik kaiyagi? Keya ngago saweliwei taliktago ngai pumokki langai kozak kaiyagi? ");
INSERT INTO big_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Anotogo pigi ngaimekki ngai yolu pura yengelei wilek Mastet mei nak kelik. Yengelei wilek Mastet meiyeng wilek nayeng kelik yemane ono, yengelei Mastet puleigi wilekyeng songono panu kapura yombanu nakko wilek pok weiya logo yawe puguleige ngeriya puwekkerik kalike purik yengelei nayengka yemane panu lewagelagi. Keya puleigi meleyeng yemane panu logo winakwiligu kanda yengelei meleyengke igazi mizagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mawinda Yisugu nguk yeiya, Nogo Anotogo pigi ngaimekki ngai yolu pura nangaiyeng kelik kaiyagi? ");
INSERT INTO big_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Anotogi ngaimek ngeragi Yis meirik kelik. Yongok namologo yis songono narik weiya logo kaimi yemane nakke iwing palewayeng kiling ngelaming kelemiya purik kalike iwing palewarik maburik weik yisrikku mizagewiyege wilak wara wizei penangai, yeiya. Togo purikku kai pura pelik, Anotogi ngaimek solowekkerik songono kele kapura kai kanda kalike unatuba lewagelagi keya solowekke Anotogo yongkambanu ngai yolu puwili keremungke ono kele kapura kalike keremungkegi. ");
INSERT INTO big_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yisu paka Yirusalem kunimowei pugu yereng yemane keya songono piyeng mabiyeng neing yongkambanuwiliyegi ngago pugura waligeleyi kambela. ");
INSERT INTO big_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yereng narage yombu nakko Yisuyegi pelik nguk meiya, Yemizibek, yongkambanu Anotogo yaliya wazaya logo pigi ngaimekki pugu ngai yolu puragi kiliyi puwili mele sangkelagi, ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Keya Yisugu puwiliyegi pelik kanga yeiya to mela, Kang Anotogo pigi ngaimekki ngai yolu puragi kiliya kandik imakki kandik kelik. Logo kang purik koru panurikki wiyeke yongkambanu kolokngagono kiliya liweki yang mizagi kapura pangka kiliya lagi ono. Tegi ini Anotogo pigi ngaimekki ngai yolurage kiliya liweki yawe kozang mizizo. ");
INSERT INTO big_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Purik kang purikki mangobek kandik waliyi penanging logo pulaga ini yenge yerengka luwe koyimowei piyegi pelik meiyagi, Yemizibek teniyegi kandik tiye meiyagi. Puwekke pugu iniyegi pelik yeiya to melagi, Ini talaga lewa. Ini nogowiliyaga nak ono purik ne iwaka, yeiyagi. ");
INSERT INTO big_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Togo inugu piyegi pelik meiya to melagi, Teni ni kiling mogosa logo ngeragi ni miza puwili. Ni yereng tonuguyengke waligeleyabok, meiyagi. ");
INSERT INTO big_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kapura pugu iniyegi mawinda pelik yeiyagi, Nogo yaka pelik yeiya wizinda, Ini talagawili miza purik ne lusuwei logo ini nogowiliyaga nak ono purik ne iwaka. Ini mabuwili kaile miziwili mena neyaga kazi kuni, yeiyagi. ");
INSERT INTO big_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Logo kalike inugu inigi yelibungang kokawili Abalam keya Isak keya Yakop kiling yombanu Anotoyaga ngagora weiya logo kozak kisawili yereng Anotogo pigi ngaimekki ngai yolu purage yungke koyilege pakelagi kapura ini yenge yerengka mamiza puwekke ini ingkeya kelele yemane panu kisi keya kili inuguyeng ngiliti mizagiyagi. ");
INSERT INTO big_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yongkambanu Yuda ono neyegi ngizi kumuliwilirau pulogo Anoto kiling ngai pugurage yungke mogosa logo ngeragi nageya koyi nangai. Puwili ngabelak mabiyengkawili logo panga yokmek lewagela lagawili, keya panga yokmek kiliya lagawili, keya paka yongoleiga lewawili, keya pongo moleiga lewawili. ");
INSERT INTO big_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ini Yudawiligurik ini Anotogi ngaimekki pugu ngai yolu puragi kiliya kunagiwili mizi kapura nawili were kunagi keya ini Yudawili kalik panuge kunagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pilik yei ngizige yombu Palisi mei nawili Yisuyegi wiriya logo pelik meiya, Ni yereng pera wiya logo wale narikke kambele, purik Ngai Elodo ni neliweki mizi mena, meiya. ");
INSERT INTO big_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yisugu puwiliyegi pelik yeiya to mela, Nogo Elodoyegi meirik keri wizing kaile namek mei. Tegi ini keri wizing kaile pumokyegi kambeli logo piyegi pelik meizo, Ne yawe nogora miziweki Anotogo wok sawiyayeng wizinda logo Elodorau ngezangai Anotogo sawiya pura wandikke ngelagi langai ono. ");
INSERT INTO big_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Legi ne yawe nogora mizi kanda weik puwekke weikkine. Yombanu Anotoyaga ngagora weiya logo kozak kisawili paka Yirusalem yerengke yela legi ne paka Yirusalem kangweki mizi meizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yisu yereng Yirusalem puragi kumula logo yongkambanu pulogo yolu puwiliyegi yalek miza logo ingi ngaungaumek kiling pelik kai, O ini Yirusalem yerengke yoluwili, inugu yombu Anotoyaga ngagora weiya logo kozak kisawili yeli miza keya inugu Anotogo yombu iniyegi wezayeliwili kingyengko yeli miza. Keya winakmokko luguwili yenge sabengyauge kiliya wazayi pilik, kang kolokngagono nogo iniyegi waberek ngaiweki miza kapura inugu neyegi kezanga nana. ");
INSERT INTO big_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kerewiyi, Anotogo weik ini wezaya, i yombu naktau yolu onomak kelik keya yombanu ini kiling ngai kelagiwili lewa puwekke Anotogo iniyegi sawelagi ono. Logo nogo iniyegi pera pelik yei, inugu ngereke neyegi pakelagi ono wiziya ne wameik yombu Anotogo iniyegi wezanelabok mizi puwekke inugu pelik kisagi, Pok Anotogo teniyegi wezamelabek legi Anotogo pi kozanda maniweki, kisi puwekke inugu ngereke neyegi pakelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wok yawe mizi onobek Sabatpek mei nakke Yisu yombanu Palisiwili meiwiliyaga yemane nakki imakke pi kiling ngeragi niweki kambela. Kanda yeke ige mogosa. Yongkambanu nawilirau koyilege logo puwili Yisugu mizi piyengki mereke ngai koya. ");
INSERT INTO big_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yisugu yombu ingkeya meleyeng wara nak mereke wizilege pakela. ");
INSERT INTO big_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Logo Yisugu yombu Mosegi loyengki waligeleyiwili keya Palisi mei pulogo puwiliyegi pelik nguk yeiya, Ma lo tonuguyengko wok yawe mizi onobekke yombanu yombiyangai wazamira miziweki kai ma yeik, yeiya. ");
INSERT INTO big_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kapura puwili mabuwili ngagoluk koya. Pulaga Yisugu yombanubek miza logo yombiyangai kelemiya logo kang wezamela. ");
INSERT INTO big_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pilik miza logo Yisugu puwiliyegi pelik yeiya, Inugu kumularik talik? Tamizeige inuwa puwili nakki marekpek ma liyeng pulumakau nakkimek wok yawe mizi onobekke yenge kawik kai kolirikke kiliya puwekkerik nugu kumulagirik wokpok wok teni yawe mizi onobek mena miza logo mabilik wizi pani mizagi ma ni nguk namizi ulumiyagi ma talik, yeiya. ");
INSERT INTO big_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kapura puwiligurau ngago puragi kanga nara kisa yo mela ono. ");
INSERT INTO big_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yisu yongkambanu ingenaze nawili tung yeikyeng kilingwiligu mogosiyengke mogosiweki were kandikki pakelawekke pugu ngago saweliwei pera puwiliyegi pelik yeiya, ");
INSERT INTO big_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Kang naraga yombanu nakko ngeragi yongkambanu mele yanirage ngeragi miza niweki ini nakyegi ngago yei purik mabura ni tung yeikyeng kilingwiligu mogosi piyengke mogosiweki mizi nagani, purik yombanu yaka niyegi ngago neiyabokko yombu yeik yemane nara kiling nak tung purikke mogosagibek ngago meiya wizindagi langai legi. ");
INSERT INTO big_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Togo yombu yaka niyegi ngago neiyabokko kanda niyegi pelik neiyagi, Yek wizei, pek yeikta kilimbek mena pi tung yeikta kilimbokko mogosi purikke mogosi pani neiyagi. Pilik miziwekke purik ni kendek miza logo tung ngabelakka panurikke ni ngeragi nagi. ");
INSERT INTO big_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Togo pilik segeya ni yombu ingenaze nak puwekke purik mabura nak were tung yeikyeng kiling puwiligi purik weibene kelemi logo ni tung ngabelakka panurikke mogosi mangine. Togo yombu yaka niyegi ngago neiyabok pakeliraige ni pilik mizi mabura ngezebokko niyegi pelik kai penanging, Negi kewengkebek pelege tung yeikyeng kilingwiligu mogosi perikke mogosiweki mena koli, neiyagi. Pilik miza purago yongkambanu ingenaze puwiligu yeik nugura yemane sawiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yisugu ngago saweliwei pura yeiya logo puwiliyegi pelik yeiya, Yombanu ngezebokko ngezebekki yeikta yongolok meibok Anotogo yeik pugura kulengke wiyagi, kapura yombanu yeik ngezebekkira kulengke wiyibok Anotogo yeik pugura yongolok meiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pulaga Yisugu yombu yaka ngeragi yemane miza ni puragi mangobekyegi pelik meiya, Ni ngeragi yemane nara mizi purik mabura nigi kewengkewili ma nigi ingembuwili ma nigi yeligagangmekkawili ma yongkambanu watabiyengko kolokngagonowili ma yemanewiliyegi ngago yei nagani, purik kalike puwiligu ngeragi yemane miza ni puraga ni lewaweki ngago neiyagi legi, logo kazing pilikmekke ni watabi nugu miza piyengki wiyeke kangayeng nanagirik weik puwekke weiyagi. ");
INSERT INTO big_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pilik segeya ni yongkambanu watabiyengki yeikwili keya korik kang korowali puwili keya ingeyeng korowaliwili keya wire kusawiliyegi ngago yeimo. ");
INSERT INTO big_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Logo puwiligu ni kangayeng nanagi langai ono kapura Anotogo kele kalike wok nakke pugu yongkambanu wilek kang pangka pangkayeng kilingwili ibendaga yangalekta wazayi puwekke pugu nugu watabi miza piyengki wiyeke kanga nanagirik nanagi logo ni wilik mizagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yombu pulogo mogosara nageyawiliyaga nakko ngago puragi kerewiya logo Yisuyegi pelik meiya, Okuwi, teni yongkambanu Anotogi yeligagangmekki pugu ngai yolu purage mogosa logo ngeragi puguyeng nagi puwili wilikwilik yemane mizagi, kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yisugu piyegi ngago saweliwei perago kanga meiya to mela, Wok nakke yombanu nakko ngeragi miza ni nara miza logo yongkambanu kolokngagono niweki ngago yeiya. ");
INSERT INTO big_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Logo watabi mabiyeng ngayek miza logo pugu yombu piyegi yawe mizibek yongkambanu ulogo ngago yeiyawiliyegi lewaweki ngago yei wezamela logo watabi mabiyeng weik ngayek miza logo pangka pangka mena koli yeimo, meiya. ");
INSERT INTO big_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yawe mizibek pilik miza kapura puwili mabuwili nak nak kangki ono kisa, yeiya. Togo werebokko yawe mizibekyegi pelik meiya, Ne weik ngabelak wik narik weiya logo ne pakeli kangweki mizi logo ne kangki ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Keya ngereke nakko pelik meiya, Ne yaka liyeng pulumakau yawe mizagi meleyau weiya logo ne puwili yamizi kangweki mizi logo ne kangki langai ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Keya ngereke nakko pelik meiya, Ne mabek ngolukku yongok weiya logo piliktikki wiyeke ne pangka pangka namizi legi kangki langai ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Togo yombu yawe mizibek kandorik ngai pugubekyegi piyeng mabiyeng kozak meiya logo imakki mangobek sisik miza logo pigi marek yawe mizibekyegi pelik meiya, Nguk namizi pongo yereng perage kazing yemane keya songono piyengke kanda yongkambanu watabiyengki yeik puwili keya korik kang korowali puwili keya wire kusa puwili keya ingeyeng korowali puwili ngago yeiya logo iza orowei i nogomakke yabekkimo, meiya. ");
INSERT INTO big_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Yawe mizibek pilik miza logo waleleige pugu ngaibekyegi pelik meiya, Peba, ne nugu yaka kai pura pilik miza kapura tung nayeng ngoluk yolu, meiya. ");
INSERT INTO big_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Pilik kai legi ngaibokko marek yawe mizibekyegi pelik meiya, Ni yerengke welagela pongo kazing yemaneyeng keya kazing songono yawege yongomo mizi piyengke kanda yongkambanu puwili iza orowei ige pelege yabekkibene kozang yeiya logo iza orowei koli logo i nogomak wilak sibene. ");
INSERT INTO big_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nogo wameik kai, Yongkambanu ulogo nogo ngago yeiya puwiliyaga nakkorau ngeragi pewiligi miza peyengka kolok ulagi ono, meiya. Yisugu puwiliyegi ngago pera waligeleya logo weik yeik. ");
INSERT INTO big_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yisu kang wizigeya yongkambanu kolokngagono menalege wawere ula logo piyegi kiriwei kang. Togo pi weik puwiliyegi kowita yo mela logo pelik yeiya, ");
INSERT INTO big_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Tamizeige nak neyegi keli logo neyegi kiriwei mizagi kai mabura panu keya mango keya yongokpu iyakong keya si keya sakwili keya ngezebekki korikwekka keli pura neyegi keli puraga songonoweki. Kapura tamizeige pi pilik mizi ono purik mabura pok yombanu neyegi kiriweiwiliyaga nak mizagi ono. ");
INSERT INTO big_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Keya yombanu neyegi kiriwei mizagi kelibok negi wiyeke ne makngezego Anotogo kelirarikki wiyeke yengeleileige nganganda wagela logo ibeng sa pilik nganganda wageli mabura wilik kagowinda kiling wageliweki. Kapura tamizeige pi pilik mizi ono purik mabura pok yombanu neyegi kiriweiwiliyaga nak mizagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Keya yongkambanuwili purikku kai pura iwaka sibene Yisugu puwiliyegi ngago saweliwei nara pelik yeiya, Tamizeige inuwa puwiliyaga nak kapa i namak ngizagi purik ni were mogosa logo king imak ngizagiyeng talik talikki mizagi, ma king nigi imak kemenak ngizagiyeng pangka ma pangka ono ma talik, mizagi. ");
INSERT INTO big_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tamizeige ni pilik miza ono wizigeya yenge ngabelakke simembek keremiza logo pulaga kingyeng yeik mabura ngalege i ngizimaktau ngizagi ono. Togo yombanuwili imakko pilik miza purikki pakela logo purik niyegi songomei keya pelik kisagi, ");
INSERT INTO big_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Yombu pebok i pemak ngiziweki mizabek kapura pi imakki walerik wiyabek, kisagi. Kazing pilikmekke tamizeige ni neyegi kiriwei mizagi keli purik were yawe neyegi kemenak kiriwei mizagira talikta miza purikki waberek kumula logo mizimo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Keya Yisugu puwiliyegi ngago saweliwei nararau pelik kozak yeiya, Tamizeige yombu ngai yemizi nak yombu pigi ngai keliwili sangkelarik tausen meleyau tikindawili logo piyegi ngai mizi yemizi nak yombu pigi ngai keliwili sangkelarik tausen yombunak tikindawili miza logo ngai keliweki kangkine purik tausen meleyau puwiligi ngaibek were mogosa logo keriyagi tamizeige ngai lewamekki kozanda puwiliyaga lewegegi ma kawiye walagi ma talik wiriyagi miza purikki. ");
INSERT INTO big_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tamizeige pi teni pangka ono purikki waberek keriya purik mabura ngai mizimek ngoluk panga koweige yawereiga piyegi ibek oroweiwili wezayela logo ngaira talik yeik sawiyagi miziweki. ");
INSERT INTO big_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kazing pilikmekke ini were kumula logo neyegi kiriwei miziweki mizi. Tegi tamizeige iniyaga nak watabi puguyeng mabiyeng keya korik kang puguyeng keya pigi ingembuwilirau wezayela logo neyegi kiriwei ono mabura pok yombanu neyegi kiriweiwiliyaga nak mizagi ono. ");
INSERT INTO big_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Wizandik wazono panurikku logo ngeragiyeng kolok kelibene wiyirik kapura tamizeige pigi kolok keli pura yeik puwekkerik kazing ngereke kolok kelibene keremizagi namektau ono, yawe pugura weik yeik. ");
INSERT INTO big_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Logo wizang piliktik weik kailerikku logo wezamelagirikku. Kazing pilikmekke ini neyegi kiriweiwekke kiyebuk sende logo wiyi purik yawe inugu neyegi mizagira weik yeik. Tamizeige ini kerangangyeng kilingwili mabura kerewiyizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yombu king takis weiya logo piyengka ngoweiwili keya yombu kaile miziwilirau Yisuyegi kerewiyiweki lewa mizi. ");
INSERT INTO big_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Togo yombu Palisi nawili keya yombu Mosegi loyengki waligeleyi nawiligurau piliktikki pakela logo pelik ngalik kisa meli, Yombanu pobok yombanu kaile miziwili kiling mogosa logo ngagozakka mizibek. Keya pi puwili kiling ngeragi ni mizibek purik pangka ono, kisa. ");
INSERT INTO big_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tegi Yisugu puwiliyegi ngago saweliwei peyeng pelik yeiya to mela, ");
INSERT INTO big_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Tamizeige yombu nak liyeng memeng kolokngagono 100 nawili kiling logo puwiliyaga namek suwei miza purik pi talik mizagi? Pi liyeng memeng mabuwili siliksilik ngela nagiya wezaya logo pi memeng yaka suwei pumokyegi weli kanda weik yolok ngela puwekke weikki. ");
INSERT INTO big_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pi pumok yolok ngela logo pi wilikwilik unatuba panu mizagi logo yeke lagokwekke ulalengke wagela ");
INSERT INTO big_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","logo yerengke miza orowei yogi. Togo pigi ingembungangwili keya yerengkewili menalege ngago yeiya logo puwiliyegi pelik yeiyagi, Ne liyeng memeng negi suwei mizamek ngereke yolok ngela legi ne kiling pelege wilikwilik miziweki, yeiyagi. ");
INSERT INTO big_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pulaga Yisugu mawinda pelik yeiya, Kerewiyi, yombanubokko wilik kagowing miza mabilik Anotogi angela paka ngalegewilirau yombanu wamenak kaile puguyengki kuneng miza logo kaile puguyengka kowitabokyegi wilik kagowing unatuba panu miza kapura yombanu kolokngagono 99 pangka puwili kaile nayendau ono miza logo kaile puwiligi piyengka kowitagi langai ono puwiliyegi wilik kagowing mizagirik yeik panu. ");
INSERT INTO big_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ma tamizeige yongok namele king meleyau wizigeya piyengka nalik suwei puwekke purik pi talik mizagi? Pi lambek langiya logo i ngezemelegimakki kelewenda kilisi keya watabi mabiyengki waberek panu weli kai kanda weik yolok ngela purik weikki. ");
INSERT INTO big_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pugu yolok ngela puwekke purik pi pigi ingembungangwili keya yerengkewiliyegi menalege ngago yeiyagi. Pugu puwiliyegi pelik yeiyagi, King negi suwei mizalik weik yolok ngela mena ne kiling wilikwilik miziweki mena koli, yeiyagi. ");
INSERT INTO big_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Togo Yisugu puwiliyegi pelik yeiya, Nogo inuwayegi pelik yeiweki, Kazing mabilik panumekke Anotogi angelawiligu yombu kaile miza nak pugu mizayengka kowita puwekke purik puwiligu wilikwilik unatuba panu kelemiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Pulaga Yisugu ngago saweliwei perarau pelik kozak yeiya, Yombanu nak mandik neyau. ");
INSERT INTO big_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Logo wok nakke mandikyauyaga sakpokko mangoyegi pelik meiya, Peba, watabi tegi nugu menalege wiyi kambela piyengka sanga miza logo ne nanagiyeng weik nane, meiya. Tegi mangogo weik watabi mabiyeng koyangyauyegi sanga mizagelega yana. ");
INSERT INTO big_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wok ngelek miza ono wiziya logo sakpek watabi puguyeng kangkere miza logo weik yerenda wizami kambela. Pi ngabelak koweige nakke kanda pulogo kaile kaile mizageya wizimowei king puguyeng yeik ulak wezameli mizageya wiziya. ");
INSERT INTO big_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pulogo watabi pugu warayeng mabiyeng yana meli yongomo mizi keya king puguyeng mabiyeng wezameli kaiyageya wiziya. Togo waleleige ngabelakpok mabokko ngaba ibeng yemanera lewa logo pi ngaba ibeng yemane panu miza. ");
INSERT INTO big_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tegi pi yombanu ngabelak mabokka nakyegi yawe miziweki nguk meiya logo yombanubokko pi liyeng puguwiliyegi ngaiweki wezamela. ");
INSERT INTO big_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Logo pi liyengwiliyegi ngai keya ngeragi liyengwili nagiyeng yana logo pi ngeragi nayendau na ono kopong pi ngeragi liyengwiligu nagiyengka niweki kumula purik yombanu nakkorau pi watabi nayeng niweki mani ono legi. ");
INSERT INTO big_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Togo pilik mizi ngizige wire puguyau ngela wizigeya kangka nak piyegi lewagela wizigeya ngezebokko pelik kaiya, Negi mangobekyegi yombanu yawe miziwili ngeragi kolokngagono panu ni logo wilak wizigeya ngeragi wale wiya piyeng yolu kapura ne pelege yagasi mizageya. ");
INSERT INTO big_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tegi ne yangalek meiya logo negi mangobekyegi kangweki logo piyegi pelik meiyagine, Peba, ne ni keya Anoto paka ngalegebekyegirau kaile kaile nayeng miza. ");
INSERT INTO big_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ne weik yombanu yombiyangai onobek logo ngereke nugu ne nigi marekpek kaiyagi ono, nugu neyegi keleniyagirik yombanu niyegi yawe miziwili nak mizimo, meiyagi, miza. ");
INSERT INTO big_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Togo pi weik pulumeng wiya logo pigi mangobekyegi yo kayima. Pi ngoluk i pugumakka koweige yawereiga pigi mangobokko piyegi pakela logo wilek pugubek yalek keli legi pi nginda kanda koyambek yogotora wawiya logo ingkeya ngabik kelemiya. ");
INSERT INTO big_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Logo koyambokko mangoyegi pelik meiya, Peba, ne yali Anotogi wirege kaile miza kani. Ne yombanu yombiyangai onobek logo ngereke nugu ne nigi marekpek kaiyagi ono kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kapura mangogo piyegi yawe miziwiliyegi pelik yeiya, Ngezangai, melewangka wik wazono nogorik weiya logo pelege wakiya wazami. Keya negi marekpek ngereke yorikki wiyeke mena meleling wakiya wazami keya ingegangyau pongo ingeyauge wakiya wazami. ");
INSERT INTO big_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pilik miza logo pangalege liyeng pulumakau wazono panumek ulizo logo teni ngeragi yemane miza ni keya wilikwilik miziweki, ");
INSERT INTO big_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","purik mandik negi marekpek ibeng nobiyeng miza kapura wik kayima legi keya pi suwei nobiyeng miza kapura pi weik pek legi teni wilikwilik miziweki mena, yeiya. Togo puwili weik ngeragi yemane ni keya weik yongolo uli, yeiya. ");
INSERT INTO big_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pilik mizageya koyilege mandik sibek panga yawega kanda panga imakka mereke pura puwili ingimei keya yongolo ulageyarikki kerewiya. ");
INSERT INTO big_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pugu yombanu mangoyegi yawe miziwiliyaga nakyegi ngago meiya logo pelik nguk meiya, Puwili nangaiyeng mizi, meiya. ");
INSERT INTO big_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Legi mangoyegi yawe mizibokko pelik meiya to mela, Nigi sakpek ngereke yo kayima wizigeya nigi mangobokko liyeng pulumakau wazono panumek ula, purik nigi sakpek yombiyangai yo kayima kopong, teni wilikwilik mizi. ");
INSERT INTO big_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kapura mandik sibek sisik miza logo pi yeke ige yabela ono. Tegi mango welagelarik sibek yeke ige liweki nguk meiyageya wiziya. ");
INSERT INTO big_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mango nguk meiyageya wiziya kapura sibokko mangoyegi pelik meiya to mela, Kerewiye, kirisimasi ulogo mizi yabekeya peyeng yawe yeik ulak yawe miziwiligu mizilik ne niyege yawe mizi yabekeya kani, keya ngago nugu miziweki kaiyayeng nara ngela mela ono kani. Kapura nugu neyegi keleniyayeng nangaiyeng? Nugu liyeng yemane namek ma songono namektau ne nana logo negi ingembuwili kiling teni ngeragi yemane miza nigeya miza ono kani. ");
INSERT INTO big_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kapura mandik nigi marek pobok watabi nugu nigi piyengka mana piyeng mabiyeng yongok kazingkewiliyegi yana melabek kani. Togo pi yorik nugu liyeng pulumakau wazono panumek piyegi wiyeke ula logo ini miza ni. ");
INSERT INTO big_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Legi mangogo piyegi pelik meiya to mela, Mandikpek, ni wok mabiyeng yerengke towa yoluyau logo watabi negi piyeng nuguyeng. ");
INSERT INTO big_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kapura nigi sakpek ibeng nobiyeng mizabek kapura pi ngereke wik yo kayima. Pi suwei miza nobiyeng miza kapura pi weik yolubektikki wiyeke teni ngeragi yemane miza ni keya wilek kang tonuguyeng wilikwilik mizageya purik pangkarikku. Teni pilik mizi ono kesak pangka onogi, meiya. Yisugu ngago piyeng pilik yeiya logo yombu Palisiwili keya Mosegi loyengki waligeleyiwili piyengki kerewiya. ");
INSERT INTO big_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pulaga Yisugu ngezebokko waligeleyiwiliyegi ngago saweliwei perarau pelik yeiya, Yombu watabiyengko kolokngagono nak wiziya logo weik ulogo pi pigi watabi piyengki yombanu nak ngaiweki keremiza. Togo yombanu nawiligu kanda watabiyengki mangobekyegi pelik kozak meiya, Yombanu watabi nuguyengki ngaibok watabi nuguyengki waberek ngai ono, pugu watabi nuguyeng nayeng nalege wezameli mizi, meiya. ");
INSERT INTO big_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tegi pi yombu watabiyengki ngaibok ngago meiya logo piyegi pelik ngalik meiya, Ngago nogo niyegi langai kerewiyi pera talikta? Kapiya narikke watabi nugu negi nangaiyeng miza piyeng mabiyeng lende miza logo nanimo. Pulaga pilik miza logo purik weik kunimo purik ni watabi nogoyengki pangka ngai wiziyagi onobek mena, meiya. ");
INSERT INTO big_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pilik meiya legi yombu ngaibokko pi ngezebekyegi pelik kaiya, Negi yemizibokko ne weik yawe nogorikka wezaneliweki mizi. Legi ne talik mizagine? Ne kozang wizigeya ngabelak yokoragi ono keya watabiyengki nguk yeiyagirikki ne kendek. ");
INSERT INTO big_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Watabi nogo mizagiyeng ne weik iwaka. Nogo yongkambanu negi yemizibekyegi koka king keya watabiyeng namani yeik weiya puwiliyegi sawela logo puwiligu pi kanga managi peyengki waleyeng keke mela mowiyibene kozak yeiyagi, logo ne yawe nogoraga wezanela logo purik puwiligu neyegi sawela logo teni kiling yoluweki koli neirik kele, ne mabuwekke puwiliyegi sawelagi kaiya. ");
INSERT INTO big_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ngaibokko pilik kumula logo pugu yombanu yemizibekyegi ngoluk kanga manayeng mela mowiya onowiliyegi nak nak piyegi yeke ige liweki kozak yeiya, logo were yeke ige yabekeyabekyegi pelik meiya, Nugu talik talik yemizi nogobekyaga mongona, meiya. ");
INSERT INTO big_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Legi pugu pelik meiya to mela, Weli kolokngagono 100 taramgi pangka weiya, meiya, logo ngaibokko pelik meiya, Mena, kapiya watabi nugu yeik weiyayengki nging penging mena, ya. Mogosa logo nguk namizi 50 taram miza wazamiye, meiya. ");
INSERT INTO big_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Keya pugu yombanu nakyegirau pelik meiya, Keya ni, talik talik mela mowiyagi, meiya. Legi pugu pelik meiya to mela, Pandi wit wireyeng kik andet wamenakki pangka weiya, meiya. Legi ngaibokko pelik meiya, Mena, kapiya watabi nugu yeik weiyayengki nging penging mena, ya. Mogosa logo kik andet wamenakki piyeng tumula logo kik 80 miza wazamiye, meiya. ");
INSERT INTO big_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Togo waleleige yombu watabiyengko kolokngagonobokko yombu ngai kailebokki yeikta yongolok meiya purik yawe yaka pugu miza pura kaile kele kapura pugu waberek panu mizarikki wiyeke. Yongkambanu ngabelakpekke kusabanurikke yolu puwili ngezewili kelik puwili kiling yawe mizagi purikki iwaka panuwili keya puwili watabi ngoluk wangki mizagi pilik piyengki mabuwekke kumuliwili keya watabi kaile kazing ikuyogorik mizi pumokko miziyeng ngezewiliyegi sawelagirikki wiyeke miziwili logo piliktikku puwili yongkambanu wilangkarikkewiliyegi lewege miza meli, yeiya. ");
INSERT INTO big_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yisugu ngago yeke langakta pelik kozak yeiya, Ngabelak pobokke yongkambanuwili kingyeng kazing ikuyogorik miziyengki wei keya wezameli kapura nogo iniyegi lo nara pelik kozak yeiweki, Ini ngabelak pobokko watabi keya king inuguyeng yongkambanu watabiyengki yeikwiliyegi saweliweki yani mizizo logo puwili inigi kewengkewili mizagi kani logo ini ibeng logo pelege watabi inuguyeng wizamiya logo paka ngalege i wizagomagimakki kang puwekke Anotogo iniyegi koli keleyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Togo pugu mawinda kozak yeiya, Yombanu watabi songono panuyengkirau pangka ngai mizi wilibekpok watabi yemane panu piyengkirau pangka ngaigi langaibek. Yombanu watabi songono panu piyengkirau ikuyogorik mizibok watabi yemane panu piyengkirau ikuyogorik mizagi. ");
INSERT INTO big_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tegi tamizeige ini watabi king keya pulangai ngabelakpekki piyengki pangka ngai mizi wilibek ono purik mabura Anotogorau ini watabi wizagomagi pilik piyengki ngaiweki yanagi ono. ");
INSERT INTO big_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Watabi king keya pulangai inigi piyeng Anotogo yanayeng logo tamizeige ini piyeng weiya logo kazing pangkamekke ngai mizi wilibek ono purik mabura watabi kumbekki wizagomagi pugu ini yaniweki keli piyeng pugu ini yanagi ono. ");
INSERT INTO big_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yombanu yawe mizi nakko kemenak yombu ngai neyauyegi yawe mizagi langai ono. Kazing mabilikmekke ini Anotoyegi keli keya watabi king keya pulangai ngabelakpekkeyengkirau kemenak kelagi langai ono, purik ini nakyegi keli keya nakyegi kumbak mizagi legi. Keya ini nakki keliragi kiriwei keya nakki keliragi kezanga mani mizagi legi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yombu Palisi puwili Yisugi ngago piyengki kerewiya logo piyegi yang meiya, purik puwili kingyengki ngora panu kopong. ");
INSERT INTO big_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tegi Yisugu puwiliyegi pelik yeiya, Ini Palisiwili yombu yawe wazono yombanu watabiyeng yeikwiliyegi king yanagiyeng miziwili logo yongkambanu yeikwiligu kumularik ini yombu pangkawili mizi kapura Anotogo wilek kang kaile inuguyengki pakela wizinda kani. Watabi yombanuwiligu kumularik unatuba nobiyeng miza piyeng Anotogi wireyaugu pakelarik sok panu. ");
INSERT INTO big_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Koka Anotogi lo Mosego lende miza piyeng keya ngago Anotoyaga weiya logo kozak kisawiligu lende mizayeng iniyegi kozang mizi kanda weik Yowan kaimelabokko weik ngago yana. Teng puraga mabek teng perage perik tonugu ngago wazonoragi Anotogo pigi ngaimekki ngai yolu puragi purikki kozak yeiya logo nak nak panga Anotogi ngaimekki kiliya kuniweki kozang yawe mizi, kapura ini Yowan kaimelabokko kazing kiliya kuniweki kozak kaiya pumokki ini kiyebuk miza. ");
INSERT INTO big_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ngago wazonora weik lewa purikku Mosegi loyengki kozanda yeik mizi ono, a’a’. Kalike purik ngilumbek keya ngabelakpek talege mizagi kapura Mosegi loyengka watabi songono nayendau talege mizagi langai ono. ");
INSERT INTO big_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Keya lo nara yongkambu wei puragira. Tamizeige yombu nak yongok pugumele wezamela logo ngereke namele wei purik pi yombanu yongok ngezebekkimele weiya wizimowei ngereke namele kiling iwek kolibok kelik mizi yagenda. Ma yombu yongok nakko wezamelamele wei purik pirau mabilik yombanu yongok ngezebekkimele weiya wizimowei ngereke namele kiling iwek kolibok kelik mizi yagenda, yeiya. ");
INSERT INTO big_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Keya Yisugu mawinda pelik kozak yeiya, Koka yombu watabiyengko kolokngagono nak wizagoma logo pi watabi king yemane panuyengki ngane weiyayeng wakiyi mizi keya wok mabiyeng ngeragi wazonoyeng ni mizi. ");
INSERT INTO big_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Keya pulogo yombu watabiyengki yeik naktau wiziya logo yeik pugura Lasara meiyabek. Korik puguwek wizingyengko kolabek logo nawiligu pi miza orowei kanda yombu watabiyengko kolokngagonobokki imakki kandikke wezami mizi ");
INSERT INTO big_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","logo pi yombu watabiyengko kolokngagonobokki ngeragi muneng lalek puguraga yenge kulengke kawiye wali piyeng weiya niweki keya keriwiligu wizing puguyeng longok puwiliyengko pikira ni mizi. ");
INSERT INTO big_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Togo waleleige yombu watabiyengki yeikpok ibeng logo Anotogi angelawiligu pi wagela logo yereng wazonorage Abalamyegi saweliwei wezamiya. Logo wiziya waleleige yombu watabiyengko kolaboktau ibeng logo puwiligu waliya wazamiya. ");
INSERT INTO big_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yombu watabiyengko kolabek yereng kaile ibeng puwiligi kungwili yoluraga yolu wizigeya ngangang yemane panu mizageya logo paka ngalege pakeliraige Abalam koweige panu Lasara kiling wizilege. ");
INSERT INTO big_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pilik pakela logo pugu pelik kek meiya, Peba Abalam, neyegi yalek miza logo Lasara kai nakka mele kong pugubekki orozabek waliyi wezamele logo longok nogobekki wiyi pani logo kabeneng siweki sawelibene purik ne ngangang yemanera yezi pezikku nani mena, meiya. ");
INSERT INTO big_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kapura Abalamgu pelik meiya to mela, Negi marekpek, ni kumula, koka yali ngoluk wik yolu puwekke ni watabi wazonoyeng weiyageya wiziya keya Lasara korowaliyeng weiyageya wiziya. Kapura mabek pi pelege weik wilikwilik mizageya keya ni pulogo ngangang mizageya. ");
INSERT INTO big_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Keya yeke langak nararau, tenigi tepekke Anotogo kosau kulaka yemane panuling keremiza logo pelagawili pulogo kangki purik pangka kangki langai ono. Keya pulagawilirau pelege lewagi purik pangka lewagi langai ono kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Pilik meiya legi yombu watabiyengko kolabokko kozang nguk meiya, O Peba Abalam, pilik mabura, nugu Lasara negi mangobekki imakka negi sak melenazik yolu mena wezamele ");
INSERT INTO big_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","logo puwili yereng ngangang mizi perage lewa nelegi puwiligu kaile kaile mizi piyengka kowitiweki kozak yeibene wezamele, meiya. ");
INSERT INTO big_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kapura Abalamgu pelik meiya, Nogorau Lasara wezamelagi ono purik nigi si keya sakwili kapiya Mosego lende miza piyeng keya kapiya yombanu Anotoyaga ngagora weiya logo kozak kisa puwiligu lende miza piyengka sangkeli keya kerewiyi nangai, meiya. ");
INSERT INTO big_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yombu watabiyengko kolabokko pelik meiya to mela, Puwiligu kozak yei piyeng ngoluk pangka ono. Kapura tamizeige yombanu ibendaga yangalek meiya nakko negi sakwiliyegi kozak yei kang purik kele puwili kaile kaile puwiligu miziyengka kowitagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kapura Abalamgu pelik meiya, Tamizeige puwili Mose keya yombanu Anotoyaga ngagora weiya logo kozak kisawiliyegi kerewiyi ono purik puwili mabilik yombanu ibendaga yangalektabokko kairikki kerewiya logo kaile puwiligiyengka kowita logo ngizi kumulagi ono, meiya, Yisugu pilik yeiya. ");
INSERT INTO big_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Keya Yisugu ngezebokko waligeleyiwiliyegi pelik yeiya, Watabi nalangai nalangaiyengko yongkambanuwili kaile miziweki ulumi kapura yombanu puwili pilik mizibene keleyibokyegi Anotogo ngangang panu kelemiyagi, legi waberek ngaiweki kani. ");
INSERT INTO big_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Logo pilik poktau ono kesak pangka, purik yombanu neyegi ngizi panu kumuli kazing kumbekki lewengke songono nogowiliyaga nak kaile miziweki ulumiyabokyegi Anotogo ngangang yemane panu managi. ");
INSERT INTO big_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pilik legi ini yongkambanu negi puwili, ini kazing ini makngezego koyagi pumokko waberek panu koyizo. Tamizeige neyegi ngizi kumuliwiliyaga nakko niyegi kaile mizi mabura nugu piyegi pelik ngalik meimo, Nugu neyegi kaile miza kani. Keya tamizeige pugu niyegi pelik neiya yo meli, Ei, nogo kaile miza logo ne kuneng logo ne melegulang miziweki kai mabura nugu pugu kaile miza pura tumula logo keremareke wezamelimo. ");
INSERT INTO big_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Keya tamizeige pugu niyegi langai kaile mizayeng melenazik keya nazikka neyau wok wamenakke miza logo nara miza logo ngereke niyege kanda, pi kaileyengki kuneng kai purik mabura nugu tumula logo kang melenazik keya nazikka neyau mabilik keremareke wezamelimo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pugu yeiya logo yombu pugu waligeleyi Aposolo meiwiligu piyegi pelik meiya, Yemizibek, tonugu niyegi ngizi kumulirik songono nangezi legi nugu tonugu ni keya kozang nuguragi ngizi kumuli pura unatuba sibene keleyimo, meiya. ");
INSERT INTO big_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Keya Yemizibokko puwiliyegi pelik yeiya to mela, Yengelei Mastetlei mei puleigi kumuli. Yengelei Mastet puleigi wireyeng songono panu kapura ngeriyi puwekkerik nguk namizi lewa logo yengelei yemane keremizagi. Tegi inugu ne keya kozang nogoragi ngizi kumuli pura yengelei Mastet puleigi wireyengka nak kelik lewibene kelemi. Purik tamizeige inugu neyegi ngizi kumuli pura Mastet wilekpek kelik songono pilik kesak watabi nalangai piyeng mabiyeng inugu mizagi langai, keya inugurau yengelei kozang pelege lewi peleigi pelik meiyagi, Ni ni makngezego pulili nuguyeng puliya logo ngereke ni makngeze panga kai wizambekke ni makngeze ngeriye, mei purik, pi inugu kairagi kiriwei mizi penanging kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Keya Yisugu pigi yawe miziwiliyegi ngago yeke langak nara yeiya, Tamizeige inuwayaga nak yombu nigi yawe ngabelak kiriraga mizi nak ma nigi liyeng memengwiliyegi ngai nak kiling logo pi panga yawega ige yowekke purik nugu piyegi pelik meiyagi ono, Ngezangai koli, ngeragi nuguyeng ni mangiweki mena meiyagi ono. ");
INSERT INTO big_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pilik segeya nugu piyegi pelik meiyagi, Ngeragi nogoyeng ngaiyek miza logo nane logo ne kairi keya ngeragi ni keya ni yeik wizei logo waleleige ni ngeragi nuguyeng miza ni mangine, meiyagi. ");
INSERT INTO big_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Togo yawe mizibok nugu kairagi kiriwei mizarikki wiyeke nugu yeik pugura yongolok meiyagi ma talik? A’a’, watabi pugu mizi piyeng, yawe puguyeng. ");
INSERT INTO big_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kazing mabilikmekke iniyegirau pilik mizagi. Ini yaka watabi miziweki nogo kozak yeiya piyeng miza logo weik purik mabura pelik kisizo, Teni Yemizibekki yawe miziwili. Watabi tonugu mizi piyeng yawe tonuguyeng logo teni yombiyangai wizigeya yeik tonuguyeng yongolok meiyagi ono, kisizo, Yisugu pilik yeiya. ");
INSERT INTO big_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pilik mizarikka weik Yisu kazing Yirusalem yerengke kang leweng neing kambela logo pi ngabelak Sameriya keya Kalili meiyaugi tepek neing kambela. ");
INSERT INTO big_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pi yereng narage lewagela logo kemegeme korikwek sok mizimek logo Leposimek meimekka yombu meleyauwili pumokka miziwili yoromaure miza. Puwili ngoluk koweige wiriyimowei ");
INSERT INTO big_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","pelik ngalizi kek kisa, Yisu. Yemanebek. Teniyegi yalek mize, kisa. ");
INSERT INTO big_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yisugu puwiliyegi pakela logo puwiliyegi pelik yeiya, Kambeli. Yombu Anotoyegi wata kolak kelibene waliya maniwiligu korik inuguyengki pakela logo ini weik yombiyangaiwili mizibene logo pulaga ini ngereke yombanuwili kiling menalege wei mizi keya mizi nangine kambeli, yeiya. Puwili mabilik tagoneige korik puwiligiyeng weik yombiyangai sa. ");
INSERT INTO big_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yombu puwiliyaga nak tapakeleige korik puguwek yombiyangai mamiza legi pi ngereke Anotogi yeikta ngalizi panu yongolok mei yo kayima. ");
INSERT INTO big_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pi pongo Yisugi inge werege ulu wala logo morogulunda wizimowei wazono meiya. Yombanubok Sameriyagabek logo Yudawiligu kiyebuk mizibek. ");
INSERT INTO big_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yisugu yombanu meleyauyaga pi wamenak yorikki pakela logo pelik kaiya, Yombanu meleyauwili yakarik yombiyangai wezaya kapura yombanu melenazik keya nazikka mangobektau onowili puwili talege? ");
INSERT INTO big_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yombu yenge nalaga kayima pobok Anotogi yeikta yongolok meiweki yo kapura pi ngezebek keke yo pura nangki, kaiya. ");
INSERT INTO big_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Logo Yisugu Sameriyagabekyegi pelik meiya, Yangalek meiya logo kambele. Nugu neyegi ngizi panu kumulirikku ni yombiyangai keya kaile nuguyengka yaliya wazaniya mena, meiya. ");
INSERT INTO big_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yombanu Palisi nawiligu Yisuyegi wok Anotogo yongkambanu mabuwiliyegi ngaigibek talikwekke lewagi miza purikki nguk meiya. Tegi pugu puwiliyegi pelik yeiya to yela, Anotogo pigi ngaimekki ngai yolu pura lewawekkerik yongkambanuwiligi wireyengko pakelagi langai pilikmekke lewagi ono. ");
INSERT INTO big_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma nakkorau pelik kaiyagi langai ono, Pakeli, Anotogi ngaira pelege pera mena, ma ngai pugura pangalege panga pura kaiyagi langai ono, purik Anotogo nawiligi wilek kangyengki ngai logo Anotogi ngaira weik inigi tepekke wizinda, yeiya. ");
INSERT INTO big_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Togo pugu ngezebokko waligeleyiwiliyegi pelik yeiya, Wok nak lewagelagi logo wokpokko inuwago ne yombanu paka ngalega kayimabekyegi pakeliweki kelagi kapura inuwago neyegi pakelagi langai ono. ");
INSERT INTO big_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yongkambanu nawiligu iniyegi pelik kisagi, Pakeli, Yombanu paka ngalega kayimabek yaka lewa. Pi panga pulogo yolubek, mena, kisagi. Ma pakeli, pi pelege yolubek, mena kisagi, kapura puwiliyegi ngizi kumuli nagani. Panga pulogo pakeli kang nagani. ");
INSERT INTO big_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Inuwa lengka wililiktikku mizi puwekke purik paka ngilumbek mabok pangazuwaga pezuwaga ngela manirikki teni mabuwiligu pakeli mizi. Kazing mabilikmekke ne yombanu paka ngalega kayimabek ngereke yogi logo puwekke mabuwiligu neyegi pakelagi kani. ");
INSERT INTO big_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kapura pilik mizagine were yongkambanu mabek yolu pewiligu neyegi kezanga nanagi logo ngangang unatuba keleniyagi. ");
INSERT INTO big_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ne yombanu paka ngalega kayimabek ngereke yo puwekkerik yongkambanuwili ngereke koka walaka kazing yongkambanu Nowagi tendaga koya mabilik mizageya koyi nangai. ");
INSERT INTO big_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nowa wiziya puwekke yongkambanuwili Anotoyegi langai kumula ono keya Nowago ngago watabi lewagelagi piyengki langai kai piyengki kerewiya ono logo watabi ngezewiligiyengki mizageya koya. Logo puwili ngeragi ni keya kai ni keya yongkambu wei keya panu keya mangogo kolomele yombu weiyagi nakyegi miza mani kaiyageya koya weik wok Nowa yeke sikmakke kiliya lagibekke kai ngai yemaneyaugu yongkambanu nawili mabuwili yela. ");
INSERT INTO big_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Keya wizagoma kalike yongkambanuwili koka Loto meibek wiziya puwekkewiligu kazing miza pilikmekke, puwili ngeragi ni keya kai ni keya watabiyeng wei keya yani, keya puwili yaweyeng ngeriyi keya iyeng ngizi. Kapura puwilirau Anotoyegi langai kumula ono. ");
INSERT INTO big_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Logo wok Loto yereng Sorong pura wiya logo kunabekke yezizik keya king salapa ngoriyeng paka ngilumbekka koboyau kelik kuli logo Sorong yerengke mabulogo koya puwili mabuwili yela logo ibeng. ");
INSERT INTO big_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wok ne yombanu paka ngalega kayimabek ngereke lewagelagirik kazing mabilik panumekke lewagi. ");
INSERT INTO big_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Wok Yisu yogibokko, yongkambanu imakka welagela puwili ngereke yeke ige yongorik watabi puwiligi piyeng wei nagani, ma yongkambanu panga yawege mizageya koya puwili watabi puwiligiyeng weiweki kowiti nagani. ");
INSERT INTO big_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotogi yongokpumologo miza puragi kumula panu. Pi Loto kiling yereng Sorong meira wiya logo kuna kapura pi watabi pugu wizamiyayengki kumula logo pakeliweki kowita ngizige kemenak ibeng. ");
INSERT INTO big_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kazing mabilikmekke yombanu ngezebekki kelira keya ngezebekki wik yolugira kozang kebangkeli mizibok Anotogi wiregerik ibeng logo wik wizagomagira weiyagi ono, kapura yombanu neyegi ngizi panu kumula logo pulaga wilek kang pugubek keya wik yolugi pugura neyegi tiya mani mizibok ibeng wizagomagi ono, pi paka ngalege wik yombiyangai wizagomagi. ");
INSERT INTO big_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kerewiyi, wokpokko kusage yombu neyau i wamenamakka menalege iwekki kani, logo nak miza oroweigi kapura nak mabulogo wezamiyagi kani. ");
INSERT INTO big_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yongok neyau yeke ige menalege yawe mizageya koyagi, logo namele miza oroweigi kapura namele mabulogo yawe mizageya wezamiyagi kani. ");
INSERT INTO big_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yombu neyau panga yawege menalege yawe mizageya koyagi, logo nak miza orowei kangki kapura nak mabulogo yawe mizageya wezamiyagi kani, Yisugu pilik yeiya. ");
INSERT INTO big_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tegi Yisugu waligeleyiwiligu piyegi pelik nguk meiya, Yemizibek peyeng talege mizagi meiya logo Yisugu ngago saweliwei nara pelik yeiya to mela, Wale watabi ibeng piyengki korik sokyeng wizilege winak Yezigokwili kanda pura menalege niweki wawere ulageya pulogo, yeiya. Togo purikku kai purik pelik, yereng yongkambanu kazing kumbekki Anotoyegi leweng ibengwili koyagi pulogo Anotogo ngangang yaniweki lewagi. ");
INSERT INTO big_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Puwili wok mabiyeng waberek mizibene keya kiyebuk sende miza logo waberek mizimok wizamiya nelegi Yisugu ngezebokko waligeleyiwiliyegi ngago saweliwei pera pelik kozak yeiya, ");
INSERT INTO big_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kang naraga panga yereng yemane narage yombu ngagozakyengki kerewiyi nak wizagoma. Pi Anotoyegi kazi namizibek keya yombanuwiliyegirau yalek mizi onobek. ");
INSERT INTO big_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Keya yereng maburage yongok komate namelerau mabulogo wizagoma logo pi yombu ngagozakyengki kerewiyibekyegi kayimi wilibek logo piyegi pelik nguk mei mizi, Nogo neyegi korowali mizabek ngagozak kelemiweki mizi legi nugu neyegi sawela logo negi ngagozak puragi kerewiya logo pangka pangka miziweki, mei mizimele. ");
INSERT INTO big_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yongok komatemele solo kayimawekkerik yombu ngagozakyengki kerewiyibokko piyegi, pilik mizagi ono meiya. Kapura kalike pi ngezebek pelik kumula, Ne Anotoyegi kazi ono keya yongkambanuwiliyegi yalek keli ono kele ");
INSERT INTO big_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kapura yongok komate pemelego ne yawe unatuba nani mizi legi nogo ngagozak puguragi kerewiya logo pangka pangka mizagi. Tamizeige ne piyegi saweli ono purik pi ngoluk mazeng keya lewa lewa mizagi logo purik ne kiyebuk mizagi langai, pilik kumula, yeiya. ");
INSERT INTO big_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pulaga Yemizibokko puwiliyegi pelik yeiya, Inuwa yombu korowali ngagozakyengki kerewiyabokko kaiya puragi kerewiyizo. ");
INSERT INTO big_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Purik tamizeige yombu korowali ngagozakyengki kerewiyabokko yongok komatemeleyegi korowali miza piyeng pangka pangka miza purik mabura Anoto pangka ngagozakyengki kerewiyibokko yongkambanu pi ngezebokko nogowili kaiya puwiligu yoklongko keya kusage wok piyeng mabiyeng piyegi pobilik ingkisi pelik, Ngagozak tonuguragi kerewiye logo watabi korowali nazuwagawiligu teniyegi miza piyeng pangka pangka mize, kisi pilik. Logo pugu puwiliyegi sawelagirikki yelakkelek mizagi ma talik? ");
INSERT INTO big_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nogo inuwayegi watabi pugu mizagi piyengki kozak yeiweki, Anotogo yongkambanu puguwiliyegi nguk namizi sawela logo puwiliyegi nazuwagawiligu korowali miza piyeng kebangkela logo pugu yombanu piyegi kumuli onowiligu yombanu piyegi kumuliwiliyegi kaile miza piyengki wiyeke piyegi kumuli ono puwili nganganda nguk namizi yanagi. Kapura ne yombanu paka ngalega kayimabek ngereke ngabelakpekke yowekkerik nogo yongkambanu neyegi ngizi panu kumulageya nawili pakelagi ma yeikki? Ne yalek purik nogo kumularik kolokngagono ngizi kumuli pura wiya wizilege ne pakelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wok nakke Yisugu yongkambanu ngezewiligu ngezewiliyegi teni pangkawili keya teni kaile miziwiliyegi kiyebuk mizi puwiliyegi ngago saweliwei pera pelik kozak yeiya, ");
INSERT INTO big_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Wok nakke yombu neyau paka Anotogi i walek yemanemakke waberek miziweki kambela. Piyauyaga nak ngai Palisi meimekkabek keya nak king takis weiya piyengka ngoweibek. ");
INSERT INTO big_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Palisibek luweza logo pi ngezebekki kangkabekke pelik ngagoluk waberek miza, O Anoto, ne yombu nawili kelik ono legi ne niyegi wazono nei. Yombu nawili watabiyengki kerezi kopong puwili king menalege yawe naragi wawiya piyeng ngowei keya puwili yongkambanuwiliyegi korowaliyeng miziwili, keya puwili yongok puwiligi onowili kiling iwek koli miziwili, kapura ne pilikpek ono keya nerau yombu king takis weiya piyengka ngoweibok kelik pek ono. ");
INSERT INTO big_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Purik sonda naraga wok neyau ne kazing ngago nuguragi wiyeke niyegi waberek miziweki ngeragi ni ono mizi pumok mizibek, keya watabi nogo wei piyeng mabiyeng sanga miza logo limak meleyau keremizi logo limak meleyau piyengka narik weiya logo ni nani mizibek, yombu Palisibek meibek pilik waberek miza. ");
INSERT INTO big_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kapura yombu kaile king takis weiya piyengka ngoweibek panga koweiga luweza wizimowei waberek miza. Logo kaile pugu miza piyengki wiyeke pi kendek miza logo wiregawere pugura paka ngilumbekke pakela ono. Keya pi kaile puguyengki kuneng kelirikki wiyeke ngeleleng ngezebekkira ula logo pelik waberek miza, O Anoto, ne kaile panu mizibek mena neyegi yalek mize. Pi pilik waberek miza. ");
INSERT INTO big_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yisugu ngago pura yeiya logo pelik yeiya, Nogo iniyegi wameik kozak yei, Yombu kalikebok Anoto kiling pangka miza wizigeya i ngezebekkimakki kandobela. Kapura yombu werebok, Anoto kiling pangka miza ono purik pi yeik ngezebekkira yongolok meiya kopong. Purik yombanu pi ngezebokko ngezebek yongolok meibok Anotogo pi kulengkebek kelemiyagi keya yombanu pi ngezebokko ngezebek kulengkebek kelemibok Anotogo pi yongolok meiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wok nakke yongkambanu nawili koloyakamandik songono puwiligiwili Yisuyegi iza orowei kayima logo mele puguzik koloyakamandikwiligi kebiyengke walamiya logo Anotogo puwiliyegi wazono keleyibene, kapura Yisugu waligeleyiwiligu purikki pakela logo ngalik yeiya. ");
INSERT INTO big_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kapura Yisugu koloyakamandik songonowiliyegi pelik yeiya, Neyegi koli. Pilik yeiya logo pugu ngezebokko waligeleyiwiliyegi pelik yeiya, Koloyakamandikwili neyegi wiriyi pani. Puwili neyegi lewa nelegi waliyi nagani, purik koloyakamandik pilikwilirau Anotogo puwiliyegi ngaiweki ngai pugumekki kiliya wiriyagi purik pangka. ");
INSERT INTO big_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kerewiyi. Tamizeige nak Anotogo piyegi ngai wizeibene kazing koloyakamandik songonowili mizi mabilikmekke kelemi ono purik mabura pok Anotogo pigi ngaimekki ngai yolu puragi kiliya wiriyagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yudawiligi yemane nakko Yisuyegi pelik nguk meiya, Kiriwaga wazonobek, yawe talikta miza logo ne wik wizagomagira weiyagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Legi Yisugu piyegi pelik meiya to mela, Nugu neyegi wazonobek kaira nangki? Nugu neyegi keriyirik ne Anoto, purik Anoto wamenak wazonobek, naktau wazono ono. ");
INSERT INTO big_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kapura ni Mosegi lo piyengki iwaka. Lo piyeng pelik, Yongkambu weiya puwili nigi kerekpu onobek ma nigi yongokpu onomele kiling iwek koli nagani. Yombanu uli nagani. Yombanu nakki watabiyeng purik ngowei nagani. Yombanu nakyegi langai ngaigu kai nagani. Nigi panu keya mangoyauyegi panga yungke mizimo, meiya. ");
INSERT INTO big_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tegi yombu yemanebokko Yisuyegi pelik meiya to mela, Lo nugu neyegi yaka kozak nei piyeng mabiyeng ne mandik songonowekkerikka kiriwei mizi kayimi, meiya. ");
INSERT INTO big_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pilik meiya legi Yisugu piyegi pelik meiya, Purik wazono kapura ni ngoluk watabi nayendau miziweki. Watabi nigi piyengko nigi kazing wik wizagomagira weiyagimek waliya legi watabi nigi piyeng mabiyeng yombanuwiligu weibene yani kune logo king piyengki ngane weiya piyeng yongkambanu watabiyengki yeik puwili yanimo. Pilik miza logo purik nugu lewege panu kelira paka ngalege wik wizagomagira purikki iwakagi. Mabiyeng pilik yana logo neyegi saweliwei kiriwei koli. ");
INSERT INTO big_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yisugu piyegi pilik meiya kapura yombanubek pilik kai puragi kerewiyawekke wilek kang pugubek kuneng, purik pi watabi puguyeng kolokngagono panu logo yanagirikki kiyebuk kopong. ");
INSERT INTO big_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yisugu piyegi pakela logo pelik kaiya, Yongkambanu watabiyengko kola puwili Anotogo puwiliyegi ngaiweki Anotoyegi panga yungke kunagirik yawe unatuba panu kani. ");
INSERT INTO big_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kerewiyi, liyeng Kamelmek meimok nili kagorik lolo ulibekki yungurikke kiliya kang purik yawe unatuba kapura yombanu watabi kolokngagono puguyengki kozang kumulibokko Anotogo piyegi ngaiweki kelemiyagirik yawe unatuba panu, yeiya. ");
INSERT INTO big_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yongkambanu ngago puragi kerewiyawiligu Yisuyegi pelik nguk meiya, Tamizeige pilik purik mabura yongkambanu wik wizagomagiragi wiyeke yaliya wazayagi langai puwili tawili, meiya. ");
INSERT INTO big_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tegi Yisugu puwiliyegi pelik yeiya to mela, Watabi yongkambanuwiligu mizagi langai ono piyeng, Anotogo pangka mizagi langai, yeiya. ");
INSERT INTO big_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita pilik kerewiya logo Yisuyegi pelik meiya, Kerewiye, teni yereng tonuguyeng wizamiya logo niyegi saweliwei kiriwei mizi wiziga teni wik wizagomagira weiyagi ma yeik, meiya. ");
INSERT INTO big_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Togo Yisugu puwiliyegi pelik yeiya to mela, Ei, wameik, keya nogo inuwayegi pera kozak yeiweki, Yombanu nak Anotogo piyegi ngai purikki wiyeke i pugumak wiyi keya yereng pugura wiyi, ma pigi yongokpumele wezami, ma pigi si keya sakwili wezayi, ma pigi panu keya mangoyau wezayi, ma koloyakamandik puguwili wezayi kang pilikpok ");
INSERT INTO big_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mabek ngoluk wik wizigeya Anotogo kanga managi piyeng watabi pugu wiya piyengka ngoluk lewegeyeng keya teng kalike lewagi purage wik wizagomagira managi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pulaga Yisugu yombu ngezebokko waligeleyi meleyau keya pongo ingenazikka neyauwili lewe narikke iza oroweirik puwiliyegi pelik yeiya, Kerewiyi, teni paka Yirusalem yerengke kangweki logo pulogo yombu koka Anotoyaga ngagora weiya logo kozak kisawiligu ne yombanu paka ngalega kayimabekyegi langai lende miza piyeng weik ngizi mizagilege. ");
INSERT INTO big_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Watabi lende miza piyeng pelik, Pulogo Yudawiligu yombanu paka ngalega kayimabek miza oroweirik Yuda onowiliyegi miza yanagi. Puwiligu piyegi ngago wageliwei meiyagi keya piyegi korowali kelemiyagi keya pi sibilak ngiza mani mizagi. ");
INSERT INTO big_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Keya puwiligu pi wizale ulagi logo ibengki, kapura wok neyau wiziya logo wok kalikebekke pi ngereke wik yangalektagi. ");
INSERT INTO big_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yisugu pilik yeiya kapura pugu waligeleyiwili ngago piyeng naragirau iwaka ono. Purik ngagoyengki soloyeng puwiliyegi liwik logo Yisugu ngago kozak kai piyeng puwiligu iwaka ono. ");
INSERT INTO big_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Togo Yisu kiling pugu waligeleyiwili weik ngereke paka Yirusalem kangweki kambela. Puwili yereng Yeriko mei puragi mereke tawereige pura yombu wireyau kusa nak kazing lewengke kerelege mogosa wizimowei yongkambanu ngabelak libu kangwiliyegi ngeragi keya kingyengki nguk yeiyageya wizilege. ");
INSERT INTO big_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yombu wireyau kusabek yongkambanu mabuwili kunimowei kisageli mei kandikki pi kerewiyawekke pugu nguk yeiya, Pera nangaira mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Legi puwiligu piyegi pelik kozak meiya, Yisu yereng Nasaretegabok kiling yongkambanu paka Yirusalem kangkiwiligu meiya meli yagenda, meiya. ");
INSERT INTO big_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tegi wireyau kusabokko pelik ngalizi kek kaiya, Yisu, ni negi yelibu koka King Ngai Tawiti meiyabokki marekngangwiliyagabek logo Anotogo teni Yudawiliyegi wiyeke wezanelabok purik nogo iwaka, legi neyegi yalek mize, kaiya. ");
INSERT INTO big_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pilik kai legi yongkambanu yeke orozarikke piyegi merekewiligu wireyau kusabekyegi pelik meiya, Ni ngagoluk wizei, meiya. Kapura pi mazeng keya pelik kek kaiyageya, Ni King Ngai Tawitigi marekngangwiliyagabek legi neyegi yalek mize, kaiyageya. ");
INSERT INTO big_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pilik kai legi Yisu leng miza logo nawiligu yombu wireyau kusabok miza orowei yarobene yeiya. Pi mereke kandawekke Yisugu piyegi pelik nguk meiya, ");
INSERT INTO big_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Nangaiyeng nogo niyegi miziweki ni keli, meiya logo wireyau kusabokko pelik meiya to mela, Negi Yemizibek, ne ngereke wireyaugu pakelagi keli, meiya. ");
INSERT INTO big_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Pilik kai legi Yisugu piyegi pelik meiya, Wire nuguyau ngaiwila logo pakele. Nugu neyegi ngizi panu kumulirikku ni yombiyangai keleniya kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pilik meiya logo nguk namizi pi weik wireyau ngaiwila. Pi weik pakelagi langai wizigeya pi Yisuyegi kiriwei kunimowei Anotoyegi wilikwilik ngago mei kang kuna. Keya yongkambanu wawere ulawiligu yombanu wireyau ngaiwilabekyegi pakelawekke puwili mabuwilirau Anotogi yeikta yongolok meiya. ");
INSERT INTO big_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yisu Yeriko yerendage kiliya kuna logo yerenda weik wizamiweki mizi. ");
INSERT INTO big_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pulogo yombu king takis weiwiliyegi ngai yemane nak yeikta Sakiyasi meibek yolu. Pi watabiyengko kolabek. ");
INSERT INTO big_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pi Yisu meibok talik nalikpek miza legi pakeliweki miza kapura yongkambanuwiligu pi waliyarikku pi Yisuyegi pakelagi langai ono, purik pi yombu ngerewalekpek kopong. ");
INSERT INTO big_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sakiyasi iwaka Yisu kazing pumok neing wiriyagi purikki, legi pi were ngindarik yengelei Fik mei naleige ngalege taberek meiya logo Yisuyegi pakeliweki. ");
INSERT INTO big_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yisu kanda yengelei puleigi sologa paka ngalege pakela logo Sakiyasiyegi pelik meiya, Sakiyasi, ngezangai ngabelakke kule. Mabek wokpek ne ni kiling i nugumakke yolugi mena, meiya. ");
INSERT INTO big_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Legi Sakiyasi ngezangai ngabelakke yerageya logo wilikwilik miza wizimowei Yisuyegi koli meiya logo i pugumakke miza orowei kuna. ");
INSERT INTO big_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Togo yongkambanuwiligu puragi pakela logo weik munumunu mei kang keya mizi. Logo puwili pelik kisa, Pi panga yombu kaile mizi mizibek kiling yoluweki mizi purik kaile, kisa. ");
INSERT INTO big_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yisu keya Sakiyasi yeke ige kanda ngagozakka mogosa. Pilik miza logo Sakiyasi puwili mabuwiligi wirege luweza logo Yisuyegi pelik meiya, Yemizibek, nogo kaile miza purik ne iwaka. Kapura ne kuneng logo kaile nogo mizayengka kowitiweki mizi legi piliktikki wiyeke ne watabi nogoyeng mabiyeng sanga miza logo lewe narik yongkambanu watabiyengki yeik puwili yanagi. Keya tamizeige ne yombu nakyegi ngaigu meiya logo watabi puguyeng ngoweiya purik, nogo kang mangorarau ono pi kanga managi, meiya. ");
INSERT INTO big_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pilik meiya legi Yisugu piyegi pelik meiya, Mabek wokpekke weik Anotogo ni keya i nugumakki yoluwili kaileyengka yaliya wazaya, purik nugu neyegi ngizi kumularikku ni weik ngizi Abalamgi marekngangwiliyaga nak. ");
INSERT INTO big_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Purik ne yombanu paka ngalega kayimabek yongkambanu Anotoyaga koweige yolu puwiliyegi wela logo mereke iza orowei yo keya ibeng koyimagi puraga yaliya wazayiweki kayimabek, meiya. ");
INSERT INTO big_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yongkambanuwili Yisugu ngago yaka pura kaiyarikki kerewiya logo pugu ngago saweliwei pera kozak yeiya purik puwili weik Yirusalem lemengki mereke logo pulogo yongkambanuwiligurik Yisu kapmanwili keleyayela logo Anotogo yongkambanu puguwiliyegi ngaigi pura weik pugu lewagela wazamiweki mizi nobiyeng miza kapura pi pilik mizagi ono, keya puwiligi ngai keremizagi ono kapura pi kangki logo puwili yawe pugura mizageya wazayagi purikki wiyeke ngago saweliwei pera kozak yeiya. ");
INSERT INTO big_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kang narage yombanu yemane panu nakki marekpek ngabelak koweige nakke yeik ngaibek mei pura weiweki kangweki mizi logo waleleige ngereke yogine. ");
INSERT INTO big_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pi kangkine were yombu meleyau piyegi yawe miziwiliyegi ngago yeiya logo puwili mabuwili nak nak king ngele neyau keleya logo yanageya wizimowei pelik yeiya, Kerewiyi, Ne kang keya inuwa nak nak king ngele nogo yani piyauge yawe kingyeng ulumiyagi nara mizizo. Logo pulaga ne yo puwekke nogo inuwa king talik talik king ngele piyauga yeke langak keremiza miza purikki ne pakelagi kani, yeiya logo pi weik kambela. ");
INSERT INTO big_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kapura yombu pokko ngaigi puwili piyegi kiyebuk miza logo puwiligu yombu ngago pelikta oroweiwili kalika wezayela, Teni yombu pokko teniyegi ngaigirikki kiyebuk kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kapura pi yeik ngaibek mei pura mabilik keya weiya logo ngai yemane wazamiya logo kalike yo kayima. Pi kanda nguk namizi yombu piyegi yawe mizi pugu koka kingyeng yana puwiliyegi ngago yeiya logo pigi wirege kanda puwili nakko king yeke langak keremizayeng talik talik miziweki. ");
INSERT INTO big_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Logo werebokko kanda pelik meiya, Yemizibek, ne king ngele nugu koka nana piyaugu ngereke king 200 Kina piyeng ulumiya mena, ya, meiya. ");
INSERT INTO big_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Pilik meiya logo ngaibokko pelik meiya, Wazono panu, ni yombu yawe nugura pangka mizabek. Keya ni songonoyengki ngai waberek panu miza legi nogo ni weik yereng unatuba meleyauyengki ngai yemane wazaniyagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pulaga yombu piyegi yawe mizi nak kalike kanda pelik meiya, Yemizibek, ne king ngele nugu koka nana piyaugu ngereke king 100 Kina piyeng ulumiya mena, ya, meiya. ");
INSERT INTO big_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Pilik meiya logo ngaibokko pokyegi pelik meiya, Nogo ni weik yereng unatuba melenazikyengki ngai yemane wazani, meiya. ");
INSERT INTO big_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Keya pulaga yombu piyegi yawe mizi nalik nak kanda pelik meiya, Yemizibek, nogo king ngele nugu koka nana piyau kagorik walerikku sukumeng miza logo waberek wiya wizagoma mena, ya. ");
INSERT INTO big_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ni yombanu yalek mizi onobek legi ne niyegi kulili miza. Purik ni yawe mabiyeng pangka panu miziweki kai wilibekpek legi ne kulili miza, meiya. ");
INSERT INTO big_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Legi ngaibokko piyegi pelik kozang meiya, Ni yawe namizibek. Ngago ngaigu kili ni makngezegiraga punda wali piyengko mizagewiyege nogo ni ngagozak keleniyagi kani. Keya nugu kairik ne yombanu yalek mizi onobek keya yombanu yawe mabiyeng pangka panu miziweki kai wilibekpek kai. ");
INSERT INTO big_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Logo ni piliktikki iwaka mabura ni nangki king nogoyeng panga pendikke nowiyi ono, kesak waleleige ne yowekke king piyeng kiling kokowa nayendau wei kak? ");
INSERT INTO big_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ngaibokko piyegi pilik meiya logo yongkambanu pulogo luweza koyilegewiliyegi pelik yeiya, Yombanu neyegi yawe mizi pobok korowali mizarikki wiyeke mena inugu king ngele nogo mana piyau piyaga weiya logo yombu yawe miza logo king 200 Kina piyeng ulumiyabokyegi mani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yongkambanu luwezawiligu ngaibekyegi pelik meiya, Kapura yemizibek, pi koka king ngele neyau weiyabek, kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ngaibokko pelik yeiya to mela, Ei wameik. Keya nogo iniyegi pelik kozak yeiweki, Yongkambanu ngago nogo kairagi kerewiyi logo watabi nogo yana piyeng kebangkela yolu puwili mabuwiliyegi nogo mawinda watabi nayendau yanagi kapura yongkambanu ngago nogo kairagi nagerewiyi logo watabi songono nogo yana piyeng kebangkela yolu puwiliyaga nogo songono puwiligu kebangkela piyeng yongonagi kani. ");
INSERT INTO big_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Keya yombanu neyegi kumbak mizi logo nogo puwiliyegi ngaigirikki kiyebuk miza puwili pelege iza orowei koli logo negi wirege yela logo ibeng sibene. Logo ne ngago saweliwei pura kozak yei purik ne weik kangkiweki mereke kapura ne kambela wizigeya ini kang tamekke mizageya koyi nangai? ");
INSERT INTO big_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisu ngago pura yeiya logo waleleige pi paka Yirusalem yerengke kangweki puwiligi orozarikke kambela. ");
INSERT INTO big_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Puwili kayimeige lewak Olip meibekke mereke. Lewak pokko yengelei olipyeng lewarikki wiyeke yeik pura meiya logo yereng neyau lewakpekke ngezege wizilege. Yereng nara Petepasi meira keya yereng nara Petani meira. Puwili yereng piyaugi mereke kandawekke Yisugu yombu ngezebokko waligeleyi neyau were ngago pelikta kiling wezayela, ");
INSERT INTO big_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Yereng mereke paka purage kunizo. Yali pulogo kiliya tagoneige purik liyeng tongki kong namek nakko wakleige wibokko tariya logo wizi penanging kani, ngoluk nakkorau mogosa onomek logo wei yongomo miza onomek. Pumokko wi tariya piyeng wila mowiya logo pelege miza orowei koli. ");
INSERT INTO big_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Keya tamizeige nakko yaliyegi pelik kai, Nangki yali pumokki wibek wili, kai purik mabura piyegi pelik kozak meizo, Yemizibek pemekyegi yawe nara legi te miza orowei kang, meizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Piyau kazing leweng neing wezayela logo kambela. Kanda Yisugu yaka piyauyegi kozak yeiya mabilik liyeng tongki kongmek wizilege yolok ngela. ");
INSERT INTO big_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Logo piyau liyeng tongki kongmekki wi tariyabek wilageya tagogei pura liyeng tongki kongmekki mangowiligu kanda piyauyegi pelik yeiya, Nangki yali liyeng tongki kong pemekki wi tariyabek wili, yeiya. ");
INSERT INTO big_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Legi piyaugu pelik yeiya to mela, Yemizibek pemekyegi yawe nara mizagi. ");
INSERT INTO big_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Piyaugu pilik yeiya logo liyeng tongki kongmek Yisuyegi miza orowei yo kayima. Pilik miza logo Yisu ngezebokko waligeleyiwiligu kagorik yeke ngalege waliya piyengka panga liyeng tongki kongmekke ngalege wiya logo Yisu tongki kongmekke ngalege mogosa wazamiya logo wiriya. ");
INSERT INTO big_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yisu liyeng tongki kongmekke ngalengale yagoneigeya yombanu wawere ulawiligu pi King Ngai Yemizi puwiligi ngaibek sawiyarikki wiyeke kagorik puwiligi yeke ngalege waliya piyeng kazingmekke laga wiya. ");
INSERT INTO big_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yisu Yirusalem yerengke mereke lewagelawekke pulogo kazing lewak Olip meibekka kando kang leweng yolulege yongkambanu kolokngagono pugu waligeleya logo piyegi kiriwei mizi lewawili mabuwili wilikwiliktago kola koyimowei weik Anotogi yeikta yongolok meiya purik Yisugu watabi Anotogo keke mizagi langai pugu miza piyengki puwili ulogo pakela kopong. Togo puwiligu pelik ngalizi kek kisa. ");
INSERT INTO big_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Pok Anotogo tenigi King Ngai wizeibene wezamelabek, Anotogo pi kozanda maniweki. Kazing ngezege saragi pumok paka ngalege wizeiweki. Anoto paka ngalege panu yolubekki yeikta yongolok meiweki. Puwili pilik kisi wiriya. ");
INSERT INTO big_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Keya wawere ulawili kiling Palisi piyegi yeik kiriwei wiriya nawiligu Yisuyegi pelik meiya, Kiriwagabek, nugu waligeleya logo niyegi kiriwei mizi lewa pewili ngagoluk koyibene yei, meiya. ");
INSERT INTO big_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Logo Yisugu puwiliyegi pelik yeiya to meiya, Nogo iniyegi wameik panu kozak yei, tamizeige puwili ngagoluk purik, kingyeng ngezeyeng yeik nogora yongolok meibene ngalizi kek kisi nangai kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yisu Yirusalem yerendage mereke wiriyimowei pakelawekke Yirusalem yerengki yongkambanuwiliyegi kumula logo ingkeiya. ");
INSERT INTO big_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Logo pelik kaiya, Nogo kelirik pelik, mabek wokpekke inigi wilek kangyeng kazing ngezege sara yolugi pumokki iwakaweki kapura pumok yokopekke iniyegi liwik logo inugu pakelagi langai ono. ");
INSERT INTO big_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yereng inuguraga, lemeng kozang panu kingyengka keremizamek yolu logo yerenda mabura yawereng kelemiya kele kapura ini kiling ngai kelagiwiligu ngabelak waragela lomong yemaneyeng keremizi kayimeige lemeng inigi pumokki lolongmekke pangka pangkagi logo ini kemenak yawereng keleyagi logo puwili tameneng mei kanda paka lolongmekka pongo inigi ngalege perek keya walagi. ");
INSERT INTO big_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Logo puwiligu ini keya yongokwili keya koloyakamandikwilirau ini mabuwili kemenak korowali keleyageyara ini yeikki. Keya i inuguyeng ula waliyagi, keya Anotogi i walek yemane kimbokko ngizamaktau puwiligu kemenak sugusugu kelemiyagi. Inugurau king nakki ngalege nak nak wiyi yabelayeng pakelagi ono. Purik Anotogo ne iniyegi saweliweki wezanela kapura inugu pakela ono logo inugu neyegi kezanga nana legi yombanu ini kiling ngai kelagiwili lewagi logo iniyegi pilik keleyagi, kaiya. ");
INSERT INTO big_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yisu pilik kaiya logo paka Yirusalem yerengke Anotogi i walek yemane kimbokko ngizamakki kambela. Pi i pumakki yerembekke kanda yongkambanuwili kingyengki ngane liyeng kau keya liyeng memeng keya winakwili wei keya yani mizageya koyilege logo Yisu kazing kaile pumokki pakela logo kiyebuk, legi pugu puwili keleyayela logo puwili keleyayelageya wizimowei ");
INSERT INTO big_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","puwiliyegi pelik yeiya, Anotogi Kapiya Walektikke lende mizarik pelik, I Anotogimak i yongkambanuwiligu piyegi waberek mizagimak, kapura inugu pung wezarik keremizarikku i Anotogimakki yeikta kaile sawiya logo weik yombanu king ngoweiwiligu king ururu yolu piyeng kelik keremiza, kai, yeiya. ");
INSERT INTO big_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Keya pulaga wok mabiyeng Yisugu yongkambanuwili Anotogi i walek yemanemakke waligeleyageya wiziya. Yombu Anotoyegi kolak miziwiligi ngaiwili, keya Mosegi loyengki waligeleyiwili, keya Yudawiligi yemane nawilirau pi uliweki miza ");
INSERT INTO big_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kapura puwili yongkambanuwiliyegi kulili kopong puwiligu kazing pilik mizagimek mizagi langai ono, purik yongkambanu mabuwili ngago lang narik kokowa nelegi piyegi kerewiya panu yolu. ");
INSERT INTO big_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wok nakke Yisugu yongkambanuwili Anotogi i walek yemanemakke waligeleyi keya ngago wazono kazing Anotogo puwili yaliya wazayagimekki langai pura kozak yeiyageya tawizeige pura Yudawiligi yemanewili kiling yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwili Yisuyegi wiriya ");
INSERT INTO big_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","logo puwiligu piyegi pelik nguk meiya, Nugu teniyegi kozak yei, Ni yeik talikta kilimbokko yawe pera mizi? Keya takko ni yawe pera miziweki pangkara nana? ");
INSERT INTO big_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Pilik kisi legi Yisugu puwiliyegi pelik yeiya to mela, Mena, nerau inuwayegi ngago naragi nguk yei pei, ");
INSERT INTO big_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yowan kaimelabek kayima logo yongkambanuwili kaimela puwekke yawe kaimela pura Anotogi yawera ma yombu ngabelakpekkewiliyaga nakki yawera miza purikki inugu neyegi kozak nei, yeiya. ");
INSERT INTO big_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Togo puwili ngezewili pulogo pelik kozak keli yongomo miza, Teni talik meiyagi? Tamizeige tonugu pelik mei, Anotogira, mei purik mabura pugu pelik nguk yeiyagi, Inuwa watabi Yowangu kai piyengki ngizi kumula onora nangki? ");
INSERT INTO big_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kapura tamizeige tonugu yombu ngabelakpekkewiliyaga nakkira, mei purik mabura yongkambanu wawere ula pewiligu teni kingyengko yelagi, purik puwili Yowan Anotoyaga ngagora weiya logo kozak kaiyageya wiziyabektikki ngizi kumuliwili kopong, meiya. ");
INSERT INTO big_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tegi puwili yongkambanuwiliyegi kazi miza kopong puwiligu Yisuyegi pelik meiya to mela, Yawe Yowangira talaga kayimara miza purik teni lusuwei, meiya ");
INSERT INTO big_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","logo Yisugu puwiliyegi pelik yeiya to mela, Pilik mabura, nogorau inuwayegi takko ne yawe pera miziweki pangkara nana miza purikki kozak yeiyagi ono, yeiya. ");
INSERT INTO big_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yisugu ngago pura yeiya logo weik yongkambanu pulogo wawere ula puwiliyegi ngago saweliwei pera pelik kozak yeiya, Yombanu nak waing yawe nalei ngeriya logo pugu nawili yaweleige ngai koyibene wazaya logo puwiliyegi pelik yeiya, Yawe nogoleigi yawe mizageya koyimowei waberek ngai koyizo. Keya waing wilekyeng weik kuk puwekke purik mabura piyeng tiyizo logo waing keremizizo. Pilik yeiya logo yawe puleigi mangobek koweige nalege kambela logo pulogo kirisimasi kolokngagono wizagoma. ");
INSERT INTO big_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Teng waing wilekyeng weik kuk wizigeya wilekyeng tiyagiwekkeraga pugu yombu ngagora orowei nak yaweleigi ngai wazayawiliyegi wezamela logo yaweleige waing wilek piyengka waing keremiza nayeng weiweki, kapura yaweleigi ngai wazayawiligu ngagora oroweibek kebangkela logo wizale ula logo yeik wezayongomela. ");
INSERT INTO big_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tegi yaweleigi mangobokko ngereke ngagora orowei nak mazenda wezamela, kapura yaweleigi ngai wazayawiligu pi wizale uli keya ngago kaile meiya logo mabilik yeik wezayongomela. ");
INSERT INTO big_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pulaga pugu mazenda ngagora orowei naktau wezamela, kapura yaweleigi ngai wazayawiligu poktau ngangang unatuba mana logo yenge yerendaga wilingke wezamela. ");
INSERT INTO big_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Puwiligu pilik miza legi waing yaweleigi mangobokko pelik kaiya, Ne talik mizagi? Ne negi marek wamenak nogo keli panubek wezamelagi. Puwiligu piyegi purik kele ngago puguragi kerewiyagi langai, kaiya. ");
INSERT INTO big_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pilik miza logo pi pilik wezamela kapura yaweleigi ngai wazayawiligu pigi marekpekyegi pakelawekke puwili nakko nakyegi pelik meiya yongomo miza, Pobok yaweleigi mangobekki marekpek kani. Pi kalike pigi mangobek ibeng puwekke pi yawe pelei weiyagibek. Tegi teni pi ula logo mango ibeng purik waing yawelei teni makngezegiweki mena, kela. ");
INSERT INTO big_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Togo puwiligu pi kebangkela logo panga waing yaweleige yomizora wezamela logo pi ula logo ibeng. Togo yaweleigi ngai wazayawiligu pilik miza purikki yaweleigi mangobokko puwiliyegi talik mizagi? ");
INSERT INTO big_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yaweleigi mangobokko kanda yaweleigi ngai pugu wazaya puwili neneng ngela logo waing yawe pugulei ngereke ngai nawiliyegi yanagi, yeiya. Yombanu Yudawiligi ngaiwiligu peragi kerewiya logo pelik kisa, Igali, pilikta miza nagani, kisa. ");
INSERT INTO big_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yisugu pilik kisirikki kerewiya logo puwiliyegi ngai yuke panu keleya logo pugu pelik yeiya, Ini pilikta lewagelagirikki kiyebuk. Mabura, Anotogi Kapiya Walektikku pelik kai, pura talik kai, King yombu imak ngiziwiligu kiyebuk miza logo wezamela pura ngereke king panu imak mamak kebangkela yolu pura kani, kai. ");
INSERT INTO big_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Keya king yaka panu puragirik, Yombanu king puragi ngalege wala puwili narik narik ngela melagi. Keya tamizeige king purago yombanu nakki ngalege kawiye wala purik, king purago pi neneng ngela logo kozobek kelik keremizagi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yisugu pilik yeiya logo yombu Mosegi loyengki waligeleyiwili keya yombu Anotoyegi kolak miziwiligi ngaiwili Yisugu ngago waing yaweleigi mangobekyegi langai kai puragi kerewiya puwekke Yisugu puwiliyegi langai kozak kairikki puwiligu pakela logo mabuwekke puwiligu Yisu kebangkeliweki miza kapura puwili watabi yongkambanuwiligu mizagi piyengki kazi. ");
INSERT INTO big_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pulaga puwili wok Yisu ngezebek kuyangka kebangkelagibekki yuke koya. Keya puwiligu yombanu ngaigu kerewiyagi keliwili miza koyimowei Yisuyegi liwik pakelageya koyagi nawili wezayela. Yombu liwik pakeliwiligu Yisu ngago kaile nayeng kai purik mabura kebangkela logo puwiligu pi panga Rom Kapman Yudaya ngabelakpekki ngai yemanebekyegi miza managi miza. ");
INSERT INTO big_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yombu Yisuyegi liwik pakeliweki wiriya puwili kanda Yisuyegi pelik meiya, Kiriwagabek, nugu kaiyeng keya waligeleyiyeng wameik ngizi panuyeng purik tonuwa iwaka. Keya ni yewizek mizi onobek, ni yongkambanuwili mabuwiliyegi kazing Anotogi ngizi panumekki waligeleyibek purik tonuwa iwaka. ");
INSERT INTO big_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kapura nugu tonuwa nayendau iwakaweki mena tonuwayegi poburikki kozak yei, Lo tonugurago talik kai, teni king takisyeng Romwiligi King Ngaibek Sisa meibekyegi managi kai ma managi ono kai, pilik nguk meiya. ");
INSERT INTO big_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kapura Yisu puwiligu ikuyogorik mizi puragi pakela logo puwiliyegi pelik yeiya, King keke nalik neyegi orowei koli logo pakeliweki yeiya. ");
INSERT INTO big_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Puwiligu piyegi nalik orowei kanda logo Yisugu pelik nguk yeiya, Wiregawere king pelikke pera takkara keya yeik takkara wizine pakeli, yeiya. Legi puwiligu pelik meiya to mela, Romwiligi King Ngaibek Sisagiyau, meiya, ");
INSERT INTO big_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","legi Yisugu pelik yeiya, Mena, watabi King Ngaibekkiyeng purik King Ngaibekyegi manizo, keya watabi Anotogiyeng purik Anotoyegi manizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Togo pulogo yongkambanuwiligi wirege yombu Yisuyegi liwik pakeliwiligu piyaga ngago lang songono nariktau weiyagi langai ono. Tegi puwili ngagoluk koya keya ngago pugu kaiya yo meliyengki lebuk mizara koya. ");
INSERT INTO big_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Togo pulaga yombanu Sadusiwili meiwiliyaga nawili Yisuyegi ikuyogorik kelemi wiriya. Sadusiwili yombanu pelik kisiwili, Yombanu nak ibeng purik kung pugubektau ibeng logo pi ngereke yangalektagi ono, kisiwili. ");
INSERT INTO big_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Puwiligu Yisuyegi pelik nguk meiya, Kiriwagabek, Mosego lo tenigi lende miza nara pelik, Tamizeige yombanu nak yongok weiya logo mandik wazami ono wiziya yombubok ibeng purik yombubokki sakpek ngereke yongok komatemolo weiyagi logo piyaugu yombu yaka ibembokki yango keya marekngang nawili wazayiweki. ");
INSERT INTO big_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yombu ingini melenazik keya nazikka neyauwili koya. Logo kalogolibek were yongok weiya logo mandik wazamiya ono wiziya pi ibeng. ");
INSERT INTO big_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pulaga waleleige kalogolibekki kelengkebokko ngereke yongok komatemele weiya kapura piyaurau mandik wazamiya ono koya pi ibeng. ");
INSERT INTO big_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Keya pulaga pokki kelengkebokko komatemele ngereke weiya. Logo yombu melenazik keya nazikka neyau puwili mabuwili pilik miza kapura mandik wazaya ono koya ibeng. ");
INSERT INTO big_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Logo kalik panuge yongo komatemelerau ibeng. ");
INSERT INTO big_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mena, teni niyegi ngago peragi nguk neiweki, Tamizeige wok kalik panubekke yongkambanu ulogo ibeng puwili nugu kai pilik yangalekta wik yolugi mabura yongok komatemolo yombu melenazik keya nazikka neyau puwili mabuwili weiyamele legi tamizeige kalike ibengwili ngereke yangalekta puwekkerik yongok yaka pumolo takki yongokpumele mizagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yisugu puwiliyegi pelik yeiya to mela, Yongkambanuwili ngabelakka yolu pewekkerik yongkambu weiya yolu ");
INSERT INTO big_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kapura yongkambanu ibeng logo kalike Anotogo ibendaga yangalekta wazaya logo pugu wik wizagomagi kaiya pilik puwili puwekkeriktau weiyawili mizagi ono, ma panu keya mangogo kolomele yombu weiyagi nakyegi miza managi ono. ");
INSERT INTO big_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Purik puwili Anotogi angelawili kelikki kopong ngereke mawinda ibengki ono. Keya Anotogo puwili ibendaga yangalekta wazaya logo wik wizagomagira yani kopong puwili Anotogi yango keya marekngang ngiziwili mizagi. ");
INSERT INTO big_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Keya Mosegorau teniyegi yombu ibengwili ngereke yangalek meiyagiragi kozak yeiya, Koka walaka wok nakke Mosego ibek solorik ngoririkki pakela kapura ibek solorik kemenak ngora ono. Logo Mosego Anotogo ibek solo ngori purikki yungka piyegi meiyaragi lende mizarik pelik, Ne Anoto Abalamgibek keya ne Anoto Isakkibek keya ne Anoto Yakopgibek, meiyara lende miza. Anotogo pilik kaiyawekkerik, Abalam keya pigi marekpek Isak keya Isakki marekpek Yakop ulogo ibengwiliyegi pi pilik kaiya kapura Anotogo puwili wik kai yagenda. Ulogo puwiligi korikyeng ibeng kele kapura wilek kang puwiligiyeng wik yolu. ");
INSERT INTO big_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Logo inuwayegirik puwili ibeng kapura Anotoyegirik puwili wik yolu, legi pi Anoto wik yoluwiligi ngaibek. ");
INSERT INTO big_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yisugu pilik yeiya logo Mosegi loyengki waligeleyi nawiligu piyegi pelik meiya, Kiriwagabek, nugu puwiliyegi ngago yeiya to mela pura wazonora, meiya. ");
INSERT INTO big_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kapura pulaga puwili piyegi mawinda ngago nara nguk meiyagirikki weik kazi. ");
INSERT INTO big_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pilik miza logo Yisugu puwiliyegi ngago nara pelik nguk yeiya, Yombanuwiligu Kilisibek Anotogi Mesiyabek koka King Ngai Tawitigi marekngangwiliyaga nak kisara nangki? Puwiligu ngago pilik kisirago Kilisibek yeik yombanubek kisi yagenda. ");
INSERT INTO big_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Kapura Tawiti ngezebokko Kapiya Walek Ingi Samyengkirikke Kilisibekyegi langai lende mizarik pelik kaiya, Anoto Yemizibokko Kilisibek Yemizi nogobekyegi pelik meiya, Nogo niyegi kiyebuk miziwili kulengke nugu ngaiweki wazayirikka negi ngaigezuwaga pelaga mogosi koli, kaiya. ");
INSERT INTO big_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tawitigu Kilisibekyegi Anoto Yemizibek meiya legi talik miza logo Kilisibek Tawitigi marekngangwiliyaga nak? Pilik mabura Kilisibek mabok yombanubek keya Anoto wizinda, yeiya. ");
INSERT INTO big_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yisugu puwiliyegi pilik yeiya logo yongkambanu wawere ulawili mabuwiligu kerewiya koyigeya pugu yombu ngezebokko waligeleyiwiliyegi pelik yeiya, ");
INSERT INTO big_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Inuwa yombu Mosegi loyengki waligeleyiwili kelik nagani, puwiliyegi kani waberek panu. Purik puwili kagorik wazonoyeng keya melewangka yokolongyeng wakiya logo wei miziweki keliwili, logo yongkambanuwiligu puwili yemanewili mizibene. Keya puwili pundikke yongkambanu mamokki wirege puwiliyegi pelik yeiweki miziwili, Wangane Ngaibek, miziwili. Keya puwili i walek songonoyengke paka orozarikke yongkambanuwiligi wirege yongkambanuwiligu pakelibene mogosiweki keliwili. Keya puwili ngeragi yemane miza ni piyengke tung yeikyeng kilingwiligu mogosi piyengke mogosiweki keliwili. ");
INSERT INTO big_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Puwili yongok komatewiligi iyengki kanda purik puwili yongok komatewili purikki iwaka koyimowei ngaigu king i walekmakkiyeng weiweki yeiya logo kalike ngereke ngezewiligi liwik wawiyiwili. Keya waleleige purik puwiligu kaile ngezewiligiyeng momane meibene Anotoyegi waberek miziyeng yokolong panu meiwili. Togo kalike Anotogo yongkambanuwili kaile puwiligiyengki wiyeke ngagozak keleyi puwekke puwili ngangang weiyagi, kapura yombanu loyengki waligeleyi puwiligu kaile panu mizi piyengki wiyeke ngangang yemane panu weiyagi. Logo Yisugu puwiliyegi ngago piyeng Anotogi i walek yemanemakke mogosa wizimowei kozak yeiya. ");
INSERT INTO big_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yisu pakeli wei miza logo yombu kingyengko kolawili Anotoyegi opa maniweki king nayeng yeke ige pelengwekke wiyirikki pakela. ");
INSERT INTO big_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Keya pugu mabilik yongok komate watabiyengki yeik panu namele kanda korok neyau wiyirikki pakela. ");
INSERT INTO big_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pulaga Yisugu pelik yeiya, Nogo inuwayegi wameik panu kozak yei, yongok komate watabiyengki yeik panu pemologo wiya piyengko yombanu mabuwiligu wiya piyengka ngalege panu kani, ");
INSERT INTO big_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","purik puwili mabuwili king kolokngagonoyengka Anotoyegi puwiligu songono mani keya ngoluk kolokngagono yolu, kapura pemele, pi watabiyengki yeikmele kele kapura pugu wara yoluyeng mabiyeng wiya logo pi ngeragiyeng weiyagi nayendau ono, yeiya. ");
INSERT INTO big_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yisu kiling nawili Anotogi i walek yemane yombiyangaimakki pelik kozak keli, I pemakki king peyeng palumuyengko keya watabi yongkambanuwiligu Anotoyegi manayengko mizagewiyege i pemak, pelik, kela. ");
INSERT INTO big_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Kapura Yisugu puwiliyegi pelik yeiya, Nogo iniyegi ngago i pemakki langai nara kozak yeiweki, wok nakka purik yombanu Yudawiliyegi ngai miziwiligu kanda i mabek inugu pelege pakeli pemak mamak yowela melagi keya kingyeng sugusugu miza melagi, king neyau pulogo menalege nakki ngalege nak wiziyagi ono, puwiligu yowela melagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Keya Yisu kiling puwiligu piyegi pelik nguk meiya, Kiriwagabek, talikwekke pilik mizagi? Keya kazing talikmokko pilik mizagi pura lewagelagirikki were teniyegi walimizagi, meiya. ");
INSERT INTO big_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tegi Yisugu puwiliyegi pelik yeiya to mela, Waberek panu. Inuwa yombu inuwayegi ngaigu kisi puwiliyegi kiriwei miza nagani. Purik yombanu kolokngagono yeik nogorage lewagi kani logo pelik kisi wiriyi nangai, Ne Kilisibek, kisi nangai keya, Wok Yisu lewagibek weik mereke, kisi nangai, kapura puwiliyegi kerewiya logo kiriwei mizi nagani. ");
INSERT INTO big_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Keya inuwa ngai keliyengki langai kerewiyi keya yombanuwili ngabelak koweige nayengke watabi nayengki wiyeke sisik miza logo ngalizi meiya meli kang keya miza melirikki kerewiya purik kulili mizi nagani. Watabi pilik piyeng mabiyeng were lewagelagiyeng kani kapura piyengko mizi purik ngabelakpek weik yeikkirikki mizi yagenda ono, yeiya. ");
INSERT INTO big_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Keya Yisugu mawinda pelik yeiya, Ngabelakpek weik yeikkine were peyeng pelik lewagelagi, yongkambanu ngabelak nakkewili kiling yongkambanu ngabelak nakkawili ngai kelagi. Keya kapman ngabelak nakkebek kiling kapman ngabelak nakkabek ngai kelagi, keya yongkambanu ngabelak nayengkewili kiling yongkambanu ngabelak nayengkawili ngai kelagi. ");
INSERT INTO big_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Keya puwekkerik ngabelak kolokngagonoyengke kuburuk unatuba panuyeng ulagi, keya ngabelak nayengke ngaba ibeng yemaneyeng mizagi, keya kemegeme nalangai unatuba panuyendau lewagelagi, keya paka ngilumbekka watabi yemane wirangai panu nayeng keya ini kulili keleyagiyendau lewagelagi. ");
INSERT INTO big_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Watabi pilik peyeng kalike mizagi kapura were inuwa neyegi kiriwei mizirikki wiyeke yombanuwiligu inuwa kebangkela logo ngangang keleyi ma kuneng yanagi, keya puwiligu inuwa panga i walek songonoyengke ngaiwiliyegi iza orowei kunagi logo ngagozak keleyagi logo wigira wezayagi, keya yeik nogoragi wiyeke puwiligu inuwa yombu ngabelakpekki King Ngaiwili keya kapman ngai yemanewiliyegi ngagozak keleyibene iza orowei kunagi. ");
INSERT INTO big_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Puwekke inuwa weik puwiliyegi neyegi langai kozak yei keya ngago nogo inuwayegi waligeleyaragi langai kozak yeiyagi. ");
INSERT INTO big_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tegi inuwago were ngago puwiliyegi yeiyagi nayeng pangka pangka mizagirikki wiyeke wilek ngelek kumula nelegi yeik karagare koyizo. ");
INSERT INTO big_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Purik, pilikta lewagela puwekke purik, mabura nogo kangka inuwagiyeng wazono iwakagira yanagi keya nogo kili inuwagiyengke ngago lang wazono mela to melagiyeng wiyagi mena, logo yombanu inuwa ngangang yanagiwiligu ngago nogo inuwa yana pura keta wezameli keya momanenda wiyagi langai ono. ");
INSERT INTO big_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Keya puwekke iniyaga nawiligi panu keya mangowiligurau ini yombanu ini ngangang yanagiwiliyegi iza yanagi, keya iniyaga nawiligi si keya sakwiligu iniyegi mabilik keleyagi, keya iniyaga nawiligi ingembuwiligurau ma inigi kewengkewiligurau mabilik iza oroweigi logo yombanu ini ngangang yanagiwiliyegi iza yanagi. Puwiligu iniyaga nawili yela logo ibengki kani, ");
INSERT INTO big_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","keya ini yeik nogoraga yawe mizirikki wiyeke yongkambanu mabuwiligu iniyegi kumbak mizagi kani. ");
INSERT INTO big_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Puwiligu iniyegi pilik keleyagi kele kapura pilik mizagi piyeng yeikkiyengko keya kazing kumbekki lewengkerik nakkorau ini kebangkelagi ono. ");
INSERT INTO big_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Keya ini kozang panu koyarikku ini wik ngizi koyimagi pura weiyagi. ");
INSERT INTO big_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Kapura inugu Yirusalem yerendagi tapakeleige amiwiligu yawereng kelemiya puwekke purik mabura wok yerenda kaile kaile kelemiyagibek weik mereke lewa kani. ");
INSERT INTO big_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wok piyengke yongkambanu Yudaya ngabelakpekke yolu puwili ngabelakpok wiya logo kazi paka lewakyengke liwik siweki kunizo, keya Yirusalem yerendage yeke ige yolu puwili yereng puraga welagela kazi kunizo, keya Yirusalem yerendaga welagela kuna puwili ngereke yeke yerendagi kang yongo nagani. ");
INSERT INTO big_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Purik wok piyeng Anotogo yongkambanu Yirusalemwiligu kaile kaile mizayengki wiyeke ngangang yanagiyeng, logo puwekke Anotogi Kapiya Walektikke ngago pugu lende miza piyeng weik ngizigi. ");
INSERT INTO big_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Togo Anotogo yongkambanu Yirusalem pewiliyegi sisik miza purikki wiyeke amiwiligu ngangang unatuba panura yongkambanu ngabelak pobokkewilyegi yanagi. Tegi wok piyengke yongok mandik kogo puwili keya yongok mandik yebili yani puwiliyegi ne yalek panu mizagi, purik puwili nguk namizi paka lewakyengke liwik siweki kunagi langai onowili legi. ");
INSERT INTO big_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Keya ami Yuda onowiligu yongkambanu Yuda kolokngagonowili lang yokolongyengko yela logo ibengki keya puwiligu Yuda ibeng ono puwili ngabelak ngezewiligibekka iza orowei ngabelak koweigeyengke kangki, keya ngabelak koweige piyengke Yuda onowiligu Yudawiliyegi ngaigi keya Yudawili puwiliyegi kulengke koya wok Anotogo Yuda onowiligu ngai pura weik yeik kai pokko Yudawili ngereke Yirusalem yerengke yoluweki yogi. ");
INSERT INTO big_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Wok ngabelakpekki kangkali panu piyengkirik, yokmek keya ngombek keya pelewewiligu watabi wirangai nayeng mizagi. Keya ngabelakpekke pelege wizambekki ngai ngagomek keya kailau yemaneyengki wiyeke yongkambanu ngabelak mabiyengkiwili kazi unatuba mizagi. ");
INSERT INTO big_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Keya watabi paka ngilumbekke yolu piyeng urukang mizagi logo piliktikki wiyeke yombanuwiligi wilek kangyeng kulilimokko kolagi keya puwili watabi ngabelakpek mabokko lewagelaweki mizi piyengki wilek ngelek kumulagi kani. ");
INSERT INTO big_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","28","Togo inugu tapakeleige peyeng weik mizi mabura Anotogo ini kunengyengka wila wazayagira weik mereke lewa legi ngai yuke koyimowei wilik kagowing mizageya koyizo. Pilik miza logo pulaga yongkambanuwiligu ne yombanu paka ngalega kayimabek ngereke kozainumbekke kozanda keya ngaiwak unatubarik kiling tabunda lewarikki pakelagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Pulaga ngereke Yisugu ngago saweliwei pera puwiliyegi pelik kozak yeiya, Kusayeng kabeneng panu keya kilili keya kebarek yemane uli puwekke ini iwaka yokpek seliweki mereke mamizi. ");
INSERT INTO big_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kazing mabilikmekke inugu watabi nogo iniyegi kozak yeiya piyeng weik mizirikki pakeli puwekke purik mabura ngabelakka pelege Anotogo pigi ngaimekki kemenak ngaigira weik mereke mamizagi purik inugu iwakagi. ");
INSERT INTO big_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Wameik panu, yombanu ini Yudawiliyegi ngai mizi puwiligu ini mabuwili neneng ngeliweki lewagi kapura ini kemenak neneng ngelagi ono. Iniyagawili ngoluk yolugi logo nawiligu watabi nogo kozak yeiya peyeng mabiyeng ngizi lewagelagirikki keriyagi. ");
INSERT INTO big_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ngilumbek keya ngabelakpek yeik sagi, kapura ngago nogorarau yeik sagi ono, ngago nogora wizagomagi. ");
INSERT INTO big_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Togo ini inugu mizi piyengki waberek ngai koyizo, purik wok negi yogibok nguk namizi iniyegi lewagela wiriyi penangai kani. Keya tamizeige ini kazing wazewaze mizimekke koyimowei kai nameli keya mizi, keya watabi korikwekkiyengki wilibek mizirikki ne pakela logo purik wokpokko nogo iniyegi mizagirik watawiliyegi lagowa wiyi pilik mizagi, ");
INSERT INTO big_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","purik ne yo purik yongkambanu ngabelakpekke pelege yolu puwili mabuwiliyegi lewagelagi kani. ");
INSERT INTO big_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Togo wok mabiyeng waberek panu ngai koyizo keya Anotoyegi waberek wilibek mizageya koyizo logo pugu ini kozanda yanibene. Ini pilik kozang yolu purik mabura watabi nogo lewagelagi kaiya piyengko ini kawiye walibene keleyagi langai ono logo ini kalike ne yombanu paka ngalega kayimabekki wirege luweza koyagi. Tegi ngai yuke koyimowei pilik waberek mizageya koyizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Logo yoklongko Yisu yongkambanuwili Anotogi i walek yemanemakke ngago pugura waligeleyageya wiziya. Kapura kusage purik pi lewak yengelei Olipyeng kilimbekke yolu mizi ");
INSERT INTO big_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","keya wangkotage purik yongkambanu kolokngagonowili Anotogi i walek yemanemakke piyegi kang mizi logo pugu kaiyengki kerewiyiwek ");
INSERT INTO big_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wok yemane Pasobabek meibek weik mereke logo wok pok ngeragi yemane miza nibek, logo kirisimasi mabiyengki keriyibek. Logo wok pokkorik Yudawili perek ngeragi yisriktau onoyeng keremiza logo nibek logo nageya koyimowei walaka Anotogo puwiligi yelibungang kokawiligi iyengki kangyengke iwirik pukmela wizilege keriya logo puwiligi koloyakamandik kalogoliwili ibengkirikka yaliya wazaya puragi kumulibek. ");
INSERT INTO big_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwili kazing Yisu ulagi namekki weli. Puwili yongkambanu yeikwiliyegi kazi kopong puwili liwik mizi. ");
INSERT INTO big_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ngaiwili pilik mizageya keya Sadang Yuras Isaliyoto mei Yisu ngezebokko yombu meleyau keya pongo ingenazikka neyau waligeleyiwiliyaga nakyegi kiliya kuna. ");
INSERT INTO big_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Sadangko weik Yurasgi kangkabekki ngai logo Yuras yombu Anotoyegi kolak miziwiligi ngaiwili keya wagela Anotogi i walek yemanemakki ngai yoluwiligi ngaiwili kiling kazing pugu Yisu mele puwiligiyengke miza yanagimekki kozak keliweki kambela. ");
INSERT INTO big_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yombu yaka puwili wilik miza logo puwiligu pi king managi sawiya. ");
INSERT INTO big_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Togo Yuras ngago puwiligiragi ei miza logo pi weik kazing liwik Yisu keke wizilege yombu ulagi puwiliyegi miza yanagi namekki weik welageya wiziya. ");
INSERT INTO big_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pulaga wok Yudawiligu perek ngeragi Yis meiriktau onoyeng keremiza logo nagibek weik lewagela. Wokpok i namakkiwiligu liyeng memeng marek namek uli mizagibek. ");
INSERT INTO big_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Wokpok weik lewa logo Yisugu Pita keya Yowanyegi pelik yeiya logo wezayela, Kambeli logo ngeragi tenigi Pasobaragi kumuliweki nagiyeng ngayek mizizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tegi piyaugu pelik nguk meiya to mela, Togo talege kangki keya i takkimakke ngeragiyeng ngayek mizagirikki ni keli, meiya. ");
INSERT INTO big_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Pugu pelik yeiya to mela, Kerewiyi, yali paka Yirusalem yerendage kiliya puwekke yombu kaimi narage kai nak kola warabek yaligu paka kazingke yoromaure mizagi kani. Piyegi kiriwei kunizo logo i pugu kiliya kang pumakke yalirau kiriwei lizo. ");
INSERT INTO big_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Logo imakki mangobekyegi pelik meizo, Kiriwagabokko niyegi kaira, Ne kiling yombu nogo waligeleyiwili ngeragi Pasobaragi kumuliweki ngeragi nagimak tamak, meizo. ");
INSERT INTO big_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pulaga pugu yaliyegi yeke ngalege i kawegawe watabi lalek keya pulangaiyeng kiling namak waligeleyi penanging kani pulogo yali ngeragi tonuguyeng ngayek mizizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Piyau weik kambela logo watabi mabiyeng Yisugu yaka piyauyegi kozak yeiya mabilik miza wizilege piyau weik i pumakke ngeragi Pasobaragi kumuliweki nagiyeng ngayek miza wiya. ");
INSERT INTO big_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pilik miza logo ngeragi niwekkerik Yisu yombu ngezebokko waligeleyiwili kiling weik i pumakke kanda logo panga lalektaga mogosa. ");
INSERT INTO big_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pugu puwiliyegi pelik yeiya, Ne waleleige nganganda wagelagine, were ne ngeragi Pasobaragi kumuliweki miza ni peyeng inuwa kiling niweki keli panu. ");
INSERT INTO big_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Purik kerewiyi, ne ngeragi Pasobaragi peyengka nagi ono wiziya watabi Pasobarago walimizi piyengki solorik ngizi miza logo Anotogi ngai yolugi pura yawe mizi puwekke ne ngereke piyeng nagine, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pilik yeiya logo pulaga Yisu kai waing kakpek weiya logo Anotoyegi wazono meiya logo pelik yeiya, Kak pobok weiya logo ini mabuwili kakpekka nizo. ");
INSERT INTO big_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Purik kerewiyi, nogo kai waing pobok nagi ono wiziya Anotogi ngai yolugi pura yawe mizi puwekke ne ngereke nagine, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pilik yeiya logo Yisugu pereksik weiya logo Anotoyegi wazono meiya logo sikila logo puwili yanageya wizimowei pelik yeiya, Pobuzikku walimizi purik korik nogowekki walimizi yagenda. Korik nogowek iniyegi wiyeke puwiligu ne yombanu nelagiwiliyegi yanagi. Ini pezik ni puwekke purik mabura inuwa nogo iniyegi wiyeke watabi miza piyengki kumulizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Puwili ngeragi na logo pulaga kazing mabilikmekke pugu kakpektau puwiliyegi yana logo pelik yeiya, Kai waing kak pobokko walimizi purik iwi nogobekki walimizi yagenda. Pokko walimizi purik Anotogo ini kemenak ibengkiraga yaliya wazayagi puragi langai ngago wik silok tiya pura ngelagi ono, kapura negi iwi kubula walagibokko kozang kelemiyagi. ");
INSERT INTO big_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kapura pakeli, yombu ne yombanu nelagiwiliyegi niza yanagibek ne makngeze kiling lalektaga mogosa yolubek kani. ");
INSERT INTO big_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Purik ne yombanu paka ngalega kayimabek ibengki, Anotogo mizagi kaiya pilik, kapura yombu ne yombanu nelagiwiliyegi niza yanagibekyegi yalek unatuba keli, purik Anotogo pi ngangang yemane panu managi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pilik yeiya logo weik puwili ngezewili takko pura mizagi miza legi nakko nakyegi nguk meiya yongomo mizi. ");
INSERT INTO big_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Keya yombu Yisugu waligeleyiwili ngezewiliyaga tak Anotogi ngaimekke yeikta lewegegi miza legi kozak keli yongomo miza. ");
INSERT INTO big_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pilik legi Yisugu puwiliyegi pelik yeiya, Ngabelak pobok mabokko King Ngaiwili yongkambanuwiliyegi ngai kozang yoluwili keya yaweyeng yaniwili logo puwiligu kelirik yongkambanu yeikwiligu King Ngaiwili yombu wazonowili yeiyagi purikki keliwili. ");
INSERT INTO big_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kapura inuwa pilik pura mizagi onowiligu, segeya inuwayaga yeikta lewegebok, nawiligi kulengke yolubok. Keya ngai yemanebok, nawiliyegi yawe mizibok. ");
INSERT INTO big_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ngabelakpekkewiliyegirik yombanu yemanebek yeikta kilimbek kapura neyegirik yombanu nazuwagawiliyegi yawe mizibok yeikta kilimbek, kapura ne inuwa kiling wizageya wiriyawekkerik ne yombanu nazuwagawiliyegi yawe miziwili kelik, inuwayegi saweli wiriya. ");
INSERT INTO big_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kuneng neyegiyeng lewagelawekkerik inuwa ne wezaniya ono, inuwa ne kiling koya. ");
INSERT INTO big_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Togo negi Mangobokko ne ngai pugumekke ngaiweki keleni pilik, nogorau mabilik ");
INSERT INTO big_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","inuwa ne kiling lalek nogorage ngeragi ni keya kai niweki keleyagi keya tung mogosagiyengke mogosa wazayagi logo yongkambanu Isileiliwiligi ngai meleyau keya pongo ingenazikka neyau piyengki inuwago ngaiweki keleyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Pulaga Yisugu Pitayegi pelik meiya, Simong, Simong, kerewiye, Sadangko Anotoyegi yaka nguk meiya kani ni yang keleniweki, yaweleige ngaibokko iwing palewayengka kaileyeng kik kik kelemiya logo wazonoyeng wei pilik. ");
INSERT INTO big_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kapura, Simong, nogo yaka nigi neyegi ngizi kumuli pura kawiye nelegi Anotoyegi waberek miza kani. Logo ni kawiyegi kapura ya nugura kuneng miza logo neyegi kowita logo ni ngereke yowekke purik mabura ni nigi kewengkewiliyegi kozang keleyimo, meiya. ");
INSERT INTO big_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pitago Yisuyegi pelik meiya, Yemizibek, ne ni kiling panga wigirimakke wigiri keya ni kiling ibengweki kangkere miza wizinda, meiya. ");
INSERT INTO big_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kapura Yisugu piyegi pelik meiya, Pita, nogo nugu kai mangaira neiweki logo pura pelik, kang neyauganara nugu yeik nogora liwik wiyagi logo ni neyegi lusuwei panu kaiya wizigeya pulaga winak talekmek kai penangai, meiya. ");
INSERT INTO big_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yisugu mawinda puwiliyegi pelik yeiya, Koka nogo ini kik kalok king waliyeng keya kik yemaneyeng keya inge kangyeng kilindau ono, yeik wezayela puwekkerik ini watabi nayengkirau suwei wela ma yeik? Pilik yeiya logo puwiligu pelik meiya to mela, Tonuwa watabi nayengkirau suwei wela ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Togo Yisugu pelik yeiya, Wameik panu kapura mabek watabi kunengyeng inuwayegi lewagelagi legi nak kik kalok king wali nagik kilimbek mabura pugik warimo keya mabilik kik yemane nagik purik warimo. Keya nak lang nawektau onobok mabura melewangka pugurik nakyegi kingyengki ngane weibene mana logo king piyengke lang nawek weimo logo warimo. ");
INSERT INTO big_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Purik Anotogi Kapiya Walektikku pobilik kaiya puragi kiriwei, neyegi mizagi, Puwiligu pi yombanu kaile miziwiliyaga nak mena miza. Wameik panu, ngago neyegi langai pilik kaiya piyeng weik ngizi lewagelaweki mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kapura pugu waligeleyiwili puragi solorikki iwaka ono kopong puwiligu pelik meiya, Yemizibek, pakele, lang neyau peyau, meiya. Togo pugu pelik yeiya to mela, Mabilik mena, kangweki, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pulaga Yisu pulumeng wiya logo lewak yengelei Olipyeng kilimbekke kambela, pi ngezebokko mizageyalik. Keya pugu waligeleyiwilirau pi kiling kambela. ");
INSERT INTO big_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Keya puwili paka waberek mizagilege lewagelawekke pugu puwiliyegi pelik yeiya, Pelege waberek mizi, inuwayegi yang keleyiweki lewagi piyengko inuwa kawiye walibene keleya nelegi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pilik yeiya logo pi puwili wezayi panga keke nangezi kuna logo pi ingegereyau laliya logo waberek miza logo pugu Anotoyegi pelik meiya, ");
INSERT INTO big_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","O Peba, nugu neyegi ngangang wiriyagi pura keya ibengki pura yeik sa wazamiye, kapura keli nogora ono, pilik segeya keli ni makngezegiragi kiriwei mizimo, meiya. ");
INSERT INTO big_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Logo Anotogi angela nak weik piyegi kanda kozang kelemiya. ");
INSERT INTO big_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yisu kuneng yemane panu keli legi pi kozang panu waberek miza. Logo ulong pugubek iwibokko wali pilik panga ngabelakpekke wala. ");
INSERT INTO big_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pi pilik waberek miza logo yangalek meiya logo panga ngezebokko waligeleyi neyauganakwiliyegi to kuna logo morok iwek koyilege, purik puwili watabi miziweki mizi piyengki ya kuneng panu kopong puwili iwek kola. ");
INSERT INTO big_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Togo pugu puwiliyegi pelik yeiya, Inuwa iwek kola yolura nangki? Yangalek meiya logo inuwayegi yang keleyiweki lewagi piyengko inuwa kawiye walibene keleya nelegi waberek mizizo, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yisu ngoluk ngago kaiyageya wizigeya yombu kolokngagono wiriya. Yuras meleyau keya pongo ingenazikka neyau Yisu ngezebokko waligeleyiwiliyagabokko kazingmekki orozarikke wiriya. Togo pi Yisu songok kuliweki mereke wiriya. ");
INSERT INTO big_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kapura Yisugu piyegi pelik meiya, Yuras, nugu ne yombanu paka ngalega kayimabek kazing songok kuli pumokko ne nelagiwiliyegi niza yaniweki mizi lewa purik ne iwaka. Tegi ni negi kewengke wezalikpek kewengkewiligimekke songok kuli wak, meiya. ");
INSERT INTO big_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Logo Yisugu waligeleyi pi kiling koyawili pakela logo pelikta miziweki mizi mamiza legi puwiligu pelik meiya, Yemizibek tonugu lang tonuguyengko yeli pei ma, meiya. ");
INSERT INTO big_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mabuwekke puwiliyaga nakko yombu Anotoyegi kolak miziwiligi ngai yemane panubekyegi yawe mizibekki kerelik ngaigezuwagemek peto ula mela. ");
INSERT INTO big_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kapura Yisugu pelik meiya, Pilik mizi wak. Yawe pilik mizi pura ngereke mizi nagani, wizamimo, meiya logo pugu yaka yombubokki kebira keya kerelikmektau kebangkela logo yombiyangai wazamiya. ");
INSERT INTO big_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pulaga Yisugu Yudawiligi yemanewili keya yombu Anotoyegi kolak miziwiligi ngaiwili keya wagela Anotogi i walek yemanemakki ngai yoluwiligi ngaiwili pi miza wariweki wiriya puwiliyegi pelik yeiya, Ini mabektik ne yombanu ngowei wezalikpekyegi lang keya kilikkilikyeng kiling ne niza wari yawerenda. ");
INSERT INTO big_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ne ini kiling panga Yirusalem Anotogi i walek yemanemakke wok mabiyeng wiziya kapura pilikwekke inugu ne kebangkela ono, kapura weik pera inugu ne kebangkeliwekira, purik Anotogo inuwayegi Sadangko sawelibene piyegi ei meiya kopong keya Sadang kusabanurikke ngaibekki kozanda ini kiling wizinda kopong, ini weik pilik mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Puwiligu weik Yisu kebangkela logo pi miza orowei panga yombu Anotoyegi kolak miziwiligi ngai yemanebekki imakki kuna. Logo Pita ngereke yorik Yisuyegi kalika koweige kiriwei kuna. ");
INSERT INTO big_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pi yaka ngai yemane panubokki imakke kanda puwili imakke yerengke yezizik waliya koyilege Pitarau pulogo yezizikke mogosa puwili kiling mogosa wiziya. ");
INSERT INTO big_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Logo kolomandik yawe miziwiliyaga namelego pi yezizikke pulogo mogosa wizilege pakela logo pugu piyegi ngai yuke panu wizimowei pelik kaiya, Wameik panu, yombu poboktau Yisu kiling wiziyabek kani, kaiya. ");
INSERT INTO big_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kapura Pitago ngaigu, A’a’. Yongokmele, ne pokyegi lusuwei, meiya. ");
INSERT INTO big_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Songono nangezi wiziya logo yombu nakko Pitayegi pakela logo pelik kaiya, Nirau Yisugi yombanuwiliyaga nak kani. Pilik kai legi Pitago pelik kanga meiya to mela, Yombanubek, ne puwiliyaga nak ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Keya pulaga awa wamenak wiziya logo pulaga yombu nakkorau nawiliyegi ngago kozang pelik yeiya, Wameik panu, yombanuboktau Yisu kiling wiziyabek, purik ngago pugurago pi pongo ngabelak Kalili meibekkabek mizi. ");
INSERT INTO big_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kapura Pitago pelik kanga meiya to mela, Yombanubek, nugu kozak kai puragirau nogo iwaka ono, meiya logo pi ngoluk ngago kaiyageya keya nguk namizi winak talekmek weik ngago kai. ");
INSERT INTO big_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yemizibek yowezak meiya logo Pitayegi ngai yuke panu kelemiya logo mabuwekke Pita weik ulogo Yemizibokko piyegi ngago lang pelik kozak meiya pura, mabek kusage winak talekmek ngago kaiyagine ni were kang neyauganara neyegi lusuwei kaiyagi kani, meiyaragi kumula ");
INSERT INTO big_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","logo pi kuneng yemane miza logo yenge yerengke welagela kanda ingi yemane panu kaiya. ");
INSERT INTO big_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Keya pulaga wagela Yisuyegi ngai yuke puwiligu wiregawere pugura kagorik walerikku ngokmana logo piyegi songomeiya mani keya yang mei keya pi uli kelemiya logo puwiligu piyegi pelik meiya, Nugu ni Anotoyaga ngagoyeng weiya logo kozak kaibek kai mena takko ni neli miza purik kozak kai, meiya. ");
INSERT INTO big_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Keya puwiligu ngago korowali nayendau piyegi meiya. ");
INSERT INTO big_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wangane pura Yudawiligi yemanewili keya yombu Anotoyegi wata kolak kelibene miziwiligi ngaiwili keya yombu Mosegi loyengki waligeleyiwili menalege wawere ula logo Yisu miza orowei ngezewiliyaga ngagozakyengki kerewiyiwiliyegi kuna. ");
INSERT INTO big_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Yeke ige kanda puwiligu Yisuyegi pelik meiya, Nugu ni Kilisibek, Mesiyabek Anotogo yawe pigi teni yaliya wazayagi pura miziweki sawiyabok ma yeik purik teniyegi kozak kai. Pilik kisi legi pugu pelik kanga yeiya to mela, Tamizeige nogo iniyegi kozak yei purik inugu neyegi ngizi kumulagi ono. ");
INSERT INTO big_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Keya tamizeige nogo iniyegi nara nguk yei puwekkerik inugu neyegi kanga kisa yo melagi ono. ");
INSERT INTO big_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kapura mabek teng peraga kang purik ne yombanu paka ngalega kayimabek ngereke paka ngalegi yongorik Anoto watabi mabiyengki kozandagi mangobekki ngaigezuwage mogosa yolugi logo pi kiling ngaiweki, yeiya. ");
INSERT INTO big_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pugu pelik yeiya logo puwili mabuwili piyegi pelik meiya, Togo ni Anotogi Marekpek? Legi Yisugu puwiliyegi pelik yeiya to mela, Ini makngezego ne pok kisi yagenda keya inugu ngago kisi pura wameik. ");
INSERT INTO big_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pugu pelik yeiya logo puwiligu pelik kisa, Teni makngezego kili ngezebekki panurago kairikki yaka kerewiya, legi teni ngereke ngago talikta kerewiyiweki? ");
INSERT INTO big_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pulaga puwili mabuwili yangalek meiya logo Yisu miza oroweirik yombu ngabelak Yudaya meibekki Rom Kapman ngaibek Pailet meibekyegi kuna. ");
INSERT INTO big_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Panga pulogo kanda puwiligu piyegi weik ngago kolokngagono yowa logo puwiligu Pailetyegi pelik meiya, Teni yombu pobokko yongkambanu tonuguwiligu kazing mizi kayimiyengka kokowa lewengke iza orowei keleyirikki pakela, keya Sisa Rom Kapmanbekki King Ngai tenigibekyegi teni king takisyeng mana nelegi yei, keya pi ngezebek Kilisibek, pi King Ngai nak yeirikki wiyeke miza orowei lewa, meiya. ");
INSERT INTO big_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Togo Pailetgu piyegi pelik nguk meiya, Ni Yudawiligi King Ngaibek ma yeik, meiya. Tegi Yisugu pelik meiya to mela, Ni makngezego kai mabura, meiya. ");
INSERT INTO big_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pulaga Pailet yenge yerengke kuna logo pugu yombu Anotoyegi kolak miziwiligi ngaiwili keya yongkambanu wawere ulawiliyegi pelik yeiya, Nogorau ngago korowali yombanu pobok ngagozak kelemiyagi langai nararau piyaga kerewiya ono, yeiya. ");
INSERT INTO big_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pailetgu pilik yeiya kele kapura puwiligu kozang panu pelik kisa, Ngago pugu yongkambanu yeikwiliyegi waligeleya piyengko puwili Kapmanwiliyegi kiyebuk miziweki keleyi. Pi solo pilik mizarik Kalili ngabelakpekka miza logo pulaga Yudaya ngabelakpek mabok waligeleyi kang kayimeige mabek weik Yirusalem yerengke pelege lewagela, meiya. ");
INSERT INTO big_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pulaga Pailet puwiligu yeik Kalili pura kisa puwekke kerewiyawekke pugu nguk yeiya, Yombanu pobok Kaliligabek ma yeik, yeiya. ");
INSERT INTO big_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Logo pi Yisu ngabelak Elodogo ngai yolubokkabek purikki iwakawekke, pugu Yisu Elodoyegi wezamela, purik Elodorau Yirusalem yerengke mabuwekke wizilege. ");
INSERT INTO big_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Elodo Yisuyegi pakela logo pi wilik, purik pi koka Yisugu miziyengki kerewiya logo pugu kelirik Yisugu Anotogo keke mizi nayeng mizirikki pakeliweki keli legi pi Yisuyegi wok pakela yoluweki keli. ");
INSERT INTO big_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Logo Elodogo ngago kolokngagono Yisuyegi nguk meiya kapura Yisugurau ngago lang narik kaiya ono. ");
INSERT INTO big_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Keya yombu Anotoyegi kolak miziwiligi ngaiwili keya Mosegi loyengki waligeleyiwili pulogo mereke kanda Yisuyegi ngago kolokngagono panu yowa. ");
INSERT INTO big_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Logo Elodo kiling ami pigi nawiligu Yisuyegi yang meiya keya piyegi kendek ngelaiyeng kelemiya. Pilik mizageya koyimowei puwiligu pi kagorik palumu King Ngaiwiligu wakiyi pilik narik wakiya wazamiya logo Pailetyegi ngereke miza mana. ");
INSERT INTO big_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Wok mabokko Elodo keya Pailet kewengkeyau miza. Piyau kokarik nakko nakyegi ngai keremizageya koyimayau, kapura Yisuyegi wiyeke piyau weik kewengkeyau miza. ");
INSERT INTO big_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pulaga Pailetgu yombu Anotoyegi kolak miziwiligi ngaiwili keya Yudawiligi ngaiwili kiling Yuda yongkambanuwiliyegi ngago yeiya ");
INSERT INTO big_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","logo puwiliyegi pelik yeiya, Inuwago yombu pobok neyegi miza orowei kanda pelik kisi, Yombanu pobokko yongkambanu tonuguwiligu Kapmanwiliyegi kiyebuk miza logo puwiligu kaile miziweki keleyi kisi, logo mabek inuwagi wirege nogo piyegi nguk mei keya kerewiya miza kapura nogo piyaga inuwago ngagozak kelemiweki mizi puragi ngizi nara kerewiya ono. ");
INSERT INTO big_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Keya Elodogo pi teniyegi ngereke wezayomela purik pugurau mabilik nara kerewiya ono. Logo kerewiyiwekkerik yombanu pobokko kazing korowali tonugu pi ula logo ibengki langai namek miza ono. ");
INSERT INTO big_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tegi ami nogowiligu pi yeik wizale ula logo kazing inugu mizimekke nogo wila wazamiyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kazing pumok pelik, wok Yudawiligu Pasobaraga pakelibekke kirisimasi mabiyengkerik Pailetgu yombanu wirigirawiliyaga puwiligu keli nak wila wazami mizi. ");
INSERT INTO big_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pailetgu pilik miziweki mizi purik puwiligu iwaka legi puwili mabuwili menalege ngalizi pelik kek kisa, Yombanubok wila wazami nagani, pi ule. Keya yombu Parabas meibok wila wazamiya logo teniyegi yane, kisa. ");
INSERT INTO big_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Parabas ulogo Romwiligi Kapman ngaiwiliyegi ngai miza logo yombanu nak ula logo ibendikki wiyeke wigira wazamiyabek. ");
INSERT INTO big_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailet pilik kisi puragi kerewiya kapura pugu kelirik pi Yisu yeik wila wazamiyagi keli legi yongkambanu wawere ulawiliyegi mazenda nguk yeiya, ");
INSERT INTO big_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","kapura puwiligu ngalizi pelik kek kisa yo mela, Pi paka yengeleileige nili ule, kisageya mizi. ");
INSERT INTO big_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilik kisa logo Pailet ngago kang neyauganararau puwiliyegi pelik yeiya to mela, Kapura korowali talikta pugu miza kai? Nogorau pugu korowali mizi keya kai pi ibeng wazamiyagi langai nayendau kerewiya ono legi nogo ami nogowiliyegi pi ngangang managiragi kozak yeiya logo yeik wila wazamiweki mizi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pugu pilik yeiya kapura yongkambanuwiligu ngoluk mazeng keya ngalizi panu pelik kek kisa, Yisu paka yengeleileige nili uliweki, kisa. Togo kalik panuge puwiligu kek kisayengko ngago Pailetgira ula. ");
INSERT INTO big_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tegi Pailet weik puwiligu keli maburage Yisu uliweki miza. ");
INSERT INTO big_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Keya puwiligu yombu wila wazamiweki kelibok Pailetgu wila wazamiya. Pok ulogo Romwiligi Kapman ngaiwiliyegi ngai miza logo yombanu nak ula logo ibendikki wiyeke wigira wazamiyabok, kapura Pailetgu Yisu puwiliyegi miza yana logo puwiligu piyegi miziweki keli piyeng mizibene. ");
INSERT INTO big_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pulaga weik yombu Rom Ami puwiligu weik Yisu miza orowei kuna. Puwili tagoneige pura kazingmekke yombu Saimon yereng Sairini meiragabek paka yawega lewa logo paka Yirusalem yerengke kuniweki wizilege. Puwiligu pi kebangkela logo Yisugi yengeleilei wagela wazamiya logo Yisuyegi kalika kiriwei kunibene meiya. ");
INSERT INTO big_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yongkambanu kolokngagono wawere ulawili piyegi kiriwei kuna. Puwiligi tepekke yongok nawili ingkeya ngabik mizi keya ingi yalek mizagi nayeng mei kuna. ");
INSERT INTO big_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yisu puwiliyegi langai kowita yo mela logo pelik yeiya, Ini yongok Yirusalemgawili, ini neyegi wiyeke ingkisi nagani, kapura ini makngezego ini makngeze keya inigi yango keya marekngangwiliyegi ingkisagirikki kai. ");
INSERT INTO big_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Purik kerewiyi, wok kalike kuneng korowali yemane panuyeng keya ngangang yemane panuyeng lewagiyengke purik yongkambanu nawiligu pelik kisagi, Anotogo ini kabili puwiliyegi langai wazono miza wizinda, keya pugu ini yongok koloyakong wazayi nangai puwiliyegi wazono miza wizinda, keya pugu ini yongok koloyakong yebili yana ono puwiliyegi wazono miza wizinda, kisagi. Pilik puwili wilikwilik panu mizagiwili, purik puwili koloyakong puwiligiwiliyegi ingkisagi ono. ");
INSERT INTO big_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wok kuneng keya ngangang mizagi piyengke purik yongkambanuwiligu lewakyengki pelik kisagi, Teni ibengki keli mena tenigi ngalege wali, kisagi, keya lewe songonoyengkirau pelik kisagi, Teni ibengki keli mena, teni ngokmani, kisagi. ");
INSERT INTO big_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yisugu pilik yeiya logo mawinda ngago saweliweira pelik yeiya, Tamizeige yengelei ngoluk wikleigi kaile pilikyeng mizi purik mabura yengelei ngoliyaleige talik mizi penangai? Purik pelik kai yagenda, Puwiligu mabek ne yombu kaile nararau miza onobekyegi ngangang nanagi legi puwiligu kalike ngereke ini yongkambanu kokowa mizawiliyegi ngangang yemane panu yani nangai, yeiya. ");
INSERT INTO big_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Puwiligu yombanu neyaurau iza orowei, kuna piyau mabiyau kazing korowaliyeng miza logo wigira wazayayau, logo piyaurau Yisu kiling yengeleiyauge yelagiyau. ");
INSERT INTO big_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Puwili mabuwili weik kanda ngabelak wale yeikta Kebi Kozarik meirikke logo Rom Amiwiligu pulogo Yisu yengeleileige ngalege nili ula logo yengeleilei luwe lewamiya. Keya yombanu kazing korowaliyeng mizayaurau mabilik keleya. Nak Yisugi mele ngaigezuwagezikke wazami keya nak pigi mele koranengkezikke wazami miza. ");
INSERT INTO big_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pilik miza logo Yisugu pelik waberek miza, O Peba, mabek mizi piyengki puwili lusuwei legi kaile kaile puwiligu neyegi mizi piyeng tumula logo keremareke wezamelimo, meiya. Togo amiwili takko Yisugi kagorikyeng weiyagi miza legi puwili yengelei lek uli. ");
INSERT INTO big_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Puwili pilik mizageya koyigeya yongkambanuwili pulaga luweza koyimowei pakela yolu, Yudawiligi ngai yemanewiligu piyegi pelik yang kisa, Pugu nawili ibendaga yaliya wazaya mena tamizeige pi Kilisibek Mesiya Anotogo yawe pigi yongkambanuwili yaliya wazayagi pura miziweki sawiyabek purik mabura ngezebokko ngezebek ibendaga yaliya wazamiye, mei, kisa. ");
INSERT INTO big_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Keya amiwiligurau mabilik piyegi yang mei wiriyimowei puwiligu piyegi mereke kanda kai waing walek narik niweki mana ");
INSERT INTO big_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","logo pelik meiya, Tamizeige ni Yudawiligi King Ngaibek purik mabura ni makngezego ni makngeze yaliya wazame, meiya. ");
INSERT INTO big_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ngago lang peyeng paka pigi ngalege pelang korokwekke pelik lende miza, Pobok Yudawiligi King Ngaibek kani, miza. ");
INSERT INTO big_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yombu kazing korowaliyeng miza logo wiramiya piyauyaga nakko Yisuyegi pelik meiya, Nugu ni Kilisibek kaibek mena, ni makngeze keya terau yaliya wazaye, meiya. ");
INSERT INTO big_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pilik mei legi nakko puragi kerewiya logo piyegi pelik ngalik meiya, Pilik mei wak. Ni Anotoyegi kulili kesak ni pilik mei kak ono. Towa ngangang pugu wei mabilikta wei kani. ");
INSERT INTO big_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Towa nganganda wei perik kazing towa ngezego mizayengki wiyeke wei yagenda logo towa ibeng wazayi perik kazing pangkamekke kapura yombu pobok kaile kaile nara mizarikki wiyeke pi nganganda wei yagenda ono kani, meiya. ");
INSERT INTO big_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pilik meiya logo pugu Yisuyegi pelik meiya, Yisu, wok ni ngai kozanda kiling ngai yemizi wizeiweki lewa puwekke purik mabura neyegi kumulimo. ");
INSERT INTO big_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Pilik mei legi Yisugu piyegi pelik meiya to mela, Nogo wameik niyegi pera kozak nei, Mabek wokpekke ni ne kiling yereng yombiyangai Paladisi meirage yolugi, meiya. ");
INSERT INTO big_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yokmek weik paka ngilumbekke libuge 12 kilok si ngizige yokmek kusa logo ngabelakpek mabok weik kusa logo wiziya yokmek panga luwege neyauganakwekke yokmek ngereke ngaiwila. ");
INSERT INTO big_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yokmek ibeng wiziya puwekke kagorik Anotogi i walek yemanemakke ngalege wiramiyarik libuga koliyara narik narik miza. ");
INSERT INTO big_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yisu ngalizi panu pelik kek kaiya, O Peba, ne kung nogobek mele nuguzikke nani. Pi pura kaiya logo pulaga weik ibeng. ");
INSERT INTO big_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Togo yombu amiwiliyegi ngaibokko watabi yaka lewagela mela piyengki pakelawekke pi Anotogi yeikta pelik yongolok meiya, Wameik ngizi panu, yombu pobok kaile nayendau miza ono, pi pangka panubek, meiya ");
INSERT INTO big_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yongkambanu yaka kayima logo pakeliweki pulogo wawere ulawiligu watabi yaka lewagela mela piyengki pakelawekke puwili mabuwili i ngezewiligiyengke kando kunimowei nak nak kaile ngezebekkiyengki kuneng kelirikki wiyeke ngeleleng ngezebekkira ula. ");
INSERT INTO big_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Keya Yisuyegi kewengkewili kiling yongok Kaliliga piyegi kiriwei kelemi kayima puwili panga koweige nangezi koya logo watabi piyegi mizi piyengki pakelara koya. ");
INSERT INTO big_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Yombanu pulogo yolu nakki, yeikta Yosep. Pi Yudawiligi yereng yeikta Arimatiya meiyaragabek. Pi yombanu wazonobek keya pi pangkabek keya pi yombu ngagozakyengki kerewiyiwiliyaga nak. ");
INSERT INTO big_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kapura pi kazing yombu ngagozakyengki kerewiyiwiligu Yisu uliweki miziyengki keli panu ono keya pi, ei, yei ono. Pi teng Anotogo pigi ngaimekki ngaigi puragi yuke yolubek. ");
INSERT INTO big_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pok panga Pailetyegi kanda luweza wizimowei Yisugi yasurik wawiyiweki meiya. ");
INSERT INTO big_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pailetgu piyegi ei meiya logo pi yasurik orowei yerageya logo kagorik wilangka wazono narikku sape miza logo mosindaga king ururu yombanu waliyiweki keremiza namek ngoluk yombanu naktau pulogo waliya onomekke yasurik wiya. ");
INSERT INTO big_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wok melenazikpekke piyeng pilik miza. Wokpok yongkambanuwili watabi Yudawiligi wok yawe mizi onobek wok Sabatpek meibekkiyeng ngayek mizibek logo wokpok weik lewagelaweki mereke legi puwili weik Yisugi yasurik nguk namizi panga mosindaga wiya wazamiya. ");
INSERT INTO big_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yongok ngabelak Kalilibekka Yisuyegi kiriwei kelemi kayima puwili Yosepyegi kalika kiriwei kambela logo Yisugi londa king ururumekki wizilege pakeli keya Yisugi yasurik talik wiya miza legi pakeliweki kambela. ");
INSERT INTO big_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pilik pakela logo waleleige puwili ngereke Yirusalem yerengke yo kayima logo puwili weli keya watabi pulangai kukngizi keliyengka korik puguwekke meliweki pangka pangka miza wiyageya koyima. Pilik miza logo wok Sabatpekke lorago miziweki kaiyalik legi puwili yerengke kumanara koyima. ");
INSERT INTO big_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wok Sondabekke wangane panu yongokwili weli keya watabi pulangai kukngizi keli ulogo pangka pangka miza wiya piyeng orowei Yisugi londagi kambela. ");
INSERT INTO big_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pulogo kanda puwili king yemane Yisugi londage ulogo kandikke waliya wazamiyara yomizora wezamelarikki pakela. ");
INSERT INTO big_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tegi puwili yeke ige kiliya yabela kapura puwiligu Yisugi yasuriktau pulogo pakela ono. ");
INSERT INTO big_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Puwili puragi wilek ngelek kumula logo talik tomizo mizageya koyi tagogei nguk namizi yombu watabi wilangka ngaiwaktikku kolayeng wakiya neyau puwiliyegi saweliwei luweza koyilege. ");
INSERT INTO big_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yongokwili piyauyegi pakela logo kulili miza logo morogulung meiya logo ngabelakke pakela momelirikki yombuyaugu puwiliyegi pelik yeiya, Inuwa ibengwiligi tepekke wik yolubokyegi weli lewara nangki? ");
INSERT INTO big_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Pi pelege yolu ono, kani. Pi yaka yangalekta kani. Pi ngoluk ngabelak Kalilibekke wiziya puwekke pugu inuwayegi kozak yeiya puragi kumula to meli. ");
INSERT INTO big_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Pugu inuwayegi pelik yeiya, Ne yombanu paka ngalega kayimabek yombanu kaile kaile miziyeng miziwiligi meleyengke niza yaniweki logo yengeleileige ngalege neliweki logo wok neyau miza logo wok kalikebekke ibendaga yangalek meiweki, yeiya, yeiya. ");
INSERT INTO big_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Piyaugu pilik yeiya logo yongokwili ngago Yisugu koka kaiya piyengki weik kumula to mela ");
INSERT INTO big_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","logo puwili londa wiya logo panga yerengke kandobela logo puwiligu yombu meleyauganak pugu ulogo waligeleyawili kiling nawiliyegirau watabi pakeli keya kerewiya piyeng mabiyengki kozak yei miza. ");
INSERT INTO big_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yongok puwili, Maliya Matalena keya Jowana keya Maliya Jemsgi panumele keya puwili kiling yongok nawilirau Yisugu wezayela Aposolowili meiwiliyegi piyengki kozak yeiyawili. ");
INSERT INTO big_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kapura wezayelawiligu kumularik yongok puwiligu kozak kisi pura ngago yeiktago kisi yagenda miza logo puragi ngizi panu kumula ono. ");
INSERT INTO big_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kapura Pita yangalek meiya logo panga Yisugi londagi nginda kanda, pi lawila logo yeke ige pakeliraige pura kagorikkayeng ngezeyeng wizilege keya nayendau ono. Tegi pi paka ige talik miza miza puragi wilek ngelek kumuli kandobela. ");
INSERT INTO big_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wok mabokko yombu mabuwiliyaga neyau pongo yereng yeikta Emeyasa meiragi kambela. Yirusalem yerengka pongo yereng Emeyasa mei puragi yokolondik 7 mailgi pangka. ");
INSERT INTO big_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Logo piyau watabi yaka miza piyengki nakko nakyegi kozak mei kuna. ");
INSERT INTO big_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Piyau ngagozakka tagoneige pura Yisu ngezebek piyauyegi mereke kanda weik piyau kiling kuna. ");
INSERT INTO big_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Logo piyaugu piyegi pakela, kapura piyaugurau piyegi yombu yelebe miza ono. ");
INSERT INTO big_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yisugu piyauyegi pelik yeiya, Yaligu kang kunimowei kozak kela yongomo mizi kang pura nangaiyengki, yeiya. Pilik kai legi piyaugi wirega wereyau yalekke sara koyimowei piyegi pakela. ");
INSERT INTO big_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Logo piyauyaga nak yeikta Kiliyopa meiyabokko piyegi nguk meiya, Nugu kai purik ni yombanu Yirusalem yerengke wiziyabek kapura watabi yaka wok moleige peyengke lewagela piyeng ni ngoluk iwaka ono, kai yagenda ma, meiya. ");
INSERT INTO big_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Legi pugu pelik nguk yeiya to mela, Watabi nangaiyeng? Pilik nguk yeiya legi piyaugu kanga pelik meiya to mela, Watabi Yisu Nasarete yerengkabekyegi langai miza piyeng. Yombanu pok Anotoyaga ngagora weiya logo kozak kaibek, keya pi Anotogi wirege keya yongkambanuwiligi wirege yawe kozanda mizibek keya ngago kozanda kozak kaibek. ");
INSERT INTO big_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Logo tenigi yombu Anotoyegi kolak miziwiligi ngaiwili keya ngai yemanewiligu ibeng sibene miza manabek, logo puwiligu yengeleileige ngalege ulabek. ");
INSERT INTO big_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tonugu koka kumularik yombanu pobok Anotogo wezamela logo teni Isileiliwili Rom Kapmanbokko ngai puraga wila wazayiwekibek mizabek. Keya watabi nayendau pelik, watabi piyeng ulogo wok were piyauge mizayeng. ");
INSERT INTO big_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kapura yongok teni piyegi kiriwei miziwiliyaga nawiligu teniyegi watabi nayeng kozak yeiya logo teni lebuk ngai keleya. Puwili yaka wangane Yisugi londagi pakeliweki kambela ");
INSERT INTO big_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kapura yasu pugurik kakwela logo puwili yorik pelik kisi lewa, Teni Anotogi angela nawiliyegi pakela logo puwiligu teniyegi kozak kisirik pi wik yolu kisi mena, kisi. ");
INSERT INTO big_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Teniyaga nawili Yisugi londage pakeliweki kambela logo yongokwiligu yaka kozak kisa mabilik panu wizilege pakela, kapura pirau puwiligu pakela ono, meiya. ");
INSERT INTO big_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Piyaugu pilik meiya logo Yisugu piyauyegi pelik yeiya, Yali kangka yeikyau kani. Keya yaligu ngago yombanu Anotoyaga ngagora weiya logo kozak kisawiligu kozak kisa piyeng mabiyengki nguk namizi ngizi panu kumuli ono. ");
INSERT INTO big_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Purik puwiligu pelik kisa, Kilisi Mesiyabek were nganganda wagelagi logo kalike yeik yemane pugura weiyagi, kisa, yeiya. ");
INSERT INTO big_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Togo Yisugu piyauyegi Kapiya Walektikke pi ngezebekyegi langai solo kaiya piyeng mabiyeng waberek kozak yeiya. Logo solo Kapiya Walek Mosego lende mizayeng keya pulaga yombanu Anotoyaga ngagora weiya logo kozak kisawiligu lende mizayengki kozak yeiya. ");
INSERT INTO big_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Puwili yereng Emeyasa purage mereke pura, Yisu ngoluk koweige kangweki miziwiligu mizilik mizi. ");
INSERT INTO big_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kapura piyaugu waliya logo pelik meiya, Te kiling iwekweki koli. Wokpek weik yeik keya kusaweki mizi mena, meiya. Pilik mei legi pi piyau kiling iwekweki yeke ige kiliya yabela. ");
INSERT INTO big_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Togo pi piyau kiling lalektage mogosa logo pereksik weiya logo Anotoyegi wazono meiya logo pugu pereksik sikila logo piyau yana. ");
INSERT INTO big_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pilik mizi ngizige wire piyaugiyau weik ngaiwila wizigeya piyaugu piyegi pakela logo iwaka kapura pi piyauguyaga weik tamek neing miza. ");
INSERT INTO big_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pilik miza logo piyau nakko nakyegi pelik meiya, Pugu paka kazingke towayegi ngago kai keya Anotogi Kapiya Walektikki solorikki kozak yeiya puwekkerik wilek kang towagiyeng wilikwilikmokko kola, kela. ");
INSERT INTO big_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Togo piyau nguk namizi yangalek meiya logo paka Yirusalem yerengke kang yongobela. Paka pulogo kanda yombu meleyau keya nazikka nakwili menalege wawere ula logo nawili kiling koyilege. ");
INSERT INTO big_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Puwiligu piyauyegi pelik yeiya, Wameik panu. Yemizibek yangalekta kani. Pi ulogo Simong Pitayegi kayima logo Simong Pitago pi pakela, yeiya. ");
INSERT INTO big_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pilik kisi legi piyaugu puwiliyegi pongo kazingke lewagela puragi waberek kozak yeiya, keya pugu pereksik sikila puwekke piyaugu Yemizibekyegi pakela logo iwaka sa puragi kozak yei miza. ");
INSERT INTO big_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Piyaugu puwiliyegi pura kozak yeiyageya tagogei pura Yisu ngezebek nguk namizi puwiligi tepekke luweza wizimowei puwiliyegi pelik yeiya, Ya inuwagiyeng ngezege sara kiling koyi pani, yeiya. ");
INSERT INTO big_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kapura puwili lebuk miza keya kulili miza. Puwiligurik yombanu kung nak pakeli nobiyeng miza ");
INSERT INTO big_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","kapura pugu puwiliyegi pelik yeiya, Ini wilek kuneng mizira nangki? Keya nangki wiyeke wilek ngelek kumula meli? ");
INSERT INTO big_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pakeli. Inge keya mele puwiligu nili ula piyengki logo ne mabok miza logo iwaka si. Keya ne kebangkela logo iwaka si, purik kung nak muzuktik keya kozayendau onobek, yaka inuwago ne kebangkelawekke muzuk keya kozayeng kebangkela pilik. ");
INSERT INTO big_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pugu pilik yeiya logo puwiliyegi inge keya mele puguyeng waligeleya. ");
INSERT INTO big_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Puwili wilikwilik kapura puwili Yisu wik yolu purikki ngoluk ngizi panu kumuli ono koyimowei wilek ngelek kumula mela. Pilik kumuli legi pugu puwiliyegi nguk yeiya, Ini watabi nagi nayendau pelege ma yeik, yeiya. ");
INSERT INTO big_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Togo puwiligu pi watabisi pak mizamekka narik mana ");
INSERT INTO big_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","logo pi weiya logo puwiligi wirege na. ");
INSERT INTO big_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pulaga pugu puwiliyegi pelik yeiya, Ngago pobiyeng ne koka ini kiling yolu puwekke iniyegi kozak yei kayima piyeng. Mosegi loyengki watabi lende miza piyeng, keya yombu Anotoyaga ngagora weiya logo kozak kisawiligu lende miza piyeng, keya Kapiya Walek Ingi Samyengki purikke neyegi langai lende miza piyeng mabiyeng ngizi mizagirikki kaiyeng, yeiya. ");
INSERT INTO big_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pilik yeiya logo pugu kangka puwiligiyeng kimeike wela wazaya Anotogi Kapiya Walektikke iwaka sibene logo ");
INSERT INTO big_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","pugu pelik yeiya, Ngago Anotogi Kapiya Walektikke lende miza pura pera, Kilisibek nganganda wagelagi logo wok neyau miza logo wok kalikebekke ibendaga yangalek meiweki, ");
INSERT INTO big_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","logo waleleige yombanu nawiligu Yirusalem yerengka sa wizigeya yongkambanu ngabelak mabiyengkewiliyegi yeik Kilisigirage ngago yongkambanuwili kaile kaile puwiligiyengki kuneng mizi keya kazing kaile puwiligiyengka kowiti keya wilek kang puwiligiyeng Anotoyegi sawela, logo Anotogo kaile puwiligiyeng tumula logo keremareke wezamelagiragi kozak yeiyagirikki kai, yeiya. ");
INSERT INTO big_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Keya ini yongkambanuwiliyegi watabi inugu ulogo pakela peyengki kozak yeiyagiwili kani. ");
INSERT INTO big_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Keya kerewiyi, ne makngezego negi Mangobekki Kung Walek pugu iniyegi yeik yanagi kaiyabok nogo iniyegi kiliyibene wezamelagi. Kapura ini paka Yirusalem yerengke yuke koyizo wizigeya kozang paka ngalegabek kanda iniyegi kiliya puwekkine, yeiya. ");
INSERT INTO big_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pulaga pugu puwili Yirusalem yerendaga iza orowei Petani yerengke mereke kuna. Logo pulogo pugu mele puguyau paka ngalege puwiliyegi langai miza wizimowei pugu pelik yeiya, Anotogo iniyegi wazono mizagi. ");
INSERT INTO big_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pugu puwiliyegi pilik yeiyageya keya weik Anotogo pi paka ngalege miza orowei kang yongo. ");
INSERT INTO big_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Togo pulogo puwili piyegi ya kumula keya yeik pugura yongolok meiya logo paka Yirusalem yerengke wilek kang puwiligiyeng wilikwilikmokko kola koyimowei kang yongobela. ");
INSERT INTO big_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Logo puwili Anotogi i walek yemanemakke Anotoyegi wazono mei keya piyegi ngago wilikwilik mei keya yeik pugura yongolok meiyageya koya. Ne Lukago ngago wameik panura ni Tiyopilayegi lende mizara mabura. ");
INSERT INTO big_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Watabi wizageya koyi kambeli piyeng mabiyeng keremizagine Ngagora meibok wiziya. Pi Anoto kiling were wiziya keya ngoluk yolu keya pi mabok Anoto. ");
INSERT INTO big_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pi solo panuwekkerikka Anoto kiling wizageya kayimibokko. ");
INSERT INTO big_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Keya watabi mabiyeng Ngagora meibokko keremiza logo pugurau keremiza ono nayeng taiyeng kaiyagi? ");
INSERT INTO big_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ngagora meibokko ngizi yoluragi solorik keya pugu wameikta yongkambanuwiliyegi waligeleya logo kazing pilikmekke pi yongkambanuwiligi wilangkarik logo puwili Anotoyegi kimeike pakeliweki. ");
INSERT INTO big_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Logo wilangkarik kaile ngabelakpekki piyengki kusabanurikki tepekka weik ngela uli logo kaileyengkorau ngokmorokta wiyagi ono. ");
INSERT INTO big_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anotogo yombanu Yowan mei nak ngago pugura orowei miziweki wezamela, ");
INSERT INTO big_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","pi yongkambanuwiliyegi wilangkarikki mangobekyegi langai kozak yeiweki kayima, logo puragi kerewiyi puwili mabuwili ngizi kumulibene. ");
INSERT INTO big_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yowan ngezebek wilangkarikki mangobek ono, pi yeik wilangkarikki mangobokyegi langai yongkambanuwiliyegi kozak yeiwekibek. ");
INSERT INTO big_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Logo wilangka purik wilangka ngizi panurik logo pok ngabelakpekke pelege kayima logo ngela ulageya wizimowei pugu yongkambanuwili mabuwiliyegi Anoto kimeike waligeleyageya. ");
INSERT INTO big_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Togo wilangkarikki mangobek Ngagora meibok ngabelakpek keremiza kele kapura pi ngabelakka kayimawekkeriktau namele keya nakko pi tak miza purikki iwaka sa ono. ");
INSERT INTO big_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Keya yereng ngezebekkiraga ngezebekyagawiligurau piyegi koli kelemiya ono. ");
INSERT INTO big_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yongkambanu mele sangkelawiligu piyegi koli kelemiya logo piyegi ngizi panu kumula. Logo piyegi wilekpek ngalege wiyi puwili mabuwiliyegi pugu weik Anotogi yango keya marekngangwili miziweki pangkara yana. ");
INSERT INTO big_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Logo pugu piyegi koli kelemi puwili weik Anotogi yango keya marekngangwili keleya logo purik kazing ngabelakpekkimekki kiriwei ono ma korikwekki keliragi kiriwei ono ma yombanuwiligi keliragi kiriwei ono, kapura Anotogi keliragi kiriwei. Pi ngezebek puwiligi mangobek. ");
INSERT INTO big_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Keya Ngagora Kilisi meibok yombanu keremiza logo ngabelakpekke tenigi tepekke kazing wazonoragimek keya kazing wameiktagimokko kola wizagoma. Keya kozang tenigi Mangobek Anotogo pigi Marek wamenakpekyegi manabokki tonugu pakela. ");
INSERT INTO big_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Weik Yowangu ngago piyegi langaira yongkambanuwiliyegi pelik yei kuna, Pek yombanu nogo ulogo pelik kaiyabok, Nak neyegi kiriwei yawe pugura miziweki wiriyagi logo pi watabi mabiyeng keremizawekkabek legi pi neyaga ngalege panu nak kaiyabok pek, yeiya. ");
INSERT INTO big_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Keya pigi wazonorago kola puraga pugu teni mawiyarekka wazono keleyi mizi. ");
INSERT INTO big_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Purik Anotogo lo tonuguyeng Mosegi melezikke mana logo Mose loyengki mangobek kapura kazing wazonoragimek keya kazing wameiktagimekki mangobek Yisu Kilisi. ");
INSERT INTO big_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nakkorau songono nangezi Anotoyegi pakela ono kapura pigi Marekpokko kele keke pakela, purik pi Mangogi wilekpekke ngezege panu yolubek logo pugu Mangoyegi langai teni mamokyegi kozak yeiya. ");
INSERT INTO big_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Weik Yuda ngaiwiligu yombu Anotogi i walek yemanemakke yongkambanuwiligi yeiktaga Anotoyegi kolak mizi nawili kiling yombu Lebigi ngaimekka i walek yemanemakki yaweyengki saweli mizi nawili Yirusalem yerengka panga Yowanyegi, Ni Kilisibek Anotogo teniyegi wezamelagi kaiyabok ma talik, meiweki wezayela. ");
INSERT INTO big_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Logo Yowan ngagoluk wiziya ono kapura kimeike kawela yeiya. Logo pugu pelik yeiya, Ne Kilisibek Anotogo iniyegi wezamelagi kaiyabok ono, yeiya. ");
INSERT INTO big_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Legi puwiligu ngereke piyegi, Pilik mabura ni tak, Ni Elaya yombanu Anotoyaga ngagoyeng weiya logo kozak kaiya, walaka panu Anotogo paka ngalege korikwek kiling miza orowei kambelabok ngereke yo ma, meiya kapura Yowangu puwiliyegi, Ne pok ono, yeiya. Logo puwiligu piyegi, Ni yombanu Mose kelik Anotoyaga ngagoyeng weiya logo kozak kai tonugu yuke yolubok ma, meiya legi pugu, A’a’, yeiya. ");
INSERT INTO big_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Logo puwiligu piyegi, Teni ngago nugu kaiya puragi kangara teni wezayela puwiliyegi orowei kangki sa mena nugu kumularik ni tak miza purik teniyegi kozak yei keya ni makngezeyegi ni talikpek kai mangai, meiya. ");
INSERT INTO big_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yowangu pelik kanga yeiya to meiya, Ne koka walaka Isaya poropekwiliyaga nakko kapiya walektikke kozak kaiyabok, Yombu nak lewagelagi logo paka kurung yeikwekke wizimowei ngalizi pelik yeiyagi, Yemizibek lewa legi kazing inuguyeng pangka pangka mizizo. Kazing pilikmekke inugu kazing Yemizibekkimek kangkere mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Logo yombanu ngai Palisiwili meiwiligu wezayela puwiligu Yowanyegi pelik nguk meiya, Tamizeige ni Kilisibek Anotogo wezamelagi kaiyabok ono ma ni Elaya Anotogo paka ngalege korikwek kiling miza orowei kambelabok ngereke yo ono ma ni yombanu Mose kelik Anotoyaga ngagora weiya logo kozak kai Anotogo wezamelagi kaiyabok ono mabura ni talikpokko yawe kaimelira mizi, meiya. ");
INSERT INTO big_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Legi Yowangu pelik kanga yeiya to mela, Ne kai yeikpokko kaimeli, kapura yombanu yongkambanubekke liburikki tepekke inugu lusuwei nak wizinda kani. ");
INSERT INTO big_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Logo pi neyegi kiriwei yawe pugura mizagirik mereke keya ne pokyaga kulengke logo nogo kumularik yeik nogora yeik puguraga kulengke panu, keya yeik pugura nogoraga ngalege panu, yeiya. ");
INSERT INTO big_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Logo pilik miza pura yereng kai Yolodang meilingka pangazuwaga Petani meiraga, Yowan yongkambanu kaimelageya wiziyawekke mizara. ");
INSERT INTO big_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wok kalikebekke Yisu Yowanyegi lewarikki Yowangu keriya wizigeya Yowangu pelik kai, Keriyi. Pek liyeng memeng kong pangka panu Anotogo ngabelakpekkiwiligi kaileyeng wezameliweki sawiyamek. ");
INSERT INTO big_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nogo pelik kaiyawekke, Yombanu neyaga ngalege panubek purik pi watabi mabiyeng keremizawekkabek logo neyegi kiriwei yawe pugura miziweki lewagi kaiyabok piyegi kaiya kani. ");
INSERT INTO big_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ne makngezerau pi talik nak miza wiziya kapura ne ini Isileili yongkambanu kaibek kiling kaimeliweki kayima logo pi kimeike pek mizi ngizige piyegi iwakaweki, yeiya. ");
INSERT INTO big_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Keya Yowangu peliktarau kozak yeiya, Nogoriktau pi pek miza ono. Kapura nogo keriyarik paka ngalega Anotogi Kung Walekpek winak Kuwemimimek kelikmek piyegi yerageya logo kanda piyegi yolurikki ne keriya. Logo pulogo pura ne yongkambanuwili kai yeikpokko kaimeliweki wezanelabokko neyegi pelik neiyaragi ne kumula, Nakki ngalege Anotogi Kung Walekpek kanda yolubok pokko yongkambanuwili Anotogi Kung Walekpokko yenge yungke kola wizeibene keleyagi kani, kaiya. ");
INSERT INTO big_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Logo ne puragi kumuli keya pilik mizi yagalege keriyabek logo nogo pelik kai, pek Anotogi Marekpek, yeiya. ");
INSERT INTO big_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Wok kalikebekke Yowan kiling piyegi kiriwei mizi neyau luwe ngagozakka koyilege ");
INSERT INTO big_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yisu kuna. Logo Yowangu pelik yeiya, Keriyi. Pek liyeng memeng kong pangka panu Anotogo sawiyamok kani, yeiya. ");
INSERT INTO big_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yowanyegi kiriwei miziyau Yowangu pilik kairikki kerewiyawekke Yisuyegi kalika kuna. ");
INSERT INTO big_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yisu yongolik meiya logo piyau kiriwei lewarikki keriya wizigeya kowita logo piyauyegi pelik nguk yeiya, Yali talik mizi, yeiya. Legi piyaugu pelik kanga meiya to mela, Rabai, ni talege yolubek, meiya. Logo Rabai mei puragi solorik, Kiriwagabek, kai yagenda. ");
INSERT INTO big_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yisugu pelik yeiya, Keriyi nangaiweki mena koli, yeiya logo piyau pi kiling i pugu yolu pumakke kuna logo piyau pi kiling yokmek mangobektau onorikka koyimeige weik kusa nunung kangmekke. ");
INSERT INTO big_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Enduru yogo Simong Pita meibekke sakpek yaka Yowangu kaiyarikki kerewiya logo Yisuyegi kiriwei kuna piyauyaganak. ");
INSERT INTO big_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Logo pugu mizarik were sibek Simongyegi weliweki kuna logo piyegi pelik meiweki, Togo yaka ngolukku Mesiyabek Anotogo teni yaliya wazayiweki wezamelagi sawiyabok keriya, meiweki. Ngago lang Mesiyabek mei purik ngago yeik Kirikwiligiraga Kilisibek kai yagenda. ");
INSERT INTO big_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pilik miza logo pi Simong Yisuyegi pakeliweki miza orowei kuna. Yisu Simongyegi pakela wizimowei pelik meiya, Ni Simong keya nigi mangobekki yeikta Yowan. Kapura nogo ngereke ni yeik kalogomok nara nanagi logo yeik pura Sipasi mei. Sipasi pura Yudawiligi ngago yeiktaga keya Kirikwiligi ngago yeiktaga Pita mei keya ngago yeik piyau mabiyauge yeik puragi solorik, Kimbek. ");
INSERT INTO big_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wok kalikebekke Yisu paka ngabelak Kalili meibekke kangweki sawiya. Pi Pilipyegi welageyara weik pugu pi yolok ngelawekke, Ne kiling saweliweki kiriwei koli, meiya. ");
INSERT INTO big_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip yogo Enduru yali sibek Pitagi yereng Pesaita mei puragabek. ");
INSERT INTO big_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip pigi sakpek Natanailyegi welageyara pi yolok ngelawekke piyegi pelik meiya, Tonuwago yombanu Mosegi loyengke piyegi langai lende mizi keya Anotogi yombanu Anotoyaga ngagoyeng weiya logo kozak kisa puwiligurau piyegi langai lende mizi mizabok pakela. Yeik pugura Yisu keya pi pongo Nasarete yerengka yombanu Yosep mei nakki marekpek, meiya. ");
INSERT INTO big_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Logo Natanailgu Pilipyegi pelik meiya, Yereng puragawili kaile panuwili logo talik miza logo yombanu wazono panu nak pulaga lewagelaweki. Legi Pilipgu pelik meiya, Pakeli mangine koli, meiya. ");
INSERT INTO big_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yisu Natanail piyegi yawerelege keriyawekke Yisugu piyegi langai pelik kaiya, Pobok Isileili panubek meiyagibokko purik pi pangka panu yolu keya ikuyogorik kai onobek legi, kaiya. ");
INSERT INTO big_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanailgu pelik nguk meiya, Ni talik miza logo neyegi iwaka, meiya. Yisugu pelik kanga meiya to mela, Pilipgu ngago neiyagine nogo ni yengelei Fik mei mereke kulengke wizilegewekke nogo ni keriya, meiya. ");
INSERT INTO big_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanailgu pelik meiya to mela, Kiriwagabek, ni Anotogi Marekpek. Ni teni Isileiliwiligi King Ngaibek, meiya. ");
INSERT INTO big_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yisugu piyegi pelik meiya, Nogo ni yengelei Fik meileige kulengke wizilege pakela nei purikku ni ngizi kumuli. Nugu puraga ngoluk yemane panu nayeng keriyagi. ");
INSERT INTO big_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nogo niyegi nei pura wameiktago. Ni keriyagirik Anotogo paka ngalege lemengki kandik tiyagi logo Anotogi angelawili pakalaga pongo ne yombanu paka ngalega kayimabekyaga logo ngereke paka ngalege kang yongo mizirikki ni keriyagi, meiya. ");
INSERT INTO big_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wok neyau miza logo wok kalikebekke paka ngabelak Kalili meibokko yereng Kana mei puraga yongkambanu neyau wei. Yisugi panumelerau ngeragi kaimizi keya mizageya wizilege, ");
INSERT INTO big_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","keya Yisu kiling pugu waligeleyi puwilirau ngago yeiya logo pulogo koyilege. ");
INSERT INTO big_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yisugi panumele kai waing puwiligu nageya koyabek weik yeikwekke pugu Yisuyegi pelik meiya, Puwili kai waingki yeik, meiya. ");
INSERT INTO big_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pugu pelik meiya to mela, Kali, neyegi mizagiyengki kozak kai wak. Teng negi kozang nogora walimizagira weik pera ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kapura Yisugi panumologo imakke yawe miziwiliyegi pelik yeiya, Pugu iniyegi miziweki kozak yei piyeng mizizo, yeiya. ");
INSERT INTO big_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kaimi unatuba ngai kozang melenazik keya nazikka narayeng pulogo luwe wizilege. Kaimi piyeng Yudawiligu kaimela logo purik puwiligi kangmekke ngeragi nagine keya ngeragi na logo mele keya pulangaiyeng kaigesiyeng. Puwiligu pilik miza purik puwiligu kumularik puwili Anotogi wirege wazonowili miziweki mizarik. Kaimi piyengko kai kebangkela wiziyayengki maktik 20 keleng ma 30 kelengki pangka. ");
INSERT INTO big_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yisugu imakke yawe miziwiliyegi pelik yeiya, Kaimiyengke kai ngabeli, yeiya. Logo puwiligu kaimiyeng wilak sesak ngabela. ");
INSERT INTO big_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pilik miza logo pugu puwiliyegi pelik yeiya, Weik mena nayeng ngabela logo yombanu yemane ngeragi keya kai keya piyengki ngaibekyegi orowei kuni, yeiya. Puwiligu yaka ngeragi keya kai keya piyengki ngaibekyegi orowei kuna ");
INSERT INTO big_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","logo pugu kai yaka Yisugu miza logo waing keremiza pok kolok ula. Waimbek talaga wiriyabek miza purik pi lusuwei kapura imakke yawe mizi yaka kaiyeng ngabela puwili ngezewiligu kele iwaka. Togo pugu mandik yongok weiyagibok ngago meiya, ");
INSERT INTO big_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","logo piyegi pelik meiya, Kazing tonugumekkerik yaka ngago yeiya pilik puwili were waing wazono panu pokka yani logo puwili ngelek na wizigeya kalike waing waze wazono panu ono pilikpokka yani. Kapura nugu waing lewege panubek kalike panu yani, meiya. ");
INSERT INTO big_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Togo Yisu Anoto ngezebokko mizagi langaira Yisugu yereng Kana puraga miza pura pugu yombanu lembekke solo panu kozang pigi paka ngalega mana puragi walimizara. Logo pugu waligeleyi puwiligu ngizi kumularik pi wameik Mesiyabek mena miza. ");
INSERT INTO big_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yongkambanu wei pura weik yeik logo Yisu pongo Kapaneyam yerengke pongologo panu keya sakwili keya pugu waligeleyi puwili kiling kambela logo pulogo wok nayeng wiziya. ");
INSERT INTO big_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pi yolura weik wok Yudawiligu puwili ngabelak Isippekka Anotogo iza orowei wiriya logo puwiligu Pasoba meibok weik mereke logo pi paka Yirusalem wok pok keriyagi lemengke kambela. ");
INSERT INTO big_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pi kanda paka Anotogi i walek yemanemakki yerengke pura yongkambanuwili mabulogo liyeng kau keya liyeng memeng keya winakwiligi pundik keremizageya koyilege keya nawili lalekyengki mogosa wizigeya yombanu nalangaiwiligi king nalangai piyeng Yudawiligi king piyengke kowita to mela logo watabi pulogo piyengka weiweki mizageya koyilege. ");
INSERT INTO big_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Togo Yisu kazing kaile pumokki pakela logo kiyebuk legi pi wizale kozang nak wi nayengka keremiza logo liyeng memengka liyeng kau mabuwili ula yela logo Anotogi i walek yemanemakki yerendikka kazi keya yombanu king nalangai piyeng kowita to melageya koya puwiligi kingyendau kubulagelega wezameli keya lalek keya puwiligi piyeng kowitagelega wezameli kang keya kelemiya. ");
INSERT INTO big_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pugu winakwili wiyiwiliyegi pelik yeiya, Inugu pelege warara yolu piyeng orowei kuni. Pemak negi Mangobekki imak. Pemakke pung inuwagirik keremizi wak, yeiya. ");
INSERT INTO big_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pulaga pugu waligeleyiwili Tawitigu Anotogi Kapiya Walektikke yungke pelik kaiyarikke ngereke kumula, Keli negi Anotogi imak walekmak mizagi pura yemane panu logo purago neyegi ngai, kaiya purikki. ");
INSERT INTO big_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pugu watabi wiyiwiliyegi pilik keleya logo Yuda ngai pulogo koya nawiligu pelik meiya, Ni pilik mizagiweki pangkara warabokko mizi yagenda ma? Mena watabi Anoto ngezebokko mizagi langai pilik nara nugu mize logo tonugu wameik ni pangkara warabek miziweki, meiya. ");
INSERT INTO big_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tegi Yisugu pelik kanga yeiya to mela, Anotogi i walek yemane pemak topela logo nogo wok neyauganakke ngereke ngizagi mena, yeiya. ");
INSERT INTO big_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tegi Yuda ngaiwiligu pelik meiya, Anotogi i walek pemak ngizageya koyimarik kirisimasi yombu neyau keya melenazik keya ingenazikka nak. Logo mabektik tonugu wok panu ngizageya koyima pumak nugu wok neyau keya nakka ngereke ngiziwekirik ni pangka kai yagenda ma, meiya. ");
INSERT INTO big_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kapura Yisugu Anotogi i walek yemanemakki kaiya purik korik pigi puwekki kaiya wizinda, purik korik puguwek Anotogi i walekmak. ");
INSERT INTO big_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pugu puwiliyegi pilik yeiya logo kalik panuge pi ibeng sa logo yangalekta kang miza logowekke pugu waligeleyawili pugu kaiya puragi ngereke kumula to mela logo puwili Anotogi Kapiya Walektikke ngago pura keya Yisugu kaiya puragi ngizi kumula. ");
INSERT INTO big_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yisu paka Yirusalem pulogo Pasobara miziwekke watabi Anoto keya ngezebokko mizagi langai pilik piyeng mizarikku yongkambanu kolokngagono pi Mesiyabek miza logo ngizi kumula. ");
INSERT INTO big_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kapura Yisugu puwiliyegi wameik pi mabok yeiya ono purik pi puwiligu ngizi kumuli puragi wameik mizi yagenda miza ono kopong. ");
INSERT INTO big_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nakkorau piyegi yombanuwiligi kang pumokki kozak meiyagi ono, purik pi yombanuwiligi kumula piyeng iwaka legi. ");
INSERT INTO big_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yombanu yeikta Nikotimas mei nak wizagoma. Pi Palisiwili meiwiliyaga nak keya pi Yudawiligi ngai yemane nak. Yombu Palisiwili meiwili yombu Yuda kangka yemane Mosegi loyeng mabiyengki waberek panu kiriwei mizi keya puwiligi yelibungang kokawiligi ngago yogongyengkirau kozang panu kiriwei mizi miziwili. ");
INSERT INTO big_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nikotimas kusarikke Yisuyegi keriyiweki kayima. Logo pi kanda Yisuyegi pelik meiya, Kiriwagabek, ni teni waligeleyiweki paka Anotoyaga kayima purik ne iwaka. Ne iwaka purik nakkorau waze watabi Anoto ngezebokko mizagi langai nugu mizi pilik piyeng keke mizagi ono, tamizeige Anoto pilik pok kiling yolu keya Anotogo pilik pokyegi saweli miza purik kele, meiya. ");
INSERT INTO big_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Logo Yisugu piyegi pelik meiya, Nogo kozak nei pura wameiktago. Yombu nak wik keremiza ono purik mabura pi Anotogi ngai pugu ngai yolumekki kiliyagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pulaga Nikotimasgu pelik meiya, Kapura talik miza wizigeya yombanu nak wik keremizagi? Yombusi nak ngereke mandik songono sa logo yeke panugi yaga yongola logo panugu ngereke wazamiyagi ono, meiya. ");
INSERT INTO big_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yisugu pelik kanga meiya to mela, Nogo kozak nei pura wameiktago. Yombanu kaibek keya Anotogi Kung Walekpokko miza logo wik keremizabok wamenak kele Anotogi ngai pugu ngai yolumokko kiliyagibek. ");
INSERT INTO big_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Purik kazing korikwekki lewengkerik nakki panu keya mangoyaugu wazami kapura kazing kumbekki lewengkerik Anotogi Kung Walekpokko wazami logo wik keremizi. ");
INSERT INTO big_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nogo niyegi, Ni wik keremizagirikki kai, nei purikki lembek ngeli nagani. ");
INSERT INTO big_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Anotogi Kung Walekpokko nak wik keremizirik kebarekpek kelik. Kebarekpekki ngagora kerewiyi kapura talaga lewa keya tamek neing kang miza purikki ini lusuwei mizi mabilik, yombanu Anotogi Kung Walekpokko kazing kumbekki lewengke wik wizeibene kelemiyabokyegirik pilik mizi. Talik miza logo pilik miza, miza purik teni lusuwei kele kapura kazing kumbekki lewengke pi wik yolu purik kimeike panu, meiya. ");
INSERT INTO big_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Pulaga Nikotimasgu pelik nguk meiya, Talik miza logo pilikki, meiya. ");
INSERT INTO big_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tegi Yisugu pelik kanga meiya to mela, Ni Isileili yongkambanuwiliyegi Anotogi Kapiya Walektikka waligeleyibek, logo waligeleyi yemane nak kapura talik miza logo ni ngoluk nogo kozak kai poburagi langai iwaka panu ono? ");
INSERT INTO big_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nogo kozak nei pura wameiktago. Nogo pakela keya iwaka mizayengki ne iniyegi kozak yei yagenda kapura ini nogo yei piyengki ngizi kumuli ono. ");
INSERT INTO big_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tamizeige ini nogo ngabelakka pelege Anotogo miziyengki langai kozak kairikki ngizi kumuli ono mabura talik miza logo ini nogo paka ngalege Anotogo miziyengki langai kozak kairikki ngizi kumulagi. ");
INSERT INTO big_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nakkorau koka paka ngalege kambela logo yorik paka ngalege lemeng kang tamekke lemeng miza purikki kozak kaiya ono. Kapura ne yombanu paka ngalega kayimabek paka ngalege lemengki iwaka, purik ne paka ngalega pelege kayima logo nogo kozak kai purik pangka. ");
INSERT INTO big_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kumule, koka walaka ngabelak ngaingai kurung yeikwekkepekke Mosego kemale ngayengyengka keremiza namek yengelei wang yokolong naleige wiramiya wazamiya logo luwe lowamiya wazamiya logo kemalemekki pakeli puwili mabuwili ibengki ono. Kazing mabilikmekke ne yombanu paka ngalega kayimabok yengeleileige ngalege ula wazaniweki yengeleilei kiling luwe lowamiya wazaniyagi sa kani. ");
INSERT INTO big_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ne nela logo ibengki, logo neyegi ne Kilisibek miza logo ngizi panu kumuli puwili mabuwili kemenak ibengki ono, kapura wik koyimagira weiweki. ");
INSERT INTO big_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Purik Anotogo ngabelakpekki yongkambanu pewili mabuwiliyegi kela panurikku pugu pigi Marek wamenakpek wezamela, logo piyegi pi Kilisibek miza logo ngizi panu kumuli puwili mabuwili kemenak ibengki ono, kapura wik koyimagira kilingwili miziweki. ");
INSERT INTO big_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kapura Anoto pigi Marekpek ngabelakka pelege yongkambanuwiligi kaileyengki wiyeke ngangang yaniweki wezamela ono, a’a’. Pugu pi wezamela purik yongkambanu mamok kaileyengki ngangang puraga yaliya wazayiweki. ");
INSERT INTO big_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Togo yongkambanu Kilisigu puwili yaliya wazayirikki ngizi panu kumuli puwiliyegirau kemenak ngangang weiyageya koyimagi nara yuke ono. Kapura piyegi ngizi kumuli ono puwiliyegi kele kemenak ngangang weiyagiragi yuke, purik puwili Anotogi Marek wamenakpokyegi ngizi kumula ono legi. ");
INSERT INTO big_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Puwili kemenak ngangang weiyagiragi yuke, purik wilangkarikki mangobek paka ngalegarik ngabelakka kayima kapura puwiligu miziyeng korowali kopong puwili kaileyengki kusabanurikki keli keya wilangkarikki mangobekyegi kiyebuk miza. ");
INSERT INTO big_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Puwili wilangka paka ngalegarikki kiyebuk miza, purik puwili kaile mizagirikki kela kopong. Logo wilangkarikki mangobokko kaile puwiligiyeng kimeike walimiza nelegi puwili pigi wilangkarikka kungke koya. ");
INSERT INTO big_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kapura pangkaraga yolubok wilangkarikki wilik kagowinda kiling lewa purik mamokko pilik pokyegi pi Anotogo pugu miziweki keliragi kiriwei mizi yagenda mizibene, meiya. ");
INSERT INTO big_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pilik miza logo Yisu kiling pugu waligeleyi puwili Yirusalem yerenda wiya, logo ngabelak Yudaya meibekke kai kambela logo pulogo yongkambanu kaimelageyara koyima. ");
INSERT INTO big_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Puwekkerik Yowan kaimelibek ngoluk wigira ono wizigeya. Pi yereng Inong mei, yereng Saling mei puragi mereke puraga yongkambanu piyegi wiriyawili kaimeli, pulogo kai kolokngagono kopong. ");
INSERT INTO big_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Wok nakka Yowan kaimelibokko waligeleyiwili kiling Yuda nak puwiligu kaimeli puragi langai ngalik kela yongomo mizi. ");
INSERT INTO big_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Togo puwili Yowan kaimelibekyegi kanda pelik meiya, Kiriwagabek, yombanu nugu kai Yolodang lingka pangazuwaga wilek ula logo nugu pi Mesiyabek kaibok, pirau yongkambanu kaimeli logo yongkambanuwili pelege lewagirik segeya ngereke panga piyegi kang, meiya. ");
INSERT INTO big_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yowan kaimelibokko pelik yeiya to mela, Yombanu nak kangka Anoto paka ngalege yolubokko manabokko kele yolu logo tak takyaga lewege miza purik Anoto ngezebokko sawiyi. ");
INSERT INTO big_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ini nogo pelik kaiya puragi iwaka, ne Mesiyabek ono. Ne yeik were Mesiya ngizi sawiya, kalika lewabokko kazing leweng keremiziweki kayimabek. ");
INSERT INTO big_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yek tek nangezi yombanu yongok weiweki mizi nakyegi langai kumuli. Yombanu yongokmele weibok yemanebokko, kapura yombubekki kewengkebek yeik luwe kerewiyara yolu logo pi yongok weibokki kiliragi kerewiyi puwekke pi wilik. Nerau mabilik wilik mizi. Logo ne wilik kagowingmokko pangka ono, purik yongkambanuwili Yisuyegi kerewiyi keya kiriwei mizi legi. ");
INSERT INTO big_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yeik pugura yemane si kang keya yeik nogora songono si kang purik yemanerikku, meiya. ");
INSERT INTO big_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Togo pi paka ngalega kayimabek logo pi mamokyaga yemanebek. Purik ngabelakpekkabekki kangka yeik watabi ngabelakpekki piyengki keke iwaka kapura paka ngalega kayimabok mamokyaga ngalege. ");
INSERT INTO big_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pugu pakeli keya kerewiyayengki pi kozak kai kapura nakkorau pugu kozak kai puragi ngizi kumuli ono. ");
INSERT INTO big_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kapura pugu kozak kai piyengki ngizi kumuli puwiligu walimizirik Anoto wameiktago kola. ");
INSERT INTO big_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Purik Anotogo paka ngalega wezamelabok, Anoto ngeze panubekki ngagora kozak kai, purik Anotogo pigi Kung Walekpek kiling Kung Walekpekki kozanda piyegi mabok kemenak mana. ");
INSERT INTO big_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mango Koyambekyegi keli panu, logo watabi mabiyeng ngai puguragi kulengke wiya wazamiya. ");
INSERT INTO big_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Logo Koyambekyegi ngizi panu kumuli puwili weik wik koyimagi pura kiling, kapura pugu kai piyengki nagerewiyi puwili wik koyimagi purarau onogi segeya Anotogi sisikta puwili kiling wiziyagi. ");
INSERT INTO big_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yongkambanuwiligu Yisuyegi kiriweiwili weik kolokngagono si lewa keya weik Yisugu yongkambanu kaimeliwiligu Yowan kaimelibokko kaimeliwiliyaga ngalegerikki kozak kelirikki, yombanu Palisiwili meiwili kerewiya. ");
INSERT INTO big_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yisu ngezebokkorau kaimela ono, mak pugu waligeleyi puwiligu keke kaimeli. ");
INSERT INTO big_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yombanu Palisiwili meiwili pilik puragi kerewiya kairik Yisu iwaka sa logo pi ngabelak Yudayabek wiya logo ngabelak Kalilibekke kandobela. ");
INSERT INTO big_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kazing pongo ngabelak Kalilibekke kang puluweng ngabelak Sameriyabekke libulibu kang. ");
INSERT INTO big_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pi kanda ngabelak Sameriyabekke yereng Saika meiraga lewagela. Yereng pura ngabelak muneng Yakopgu koka pigi marekpek Yosep mana purikki mereke yolura. ");
INSERT INTO big_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pi wei kanda kai kulek yombanuwiligu kai koliweki yokora narikke, logo kai kulek purik, Yakopgi Kai Kulektik, meirik. Yokmek weik yoklongko logo pi yaka kazing koweige lewengke kayimabek kopong pi kai kulektikki ngezege mogosa logo leng miza. ");
INSERT INTO big_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Pugu waligeleyiwili panga yerendaga ngeragi weiweki kuna wizigeya ngezebek wiziya. Pi pulogo mogosara tawizeige pura yongokpanu Sameriya mabuloga namele kai koli penangiweki yawerelege. Togo Yisugu piyegi pelik meiya, Ne kai kabeneng nane, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Logo yongokpanumologo piyegi pelik meiya, Ni Yudabek keya ne Sameriya yongokmele, legi nangki nugu neyegi, Kai kabenembekki nguk nei, meiya. Pugu pilik meiya purik Yudawili keya Sameriyawilirau nakko nakyegi wazono kelemi onowili kopong pilik meiya. ");
INSERT INTO big_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Logo Yisugu pelik kanga meiya to mela, Anotogo watabi ni yeik naniweki mizi piyeng ni lusuwei keya ne niyegi, Kai kabeneng nane, kai pokyegi ni lusuwei. Tamizeige ni iwaka wizigeya nguk neiya kesak nogo ni kai kabeneng wik koyibene keleyi pokka nani kak, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Logo yongokpanumologo pelik meiya, Yemanebek, nirau kai kola wakiyagi nayeng ono pura, keya kaibektau yenge kulaka panu miza pura, ni talaga kai wik koyibene keleyibok ulumi mangai? ");
INSERT INTO big_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Koka walaka Yakop tenigi yeligagangmekkabek keya pigi yango keya marekngangwili keya liyeng keya pigi puwilirau kai kulek perikka nawiligu. Logo puwili ibeng wizigeya kai kulektik tonugu weik weiya. Nugu kai nalik nak yanagi kai purik ni piyaga yemane ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yisugu pelik kanga meiya to mela, Kai kulektikki pokka nibok ngereke kaigi keli penangai ");
INSERT INTO big_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kapura kai nogo manibokka nibok, mawinda kai wikki kelagi ono, a’a’, pi weik wilakki, purik kai nogo manibokko ya puguraga kai kulek yemane wezarik wizagomi penangai, logo kelangki ono, purik kaibokko pi wik wizagomibene kelemiyagi. ");
INSERT INTO big_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Pulaga yongokpanumologorik pi kai kabeneng yeikyengki langai kozak kai nobiyeng piyegi pelik meiya, Yemanebek, ne kaibokka nane logo nerau mawinda kaigi keli onoweki keya pelege kai koli yo mizi onoweki, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yisugu yongokpanumeleyegi pelik meiya, Yombu nugubek miza wari kune, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Legi yongokpanumologo pelik meiya, Ne yombu naktau ono, meiya. Yisugu pelik meiya to mela, Nugu ni yombu naktau ono kai purik ni wameik panu kai yagenda. ");
INSERT INTO big_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ni ulogo yombu melenazik weiya keya yombanu ni kiling weik mabek yolubok nigi kerekpubek ono logo nugu kai pura wameik yagenda, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yongokpanumologo pelik meiya, Yemanebek, ni Anotoyaga ngagora weiya logo kozak kaibek, purik ni nogo miza piyeng mabiyengki iwaka legi. ");
INSERT INTO big_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kapura ne poburikki iwakaweki, Tenigi yeligagangmekkawiligu lewak pobokko kokarik ingeyeng laliya logo Anotoyegi ya kumulageya koyima logo tenirau lewak mabekke pilik mizi kapura taliktikki wiyeke ini Yudawili paka Yirusalem yerengke Anotoyegi ya kumuli mizagi purikki kelegele mizi, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yisugu pelik meiya to mela, Nogo kai peragi ngizi kumulimo. Inugu negi Mangobekyegi lewakpekke pelege ya kumuli mizi pura keya paka Yirusalem ya kumuli mizi puriktau yeikkirik weik mereke, purik wale nakko Anotoyegi ya kumuli mizi purik watabi yemaneyeng ono. ");
INSERT INTO big_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ini Sameriyawili inigu ya kumuli mizibokyegi ini lusuwei, kapura teni Yudawili kele Anoto tonugu ya kumuli mizibokyegi teni iwaka, logo nogo pilik kai purik pangka, purik Anotogo sawiyarik Yudawiliyaga yongkambanuwili kaileyengka yaliya wazayagibek lewagelagi. ");
INSERT INTO big_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wangki keya mabek pewekkeriktau yombanu Peba Anotoyegi kazing ngizimekke ingeyau laliya logo ya kumuli miziweki keli panubok, wilek kang mabiyengka kazing ngizi panu kumbekki lewengke ya kumuli mizagi. Peba Anoto yombanu kazing pilikmekke piyegi ya kumuli mizagiwiliyegi welageya wizinda. ");
INSERT INTO big_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tonugurau Anoto keriyi ono kele kapura pi wizinda purik pi kumbek logo yongkambanu piyegi ingeyau laliya logo ya kumulagi keli puwili wilek kang puwiligi piyeng mabiyengka kazing ngizi panu kumbekki lewengke piyegi ya kumuliweki kani. Kazing pilikmekke puwili pangka ya kumuli mizagi. ");
INSERT INTO big_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yongokpanumologo pelik meiya, Mesiya Kilisi meibok lewagi purik ne iwaka. Pi lewa puwekke watabi mabiyeng pugu teniyegi kozak yeiyagi, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Pulaga Yisugu pelik meiya, Ne pi. Ne ni kiling ngagozakka yolu mabek, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pilik mizi pura Yisugu waligeleyiwili yo, logo pi yongokpanumele kiling ngagozakka yolurikki keriya logo puwili lebuk miza, kapura nakkorau yongokpanumeleyegi, Ni nangaiyengki keli, meiya ono, ma Yisuyegi, Ni nangki pi kiling ngagozakka, meiya ono. ");
INSERT INTO big_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pulaga yongokpanumele kaimi kai koli pugura mabulogo wiya logo panga yerengke kando kuna, logo kanda pangalege yongkambanuwiliyegi pelik yeiya, ");
INSERT INTO big_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Yombanu neyegi lusuweibek kapura nogo ulogo mizayeng mabiyengki neyegi kozak neiyabekyegi pakeliweki mena koli. Pi Kilisibek mane miza mena, yeiya. ");
INSERT INTO big_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Togo puwili yerenda wiya logo Yisuyegi keriyi kuna. ");
INSERT INTO big_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yongokpanumele panga yerendaga wizigeya yombanu Yisugu waligeleyi puwili Yisu ngeragi niweki kelegele keya kelemiyageya koya. ");
INSERT INTO big_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kapura Yisugu pelik kanga yeiya to mela, Nogo ngeragi nalikyeng wara, kapura ini piyengki lusuwei. ");
INSERT INTO big_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Togo Yisugu yombu waligeleyi puwili weik nakko nakyegi pelik mei kang keya mizi, Nakko kanda pi ngeragi nayeng mana ma talik, mei. ");
INSERT INTO big_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tegi Yisugu pelik yeiya, Ne wezanelabokki keliragi kerewiyi keya mizi pura keya yawe nogo miziweki pugu nana pura miza logo weik yeikki purarau ngeragi nogoyeng. ");
INSERT INTO big_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Inugu ngago lang narik pelik mei, Ngong mangobektau ono miza logo purik weik teng ngeragi yokoragira lewagelagi. Tegi ne iniyegi pelik yei, Yongkambanu lewa panga puwiliyegi keriyi. Puwili ngeragi kuk logo weik yokoriweki mizi piyeng kelikwili kani. ");
INSERT INTO big_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Negi wiyeke yongkambanu wawere keleyi puwiliyegi kangara nogo yanagi keya yongkambanu negi wiyeke wawere keleya puwili wik koyimagira weiyagi. Logo pulogo ngago nogora yenge ya puwiligiyengke ngeriyi puwili keya wawere keleyi puwilirau kemenak wilik mizagi. ");
INSERT INTO big_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Logo purik pelik kai purikki pangka, Nakko ngeragiyeng ngeriyi keya nakko ngeragi kuk piyeng yokori. ");
INSERT INTO big_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Purik wameik, purik nawiligu ulogo ngago nogora yongkambanuwiligi yayengke ngeriya logo ini yeik ngago ya puwiligiyengki ngeriya puragi langai waberek kozak yeiyagi logo puwili ngizi kumulibene nogo ini wezayeli. Kazing pilikmekke inugu yongkambanu nogowili wawere keleyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Yongkambanu kolokngagono yongokpanumologi yereng ngabelak Sameriyabokkawili Yisu yombanu Kilisi meibok purikki puwili ngizi kumula, purik yongokpanumologo puwiliyegi, Pi neyegirau iwaka ono kele kapura nogo ulogo mizayeng mabiyeng pugu kozak neiya, yeiya logo purikku puwili Yisuyegi ngizi kumula. ");
INSERT INTO big_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Togo Sameriya yongkambanuwili panga Yisu yolu pulogo kuna logo kanda piyegi pi puwili kiling yereng puwiligiraga tek narik yoluweki piyegi kelegele kelemiya logo pi wok neyau wizagoma. ");
INSERT INTO big_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Keya Yisu ngezebokko kairagi puwili kerewiyarikku pulogo yongkambanu kolokngagono mawinda ngizi kumula. ");
INSERT INTO big_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Logo puwiligu yongokpanumeleyegi pelik meiya, Teni weik ngizi kumuli, kapura purik nugu kaiya maburikki wiyeke ono kapura teni makngezego pi ngago kaiyagalege kerewiya purikku logo tonugu kumulirik wameik pek Kilisi yombanu Anotogo yongkambanu mamok kaileyeng keya ibeng koyimagiraga yaliya wazayiweki mizabek, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yisu Sameriya meibekke pulogo wok neyau miza logo pulumeng wiya wizigeya ngabelak Kalili meibekke kambela. ");
INSERT INTO big_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yisu ngezebokko pelik kaiya, Yombanu Anotogi ngagora kozak kaibok ngabelak kalogomokpekkerik yeikta kiling keya puwiligu ngago pugu kai piyengki ngizi kumuli kapura ngabelak ngezebekkibekkerik yeiktarau ono keya ngezebekyagawili piyegi ngizi kumuli ono, kaiya. ");
INSERT INTO big_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Togo pi kanda pongo ngabelak Kalilibekke lewagelawekkerik yongkambanu pulogowiligu piyegi koli kelemiya, purik puwili paka Yirusalem Pasobaraga koyawekke pugu mizayengki keriya. ");
INSERT INTO big_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yisu ngereke yereng Kana mei, pugu kaibek kowita logo waing keremiza puraga kambela. Keya yereng Kana puragi ngezege yereng Kapaneyam mei pura yolu logo yereng puraga Rom Kapmanbekki ngaiwiliyaga nak yolu logo pigi marekpek kemegememokko pangka ono. ");
INSERT INTO big_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yombanubok Yisu paka Yudayaga kanda weik pongo Kalili lewagela kisirikki kerewiyawekke pi Yisuyegi ngezangai nginda kanda piyegi pigi marekpek weik ibengweki mereke legi yereng Kapaneyam puraga mandikpek yombiyangai wazamiweki kangweki nguk meiya. ");
INSERT INTO big_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yisugu piyegi pelik meiya, Ini nogo watabi nakkorau mizagi langai ono Anotogo keke mizi nayeng keya watabi wirangai ne Anotoyaga kozanda weiyabek mizi nayeng mizirikki keriya logo puwekke kele ini ngizi kumulagi, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kapura Rom Kapman ngaibokko pelik meiya, Yemanebek, negi marekpek ibeng nera panga Kapaneyam kangweki mena koli, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yisugu pelik meiya to mela, Ni kambele. Nigi marekpek wik yolugi mena, meiya. Logo yombanubek Yisugu kairagi ngizi kumula logo kambela. ");
INSERT INTO big_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yombanubek panga igeweki tagoneige piyegi yawe miziwili kanda pi wilek ula, logo puwiligu piyegi pelik meiya, Nigi marekpek weik yombiyangai si kang, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Puwili pilik kisiwekke pugu puwiliyegi pelik nguk yeiya, Yokmek talik wizigeya pi yombiyangai sa, yeiya, legi puwiligu ulogopekke ibengke yokmek nak wizigeya kilili kukuk mizimek yeik, meiya. ");
INSERT INTO big_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Pulaga mandikpekki mangobek Yisugu teng maburaga nigi marekpek wik yolugi mena kambele meiyaragi kumula to mela. Togo pi keya pigi ingembungangwili mabuwili Yisu yombanu Kilisibek meibok purikki puwili ngizi kumula. ");
INSERT INTO big_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Logo pura Yisugu kalike Anotogo keke mizira ngabelak Yudayabek wiya logo kanda ngabelak Kalili meibekke pulogo mizara. ");
INSERT INTO big_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pilik piyeng miza logo waleleige wizigeya Yisu paka Yirusalem yerengke Isileiliwiligi wok yemane ngeragi miza ni piyengka nak lewagela, legi pi kambela. ");
INSERT INTO big_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Paka Yirusalem pulogo kai luwang yemane panu yongkambanuwiligu kaigesi nak yolu. Kai luwambok kang yemane yerendage kiliya lewarikke ngezege, logo kang purikki yeikta, Liyeng Memengwili Kiliya Lewarik, meirik. Keya Iburuwiligi ngago yeiktaga kai luwambokki meirik, Petesara, mei. Keya kai luwambokki ngezege i marek songono melenazik yolu, logo piyengke yongkambanuwili leng mizi. ");
INSERT INTO big_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yongkambanu kolokngagono kemegemeyeng kilingwili i marek songono piyengki yareksara koyilege. Nawili wire kusawili keya nawili inge keya mele kailewili keya nawili korikwekke wale nayeng ibengwili miza logo puwili kaibek urukang mizirik kelegi yuke koyilege. ");
INSERT INTO big_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kang nayengki purik Yemizibekki angela nakko kanda kaibek urukang kelemi. Logo yombanu kaibek urukang mizi ngizige panga kaibekke were kiliyabok kemegeme pugu mizi pumokka yeik si. ");
INSERT INTO big_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Keya yongkambanu pulogo koyawiligi tepekke yombanu kirisimasi yombu nak keya meleyau keya ingenazik keya nazikka neyauganak kemegeme mizageya wizagoma nak wizilege. ");
INSERT INTO big_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yisugu yombanubekyegi keriya logo yombanubek kirisimasi kolokngagono kemegeme wizagoma purik Yisugu iwaka. Togo Yisugu kemegemebekyegi pelik meiya, Ni yombiyangai sagi keli ma talik, meiya. ");
INSERT INTO big_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Logo kemegemebokko pelik kanga meiya to mela, Yemanebek, kaibek urukang mizi puwekke neyegi sawela logo ne nguk namizi panga kaibekke wazaniyagi naktau ono, logo ne makngeze panga kaibekkiweki yelakkelek mizageya purik nak weik yaka were kuna wizigeya wilibek, meiya. ");
INSERT INTO big_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yisugu piyegi pelik meiya, Luwe sa logo yolumek nugurik weiya logo wei kune, meiya. ");
INSERT INTO big_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Logo mabuwekke yombanubek yombiyangai sa logo yolumek pugurik weiya logo kuna. Pilik miza purik Yudawiligi wok yawe mizi onobek wok Sabatpek meibekke pilik miza. ");
INSERT INTO big_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Togo Yuda ngaiwiligu yombanu yombiyangai sabokyegi pelik meiya, Yokopek tenigi wok yawe mizi onobek, wok Sabatpek logo ni yolumek nugurik pilik wara purik yawe mizi yagenda, logo purik lo tonuguragirik ni kaile mizi yagenda, meiya. ");
INSERT INTO big_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Logo pugu pelik yeiya, Yombanu ne yombiyangai wazaniyabokko neyegi yolumek nugurik weiya logo wei kune neiya, yeiya. ");
INSERT INTO big_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pilik kai legi puwiligu piyegi pelik nguk meiya, Yombanu niyegi pilik neiyabok tak, meiya. ");
INSERT INTO big_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kapura yombanubek takko pi yombiyangai wazamiya miza purik pi lusuwei purik pilik mizawekkerik yongkambanu kolokngagono koya logo Yisu sengekta kuna. ");
INSERT INTO big_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Waleleige Yisugu Anotogi i walek yemanemakke yombanu pugu yombiyangai wazamiyabok wilek ula logo Yisugu piyegi pelik meiya, Keriye. Ni weik yombiyangai sa mena ni ngereke watabi kaile panu nayeng niyegi wiriya nera nugu kaile mizi piyeng weik wiyagirikki kai, meiya. ");
INSERT INTO big_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yisugu pilik meiyawekke yombanubek Yisu wezamiya logo pi kanda Yuda ngaiwiliyegi yombanu ne yombiyangai sibene keleniyabok Yisu, yeiya. ");
INSERT INTO big_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Togo Yisu Yudawiligi wok yawe mizi onobekke yombanu yombiyangai wazayirikki wiyeke weik Yuda ngaiwili pi kuneng mana logo uliweki kozak kela. ");
INSERT INTO big_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kapura Yisugu puwiliyegi pelik yeiya, Negi Mangobek ngoluk yawe mizageya, logo purikki wiyeke nerau yawe mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Keya pugu Anoto pigi Mangobek kairikki wiyeke puwili weik pi ulagi puragi mawiyarekka kozang panu mizi. Purik pi wok yawe mizi onobokki lora keke ngela ono kapura pi Anoto pigi Mangobek kai logo purikku pi keya Anotorau pangka pangka mizi legi puwili pi uliweki mizi. ");
INSERT INTO big_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Puwiligu sisik mizi puragi pi iwaka logo pugu pelik yeiya, Nogo kozak yei pura wameiktago. Ne Koyambokkorau watabi nayeng keke mizagi ono, ne Anoto negi Mangobokko miziyengki keriya logo ne piyeng keke mizi, purik watabi Anoto negi Mangobokko mizi piyeng ne Koyambokkorau mizi mizi. ");
INSERT INTO big_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Purik Anoto negi Mangobek ne pigi Marekpekyegi keli logo pugu mizi piyeng mabiyeng neyegi walimizi keya piyengka yemane panuyeng walimizagi logo nogo piyeng mizagi logo ini lelengkiragi. ");
INSERT INTO big_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Anoto, negi Mangobokko ibengwili ibendaga wik yangalekta wazayi mabilik nogorau wik koyimagira yanagi keli pilik puwiliyegi wik koyimagira yani. ");
INSERT INTO big_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Negi Mangobokkorau yongkambanuwili kaile puwiligiyengki wiyeke keleyagiyeng kozak kai ono, purik pilik yawe mizagi pura pugu ne pigi Marekpekki melezikke wiya. ");
INSERT INTO big_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Pugu pilik miza purik yongkambanuwiligu yeik pugura yongolok mei pilik yeik nogorarau yongolok meiweki. Pi ne wezanelabek, legi yongkambanu ne pigi Marekpekki yeikta yongolok mei ono puwili, negi Mangobekki yeiktarau yongolok mei yagenda ono. ");
INSERT INTO big_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nogo kozak yei pura wameiktago. Yongkambanu ngago nogoragi kerewiya logo ne wezanelabokyegi ngizi kumuli puwili weik wik koyimagi pura kiling. Puwili kaile puwiligiyengki wiyeke puwili kemenak ngangang weiyagiragi yuke ono, purik kazing Anotoyegi kumbekki leweng ibendaga panga kazing Anotoyegi kumbekki leweng wikkiraga nogo kowita. ");
INSERT INTO big_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nogo kozak yei pura wameiktago. Teng yongkambanu kazing kumbekki lewengke ibeng puwiligu ne Anotogi Marekpekki ngagoragi kerewiyagirik weik lewagela. Logo ngago nogoragi ngizi kumuli puwili kazing kumbekki lewengke wik wizagomagi. ");
INSERT INTO big_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Purik negi Mangobek kazing kumbekki lewengki wik wizagomagiragi mangobek mizi mabilik pugu ne pigi Marekpek kazing kumbekki lewengke wik wizagomagiragi mangobek keleniya. ");
INSERT INTO big_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Keya pugu ne yongkambanuwili ngagozak keleyagiweki pangkara nana kai, purik ne yombanu paka ngalega kayimabek legi. ");
INSERT INTO big_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nogo yongkambanuwiligi wilek kangyeng wik wazayi purikki ini lebuk mizi nagani. Purik kalike wok nakka yongkambanu ibeng logo waliya puwili mabuwili ngago nogoragi kerewiyi nangai ");
INSERT INTO big_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","logo ngereke yangalek meiyagi. Ne ngago kai puwekkerik kazing Anotogo kelimekke wiziya logo ibembok paka ngalege wik wizagomiweki yangalekta wazamiyagi kapura kazing Anotogo kiyebuk mizimekke wiziya logo ibembok kemenak ngangang weiyagiragi yangalekta wazamiyagi. ");
INSERT INTO big_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nogorau watabi nayeng keke mizagi ono. Ne Anotogo kozak nei puragi kiriwei yongkambanuwili ngagozak keleyi. Nogo kazing ngagozak keleyimok pangkamekke purik ne, ne makngezego keliragi mizi ono, ne negi Mango ne wezanelabokko keli pura keke mizi. ");
INSERT INTO big_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tamizeige nogo keke ne makngezeyegi langai ne tak miza purikki kai kesak inugu ngaigu kai kisi purik pangka. ");
INSERT INTO big_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kapura negi Mangobektau wizinda. Pi ne tak miza purik kozak kaiyageya wizinda keya pugu neyegi langai kozak kai piyeng wameikyeng purik ne iwaka. ");
INSERT INTO big_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Inugu nawili neyegi langai Yowan kaimelibekyegi nguk meiweki wezayela logo Yowan kaimelibokko ngago neyegi langai kozak kaiya piyeng wameik. ");
INSERT INTO big_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yongkambanuwiligu kozak kisi piyeng neyegi yemaneyeng ono. Ne yeik Yowan kaimelibokko iniyegi ngago kozak yeiya piyengki keke kai yagenda, purik ini ngago piyengki ngizi kumula logo ini yaliya wazayagi purikki ne keli. ");
INSERT INTO big_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yowan kaimelibek lang wezarik wizimowei iniyegi ngaiwak wiyageya wiziya. Logo pugu ini ngaiwaktik yanageya wiziyawekkerik ini tek nangezige wilik miza. ");
INSERT INTO big_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Watabi yeik nogora kawela wiyagi nayeng ngoluk wizinda. Logo piyeng Yowan kaimelibokko kozak kai puraga ngalegeyeng logo piyeng yawe nogora keya piyeng yawe negi Mangobokko miziweki nanara logo purago iniyegi ne negi Mangobokko wezanelabek keleyiweki. ");
INSERT INTO big_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Keya negi Mango ne wezanelabokko kairik ne pigi Marekpek kai. Inugurau pi ngago kaiyagalege kerewiya ono keya inugurau pi keriya ono, ");
INSERT INTO big_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ma negi Mangobekki ngagora inugu ya inuguyengke wara ono logo pugu ne wezanela kele kapura ini neyegi ngizi kumuli ono. ");
INSERT INTO big_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Inugurik Kapiya Walektikku ini wik koyimagira weiyagirikki waligeleyagi nobiyeng ini Kapiya Walektik waberek panu mei kapura Kapiya Walektikku kozak kaibok neyegi langai kozak kai yagenda. ");
INSERT INTO big_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kapura ini wik koyimagira weiweki neyegi ngizi kumulagirikki kiyebuk mizi. ");
INSERT INTO big_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ne yombanuwiligu yeik nogora yongolok meiyagi purikki weli ono, ");
INSERT INTO big_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","purik ya inuguyengki kazingmek nogo iwaka. Inirau Anotoyegi keli ono. ");
INSERT INTO big_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ne negi Mangobokki yeiktage pugu kairagi kiriwei iniyegi kayima kapura ini neyegi ngizi kumuli ono. Kapura tamizeige iniyaga nakko kanda ngago ngezebekki nayeng kozak kai purik ini piyegi ngizi kumuli. ");
INSERT INTO big_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Inirau neyegi ngizi kumulagi langai ono, purik iniyegi langai nazuwaga nakko wazono kaiyagirikki ini kumuli kapura ini Anoto wamenakpokko iniyegi langai wazono kaiyagi purikkirau ini kumuli ono. ");
INSERT INTO big_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kapura nogo piliktikki wiyeke negi Mangobekyegi iniyegi langai melebek yowagi ono, pilik mizagibek Mose. Mose iniyegi sawelagi nobiyeng inugu ngai yuke yolubokko piliktikki wiyeke iniyegi melebek yowi penangai. ");
INSERT INTO big_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosego lende miza piyeng neyegi langai lende miza. Togo tamizeige ini puwekke ngago pugu lende miza piyengki ngizi kumula kesak ini ngago nogoragirau ngizi kumuli kak. ");
INSERT INTO big_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Logo ini Mosego lende miza piyengki ngizi kumula ono legi ini nogo kozak yei piyengki ngizi kumulagi ono. ");
INSERT INTO big_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ngago piyeng kaiya logo pulaga Yisu kai kolamiya yeik Kalili keya Taibiriya piyau meibekke lalu pangazuwagawekkeweki wangleige kuna. ");
INSERT INTO big_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","4","Yisu panga pulogo kanda logo pi kiling pugu waligeleyiwili weik lewak marek nakka yabela logo paka luwege puwili mabuwili mogosa. Logo puwekkerik yongkambanu kolokngagono paka Yirusalem kuna, purik Yudawiligi wok koka walaka Anotogo Yudawili Isipwiliyaga yaliya wazayarikki kumula logo ngeragi yemane miza nibek Pasoba meibok weik mereke logo puwili Yisuyegi kiriwei kai kang wiriya, purik puwiligu keriyarik pugu watabi Anotogo keke miziyeng miza logo kemegemewili yombiyangai sa wazayarikki keriya kopong. ");
INSERT INTO big_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yisu mogosara wizimowei pongologo langai keriya logo yongkambanu kolokngagonomek lewarikki keriya logo Pilipyegi pelik meiya, Teni talaga ngeragi nayeng pewili nibene wei kangki, meiya. ");
INSERT INTO big_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yisugu ngezebokko mizagirik pi iwaka kapura pura pugu Pilipyegi yang kelemibene pilik meiya. ");
INSERT INTO big_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Logo Pilipgu pelik kanga meiya to mela, Nakko wok andet neyaugi yawe miza piyengki ngane king weiya piyengkorau ngeragi pewiliyaga nak nak nangezi niweki keremungke weiyagi langai ono, meiya. ");
INSERT INTO big_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pilik kai ngizige Enduru, Simong Pita meibokki sakpek logo Yisugu waligeleyi puwiliyaga nakko Yisuyegi pelik mei, ");
INSERT INTO big_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Mandik nak pelege. Pi perek marek songono melenazik paliyeng meiyengka keremiza nayeng keya watabisi waliya neyaurau wara kapura piyeng yongkambanu mabuwiligi pangka ono, kai. ");
INSERT INTO big_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Pi pilik kaiwekke Yisugu pugu waligeleyiwiliyegi, Yongkambanuwili mogosi yei, yeiya logo puwiligu yeiya wizigeya yengelik wazonobek logo yongkambanuwili mogosa. Yombuwili keke sangkelarik tausen melenazik tikinda. ");
INSERT INTO big_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pulaga Yisu perek melenazik yaka piyeng weiya logo Anotoyegi perekyengki langai wazono meiya. Pulaga pugu waligeleyiwiliyegi yana logo puwiligu mogosa puwiliyegi sanga mizagelega yana logo yongkambanuwili keli puwiligiyengke na. Pulaga Yisugu watabisiyaugerau mabilik miza logo puwili na logo ");
INSERT INTO big_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ngekyengko wizigeya weik Yisugu pugu waligeleyiwiliyegi pelik yeiya, Ngeragi waleyeng wiyi purik wezamelagi sa mena waleyeng menalege weiya logo wiyi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Togo Yisugu waligeleyiwili ngeragi wale wazono ni ono piyeng weiya logo perek melenazik yaka na piyengka kik meleyau keya pongo ingenazikka neyau piyeng mereng miza. ");
INSERT INTO big_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yongkambanu pulogo koyawili Yisugu Anotogo keke mizara miza purikki keriya logo pelik kisa, Wameik, pek yombanu Anotoyaga ngagora weiya logo kozak kai, Anotogo teni yongkambanu ngabelakpekkiwili yaliya wazayiweki wezamelagi kaiya logo tonugu yuke yolubok mena, kisa. ");
INSERT INTO big_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yisu weik yongkambanuwiligu miza orowei logo puwiligi King Ngaibek keremiziweki mizi purik pi iwaka, legi pi ngereke ngezebek keke panga lewak nakka kuna, pi puwiligi keliragi kiyebuk kopong. ");
INSERT INTO big_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Weik kusaweki miziwekke Yisugu waligeleyiwili pongo kai kolamiyabekke kerelege kuna. ");
INSERT INTO big_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kapura Yisu lewa ono wizigeya weik kusa logo Yisugu waligeleyiwili wang naleige tameneng meiya logo mogosa logo panga yereng Kapaneyam meiragiweki kuna. ");
INSERT INTO big_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pilik mizi pura kebarek yemane nak uli keya kailauriktau yemane lewa. ");
INSERT INTO big_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Puwili weik tek narik kuna wizigeya Yisugu waligeleyiwiligu Yisu wangleigiweki kaibekke ngalengale yawerelege keriya logo puwili kulili miza. ");
INSERT INTO big_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Puwili kazi legi Yisugu pelik yeiya, Ne mena kulili mizi wak, yeiya. ");
INSERT INTO big_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Togo puwili wilik miza logo wangleige ngalege koli kelemiya logo mabuwekke pilik mizi pura wanglei weik puwiligu yereng yaka kang puragi kaibekke kerelemekke lewagela. ");
INSERT INTO big_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wok kalikebekke yongkambanu wale pangaleige wezaya puwili ulogorik wang wamenaklei logo wang puleige Yisugu waligeleyiwili kunawekkerik Yisurau kuna ono mamiza. ");
INSERT INTO big_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kapura yereng Taibiriya meiraga wang nayeng wiriya logo wangyeng ulogo Yisugu ngeragiyengki langai Anotoyegi wazono meiya logo yongkambanuwiligu ngeragi na pulumengki ngezege wila wiya. ");
INSERT INTO big_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yongkambanuwili Yisurau ono keya pugu waligeleyiwilirau ono mamiza, legi wang piyengki ngalege sa logo panga Kapaneyam yerengke Yisuyegi weliweki kuna. ");
INSERT INTO big_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pangazuwaga pura Yisu wizilege puwiligu pakela, logo piyegi puwiligu pelik meiya, Kiriwagabek, ni talikwekke wiriya, meiya. ");
INSERT INTO big_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Logo Yisugu puwiliyegi pelik yeiya, Nogo kozak yei pura wameiktago. Ini nogo Anotogo keke miziyeng mizarikki keriya kopong ini neyegi weli yagenda ono, ini ngeragi nogo yana piyeng na logo ngekyengko kopong ini neyegi weli yagenda. ");
INSERT INTO big_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Inugu ngeragi ni piyeng weiweki yawe kozang panu mizi nagani, purik piyeng nguk namizi na logo purik weik yeik siyeng kani, segeya ngeragi ini wik koyimiweki keleyi piyengka kele niweki yawe kozang mizi. Ngeragi pilik piyeng ne yombanu paka ngalega kayimabokko yaniyeng. Negi Mangobek Anotogo neyegi kozang ngeragi piyeng yanagira nana, yeiya. ");
INSERT INTO big_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Togo puwiligu piyegi pelik nguk meiya, Teni Anotogi yawera kang tamekke miza logo ngeragi piyeng weiyagi, meiya. ");
INSERT INTO big_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tegi Yisugu pelik kanga yeiya, Anotogi yawe inugu mizagira ne Anotogo wezanelabokyegi ngizi kumulagi pura, yeiya. ");
INSERT INTO big_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Legi puwiligu pelik nguk meiya, Watabi Anotogo keke mizi talikyeng nugu miza logo teni keriya wizigeya ni Anotoyaga kayimabektikki teni ngizi kumulagi? ");
INSERT INTO big_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mosego miza pilikta nugurau mizagi? Mosego Anotogo keke mizi nara miza logo paka ngalega ngeragiyeng wirageya logo tenigi yelibungang walakawili ngeragi Manayeng meiyeng ngabelak kurung yeikwekkepekke koyimawekke na, mabilik Anotogi Kapiya Walektikke pobilik lende miza pelik, Paka ngalega ngeragi wezamela logo puwili na, meiya. ");
INSERT INTO big_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yisugu pelik yeiya, Nogo kozak yei pura wameiktago, Mosego ini yana piyeng ngeragi ngizi paka ngalegayeng ono. Mosego Mana piyeng yana, kapura Mana piyengko wik koyimagira yana ono. ");
INSERT INTO big_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kapura mabek pewekke negi Mangobokko ini ngeragi ngizi paka ngalegayeng yanagi, logo ngeragi Anotoyaga piyeng yombanu paka ngalega kayimabok, keya mabok yongkambanu ngabelakpekkiwiliyegi wik koyimagira yanibok, yeiya. ");
INSERT INTO big_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Pulaga puwiligu pelik meiya, Yemizibek, ngeragi nugu kozak kai piyeng wok mabiyeng teni yane, meiya. ");
INSERT INTO big_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Logo Yisugu puwiliyegi pelik yeiya, Ngeragi wik koyimagira yanagi piyeng ne. Ngeragiyengko korik inuguyeng wik koyibene keleyi mabilik nogo yongkambanuwili kazing kumbekki lewengke wik koyibene keleyi. Ini ngeragi korikwekkiyeng ni kele kapura ini ngoluk yagasi mizagi keya ngaba kangyeng kelakkelak logo mawiyarekka kai wik nagi. Kapura nak ne kiling saweliweki lewa keya wilekpek neyegi ngalege wiyi mizibok mabura pok watabiyengkirau mawiyarekka welagi ono. ");
INSERT INTO big_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kapura nogo iniyegi ne tak miza purikki kimeike kozak yeiya keya ini nogo miziyengki pakela kele kapura ini ngago nogoragi ngizi kumuli ono. ");
INSERT INTO big_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yongkambanu negi Mangobokko neyegi nani puwili nogowili. Yongkambanu neyegiweki mizi puwili nogo wezayelagi ono segeya nogo koli keleyagi. ");
INSERT INTO big_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ne paka ngalege lemeng wiya logo ngabelakka kayima purik ne makngezegi kelira miziweki ne kayima ono, ne wezanelabokki kelira miziweki kayima. ");
INSERT INTO big_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ne wezanelabokko kelirik pugu yongkambanu nana puwili mabuwiliyaga nak kemenak ibengki purikki pi kiyebuk, kapura wok kalik panubekke ne yo pilikwekke nogo puwili ibendaga yangalekta wazayagi purikki pi keli. ");
INSERT INTO big_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Negi Mangobokko kelira pelik, Ne Anotogi Marekpek kiling saweliweki lewa keya neyegi wilekpek ngalege wiyi puwili mabuwili wik koyimagira kiling koyimagi, keya wok kalik panu ne ngereke yogibokkowekke nogo puwili ibendaga yangalekta wazayagi. ");
INSERT INTO big_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yudawiligi ngaiwili ngago puragi kerewiyawekke puwili weik sisik miza logo munumunu mei kang, purik Yisugu pelik yeirikki wiyeke, Ne ngeragi paka ngalega kayima piyeng. ");
INSERT INTO big_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Puwiligu pelik kisa, Yisu pobok Yosepgi marek mabok ma? Teni pigi panu keya mangoyauyegi iwaka, logo nangki pi ngereke teniyegi pi paka ngalega kayimabek kai, kisa. ");
INSERT INTO big_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Togo Yisugu pelik kozak yeiya, Ini makngezegi tepekke munumunu mei kang keya mizi wak. ");
INSERT INTO big_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nak ngezebokko keliraga ne kiling saweliweki wiriyagi ono, a’a’, kapura segeya negi Mango ne wezanelabokko nak wiriyibene kelemi purik mabura pilikpok ne kiling saweliweki wiriyagi keya wok kalik panu ne ngereke yobokkowekke, nogo pi ibendaga yangalekta wazamiyagi. ");
INSERT INTO big_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yombanu Anotoyaga ngagora weiya logo kozak kaibokko koka panu pelik lende miza, Anotogo mabuwili waligeleyagi. Tegi negi Mangobekki ngagoragi kerewiya logo purago waligeleyibene mizi puwili mabuwili ne kiling saweliweki wiriyagi. ");
INSERT INTO big_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nogo kai purik nakko negi Mangobek keriyarikki ne kai ono, kapura ne Anotoyaga kayimabek legi ne wamenakko kele pi pakela. ");
INSERT INTO big_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nogo kozak yei pura wameiktago. Neyegi ngizi panu kumulibok wik wizagomagi pura kiling. ");
INSERT INTO big_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ne ngeragi yombanuwili kazing kumbekki lewengke wik koyimiweki keleyiyeng. ");
INSERT INTO big_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ngabelak kurung yeikwekkebekke tenigi yelibungang walakawili koyawekke, puwili ngeragi paka ngalega kayimayeng logo Manayeng meiyeng na kapura puwili wik koyima ono segeya puwili kalike ibeng sa. ");
INSERT INTO big_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kapura ne ngeragi nalik paka ngalega kayimayengki kozak kai logo piyengka niboktau kemenak ibengki ono. ");
INSERT INTO big_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ne ngeragi yombanuwili kazing kumbekki lewengke wik koyimibene paka ngalega kayima piyeng. Ngeragi piyeng nibok wik wizagomagi. Korik nogowek ngeragi wezayeng logo nogo korik nogowek ibengkiweki managi logo ini ngabelakpekke yolu puwili wik koyimagiweki, yeiya. ");
INSERT INTO big_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Puragi kerewiya logo Yudawili ngezewiligi tepekke ngago si kela yongomo mizi logo pelik mei, Talik miza logo yombanubekki korikwek teni ngeragi wezayeng niweki yanagi, kisi. ");
INSERT INTO big_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yisugu pelik yeiya, Nogo iniyegi yei pura wameiktago. Ini ne yombanu paka ngalega kayimabekki korikwek keya iwi nogobektau inugu ngeragi ni keya kai wik ni pilik ni ono mabura inigi yungke ngizi wik yolu nararau ono, yeiya. ");
INSERT INTO big_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yombanu korik nogowek ngeragi wezayeng ni mizibok keya iwi nogobek kai wik wezabek ni mizibok wik wizagomagi pura kiling. Keya nogo wok kalik panu ne yobokkowekke pilik pok ibendaga yangalekta wazamiyagi. ");
INSERT INTO big_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Korik nogowek ngeragi ngiziyeng kelik keya iwi nogobek kai wik panubek kelik. ");
INSERT INTO big_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Korik nogowek ngeragi wezayeng ni keya iwi nogobek kai wik wezabek ni mizibok negi yungke wizinda keya ne pigi yungke wizinda. ");
INSERT INTO big_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Negi Mango ne wezanelabokko yongkambanuwili wik koyimiweki keleyi logo pugu ne wik yoluweki keleni, logo kazing mabilikmekke nak ngeragiyeng yenge yaga niwekke wezameli pilik ne pigi yungke wezanelibok, nogo kazing kumbekki lewengke wik wizagomibene kelemiyagi. ");
INSERT INTO big_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ne iniyegi ne makngezeyegi langai ne ngeragi nalik paka ngalega kayimayeng kani yei. Ngeragi nogo kozak kai piyeng inigi yelibungang walakawiligu koka na logo Manayeng mei piyeng kelik onoyeng. Puwili piyeng na kele kapura puwili paka ngalege wik koyimagira weiya ono. Kapura ngeragiyengko mizagewiyege korikwek wik yolu mabilik ne ngeragi wezayeng pigi yungke wezanelibok nogo mizagewiyege pi kazing kumbekki lewengke wik wizagomagi. ");
INSERT INTO big_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yisugu peyeng yongkambanuwiliyegi Kapaneyam yerengke Yudawiligi i walek songonomakki yungke waligeleya. ");
INSERT INTO big_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pulaga pugu waligeleyageya koya puwiliyaga kolokngagono puragi kerewiyawiligu pelik kisa, Teni ngago peragi kiyebuk. Takko pilik mizagi, kisa. ");
INSERT INTO big_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Puwili Yisugu ngago kaiyayengki puwili munumunu mei purik pi iwaka, logo pugu puwiliyegi pelik nguk yeiya, Ini ngago puragi sisik ma talik? ");
INSERT INTO big_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tamizeige ne yombanu paka ngalega kayimabek paka ngalege yongo yabeleilege ini keriyawekkerik ini sisik mizagi ma talik? ");
INSERT INTO big_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anotogi Kung Walekpokko yombanubekki kumbek kazing kumbekki lewengke Anotoyegi wik wizagomiweki kelemi. Yombanubekki korikwekko ma korik puguwekki kozandago pi kazing Anotoyegi kumbekki lewengke wik wizagomiweki kelemiyagi ono. Ngago nogo kozak kai piyeng wilek kang inuguyengki wiyagiyeng logo piyengki ngizi kumulirikku ini kazing kumbekki lewengke wik koyimagi pura kiling. ");
INSERT INTO big_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kapura iniyaga nawili ngoluk ngago nogo kozak kai piyengki ngizi kumuli ono. Yisugu pilik kaiya purik pi ulogo solo mabuwekke, tak piyegi ngizi kumuli ono keya takko pi yombanu ulagiwiliyegi miza yanagi mizaboktau pugu iwaka. ");
INSERT INTO big_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Keya Yisugurau pelik yeiya, Piliktikki wiyeke ne iniyegi pelik yei, Negi Mangobokko wiriyibene keleyi puwili keke neyegi wiriyagi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Logo pulagarik piyegi kiriwei wiriyawiliyaga kolokngagono weik pi wezami kai kanda logo piyegi mawinda kiriwei mizi ono. ");
INSERT INTO big_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Puwili yagoneiga Yisugu meleyau keya pongo ingenazikka neyau waligeleyiwiliyegi pelik yeiya, Inirau ne wezaniya logo pilik kuniweki keli ma talik, yeiya. ");
INSERT INTO big_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Legi Simong Pitago pelik meiya, Yemizibek, tonugu kiriwei mizagi naktau wizinda ono. Ni wamenakko teniyegi ngago teniyegi kazing wik koyimagimek waligeleyagi pura kozak yei. ");
INSERT INTO big_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Logo teni weik ngizi kumuli keya ni kaile nayendau ono Anotoyaga teniyegi kayimabek purik teni iwaka, meiya. ");
INSERT INTO big_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Logo Yisugu pelik yeiya, Nogo ini meleyau keya pongo ingenazikka neyau puwili iza kapura iniyaga nak Sadangkibek, yeiya. ");
INSERT INTO big_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yisugu pilik kaiya purik Yuras yogo Simong Isaliyotogi marek Yisu ulagiwiliyegi miza yanabokyegi langai kaiya. ");
INSERT INTO big_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pilik miza wizigeya Yisu ngabelak libu kunimowei ngabelak Kalilibekke yongkambanuwili waligeleyi kang keya miza. Pi ngabelak Yudayabekke kunagirikki kiyebuk miza, purik Yudawiligi ngaiwili kang tamekke pi ulagi miza purikki kozak keli legi. ");
INSERT INTO big_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Weik wok Yudawiligu i yagongyeng paka Yirusalem keremiziyeng, logo Wok Yemane Sela I Walekmakkiyeng meiyeng mereke. Puwili wok melenazik keya nazikka neyauganakka i piyengki koyimowei purik koka puwiligi yelibungangwiligu kurung yeikwekke kirisimasi yombu neyau sela iyengki koyarikki kumulageya. ");
INSERT INTO big_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Wok piyeng weik mereke legi Yisugi sakwiligu piyegi pelik meiya, Pelaga yolu wak. Paka ngabelak Yudayabekke kambele, logo nugu miziyengki yombanu niyegi kiriwei pakalege yolu puwiligurau keriyiweki. ");
INSERT INTO big_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Purik yongkambanu mamokko piyeng iwaka sibene miziboktau watabiyeng liwik liwik mizi onobokko. Tamizeige nugu mizi piyeng wameikyeng mabura yongkambanu mamokki wirege mize, meiya. ");
INSERT INTO big_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pigi sakwiligu pilik kisa purik puwilirau pugu pi pilikpok yeirikki ngoluk piyegi ngizi panu kumula ono kopong puwili pilik kisa. ");
INSERT INTO big_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tegi Yisugu puwiliyegi pelik yeiya, Teng nogo mamokyegi nogo miziyeng waligeleyagira ngoluk lewagela ono kapura iniyegirik ini wok yawe inuguyeng mizagi nakki ini yuke ono. ");
INSERT INTO big_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Keya ngabelakpekke yongkambanu Anotoyegi kerewiyi ono puwili iniyegi kumbak mizi ono, kapura puwili neyegi kumbak mizi purik nogo puwiliyegi puwili kaile mizi kani keleyirikki wiyeke. ");
INSERT INTO big_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ini yaka ngeragi yemane miza ni pulogo kuni. Ne waze kangki ono, purik wok negi kangkibek ngoluk lewagela ono. ");
INSERT INTO big_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pi puwiliyegi pilik yeiya logo weik wizigeya pi Kalili mabulogo mawinda wok nayendau wizagoma. ");
INSERT INTO big_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Logo pigi sakwili paka Yirusalem yerengke ngeragi yemane miza ni puraga kambela, logo pirau kalika kambela. Pi nawili kilindau kambela ono, yeik ngezebek naleweng nangai liwik kambela. ");
INSERT INTO big_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Logo ngeragi yemane miza ni puragarik Yuda ngaiwili piyegi welageya koya. Puwili mawiyarekka pelik nguk kisageya koya, Yombanu Yisu pok, talege, kisageya koya. ");
INSERT INTO big_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Keya yongkambanu kolokngagono piyegi langai munumunu ngago kelageya koya. Nawili pelik meiyageya, Pi yombanu wazonobek, mei keya nawili pelik meiyageya, Yombanubok kaile. Pi yeik yongkambanuwili ikuyogorik keleyi yagenda, mei. ");
INSERT INTO big_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Keya yongkambanuwili Yuda ngaiwiliyegi kazi kopong puwili Yisuyegi langai ngago ngezege kelageya koya. ");
INSERT INTO big_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Logo ngeragi yemane miza ni puragi libulibu wok mangobektau onobekke Yisu luweza logo paka Anotogi i walek yemanemakke kuna logo pulogo Anotogi ngagora yana. ");
INSERT INTO big_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yuda ngaiwili lelengkira logo pelik kisi, Yombanubek tonugu kapiya miza pilik Yudawiligi kapiya yemaneyengki kapiya miza onobek kapura talik miza logo pi piyengki iwaka panu, kisa. ");
INSERT INTO big_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Logo Yisugu pelik kanga yeiya, Nogo kozak kai piyeng yeik kumuli ne makngezegiragayeng ono, piyeng ngago ne wezanelabokkiyeng. ");
INSERT INTO big_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Logo yongkambanu Anotogi keliragi miziweki mizi logo mizi puwiligu keke purikki iwakagi, purik nogo kozak kai pera Anotogi ngagora ma yeik miza purik puwiligu iwakagi. Keya ngago ne makngezegi kangkabekkarago kozak kai yagenda ma yeik miza purik puwiligu iwakagi. ");
INSERT INTO big_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yombanu ngezebokko kumulayengka kozak kaibok, yeik ngezebekkira yongolok meiweki ngaigu mizi yagenda kapura yombu pi wezamelabekki yeikta yongolok meiweki kelibok ngaigu kai onobek, purik pigi yungke ngaigu kai nararau ono, pi wameikta kozak kai wilibekpek. ");
INSERT INTO big_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosego loyeng ini yana kapura iniyaga naktau lo piyengki kiriwei panu mizi ono. Keya inugu ne Mosegi loyengki kiriwei mizi ono kisi, logo ne neliweki mizi. Ta nangki ini ne neliweki mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Pulaga yongkambanuwiligu Yisuyegi pelik meiya, Ni wirangai narik kai puloge. Mabura ni kerewa nak yenge yaga. Tak ni kazing nelagimekki welageya, meiya. ");
INSERT INTO big_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Legi Yisugu pelik yeiya, Ini nogo Sabatpek wok yawe mizi onobekke yombanu nak yombiyangai sa wazamiya purikki lebuk. ");
INSERT INTO big_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kapura inirau Sabatpek wok yawe mizi onobekke yawe miziwiligu. Inigi yelibu kokabek Mosego iniyegi ngago ngai pobilikta yana, Mandik wik wazamiya nak wok melenazik keya nazikka neyau wiziya logo wok kalikebekke purik yombu korik puguwekki korik yeke ngalege puwek ngeliweki kai. Wameik, kazing pilik mizi puluweng Moseyaga solo lewa leweng ono, puluweng teni Yudawiligi mangowiliyaga lewa leweng. Logo wok pilik mizagibok wok Sabat teni yawe mizi ono mabokko lewagela purik, ");
INSERT INTO big_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ini Mosegi lora ngela nelegi Mosego miziweki kaiya pura ini mizi logo pura pelik, Wok yawe mizi onobek kele kapura ini mandik pilik pokki yombu korikwekki korik yeke ngalege puwek ngeli. Logo ini wok yawe mizi onobekke pilik miziwili nangki Sabatpek wok yawe mizi onobekke nogo yombanu kemegeme nak yombiyangai sa wazamiyarikki wiyeke ini ngalik kisi? ");
INSERT INTO big_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ini waze inugu keriyarik nak kaile mizi nobiyeng mizarikki wiyeke nguk namizi melebek walimizi nagani. Pilikpok ngizi kaile miza ma yeik miza purikki were waberek keriyi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yongkambanu Yirusalem yerengke yolu nawili pugu kai puragi kerewiya logo pelik kisa, Pek Yisu, Yuda ngaiwiligu uliweki mizibok. ");
INSERT INTO big_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Keriyi. Pi yeik ngezebokko kelirikka kaiya melirikki. Yuda ngaiwili nangki yeik wireyeng kele mizara yolu? Ma pi wameik Kilisi Anotogo sawiyabok purikki Yuda ngaiwili weik ngolukku iwaka si kani. ");
INSERT INTO big_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mabura songomeiweki. Purik teni yombanubekyegi iwaka keya pi Nasaretegabek purik teni iwaka kapura Kilisi ngizibek lewa puwekkeriktau nakko solo pugurik iwakagi ono purik teni iwaka, kisa. ");
INSERT INTO big_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yisu ngago piyeng kerewiya logo pugu Anotogi i walekmakki yungke ngago yanageya wizimowei pugu ngalizi panu pelik yeiya, Inugurik ini neyegi iwaka nobiyeng mizi. Keya ini ne talagabek miza purikki iwaka nobiyeng mizi. Ne ne makngezego kumularagi wiyeke kayima ono. Ne wezanelabok ngizi keya ini piyegi lusuwei. ");
INSERT INTO big_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kapura nogo kele piyegi iwaka purik ne piyaga kayimabek kopong, keya pi ne wezanelabek, yeiya. ");
INSERT INTO big_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pulaga Yuda ngaiwili weik nguk namizi pi kebangkelagirikki kumula kapura Anotogo pi pilik kelemiyagira ngoluk sawiya ono legi nakkorau pi pilik kebangkelagi langai ono. ");
INSERT INTO big_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kapura pilik kele kapura yongkambanu wawere ula puwiliyaga kolokngagono Yisu pi Kilisi purikki ngizi kumula. Puwiligu pelik kisa, Yombanubek watabi nakkorau mizi ono, Anoto ngezebokko keke mizi piyeng mizibek walaka Kilisi lewa puwekke pugu mizagi kaiya piyeng kelik mizi, logo pek Kilisibek mane miza, kisa. ");
INSERT INTO big_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Logo yombanu Palisiwili meiwili yongkambanuwiligu pilik kisirikki kerewiya. Togo yombu Anotoyegi kolak miziwiligi ngaiwili keya Palisiwili meiwili miza logo puwiligu Anotogi i walek yemanemakki wagela ngai yoluwiliyegi teng pangka Yisu kebangkelagi naragi yuke koyibene wezayela. ");
INSERT INTO big_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Logo mabilik keya Yisu ngago kaiyageya wiziya logo Yisugu pelik kaiya, Ne ini kiling ngoluk tek narik wiziyagi, pulaga wiziya logo purik ne ngereke ne wezanelabekyegi kangki. ");
INSERT INTO big_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Keya ini neyegi welagi kapura inugurau ne yolok ngelagi ono. Keya ne kangki pulogorau ini neyegi kiriwei kangki ono, yeiya. ");
INSERT INTO big_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Logo Yudawili nakko nakyegi pelik meiya to keya yo miza, Yombanubek tonugurau pi yolok ngelagi ono kai pera pi nangaibek keya pi talege kangweki mizi? Ma pi Yudawiligi ngabelakpek wiya logo Yuda onowiligi ngabelak Yuda nawili yolubekke kangki, logo kanda pulogo Yuda onowili waligeleyiweki, ma talik? ");
INSERT INTO big_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Pugu teniyegi kaiyarik pelik, Ini neyegi welagi kapura inugurau ne yolok ngelagi ono. Keya nogo kang pulogo inirau kangki ono kai. Logo pugu pilik kai purik nangaiyengki, kisi. ");
INSERT INTO big_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ngeragi yemane yaka miza ni puraga wok yemane panubek keya wok kangkalibek mizabekke Yisu luweza logo ngalizi panu pelik kaiya, Tamizeige inuwayaga nak kazing kumbekki lewengke wik wizagomagiragi keli panu wizigeya weik kai kabenengyengki uwei mizi puwili kelik mizi mabura ne kiling saweliweki koli, logo ne kai wik wezabek niweki. ");
INSERT INTO big_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Keya nogo Anotogi Kapiya Walektikku kaiya pelik mizagi, logo wilekpek neyegi ngalege wiyibok, wilek kang pugubekke kai kulektikku lewageli pilik ngizi yolurago kola keya kubulagelega walimizagi. ");
INSERT INTO big_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yisugu pilik kaiya purik yombanu piyegi ngizi kumuli puwili kalike Anotogi Kung Walekpek weiyagi purikki kaiya. Purik puwekkerik Yisu ngoluk paka ngalege yemane keremizi nangai kopong Anotogi Kung Walekpek ngoluk yerageya ono. ");
INSERT INTO big_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yongkambanu wawere ula puwiliyaga kolokngagono pugu kai puragi kerewiya logo pelik kisa, Wameik, Yisu pobok yombanu Mose kelik Anotogo lewagi sawiya logo ngago pugura kozak kai tonugu yuke yolubok, kisa. ");
INSERT INTO big_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Keya nawiligu pelik kisa, Pek Kilisibek. Kapura ngereke nawiligu kanga pelik kisa, Talik miza logo pilikki? Kilisibek ngabelak Kalili meibekka lewagelagi ono. ");
INSERT INTO big_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Purik Kapiya Walektikku pelik kai, Kilisibek Tawitigi yeligagangmekka lewagi logo pi Tawitigi yereng Petelem puraga wazamiyagi, kisa. ");
INSERT INTO big_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tegi weik Yisuyegi weraga yongkambanuwili sanga miza logo nawili namekke keya nawili namekke miza. ");
INSERT INTO big_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Logo nawili pi kebangkela logo wigira wazamiweki miza kapura nakkorau pi kebangkela ono. ");
INSERT INTO big_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Weik pilik miza logo pulaga yombanu Anotogi i walek yemanemakki ngai wagela, Yudawiligi ngai yemanewiligu yaka Yisuyegi ngai yukeweki wezayela puwili yombanu Anotoyegi kolak miziwiligi ngaiwili keya yombanu Palisiwili meiwiliyegi kandobela. Logo puwiligu wagelawiliyegi pelik nguk yeiya, Inuwa nangki pi pelege miza orowei wiriyi nangai miza, yeiya. ");
INSERT INTO big_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Legi wagelawiligu pelik yeiya, Tonugurau yombanu pobokko ngago kai pilik walaka nakko kaiyagalege kerewiya ono. Logo maburikki wiyeke teni pi miza orowei wiriya ono, yeiya. ");
INSERT INTO big_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Legi Palisiwiligu wagelawiliyegi pelik yang yeiya, Talik kisi yaga? Pugu inirau weik kazing nawili ikuyogorik keleya mamokko ikuyogorik keleya kani. ");
INSERT INTO big_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Keriyi, teni Yuda ngaiwiliyaga nawili ma teni Palisiwiliyaga nawili pi Kilisibek purikki ngizi kumuli? A’a’, yeik panu. ");
INSERT INTO big_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kapura yongkambanu piyegi ngizi kumuli puwili yongkambanu Mosegi loyengki lusuweiwili, logo tonugu yeirik, Anotogo ngangang yani pani yei, purik puwili Yisuyegi kiriwei mizi legi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kapura yombanu yeikta Nikotimas mei kusaga Yisuyegi keriyiweki kambela mabok, Palisi puwiliyaga nak, logo pugu Yuda ngaiwili keya Palisi nawiliyegirau pelik nguk yeiya, ");
INSERT INTO big_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Mosegi lorago talik kai? Ngago tonugurago kairik inugu mizi pilik miziweki kai keya pugu mizayeng nangaiyeng miza ono wizigeya waze pi kaile miza kisagi? A’a’, yeiya. ");
INSERT INTO big_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Legi Palisi nawiligu piyegi pelik meiya, Mabura nirau ngabelak Kalili yombanu yeiktikyengko yolu pulumengkabek kani. Anotogi Kapiyarik meiyagirikki kai logo Poropek Anotoyaga ngagora weiya logo kozak kai naktau Kaliligabek ono purikki keriyi mangaiweki, meiya. ");
INSERT INTO big_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Logo weik pilik kisa logo puwili mabuwili nak nak pi pugumakka wei kang miza. ");
INSERT INTO big_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Puwili pilik miza kapura Yisu ngezebek kele paka lewak Olip meibekke Anotoyegi waberek meiweki kambela. ");
INSERT INTO big_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wok kalikebekke wangane panu Yisu ngereke pongo Yirusalem Anotogi i walek yemanemakke kandobela. Yongkambanu wawere ulawili mabuwili piyegi mereke kanda pi kiling mogosa logo puwili waligeleya. ");
INSERT INTO big_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kapura Mosegi loyengki waligeleyiwili keya yombanu Palisiwili meiwilirau yongokpanu yombu pigi kerekpu ono kalogomok nak kiling iwek kolageya wizilegemele, miza orowei kanda mabuwiligi wirege luweza wazamiya. ");
INSERT INTO big_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Logo puwiligu Yisuyegi pelik meiya, Kiriwagabek, yongokpanu pemele yombu weiyamele kele kapura nakko pi yombanu pigi kerekpu ono kalogomokpek kiling mabek mabewekke iwek kolageya wizilege kebangkela. ");
INSERT INTO big_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lo Mosego lende miza piyengka narago teni pilik miziweki kozak kairik yombanu pilik miza puwili kingyengko yela logo ibengweki kai. Kapura nugu purikki kumularik talik? ");
INSERT INTO big_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Puwiligu pilik kisa purik puwili Yisugu ngago lang kaiya narik weiya logo pi purikki wiyeke ngagozak kelemiyagirikki wiyeke kelemiya. Kapura Yisu nguk namizi lawila logo weik ngabelakpekke melegong nakko lende mizi. ");
INSERT INTO big_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Logo puwili piyegi pugu talik kaiyagi miza purikki pulogo luwezara koyimowei nguk meiyageya koya, logo puwili meiyageya keya pi tungkula logo puwiliyegi pelik yeiya, Tamizeige inuwayaga nak kaile nayendau ono mabura kaile nayendau onobokko king solo panubek wezameliweki, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pulaga pi ngereke lawila to mela logo ngabelakpekke melegong nakko lende miza. ");
INSERT INTO big_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Logo puwili Yisugu kai puragi kerewiyawekke yenge ya puwiligiyengka kumulimokko mizagewiyege puwili weik kaile ngezewiligiyengke kumula to mela. Logo were yombu kerekwili kang keya pulaga yombu nawekkewili miza. Logo yongokpanumele ngoluk luwe wizilegemele kiling Yisu ngezebek wezamiya. ");
INSERT INTO big_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Pulaga Yisu tungkula logo yongokpanumeleyegi pakela logo pelik meiya, Yongokpanumele, yaka ni pelege niza orowei wiriya puwili talege? Keya kaile yaka nugu miza puragi wiyeke nakkorau ni king nela ono ma, meiya. ");
INSERT INTO big_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Logo yongokpanumologo pelik meiya, Yemizibek nakkorau pilik miza ono, meiya. Logo Yisugu pelik meiya, Nogorau ni king neliweki kaiyagi ono mena kambele keya kazing kaile mizimek wiye logo mawinda kaile mizi nagani, meiya. ");
INSERT INTO big_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Waleleige Yisu Yudawiligi i walek yemanemakka yongkambanuwiliyegi ngago yanageya wiziyawekke pugu pelik yeiya, Ne yombanuwiligi yayengke wilangka wezarik langaibek kani. Neyegi kiriwei mizi mologaboktau kusabanurikke ulu wali kang keya mizagi ono segeya pilik mologabokki kunagimek ne wilangka wik wizagomagirikku langiya mowiyagi. ");
INSERT INTO big_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pulaga yombu Palisiwili meiwiligu piyegi pelik meiya, Ni weik ni makngezeyegi kozak kai logo ni yombanu wamenak keke legi tenirau niyegi ngizi kumuli ono, meiya. ");
INSERT INTO big_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Logo Yisugu pelik kanga yeiya, Tamizeige nogo ne makngezegi wiyeke kozak kai puriktau nogo kozak kai pura wameiktago, purik nogo kayima laga pulumeng keya nogo kangki pulumendau nogo iwaka. Kapura ini piyengkirau iwaka ono. ");
INSERT INTO big_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ini yeik yongkambanu mabuwiligu mizilik wire yeik inuguyengko keriya piyengki neyegi waze mele yowi. Kapura nogo nakyegirau mele yowi ono. ");
INSERT INTO big_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kapura tamizeige nogo inigi ngagozakyengki kerewiyagi purik nogo sawiyi pura pangkagi, purik ne wamenakko ngagozakyengki kerewiyagi ono. Kapura Peba ne wezanelabok keya nerau te mabiyaugu ngagozakyeng kerewiyagi. ");
INSERT INTO big_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Keya lo inigi piyengka lende miza nara pelik, Tamizeige yombanu neyaugu watabi keriya nayengki mabiyaugu kozak kisi purik mabuwiligu wameik mizagi. ");
INSERT INTO big_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Keya ne makngezego ne tak miza purik kozak kai keya negi Mango ne wezanelabokkorau ne tak miza purik kozak kai, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pulaga puwiligu piyegi pelik nguk meiya, Nigi Mangobek talege yolu, meiya. Legi Yisugu pelik kanga yeiya, Ini ne ma negi Mangobekyegirau iwaka ono. Tamizeige ini neyegi iwaka kesak ini negi Mangobekyegirau iwaka, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Logo ngago piyeng Yisugu Anotogi i walek yemanemakka yongkambanuwili waligeleyawekke kaiyayeng. Logo pulogorik pi king Anotoyegi mani piyengki lopongleigi ngezege luwe wiziya kapura nakkorau pi wigira wazamiweki kebangkela ono, purik Anotogo pi kebangkelagi sawiyara ngoluk kopong. ");
INSERT INTO big_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Pulaga mawinda kang nararau Yisugu puwiliyegi pelik yeiya, Ne yereng nogoraga kang yongogi. Logo ne pilik mizi puwekke ini neyegi welagi kapura inugu ne yolok ngelagi ono. Keya kaile inuguyeng Anotogo tumuli nangai wizigeya ini kemenak ibengki. Keya ne kangki pulogorau ini kangki ono, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yudawili puragi kerewiya logo pelik kela yo keya to miza, Pugu ne kangki pulogo inirau kangki ono kai poburik pi ngezebokko ngezebek ula logo ibengki sa legi pelik kai kani, kela. ");
INSERT INTO big_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kapura Yisu mabilik ngago kai kuna, Ini ngabelakpekkawili. Ne paka ngalegabek. Ini watabi ngabelakpekke piyeng mabiyengki wilek kang tiya maniwili kapura ne pilik mizi onobek. ");
INSERT INTO big_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Logo piliktikki wiyeke nogo iniyegi kaile inuguyeng Anotogo ngoluk tumuli nangai wizigeya ini kemenak ibengki yeiya purik, tamizeige ne nogo kai mabok purikki ini ngizi kumuli ono mabura. ");
INSERT INTO big_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Logo puwiligu piyegi pelik nguk meiya, Mabura ni tak, meiya. Yisugu pelik kanga yeiya, Nogo koka solowekka iniyegi kozak yeiya mabok ne, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Keya iniyegirik ngoluk watabi kolokngagono nogo iniyegi langai kaiyagiyeng wizinda, kaile inigi piyengki langai ini iwaka siweki keleyagiyeng. Negi Mangobokko ne pugu kaiyagalege kerewiya piyeng ngabelakpekkewiliyegi kozak yeiweki wezanela. Keya negi Mangobek ngago wameikyeng kaibek, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kapura Yuda ngaiwili pugu pigi Mangobek kaibok tak miza purikki puwili iwaka panu ono. ");
INSERT INTO big_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Legi Yisugu pelik yeiya, Yombanu paka ngalega kayimabek yengeleileige ngalege nili ula logo yengeleilei kiling luwe lowamiya wazami puwekke ini ne tak miza purikki iwaka si nangine keya keli ne makngezegirago watabi nayeng mizi ono, nogo kaiya piyeng negi Mangobokko waligeleniyayeng purikki iwaka si nangine. ");
INSERT INTO big_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Keya ne wezanelabok ne wezani onobek, pi ne kiling yolu. Pugu ne wezani ono purikki solorik pelik, ne wok mabiyeng pugu keli piyeng mizi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Logo pi pilik kaiyageyarik yongkambanu kolokngagonomek weik pi Kilisi Mesiyabek Anotogo puwili yaliya wazayiweki sawiyabek purikki ngizi kumula. ");
INSERT INTO big_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Logo Yisugu piyegi Yuda ngizi kumuli puwiliyegi pelik yeiya, Tamizeige ini Anotogi ngago nogo kozak yei piyengki wok mabiyeng kiriwei yolu purik mabura ini neyegi kiriwei panuwili. ");
INSERT INTO big_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Logo wameikta nangaira miza purik ini iwakagi logo wameiktago ini wila wazayagi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Pilik kai legi nawiligu piyegi pelik kanga meiya, Kapura teni Abalamgi yango keya marekngangwili. Tenirau koka yombanu ngai nawiligu puwiliyegi yeik ulak yawe miziweki kingyengki ngane weiya onowili. Tegi nangki nugu teniyegi teni wila wazayagi kai? Ni purik nangairikki kai yagenda, meiya. ");
INSERT INTO big_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Legi Yisugu pelik yeiya, Nogo kozak yei pura wameiktago, Nak kaile mizibek kaileyengki yawe mizi yagenda, logo kaileyengko piyegi ngai. ");
INSERT INTO big_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ngai nakko yombanu kingyengki ngane weiya logo piyegi ulak yawe mizibok ngaibekki imakka pulogo wizagomagibek ono kapura pigi marek pugu wazamiyabok kele ngaibekki imakka pulogo wizagomagibek. ");
INSERT INTO big_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Legi tamizeige ne, Anotogi Marekpokko ini kaileyengki kozandaga wila wazayi purik mabura ini wameik wila wazayi yagenda kani. ");
INSERT INTO big_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ini Abalamgi yango keya marekngangwili purik ne iwaka, kapura ini ngoluk ne nelagirikki kumula, logo purik wilek kang inuguyeng ngago nogoragi kumbak kopong. ");
INSERT INTO big_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Keya nogo kai piyeng ne negi Mangobek kiling wiziyawekke nogo keriyayengki ne keke kozak kai yagenda keya inirau mabilik. Ini inigi mangobekyaga kerewiya piyengki kiriwei mizi yagenda, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Logo puwiligu mawinda pelik meiya, Abalam walaka panu wizagomabok tenigi mangobek, meiya. Logo Yisugu pelik yeiya, Ini wameik Abalamgi yango keya marekngangwili kesak ini Abalamgu mizalik mizi kak. ");
INSERT INTO big_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kapura ini weik ne neliweki mizi, nogo kozak yeiya piyeng wameik keya Anotogo kaiyagalege nogo kerewiyayeng kele kapura. Keya Abalam inugu mizi piyeng miza onobokko. ");
INSERT INTO big_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kapura iniyegirik ini inigi mangobokko mizilik mizi, yeiya. Logo puwiligu pelik meiya, Takko kai? Teni koloyakamandik kelaleng kekewili ono. Tenigi Mango wamenak, logo pok Anoto, meiya. ");
INSERT INTO big_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yisugu pelik yeiya, Anoto wameik inigi Mangobek kesak ini neyegi keli. Purik pugu yolu pulaga ne wezanela, logo ne weik pelege yolu. Ne ne makngezego kumularaga kayima ono, pugu ne wezanela. ");
INSERT INTO big_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Keya nogo iniyegi kai peragi ini lusuwei mizi purikki solorik ini iwaka? Purik ini nogo iniyegi kai peragi kerewiyagirikki kiyebuk kopong. ");
INSERT INTO big_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Keya inigi mangobek Sadang logo ini pugu watabiyengki kira orowei mizi pilik miziweki keliwili. Pi koka solowekkerikka yombanu ulageya wizagomibek. Pi wameiktagi kumbakpek purik pigi yungke wameiktarau yolu ono. Logo pi ngaigu kai puwekke pi kaiyagelik kai yagenda, purik pi ngaigu kai piyengki mangobek. ");
INSERT INTO big_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kapura ne wameik kai kopong ini neyegi ngizi panu kumuli ono. ");
INSERT INTO big_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Inuwayaga takko ne kaile kaile mizageya yolubek neiyagi langai? Nak ono. Tamizeige ne wameik kai mabura nangki ini neyegi ngizi panu kumuli ono? ");
INSERT INTO big_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Anotogi marekngangwili ngago puguyengki kerewiyi puwili. Kapura ini purik, ini Anotogi marekngangwili ono, logo piliktikki wiyeke ini ngago nogoyengki nagerewiyi miziwili, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yisu pilik yeiya logo Yudawiligu Yisuyegi pelik kanga meiya, Teni niyegi pelik kisiwili, Ni yombu ngabelak Sameriya meibekka lewa legi ni pelaga onobek, keya ni yombu kerewa nak yenge nigi yungke yolubek, kisiwili logo tonugu piyeng kisi purik wameik kisi ma, meiya. ");
INSERT INTO big_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yisugu pelik kanga yeiya, A’a’, ne kerewa nak yenge yungke yolu ono. Ne negi Mangobekki yeikta yongolok mei keya inugu yeik nogora kaile sawiyi. ");
INSERT INTO big_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kapura ne yeik ne makngezegera yongolok meiweki keli ono kani. Nakko yeik nogora yongolok meiweki mizi keya pi ngagozakyengki kerewiyagibek. ");
INSERT INTO big_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nogo iniyegi kozak yei pura wameiktago. Tamizeige nak ngago nogoragi kerewiya logo kiriwei mizibok mabura pi kemenak ibeng wizagomagi ono, pi wik wizagomagi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tegi Yudawiligu piyegi pelik meiya, Ni kerewabek yenge yungke yolu purik tonugu mabek weik iwaka panu. Abalam ulogo ibeng keya yombanu Anotoyaga ngago weiya logo kozak kisiwilirau ulogo ibeng kapura nugu pelik kai, Tamizeige nak ngago nogoyengki kerewiya logo kiriwei mizi mabura pi kemenak ibeng wizagomagi ono, kai. ");
INSERT INTO big_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abalam tenigi mangobek ulogo ibeng kapura ni teni Yudawiligi mangobek, Abalamyaga ngalege panu ma talik? Keya yombanu Anotoyaga ngagora weiya logo kozak kisawilirau ulogo ibeng, legi nugu kumularik ni tak, meiya. ");
INSERT INTO big_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tegi Yisugu pelik kanga yeiya, Tamizeige ne yeik nogora ne makngezego yongolok mei purik yeik nogora yeikki. Kapura Peba negi Mangobek yeik nogora yongolok meibek inugu Anoto inigibek kisibok. ");
INSERT INTO big_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Keya ini ulogo piyegi iwaka ono keya mabek ngoluk iwaka ono kapura nogo piyegi iwaka. Tamizeige nogo ne piyegi iwaka ono kai kesak ne onanga kai yagenda, inugu kisi pilik. Kapura nogo piyegi iwaka logo ne ngago puguragi kerewiya logo kiriwei mizi mizi. ");
INSERT INTO big_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abalam inigi mangobek koka wok ne lewagibekke pakeliweki wilik miza. Pugu pakela logo pi wilikwilik yemane miza, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pulaga Yudawiligu piyegi pelik meiya, Ni ngoluk yombusibek ono. Talik miza logo nugu Abalamyegi pakela, meiya. ");
INSERT INTO big_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yisugu kanga pelik yeiya, Koka Abalam wazamiyaginerik ne were wiziya kani. Nogo iniyegi kozak yei pura wameiktago, yeiya. ");
INSERT INTO big_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Togo puwiligu kingyeng weiya logo pi uliweki miza kapura Yisu liwik sa logo Anotogi i walek yemanemak wizamiya logo welagela kazi kula. ");
INSERT INTO big_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yisu kiling pugu waligeleyiwili tagoneige pura yombanu panugu wazamiyarik wireyau mabilik kusa wizigeya wazamiya nak wizilege pakela. ");
INSERT INTO big_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Logo Yisugu waligeleyiwiligu piyegi pelik nguk meiya, Kiriwagabek, yombanubek wire kusayau kiling wazamiya pura nangki? Kaile mangogiyeng ma panugiyeng ma ngezebekkiyengki wiyeke pek pilik miza, meiya. ");
INSERT INTO big_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Legi Yisugu pelik kanga yeiya, Yombanubek pilik wazamiya purik pugu kaile miza ma panu keya mangogo kaile mizarikki wiyeke ono kapura segeya Anoto piyegi yawe nara kelemiya logo yombanuwiligu keriya logo Anotogi yeikta yongolok meiweki. ");
INSERT INTO big_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yombanu nak kabelaktik ngoluk wilangka puwekkerik pangka yawe mizi penangai kapura weik kusa puwekkerik pi mawinda yawe mizagi ono, logo teniyegiriktau mabilik kani. Teni ngoluk wilangka yolu mabuwekke teni ne wezanelabokki yawera miziweki kani. Wok ne nela logo ibeng wizigeya mawinda yawe mizagi onobek weik mereke. ");
INSERT INTO big_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Keya ngabelakpekke pelege ne yolu perik ne wilangka wezarik yombanuwiligi yayengke langaibek kani, yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yisu pilik kaiya logo pulaga ngabelakka sibilak ngiza logo sibilaktik kiling ngabelakpek lomok keremiza wizigeya yaka wireyau kusabokki wireyauge pukmela. ");
INSERT INTO big_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Logo pugu wireyau kusabekyegi pelik meiya, Panga kaigesirikke kai yeikta Silom meibokka kaigesi mangine, kambele, meiya. Yeik yaka Silom mei pura ngago yeik tonuguragarik, kang wezamela, mei yagenda. Yisu pilik kaiwekke yombanubek kanda wiregawerera kaigesa logo weik wireyau ngaiwila wizigeya panga ige kambela. ");
INSERT INTO big_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Logo yongkambanu pigi ngezege yoluwili keya pi watabiyengki nguk kaiyageya wizilege keriyawiligu pelik kisi, Pek yombanu kazing lewengke kerelemekke mogosa logo kingyengki nguk kaiyageya mizibok ma nak, kisi. ");
INSERT INTO big_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Legi yombu nawiligu mabok yeiya. Nawiligu pi ono kapura pi kelik yeiya. Kapura yombanubek ngezebokko kimeike ne mabok yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Logo puwiligu pelik nguk meiya, Talik miza logo wire nuguyau ngaiwila, meiya. ");
INSERT INTO big_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Legi pugu pelik kanga yeiya, Yombanu puwiligu Yisu meibokko lomok narik keremiza logo wire nogoyauge pukmela. Logo pugu ne panga kaigesirikke kai yeikta Silom meibokka wiregawerera kaigesiweki kai legi ne kuna. Ne wiregawerera kaigesa logo wire nogoyau weik ngaiwila, yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Logo puwiligu piyegi pelik nguk meiya, Yombanu yaka wire nuguyau ngaiwila wazamiyabok talege, meiya. Logo pugu ne lusuwei, yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pulaga weik puwiligu yombanu ulogo wireyau kusa wizagomabok miza orowei panga Palisiwiliyegi kuna. ");
INSERT INTO big_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Purik wok Yisugu yaka lomoktik keremiza logo yombanubekki wireyauge pukmela logo wireyau ngaiwilabok, wok Yudawiligi yawe mizi onobekke, logo purikki Palisiwili kiyebuk. ");
INSERT INTO big_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tegi Palisiwiligu piyegi talik nalik miza logo pi wireyau ngaiwila miza purikkirau meiya. Logo pugu pelik kanga yeiya, Pugu lomoktik wire nogoyauge pukmela logo ne wire nogoyau kaigesa logo wire nogoyau weik ngaiwila, yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pulaga Palisi nawiligu pelik kisa, Yombanu pera mizabok Anotoyagabek ono, purik pi Yudawiligi lo wok yawe mizi onobekke yawe mizi nagani kai pura ngela legi, kisa. Keya nawiligu pelik kisa, Logo inugu pi kaile mizibek mei, kapura tamizeige pi kaile nayeng miza kesak yombanu nakkorau mizagi ono Anoto ngezebokko keke mizi pugu mizi piyeng mizi kak ono, kisa. Pulaga weik yongkambanuwili ngezewiligi tepekke ngalik kela yongomo miza. ");
INSERT INTO big_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Pilik miza logo Palisiwiligu mawinda kang nararau yombanubekyegi pelik nguk meiya, Wire nuguyau ngaiwila wazamiyabokyegi langai nugu kaiyagirik talik kaiyagi, meiya. Logo yombanubokko pelik yeiya, Pi yombanu Anotoyaga ngagora weiya logo kozak kaibek kani, yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yudawiligi ngai puwili pilik kerewiya kapura puwili yombanubek wireyau kusa wizagomabek logo weik wireyau ngaiwila purikki ngoluk ngizi kumula ono, purik puwili yombanubekyegi lusuweiwili kopong. Togo puwili yombanu yaka Yisugu wireyau ngaiwila wazamiyabokki panu keya mangoyau ngago yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Logo puwiligu panu keya mangoyegi pelik nguk yeiya, Pek yaligi marekpek? Keya pi wazamiyarik wireyau kusa mabilik wizigeya wazamiya kisi purik wameik? Keya pi weik wireyau ngaiwila perik talik miza logo, yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Logo panu keya mangogo pelik kanga yeiya, Ei, wameik, pek tegi marek wireyau kusa mabilik wazamiya pok. ");
INSERT INTO big_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kapura pi wireyau talik miza logo ngaiwila miza purik te lusuwei keya takko wire puguyau ngaiwila wazamiya miza purik togorau pakela ono. Pi weik yombu nak wizinda mena piyegi mei. Pi ngezebokko pangka kozak kai penangai mena, yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Pigi panu keya mangoyaugu pilik kisa purik piyau Yuda ngaiwiliyegi kazi kopong, purik Yuda ngaiwiligu kisarik tamizeige namele ma nakko Yisu Kilisibek kaiya purik mabura pumolo ma poktau Yudawiligi i walek songonomakke kiliya yabelagi ono kisi legi. ");
INSERT INTO big_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Piliktikki wiyeke pigi panu keya mangoyaugu, Pi weik yombu nak wizinda mena piyegi mei. Pi ngezebokko pangka kozak kai penangai mena kisa purik. ");
INSERT INTO big_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Togo pulaga puwili ngereke yombanu ulogo wireyau kusa wizagomabok ngago meiya logo piyegi pelik meiya, Niyegi lewagela piyengki wiyeke mena Anotogi wirege wameikta kozak kai, purik yombanubek kaile mizibek purik teni iwaka mena, meiya. ");
INSERT INTO big_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Logo pugu pelik kanga yeiya, Pi kaile mizibek ma yeikpek miza purik ne lusuwei. Watabi wamenak nayeng nogo keke iwaka. Ne wireyau kusabek kapura wire nogoyau weik ngaiwila, yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pulaga puwiligu pelik nguk meiya, Pugu niyegi talik keleniya? Kang tamekke pugu wire nuguyau ngaiwila wazamiya, meiya. ");
INSERT INTO big_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Logo pugu pelik kanga yeiya, Nogo yaka iniyegi kozak yeiya kapura ini neyegi kerewiya ono. Legi nangki nogo iniyegi mawinda kozak yeiweki kisi? Mabura inirau piyegi kiriweiweki mizi kani, yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Logo Yuda ngaiwiligu pelik ngalik meiya, Ni kaile mizibokyegi kiriwei mizibek. Teni Moseyegi kiriwei miziwili. ");
INSERT INTO big_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Keya Anotogo Moseyegi ngago meiya purik teni iwaka kapura pekyegirik pi talaga lewabek miza purik tenirau lusuwei, meiya. ");
INSERT INTO big_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Logo pugu pelik yeiya, Maburikki ne lebuk mizi. Purik pi talagabek miza purik ini lusuwei kapura pugu wire nogoyau ngaiwila wazamiya purikki. ");
INSERT INTO big_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Anoto kaile mizi puwiliyegi kerewiyi onobek purik teni iwaka. Keya Anoto piyegi keli keya pugu kelira mizi puwiliyegi keke kerewiyibokko. ");
INSERT INTO big_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Koka ngabelakpek keremizariktau nakko mabilik wire kusayeng kiling wazayawiligi wireyeng ngaiwila wazayirikki kozak kisiyagalege tonugu kerewiya ono. ");
INSERT INTO big_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Keya tamizeige Anotogo pi wezamela ono kesak pugurau watabi nayeng mizi kak ono, yeiya. ");
INSERT INTO big_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Logo puwiligu pelik meiya to mela, Ni kaileyeng kiling wazaniyabek keya kaile mizi kai kayimabek kapura nugu teni waligeleyiweki mizi, meiya. Togo Yuda ngaiwiligi wawere ula logo kozak kela purikka pi mawinda i walek songonomakki kangki ono meiya logo pi welagela wezamela. ");
INSERT INTO big_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yuda ngaiwiligu yombanubek pilik welagela wezamela purikki Yisu kerewiya logo pi yombanubekyegi pelik meiweki kuna, Ni yombanu paka ngalega kayimabokyegi ngizi kumuli ma yeik, meiya. ");
INSERT INTO big_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Logo yombanubokko pelik nguk meiya, Yemanebek, pok tak? Ne piyegi ngizi kumuliweki mena neyegi kozak kai, meiya. ");
INSERT INTO big_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Logo Yisugu pelik meiya, Ni weik piyegi pakela. Keya ni kiling ngagogeya mizibok pi, meiya. ");
INSERT INTO big_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Togo ulogo wireyau kusa wizagoma kapura weik ngaiwilabokko pelik meiya, Yemizibek, ne ngizi kumuli, meiya logo Yisugi wilek wirege ingegereyau laliya logo yeik pugura yongolok meiweki. ");
INSERT INTO big_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Logo Yisugu pelik meiya, Ne yongkambanu mamok ngai neyauge sanga mizagelega wezayiweki ne ngabelakka pelege kayima logo purik pelik, kazing kumbekki lewengke wireyeng kusa puwiligi wireyeng ngaiwila wazayiweki keya pakeli nobiyeng kumuli puwiliyegi ini wireyeng kusa kani yeiweki, meiya. ");
INSERT INTO big_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Logo Palisi pulogo pi kiling koya nawili Yisugu pilik kairikki kerewiya logo pelik nguk meiya, Talik yaga? Nugu kumularik teni wire kusawili, meiya. ");
INSERT INTO big_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Logo Yisugu Palisiwiliyegi pelik yeiya, Ini wireyeng wameik panu kusa kesak kaile nayeng iniyegi ono. Kapura ini wameiktagi iwaka kisi legi purikki wiyeke kaile inuguyeng iniyegi mabilik yolu, yeiya. ");
INSERT INTO big_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yisugu pelik yeiya, Kerewiyi, nogo iniyegi kozak yei pura wameiktago. Yombanu liyeng memengwiligi lemengmekke kiliya kangwekke kandik neing kiliya kang ono, ngereke lemengmekki libuga tameneng meibokyegi langai nogo meiyagirik ngoweibek keya i ngelibek meiyagi. ");
INSERT INTO big_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kapura yombanu liyeng memengwiliyegi ngaibok lemengmekki kandik neing kiliya wiriyi penangai. ");
INSERT INTO big_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Logo yombanu kandikke ngai yolubokko liyeng memengwiliyegi ngaibokki kandik tiya mowiyi. Liyeng memengwili puwiliyegi ngaibokko ngagora puwili iwaka logo ngaibokko liyeng memeng pigi puwiligi yeikyeng mei logo puwili wanganerikki wiyeke lemengmekka welagela iza orowei kuniweki. ");
INSERT INTO big_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Keya pi puwili ngago yeiyageyara weik puwekke purik pi ngezebek were kang. Keya liyeng memengwili puwiliyegi ngaibokki ngagora iwaka kopong puwili piyegi kiriwei kang. ");
INSERT INTO big_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kapura puwilirau nazuwaga nakyegi kiriwei kang onowili, keya puwili pokyegi lusuwei kopong puwili kazi kang, yeiya. ");
INSERT INTO big_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisugu ngago saweli pura Palisiwiliyegi kozak yeiya kapura Palisiwili ngago puragi solorikki lusuwei miza. ");
INSERT INTO big_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tegi Yisugu ngereke pelik yeiya, Nogo iniyegi kozak yei pura wameiktago. Ne kang liyeng memengwiligu yeke lemengmekkiweki kiliya kang yongomorik kelik. ");
INSERT INTO big_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Keya waligeleyi ne lewagine were teni Mesiyabek kisi kayima puwili mabuwili ngoweiwili keya i ngeliwili kelik. Logo puwiligu mizarik yombanuwili puwiliyegi kiriwei mizibene ikuyogorik keleyagi nobiyeng miza. Kapura yombanuwili liyeng memengwiligu mizilik yombanu puwiligu lusuweibekki ngagora kopong puwili kazi kuna. ");
INSERT INTO big_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ne kang liyeng memengwili yeke lemengmekki kiliyawekirik kelik. Keya kazing Anotogo ngai pugumekki ngai puragi kiliyawekimek, ne legi kazing nogomek neing kiliyabok nogo watabi kozaga kelemiyagi piyengka yaliya wazamiyagi. Keya liyeng memeng lemengmekka welagela kanda ngeragiyengki wela logo pulaga kiliya yo puwiliyegi ngai puwiligibokko puwiliyegi ngai pilik nogo puwiliyegi ngaigi. ");
INSERT INTO big_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kapura ngoweiwili liyeng memengwili ngowei keya yeli lewa logo liyeng memeng mabuwili yeik sawiyiweki. Ne kayima purik yongkambanu ne kiling saweli mamok ngizi koyimagi pura kilingweki keya puwiligu ngizi yolu puraga wilik kagowindago kola koyibene. ");
INSERT INTO big_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Keya ne yombanu liyeng memengwili kelik puwiligi ngai wazonobek. Liyeng memengwiligi ngai wazonobokko liyeng memeng puguwili kaileyengka yaliya wazayagirikki weraga miza logo ibeng si penangai. ");
INSERT INTO big_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Liyeng memengwiligi ngaibekyegi yombanu yawe mizibok liyeng memengwiligi mangobek ono. Pi yeik king wei purikki ngane liyengwiliyegi ngai. Togo pugu keriyi tagai keri wizing yemane namek yawerelege puwekkerik pi kazi kunagi logo liyeng memengwili ngezewili wezayagi. Logo keri wizing yemanemokko liyeng memeng nawili limitagi logo pi nawili limitageya puwekkerik nawili weik narikke mizagi. ");
INSERT INTO big_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Logo yombanu yawe mizibokko pilik mizi purik pi yeik kingyengki yawe mizibek kopong. Logo pugurau liyeng memengwiliyegi keli ono. ");
INSERT INTO big_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ne yombanu neyegi ngizi kumuli puwiligi ngai wazonobek. Ne yongkambanu nogowiliyegi iwaka keya yongkambanu nogowili neyegi iwaka ");
INSERT INTO big_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","mabilik negi Mangobokko neyegi iwaka keya nogo negi Mangobekyegi iwaka yolu logo ne yombanu nogowiligi wiyeke ibeng yaka liyeng memengwiligi mangobokko puwiligi wiyeke ibengki pilik. ");
INSERT INTO big_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Keya liyeng memeng negi nawilirau ngoluk koyinda. Kapura puwili ngoluk liyeng memeng kabe nogomek kiling leme wezayimekke yolu ono. Puwilirau nogo ngago yeiya logo pelege wiriyibene keleyagi. Logo nogo pilik mizi puwekke puwilirau ngago nogora kerewiyagi. Logo nogo kabe wamenakmek keleyagi, logo ne wamenakko puwili mabuwiliyegi ngaigi. ");
INSERT INTO big_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Negi Mangobek neyegi keli purik ne liyeng memeng nogowiligi wiyeke yombanuwiligu ne nelibene ne makngezego ne makngeze ngaungaugu niza yani kopong logo pulaga ne yangalek meiya logo ngereke wik wizagomiweki. ");
INSERT INTO big_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ne nelagirikki keli ono kesak nakkorau ne neli ono. Kapura ne ngaungaugu ibengki. Keya ne ibengki puragi pangkara keya kozanda kilimbek, keya ne yangalek meiya logo ngereke wik wizagomagi puragi pangkara keya kozanda kilimbek. Nogo pilik mizi purik pangkarikku, purik negi Mangobokko miziweki neiya legi, yeiya. ");
INSERT INTO big_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yudawili kerewiyarikka ngago piyengki weraga puwili ngereke nawili namekke miza. ");
INSERT INTO big_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Logo nawiligu pelik kisa, Ini nangki pugu kai puragi kerewiya yolu? Pi lelewe kani. Pi kerewa nak yenge yaga yolu kani, kisa. ");
INSERT INTO big_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kapura Yuda nawiligu pelik kisa, Pi kerewa nak yenge yaga yolu kesak pugu ngago kaiyageya pilik pi kai kak ono. Keya yombanu kerewa nak yenge yaga yolubokkorau wire kusa piyau ngereke ngaiwilibene keleyagi ono, kisa ");
INSERT INTO big_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yirusalem yerengke pulogo weik ngeragi yemane miza ni nara lewagelaweki mizi. Logo pura yongkambanuwili Anotogi i walek yemane puwiligimakka Yuda onowiligu kaile kaile miza logo puwiligi yelibungangwiligu walaka ngereke waberek ngizarikki kumula logo ngeragi yemane miza nira. ");
INSERT INTO big_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Weik teng kebarekpek uli keya kilili miziraga logo Yisu Anotogi i walek yemanemakka wale Solomongi Parandara meirage wei kaiyageya wiziya. ");
INSERT INTO big_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Logo Yuda ngaiwili kanda pi yawereng kelemiya logo pelik meiya, Ni wok talik talikke teni lelewe sara koyimowei keya ni tak miza purik teniyegi liwik mizageya wizagomi mangai? Tamizeige ni Kilisibek mabura wameikta teniyegi kozak kai, meiya. ");
INSERT INTO big_vp