﻿USE sofia;
DROP TABLE IF EXISTS sofia.bib_vpl;
CREATE TABLE bib_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bib_vpl WRITE;
INSERT INTO bib_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yeezuu yaabɔɔ wɔɔ ba n nɩ: Yeezuu ɩ yɩrɛ ɩ ʊ, cir *Davɩd Nyɩ m, Abraham do gʊaa m sɔ. ");
INSERT INTO bib_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham n Izakkɩ yɩ, Izakkɩ n Zakɔɔb yɩ, Zakɔɔb n Ziida kan a dannɔ kɩ yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ziida n Farɛɛs kan Zaaraa kɩ yɩ, ŋ da m Tamaar m, Farɛɛs n Ɛsrɔm yɩ, Ɛsrɔm n Aram yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram n Aminadaab yɩ, Aminadaab n Naasɔɔn yɩ, Naasɔɔn n Salmɔɔn yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔɔn n Boozɩ yɩ, a da m Rahab m, Boozɩ n Zobɛɛd yɩ, a da m Rutɩ m, Zobɛɛd n Yesee yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesee n cir Davɩd yɩ, Davɩd n Salomɔɔn yɩ, a da nyɩnta Iirii lʊ, ");
INSERT INTO bib_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔɔn n Roboam yɩ, Roboam n Abɩya yɩ, Abɩya n Azaa yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Azaa n Zozafat yɩ, Zozafat n Zooram yɩ, Zooram n Ozɩyas yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozɩyas n Zowatan yɩ, Zowatan n Akaazɩ yɩ, Akaazɩ n Ezekɩyas yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekɩyas n Manase yɩ, Manase n Amɔɔn yɩ, Amɔɔn n Zozɩyas yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zozɩyas n Zekonɩyas kan a dannɔ kɩ yɩ. A n a ga kʊ ʊ kan *Babɩlɔnnɩ lɔmbaa tarɛ dɔmɩm bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babɩlɔnnɩ lɔmbaa bɩ jɛ ʊ bɩ, Zekonɩyas Salatɩyɛl yɩ, Salatɩyɛl n Zorobabɛl yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabɛl n Abiyud yɩ, Abiyud n Eliyakim yɩ, Eliyakim n Azɔɔr yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔɔr n Sadɔk yɩ, Sadɔk n Akim yɩ, Akim n Eliyud yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud n Eleyazaar yɩ, Eleyazaar n Matan yɩ, Matan n Zakɔɔb yɩ, ");
INSERT INTO bib_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zakɔɔb n Maarii zim Zozɛf yɩ, Maarii bɩ do ɩ Yeezuu yɩ n n'a birm Krista. ");
INSERT INTO bib_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yaabɔɔ wɔɔ haay lɛ a zɛ kʊ ra bueeresi-si. A n a sa Abraham ma an ta m Davɩd ra bueeresi, an a sa Davɩd ma an ta m Babɩlɔnnɩ lɔmbaa ma bueeresi, an a sa Babɩlɔnnɩ lɔmbaa ma an ta m Krista ra bueeresi. ");
INSERT INTO bib_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yeezuu yɩrɛ bɩ zaa ba n nɩ: A da Maarii bɩ, nyɩnta a ʊ Zozɛf jaan, bɩ, an lɛɛ ka kʊ Maarii n a ba Zozɛf lʊ bɩ, *Sɛnt-Ɛspri a ka Maarii n jɩsɩ sa. ");
INSERT INTO bib_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A jaan Zozɛf bɩ kʊ gʊaa mɩŋŋa m bɩ, a n a ŋʊa k'a a da nyannɩ ʊ y. A n a hɔɔn da k'a wɔ saa kʊ gɔsɩ b'a dɔ y. ");
INSERT INTO bib_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","K'a n'a hɔɔn darɛ ncɩnaaʊ bɩ, Zuuba Malɛɛka bʊr zi nɩnnarɛ nɔ ʊ, an a hɩ m, a ʊ: «Zozɛf, Davɩd do gʊaa, ɩ bɩ nyi ba k'ɩ Maarii sa ɩ ba ɩ lʊ y, bala, Sɛnt-Ɛspri paŋŋa y'a ka, an nɩ jɩsɩ bɩ m, ");
INSERT INTO bib_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","a nyɩ yɩm yar, k'ɩ tɔ ka Yeezuu, bala, a m n'a do bɩ bʊmbɔrɛ a mimbʊnyaarɔ nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Naa do woo… naa, ba ʊ kʊ meerbaa kʊ Woso a ba kan a lɛsinnɩsorazaa lɛ kɩ bɩ n kʊ yɩ. ");
INSERT INTO bib_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","A ba n nɩ: nyɩmbʊɛɛrɛ k'a n yar dɔ bɩ jɩsɩ sim, an nyɩ yɩ yar, n y'a tɔ karɛ Emanʊwɛl, a jɩ lɛ taa k'a hɩ, a ʊ: Woso ɩ kan wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zozɛf k'a bɩ gu hinceem ma bɩ, a hɔ kʊ Zuuba malɛɛka b'a hɩ m bɩ ba: A Maarii gaa, an a ba a lʊ, ");
INSERT INTO bib_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","bɩ, a n a dɔ lʊ y, an ta an aa dɔmɩm k'a nyɩyar bɩ yɩ ʊ bɩ ku, an a tɔ ka Yeezuu. ");
INSERT INTO bib_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yeezuu bɩ, yɩ a ʊ Betelehɛm ʊ Zidee kʊ ʊ, cir Hɩrɔɔdɩ dɔmɩm ʊ, bɩ hɔdonno a to dɔjɩr ʊ, ŋnɩ bʊr Zerizalɛm ʊ, ");
INSERT INTO bib_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ŋnɩ laaka da: «Zɩɩfʊrɔ cir k'a yɩ b'ɩ ka? Wɔɔ monyaa yɩ dɔjɩr ʊ bɩ y'a ka, wɔɔ n bʊr k'ʊ b'a da ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hɩrɔɔdɩ k'a naa ma bɩ, a da bɔ ʊ kan Zerizalɛm zannɔ kɩ haay. ");
INSERT INTO bib_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A n wosocɛmannɩbənno jɩtannɔ wɔɔ so kʊ ma kan wosocikarɩnsaambɔɔ wɔɔ kɩ, an laaka da ŋ han kʊ niŋŋə kʊ Krista bɩ n nɩ yɩŋ ʊ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Brɔɔ n a nyɩ bɔ ʊ, ŋ ʊ: Betelehɛm ʊ Zidee kʊ ʊ, bala, hɔ kʊ wosolɛsinnɩsorazaa b'a hɩ bɩ n naa do. ");
INSERT INTO bib_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","B'ɩbɩɩ Betelehɛm, Zidee kʊ, ɩbɩɩ bɛɛ m poore Zidee kʊrɔ gʊtɔɔ wɔɔ barla y. Bala, cir bɔrɛ ɩbɩɩ bireyaa ʊ, an ka Israyɛl mɔɔ gʊɔɔ wɔɔ lɛɛ. ");
INSERT INTO bib_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","A m bɩ, Hɩrɔɔdɩ n hɔdonno wɔɔ bir sɛɛrɛ, an laaka da ŋ han dɔmɩm kʊ monyaa bɩ bɔ ʊ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A n ŋ nyɔɔ Betelehɛm ʊ, an n'a hɩrɛ ŋ nɩ, a ʊ: «K'a ta a laaka da nyɩ bɩ mim ma mɩŋŋa, k'a nyɩ bɩ yɩ, k'a a wusigə a b'a hɩ mɔɔ m, kʊ m ta m aa da ʊ sɔ.» ");
INSERT INTO bib_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Cir bɩ k'a naa hɩ bɩ, ŋ y'a hʊr, ta kʊ ŋ nawʊm bɩ, monyaa kʊ ŋ lɛɛ ka ŋn'a yɩ dɔjɩr b'ɩ tarɛ ŋ lɛɛ, an ta an aa jɩm lɛɛ kʊ nyɩ bɩ n ta ʊ bɩ burə ʊ. ");
INSERT INTO bib_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Monyaa bɩ kʊ ŋ y'a yɩ bɩ, ŋ heer yɩ nyɩnta gʊta. ");
INSERT INTO bib_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ŋ gasʊ cɛ b'ʊ, ŋn'aa nyɩ bɩ yɩ kan a da Maarii kɩ, ŋnɩ kukurə zɛ a taa, ŋnɩ yaa da m, bɩ jɛ ʊ, ŋn'a mɔdrɔ wɔɔ hʊr, ŋnɩ gan wʊ ma: Sarma m kan tidəər nyisi kɩ, *mɩɩr kɩ. ");
INSERT INTO bib_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bɩ Woso a hɩ ŋ nɩ nɩnnarɛ nɔ ʊ, a ʊ: ŋ b'a ya, ŋnɩ bɔ Hɩrɔɔdɩ zi y. Naa minto bɩ, brɔɔ zaa vanta sa ŋnɩ doo a kʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","A hʊr kʊ ŋ y'a ʊ bɩ, Zuuba malɛɛka a hɩnka Zozɛf m nɩnnarɛ nɔ ʊ, an a hɩ m, a ʊ: «Wuti ɩ nyɩ bɩ gaa kan a da bɩ kɩ, ɩ ɩ si, ɩ ta Eziptɩ ʊ, nyɩnta b'ʊ k'an ta an aa dɔmɩm kʊ mɔɔ n nɩ m yarɛ m meer ba kan ɩbɩɩ kɩ bɩ ku, bala, Hɩrɔɔdɩ y'a kam nyɩ bɩ ma, k'a zɛ.» ");
INSERT INTO bib_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Zozɛf n wuti, an nyɩ bɩ kan a da bɩ kɩ gaa gunuu ʊ, an a hʊr an ta Eziptɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A gɔɔta b'ʊ an ta, an Hɩrɔɔdɩ garɛ ku, kʊ Woso meerbaa k'a ba kan a lɛsinnɩsorazaa lɛ kɩ bɩ n kʊ yɩ. Mɔɔ m Nyɩ bɩ bir, k'an bɔ Eziptɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hɩrɔɔdɩ k'a b'a dɔ a ʊ, hɔdonno wɔɔ a yamba a m bɩ, a wuti nɔmaa gandaara m. A n gʊɔɔ nyɔɔ Betelehɛm ʊ kan kʊrɔ vantɔɔ k'a a so ŋ ʊ rɔ wɔɔ kɩ ʊ, kʊ ŋ n'aa nyɩnɔ poorero yaarɔ kʊ ŋ dɔɔraa hɩɩya gɛɛ ŋ n a ku rɔ wɔɔ zɩnzɛ. Amba hɔdonno wɔɔ a hɩ m, nyɩnta k'a ʊ, an laaka da k'a nyɩ bɩ yɩrɛ dɔmɩm dɔ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Naa ma bɩ, hɔ kʊ wosolɛsinnɩsorazaa Zeremii a hɩ bɩ kʊ yɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","N zeedarɛ ma Ramaa ʊ, nyikəre kan heerzarlɛ gʊta kɩ: Rasɛl nɩ nyi karɛ a nyɩnɔ minto, a lɛ baa kʊ n n'a wɔ zɩnzɛ a nɩ y, nyɩnɔ wɔɔ kʊ ŋ gɩnga bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hɩrɔɔdɩ garɛ jɛ ʊ bɩ, Zuuba malɛɛka a hɩnka Zozɛf m nɩnnarɛ nɔ ʊ Eziptɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","A n meer ba kan kɩ, a ʊ: «Wuti, ɩ nyɩ bɩ kan a da bɩ kɩ gaa ɩ ɩ wusigə, ɩ ta Israyɛl tara ra. Bala, gʊɔɔ kʊ ŋ n'a kam ma k'a nyɩ bɩ meeyaa bɔ ʊ rɔ wɔɔ gɩnga.» ");
INSERT INTO bib_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Zozɛf n wuti, an nyɩ bɩ kan a da bɩ kɩ gaa, an ta Israyɛl ʊ. ");
INSERT INTO bib_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bɩ, Zozɛf k'a a ma, n ʊ, Arkelayus nɩ cirbəə m Zidee ʊ a zɩ Hɩrɔɔdɩ bɩncɛ ʊ bɩ, nyibəə a nyasʊ k'an ta b'ʊ bɩ kɩ, bɩ Woso meer ba kan kɩ nɩnnarɛ nɔ ʊ, an ta Galilee kʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A n aa nyɩnta kʊ kʊ n n'a hɩm ma Nazarɛtɩ ʊ b'ʊ, k'an bɩr yɩrɛ ɩ ʊ hɔ kʊ wosolɛsinnɩsorazannɔ wɔɔ a hɩ bɩ n kʊ yɩ, ŋ ʊ: N y'a birm Nazarɛtɩ gʊaa. ");
INSERT INTO bib_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dɔmɩnnɔ wɔɔ duro ʊ bɩ, Zaan-Batiisi bʊr Zidee poo nɔ ʊ, an nɩ Woso lemim pa dam. ");
INSERT INTO bib_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","A n n'a hɩrɛ, a ʊ: «K'a a bɔ a taam, k'a sugur yɛ, bala, Woso cirbəə b'a zɔ.» ");
INSERT INTO bib_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A mɩŋŋa wosolɛsinnɩsorazaa Ezayii a hɩ ma, a ʊ: Gʊaa leer nɩ bɔm poo nɔ ʊ: k'a Zuuba zaa banka, k'a zaa fɔɔrɛrɔ wɔɔ bɩmbanka kʊ ŋ nɩ yɩ tɩrga. ");
INSERT INTO bib_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zaan bɩ, yoonde ka huu a a du a ma, an kʊmbar sa an a so a ʊ, bɩsɩnɔ kan zɔɔn kɩ n a hɔbɩrɛ. ");
INSERT INTO bib_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A m naa, Zerizalɛm, Zidee kʊ bɩ haay, kɔ k'a tɔ m Zʊrdɛn kʊrɔ wɔɔ haay nɩ tam zi, ");
INSERT INTO bib_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ŋ n'a mimbʊnyaarɔ hɩrɛ, Zaan nɩ batɛm karɛ ŋ ʊ Zʊrdɛn kɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","K'a farizɛɛnrɔ kan sadisɛɛnrɔ kɩ yɩ ŋn'ɩ zɛm gʊta batɛm sire bɩncɛ ʊ bɩ, a a hɩ ŋ nɩ, a ʊ: «Mɩnnɔ kʊsɩrɔ do, nka y'a hɩ awɔɔ m, a ʊ, a a si Woso nɔmaa gʊta k'a nɩ zɛm bɩ lɛɛ? ");
INSERT INTO bib_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","K'a zibəə k'a n'a hɩnkarɛ a ʊ, awɔɔ heerlʊrlɛ yɩ bɩ ba. ");
INSERT INTO bib_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","B'a b'a hɔɔn da a ʊ, awɔɔ zɩ m Abraham nɩ y. Bala, mɔɔ y'a hɩrɛ awɔɔ m, Woso a da ma an jaarɔ nɔɔn duro wusigə an ŋ ba Abraham nyɩnɔ. ");
INSERT INTO bib_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bɩ dɩɩtaa naa, n sɩga banka k'an gɔrɔ zɩnzɛ ra ŋ məsi ma, gɔ niŋŋə k'a bɩr nyɩ mɩŋŋa darɛ y, n y'a zɛm la, n n a da sɛ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Mɔɔ ɩ batɛm karɛ awɔɔ ʊ hi ʊ a heer k'awɔɔ lʊr bɩ minto. Bɩ, an nɩ zɛm mɔɔ jɛ ʊ bɩ paŋŋa lɛ da mɔɔ ra, mɔɔ n m ga m, m a kʊsɔrɔ waa a gannɔ ʊ y, a batɛm karɛ awɔɔ ʊ *Sɛnt-Ɛspri kan sɛ kɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A y'a gʊr m a wɔ ʊ, a y'a tʊyaa waarɛ an a hɔyaa gʊr an a zar sɩ ʊ, bɩ, a sɛ k'a bɩr lihim bɩ nyam puur b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","A m bɩ, Yeezuu n a to Galilee ʊ, an bʊr Zʊrdɛn ʊ Zaan zi, k'a bɩ batɛm si. ");
INSERT INTO bib_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bɩ, Zaan a gu an n'a hɩrɛ, a ʊ: «Ɩbɩɩ y'ɩ ga m, ɩ batɛm ka mɔɔ ʊ, b'ɩbɩɩ ɩ ya, ɩ nɩ zɛm mɔɔ zi!» ");
INSERT INTO bib_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yeezuu n a hɩ m, a ʊ: «A to k'an yɩ ncɩnaaʊ naa ma, bala, naa n'a karɛ, wɔɔ n hɔ haay k'an tɩrga Woso ma bɩ ba.» Zaan n yɛ kɛɛrɛ. ");
INSERT INTO bib_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yeezuu k'a batɛm bɩ si bɩ, a bɔ hi b'ʊ. A m bɩ, brama n a gʊ, an Woso Ɛspri yɩ an nɩ zerle, am cirpʊʊrɛ hɔ bɩ m an bɩ zer la. ");
INSERT INTO bib_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Leer n a to mim ʊ an n'a hɩrɛ, a ʊ: «Ba mɔɔ Nyɩ m na. Mɔɔ ŋʊa gʊta. A mɔɔ nɔ yɩ paan….» ");
INSERT INTO bib_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bɩ jɛ ʊ bɩ, Sɛnt-Ɛspri bɩ ta Yeezuu m poo nɔ ʊ, kʊ Sʊtaana n a gɩnga ma. ");
INSERT INTO bib_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","K'a a lɛ kʊsɩ dɔmɩm busi sinuu ʊ kan a gunuu ʊ kɩ bɩ, nɔ b'a nyasʊ. ");
INSERT INTO bib_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sʊtaana n a zɔ ma, an a hɩ m, a ʊ: «Kʊ Woso Nyɩ n'ɩbɩɩ m, k'ɩ ka kʊ jaarɔ nɔɔn duro n a ba hɔbɩrɛ.» ");
INSERT INTO bib_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bɩ, Yeezuu a nyɩ bɔ nʊ, a ʊ: «N y'a gʊrsɩra ba Wosoci ʊ, n ʊ: Hɔbɩrɛ bɛɛ gʊaa n'a bɩm bala k'a mɩsɩrbaa ba y, bɩ lemim haay k'a nɩ bɔm Woso lɛ ʊ bɩ m.» ");
INSERT INTO bib_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sʊtaana n a gaa an ta m Zerizalɛm ʊ, an a der Wosocɛ bɩ mim ʊ. ");
INSERT INTO bib_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","A n a hɩ m, a ʊ: «Kʊ Woso Nyɩ n'ɩbɩɩ m k'ɩ hɩr ɩ ɩ da tara ʊ, bala, n y'a gʊrsɩra ba, n ʊ: A lɛrɔ karɛ a malɛɛkarɔ ʊ, kʊ ŋ n'ɩbɩɩ busu a wɔrɔ ʊ k'ɩbɩɩ b'ɩ gəm zɛ y.» ");
INSERT INTO bib_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeezuu n a hɩ m, a ʊ: «N y'a gʊrsɩra ba sɔ, n ʊ: Ɩ bɩ da Zuuba ɩ Woso lɛ ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sʊtaana n a ya, an ta m ci gʊta mim ʊ, an durnya cirbəəro kʊrɔ hɩnka m kan ŋ paŋŋa kɩ, ");
INSERT INTO bib_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","an a hɩ, a ʊ: «K'ɩbɩɩ kukurə zɛ mɔɔ taa, ɩ mɔɔ da ʊ, mɔɔ naa haay karɛ ɩbɩɩ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeezuu a nyɩ bɔ nʊ, a ʊ: «Ɩ jɛ bɔ mɔɔ jɩr ʊ, Sʊtaana! Bala, n y'a gʊrsɩra ba, n ʊ: Zuuba Woso y'a deem ɩbɩɩ nɩ yaa dam nɩ, ɩ da ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bɩ jɛ ʊ bɩ, Sʊtaana n a bɔ a jɛ ʊ, lɛɛm bɩ malɛɛkarɔ n bʊr, ŋnɩ bɩ hɔbɩrɛ ka ʊ. ");
INSERT INTO bib_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yeezuu k'a a ma, n ʊ, n Zaan du lɔnnɔcɛ ʊ bɩ, a a hʊr, an ta Galilee ʊ. ");
INSERT INTO bib_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A n gɔɔta Nazarɛtɩ ʊ y. A hʊr a ʊ, an aa nyɩnta Kapɛrnawum ʊ. Kʊ m bɩ, an nɩ Galilee higʊta lɛ ra Zabɩlɔn kan Nɛftalii kɩ kʊrɔ wɔɔ barla. ");
INSERT INTO bib_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yɩ a ʊ ncɩnaaʊ kʊ wosolɛsinnɩsorazaa Ezayii meerbaarɔ nɔɔn duro n kʊ yɩ. ");
INSERT INTO bib_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabɩlɔn tara, Nɛftalii tara, higʊta zaa, kʊrɔ kʊ ŋ nɩ Zʊrdɛn kɔ gəm la kan doro vantɔɔ kʊ ŋ nɩ Galilee ʊ rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Do k'a nɩ monsigə ʊ bɩ lɛɛgure gandaara yɩ, gʊɔɔ kʊ ŋ nɩ zɛ kʊ ʊ kan zɛ hinni kɩ rɔ wɔɔ, lɛɛgure bʊr brɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A n a sa naa ma bɩ, Yeezuu a sɩŋŋɩda sa, an nɩ Woso lemim pa darɛ, an n'a hɩrɛ, a ʊ: «K'a bɔ a taam k'a sugur yɛ: Woso cirbəə b'a zɔ.» ");
INSERT INTO bib_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yeezuu k'a nɩ Galilee higʊta lɛ ra an nɩ tam bɩ, a gʊɔɔ yɩ hɩɩya: Sɩmɔɔn kʊ n n'a birm Pɩyɛɛr kan a danzaa Andɩr kɩ, ŋn'ɩ zaŋŋa zom higʊta b'ʊ, bala, zɔbənno m. ");
INSERT INTO bib_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","A n a hɩ ŋ nɩ, a ʊ: «K'a bʊr a zu mɔɔ ʊ, mɔɔ y'awɔɔ bam gʊɔɔ kama zannɔ.» ");
INSERT INTO bib_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lɛɛm bɩ, ŋ y'a zaŋŋarɔ wɔɔ to, ŋn'ɩ zum Yeezuu ʊ. ");
INSERT INTO bib_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","K'a ta lɛɛ bɩ, a Zakkɩ yɩ kan a danzaa Zaan kɩ, Zebedee nyɩnɔ m ŋn'ɩ kɔɔlʊʊ ʊ kan a zɩ Zebedee bɩ kɩ, ŋn'a zaŋŋarɔ bankam. A n ŋ bir. ");
INSERT INTO bib_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ŋ n a bɔ a zɩ b'ʊ kan kɔɔlʊʊ bɩ kɩ lɛɛm, ŋn'ɩ zure a jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeezuu gasʊ Galilee kʊ b'ʊ haay, an nɩ bɩmbɩrm, an nɩ hɔ dɩndam gʊɔɔ m zɩɩfʊrɔ sokʊmacɛrɔ wɔɔ ʊ, an nɩ Woso cirbəə lemim nyɩnta bɩ pa dam, an nɩ yaaba do haay waam kan kʊsɩ do haay kɩ zamaa bɩ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A tɔ bɔ lɛɛ haay ʊ, an ta kan Siirii kʊ kɩ haay, a m naa, n nɩ zɛm gʊɔɔ kʊ ŋ nɩ cicir bam yaaba do haay kan kʊsɩ do haay nɔ ʊ rɔ wɔɔ kɩ m: Gʊɔɔ kʊ zinəro n ta ŋ nɩ, parparlɔzannɔ, mɛgarɛzannɔ kɩ an ŋ waa. ");
INSERT INTO bib_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Zamaa cir gʊta nɩ zure a jɛ ʊ, a to ŋ y'a ʊ Galilee ʊ, Taraburo ʊ, Zerizalɛm kan Zidee kɩ, kan Zʊrdɛn kɔ gəm la kɩ. ");
INSERT INTO bib_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yeezuu k'a zamaa bɩ yɩ bɩ, a der ci burə ʊ, an nyɩnta. A karɩndanyɩnɔ wɔɔ n a zɔ ma. ");
INSERT INTO bib_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A n a sɩŋŋɩda sa, an nɩ hɔ dɩndarɛ ŋ nɩ, an n'a hɩrɛ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Mimbirenyɩntazannɔ m mɩŋŋazerlezannɔ m: Ŋ hɔ m Woso cirbəə bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mimbirenyɩntazannɔ m gʊɔɔ bʊgʊ-bʊgʊdɔɔ wɔɔ m: Ŋ y'a hɔjirle yɩm durnya ʊ. ");
INSERT INTO bib_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mimbirenyɩntazannɔ m nyikərezannɔ m: Woso bra barɛ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mimbirenyɩntazannɔ m gʊɔɔ kʊ tɩrgabaa nɔ nɩ ŋ zɛm kan mɩsɩ kɩ rɔ wɔɔ m: Hɔ yɩ ŋ kam. ");
INSERT INTO bib_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mimbirenyɩntazannɔ m cicirzɛrɛzannɔ m: Woso yɩ ŋ cicir zɛrɛ. ");
INSERT INTO bib_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mimbirenyɩntazannɔ m heerhuzannɔ m: Ŋ Woso yɩrɛ. ");
INSERT INTO bib_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mimbirenyɩntazannɔ m gʊɔɔ kʊ ŋ n'a kam kʊmarɛ ma rɔ wɔɔ m: Woso yɩ ŋ birle a nyɩnɔ. ");
INSERT INTO bib_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mimbirenyɩntazannɔ m gʊɔɔ kʊ ŋ nɩ cicir bam tɩrgabaa tɔ ma rɔ wɔɔ m: Ŋ hɔ m Woso cirbəə bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mimbirenyɩntazannɔ n'awɔɔ m, kʊ n y'awɔɔ sʊnsɔ wʊrɛ, n nɩ cicir karɛ awɔɔ ma, n nɩ ŋʊaar do haay karɛ awɔɔ ra mɔɔ minto, ");
INSERT INTO bib_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","k'a heer nyɔɔ heernyɔɔ gʊta m, bala, awɔɔ ganwʊrɛ gʊta yɩm arzana ʊ. A ba n y'a ʊ ncɩnaaʊ wosolɛsinnɩsorazannɔ kʊ ŋ lɛɛ ka awɔɔ m nɔ wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Durnya yɛ n'awɔɔ m. Bɩ, kʊ yɛ nyɩntabaa bɔ, n y'a bam lɔ, k'a a ya, a nyɩntabaa ka ʊ? A zibəə ba ʊ dɔ y, a lo n nawʊm garga ra, gʊɔɔ nɩ tʊntɔm la.» ");
INSERT INTO bib_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Durnya lɛɛgure n'awɔɔ m, kʊ k'a nɩ zigi burə ʊ bɩ b'a dam ma, an a nyaakʊm da y. ");
INSERT INTO bib_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kʊ gʊaa sɛ nya fɩtɩrɛ ʊ a bɩr a cɩntam kasɩ taa y, a cɩnta a tɩr a ʊ hɔ burə ʊ an cɛ bɩ gu gʊɔɔ kʊ ŋ nɩ b'ʊ haay rɔ wɔɔ daahan minto. ");
INSERT INTO bib_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bɩ, k'awɔɔ lɛɛgure n yɔ ncɩnaaʊ gʊɔɔ mɩm ʊ, kʊ ŋ n'a lɛ bɔ awɔɔ Zɩ k'a nɩ arzana ʊ b'ʊ, awɔɔ zibəəro mɩŋŋɔɔ kʊ ŋ yɩ ŋ yɩ rɔ wɔɔ minto.» ");
INSERT INTO bib_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«A b'a hɔɔn da a ʊ, bʊr mɔɔ ʊ kʊ m bɩ Moyiisi lɛ, gɛɛ, wosolɛsinnɩsorazannɔ wɔɔ n a hɩ rɔ wɔɔ zar y. Mɔɔ n bʊr kʊ m bɩ ŋ zar y, bʊr mɔɔ ʊ kʊ ŋ nɩ kʊ yɩ. ");
INSERT INTO bib_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, an lɛɛ ka kʊ tara kan brama kɩ n cem bɩ, Woso lɛ bɩ nyɩ deem bɩ bɩ cenle y, a jɩ deem bɩ cenim sɔ y, kʊ nawɔnnɔ haay n bɔkarɛ an kʊ yɩ. ");
INSERT INTO bib_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Naa minto bɩ, kʊ gʊaa bɩsɩ ka Woso lɛ bɩ poore deem taan… ma an a dɩnda gʊɔɔ m kʊ ŋ n'a ba maam sɔ, a zaa bɩ do bir n nawʊm gʊɔɔ wɔɔ haay poore Woso cirbəə b'ʊ. Bɩ gʊaa k'a zu lɛrɔ wɔɔ ʊ, an a dɩnda gʊɔɔ m ŋn'a ba maam sɔ bɩ, bɩ zaa nyɩntam gʊta Woso cirbəə b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kʊ m sɩra hɩ awɔɔ m. K'awɔɔ tɩrgabaa n cem wosocikarɩnsaambɔɔ wɔɔ kan farizɛɛnrɔ wɔɔ tɩrgabaa kɩ han, awɔɔ bɩ gasʊm Woso cirbəə ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Awɔɔ ma n n a hɩ wɔɔ yaabɔɔ m, n ʊ: ‹Ɩ bɩ gər zɛ y›, kʊ gʊaa a mim meeyaa bɔ ʊ, a a ga m, kʊ n n ta m dʊdɔkənno taa. ");
INSERT INTO bib_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bɩ mɔɔ y'a hɩrɛ awɔɔ m: Kʊ gʊaa nɔmaa ba kan a mim kɩ, a a ga m, kʊ n n ta a zaa m dʊdɔkənno taa. Kʊ gʊaa a hɩ a mim m, a ʊ: ‹Hɔɔnwarzaa›, a a ga m, kʊ n n ta a zaa m dʊdɔkənno jɩtannɔ taa. Kʊ gʊaa a hɩ a mim m, a ʊ: ‹hɔɔzaa›, a ga a ʊ m k'an ta sɛhar ʊ. ");
INSERT INTO bib_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Naa minto bɩ, k'ɩbɩɩ ta Wosocɛ ʊ k'ɩ yaa ganwʊrɛ ka Woso ʊ, ɩ bɔkarɛ ɩ tɔ da ɩ nɔ ʊ, ɩ ʊ, ɩ ɩ zar ɩ mim ma, ");
INSERT INTO bib_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","k'ɩ ganwʊrɛ bɩ to Wosocɛ ʊ b'ʊ, ɩ ta ɩ yaa n'ɩ zɛ kʊ ra kan ɩ mim bɩ kɩ, k'ɩ bɔkarɛ ɩ ɩ wusigə ɩ bʊr, ɩ b'ɩ ganwʊrɛ bɩ ka Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","K'ɩbɩɩ jɩm ɩ tarɛ ɩ m dʊdɔkarɛ bɩncɛ ʊ, k'ɩ tɔ ʊ, a kʊ ma zaa ra. K'a n yɩ ncɩnaaʊ y, a y'ɩ kam dʊdɔkər ʊ, dʊdɔkər bɩ n ɩ ka lɔnnɔdɔmazannɔ ʊ, ŋn'ɩ du lɔnnɔcɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sɩra mɔɔ n'a hɩrɛ ɩbɩɩ m: Ɩbɩɩ bɩ bɔm b'ʊ k'ɩbɩɩ n ɩ zɩm bɩ ka haay y, bɩ tanka deem taan… bɩ gɔɔtarɛ y.» ");
INSERT INTO bib_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Awɔɔ ma, n ʊ: ‹Ɩ bɩ jaan da y.› ");
INSERT INTO bib_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bɩ mɔɔ y'a hɩrɛ awɔɔ m: Kʊ gʊaa dɩga lʊ ma a hɔɔn n ta zi, a jaan da kan kɩ a heer ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","«K'ɩ bɩsɩ mɩnyaa bɩ y'ɩ dam mimbʊnyaa barɛ ma, k'ɩ bɔ ʊ, ɩ zo laatʊ ɩ ma. Bala, a jɩra k'ɩ mɛ vəŋŋə deem n a zaar ba, k'ɩ mɛ bɩ haay bɩ ta sɛhar ʊ y. ");
INSERT INTO bib_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bɩ, k'ɩ bɩsɩ wɔ bɩ y'ɩ dam mimbʊnyaa barɛ ma, k'ɩ zɛ ra ɩ zo laatʊ ɩ ma. A jɩra k'ɩ mɛ vəŋŋə deem n a zaar ba, k'ɩ mɛ bɩ haay bɩ ta sɛhar ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«N y'a ya, n n a hɩ sɔ, n ʊ: ‹Kʊ gʊaa la a lʊ ra k'an wɔsaalʊmaci ka ʊ.› ");
INSERT INTO bib_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bɩ mɔɔ y'a hɩrɛ awɔɔ m: Kʊ gʊaa la a lʊ ra, bɩ jaan bɛɛ a a da y, lʊ bɩ da an nawʊm jaandarɛ ma. Bɩ, kʊ gʊaa lʊ k'a gʊ a zim ma sa, jaan a da.» ");
INSERT INTO bib_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Awɔɔ ma, n n a hɩ wɔɔ yaabɔɔ m, n ʊ: ‹Ɩ bɩ ɩ lerbɔrɛ to y, b'a ka kʊ hɔ k'ɩbɩɩ ler bɔ Zuuba m ɩ ɩ wer si bɩ n kʊ yɩ.› ");
INSERT INTO bib_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bɩ mɔɔ y'a hɩrɛ awɔɔ m, a b'a wer si fɩɩga y: A b'a wer si brama tɔ nɩ y, bala, Woso cirbəəduu m bɩ. ");
INSERT INTO bib_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","A b'a wer si tara tɔ nɩ y, bala, a gam cɩntarahɔ m bɩ, a b'a wer si Zerizalɛm tɔ nɩ y, bala, cir gʊta bɩ kʊ m bɩ. ");
INSERT INTO bib_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ɩ b'ɩ wer si ɩ mim tɔ nɩ y, bala ɩbɩɩ b'ɩ dam ma ɩ ka minkə deem n a ba kunkum gɛɛ fu y. ");
INSERT INTO bib_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","K'awɔɔ ɩ meer barɛ, kʊ ɩɩn… m, k'a hɩ, a ʊ: ɩɩn… m. Kʊ ayy… m, k'a hɩ, a ʊ: ayy… m. Meerbaa k'a n'a nam ma bɩ, a to a ʊ a Bʊnyaabarɛzaa bɩ zi.» ");
INSERT INTO bib_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Awɔɔ ma, n n a hɩ, n ʊ: ‹Mɩnyaa nɩ sompim mɩnyaa bɩncɛ ʊ, sɔ nɩ sompim sɔ bɩncɛ ʊ.› ");
INSERT INTO bib_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bɩ mɔɔ y'a hɩrɛ awɔɔ m, kʊ gʊaa a ba awɔɔ m bʊnyaa, a b'a bʊnyaa ba m sɔ y. Bɩ, kʊ gʊaa a wɔ ta ɩ bɩsɩ paasɩ rɛ, k'ɩ ɩ jɩsa paasɩ bɩ ka ʊ k'an a ta rɛ. ");
INSERT INTO bib_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kʊ gʊaa ʊ, k'a dʊdɔ ka kan ɩ kɩ, k'a ɩ huudaara yɔ ɩ m, k'ɩ to k'an ɩ huukuurə sa sɔ. ");
INSERT INTO bib_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kʊ gʊaa paŋŋa ba ɩ ma, k'a ɩ da tarɛ ma ganjɩbɔʊrɛ tisi kan a kɩ, k'ɩ ta ganjɩbɔʊrɛ tisi hɩɩya kan kɩ. ");
INSERT INTO bib_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kʊ gʊaa hɔ yɛ ɩ han, k'ɩ ka ʊ. Kʊ gʊaa ʊ, k'a zɩm sa ɩ zi, ɩ bɩ ɩ gu han y.» ");
INSERT INTO bib_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Awɔɔ ma, n n a hɩ, n ʊ: ‹K'ɩ ɩ gʊaa ŋʊa, k'ɩ sɔ ɩ jɩm m.› ");
INSERT INTO bib_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bɩ mɔɔ y'a hɩrɛ awɔɔ m: K'a a jɩnnɔ ŋʊa, k'a yaa da Woso m gʊɔɔ kʊ ŋ nɩ fɩr karɛ awɔɔ ma rɔ wɔɔ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ncɩnaaʊ bɩ, awɔɔ yɩm awɔɔ Zɩ k'a nɩ arzana ʊ bɩ nyɩnɔ paan…rɔ. Bala, a a ka woso nɩ gum gʊɔɔ bʊnyaarɔ wɔɔ ra kan gʊɔɔ mɩŋŋɔɔ wɔɔ kɩ. A a ka sɔ, la nɩ bam gʊɔɔ mɩŋŋɔɔ ra kan gʊɔɔ bʊnyaarɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bɩ, k'awɔɔ ɩ gʊɔɔ kʊ ŋ n'awɔɔ ŋʊam nɔ wɔɔ ŋʊarɛ, a nyɔɔdʊ ɩ ka? Bala, yawʊrsinno wɔɔ y'a barɛ ncɩnaaʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Bɩ, k'awɔɔ ɩ yaa darɛ a danyɩnɔ m bala, bɔ awɔɔ n'a bam, an nɩ yɩrɛ a hɔ? Kɩfɩɩrɔ wɔɔ bɩr a barɛ ncɩnaaʊ sɔ ra? ");
INSERT INTO bib_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","K'a maam, k'a yɩ mɩŋŋa paan… amba awɔɔ Zɩ k'a nɩ arzana ʊ n mɩŋŋa paan… bɩ m.» ");
INSERT INTO bib_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«A b'a ka k'a a zibəəro mɩŋŋɔɔ ba, kʊ gʊɔɔ n dɩga a ma y. K'awɔɔ ŋ ba kʊ ŋ nɩ dɩga a ma, awɔɔ bɩ ganwʊrɛ yɩm awɔɔ Zɩ k'a nɩ arzana ʊ bɩ zi y. ");
INSERT INTO bib_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","K'ɩbɩɩ ɩ hɔ kam cicirzaa ʊ, ɩ bɩ hɔ ba kʊ gʊaa haay n a dɔ, ŋ ʊ, ɩbɩɩ ɩ hɔ kam gʊaa ʊ, amba zambʊzannɔ kʊ ŋ n'a bam sokʊmacɛrɔ ʊ kan zaa birero ʊ kɩ, kʊ gʊɔɔ n a lɛ bɔ a ʊ rɔ wɔɔ nɩ y. Mɔɔ y'a hɩrɛ awɔɔ m, ŋ y'a ganwʊrɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","B'ɩbɩɩ, k'ɩ ɩ gan wʊrɛ, k'ɩ jɩsa wɔ bɩ bɩ hɔ k'ɩ bɩsɩ wɔ n'a bam bɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","K'ɩ ganwʊrɛ bɩ nyaakʊm da ɩ ka, ɩ Zɩ k'a nɩ hɔ nyaakʊndarɛ yɩm bɩ ganwʊrɛ karɛ ɩ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«K'awɔɔ ɩ yaa darɛ, a bɩ yɩ am zambʊzannɔ hɔ bɩ nɩ y. Kʊ ŋ lɛ n taa kʊ gʊɔɔ n a yɩ bɩ, jɩm ŋ tɩr a ʊ sokʊmacɛrɔ wɔɔ ʊ, kan zaarɔ zɛkʊrajɩrɔ kɩ ʊ, ŋn'ɩ bɩr yaa darɛ. Mɔɔ y'a hɩrɛ awɔɔ m, sɩra m, ŋ y'a ganwʊrɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","B'ɩbɩɩ, k'ɩ lɛ taa kɩ yaa da, gasʊ ɩ cɛ ʊ ɩ lɛ ta, ɩ yaa da ɩ Zɩ Woso k'a nɩ b'ʊ bɩ m, b'ɩbɩɩ Zɩ k'a nɩ lɛɛ k'a nyaakʊm da bɩ yɩm bɩ, a y'ɩbɩɩ zibəə k'ɩbɩɩ nyaakʊm da bɩ ganwʊrɛ karɛ ɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","K'awɔɔ ɩ yaa darɛ, a bɩ meer ba gʊta am kɩfɩɩrɔ hɔ bɩ nɩ y. A hɔɔn ŋn'a darɛ, ŋ ʊ, k'a meer ba gʊta, Woso y'a yaadarɛ mam. ");
INSERT INTO bib_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A b'a ba am ŋ hɔ bɩ nɩ y. Bala, awɔɔ Zɩ Woso bɩ lɛɛ ka an hɔ k'awɔɔ lɛ n taa bɩ dɔ, awɔɔ n bɔkarɛ, an n'a yɛm han.» ");
INSERT INTO bib_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«K'awɔɔ k'a yaa da, k'a da ncɩnaaʊ: Wɔɔ Zɩ k'a nɩ arzana ʊ, k'ɩ tɔ n lɛbɔʊrɛ yɩ, ");
INSERT INTO bib_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","k'ɩ cirbəə n bʊr, k'ɩ hɔɔnhɔ n ba tara burə ʊ, amba an nɩ bam arzana ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Wɔɔ her hɔbɩrɛ ka wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wɔɔ kʊrɔmarɔ sugur ka wɔɔ ʊ, amba wɔɔ n'ʊ muno kʊrɔmarɔ sugur karɛ ŋ ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Dɔ wɔɔ ma k'ʊ bɩ yɛ ʊ ʊ do makra bʊnyaa nɔ ʊ y, bɩ wɔɔ yɔ Bʊnyaabarɛzaa bɩ wɔ ʊ. Bala, ɩbɩɩ y'ɩ so cirbəə ʊ kan paŋŋa kɩ, lɛbɔʊrɛ kɩ dɔɔraa k'a nyarɛ ba ʊ nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Kʊ sɩra nɩ, k'awɔɔ gʊɔɔ kʊrɔmarɔ sugur ka ŋ ʊ, awɔɔ Zɩ k'a nɩ arzana ʊ bɩ sugur karɛ awɔɔ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bɩ, k'awɔɔ bɩr sugur kam gʊɔɔ ʊ, awɔɔ Zɩ k'a nɩ arzana ʊ bɩ b'awɔɔ kʊrɔmarɔ sugur karɛ awɔɔ ʊ sɔ y.» ");
INSERT INTO bib_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«K'awɔɔ y'a lɛ kʊsɩrɛ, a bɩ tɩr a meer zɩnzar kʊ ʊ, am zambʊzannɔ hɔ bɩ nɩ y. A meer ŋ tɩr a zɩnzar kʊ ʊ, kʊ gʊɔɔ n a dɔ, ŋ ʊ, a a lɛ kʊsɩ. Sɩra mɔɔ n'a hɩrɛ awɔɔ m: ŋ y'a ganwʊrɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","K'ɩbɩɩ y'ɩ lɛ kʊsɩrɛ, k'ɩ hi da ɩ meer ʊ, ɩ tidəər zɛ ɩ mim ma, ");
INSERT INTO bib_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kʊ gʊɔɔ b'a dɔ, ŋ ʊ, ɩ lɛ ɩ kʊsɩ y. Bɩ, k'ɩ Zɩ k'a nɩ lɛɛ k'a nyaakʊm da ʊ bɩ n a dɔ a deem. B'a y'ɩ ganwʊrɛ karɛ ɩ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«A b'a ka arzaka ma durnya burə ʊ naa ʊ y. Bala, bɛɛ kan muku kɩ y'a zarm, konno ɩ cɛlɛ yarm, ŋn'a sarɛ. ");
INSERT INTO bib_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bɩ k'ɩ ka arzana arzaka ma. Bala, muku kan bɛɛ kɩ ba b'ʊ k'a zar y, konno ba b'ʊ k'a cɛlɛ yar, k'a sa y. ");
INSERT INTO bib_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bala, lɛɛ k'ɩ arzaka n ta ʊ b'ɩ heer n ta ʊ sɔ.» ");
INSERT INTO bib_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Mɛsim fɩtɩrɛ m mɩnyaa m. K'ɩ mɩnyaa mɩŋŋa ɩbɩɩ mɛ bɩ haay ɩ lɛɛgure ʊ. ");
INSERT INTO bib_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bɩ k'ɩ mɩnyaa bɩ mɩŋŋa y, ɩbɩɩ mɛ bɩ haay nyɩntam monsigə ʊ. K'a ɩ yɩrɛ ɩ ʊ, lɛɛgure k'ɩbɩɩ n ta m bɩ monsigə nɩ, monsigə bɩ do yɩm gʊta bidə.» ");
INSERT INTO bib_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Gʊaa ba ʊ an b'a dam ma, an zuubɔɔ hɩɩyɔɔ zi ba y. A deem ŋʊam, an sɔ deem m, gɛɛ, an a zɛ kʊ ra kan deem kɩ, an kaanm deem m. Awɔɔ b'a dam ma, a zu Woso ʊ, k'a a ya, a zu busoo ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Bɩ y'a ka, mɔɔ n'a hɩrɛ awɔɔ m: a b'a heer kɔ a mɩsɩrbaa bɩ hɔbɩrɛ mim ma y. B'a b'a heer kɔ huu mim ma sɔ y. Mɩsɩrbaa n lɛ da hɔbɩrɛ m na? Mɛsim bɩ n lɛ da huu m na? ");
INSERT INTO bib_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","K'a dɩga bɛnnɔ ma: ŋ bɩr hɔ duure y, bɩ ŋ bɩr hɔ darɛ y, ŋ bɩr hɔ zarm sɩ ʊ y, b'awɔɔ Zɩ k'a nɩ arzana ʊ bɩ yɩ ŋ tʊrm! Awɔɔ n lɛ da ŋ nɩ gallɛm hɔka ra? ");
INSERT INTO bib_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nka n'a dam ma, an a mɩsɩrbaa da ra poore tɔkkɛ a hɔɔn k'a n'a dam ma gʊta minto? ");
INSERT INTO bib_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Bɔ y'a ka, awɔɔ n'a heer kɔm huu mim ma? K'a dɩga pooyaa hɔvuro ma, ŋ yɩ mam, bɩ ŋ bɩr zi barɛ, bɩ ŋ bɩr huu barɛ y. ");
INSERT INTO bib_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bɩ mɔɔ ʊ kʊ m a hɩ awɔɔ m, Salomɔɔn mɩŋŋa, b'a kan a cirbəə bɩ kɩ, a n huu du a ma, am ŋ deem hɔ bɩ nɩ y. ");
INSERT INTO bib_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bɩ, kʊ Woso ɩ huu dum pooyaa bur ma ncɩnaaʊ, bɩ ta an a ʊ her kʊ sɛ n b'a bɩ booti m, a bɩ huu dure awɔɔ ma an lɛ da brɔɔ m na? Sɩrakarɛ poore zannɔ! ");
INSERT INTO bib_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","K'a maam, a b'a heer kɔ a bɩr a hɩrɛ, a ʊ: Bɔ wɔɔ n'a bɩrɛ? Bɔ wɔɔ n'a mire? Bɔ wɔɔ n'a dure ʊ ma? ");
INSERT INTO bib_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Naa do haay kɩfɩɩrɔ wɔɔ n'a karɛ ŋ ma kʊsɩ-kʊsɩ, b'awɔɔ Zɩ k'a nɩ arzana ʊ b'a dɔ, a ʊ, awɔɔ lɛ taa ŋ ma. ");
INSERT INTO bib_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","K'a lɛɛ ka a ka Woso cirbəə bɩ ma, kan a tɩrgabaa kɩ. Maam bɩ, Woso hɔ k'a gɔɔta bɩ karɛ awɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Naa minto bɩ, a b'a heer kɔ booti mim ma y. Booti dɩgarɛ a mɩŋŋa mim ma. Dɔmɩm biyəə y'a mɩŋŋa mim m.» ");
INSERT INTO bib_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«A bɩ gʊaa dʊdɔ yar y, kʊ Woso b'a dʊdɔ yar y. ");
INSERT INTO bib_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","K'awɔɔ gʊaa dʊdɔ yar lʊnlɔ, awɔɔ dʊdɔ yar n nawʊm maam sɔ, hɔganhɔ k'awɔɔ n ta m gʊɔɔ minto bɩ, bɩ nɩ nyɩntam hɔganhɔ awɔɔ minto sɔ. ");
INSERT INTO bib_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","A lɔ ɩbɩɩ nɩ bur k'a n'ɩ mim mɩm ʊ bɩ yɩrɛ, an bɔkarɛ kusə n'ɩbɩɩ mɩm ʊ, b'ɩ bɩr a yɩrɛ? ");
INSERT INTO bib_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ɩbɩɩ y'a bam lɔ, ɩ hɩ ɩ danyɩ m, ɩ ʊ, jɩm kʊ m bur bɔ ɩ mɩm ʊ, an bɔkarɛ kusə n'ɩbɩɩ mɩm ʊ! ");
INSERT INTO bib_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Zambʊzaa, kusə bɩ bɔ ɩ mɩm ʊ cɩna, k'ɩ dɔ ɩ lɛɛ yɩ mɩŋŋa, ɩ bur bɩ bɔ ɩ danyɩ bɩ mɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","A bɩ hɔ mɩŋŋa ka jino ʊ y, kʊ n bɛɛ m, ŋ y'a bɔrɛ, ŋn'awɔɔ bɩ. A bɩ hɔ wɩsɩ sa a ka kurkuuro ʊ y, kʊ n bɛɛ m, ŋ tʊntɔm la. ");
INSERT INTO bib_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","K'a hɔ yɛ, n y'a karɛ awɔɔ ʊ. K'awɔɔ a ka ma, awɔɔ y'a yɩm. K'awɔɔ cɛlɛ zɛ, n y'a gʊrɛ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bala, kʊ gʊaa hɔ yɛ, a y'a yɩm. K'a a ka ma, a y'a yɩm. Kʊ gʊaa cɛlɛ zɛ, n y'a gʊm nɩ. ");
INSERT INTO bib_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Gʊaa y'awɔɔ bire ʊ a nyɩ nɩ bur yɛm han, an jaa ka ʊ ra? ");
INSERT INTO bib_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Gɛɛ, k'a zɔ yɛ han, a mɩm kaŋ ʊ ra? ");
INSERT INTO bib_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Awɔɔ k'an bʊnyaa ncɩnaaʊ a bɔkarɛ a hɔɔ mɩŋŋɔɔ ka a nyɩnɔ ʊ dɔ, awɔɔ Zɩ k'a nɩ arzana ʊ bɩ bɛɛ lɛ da ra? A hɔɔ mɩŋŋɔɔ kam gʊɔɔ kʊ ŋ n'a yɛm han rɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ncɩnaaʊ bɩ, hɔ k'awɔɔ lɛ n taa haay kʊ gʊɔɔ n a ba awɔɔ m bɩ, k'a ba ŋ nɩ sɔ. Moyiisi lɛrɔ wɔɔ haay kan wosolɛsinnɩsorazannɔ wɔɔ ciro wɔɔ kɩ a hɩ. ");
INSERT INTO bib_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","K'a gasʊ cɛlɛ fɔɔrɛ bɩ m, bala, cɛlɛ gʊta bɩ kan zaa zanta bɩ kɩ bɩ, ta ŋ nawʊm nyaanlɛ bɩncɛ ʊ. Gʊɔɔ gʊta yɩ ŋ sam. ");
INSERT INTO bib_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bɩ, cɛlɛ fɔɔrɛ bɩ kan zaa kʊsɩ bɩ kɩ bɩ, ta ŋ nawʊm mɩsɩrbaa bɩncɛ ʊ. Gʊɔɔ kʊ ŋ nɩ ŋ yɩm nɔ wɔɔ bɩ gʊta y. ");
INSERT INTO bib_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","K'a dundo a zi kan ŋʊaarlɛsinnɩsorazannɔ wɔɔ kɩ, bʊr ŋ tɩr a ʊ awɔɔ zi, am seero hɔ bɩ m, an bɔkarɛ poojino kʊsɩrɔ m. ");
INSERT INTO bib_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ŋ zibəəro awɔɔ nɩ ŋ dɔm ma. N bɩr tʊgɔ nyɩ nɔm laa gɔ ra y, n bɩr sɔɔn nyɩ nɔm laazankʊrɛ ra y. ");
INSERT INTO bib_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Gɔ mɩŋŋa bɩ, nyɩ mɩŋŋa an n'a dam, gɔ bʊnyaa bɩ, nyɩ bʊnyaa an n'a dam sɔ. ");
INSERT INTO bib_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gɔ mɩŋŋa b'a dam ma an nyɩ bʊnyaa da y, gɔ bʊnyaa b'a dam ma, an nyɩ mɩŋŋa da sɔ y. ");
INSERT INTO bib_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Gɔ haay k'a bɩr nyɩ mɩŋŋa dam bɩ, a zɛ n nawʊm la, n n'a dam sɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ncɩnaaʊ bɩ ŋ zibəəro awɔɔ nɩ ŋ dɔm ma. ");
INSERT INTO bib_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Gʊaa haay k'a n'a hɩm mɔɔ ma: ‹Zuuba, Zuuba› bɩ bɛɛ nɩ gasʊm Woso cirbəə ʊ y. Bɩ, gʊɔɔ kʊ ŋ nɩ mɔɔ Zɩ k'a nɩ arzana ʊ bɩ hɔɔnhɔ bam nɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Dʊdɔkarɛ hinni ʊ, gʊɔɔ gʊta y'a hɩrɛ: ‹Zuuba, Zuuba, ɩbɩɩ tɔ minto, wɔɔ Woso lɛ si ʊ so ra. Ɩbɩɩ tɔ ma wɔɔ la zinəro ra. Wɔɔ hoserlo ba gʊta ɩbɩɩ tɔ minto.› ");
INSERT INTO bib_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bɩ mɔɔ y'a hɩrɛ ŋ nɩ, mɔɔ ʊ: ‹Mɔɔ n awɔɔ dɔ fɩɩga y. K'a a hʊr mɔɔ jɩr ʊ, mimbʊnyaabənno!› ");
INSERT INTO bib_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ncɩnaaʊ bɩ, gʊaa k'a nɩ mɔɔ meerbaa kʊ mɔɔ ba naa mam bɩ, an nɩ zi bam nɩ bɩ, bɔ a ʊ kʊ ʊ kan gʊaa k'a hɔɔn n ta ʊ, an a cɛ dɔ ci burə ʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","La n ba, hi n yar, hɩnhɛr n hɔn kan paŋŋa kɩ, an a mom cɛ b'ʊ, a n a da y. Bala, a jɩr bɩ da n y'a ʊ ci burə ʊ. ");
INSERT INTO bib_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Bɩ gʊaa k'a nɩ mɔɔ meerbaa kʊ mɔɔ ba naa mam b'a bɩr zi bam nɩ bɩ, gʊaa bɩ do bɔ a ʊ kʊ ʊ kan gʊaa yarma k'a cɛ dɔ nyɩntaa burə ʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","La n ba, hi n yar, hɩnhɛr n hɔn kan paŋŋa kɩ, an a mom cɛ b'ʊ, cɛ bɩ n wurgə, a hɔsɩ n gɔɔta y.» ");
INSERT INTO bib_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yeezuu k'a hɔ dɩnda ncɩnaaʊ an a nya bɩ, gʊɔɔ cir gʊta kʊ ŋ nɩ b'ʊ rɔ wɔɔ zɛ kədə a hɔdɩndarɛ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Bala, Yeezuu bɩr hɔ dɩndarɛ am ŋ wosocikarɩnsaambɔɔ wɔɔ hɔ bɩ nɩ y. Woso paŋŋa an nɩ hɔ bɩ dɩndam nɩ. ");
INSERT INTO bib_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yeezuu k'a a to ci bɩ mim ʊ bɩ, gʊɔɔ cir gʊta zu a jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kusimə n b'a zɔ ma, an kukurə zɛ a taa, an a hɩ m, a ʊ: «Zuuba, k'ɩ lɛ taa, ɩ ɩ da ma, ɩ mɔɔ waa, ɩ dintim naa do gʊ mɔɔ ma.» ");
INSERT INTO bib_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeezuu n a wɔ hʊr, an a da ma, an a hɩ, a ʊ: «Mɔɔ lɛ taa, ɩ waa. Kʊ dintim bɩ n gʊ ɩ ma.» Lɛɛm bɩ, a kusiməbaa bɩ nya ma. ");
INSERT INTO bib_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","A m bɩ, Yeezuu n a hɩ m, a ʊ: «Ɩ b'a hɩ gɔsɩ nɩ y, bɩ ta ɩ yaa n'ɩ hɩnka wosocɛmannɩbər bɩ m, k'ɩ ganwʊrɛ kʊ Moyiisi lɛ ka kʊ n n a ba bɩ ka, k'an nyɩnta ɩbɩɩ waarɛ bɩ kasɛtɩ gʊaa haay minto.» ");
INSERT INTO bib_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yeezuu k'a nɩ gasʊm Kapɛrnawum ʊ bɩ, sʊrdaarɔ cir bʊr zi, an a hɩ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Zuuba, mɔɔ zibəənyɩ nɩ wʊtam har ʊ, a mɛ n ga, an nɩ fɩr yɩm gʊta.» ");
INSERT INTO bib_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeezuu n a hɩ m, a ʊ: «Mɔɔ tam, m aa a waa.» ");
INSERT INTO bib_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bɩ sʊrdaarɔ cir b'a nyɩ bɔ ʊ, a ʊ: «Zuuba, mɔɔ n m ga m, k'ɩbɩɩ n gasʊ mɔɔ har ʊ y, meerbaanyɩ ba deem bala, mɔɔ zibəənyɩ bɩ y'a waam! ");
INSERT INTO bib_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Lɛɛzannɔ y'a so mɔɔ mɩŋŋa ʊ, mɔɔ nɩ m so sʊrdaarɔ ʊ. Kʊ mɔɔ hɩ deem m, mɔɔ ʊ: ‹Ta!›, b'a ta. Kʊ mɔɔ hɩ a vanta m, mɔɔ ʊ: ‹Bʊr!›, b'a bʊr. Kʊ mɔɔ m ya, m a hɩ m zibəənyɩ m, mɔɔ ʊ: ‹Naa ba!›, b'a a ba.» ");
INSERT INTO bib_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yeezuu k'a naa ma bɩ, a dɩga gʊaa bɩ ma, an zɛ kədə, an a hɩ gʊɔɔ kʊ ŋ nɩ zum kʊ ʊ kan kɩ rɔ wɔɔ m, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m, mɔɔ n sɩrakarɛ naa do lɔɔ yɩ Israyɛl gʊaa zi y. ");
INSERT INTO bib_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A hɩ mɔɔ n nawʊrɛ awɔɔ m, gʊɔɔ y'a tom gʊta dɔjɩr ʊ kan meer kɩ ŋnɩ bɩ nyɩnta kan Abraham kɩ Izakkɩ kɩ, Zakɔɔb kɩ, ŋnɩ hɔ bɩ Woso cirbəə b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Gʊɔɔ kʊ n lɛɛ ka n ŋ bɔ ʊ Woso cirbəə bɩ minto rɔ wɔɔ, n brɔɔ nyɔɔm garga ra monsigə ʊ. Nyikəre kan sɔsʊrɛ kɩ nyɩntam b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Meerbaa naa do jɛ ʊ, Yeezuu a hɩ sʊrdaarɔ cir bɩ m, a ʊ: «Doo har ʊ, k'an ba ɩbɩɩ m, amba ɩbɩɩ sɩra ka mɔɔ ʊ bɩ m.» Wakatɩ bɩ do ʊ lɛɛm bɩ, zibəənyɩ b'a waa. ");
INSERT INTO bib_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yeezuu k'a gasʊ Pɩyɛɛr har ʊ bɩ, a Pɩyɛɛr dində yɩ an nɩ wʊtam mɛmarɛ m. ");
INSERT INTO bib_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A n a wɔ da a wɔ ma mɛmarɛ bɩ n bɔ a mɛ ʊ, an wuti an nyasʊ Yeezuu m. ");
INSERT INTO bib_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yirbəə k'a da bɩ, n bʊr gʊɔɔ m gʊta zinəro n ta ŋ nɩ. Yeezuu meer ba bala an la zinəro wɔɔ ra, an yaabazannɔ wɔɔ waa haay. ");
INSERT INTO bib_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yɩ a ʊ ncɩnaaʊ, kʊ hɔ kʊ wosolɛsinnɩsorazaa Ezayii a hɩ bɩ n kʊ yɩ. A a hɩ, a ʊ: A ɩ hɔ haay k'a nɩ fɩr kam wɔɔ mɛsim ma bɩ sa, an wɔɔ yaabarɔ gʊ wɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yeezuu k'a gʊɔɔ cir gʊta yɩ, ŋnɩ bɩr a ma bɩ, a lɛ ka a ʊ, k'a ta higʊta bɩ gəm deem la. ");
INSERT INTO bib_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wosocikarɩnsaamba deem n a zɔ ma, an a hɩ m, a ʊ: «Karɩnsaamba, mɔɔ zure ɩbɩɩ jɛ ʊ lɛɛ haay k'ɩbɩɩ nɩ taŋ ʊ b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeezuu n a hɩ m, a ʊ: «Sɛɛʊnrɔ ɩ yaarɔ m, bɛnnɔ ɩ cɛlɩŋŋarɔ m, bɩ Gʊaanyɩ bɩ ba bɩncɛ m k'a a mim cɩnta ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Karɩndanyɩ vanta n a hɩ m, a ʊ: «Zuuba, zaa ka m ʊ, kʊ m aa nɩ m zɩ gər bir, kʊ m a dɔ m bʊr.» ");
INSERT INTO bib_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bɩ, Yeezuu a hɩ m, a ʊ: «Zu mɔɔ ʊ, k'ɩ gəəno to kʊ ŋ n'a gəəno bir.» ");
INSERT INTO bib_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yeezuu gasʊ kɔɔlʊʊ ʊ, a karɩndanyɩnɔ n zu a jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lɛɛm bɩ, hɩnhɛr gʊta wuti hi bɩ burə ʊ, an a ŋʊa k'a ka kʊ hi m kɔɔlʊʊ bɩ mom. Yeezuu n bɔkarɛ, an nɩ hinceem bam. ");
INSERT INTO bib_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Karɩndanyɩnɔ wɔɔ n a zɔ ma, ŋn'a gu, ŋn'a hɩ m, ŋ ʊ: «Zuuba, wɔɔ yɔ! Kʊ m bɛɛ m wɔɔ gɩngam!» ");
INSERT INTO bib_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A n a hɩ ŋ nɩ, a ʊ: «Bɔ m, awɔɔ nɩ nyi barɛ, sɩrakarɛ poore zannɔ!» A n wuti an jɩm, an həən si hɩnhɛr bɩ ma kan higʊta bɩ kɩ. Lɛɛ bɩ n zɛ sɩɩ… ");
INSERT INTO bib_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ŋ n zɛ kədə, ŋn'a hɩrɛ, ŋ ʊ: «Bɩ gʊaa bɩ kara n naa, baa hɩnhɛr kan hi kɩ n n'a lɛ sire?» ");
INSERT INTO bib_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yeezuu k'a lee ku higʊta bɩ tʊr deem ʊ Gadara zannɔ kʊ ʊ b'ʊ bɩ, a m bɩ, gʊɔɔ hɩɩyɔɔ kʊ zinəro n ta ŋ nɩ n bɔ gəənoyaarɔ ʊ, ŋnɩ b'a zɛ ʊ. Gʊɔɔ wɔɔ duro nyɩnta bʊnyaa gʊta. Naa minto bɩ, gɔsɩ b'a dam ma, an cem lɛɛ bɩ do ʊ y. ");
INSERT INTO bib_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ŋ n a sɩŋŋɩda ba, ŋn'ɩ zee dam, ŋ ʊ: «Bɔ ɩbɩɩ lɛ n taa k'ɩ ba wɔɔ nɩ Woso Nyɩ? Bʊr ɩbɩɩ ʊ k'ɩ bɩ fɩr ka wɔɔ ma, bɩ wɔɔ fɩryɩrɛ dɔmɩm bɩ n a ku cɩna ra?» ");
INSERT INTO bib_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A n bɔkarɛ, kurkuuro cir gʊta ɩ nyɩnta laatʊ b'ʊ, ŋn'ɩ hɔ bɩrɛ. ");
INSERT INTO bib_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Zinəro wɔɔ n'a yɛm Yeezuu han gʊta, ŋ ʊ: «K'ɩ la wɔɔ ra, k'ɩ wɔɔ nyɔɔ kurkuuro wɔɔ mɛ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a ta!» Ŋ nɩ bɔ gʊɔɔ wɔɔ mɛ ʊ, ŋnɩ gasʊ kurkuuro wɔɔ mɛ ʊ. A m bɩ, kurkuuro cir gʊta bɩ n bra si, ŋnɩ zer, ŋn'a zar higʊta b'ʊ, ŋnɩ gɩnga. ");
INSERT INTO bib_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kurkuuro dundonno wɔɔ n bra si, ŋn'aa hɔ k'a ba bɩ hɩ kʊnɔ ʊ b'ʊ, kan hɔ k'a ba gʊɔɔ kʊ zinəro n ta ŋ nɩ rɔ wɔɔ n bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A m bɩ, gʊɔɔ kʊ ŋ nɩ kʊnɔ ʊ b'ʊ haay rɔ wɔɔ n bɔ, ŋn'ɩ tam k'a yaa Yeezuu zɛ ʊ. A yɩ kʊ ŋ y'a ʊ bɩ, ŋ y'a yɛ han gʊta k'an bɔ a kʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Naa jɛ ʊ bɩ, Yeezuu gasʊ kɔɔlʊʊ ʊ, an a wusigə, an higʊta bɩ zɛ ra an ta a kʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","N n mɛgarɛzaa busu wʊtarahɔ ra, n nɩ bʊr m Yeezuu zi. K'a gʊɔɔ kʊ ŋ bʊr m nɔ wɔɔ sɩrakarɛ yɩ bɩ, a a hɩ mɛgarɛzaa bɩ m, a ʊ: «M nyɩnnɩ, ɩ tɔ ʊ, ɩ ɩ mimbʊnyaarɔ wɔɔ sugur yɩ.» ");
INSERT INTO bib_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wosocikarɩnsaambɔɔ gɔsɩnnɔ nyɩnta b'ʊ, ŋn'a hɩrɛ a heer ʊ, ŋ ʊ: «Gʊaa naa do ɩ Woso sʊnsɔ wʊrɛ!» ");
INSERT INTO bib_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yeezuu k'a hɔ k'a nɩ ŋ heer ʊ bɩ dɔ bɩ, a a hɩ ŋ nɩ, a ʊ: «Bɔ minto, awɔɔ n'a hɔɔn darɛ ncɩnaaʊ? ");
INSERT INTO bib_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kara m zanta? Mɔɔ n b'a hɩm lʊgɔ bɩ m, mɔɔ ʊ: Ɩ ɩ mimbʊnyaarɔ sugur yɩ bɩ m gɛ, gɛɛ, ɩ wuti ɩ ɩ wʊtarahɔ bɩ gʊr, ɩ ta bɩ nɩ? ");
INSERT INTO bib_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bɩ kɛɛrɛ bɩ, awɔɔ y'a dɔrɛ, a ʊ: Gʊaanyɩ b'ɩ lɛ m tara burə ʊ, k'a gʊɔɔ mimbʊnyaarɔ sugur ka ŋ ʊ.» A n a hɩ lʊgɔ bɩ m, a ʊ: «Wuti, ɩ ɩ wʊtarahɔ bɩ gʊr ɩ doo!» ");
INSERT INTO bib_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gʊaa bɩ n wuti an doo. ");
INSERT INTO bib_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Gʊɔɔ cir gʊta kʊ ŋ naa yɩ bɩ, ŋ da bɔ ʊ, ŋn'a lɛ bɔ Woso ʊ, k'a paŋŋa naa do ka gʊɔɔ ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeezuu k'a nɩ tam bɩ, a a to, an gʊaa yɩ an nɩ nyɩntam yawʊrsire bɩncɛ b'ʊ, a tɔ m Matiyee, an a hɩ m, a ʊ: «Zu mɔɔ ʊ!» A n wuti an zu a jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kʊ Yeezuu nɩ nyɩntam Matiyee har ʊ b'ʊ k'a hɔ bɩ bɩ, yawʊrsinno kan mimbʊnyaabənno kɩ nyɩnta b'ʊ gʊta kan kɩ, kan a karɩndanyɩnɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farizɛɛnrɔ wɔɔ kʊ ŋ naa yɩ bɩ, ŋ y'a hɩrɛ a karɩndanyɩnɔ wɔɔ m, ŋ ʊ: «A lɔ, awɔɔ karɩnsaamba bɩ nɩ hɔbɩrɛ bɩm kan yawʊrsinno kɩ, mimbʊnyaabənno kɩ?» ");
INSERT INTO bib_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yeezuu k'a naa ma bɩ, a a hɩ, a ʊ: «Laafɩɩzannɔ lɛ baa lɔɔtɔr ma y, yaabazannɔ lɛ n taa lɔɔtɔr ma. ");
INSERT INTO bib_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","K'a ta, a yaa a ka meerbaa naa do jɩ ma: ‹Cicirzɛrɛ mɔɔ lɛ n taa, mannɩ barɛ bɛɛ y›. Mɔɔ n bʊr kʊ m bɩ gʊɔɔ mɩŋŋɔɔ bir y. Bʊr mɔɔ ʊ kʊ m bɩ mimbʊnyaabənno bir.» ");
INSERT INTO bib_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Zaan karɩndanyɩnɔ a zɔ Yeezuu ma, ŋnɩ laaka da han, ŋ ʊ: «Bɔ minto m, wɔɔ kan farizɛɛnrɔ wɔɔ kɩ, wɔɔ n'ʊ lɛ kʊsɩm, b'ɩbɩɩ hɔɔ wɔɔ bɩr a kʊsɩrɛ?» ");
INSERT INTO bib_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Kʊ gʊaa ɩ lʊsarɛ cibsa barɛ, lʊ bɩ zim bɩ nɩ gʊɔɔ wɔɔ bireyaa ʊ, gʊɔɔ wɔɔ y'a dam ma, ŋnɩ heerzarlɛ ba ra? Bɩ dɔmɩm niŋŋə ʊ, n zɛm bɩ lʊ bɩ zim bɩ gʊ ŋ ma, ŋ y'a lɛ kʊsɩm dɔmɩm bɩ do ʊ. ");
INSERT INTO bib_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Gʊaa ba ʊ, an nɩ pɛɛra daa kər sam, an n'a tam huu gusire rɛ y. Bala, pɛɛra daa kər bɩ huu gusire bɩ gaam an a kaansʊ, an lɛ da biisi ra. ");
INSERT INTO bib_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Gʊaa ba ʊ, an nɩ dɩvɛn daa sam k'a tɔ hibɔɔnrɔ gusinno ʊ y. Kʊ m bɛɛ m, hibɔɔnrɔ wɔɔ hɩnhaanm, dɩvɛn bɩ n a lo hibɔɔnrɔ wɔɔ n a zaar ba. Bɩ dɩvɛn daa bɩ tɔ n tɩr a ʊ hibɔɔnrɔ daarɔ ʊ, dɩvɛn bɩ kan hibɔɔnrɔ wɔɔ kɩ b'a zaarbarɛ y.» ");
INSERT INTO bib_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","K'a nɩ meer barɛ ncɩnaaʊ kan gʊɔɔ wɔɔ kɩ bɩ, zɩɩfʊrɔ sokʊmacɛ cir deem n a zɔ ma, an sʊnta a taa, an n'a hɩm nɩ, a ʊ: «Mɔɔ nyɩmbʊɛɛrɛ ɩ ga, a n maasɩrɛ ba cɩna y. Bɩ, bʊr ɩ wɔ ka a mim la, k'an a mɩm bɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yeezuu n wuti kan a karɩndanyɩnɔ kɩ, ŋnɩ zu a jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Bɩ, lʊ n ta ʊ, ma n'a dam zi a dɔɔraa bueerehɩɩya hɔ m naa, an a zɔ Yeezuu ma jɛ ʊ, an a wɔ da Yeezuu huu lɛ ma. ");
INSERT INTO bib_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Bala, lʊ bɩ y'a hɩrɛ a heer ʊ, a ʊ: «Kʊ mɔɔ m wɔ da a huu lɛ ma tɔkkɛ, mɔɔ yɩ m waam.» ");
INSERT INTO bib_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bɩ, Yeezuu a bɔ an dɩga a jɛ ʊ, an lʊ bɩ yɩ an a hɩ m, a ʊ: «Mɔɔ nyɩnnɩ, ɩ heer ba kookoo, ɩ sɩrakarɛ y'ɩ bʊmbɔ». Lɛɛm bɩ, lʊ b'a waa wakatɩ bɩ do ʊ. ");
INSERT INTO bib_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yeezuu k'a lee ku zɩɩfʊrɔ sokʊmacɛ cir bɩ har ʊ bɩ, k'a hirpenno wɔɔ yɩ kan gʊaa cir bɩ bʊgʊr barɛ kɩ bɩ, a a hɩ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«K'a bɔ, nyɩmbʊɛɛrɛ bɩ n ga y. Hinceem a a ba.» Gʊɔɔ wɔɔ nɩ yaa wʊm ma. ");
INSERT INTO bib_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kʊ n bɔ gʊɔɔ wɔɔ m bɩ, a gasʊ zi, an nyɩ bɩ sa a wɔ ma, a m bɩ, nyɩmbʊɛɛrɛ bɩ n wuti. ");
INSERT INTO bib_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mim naa do n ta lɛ haay ʊ kʊ bɩ do ʊ. ");
INSERT INTO bib_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeezuu k'a hʊr b'ʊ bɩ, bʊʊrɔ hɩɩyɔɔ ɩ b'a zɛ ʊ, ŋnɩ zu a jɛ ʊ, ŋn'ɩ baa dam, ŋn'a hɩrɛ, ŋ ʊ: «Wɔɔ cicir zɛ *Davɩd Nyɩ!» ");
INSERT INTO bib_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yeezuu k'a lee ku har ʊ bɩ, bʊʊrɔ wɔɔ a zɔ ma, an ŋ lar, a ʊ: «Awɔɔ sɩra ka a ʊ, mɔɔ yɩ m dam ma, m naa ba ra?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Ɩɩn…, Zuuba.» ");
INSERT INTO bib_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","A m naa, Yeezuu n a wɔ da ŋ mɩnyaarɔ wɔɔ ma, an a hɩ, a ʊ: «Hɔ k'awɔɔ sɩra ka k'a yɩ bɩ, k'a yɩ maam.» ");
INSERT INTO bib_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ŋ mɩnyaarɔ wɔɔ n gʊ. Yeezuu n lɛ ka ŋ ʊ paŋŋa m, a ʊ: «K'a dundo a zi! A b'a ka gʊaa n a dɔ y!» ");
INSERT INTO bib_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bɩ gʊɔɔ wɔɔ kʊ ŋ bɔ bɩ, ŋ y'a sɩŋŋɩda sa lɛɛm, ŋn'a mim dɩndam kʊ b'ʊ haay. ");
INSERT INTO bib_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yeezuu k'a n'a hʊrm bɩ, n bʊr gʊaa m zinə n ta m, an a ba bəətir. ");
INSERT INTO bib_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yeezuu k'a la zinə bɩ ra bɩ, bəətir b'a sɩŋŋɩda sa, an nɩ meer bam. Gʊɔɔ cir gʊta bɩ zɛ kədə. Ŋ n'a hɩrɛ, ŋ ʊ: «Hɔ naa do lɔɔ n ba cɩna Israyɛl kʊ naa ʊ y!» ");
INSERT INTO bib_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bɩ farizɛɛnrɔ wɔɔ y'a hɩrɛ, ŋ ʊ: «Zinəro jɩtaarɛ bɩ nɩ paŋŋa kaŋ ʊ, an nɩ lam zinəro wɔɔ ra.» ");
INSERT INTO bib_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeezuu ɩ bɩrm kʊnɔrɔ wɔɔ ʊ kan bɔlɛɛmarɔ kʊrɔ wɔɔ kɩ, an nɩ hɔ dɩndarɛ ŋ sokʊmacɛrɔ wɔɔ ʊ, an nɩ Woso cirbəə lemim nyɩnta pa dam sɔ, an nɩ yaaba do haay waam kan kʊsɩ do haay kɩ. ");
INSERT INTO bib_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","K'a gʊɔɔ cir gʊta bɩ yɩ bɩ, ŋ cicir a nyasʊ, bala, gʊɔɔ wɔɔ ɩ heerzarlɛ nɔ ʊ kan kɔrɛ kɩ, amba hɔbɩsɩrɔ kʊ ŋ ba dundor m bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A n a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «Mɔsa zibəə bɩ gʊta, bɩ zibəənyɩnɔ wɔɔ bɩ gʊta y. ");
INSERT INTO bib_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Naa minto bɩ, k'a yɛ Wutuzaa bɩ han k'an zibəənyɩnɔ nyɔɔ a mɔsa zibəə bɩ tɔ ma.» ");
INSERT INTO bib_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeezuu a karɩndanyɩnɔ bueerehɩɩyɔɔ wɔɔ bir, an paŋŋa ka ŋ ʊ, kʊ ŋ n'a da zinəro wɔɔ ma, kʊ ŋ nɩ la ŋ la, kʊ ŋ nɩ yaaba do haay waa, kan kʊsɩ do haay kɩ. ");
INSERT INTO bib_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kristazibəəzannɔ bueerehɩɩyɔɔ wɔɔ tɔrɔ ba n nɩ: Lɛɛkarɛ zaa bɩ tɔ m, Sɩmɔɔn, n n'a hɩm ma Pɩyɛɛr, kan a danzaa Andɩr kɩ, Zebedee nyɩnɔ Zakkɩ kan a danzaa Zaan kɩ. ");
INSERT INTO bib_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi kan Bartelemii kɩ, Toma kan yawʊrsirezaa Matiyee kɩ, Alfee nyɩ Zakkɩ kan Tade kɩ. ");
INSERT INTO bib_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Sɩmɔɔn *Zelɔtɩ, kan Zidas Iskarɩyɔtɩ kɩ, b'ɩ Yeezuu da jɩnnɔ wɔ ʊ bɩ. ");
INSERT INTO bib_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yeezuu bueerehɩɩyɔɔ nɔɔn duro nyɔɔ, an lɛ ka ŋ ʊ, a ʊ: «A bɩ kɩfɩɩrɔ zaa sa y, b'a bɩ gasʊ Samarii zannɔ kʊ ʊ y. ");
INSERT INTO bib_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Bɩ k'a ta Israyɛl do zi, gʊɔɔ kʊ ŋ bɔ kʊ ʊ kan hɔbɩsɩrɔ kʊ ŋ nyaam nɔ wɔɔ kɩ zi. ");
INSERT INTO bib_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","K'awɔɔ ɩ tam k'a bɩr a pa darɛ, a ʊ: Woso cirbəə b'a zɔ. ");
INSERT INTO bib_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","K'a yaabazannɔ waa, k'a gəəno mɩm bɔ ʊ, k'a kusiməro waa, a dintim gʊ ŋ ma, k'a la zinəro ra. A ka n y'a ʊ awɔɔ ʊ vam, k'a ka vam sɔ. ");
INSERT INTO bib_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","A bɩ sarma sa, b'a bɩ busoo sa sɔ y. A bɩ bɔɔlʊgʊ zar a mɔr ʊ sɔ y. ");
INSERT INTO bib_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","A bɩ hɩra sa zaa bɩ sarɛ minto, b'a bɩ huu sa hɩɩya y. A bɩ kʊsɔ kan bara kɩ sa y, bala, zibəəzaa b'a ga m, an hɔbɩrɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","K'awɔɔ gasʊ kʊ poore ʊ gɛɛ kʊ gʊta ʊ, k'a laaka da, kʊ gʊaa ta ʊ a lɛ n taa k'awɔɔ si a har ʊ, k'a gɔɔta b'ʊ k'an ta an awɔɔ hʊrlɛ ku. ");
INSERT INTO bib_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","K'awɔɔ ta k'a gasʊ har b'ʊ, k'a hɩ, a ʊ: ‹Laafɩɩ n bɩr kan awɔɔ kɩ.› ");
INSERT INTO bib_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kʊ har bɩ do a ga m, k'awɔɔ laafɩɩ n nyɩnta kan kɩ. Bɩ, k'a n a ga m, k'awɔɔ laafɩɩ n a wusigə awɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Har bɩ do nɔ ʊ kʊ ŋ n awɔɔ si, kʊ ŋ n a tʊr ka awɔɔ meerbaa bɩ ma, ŋn'a si sɔ, k'a ɩ bɔm har bɩ do ʊ, gɛɛ kʊ bɩ do ʊ, k'a taanyisi gʊ a gannɔ ma. ");
INSERT INTO bib_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sɩra mɔɔ n'a hɩrɛ awɔɔ m: dʊdɔkarɛ hinni ʊ, kʊ naa do fɩryɩrɛ yɩm gʊta an lɛ da Sodɔm kan Gomɔɔr kɩ kʊ ra.» ");
INSERT INTO bib_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«K'a tʊr ka mɩŋŋa, awɔɔ nyɔɔ mɔɔ nawʊm am seero hɔ bɩ m poojino bireyaa ʊ. Bɩ minto bɩ, k'a hɔɔn ka mɩŋŋa, am mɩnnɔ hɔ bɩ m. K'a yɩ gʊɔɔ kʊ ŋ mim ba ʊ y, am cirpʊnnɔ hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","K'a dundo a zi kan gʊɔɔ kɩ, bala, ŋ y'awɔɔ gʊrm, ŋnɩ ta awɔɔ m dʊdɔkənno zi. Ŋ y'awɔɔ zɛm madɩɩrɔ m a sokʊmacɛrɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ŋ tarɛ awɔɔ m kʊrɔ lɛɛzannɔ kan cinno kɩ taa mɔɔ tɔ ma. Naa nɩ nyɩntam kasɛtɩ ŋ mɩŋŋɔɔ kan kɩfɩɩrɔ wɔɔ kɩ lɛɛ. ");
INSERT INTO bib_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kʊ ŋ bɩ ta awɔɔ m brɔɔ lɛɛ, a b'a hɔɔn da k'awɔɔ meer bam lʊnlɔ, gɛɛ, bɔ awɔɔ n n'a hɩrɛ y. Hɔ k'awɔɔ n'a hɩm bɩ, n y'a karɛ awɔɔ ʊ dɔmɩm bɩ do ʊ. ");
INSERT INTO bib_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bala, awɔɔ bɛɛ n nɩ meer barɛ a zim y, awɔɔ Zɩ Sɛnt-Ɛspri n nɩ meer k'awɔɔ n n'a bam bɩ darɛ awɔɔ lɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Danyɩnɔ kʊ kam zɛ ma. Zɩ y'a nyɩ karɛ, n n a zɛ. Nyɩnɔ wutire ŋnɩ jɩm kan a zɩrɔ kɩ, ŋnɩ ŋ ka, ŋnɩ ŋ zɩnzɛ. ");
INSERT INTO bib_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Gʊaa haay sɔrɛ awɔɔ m mɔɔ tɔ ma. Bɩ gʊaa k'a jɩm kɔɔkɔɔ an ta an fɩryɩrɛ bɩ nyarɛ ku bɩ bʊmbɔrɛ yɩm. ");
INSERT INTO bib_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kʊ ŋ fɩr ka awɔɔ ma kʊ niŋŋə ʊ, k'a a si a ta kʊ vanta ʊ. Sɩra mɔɔ n'a hɩrɛ awɔɔ m, awɔɔ bɩ Israyɛl kʊnɔrɔ wɔɔ nyarɛ Gʊaanyɩ bɩ m bɔkarɛ, an bʊr y. ");
INSERT INTO bib_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Karɩndanyɩ bɩ n lɛ da a karɩnsaamba ra y, zibəənyɩ bɩ n lɛ da a zuuba ra sɔ y. ");
INSERT INTO bib_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Karɩndanyɩ a ga m, an yɩ am a karɩnsaamba m. Zibəənyɩ a ga m, an yɩ am a zuuba m. Kʊ n har bɩ zaa bɩ ba zinəro jɩtaarɛ, awɔɔ hɔɔn ʊ naa, n b'a bam har bɩ nyɩnɔ wɔɔ m ncɩnaaʊ ra? ");
INSERT INTO bib_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ncɩnaaʊ bɩ, a bɩ nyi ba gʊɔɔ nɩ y. Bala, hɔ ba ʊ, an a nyaakʊm da, n ba yɩrɛ y. Mim ba ʊ, an a nyaakʊm da, n b'a dɔrɛ y. ");
INSERT INTO bib_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hɔ kʊ mɔɔ n'a hɩrɛ awɔɔ m monsigə ʊ bɩ, k'a hɩ garga ra, hɔ k'awɔɔ n'a mam sɔ awɔɔ y'a minto bɩ, k'a pa da kʊ gʊaa haay n a ma. ");
INSERT INTO bib_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A bɩ nyi ba gʊɔɔ kʊ ŋ nɩ mɛsim zɛm gər, bɩ ŋ b'a dam ma, ŋnɩ gʊaa nyi zɛ rɔ wɔɔ nɩ y. K'a nyi ba Woso m. Bɩ y'a da ma, an mɛsim kan nyi kɩ zaar ba sɛhar ʊ. ");
INSERT INTO bib_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","N bɩr bɛnnɔ hɛɛnm hɩɩya wacɩr la? A n bɔkarɛ deem taan… bɩr gam k'awɔɔ Zɩ bɛɛ zaa ka y. ");
INSERT INTO bib_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","B'awɔɔ, ŋ y'awɔɔ minkə bɩ lɛ dɔ. ");
INSERT INTO bib_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","K'a maam, a bɩ nyi ba y. Awɔɔ gore ta ʊ, an lɛ da bɛnnɔ haay ra. ");
INSERT INTO bib_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kʊ gʊaa a hɩ gʊɔɔ lɛɛ, a ʊ, a mɔɔ dɔ, mɔɔ y'a hɩrɛ m Zɩ k'a nɩ arzana ʊ bɩ m, mɔɔ ʊ, mɔɔ zaa dɔ sɔ. ");
INSERT INTO bib_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bɩ, kʊ gʊaa bɩsɩ ka mɔɔ ma gʊɔɔ lɛɛ, mɔɔ bɩsɩ karɛ a zaa ma sɔ mɔɔ Zɩ k'a nɩ arzana ʊ bɩ lɛɛ. ");
INSERT INTO bib_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","A b'a hɔɔn da, a ʊ, bʊr mɔɔ ʊ kʊ laafɩɩ n nyɩnta ʊ tara burə ʊ y. Mɔɔ n bʊr kʊ laafɩɩ n nyɩnta ʊ y. Bʊr mɔɔ ʊ zoobarɛ m. ");
INSERT INTO bib_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bʊr mɔɔ ʊ, kʊ m gʊaa gʊ a zɩ ma, kʊ m nyɩmbʊɛɛrɛ gʊ a da ma, kʊ m lʊ gʊ a nyar ma. ");
INSERT INTO bib_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Gʊaa har gʊɔɔ n nɩ yɩrɛ a jɩnnɔ. ");
INSERT INTO bib_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kʊ gʊaa a zɩ ŋʊa gɛɛ a da an lɛ da mɔɔ m, gʊaa bɩ do n a ga m, an yɩ mɔɔ gʊaa y. Kʊ gʊaa a nyɩyar gɛɛ a nyɩmbʊɛɛrɛ ŋʊa an lɛ da mɔɔ m, gʊaa bɩ do n a ga m, an yɩ mɔɔ gʊaa sɔ y. ");
INSERT INTO bib_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kʊ gʊaa n a gɔdarkʊra busu an zu mɔɔ ʊ, a n a ga m, an yɩ mɔɔ gʊaa y. ");
INSERT INTO bib_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kʊ gʊaa lɛ taa k'a a meeyaa bʊmbɔ, a b'a meeyaa bʊmbɔrɛ yɩrɛ y. Bɩ gʊaa k'a yɛ zɛ ma mɔɔ tɔ ma bɩ bʊmbɔrɛ yɩm.» ");
INSERT INTO bib_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Kʊ gʊaa awɔɔ si, mɔɔ a m si. Mɔɔ si k'a ʊ bɩ, bɔzaa ɩ mɔɔ nyɔɔ b'a a si. ");
INSERT INTO bib_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kʊ gʊaa wosolɛsinnɩsorazaa si k'an wosolɛsinnɩsorazaa bɩ minto, a wosolɛsinnɩsorazaa ganwʊrɛ yɩm. Kʊ gʊaa gʊaa tɩrga si a tɩrgabaa tɔ ma, a gʊaa tɩrga ganwʊrɛ yɩm. ");
INSERT INTO bib_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, kʊ gʊaa hi ka hɩnnɩ ʊ tɔkkɛ nyɩnɔ poorero nɔɔn duro deem ʊ, kʊ mɔɔ karɩndanyɩ m bɩ tɔ ma, gʊaa bɩ do bɩ kʊrɔm ganwʊrɛ ma y.» ");
INSERT INTO bib_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yeezuu k'a hɔ dɩnda a karɩndanyɩnɔ bueerehɩɩyɔɔ wɔɔ m an a nya bɩ, a a hʊr lɛɛ bɩ do ʊ k'a yaa Woso lemim pa da, k'a hɔ dɩnda sɔ kʊrɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Zaan k'a nɩ lɔnnɔcɛ ʊ b'a to an Krista zibəəro wɔɔ mim ma, an a karɩndanyɩnɔ gɔsɩnnɔ nyɔɔ, ");
INSERT INTO bib_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kʊ ŋ n aa laaka da han, ŋ ʊ: «Ɩbɩɩ ŋn'ɩ dɔrɛ ɩ zɛrɛ ma bɩ gɛɛ, gʊaa vanta nɩ?» ");
INSERT INTO bib_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «K'a ta a yaa hɔ k'awɔɔ n'a mam, an n'a yɩm naa dɩnda Zaan m: ");
INSERT INTO bib_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bʊʊrɔ mɩm ɩ lɛɛ yɩm, lʊgɔrɔ ɩ tam, kusimoo y'a waam, dintim nɩ gʊrɛ ŋ ma, tikkiro ɩ meerbaa mam, gəəno y'a mɩm bɔŋ ʊ, lemim nyɩnta ɩ hɩm ŋʊazannɔ m. ");
INSERT INTO bib_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mimbirenyɩntazaa m gʊaa k'a n a sɩrakarɛ to mɔɔ minto bɩ m.» ");
INSERT INTO bib_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Zaan karɩndanyɩnɔ wɔɔ kʊ ŋ y'a hʊr bɩ, Yeezuu a sɩŋŋɩda ba, an n'a hɩm zamaa bɩ m, a ʊ: «Nka awɔɔ ta a yaa dɩga a poohɔɔn ʊ? Hɩnhɛr awɔɔ yɩ, an nɩ niigə gɔ yəŋŋəm gɛ? ");
INSERT INTO bib_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bɔ awɔɔ ta a yaa dɩga a paan…? Gʊaa m, an huu wɩsɩ da a ra gɛ? Gʊɔɔ kʊ ŋ nɩ huu wɩsɩrɔ darɛ a ra rɔ wɔɔ ɩ cinno harlɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nka awɔɔ ta a yaa dɩga a? Wosolɛsinnɩsorazaa m gɛ? Ɩɩn…, mɔɔ y'a hɩ awɔɔ m, a lɛ da wosolɛsinnɩsorazaa ra. ");
INSERT INTO bib_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Zaan mim n y'a gʊrsɩra ba Wosoci nɔ ʊ, n ʊ: ‹Mɔɔ nɩ m zibəəzaa nyɔɔrɛ ɩbɩɩ lɛɛ, k'an ɩbɩɩ zaa banka.› ");
INSERT INTO bib_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, lannɔ nyɩnɔ barla gʊaa ba ʊ an lɛ da Zaan-Batiisi ra y. A n bɔkarɛ gʊaa k'an poore Woso cirbəə nɔ ʊ bɩ lɛ da m. ");
INSERT INTO bib_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A n a sɩŋŋɩda sa Zaan-Batiisi Woso lemim padarɛ dɔmɩnnɔ ʊ, an lee ku dɩɩtaa naa ma bɩ, arzana bɩ gasʊ n nawʊŋ ʊ paŋŋa m, tʊntɔʊrɛzannɔ n'a soŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Wosolɛsinnɩsorazannɔ wɔɔ haay kan Moyiisi lɛrɔ wɔɔ kɩ Woso cirbəə bɩ mim dɩnda, an ta an Zaan dɔmɩm ku. ");
INSERT INTO bib_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","K'a dɔ mɩŋŋa a ʊ, *Elii niŋŋə kʊ n ʊ a zɛm bɩ m Zaan m. ");
INSERT INTO bib_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Gʊaa k'a nɩ tʊr m k'an a ma! ");
INSERT INTO bib_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kʊ m her gʊɔɔ nɔɔn makra ba kan bɔ kɩ? Bɔ ŋ y'a ʊ kʊ ʊ kan nyɩnɔ kʊ ŋ yaa nyɩnta daasɩyaa ʊ, ŋn'a to, ŋn'ɩ kʊ bimbirm, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Wɔɔ hir hɛ awɔɔ m, b'awɔɔ n sar ba y! Wɔɔ zɛlaa lɔ awɔɔ m, b'awɔɔ n nyi ka y! ");
INSERT INTO bib_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bala, Zaan k'a bʊr bɩ, a bɩr hɔ bɩrɛ y, a bɩr dɩvɛn mim sɔ y. N n a hɩrɛ, n ʊ: zinə n ta m. ");
INSERT INTO bib_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Gʊaanyɩ bɩ bʊr, an nɩ hɔ bɩm, an nɩ hɔ mim, n n'a hɩm ma, n ʊ: Naa do naa, nɔzaa m, bɩ, bɛɛmir m sɔ. Yawʊrsinno kan mimbʊnyaabənno kɩ hannyɩ m. Bɩ, gʊɔɔ kʊ ŋ nɩ yɛm Woso Mindɔrɛ bɩ ma rɔ wɔɔ a dɔ ŋ ʊ, Woso Mindɔrɛ bɩ tɩrga.» ");
INSERT INTO bib_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","A m naa, Yeezuu n a sɩŋŋɩda sa, an nɩ nyaa bam kan kʊrɔ k'a hoserlo ba ʊ gʊta bɩ ŋ n a bɔ a taam nɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Korazɛn, ɩbɩɩ kʊsɩ yɩm! Bɛtsayɩdaa, ɩbɩɩ kʊsɩ yɩm sɔ! Bala, hoserlo kʊ ŋ ba awɔɔ bireyaa ʊ rɔ wɔɔ, kʊ ba ŋ y'a ʊ Tiir kʊ ʊ kan Sidɔn kʊ kɩ, k'an naa brɔɔ huu yiiro gʊr ŋnɩ ŋ ka a ra ŋnɩ suu lo a ra, k'a hɩnka a ʊ, a lɛ taa k'a a bɔ a taam. ");
INSERT INTO bib_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bɩ y'a ka, mɔɔ n'a hɩrɛ awɔɔ m: dʊdɔkarɛ hinni ʊ, awɔɔ fɩryɩrɛ nyɩntam kʊsɩ, an lɛ da Tiir kan Sidɔn kɩ m. ");
INSERT INTO bib_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","B'ɩbɩɩ, Kapɛrnawum, ɩbɩɩ y'ɩ busure ɩ lee ku brama ra? Ɩbɩɩ zerm ɩ gasʊ gəənokʊ ʊ! Bala, kʊ hoserlo kʊ ŋ ba ɩbɩɩ zi rɔ wɔɔ, kʊ ba ŋ y'a ʊ Sodɔm kʊ ʊ, k'an naa a gɔɔta an ta ʊ her dɔmɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Naa y'a ka, mɔɔ n'a hɩrɛ awɔɔ m: dʊdɔkarɛ dɔmɩm ʊ, ɩbɩɩ fɩryɩrɛ yɩm kʊsɩ an lɛ da Sodɔm hɔ ra.» ");
INSERT INTO bib_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dɔmɩm bɩ do ʊ bɩ, Yeezuu meer ba, a ʊ: «Zɩ k'a a so tara ʊ kan brama kɩ, mɔɔ ɩ yaa darɛ ɩbɩɩ m barka, k'ɩbɩɩ hɔɔ nɔɔn duro nyaakʊm da gʊɔɔ hɔɔnzannɔ m kan hɔdonno kɩ m, ɩ bɔkarɛ, ɩ ŋ hɩnka nyɩnɔ poorero m bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɩɩn…, Zɩ, ɩbɩɩ y'a ŋʊa ɩ ba ncɩnaaʊ. ");
INSERT INTO bib_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mɔɔ Zɩ hɔ haay ka mɔɔ ʊ. Zɩ bɩ y'a deem ɩ Nyɩ bɩ dɔ. Nyɩ bɩ y'a deem ɩ Zɩ bɩ dɔ kan gʊɔɔ k'a lɛ n taa k'a hɩnka ŋ nɩ rɔ wɔɔ kɩ bala. ");
INSERT INTO bib_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","K'a bʊr mɔɔ zi, awɔɔ haay k'awɔɔ mɔr gorezaa busu an n'a kɔm nɔ wɔɔ, mɔɔ hoonsire karɛ awɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","K'a zu mɔɔ ʊ, k'a mɔɔ hɔdɩndarɛ si, bala, mɔɔ bʊgʊ-bʊgʊ, mɩŋŋazerlezaa m mɔɔ m. Bɩ, awɔɔ nyiro wɔɔ hoonsire yɩm. ");
INSERT INTO bib_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bala, zuuba k'an kʊsɩ bɛɛ m mɔɔ nɩ y. Mɔr kʊ mɔɔ n'a karɛ awɔɔ ʊ bɩ gore ba ʊ sɔ y.» ");
INSERT INTO bib_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dɔmɩnnɔ wɔɔ duro ʊ, sabaa hinni ʊ, Yeezuu bɔ hɔsɩrarɔ ʊ, nɔ n a karɩndanyɩnɔ wɔɔ nyasʊ, ŋn'a sɩŋŋɩda ba, ŋn'ɩ hɔyaa yɩnyarm ŋn'a tiŋŋəre, ŋn'a sʊm. ");
INSERT INTO bib_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farizɛɛnrɔ wɔɔ kʊ ŋ naa yɩ bɩ, ŋ y'a hɩ Yeezuu m, ŋ ʊ: «Dɩga ɩ karɩndanyɩnɔ wɔɔ ma, hɔ k'a n a ga barɛ m *sabaa hinni ʊ bɩ ŋn'a bam.» ");
INSERT INTO bib_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mim k'a pakra ba Davɩd m kan a gʊɔɔ kɩ bɩ dɔmɩm ʊ, hɔ niŋŋə k'a a ba, nɔ k'a a nyasʊ bɩ, ");
INSERT INTO bib_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","gasʊ k'a ʊ Woso zɛʊjɩ bɩncɛ ʊ, an mannɩ bur bɩ gʊr an a bɩ, kan a gʊɔɔ wɔɔ kɩ, bɩ lɛ ba ʊ kʊ ŋ n'a bɩ kʊ wosocɛmannɩbənno wɔɔ bɛɛ m bala bɩ, awɔɔ n a karɩnda ba ra? ");
INSERT INTO bib_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Gɛɛ, awɔɔ n a karɩnda ba Moyiisi lɛrɔ ci b'ʊ, n ʊ: Woso zɛʊjɩ bɩncɛ ʊ b'ʊ bɩ, wosocɛmannɩbənno wɔɔ bɩr zum sabaa hinni b'ʊ y, bɩ kʊrɔma bɛɛ nɩ y. ");
INSERT INTO bib_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Bɩ, mɔɔ y'a hɩrɛ awɔɔ m, Gʊaa ɩ naa ʊ, an lɛ da Wosocɛ bɩ ra. ");
INSERT INTO bib_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","N ʊ: cicirzɛrɛ mɔɔ lɛ n taa, mannɩbarɛ bɛɛ y, k'awɔɔ meerbaa naa do jɩ ma, awɔɔ bɩ gʊɔɔ nɔɔn duro dʊdɔ yarlɛ y, bala, ŋ n kʊrɔma y. ");
INSERT INTO bib_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bala, Gʊaanyɩ bɩ m sabaa hinni bɩ minzaa.» ");
INSERT INTO bib_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Cem kʊ Yeezuu ʊ b'ʊ bɩ, ta a ʊ, an aa gasʊ ŋ sokʊmacɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lɛɛ bɩ do ʊ bɩ, gʊaa n nɩ b'ʊ, a wɔ deem n ga. Ŋ n laaka da Yeezuu han, ŋ ʊ: «A a ga m, kʊ n nɩ gʊaa waa *sabaa hinni ʊ ra?» A hɩ ŋ y'a ʊ ncɩnaaʊ, k'a Yeezuu ku, a mim ka ra. ");
INSERT INTO bib_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Bɩ, Yeezuu a hɩ ŋ nɩ, a ʊ: «Nka n'awɔɔ bire ʊ, a ser deem bala n n'a dam yaa ʊ sabaa hinni ʊ, b'a bɩ tarɛ an aa a bɔ yaa b'ʊ? ");
INSERT INTO bib_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Gʊaa n lɛ da ser m denter la? K'a maam, a a ga m, kʊ n nɩ zi mɩŋŋa ba gʊaa m sabaa hinni ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","A m bɩ, an a hɩ wɔgərzaa bɩ m, a ʊ: «Ɩ wɔ bɩ hʊr!» Gʊaa bɩ n a hʊr, a wɔ bɩ n a banka mɩŋŋa am deem bɩ hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farizɛɛnrɔ wɔɔ kʊ ŋ bɔ sokʊmacɛ b'ʊ bɩ, ŋ y'a dɩnda k'a ka zaa ma k'a Yeezuu ku a zɛ. ");
INSERT INTO bib_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yeezuu k'a naa ma bɩ, a a hʊr lɛɛ bɩ do ʊ, gʊaa cir gʊta n zu a jɛ ʊ, an yaabazannɔ wɔɔ waa haay. ");
INSERT INTO bib_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","A n n'a hɩrɛ ŋ nɩ mɩŋŋa, a ʊ: A b'a ka gɔsɩ n a dɔ y. ");
INSERT INTO bib_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kʊ hɔ kʊ wosolɛsinnɩsorazaa Ezayii a hɩ bɩ n kʊ yɩ. A a hɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Mɔɔ Zibəənyɩ kʊ mɔɔ bɔ ʊ bɩ ba n nɩ. Gʊaa kʊ mɔɔ n'a ŋʊam kan m heer kɩ haay bɩ, mɔɔ yɩ m Ɛspri bɩ kaŋ ʊ. A mɔɔ lɛrɔ hɩ m do gʊta m. ");
INSERT INTO bib_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A b'a kam nyaa ma y. A bɩ zee darɛ y. Gɔsɩ b'a leer mam zaarɔ bire ʊ y. ");
INSERT INTO bib_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A bɩ niigə gɔ paŋŋawarzaa darɛ y. A bɩ fɩtɩrɛ k'a sɛ paŋŋa ba ʊ bɩ lihire y. A ba a nawʊrɛ ncɩnaaʊ, an ta an paŋŋa ka tɩrgabaa ʊ. ");
INSERT INTO bib_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Do haay sɩra kaŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bɩ jɛ ʊ bɩ, n bʊr gʊaa m Yeezuu zi, zinə n ta m, an a ba bʊʊ, bəətirbaa n ta m sɔ. Yeezuu n a waa, a n nɩ meerbarɛ, a mɩm n nɩ lɛɛ yɩm sɔ. ");
INSERT INTO bib_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Gʊaa cir bɩ zɛ kədə, ŋn'a hɩrɛ, ŋ ʊ: «*Davɩd Nyɩ bɛɛ m na?» ");
INSERT INTO bib_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bɩ farizɛɛnrɔ wɔɔ kʊ ŋ naa ma bɩ, ŋ y'a hɩrɛ, ŋ ʊ: «Naa do k'an naa, la a nawʊm zinəro ra, zinəro jɩtaarɛ Bɛlzebul paŋŋa m bala.» ");
INSERT INTO bib_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeezuu k'a hɔ kʊ ŋ n'a hɔɔn dam ma bɩ dɔ bɩ, a a hɩ ŋ nɩ, a ʊ: «Kʊ k'a gʊɔɔ bɩr kʊ mam bɩ y'a darɛ. Kʊnɔ gɛɛ, har kʊ kʊmarɛ ba ʊ bɩ y'a dam sɔ. ");
INSERT INTO bib_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kʊ Sʊtaana bʊr an nɩ lam Sʊtaana ra, gʊngʊrɛ m bɩ. A kʊ bɩ y'a dam ma, an jɩm dʊntɔ ra? ");
INSERT INTO bib_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Bɩ kʊ Bɛlzebul paŋŋa y'a ka mɔɔ nɩ lam zinəro ra, awɔɔ karɩndanyɩnɔ wɔɔ la kʊ ŋ nawʊrɛ ŋ la sɔ bɩ, ŋ paŋŋa b'a to ka? Bɩ y'a ka ŋ mɩŋŋɔɔ n n'awɔɔ dʊdɔ karɛ. ");
INSERT INTO bib_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bɩ kʊ Woso *Sɛnt-Ɛspri paŋŋa y'a ka mɔɔ nɩ lam zinəro ra, k'a maam k'a dɔ a ʊ, Woso cirbəə bɩ lee ku awɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","A n ta ʊ sɔ bɩ, gʊaa ba ʊ, an b'a dam ma, an gasʊ gʊaa paŋŋazaa har ʊ, k'a mɔrlɔ gʊr, k'a n ser ka, an a kʊsɩ, an bɔkarɛ, an gasʊ, an mɔrlɔ wɔɔ gʊr y. ");
INSERT INTO bib_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Gʊaa k'a ba kan mɔɔ kɩ bɩ, mɔɔ jɩm m. Gʊaa k'a bɩr a dam mɔɔ han an a so kʊ ma bɩ, a hɩsɩga a nawʊm.» ");
INSERT INTO bib_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","«Naa y'a ka, mɔɔ n'a hɩrɛ awɔɔ m, Woso mimbʊnyaarɔ haay kan sʊnsɔrɔ haay kɩ sugur kam gʊɔɔ ʊ. Bɩ, gʊaa biyəə k'a nɩ Sɛnt-Ɛspri sʊnsɔ wʊm bɩ, a b'a sugur yɩm fɩɩga y. ");
INSERT INTO bib_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kʊ gʊaa meer ba Gʊaanyɩ bɩ ma, a y'a sugur yɩm, bɩ k'a meer ba Sɛnt-Ɛspri ma, a b'a sugur yɩm tara burə ʊ naa ʊ, b'a b'a yɩm booti hinni ʊ sɔ y.» ");
INSERT INTO bib_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«K'a dɔ a ʊ: gɔ mɩŋŋa bɩ, nyɩ mɩŋŋa a n'a dam. Gɔ bʊnyaa bɩ nɩ nyɩ bʊnyaa dam. N gɔ biyəə dɔ a nyɩ ma. ");
INSERT INTO bib_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mɩnnɔ kʊsɩrɔ, awɔɔ y'a bam lɔ k'a mim mɩŋŋa hɩ a kʊsɩrabaa bɩ nɔ ʊ? Bala, hɔ k'a gʊaa heer han b'a lɛ n'a hɩm. ");
INSERT INTO bib_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Gʊaa mɩŋŋa k'a n'a mɩŋŋabaa m bɩ, bɔ an nawʊm mim mɩŋŋa m a heer ʊ. Gʊaa bʊnyaa k'a n'a bʊnyaabaa m bɩ, bɔ an nawʊm mim bʊnyaa m a heer ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Bɩ, mɔɔ y'a hɩrɛ awɔɔ m, mɔɔ ʊ: Meerbaa k'a nyɔɔdʊ ba ʊ haay kʊ gʊaa n'a bam bɩ, Woso y'a larm ma. ");
INSERT INTO bib_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bala, ɩbɩɩ meerbaa n n'ɩ bʊmbɔrɛ, ɩ meerbaa n n'ɩ dam mim ʊ sɔ.» ");
INSERT INTO bib_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Naa kur bɩ, wosocikarɩnsaambɔɔ kan farizɛɛnrɔ kɩ a sɩŋŋɩda ba, ŋn'a hɩ Yeezuu m, ŋ ʊ: «Karɩnsaamba, wɔɔ lɛ taa k'ɩ hoser ba k'ʊ a yɩ.» ");
INSERT INTO bib_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A n a nyɩ bɔ ŋ nʊ, a ʊ: «Her naa gʊɔɔ wɔɔ, gʊɔɔ bʊnyaarɔ m, ŋ bɩr Woso lɛ sire y, ŋ y'a kam makra ma, bɩ kʊ makra bɩ nɩ, ŋ bɩ makra vanta yɩrɛ kʊ wosolɛsinnɩsorazaa Zonas makra bɩ bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bala, Zonas k'a gɔɔta zɔ gʊta nɔ ʊ hi ʊ dɔmɩm kaakʊ bɩ, sinuu ʊ kan a gunuu ʊ kɩ bɩ, Gʊaanyɩ bɩ gɔɔtam maam sɔ tara noom ʊ dɔmɩm kaakʊ, sinuu ʊ kan a gunuu ʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dʊdɔkarɛ hinni ʊ, Niniivɩ gʊɔɔ wutire, ŋnɩ her gʊɔɔ nɔɔn da lɛ ʊ, ŋnɩ ŋ gumə war bɩ hɩnka ŋ nɩ. Bala, Niniivɩ gʊɔɔ wɔɔ a bɔ a taam ŋnɩ sugur yɛ Zonas Woso lemim padarɛ ma. Bɩ naa ʊ bɩ, gʊaa ta ʊ an lɛ da Zonas ra. ");
INSERT INTO bib_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dʊdɔkarɛ hinni ʊ, lʊ cir k'a a to jɩsadɔpaasɩ ma an bʊr k'a b'a tʊr ka Salomɔɔn mindɔrɛ meerbaa ma bɩ, a zamaana naa do gumə war bɩ hɩnkarɛ ŋ nɩ. Bala, a to a ʊ kʊ laatʊrɛ ʊ, an bʊr k'a b'a tʊr ka ma, an bɔkarɛ, gʊaa ɩ naa ʊ an lɛ da Salomɔɔn ra.» ");
INSERT INTO bib_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Kʊ zinə bɔ gʊaa mɛ ʊ, a da an nawʊm lɛɛ gəəro zi, k'a a ka hoonsire bɩncɛ ma, bɩ k'a bɩr a yɩrɛ, ");
INSERT INTO bib_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","b'a hɩ a heer ʊ, a ʊ: ‹Mɔɔ yɩ m wusigəre m bɩncɛ gusire ʊ.› K'a yaa leeku bɩ, a yaa dɩga a gɔsɩ n a so cɛ b'ʊ, bɩ dintim ba b'ʊ sɔ y. Hɔ haay ɩ cɛ b'ʊ, a bɩncɛrɔ ʊ mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","K'a yɩ ncɩnaaʊ, b'a ta an aa zinəro vantɔɔ gaa saanhɩna, ŋ bʊnyaabaa n lɛ da a mɩŋŋa ra, ŋnɩ bɩ gasʊ, ŋn'a so gʊaa bɩ do ʊ. Gʊaa bɩ do mim bɩ bʊnyaabaa lɛ dam biisi hɔ ra. Zamaana naa do k'an bʊnyaa naa, a mim yɩrɛ ncɩnaaʊ sɔ.» ");
INSERT INTO bib_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeezuu k'a nɩ meer bam kan gʊɔɔ cir bɩ kɩ bɩ, a da kan a danyɩnɔ kɩ bʊr, ŋnɩ jɩm garga ra, ŋn'a ŋʊam k'a meer ba kan kɩ.  ");
INSERT INTO bib_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Gʊaa n a hɩ Yeezuu m, a ʊ: «Ɩ da kan ɩ danyɩnɔ kɩ ɩ garga ra, ŋ lɛ n taa k'a meer ba kan ɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeezuu n a nyɩ bɔ gʊaa bɩ nʊ, a ʊ: «Nka m mɔɔ da? Nkɔɔ m mɔɔ danyɩnɔ?» ");
INSERT INTO bib_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A n bɔkarɛ, an a wɔ nyɔɔ a karɩndanyɩnɔ wɔɔ ma, an a hɩ, a ʊ: «Mɔɔ da bɩ ba n nɩ, kan mɔɔ danyɩnɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gʊaa niŋŋə k'a nɩ mɔɔ Zɩ k'a nɩ arzana ʊ bɩ hɔɔnhɔ bam bɩ, mɔɔ danyɩ m, mɔɔ danlʊ m, mɔɔ da m.» ");
INSERT INTO bib_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hinni bɩ dɔ ʊ bɩ, Yeezuu bɔ har ʊ, an aa nyɩnta higʊta bɩ lɛ ra, ");
INSERT INTO bib_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","zamaa cir gʊta a so kʊ ma a jɩr ʊ. A m bɩ, Yeezuu n kɔ, an aa nyɩnta kɔɔlʊʊ ʊ, zamaa bɩ haay n nɩ jɩnɩm hi bɩ lɛ ra. ");
INSERT INTO bib_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A hɔ dɩnda ŋ nɩ gʊta hɔbɔkʊrɛnoom darɛ nɔ ʊ, an a hɩ, a ʊ: «Gʊaa ɩ bɔ, k'a hɔ duu. ");
INSERT INTO bib_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A duu k'a nawʊm bɩ, gɔsɩnnɔ n a lo zaa gʊr ma, bɛnnɔ n bʊr, ŋnɩ b'a bɩ haay. ");
INSERT INTO bib_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gɔsɩnnɔ n a lo jaarɔ bɩncɛ ʊ, taa n nyɩnta b'ʊ gʊta y. Hɔyaa bɩ n bɔ lɛɛm, kʊ taa ba b'ʊ gʊta bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Woso k'a der bɩ, a na hɔka bɩ ma, an ga, k'a məsi ba ʊ bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gɔsɩnnɔ n a zar laa gaa ʊ, laa bɩ n haan, an ŋ zɩnzɛ. ");
INSERT INTO bib_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gɔsɩnnɔ n a lo lɛɛ mɩŋŋa ʊ, ŋnɩ haan, ŋnɩ ma, ŋnɩ nyɩ da. A yaa deem yaa ka zɔrɔ, deem busɔrdɩ, deem bukərku. ");
INSERT INTO bib_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gʊaa k'a nɩ tʊr m bɩ, k'an a tʊr ka ma.» ");
INSERT INTO bib_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Karɩndanyɩnɔ wɔɔ a zɔ Yeezuu ma, ŋn'a hɩ m, ŋ ʊ: «Bɔ m, ɩbɩɩ n tɩr meer ba kan ŋ kɩ hɔbɔkʊrɛnoom nɩ?» ");
INSERT INTO bib_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A n a nyɩ bɔ ʊ, a ʊ: «Woso a ka k'awɔɔ n Woso cirbəə bɩ minno kʊ ŋ y'a nyaakʊm da rɔ wɔɔ dɔ, b'a n a ka nawɔnnɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bala, gʊaa k'an ta hɔ m bɩ, n y'a yarɛ n n a ka ʊ, a hɔ n yɩ gʊta, bɩ gʊaa k'a ba m bɩ, baa hɔ k'an ta m bɩ, n bɩ yɔm nɩ. ");
INSERT INTO bib_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Naa y'a ka mɔɔ nɩ meer bam kan ŋ kɩ hɔbɔkʊrɛnoom m. Bala, ŋ yɩ dɩgam, bɩ ŋ bɩr lɛɛ yɩrɛ y. Ŋ y'a tʊr kam, bɩ ŋ bɩr a marɛ, ŋ bɩr a jɩ mam sɔ y. ");
INSERT INTO bib_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kʊ hɔ kʊ Ezayii a hɩ bɩ n kʊ yɩ ŋ minto. A ʊ: Awɔɔ mim mam gʊta, b'awɔɔ b'a jɩ marɛ y. Awɔɔ dɩgam mɩŋŋa, b'awɔɔ bɩ lɛɛ yɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bala, do naa do heer a ta. Ŋ tʊr bɩr mim marɛ y, ŋ y'a mɩnyaarɔ tɩnta, k'a bɩ lɛɛ yɩ, k'a bɩ mim ma y, k'a heer bɩ mim jɩ ma y, k'a bɩ sugur yɛ, a a bɔ a taam kʊ mɔɔ n a waa y! ");
INSERT INTO bib_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","B'awɔɔ, awɔɔ jɩra: awɔɔ mɩnyaarɔ ɩ lɛɛ yɩm, awɔɔ tʊʊrɔ ɩ mim mam! ");
INSERT INTO bib_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, wosolɛsinnɩsorazannɔ gʊta kan gʊɔɔ tɩrgɔɔ gʊta kɩ a ŋʊa, k'a hɔ k'awɔɔ n'a yɩm naa yɩ, bɩ ŋ n a yɩ y. K'a hɔ k'awɔɔ n'a mam naa ma, bɩ ŋ n a ma y.» ");
INSERT INTO bib_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«K'a tʊr ka hɔduure hɔbɔkʊrɛnoom bɩ jɩ ma. ");
INSERT INTO bib_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hɔyaa k'a nɩ zaa lezi bɩ, gʊɔɔ kʊ ŋ nɩ Woso cirbəə lemim bɩ mam, bɩ ŋ bɩr a jɩ mam nɔ wɔɔ m. Bala, lɛɛm bɩ, Sʊtaana lemim kʊ n y'a duu ŋ heer ʊ bɩ si ŋ han. ");
INSERT INTO bib_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Hɔyaa k'a nɩ jaarɔ bɩncɛ ʊ bɩ, gʊɔɔ kʊ ŋ nɩ Woso lemim bɩ marɛ, ŋn'a sim lɛɛm kan heernyɔɔ kɩ rɔ wɔɔ m brɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bɩ, ŋ mɩŋŋɔɔ məsi ba ʊ y, hindeem gʊɔɔ m. Kʊ heerzar gɛɛ fɩryɩrɛ bʊr Woso lemim bɩ tɔ ma, bɩ ŋ y'a do lɛɛm. ");
INSERT INTO bib_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Hɔyaa k'a nɩ laarɔ bireyaa ʊ bɩ, gʊɔɔ m, ŋnɩ Woso lemim bɩ ma, durnya hɔɔndama kan a arzaka lɛtaama kɩ ŋ lemim bɩ zɛ, a bɩr nyɩ darɛ y. ");
INSERT INTO bib_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hɔyaa k'a nɩ lɛɛ mɩŋŋa ʊ bɩ, gʊɔɔ kʊ ŋ Woso lemim bɩ ma, ŋn'a jɩ ma rɔ wɔɔ m: Ŋ n'ɩ nyɩ dam. A yaa deem ɩ nyɩ dam zɔrɔ, deem busɔrdɩ, deem bukərku.» ");
INSERT INTO bib_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeezuu a ya, an hɔbɔkʊrɛnoom vanta da, a ʊ: «Woso cirbəə bɔ kʊ ʊ kan gʊaa k'a hɔdo mɩŋŋa duu a hɔsɩra ʊ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Gum k'a bɩ da gʊɔɔ nɩ hinceem bam bɩ, gʊaa bɩ jɩm deem n bʊr, an bɩ sʊr duu hɔyaa bɩ barla, an a hʊr. ");
INSERT INTO bib_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hɔyaa bɩ k'a bɩ bɔ, an ma, an yaa ka bɩ, sʊr bɩ n bɔ sɔ. ");
INSERT INTO bib_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hɔsɩrazaa bɩ zibəənyɩnɔ n b'a hɩ m, ŋ ʊ: ‹Zuuba, hɔdo mɩŋŋa bɛɛ ɩbɩɩ duu ɩ hɔsɩra b'ʊ ra? A a ba lɔ kɛɛrɛ sʊr n bʊr, an ta ʊ?› ");
INSERT INTO bib_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A n a nyɩ bɔ ŋ nʊ, a ʊ: ‹Jɩm deem ɩ hɔ naa do ba›. A m naa, zibəənyɩnɔ wɔɔ n a lar, ŋ ʊ: ‹Ɩbɩɩ lɛ taa k'ʊ ta, ʊ aa sʊr bɩ wʊnwʊr la?› A n a nyɩ bɔ ʊ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‹Ayy… Bala, k'awɔɔ k'a sʊr bɩ wʊnwʊr, awɔɔ cenle a hɔka bɩ wʊnwʊr sɔ. ");
INSERT INTO bib_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","K'a ŋ to kʊ ŋ nɩ ma kan kʊ kɩ, k'an ta, an aa hɔdarɛ dɔmɩm ku. Hɔdarɛ dɔmɩm ʊ bɩ, mɔɔ y'a hɩm zibənno wɔɔ m, mɔɔ ʊ: K'a lɛɛ ka a sʊr bɩ gʊr, a kʊsɩ, a da sɛ ʊ, k'a bɔkarɛ a hɔyaa bɩ gʊr a zar m sɩ ʊ.› » ");
INSERT INTO bib_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeezuu a ya, an hɔbɔkʊrɛnoom vanta da ŋ nɩ, a ʊ: «Woso cirbəə bɩ bɔ kʊ ʊ kan hɔ kʊ n n'a hɩm ma mutardɩ yaa, kʊ gʊaa n'a sam, an n'a duum a hɔsɩra ʊ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","A m hɔdo haay rɔ wɔɔ poore. Bɩ, kʊ n y'a duu an bɔ, ma an nawʊm, an nɩ lɛ dam hɔyaa haay ra: a ba an nawʊm gɔ gʊta, bɛnnɔ n b'a dam ma, ŋnɩ cɛ kɩnka a vəŋŋəro ma.» ");
INSERT INTO bib_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A a ya an hɔbɔkʊrɛnoom da ŋ nɩ, a ʊ: «Woso cirbəə bɩ bɔ kʊ rɛ kan nyʊnyɔɔ kɩ. Lʊ n a sa, an a tʊntɔ kan nyisi kɩ mɔr gʊta lɛ ma kaakʊ. Nyisi bɩ n ta an der.» ");
INSERT INTO bib_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Minno nɔɔn duro haay hɩ Yeezuu n nawʊrɛ ŋ nɩ hɔbɔkʊrɛnoom m. A bɩr hɔsɩ hɩm gʊɔɔ cir bɩ m, k'a hɩ bɛɛ a nawʊm hɔbɔkʊrɛnoom nɩ y. ");
INSERT INTO bib_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kʊ hɔ kʊ wosolɛsinnɩsorazaa b'a hɩ bɩ n kʊ yɩ. A a hɩ, a ʊ: Mɔɔ yɩ m lɛ gʊrɛ, m hɔbɔkʊrɛnoom da ŋ nɩ, m hɔ k'a nyaakʊm da durnya sɩŋŋɩda ʊ tee… bɩ hɩ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yeezuu k'a zamaa cir bɩ to, an doo bɩ, a karɩndanyɩnɔ wɔɔ a zɔ ma, ŋn'a hɩ m, ŋ ʊ: «Sʊr hɔbɔkʊrɛnoom bɩ jɩ dɩnda wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A n a nyɩ bɔ ŋ nʊ, a ʊ: «Gʊaa k'a nɩ hɔ mɩŋŋa do duum bɩ, Gʊaanyɩ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Hɔsɩra bɩ, durnya m. Hɔdo mɩŋŋa bɩ, Woso cirbəə nyɩnɔ wɔɔ m. Sʊr bɩ, Sʊtaana nyɩnɔ m. ");
INSERT INTO bib_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jɩm k'a sʊr bɩ duu bɩ, Sʊtaana m. Hɔdarɛ bɩ, durnya nyarɛ m. Hɔdənno wɔɔ, malɛɛkarɔ m. ");
INSERT INTO bib_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Amba kʊ ŋ nɩ sʊr gʊrm ŋn'a dam sɛ ʊ bɩ, yɩ a nawʊrɛ ncɩnaaʊ durnya nyarɛ hinni ʊ: ");
INSERT INTO bib_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gʊaanyɩ bɩ y'a malɛɛkarɔ nyɔɔrɛ, ŋnɩ hɔ haay k'a nɩ gʊɔɔ gʊm Woso ma rɔ wɔɔ gʊr Woso cirbəə bɩ nɔ ʊ. Ŋ mimbʊnyaabənno wɔɔ gʊrm sɔ, ŋnɩ bɔ ŋ nɩ, ");
INSERT INTO bib_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ŋn'aa ŋ zar sɛhar ʊ. Ŋ nyi kam b'ʊ, ŋn'a sɔ sʊ. ");
INSERT INTO bib_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bɩ, gʊɔɔ tɩrgarɔ wɔɔ gure am wosogure hɔ bɩ m, ŋ Zɩ bɩ cirbəə nɔ ʊ b'ʊ. Gʊaa k'a nɩ tʊr m, k'a n'a tʊr ka ma.» ");
INSERT INTO bib_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Woso cirbəə bɩ bɔ kʊ rɛ kan arzaka gʊta kʊ n y'a nyaakʊm da hɔsɩra ʊ bɩ kɩ, gʊaa n sʊr la: a n so ra, an a nyaakʊm da. K'a heer nyɔɔ bɩ, an a hʊr, an aa hɔ haay k'an ta m nɔ wɔɔ hɛɛ, an hɔsɩra bɩ do si m.» ");
INSERT INTO bib_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Woso cirbəə b'a ya an bɔ kʊ rɛ kan terbarɛzaa k'a n'a kam nyɛɛnyaarɔ mɩŋŋɔɔ ma kɩ. ");
INSERT INTO bib_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","K'a nyɛɛnyaa wɩsɩ yɩ, a busoo nɩ yɩm gʊta bɩ, an ta, an aa hɔ haay k'an ta m nɔ wɔɔ hɛɛ, an b'a si m.» ");
INSERT INTO bib_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Woso cirbəə b'a ya, an bɔ kʊ rɛ kan zaŋŋa kʊ ŋ n'a zom hi ʊ, an nɩ zɔ do haay gʊrlɛ an nɩ bɔm nɩ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kʊ zɔnɔ a han bɩ n y'a gaa, n n bɔ m hi bɩ lɛ ra. N n bɔkarɛ, ŋnɩ nyɩnta, ŋnɩ zɔnɔ mɩŋŋɔɔ wɔɔ nyʊkɔ ʊ, ŋnɩ ŋ zar mɔr ʊ, ŋnɩ zɔnɔ bʊnyaarɔ wɔɔ lo. ");
INSERT INTO bib_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Yɩ a nawʊrɛ ncɩnaaʊ durnya nyarɛ hinni ʊ. Malɛɛkarɔ zɛm bɩ gʊɔɔ bʊnyaarɔ wɔɔ gʊ gʊɔɔ tɩrgarɔ wɔɔ ma, ");
INSERT INTO bib_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ŋnɩ ŋ zar sɛhar ʊ. Ŋ nyi kam b'ʊ, ŋn'a sɔ sʊ.» ");
INSERT INTO bib_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeezuu n a karɩndanyɩnɔ wɔɔ lar, a ʊ: «Awɔɔ naa haay woo… ma mɩŋŋa ra?» Ŋ ʊ: «Ɩɩn…» ");
INSERT INTO bib_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A n a hɩ ŋ nɩ, a ʊ: «Ncɩnaaʊ bɩ, wosocikarɩnsaamba biyəə k'a n'a bam Woso cirbəə kʊ bɩ karɩndanyɩ bɩ, bɔ a ʊ kʊ rɛ kan harzaa k'a nɩ hɔ gusire kan hɔ daa kɩ bɔrɛ a arzaka ʊ bɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yeezuu k'a hɔbɔkʊrɛnoonno nɔɔn duro da an ŋ nya bɩ, a a hʊr lɛɛ bɩ do ʊ, ");
INSERT INTO bib_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","an doo kʊ k'a tʊr ʊ b'ʊ. A n a sɩŋŋɩda sa, an nɩ hɔ dɩndam kʊ bɩ do sokʊmacɛ b'ʊ, zamaa bɩ n zɛ kədə a hɔdɩndarɛ bɩ tɔ ma. Ŋ n'a hɩrɛ, ŋ ʊ: «Awɔɔ a to mindɔrɛ naa do m ka? A a ba lɔ, an nɩ hoserlo barɛ? ");
INSERT INTO bib_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Gɔwurezaa bɩ nyɩ bɛɛ n'awɔɔ m na? Maarii nyɩ bɛɛ n'awɔɔ m na? Zakkɩ, Zozɛf, Sɩmɔɔn, Ziidi, a danyɩnɔ bɛɛ m nawɔnnɔ ra? ");
INSERT INTO bib_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Awɔɔ danlʊrɔ ba wɔɔ bire ʊ naa ʊ ra? A a ba lɔ kɛɛrɛ, an n'a dam naa do haay barɛ ma?» ");
INSERT INTO bib_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Naa do a ka, ŋ n kaanm Yeezuu m. A m naa, Yeezuu n a hɩ ŋ nɩ, a ʊ: «Wosolɛsinnɩsorazaa ɩ daʊrɛ yɩm bɩncɛ haay ʊ, b'a bɩr a yɩm a kʊ ʊ, a bɩr a yɩm a har ʊ sɔ y.» ");
INSERT INTO bib_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yeezuu n hoser ba b'ʊ gʊta y, ŋ sɩrakarɛwar bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dɔmɩm bɩ do ʊ bɩ, cir Hɩrɔɔdɩ Yeezuu mim ma, bala a tɔ bɔ lɛɛ haay ʊ. ");
INSERT INTO bib_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A n n'a hɩrɛ a zibəənyɩnɔ m, a ʊ: «Gʊaa naa do, Zaan-Batiisi m! K'a a mɩm bɔ ʊ gəəno bire ʊ bɩ y'a ka, an paŋŋa yɩ, an nɩ hoserlo barɛ.» ");
INSERT INTO bib_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kʊ sɩra nɩ, Hɩrɔɔdɩ a ka, ŋnɩ Zaan nyasʊ, ŋn'a sur, ŋn'a du lɔnnɔcɛ ʊ, a dam Filipi lʊ k'an ta m, a tɔ m Hɩrɔdɩyaadɩ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Bala, Zaan a hɩ Hɩrɔɔdɩ m, a ʊ: «A n a ga m k'ɩbɩɩ n a ba ɩ lʊ y!» ");
INSERT INTO bib_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hɩrɔɔdɩ a ŋʊa k'a Zaan zɛ gər, b'a ɩ nyi bam gʊɔɔ wɔɔ m. Bala, brɔɔ haay ɩ dɩgam Zaan ma, ŋ ʊ: Wosolɛsinnɩsorazaa m. ");
INSERT INTO bib_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bɩ, Hɩrɔɔdɩ yɩrɛ dɔmɩm cibsa hinni ʊ, Hɩrɔdɩyaadɩ nyɩmbʊɛɛrɛ sar ba gʊɔɔ kʊ n yɩ ŋ bir cibsa ma rɔ wɔɔ lɛɛ, an Hɩrɔɔdɩ nɔ yɩ. ");
INSERT INTO bib_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hɩrɔɔdɩ n a wer si, a ʊ: hɔ k'a lɛ n taa haay bɩ, a y'a kaŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nyɩmbʊɛɛrɛ bɩ da bɩ n a nyʊnnyɔɔta, a ʊ: «A n Zaan-Batiisi mim yɛ laaga burə ʊ.» Nyɩmbʊɛɛrɛ bɩ n a yɛ maam sɔ. ");
INSERT INTO bib_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Cir bɩ heer n a zar, b'a b'a dam ma, an a gu y, k'a wer si hɔbɩrɛbinno wɔɔ bire ʊ bɩ minto. A m bɩ, an lɛ ka kʊ n n'a ka ʊ. ");
INSERT INTO bib_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A n gʊaa deem nyɔɔ, an aa Zaan mim gʊ ma lɔnnɔcɛ ʊ b'ʊ, ");
INSERT INTO bib_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","an bʊr m laaga ʊ, an b'a ka nyɩmbʊɛɛrɛ b'ʊ, an a si, an aa a ka a da ʊ. ");
INSERT INTO bib_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Zaan karɩndanyɩnɔ wɔɔ n bʊr, ŋnɩ bɩ Zaan gər bɩ sa, ŋn'aa bir, ŋnɩ bɔkarɛ ŋn'aa hɔ k'a a ba bɩ hɩ Yeezuu m. ");
INSERT INTO bib_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yeezuu k'a mim naa do ma bɩ, a a hʊr lɛɛ bɩ do ʊ, an da kɔɔlʊʊ ʊ k'a ta toore ma a deem. Gʊɔɔ cir kʊ ŋ naa yɩ bɩ, ŋ y'a hʊr a kʊrɔ ʊ a gam ma, k'a zu a jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yeezuu k'a bɔ kɔɔlʊʊ b'ʊ bɩ, a gʊaa cir yɩ gʊta, gʊɔɔ wɔɔ cicir n a nyasʊ, an a sɩŋŋɩda sa, an nɩ ŋ yaabazannɔ waarɛ. ");
INSERT INTO bib_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yirbəə k'a da bɩ, a karɩndanyɩnɔ wɔɔ a zɔ ma, ŋn'a hɩ m, ŋ ʊ: «Gum da, bɩ pooyaa m naa, gʊɔɔ wɔɔ da zaa ra kʊ ŋ nɩ ta kʊrɔ wɔɔ ʊ, ŋn'aa hɔbɩrɛ si, ŋn'a bɩ!» ");
INSERT INTO bib_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bɩ, Yeezuu a nyɩ bɔ ʊ, a ʊ: «A n a ga m, ŋn'a hʊr y. K'a hɔbɩrɛ ka ŋ ʊ a zim.» ");
INSERT INTO bib_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","A m bɩ, ŋn'a hɩ m, ŋ ʊ: «Bur soor kan zɔnɔ kɩ hɩɩya wɔɔ n ta m naa ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a ŋ ka m ʊ naa ʊ». ");
INSERT INTO bib_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A n lɛ ka, kʊ gʊɔɔ wɔɔ n nyɩnta bur bɩ ra, an bur soorlɔ wɔɔ si kan zɔ hɩɩya bɩ kɩ a wɔ ʊ, an dɩga brama, an barka da Woso m. A n buuro wɔɔ zɩnzɛ ra, an a ka a karɩndanyɩnɔ wɔɔ ʊ, kʊ ŋ n'a ka zamaa b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gʊɔɔ wɔɔ haay a bɩ, an ŋ ka. Karɩndanyɩnɔ wɔɔ bur kan zɔ kɩ kuuro kʊ ŋ gɔɔta rɔ wɔɔ gʊr kasɩ lɛ ma bueerehɩɩya. ");
INSERT INTO bib_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Gʊɔɔ kʊ ŋ hɔ bɩ bɩ rɔ wɔɔ, yaarɔ wɔɔ lɛ a zɔ tisi soor ma. N n lannɔ kan nyɩnɔ kɩ lɛ sa y. ");
INSERT INTO bib_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Lɛɛm bɩ, Yeezuu a ka karɩndanyɩnɔ wɔɔ n da kɔɔlʊʊ b'ʊ, kʊ ŋ nɩ bra higʊta bɩ gəm deem la, k'a gɔɔta a zamaa bɩ da zaa ra. ");
INSERT INTO bib_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","K'a zamaa bɩ da zaa ra an a nya bɩ, a a hʊr a deem, an ta ci ra, k'a yaa da. Yirbəə k'a da bɩ, a gɔɔta b'ʊ a deem. ");
INSERT INTO bib_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kɔɔlʊʊ bɩ n a gʊ hi bɩ lɛ bɩ ma, an ta laatʊ hi bɩ bire ʊ. Bala, hɩnhɛr y'a nyam kɔɔlʊʊ bɩ zi, hikurero wɔɔ n'a monɩm kɔɔlʊʊ b'ʊ ");
INSERT INTO bib_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dɔ k'a bʊr an nɩ mɛm bɩ, a wuti an tɔ hi bɩ ra, an nɩ tarɛ ŋ zi. ");
INSERT INTO bib_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kʊ karɩndanyɩnɔ wɔɔ a yɩ an nɩ tam hi bɩ ra bɩ, nyibəə gasʊ ŋ ʊ, ŋn'a hɩrɛ, ŋ ʊ: «Toor m!» Ŋ n'ɩ zee dam. ");
INSERT INTO bib_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Lɛɛm bɩ, Yeezuu meer ba kan ŋ kɩ, a ʊ: «K'a sɩra ka, mɔɔ m, a da bɩ bɔ ʊ y!» ");
INSERT INTO bib_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pɩyɛɛr n a hɩ m, a ʊ: «Zuuba, k'ɩbɩɩ m paan… k'ɩ lɛ ka kʊ m bʊr ɩ zi hi bɩ burə ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeezuu n a hɩ m, a ʊ: «Bʊr.» Pɩyɛɛr n bɔ kɔɔlʊʊ b'ʊ, an nɩ tɔm hi bɩ ra k'a ta Yeezuu zi. ");
INSERT INTO bib_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","K'a hɩnhɛr bɩ yɩ an nɩ hɔnm kan paŋŋa kɩ bɩ, a da bɔ ʊ, hi bɩ n'a monɩm, an zee da, a ʊ: «Zuuba, m bɔ lɛ m!» ");
INSERT INTO bib_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lɛɛm bɩ, Yeezuu a wɔ nyɔɔ an a nyasʊ, an a hɩ m, a ʊ: «Ɩbɩɩ sɩrakarɛ poore! A lɔ ɩbɩɩ n sɩnsɩm ka?» ");
INSERT INTO bib_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ŋ n'a da kʊ ʊ, ŋnɩ gasʊ kɔɔlʊʊ b'ʊ hɩnhɛr bɩ n jɩm. ");
INSERT INTO bib_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Gʊɔɔ kʊ ŋ nɩ kɔɔlʊʊ b'ʊ rɔ wɔɔ kukurə zɛ a taa, ŋn'a hɩrɛ, ŋ ʊ: «Woso Nyɩ n'ɩbɩɩ m paan….» ");
INSERT INTO bib_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kʊ ŋ higʊta bɩ zɛ ra bɩ, ŋ yaa lee ku Zenezarɛtɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kʊ bɩ do gʊɔɔ wɔɔ kʊ ŋ Yeezuu yɩ, ŋn'a dɔ bɩ, ŋ yaa a hɩ kʊ b'ʊ haay kan kʊrɔ jɩnjɛɛnnɔ wɔɔ kɩ, ŋ ʊ, a bʊr. Ŋ n bʊr yaabazannɔ wɔɔ m haay Yeezuu zi. ");
INSERT INTO bib_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ŋ n a yɛ han, k'a a wɔ da a huu lɛ tɔkkɛ ma. Bɩ, gʊɔɔ kʊ ŋ y'a wɔ da ma rɔ wɔɔ waarɛ yɩ haay. ");
INSERT INTO bib_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farizɛɛnrɔ kan wosocikarɩnsaambɔɔ gɔsɩnnɔ kɩ a to Zerizalɛm ʊ, ŋnɩ bʊr Yeezuu zi, ŋnɩ b'a hɩ m, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Bɔ m, ɩbɩɩ karɩndanyɩnɔ wɔɔ bɩr zum wɔɔ yaabɔɔ yɩnnɩbayɩrɔ wɔɔ ʊ? Ŋ n'ɩ hɔ bɩm, bɩ ŋ n a wɔ hir y. A n a ga nɩ y.» ");
INSERT INTO bib_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeezuu n a hɩ ŋ nɩ, a ʊ: «B'awɔɔ, a lɔ awɔɔ bɩr zum Woso lɛrɔ wɔɔ ʊ, a bɔkarɛ, an nɩ zum a yɩnnɩbayɩrɔ wɔɔ ʊ? ");
INSERT INTO bib_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Woso a hɩ, a ʊ: ‹Ɩ zɩ kan ɩ da kɩ da ʊ. Bɩ gʊaa k'a zɩ bɔ ʊ gɛɛ a da a bɔ ʊ, pakra m, kʊ n n a zɛ gər.› ");
INSERT INTO bib_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","B'awɔɔ ʊ, kʊ gʊaa a hɩ a zɩ m, gɛɛ a da m, a ʊ: ‹Daahan kʊ mɔɔ m ga m, m a ka ɩbɩɩ ʊ bɩ, Woso hɔ nɩ.› ");
INSERT INTO bib_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Pakra bɛɛ m kʊ gʊaa bɩ do m a da a zɩ kan a da kɩ han y. Woso lemim bɩ zar awɔɔ nawʊrɛ ncɩnaaʊ a yɩnnɩbayɩrɔ wɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Zambʊzannɔ, Ezayii gumə ta ʊ, an awɔɔ mim hɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Gʊɔɔ nɔɔn duro, mɔɔ da ŋ nawʊŋ ʊ a lɛ m, bɩ ŋ heer laatʊ mɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Daʊrɛ kʊ ŋ n'a kam mɔɔ ʊ bɩ, vam m. Bala, durnya mim ŋn'a dɩndam gʊɔɔ m, ɩ ʊ Woso hɔ m.» ");
INSERT INTO bib_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Bɩ jɛ ʊ bɩ, Yeezuu zamaa bɩ bir, an a hɩ ŋ nɩ, a ʊ: «K'a tʊr ka mɩŋŋa k'a jɩ ma! ");
INSERT INTO bib_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hɔ k'a nɩ gasʊm gʊaa lɛ ʊ an ta a nɔ ʊ bɩ bɛɛ nɩ dintim kam ma y, bɩ hɔ k'a nɩ bɔm gʊaa lɛ ʊ bɩ nɩ dintim kam ma.» ");
INSERT INTO bib_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","A m naa, karɩndanyɩnɔ wɔɔ n a zɔ ma, ŋn'a hɩ m, ŋ ʊ: «Farizɛɛnrɔ wɔɔ kʊ ŋ naa ma bɩ, ɩbɩɩ dɔ ɩ ʊ, a busu ŋ ma ra?» ");
INSERT INTO bib_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A n a nyɩ bɔ ʊ, a ʊ: «Hɔ haay kʊ mɔɔ Zɩ k'a nɩ arzana ʊ bɩ n a sɔɔn bɩ, n y'a wʊrm. ");
INSERT INTO bib_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","K'a ŋ to, bʊʊrɔ nɩ bʊʊrɔ gaam. Bɩ, kʊ bʊʊ bʊr, an nɩ bʊʊ gaarɛ, ŋ gʊaa hɩɩya haay y'a zarm yaa ʊ!» ");
INSERT INTO bib_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pɩyɛɛr n a hɩ m, a ʊ: «Hɔbɔkʊrɛnoom naa do jɩ hɩ ʊ m.» ");
INSERT INTO bib_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yeezuu n a hɩ, a ʊ: «Awɔɔ gɔɔta, awɔɔ n a jɩ dɔ ra? ");
INSERT INTO bib_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Awɔɔ n a dɔ, a ʊ, hɔ haay k'a nɩ gasʊm gʊaa lɛ ʊ, an nɩ tarɛ a nɔ ʊ bɩ, ta an nawʊm, an nɩ bɔm garga ra ra? ");
INSERT INTO bib_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bɩ, hɔ k'a nɩ bɔm gʊaa lɛ ʊ bɩ, a to a nawʊm gʊaa heer ʊ, bɩ nɩ dintim kam ma. ");
INSERT INTO bib_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bala, gʊaa heer hɔɔndarɛ bʊnyaarɔ wɔɔ nɩ bɔŋ ʊ: gərzɛrɛ, jaandarɛ, koorbarɛ, gʊɔɔ tɔ zarlɛ, kan sʊnsɔwʊrɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nawɔnnɔ nɩ dintim kam gʊaa ma, bɩ hɔbɩrɛ bɩ, ɩ n ɩ wɔ hir bɩ bɩr dintim kam gʊaa ma y.» ");
INSERT INTO bib_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeezuu k'a cem b'ʊ bɩ, a ta Tiir kan Sidɔn kɩ kʊrɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lʊ nɩ b'ʊ an ta Yeezuu zi, zɩɩfʊ bɛɛ nɩ y, Kanaan do nyɩ m, an a hɩ Yeezuu m, a ʊ: «M cicir zɛ Zuuba, *Davɩd Nyɩ, mɔɔ nyɩmbʊɛɛrɛ zinə n ta m, an nɩ fɩr kam ma gʊta.» ");
INSERT INTO bib_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yeezuu n a nyɩ bɔ nʊ y. A karɩndanyɩnɔ wɔɔ n a zɔ ma, ŋn'a yɛ han, ŋ ʊ: «La lʊ naa do ra, bala, a ɩ wɔɔ kɔm kan a zeedarɛ kɩ.» ");
INSERT INTO bib_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Mɔɔ nyɔɔ n y'a ʊ Israyɛl gʊɔɔ kʊ ŋ bɔ kʊ ʊ kan seero kʊ ŋ nyaam nɔ wɔɔ kɩ zi.» ");
INSERT INTO bib_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bɩ, lʊ b'a gu an bɩ kukurə zɛ a taa, an a hɩ m, a ʊ: «Zuuba, bʊr ɩ da mɔɔ han!» ");
INSERT INTO bib_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «A n a ga m, n nɩ nyɩnɔ hɔbɩrɛ sa, n n a ka jinnyɩnɔ ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Lʊ bɩ n a nyɩ bɔ ʊ, a ʊ: «Sɩra m, Zuuba, baa jinnyɩnɔ wɔɔ ɩ hɔbɩrɛ bʊtʊ k'a a lo ŋ zuubarɔ wɔɔ taa bɩ gʊrlɛ, ŋn'a bɩrɛ.» ");
INSERT INTO bib_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","A m naa Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Lʊ, ɩ sɩrakarɛ gandaa ʊ! Ɩ hɔ k'ɩ lɛ n taa bɩ yɩm!» Lɛɛm bɩ, a nyɩmbʊɛɛrɛ b'a waa wakatɩ bɩ do ʊ. ");
INSERT INTO bib_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeezuu a hʊr b'ʊ, an ta Galilee higʊta lɛ ra, an aa der ci ra, an nyɩnta. ");
INSERT INTO bib_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Gʊɔɔ cir gʊta bʊr zi, lʊgɔrɔ m, bʊʊrɔ m, gandeenzannɔ m, bəətinno kan yaabazannɔ vantɔɔ kɩ m, ŋnɩ bɩ ŋ nyɩnta Yeezuu taa, an ŋ waa. ");
INSERT INTO bib_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Gʊɔɔ wɔɔ n zɛ kədə, kʊ bəətinno nɩ meer barɛ, gandeenzannɔ n a gannɔ yɩ, lʊgɔrɔ nɩ tam mɩŋŋa, bʊʊrɔ nɩ lɛɛ yɩm bɩ minto. Ŋ y'a lɛ bɔ Israyɛl Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yeezuu a karɩndanyɩnɔ wɔɔ bir an a hɩ ŋ nɩ, a ʊ: «Zamaa bɩ cicir ɩ mɔɔ zɛm, bala, a dɔmɩm kaakʊ hɔ m naa, ŋ nɩ kan mɔɔ kɩ, hɔsɩ ba ŋ ʊ, ŋn'a bɩrɛ y. Mɔɔ lɛ baa kʊ m ŋ da zaa ra kan nɔ kɩ y. Kʊ n bɛɛ nɩ, ŋ y'a dundom zaa ra.» ");
INSERT INTO bib_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Karɩndanyɩnɔ wɔɔ n a hɩ m, ŋ ʊ: «K'ʊ bur yɩ ka pooyaa ʊ naa ʊ, ʊ a ka gʊɔɔ cir naa ʊ, k'an ŋ ka?» ");
INSERT INTO bib_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeezuu n ŋ lar, a ʊ: «Bur karɔ n ta awɔɔ ʊ?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Saanhɩna kan zɔ poorenyɩnɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","A n lɛ ka kʊ zamaa bɩ n nyɩnta tara ʊ. ");
INSERT INTO bib_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A n bur saanhɩna bɩ sa kan zɔnɔ wɔɔ kɩ an yaa da Woso m barka, an n'a zɩnzɛm la, an n'a kam a karɩndanyɩnɔ wɔɔ ʊ, ŋn'a kam, zamaa b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ŋ n a bɩ, an ŋ ka, an a yɔ, ŋn'a kuuro gʊr kasɩ lɛ ma saanhɩna. ");
INSERT INTO bib_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Zamaa bɩ gʊɔɔyaarɔ a zɔ tisi si ma, n n lannɔ kan nyɩnɔ kɩ lɛ sa y. ");
INSERT INTO bib_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bɩ jɛ ʊ bɩ, Yeezuu ŋ da zaa ra, an da kɔɔlʊʊ b'ʊ an ta Magadaan ʊ. ");
INSERT INTO bib_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farizɛɛnrɔ kan sadisɛɛnrɔ kɩ a zɔ Yeezuu ma, ŋnɩ hoser yɛ han, k'a makra ba. ");
INSERT INTO bib_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Kʊ woso lɛ a zo, b'awɔɔ ʊ, lɛɛ yɩm mɩŋŋa, bala, brama bɩ piin…. ");
INSERT INTO bib_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Dɔgta m, b'awɔɔ ʊ la bam her, bala, brama bɩ piin… b'a kundə sɔ. Awɔɔ brama mim dɔ, b'awɔɔ b'a dam ma a hɔɔ kʊ ŋ nɩ bam dɩɩtaa rɔ wɔɔ jɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Her gʊɔɔ bʊnyaarɔ kʊ ŋ bɩr Woso lɛ sim nɔ wɔɔ ɩ hoser yɛrɛ, bɩ ŋ bɩ hoser vanta yɩrɛ kʊ Zonas hɔ bɩ bɛɛ y.» A n a gʊ ŋ ma, an cem. ");
INSERT INTO bib_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","A hʊr kʊ Yeezuu ʊ kan a karɩndanyɩnɔ wɔɔ kɩ ŋnɩ bra higʊta bɩ gəm deem bɩ ra bɩ, bur tɔ bɔ karɩndanyɩnɔ wɔɔ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a dundo a zi, k'a a ba laatʊ farizɛɛnrɔ kan sadisɛɛnrɔ kɩ nyʊnyɔɔ bɩ ma.» ");
INSERT INTO bib_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ŋ n bɔkarɛ, ŋn'a hɩm kʊ m, ŋ ʊ: «Kʊ wɔɔ n bur sa bɩ y'a ka an naa hɩ.» ");
INSERT INTO bib_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeezuu n a dɔ, an a hɩ ŋ nɩ, a ʊ: «A lɔ awɔɔ n'a hɩm kʊ m, a ʊ: kʊ wɔɔ n bur sa bɩ minto nɩ? Awɔɔ sɩrakarɛ bɩ gʊta y! ");
INSERT INTO bib_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Awɔɔ gɔɔta a bɩr naa jɩ dɔm na? Kʊ mɔɔ bur soor zɩnzɛ ra, m a ka gʊɔɔyaarɔ tisi soor ʊ bɩ, a tɔ b'awɔɔ nɔ ʊ ra? Awɔɔ kuuro gʊr kasɩ lɛ ma karɔ? ");
INSERT INTO bib_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bɩ, kʊ mɔɔ bur saanhɩna zɩnzɛ ra m a ka gʊaa tisi si ʊ bɩ, kasɩ lɛ ma karɔ awɔɔ kuuro gʊr ʊ? A tɔ b'awɔɔ nɔ ʊ ra? ");
INSERT INTO bib_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","A a ba lɔ awɔɔ n a jɩ ma, a ʊ, bur bɛɛ mɔɔ n'a hɩm ma? K'a dundo a zi kan farizɛɛnrɔ, sadisɛɛnrɔ nyʊnyɔɔ bɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","A m naa, karɩndanyɩnɔ wɔɔ n bɔkarɛ, ŋn'a jɩ ma, ŋn'a dɔ ŋ ʊ, bur barɛ nyʊnyɔɔ bɛɛ an n'a hɩm ma y. Farizɛɛnrɔ kan sadisɛɛnrɔ kɩ hɔdɩndarɛ an n'a hɩm ma. ");
INSERT INTO bib_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ŋ yaa lee ku kʊ kʊ n n'a hɩm ma, ŋ ʊ: Filipi-Sezaaree kʊrɔ wɔɔ ʊ. Yeezuu laaka da a karɩndanyɩnɔ wɔɔ han, a ʊ: «Gʊɔɔ wɔɔ y'a hɩrɛ, ŋ ʊ: nka m Gʊaanyɩ bɩ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Gɔsɩnnɔ y'a hɩrɛ, ŋ ʊ: Zaan-Batiisi m, nawɔnnɔ ʊ: *Elii m, gɔsɩnnɔ a ya, ŋ ʊ: Zeremii m, gɛɛ, wosolɛsinnɩsorazannɔ wɔɔ deem m.» ");
INSERT INTO bib_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A n ŋ lar, a ʊ: «B'awɔɔ, awɔɔ y'a hɩrɛ, a ʊ: nka m mɔɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pɩyɛɛr n meerbaa bɩ si, an a nyɩ bɔ ʊ, a ʊ: «Krista bɩ n'ɩbɩɩ m, Woso k'an mɩsɩr bɩ nyɩ.» ");
INSERT INTO bib_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeezuu n a hɩ m, a ʊ: «Mimbirenyɩntazaa n'ɩbɩɩ m, Sɩmɔɔn, Zonas nyɩnnɩ, bala, gʊaa bɛɛ sɩra naa do hɩnka ɩbɩɩ nɩ y. Mɔɔ Zɩ k'a nɩ arzana ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Bɩ, mɔɔ y'a hɩrɛ ɩbɩɩ m, Pɩyɛɛr n'ɩbɩɩ m, bɩ ci naa do mɔɔ n nɩ m sokʊma bɩ dɔrɛ a burə ʊ. Zɛ kan a paŋŋa kɩ bɩ bʊrm la y. ");
INSERT INTO bib_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mɔɔ Woso cirbəə cɛnyɩrɔ karɛ ɩbɩɩ ʊ, hɔ haay k'ɩbɩɩ n n'a kʊsɩm tara burə ʊ bɩ, n y'a kʊsɩm arzana ʊ, hɔ haay k'ɩbɩɩ n n'a hʊrm tara burə ʊ bɩ, n y'a hʊrm arzana ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Naa do jɛ ʊ, a lɛ ka ŋ ʊ mɩŋŋa, a ʊ: ŋ b'a hɩ gɔsɩ m, ŋ ʊ, Krista n'awɔɔ nɩ y. ");
INSERT INTO bib_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A n a sa wakatɩ bɩ do ma, Yeezuu a sɩŋŋɩda sa, an nɩ hɔ dɩndarɛ a karɩndanyɩnɔ wɔɔ m, a ʊ: «Pakra m, kʊ m ta Zerizalɛm ʊ kʊ m aa fɩr yɩ gʊta gʊɔɔgusinno kan wosocɛmannɩbənno jɩtannɔ, wosocikarɩnsaambɔɔ kɩ wɔ ʊ. Ŋ mɔɔ zɛm gər. B'a dɔmɩm kaakʊ hinni ʊ, Woso mɔɔ mɩm bɔŋ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pɩyɛɛr n Yeezuu gaa, an bɔ m toore ma, an nɩ nyaa bam kan kɩ, a ʊ. «Woso dɔrɛ ɩ ma kan naa kɩ Zuuba, mim naa do b'ɩ b'ɩ yɩrɛ y.» ");
INSERT INTO bib_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Bɩ, Yeezuu a bɔ, an a hɩ Pɩyɛɛr m, a ʊ: «Ɩ jɛ bɔ mɔɔ jɩr ʊ! Sʊtaana, mɔɔ makra ɩbɩɩ n'a bam, ɩbɩɩ hɔɔndarɛ bɩ n bɔ kʊ ʊ kan Woso hɔ kɩ y. Gʊɔɔ hɔɔndarɛ m.» ");
INSERT INTO bib_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bɩ kur bɩ, Yeezuu a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «Kʊ gʊaa lɛ taa k'a zu mɔɔ ʊ, k'an sɔ a mɩŋŋa m, k'an a gɔdarkʊra busu, an zu mɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bala, kʊ gʊaa lɛ taa k'a a meeyaa bʊmbɔ, a b'a meeyaa bʊmbɔrɛ yɩrɛ y. Bɩ, kʊ gʊaa ga mɔɔ tɔ ma a y'a meeyaa bʊmbɔrɛ yɩrɛ. ");
INSERT INTO bib_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bɩ, kʊ gʊaa a so durnya hɔ haay ʊ, an bɔkarɛ an kʊrɔ mɩsɩrbaa k'a nyarɛ ba ʊ bɩ ma, a nyɔɔdʊ ɩ ka? Gɛɛ gʊaa y'a mɩsɩrbaa lʊrm kan bɔ kɩ? ");
INSERT INTO bib_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bala, Gʊaanyɩ bɩ zɛrɛ a Zɩ lɛbɔʊrɛ nɔ ʊ kan a malɛɛkarɔ kɩ. Dɔmɩm bɩ do ʊ bɩ, a gʊaa biyəə zibəə nyɔɔdʊ kaŋ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yeezuu a ya, an a hɩ ŋ nɩ, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m, gʊɔɔ kʊ ŋ nɩ naa ʊ naa, gɔsɩnnɔ zɛ b'a kure, kʊ ŋ n Gʊaanyɩ bɩ yɩ an bʊr a cirbəə nɔ ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dɔmɩm sɔrdɩ kur bɩ, Yeezuu Pɩyɛɛr gaa, kan Zakkɩ kɩ a danzaa Zaan kɩ, an bɔ ŋ nɩ toore ma a minto, ci jintə mim ʊ. ");
INSERT INTO bib_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","A n a lʊr ŋ mɩm ʊ. A meer nɩ yɔm am wosogure hɔ bɩ m, a huuro wɔɔ nɩ nyakɩ bɔm, ŋn'a ba fu fɩrr…. ");
INSERT INTO bib_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","*Elii n a hɩnka ŋ nɩ kan Moyiisi kɩ, ŋn'ɩ meer bam kan Yeezuu kɩ. ");
INSERT INTO bib_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pɩyɛɛr n a hɩ Yeezuu m, a ʊ: «Zuuba, kʊ wɔɔ ɩ naa ʊ, a mɩŋŋa. K'ɩ lɛ taa, kʊ m bur ba kaakʊ: ɩbɩɩ hɔ deem, Moyiisi hɔ deem, Elii hɔ deem.» ");
INSERT INTO bib_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","K'a nɩ meer barɛ ncɩnaaʊ bɩ, warkʊ k'a nɩ yɔm bʊr an b'a ku ŋ la. Meerbaa n a to warkʊ bɩ nɔ ʊ, a ʊ: «Ba mɔɔ Nyɩ m na. Mɔɔ ŋʊa gʊta. A mɔɔ nɔ yɩ paan…. K'a a tʊr ka ma.» ");
INSERT INTO bib_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Karɩndanyɩnɔ wɔɔ kʊ ŋ naa ma bɩ, ŋ y'a dundo, ŋn'a meer kunku tara ma, dabɔʊ gʊta k'a ŋ nyasʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeezuu n a zɔ ŋ ma, an a wɔ da ŋ ma, an a hɩ, a ʊ: «K'a wuti, a da bɩ bɔ ʊ y!» ");
INSERT INTO bib_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kʊ ŋ y'a bɔ ŋnɩ dɩga bɩ, ŋ n gɔsɩ yɩ dɔ, kʊ Yeezuu y'a deem bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kʊ ŋ n'ɩ zerm ci bɩ ra bɩ, a lɛ ka ŋ ʊ, a ʊ: «Hɔ k'awɔɔ yɩ naa, a b'a hɩ gɔsɩ nɩ y, k'an ta, an Gʊaanyɩ bɩ mɩmbɔʊrɛ ku gəəno bire ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A karɩndanyɩnɔ wɔɔ n a lar, ŋ ʊ: «Bɔ m wosocikarɩnsaambɔɔ wɔɔ ʊ, Elii lɛɛkarɛ an bʊr?» ");
INSERT INTO bib_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Sɩra m, Elii nɩ lɛɛkarɛ an bʊr k'a bɩ hɔ haay banka. ");
INSERT INTO bib_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, Elii bʊr kara, bɩ ŋ n a dɔ y, a hɔɔnhɔ ŋ y'a ba m. Gʊaanyɩ bɩ fɩr yɩrɛ ŋ wɔ ʊ maam sɔ.» ");
INSERT INTO bib_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","A m naa, karɩndanyɩnɔ wɔɔ n a dɔ, ŋ ʊ, Zaan-Batiisi an n'a hɩm ma. ");
INSERT INTO bib_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kʊ ŋ lee ku zamaa cir gʊta bɩ zi bɩ, gʊaa a zɔ Yeezuu ma, an kukurə zɛ a taa, an a hɩ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Karɩnsaamba, m nyɩnnɩ cicir zɛ, hɔɔ n'a zɛm, an nɩ fɩr yɩm gʊta, a tɩr a da sɛ ʊ, gɛɛ hi ʊ. ");
INSERT INTO bib_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mɔɔ n bʊr m ɩ karɩndanyɩnɔ wɔɔ zi, bɩ, ŋ n a da ma, ŋn'a waa y.» ");
INSERT INTO bib_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeezuu n meerbaa bɩ sa, a ʊ: «Zamaana sɩrakarɛwar zannɔ, gʊɔɔ bʊnyaarɔ, mɔɔ dɔmɩm bam karɔ kan awɔɔ kɩ? Dɔmɩm karɔ mɔɔ nɩ m yarɛ, m yɛ kɔrɛ ma awɔɔ minto? K'a bʊr m mɔɔ zi.» ");
INSERT INTO bib_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yeezuu n həən si zinə bɩ ma, an bɔ nyɩ bɩ mɛ ʊ, nyɩ bɩ n laafɩɩ yɩ wakatɩ bɩ do ʊ. ");
INSERT INTO bib_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Karɩndanyɩnɔ wɔɔ n a zɔ Yeezuu ma, ŋn'a lar a deem, ŋ ʊ: «Bɔ y'a ka wɔɔ n ʊ da ma, ʊ la zinə bɩ ra?» ");
INSERT INTO bib_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","A n a hɩ ŋ nɩ, a ʊ: «Awɔɔ sɩrakarɛ k'an poore bɩ m. Bala, sɩra mɔɔ n'a hɩrɛ awɔɔ m, k'awɔɔ sɩrakarɛ bɔ kʊ ʊ kan mutardɩ yaa kɩ, awɔɔ y'a hɩm ci naa do m, a ʊ: wuti, ɩ ta lɛɛ naa do ʊ! A wutire an ta, awɔɔ bɩ jɩram hɔsɩ barɛ ra y.  ");
INSERT INTO bib_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Bɩ, zinə ncɩnaaʊ bɩ, hɔ ba ʊ an b'a dam ma an a ka, an bɔ, kʊ yaadarɛ bɛɛ kan lɛkʊsɩrɛ kɩ y.» ");
INSERT INTO bib_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Hindeem ʊ, karɩndanyɩnɔ wɔɔ kʊ ŋ y'a so kʊ ma haay Galilee ʊ bɩ, Yeezuu a hɩ ŋ nɩ, a ʊ: «N Gʊaanyɩ bɩ dam gʊɔɔ wɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ŋ y'a zɛm, b'a dɔmɩm kaakʊ hinni ʊ, Woso y'a mɩm bɔŋ ʊ.» Meerbaa naa do ŋ heer zar gʊta. ");
INSERT INTO bib_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kʊ Yeezuu kan a karɩndanyɩnɔ wɔɔ kɩ lee ku Kapɛrnawum ʊ bɩ, Wosocɛ yawʊrsinno a zɔ Pɩyɛɛr ma, ŋn'a lar, ŋ ʊ: «Awɔɔ karɩnsaamba bɩ bɩr Wosocɛ yawʊr kam na?» ");
INSERT INTO bib_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pɩyɛɛr n a nyɩ bɔ ʊ, a ʊ: «A y'a kam.» Pɩyɛɛr k'a lee ku har ʊ bɩ, Yeezuu lɛɛ ka m an a lar, a ʊ: «Sɩmɔɔn, kan ɩbɩɩ kɩ, nkɔɔ durnya cinno nɔɔm nɩ yawʊr sire ŋ han? Ŋ nyɩnɔ m gɛɛ, saanɔɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pɩyɛɛr n a nyɩ bɔ ʊ, a ʊ: «Saanɔɔ m.» Yeezuu n a hɩ m, a ʊ: «K'a maam ŋ nyɩnɔ wɔɔ ba ŋ barla y. ");
INSERT INTO bib_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bɩ k'ʊ lɛ baa kʊ ŋ n'a hɩ, ŋ ʊ, ʊ ʊ zar a ma bɩ, ta higʊta b'ʊ, ɩ yaa ka zo hi b'ʊ. Zɔ niŋŋə k'a nɩ lɛɛ kam an ka bɩ mom bɩ, bɔ zɔ bɩ do m, ɩ lɛ gʊ, ɩbɩɩ busoo yɩrɛ a lɛ b'ʊ, an nɩ mɔɔ kan ɩbɩɩ kɩ yawʊr karɛ bɔm. K'ɩ bɔ ʊ, ɩ b'a ka yawʊrsinno wɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wakatɩ bɩ do ʊ bɩ, karɩndanyɩnɔ wɔɔ a zɔ Yeezuu ma, ŋn'a lar, ŋ ʊ: «Nka m jɩtaarɛ Woso cirbəə bɩ nɔ ʊ?» ");
INSERT INTO bib_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yeezuu n nyɩ poore bir an a jɩm ŋ bire ʊ, ");
INSERT INTO bib_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","an bɔkarɛ, an a hɩ ŋ nɩ, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m, k'awɔɔ n a lʊr a a ba, am nyɩ poore hɔ bɩ nɩ, awɔɔ bɩ gasʊm Woso cirbəə b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Gʊaa k'a n'a mɩŋŋa zerm am nyɩ hɔ bɩ m bɩ, bɩ zaa n jɩtaarɛ Woso cirbəə b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Gʊaa k'a nyɩ poore si mɔɔ tɔ ma am nyɩ naa do m bɩ, mɔɔ mɩŋŋa a yɩ m si.» ");
INSERT INTO bib_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Bɩ, kʊ gʊaa a ka nyɩnɔ kʊ ŋ sɩra ka mɔɔ rɔ nɔɔn duro gʊaa deem n a do mimbʊnyaa nɔ ʊ, kʊ n jɛnlajaa gʊta kʊsɩ a wer ma, n n a da higʊta ʊ, a jɩra. ");
INSERT INTO bib_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kʊsɩ nɩ kan durnya kɩ, kʊ minno n ta ʊ, ŋn'ɩ gʊɔɔ dom mimbʊnyaa nɔ ʊ bɩ minto. Minno wɔɔ duro bɩ nyam durnya nɔ ʊ y, bɩ kʊsɩ ɩ kan gʊaa k'a ka ŋn'ɩ zɛm bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","K'ɩ wɔ gɛɛ, ɩ gam y'ɩ dam mimbʊnyaa barɛ ma, k'ɩ zɛ ra, ɩ zo laatʊ ɩ ma k'ɩ gasʊ mɩsɩrbaa k'a nyarɛ ba ʊ b'ʊ, ɩ wɔ deem m, gɛɛ ɩ gam deem m, bɩ jɩra, gasʊ k'ɩbɩɩ nawʊrɛ ɩ wɔ hɩɩya m, gɛɛ ɩ gam hɩɩya m sɛhar k'a lihire ba ʊ bɩ nɔ ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","K'ɩ mɩnyaa y'ɩ dam mimbʊnyaa barɛ ma, k'ɩ bɔ ʊ ɩ zo laatʊ ɩ ma, k'ɩ gasʊ ɩ mɩnyaa deem m mɩsɩrbaa k'a nyarɛ ba ʊ bɩ nɔ ʊ, bɩ jɩra, gasʊ k'ɩbɩɩ nawʊrɛ ɩ mɩm hɩɩya m sɛhar ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","K'a dundo a zi, a b'a ka a nyɩnɔ nɔɔn duro gʊaa deem bɔ ʊ y. Bala, sɩra mɔɔ n'a hɩrɛ awɔɔ m, arzana ʊ bɩ, ŋ malɛɛkarɔ ɩ mɔɔ Zɩ k'a nɩ arzana ʊ bɩ mɛ yɩm wakatɩ haay.  ");
INSERT INTO bib_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bala Gʊaanyɩ bɩ, bʊr a ʊ, k'a gʊɔɔ kʊ ŋ nyaam nɔ wɔɔ bʊmbɔ. ");
INSERT INTO bib_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Awɔɔ y'a hɔɔn dam lʊnlɔ? Kʊ gʊaa ɩ seero m zɔrɔ, deem n a bɔ ʊ an nyaam, a bɩ bunɛɛhʊ a yaa nɛɛhʊ rɔ wɔɔ tom zigi ra, an ta an aa a ka deem k'a nyaam bɩ ma ra? ");
INSERT INTO bib_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","K'a ser bɩ yɩ, a heer yɩm nyɩnta kan kɩ an lɛ da bunɛɛhʊ a yaa nɛɛhʊ rɔ kʊ ŋ n nyaam nɔ wɔɔ ra. ");
INSERT INTO bib_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Awɔɔ Zɩ k'a nɩ arzana ʊ bɩ lɛ baa sɔ kʊ nyɩnɔ nɔɔn duro gʊaa deem n nyaam y. ");
INSERT INTO bib_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","K'ɩ danyɩ a zar ɩ ma, k'ɩ ta zi, ɩ yaa hɔ k'a ba ɩbɩɩ m bɩ hɩ m, ɩbɩɩ kan kɩ a hɩɩya. K'a ɩbɩɩ mim bɩ si, k'ɩ dɔ ɩ ʊ, awɔɔ a zɛ kʊ ra. ");
INSERT INTO bib_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bɩ, k'a n a tʊr ka ɩ ma, k'ɩ gʊaa na ɩ ma deem gɛɛ hɩɩya, amba Wosoci a hɩ, a ʊ: ‹Gʊaa hɩɩya gɛɛ kaakʊ y'a ga mim kasɛtɩ barɛ m.› ");
INSERT INTO bib_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kʊ gʊaa bɩ lɛ baa k'a tʊr ka brɔɔ ma sɔ, k'ɩ hɩ kristagʊɔɔ sokʊma bɩ m. K'a ʊ a b'a tʊr kam kristagʊɔɔ sokʊma bɩ ma, k'ɩ dɩga ma kɩfɩr gɛɛ, yawʊrsirezaa. ");
INSERT INTO bib_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Sɩra mɔɔ n'a hɩrɛ awɔɔ m: hɔ haay, k'awɔɔ n'a gum ma tara burə ʊ naa ʊ, n y'a gum ma sɔ Woso cirbəə nɔ ʊ. Hɔ haay k'awɔɔ nɩ yɛm ma tara burə ʊ, n yɛm ma sɔ Woso cirbəə nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mɔɔ m ya, m n'a hɩrɛ awɔɔ m sɔ: K'awɔɔ gʊaa hɩɩya a zɛ kʊ ra tara burə ʊ naa ʊ, k'a hɔ niŋŋə haay yɛ yaadarɛ nɔ ʊ, mɔɔ Zɩ k'a nɩ arzana ʊ bɩ hɔ bɩ do karɛ ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bala, lɛɛ kʊ gʊɔɔ a so kʊ ma ʊ hɩɩya gɛɛ kaakʊ mɔɔ tɔ ma bɩ, mɔɔ yɩ ŋ bireyaa ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pɩyɛɛr n a zɔ Yeezuu ma, an a hɩ m, a ʊ: «Zuuba, kʊ mɔɔ danyɩ a zar mɔɔ ma, gallɛm karɔ mɔɔ nɩ sugur kaŋ ʊ? Gallɛm saanhɩna gɛɛ?» ");
INSERT INTO bib_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeezuu n a hɩ m, a ʊ: «Mɔɔ n a hɩ ɩbɩɩ m, mɔɔ ʊ gallɛm saanhɩna y, bɩ, gallɛm busaanhɩna a gallɛm saanhɩna.» ");
INSERT INTO bib_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Naa do minto bɩ, Woso cirbəə bɩ bɔ kʊ rɛ kan cir k'a wuti k'a a zibəənyɩnɔ lar ŋ zibəə ma. ");
INSERT INTO bib_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","A sɩŋŋɩda k'a k'a ba bɩ, bʊr n y'a ʊ zibəənyɩ deem m, an ta talan waa bu zɩm m. ");
INSERT INTO bib_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bɩ, gʊaa bɩ ba hɔsɩ m an b'a zɩm bɩ karɛ y. A m bɩ, cir bɩ n lɛ ka, kʊ n nɩ gʊaa bɩ hɛɛ kan a lʊ kɩ, a nyɩnɔ kɩ, kan hɔ niŋŋə k'an ta m haay kɩ, k'a cɩnta zɩm bɩ bɩncɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","A m naa, zibəənyɩ bɩ n kukurə zɛ cir bɩ taa, an cicir ba a lɛ ra, a ʊ: ‹M cicir zɛ, mɔɔ yɩ m zɩm bɩ kam haay!› ");
INSERT INTO bib_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Gʊaa bɩ cicir n cir bɩ nyasʊ, an zɩm bɩ to m, an a da zaa ra. ");
INSERT INTO bib_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Zibəənyɩ bɩ n bɔ, an a muno wɔɔ deem zɛ ʊ zaa ra, a zɩm n ta ra *deniyee zɔrɔ, an a wɔ so a bʊkɔ ʊ, an n'a ŋʊam k'a hoonsi ta rɛ, an n'a hɩm nɩ, a ʊ: ‹M zɩm bɩ ka m ʊ.› ");
INSERT INTO bib_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A mim bɩ n kukurə zɛ a taa, an cicir ba a lɛ ra, a ʊ: ‹M cicir zɛ, mɔɔ yɩ m zɩm bɩ kam.› ");
INSERT INTO bib_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bɩ, gʊaa b'a gu, an ta, an aa a ka, n n a du lɔnnɔcɛ ʊ, k'an tolle ba, an zɩm bɩ ka, an a nya. ");
INSERT INTO bib_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Zibəənyɩnɔ mɩsɩrɔ wɔɔ kʊ ŋ naa yɩ bɩ, ŋ heer a zar gʊta, ŋnɩ ta, ŋn'aa hɔ haay woo… k'a ba bɩ hɩ cir bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Cir bɩ n zibəənyɩ bɩ bir an a hɩ m, a ʊ: ‹Zibəənyɩ bʊnyaa, mɔɔ ɩ zɩm bɩ to ɩbɩɩ m haay, k'ɩbɩɩ cicir ba mɔɔ lɛ ra bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ɩbɩɩ n ɩ da ma sɔ, ɩ ɩ mim bɩ cicir zɛ, amba mɔɔ ɩbɩɩ cicir zɛ bɩ n na?› ");
INSERT INTO bib_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Cir bɩ nɔ n ma ʊ gʊta, an gʊaa bɩ du lɔnnɔcɛ ʊ k'an fɩr yɩ, k'an zɩm bɩ ka haay.» ");
INSERT INTO bib_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yeezuu n a ya, an a na ma, a ʊ: «Mɔɔ Zɩ k'a nɩ arzana ʊ bɩ y'a barɛ awɔɔ m ncɩnaaʊ, k'awɔɔ bɩr sugur kam kʊ ʊ kan a heer kɩ haay y.» ");
INSERT INTO bib_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yeezuu k'a naa do dɩnda haay bɩ, a a hʊr Galilee ʊ, an ta Zidee ʊ, Zʊrdɛn kur. ");
INSERT INTO bib_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Zamaa cir gʊta zu a jɛ ʊ, an ŋ yaabazannɔ waa b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farizɛɛnrɔ n a zɔ ma, k'a nyasʊ meerbaa nɔ ʊ, ŋnɩ laaka da han, ŋ ʊ: «Gʊaa a da ma, an la a lʊ ra, baa kʊ mim kara m na?» ");
INSERT INTO bib_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A n a nyɩ bɔ ʊ, a ʊ: «Awɔɔ n a karɩnda ba Wosoci b'ʊ ra? A ʊ: ‹A sɩŋŋɩda ʊ bɩ, Woso gʊaa da kan lʊ kɩ.› ");
INSERT INTO bib_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A n a hɩ ŋ nɩ, a ʊ: ‹Bɩ y'a ka: gʊaa y'a gʊrɛ a zɩ kan a da kɩ ma, an a zɛ kʊ ra kan a lʊ kɩ, ŋ gʊaa hɩɩya bɩ n a ba deem.› ");
INSERT INTO bib_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ncɩnaaʊ bɩ, ŋ bɩ hɩɩya dɔ y, ŋ deem. Bɩ, gʊaa bɩ hɔ kʊ Woso a zɛ kʊ ra bɩ gʊngʊm kʊ ma y.» ");
INSERT INTO bib_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farizɛɛnrɔ wɔɔ n a lar, ŋ ʊ: «Bɔ m Moyiisi ʊ, n nɩ harcɩntarɛ kaansʊrɛ ci ba, kʊ n nɩ bɔkarɛ n nɩ la lʊ ra?» ");
INSERT INTO bib_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Awɔɔ heerkarɛ minto y'a ka Moyiisi n lɛ ka k'awɔɔ n la a lannɔ ra. Bɩ, durnya sɩŋŋɩda ʊ bɩ, ncɩnaaʊ bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Sɩra mɔɔ n'a hɩrɛ awɔɔ m: kʊ gʊaa la a lʊ ra, bɩ lʊ bɩ n jaan da y, an lʊ vanta sa, gʊaa bɩ do, jaandarɛzaa m.» ");
INSERT INTO bib_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Karɩndanyɩnɔ wɔɔ n a hɩ m, ŋ ʊ: «Kʊ gʊaa kan a lʊ kɩ mim b'ɩ yɩrɛ ncɩnaaʊ, kʊ gʊaa n lʊ sa y, a jɩra.» ");
INSERT INTO bib_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Gʊaa haay bɛɛ nɩ hɔdɩndarɛ naa do sire y, bɩ gʊɔɔ kʊ Woso paŋŋa ka ŋ ʊ kʊ ŋ n'a si rɔ wɔɔ, brɔɔ y'a sim. ");
INSERT INTO bib_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Minno y'a hʊnhɔ y'a karɛ gʊɔɔ bɩr lʊ sire y: Gʊɔɔ ta ʊ, yɩ kʊ ŋ y'a ʊ bɩ, ŋ b'a dam ma ŋnɩ lʊ si y, gɔsɩnnɔ ta ʊ, gʊɔɔ y'a ba ŋ nɩ, gɔsɩnnɔ n ta ʊ, ŋ bɩr lʊ sire y Woso cirbəə bɩ minto. Gʊaa k'a n'a dam ma, an meerbaa naa do si bɩ, k'an a si.» ");
INSERT INTO bib_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Gʊɔɔ bʊr nyɩnɔ poorero m Yeezuu zi, k'an a wɔ ka ŋ mim la, an yaa da ŋ tɔ ma, bɩ karɩndanyɩnɔ wɔɔ n yɛ gʊɔɔ wɔɔ nɩ y, ŋn'a bam kan ŋ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yeezuu k'a naa yɩ bɩ, a a hɩ ŋ nɩ, a ʊ: «K'a nyɩnɔ poorero wɔɔ to, ŋnɩ bʊr mɔɔ zi, a b'a ta ŋ nɩ tolle y. Bala, gʊɔɔ kʊ ŋ bɔ kʊ ʊ kan nawɔnnɔ kɩ rɔ wɔɔ, ŋ hɔ m Woso cirbəə bɩ m.» ");
INSERT INTO bib_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A n a wɔ ka nyɩnɔ wɔɔ mim la, an a hʊr lɛɛ bɩ do ʊ. ");
INSERT INTO bib_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bɩ kur bɩ, gʊaa a zɔ Yeezuu ma, an a lar, a ʊ: «Karɩnsaamba, bɔ mɩŋŋa mɔɔ n'a barɛ m mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩ?» ");
INSERT INTO bib_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Bɔ m, ɩbɩɩ nɩ mɔɔ larm hɔ mɩŋŋa mim ma? Gʊaa mɩŋŋa ba ʊ kʊ Woso deem bɛɛ y. K'ɩbɩɩ lɛ taa k'ɩ gasʊ mɩsɩrbaa k'a nyarɛ ba ʊ bɩ nɔ ʊ, k'ɩ zu Woso lɛrɔ wɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Gʊaa bɩ n laaka da Yeezuu han, a ʊ: «Karɔɔ m Woso lɛrɔ wɔɔ barla?» Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Ɩ bɩ gər zɛ y, ɩ bɩ jaan da y, ɩ bɩ koor ba y, ɩ bɩ kasɛtɩ ŋʊaar ba ɩ ka ɩ mim la y, ");
INSERT INTO bib_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ɩ zɩ kan ɩ da kɩ da ʊ, ɩ ɩ mim ŋʊa amba ɩ ɩ mɩŋŋa ŋʊa bɩ m.» ");
INSERT INTO bib_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nyukumbueere bɩ n a hɩ m, a ʊ: «Mɔɔ zu lɛrɔ nɔɔn duro haay ʊ, bɔ ɩ gɔɔta mɔɔ n'a barɛ?» ");
INSERT INTO bib_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeezuu n a hɩ m, a ʊ: «K'ɩbɩɩ lɛ taa k'ɩ yɩ mɩŋŋa paan… k'ɩ ta ɩ yaa hɔ k'a n'ɩbɩɩ ʊ haay bɩ hɛɛ, ɩ busoo bɩ ka ŋʊazannɔ ʊ. Maam bɩ, ɩbɩɩ arzaka yɩm arzana ʊ. K'ɩ bʊr, ɩ bɩr zum mɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Bɩ, nyukumbueere bɩ k'a naa ma bɩ, a heer a zar gʊta, an a hʊr kan heerzar kɩ, bala, arzakazaa gʊta m. ");
INSERT INTO bib_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","A m naa, Yeezuu n a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m: a wer ta ʊ kʊ arzakazaa n gasʊ Woso cirbəə nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mɔɔ m ya, m n'a hɩrɛ: Yoonde gasʊ huuka yaa ʊ zanta, an lɛ da arzakazaa gasʊ Woso cirbəə bɩ nɔ ʊ m.» ");
INSERT INTO bib_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Karɩndanyɩnɔ wɔɔ n zɛ kədə meerbaa naa do minto, ŋn'a hɩrɛ, ŋ ʊ: «Bɩ nka n'a dam ma kɛɛrɛ an bʊmbɔrɛ yɩ?» ");
INSERT INTO bib_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeezuu n dɩga ŋ ma, an a hɩ ŋ nɩ, a ʊ: «Gʊɔɔ b'a dam ma y, bɩ, Woso a da hɔ haay ma.» ");
INSERT INTO bib_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pɩyɛɛr n meerbaa bɩ sa, a ʊ: «Dɩga, wɔɔ hɔ haay to k'ʊ zu ɩbɩɩ ʊ, a nyɩntam wɔɔ ma lɔ?» ");
INSERT INTO bib_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeezuu n a hɩ m, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m: kʊ Gʊaanyɩ bɩ bʊr an nɩ nyɩntam a cirbəəduu paŋŋazaa bɩ ra durnya daa b'ʊ, awɔɔ bueerehɩɩyɔɔ k'a zu mɔɔ ʊ naa, awɔɔ nyɩntam sɔ duuro ra kan mɔɔ kɩ k'ʊ Israyɛl do bueerehɩɩyɔɔ wɔɔ dʊdɔ ka. ");
INSERT INTO bib_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bɩ, gʊaa haay k'a gʊ a harlɔ ma, gɛɛ a danyɩnɔ ma, a danlʊrɔ ma gɛɛ a zɩ kan a da kɩ ma, a nyɩnɔ ma, a hɔsɩrarɔ ma mɔɔ tɔ ma bɩ, a nawɔnnɔ haay yɩm gallɛm zɔrɔ kan mɩsɩrbaa k'a nyarɛ ba ʊ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bɩ, lɛɛkarɛzannɔ gʊta nyɩntam jɛzannɔ, jɛzannɔ gʊta n nyɩnta lɛɛkarɛzannɔ.» ");
INSERT INTO bib_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Woso cirbəə bɩ bɔ kʊ rɛ kan gʊaa k'a wuti dɔgta mɩŋŋa m, k'a gʊɔɔ sa a dɩvɛnsɩra zibəə ma bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A n lɛ sa kan zibəəzannɔ wɔɔ kɩ k'a *deniyee deem ka ŋ ʊ hindeem zibəə busoo. A n ŋ nyɔɔ a hɔsɩra b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A n a ya, an a bɔ dɔgta wakatɩ nɛɛhʊ ma an gʊɔɔ gɔsɩnnɔ yɩ, ŋn'ɩ jɩnɩm daasɩyaa ʊ, bɩ ŋ ba zibəə nɩ y. ");
INSERT INTO bib_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A n a hɩ ŋ nɩ, a ʊ: ‹K'a ta mɔɔ hɔsɩra b'ʊ sɔ, mɔɔ y'awɔɔ zibəə busoo k'a a ga m karɛ awɔɔ ʊ.› ");
INSERT INTO bib_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ŋ n ta hɔsɩra b'ʊ. A n a ya, an bɔ sinsebir ʊ kan yirbəə wakatɩ kaakʊ kɩ ma, an a ya, an a ba maam sɔ. ");
INSERT INTO bib_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yirbəə wakatɩ soor k'a a ku bɩ, a a ya, an bɔ, an gʊɔɔ vantɔɔ yɩ ŋn'ɩ jɩnɩm daasɩyaa b'ʊ, an a hɩ ŋ nɩ, a ʊ: ‹Bɔ m, awɔɔ n gɔɔta naa ʊ dɔgta m saa…, b'awɔɔ ba zibəə nɩ y?› ");
INSERT INTO bib_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Gʊɔɔ wɔɔ n a hɩ m, ŋ ʊ: ‹Gɔsɩ n wɔɔ sa zibəə ma y.› A n a hɩ ŋ nɩ, a ʊ: ‹K'a ta mɔɔ hɔsɩra b'ʊ sɔ a yaa zi ba.› ");
INSERT INTO bib_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Lɛɛ k'a bʊr k'a lihi bɩ, dɩvɛnsɩra zaa b'a hɩ a zibəədɩgamazaa bɩ m, a ʊ: ‹Zibəəzannɔ wɔɔ bir, ɩ ŋ busoo ka ŋ ʊ. A sɩŋŋɩda ba gʊɔɔ kʊ ŋ bʊr jɛ ʊ rɔ wɔɔ ma, k'ɩ nyambʊr lɛɛkarɛzannɔ wɔɔ ma.› ");
INSERT INTO bib_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Gʊɔɔ kʊ ŋ bʊr yirbəə wakatɩ soor ma rɔ wɔɔ a zɔ, n nɩ deniyee deem-deem ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lɛɛkarɛzannɔ wɔɔ kʊ ŋ y'a zɔ bɩ, ŋ y'a hɔɔn darɛ ŋ ʊ, a y'a yɩrɛ an lɛ da. Bɩ, deniyee deem-deem ŋ y'a ka ŋ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Busoo bɩ kʊ ŋ n'a sim bɩ, ŋn'ɩ kukur bam hɔsɩrazaa bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ŋ ʊ: ‹Gʊɔɔ nɔɔn duro, bʊr ŋ y'a ʊ jɛ ʊ, ŋ n zi ba wakatɩ deem taan…, ɩbɩɩ n bɔkarɛ, ɩ busoo ka ŋ ʊ hɔdeem kan wɔɔ kɩ, bɩ zi wɔɔ ba, ʊ kɔ dɔgta m tee… woso n wɔ wɔɔ ʊ, am sɛ hɔ bɩ m!› ");
INSERT INTO bib_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hɔsɩrazaa bɩ n a hɩ ŋ gʊaa deem m, a ʊ: ‹M gʊaa, mɔɔ n tu ta ɩbɩɩ rɛ y, ɩbɩɩ n lɛ sa kan mɔɔ kɩ kʊ m deniyee deem ka ɩ ʊ hindeem zibəə busoo ra? ");
INSERT INTO bib_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ɩ zibəə busoo si k'ɩ hʊr. Mɔɔ lɛ taa kʊ m busoo ka gʊaa k'a bʊr jɛ ʊ naa ʊ, amba mɔɔ lɛ n taa kʊ m a ka ɩbɩɩ ʊ naa m. ");
INSERT INTO bib_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mɔɔ ba lɛ m kʊ m m hɔɔnhɔ ba m busoo m na? Gɛɛ nɔntaama n ta ɩbɩɩ m kʊ mɔɔ m mɩŋŋa bɩ minto ra!› » ");
INSERT INTO bib_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yeezuu n a ya, an a hɩ, a ʊ: «Ncɩnaaʊ bɩ, jɛzannɔ yɩm lɛɛkarɛzannɔ, lɛɛkarɛzannɔ n yɩ jɛzannɔ.» ");
INSERT INTO bib_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yeezuu a hʊr, an nɩ tam Zerizalɛm ʊ. A n karɩndanyɩnɔ bueerehɩɩyɔɔ wɔɔ gaa a hɔ, ŋn'ɩ tarɛ, an n'a hɩrɛ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«K'a tʊr ka, ta kʊ wɔɔ nawʊm Zerizalɛm ʊ naa, bɩ n nɩ zɛm bɩ Gʊaanyɩ bɩ nyasʊ ʊ, n n a ka wosocɛmannɩbənno jɩtannɔ wɔɔ ʊ kan wosocikarɩnsaambɔɔ wɔɔ kɩ. Brɔɔ n a ka zɛ ma. ");
INSERT INTO bib_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ŋ y'a kam kɩfɩɩrɔ ʊ, brɔɔ n yaa wʊ ma, ŋn'a zɛ madɩr m, ŋn'a wɔ gɔdarkʊra ma, b'a dɔmɩm kaakʊ hinni ʊ, Woso y'a mɩm bɔŋ ʊ gəəno bire ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedee nyɩnɔ da a zɔ Yeezuu ma kan a nyɩnɔ wɔɔ kɩ, an kukurə zɛ a taa, k'a hɔ yɛ han. ");
INSERT INTO bib_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeezuu n a lar, a ʊ: «Bɔ ɩ lɛ n taa?» A n a nyɩ bɔ ʊ, a ʊ: «Lɛ ka kʊ mɔɔ nyɩnɔ hɩɩyɔɔ nɔɔm n bɩ nyɩnta ɩbɩɩ cirbəə bɩ nɔ ʊ. Deem ɩ bɩsɩ, deem ɩ jɩsa.» ");
INSERT INTO bib_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Awɔɔ n hɔ k'a n'a yɛm bɩ dɔ y. Awɔɔ y'a dam ma, a fɩryɩrɛ kʊ mɔɔ n n'a yɩm bɩ yɩ ra?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Wɔɔ ʊ da ma.» ");
INSERT INTO bib_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Fɩryɩrɛ kʊ mɔɔ n n'a yɩm bɩ, awɔɔ y'a yɩrɛ. Bɩ, k'a gɔɔta mɔɔ jɩsa kan mɔɔ bɩsɩ bɩ kɩ nyɩntarɛ nɩ, mɔɔ n m da ma, m zaa ka y, bala, mɔɔ n m so ŋ ʊ y. N zɛm bɩ ŋ ka gʊɔɔ kʊ mɔɔ Zɩ bɩncɛrɔ wɔɔ banka ŋ minto rɔ wɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Karɩndanyɩnɔ buro kʊ ŋ gɔɔta rɔ wɔɔ kʊ ŋ naa ma bɩ, ŋ nɔ ma ʊ kan danyɩnɔ hɩɩyɔɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yeezuu n ŋ bir, an a hɩ ŋ nɩ, a ʊ: «Awɔɔ dɔ, a ʊ: gʊɔɔ k'awɔɔ nɩ dɩgarɛ ŋ ma kɩfɩɩrɔ wɔɔ, ŋ cinno ɩ paŋŋa barɛ ŋ ma, paŋŋazannɔ n n'a hɔɔnhɔ bam gʊɔɔ wɔɔ ma sɔ. ");
INSERT INTO bib_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","B'a n a ga m, an yɩ ncɩnaaʊ awɔɔ bire ʊ y. Bɩ, kʊ gʊaa lɛ taa k'a yɩ jɩtaarɛ awɔɔ bire ʊ, k'an a ba awɔɔ zibəənyɩ. ");
INSERT INTO bib_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bɩ, kʊ gʊaa lɛ taa k'a yɩ lɛɛkarɛzaa awɔɔ bire ʊ, k'an a ba awɔɔ lɔ. ");
INSERT INTO bib_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bala, Gʊaanyɩ bɩ n bʊr kʊ gʊɔɔ n'a hɔɔnhɔ ba y, bʊr a ʊ k'a b'a ba gʊɔɔ zibəənyɩ, k'a ga, kʊ gʊɔɔ gʊta n bʊmbɔrɛ yɩ.» ");
INSERT INTO bib_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Bɔ kʊ ŋ y'a ʊ Zeriko ʊ bɩ, gʊaa cir gʊta zu Yeezuu jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bʊʊrɔ nyɩnta hɩɩya zaa bɩ lezi. Kʊ ŋ y'a ma, ŋ ʊ: Yeezuu n nɩ cenim bɩ, ŋn'a sɩŋŋɩda ba ŋn'ɩ zee dam, ŋ ʊ. «Karɩnsaamba, *Davɩd Nyɩ, wɔɔ cicir zɛ!» ");
INSERT INTO bib_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gʊɔɔ wɔɔ nɩ bʊgʊr barɛ ŋ ma, ŋ ʊ, ŋn'a tʊr ka, bɩ ŋ y'a banka ŋn'a da ra: «Karɩnsaamba, Davɩd Nyɩ, wɔɔ cicir zɛ!» ");
INSERT INTO bib_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeezuu n jɩm, an ŋ bir, an ŋ lar, a ʊ: «Awɔɔ lɛ n taa kʊ m bɔ ba awɔɔ minto?» ");
INSERT INTO bib_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Karɩnsaamba, a ka kʊ wɔɔ n lɛɛ yɩ.» ");
INSERT INTO bib_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeezuu n ŋ cicir zɛ, an a wɔ da ŋ mɩnyaarɔ wɔɔ ma. Lɛɛm bɩ, gʊɔɔ hɩɩyɔɔ wɔɔ ɩ lɛɛ yɩrɛ, ŋn'ɩ zum Yeezuu ʊ. ");
INSERT INTO bib_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kʊ ŋ y'a zɔ Zerizalɛm ma, ŋn'a zɔ Bɛtfazee jɩr ʊ Oliviyee ci mim ʊ bɩ, Yeezuu a karɩndanyɩnɔ nyɔɔ hɩɩya. ");
INSERT INTO bib_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","A n a hɩ ŋ nɩ, a ʊ: «K'a ta kʊ k'a n'awɔɔ lɛɛ naa ʊ. Awɔɔ brada yɩrɛ, n n a kʊsɩ kan a nyɩnnɩ kɩ, k'a hʊr a bʊr ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kʊ gʊaa awɔɔ lar a hʊrlɛ zaa ma, k'a hɩ m a ʊ: Zuuba lɛ n taa. B'a yɩ ŋ tore ŋnɩ bʊr.» ");
INSERT INTO bib_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ba mim naa do ʊ kʊ wosolɛsinnɩsorazaa bɩ hɔ k'a hɩ naa n kʊ yɩ. A ʊ: ");
INSERT INTO bib_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","K'a hɩ *Siyɔn zannɔ m, a ʊ: K'a dɩga a cir k'a nɩ zɛrɛ a zi mɩŋŋazerle m, an da bra ʊ, brapoo m, brada nyɩnnɩ m. ");
INSERT INTO bib_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Karɩndanyɩnɔ wɔɔ n ta, ŋnɩ hɔ kʊ Yeezuu a hɩ ŋ nɩ bɩ ba. ");
INSERT INTO bib_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ŋ n bʊr brada bɩ m kan a nyɩnnɩ bɩ kɩ, ŋn'a huuro ka ŋ la, Yeezuu n da ʊ. ");
INSERT INTO bib_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Gʊɔɔ gʊta n a huuro ka zaa bɩ ra, gɔsɩnnɔ n gɔ lɛɛ yɩnyar ŋn'a ka zaa bɩ ra sɔ. ");
INSERT INTO bib_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Gʊɔɔ kʊ ŋ nɩ Yeezuu lɛɛ kan gʊɔɔ kʊ ŋ n'a jɛ ʊ rɔ wɔɔ kɩ ɩ zee darɛ, ŋ ʊ: «*Hozaana *Davɩd Nyɩ! Gʊaa k'a nɩ zɛm Zuuba tɔ ma bɩ n barka yɩ! Woso n lɛbɔʊrɛ yɩ arzana ʊ!» ");
INSERT INTO bib_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yeezuu k'a gasʊ Zerizalɛm ʊ bɩ, kʊ bɩ gʊɔɔ wɔɔ haay ŋn'ɩ bɩrlɛ a mim ma, ŋn'ɩ laaka dam, ŋ ʊ: «Gʊaa naa do nka nɩ?» ");
INSERT INTO bib_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Zamaa bɩ n'a nyɩ bɔŋ ʊ, ŋ ʊ: «Wosolɛsinnɩsorazaa Yeezuu m, a to a ʊ Nazarɛtɩ ʊ, Galilee kʊ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeezuu n gasʊ Wosocɛ ʊ b'ʊ, an nɩ lam gʊɔɔ kʊ ŋ nɩ hɔ hɛɛnm, ŋn'ɩ hɔ sim nɔ wɔɔ ra. A busoolʊrlɛzannɔ taabɩrlɔ hɩnhɩsɩga kan cirpʊnnɔ hɛɛnno nyɩntaragɔrɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A n a hɩ ŋ nɩ, a ʊ: «N n a gʊrsɩra ba Wosoci ʊ, n ʊ: ‹N mɔɔ cɛ bɩ birm yaadarɛcɛ› ra? Awɔɔ n bɔkarɛ a sa, a ba konno nyaakʊndajɩ!» ");
INSERT INTO bib_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bʊʊrɔ kan kusiməro kɩ n a zɔ Yeezuu ma Wosocɛ ʊ b'ʊ an ŋ waa. ");
INSERT INTO bib_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Wosocɛmannɩbənno jɩtannɔ kan wosocikarɩnsaambɔɔ wɔɔ kɩ heer n yɩ nyɩnta kan Yeezuu kɩ y, kʊ ŋ y'a yɩ an nɩ zi gʊta barɛ, kan nyɩnɔ kʊ ŋ nɩ zee dam Wosocɛ ʊ b'ʊ, ŋ ʊ: «Hozaana, Davɩd Nyɩ!» ");
INSERT INTO bib_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ŋ n a hɩ Yeezuu m, ŋ ʊ: «Ɩbɩɩ ɩ hɔ kʊ ŋ n'a hɩm bɩ mam na?» Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Ɩɩn…, awɔɔ n a karɩnda ba fɩɩga Wosoci b'ʊ, n ʊ: ‹Ɩbɩɩ ka nyɩnɔ kan banfinnirɔ kɩ n n'a lɛ bɔrɛ ɩbɩɩ ʊ› ra?» ");
INSERT INTO bib_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A m bɩ, Yeezuu n ŋ to b'ʊ, an a hʊr an bɔ kʊnɔ ʊ b'ʊ, an ta Betanii ʊ dɔ n mɛ m b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yeezuu k'a wusigə dɔgta mɩŋŋa m, an nɩ tam kʊnɔ ʊ b'ʊ bɩ, nɔ a nyasʊ. ");
INSERT INTO bib_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A n sɔɔn yɩ zaa bɩ lezi, an a zɔ ma b'a n hɔsɩ yɩ ma k'a lɛɛ bɛɛ bala y. A m bɩ, an a hɩ sɔɔn bɩ m, a ʊ: «Ɩbɩɩ b'ɩ yarɛ ɩ nyɩ da dɔ y!» Lɛɛm bɩ, sɔɔn bɩ ga. ");
INSERT INTO bib_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Karɩndanyɩnɔ wɔɔ kʊ ŋ naa yɩ bɩ, ŋ zɛ kədə, ŋnɩ laaka da Yeezuu han, ŋ ʊ: «A a ba lɔ sɔɔn bɩ n ga lɛɛm ncɩnaaʊ?» ");
INSERT INTO bib_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m: k'awɔɔ sɩra ka, bɩ bɩsɩkarɛ b'awɔɔ heer ʊ, awɔɔ mɔɔ zi kʊ mɔɔ ba sɔɔn naa do m bɩ bam. B'awɔɔ a da ma sɔ, a hɩ ci naa do m, a ʊ, ɩ bɔɔta naa ʊ, ɩ ɩ da higʊta ʊ. A bam maam. ");
INSERT INTO bib_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","K'awɔɔ sɩra ka, hɔ haay k'awɔɔ n n'a yɛm yaadarɛ nɔ ʊ haay bɩ, Woso yɩ ŋ karɛ awɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeezuu k'a gasʊ Wosocɛ ʊ b'ʊ bɩ, a a sɩŋŋɩda ba, an nɩ hɔ dɩndam. Wosocɛmannɩbənno jɩtannɔ kan gʊɔɔgusinno kɩ a zɔ Yeezuu ma, ŋn'a lar, ŋ ʊ: «Lɛ kara ɩbɩɩ n ta m k'ɩ naa ba? Nka ɩ lɛ bɩ do ka ɩ b'ʊ?» ");
INSERT INTO bib_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Kʊ m awɔɔ lar mim deem ma, deem bala, k'awɔɔ nyɩ bɔ ʊ, kʊ m bɔkarɛ, m lɛ kʊ mɔɔ n ta m bɩ jɩ hɩ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Batɛm kʊ Zaan n n'a kam bɩ, a to a ʊ Woso zi gɛɛ, gʊɔɔ zi?» Ŋ nɩ bɩsɩ kam kan kʊ kɩ, ŋ ʊ: «Kʊ wɔɔ ʊ a to a ʊ Woso zi, a y'a hɩrɛ, a ʊ: Bɔ minto m, wɔɔ n sɩra ka ʊ? ");
INSERT INTO bib_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bɩ kʊ wɔɔ ʊ gʊɔɔ zi, wɔɔ ɩ nyi bam zamaa bɩ kʊ ŋ Zaan dɔ wosolɛsinnɩsorazaa paan… bɩ, ŋ bɩ yɛm kan ʊ kɩ y.» ");
INSERT INTO bib_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","A m naa, ŋn'a nyɩ bɔ Yeezuu nʊ, ŋ ʊ: «Wɔɔ n a dɔ y.» Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mɔɔ bɩ lɛ kʊ mɔɔ n ta m, m nɩ naa bam bɩ jɩ hɩrɛ awɔɔ m sɔ y.» ");
INSERT INTO bib_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«Awɔɔ y'a hɔɔn dam mim naa do ma lɔ? Gʊaa ɩ nyɩnta nyɩnɔ m hɩɩya. A n a hɩ lɛɛkarɛzaa bɩ m, a ʊ: ‹M nyɩnnɩ, ta her ɩ yaa zi ba mɔɔ *dɩvɛnsɩra ʊ.› ");
INSERT INTO bib_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nyɩ bɩ n a nyɩ bɔ ʊ, a ʊ: ‹Mɔɔ bɩ tarɛ y.› Maasɩrɛ k'a ba bɩ, a a hɔɔndarɛ lʊr an ta hɔsɩra b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Gʊaa bɩ n a ya, an a hɩ nyɩ vanta bɩ m maam sɔ. Nyɩ bɩ do ʊ: ‹Ɩɩn…, baaba,› b'a n ta y. ");
INSERT INTO bib_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nyɩnɔ hɩɩyɔɔ nɔɔn duro bire ʊ bɩ, nka y'a zɩ bɩ hɔɔnhɔ ba?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Lɛɛkarɛzaa bɩ m». Yeezuu n a hɩ ŋ nɩ, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m, yawʊrsinno kan lannɔ kʊ ŋ n'a mɩŋŋa hɛɛnm nɔ kɩ lɛɛkarɛ awɔɔ m Woso cirbəə bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bala, Zaan-Batiisi bʊr awɔɔ zi, an zaa mɩŋŋa hɩnka awɔɔ m, b'awɔɔ n a mim si y. Bɩ, yawʊrsinno kan lannɔ kʊ ŋ n'a mɩŋŋa hɛɛnm nɔ kɩ a mim si. Awɔɔ naa yɩ, b'awɔɔ gɔɔta awɔɔ n a bɔ a taam k'a mim si y.» ");
INSERT INTO bib_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«K'a tʊr ka hɔbɔkʊrɛnoom vanta ma: Gʊaa ɩ nyɩnta, an dɩvɛn gɔ sɔɔn, an lambaar da ma, an yaa hɔn, k'a bɩr dɩvɛn bɩ hi bɔŋ ʊ, an bɛŋŋʊ dɔ sɔ k'a tɩr dɔ hɔsɩra bɩ ma. A n a sa, an a da gʊɔɔ wɔ ʊ, kʊ ŋ n'a zi ba, k'a b'a nyɔɔdʊ bɩ jir. A n a hʊr, an ta kʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Dɩvɛn mɔsa k'a ku bɩ, an a zibəənyɩnɔ nyɔɔ hɔsɩra bɩ zibənno wɔɔ zi, kʊ ŋ n'aa a hɔ si, ŋnɩ b'a ka a ʊ. ");
INSERT INTO bib_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Zibəənyɩnɔ wɔɔ n ŋ nyasʊ, ŋnɩ deem dundu, ŋnɩ deem zɛ gər, ŋnɩ deem bɩmba jaarɔ m, ŋn'a zɛ, an ga. ");
INSERT INTO bib_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hɔsɩrazaa bɩ n a ya, an zibəənyɩnɔ nyɔɔ gʊta an lɛ da biisi bɩ m. Bɩ, zibənno wɔɔ a ya ŋnɩ hɔ kʊ ŋ y'a ba lɛɛkarɛzannɔ wɔɔ m bɩ ba nawɔnnɔ m sɔ. ");
INSERT INTO bib_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","A nyarɛ ma bɩ, a nyɩyar a nyɔɔ, an n'a hɔɔn darɛ, a ʊ, kʊ mɔɔ nyɩ m naa, ŋ y'a daŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bɩ, zibənno wɔɔ kʊ ŋ y'a to ŋnɩ nyɩ bɩ yɩ bɩ, ŋn'a dɩndam kan kʊ kɩ, ŋ ʊ: ‹Naa n nɩ zɛm b'a so a zɩ arzaka b'ʊ. K'a bʊr, k'ʊ a zɛ, k'ʊ ʊ so arzaka b'ʊ!› ");
INSERT INTO bib_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ŋ n a nyasʊ, ŋnɩ bɔ m hɔsɩra b'ʊ, ŋn'a zɛ gər.» ");
INSERT INTO bib_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yeezuu n laaka da ŋ han, a ʊ: «Kʊ dɩvɛnsɩrazaa bɩ bʊr, bɔ an n'a bam zibənno wɔɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «A gʊɔɔ bʊnyaarɔ nɔɔn duro zɩnzɛm, a bɩ ŋ cicir zɛrɛ y, an hɔsɩra bɩ ka gʊɔɔ vantɔɔ ʊ ŋn'a zi ba, ŋn'a hɔ ka ʊ a dɔmɩm ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Awɔɔ n hɔ kʊ Wosoci b'a hɩ bɩ karɩnda ba ra? A a hɩ, a ʊ: Jaa kʊ cɛdonno wɔɔ a zo bɩ y'a ba cɛ bɩ jɩr jaa paŋŋazaa. Hɔ kʊ Zuuba a ba bɩ n naa do, wɔɔ nɩ dɩgam ma hɔ mɩŋŋa gʊta. ");
INSERT INTO bib_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Bɩ y'a ka, mɔɔ n'a hɩrɛ awɔɔ m, mɔɔ ʊ, n Woso cirbəə bɩ yɔrɛ awɔɔ m, n n a ka do vanta ʊ an cirbəə bɩ zibəə k'a a ga m bɩ ba.  ");
INSERT INTO bib_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kʊ gʊaa a do jaa naa do ra, a hɩsɩga dam, bɩ kʊ jaa b'a da gʊaa ra a gʊaa bɩ do hɔɔnsɩrɛ.» ");
INSERT INTO bib_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wosocɛmannɩbənno jɩtannɔ kan farizɛɛnrɔ wɔɔ kɩ kʊ ŋ Yeezuu hɔbɔkʊrɛnoonno nɔɔn duro ma bɩ, ŋ y'a dɔ ŋ ʊ, a hɩ a nawʊrɛ a ma. ");
INSERT INTO bib_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ŋ n'a kam ma k'a nyasʊ, bɩ, ŋ yɩ nyi bam zamaa bɩ m, bala, zamaa b'ɩ dɩgam Yeezuu ma wosolɛsinnɩsorazaa. ");
INSERT INTO bib_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeezuu a ya, an hɔbɔkʊrɛnoom da ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Woso cirbəə bɔ kʊ rɛ kan cir k'a a nyɩnnɩ lʊsarɛ cibsa ba kɩ. ");
INSERT INTO bib_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A n a zibəənyɩnɔ nyɔɔ kʊ ŋ n'aa gʊɔɔ k'a hɩ ŋ nɩ kʊ ŋ nɩ bɩ cibsa bɩ rɔ wɔɔ bir, ŋnɩ bɔkarɛ ŋ ʊ, a bɩ zɛrɛ y. ");
INSERT INTO bib_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A n a ya, an zibəənyɩnɔ vantɔɔ nyɔɔ an a hɩ ŋ nɩ, a ʊ: ‹K'a yaa hɩ gʊɔɔ kʊ mɔɔ ŋ bir cibsa bɩ ma rɔ wɔɔ m, a ʊ: mɔɔ cibsa bɩ banka m a nya, mɔɔ m dono zɩnzɛ kan m hɔbɩsɩrɔ gʊtɔɔ kɩ, hɔ haay banka, k'a bʊr cibsa bɩ ma kɛɛrɛ.› ");
INSERT INTO bib_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bɩ, gʊɔɔ wɔɔ n dɩga cibsa birle bɩ ma hɔsɩ y, ŋn'a hʊr ŋnɩ ta a zibəəjɩrɔ ʊ, naa n ta hɔsɩra ʊ, naa n ta daasɩ ʊ mɔdrɔ hɛɛjɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ŋ n gɔɔta rɔ wɔɔ n zibəənyɩnɔ wɔɔ nyasʊ, ŋnɩ nyannɩ da ŋ ma, ŋnɩ bɔkarɛ, ŋnɩ ŋ zɩnzɛ. ");
INSERT INTO bib_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Cir bɩ nɔ n ma ʊ, an sʊrdaarɔ nyɔɔ ŋn'aa gərzenno nɔɔn duro zɩnzɛ, ŋnɩ sɛ da ŋ kʊ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","A m naa, an a hɩ a zibəənyɩnɔ m, a ʊ: ‹Cibsa bɩ hɔbɩrɛ bɩ bankarɛ nya, bɩ gʊɔɔ kʊ mɔɔ hɩ ŋ nɩ rɔ wɔɔ n a ga kʊ ʊ ba y. ");
INSERT INTO bib_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","K'a ta zaazɛkʊrarɔ wɔɔ ra, kʊ nka awɔɔ yɩ, k'a hɩ m k'an bʊr cibsa bɩ ma.› ");
INSERT INTO bib_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","A zibəənyɩnɔ wɔɔ n a hʊr, ŋnɩ zaarɔ sa ŋnɩ gʊɔɔ kʊ ŋ yɩ ŋ yɩ rɔ wɔɔ so kʊ ma, gʊɔɔ mɩŋŋɔɔ, kan gʊɔɔ bʊnyaarɔ kɩ. Gʊɔɔ n cɛ kʊ n nɩ cibsa bɩ baŋ ʊ bɩ han. ");
INSERT INTO bib_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Cir bɩ gasʊ k'a dɩga gʊɔɔ kʊ ŋ bʊr cibsa bɩ ma rɔ wɔɔ ma, an a to, an gʊaa yɩ, gʊaa bɩ do n harcɩntarɛ cibsa huu du a ma y. ");
INSERT INTO bib_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A n a hɩ m, a ʊ: ‹Ɩbɩɩ ba lɔ ɩ gasʊ naa ʊ, b'ɩbɩɩ ba harcɩntarɛ cibsa huu nɩ?› Bɩ gʊaa bɩ n a nyɩ bɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","A m bɩ, cir bɩ n a hɩ zibəənyɩnɔ wɔɔ m, a ʊ: ‹K'a gannɔ kan a wɔrɔ kɩ kʊsɩ a zo garga ra, monsigə ʊ. Lɛɛ bɩ do an nɩ nyi kaŋ ʊ, an a sɔ sʊ.› » ");
INSERT INTO bib_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yeezuu n a ya, an a hɩ, a ʊ: «N gʊɔɔ bir gʊta, bɩ, n nɩ ŋ nyʊkɔ ʊ rɔ wɔɔ poore.» ");
INSERT INTO bib_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Naa jɛ ʊ bɩ, farizɛɛnrɔ ta, ŋn'aa a so kʊ ma, k'a a ka zaa k'a nɩ Yeezuu nyasʊm ma a meerbaa nɔ ʊ bɩ dɔ. ");
INSERT INTO bib_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ŋ n a karɩndanyɩnɔ kan Hɩrɔɔdɩ jɛzannɔ kɩ nyɔɔ Yeezuu zi, kʊ ŋ n'aa hɩ m, ŋ ʊ: «Karɩnsaamba, wɔɔ dɔ wɔɔ ʊ sɩra ɩbɩɩ n'a hɩm, Woso zaa ɩbɩɩ n'a dɩndam sɩra bɩncɛ ʊ, ɩbɩɩ bɩr nyi bam gʊɔɔ nɩ y, b'ɩbɩɩ bɩr gʊɔɔ nyʊkɔŋ ʊ sɔ y. ");
INSERT INTO bib_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bɩ minto bɩ, ɩ hɔɔnhɔ hɩ wɔɔ m, wɔɔ lɛ bɩ zaa ka k'ʊ Rɔm cir yawʊr ka ʊ gɛɛ, ʊ b'a ka ʊ gɛ?» ");
INSERT INTO bib_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bɩ, kʊ Yeezuu ŋ zambʊ bɩ dɔ bɩ, a a hɩ ŋ nɩ, a ʊ: «Zambʊzannɔ! Bɔ m, awɔɔ nɩ mɔɔ makra barɛ? ");
INSERT INTO bib_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","K'a busoo kʊ n nɩ Rɔm cir yawʊr kam nɩ bɩ hɩnka m m.» Ŋ n deniyee deem hɩnka m. ");
INSERT INTO bib_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yeezuu n ŋ lar, a ʊ: «Gʊaa mim kʊ n y'a da ʊ naa kan gʊrsɩra naa do kɩ, nka hɔɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ŋ ʊ: «Rɔm cir hɔɔ m.» A n a hɩ ŋ nɩ, a ʊ: «K'a maam k'a hɔ kʊ Rɔm cir hɔ m bɩ ka ʊ, k'a hɔ kʊ Woso hɔ m bɩ ka ʊ sɔ.» ");
INSERT INTO bib_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Meerbaa naa do a ka ŋ n zɛ kədə, ŋn'a hʊr, ŋnɩ Yeezuu to. ");
INSERT INTO bib_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hinni bɩ do ʊ bɩ, sadisɛɛnrɔ gɔsɩnnɔ bʊr Yeezuu zi. Bala, sadisɛɛnrɔ wɔɔ ʊ gəəno mɩmbɔʊrɛ b'a ʊ y. Ŋ n laaka da Yeezuu han, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Karɩnsaamba, Moyiisi a gʊrsɩra ba an a ka wɔɔ ʊ, a ʊ, kʊ gʊaa cɛmba ta ʊ, an ga an a lʊ to, b'a nyɩ ba ʊ y, k'a dam n lʊ bɩ si, k'an nyɩ yɩ kan kɩ a cɛmba bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","A n bɔkarɛ, danyɩnɔ ɩ nyɩnta saanhɩna wɔɔ bire ʊ, lɛɛkarɛzaa bɩ n lʊ sa an ga, b'a n nyɩ yɩ kan lʊ bɩ kɩ y. ");
INSERT INTO bib_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A hɩɩya hɔ bɩ n lʊ bɩ si, an ga, an lʊ bɩ to b'a n nyɩ yɩ kan kɩ y. A kaakʊ hɔ bɩ maam sɔ, saanhɩnarɔ wɔɔ haay ŋ gɩnga bɩ ŋ n nyɩ yɩ kan lʊ bɩ kɩ y. ");
INSERT INTO bib_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ŋ haay kur bɩ, lʊ bɩ n ga sɔ. ");
INSERT INTO bib_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Gəəno mɩmbɔʊrɛ dɔmɩm ʊ, kʊ ŋ y'a mɩm bɔ ʊ, nka y'a so lʊ b'ʊ ŋ bireyaa ʊ? Bala, gʊɔɔ saanhɩnarɔ wɔɔ haay lʊ bɩ si.» ");
INSERT INTO bib_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «K'awɔɔ n gʊrsɩra mɩŋŋɔɔ wɔɔ dɔ kan Woso paŋŋa kɩ bɩ y'a ka awɔɔ n'a nyʊnnyɔɔm. ");
INSERT INTO bib_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bala, gəəno mɩmbɔʊrɛ dɔmɩm ʊ, yar bɩr lʊ sarɛ y, lʊ bɩr yar sarɛ y, bɔ ŋ y'a ʊ kʊ ʊ kan malɛɛkarɔ kʊ ŋ nɩ brama rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Bɩ, kʊ gəəno mɩmbɔʊrɛ mim nɩ, awɔɔ n hɔ kʊ Woso a hɩ awɔɔ m bɩ karɩnda ba ra? A a hɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Abraham kan Izakkɩ kɩ, Zakɔɔb kɩ Woso m mɔɔ m.› Gəəno Woso bɛɛ y, gʊɔɔ mɩsɩɩrɔ Woso m.» ");
INSERT INTO bib_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yeezuu hɔdɩndarɛ naa do cem zamaa bɩ hɔɔndarɛ han. ");
INSERT INTO bib_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farizɛɛnrɔ wɔɔ kʊ ŋ y'a ma, ŋ ʊ, Yeezuu a ka sadisɛɛnrɔ wɔɔ b'a dam ma ŋn'a ya ŋnɩ meer ba bɩ, ŋ y'a so kʊ ma. ");
INSERT INTO bib_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ŋ gʊaa deem kʊ wosocikarɩnsaamba gʊta m bɩ laaka da Yeezuu han, k'a makra ba. ");
INSERT INTO bib_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","A ʊ: «Karɩnsaamba, lɛrɔ wɔɔ haay bire ʊ, kara ɩ lɛ da?» ");
INSERT INTO bib_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeezuu n a nyɩ bɔ nʊ, a ʊ: « ‹K'ɩ Zuuba Woso ŋʊa kan ɩ heer kɩ haay, kan ɩ nyi kɩ haay, kan ɩ hɔɔndarɛ kɩ haay.› ");
INSERT INTO bib_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lɛ k'a lɛ da, a m lɛ gʊta bɩ m naa do. ");
INSERT INTO bib_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Lɛ hɩɩya hɔ k'a gʊtabaa lɛɛkarɛ hɔ bɩ ku bɩ m naa do: ‹K'ɩ mim ŋʊa amba ɩ mɩŋŋa m.› ");
INSERT INTO bib_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moyiisi lɛrɔ wɔɔ haay kan wosolɛsinnɩsorazannɔ wɔɔ meerbaarɔ kɩ haay məsi m lɛrɔ hɩɩyɔɔ nɔɔn duro m.» ");
INSERT INTO bib_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farizɛɛnrɔ wɔɔ kʊ ŋ y'a so kʊ ma bɩ, Yeezuu laaka da ŋ han, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Awɔɔ y'a hɔɔn dam Krista ma lʊnlɔ? Nka nyɩ nɩ?» Ŋ n a hɩ m, ŋ ʊ: «*Davɩd Nyɩ m.» ");
INSERT INTO bib_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yeezuu n a hɩ ŋ nɩ, a ʊ: «B'a yɩ lɔ, Sɛnt-Ɛspri n a ka Davɩd n a bir a Zuuba? Bala, Davɩd b'a hɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Zuuba Woso a hɩ mɔɔ zuuba m, a ʊ: nyɩnta mɔɔ bɩsɩ ʊ, kʊ m tolle ba m a ka, k'ɩ jɩnnɔ wɔɔ n nyɩnta ɩ gam taa. ");
INSERT INTO bib_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","K'a ɩ yɩrɛ ɩ ʊ Davɩd y'a birm a Zuuba, yɩ an nawʊm lɔ kɛɛrɛ kʊ Krista n yɩ *Davɩd Nyɩ?» ");
INSERT INTO bib_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Gɔsɩ n a da ma, an a nyɩ bɔ nʊ y. Hinni bɩ do tɛkka ma, gʊaa ba ʊ dɔ, a heer n kookoo k'a lar mim ma y. ");
INSERT INTO bib_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yeezuu a sɩŋŋɩda ba, an nɩ meer bam kan zamaa bɩ kɩ, a karɩndanyɩnɔ wɔɔ kɩ, an n'a hɩrɛ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Wosocikarɩnsaambɔɔ wɔɔ kan farizɛɛnrɔ wɔɔ kɩ, Moyiisi lɛrɔ wɔɔ ŋn'a hɩnkam gʊɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bɩ minto bɩ, awɔɔ a ga m, a sɩra ka ŋ ʊ, a hɔ kʊ ŋ n'a hɩrɛ awɔɔ m haay bɩ ba, b'a bɩ zu ŋ zibəə ʊ y. Bala, ŋ bɩr hɔ kʊ ŋ n'a dɩndam gʊɔɔ m bɩ barɛ y. ");
INSERT INTO bib_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ŋ tɩr mɔr gorezaa kʊsɩ ŋn'a ka gʊaa mee, bɩ ŋ bɩr a wɔ dam ma k'a a da a zaa han, an a busu y. ");
INSERT INTO bib_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ziro kʊ ŋ nɩ ŋ bam haay rɔ wɔɔ ba ŋ nawʊm kʊ gʊɔɔ m dɩga a ma, bɩ y'a ka, Wosoci lemim kʊ ŋ tɩr a kʊsɩ a tusə ma gɛɛ a za ma bɩ ba ŋ tɩr a ʊ jintə, ŋ tɩr pɛɛra lensəzannɔ dɔ a huuro rɛ, k'an bɩr yɩm. ");
INSERT INTO bib_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Lɛɛ mɩŋŋɔɔ ŋ tɩr a ka ma cibsarɔ bɩncɛ ʊ, sokʊma bɩncɛ ʊ, lɛɛ wɩsɩ ŋ tɩr a kam ma. ");
INSERT INTO bib_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","A ŋʊa ŋ tɩr a ʊ kʊ ŋ nɩ bɩr yaa darɛ a m mɩŋŋa gʊɔɔ gaa ʊ, kʊ gʊɔɔ n bɩr a birm karɩnsaamba. ");
INSERT INTO bib_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","B'awɔɔ, a bɩ yɛ kʊ n n'a bir karɩnsaamba y, bala, danyɩnɔ n'awɔɔ m haay, awɔɔ karɩnsaamba bɩ deem. ");
INSERT INTO bib_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A bɩ gɔsɩ bir tara burə ʊ a ʊ, a Zɩ y, bala, awɔɔ Zɩ bɩ deem, an nɩ arzana ʊ bɩ. ");
INSERT INTO bib_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A b'a ka ma kʊ n n'a bir jɩtaarɛ y. Bala, awɔɔ jɩtaarɛ bɩ deem, Krista m. ");
INSERT INTO bib_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Gʊaa k'a lɛ da awɔɔ bire ʊ bɩ, k'an yɩ awɔɔ zibəənyɩ. ");
INSERT INTO bib_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kʊ gʊaa a mɩŋŋa busu, Woso y'a zerm. Kʊ gʊaa a mɩŋŋa zer, Woso y'a busum.» ");
INSERT INTO bib_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Kʊsɩ ɩ kan awɔɔ kɩ, awɔɔ wosocikarɩnsaambɔɔ kan farizɛɛnrɔ zambʊzannɔ kɩ, awɔɔ ɩ Woso cirbəə bɩ lɛ tam kʊ gʊɔɔ bɩ gasʊ y. Awɔɔ mɩŋŋɔɔ bɩr gasʊrɛ y, bɩ gʊɔɔ kʊ ŋ lɛ n taa k'a gasʊ rɔ wɔɔ, awɔɔ bɩr brɔɔ tore ŋn'ɩ gasʊrɛ y.  ");
INSERT INTO bib_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kʊsɩ ɩ kan awɔɔ kɩ awɔɔ wosocikarɩnsaambɔɔ kan farizɛɛnrɔ zambʊzannɔ kɩ, awɔɔ ɩ zonno hɔ kʊ ŋ nɩ ta m bɩ yɔrɛ ŋ nɩ, a a ya, a gaa, an nɩ yaa jintoo dam kʊ n n'a hɩ a ma gʊɔɔ mɩŋŋɔɔ. Naa minto m, awɔɔ hʊnhʊrlɛ n nɩ yɩm maam-maam. ");
INSERT INTO bib_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kʊsɩ ɩ kan awɔɔ kɩ, awɔɔ, wosocikarɩnsaambɔɔ kan farizɛɛnrɔ zambʊzannɔ kɩ, awɔɔ ɩ tam kʊrɔ ʊ tara burə ʊ kan kɔɔlʊʊ nɔ ʊ kɩ an n'a kam gʊaa deem taan… ma k'an zu awɔɔ lɛrɔ wɔɔ ʊ, bɩ k'awɔɔ ku b'awɔɔ ka an yɩ sɛhar gʊaa gallɛm hɩɩya an lɛ da awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kʊsɩ ɩ kan awɔɔ kɩ, awɔɔ k'an bʊʊrɔ, an nɩ zaa hɩnkam gʊɔɔ m, awɔɔ y'a hɩrɛ, a ʊ: ‹Kʊ gʊaa ler bɔ Wosocɛ bɩ tɔ ma hɔsɩ bɛɛ nɩ y, bɩ k'a ler bɔ Wosocɛ bɩ sarma bɩ tɔ ma pakra m k'an hɔ k'a hɩ bɩ ba.› ");
INSERT INTO bib_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hɔɔnwarzannɔ, bʊʊrɔ n'awɔɔ m! Kara ɩ lɛ da a mim nɩ? Sarma bɩ m gɛɛ, Wosocɛ k'a ka sarma bɩ nɩ yɩm Woso hɔ bɩ nɩ? ");
INSERT INTO bib_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Awɔɔ a ya, an n'a hɩrɛ, a ʊ: ‹Kʊ gʊaa ler bɔ mannɩduu ma hɔsɩ bɛɛ y, bɩ k'a ler bɔ mannɩhɔ k'a n'a burə ʊ bɩ ma, pakra m k'an hɔ k'a hɩ bɩ ba.› ");
INSERT INTO bib_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bʊʊrɔ n'awɔɔ m! Kara ɩ lɛ da? Mannɩhɔ bɩ n gɛɛ, mannɩduu k'a nɩ mannɩhɔ bɩ kam Woso ʊ bɩ nɩ? ");
INSERT INTO bib_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Gʊaa k'a nɩ ler bɔm mannɩduu bɩ ma bɩ, ler bɔ a nawʊm duu bɩ ma, kan hɔ niŋŋə haay k'a nɩ duu bɩ burə ʊ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Gʊaa k'a nɩ ler bɔm Wosocɛ bɩ ma bɩ, ler bɔ a nawʊm Wosocɛ bɩ ma, kan Woso k'a nɩ cɛ b'ʊ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Gʊaa k'a nɩ ler bɔm arzana ma, ler bɔ a nawʊm Woso duu bɩ ma kan Woso mɩŋŋa k'a nyɩnta ra bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kʊsɩ ɩ kan awɔɔ kɩ, wosocikarɩnsaambɔɔ kan farizɛɛnrɔ zambʊzannɔ kɩ, awɔɔ ɩ dʊlɛɛrɔ bu hɔ ganwʊrɛ bɔŋ ʊ an n'a kam Woso ʊ, a bɔkarɛ, a hɔ k'an mɩŋŋa Woso lɛrɔ wɔɔ nɔ ʊ bɩ to, amba: Tɩrgabaa, mɩŋŋabaa, kan sɩrabarɛ kɩ, nawɔnnɔ awɔɔ a ga m, a ŋ ba, a ŋ gɔɔtarɔ wɔɔ ba sɔ. ");
INSERT INTO bib_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Awɔɔ k'an bʊʊrɔ, an nɩ zaa hɩnkam bɩ, awɔɔ y'a hɔ mire sʊrm k'a mɛɛm bɔ ʊ, b'awɔɔ ɩ yoonde monɩm. ");
INSERT INTO bib_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kʊsɩ ɩ kan awɔɔ kɩ, wosocikarɩnsaambɔɔ kan farizɛɛnrɔ zambʊzannɔ kɩ, awɔɔ ɩ hɔmihɔ kan hɔbɩrɛ mɔr burə kɩ sʊrgɔm, k'a dintim gʊ ŋ ma. Bɩ, ŋ nɔ rɔ wɔɔ, awɔɔ koorbaa zibəə kan a hɔɔndarɛ bʊnyaarɔ kɩ yɩ ŋ han. ");
INSERT INTO bib_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farizɛn, bʊʊ n'ɩbɩɩ m, lɛɛ ka ɩ hɔmihɔ bɩ nɔ sʊrgɔ, a burə bɩ hu bɔm sɔ. ");
INSERT INTO bib_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kʊsɩ ɩ kan awɔɔ kɩ, wosocikarɩnsaambɔɔ kan farizɛɛnrɔ zambʊzannɔ kɩ, bɔ awɔɔ ʊ kʊ rɛ kan gəənoyaarɔ huro kɩ, ŋ burə gʊɛrɛ n ta ʊ, an bɔkarɛ, ŋ nɔ ʊ b'ʊ bɩ, yaarɔ kan hɔɔ vənno do haay kɩ yɩ ŋ han. ");
INSERT INTO bib_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Awɔɔ do m bɩ, gʊɔɔ ɩ dɩgarɛ a ma gʊɔɔ mɩŋŋɔɔ, an bɔkarɛ zambʊ kan bʊnyaabaa kɩ y'awɔɔ heer han.» ");
INSERT INTO bib_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Kʊsɩ ɩ kan awɔɔ kɩ, wosocikarɩnsaambɔɔ kan farizɛɛnrɔ zambʊzannɔ kɩ, gəənoyaarɔ awɔɔ nɩ ŋ bankam mɩŋŋa wosolɛsinnɩsorazannɔ minto, gʊɔɔ tɩrgɔɔ wɔɔ awɔɔ nɩ ŋ yaarɔ gʊɛrɛ dam ma. ");
INSERT INTO bib_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","A bɔkarɛ, an n'a hɩrɛ, a ʊ: ‹Kʊ wɔɔ ɩ nyɩnta ʊ yaabɔɔ dɔmɩm ʊ, wɔɔ b'ʊ zɛm kʊ ra kan ŋ kɩ, ʊ wosolɛsinnɩsorazannɔ wɔɔ zɩnzɛ y.› ");
INSERT INTO bib_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Naa minto bɩ, awɔɔ mɩŋŋɔɔ nɩ kasɛtɩ karɛ a ʊ, gʊɔɔ kʊ ŋ wosolɛsinnɩsorazannɔ wɔɔ zɩnzɛ rɔ wɔɔ nyɩnɔ n'awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","K'a maam, k'a a tʊntɔ ʊ, k'a hɔ k'awɔɔ yaabɔɔ a sɩŋŋɩda ba bɩ nyambʊr. ");
INSERT INTO bib_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mɩnnɔ, cɩrkarɔ do n'awɔɔ m! Awɔɔ y'a hɔɔn dam lɔ, k'a a da ma, a a si Woso k'awɔɔ dʊdɔ yar, an awɔɔ da sɛhar ʊ bɩ lɛɛ? ");
INSERT INTO bib_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Bɩ y'a ka, mɔɔ wosolɛsinnɩsorazannɔ, hɔɔnzannɔ kan wosocikarɩnsaambɔɔ kɩ nyɔɔrɛ awɔɔ zi. Awɔɔ nɔɔn zɩnzɛm, a gɔsɩnnɔ wɔ gɔdarkʊrarɔ ma, awɔɔ nɔɔn zɛm madɩɩrɔ m a sokʊmacɛrɔ ʊ, a fɩr ka ŋ ma kʊrɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Naa minto bɩ, awɔɔ hʊnhʊrlɛ yɩm gʊɔɔ tɩrgɔɔ k'awɔɔ ŋ zɩnzɛ rɔ wɔɔ minto, an a sɩŋŋɩda sa gʊaa tɩrga Abɛl zɛrɛ ma, an ta an aa Baraki nyɩ Zakarii k'awɔɔ zɛ Wosocɛ bɩ bɩncɛ paan… bɩ kan mannɩduu bɩ kɩ bire ʊ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, hʊnhʊrlɛ k'a a ga m gʊɔɔ zɩnzɛrɛ naa do minto bɩ, her zamaana naa do n nɩ hʊnhʊrlɛ bɩ do yɩm.» ");
INSERT INTO bib_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Zerizalɛm, Zerizalɛm, ɩbɩɩ k'ɩ nɩ wosolɛsinnɩsorazannɔ zɩnzɛm, ɩ nɩ gʊɔɔ kʊ Woso ŋ nyɔɔ ɩ ma rɔ wɔɔ bɩmbam jaarɔ m bɩ! Mɔɔ gallɛm karɔ m a ŋʊa kʊ m ɩ ɩ zamaa so kʊ ma m taa amba kʊrda tɩr a nyɩnɔ so kʊ ma a zarɔ taa bɩ m, b'awɔɔ n yɛ! ");
INSERT INTO bib_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bɩ kɛɛrɛ naa, ‹N y'a bɔrɛ awɔɔ cɛ b'ʊ.› ");
INSERT INTO bib_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sɩra mɔɔ n'a hɩrɛ awɔɔ m: an a sɩŋŋɩda sa naa ma, awɔɔ b'a yarɛ a mɔɔ yɩ y, k'awɔɔ m b'a hɩ, a ʊ: ‹Barka ɩ gʊaa k'a nɩ zɛm Zuuba tɔ ma bɩ mim ʊ!› » ");
INSERT INTO bib_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeezuu k'a bɔ Wosocɛ b'ʊ k'a a hʊr bɩ, a karɩndanyɩnɔ wɔɔ a zɔ ma ŋn'ɩ Wosocɛ bɩ dɔrɛ mim hɩm nɩ. ");
INSERT INTO bib_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A n a nyɩ bɔ ŋ nʊ, a ʊ: «Naa k'awɔɔ n'a yɩm haay naa, sɩra mɔɔ n'a hɩrɛ awɔɔ m: jaa deem bɩ gɔɔtarɛ a mim burə ʊ y. Ŋ haay zɛm bɩ wurgə.» ");
INSERT INTO bib_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yeezuu k'a nɩ nyɩntam Oliviyee ci mim ʊ bɩ, a karɩndanyɩnɔ a zɔ ma a minto, ŋn'a lar, ŋ ʊ: «A hɩ wɔɔ m, ba naa do nawʊm brɔ? Makra kara n n'ɩbɩɩ zɛrɛ hɩnkarɛ kan durnya nyarɛ kɩ?» ");
INSERT INTO bib_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «K'a dundo a zi kʊ gɔsɩ b'awɔɔ nyʊnnyɔɔ y. ");
INSERT INTO bib_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bala, gʊɔɔ zɛm gʊta, ŋnɩ meer ba mɔɔ tɔ m, ŋ ʊ: ‹Mɔɔ m Krista,› bɩ ŋ gʊɔɔ nyʊnnyɔɔm gʊta. ");
INSERT INTO bib_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Awɔɔ yarbarɛ mim mam, kan yarbarɛ k'a n'a dam ma an bɩ wuti bɩ mim kɩ, a bɩ dabɔʊ ba y. Bala, pakra m, kʊ naa haay n ba, bɩ durnya bɩ nyarɛ bɛɛ m cɩna y. ");
INSERT INTO bib_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Do deem gʊɔɔ wutire ŋnɩ yar ba kan do vanta kɩ, tara deem zannɔ wutire ŋnɩ yar ba kan tara vanta zannɔ kɩ, nɔ nyɩntam kʊrɔ ʊ, bɩncɛrɔ niŋŋoo nyiŋŋəm. ");
INSERT INTO bib_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Naa do haay bɩ, bɔ a ʊ kʊ rɛ kan lʊ nyɩ yɩrɛ fɩryɩrɛ sɩŋŋɩda kɩ. ");
INSERT INTO bib_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Bɩ, n y'awɔɔ gʊrm, ŋnɩ fɩr ka awɔɔ ma, ŋn'a zɩnzɛ. Doro haay sɔrɛ awɔɔ m mɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Dɔmɩnnɔ wɔɔ duro ʊ gʊɔɔ gʊta sɩrakarɛ tom, ŋnɩ ŋʊaar ba kʊ m, ŋnɩ sɔ kʊ m. ");
INSERT INTO bib_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ŋʊaarlɛsinnɩsorazannɔ zɛm gʊta ŋnɩ gʊɔɔ gʊta nyʊnnyɔɔ. ");
INSERT INTO bib_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mimbʊnyaa pasɩm gʊta, an a ka gʊaa cir gʊta ŋʊarɛ n nyɔɔ. ");
INSERT INTO bib_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bɩ, gʊaa k'a nyasʊ a sɩrakarɛ m kaŋŋɩda an ta an fɩryɩrɛ bɩ nyarɛ ku bɩ, bɩ zaa bʊmbɔrɛ yɩm. ");
INSERT INTO bib_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ŋ Woso lemim nyɩnta naa do pa dam durnya haay nɔ ʊ, k'an nyɩnta kasɛtɩ, doro minto. Naa jɛ, durnya nyarɛ n nɩ zɛŋ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«K'awɔɔ bɩ ‹Gʊaa kʊ hɔzaarbarɛzaa bʊnyaa m bɩ yɩ›, wosolɛsinnɩsorazaa Danɩyɛl n a hɩ ma bɩ, an nɩ nyɩntam lɛɛ mɩŋŋa kʊ Woso bɩncɛ m, b'a n a ga nɩ y, gʊaa k'a nɩ karɩnda bam bɩ, k'a n'a jɩ ma mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ncɩnaaʊ bɩ, gʊɔɔ kʊ ŋ nɩ Zidee ʊ bɩ, kʊ ŋ n'a si, ŋnɩ ta ciro ʊ. ");
INSERT INTO bib_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Gʊaa k'a n'a cɛ mim ʊ bɩ, a b'a ka zerle ma k'a gasʊ a cɛ ʊ a hɔsɩ sa y. ");
INSERT INTO bib_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gʊaa k'a n'a hɔsɩra ʊ sɔ bɩ, a bɩ doo k'a yaa a huu sa y. ");
INSERT INTO bib_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Dɔmɩnnɔ wɔɔ duro ʊ, a yɩm kʊsɩ lannɔ jɩsɩzannɔ wɔɔ ma, kan lannɔ kʊ ŋ nɩ nyɔ karɛ a nyɩnɔ ʊ rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","K'a yaa da Woso m k'awɔɔ sire bɩ bɩ nyɩnta la barɛ dɔmɩnnɔ ʊ gɛɛ, *sabaa hinni ʊ y. ");
INSERT INTO bib_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bala, a nyɩntam fɩryɩrɛ gʊta dɔmɩnnɔ an lɛ da fɩryɩrɛ haay ra, an a sa durnya sɩŋŋɩda ma an naa ma ku, naa lɔɔ n nyɩnta ʊ y, b'a bɩ nyɩntaŋ ʊ fɩɩga y. ");
INSERT INTO bib_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kʊ Woso bɛɛ dɔmɩnnɔ nɔɔn duro bɔrɛ, gɔsɩ bɩ larɛ y. Bɩ, a ŋ bɔrɛ a gʊɔɔ k'a ŋ nyʊkɔ ʊ rɔ wɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kʊ gʊaa a hɩ awɔɔ m, a ʊ: Krista ɩ naa ʊ, gɛɛ, a ɩ bra ʊ, a b'a si y. ");
INSERT INTO bib_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bala, kristarɔ ŋʊaarzannɔ kan ŋʊaarlɛsinnɩsorazannɔ kɩ nyɩntaŋ ʊ gʊta. Ŋ hoserlo bam kan makrarɔ kɩ, k'an yɩ ʊ, a a da ma, a gʊɔɔ kʊ Woso ŋ nyʊkɔ ʊ rɔ wɔɔ nyʊnnyɔɔ. ");
INSERT INTO bib_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","K'a tʊr ka mɩŋŋa, mɔɔ ser ka m a hɩ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kʊ n b'a hɩ awɔɔ m, n ʊ, k'a dɩga, a ɩ poo ʊ, a bɩ ta y, gɛɛ kʊ n y'a hɩ awɔɔ m, n ʊ, a a nyaakʊm da naa ʊ, a b'a si y. ");
INSERT INTO bib_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Amba brama tɩr nyakɩ bɔ dɔjɩr ʊ an ta meer ʊ bɩ, Gʊaanyɩ bɩ zɛm maam sɔ. ");
INSERT INTO bib_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lɛɛ kʊ hɔgər n ta ʊ bɩ, gɔbɩrgʊrɔ n n'a som kʊ ma ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Kʊ fɩr gʊta dɔmɩnnɔ wɔɔ bɩ cem, woso bɩ gum dɔ y, mom bɩ gum sɔ y, monyaarɔ surm, brama hɔɔpaŋŋazannɔ haay nyiŋŋəm. ");
INSERT INTO bib_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dɔmɩm bɩ do ʊ bɩ, Gʊaanyɩ bɩ makra y'a hɩnkam brama. ‹Do haay n nyi ka. Ŋ Gʊaanyɩ bɩ yɩrɛ an a to brama warkʊ mim ʊ› kan paŋŋa kɩ, lɛbɔʊrɛ gʊta nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","‹Ŋ hir gʊta bɩ hɛm, an a malɛɛkarɔ nyɔɔ durnya gʊrga siro wɔɔ ʊ, kʊ ŋ nɩ gʊɔɔ k'a ŋ nyʊkɔ ʊ rɔ wɔɔ so kʊ ma, an a sa durnya lɛ ma an ta a cɩntarɛ ma.› » ");
INSERT INTO bib_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«K'a makra sa sɔɔn ma: k'awɔɔ b'a yɩ, an lɛɛ daa da, a lɛɛ nɩ kure, awɔɔ dɔ a ʊ, siire a zɔ. ");
INSERT INTO bib_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","A maam sɔ, k'awɔɔ bɩ minno nɔɔn duro yɩ, k'a dɔ a ʊ Gʊaanyɩ bɩ zɛrɛ a zɔ, bɩ, yɩ an nawʊm maam sɔ. ");
INSERT INTO bib_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, zamaana naa do bɩ cenim, kʊ nawɔnnɔ haay bɛɛ ba y. ");
INSERT INTO bib_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Brama kan tara kɩ cenim, bɩ mɔɔ meerbaarɔ wɔɔ bɩ cenle y.» ");
INSERT INTO bib_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«A n ta ʊ bɩ, gɔsɩ n dɔmɩm bɩ do kan a wakatɩ kɩ dɔ y. Baa, malɛɛkarɔ kʊ ŋ nɩ brama rɔ wɔɔ n a dɔ y, Nyɩ bɩ n a dɔ sɔ y. Zɩ bɩ y'a dɔ a deem. ");
INSERT INTO bib_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hɔ k'a ba Nowee dɔmɩm ʊ bɩ nyɩntaŋ ʊ sɔ Gʊaanyɩ bɩ zɛrɛ dɔmɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kʊ sɩra nɩ, an lɛɛ ka kʊ hi m durnya bɩ Nowee dɔmɩm b'ʊ bɩ, gʊɔɔ wɔɔ ɩ hɔbɩrɛ bɩm, ŋn'ɩ hɔ mim, ŋn'ɩ lʊ kam cɛ ʊ, ŋn'a nyɩnɔ kam gʊɔɔ ʊ ŋnɩ ŋ kam cɛ ʊ, an ta an aa dɔmɩm kʊ Nowee gasʊ kɔɔlʊʊ b'ʊ bɩ ku. ");
INSERT INTO bib_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ŋ n a zu a ʊ, ŋ n a dɔ ŋ ʊ hɔsɩ ɩ barɛ y, hi bɩ n tolle ba an bɩ cem ŋ nɩ haay. A yɩrɛ ncɩnaaʊ Gʊaanyɩ bɩ zɛrɛ dɔmɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kʊ gʊaa hɩɩya ɩ hɔsɩra ʊ: n deem gaam, n nɩ deem to. ");
INSERT INTO bib_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kʊ lannɔ hɩɩya ŋn'ɩ jaa lɔm, n deem gaam, n nɩ deem to. ");
INSERT INTO bib_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Naa minto bɩ, a b'a zu a ʊ y, bala, awɔɔ n dɔmɩm k'awɔɔ Zuuba n nɩ zɛŋ ʊ bɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","K'a mim naa do jɩ ma mɩŋŋa. Kʊ harzaa b'a dɔ a ʊ, koor bɩ zɛm gunuu wakatɩ naa do ma, a bɩ hinceem barɛ y, a bɩ koor bɩ tore an gasʊ a cɛ b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bɩ y'a ka, awɔɔ sɔ k'a a banka, bala, Gʊaanyɩ bɩ zɛm wakatɩ k'awɔɔ bɩr a hɔɔn dam ma b'ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Zibəənyɩ kara n mɩŋŋa, a hɔɔn n ta ʊ? Zibəənyɩ lɛɛzaa zibəə ka ʊ, a ʊ, an dɩga zibəənyɩnɔ mɩsɩrɔ wɔɔ ma mɩŋŋa k'a nɩ ŋ hɔbɩrɛ kaŋ ʊ a dɔmɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Zibəənyɩ bɩ do nyɩntam mimbirenyɩntazaa, k'a lɛɛzaa b'a wusigə an bʊr har ʊ, an b'a ku an nɩ zibəə k'a ka ʊ bɩ barɛ. ");
INSERT INTO bib_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, lɛɛzaa bɩ y'a kam an yɩ a har bɩ haay arzaka dɔmazaa. ");
INSERT INTO bib_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bɩ, kʊ zibəənyɩ bʊnyaa m, a y'a hɩrɛ a heer ʊ, a ʊ, mɔɔ Zuuba maasɩrɛ ba a bɩr zɛrɛ y. ");
INSERT INTO bib_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","A n wuti, an a muno wɔɔ zɛ, an hɔ bɩ, an bɛɛ mi kan bɛɛminno kɩ. ");
INSERT INTO bib_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","B'a Zuuba bɩ zɛm dɔmɩm kʊ zibəənyɩ bɩ bɩr dɔm ma b'ʊ, kan wakatɩ k'a n a dɔ bɩ kɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A zibəənyɩ bɩ hʊnhʊrm mɩŋŋa, an zambʊzannɔ fɩryɩrɛ ka ma, bɩncɛ niŋŋə k'a nɩ nyi kaŋ ʊ, an a sɔ sʊ ʊ b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Woso cirbəə bɩ bɔ kʊ rɛ kan nyɩmbɔnnɔ buro kʊ ŋ y'a fɩtɩrɛrɔ gʊr, ŋnɩ bɔ k'a yaa n'a zim zɛ ʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Soor hɔɔn ɩ ba ʊ y, soor hɔɔn n ta ʊ. ");
INSERT INTO bib_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ŋ hɔɔn ba ʊ rɔ wɔɔ n a fɩtɩrɛrɔ gʊr, bɩ ŋ n nyɔɔ tɔ mɔr ʊ, ŋn'a sa y. ");
INSERT INTO bib_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bɩ, ŋ hɔɔn n ta ʊ rɔ wɔɔ, brɔɔ nyɔɔ tɔ mɔdrɔ ʊ ŋn'a na a fɩtɩrɛrɔ wɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bɩ, zim bɩ bɔkarɛ an maasɩrɛ ba a bɩr zɛrɛ y. Hinceem n nyɩmbɔnnɔ bu rɔ wɔɔ nyasʊ, ŋnɩ hinceem ba. ");
INSERT INTO bib_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Gunuu wakatɩ bueerehɩɩya k'a b'a ku bɩ, zee n bɔ, a ʊ: ‹Zim bɩ ba n nɩ! K'a bɔ a yaa a zɛ ʊ!› ");
INSERT INTO bib_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","A m naa, nyɩmbɔnnɔ bu rɔ wɔɔ n gu, ŋn'a fɩtɩrɛrɔ bankarɛ. ");
INSERT INTO bib_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ŋ hɔɔn ba ʊ rɔ wɔɔ n'a hɩm, ŋ ʊ: ‹K'a nyɔɔ bɩ ka wɔɔ ʊ poore, bala, wɔɔ fɩtɩrɛrɔ wɔɔ ɩ lihim.› ");
INSERT INTO bib_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ŋ hɔɔn ta ʊ rɔ wɔɔ n a nyɩ bɔ ʊ, ŋ ʊ: ‹Ayy…, bala, a bɩ gʊta y, a bɩ wɔɔ bɔm kan awɔɔ kɩ y. K'a ta a yaa n a hɔ si a hɛɛrɛzannɔ wɔɔ zi.› ");
INSERT INTO bib_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ŋ hɔɔn ba ʊ rɔ wɔɔ n ta k'a yaa nyɔɔ bɩ si, a hʊr kʊ ŋ y'a ʊ bɩ, zim bɩ gɔɔta an bʊr ŋ jɛ ʊ, nyɩmbɔnnɔ kʊ ŋ y'a banka rɔ wɔɔ n gasʊ kan kɩ harcɩntarɛ cibsa cɛ ʊ b'ʊ, n nɩ cɛlɛ bɩ gaa, n n a ta a nyɩ m. ");
INSERT INTO bib_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Maasɩrɛ k'a ba bɩ, nyɩmbɔnnɔ kʊ ŋ gɔɔta rɔ wɔɔ bʊr, ŋn'ɩ zee darɛ, ŋ ʊ: ‹Karɩnsaamba, karɩnsaamba, cɛ bɩ gʊ wɔɔ m!› ");
INSERT INTO bib_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bɩ, b'a nyɩ bɔ ʊ, a ʊ: ‹Sɩra mɔɔ n'a hɩrɛ awɔɔ m, mɔɔ n awɔɔ dɔ y.› » ");
INSERT INTO bib_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yeezuu n a ya, an a hɩ, a ʊ: «A bɩ hinceem ba y, bala, awɔɔ n dɔmɩm bɩ kan wakatɩ bɩ kɩ dɔ y.» ");
INSERT INTO bib_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Woso cirbəə b'a ya, an bɔ kʊ rɛ kan gʊaa k'a n'a ŋʊam k'a ta kʊ ʊ, an a zibəənyɩnɔ bir, an a arzaka ka ŋ ʊ kʊ ŋ nɩ dɔ ma bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A n talan soor ka deem ʊ, an talan hɩɩya ka naa do ʊ, an talan deem ka a vanta ʊ. Gʊaa biyəə n n'a dam ma an zi ba m b'a ka ʊ, an bɔkarɛ, an cem. ");
INSERT INTO bib_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Gʊaa k'a talan soor bɩ yɩ bɩ n ta an ter ba m, an talan soor vanta yɩ an a na ma. ");
INSERT INTO bib_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Gʊaa k'a talan hɩɩya yɩ bɩ n ta an ter ba m sɔ, an talan hɩɩya yɩ an a na ma. ");
INSERT INTO bib_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bɩ, gʊaa k'a talan deem yɩ bɩ, ta a ʊ, an aa yaa hɔn, an a zuuba bɩ busoo nyaakʊm da ʊ. ");
INSERT INTO bib_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Zibəənyɩnɔ wɔɔ zuuba bɩ, k'a ta tee… bɩ, a a bɔ an bʊr, an n'a busoo bɩ mim laaka darɛ ŋ han. ");
INSERT INTO bib_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Gʊaa k'a talan soor yɩ bɩ n a zɔ, an talan soor k'a yɩ an a na ma bɩ hɩnka, an a hɩ, a ʊ: ‹Zuuba, talan soor ɩbɩɩ ka mɔɔ ʊ hɔɔ, talan soor vanta ba mɔɔ yɩ na.› ");
INSERT INTO bib_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A zuuba bɩ n a hɩ m, a ʊ: ‹Zibəənyɩ mɩŋŋa k'an tɩrga n'ɩbɩɩ m, a mɩŋŋa, ɩbɩɩ sɩra zi ba hɔ poore nɔ ʊ, mɔɔ hɔ gʊta zibəə karɛ ɩ ʊ, bʊr ɩ heernyɔɔ ba kan mɔɔ kɩ.› ");
INSERT INTO bib_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Zibəənyɩ k'a talan hɩɩya yɩ bɩ n a zɔ, an a hɩ, a ʊ: ‹Talan hɩɩya ɩbɩɩ ka mɔɔ ʊ, talan hɩɩya vanta ba mɔɔ yɩ na.› ");
INSERT INTO bib_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A zuuba bɩ n a hɩ m, a ʊ: ‹Zibəənyɩ mɩŋŋa k'an tɩrga n'ɩbɩɩ m, ɩbɩɩ sɩra zi ba hɔ poore nɔ ʊ, mɔɔ hɔ gʊta zibəə karɛ ɩ ʊ, bʊr ɩ heernyɔɔ ba kan mɔɔ kɩ.› ");
INSERT INTO bib_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Zibəənyɩ k'a talan deem yɩ bɩ n a zɔ, an a hɩ, a ʊ: ‹Zuuba, mɔɔ dɔ mɔɔ ʊ gʊaa kʊsɩ n'ɩbɩɩ m, lɛɛ k'ɩbɩɩ n hɔ duu ʊ bɩ ɩbɩɩ nɩ hɔ daŋ ʊ, lɛɛ k'ɩbɩɩ n hɔ sɔɔn ʊ bɩ ɩbɩɩ nɩ hɔ saŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nyibəə mɔɔ nyasʊ, mɔɔ n ta m aa ɩ busoo bɩ biitə tara ʊ, dɩga, ɩ busoo bɩ ba n nɩ.› ");
INSERT INTO bib_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A zuuba bɩ n a nyɩ bɔ nʊ, a ʊ: ‹Zibəənyɩ bʊnyaa yakʊzaa ra! Ɩbɩɩ dɔ mɩŋŋa ɩ ʊ, mɔɔ ɩ hɔ dam lɛɛ kʊ mɔɔ n hɔ duu ʊ, m nɩ hɔ sam lɛɛ kʊ mɔɔ n hɔ sɔɔn ʊ. ");
INSERT INTO bib_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","A dɔ k'ɩbɩɩ ʊ maam bɩ, mɔɔ busoo bɩ cɩnta ɩbɩɩ nawʊm busoocɩntarɛcɛ ʊ, mɔɔ wusigəre ma, mɔɔ yɩ m busoo bɩ sam kan nyɔɔdʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Naa minto bɩ, k'a busoo talan deem k'an ta m bɩ yɔm, a ka talan bu zaa b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bala, gʊaa k'an ta hɔ m bɩ, n y'a kam bɩ zaa ʊ, an a na ma, a hɔ m yɩ gʊta. Bɩ gʊaa k'a bam bɩ, baa hɔ k'an ta m bɩ, n bɩ yɔm nɩ. ");
INSERT INTO bib_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Bɩ, k'a zibəənyɩ hɔ vam naa do zo garga ra monsigə ʊ. Lɛɛ bɩ do an nɩ baa daŋ ʊ, an a sɔ sʊ.› » ");
INSERT INTO bib_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Kʊ Gʊaanyɩ bʊr a cirbəə nɔ ʊ kan malɛɛkarɔ wɔɔ kɩ haay, a nyɩntam a cirbəəduu paŋŋazaa bɩ ra. ");
INSERT INTO bib_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Durnya kʊrɔ haay gʊɔɔ y'a som kʊ ma a lɛɛ, an gʊɔɔ gʊngʊ a hɔ, amba hɔbɩsɩrɔ dundor tɩr seero gʊ biiro ma bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A seero wɔɔ nyɔɔrɛ a bɩsɩ, an biiro wɔɔ nyɔɔ a jɩsa. ");
INSERT INTO bib_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Cir bɩ y'a hɩrɛ a bɩsɩ ra zannɔ wɔɔ m, a ʊ: ‹Awɔɔ kʊ mɔɔ Zɩ barka n nɩ kan a kɩ bɩ, k'a bʊr, a cirbəə kʊ Woso a banka awɔɔ minto durnya darɛ sɩŋŋɩda ʊ bɩ si. ");
INSERT INTO bib_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bala, nɔ mɔɔ zɛ, awɔɔ n hɔbɩrɛ ka mɔɔ ʊ, mɩsɩ mɔɔ zɛ, awɔɔ n hi ka mɔɔ ʊ, mɔɔ bʊr awɔɔ zi saana, awɔɔ mɔɔ si a har ʊ, ");
INSERT INTO bib_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mɔɔ nyɩnta dɩgɩ, awɔɔ n huu du mɔɔ ma, mɔɔ n nyɩnta laafɩɩ y, awɔɔ bɩ dɩga mɔɔ ma, mɔɔ nyɩnta lɔnnɔcɛ ʊ, awɔɔ m bʊr mɔɔ zi b'ʊ.› ");
INSERT INTO bib_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Meerbaa naa do jɛ ʊ, gʊɔɔ tɩrgɔɔ wɔɔ y'a hɩrɛ, ŋ ʊ: ‹Zuuba, wɔɔ ɩbɩɩ yɩ brɔɔ nɔ n'ɩbɩɩ zɛrɛ, ʊ hɔbɩrɛ ka ɩbɩɩ ʊ, gɛɛ mɩsɩ n'ɩ zɛrɛ, ʊ hi ka ɩ ʊ? ");
INSERT INTO bib_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wɔɔ ɩbɩɩ yɩ brɔɔ saana, ʊ ɩbɩɩ si ʊ har ʊ, gɛɛ ɩbɩɩ n dɩgɩ, ʊ huu du ɩ ma? ");
INSERT INTO bib_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Wɔɔ ɩbɩɩ yɩ brɔɔ ɩ nɩ yaaba m, gɛɛ ɩ nɩ lɔnnɔcɛ ʊ, ʊ ta, ʊ aa dɩga ɩ ma?› ");
INSERT INTO bib_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Cir bɩ y'a hɩrɛ, a ʊ: ‹Sɩra mɔɔ n'a hɩrɛ awɔɔ m, hɔɔ nɔɔn duro k'awɔɔ n n'a bam gʊɔɔ poorero nɔɔn gʊaa deem m bɩ, kʊ ŋ nɩ mɔɔ danyɩnɔ wɔɔ bɩ, a ba awɔɔ nawʊm mɔɔ m.› ");
INSERT INTO bib_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Naa jɛ ʊ, a y'a hɩm jɩsa ra zannɔ wɔɔ m, a ʊ: ‹K'a jɩ bɔ mɔɔ ma a ta laatʊ, awɔɔ kʊ Woso lerbɔrɛ bʊnyaa n'a jɛ ʊ, k'a ta sɛ k'a lihire ba ʊ, n n a banka Sʊtaana kan a malɛɛkarɔ kɩ minto b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bala, nɔ mɔɔ zɛ, b'awɔɔ n hɔbɩrɛ ka mɔɔ ʊ y, mɩsɩ mɔɔ zɛ, b'awɔɔ n hi ka mɔɔ ʊ y, ");
INSERT INTO bib_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mɔɔ nyɩnta saana, awɔɔ n mɔɔ si a har ʊ y, mɔɔ nyɩnta dɩgɩ, awɔɔ n huu du mɔɔ ma y, mɔɔ n nyɩnta laafɩɩ y, awɔɔ n bɩ dɩga mɔɔ ma y, mɔɔ nyɩnta lɔnnɔcɛ ʊ, awɔɔ n bɩ dɩga mɔɔ ma sɔ y.› ");
INSERT INTO bib_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Brɔɔ y'a hɩm nɩ, ŋ ʊ: ‹Zuuba, wɔɔ ɩbɩɩ yɩ brɔɔ nɔ n'ɩ zɛrɛ, mɩsɩ n'ɩ zɛrɛ, gɛɛ saana, ɩ n dɩgɩ, ɩ nɩ yaaba m, ɩ nɩ lɔnnɔcɛ ʊ, wɔɔ n dɩga ɩbɩɩ ma, k'ʊ da ɩ han?› ");
INSERT INTO bib_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Cir bɩ y'a hɩrɛ ŋ nɩ, a ʊ: ‹Sɩra mɔɔ n'a hɩrɛ awɔɔ m, k'awɔɔ n a ba gʊɔɔ poorero nɔɔn duro gʊaa deem m bɩ, awɔɔ n a ba mɔɔ m sɔ y.› ");
INSERT INTO bib_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ncɩnaaʊ bɩ, ŋ y'a hʊrlɛ ŋnɩ ta hʊnhʊrlɛ k'a nyarɛ ba ʊ bɩ nɔ ʊ, bɩ gʊɔɔ tɩrgɔɔ wɔɔ tam mɩsɩrbaa k'a nyarɛ ba ʊ bɩ nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yeezuu k'a meerbaarɔ nɔɔn duro ba haay bɩ, a a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «Awɔɔ dɔ a ʊ pakkɩ cibsa n zizer. ");
INSERT INTO bib_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","N Gʊaanyɩ bɩ nyasʊrɛ, n n a zɛ gɔdarkʊra ma.» ");
INSERT INTO bib_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A m naa, wosocɛmannɩbənno jɩtannɔ, kan kʊ bɩ gʊɔɔgusinno wɔɔ kɩ n a so kʊ ma wosocɛmannɩbər jɩtaarɛ *Kayiifʊ har ʊ. ");
INSERT INTO bib_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ŋ n kʊ ma k'a Yeezuu nyasʊ hɔɔnkarɛ m, a zɛ gər. ");
INSERT INTO bib_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ŋ n'a hɩrɛ, ŋ ʊ: «Ʊ b'a nyasʊ cibsa bɩ bire ʊ y, kʊ m bɛɛ zɛkʊma nyɩntam zamaa bɩ bire ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yeezuu k'a ta Sɩmɔɔn kʊ n n'a birm kusimə bɩ har ʊ, Betanii ʊ bɩ, ");
INSERT INTO bib_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yeezuu k'a nyɩnta an nɩ hɔ bɩm bɩ, lʊ n a zɔ ma tidəər k'a lɛ n kʊsɩ m albatɩr jaa gedre ʊ, an a burgu Yeezuu mim la. ");
INSERT INTO bib_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Karɩndanyɩnɔ wɔɔ kʊ ŋ naa yɩ bɩ, ŋ nɔ n yɩ y, ŋn'a hɩrɛ, ŋ ʊ: «Bɔ noonkahɔma n naa? ");
INSERT INTO bib_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","N y'a da ma, n nɩ tidəər naa do hɛɛ busoo gʊta ma, n n a ka ŋʊazannɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeezuu k'a a dɔ a ʊ, ŋ yɩ meer barɛ ncɩnaaʊ bɩ, a a hɩ ŋ nɩ, a ʊ: «Bɔ m, awɔɔ nɩ lʊ naa do heer kɔrɛ? Zibəə mɩŋŋa a a ba mɔɔ m naa. ");
INSERT INTO bib_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ŋʊazannɔ gɔɔtarɛ ŋnɩ bɩr kan awɔɔ kɩ tee…, bɩ mɔɔ ba kan awɔɔ kɩ tee… y. ");
INSERT INTO bib_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tidəər naa do k'a a burgu mɔɔ ra naa, mɔɔ gər birle a a banka. ");
INSERT INTO bib_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, lɛɛ haay kʊ gʊɔɔ n nɩ lemim nyɩnta naa do dɩndaŋ ʊ durnya lɛɛ haay ʊ bɩ, ŋ lʊ naa do zi k'a a ba bɩ tɔ darɛ a nɔ ʊ, ŋn'a dɩnda.» ");
INSERT INTO bib_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Bɩ kur bɩ, Zidas Iskarɩyɔtɩ karɩndanyɩnɔ bueerehɩɩyɔɔ wɔɔ gʊaa deem bɩ ta wosocɛmannɩbənno jɩtannɔ wɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","A n aa a hɩ ŋ nɩ, a ʊ, awɔɔ: «Bɔ hɔ awɔɔ n n'a kam mɔɔ ʊ, kʊ mɔɔ Yeezuu nyasʊ m a ka a ʊ?» Brɔɔ n wanzurfu busooyaa lɛ sa bukərku, ŋn'a ka ʊ. ");
INSERT INTO bib_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Dɔmɩm bɩ do tɛkka ʊ, Zidas y'a kam toore mɩŋŋa ma k'a Yeezuu nyasʊ a ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bur kʊ n nɩ nyʊnyɔɔ da ʊ cibsa lɛɛkarɛ dɔmɩm ma bɩ, karɩndanyɩnɔ wɔɔ bʊr Yeezuu zi, ŋn'a lar, ŋ ʊ: «Ɩbɩɩ lɛ n taa kʊ aa pakkɩ hɔbɩrɛ banka lɛɛ kara ʊ ɩbɩɩ minto?» ");
INSERT INTO bib_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «K'a ta kʊnɔ ʊ b'ʊ niŋŋəzaa naa zi, a hɩ m, a ʊ: Karɩnsaamba ʊ, mɔɔ dɔmɩm a zɔ, ɩbɩɩ har mɔɔ n nɩ pakkɩ bɩ bɩŋ ʊ kan ŋ karɩndanyɩnɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Karɩndanyɩnɔ wɔɔ hɔ kʊ Yeezuu a hɩ ŋ nɩ bɩ ba, ŋnɩ pakkɩ hɔbɩrɛ bɩ banka. ");
INSERT INTO bib_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yirbəə k'a da bɩ, Yeezuu nyɩnta k'a hɔ bɩ kan bueerehɩɩyɔɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hɔbɩrɛ bɩ kʊ ŋ n'a bɩm bɩ, Yeezuu n a hɩ, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m, awɔɔ gʊaa deem mɔɔ nyasʊrɛ, an mɔɔ ka.» ");
INSERT INTO bib_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Karɩndanyɩnɔ wɔɔ heer n a zar, ŋn'ɩ laaka dam han deem-deem, ŋ ʊ: «Yɩ a nawʊm mɔɔ ra, Zuuba?» ");
INSERT INTO bib_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Gʊaa k'a a wɔ nyɔɔ laaga b'ʊ kan mɔɔ kɩ, bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gʊaanyɩ bɩ garɛ amba hɔ kʊ ŋ y'a gʊrsɩra ba a tɔ ma bɩ m, bɩ gʊaa k'a nɩ Gʊaanyɩ bɩ nyasʊm k'a ka bɩ kʊsɩ yɩrɛ. Kʊ gʊaa bɩ do ɩ nɩ yɩ, a jɩra m.» ");
INSERT INTO bib_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zidas k'a nɩ zɛm b'a nyasʊ an a ka bɩ n a lar, a ʊ: «Mɔɔ m gɛɛ karɩnsaamba?» Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Ɩbɩɩ y'a hɩ ɩ zi m.» ");
INSERT INTO bib_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hɔbɩrɛ bɩ kʊ ŋ n'a bɩm bɩ, Yeezuu bur sa an barka da Woso m, an a zɩnzɛ ra, an bɔkarɛ an a ka a karɩndanyɩnɔ wɔɔ ʊ, an a hɩ ŋ nɩ, a ʊ: «K'a si a bɩ, naa do naa mɔɔ mɛ m.» ");
INSERT INTO bib_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bɩ kur bɩ, an hɔmire sa, an barka da Woso m, an bɔkarɛ an a ka a karɩndanyɩnɔ wɔɔ ʊ, an a hɩ, a ʊ: «Awɔɔ haay k'a mi. ");
INSERT INTO bib_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Bala, mɔɔ ma n naa, gʊaasɩbabaa ma m, an a lo gʊɔɔ ciiro minto, mimbʊnyaarɔ sugur yɩrɛ minto. ");
INSERT INTO bib_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A hɩ mɔɔ nawʊrɛ awɔɔ m, mɔɔ bɩ m yarɛ m dɩvɛn daa mi dʊntɔ y, an ta an dɔmɩm kʊ mɔɔ n a mim kan awɔɔ kɩ m Zɩ cirbəə nɔ ʊ bɩ ku.» ");
INSERT INTO bib_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kʊ ŋ cibsa bɩ laarɔ lɔ ŋn'a nya bɩ, ŋ y'a hʊr ŋnɩ ta Oliviyee ci ra. ");
INSERT INTO bib_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Bɩ kur bɩ, Yeezuu a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «Gum naa do ʊ bala, awɔɔ haay y'a sɩrakarɛ tom mɔɔ minto, bala, n y'a gʊrsɩra ba Wosoci nɔ ʊ, n ʊ: ‹Mɔɔ seero dundor bɩ zɛm, seero wɔɔ n hɩsɩga da.› ");
INSERT INTO bib_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bɩ kʊ mɔɔ bɩ m mɩm bɔ ʊ, mɔɔ lɛɛkarɛ awɔɔ lɛɛ Galilee ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pɩyɛɛr n meerbaa bɩ sa, an a hɩ m, a ʊ: «Baa kʊ nawɔnnɔ haay a sɩrakarɛ to, mɔɔ bɩ m sɩrakarɛ tore y.» ");
INSERT INTO bib_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Sɩra mɔɔ n'a hɩrɛ ɩbɩɩ m: Gum naa do ʊ bala, an lɛɛ ka koo baadarɛ m, ɩbɩɩ bɩsɩ kam mɔɔ ma gallɛm kaakʊ ɩ ʊ, ɩ n mɔɔ dɔ y.» ");
INSERT INTO bib_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pɩyɛɛr n a hɩ m, a ʊ: «Baa kʊ ga mɔɔ nawʊm kan ɩbɩɩ kɩ, bɩ m. Mɔɔ bɩ bɩsɩ karɛ ɩbɩɩ ma y.» A muno wɔɔ haay n a hɩ maam sɔ. ");
INSERT INTO bib_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Bɩ kur bɩ, Yeezuu ta kan a karɩndanyɩnɔ wɔɔ kɩ lɛɛ kʊ n n'a birm Gɛtsemanee ʊ b'ʊ, an a hɩ ŋ nɩ, a ʊ: «K'a nyɩnta naa ʊ, kʊ m aa yaa da lɛɛ naa do ʊ kʊ m bʊr.» ");
INSERT INTO bib_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A n Pɩyɛɛr gaa kan Zebedee nyɩnɔ hɩɩyɔɔ wɔɔ kɩ. Heerzar kan dabɔʊ kɩ gasʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A n a hɩ ŋ nɩ, a ʊ: «Mɔɔ heer a zar an a zɔ zɛ ma, k'a gɔɔta naa ʊ, a bɩ hinceem ba y.» ");
INSERT INTO bib_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A n ta lɛɛ poore, an a do an a meer ku tara ma, an nɩ yaa darɛ, an n'a hɩrɛ, a ʊ: «M Zɩ, kʊ fɩryɩrɛ naa do y'a dam ma an a gʊ mɔɔ ma, k'ɩ gʊ m ma. Kan naa kɩ haay ɩ bɩ mɔɔ hɔɔnhɔ ba y, ɩ hɔɔnhɔ ba.» ");
INSERT INTO bib_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A n a wusigə, an bʊr karɩndanyɩnɔ kaakʊrɔ wɔɔ zi, a bɩ dɩga a ŋ hinceem ba. A n a hɩ Pɩyɛɛr m, a ʊ: «Ncɩnaaʊ bɩ, awɔɔ n a da a mɩŋŋa ma a jɩm wakatɩ deem nɔ ʊ tɔkkɛ kan mɔɔ kɩ y! ");
INSERT INTO bib_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","K'a yaa da, a bɩ hinceem ba y, a yaa n a do makra nɔ ʊ. Gʊaa heer lɛ taa, b'a mɛsim paŋŋa ba ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A n a ya, an a bɔ a hɩɩya hɔ ma, an yaa da, a ʊ: «M Zɩ, kʊ pakra m kʊ fɩryɩrɛ naa do n mɔɔ yɩ, k'an yɩ maam, k'ɩ hɔɔnhɔ n kʊ yɩ.» ");
INSERT INTO bib_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A n a ya, an a bɔ an bʊr karɩndanyɩnɔ wɔɔ zi, an bɩ ŋ yɩ ŋn'ɩ hinceem barɛ, hinceem k'a nɩ ŋ zɛm bɩ minto m. ");
INSERT INTO bib_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yeezuu n a ya, an a gʊ ŋ ma a kaakʊ hɔ ma, an aa so a yaadarɛ bɩ ra. ");
INSERT INTO bib_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","A n a bɔ an bʊr karɩndanyɩnɔ wɔɔ zi, an a hɩ ŋ nɩ, a ʊ: «Awɔɔ gɔɔta an nɩ hinceem bam, an nɩ hoon sim na? K'a dɩga a wakatɩ a ku, n Gʊaanyɩ bɩ nyasʊrɛ, n n a ka mimbʊnyaabənno ʊ. ");
INSERT INTO bib_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","K'a wuti! K'ʊ ʊ hʊr! Gʊaa k'a nɩ mɔɔ nyasʊm k'a mɔɔ ka bɩ lee ku.» ");
INSERT INTO bib_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","K'a gɔɔta an nɩ meer bam bɩ, karɩndanyɩnɔ bueerehɩɩyɔɔ wɔɔ gʊaa deem Zidas bɩ lee ku. Bʊr a ʊ kan zamaa cir gʊta kɩ, ŋn'ɩ kargʊrɔ m kan bənkənno kɩ. Wosocɛmannɩbənno jɩtannɔ kan zɩɩfʊrɔ gʊɔɔgusinno wɔɔ kɩ yɩ ŋ nyɔɔ. ");
INSERT INTO bib_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zidas bɩ lɛɛ ka an hɔ k'a n'a bam ŋnɩ Yeezuu dɔ ŋn'a nyasʊ bɩ makra hɩnka ŋ nɩ, a ʊ: «Gʊaa kʊ mɔɔ n nɩ yaa dam nɩ kan daʊrɛ kɩ bɩ, gʊaa bɩ do m, k'a nyasʊ.» ");
INSERT INTO bib_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Zidas n a zɔ Yeezuu ma lɛɛm, an a hɩ m, a ʊ: «Karɩnsaamba, mɔɔ ɩ yaa darɛ ɩbɩɩ m!» A n bɔkarɛ, an yaa da m. ");
INSERT INTO bib_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeezuu n a hɩ m, a ʊ: «M gʊaasɩba, hɔ k'ɩ bʊr, kɩ b'a ba bɩ ba.» A m naa, gʊɔɔ wɔɔ n a zɔ Yeezuu ma, ŋn'a nyasʊ. ");
INSERT INTO bib_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bɩ, gʊɔɔ kʊ ŋ nɩ kan Yeezuu kɩ rɔ wɔɔ gʊaa deem a kargʊ gaa ʊ, an wosocɛmannɩbər jɩtaarɛ bɩ zibəənyɩ deem sakʊ, an a tʊr gʊ ma. ");
INSERT INTO bib_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yeezuu n a hɩ m, a ʊ: «Ɩ kargʊ bɩ du a caan ʊ, bala, gʊaa niŋŋə k'a nɩ yar bam kargʊ m bɩ, kargʊ n n'a zɛm gər. ");
INSERT INTO bib_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ɩbɩɩ n a dɔ ɩ ʊ, mɔɔ n da ma, m m Zɩ bir, an malɛɛkarɔ tisi bam hɔka-hɔka nyɔɔ mɔɔ m lɛɛm na? ");
INSERT INTO bib_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bɩ k'a yɩ ncɩnaaʊ, Wosoci bɩ meerbaa y'a bam lɔ, an kʊ yɩ? Bala, a a hɩ, a ʊ: Pakra m k'an yɩ ncɩnaaʊ.» ");
INSERT INTO bib_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yeezuu n a ya, an a hɩ gʊaa cir bɩ m, a ʊ: «Bʊr awɔɔ ʊ kargʊrɔ m kan bannɔ kɩ k'a bɩ mɔɔ nyasʊ, ɩ ʊ, dazaamazaa m mɔɔ nɩ! Mɔɔ nyɩnta Wosocɛ ʊ b'ʊ dɔmɩm haay, m nɩ hɔ dɩndam, b'awɔɔ n mɔɔ nyasʊ y. ");
INSERT INTO bib_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bɩ naa do haay naa, ba a ʊ kʊ wosolɛsinnɩsorazannɔ wɔɔ meerbaarɔ kʊ ŋ nɩ Wosoci b'ʊ rɔ wɔɔ n kʊ yɩ.» A m naa, karɩndanyɩnɔ wɔɔ haay n a si, ŋn'a bɔ Yeezuu ʊ. ");
INSERT INTO bib_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Gʊɔɔ kʊ ŋ Yeezuu nyasʊ rɔ wɔɔ ta m wosocɛmannɩbər jɩtaarɛ *Kayiifʊ har ʊ. Lɛɛ bɩ do wosocikarɩnsaambɔɔ wɔɔ a so kʊ ma ʊ, kan gʊɔɔgusinno wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pɩyɛɛr n zu Yeezuu jɛ ʊ laatʊ, an ta an aa lee ku wosocɛmannɩbər jɩtaarɛ bɩ har ʊ. A n gasʊ har b'ʊ, an aa nyɩnta kan hallɛdɔmazannɔ wɔɔ kɩ, k'a dɩga mim bɩ nyambʊrlɛ ma. ");
INSERT INTO bib_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wosocɛmannɩbənno jɩtannɔ wɔɔ kan dʊdɔkənno wɔɔ haay kɩ y'a kam mim ma k'a ka Yeezuu ra, k'a ku a dʊdɔ yar, a ka kʊ n n a zɛ gər. ");
INSERT INTO bib_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bɩ, ŋ bɩr mim yɩrɛ y, baa kʊ gʊɔɔ bʊr gʊta ŋnɩ ŋʊaar ba k'a ka ra bɩ, ŋ n a da ma, ŋnɩ hɔsɩ yɩ k'a ka ra y. Gʊɔɔ hɩɩyɔɔ ɩ bɔkarɛ ŋnɩ bʊr. ");
INSERT INTO bib_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ŋ n a hɩ, ŋ ʊ: «Gʊaa naa do a hɩ, a ʊ: Mɔɔ m da ma, m Wosocɛ bɩ wurgə, m m ya, m a dɔ dɔmɩm kaakʊ nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wosocɛmannɩbər jɩtaarɛ bɩ n wuti, an a hɩ Yeezuu m, a ʊ: «Ɩbɩɩ bɩr a nyɩ bɔŋ ʊ ra? Bɔ mim gʊɔɔ nɔɔn duro n a hɩrɛ ɩbɩɩ minto na?» ");
INSERT INTO bib_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bɩ, Yeezuu bɩr hɔsɩ hɩrɛ y. Wosocɛmannɩbər jɩtaarɛ bɩ n a ya, an lɛ ka ʊ, a ʊ: «Ɩ wer si Woso k'an mɩsɩr bɩ tɔ ma, sɩra hɩ wɔɔ m, ɩbɩɩ m Krista Woso Nyɩ bɩ gɛ?» ");
INSERT INTO bib_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Ɩbɩɩ n'a hɩrɛ, bɩ mɔɔ y'a hɩrɛ awɔɔ m, an a sɩŋŋɩda sa naa ma kɛɛrɛ bɩ, awɔɔ Gʊaanyɩ bɩ yɩrɛ an nyɩnta Woso paŋŋazaa bɩ bɩsɩ ra, awɔɔ y'a yɩm sɔ, an bɩr zɛm warkʊ mim ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","A m naa, wosocɛmannɩbər jɩtaarɛ bɩ nɔ n ma ʊ, an a huuro kɩnkaansʊ, an a hɩ, a ʊ: «Woso sʊnsɔ a a wʊ, kasɛtɩzannɔ zibəə a ya an ta wɔɔ ma ra? Awɔɔ Woso sʊnsɔ k'a wʊ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Awɔɔ y'a hɔɔn dam lɔ kɛɛrɛ?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «A a ga zɛ m.» ");
INSERT INTO bib_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ŋ n lihi da a meer ma, ŋn'a wɔrɔ hunhuŋŋu ŋn'a zɛrɛ, gɔsɩnnɔ n n'a wɔ tɩntam lɛ, ŋn'a hɩrɛ, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«Wosolɛsinnɩsorazaa zi ba, ɩ hɩ wɔɔ m, Krista, nka y'ɩ zɛ?» ");
INSERT INTO bib_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kʊ Pɩyɛɛr nɩ nyɩntam tɩnsara b'ʊ bɩ, wosocɛmannɩbər jɩtaarɛ bɩ zibəənyɩlʊrɔ wɔɔ gʊaa deem a zɔ ma, an a hɩ m, a ʊ: «Ɩbɩɩ ɩ kan Galilee gʊaa Yeezuu bɩ kɩ sɔ!» ");
INSERT INTO bib_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pɩyɛɛr n bɩsɩ ka gʊaa haay lɛɛ, an n'a hɩrɛ, a ʊ: «Mɔɔ n hɔ k'ɩbɩɩ ʊ k'ɩ hɩ naa jɩ dɔ y.» ");
INSERT INTO bib_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","A n a hʊr b'ʊ, an nɩ tam har bɩ lɛ ma, zibəənyɩlʊ vanta n a yɩ, an a hɩ gʊɔɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ m, a ʊ: «Gʊaa naa do nyɩnta kan Nazarɛtɩ Yeezuu bɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pɩyɛɛr n a ya, an bɩsɩ ka Yeezuu ma, an n'a hɩrɛ, a ʊ: «Mɔɔ m wer si, mɔɔ n gʊaa naa do dɔ y.» ");
INSERT INTO bib_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kʊ maasɩrɛ ba poore bɩ, gʊɔɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ a zɔ Pɩyɛɛr ma, ŋn'a hɩ m, ŋ ʊ: «Kʊ sɩra m, ŋ gʊaa n'ɩbɩɩ m sɔ, ɩbɩɩ meerbaa y'ɩ tojɩ hɩnkarɛ.» ");
INSERT INTO bib_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pɩyɛɛr n a sɩŋŋɩda ba, an n'a wer sim, an n'a tarɛ a rɛ, a ʊ: «Mɔɔ n gʊaa naa do dɔ y!» Lɛɛm bɩ, koo n baa da. ");
INSERT INTO bib_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pɩyɛɛr n mim kʊ Yeezuu a hɩ m bɩ tɔ da a nɔ ʊ: «Ɩbɩɩ bɩsɩ kam mɔɔ ma gallɛm kaakʊ koo n bɔkarɛ, an baa da.» A n bɔ, an nɩ nyi kam kan heer zar gʊta kɩ. ");
INSERT INTO bib_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Dɔ k'a mɛ dɔgta mɩŋŋa m bɩ, wosocɛmannɩbənno jɩtannɔ wɔɔ kan tara bɩ gʊɔɔgusinno kɩ lɛ sa k'a Yeezuu ka zɛ ma. ");
INSERT INTO bib_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ŋ n a sur, ŋnɩ ta m, ŋn'aa ka Rɔm lɛɛzaa Pɩlatɩ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zidas Yeezuu nyasʊ an a ka, bɩ, k'a b'a yɩ ŋnɩ Yeezuu dʊdɔ yar k'a zɛ gər bɩ, a kʊrkʊr da, an a bɔ an a wanzurfu busooyaa bukərku rɔ wɔɔ ka wosocɛmannɩbənno jɩtannɔ wɔɔ ʊ kan gʊɔɔgusinno wɔɔ kɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A n a hɩ ŋ nɩ, a ʊ: «Gʊaa k'a n hɔsɩ ba naa kʊ mɔɔ ka ŋn'a zɛ naa, mimbʊnyaa mɔɔ ba.» Bɩ brɔɔ a nyɩ bɔ nʊ, ŋ ʊ: «Kara ɩ pakra ba wɔɔ ma? Ɩbɩɩ mim m!» ");
INSERT INTO bib_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","A n aa busoo bɩ lo Wosocɛ b'ʊ, an a hʊr, an ta an aa bar da a ma. ");
INSERT INTO bib_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wosocɛmannɩbənno wɔɔ n busoo bɩ gʊr, ŋn'a hɩ, ŋ ʊ: «Wɔɔ lɛrɔ wɔɔ nɔ ʊ, a n a ga m, kʊ wɔɔ n busoo naa do zar Wosocɛ bɩ busoo ra y, bala, gərzɛrɛ busoo m.» ");
INSERT INTO bib_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ŋ nɩ kʊ ma, ŋnɩ busoo bɩ sa ŋnɩ mɔrdor hɔsɩra si m, k'an yɩ saanɔɔ gəənoyaa. ");
INSERT INTO bib_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Bɩ y'a ka, n n hɔsɩra bɩ do tɔ ka, n ʊ: ‹Ma sɩra,› an ta, an her dɔmɩm ku. ");
INSERT INTO bib_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","A m naa, wosolɛsinnɩsorazaa Zeremii meerbaa k'a ba bɩ n kʊ yɩ: ‹Ŋ wanzurfu bukərku bɩ sa, ŋnɩ mɔrdor bɩ hɔsɩra bɩ si m, amba Zuuba a hɩ mɔɔ m bɩ m. Gʊaa kʊ Israyɛl nyɩnɔ kʊ ma, ŋn'a ter ba bɩ busoo m.› ");
INSERT INTO bib_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bɩ, Yeezuu yaa jɩm lɛɛzaa Pɩlatɩ lɛɛ. Bɩ n a lar, a ʊ: «Zɩɩfʊrɔ cir n'ɩbɩɩ m gɛ?» Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Ɩbɩɩ hɩ ɩ zim.» ");
INSERT INTO bib_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bɩ, wosocɛmannɩbənno jɩtannɔ wɔɔ kan gʊɔɔgusinno wɔɔ kɩ ɩ mim kam Yeezuu ra, b'a n hɔsɩ nyɩ bɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pɩlatɩ n a hɩ m, a ʊ: «Ɩbɩɩ bɩr minno kʊ ŋ nɩ ŋ karɛ ɩ ra bɩ mam na?» ");
INSERT INTO bib_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bɩ, Yeezuu n deem taan… nyɩ bɔ ʊ y, naa do a ka cir bɩ n zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pakkɩ cibsa biyəə ma, lɛɛzaa Pɩlatɩ bɩ tɩr lɔ kʊ zamaa bɩ lɛ n taa bɩ bɔ, an a ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A n bɔkarɛ lɔ deem ɩ nyɩnta b'ʊ, lɔ wɩsɩ, a tɔ m Barabas. ");
INSERT INTO bib_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pɩlatɩ n laaka da gʊaa cir k'a so kʊ ma b'ʊ bɩ han, a ʊ: «Nka awɔɔ lɛ n taa kʊ mɔɔ n wɔ saa ma, Barabas gɛɛ, Yeezuu kʊ n n'a birm Krista bɩ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bala, Pɩlatɩ a dɔ mɩŋŋa a ʊ Yeezuu nyasʊ ŋ y'a ʊ ŋn'a ka a ʊ jɩmbaa minto. ");
INSERT INTO bib_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pɩlatɩ k'a nɩ nyɩntam dʊdɔkarɛ bɩncɛ ʊ bɩ, a laarɛ nyɔɔ da ma, kʊ n n a hɩ m, n ʊ: «Ɩ bɩ gasʊ gʊaa tɩrga naa do mim ʊ y. Bala, gunuu ʊ bɩ, mɔɔ fɩr yɩ nɩnnarɛ nɔ ʊ a minto.» ");
INSERT INTO bib_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wosocɛmannɩbənno jɩtannɔ wɔɔ kan gʊɔɔgusinno wɔɔ k'ɩ gʊaa cir bɩ nyʊnnyɔɔm, kʊ ŋ nɩ Barabas bɔrɛ yɛ, kʊ ŋ nɩ Yeezuu garɛ yɛ. ");
INSERT INTO bib_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Lɛɛzaa Pɩlatɩ bɩ n a ya, an ŋ lar, a ʊ: «Ŋ gʊaa hɩɩya bɩ barla bɩ, kara awɔɔ lɛ n taa kʊ m bɔ m a ka a ʊ?» Ŋ n a hɩ, ŋ ʊ: «Barabas.» ");
INSERT INTO bib_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pɩlatɩ n laaka da ŋ han, a ʊ: «Bɩ bɔ mɔɔ n'a bam Yeezuu kʊ n n'a birm Krista bɩ nɩ?» Ŋ haay n a nyɩ bɔ ʊ, ŋ ʊ: «A wɔ gɔdarkʊra ma!» ");
INSERT INTO bib_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pɩlatɩ n laaka da, a ʊ: «Mimbʊnyaa kara a a ba?» Ŋ n zee da kan paŋŋa kɩ, ŋ ʊ: «A wɔ gɔdarkʊra ma!» ");
INSERT INTO bib_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pɩlatɩ k'a n'a yɩrɛ, a ʊ, awɔɔ b'a dam mim bɩ bankarɛ ma bɩ, bɩ zamaa bɩ y'a ŋʊam k'a lɛɛ zɛ kʊ ma bɩ, a hi kusi, an a wɔ hir m zamaa bɩ lɛɛ, an a hɩ, a ʊ: «Mɔɔ ba gʊaa naa do zɛrɛ barla y, awɔɔ mim m!» ");
INSERT INTO bib_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Zamaa bɩ haay n a nyɩ bɔ ʊ: «K'a zɛrɛ mim n wɔɔ yɩ, kan ʊ nyɩnɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","A m naa do, Pɩlatɩ n Barabas bɔ, an a ka ŋnɩ Yeezuu zɛ madɩr m, an a ka kʊ n n a wɔ gɔdarkʊra ma. ");
INSERT INTO bib_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pɩlatɩ sʊrdaarɔ wɔɔ n ta Yeezuu m lɛɛzaa bɩ har ʊ b'ʊ, sʊrdaarɔ wɔɔ haay n a so kʊ ma ŋnɩ bɩr Yeezuu ma, ");
INSERT INTO bib_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ŋn'a huuro bɔ ma, ŋnɩ zaba piinə du ma, ");
INSERT INTO bib_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ŋnɩ laa waa ŋn'a ku a mim ma, ŋ ʊ, cinno firgə m, ŋnɩ bənkə da a bɩsɩ wɔ ʊ, ŋnɩ kukurə zɛ a taa ŋn'ɩ yaa wʊm ma, ŋn'a hɩrɛ, ŋ ʊ: «Wɔɔ ɩ yaa darɛ ɩbɩɩ m zɩɩfʊrɔ cir!» ");
INSERT INTO bib_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ŋ n'ɩ lihi dɩndam ma, ŋn'ɩ bənkə bɩ sarɛ ŋn'a zɛm nɩ a mim ma. ");
INSERT INTO bib_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kʊ ŋ yaa wʊ ma ŋn'a nya bɩ, ŋ zaba bɩ bɔ ma, ŋn'a huuro wɔɔ du ma, ŋn'a hʊr m k'a yaa wɔ gɔdarkʊra ma. ");
INSERT INTO bib_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bɔ kʊ ŋ y'a ʊ kʊ b'ʊ bɩ, ŋ Sirɛnnɩ gʊaa kʊ n n'a birm Sɩmɔɔn bɩ zɛ ʊ, sʊrdaarɔ wɔɔ n paŋŋa ba ma, an Yeezuu gɔdarkʊra bɩ busu. ");
INSERT INTO bib_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ŋ n lee ku lɛɛ kʊ ŋ n'a birm Golgotaa b'ʊ, a jɩ ʊ k'a hɩ a ʊ, ‹Minkorgo bɩncɛ.› ");
INSERT INTO bib_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ŋ n dɩvɛn war kʊ ma kan hɔ hɛɛnr kɩ, ŋn'a ka ʊ, k'an a mi. K'a da a lɛ ma bɩ, a n a ŋʊa an a mi y. ");
INSERT INTO bib_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ŋ n a wɔ gɔdarkʊra ma, ŋnɩ pʊɛɛga da a huuro wɔɔ ma ŋnɩ ŋ jir. ");
INSERT INTO bib_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ŋ n a gaa, ŋnɩ nyɩnta b'ʊ, ŋn'ɩ dɔm ma. ");
INSERT INTO bib_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ŋ n Yeezuu zɛ bɩ jɩ gʊrsɩra ba warga ma, Yeezuu mim la gɔdarkʊra bɩ ma, ŋ ʊ: ‹Yeezuu m naa, zɩɩfʊrɔ cir m.› ");
INSERT INTO bib_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ŋ konno wɔ hɩɩya gɔdarkʊra ma Yeezuu jɩr ʊ, deem a bɩsɩ, deem a jɩsa. ");
INSERT INTO bib_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Gʊɔɔ kʊ ŋ nɩ cenim b'ʊ rɔ wɔɔ n'a mim zukə zɛrɛ, ŋn'a sʊnsɔ wʊrɛ. ");
INSERT INTO bib_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ŋ n'a hɩm Yeezuu m, ŋ ʊ: «Ɩbɩɩ k'ɩ n'ɩ dam ma, ɩ Wosocɛ bɩ wurgə, ɩ ya, ɩ dɔ dɔmɩm kaakʊ nɔ ʊ bɩ, ɩ bʊmbɔ ɩ zim kʊ Woso Nyɩ n'ɩbɩɩ m, k'ɩ zer gɔdarkʊra bɩ ma!» ");
INSERT INTO bib_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wosocɛmannɩbənno jɩtannɔ wɔɔ kan wosocikarɩnsaambɔɔ wɔɔ kɩ, gʊɔɔgusinno wɔɔ kɩ ɩ yaa wʊm ma sɔ, ŋn'a hɩrɛ, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«A gʊɔɔ vantɔɔ bʊmbɔ, b'a b'a dam ma, an a mɩŋŋa bʊmbɔ y. Kʊ Israyɛl cir nɩ, k'an zer gɔdarkʊra bɩ ra kɛɛrɛ, k'ʊ sɩra ka ʊ. ");
INSERT INTO bib_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A sɩra ka Woso ʊ, an a hɩ a ʊ, Woso Nyɩ n'a mɩ, kɛɛrɛ bɩ, kʊ Woso y'a ŋʊarɛ, k'a n a yɔ wa.» ");
INSERT INTO bib_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Konno kʊ ŋ yɩ ŋ wɔ gɔdarkʊra ma a jɩr ʊ rɔ wɔɔ y'a sʊnsɔ wʊm sɔ. ");
INSERT INTO bib_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sinsebir k'a da bɩ, monsigə gʊta zɛ tara burə ʊ, an ta an wakatɩ kaakʊ ku yirbəəre m. ");
INSERT INTO bib_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yirbəə wakatɩ kaakʊ zeezi bɩ, Yeezuu zee gʊta da, a ʊ: «Eloyii, Eloyii, lama sabaktaani?» A lɛ taa k'a hɩ, a ʊ: «Mɔɔ Woso, mɔɔ Woso, bɔ m, ɩ ɩ bɔ mɔɔ ʊ?» ");
INSERT INTO bib_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Gʊɔɔ gɔsɩnnɔ kʊ ŋ nyɩnta b'ʊ rɔ wɔɔ naa ma, ŋn'a hɩrɛ, ŋ ʊ: «A ɩ *Elii birm!» ");
INSERT INTO bib_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ŋ gʊaa deem n bra si, an aa hɔ mafʊ-mafʊda sa, an a nyɔɔ hɔ hɛɛnr ma an a da bənkə ma, an a ka Yeezuu ʊ k'an a mi. ");
INSERT INTO bib_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bɩ, a muno wɔɔ y'a hɩrɛ, ŋ ʊ: «Jɩm cɩna, k'ʊ dɩga a Elii zɛm b'a bʊmbɔ gɛ?» ");
INSERT INTO bib_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yeezuu n a ya, an zee gʊta da, an ga. ");
INSERT INTO bib_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lɛɛm bɩ, Wosocɛ bɩ pɛɛra bɩ n zɛ kumbir, an a sa mim ʊ an b'a zɛ tara ma. Tara n nyiŋŋə, ciro n wunwu, ");
INSERT INTO bib_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","gəənoyaarɔ n a gʊngʊ. Wosogʊɔɔ kʊ ŋ gɩnga rɔ wɔɔ gɔsɩnnɔ n a mɩm bʊmbɔ ʊ gʊta. ");
INSERT INTO bib_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ŋ n bɔ yaarɔ wɔɔ ʊ, Yeezuu k'a b'a mɩm bɔ ʊ bɩ hinni ʊ, ŋnɩ gasʊ Zerizalɛm ʊ, kʊ mɩŋŋa b'ʊ, gʊɔɔ gʊta nɩ ŋ yɩ. ");
INSERT INTO bib_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sʊrdaa zɔrɔ cir, kan sʊrdaarɔ kʊ ŋ nɩ dɔm Yeezuu ma rɔ wɔɔ tara bɩ nyiŋŋəre yɩ, kan hɔ k'a nyɩnta an ba haay bɩ kɩ, ŋ da n bɔ ʊ gʊta, ŋn'a hɩ, ŋ ʊ: «Sɩra m, Woso Nyɩ m paan…» ");
INSERT INTO bib_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Lannɔ nyɩnta b'ʊ guta, ŋn'a to laatʊ ŋn'ɩ dɩgam, zu ŋ y'a ʊ Yeezuu jɛ ʊ Galilee ʊ tee…, ŋn'a dam han. ");
INSERT INTO bib_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Magdalaa Maarii nyɩnta ŋ barla, kan Maarii, Zakkɩ kan Zozɛf kɩ da bɩ, kan Zebedee nyɩnɔ da kɩ. ");
INSERT INTO bib_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Woso lɛ k'a b'a zo bɩ, Arimatee kʊ gʊaa arzakazaa deem k'a tɔ m Zozɛf bʊr, Yeezuu karɩndanyɩ deem m sɔ. ");
INSERT INTO bib_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A n ta Pɩlatɩ zi, an aa Yeezuu gər bɩ yɛ han. Pɩlatɩ n lɛ ka, n n a ka ʊ. ");
INSERT INTO bib_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","A n gər bɩ sa, an pɛɛra fɛʊda burgu ma, ");
INSERT INTO bib_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","an a da a mɩŋŋa yaa daa k'a hɔ ci ʊ b'ʊ, an jaa gʊta gərgu an a ta rɛ, an a hʊr. ");
INSERT INTO bib_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magdalaa kʊ Maarii kan Maarii vanta bɩ k'ɩ nyɩntam b'ʊ, ŋn'a meer nya yaa bɩ rɛ. ");
INSERT INTO bib_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","*Sabaa bankarɛ hinni k'a cem dɔ n mɛ bɩ, wosocɛmannɩbənno jɩtannɔ wɔɔ kan farizɛɛnrɔ wɔɔ kɩ zu kʊ ʊ ŋnɩ ta Pɩlatɩ zi. ");
INSERT INTO bib_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ŋ n a hɩ, ŋ ʊ: «Wɔɔ lɛɛzaa, ŋʊaarzaa naa do k'a nyɩnta an a hɩ, a ʊ: Dɔmɩm kaakʊ hinni ʊ, mɔɔ yɩ m mɩm bɔŋ ʊ bɩ, a tɔ ɩ wɔɔ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Lɛ ka kʊ n n dɔ yaa bɩ ma, k'an ta an dɔmɩm kaakʊ bɩ ku, k'a karɩndanyɩnɔ wɔɔ b'a da ma, ŋnɩ bʊr, ŋn'a gər bɩ kʊna, ŋn'a hɩ zamaa bɩ m, ŋ ʊ: A a mɩm bɔ ʊ gəəno bire ʊ y. Kʊ m bɛɛ m, ŋʊaar naa do lɛ dam lɛɛkarɛ hɔ bɩ m.» ");
INSERT INTO bib_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pɩlatɩ n a hɩ ŋ nɩ, a ʊ: «Awɔɔ ɩ sʊrdaarɔ m, k'a ta a ka ŋnɩ dɔ yaa bɩ ma amba awɔɔ a da ma bɩ m.» ");
INSERT INTO bib_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ŋ n a hʊr, ŋnɩ ta, ŋn'aa jaa k'a ta yaa bɩ lɛ bɩ kʊsɩ, ŋnɩ gʊɔɔ da a dɔma ʊ. ");
INSERT INTO bib_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabaa hinni bɩ k'a cem bɩ, hatʊ hinni ʊ wutigʊta m bɩ, Magdalaa Maarii kan Maarii deem bɩ kɩ bʊr, ŋnɩ bɩ dɩga yaa bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tara n nyiŋŋə lɛɛm, Zuuba malɛɛka n a to brama an zer, an bɩ jaa bɩ gərgu an a gʊ yaa bɩ rɛ, an nyɩnta ra. ");
INSERT INTO bib_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A mɛ n bɔ kʊ ʊ kan brama nyakɩ kɩ, a huu bɩ fu am lajaa hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sʊrdaarɔ wɔɔ da n bɔ ʊ, ŋ mɛ nɩ hinkəm, ŋn'a ba ɩ ʊ, gɩnga ŋ y'a ʊ. ");
INSERT INTO bib_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bɩ, malɛɛka bɩ meer ba kan lannɔ wɔɔ kɩ, a ʊ: «A da bɩ bɔ ʊ y. Mɔɔ dɔ mɔɔ ʊ Yeezuu kʊ n y'a wɔ gɔdarkʊra ma bɩ awɔɔ n'a kam ma. ");
INSERT INTO bib_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A ba naa ʊ dɔ y, a a mɩm bɔ ʊ amba a lɛɛ ka an a hɩ bɩ m, k'a bʊr a dɩga lɛɛ k'a nɩ wʊtaŋ ʊ hɔɔ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bɩ, k'a ta zɔɔ a yaa hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: A a mɩm bɔ ʊ, bɩ, a ɩ lɛɛkarɛ awɔɔ lɛɛ Galilee ʊ, lɛɛ bɩ do awɔɔ naa yɩ ʊ, naa do mɔɔ kʊ m a hɩ awɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Lannɔ wɔɔ a hʊr yaa bɩ ra zɔɔ-zɔɔ, kan dabɔʊ kɩ heernyɔɔ gʊta kɩ, ŋn'a si, k'a yaa mim bɩ hɩ karɩndanyɩnɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bɩ, Yeezuu bʊr an ŋ zɛ ʊ, an a hɩ ŋ nɩ, a ʊ: «Mɔɔ ɩ yaa darɛ awɔɔ m.» Lannɔ wɔɔ n a zɔ ma ŋn'a gannɔ nyɩnnyasʊ, ŋnɩ kukurə zɛ a taa. ");
INSERT INTO bib_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeezuu n a hɩ ŋ nɩ, a ʊ: «A da bɩ bɔ ʊ y. K'a ta a yaa hɩ mɔɔ danyɩnɔ wɔɔ m, ŋnɩ ta Galilee ʊ, ŋ mɔɔ yɩm b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kʊ ŋn'ɩ tam bɩ, sʊrdaarɔ gɔsɩnnɔ bʊr kʊnɔ ʊ b'ʊ, ŋnɩ bɩ hɔ k'a ba haay bɩ sa, ŋn'a dɩnda wosocɛmannɩbənno jɩtannɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Brɔɔ n a so kʊ ma, kan gʊɔɔgusinno wɔɔ kɩ, ŋnɩ kʊ ma, ŋnɩ busoo ka sʊrdaarɔ wɔɔ ʊ gʊta. ");
INSERT INTO bib_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ŋ nɩ lɛ ka ŋ ʊ, ŋ ʊ: «K'a hɩ a ʊ, a karɩndanyɩnɔ ɩ bʊr gunuu ʊ, ŋnɩ b'a gər bɩ kʊna, bɩ ma bɩ, wɔɔ hinceem ba. ");
INSERT INTO bib_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bɩ, kʊ lɛɛzaa b'a ma, wɔɔ y'a dɩndarɛ dɔm, mim b'a nɔrɛ awɔɔ ma y.» ");
INSERT INTO bib_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sʊrdaarɔ wɔɔ n busoo bɩ si, ŋnɩ hɔ kʊ ŋ y'a dɩnda ŋ nɩ bɩ ba, mim naa do n bɔ lɛɛ haay ʊ zɩɩfʊrɔ wɔɔ bire ʊ, an ta an lee ku her dɔmɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Karɩndanyɩnɔ bueeredeem nɔ wɔɔ n a hʊr, ŋnɩ ta Galilee ʊ, ci kʊ Yeezuu a hɩ ŋ nɩ a ʊ, ŋnɩ ta ra bɩ burə ʊ. ");
INSERT INTO bib_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kʊ ŋ yaa yɩ bɩ, ŋnɩ kukurə zɛ, bɩ gɔsɩnnɔ sɩnsɩm ka. ");
INSERT INTO bib_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yeezuu n a zɔ ŋ ma, an a hɩ ŋ nɩ, a ʊ: «N paŋŋa do haay ka mɔɔ ʊ, brama kan tara kɩ burə ʊ. ");
INSERT INTO bib_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bɩ, k'a ta doro haay zi, a yaa gʊɔɔ wɔɔ ba mɔɔ karɩndanyɩnɔ, a batɛm ka ŋ ʊ, Zɩ kan Nyɩ kɩ Sɛnt-Ɛspri kɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","A hɔ kʊ mɔɔ dɩnda awɔɔ m haay bɩ dɩnda ŋ nɩ, kʊ ŋ nɩ zu ʊ. Bɩ mɔɔ ba n bɩr kan awɔɔ kɩ dɔmɩm haay nɔ ʊ, k'an ta an durnya nyarɛ ku.»");
INSERT INTO bib_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Lemim nyɩnta k'a nɩ Woso Nyɩ Yeezuu Krista bɩ mim dɩndam bɩ n naa do. ");
INSERT INTO bib_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mim bɩ, a sɩŋŋɩda a ba, amba wosolɛsinnɩsorazaa Ezayii a gʊrsɩra ba biisi bɩ m, a ʊ: Mɔɔ nɩ m zibəəzaa nyɔɔrɛ ɩbɩɩ lɛɛ, k'an b'ɩ zaa banka. ");
INSERT INTO bib_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","A mɩŋŋa leer nɩ bɔm poohɔɔn ʊ, an n'a hɩrɛ, a ʊ: k'a Zuuba zaa banka, k'a a zaarɔ kʊ ŋ y'a tʊntɔ rɔ wɔɔ banka, k'a ŋ zɛ kʊ ŋ n yɩ tɩrga. ");
INSERT INTO bib_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kɛɛrɛ bɩ, Zaan a hɩnka poohɔɔn ʊ b'ʊ, an nɩ pa dam, a ʊ: «K'a a bɔ a taam, k'a batɛm si, k'a a mimbʊnyaarɔ sugur yɩ.» ");
INSERT INTO bib_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Zidee kʊ zannɔ kan Zerizalɛm kʊ zannɔ kɩ bʊr Zaan zi, ŋnɩ batɛm si Zʊrdɛn kɔ ʊ, ŋn'a mimbʊnyaarɔ hɩrɛ. ");
INSERT INTO bib_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zaan bɩ, yoonde ka huu a du a ma, an kʊmbar so a ʊ. Bɩsɩnɔ kan zɔɔn kɩ a n'a bɩrɛ. ");
INSERT INTO bib_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A hɔdɩndarɛ nɔ ʊ bɩ, a y'a hɩm gʊɔɔ wɔɔ m, a ʊ: «Gʊaa nɩ mɔɔ jɛ ʊ, an nɩ zɛm, bɩ, a zaa paŋŋa cem mɔɔ han. Mɔɔ n m ga m, m sʊnta a taa, m a kʊsɔrɔ bar tɔkkɛ hʊnhʊr y. ");
INSERT INTO bib_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mɔɔ batɛm ka awɔɔ ʊ hi nɔ ʊ, bɩ, a mɩŋŋa zɛm bɩ batɛm ka awɔɔ ʊ *Sɛnt-Ɛspri m.» ");
INSERT INTO bib_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Dɔmɩm bɩ do ʊ bɩ, Yeezuu a to Nazarɛtɩ ʊ, Galilee kʊ nɔ ʊ, an bʊr Zʊrdɛn kɔ ʊ k'a bɩ batɛm si Zaan zi. ");
INSERT INTO bib_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bɩ, k'a bɩ batɛm si an a nya, an nɩ bɔm hi b'ʊ bɩ, brama a gʊ, Sɛnt-Ɛspri n zer a mim ʊ, am cirpʊʊrɛ hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bɩ leer a to mim ʊ, an n'a hɩrɛ, a ʊ: «Mɔɔ Nyɩ kʊ mɔɔ ŋʊa bɩ n'ɩbɩɩ m, mɔɔ ɩbɩɩ ŋʊa kan m heer kɩ haay.» ");
INSERT INTO bib_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Lɛɛm bɩ, Sɛnt-Ɛspri a ka an ta poohɔɔn ʊ. ");
INSERT INTO bib_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A gɔɔta b'ʊ dɔmɩm busi, Sʊtaana n'a gɩngam ma. A mɩsɩrbaa ba a nawʊm poohɔɔ barla, bɩ malɛɛkarɔ bʊr k'a b'a da han. ");
INSERT INTO bib_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","N Zaan nyasʊ, n n a du, Yeezuu n bɔkarɛ an bʊr Galilee ʊ, ");
INSERT INTO bib_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","an nɩ Woso lemim nyɩnta pa dam gʊɔɔ m, a ʊ: «Dɔmɩm b'a ku, Woso cirbəə b'a zɔ. K'a bɔ a taam, k'a lemim nyɩnta bɩ si.» ");
INSERT INTO bib_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kʊ Yeezuu nɩ tam Galilee higʊta lɛ ra bɩ, a zɔbənno yɩ hɩɩya, Sɩmɔɔn kan a danzaa Andɩr kɩ, ŋn'ɩ zɔ bam, ŋn'ɩ zaŋŋa zom higʊta b'ʊ, bala, zɔbənno m. ");
INSERT INTO bib_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a bʊr a zu mɔɔ ʊ, mɔɔ y'awɔɔ bam gʊɔɔkamazannɔ!» ");
INSERT INTO bib_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lɛɛm bɩ, ŋ zaŋŋarɔ wɔɔ to, ŋn'ɩ zum kʊ ʊ kan kɩ. ");
INSERT INTO bib_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","K'a ta lɛɛ poore bɩ, a Zebedee nyɩnɔ yɩ, Zakkɩ kan a danzaa Zaan kɩ, ŋn'ɩ zaŋŋarɔ bankarɛ a kɔɔlʊʊ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yeezuu n ŋ bir lɛɛm, ŋn'a zɩ Zebedee to kɔɔlʊʊ bɩ nɔ ʊ kan zibənno wɔɔ kɩ, ŋn'a hʊr, ŋn'ɩ zum kʊ ʊ kan kɩ. ");
INSERT INTO bib_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ŋ gasʊ Kapɛrnawum kʊ nɔ ʊ, *sabaa hinni ʊ, Yeezuu n gasʊ zɩɩfʊrɔ sokʊmacɛ ʊ, an hɔ dɩnda. ");
INSERT INTO bib_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Gʊɔɔ wɔɔ n zɛ kədə a hɔdɩndarɛ bɩ minto. Bala Woso paŋŋa an nɩ hɔ bɩ dɩndam nɩ, a bɩ hɔdeem kan wosocikarɩnsaambɔɔ wɔɔ hɔ kɩ y. ");
INSERT INTO bib_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Dɔmɩm bɩ do ʊ bɩ, gʊaa kʊ zinəro n ta m nɩ ŋ sokʊmacɛ b'ʊ, an nɩ zee darɛ, an n'a hɩrɛ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Bɔ ɩbɩɩ lɛ n taa k'ɩ ba wɔɔ nɩ, Nazarɛtɩ Yeezuu? Bʊr ɩbɩɩ ʊ k'ɩ bɩ wɔɔ zibəə zar gɛ? Kʊ nka n'ɩbɩɩ m, mɔɔ dɔ: Woso gʊaa mɩŋŋa n'ɩbɩɩ m.» ");
INSERT INTO bib_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yeezuu n meer ba ma, a ʊ: «Ɩ tʊr ka, k'ɩ bɔ gʊaa bɩ mɛ ʊ!» ");
INSERT INTO bib_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Zinə bɩ n gʊaa bɩ hinkə kan paŋŋa kɩ, an bɔ a mɛ ʊ kan zee kɩ. ");
INSERT INTO bib_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Gʊɔɔ wɔɔ haay zɛ kədə, ŋn'ɩ laaka dɩndam kʊ han, ŋ ʊ: «Bɔ m naa? Hɔdɩndarɛ daa kan paŋŋa gʊta kɩ bɩ ba n nɩ! A m lɛ da bɩ, Yeezuu ɩ həən sim zinəro wɔɔ ma, ŋn'a lɛ sire.» ");
INSERT INTO bib_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yeezuu tɔ bɔ lɛɛ haay ʊ, Galilee kʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kʊ ŋ bɔ sokʊmacɛ ʊ lɛɛm bɩ, ŋ ta Sɩmɔɔn kan Andɩr kɩ har ʊ, kan Zakkɩ kɩ Zaan kɩ. ");
INSERT INTO bib_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bɩ ma bɩ, Sɩmɔɔn dində ɩ wʊtam kan mɛmarɛ kɩ. Lɛɛm bɩ, n yaabazaa bɩ mim hɩ Yeezuu m. ");
INSERT INTO bib_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yeezuu a zɔ, an a wɔ nyasʊ, an a ka an wuti. Mɛmarɛ bɩ n bɔ a mɛ ʊ, an wuti, an nyasʊ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yirbəəre m bɩ, woso lɛzore dɔmɩm ʊ bɩ, n bʊr yaabazannɔ m kan hɔɔzannɔ kɩ m haay Yeezuu zi. ");
INSERT INTO bib_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kʊ bɩ zannɔ haay a so kʊ ma har bɩ lɛ ma. ");
INSERT INTO bib_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A yaabazannɔ kʊ ŋ nɩ cicir bam yaaba do haay m nɔ ʊ rɔ wɔɔ waa gʊta, an la zinəro ra gʊta gʊɔɔ mɛ ʊ. Yeezuu n zinəro wɔɔ to ŋn'ɩ meer barɛ y, kʊ ŋ y'a dɔ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Dɔgta mɩŋŋa m, Yeezuu wuti, an bɔ, an ta poohɔɔn ʊ, an nɩ yaa dam b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sɩmɔɔn wuti kan a muno kɩ, ŋn'a dɩndaŋ ʊ, ");
INSERT INTO bib_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ŋn'aa yɩ, ŋn'a hɩ m, ŋ ʊ: «Gʊɔɔ wɔɔ haay y'a karɛ ɩbɩɩ ma!» ");
INSERT INTO bib_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Bɩ, Yeezuu a nyɩ bɔ ʊ, a ʊ: «Ʊ ta kʊrɔ kʊ ŋ nɩ lezima rɔ wɔɔ ʊ sɔ, kʊ m aa Woso lemim nyɩnta dɩnda ŋ nɩ. Bala, bʊr mɔɔ ʊ bɩ minto.» ");
INSERT INTO bib_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A a da Galilee kʊrɔ wɔɔ zi haay, an nɩ hɔ dɩndarɛ ŋ nɩ ŋ sokʊmacɛrɔ wɔɔ ʊ, an nɩ lam zinəro ra. ");
INSERT INTO bib_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kusimə deem n b'a zɔ Yeezuu ma, an sʊnta, an a zuutə a taa, an n'a yɛm han, a ʊ: «K'ɩbɩɩ lɛ taa, ɩbɩɩ ɩ da ma, ɩ mɔɔ waa.» ");
INSERT INTO bib_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yeezuu a cicir zɛ, an a wɔ hʊr, an a da ma, an a hɩ m, a ʊ: «Mɔɔ lɛ taa ma k'ɩ laafɩɩ yɩ.» ");
INSERT INTO bib_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lɛɛm bɩ, yaaba bɩ bɔ kusimə bɩ mɛ ʊ, an a ba mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bɩ jɛ ʊ bɩ, Yeezuu a nyɔɔ, an lɛ ka ʊ, ");
INSERT INTO bib_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","an n'a hɩrɛ, a ʊ: «Dundo ɩ zi, ɩ b'a ka ɩ hɩ gɔsɩ nɩ y. Ta ɩ yaa ɩ hɩnka wosocɛmannɩbər bɩ m, *hubɔrɛ mannɩ kʊ Moyiisi lɛ ka awɔɔ ʊ k'a ba bɩ, k'ɩ bɩ ba, kʊ gʊaa biyəə n a dɔ, a ʊ, ɩbɩɩ laafɩɩ yɩ.» ");
INSERT INTO bib_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bɩ, gʊaa bɩ bɔ, an a hʊr, an a sɩŋŋɩda sa, an nɩ mim bɩ dɩndam gʊɔɔ m lɛɛ haay ʊ. Naa do minto ma, Yeezuu b'a dam ma, an a hɩnka, an gasʊ kʊnɔ ʊ y. Gɔɔta a tɩr a ʊ bɔlɛɛmarɔ ʊ. Bɩ, gʊɔɔ a to lɛɛ haay ʊ, ŋn'ɩ zɛm Yeezuu zi. ");
INSERT INTO bib_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Dɔmɩnnɔ kʊ ŋ cem nɔ wɔɔ nɔ ʊ, Yeezuu a wusigə, an bʊr Kapɛrnawum kʊnɔ ʊ, bɩ gʊɔɔ a ma ŋ ʊ, a lee ku an nɩ har ʊ. ");
INSERT INTO bib_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Gʊɔɔ cir gʊta bʊr, ŋnɩ b'a so kʊ ma b'ʊ, lɛ ba b'ʊ y, baa cɛlɛ ma bɩ, lɛ ba ʊ sɔ y. Yeezuu nɩ Woso lemim dɩndam gʊɔɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Gʊɔɔ gɔsɩnnɔ bʊr zi mɛgarɛzaa m, ŋn'a busu gʊaa si. ");
INSERT INTO bib_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kʊ ŋ n a da ma, ŋn'ɩ tam nɩ Yeezuu zi bɩ, zamaa bɩ minto m, ŋ n cɛ mim bɩ hɔn ra, bɩncɛ kʊ Yeezuu n ta ʊ b'ʊ, ŋnɩ mɛgarɛzaa bɩ busu kan a wʊtarahɔ bɩ kɩ, ŋn'a zer cɛ bɩ yaa bɩ m. ");
INSERT INTO bib_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kʊ Yeezuu ŋ sɩrakarɛ bɩ yɩ bɩ, a a hɩ mɛgarɛzaa bɩ m, a ʊ: «M nyɩnnɩ, ɩ ɩ mimbʊnyaarɔ wɔɔ sugur yɩ!» ");
INSERT INTO bib_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wosocikarɩnsaambɔɔ gɔsɩnnɔ nɩ b'ʊ, ŋn'ɩ nyɩntam, ŋn'a hɔɔn darɛ a heer ʊ, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Bɔ m, gʊaa naa do nɩ meer naa do barɛ? Woso sʊnsɔ a n'a wʊm! Nka y'a da ma, an gʊaa mimbʊnyaarɔ sugur ka ʊ, kʊ Woso deem bɛɛ?» ");
INSERT INTO bib_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Zɔɔ-zɔɔ bala, hɔ kʊ ŋ n'a hɔɔn dam ma a heer ʊ bɩ, Yeezuu a dɔ a zim, an ŋ lar, a ʊ: «Bɔ minto m awɔɔ n'a hɔɔn darɛ ncɩnaaʊ? ");
INSERT INTO bib_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kara m naanaa? Mɔɔ n b'a hɩm mɛgarɛzaa bɩ m, mɔɔ ʊ: ɩ ɩ mimbʊnyaarɔ sugur yɩ bɩ m gɛɛ, ɩ wuti, ɩ ɩ wʊtarahɔ bɩ gʊr, ɩ ta bɩ nɩ? ");
INSERT INTO bib_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bɩ, awɔɔ y'a dɔrɛ, a ʊ: Gʊaanyɩ b'a da ma, an gʊɔɔ mimbʊnyaarɔ sugur ka ŋ ʊ, tara burə ʊ naa ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","A n a hɩ mɛgarɛzaa bɩ m, a ʊ: «Ɩbɩɩ, mɔɔ n'a hɩrɛ ɩbɩɩ m, ɩ wuti, ɩ ɩ wʊtarahɔ bɩ gʊr, ɩ doo ɩ har ʊ!» ");
INSERT INTO bib_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lɛɛm bɩ, a wuti, an a wʊtarahɔ bɩ gʊr, an bɔ m, gʊaa biyəə mɩm m. Gʊɔɔ wɔɔ n zɛ kədə, ŋn'a lɛ bɔ Woso ʊ, ŋ ʊ: «Wɔɔ n mim naa do lɔɔ yɩ deem y.» ");
INSERT INTO bib_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yeezuu a ya, an ta Galilee higʊta lɛ ra. Gʊɔɔ wɔɔ haay bʊr zi, an nɩ Woso lemim dɩndarɛ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","K'a nɩ cenim bɩ, a Alfee nyɩnnɩ Levii yɩ. A n nɩ nyɩntarɛ a yawʊrsire bɩncɛ ʊ b'ʊ. Yeezuu n a hɩ m, a ʊ: «Zu mɔɔ ʊ!» Levii bɩ n wuti, an nɩ zum kʊ ʊ kan kɩ. ");
INSERT INTO bib_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kʊ Yeezuu nɩ nyɩntam Levii har ʊ b'ʊ k'a hɔ bɩ bɩ, yawʊrsinno kan mimbʊnyaabənno kɩ gʊta nyɩnta kan kɩ, kan a karɩndanyɩnɔ wɔɔ kɩ. Bala, gʊɔɔ gʊta zu kʊ ʊ kan Yeezuu kɩ. ");
INSERT INTO bib_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Zɛkʊrazannɔ n ta ʊ, ŋn'ɩ ŋ birm farizɛɛnrɔ. Kʊ farizɛɛnrɔ wɔɔ kan wosocikarɩnsaambɔɔ wɔɔ kɩ a yɩ, an nɩ hɔbɩrɛ bɩm kan yawʊrsinno wɔɔ kɩ, mimbʊnyaabənno wɔɔ kɩ bɩ, ŋ y'a hɩ a karɩndanyɩnɔ wɔɔ m, ŋ ʊ: «A lɔ, an nɩ hɔbɩrɛ bɩm kan yawʊrsinno wɔɔ kɩ, mimbʊnyaabənno wɔɔ kɩ?» ");
INSERT INTO bib_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yeezuu k'a mim bɩ ma bɩ, a a hɩ ŋ nɩ, a ʊ: «Laafɩɩzannɔ lɛ baa lɔɔtɔr ma y, bɩ yaabazannɔ lɛ n taa lɔɔtɔr ma. Mɔɔ n bʊr kʊ m bɩ gʊɔɔ mɩŋŋɔɔ bir y, bʊr mɔɔ ʊ, kʊ m bɩ mimbʊnyaabənno bir.» ");
INSERT INTO bib_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Dɔmɩm bɩ do ʊ bɩ, Zaan karɩndanyɩnɔ kan farizɛɛnrɔ karɩndanyɩnɔ kɩ y'a lɛ kʊsɩm. Ŋ bʊr, ŋnɩ bɩ Yeezuu lar, ŋ ʊ: «Bɔ minto nɩ, Zaan karɩndanyɩnɔ wɔɔ kan farizɛɛnrɔ hɔɔ wɔɔ kɩ n'a lɛ kʊsɩm, b'ɩbɩɩ hɔɔ wɔɔ bɩr a lɛ kʊsɩrɛ?» ");
INSERT INTO bib_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yeezuu n a nyɩ bɔ ŋ nʊ, hɔbɔkʊrɛnoom darɛ m, a ʊ: «Kʊ gʊaa ɩ lʊsarɛ cibsa barɛ, lʊ bɩ zim bɩ n gɔɔta, an nɩ gʊɔɔ wɔɔ bire ʊ, ŋ y'a lɛ kʊsɩm na? Kʊ lʊ bɩ zim bɩ nɩ b'ʊ bɩ, ŋ b'a dam ma ŋn'a lɛ kʊsɩ y. ");
INSERT INTO bib_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Dɔmɩnnɔ niŋŋoo zɛm bɩ nyɩnta ʊ, kʊ n bɩ lʊ bɩ zim bɩ gʊ ŋ ma, ŋ y'a lɛ kʊsɩm dɔmɩm bɩ do ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","A n a ya, an a hɩ, a ʊ: «Gʊaa ba ʊ, an nɩ pɛɛra daa kər sam, an a sɩnsar kan huu gusire kɩ y. Pɛɛra daa kər bɩ n nɩ huu gusire hɔ bɩ gaam, an n'a kaansʊm, an nɩ cenim biisi han.» ");
INSERT INTO bib_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","A n a ya, an a vanta hɩ ŋ nɩ, a ʊ: «Gʊaa ba ʊ, an nɩ *dɩvɛn daa sam k'a tɔ hibɔɔnrɔ gusinno ʊ y. Kʊ n bɛɛ m, dɩvɛn bɩ hibɔɔnrɔ wɔɔ hɩnhaanm. Dɩvɛn bɩ kan hibɔɔnrɔ wɔɔ kɩ, ŋ y'a zaar bam. Bɩ, k'a dɩvɛn daa tɔ hibɔɔnrɔ daarɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Hindeem ʊ, *sabaa hinni ʊ, Yeezuu bɔ hɔsɩrarɔ ʊ. A karɩndanyɩnɔ wɔɔ kʊ ŋ zaa sa ŋn'ɩ tam bɩ, ŋ y'a sɩŋŋɩda ba, ŋn'ɩ hɔyaa gɔyir yɩnyarm. ");
INSERT INTO bib_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farizɛɛnrɔ wɔɔ n a hɩ ŋ nɩ, ŋ ʊ: «Dɩga, hɔ kʊ ŋ n'a bam sabaa hinni ʊ! A n a ga m, ŋn'a ba a hinni ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mim k'a pakra ba Davɩd m kan a gʊɔɔ kɩ bɩ dɔmɩm ʊ, hɔ niŋŋə k'a a ba, nɔ k'a ŋ nyasʊ bɩ, ");
INSERT INTO bib_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","gasʊ k'a ʊ Wosocɛ ʊ kan a gʊɔɔ wɔɔ kɩ, wosocɛmannɩbər jɩtaarɛ Abɩyataar dɔmɩm ʊ, an bur kʊ ŋ y'a cɩnta Woso m bɩ gʊr, an a bɩ kan a gʊɔɔ wɔɔ kɩ, awɔɔ n a karɩnda ba ra? Bɩ, ŋ n a ga m, ŋn'a bɩ, kʊ wosocɛmannɩbənno wɔɔ bɛɛ m bala y.» ");
INSERT INTO bib_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yeezuu a ya, an a hɩ ŋ nɩ, a ʊ: «Hoonsire dɔmɩm bɩ ba Woso ʊ, gʊaa minto, bɩ, a n gʊaa ba hoonsire dɔmɩm minto y. ");
INSERT INTO bib_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bɩ y'a ka, Gʊaanyɩ bɩ m sabaa hinni bɩ minzaa.» ");
INSERT INTO bib_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sabaa vanta hinni ʊ, Yeezuu a ya, an gasʊ zɩɩfʊrɔ sokʊmacɛ ʊ. B'ʊ bɩ, gʊaa deem n ta ʊ, a wɔ n ga. ");
INSERT INTO bib_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Gʊɔɔ kʊ ŋ bʊr b'ʊ rɔ wɔɔ ɩ dɩgam Yeezuu ma, hɔ k'a n'a bam *sabaa hinni ʊ, k'a gʊaa bɩ waam k'a yɩ. A ka brɔɔ nawʊm ma, k'a mim ka Yeezuu ra, mim naa do jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeezuu n a hɩ wɔgərzaa bɩ m, a ʊ: «Wuti, ɩ bʊr bireyaa ʊ naa ʊ!» ");
INSERT INTO bib_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","B'a a hɩ gʊɔɔ wɔɔ m, a ʊ: «Sabaa hinni ʊ, bɔ barɛ n mɩŋŋa? Zibəə mɩŋŋa barɛ m gɛɛ, zibəə bʊnyaa barɛ nɩ? Gʊaa meeyaa bʊmbɔrɛ m gɛɛ, gʊaa zɛrɛ nɩ?» Bɩ ŋ bɩr a nyɩ bɔŋ ʊ y. ");
INSERT INTO bib_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A ɩ dɩgarɛ ŋ ma a jɩr ʊ kan nɔmaa kɩ, a heer n a zar ŋ heerkarɛ bɩ minto. A n a hɩ gʊaa bɩ m, a ʊ: «Ɩ wɔ bɩ hʊr!» B'a a hʊr, a wɔ bɩ n a banka. ");
INSERT INTO bib_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farizɛɛnrɔ wɔɔ kʊ ŋ bɔ sokʊmacɛ b'ʊ bɩ, ŋ y'a zɛ kʊ ra kan Hɩrɔɔdɩ gʊɔɔ wɔɔ kɩ, ŋn'a hɔɔn dam hɔ k'a n'a bam, k'a Yeezuu ku a zɛ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yeezuu ta kan a karɩndanyɩnɔ wɔɔ kɩ Galilee higʊta lɛ ra. Zamaa gʊta n zu a jɛ ʊ. Zamaa bɩ, a to ŋ y'a ʊ Galilee ʊ, Zidee ʊ, ");
INSERT INTO bib_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Zerizalɛm ʊ, Idumee ʊ, kan Zʊrdɛn kɔ kur zannɔ kɩ, Tiir kʊ kan Sidɔn kʊ zannɔ kɩ. Gʊɔɔ gʊta n bʊr zi, hɔ haay k'a a ba bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ, k'a a zɔ kɔɔlʊʊ bɩ m mɔɔ jɩr ʊ, kʊ zamaa bɩ b'a da ma, ŋn'a so mɔɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yeezuu k'a gʊɔɔ waa gʊta bɩ minto y'a ka, yaabazannɔ wɔɔ haay lɛ n taa k'a lɛɛ ka a a zɔ ma, a a wɔ da ma. ");
INSERT INTO bib_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Zinəro wɔɔ kʊ ŋ y'a yɩ bɩ, ŋ kukurə zɛ, ŋn'ɩ zee dam, ŋ ʊ: «Woso Nyɩ n'ɩbɩɩ m!» ");
INSERT INTO bib_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A həən si ŋ ma kan paŋŋa kɩ, a ʊ, ŋ b'a ka n n'a dɔ y. ");
INSERT INTO bib_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yeezuu der ci ra, an nɩ gʊɔɔ k'a lɛ n taa ŋ ma rɔ wɔɔ birm. Brɔɔ ŋ bʊr zi. ");
INSERT INTO bib_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A n ŋ nyʊkɔ ʊ gʊaa bueerehɩɩya, kʊ ŋ nɩ gɔɔta kan a kɩ, k'a bɩr ŋ nyɔɔm, kʊ ŋ nɩ bɩr Woso lemim nyɩnta bɩ dɩndam, ");
INSERT INTO bib_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kʊ ŋ n paŋŋa yɩ, ŋnɩ wɔ ʊ, ŋnɩ la zinəro ra. ");
INSERT INTO bib_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bueerehɩɩyɔɔ wɔɔ kʊ Yeezuu ŋ bir lɔ wɔɔ ba n nɩ: Sɩmɔɔn kʊ n n'a hɩm ma Pɩyɛɛr ta ʊ, ");
INSERT INTO bib_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedee nyɩ Zakkɩ ta ʊ, kan a danzaa Zaan kɩ. Yeezuu tɔ vanta ka brɔɔ ma, a ʊ: Bʊanɛrgɛs, a lɛ taa k'a hɩ: bramahəənsire nyɩnɔ. ");
INSERT INTO bib_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andɩr ta ʊ sɔ, kan Filipi kɩ, Bartelemii kɩ, Matiyee kɩ, Toma kɩ, kan Alfee nyɩ Zakkɩ kɩ, Tade kɩ, Sɩmɔɔn *Zelɔtɩ kɩ sɔ, ");
INSERT INTO bib_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kan Iskarɩyɔtɩ kʊ gʊaa Zidas, k'a Yeezuu zambʊ zɛ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yeezuu a wusigə, an bʊr har ʊ, zamaa bɩ n a ya, an a so kʊ ma. Bɩ minto nɩ, Yeezuu kan a karɩndanyɩnɔ wɔɔ kɩ ba toore m k'a hɔ bɩ y. ");
INSERT INTO bib_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bɩ k'a danyɩnɔ wɔɔ a ma bɩ, ŋ bʊr, k'a b'a gaa, bala ŋ y'a hɔɔndarɛ, ŋ ʊ: «A mim n'a wusigəm!» ");
INSERT INTO bib_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wosocikarɩnsaambɔɔ kʊ ŋ y'a to Zerizalɛm nɔ ʊ rɔ wɔɔ, ŋ y'a hɩ, ŋ ʊ: «Bɛlzebul nɩ kan kɩ!» Ŋ y'a hɩ sɔ, ŋ ʊ: «Zinəro cir daahan minto y'a ka, an wɔ ʊ, an nɩ lam zinəro ra.» ");
INSERT INTO bib_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yeezuu n ŋ bir, an hɔbɔkʊrɛnoom da ŋ nɩ, a ʊ: «Sʊtaana y'a bam lɔ, an zoo ba kan a mɩŋŋa kɩ? ");
INSERT INTO bib_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kʊ k'a gʊɔɔ bɩr kʊ mam bɩ y'a darɛ. ");
INSERT INTO bib_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kʊ har gʊɔɔ a gʊngʊ, har bɩ do b'a dam ma, an ta lɛɛ y. ");
INSERT INTO bib_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kʊ Sʊtaana bʊr, an nɩ yar bam kan a mɩŋŋa kɩ, kʊ gʊngʊrɛ ta ʊ, a b'a dam ma, an jɩm mim ʊ dʊntɔ y, bɩ, a cirbəə bɩ nyam. ");
INSERT INTO bib_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Gʊaa ba ʊ, an b'a dam ma, an gasʊ gʊaa paŋŋazaa har ʊ, k'a mɔrlɔ gʊr, k'a n ser ka, an bʊr la an a sʊr y. K'a sʊr an a nya, b'a bɔkarɛ an gasʊ, an mɔrlɔ wɔɔ gʊr. ");
INSERT INTO bib_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Sɩra mɔɔ n'a hɩrɛ awɔɔ m: Woso mimbʊnyaarɔ haay kan sʊnsɔrɔ haay kɩ sugur kam gʊɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bɩ gʊaa biyəə k'a nɩ *Sɛnt-Ɛspri sʊnsɔ wʊm bɩ, a b'a sugur yɩm fɩɩga y. A mimbʊnyaa bɩ gɔɔtarɛ a mim ʊ dɔmɩm k'a nyarɛ ba ʊ bɩ nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeezuu naa do hɩ, kʊ ŋ ʊ: Sʊtaana nɩ kan kɩ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Bɩ jɛ ʊ bɩ, Yeezuu da kan Yeezuu danyɩnɔ kɩ bʊr, ŋnɩ jɩm garga ra, ŋ n nyɔɔ da kʊ ŋ n Yeezuu bir. ");
INSERT INTO bib_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Zamaa bɩ nyɩnta, n nɩ bɩr ma, n n'a hɩm nɩ, n ʊ: «Gaafra, ɩbɩɩ da kan ɩbɩɩ danyɩnɔ kɩ y'ɩbɩɩ birm garga ra.» ");
INSERT INTO bib_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yeezuu n a nyɩ bɔ ʊ ŋ nʊ, a ʊ: «Nka m mɔɔ da? Nkɔɔ m mɔɔ danyɩnɔ?» ");
INSERT INTO bib_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A n bɔkarɛ, an a bɔ, an nɩ dɩgam gʊɔɔ kʊ ŋ nyɩnta ŋnɩ bɩr ma rɔ wɔɔ ma, an n'a hɩrɛ, a ʊ: «Mɔɔ da bɩ ba n nɩ, kan mɔɔ danyɩnɔ wɔɔ kɩ! ");
INSERT INTO bib_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gʊaa niŋŋə k'a nɩ Woso hɔɔnhɔ bam bɩ, mɔɔ danyɩ m, mɔɔ danlʊ m, mɔɔ da m.» ");
INSERT INTO bib_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yeezuu a ya, an nɩ hɔ dɩndam Galilee higʊta lɛ ra. Zamaa a so kʊ ma gʊta ŋnɩ bɩr ma, an wuti, an aa nyɩnta kɔɔlʊʊrɔ wɔɔ deem ʊ hi bɩ nɔ ʊ. Zamaa bɩ haay n nyɩnta tara ʊ hi bɩ lɛ ra. ");
INSERT INTO bib_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A hɔbɔkʊrɛnoom darɛ nɔ ʊ, a hɔ dɩnda ŋ nɩ gʊta. A hɔdɩndarɛ nɔ ʊ, a a hɩ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«K'a tʊr ka: gʊaa ɩ bɔ k'a hɔ duu, a duure nɔ ʊ bɩ, a hɩsɩga an nawʊm. ");
INSERT INTO bib_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","K'a n'a duum bɩ, gɔsɩnnɔ n a lo zaa gʊr ma. Bɛnnɔ n bʊr, ŋnɩ b'a bɩ. ");
INSERT INTO bib_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Gɔsɩnnɔ n a lo jaarɔ bɩncɛ ʊ, taa n nyɩnta b'ʊ gʊta y. Hɔyaa bɩ n lɛɛ ka an bɔ, kʊ taa ba ʊ gʊta b'ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Woso k'a der bɩ, an na hɔka bɩ ma, an ga, kʊ ŋ məsi ba ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gɔsɩnnɔ a zar laa bɩncɛ ʊ, laa bɩ n haan, an a ta ŋ mee, ŋ n nyɩ da y. ");
INSERT INTO bib_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gɔsɩnnɔ n a lo lɛɛ mɩŋŋa ʊ, ŋnɩ haan, ŋnɩ ma, ŋnɩ nyɩ da. A yaa deem yaa ka bukərku, deem busɔrdɩ, deem zɔrɔ.» ");
INSERT INTO bib_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yeezuu a hɩ, a ʊ: «Gʊaa k'a lɛ n taa k'a jɩ ma, k'an a tʊr ka ma mɩŋŋa.» ");
INSERT INTO bib_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kʊ zamaa b'a hʊr bɩ, gʊɔɔ kʊ ŋ gɔɔta kan Yeezuu kɩ, a karɩndanyɩnɔ bueerehɩɩyɔɔ wɔɔ kɩ bɩ, ŋ nyɩnta ŋn'a larm a hɔbɔkʊrɛnoonno wɔɔ jɩ ma. ");
INSERT INTO bib_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A n n'a hɩrɛ ŋ nɩ, a ʊ: «Awɔɔ Woso cirbəə mim k'a nyaakʊm da bɩ yɩ, bɩ gʊɔɔ kʊ ŋ bɩr a kam ma k'a yɩ rɔ wɔɔ, a hɩ n nawʊrɛ ŋ nɩ hɔbɔkʊrɛnoom darɛ m. ");
INSERT INTO bib_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Bɩ minto y'a ka gʊɔɔ wɔɔ nɩ dɩgam, bɩ ŋ bɩr lɛɛ yɩrɛ y, ŋn'a tʊr kam, bɩ ŋ bɩr hɔsɩ jɩ marɛ kʊ ŋ b'a da ma ŋn'a bɔ a taam kʊ Woso n sugur ka ŋ ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yeezuu n'a hɩrɛ ŋ nɩ, a ʊ: «Awɔɔ n hɔbɔkʊrɛnoom naa do jɩ dɔ ra? Bɩ, awɔɔ y'a bam lɔ, a hɔbɔkʊrɛnoonno haay jɩ dɔ?» ");
INSERT INTO bib_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Hɔduurezaa bɩ, Woso lemim a n n'a duum. ");
INSERT INTO bib_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hɔyaa k'a a lo zaa lezi bɩ, bɔ ŋ y'a ʊ kʊ ʊ kan gʊɔɔ kɩ. Brɔɔ Woso lemim bɩ ma, lɛɛm bɩ Sʊtaana lemim kʊ n y'a duu ŋ heer ʊ bɩ si ŋ han. ");
INSERT INTO bib_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","B'a hɔdeem kan gʊɔɔ kʊ ŋ bɔ kʊ ʊ kan hɔyaa k'a a lo jaarɔ bɩncɛrɔ ʊ rɔ wɔɔ kɩ, brɔɔ nɩ Woso lemim bɩ marɛ, ŋn'a sim lɛɛm kan heernyɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bɩ, ŋ mɩŋŋɔɔ məsi ba ʊ y, hindeem gʊɔɔ m. Kʊ cicir gɛɛ fɩryɩrɛ bʊr Woso lemim bɩ minto, bɩ ŋ y'a to. ");
INSERT INTO bib_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Gʊɔɔ vantɔɔ bɔ kʊ ʊ kan hɔyaa k'a a lo laa bireyaa ʊ rɔ wɔɔ kɩ. Brɔɔ nɩ Woso lemim bɩ mam. ");
INSERT INTO bib_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Kan durnya hɔɔndama bɩ kɩ, braba a mɩŋŋa m arzaka kama kɩ, kan hɔɔ vantɔɔ lɛtaama kɩ gasʊ ŋ ʊ, ŋn'ɩ Woso lemim bɩ zarm, a bɩr nyɩ darɛ y. ");
INSERT INTO bib_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A nyambʊrlɛ ma bɩ, gʊɔɔ vantɔɔ n ta ʊ, ŋnɩ bɔ kʊ ʊ kan hɔyaa k'a a lo bɩncɛ mɩŋŋa ʊ rɔ wɔɔ kɩ. Brɔɔ nɩ Woso lemim bɩ marɛ, ŋn'ɩ yɛm ma, ŋn'ɩ nyɩ dam. A yaa deem nɩ nyɩ dam bukərku, deem busɔrdɩ, deem zɔrɔ. ");
INSERT INTO bib_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","A a ya, an a hɩ ŋ nɩ, a ʊ: «N bɩr sɛ dam fɩtɩrɛ ʊ, n n'a cɩntam kasɩ gɛɛ gargʊ taa y, gɛɛ lɔ? A cɩnta n nawʊm hɔ burə ʊ. ");
INSERT INTO bib_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bala, mim haay kʊ gʊɔɔ b'a dam ma ŋn'a dɔ naa ma bɩ, ŋ zɛm b'a dɔ. Hɔ ba ʊ n n a nyaakʊm da a dɔ n mɩ y. ");
INSERT INTO bib_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Gʊaa k'a lɛ n taa k'a jɩ ma, k'an a tʊr ka ma mɩŋŋa.» ");
INSERT INTO bib_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yeezuu a vanta hɩ ŋ nɩ, a ʊ: «K'a dundo a zi kan hɔ k'awɔɔ n'a mam bɩ kɩ. Awɔɔ makra barɛ hɔ bɩ, n zɛm b'a sa, n nɩ ganwʊrɛ makra bam, n n'a ka awɔɔ ʊ. N y'a lɛŋŋa dam sɔ. ");
INSERT INTO bib_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bala, n hɔ kam gʊaa k'an ta m b'ʊ; Gʊaa k'a ba m bɩ, baa k'a ta m poore, n y'a yɔm nɩ.» ");
INSERT INTO bib_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","A a ya, an a hɩ ŋ nɩ, a ʊ: «Woso cirbəə bɩ, bɔ a kʊ ʊ kan gʊaa k'a nɩ hɔ duum tara ʊ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kʊ hinceem a n'a barɛ gɛɛ, jɩm a nawʊrɛ, sinuu ʊ kan a gunuu ʊ kɩ, hɔyaa bɩ, haan a nawʊm, an nɩ mam, b'a n a dɔ kʊ ba a nawʊm lʊnlɔ y. ");
INSERT INTO bib_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tara bɩ n'a zi barɛ, hɔyaa bɩ n nɩ lɛɛkarɛ an nɩ haanm, an nɩ gɔ dam, an nɩ jɩsɩ sim, a nyambʊrlɛ ma bɩ, an nɩ nyɩ dam. ");
INSERT INTO bib_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hɔyaa bɩ k'a ma bɩ, a da n nawʊm, k'a dɔmɩm a ku bɩ minto.» ");
INSERT INTO bib_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yeezuu a ya, an a hɩ, a ʊ: «K'ʊ Woso cirbəə makra ba lʊnlɔ kan bɔ kɩ? ");
INSERT INTO bib_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bɔ a kʊ ʊ kan hɔ kʊ n n'a hɩm ma mutardɩ bɩ yaa kɩ; A m hɔyaa haay k'a nɩ durnya nɔ ʊ rɔ wɔɔ poore, n n'a duum. ");
INSERT INTO bib_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kʊ n y'a duu, ma a nawʊm, an nɩ gɔ dam an lɛ da hɔyaa haay ra, an nɩ haanm gʊta, a vəŋŋəro n ta ʊ, bɛnnɔ n b'a dam ma ŋnɩ cɛ kɩnka ma.» ");
INSERT INTO bib_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yeezuu ɩ Woso lemim nyɩnta dɩndam gʊɔɔ wɔɔ m kan makrarɔ kʊ ŋ bɔ kʊ ʊ kɩ gʊta, kʊ ŋ n'a da ma ŋn'a jɩ ma. ");
INSERT INTO bib_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Hɔbɔkʊrɛnoom an n'a dam gʊɔɔ wɔɔ m bala, bɩ k'a karɩndanyɩnɔ wɔɔ nɩ, a y'a jɩ hɩrɛ ŋ nɩ haay. ");
INSERT INTO bib_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hinni bɩ do yirbəə m bɩ, Yeezuu a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «Ʊ bra gəm deem bɩ ra.» ");
INSERT INTO bib_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kʊ Yeezuu a gʊ zamaa bɩ ma bɩ, a zu kʊ ʊ kan a karɩndanyɩnɔ wɔɔ kɩ, ŋn'aa gasʊ kɔɔlʊʊ ʊ. Kɔɔlʊʊrɔ vantɔɔ nyɩnta b'ʊ sɔ kan kɩ. ");
INSERT INTO bib_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lɛɛm bɩ, hɩnhɛr gʊta wuti an nɩ hɔnm. Hi kurə bɩ n'a tɔm kɔɔlʊʊ b'ʊ, an a han lɛɛm. ");
INSERT INTO bib_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Bɩ ma bɩ, Yeezuu a mim ka minkarahɔ ra an nɩ hinceem bam kɔɔlʊʊ bɩ nɔ ʊ jɛ ʊ, ŋn'a gu, ŋn'a hɩ m, ŋ ʊ: «Karɩnsaamba, wɔɔ gɩngarɛ bɩr hɔsɩ barɛ ɩbɩɩ m na?» ");
INSERT INTO bib_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","K'a gu bɩ, an həən si hɩnhɛr bɩ ma, an a hɩ higʊta bɩ m, a ʊ: «Ɩ tʊr ka ɩ zɛ sɩɩ…» Hɩnhɛr bɩ n jɩm, lɛɛ bɩ n zɛ sɩɩ…. ");
INSERT INTO bib_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yeezuu n a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «Bɔ m, awɔɔ nɩ nyi barɛ ncɩnaaʊ? Awɔɔ ba sɩrakarɛ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nyibəə gʊta n gasʊ ŋ ʊ, ŋn'a hɩm kʊ m, ŋ ʊ: «Bɩ, gʊaa bɩ kara n naa, hɩnhɛr kan hi kɩ n'a lɛ sire?» ");
INSERT INTO bib_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ŋ yaa lee ku higʊta tʊr ʊ, Gerazaa zannɔ kʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kʊ Yeezuu nɩ zerm kɔɔlʊʊ b'ʊ bɩ, gʊaa kʊ zinəro n ta m bɔ gəənoyaa ra, an b'a zɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A wʊtajɩ m gəənoyaa ra bɩ m. Baa kan pɔyaabar kɩ, gʊaa paŋŋazaa ba ʊ, an b'a dam ma, an a nyasʊ y. ");
INSERT INTO bib_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bala, dɔmɩm biyəə bɩ, ŋ pɔyaa da a gam ʊ, ŋn'a wɔ kʊsɩ pɔyaabar m, an a cencer haay. Gʊaa ba ʊ an nɩ bʊrm ma y. ");
INSERT INTO bib_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sinuu ʊ kan a gunuu ʊ kɩ, gəənoyaarɔ an nɩ wʊtaŋ ʊ kan ciro wɔɔ burə kɩ, zee an n'a dam, an nɩ yaaba darɛ a mɩŋŋa ma jaarɔ m. ");
INSERT INTO bib_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","K'a a to an Yeezuu yɩ laatʊ bɩ, a bra si, an aa sʊnta a taa, ");
INSERT INTO bib_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","an nɩ zee darɛ, a ʊ: «Yeezuu, Woso k'a lɛ da haay Nyɩ, bɔ ɩbɩɩ lɛ n taa k'ɩ ba mɔɔ nɩ? Mɔɔ y'a yɛrɛ ɩbɩɩ han Woso tɔ ma gʊta: ɩ bɩ zibʊnyaa ba mɔɔ nɩ y!» ");
INSERT INTO bib_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bala, Yeezuu y'a hɩm zinə bɩ m, a ʊ: «Bɔ gʊaa bɩ mɛ ʊ!» ");
INSERT INTO bib_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yeezuu n a lar, a ʊ: «Ɩbɩɩ tɔ m bɔ?» A n a nyɩ bɔ ʊ, a ʊ: «Mɔɔ tɔ m Leziyɔn, bala wɔɔ gʊta.» ");
INSERT INTO bib_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A n a yɛ Yeezuu han kan a heer kɩ haay, a ʊ: «A bɩ la a ra tara bɩ nɔ ʊ y!» ");
INSERT INTO bib_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dɔmɩm bɩ do ʊ bɩ, kurkuuro cir gʊta nɩ ci bɩ zeezi, ŋn'ɩ hɔ bɩm. ");
INSERT INTO bib_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Zinəro wɔɔ n n'a hɩrɛ, ŋ ʊ: «A ka k'ʊ gasʊ kurkuuro wɔɔ mɛ ʊ!» ");
INSERT INTO bib_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A n zaa ka ŋ ʊ. Zinəro wɔɔ n bɔ, ŋnɩ gasʊ kurkuuro wɔɔ ʊ. Kurkuuro wɔɔ haay n'a to ci bɩ ma, ŋnɩ bra si, ŋnɩ zer, ŋn'aa a zar higʊta b'ʊ, ŋnɩ gɩnga haay. Kurkuuro wɔɔ a zɔ tisi hɩɩya ma. ");
INSERT INTO bib_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kurkuuro dundonno wɔɔ n bra si, ŋn'aa hɔ k'a ba bɩ hɩ taranɔzannɔ wɔɔ m, kan lezimazannɔ wɔɔ kɩ m. Gʊɔɔ wɔɔ n bʊr, ŋnɩ bɩ dɩga hɔ k'a nyɩnta an ba bɩ ma, ");
INSERT INTO bib_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ŋnɩ bʊr Yeezuu jɩr ʊ, ŋnɩ bɩ gʊaa kʊ zinəro Leziyɔn n ta m bɩ yɩ, an huu du a ma, an nɩ nyɩntam kan laafɩɩ kɩ. Dabɔʊ n ŋ nyasʊ. ");
INSERT INTO bib_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Gʊɔɔ kʊ ŋ nyɩnta, ŋ nɩ hɔ k'a nyɩnta an ba gʊaa kʊ zinəro n ta m bɩ m, kan kurkuuro wɔɔ kɩ m bɩ dɩnda gʊɔɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ŋ n a da a ra, ŋn'a yɛm Yeezuu han k'an a hʊr a tara bɩ ra. ");
INSERT INTO bib_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kʊ Yeezuu bʊr an nɩ dam kɔɔlʊʊ b'ʊ bɩ, gʊaa kʊ zinəro n ta m bɩ k'a waa b'a yɛ han k'a bɩr kan kɩ. ");
INSERT INTO bib_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bɩ Yeezuu n zaa ka ʊ y, b'a a hɩ m, a ʊ: «Doo ɩ yaa a hɩ ɩ har zannɔ m. K'ɩ hɔ kʊ Zuuba a ba ɩbɩɩ m a cicirzɛrɛ minto bɩ hɩ ŋ nɩ.» ");
INSERT INTO bib_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Gʊaa bɩ n a hʊr, an aa hɔ kʊ Yeezuu a ba a m haay bɩ dɩnda Taraburo wɔɔ gʊɔɔ wɔɔ m. Gʊaa haay n zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kʊ Yeezuu a wusigə kɔɔlʊʊ bɩ m an higʊta bɩ zɛ ra an lee ku tʊr deem bɩ ra b'ʊ bɩ, zamaa cir gʊta a zɛ kʊ ra, ŋnɩ bʊr zi. Nyɩnta Yeezuu b'ʊ higʊta bɩ lɛ ra. ");
INSERT INTO bib_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Zɩɩfʊrɔ sokʊmacɛ cir deem n bʊr, a tɔ m Zayɩɩr. K'a Yeezuu yɩ bɩ, a kukurə zɛ a taa, ");
INSERT INTO bib_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","an a yɛ han kan a heer kɩ haay, a ʊ: «Mɔɔ nyɩmbʊɛɛrɛ poore a zɔ zɛ ma, bʊr ɩ bɩ ɩ wɔ ka nyɩ bɩ mim la, k'an a waa, k'an la sɔ.» ");
INSERT INTO bib_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yeezuu n cem kan kɩ, zamaa gʊta n zu kʊ ʊ kan kɩ, ŋn'a so ʊ, ŋn'ɩ tʊntɔm kʊ ra. ");
INSERT INTO bib_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lʊ n ta ʊ, ma n'a dam zi a dɔɔraa bueerehɩɩya hɔ m naa. ");
INSERT INTO bib_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A a yɔ gʊta nyɩsɩbənno wɔ ʊ, a nyɩsɩbarɛ nɔ ʊ. A a wɔhɔ zar haay a tar la, b'a n a waa y. Yaaba bɩ n'a dam la. ");
INSERT INTO bib_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Lʊ bɩ k'a Yeezuu mim ma bɩ, a bʊr a kur zamaa gaa ʊ b'ʊ, an a wɔ da a huu ma. ");
INSERT INTO bib_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Bala, lʊ b'a hɩ a mɩŋŋa m, a ʊ: «Kʊ mɔɔ m wɔ da a huu tɔkkɛ ma, mɔɔ yɩ m waam.» ");
INSERT INTO bib_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lɛɛm bɩ, lʊ bɩ yaaba b'a da jɩm ʊ. A n a dɔ a ʊ, yaaba bɩ bɔ a mɛ ʊ, b'a a waa. ");
INSERT INTO bib_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lɛɛm bɩ, Yeezuu a dɔ a ʊ, paŋŋa bɔ a mɛ ʊ poore, an a wusigə zamaa bɩ bire ʊ, an laaka da, a ʊ: «Nka y'a wɔ da mɔɔ huu ma?» ");
INSERT INTO bib_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","A karɩndanyɩnɔ wɔɔ n a hɩ m, ŋ ʊ: «Ɩbɩɩ yɩ zamaa bɩ n'ɩbɩɩ nyɔɔtam, ɩ ɩ ya, ɩ nɩ laaka darɛ, ɩ ʊ, nka y'a wɔ da ɩbɩɩ ma gɛ?» ");
INSERT INTO bib_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yeezuu nɩ dɩndɩgarɛ a jɩr ʊ, k'a zaa yɩ. ");
INSERT INTO bib_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kɛɛrɛ bɩ, lʊ b'ɩ nyi bam a mɛ n nɩ hinkəm, k'a hɔ k'a ba a m bɩ dɔ bɩ, a bɩ kukurə zɛ Yeezuu taa, an a sɩra hɩ m haay. ");
INSERT INTO bib_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeezuu n a hɩ m, a ʊ: «Mɔɔ nyɩnnɩ, ɩ sɩrakarɛ ɩ bʊmbɔ, ta kan laafɩɩ kɩ, bɩ, ɩ ɩ waa ɩ yaaba bɩ minto.» ");
INSERT INTO bib_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","K'a nɩ meer bam bɩ, gʊɔɔ a to zɩɩfʊrɔ sokʊmacɛ cir bɩ har ʊ b'ʊ, ŋnɩ b'a hɩ, ŋ ʊ: «Ɩ nyɩmbʊɛɛrɛ bɩ ga. K'ɩ ɩ ya, ɩ Zuuba da kɔrɛ ma lʊnlɔ gɛ?» ");
INSERT INTO bib_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bɩ, Yeezuu n a tʊr ka mim bɩ ma y. A n a hɩ zɩɩfʊrɔ sokʊmacɛ cir bɩ m, a ʊ: «Ɩ da bɩ bɔ ʊ y, sɩra ka bala.» ");
INSERT INTO bib_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A n yɛ kʊ gɔsɩ n zu kʊ ʊ kan a kɩ y. Pɩyɛɛr a gaa bala, Zakkɩ kan a danzaa Zaan kɩ. ");
INSERT INTO bib_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kʊ ŋ yaa lee ku zɩɩfʊrɔ sokʊmacɛ cir bɩ har ʊ bɩ, Yeezuu gʊɔɔ yɩ, ŋn'ɩ tatʊr barɛ, ŋn'ɩ baa darɛ, ŋn'ɩ zee dam. ");
INSERT INTO bib_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A n gasʊ, an a hɩ ŋ nɩ, a ʊ: «Bɔ tatʊr kan baadarɛ kɩ nɩ? Nyɩ bɩ n ga y, hinceem a ba.» ");
INSERT INTO bib_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Gʊɔɔ wɔɔ nɩ yaa wʊm Yeezuu ma. A n la gʊɔɔ wɔɔ ra, ŋnɩ bɔ, an nyɩ bɩ zɩ kan a da kɩ to, a karɩndanyɩnɔ wɔɔ kɩ, ŋnɩ gasʊ nyɩ bɩ bɩncɛ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","K'a nyɩ bɩ wɔ sa bɩ, a a hɩ m, a ʊ: «Taliita kum» A lɛ taa k'a hɩ, a ʊ: «M nyɩnnɩ, mɔɔ y'a hɩ ɩbɩɩ m, wuti!» ");
INSERT INTO bib_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Lɛɛm bɩ nyɩmbʊɛɛrɛ bɩ wuti, an nɩ tam. Bala, nyɩ bɩ dɔɔraa bueerehɩɩya. A m bɩ, zamaa bɩ n zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yeezuu lɛ ka gʊɔɔ wɔɔ ʊ, a ʊ: «Ŋ b'a hɩ gɔsɩ nɩ y.» A n a hɩ ŋ nɩ, a ʊ: «K'a hɔbɩrɛ ka nyɩ b'ʊ, k'an a bɩ!» ");
INSERT INTO bib_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yeezuu a hʊr lɛɛ bɩ do ʊ, kan a karɩndanyɩnɔ wɔɔ kɩ, an ta kʊ k'a tʊr ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","*Sabaa hinni k'a a ku bɩ, Yeezuu hɔ dɩnda gʊɔɔ m zɩɩfʊrɔ sokʊmacɛ ʊ. Zamaa bɩ n zɛ kədə a hɔdɩndarɛ bɩ tɔ ma. Gʊɔɔ kʊ ŋ nyɩnta b'ʊ rɔ wɔɔ gʊta y'a hɩm kʊ m, ŋ ʊ: «Awɔɔ a to mindɔrɛ naa do m ka? A to awɔɔ ʊ hɔɔn naa do m ka, an a da ma, an nɩ hoserlo barɛ a wɔ nɩ? ");
INSERT INTO bib_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Awɔɔ bɛɛ m Maarii nyɩ, an nɩ gɔ wum bɩ ra? Zakkɩ, Zozɛs, Ziidi kan Sɩmɔɔn kɩ danyɩ bɛɛ ra? Awɔɔ danlʊrɔ ba wɔɔ bire ʊ naa ʊ ra?» Naa do a ka ŋ n kaanm Yeezuu m. ");
INSERT INTO bib_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Wosolɛsinnɩsorazaa bɩ daʊrɛ yɩrɛ a zɩ kʊ ʊ kan a yɩrɛrɔ kɩ, a har gʊɔɔ kɩ bire ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yeezuu n hoser ba b'ʊ y, kʊ gʊɔɔ k'a wɔ ka ŋ mim la, an ŋ waa rɔ wɔɔ bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yeezuu zɛ kədə ŋ sɩrakarɛ war bɩ tɔ ma. Yeezuu cem an nɩ hɔ dɩndam kʊrɔ jɩnjɛɛnnɔ wɔɔ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Bɩ jɛ ʊ bɩ, Yeezuu n bueerehɩɩyɔɔ wɔɔ bir, an a sɩŋŋɩda ba, an nɩ ŋ nyɔɔm hɩɩya-hɩɩya, an lɛ ka ŋ ʊ kʊ ŋ n la zinəro ra. ");
INSERT INTO bib_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","A a hɩ ŋ nɩ, a ʊ: «Ŋ bɩ hɔsɩ sa a wɔ ʊ zaa sarɛ minto y. Bur, hɛra, busoo, a b'a sa y, k'a maam bara m. ");
INSERT INTO bib_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bɩ, k'a kʊsɔrɔ da ʊ, k'a huu sa deem.» ");
INSERT INTO bib_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A a ya, an a hɩ ŋ nɩ, a ʊ: «K'a lee ku kʊ ʊ, k'a gɔɔta har kʊ n y'awɔɔ si ʊ b'ʊ, an ta, an awɔɔ hʊrlɛ dɔmɩm ku. ");
INSERT INTO bib_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","K'awɔɔ ta kʊ ʊ, ŋ nɩ kaanm awɔɔ m, kʊ ŋ n a tʊr ka awɔɔ mim ma, k'a ɩ doom, k'a kʊ bɩ taanyisi gʊngʊ a gam ma, k'an nyɩnta kasɛtɩ.» ");
INSERT INTO bib_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bueerehɩɩyɔɔ wɔɔ a hʊr ŋn'a hɩm gʊɔɔ m, ŋ ʊ: «K'a a bɔ a taam, k'a sugur yɛ.» ");
INSERT INTO bib_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ŋ la zinəro ra gʊta, ŋ nyɔɔ nɔ yaabazannɔ gʊta ma, ŋnɩ ŋ waa. ");
INSERT INTO bib_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Cir Hɩrɔɔdɩ Yeezuu mim ma, bala, a tɔ bɔ lɛɛ woo… ʊ. Gʊɔɔ gɔsɩnnɔ n'a hɩrɛ, ŋ ʊ: «Zaan-Batiisi a mɩm bɔ ʊ gəəno bire ʊ. Bɩ y'a ka, an paŋŋa yɩ, an nɩ hoserlo bam.» ");
INSERT INTO bib_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nawɔnnɔ ʊ: «*Elii m.» Gɔsɩnnɔ ʊ: «Wosolɛsinnɩsorazannɔ wɔɔ deem m am biisi hɔɔ wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hɩrɔɔdɩ k'a hɔ kʊ Yeezuu a ba bɩ ma bɩ, a a hɩ, a ʊ: «Zaan-Batiisi m! Mɔɔ n a ka, n n a mim gʊ ma bɩ y'a a ya, an a mɩm bɔ ʊ!» ");
INSERT INTO bib_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","A yɩ sɩra, Hɩrɔɔdɩ a ka, n nɩ Zaan nyasʊ, n n'a sur, n n'a du lɔnnɔcɛ ʊ. Hɩrɔɔdɩ bɩ, naa ba a ʊ: a dam Filipi lʊ k'a yɔ m a tɔ m Hɩrɔdɩyaadɩ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Bala, Zaan a hɩ Hɩrɔɔdɩ m, a ʊ: «A n a ga m, k'ɩbɩɩ m ɩ dam lʊ yɔm y!» ");
INSERT INTO bib_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hɩrɔdɩyaadɩ nyɩnta an sɔ Zaan m, a lɛ n taa k'a ka kʊ n n a zɛ, b'a b'a dam ma y. ");
INSERT INTO bib_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hɩrɔɔdɩ ɩ nyi bam Zaan m, an nɩ kum la, bala, a a dɔ, a ʊ: Zaan bɩ, gʊaa tɩrga nɩ, gʊaa mɩŋŋa m sɔ. K'a a tʊr ka Zaan meerbaa bɩ ma bɩ, a n a dɔ kʊ bɔ an n'a hɩm Zaan nɩ y, b'a a meerbaa bɩ ŋʊa, an n'a tʊr kam ma. ");
INSERT INTO bib_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kɛɛrɛ bɩ, toore a ka Hɩrɔdɩyaadɩ ʊ. Hɩrɔɔdɩ a kʊ lɛɛzannɔ, yarbənno jɩtannɔ, kan Galilee gʊɔɔ gʊtɔɔ kɩ bir a yɩrɛ cibsa hɔbɩrɛ ma. ");
INSERT INTO bib_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hɩrɔdɩyaadɩ nyɩmbʊɛɛrɛ gasʊ hɔbɩrɛ bɩrɛ cɛ ʊ b'ʊ, an sar ba zamaa bɩ bire ʊ; a Hɩrɔɔdɩ nɔ yɩ kan hɔbɩrɛbinno wɔɔ kɩ. Cir Hɩrɔɔdɩ n a hɩ nyɩmbʊɛɛrɛ bɩ m, a ʊ: «Hɔ k'ɩbɩɩ lɛ n taa bɩ yɛ mɔɔ han, kʊ m a ka ɩ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hɩrɔɔdɩ n a wer si bɩ m, a ʊ: «Hɔ k'ɩbɩɩ lɛ n taa bɩ, mɔɔ y'a karɛ ʊ, baa kʊ mɔɔ cirbəə tara bɩ zɛkumbir m.» ");
INSERT INTO bib_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nyɩmbʊɛɛrɛ bɩ n bɔ, an aa a hɩ a da m, a ʊ: «M bɔ yɛ?» A n a nyɩ bɔ ʊ, a ʊ: «Zaan-Batiisi mim yɛ.» ");
INSERT INTO bib_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nyɩmbʊɛɛrɛ bɩ n ta zɔɔ-zɔɔ, an aa a hɩ cir Hɩrɔɔdɩ m, a ʊ: «Mɔɔ lɛ n taa dɩɩtaa, k'ɩ Zaan-Batiisi mim da laaga ʊ, ɩ ka m ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Cir Hɩrɔɔdɩ heer a zar, bɩ, a b'a dam ma, an a gu ma y, k'a a wer si hɔbɩrɛbinno wɔɔ bire ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lɛɛm bɩ, cir Hɩrɔɔdɩ lɛ ka a dɔmazaa deem ʊ, k'an bʊr Zaan mim m. A dɔmazaa bɩ n ta lɔnnɔcɛ ʊ b'ʊ, an aa Zaan mim gʊ ma, ");
INSERT INTO bib_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","an bʊr m laaga ʊ, an b'a ka nyɩmbʊɛɛrɛ b'ʊ, an a si, an a ka a da ʊ. ");
INSERT INTO bib_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zaan karɩndanyɩnɔ wɔɔ kʊ ŋ naa ma bɩ, ŋ bʊr, ŋnɩ bɩ Zaan gər bɩ sa, ŋn'aa bir. ");
INSERT INTO bib_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yeezuu zibəəzannɔ wɔɔ a bɔ, ŋnɩ bʊr zi, ŋnɩ hɔ haay kʊ ŋ y'a ba bɩ hɩ Yeezuu m, kan hɔ haay kʊ ŋ y'a dɩnda gʊɔɔ wɔɔ m bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yeezuu kan a karɩndanyɩnɔ wɔɔ kɩ n toore yɩ k'a hɔ bɩ gʊɔɔ gʊta kʊ ŋ nɩ zɛm, ŋn'a wusigəm bɩ minto. Bɩ minto y'a ka, a ʊ: «K'a bʊr k'ʊ bɔ toore ma, bɩncɛ kʊ gʊɔɔ ba ʊ b'ʊ, k'a hoon si poore.» ");
INSERT INTO bib_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ŋ yaa da kɔɔlʊʊ ʊ, ŋnɩ ta toore ma bɩncɛ kʊ gɔsɩ ba ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bɩ gʊɔɔ gʊta ŋ cenle yɩ, ŋnɩ ŋ dɔ, ŋnɩ bra si a gam ma, ŋnɩ lɛɛ ka Yeezuu m kan a karɩndanyɩnɔ wɔɔ kɩ lɛɛ bɩ do ʊ. ");
INSERT INTO bib_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kʊ Yeezuu bɔ kɔɔlʊʊ b'ʊ bɩ, a zamaa cir gʊta yɩ. Gʊɔɔ wɔɔ cicir n a nyasʊ, bala, bɔ ŋ y'a ʊ kʊ ʊ kan hɔbɩsɩ cir kʊ ŋ dɔmazaa ba ʊ bɩ kɩ. A a sɩŋŋɩda ba, an nɩ hɔ gʊta dɩndarɛ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Gum k'a bʊr an nɩ dam bɩ, Yeezuu karɩndanyɩnɔ wɔɔ a zɔ ma, ŋn'a hɩ m, ŋ ʊ: «Gum da, bɩ pooyaa m naa, ");
INSERT INTO bib_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","gʊɔɔ wɔɔ da zaa ra kʊ ŋ nɩ ta kʊrɔ jɩnjɛɛnnɔ wɔɔ ʊ, ŋn'aa hɔbɩrɛ si, ŋn'a bɩ!» ");
INSERT INTO bib_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «K'a hɔbɩrɛ ka ŋ ʊ, ŋn'a bɩ!» Ŋ n a lar, ŋ ʊ: «Ɩbɩɩ lɛ n taa k'ʊ aa bur si *deniyee zɔɔhɩra k'ʊ b'a ka ŋ ʊ gɛ?» ");
INSERT INTO bib_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a yaa dɩga a, bur karɔ n ta awɔɔ ʊ?» Kʊ ŋ yaa dɩga a bɩ, ŋ b'a hɩ, ŋ ʊ: «Bur soor n ta ʊ kan zɔ kɩ hɩɩya.» ");
INSERT INTO bib_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","A n lɛ ka ŋ ʊ, kʊ ŋ n zamaa bɩ nyɩnta bur butur bɩ ra. ");
INSERT INTO bib_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ŋ nɩ nyɩnyɩnta zɔrɔ-zɔrɔ, busoor-busoor. ");
INSERT INTO bib_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yeezuu bur soor bɩ si kan zɔ hɩɩya bɩ kɩ a wɔ ʊ, an dɩga brama, an a barka da ʊ, an ŋ zɩnzɛra, an a ka a karɩndanyɩnɔ wɔɔ ʊ, kʊ ŋ n a ka zamaa b'ʊ. A zɔ hɩɩya bɩ jir zamaa bɩ m sɔ. ");
INSERT INTO bib_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Gʊɔɔ wɔɔ haay a bɩ, an ŋ ka. ");
INSERT INTO bib_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ŋ bur kan zɔ kɩ kuuro gʊr kasɩ lɛ ma bueerehɩɩya. ");
INSERT INTO bib_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bur bɩ binno wɔɔ barla, yar tisi soor ɩ nyɩnta ʊ. ");
INSERT INTO bib_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Lɛɛm bɩ, Yeezuu a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «K'a da kɔɔlʊʊ ʊ, k'a bra gəm la Bɛtsayɩdaa zeezi.» A mɩŋŋa n gɔɔta k'a zamaa bɩ da zaa ra. ");
INSERT INTO bib_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","K'a ŋ da zaa ra, an a nya bɩ, a a hʊr, an ta ci ra k'a yaa da. ");
INSERT INTO bib_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yirbəə k'a da bɩ, kɔɔlʊʊ bɩ hi bireyaa ku, a mɩŋŋa nɩ gəm la. ");
INSERT INTO bib_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","K'a yɩ hɩnhɛr n a nya ŋ lɛ, ŋn'a yɔm kan kɔɔlʊʊ bɩ bɔrɛ kɩ bɩ, dɔ k'a bʊr an nɩ mɛm bɩ, a wuti an tɔ hi ra, an nɩ tarɛ ŋ zi, an a yo k'a cem ŋ han. ");
INSERT INTO bib_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kʊ ŋ y'a yɩ an nɩ tam hi ra bɩ, ŋ yɩ dɩgam ma, ŋ ʊ: «Toor m,» ŋn'ɩ zee dam. ");
INSERT INTO bib_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bala, ŋ haay a yɩ, nyibəə n ŋ nyasʊ. Lɛɛm bɩ, Yeezuu meer ba kan ŋ kɩ, a ʊ: «K'a sɩra ka, mɔɔ m, a da bɩ bɔ ʊ y!» ");
INSERT INTO bib_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A n da kɔɔlʊʊ b'ʊ kan ŋ kɩ, hɩnhɛr bɩ n jɩm. Ŋ n zɛ kədə, ŋ n a so a ʊ y. ");
INSERT INTO bib_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Baa kʊ ŋ bur bɩ jirle yɩ bɩ, ŋ n hɔsɩ jɩ ma ŋn'a dɔ ŋ ʊ, Yeezuu a da hɔ haay ma y. ");
INSERT INTO bib_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kʊ ŋ higʊta bɩ zɛ ra bɩ, ŋ yaa lee ku Zenezarɛtɩ gəm la, ŋn'a kɔɔlʊʊ bɩ kʊsɩ. ");
INSERT INTO bib_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kʊ ŋ zer lɛɛm bɩ, gʊɔɔ wɔɔ Yeezuu dɔ. ");
INSERT INTO bib_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ŋ n a si, ŋnɩ ta kʊrɔ haay ʊ, ŋn'aa yaabazannɔ busu a gʊraŋŋarɔ m, ŋnɩ bʊr ŋ nɩ bɩncɛ kʊ Yeezuu n ta ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bɩncɛ k'a nɩ taŋ ʊ, kʊrɔ gʊtɔɔ ʊ, kʊrɔ poorero ʊ, bɔlɛɛmarɔ ʊ, zɛ n nawʊm yaabazannɔ m daasɩrɔ ʊ, ŋn'a yɛm han, k'an yɛ kʊ ŋ n'a wɔ da a huu lɛ ma bala. Bɩ gʊɔɔ kʊ ŋ y'a wɔ da ma rɔ wɔɔ waarɛ yɩ haay. ");
INSERT INTO bib_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farizɛɛnrɔ kan wosocikarɩnsaambɔɔ gɔsɩnnɔ kɩ y'a to Zerizalɛm ʊ, ŋn'a zɛ kʊ ra, ŋnɩ bʊr Yeezuu zi, ");
INSERT INTO bib_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ŋnɩ Yeezuu karɩndanyɩnɔ gɔsɩnnɔ yɩ, ŋn'ɩ hɔ bɩm kan dintim kɩ, a lɛ taa k'a hɩ, a ʊ: ŋ n a wɔ hir y. ");
INSERT INTO bib_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kʊ sɩra nɩ, farizɛɛnrɔ kan zɩɩfʊrɔ kɩ haay hɔbɩrɛ bɩrɛ bɩ, a wɔ ŋn'a hirm mɩŋŋa, amba ŋ yaabɔɔ yɩnnɩbayɩ m. ");
INSERT INTO bib_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kʊ ŋ y'a to daasɩ ʊ, ŋnɩ bʊr, ŋ bɩr hɔ bɩm kʊ ŋ n dintim gʊ a ma y. Ŋ yɩnnɩbayɩrɔ vantɔɔ ta ʊ gʊta, amba hɛrɔ sʊrgɔrɛ, gərlo kan hɔbɩrɛ mɔdrɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farizɛɛnrɔ kan wosocikarɩnsaambɔɔ wɔɔ kɩ laaka da Yeezuu han, ŋ ʊ: «Bɔ m, ɩbɩɩ karɩndanyɩnɔ wɔɔ bɩr zum wɔɔ yaabɔɔ yɩnnɩbayɩ b'ʊ, ŋnɩ bɔkarɛ ŋn'ɩ hɔ bɩm, bɩ ŋ n hi nyasʊ?» ");
INSERT INTO bib_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Zambʊzannɔ, Ezayii gumə ta ʊ, Woso lɛ k'a a si an so ra, an awɔɔ mim hɩ bɩ nɔ ʊ, bala, a a gʊrsɩra ba ncɩnaaʊ, a ʊ: Gʊɔɔ nɔɔn duro, mɔɔ da ŋ nawʊŋ ʊ a lɛ m, bɩ ŋ heer laatʊ mɔɔ ma, ");
INSERT INTO bib_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","bɩ mɔɔ daʊrɛ bɩ vam m. Durnya mim ŋ n'a dɩndam gʊɔɔ m, Woso hɔ bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Woso lɛrɔ wɔɔ awɔɔ to, an nɩ zum gʊɔɔ yɩnnɩbayɩrɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Woso lɛrɔ wɔɔ bɔ awɔɔ ʊ a jɛ m, an nɩ zum a yɩnnɩbayɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bala, Moyiisi a hɩ, a ʊ: ‹Ɩ zɩ kan ɩ da kɩ da ʊ,› bɩ, ‹Gʊaa k'a zɩ bɔ ʊ kan a da kɩ, kʊ ŋ n a zɛ gər.› ");
INSERT INTO bib_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","B'awɔɔ, awɔɔ y'a hɩm, a ʊ: Kʊ gʊaa a hɩ a zɩ m gɛɛ a da m, a ʊ: hɔ kʊ mɔɔ m ga m, m m dam ɩbɩɩ han bɩ ‹kɔrbaan m› a lɛ taa k'a hɩ, a ʊ: ‹Woso mannɩ hɔ m.› ");
INSERT INTO bib_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","A n a ga m, k'an a da a zɩ han gɛɛ a da han dɔ y. ");
INSERT INTO bib_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","A ba awɔɔ nawʊm ncɩnaaʊ an nɩ Woso lemim bɩ zaar bam a yɩnnɩbayɩrɔ wɔɔ m. Ziro ncɩnaaʊ rɔ wɔɔ lɔɔrɔ awɔɔ nɩ ŋ bam gʊta.» ");
INSERT INTO bib_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Bɩ jɛ ʊ bɩ, Yeezuu zamaa bɩ bir, an a hɩ ŋ nɩ, a ʊ: «K'a tʊr ka mɔɔ ma, k'a da a heer ʊ. ");
INSERT INTO bib_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hɔ ba ʊ, an n'a tom garga ra, an gasʊ gʊaa nɔ ʊ k'a dintim ka ma y. Bɔ n'a tom gʊaa nɔ ʊ bɩ nɩ dintim kam ma.  ");
INSERT INTO bib_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Gʊaa k'a nɩ tʊr m bɩ, k'an a tʊr ka ma.» ");
INSERT INTO bib_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","K'a a gʊ zamaa bɩ ma, an gasʊ har ʊ bɩ, a karɩndanyɩnɔ wɔɔ a lar hɔbɔkʊrɛnoom naa do jɩ ma. ");
INSERT INTO bib_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A n a nyɩ bɔ ŋ nʊ, a ʊ: «Awɔɔ sɔ, awɔɔ n naa do jɩ dɔ ra? Awɔɔ n a dɔ, a ʊ: hɔ k'a n'a tore, an nɩ gasʊm gʊaa nɔ ʊ bɩ b'a dam ma, an dintim ka ma ra? ");
INSERT INTO bib_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bala, a nɔ an nɩ gasʊŋ ʊ, an ta, an nɩ bɔm garga ra, a bɩr gasʊrɛ a heer ʊ y.» Ncɩnaaʊ bɩ, Yeezuu y'a hɩnkarɛ, a ʊ: «hɔbɩrɛ haay mɩŋŋa.» ");
INSERT INTO bib_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A a ya, an a hɩ, a ʊ: «Bɔ nɩ bɔm gʊaa nɔ ʊ bɩ nɩ dintim kam ma. ");
INSERT INTO bib_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bala, gʊaa heer hɔɔndarɛ bʊnyaa bɩ n nɩ bɔŋ ʊ: so a mɩŋŋa ʊ, koorbarɛ, gərzɛrɛ, ");
INSERT INTO bib_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jaandarɛ, gʊaa hɔ ŋʊarɛ, zibʊnyaa do haay barɛ, bra ba gʊaa m, mɩsɩrbaa bʊnyaa barɛ, jɩm barɛ, gʊaa tɔ zarlɛ, mɩŋŋa busure kan yarmabaa kɩ. ");
INSERT INTO bib_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hɔɔ bʊnyaarɔ nɔɔn duro haay, bɔ ŋ nawʊm gʊaa heer ʊ, ŋn'ɩ dintim kam ma.» ");
INSERT INTO bib_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yeezuu k'a cem b'ʊ bɩ, a ta Tiir kʊ ʊ, an aa gasʊ har ʊ, a lɛ baa kʊ ŋ n a yɩ y. Bɩ, a n a da ma, an a nyaakʊm da y. ");
INSERT INTO bib_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bala, lʊ nɩ nyɩmbʊɛɛrɛ m, zinə nɩ kan kɩ. Bɩ, lʊ bɩ Yeezuu mim ma, an bra si, an bɩ kukurə zɛ Yeezuu taa. ");
INSERT INTO bib_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Lʊ bɩ, grɛkkɩ do m, yɩ a ʊ Siirii kʊ Fenisii ʊ. A n a yɛ Yeezuu han k'an la zinə bɩ ra nyɩmbʊɛɛrɛ bɩ mɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yeezuu n a hɩ m, a ʊ: «A to kʊ nyɩnɔ wɔɔ ŋ hɔ bɩ, an ŋ ka. A n a ga m, ŋnɩ nyɩnɔ hɔbɩrɛ sa, ŋn'a ka jinnyɩnɔ ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lʊ bɩ n a nyɩ bɔ ʊ, a ʊ: «Sɩra m, Zuuba, bɩ, jinnyɩnɔ wɔɔ tɩr hɔbɩrɛ kuuro kʊ ŋ y'a lunlo taabɩr bɩ taa bɩ gʊr, ŋn'a bɩ.» Yeezuu n a hɩ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","«Meerbaa naa do minto, doo, zinə bɩ bɔ ɩ nyɩmbʊɛɛrɛ bɩ mɛ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Lʊ bɩ n a hʊr, an doo, an aa a nyɩ bɩ yɩ, an nɩ wʊtam gargʊ burə ʊ. Zinə bɩ n bɔ a mɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yeezuu a hʊr Tiir kʊ ʊ, an a bɔ, an bɔ Sidɔn ʊ kan Taraburo wɔɔ kɩ nɔ ʊ, an ta Galilee higʊta zeezi. ");
INSERT INTO bib_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","N bʊr tikki m Yeezuu zi. Tikki bɩ, bɛkka m sɔ. N n a yɛ han k'an a wɔ ka a mim la, k'an a waa. ");
INSERT INTO bib_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeezuu n a gaa zamaa bɩ jɩr ʊ, an bɔ m toore ma, an a nyʊkʊnnyɩnɔ dundu tikki bɩ tʊr ʊ, an lihi da, a nyʊkʊr ma, an a nɔ a nɛɛm ma, ");
INSERT INTO bib_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","an a bɔɔta an dɩga brama, an hoonsi bɔ a rɛ, an a hɩ m, a ʊ: «Ɛfata!» ");
INSERT INTO bib_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A lɛ taa k'a hɩ, a ʊ: «Ɩ gʊ!» A tʊʊrɔ wɔɔ n a gʊ lɛɛm, a nɛɛm bɩ n a bɔ kʊ zi, an nɩ meer bam mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a b'a hɩ gɔsɩ nɩ y.» Yeezuu k'a lɛ ka ŋ ʊ, a ʊ: ŋ b'a hɩ bɩ, ŋ y'a pa da, an lɛ da biisi ra. ");
INSERT INTO bib_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Gʊɔɔ wɔɔ zɛ kədə, ŋn'a hɩrɛ, ŋ ʊ: «A ɩ hɔ haay bam mɩŋŋa; A ɩ tikkiro tʊr gʊm, a a ka bəətinno nɩ meer bam!» ");
INSERT INTO bib_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Dɔmɩnnɔ wɔɔ duro ʊ bɩ, zamaa gʊta a ya, an ta ʊ, bɩ hɔbɩrɛ ba ʊ kʊ ŋ n a bɩ y. Yeezuu n a karɩndanyɩnɔ wɔɔ bir, an a hɩ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Zamaa bɩ cicir ɩ mɔɔ zɛm, bala, ŋ dɔmɩm kaakʊ mɔɔ zi, bɩ, hɔbɩrɛ ba ŋ ʊ y. ");
INSERT INTO bib_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kʊ mɔɔ ŋ da zaa ra kan nɔ kɩ, ŋ y'a dundom zaa ra, bɩ gɔsɩnnɔ a to laatʊ.» ");
INSERT INTO bib_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Karɩndanyɩnɔ wɔɔ n a nyɩ bɔ nʊ, ŋ ʊ: «K'ʊ bur yɩ ka poohɔɔn ʊ naa ʊ, ʊ a ka ŋ ʊ, ŋn'a bɩ k'an ŋ ka?» ");
INSERT INTO bib_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeezuu n ŋ lar, a ʊ: «Bur karɔ n ta awɔɔ ʊ?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Saanhɩna» ");
INSERT INTO bib_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A n lɛ ka, a ʊ, ŋ n nyɩnta tara ʊ. A n bur saanhɩnarɔ wɔɔ gʊr, an a barka da ʊ, an n'a zɩnzɛ ra, an n'a kam a karɩndanyɩnɔ wɔɔ ʊ, ŋn'a kam zamaa b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Zɔnnyɩnɔ nyɩnta ŋ ʊ sɔ. Yeezuu n ŋ barka da ʊ, a ʊ: ŋ n a ka ŋ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ŋ n a bɩ, an ŋ ka. Ŋ n a kuuro gʊr kasɩ lɛ ma saanhɩna. ");
INSERT INTO bib_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Gʊɔɔ wɔɔ nyɩnta, ŋn'a zɔ tisi si ma. Bɩ jɛ ʊ bɩ, Yeezuu ŋ da zaa ra. ");
INSERT INTO bib_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Lɛɛm bɩ, a da kɔɔlʊʊ b'ʊ kan a karɩndanyɩnɔ wɔɔ kɩ, ŋn'ɩ tam Dalmanutaa zeezi. ");
INSERT INTO bib_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farizɛɛnrɔ bʊr, ŋn'a sɩŋŋɩda ba, ŋn'ɩ bɩsɩ kam kan Yeezuu kɩ, ŋn'a yɛ han, k'an hoser kʊ Woso a ka ʊ bɩ ba, k'a dɩga a, a y'a dam ma, an a ba gɛ. ");
INSERT INTO bib_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeezuu hoon gʊta si, an n'a hɩrɛ, a ʊ: «Bɔ minto her zamaana naa nɩ hoser yɛrɛ? Sɩra mɔɔ n'a hɩrɛ awɔɔ m, hoser ba ʊ mɔɔ n n'a bam awɔɔ zamaana naa do minto y.» ");
INSERT INTO bib_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A n a gʊ farizɛɛnrɔ wɔɔ ma, an aa da kɔɔlʊʊ b'ʊ, an bra gəm deem bɩ ra. ");
INSERT INTO bib_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Hinni bɩ do ʊ bɩ, bur sarɛ tɔ bɔ karɩndanyɩnɔ wɔɔ nɔ ʊ. Bur deem bala nɩ ŋ ʊ kɔɔlʊʊ bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeezuu lɛ ka ŋ ʊ, a ʊ: «K'a dundo a zi, k'a ba laatʊ farizɛɛnrɔ nyʊnyɔɔ bɩ ma, kan Hɩrɔɔdɩ hɔ bɩ kɩ ma sɔ.» ");
INSERT INTO bib_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ŋ n bɔkarɛ, ŋn'ɩ bɩsɩ kam kan kʊ kɩ, kʊ bur ba ŋ ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yeezuu n a ma, an n'a hɩrɛ ŋ nɩ, a ʊ: «Bɔ bɩsɩ awɔɔ n'a karɛ? Bur k'a ba awɔɔ ʊ bɩ minto m gɛ? Awɔɔ hɔɔn gɔɔta a n gu k'a jɩ dɔ ra? Awɔɔ heer ɩ ka gɛ? ");
INSERT INTO bib_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Awɔɔ mɩnyaarɔ kʊ ŋ nɩ ta ʊ bɩ, ŋ bɩr lɛɛ yɩm na? Awɔɔ tʊʊrɔ kʊ ŋ nɩ ta ʊ bɩ, ŋ bɩr mim mam na? ");
INSERT INTO bib_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kʊ mɔɔ bur soor zɩnzɛ ra, m a ka gʊaa tisi soor ʊ bɩ, a tɔ ba awɔɔ nɔ ʊ ra? Awɔɔ kuuro gʊr kasɩ lɛ ma karɔ?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Bueerehɩɩya.» ");
INSERT INTO bib_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Bɩ kʊ mɔɔ bur saanhɩna zɩnzɛ ra m a ka gʊaa tisi si ʊ bɩ, kasɩ lɛ ma karɔ awɔɔ kuuro gʊr ʊ?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Saanhɩna.» ");
INSERT INTO bib_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A n a hɩ ŋ nɩ, a ʊ: «Awɔɔ gɔɔta a n a dɔ, a ʊ, bur mim bɛɛ mɔɔ n'a hɩm ma ra?» ");
INSERT INTO bib_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ŋ lee ku Bɛtsayɩdaa ʊ, n n bʊr bʊʊ m Yeezuu zi, n n a yɛ han, k'an a wɔ da bʊʊ bɩ ma, k'an lɛɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","A n bʊʊ bɩ gaa a wɔ ma, an bɔ m bɔlɛɛma, an lihi da a mɩm ma, an a wɔ ka a mim la, an n'a larm, a ʊ: «Ɩbɩɩ ɩ hɔsɩ yɩm na?» ");
INSERT INTO bib_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","K'a mɩm bɩ gʊ bɩ, a a hɩ, a ʊ: «Mɔɔ ɩ gʊɔɔ yɩm, ɩ ʊ, gɔrɔ m, ŋn'ɩ tarɛ.» ");
INSERT INTO bib_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Bɩ, Yeezuu a ya, an a wɔ ka gʊaa bɩ mɩnyaarɔ wɔɔ ra. Gʊaa bɩ nɩ dɩgam ma sɩɩ…, an a waa, an nɩ lɛɛ yɩm mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yeezuu n a da a har zaa ra, a ʊ: «Ɩ b'a ka ɩ gasʊ kʊnɔ b'ʊ y!» ");
INSERT INTO bib_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yeezuu ɩ tam kan a karɩndanyɩnɔ wɔɔ kɩ Filipi-Sezaaree kʊrɔ jɩnjɛɛnnɔ wɔɔ nɔ ʊ. Zaa ra bɩ, a a karɩndanyɩnɔ wɔɔ lar, a ʊ: «Gʊɔɔ wɔɔ y'a hɩm, ŋ ʊ, nka m mɔɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Gɔsɩnnɔ ʊ: Zaan-Batiisi m, nawɔnnɔ ʊ: *Elii m, gɔsɩnnɔ ʊ: wosolɛsinnɩsorazaa deem m.» ");
INSERT INTO bib_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yeezuu n ŋ lar, a ʊ: «B'awɔɔ, awɔɔ y'a hɩrɛ, a ʊ: Nka m mɔɔ nɩ?» Pɩyɛɛr n meerbaa bɩ sa, an a nyɩ bɔ ʊ, a ʊ: «Krista n'ɩbɩɩ m.» ");
INSERT INTO bib_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","A n lɛ ka ŋ ʊ mɩŋŋa, a ʊ: ŋ b'awɔɔ mim bɩ hɩ gɔsɩ nɩ y. ");
INSERT INTO bib_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kɛɛrɛ bɩ, a n a sɩŋŋɩda ba, an n'a dɩndarɛ ŋ nɩ, a ʊ: pakra m, kʊ Gʊaanyɩ bɩ n cicir ba gʊta. Bɩ, gʊɔɔgusinno kan wosocɛmannɩbənno jɩtannɔ kɩ, kan wosocikarɩnsaambɔɔ kɩ kaanɩm nɩ, an ta kan a zɛrɛ kɩ, k'an a mɩm bɔ ʊ dɔmɩm kaakʊ hinni ʊ. ");
INSERT INTO bib_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A n minno nɔɔn duro nyaakʊm da an n'a hɩrɛ y. Pɩyɛɛr n a gaa an bɔ m toore ma, an nɩ nyaa bam kan Yeezuu kɩ, a ʊ: a n a ga m, an naa hɩ y. ");
INSERT INTO bib_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bɩ, Yeezuu k'a wusigə an dɩga a karɩndanyɩnɔ wɔɔ ma bɩ, a həən si Pɩyɛɛr ma, a ʊ: «Ɩ jɛ bɔ mɔɔ jɩr ʊ! Sʊtaana, ɩbɩɩ hɔɔndarɛ bɩ n bɔ kʊ ʊ kan Woso hɔ kɩ y. Gʊɔɔ hɔɔndarɛ m.» ");
INSERT INTO bib_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yeezuu n bɔkarɛ, an a karɩndanyɩnɔ bir kan zamaa bɩ kɩ, an a hɩ ŋ nɩ, a ʊ: «Kʊ gʊaa lɛ taa k'a zu mɔɔ ʊ, k'an a mɩŋŋa lɛtaamarɔ to, k'an a gɔdarkʊra busu, an zu mɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bala, gʊaa k'a a lɛ n taa k'a meeyaa bʊmbɔ bɩ, a b'a meeyaa bʊmbɔrɛ yɩrɛ y. Bɩ, kʊ gʊaa ga mɔɔ tɔ ma, kan lemim nyɩnta bɩ kɩ tɔ ma, a y'a meeyaa bʊmbɔrɛ yɩrɛ. ");
INSERT INTO bib_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bɩ, kʊ gʊaa a so durnya hɔ haay ʊ, an bɔkarɛ, an ga, a nyɔɔdʊ ɩ ka? ");
INSERT INTO bib_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bɔ gʊaa bɩ n n'a sam, k'a mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩ nɩ? ");
INSERT INTO bib_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bala, gʊaa k'a nɩ nyannɩ zɛm mɔɔ tɔ ma kan mɔɔ lemim nyɩnta bɩ kɩ tɔ ma, her zamaana jaandənno nɔɔn duro kan mimbʊnyaabənno nɔɔm kɩ bireyaa ʊ, Gʊaanyɩ bɩ b'a zaa nyannɩ zɛm, dɔmɩm k'a nɩ zɛŋ ʊ, kan malɛɛkarɔ mɩŋŋɔɔ kɩ, Woso lɛbɔʊrɛ nɔ ʊ kɩ b'ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yeezuu a ya, an a hɩ ŋ nɩ, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m: gʊɔɔ kʊ ŋ nɩ ta ʊ naa ʊ rɔ wɔɔ, gɔsɩnnɔ zɛ hinni b'a kure y, ŋn'ɩ Woso cirbəə bɩ zɛrɛ yɩm kan paŋŋa gʊta kɩ.» ");
INSERT INTO bib_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Dɔmɩm sɔrdɩ kur bɩ, Yeezuu Pɩyɛɛr, Zakkɩ kan Zaan kɩ gaa, an bɔ ŋ nɩ toore ma a minto ci jintə mim ʊ, an a lʊr ŋ mɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A huuro wɔɔ nɩ nyakɩ bɔm, gʊaa ba ʊ an b'a nyakɩ bɔrɛ bɩ makra barɛ y. ");
INSERT INTO bib_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","*Elii n a hɩnka ŋ nɩ kan Moyiisi kɩ, ŋn'ɩ meer bam kan Yeezuu kɩ. ");
INSERT INTO bib_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pɩyɛɛr n a hɩ Yeezuu m, a ʊ: «Karɩnsaamba, kʊ wɔɔ ɩ naa ʊ, a mɩŋŋa. K'ʊ bur ba kaakʊ: ɩbɩɩ hɔ deem, Moyiisi hɔ deem, Elii hɔ deem.» ");
INSERT INTO bib_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Dabɔʊ ŋ haay nyasʊ. Bɩ y'a ka, Pɩyɛɛr n a dɔ kʊ bɔ an n'a hɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Warkʊ bʊr an b'a ku ŋ la, meerbaa n a to warkʊ bɩ nɔ ʊ, a ʊ: «Mɔɔ Nyɩ kʊ mɔɔ ŋʊa bɩ n naa do, k'a tʊr ka ma.» ");
INSERT INTO bib_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Lɛɛm bɩ, a bɔ kʊ ŋ y'a ʊ, ŋnɩ dɩga a jɩr ʊ bɩ, ŋ n gɔsɩ yɩ kʊ Yeezuu bɛɛ m a deem kan ŋ kɩ y. ");
INSERT INTO bib_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kʊ ŋ n'ɩ zerm ci bɩ ra bɩ, a lɛ ka ŋ ʊ, a ʊ: «hɔ kʊ ŋbɔɔ n a yɩ bɩ, ŋ b'a hɩ gɔsɩ nɩ y, k'an ta, an Gʊaanyɩ bɩ mɩmbɔʊrɛ dɔmɩm ku gəəno bire ʊ. ");
INSERT INTO bib_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ŋ lɛ naa do si, bɩ, ŋ y'a mɩŋŋa larm: ‹Mɩmbɔʊrɛ gəəno bire ʊ bɩ mim bɩ ma.› » ");
INSERT INTO bib_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","A karɩndanyɩnɔ wɔɔ n a lar, ŋ ʊ: «Bɔ minto wosocikarɩnsaambɔɔ wɔɔ ʊ, kʊ Elii n lɛɛ ka an bʊr Krista m gɛ?» ");
INSERT INTO bib_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Sɩra m, Elii nɩ lɛɛ karɛ an bʊr k'a bɩ hɔ haay banka. Bɩ, kɛɛrɛ bɩ, a m lɔ, ŋn'a gʊrsɩra ba ŋ ʊ: Gʊaanyɩ bɩ bɔʊrɛ yɩm b'a fɩr yɩm gʊta gɛ? ");
INSERT INTO bib_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, Elii bʊr, bɩ ŋ y'a hɔɔnhɔ ba m, amba hɔ kʊ ŋ y'a gʊrsɩra ba a minto bɩ m.» ");
INSERT INTO bib_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kʊ Yeezuu a wusigə kan karɩndanyɩnɔ kaakʊrɔ wɔɔ kɩ, ŋn'ɩ tam karɩndanyɩnɔ gɔsɩnnɔ wɔɔ zi bɩ, ŋ zamaa cir gʊta yɩ kan wosocikarɩnsaambɔɔ kɩ, ŋn'ɩ bɩsɩ kam kan ŋ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Zamaa bɩ k'a Yeezuu yɩ bɩ, ŋ zɛ kədə, ŋnɩ bra si, ŋn'ɩ tam k'a yaa daʊrɛ yaa da m. ");
INSERT INTO bib_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A n karɩndanyɩnɔ wɔɔ lar, a ʊ: «Bɔ bɩsɩ awɔɔ n'a kam kan ŋ kɩ?» ");
INSERT INTO bib_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Gʊaa n a to zamaa bɩ bire ʊ, an a nyɩ bɔ ʊ, a ʊ: karɩnsaamba, bʊr mɔɔ ʊ, m nyɩ m ɩbɩɩ zi, zinə n ta m, an a ba bəətir. ");
INSERT INTO bib_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","K'a wuti ma bɩncɛ bɩ do ʊ, a do an nawʊm b'ʊ, an lihihur ta a lɛ rɛ, an n'a sɔ sʊrɛ, a mɛ bɩ n a ba taŋŋɩ-taŋŋɩ. Mɔɔ n a yɛ ɩbɩɩ karɩndanyɩnɔ wɔɔ han kʊ ŋ nɩ la zinə bɩ ra, bɩ ŋ n a da ma y. ");
INSERT INTO bib_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Do sɩrakarɛ war zannɔ, mɔɔ dɔmɩm karɔ bam kan awɔɔ kɩ? Kʊ m nyasʊ awɔɔ m dɔmɩm karɔ? K'a nyɩ bɩ gaa, a bʊr m mɔɔ zi.» ");
INSERT INTO bib_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ŋ n a gaa, ŋnɩ ta m. Nyɩ bɩ k'a Yeezuu yɩ lɛɛm bɩ, zinə bɩ n a hinkə, an a do tara ʊ, an nɩ pɩr kam, an nɩ lihi bɔrɛ a rɛ. ");
INSERT INTO bib_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yeezuu n a zɩ bɩ lar, a ʊ: «Yaaba b'a sɩŋŋɩda ba brɔ an nɩ nyɩ bɩ ma?» A ʊ: «A nyɩbaa ma. ");
INSERT INTO bib_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Dɔmɩm niŋŋoo ʊ, a a zɛ, an a da sɛ ʊ, gɛɛ hi ʊ k'an ga. Bɩ, k'ɩbɩɩ y'ɩ dam hɔsɩ ma, k'ɩ da wɔɔ han, ɩ cicirzɛrɛ minto.» ");
INSERT INTO bib_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yeezuu n a hɩ m, a ʊ: «Bɔ minto ɩ n'a hɩrɛ, ɩ ʊ: k'ɩ y'ɩ dam ma! Hɔ woo… a da ma an ba sɩrakarɛzaa m.» ");
INSERT INTO bib_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lɛɛm bɩ, nyɩ bɩ zɩ bɩ n zee da, a ʊ: «Mɔɔ sɩra ka, mɔɔ cicir zɛ, m sɩrakarɛ war bɩ minto!» ");
INSERT INTO bib_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yeezuu k'a zamaa bɩ yɩ ŋn'ɩ zɛm gʊta bɩ, a həən si zinə bɩ ma, a ʊ: «Zinə, ɩbɩɩ n nɩ gʊaa bam bəətir, ɩ n n'a bam tikki, bɔ nyɩ naa do mɛ ʊ, bɩ, ɩ b'ɩ ya ɩ gasʊ y!» ");
INSERT INTO bib_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Zinə bɩ n nyɩ bɩ hinkə kan paŋŋa kɩ, an bɔ a mɛ ʊ kan zee kɩ. Nyɩ bɩ n gɔɔta am gər hɔ bɩ m. Gʊɔɔ n'a hɩrɛ, ŋ ʊ: «Ga a ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bɩ, Yeezuu a sa a wɔ ma, an a busu, an a jɩm brama. ");
INSERT INTO bib_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kʊ Yeezuu gasʊ har ʊ bɩ, a karɩndanyɩnɔ wɔɔ a lar a deem, ŋ ʊ: «Bɔ minto y'a ka wɔɔ n ʊ da ma, ʊ la zinə bɩ ra?» ");
INSERT INTO bib_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A n a nyɩ bɔ ʊ, a ʊ: «Zinə ncɩnaaʊ do bɩ, hɔ ba ʊ, an b'a dam ma an a ka, an bɔ, kʊ yaadarɛ bɛɛ y.» ");
INSERT INTO bib_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yeezuu k'a cem kan a karɩndanyɩnɔ kɩ b'ʊ bɩ, ŋ bra Galilee ʊ, Yeezuu n a ŋʊa kʊ n n a dɔ y. ");
INSERT INTO bib_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Bala, a nyɩnta an nɩ hɔ dɩndam a karɩndanyɩnɔ wɔɔ m, a ʊ: «N Gʊaanyɩ bɩ nyasʊm, ŋn'a ka gʊɔɔ ʊ, ŋn'a zɛ, b'a zɛ bɩ kur bɩ dɔmɩm kaakʊ hinni ʊ, a y'a mɩm bɔŋ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bɩ, a karɩndanyɩnɔ wɔɔ n nyɩnta ŋ n'a jɩ dɔrɛ y, b'a larlɛ nyibəə ta ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ŋ yaa lee ku Kapɛrnawum ʊ. Gasʊ kʊ ŋ y'a ʊ har ʊ bɩ, Yeezuu ŋ lar, a ʊ: «Bɔ bɩsɩ awɔɔ n'a kam zaa ra bɩ?» ");
INSERT INTO bib_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ŋ n zɛ pi, bala, zaa ra bɩ, ŋ bʊgʊr ba kʊ ma jɩtambaa minto. ");
INSERT INTO bib_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yeezuu n nyɩnta, an gʊaa bueerehɩɩya bɩ bir, an a hɩ ŋ nɩ, a ʊ: «Kʊ gʊaa lɛ taa k'a bɩr jɩtaarɛ, k'an bɩr gʊaa haay jɛzaa, k'an bɩr gʊaa haay zibəənyɩ.» ");
INSERT INTO bib_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A n nyɩ gaa, an a jɩm ŋ bire ʊ, an a wɔ burgu ma, an a hɩ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Gʊaa k'a nyɩnɔ nɔɔm gʊaa deem da ʊ bɩ, a ba a ʊ mɔɔ m. Bɩ gʊaa k'a mɔɔ da ʊ bɩ, a n mɔɔ da ʊ m deem y, Zɩ k'a mɔɔ nyɔɔ b'a da ʊ sɔ.» ");
INSERT INTO bib_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zaan n a hɩ Yeezuu m, a ʊ: «Karɩnsaamba, wɔɔ gʊaa yɩ, an nɩ lam zinəro ra ɩbɩɩ tɔ m, wɔɔ k'ʊ a gʊ ma k'a bɩr zum kʊ ʊ kan wɔɔ kɩ bɩ minto.» ");
INSERT INTO bib_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yeezuu n a hɩ ŋ nɩ, a ʊ: «A b'a gʊ ma y, bala, gʊaa ba ʊ, an nɩ lam zinəro ra mɔɔ tɔ m, an a ya, an mɔɔ tɔ zar y. ");
INSERT INTO bib_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Gʊaa k'a bɩr jɩm bam kan wɔɔ kɩ y, wɔɔ gʊaa m. ");
INSERT INTO bib_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, gʊaa k'a hi ka awɔɔ ʊ poore a mi, kʊ mɔɔ gʊɔɔ n'awɔɔ m bɩ minto, a zaa bɩ kʊrɔm a ganwʊrɛ ma y. ");
INSERT INTO bib_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kʊ gʊaa a ka nyɩnɔ kʊ ŋ sɩra ka mɔɔ ʊ rɔ nɔɔn duro gʊaa deem n'a do mimbʊnyaa nɔ ʊ, kʊ n jɛnlajaa gʊta kʊsɩ a wer ma, n n a da higʊta ʊ, a jɩra. ");
INSERT INTO bib_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","K'ɩ wɔ y'ɩ dam mimbʊnyaa barɛ ma, k'ɩ zɛ ra, k'ɩ gasʊ ɩ wɔ deem m mɩsɩrbaa k'a nyarɛ ba ʊ b'ʊ, bɩ jɩra, gasʊ k'ɩbɩɩ nawʊm ɩ wɔ hɩɩya m sɛhar k'a lihire ba ʊ bɩ nɔ ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","K'ɩ gam y'ɩ dam mimbʊnyaa barɛ ma, k'ɩ zɛ ra, k'ɩ gasʊ ɩ gam deem m mɩsɩrbaa k'a nyarɛ ba ʊ b'ʊ, bɩ jɩra, gasʊ k'ɩbɩɩ nawʊm ɩ gam hɩɩya m sɛhar ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","K'ɩ mɩnyaa y'ɩ dam mimbʊnyaa barɛ ma, k'ɩ bɔ ʊ, k'ɩ gasʊ ɩ mɩnyaa deem m, Woso cirbəə b'ʊ, bɩ jɩra, k'ɩ gasʊ ɩ mɩm hɩɩya m sɛhar ʊ bɩ m, ");
INSERT INTO bib_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","bɩncɛ kʊ mukuno bɩr gɩngaŋ ʊ, sɛ bɩr lihiŋ ʊ sɔ y. ");
INSERT INTO bib_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Bala, n sɛ sam, n nɩ yɛ da gʊaa haay ma. ");
INSERT INTO bib_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yɛ naa, hɔ mɩŋŋa m. Bɩ kʊ yɛ b'a nyɩntabaa nɩ y, k'a banka bɔ nɩ? K'a ka kʊ yɛ n bɩr ta a ma, k'a nyɩnta kan kʊ kɩ laafɩɩ.» ");
INSERT INTO bib_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeezuu a hʊr b'ʊ, an ta Zidee ʊ, Zʊrdɛn kur, zamaa n a ya, an a so kʊ ma a jɩr ʊ, an a ya, an nɩ hɔ dɩndarɛ ŋ nɩ, am dɔmɩm haay hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farizɛɛnrɔ n a zɔ k'a nyasʊ meerbaa nɔ ʊ. Bɩ minto y'a ka, ŋn'a larlɛ, ŋ ʊ: «Yar a da ma an la a lʊ ra gɛ?» ");
INSERT INTO bib_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A n a nyɩ bɔ ʊ, a ʊ: «Bɔ Moyiisi a gʊrsɩra ba awɔɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Moyiisi ʊ, n n harcɩntarɛ kaansʊrɛ ci ba, kʊ n n bɔkarɛ, n n la lʊ ra.» ");
INSERT INTO bib_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Awɔɔ heerkarɛ minto y'a ka, an lɛ naa do gʊrsɩra ba. ");
INSERT INTO bib_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Durnya sɩŋŋɩda ma bɩ, Woso yar da kan lʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Bɩ minto y'a ka, yar n n'a gʊm a zɩ ma kan a da kɩ, k'a nyɩnta kan a lʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Bɩ, ŋ gʊaa hɩɩya bɩ y'a bam mɛsim deem. Ncɩnaaʊ bɩ, ŋ bɩ gʊaa hɩɩya dɔ y, mɛsim deem zannɔ m. ");
INSERT INTO bib_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hɔ kʊ Woso a zɛ kʊ ra bɩ, a b'a ka gʊaa n a gʊngʊ kʊ ma y.» ");
INSERT INTO bib_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kʊ ŋ y'a bɔ, ŋnɩ doo har ʊ bɩ, karɩndanyɩnɔ wɔɔ a ya, ŋn'a lar mim naa do jɩ ma. ");
INSERT INTO bib_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A n a hɩ ŋ nɩ, a ʊ: «Gʊaa k'a la a lʊ ra, an a vanta sa bɩ, jaan an n'a dam kan bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bɩ, kʊ lʊ a gʊ a zim ma, an a vanta sa, jaan an n'a dam kan bɩ kɩ sɔ.» ");
INSERT INTO bib_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Gʊɔɔ bʊr nyɩnɔ poorero m Yeezuu zi, ŋn'a yɛ han k'an a wɔ da ŋ ma, b'a karɩndanyɩnɔ wɔɔ n yɛ gʊɔɔ wɔɔ nɩ y. ");
INSERT INTO bib_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yeezuu k'a naa yɩ bɩ, a nɔ ma ʊ, an a hɩ ŋ nɩ, a ʊ: «K'a nyɩnɔ wɔɔ to ŋnɩ bʊr mɔɔ zi, a b'a ta ŋ nɩ tolle y, bala, gʊɔɔ kʊ ŋ bɔ kʊ ʊ kan nawɔnnɔ kɩ rɔ wɔɔ, ŋ hɔ m Woso cirbəə bɩ m. ");
INSERT INTO bib_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, gʊaa k'a n Woso cirbəə bɩ si am nyɩ poore hɔ bɩ m bɩ, a bɩ gasʊŋ ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bɩ kur bɩ, a a wɔ burgu ŋ ma, an a wɔ ka ŋ mim la, an nɩ ŋ barka daŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kʊ Yeezuu kan a karɩndanyɩnɔ wɔɔ kɩ zaa sa, ŋn'ɩ tam bɩ, gʊaa n a si, an bɩ kukurə zɛ a taa, an a yɛ han, a ʊ: «Karɩnsaamba mɩŋŋa, bɔ mɔɔ m ga m, m a ba, kʊ m mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩ?» ");
INSERT INTO bib_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yeezuu n a hɩ m, a ʊ: «Bɔ minto, ɩ n nɩ mɔɔ birm mɩŋŋa? Gʊaa mɩŋŋa ba ʊ kʊ Woso deem bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ɩbɩɩ Woso lɛrɔ wɔɔ dɔ. ‹Ɩ bɩ gʊaa zɛ y, ɩ bɩ jaan da y, ɩ bɩ koor ba y, ɩ bɩ ŋʊaar ba y, ɩ b'ɩ hɔɔn da gʊaa hɔ ma k'an yɩ ɩ hɔ y, ɩ zɩ kan ɩ da kɩ da ʊ.› » ");
INSERT INTO bib_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Gʊaa bɩ n a hɩ m, a ʊ: «Karɩnsaamba, mɔɔ naa haay sɩŋŋɩda sa m nyɩbaa ma, m n'a barɛ.» ");
INSERT INTO bib_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yeezuu n dɩga gʊaa bɩ ma, an a ŋʊa, an a hɩ m, a ʊ: «Hɔ deem ɩ jɩra ɩbɩɩ ma: ta, hɔ k'a n'ɩbɩɩ ʊ bɩ hɛɛ haay, ɩ jir ŋʊazannɔ m. Ɩbɩɩ yaa arzaka yɩ Woso zi, k'ɩ bʊr ɩ zu mɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yeezuu k'a naa hɩ bɩ, gʊaa bɩ heer a zar gʊta, an a hʊr kan heerzarlɛ kɩ, bala, a arzaka nyɩnta ʊ gʊta. ");
INSERT INTO bib_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yeezuu k'a dɩga a jɩr ʊ bɩ, a a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «Woso cirbəə gasʊʊrɛ nyɩntam arzakazannɔ ma kaŋŋɩda!» ");
INSERT INTO bib_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A karɩndanyɩnɔ wɔɔ zɛ kədə a meer naa do barɛ minto. Yeezuu n a ya, an so ra, a ʊ: «M danyɩnɔ, Woso cirbəə gasʊʊrɛ kɔɔkɔɔ. ");
INSERT INTO bib_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yoonde gasʊ huuka yaa m nyɩntam zanta an lɛ da arzakazaa gasʊ Woso cirbəə ʊ m.» ");
INSERT INTO bib_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Karɩndanyɩnɔ wɔɔ a ya ŋnɩ zɛ kədə an lɛ da, ŋn'a hɩm kʊ m, ŋ ʊ: «Nka n nɩ bɔm lɛ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeezuu n dɩga ŋ ma, a ʊ: «Gʊaa b'a dam ma, an a mɩŋŋa bʊmbɔ y, bɩ Woso y'a da hɔ haay ma.» ");
INSERT INTO bib_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pɩyɛɛr n a hɩ m, a ʊ: «Dɩga, wɔɔ hɔ haay to, k'ʊ zu ɩbɩɩ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeezuu n a hɩ Pɩyɛɛr m, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m, kʊ gʊaa a gʊ a har, kan a zɩ kɩ, a da kɩ, a dakumbonno kɩ, a danlʊrɔ kɩ, a nyɩnɔ kɩ, a tara kɩ ma mɔɔ minto kan lemim nyɩnta bɩ minto kɩ, ");
INSERT INTO bib_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","a zaa har, kan da kɩ, dakumbonno kɩ, danlʊrɔ kɩ, nyɩnɔ kɩ, tara kɩ yɩm gallɛm zɔrɔ dɔmɩnnɔ nɔɔn duro ʊ, kan fɩryɩrɛ kɩ. Durnya k'a nɩ zɛm bɩ nɔ ʊ, a mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩm sɔ. ");
INSERT INTO bib_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lɛɛkarɛzannɔ gʊta nyɩntam jɛzannɔ, jɛzannɔ nyɩntam lɛɛkarɛzannɔ.» ");
INSERT INTO bib_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ŋ y'a hʊr, ŋnɩ zaa sa ŋn'ɩ tam Zerizalɛm ʊ. Yeezuu nɩ tarɛ ŋ lɛɛ. Dabɔʊ a karɩndanyɩnɔ wɔɔ nyasʊ, nyibəə gʊɔɔ kʊ ŋ zu kʊ ʊ kan ŋ kɩ rɔ wɔɔ nyasʊ. Yeezuu a ya, an bueerehɩɩyɔɔ wɔɔ bir a jɩr ʊ, an nɩ mim k'a nɩ zɛm k'a bɩ ba m bɩ hɩrɛ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«K'a dɩga, ta kʊ wɔɔ nawʊm Zerizalɛm ʊ naa, n yaa Gʊaanyɩ bɩ nyasʊ n a ka wosocɛmannɩbənno jɩtannɔ ʊ kan wosocikarɩnsaambɔɔ kɩ ʊ. Ŋ y'a dʊdɔ yarlɛ k'a zɛ gər, ŋn'a da do vantɔɔ gʊɔɔ wɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ŋ yaa wʊm ma, ŋ lihi dam ma, ŋ y'a zɛm madɩɩrɔ m, ŋ y'a zɛrɛ an ga, bɩ, dɔmɩm kaakʊ hinni ʊ, a y'a mɩm bɔŋ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedee nyɩnɔ Zakkɩ kan Zaan kɩ a zɔ Yeezuu ma, ŋn'a hɩ m, ŋ ʊ: «Karɩnsaamba, hɔ kʊ wɔɔ n'a yɛrɛ ɩbɩɩ han naa ma bɩ, ɩ bɩ zɛ wɔɔ m ma y.» ");
INSERT INTO bib_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A n a hɩ ŋ nɩ, a ʊ: «Bɔ awɔɔ lɛ n taa kʊ mɔɔ n a ba awɔɔ minto?» ");
INSERT INTO bib_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ŋ n a hɩ m, ŋ ʊ: «K'ʊ a yɛ ɩbɩɩ han, ɩbɩɩ cirbəə bɩncɛ ʊ, k'ɩ ka kʊ wɔɔ gʊaa deem n nyɩnta ɩbɩɩ bɩsɩ, deem ɩbɩɩ jɩsa.» ");
INSERT INTO bib_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Awɔɔ n hɔ k'a n'a yɛm bɩ dɔ y. Awɔɔ a da ma, a hɔ kʊ mɔɔ n n'a mim laaga ʊ bɩ mi ra? Gɛɛ awɔɔ a da ma a fɩryɩrɛ kʊ mɔɔ n n'a yɩm bɩ yɩ ra?» ");
INSERT INTO bib_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Wɔɔ ʊ da ma.» Yeezuu n a hɩ ŋ nɩ, a ʊ: «Laaga hɔ kʊ mɔɔ n n'a mim bɩ, awɔɔ y'a mim, fɩr kʊ mɔɔ n n'a yɩm bɩ, awɔɔ y'a yɩm sɔ, ");
INSERT INTO bib_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","bɩ, k'a gɔɔta mɔɔ jɩsa kan mɔɔ bɩsɩ bɩ kɩ nyɩntarɛ nɩ, mɔɔ n m da ma m zaa ka y, bala, mɔɔ n m so ʊ y. Bɩncɛ bɩ banka Woso ʊ ŋ zannɔ minto.» ");
INSERT INTO bib_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Karɩndanyɩnɔ buro wɔɔ kʊ ŋ naa ma bɩ, ŋ nɔ ma ʊ kan Zakkɩ kɩ, Zaan kɩ. ");
INSERT INTO bib_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yeezuu n ŋ bir, an a hɩ ŋ nɩ, a ʊ: «Awɔɔ dɔ, a ʊ: gʊɔɔ k'awɔɔ nɩ dɩgarɛ ŋ ma cinno wɔɔ, brɔɔ nɩ paŋŋa barɛ a kʊrɔ ma, paŋŋazannɔ n'a hɔɔnhɔ barɛ a gʊɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","B'a bɩ nyɩntarɛ ncɩnaaʊ awɔɔ bire ʊ y. Bɩ, kʊ gʊaa lɛ taa k'a bɩr jɩtaarɛ awɔɔ bire ʊ, k'an a ba zibəənyɩ. ");
INSERT INTO bib_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Bɩ, kʊ gʊaa lɛ taa k'a bɩr lɛɛkarɛzaa awɔɔ bire ʊ, k'an a ba awɔɔ haay lɔ. ");
INSERT INTO bib_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bala, Gʊaanyɩ bɩ n bʊr kʊ gʊɔɔ n b'a hɔɔnhɔ ba y, bʊr a ʊ k'a b'a da gʊɔɔ han, k'a a mɩsɩrbaa ka gʊɔɔ gʊta bʊmbɔrɛ minto.» ");
INSERT INTO bib_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yeezuu kan a karɩndanyɩnɔ wɔɔ kɩ, zamaa bɩ kɩ yaa lee ku Zeriko ʊ. Kʊ ŋ nɩ bɔm kʊnɔ ʊ b'ʊ bɩ, bʊʊ ɩ nyɩnta zaa lezi b'ʊ, a tɔ m Bartimee, Time nyɩ m, an nɩ hɔ yɩnyɛm. ");
INSERT INTO bib_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","K'a a ma ŋ ʊ: Nazarɛtɩ Yeezuu m bɩ, an nɩ zee darɛ, a ʊ: «*Davɩd Nyɩ, mɔɔ cicir zɛ!» ");
INSERT INTO bib_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gʊɔɔ wɔɔ nɩ bʊgʊr bam ma, ŋ ʊ, an a tʊr ka, b'a a banka, an a da ra: «*Davɩd Nyɩ, mɔɔ cicir zɛ!» ");
INSERT INTO bib_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yeezuu n jɩm, an a hɩ, a ʊ: «K'a bir!» N n a bir, n n a hɩ m, n ʊ: «Ɩ tɔ ʊ, wuti, a y'ɩ birm.» ");
INSERT INTO bib_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bʊʊ bɩ n a gɔbga bɔ a ra, an a zo, an wuti kan bra kɩ, an bʊr Yeezuu zi. ");
INSERT INTO bib_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeezuu n a lar, a ʊ: «Ɩbɩɩ lɛ n taa kʊ m bɔ ba ɩ nɩ?» Bʊʊ bɩ n a nyɩ bɔ ʊ, a ʊ: «Karɩnsaamba, a ka kʊ m m ya, m lɛɛ yɩ.» ");
INSERT INTO bib_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeezuu n a hɩ m, a ʊ: «Ta, ɩ sɩrakarɛ ɩ bʊmbɔ.» Lɛɛm bɩ, a mɩnyaa ɩ lɛɛ yɩm, an zu Yeezuu ʊ, an nɩ tam. ");
INSERT INTO bib_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kʊ ŋ n'a zɔm Zerizalɛm ma, Bɛtfazee kan Betanii kɩ jɩr ʊ, ci kʊ n n'a birm Oliviyee ci bɩ zeezi bɩ, Yeezuu a karɩndanyɩnɔ nyɔɔ hɩɩya, ");
INSERT INTO bib_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","an a hɩ ŋ nɩ, a ʊ: «K'a ta kʊ k'a n'awɔɔ lɛɛ naa ʊ. Bɩ, k'awɔɔ yaa gasʊ b'ʊ lɛɛm nɩ, awɔɔ brapoo yɩm, n n a kʊsɩ, bɩ gʊaa n da ʊ cɩna y. K'a hʊr a bʊr m. ");
INSERT INTO bib_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kʊ gʊaa awɔɔ lar, a ʊ: bɔ minto m awɔɔ nɩ naa barɛ, k'a hɩ m, a ʊ: Zuuba lɛ n taa, a y'a tore awɔɔ m bʊr m lɛɛm.» ");
INSERT INTO bib_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Karɩndanyɩnɔ wɔɔ n ta, ŋ n'aa brapoo yɩ, n n a kʊsɩ tɩnsara harlɛ ma zaa lɛ zi, karɩndanyɩnɔ wɔɔ n a hʊr. ");
INSERT INTO bib_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Gʊɔɔ kʊ ŋ nyɩnta b'ʊ rɔ wɔɔ gɔsɩnnɔ ŋ lar, ŋ ʊ: «Bɔ m, awɔɔ n nɩ brapoo bɩ hʊrlɛ?» ");
INSERT INTO bib_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ŋ n a nyɩ bɔ ʊ, amba Yeezuu a hɩ bɩ m, gʊɔɔ wɔɔ n ŋ to, ŋn'a hʊr. ");
INSERT INTO bib_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ŋ n ta brapoo bɩ m Yeezuu zi, ŋn'a huuro ka brapoo bɩ ra, Yeezuu n da ʊ. ");
INSERT INTO bib_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gʊɔɔ gʊta n a huuro ka zaa bɩ ra, gɔsɩnnɔ n gɔ lɛɛ yɩnyar hɔsɩrarɔ ʊ, ŋn'a ka ra. ");
INSERT INTO bib_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bɔɔ nɩ Yeezuu lɛɛ, kan bɔɔ n'a kur lɔ wɔɔ kɩ ɩ zee dam, ŋ ʊ: «*Hozaana! Kʊ gʊaa k'a nɩ zɛm Zuuba tɔ ma bɩ n barka yɩ! ");
INSERT INTO bib_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kʊ cirbəə k'a nɩ zɛm naa n barka yɩ, am wɔɔ yaaba Davɩd hɔ bɩ m. *Hozaana! K'ɩ tɔ n lɛbɔʊrɛ yɩ brama.» ");
INSERT INTO bib_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","A n gasʊ Zerizalɛm ʊ, Wosocɛ ʊ. K'a dɩga hɔ haay ma bɩ, a a hʊr an ta Betanii ʊ kan bueerehɩɩyɔɔ wɔɔ kɩ, kʊ gum da bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A dɔ k'a mɛ ŋn'ɩ bɔm Betanii ʊ bɩ, nɔ Yeezuu nyasʊ. ");
INSERT INTO bib_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A n a to, an sɔɔn yɩ laatʊ a lɛɛ n ta ʊ, an ta kan a karɩndanyɩnɔ wɔɔ kɩ, k'a yaa dɩga a hɔsɩ nyɩntaŋ ʊ gɛ. A zɔ k'a ʊ sɔɔn bɩ ma bɩ, a lɛɛ a yɩ, bala, sɔɔn bɔɔnrɛ dɔmɩm bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","A n a hɩ sɔɔn bɩ m, a ʊ: «Gʊaa b'a yarɛ an ɩbɩɩ nyɩ bɩ dɔ y!» A karɩndanyɩnɔ wɔɔ n a ma. ");
INSERT INTO bib_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yeezuu yaa lee ku Zerizalɛm ʊ kan a karɩndanyɩnɔ kɩ. Gasʊ kʊ Yeezuu ʊ Wosocɛ ʊ b'ʊ bɩ, a a sɩŋŋɩda ba, an nɩ lam gʊɔɔ kʊ ŋ nɩ hɔ hɛɛnm, ŋn'ɩ hɔ sim nɔ wɔɔ ra Wosocɛ hallu ʊ b'ʊ. A busoolʊrlɛzannɔ mɔdrɔkuntərehɔɔ hɩnhɩsɩga kan cirpʊnnɔ hɛɛnno nyɩntaragɔrɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Bɩ, a n gɔsɩ to an nɩ cenim mɔr m Wosocɛ hallu ʊ b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A n n'a hɩrɛ ŋ nɩ hɔdɩndarɛ nɔ ʊ, a ʊ: «N y'a gʊrsɩra ba, n ʊ: ‹N mɔɔ cɛ bɩ birm yaadarɛ cɛ, do haay minto.› Awɔɔ n bɔkarɛ a sa, a ba konno bɩncɛ.» ");
INSERT INTO bib_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kʊ Yeezuu naa hɩ wosocɛmannɩbənno jɩtannɔ kan wosocikarɩnsaambɔɔ wɔɔ kɩ n a ma bɩ, ŋ y'a karɛ a zɛrɛ zaa ma. Bɩ, ŋ yɩ nyi bam. Bala, zamaa b'a lɛ bɔ Yeezuu hɔdɩndarɛ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yirbəə k'a da bɩ, Yeezuu bɔ tara bɩ nɔ ʊ, kan a karɩndanyɩnɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","A dɔ k'a mɛ Yeezuu kan a karɩndanyɩnɔ wɔɔ kɩ nɩ cenim bɩ, ŋ sɔɔn bɩ yɩ, an ga kan a məsi kɩ. ");
INSERT INTO bib_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pɩyɛɛr n hɔ kʊ Yeezuu a hɩ bɩ tɔ da a nɔ ʊ, a a hɩ, a ʊ: «Dɩga, Zuuba, sɔɔn k'ɩbɩɩ ɩ lɛ da ʊ bɩ ga haay!» ");
INSERT INTO bib_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a sɩra ka Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, kʊ gʊaa a hɩ ci naa do m: ‹Ɩ bɔɔta, ɩ ɩ da kɔ ʊ,› bɩ bɩsɩkarɛ ba a heer ʊ, k'a a sɩra ka, a ʊ: hɔ k'awɔɔ hɩ bɩ barɛ, a bam, amba a a hɩ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Bɩ y'a ka mɔɔ n'a hɩrɛ awɔɔ m: hɔ k'awɔɔ n'a yɛm a yaadarɛ nɔ ʊ bɩ, k'a sɩra ka, a ʊ, awɔɔ yɩ, bɩ n y'a karɛ awɔɔ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Bɩ k'awɔɔ jɩm brama, an nɩ yaa dam, kʊ hɔ y'awɔɔ heer ʊ kan gʊaa kɩ, k'a sugur ka ʊ, k'awɔɔ Zɩ k'a nɩ arzana ʊ bɩ n awɔɔ kʊrɔmarɔ sugur ka awɔɔ ʊ sɔ.  ");
INSERT INTO bib_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bɩ k'awɔɔ n sugur ka a muno ʊ, awɔɔ Zɩ k'a nɩ arzana ʊ bɩ b'awɔɔ kʊrɔmarɔ wɔɔ sugur karɛ y.» ");
INSERT INTO bib_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yeezuu kan a karɩndanyɩnɔ wɔɔ kɩ a ya, ŋnɩ ta Zerizalɛm ʊ. Yeezuu k'a nɩ bɩmbɩrm Wosocɛ ʊ b'ʊ bɩ, wosocɛmannɩbənno jɩtannɔ kan wosocikarɩnsaambɔɔ wɔɔ kɩ, gʊɔɔgusinno kɩ bʊr zi, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«Nka ɩ lɛ ka ɩbɩɩ ʊ naa barɛ minto? Nka ɩ zaa ka?» ");
INSERT INTO bib_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Kʊ m awɔɔ lar mim deem ma, k'a nyɩ bɔ ʊ, kʊ m bɔkarɛ, m bɩncɛ kʊ n lɛ ka mɔɔ ʊ bɩ hɩ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Batɛm kʊ Zaan nyɩnta an n'a kam bɩ, a to a ʊ Woso zi gɛɛ, gʊɔɔ zi? K'a nyɩ bɔ ʊ!» ");
INSERT INTO bib_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ŋ n'ɩ bɩsɩ kɩnkam kʊ ma, ŋ ʊ: «Kʊ wɔɔ ʊ: a to a ʊ Woso zi, a y'a hɩrɛ a ʊ: bɔ minto m wɔɔ n a mim si gɛ? ");
INSERT INTO bib_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bɩ kʊ wɔɔ ʊ: a to a ʊ gʊɔɔ zi, zamaa bɩ bɩ yɛrɛ y. Kʊ zamaa bɩ Zaan dɔ wosolɛsinnɩsorazaa paan… bɩ minto.» ");
INSERT INTO bib_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ŋ n a nyɩ bɔ ʊ Yeezuu m, ŋ ʊ: «Wɔɔ n a dɔ y.» Yeezuu n a hɩ ŋ nɩ, a ʊ: «Bɩ minto bɩ, mɔɔ bɩ bɩncɛ niŋŋə kʊ n lɛ ka mɔɔ ʊ bɩ hɩrɛ awɔɔ m sɔ y.» ");
INSERT INTO bib_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yeezuu n a sɩŋŋɩda ba, an nɩ meer bam kan ŋ kɩ hɔbɔkʊrɛnoom darɛ m, a ʊ: «Gʊaa ɩ nyɩnta an dɩvɛn gɔ sɔɔn, an lambaar da ma, an yaa hɔn, k'a bɩr dɩvɛn nyɩ bɩ hi bɔŋ ʊ, an bɛŋŋʊ dɔ sɔ, an gʊɔɔ sa kʊ ŋ n dɔ dɩvɛnsɩra bɩ ma, an a hʊr an ta zaa ra. ");
INSERT INTO bib_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Dɩvɛn mɔsa k'a a ku bɩ, a n a zibəənyɩ deem nyɔɔ wutu zibəəzannɔ wɔɔ zi, k'an aa a hɔ si, an b'a ka a ʊ. ");
INSERT INTO bib_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ŋ n a nyasʊ, ŋn'a zɛ, ŋn'a da zaa ra a wɔ n tu. ");
INSERT INTO bib_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wutu zaa bɩ n a ya, an zibəənyɩ vanta nyɔɔ. Wutu zibəəzannɔ wɔɔ n a zɛ, ŋnɩ yaaba da a mim ma, ŋnɩ fɩr ka ma. ");
INSERT INTO bib_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A n a ya, an a kaakʊ hɔ nyɔɔ, ŋn'a zɛ gər. Bɩ jɛ ʊ, an gʊɔɔ vantɔɔ nyɔɔ, ŋnɩ fɩr ka gɔsɩnnɔ ma, ŋnɩ gɔsɩnnɔ zɩnzɛ. ");
INSERT INTO bib_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","A kur ma hɔ ma bɩ, a nyɩ k'a ŋʊa bɩ y'a deem ɩ gɔɔta, an a nyɔɔ ŋ zi, an n'a hɩrɛ, a ʊ: ‹Ŋ mɔɔ nyɩ bɩ daŋ ʊ.› ");
INSERT INTO bib_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wutu zibəəzannɔ wɔɔ n a dɩnda kan kʊ kɩ, ŋ ʊ: ‹A n nɩ zɛm b'a so arzaka b'ʊ. K'a bʊr, k'ʊ a zɛ, k'ʊ ʊ so wutu b'ʊ.› ");
INSERT INTO bib_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ŋ n a nyasʊ, ŋn'a zɛ gər, ŋnɩ bɔ m dɩvɛnsɩra b'ʊ, ŋn'a zo.» ");
INSERT INTO bib_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Bɔ dɩvɛnsɩra zaa bɩ n'a barɛ? A zɛm, an b'a dɩvɛnsɩra zibəəzannɔ wɔɔ zɩnzɛ, an a sa, an a ka a vantɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Awɔɔ n naa karɩnda ba ra? Jaa kʊ cɛdonno a bɔ ʊ ŋn'a zo bɩ, bɩ y'a ba jaa paŋŋazaa, cɛ bɩ dɔrɛ minto. ");
INSERT INTO bib_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Zuuba ɩ naa ba, bɩ wɔɔ yɩ hɔ gʊta m.» ");
INSERT INTO bib_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Gʊɔɔ kʊ ŋ y'a tʊr ka ma rɔ wɔɔ n'a kam ma k'a nyasʊ, bɩ, ŋ yɩ nyi bam zamaa bɩ m. Ŋ y'a dɔ, ŋ ʊ: hɔbɔkʊrɛnoom naa do da Yeezuu ʊ awɔɔ minto. Ŋ n a hʊr, ŋn'a gʊ ma. ");
INSERT INTO bib_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","N farizɛɛnrɔ kan Hɩrɔɔdɩ gʊɔɔ kɩ nyɔɔ Yeezuu zi kʊ ŋ n'aa a nyasʊ a meerbaa nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ŋ n b'a hɩ, ŋ ʊ: «Zuuba, wɔɔ dɔ sɩrazaa n'ɩbɩɩ m, b'ɩbɩɩ heer tɩrga kan gʊaa biyəə kɩ. Ɩbɩɩ bɩr dɩgam gʊaa meer ma bala y, Woso zaa ɩbɩɩ n'a dɩndam sɩra bɩncɛ ʊ. Zaa ta ʊ k'ʊ *Rɔm cir yawʊr ka gɛ? A a ga m gɛɛ a n a ga nɩ?» ");
INSERT INTO bib_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bɩ, kʊ Yeezuu ŋ zambʊ bɩ dɔ bɩ, a a hɩ ŋ nɩ, a ʊ: «Bɔ m, awɔɔ n'a gɩngam mɔɔ ma ncɩnaaʊ? K'a bʊr wacɩr m deem, kʊ m dɩga a.» ");
INSERT INTO bib_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ŋ n bʊr m. Yeezuu n a hɩ ŋ nɩ, a ʊ: «Ŋʊasa naa do kan gʊrsɩra naa do kɩ, nka hɔ nɩ?» Ŋ ʊ: «*Rɔm cir hɔ m.» ");
INSERT INTO bib_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a hɔ kʊ cir a so ʊ bɩ ka ʊ, k'a hɔ kʊ Woso a so ʊ bɩ ka ʊ.» Meerbaa naa do nyɩbɔʊrɛ a ka, ŋ n zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadisɛɛnrɔ kʊ ŋ ʊ, gəəno mɩmbɔʊrɛ ba ʊ bɩ, ŋ bʊr Yeezuu zi, ŋnɩ laaka da han, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Zuuba, Moyiisi a gʊrsɩra ba an a ka wɔɔ ʊ, a ʊ, ‹Kʊ gʊaa ga, an a lʊ to, b'a nyɩ ba ʊ y, k'a danyɩ n lʊ bɩ si, k'an nyɩ yɩ kan kɩ a danyɩ bɩ minto.› ");
INSERT INTO bib_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Danyɩnɔ ɩ nyɩnta saanhɩna. Lɛɛkarɛzaa bɩ n lʊ sa, an ga, an a gʊ lʊ bɩ ma, bɩ nyɩ ba ʊ y. ");
INSERT INTO bib_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A hɩɩya hɔ bɩ n lʊ bɩ si, an ga, b'a n nyɩ yɩ kan kɩ y. A kaakʊ hɔ bɩ maam sɔ. ");
INSERT INTO bib_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Saanhɩnarɔ wɔɔ haay ŋ gɩnga, bɩ ŋ n nyɩ yɩ kan lʊ bɩ kɩ y. Ŋ haay kur bɩ, lʊ bɩ n bɩ ga. ");
INSERT INTO bib_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Gəəno mɩmbɔʊrɛ dɔmɩm ʊ, kʊ ŋ y'a mɩm bɔ ʊ, ŋ haay bireyaa ʊ, nka y'a so lʊ b'ʊ? Bala, gʊɔɔ saanhɩnarɔ wɔɔ haay lʊ bɩ si.» ");
INSERT INTO bib_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'awɔɔ n gʊrsɩrarɔ mɩŋŋɔɔ kan Woso paŋŋa kɩ dɔ bɩ, bɩ y'a ka awɔɔ nɩ nyʊnnyɔɔrɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bala, kʊ gəəno b'a mɩm bɔ ʊ, yar bɩr lʊ sarɛ y, lʊ bɩr yar sarɛ y. Bɔ ŋ y'a ʊ kʊ ʊ kan malɛɛkarɔ kʊ ŋ nɩ brama rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bɩ kʊ gəəno mɩmbɔʊrɛ bɩ mim nɩ, awɔɔ n a karɩnda ba Moyiisi ci bɩ nɔ ʊ ra, dɔmɩm kʊ Woso meer ba kan Moyiisi kɩ tutugu nɔ ʊ bɩ, a ʊ: ‹Abraham kan Izakkɩ kɩ, Zakɔɔb kɩ Woso m mɔɔ m.› ");
INSERT INTO bib_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gəəno Woso bɛɛ y, mɩsɩɩrɔ Woso m. Awɔɔ ɩ nyʊnnyɔɔrɛ nɔ ʊ gʊta.» ");
INSERT INTO bib_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wosocikarɩnsaamba deem ŋ bɩsɩkarɛ bɩ ma, a a yɩ, Yeezuu a nyɩ bɔ ʊ mɩŋŋa, an a zɔ, an Yeezuu lar, a ʊ: «Lɛrɔ wɔɔ haay bire ʊ kara ɩ lɛ da?» ");
INSERT INTO bib_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Lɛ lɛɛkarɛ hɔ bɩ n naa do: ‹K'a tʊr ka Israyɛl zannɔ, Zuuba k'a m wɔɔ Woso bɩ, a y'a deem m Zuuba. ");
INSERT INTO bib_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","K'ɩ Zuuba ɩ Woso bɩ ŋʊa kan ɩ heer kɩ haay, kan ɩ nyi kɩ haay, kan ɩ hɔɔndarɛ kɩ haay, kan ɩ paŋŋa kɩ haay.› ");
INSERT INTO bib_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A hɩɩya hɔ bɩ ba n nɩ: ‹K'ɩ mim ŋʊa amba ɩ mɩŋŋa m.› Lɛ vanta ba ʊ an lɛ da nawɔnnɔ ra y.» ");
INSERT INTO bib_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wosocikarɩnsaamba bɩ n a hɩ m, a ʊ: «Sɩra ɩbɩɩ hɩ, karɩnsaamba, a mɩŋŋa gʊta: ‹Woso y'a deem m, bɩ a vanta ba ʊ, an a na ma y. ");
INSERT INTO bib_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ɩ Woso ŋʊa kan ɩ heer kɩ haay, ɩ hɔɔn kɩ haay, ɩ paŋŋa kɩ haay, k'ɩ mim ŋʊa amba ɩ mɩŋŋa m,› bɩ jɩra mannɩ haay kʊ n nɩ sɛ nyaŋ ʊ bɩ m, kan ganwʊrɛrɔ k'awɔɔ nɩ ŋ kam Woso ʊ rɔ wɔɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yeezuu k'a yɩ gʊaa b'a nyɩ bɔ ʊ mɩŋŋa bɩ, a a hɩ, a ʊ: «Ɩbɩɩ bɩ laatʊ Woso cirbəə bɩ ma y.» Bɩ kur bɩ, gʊaa biyəə ɩ nyi bam Yeezuu larlɛ m. ");
INSERT INTO bib_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yeezuu k'a nɩ hɔ dɩndam Zerizalɛm Wosocɛ ʊ bɩ, a a hɩ, a ʊ: «Bɔ minto m wosocikarɩnsaambɔɔ wɔɔ ʊ: *Davɩd Nyɩ m Krista bɩ m gɛ? ");
INSERT INTO bib_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","*Sɛnt-Ɛspri a ka Davɩd n a hɩ, a ʊ: Zuuba Woso a hɩ mɔɔ Zuuba m: nyɩnta mɔɔ bɩsɩ ʊ, kʊ m b'a ka k'ɩ jɩnnɔ wɔɔ n nyɩnta ɩ gam taa. ");
INSERT INTO bib_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davɩd mɩŋŋa y'a birm Zuuba. Kʊ Zuuba n a ba lɔ, an nyɩnta *Davɩd Nyɩ gɛ?» Zamaa bɩ n'a tʊr kam ma kan heernyɩnta kɩ. ");
INSERT INTO bib_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yeezuu y'a hɩrɛ ŋ nɩ a hɔdɩndarɛ nɔ ʊ, a ʊ: «K'a dundo a zi kan wosocikarɩnsaambɔɔ kʊ ŋ nɩ bɩmbɩrm zabarɔ m, ŋn'a kam daʊrɛ ma zamaa gʊta bire ʊ rɔ wɔɔ kɩ, ");
INSERT INTO bib_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ŋn'a kam lɛɛkarɛ bɩncɛ ma hɔbɩrɛ bɩncɛ ʊ, kan sokʊma bɩncɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ŋ n'ɩ zonno hɔ yɔrɛ ŋ nɩ, ŋn'a mɩŋŋabaa hɩnkam kan yaadarɛrɔ jintoo kɩ. Ŋ hʊnhʊrlɛ yɩm maam-maam.» ");
INSERT INTO bib_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yeezuu nyɩnta an a meer nya busoo daʊrɛ bɩncɛ bɩ rɛ, an nɩ dɩgam gʊɔɔ wɔɔ busoo bɩ daʊrɛ ma. Arzakazannɔ wɔɔ barla gɔsɩnnɔ y'a daŋ ʊ gʊta. ");
INSERT INTO bib_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Zoro n bɩ tanka hɩɩya zar ʊ. ");
INSERT INTO bib_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yeezuu n a karɩndanyɩnɔ wɔɔ bir, an a hɩ ŋ nɩ, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m, zoro ŋʊazaa naa do busoo bɩ zar ʊ gʊta, an lɛ da gʊaa haay k'a n'a daŋ ʊ bɩ ra. ");
INSERT INTO bib_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bala, ŋ haay busoo k'a zibəə ba ŋ ma bɩ, ŋ y'a da ʊ. Bɩ zoro bɩ kan a cicir bɩ kɩ, a a mɩsɩrbaa hɔ sa haay, an a da ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yeezuu k'a bɔ Wosocɛ b'ʊ bɩ, a karɩndanyɩnɔ wɔɔ gʊaa deem a hɩ m, a ʊ: «Karɩnsaamba, dɩga cɛ bɩ jaarɔ wɔɔ gʊɛrɛ ma kan a dɔrɛ kɩ!» ");
INSERT INTO bib_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yeezuu n a hɩ m, a ʊ: «Dɩga ɩbɩɩ nawʊm cɛrɔ wɔɔ dɔrɛ gʊtabaa ma ra? Jaa deem bɩ gɔɔtarɛ a mim burə ʊ y. Ŋ haay zɛm bɩ wurgə.» ");
INSERT INTO bib_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yeezuu yaa nyɩnta Oliviyee ci bɩ ra, an a meer nya Wosocɛ bɩ rɛ. Dɔmɩm bɩ do ʊ bɩ, Pɩyɛɛr kan Zakkɩ kɩ, Zaan kɩ, Andɩr kɩ kʊ ŋ y'a dɔ, ŋ ʊ, gɔsɩ ba b'ʊ bɩ, ŋ laaka naa do da Yeezuu han, ŋ ʊ: «Naa do bam brɔ? ");
INSERT INTO bib_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","A hɩ wɔɔ m, makra kara n nɩ nawɔnnɔ nyarɛ bɩ hɩnkam wɔɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yeezuu n'a hɩrɛ ŋ nɩ, a ʊ: «K'a dundo a zi kʊ gɔsɩ b'awɔɔ nyʊnnyɔɔ y. ");
INSERT INTO bib_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Gʊɔɔ gʊta zɛm, ŋnɩ bɩ meer ba mɔɔ tɔ m, ŋ ʊ: ‹Krista n a mɩ,› bɩ ŋ gʊɔɔ gʊta nyʊnnyɔɔrɛ. ");
INSERT INTO bib_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","K'awɔɔ bɩ yar mim ma kan yar k'a n'a dam ma, an bɩ wuti bɩ kɩ, a bɩ dabɔʊ ba y, bala, pakra m kʊ naa haay n ba. Bɩ, durnya nyarɛ bɛɛ m naa cɩna y. ");
INSERT INTO bib_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Do deem gʊɔɔ wutim ŋnɩ yar ba kan doro vantɔɔ kɩ. Tara deem zannɔ wutim ŋnɩ yar ba kan tara vanta zannɔ kɩ. Bɩncɛrɔ gɔsɩnnɔ tara nyiŋŋəm. Nɔ nyɩntaŋ ʊ, dɔmɩm bɩ do ʊ bɩ, k'a dɔ, a ʊ: fɩryɩrɛ sɩŋŋɩda a zɔ. ");
INSERT INTO bib_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","K'a dundo a mɩŋŋa zi, ŋ y'awɔɔ gʊrm, ŋnɩ ta awɔɔ m dʊdɔkənno zi, ŋ y'awɔɔ zɛm madɩɩrɔ m sokʊmacɛrɔ ʊ. Ŋ tarɛ awɔɔ m tara lɛɛzannɔ kan cinno kɩ taa mɔɔ minto. Nawɔnnɔ y'awɔɔ yɩm mɔɔ minto, an nyɩnta kasɛtɩ brɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bɩ pakra m kʊ ŋ nɩ lɛɛ ka, ŋnɩ lemim nyɩnta pa da durnya haay nɔ ʊ, kʊ durnya nyarɛ n bɔkarɛ, an a ku. ");
INSERT INTO bib_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kʊ ŋ b'awɔɔ nyasʊ, ŋn'ɩ tarɛ awɔɔ m dʊdɔkənno bɩncɛ ʊ b'ʊ, a bɩ lɛɛ ka a a hɔɔn da hɔ k'awɔɔ n aa a hɩ bɩ ma y. Mim k'a nɩ zɛm bɩ bʊr awɔɔ hɔɔn ʊ dɔmɩm bɩ do ʊ bɩ, b'awɔɔ n n'a hɩm. Bala, awɔɔ bɛɛ n nɩ meer bam dɔmɩm bɩ do ʊ y, Sɛnt-Ɛspri n nɩ meer bɩ barɛ awɔɔ bɩncɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Danyɩnɔ kʊ kam zɛ ma. Zɩ y'a nyɩ karɛ n n a zɛ. Nyɩnɔ wutim nyaam kan a zɩrɔ kɩ, ŋn'a ka, ŋnɩ ŋ zɩnzɛ. ");
INSERT INTO bib_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Gʊaa haay sɔrɛ awɔɔ m mɔɔ tɔ ma, bɩ gʊaa k'a nyasʊ a sɩrakarɛ m kɔɔkɔɔ an ta an fɩryɩrɛ bɩ nyarɛ ku, bɩ zaa bʊmbɔrɛ yɩm.» ");
INSERT INTO bib_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«K'awɔɔ bɩ ‹Gʊaa kʊ hɔzaarbarɛzaa bʊnyaa m bɩ› yɩ an nɩ bɩncɛ niŋŋə ʊ, b'a n'a ga m, an nyɩnta bɩncɛ bɩ do ʊ, gʊaa niŋŋə k'a n'a karɩnda bam bɩ ma bɩ, k'an a jɩ ma. Gʊɔɔ kʊ ŋ nɩ nyɩntam Zidee ʊ bɩ, kʊ ŋ n'a si ŋnɩ ta ciro ʊ. ");
INSERT INTO bib_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Gʊaa k'a n'a cɛ mim ʊ bɩ, a b'a ka ma k'a zer a gasʊ a cɛ ʊ, k'a hɔsɩ sa dɔmɩm bɩ do ʊ y. ");
INSERT INTO bib_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Gʊaa k'a n'a hɔsɩra ʊ dɔmɩm bɩ do ʊ, a b'a bɔ an doo k'a yaa a huu sa y! ");
INSERT INTO bib_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dɔmɩnnɔ wɔɔ duro ʊ, mim pakra bam lannɔ jɩsɩzannɔ m, kan bɔɔ n nɩ nyɔ karɛ a nyɩnɔ ʊ rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","K'a yaa da, kʊ naa do bɩ lee ku la dɔmɩm ʊ y. ");
INSERT INTO bib_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bala, a nyɩntam fɩryɩrɛ dɔmɩnnɔ k'an nyɩnta ʊ hallɩ durnya kʊ Woso a da bɩ sɩŋŋɩda ma, an ta an naa ma ku, bɩ, ʊ b'ʊ yarɛ, ʊ a do yɩ fɩɩga y. ");
INSERT INTO bib_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kʊ Woso bɛɛ dɔmɩnnɔ nɔɔn duro bɔrɛ, gʊaa ba ʊ an b'a dam ma, an a meeyaa bʊmbɔ y. Bɩ gʊɔɔ k'an ŋ nyʊkɔ ʊ rɔ wɔɔ minto, a dɔmɩnnɔ wɔɔ duro bɔrɛ. ");
INSERT INTO bib_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kʊ gʊaa a hɩ, a ʊ: Krista ɩ naa ʊ, gɛɛ, a ɩ bra ʊ, a b'a si y. ");
INSERT INTO bib_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ŋʊaarzannɔ kʊ ŋ Krista tɔ sa ŋn'a ka a ma rɔ wɔɔ, kan ŋʊaarlɛsinnɩsorazannɔ kɩ nyɩntaŋ ʊ gʊta. Ŋ makrarɔ bam gʊta kan hoserlo kɩ k'a a da ma, a gʊɔɔ kʊ Woso ŋ nyʊkɔ ʊ rɔ wɔɔ nyʊnnyɔɔ. ");
INSERT INTO bib_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bɩ k'awɔɔ m, k'a dundo a zi kan hɔ kʊ mɔɔ lɛɛ ka m a hɩ haay awɔɔ m, b'a n'a ku cɩna bɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Bɩ kʊ fɩryɩrɛ dɔmɩnnɔ wɔɔ bɩ cem, dɔmɩnnɔ wɔɔ duro nɔ ʊ, woso b'a yarɛ an gu y, mom b'a yarɛ an gu sɔ y. ");
INSERT INTO bib_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Monyaarɔ surm, brama paŋŋa haay y'a zɛm kʊ ma. ");
INSERT INTO bib_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dɔmɩm bɩ do ʊ bɩ, n Gʊaanyɩ bɩ yɩrɛ an a to warkʊ nɔ ʊ an bɩr zɛm kan paŋŋa kɩ, cirbəə gʊta kɩ. ");
INSERT INTO bib_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A n bɔkarɛ, an malɛɛkarɔ nyɔɔ lɛɛ haay ʊ, ŋn'aa gʊɔɔ kʊ Woso ŋ nyʊkɔ ʊ rɔ wɔɔ so kʊ ma, an a sa dɔjɩr ma an ta kan meer kɩ. ");
INSERT INTO bib_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","K'a sɔɔn makra bɩ sa. K'awɔɔ b'a yɩ, an lɛɛ daa da, an nɩ kum, awɔɔ dɔ a ʊ siire a zɔ. ");
INSERT INTO bib_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","A maam sɔ kan awɔɔ kɩ. K'awɔɔ bɩ minno nɔɔn duro yɩ, ŋn'ɩ zɛrɛ, k'a dɔ a ʊ Gʊaanyɩ bɩ zɛrɛ dɔmɩm a zɔ. ");
INSERT INTO bib_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sɩra mɔɔ n'a hɩrɛ awɔɔ m: zamaana naa do bɩ cenim, kʊ nawɔnnɔ haay bɛɛ ba y. ");
INSERT INTO bib_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Brama kan tara kɩ cenim, bɩ mɔɔ meerbaarɔ wɔɔ bɩ cenle y. ");
INSERT INTO bib_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Bɩ, dɔmɩm bɩ do kan wakatɩ bɩ do kɩ, gʊaa ba ʊ an b'a dɔrɛ y. Baa malɛɛkarɔ kʊ ŋ nɩ brama rɔ wɔɔ n a dɔ y. Gʊaanyɩ bɩ n a dɔ sɔ y. K'a maam, Zɩ bɩ y'a deem y'a dɔ. ");
INSERT INTO bib_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","K'a dundo a zi, a bɩ hinceem ba y. Bala, awɔɔ n dɔmɩm bɩ do zɛrɛ dɔ y. ");
INSERT INTO bib_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bɔ a kʊ ʊ kan gʊaa k'a nɩ tam kʊ ʊ bɩ kɩ, an a har to a zibəənyɩnɔ m, an lɛ ka ŋ ʊ, an zibəə ka gʊaa biyəə ʊ k'an a ba. A n a hɩ hardɔmazaa bɩ m, a ʊ: a bɩ hinceem ba y. ");
INSERT INTO bib_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","K'a b'a zu a ʊ y. Bala, awɔɔ n har bɩ zaa bɩ zɛrɛ dɔmɩm dɔ y. Kʊ dibsir nɩ, kʊ wuti gʊta nɩ, kʊ koo baadarɛ dɔmɩm nɩ, kʊ dɔmɩrɛ nɩ, awɔɔ n a dɔ y. ");
INSERT INTO bib_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Dɔmɩm niŋŋə k'a nɩ zɛm bɩ bʊr ʊ bɩ, a b'a ka, an bɩ dɩga a awɔɔ hinceem ba y. ");
INSERT INTO bib_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Hɔ kʊ mɔɔ n'a hɩm bɩ, awɔɔ haay mɔɔ hɩ a m. K'a bɩ hinceem ba y.» ");
INSERT INTO bib_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","*Pakkɩ cibsa kan bur kʊ n n nyʊnyɔɔ da ma *cibsa kɩ gɔɔta dɔmɩm hɩɩya. Wosocɛmannɩbənno jɩtannɔ kan wosocikarɩnsaambɔɔ kɩ y'a kam zaa k'a n'a sam k'a Yeezuu ku a nyasʊ a mim ka ra, kʊ n n'a zɛ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ŋ y'a hɩm kʊ m, ŋ ʊ: «Ʊ b'a ba cibsa hinni ʊ y. Kʊ n bɛɛ nɩ, zamaa bɩ wutim yar m kan wɔɔ kɩ a minto.» ");
INSERT INTO bib_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yeezuu nyɩnta Betanii ʊ, gʊaa deem kʊ n n'a birm Sɩmɔɔn kusimə bɩ har ʊ. K'a nɩ hɔbɩrɛ bɩm bɩ, lʊ deem bʊr har ʊ b'ʊ kan gedre kɩ, n n a ba albatɩr jaa m, tidəər n a han. A ji n nyɩnta, a lɛ m kʊsɩ, an tidəər gedre bɩ yi, an tidəər bɩ lo Yeezuu ra. ");
INSERT INTO bib_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bɩ, naa do gʊɔɔ gʊta heer zar, ŋn'a hɩm kʊ m, ŋ ʊ: «Bɔ tɔ ma m, n n tidəər naa do zaar barɛ? ");
INSERT INTO bib_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","N y'a da ma, n n tidəər naa do hɛɛ, a busoo n cem *deniyee zɔɔkarkʊ han, n n a ka ŋʊazannɔ ʊ.» Bɩ, ŋ nyɩnta, ŋn'ɩ kukur bam lʊ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a lʊ bɩ to zenyy… Bɔ tɔ ma m, awɔɔ n'a heer zarlɛ? Zibəə mɩŋŋa a ba mɔɔ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ŋʊazannɔ nyɩntarɛ awɔɔ bire ʊ dɔmɩm haay. Awɔɔ y'a dam ma a hɔ mɩŋŋa ba ŋ nɩ dɔmɩm k'awɔɔ lɛ n taa ʊ. Bɩ mɔɔ, mɔɔ bɩ nyɩntam kan awɔɔ kɩ dɔmɩm haay y. ");
INSERT INTO bib_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Lʊ naa do, hɔ k'a a da ma b'a a ba. K'a tidəər nɔ mɔɔ mɛ ma bɩ, lɛɛ a ka, an mɔɔ mɛsim banka mɔɔ birle minto. ");
INSERT INTO bib_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sɩra mɔɔ n'a hɩrɛ awɔɔ m: durnya nɔ ʊ, bɩncɛ kʊ n nɩ lemim nyɩnta pa daŋ ʊ haay bɩ, n y'a tɔ darɛ a nɔ ʊ, n n lʊ naa do hɔ k'a a ba bɩ hɩ sɔ.» ");
INSERT INTO bib_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Bɩ kur bɩ, Zidas Iskarɩyɔtɩ, karɩndanyɩnɔ bueerehɩɩyɔɔ wɔɔ gʊaa deem bɩ ta, an aa wosocɛmannɩbənno jɩtannɔ wɔɔ yɩ, k'a Yeezuu nyasʊ a ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kʊ ŋ naa ma bɩ, ŋ heer nyɔɔ gʊta, ŋnɩ ler bɔ m, ŋ ʊ: «K'a busoo ka ʊ.» Zidas n yɛ, an n'a kam dɔmɩm k'a n'a dam ma a Yeezuu nyasʊ a ka ŋ ʊ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bur kʊ n n nyʊnyɔɔ da ma lɛɛkarɛ dɔmɩm ma bɩ, n nɩ pakkɩ sinnyɛɛm mannɩ baŋ ʊ bɩ, Yeezuu karɩndanyɩnɔ wɔɔ a hɩ m, ŋ ʊ: «Ɩbɩɩ lɛ n taa kʊ aa pakkɩ hɔbɩrɛ bɩ ba ka, ɩbɩɩ minto?» ");
INSERT INTO bib_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A n a karɩndanyɩnɔ nyɔɔ hɩɩya, an a hɩ ŋ nɩ, a ʊ: «K'a ta tara nɔ ʊ, awɔɔ gʊaa zɛŋ ʊ, an hi busu gər ʊ, k'a zu kʊ ʊ kan kɩ, ");
INSERT INTO bib_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","a gasʊ bɩncɛ k'a nɩ gasʊŋ ʊ b'ʊ. B'ʊ bɩ, k'a hɩ har bɩ zaa m, a ʊ: ‹Zuuba ɩ laaka dam: bɩncɛ kara awɔɔ n nɩ pakkɩ hɔbɩrɛ bɩ bɩŋ ʊ kan a karɩndanyɩnɔ kɩ?› ");
INSERT INTO bib_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A cɛ gʊta hɩnkarɛ awɔɔ m mim ʊ, ŋn'a banka haay. Bɩncɛ bɩ do ʊ awɔɔ n nɩ pakkɩ hɔbɩrɛ bɩ baŋ ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Karɩndanyɩnɔ wɔɔ n a hʊr, ŋnɩ ta tara nɔ ʊ b'ʊ, ŋn'aa hɔ haay bɩ yɩ amba a a hɩ ŋ nɩ bɩ m, ŋnɩ pakkɩ hɔbɩrɛ bɩ banka. ");
INSERT INTO bib_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yirbəə k'a da bɩ, Yeezuu bʊr kan a karɩndanyɩnɔ bueerehɩɩyɔɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yeezuu k'a nɩ hɔbɩrɛ bɩ bɩm kan a karɩndanyɩnɔ wɔɔ kɩ bɩ, a a hɩ, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m, awɔɔ gʊaa deem k'a nɩ hɔbɩrɛ bɩm kan mɔɔ kɩ bɩ mɔɔ nyasʊm, an mɔɔ ka.» ");
INSERT INTO bib_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ŋ haay nɩ nyɩntam kan heer zar kɩ. Ŋ gʊaa deem-deem n'a larm, a ʊ: «Zuuba, mɔɔ m gɛ?» ");
INSERT INTO bib_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Awɔɔ gʊaa bueerehɩɩya bɩ deem m. Gʊaa k'a n'a wɔ nyɔɔm kan mɔɔ kɩ laaga b'ʊ, bɩ m. ");
INSERT INTO bib_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bala, Gʊaanyɩ bɩ cenim amba hɔ kʊ ŋ y'a gʊrsɩra ba a tɔ ma bɩ m. Bɩ kʊsɩ ɩ kan gʊaa k'a nɩ mɔɔ nyasʊm k'a mɔɔ ka bɩ kɩ. Kʊ gʊaa bɩ do ɩ nɩ yɩ, a jɩra.» ");
INSERT INTO bib_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kʊ ŋ nɩ hɔbɩrɛ bɩ bɩm bɩ, Yeezuu bur sa, an a barka da ʊ, an n'a hɩrɛ, a ʊ: «K'a si, naa do naa, mɔɔ mɛ m. ");
INSERT INTO bib_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bɩ kur bɩ, a a ya, an laaga sa, dɩvɛn n a han, an barka yaa da Woso m, an a ka ŋ ʊ, ŋ haay n a mi.» ");
INSERT INTO bib_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A n a hɩ ŋ nɩ, a ʊ: «Mɔɔ ma m naa, gʊaasɩbabaa ma m, an a lo gʊɔɔ gʊta minto. ");
INSERT INTO bib_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, mɔɔ bɩ m yarɛ m dɩvɛn mi dɔ y, an ta an dɔmɩm kʊ mɔɔ n nɩ zɛm bɩ m ya, m a mi kan awɔɔ kɩ Woso cirbəə bɩ nɔ ʊ bɩ ku.» ");
INSERT INTO bib_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kʊ ŋ barka laarɔ wɔɔ lɔ ŋn'a nya bɩ, ŋ bɔ ŋnɩ ta Oliviyee ci ra. ");
INSERT INTO bib_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Awɔɔ y'a wɩsɩrabaa tom, bala, n y'a gʊrsɩra ba Wosoci nɔ ʊ, n ʊ: ‹Mɔɔ seero dundor bɩ zɛm, seero wɔɔ n hɩsɩga da.› ");
INSERT INTO bib_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bɩ mɔɔ mɩmbɔʊrɛ kur bɩ, mɔɔ lɛɛ karɛ awɔɔ lɛɛ Galilee ʊ.» ");
INSERT INTO bib_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pɩyɛɛr n a nyɩ bɔ ʊ, a ʊ: «Baa kʊ gʊaa haay bɩ wɔ saa a wɩsɩrabaa ma, mɔɔ bɩ wɔ saa n ma y.» ");
INSERT INTO bib_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeezuu n a hɩ m, a ʊ: «Sɩra mɔɔ n'a hɩrɛ ɩbɩɩ m, gum naa do ʊ bala, koo bɩ baa dam gallɛm hɩɩya y, ɩbɩɩ n bɩsɩ ka mɔɔ ma gallɛm kaakʊ.» ");
INSERT INTO bib_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pɩyɛɛr n a nyɩ bɔ ʊ, an so ra kan paŋŋa kɩ, a ʊ: «Kʊ ga mɔɔ nawʊm kan ɩbɩɩ kɩ a jɩra, mɔɔ bɩ bɩsɩ karɛ ɩbɩɩ ma y.» A muno wɔɔ n a hɩ maam sɔ. ");
INSERT INTO bib_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bɩ kur bɩ, ŋ ta bɩncɛ kʊ n n'a birm Gɛtsemanee ʊ b'ʊ. Yeezuu n a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «K'a nyɩnta naa ʊ, kʊ m yaa da, kʊ m bʊr.» ");
INSERT INTO bib_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A n Pɩyɛɛr gaa kan Zakkɩ kɩ Zaan kɩ. Dɔmɩm bɩ do ʊ bɩ, heerzar gʊta kan dabɔʊ kɩ gasʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A n a hɩ ŋ nɩ, a ʊ: «Mɔɔ heer a zar an a zɔ zɛ ma. K'a gɔɔta naa ʊ, a bɩ hinceem ba y.» ");
INSERT INTO bib_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A n ta lɛɛ poore, an kukurə zɛ, an a meer ku tara ma, an nɩ yaa darɛ, an n'a hɩrɛ, a ʊ, kʊ fɩryɩrɛ k'awɔɔ n n'a yɩm bɩ y'a dam ma, an a gʊ a ma. ");
INSERT INTO bib_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A n n'a hɩrɛ, a ʊ: «M Zɩ, hɔ ba ʊ an kɔɔkɔɔ ɩbɩɩ ma y. Fɩr naa do gʊ mɔɔ ma, kan bɩ kɩ haay, ɩ bɩ mɔɔ hɔɔnhɔ ba y, ɩ hɔ ba.» ");
INSERT INTO bib_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A n a bɔ, an bʊr a karɩndanyɩnɔ wɔɔ zi, a bɩ dɩga a ŋ hinceem ba, an ŋ gu, an a hɩ Pɩyɛɛr m, a ʊ: «Sɩmɔɔn, hinceem ɩbɩɩ n'a bam na, ɩbɩɩ n'ɩ da ɩ mɩŋŋa ma wakatɩ deem ma tɔkkɛ ra! ");
INSERT INTO bib_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","K'a yaa da, a bɩ hinceem ba y, a yaa n a do makra nɔ ʊ. Awɔɔ heer lɛ taa, bɩ mɛsim paŋŋa ba ʊ y.» ");
INSERT INTO bib_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A n a bɔ, an ta yaadarɛ bɩncɛ ʊ b'ʊ, an a ya, an so a yaadarɛ bɩ ra. ");
INSERT INTO bib_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A n a bɔ, an bʊr a hɩɩya hɔ ma a karɩndanyɩnɔ wɔɔ zi, an bɩ dɩga a, ŋ hinceem ba. Bala, hinceem ta ŋ nɩ gʊta. Ŋ n hɔ k'a n'a hɩm nɩ bɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A n a bɔ an bʊr a kaakʊ hɔ ma ŋ zi, an b'a hɩ ŋ nɩ, a ʊ: «K'a lɛ taa, k'a hinceem ba kɛɛrɛ, k'a hoon si. Hɔ haay nya. Dɔmɩm a ku. Naa ma bɩ, n Gʊaanyɩ bɩ nyasʊrɛ n a ka mimbʊnyaabənno ʊ. ");
INSERT INTO bib_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","K'a wuti, k'ʊ ta, gʊaa k'a nɩ mɔɔ nyasʊm k'a mɔɔ ka bɩ lee ku.» ");
INSERT INTO bib_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kʊ Yeezuu gɔɔta an nɩ meer bam bɩ, Zidas, bueerehɩɩyɔɔ wɔɔ gʊaa deem bɩ lee ku lɛɛm, kan gʊɔɔ cir kɩ, bannɔ kan kargʊrɔ kɩ a wɔ ʊ. Wosocɛmannɩbənno jɩtannɔ kan wosocikarɩnsaambɔɔ kɩ, gʊɔɔgusinno kɩ yɩ ŋ nyɔɔ. ");
INSERT INTO bib_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zunzukʊrazaa bɩ lɛɛ ka an makra hɩnka ŋ nɩ, a ʊ: «Gʊaa kʊ mɔɔ n nɩ m wɔ burgum ma bɩ, bɩ zaa m. K'a nyasʊ, a dɔ ma mɩŋŋa, a ta m.» ");
INSERT INTO bib_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Zidas k'a lee ku lɛɛm bɩ, a a zɔ Yeezuu ma, an n'a hɩrɛ, a ʊ: «Karɩnsaamba.» A n a burgu ma. ");
INSERT INTO bib_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Gʊɔɔ wɔɔ duro Yeezuu nyasʊ lɛɛm. ");
INSERT INTO bib_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A karɩndanyɩnɔ wɔɔ gʊaa deem kargʊ gaa ʊ, an wosocɛmannɩbər jɩtaarɛ bɩ zibəənyɩ sakʊ, an a tʊr gʊ ma. ");
INSERT INTO bib_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Bʊr awɔɔ kargʊrɔ m kan bannɔ kɩ m k'a bɩ mɔɔ nyasʊ, ɩ ʊ, dazaamazaa n mɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mɔɔ nyɩnta awɔɔ bire ʊ dɔmɩm haay, m nɩ karɩnda bam Wosocɛ ʊ, b'awɔɔ n mɔɔ nyasʊ y.» Naa do naa, ba a ʊ, kʊ hɔ kʊ n y'a gʊrsɩra ba Wosoci nɔ ʊ bɩ n kʊ yɩ. ");
INSERT INTO bib_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kɛɛrɛ bɩ, Yeezuu karɩndanyɩnɔ wɔɔ a gʊ ma, ŋn'a si. ");
INSERT INTO bib_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nyukumbueere deem zu a jɛ ʊ, an gɔbga zu a kɔɔn ʊ. Gʊɔɔ vantɔɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ n a nyasʊ. ");
INSERT INTO bib_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Bɩ n a mɩŋŋa yɔ, an a si a mɛ m dɩgɩ, an gɔbga bɩ to ŋ wɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ŋ ta Yeezuu m wosocɛmannɩbər jɩtaarɛ har ʊ. Wosocɛmannɩbənno jɩtannɔ, gʊɔɔgusinno kan wosocikarɩnsaambɔɔ kɩ a so kʊ ma b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pɩyɛɛr n zu Yeezuu jɛ ʊ laatʊ, an ta, an aa lee ku wosocɛmannɩbənno jɩtaarɛ bɩ har ʊ b'ʊ, an aa nyɩnta kan hallɛdɔmazannɔ wɔɔ kɩ, an nɩ nyɩkam sɛ ma. ");
INSERT INTO bib_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wosocɛmannɩbənno jɩtannɔ wɔɔ kan dʊdɔkənno vantɔɔ wɔɔ kɩ haay y'a kam mim ma k'a ka Yeezuu ra, a dʊdɔ yar, k'a ka kʊ n n a zɛ gər, bɩ ŋ bɩr a yɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bala, kasɛtɩ ŋʊaarzannɔ bʊr gʊta, bɩ ŋ meerbaa bɩ bɩr zum kʊ y. ");
INSERT INTO bib_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Gʊɔɔ gɔsɩnnɔ n wuti, ŋnɩ ŋʊaar ba, ŋn'a ka a lɛ m, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Wɔɔ ma an n'a hɩrɛ, a ʊ: Wosocɛ naa do kʊ ŋ y'a dɔ a wɔ m naa, mɔɔ y'a wurgəm, bɩ dɔmɩm kaakʊ nɔ ʊ bɩ, mɔɔ y'a vanta dɔm, b'a bɩ nyɩntam gʊaa wɔ zibəə y.» ");
INSERT INTO bib_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bɩ kan hɔ kʊ ŋ n'a hɩm bɩ kɩ, ŋ meerbaa bɩ bɩr a gam kʊ ʊ y. ");
INSERT INTO bib_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bɩ kur bɩ, wosocɛmannɩbər jɩtaarɛ bɩ wuti gʊɔɔ wɔɔ bire ʊ, an Yeezuu lar, a ʊ: «Bɔ mim gʊɔɔ wɔɔ n'a karɛ ɩbɩɩ ra na? Ɩbɩɩ b'a nyɩ bɔŋ ʊ ra?» ");
INSERT INTO bib_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yeezuu n a nyɩ bɔ ʊ y. Wosocɛmannɩbər jɩtaarɛ bɩ n a ya, an a lar, a ʊ: «Krista n'ɩbɩɩ m na? Ɩbɩɩ m Nyɩ kʊ Woso barkazaa b'a nyɔɔ bɩ gɛ?» ");
INSERT INTO bib_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Mɔɔ mɩŋŋa m. B'awɔɔ Gʊaanyɩ bɩ yɩm an aa nyɩnta Woso paŋŋazaa bɩsɩ ʊ, an a to brama warkʊ nɔ ʊ, an bɩr zɛm.» ");
INSERT INTO bib_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dɔmɩm bɩ do ʊ bɩ, wosocɛmannɩbər jɩtaarɛ bɩ nɔ ma ʊ, an a mɩŋŋa huuro kɩnkaansʊ, an n'a hɩrɛ, a ʊ: «Kasɛtɩzannɔ zibəə a ya, an ta wɔɔ ma ra? ");
INSERT INTO bib_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Awɔɔ ma an Woso sʊnsɔ wʊ. Awɔɔ y'a hɔɔn dam lɔ?» Ŋ haay n a hɩ, ŋ ʊ: «A a ga zɛ m.» ");
INSERT INTO bib_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Gʊɔɔ gɔsɩnnɔ n a sɩŋŋɩda ba, ŋn'ɩ lihi dɩndam ma, ŋnɩ pɛɛra ku a meer ma, ŋn'a zɛm, ŋ ʊ: «Kʊ nka nɩ zɛrɛ k'ɩ dɔ ɩ hɩ!» Hallɛdɔmazannɔ wɔɔ n'a zɛm. ");
INSERT INTO bib_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kʊ Pɩyɛɛr nɩ hallu b'ʊ bɩ, wosocɛmannɩbər jɩtaarɛ bɩ zibəənyɩlʊrɔ wɔɔ gʊaa deem bɩ bʊr b'ʊ. ");
INSERT INTO bib_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","A n bɩ Pɩyɛɛr yɩ, an nɩ nyɩ kam sɛ ma, an dɩga a meer ma, an n'a hɩm nɩ, a ʊ: «Ɩbɩɩ nyɩnta kan Yeezuu Nazarɛtɩ gʊaa bɩ kɩ sɔ.» ");
INSERT INTO bib_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pɩyɛɛr n bɩsɩ ka, an n'a hɩrɛ, a ʊ: «Mɔɔ n a dɔ y. Hɔ k'ɩbɩɩ lɛ n taa k'ɩ hɩ naa, mɔɔ n a jɩ ma y.» A n bɔ, an ta zaŋŋʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Zibəənyɩlʊ bɩ k'a a ya an a yɩ bɩ, a a hɩ gʊɔɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ m, a ʊ: «Naa do naa ŋ gʊaa deem m.» ");
INSERT INTO bib_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pɩyɛɛr n a ya, an bɩsɩ ka. Bɩ kur bɩ, kʊ maasɩrɛ ba poore bɩ, gʊɔɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ haay a ya, ŋn'a hɩ Pɩyɛɛr m, ŋ ʊ: «Kʊ sɩra m, ɩbɩɩ, ŋ gʊaa n'ɩbɩɩ m sɔ. Bala, Galilee gʊaa n'ɩbɩɩ m.» ");
INSERT INTO bib_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pɩyɛɛr n a sɩŋŋɩda ba, an n'a wer sire, a ʊ: «Mɔɔ n gʊaa k'awɔɔ n'a mim dɩndam naa dɔ y.» ");
INSERT INTO bib_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dɔmɩm bɩ do ʊ bɩ, koo baa da gallɛm hɩɩya hɔ ma. Pɩyɛɛr bɔkarɛ, an mim kʊ Yeezuu a hɩ m bɩ tɔ da a nɔ ʊ: «Koo bɩ baa dam gallɛm hɩɩya y, ɩbɩɩ n bɩsɩ ka mɔɔ ma gallɛm kaakʊ.» A n bɔ zɔɔ-zɔɔ, an nɩ nyi karɛ. ");
INSERT INTO bib_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wutigʊta m bɩ, wosocɛmannɩbənno jɩtannɔ kan gʊɔɔgusinno kɩ, wosocikarɩnsaambɔɔ kɩ, kan dʊdɔkənno wɔɔ kɩ a zɛ kʊ ra, k'a dɩga hɔ k'a n'a bam bɩ ma. Ŋ y'a ka, ŋnɩ Yeezuu wɔrɔ sur, ŋnɩ ta m, ŋn'aa ka Pɩlatɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pɩlatɩ n a lar, a ʊ: «Zɩɩfʊrɔ cir n'ɩbɩɩ m gɛ?» Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Ɩbɩɩ hɩ.» ");
INSERT INTO bib_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wosocɛmannɩbənno jɩtannɔ wɔɔ ŋʊaar ba ŋn'a kam la kan ŋʊaarbaa do haay kɩ. ");
INSERT INTO bib_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pɩlatɩ n a ya, an a lar, a ʊ: «Ɩbɩɩ b'a nyɩ bɔŋ ʊ ra? Dɩga mim haay kʊ ŋ n'a karɛ ɩbɩɩ ra bɩ ma.» ");
INSERT INTO bib_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bɩ Yeezuu n a ya, an hɔsɩ nyɩ bɔ ʊ Pɩlatɩ nʊ y. Pɩlatɩ n zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kʊ zɩɩfʊrɔ wɔɔ bʊr ŋn'ɩ cibsa gʊta barɛ, Pɩlatɩ bɩ, lɔ kʊ ŋ y'a yɛ bɩ, an n'a bɔrɛ, an wɔ saa. ");
INSERT INTO bib_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bala, gʊaa kʊ n n'a birm Barabas bɩ nyɩnta lɔnnɔcɛ ʊ kan gʊɔɔ kʊ ŋ yar ba tara nɔ ʊ ŋnɩ gər zɛ rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Zamaa bɩ n ta Pɩlatɩ zi, ŋn'aa hɔ k'a n'a karɛ ŋ ʊ biisi bɩ yɛ. ");
INSERT INTO bib_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pɩlatɩ n ŋ lar, a ʊ: «Awɔɔ lɛ n taa kʊ m zɩɩfʊrɔ cir bɩ bɔ, m wɔ saa gɛ?» ");
INSERT INTO bib_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bala, a a dɔ a ʊ, wosocɛmannɩbənno jɩtannɔ wɔɔ nɔ nɩ tam Yeezuu ma, kʊ gʊɔɔ wɔɔ a ŋʊa bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bɩ, wosocɛmannɩbənno jɩtannɔ wɔɔ zamaa bɩ nyʊnnyɔɔ, kʊ Pɩlatɩ m Barabas bɔ an wɔ saa. ");
INSERT INTO bib_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pɩlatɩ n a ya, an zamaa bɩ lar, a ʊ: «Bɔ awɔɔ lɛ n taa kʊ m a ba gʊaa k'awɔɔ n'a birm zɩɩfʊrɔ cir bɩ nɩ?» ");
INSERT INTO bib_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ŋ n zee da, ŋ ʊ: «K'a wɔ gɔdarkʊra ma!» ");
INSERT INTO bib_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pɩlatɩ n a hɩ ŋ nɩ, a ʊ: «Bɔ a a ba an bʊnyaa?» Ŋ n a ya, ŋnɩ zee da, an lɛ da biisi ra: «K'a wɔ gɔdarkʊra ma!» ");
INSERT INTO bib_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pɩlatɩ k'a lɛ n taa k'a zamaa bɩ heer nyɔɔ bɩ, a Barabas bɔ an wɔ saa, an a ka, ŋnɩ Yeezuu zɛ madɩɩrɔ m, an a ka ŋ ʊ, kʊ ŋ n'a wɔ gɔdarkʊra ma. ");
INSERT INTO bib_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yarbənno Yeezuu gaa ŋnɩ ta m hallu ʊ, bɩncɛ kʊ n n'a hɩm ma Pretʊaar b'ʊ, kan yarbənno kʊ ŋ gɔɔta rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bɩ kur bɩ, ŋnɩ cinno huu kʊ n y'a ba pɛɛra piinə m da Yeezuu ra, ŋnɩ laa waa, ŋn'a ku a mim ma. ");
INSERT INTO bib_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ŋ n'ɩ yaa dam nɩ, ŋn'a hɩrɛ, ŋ ʊ: «Zɩɩfʊrɔ cir, wɔɔ ɩ yaa darɛ ɩbɩɩ m.» ");
INSERT INTO bib_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ŋ n'a zɛrɛ a mim ma bara m, ŋn'ɩ lihi dɩndam ma. Ŋ n sʊnta a taa, ŋn'ɩ yaa dam nɩ. ");
INSERT INTO bib_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kʊ ŋ y'a hɔɔnhɔ ba Yeezuu m ŋn'a nya bɩ, ŋ cinno huu bɩ bɔ ma ŋn'a huuro wɔɔ du ma, ŋn'ɩ tam nɩ k'a yaa a wɔ gɔdarkʊra ma. ");
INSERT INTO bib_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sirɛnnɩ gʊaa deem kʊ n n'a birm Sɩmɔɔn b'a to a har ʊ, an nɩ tam kʊnɔ ʊ. Alɛsandɩr kan Rifis kɩ baaba m. Yarbənno wɔɔ n paŋŋa ba ma k'an Yeezuu gɔdarkʊra bɩ busu. ");
INSERT INTO bib_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ŋ n ta Yeezuu m bɩncɛ kʊ n n'a birm Golgotaa b'ʊ. A lɛ taa k'a hɩ, a ʊ: ‹Minkorgo bɩncɛ.› ");
INSERT INTO bib_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ŋ n dɩvɛn war kʊ ma kan *mɩɩr kɩ ŋn'a ka Yeezuu ʊ, b'a n a mi y. ");
INSERT INTO bib_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ŋ n a wɔ gɔdarkʊra ma, ŋnɩ pʊɛɛga da a huuro wɔɔ ma ŋnɩ ŋ jir. Gʊaa biyəə kan a hɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ŋ Yeezuu wɔ gɔdarkʊra ma ŋn'a nya dɔgta m wakatɩ nɛɛhʊ ma. ");
INSERT INTO bib_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ŋ n Yeezuu zɛ bɩ jɩ gʊrsɩra ba ncɩnaaʊ warga ma Yeezuu mim la gɔdarkʊra bɩ ma: ‹Zɩɩfʊrɔ cir m.› ");
INSERT INTO bib_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ŋ konno wɔ hɩɩya gɔdarkʊrarɔ ma bɩncɛ deem ʊ kan Yeezuu kɩ. Deem a jɩsa, deem a bɩsɩ.  ");
INSERT INTO bib_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hɔ kʊ n nyɩnta, n n a da Wosoci nɔ ʊ bɩ kʊ yɩ: ‹N y'a lɛ sa n n a da mimbʊnyaabənno barla.› ");
INSERT INTO bib_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Cenlezannɔ kʊ ŋ nɩ cenim b'ʊ rɔ wɔɔ y'a sʊnsɔ wʊm, ŋn'a mim zɛm zukə-zukə, ŋn'a hɩrɛ, ŋ ʊ: «Haya! Ɩbɩɩ k'ɩ ɩ da ma, ɩ Wosocɛ wurgə, ɩ ɩ bɔ, ɩ dɔ dɔmɩm kaakʊ nɔ ʊ bɩ, ");
INSERT INTO bib_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ɩ mɩŋŋa bʊmbɔ, k'ɩ zer gɔdarkʊra bɩ ma.» ");
INSERT INTO bib_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wosocɛmannɩbənno wɔɔ sɔ kan wosocikarɩnsaambɔɔ wɔɔ kɩ y'a dɩndam kan kʊ kɩ, ŋn'ɩ yaa wʊm Yeezuu ma, ŋ ʊ: «A a muno bʊmbɔ, an bɔkarɛ, a b'a dam ma an a mɩŋŋa bʊmbɔ y.» ");
INSERT INTO bib_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kʊ Krista, Israyɛl cir bɩ n zer gɔdarkʊra ma kɛɛrɛ, k'ʊ a yɩ, k'ʊ sɩra ka. Gʊɔɔ kʊ ŋ yɩ ŋ wɔ gɔdarkʊra ma rɔ wɔɔ y'a sʊnsɔ wʊm sɔ. ");
INSERT INTO bib_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sinsebir k'a bɩ da bɩ, monsigə gʊta zɛ tara burə ʊ an ta an wakatɩ kaakʊ ku yirbəəre m. ");
INSERT INTO bib_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wakatɩ kaakʊ bɩ ma bɩ, Yeezuu zee gʊta da, a ʊ: «Eloyii, Eloyii, lama sabaktaani?» A lɛ taa k'a hɩ, a ʊ: «Mɔɔ Woso, mɔɔ Woso, bɔ nɩ, ɩ ɩ bɔ mɔɔ ʊ?» ");
INSERT INTO bib_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Gʊɔɔ kʊ ŋ nyɩnta b'ʊ rɔ wɔɔ naa ma, ŋ ʊ: «K'a tʊr ka, a ɩ *Elii birm k'an b'a da a han.» ");
INSERT INTO bib_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ŋ deem n bra si an aa hɔ mafʊ-mafʊda sa, an a nyɔɔ hɔ hɛɛnr ma, an a du bənkə ma, an a ka Yeezuu ʊ k'an a mi, an n'a hɩrɛ, a ʊ: «K'a to, k'ʊ dɩga a Elii zɛm b'a zer gɛ.» ");
INSERT INTO bib_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yeezuu n zee gʊta da, an ga. ");
INSERT INTO bib_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wosocɛ bɩ pɛɛra bɩ n kaansʊ a bire ʊ, an a sa mim ʊ an b'a zɛ tara ma. ");
INSERT INTO bib_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yarbənno cir bɩ n jɩm, an a nya Yeezuu rɛ. K'a yɩ an ga maam bɩ, a a hɩ, a ʊ: «Sɩra m, gʊaa naa do nyɩnta Woso Nyɩ paan….» ");
INSERT INTO bib_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Lannɔ nyɩnta b'ʊ, ŋnɩ jɩm laatʊ ŋn'ɩ dɩgam. Magdalaa Maarii nyɩnta ŋ bire ʊ, kan Salomee kɩ, Zozee kan Zakkɩ poore da Maarii kɩ. ");
INSERT INTO bib_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yeezuu k'a nyɩnta Galilee ʊ bɩ, lannɔ nɔɔn duro nyɩnta ŋnɩ zu kʊ ʊ kan kɩ, ŋn'a dam han. Lannɔ gɔsɩnnɔ zu kʊ ʊ kan kɩ, ŋnɩ bʊr Zerizalɛm ʊ. ");
INSERT INTO bib_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Woso lɛ ter. *Sabaa bankarɛ wakatɩ m, a lɛ taa k'a hɩ a ʊ, hoonsire dɔmɩm n bɩr booti m. ");
INSERT INTO bib_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kɛɛrɛ bɩ, Arimatee kʊ gʊaa deem k'a tɔ m Zozɛf bɩ lee ku. Nyɩnta a ʊ gʊaa gʊta dʊdɔkənno wɔɔ bire ʊ. A nyɩnta, an nɩ dɔm Woso cirbəə bɩ zɛrɛ ma. A n a heer ba koodə, an ta Pɩlatɩ zi, k'a yaa Yeezuu gər bɩ yɛ han. ");
INSERT INTO bib_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yeezuu k'a ga lɛɛm ncɩnaaʊ bɩ, Pɩlatɩ zɛ kədə, an yarbənno cir bɩ bir, an a lar kʊ Yeezuu garɛ bɩ maasɩrɛ ba gɛ. ");
INSERT INTO bib_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","K'a hɔ kʊ yarbənno cir b'a hɩ bɩ ma bɩ, a Yeezuu gər bɩ ka Zozɛf ʊ. ");
INSERT INTO bib_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zozɛf n pɛɛra fɛʊda si, an a ka, n n Yeezuu gər bɩ zer gɔdarkʊra bɩ ma, an pɛɛra fɛʊda bɩ burgu ma, an aa wʊta yaa kʊ n y'a hɔn ci ʊ b'ʊ. A n jaa gʊta gərgu, an a ta yaa bɩ lɛ rɛ. ");
INSERT INTO bib_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdalaa Maarii kan Zakkɩ da Maarii kɩ nyɩnta b'ʊ, ŋn'ɩ dɩgam bɩncɛ kʊ n nɩ Yeezuu gər bɩ wʊtaŋ ʊ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","*Sabaa hinni bɩ k'a cem bɩ, Magdalaa Maarii kan Salomee kɩ, Maarii Zakkɩ da kɩ tidəər si k'a yaa da Yeezuu ma. ");
INSERT INTO bib_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hatʊ hinni k'an lɛɛkarɛ dɔmɩm bɩ wutigʊta m bɩ, ŋ bʊr yaa ra b'ʊ, bɩ ma bɩ, woso n haan y. ");
INSERT INTO bib_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ŋ n'a hɩm kʊ m, ŋ ʊ: «Nka n nɩ jaa bɩ gʊm wɔɔ m yaa bɩ lɛ rɛ?» ");
INSERT INTO bib_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kʊ ŋ y'a bɔɔta ŋnɩ dɩga bɩ, ŋ jaa k'a nyɩnta gʊta bɩ yɩ, n n a gərgu, n n a gʊ yaa bɩ lɛ rɛ. ");
INSERT INTO bib_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ŋ n gasʊ yaa b'ʊ, ŋn'aa nyukumbueere yɩ, an nɩ nyɩntam bɩsɩ ʊ, an zaba fu du a ma. Ŋ da n bɔ ʊ gʊta. ");
INSERT INTO bib_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A n a hɩ ŋ nɩ, a ʊ: «A da bɩ bɔ ʊ y. Mɔɔ dɔ mɔɔ ʊ, Nazarɛtɩ Yeezuu kʊ n y'a wɔ gɔdarkʊra ma b'awɔɔ n'a kam ma. A a mɩm bɔ ʊ, a ba naa ʊ dɔ y. Ba bɩncɛ kʊ n y'a wʊta ʊ bɩ n na.» ");
INSERT INTO bib_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bɩ, k'a yaa a hɩ Pɩyɛɛr m, kan a karɩndanyɩnɔ gɔsɩnnɔ wɔɔ kɩ, a ʊ: «A lɛɛkarɛ awɔɔ lɛɛ Galilee ʊ. Bɩncɛ bɩ do awɔɔ n n'a yɩŋ ʊ, amba a hɩ awɔɔ m bɩ m.» ");
INSERT INTO bib_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ŋ n bɔ yaa b'ʊ, ŋnɩ bra si kan mɛhinkə kɩ, ŋ n a so a ʊ y. Kan dabɔʊ k'an ta ŋ nɩ bɩ kɩ, ŋ n yɛ, ŋ n a hɩ gɔsɩ nɩ y.  ");
INSERT INTO bib_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yeezuu k'a mɩm bɔ ʊ hatʊ hinni k'an lɛɛkarɛ dɔmɩm bɩ wutigʊta m bɩ, a lɛɛ ka an a hɩnka Magdalaa Maarii m. A n nyɩnta an la zinəro ra saanhɩna a mɛ ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Magdalaa Maarii n ta, an aa hɔ k'a yɩ bɩ hɩ gʊɔɔ kʊ ŋ nyɩnta kan Yeezuu kɩ rɔ wɔɔ m. Brɔɔ haay heer nyɩnta an a zar, ŋn'ɩ nyi karɛ. ");
INSERT INTO bib_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kʊ ŋ y'a tʊr ka Magdalaa Maarii meerbaa bɩ ma an n'a hɩrɛ a ʊ, a a mɩm bɔ ʊ, b'awɔɔ yɩ bɩ, ŋ n a si nɩ y. ");
INSERT INTO bib_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bɩ kur bɩ, Yeezuu a hɩnka makra do vanta m karɩndanyɩnɔ hɩɩyɔɔ m, ŋn'ɩ bɔm tara nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ŋ n a wusigə, ŋnɩ b'a hɩ a muno karɩndanyɩnɔ wɔɔ m, bɩ brɔɔ n a si sɔ y. ");
INSERT INTO bib_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","A nyarɛ ma bɩ, a a hɩnka karɩndanyɩnɔ bueeredeem nɔ wɔɔ m, ŋnɩ nyɩnta, ŋn'ɩ hɔbɩrɛ bɩm. Yeezuu n ŋ sɩrakarɛ war kan ŋ heerkarɛ bɩ kɩ hɩ ŋ nɩ. Kʊ ŋ n gʊɔɔ kʊ ŋ y'a yɩ, an a mɩm bɔ ʊ rɔ mim si bɩ minto. ");
INSERT INTO bib_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A n bɔkarɛ, an a hɩ ŋ nɩ, a ʊ: «K'a ta durnya haay nɔ ʊ, a yaa lemim nyɩnta bɩ pa da gʊɔɔ m. ");
INSERT INTO bib_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Gʊaa k'a sɩra ka, an yɛ an batɛm si sɔ bɩ, bɩ zaa n nɩ bʊmbɔrɛ yɩm. Bɩ gʊaa k'a bɩ sɩra kam bɩ, a zaa bɩ bʊmbɔrɛ yɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ba makrarɔ kʊ sɩrakarɛzannɔ a da ma, ŋnɩ ŋ ba bɩ n na: Ŋ lam zinəro ra mɔɔ tɔ ma, ŋ lemim daarɔ hɩrɛ. ");
INSERT INTO bib_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kʊ n cem ŋnɩ mɩnnɔ gʊr a wɔ ʊ gɛɛ, ŋnɩ nyɩsɩ da hɔ ʊ, ŋn'a ka ŋ ʊ, a bɩ hɔsɩ barɛ ŋ nɩ y. Ŋ y'a wɔ kam yaabazannɔ ra, bɩ brɔɔ y'a waam.» ");
INSERT INTO bib_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kʊ Zuuba Yeezuu meer ba kan ŋ kɩ an a nya bɩ, a der, an ta arzana ʊ, an aa nyɩnta Woso bɩsɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Karɩndanyɩnɔ wɔɔ n ta, ŋn'aa lemim nyɩnta bɩ pa da lɛɛ haay ʊ. Zuuba bɩ y'a darɛ ŋ han, an nɩ lemim nyɩnta bɩ paŋŋa daŋ ʊ kan hoserlo barɛ kɩ.");
INSERT INTO bib_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Jɩtaarɛ Teofil, gʊɔɔ gʊta a tʊntɔ ʊ, ŋnɩ minno kʊ ŋ ba wɔɔ bire ʊ ŋnɩ cem nɔ wɔɔ gʊrsɩra ba. ");
INSERT INTO bib_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kasɛtɩzannɔ kʊ ŋ minno wɔɔ yɩ a sɩŋŋɩda ma kan a nyarɛ kɩ, ŋn'a ba Woso lemim nyɩnta padənno wɔɔ ɩ b'a dɩnda wɔɔ m amba ŋ y'a yɩ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mɔɔ mɩŋŋa sɔ, mɔɔ laaka dɩnda mɩŋŋa. Jɩtaarɛ Teofil, a ta mɔɔ ma mɩŋŋa, kʊ m mim haay sa a sɩŋŋɩda ma an ta kan a nyarɛ kɩ, m a gʊrsɩra ba ɩbɩɩ ma, ");
INSERT INTO bib_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","k'ɩbɩɩ n a dɔ, ɩ ʊ, hɔ kʊ n y'a dɩnda ɩbɩɩ m bɩ, sɩra m. ");
INSERT INTO bib_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Zidee cir Hɩrɔɔdɩ dɔmɩm ʊ bɩ, wosocɛmannɩbər deem ɩ nyɩnta ʊ, a tɔ m Zakarii. Abɩya hargʊaa m, a m wosocɛmannɩbər sɔ. A lʊ bɩ tɔ m Elizabɛtɩ, wosocɛmannɩbər jɩtaarɛ Aarɔn yaŋŋa m sɔ. ");
INSERT INTO bib_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ŋ hɩɩya haay nyɩnta gʊɔɔ mɩŋŋɔɔ Woso taa. Ŋ nyɩnta, ŋn'ɩ hɔ kʊ Zuuba Woso lɛ n taa bɩ bam mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ŋ n nyɩ yɩ y, bala, Elizabɛtɩ bɩ cɩna m, ŋ hɩɩya haay gusi. ");
INSERT INTO bib_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Hindeem ʊ, Zakarii y'a wosocɛmannɩbərbaa zi bam Woso taa. Hinni bɩ do ʊ bɩ, Abɩya wosocɛmannɩbənno wɔɔ zibəə hinni m. ");
INSERT INTO bib_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Amba wosocɛmannɩbənno wɔɔ tɩr a ba bɩ m bɩ, pʊɛɛga bɩ, a da a ʊ Zakarii mim la hinni bɩ do ʊ, k'an sɛ nya tidəər nyisi ʊ, an gasʊ m Wosocɛ ʊ, bɩncɛ mɩŋŋa b'ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zamaa bɩ jɩm garga ra, ŋn'ɩ yaa dam tidəər nyisi bɩ sɛ nyaʊrɛ dɔmɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zuuba Woso malɛɛka deem a hɩnka Zakarii m, an jɩm brama tidəər nyisi bɩ sɛnyaʊrɛhɔ bɩ bɩsɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakarii k'a a yɩ bɩ, a nyi wer ma, nyibəə n gasʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Malɛɛka bɩ n a hɩ m, a ʊ: «Zakarii, ɩ da bɩ bɔ ʊ y, bala, Woso ɩbɩɩ yaa si. Ɩbɩɩ lʊ Elizabɛtɩ bɩ nyɩ yɩrɛ an a ka ɩbɩɩ ʊ. B'ɩbɩɩ y'a birm Zaan. ");
INSERT INTO bib_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","B'a nyɩntam heernyɩnta kan heernyɔɔ zee kɩ ɩbɩɩ minto. Bɩ, gʊɔɔ gʊta y'a heer nyɔɔm a yɩrɛ minto. ");
INSERT INTO bib_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","A nyɩntam gʊaa gʊta Zuuba Woso taa. A bɩ dɩvɛn mire y, a bɩ bɛɛ kʊsɩ vanta mim sɔ y. K'a bʊr an a da nɔ ʊ, *Sɛnt-Ɛspri y'a heer hanm. ");
INSERT INTO bib_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A bɔm Israyɛl gʊɔɔ lɛɛ, an bʊr ŋ nɩ ŋ Zuuba Woso zi. ");
INSERT INTO bib_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A lɛɛ kam Zuuba lɛɛ, wosolɛsinnɩsorazaa *Elii hɔɔn kan a paŋŋa kɩ m, k'a bɩ ‹zɩrɔ zɛ kʊ ra kan a nyɩnɔ kɩ›, kʊ bayɛrɛzannɔ wɔɔ n hɔɔn yɩ an gʊɔɔ tɩrgɔɔ wɔɔ m. K'an zamaa banka mɩŋŋa, kʊ ŋ nɩ dɔ Zuuba ma.» ");
INSERT INTO bib_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakarii n malɛɛka bɩ lar, a ʊ: «Mɔɔ y'a bam lɔ, m a dɔ mɔɔ ʊ sɩra nɩ? Mɔɔ gusi, mɔɔ lʊ bɩ gusi sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malɛɛka bɩ n a hɩ, a ʊ: «Gabrɩyɛl m mɔɔ m, m nɩ Woso lɛɛ. Mɔɔ nyɔɔ a ʊ, kʊ m bɩ meer ba kan ɩbɩɩ kɩ, kʊ m bɩ lemim nyɩnta hɩ ɩbɩɩ m. ");
INSERT INTO bib_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bɩ, ɩbɩɩ y'ɩ bam bəətir, ɩbɩɩ b'ɩ dam ma ɩ meer ba dɔ y, an ta an minno nɔɔn duro nyarɛ dɔmɩm ku. Bala, ɩbɩɩ n sɩra ka mɔɔ meerbaa k'a nɩ zɛm bɩ kʊ yɩ dɔmɩm kʊ Woso a cɩnta b'ʊ y.» ");
INSERT INTO bib_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dɔmɩm bɩ do ʊ bɩ, zamaa b'ɩ dɔm Zakarii ma. Ŋ zɛ kədə, k'a maasɩrɛ ba Wosocɛ bɩncɛ mɩŋŋa b'ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","K'a bɔ bɩ, a n a da ma an nɩ hɔsɩ hɩrɛ ŋ nɩ y. Bɩ minto y'a ka ŋn'a dɔ, ŋ ʊ, Woso makra a yɩ Wosocɛ ʊ b'ʊ. A n hɔɔrɔ bɩmba a wɔ ma, k'a hɩnka, a ʊ, a b'a dam ma a meer ba dɔ y. A n gɔɔta bəətir. ");
INSERT INTO bib_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kʊ Zakarii a zi bɩ ba an a nya, a dɔmɩm n a ku bɩ, a a hʊr an doo. ");
INSERT INTO bib_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","K'a yɩ poore bɩ kur bɩ, a lʊ Elizabɛtɩ jɩsɩ si. A n a mɩŋŋa nyaakʊm da mom soor, an n'a hɩrɛ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Ba hɔ kʊ Zuuba Woso a ba mɔɔ m bɩ n na. A dɩga mɔɔ ma, an mɔɔ bɔ nyannɩ ʊ gʊɔɔ bire ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabɛtɩ jɩsɩ mom sɔrdɩ hɔ ma bɩ, Woso malɛɛka Gabrɩyɛl nyɔɔ Galilee tara nɔ kʊ n n'a birm Nazarɛtɩ b'ʊ, ");
INSERT INTO bib_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","nyɩmbʊɛɛrɛ deem zi. A ler n y'a bɔ gʊaa m. A jaan bɩ tɔ m Zozɛf. Cir Davɩd do gʊaa m. Nyɩmbʊɛɛrɛ bɩ tɔ m Maarii. ");
INSERT INTO bib_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malɛɛka bɩ n gasʊ zi, an a hɩ m, a ʊ: «Mɔɔ ɩ yaa darɛ ɩbɩɩ m Maarii, ɩbɩɩ kʊ Woso barka ka ɩ ʊ gʊta, Zuuba Woso ɩ kan ɩbɩɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maarii k'a meerbaa bɩ ma bɩ, a da bɔ ʊ. A n n'a hɔɔn dam yaadarɛ bɩ jɩ ma. ");
INSERT INTO bib_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malɛɛka bɩ n a hɩ m, a ʊ: «Ɩ da bɩ bɔ ʊ y Maarii, bala, ɩbɩɩ barka yɩ Woso zi. ");
INSERT INTO bib_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ɩbɩɩ jɩsɩ sim, ɩ nyɩ yɩ yar, b'ɩbɩɩ y'a birm Yeezuu. ");
INSERT INTO bib_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A nyɩntam gʊaa gʊta, bɩ n y'a birm Woso k'a lɛ da haay Nyɩ. Zuuba Woso y'a yaaba Davɩd cirbəə bɩncɛ kaŋ ʊ, ");
INSERT INTO bib_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","a cirbəə bɩm Zakɔɔb do nɔ ʊ dɔmɩm haay, b'a cirbəə bɩ nyarɛ ba ʊ y.» ");
INSERT INTO bib_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maarii n a hɩ malɛɛka bɩ m, a ʊ: «Bɩ naa y'a bam lɔ an kʊ yɩ, kʊ mɔɔ n yar dɔ naa?» ");
INSERT INTO bib_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malɛɛka bɩ n a hɩ m, a ʊ: «Sɛnt-Ɛspri zerle ɩbɩɩ mim ʊ, Woso k'a lɛ da haay paŋŋa y'a kure ɩbɩɩ ra, am hinni hɔ bɩ m. Bɩ y'a ka, nyɩ k'a nɩ zɛm k'a bɩ yɩ bɩ, n y'a birm Woso Nyɩ mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ɩbɩɩ danyɩ Elizabɛtɩ, kʊ n n'a birm cɩna b'ɩ jɩsɩ m sɔ, a mom sɔrdɩ hɔ m naa. A nyɩyar yɩm a gusimbaa nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bala, ‹hɔ ba ʊ, Woso n a da ma y.› » ");
INSERT INTO bib_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maarii n a hɩ, a ʊ: «Zuuba zibəəzaa m mɔɔ m, k'an ba mɔɔ m amba ɩbɩɩ hɩ bɩ m.» Malɛɛka bɩ n a hʊr, an a gʊ ma. ");
INSERT INTO bib_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Dɔmɩm bɩ do ʊ bɩ, Maarii wuti zɔɔ-zɔɔ, an zaa sa, an bɔ kʊrɔ kʊ ciro n ta ʊ rɔ wɔɔ ʊ, an ta Zidee kʊ deem nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A n aa gasʊ Zakarii har ʊ, an yaa da Elizabɛtɩ m. ");
INSERT INTO bib_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabɛtɩ k'a Maarii yaadarɛ bɩ ma bɩ, nyɩ k'a n'a nɔ ʊ bɩ heer ba. Sɛnt-Ɛspri n Elizabɛtɩ heer han. ");
INSERT INTO bib_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A n zee da kan paŋŋa kɩ, a ʊ: «Woso ɩbɩɩ barka da ʊ an lɛ da lannɔ haay ra, bɩ barka bɩ zer an nawʊm nyɩ k'ɩbɩɩ n nɩ zɛm b'a yɩ bɩ ra. ");
INSERT INTO bib_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nka m mɔɔ nɩ, kʊ mɔɔ Zuuba da n bɩ dɩga mɔɔ ma? ");
INSERT INTO bib_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bala, k'ɩbɩɩ yaadarɛ bɩ gasʊ mɔɔ tʊr ʊ bɩ, nyɩ bɩ heer ba mɔɔ nɔ ʊ kan heernyɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mimbirenyɩntazaa n'ɩbɩɩ m, ɩbɩɩ sɩra ka, ɩ ʊ, meerbaa kʊ n y'a hɩ ɩbɩɩ m Zuuba Woso tɔ ma bɩ kʊ yɩm.» ");
INSERT INTO bib_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Bɩ, Maarii a hɩ, a ʊ: «Mɔɔ nyi y'a lɛ bɔm mɔɔ Zuuba Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Bɩ, heernyɔɔ mɔɔ heer han, bala Woso m mɔɔ bʊmbɔrɛzaa. ");
INSERT INTO bib_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bala, a zerga an dɩga a zibəəzaa cicirzaa bɩ ma. Naa ma kɛɛrɛ bɩ, do haay y'a hɩm mɔɔ ma mimbirenyɩntazaa. ");
INSERT INTO bib_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Paŋŋazaa Woso minno gʊtɔ-gʊtɔɔ ba mɔɔ minto. A tɔ bɩ, tɔ mɩŋŋa m. ");
INSERT INTO bib_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A cicirzɛrɛ ɩ gʊɔɔ kʊ ŋ nɩ nyi bam nɩ rɔ wɔɔ mim ʊ dɔmɩm haay. ");
INSERT INTO bib_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A zibəəro gʊtɔɔ ba a wɔ paŋŋa m. A gʊɔɔ kʊ ŋ n'a mɩŋŋa busum nɔ wɔɔ hɩsɩga. ");
INSERT INTO bib_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A paŋŋazannɔ bra a cirbəəduuro ra an ŋ dundo. A n gʊɔɔ ŋʊazannɔ wɔɔ busu brama. ");
INSERT INTO bib_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A gan wʊ gʊɔɔ kʊ nɔ nɩ ŋ zɛm nɔ wɔɔ ma, an arzakazannɔ da zaa ra a wɔ n tu. ");
INSERT INTO bib_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A b'a da a zibəənyɩ Israyɛl han, an a cicirzɛrɛ bɩ tɔ da a nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ler k'a bɔ Abraham m, kan a yaŋŋɔɔ kɩ m a nyarɛ ba ʊ bɩ minto.» ");
INSERT INTO bib_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maarii gɔɔta kan Elizabɛtɩ kɩ an a zɔ mom kaakʊ ma, an bɔkarɛ, an doo. ");
INSERT INTO bib_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabɛtɩ nyɩ yɩrɛ a ku. A nyɩ bɩ yɩ yar. ");
INSERT INTO bib_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A cɩsɔnnɔ kan a dogʊɔɔ kɩ a ma ŋ ʊ, Zuuba a cicir zɛ, ŋn'a zɛ kʊ ra kan kɩ, ŋn'a heer nyɔɔm. ");
INSERT INTO bib_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nyɩ bɩ k'a dɔmɩm sinnyə ba bɩ, ŋ bʊr k'a b'a gasʊ baŋŋʊ ʊ. Ŋ y'a ŋʊa k'a tɔ ka Zakarii, am a zɩ bɩ hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","A da bɩ n a hɩ, a ʊ: «Ayy…, a tɔ m Zaan.» ");
INSERT INTO bib_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ŋ n a hɩ m, ŋ ʊ: «Ɩbɩɩ do bɩ nɔ ʊ, gʊaa ba ʊ, n n a tɔ ka ncɩnaaʊ y.» ");
INSERT INTO bib_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ŋ n makra ba a wɔ m, ŋn'a zɩ bɩ lar, kʊ n y'a birm lʊnlɔ gɛ? ");
INSERT INTO bib_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakarii n warga yɛ, an gʊrsɩrarɔ nɔɔn duro ba ma: «A tɔ m Zaan.» Ŋ haay n zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lɛɛm bɩ, Zakarii lɛ a gʊ, a nɛɛm n a bɔ kʊ zi, an nɩ meer barɛ, an n'a lɛ bɔm Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nyibəə gasʊ a cɩsɔnnɔ wɔɔ ʊ haay, an ta kʊrɔ kʊ ŋ nɩ cigəəzi rɔ wɔɔ ʊ, Zidee gʊrga haay jilli, sʊʊra n'a bam mim naa do ma. ");
INSERT INTO bib_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Gʊɔɔ kʊ ŋ mim naa do ma rɔ wɔɔ y'a hɔɔn dam, ŋn'a mɩŋŋa larm, ŋ ʊ: «Nyɩ naa do zɛm bɩ nyɩnta lɔ?» Sɩra m, Zuuba Woso wɔ nyɩnta nyɩ bɩ ra. ");
INSERT INTO bib_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sɛnt-Ɛspri nyɩnta an nyɩ bɩ zɩ Zakarii heer han, an nɩ wosolɛsinnɩsora meer barɛ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Zuuba, Israyɛl Woso n lɛbɔʊrɛ yɩ, bala, a bɩ dɩga a do ma, an a bʊmbɔ. ");
INSERT INTO bib_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A bɔ bʊmbɔrɛzaa paŋŋazaa m wɔɔ minto, a zibəənyɩ Davɩd do nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Naa a lɛɛ ka an a hɩ a lɛsinnɩsorazannɔ mɩŋŋɔɔ lɛ m biisi. ");
INSERT INTO bib_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","A ʊ, a wɔɔ bɔm wɔɔ jɩnnɔ wɔ ʊ, kan gʊaa haay k'a sɔ wɔɔ m bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A wɔɔ yaabɔɔ cicir zɛ, a a gʊaasɩbabaa mɩŋŋa tɔ da a nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","A lerbɔrɛ k'a bɔ wɔɔ yaaba Abraham m bɩ ba n nɩ: ");
INSERT INTO bib_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","K'a wɔɔ bʊmbɔ jɩnnɔ wɔ ʊ an nya, a zaa kam wɔɔ ʊ kʊ ʊ a zi ba kan heerkoodəbaa kɩ, ");
INSERT INTO bib_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mɩŋŋabaa kan tɩrgabaa kɩ nɔ ʊ, Woso taa dɔmɩm haay kan ʊ mɩsɩrbaa nyarɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","B'ɩbɩɩ, m nyɩnnɩ, ŋ y'ɩbɩɩ birm Woso k'a lɛ da haay lɛsinnɩsorazaa. Bala, ɩbɩɩ kam Zuuba lɛɛ k'ɩ zaarɔ banka, ");
INSERT INTO bib_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","k'ɩ ka, k'a dogʊɔɔ n bʊmbɔrɛ dɔ, ŋ mimbʊnyaarɔ sugur karɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bala, wɔɔ Woso bɩ cicirzɛrɛ gʊta. Naa minto bɩ, lɛɛgure y'a tom brama, an gu wɔɔ m, amba woso haanrɛ hɔ bɩ m, ");
INSERT INTO bib_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","k'a bɩ lɛɛ gu gʊɔɔ kʊ ŋ nɩ monsigə ʊ, ŋn'ɩ nyi bam zɛ m nɔ wɔɔ m, k'a bɩ laafɩɩ zaa hɩnka wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kʊ nyɩ bɩ nɩ, a ɩ mam, a heerkoodəbaa n'a dam la. A gɔɔta zaŋŋa ʊ, an ta an dɔmɩm k'a a hɩnka ʊ Israyɛl zamaa lɛɛ bɩ dɔmɩm ku. ");
INSERT INTO bib_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dɔmɩm bɩ do ʊ bɩ, cir Ogisti bɩ lɛ ka, a ʊ, n n durnya haay gʊɔɔ lɛ sa. ");
INSERT INTO bib_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lɛɛkarɛ lɛsarɛ n naa, an ba Kiriniyusi k'a nyɩnta Siirii kʊzaa bɩ dɔmɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gʊaa haay ta, kʊ n n'a lɛ sa, gʊaa biyəə lɛ sa n nawʊrɛ a kʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zozɛf wuti sɔ Galilee kʊ Nazarɛtɩ ʊ, an ta Zidee gʊrga deem kʊ n n'a birm Betelehɛm ʊ. Bɩncɛ bɩ do cir Davɩd yɩ ʊ. Bala a mɩŋŋa naa, cir Davɩd do gʊaa m. ");
INSERT INTO bib_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ta a ʊ k'a yaa lɛsarɛ bɩ wʊ kan a jaan Maarii kɩ. Bɩ ma bɩ, Maarii ɩ jɩsɩ m. ");
INSERT INTO bib_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kʊ ŋ nɩ b'ʊ bɩ, Maarii nyɩ yɩrɛ dɔmɩm a ku. ");
INSERT INTO bib_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A a dʊndɔmbaa nyɩ yɩ yar, an pɛɛra burgu ma, an a wʊta hɔbɩsɩrɔ hɔbɩrɛ mɔr ʊ. Bala, ŋ n toore yɩ saanɔɔ cɛ ʊ b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gʊrga bɩ do poo ʊ bɩ, dundonno nɩ b'ʊ, ŋn'ɩ dɔrɛ a hɔbɩsɩrɔ ma gunuu ʊ. ");
INSERT INTO bib_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Zuuba malɛɛka n a hɩnka ŋ nɩ. Zuuba lɛɛgure n yɔ ŋ nɩ. Nyibəə gʊta n ŋ nyasʊ. ");
INSERT INTO bib_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Malɛɛka bɩ n a hɩ ŋ nɩ, a ʊ: «A da bɩ bɔ ʊ y, bala, zɛ mɔɔ nawʊm lemim nyɩnta m kʊ m b'a hɩ awɔɔ m. A nyɩntam heernyɔɔ gʊta do bɩ haay minto. ");
INSERT INTO bib_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bʊmbɔrɛzaa bɩ yɩ her Davɩd tara ra awɔɔ tɔ ma. A m Krista, Zuuba. ");
INSERT INTO bib_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Makra k'a n'a kam awɔɔ n a dɔ bɩ ba n nɩ: awɔɔ yaa nyɩhure yɩ, n n pɛɛra burgu ma, n n a wʊta hɔbɩsɩrɔ hɔbɩrɛ mɔr ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lɛɛm bɩ, arzana malɛɛkarɔ cir gʊta bʊr, ŋ n b'a zɛ kʊ ra kan malɛɛka bɩ kɩ, ŋn'a lɛ bɔm Woso ʊ, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Woso n lɛbɔʊrɛ yɩ brama, kʊ gʊɔɔ k'a nɔ yɩ ŋ la tara burə ʊ rɔ wɔɔ m mɛnyɔɔ yɩ.» ");
INSERT INTO bib_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kʊ malɛɛkarɔ wɔɔ a gʊ ŋ ma ŋnɩ der brama bɩ, dundonno wɔɔ gɔɔta ŋn'a hɩm kʊ m, ŋ ʊ: «Ʊ ta Betelehɛm ʊ, k'ʊ aa hɔ k'a ba bɩ yɩ, Zuuba n a hɩ wɔɔ m bɩ.» ");
INSERT INTO bib_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ŋ n ta zɔɔ-zɔɔ, ŋn'aa Maarii yɩ kan Zozɛf kɩ, kan nyɩhure bɩ kɩ, n n a wʊta hɔbɩsɩrɔ hɔbɩrɛ mɔr ʊ. ");
INSERT INTO bib_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kʊ ŋ y'a yɩ bɩ, ŋnɩ hɔ kʊ malɛɛka b'a hɩ ŋ nɩ nyɩ naa do minto bɩ dɩnda. ");
INSERT INTO bib_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Gʊɔɔ kʊ ŋ y'a tʊr ka dundonno wɔɔ meerbaa bɩ ma haay rɔ wɔɔ, ŋ zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bɩ, Maarii minno nɔɔn duro da a heer ʊ, an n'a hɔɔn darɛ ŋ ma. ");
INSERT INTO bib_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Dundonno wɔɔ n a wusigə, ŋn'a lɛ bɔm Woso ʊ, ŋn'a daŋ ʊ, hɔ haay kʊ ŋ y'a ma, ŋn'a yɩ sɔ bɩ minto. Bala, hɔ haay ba amba malɛɛka b'a hɩ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dɔmɩm sinnyə k'a ku bɩ, n nyɩ bɩ gasʊ baŋŋʊ ʊ. N n a tɔ ka Yeezuu, tɔ kʊ malɛɛka bɩ nyɩnta an a ka, bɩ ma bɩ, a da n a jɩsɩ sa bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kʊ ŋ hubɔrɛ dɔmɩnnɔ a ku amba Moyiisi lɛ ka bɩ m bɩ, Zozɛf kan Maarii kɩ nyɩ bɩ busu, ŋnɩ ta m Zerizalɛm ʊ, k'a yaa ka Woso ʊ, ");
INSERT INTO bib_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","amba n y'a gʊrsɩra ba Zuuba lɛrɔ wɔɔ nɔ ʊ bɩ m: ‹Nyɩyar haay k'an a da nyɩ lɛɛkarɛzaa bɩ, Zuuba hɔ m.› ");
INSERT INTO bib_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","N n ‹pʊnnɔ hɩɩyɔɔ gɛɛ cirpʊʊrɛ nyɩnɔ hɩɩyɔɔ› ka, kʊ n n mannɩ ba m, amba n y'a gʊrsɩra ba Zuuba Wosoci ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gʊaa ɩ nyɩnta Zerizalɛm ʊ, a tɔ m Sɩmɩnyɔɔ. Gʊaa tɩrga m, an nɩ zum Woso ʊ mɩŋŋa. Nyɩnta a ʊ, an nɩ Israyɛl bʊmbɔrɛzaa mɩm dam. *Sɛnt-Ɛspri nyɩnta kan kɩ. ");
INSERT INTO bib_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bala, Sɛnt-Ɛspri nyɩnta an a hɩnka m, a ʊ, awɔɔ bɩ gam, k'a n Krista, kʊ Zuuba n n'a nyɔɔm bɩ yɩ y. ");
INSERT INTO bib_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sɛnt-Ɛspri a ka, an ta Wosocɛ ʊ. Bɩ ma bɩ, a Yeezuu zɩrɔ wɔɔ yɩ, ŋn'ɩ zɛrɛ a nyɩ bɩ m k'a b'a ka Woso ʊ amba n y'a gʊrsɩra ba bɩ m, ");
INSERT INTO bib_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sɩmɩnyɔɔ nyɩ bɩ si a wɔ ʊ, an barka da Woso m, an n'a hɩrɛ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Naa ma bɩ, Zuuba, ɩbɩɩ lerbɔrɛ bɩ kʊ yɩ. Ɩbɩɩ ɩ da ma, ɩ ɩ zibəənyɩ bɩ to an cem kan laafɩɩ kɩ amba ɩbɩɩ hɩ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mɔɔ ɩbɩɩ bʊmbɔrɛzaa bɩ yɩ, ");
INSERT INTO bib_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ɩbɩɩ n a banka doro haay lɛɛ. ");
INSERT INTO bib_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ɩbɩɩ do Israyɛl lɛbɔʊrɛ m. Lɛɛgure m, an n'ɩbɩɩ hɩnkam doro haay m.» ");
INSERT INTO bib_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","K'a nɩ meer bɩ barɛ ncɩnaaʊ bɩ, nyɩ bɩ zɩ kan a da kɩ zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sɩmɩnyɔɔ n ŋ barka da ʊ, an a hɩ nyɩ bɩ da Maarii m, a ʊ: «Nyɩ naa do, bʊr a ʊ k'a bɩ gʊɔɔ gʊta do, k'a gʊɔɔ gʊta wuti Israyɛl nɔ ʊ sɔ. A nyɩntam Woso makra, bɩ gʊɔɔ bɩsɩ kam ma. ");
INSERT INTO bib_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","A gʊɔɔ gʊta hɔɔndarɛrɔ kʊ ŋ y'a nyaakʊm da rɔ wɔɔ hɩnkam lɛɛgure ʊ. Bɩ k'ɩbɩɩ nɩ, kargʊ n n'ɩbɩɩ heer hɔnm.» ");
INSERT INTO bib_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Lʊ wosolɛsinnɩsorazaa deem ɩ nyɩnta b'ʊ, a tɔ m Annɩ. Nyɩnta a ʊ Fanɩyɛl nyɩmbʊɛɛrɛ, Asɛɛr do m. A gusi gʊta. A nyɩnta kan a zim k'a sa a poombaa ma bɩ kɩ dɔɔraa saanhɩna. ");
INSERT INTO bib_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","A gɔɔta zoro, a dɔɔraa businnyə a yaa si ku. A n nɩ Wosocɛ ʊ b'ʊ dɔmɩm haay, an nɩ Woso daŋ ʊ sinuu ʊ kan a gunuu ʊ kɩ. A n n'a lɛ kʊsɩm, an nɩ yaa dam sɔ. ");
INSERT INTO bib_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A mɩŋŋa bʊr dɔmɩm kʊ n nɩ nyɩ bɩ kam Woso ʊ b'ʊ, an nɩ barka dam Woso m, an nɩ nyɩ bɩ mim dɩndam gʊɔɔ kʊ ŋ nɩ dɔm ma kʊ Woso n bʊr Zerizalɛm bʊmbɔrɛ m nɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kʊ Yeezuu zɩrɔ wɔɔ hɔ kʊ n y'a gʊrsɩra ba Zuuba lɛrɔ wɔɔ nɔ ʊ bɩ ba ŋn'a nya bɩ, ŋ y'a bɔ, ŋnɩ ta Galilee kʊ Nazarɛtɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nyɩ bɩ n nɩ marɛ, a paŋŋa n n'a dam la. A mindɔrɛ nyɩnta ʊ gʊta, Woso barka nɩ kan kɩ. ");
INSERT INTO bib_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Dɔɔraa haay, Yeezuu zɩrɔ wɔɔ tɩr ta Zerizalɛm ʊ *pakkɩ cibsa ma. ");
INSERT INTO bib_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kʊ Yeezuu dɔɔraa bueerehɩɩya kʊ bɩ, ŋ ta Zerizalɛm ʊ cibsa bɩ ma, amba ŋn'a bam dɔɔraa haay bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kʊ cibsa bɩ dɔmɩnnɔ wɔɔ cem bɩ, ŋ y'a wusigə, ŋnɩ doore. Nyukumbueere Yeezuu bɩ gɔɔta Zerizalɛm ʊ, b'a zɩrɔ wɔɔ n a dɔ y. ");
INSERT INTO bib_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ŋ y'a hɔɔn darɛ ŋ ʊ, zaasənno an nɩ kan ŋ kɩ. Ŋ tarɛ bɩ yɩ dɔmɩm deem, ŋnɩ bɔkarɛ, ŋn'a sɩŋŋɩda sa, ŋn'a kam ma a yɩrɛrɔ kan a dɔrɛrɔ kɩ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bɩ, ŋ n a yɩ y. Ŋ n'a wusigə, ŋnɩ ta Zerizalɛm ʊ, a kama jɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","A dɔmɩm kaakʊ hinni ʊ, ŋ yaa a yɩ Wosocɛ ʊ, an nɩ nyɩntam karɩnsaambɔɔ bire ʊ, an n'a tʊr karɛ ŋ meerbaa ma, an nɩ ŋ larm sɔ. ");
INSERT INTO bib_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Gʊaa haay k'a n'a tʊr kam ma bɩ, zɛ a nawʊm kədə a hɔɔntaʊrɛ meerbaa nyɩbɔʊrɛ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","K'a zɩrɔ wɔɔ a yɩ bɩ, ŋ zɛ kədə, a da bɩ n a hɩ m, a ʊ: «M nyɩnnɩ, bɔ m ɩbɩɩ m naa do ba wɔɔ nɩ? Dɩga a, ɩ zɩ kan mɔɔ kɩ da bɔ ʊ, ʊ n'ʊ karɛ ɩbɩɩ ma.» ");
INSERT INTO bib_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A n a nyɩ bɔ ŋ nʊ, a ʊ: «Bɔ m an n'a kam mɔɔ ma? Awɔɔ n a dɔ a ʊ, mɔɔ m ga m, m bɩr m Zɩ har ʊ ra?» ");
INSERT INTO bib_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bɩ, hɔ k'a hɩ ŋ nɩ bɩ, ŋ n a jɩ ma y. ");
INSERT INTO bib_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yeezuu n a wusigə kan ŋ kɩ Nazarɛtɩ ʊ. A n nɩ ŋ lɛ sire. A da bɩ minno nɔɔn duro da a heer ʊ. ");
INSERT INTO bib_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeezuu nɩ marɛ, a mindɔrɛ n'a dam la. A Woso nɔ yɩ, an gʊɔɔ nɔ yɩ sɔ. ");
INSERT INTO bib_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rɔm cir Tibɛɛr cirbəə bɩrɛ dɔɔraa bueeresoor hɔ ma bɩ, Pɔns Pɩlatɩ nyɩnta an a so Zidee gʊrga ʊ, cir Hɩrɔɔdɩ n a so Galilee ʊ, a danyɩ cir Filipi n a so Itiree kʊ ʊ kan Trakonitɩ kʊ kɩ, cir Lizaniyas n a so Abɩlɛnnɩ kʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hannɩ kan *Kayiifʊ k'ɩ nyɩnta wosocɛmannɩbənno jɩtannɔ. Dɔmɩm bɩ do ʊ bɩ, Woso a lemim ka Zakarii nyɩ Zaan ʊ poohɔɔn ʊ. ");
INSERT INTO bib_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Bɩ Zaan ta Zʊrdɛn gʊrga haay ʊ, an nɩ heerlʊrlɛ kan batɛm kɩ mim pa dam gʊɔɔ m, ŋ mimbʊnyaarɔ sugur yɩrɛ minto, ");
INSERT INTO bib_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","amba n y'a gʊrsɩra ba wosolɛsinnɩsorazaa Ezayii ci nɔ ʊ bɩ m: Gʊaa leer nɩ bɔm poohɔɔn ʊ: K'a Zuuba zaa banka, k'a zaafɔɔrɛrɔ wɔɔ bɩmbanka kʊ ŋ nɩ yɩ tɩrga. ");
INSERT INTO bib_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","K'a hɔ zar toko haay ʊ, k'a ciro kan dimbirlɔ kɩ zɛ a wʊta, k'a zaarɔ kʊ ŋ y'a tʊntɔ rɔ wɔɔ hʊnhʊr, bɔɔ ɩ bɩ mɩŋŋa rɔ wɔɔ, k'a ŋ banka a ŋ lʊnlɔ. ");
INSERT INTO bib_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bʊmbɔrɛzaa k'a a to Woso zi bɩ, a gʊɔɔ bʊmbɔm do haay nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Zamaa gʊta nɩ zɛm Zaan zi, k'a bɩ batɛm si. A n n'a hɩrɛ ŋ nɩ, a ʊ: «Awɔɔ naa, cɩrka do n'awɔɔ m. Nka y'a hɩ awɔɔ m, a ʊ, a a si a bɔ lɛm Woso heerbusu k'a nɩ zɛm booti m bɩ lɛɛ? ");
INSERT INTO bib_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","K'a zi mɩŋŋa ba amba gɔ nɩ nyɩ dam bɩ m, k'an zu kʊ ʊ kan awɔɔ heerlʊrlɛ bɩ kɩ, b'a b'a hɔɔn da a ʊ, awɔɔ yaaba m Abraham nɩ y. Bala, mɔɔ y'a hɩrɛ awɔɔ m, mɔɔ ʊ, Woso a da ma, an jaarɔ nɔɔn duro wusigə an ŋ ba Abraham nyɩnɔ. ");
INSERT INTO bib_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bala, n sɩga banka an nɩ cɩntam k'an gɔrɔ zɩnzɛ ra ŋ məsi ma. Gɔ niŋŋə k'a bɩr nyɩ mɩŋŋa dam bɩ, n y'a zɛm la, n a da sɛ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Zamaa bɩ barla gʊɔɔ gɔsɩnnɔ n laaka da, ŋ ʊ: «K'a maam, k'ʊ a ba lɔ?» ");
INSERT INTO bib_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A n a nyɩ bɔ ŋ nʊ, a ʊ: «Kʊ gʊaa ɩ huu m hɩɩya, k'an a jir kan gʊaa k'a ba m bɩ kɩ. Gʊaa k'an ta hɔbɩrɛ m bɩ, k'an a ba maam sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yawʊrsinno n bʊr sɔ k'a bɩ batɛm si, ŋnɩ laaka da Zaan han, ŋ ʊ: «Karɩnsaamba, bɔ wɔɔ ʊ ga m, ʊ a ba?» ");
INSERT INTO bib_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A n a hɩ ŋ nɩ, a ʊ: «A bɩ busoo si an lɛ da lɛ kʊ n y'a ka bɩ ra y.» ");
INSERT INTO bib_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Yarbənno n a lar sɔ, ŋ ʊ: «Bɩ wɔɔ, bɔ wɔɔ ʊ ga m, ʊ a ba?» A n a nyɩ bɔ ŋ nʊ, a ʊ: «A bɩ paŋŋa ba gʊaa ma y, b'a bɩ ŋʊaar ba a ka gʊaa lɛ m k'a busoo yɩ y. Bɩ k'a zerga a yawʊra bɩ rɛ.» ");
INSERT INTO bib_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Zamaa bɩ nɩ dɔm hɔ k'a nɩ zɛm bɩ nyɩnta ʊ bɩ ma. N n'a hɔɔn dam. N nɩ laaka darɛ a mɩŋŋa han a heer ʊ, ŋ ʊ: «Krista bɛɛ m Zaan bɩ m na?» ");
INSERT INTO bib_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Zaan n a hɩ ŋ haay m, a ʊ: «Mɔɔ naa, batɛm mɔɔ n'a karɛ awɔɔ ʊ hi ʊ. Bɩ, gʊaa ɩ zɛm, a paŋŋa n lɛ da mɔɔ ra, bɩ mɔɔ n m ga m, m a kʊsɔrɔ bar tɔkkɛ hʊr y. A batɛm karɛ awɔɔ ʊ Sɛnt-Ɛspri m kan sɛ kɩ m. ");
INSERT INTO bib_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A gʊr sa a wɔ ʊ, k'a tʊyaa kʊnkɔ m, k'a hɔyaa zo m. A hɔyaa bɩ zarlɛ a sɩ ʊ, a sɛ k'a bɩr lihim bɩ nyam puur b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ncɩnaaʊ bɩ, Zaan a ya, an minno gɔsɩnnɔ hɩ gʊɔɔ wɔɔ m, an nɩ lemim nyɩnta bɩ hɩm Israyɛl gʊɔɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bɩ kur bɩ, Zaan nyaa ba kan cir Hɩrɔɔdɩ kɩ, a cɛmba lʊ Hɩrɔdɩyaadɩ k'a yɔm, kan a hɔbaa bʊnyaarɔ vantɔɔ wɔɔ haay kɩ minto. ");
INSERT INTO bib_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kɛɛrɛ bɩ, Hɩrɔɔdɩ a ya, an mimbʊnyaa ba an a na ma: a a ka n nɩ Zaan du lɔnnɔcɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dɔmɩm kʊ zamaa bɩ haay nɩ batɛm siŋ ʊ bɩ, Yeezuu batɛm si sɔ. K'a nɩ yaa dam bɩ, brama a gʊ, ");
INSERT INTO bib_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","*Sɛnt-Ɛspri n cirpʊʊrɛ mɛ sa, an zer a mim ʊ. Leer n a to brama an n'a hɩrɛ, a ʊ: «Mɔɔ Nyɩ n'ɩbɩɩ m, mɔɔ ɩbɩɩ ŋʊa gʊta, mɔɔ nɔ yɩ ɩbɩɩ ra.» ");
INSERT INTO bib_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yeezuu dɔɔraa bɩ, a ga kʊ ʊ a ba kan bukərku kɩ, an bɔkarɛ an a zibəə sa. Ŋ y'a hɔɔn darɛ, ŋ ʊ Zozɛf nyɩ m. Zozɛf zɩ m Helii m, ");
INSERT INTO bib_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Helii zɩ m Mataat m, Mataat zɩ m Levii m, Levii zɩ m Mɛlkii m, Mɛlkii zɩ m Yanayɩ m, Yanayɩ zɩ m Zozɛf m, ");
INSERT INTO bib_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zozɛf zɩ m Matatɩyas m, Matatɩyas zɩ m Amɔs m, Amɔs zɩ m Nahum m, Nahum zɩ m Hɛslii m, Hɛslii zɩ m Nagayɩ m, ");
INSERT INTO bib_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayɩ zɩ m Maatɩ m, Maatɩ zɩ m Matatɩyas m, Matatɩyas zɩ m Semeyini m, Semeyini zɩ m Yosɛkɩ m, Yosɛkɩ zɩ m Yooda m, ");
INSERT INTO bib_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yooda zɩ m Yohanam m, Yohanam zɩ m Reeza m, Reeza zɩ m Zorobabɛl m, Zorobabɛl zɩ m Salatɩyɛl m, Salatɩyɛl zɩ m Neerii m, ");
INSERT INTO bib_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neerii zɩ m Mɛlkii m, Mɛlkii zɩ m Adii m, Adii zɩ m Kozam m, Kozam zɩ m Ɛlmadam m, Ɛlmadam zɩ m Ɛɛr m, ");
INSERT INTO bib_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛɛr zɩ m Yeezuu m, Yeezuu zɩ m Eliyezɛɛr m, Eliyezɛɛr zɩ m Yoorim m, Yoorim zɩ m Mataat m, Mataat zɩ m Levii m, ");
INSERT INTO bib_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levii zɩ m Sɩmɩnyɔɔ m, Sɩmɩnyɔɔ zɩ m Ziida m, Ziida zɩ m Zozɛf m, Zozɛf zɩ m Yoonam m, Yoonam zɩ m Eliyakim m, ");
INSERT INTO bib_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim zɩ m Meleyaa m, Meleyaa zɩ m Menaa m, Menaa zɩ m Matataa m, Matataa zɩ m Natan m, Natan zɩ m Davɩd m, Davɩd zɩ m Yesee m, ");
INSERT INTO bib_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Yesee zɩ m Yobɛdɩ m, Yobɛdɩ zɩ m Boozɩ m, Boozɩ zɩ m Salaa m, Salaa zɩ m Naasɔɔn m, ");
INSERT INTO bib_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasɔɔn zɩ m Aminadaab m, Aminadaab zɩ m Admɩnɩ m, Admɩnɩ zɩ m Arnii m, Arnii zɩ m Ɛsrɔm m, Ɛsrɔm zɩ m Farɛɛs m, Farɛɛs zɩ m Ziida m, ");
INSERT INTO bib_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ziida zɩ m Zakɔɔb m, Zakɔɔb zɩ m Izakkɩ m, Izakkɩ zɩ m Abraham m, Abraham zɩ m Taaraa m, Taaraa zɩ m Nahɔɔr m, ");
INSERT INTO bib_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahɔɔr zɩ m Seruki m, Seruki zɩ m Ragoo m, Ragoo zɩ m Falɛkɩ m, Falɛkɩ zɩ m Ebɛɛr m, Ebɛɛr zɩ m Salaa m, ");
INSERT INTO bib_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salaa zɩ m Kayɩnam m, Kayɩnam zɩ m Arfasatɩ m, Arfasatɩ zɩ m Sɛm m, Sɛm zɩ m Nowee m, Nowee zɩ m Lamɛk m, ");
INSERT INTO bib_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛk zɩ m Matusalam m, Matusalam zɩ m Enɔk m, Enɔk zɩ m Yarɛtɩ m, Yarɛtɩ zɩ m Maleleyɛl m, Maleleyɛl zɩ m Kayɩnam m, ");
INSERT INTO bib_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayɩnam zɩ m Enɔs m, Enɔs zɩ m Sɛt m, Sɛt zɩ m Adam m, Adam zɩ m Woso m. ");
INSERT INTO bib_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeezuu kʊ Sɛnt-Ɛspri a han bɩ, a a to Zʊrdɛn kɔ lɛ ra b'ʊ, Sɛnt-Ɛspri n a ka, an ta poohɔɔn ʊ. ");
INSERT INTO bib_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","B'ʊ bɩ, Sʊtaana a makra ba dɔmɩm busi. A n hɔsɩ bɩ dɔmɩnnɔ wɔɔ duro nɔ ʊ y. Bɩ dɔmɩnnɔ wɔɔ duro kʊ ŋ cem bɩ, nɔ a nyasʊ. ");
INSERT INTO bib_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sʊtaana bɩ n a hɩ m, a ʊ: «Kʊ Woso Nyɩ n'ɩbɩɩ m, k'ɩ ka kʊ jaa naa do n a ba bur.» ");
INSERT INTO bib_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeezuu n a hɩ m, a ʊ: «N y'a gʊrsɩra ba Wosoci ʊ, n ʊ: Gʊaa b'a dam ma an mɩsɩrbaa ba hɔbɩrɛ m bala y.» ");
INSERT INTO bib_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sʊtaana bɩ n ta m brama, an tara burə cirbəəro haay hɩnka m lɛɛm. ");
INSERT INTO bib_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","A n a hɩ m, a ʊ: «Mɔɔ cirbəəro nɔɔn duro paŋŋa kan a arzaka kɩ karɛ ɩbɩɩ ʊ, ɩ ɩ so ʊ. Bala, mɔɔ hɔɔ m. Mɔɔ m da ma m a ka gʊaa kʊ mɔɔ ŋʊa ʊ. ");
INSERT INTO bib_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bɩ, k'ɩbɩɩ yɛ ɩ kukurə zɛ mɔɔ taa ɩ mɔɔ da ʊ, mɔɔ yɩ ŋ karɛ ɩbɩɩ ʊ haay.» ");
INSERT INTO bib_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeezuu n a hɩ m, a ʊ: «N y'a gʊrsɩra ba, n ʊ: Ɩ ɩ Zuuba Woso da ʊ, bɩ, deem bala ɩbɩɩ n nɩ yaa dam nɩ.» ");
INSERT INTO bib_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sʊtaana bɩ n a gaa, an ta m Zerizalɛm ʊ, an aa a jɩm Wosocɛ bɩ mim ʊ, an a hɩ m, a ʊ: «Kʊ Woso Nyɩ n'ɩbɩɩ m, k'ɩ hɩr naa ʊ, ɩ ɩ da tara ʊ: ");
INSERT INTO bib_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bala, n y'a gʊrsɩra ba, n ʊ: Woso lɛ karɛ a malɛɛkarɔ ʊ, kʊ ŋ nɩ dɔ ɩbɩɩ ma, ");
INSERT INTO bib_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","bɩ, n y'a gʊrsɩra ba sɔ, n ʊ: Ŋ y'a wɔ karɛ ɩbɩɩ taa k'ɩ b'ɩ gəm zɛ jaa ma y.» ");
INSERT INTO bib_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yeezuu n a hɩ m, a ʊ: «N y'a hɩ: ɩ bɩ da Zuuba ɩ Woso lɛ ʊ y.» ");
INSERT INTO bib_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kʊ Sʊtaana bɩ Yeezuu makra ba kan makrarɔ do haay kɩ an a nya bɩ, a a gʊ ma an cem, an n'a kam toore vanta ma. ");
INSERT INTO bib_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kɛɛrɛ bɩ, kan Sɛnt-Ɛspri paŋŋa kɩ, Yeezuu a bɔ an bʊr Galilee ʊ. A tɔ n bɔ lɛɛ haay ʊ. ");
INSERT INTO bib_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A n nɩ hɔ dɩndam sokʊmacɛrɔ ʊ, gʊaa haay n'a lɛ bɔŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yeezuu ta Nazarɛtɩ ʊ, kʊ kʊ n y'a tʊr ʊ b'ʊ. A n gasʊ sokʊmacɛ b'ʊ hoonsire hinni kʊ n n'a birm *sabaa bɩ hinni ʊ, amba a tɩr a ba biisi bɩ m. A n wuti k'a Wosoci karɩnda ba. ");
INSERT INTO bib_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","N nɩ wosolɛsinnɩsorazaa Ezayii ci ka ʊ. K'a ci bɩ hʊr bɩ, a a zɛ bɩncɛ kʊ n y'a gʊrsɩra ba ncɩnaaʊ bɩ ma: ");
INSERT INTO bib_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Zuuba mɔɔ bɔ ʊ, a a Sɛnt-Ɛspri zer mɔɔ ra, kʊ m lemim nyɩnta pa da cicirzannɔ m, kʊ m gʊɔɔ kʊ ŋ heer a zar lɔ wɔɔ heer wʊta. A mɔɔ nyɔɔ kʊ m b'a hɩ lɔnnɔ m, ŋ y'a mɩŋŋa ku, kʊ m a hɩ bʊʊrɔ m, ŋ mɩm lɛɛ yɩm. Gʊɔɔ kʊ ŋ nɩ fɩr nɔ ʊ rɔ wɔɔ n bʊmbɔrɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mɔɔ nyɔɔ a ʊ sɔ, kʊ m ba hɩ gʊɔɔ m, Zuuba barka dɔ ɩ gʊ ra. ");
INSERT INTO bib_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","A n ci bɩ huŋŋu, an a ka sokʊmacɛ bɩ zibəənyɩ b'ʊ, an nyɩnta. Ŋ haay kʊ ŋ nɩ cɛ b'ʊ bɩ, ŋ y'a zɛ kʊ ra, ŋn'ɩ dɩgam Yeezuu ma. ");
INSERT INTO bib_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A n a sa ma, an n'a hɩrɛ ŋ nɩ, a ʊ: «Wosoci meerbaa k'awɔɔ ma dɩɩtaa-dɩɩtaa naa ʊ bɩ kʊ yɩ her.» ");
INSERT INTO bib_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ŋ haay n yɛ Yeezuu ma y, bɩ ŋ zɛ kədə barka meerbaa nyɩnta k'a n'a bam bɩ tɔ ma. Ŋ n'a hɩrɛ, ŋ ʊ: «Zozɛf nyɩ bɩ bɛɛ m naa ra?» ");
INSERT INTO bib_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mɔɔ dɔ mɔɔ ʊ awɔɔ bɔɔr naa do zɛm mɔɔ ma: Lɔɔtɔr, lɛɛ ka ɩ ɩ mɩŋŋa waa. Wɔɔ hɔ k'ɩbɩɩ ba Kapɛrnawum ʊ bɩ ma. Bɩ ba ɩ kʊ ʊ naa ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yeezuu a ya, an a hɩ, a ʊ: «Sɩra m, n bɩr wosolɛsinnɩsorazaa sɩ sim mɩŋŋa a kʊ ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Awɔɔ dɔ mɩŋŋa, biisi bɩ, wosolɛsinnɩsorazaa *Elii dɔmɩm ʊ, la a gʊsɩ barɛ ma dɔɔraa kaakʊ kan mom kɩ sɔrdɩ, nɔ gʊta n a da tara bɩ ra haay. Zonno nyɩnta ʊ gʊta Israyɛl ʊ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bɩ, Woso n Elii nyɔɔ ŋ gʊaa deem zi y, kʊ bɩ m, zoro deem k'a nyɩnta ʊ Sarɛptaa ʊ, Sidɔn gʊrga ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kusimoo nyɩnta ʊ sɔ gʊta Israyɛl ʊ wosolɛsinnɩsorazaa Elizee dɔmɩm ʊ. Bɩ ŋ gʊaa deem taan… n a waa, kʊ saana k'a a to Siirii ʊ, n n'a birm Naaman bɩ bɛɛ y.» ");
INSERT INTO bib_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kʊ ŋ naa ma bɩ, ŋ haay nɔ ma ʊ gʊta sokʊmacɛ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ŋ nɩ wuti, ŋn'a nyʊnnyɔɔta, ŋnɩ bɔ m tara nɔ ʊ b'ʊ, ŋnɩ ta m a kʊ ci mim ʊ k'a yaa nyɔɔta a bɩra a da tara ʊ. ");
INSERT INTO bib_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yeezuu n bɔ ŋ bireyaa ʊ, an cem. ");
INSERT INTO bib_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yeezuu ta Galilee gʊrga deem Kapɛrnawum ʊ, an nɩ hɔ dɩndam gʊɔɔ m *sabaa hinni ʊ. ");
INSERT INTO bib_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ŋ zɛ kədə a hɔdɩndarɛ tɔ ma, bala, a meer bɩ ba an nawʊm lɛ k'an ta m bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gʊaa deem ɩ nyɩnta sokʊmacɛ ʊ b'ʊ, zinə nɩ kan kɩ. A n zee da kan paŋŋa kɩ a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Hey! Nazarɛtɩ Yeezuu, ɩbɩɩ bɔ nɩ wɔɔ zi? Bʊr ɩbɩɩ ʊ k'ɩ bɩ wɔɔ zɩnzɛ gɛ? Kʊ nka n'ɩbɩɩ m, mɔɔ dɔ mɩŋŋa, gʊaa mɩŋŋa kʊ Woso a nyɔɔ bɩ n'ɩbɩɩ m.» ");
INSERT INTO bib_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeezuu n zinə bɩ da jɩm ʊ a meerbaa m, an n'a hɩrɛ, a ʊ: «Zɛ hi, k'ɩ bɔ gʊaa bɩ mɛ ʊ.» Zinə bɩ n gʊaa bɩ do tara ʊ zamaa bɩ lɛɛ, an bɔ a mɛ ʊ, b'a n yaaba da ma y. ");
INSERT INTO bib_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ŋ haay zɛ kədə, ŋn'a hɩm kʊ m, ŋ ʊ: «Bɔ meerbaa m naa! A n nɩ lɛ kam zinəro ʊ kan paŋŋa kɩ ŋn'ɩ bɔrɛ!» ");
INSERT INTO bib_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","N nɩ Yeezuu mim dɩndam lɛɛ haay ʊ, gʊrga bɩ do nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeezuu k'a bɔ sokʊmacɛ ʊ b'ʊ bɩ, a ta gʊaa kʊ n n'a birm Sɩmɔɔn har ʊ. A n aa dɩga a, Sɩmɔɔn dində ɩ yaaba m. Ŋ n a yɛ Yeezuu han k'an a waa. ");
INSERT INTO bib_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yeezuu n a zɔ ma, an zerga a burə ʊ, an həən si yaaba bɩ ma, an bɔ a mɛ ʊ. A n wuti lɛɛm an nyasʊ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kʊ woso lɛ a da bɩ, gʊɔɔ kʊ ŋ nɩ yaabazannɔ m, ŋnɩ yaaba do haay m bɩ, ŋ bʊr ŋ nɩ Yeezuu zi. Bɩ n a wɔ ka ŋ gʊaa deem-deem la, an ŋ waa. ");
INSERT INTO bib_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Zinəro bɔ yaabazannɔ gʊta mɛ ʊ, kan zee kɩ, ŋ ʊ: «Woso Nyɩ n'ɩbɩɩ m!» Bɩ, Yeezuu ɩ həən sire ŋ ma, a bɩr yɛm kʊ ŋ nɩ meer ba y. Bala, zinəro wɔɔ a dɔ, ŋ ʊ Krista m. ");
INSERT INTO bib_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Dɔ k'a mɛ bɩ, Yeezuu bɔ, an ta poohɔɔn ʊ, gʊɔɔ gʊta n'a kam ma. Kʊ ŋ y'a yɩ bɩ, ŋ y'a ŋʊa kʊ Yeezuu n gɔɔta kan a kɩ. ");
INSERT INTO bib_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bɩ, Yeezuu a hɩ ŋ nɩ, a ʊ: «Pakra m, kʊ m aa Woso cirbəə bɩ pa da tara gɔsɩnnɔ ra, bala, mɔɔ nyɔɔ n y'a ʊ bɩ minto.» ");
INSERT INTO bib_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A n nɩ hɔ dɩndam gʊɔɔ m Zidee sokʊmacɛrɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Hindeem ʊ, Yeezuu ɩ jɩnɩm *Zenezarɛtɩ higʊta lɛ ra, zamaa bɩ nɩ kʊ nyʊnnyɔɔtam a jɩr ʊ k'a tʊr ka Woso lemim ma. ");
INSERT INTO bib_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A kɔɔlʊʊ yɩ hɩɩya higʊta bɩ lɛ ra. Zɔbənno wɔɔ n bra, ŋn'a zaŋŋarɔ sʊrgɔm. ");
INSERT INTO bib_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yeezuu n da kɔɔlʊʊ bɩ deem ʊ. Nyɩnta a ʊ Sɩmɔɔn hɔ. A n a yɛ han k'an a gaa higʊta bɩ lɛ ma poore. Yeezuu n nyɩnta, an a to kɔɔlʊʊ bɩ nɔ ʊ, an nɩ hɔ dɩndam zamaa bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","K'a meer bɩ ba an a nya bɩ, a a hɩ Sɩmɔɔn m, a ʊ: «Ɩ zɔ hi bɩ nɔ ʊ, k'a a zaŋŋarɔ wɔɔ zo, k'a zɔ gʊr.» ");
INSERT INTO bib_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sɩmɔɔn n a nyɩ bɔ ʊ, a ʊ: «Karɩnsaamba, wɔɔ zi ba gunuu ʊ tee… bɩ wɔɔ n hɔsɩ nyasʊ y. Bɩ k'ɩbɩɩ hɩ bɩ, mɔɔ yɩ ŋ zom.» ");
INSERT INTO bib_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kʊ ŋ zaŋŋarɔ wɔɔ zo bɩ, ŋ zɔ gʊr gʊta, ŋ zaŋŋarɔ wɔɔ nɩ kɩnkaansʊrɛ. ");
INSERT INTO bib_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ŋ n a to, ŋn'a wɔ zo a zibəəkɔɔnrɔ kʊ ŋ nɩ kɔɔlʊʊ deem bɩ nɔ ʊ rɔ wɔɔ m, kʊ ŋ nɩ b'a da a han. Brɔɔ n bʊr, ŋnɩ b'a da ŋ han ŋn'a waa ʊ, ŋn'a zar kɔɔlʊʊrɔ hɩɩyɔɔ wɔɔ ʊ, an a han, ŋn'a yo k'a nyoo ba. ");
INSERT INTO bib_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sɩmɔɔn Pɩyɛɛr k'a naa yɩ bɩ, a kukurə zɛ Yeezuu taa, an n'a hɩrɛ, a ʊ: «Zuuba, ɩ ba mɔɔ ma laatʊ, bala, mimbʊnyaabər m mɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Dabɔʊ gʊta y'a nyasʊ kan a muno wɔɔ kɩ, zɔ gʊta kʊ ŋ y'a gʊr bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Dabɔʊ Zebedee nyɩnɔ Zakkɩ kan Zaan kɩ kʊ ŋ nɩ Sɩmɔɔn zibəəkɔɔnrɔ wɔɔ nyasʊ sɔ. Yeezuu n a hɩ Sɩmɔɔn m, a ʊ: «Ɩ da bɩ bɔ ʊ y, naa ma kɛɛrɛ bɩ, ɩbɩɩ zɔnɔ gʊr biisi, ɩbɩɩ y'ɩ bam gʊɔɔkamazaa kɛɛrɛ.» ");
INSERT INTO bib_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ŋ n a bɔ, ŋnɩ bʊr kɔɔlʊʊrɔ wɔɔ m higʊta lɛ ra b'ʊ, ŋnɩ hɔ haay bɩ to, ŋnɩ zu kʊ ʊ kan kɩ. ");
INSERT INTO bib_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yeezuu k'a yaa lee ku tara deem la bɩ, gʊaa nɩ b'ʊ kusiməbaa n ta ma jilli. K'a Yeezuu yɩ bɩ, a sʊnta, an a meer zuutə tara ʊ, an yaa da m, a ʊ: «Zuuba, k'ɩ lɛ taa ma, ɩ ɩ da ma ɩ mɔɔ waa, k'ɩ dintim gʊ mɔɔ ma.» ");
INSERT INTO bib_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeezuu n a wɔ hʊr, an a da ma, a ʊ: «Mɔɔ lɛ taa, ɩ waa.» Lɛɛm bɩ, a kusiməbaa bɩ nya ma. ");
INSERT INTO bib_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yeezuu n lɛ ka ʊ, a ʊ, a b'a hɩ gʊaa nɩ y. Bɩ, a a hɩ, a ʊ: «Ta ɩ yaa n'ɩ hɩnka wosocɛmannɩbər m, k'ɩ ganwʊrɛ ka amba wosolɛsinnɩsorazaa Moyiisi lɛ ka bɩ m, ɩ dintim gʊ ɩ ma minto, k'an nyɩnta kasɛtɩ gʊaa haay lɛɛ.» ");
INSERT INTO bib_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bɩ y'a ka Yeezuu tɔ n bɔ an n'a dam la. Zamaa gʊta n tɩr a zɛm kʊ ra, k'a tʊr ka a lemim ma, k'a ka kʊ Yeezuu n a waa a yaabarɔ minto. ");
INSERT INTO bib_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bɩ, kʊ Yeezuu nɩ, ta a tɩr a ʊ a deem bɔlɛɛmarɔ ʊ, an bɩr yaa darɛ. ");
INSERT INTO bib_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Hindeem ʊ, Yeezuu nyɩnta an nɩ hɔ dɩndam. Farizɛɛnrɔ kan wosocikarɩnsaambɔɔ kɩ nyɩnta b'ʊ. A to ŋ y'a ʊ Galilee kan Zidee kɩ Zerizalɛm kɩ kʊrɔ ʊ, ŋnɩ bʊr. Zuuba paŋŋa nyɩnta kan Yeezuu kɩ, an a ka, an nɩ yaabazannɔ waam. ");
INSERT INTO bib_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Gʊɔɔ n lee ku mɛgarɛzaa m wʊtarahɔ ʊ, ŋn'a kam ma k'a gasʊ m har ʊ b'ʊ, a wʊta Yeezuu taa. ");
INSERT INTO bib_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Zamaa bɩ minto bɩ ŋ n a dɔ kʊ gasʊ awɔɔ n nawʊm nɩ lʊnlɔ y. Ŋ nɩ der cɛ bɩ ra, ŋnɩ cɛ bɩ mim hɔn ra, ŋn'a nyɔɔ, ŋn'a zer kan a wʊtarahɔ bɩ kɩ Yeezuu taa zamaa bɩ lɛɛ. ");
INSERT INTO bib_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yeezuu k'a ŋ sɩrakarɛ bɩ yɩ bɩ, a a hɩ yaabazaa bɩ m, a ʊ: «Gʊaa, ɩ ɩ mimbʊnyaarɔ sugur yɩ.» ");
INSERT INTO bib_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Farizɛɛnrɔ kan wosocikarɩnsaambɔɔ kɩ y'a mɩŋŋa larm a heer ʊ, ŋ ʊ: «Gʊaa bɩ kara n naa, an nɩ Woso sʊnsɔ wʊrɛ? Nka y'a da ma an mimbʊnyaarɔ sugur ka kʊ Woso deem bɛɛ?» ");
INSERT INTO bib_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bɩ Yeezuu k'a ŋ hɔɔndarɛ bɩ yɩ bɩ, a a hɩ ŋ nɩ, a ʊ: «Bɔ m, awɔɔ n'a hɔɔn darɛ ncɩnaaʊ? ");
INSERT INTO bib_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kara n naanaa? M a hɩ, m ʊ: Ɩ ɩ mimbʊnyaarɔ sugur yɩ bɩ m gɛ, ɩ wuti ɩ ta bɩ nɩ?» ");
INSERT INTO bib_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bɩ k'awɔɔ n a dɔ a ʊ, Gʊaanyɩ b'ɩ lɛ m k'a mimbʊnyaarɔ sugur ka tara burə ʊ bɩ, an a hɩ mɛgarɛzaa bɩ m, a ʊ: «Mɔɔ y'a hɩ ɩbɩɩ m, wuti, ɩ ɩ wʊtarahɔ bɩ sa ɩ doo.» ");
INSERT INTO bib_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bɩ n wuti lɛɛm, ŋ mɩnyaa m, an a wʊtarahɔ bɩ sa, an doo, an n'a lɛ bɔm Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ŋ haay zɛ kədə, ŋn'a lɛ bɔm Woso ʊ. Dabɔʊ n ŋ nyasʊ, ŋn'a hɩrɛ, ŋ ʊ: «Wɔɔ mim daa yɩ her.» ");
INSERT INTO bib_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bɩ kur bɩ, a bɔ an yawʊrsir yɩ, a tɔ m Levii, an nɩ nyɩntarɛ a zibəə bɩncɛ ʊ. Yeezuu n a hɩ m, a ʊ: «Zu mɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levii n wuti, an a gʊ hɔ haay ma, an zu Yeezuu ʊ. ");
INSERT INTO bib_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levii n cibsa gʊta ba a har ʊ, an hɔbɩrɛ ba Yeezuu minto. Yawʊrsinno gʊta bʊr, kan gʊɔɔ vantɔɔ kɩ, ŋnɩ b'a zɛ kʊ ra, ŋn'ɩ hɔ bɩm kan ŋ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farizɛɛnrɔ kan a wosocikarɩnsaambɔɔ kɩ n bʊr, ŋn'ɩ kukur bam karɩndanyɩnɔ wɔɔ ma, ŋ ʊ: «Bɔ minto, awɔɔ n nɩ hɔ bɩm, an nɩ hɔ mim kan yawʊrsinno kɩ, mimbʊnyaabənno kɩ?» ");
INSERT INTO bib_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Laafɩɩzannɔ bɩr a kam lɔɔtɔr ma y, yaabazannɔ n n'a kam ma. ");
INSERT INTO bib_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mɔɔ n bʊr kʊ m bɩ gʊɔɔ tɩrgɔɔ bir y, bʊr mɔɔ ʊ mimbʊnyaabənno minto, kʊ ŋ n'a mɩsɩrbaa lʊr.» ");
INSERT INTO bib_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Gʊɔɔ n a hɩ Yeezuu m, ŋ ʊ: «Gallɛm gʊta Zaan karɩndanyɩnɔ kan farizɛɛnrɔ karɩndanyɩnɔ kɩ y'a lɛ kʊsɩm, ɩbɩɩ hɔɔ wɔɔ n bɔkarɛ, ŋn'ɩ hɔ bɩrɛ, ŋn'ɩ hɔ mire?» ");
INSERT INTO bib_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Awɔɔ y'a dam ma, a ka lʊ daa zim gʊaasɩbɔɔ n a lɛ kʊsɩ, kʊ lʊ daa bɩ zim b'ɩ kan ŋ kɩ ra? ");
INSERT INTO bib_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dɔmɩm zɛm, n nɩ zɛm bɩ lʊ daa zim bɩ bɔ ŋ bire ʊ. Dɔmɩm bɩ do ʊ bɩ, ŋ y'a lɛ kʊsɩm.» ");
INSERT INTO bib_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","A n a ya, an hɔbɔkʊrɛnoom vanta da ŋ nɩ, a ʊ: «Gʊaa ba ʊ, an nɩ pɛɛra daa kur sam, an a sɩnsar kan huu gusire kɩ y. Bala, pɛɛra daa bɩ b'a gam kʊ ʊ kan a gusire bɩ kɩ y. Pɛɛra daa bɩ y'a gusire bɩ kaansʊm. ");
INSERT INTO bib_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Gʊaa b'a dam ma, an dɩvɛn daa tɔ hibɔɔnrɔ gusinno ʊ y, kʊ bɩ bɛɛ nɩ, dɩvɛn bɩ yɩ ŋ hɩnhaanm, an a lo, bɩ hibɔɔnrɔ wɔɔ nyɩntam bɔm. ");
INSERT INTO bib_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bɩ, a ga a wʊm, ŋnɩ dɩvɛn daa tɔ hibɔɔnrɔ daarɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Bala, gʊaa k'a nɩ dɩvɛn gusire mim bɩ, a lɛ baa dɩvɛn daa ma y. Bala, a hɩ a nawʊrɛ, a ʊ, dɩvɛn gusire bɩ m mɩŋŋa.» ");
INSERT INTO bib_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hindeem ʊ, *sabaa hinni ʊ, Yeezuu bra hɔsɩrarɔ ʊ kan a karɩndanyɩnɔ kɩ. A karɩndanyɩnɔ wɔɔ m hɔyaa bɩ yɩnyar, ŋn'a tiŋŋə, ŋn'a sʊrɛ. ");
INSERT INTO bib_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farizɛɛnrɔ gɔsɩnnɔ n a hɩ ŋ nɩ, ŋ ʊ: «Bɔ minto, awɔɔ nɩ naa barɛ? Bɩ n n lɛ ka kʊ n naa ba sabaa hinni ʊ?» ");
INSERT INTO bib_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Nɔ k'a Davɩd nyasʊ kan a muno kɩ an hɔ niŋŋə ba bɩ, ");
INSERT INTO bib_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","an gasʊ Wosocɛ ʊ, an bur kʊ n y'a ka Woso ʊ bɩ sa, an a bɩ kan a muno wɔɔ kɩ, bɩ n nɩ lɛ ka kʊ n a bɩ kʊ wosocɛmannɩbənno bɛɛ bala bɩ, awɔɔ n a karɩnda ba ra?» ");
INSERT INTO bib_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A n n'a hɩrɛ ŋ nɩ, a ʊ: «Gʊaanyɩ bɩ m sabaa hinni bɩ minzaa.» ");
INSERT INTO bib_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabaa hinni vanta ʊ, Yeezuu gasʊ sokʊmacɛ ʊ, an nɩ hɔ dɩndam. Gʊaa nɩ b'ʊ, a bɩsɩ ra wɔ n ga. ");
INSERT INTO bib_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wosocikarɩnsaambɔɔ kan farizɛɛnrɔ kɩ nyɩnta, ŋn'ɩ dundom Yeezuu zi, k'a dɩga a, a yaabazaa bɩ waam sabaa hinni ʊ gɛ, k'a ku a mim ka ra. ");
INSERT INTO bib_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bɩ, Yeezuu ŋ hɔɔndarɛ bɩ dɔ. A n a hɩ wɔgərzaa bɩ m, a ʊ: «Wuti ɩ jɩm naa ʊ, zamaa bɩ bire ʊ.» Gʊaa bɩ n wuti an jɩm b'ʊ. ");
INSERT INTO bib_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mɔɔ kʊ m awɔɔ lar: zaa ta ʊ sabaa hinni ʊ, kʊ n nɩ zi mɩŋŋa ba gɛɛ, kʊ n nɩ zi bʊnyaa ba? Zaa ta ʊ kʊ n nɩ gʊaa meeyaa bʊmbɔ gɛɛ, kʊ n n'a zar?» ");
INSERT INTO bib_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A n dɩga ŋ ma a jɩr ʊ, an a hɩ gʊaa bɩ m, a ʊ: «Ɩ wɔ hʊr.» Gʊaa bɩ n a wɔ hʊr, a wɔ bɩ n a waa. ");
INSERT INTO bib_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bɩ, gʊɔɔ kʊ ŋ ʊ, k'a mim ka ra rɔ wɔɔ nɔ ma ʊ gʊta, ŋn'a dɩndam kan kʊ kɩ, k'a dɩga hɔ k'a n'a bam Yeezuu m bɩ ma. ");
INSERT INTO bib_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Dɔmɩm bɩ do ʊ bɩ, Yeezuu ta ci mim ʊ, k'a yaa yaa da. B'a yaa bɩ da Woso m gunuu ʊ b'ʊ kan dɔmɩrɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dɔ k'a mɩ bɩ, a a karɩndanyɩnɔ bir, an ŋ bɔ ʊ bueerehɩɩya, an tɔ ka ŋ ʊ, kristazibəəzannɔ. ");
INSERT INTO bib_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sɩmɔɔn k'a tɔ ka Pɩyɛɛr, a danzaa Andɩr, Zakkɩ, Zaan, Filipi, Bartelemii, ");
INSERT INTO bib_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyee, Toma, Alfee nyɩ Zakkɩ, Sɩmɔɔn kʊ n n'a birm *Zelɔtɩ, ");
INSERT INTO bib_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Zakkɩ nyɩ Zidas, kan Iskarɩyɔtɩ Zidas k'a a ba zambʊzaa bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeezuu a to ci mim ʊ kan ŋ kɩ, an zer, an aa jɩm bɩncɛ fapɩda ʊ. B'ʊ bɩ, a karɩndanyɩnɔ gʊta gɔɔta b'ʊ. Zamaa gʊta nyɩnta b'ʊ sɔ. A to ŋ y'a ʊ Zidee ʊ, Zerizalɛm ʊ, kan kʊrɔ kʊ ŋ nɩ higʊta lɛ ra rɔ wɔɔ kɩ ʊ, Tiir kan Sidɔn kɩ jir ʊ. ");
INSERT INTO bib_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bʊr ŋ y'a ʊ, k'a b'a tʊr ka ma, k'an a waa a yaabarɔ minto. Gʊɔɔ kʊ zinəro nɩ kan ŋ kɩ rɔ wɔɔ, ŋ y'a waam sɔ. ");
INSERT INTO bib_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Zamaa bɩ haay y'a kam ma k'a a wɔ da ma. Bala, paŋŋa nyɩnta an nɩ bɔrɛ a mɛ ʊ, an nɩ ŋ haay waarɛ. ");
INSERT INTO bib_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeezuu n dɩga a karɩndanyɩnɔ wɔɔ ma kɛɛrɛ, an a hɩ ŋ nɩ, a ʊ: «Mimbirenyɩntazannɔ n'awɔɔ m, awɔɔ k'a m ŋʊazannɔ, Woso cirbəə bɩ, awɔɔ y'a so ʊ. ");
INSERT INTO bib_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mimbirenyɩntazannɔ n'awɔɔ m, awɔɔ kʊ nɔ n'awɔɔ zɛm naa ma, hɔbɩrɛ y'awɔɔ bɔm. Mimbirenyɩntazannɔ n'awɔɔ m, awɔɔ k'a nɩ baa dam naa ma, awɔɔ yaa wʊm. ");
INSERT INTO bib_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mimbirenyɩntazannɔ n'awɔɔ m, kʊ n sɔ awɔɔ m, kʊ n kaanm awɔɔ m, kʊ n y'awɔɔ sʊnsɔ wʊ, ŋn'a bʊnyaa hɩ awɔɔ ma Gʊaanyɩ bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","K'a heernyɔɔ gʊta ba hinni bɩ do ʊ. Bala, Woso ɩ ganwʊrɛ gʊta bankam awɔɔ minto arzana ʊ. Ŋ yaabɔɔ wɔɔ, nyɩnta ŋ y'a ʊ, ŋn'a ba ncɩnaaʊ wosolɛsinnɩsorazannɔ m biisi. ");
INSERT INTO bib_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","A pakra barɛ awɔɔ m, awɔɔ arzakazannɔ. Bala, awɔɔ a heernyɔɔ yɩ biisi. ");
INSERT INTO bib_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","A pakra barɛ awɔɔ m, awɔɔ k'a hɔ bɩ an a ka her bɩ, nɔ y'awɔɔ zɛm. A pakra barɛ awɔɔ m, awɔɔ k'a nɩ yaa wʊm naa ma bɩ, awɔɔ heer y'a zarm, a baa da. ");
INSERT INTO bib_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Awɔɔ kʊ gʊaa haay n n'awɔɔ mɩŋŋabaa hɩm bɩ, a pakra barɛ awɔɔ m. Ŋ yaabɔɔ wɔɔ, a ba ŋ y'a ʊ ncɩnaaʊ biisi lɛsinnɩsorazannɔ ŋʊaarzannɔ wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«B'awɔɔ k'a n'a tʊr kam mɔɔ ma bɩ, mɔɔ y'a hɩrɛ awɔɔ m, k'a a jɩnnɔ ŋʊa, k'a hɔ mɩŋŋa ba gʊɔɔ kʊ ŋ sɔ awɔɔ m nɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gʊɔɔ kʊ ŋ nɩ ler bʊnyaa bɔrɛ awɔɔ m bɩ, k'a brɔɔ barka da ʊ. K'a yaa da gʊɔɔ kʊ ŋ ŋʊaar ba ŋn'a karɛ awɔɔ lɛ m nɔ wɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kʊ gʊaa a wɔ ta ɩ paasɩ deem lɛ, k'ɩ deem bɩ ka ʊ k'an a tarɛ. Kʊ gʊaa ɩ gɔbga yɔ ɩ m, k'ɩ to k'an ɩ huuduama sa. ");
INSERT INTO bib_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kʊ gʊaa hɔ yɛ ɩ han, k'ɩ ka ʊ. Gʊaa k'a ɩbɩɩ hɔ sa bɩ, ɩ b'a laaka da han y. ");
INSERT INTO bib_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Hɔ k'awɔɔ lɛ n taa kʊ gʊɔɔ n'a ba awɔɔ m bɩ, k'a ba ŋ nɩ maam sɔ. ");
INSERT INTO bib_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","K'awɔɔ ɩ gʊɔɔ kʊ ŋ n'awɔɔ ŋʊam nɔ wɔɔ ŋʊam bala, a nyɔɔdʊ ɩ ka? Bala mimbʊnyaabənno wɔɔ ɩ gʊɔɔ kʊ ŋ nɩ ŋ ŋʊam nɔ wɔɔ ŋʊam. ");
INSERT INTO bib_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","K'awɔɔ ɩ hɔ mɩŋŋa bam gʊɔɔ kʊ ŋ n'a barɛ awɔɔ n nɔ wɔɔ nɩ, a nyɔɔdʊ ɩ ka? Mimbʊnyaabənno wɔɔ y'a bam maam sɔ. ");
INSERT INTO bib_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","K'awɔɔ zɩm sa gʊɔɔ k'awɔɔ dɔ a ʊ, ŋ y'a karɛ awɔɔ rɔ wɔɔ nɩ, a nyɔɔdʊ ɩ ka? Bala, mimbʊnyaabənno wɔɔ ɩ zɩm sam kʊ m, k'a b'a si a lɛ ma. ");
INSERT INTO bib_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bɩ, k'a a jɩnnɔ ŋʊa, k'a zi mɩŋŋa ba ŋ nɩ, k'a zɩm sa ŋ nɩ, b'a b'a hɔɔn da a sire ma y. Maam bɩ, awɔɔ ganwʊrɛ yɩm gʊta, awɔɔ nyɩntam Woso k'a lɛ da haay nyɩnɔ. Bala, Woso mɩŋŋa ɩ kan gʊɔɔ kʊ ŋ n barka darɛ dɔ rɔ wɔɔ kɩ, a mɩŋŋa ɩ kan gʊɔɔ bʊnyaarɔ wɔɔ kɩ sɔ. ");
INSERT INTO bib_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","K'a cicirzɛrɛ zi ba, amba awɔɔ Zɩ m cicirzɛrɛzaa bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","A b'a muno dʊdɔ ka y. Maam bɩ, Woso b'awɔɔ dʊdɔ karɛ y. A b'a muno dʊdɔ yar y. Maam bɩ, Woso b'awɔɔ dʊdɔ yarlɛ y. K'a sugur ka a muno ʊ, maam bɩ, Woso sugur karɛ awɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","K'a hɔ ka a muno ʊ. Maam bɩ, Woso y'a karɛ awɔɔ ʊ sɔ. N hɔgammɔr mɩŋŋa sam, n nɩ hɔ zar m awɔɔ mɔr ʊ, an a han, n n'a yɩga-yɩga zɛ, an bɩr a lom. Bala, hɔgammɔr k'awɔɔ n ta m gʊɔɔ minto bɩ, bɩ n nɩ nyɩntam hɔgammɔr awɔɔ minto sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeezuu n a ya, an hɔbɔkʊrɛnoom da ŋ nɩ, a ʊ: «Bʊʊ y'a dam ma an bʊʊ gaa ra? Ŋ hɩɩya haay b'a zarm yaa deem ʊ ra? ");
INSERT INTO bib_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Karɩndanyɩ n lɛ da a karɩnsaamba ra y, bɩ karɩndanyɩ haay, k'a bankarɛ yɩ mɩŋŋa, a nyɩntam am a karɩnsaamba hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Bɔ nɩ, ɩ nɩ bur k'a n'ɩ mim mɩnyaa ʊ bɩ yɩrɛ, an bɔkarɛ kusə k'a n'ɩbɩɩ mɩm ʊ bɩ, ɩbɩɩ bɩr a yɩrɛ? ");
INSERT INTO bib_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ɩbɩɩ y'a bam lɔ ɩ hɩ ɩ danyɩ m, ɩ ʊ: Jɩm kʊ m bur bɔ ɩ mɩm ʊ, ɩbɩɩ n bɔkarɛ, ɩbɩɩ bɩr kusə k'a n'ɩbɩɩ mɩm ʊ bɩ yɩrɛ? Zambʊzaa, kusə bɩ bɔ ɩ mɩm ʊ cɩna, kɛɛrɛ bɩ, ɩbɩɩ mɩm lɛɛ yɩm, k'ɩ bur bɩ bɔ ɩ mim bɩ mɩm ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Gɔ mɩŋŋa ba ʊ, an nɩ nyɩ bʊnyaa darɛ y, gɔ bʊnyaa ba ʊ, an nɩ nyɩ mɩŋŋa dam sɔ y. ");
INSERT INTO bib_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","N gɔ biyəə dɔ kan a nyɩ kɩ. N bɩr sɔɔn nyɩ nɔm laa gɔ ra y. N bɩr tʊgɔ nyɩ nɔm laazankʊrɛ ra y. ");
INSERT INTO bib_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Gʊaa mɩŋŋa k'a n'a mɩŋŋabaa m bɩ, bɔ an nawʊm mim mɩŋŋa m a heer ʊ sɔ. Gʊaa bʊnyaa k'a n'a bʊnyaabaa m bɩ, bɔ an nawʊm mim bʊnyaa m a heer ʊ. Bala, hɔ k'a ɩbɩɩ heer han bɩ, b'ɩ lɛ n'a hɩm.» ");
INSERT INTO bib_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Bɔ minto m, awɔɔ nɩ mɔɔ birm Zuuba, Zuuba, b'awɔɔ bɩr hɔ kʊ mɔɔ n'a hɩm bɩ barɛ? ");
INSERT INTO bib_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Gʊaa k'a nɩ zɛm mɔɔ zi, an n'a tʊr kam mɔɔ meerbaa ma, an nɩ zi bam nɩ bɩ, kʊ m a bɔkʊrɛ hɩnka a m. ");
INSERT INTO bib_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Bɔ a kʊ ʊ kan gʊaa k'a nɩ cɛ dɔm, an yaa hɔn zukudə, an a jɩr bɩ cɩnta ci burə ʊ bɩ kɩ. La gʊta bʊr, hi n yar kan hɩnhɛr kɩ an a mom cɛ b'ʊ, b'a n a da ma, an a wurgə y, bala a dɔrɛ yɩ mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Gʊaa k'a n'a mam, b'a bɩr zi bam nɩ, bɔ a kʊ ʊ kan gʊaa k'a cɛ dɔ tara ʊ, b'a na jɩr cɩnta y. La gʊta bʊr, hi n yar kan hɩnhɛr kɩ an a mom cɛ b'ʊ, an wurgə lɛɛm. Bɩ cɛ bɩ wurgəre kur, a hɔsɩ n gɔɔta y.» ");
INSERT INTO bib_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yeezuu k'a meer bɩ ba kan gʊɔɔ wɔɔ kɩ an a nya bɩ, a wuti an ta Kapɛrnawum ʊ. ");
INSERT INTO bib_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Sʊrdaa zɔrɔ cir deem n ta lɔ m, an a ŋʊa maam-maam, an yaaba zɛ, an a zɔ zɛ ma. ");
INSERT INTO bib_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","K'a Yeezuu mim ma bɩ, a zɩɩfʊrɔ *gʊɔɔgusinno nyɔɔ zi, kʊ ŋ n'aa a yɛ han, k'an b'a lɔ bɩ waa. ");
INSERT INTO bib_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kʊ ŋ yaa lee ku Yeezuu zi bɩ, ŋ y'a yɛ han, ŋnɩ so ra, ŋn'a hɩrɛ, ŋ ʊ: «Gʊaa naa do a ga m k'ɩbɩɩ n ɩ da han, ");
INSERT INTO bib_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","bala, a wɔɔ do bɩ ŋʊa, a sokʊmacɛ dɔ an a ka wɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yeezuu n ta kan ŋ kɩ. Kʊ ŋ y'a zɔ har bɩ ma bɩ, sʊrdaa zɔrɔ cir b'a gʊaasɩbɔɔ nyɔɔ, ŋn'a hɩm, ŋ ʊ: «Zuuba, ɩbɩɩ ɩ mɩŋŋa da kɔrɛ ma, bala, mɔɔ n m ga m, k'ɩbɩɩ n gasʊ mɔɔ har ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mɔɔ m hɔɔn da mɔɔ ʊ, mɔɔ poore kʊ m bʊr ɩbɩɩ zi, bɩ k'ɩbɩɩ meer ba deem bala, mɔɔ lɔ bɩ y'a waam. ");
INSERT INTO bib_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Lɛɛzannɔ y'a so mɔɔ mɩŋŋa ʊ, mɔɔ nɩ m so sʊrdaarɔ ʊ. Kʊ mɔɔ hɩ deem m, an ta, a tam. Kʊ mɔɔ hɩ a vanta m, an bʊr, a zɛm. Kʊ mɔɔ hɩ zibəənyɩ m, an naa ba, a y'a bam.» ");
INSERT INTO bib_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yeezuu k'a naa ma bɩ, a zɛ kədə sʊrdaa zɔrɔ cir bɩ tɔ ma, an a bɔ an dɩga zamaa k'a zu a jɛ ʊ bɩ ma, a ʊ: «Mɔɔ y'a hɩrɛ awɔɔ m, baa Israyɛl nɔ ʊ, mɔɔ n sɩrakarɛ yɩ ncɩnaaʊ y.» ");
INSERT INTO bib_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Gʊɔɔ kʊ ŋ yɩ ŋ nyɔɔ rɔ wɔɔ kʊ ŋ doo sʊrdaa zɔrɔ cir bɩ har ʊ bɩ, ŋ yaa dɩga a lɔ b'a waa. ");
INSERT INTO bib_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bɩ kur bɩ, Yeezuu ta tara deem kʊ n n'a birm Nayin bɩ nɔ ʊ. A karɩndanyɩnɔ wɔɔ n zu kʊ ʊ kan kɩ kan zamaa gʊta kɩ. ");
INSERT INTO bib_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","K'a n'a zɔm tara bɩ lɛ ma bɩ, n gər busu, n nɩ tam nɩ yaa ra. Zoro nyɩ m, b'a m nyɩyar a deem a da han. Tara bɩ gʊɔɔ gʊta lʊ bɩ da zaa ʊ. ");
INSERT INTO bib_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Zuuba k'a lʊ bɩ yɩ bɩ, lʊ bɩ cicir gasʊ ʊ, an a hɩ m, a ʊ: «Ɩ b'ɩ ya ɩ nyi ka y.» ");
INSERT INTO bib_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","A n a zɔ, an a wɔ da gʊraŋŋa bɩ ma. Gʊɔɔ kʊ ŋ y'a busu rɔ wɔɔ n jɩm. Yeezuu n a hɩ, a ʊ: «Nyukumbueere, mɔɔ lɛ ka, wuti.» ");
INSERT INTO bib_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Gər bɩ n wuti an nyɩnta, an nɩ meer bam. Yeezuu n nyɩ bɩ gaa, an a ka a da ʊ. ");
INSERT INTO bib_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dabɔʊ gʊta ŋ haay nyasʊ, ŋn'a lɛ bɔm Woso ʊ, ŋ ʊ: «Wosolɛsinnɩsorazaa gʊta a hɩnka wɔɔ bire ʊ. Bɩ Woso bɩ dɩga a do ma.» ");
INSERT INTO bib_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hɔ kʊ Yeezuu a ba bɩ ta Zidee haay ʊ kan a gʊrgarɔ kɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Zaan-Batiisi karɩndanyɩnɔ yaa hɔ haay k'a ba bɩ hɩ m. Zaan nɩ ŋ gʊaa hɩɩya bir, ");
INSERT INTO bib_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","an ŋ nyɔɔ Zuuba zi kʊ ŋ n'aa a lar: «Ɩbɩɩ n nɩ dɔrɛ ɩ zɛrɛ ma bɩ gɛɛ, gʊaa vanta nɩ?» ");
INSERT INTO bib_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kʊ ŋ yaa lee ku Yeezuu zi bɩ, ŋ y'a hɩ, ŋ ʊ: «Zaan-Batiisi ɩ wɔɔ nyɔɔ ɩbɩɩ ma, k'ʊ bɩ laaka da ɩbɩɩ han: ɩbɩɩ n gʊaa k'a a ga m an bʊr bɩ gɛɛ, gʊaa vanta nɩ?» ");
INSERT INTO bib_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dɔmɩm bɩ do ʊ bɩ, Yeezuu yaabazannɔ waa gʊta, an gʊɔɔ waa a yaabarɔ do haay nɔ ʊ, kan zinərozannɔ kɩ, a bʊʊrɔ mɩm gʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","A n bɔkarɛ, an a hɩ gʊɔɔ kʊ Zaan-Batiisi ŋ nyɔɔ rɔ wɔɔ m, a ʊ: «K'a ta, a yaa hɔ k'awɔɔ yɩ, a ma sɔ bɩ hɩ Zaan m: bʊʊrɔ mɩm ɩ lɛɛ yɩm, lʊgɔrɔ ɩ tam, kusimoo laafɩɩ yɩ, tikkiro tʊr a gʊ, gəəno a mɩm bɔ ʊ, lemim nyɩnta ɩ hɩm cicirzannɔ m. ");
INSERT INTO bib_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mimbirenyɩntazaa m gʊaa k'a n a sɩrakarɛ to mɔɔ minto bɩ m.» ");
INSERT INTO bib_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Gʊɔɔ kʊ Zaan-Batiisi ŋ nyɔɔ rɔ wɔɔ kʊ ŋ y'a hʊr bɩ, Yeezuu a hɩ zamaa bɩ m, a ʊ: «Nka awɔɔ ta a yaa dɩga a poohɔɔn ʊ? Hɩnhɛr awɔɔ yɩ an nɩ niigəgɔ yəŋŋəm gɛ? ");
INSERT INTO bib_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bɔ awɔɔ ta a yaa dɩga a paan…? Gʊaa m, an huu wɩsɩ da a ra gɛ? Gʊɔɔ kʊ ŋ huu wɩsɩrɔ da a ra, ŋn'ɩ mɩsɩrbaa bam mɩŋŋa bɩ, cinno har brɔɔ n ta ʊ. ");
INSERT INTO bib_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nka awɔɔ ta a yaa dɩga a? Wosolɛsinnɩsorazaa m gɛ? Ɩɩn… mɔɔ y'a hɩ awɔɔ m, a lɛ da wosolɛsinnɩsorazaa ra. ");
INSERT INTO bib_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bala, Zaan bɩ mim n y'a gʊrsɩra ba Wosoci nɔ ʊ bɩ, n ʊ: ‹Ba mɔɔ nɩ m zibəəzaa nyɔɔrɛ ɩbɩɩ lɛɛ, k'a n'ɩbɩɩ zaarɔ bɩmbanka na.› ");
INSERT INTO bib_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mɔɔ y'a hɩrɛ awɔɔ m, lannɔ nyɩnɔ bire ʊ, gʊaa ba ʊ an lɛ da Zaan-Batiisi ra y. Bɩ gʊaa k'an poore Woso cirbəə nɔ ʊ bɩ, a lɛ da m.» ");
INSERT INTO bib_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Zamaa bɩ haay kan yawʊrsinno wɔɔ kɩ a tʊr ka Zaan ma, ŋn'a dɔ, ŋ ʊ Woso tɩrga, ŋn'a ka an batɛm ka a ʊ. ");
INSERT INTO bib_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bɩ farizɛɛnrɔ kan wosocikarɩnsaambɔɔ wɔɔ kɩ kaanm hɔ kʊ Woso lɛ n taa ŋ minto bɩ m, kaanm kʊ ŋ y'a ʊ Zaan batɛm bɩ m bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Kʊ m her gʊɔɔ nɔɔn makra ba kan bɔ kɩ? Bɔ ŋ y'a ʊ kʊ ʊ kan bɔ kɩ? ");
INSERT INTO bib_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bɔ ŋ y'a ʊ kʊ ʊ kan nyɩnɔ kʊ ŋ yaa nyɩnta daasɩ ʊ, ŋn'a to ŋn'ɩ kʊ bimbirm nɔ wɔɔ kɩ, ŋ ʊ: Wɔɔ hir hɛ awɔɔ m, b'awɔɔ n sar ba y! Wɔɔ zɛ laa lɔ b'awɔɔ n nyi ka y? ");
INSERT INTO bib_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bala, Zaan-Batiisi bʊr, a bɩr bur bɩrɛ y, a bɩr dɩvɛn mire y, awɔɔ n'a hɩrɛ, a ʊ: Zinə nɩ kan kɩ. ");
INSERT INTO bib_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Bɩ Gʊaanyɩ bɩ bʊr, an nɩ hɔ bɩm, an nɩ hɔ mim, awɔɔ ʊ: Naa do naa, nɔzaa m bɩ dɩvɛnmir m sɔ, yawʊrsinno kan mimbʊnyaabənno kɩ hannyɩ m. ");
INSERT INTO bib_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Gʊɔɔ kʊ ŋ nɩ yɛm Woso Mindɔrɛ bɩ ma rɔ wɔɔ a dɔ ŋ ʊ, Woso Mindɔrɛ bɩ tɩrga.» ");
INSERT INTO bib_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farizɛn deem Yeezuu bir k'an bɩ hɔ bɩ kan a kɩ. Yeezuu n gasʊ a har ʊ, ŋn'a sɩŋŋɩda sa, ŋnɩ hɔ bɩrɛ. ");
INSERT INTO bib_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lʊ n nɩ tara nɔ ʊ b'ʊ, mimbʊnyaabər m. A n a ma ŋ ʊ, Yeezuu ɩ hɔ bɩm farizɛn har ʊ b'ʊ. A n bʊr gedre m, n n'a ba albatɩr jaa m, tidəər n a han, ");
INSERT INTO bib_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","an bɩ sʊnta a kur a gannɔ ma, an nɩ nyi karɛ. A mɩm hi n bɔ, an n'a lom Yeezuu gannɔ ra. A n a minkə gaa, an a nʊnnɔ ma, an a wɔ barka ŋ la, an tidəər bɩ sa, an a lo ŋ la. ");
INSERT INTO bib_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farizɛn k'a Yeezuu bir bɩ k'a naa yɩ bɩ, a y'a hɩrɛ a mɩŋŋa m, a ʊ: «Kʊ wosolɛsinnɩsorazaa m gʊaa naa do nɩ, a lʊ k'a n'a wɔ nɔrɛ awɔɔ ma naa dɔm, kʊ nka m sɔ: mimbʊnyaabər naa.» ");
INSERT INTO bib_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yeezuu n a hɩ m, a ʊ: «Sɩmɔɔn, mɔɔ ɩ mim m kʊ m a hɩ ɩbɩɩ m.» A n a nyɩ bɔ ʊ, a ʊ: «Meer ba, karɩnsaamba.» ");
INSERT INTO bib_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","«Gʊaa ɩ nyɩnta ʊ, gʊaa hɩɩya n n'a zɩm m. Deem nɩ dɔmɩm zɔrsoor zibəə busoo m, deem bɩ n ta dɔmɩm busoor zibəə busoo m. ");
INSERT INTO bib_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kʊ ŋ ba busoo m k'a zɩm bɩ kam bɩ, busoo bɩ zaa b'a hɩ ŋ nɩ, a ʊ: ŋn'a to. Nka nɩ busoozaa bɩ ŋʊarɛ an lɛ da?» ");
INSERT INTO bib_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sɩmɔɔn n a hɩ, a ʊ: «Mɔɔ y'a hɩm, mɔɔ ʊ, gʊaa k'a zɩm lɛ da a mim la bɩ m.» Yeezuu n a hɩ, a ʊ: «Ɩ sɩra hɩ.» ");
INSERT INTO bib_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yeezuu n a bɔ an dɩga lʊ bɩ ma, an a hɩ Sɩmɔɔn m, a ʊ: «Ɩbɩɩ lʊ naa do yɩ ra? Mɔɔ gasʊ ɩbɩɩ har ʊ, ɩbɩɩ n hi lo mɔɔ gannɔ ra y, bɩ, a nyi ka, a mɩm hi n a lo mɔɔ gannɔ ra, an a gʊngʊ ma a minkə m. ");
INSERT INTO bib_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ɩbɩɩ n mɔɔ nyaasɩ ka kan daʊrɛ kɩ y. Bɩ lʊ bɩ mɔɔ nyaasɩ ka an a wɔ barka mɔɔ gannɔ ra, b'a bɩr a tore y. ");
INSERT INTO bib_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɩbɩɩ n nyɔɔ nɔ mɔɔ mim ma y, bɩ, a tidəər nɔ mɔɔ gannɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bɩ y'a ka mɔɔ n'a hɩrɛ ɩbɩɩ m, mɔɔ ʊ: a a mimbʊnyaarɔ k'a ŋ ba gʊta rɔ wɔɔ sugur yɩ, bɩ tɔ ma m, an ŋʊarɛ gʊta zi naa ba. Gʊaa k'a mimbʊnyaa m poore n nɩ sugur ka ʊ bɩ, a ɩ ŋʊarɛ m poore sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yeezuu n a hɩ lʊ bɩ m, a ʊ: «Ɩ ɩ mimbʊnyaarɔ sugur yɩ.» ");
INSERT INTO bib_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Gʊɔɔ kʊ ŋ nyɩnta ŋn'ɩ hɔbɩrɛ bɩm kan kɩ rɔ wɔɔ y'a hɩrɛ a heer ʊ, ŋ ʊ: «Nka m gʊaa naa do nɩ? A n yɛ an nɩ mimbʊnyaarɔ sugur karɛ?» ");
INSERT INTO bib_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yeezuu n a hɩ lʊ bɩ m, a ʊ: «Ɩ sɩrakarɛ ɩ bʊmbɔ. Ta kan laafɩɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bɩ kur bɩ, Yeezuu zaa sa an bɔ kʊrɔ gʊtɔɔ kan kʊrɔ poorero kɩ nɔ ʊ, an nɩ Woso cirbəə bɩ lemim nyɩnta pa darɛ. Karɩndanyɩnɔ bueerehɩɩyɔɔ wɔɔ nyɩnta kan kɩ, ");
INSERT INTO bib_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kan lannɔ gɔsɩnnɔ k'a ŋ waa zinəro kan yaabarɔ kɩ minto rɔ wɔɔ kɩ: Magdalaa Maarii kʊ zinəro bɔ a mɛ ʊ saanhɩna, ");
INSERT INTO bib_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Hɩrɔɔdɩ har dɩgamazaa Kuzaa lʊ Zannɩ kɩ, Sʊzannɩ kan lannɔ gɔsɩnnɔ kɩ gʊta, kʊ ŋ y'a da ŋ han a hɔnyɩrɔ m nɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Zamaa a to kʊrɔ haay ʊ, ŋnɩ bʊr Yeezuu zi. Kʊ ŋ y'a zɛ kʊ ra bɩ, Yeezuu hɔbɔkʊrɛnoom naa do da. ");
INSERT INTO bib_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Gʊaa ɩ bɔ k'a hɔ duu. K'a n'a duum bɩ, a hɩsɩga an nawʊm. A yaa gɔsɩnnɔ n a lo zaa bire ʊ. N n tʊntɔ ra, brama bɛnnɔ n a bɩ. ");
INSERT INTO bib_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Gɔsɩnnɔ n a lo jaarɔ ra. Ŋ haan, ŋnɩ gɩnga kʊ taa butur ba ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gɔsɩnnɔ n a zar laa ʊ. Ŋ bɔ, laa bɩ n a ta ŋ mee, ŋnɩ gɩnga. ");
INSERT INTO bib_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gɔsɩnnɔ n a lo lɛɛ mɩŋŋa ʊ. Ŋ bɔ, ŋnɩ nyɩ da zɔrɔ-zɔrɔ.» Yeezuu n a ya, an a hɩ, an so ra kan paŋŋa kɩ, a ʊ: «Gʊaa k'a tʊr n ta ʊ, k'an a ma!» ");
INSERT INTO bib_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yeezuu karɩndanyɩnɔ wɔɔ n a lar hɔbɔkʊrɛnoom naa do jɩ ma. ");
INSERT INTO bib_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A n a hɩ, a ʊ: «Woso zaa ka awɔɔ n hɔ k'a nyaakʊm da Woso cirbəə nɔ ʊ bɩ dɔ, bɩ, bɔɔ ɩ gɔɔta rɔ wɔɔ, hɔbɔkʊrɛnoom n n'a darɛ ŋ nɩ, kʊ ‹ŋnɩ dɩga, bɩ ŋ b'a yɩ y, kʊ ŋ n'a tʊr ka, bɩ ŋ b'a ma y.› » ");
INSERT INTO bib_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Ba hɔbɔkʊrɛnoom bɩ jɩ n na. Hɔduure bɩ, Woso lemim m. ");
INSERT INTO bib_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bɔɔ nɩ zaa bire ʊ rɔ wɔɔ, gʊɔɔ m, ŋn'a mam, Sʊtaana k'a lee ku bɩ, an nɩ hɔ k'a nɩ ŋ heer ʊ bɩ yɔrɛ ŋ nɩ, kʊ ŋ b'a da ma, ŋn'a si, ŋnɩ bʊmbɔrɛ yɩ nɩ y. ");
INSERT INTO bib_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bɔɔ nɩ jaarɔ burə ʊ rɔ wɔɔ, gʊɔɔ m, kʊ ŋ Woso lemim bɩ ma, a si ŋ nawʊm kan heernyɔɔ kɩ, bɩ ŋ məsi ba ʊ y. A si ŋ nawʊm, bɩ k'a yɩ poore, makra dɔmɩm ʊ, ŋnɩ wɔ saa. ");
INSERT INTO bib_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bɔɔ y'a zar laa ʊ rɔ wɔɔ, gʊɔɔ m, ŋn'a mam, bɩ kan hɔɔndarɛrɔ wɔɔ kɩ, durnya arzakarɔ wɔɔ kɩ, durnya heernyɔɔrɔ wɔɔ kɩ, gɔɔta ŋ nawʊm jɛ ʊ, ŋ b'a dam ma, ŋnɩ nyɩ da mɩŋŋa y. ");
INSERT INTO bib_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bɔɔ y'a lo lɛɛ mɩŋŋa ʊ rɔ wɔɔ, gʊɔɔ m, ŋn'a tʊr kam lemim bɩ ma, ŋn'a sim mɩŋŋa kan heer tɩrgabaa kɩ. Ŋ bɩr a tɔ bɔrɛ a nɔ ʊ y, ŋ bɩr a tom sɔ y, ŋnɩ bɔkarɛ ŋn'ɩ nyɩ dam.» ");
INSERT INTO bib_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Gʊaa bɩ sɛ dam fɩtɩrɛ ʊ, an mɔr sa an a ku ma, gɛɛ an a sa, an a nyɔɔ gargʊ ta y. A cɩnta n nawʊrɛ a bɩncɛ ʊ, gʊɔɔ kʊ ŋ nɩ gasʊm nɔ wɔɔ n bɩr lɛɛ gure bɩ yɩm. ");
INSERT INTO bib_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bala, mim haay kʊ gʊɔɔ b'a dam ma ŋn'a dɔ naa ma bɩ, ŋ zɛm b'a dɔ. Mim ba ʊ n n a nyaakʊm da a dɔ n mɩ y. ");
INSERT INTO bib_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","K'a dundo a zi kan a tʊr k'awɔɔ n'a kam ma lʊnlɔ bɩ kɩ. Bala, gʊaa k'a nɩ hɔ m bɩ, n y'a dam la. Bɔ ɩ bɩ hɔsɩ n bɩ, a hɔɔn k'a a da a ʊ, a ta m poore bɩ, n y'a yɔm nɩ.» ");
INSERT INTO bib_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yeezuu da kan a danyɩnɔ kɩ bʊr zi, bɩ ŋ b'a dam ma ŋn'a zɔ ma y, zamaa minto. ");
INSERT INTO bib_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","N n'a hɩ m, ŋ ʊ: «Ɩbɩɩ da kan ɩ danyɩnɔ kɩ ɩ garga ra, ŋ lɛ n taa ɩbɩɩ ma.» ");
INSERT INTO bib_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A n a nyɩ bɔ ŋ nʊ, a ʊ: «Mɔɔ da kan mɔɔ danyɩnɔ kɩ m gʊɔɔ kʊ ŋ n'a tʊr kam Woso lemim ma, ŋn'a zi bam nɔ wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Hindeem ʊ, Yeezuu da kɔɔlʊʊ ʊ kan a karɩndanyɩnɔ kɩ. A n a hɩ ŋ nɩ, a ʊ: «Ʊ ta higʊta bɩ gəm deem bɩ ra», ŋnɩ cem. ");
INSERT INTO bib_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kʊ ŋ y'a hʊr, ŋn'ɩ tam bɩ, Yeezuu hinceem ba. Hɩnhɛr gʊta n yar higʊta bɩ ra. Hi n'a tɔm kɔɔlʊʊ b'ʊ, an n'a ŋʊam k'a nyoo zɛ. ");
INSERT INTO bib_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ŋ n'a zɔ, ŋn'a gu, ŋ ʊ: «Karɩnsaamba, karɩnsaamba, ʊ ɩ gɩngam!» A n wuti, an həən si hɩnhɛr bɩ ma kan hikurero wɔɔ kɩ, ŋn'a da zenyy…, lɛɛ n zɛ sɩɩ… ");
INSERT INTO bib_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","A n bɔkarɛ, an a hɩ ŋ nɩ, a ʊ: «Awɔɔ sɩrakarɛ b'ɩ ka?» Dabɔʊ nɩ ŋ nyasʊ, ŋ n zɛ kədə, ŋn'a hɩm kʊ m, ŋ ʊ: «Nka m gʊaa naa do nɩ? A n nɩ lɛ kam hɩnhɛr ʊ kan hi kɩ, ŋn'a lɛ sire!» ");
INSERT INTO bib_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ŋ yaa lee ku Gergezaa zannɔ kʊ ʊ. Kʊ bɩ, a nya a ʊ Galilee kʊ bɩ rɛ. ");
INSERT INTO bib_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yeezuu k'a zer tara ʊ bɩ, tara bɩ gʊaa deem a zɛ ʊ, zinəro nɩ kan kɩ. A dɔmɩm laatʊ, a n a ya, an nɩ huu darɛ a ra y, b'a n a ya, an nɩ wʊtam har ʊ y. Wʊta a nawʊm gəənoyaarɔ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Gallɛm gʊta zinə bɩ tɩr gasʊ gʊaa b'ʊ an maasɩrɛ ba. N n a wɔrɔ sur baŋŋarɔ m, n n pɔyaarɔ da a gam ʊ k'a dɔ ma. Bɩ, a tɩr ŋ yɩnyar, zinə bɩ n a gaa, an ta m zaŋŋa ʊ. Yeezuu n lɛ ka zinə b'ʊ k'an bɔ gʊaa bɩ mɛ ʊ. K'a Yeezuu yɩ bɩ, a zee da, an sʊnta a taa, an n'a hɩm kan paŋŋa kɩ, a ʊ: «Bɔ ɩbɩɩ ʊ k'ɩ ba mɔɔ nɩ, Yeezuu, Woso k'a lɛ da haay Nyɩ? Mɔɔ y'a yɛrɛ ɩbɩɩ han, ɩ bɩ fɩr ka mɔɔ ma y.» ");
INSERT INTO bib_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeezuu n a lar, a ʊ: «Ɩbɩɩ tɔ m bɔ?» A ʊ: «Leziyɔn» A jɩ k'a hɩ, a ʊ: Gʊta maam-maam, bala, zinəro gʊta ɩ gasʊ gʊaa bɩ mɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Zinəro wɔɔ n a yɛ Yeezuu han k'a bɩ lɛ ka a ʊ, k'a gasʊ yaa gʊta ʊ fɩryɩrɛ nɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kurkuuro ɩ nyɩnta b'ʊ gʊta, ŋn'ɩ hɔ bɩm ci bɩ ra. Zinəro wɔɔ n a yɛ Yeezuu han, k'an zaa ka a ʊ, k'a gasʊ kurkuuro wɔɔ ʊ. A n zaa ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Zinəro wɔɔ n bɔ gʊaa bɩ mɛ ʊ, ŋnɩ gasʊ kurkuuro wɔɔ ʊ. Kurkuuro wɔɔ n bra si ci bɩ mim ʊ, ŋnɩ zer, ŋn'a zar higʊta b'ʊ, ŋnɩ gɩnga. ");
INSERT INTO bib_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kurkuuro dɔmazannɔ wɔɔ kʊ ŋ hɔ k'a ba bɩ yɩ bɩ, ŋ bra si, ŋn'aa hɩ tara nɔ ʊ, kan bɔlɛɛmarɔ wɔɔ kɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gʊɔɔ wɔɔ n bʊr k'a bɩ dɩga hɔ k'a ba bɩ ma. Ŋ lee ku Yeezuu zi, ŋnɩ gʊaa kʊ zinəro bɔ a mɛ ʊ bɩ yɩ, an nɩ nyɩntam Yeezuu jɩr ʊ, an huu da a ra, an a ba gʊaa mɩŋŋa, gʊɔɔ wɔɔ da n bɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bɔɔ ɩ hɔ k'a ba bɩ yɩ rɔ wɔɔ zinəro zaa bɩ waarɛ jɩ dɩnda gʊɔɔ kʊ ŋ bʊr lɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kɛɛrɛ bɩ, Gergezaa zannɔ wɔɔ n a yɛ Yeezuu han k'an a hʊr a tara ra. Bala, nyibəə gʊta gasʊ ŋ ʊ. Yeezuu n a bɔ, an da kɔɔlʊʊ b'ʊ, an a wusigə. ");
INSERT INTO bib_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Gʊaa kʊ zinəro bɔ a mɛ ʊ b'a yɛ Yeezuu han k'a zu kʊ ʊ kan kɩ. Yeezuu n a da zaa ra, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Doo ɩ har ʊ, k'ɩ yaa hɔ kʊ Woso a ba ɩbɩɩ minto bɩ hɩ.» Gʊaa bɩ n a hʊr, an aa hɔ kʊ Yeezuu a ba a m bɩ hɩ tara bɩ nɔ ʊ jilli. ");
INSERT INTO bib_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yeezuu k'a a bɔ, an bɩ lee ku bɩ, zamaa bɩ b'a zɛ ʊ, ŋn'a si. Bala, ŋ nyɩnta, ŋn'ɩ dɔm ma. ");
INSERT INTO bib_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Gʊaa n bʊr b'ʊ, a tɔ m Zayirus, sokʊmacɛ cir m. A n bɩ sʊnta Yeezuu taa, an a yɛ han, k'an bʊr a har ʊ, ");
INSERT INTO bib_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","bala, a nyɩmbʊɛɛrɛ n ta ʊ deem bala, a dɔɔraa a zɔ bueerehɩɩya ma, an n'a bam k'a ga. Kʊ Yeezuu nɩ tam bɩ, zamaa b'a so ʊ. ");
INSERT INTO bib_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lʊ ɩ nyɩnta b'ʊ, ma n'a dam zi dɔɔraa bueerehɩɩya. A n a hɔnyɩ zar lɔɔtɔɔrɔ zi, bɩ, gʊaa ba ʊ an a da ma, an a waa y. ");
INSERT INTO bib_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A n a zɔ Yeezuu ma a kur, an a wɔ da a huu lɛ ma. Lɛɛm bɩ, a ma b'a da jɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeezuu n laaka da, a ʊ: «Nka y'a wɔ da mɔɔ ma?» Ŋ haay n bɩsɩ ka. Pɩyɛɛr n a hɩ, a ʊ: «Karɩnsaamba, gʊɔɔ kʊ ŋ y'a so ɩbɩɩ ʊ, ŋn'ɩbɩɩ nyʊnnyɔɔtam nɔ wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yeezuu n a hɩ, a ʊ: «Gʊaa a wɔ da mɔɔ ma, bala paŋŋa bɔ mɔɔ mɛ ʊ, mɔɔ n a dɔ.» ");
INSERT INTO bib_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Lʊ bɩ k'a a dɔ a ʊ, ŋ sʊr a ra bɩ, a bʊr kan mɛhinkə kɩ, an bɩ kukurə zɛ Yeezuu taa. Hɔ niŋŋə k'a ka, an a wɔ da ma, an a waa lɛɛm bɩ, an a jɩ sa, an a dɩnda m zamaa bɩ haay taa. ");
INSERT INTO bib_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeezuu n a hɩ, a ʊ: «M nyɩmbʊɛɛrɛ ɩ sɩrakarɛ ɩ bʊmbɔ. Ta kan laafɩɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kʊ Yeezuu gɔɔta an nɩ meer bam bɩ, gʊaa a to sokʊmacɛ cir bɩ har ʊ, an b'a hɩ, a ʊ: «Ɩ nyɩmbʊɛɛrɛ bɩ ga. Ɩ b'ɩ ya, ɩ karɩnsaamba da kɔrɛ ma y.» ");
INSERT INTO bib_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bɩ Yeezuu k'a naa ma bɩ, an a hɩ Zayirus m, a ʊ: «Ɩ da bɩ bɔ ʊ y. Sɩra ka bala, a y'a waam.» ");
INSERT INTO bib_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kʊ Yeezuu lee ku har ʊ b'ʊ bɩ, a n zaa ka gɔsɩ ʊ k'an gasʊ y. Pɩyɛɛr a gaa bala, kan Zaan kɩ, Zakkɩ kɩ, kan nyɩ bɩ zɩ kɩ, a da kɩ. ");
INSERT INTO bib_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Zamaa bɩ haay nɩ baa dam, ŋnɩ heerzar nɔ ʊ nyɩ bɩ minto. Yeezuu n a hɩ, a ʊ: «A bɩ baa da y. A n ga y, hinceem an n'a bam.» ");
INSERT INTO bib_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ŋ nɩ yaa wʊm Yeezuu ma, bala, ŋ sɩra ka, a ga. ");
INSERT INTO bib_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yeezuu n nyɩ bɩ sa a wɔ ma, an a bir, a ʊ: «M nyɩnnɩ, wuti!» ");
INSERT INTO bib_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A n a mɩm bɔ ʊ, an wuti lɛɛm. Yeezuu n zaa ka, a ʊ, ŋnɩ hɔbɩrɛ ka ʊ. ");
INSERT INTO bib_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A zɩrɔ wɔɔ n zɛ kədə, bɩ Yeezuu lɛ ka, a ʊ, ŋ bɩ hɔ k'a ba naa hɩ gɔsɩ nɩ y. ");
INSERT INTO bib_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yeezuu bueerehɩɩyɔɔ wɔɔ so kʊ ma, a paŋŋa kan lɛ kɩ ka ŋ ʊ, kʊ ŋ nɩ la zinəro ra, kʊ ŋ nɩ yaabazannɔ waa. ");
INSERT INTO bib_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","A n ŋ nyɔɔ, kʊ ŋ n'aa Woso cirbəə bɩ pa da, kʊ ŋ nɩ yaabazannɔ waa. ");
INSERT INTO bib_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A n a hɩ ŋ nɩ, a ʊ: «A bɩ hɔsɩ sa a wɔ ʊ k'a zaa bɩ sa nɩ y. A bɩ bara sa, gɛɛ hɛra, gɛɛ bur, gɛɛ busoo y. A b'a ka gʊaa deem m huuro gʊr hɩɩya y. ");
INSERT INTO bib_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Har niŋŋə kʊ ŋ n'awɔɔ siŋ ʊ bɩ, k'a gɔɔta b'ʊ, an ta, an awɔɔ hʊrlɛ dɔmɩm ku. ");
INSERT INTO bib_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kʊ ŋ n awɔɔ si kʊ bɩ do nɔ ʊ y, k'a bʊr an n'a hʊrm, k'a kʊ bɩ taanyisi bɩ gʊngʊm a gannɔ ma, kʊ ŋ n'a dɔ, ŋ ʊ, a kʊrɔ ma.» ");
INSERT INTO bib_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ŋ n'a hʊr ŋnɩ ta kʊrɔ haay ʊ, ŋn'ɩ lemim nyɩnta bɩ pa dam, ŋn'ɩ yaabazannɔ waam bɩncɛ haay ʊ. ");
INSERT INTO bib_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Cir Hɩrɔɔdɩ hɔ haay kʊ Yeezuu a ba naa ma. A n a dɔ k'a hɔɔn an n'a dam lɔ y. Bala, nawɔnnɔ ʊ Zaan y'a mɩm bɔ ʊ gəəno bire ʊ. ");
INSERT INTO bib_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gɔsɩnnɔ ʊ *Elii y'a hɩnka. Gɔsɩnnɔ ʊ wosolɛsinnɩsorazannɔ kʊ ŋ nyɩnta ʊ biisi rɔ wɔɔ deem y'a mɩm bɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hɩrɔɔdɩ ʊ: «Mɔɔ ka ŋnɩ Zaan mim gʊ ma. Bɩ, nka ŋn'a mim dɩndam mɔɔ n'a mam naa?» A n n'a kam ma k'a yɩ. ");
INSERT INTO bib_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Zibəəzannɔ wɔɔ kʊ ŋ y'a wusigə bɩ, ŋ yaa hɔ haay kʊ ŋ yaa ba bɩ hɩ Yeezuu m. A n ŋ gaa, an bɔ ŋ nɩ toore ma, tara kʊ n n'a birm Bɛtsayɩdaa bɩ zeezi. ");
INSERT INTO bib_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gʊɔɔ wɔɔ kʊ ŋ y'a dɔ bɩ, ŋ zu ŋ jɛ ʊ. Yeezuu nɩ ŋ si, an nɩ Woso cirbəə bɩ mim dɩndarɛ ŋ nɩ, an nɩ gʊɔɔ kʊ ŋ lɛ n taa laafɩɩ ma rɔ wɔɔ waarɛ. ");
INSERT INTO bib_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gum k'a bʊr an nɩ dam bɩ, bueerehɩɩyɔɔ wɔɔ a zɔ ma, ŋn'a hɩ m, ŋ ʊ: «Gʊɔɔ wɔɔ da zaa ra, kʊ ŋ nɩ ta kʊrɔ wɔɔ ʊ kan bɔlɛɛmarɔ kʊ ŋ nɩ jɩnjɛɛm nɔ wɔɔ kɩ nɔ ʊ, kʊ ŋ n'aa a ka wʊtajɩrɔ ma kan hɔbɩrɛ kɩ ma ŋn'a bɩ. Bala, bɩncɛ kʊ wɔɔ n ta ʊ naa, laatʊ hadrɔ ma.» ");
INSERT INTO bib_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bɩ, Yeezuu a hɩ ŋ nɩ, a ʊ: «K'a hɔbɩrɛ ka ŋ ʊ ŋn'a bɩ a zim.» Ŋ n'a nyɩ bɔ ʊ, ŋ ʊ: «Bur soor taan… ɩ gɔɔta wɔɔ ʊ kan zɔnɔ kɩ hɩɩya, kʊ bɩ bɛɛ y, k'ʊ ta ʊ aa hɔbɩrɛ si, ʊ b'a ka zamaa b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gʊɔɔ yaarɔ kʊ ŋ nyɩnta b'ʊ rɔ wɔɔ tisi soor ku. Yeezuu n a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «K'a ka kʊ gʊɔɔ wɔɔ n nyɩnta busoor-busoor.» ");
INSERT INTO bib_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ŋ n'a ba maam, ŋnɩ ŋ nyɩnta haay. ");
INSERT INTO bib_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeezuu n bur soor bɩ sa kan zɔ hɩɩya bɩ kɩ, an a mɩm busu brama, an ŋ barka da ʊ, an a zɩnzɛ ra, an a ka a karɩndanyɩnɔ wɔɔ ʊ kʊ ŋ n'a ka zamaa b'ʊ. ");
INSERT INTO bib_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ŋ n'a bɩ, an ŋ ka haay. A kuurero kʊ ŋ gɔɔta bɩ, ŋn'a gʊr kasɩ lɛ ma bueerehɩɩya. ");
INSERT INTO bib_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Hindeem ʊ, Yeezuu bɔ toore ma, an nɩ yaa dam, a karɩndanyɩnɔ wɔɔ nɩ kan kɩ. A n ŋ lar, a ʊ: «Zamaa bɩ y'a hɩrɛ a ʊ, nka m mɔɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Gɔsɩnnɔ ʊ, Zaan-Batiisi m. Nawɔnnɔ ʊ, Elii m. Gɔsɩnnɔ ʊ, biisizannɔ wosolɛsinnɩsorazaa deem y'a mɩm bɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Bɩ k'awɔɔ nɩ, awɔɔ y'a hɩrɛ a ʊ, nka m mɔɔ nɩ?» Pɩyɛɛr n a nyɩ bɔ ʊ, a ʊ: «Krista kʊ Woso a nyɔɔ bɩ n'ɩbɩɩ m.» ");
INSERT INTO bib_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeezuu ŋ lɛ ka ŋ ʊ, a ʊ: «Ŋ b'a hɩ gɔsɩ nɩ y.» ");
INSERT INTO bib_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A n a ya, an n'a hɩrɛ, a ʊ: «Pakra m kʊ Gʊaanyɩ bɩ n fɩr yɩ gʊta, kʊ gʊɔɔgusinno n kaanm m kan wosocɛmannɩbənno jɩtannɔ kɩ, wosocikarɩnsaambɔɔ kɩ, kʊ ŋ n'a zɛ an ga, k'an a mɩm bɔ ʊ dɔmɩm kaakʊ hinni ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yeezuu n bɔkarɛ an a hɩ ŋ nɩ haay, a ʊ: «Kʊ gʊaa lɛ taa k'a zu mɔɔ ʊ, k'an a mɩŋŋa lɛtaamarɔ to haay, dɔmɩm haay, k'an a gɔdarkʊra busu, an zu mɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kʊ sɩra nɩ, gʊaa k'a lɛ n taa k'a a meeyaa bʊmbɔ, bɩ zaa n nɩ kʊrɔm ma. Bɩ, gʊaa k'a yɛ zɛ ma mɔɔ minto bɩ, bɩ zaa ɩ bɩ kʊrɔm a meeyaa bʊmbɔrɛ ma y. ");
INSERT INTO bib_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bɩ kʊ gʊaa durnya naa arzaka yɩ haay, a zaa n bɔkarɛ an a mɩŋŋa nyaam, gɛɛ, an a mɩŋŋa zar, a nyɔɔdʊ ɩ ka? ");
INSERT INTO bib_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bala, kʊ gʊaa ɩ nyannɩ zɛm mɔɔ tɔ ma, an nɩ nyannɩ zɛm mɔɔ meerbaa tɔ ma, kʊ Gʊaanyɩ bɩ bʊr a lɛbɔʊrɛ nɔ ʊ kan a Zɩ hɔ kɩ malɛɛkarɔ mɩŋŋɔɔ hɔ kɩ, a b'a zaa nyannɩ zɛrɛ y. ");
INSERT INTO bib_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sɩra mɔɔ n'a hɩrɛ awɔɔ m: gʊɔɔ kʊ ŋ nɩ naa ʊ rɔ wɔɔ barla, gɔsɩnnɔ Woso cirbəə bɩ yɩm, a mɩsɩrbaa dɔmɩm ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yeezuu k'a meer bɩ ba bɩ, a dɔmɩm a zɔ sinnyə ma. A Pɩyɛɛr gaa kan Zaan kɩ, Zakkɩ kɩ, an der ci ra k'a yaa da. ");
INSERT INTO bib_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","K'a nɩ yaa bɩ dam bɩ, a meer a lʊr, a huu n a ba fu fɩtɩtɩ, an nɩ nyakɩ bɔm. ");
INSERT INTO bib_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lɛɛm bɩ, gʊɔɔ hɩɩyɔɔ bʊr, ŋn'ɩ meer bam kan kɩ; Moyiisi kan Elii kɩ y'a hɩnka Woso lɛbɔʊrɛ nɔ ʊ, ");
INSERT INTO bib_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ŋn'ɩ zibəə kʊ Yeezuu n n'a nyambʊrlɛ a zɛ m, Zerizalɛm ʊ bɩ mim dɩndam kan kɩ. ");
INSERT INTO bib_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bɩ ma bɩ, Pɩyɛɛr ɩ hinceem barɛ a ra kan a muno wɔɔ kɩ. Hinceem bɩ n bɩ ku ŋ la. Kʊ ŋ gu bɩ, ŋ Yeezuu lɛbɔʊrɛ bɩ yɩ kan gʊɔɔ hɩɩyɔɔ kʊ ŋ nɩ kan kɩ rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Gʊɔɔ hɩɩyɔɔ wɔɔ kʊ ŋ n'a gʊm Yeezuu ma bɩ, Pɩyɛɛr a hɩ m, a ʊ: «Karɩnsaamba, kʊ wɔɔ ɩ naa ʊ a mɩŋŋa. Ʊ bur ba kaakʊ: Ɩbɩɩ hɔ deem, Moyiisi hɔ deem, Elii hɔ deem.» A n hɔ k'an a hɩm bɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","K'a nɩ meer bɩ barɛ ncɩnaaʊ bɩ, warkʊ bʊr an b'a ku ŋ la. Karɩndanyɩnɔ wɔɔ kʊ ŋ warkʊ bɩ yɩ an n'a kure a ra bɩ, ŋ da bɔ ʊ gʊta. ");
INSERT INTO bib_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Meerbaa n a to warkʊ bɩ nɔ ʊ an n'a hɩrɛ, a ʊ: «Mɔɔ Nyɩ m naa, mɔɔ n'a bɔ ʊ. K'a a tʊr ka ma.» ");
INSERT INTO bib_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Meerbaa bɩ jɛ ʊ bɩ, karɩndanyɩnɔ wɔɔ n gɔsɩ yɩ, kʊ Yeezuu deem bɛɛ y. Ŋ n hɔ kʊ ŋ y'a yɩ bɩ hɩ gɔsɩ m dɔmɩnnɔ wɔɔ duro ʊ y, ŋ zɛ pi. ");
INSERT INTO bib_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bɩ dɔ k'a mɩ bɩ, ŋ zer ci bɩ ra, zamaa n bʊr, an bɩ Yeezuu zɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Gʊaa deem nɩ zamaa bɩ bire ʊ, an zee da, a ʊ: «Karɩnsaamba, mɔɔ y'a yɛrɛ ɩbɩɩ han, dɩga mɔɔ nyɩyar bɩ mim ma, an mɔɔ nyɩ a deem bala. ");
INSERT INTO bib_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Zinə deem ɩ gasʊ ʊ, an tɩr a da zeedarɛ ma, an a hinkə. A n bɩr lihihur tarɛ a lɛ rɛ, an bɩr a dam kɔrɛ ma, a bɩr bɔrɛ a mɛ ʊ naanaa y. ");
INSERT INTO bib_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mɔɔ yɛ ɩbɩɩ karɩndanyɩnɔ wɔɔ han kʊ ŋ nɩ la ra, bɩ ŋ n a da ma y.» ");
INSERT INTO bib_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeezuu n a hɩ, a ʊ: «Sɩrakarɛ warzannɔ kan gʊɔɔ bʊnyaarɔ kɩ do n'awɔɔ m. Mɔɔ yɩ m yarɛ m dɔmɩm karɔ ba, kʊ m bʊraama zi ba kan awɔɔ kɩ? Bʊr ɩ nyɩ bɩ m naa ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nyɩ bɩ k'a bʊr an n'a zɔm bɩ, zinə b'a zɛ an a zo tara ʊ, an a hinkə. Yeezuu n həən si zinə bɩ ma, an nyɩ bɩ waa, an a ka a zɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ŋ haay n zɛ kədə Woso gʊtabaa bɩ minto. Hɔ haay kʊ Yeezuu a ba bɩ a ka gʊaa biyəə heer n nyɩnta. A a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«K'a tʊr ka hɔ kʊ mɔɔ n'a hɩm bɩ ma mɩŋŋa: N Gʊaanyɩ bɩ nyasʊm, n n'a da gʊɔɔ wɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bɩ, karɩndanyɩnɔ wɔɔ bɩr a meerbaa bɩ jɩ marɛ y. A jɩ b'a nyaakʊm da ŋ nɩ, kʊ ŋ b'a da ma, ŋn'a dɔ y, ŋn'ɩ nyi bam Yeezuu larlɛ m mim naa do minto. ");
INSERT INTO bib_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Laakadarɛ deem bʊr ŋ hɔɔn ʊ, ŋnɩ bɩsɩ kam kʊ ma, ŋ ʊ: nka y'a da ma an yɩ jɩtaarɛ a bire ʊ. ");
INSERT INTO bib_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeezuu k'a ŋ laaka bɩ darɛ jɩ dɔ bɩ, a nyɩ gaa, an a jɩm a jɩr ʊ, ");
INSERT INTO bib_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","an n'a hɩrɛ ŋ nɩ, a ʊ: «Gʊaa k'a nyɩ naa do si mɔɔ tɔ ma, mɔɔ a yɩ m si. Gʊaa k'a mɔɔ si bɩ, gʊaa k'a mɔɔ nyɔɔ b'a a si. Bala, gʊaa k'an poore awɔɔ haay barla bɩ, bɩ n'awɔɔ jɩtaarɛ.» ");
INSERT INTO bib_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zaan meerbaa bɩ sa, a ʊ: «Karɩnsaamba, wɔɔ gʊaa yɩ an nɩ lam zinəro ra ɩbɩɩ tɔ m, wɔɔ n a gʊ ma, k'a ba kan wɔɔ kɩ bɩ tɔ ma.» ");
INSERT INTO bib_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeezuu n a hɩ, a ʊ: «A b'a gʊ ma y, bala, gʊaa k'a bɩ bʊnyaa kan awɔɔ kɩ bɩ, awɔɔ gʊaa m.» ");
INSERT INTO bib_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dɔmɩm k'a a ga m kʊ Woso n Yeezuu bɔ durnya ʊ bɩ k'a n'a zɔm bɩ, a a cɩnta k'a ta Zerizalɛm ʊ. ");
INSERT INTO bib_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A gʊɔɔ nyɔɔ kʊ ŋ nɩ lɛɛ ka a m. Brɔɔ n zaa sa, ŋn'aa gasʊ Samarii kʊ deem ʊ, k'a leekure bɩ banka. ");
INSERT INTO bib_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bɩ, ŋ n a si y, k'a zaa sa an nɩ tam Zerizalɛm ʊ bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Karɩndanyɩnɔ Zaan kan Zakkɩ kɩ kʊ ŋ naa yɩ bɩ, ŋ y'a hɩ, ŋ ʊ: «Zuuba, ɩbɩɩ lɛ taa k'ʊ lɛ ka, kʊ sɛ n a to brama an zer, an nawɔnnɔ bɩ gɛ?» ");
INSERT INTO bib_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yeezuu n a bɔ an dɩga ŋ ma, an nyaa ba kan ŋ kɩ, a ʊ: «Nyi k'an ta awɔɔ m bɩ, awɔɔ n a dɔ y. Gʊaanyɩ bɩ n bʊr k'a bɩ gʊɔɔ zɩnzɛ y, bʊr a ʊ k'a bɩ ŋ bʊmbɔ.» ");
INSERT INTO bib_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ŋ n'a hʊr, ŋnɩ ta tara vanta ra. ");
INSERT INTO bib_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kʊ ŋ zaa sa ŋn'ɩ tam bɩ, gʊaa deem a hɩ Yeezuu m, a ʊ: «Mɔɔ zum kʊ ʊ kan ɩbɩɩ kɩ, m ta bɩncɛ haay k'ɩbɩɩ n nɩ taŋ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeezuu n a hɩ m, a ʊ: «Sɛɛʊnrɔ yaarɔ ta ʊ, bɩ bɛnnɔ y'a cɛrɔ m. Bɩ, Gʊaanyɩ bɩ ba bɩncɛ m k'a mim cɩnta ʊ y.» ");
INSERT INTO bib_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A n a hɩ gʊaa vanta m, a ʊ: «Zu mɔɔ ʊ.» Bɩ n a nyɩ bɔ ʊ, a ʊ: «Zuuba, zaa ka m ʊ, kʊ m dɔ m zɩ birle ma.» ");
INSERT INTO bib_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yeezuu n a hɩ m, a ʊ: «Gəəno wɔɔ to kʊ ŋ n a gəəno bir. B'ɩbɩɩ, ta ɩ yaa Woso cirbəə pa da.» ");
INSERT INTO bib_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Gʊaa vanta n a hɩ, a ʊ: «Mɔɔ zure ɩbɩɩ ʊ karɩnsaamba, bɩ zaa ka m ʊ, kʊ m m leer so m harzannɔ m.» ");
INSERT INTO bib_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeezuu n a hɩ m, a ʊ: «Kʊ gʊaa donokaan sa k'a dam wʊ, an a bɔ an nɩ dɩgarɛ a kur, a zaa b'a dam ma an Woso cirbəə zi ba y.» ");
INSERT INTO bib_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bɩ kur bɩ, Zuuba karɩndanyɩnɔ gɔsɩnnɔ bɔ ʊ busaanhɩna a yaa hɩɩya, an ŋ nyɔɔ hɩɩya-hɩɩya, kʊrɔ kan bɩncɛ haay k'a a ga m an ta ʊ b'ʊ, ŋnɩ lɛɛ ka a lɛɛ. ");
INSERT INTO bib_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A n a hɩ ŋ nɩ, a ʊ: «Hɔdarɛ bɩ gʊta, b'a darɛzannɔ ba ʊ gʊta y. K'a yaa da wutu zaa bɩ m, k'a yɛ han, k'an zibənno nyɔɔ hɔdarɛ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","K'a ta! Awɔɔ nyɔɔ mɔɔ nawʊm am sinnyɛɛnnyɩnɔ hɔ bɩ m tamparɔ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","A bɩ busoo sa y, a bɩ hɛra sa y, a bɩ kʊsɔ sa sɔ y. A bɩ jɩm a yaa da gʊaa m zaa ra y. ");
INSERT INTO bib_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","K'a lɛɛ ka a hɩ har k'awɔɔ n nɩ gasʊŋ ʊ b'ʊ, a ʊ: Kʊ laafɩɩ n bɩr har naa do mim la. ");
INSERT INTO bib_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kʊ laafɩɩ zaa ɩ b'ʊ deem, awɔɔ laafɩɩ bɩ zerm la. Kʊ bɩ bɛɛ y, a y'a bɔm an bʊr awɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","K'a gɔɔta har bɩ do ʊ. Hɔ kʊ n n'a karɛ awɔɔ ʊ bɩ, a bɩr a bɩrɛ, a bɩr a mire. Bala, zibəəzaa b'a ga a busoo m. A bɩ har lʊnlʊr y. ");
INSERT INTO bib_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","K'awɔɔ yaa gasʊ tara niŋŋə nɔ ʊ, n n'awɔɔ si, k'a hɔ kʊ n y'a ka awɔɔ ʊ bɩ bɩ. ");
INSERT INTO bib_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","K'a yaabazannɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ waa. K'a hɩ gʊɔɔ wɔɔ m, a ʊ: Woso cirbəə b'a zɔ awɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","K'awɔɔ yaa gasʊ kʊ niŋŋə ʊ, bɩ ŋ n awɔɔ si, k'a bɔ a hɩ gʊɔɔ gaa ʊ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Baa k'awɔɔ kʊ bɩ taanyisi k'a naasʊ wɔɔ gannɔ ma bɩ, wɔɔ y'a gʊngʊm ma, ʊ a to awɔɔ m. Bɩ, k'a dɔ a ʊ, Woso cirbəə b'a zɔ awɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Sɩra mɔɔ n'a hɩrɛ awɔɔ m: Woso dʊdɔkarɛ hinni ʊ, Sodɔm hʊnhʊrlɛ bɩ nyɩntam gʊta, an kʊ bɩ do ku y.» ");
INSERT INTO bib_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«A nyɩntarɛ awɔɔ ma bʊnyaa, Korazɛn zannɔ! A nyɩntarɛ awɔɔ ma bʊnyaa, Bɛtsayɩdaa zannɔ! Bala, hoserlo kʊ ŋ ba awɔɔ bire ʊ rɔ wɔɔ, kʊ ba ŋ y'a ʊ Tiir ʊ kan Sidɔn kɩ, ncɩnaaʊ naa ŋ yɔrgɔrɔ da a ra, ŋnɩ suu lo a mim la, k'a hɩnka a ʊ, a a mɩsɩrbaa lʊr, a dɔmɩm laatʊ. ");
INSERT INTO bib_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bɩ minto bɩ, dʊdɔkarɛ hinni ʊ, Tiir kan Sidɔn kɩ hʊnhʊrlɛ bɩ nyɩntam gʊta, an awɔɔ hɔ bɩ ku y. ");
INSERT INTO bib_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","B'ɩbɩɩ Kapɛrnawum, ɩ hɔɔn ɩbɩɩ n n'a darɛ ɩ ʊ, n y'ɩbɩɩ busum ɩ ta arzana ʊ ra? N y'ɩbɩɩ zerm yaa gʊta ʊ, fɩryɩrɛ bɩncɛ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yeezuu a ya, an a hɩ ŋ nɩ, a ʊ: «Bɔzaa n n'a tʊr karɛ awɔɔ ma bɩ, a tʊr an n'a kam mɔɔ ma. Bɔzaa ɩ kaanm awɔɔ m bɩ, kaanm a ʊ mɔɔ m sɔ. Bɩ bɔzaa ɩ kaanm mɔɔ m bɩ, kaanm a ʊ gʊaa k'a mɔɔ nyɔɔ bɩ m.» ");
INSERT INTO bib_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Karɩndanyɩnɔ busaanhɩna a yaa hɩɩyɔɔ wɔɔ a wusigə, ŋnɩ bʊr kan heernyɔɔ kɩ, ŋ ʊ: «Zuuba, baa zinəro wɔɔ lɛ si ɩbɩɩ tɔ ma.» ");
INSERT INTO bib_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mɔɔ Sʊtaana yɩ, an a to brama an a da, am brama nyakɩ hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ba n nɩ: mɔɔ paŋŋa ka awɔɔ ʊ k'a tɔ mɩnnɔ ra kan bɔɔrɔrɔ kɩ kan jɩnnɔ paŋŋa kɩ haay, bɩ hɔsɩ bɩ barɛ awɔɔ nɩ y. ");
INSERT INTO bib_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bɩ, a b'a hɔɔn nyɔɔ zinəro kʊ ŋ y'awɔɔ lɛ si rɔ wɔɔ minto y. K'a heer nyɔɔ, kʊ Woso awɔɔ tɔrɔ gʊrsɩra ba arzana ʊ bɩ minto.» ");
INSERT INTO bib_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lɛɛm bɩ, *Sɛnt-Ɛspri a ka heernyɔɔ gʊta n gasʊ Yeezuu ʊ, a ʊ: «M Zɩ, mɔɔ yɩ m lɛ bɔrɛ ɩbɩɩ ʊ, brama kan tara kɩ Zuuba, ɩbɩɩ k'ɩ mim naa do nyaakʊm da hɔɔnzannɔ, kan hɔdonno kɩ m, ɩ b'a hɩnka gʊɔɔ poorero m. Sɩra m, m Zɩ, ɩbɩɩ y'a ŋʊa k'an nyɩnta ncɩnaaʊ.» ");
INSERT INTO bib_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Mɔɔ Zɩ hɔ haay sa, an a ka mɔɔ ʊ, bɩ gʊaa ba ʊ an Nyɩ bɩ dɔ kʊ Zɩ bɩ bɛɛ bala y. Bɩ, gʊaa ba ʊ an Zɩ bɩ dɔ kʊ Nyɩ bɩ kan gʊɔɔ kʊ Nyɩ bɩ lɛ n taa k'a hɩnka ŋ nɩ rɔ wɔɔ kɩ bɛɛ bala y.» ");
INSERT INTO bib_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A n a bɔ, an dɩga karɩndanyɩnɔ wɔɔ ma, an a hɩ ŋ nɩ a minto, a ʊ: «Mimbirenyɩntazannɔ m, gʊɔɔ kʊ ŋ nɩ hɔ k'awɔɔ n'a yɩm nɔ wɔɔ yɩm. ");
INSERT INTO bib_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bala, Sɩra mɔɔ n'a hɩrɛ awɔɔ m, wosolɛsinnɩsorazannɔ gʊta kan cinno kɩ a ŋʊa k'a hɔ k'awɔɔ n'a yɩm bɩ yɩ, bɩ ŋ n a yɩ y, k'a hɔ k'awɔɔ n'a mam bɩ ma, bɩ ŋ n a ma y.» ");
INSERT INTO bib_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wosocikarɩnsaamba deem wuti an laaka da Yeezuu han, k'a nyasʊ meerbaa nɔ ʊ, a ʊ: «Karɩnsaamba, bɔ mɔɔ m ga m m a ba, kʊ m mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩ?» ");
INSERT INTO bib_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeezuu n a hɩ m, a ʊ: «Moyiisi lɛ ci bɩ nɔ ʊ, bɔ n y'a gʊrsɩra ba? Ɩbɩɩ y'a karɩnda bam lɔ?» ");
INSERT INTO bib_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A n a nyɩ bɔ nʊ, a ʊ: «K'ɩ Zuuba ɩ Woso ŋʊa kan ɩ heer kɩ haay, kan ɩ nyi kɩ haay, kan ɩ paŋŋa kɩ haay, kan ɩ hɔɔndarɛ kɩ haay. K'ɩ mim ŋʊa amba ɩ mɩŋŋa m.» ");
INSERT INTO bib_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeezuu n a hɩ m, a ʊ: «Ɩ nyɩ bɔ ʊ mɩŋŋa. A ba ncɩnaaʊ, ɩ mɩsɩrbaa bɩ yɩm.» ");
INSERT INTO bib_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bɩ, wosocikarɩnsaamba bɩ k'a lɛ n taa k'a gumə ka a mɩŋŋa ʊ bɩ, a Yeezuu lar, a ʊ: «Nka m mɔɔ mim nɩ?» ");
INSERT INTO bib_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Gʊaa ɩ nyɩnta an a to Zerizalɛm ʊ, an nɩ tam Zeriko ʊ. Konno n aa da ma, ŋn'a huuro yɔ m, ŋn'a zɛ bannɔ m, ŋnɩ yaaba da ma, ŋn'a gʊ ma, an n'a bam k'a ga. ");
INSERT INTO bib_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wosocɛmannɩbər deem a to b'ʊ sɔ, an bʊr an nɩ cenim zaa bɩ do ra. A n gʊaa bɩ yɩ, an bɩr ma, an cem. ");
INSERT INTO bib_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wosocɛ zibəəzaa deem a to Zerizalɛm ʊ sɔ, an nɩ cenim b'ʊ. Levii do gʊaa m. A n gʊaa bɩ yɩ, an bɩr ma, an cem. ");
INSERT INTO bib_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bɩ, Samarii gʊaa deem y'a to zaa ra, an bɩ lee ku gʊaa bɩ zi. K'a a yɩ bɩ, a cicir a nyasʊ. ");
INSERT INTO bib_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A n a zɔ ma, an a nyinno wɔɔ sʊrgɔ dɩvɛn m, an nyɔɔ nɔ ŋ ma, an pɛɛra burgu ma, an a busu, an a da a sisi ʊ, an ta m zaasənnocɛ ʊ, an aa nyɩsɩ ba m. ");
INSERT INTO bib_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Dɔ k'a mɩ bɩ, a busoo bɔ ʊ bɔɔlʊgʊ hɩɩya, n n a ba wanzur m, an a ka zaasənnocɛ zaa b'ʊ, an a hɩ m, a ʊ: Dɩga a mim ma, bɩ k'ɩ busoo zar a kur, kʊ mɔɔ m wusigə, kʊ m b'a sompi a yaa ʊ. ");
INSERT INTO bib_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ɩbɩɩ hɔɔndarɛ nɔ ʊ, gʊaa kaakʊ naa bireyaa ʊ, nka m gʊaa kʊ konno a zɛ bɩ mim nɩ?» ");
INSERT INTO bib_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wosocikarɩnsaamba bɩ n a nyɩ bɔ ʊ, a ʊ: «Bɔ ɩ mɩŋŋabaa ba kan kɩ bɩ m.» Yeezuu n a hɩ m, a ʊ: «B'ɩbɩɩ sɔ, ta, ɩ ba maam sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kʊ Yeezuu kan a karɩndanyɩnɔ kɩ zaa sa ŋn'ɩ tam bɩ, ŋ yaa gasʊ kʊ deem ʊ. Lʊ kʊ n n'a birm Martɩ bɩ ŋ si a har ʊ. ");
INSERT INTO bib_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A dam n ta ʊ, a tɔ m Maarii, b'ɩ nyɩnta Zuuba bɩ taa, an n'a tʊr karɛ a meerbaa ma. ");
INSERT INTO bib_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martɩ nyɩnta an n'a tʊntɔŋ ʊ kan hɔbɩrɛ barɛ kɩ, zibəə gɔsɩnnɔ kɩ sɔ. A n bʊr, an b'a hɩ, a ʊ: «Zuuba, mɔɔ dam bɩ k'a mɔɔ to m deem, m nɩ ziro wɔɔ bam bɩ, a bɩr hɔsɩ barɛ ɩbɩɩ n na? A hɩ m k'an b'a da m han.» ");
INSERT INTO bib_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Zuuba n a nyɩ bɔ ʊ, a ʊ: «Martɩ, Martɩ, hɔ gʊta y'ɩbɩɩ hɔɔn ʊ, an n'ɩbɩɩ kɔm. ");
INSERT INTO bib_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Deem bala m pakra. Maarii hɔ k'an mɩŋŋa bɩ bɔ ʊ, bɩ, gʊaa b'a yɔm nɩ y.» ");
INSERT INTO bib_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Hindeem ʊ, Yeezuu nyɩnta an nɩ yaa dam bɩncɛ niŋŋə ʊ. K'a yaa bɩ da an a nya bɩ, karɩndanyɩ deem a hɩ m, a ʊ: «Zuuba, yaadarɛ dɩnda ʊ m, amba Zaan a dɩnda a karɩndanyɩnɔ wɔɔ m bɩ m.» ");
INSERT INTO bib_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A n a hɩ ŋ nɩ, a ʊ: «K'a ɩ yaa dam, k'a hɩ, a ʊ: Zɩ, a ka kʊ n n'ɩbɩɩ mɩŋŋa dɔ Woso a deem, k'ɩ cirbəə n bʊr. ");
INSERT INTO bib_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wɔɔ dɔmɩm biyəə hɔbɩrɛ ka wɔɔ ʊ, ");
INSERT INTO bib_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","k'ɩ wɔɔ mimbʊnyaarɔ sugur ka wɔɔ ʊ, amba wɔɔ mɩŋŋɔɔ y'a sugur kam bɔɔ ɩ kʊrɔma kan wɔɔ kɩ rɔ wɔɔ ʊ bɩ m. Ɩ b'a ka, ʊ ʊ do makra nɔ ʊ y.» ");
INSERT INTO bib_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yeezuu a ya, an a hɩ, a ʊ: «Gʊaa bɩ kara hannyɩ n ta ʊ, an ta an aa hɩ m dibsir ma, a ʊ: ‹M hannyɩ, bur zɩm sa m m kaakʊ, ");
INSERT INTO bib_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mɔɔ hannyɩ deem y'a to zaa ra an bʊr mɔɔ zi, bɩ hɔsɩ ba mɔɔ ʊ kʊ m a ka ʊ y.› ");
INSERT INTO bib_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bɔ n nɩ cɛ ʊ b'ʊ bɩ n a nyɩ bɔ ʊ, a ʊ: ‹Ɩ bɩ mɔɔ kɔ y. Mɔɔ cɛ lɛ ta. Mɔɔ kan m nyɩnɔ kɩ ɩ wʊtam. Mɔɔ bɩ m dam ma, m wuti, m bur ka ɩbɩɩ ʊ y.› ");
INSERT INTO bib_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mɔɔ y'a hɩrɛ awɔɔ m: baa k'a b'a dam ma, an wuti an a ka ʊ a hannyɩbaa bɩ minto, a wutire an hɔ haay k'a lɛ n taa bɩ ka ʊ, k'a lɛ baa k'an a kɔ bɩ tɔ ma.» ");
INSERT INTO bib_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Sɩra mɔɔ n'a hɩrɛ awɔɔ m: K'a hɔ yɛ, n y'a karɛ awɔɔ ʊ. K'a ka, awɔɔ y'a yɩm. K'a cɛlɛ zɛ, n y'a gʊrɛ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bala, gʊaa k'a hɔ yɛ, n y'a kaŋ ʊ, gʊaa k'a ka, a y'a yɩm, gʊaa k'a cɛlɛ zɛ, n y'a gʊrɛ a zaa m. ");
INSERT INTO bib_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Zɩ bɩ kara n n'awɔɔ bire ʊ naa ʊ, a nyɩ n zɔ yɛ han an mɩm sa an a ka ʊ? ");
INSERT INTO bib_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Gɛɛ a n a ya, an jir yɛ, bɩ n bɔɔrɔ sa an a ka ʊ? ");
INSERT INTO bib_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","K'awɔɔ n gʊɔɔ bʊnyaarɔ wɔɔ, awɔɔ hɔ mɩŋŋa ka a nyɩnɔ ʊ dɔ. Bɩ Zɩ Woso k'a nɩ arzana ʊ bɩ, a bɩ Sɛnt-Ɛspri kam gʊɔɔ kʊ ŋ n'a yɛm han rɔ wɔɔ ʊ an lɛ da ra?» ");
INSERT INTO bib_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yeezuu ɩ lam zinə k'a gʊaa ba bəətir bɩ la. Bɩ, zinə bɩ k'a bɔ bɩ, bəətir b'ɩ meer bam, zamaa bɩ n zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bɩ, gɔsɩnnɔ a hɩ, ŋ ʊ, la Yeezuu n nawʊm zinəro wɔɔ ra, zinəro cir Bɛlzebul paŋŋa m. ");
INSERT INTO bib_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Gɔsɩnnɔ lɛ n taa k'a Yeezuu makra ba a dɩga a, ŋn'a yɛm han k'an a ka kʊ makra n a to arzana ʊ k'a yɩ. ");
INSERT INTO bib_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bɩ Yeezuu ŋ hɔɔndarɛ bɩ yɩ, an a hɩ ŋ nɩ, a ʊ: «Kʊ cirbəə deem zannɔ wuti ŋn'ɩ yar bam kan kʊ kɩ, a da an nawʊm, a cɛrɔ wɔɔ n a dɩnda kʊ ra sɔ. ");
INSERT INTO bib_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","K'awɔɔ ʊ, Bɛlzebul paŋŋa minto y'a ka mɔɔ nɩ lam zinəro ra bɩ, kʊ Sʊtaana a bɔ an nɩ yar bam kan a mɩŋŋa kɩ sɔ, a cirbəə bɩ nyɩntam lɔ? ");
INSERT INTO bib_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kʊ Bɛlzebul minto y'a ka mɔɔ nɩ lam zinəro ra, awɔɔ karɩndanyɩnɔ wɔɔ, la ŋ nawʊrɛ ŋ la, nka tɔ ma? Awɔɔ gʊɔɔ wɔɔ n n'awɔɔ dʊdɔ yarm. ");
INSERT INTO bib_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bɩ kʊ la mɔɔ nawʊm zinəro wɔɔ ra kan Woso wɔ paŋŋa kɩ, k'a dɔ a ʊ: Woso cirbəə b'ɩ lee ku awɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kʊ gʊaa paŋŋazaa ɩ dɔrɛ a har ma kan a yarbaa mɔrlɔ kɩ, hɔsɩ bɩ bam hɔ k'an ta m bɩ nɩ y. ");
INSERT INTO bib_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bɩ kʊ paŋŋazaa vanta bʊr a paŋŋa n lɛ da ra, an b'a nyasʊ an a da ra, an a yarbaa mɔrlɔ k'a ŋ ka a ma rɔ wɔɔ yɔ nɩ, hɔ k'an ta m bɩ gʊr an nawʊm an a jir. ");
INSERT INTO bib_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Gʊaa k'a ba kan mɔɔ kɩ bɩ, mɔɔ jɩm m. Gʊaa k'a bɩr a dam mɔɔ han an a so kʊ ma bɩ, a hɩsɩga an nawʊm.» ");
INSERT INTO bib_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Kʊ zinə bɔ gʊaa mɛ ʊ, bɩmbɩr an nawʊm zaŋŋa ʊ an n'a kam mɛnyɔɔ darɛ bɩncɛ ma. K'a n a yɩ y, a y'a hɩrɛ a mɩŋŋa m, a ʊ: Mɔɔ yɩ m wusigəm, m ta m har gusire ʊ, bɩncɛ kʊ mɔɔ m bɔ ʊ bɩ. ");
INSERT INTO bib_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","K'a a wusigə bɩ, a yaa dɩga a, n y'a waa, n n'a banka mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","A n a bɔ an ta, an aa zinəro gaa saanhɩna, ŋ bʊnyaabaa n lɛ da ra, ŋnɩ bɩ gasʊ, ŋnɩ nyɩnta b'ʊ. Bɩ gʊaa bɩ do bʊnyaabaa lɛ da m biisi ra.» ");
INSERT INTO bib_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yeezuu k'a meer ba ncɩnaaʊ bɩ, lʊ deem a leer busu an meer ba zamaa bɩ bire ʊ, a ʊ: «Mimbirenyɩntazaa m lʊ k'a ɩbɩɩ yɩ durnya ʊ, an nyɔ ka ɩbɩɩ ʊ bɩ m.» ");
INSERT INTO bib_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Mimbirenyɩntazannɔ m gʊɔɔ kʊ ŋ n'a tʊr kam Woso lemim ma, ŋn'a lɛ sim nɔ wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Zamaa bɩ k'a a so kʊ ma bɩ, Yeezuu y'a hɩrɛ ŋ nɩ, a ʊ: «Her naa ʊ gʊɔɔ wɔɔ, gʊɔɔ bʊnyaarɔ m, makra ŋn'a kam ma. Bɩ kʊ makra bɩ nɩ, ŋ bɩ makra vanta yɩm kʊ Zonas makra bɩ bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bala, Zonas k'a nyɩnta makra Niniivɩ gʊɔɔ mɩm ʊ bɩ, Gʊaanyɩ bɩ nyɩntam makra sɔ her naa ʊ gʊɔɔ wɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Woso dʊdɔkarɛ hinni ʊ, lʊcir k'a a to jɩsadɔpaasɩ ʊ bɩ wutim kan her naa ʊ gʊɔɔ nɔɔ m kɩ an ŋ dʊdɔ yar, bala, a to a ʊ durnya lɛ cɩnta jɛ ʊ, k'a b'a tʊr ka mindor Salomɔɔn lemim ma. Bɩ, bɔ ɩ lɛ da Salomɔɔn m b'ɩ naa ʊ. ");
INSERT INTO bib_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Dʊdɔkarɛ hinni ʊ, Niniivɩ gʊɔɔ wutim kan her gʊɔɔ nɔɔ m kɩ, ŋnɩ ŋ dʊdɔ yar, bala, kʊ ŋ y'a tʊr ka hɔ kʊ Zonas a hɩ bɩ ma bɩ, ŋ y'a bɔ a taam. Bɔ ɩ lɛ da Zonas ra b'ɩ naa ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Gʊaa ba ʊ an nɩ sɛ dam fɩtɩrɛ ʊ, an a nyaakʊm da y, gɛɛ, an a nyɔɔ kasɩ taa y. A cɩnta n nawʊm hɔ burə ʊ, kʊ gʊɔɔ kʊ ŋ nɩ gasʊm nɔ wɔɔ n lɛɛgure bɩ yɩ. ");
INSERT INTO bib_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ɩbɩɩ mɛsim fɩtɩrɛ bɩ, mɩnyaa m. K'ɩbɩɩ mɩnyaa mɩŋŋa, ɩbɩɩ mɛsim bɩ haay b'ɩ lɛɛgure ʊ. Bɩ, k'ɩbɩɩ mɩnyaa bɩ mɩŋŋa y, ɩbɩɩ mɛsim b'ɩ monsigə ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Dundo ɩ zi kan lɛɛgure k'a n'ɩbɩɩ ʊ bɩ kɩ, ɩ b'a ka, an a ba monsigə y. ");
INSERT INTO bib_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","K'ɩbɩɩ mɛsim haay ɩ lɛɛgure ʊ, bɩ monsigə poore ba ʊ tɔkkɛ, a haay nyɩntam lɛɛgure ʊ amba fɩtɩrɛ k'a nɩ lɛɛ bɔrɛ a ʊ, an nɩ lɛɛgure kam bɩ m.» ");
INSERT INTO bib_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yeezuu k'a nɩ meer bam bɩ, farizɛn deem a bir a har ʊ k'an bɩ hɔbɩrɛ bɩ. A n gasʊ, k'a hɔ bɩ. ");
INSERT INTO bib_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farizɛn bɩ k'a Yeezuu yɩ an nɩ hɔbɩrɛ bɩncɛ ʊ b'a n a wɔ hir amba n tɩr a ba bɩ, a zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Zuuba bɩ n a hɩ m, a ʊ: «Dɩga, awɔɔ farizɛɛnrɔ wɔɔ, hɛ kan laaga kɩ kur awɔɔ n'a sʊrgɔm, koorbaa n bɔkarɛ an awɔɔ heer han kan kʊsɩrabaa kɩ. ");
INSERT INTO bib_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hɔɔnwarzannɔ n'awɔɔ m! Gʊaa k'a kur bɩ ba bɩ, a bɛɛ y'a nɔ bɩ ba sɔ ra? ");
INSERT INTO bib_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bɩ, k'a hɔ ka cicirzannɔ ʊ, awɔɔ n n'a bam kɛɛrɛ bɩ haay yɩm mɩŋŋa awɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","A pakra barɛ awɔɔ m, farizɛɛnrɔ ra! Bala, ganwʊrɛ bu hɔ awɔɔ n'a kam kan mantɩ, poobur kɩ, kan hɔ haay k'a nɩ haanm brikəro ʊ bɩ kɩ. A bɔkarɛ a kaanm Woso tɩrgabaa bɩ m kan a ŋʊarɛ bɩ kɩ m. Bɩ, awɔɔ a ga m, a ba, a bɔɔ ɩ gɔɔta rɔ wɔɔ ba sɔ. ");
INSERT INTO bib_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","A pakra barɛ awɔɔ m, farizɛɛnrɔ ra! Awɔɔ ɩ lɛɛkarɛ bɩncɛrɔ wɔɔ ŋʊa sokʊmacɛrɔ ʊ, awɔɔ gʊɔɔ yaadarɛrɔ ŋʊa daasɩrɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","A pakra barɛ awɔɔ m, awɔɔ bɔ kʊ ʊ kan gəənoyaarɔ kɩ, ŋn'ɩ tɔrɛ ŋ la, bɩ ŋ bɩr a dɔrɛ y.» ");
INSERT INTO bib_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wosocikarɩnsaambɔɔ wɔɔ deem a hɩ Yeezuu m, a ʊ: «Karɩnsaamba, k'ɩbɩɩ nɩ meer barɛ ncɩnaaʊ bɩ, wɔɔ sʊnsɔ ɩbɩɩ n'a wʊm sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","A n a nyɩ bɔ ʊ, a ʊ: «Awɔɔ sɔ wosocikarɩnsaambɔɔ ra, a pakra barɛ awɔɔ m, awɔɔ nɩ mɔrlɔ gorezannɔ kam gʊɔɔ ra, b'awɔɔ bɔkarɛ, awɔɔ mɩŋŋɔɔ bɩr a nyʊkʊr deem taan… dam mɔrlɔ wɔɔ duro ma y. ");
INSERT INTO bib_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","A pakra barɛ awɔɔ m, awɔɔ k'a nɩ wosolɛsinnɩsorazannɔ wɔɔ yaarɔ dɔm bɩ minto, b'awɔɔ zɩrɔ yɩ ŋ zɩnzɛ. ");
INSERT INTO bib_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ncɩnaaʊ bɩ, awɔɔ y'a zɩrɔ wɔɔ kasɛtɩ karɛ a ʊ, awɔɔ yɛ ŋ zibəə bɩ ma. Bala, ŋ yɩ wosolɛsinnɩsorazannɔ wɔɔ zɩnzɛ, awɔɔ m bʊr an nɩ ŋ yaarɔ bɩmbankam. ");
INSERT INTO bib_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bɩ y'a ka Woso n a hɩ a mindɔrɛ nɔ ʊ, a ʊ: Mɔɔ wosolɛsinnɩsorazannɔ kan m zibəəzannɔ kɩ nyɔɔrɛ ŋ nɩ, ŋ gʊɔɔ gɔsɩnnɔ zɩnzɛrɛ ŋ barla, ŋnɩ zibəə bʊnyaa ba gɔsɩnnɔ m. ");
INSERT INTO bib_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bɩ minto bɩ, ŋ her gʊɔɔ wɔɔ hʊnhʊrm, wosolɛsinnɩsorazannɔ haay kʊ ŋ yɩ ŋ zɩnzɛ hallɩ durnya darɛ ma rɔ wɔɔ ma lore minto. ");
INSERT INTO bib_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","A n a sa Abɛl ma lore ma, an ta m Zakarii k'a ga Wosocɛ ʊ, mannɩjaa bɩ kan bɩncɛ mɩŋŋa bɩ kɩ bire ʊ. Sɩra mɔɔ n'a hɩrɛ awɔɔ m, ŋ her naa ʊ gʊɔɔ nɔɔn duro hʊnhʊrm minno nɔɔn duro minto. ");
INSERT INTO bib_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","A pakra barɛ awɔɔ m, wosocikarɩnsaambɔɔ ra, awɔɔ hɔdɔrɛ cɛlɛnyɩ sa a nyaakʊm da. Awɔɔ n gasʊ a zim y, a bɔkarɛ an n'a nyam gʊɔɔ kʊ ŋ lɛ taa k'a gasʊ ʊ rɔ wɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yeezuu k'a bɔ b'ʊ bɩ, wosocikarɩnsaambɔɔ wɔɔ kan farizɛɛnrɔ wɔɔ kɩ wuti ŋn'ɩ tatʊr bam kan nɔmaa kɩ, ŋn'ɩ laakarɔ do haay dɩndam han. ");
INSERT INTO bib_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ŋ n'ɩ dundom zi k'a ku a nyasʊ, a meerbaa deem nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dɔmɩm bɩ do ʊ bɩ, gʊɔɔ kʊ ŋ lɛ dɔrɛ ba ʊ a zɛ kʊ ra, hallɩ ŋn'ɩ tʊntɔm kʊ ra. Yeezuu n a sa, an n'a dɩndam a karɩndanyɩnɔ m, a ʊ: «A n lɛ da haay bɩ, k'a dundo a zi kan farizɛɛnrɔ nyʊnyɔɔ kʊ zambʊ m bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hɔ ba ʊ, an a nyaakʊm da, n b'a yɩrɛ y. Mim ba ʊ, an a nyaakʊm da, n b'a dɔrɛ y. ");
INSERT INTO bib_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hɔ k'awɔɔ hɩ monsigə ʊ bɩ, ŋ y'a mam lɛɛgure ʊ. Awɔɔ n a hɩ tʊr ʊ cɛ ʊ bɩ, n bɔm garga ra ŋn'a hɩ.» ");
INSERT INTO bib_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«A hɩ mɔɔ nawʊrɛ awɔɔ m, m hannyɩnɔ: A bɩ nyi ba gʊɔɔ kʊ ŋ nɩ mɛsim zɛm gər, bɩ, ŋ b'a dam hɔsɩ ma ŋn'a ba bɩ jɛ ʊ rɔ wɔɔ nɩ y. ");
INSERT INTO bib_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Hɔ k'awɔɔ a ga m a nyi ba m bɩ, kʊ m a hɩnka a m: K'a nyi ba Woso k'a a da ma an gər zɛ, bɩ jɛ ʊ an a da ma, an ɩ gasʊ sɛhar ʊ bɩ m. Sɩra mɔɔ n'a hɩrɛ awɔɔ m, bɩ, awɔɔ a ga m a nyi ba m. ");
INSERT INTO bib_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","N bɩr bɛnnɔ nyɩnɔ hɛɛnm soor, k'a tanka hɩɩya yɩ ra? Bɩ deem taan… tɔ bɩr bɔm Woso nɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","B'awɔɔ, awɔɔ minkə bɩ, ŋ y'a lɛ sa haay. A da bɩ bɔ y, awɔɔ jɩra bɛnnɔ nyɩnɔ m jilli.» ");
INSERT INTO bib_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«A hɩ mɔɔ nawʊrɛ awɔɔ m: Kʊ gʊaa kasɛtɩ ka gʊɔɔ taa, a ʊ, mɔɔ gʊaa n'a mɩ, Gʊaanyɩ bɩ y'a kasɛtɩ kam Woso malɛɛkarɔ taa sɔ. ");
INSERT INTO bib_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bɩ kʊ gʊaa bɩsɩ ka mɔɔ ma gʊɔɔ taa, mɔɔ bɩsɩ kam ma Woso malɛɛkarɔ taa sɔ. ");
INSERT INTO bib_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Gʊaa k'a meerbaa bʊnyaa ba Gʊaanyɩ bɩ ma, a y'a sugur yɩm. Bɩ, gʊaa k'a meerbaa bʊnyaa ba Sɛnt-Ɛspri ma, a b'a sugur yɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kʊ ŋ bʊr, ŋn'ɩ tarɛ awɔɔ m yaadarɛcɛrɔ ʊ, gɛɛ cinno taa, gɛɛ taralɛɛzannɔ taa, a b'a heer kɔ kan hɔ k'awɔɔ n n'a hɩm k'a mɩŋŋa bʊmbɔm bɩ kɩ y. ");
INSERT INTO bib_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bala, Sɛnt-Ɛspri y'a hɩrɛ awɔɔ m, a hɩrɛ dɔmɩm ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Gʊaa ɩ nyɩnta zamaa bɩ bire ʊ, an a hɩ Yeezuu m, a ʊ: «Karɩnsaamba, a hɩ mɔɔ danyɩ bɩ m k'an wɔɔ zɩ arzaka niŋŋə k'a a to bɩ jir kan mɔɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeezuu n a hɩ m, a ʊ: «Nka ɩ lɛ ka kʊ mɔɔ n nyɩnta awɔɔ dʊdɔkarɛzaa gɛɛ awɔɔ hɔjirlezaa?» ");
INSERT INTO bib_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","A n a hɩ ŋ nɩ, a ʊ: «K'a dundo a zi kan arzaka ŋʊarɛ kɩ. Bala, gʊaa mɩsɩrbaa bɩ bɩr zum kʊ ʊ kan a arzaka kɩ y, baa kʊ arzakazaa m.» ");
INSERT INTO bib_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","A n hɔbɔkʊrɛnoom naa do da ŋ nɩ, a ʊ: «Arzakazaa deem ɩ nyɩnta ʊ, a hɔsɩra n hɔ ba mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A n n'a hɔɔn darɛ a heer ʊ, a ʊ: Mɔɔ y'a bam lɔ? Bala, bɩncɛ ba mɔɔ ʊ, m nɩ m hɔyaa bɩ zarŋ ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A n n'a hɩ a mɩŋŋa m, a ʊ: Hɔ kʊ mɔɔ n'a bam bɩ ba n nɩ: kʊ m m sɩrɔ wɔɔ zɔ haay, m ŋ banka m ŋ dɔ gʊta-gʊta, m m hɔyaa bɩ zar ʊ kan m arzaka bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mɔɔ y'a hɩrɛ m mɩŋŋa m, mɔɔ ʊ: Ba ɩ n nɩ arzaka gʊta m na, dɔɔraa hɔka-hɔka minto. Mɛnyɔɔ da, hɔ bɩ, ɩ hɔ mi, k'ɩ heer nyɔɔ. ");
INSERT INTO bib_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bɩ, Woso a hɩ m, a ʊ: ‹Hɔɔnwarzaa ra, ɩbɩɩ gam gum naa ʊ. Hɔ k'ɩbɩɩ banka haay bɩ, nka n n'a sarɛ?› ");
INSERT INTO bib_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ncɩnaaʊ m kan gʊaa k'a arzaka gʊr an n'a kuntəre a mɩŋŋa tɔ ma, an bɔkarɛ hɔntazaa bɛɛ m Woso mɩm ʊ y.» ");
INSERT INTO bib_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yeezuu a hɩ a karɩndanyɩnɔ m, a ʊ: «Naa minto y'a ka mɔɔ n'a hɩrɛ awɔɔ m: a b'a heer kɔ kan hɔ k'awɔɔ n'a bɩm k'a mɩsɩrbaa ba bɩ mim kɩ y, a b'a heer kɔ kan huu k'awɔɔ n n'a dure a ma bɩ mim kɩ sɔ y. ");
INSERT INTO bib_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bala, mɩsɩrbaa lɛ da hɔbɩrɛ m, mɛsim n lɛ da huu m. ");
INSERT INTO bib_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","K'a dɩga kaakaarɔ ma, ŋ bɩr hɔ duure y, bɩ ŋ bɩr a darɛ y. Ŋ ba hɔbɩrɛ kuntəjɩ nɩ y, ŋ ba sɩ m sɔ y. Bɩ Woso yɩ ŋ tʊrm. Awɔɔ jɩra bɛnnɔ m gallɛm hɔka! ");
INSERT INTO bib_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Gʊaa bɩ kara n'awɔɔ bire ʊ, an n'a dam ma, an a mɩsɩrbaa nyɔɔ lɛɛ poore a heerkɔrɛ minto? ");
INSERT INTO bib_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","K'awɔɔ b'a dam a poore bɩ barɛ ma bɩ, bɔ minto m, awɔɔ n n'a heer kɔm kan bɔ ɩ gɔɔta haay bɩ kɩ? ");
INSERT INTO bib_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","K'a dɩga burvuro kʊ ŋ nɩ haanm hɔsɩra ʊ rɔ wɔɔ ma, ŋ bɩr lannɩ nɔɔrɛ, ŋ bɩr huu barɛ y, bɩ mɔɔ y'a hɩrɛ awɔɔ m: Salomɔɔn kan a cirbəə bɩ kɩ, a n huuro gʊɛrɛrɔ yɩ an burvuro nɔɔn duro deem nɩ y. ");
INSERT INTO bib_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kʊ Woso ɩ bur gʊɛrɛ dam ma ncɩnaaʊ her, booti m kʊ sɛ n a bɩ, a bɩ dɩgarɛ awɔɔ mim ma gʊta an lɛ da ra, sɩrakarɛ poore zannɔ ra? ");
INSERT INTO bib_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","B'awɔɔ, a b'a mɩŋŋa da kɔrɛ ma a a ka hɔ k'awɔɔ n n'a bɩm, kan hɔ k'awɔɔ n n'a mim bɩ kɩ ma y. ");
INSERT INTO bib_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Naa haay naa, durnya gʊɔɔ kʊ ŋ bɩr yaa dam nɔ wɔɔ n'a karɛ ŋ ma. B'awɔɔ Zɩ Woso a dɔ a ʊ, a zibəə ta awɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bɩ, k'a ka Woso cirbəə bɩ ma. A n nɩ bɔ ɩ gɔɔta bɩ darɛ awɔɔ m la.» ");
INSERT INTO bib_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Awɔɔ k'a bɔ kʊ ʊ kan hɔbɩsɩ cir poore kɩ bɩ, a da bɩ bɔ ʊ y. Bala, a awɔɔ Zɩ bɩ nɔ yɩ, k'a a cirbəə bɩ ka awɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","«K'a hɔ k'an ta awɔɔ ʊ bɩ hɛɛ, a ka cicirzannɔ ʊ. K'a a ka busoohɛra k'a bɩr zarm bɩ ma, kan arzaka k'a nyarɛ ba ʊ arzana ʊ bɩ kɩ. B'ʊ bɩ, ŋ nyaanlɛ ba ʊ y. Konno b'a dam ma ŋn'a sa, bɛɛ b'a dam ma an a bɩ y. ");
INSERT INTO bib_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bala, bɩncɛ k'awɔɔ arzaka bɩ n ta ʊ bɩ, awɔɔ heer bɩ, b'an ta ʊ sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«K'a hɔsoaʊ sa, a so a ʊ, k'a sɛ da a fɩtɩrɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","K'a a ba amba zibəənyɩnɔ kʊ ŋ nyɩnta ŋn'ɩ dɔm a harzaa k'a ta harcɩntarɛ cibsa ma rɔ wɔɔ m. Kʊ harzaa b'a bɔ an nɩ zɛrɛ, k'a bɩ lee ku an cɛlɛ zɛ, k'a gʊ m. ");
INSERT INTO bib_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mimbirenyɩntazannɔ m zibəənyɩnɔ nɔɔn duro m, kʊ ŋ harzaa bɩ bʊr, an bɩ dɩga a ŋ n hinceem ba y. Sɩra mɔɔ n'a hɩrɛ awɔɔ m: a y'a hɔsoaʊ sarɛ, an a so a ʊ an ŋ nyɩnta hɔbɩrɛ bɩrɛ bɩncɛ ʊ, an hɔbɩrɛ sa a zim an b'a ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mimbirenyɩntazannɔ m zibəənyɩnɔ wɔɔ m, k'a bɔ an bʊr dibsir ma gɛɛ dɔmɩrɛ m, a n a ya, an bɩ dɩga a ŋ n hinceem ba y. ");
INSERT INTO bib_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","K'a mim naa do jɩ ma mɩŋŋa. Kʊ harzaa bɩ, kʊ koor zɛrɛ dɔmɩm a dɔ, a b'a tom an gasʊ a cɛ ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Awɔɔ sɔ, k'a a banka mɩŋŋa. Bala, Gʊaanyɩ bɩ zɛm bɩ bʊr dɔmɩm niŋŋə k'awɔɔ bɩr a hɔɔn dam ma b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pɩyɛɛr n a lar, a ʊ: «Zuuba, wɔɔ minto ɩbɩɩ nɩ hɔbɔkʊrɛnoom naa do dam gɛɛ, gʊaa haay minto nɩ?» ");
INSERT INTO bib_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Zuuba n a nyɩ bɔ nʊ, a ʊ: «Nka m zibəənyɩ mɩŋŋa, a hɔɔn n ta ʊ? Bɔ harzaa lɛ ka ʊ k'an dɩga a har bɩ mim ma, k'an hɔbɩrɛ ka a muno wɔɔ ʊ dɔmɩm niŋŋə k'a a ga m b'ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mimbirenyɩntazaa m zibəənyɩ bɩ do m, kʊ harzaa a wusigə, an bʊr a har ʊ, an bɩ dɩga a a y'a zibəə lɛ ra. ");
INSERT INTO bib_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, harzaa bɩ y'a dɔm a arzaka bɩ haay ma. ");
INSERT INTO bib_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bɩ kʊ zibəənyɩ bɩ do a hɩ a heer ʊ, a ʊ: Mɔɔ harzaa bɩ bɩr zɛm zɔɔ y, an wuti an n'a zibəənyɩnɔ kʊ ŋ gɔɔta rɔ wɔɔ zɛrɛ, kan zibəənyɩlʊrɔ wɔɔ kɩ, an nɩ hɔ bɩrɛ an nɩ hɔ mire a mɩm nɩ durgəre. ");
INSERT INTO bib_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Zibəənyɩ bɩ do harzaa bɩ zɛm bɩ bʊr hin niŋŋə k'a n a hɔɔn da ma b'ʊ, kan wakatɩ k'a n a dɔ a ʊ a zɛm bɩ kɩ ʊ. A lam la, an fɩr ka ma mɩŋŋa, an a da gʊɔɔ kʊ ŋ bɩr zum Woso ʊ rɔ wɔɔ barla. ");
INSERT INTO bib_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Zibəənyɩ k'a hɔ k'a harzaa lɛ n taa bɩ dɔ bɩ, b'a bɩr a mɩŋŋa bankam, b'a bɩr bɩ hɔɔnhɔ barɛ, a zɛrɛ yɩm mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bɩ bɔ ɩ nɩ hɔ k'a harzaa lɛ n taa bɩ dɔ an bɔkarɛ an nɩ zi k'a a ga zɛrɛ m bam bɩ, a bɩ zɛrɛ yɩm gʊta y. Bɩ bɔ n y'a ka ʊ gʊta bɩ, n y'a laaka dam han gʊta. Bɔ n y'a ka ʊ gʊta k'an dɔ ma bɩ, n y'a sim han gʊta sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Bʊr mɔɔ ʊ sɛ m tara burə ʊ. A ŋʊa mɔɔ nawʊm paan… k'an yɔ. ");
INSERT INTO bib_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Fɩryɩrɛ n ta ʊ an nɩ mɔɔ yɩm. A gore ta ʊ kan mɔɔ kɩ, b'a mɔɔ ku an nya. ");
INSERT INTO bib_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","A hɔɔn awɔɔ n'a darɛ a ʊ laafɩɩ mɔɔ bʊr m tara burə ʊ ra? Ayy…, a hɩ mɔɔ nawʊrɛ awɔɔ m, bʊr mɔɔ ʊ gʊngʊ kʊ ma m. ");
INSERT INTO bib_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bala, naa ma kɛɛrɛ naa, kʊ gʊaa soor ɩ har deem ʊ, ŋ y'a gʊngʊm kʊ ma, gʊaa kaakʊ y'a gʊm gʊaa hɩɩya ma, gʊaa hɩɩya n a gʊ gʊaa kaakʊ ma. ");
INSERT INTO bib_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Zɩ y'a gʊrɛ a nyɩ ma, nyɩ n a gʊ a zɩ ma. Da y'a gʊrɛ a nyɩmbʊɛɛrɛ ma, nyɩmbʊɛɛrɛ n a gʊ a da ma. Da y'a gʊrɛ a nyar ma, nyar y'a gʊrɛ a da ma.» ");
INSERT INTO bib_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A n a ya, an a hɩ zamaa bɩ m, a ʊ: «K'awɔɔ warkʊ yɩ an jɩm meer ʊ, b'awɔɔ hɩ lɛɛm a ʊ: la n nɩ zɛm, b'a kʊ yɩm maam. ");
INSERT INTO bib_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","K'awɔɔ hɩnhɛr yɩ an a to jɩsadɔpaasɩ an nɩ hɔnrɛ, b'awɔɔ ʊ lɛɛ ma m, b'a kʊ yɩm maam. ");
INSERT INTO bib_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Zambʊzannɔ ra, awɔɔ ba lɔ a brama kan tara kɩ minno dɔ, a bɔkarɛ a n dɔmɩm k'an ta ʊ dɩɩtaa naa mim dɔ?» ");
INSERT INTO bib_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Bɔ m sɔ b'awɔɔ bɩr hɔ k'an mɩŋŋa bɩ dʊdɔ karɛ a zim nɩ y? ");
INSERT INTO bib_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","K'ɩbɩɩ jɩm ɩ tarɛ ɩ m dʊdɔkarɛ bɩncɛ ʊ, k'ɩ ɩ tɔ ʊ a kʊ ma zaa ra, k'a bɩ ta ɩ m dʊdɔkər taa y, kʊ dʊdɔkər bɩ b'ɩbɩɩ ka lɔnnɔdɔmazannɔ ʊ, ŋn'ɩbɩɩ du lɔnnɔcɛ ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sɩra mɔɔ n'a hɩrɛ ɩbɩɩ m: N b'ɩbɩɩ bɔm lɔnnɔcɛ b'ʊ k'ɩbɩɩ n zɩm bɩ ka haay ɩ nya y. Baa tanka deem bɩ gɔɔtarɛ y.» ");
INSERT INTO bib_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Dɔmɩm bɩ do ʊ bɩ, gʊɔɔ gɔsɩnnɔ bʊr, ŋnɩ bɩ Galilee gʊɔɔ kʊ Pɩlatɩ a ka ŋnɩ ŋ zɩnzɛ ŋ mannɩbarɛ dɔmɩm ʊ bɩ mim hɩ Yeezuu m. ");
INSERT INTO bib_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Awɔɔ y'a hɔɔn darɛ a ʊ, Galilee zannɔ kʊ ŋ yɩ ŋ zɩnzɛ naa mimbʊnyaabənno gʊtɔɔ m ŋnɩ lɛ da Galilee gʊɔɔ gɔsɩnnɔ wɔɔ ra gɛ? ");
INSERT INTO bib_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ayy…, a hɩ mɔɔ nawʊrɛ awɔɔ m, k'awɔɔ n a bɔ a taam y, gɩnga awɔɔ nawʊrɛ ncɩnaaʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bɩ, gʊaa bueeresinnyə kʊ Silowee cɛjintə a da ŋ la, an ŋ zɩnzɛ rɔ wɔɔ, awɔɔ y'a hɔɔn darɛ a ʊ, mimbʊnyaabənno m an lɛ da Zerizalɛm gʊɔɔ gɔsɩnnɔ wɔɔ ra gɛ? ");
INSERT INTO bib_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ayy…, a hɩ mɔɔ nawʊrɛ awɔɔ m, k'awɔɔ n a bɔ a taam y, gɩnga awɔɔ nawʊm haay am brɔɔ hɔ bɩ m.» ");
INSERT INTO bib_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bɩ kur bɩ, Yeezuu hɔbɔkʊrɛnoom naa do da ŋ nɩ, a ʊ: «Gʊaa ɩ nyɩnta ʊ, a sɔɔn n ta ʊ a dɩvɛnsɩra ʊ. A n bʊr k'a b'a bɔ, b'a n bɩ hɔsɩ yɩ y. ");
INSERT INTO bib_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","A n a hɩ hɔsɩra zibəəzaa bɩ m, a ʊ: A dɔɔraa kaakʊ hɔ m naa, mɔɔ n tɩr bʊr kʊ m b'a bɔ, bɩ mɔɔ n tɩr a nyɩ yɩ y. A da! Bɔ m an tara si an a so ʊ b'a zibəə ba ʊ y? ");
INSERT INTO bib_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bɩ n a nyɩ bɔ ʊ, a ʊ: Karɩnsaamba, ɩ ɩ ya, ɩ to dɔɔraa deem, kʊ m yaa hɔn, m a bɩr ma, kʊ m buundi da ma. ");
INSERT INTO bib_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","A a da ma, an bɩ nyɩ da dɔɔraa m, k'a bʊr a n nyɩ da y, k'ɩ ka kʊ n n'a da.» ");
INSERT INTO bib_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yeezuu nyɩnta an nɩ hɔ dɩndam sokʊmacɛ ʊ *sabaa hinni ʊ. ");
INSERT INTO bib_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lʊ ɩ nyɩnta b'ʊ zinə n a ka, an a huŋŋu a dɔɔraa bueeresinnyə hɔ m naa. A b'a dam ma an jɩm brama tɩrga y. ");
INSERT INTO bib_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yeezuu k'a a yɩ bɩ, a a bir, an a hɩ m, a ʊ: «Lʊ, ɩ ɩ waa, ɩ yaaba bɩ nya.» ");
INSERT INTO bib_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A n a wɔ ka a mim la. Lɛɛm bɩ, lʊ b'a ba tɩrga, an n'a lɛ bɔm Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sokʊmacɛ cir bɩ k'a a yɩ Yeezuu n lʊ bɩ waa sabaa hinni ʊ bɩ, a nɔ ma ʊ. A meerbaa bɩ si, an a hɩ zamaa bɩ m, a ʊ: «Dɔmɩm sɔrdɩ n ta ʊ, gʊɔɔ n a da ma, ŋnɩ zi ba. Dɔmɩnnɔ wɔɔ duro awɔɔ a ga m, a bʊr, ŋn'a waa, sabaa hinni ʊ bɛɛ y.» ");
INSERT INTO bib_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Zuuba n a nyɩ bɔ nʊ, a ʊ: «Zambʊzannɔ ra! Awɔɔ gʊaa biyəə bɩr a der zarm, gɛɛ, a bra, k'a yaa ka hi ma sabaa hinni ʊ ra? ");
INSERT INTO bib_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Bɩ lʊ naa do Abraham yaŋŋa m, zinə n yaaba da ma a dɔɔraa bueeresinnyə hɔ m naa, sabaa hinni bɛɛ a a ga m, n n a bɔ bar ma ra?» ");
INSERT INTO bib_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","K'a naa hɩ bɩ, nyannɩ a jɩnnɔ wɔɔ haay nyasʊ. Zamaa bɩ n'a heer nyɔɔm kan zibəə gʊtɔɔ haay k'a n'a bam bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","A a ya, an a hɩ, a ʊ: «Woso cirbəə bɩ, bɔ a kʊ ʊ kan bɔ kɩ? A makra mɔɔ n'a bam kan bɔ kɩ? ");
INSERT INTO bib_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bɔ a kʊ ʊ kan mutardɩ yaa kʊ gʊaa n'a sam, an n'a duum a brikə ʊ bɩ kɩ. A n haan, an a ba gɔ gʊta, bɛnnɔ nɩ cɛ kɩnkarɛ a vəŋŋəro ma.» ");
INSERT INTO bib_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","A n a ya, an a hɩ, a ʊ: «Woso cirbəə bɩ makra mɔɔ n'a bam kan bɔ kɩ? ");
INSERT INTO bib_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A makra mɔɔ n'a bam kan nyʊnyɔɔ kʊ lʊ n'a sam, an n'a warm kʊ ma kan koŋŋo kaakʊ nyisi kɩ, an nɩ derm haay.» ");
INSERT INTO bib_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeezuu bɔ kʊrɔ ʊ kan bɔlɛɛmarɔ kɩ ʊ, an nɩ hɔ dɩndam, an nɩ tam Zerizalɛm zeezi. ");
INSERT INTO bib_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Gʊaa deem n a lar, a ʊ: «Zuuba, gʊɔɔ kʊ ŋ nɩ bʊmbɔrɛ yɩm nɔ wɔɔ, ŋ bɩ gʊta nɩ?» ");
INSERT INTO bib_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","A n a hɩ ŋ nɩ, a ʊ: «K'a a tɔ ʊ k'a gasʊ hallɛ poore bɩ m. Bala, a hɩ mɔɔ nawʊrɛ awɔɔ m, gʊɔɔ gʊta y'a kam ma k'a gasʊ m, bɩ ŋ b'a dam ma y. ");
INSERT INTO bib_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kʊ harzaa bɩ bɩ wuti, an hallɛ bɩ ta, awɔɔ gɔɔtam garga ra, awɔɔ ba n bɩr cɛlɛ zɛrɛ, a bɩr a hɩrɛ, a ʊ: Zuuba, cɛlɛ gʊ wɔɔ m. A y'a nyɩ bɔrɛ awɔɔ nʊ, a ʊ: Awɔɔ, mɔɔ n awɔɔ tojɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Awɔɔ y'a hɩm nɩ, a ʊ: Wɔɔ hɔ bɩ, ʊ hɔ mi kan ɩbɩɩ kɩ. Ɩbɩɩ hɔ dɩnda gʊɔɔ m, ʊ daasɩrɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","B'a y'a hɩrɛ awɔɔ m, a ʊ: Mɔɔ n awɔɔ tojɩ dɔ y. Awɔɔ, k'a a gaa mɔɔ ma, awɔɔ haay k'a nɩ mimbʊnyaarɔ bam bɩ. ");
INSERT INTO bib_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","K'awɔɔ bɩ Abraham kan Izakkɩ, Zakɔɔb kɩ yɩ Woso cirbəə nɔ ʊ, kan wosolɛsinnɩsorazannɔ wɔɔ haay kɩ awɔɔ n nɩ garga ra, a nyɩntarɛ awɔɔ ma baadarɛ kan sɔ sʊrɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Gʊɔɔ y'a tom dɔjɩr kan meer kɩ ʊ, jɩsa kan bɩsɩ kɩ ʊ, ŋnɩ bɩ nyɩnta ŋnɩ hɔ bɩ Woso cirbəə nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kɛɛrɛ bɩ, jɛzannɔ nyɩntam lɛɛkarɛzannɔ, lɛɛkarɛzannɔ n nyɩnta jɛzannɔ.» ");
INSERT INTO bib_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dɔmɩm bɩ do ʊ bɩ, farizɛɛnrɔ gɔsɩnnɔ b'a zɔ Yeezuu ma, ŋn'a hɩ m, ŋ ʊ: «Ta bɩncɛ vanta ʊ. Hɩrɔɔdɩ y'a kam ma k'a ɩbɩɩ zɛ.» ");
INSERT INTO bib_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A n a hɩ ŋ nɩ, a ʊ: «K'a yaa hɩ pooji naa do m: mɔɔ ɩ lam zinəro ra, m nɩ gʊɔɔ waam, her kan booti kɩ zizer kɩ, an nya. ");
INSERT INTO bib_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bɩ pakra m kʊ m ta lɛɛ her, kan booti kɩ zizer kɩ. Bala wosolɛsinnɩsorazaa b'a dam ma an ga bɩncɛ vanta ʊ kʊ Zerizalɛm nɔ bɛɛ y.» ");
INSERT INTO bib_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Zerizalɛm, Zerizalɛm, ɩbɩɩ k'ɩ nɩ wosolɛsinnɩsorazannɔ zɩnzɛm, ɩ nɩ gʊɔɔ kʊ ŋ yɩ ŋ nyɔɔ ɩbɩɩ ma rɔ wɔɔ bɩmbam jaarɔ m bɩ. Gallɛm karɔ, mɔɔ ŋʊa kʊ m ɩ nyɩnɔ so kʊ ma, amba kʊr tɩr a nyɩnɔ so kʊ ma a za taa bɩ m, b'ɩbɩɩ n yɛ? ");
INSERT INTO bib_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dɩga! Woso y'a bɔrɛ ɩbɩɩ ʊ. Bɩ, mɔɔ y'a hɩrɛ awɔɔ m: Awɔɔ b'a yarɛ a mɔɔ yɩ y, an ta an dɔmɩm k'awɔɔ nɩ zɛm b'a hɩ, a ʊ: ‹Gʊaa k'a nɩ zɛm Zuuba Woso tɔ ma bɩ n barka yɩ.› » ");
INSERT INTO bib_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yeezuu gasʊ farizɛɛnrɔ jɩtaarɛ deem har ʊ, *sabaa hinni ʊ, k'a hɔbɩrɛ bɩ. Farizɛɛnrɔ wɔɔ nɩ dundom zi. ");
INSERT INTO bib_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Gʊaa deem ɩ bɩ jɩm Yeezuu lɛɛ, a mɛ n hɩnhanrɛ. ");
INSERT INTO bib_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeezuu n a hɩ wosocikarɩnsaambɔɔ wɔɔ m kan farizɛɛnrɔ wɔɔ kɩ, a ʊ: «Zaa ta ʊ k'ʊ yaabazaa waa sabaa hinni ʊ gɛɛ, zaa ba ʊ y?» ");
INSERT INTO bib_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ŋ nɩ zɛ pi. Kɛɛrɛ bɩ, Yeezuu n yaabazaa bɩ gaa, an a waa, an a da zaa ra. ");
INSERT INTO bib_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bɩ kur bɩ, an a hɩ ŋ nɩ, a ʊ: «Gʊaa bɩ kara n'awɔɔ bire ʊ naa ʊ, a nyɩ, gɛɛ, a der n a da hiyəə ʊ sabaa hinni ʊ, a bɩ bra sire, an a bɔ ʊ lɛɛm nɩ?» ");
INSERT INTO bib_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bɩ ŋ n a da ma ŋn'a nyɩ bɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yeezuu k'a gʊɔɔ kʊ ŋ yɩ ŋ bir hɔbɩrɛ ma rɔ wɔɔ yɩ, ŋn'ɩ lɛɛkarɛ bɩncɛrɔ bʊmbɔŋ ʊ bɩ, a hɔbɔkʊrɛnoom naa do da ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Kʊ gʊaa ɩbɩɩ bir harcɩntarɛ cibsa ma, ɩ b'aa nyɩnta lɛɛkarɛ bɩncɛ ʊ y. Bala, a a da ma, a gʊaa vanta bir, an lɛ da ɩbɩɩ ra. ");
INSERT INTO bib_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Gʊaa k'awɔɔ bir bɩ, a b'a ka, an b'a hɩ awɔɔ gʊaa hɩɩya bɩ m, a ʊ: toore ka ɩ mim b'ʊ y. Ɩbɩɩ zɛm bɩ wuti kan nyannɩ kɩ, ɩ ta jɛ bɩncɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bɩ kʊ n y'ɩbɩɩ bir hɔbɩrɛ ma, k'ɩ yaa nyɩnta jɛ bɩncɛ ʊ, gʊaa k'a ɩbɩɩ bir bɩ, k'a bɩ bʊr, a y'a hɩrɛ ɩbɩɩ m, a ʊ: M hannyɩ, ɩ zɔ lɛɛ bɩncɛ b'ʊ. A nyɩntarɛ ɩbɩɩ tɔ busure gʊaa haay kʊ ŋ nɩ hɔ bɩrɛ kan ɩbɩɩ kɩ rɔ kɩ lɛɛ. ");
INSERT INTO bib_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bala, gʊaa k'a n'a mɩŋŋa busum bɩ, n y'a zerm, bɔ n'a mɩŋŋa zerm bɩ, n y'a busum.» ");
INSERT INTO bib_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","A n a hɩ gʊaa k'a a bir bɩ m sɔ, a ʊ: «K'ɩbɩɩ sinuu hɔbɩrɛ ba gɛɛ gunuu hɔ, ɩ b'ɩ hannyɩnɔ, gɛɛ, ɩ dogʊɔɔ, gɛɛ ɩ cɩsɔnnɔ arzakazannɔ kɩ bir y. Kʊ n bɛɛ, ŋ y'ɩbɩɩ birm sɔ a zɩm ma, ŋn'a so a yaa ʊ. ");
INSERT INTO bib_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bɩ, k'ɩ cibsa hɔbɩrɛ ba, k'ɩ cicirzannɔ, paŋŋawarzannɔ, lʊgɔrɔ, bʊʊrɔ kɩ bir, ");
INSERT INTO bib_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","b'a nyɩntam mimbirenyɩnta kan ɩbɩɩ kɩ, bala, ŋ b'a dam ma ŋ n a ba, ŋ n a so a yaa ʊ y. Bala, Woso naa sompire ɩbɩɩ m, gʊɔɔ tɩrgɔɔ mɩmbɔʊrɛ dɔmɩm ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Gʊaa deem k'a nyɩnta b'ʊ an naa haay ma bɩ, a a hɩ Yeezuu m, a ʊ: «Mimbirenyɩntazaa m gʊaa k'a nɩ zɛm bɩ hɔbɩrɛ bɩ Woso cirbəə nɔ ʊ bɩ m.» ");
INSERT INTO bib_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yeezuu n a hɩ m, a ʊ: «Gʊaa deem ɩ nyɩnta an cibsa gʊta hɔbɩrɛ ba. A n zamaa bir gʊta kʊ ŋ nɩ b'a bɩ. ");
INSERT INTO bib_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hɔbɩrɛ bɩ dɔmɩm k'a ku bɩ, a a zibəənyɩ nyɔɔ gʊɔɔ k'a ŋ bir hɔbɩrɛ bɩ ma rɔ wɔɔ zi, a ʊ: K'a bʊr kɛɛrɛ, n hɔ haay banka, an nya. ");
INSERT INTO bib_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ŋ haay n a lɛ ba deem, ŋ ʊ: a b'a dam ma y. Lɛɛkarɛ zaa bɩ n a hɩ zibəənyɩ bɩ m, a ʊ: hɔsɩra mɔɔ si, pakra m kʊ m ta, m aa dɩga a. Mɔɔ y'a yɛrɛ ɩbɩɩ han, k'ɩ sugur ba m ma. ");
INSERT INTO bib_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","A vanta n a hɩ, a ʊ: Dono mɔɔ n si bu, kʊ m aa nɩ ŋ makra ba ŋ dɩga a. Mɔɔ y'a yɛrɛ ɩbɩɩ han k'ɩ sugur ba m ma. ");
INSERT INTO bib_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","A vanta n a ya, an a hɩ, a ʊ: lʊ mɔɔ sa daa, bɩ y'a ka mɔɔ bɩ m dam ma, m bʊr y. ");
INSERT INTO bib_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Zibəənyɩ bɩ k'a a wusigə bɩ, a yaa naa hɩ a harzaa bɩ m. Harzaa bɩ nɔ n ma ʊ, an a hɩ, a ʊ: ta zɔɔ-zɔɔ kʊ bɩ daasɩrɔ ʊ, kan kʊ bɩ zaa bire rɔ kɩ, ɩ cicirzannɔ gaa kan paŋŋawarzannɔ kɩ, lʊgɔrɔ kɩ, bʊʊrɔ kɩ ɩ bʊr ŋ nɩ naa ʊ. ");
INSERT INTO bib_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Zibəənyɩ bɩ n ta an a bɔ an bʊr an b'a hɩ, a ʊ: harzaa, ʊ lɛ k'ɩbɩɩ ka bɩ ba, bɩ lɛ gɔɔta. ");
INSERT INTO bib_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Harzaa bɩ n a hɩ zibəənyɩ bɩ m, a ʊ: ta zaa poorero wɔɔ ra kan brikəro kɩ, ɩ ɩ ka gʊɔɔ wɔɔ ma ɩ gasʊ ŋ nɩ, kʊ lɛ bɩ gɔɔta mɔɔ har b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bala, a hɩ mɔɔ nawʊrɛ awɔɔ m, gʊɔɔ kʊ mɔɔ n bir lɔ wɔɔ, gʊaa deem taan… ba ʊ an nɩ mɔɔ hɔbɩrɛ bɩ darɛ a lɛ ʊ y.» ");
INSERT INTO bib_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bɩ jɛ ʊ, gʊɔɔ cir gʊta zu Yeezuu ʊ. A n a bɔ an a hɩ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Kʊ gʊaa bʊr mɔɔ zi, a n mɔɔ ŋʊa an lɛ da a zɩ ra, kan a da kɩ, a lʊ kɩ, a nyɩnɔ kɩ, a cɛmbɔɔ kɩ, a danlʊrɔ kɩ, baa kan a mɩŋŋa mɩsɩrbaa kɩ, a b'a dam ma an nyɩnta mɔɔ karɩndanyɩ y. ");
INSERT INTO bib_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Gʊaa k'a bɩr a gɔdarkʊra busure an nɩ zum mɔɔ jɛ ʊ, a b'a dam ma an nyɩnta mɔɔ karɩndanyɩ y. ");
INSERT INTO bib_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kʊ sɩra nɩ, gʊaa bɩ kara n'awɔɔ bire ʊ a lɛ n taa k'a cɛ gʊta dɔ, a n lɛɛ ka an nyɩnta, an busoo k'a n'a bɩm bɩ lɛ zɛ, an a dɔ, k'a cɛ bɩ dɔm gɛ ra? ");
INSERT INTO bib_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kʊ bɩ bɛɛ, k'a lɛɛ ka an a jɩr cɩnta b'a b'a dam ma an a nyambʊr y, gʊɔɔ haay kʊ ŋ n'a yɩm bɩ, ŋ yaa wʊm ma, ");
INSERT INTO bib_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ŋnɩ bɩr a hɩrɛ, ŋ ʊ: Ba gʊaa cɛ dɔrɛ sɩŋŋɩda sa na, b'a n a nyambʊr na. ");
INSERT INTO bib_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Gɛɛ cir bɔ n ta ʊ, k'a ɩ tam k'a yaa yar ba kan cir vanta kɩ, a n lɛɛ ka an nyɩnta an dɩga, k'a y'a dam ma kan gʊaa tisi bu kɩ, a yar ba kan gʊaa k'a nɩ gʊaa m tisi buhɩra bɩ kɩ gɛ? ");
INSERT INTO bib_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kʊ bɩ bɛɛ, cir deem bɩ k'a gɔɔta an laatʊ bɩ, a gʊaa deem nyɔɔ n zi, an aa laafɩɩ mim dɩnda kan kɩ. ");
INSERT INTO bib_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ncɩnaaʊ sɔ bɩ, awɔɔ bire ʊ kʊ gʊaa lɛ baa k'a wɔ saa hɔ k'an ta m bɩ ma, a b'a dam ma an nyɩnta mɔɔ karɩndanyɩ y.» ");
INSERT INTO bib_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Sɩra m, yɛ k'an naa, hɔ mɩŋŋa m. Bɩ kʊ yɛ nyɩntabaa bɩ bɔ, bɔ n'a yarɛ an bʊr a nyɩntabaa bɩ nɩ? ");
INSERT INTO bib_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A bɩ mɩŋŋa tara minto, b'a bɩ yɩm buundi sɔ y. A lo n nawʊm garga ra. Gʊaa k'a nɩ tʊr m k'an a ma.» ");
INSERT INTO bib_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yawʊrsinno kan mimbʊnyaabənno kɩ haay a zɔ Yeezuu ma, k'a a tʊr ka ma. ");
INSERT INTO bib_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farizɛɛnrɔ kan wosocikarɩnsaambɔɔ kɩ nɩ kukur barɛ, ŋ ʊ: «Gʊaa naa do ɩ mimbʊnyaabənno sim, an nɩ hɔ bɩm kan ŋ kɩ.» ");
INSERT INTO bib_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bɩ Yeezuu hɔbɔkʊrɛnoom naa do da ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Gʊaa bɩ kara n'awɔɔ bire ʊ, a seero n ta ʊ zɔrɔ, deem n nyaam, a bɩ bunɛɛhʊ a yaa n nɛɛhʊ rɔ wɔɔ tom a hɔbɩjɩ ʊ, an ta an aa a ka deem bɩ ma, an tolle ba an a yɩ? ");
INSERT INTO bib_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bɩ, k'a a yɩ, a busu an nawʊm kan heernyɩnta kɩ a kɔɔn ra. ");
INSERT INTO bib_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","K'a lee ku har ʊ, an a hannyɩnɔ so kʊ ma kan a cɩsɔnnɔ kɩ an a hɩ ŋ nɩ, a ʊ: k'a heer nyɔɔ kan mɔɔ kɩ, bala mɔɔ m ser k'a nyaam bɩ yɩ. ");
INSERT INTO bib_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A hɩ mɔɔ nawʊrɛ awɔɔ m, heernyɔɔ nyɩntaŋ ʊ gʊta arzana ʊ, mimbʊnyaabər deem k'a a bɔ a taam bɩ tɔ ma, an lɛ da gʊɔɔ tɩrgɔɔ bunɛɛhʊ a yaa nɛɛhʊ rɔ wɔɔ kʊ heerlʊrlɛ zibəə ba ŋ ma rɔ wɔɔ ra.» ");
INSERT INTO bib_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Gɛɛ lʊ bɩ kara n ta ʊ, a wanzurfu m bu, deem n nyaam, a bɩ sɛ dam fɩtɩrɛ ʊ, an cɛ bɩ waa, an a ka ma mɩŋŋa an tolle ba an a yɩ? ");
INSERT INTO bib_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bɩ k'a a yɩ, a y'a hannyɩnɔ som kʊ ma, kan a cɩsɔnnɔ kɩ an a hɩ ŋ nɩ, a ʊ: K'a heernyɔɔ kan mɔɔ kɩ, bala mɔɔ m wanzurfu k'a nyaam bɩ yɩ. ");
INSERT INTO bib_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","A hɩ mɔɔ nawʊrɛ awɔɔ m, heernyɔɔ ta ʊ Woso malɛɛkarɔ zi mimbʊnyaabər deem k'a n'a bɔrɛ a taam tɔ ma.» ");
INSERT INTO bib_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeezuu n a ya, an a hɩ, a ʊ: «Gʊaa ɩ nyɩnta ʊ, a nyɩnɔ hɩɩya. ");
INSERT INTO bib_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A poore bɩ n a hɩ a zɩ m, a ʊ: M zɩ, arzaka k'ɩbɩɩ n ta m bɩ, a jir, k'ɩ m hɔ ka m ʊ. Ŋ zɩ bɩ n arzaka k'an ta m bɩ jir ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A dɔmɩm k'a yɩ poore bɩ, nyɩ poore b'a hɔ bɩ gʊr an a hɛɛ, an ta zaa ra, kʊ laatʊrɛ ʊ. B'ʊ bɩ, a yaa a arzaka bɩ zar zibəəro bʊnyaarɔ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","K'a a zar an a nya bɩ, nɔ gʊta a da kʊ b'ʊ, cicir n a nyasʊ. ");
INSERT INTO bib_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A n ta, an nɩ zi bam kan tara bɩ gʊaa deem kɩ, bɩ n a nyɔɔ kurkuuro dɔ ma ʊ a hɔsɩra ʊ. ");
INSERT INTO bib_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A mɩŋŋa a ŋʊa k'a hɔbɩrɛ kʊ kurkuuro wɔɔ n'a bɩm bɩ bɩ, k'an a ka. Bɩ gɔsɩ bɩr a kaŋ ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","A n bɩ, an nyɩnta an a hɔɔn da, a ʊ: Mɔɔ zɩ zibəəzannɔ gʊta, ŋn'ɩ hɔbɩrɛ bɩrɛ a mɩsɩ nɩ gɔɔtam, mɔɔ n bʊr kɛɛrɛ, m nɩ gam nɔ ma naa ʊ. ");
INSERT INTO bib_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mɔɔ tarɛ m zɩ zi, m aa a hɩ m, mɔɔ m zar Woso kan ɩbɩɩ kɩ ma. ");
INSERT INTO bib_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mɔɔ n m ga m, ɩbɩɩ n ɩ ya, ɩ mɔɔ bir ɩ nyɩ y. Mɔɔ ba am ɩ zibəəzannɔ gʊaa deem hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A n a bɔ an nɩ doore a zɩ bɩ zi. K'a gɔɔta an laatʊ bɩ, a zɩ bɩ n a to an a yɩ, a cicir n a nyasʊ. A n bra si, an aa a wɔ burgu ma, an a lɛ dɔrɛ. ");
INSERT INTO bib_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","A nyɩ bɩ n a hɩ m, a ʊ: M zɩ, mɔɔ mim zar Woso kan ɩbɩɩ kɩ ma, mɔɔ n m ga m, k'ɩ ɩ ya, ɩ mɔɔ bir ɩ nyɩ y. ");
INSERT INTO bib_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","B'a zɩ b'a hɩ a zibəənyɩnɔ wɔɔ m, a ʊ: K'a ba zɔɔ, a bʊr huu k'a gʊɛrɛ lɛ da bɩ m, a b'a du ma. K'a bʊr tolleŋŋa m a da a nyʊkʊm ma, k'a kʊsɔrɔ da a gam ʊ. ");
INSERT INTO bib_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","K'a bʊr dinnyɛɛm ka mɛ ka bɩ m, a zɛ k'ʊ a bɩ, k'ʊ ʊ heer nyɔɔ, ");
INSERT INTO bib_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","bala, mɔɔ nyɩ k'a nyɩnta an ga bɩ, a a mɩm bɔ ʊ, a nyɩnta an nyaam, ʊ ʊ ya, ʊ a yɩ. Ŋ n a sɩŋŋɩda sa, ŋn'ɩ cibsa barɛ. ");
INSERT INTO bib_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","A nyɩ jɩtaarɛ bɩ nyɩnta pooyaa ʊ. K'a a bɔ, an nɩ zɛm an a zɔ har ma bɩ, a bɩ kɔnnɩrɔ kan bintiiro kɩ nyi ma, kan sarbaa kɩ. ");
INSERT INTO bib_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A n zibəənyɩ deem bir an laaka da a jɩ ma. ");
INSERT INTO bib_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Zibəənyɩ bɩ n'a nyɩ bɔ ʊ, a ʊ: Ɩbɩɩ dam bɩ y'a bɔ an bʊr, ɩbɩɩ zɩ bɩ n dinnyɛɛm k'ʊ wɔɔ tʊr bɩ zɛ, k'a a nyɩ bɩ yɩ kan laafɩɩ kɩ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nyɩ jɩtaarɛ bɩ nɔ n ma ʊ, a ʊ: A bɩ gasʊm har ʊ y. A zɩ bɩ n bɔ k'a yaa bir k'an bɩ gasʊ. ");
INSERT INTO bib_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A n a hɩ m, a ʊ: Dɩga a, a dɔɔraa gʊta mɔɔ n'ɩbɩɩ zi bam, mɔɔ n kaanm ɩbɩɩ lɛ m deem nɩ y. B'ɩbɩɩ n binnyɛɛm ka mɔɔ ʊ cɩna m a zɛ, m cibsa ba m kan m hannyɩnɔ kɩ y. ");
INSERT INTO bib_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","B'ɩbɩɩ nyɩ k'a ɩbɩɩ arzaka gʊr, an aa a zar kan lannɔmɩŋŋaheenno kɩ an a bɔ an bʊr naa, ɩbɩɩ dinnyɛɛm k'a mɛ ka bɩ zɛ a minto. ");
INSERT INTO bib_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A zɩ bɩ n a hɩ m, a ʊ: M nyɩnnɩ, ɩbɩɩ ɩ kan mɔɔ kɩ dɔmɩm haay, hɔ haay k'a nɩ mɔɔ ʊ bɩ, ɩbɩɩ y'ɩ so ʊ. ");
INSERT INTO bib_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Bala, a a ga m k'ʊ cibsa ba, k'ʊ ʊ heer nyɔɔ. Ɩbɩɩ dam bɩ k'a nyɩnta an ga, an a mɩm bɔ ʊ bɩ minto. Nyaam a ʊ, ʊ ʊ ya, ʊ a yɩ.» ");
INSERT INTO bib_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeezuu n a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «Arzakazaa deem ɩ nyɩnta ʊ, a zibəənyɩ n ta ʊ, an nɩ dɩgarɛ a hɔnyɩ mim ma. Gʊɔɔ n b'a hɩ arzakazaa bɩ m, ŋ ʊ: Awɔɔ zibəənyɩ bɩ y'awɔɔ arzaka bɩ zarm. ");
INSERT INTO bib_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","A n a bir, an a hɩ m, a ʊ: bɔ minto m n n'ɩbɩɩ mim dɩndam mɔɔ m, ncɩnaaʊ? Ɩ hɔcɩntarɛ ciro ka m ʊ, bala ɩbɩɩ b'ɩ yarɛ, ɩ mɔɔ zi bɩ ba y. ");
INSERT INTO bib_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Zibəənyɩ bɩ n'a mɩŋŋa larm, a ʊ: Kʊ m a ba lɔ? Kʊ mɔɔ zuuba mɔɔ bɔ zibəə b'ʊ bɩ? Mɔɔ paŋŋa ba ʊ kʊ m dam wʊ ra? Hɔyɩnyɛrɛ nyannɩ ɩ mɔɔ zɛm. ");
INSERT INTO bib_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hɔ kʊ mɔɔ n n'a bam bɩ mɔɔ dɔ, kʊ m bɩ bɔ zibəə b'ʊ, kʊ gʊɔɔ n m si a har ʊ. ");
INSERT INTO bib_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","A n gʊɔɔ kʊ zuuba bɩ zɩnnɔ ta ŋ lɛ rɔ wɔɔ bir deem-deem, an lɛɛkarɛzaa bɩ lar, a ʊ: Ɩbɩɩ ta mɔɔ zuuba bɩ zɩm m karɔ? ");
INSERT INTO bib_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Bɩ n a nyɩ bɔ ʊ, a ʊ: Nyɔɔ gər zɔrɔ. A n'a hɩ bɩ m, a ʊ: Ba ɩ sɩraci m na, a si, ɩ nyɩnta zɔɔ-zɔɔ ɩ gʊrsɩra ba busoor. ");
INSERT INTO bib_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","A n a ya, an a vanta lar, a ʊ: B'ɩbɩɩ, ɩ ta m karɔ? A ʊ: Hɔyaa yɔrgɔ zɔrɔ. Zibəənyɩ bɩ n a hɩ m, a ʊ: Ba ɩbɩɩ sɩraci n na, a gʊrsɩra ba businnyə. ");
INSERT INTO bib_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Zuuba bɩ n a lɛ bɔ zibəənyɩ b'ʊ, zi k'a ba ncɩnaaʊ bɩ tɔ ma. Her naa ʊ gʊɔɔ wɔɔ hɔɔn ka kan kʊ kɩ, an lɛ da lɛɛgurezannɔ wɔɔ ra.» ");
INSERT INTO bib_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«Sɩra mɔɔ n'a hɩrɛ awɔɔ m, k'a durnya arzaka bɩ sa a gʊaasɩbabaa da m gʊɔɔ ma. Dɔmɩm niŋŋə k'a bʊr a b'awɔɔ ʊ bɩ, Woso y'awɔɔ sire a har ʊ. ");
INSERT INTO bib_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Gʊaa k'a sɩra ba kan hɔ poore kɩ, a sɩra barɛ a gʊta m sɔ. Bɩ gʊaa k'a n sɩra ba hɔ poore m, a bɩ sɩra bam hɔ gʊta m sɔ y. ");
INSERT INTO bib_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bɩ minto bɩ, k'awɔɔ n sɩra ba kan durnya naa arzakarɔ kɩ y, nka nɩ hɔnyɩ paan… bɩ karɛ awɔɔ ʊ? ");
INSERT INTO bib_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bɩ k'awɔɔ n sɩra ba gʊaa hɔ m, nka n n'awɔɔ mɩŋŋɔɔ hɔ bɩ karɛ awɔɔ ʊ? ");
INSERT INTO bib_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Zibəənyɩ ba ʊ a n n'a dam ma, an zuubɔɔ hɩɩyɔɔ zi ba y. A deem ŋʊarɛ, an sɔ deem m. Gɛɛ an bɩr kan deem kɩ, an kaanm deem m. Awɔɔ b'a dam ma a Woso ŋʊa, a busoo ŋʊa sɔ y.» ");
INSERT INTO bib_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farizɛɛnrɔ busoo ŋuənno wɔɔ y'a tʊr kam naa haay ma, ŋn'ɩ yaa wʊrɛ a meerbaa bɩ ma. ");
INSERT INTO bib_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yeezuu n a hɩ ŋ nɩ, a ʊ: «A ka awɔɔ nawʊm ma k'a bɩr tɩrga gʊɔɔ mɩm ʊ. Bɩ Woso awɔɔ heer dɔ, bala, hɔ niŋŋə kʊ gʊɔɔ n'a lɛ bɔŋ ʊ bɩ, hɔ vəm m bɩ Woso mɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Lɛrɔ kan wosolɛsinnɩsorazannɔ wɔɔ kɩ ta an Zaan dɔmɩm ku. N y'a sɩŋŋɩda ba dɔmɩm bɩ do ʊ, n nɩ Woso cirbəə lemim nyɩnta pa dam, gʊaa haay n'a tɔŋ ʊ k'a gasʊ ʊ kan paŋŋa kɩ. ");
INSERT INTO bib_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Brama kan tara kɩ cenle naanaa an lɛ da lɛ minnyɩ deem taan… k'a nɩ gɔɔtam bɩ ra. ");
INSERT INTO bib_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Bɩ y'a ka, gʊaa biyəə k'a nɩ larɛ a lʊ ra, an n'a vanta sam bɩ, jaandər m. Bɩ gʊaa k'a lʊ k'a zim la ra bɩ sa, jaandər m sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Arzakazaa deem ɩ nyɩnta ʊ, an nɩ huu wɩsɩrɔ kʊ ŋ lɛ ŋ kʊsɩ dure a ma, an nɩ hɔbɩrɛ mɩŋŋa bɩrɛ dɔmɩm haay, an nɩ mɩsɩrbaa nyɩnta bam. ");
INSERT INTO bib_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Cicirzaa deem k'a tɔ m Lazaar bɩ nɩ wʊtam arzakazaa bɩ cɛlɛ ma, a mɛ haay bɩ, nyinno m. ");
INSERT INTO bib_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A ɩ hɔbɩrɛ kuuro kʊ ŋ n'a lom arzakazaa bɩ hɔbɩrɛ gɔ bɩ ra bɩ ŋʊam k'a bɩ, b'a bɩr a yɩrɛ y. Kan naa kɩ haay, jino bʊr ŋn'a nyinno mɩmmɛɛsʊm. ");
INSERT INTO bib_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Cicirzaa bɩ n bɩ ga. Malɛɛkarɔ n a busu ŋnɩ ta m Abraham jɩr ʊ. Arzakazaa bɩ m bɩ ga sɔ, n n a bir. ");
INSERT INTO bib_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Gəəno bɩncɛ ʊ b'ʊ bɩ, arzakazaa b'ɩ fɩr yɩm gʊta. A n a mɩm busu brama an a to an Abraham yɩ laatʊ, Lazaar n'a jɩr ʊ. ");
INSERT INTO bib_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A n zee da, a ʊ: M zɩ Abraham, mɔɔ cicir zɛ, k'ɩ Lazaar nyɔɔ k'an a nyʊkʊm nyɔɔ hi ma k'an b'a tɔkʊ m nɛɛm la, k'an bɩsa, bala, mɔɔ ɩ fɩr yɩm gʊta sɛ naa do nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham n a nyɩ bɔ nʊ, a ʊ: M nyɩnnɩ, a tɔ da ɩ nɔ ʊ, ɩ ʊ, ɩbɩɩ nyɩnta mɩŋŋa ɩ mɩsɩrbaa nɔ ʊ, Lazaar n a bʊnyaa yɩ. Naa ma bɩ, a heernyɔɔ yɩ naa ʊ, ɩbɩɩ nɩ fɩr nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bɩ, yaa gʊta y'awɔɔ kan wɔɔ kɩ bire ʊ kʊ gʊɔɔ kʊ ŋ n'a tom wɔɔ zeezi naa ʊ k'a ta awɔɔ zi rɔ wɔɔ b'a da ma, ŋnɩ cem y, awɔɔ zeezi sɔ, kʊ ŋ b'a da ma ŋnɩ bʊr naa ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Arzakazaa bɩ n a hɩ, a ʊ: M zɩ, mɔɔ y'a yɛrɛ ɩbɩɩ han, k'ɩ Lazaar nyɔɔ mɔɔ zɩ har ʊ, ");
INSERT INTO bib_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","bala, mɔɔ danzannɔ ta ʊ soor, k'an aa a hɩ ŋ nɩ, kʊ brɔɔ bɩ bʊr fɩr yɩrɛ bɩncɛ naa do ʊ sɔ y. ");
INSERT INTO bib_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham n a hɩ m, a ʊ: Ŋ yɩ Moyiisi ciro m kan wosolɛsinnɩsorazannɔ hɔɔ kɩ, ŋn'a tʊr ka ŋ lemim ma. ");
INSERT INTO bib_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Arzakazaa bɩ n a hɩ, a ʊ: Ayy…, m zɩ Abraham, kʊ gʊaa a to gəəno zi naa ʊ an ta b'ʊ, ŋ y'a bɔrɛ a taam. ");
INSERT INTO bib_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham n a hɩ, a ʊ: Kʊ ŋ n a tʊr ka Moyiisi ma kan wosolɛsinnɩsorazannɔ wɔɔ kɩ, baa kʊ gʊaa a mɩm bɔ ʊ gəəno bire ʊ, ŋ b'a sire y.» ");
INSERT INTO bib_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeezuu n a hɩ karɩndanyɩnɔ wɔɔ m, a ʊ: «Mim k'a a da ma an gʊaa do bɩ b'a dam ma, a n nyɩnta ʊ y. Bɩ, a pakra bam gʊaa k'a nɩ zɛm nɩ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kʊ n bar da jɛnlajaa ma, n n'a da a wer, n n'a da higʊta ʊ jɩra, nyɩnɔ poorero nɔɔn duro deem k'a n'a dam mim ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","K'a dundo a zi mɩŋŋa! K'ɩ danyɩ a zar ɩ ma, k'ɩ dʊndɔ, k'a a bɔ a taam, k'ɩ sugur ka ʊ. ");
INSERT INTO bib_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bɩ k'a zar ɩbɩɩ ma gallɛm saanhɩna hindeem ʊ, an tɩr a bɔ an bʊr ɩbɩɩ zi an b'a hɩ, a ʊ: Mɔɔ m bɔ m taam, sugur ka m ʊ, k'ɩ sugur ka ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kristazibəəzannɔ wɔɔ n a hɩ Zuuba m, ŋ ʊ: «Wɔɔ sɩrakarɛ da ra.» ");
INSERT INTO bib_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Zuuba n a hɩ, a ʊ: «Awɔɔ sɩrakarɛ bɩ, kʊ mutardɩ yaa a ku, awɔɔ y'a hɩm gɔ naa do m, a ʊ: Ɩ bɔɔta, ɩ yaa ɩ sɔɔn higʊta ʊ, b'a y'awɔɔ lɛ sim.» ");
INSERT INTO bib_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Gʊaa bɩ kara n'awɔɔ bire ʊ naa ʊ, a zibəənyɩ n ta ʊ, an nɩ dam wʊm, gɛɛ, an nɩ dɔm hɔbɩsɩ ma. K'a a to poo ʊ, an bʊr, an a hɩ m, a ʊ: A ba zɔɔ ɩ bʊr, ɩ nyɩnta ɩ hɔbɩrɛ bɩ? ");
INSERT INTO bib_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A hɩ bɛɛ an nawʊrɛ, a ʊ: Hɔbɩrɛ ba gum naa ʊ, k'ɩ huuro da ɩ ra, ɩ sa ɩ ba ka m ʊ kʊ m a bɩ, kʊ m a mi, k'ɩ bɔkarɛ ɩ bɩ, ɩ mi ra? ");
INSERT INTO bib_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","A yaa dam zibəənyɩ bɩ m barka ra? K'a a lɛ si an a zi bɩ ba bɩ minto ra? Mɔɔ n a si a yaa dam nɩ barka y. ");
INSERT INTO bib_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","A maam sɔ kan awɔɔ kɩ. K'awɔɔ hɔ haay kʊ Woso lɛ ka awɔɔ ʊ k'a ba bɩ ba, k'a hɩ, a ʊ: Zibəənyɩnɔ m wɔɔ m bala, wɔɔ ʊ zibəə k'a a ga m bɩ ba.» ");
INSERT INTO bib_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kʊ Yeezuu zaa sa an nɩ tam Zerizalɛm zeezi bɩ, bɔ a ʊ Galilee kan Samarii kɩ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","K'a nɩ gasʊm tara deem ʊ bɩ, kusiməro bu b'a zɛ ʊ, ŋnɩ jɩm laatʊ, ");
INSERT INTO bib_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ŋn'a leer busu, ŋ ʊ: «Yeezuu, karɩnsaamba! Wɔɔ cicir zɛ!» ");
INSERT INTO bib_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeezuu k'a ŋ yɩ bɩ, a a hɩ ŋ nɩ, a ʊ: «K'a yaa a hɩnka wosocɛmannɩbənno m.» Kʊ ŋ y'a hʊr ŋn'ɩ tam bɩ, ŋ yaa a waa zaa ra, dintim n gʊ ŋ ma. ");
INSERT INTO bib_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ŋ gʊaa deem k'a yɩ a laafɩɩ yɩ bɩ, a a wusigə an bʊr, an a leer busu, an n'a lɛ bɔm Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A n sʊnta Yeezuu taa, an a meer zuutə tara ʊ, an nɩ barka dam nɩ. Gʊaa bɩ, Samarii gʊaa m. ");
INSERT INTO bib_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yeezuu n a hɩ, a ʊ: «Gʊaa bu haay bɛɛ y'a waa dintim n gʊ ŋ ma ra? Bɩ nɛɛhʊ rɔ wɔɔ be? ");
INSERT INTO bib_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Gɔsɩ n a bɔ ŋ bire ʊ k'a b'a lɛ bɔ Woso ʊ, kʊ saana naa do bɛɛ y.» ");
INSERT INTO bib_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A n a hɩ m, a ʊ: «Wuti ɩ ta, ɩ sɩrakarɛ ɩ bʊmbɔ.» ");
INSERT INTO bib_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farizɛɛnrɔ wɔɔ n Yeezuu lar, ŋ ʊ: «Woso cirbəə bɩ zɛ an nawʊm brɔ?» A n a nyɩ bɔ ŋ nʊ, a ʊ: «Woso cirbəə bɩ bɩr zɛrɛ, an nɩ yɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","N b'a hɩrɛ, ŋ ʊ: Woso cirbəə bɩ ba n nɩ, gɛɛ, a ɩ naa ʊ y!» A n a hɩ ŋ nɩ kɛɛrɛ, a ʊ: «K'a dɩga a, Woso cirbəə bɩ y'awɔɔ bire ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A n bɔkarɛ, an a hɩ karɩndanyɩnɔ m, a ʊ: «Dɔmɩnnɔ ta ʊ ŋn'ɩ zɛm, awɔɔ n n'a ŋʊam k'a Gʊaanyɩ bɩ yɩ hindeem ʊ bala, b'awɔɔ ba yɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","N y'a hɩrɛ awɔɔ m, ŋ ʊ: A ba n nɩ, gɛɛ, a ɩ naa ʊ! A bɩ ta y, a b'a si a ta y. ");
INSERT INTO bib_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bala, Gʊaanyɩ bɩ zɛrɛ dɔmɩm bɩ, zɛ an nawʊm amba brama tɩr nyakɩ bɔ dɔjɩr ʊ an ta meer ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bɩ, a lɛɛkarɛ an fɩr yɩ gʊta, her gʊɔɔ nɔɔn n kaanm m. ");
INSERT INTO bib_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Hɔ k'a nyɩnta an ba Nowee dɔmɩm ʊ bɩ, a zɛm bɩ nyɩnta maam Gʊaanyɩ bɩ dɔmɩm ʊ: ");
INSERT INTO bib_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ŋ nyɩnta ŋn'ɩ hɔ bɩm, ŋn'ɩ hɔ mim, ŋn'ɩ lʊ sam, ŋn'ɩ zim sam an ta an dɔmɩm kʊ Nowee gasʊ ʊ kɔɔlʊʊ ʊ bɩ ku. Bɩ, Woso a ka la gʊta n ba an ŋ bɩ haay. ");
INSERT INTO bib_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Gɛɛ, am hɔ k'a nyɩnta an ba Lɔttɩ dɔmɩm ʊ bɩ hɔ bɩ m: Ŋ yɩ hɔ bɩm, ŋn'ɩ hɔ mim, ŋn'ɩ hɔ sim, ŋn'ɩ hɔ hɛɛnm, ŋn'ɩ hɔ duum, ŋn'ɩ cɛ dɔm. ");
INSERT INTO bib_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bɩ, dɔmɩm kʊ Lɔttɩ bɔ ʊ Sodɔm ʊ bɩ, Woso a ka sɛ n a to brama, an ba am la hɔ bɩ m, an ŋ zɩnzɛ haay. ");
INSERT INTO bib_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Gʊaanyɩ bɩ hɩnkarɛ hinni ʊ, a nyɩntam maam sɔ. ");
INSERT INTO bib_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Hinni bɩ do ʊ bɩ, gʊaa k'a nɩ cɛ mim ʊ a mɔdrɔ nɩ cɛ ʊ bɩ, a bɩ zer an gasʊ an ŋ gʊr y. A maam sɔ kan gʊaa k'a ta poo ʊ bɩ kɩ, a b'a bɔ an bʊr har ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","K'a Lɔttɩ lʊ bɩ mim tɔ da a nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Gʊaa k'a lɛ n taa k'a a meeyaa bʊmbɔ bɩ, a b'a yɩrɛ y. Bɩ gʊaa k'a yɛ zɛ ma mɔɔ tɔ ma bɩ, a y'a meeyaa bʊmbɔrɛ yɩm. ");
INSERT INTO bib_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A hɩ mɔɔ nawʊrɛ awɔɔ m, gum bɩ do ʊ, gʊaa hɩɩya y'a zɛm kʊ ra, ŋnɩ wʊta gargʊ deem la. N deem gaarɛ, n n deem to. ");
INSERT INTO bib_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Lannɔ y'a zɛm kʊ ra hɩɩya, ŋn'ɩ bɩr jaa lɔm. N deem gaarɛ, n n deem to.»  ");
INSERT INTO bib_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kʊ gʊaa hɩɩya ɩ hɔsɩra ʊ: N deem gaam, n nɩ deem to. ");
INSERT INTO bib_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Karɩndanyɩnɔ wɔɔ n a lar, ŋ ʊ: «Zuuba, a nyɩntam ka?» A n a nyɩ bɔ ʊ, a ʊ: «Bɩncɛ kʊ sim n nɩ nyɩntaŋ ʊ bɩ, bɩncɛ bɩ do gɔbɩrgʊrɔ n n'a som kʊ ma ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yeezuu hɔbɔkʊrɛnoom da ŋ nɩ k'a hɩnka a ʊ, a a ga m kʊ ŋ nɩ yaa da dɔmɩm haay, bɩ ŋ bɩ kɔ kan yaadarɛ bɩ kɩ y. ");
INSERT INTO bib_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A a hɩ ŋ nɩ, a ʊ: «Dʊdɔkər ɩ nyɩnta tara deem nɔ ʊ, a bɩr nyi bam Woso nɩ y, a bɩr gʊɔɔ daŋ ʊ sɔ y. ");
INSERT INTO bib_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Zoro nɩ tara bɩ do nɔ ʊ, an nɩ zɛm tee… an n'a hɩrɛ, a ʊ: Gumə ka m ʊ mim kʊ mɔɔ jɩm bɩ n ta m kan mɔɔ kɩ bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Dʊdɔkər bɩ n a gu, gallɛm hɔka. Bɩ kur bɩ, a n n'a hɩrɛ a mɩŋŋa m, a ʊ: Baa kʊ mɔɔ bɩr nyi bam Woso m, bɩ mɔɔ bɩr gʊɔɔ daŋ ʊ sɔ, ");
INSERT INTO bib_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lʊ naa do k'a bʊr an nɩ mɔɔ kɔm bɩ, mɔɔ y'a dʊdɔ bɩ karɛ, m gumə ka ʊ, k'a bɩ bʊr mɔɔ zi dɔ dɔmɩm haay, an bɩr mɔɔ kɔrɛ y.» ");
INSERT INTO bib_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Zuuba n a ya, an a hɩ, a ʊ: «K'a tʊr ka, hɔ kʊ dʊdɔkər bʊnyaa b'a hɩ bɩ ma mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bɩ, Woso b'a darɛ a gʊɔɔ k'a ŋ nyʊkɔ ʊ ŋn'ɩ zee dam zi sinuu ʊ kan a gunuu ʊ kɩ rɔ wɔɔ han ra? A maasɩrɛ bam, an bɔkarɛ an a da ŋ han ra? ");
INSERT INTO bib_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A hɩ mɔɔ nawʊrɛ awɔɔ m, a y'a darɛ ŋ han zɔɔ-zɔɔ. Bɩ kʊ Gʊaanyɩ bɩ bɩ bʊr, a zɛm bɩ sɩrakarɛ yɩ tara burə ʊ ra?» ");
INSERT INTO bib_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yeezuu hɔbɔkʊrɛnoom da gʊɔɔ kʊ ŋ n'a hɔɔn darɛ ŋ ʊ, gʊɔɔ mɩŋŋɔɔ n'a mɩ, ŋnɩ bɔkarɛ, ŋn'a muno bɔŋ ʊ rɔ wɔɔ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Gʊɔɔ hɩɩyɔɔ ɩ gasʊ Wosocɛ ʊ k'a yaa da. Gʊaa deem bɩ farizɛn m, deem bɩ yawʊrsirezaa m. ");
INSERT INTO bib_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farizɛn bɩ n jɩm brama an nɩ yaa darɛ a heer ʊ ncɩnaaʊ: Woso, mɔɔ ɩ yaa darɛ ɩbɩɩ m barka kʊ mɔɔ n bɔ kʊ ʊ kan gʊɔɔ gɔsɩnnɔ kʊ ŋ nɩ konno, mimbʊnyaabənno, jaandənno, gɛɛ yawʊrsir naa do kɩ minto. ");
INSERT INTO bib_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mɔɔ yɩ m lɛ kʊsɩm gallɛm hɩɩya dɔmɩm saanhɩna nɔ ʊ, mɔɔ hɔnyɩ haay nɔ ʊ mɔɔ y'a bu hɔ karɛ ɩbɩɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Yawʊrsir bɩ n jɩm laatʊ, a lɛ baa k'a a mɩm busu brama y, an n'a cɩ zɛrɛ k'a a heerzar hɩnka, a ʊ: Woso, mɔɔ cicir zɛ, bala, mimbʊnyaabər m mɔɔ m. ");
INSERT INTO bib_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","A hɩ mɔɔ nawʊrɛ awɔɔ m, a tɩrgabaa yɩ Woso mɩm ʊ, an a bɔ an doo, deem bɩ n a yɩ y. Bala, gʊaa k'a n'a busum bɩ, n y'a zerm tara ʊ, bɩ gʊaa k'a a mɩŋŋa zer bɩ n y'a busum.» ");
INSERT INTO bib_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Gʊɔɔ bʊr nyɩnɔ poorero m Yeezuu zi k'an a wɔ ka ŋ mim la. Karɩndanyɩnɔ wɔɔ kʊ ŋ naa yɩ bɩ, ŋ nyaa ba kan ŋ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yeezuu n a ka ŋnɩ bʊr nyɩnɔ wɔɔ m, an n'a hɩrɛ, a ʊ: «K'a nyɩnɔ wɔɔ to ŋnɩ bʊr mɔɔ zi, a b'a ta ŋ nɩ toore y, bala, gʊɔɔ kʊ ŋ bɔ kʊ ʊ kan ŋ kɩ rɔ wɔɔ y'a so Woso cirbəə b'ʊ. ");
INSERT INTO bib_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, gʊaa k'a n Woso cirbəə bɩ si am nyɩ poore hɔ bɩ m bɩ, a bɩ gasʊŋ ʊ y.» ");
INSERT INTO bib_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Cir deem Yeezuu lar, a ʊ: «Karɩnsaamba mɩŋŋa, bɔ mɔɔ n'a barɛ kʊ m mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩ?» ");
INSERT INTO bib_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeezuu n a hɩ m, a ʊ: «Bɔ m, ɩbɩɩ nɩ mɔɔ birm mɩŋŋa? Gʊaa mɩŋŋa ba ʊ kʊ Woso y'a deem bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ɩbɩɩ lɛrɔ wɔɔ dɔ ra? Ɩ bɩ jaan da y, ɩ bɩ gər zɛ y, ɩ bɩ koor ba y, ɩ bɩ ŋʊaar kasɛtɩ ka y, ɩ zɩ kan ɩ da kɩ da ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Gʊaa bɩ n a nyɩ bɔ ʊ, a ʊ: «Mɔɔ naa haay ba m nyɩbaa ma tee….» ");
INSERT INTO bib_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yeezuu k'a naa ma bɩ, a a hɩ m, a ʊ: «Hɔ deem ɩ gɔɔta ɩbɩɩ ma k'ɩ ba: Hɔ k'a n'ɩbɩɩ ʊ bɩ hɛɛ haay ɩ jinjir ŋʊazannɔ m, k'ɩ bʊr ɩ zu mɔɔ ʊ, ɩbɩɩ arzaka yɩm arzana ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kʊ gʊaa bɩ naa ma bɩ, a heer a zar, bala, a arzaka bɩ gʊta. ");
INSERT INTO bib_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yeezuu k'a a heerzarlɛ bɩ yɩ bɩ, a a hɩ, a ʊ: «Arzakazannɔ Woso cirbəə gasʊʊrɛ yɩm kɔɔkɔɔ. ");
INSERT INTO bib_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sɩra m, yoonde huuka yaa gasʊʊrɛ nyɩntam naanaa, an lɛ da arzakazaa Woso cirbəə gasʊʊrɛ m.» ");
INSERT INTO bib_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Gʊɔɔ kʊ ŋ n'a tʊr kam ma rɔ wɔɔ a hɩ, ŋ ʊ: «Ncɩnaaʊ bɩ, nka m nɩ bʊmbɔrɛ yɩrɛ?» ");
INSERT INTO bib_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Hɔ kʊ gʊaa b'a dam ma an a ba bɩ, a naanaa Woso ma.» ");
INSERT INTO bib_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pɩyɛɛr n a hɩ, a ʊ: «Dɩga, wɔɔ hɔ haay to, ʊ zu ɩbɩɩ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A n a nyɩ bɔ ŋ nʊ, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m, gʊaa k'a a har to, kan a lʊ kɩ, a danyɩnɔ kɩ, a zɩrɔ kɩ, a nyɩnɔ kɩ Woso cirbəə minto, ");
INSERT INTO bib_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a naa haay yɩm gʊta an lɛ da durnya naa do nɔ ʊ, b'a mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩm durnya k'a nɩ zɛm bɩ nɔ ʊ sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeezuu bueerehɩɩyɔɔ wɔɔ bir, an a hɩ ŋ nɩ, a ʊ: «Ba wɔɔ nɩ tam Zerizalɛm ʊ na, bɩ, hɔ haay kʊ wosolɛsinnɩsorazannɔ wɔɔ a gʊrsɩra ba Gʊaanyɩ bɩ minto bɩ kʊ yɩm. ");
INSERT INTO bib_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","N y'a nyasʊm, n n'a ka kɩfɩɩrɔ ʊ kʊ ŋ nɩ yaa wʊ ma, kʊ ŋ n'a sʊnsɔ wʊ, kʊ ŋ nɩ lihi dɩnda ma, ");
INSERT INTO bib_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kʊ ŋ n'a zɛ madɩɩrɔ m, kʊ ŋ nɩ bɔkarɛ ŋn'a zɛ gər, b'a y'a mɩm bɔŋ ʊ dɔmɩm kaakʊ hinni ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bɩ, karɩndanyɩnɔ wɔɔ n hɔsɩ jɩ ma y. Mim naa do a nyaakʊm da ŋ nɩ, ŋ n hɔ kʊ Yeezuu a hɩ bɩ jɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","K'a ta, an n'a zɔm Zeriko ma bɩ, bʊʊ deem ɩ nyɩnta zaa lezi b'ʊ, an nɩ hɔ yɩnyɛm. ");
INSERT INTO bib_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Zamaa k'a bʊr an nɩ cenim an a ma bɩ, a laaka da kʊ bɔ m gɛ. ");
INSERT INTO bib_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","N n a hɩ m, n ʊ: «Nazarɛtɩ Yeezuu nɩ cenim.» ");
INSERT INTO bib_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A n zee da, a ʊ: «*Davɩd Nyɩ, Yeezuu, m cicir zɛ!» ");
INSERT INTO bib_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Gʊɔɔ kʊ ŋ nyɩnta lɛɛ rɔ wɔɔ nɩ nyaa bam kan kɩ ŋ ʊ, an zɛ pi. A n a banka an zee da an lɛ da biisi ra, a ʊ: «Davɩd Nyɩ, mɔɔ cicir zɛ!» ");
INSERT INTO bib_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeezuu n jɩm, an lɛ ka kʊ ŋ n'a gaa, ŋn'ɩ bʊr m. K'a a zɔ bɩ, Yeezuu a lar, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Bɔ ɩbɩɩ ʊ kʊ mɔɔ n a ba ɩbɩɩ minto?» A n a nyɩ bɔ ʊ, a ʊ: «Zuuba, a ka kʊ m mɩm n a ya an lɛɛ yɩ.» ");
INSERT INTO bib_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeezuu n a hɩ m, a ʊ: «K'ɩ mɩm n a ya an lɛɛ yɩ! Ɩ sɩrakarɛ ɩ bʊmbɔ.» ");
INSERT INTO bib_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lɛɛm bɩ, a mɩm a gʊ, an nɩ lɛɛ yɩm, an zu Yeezuu jɛ ʊ, an n'a lɛ bɔm Woso ʊ. Zamaa bɩ kʊ ŋ naa yɩ bɩ, ŋn'a lɛ bɔm Woso ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeezuu gasʊ Zeriko ʊ, an nɩ kʊ bɩ zɛm la. ");
INSERT INTO bib_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Gʊaa nɩ b'ʊ a tɔ m Zasee, yawʊrsinno cir m, arzakazaa m sɔ. ");
INSERT INTO bib_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A n n'a kam Yeezuu ma k'a yɩ, kʊ nka m, k'a a dɔ. Zamaa bɩ minto, kʊ gʊaa kutiim m bɩ, a b'a dam ma, a n a yɩ y. ");
INSERT INTO bib_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A n bra si an ta lɛɛ, an aa der gɔ ra, kʊ Yeezuu bʊr an nɩ cenim b'ʊ, k'a yɩ. ");
INSERT INTO bib_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kʊ Yeezuu lee ku bɩncɛ bɩ do ʊ bɩ, a a bɔɔta an a hɩ m, a ʊ: «Zasee, a ba zɔɔ ɩ zer, bala, mɔɔ cɩnta kʊ m zer ɩbɩɩ har ʊ her.» ");
INSERT INTO bib_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zasee n zer zɔɔ-zɔɔ, an a si kan heernyɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kʊ zamaa bɩ naa yɩ bɩ, ŋn'ɩ kukur barɛ, ŋ ʊ: «Zer a ʊ mimbʊnyaabər har ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zasee n a zɔ Zuuba ma an a hɩ m, a ʊ: «Dɩga, Zuuba, mɔɔ yɩ m arzaka bɩ haay, zɛkumbir sam, m a ka cicirzannɔ ʊ, bɩ, kʊ mɔɔ mim zu ʊ gʊaa ma, mɔɔ y'a sompim nʊ gallɛm si.» ");
INSERT INTO bib_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeezuu n a hɩ, a ʊ: «Bʊmbɔrɛ gasʊ har naa do ʊ her, bala, gʊaa naa do Abraham yaŋŋa m sɔ. ");
INSERT INTO bib_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bala, Gʊaanyɩ bɩ bʊr a ʊ, an b'a ka gʊɔɔ kʊ ŋ nyaam nɔ wɔɔ ma, an ŋ bʊmbɔ.» ");
INSERT INTO bib_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kʊ ŋ gɔɔta ŋn'a tʊr kam a meerbaarɔ wɔɔ ma bɩ, Yeezuu a ya, an hɔbɔkʊrɛnoom naa do da ŋ nɩ. Bala, a a zɔ Zerizalɛm ma. Bɩ, gʊɔɔ wɔɔ ɩ dɩgam ma, ŋ ʊ, Woso cirbəə bɩ y'a hɩnkarɛ a m b'ʊ lɛɛm. ");
INSERT INTO bib_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Bɩ y'a ka Yeezuu n a hɩ, a ʊ: «Cir nyɩ deem ɩ ta kʊ laatʊ ʊ k'a yaa cirbəə bɩ, k'a bɔ a bʊr. ");
INSERT INTO bib_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A n a zibəənyɩnɔ bir bu, an busoo jir ŋ nɩ minnɩ deem-deem, an a hɩ ŋ nɩ, a ʊ: ‹K'a zi ba m, k'an ta an mɔɔ wusigəre dɔmɩm ku.› ");
INSERT INTO bib_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","B'a gʊrgazannɔ wɔɔ sɔ m, ŋnɩ gʊɔɔ nyɔɔ a jɛ ʊ kʊ ŋ n'a a hɩ cirbəə karɛzaa bɩ m, ŋ ʊ: ‹Wɔɔ lɛ baa k'an a so wɔɔ ʊ y.› ");
INSERT INTO bib_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","K'a yaa cirbəə bɩ bɩ an bʊr bɩ, a a ka ŋnɩ zibəənyɩnɔ k'a busoo jinjir ŋ nɩ rɔ wɔɔ bir a taa, k'a dɩga a kʊ bɔ zi ŋ y'a ba m gɛ. ");
INSERT INTO bib_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Lɛɛkarɛzaa bɩ n bʊr, a ʊ: ‹Zuuba, minnɩ deem k'ɩbɩɩ ka mɔɔ ʊ bɩ, minnɩ bu y'a da ra.› ");
INSERT INTO bib_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A n a hɩ m, a ʊ: ‹Zibəənyɩ mɩŋŋa n'ɩbɩɩ m, bala, ɩbɩɩ noonhubaa hɩnka hɔ poorero nɔ ʊ, mɔɔ cirbəə karɛ ɩbɩɩ ʊ, k'ɩ ɩ so tara bu ʊ.› ");
INSERT INTO bib_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","A hɩɩya hɔ bɩ n b'a hɩ, a ʊ: ‹Zuuba, ɩbɩɩ busoo bɩ nyɩ da minnɩ soor. ");
INSERT INTO bib_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","A n a hɩ bɩ m sɔ, a ʊ: Ɩ so tara soor ʊ.› ");
INSERT INTO bib_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","A vanta n bʊr, a ʊ: ‹Zuuba, ba ɩbɩɩ busoo bɩ n na, pɛɛra mɔɔ burgu ma, m a nyaakʊm da.› ");
INSERT INTO bib_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mɔɔ ɩ nyi barɛ ɩbɩɩ m, ɩbɩɩ heer kʊsɩrabaa bɩ minto. Hɔ k'ɩbɩɩ n a cɩnta bɩ ɩbɩɩ n n'a sam. Hɔ k'ɩbɩɩ n a duu bɩ, ɩbɩɩ n n'a dam. ");
INSERT INTO bib_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A n a hɩ m, a ʊ: Ɩbɩɩ mɩŋŋa meerbaa bɩ mɔɔ n n'ɩbɩɩ dʊdɔ yarm ma, zibəənyɩ bʊnyaa. ‹Ɩbɩɩ dɔ, ɩ ʊ: gʊaa kʊsɩ m mɔɔ m, mɔɔ nɩ hɔ kʊ mɔɔ n a cɩnta bɩ sam, m nɩ hɔ kʊ mɔɔ n a duu bɩ dam. ");
INSERT INTO bib_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bɔ minto, ɩbɩɩ n mɔɔ busoo bɩ cɩnta busoo cɛ ʊ y? Kʊ mɔɔ m bɔ, m bʊr kʊ m bɩ nyɔɔdʊ yɩ?› ");
INSERT INTO bib_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","A n a hɩ gʊɔɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ m, a ʊ: ‹K'a busoo bɩ yɔ m, a ka gʊaa k'an ta m bu b'ʊ.› ");
INSERT INTO bib_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ŋ n a hɩ m, ŋ ʊ: ‹Zuuba, a lɛɛ ka an a yɩ bu.› ");
INSERT INTO bib_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","A hɩ mɔɔ nawʊrɛ awɔɔ m, gʊaa biyəə k'an ta hɔ m bɩ, n y'a kaŋ ʊ, gʊaa k'a ba m bɩ, baa k'a ta m poore bɩ, n y'a yɔm nɩ. ");
INSERT INTO bib_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mɔɔ jɩnnɔ kʊ ŋ nɩ mɔɔ ŋʊa kan cirbəə kɩ rɔ wɔɔ, k'a bʊr ŋ nɩ mɔɔ taa naa ʊ, a ŋ zɩnzɛ.» ");
INSERT INTO bib_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yeezuu k'a naa hɩ bɩ, a ka ŋ lɛɛ an nɩ tam Zerizalɛm ʊ. ");
INSERT INTO bib_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","K'a ta an n'a zɔm Bɛtfazee ma kan Betanii kɩ, Oliviyee ci bɩ zeezi bɩ, a a karɩndanyɩnɔ nyɔɔ hɩɩya. ");
INSERT INTO bib_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","A n a hɩ ŋ nɩ, a ʊ: «K'a ta kʊ k'a nɩ lɛɛ naa ʊ. K'awɔɔ ta an nɩ gasʊm, awɔɔ brapoo yɩm n n'a kʊsɩ, bɩ gɔsɩ n da ʊ cɩna y. K'a hʊr a bʊr m. ");
INSERT INTO bib_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bɩ kʊ gʊaa awɔɔ lar, a ʊ: Bɔ m awɔɔ n'a hʊrlɛ? K'a hɩ m, a ʊ: Zuuba lɛ n taa.» ");
INSERT INTO bib_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Gʊɔɔ k'a ŋ nyɔɔ rɔ wɔɔ, kʊ ŋ ta bɩ, ŋ yaa hɔ haay bɩ yɩ amba Yeezuu a hɩ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kʊ ŋn'ɩ brapoo bɩ hʊrm bɩ, a zannɔ wɔɔ n a hɩ ŋ nɩ, ŋ ʊ: «Bɔ minto m, awɔɔ n'a hʊrlɛ?» ");
INSERT INTO bib_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ŋ n'a nyɩ bɔ ʊ, ŋ ʊ: «Zuuba lɛ n taa.» ");
INSERT INTO bib_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ŋ n brapoo bɩ gaa, ŋnɩ ta m Yeezuu zi, ŋn'a huuro ka ra, ŋn'a ka Yeezuu n da ʊ. ");
INSERT INTO bib_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","K'a nɩ tam bɩ, gʊɔɔ wɔɔ n'a huuro kam zaa bɩ ra. ");
INSERT INTO bib_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","K'a a zɔ Oliviyee ci bɩ zerjɩ bɩ ma bɩ, heernyɔɔ gasʊ karɩndanyɩnɔ wɔɔ ʊ, zamaa bɩ haay, ŋn'a leer busu, ŋn'a lɛ bɔm Woso ʊ hoserlo haay kʊ ŋ y'a yɩ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ŋ ʊ: «Cir k'a nɩ zɛm Zuuba Woso tɔ ma bɩ n barka yɩ. Kʊ laafɩɩ n nyɩnta arzana ʊ, kʊ lɛbɔʊrɛ n nyɩnta brama.» ");
INSERT INTO bib_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farizɛɛnrɔ gɔsɩnnɔ a hɩ Yeezuu m zamaa bɩ bire ʊ, ŋ ʊ: «Karɩnsaamba, a ka k'ɩ karɩndanyɩnɔ wɔɔ n zɛ pi.» ");
INSERT INTO bib_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A n a nyɩ bɔ ʊ, a ʊ: «A hɩ mɔɔ nawʊrɛ awɔɔ m: Kʊ ŋ zɛ pi, jaarɔ n nɩ zee dam.» ");
INSERT INTO bib_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","K'a a zɔ Zerizalɛm kʊnɔ bɩ ma, an a to an a yɩ bɩ, a nyi ka a minto. ");
INSERT INTO bib_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","A n n'a hɩrɛ, a ʊ: «Ɩbɩɩ sɔ, k'a dɔ ɩbɩɩ ʊ her, kʊ nka n nɩ laafɩɩ karɛ ɩbɩɩ ʊ! Bɩ naa ma bɩ, a a nyaakʊm da ɩbɩɩ lɛɛ, ɩbɩɩ b'ɩ dam ma, ɩ yɩ y. ");
INSERT INTO bib_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sɩra m, dɔmɩnnɔ ɩ zɛrɛ ɩbɩɩ minto, ɩbɩɩ jɩnnɔ wɔɔ tee kɩnkarɛ ɩbɩɩ pəŋŋə bɩ ma, ŋ bɩrlɛ ɩbɩɩ ma, k'a ɩbɩɩ da, ŋn'a so bɩncɛ haay ʊ. ");
INSERT INTO bib_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ŋ y'ɩbɩɩ wurgəm haay, ɩbɩɩ kan ɩ zamaa kɩ. Ŋ bɩ jaa deem taan… tore, an bɩr a mim burə ʊ y, bala, ɩbɩɩ n dɔmɩm kʊ Woso bʊr k'a b'a da ɩ han bɩ dɔ y.» ");
INSERT INTO bib_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeezuu gasʊ Wosocɛ ʊ, an nɩ lam hɔheenno wɔɔ ra. ");
INSERT INTO bib_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","A n a hɩ ŋ nɩ, a ʊ: «N y'a gʊrsɩra ba, ŋ ʊ: ‹Mɔɔ cɛ bɩ nyɩntam yaadarɛ cɛ.› B'awɔɔ, awɔɔ sa a ba konno bɩncɛ.» ");
INSERT INTO bib_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yeezuu ɩ hɔ dɩndam dɔmɩm haay Wosocɛ ʊ b'ʊ. Wosocɛmannɩbənno jɩtannɔ kan wosocikarɩnsaambɔɔ kɩ, tara cinno kɩ y'a karɛ a zɛrɛ zaa ma. ");
INSERT INTO bib_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bɩ hɔ kʊ ŋ y'a cɩnta k'a ba bɩ, ŋn'a zaa yɩ y, bala, zamaa bɩ haay y'a tʊr karɛ a meerbaa ma kan bʊraama gʊta kɩ. ");
INSERT INTO bib_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dɔmɩnnɔ wɔɔ duro ʊ hindeem ʊ, Yeezuu k'a nɩ hɔ dɩndam zamaa bɩ m Wosocɛ ʊ, an nɩ Woso lemim nyɩnta pa dam bɩ, wosocɛmannɩbənno jɩtannɔ kan wosocikarɩnsaambɔɔ kɩ, kan *gʊɔɔgusinno kɩ bʊr zi. ");
INSERT INTO bib_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ŋ n a hɩ, ŋ ʊ: «Lɛ kara ɩbɩɩ n ta m ɩ nɩ naa bam nɩ, gɛɛ, bɔ a ʊ, nka lɛ ʊ, k'ɩ hɩ wɔɔ m?» ");
INSERT INTO bib_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A n a nyɩ bɔ ʊ ŋ nʊ, a ʊ: «Mɔɔ mɩŋŋa sɔ, mɔɔ laaka darɛ awɔɔ han, k'a hɩ mɔɔ m: ");
INSERT INTO bib_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Zaan batɛm bɩ, a to a ʊ brama gɛɛ gʊɔɔ zi?» ");
INSERT INTO bib_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ŋ n'a hɔɔn dam kan kʊ kɩ, ŋ ʊ: «Kʊ wɔɔ ʊ: A to a ʊ brama, a y'a hɩrɛ, a ʊ: Bɔ minto m awɔɔ n a mim si gɛ? ");
INSERT INTO bib_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bɩ, kʊ wɔɔ ʊ: A to a ʊ gʊɔɔ zi, zamaa bɩ haay wɔɔ gʊngʊɛɛnm jaarɔ m, bala, ŋ sɩra ka, ŋ ʊ Zaan bɩ nyɩnta wosolɛsinnɩsorazaa.» ");
INSERT INTO bib_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Wɔɔ n a dɔ k'a to a ʊ ka y.» ");
INSERT INTO bib_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mɔɔ sɔ, mɔɔ b'a hɩrɛ awɔɔ m, kʊ nka ɩ lɛ ka mɔɔ ʊ, mɔɔ nɩ naa barɛ y.» ");
INSERT INTO bib_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","A n nɩ hɔbɔkʊrɛnoom naa do dam zamaa bɩ m, a ʊ: «Gʊaa ɩ dɩvɛnsɩra da ʊ, an a ka a zibənno ʊ, kʊ ŋ n'a zi ba, an ta zaa jintə ra. ");
INSERT INTO bib_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","K'a dɔmɩm a ku bɩ, a a zibəənyɩ deem nyɔɔ dɩvɛnsɩra zibənno wɔɔ zi, k'an aa a hɔ si an b'a ka a ʊ. Bɩ, dɩvɛnsɩra zibənno wɔɔ a nyasʊ ŋn'a zɛ, ŋn'a ka an doo a wɔ m tu. ");
INSERT INTO bib_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A n a ya, an a zibəənyɩ vanta nyɔɔ, ŋn'aa bɩ nyasʊ ŋn'a zɛ sɔ, ŋn'a sʊnsɔ wʊ, ŋn'a ka an doo a wɔ m tu. ");
INSERT INTO bib_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A n a ya, an a vanta nyɔɔ a kaakʊ hɔ ma, ŋnɩ bɩ zɛ, ŋnɩ yaaba da ma, ŋnɩ la ra. ");
INSERT INTO bib_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dɩvɛnsɩrazaa bɩ n a hɩ a mɩŋŋa m, a ʊ: Kʊ m a ba lɔ? Mɔɔ yɩ m nyɩ ŋʊarɛ bɩ nyɔɔm. Ŋ bɩ daŋ ʊ barɛm. ");
INSERT INTO bib_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kʊ ŋ y'a nyɩ bɩ yɩ bɩ, dɩvɛnsɩra zibənno wɔɔ n a dɩnda kan kʊ kɩ, ŋ ʊ: Naa do n nɩ zɛm b'a so ʊ. Ʊ a nyasʊ ʊ a zɛ gər k'ʊ ʊ so arzaka b'ʊ. ");
INSERT INTO bib_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ŋ n a nyasʊ, ŋnɩ bɔ m dɩvɛnsɩra ʊ b'ʊ toore ma, ŋn'a zɛ gər. Bɔ dɩvɛnsɩrazaa bɩ n n'a barɛ ŋ nɩ? ");
INSERT INTO bib_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","A zɛm bɩ bʊr, an b'a ka ŋnɩ dɩvɛnsɩra zibənno wɔɔ zɩnzɛ, an dɩvɛnsɩra bɩ ka a vantɔɔ ʊ.» Kʊ ŋ naa ma bɩ, ŋ ʊ: «Ayy…, kʊ naa bɩ ba y!» ");
INSERT INTO bib_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yeezuu n a nya ŋ lɛ an dɩga ŋ ma, an a hɩ ŋ nɩ, a ʊ: «Wosoci bɩ gʊrsɩra naa do jɩ m bɔ nɩ? Jaa kʊ cɛdonno a bɔ ʊ ŋn'a zo bɩ, bɩ y'a ba cɛ bɩ jaa wɩsɩ. ");
INSERT INTO bib_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kʊ gʊaa a do jaa bɩ do ra, hɩsɩga a zaa nawʊm. Bɩ, kʊ jaa bɩ do a da gʊaa ra, a hɔɔnsɩ an nawʊm.» ");
INSERT INTO bib_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wosocikarɩnsaambɔɔ kan wosocɛmannɩbənno jɩtannɔ kɩ y'a karɛ a nyasʊrɛ ma b'ʊ lɛɛm, bɩ ŋ yɩ nyi bam zamaa bɩ m. Ŋ y'a jɩ ma mɩŋŋa, ŋn'a dɔ ŋ ʊ, hɔbɔkʊrɛnoom naa do da a ʊ awɔɔ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ŋ nɩ nyɩnta, ŋn'ɩ dundom Yeezuu zi, ŋnɩ gʊɔɔ nyɔɔ zi, ŋnɩ tɩrgabaa ka a ra. K'a ku a nyasʊ a meerbaa nɔ ʊ, a ka tara lɛɛzannɔ ʊ kan kʊzaa bɩ kɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ŋ laaka naa do da han: «Karɩnsaamba, wɔɔ dɔ ʊ ʊ, ɩbɩɩ ɩ meer bam, ɩ nɩ hɔ dɩndam kan sɩra kɩ, ɩ bɩr nyi bam gɔsɩ nɩ y, ɩ nɩ Woso zaa hɔ dɩndam kan a sɩra kɩ. ");
INSERT INTO bib_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","A a ga m k'ʊ Rɔm cir yawʊr ka gɛɛ, a n a ga nɩ?» ");
INSERT INTO bib_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yeezuu k'a ŋ zambʊ bɩ dɔ bɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«K'a busoo ka m ʊ deem naa ʊ. Nka meer kan a tɔ kɩ nɩ busoo bɩ burə ʊ naa?» Ŋ n'a nyɩ bɔ ʊ, ŋ ʊ: «Rɔm cir hɔ m.» ");
INSERT INTO bib_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A n a hɩ ŋ nɩ, a ʊ: «K'a Rɔm cir tɔ hɔ ka ʊ, k'a hɔ kʊ Woso a so ʊ bɩ ka ʊ sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ŋ n a da ma, ŋnɩ Yeezuu nyasʊ a meerbaa nɔ ʊ zamaa bɩ lɛɛ y. A nyɩbɔʊrɛ bɩ k'a a ka ŋ n zɛ kədə bɩ, ŋ zɛ pi. ");
INSERT INTO bib_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadisɛɛnrɔ kʊ ŋ nɩ bɩsɩ kam gəəno mɩmbɔʊrɛ ma bɩ, ŋ gɔsɩnnɔ a zɔ Yeezuu ma, ŋn'a lar, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Karɩnsaamba, Moyiisi a gʊrsɩra ba wɔɔ minto, a ʊ: ‹Kʊ gʊaa ga an a gʊ a lʊ ma b'a n nyɩ yɩ kan kɩ y, k'a danyɩ n a si an nyɩnɔ yɩ kan kɩ a minto.› ");
INSERT INTO bib_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Gʊaa ɩ nyɩnta, a nyɩnɔ saanhɩna: Lɛɛkarɛzaa bɩ n lʊ sa an ga an a gʊ ma b'a n nyɩ yɩ kan kɩ y. ");
INSERT INTO bib_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A hɩɩya hɔ bɩ n lʊ bɩ si, ");
INSERT INTO bib_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","a kaakʊ hɔ bɩ maam sɔ, an ta an nyɩnɔ saanhɩna rɔ wɔɔ ku. Ŋ haay gɩnga bɩ ŋ nɩ nyɩ yɩ kan lʊ bɩ kɩ y. ");
INSERT INTO bib_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A nyarɛ ma bɩ, lʊ bɩ ga sɔ. ");
INSERT INTO bib_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bɩ, lʊ naa do, gəəno mɩmbɔʊrɛ dɔmɩm ʊ, nka hɔ m lʊ bɩ nɩ? Kʊ ŋ haay lʊ bɩ si bɩ?» ");
INSERT INTO bib_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Zamaa naa do gʊɔɔ wɔɔ ɩ lannɔ gɛɛ yaarɔ sam. ");
INSERT INTO bib_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bɩ, gʊɔɔ kʊ ŋ y'a ga mɩmbɔʊrɛ m Woso mɩm ʊ, ŋnɩ zɛm bɩ mɩsɩrbaa ba durnya k'a nɩ zɛm bɩ nɔ ʊ rɔ wɔɔ, ŋ bɩ lʊ gɛɛ yar sam b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ŋ b'a dam ma ŋnɩ ga dɔ y, bala, ŋ bɔm kʊ ʊ kan malɛɛkarɔ kɩ. Woso nyɩnɔ m, kʊ ŋ y'a mɩm bɔ ʊ gəəno bire ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moyiisi gəəno mɩmbɔʊrɛ bɩ hɩnka mɩŋŋa, bɩncɛ niŋŋə kʊ Wosoci nɩ tutugu mim dɩndaŋ ʊ b'ʊ, an nɩ Zuuba Woso birm Abraham Woso, Izakkɩ Woso, Zakɔɔb Woso. ");
INSERT INTO bib_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bɩ Woso bɩ, gəəno Woso bɛɛ y, mɩsɩɩrɔ Woso m, bala, hɔ haay mɩsɩr a minto.» ");
INSERT INTO bib_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wosocikarɩnsaambɔɔ gɔsɩnnɔ meerbaa bɩ si, ŋ ʊ: «Karɩnsaamba, ɩ meer ba mɩŋŋa.» ");
INSERT INTO bib_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ŋ bɩr yɛm dɔ k'a laaka da han mim sɩ ma y. ");
INSERT INTO bib_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Wɔɔ y'a bam lɔ, ʊ a hɩ, ʊ ʊ: ‹Krista bɩ, *Davɩd Nyɩ› nɩ? ");
INSERT INTO bib_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kʊ Davɩd mɩŋŋa n'a hɩm laarɔ ci nɔ ʊ, a ʊ: Mɔɔ Zuuba Woso a hɩ mɔɔ Zuuba m: nyɩnta mɔɔ bɩsɩ ʊ, ");
INSERT INTO bib_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","an ta an dɔmɩm kʊ mɔɔ n'ɩbɩɩ jɩnnɔ wɔɔ bam gankarahɔ, k'ɩ gam ka ŋ la bɩ ku. ");
INSERT INTO bib_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Naa y'a hɩnkarɛ a ʊ, Davɩd y'a birm ‹Zuuba›. A nyɩnnɩ m lʊnlɔ kɛɛrɛ?» ");
INSERT INTO bib_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kʊ zamaa bɩ haay n'a tʊr kam bɩ, Yeezuu a hɩ karɩndanyɩnɔ wɔɔ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«K'a dundo a zi kan wosocikarɩnsaambɔɔ kʊ ŋ nɩ bɩmbɩr zabarɔ m nɔ wɔɔ kɩ. Ŋ gʊɔɔ yaadarɛ ŋʊa daasɩrɔ bire ʊ. Ŋ lɛɛkarɛ bɩncɛrɔ ŋʊa yaadarɛcɛrɔ ʊ, ŋ lɛɛkarɛ bɩncɛrɔ ŋʊa sɔ hɔbɩrɛ bɩncɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ŋ nɩ zonno hɔ yɔrɛ ŋ nɩ, ŋn'ɩ yaa jintoo dam, kʊ ŋ n'a yɩ. N yɩ ŋ dʊdɔ yarm, ŋnɩ hʊnhʊrlɛ yɩ gʊta an lɛ da.» ");
INSERT INTO bib_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeezuu k'a a mɩm busu bɩ, a arzakazannɔ yɩ, ŋn'ɩ busoo dam ganwʊrɛ mɔr ʊ. ");
INSERT INTO bib_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A n zoro yɩ sɔ cicirzaa m, an tamma hɩɩya da ʊ. ");
INSERT INTO bib_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","A n a hɩ, a ʊ: «Sɩra mɔɔ n'a hɩrɛ awɔɔ m, zoro cicirzaa naa do a da ʊ an lɛ da ŋ nɩ haay. ");
INSERT INTO bib_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bala, nawɔnnɔ haay busoo k'an ta ŋ ʊ gʊta bɩ ŋ y'a bɔ ʊ ŋn'a da ganwʊrɛ mɔr b'ʊ, bɩ zoro bɩ busoo k'a n'a wɔ ʊ b'a ka haay.» ");
INSERT INTO bib_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Gɔsɩnnɔ kʊ ŋ nɩ Wosocɛ bɩ mim dɩndam, ŋn'a lɛ bɔrɛ a gʊɛrɛ ʊ, a jaarɔ wɔɔ mɩŋŋabaa ʊ, kan ganwʊrɛ kʊ ŋ y'a bankam bɩ kɩ bɩ, Yeezuu a hɩ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Dɔmɩm ta ʊ an nɩ zɛm, hɔ k'awɔɔ n n'a yɩm naa, jaarɔ wɔɔ bɩ gɔɔtam kʊ burə ʊ y, ŋ haay wurgəm.» ");
INSERT INTO bib_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ŋ n a lar, ŋ ʊ: «Karɩnsaamba, naa zɛm brɔ? Bɩ makra kara n nɩ naa dɔmɩm hɩnkarɛ?» ");
INSERT INTO bib_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A n a hɩ, a ʊ: «K'a dundo a zi, a b'a ka ŋnɩ braba a nɩ y, bala, gʊɔɔ gʊta zɛm b'a hɩ mɔɔ tɔ m, ŋ ʊ: Awɔɔ m Krista, gɛɛ: Dɔmɩm a ku. A bɩ zu ŋ ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","K'awɔɔ bɩ yar barɛ mim ma, tara gʊɔɔ n wuti kan a cinno kɩ, a da bɩ bɔ ʊ y. Bala, pakra m kʊ bɩ n lɛɛ ka an bʊr, b'a nyarɛ bɛɛ m bɩ lɛɛm y.» ");
INSERT INTO bib_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","A a ya, an a hɩ ŋ nɩ, a ʊ: «Tararɔ wutim kan kʊ kɩ yar m, tara cinno n wuti kan kʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tara hinkəre gʊta zɛm bɩ nyɩnta ʊ, yaaba bʊnyaarɔ kan nɔ kɩ zɛm bɩ nyɩnta ʊ bɩncɛ-bɩncɛ. Hɔɔrɔ bam ŋnɩ nyibəə gʊta da gʊɔɔ ma, kan makrarɔ gʊtɔɔ kʊ ŋ y'a to brama kɩ.» ");
INSERT INTO bib_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Bɩ, an nɩ lɛɛ kam naa haay lɛɛ bɩ, n y'awɔɔ gʊrm, n nɩ fɩr ka awɔɔ ma, n y'a karɛ, n n'awɔɔ dʊdɔ ka sokʊmacɛrɔ ʊ, n n'awɔɔ du lɔnnɔcɛ ʊ, n tarɛ awɔɔ m cinno kan lɛɛzannɔ kɩ taa mɔɔ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bɩ n nɩ nyɩntarɛ awɔɔ kasɛtɩ karɛ dɔmɩm mɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bɩ, a bɩ lɛɛ ka a a hɔɔn da minno nɔɔn duro nyɩbɔʊrɛ ma y. ");
INSERT INTO bib_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bala, mɔɔ meerbaa dɔrɛ kan hɔɔn kɩ karɛ awɔɔ ʊ, b'awɔɔ jɩnnɔ wɔɔ gʊaa deem b'a dam ma an awɔɔ meerbaa nyɩ bɔ ʊ, gɛɛ, an bɩsɩ ka ma y. ");
INSERT INTO bib_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Awɔɔ mɩŋŋɔɔ zɩrɔ kan a dɔɔ kɩ, awɔɔ danyɩnɔ kɩ, awɔɔ dogʊɔɔ kɩ, awɔɔ gʊaasɩbɔɔ kɩ, n n'awɔɔ nyasʊrɛ, bɩ, ŋ y'awɔɔ gɔsɩnnɔ zɩnzɛm. ");
INSERT INTO bib_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Gʊaa haay sɔrɛ awɔɔ m mɔɔ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bɩ, awɔɔ minkə deem taan… bɩ nyaanɩm awɔɔ mim ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Awɔɔ tʊntɔʊrɛ n nɩ mɩsɩrbaa karɛ awɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«K'awɔɔ bɩ Zerizalɛm yɩ yarbənno n bɩr ma, k'a dɔ a ʊ, a wurgəre dɔmɩm a zɔ. ");
INSERT INTO bib_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kʊ gʊɔɔ kʊ ŋ nɩ Zidee ʊ rɔ wɔɔ n a si, ŋnɩ ta ciro ʊ, gʊɔɔ kʊ ŋ nɩ tara nɔ ʊ rɔ wɔɔ n bɔ, gʊɔɔ kʊ ŋ nɩ bɔlɛɛmarɔ ʊ rɔ wɔɔ, ŋ bɩ gasʊ tara nɔ ʊ y! ");
INSERT INTO bib_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Woso heerbusu dɔmɩm m dɔmɩnnɔ wɔɔ duro m, bɩ hɔ haay kʊ n y'a gʊrsɩra ba Wosoci ʊ bɩ n nɩ kʊ yɩŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","A pakra bam lannɔ jɩsɩzannɔ kan lannɔ kʊ ŋ nɩ nyɔ karɛ a nyɩnɔ ʊ rɔ wɔɔ kɩ m dɔmɩnnɔ wɔɔ duro ʊ, bala, cicir gʊta y'a dam tara bɩ ra kan heerbusu gʊta kɩ zamaa bɩ minto. ");
INSERT INTO bib_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","N gʊɔɔ gʊta zɩnzɛm kargʊrɔ m, ŋ gɔsɩnnɔ gʊrm lɔmbaa nɔ ʊ do haay bire ʊ, do vantɔɔ tʊntɔm Zerizalɛm la an ta an do vantɔɔ wɔɔ dɔmɩm bɩ nyarɛ ku.» ");
INSERT INTO bib_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Makrarɔ nyɩntaŋ ʊ woso kan mom kɩ monyaarɔ kɩ nɔ ʊ. Tara burə ʊ, do haay gʊɔɔ nyɩntam kɔrɛ nɔ ʊ, ŋ b'a banjɩ dɔrɛ y, higʊta paŋŋa kan a kurəro tatʊr kɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Gʊɔɔ n'a mom, hoonsi n ta ŋ lɛ hɔ k'a nɩ zɛm tara burə ʊ bɩ hɔɔndarɛ nɔ ʊ. Bala, n brama paŋŋazannɔ hinkəm. ");
INSERT INTO bib_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bɩ kur bɩ, ŋ Gʊaanyɩ bɩ yɩrɛ an bɩr zɛm warkʊ nɔ ʊ kan paŋŋa gʊta kɩ, cirbəə kɩ.» ");
INSERT INTO bib_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","«Kʊ minno nɔɔn duro haay bʊr ŋn'ɩ barɛ, k'a a bɔɔta a dɩga brama, awɔɔ bʊmbɔrɛ a zɔ.» ");
INSERT INTO bib_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","A n hɔbɔkʊrɛnoom da ŋ nɩ, a ʊ: «K'a dɩga sɔɔn kan gɔrɔ haay kɩ ma. ");
INSERT INTO bib_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","K'awɔɔ yɩ ŋn'ɩ lɛɛ daa darɛ, awɔɔ dɔ mɩŋŋa a ʊ, siire a zɔ. ");
INSERT INTO bib_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","A maam sɔ kan awɔɔ kɩ. K'awɔɔ bɩ naa yɩ an nɩ zɛrɛ, k'a dɔ a ʊ: Woso cirbəə b'a zɔ. ");
INSERT INTO bib_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sɩra mɔɔ n'a hɩrɛ awɔɔ m, zamaana naa do bɩ cenim kʊ nawɔnnɔ haay bɛɛ ba y. ");
INSERT INTO bib_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Brama kan tara kɩ cenim, bɩ mɔɔ meerbaa bɩ bɩ cenle y.» ");
INSERT INTO bib_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«K'a dundo a zi, a b'a heer gore da ʊ kan bɛɛ mire waasɩ kɩ, hɔ bɩ gʊta kɩ, kan durnya minno hɔɔndarɛrɔ kɩ y, kʊ dɔmɩm naa do bɩ daata zɛ awɔɔ ra y, ");
INSERT INTO bib_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","amba zaŋŋa hɔ bɩ nɩ y. Bala, a y'a kum gʊaa haay k'a nɩ tara burə ʊ ra. ");
INSERT INTO bib_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","A b'a zuu ʊ y, k'a yaa da dɔmɩm haay, k'a a da ma, a bɔ lɛm hɔ haay k'a nɩ zɛm bɩ ma, k'a jɩm brama, Gʊaanyɩ bɩ lɛɛ.» ");
INSERT INTO bib_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Dɔmɩm haay Yeezuu tɩr ta an aa hɔ dɩnda Zerizalɛm Wosocɛ ʊ. Bɩ, yirbəə haay a tɩr bɔ, an ta ci kʊ n n'a birm Oliviyee ci bɩ ra, dɔ n tɩr mɩ m b'ʊ. ");
INSERT INTO bib_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bɩ wutigʊta nɩ, zamaa bɩ tɩr ta zi Wosocɛ ʊ b'ʊ, ŋn'aa a tʊr ka ma. ");
INSERT INTO bib_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bur kʊ n n nyʊnyɔɔ da ma *cibsa kʊ n a birm pakkɩ bɩ y'a zɔm. ");
INSERT INTO bib_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wosocɛmannɩbənno jɩtannɔ kan wosocikarɩnsaambɔɔ kɩ y'a kam zaa k'a n'a sam k'a a ku a zɛ bɩ ma. Bala, ŋ yɩ nyi bam gʊɔɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bɩ, Sʊtaana gasʊ karɩndanyɩnɔ bueerehɩɩyɔɔ wɔɔ gʊaa deem heer ʊ. Zidas m, gʊaa kʊ n n'a birm Iskarɩyɔtɩ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","A n ta, an aa a dɩnda kan wosocɛmannɩbənno jɩtannɔ wɔɔ kɩ, kan Wosocɛ dɔmazannɔ cinno wɔɔ kɩ, hɔ k'a n'a bam k'a Yeezuu nyasʊ a ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bɩ ŋ heer nyɔɔ gʊta ŋn'a dɩnda kan kʊ kɩ, ŋ ʊ: k'a busoo ka ʊ. ");
INSERT INTO bib_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Bɩ, Zidas yɛ sɔ, an n'a kam dɔmɩm k'a n'a dam ma, an Yeezuu nyasʊ a ka ŋ ʊ bɩ ma, kʊ zamaa bɩ b'a dɔ y. ");
INSERT INTO bib_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bur kʊ n n nyʊnyɔɔ da ma cibsa, n nɩ pakkɩ sinnyɛɛm mannɩ bam ma bɩ dɔmɩm a zɔ. ");
INSERT INTO bib_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yeezuu n Pɩyɛɛr nyɔɔ kan Zaan kɩ an a hɩ ŋ nɩ, a ʊ: «K'a ta, a yaa pakkɩ cibsa hɔbɩrɛ bɩ banka k'ʊ b'a bɩ.» ");
INSERT INTO bib_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ŋ n a lar, ŋ ʊ: «Ɩbɩɩ lɛ n taa k'ʊ aa hɔbɩrɛ bɩ banka ka?» ");
INSERT INTO bib_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A n a nyɩ bɔ ŋ n'ʊ, a ʊ: «K'a dɩga a, k'awɔɔ gasʊ tara nɔ ʊ b'ʊ, awɔɔ gʊaayar deem zɛŋ ʊ, an gər busu kan hi kɩ, k'a zu kʊ ʊ kan kɩ, a gasʊ har k'a nɩ gasʊŋ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","K'a hɩ har bɩ zaa m, a ʊ: Karɩnsaamba y'ɩbɩɩ larm: saanɔɔcɛ ɩ ka, kʊ m bɩ pakkɩ hɔbɩrɛ bɩ kan m karɩndanyɩnɔ wɔɔ kɩ? ");
INSERT INTO bib_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A cɛ gʊta hɩnkarɛ awɔɔ m mim ʊ, n nɩ mɔrlɔ wɔɔ banka haay, bɩncɛ bɩ do ʊ, awɔɔ n nɩ pakkɩ hɔbɩrɛ bɩ bankaŋ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ŋ n ta, ŋn'a hɔ haay k'a a hɩ bɩ yɩ, ŋnɩ pakkɩ hɔbɩrɛ bɩ ba. ");
INSERT INTO bib_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wakatɩ bɩ k'a a ku bɩ, Yeezuu yaa nyɩnta kan a zibəəzannɔ wɔɔ kɩ, k'a hɔbɩrɛ bɩ bɩ. ");
INSERT INTO bib_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A n a hɩ ŋ nɩ, a ʊ: «Mɔɔ ŋʊa gʊta kʊ m pakkɩ hɔbɩrɛ naa do bɩ kan awɔɔ kɩ, kʊ m bɔkarɛ m fɩr yɩ. ");
INSERT INTO bib_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bala, mɔɔ y'a hɩrɛ awɔɔ m: mɔɔ bɩ m yarɛ m hɔbɩrɛ naa do bɩ fɩɩga y, k'a mim m tolle ba an kʊ yɩ Woso cirbəə nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A n hɔmire sa, an yaa da Woso m barka, an a hɩ ŋ nɩ, a ʊ: «K'a si a a mi kan kʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bala, mɔɔ y'a hɩrɛ awɔɔ m: a nya her mɔɔ bɩ m yarɛ m dɩvɛn mi dʊntɔ y, an ta an Woso cirbəə bɩ zɛrɛ dɔmɩm ku.» ");
INSERT INTO bib_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A n bɔkarɛ an bur sa, k'a yaa da Woso m barka an a nya bɩ, a a zɩnzɛ ra an a ka ŋ ʊ, an n'a hɩrɛ, a ʊ: «Mɔɔ mɛ m naa, mɔɔ n a ka awɔɔ minto. K'a naa ba mɔɔ tɔdaanɔʊ minto.» ");
INSERT INTO bib_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hɔbɩrɛ bɩ kur bɩ, a hɔmihɔ sa an a ba maam sɔ, an a hɩ ŋ nɩ, a ʊ: «Hɔmire naa do gʊaasɩbabaa daa hɔmire m. Mɔɔ ma m, an a lo awɔɔ minto.» ");
INSERT INTO bib_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«K'a tʊr ka, gʊaa k'a nɩ mɔɔ nyasʊm k'a mɔɔ ka bɩ, a ɩ hɔbɩrɛ bɩncɛ ʊ naa ʊ kan mɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sɩra m, Gʊaanyɩ bɩ zɛm bɩ ga, amba Woso lɛɛ ka an a hɩ bɩ m. Bɩ, kʊsɩ ɩ kan gʊaa k'a nɩ mɔɔ nyasʊm k'a mɔɔ ka bɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bɩ, karɩndanyɩnɔ wɔɔ a sɩŋŋɩda sa ŋn'ɩ kʊ larm: «Wɔɔ bireyaa ʊ naa ʊ, nka n nɩ mim naa do barɛ?» ");
INSERT INTO bib_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ŋ wuti bɩsɩkarɛ vanta m kan kʊ kɩ, k'a a dɔ nka m jɩtaarɛ gɛ. ");
INSERT INTO bib_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Do vantɔɔ cinno ɩ cirbəə bɩm ŋn'a so a tarazannɔ ʊ, bɩ cinno wɔɔ y'a kam gʊɔɔ kʊ ŋ y'a so ŋ ʊ rɔ wɔɔ nɩ ŋ birm: mimmɩŋŋabənno. ");
INSERT INTO bib_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","B'awɔɔ kan kʊ kɩ, a b'a ba maam y. Bɔ n jɩtaarɛ awɔɔ bireyaa ʊ bɩ, k'an a ba awɔɔ dam poore. Bɔ y'a so awɔɔ ʊ bɩ, k'an a ba awɔɔ zibəənyɩ. ");
INSERT INTO bib_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nka m jɩtaarɛ paan…? Bɔ ɩ nyɩnta an nɩ hɔbɩrɛ bɩm bɩ m gɛɛ, bɔ ɩ hɔbɩrɛ sa an n'a kam bɩ nɩ? Mɔɔ ʊ: bɔ ɩ nyɩnta an nɩ hɔbɩrɛ bɩm bɩ m. Bɩ, mɔɔ y'awɔɔ bireyaa ʊ am zibəənyɩ hɔ bɩ m.» ");
INSERT INTO bib_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Awɔɔ, awɔɔ gɔɔta kan mɔɔ kɩ dɔmɩm haay m cicir nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bɩ y'a ka mɔɔ nɩ cirbəə bɩncɛ bankam awɔɔ minto, amba mɔɔ Zɩ a banka mɔɔ minto bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","K'a a da ma, a b'a zɛ kʊ ra kan mɔɔ kɩ a hɔ bɩ, a hɔ mi mɔɔ cirbəə bɩ nɔ ʊ. K'a a da ma sɔ a nyɩnta cirbəəduuro ra, a Israyɛl do bueerehɩɩyɔɔ wɔɔ dʊdɔ yar. ");
INSERT INTO bib_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Bɩ, Zuuba a hɩ, a ʊ: «Sɩmɔɔn, Sɩmɔɔn, Sʊtaana a yɛ k'awɔɔ daŋŋa am hɔyaa hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bɩ mɔɔ yaa da ɩbɩɩ minto k'ɩbɩɩ sɩrakarɛ b'a da jɩm ʊ y. Bɩ k'ɩbɩɩ ɩ bɔ ɩ bʊr mɔɔ zi, k'ɩ danyɩnɔ heer ba kookoo.» ");
INSERT INTO bib_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pɩyɛɛr n a nyɩ bɔ ʊ, a ʊ: «Zuuba, mɔɔ yɛ kʊ m ta kan ɩbɩɩ kɩ lɔnnɔcɛ ʊ. Baa kʊ zɛ m sɔ, mɔɔ yɛrɛ m ga kan ɩbɩɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Bɩ Yeezuu a hɩ, a ʊ: «Pɩyɛɛr, mɔɔ y'a hɩrɛ ɩbɩɩ m, ɩbɩɩ bɩsɩ kam gum naa ʊ, ɩ ʊ: ɩbɩɩ n mɔɔ dɔ y, gallɛm kaakʊ, koo n bɔkarɛ an baa da.» ");
INSERT INTO bib_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","A n a hɩ ŋ nɩ, a ʊ: «Kʊ mɔɔ awɔɔ nyɔɔ, awɔɔ n busoohɛra sa y kan bɔɔn kɩ, kʊsɔrɔ kɩ bɩ, bɔ ɩ kʊrɔ awɔɔ ʊ?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Hɔsɩ.» ");
INSERT INTO bib_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A n a hɩ ŋ nɩ, a ʊ: «Naa ma kɛɛrɛ bɩ, gʊaa k'a nɩ busoohɛra m bɩ, k'an a sa; Gʊaa k'a nɩ bɔɔn m bɩ, k'an a sa sɔ. Gʊaa k'a ba kargʊ m bɩ, k'an a huu hɛɛ an a si m. ");
INSERT INTO bib_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bala, mɔɔ y'a hɩrɛ awɔɔ m: mim niŋŋə kʊ n y'a gʊrsɩra ba Wosoci nɔ ʊ mɔɔ minto bɩ kʊ yɩm: ‹N y'a lɛ sa n a da mimbʊnyaabənno barla.› Bɩ sɩra m, hɔ niŋŋə kʊ n y'a gʊrsɩra ba mɔɔ minto bɩ kʊ yɩm.» ");
INSERT INTO bib_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ŋ n a hɩ, ŋ ʊ: «Zuuba, kargʊrɔ hɩɩyɔɔ ba n na.» A n a nyɩ bɔ ŋ nʊ, a ʊ: «A bʊrbɔ.» ");
INSERT INTO bib_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yeezuu bɔ an ta Oliviyee ci mim ʊ, amba a tɩr a bam bɩ m. A karɩndanyɩnɔ wɔɔ n zu kʊ ʊ kan kɩ. ");
INSERT INTO bib_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","K'a lee ku bɩncɛ b'ʊ bɩ, a a hɩ ŋ nɩ, a ʊ: «K'a yaa da, a yaa n a do makra nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","A n a jɛ bɔ ŋ ma, an ta lɛɛ poore, an a kukurə zɛ, an nɩ yaa darɛ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«M Zɩ, k'ɩ lɛ taa k'ɩ fɩr naa do gʊ mɔɔ ma, kan bɩ kɩ haay ɩ bɩ mɔɔ hɔɔnhɔ ba y, ɩ hɔ ba!»  ");
INSERT INTO bib_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bɩ ma bɩ, malɛɛka y'a to arzana ʊ, an b'a hɩnka m, an a paŋŋa da ra. ");
INSERT INTO bib_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yeezuu nɩ zoo kaŋŋɩda bam a heer ʊ, an n'a tʊntɔŋ ʊ kan yaadarɛ kɩ, a lɛɛmaa n'a ba am macina hɔ bɩ m, an nɩ surm tara ʊ. ");
INSERT INTO bib_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","K'a yaa bɩ da bɩ, a wuti, an bʊr a karɩndanyɩnɔ wɔɔ zi, an bɩ dɩga a ŋ hinceem ba heerzarlɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A n ŋ lar, a ʊ: «Bɔ minto m, awɔɔ nɩ hinceem barɛ? K'a wuti, a yaa da k'a b'a do makra nɔ ʊ y!» ");
INSERT INTO bib_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kʊ Yeezuu gɔɔta an nɩ meer bam bɩ, gʊaa cir gʊta bʊr. Iskarɩyɔtɩ Zidas bɩ, karɩndanyɩnɔ bueerehɩɩyɔɔ wɔɔ gʊaa deem b'ɩ nyɩnta gʊaa cir gʊta bɩ lɛɛ, an a zɔ Yeezuu ma k'a yaa da m. ");
INSERT INTO bib_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yeezuu n a hɩ m, a ʊ: «Zidas, yaa ɩ n'a dam Gʊaanyɩ bɩ m kan daʊrɛ kɩ, k'ɩ zambʊ ba ma gɛ?» ");
INSERT INTO bib_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bɔɔ ɩ nyɩnta kan Yeezuu kɩ rɔ wɔɔ kʊ ŋ hɔ k'a n'a bam k'a nyɩnta ʊ bɩ yɩ bɩ, ŋ y'a lar, ŋ ʊ: «Zuuba, ʊ ŋ zɛ kargʊ m gɛ?» ");
INSERT INTO bib_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bɩ ŋ gʊaa deem wosocɛmannɩbər jɩtaarɛ zibəənyɩ sakʊ an a bɩsɩ tʊr gʊ ma. ");
INSERT INTO bib_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bɩ Yeezuu a hɩ ŋ nɩ, a ʊ: «K'a to maam.» A n bɔkarɛ an a wɔ da gʊaa bɩ tʊr bɩ ma, an a waa. ");
INSERT INTO bib_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yeezuu n a bɔ, an a hɩ wosocɛmannɩbənno jɩtannɔ wɔɔ m, kan Wosocɛ dɔmazannɔ cinno kɩ, kan gʊɔɔgusinno kʊ ŋ bʊr k'a b'a nyasʊ rɔ wɔɔ kɩ m, a ʊ: «Awɔɔ bʊr kan kargʊrɔ kɩ, bannɔ kɩ, ɩ ʊ, ta awɔɔ nawʊm koor nyasʊ jɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bɩ mɔɔ nyɩnta kan awɔɔ kɩ dɔmɩm haay Wosocɛ ʊ, b'awɔɔ n a wɔ da mɔɔ ma y. Naa ma bɩ, awɔɔ wakatɩ m kan monsigə cir bɩ hɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kʊ ŋ Yeezuu nyasʊ bɩ, ŋ y'a gaa, ŋnɩ ta m wosocɛmannɩbər jɩtaarɛ bɩ har ʊ. Pɩyɛɛr n zu a jɛ ʊ laatʊ, an ta. ");
INSERT INTO bib_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","N nɩ sɛ hɛ hallu bireyaa ʊ, ŋnɩ nyɩnta b'ʊ. Pɩyɛɛr n ta, an aa nyɩnta ŋ bireyaa ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Zibəənyɩlʊ k'a a yɩ an nɩ nyɩntam sɛ bɩ lɛ ma b'ʊ bɩ, a dɩga a sɩɩ…, a ʊ: «Gʊaa naa do nyɩnta kan kɩ sɔ!» ");
INSERT INTO bib_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bɩ Pɩyɛɛr bɩsɩ ka, a ʊ: «Lʊ, mɔɔ n a dɔ y.» ");
INSERT INTO bib_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","K'a yɩ poore bɩ, gʊaa vanta n a yɩ, an a hɩ, a ʊ: «ɩbɩɩ sɔ, ŋ gʊaa deem n'ɩbɩɩ m!» Pɩyɛɛr n a nyɩ bɔ gʊaa bɩ nʊ, a ʊ: «Ayy…, ŋ gʊaa deem bɛɛ n mɔɔ nɩ y!» ");
INSERT INTO bib_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","K'a maasɩrɛ ba an wakatɩ deem ku bɩ, gʊaa vanta a ya, an a hɩ, an so ra, a ʊ: «Sɩra m, gʊaa naa do nyɩnta kan kɩ! Galilee gʊaa m.» ");
INSERT INTO bib_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pɩyɛɛr n a nyɩ bɔ ʊ, a ʊ: «Gʊaa, mɔɔ n a dɔ kʊ bɔ ɩbɩɩ ʊ k'ɩ hɩ y!» Lɛɛm bɩ, k'a gɔɔta an nɩ meer bam bɩ, koo n baa da. ");
INSERT INTO bib_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Zuuba n a bɔ, an dɩga Pɩyɛɛr ma. Pɩyɛɛr n mim niŋŋə kʊ Zuuba a hɩ m bɩ tɔ da a nɔ ʊ: ɩbɩɩ bɩsɩ kam mɔɔ ma her gallɛm kaakʊ, ɩ ʊ: ɩbɩɩ n mɔɔ dɔ y, koo n bɔkarɛ an baa da. ");
INSERT INTO bib_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","A n bɔ garga ra, an nyi ka kan heerzarlɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Gʊɔɔ kʊ ŋ nɩ dɔm Yeezuu ma rɔ wɔɔ ɩ yaa wʊm ma, ŋn'a zɛm. ");
INSERT INTO bib_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ŋ n pɛɛra sa, ŋn'a ku a meer la, ŋn'a lar, ŋ ʊ: «Wosolɛsinnɩsorazaa n'ɩ mɩ. Nka y'ɩbɩɩ zɛ, a hɩ?» ");
INSERT INTO bib_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ŋ n bɔkarɛ ŋnɩ sʊnsɔ do haay wʊ Yeezuu ma. ");
INSERT INTO bib_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Woso k'a haan bɩ, tara bɩ jɩtannɔ kan wosocɛmannɩbənno kɩ, wosocikarɩnsaambɔɔ kɩ a so kʊ ma, ŋnɩ Yeezuu gaa, ŋnɩ bʊr m a dʊdɔkarɛ bɩncɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ŋ n a hɩ m, ŋ ʊ: «Kʊ Krista n'ɩbɩɩ m, k'ɩ hɩ ʊ m!» A n a nyɩ bɔ ŋ nʊ, a ʊ: «Kʊ mɔɔ hɩ awɔɔ m, awɔɔ b'a sim mɔɔ nɩ y. ");
INSERT INTO bib_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Bɩ, kʊ mɔɔ laaka da awɔɔ han sɔ, awɔɔ b'a nyɩ bɔm mɔɔ nʊ y. ");
INSERT INTO bib_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bɩ, naa ma kɛɛrɛ bɩ, Gʊaanyɩ bɩ y'aa nyɩnta Woso paŋŋazaa bɩsɩ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ŋ haay n a hɩ, ŋ ʊ: «Bɩ minto bɩ, Woso Nyɩ n'ɩbɩɩ m na?» A n a nyɩ bɔ ŋ nʊ, a ʊ: «Awɔɔ hɩ, a m mɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bɩ, ŋ haay a hɩ, ŋ ʊ: «Kasɛtɩzannɔ zibəə ta wɔɔ ma ra! Wɔɔ mɩŋŋɔɔ a lɛ mim bɩ ma.» ");
INSERT INTO bib_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bɩ sokʊma zannɔ wɔɔ wuti, ŋnɩ Yeezuu gaa, ŋnɩ ta m *Pɩlatɩ taa. ");
INSERT INTO bib_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ŋ nɩ bɔkarɛ, ŋn'a sɩŋŋɩda sa, ŋnɩ mim ka ra, ŋ ʊ: «Wɔɔ sʊr gʊaa naa do ra, an nɩ wɔɔ tara gʊɔɔ nyʊnnyɔɔrɛ, an n'a tarɛ ŋ nɩ tolle, a ʊ: ŋ bɩ Rɔm cir yawʊr ka y. A n a ya, an n'a hɩrɛ, a ʊ: Awɔɔ m Krista, cir n'awɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pɩlatɩ n a lar, a ʊ: «Zɩɩfʊrɔ cir n'ɩbɩɩ m nɩ?» Yeezuu n a hɩ, a ʊ: «Ɩbɩɩ mɩŋŋa y'a hɩ.» ");
INSERT INTO bib_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pɩlatɩ n a hɩ wosocɛmannɩbənno jɩtannɔ wɔɔ m kan zamaa bɩ kɩ, a ʊ: «Mɔɔ n gʊaa naa do kʊrɔma yɩ y.» ");
INSERT INTO bib_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bɩ, ŋ so ra, ŋ n'a hɩ, ŋ ʊ: «A mɩŋŋa nɩ gʊɔɔ wɔɔ nyʊnnyɔɔrɛ a hɔdɩndarɛ nɔ ʊ. A sɩŋŋɩda a sa Galilee ʊ, an bɔ Zidee ʊ, an bɔkarɛ an lee ku naa ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pɩlatɩ k'a naa ma bɩ, a laaka da, a ʊ: «Gʊaa bɩ Galilee gʊaa m gɛ?» ");
INSERT INTO bib_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","K'a a dɔ a ʊ, *Hɩrɔɔdɩ gʊrga gʊaa m bɩ, a a nyɔɔ Hɩrɔɔdɩ zi. Bɩ nyɩnta Zerizalɛm ʊ dɔmɩm bɩ do ʊ. ");
INSERT INTO bib_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hɩrɔɔdɩ k'a Yeezuu yɩ bɩ, a heer nyɔɔ gʊta, bala, a a ŋʊa k'a yɩ a dɔmɩm laatʊ. Bala, a a mim ma, an n'a hɔɔn dam k'an hoser ba k'a yɩ. ");
INSERT INTO bib_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","A hɔ gʊta laaka da han, bɩ Yeezuu n a nyɩ bɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wosocɛmannɩbənno jɩtannɔ kan wosocikarɩnsaambɔɔ wɔɔ kɩ nyɩnta b'ʊ, ŋnɩ ŋʊaar ba, ŋn'a karɛ a lɛ m kan a paŋŋa jire kɩ. ");
INSERT INTO bib_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bɩ, Hɩrɔɔdɩ a zɛ kʊ ra kan a dɔmazannɔ wɔɔ kɩ, ŋnɩ Yeezuu zɛ, ŋnɩ yaa wʊ ma, ŋnɩ cicir ka ma, ŋnɩ cinno huu du ma. Hɩrɔɔdɩ n a ka, ŋn'a wusigəm ŋnɩ ta m Pɩlatɩ zi. ");
INSERT INTO bib_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hinni bɩ do ʊ bɩ, Pɩlatɩ kan Hɩrɔɔdɩ kɩ kʊ ŋ nyɩnta kʊ jɩnnɔ wɔɔ, ŋ gʊaasɩbabaa da kʊ ma. ");
INSERT INTO bib_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bɩ kur bɩ, Pɩlatɩ wosocɛmannɩbənno jɩtannɔ wɔɔ bir, kan cinno vantɔɔ wɔɔ kɩ, gʊɔɔ wɔɔ kɩ, ");
INSERT INTO bib_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","an a hɩ ŋ nɩ, a ʊ: «Awɔɔ gʊaa naa do gaa a b'a ka mɔɔ ʊ, a ʊ: gʊɔɔ an nɩ ŋ nyʊnnyɔɔm. Bɩ mɔɔ lar awɔɔ taa naa ʊ, bɩ mɔɔ n hɔsɩ yɩ, an a ba, an bʊnyaa amba awɔɔ hɩ bɩ nɩ y. ");
INSERT INTO bib_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hɩrɔɔdɩ n hɔsɩ yɩ sɔ y, an a wusigə mɔɔ zi. Gʊaa bɩ n hɔsɩ ba an a ga zɛ nɩ y. ");
INSERT INTO bib_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Bɩ k'a yɩ ncɩnaaʊ, mɔɔ y'a kam ŋn'a hʊnhʊr mɩŋŋa, m bɔkarɛ, m a to.»  ");
INSERT INTO bib_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pakkɩ cibsa haay, pakra m kʊ Pɩlatɩ n ŋ hɔɔnhɔ lɔ deem bɔ an a ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bɩ y'a ka, gʊɔɔ wɔɔ n a zɛ kʊ ra haay, ŋn'ɩ zee dam: «K'a gʊaa naa do zɛ, k'a Barabas bɔ a ka wɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas bɩ nyasʊ ŋ y'a ʊ, ŋn'a du lɔnnɔcɛ ʊ, nyaa k'a zɛ an a da tara nɔ ʊ, an gər zɛ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pɩlatɩ n a ya, an meer ba kan gʊɔɔ wɔɔ kɩ k'a Yeezuu to. ");
INSERT INTO bib_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ŋ haay n zee da, ŋ ʊ: «K'a wɔ gɔdarkʊra ma! K'a wɔ gɔdarkʊra ma!» ");
INSERT INTO bib_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pɩlatɩ a ya, an ŋ lar a gallɛm kaakʊ hɔ ma, a ʊ: «Bɔ a ba an bʊnyaa? Kʊ mɔɔ m, mɔɔ n hɔsɩ yɩ an a ba, an a ga zɛ nɩ y. K'a maam nɩ, mɔɔ y'a kam, ŋn'a hʊnhʊr, m bɔkarɛ m a to.» ");
INSERT INTO bib_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ŋ n a gu, ŋn'a hɩ ŋn'ɩ som la kan zee kɩ, ŋ ʊ: «K'a wɔ gɔdarkʊra ma!» Gʊɔɔ wɔɔ haay kʊ ŋ bʊgʊr bɩ n maam-maam bɩ, ŋ bʊr Pɩlatɩ la. ");
INSERT INTO bib_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pɩlatɩ n dʊdɔ bɩ yar amba ŋ lɛ n taa bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bɩ, a gʊaa niŋŋə k'a yar ba, an gər zɛ, ŋn'a nyasʊ, ŋn'a du bɩ to, amba ŋ y'a yɛ bɩ m. A n bɔkarɛ an Yeezuu to yarbənno m, kʊ ŋ n'a hɔɔnmim ba m. ");
INSERT INTO bib_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kʊ yarbənno wɔɔ Yeezuu nyasʊ, ŋn'ɩ tam nɩ bɩ, ŋ Sirɛnnɩ gʊaa deem kʊ n n'a birm Sɩmɔɔn bɩ zɛ ʊ, an a to poo ʊ an nɩ zɛm, ŋn'a nyasʊ, ŋn'a da gɔdarkʊra bɩ busure ʊ k'an zu Yeezuu jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Zamaa gʊta zu a jɛ ʊ kan lannɔ kɩ. Lannɔ wɔɔ n zɛnyi da ʊ Yeezuu tɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeezuu n a bɔ, an a hɩ ŋ nɩ, a ʊ: «Zerizalɛm lannɔ, a bɩ nyi ka mɔɔ tɔ ma y. K'a nyi ka a mɩŋŋɔɔ tɔ ma an lɛ da, kan a nyɩnɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bala, dɔmɩm ta ʊ an nɩ zɛm, n nɩ zɛm b'a hɩ, ŋ ʊ: mimbirenyɩntazannɔ m lannɔ kʊ cɩnarɔ m, kan lannɔ kʊ ŋ bɩr nyɩnɔ yɩm cɩna rɔ wɔɔ kɩ m, kan bɔɔ ɩ nɩ nyɔ ka nyɩnɔ ʊ rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dɔmɩm bɩ do ʊ bɩ, n y'a hɩm ciro m: K'a da wɔɔ ra, ŋn'a hɩ dimbirlɔ m: K'a ku wɔɔ ra. ");
INSERT INTO bib_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bala, kʊ n y'a bam gɔ butur m ncɩnaaʊ, a zɛm bɩ nyɩnta gɔ gər ma lɔ?» ");
INSERT INTO bib_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ŋ bibiiro gaa hɩɩya k'a yaa nɩ ŋ zɛ kan kɩ. ");
INSERT INTO bib_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kʊ ŋ yaa lee ku bɩncɛ kʊ n n'a hɩm ma: ‹Minkorgo› bɩ, yarbənno yaa a wɔ gɔdarkʊra ma b'ʊ kan bibiiro hɩɩyɔɔ wɔɔ kɩ. Deem a bɩsɩ, deem a jɩsa. ");
INSERT INTO bib_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeezuu n a hɩ, a ʊ: «M Zɩ, sugur ka ŋ ʊ, bala hɔ kʊ ŋ n'a bam bɩ, ŋ n a jɩ dɔ y.» Bɩ jɛ ʊ bɩ, ŋ n pʊɛɛga da a huuro wɔɔ ma, ŋnɩ ŋ jir kan kʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Zamaa bɩ n jɩm b'ʊ, an nɩ dɩgam. Tara cinno wɔɔ nɩ yaa wʊm ma, ŋn'a hɩrɛ, ŋ ʊ: «A gɔsɩnnɔ bʊmbɔ. Kʊ Krista kʊ Woso a bɔ ʊ bɩ n'awɔɔ nɩ, k'an a mɩŋŋa bʊmbɔ a zim.» ");
INSERT INTO bib_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Yarbənno wɔɔ nɩ yaa wʊm ma sɔ. Ŋ y'a zɔ, ŋnɩ bɛɛ hɛɛnr ka ʊ, ŋn'a hɩ, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Kʊ zɩɩfʊrɔ cir n'ɩbɩɩ m, k'ɩ ɩ mɩŋŋa bʊmbɔ ɩ zim.» ");
INSERT INTO bib_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ŋ nɩ warga deem zeŋŋə a mim la, ŋn'a gʊrsɩra ba ncɩnaaʊ, ŋ ʊ: «Zɩɩfʊrɔ cir m naa.» ");
INSERT INTO bib_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bibii deem k'a nɩ zeŋŋəm gɔdarkʊra ma kan kɩ bɩ y'a sʊnsɔ wʊm, a ʊ: «Krista bɛɛ n'ɩbɩɩ m na? Ɩ mɩŋŋa bʊmbɔ, k'ɩ wɔɔ bʊmbɔ sɔ.» ");
INSERT INTO bib_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Deem bɩ n nyaa ba kan kɩ, a ʊ: «Ɩbɩɩ bɩr nyi bam Woso m na? Ɩbɩɩ ɩ hʊnhʊrlɛ nɔ ʊ am a hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kʊ wɔɔ hɔ bɩ nɩ, a a ga m, k'ʊ hʊnhʊrlɛ yɩ an a ga wɔɔ mim barɛ m, bɩ kʊ naa zaa nɩ, a mim ba ʊ y.» ");
INSERT INTO bib_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","A n bɔkarɛ, an a hɩ, a ʊ: «Yeezuu, k'ɩ yaa lee ku ɩ cirbəə bɩncɛ ʊ, k'ɩ mɔɔ tɔ da ɩ nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeezuu n a hɩ m, a ʊ: «Sɩra mɔɔ n'a hɩrɛ ɩbɩɩ m: her naa ʊ, ɩbɩɩ nyɩntam kan mɔɔ kɩ arzana ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Dɔmɩm bɩ do ʊ bɩ sinsebir da, monsigə gʊta n zɛ tara burə ʊ jilli, woso n ter, lɛɛ n'a ba bimm… an ta an wakatɩ kaakʊ ku. Wosocɛ pɛɛra bɩ n kaansʊ a bire ʊ. ");
INSERT INTO bib_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yeezuu n zee da kan paŋŋa kɩ, a ʊ: «M Zɩ, mɔɔ yɩ m nyi darɛ ɩbɩɩ wɔ ʊ.» K'a naa hɩ bɩ, a ga. ");
INSERT INTO bib_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yarbənno zɔrɔ cir bɩ k'a hɔ k'a ba bɩ yɩ bɩ, a y'a lɛ bɔm Woso ʊ, a ʊ: «Sɩra m, gʊaa naa do nyɩnta gʊaa tɩrga.» ");
INSERT INTO bib_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Gʊɔɔ wɔɔ kʊ ŋ bʊr k'a bɩ dɩga a bɩ, kʊ ŋ hɔ haay k'a ba bɩ yɩ bɩ, ŋ y'a wusigə ŋn'ɩ doom kan heerzar kɩ. ");
INSERT INTO bib_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bɩ Yeezuu dɔrɛrɔ wɔɔ haay, kan lannɔ kʊ ŋ zu kʊ ʊ kan kɩ hallɩ Galilee ʊ saa… rɔ wɔɔ haay jɩm laatʊ ŋn'ɩ dɩgarɛ. ");
INSERT INTO bib_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Gʊaa ɩ nyɩnta ʊ, a tɔ m Zozɛf. Zɩɩfʊrɔ kʊ deem kʊ n n'a birm Arimatee kʊ bɩ gʊaa m. Gʊaa bɩ do nyɩnta mɩŋŋa, a nyɩnta gʊaa tɩrga. A nyɩnta, an nɩ dɔm Woso cirbəə bɩ zɛrɛ ma. A nyɩnta dʊdɔkənno wɔɔ gʊaa deem, b'a n yɛ hɔ kʊ dʊdɔkənno wɔɔ a cɩnta, ŋn'a ba naa ma y. ");
INSERT INTO bib_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A n ta Pɩlatɩ zi, an aa Yeezuu gər bɩ yɛ han. ");
INSERT INTO bib_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A n a zer gɔdarkʊra bɩ ma, an pɛɛra mɩŋŋa ku ra, an aa wʊta yaa deem kʊ n y'a hɔn ci ʊ, bɩ n nɩ gər bir ʊ cɩna bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pakkɩ cibsa hinni m, bɩ *sabaa y'a bam k'a sɩŋŋɩda sa sɔ. ");
INSERT INTO bib_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Lannɔ kʊ ŋ y'a to Galilee ʊ ŋnɩ bʊr kan Yeezuu kɩ rɔ wɔɔ Zozɛf da zaa ʊ, ŋnɩ bɩ dɩga yaa bɩ ma, kʊ ŋ Yeezuu bir lʊnlɔ gɛ. ");
INSERT INTO bib_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ŋ n a wusigə k'a yaa tidəər hi banka kan nyɔɔ kɩ. Bɩ, kan bɩ kɩ, sabaa hinni ʊ bɩ, ŋ hoon si amba Woso lɛ ka bɩ m. ");
INSERT INTO bib_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hatʊ hinni ʊ wutigʊta m, lannɔ wɔɔ ta yaa ra b'ʊ kan tidəər nyɔɔ kʊ ŋ y'a banka bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kʊ ŋ lee ku b'ʊ bɩ, ŋ yaa dɩga a jaa kʊ ŋ y'a ta yaa bɩ lɛ rɛ bɩ, n y'a gərgu n n a gʊ rɛ, n n ta m laatʊ, n n yaa bɩ lɛ bɩ to. ");
INSERT INTO bib_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Gasʊ kʊ ŋ y'a ʊ bɩ, ŋ n Yeezuu gər bɩ yɩ y. ");
INSERT INTO bib_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ŋ n a dɔ k'a hɔɔn an n'a dam lɔ mim naa do ma y. Lɛɛm bɩ, gʊɔɔyaarɔ hɩɩyɔɔ y'a hɩnka ŋ nɩ, ŋ huuro nɩ yɔm. ");
INSERT INTO bib_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ŋ da bɔ ʊ, ŋn'a meer zuutə. Yaarɔ wɔɔ n a hɩ ŋ nɩ, ŋ ʊ: «Bɔ minto awɔɔ n'a kam gʊaa k'an mɩsɩr bɩ ma gəəno bire ʊ? ");
INSERT INTO bib_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A ba naa ʊ y. A a mɩm bɔ ʊ. K'a hɔ niŋŋə k'a hɩ awɔɔ m, an bɩr Galilee ʊ bɩ tɔ da a nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","A n n'a hɩrɛ, a ʊ: «Pakra m, kʊ n n Gʊaanyɩ bɩ nyasʊ n a ka mimbʊnyaabənno ʊ, kʊ ŋ n'a wɔ gɔdarkʊra ma, bɩ k'an a mɩm bɔ ʊ dɔmɩm kaakʊ hinni ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dɔmɩm bɩ do ʊ bɩ, lannɔ wɔɔ Yeezuu mim bɩ tɔ da a nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Lannɔ wɔɔ n a hʊr yaa ra b'ʊ, ŋn'a wusigə, ŋn'aa naa haay hɩ karɩndanyɩnɔ bueeredeenno wɔɔ m kan gʊɔɔ vantɔɔ kɩ m. ");
INSERT INTO bib_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nyɩnta a ʊ: Magdalaa Maarii, kan Zannɩ kɩ, kan Zakkɩ da Maarii kɩ. Lannɔ gɔsɩnnɔ kʊ ŋ nyɩnta kan ŋ kɩ rɔ wɔɔ mim naa do hɩ kristazibəəzannɔ wɔɔ m sɔ. ");
INSERT INTO bib_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bɩ, kristazibəəzannɔ wɔɔ n a tʊr ka lannɔ wɔɔ mim bɩ ma, ŋ n a si y, ŋ ʊ: «Para-para ŋ n'a dɩndam.» ");
INSERT INTO bib_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pɩyɛɛr n wuti an bra si, an ta yaa ra b'ʊ. Bɩ, k'a yaa zerga an dɩga yaa bɩ nɔ ʊ bɩ, pɛɛra b'a a yɩ, an nɩ cɩntam. A n a wusigə, an doo. A n zɛ kədə hɔ k'a ba bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Hinni bɩ do ʊ, karɩndanyɩnɔ hɩɩyɔɔ ɩ tam kʊ kʊ n n'a birm Emayuus b'ʊ. Tara bɩ, a ga kʊ ʊ a ba cilo bueeredeem kan Zerizalɛm kɩ. ");
INSERT INTO bib_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ŋ nyɩnta, ŋn'ɩ mim k'a ba bɩ dɩndam kan kʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kʊ ŋ nɩ mim bɩ dɩndam, ŋn'ɩ bɩsɩ kam kan kʊ kɩ bɩ, Yeezuu bɩ ŋ ku, an nɩ zum kʊ ʊ kan ŋ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bɔ a kʊ ʊ, ɩ ʊ: Hɔ y'a ka ŋ mɩm la, ŋ n a dɔ kʊ nka nɩ y. ");
INSERT INTO bib_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeezuu n ŋ lar, a ʊ: «Bɔ bɩsɩ awɔɔ ka an nɩ tarɛ?» Ŋ n a gaa, ŋnɩ jɩm kan heerzarlɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ŋ gʊaa deem kʊ n n'a birm Kleopas b'a nyɩ bɔ nʊ, a ʊ: «Ɩbɩɩ y'ɩ deem ɩ gɔɔta Zerizalɛm nɔ ʊ naa ʊ, ɩbɩɩ n mim k'a ba dɔmɩnnɔ nɔɔn duro ʊ bɩ dɔ ra?» ");
INSERT INTO bib_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yeezuu n ŋ lar, a ʊ: «Bɔ ɩ ba?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Nazarɛtɩ Yeezuu k'a nyɩnta wosolɛsinnɩsorazaa, a zibəə paŋŋa nyɩnta ʊ kan a meerbaa kɩ Woso taa bɩ, kan gʊaa haay kɩ taa sɔ bɩ, ");
INSERT INTO bib_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","wosocɛmannɩbənno jɩtannɔ kan wɔɔ cinno kɩ y'a nyasʊ, ŋn'a dʊdɔ ka, ŋ ʊ: A a ga zɛ m. Ŋ n a wɔ gɔdarkʊra ma. ");
INSERT INTO bib_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wɔɔ y'ʊ hɔɔn dam, ʊ ʊ: A n nɩ zɛm k'a bɩ Israyɛl bʊmbɔ. Bɩ, an lɛ da bɩ, minno nɔɔn duro ba ŋ y'a ʊ, a dɔmɩm kaakʊ hɔ m her. ");
INSERT INTO bib_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Sɩra m, lannɔ gɔsɩnnɔ kʊ ŋ nɩ wɔɔ barla rɔ wɔɔ a ka wɔɔ n zɛ kədə. Ta ŋ y'a ʊ yaa ra b'ʊ wutigʊta m, ");
INSERT INTO bib_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ŋ n aa a gər bɩ yɩ y, ŋn'a bɔ ŋnɩ b'a hɩ, ŋ ʊ: Malɛɛkarɔ y'a hɩnka awɔɔ m, ŋn'a hɩ, ŋ ʊ, Yeezuu mɩsɩr. ");
INSERT INTO bib_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wɔɔ gʊɔɔ gɔsɩnnɔ ta yaa ra b'ʊ, ŋn'a hɔ haay bɩ yɩ amba lannɔ wɔɔ a hɩ bɩ m, bɩ ŋ n a mɩŋŋa yɩ y.» ");
INSERT INTO bib_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Bɩ Yeezuu a hɩ, a ʊ: «Hɔɔn poore zannɔ n'awɔɔ m, awɔɔ bɩr yɛm an nɩ hɔ kʊ wosolɛsinnɩsorazannɔ a hɩ awɔɔ m haay bɩ mim sim zɔɔ y. ");
INSERT INTO bib_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pakra m kan Krista kɩ, k'an fɩr yɩ ncɩnaaʊ, k'an bɔkarɛ an gasʊ a lɛbɔʊrɛ nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A n a sɩŋŋɩda sa, an nɩ hɔ kʊ Wosoci a hɩ a minto bɩ jɩ hɩrɛ ŋ nɩ. A n a sa Moyiisi ma kan wosolɛsinnɩsorazannɔ haay kʊ ŋ y'a mim gʊrsɩra ba rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kʊ ŋ y'a zɔ tara kʊ ŋ nɩ taŋ ʊ bɩ ma bɩ, Yeezuu n a hɔ ba ɩ ʊ, a hɩ a ʊ k'a cem ŋ han. ");
INSERT INTO bib_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ŋ n yu ra, ŋ ʊ: «Gɔɔta kan wɔɔ kɩ, woso lɛ y'a zom.» Yeezuu n gasʊ k'a gɔɔta kan ŋ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","K'a nyɩnta an nɩ hɔ bɩm kan ŋ kɩ bɩ, a bur sa an a barka da ʊ an bɔkarɛ an a zɩnzɛ ra, an a ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Bɩ ma bɩ, ŋ mɩm zer, ŋnɩ Yeezuu dɔ, bɩ Yeezuu nyaam ŋ lɛɛ. ");
INSERT INTO bib_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ŋ n'a hɩm kʊ m, ŋ ʊ: «Sɩra m, dɔmɩm niŋŋə k'a nyɩnta an nɩ Wosoci bʊmbɔm wɔɔ m kʊ zi, ʊ nɩ tam bɩ, wɔɔ heer yɩ nyɩnta gʊta.» ");
INSERT INTO bib_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ŋ n a bɔ lɛɛm, ŋnɩ ta Zerizalɛm ʊ, ŋn'a karɩndanyɩnɔ bueeredeenno wɔɔ yɩ, ŋn'a so kʊ ma kan a muno kɩ. ");
INSERT INTO bib_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Karɩndanyɩnɔ wɔɔ duro n'a hɩrɛ ŋ nɩ, ŋ ʊ: «Sɩra m, Zuuba a mɩm bɔ ʊ! A a hɩnka Sɩmɔɔn m.» ");
INSERT INTO bib_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Gʊɔɔ hɩɩyɔɔ wɔɔ n hɔ k'a ba zaa bire ʊ bɩ hɩ, ŋn'a hɩ sɔ, ŋ ʊ: «Yeezuu k'a bʊr an nɩ bur bɩ zɩnzɛm la bɩ dɔmɩm ʊ wɔɔ b'a dɔ ma, ʊ ʊ, a mɩŋŋa m.» ");
INSERT INTO bib_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kʊ ŋ gɔɔta, ŋn'ɩ meer bam kan kʊ kɩ bɩ, Yeezuu bʊr ŋ bire ʊ, an a hɩ ŋ nɩ, a ʊ: «Laafɩɩ n bɩr kan awɔɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ŋ da n bɔ ʊ, nyibəə gʊta n gasʊ ŋ ʊ. Ŋ hɔɔn ʊ bɩ, zinə awɔɔ yɩ naa. ");
INSERT INTO bib_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A n a hɩ ŋ nɩ, a ʊ: «Bɔ da bɔ ʊ n ta awɔɔ nɩ? Bɔ hɔɔndarɛ n ta awɔɔ heer ʊ? ");
INSERT INTO bib_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","K'a dɩga mɔɔ wɔrɔ ma kan mɔɔ gannɔ kɩ. Mɔɔ mɩŋŋa m bala! K'a wɔ da mɔɔ ma, a dɩga a. Zinə mɛsim ba ʊ, b'a yaa ba ʊ, amba awɔɔ mɔɔ yɩ mɔɔ m ta m naa nɩ y.» ");
INSERT INTO bib_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","K'a naa hɩ bɩ, a a wɔrɔ hɩnka kan a gannɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Heernyɔɔ gʊta nyɩnta ŋ ʊ, ŋ n zɛ kədə. Bɩ y'a ka ŋ b'a dam ma ŋn'a si y. Yeezuu n a hɩ ŋ nɩ: «Hɔbɩrɛ y'awɔɔ ʊ naa ʊ ra?» ");
INSERT INTO bib_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ŋ n zɔdɩsɛɛrɛ sa, ŋn'a ka ʊ. ");
INSERT INTO bib_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","A n a si, an a sʊ ŋ mɩnyaa m. ");
INSERT INTO bib_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A n bɔkarɛ, an a hɩ ŋ nɩ, a ʊ: «Kʊ mɔɔ nyɩnta kan awɔɔ kɩ bɩ, hɔ kʊ mɔɔ hɩ awɔɔ m bɩ ba n na: Pakra m kʊ hɔ haay kʊ n y'a gʊrsɩra ba mɔɔ minto, Moyiisi lɛrɔ ci nɔ ʊ kan wosolɛsinnɩsorazannɔ ciro kɩ nɔ ʊ, kan laarɔ kɩ nɔ ʊ bɩ n kʊ yɩ.» ");
INSERT INTO bib_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Bɩ kur bɩ, Yeezuu n ŋ hɔɔn gu, kʊ ŋ nɩ Wosoci bɩ jɩ dɔ. ");
INSERT INTO bib_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A n a hɩ ŋ nɩ, a ʊ: «Ba hɔ kʊ n y'a gʊrsɩra ba bɩ n na: Pakra m kʊ Krista n fɩr yɩ, k'an a mɩm bɔ ʊ gəəno bire ʊ a dɔmɩm kaakʊ hinni ʊ. ");
INSERT INTO bib_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bɩ, a tɔ ma bɩ, a a ga m kʊ n n'a pa da durnya gʊɔɔ m, kʊ n n'a mɩsɩrbaa lʊr, kʊ n n'a mimbʊnyaarɔ sugur yɩ, bɩ a sɩŋŋɩda an n'a sam Zerizalɛm ma. ");
INSERT INTO bib_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mɔɔ kasɛtɩzannɔ n'awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bɩ, mɔɔ ganwʊrɛ kʊ mɔɔ Zɩ a ler bɔ bɩ nyɔɔrɛ awɔɔ m. B'awɔɔ, k'a gɔɔta tara nɔ ʊ naa ʊ, an ta an dɔmɩm kʊ paŋŋa k'a n'a tom brama, an zer awɔɔ mim ʊ bɩ ku.» ");
INSERT INTO bib_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bɩ Yeezuu ŋ gaa, an bɔ ŋ nɩ tara bɩ nɔ ʊ, an ta ŋ nɩ Betanii zeezi. B'ʊ bɩ, a a wɔ busu, an ŋ barka da ʊ. ");
INSERT INTO bib_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","K'a nɩ ŋ barka daŋ ʊ bɩ, a a gʊ ŋ ma, an der arzana ʊ. ");
INSERT INTO bib_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Karɩndanyɩnɔ wɔɔ n Yeezuu da ʊ, ŋnɩ bɔkarɛ ŋn'a wusigə Zerizalɛm ʊ kan heernyɔɔ gʊta kɩ. ");
INSERT INTO bib_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bɩ ŋ tɩr ta Wosocɛ ʊ dɔmɩm haay ŋnɩ bɩr a lɛ bɔm Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","A sɩŋŋɩda ʊ bɩ, Lemim bɩ lɛɛ ka an nyɩnta ʊ. Lemim bɩ nyɩnta a ʊ kan Woso kɩ, bɩ Lemim bɩ, Woso m. ");
INSERT INTO bib_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","A sɩŋŋɩda ʊ bɩ, a nyɩnta ʊ kan Woso kɩ. ");
INSERT INTO bib_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hɔ haay bɩ, a y'a da. Hɔ ba ʊ an ba, an nyɩnta a nɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","*Mɩsɩrbaa bɩ, nyɩnta a ʊ a mɩŋŋa ʊ, bɩ Mɩsɩrbaa bɩ nyɩnta gʊɔɔ Lɛɛgure. ");
INSERT INTO bib_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lɛɛgure bɩ nɩ yɔm monsigə nɔ ʊ, bɩ monsigə bɩ n a si y. ");
INSERT INTO bib_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gʊaa deem ɩ nyɩnta ʊ, Woso n a nyɔɔ. A tɔ m Zaan. ");
INSERT INTO bib_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Bʊr a ʊ kasɛtɩ m, k'a bɩ Lɛɛgure kasɛtɩ ka, kʊ gʊaa haay n a si, a kasɛtɩ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A bɛɛ m Lɛɛgure y. Bʊr a ʊ, k'a bɩ Lɛɛgure kasɛtɩ ka. ");
INSERT INTO bib_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lɛɛgure paan…, Lemim bɩ m, an bʊr durnya nɔ ʊ k'a bɩ lɛɛ gu gʊaa haay m. ");
INSERT INTO bib_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A nyɩnta durnya nɔ ʊ, a ɩ durnya da, bɩ, kʊ nka m a mɩŋŋa nɩ, durnyazannɔ n a dɔ y. ");
INSERT INTO bib_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Bʊr a ʊ a dogʊɔɔ bire ʊ, b'a dogʊɔɔ n a si y. ");
INSERT INTO bib_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bɩ gʊɔɔ kʊ ŋ y'a si, ŋnɩ sɩra ka a tɔ ʊ rɔ wɔɔ, a paŋŋa ka ŋ ʊ, kʊ ŋ n'a ba Woso nyɩnɔ. ");
INSERT INTO bib_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Brɔɔ n yɩ ma nɔ ʊ, kan mɛsim lɛtaama kɩ, kan gʊaa hɔɔnhɔ kɩ y. Yɩ ŋ y'a ʊ Woso nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lemim b'a ba gʊaa, an bɩ nyɩnta wɔɔ bire ʊ, mɩŋŋabaa n a heer han kan sɩra kɩ. Wɔɔ cirbəə yɩ, cirbəə niŋŋə kʊ Zɩ b'a ka Nyɩ k'a vanta ba ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zaan a kasɛtɩ ka, an n'a pa darɛ, a ʊ: «Ba gʊaa kʊ mɔɔ hɩ ma bɩ n na. A lɛ da mɔɔ m, an nɩ zɛm mɔɔ jɛ ʊ, bala, dɔmɩm kʊ mɔɔ n nyɩnta ʊ bɩ, a ta ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Woso hɔɔ mɩŋŋɔɔ haay k'a nɩ kan kɩ rɔ wɔɔ, wɔɔ ŋ yɩ barka k'a nyarɛ ba ʊ bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","*Moyiisi ɩ bʊr *lɛrɔ m, bɩ, Yeezuu *Krista ɩ bʊr barka m kan sɩra kɩ. ");
INSERT INTO bib_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Gʊaa ba ʊ, an Woso yɩ y. Woso Nyɩ a deem, k'a m Woso, an n'a Zɩ jɩr ʊ bɩ, a a hɩnka wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ba Zaan kasɛtɩ k'a ka bɩ n na. Dɔmɩm niŋŋə kʊ zɩɩfʊrɔ jɩtannɔ wɔɔ *wosocɛmannɩbənno kan a daahanzannɔ kɩ nyɔɔ ʊ Zerizalɛm ʊ, kʊ ŋ n'aa laaka naa do da han, ŋ ʊ: «Nka n'ɩbɩɩ nɩ?» ");
INSERT INTO bib_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","A n bɩsɩ ka a nyɩbɔʊrɛ ma y, an a hɩ, a ʊ: «*Krista (kʊ Woso a ler bɔ k'a nyɔɔ bɩ) bɛɛ m mɔɔ nɩ y.» ");
INSERT INTO bib_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ŋ n a lar, ŋ ʊ: «Nka n'ɩbɩɩ nɩ? *Elii n'ɩbɩɩ m gɛ?» A n a nyɩ bɔ ʊ, a ʊ: «Elii bɛɛ m mɔɔ nɩ y.» «Wosolɛsinnɩsorazaa bɩ n'ɩbɩɩ m gɛ?» A n a nyɩ bɔ ʊ, a ʊ: «Ayy…» ");
INSERT INTO bib_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ŋ n a lar, ŋ ʊ: «Nka n'ɩbɩɩ nɩ? Kʊ aa a nyɩbɔʊrɛ ka gʊɔɔ kʊ ŋ wɔɔ nyɔɔ rɔ wɔɔ ʊ. K'ɩbɩɩ m, nka n'ɩbɩɩ m paan…?» ");
INSERT INTO bib_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A n a nyɩ bɔ ʊ, amba *wosolɛsinnɩsorazaa Ezayii a hɩ bɩ m: « ‹Leer k'a nɩ bɔm *poohɔɔn ʊ bɩ› m mɔɔ m, ‹k'a Zuuba zaa zɛ a wʊta.› » ");
INSERT INTO bib_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bala, gʊɔɔ kʊ ŋ yɩ ŋ nyɔɔ rɔ wɔɔ, farizɛɛnrɔ m. ");
INSERT INTO bib_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ŋ n gɔɔta, ŋn'a larlɛ, ŋ ʊ: «Kʊ *Krista, gɛɛ *Elii, gɛɛ wosolɛsinnɩsorazaa bɩ bɛɛ n'ɩbɩɩ nɩ, bɔ minto ɩbɩɩ nɩ *batɛm karɛ?» ");
INSERT INTO bib_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Zaan a nyɩ bɔ ʊ, a ʊ: «Mɔɔ naa, batɛm mɔɔ n'a kam hi nɔ ʊ. Gʊaa k'awɔɔ n a dɔ bɩ y'awɔɔ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A ɩ zɛm mɔɔ jɛ ʊ, bɩ mɔɔ n m ga m, m a kʊsɔrɔ bar hʊr y.» ");
INSERT INTO bib_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ba naa ʊ Betanii ʊ, kɔ kʊ n n'a birm Zʊrdɛn bɩ lɛ ra zeezi, bɩncɛ kʊ Zaan nɩ batɛm kaŋ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Bɩ dɔ k'a mɛ bɩ, Zaan Yeezuu yɩ, an nɩ zɛm zi, an a hɩ, a ʊ: «Ba *Woso sinnyɛɛm k'a nɩ mimbʊnyaa k'a nɩ durnya nɔ ʊ bɩ gʊm ma bɩ n na. ");
INSERT INTO bib_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","A mɩŋŋa mɔɔ hɩ ma, mɔɔ ʊ: A lɛ da mɔɔ m, an nɩ zɛm mɔɔ jɛ ʊ, bala, a lɛɛ ka mɔɔ m, an ta ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mɔɔ mɩŋŋa, mɔɔ n nyɩnta m a dɔ y, kʊ ŋ n'a dɔ *Israyɛl ʊ bɩ minto y'a ka, mɔɔ nɩ *batɛm kam hi ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Zaan a kasɛtɩ ka, an n'a hɩrɛ, a ʊ: «Mɔɔ *Sɛnt-Ɛspri yɩ, an bɔ kʊ ʊ kan cirpʊʊrɛ kɩ, an a to brama, an bɩ zer a mim ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Bɩ, mɔɔ n nyɩnta m a dɔ y. Bɩ, Woso ɩ mɔɔ nyɔɔ an a hɩ mɔɔ m, a ʊ: kʊ m bɩ batɛm ka hi ʊ. Gʊaa niŋŋə kʊ Sɛnt-Ɛspri n nɩ zerle a mim la bɩ n nɩ zɛm bɩ batɛm ka Sɛnt-Ɛspri nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mɔɔ mɩŋŋa a yɩ, m n'a kasɛtɩ kam, mɔɔ ʊ, a m Woso Nyɩ.» ");
INSERT INTO bib_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Dɔ k'a mɛ bɩ, Zaan a ya, an ta bɩncɛ bɩ do ʊ kan a *karɩndanyɩnɔ kɩ hɩɩya. ");
INSERT INTO bib_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","K'a Yeezuu yɩ, an nɩ cenim bɩ, a a hɩ, a ʊ: «Woso sinnyɛɛm bɩ ba n nɩ.» ");
INSERT INTO bib_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kʊ karɩndanyɩnɔ hɩɩyɔɔ wɔɔ a ma, an n'a hɩrɛ ncɩnaaʊ bɩ, ŋ zu Yeezuu ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeezuu n a bɔ an dɩga a kur, k'a ŋ yɩ ŋn'ɩ zure a jɛ ʊ bɩ, a ŋ lar, a ʊ: «Bɔ awɔɔ n'a kam ma?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Rabi, - a lɛ taa k'a hɩ, a ʊ: karɩnsaamba - ɩbɩɩ har ɩ ka?» ");
INSERT INTO bib_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","A n a hɩ ŋ nɩ, a ʊ: «K'a bʊr a dɩga a.» Ŋ n ta, ŋnɩ bɩncɛ bɩ dɔ, ŋnɩ gɔɔta kan kɩ hinni bɩ do ʊ. Nyɩnta a ʊ yirbəə wakatɩ si ma. ");
INSERT INTO bib_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Sɩmɔɔn Pɩyɛɛr danzaa Andɩr nyɩnta ŋ gʊɔɔ hɩɩyɔɔ wɔɔ gʊaa deem, ŋn'a tʊr ka Zaan meerbaa bɩ ma, ŋnɩ zu Yeezuu ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Lɛɛm bɩ, a ta, an aa a danyɩ Sɩmɔɔn bɩ yɩ, an a hɩ m, a ʊ: «Wɔɔ *Mesii bɩ yɩ!» - Bɩ lɛ taa k'a hɩ, a ʊ: *Krista. - ");
INSERT INTO bib_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A n a gaa, an ta m Yeezuu zi. Yeezuu n dɩga a sɩɩ… an a hɩ m, a ʊ: «Ɩbɩɩ m Sɩmɔɔn, Zaan nyɩ n'ɩbɩɩ m; n y'ɩbɩɩ birm Sefas.» Bɩ lɛ taa k'a hɩ, a ʊ: Pɩyɛɛr. ");
INSERT INTO bib_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Bɩ dɔ k'a mɛ bɩ, Yeezuu a hɩ a ʊ, k'a ta Galilee ʊ. A n aa Filipi yɩ, an a hɩ m, a ʊ: «Zu mɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipi bɩ, Bɛtsayɩdaa gʊaa m, Andɩr kan Pɩyɛɛr kɩ kʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi n aa Natanayɛl yɩ, an a hɩ m, a ʊ: «Gʊaa kʊ n y'a mim dɩnda *Moyiisi ciro nɔ ʊ kan *wosolɛsinnɩsorazannɔ wɔɔ hɔɔ kɩ m bɩ, wɔɔ yɩ. Zozɛf nyɩ Yeezuu, Nazarɛtɩ gʊaa bɩ m.» ");
INSERT INTO bib_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayɛl n a hɩ m, a ʊ: «Hɔ mɩŋŋa do bɔm Nazarɛtɩ ʊ ra?» Filipi n a hɩ m, a ʊ: «Bʊr ɩ dɩga a.» ");
INSERT INTO bib_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yeezuu n Natanayɛl yɩ, an nɩ zɛm zi, an a mim dɩnda, a ʊ: «Ba Israyɛl gʊaa paan… n na, a zambʊ ba ʊ y.» ");
INSERT INTO bib_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayɛl n a hɩ m, a ʊ: «Ɩbɩɩ mɔɔ dɔ ka?» Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Nyɩnta k'ɩbɩɩ ʊ sɔɔn bɩ taa bɩ, mɔɔ ɩbɩɩ yɩ, bɩ ma bɩ, Filipi n ɩbɩɩ bir y.» ");
INSERT INTO bib_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayɛl n a hɩ, a ʊ: «Karɩnsaamba, Woso Nyɩ n'ɩbɩɩ m, ɩbɩɩ m *Israyɛl cir.» ");
INSERT INTO bib_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Kʊ mɔɔ hɩ, mɔɔ ʊ, mɔɔ ɩbɩɩ yɩ sɔɔn bɩ taa bɩ, bɩ y'a ka, ɩbɩɩ n sɩra ka ra? Ɩbɩɩ hɔ gʊta yɩrɛ, an lɛ da naa m.» ");
INSERT INTO bib_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A n a ya, an n'a hɩrɛ, a ʊ: «Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m: awɔɔ brama yɩrɛ an a gʊ, Woso malɛɛkarɔ n bɩr derm, ŋn'ɩ bɩr zerm *Gʊaanyɩ bɩ burə ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A dɔmɩm kaakʊ hinni ʊ bɩ, lʊsarɛ cibsa ɩ nyɩnta ʊ Galilee kʊ Kanaa ʊ. Yeezuu da nyɩnta b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","N Yeezuu bir lʊsarɛ cibsa bɩ ma sɔ kan a *karɩndanyɩnɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dɩvɛn bɩ k'a bɩ nya bɩ, Yeezuu da a hɩ m, a ʊ: «Dɩvɛn ba ŋ ʊ dɔ y.» ");
INSERT INTO bib_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «M naa, kara y'ɩbɩɩ ku? Mɔɔ wakatɩ n a ku cɩna y.» ");
INSERT INTO bib_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A da bɩ n a hɩ zibəənyɩnɔ wɔɔ m, a ʊ: «K'a hɔ k'a n'a hɩrɛ awɔɔ m haay bɩ ba.» ");
INSERT INTO bib_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Sipiro ɩ nyɩnta b'ʊ sɔrdɩ, ŋnɩ tɩr hi tʊntɔŋ ʊ, zɩɩfʊrɔ wɔɔ *hubɔrɛ minto, amba ŋ tɩr a ba a Woso zaa zuure nɔ ʊ bɩ m. Bɩ sipi deem a da ma, an gər si si. ");
INSERT INTO bib_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yeezuu n a hɩ zibəənyɩnɔ wɔɔ m, a ʊ: «K'a hi tʊntɔ sipiro nɔɔn duro ʊ, k'an ŋ hɩnhan.» Ŋ n hi bɩ tʊntɔ ŋ ʊ, an ŋ hɩnhan kan a lɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a kusi kɛɛrɛ, a ka hɔjirlezaa b'ʊ.» Ŋ n a kusi, ŋn'aa a ka ʊ. ");
INSERT INTO bib_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","K'a hi k'a lʊr dɩvɛn bɩ da a lɛ ma bɩ, a n a dɔ k'a to a ʊ ka y. Bɩ, zibəənyɩnɔ kʊ ŋ y'a kusi rɔ wɔɔ a dɔ. A lʊ bɩ zim bɩ bir, ");
INSERT INTO bib_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","an a hɩ m, a ʊ: «Gʊaa biyəə naa, dɩvɛn nyɩnta a tɩr lɛɛ ka, an a ka gʊɔɔ ʊ. Kʊ ŋ b'a mi, an ŋ ka, an bɔkarɛ, an bɔ ɩ bɩ nyɩnta bɩ ka ŋ ʊ. Ɩbɩɩ n bɔkarɛ ɩ dɩvɛn nyɩnta bɩ to, an wakatɩ naa do ku!» ");
INSERT INTO bib_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yeezuu lɛɛkarɛ hoser n naa, an a ba Kanaa ʊ, Galilee kʊ ʊ. A a cirbəə bɩ hɩnka, a karɩndanyɩnɔ wɔɔ n sɩra ka ʊ. ");
INSERT INTO bib_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bɩ jɛ ʊ bɩ, a ta Kapɛrnawum ʊ kan a da kɩ, a danyɩnɔ kɩ, a karɩndanyɩnɔ kɩ. Ŋ yaa nyɩnta b'ʊ, bɩ, ŋ n maasɩrɛ ba y. ");
INSERT INTO bib_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Zɩɩfʊrɔ *pakkɩ cibsa a zɔ, Yeezuu n ta Zerizalɛm ʊ. ");
INSERT INTO bib_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","A n aa dɩga a, ŋ yɩ ŋʊannɔ hɛɛnm *Wosocɛ hallu ʊ b'ʊ, kan seero kɩ, cirpʊnnɔ kɩ, busoolʊrlɛzannɔ nyɩnta b'ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","A n bar sa, an a ba madɩr, an la ŋ la haay Wosocɛ hallu ʊ b'ʊ kan seero wɔɔ kɩ, dono wɔɔ kɩ. A busoolʊrlɛzannɔ wɔɔ bɔɔlʊgʊ bɩ hɩsɩga, an ŋ mɔdrɔkuntərehɔɔ wɔɔ hɩnhɩsɩga. ");
INSERT INTO bib_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A n a hɩ cirpʊnnɔ hɛɛrɛ zannɔ wɔɔ m, a ʊ: «K'a bɔ nawɔnnɔ haay m naa ʊ, a bɩ mɔɔ Zɩ cɛ bɩ sa a ba daasɩ y.» ");
INSERT INTO bib_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Karɩndanyɩnɔ wɔɔ n hɔ kʊ n y'a gʊrsɩra ba bɩ tɔ da a nɔ ʊ: ‹Ɩbɩɩ har bɩ ŋʊarɛ a so mɔɔ ʊ haay.› ");
INSERT INTO bib_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Zɩɩfʊrɔ jɩtannɔ wɔɔ n meerbaa bɩ sa, ŋ ʊ: «K'ɩbɩɩ ba ncɩnaaʊ naa, bɔ *makra ɩbɩɩ n n'a hɩnkam wɔɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «K'a Wosocɛ naa do wurgə, mɔɔ yɩ m bɔrɛ m a dɔ dɔmɩm kaakʊ nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ŋ n a hɩ m, ŋ ʊ: «Dɔɔraa busi a yaa sɔrdɩ wɔɔ Wosocɛ naa do dɔ, ʊ a nya ma. Ɩbɩɩ n bɔkarɛ, ɩ ʊ, k'ɩ dɔ dɔmɩm kaakʊ nɔ ʊ?» ");
INSERT INTO bib_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bala, Wosocɛ k'a n'a mim hɩm bɩ, a mɩŋŋa mɛ m. ");
INSERT INTO bib_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bɩ minto y'a ka, Yeezuu k'a b'a mɩm bɔ ʊ gəəno bire ʊ bɩ, a karɩndanyɩnɔ wɔɔ a tɔ da a nɔ ʊ, ŋ ʊ, a nyɩnta an a hɩ ncɩnaaʊ, ŋnɩ sɩra ka *Wosoci bɩ lemim ʊ kan meerbaa k'a ba bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yeezuu k'a nɩ Zerizalɛm ʊ *pakkɩ cibsa dɔmɩm ʊ bɩ, gʊɔɔ gʊta sɩra ka Yeezuu tɔ ʊ makrarɔ k'a ŋ ba ŋn'a yɩ rɔ wɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bɩ, Yeezuu n yɛ, an sɩra ka ŋ ʊ y. Bala, a ŋ dɔ haay, ");
INSERT INTO bib_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","a lɛ baa kʊ n n gʊaa kasɛtɩ ka ʊ y. Bala, a hɔ k'a nɩ gʊaa heer ʊ bɩ dɔ. ");
INSERT INTO bib_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Zɩɩfʊrɔ jɩtaarɛ deem ɩ nyɩnta farizɛɛnrɔ wɔɔ barla, a tɔ m Nikodɛm. ");
INSERT INTO bib_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","A n bʊr gunuu Yeezuu zi, an b'a hɩ m, a ʊ: «*Rabi, wɔɔ dɔ wɔɔ ʊ karɩnsaamba n'ɩbɩɩ m, ɩ ɩ to Woso zi. Bala, wɔɔ dɔ wɔɔ ʊ, gʊaa b'a dam ma, an makrarɔ k'ɩbɩɩ nɩ ŋ bam nɔ nɔɔn ba, kʊ Woso ba kan a zaa kɩ y.» ");
INSERT INTO bib_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Sɩra paan… mɔɔ n'a hɩrɛ ɩbɩɩ m: kʊ gʊaa n a bɔ an yɩ, a bɩ *Woso cirbəə bɩ yɩrɛ y.» ");
INSERT INTO bib_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodɛm n a hɩ m, a ʊ: «Kʊ gʊaa gusi, a y'a bam lɔ k'a a ya, a yɩ gɛ? A y'a bɔrɛ, an gasʊ a da nɔ ʊ a hɩɩya hɔ ma k'a yɩ ra?» ");
INSERT INTO bib_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeezuu n a hɩ m, a ʊ: «Sɩra paan… mɔɔ n'a hɩrɛ ɩbɩɩ m: Kʊ gʊaa n yɩ hi nɔ ʊ kan *Sɛnt-Ɛspri kɩ, a b'a dam ma, an gasʊ Woso cirbəə nɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hɔ k'a yɩ mɛsim nɔ ʊ bɩ, mɛsim m. Hɔ k'a yɩ Sɛnt-Ɛspri nɔ ʊ bɩ, ɛspri m. ");
INSERT INTO bib_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kʊ mɔɔ hɩ ɩbɩɩ m, mɔɔ ʊ, ɩ ɩ ya, ɩ so ɩ ra ɩ yɩ bɩ, ɩ bɩ zɛ kədə y. ");
INSERT INTO bib_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hɩnhɛr bɩ, hɔ an nawʊm bɩncɛ k'a ŋʊa ʊ, ɩbɩɩ n'a bʊgʊr marɛ, b'ɩbɩɩ n a dɔ k'a to a ʊ ka, an nɩ tam ka y. A maam sɔ kan gʊaa k'a nɩ yɩm Sɛnt-Ɛspri nɔ ʊ bɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodɛm n a hɩ m, a ʊ: «Naa y'a dam ma, an ba lɔ?» ");
INSERT INTO bib_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Israyɛl karɩnsaamba n'ɩbɩɩ m, b'ɩbɩɩ n hɔɔ nɔɔn duro dɔ y! ");
INSERT INTO bib_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sɩra paan… mɔɔ n'a hɩrɛ ɩbɩɩ m, hɔ kʊ wɔɔ dɔ bɩ wɔɔ n n'a hɩm, hɔ kʊ wɔɔ yɩ bɩ wɔɔ n'a kasɛtɩ kam, awɔɔ n bɔkarɛ, awɔɔ bɩr wɔɔ kasɛtɩ bɩ sire y. ");
INSERT INTO bib_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kʊ mɔɔ ɩ tara burə minno hɩrɛ b'awɔɔ bɩr ŋ sire, kʊ mɔɔ bɩ brama mim hɩ, awɔɔ y'a bam lɔ k'a si? ");
INSERT INTO bib_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Bala, gɔsɩ n ta arzana ʊ y, kʊ n maam *Gʊaanyɩ k'a a to arzana ʊ, an bʊr bɩ m. ");
INSERT INTO bib_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Amba *Moyiisi k'a mɩm busu brama poohɔɔn ʊ bɩ, pakra m kʊ n n Gʊaanyɩ bɩ busu sɔ. ");
INSERT INTO bib_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kʊ gʊaa k'a sɩra ka ʊ bɩ n *mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩ. ");
INSERT INTO bib_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sɩra m, Woso durnya ŋʊa paan…, hallɩ an a Nyɩ deem bɩ sa an a ka, kʊ gʊaa k'a nɩ sɩra kaŋ ʊ bɩ mɩsɩrbaa b'a zar y, k'an mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩ. ");
INSERT INTO bib_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bala, Woso n a Nyɩ bɩ nyɔɔ durnya ʊ k'an bɩ durnya dʊdɔ ka y. A nyɔɔ a ʊ, k'an bɩ durnya bʊmbɔ. ");
INSERT INTO bib_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","N bɩ gʊaa k'a sɩra ka ʊ bɩ dʊdɔ karɛ y. Bɔ ɩ nɩ sɩra ka ʊ bɩ, n lɛɛ ka, n n a dʊdɔ ka. Bala, a n sɩra ka Woso Nyɩ a deem b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ba dʊdɔ bɩ n na: lɛɛgure bʊr durnya ʊ, gʊɔɔ n bɔkarɛ ŋnɩ monsigə ŋʊa an lɛ da lɛɛgure m, bala, ŋ zibəəro wɔɔ nyɩnta bʊnyaa. ");
INSERT INTO bib_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Gʊaa k'a n'a bʊnyaa bam bɩ, a sɔ lɛɛgure m, an nɩ nyi barɛ, a lɛ baa k'a bʊr lɛɛgure ʊ y, a zibəəro bʊnyaarɔ wɔɔ y'a n a hɩnka. ");
INSERT INTO bib_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gʊaa k'a nɩ sɩra zi bam bɩ, zɛ bɩ nawʊm lɛɛgure ʊ, kʊ ŋ n'a zibəəro wɔɔ dɔ, bala, ŋ ba a ʊ Woso tɔ ma.» ");
INSERT INTO bib_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bɩ jɛ ʊ bɩ, Yeezuu ta kan a *karɩndanyɩnɔ kɩ Zidee kʊ ʊ. A gɔɔta b'ʊ kan ŋ kɩ, an nɩ *batɛm kam. ");
INSERT INTO bib_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Zaan ɩ batɛm kam sɔ Enɔɔn kʊ ʊ, Salim kʊ jɩr ʊ. Bala, hi ɩ b'ʊ gʊta. Gʊɔɔ wɔɔ n bʊr, ŋn'ɩ batɛm sire. ");
INSERT INTO bib_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Bɩ ma bɩ, n n Zaan du lɔnnɔcɛ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bɩsɩkarɛ wuti Zaan karɩndanyɩnɔ wɔɔ bire ʊ kan zɩɩfʊ deem kɩ zɩɩfʊrɔ *hubɔrɛ minto. ");
INSERT INTO bib_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ŋ n bʊr Zaan zi, ŋnɩ b'a hɩ, ŋ ʊ: «Karɩnsaamba, gʊaa k'a nyɩnta kan ɩbɩɩ kɩ Zʊrdɛn kɔ zeezi bɩ, ɩbɩɩ n a kasɛtɩ ka bɩ, a ɩ batɛm kam kɛɛrɛ sɔ, gʊaa haay nɩ tam zi.» ");
INSERT INTO bib_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Zaan n a nyɩ bɔ ŋ nʊ, a ʊ: «Gʊaa b'a dam ma, an hɔ yɩ, kʊ Woso bɛɛ y'a ka ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Awɔɔ mɩŋŋɔɔ m mɔɔ kasɛtɩzannɔ kan hɔ kʊ mɔɔ hɩ bɩ kɩ: mɔɔ ʊ *Krista bɛɛ m mɔɔ nɩ y, bɩ mɔɔ n yɩ m nyɔɔ kʊ m lɛɛ ka a lɛɛ. ");
INSERT INTO bib_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Gʊaa k'a nɩ lʊ bɩ m bɩ, bɩ n a zim. Lʊzaa bɩ gʊaasɩba bɩ, jɩm an nawʊm b'ʊ, an n'a tʊr karɛ. Heernyɔɔ n a heer han lʊzaa bɩ leer k'a n'a mam bɩ minto. Mɔɔ heernyɔɔ bɩ n naa, a mɩŋŋa paan…. ");
INSERT INTO bib_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Pakra m k'a wɩsɩrabaa n bɩr a dam la, kʊ mɔɔ n bɩr m bɔm lɛ.» ");
INSERT INTO bib_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Gʊaa k'a a to brama an bʊr bɩ lɛ da hɔ haay ra. Bɔ y'a to tara ʊ bɩ, tara burə gʊaa m, an nɩ tara burə mim dɩndam. Gʊaa k'a a to brama bɩ, ");
INSERT INTO bib_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","hɔ k'a yɩ, an a ma sɔ bɩ kasɛtɩ an n'a kam. Bɩ gɔsɩ bɩr a kasɛtɩ bɩ sire y. ");
INSERT INTO bib_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Gʊaa k'a n'a kasɛtɩ bɩ sim bɩ, a sɩra ka an n'a hɩrɛ, a ʊ: Woso bɩ sɩrazaa m. ");
INSERT INTO bib_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Sɩra m, gʊaa kʊ Woso a nyɔɔ bɩ, Woso lemim an n'a hɩm. Bala, Woso *Sɛnt-Ɛspri ka ʊ, b'a jire ba ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Zɩ Woso a Nyɩ ŋʊa, an hɔ haay sa, an a zar a wɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Gʊaa k'a nɩ sɩra kam Nyɩ b'ʊ, a ɩ *mɩsɩrbaa k'a nyarɛ ba ʊ bɩ m. Gʊaa k'a kaanm Nyɩ bɩ nɩ, a bɩ mɩsɩrbaa yɩrɛ y, bɩ Woso heerbusu gɔɔtarɛ a mim ʊ. ");
INSERT INTO bib_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kʊ Yeezuu b'a dɔ a ʊ, farizɛɛnrɔ wɔɔ a ma, ŋn'a dɩndarɛ ŋ ʊ, a ɩ *karɩndanyɩnɔ yɩm gʊta, an nɩ *batɛm karɛ an lɛ da Zaan ra bɩ, ");
INSERT INTO bib_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","3","a a hʊr Zidee kʊ ʊ, an a bɔ, an ta Galilee kʊ ʊ. Kʊ sɩra nɩ, Yeezuu mɩŋŋa bɩr batɛm karɛ y, a karɩndanyɩnɔ wɔɔ n'a kam. ");
INSERT INTO bib_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Bɩ pakra m, k'an aa bɔ Samarii ʊ. ");
INSERT INTO bib_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","A yɩ ncɩnaaʊ, ŋn'aa lee ku Samarii kʊ deem kʊ n n'a birm Sikaar bɩ nɔ ʊ. A bɩ laatʊ tara kʊ Zakɔɔb a ka a nyɩ Zozɛf ʊ biisi bɩ ma y. ");
INSERT INTO bib_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Bɩncɛ bɩ do Zakɔɔb hiyəə bɩ n ta ʊ. Yeezuu k'a ta, an kɔ bɩ, a nyɩnta hiyəə bɩ lɛ ra. Nyɩnta a ʊ sinsebir ʊ. ");
INSERT INTO bib_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samarii kʊ lʊ deem n bʊr k'a bɩ hi kusi. Yeezuu n a hɩ m, a ʊ: «Hi bɩ kusi, ɩ ka m ʊ, kʊ m a mi!» ");
INSERT INTO bib_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Bɩ ma bɩ, a karɩndanyɩnɔ wɔɔ ta tara nɔ ʊ, k'a yaa hɔbɩrɛ si. ");
INSERT INTO bib_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samarii kʊ lʊ bɩ n a hɩ m, a ʊ: «A ba a ʊ lɔ, ɩbɩɩ k'ɩ m zɩɩfʊ, ɩbɩɩ nɩ hi yɛm mɔɔ han k'ɩ mi, bɩ Samarii kʊ lʊ n mɔɔ nɩ?» Kʊ sɩra nɩ, zɩɩfʊrɔ wɔɔ bɩr kʊ mam kan Samarii zannɔ wɔɔ kɩ y. ");
INSERT INTO bib_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Kʊ Woso ganwʊrɛ ɩbɩɩ dɔ, kan gʊaa k'a n'a hɩrɛ ɩbɩɩ m, a ʊ: ɩ hi kusi, ɩ ka m ʊ kʊ m a mi naa kɩ, ɩbɩɩ y'ɩ ga m, ɩ yɛ han, an hi k'a nɩ mɩsɩrbaa kam bɩ ka ɩ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Lʊ bɩ n a hɩ m, a ʊ: «M Zuuba, poko ba ɩbɩɩ ʊ, ɩ n bɩ hi bɩ kusim nɩ y. Bɩ hiyəə bɩ nɔ ta sɔ. Ɩbɩɩ ɩ hi mɩŋŋa bɩ do m ka? ");
INSERT INTO bib_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Lɛ ɩbɩɩ da wɔɔ yaaba Zakɔɔb k'a hiyəə naa do ka wɔɔ ʊ bɩ n na? A mɩŋŋa bɛɛ y'a mi kan a nyɩnɔ kɩ, a hɔbɩsɩrɔ kɩ ra?» ");
INSERT INTO bib_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Gʊaa k'a nɩ hi naa do mire, mɩsɩ y'a yarɛ an a zɛ. ");
INSERT INTO bib_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Bɩ, gʊaa niŋŋə k'a nɩ hi kʊ mɔɔ n n'a kaŋ ʊ bɩ mim bɩ, mɩsɩ b'a yarɛ an gʊaa bɩ do zɛ fɩɩga y. Hi kʊ mɔɔ n n'a kaŋ ʊ bɩ y'a bam hi mɩnyaa a mɩsɩrbaa nɔ ʊ, an bɩr surm, an *mɩsɩrbaa k'a nyarɛ ba ʊ bɩ ka ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Lʊ bɩ n a hɩ m, a ʊ: «Zuuba, hi bɩ do ka m ʊ, kʊ mɩsɩ b'a ya, an m zɛ y, kʊ m bɩ m ya, m bɩ hi kusi naa ʊ y.» ");
INSERT INTO bib_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeezuu n a hɩ m, a ʊ: «Ta ɩ yaa ɩ zim bɩ bir, k'ɩ ɩ bɔ ɩ bʊr naa ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Lʊ bɩ n a nyɩ bɔ nʊ, a ʊ: «Mɔɔ zim ba ʊ y.» ");
INSERT INTO bib_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yeezuu n a hɩ m, a ʊ: «Ɩ gumə ta ʊ, ɩ ʊ, ɩ zim ba ʊ y. Ɩbɩɩ zino nyɩnta ʊ soor, bɩ gʊaa k'ɩbɩɩ nɩ kan kɩ naa ma bɩ, ɩbɩɩ zim bɛɛ y. Bɩ nɔ ʊ bɩ, ɩ sɩra hɩ.» ");
INSERT INTO bib_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Lʊ bɩ n a hɩ m, a ʊ: «Zuuba, mɔɔ dɔ kɛɛrɛ, mɔɔ ʊ: *wosolɛsinnɩsorazaa n'ɩbɩɩ m. ");
INSERT INTO bib_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wɔɔ yaabɔɔ Woso da ʊ ci naa do mim ʊ, awɔɔ n bɔkarɛ a hɩ, a ʊ, Woso daʊrɛ bɩncɛ bɩ m Zerizalɛm m.» ");
INSERT INTO bib_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeezuu n a hɩ m, a ʊ: «Sɩra ka mɔɔ ʊ, lʊ, wakatɩ ɩ zɛm, awɔɔ b'a yarɛ a Zɩ Woso da ʊ ci naa do mim ʊ, bɩ Zerizalɛm nɩ y. ");
INSERT INTO bib_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hɔ k'awɔɔ n a dɔ b'awɔɔ n'a daŋ ʊ. Hɔ kʊ wɔɔ dɔ bɩ wɔɔ n'a daŋ ʊ. Bʊmbɔrɛzaa bɩ, a to an nawʊm zɩɩfʊrɔ barla. ");
INSERT INTO bib_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bɩ dɔmɩm ɩ zɛm, b'a lee ku kɛɛrɛ. Zɩ Woso daʊrɛ zannɔ paan…rɔ wɔɔ Zɩ bɩ daŋ ʊ a heer ʊ kan sɩra kɩ. Gʊɔɔ ncɩnaaʊ rɔ wɔɔ Zɩ Woso lɛ n taa ŋ ma. ");
INSERT INTO bib_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Woso naa, Ɛspri m, bɩ minto y'a ka, gʊɔɔ kʊ ŋ n'a daŋ ʊ rɔ wɔɔ a ga m, ŋn'a da ʊ a heer ʊ kan sɩra kɩ.» ");
INSERT INTO bib_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Lʊ bɩ n a hɩ m, a ʊ: «Mɔɔ dɔ mɔɔ ʊ, *Mesii kʊ n n'a birm *Krista bɩ zɛm. K'a bɩ bʊr, a hɔ haay hɩm wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeezuu n a hɩ m, a ʊ: «A m mɔɔ m, mɔɔ nɩ meer bam kan ɩbɩɩ kɩ naa.» ");
INSERT INTO bib_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lɛɛm bɩ, karɩndanyɩnɔ wɔɔ lee ku. Ŋ n zɛ kədə, kʊ ŋ Yeezuu yɩ, an nɩ meer bam kan lʊ kɩ bɩ minto. Bɩ, gɔsɩ n a lar, a ʊ: «Bɔ ɩ n'ɩ kam ma gɛ?» gɛɛ «Bɔ minto ɩ nɩ meer bam kan kɩ gɛ?» ");
INSERT INTO bib_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Lʊ bɩ n a gʊ a gər bɩ ma, an ta tara nɔ ʊ, an aa a hɩ gʊɔɔ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«K'a bʊr a dɩga gʊaa k'a hɔ kʊ mɔɔ ba haay bɩ hɩ mɔɔ m. *Krista bɛɛ m barɛm na?» ");
INSERT INTO bib_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Gʊɔɔ wɔɔ n bɔ tara nɔ ʊ b'ʊ, ŋnɩ ta zi. ");
INSERT INTO bib_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Dɔmɩm bɩ do ʊ bɩ, a karɩndanyɩnɔ wɔɔ ɩ mam ma, ŋ ʊ: «Karɩnsaamba, hɔbɩrɛ bɩ bɩ.» ");
INSERT INTO bib_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","A n a hɩ ŋ nɩ, a ʊ: «Hɔbɩrɛ niŋŋə n ta ʊ mɔɔ nɩ m ga m, m a bɩ, b'awɔɔ n a dɔ y.» ");
INSERT INTO bib_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Karɩndanyɩnɔ wɔɔ n a hɩ kʊ m, ŋ ʊ: «Gʊaa ɩ hɔbɩrɛ ka ʊ, an a bɩ gɛ?» ");
INSERT INTO bib_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mɔɔ hɔbɩrɛ bɩ ba n nɩ: Woso mɔɔ nyɔɔ kʊ m b'a hɔɔnhɔ ba, kan a zibəə kɩ, m a nya. ");
INSERT INTO bib_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Awɔɔ n a hɩ a zim a ʊ, a gɔɔta mom si mɔsa n n'a kum na? Bɩ mɔɔ y'a hɩrɛ awɔɔ m, k'a a bɔɔta a dɩga: Wuturo wɔɔ a ba fu mɔsa minto. ");
INSERT INTO bib_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Zibəəzaa b'a zibəə nyɔɔdʊ yɩ, an n'a hɔnyɩ bɩ som kʊ ma *mɩsɩrbaa k'a nyarɛ ba ʊ bɩ minto. Bɩ y'a ka, gʊaa k'a nɩ hɔ duum kan gʊaa k'a nɩ hɔ som kʊ ma bɩ kɩ y'a heer nyɔɔm kan kʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bɩ y'a ka, hɔ kʊ bɔɔr naa do a hɩ bɩ sɩra m, a ʊ: gʊaa deem ɩ hɔ duure, gʊaa vanta n nɩ zɛm b'a da. ");
INSERT INTO bib_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mɔɔ awɔɔ nyɔɔ k'a yaa hɔ k'awɔɔ n a zi ba bɩ da. Gɔsɩnnɔ kɔrɛ yɩ a nɔ ʊ. Awɔɔ n bʊr an n'a nyɔɔdʊ bɩrɛ.» ");
INSERT INTO bib_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kʊ bɩ do nɔ ʊ, Samarii gʊɔɔ gʊta sɩra ka ʊ, lʊ bɩ kasɛtɩkarɛ naa do minto. «A hɔ haay kʊ mɔɔ ba bɩ hɩ mɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kʊ ŋ yaa lee ku zi sɔ bɩ, Samarii zannɔ wɔɔ, ŋ y'a yɛ han k'an gɔɔta kan a kɩ. A n gɔɔta b'ʊ dɔmɩm hɩɩya. ");
INSERT INTO bib_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gʊɔɔ kʊ ŋ y'a ya, ŋnɩ sɩra ka ʊ a mɩŋŋa meerbaa bɩ minto bɩ, ŋ gʊta ŋnɩ lɛ da biisi ra. ");
INSERT INTO bib_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ŋ n'a hɩm lʊ bɩ m, ŋ ʊ: ɩbɩɩ n a hɩ bɩ minto bala bɛɛ y'a ka wɔɔ n sɩra ka ʊ y. Wɔɔ mɩŋŋɔɔ a lɛ meerbaa ma, bɩ wɔɔ dɔ sɔ, sɩra m, durnya bʊmbɔrɛzaa bɩ m. ");
INSERT INTO bib_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Dɔmɩm hɩɩya k'a cem bɩ, Yeezuu a hʊr bɩncɛ bɩ do ʊ, an ta Galilee ʊ. ");
INSERT INTO bib_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Bala, a mɩŋŋa nyɩnta an a hɩ, a ʊ, *wosolɛsinnɩsorazaa bɩr daʊrɛ yɩm mɩŋŋa a kʊ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bɩ, k'a lee ku Galilee ʊ bɩ, Galilee zannɔ wɔɔ a si mɩŋŋa. Nyɩnta ŋ y'a ʊ, ŋnɩ ta Zerizalɛm ʊ cibsa bɩ minto. Ŋ mɩŋŋɔɔ hɔ kʊ Yeezuu a ba haay bɩ yɩ sɔ. ");
INSERT INTO bib_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yeezuu n a bɔ, an bʊr Kanaa ʊ Galilee kʊ ʊ. Bɩncɛ bɩ do a hi ba ʊ dɩvɛn bɩ. *Rɔm cir zibəəzaa jɩtaarɛ deem ɩ nyɩnta Kapɛrnawum ʊ, a nyɩ bɩ laafɩɩ y. ");
INSERT INTO bib_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","K'a a ma, ŋ ʊ, Yeezuu a to Zidee ʊ, an bʊr Galilee ʊ bɩ, a bʊr an b'a yɩ, an a yɛ han, k'an b'a nyɩ k'a n'a bam k'a ga bɩ waa. ");
INSERT INTO bib_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeezuu n a hɩ m, a ʊ: «K'awɔɔ n *makrarɔ yɩ kan hoserlo kɩ, awɔɔ bɩ sɩra kam fɩɩga ra!» ");
INSERT INTO bib_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Zibəəzaa jɩtaarɛ bɩ n a hɩ m, a ʊ: «Zuuba, bʊr kʊ n bɛɛ m, mɔɔ nyɩ bɩ gam.» ");
INSERT INTO bib_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeezuu n a hɩ m, a ʊ: «Ta, ɩ nyɩ bɩ mɩsɩr.» Gʊaa bɩ do sɩra ka Yeezuu meerbaa b'ʊ, an a wusigə. ");
INSERT INTO bib_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","K'a nɩ doom bɩ, a zibəənyɩnɔ b'a zɛ ʊ, ŋn'a hɩ, ŋ ʊ: «Ɩ nyɩ bɩ mɩsɩr!» ");
INSERT INTO bib_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A n ŋ lar, a ʊ, wakatɩ kara a waa ma gɛ? Ŋ n a nyɩ bɔ nʊ, ŋ ʊ: «Jim sinuu wakatɩ deem ma mɛmarɛ bɩ zer ma.» ");
INSERT INTO bib_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nyɩ bɩ zɩ bɩ dɩga a sɔ wakatɩ bɩ do Yeezuu a hɩ a m, a ʊ: «Ɩ nyɩ bɩ mɩsɩr.» Dɔmɩm bɩ do tɛkka ma, a sɩra ka Yeezuu ʊ, a mɩŋŋa kan a har gʊɔɔ kɩ haay. ");
INSERT INTO bib_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yeezuu hoser k'a ba a hɩɩya hɔ ma, a to k'a ʊ Zidee ʊ an ta Galilee ʊ bɩ n naa do. ");
INSERT INTO bib_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bɩ jɛ ʊ bɩ, Yeezuu ta Zerizalɛm ʊ, zɩɩfʊrɔ wɔɔ cibsa deem ma. ");
INSERT INTO bib_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Zerizalɛm ʊ b'ʊ bɩ, lɛɛ nɩ b'ʊ hi m ta ʊ, seero cɛ lɛ jɩr ʊ, ŋn'a birm *ebree lemim m Bɛtzata. A gasʊjɩrɔ soor gʊta-gʊta, n n a dɔ jaarɔ m. ");
INSERT INTO bib_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bɩncɛ bɩ do gʊɔɔ yaabazannɔ nɩ wʊtarɛ a taa, bʊʊrɔ, lʊgɔrɔ kan mɛgarɛzannɔ kɩ.  ");
INSERT INTO bib_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bala, Zuuba Malɛɛka deem ɩ tɩr zer dɔmɩm niŋŋoo ʊ hi b'ʊ, an heer ba ma. Yaabazaa k'a lɛɛ ka, an gasʊ hi bɩ heerbarɛ jɛ ʊ bɩ, laafɩɩ an n'a yɩrɛ, baa k'a yaaba bɩ lʊnlɔ. ");
INSERT INTO bib_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gʊaa ɩ nyɩnta b'ʊ, an nɩ yaaba m, a yaaba bɩ dɔɔraa bukərku a yaa sinnyə. ");
INSERT INTO bib_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yeezuu n a yɩ, an nɩ wʊtam, bɩ k'a a ma ŋ ʊ, a yaaba bɩ maasɩrɛ ba bɩ, a a lar, a ʊ: «Ɩ lɛ taa k'ɩ waa gɛ?» ");
INSERT INTO bib_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yaabazaa bɩ n a nyɩ bɔ nʊ, a ʊ: «Zuuba, mɔɔ ba gʊaa m, an nɩ mɔɔ gasʊm hi b'ʊ, a heer barɛ dɔmɩm ʊ y. Kʊ mɔɔ kʊ m gasʊ, gʊaa nɩ lɛɛ kam mɔɔ lɛɛ.» ");
INSERT INTO bib_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeezuu n a hɩ m, a ʊ: «Wuti, ɩ ɩ wʊtarahɔ bɩ sa, ɩ ta.» ");
INSERT INTO bib_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lɛɛm bɩ, gʊaa b'a waa, an a wʊtarahɔ bɩ sa, an nɩ tarɛ. Hinni bɩ do ʊ bɩ, *sabaa hinni m. ");
INSERT INTO bib_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Zɩɩfʊrɔ jɩtannɔ wɔɔ n a hɩ gʊaa k'a waa bɩ m, ŋ ʊ: «Sabaa hinni m, a n a ga m, ɩbɩɩ n ɩ wʊtarahɔ bɩ busu y.» ");
INSERT INTO bib_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Gʊaa bɩ n a nyɩ bɔ ŋ nʊ, a ʊ: «Gʊaa k'a laafɩɩ ka mɔɔ ʊ bɩ y'a hɩ mɔɔ m, a ʊ: ɩ wʊtarahɔ bɩ sa, ɩ ta.» ");
INSERT INTO bib_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ŋ n a lar, ŋ ʊ: «Gʊaa bɩ kara ɩ naa hɩ ɩbɩɩ nɩ, a ʊ, ɩ ɩ wʊtarahɔ bɩ sa, ɩ ta?» ");
INSERT INTO bib_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bɩ, gʊaa k'a laafɩɩ yɩ bɩ n a dɔ kʊ nka ɩ laafɩɩ bɩ ka a ʊ y. Bala, Yeezuu a gʊ gʊɔɔ kʊ ŋ nyɩnta b'ʊ rɔ wɔɔ ma laatʊ. ");
INSERT INTO bib_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bɩ jɛ ʊ bɩ, Yeezuu b'a yɩ *Wosocɛ ʊ, an a hɩ m, a ʊ: «Ba ɩbɩɩ laafɩɩ yɩ kɛɛrɛ na. Ɩ b'ɩ ya, ɩ mimbʊnyaa ba y, mim y'a ɩ yɩ, an lɛ da biisi hɔ naa ra.» ");
INSERT INTO bib_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Gʊaa bɩ n ta an aa a dɩnda zɩɩfʊrɔ jɩtannɔ wɔɔ m, a ʊ, Yeezuu y'awɔɔ waa bɩ. ");
INSERT INTO bib_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bɩ y'a ka, jɩtannɔ wɔɔ nɩ nyaa m kan Yeezuu kɩ k'a naa ba sabaa hinni b'ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Mɔɔ Zɩ gɔɔta an nɩ zi bam, mɔɔ y'a bam sɔ.» ");
INSERT INTO bib_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Bɩ y'a ka, brɔɔ n'a kam ma, k'a zɛ gər, k'a nɩ zi bam sabaa hinni ʊ bɩ bɛɛ bala y, k'a nɩ Woso birm a Zɩ, an a mɩŋŋa sa, an a ga kʊ ʊ kan kɩ bɩ minto m sɔ. ");
INSERT INTO bib_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeezuu meerbaa bɩ sa, an a hɩ, a ʊ: «Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m: Woso Nyɩ bɩ b'a dam ma, an hɔsɩ ba a mɩŋŋa paŋŋa nɩ y. K'a Zɩ Woso bɩ yɩ, an hɔ niŋŋə ba, b'a ba. Bala, hɔ kʊ Zɩ n'a bam bɩ, bɩ Nyɩ n'a bam sɔ. ");
INSERT INTO bib_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kʊ Zɩ a Nyɩ ŋʊa bɩ, a hɔ k'a n'a bam bɩ hɩnkam nɩ haay. A zibəə gʊta hɩnkam nɩ, an lɛ da nawɔnnɔ ra, awɔɔ m zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kʊ Zɩ bɩ nɩ gəəno mɩm bɔŋ ʊ an nɩ mɩsɩrbaa karɛ ŋ ʊ bɩ, Nyɩ bɩ, gʊaa k'a lɛ n taa b'a nɩ mɩsɩrbaa kaŋ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Zɩ bɩ bɩr gʊaa dʊdɔ karɛ y. A dʊdɔkarɛ haay sa an a ka a Nyɩ b'ʊ, ");
INSERT INTO bib_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kʊ gʊaa haay n a da ma, an Nyɩ bɩ da ʊ amba ŋn'ɩ Zɩ bɩ daŋ ʊ bɩ m. Gʊaa k'a bɩr Nyɩ bɩ daŋ ʊ bɩ, a bɩr Zɩ k'a Nyɩ bɩ nyɔɔ bɩ daŋ ʊ sɔ y. ");
INSERT INTO bib_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, gʊaa k'a n'a tʊr kam mɔɔ lemim ma, an nɩ Zɩ k'a mɔɔ nyɔɔ bɩ mim sire, a ɩ *mɩsɩrbaa k'a nyarɛ ba ʊ bɩ m. Ŋ b'a dʊdɔ karɛ y. Bɔ a ʊ zɛ nɔ ʊ, an ta mɩsɩrbaa nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, wakatɩ ɩ zɛm, b'a lee ku kɛɛrɛ. Gʊɔɔ kʊ ŋ gɩnga rɔ wɔɔ Woso Nyɩ bɩ leer mam, bɩ gʊɔɔ kʊ ŋ y'a ma rɔ wɔɔ y'a mɩm bɔŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bala, kʊ Zɩ b'a so mɩsɩrbaa ʊ bɩ, a a ka, k'a Nyɩ bɩ n nyɩnta mɩsɩrbaasoʊrezaa sɔ. ");
INSERT INTO bib_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Woso paŋŋa ka ʊ k'an dʊdɔ ka, k'a m *Gʊaanyɩ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","A bɩ zɛ kədə naa haay tɔ ma y! Wakatɩ ɩ zɛm gəəno wɔɔ y'a leer mam. ");
INSERT INTO bib_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Gʊɔɔ kʊ ŋ y'a mɩŋŋa ba rɔ wɔɔ y'a mɩm bɔŋ ʊ, ŋnɩ mɩsɩrbaa yɩ. Gʊɔɔ kʊ ŋ y'a bʊnyaa ba rɔ wɔɔ, ŋ y'a mɩm bɔŋ ʊ, ŋnɩ ŋ dʊdɔ ka. ");
INSERT INTO bib_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mɔɔ bɩ m dam ma, m hɔsɩ ba, m mɩŋŋa paŋŋa nɩ y. Hɔ kʊ mɔɔ n'a mam bɩ mɔɔ n'a dʊdɔ kam, bɩ mɔɔ dʊdɔkarɛ bɩ tɩrga, bala, mɔɔ bɩr m karɛ m mɩŋŋa hɔɔnhɔ ma y. Zɩ k'a mɔɔ nyɔɔ bɩ hɔɔnhɔ mɔɔ n nɩ m kam ma. ");
INSERT INTO bib_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kʊ m mɩŋŋa kasɛtɩ mɔɔ n'a karɛ, n bɩ mɔɔ kasɛtɩ bɩ sire y. ");
INSERT INTO bib_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Woso nɩ mɔɔ kasɛtɩ kam, bɩ mɔɔ dɔ sɔ kasɛtɩ niŋŋə k'a n'a kam mɔɔ minto bɩ, sɩra m. ");
INSERT INTO bib_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Awɔɔ gʊɔɔ nyɔɔ Zaan zi, b'a sɩra kasɛtɩ ka. ");
INSERT INTO bib_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mɔɔ bɩr m kam gʊaa kasɛtɩ ma y. Meer bɩ ba mɔɔ nawʊm ncɩnaaʊ, k'a bʊmbɔrɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zaan nyɩnta amba fɩtɩrɛ kʊ n nɩ sɛ nyaŋ ʊ, an nɩ yɔm bɩ m. Bɩ, awɔɔ ŋʊa mɩŋŋa k'a a heer nyɔɔ dɔmɩm poore ʊ, a lɛɛgure b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mɔɔ ɩ kasɛtɩ m, a gʊtabaa n lɛ da Zaan hɔ bɩ ra. Zibəəro kʊ Zɩ a ka mɔɔ ʊ kʊ m ŋ ba rɔ wɔɔ m. Mɔɔ yɩ ŋ bam, bɩ brɔɔ nɩ mɔɔ kasɛtɩ karɛ, ŋ ʊ, Zɩ b'ɩ mɔɔ nyɔɔ. ");
INSERT INTO bib_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Zɩ k'a mɔɔ nyɔɔ bɩ nɩ mɔɔ kasɛtɩ kam. B'awɔɔ n a leer ma, b'awɔɔ n a meer yɩ sɔ y. ");
INSERT INTO bib_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Woso lemim bɩr gɔɔtarɛ awɔɔ heer ʊ y, bala, awɔɔ n sɩra ka gʊaa k'a nyɔɔ b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","*Wosoci karɩnda awɔɔ n'a bam, an n'a hɔɔn darɛ, a ʊ, bɩ nɔ awɔɔ n nɩ *mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩŋ ʊ. Bɩ, bɩ nɩ mɔɔ kasɛtɩ kam. ");
INSERT INTO bib_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Awɔɔ lɛ baa k'a bʊr mɔɔ zi k'a mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩ y. ");
INSERT INTO bib_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mɔɔ bɩr m kam lɛbɔʊrɛ ma gʊɔɔ zi y. ");
INSERT INTO bib_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Bɩ mɔɔ awɔɔ dɔ, awɔɔ n Woso ŋʊa y. ");
INSERT INTO bib_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bʊr mɔɔ ʊ, m Zɩ tɔ ma, b'awɔɔ kaanm mɔɔ m. Kʊ gʊaa vanta ɩ bʊr a mɩŋŋa tɔ ra, awɔɔ y'a sim. ");
INSERT INTO bib_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Awɔɔ y'a bam lɔ a si, awɔɔ k'a n'a kam daʊrɛ ma a muno zi, a bɩr a kam daʊrɛ k'a a to Woso y'a deem bɩ zi bɩ ma? ");
INSERT INTO bib_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","A b'a hɔɔn da, a ʊ, mɔɔ n nɩ mim karɛ awɔɔ ra m Zɩ taa y. Hɔ k'a nɩ mim karɛ awɔɔ ra bɩ Moyiisi *lɛrɔ k'awɔɔ nɩ yure ŋ ma rɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kʊ nyɩnta awɔɔ ʊ a Moyiisi mim si, awɔɔ mɔɔ mim sim sɔ. Bala, a gʊrsɩra ba a ʊ mɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","K'awɔɔ n hɔ k'a gʊrsɩra ba bɩ si, awɔɔ y'a bam lɔ k'a hɔ kʊ mɔɔ n'a hɩm bɩ si?» ");
INSERT INTO bib_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bɩ jɛ ʊ bɩ, Yeezuu bra Galilee higʊta kʊ n n'a birm sɔ Tiberiyaadɩ higʊta bɩ gəm deem la. ");
INSERT INTO bib_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Gʊaa cir gʊta zu a jɛ ʊ, bala, gʊɔɔ wɔɔ hoserlo k'a nɩ ŋ bam, an nɩ yaabazannɔ waam nɔ wɔɔ yɩ. ");
INSERT INTO bib_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Gʊaa cir bɩ minto y'a ka, Yeezuu n der ci ra, an nyɩnta b'ʊ kan a karɩndanyɩnɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Bɩ ma bɩ, *pakkɩ k'a m zɩɩfʊrɔ wɔɔ cibsa b'a zɔ. ");
INSERT INTO bib_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kʊ Yeezuu a bɔɔta an dɩga bɩ, a gʊaa cir gʊta yɩ, an nɩ zɛm zi. A n a hɩ Filipi m, a ʊ: «K'ʊ bur yɩ ka, ʊ a si, kʊ ŋ n'a bɩ?» ");
INSERT INTO bib_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Meer bɩ ba a ʊ, ncɩnaaʊ k'a dɩga a. Hɔ k'a mɩŋŋa ʊ k'a ba bɩ, a a dɔ. ");
INSERT INTO bib_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi n a hɩ m, a ʊ: «Kʊ wɔɔ bur si *deniyee zɔɔhɩra nɩ, a bɩ bʊr bɔrɛ y, bala, gʊaa biyəə b'a kur yɩm poore y.» ");
INSERT INTO bib_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A *karɩndanyɩnɔ wɔɔ deem Sɩmɔɔn Pɩyɛɛr danzaa Andɩr a hɩ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Nyɩyar ɩ naa ʊ, an nɩ bur m soor, kan zɔnɔ kɩ hɩɩya. Bɩ, bɔ naa n n'a bam gʊaa cir naa nɩ?» ");
INSERT INTO bib_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yeezuu n a hɩ, a ʊ: «K'a ka kʊ ŋ nɩ nyɩnta.» Lɛɛ bɩ do ʊ bɩ, bur m jilli. Ŋ n nyɩnta. Gʊɔɔ cir bɩ gʊɔɔyaarɔ wɔɔ lɛ a zɔ tisi soor ma. ");
INSERT INTO bib_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yeezuu n bur bɩ si, an a barka da ʊ, an a ka gʊɔɔ wɔɔ ʊ. A n a ba maam sɔ zɔnɔ wɔɔ m. A n a ka ŋ ʊ amba ŋ lɛ taa bɩ m. ");
INSERT INTO bib_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kʊ ŋ y'a bɩ, an ŋ ka bɩ, Yeezuu a hɩ a karɩndanyɩnɔ wɔɔ m, a ʊ: «K'a kuuro kʊ ŋ gɔɔta rɔ wɔɔ so kʊ ma, a b'a ka deem m nyaam nɩ y.» ");
INSERT INTO bib_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ŋ n bur soor kʊ ŋ y'a bɩ rɔ wɔɔ kuuro so kʊ ma, ŋn'a zar kasɩ ʊ bueerehɩɩya. ");
INSERT INTO bib_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kʊ gʊɔɔ wɔɔ hoser k'a ba bɩ yɩ bɩ, ŋ y'a hɩ, ŋ ʊ: «*Wosolɛsinnɩsorazaa paan… k'a a ga m, an bʊr durnya ʊ bɩ m naa.» ");
INSERT INTO bib_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bɩ, Yeezuu k'a a dɔ a ʊ, n zɛm b'a nyasʊ, n n'a ba cir bɩ, a a hʊr a deem, an ta ci ra. ");
INSERT INTO bib_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yirbəə k'a da bɩ, karɩndanyɩnɔ wɔɔ ta higʊta lɛ ra. ");
INSERT INTO bib_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ŋ n da kɔɔlʊʊ ʊ, ŋn'ɩ tam Kapɛrnawum zeezi, gəm deem bɩ ra. Bɩ ma bɩ, gum da, bɩ Yeezuu n ŋ ku cɩna y. ");
INSERT INTO bib_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hɩnhɛr gʊta nɩ hɔnm, an nɩ hi bɩ wunwusigəm. ");
INSERT INTO bib_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kʊ ŋ ta, cilo soor gɛɛ sɔrdɩ bɩ, ŋ Yeezuu yɩ, an nɩ tam hi burə ʊ, an n'a zɔm kɔɔlʊʊ bɩ ma. Nyibəə n gasʊ ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yeezuu n a hɩ ŋ nɩ, a ʊ: «A da bɩ bɔ ʊ y, mɔɔ m!» ");
INSERT INTO bib_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ŋ y'a ŋʊa k'a busu kɔɔlʊʊ bɩ m. Lɛɛm bɩ, kɔɔlʊʊ bɩ bɩncɛ kʊ ŋ nɩ taŋ ʊ bɩ gəm ku. ");
INSERT INTO bib_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Dɔ k'a mɛ bɩ, gʊɔɔ kʊ ŋ gɔɔta kɔ bɩ lɛ ra rɔ wɔɔ kɔɔlʊʊ deem yɩ b'ʊ. Bɩ, Yeezuu n zu kʊ ʊ kan a karɩndanyɩnɔ wɔɔ kɩ ŋ kɔɔlʊʊ deem bɩ nɔ ʊ y. Ta brɔɔ ʊ a minto. ");
INSERT INTO bib_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kɔɔlʊʊrɔ y'a to Tiberiyaadɩ ʊ, ŋnɩ bʊr bɩncɛ kʊ Yeezuu bur bɩ barka da ʊ, ŋn'a bɩ bɩ jɩr ʊ. ");
INSERT INTO bib_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kʊ gʊɔɔ wɔɔ a yɩ Yeezuu ba b'ʊ, bɩ karɩndanyɩnɔ wɔɔ ba b'ʊ sɔ bɩ, gʊɔɔ wɔɔ da kɔɔlʊʊrɔ wɔɔ ʊ, ŋnɩ ta Kapɛrnawum ʊ k'a yaa a ka Yeezuu ma. ");
INSERT INTO bib_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kʊ ŋ yaa yɩ higʊta bɩ gəm deem la bɩ, ŋ y'a hɩ m, ŋ ʊ: «Karɩnsaamba, ɩbɩɩ lee ku naa ʊ brɔ?» ");
INSERT INTO bib_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Sɩra paan… mɔɔ n'a hɩrɛ, awɔɔ bɩr a kam mɔɔ ma k'awɔɔ hoserlo yɩ bɩ minto y, k'awɔɔ hɔbɩrɛ bɩ an a ka bɩ minto m. ");
INSERT INTO bib_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","A bɩ zi ba hɔbɩrɛ k'a n'a zarm bɩ minto y, k'a zi ba, a a ka hɔbɩrɛ k'a nɩ gɔɔtam an nɩ *mɩsɩrbaa k'a nyarɛ ba ʊ bɩ kam bɩ minto. Hɔbɩrɛ bɩ do, *Gʊaanyɩ bɩ n nɩ zɛm b'a ka awɔɔ ʊ, bala, a mɩŋŋa Zɩ k'a m Woso b'a mɩŋŋa jɩ da ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ŋ n a hɩ m, ŋ ʊ: «Bɔ wɔɔ n'a bam, k'ʊ Woso zi ba?» ");
INSERT INTO bib_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Woso zibəə bɩ, k'ɩ sɩra ka gʊaa k'a nyɔɔ b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ŋ n a hɩ m, ŋ ʊ: «Ncɩnaaʊ bɩ, hoser kara ɩbɩɩ n'a bam ʊ a yɩ, k'ʊ sɩra ka ɩbɩɩ ʊ? Ɩbɩɩ zibəə bɩ n kara? ");
INSERT INTO bib_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wɔɔ zɩrɔ hɔbɩrɛ kʊ n'a birm *mann bɩ bɩ poohɔɔn ʊ, amba n y'a gʊrsɩra ba bɩ m: ‹Bur a to arzana ʊ, an a ka ŋ ʊ, ŋn'a bɩ.› » ");
INSERT INTO bib_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, *Moyiisi bɛɛ arzana bur bɩ ka awɔɔ ʊ y. Mɔɔ Zɩ ɩ arzana bur paan… bɩ ka awɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bala, Woso bur bɩ m gʊaa k'a a to arzana ʊ an bʊr, an nɩ *mɩsɩrbaa kam durnya ʊ bɩ m.» ");
INSERT INTO bib_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ŋ n a hɩ m, ŋ ʊ: «Zuuba, bur bɩ do ka wɔɔ ʊ dɔmɩm haay!» ");
INSERT INTO bib_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mɔɔ m mɩsɩrbaa bur bɩ. Gʊaa k'a bʊr mɔɔ zi, nɔ b'a zaa zɛrɛ y. Gʊaa k'a sɩra ka mɔɔ ʊ, mɩsɩ b'a yarɛ an a zaa zɛ y. ");
INSERT INTO bib_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bɩ mɔɔ hɩ awɔɔ m: Awɔɔ mɔɔ yɩ, b'awɔɔ n sɩra ka mɔɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Gʊaa haay kʊ mɔɔ Zɩ n'a kam mɔɔ ʊ bɩ, ŋ zɛm mɔɔ zi, bɩ gʊaa k'a nɩ zɛm mɔɔ zi bɩ, mɔɔ bɩ kaanm nɩ y. ");
INSERT INTO bib_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bala, m to mɔɔ ʊ arzana ʊ kʊ m bɩ Zɩ k'a mɔɔ nyɔɔ bɩ hɔɔnhɔ ba, mɔɔ hɔ bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Zɩ k'a mɔɔ nyɔɔ bɩ hɔɔnhɔ bɩ, a lɛ baa kʊ gʊɔɔ k'a ŋ ka mɔɔ ʊ rɔ wɔɔ deem m nyaam nɩ y, kʊ m ŋ mɩm bɔ ʊ durnya nyarɛ hinni ʊ. ");
INSERT INTO bib_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mɔɔ Zɩ hɔɔnhɔ bɩ n naa: Gʊaa haay k'a Nyɩ bɩ yɩ, an sɩra ka ʊ bɩ, k'an mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩ. Bɩ mɔɔ y'a mɩm bɔŋ ʊ durnya nyarɛ hinni ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bɩ tɛkka ma, zɩɩfʊrɔ wɔɔ a sa ma, ŋn'ɩ kukur barɛ a minto. K'a a hɩ, a ʊ, a mɩŋŋa m bur k'a a to arzana ʊ a bʊr bɩ minto m. ");
INSERT INTO bib_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ŋ n a ya, ŋn'a hɩ, ŋ ʊ: «Yeezuu bɛɛ ra, Zozɛf nyɩ bɩ? Wɔɔ n a zɩ dɔ kan a da kɩ ra? A a ba lɔ kɛɛrɛ, an a hɩ, a ʊ, a to a ʊ arzana ʊ?» ");
INSERT INTO bib_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeezuu n a bɔ, an meerbaa bɩ sa, a ʊ: «K'a kukur barɛ bɩ to kan kʊ kɩ! ");
INSERT INTO bib_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Gʊaa b'a dam ma, an bʊr mɔɔ zi kʊ mɔɔ Zɩ k'a mɔɔ nyɔɔ bɩ n a gaa y. Bɩ, mɔɔ y'a mɩm bɔŋ ʊ durnya nyarɛ hinni ʊ. ");
INSERT INTO bib_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","N y'a gʊrsɩra ba *wosolɛsinnɩsorazannɔ ciro ʊ, n ʊ: ‹Ŋ haay hɔdɩndarɛ yɩm Woso zi.› Gʊaa niŋŋə k'a Woso lemim ma, an n'a hɔdɩndarɛ sim bɩ, zɛ an nawʊm mɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gʊaa ba ʊ an Zɩ yɩ y. Gʊaa k'a a to Woso zi an bʊr bɩ y'a yɩ bala. ");
INSERT INTO bib_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, gʊaa k'a nɩ sɩra kam bɩ, a ɩ mɩsɩrbaa k'a nyarɛ ba ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mɔɔ n bur k'a nɩ mɩsɩrbaa kam. ");
INSERT INTO bib_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Awɔɔ zɩrɔ *mann bɩ poohɔɔn ʊ, bɩ ŋ gɩnga. ");
INSERT INTO bib_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bur k'a a to arzana ʊ bɩ n naa. Gʊaa k'a bɩ a bɩ garɛ y. ");
INSERT INTO bib_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mɔɔ m bur mɩsɩr, m m to arzana ʊ. Gʊaa k'a bur bɩ do bɩ bɩ, a zaa bɩ gam fɩɩga y. Bur kʊ mɔɔ n n'a kam bɩ, m mɩŋŋa mɛsim m, m n n'a kam kʊ durnya n mɩsɩrbaa yɩ.» ");
INSERT INTO bib_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Naa do y'a ka, zɩɩfʊrɔ wɔɔ ŋ wuti bʊgʊr m kan kʊ kɩ, ŋ ʊ: «Naa y'a bam lɔ k'a mɛsim ka wɔɔ ʊ, k'ʊ a sʊ?» ");
INSERT INTO bib_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, k'awɔɔ n *Gʊaanyɩ bɩ sim sʊ, k'awɔɔ n a ma mi, awɔɔ bɩ mɩsɩrbaa yɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Gʊaa k'a mɔɔ sim sʊ, an mɔɔ ma mi b'ɩ mɩsɩrbaa k'a nyarɛ ba ʊ bɩ m, bɩ mɔɔ y'a mɩm bɔŋ ʊ durnya nyarɛ hinni ʊ. ");
INSERT INTO bib_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Bala, mɔɔ mɛsim bɩ, hɔbɩrɛ paan… m, mɔɔ ma bɩ, hɔmire paan… m sɔ. ");
INSERT INTO bib_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Gʊaa k'a mɔɔ sim sʊ, an mɔɔ ma mi, a zaa ɩ kan mɔɔ kɩ, mɔɔ nɩ kan a zaa kɩ. ");
INSERT INTO bib_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kʊ Zɩ k'an mɩsɩr bɩ mɔɔ nyɔɔ bɩ, bɩ mɩsɩrbaa ba mɔɔ nawʊm Zɩ bɩ minto bɩ, gʊaa k'a nɩ mɔɔ bɩm bɩ, mɔɔ y'a kam an mɩsɩrbaa ba sɔ. ");
INSERT INTO bib_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bur k'a a to arzana ʊ bɩ n naa. A bɩ hɔdeem kan awɔɔ zɩrɔ wɔɔ n a bɩ bɩ kɩ y. Ŋ gɩnga, bɩ gʊaa k'a bur naa do bɩ, a zaa bɩ garɛ y.» ");
INSERT INTO bib_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Minno nɔɔn duro Yeezuu a dɩnda gʊɔɔ m Kapɛrnawum sokʊmacɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Karɩndanyɩnɔ gʊta kʊ ŋ naa ma bɩ, ŋ y'a hɩrɛ, ŋ ʊ: «Meerbaa naa do kaŋŋɩda! Nka n'a dam ma, an a si?» ");
INSERT INTO bib_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeezuu k'a a dɔ a zim, a ʊ, a karɩndanyɩnɔ wɔɔ ɩ kukur bam mim naa do minto bɩ, a a hɩ ŋ nɩ, a ʊ: «Busu a ʊ awɔɔ ma ra? ");
INSERT INTO bib_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bɩ, k'awɔɔ bɔkarɛ a bɩ *Gʊaanyɩ bɩ yɩ an nɩ tam bɩncɛ k'a nyɩnta ʊ biisi b'ʊ? ");
INSERT INTO bib_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","*Ɛspri nɩ mɩsɩrbaa kam, mɛsim bɩ zibəə ba ʊ y. Meerbaarɔ kʊ mɔɔ hɩ awɔɔ m bɩ, Ɛspri m kan *mɩsɩrbaa kɩ. ");
INSERT INTO bib_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bɩ gʊɔɔ y'awɔɔ bire ʊ, ŋ n sɩra ka y.» Yeezuu lɛɛ ka, an gʊɔɔ kʊ ŋ n sɩra ka rɔ wɔɔ dɔ, kan gʊaa k'a nɩ zɛm b'a nyasʊ an a ka bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A a ya, an a hɩ, a ʊ: «Bɩ minto y'a ka, mɔɔ n a hɩ awɔɔ m, mɔɔ ʊ, gʊaa b'a dam ma, an bʊr mɔɔ zi kʊ Zɩ bɛɛ y'a bir y.» ");
INSERT INTO bib_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Dɔmɩm bɩ do tɛkka ma bɩ, *karɩndanyɩnɔ gʊta a bɔ a jɛ ʊ, ŋ n a ya, ŋn'ɩ zum kʊ ʊ kan kɩ y. ");
INSERT INTO bib_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yeezuu n a hɩ bueerehɩɩyɔɔ wɔɔ m, a ʊ: «B'awɔɔ, awɔɔ b'a gʊm mɔɔ ma sɔ ra?» ");
INSERT INTO bib_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sɩmɔɔn Pɩyɛɛr n a nyɩ bɔ nʊ, a ʊ: «Zuuba, k'ʊ ta nka zi? Ɩbɩɩ ɩ mɩsɩrbaa k'a nyarɛ ba ʊ bɩ meerbaarɔ m. ");
INSERT INTO bib_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Bɩ wɔɔ si, ʊ a dɔ sɔ, ʊ ʊ, ɩbɩɩ m Krista, Woso Nyɩ mɩŋŋa.» ");
INSERT INTO bib_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Mɔɔ bɛɛ y'awɔɔ gʊaa bueerehɩɩya bɩ bɔ ʊ ra? Bɩ, Sʊtaana y'a so awɔɔ gʊaa deem ʊ!» ");
INSERT INTO bib_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iskarɩyɔtɩ kʊ gʊaa Sɩmɔɔn nyɩ Zidas b'a n'a hɩm ma. Bala, a m bueerehɩɩyɔɔ wɔɔ gʊaa deem, an nɩ Yeezuu nyasʊrɛ, an a ka. ");
INSERT INTO bib_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bɩ jɛ ʊ bɩ, Yeezuu cem, an nɩ bɩmbɩrm Galilee kʊ ʊ, a n a ŋʊa k'a ta Zidee ʊ y, bala, zɩɩfʊrɔ jɩtannɔ wɔɔ y'a kam ma k'a zɛ gər. ");
INSERT INTO bib_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Bɩ ma bɩ, zɩɩfʊrɔ cibsa kʊ n n'a birm *buuro cibsa b'a zɔ. ");
INSERT INTO bib_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","A danyɩnɔ wɔɔ n a hɩ m, ŋ ʊ: «Ta Zidee ʊ, k'ɩ karɩndanyɩnɔ wɔɔ n'ɩ zibəəro k'ɩbɩɩ nɩ ŋ bam nɔ wɔɔ yɩ sɔ. ");
INSERT INTO bib_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kʊ gʊaa lɛ taa kʊ n n'a dɔ, a bɩr a zibəə bɩ nyaakʊm darɛ y. K'ɩbɩɩ nɩ zibəəro barɛ ncɩnaaʊ bɩ, ɩ hɩnka durnyazannɔ m.» ");
INSERT INTO bib_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yeezuu danyɩnɔ wɔɔ mɩŋŋɔɔ n sɩra ka ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mɔɔ wakatɩ n a ku cɩna y. B'awɔɔ wakatɩ m dɔmɩm haay m. ");
INSERT INTO bib_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Durnya bɩ sɔrɛ awɔɔ nɩ y, bɩ, a ɩ sɔm mɔɔ m, bala, kʊ mɔɔ n'a zibəə bɩ kasɛtɩ kam, mɔɔ ʊ, a bʊnyaa bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","K'a ta cibsa bɩ ma, mɔɔ bɩ tarɛ y. Bala, mɔɔ wakatɩ n a ku cɩna y.» ");
INSERT INTO bib_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","K'a meer bɩ ba ncɩnaaʊ bɩ, a gɔɔta Galilee ʊ. ");
INSERT INTO bib_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","K'a danyɩnɔ wɔɔ ta cibsa bɩ ma bɩ, a zaa sa sɔ, an a nyaakʊm da, an nɩ tam, a lɛ baa kʊ n a dɔ y. ");
INSERT INTO bib_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Cibsa bɩ dɔmɩm ʊ, zɩɩfʊrɔ jɩtannɔ wɔɔ y'a kam Yeezuu ma, ŋnɩ laaka da, ŋ ʊ: «A ɩ ka?» ");
INSERT INTO bib_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Gʊɔɔ wɔɔ bire ʊ, ŋ y'a mim dɩndarɛ: Gɔsɩnnɔ y'a hɩrɛ, ŋ ʊ: «Gʊaa mɩŋŋa m.» Gɔsɩnnɔ ʊ: «Ŋʊaarzaa m, bra an n'a bam gʊɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bɩ, gʊaa ba ʊ, an nɩ yɛrɛ, an n'a mim hɩm garga ra y. Bala, ŋ yɩ nyi barɛ a jɩtannɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kʊ *buuro cibsa bɩ bireyaa a ku bɩ, Yeezuu ta *Wosocɛ ʊ, an nɩ hɔ dɩndam gʊɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Zɩɩfʊrɔ wɔɔ zɛ kədə, ŋn'a hɩrɛ, ŋ ʊ: «A a ba lɔ an hɔ dɔ, b'a n karɩnda ba?» ");
INSERT INTO bib_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Mɔɔ hɔdɩndarɛ bɩ n a to mɔɔ zi y. A to a ʊ Woso k'a mɔɔ nyɔɔ bɩ zi. ");
INSERT INTO bib_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kʊ gʊaa lɛ taa k'a Woso hɔɔnhɔ ba, a y'a dɔm kʊ hɔdɩndarɛ naa do, k'a to a ʊ Woso zi, gɛɛ kʊ m mɩŋŋa mim mɔɔ n'a dɩndarɛ. ");
INSERT INTO bib_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Gʊaa k'a n'a mɩŋŋa mim dɩndam bɩ, a ka an nawʊrɛ a mɩŋŋa lɛbɔʊrɛ ma. Bɩ, gʊaa k'a n'a kam a gʊaa k'a a nyɔɔ bɩ lɛbɔʊrɛ ma bɩ, bɩ bala n sɩrazaa. Zambʊ b'a nɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moyiisi bɛɛ *lɛrɔ wɔɔ ka awɔɔ ra? B'awɔɔ gʊaa deem ba ʊ, an nɩ zum lɛrɔ wɔɔ ʊ y. Bɔ minto, an n'a kam mɔɔ garɛ ma?» ");
INSERT INTO bib_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Gʊɔɔ wɔɔ n a nyɩ bɔ ʊ, ŋ ʊ: «Zinə nɩ kan ɩbɩɩ kɩ! Nka y'a hɩ, a ʊ, k'a ɩbɩɩ zɛ?» ");
INSERT INTO bib_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeezuu a hɩ ŋ nɩ, a ʊ: «Zibəə deem mɔɔ ba *sabaa hinni ʊ, awɔɔ n zɛ kədə haay! ");
INSERT INTO bib_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyiisi *lɛ ka awɔɔ ʊ, k'a gʊɔɔ gasʊ baŋŋʊ ʊ. A to a ʊ awɔɔ yaabɔɔ zi Moyiisi mɩŋŋa bɛɛ bʊr nɩ y. Bɩ, k'a a da sabaa hinni ma, awɔɔ y'a bam. ");
INSERT INTO bib_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bɩ, k'a ɩ yɩrɛ ɩ ʊ, kʊ gʊaa gasʊ baŋŋʊ ʊ sabaa hinni ʊ, an bɔ Moyiisi lɛrɔ wɔɔ la nɩ, bɔ minto m, awɔɔ heer nɩ busum kan mɔɔ kɩ gʊaa kʊ mɔɔ waa haay sabaa hinni ʊ bɩ ma? ");
INSERT INTO bib_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","A bɩ hɔ k'awɔɔ n'a yɩm mɩm ʊ bɩ dʊdɔ ka bala y, k'a dʊdɔ ka kan sɩra kɩ.» ");
INSERT INTO bib_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Zerizalɛm gʊɔɔ y'a hɩrɛ, ŋ ʊ: «Gʊaa kʊ ŋ n'a kam ma k'a mee bɔ ʊ bɩ bɛɛ m naa ra? ");
INSERT INTO bib_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ba an nɩ meer bam ŋn'a mam na, bɩ ŋ bɩr hɔsɩ hɩm nɩ y! Wɔɔ tara bɩ lɛɛzannɔ wɔɔ, a dɔ ŋ y'a ʊ paan…, ŋ ʊ, *Krista m gɛ? ");
INSERT INTO bib_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wɔɔ gʊaa naa do tojɩ dɔ, kʊ *Krista bɩ bʊr, gɔsɩ b'a tojɩ dɔrɛ y.» ");
INSERT INTO bib_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yeezuu k'a nɩ hɔ dɩndam Wosocɛ ʊ b'ʊ b'a hɩ, a ʊ: «Awɔɔ mɔɔ dɔ! Awɔɔ mɔɔ tojɩ dɔ. Bɩ, mɔɔ n bʊr m zi nɩ y. Sɩrazaa m Zɩ k'a mɔɔ nyɔɔ bɩ m. B'awɔɔ n bɩ zaa dɔ y. ");
INSERT INTO bib_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mɔɔ mɩŋŋa a dɔ, m to mɔɔ ʊ zi, a ɩ mɔɔ nyɔɔ.» ");
INSERT INTO bib_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ŋ n'a kam ma k'a nyasʊ, bɩ gʊaa ba ʊ, an a wɔ da ma y. Bala, a wakatɩ n a ku cɩna y. ");
INSERT INTO bib_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gʊɔɔ nyɩnta zamaa bɩ bire ʊ, ŋnɩ sɩra ka ʊ, ŋn'a hɩrɛ, ŋ ʊ: «Kʊ *Krista bɩ bʊr, a hoserlo barɛ an lɛ da naa n a ba rɔ wɔɔ ra gɛ?» ");
INSERT INTO bib_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kukur kʊ n n'a bam Yeezuu minto gʊɔɔ wɔɔ bire ʊ bɩ, *farizɛɛnrɔ wɔɔ a ma. A m bɩ, *wosocɛmannɩbənno jɩtannɔ kan farizɛɛnrɔ kɩ n Wosocɛ dɔmazannɔ nyɔɔ kʊ ŋ n'aa a nyasʊ. ");
INSERT INTO bib_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yeezuu n a hɩ, a ʊ: «Mɔɔ gɔɔtam kan awɔɔ kɩ dɔmɩm poore nɔ ʊ, kʊ m bɩ m bɔ, m ta Zɩ k'a mɔɔ nyɔɔ bɩ zi. ");
INSERT INTO bib_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Awɔɔ zɛm b'a ka mɔɔ ma, b'awɔɔ bɩ mɔɔ yɩrɛ y. Bala, bɩncɛ kʊ mɔɔ nɩ taŋ ʊ bɩ, awɔɔ b'a dam ma a bʊr b'ʊ y.» ");
INSERT INTO bib_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bɩ jɛ ʊ bɩ, zɩɩfʊrɔ wɔɔ y'a hɩm kʊ m, ŋ ʊ: «Ta awɔɔ nawʊm ka, wɔɔ b'ʊ yarɛ ʊ a yɩ? Ta awɔɔ nawʊm gʊɔɔ kʊ ŋ hɩsɩga da ŋn'a war kʊ ma kan grɛkkɩrɔ kɩ rɔ wɔɔ zi ra? Gɛɛ, ta an nawʊm k'a yaa hɔ dɩnda grɛkkɩrɔ m na? ");
INSERT INTO bib_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Hɔ k'a hɩ naa jɩ lɛ taa k'a hɩ, a ʊ lɔ: Awɔɔ y'a kam mɔɔ ma, b'awɔɔ bɩ mɔɔ yɩrɛ y, bɩ bɩncɛ kʊ mɔɔ nɩ taŋ ʊ bɩ, awɔɔ b'a dam ma, a bʊr ʊ y?» ");
INSERT INTO bib_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Cibsa bɩ nyarɛ ma bɩ, dɔmɩm niŋŋə k'an dɔmɩm gʊta bɩ, Yeezuu jɩm brama, an a leer busu, an n'a hɩrɛ, a ʊ: «Gʊaa kʊ mɩsɩ n'a zɛm k'an bʊr mɔɔ zi, an bɩ hi mi. ");
INSERT INTO bib_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Gʊaa k'a sɩra ka mɔɔ ʊ bɩ, mɩsɩrbaa hi kɔyaarɔ y'a tom zi, amba *Wosoci a hɩ bɩ m.» ");
INSERT INTO bib_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","*Sɛnt-Ɛspri kʊ gʊɔɔ kʊ ŋ nɩ sɩra kaŋ ʊ rɔ wɔɔ n'a yɩm bɩ mim an n'a hɩm. Kʊ sɩra nɩ, Yeezuu k'a n lɛbɔʊrɛ yɩ cɩna bɩ, Sɛnt-Ɛspri n bʊr cɩna y. ");
INSERT INTO bib_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Gʊɔɔ kʊ ŋ nyɩnta, ŋn'a tʊr ka Yeezuu meerbaa bɩ ma gʊɔɔ cir bɩ bire ʊ rɔ wɔɔ, gɔsɩnnɔ y'a hɩrɛ, ŋ ʊ: «Sɩra m, ba wosolɛsinnɩsorazaa bɩ n na.» ");
INSERT INTO bib_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Gɔsɩnnɔ y'a hɩrɛ, ŋ ʊ: «*Krista bɩ n naa.» Gɔsɩnnɔ a ya, ŋn'a hɩrɛ, ŋ ʊ: «Krista y'a dam ma, an a to Galilee kʊ ʊ ra? ");
INSERT INTO bib_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wosoci n a hɩ, a ʊ, ‹bɔ an nawʊm Davɩd do nɔ ʊ›, b'a to an nawʊm tara poore kʊ Davɩd yɩ ʊ, ŋn'a birm Betelehɛm b'ʊ ra?» ");
INSERT INTO bib_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Naa do y'a ka, gʊɔɔ wɔɔ n a gʊngʊ a minto. ");
INSERT INTO bib_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ŋ gʊɔɔ gɔsɩnnɔ a ŋʊa k'a nyasʊ, bɩ gɔsɩ n a wɔ da ma y. ");
INSERT INTO bib_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wosocɛ dɔmazannɔ wɔɔ n a bɔ, ŋnɩ bʊr wosocɛmannɩbənno jɩtannɔ wɔɔ zi kan *farizɛɛnrɔ wɔɔ kɩ. Brɔɔ nɩ ŋ lar, ŋ ʊ: «Bɔ m awɔɔ n bʊr nɩ?» ");
INSERT INTO bib_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wosocɛ dɔmazannɔ wɔɔ n a nyɩ bɔ ʊ, ŋ ʊ: «Gʊaa ba ʊ an meer kʊ gʊaa naa do a ba bɩ lɔɔ ba y.» ");
INSERT INTO bib_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farizɛɛnrɔ wɔɔ n a hɩ ŋ nɩ, ŋ ʊ: «A to awɔɔ ʊ, an awɔɔ hɔɔn da a zi ra? ");
INSERT INTO bib_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Jɩtannɔ wɔɔ kan farizɛɛnrɔ wɔɔ kɩ barla bɩ, gʊaa deem taan… ta ʊ, an a mim si ra? ");
INSERT INTO bib_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bɩ, gʊaa cir naa do n *lɛrɔ wɔɔ dɔ y. Ŋ barka ba ʊ y!» ");
INSERT INTO bib_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodɛm k'a nyɩnta an ta Yeezuu zi bɩ nyɩnta kan ŋ kɩ, an a hɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«N n gʊaa dʊdɔ yar bɩ n n'a meerbaa ma kan hɔ k'a ba bɩ kɩ y. Wɔɔ lɛrɔ wɔɔ n bɩ hɩ ra?» ");
INSERT INTO bib_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Ɩ to ɩbɩɩ ʊ Galilee ʊ sɔ ra? Bɩ, ɩ ka mɩŋŋa, ɩbɩɩ bɩ *wosolɛsinnɩsorazaa yɩrɛ an bɩr Galilee gʊaa y.»  ");
INSERT INTO bib_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ŋ haay n a hʊr, ŋnɩ dundoo a harlɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yeezuu n a hʊr an ta Oliviyee ci mim ʊ. ");
INSERT INTO bib_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Dɔ k'a bʊr an nɩ mɛm bɩ, a a bɔ an bʊr *Wosocɛ ʊ b'ʊ, gʊaa haay nɩ zɛm zi, an nyɩnta, an nɩ hɔ dɩndarɛ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","*Wosocikarɩnsaambɔɔ kan *farizɛɛnrɔ kɩ bʊr lʊ m b'ʊ, ŋn'a da gʊɔɔ wɔɔ bire ʊ. Sʊr n y'a ʊ ra, an nɩ jaan darɛ. ");
INSERT INTO bib_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ŋ n a hɩ Yeezuu m, ŋ ʊ: «Karɩnsaamba, lʊ naa do, sʊr n y'a ʊ ra, an nɩ jaan darɛ. ");
INSERT INTO bib_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","*Lɛrɔ nɔ ʊ, Moyiisi a hɩ, a ʊ, n n lannɔ nɔɔn duro zɛ jaarɔ m. B'ɩbɩɩ, ɩbɩɩ ʊ lɔ?» ");
INSERT INTO bib_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","A hɩ ŋ nawʊrɛ ncɩnaaʊ k'a nyasʊ meerbaa nɔ ʊ, k'a ku a mim ka ra. Yeezuu a zuutə, an n'a nyʊkʊm wʊnwɔsɩm tara ʊ. ");
INSERT INTO bib_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kʊ ŋ gɔɔta ŋn'a larm bɩ, Yeezuu a bɔɔta, an a hɩ ŋ nɩ, a ʊ: «Gʊaa k'a n'awɔɔ bire ʊ, b'a n mimbʊnyaa ba cɩna bɩ n lɛɛ ka, an a gʊɛɛn.» ");
INSERT INTO bib_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","A n a ya, an a zuutə, an n'a nyʊkʊm bɩ wʊnwɔsɩm tara ʊ. ");
INSERT INTO bib_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kʊ ŋ meerbaa naa do ma bɩ, ŋ cem deem-deem. Gʊɔɔ marɛrɔ wɔɔ ɩ lɛɛ ka ŋnɩ cem, a poorero wɔɔ n a nya ŋ ʊ. Yeezuu n gɔɔta a deem. Kʊ lʊ bɩ gɔɔta an nɩ b'ʊ bɩ, ");
INSERT INTO bib_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yeezuu a bɔɔta, an a hɩ m, a ʊ: «Ŋ bee, lʊ ra? Gɔsɩ n'ɩbɩɩ dʊdɔ yar la?» ");
INSERT INTO bib_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A n a nyɩ bɔ ʊ, a ʊ: «Ayy…, Zuuba, gɔsɩ.» Yeezuu n a hɩ m, a ʊ: «Mɔɔ sɔ, mɔɔ b'ɩbɩɩ dʊdɔ yarlɛ y. Ta, b'ɩbɩɩ ɩ ya, ɩ mimbʊnyaa ba y.» ");
INSERT INTO bib_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yeezuu n a ya, an a hɩ ŋ nɩ, a ʊ: «Durnya lɛɛgure m mɔɔ m. Gʊaa k'a nɩ zum mɔɔ ʊ bɩ bɩ tam monsigə ʊ y. A mɩsɩrbaa lɛɛgure yɩm.» ");
INSERT INTO bib_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","*Farizɛɛnrɔ wɔɔ n a hɩ m, ŋ ʊ: «Ɩ mɩŋŋa kasɛtɩ ɩ n'a kam na? Ɩbɩɩ kasɛtɩ bɩ, ŋʊaar m.» ");
INSERT INTO bib_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Sɩra m, m mɩŋŋa kasɛtɩ mɔɔ n'a kam. Bɩ, mɔɔ kasɛtɩ bɩ sɩra m, bala, mɔɔ m tojɩ dɔ, m m tajɩ dɔ. B'awɔɔ, awɔɔ n a dɔ kʊ m to mɔɔ ʊ ka m nɩ tam ka y. ");
INSERT INTO bib_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Dʊdɔ awɔɔ n'a karɛ am gʊɔɔ hɔ bɩ m. Mɔɔ bɩr gʊaa dʊdɔ karɛ y. ");
INSERT INTO bib_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Baa kʊ mɔɔ ʊ kʊ m dʊdɔ ka, a ka mɔɔ nawʊm kan sɩra kɩ, bala, mɔɔ bɩ m deem nɩ y. Zɩ k'a mɔɔ nyɔɔ bɩ ta ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Awɔɔ mɩŋŋɔɔ *lɛrɔ wɔɔ nɔ ʊ, n y'a gʊrsɩra ba, n ʊ, gʊaa hɩɩya kasɛtɩ bɩ, sɩra m. ");
INSERT INTO bib_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","M mɩŋŋa kasɛtɩ mɔɔ n'a kam, bɩ Zɩ k'a mɔɔ nyɔɔ b'ɩ mɔɔ kasɛtɩ kam sɔ.» ");
INSERT INTO bib_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ŋ n a nyɩ bɔ nʊ, ŋ ʊ: «Ɩbɩɩ Zɩ b'ɩ ka?» Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Awɔɔ n mɔɔ dɔ y, b'awɔɔ n mɔɔ Zɩ dɔ sɔ y. Kʊ mɔɔ dɔ awɔɔ ʊ, awɔɔ mɔɔ Zɩ bɩ dɔm sɔ.» ");
INSERT INTO bib_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Meerbaarɔ nɔɔn duro ba Yeezuu ʊ bɩncɛ kʊ n nɩ busoo zarŋ ʊ b'ʊ, bɩ ma bɩ, a ɩ hɔ dɩndam Wosocɛ ʊ, gɔsɩ n a wɔ da ma y, bala, a wakatɩ n a ku cɩna y. ");
INSERT INTO bib_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeezuu n a ya, an a hɩ ŋ nɩ, a ʊ: «Cem mɔɔ n nawʊm, awɔɔ y'a kam mɔɔ ma, bɩ, gɩnga awɔɔ nawʊm a mimbʊnyaarɔ nɔ ʊ. Bɩncɛ kʊ mɔɔ nɩ taŋ ʊ bɩ, awɔɔ b'a dam ma, a ta b'ʊ y.» ");
INSERT INTO bib_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Zɩɩfʊrɔ wɔɔ n a hɩ, ŋ ʊ: «A ŋʊa an nawʊm k'a mɩŋŋa zɛ gɛ? K'a a hɩ, a ʊ: bɩncɛ kʊ mɔɔ nɩ taŋ ʊ bɩ, awɔɔ b'a dam ma a ta b'ʊ bɩ minto.» ");
INSERT INTO bib_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Tara burə naa gʊɔɔ n'awɔɔ m, bɩ, m to mɔɔ ʊ brama. Durnya naa gʊɔɔ n'awɔɔ m, bɩ, durnya naa do gʊaa bɛɛ m mɔɔ nɩ y. ");
INSERT INTO bib_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Bɩ y'a ka, mɔɔ n a hɩ awɔɔ m, mɔɔ ʊ, awɔɔ gɩngarɛ a mimbʊnyaarɔ nɔ ʊ. K'awɔɔ n a si, a ʊ: A n ta ʊ bɩ m mɔɔ m, awɔɔ gɩngarɛ a mimbʊnyaarɔ nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ŋ n a hɩ, ŋ ʊ: «Nka n'ɩbɩɩ nɩ?» Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Mɔɔ n'a mim hɩrɛ awɔɔ m tee… bɩ m. ");
INSERT INTO bib_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Awɔɔ minno ta ʊ gʊta, kʊ m ŋ hɩ awɔɔ m, kʊ m ŋ dʊdɔ ka. Zɩ k'a mɔɔ nyɔɔ bɩ, sɩrazaa m, bɩ hɔ kʊ mɔɔ ma zi bɩ, bɩ mɔɔ n'a hɩm durnya m.» ");
INSERT INTO bib_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ŋ n a dɔ, ŋ ʊ, Yeezuu bɩ, Zɩ Woso mim a a hɩ a nɩ y. ");
INSERT INTO bib_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Dɔmɩm niŋŋə k'awɔɔ nɩ *Gʊaanyɩ bɩ busuŋ ʊ bɩ, dɔmɩm bɩ do awɔɔ n n'a dɔrɛ, a ʊ: A n ta ʊ bɩ m mɔɔ m. Bɩ mɔɔ bɩr zi bam ŋ mɩŋŋa paŋŋa nɩ y. Hɔ kʊ mɔɔ Zɩ a dɩnda mɔɔ m bɩ mɔɔ n'a hɩm. ");
INSERT INTO bib_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Zɩ k'a mɔɔ nyɔɔ b'ɩ kan mɔɔ kɩ. A n mɔɔ to m deem nɩ y, bala, hɔ k'a ŋʊa bɩ mɔɔ n'a bam dɔmɩm haay.» ");
INSERT INTO bib_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","K'a nɩ meer bɩ barɛ ncɩnaaʊ bɩ, gʊɔɔ gʊta sɩra ka ʊ. ");
INSERT INTO bib_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yeezuu n a hɩ zɩɩfʊrɔ kʊ ŋ sɩra ka ʊ rɔ wɔɔ m, a ʊ: «K'awɔɔ gɔɔta mɔɔ lemim bɩ nɔ ʊ, mɔɔ karɩndanyɩnɔ paan…rɔ n'awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Awɔɔ sɩra dɔm, bɩ sɩra bɩ y'awɔɔ bam soamɩŋŋaʊzannɔ.» ");
INSERT INTO bib_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ŋ n a nyɩ bɔ nʊ, ŋ ʊ: «Abraham yaŋŋɔɔ n wɔɔ m, bɩ gʊaa n wɔɔ ba a lɔnnɔ cɩna y. Ɩbɩɩ ba lɔ, ɩ n'a hɩrɛ, ɩ ʊ: wɔɔ nyɩntam soamɩŋŋaʊzannɔ?» ");
INSERT INTO bib_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, gʊaa k'a nɩ mimbʊnyaa barɛ, mimbʊnyaa lɔmbaa nɔ an ta ʊ. ");
INSERT INTO bib_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Lɔ bɩ, har nɔ bɛɛ an ta ʊ dɔmɩm haay y. Har nyɩ b'ɩ har ʊ dɔmɩm haay. ");
INSERT INTO bib_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Bɩ minto y'a ka, kʊ Nyɩ b'awɔɔ bɔ lɔmbaa nɔ ʊ, awɔɔ nyɩntam soamɩŋŋaʊzannɔ. ");
INSERT INTO bib_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mɔɔ dɔ *Abraham yaŋŋɔɔ n'awɔɔ m. Kʊ mɔɔ lemim bɩ bɩr gasʊrɛ awɔɔ ʊ bɩ, bɩ y'a ka, awɔɔ n'a kam mɔɔ meeyaa ma. ");
INSERT INTO bib_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Hɔ kʊ mɔɔ yɩ m Zɩ zi bɩ mɔɔ n'a hɩrɛ. B'awɔɔ, hɔ k'awɔɔ ma a zɩ zi b'awɔɔ n'a bam!» ");
INSERT INTO bib_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ŋ n a nyɩ bɔ nʊ, ŋ ʊ: «Wɔɔ zɩ m Abraham m.» Yeezuu n a hɩ ŋ nɩ, a ʊ: «Kʊ Abraham nyɩnɔ n'awɔɔ nɩ, k'a Abraham zi ba. ");
INSERT INTO bib_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kɛɛrɛ bɩ, awɔɔ y'a kam ma k'a mɔɔ meeyaa bɔ ʊ, mɔɔ kʊ mɔɔ sɩra kʊ mɔɔ ma Woso zi bɩ hɩ awɔɔ m bɩ minto. Abraham n naa ba y. ");
INSERT INTO bib_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","B'awɔɔ, a zɩ zibəə awɔɔ n'a bam.» Ŋ n a nyɩ bɔ nʊ, ŋ ʊ: «Jaandarɛnyɩnɔ bɛɛ m wɔɔ nɩ y! Wɔɔ Zɩ deem bala, a m Woso m.» ");
INSERT INTO bib_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'awɔɔ Zɩ m Woso nɩ, awɔɔ mɔɔ ŋʊam, bala, m to mɔɔ ʊ Woso zi, m bʊr. Mɔɔ n bʊr m mɩŋŋa paŋŋa nɩ y. A ɩ mɔɔ nyɔɔ. ");
INSERT INTO bib_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bɔ minto m, awɔɔ bɩr mɔɔ meerbaa bɩ marɛ? Bala, awɔɔ b'a dam ma, a a tʊr ka mɔɔ meerbaa bɩ ma y. ");
INSERT INTO bib_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Awɔɔ zɩ bɩ n Sʊtaana m. B'awɔɔ lɛ taa k'a a zɩ bɩ hɔɔnhɔ ba. Gərzer m tee… a sɩŋŋɩda ʊ. A n gɔɔta sɩra nɔ ʊ y, kʊ sɩra ba a nɔ ʊ bɩ minto. K'a ɩ ŋʊaar barɛ, meerbaa k'a n'a nɔ ʊ b'a n'a bam, bala, ŋʊaarzaa m, bɩ ŋʊaar zɩ m sɔ. ");
INSERT INTO bib_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kʊ mɔɔ nɩ, kʊ mɔɔ nɩ sɩra hɩm bɩ y'a ka awɔɔ bɩr sɩra kam mɔɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Awɔɔ bire ʊ, nka y'a da ma, an a hɩ, a ʊ: mɔɔ mimbʊnyaa ba? Bɩ kʊ mɔɔ ɩ sɩra hɩrɛ, bɔ m, awɔɔ bɩr a sire? ");
INSERT INTO bib_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Gʊaa k'an Woso gʊaa bɩ, Woso lemim an n'a tʊr kam ma. Kʊ Woso gʊɔɔ bɛɛ n'awɔɔ m bɩ y'a ka, awɔɔ bɩr a tʊr kam mɔɔ ma y.» ");
INSERT INTO bib_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Zɩɩfʊrɔ wɔɔ n a hɩ Yeezuu m, ŋ ʊ: «Kʊ wɔɔ ʊ, Samarii gʊaa n'ɩbɩɩ m, bɩ zinə nɩ kan ɩbɩɩ kɩ bɩ, wɔɔ gumə ba ʊ ra?» ");
INSERT INTO bib_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Zinə ba kan mɔɔ kɩ y. Bɩ mɔɔ yɩ m Zɩ daŋ ʊ, awɔɔ n bɔkarɛ an nɩ mɔɔ bɔŋ ʊ! ");
INSERT INTO bib_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mɔɔ bɩr m karɛ m mɩŋŋa lɛbɔʊrɛ ma y. Bɩ, gʊaa ta ʊ, an nɩ mɔɔ daŋ ʊ, an nɩ dʊdɔ karɛ. ");
INSERT INTO bib_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, kʊ gʊaa mɔɔ meerbaa bɩ si, a bɩ gam fɩɩga y.» ");
INSERT INTO bib_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Zɩɩfʊrɔ wɔɔ n a hɩ m, ŋ ʊ: «Wɔɔ dɔ kɛɛrɛ, ʊ ʊ, zinə nɩ kan ɩbɩɩ kɩ! Abraham ga kan *wosolɛsinnɩsorazannɔ kɩ sɔ, ɩbɩɩ n bʊr ɩ n'a hɩrɛ, ɩ ʊ: Kʊ gʊaa mɔɔ mim si, a bɩ gam fɩɩga y. ");
INSERT INTO bib_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Lɛ ɩbɩɩ da wɔɔ yaaba Abraham k'a ga bɩ ra ra? Wosolɛsinnɩsorazannɔ gɩnga sɔ! Ɩ mɩŋŋa sa ɩbɩɩ ʊ nka?» ");
INSERT INTO bib_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Kʊ m lɛ mɔɔ n'a bɔrɛ m mɩŋŋa ʊ, mɔɔ lɛbɔʊrɛ jɩ bɩ nyɩntaŋ ʊ y. Mɔɔ Zɩ n'a lɛ bɔm mɔɔ ʊ, awɔɔ n'a hɩm ma, a Woso bɩ. ");
INSERT INTO bib_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Awɔɔ n a dɔ y, bɩ mɔɔ dɔ. Kʊ mɔɔ hɩ mɔɔ ʊ, mɔɔ n a dɔ, m ba mɔɔ nawʊm ŋʊaarzaa a n'awɔɔ hɔ bɩ m. Bɩ mɔɔ dɔ, m n'a meerbaa sim. ");
INSERT INTO bib_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Awɔɔ yaaba Abraham b'a heer nyɔɔ, an a ka mɔɔ dɔmɩm bɩ yɩrɛ ma. B'a a yɩ, a heer nyɔɔ.» ");
INSERT INTO bib_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Zɩɩfʊrɔ wɔɔ n a hɩ, ŋ ʊ: «Ɩbɩɩ dɔɔraa n busoor ku y, ɩbɩɩ n bɔkarɛ ɩ Abraham yɩ!» ");
INSERT INTO bib_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m: dɔmɩm kʊ Abraham n nyɩnta ʊ bɩ, mɔɔ ta ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ŋ n jaarɔ gʊr k'a gʊngʊɛɛn. Yeezuu n a nyaakʊm da, an bɔ Wosocɛ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yeezuu k'a nɩ cenim bɩ, a gʊaa yɩ, an yɩ kan bʊʊbaa kɩ. ");
INSERT INTO bib_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A *karɩndanyɩnɔ wɔɔ n laaka naa do da han, ŋ ʊ: «Karɩnsaamba, nka ɩ mimbʊnyaa ba an yɩ kan bʊʊbaa kɩ? A y'a ba gɛɛ, a zɩrɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «A mɩŋŋa bɛɛ y, b'a zɩrɔ bɛɛ sɔ y. Bɩ lɛ taa k'a hɩ, a ʊ, kʊ Woso zibəə bɩ n a hɩnka a gʊr zi! ");
INSERT INTO bib_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","A a ga m, k'ʊ Zɩ k'a mɔɔ nyɔɔ bɩ zi ba, kʊ woso lɛ n gɔɔta an bɩr ta ʊ. Kʊ gum da, gʊaa b'a dam ma an zi ba y. ");
INSERT INTO bib_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kʊ mɔɔ nɩ durnya nɔ ʊ bɩ, durnya lɛɛgure m mɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kʊ Yeezuu meer ba maam bɩ, a lihi da tara ʊ, an taa bɩ yɔɔ lihi bɩ m, an a gʊr, an a nɔ bʊʊ bɩ mɩnyaa bɩ ma, ");
INSERT INTO bib_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","A n a hɩ m, a ʊ: «Ta ɩ yaa hi da ɩ meer ʊ Silowee bɔrkɔ ʊ.» Tɔ naa do lɛ taa k'a hɩ, a ʊ: nyɔɔdarɛ. Bʊʊ bɩ n ta, an aa hi bɩ da a meer ʊ. K'a wusigə an nɩ doom bɩ, a mɩm ɩ lɛɛ yɩm. ");
INSERT INTO bib_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A cɩsɔnnɔ kan gʊɔɔ kʊ ŋ lɛɛ ka ŋn'a yɩ biisi an nɩ hɔ yɩnyɛm nɔ wɔɔ kɩ a hɩ, ŋ ʊ: «Naa bɛɛ tɩr nyɩnta an bɩr hɔ yɩnyɛm bɩ ra?» ");
INSERT INTO bib_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Gɔsɩnnɔ n'a hɩrɛ, ŋ ʊ: «A mɩŋŋa m!» Gɔsɩnnɔ ʊ: «A bɛɛ y, a bɔkʊʊrɛzaa m.» Bʊʊ bɩ n a hɩ, a ʊ: «Mɔɔ mɩŋŋa m.» ");
INSERT INTO bib_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ŋ n a hɩ m, ŋ ʊ: «Ɩbɩɩ mɩnyaa b'a ba lɔ, an nɩ lɛɛ yɩrɛ?» ");
INSERT INTO bib_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A n a nyɩ bɔ ʊ, a ʊ: «Gʊaa kʊ n n'a birm Yeezuu b'ɩ taa yɔɔ, an a nɔ mɔɔ mɩnyaa bɩ ma, an a hɩ mɔɔ m, a ʊ: Ta ɩ yaa hi da ɩ meer ʊ Silowee bɔrkɔ ʊ. Mɔɔ n ta, m aa hi da m meer ʊ, mɔɔ mɩm nɩ lɛɛ yɩm.» ");
INSERT INTO bib_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ŋ n a hɩ m, ŋ ʊ: «Gʊaa b'ɩ ka?» A n a nyɩ bɔ ʊ, a ʊ: «Mɔɔ n a dɔ y.» ");
INSERT INTO bib_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ŋ n gʊaa k'a nyɩnta bʊʊ bɩ gaa, ŋnɩ ta m *farizɛɛnrɔ zi. ");
INSERT INTO bib_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yeezuu k'a taa bɩ yɔɔ an a mɩm bɩ gʊm bɩ, a ba a ʊ *sabaa hinni ʊ. ");
INSERT INTO bib_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farizɛɛnrɔ wɔɔ n a lar sɔ, k'a ba a ʊ lɔ, a mɩm nɩ lɛɛ yɩm gɛ? A n a hɩ ŋ nɩ, a ʊ: «Taa a yɔɔ, an a nɔ mɔɔ mɩm ma, mɔɔ m hi da m meer ʊ, m nɩ lɛɛ yɩm.» ");
INSERT INTO bib_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farizɛɛnrɔ wɔɔ barla gɔsɩnnɔ y'a hɩrɛ, ŋ ʊ: «Gʊaa naa do, Woso gʊaa bɛɛ y, a bɩr zum sabaa hinni lɛrɔ wɔɔ ʊ y.» Gɔsɩnnɔ ʊ: «Gʊaa mimbʊnyaabər y'a bam lɔ an bɩr hoserlo barɛ ncɩnaaʊ?» Mim naa do farizɛɛnrɔ wɔɔ gʊngʊ kʊ ma. ");
INSERT INTO bib_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ŋ n a ya, ŋn'a hɩ bʊʊ bɩ m, ŋ ʊ: «B'ɩbɩɩ, bɔ ɩbɩɩ n'a hɩm gʊaa k'a ɩbɩɩ waa bɩ jɛ ʊ?» A n a nyɩ bɔ ʊ, a ʊ: «*Wosolɛsinnɩsorazaa m.» ");
INSERT INTO bib_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bɩ, zɩɩfʊrɔ jɩtannɔ wɔɔ n a si ŋ ʊ, a nyɩnta bʊʊ, an mɩm n bɔkarɛ an gʊ y. Pakra m kʊ ŋ n'a zɩrɔ wɔɔ bir, ŋnɩ laaka da ŋ han. ");
INSERT INTO bib_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ŋ n laaka naa do da ŋ han, ŋ ʊ: «Awɔɔ nyɩ m gʊaa naa do m, awɔɔ n a dɔ, a ʊ, yɩ a ʊ kan bʊʊbaa kɩ gɛ? Bɩ, a a ba lɔ, an nɩ lɛɛ yɩm kɛɛrɛ?» ");
INSERT INTO bib_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A zɩrɔ wɔɔ n a nyɩ bɔ ʊ, ŋ ʊ, «Wɔɔ dɔ paan… ʊ ʊ, wɔɔ nyɩ m, bɩ yɩ a ʊ bʊʊ. ");
INSERT INTO bib_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bɩ, wɔɔ n a dɔ k'a ba a ʊ lɔ, a mɩm nɩ lɛɛ yɩm kɛɛrɛ y. Kʊ nka y'a mɩm bɩ gʊ, wɔɔ n bɩ zaa dɔ sɔ y. K'a lar, nyɩ bɛɛ m dɔ y. A a da ma, an a mim dɩnda a zim!» ");
INSERT INTO bib_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A zɩrɔ wɔɔ ɩ nyi bam zɩɩfʊrɔ jɩtannɔ wɔɔ m. Bɩ y'a ka, ŋnɩ meer ba ncɩnaaʊ. Bala, jɩtannɔ wɔɔ kʊ ma, ŋn'a hɩ, ŋ ʊ: Kʊ gʊaa a hɩ, a ʊ: Yeezuu bɩ, *Krista m, k'a bɔ a zi. ");
INSERT INTO bib_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Bɩ y'a ka, a zɩrɔ wɔɔ n a hɩ, ŋ ʊ: «Nyɩ bɛɛ m dɔ y, k'a lar.» ");
INSERT INTO bib_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farizɛɛnrɔ wɔɔ n a ya, ŋnɩ gʊaa k'a yɩ bʊʊbaa nɔ ʊ bɩ bir a hɩɩya hɔ ma, ŋn'a hɩ m, ŋ ʊ: «Nyi ba Woso m, ɩ sɩra hɩ! Wɔɔ dɔ wɔɔ ʊ, gʊaa naa do mimbʊnyaabər m.» ");
INSERT INTO bib_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A n a nyɩ bɔ ŋ nʊ, a ʊ: «Mɔɔ n a dɔ kʊ mimbʊnyaabər nɩ y. Hɔ deem mɔɔ dɔ, bala, mɔɔ nyɩnta bʊʊ, bɩ, mɔɔ ɩ lɛɛ yɩm kɛɛrɛ.» ");
INSERT INTO bib_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ŋ n a hɩ m, ŋ ʊ: «Bɔ a a ba ɩbɩɩ nɩ? A ba a ʊ lɔ an ɩbɩɩ mɩm bɩ gʊ?» ");
INSERT INTO bib_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A n a nyɩ bɔ ŋ nʊ, a ʊ: «Mɔɔ lɛɛ ka, m a dɩnda awɔɔ m, b'awɔɔ n a tʊr ka ma y, gɛɛ lɔ? Bɔ minto m, a a ya, an nɩ mɔɔ larlɛ? A hɩ awɔɔ ʊ k'a ba a karɩndanyɩnɔ sɔ ra?» ");
INSERT INTO bib_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Farizɛɛnrɔ wɔɔ n a sɩŋŋɩda ba, ŋn'a sʊnsɔ wʊrɛ, ŋn'a hɩrɛ, ŋ ʊ: «Ɩbɩɩ n a karɩndanyɩ! *Moyiisi karɩndanyɩnɔ m wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wɔɔ dɔ, wɔɔ ʊ, Woso meer ba kan Moyiisi kɩ, bɩ naa do naa, wɔɔ n a dɔ k'a to a ʊ ka y.» ");
INSERT INTO bib_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Gʊaa bɩ n a nyɩ bɔ ŋ nʊ, a ʊ: «Zɛkədə mim n naa! Awɔɔ n a tojɩ dɔ, b'a a ka mɔɔ mɩm nɩ lɛɛ yɩm la! ");
INSERT INTO bib_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wɔɔ dɔ, wɔɔ ʊ, Woso bɩr a tʊr kam mimbʊnyaabənno ma y. Bɩ kʊ gʊaa ɩ Woso daŋ ʊ, an n'a hɔɔnhɔ barɛ, Woso y'a tʊr kam bɩ zaa ma. ");
INSERT INTO bib_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Gʊaa n a ma cɩna, ŋ ʊ, gʊaa ɩ gʊaa k'a yɩ kan bʊʊbaa kɩ bɩ mɩm gʊ y. ");
INSERT INTO bib_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Gʊaa naa do, kʊ Woso gʊaa ɩ bɛɛ, a b'a dam ma, an hɔsɩ ba y.» ");
INSERT INTO bib_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Yɩ ɩbɩɩ ʊ mimbʊnyaa nɔ ʊ, ɩ bʊr, ɩ nɩ karɩnda dɩndam wɔɔ m na?» Ŋ n la ra an bɔ, ŋn'a bɔ a zi. ");
INSERT INTO bib_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeezuu k'a a ma a ʊ, ŋ la ra bɩ, a bʊr zi an b'a hɩ m, a ʊ: «Ɩbɩɩ ɩ sɩra kam *Gʊaanyɩ b'ʊ ra?» ");
INSERT INTO bib_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","A n a nyɩ bɔ ʊ, a ʊ: «Nka nɩ, Zuuba, kʊ m sɩra ka ʊ?» ");
INSERT INTO bib_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeezuu n a hɩ m, a ʊ: «Ɩbɩɩ yɩ, an nɩ meer bam kan ɩbɩɩ kɩ naa.» ");
INSERT INTO bib_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Gʊaa bɩ n a hɩ, a ʊ: «Mɔɔ sɩra ka ɩ ʊ, Zuuba.» A n kukurə zɛ a taa. ");
INSERT INTO bib_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yeezuu n a hɩ, a ʊ: «Bʊr mɔɔ ʊ durnya naa nɔ ʊ dʊdɔ minto, kʊ gʊɔɔ kʊ ŋ mɩm bɩr lɛɛ yɩm nɔ wɔɔ n lɛɛ yɩ, kʊ gʊɔɔ kʊ ŋ mɩm nɩ lɛɛ yɩm nɔ wɔɔ n a ba bʊʊrɔ.» ");
INSERT INTO bib_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farizɛɛnrɔ kʊ ŋ nyɩnta kan kɩ rɔ wɔɔ kʊ ŋ naa ma bɩ, ŋ y'a hɩ, ŋ ʊ: «A hɩ ɩbɩɩ ʊ, bʊʊrɔ m wɔɔ m sɔ gɛ?» ");
INSERT INTO bib_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Kʊ bʊʊrɔ n'awɔɔ nɩ, awɔɔ mimbʊnyaa bɩ nyɩntaŋ ʊ y. Bɩ naa ma bɩ, k'awɔɔ ʊ, a mɩm ɩ lɛɛ yɩm bɩ, awɔɔ mimbʊnyaa bɩ gɔɔta an ta ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, gʊaa k'a n gasʊ seero bakʊ lɛ nɩ y, an bɔkarɛ an bɔɔra m, an gasʊ, bɩ zaa bɩ, koor m, hɔyɔrɛzaa m sɔ. ");
INSERT INTO bib_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bɩ, gʊaa k'a gasʊ bakʊ bɩ lɛ m bɩ, bɩ zaa m seero wɔɔ dundor. ");
INSERT INTO bib_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Gʊaa k'a nɩ dɔm cɛlɛ ma bɩ n'a gʊm dundor bɩ m, seero wɔɔ n a tʊr ka a leer ma. A n a seero wɔɔ bir deem-deem ŋ tɔ ma, an bɔ ŋ nɩ garga ra. ");
INSERT INTO bib_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","K'a bɔ ŋ nɩ haay, ka an nawʊrɛ ŋ lɛɛ, seero wɔɔ n zu a jɛ ʊ, kʊ ŋ y'a leer dɔ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ŋ bɩ yɛrɛ, ŋnɩ zu saana jɛ ʊ y. A si ŋ nawʊm, ŋn'a gʊ saana bɩ ma, bala, ŋ n saanarɔ leer dɔ y.» ");
INSERT INTO bib_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeezuu n *hɔbɔkʊrɛnoom naa do da ŋ nɩ, bɩ ŋ n hɔ kʊ Yeezuu a hɩ bɩ jɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yeezuu n a ya, an a hɩ, a ʊ: «Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, mɔɔ m bakʊ bɩ lɛ. ");
INSERT INTO bib_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Gʊɔɔ kʊ ŋ lɛɛ ka mɔɔ lɛɛ ŋnɩ bʊr lɔ wɔɔ, konno m, hɔyɔrɛzannɔ m sɔ. Bɩ, seero wɔɔ n a tʊr ka ŋ ma y. ");
INSERT INTO bib_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mɔɔ m bakʊ bɩ lɛ. Kʊ gʊaa gasʊ mɔɔ m, a bʊmbɔrɛ yɩm. A gasʊrɛ, an bɔ, an bʊr, an hɔbɩrɛ yɩ an a bɩ. ");
INSERT INTO bib_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Koor bɩr zɛm k'a hɩ bɛɛ a ʊ, k'a koor ba, k'a gər zɛ, k'a hɔ zar y. Bʊr mɔɔ ʊ kʊ gʊɔɔ m mɩsɩrbaa yɩ, kʊ ŋ n'a yɩ an bʊr bɔ.» ");
INSERT INTO bib_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Mɔɔ m dundor mɩŋŋa. Bɩ dundor mɩŋŋa bɩ, a mɩsɩrbaa an n'a kam a seero wɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Gʊaa k'a nɩ zi bam busoo minto bɩ, seero wɔɔ dundor bɛɛ nɩ y, bɩ ŋ zaa bɛɛ sɔ y. K'a tampa yɩ an nɩ zɛrɛ, a si an nawʊrɛ, an n'a gʊm seero wɔɔ ma. Tampa bɩ n a da ŋ bir, ŋn'a hɩsɩga. ");
INSERT INTO bib_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kʊ gʊaa bɩ, a ka an nawʊm busoo ma bɩ, a leer ba seero wɔɔ mim ma y. ");
INSERT INTO bib_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Dundor mɩŋŋa m mɔɔ m. Mɔɔ m seero wɔɔ dɔ, bɩ mɔɔ seero wɔɔ mɔɔ dɔ sɔ, ");
INSERT INTO bib_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","amba mɔɔ Zɩ mɔɔ dɔ, mɔɔ nɩ m Zɩ dɔ bɩ m. Bɩ, m mɩsɩrbaa mɔɔ n'a karɛ m seero wɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Seero gɔsɩnnɔ ta ʊ, ŋ ba bakʊ naa do ʊ y, bɩ mɔɔ brɔɔ gaam, m bʊr ŋ nɩ. Ŋ zɛm b'a tʊr ka mɔɔ leer ma. Bɩ, seero bakʊ nyɩntam deem a dundor deem. ");
INSERT INTO bib_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mɔɔ Zɩ ɩ mɔɔ ŋʊarɛ, bala, mɔɔ yɩ m mɩsɩrbaa karɛ, kʊ m m ya, m b'a si. ");
INSERT INTO bib_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Gʊaa bɛɛ nɩ mɔɔ mɩsɩrbaa bɩ sire y, mɔɔ mɩŋŋa n'a kam. Mɔɔ m da ma, m a ka, mɔɔ m da ma, m a si. Mɔɔ Zɩ ɩ lɛ naa do ka mɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Minno nɔɔn duro a ya, an zɩɩfʊrɔ wɔɔ gʊngʊ kʊ ma. ");
INSERT INTO bib_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Gʊɔɔ gʊta yɩ ŋ barla, ŋn'a hɩrɛ, ŋ ʊ: «Zinə nɩ kan kɩ, hɔɔzaa m, bɔ minto m, a n'a tʊr karɛ a meerbaa ma?» ");
INSERT INTO bib_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bɩ, gɔsɩnnɔ y'a hɩrɛ, ŋ ʊ: «Gʊaa kʊ zinə n nɩ kan kɩ meerbaarɔ bɛɛ m naa y. Zinə y'a dam ma, an bʊʊ mɩm gʊ ra?» ");
INSERT INTO bib_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","N ɩ Zerizalɛm *Wosocɛ bankarɛ tɔdaanɔʊ cibsa bam. Nyɩnta a ʊ nyɛɛm dɔmɩm. ");
INSERT INTO bib_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yeezuu nɩ bɩmbɩrm Wosocɛ ʊ b'ʊ Salomɔɔn laŋŋa gʊta kʊ n y'a dɔ jaa m bɩ taa b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Zɩɩfʊrɔ wɔɔ n bɩ bɩr ma, ŋn'a hɩ m, ŋ ʊ: «Kʊ *Krista n'ɩbɩɩ nɩ, ɩbɩɩ wɔɔ tore ʊ hɔɔndarɛ nɔ ʊ, an ta, an dɔmɩm kara ku? A hɩ wɔɔ m paan…!» ");
INSERT INTO bib_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mɔɔ hɩ awɔɔ m, b'awɔɔ n a si y, ziro kʊ mɔɔ n nɩ barɛ m Zɩ tɔ ma rɔ wɔɔ ɩ mɔɔ kasɛtɩ kam. ");
INSERT INTO bib_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bɩ, mɔɔ y'a hɩrɛ awɔɔ m, b'awɔɔ bɩr a sire y, kʊ mɔɔ seero bɛɛ n'awɔɔ m bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mɔɔ seero wɔɔ y'a tʊr kam mɔɔ leer ma, bɩ mɔɔ ŋ dɔ sɔ, ŋn'ɩ zum mɔɔ jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Bɩ mɔɔ *mɩsɩrbaa k'a nyarɛ ba ʊ bɩ karɛ ŋ ʊ. Ŋ bɩ gam fɩɩga y. Bɩ, gʊaa b'a dam ma, an ŋ bɔ mɔɔ wɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mɔɔ Zɩ k'a ŋ ka mɔɔ ʊ bɩ lɛ da hɔ haay ra, bɩ gʊaa ba ʊ an b'a dam ma, an hɔ bɔ Zɩ bɩ wɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mɔɔ kan Zɩ bɩ kɩ, wɔɔ deem.» ");
INSERT INTO bib_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Zɩɩfʊrɔ wɔɔ n a ya, ŋnɩ jaarɔ gʊr k'a gʊngʊɛɛn. ");
INSERT INTO bib_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Mɔɔ ka awɔɔ m zibəəro mɩŋŋɔɔ kʊ ŋ y'a to Zɩ zi rɔ wɔɔ yɩ. Brɔɔ minto y'a ka, awɔɔ k'a mɔɔ gʊngʊɛɛn ra?» ");
INSERT INTO bib_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Zɩɩfʊrɔ wɔɔ n a nyɩ bɔ ʊ, ŋ ʊ: «Zibəə mɩŋŋa barɛ minto bɛɛ y'a ka, wɔɔ n'ɩbɩɩ gʊngʊɛɛnrɛ y, sʊnsɔ k'ɩbɩɩ wʊ, ɩbɩɩ k'ɩ m gʊaa, ɩ bɔkarɛ, ɩ n'ɩ mɩŋŋa bam Woso bɩ minto m.» ");
INSERT INTO bib_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Ŋ n a gʊrsɩra ba ncɩnaaʊ awɔɔ *lɛrɔ ci bɩ nɔ ʊ ra? ‹Mɔɔ hɩ: wosoro n'awɔɔ m.› ");
INSERT INTO bib_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wɔɔ dɔ, wɔɔ ʊ, gʊaa b'a dam ma, an hɔ kʊ n y'a gʊrsɩra ba *Wosoci nɔ ʊ bɩ zar y. Woso gʊɔɔ kʊ ŋ y'a lemim ma rɔ wɔɔ bir wosoro. Awɔɔ y'a hɩm gʊaa kʊ Zɩ b'a nyɔɔ bɩ ma, a ʊ, sʊnsɔ ɩbɩɩ n'a wʊrɛ, kʊ mɔɔ hɩ mɔɔ ʊ Woso Nyɩ m mɔɔ m bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Gʊaa kʊ Zɩ b'a bɔ ʊ, an a nyɔɔ durnya ʊ, b'awɔɔ ʊ, Woso sʊnsɔ an n'a wʊrɛ. Bala, kʊ mɔɔ hɩ mɔɔ ʊ Woso Nyɩ mɔɔ m bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kʊ mɔɔ nɩ m Zɩ zi ba, a bɩ sɩra ka mɔɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bɩ kʊ mɔɔ y'a barɛ, baa k'awɔɔ n sɩra ka mɔɔ ʊ, k'a sɩra ka a zibəə bɩ minto, k'a bɔkarɛ a dɔ mɩŋŋa, a ʊ, Zɩ ɩ kan mɔɔ kɩ, mɔɔ nɩ kan Zɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ŋ n a ya, ŋnɩ wuti, ŋn'a ŋʊam k'a nyasʊ. Yeezuu n a yɔ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yeezuu n a wusigə an ta Zʊrdɛn kɔ lɛ ra zeezi, bɩncɛ kʊ Zaan a sɩŋŋɩda ba ʊ, an nɩ *batɛm kaŋ ʊ b'ʊ, an aa gɔɔta b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Gʊɔɔ gʊta n bʊr zi, ŋn'a hɩrɛ, ŋ ʊ: «Zaan n hoser deem taan… ba y, bɩ hɔ haay k'a hɩ gʊaa naa do minto bɩ, sɩra m.» ");
INSERT INTO bib_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bɩ, gʊɔɔ gʊta sɩra ka ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gʊaa ɩ nyɩnta ʊ, an nɩ yaaba m. A tɔ m Lazaar. Betanii gʊaa m. Maarii kan a cɛmba Martɩ kɩ kʊ m bɩ. ");
INSERT INTO bib_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maarii bɩ do ɩ tidəər nɔ Zuuba ma, an a minkə gaa, an a nʊnnɔ a gannɔ ma bɩ. A dakumboor Lazaar ɩ bɩ laafɩɩ bɩ. ");
INSERT INTO bib_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","A danlʊrɔ wɔɔ n nyɔɔ da, ŋn'aa a hɩ Yeezuu m, ŋ ʊ: «Gʊaa k'ɩbɩɩ ŋʊa bɩ bɩ laafɩɩ y.» ");
INSERT INTO bib_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kʊ Yeezuu a ma bɩ, a a hɩ, a ʊ: «Yaaba naa do, zɛ yaaba bɛɛ y, zɛ an nawʊm Woso lɛbɔʊrɛ m. A minto n'a kam Woso Nyɩ bɩ n daʊrɛ yɩ.» ");
INSERT INTO bib_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeezuu nyɩnta an Martɩ ŋʊa kan a danzaa bɩ kɩ, Lazaar kɩ. ");
INSERT INTO bib_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Baa k'a a dɔ a ʊ, Lazaar bɩ laafɩɩ bɩ, a gɔɔta bɩncɛ k'an ta ʊ b'ʊ dɔmɩm hɩɩya. ");
INSERT INTO bib_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Bɩ jɛ ʊ bɩ, a a hɩ a karɩndanyɩnɔ m, a ʊ: «Ʊ ʊ bɔ, ʊ ta Zidee ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Karɩndanyɩnɔ wɔɔ n a hɩ, ŋ ʊ: «Karɩnsaamba, zɩɩfʊrɔ a ka ma dɩɩtaa k'a ɩbɩɩ gʊngʊɛɛn jaarɔ m, ɩbɩɩ lɛ taa k'ɩ ɩ ya, ɩ ɩ bɔ, ɩ ta b'ʊ ra?» ");
INSERT INTO bib_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «A n a sa dɔgta m an ta yirbəə ra lɛɛgure bɛɛ m ta ʊ wakatɩ bueerehɩɩya ra? Kʊ gʊaa ɩ tam lɛɛgure ʊ a bɩr a gəm zɛrɛ y, bala, a ɩ durnya naa do lɛɛgure yɩm. ");
INSERT INTO bib_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bɩ kʊ gʊaa ɩ tam gunuu ʊ, a y'a gəm zɛm, bala, a mɩm bɩr lɛɛ yɩrɛ y.» ");
INSERT INTO bib_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","K'a meer naa do ba an a nya bɩ, a a hɩ, a ʊ: «Wɔɔ gʊaasɩba Lazaar hinceem ba, bɩ mɔɔ tam, m aa a gu.» ");
INSERT INTO bib_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","A karɩndanyɩnɔ wɔɔ n a hɩ m, ŋ ʊ: «Zuuba, kʊ hinceem a ba, a laafɩɩ yɩrɛ.» ");
INSERT INTO bib_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kʊ sɩra nɩ, Yeezuu bɩ, a ŋʊa a ʊ, k'a hɩ a ʊ, Lazaar ga. Ŋ n bɔkarɛ, ŋn'a hɔɔn darɛ, ŋ ʊ, hinceem paan… mim an n'a dɩndarɛ. ");
INSERT INTO bib_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yeezuu n a hɩ ŋ nɩ paan…, a ʊ: «Lazaar ga. ");
INSERT INTO bib_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Bɩ kʊ mɔɔ n nyɩnta b'ʊ bɩ, mɔɔ ɩ heernyɔɔ m awɔɔ tɔ ma, k'a a da ma, a sɩra ka. K'a wuti, k'ʊ ta zi.» ");
INSERT INTO bib_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma kʊ n n'a birm Didim b'a hɩ karɩndanyɩnɔ gɔsɩnnɔ wɔɔ m, a ʊ: «Ʊ ta, kan kɩ, ʊ aa gɩnga sɔ.» ");
INSERT INTO bib_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yeezuu k'a lee ku bɩ, a yaa dɩga a n Lazaar bir. A birle dɔmɩm si lɛɛm. ");
INSERT INTO bib_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bɩ kʊ Betanii bɩ laatʊ Zerizalɛm ma bɩ, a ga kʊ a ba cilo kaakʊ. ");
INSERT INTO bib_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Zɩɩfʊrɔ wɔɔ bʊr gʊta k'a bɩ yaa da Martɩ m kan Maarii kɩ, ŋ dakumboor bɩ garɛ minto. ");
INSERT INTO bib_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kʊ Martɩ a ma, n ʊ, Yeezuu ɩ zɛm bɩ, a ta, an aa a zɛ ʊ, Maarii n gɔɔta har ʊ, an nɩ nyɩntam. ");
INSERT INTO bib_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martɩ n a hɩ Yeezuu m, a ʊ: «Zuuba, kʊ nyɩnta ɩbɩɩ ʊ naa ʊ, mɔɔ dakumboor bɩ bɩ garɛ y. ");
INSERT INTO bib_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bɩ, an gɔɔta naa, mɔɔ dɔ mɔɔ ʊ, hɔ haay k'ɩbɩɩ n n'a yɛm Woso han bɩ, a y'a karɛ ɩbɩɩ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Ɩbɩɩ dakumboor bɩ y'a mɩm bɔŋ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martɩ n a hɩ, a ʊ: «Mɔɔ dɔ, a y'a mɩm bɔŋ ʊ gəəno mɩmbɔʊrɛ dɔmɩm ʊ durnya nyarɛ ma.» ");
INSERT INTO bib_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeezuu n a hɩ m, a ʊ: «Mɔɔ m mɩmbɔʊrɛ, mɔɔ m *mɩsɩrbaa. Gʊaa k'a sɩra ka mɔɔ ʊ bɩ, baa k'a zaa ga, a mɩsɩrbaa yɩrɛ. ");
INSERT INTO bib_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Bɩ gʊaa k'an mɩsɩr, an nɩ sɩra kam mɔɔ ʊ, a bɩ gam fɩɩga y. Ɩbɩɩ sɩra ka naa ʊ ra?» ");
INSERT INTO bib_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","A n a nyɩ bɔ ʊ, a ʊ: «Ɩɩn… Zuuba, mɔɔ sɩra ka, mɔɔ ʊ, ɩbɩɩ m *Krista, Woso Nyɩ k'a a ga m an bʊr durnya ʊ bɩ.» ");
INSERT INTO bib_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","K'a meer bɩ ba ncɩnaaʊ bɩ, a a hʊr, an aa a danzaa Maarii bɩ bir, an a hɩ m sɩnsɛɛrɛ m, a ʊ: «Karɩnsaamba bʊr, an n'ɩbɩɩ birm.» ");
INSERT INTO bib_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maarii k'a naa ma bɩ, a wuti zɔɔ-zɔɔ, an ta zi. ");
INSERT INTO bib_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Bɩ ma bɩ, Yeezuu n gasʊ kʊ b'ʊ cɩna y. A gɔɔta an nɩ bɩncɛ kʊ Martɩ a zɛ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Zɩɩfʊrɔ wɔɔ nyɩnta kan Maarii kɩ har ʊ b'ʊ, ŋn'ɩ bra bam nɩ. Kʊ ŋ y'a yɩ an wuti zɔɔ-zɔɔ an bɔ bɩ, ŋ zu a jɛ ʊ, ŋn'a hɔɔn darɛ, ŋ ʊ, ta an nawʊm yaa ra b'ʊ k'a yaa nyi ka. ");
INSERT INTO bib_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maarii k'a yaa lee ku bɩncɛ kʊ Yeezuu n ta ʊ b'ʊ bɩ, k'a a yɩ lɛɛm bɩ, a sʊnta a taa an n'a hɩm nɩ, a ʊ: «Zuuba, kʊ nyɩnta ɩbɩɩ ʊ naa ʊ, mɔɔ dakumboor bɩ bɩ garɛ y.» ");
INSERT INTO bib_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yeezuu k'a yɩ, an nɩ nyi kam kan zɩɩfʊrɔ kʊ ŋ yaa a da zaa ʊ rɔ wɔɔ kɩ bɩ, a heer a zɛ kʊ ma. ");
INSERT INTO bib_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","A n a hɩ, a ʊ: «A bir awɔɔ ʊ ka?» Ŋ n a nyɩ bɔ nʊ, ŋ ʊ: «Zuuba, bʊr ɩ dɩga a.» ");
INSERT INTO bib_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeezuu n nyi ka. ");
INSERT INTO bib_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Zɩɩfʊrɔ wɔɔ n'a hɩrɛ, ŋ ʊ: «K'a dɩga a, a a ŋʊa gʊta!» ");
INSERT INTO bib_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Gɔsɩnnɔ n'a hɩrɛ ŋ barla, ŋ ʊ: «Gʊaa k'a bʊʊ k'a yɩ kan bʊʊbaa kɩ mɩm gʊ bɩ, a b'a dam ma, an a ka Lazaar bɩ gam na?» ");
INSERT INTO bib_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yeezuu heer n a ya, an a zɛ kʊ ma, an a hʊr an ta yaa ra b'ʊ. Nyɩnta a ʊ ci yaa, ŋ n jaa ta a lɛ bɩ rɛ. ");
INSERT INTO bib_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeezuu n a hɩ, a ʊ: «K'a jaa bɩ gʊ rɛ.» Gər bɩ danlʊ Martɩ bɩ n a nyɩ bɔ nʊ, a ʊ: «Zuuba, a ji nyɩntaŋ ʊ, a dɔmɩm si hɔ n naa.» ");
INSERT INTO bib_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Mɔɔ n a hɩ ɩbɩɩ m, mɔɔ ʊ, k'ɩ sɩra ka mɔɔ ʊ, ɩ Woso lɛbɔʊrɛ yɩm na?» ");
INSERT INTO bib_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ŋ n jaa bɩ gʊ rɛ. Yeezuu n a bɔɔta, an dɩga brama, an a hɩ, a ʊ: «M Zɩ, mɔɔ ɩ barka darɛ ɩbɩɩ m, ɩbɩɩ k'ɩ mɔɔ yaadarɛ si bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mɔɔ dɔ, mɔɔ ʊ, ɩbɩɩ ɩ mɔɔ yaadarɛ sim dɔmɩm haay, bɩ meer bɩ ba mɔɔ ʊ gʊɔɔ kʊ ŋ bɩr mɔɔ ma naa ʊ rɔ wɔɔ minto, kʊ ŋ n'a da ma, ŋn'a si, ŋ ʊ, ɩbɩɩ ɩ mɔɔ nyɔɔ.» ");
INSERT INTO bib_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","K'a meer ba ncɩnaaʊ bɩ, a həən si kan paŋŋa kɩ, a ʊ: «Lazaar, bɔ!» ");
INSERT INTO bib_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Gər bɩ n bɔ, a gannɔ kan a wɔrɔ kɩ nɩ kʊsɩm kan pɛɛrarɔ kɩ, pɛɛra nɩ burgure a meer ma. Yeezuu n a hɩ gʊɔɔ wɔɔ m, a ʊ: «K'a pɛɛrarɔ wɔɔ hʊnhʊr ma, k'a to k'an ta!» ");
INSERT INTO bib_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Zɩɩfʊrɔ wɔɔ duro gʊɔɔ kʊ ŋ nyɩnta kan Maarii kɩ jɩr ʊ rɔ wɔɔ, ŋnɩ hɔ kʊ Yeezuu a ba bɩ yɩ rɔ wɔɔ, gʊta sɩra ka ʊ. ");
INSERT INTO bib_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gʊɔɔ gɔsɩnnɔ ta, ŋn'aa *farizɛɛnrɔ yɩ, ŋnɩ hɔ kʊ Yeezuu a ba bɩ dɩnda ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","*Wosocɛmannɩbənno jɩtannɔ kan farizɛɛnrɔ wɔɔ kɩ dʊdɔkənno wɔɔ kɩ a so kʊ ma, ŋn'a hɩ ŋ nɩ, ŋ ʊ: «Bɔ wɔɔ n n'a barɛ? Gʊaa naa do ɩ hoserlo bam gʊta. ");
INSERT INTO bib_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kʊ wɔɔ to an n'a barɛ ncɩnaaʊ gʊaa haay sɩra kaŋ ʊ, *Rɔm zannɔ zɛm, ŋnɩ bɩ wɔɔ *Wosocɛ bɩ da, kan wɔɔ do bɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ŋ gʊaa deem k'a tɔ m *Kayiifʊ b'ɩ nyɩnta wosocɛmannɩbər jɩtaarɛ dɔɔraa bɩ do ma, an a hɩ, a ʊ: «Awɔɔ bɩr hɔsɩ jɩ marɛ y. ");
INSERT INTO bib_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Awɔɔ n a dɔ a ʊ, a jɩra kʊ gʊaa deem n ga, gʊaa haay minto kʊ wɔɔ do bɩ b'a zar haay ra?» ");
INSERT INTO bib_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A mɩŋŋa hɔɔndarɛ bɛɛ m meerbaa naa do nɩ y, kʊ wosocɛmannɩbər jɩtaarɛ m dɔɔraa bɩ do ʊ bɩ, Woso lemim naa do da a lɛ ʊ, a ʊ: Pakra m kʊ Yeezuu m ga do bɩ minto, ");
INSERT INTO bib_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","bɩ do bɩ minto bɛɛ m bala y, k'a Woso nyɩnɔ kʊ ŋ y'a hɩsɩga bɩ so kʊ ma lɛɛ deem ʊ. ");
INSERT INTO bib_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Hinni bɩ do ʊ, ŋ y'a cɩnta ŋ ʊ, k'a zɛ gər. ");
INSERT INTO bib_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Bɩ minto y'a ka, Yeezuu n a ya, an nɩ bɩmbɩrm paan… zɩɩfʊrɔ jɩtannɔ wɔɔ bire ʊ y. A ta bɩncɛ niŋŋə k'an jɩnjɛɛm poohɔɔn ma b'ʊ, kʊ niŋŋə kʊ n n'a birm Efrayim ʊ b'ʊ, an aa gɔɔta b'ʊ kan a karɩndanyɩnɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Dɔmɩm bɩ do ʊ bɩ, *pakkɩ cibsa a zɔ. Pakkɩ bɩ k'a gɔɔta booti m bɩ yirbəə m gʊɔɔ gʊta a to bɔlɛɛmarɔ ʊ, ŋnɩ ta Zerizalɛm ʊ mɩŋŋa *hubɔrɛ zibəə minto. ");
INSERT INTO bib_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ŋ n'a kam Yeezuu ma, bɩ ma bɩ, ŋ yɩ Wosocɛ ʊ, ŋn'a hɩm kʊ m, ŋ ʊ: «Awɔɔ y'a hɔɔn darɛ, a ʊ lɔ? A bɩ zɛm cibsa bɩ ma ra!» ");
INSERT INTO bib_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","*Wosocɛmannɩbənno jɩtannɔ kan *farizɛɛnrɔ wɔɔ kɩ lɛ ka, ŋ ʊ: Gʊaa k'a bɩncɛ dɔ kan a hɩ k'a ku a nyasʊ. ");
INSERT INTO bib_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","*Pakkɩ cibsa k'a gɔɔta dɔmɩm sɔrdɩ bɩ, Yeezuu ta Betanii ʊ, kʊ kʊ Lazaar n ta ʊ b'ʊ. Kʊ bɩ do a Lazaar mɩm bɔ ʊ bɩ. ");
INSERT INTO bib_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","N yirbəə hɔbɩrɛ ba b'ʊ, n n a ka Yeezuu ʊ. Martɩ nyɩnta an nɩ hɔbɩrɛ jirm, bɩ ma bɩ, Lazaar ɩ gʊɔɔ kʊ ŋ nɩ hɔbɩrɛ bɩm kan Yeezuu kɩ rɔ wɔɔ barla. ");
INSERT INTO bib_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maarii n tidəər nyɔɔ kʊ n y'a ba naar paan… m a lɛ n kʊsɩ bɩ sa gedre ʊ, an a nɔ Yeezuu gannɔ ma, an a minkə gaa an a nʊnnɔ ma, tidəər ji bɩ n sʊr har bɩ ma haay. ");
INSERT INTO bib_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Karɩndanyɩnɔ wɔɔ gʊaa deem Zidas Iskarɩyɔtɩ kʊ gʊaa k'a nɩ zɛm k'a bɩ Yeezuu nyasʊ a ka b'a hɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Bɔ minto, n n tidəər naa do sa, n n a hɛɛ *deniyee zɔɔkarkʊ, n n a ka cicirzannɔ ʊ?» ");
INSERT INTO bib_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","K'a hɩ ncɩnaaʊ bɩ, a bɩr yɩrɛ ɩ ʊ, a hɔɔn an n'a dam cicirzannɔ ma y. Bala, a mɩŋŋa koor m, k'a y'a so busoo bɩ zibəə b'ʊ bɩ, a ɩ hɔ kʊ n n'a cɩntam bɩ kʊnam. ");
INSERT INTO bib_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yeezuu n a hɩ, a ʊ: «K'a to! Naa do ba an nawʊm mɔɔ birle dɔmɩm minto. ");
INSERT INTO bib_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Cicirzannɔ wɔɔ ɩ kan awɔɔ kɩ dɔmɩm haay, bɩ, mɔɔ bɩ kan awɔɔ kɩ dɔmɩm haay y.» ");
INSERT INTO bib_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bɩ ma bɩ, zɩɩfʊrɔ cir gʊta a ma, ŋ ʊ, Yeezuu bʊr b'ʊ. Ŋ n bʊr zi, bɩ ŋ n bʊr a minto bala y, bʊr ŋ y'a ʊ k'a bɩ Lazaar k'a mɩm bɔ ʊ gəəno bire ʊ bɩ yɩ. ");
INSERT INTO bib_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","*Wosocɛmannɩbənno jɩtannɔ wɔɔ a cɩnta k'a Lazaar zɛ gər sɔ, ");
INSERT INTO bib_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","bala, a minto y'a ka, zɩɩfʊrɔ gʊɔɔ gʊta n'a gʊrɛ ŋ ma, ŋn'ɩ Yeezuu mim sim. ");
INSERT INTO bib_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Dɔ k'a mɛ bɩ, gʊɔɔ gʊta kʊ ŋ bʊr cibsa bɩ ma rɔ wɔɔ kʊ ŋ y'a ma, ŋ ʊ, Yeezuu ɩ zɛm Zerizalɛm ʊ bɩ, ");
INSERT INTO bib_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ŋ bɛ gɔ lɛɛ yɩnyar, ŋnɩ ta k'a yaa a zɛ ʊ, ŋn'ɩ zee darɛ, ŋ ʊ: «*Hozaana! Gʊaa k'a nɩ zɛm Woso tɔ ma, *Israyɛl cir bɩ n barka yɩ.» ");
INSERT INTO bib_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yeezuu brapoo yɩ, an da ʊ, amba n y'a gʊrsɩra ba bɩ m: ");
INSERT INTO bib_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","*Siyɔn zannɔ, a da bɩ bɔ ʊ y. Ba awɔɔ cir nɩ zɛm n na. Da a ʊ brapoo ʊ. ");
INSERT INTO bib_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Karɩndanyɩnɔ wɔɔ n lɛɛ ka ŋnɩ hɔ k'a nɩ zɛm naa jɩ dɔ hɔɔ y. Bɩ, kʊ ŋ Yeezuu lɛbɔʊrɛ yɩ bɩ, ŋ hɔ kʊ ŋ y'a gʊrsɩra ba a minto bɩ tɔ da a nɔ ʊ, bɩ naa ba ŋ y'a ʊ a minto. ");
INSERT INTO bib_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bɩ, gʊɔɔ kʊ ŋ nyɩnta kan Yeezuu kɩ dɔmɩm k'a Lazaar bir yaa ʊ an bɔ, an a mɩm bɔ ʊ gəəno bire ʊ rɔ wɔɔ a kasɛtɩ ka. ");
INSERT INTO bib_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bɩ gʊɔɔ gʊta bʊr zi. Kʊ ŋ y'a ma, ŋ ʊ, a hoser naa do ba bɩ minto y'a ka, ŋnɩ bʊr k'a b'a zɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","*Farizɛɛnrɔ wɔɔ n'a hɩm kʊ m, ŋ ʊ: «Awɔɔ yɩ, a dɔ a ʊ, a b'a dam ma, a hɔsɩ ba y. K'a dɩga gʊɔɔ haay kʊ ŋ nɩ zure a jɛ ʊ!» ");
INSERT INTO bib_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Cibsa k'a n ta ʊ bɩ minto, grɛkkɩrɔ gɔsɩnnɔ der k'a Woso da ʊ. ");
INSERT INTO bib_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ŋ n a hɩ Galilee kʊ Bɛtsayɩdaa gʊaa Filipi m, ŋ ʊ: «Wɔɔ harzaa, wɔɔ lɛ n taa k'ʊ Yeezuu yɩ.» ");
INSERT INTO bib_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipi n ta, an aa hɩ Andɩr m, ŋn'a zɛ kʊ ra, ŋn'a hɩ Yeezuu m. ");
INSERT INTO bib_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Wakatɩ a ku kʊ *Gʊaanyɩ bɩ n lɛbɔʊrɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m: kʊ hɔyaa a zo tara ʊ, a n ga y, gɔɔta an nawʊrɛ a deem. Bɩ, k'a ga, nyɩ an n'a dam gʊta. ");
INSERT INTO bib_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Gʊaa k'a a mɩsɩrbaa ŋʊa, a b'a yɩrɛ y. Bɩ, gʊaa k'a kaanm a mɩsɩrbaa m durnya naa do nɔ ʊ, a mɩsɩrbaa yɩm *mɩsɩrbaa k'a nyarɛ ba ʊ bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kʊ gʊaa lɛ taa k'a mɔɔ zi ba k'an zu mɔɔ ʊ, bɩncɛ kʊ mɔɔ n ta ʊ bɩ, mɔɔ zibəənyɩ bɩ nyɩntam b'ʊ sɔ. Gʊaa k'a mɔɔ zi ba, Zɩ y'a daŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Naa ma bɩ, mɔɔ heer a zɛ kʊ ma, bɩ, kʊ m a hɩ mɔɔ ʊ lɔ? Kʊ m a hɩ, mɔɔ ʊ: M Zɩ, mɔɔ bʊmbɔ wakatɩ naa do ma gɛɛ? Bɩ, wakatɩ naa do minto y'a ka, mɔɔ n bʊr. ");
INSERT INTO bib_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Zɩ, ɩ lɛ bɔ ɩ tɔ ʊ.» Leer n a to brama, an a hɩ, a ʊ: «Mɔɔ n lɛ bɔ ʊ, bɩ mɔɔ yɩ m yarɛ, m m lɛ bɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Gʊɔɔ kʊ ŋ nyɩnta b'ʊ, ŋnɩ leer bɩ ma rɔ wɔɔ y'a hɩrɛ, ŋ ʊ, brama ɩ həən si. Gɔsɩnnɔ ʊ, malɛɛka ɩ meer ba kan kɩ. ");
INSERT INTO bib_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yeezuu n a hɩ, a ʊ: «Leer naa do n bɔ mɔɔ minto y, bɔ a ʊ, awɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Durnya naa do dʊdɔ karɛ n naa kɛɛrɛ, bɩ, n lam durnya naa do cir bɩ ra, an bɔ garga ra. ");
INSERT INTO bib_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bɩ kʊ n mɔɔ busu brama durnya burə ʊ, mɔɔ gʊɔɔ haay gaarɛ m zi.» ");
INSERT INTO bib_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Meerbaarɔ nɔɔn duro ba Yeezuu ʊ, k'a a zɛ zaa hɩnka. ");
INSERT INTO bib_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Gʊɔɔ wɔɔ n a nyɩ bɔ nʊ, ŋ ʊ: «*Lɛrɔ ci b'a dɩnda wɔɔ m, a ʊ: *Krista gɔɔtam dɔmɩm k'a nyarɛ ba ʊ bɩ nɔ ʊ. Ɩbɩɩ ba lɔ, ɩ n'a hɩrɛ, ɩ ʊ, n Gʊaanyɩ bɩ busum brama? Gʊaanyɩ naa do, nka nɩ?» ");
INSERT INTO bib_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeezuu n a hɩ ŋ nɩ, a ʊ: «Lɛɛgure gɔɔta awɔɔ minto dɔmɩm poore nɔ ʊ. Bala, lɛɛgure k'a gɔɔta an ta ʊ bɩ, k'a ta a nɔ ʊ, a b'a ka monsigə bɩ n zɛ awɔɔ ra y. Bala, gʊaa k'a nɩ tam monsigə ʊ bɩ n a dɔ kʊ ta an nawʊm ka y. ");
INSERT INTO bib_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kʊ lɛɛgure bɩ gɔɔta an ta ʊ bɩ, k'a sɩra ka lɛɛgure b'ʊ, k'a a ba lɛɛgure nyɩnɔ.» Yeezuu k'a meer ba kan ŋ kɩ ncɩnaaʊ bɩ, a a hʊr an a nyaakʊm da ŋ lɛɛ. ");
INSERT INTO bib_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Baa kan hoserlo k'a ŋ ba ŋ mɩm ʊ rɔ wɔɔ kɩ haay, ŋ n sɩra ka ʊ y, ");
INSERT INTO bib_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","kʊ hɔ kʊ *wosolɛsinnɩsorazaa Ezayii a hɩ n bɩ n kʊ yɩ: ‹Zuuba, nka ɩ hɔ kʊ wɔɔ hɩ bɩ si? Nka Zuuba a paŋŋa hɩnka nɩ?› ");
INSERT INTO bib_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ezayii deem-deem b'a hɩ kʊ bɔ minto y'a ka, ŋ b'a dam ma, ŋn'a si y: ");
INSERT INTO bib_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‹A ŋ mɩm ta, an ŋ heer ka, kʊ ŋ mɩm b'a da ma an lɛɛ yɩ, kʊ ŋ heer b'a da ma an a jɩ ma y, kʊ ŋ b'a bɔ a taam, kʊ m ŋ waa y.› ");
INSERT INTO bib_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezayii naa do hɩ, bala, a Yeezuu lɛbɔʊrɛ bɩ yɩ, an a mim dɩnda. ");
INSERT INTO bib_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kan bɩ kɩ haay, jɩtannɔ wɔɔ barla, gʊta a mim si. Bɩ, *farizɛɛnrɔ wɔɔ minto, ŋ bɩr a kasɛtɩ karɛ y. Bala, ŋ yɩ nyi bam, ŋ y'a la a ra *sokʊmacɛ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gʊɔɔ lɛbɔʊrɛ ŋ n'a ŋʊarɛ, ŋ bɩr a kam Woso hɔ ma y. ");
INSERT INTO bib_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yeezuu n a leer busu, an a hɩ, a ʊ: «Gʊaa k'a sɩra ka mɔɔ ʊ bɩ, sɩra bɛɛ a ka mɔɔ ʊ y, Zɩ k'a mɔɔ nyɔɔ b'a sɩra ka ʊ. ");
INSERT INTO bib_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bɩ gʊaa k'a nɩ mɔɔ yɩrɛ, Zɩ k'a mɔɔ nyɔɔ b'a n'a yɩrɛ. ");
INSERT INTO bib_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mɔɔ m lɛɛgure, m bʊr durnya ʊ, kʊ gʊaa k'a nɩ sɩra kam mɔɔ ʊ bɩ bɩ gɔɔta monsigə ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kʊ gʊaa mɔɔ lemim ma, b'a n a si y, mɔɔ bɛɛ n n'a dʊdɔ karɛ y. Bala, mɔɔ n bʊr kʊ m bɩ durnya dʊdɔ ka y, bʊr mɔɔ ʊ kʊ m bɩ durnya bʊmbɔ. ");
INSERT INTO bib_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Gʊaa k'a kaanm mɔɔ m, a n mɔɔ lemim bɩ si, a zaa dʊdɔkər ta ʊ. Lemim kʊ mɔɔ hɩ bɩ y'a dʊdɔ kam durnya nyarɛ hinni ʊ. ");
INSERT INTO bib_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mɔɔ n m mɩŋŋa mim dɩnda y, Mɔɔ Zɩ k'a mɔɔ nyɔɔ b'ɩ hɔ kʊ mɔɔ m ga m, m a hɩ bɩ hɩ mɔɔ m, kʊ m a hɩ. ");
INSERT INTO bib_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mɔɔ dɔ mɔɔ ʊ, a lɛ bɩ, *mɩsɩrbaa k'a nyarɛ ba ʊ bɩ m. Hɔ kʊ mɔɔ n'a hɩm bɩ, a hɩ mɔɔ nawʊrɛ amba mɔɔ Zɩ a hɩ mɔɔ m bɩ m.» ");
INSERT INTO bib_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","*Pakkɩ cibsa k'a n a ku cɩna bɩ, Yeezuu k'a a dɔ a ʊ a wakatɩ a ku bɩ, k'a bɔ durnya nɔ ʊ a a wusigə a Zɩ zi bɩ, a a mɩŋŋa gʊɔɔ kʊ ŋ nɩ durnya ʊ rɔ wɔɔ ŋʊa kan ŋʊarɛ gʊta kɩ. ");
INSERT INTO bib_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","A bʊr an nɩ hɔbɩrɛ bɩm, bɩ ma bɩ, Sʊtaana hɔɔndarɛ da Sɩmɔɔn nyɩ Zidas Iskarɩyɔtɩ kʊ gʊaa bɩ heer ʊ, k'an a nyasʊ an a ka. ");
INSERT INTO bib_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","K'a a dɔ a ʊ, Zɩ bɩ hɔ haay zar a wɔ ʊ bɩ, b'a to a ʊ Woso zi, a a bɔ an nɩ tam zi bɩ, ");
INSERT INTO bib_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yeezuu wuti hɔbɩrɛ bɩ ra, an a zaba bɩ bɔ a ra, an a cɩnta, an pɛɛra sa an a so a ʊ. ");
INSERT INTO bib_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","A n hi tɔ mɔr ʊ, an a sɩŋŋɩda ba an n'a karɩndanyɩnɔ wɔɔ gannɔ sʊrgɔm, an nɩ pɛɛra k'a so a ʊ bɩ nʊnnɔrɛ ŋ ma. ");
INSERT INTO bib_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A n aa lee ku Sɩmɔɔn Pɩyɛɛr zi. Pɩyɛɛr n a hɩ m, a ʊ: «A n a ga m, k'ɩbɩɩ m mɔɔ gannɔ sʊrgɔ y, Zuuba!» ");
INSERT INTO bib_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Ɩbɩɩ n hɔ kʊ mɔɔ n'a bam bɩ jɩ dɔ cɩna y, b'ɩbɩɩ zɛm b'a dɔ.» ");
INSERT INTO bib_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pɩyɛɛr n a hɩ m, a ʊ: «Ɩbɩɩ bɩ mɔɔ gannɔ sʊrgɔm fɩɩga y!» Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Kʊ mɔɔ n ɩbɩɩ gannɔ sʊrgɔ, mɔɔ gʊaa bɛɛ n'ɩbɩɩ nɩ y.» ");
INSERT INTO bib_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Sɩmɔɔn Pɩyɛɛr n a hɩ m, a ʊ: «Zuuba, ɩ bɩ mɔɔ gannɔ sʊrgɔ bala y, mɔɔ wɔrɔ sʊrgɔ sɔ kan mɔɔ mim kɩ!» ");
INSERT INTO bib_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeezuu n a hɩ m, a ʊ: «Gʊaa k'a a zʊr bɩ lɛ baa zʊrlɛ ma dɔ y, bala, a hu bɔ jilli. B'awɔɔ, dintim b'awɔɔ ma dɔ y. Bɩ, awɔɔ haay bɛɛ mɔɔ n'a hɩrɛ a ma y.» ");
INSERT INTO bib_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Bala, a gʊaa k'a n'a nyasʊm k'a ka bɩ dɔ. Bɩ minto y'a ka, a ʊ: «Awɔɔ haay hu bɛɛ bɔ y.» ");
INSERT INTO bib_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yeezuu ka ŋ gannɔ sʊrgɔ an a nya bɩ, a a huu bɩ sa, an a da a ra, an nyɩnta hɔbɩrɛ bɩ bɩncɛ ʊ b'ʊ, an n'a hɩrɛ ŋ nɩ, a ʊ: «Awɔɔ hɔ kʊ mɔɔ ba awɔɔ m bɩ jɩ dɔ ra? ");
INSERT INTO bib_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Awɔɔ ɩ mɔɔ birm, Karɩnsaamba gɛɛ Zuuba, a maam karɛ, bala, a m mɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","K'awɔɔ Zuuba kan a karɩnsaamba kɩ m mɔɔ m bɩ y'a ka, mɔɔ n awɔɔ gannɔ sʊrgɔ, b'awɔɔ a ga m sɔ a kʊ gannɔ sʊrgɔ. ");
INSERT INTO bib_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Bala, makra mɔɔ ka awɔɔ ʊ, kʊ mɔɔ ba awɔɔ minto bɩ, k'a ba sɔ. ");
INSERT INTO bib_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, zibəənyɩ n lɛ da a karɩnsaamba nɩ y, bɩ zibəəzaa kʊ n y'a nyɔɔ n lɛ da gʊaa k'a nyɔɔ bɩ nɩ y. ");
INSERT INTO bib_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","K'awɔɔ naa haay dɔ bɩ, k'awɔɔ ba maam, mimbirenyɩntazannɔ n'awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mɔɔ bɩr meer bɩ barɛ awɔɔ haay minto y. Mɔɔ gʊɔɔ kʊ mɔɔ ŋ bɔ ʊ rɔ wɔɔ dɔ. Kʊ *Wosoci bɩ meerbaa naa do n kʊ yɩ: ‹Gʊaa k'a nɩ hɔ bɩm kan mɔɔ kɩ b'a ba mɔɔ jɩm.› ");
INSERT INTO bib_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","A hɩ mɔɔ nawʊrɛ awɔɔ m kɛɛrɛ, kʊ mim bɩ n lee ku cɩna bɩ minto, k'a bɩ bʊr, k'a sɩra ka, a ʊ: A n ta ʊ bɩ m mɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, kʊ mɔɔ gʊaa nyɔɔ, n n a si, mɔɔ n yɩ m si, bɩ kʊ n mɔɔ si, Zɩ k'a mɔɔ nyɔɔ bɩ n y'a si.» ");
INSERT INTO bib_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kʊ Yeezuu meer ba ncɩnaaʊ bɩ, a heer a zɛ kʊ ma, an a hɩ, a ʊ: «Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, awɔɔ gʊaa deem mɔɔ nyasʊrɛ an mɔɔ ka.» ");
INSERT INTO bib_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Karɩndanyɩnɔ wɔɔ nɩ dɩgam kʊ ma, ŋn'a mɩŋŋa larlɛ kʊ nka mim an n'a hɩm gɛ. ");
INSERT INTO bib_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Karɩndanyɩ deem kʊ Yeezuu nyɩnta an a ŋʊa bɩ nyɩnta a jɩr ʊ. ");
INSERT INTO bib_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sɩmɔɔn Pɩyɛɛr n kʊtɩ zɛ m, a ʊ, an laaka da han: «Nka an n'a hɩm ma gɛ?» ");
INSERT INTO bib_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Karɩndanyɩ bɩ n zerga Yeezuu cɩ ra, an a hɩ m, a ʊ: «Zuuba, nka nɩ?» ");
INSERT INTO bib_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Gʊaa kʊ mɔɔ nɩ bur nyɔɔm taanm ʊ m a ka ʊ bɩ, bɩ m.» K'a bur kur bɩ nɔ ma bɩ, a a ka Iskarɩyɔtɩ kʊ gʊaa Sɩmɔɔn nyɩ Zidas ʊ. ");
INSERT INTO bib_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zidas k'a bur kur bɩ si bɩ, Sʊtaana gasʊ ʊ dɔmɩm bɩ do ʊ. Yeezuu n a hɩ m, a ʊ: «Hɔ k'ɩ ʊ k'ɩ ba bɩ, a ba zɔɔ.» ");
INSERT INTO bib_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ŋ haay kʊ ŋ nyɩnta b'ʊ rɔ wɔɔ gʊaa deem n a dɔ kʊ bɔ minto, an naa hɩ y. ");
INSERT INTO bib_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kʊ Zidas n ta busoo bɩ m bɩ, gɔsɩnnɔ y'a hɔɔn darɛ, ŋ ʊ, a hɩ Yeezuu ʊ k'an aa cibsa bɩ mɔdrɔ si, gɛɛ, an aa hɔ niŋŋə ka cicirzannɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Zidas k'a bur bɩ kur bɩ si bɩ, a bɔ lɛɛm: Bɩ ma bɩ, gum da. ");
INSERT INTO bib_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Zidas k'a bɔ bɩ, Yeezuu a hɩ, a ʊ: «Naa ma bɩ, *Gʊaanyɩ bɩ lɛbɔʊrɛ yɩ, bɩ Woso lɛbɔʊrɛ yɩ a tɔ ma. ");
INSERT INTO bib_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Woso y'a lɛ bɔŋ ʊ a zi, bɩ k'a yɩ poore Woso y'a lɛ bɔŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","M nyɩnɔ, dɔmɩm gɔɔta poore kʊ mɔɔ n gɔɔta kan awɔɔ kɩ. Awɔɔ y'a kam mɔɔ ma. Amba mɔɔ hɩ zɩɩfʊrɔ m bɩ m, bɩncɛ kʊ mɔɔ n nɩ taŋ ʊ bɩ, awɔɔ bɩ lee kum b'ʊ y. A hɩ mɔɔ nawʊrɛ awɔɔ m kɛɛrɛ sɔ. ");
INSERT INTO bib_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lɛ daa mɔɔ n n'a karɛ awɔɔ ʊ: k'a kʊ ŋʊa. Amba mɔɔ awɔɔ ŋʊa bɩ, k'a kʊ ŋʊa maam sɔ. ");
INSERT INTO bib_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ncɩnaaʊ bɩ, gʊaa haay y'a dɔrɛ, a ʊ, mɔɔ karɩndanyɩnɔ n'awɔɔ m, k'awɔɔ ɩ kʊ ŋʊarɛ.» ");
INSERT INTO bib_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sɩmɔɔn Pɩyɛɛr n a hɩ m, a ʊ: «Zuuba, ta ɩbɩɩ n nawʊm ka?» Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Ɩbɩɩ b'ɩ dam ma ɩ zu mɔɔ ʊ ɩ ta bɩncɛ kʊ mɔɔ n nɩ taŋ ʊ b'ʊ cɩna y, bɩ k'a yɩ poore, ɩ zɛm bɩ zu mɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pɩyɛɛr n a nyɩ bɔ nʊ, a ʊ: «Zuuba, bɔ minto mɔɔ bɩ m dam ma, m zu ɩbɩɩ ʊ dɩɩtaa? Mɔɔ yɩ m mɩŋŋa meeyaa karɛ ɩbɩɩ minto!» ");
INSERT INTO bib_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «K'ɩ mɩŋŋa meeyaa ka mɔɔ minto nɩ? Sɩra paan… mɔɔ n'a hɩrɛ ɩbɩɩ m, ɩbɩɩ bɩsɩ kam mɔɔ ma gallɛm kaakʊ, koo n bɔkarɛ, an baa da.» ");
INSERT INTO bib_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","«A b'a heer zar y. K'a sɩra ka Woso ʊ, k'a sɩra ka mɔɔ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cɛrɔ ta ʊ gʊta mɔɔ Zɩ har ʊ. Kʊ n bɛɛ mɔɔ b'a hɩrɛ awɔɔ m, kʊ m aa bɩncɛ k'awɔɔ n nɩ zɛm bɩ nyɩnta ʊ bɩ banka y. ");
INSERT INTO bib_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kʊ mɔɔ bɩ ta, m aa a banka awɔɔ minto, mɔɔ yɩ m bɔrɛ, m b'awɔɔ gaa, bɩncɛ niŋŋə kʊ mɔɔ m ta ʊ bɩ, k'awɔɔ n bɩr b'ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Awɔɔ bɩncɛ kʊ mɔɔ n nɩ taŋ ʊ bɩ zaa dɔ.» ");
INSERT INTO bib_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma n a hɩ m, a ʊ: «Zuuba, wɔɔ n a dɔ kʊ ta ɩbɩɩ nawʊm ka y. Wɔɔ y'a bam lɔ, k'ʊ zaa bɩ dɔ?» ");
INSERT INTO bib_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeezuu n a hɩ m, a ʊ: «Mɔɔ n zaa, kan sɩra kɩ, *mɩsɩrbaa kɩ. Gʊaa b'a dam ma, an ta Zɩ zi kʊ mɔɔ minto bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kʊ nyɩnta awɔɔ ʊ a mɔɔ dɔ, awɔɔ mɔɔ Zɩ bɩ dɔm sɔ. Bɩ dɩɩtaa naa, awɔɔ dɔ, a yɩ sɔ.» ");
INSERT INTO bib_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi n a hɩ m, a ʊ: «Zuuba, Zɩ bɩ hɩnka wɔɔ m, bɩ wɔɔ bɔ.» ");
INSERT INTO bib_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeezuu n a hɩ m, a ʊ: «Mɔɔ nyɩnta kan awɔɔ kɩ laatʊ, ɩbɩɩ n gɔɔta, ɩ n mɔɔ dɔ ra, Filipi! Gʊaa k'a mɔɔ yɩ bɩ, a Zɩ bɩ yɩ sɔ. Bɔ minto ɩbɩɩ n'a hɩrɛ ɩ ʊ, n n Zɩ hɩnka ɩ nɩ? ");
INSERT INTO bib_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ɩbɩɩ n sɩra ka, ɩ ʊ, mɔɔ ɩ kan Zɩ kɩ, Zɩ bɩ nɩ kan mɔɔ kɩ ra? Meerbaarɔ kʊ mɔɔ nɩ ŋ bam kan awɔɔ kɩ rɔ wɔɔ, mɔɔ bɩr ŋ barɛ, m mɩŋŋa paŋŋa nɩ y! Zɩ k'a nɩ kan mɔɔ kɩ bɩ n'a mɩŋŋa zi barɛ. ");
INSERT INTO bib_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","K'a mɔɔ mim si a ʊ, mɔɔ ɩ kan Zɩ kɩ, Zɩ nɩ kan mɔɔ kɩ, bɩ, k'awɔɔ n mɔɔ meerbaa bɩ si, k'a si zibəəro nɔɔn duro minto. ");
INSERT INTO bib_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, gʊaa k'a sɩra ka mɔɔ ʊ, a zibəəro kʊ mɔɔ nɩ ŋ bam nɔ wɔɔ barɛ. A zibəəro bam gʊta, ŋnɩ lɛ da nawɔnnɔ m, bala, ta mɔɔ nawʊm Zɩ zi. ");
INSERT INTO bib_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Hɔ haay k'awɔɔ n n'a yɛm mɔɔ tɔ ma, mɔɔ y'a barɛ, kʊ Zɩ m lɛbɔʊrɛ yɩ Nyɩ bɩ zi. ");
INSERT INTO bib_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","K'awɔɔ hɔ niŋŋə yɛ mɔɔ tɔ ma, mɔɔ y'a barɛ. ");
INSERT INTO bib_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","K'awɔɔ ɩ mɔɔ ŋʊarɛ, k'a mɔɔ lɛrɔ si, a zu ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mɔɔ y'a yɛrɛ m Zɩ han k'an Daahanzaa vanta ka a ʊ, k'an gɔɔta kan awɔɔ kɩ dɔmɩm haay. ");
INSERT INTO bib_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","A m sɩra *Ɛspri, durnya b'a dam ma an a si y. Bala, n bɩr a yɩrɛ, bɩ n n a dɔ sɔ y. B'awɔɔ dɔ, bala, a ɩ kan awɔɔ kɩ, an n'awɔɔ heer ʊ. ");
INSERT INTO bib_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mɔɔ b'awɔɔ tom sʊnnɔ y, mɔɔ zɛrɛ awɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A gɔɔta poore, durnya b'a yarɛ an mɔɔ yɩ y. B'awɔɔ mɔɔ yɩm mɩsɩr, awɔɔ mɩsɩrbaa bam sɔ. ");
INSERT INTO bib_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Hinni bɩ do ʊ, awɔɔ y'a dɔrɛ a ʊ, mɔɔ ɩ kan Zɩ kɩ, awɔɔ nɩ kan mɔɔ kɩ, mɔɔ nɩ kan awɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Gʊaa k'a nɩ mɔɔ lɛrɔ wɔɔ m, an nɩ zure ŋ ʊ bɩ, a zaa ɩ mɔɔ ŋʊam. Gʊaa k'a nɩ mɔɔ ŋʊarɛ, mɔɔ Zɩ bɩ y'a ŋʊam sɔ, kʊ mɔɔ nɩ, mɔɔ y'a ŋʊarɛ, m m hɩnka m.» ");
INSERT INTO bib_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ziidi, Zidas Iskarɩyɔtɩ kʊ gʊaa bɩ bɛɛ y, bɩ n a hɩ m, a ʊ: «Zuuba, ɩbɩɩ y'a bam lɔ ɩ ɩ hɩnka wɔɔ m, b'ɩbɩɩ b'ɩ hɩnkam durnya nɩ?» ");
INSERT INTO bib_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Kʊ gʊaa ɩ mɔɔ ŋʊarɛ, a zum mɔɔ lemim ʊ, bɩ mɔɔ Zɩ y'a ŋʊarɛ. Wɔɔ zɛm zi, ʊ bɩ gɔɔta kan kɩ. ");
INSERT INTO bib_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Gʊaa k'a n mɔɔ ŋʊa bɩ bɩr zum mɔɔ lemim ʊ y. Bɩ lemim k'awɔɔ n'a mam naa, mɔɔ hɔ bɛɛ y, a to a ʊ Zɩ k'a mɔɔ nyɔɔ bɩ zi. ");
INSERT INTO bib_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nawɔnnɔ hɩ mɔɔ nawʊrɛ awɔɔ m kʊ mɔɔ gɔɔta m nɩ kan awɔɔ kɩ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Daahanzaa Sɛnt-Ɛspri kʊ Zɩ n n'a nyɔɔm mɔɔ tɔ minto bɩ hɔ haay dɩndarɛ awɔɔ m, a hɔ haay kʊ mɔɔ hɩ awɔɔ m nɔ wɔɔ tɔ darɛ awɔɔ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mɔɔ laafɩɩ to awɔɔ m, m nɩ m laafɩɩ karɛ awɔɔ ʊ. Mɔɔ bɩr a karɛ amba durnya n'a kam bɩ nɩ y. A b'a ka a heer n a zar gɛɛ, a da n bɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Awɔɔ ma mɔɔ n a hɩ awɔɔ m, mɔɔ ʊ, mɔɔ cenim, bɩ mɔɔ yɩ m bɔrɛ, m bʊr awɔɔ zi. K'awɔɔ ɩ mɔɔ ŋʊarɛ, awɔɔ y'a heer nyɔɔm kʊ mɔɔ nɩ tam Zɩ zi bɩ minto. Bala, Zɩ bɩ lɛ da mɔɔ ra. ");
INSERT INTO bib_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Minno nɔɔn duro hɩ mɔɔ nawʊrɛ awɔɔ m naa ma, bɩ ŋ n a ku cɩna y. Kʊ ŋ b'a ku, k'a ŋ si. ");
INSERT INTO bib_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Naa ma kɛɛrɛ bɩ, mɔɔ bɩ m yarɛ, m meer gʊta ba kan awɔɔ kɩ y. Bala, durnya cir b'ɩ zɛrɛ. B'a hɔsɩ ba mɔɔ gʊr zi y. ");
INSERT INTO bib_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Bɩ, kʊ durnya n a dɔ a ʊ, mɔɔ yɩ m Zɩ ŋʊarɛ, m nɩ zi barɛ amba Zɩ lɛ ka mɔɔ ʊ bɩ m. K'a wuti, k'ʊ cem.» ");
INSERT INTO bib_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«*Dɩvɛn gɔ paan… m mɔɔ m, bɩ wutuzaa m mɔɔ Zɩ m. ");
INSERT INTO bib_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mɔɔ vəŋŋə haay k'a bɩr nyɩ dam bɩ, n y'a zɛm la, n n a zo. Bɩ, mɔɔ vəŋŋə haay k'a nyɩ da bɩ, n y'a bankarɛ, k'an nyɩ da an lɛ da biisi ra. ");
INSERT INTO bib_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Awɔɔ lɛɛ ka, a bankarɛ yɩ kan lemim kʊ mɔɔ hɩ awɔɔ m bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","K'a gɔɔta kan mɔɔ kɩ amba mɔɔ nɩ kan awɔɔ kɩ bɩ m. Bala, kʊ dɩvɛn gɔ vəŋŋə bɩ n gɔɔta kan kɩ, a b'a dam ma, an nyɩ da a zim y. B'a hɔdeem k'an awɔɔ kɩ, k'awɔɔ n a naasʊ mɔɔ ma y.» ");
INSERT INTO bib_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Mɔɔ m *dɩvɛn gɔ, awɔɔ n'a vəŋŋoo. Gʊaa k'a a naasʊ mɔɔ ma, mɔɔ nɩ m naasʊ ma sɔ, a zaa nyɩ dam gʊta, bala, kʊ mɔɔ ba kan awɔɔ kɩ, awɔɔ b'a dam ma a hɔsɩ ba y. ");
INSERT INTO bib_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kʊ gʊaa n a naasʊ mɔɔ ma, n y'a zom garga ra, amba gɔvəŋŋə kʊ n y'a zɛ ra hɔ bɩ m, an ga, n n'a gʊr n n'a da sɛ rɛ, an a bɩ. ");
INSERT INTO bib_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","K'awɔɔ a naasʊ mɔɔ ma, mɔɔ lemim bɩ nɩ kan awɔɔ kɩ, awɔɔ n hɔ k'awɔɔ lɛ n taa bɩ yɛ, a y'a yɩrɛ. ");
INSERT INTO bib_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","K'awɔɔ nyɩ da gʊta, bɩ n nɩ nyɩntam mɔɔ Zɩ lɛbɔʊrɛ, b'awɔɔ gɔɔtam mɔɔ karɩndanyɩnɔ.» ");
INSERT INTO bib_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Kʊ Zɩ mɔɔ ŋʊa bɩ, mɔɔ awɔɔ ŋʊa sɔ. K'a gɔɔta mɔɔ ŋʊarɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","K'awɔɔ zu mɔɔ lɛrɔ wɔɔ ʊ, awɔɔ gɔɔta mɔɔ ŋʊarɛ nɔ ʊ, amba mɔɔ nɩ zum m Zɩ lɛrɔ ʊ, m gɔɔta a ŋʊarɛ nɔ ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Naa hɩ mɔɔ ʊ awɔɔ nɩ, kʊ mɔɔ heernyɔɔ n bɩr kan awɔɔ kɩ, k'awɔɔ heernyɔɔ n bɩr mɩŋŋa paan….» ");
INSERT INTO bib_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","«Ba mɔɔ lɛ bɩ n na: k'a kʊ ŋʊa, amba mɔɔ awɔɔ ŋʊa bɩ m. ");
INSERT INTO bib_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gʊaa ŋʊarɛ ba ʊ an lɛ da gʊaa k'a mɩsɩrbaa ka zɛ ma gʊɔɔ k'a ŋ ŋʊa rɔ wɔɔ minto y. ");
INSERT INTO bib_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Hɔ kʊ mɔɔ hɩ awɔɔ m bɩ, k'awɔɔ ba, mɔɔ gʊaasɩbɔɔ n'awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mɔɔ bɩ m yarɛ m awɔɔ bir, m zibəənyɩnɔ y, bala, zibəənyɩ bɩ n hɔ k'a zuuba n'a bam bɩ dɔ y. Awɔɔ bir mɔɔ nawʊrɛ, m gʊaasɩbɔɔ, bala, hɔ kʊ mɔɔ ma m Zɩ zi bɩ, mɔɔ ka awɔɔ n a dɔ. ");
INSERT INTO bib_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Awɔɔ bɛɛ mɔɔ bɔ ʊ y, mɔɔ y'awɔɔ bɔ ʊ, m zibəə ka awɔɔ ʊ, k'a ta, k'a nyɩ da, k'awɔɔ nyɩ bɩ nya y. Bɩ y'a ka, k'awɔɔ hɔ haay yɛ mɔɔ Zɩ bɩ han mɔɔ tɔ ma, a y'a karɛ awɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hɔ kʊ mɔɔ n'a hɩm k'awɔɔ n a ba bɩ, k'a kʊ ŋʊa.» ");
INSERT INTO bib_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Kʊ durnya sɔ awɔɔ m, k'a dɔ a ʊ, lɛɛ a ka an sɔ mɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kʊ durnya bɩ zannɔ n'awɔɔ m, durnya bɩ hɔ k'a so ʊ bɩ ŋʊam. Bɩ durnya bɩ zannɔ bɛɛ n'awɔɔ nɩ y. Mɔɔ y'awɔɔ bɔ ʊ durnya nɔ ʊ a hɔ, bɩ y'a ka, durnya n sɔ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","K'a hɔ kʊ mɔɔ hɩ awɔɔ m bɩ tɔ da a nɔ ʊ: zibəənyɩ n lɛ da a zuuba ra y. Kʊ ŋ fɩr ka mɔɔ ma, ŋ fɩr karɛ awɔɔ ma sɔ. Kʊ ŋ zu mɔɔ lemim b'ʊ, ŋ zure awɔɔ hɔ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ŋ naa haay barɛ awɔɔ m mɔɔ tɔ ma, bala, ŋ n Zɩ k'a mɔɔ nyɔɔ bɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kʊ mɔɔ ɩ nɩ bʊr ŋ bire ʊ, m bɩ hɔ k'an ta ʊ hɩ ŋ nɩ, ŋ mimbʊnyaa bɩ nyɩntaŋ ʊ y. Bɩ dɩɩtaa naa, ŋ mimbʊnyaa bɩ sugur ba ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Gʊaa k'a sɔ mɔɔ m, sɔ a ʊ mɔɔ Zɩ m sɔ. ");
INSERT INTO bib_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kʊ mɔɔ ɩ nɩ zibəəro nɔɔn duro kʊ gʊaa n a ba rɔ nɔɔm ba ŋ bire ʊ, ŋ mimbʊnyaa bɩ nyɩntaŋ ʊ y. Bɩ dɩɩtaa naa, ŋ yɩ ŋ yɩ, ŋn'a gu, ŋn'ɩ sɔm wɔɔ m, mɔɔ kan m Zɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","A lɛ taa k'a hɩ a ʊ, lemim kʊ n y'a gʊrsɩra ba ŋ *lɛrɔ ci nɔ ʊ bɩ kʊ yɩ. ‹N sɔ mɔɔ m, b'a jɩ ba ʊ y.› » ");
INSERT INTO bib_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Kʊ mɔɔ ta m Zɩ zi, mɔɔ Daahanzaa bɩ nyɔɔrɛ awɔɔ m. Sɩra *Ɛspri k'a n'a tore m Zɩ zi bɩ, a mɔɔ kasɛtɩ karɛ a zim. ");
INSERT INTO bib_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Awɔɔ sɔ, awɔɔ mɔɔ kasɛtɩ kam, bala, awɔɔ ɩ kan mɔɔ kɩ hallɩ a sɩŋŋɩda ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Naa haay hɩ mɔɔ ʊ awɔɔ m, k'awɔɔ b'a gəm zɛ y. ");
INSERT INTO bib_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ŋ larɛ awɔɔ ra *sokʊmacɛrɔ ʊ. Dɔmɩm ta ʊ an nɩ zɛm, gʊaa k'a n'awɔɔ zɛm gər bɩ y'a hɔɔn darɛ a ʊ, mannɩ a ba, a ka Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ŋ y'a barɛ awɔɔ m ncɩnaaʊ, bala, ŋ n Zɩ dɔ, ŋ n mɔɔ dɔ sɔ y. ");
INSERT INTO bib_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Naa hɩ mɔɔ ʊ awɔɔ m, kʊ wakatɩ bɩ bɩ bʊr, k'a hɔ kʊ mɔɔ hɩ awɔɔ m bɩ tɔ da a nɔ ʊ.» «Mɔɔ n lɛɛ ka m a hɩ awɔɔ m a sɩŋŋɩda ʊ y, bala, mɔɔ nyɩnta kan awɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Bɩ naa ma bɩ, ta mɔɔ nawʊm Zɩ k'a mɔɔ nyɔɔ bɩ zi, b'awɔɔ bire ʊ bɩ, gʊaa ba ʊ, an nɩ mɔɔ larm, a ʊ: ta ɩ nawʊm ka? ");
INSERT INTO bib_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kʊ mɔɔ hɩ awɔɔ m bɩ minto y'a ka, awɔɔ heer n a zar. ");
INSERT INTO bib_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sɩra mɔɔ hɩ awɔɔ m. Awɔɔ daahan minto y'a ka, mɔɔ nɩ tarɛ. Bɩ, kʊ mɔɔ n doo, Daahanzaa bɩ bɩ zɛrɛ awɔɔ zi y. Bɩ kʊ mɔɔ doo, mɔɔ y'a nyɔɔrɛ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","K'a mɩŋŋa bɩ bʊr, a mimbʊnyaa, tɩrgabaa kan dʊdɔkarɛ kɩ, kʊ ŋ lʊnlɔ, a y'a hɩnkam durnyazannɔ m. ");
INSERT INTO bib_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mimbʊnyaa bɩncɛ ʊ, ŋ n sɩra ka mɔɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tɩrgabaa bɩncɛ ʊ, ta mɔɔ nawʊrɛ m Zɩ zi, b'awɔɔ b'a yarɛ a mɔɔ yɩ y. ");
INSERT INTO bib_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Dʊdɔkarɛ bɩncɛ ʊ, n durnya cir bɩ dʊdɔ ka.» ");
INSERT INTO bib_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Hɔ gʊta ta ʊ mɔɔ n n'a hɩrɛ awɔɔ m, b'awɔɔ b'a dam ma, a ŋ si naa ma y. ");
INSERT INTO bib_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kʊ sɩra *Ɛspri bɩ bɩ bʊr, a y'awɔɔ dam sɩra haay zaa ra, bala, a bɛɛ n n'a mɩŋŋa meer barɛ y, bɩ, a hɔ k'a n'a mam bɩ hɩrɛ, a hɔ k'a nɩ zɛm bɩ dɩndarɛ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","A y'a lɛ bɔm mɔɔ ʊ, bala, a hɔ k'a nɩ mɔɔ ʊ bɩ sire, an a hɩ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Hɔ haay kʊ mɔɔ Zɩ n tam bɩ, mɔɔ hɔ m. Bɩ y'a ka, mɔɔ n a hɩ, mɔɔ ʊ, a hɔ kʊ mɔɔ n n'a hɩm bɩ hɩrɛ awɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«A gɔɔta poore, awɔɔ b'a yarɛ a mɔɔ yɩ mɩm ʊ y, bɩ k'a yɩ poore sɔ, awɔɔ mɔɔ yɩm.» ");
INSERT INTO bib_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","A karɩndanyɩnɔ gɔsɩnnɔ y'a hɩm kʊ m, ŋ ʊ: «Bɔ a a ŋʊa k'a hɩ wɔɔ nɩ? A gɔɔta poore awɔɔ b'a yarɛ a mɔɔ yɩ a mɩm ʊ y, b'a gɔɔta poore awɔɔ mɔɔ yɩrɛ, gɛɛ, ta mɔɔ nawʊrɛ, m Zɩ zi?» ");
INSERT INTO bib_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ŋ n a hɩrɛ, ŋ ʊ: «Poore naa do jɩ lɛ taa k'a hɩ, a ʊ lɔ? Wɔɔ bɩr hɔ k'a n'a hɩm bɩ jɩ dɔrɛ y!» ");
INSERT INTO bib_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeezuu k'a a dɔ a ʊ, karɩndanyɩnɔ wɔɔ lɛ taa k'a a lar bɩ, a a hɩ ŋ nɩ, a ʊ: «Laaka awɔɔ n'a dam kʊ han k'a mɔɔ mim bɩ jɩ dɔ ra? A gɔɔta poore awɔɔ b'a yarɛ a mɔɔ yɩ a mɩm ʊ y, poore awɔɔ mɔɔ yɩrɛ. ");
INSERT INTO bib_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, awɔɔ nyi karɛ, a zee da, durnyazannɔ n bɩr a heer nyɔɔm. Awɔɔ heer y'a zarm, b'awɔɔ heerzar y'a bam heernyɔɔ. ");
INSERT INTO bib_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kʊ lʊ ɩ nyɩ yɩrɛ, a ɩ busum ma, a dɔmɩm k'a ku bɩ minto. Bɩ k'a nyɩ bɩ yɩ, a fɩr yɩrɛ bɩ tɔ bɔ a nɔ ʊ. Heernyɔɔ gʊta ɩ kan kɩ k'a nyɩ yɩ durnya ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Bɩ minto y'a ka, awɔɔ nɩ heerzar nɔ ʊ naa ma, bɩ mɔɔ yɩ m yarɛ, m awɔɔ yɩ heernyɔɔ nɔ ʊ, bɩ, heernyɔɔ bɩ do, gʊaa b'a dam ma, an a zar y. ");
INSERT INTO bib_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ncɩnaaʊ, dɔmɩm bɩ do ʊ, awɔɔ b'a yarɛ a mɔɔ lar hɔsɩ minto y. Sɩra paan… mɔɔ n'a hɩrɛ awɔɔ m, k'awɔɔ hɔ yɛ mɔɔ Zɩ han mɔɔ tɔ ma, a y'a karɛ awɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","A n ta, an dɩɩtaa ku, awɔɔ n hɔsɩ yɛ mɔɔ tɔ ma y. K'a hɔ yɛ, a y'a yɩrɛ, k'awɔɔ heernyɔɔ bɩ n bɩr mɩŋŋa paan….» ");
INSERT INTO bib_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Naa haay hɩ mɔɔ ʊ awɔɔ m *hɔbɔkʊrɛnoom m, bɩ wakatɩ ɩ zɛm mɔɔ bɩ m yarɛ, m meer ba kan awɔɔ kɩ ncɩnaaʊ y. Mɔɔ Zɩ bɩ mim hɩrɛ awɔɔ m paan…. ");
INSERT INTO bib_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Hinni bɩ do ʊ bɩ, awɔɔ hɔ yɛm mɔɔ tɔ ma, bɩ mɔɔ n a hɩ awɔɔ m, mɔɔ ʊ, mɔɔ yaa dam Zɩ m awɔɔ tɔ ma y. ");
INSERT INTO bib_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bala, Zɩ b'awɔɔ ŋʊa. K'awɔɔ mɔɔ ŋʊa, a si sɔ, a ʊ, m to mɔɔ ʊ Woso zi bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","M to mɔɔ ʊ Zɩ zi, m bʊr durnya ʊ. Bɩ naa ma bɩ, bɔ mɔɔ nawʊm durnya ʊ, m n nɩ tam Zɩ zi.» ");
INSERT INTO bib_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","A karɩndanyɩnɔ wɔɔ n a hɩ m, ŋ ʊ: «Ba ɩbɩɩ nɩ meer bam paan… kɛɛrɛ ɩ wɔ saa hɔbɔkʊrɛnoom darɛ haay ma na. ");
INSERT INTO bib_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kɛɛrɛ naa, wɔɔ dɔ wɔɔ ʊ ɩbɩɩ hɔ haay dɔ, ɩbɩɩ lɛ baa kʊ gʊaa n ɩ lar y. Bɩ y'a ka, wɔɔ n a dɔ mɩŋŋa wɔɔ ʊ, ɩ to ɩbɩɩ ʊ Woso zi.» ");
INSERT INTO bib_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Dɩɩtaa awɔɔ bɔkarɛ an n'a hɩrɛ a ʊ, awɔɔ sɩra ka kɛɛrɛ ra? ");
INSERT INTO bib_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ba wakatɩ n nɩ zɛm na, b'a lee ku kɛɛrɛ, awɔɔ hɩsɩga dam, gʊaa biyəə n bɩr tarɛ a lɛ a lɛ, a mɔɔ to m deem. Bɩ mɔɔ bɩ m deem nɩ y, Zɩ ɩ kan mɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Naa hɩ mɔɔ ʊ awɔɔ m k'a laafɩɩ yɩ mɔɔ zi. Awɔɔ ɩ fɩryɩrɛ nɔ ʊ durnya naa do nɔ ʊ. Bɩ k'a heer ba kookoo, mɔɔ bʊr durnya ra.» ");
INSERT INTO bib_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kʊ Yeezuu meer ba ncɩnaaʊ bɩ, a a bɔɔta an dɩga brama, an a hɩ, a ʊ: «M Zɩ, wakatɩ a ku, ɩ Nyɩ bɩ tɔ busu, k'ɩ Nyɩ bɩ n a da ma, an ɩ tɔ busu sɔ. ");
INSERT INTO bib_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Paŋŋa k'ɩbɩɩ ka ʊ gʊaa haay burə ʊ bɩ, a *mɩsɩrbaa k'a nyarɛ ba ʊ bɩ kam gʊɔɔ haay k'ɩbɩɩ ŋ ka ʊ rɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Bala, mɩsɩrbaa k'a nyarɛ ba ʊ bɩ, kʊ ŋ y'ɩbɩɩ dɔ bɩ m, ɩbɩɩ k'ɩ m Woso a deem paan… kan gʊaa k'ɩbɩɩ nyɔɔ Yeezuu *Krista bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mɔɔ m lɛ bɔ ɩbɩɩ ʊ tara burə ʊ. Zibəə k'ɩbɩɩ ka mɔɔ ʊ kʊ ma ba bɩ, mɔɔ ba, m a nya. ");
INSERT INTO bib_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kɛɛrɛ bɩ, Zɩ, mɔɔ da ʊ ɩ zi, cirbəə niŋŋə kʊ mɔɔ n ta m ɩ zi, bɩ ma bɩ, durnya n nyɩnta ʊ bɩ m.» ");
INSERT INTO bib_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Gʊɔɔ niŋŋoo k'ɩbɩɩ ŋ bɔ ʊ durnya nɔ ʊ, ɩ ŋ ka mɔɔ ʊ rɔ wɔɔ, mɔɔ ɩbɩɩ tɔ hɩnka ŋ nɩ. Nyɩnta ŋ y'a ʊ ɩbɩɩ gʊɔɔ, ɩ ŋ ka mɔɔ ʊ, bɩ ŋ zu ɩbɩɩ lemim b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ŋ y'a dɔ kɛɛrɛ, ŋ ʊ, hɔ haay k'ɩbɩɩ ka mɔɔ ʊ bɩ, a to a ʊ ɩbɩɩ zi. ");
INSERT INTO bib_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Lemim kʊ mɔɔ hɩ ŋ nɩ bɩ, ɩbɩɩ n a ka mɔɔ ʊ bɩ m. Ŋ y'a si, ŋn'a dɔ sɩra paan… ŋ ʊ, bɔ mɔɔ ʊ ɩbɩɩ zi, ŋn'a si, ŋ ʊ, ɩbɩɩ ɩ mɔɔ nyɔɔ. ");
INSERT INTO bib_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mɔɔ ɩ yaa darɛ ŋ minto. Mɔɔ bɩr yaa dam durnya minto y, yaa mɔɔ n'a dam gʊɔɔ k'ɩbɩɩ ŋ ka mɔɔ ʊ rɔ wɔɔ minto. Ɩbɩɩ gʊɔɔ m. ");
INSERT INTO bib_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bɩ, hɔ haay k'an mɔɔ hɔ bɩ, ɩbɩɩ hɔ m sɔ, amba hɔ haay k'a n'ɩbɩɩ hɔ bɩ, mɔɔ hɔ m. Mɔɔ lɛbɔʊrɛ yɩ ŋ gʊr zi. ");
INSERT INTO bib_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Bɩ, mɔɔ bɩ maasɩrɛ bam durnya nɔ ʊ dɔ y, ŋ mɩŋŋɔɔ gɔɔtarɛ ŋ n bɩr durnya nɔ ʊ. Zɛ mɔɔ nawʊrɛ ɩbɩɩ zi. M Zɩ mɩŋŋa, dɔ ŋ ma ɩ tɔ k'ɩbɩɩ ka mɔɔ ʊ bɩ minto, kʊ ŋ nɩ bɩr deem, amba wɔɔ n deem bɩ m. ");
INSERT INTO bib_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kʊ mɔɔ nyɩnta kan ŋ kɩ bɩ, dɔ mɔɔ nawʊrɛ ŋ ma ɩbɩɩ tɔ k'ɩbɩɩ ka mɔɔ ʊ bɩ minto. Mɔɔ ku ŋ la, bɩ ŋ gʊaa deem n nyaam nɩ y, kʊ n bɩ m, nyaanlɛzaa bɩ m, kʊ *Wosoci meerbaarɔ wɔɔ n kʊ yɩ.» ");
INSERT INTO bib_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Zɛ mɔɔ nawʊrɛ ɩbɩɩ zi kɛɛrɛ, bɩ meerbaarɔ nɔɔn duro ba mɔɔ nawʊm durnya nɔ ʊ kʊ ŋ nɩ mɔɔ heernyɔɔ yɩ haay. ");
INSERT INTO bib_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mɔɔ ɩbɩɩ lemim bɩ ka ŋ ʊ, durnya n sɔ ŋ nɩ, kʊ durnya hɔɔ bɛɛ nɩ ŋ mɩ, amba durnya hɔ bɛɛ m mɔɔ m bɩ minto. ");
INSERT INTO bib_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mɔɔ n a yɛ k'ɩbɩɩ nɩ ŋ bɔ durnya ʊ y, bɩ, k'ɩ dɔ ŋ ma Sʊtaana minto. ");
INSERT INTO bib_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Durnya hɔɔ bɛɛ y, amba durnya hɔ bɛɛ m mɔɔ m bɩ m. ");
INSERT INTO bib_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","A ka k'ɩ sɩra bɩ n ŋ ba a hɔ. Ɩbɩɩ lemim bɩ sɩra m. ");
INSERT INTO bib_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Amba ɩbɩɩ mɔɔ nyɔɔ durnya nɔ ʊ bɩ, ŋ nyɔɔ mɔɔ nawʊm durnya nɔ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ŋ minto, mɔɔ yɩ m mɩŋŋa kam, kʊ ŋ mɩŋŋɔɔ n a mɩŋŋɔɔ ka sɩra minto.» ");
INSERT INTO bib_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Yaa bɛɛ mɔɔ n'a darɛ ŋ minto bala y. Yaa mɔɔ n'a dam gʊɔɔ kʊ ŋ nɩ zɛm bɩ sɩra ka mɔɔ ʊ, ŋ meerbaarɔ wɔɔ tɔ ma rɔ wɔɔ minto sɔ. ");
INSERT INTO bib_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Zɩ, kʊ ŋ haay n bɩr deem amba ɩbɩɩ n nɩ kan mɔɔ kɩ, mɔɔ nɩ kan ɩbɩɩ kɩ bɩ m. Kʊ ŋ n nyɩnta kan wɔɔ kɩ sɔ, kʊ durnya n a si, a ʊ, ɩbɩɩ ɩ mɔɔ nyɔɔ. ");
INSERT INTO bib_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Bɩ mɔɔ, mɔɔ lɛbɔʊrɛ k'ɩbɩɩ ka mɔɔ ʊ bɩ ka ŋ ʊ, kʊ ŋ nɩ bɩr deem amba wɔɔ n deem bɩ m. ");
INSERT INTO bib_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kʊ mɔɔ n bɩr kan ŋ kɩ amba ɩbɩɩ nɩ kan mɔɔ kɩ bɩ m. Kʊ ŋn'a zɛ kʊ ra deem kʊ durnya n a dɔ a ʊ, ɩbɩɩ mɔɔ nyɔɔ, ɩ ŋ ŋʊa amba ɩbɩɩ ɩ mɔɔ ŋʊa bɩ m.» ");
INSERT INTO bib_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Zɩ, mɔɔ lɛ taa bɩncɛ kʊ mɔɔ n ta ʊ bɩ, kʊ gʊɔɔ k'ɩbɩɩ ŋ ka mɔɔ ʊ rɔ wɔɔ n bɩ nyɩnta kan mɔɔ kɩ b'ʊ sɔ, kʊ ŋ nɩ lɛbɔʊrɛ k'ɩbɩɩ ka mɔɔ bɩ yɩ, bala, ɩbɩɩ lɛɛ ka ɩ mɔɔ ŋʊa bɩ ma bɩ, durnya n nyɩnta ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","M Zɩ k'an tɩrga, durnya k'a n ɩbɩɩ dɔ bɩ, mɔɔ ɩbɩɩ dɔ. Bɩ, nawɔnnɔ a dɔ, ŋ ʊ, ɩbɩɩ ɩ mɔɔ nyɔɔ. ");
INSERT INTO bib_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mɔɔ ka ŋn'ɩbɩɩ dɔ, bɩ mɔɔ yɩ m yarɛ m a ka ŋn'ɩ dɔ, kʊ ŋʊarɛ k'ɩbɩɩ mɔɔ ŋʊam bɩ m nyɩnta ŋ ʊ, kʊ mɔɔ n bɩr kan ŋ kɩ.» ");
INSERT INTO bib_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kʊ Yeezuu meer bɩ ba ncɩnaaʊ bɩ, a a hʊr kan a *karɩndanyɩnɔ wɔɔ kɩ, an bra Sedrɔn bɔrkɔ bɩ ma. Gɔsɩra nɩ b'ʊ, an gasʊ ʊ kan a karɩndanyɩnɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zidas k'a n'a nyasʊm k'a ka bɩ bɩncɛ bɩ dɔ, bala, Yeezuu tɩr ta b'ʊ kan a karɩndanyɩnɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Zidas ka *Rɔm sʊrdaarɔ wɔɔ lɛɛ kan Wosocɛ dɔmazannɔ kʊ *wosocɛmannɩbənno jɩtannɔ wɔɔ ŋ ka rɔ wɔɔ kɩ, kan *farizɛɛnrɔ kɩ, ŋnɩ bʊr gɔsɩra ʊ b'ʊ kan yar mɔr kɩ, fɩtɩrɛrɔ kɩ, ŋnɩ sɛ gungu. ");
INSERT INTO bib_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yeezuu k'a hɔ k'a nɩ zɛm b'a yɩ bɩ dɔ bɩ, a a zɔ, an a hɩ ŋ nɩ, a ʊ: «Nka awɔɔ n'a kam ma?» ");
INSERT INTO bib_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ŋ n a nyɩ bɔ nʊ, ŋ ʊ: «Nazarɛtɩ Yeezuu.» A n a hɩ ŋ nɩ, a ʊ: «A m mɔɔ m.» Bɩ, Zidas k'a n'a nyasʊm k'a ka bɩ yɩ ŋ barla. ");
INSERT INTO bib_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yeezuu k'a naa hɩ ŋ nɩ bɩ, ŋ y'a bɔ a kur m, ŋn'a dundo. ");
INSERT INTO bib_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yeezuu n a ya, an ŋ lar, a ʊ: «Nka awɔɔ n'a kam ma?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Nazarɛtɩ Yeezuu.» ");
INSERT INTO bib_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yeezuu n a nyɩ bɔ ŋ nʊ, a ʊ: «Mɔɔ hɩ awɔɔ m, mɔɔ ʊ, a m mɔɔ m. K'a ka awɔɔ nawʊm mɔɔ ma, k'a nawɔnnɔ to, ŋnɩ cem.» ");
INSERT INTO bib_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Meerbaa kʊ Yeezuu a hɩ bɩ, kʊ an n'a yɩrɛ ncɩnaaʊ: «Gʊɔɔ k'ɩbɩɩ ŋ ka mɔɔ ʊ rɔ wɔɔ, mɔɔ n deem to, an nyaam y.» ");
INSERT INTO bib_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sɩmɔɔn Pɩyɛɛr nyɩnta kargʊ m, an a gaa ʊ, an wosocɛmannɩbər jɩtaarɛ bɩ zibəənyɩ zɛ an a bɩsɩ tʊr gʊ ma. Zibəənyɩ bɩ do tɔ m Malkus. ");
INSERT INTO bib_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yeezuu n a hɩ Pɩyɛɛr m, a ʊ: «Ɩ bɔ, ɩ ɩ kargʊ bɩ du a caan ʊ. Mɔɔ bɩ fɩryɩrɛ niŋŋə kʊ mɔɔ Zɩ a ka mɔɔ ʊ bɩ yɩm na?» ");
INSERT INTO bib_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sʊrdaarɔ wɔɔ kan a cir bɩ kɩ kan zɩɩfʊrɔ Wosocɛ dɔmazannɔ wɔɔ kɩ Yeezuu nyasʊ, ŋn'a wɔrɔ sur. ");
INSERT INTO bib_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Lɛɛ ŋ y'a ka, ŋnɩ ta m Hannɩ zi. Bɩ, Hannɩ nyɩmbʊɛɛrɛ zim m *Kayiifʊ m. Kayiifʊ bɩ, wosocɛmannɩbər jɩtaarɛ m dɔɔraa bɩ do ʊ. ");
INSERT INTO bib_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayiifʊ deem-deem bɩ do ɩ zɩɩfʊrɔ wɔɔ dʊndɔ, a ʊ: kʊ gʊaa deem ga gʊaa haay minto, a jɩra bɩ. ");
INSERT INTO bib_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sɩmɔɔn Pɩyɛɛr kan karɩndanyɩ vanta kɩ zu Yeezuu jɛ ʊ. Bɩ, kʊ wosocɛmannɩbər bɩ karɩndanyɩ deem bɩ dɔ bɩ, a gasʊ kan Yeezuu kɩ wosocɛmannɩbər jɩtaarɛ bɩ har ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pɩyɛɛr n jɩm garga ra, hallɛ ma, karɩndanyɩ deem kʊ wosocɛmannɩbər jɩtaarɛ b'a dɔ bɩ bɔ, an meer ba kan lʊ k'a nɩ dɔm har bɩ lɛ ma bɩ kɩ, an Pɩyɛɛr gaa, an gasʊ m. ");
INSERT INTO bib_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Zibəənyɩlʊ k'a nɩ dɔm hallɛ ma bɩ n a hɩ m, a ʊ: «Gʊaa naa do, a karɩndanyɩnɔ wɔɔ gʊaa deem bɛɛ n'ɩbɩɩ m sɔ ra?» Pɩyɛɛr n a nyɩ bɔ ʊ, a ʊ: «Ayy…, a bɛɛ m mɔɔ nɩ y.» ");
INSERT INTO bib_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Zibəənyɩnɔ wɔɔ kan Wosocɛ dɔmazannɔ wɔɔ kɩ sɛ hɛ, ŋn'ɩ nyɩ kam ma, bala, nyɛɛm ɩ barɛ. Pɩyɛɛr nyɩnta kan ŋ kɩ, an nɩ nyɩ kam ma sɔ. ");
INSERT INTO bib_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Wosocɛmannɩbər jɩtaarɛ bɩ nɩ Yeezuu larm a karɩndanyɩnɔ wɔɔ ma kan a hɔdɩndarɛ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Mɔɔ pa da gʊaa haay m, mɔɔ hɔ dɩnda gʊɔɔ m dɔmɩm haay *sokʊmacɛrɔ ʊ kan *Wosocɛ ʊ kɩ, bɩncɛ kʊ zɩɩfʊrɔ haay n'a som kʊ ma ʊ, bɩ mɔɔ n hɔsɩ nyaakʊm da, m a hɩ y. ");
INSERT INTO bib_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bɔ minto m, ɩbɩɩ nɩ mɔɔ larlɛ? Hɔ kʊ mɔɔ hɩ bɩ, gʊɔɔ kʊ ŋ y'a tʊr ka mɔɔ ma rɔ wɔɔ lar. Ŋ hɔ kʊ mɔɔ hɩ bɩ dɔ mɩŋŋa.» ");
INSERT INTO bib_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yeezuu k'a naa hɩ bɩ, Wosocɛ dɔmazaa deem k'a nyɩnta b'ʊ b'a wɔ ta rɛ, an n'a hɩrɛ, a ʊ: «Bɔ minto m, ɩbɩɩ n'a nyɩ bɔm wosocɛmannɩbər jɩtaarɛ m ncɩnaaʊ?» ");
INSERT INTO bib_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Kʊ ŋʊaar mɔɔ ba, k'ɩ hɩ m m. Bɩ kʊ sɩra mɔɔ hɩ, bɔ minto, ɩ nɩ mɔɔ zɛrɛ?» ");
INSERT INTO bib_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Bɩ jɛ ʊ bɩ, Hannɩ a ka, ŋnɩ Yeezuu sur, ŋnɩ ta m wosocɛmannɩbər jɩtaarɛ *Kayiifʊ zi. ");
INSERT INTO bib_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Bɩ ma bɩ, Sɩmɔɔn Pɩyɛɛr ɩ nyɩ kam sɛ ma. N n a hɩ m, n ʊ: «A karɩndanyɩnɔ wɔɔ gʊaa deem bɛɛ n'ɩbɩɩ m na?» Pɩyɛɛr n bɩsɩ ka, a ʊ: «Mɔɔ bɛɛ y!» ");
INSERT INTO bib_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wosocɛmannɩbər jɩtaarɛ bɩ zibəənyɩ kʊ Pɩyɛɛr a tʊr gʊ ma bɩ danyɩ n a hɩ m, a ʊ: «Mɔɔ n ɩbɩɩ yɩ gɔsɩra ʊ b'ʊ kan kɩ ra?» ");
INSERT INTO bib_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pɩyɛɛr n a ya, an bɩsɩ ka. Lɛɛm bɩ, koo n baa da. ");
INSERT INTO bib_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ŋ bɔ Yeezuu m Kayiifʊ har ʊ, ŋnɩ ta m dʊdɔkarɛ bɩncɛ ʊ. Bɩ ma bɩ, wutigʊta m. Gʊɔɔ kʊ ŋ ta m nɔ wɔɔ n gasʊ dʊdɔkarɛ bɩncɛ ʊ b'ʊ y, a y'a *dintim ka a ma, a n a da ma a *pakkɩ cibsa bɩ bɩ y. ");
INSERT INTO bib_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bɩ minto bɩ, *Pɩlatɩ n bɔ an ta ŋ zi garga ra b'ʊ, an a hɩ ŋ nɩ, a ʊ: «Bɔ mim awɔɔ n'a kam gʊaa naa do ra?» ");
INSERT INTO bib_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Kʊ gʊaa naa do, kʊ zibʊnyaa bɛɛ a a ba, wɔɔ y'a nyasʊrɛ ʊ a ka ɩbɩɩ ʊ ra?» ");
INSERT INTO bib_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pɩlatɩ n a hɩ ŋ nɩ, a ʊ: «K'a gaa a dʊdɔ ka a zim amba awɔɔ *lɛrɔ wɔɔ n'a hɩm bɩ m.» Zɩɩfʊrɔ jɩtannɔ wɔɔ n a hɩ m, ŋ ʊ: «N n lɛ ka wɔɔ ʊ k'ʊ gər zɛ y!» ");
INSERT INTO bib_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Meerbaa kʊ Yeezuu a ba, a zɛ zaa minto bɩ, yɩ an nawʊrɛ ncɩnaaʊ, an kʊ yɩ. ");
INSERT INTO bib_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pɩlatɩ n gasʊ dʊdɔkarɛ bɩncɛ ʊ b'ʊ, an Yeezuu bir an a lar, a ʊ: «Zɩɩfʊrɔ cir n'ɩbɩɩ m nɩ?» ");
INSERT INTO bib_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Ɩbɩɩ nɩ naa hɩrɛ ɩ zim gɛ? Gɛɛ, gʊɔɔ gɔsɩnnɔ ɩ mɔɔ mim hɩ ɩbɩɩ nɩ?» ");
INSERT INTO bib_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pɩlatɩ n a nyɩ bɔ nʊ, a ʊ: «Zɩɩfʊ bɛɛ m mɔɔ nɩ y. Ɩbɩɩ dogʊɔɔ, wosocɛmannɩbənno jɩtannɔ y'ɩbɩɩ nyasʊ, ŋn'ɩbɩɩ ka mɔɔ ʊ! Bɔ ɩbɩɩ ba?» ");
INSERT INTO bib_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Mɔɔ cirbəə bɩ, durnya naa do hɔ bɛɛ y. Kʊ mɔɔ cirbəə bɩ durnya naa do hɔ nɩ, mɔɔ dɔmazannɔ yar bam kʊ ŋ bɩ mɔɔ nyasʊ, ŋnɩ mɔɔ ka zɩɩfʊrɔ jɩtannɔ wɔɔ ʊ y. Bɩ mɔɔ cirbəə bɩ, durnya naa do hɔ bɛɛ y.» ");
INSERT INTO bib_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pɩlatɩ n a hɩ m, a ʊ: «K'a maam cir n'ɩbɩɩ m wa?» Yeezuu n a nyɩ bɔ ʊ, a ʊ: «Ɩbɩɩ y'a hɩ, ɩ zim, cir m mɔɔ m. Yɩ mɔɔ ʊ m bʊr durnya ʊ, kʊ m bɩ sɩra kasɛtɩ ka. Gʊaa k'a sɩra ŋʊa bɩ, a y'a tʊr kam mɔɔ leer ma.» ");
INSERT INTO bib_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pɩlatɩ n a hɩ m, a ʊ: «Bɔ m sɩra?» K'a naa hɩ bɩ, a a ya, an ta garga ra b'ʊ, an aa zɩɩfʊrɔ wɔɔ yɩ, an a hɩ ŋ nɩ, a ʊ: «Kʊ mɔɔ nɩ, mɔɔ n mim kʊ gʊaa naa do a zar bɩ yɩ y. ");
INSERT INTO bib_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","K'a mim ka awɔɔ m, kʊ pakkɩ cibsa a zɔ, kʊ m gʊaa bɔ, m wɔ saa bɩ, awɔɔ lɛ taa kʊ m zɩɩfʊrɔ cir bɩ bɔ, m wɔ saa gɛ?» ");
INSERT INTO bib_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ŋ n'ɩ zee darɛ, ŋ ʊ: «Naa do bɛɛ y, k'a Barabas bɔ!» A n bɔkarɛ, Barabas bɩ do, gərzer m. ");
INSERT INTO bib_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","*Pɩlatɩ n a ka, ŋnɩ Yeezuu zɛ madɩɩrɔ m. ");
INSERT INTO bib_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Rɔm sʊrdaarɔ n laa waa, ŋn'a ku a mim ma, ŋnɩ cinno huu kʊ n y'a ba pɛɛra piinə m sa, ŋn'a da ra, ");
INSERT INTO bib_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ŋn'a zɔ ma, ŋn'a hɩrɛ, ŋ ʊ: «Wɔɔ ɩ yaa darɛ ɩbɩɩ m, zɩɩfʊrɔ cir!» Ŋ n'a wɔ tɩntam lɛ. ");
INSERT INTO bib_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pɩlatɩ n a bɔ, an bɔ garga ra, an a hɩ zɩɩfʊrɔ wɔɔ m, a ʊ: «Awɔɔ yɩ ra, mɔɔ y'a gaarɛ, m bɔ m garga ra naa ʊ. Awɔɔ y'a dɔrɛ a ʊ, mɔɔ n mim k'a a zar bɩ yɩ y.» ");
INSERT INTO bib_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yeezuu n bɔ garga ra b'ʊ, kan laa bɩ kɩ, cinno huu bɩ kɩ a ra. Pɩlatɩ n a hɩ ŋ nɩ, a ʊ: «Ba gʊaa bɩ n na.» ");
INSERT INTO bib_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kʊ wosocɛmannɩbənno jɩtannɔ kan a gʊɔɔ wɔɔ kɩ a yɩ bɩ, ŋ y'a sɩŋŋɩda ba, ŋn'ɩ zee darɛ, ŋ ʊ: «K'a wɔ gɔdarkʊra ma, k'a wɔ gɔdarkʊra ma!» Pɩlatɩ n a hɩ ŋ nɩ, a ʊ: «K'a gaa a wɔ gɔdarkʊra ma a zim. Bala, mɔɔ n hɔsɩ yɩ, an a ba, an bʊnyaa y.» ");
INSERT INTO bib_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Zɩɩfʊrɔ jɩtannɔ wɔɔ n a nyɩ bɔ nʊ, ŋ ʊ: «Wɔɔ ɩ lɛ m, bɩ kan wɔɔ lɛ bɩ kɩ, a a ga zɛ m, bala, a a mɩŋŋa sa, an a ba Woso Nyɩ!» ");
INSERT INTO bib_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kʊ Pɩlatɩ mim naa do ma bɩ, dabɔʊ a nyasʊ an lɛ da biisi m. ");
INSERT INTO bib_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","A n a bɔ, an ta dʊdɔkarɛ bɩncɛ ʊ b'ʊ, an a hɩ Yeezuu m, a ʊ: «Ɩ to ɩbɩɩ ʊ ka?» Yeezuu n hɔsɩ nyɩ bɔ nʊ y. ");
INSERT INTO bib_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pɩlatɩ n a hɩ m, a ʊ: «Ɩbɩɩ bɩr a nyɩ bɔm mɔɔ nʊ ra? Ɩbɩɩ n a dɔ, ɩ ʊ, mɔɔ m da ma, m wɔ saa ɩbɩɩ ma ra, gɛɛ, mɔɔ m da ma, m a ka, ŋn'ɩbɩɩ wɔ gɔdarkʊra ma ra?» ");
INSERT INTO bib_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Ɩbɩɩ b'ɩ dam ma ɩ hɔsɩ ba mɔɔ m k'a a to bɛɛ n y'a ʊ brama, n n lɛ ka ɩbɩɩ ʊ y. Bɩ minto y'a ka sɔ, gʊaa k'a mɔɔ nyasʊ an mɔɔ ka ɩbɩɩ ʊ bɩ, mimbʊnyaa gandaara a a ba!» ");
INSERT INTO bib_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Bɩ tɛkka ma, Pɩlatɩ y'a kam ma k'a wɔ saa ma, zɩɩfʊrɔ wɔɔ nɩ zee darɛ ŋ ʊ: «K'ɩbɩɩ wɔ saa ma, *Rɔm cir gʊaasɩba bɛɛ n'ɩbɩɩ m dɔ y! Bala, gʊaa k'a mɩŋŋa ba cir bɩ, cir bɩ jɩm m.» ");
INSERT INTO bib_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pɩlatɩ k'a naa ma bɩ, a a ka, ŋnɩ bɔ Yeezuu m. Pɩlatɩ n nyɩnta dʊdɔkarɛ gɔ bɩ ra, bɩncɛ kʊ n'a birm *ebree lemim m Gabata b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pakkɩ cibsa *bankarɛ hinni m, sinuu ʊ. Pɩlatɩ n a hɩ zɩɩfʊrɔ wɔɔ m, a ʊ: «Awɔɔ cir bɩ ba n nɩ!» ");
INSERT INTO bib_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ŋ n'ɩ zee darɛ, ŋ ʊ: «K'a zɛ gər! K'a zɛ gər! K'a wɔ gɔdarkʊra ma!» Pɩlatɩ n a hɩ, a ʊ: «M awɔɔ cir bɩ wɔ gɔdarkʊra ma ra?» Wosocɛmannɩbənno jɩtannɔ wɔɔ n a nyɩ bɔ ʊ, ŋ ʊ: «Wɔɔ ba cir vanta m kʊ Rɔm cir bɛɛ y.» ");
INSERT INTO bib_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pɩlatɩ n Yeezuu ka ŋ ʊ, kʊ ŋ n'a wɔ gɔdarkʊra ma. Ŋ n Yeezuu nyasʊ. ");
INSERT INTO bib_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yeezuu n a gɔdarkʊra busu a zim, an bɔ, an ta bɩncɛ kʊ n n'a birm Minkorgo, n n'a hɩm ma ebree lemim m Golgotaa b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bɩncɛ bɩ do ʊ, ŋ y'a wɔ ʊ gɔdarkʊra ma kan gʊɔɔ hɩɩyɔɔ kɩ, deem jɩsa, deem bɩsɩ, Yeezuu nɩ ŋ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","*Pɩlatɩ n gʊrsɩra ba warga ma, an a wɔ gɔdarkʊra b'ʊ, an n'a hɩrɛ, a ʊ: Yeezuu Nazarɛtɩ gʊaa, zɩɩfʊrɔ cir. ");
INSERT INTO bib_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Zɩɩfʊrɔ gʊɔɔ gʊta warga bɩ karɩnda ba, bala, bɩncɛ kʊ ŋ Yeezuu wɔ gɔdarkʊra ma bɩ bɩ laatʊ tara nɔ bɩ ma y. B'a gʊrsɩra ba n y'a ʊ ebree lemim m, grɛkkɩ lemim m, kan latɛn lemim kɩ m. ");
INSERT INTO bib_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Zɩɩfʊrɔ *wosocɛmannɩbənno jɩtannɔ wɔɔ n a hɩ Pɩlatɩ m, ŋ ʊ: «Ɩ b'a gʊrsɩra ba zɩɩfʊrɔ cir y, a gʊrsɩra ba: A a hɩ, a ʊ, zɩɩfʊrɔ cir n a mɩ.» ");
INSERT INTO bib_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pɩlatɩ n a nyɩ bɔ ʊ, a ʊ: «Hɔ kʊ mɔɔ gʊrsɩra ba bɩ, a ba mɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kʊ Rɔm sʊrdaarɔ wɔɔ Yeezuu wɔ gɔdarkʊra ma, ŋn'a nya bɩ, ŋ y'a huuro gʊr, ŋn'a jir lɛ si. Gʊaa biyəə a yɩ deem. Zaba b'ɩ gɔɔta. A ba n y'a ʊ deem jilli. ");
INSERT INTO bib_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sʊrdaarɔ wɔɔ n'a hɩm kʊ m, ŋ ʊ: «Ʊ b'a kaansʊ y, ʊ pʊɛɛga da ma, ʊ dɩga a, kʊ nka n n'a yɩrɛ.» Kʊ *Wosoci bɩ meerbaa naa do n kʊ yɩ: ‹Ŋ mɔɔ huuro jinjir kan kʊ kɩ, ŋnɩ pʊɛɛga da mɔɔ zaba ma.› Hɔ kʊ sʊrdaarɔ wɔɔ a ba bɩ n naa. ");
INSERT INTO bib_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yeezuu gɔdarkʊra bɩ jɩr ʊ bɩ, a da ɩ jɩnɩm b'ʊ kan a da bɩ dam kɩ, Klopas lʊ Maarii kɩ, kan Magdalaa kʊ Maarii kɩ. ");
INSERT INTO bib_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","K'a a da bɩ yɩ kan a karɩndanyɩ k'a ŋʊa bɩ kɩ bɩ, a a hɩ a da bɩ m, a ʊ: «M naa, ba ɩ nyɩ n na!» ");
INSERT INTO bib_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Bɩ jɛ ʊ bɩ, an a hɩ a karɩndanyɩ bɩ m, a ʊ: «Ba ɩ da n na!» Wakatɩ bɩ do ma, karɩndanyɩ b'a da bɩ gaa, an doo m. ");
INSERT INTO bib_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yeezuu k'a a dɔ kɛɛrɛ a ʊ, hɔ haay ba an nya, kʊ *Wosoci meerbaarɔ wɔɔ n kʊ yɩ bɩ, a a hɩ, a ʊ: «Mɩsɩ nɩ mɔɔ zɛm.» ");
INSERT INTO bib_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Gər ɩ nyɩnta b'ʊ bɛɛ hɛɛnr n a han. Ŋ n *hizɔp gɔ sa ŋnɩ hɔ k'an mafʊ-mafʊ kʊsɩ ma, ŋn'a nyɔɔ bɛɛ hɛɛnr ma, ŋn'a ka Yeezuu ʊ. ");
INSERT INTO bib_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kʊ Yeezuu bɩ mi bɩ, a a hɩ, a ʊ: «Hɔ haay ba an nya.» A n a mim zuutə, an ga. ");
INSERT INTO bib_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kʊ pakkɩ cibsa *bankarɛ hinni m bɩ, nyibəə gasʊ zɩɩfʊrɔ wɔɔ ʊ, ŋ lɛ baa kʊ gəəno wɔɔ n gɔɔta gɔdarkʊrarɔ wɔɔ ma *sabaa hinni ʊ b'ʊ y. Sabaa bɩ do, cibsa gʊta m. Ŋ y'a yɛ *Pɩlatɩ han, k'a ŋ gannɔ yɩnyar, k'a ŋ zer gɔdarkʊrarɔ wɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Sʊrdaarɔ wɔɔ n bɩ gʊɔɔ kʊ ŋ yɩ ŋ wɔ gɔdarkʊra ma kan Yeezuu kɩ rɔ wɔɔ gannɔ yɩnyar: lɛɛkarɛzaa bɩ kan a nyaʊrɛzaa bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kʊ ŋ lee ku Yeezuu zi bɩ, ŋ yaa dɩga a, a ga kara, bɩ ŋ n a gannɔ yɩnyar y. ");
INSERT INTO bib_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bɩ sʊrdaarɔ wɔɔ gʊaa deem a hɔn sɔɔn m a boon ma, ma n bɔ kan hi kɩ. ");
INSERT INTO bib_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Gʊaa k'a yɩ b'a kasɛtɩ ka, b'a kasɛtɩ bɩ sɩra m. B'a dɔ, a ʊ, sɩra an n'a hɩm, k'awɔɔ n a si sɩra sɔ. ");
INSERT INTO bib_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sɩra m, ba naa haay ʊ, kʊ *Wosoci meerbaa naa do n kʊ yɩ: ‹A yaarɔ wɔɔ haay deem taan… bɩ yarlɛ y.› ");
INSERT INTO bib_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wosoci bɩ bɩncɛ niŋŋə ta ʊ, an n'a hɩrɛ, a ʊ: ‹Ŋ zɛm bɩ gʊaa kʊ ŋ y'a hɔn bɩ yɩ.› ");
INSERT INTO bib_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Minno nɔɔn duro kʊ ŋ cem bɩ, Arimatee kʊ gʊaa Zozɛf k'a nyɩnta Yeezuu karɩndanyɩ sɛɛrɛ, nyi k'a n'a bam zɩɩfʊrɔ jɩtannɔ wɔɔ m bɩ minto. A bɩ zaa yɛ *Pɩlatɩ han k'a Yeezuu gər bɩ sa. Pɩlatɩ n zaa ka, an bʊr an b'a gər bɩ sa. ");
INSERT INTO bib_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛm bʊr sɔ. A ɩ nyɩnta an ta Yeezuu zi gunuu ʊ bɩ. A *mɩɩr war kʊ ma kan tidəər kʊ n n'a birm alʊɛsɩ kɩ, n a a zɔ a cilo bukərku ma. ");
INSERT INTO bib_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ŋ n Yeezuu gər bɩ sa, ŋnɩ pɛɛrarɔ bumburgu ma kan tidəər kɩ amba zɩɩfʊrɔ gər birle m. ");
INSERT INTO bib_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Brikə nɩ bɩncɛ kʊ ŋ Yeezuu wɔ gɔdarkʊra ma ʊ b'ʊ, brikə bɩ do nɔ ʊ, yaa daa nɩ b'ʊ, n n gər bir ʊ cɩna y. ");
INSERT INTO bib_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bɩ kʊ zɩɩfʊrɔ wɔɔ n'a bankarɛ *sabaa k'a n'a bam k'a sɩŋŋɩda sa minto bɩ, bɩ yaa bɩ do k'an jɩnjɛɛm sɔ bɩ, ŋ Yeezuu bir ʊ. ");
INSERT INTO bib_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","*Hatʊ hinni b'ʊ wutigʊta m, bɩ ma bɩ dɔ n mɛ y, Magdalaa Maarii ta yaa ra b'ʊ, a yaa dɩga a, n jaa bɩ gʊ yaa bɩ lɛ rɛ. ");
INSERT INTO bib_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","A n bra si, an aa Sɩmɔɔn Pɩyɛɛr yɩ, kan karɩndanyɩ deem kʊ Yeezuu a ŋʊa bɩ kɩ, an a hɩ ŋ nɩ, a ʊ: «N Zuuba bɔ yaa b'ʊ, bɩ wɔɔ n a dɔ kʊ ta n y'a ʊ m ka y.» ");
INSERT INTO bib_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pɩyɛɛr n bɔ kan karɩndanyɩ deem bɩ kɩ, ŋnɩ ta yaa ra b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ŋ hɩɩya haay bra si, karɩndanyɩ deem bɩ bra si, an cem Pɩyɛɛr han, an lɛɛ ka yaa ra b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A n zerga an pɛɛrarɔ wɔɔ yɩ, ŋn'ɩ kuntəm b'ʊ. Bɩ, a n gasʊ y. ");
INSERT INTO bib_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sɩmɔɔn Pɩyɛɛr k'a zu a jɛ ʊ bɩ, a lee ku sɔ. A n gasʊ yaa bɩ nɔ ʊ, an pɛɛrarɔ wɔɔ yɩ, ŋn'ɩ kuntəm b'ʊ, ");
INSERT INTO bib_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","kan pɛɛra kʊ n y'a burgu a mim ma bɩ kɩ. Bɩ, bɩ n nyɩnta kan pɛɛrarɔ wɔɔ kɩ y. A huŋŋu n y'a ʊ, n n a cɩnta bɩncɛ vanta ʊ. ");
INSERT INTO bib_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Karɩndanyɩ k'a lɛɛ ka an lee ku bɩ gasʊ yaa ʊ b'ʊ kɛɛrɛ. A n a yɩ, an sɩra ka. ");
INSERT INTO bib_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bɩ ŋ gɔɔta, ŋ n *Wosoci bɩ jɩ ma y. Bala, a a hɩ, a ʊ, Yeezuu y'a mɩm bɔŋ ʊ gəəno bire ʊ. ");
INSERT INTO bib_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bɩ kur bɩ, karɩndanyɩnɔ wɔɔ a wusigə, ŋnɩ doo. ");
INSERT INTO bib_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maarii gɔɔta garga ra yaa bɩ jɩr ʊ, an nɩ nyi kam. K'a nɩ nyi bɩ kam bɩ, a zerga, an dɩga yaa b'ʊ, ");
INSERT INTO bib_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","an malɛɛkarɔ yɩ hɩɩya, ŋn'ɩ huu furo m a ma, ŋnɩ nyɩnta bɩncɛ kʊ ŋ Yeezuu gər bɩ wʊta ʊ b'ʊ. Deem n'a mim ma, deem n'a gannɔ ma. ");
INSERT INTO bib_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ŋ n a hɩ lʊ bɩ m, ŋ ʊ: «Bɔ nyi ɩbɩɩ n'a karɛ?» A n a nyɩ bɔ ŋ nʊ, a ʊ: «Mɔɔ Zuuba n y'a busu, bɩ kʊ ta n y'a ʊ m ka, mɔɔ n a dɔ y.» ");
INSERT INTO bib_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","K'a nɩ meer bɩ bam bɩ, a a bɔ an dɩga, an Yeezuu yɩ an nɩ jɩnɩm b'ʊ, b'a n a dɔ, a ʊ, Yeezuu nɩ y. ");
INSERT INTO bib_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeezuu n a hɩ m, a ʊ: «Lʊ, bɔ minto ɩ nɩ nyi karɛ? Nka ɩbɩɩ nɩ kam ma?» Lʊ bɩ hɔɔn ʊ bɩ, brikə bɩ dɔmazaa m, a ʊ: «Zuuba, k'ɩbɩɩ y'a busu, k'ɩ bɩncɛ hɩnka mɔɔ m, mɔɔ yaa busu.» ");
INSERT INTO bib_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeezuu n a hɩm, a ʊ: «Maarii». A n a wusigə, an a hɩ m *ebree lemim m, a ʊ: «Rabuni» bɩ lɛ taa k'a hɩ, a ʊ: «Karɩnsaamba.» ");
INSERT INTO bib_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeezuu n a hɩ m, a ʊ: «Ɩ bɩ mɔɔ da jɩm ʊ y, mɔɔ n ta m Zɩ zi cɩna y. Bɩ, ta ɩ yaa hɩ mɔɔ danyɩnɔ wɔɔ m, ɩ ʊ, mɔɔ ɩ tarɛ m Zɩ k'a n'awɔɔ Zɩ bɩ zi, mɔɔ Woso k'a n'awɔɔ Woso bɩ zi.» ");
INSERT INTO bib_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magdalaa kʊ Maarii bɩ n b'a hɩ karɩndanyɩnɔ wɔɔ m, a ʊ: «Mɔɔ Zuuba yɩ, hɔ k'a hɩ mɔɔ m bɩ ba n nɩ!» ");
INSERT INTO bib_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hinni bɩ do yirbəə m, k'a nyɩnta *hatʊ hinni bɩ, karɩndanyɩnɔ wɔɔ cɛlɛrɔ tɩnta a ma nyi kʊ ŋ n'a bam zɩɩfʊrɔ jɩtannɔ wɔɔ m bɩ minto. Yeezuu n bʊr, an bɩ jɩm ŋ bire ʊ, an a hɩ, a ʊ: «Laafɩɩ n bɩr kan awɔɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","K'a nɩ meer bɩ bam bɩ, a a wɔrɔ wɔɔ hɩnka ŋ nɩ kan a boon bɩ kɩ. Kʊ karɩndanyɩnɔ wɔɔ Zuuba yɩ bɩ, ŋ haay heer nyɔɔ. ");
INSERT INTO bib_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yeezuu n a ya, an a hɩ, a ʊ: «Laafɩɩ n bɩr kan awɔɔ kɩ. Kʊ mɔɔ Zɩ mɔɔ nyɔɔ bɩ, mɔɔ y'awɔɔ nyɔɔm sɔ.» ");
INSERT INTO bib_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","K'a meer ba ncɩnaaʊ bɩ, a hoon si ŋ ma, an a hɩ ŋ nɩ, a ʊ: «K'a *Sɛnt-Ɛspri si. ");
INSERT INTO bib_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Gʊɔɔ k'awɔɔ n nɩ ŋ mimbʊnyaarɔ sugur karɛ ŋ ʊ rɔ wɔɔ, ŋ sugur yɩrɛ. Gʊɔɔ k'awɔɔ bɩr ŋ mimbʊnyaarɔ sugur karɛ ŋ ʊ rɔ wɔɔ, ŋ bɩ sugur yɩrɛ y.» ");
INSERT INTO bib_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Bɩ ma bɩ, bueerehɩɩyɔɔ wɔɔ gʊaa deem Toma kʊ n n'a birm Didim bɩ n nyɩnta kan ŋ kɩ Yeezuu hɩnkarɛ dɔmɩm b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Karɩndanyɩnɔ gɔsɩnnɔ wɔɔ n a hɩ m, ŋ ʊ: «Wɔɔ Zuuba yɩ!» A n a nyɩ bɔ ŋ nʊ, a ʊ: «Kʊ mɔɔ n karɔ wɔɔ yaarɔ yɩ a wɔrɔ wɔɔ ʊ, kʊ mɔɔ n m nyʊkʊm nyɔɔ ka yaa deem ʊ, kʊ mɔɔ n m wɔ du a boon b'ʊ, mɔɔ b'a sire y.» ");
INSERT INTO bib_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Dɔmɩm sinnyə kur bɩ, karɩndanyɩnɔ wɔɔ a ya, ŋn'a zɛ kʊ ra har ʊ b'ʊ, Toma nɩ kan ŋ kɩ. Yeezuu n bʊr, bɩ ma bɩ, ŋ cɛlɛrɔ wɔɔ tɩnta, an bɩ jɩm ŋ bire ʊ, an a hɩ ŋ nɩ, a ʊ: «Laafɩɩ n bɩr kan awɔɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bɩ jɛ ʊ bɩ, an a hɩ Toma m, a ʊ: «Ɩ zɔ, ɩ ɩ nyʊkʊm nyɔɔ naa ʊ, k'ɩ dɩga mɔɔ wɔrɔ ma, ɩ wɔ bɩ da mɔɔ mɛ ma, k'ɩ nyɔɔ mɔɔ boon ʊ, k'ɩ sɩra ka kɛɛrɛ, k'ɩ ba sɩrakarɛzaa.» ");
INSERT INTO bib_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma n a nyɩ bɔ ʊ, a ʊ: «Mɔɔ Zuuba, mɔɔ Woso.» ");
INSERT INTO bib_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeezuu n a hɩ m, a ʊ: «K'ɩbɩɩ mɔɔ yɩ bɩ y'a ka, ɩbɩɩ n sɩra ka mɔɔ ʊ. Mimbirenyɩntazannɔ m gʊɔɔ kʊ ŋ n a yɩ, bɩ ŋ sɩra ka rɔ wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeezuu hoserlo ba gʊta karɩndanyɩnɔ wɔɔ mɩm ʊ bɩ n n a gʊrsɩra ba ci naa do nɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nawɔnnɔ gʊrsɩra ba n y'a ʊ, k'awɔɔ n sɩra ka, a ʊ, Yeezuu m *Krista, a m Woso Nyɩ. Bɩ, k'awɔɔ sɩra ka, k'a *mɩsɩrbaa yɩ a tɔ ma. ");
INSERT INTO bib_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bɩ jɛ ʊ bɩ, Yeezuu a ya, an a hɩnka a karɩndanyɩnɔ m Tiberiyaadɩ kɔ lɛ ra. A hɩnkarɛ bɩ ba n nɩ. ");
INSERT INTO bib_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sɩmɔɔn Pɩyɛɛr kan Toma kʊ n n'a birm Didim bɩ kɩ, Galilee kʊ Kanaa gʊaa Natanayɛl kɩ, Zebedee nyɩnɔ kɩ, kan karɩndanyɩnɔ gɔsɩnnɔ kɩ hɩɩya, ŋn'a zɛ kʊ ra. ");
INSERT INTO bib_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sɩmɔɔn Pɩyɛɛr n a hɩ ŋ nɩ, a ʊ: «Ta mɔɔ nawʊm kʊ m aa zɔnɔ ba.» Ŋ n a hɩ m, ŋ ʊ: «Wɔɔ tam kan ɩbɩɩ kɩ.» Ŋ n bɔ, ŋnɩ gasʊ kɔɔlʊʊ b'ʊ, bɩ gum bɩ do ʊ, ŋ n hɔsɩ nyasʊ y. ");
INSERT INTO bib_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bɩ ma bɩ, dɔ mɛ. Yeezuu n jɩm kɔ lɛ ra b'ʊ, bɩ karɩndanyɩnɔ wɔɔ n a dɔ ŋ ʊ, Yeezuu nɩ y. ");
INSERT INTO bib_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","A n a hɩ ŋ nɩ, a ʊ: «Hey! Nyɩnɔ, zɔnɔ b'awɔɔ ʊ ra?» Ŋ n a nyɩ bɔ nʊ, ŋ ʊ: «Ayy…» ");
INSERT INTO bib_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a zaŋŋa bɩ zo kɔɔlʊʊ bɩ bɩsɩ ra, awɔɔ y'a yɩrɛ.» Ŋ n zaŋŋa bɩ zo, an zɔ gʊr gʊta, bɩ ŋ b'a dam ma, ŋn'a gaa y. ");
INSERT INTO bib_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Karɩndanyɩ kʊ Yeezuu a ŋʊa bɩ n a hɩ Pɩyɛɛr m, a ʊ: «Zuuba m!» Sɩmɔɔn Pɩyɛɛr k'a a ma, n ʊ, Zuuba m bɩ, a huu sa, an a du a ma, nyɩnta a ʊ dɩgɩ, an a da hi b'ʊ. ");
INSERT INTO bib_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Karɩndanyɩnɔ gɔsɩnnɔ wɔɔ a bɔ, ŋnɩ bʊr kɔɔlʊʊ bɩ m, ŋn'ɩ zaŋŋa bɩ gaam, zɔnɔ n a han, ŋ bɩ laatʊ kɔ bɩ lezi ma y. A gakʊ ʊ a ba kan mɛtɩr zɔrɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kʊ ŋ zer tara ʊ bɩ, ŋ sɛcɩna yɩ zɔ n ta ra kan bur kɩ. ");
INSERT INTO bib_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a bʊr zɔnɔ k'awɔɔ ŋ gʊr dɩɩtaa rɔ wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sɩmɔɔn Pɩyɛɛr n a bɔ, an gasʊ kɔɔlʊʊ b'ʊ, an zaŋŋa bɩ gaa tara ʊ, zɔ gʊta-gʊta n a han zɔrɔ busoor yaa kaakʊ, bɩ kan bɩ kɩ haay zaŋŋa bɩ n kaansʊ y. ");
INSERT INTO bib_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeezuu n a hɩ ŋ nɩ, a ʊ: «K'a bʊr a hɔ bɩ.» Bɩ karɩndanyɩ deem taan… n laaka da han, a ʊ: «Nka n'ɩbɩɩ m gɛ y?» Ŋ y'a dɔ mɩŋŋa, ŋ ʊ, Zuuba m. ");
INSERT INTO bib_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yeezuu n a zɔ kɛɛrɛ, an bur bɩ sa, an a ka ŋ ʊ. A n a ba zɔ bɩ m maam sɔ. ");
INSERT INTO bib_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yeezuu k'a mɩm bɔ ʊ gəəno bire ʊ bɩ, a gallɛm kaakʊ hɔ a hɩnka a karɩndanyɩnɔ wɔɔ m naa. ");
INSERT INTO bib_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hɔbɩrɛ bɩ kur bɩ, Yeezuu a hɩ Sɩmɔɔn Pɩyɛɛr m, a ʊ: «Sɩmɔɔn, Zaan nyɩnnɩ, ɩbɩɩ mɔɔ ŋʊa an lɛ da nawɔnnɔ ra ra?» A n a nyɩ bɔ ʊ, a ʊ: «Ɩɩn… Zuuba, ɩbɩɩ dɔ, ɩ ʊ, mɔɔ y'ɩbɩɩ ŋʊarɛ.» Yeezuu n a hɩ m, a ʊ: «Dɔ mɔɔ sinnyɛɛnnyɩnɔ ma.» ");
INSERT INTO bib_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yeezuu n a hɩ m a hɩɩya hɔ ma, a ʊ: «Zaan nyɩnnɩ, ɩbɩɩ ɩ mɔɔ ŋʊam na?» A n a nyɩ bɔ ʊ, a ʊ: «Ɩɩn… Zuuba, ɩbɩɩ dɔ, ɩ ʊ, mɔɔ y'ɩbɩɩ ŋʊarɛ.» Yeezuu n a hɩ m, a ʊ: «Dɔ mɔɔ seero ma.» ");
INSERT INTO bib_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","A kaakʊ hɔ ma bɩ, a ʊ: «Sɩmɔɔn, Zaan nyɩnnɩ, ɩbɩɩ ɩ mɔɔ ŋʊam na?» Pɩyɛɛr heer a zar kan hɔ kʊ Yeezuu a hɩ m a kaakʊ hɔ ma bɩ kɩ. «Ɩ ɩ mɔɔ ŋʊam na?» A n a nyɩ bɔ ʊ, a ʊ: «Zuuba, ɩbɩɩ k'ɩ hɔ haay dɔ bɩ, ɩbɩɩ dɔ, ɩ ʊ, mɔɔ y'ɩbɩɩ ŋʊarɛ.» Yeezuu n a hɩ m, a ʊ: «Dɔ mɔɔ seero ma. ");
INSERT INTO bib_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sɩra paan… mɔɔ n'a hɩrɛ ɩbɩɩ m, k'ɩbɩɩ nyɩnta nyukumbueere bɩ, ɩbɩɩ y'ɩ bankam, ɩ nɩ tarɛ ɩ hɔɔnhɔ bɩncɛ ʊ. K'ɩbɩɩ bɩ gusi, ɩbɩɩ y'ɩ zarɔ hʊrm, gʊaa vanta n n'ɩbɩɩ banka, an ɩbɩɩ gaa, an ta ɩbɩɩ m bɩncɛ k'ɩbɩɩ lɛ baa ʊ b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yeezuu bɩ meer naa do ba a ʊ k'a zɛ niŋŋə k'a nɩ Pɩyɛɛr zɛm, an a lɛ bɔ Woso ʊ bɩ hɩnka. K'a meer naa do ba bɩ, a a hɩ m, a ʊ: «Zu mɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pɩyɛɛr k'a a bɔ, an dɩga bɩ, a karɩndanyɩ kʊ Yeezuu a ŋʊa bɩ yɩ a jɛ ʊ. A ɩ nyɩnta hɔbɩrɛ bɩrɛ dɔmɩm ʊ, an zerga Yeezuu cɩ ra, an a hɩ, a ʊ: «Zuuba, nka n n'ɩbɩɩ nyasʊm, k'a ɩbɩɩ ka bɩ?» ");
INSERT INTO bib_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pɩyɛɛr k'a yɩ bɩ, a a hɩ Yeezuu m, a ʊ: «Bɩ naa, Zuuba, bɔ n nɩ zɛm bɩ naa yɩ?» ");
INSERT INTO bib_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeezuu n a nyɩ bɔ nʊ, a ʊ: «Kʊ mɔɔ ʊ k'an gɔɔta an ta an mɔɔ wusigəre ku, kara y'ɩbɩɩ ku? Ɩbɩɩ, zu mɔɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Meerbaa naa do minto y'a ka, n n so ra danyɩnɔ wɔɔ barla, ŋ ʊ, karɩndanyɩ naa do bɩ garɛ y. Kʊ sɩra nɩ, Yeezuu n a hɩ, a ʊ, a bɩ garɛ y. A a hɩ, a ʊ: «Kʊ mɔɔ lɛ taa k'an gɔɔta, an ta an mɔɔ wusigəre ku, kara y'ɩbɩɩ ku?» ");
INSERT INTO bib_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Karɩndanyɩ bɩ do nɩ minno nɔɔn duro kasɛtɩ kam, an nɩ ŋ gʊrsɩra barɛ, bɩ wɔɔ dɔ, wɔɔ ʊ, a kasɛtɩ bɩ sɩra m. ");
INSERT INTO bib_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yeezuu a ya, an hɔɔ gʊtɔɔ ba. K'a gʊrsɩra n n'a bam deem-deem, mɔɔ hɔɔndarɛ nɔ ʊ, durnya haay b'a dam ma, an ciro kʊ ŋ nɩ ŋ gʊrsɩra bam nɔ wɔɔ si y.");
INSERT INTO bib_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofil, m lɛɛkarɛ ci bɩ nɔ ʊ, mɔɔ Yeezuu zibəə haay k'a ba kan hɔ haay k'a dɩnda bɩ da ʊ, an a sa a sɩŋŋɩda ʊ, ");
INSERT INTO bib_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","an ta, an hinni k'a zibəəzannɔ bɔ ʊ, an a lɛrɔ ka ŋ ʊ, kan *Sɛnt-Ɛspri paŋŋa kɩ, an ta an a dɔmɩm k'a der ʊ arzana ʊ bɩ ku. ");
INSERT INTO bib_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Brɔɔ a a hɩnka ŋ nɩ mɩsɩr a zɛ bɩ kur, kan makrarɔ gʊtɔɔ kʊ ŋ bɩsɩkarɛ ba ʊ kɩ, a ʊ: a a mɩm bɔ ʊ, a m mɩsɩr. A kasɛtɩ nyɩnta ʊ gʊta. Dɔmɩm busi nɔ ʊ, a a hɩnka ŋ nɩ, an nɩ Woso cirbəə bɩ mim dɩndarɛ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","A nyɩnta an nɩ hɔbɩrɛ bɩm kan ŋ kɩ hindeem ʊ, an lɛ ka ŋ ʊ, a ʊ: ŋ bɩ bɔ Zerizalɛm nɔ ʊ y, bɩ kʊ ŋ nɩ gɔɔta ŋnɩ dɔ Zɩ Woso lerbɔrɛ bɩ ma. «Hɔ niŋŋə k'awɔɔ ma, mɔɔ n a hɩ m lɛ m bɩ. ");
INSERT INTO bib_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Zaan hi batɛm ka denter, b'awɔɔ, naa kan dɔmɩm poore kɩ, awɔɔ batɛm sim Sɛnt-Ɛspri nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ŋ nyɩnta, ŋn'a zɛ kʊ ra, ŋnɩ laaka naa do da han, ŋ ʊ: «Zuuba, naa ma ɩbɩɩ n nɩ Israyɛl cirbəə bɩ bankaŋ ʊ gɛ?» ");
INSERT INTO bib_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A n a hɩ ŋ nɩ, a ʊ: «Awɔɔ n a ga m k'a dɔmɩnnɔ kan wakatɩrɔ kɩ kʊ Zɩ Woso a cɩnta a mɩŋŋa paŋŋa m bɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bɩ, awɔɔ paŋŋa yɩrɛ, Sɛnt-Ɛspri hɔ m, an nɩ zɛm bɩ zer awɔɔ mim ʊ, a paŋŋa karɛ awɔɔ ʊ. Awɔɔ nyɩntam mɔɔ kasɛtɩzannɔ Zerizalɛm ʊ, Zidee haay kan Samarii kɩ haay, kan tara lɛ cɩnta jɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kʊ Yeezuu minno nɔɔn duro hɩ ŋ nɩ bɩ, a der ŋ mɩnyaa m, warkʊ bʊr an b'a nyaam ŋ lɛɛ. ");
INSERT INTO bib_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kʊ ŋ gɔɔta ŋn'ɩ dɩgam brama ma bɩ, gʊɔɔ hɩɩyɔɔ bʊr ŋnɩ huu fu du a ma, ŋnɩ bɩ jɩm ŋ jɩr ʊ. ");
INSERT INTO bib_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ŋ n a hɩ ŋ nɩ, ŋ ʊ: «Galilee gʊɔɔ ra, bɔ minto m, awɔɔ n gɔɔta an nɩ dɩgam brama ncɩnaaʊ? Yeezuu naa do kʊ n y'a bɔ awɔɔ bire ʊ an der brama bɩ y'a bɔrɛ an bʊr maam, amba awɔɔ yɩ an der brama bɩ m.» ");
INSERT INTO bib_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kʊ ŋ zer ci kʊ n n'a birm Oliviyee ci bɩ ra bɩ, ŋ y'a wusigə, ŋnɩ ta Zerizalɛm ʊ. Bɩ ci bɩ do, a ga a ʊ *sabaa dɔmɩm tarɛ m, amba n lɛ ka bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kʊ ŋ yaa lee ku bɩ, ŋ der cɛ k'a nɩ mim ʊ b'ʊ, amba ŋ tɩr a ba biisi bɩ m. Bɩncɛ bɩ do, Pɩyɛɛr kan Zaan kɩ, Zakkɩ kɩ, Andɩr kɩ, Filipi kan Toma kɩ, Bartelemii kan Matiyee kɩ, Alfee nyɩ Zakkɩ kan Sɩmɔɔn kʊ n n'a birm *Zelɔtɩ bɩ kɩ, kan Zakkɩ nyɩ Ziidi kɩ tɩr kʊ zɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ŋ haay a zɛ kʊ ra lɛ deem ŋn'a tɔŋ ʊ kan yaadarɛ kɩ, kan lannɔ gɔsɩnnɔ kɩ Yeezuu da Maarii kɩ, kan Yeezuu danyɩnɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dɔmɩm bɩ do ʊ, gʊɔɔ a so kʊ ma b'ʊ, ŋ lɛ n a zɔ zɔrɔ buhɩra ma. Pɩyɛɛr n wuti a danyɩnɔ wɔɔ bire ʊ, an a hɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«M danyɩnɔ, a ga a wʊm kʊ Sɛnt-Ɛspri mim k'a hɩ Davɩd lɛ m Wosoci nɔ ʊ Zidas k'a ka lɛɛ, ŋnɩ Yeezuu nyasʊ bɩ minto bɩ n kʊ yɩ. ");
INSERT INTO bib_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","A nyɩnta wɔɔ bire ʊ, an a hɔ jirle hɔ yɩ, wɔɔ zibəə bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Bɩ, gʊaa bɩ do, zibəə bʊnyaa k'a a ba bɩ, a bɩ busoo bɩ sa, an tara si m. A do a ʊ a nɔ ra, a nɔ bɩ n haan, a nɔbaarɔ haay n bɔ, ŋnɩ sur tara ʊ. ");
INSERT INTO bib_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Zerizalɛm gʊɔɔ haay a dɔ. Bɩ y'a ka ŋn'ɩ tara bɩ birm a lemim m Hakɛldamaa, a lɛ taa k'a hɩ, a ʊ: Ma tara. ");
INSERT INTO bib_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sɩra m, n y'a gʊrsɩra ba ncɩnaaʊ laarɔ ci nɔ ʊ: K'a har n gɔɔta zer, kʊ gɔsɩ bɩ nyɩnta ʊ y. Bɩ, a a ya an a hɩ, a ʊ: Kʊ gʊaa vanta n a zibəə bɩ sa. ");
INSERT INTO bib_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Gʊɔɔ kʊ ŋ wɔɔ da zaa ʊ lɛɛ haay ʊ dɔmɩm kʊ Zuuba Yeezuu mɩsɩrbaa ba ʊ wɔɔ bire ʊ bɩ, ");
INSERT INTO bib_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","an a sa Yeezuu batɛm k'a a si Zaan zi bɩ ma, an ta an dɔmɩm k'a der ʊ arzana ʊ bɩ ku bɩ, a a ga m, kʊ ŋ gʊaa deem n a ba kan wɔɔ kɩ a mɩmbɔʊrɛ kasɛtɩzaa.» ");
INSERT INTO bib_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","N ŋ hɩnka hɩɩya, Zozɛf kʊ n n'a birm Barsabas, n nɩ so ra, n n'a tɔ ka Zistus bɩ m kan Matɩyas kɩ. ");
INSERT INTO bib_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ŋ n yaa da ncɩnaaʊ: «Zuuba, ɩbɩɩ k'ɩ gʊaa haay heer dɔ, dɩga gʊaa hɩɩya naa bire ʊ ɩ gʊaa k'ɩbɩɩ bɔ ʊ bɩ hɩnka wɔɔ m, ");
INSERT INTO bib_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","k'an nyɩnta lemim nyɩnta zibəəzaa, bɩncɛ kʊ Zidas a to an ta a bɩncɛ ʊ bɩ.» ");
INSERT INTO bib_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ŋ n pʊɛɛga da, an jɩm Matɩyas mim ʊ. Bɩ y'a da kristazibəəzannɔ bueeredeenno wɔɔ barla. ");
INSERT INTO bib_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pantɩkɔtɩ dɔmɩm k'a ku bɩ, ŋ nyɩnta ŋn'a so kʊ ma haay bɩncɛ deem ʊ. ");
INSERT INTO bib_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Lɛɛm bɩ, ŋ bʊgʊr ma am hɩnhɛr gʊta hɔ bɩ m, an a to brama, an bɩ har kʊ ŋ nɩ ta ʊ bɩ han haay. ");
INSERT INTO bib_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ŋ n hɔ yɩ an bɔ kʊ ʊ kan sɛ nɛɛm kɩ, an a jinjir, an a cɩnta gʊaa biyəə mim ʊ. ");
INSERT INTO bib_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","*Sɛnt-Ɛspri nɩ ŋ haay han, ŋn'a sɩŋŋɩda sa, ŋn'ɩ lemim vantɔɔ hɩm amba Sɛnt-Ɛspri a ka ŋ ʊ kʊ ŋ n'a hɩ bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Bala, zɩɩfʊrɔ wosohɔɔnhɔbarɛzannɔ y'a to durnya kʊrɔ haay ʊ, ŋnɩ bʊr, ŋn'ɩ Zerizalɛm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bʊgʊr bɩ k'a ba bɩ, zamaa b'a so kʊ ma, bɩ, ŋ zɛ kədə, bala, gʊaa biyəə nyɩnta an nɩ ŋ mam, ŋn'ɩ meer barɛ a do lemim m. ");
INSERT INTO bib_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hɔ k'a nɩ bam b'a ka ŋnɩ zɛ kədə, gʊaa biyəə n a lɛ gu, ŋn'a hɩrɛ, ŋ ʊ: «Gʊɔɔ nɔɔn duro haay kʊ ŋ nɩ meer bam naa, Galilee gʊɔɔ bɛɛ ra? ");
INSERT INTO bib_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Bɩ, a ba a ʊ lɔ, wɔɔ gʊaa biyəə nɩ ŋ marɛ a do lemim nɩ? ");
INSERT INTO bib_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Partɩ zannɔ kan Mɛɛdɩ zannɔ kɩ, Elamitɩ kan Mezopotamii zannɔ kɩ, Zidee zannɔ kan Kapadɔs zannɔ kɩ, Pɔn zannɔ kan Azii zannɔ kɩ, ");
INSERT INTO bib_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frizii zannɔ kan Panfilii zannɔ kɩ, Eziptɩ zannɔ kan Libii Sirɛnnɩ zannɔ kɩ, kan Rɔm zannɔ kʊ ŋ nɩ naa ʊ rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Wɔɔ kʊ wɔɔ m Zɩɩfʊrɔ, kan do vantɔɔ gʊɔɔ kʊ ŋ nɩ zum zɩɩfʊrɔ wɔɔ lɛrɔ wɔɔ rɔ wɔɔ kɩ, Krɛtɩ zannɔ kan Araabɩrɔ kɩ, wɔɔ y'a mam, ŋn'a lɛ bɔm Woso zibəə mɩŋŋa b'ʊ, wɔɔ do lemim m.» ");
INSERT INTO bib_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mim naa do k'a ba bɩ cem ŋ han haay, ŋn'ɩ bɩsɩ kam kʊ ma, ŋn'a hɩm kʊ m, ŋ ʊ: «Naa lɛ taa k'a hɩ a ʊ lɔ?» ");
INSERT INTO bib_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Gɔsɩnnɔ nyɩnta ŋn'ɩ yaa wʊrɛ ŋ ma, ŋ ʊ: «Bɛɛ yɩ ŋ ka.» ");
INSERT INTO bib_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pɩyɛɛr n wuti meerbaa m bueeredeenno kʊ ŋ nyɩnta b'ʊ rɔ wɔɔ bire ʊ, an n'a hɩrɛ ncɩnaaʊ: «Zidee zannɔ, kan awɔɔ haay k'a nɩ Zerizalɛm nɔ ʊ naa ʊ rɔ wɔɔ kɩ, k'a hɔ k'a nɩ bam bɩ jɩ ma mɩŋŋa, k'a tʊr gʊ mɔɔ meerbaa bɩ ma. ");
INSERT INTO bib_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ayy…, gʊɔɔ nɔɔn duro n bɛɛ mi amba awɔɔ n'a hɔɔn dam ma bɩ nɩ y. Dɔ k'a mɛ naa, wakatɩ kaakʊ wɔɔ n ta ma cɩna. ");
INSERT INTO bib_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bɩ naa do naa, hɔ kʊ wosolɛsinnɩsorazaa Zowɛl a hɩ bɩ n naa: ");
INSERT INTO bib_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ba hɔ kʊ Woso a hɩ bɩ n na: Dɔmɩnnɔ jɛzannɔ nɔ ʊ, mɔɔ yɩ m Sɛnt-Ɛspri zerm gʊaa haay mim ʊ, awɔɔ gʊɔɔ yaarɔ kan lannɔ kɩ Woso lɛ sire ŋnɩ so ra, awɔɔ gʊɔɔ pooro hɔhɩnkarɛrɔ yɩm, awɔɔ gʊɔɔ gusinno hɔɔ yɩrɛ nɩnnarɛrɔ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sɩra m, dɔmɩnnɔ wɔɔ duro nɔ ʊ, yaarɔ kan lannɔ kʊ ŋ nɩ mɔɔ zi bam nɔ wɔɔ, mɔɔ yɩ m Sɛnt-Ɛspri bɩ zerle ŋ la, ŋn'ɩ Woso lɛ si ŋnɩ so ra. ");
INSERT INTO bib_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mɔɔ hɔɔ gʊtɔɔ bam brama, m makrarɔ ba tara burə ʊ naa ʊ, ma kan sɛ kɩ, siŋŋə kɩ nyɩntaŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Woso gure y'a lʊrm an a ba am monsigə hɔ bɩ m, mom n a lʊr am ma hɔ bɩ m, kʊ Zuuba dɔmɩm gʊta kan a cirbəə kɩ bɩ n bɔkarɛ, an lee ku. ");
INSERT INTO bib_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Bɩ, gʊaa k'a nɩ Zuuba birm yaadarɛ nɔ ʊ bɩ n nɩ bʊmbɔrɛ yɩm.» ");
INSERT INTO bib_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Israyɛl zannɔ, k'a tʊr ka mɔɔ meerbaarɔ nɔɔn duro ma: Amba awɔɔ dɔ bɩ nɩ, Nazarɛtɩ Yeezuu bɩ, gʊaa bɩ do Woso a kasɛtɩ ka ʊ awɔɔ zi, an nɩ hoserlo bam, kan hɔ k'awɔɔ n a yɩ cɩna bɩ kɩ, kan makrarɔ kɩ awɔɔ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Gʊaa bɩ do, awɔɔ nyasʊ a da gʊɔɔ bʊnyaarɔ wɔ ʊ, ŋn'a wɔ gɔdarkʊra ma, amba Woso lɛɛ ka an a cɩnta a zim a hɔdɔrɛ nɔ ʊ k'an ba bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bɩ, Woso a mɩm bɔ ʊ, an a bʊmbɔ zɛ kaʊdabaa ma, bala, zɛ b'a dam ma an gɔɔta m a cirbəə nɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Sɩra m, Davɩd a hɩ a minto, a ʊ: Mɔɔ ɩ Zuuba yɩrɛ m lɛɛ dɔmɩm haay, bala, a ɩ mɔɔ bɩsɩ ra, kʊ mɔɔ bɩ m da ma, m m do y. ");
INSERT INTO bib_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mɔɔ heer nyɔɔ sɔ, mɔɔ nɛɛm nɩ heernyɩnta laa lɔm, mɔɔ mɛ nɩ mɛnyɔɔ dam taaheerlɛ nɔ ʊ an lɛ da. ");
INSERT INTO bib_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bala, mɔɔ dɔ ɩbɩɩ bɩ mɔɔ nyi to m *gəəno bɩncɛ ʊ y. Ɩbɩɩ gʊaa paan… m mɔɔ m, ɩ bɩ mɔɔ tore m vɔn y. ");
INSERT INTO bib_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ɩbɩɩ mɩsɩrbaa zaa hɩnka mɔɔ m, ɩbɩɩ y'a kam mɔɔ m heernyɔɔ yɩ ɩ zi.» ");
INSERT INTO bib_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«M danyɩnɔ, zaa ta ʊ kʊ m a hɩ kan heerkoodəbaa kɩ, m a bɔ kʊ zi: Wɔɔ yaaba Davɩd ga, n n a bir, a yaa gɔɔta an nɩ wɔɔ zi naa ʊ her. ");
INSERT INTO bib_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","B'a nyɩnta wosolɛsinnɩsorazaa, an a dɔ, a ʊ: Woso a wer si m, a do gʊaa bɔrɛ, an nyɩnta a cirbəəduu ra. ");
INSERT INTO bib_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A lɛɛ ka an Krista mɩmbɔʊrɛ bɩ yɩ, bɩ, a minto y'a ka an a hɩ, a ʊ: N n a to gəəno bɩncɛ ʊ y, b'a mɛsim n vɔnrɛ dɔ y. ");
INSERT INTO bib_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Woso Yeezuu bɩ do mɩm bɔ ʊ, wɔɔ haay, a kasɛtɩzannɔ m wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Woso a busu a bɩsɩ ʊ a lɛbɔʊrɛ nɔ ʊ. Sɛnt-Ɛspri k'a Zɩ a ler bɔm bɩ, a a yɩ, an a jir, amba awɔɔ n'a yɩm, an n'a mam sɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Bala, Davɩd k'an der paan… arzana ʊ bɩ, a a hɩ mɩŋŋa, a ʊ: Zuuba Woso a hɩ mɔɔ Zuuba m: nyɩnta mɔɔ bɩsɩ ʊ ");
INSERT INTO bib_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","an ta an dɔmɩm kʊ mɔɔ n n'ɩbɩɩ jɩnnɔ wɔɔ bam ɩ gankarahɔ bɩ ku.» ");
INSERT INTO bib_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Kʊ Israyɛl do haay n a dɔ mɩŋŋa: Yeezuu niŋŋə k'awɔɔ wɔ gɔ ma bɩ, bɩ Woso a ba Zuuba kan Krista kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kʊ ŋ heer a zɛ kʊ ma kan minno nɔɔn duro marɛ kɩ bɩ, ŋ Pɩyɛɛr lar kan kristazibəəzannɔ gɔsɩnnɔ wɔɔ kɩ, ŋ ʊ: «Kʊ a ba lɔ, ʊ danyɩnɔ?» ");
INSERT INTO bib_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pɩyɛɛr n a nyɩ bɔ ʊ, a ʊ: «K'a a bɔ a mimbʊnyaarɔ ʊ, kʊ gʊaa biyəə m batɛm si Yeezuu tɔ ma a mimbʊnyaarɔ sugur yɩrɛ minto. B'awɔɔ Sɛnt-Ɛspri yɩm ganwʊrɛ. ");
INSERT INTO bib_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Lerbɔrɛ naa do, awɔɔ hɔ m kan a nyɩnɔ kɩ, kan gʊɔɔ haay kʊ ŋ nɩ laatʊ rɔ wɔɔ kɩ, gʊɔɔ haay kʊ Zuuba wɔɔ Woso n nɩ zɛm bɩ ŋ bir lɔ wɔɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pɩyɛɛr meer ba gʊta, an n'a kasɛtɩ kam, an nɩ ŋ heer bam kookoo, an n'a hɩrɛ, a ʊ: «K'a a gʊ her gʊɔɔ bʊnyaarɔ nɔɔn ma.» ");
INSERT INTO bib_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Gʊɔɔ kʊ ŋ y'a meerbaarɔ wɔɔ si rɔ wɔɔ ŋ batɛm si. Hinni bɩ do ʊ bɩ, gʊɔɔ kʊ ŋ y'a zɛ kʊ ra kan ŋ kɩ rɔ wɔɔ, ŋ lɛ a zɔ tisi kaakʊ ma. ");
INSERT INTO bib_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ŋ yɛ kristazibəəzannɔ wɔɔ karɩnda bɩ ma, ŋn'ɩ tam lɛɛ dɔmɩm haay, ŋn'a zɛm kʊ ra, ŋn'ɩ Zuuba zɛkʊra hɔbɩrɛ bɩm, ŋn'ɩ yaa darɛ. ");
INSERT INTO bib_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kristazibəəzannɔ wɔɔ kʊ ŋ nɩ hoserlo bam gʊta kan makrarɔ kɩ bɩ, ŋ haay zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Gʊɔɔ haay kʊ ŋ y'a ba sɩrakarɛzannɔ wɔɔ haay a zɛ kʊ ra, ŋn'a hɔ haay zɛm kʊ ra. ");
INSERT INTO bib_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ŋ y'a wɔhɔɔ hɛɛrɛ kan a arzakarɔ kɩ, k'a bɩ ŋ jir kan kʊ kɩ amba gʊaa biyəə lɛ n taa bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Dɔmɩm haay, ŋ y'a zɛm kʊ ra Wosocɛ ʊ b'ʊ, ŋn'a zɛm kʊ ra a harlɔ ʊ, ŋn'ɩ Yeezuu zɛkʊra hɔ bɩrɛ kan heernyɔɔ kɩ, noonhubaa kɩ. ");
INSERT INTO bib_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ŋ n'ɩ Woso daŋ ʊ, do bɩ haay n a lɛ bɔrɛ ŋ ʊ. Dɔmɩm biyəə, Zuuba a ka gʊɔɔ nɩ bʊmbɔrɛ yɩrɛ, sokʊmagʊɔɔ wɔɔ lɛ n'a dam la. ");
INSERT INTO bib_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yirbəə deem m wakatɩ kaakʊ hɔ ma bɩ, yaadarɛ wakatɩ m bɩ, Pɩyɛɛr kan Zaan kɩ ta Wosocɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Gʊaa n nɩ b'ʊ, an yɩ lʊgɔ, n n tɩr a busu dɔmɩm haay, n n aa nyɩnta Wosocɛ lɛ kʊ n n'a birm «cɛlɛ gʊɛrɛ-gʊɛrɛ» bɩ ma, k'an hɔ yɩnyɛ gʊɔɔ kʊ ŋ nɩ gasʊm Wosocɛ ʊ b'ʊ rɔ wɔɔ han. ");
INSERT INTO bib_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","K'a Pɩyɛɛr yɩ kan Zaan kɩ, ŋn'ɩ tam k'a gasʊ Wosocɛ ʊ b'ʊ bɩ, a hɔ yɛ ŋ han. ");
INSERT INTO bib_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pɩyɛɛr kan Zaan kɩ n dɩga a sɩɩ… ŋn'a hɩ m, ŋ ʊ: «Dɩga wɔɔ ma!» ");
INSERT INTO bib_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Gʊaa bɩ nɩ dɩgarɛ ŋ ma, bala, dɔ an nawʊrɛ ŋ ma kʊ ŋ nɩ hɔ ka a ʊ. ");
INSERT INTO bib_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pɩyɛɛr n a hɩ m, a ʊ: «Mɔɔ ba sarma m gɛɛ wanzur nɩ y. Bɩ, hɔ k'a nɩ mɔɔ ʊ bɩ, mɔɔ y'a karɛ ɩbɩɩ ʊ: Yeezuu Krista, Nazarɛtɩ gʊaa bɩ tɔ ma, wuti ɩ ta!» ");
INSERT INTO bib_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","A n a sa a bɩsɩ wɔ ma, an a ka an wuti. Lɛɛm bɩ, gʊaa bɩ gannɔ kan a gankʊyɛrɔ wɔɔ kɩ a bɔ kʊ zi. ");
INSERT INTO bib_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A n wuti brama vugur, an nɩ tam. A n gasʊ kan ŋ kɩ Wosocɛ ʊ b'ʊ, an nɩ tam, an nɩ hinherm, an n'a lɛ bɔm Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Zamaa bɩ haay n a yɩ an nɩ tam, an n'a lɛ bɔm Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","N y'a dɔ: A mɩŋŋa ɩ nyɩnta Wosocɛ lɛ gʊɛrɛ-gʊɛrɛ bɩ lɛ ma an nɩ hɔ yɩnyɛm bɩ. Gʊɔɔ wɔɔ zɛ kədə, ŋ da n bɔ ʊ, hɔ k'a ba gʊaa bɩ m bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Gʊaa bɩ n a ya, an n'a gʊm Pɩyɛɛr ma kan Zaan kɩ y. Zamaa bɩ haay n a si ŋnɩ ta ŋ zi laŋŋa kʊ n n'a birm «Salomɔɔn laŋŋa» bɩ taa. Hɔ k'a ba b'a ka ŋnɩ zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pɩyɛɛr k'a naa yɩ bɩ, a a hɩ zamaa bɩ m, a ʊ: «Israyɛl zannɔ, bɔ m, awɔɔ nɩ zɛm kədə hɔ k'a ba naa ma? Gɛɛ bɔ minto m, awɔɔ nɩ dɩgam wɔɔ ma, ɩ ʊ, gʊaa naa k'a nɩ tam bɩ, wɔɔ paŋŋa gɛɛ wɔɔ mɩŋŋabaa y'a ka, an nɩ tarɛ? ");
INSERT INTO bib_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Izakkɩ, kan Zakɔɔb kɩ Woso k'a m wɔɔ zɩrɔ Woso bɩ y'a lɛ bɔ a Zibəənyɩ Yeezuu b'ʊ. Bɩ, awɔɔ nyɩnta a nyasʊ a ka Pɩlatɩ ʊ, an a ŋʊa k'a wɔ saa, awɔɔ n a gu bɩ. ");
INSERT INTO bib_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Awɔɔ, Gʊaa mɩŋŋa k'an tɩrga bɩ, awɔɔ kaanm bɩ m, a yɛ kʊ n nɩ wɔ saa gərzer bɩ ma. ");
INSERT INTO bib_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mɩsɩrbaa cir b'awɔɔ zɛ, Woso a mɩm bɔ ʊ gəəno bire ʊ, a kasɛtɩzannɔ m wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sɩrakarɛ minto y'a ka Yeezuu tɔ ma, wɔɔ n tɔ naa do hɩ, ʊ yaabazaa k'awɔɔ n nɩ dɩgam ma a dɔ sɔ naa waa. Bɩ, sɩrakarɛ k'a a to Yeezuu zi bɩ y'a ka gʊaa naa n a waa awɔɔ haay bire ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Sɩra m, m danyɩnɔ, mɔɔ dɔ mɔɔ ʊ badɔ y'a ka awɔɔ n a ba ncɩnaaʊ haay, awɔɔ kan a cinno wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Woso mɩŋŋa lɛɛ ka an a hɩ a lɛsinnɩsorazannɔ lɛ m, a ʊ: A Krista bɩ fɩr yɩrɛ, b'a kʊ yɩ maam sɔ. ");
INSERT INTO bib_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","K'a a bɔ a mimbʊnyaarɔ ʊ, k'a a bɔ a bʊr Woso zi, k'a a mimbʊnyaarɔ sugur yɩ. ");
INSERT INTO bib_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Zuuba Woso mɛnyɔɔ dɔmɩnnɔ kam, an Yeezuu bʊmbɔrɛzaa niŋŋə k'a banka wɔɔ minto bɩ nyɔɔ. ");
INSERT INTO bib_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","K'a nɩ arzana ʊ bɩ, nyɩnta an nawʊm b'ʊ, an dɔ hɔ haay bankarɛ dɔmɩm ma, dɔmɩm niŋŋə kʊ Woso a hɩ a lɛsinnɩsorazannɔ mɩŋŋɔɔ lɛ m biisi bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moyiisi lɛɛ ka an a hɩ, a ʊ: ‹Zuuba Woso y'a lɛsinnɩsorazaa bɔŋ ʊ awɔɔ danyɩnɔ bire ʊ awɔɔ minto, amba mɔɔ m. K'a tʊr ka hɔ haay k'a n'a hɩm bɩ ma. ");
INSERT INTO bib_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Gʊaa k'a n a tʊr ka wosolɛsinnɩsorazaa bɩ do lemim ma, kʊ n n a bɔ do barla, n n'a zɛ gər.› ");
INSERT INTO bib_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wosolɛsinnɩsorazannɔ wɔɔ haay, an a sa Sanwɛl ma kan a jɛzannɔ kɩ dɔmɩnnɔ kʊ wɔɔ n ta ʊ rɔ wɔɔ nɔɔn mim hɩ. ");
INSERT INTO bib_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Awɔɔ m wosolɛsinnɩsorazannɔ wɔɔ kan gʊaasɩbabaa kʊ Woso a cɩnta kan awɔɔ zɩrɔ kɩ bɩ hɔyɩrɛzannɔ, dɔmɩm k'a hɩ ʊ Abraham m, a ʊ: ‹Ɩbɩɩ yaŋŋɔɔ minto, do haay k'a nɩ tara burə ʊ barka yɩm.› ");
INSERT INTO bib_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Woso k'a Zibəənyɩ bɩ bɔ ʊ bɩ lɛɛ ka an a nyɔɔ awɔɔ zi an a barka zer awɔɔ mim ʊ, an n'a kam awɔɔ gʊaa haay n'a mimbʊnyaarɔ tore.» ");
INSERT INTO bib_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pɩyɛɛr kan Zaan kɩ kʊ ŋ gɔɔta ŋn'ɩ meer bam kan zamaa bɩ kɩ bɩ, wosocɛmannɩbənno kan Wosocɛ dɔmazannɔ cir bɩ kɩ, kan Sadisɛɛnrɔ kɩ bʊr ŋ zi. ");
INSERT INTO bib_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ŋ heer busu kan ŋ kɩ, kʊ ŋ nɩ karɩnda dɩndam gʊɔɔ wɔɔ m, ŋn'ɩ Yeezuu mim hɩm gʊɔɔ m kan gəəno mɩmbɔʊrɛ kɩ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ŋ nɩ ŋ gʊr, ŋnɩ ŋ du lɔnnɔcɛ ʊ, bala, gum da, ŋn'a to dɔ n mɛ. ");
INSERT INTO bib_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Gʊɔɔ kʊ ŋ n'a tʊr karɛ ŋ ma rɔ wɔɔ, gʊta a ba sɩrakarɛzannɔ. Ŋ lɛ wuti an a zɔ tisi soor ma. ");
INSERT INTO bib_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Dɔ k'a mɛ bɩ, cinno kʊ ŋ nɩ Zerizalɛm ʊ kan tara bɩ gʊɔɔgusinno kɩ wosocikarɩnsaambɔɔ wɔɔ kɩ a zɛ kʊ ra. ");
INSERT INTO bib_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Wosocɛmannɩbər jɩtaarɛ Hannɩ nyɩnta ʊ kan *Kayiifʊ kɩ, Zaan kan Alɛsandɩr kɩ, kan wosocɛmannɩbənno jɩtannɔ dogʊɔɔ wɔɔ kɩ haay. ");
INSERT INTO bib_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ŋ n a ka, ŋnɩ Pɩyɛɛr gaa kan Zaan kɩ, ŋnɩ bʊr ŋ nɩ a taa, ŋn'ɩ ŋ larlɛ, ŋ ʊ: «Bɔ paŋŋa m, gɛɛ nka tɔ awɔɔ yu ma an nɩ naa barɛ?» ");
INSERT INTO bib_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","*Sɛnt-Ɛspri k'a Pɩyɛɛr han bɩ, a a hɩ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","«Kʊ lɛɛzannɔ kan gʊɔɔgusinno kɩ, her naa ʊ bɩ, wɔɔ lar awɔɔ nawʊm hɔ mɩŋŋa kʊ wɔɔ ba lʊgɔ naa do m bɩ minto. Kʊ a hɩ, k'a ba wɔɔ ʊ lɔ gʊaa naa do n a waa gɛ? ");
INSERT INTO bib_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","K'a dɔ mɩŋŋa a ʊ, awɔɔ haay kan Israyɛl do haay kɩ, Nazarɛtɩ Yeezuu Krista tɔ minto m. Awɔɔ y'a wɔ gɔdarkʊra ma, Woso n a mɩm bɔ ʊ gəəno bire ʊ, a minto y'a ka gʊaa naa do n a waa, an n'awɔɔ lɛɛ naa ʊ. ");
INSERT INTO bib_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Amba Wosoci a hɩ bɩ m, ‹jaa k'awɔɔ cɛdonno, wɔɔ a bɔ ʊ a zo bɩ, a y'a ba cɛjɩr jaa.› ");
INSERT INTO bib_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Bʊmbɔrɛzaa vanta ba ʊ bɩncɛ vanta ʊ k'a bɛɛ y. Tɔ vanta ba ʊ durnya nɔ ʊ n n a ka gʊɔɔ ʊ k'ʊ ʊ da ma ʊ bʊmbɔrɛ yɩ k'a bɛɛ y.» ");
INSERT INTO bib_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kʊ ŋ Pɩyɛɛr kan Zaan kɩ heerkoodəbaa bɩ yɩ bɩ, ŋn'a dɔ ŋ ʊ, ŋ n karɩnda ba y, targarɔ m bɩ, ŋ zɛ kədə. Ŋ y'a dɔ kɛɛrɛ, ŋ ʊ Yeezuu zukuuzannɔ m, ");
INSERT INTO bib_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ŋn'ɩ dɩgam gʊaa k'a waa bɩ ma a jɩr ʊ, ŋ n hɔ k'a n'a hɩm bɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ŋ n lɛ ka, kʊ ŋ nɩ bɔ ŋ nɩ dʊdɔkarɛ bɩncɛ ʊ b'ʊ, ŋnɩ gɔɔta k'a dɩga ŋ mim ma. ");
INSERT INTO bib_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ŋ n'a hɩm kʊ m, ŋ ʊ: «K'ʊ a ba gʊɔɔ nɔɔn duro n lɔ? Kʊ sɩra nɩ, gʊɔɔ haay kʊ ŋ nɩ Zerizalɛm nɔ ʊ rɔ wɔɔ a dɔ, ŋ ʊ, ŋ hoser ba, bɩ wɔɔ b'ʊ dam ma, ʊ bɩsɩ ka ma y. ");
INSERT INTO bib_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ʊ ŋ meerbaarɔ wɔɔ da jɩm ʊ, k'a bɩ lee ku lɛɛ haay ʊ y. Ʊ bɔ ŋ lɛɛ, kʊ ŋ b'a ya, ŋnɩ meer ba kan gʊɔɔ wɔɔ kɩ tɔ naa do minto y.» ");
INSERT INTO bib_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ŋ n a ka, ŋnɩ ŋ bir, ŋnɩ lɛ ka ŋ ʊ, kʊ ŋ b'a ya, ŋnɩ Yeezuu tɔ hɩ, gɛɛ, ŋn'a mim dɩnda y. ");
INSERT INTO bib_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pɩyɛɛr kan Zaan kɩ n a nyɩ bɔ ŋ nʊ, ŋ ʊ: «Bɔ m mɩŋŋa Woso mɩm ʊ? Ʊ ʊ tʊr ka awɔɔ ma gɛɛ, ʊ ʊ tʊr ka Woso ma? K'a a hɔɔn da ma, a dɩga a. ");
INSERT INTO bib_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kʊ wɔɔ nɩ, wɔɔ b'ʊ dam ma, ʊ hɔ kʊ wɔɔ yɩ, ʊ a ma bɩ hɩrɛ to y.» ");
INSERT INTO bib_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kʊ ŋ nɩ nyi bam zamaa bɩ m bɩ, ŋ b'a dam ma, ŋnɩ hɔsɩ ba ŋ nɩ y. Ŋ n a ya, ŋnɩ nyaa ba kan ŋ kɩ, ŋnɩ ŋ to. Bala, gʊaa haay y'a lɛ bɔm Woso ʊ hɔ k'a ba bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Bɩ, gʊaa k'a waarɛ yɩ hoser naa do barɛ nɔ ʊ bɩ, a dɔɔraa lɛ da busi m. ");
INSERT INTO bib_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kʊ ŋ wɔ saa ŋ ma bɩ, Pɩyɛɛr kan Zaan kɩ ta a muno wɔɔ zi, ŋn'aa hɔ kʊ wosocɛmannɩbənno jɩtannɔ kan tara gʊɔɔgusinno wɔɔ kɩ a hɩ bɩ dɩnda ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","N n a tʊr ka ŋ ma. Ŋ haay n a zɛ kʊ ra deem, ŋn'a hɩ Woso m, ŋ ʊ: «Karɩnsaamba, ɩbɩɩ ‹brama da kan tara kɩ, hi kɩ, kan hɔ haay k'an a nɔ ʊ bɩ kɩ.› ");
INSERT INTO bib_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ɩbɩɩ Sɛnt-Ɛspri paŋŋa da ɩ zibəənyɩ Davɩd wɔɔ yaaba bɩ lɛ ʊ, minno nɔɔn duro minto: Bɔ minto kʊrɔ nɩ həən sire ncɩnaaʊ, zamaa n'a hɔɔn dam, hɔɔndarɛ vam-vam nɩ? ");
INSERT INTO bib_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Durnya cinno n a zɔ kʊ ma, kʊrɔ cinno n a so kʊ ma k'a yar ba kan Zuuba Woso kɩ, a Krista kɩ. ");
INSERT INTO bib_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sɩra m, Hɩrɔɔdɩ kan Pɔns Pɩlatɩ kɩ a zɛ kʊ ra tara naa do nɔ ʊ, kan do vantɔɔ kɩ Israyɛl zannɔ kɩ, k'a yar ba kan Yeezuu ɩbɩɩ zibəəzaa mɩŋŋa k'ɩbɩɩ bɔ ʊ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Naa ba ŋ y'a ʊ, k'ɩbɩɩ paŋŋa, ɩ hɔɔnhɔ k'ɩbɩɩ lɛɛ ka ɩ cɩnta bɩ n kʊ yɩ. ");
INSERT INTO bib_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Naa ma kɛɛrɛ bɩ, Zuuba, ɩ tʊr ka ŋ nyaabarɛ meerbaa bɩ ma, k'ɩ ka k'ɩ zibəənyɩnɔ wɔɔ n'ɩ lemim bɩ hɩ kan heerkoodəbaa kɩ. ");
INSERT INTO bib_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ɩ wɔ hʊr, ɩ ka kʊ yaabazannɔ m waarɛ yɩ, kʊ makrarɔ m ba, kan hoserlo kɩ ɩbɩɩ Zibəənyɩ mɩŋŋa Yeezuu tɔ ma.» ");
INSERT INTO bib_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kʊ ŋ yaa bɩ da ŋn'a nya bɩ, bɩncɛ niŋŋə kʊ ŋ nɩ ta ʊ bɩ hinkə. Sɛnt-Ɛspri gasʊ ŋ ʊ an ŋ han haay. Ŋ nɩ Woso lemim bɩ pa dam kan heerkoodəbaa kɩ. ");
INSERT INTO bib_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Zamaa bɩ kʊ ŋ y'a ba sɩrakarɛzannɔ wɔɔ, ŋ heer a ba deem, nyi deem, gʊaa ba ʊ an nɩ hɔ m, a ʊ, awɔɔ y'a so ʊ y. Hɔ haay bɩ zɛ ŋ nawʊm kʊ ra deem. ");
INSERT INTO bib_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kristazibəəzannɔ wɔɔ ɩ Zuuba Yeezuu mɩmbɔʊrɛ kasɛtɩ karɛ kan paŋŋa gʊta kɩ. Ŋ haay nɩ zi bam Woso barka gʊta kʊ ŋ y'a yɩ bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Gʊaa ba ʊ ŋ bire ʊ an cicirzaa y. Gʊɔɔ kʊ ŋ nɩ tararɔ m nɔ wɔɔ, gɛɛ, ŋ nɩ harlɔ m nɔ wɔɔ, ŋ hɛɛ ŋ nawʊrɛ, ŋn'ɩ zɛrɛ a busoo kʊ ŋ y'a yɩ bɩ m, ");
INSERT INTO bib_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ŋnɩ b'a ka kristazibəəzannɔ wɔɔ ʊ. Gʊaa biyəə k'a lɛ taa daahan ma bɩ, a y'a yɩrɛ amba a lɛ taa bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Amba Zozɛf kʊ kristazibəəzannɔ wɔɔ a tɔ ka Barnabas bɩ, a lɛ taa k'a hɩ a ʊ «muno heeryurezaa» bɩ n nɩ hɔsɩra m. Levii do gʊaa m, an a to Siipɩr ʊ. ");
INSERT INTO bib_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","A n a hɔsɩra bɩ hɛɛ, an a busoo bɩ sa, an b'a ka kristazibəəzannɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gʊaa deem n ta ʊ, a tɔ m Ananɩyas, an kʊ ma kan a lʊ Safɩɩra kɩ ŋn'a tara hɛɛ. ");
INSERT INTO bib_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","A n kʊ ma kan a lʊ bɩ kɩ, an busoo bɩ bɔ ʊ an a cɩnta, an a mɩsɩ bɩ sa an aa a ka kristazibəəzannɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pɩyɛɛr n a hɩ, a ʊ: «Ananɩyas, bɔ m Sʊtaana n'ɩbɩɩ heer han? Ɩbɩɩ ŋʊaar ba Sɛnt-Ɛspri m, ɩ tara k'ɩbɩɩ hɛɛ bɩ busoo bɩ bɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ɩbɩɩ n ɩ da ma ɩ tara bɩ hɛɛrɛ to, ɩ ba ɩ hɔ ra? Gɛɛ, k'ɩ hɛɛ, ɩ busoo bɩ sa ɩ hɔ k'ɩ lɛ n taa bɩ bam na? A ba ɩbɩɩ ʊ lɔ, ɩ naa da ɩ heer ʊ? Ŋʊaar bɛɛ ɩbɩɩ ba gʊɔɔ nɩ y, a ba ɩbɩɩ ʊ Woso m.» ");
INSERT INTO bib_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananɩyas k'a naa ma bɩ, an a do, an ga. Nyibəə gʊta gasʊ gʊɔɔ kʊ ŋ minno nɔɔn duro ma rɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Gʊɔɔ pooro n bʊr, ŋnɩ b'a gər bɩ sa, ŋnɩ pɛɛra burgu ma, ŋn'aa a bir. ");
INSERT INTO bib_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","A maasɩrɛ ba, an a zɔ wakatɩ kaakʊ ma, a lʊ bɩ n bɩ gasʊ, an a dɔ kʊ bɔ ɩ ba y. ");
INSERT INTO bib_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pɩyɛɛr n a lar, a ʊ: «Tara bɩ k'awɔɔ hɛɛ bɩ, a lɛ paan… m naa ra?» A n a nyɩ bɔ ʊ, a ʊ: «Ɩɩn…, a lɛ n bɩ bala.» ");
INSERT INTO bib_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pɩyɛɛr n a ya, an a lar, a ʊ: «A ba awɔɔ lɔ a a lɛ ba deem k'a Zuuba Sɛnt-Ɛspri bɩ makra ba? Ɩ tʊr ka gʊɔɔ kʊ ŋ yaa ɩbɩɩ zim bɩ bir lɔ wɔɔ gam heer ma hallɛ ma, ŋ y'ɩbɩɩ busum sɔ.» ");
INSERT INTO bib_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lɛɛm bɩ, Safɩɩra a do Pɩyɛɛr jɩr ʊ, an ga. Kʊ gʊɔɔ pooro wɔɔ bʊr bɩ, ŋ bɩ dɩga a a ga, ŋn'a busu k'a yaa bir a zim bɩ jɩr ʊ. ");
INSERT INTO bib_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Dabɔʊ gʊta sɩrakarɛzannɔ wɔɔ nyasʊ haay, kan gʊaa haay k'a minno nɔɔn duro ma bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kristazibəəzannɔ wɔɔ ɩ makrarɔ kan hoserlo kɩ bam gʊta zamaa bɩ bire ʊ. Ŋ haay a zɛ kʊ ra deem Salomɔɔn laŋŋa taa b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bɩ, gʊaa k'a n sɩra ka Woso ʊ paan… bɩ bɩr yɛm an n'a zɛm kʊ ra kan ŋ kɩ y. Kan bɩ kɩ, zamaa bɩ n n'a lɛ bɔrɛ ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Gʊɔɔ cir gʊta, yaarɔ kan lannɔ kɩ ɩ sɩra kam Zuuba ʊ, ŋn'a zarlɛ ŋ la. ");
INSERT INTO bib_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","N n bʊr yaabazannɔ m zaarɔ bire ʊ, ŋnɩ ŋ wʊta gargʊrɔ ʊ gɛɛ gʊraŋŋarɔ ʊ, kʊ Pɩyɛɛr bʊr an nɩ cenim b'ʊ gɛɛ a hinni y'a kam niŋŋoo ra gɛ. ");
INSERT INTO bib_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Gʊɔɔ gʊta n a to yaabazannɔ m Zerizalɛm gʊrgarɔ ʊ kan gʊɔɔ kʊ zinəro nɩ kan ŋ kɩ rɔ wɔɔ kɩ, ŋnɩ bʊr ŋ nɩ, ŋn'a waa haay. ");
INSERT INTO bib_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dɔmɩm bɩ do ʊ bɩ, wosocɛmannɩbər jɩtaarɛ kan a jɛzannɔ kɩ, Sadisɛɛnrɔ wɔɔ, wuti kan jɩmbaa heerbusu kɩ. ");
INSERT INTO bib_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ŋ n a ka, ŋnɩ kristazibəəzannɔ wɔɔ gʊr gʊɔɔ mɩm m, ŋnɩ ŋ du lɔnnɔcɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Gunuu ʊ bɩ, Zuuba malɛɛka bʊr, an bɩ lɔnnɔcɛ bɩ lɛ rɔ wɔɔ gʊngʊ, an ŋ bɔ, an a hɩ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«K'a ta a yaa jɩm Wosocɛ ʊ b'ʊ, a mɩsɩrbaa daa naa do minno nɔɔn duro haay hɩ zamaa bɩ m.» ");
INSERT INTO bib_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kʊ ŋ naa ma bɩ, dɔ k'a mɛ bɩ, ŋ ta Wosocɛ ʊ b'ʊ k'a yaa dɩnda gʊɔɔ wɔɔ m. Wosocɛmannɩbər jɩtaarɛ bɩ n lee ku kan a jɛzannɔ wɔɔ kɩ. A n a ka ŋnɩ dʊdɔkənno wɔɔ bir haay, Israyɛl gʊɔɔgusinno wɔɔ haay, an nyɔɔ da kʊ n aa kristazibəəzannɔ wɔɔ bɔ lɔnnɔcɛ ʊ, n nɩ bʊr ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Gʊɔɔ wɔɔ kʊ ŋ ta bɩ, kʊ ŋ yaa lee ku b'ʊ bɩ, ŋ n ŋ yɩ lɔnnɔcɛ ʊ b'ʊ y. Ŋ n a wusigə ŋn'aa a hɩ, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Wɔɔ yaa lɔnnɔcɛ bɩ yɩ ŋn'a ta mɩŋŋa, a dɔmazannɔ wɔɔ n nɩ jɩnɩm cɛrɔ wɔɔ lɛ ma. Kʊ wɔɔ gʊ bɩ, wɔɔ n gɔsɩ yɩ a nɔ ʊ y.» ");
INSERT INTO bib_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wosocɛ dɔmazannɔ cir bɩ k'a naa ma kan wosocɛmannɩbənno jɩtannɔ wɔɔ kɩ bɩ, ŋ zɛ kədə kristazibəəzannɔ wɔɔ minto, ŋn'a mɩŋŋa larm naa k'a ba ncɩnaaʊ bɩ, a jɩ nyɩntam lɔ? ");
INSERT INTO bib_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Gʊaa n bʊr an b'a hɩ ŋ nɩ, a ʊ: «Gʊɔɔ k'awɔɔ n gʊr a ŋ du rɔ wɔɔ ɩ Wosocɛ ʊ ŋn'ɩ hɔ dɩndam gʊɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wosocɛ dɔmazaa bɩ n ta kan a zibəəzannɔ kɩ kristazibəəzannɔ wɔɔ zi, an aa ŋ gaa an bʊr ŋ nɩ. Ŋ n paŋŋa ba ŋ ma y, bala, ŋ y'ɩ nyi bam zamaa bɩ m, ŋ y'a a gʊngʊɛɛn jaarɔ m. ");
INSERT INTO bib_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ŋ n ŋ gaa, ŋnɩ bɩ ŋ hɩnka dʊdɔkənno wɔɔ m. Wosocɛmannɩbər jɩtaarɛ bɩ n ŋ lar, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Wɔɔ hɩ awɔɔ m mɩŋŋa, ʊ ʊ: A b'a ya, a tɔ naa do hɩ a karɩnda nɔ ʊ y, awɔɔ karɩnda bɩ n bɔkarɛ an Zerizalɛm han, a lɛ n taa k'a gʊaa naa do ma bɩ ka wɔɔ mim la.» ");
INSERT INTO bib_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pɩyɛɛr kan kristazibəəzannɔ wɔɔ kɩ a nyɩ bɔ ʊ, ŋ ʊ: «A a ga m, k'ɩ Woso lɛ si, k'ɩ gʊɔɔ to. ");
INSERT INTO bib_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Wɔɔ zɩrɔ Woso, Yeezuu k'awɔɔ zeŋŋə gɔ ma a zɛ gər bɩ, mɩm bɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Bɩ, Woso a busu a bɩsɩ ʊ arzana ʊ, an cirbəə ka ʊ, an a ba bʊmbɔrɛzaa, k'an a ka kʊ Israyɛl gʊɔɔ n a bɔ a taam, ŋnɩ ŋ sugur yɩ. ");
INSERT INTO bib_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Minno nɔɔn duro kasɛtɩzannɔ m wɔɔ m, wɔɔ kan *Sɛnt-Ɛspri kʊ Woso a ka gʊɔɔ kʊ n n'a lɛ sim nɔ wɔɔ ʊ kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Minno nɔɔn duro ŋ heer busu, ŋn'a hɔɔn darɛ ŋ zɩnzɛrɛ ma. ");
INSERT INTO bib_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Gʊaa deem n wuti dʊdɔkənno wɔɔ bire ʊ. Farizɛn m, a tɔ m Gamalɩyɛl, wosocikarɩnsaamba m, gʊɔɔ wɔɔ n'a daŋ ʊ. A n lɛ ka kʊ ŋ nɩ bɔ kristazibəəzannɔ wɔɔ m cɩna, ");
INSERT INTO bib_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","an a hɩ, a ʊ: «Israyɛl zannɔ, k'a dundo a zi mɩŋŋa kan hɔ k'awɔɔ k'a ba gʊɔɔ nɔɔn duro m bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dɔɔraarɔ kʊ ŋ cem dɩɩtaa rɔ nɔɔn nɔ ʊ, Tedas a hɩnka wɔɔ m, a ʊ: Gʊaa gʊta n'awɔɔ m. A n gʊɔɔ gaa, an ŋ so kʊ ma, ŋ lɛ n a zɔ zɔrsi ma. Ŋ y'a mɩŋŋa zɛ, a karɩndanyɩnɔ wɔɔ haay hɩsɩga da. Gɔsɩ n gɔɔta y. ");
INSERT INTO bib_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bɩ jɛ ʊ, lɛsarɛ dɔmɩm ʊ, Galilee gʊaa Zidas a hɩnka wɔɔ m. Gʊɔɔ gʊta nɩ zure a jɛ ʊ. Bɩ mɩŋŋa ga sɔ, gʊɔɔ kʊ ŋ nɩ zure a jɛ ʊ rɔ wɔɔ n hɩsɩga da. ");
INSERT INTO bib_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Bɩ y'a ka, mɔɔ n'a hɩrɛ awɔɔ m kɛɛrɛ, k'a gʊɔɔ nɔɔn duro to kʊ ŋ nɩ cem, a bɩ hɔsɩ ba ŋ nɩ y. Meerbaa naa do kan zibəə naa do kɩ, kʊ gʊɔɔ hɔɔ nɩ, ŋ nyaanlɛ a zim. ");
INSERT INTO bib_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bɩ kʊ Woso hɔɔ nɩ, awɔɔ b'a dam ma a ka, ŋ n nyaam nɩ y. K'a dundo a zi, a b'a ka, a bɩ yar ba kan Woso kɩ y.» Ŋ yɛ Gamalɩyɛl meerbaa bɩ ma. ");
INSERT INTO bib_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ŋ nɩ kristazibəəzannɔ wɔɔ bir, ŋn'a ka, ŋnɩ ŋ zɛ madɩɩrɔ m, ŋn'a hɩ ŋ nɩ, ŋ ʊ, ŋ b'a ya, ŋnɩ Yeezuu tɔ hɩ y, ŋnɩ wɔ saa ŋ ma. ");
INSERT INTO bib_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kristazibəəzannɔ wɔɔ n bɔ dʊdɔkarɛ bɩncɛ ʊ b'ʊ kan heernyɔɔ kɩ, kʊ Woso yɛ ŋn'a ga fɩryɩrɛ m Yeezuu tɔ ma bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Dɔmɩm biyəə, amba Wosocɛ ʊ gɛɛ har ʊ, ŋ bɩr Yeezuu Krista lemim nyɩnta bɩ dɩndarɛ kan a padarɛ kɩ tore y. ");
INSERT INTO bib_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dɔmɩnnɔ wɔɔ duro ʊ bɩ, karɩndanyɩnɔ wɔɔ lɛ y'a dam la, zɩɩfʊrɔ kʊ ŋ nɩ grɛkkɩ lemim hɩm nɔ wɔɔ n wuti kukur barɛ m kan kʊ bɩ zɩɩfʊrɔ wɔɔ kɩ. Bala, ŋ dɔmɩm haay hɔ jirle bɩ, ŋ bɩr a karɛ ŋ zonno wɔɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Bueerehɩɩyɔɔ wɔɔ n zamaa sɩrakarɛzannɔ wɔɔ so kʊ ma ŋn'a hɩ ŋ nɩ, ŋ ʊ: «A n a ga m k'ʊ wɔ saa Woso lemim nyɩnta pa darɛ ma, k'ʊ hɔbɩrɛ jir y. ");
INSERT INTO bib_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","M danyɩnɔ, k'a ka gʊɔɔ yaarɔ mɩŋŋɔɔ ma a bire ʊ saanhɩna, Sɛnt-Ɛspri n ŋ heer han kan mindɔrɛ kɩ, k'ʊ zibəə naa do ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kʊ wɔɔ nɩ, wɔɔ ba n bɩr ʊ tɔŋ ʊ kan yaadarɛ kɩ, ʊ bɩr Woso lemim nyɩnta bɩ pa dam.» ");
INSERT INTO bib_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Zamaa bɩ haay yɛ meerbaa naa do ma: ŋ n Etɩyɛnnɩ bɔ ʊ, gʊaa m, sɩrakarɛ n a heer han kan Sɛnt-Ɛspri kɩ, kan Filipi kɩ, Prokɔɔr kɩ, Nikanɔɔr kɩ, Timɔn kan Parmenas kɩ, kan Antɩyɔs gʊaa Nikola k'a nɩ zum zɩɩfʊrɔ wɔɔ lɛrɔ wɔɔ ʊ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ŋ nɩ ŋ hɩnka kristazibəəzannɔ wɔɔ m, ŋnɩ yaa da, ŋn'a wɔ ka ŋ mim la. ");
INSERT INTO bib_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Woso lemim bɩ padarɛ n'a dam la, karɩndanyɩnɔ wɔɔ lɛ n'a dam la gʊta Zerizalɛm ʊ. Wosocɛmannɩbənno gʊta nyɩnta ŋn'ɩ zum sɩrakarɛ zaa b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Barka kan paŋŋa kɩ kʊ ŋ Etɩyɛnnɩ han bɩ, a nyɩnta an nɩ hoserlo kan makrarɔ gʊtɔɔ kɩ bam zamaa bɩ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Gʊɔɔ gɔsɩnnɔ n wuti meerbaa m kan Etɩyɛnnɩ kɩ: Nyɩnta ŋ y'a ʊ lɔnnɔ, ŋnɩ wɔ saa ŋ ma, ŋ sokʊmacɛ bɩ n a hɔ. Sirɛnnɩ kʊ zɩɩfʊrɔ nyɩnta ŋ barla kan Alɛsandrii zannɔ kɩ, Silisii zannɔ kɩ, Azii zannɔ kɩ. Ŋ n a sɩŋŋɩda sa ŋn'ɩ bɩsɩ kam kan Etɩyɛnnɩ kɩ, ");
INSERT INTO bib_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sɛnt-Ɛspri k'a a ka Etɩyɛnnɩ nɩ meer bam kan mindɔrɛ kɩ bɩ, ŋ bɩr a dam ma ŋn'a meerbaa bɩ nyɩ bɔŋ ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ŋ n zambʊ ba, ŋn'a ka gʊɔɔ ma kʊ ŋ n'a hɩ, ŋ ʊ: «Wɔɔ ma, an nɩ Woso sʊnsɔ wʊm kan Moyiisi kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nyɩnta a ʊ ncɩnaaʊ, ŋnɩ zamaa bɩ, gʊɔɔgusinno wɔɔ, kan wosocikarɩnsaambɔɔ wɔɔ kɩ nyʊnnyɔɔta ŋnɩ bɩ daata zɛ Etɩyɛnnɩ la, ŋn'a nyasʊ ŋnɩ ta m dʊdɔkənno taa. ");
INSERT INTO bib_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bɩ ŋ yaa kasɛtɩ ŋʊaarzannɔ bɔ ʊ, ŋ ʊ: «Gʊaa naa do bɩr wɔɔ Wosocɛ bɩ kan lɛrɔ wɔɔ kɩ sʊnsɔ wʊrɛ tore y. ");
INSERT INTO bib_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Wɔɔ ʊ ya, ʊ a ma an n'a hɩrɛ a ʊ, Nazarɛtɩ Yeezuu naa do n nɩ zɛm bɩ bɩncɛ naa do wurgə, an Moyiisi lɛrɔ k'a ŋ ka wɔɔ ʊ rɔ wɔɔ lʊr.» ");
INSERT INTO bib_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Gʊaa haay k'a nɩ nyɩntam dʊdɔkarɛ bɩncɛ ʊ b'ʊ bɩ, dɩga ŋ nawʊm ma, ŋn'a meer yɩ an bɔ kʊ ʊ kan malɛɛka hɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Wosocɛmannɩbər jɩtaarɛ bɩ n a lar, a ʊ: «Sɩra m naa gɛ?» ");
INSERT INTO bib_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etɩyɛnnɩ n a nyɩ bɔ ʊ, a ʊ: «K'a a tʊr ka, m danyɩnɔ kan ŋ zɩrɔ kɩ. Woso k'a a so cirbəə ʊ b'a hɩnka wɔɔ yaaba Abraham m, dɔmɩm k'a nyɩnta ʊ Mezopotamii ʊ, an bɔkarɛ an ta Haaran ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","A n a hɩ m, a ʊ: ‹Ɩ gʊ ɩ kʊ bɩ ma, kan ɩ harzannɔ kɩ, ɩ ta tara kʊ mɔɔ n n'a hɩnkarɛ ɩbɩɩ m b'ʊ.› ");
INSERT INTO bib_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abraham n a gʊ Kalde zannɔ kʊ bɩ ma, k'a yaa nyɩnta Haaran ʊ. B'ʊ bɩ, a zɩ garɛ kur bɩ, Woso n a bɔ kʊ bɩ do nɔ ʊ, an bɩ nyɩnta kʊ k'awɔɔ n ta ʊ heer naa ʊ. ");
INSERT INTO bib_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","A n tara ka ʊ k'an a so ʊ kʊ bɩ do ʊ y, b'a gam cɩnta jɩ ba ʊ y. B'a a ler bɔ m k'a ka ʊ k'an a so ʊ kan a yaŋŋarɔ kɩ, baa k'a n nyɩ yɩ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Woso n a hɩ, a ʊ: ‹A dogʊɔɔ nyɩntam do vanta tara ra, bɩ ŋ gasʊm lɔmbaa ʊ, ŋ fɩr karɛ ŋ ma dɔɔraa zɔrsi.› ");
INSERT INTO bib_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Woso n a hɩ, a ʊ: ‹Do niŋŋə k'a ŋ ba lɔnnɔrɔ wɔɔ, mɔɔ yɩ m dʊdɔ kam. Bɩ kur kɛɛrɛ bɩ, ŋ bɔm, ŋnɩ yaa da mɔɔ m bɩncɛ naa do ʊ.› ");
INSERT INTO bib_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","A n gʊaasɩbabaa da kan kɩ baŋŋʊgasʊrɛ nɔ ʊ. Bɩ minto y'a ka, Abraham k'a Izakkɩ yɩ bɩ, an a gasʊ baŋŋʊ ʊ a yɩrɛ dɔmɩm sinnyə hɔ ma, Izakkɩ n a ba maam sɔ kan Zakɔɔb kɩ. Zakɔɔb n a ba a nyɩnɔ bueerehɩɩyɔɔ kʊ ŋ y'a ba wɔɔ zɩrɔ wɔɔ m maam sɔ.» ");
INSERT INTO bib_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Wɔɔ zɩrɔ wɔɔ n bɔkarɛ ŋnɩ sɔ Zozɛf m, ŋn'a hɛɛ. N n a gaa n nɩ ta m Eziptɩ ʊ. Bɩ, Woso nyɩnta kan kɩ. ");
INSERT INTO bib_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","A n a bɔ a fɩr do haay nɔ ʊ, an hɔɔn ka ʊ kan barka kɩ Eziptɩ cir Farawɔn taa. Bɩ m Zozɛf ba Eziptɩ lɛɛzaa, an a so Eziptɩ ʊ kan a har kɩ haay. ");
INSERT INTO bib_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nɔ gʊta n b'a da Eziptɩ kʊ ʊ haay ʊ, kan Kanaan kʊ kɩ ʊ. Fɩryɩrɛ bɩ paŋŋa nyɩnta ʊ, wɔɔ zɩrɔ wɔɔ n hɔbɩrɛ yɩ ŋn'a bɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kʊ ŋ y'a ma, ŋ ʊ hɔbɩrɛ ɩ Eziptɩ tara ra bɩ, Zakɔɔb a nyɩnɔ, wɔɔ zɩrɔ wɔɔ nyɔɔ ŋ lɛɛkarɛ hɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A hɩɩya hɔ ma bɩ, Zozɛf a hɩnka a danyɩnɔ wɔɔ m. Bɩ Farawɔn a danyɩnɔ wɔɔ dɔ ma ʊ. ");
INSERT INTO bib_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Bɩ m, Zozɛf n nyɔɔ da, ŋn'aa a zɩ Zakɔɔb gaa kan a dogʊɔɔ kɩ. Ŋ y'a zɛ kʊ ra haay gʊaa busaanhɩna a yaa soor. ");
INSERT INTO bib_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Zakɔɔb n ta Eziptɩ ʊ, an aa ga b'ʊ kan wɔɔ zɩrɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ŋ n ŋ gʊr, ŋnɩ ta ŋ nɩ Sikɛm ʊ ŋn'aa ŋ bir yaa kʊ Abraham a si busoo m Emɔɔr nyɩnɔ zi, Sikɛm tara ra b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Woso lerbɔrɛ k'a ba kan Abraham kɩ kan kʊ yɩ bɩ dɔmɩm k'a n'a zɔm bɩ, zamaa bɩ lɛ a da ra, ŋn'a ba gʊta Eziptɩ tara ra, ");
INSERT INTO bib_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","an ta an Eziptɩ cir vanta k'a bɩ cirbəə bɩ, b'a n Zozɛf dɔ bɩ ku. ");
INSERT INTO bib_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Cir bɩ do nyɩnta bʊnyaa, an zambʊ ba wɔɔ do bɩ ma. A paŋŋa ba wɔɔ zɩrɔ wɔɔ ma, an a ka ŋn'a a nyɩnɔ poorero gʊr, ŋn'aa ŋ lo kʊ ŋ nɩ gɩnga. ");
INSERT INTO bib_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Dɔmɩm bɩ do Moyiisi yɩ ʊ. A gʊɛrɛ nyɩnta ʊ Woso mɩm ʊ. A tʊr n y'a ʊ mom kaakʊ a zɩ har ʊ. ");
INSERT INTO bib_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bɩ kʊ ŋ y'a zo bɩ, Farawɔn nyɩmbʊɛɛrɛ bɩ y'a busu an a tʊr, an a ba a nyɩ. ");
INSERT INTO bib_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moyiisi n Eziptɩ zannɔ wɔɔ hɔɔn dɩnda haay, a meerbaarɔ kan a zibəəro kɩ paŋŋa nyɩnta ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«K'a dɔɔraa busi ku bɩ, a a hɔɔn da a ʊ, k'a dɩga a danyɩnɔ Israyɛl zannɔ wɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","K'a deem yɩ Eziptɩ gʊaa nɩ fɩr kam ma bɩ, k'a ʊ k'a a da a danyɩ k'a nɩ fɩr yɩm bɩ han a bʊmbɔ bɩ, an Eziptɩ gʊaa bɩ zɛ, an ga. ");
INSERT INTO bib_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A hɔɔn a da a ʊ a danyɩnɔ wɔɔ y'a dɔrɛ ŋ ʊ, Woso y'a bɔ ʊ k'a bɩ ŋ bʊmbɔ, bɩ ŋ n a jɩ ma y. ");
INSERT INTO bib_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","A dɔ k'a mɛ bɩ, a a danyɩnɔ hɩɩyɔɔ yɩ ŋnɩ kʊ zɛm, an a zɔ k'a ŋ bʊmbɔ kʊ ʊ, an n'a hɩrɛ, a ʊ: ‹M hannyɩnɔ, danyɩnɔ n'awɔɔ m kan kʊ kɩ, bɔ minto, awɔɔ nɩ kʊ zɛrɛ?› ");
INSERT INTO bib_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Bɔzaa nɩ fɩr karɛ a mim bɩ ma bɩ n a wɔ nya Moyiisi cɩ ʊ, an kaanm m, an a hɩ m, a ʊ: ‹Nka y'ɩbɩɩ ba wɔɔ cir, k'ɩ nyɩnta wɔɔ dʊdɔkarɛzaa? ");
INSERT INTO bib_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ɩbɩɩ lɛ n taa k'ɩ mɔɔ zɛ amba ɩbɩɩ Eziptɩ zannɔ gʊaa bɩ zɛ jim bɩ m na?› ");
INSERT INTO bib_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moyiisi k'a naa ma bɩ, an a si, an aa a nyaakʊm da kʊ vanta ʊ, Madɩyan tara ra. B'a nyɩnɔ yɩ ʊ hɩɩya.» ");
INSERT INTO bib_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Dɔɔraa busi kur bɩ, malɛɛka a hɩnka m Sinayii ci poohɔɔn ʊ tutugu ʊ, sɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moyiisi k'a naa yɩ bɩ, a zɛ kədə, an a zɔ k'a dɩga a. A Zuuba Woso leer ma, an n'a hɩrɛ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Ɩbɩɩ zɩrɔ Abraham kan Izakkɩ kɩ Zakɔɔb kɩ Woso m mɔɔ m.› Moyiisi da n bɔ ʊ, a mɛ nɩ nyiŋŋəm, a n yɛ k'a a ya, a a mɩm busu a dɩga y. ");
INSERT INTO bib_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Zuuba n a hɩ m, a ʊ: ‹Ɩ kʊsɔrɔ bɔ ɩ gam ʊ, bala, bɩncɛ k'ɩbɩɩ n nɩ jɩnɩŋ ʊ naa, bɩncɛ mɩŋŋa m, bala mɔɔ ɩ naa ʊ. ");
INSERT INTO bib_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mɔɔ m gʊɔɔ wɔɔ cicir yɩ Eziptɩ tara ra, mɔɔ ŋ zeedarɛ ma, mɔɔ n zer kʊ m ŋ bʊmbɔ. Naa ma kɛɛrɛ bɩ, mɔɔ lɛ n taa kʊ m ɩ nyɔɔ Eziptɩ kʊ ʊ.› » ");
INSERT INTO bib_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Moyiisi bɩ do ŋ kaanm m ŋn'a hɩrɛ, ŋ ʊ: ‹Nka y'ɩbɩɩ ba cir, dʊdɔkarɛzaa sɔ?› Bɩ, Woso a nyɔɔ k'an bɩr cir, bʊmbɔrɛzaa sɔ kan malɛɛka k'a hɩnka m tutugu nɔ ʊ bɩ daahan kɩ. ");
INSERT INTO bib_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Bɩ yɩ ŋ gaa, an bɔ ŋ nɩ kan hoserlo barɛ kɩ, makrarɔ kɩ Eziptɩ tara ra, higʊta piinə bɩncɛ ʊ, poohɔɔn ʊ, dɔɔraa busi. ");
INSERT INTO bib_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moyiisi mɩŋŋa y'a hɩ Israyɛl zannɔ m, a ʊ: ‹Woso y'a lɛsinnɩsorazaa bɔŋ ʊ awɔɔ danyɩnɔ bire ʊ, amba mɔɔ m, an a ka awɔɔ ʊ.› ");
INSERT INTO bib_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","A mɩŋŋa ɩ nyɩnta kan Israyɛl zannɔ wɔɔ kɩ poohɔɔn ʊ, malɛɛka n meer ba kan kɩ Sinayii ci mim ʊ. A n mɩsɩrbaa lemim si an a ka wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Wɔɔ zɩrɔ wɔɔ n yɛ k'a lɛ si y. Ŋ kaanm m, ŋn'a ŋʊa k'a a bɔ a ta Eziptɩ tara ra.» ");
INSERT INTO bib_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","«Ŋ n a hɩ Aarɔn m, ŋ ʊ: ‹wosoro ba ɩ ŋ ka wɔɔ ʊ, kʊ ŋ nɩ bɩr ʊ lɛɛ. Bala, Moyiisi naa do k'a wɔɔ gaa an bɔ wɔɔ m Eziptɩ ʊ naa, wɔɔ n a dɔ kʊ bɔ ɩ ba nɩ y.› ");
INSERT INTO bib_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ŋ n hɔ ba an bɔ kʊ ʊ kan dinnyɛɛm kɩ, dɔmɩnnɔ wɔɔ duro ʊ, ŋnɩ mannɩ ba ma, ŋnɩ hɔ kʊ ŋ y'a ba bɩ cibsa ba kan heernyɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Woso n kaanm ŋ nɩ, an ŋ to ŋn'ɩ brama monyaarɔ daŋ ʊ, amba ŋ y'a gʊrsɩra ba wosolɛsinnɩsorazannɔ ci ʊ bɩ m: Israyɛl zannɔ, mɔɔ awɔɔ ganwʊrɛ gɛɛ mannɩhɔ ka m ʊ dɔɔraa busi nɔ ʊ, poohɔɔn ʊ ra? ");
INSERT INTO bib_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Awɔɔ wosobaawɔm Molok cɛ kʊ n y'a ba huu m bɩ busu kan awɔɔ woso Refan monyaa kɩ, hɔɔbarɛrɔ, awɔɔ ŋ ba, k'a bɩr ŋ daŋ ʊ. Naa tɔ ma bɩ, mɔɔ tarɛ awɔɔ m lɔmbaa ʊ laatʊ *Babɩlɔnnɩ ma.» ");
INSERT INTO bib_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Wɔɔ zɩrɔ kʊ ŋ nyɩnta poohɔɔn ʊ rɔ wɔɔ, ŋ nyɩnta Woso taʊrɛ kasɛtɩ cɛ m. Ba a ʊ, amba Woso meer ba kan Moyiisi kɩ an a hɩ m bɩ m. A ʊ: ‹A ba amba hɔ niŋŋə k'ɩbɩɩ yɩ bɩ m.› ");
INSERT INTO bib_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Wɔɔ zɩrɔ wɔɔ kʊ ŋ y'a si bɩ, ŋ gasʊ m tara kʊ Zoziye ka ŋ lɛɛ, ŋnɩ yar ba ʊ Woso m la do vantɔɔ ra ŋn'a so ʊ naa ʊ. Bɩ, a gɔɔta ʊ, an ta, an Davɩd dɔmɩm ku. ");
INSERT INTO bib_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davɩd barka yɩ Woso taa, Zakɔɔb Woso bɩ, an zaa yɛ han k'a cɛ dɔ a ka ʊ. ");
INSERT INTO bib_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Salomɔɔn ɩ cɛ bɩ dɔ an a ka ʊ. ");
INSERT INTO bib_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Bɩ Woso k'a lɛ da haay bɩ bɩr nyɩntam cɛrɔ kʊ gʊɔɔ ŋ dɔ rɔ wɔɔ ʊ y. Amba wosolɛsinnɩsorazaa a da a ci nɔ ʊ bɩ m: ");
INSERT INTO bib_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Zuuba Woso a hɩ: Mɔɔ nyɩntajɩ bɩncɛ m arzana m, tara m mɔɔ gankarahɔ. Cɛ kara awɔɔ k'a dɔ a ka mɔɔ ʊ? Mɔɔ mɛnyɔɔdarɛ bɩncɛ m kara? ");
INSERT INTO bib_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mɔɔ wɔ bɛɛ hɔ haay naa ba ra?» ");
INSERT INTO bib_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Tʊrgarɛ zannɔ n'awɔɔ m, awɔɔ heer kan awɔɔ tʊr kɩ bɩr Woso mim sire y. Awɔɔ nɩ bɩsɩ kam Sɛnt-Ɛspri ma dɔmɩm haay. Awɔɔ kan a zɩrɔ wɔɔ kɩ hɔdeem. ");
INSERT INTO bib_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wosolɛsinnɩsorazaa bɩ kara ɩ nyɩnta ʊ awɔɔ zɩrɔ wɔɔ n fɩr ka ma? Ŋ mɩŋŋɔɔ ɩ gʊɔɔ gɔsɩnnɔ kʊ ŋ lɛɛ ka ŋnɩ Gʊaa tɩrga bɩ zɛrɛ bɩ hɩ rɔ wɔɔ zɩnzɛ, gʊaa bɩ do awɔɔ zambʊ ba ma, a zɛ. ");
INSERT INTO bib_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Woso malɛɛkarɔ nyɔɔ ŋnɩ bɩ Woso lɛrɔ hɩ awɔɔ m, b'awɔɔ n zu ʊ y.» ");
INSERT INTO bib_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Minno nɔɔn duro ŋ heer busu, ŋn'a sɔ sʊrɛ Etɩyɛnnɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Bɩ Sɛnt-Ɛspri k'a Etɩyɛnnɩ han bɩ, an a bɔɔta, an dɩga brama, an Woso lɛbɔʊrɛ yɩ, Yeezuu nɩ jɩnɩm Woso bɩsɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","A n a hɩ, a ʊ: «Ba mɔɔ arzana yɩ an a gʊ, mɔɔ n Gʊaanyɩ bɩ yɩ an nɩ jɩnɩm Woso bɩsɩ ʊ na.» ");
INSERT INTO bib_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ŋ n zee da, ŋn'a wɔ tɩnta a tʊʊrɔ rɛ. Ŋ haay wuti, ŋnɩ Etɩyɛnnɩ nyasʊ, ");
INSERT INTO bib_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ŋnɩ bɔ m tara bɩ nɔ ʊ, ŋn'a gʊngʊɛɛnm jaa m. Kasɛtɩzannɔ wɔɔ, a huuro wɔɔ kuntə ŋ y'a ʊ gʊaa poo kʊ n n'a birm Sol bɩ jɩr ʊ. ");
INSERT INTO bib_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kʊ ŋ nɩ Etɩyɛnnɩ gʊngʊɛɛnm bɩ, a ɩ yaa darɛ an n'a hɩrɛ, a ʊ: «Zuuba Yeezuu mɔɔ nyi si!» ");
INSERT INTO bib_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","A n sʊnta, an zee gʊta da, a ʊ: «Zuuba, ɩ bɩ ŋ mimbʊnyaa naa do taar ka ŋ ʊ y.» Naa k'a hɩ bɩ, an ga. ");
INSERT INTO bib_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol y'a hɔɔn darɛ a ʊ, Etɩyɛnnɩ garɛ bɩ mɩŋŋa. Hinni bɩ do ʊ bɩ, gʊɔɔ wɔɔ fɩr ka Zerizalɛm sokʊma bɩ ma. Sokʊmagʊɔɔ wɔɔ haay hɩsɩga da ŋnɩ ta Zidee kan Samarii kɩ gʊrgarɔ ʊ, kʊ bɩ m, kristazibəəzannɔ wɔɔ m bala. ");
INSERT INTO bib_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Gʊɔɔ kʊ ŋ sɩra ka Krista ʊ paan… rɔ wɔɔ ɩ Etɩyɛnnɩ busu ŋn'a bir, ŋnɩ nyi ka gʊta a minto. ");
INSERT INTO bib_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol bɩ, sokʊma bɩ wurgə an nawʊm, an nɩ gasʊm harlɔ ʊ, an nɩ yaarɔ gʊrm kan lannɔ kɩ, an nɩ ŋ dum lɔnnɔcɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bɔɔ y'a hɩsɩga rɔ wɔɔ ɩ tam kʊrɔ ʊ, ŋn'ɩ lemim nyɩnta bɩ pa dam. ");
INSERT INTO bib_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipi ta Samarii kʊ deem nɔ ʊ, an nɩ Krista pa dam. ");
INSERT INTO bib_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Zamaa bɩ haay n a zɛ kʊ ra, ŋn'a tʊr kam Filipi meerbaa bɩ ma. Bala, ŋ y'a hoserlo k'a nɩ ŋ bam nɔ wɔɔ mam, ŋn'a yɩrɛ. ");
INSERT INTO bib_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Zinəro gʊta ɩ bɔm gʊɔɔ kʊ ŋ gasʊ ŋ ʊ rɔ mɛ ʊ kan zee gʊta darɛ kɩ. Lʊgɔrɔ kan paŋŋawarzannɔ kɩ a waa. ");
INSERT INTO bib_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Heernyɔɔ nyɩnta ʊ gʊta tara bɩ do nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Bɩ, gʊaa ɩ nyɩnta kʊ bɩ nɔ ʊ, a tɔ m Sɩmɔɔn, nyɩsɩzaa m, an nɩ nyibəə dam Samarii zannɔ wɔɔ ma. A y'a hɩrɛ a zi m, a ʊ gʊaa gʊta naa a mɩ. ");
INSERT INTO bib_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Gʊaa haay nɩ tam zi, gʊɔɔ gʊtɔɔ kan gʊɔɔ poorero kɩ. Ŋ n a hɩrɛ, ŋ ʊ: «Gʊaa bɩ do, Woso paŋŋa kʊ n n'a birm paŋŋa gʊta bɩ m.» ");
INSERT INTO bib_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Gʊɔɔ wɔɔ y'a tʊr karɛ a lemim ma, bala, a ka k'a ʊ gʊɔɔ wɔɔ nɩ zɛm kədə a nyɩsɩrɔ wɔɔ tɔ ma bɩ, a dɔmɩm laatʊ. ");
INSERT INTO bib_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bɩ, kʊ ŋ Filipi Woso cirbəə lemim nyɩnta padarɛ bɩ si kan Yeezuu Krista tɔ kɩ bɩ, ŋ batɛm si, lannɔ kan yaarɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Bɩ kur bɩ, Sɩmɔɔn mɩŋŋa n a ba sɩrakarɛzaa sɔ, an batɛm si, an nɩ zum kʊ ʊ kan Filipi kɩ. Hoserlo kan makrarɔ kɩ k'a nɩ ŋ yɩm bɩ, a n zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kʊ ŋ y'a ma ŋ ʊ Samarii zannɔ Woso lemim bɩ si bɩ, kristazibəəzannɔ kʊ ŋ nyɩnta Zerizalɛm nɔ ʊ rɔ wɔɔ Pɩyɛɛr nyɔɔ kan Zaan kɩ. ");
INSERT INTO bib_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kʊ ŋ lee ku b'ʊ bɩ, ŋ yaa da Samarii zannɔ wɔɔ minto kʊ *Sɛnt-Ɛspri n zer, kʊ ŋ n a da ma ŋn'a si. ");
INSERT INTO bib_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Sɩra m, Sɛnt-Ɛspri n zer ŋ gʊaa deem taan… ra cɩna y. Batɛm ŋ y'a si Zuuba Yeezuu tɔ ma bala. ");
INSERT INTO bib_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pɩyɛɛr kan Zaan kɩ n'a wɔ kam Samarii zannɔ wɔɔ ra, ŋn'ɩ Sɛnt-Ɛspri sim. ");
INSERT INTO bib_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Sɩmɔɔn k'a yɩ kristazibəəzannɔ wɔɔ n'awɔɔ kam gʊɔɔ wɔɔ mim la, ŋnɩ Sɛnt-Ɛspri sim bɩ, a a cɩnta k'a busoo ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","A n n'a hɩrɛ, a ʊ: «K'a paŋŋa naa do ka m ʊ sɔ, gʊɔɔ kʊ mɔɔ n nɩ zɛm, kʊ m bɩ m wɔ ka ŋ la rɔ wɔɔ, kʊ ŋ nɩ Sɛnt-Ɛspri si.» ");
INSERT INTO bib_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pɩyɛɛr n a nyɩ bɔ ʊ, a ʊ: «K'ɩbɩɩ busoo bɩ n a zar kan ɩbɩɩ mɩŋŋa kɩ, ɩbɩɩ k'ɩ ɩ hɔɔn da ɩ ʊ, n y'a dam ma, ŋnɩ Woso ganwʊrɛ si busoo m bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Hɔ k'a nɩ bam naa ʊ naa, ɩbɩɩ bɩ hɔsɩ yɩrɛ a nɔ ʊ y, bala, ɩbɩɩ heer bɩ tɩrga Woso taa y. ");
INSERT INTO bib_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ɩ bɔ ɩ taam ɩ kʊsɩrabaa bɩ minto, k'ɩ yaa da Zuuba m. Hɔɔndarɛ k'a bʊr ɩbɩɩ heer ʊ bɩ, n y'a sugur karɛ ɩ ʊ barɛm. ");
INSERT INTO bib_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sɩra m, mɔɔ yɩ, jɩmbaa heerbusu kan mimbʊnyaa lɔmbaa kɩ nɔ ɩbɩɩ n ta ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sɩmɔɔn n a nyɩ bɔ ʊ, a ʊ: «K'a yaa da Zuuba m mɔɔ minto, hɔ k'awɔɔ hɩ mɔɔ m bɩ, kʊ hɔsɩ bɩ ba mɔɔ nɩ y.» ");
INSERT INTO bib_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pɩyɛɛr kan Zaan kɩ kʊ ŋ kasɛtɩ bɩ ka, ŋnɩ Zuuba lemim bɩ pa da bɩ, ŋ y'a wusigə Zerizalɛm ʊ, ŋn'ɩ lemim nyɩnta bɩ pa dam Samarii gʊrgarɔ ʊ gʊta. ");
INSERT INTO bib_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Zuuba malɛɛka deem meer ba kan Filipi kɩ, an a hɩ m, a ʊ: «Wuti ɩ ta jɩsa zeezi, ɩ zaa k'a bɔ Zerizalɛm ʊ an nɩ tam Gazaa ʊ bɩ sa. Zaa bɩ do, poohɔɔn m.» ");
INSERT INTO bib_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipi n wuti lɛɛm an ta. Bala, Etiyopii gʊaa deem, lannɔdɔmazaa, k'a m Etiyopii zannɔ lʊcir Kandasɩ arzaka dɔmazaa bɩ ta Zerizalɛm ʊ, an aa yaa da, ");
INSERT INTO bib_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","an a bɔ an nɩ doom. Nyɩnta a ʊ a tɛrkʊ nɔ ʊ, an nɩ wosolɛsinnɩsorazaa Ezayii ci karɩnda bam. ");
INSERT INTO bib_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Sɛnt-Ɛspri n a hɩ Filipi m, a ʊ: «Ta zɔɔ, ɩ tɛrkʊ bɩ ku.» ");
INSERT INTO bib_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipi n bra si, an wosolɛsinnɩsorazaa Ezayii ci karɩnda barɛ ma Etiyopii gʊaa bɩ lɛ ʊ, an a hɩ m, a ʊ: «Hɔ k'ɩbɩɩ n'a karɩnda bam naa, ɩbɩɩ y'a jɩ mam paan… ra?» ");
INSERT INTO bib_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A n a nyɩ bɔ ʊ, a ʊ: «Kʊ m a ba lɔ m a jɩ ma, kʊ gʊaa ba ʊ an n'a jɩ dɩndam mɔɔ nɩ?» A n Filipi bir, a ʊ, an bɩ nyɩnta a jɩr ʊ. ");
INSERT INTO bib_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Wosoci bɩ bɩncɛ naa do an n'a karɩnda barɛ: Amba, serda kʊ n bʊr m k'a b'a bʊkɔ bɔ ʊ, amba, sinnyɛɛm bəətir kʊ n n'a ka zɩnzɛm la, ncɩnaaʊ a bɩr meer barɛ y. ");
INSERT INTO bib_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kʊ n y'a da nyannɩ ʊ bɩ, a n gumə yɩ dʊdɔkənno zi y. Nka n nɩ naa do mim dɩndarɛ? Bala, n y'a mɩsɩrbaa bɔ durnya ʊ. ");
INSERT INTO bib_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiyopii gʊaa bɩ n a hɩ Filipi m, a ʊ: «Nka wosolɛsinnɩsorazaa bɩ n n'a mim dɩndarɛ? K'ɩ hɩ m m. A hɔ an n'a dɩndam gɛɛ, gʊaa vanta hɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipi n a lɛ gʊ, an zu Wosoci bɩ meerbaa b'ʊ, an Yeezuu lemim nyɩnta bɩ hɩ m. ");
INSERT INTO bib_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kʊ ŋn'ɩ tam bɩ, ŋ yaa hi ku, Etiyopii gʊaa bɩ n a hɩ, a ʊ: «Ba hi m na. Bɔ n n'a tam mɔɔ m tolle kʊ m bɩ batɛm si?»  ");
INSERT INTO bib_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipi n a hɩ m, a ʊ: «K'ɩbɩɩ sɩra ka kan ɩ heer kɩ haay, ɩbɩɩ ɩ da ma ɩ batɛm si.» Gʊaa bɩ n a nyɩ bɔ n'ʊ, a ʊ: «Mɔɔ sɩra ka, mɔɔ ʊ: Yeezuu Krista bɩ, Woso Nyɩ m.» ");
INSERT INTO bib_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","A n lɛ ka, n nɩ tɛrkʊ bɩ da jɩm ʊ. Filipi kan Etiyopii gʊaa bɩ kɩ, ŋ hɩɩya haay gasʊ hi b'ʊ, Filipi n batɛm ka ʊ. ");
INSERT INTO bib_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kʊ ŋ bɔ hi bɩ nɔ ʊ bɩ, Sɛnt-Ɛspri Filipi gaa an cenim, Etiyopii gʊaa bɩ n a ya, an n'a yɩrɛ y, an a zaa sa kan heernyɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kʊ Filipi nɩ, a yɩ n yaa ʊ Azɔttɩ kʊ ʊ, an nɩ lemim nyɩnta bɩ pa dam kʊrɔ haay ʊ an nɩ cenim, an nɩ tam Sezaree kʊ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sol k'a gɔɔta an nɩ fɩr kam Zuuba karɩndanyɩnɔ wɔɔ ma, a lɛ n taa k'a ŋ zɩnzɛ bɩ, a ta wosocɛmannɩbər jɩtaarɛ bɩ zi, ");
INSERT INTO bib_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","an aa yɛ han, k'an ciro ba Damas zɩɩfʊrɔ sokʊmacɛrɔ wɔɔ minto, k'a yaa gʊɔɔ yɩ, ŋn'ɩ zum zaa daa b'ʊ, kʊ lʊ m gɛɛ yar nɩ, k'a nyasʊ a sur, a bʊr m Zerizalɛm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","A zaa sa, an nɩ tarɛ, an aa a zɔ Damas ma. Lɛɛm bɩ, lɛɛgure a to mim ʊ, an yɔ, an a ku ra. ");
INSERT INTO bib_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","A n a do tara ʊ, an a to, an leer ma, an n'a hɩrɛ, a ʊ: «Sol, Sol, bɔ minto, ɩ nɩ fɩr kam mɔɔ ma?» ");
INSERT INTO bib_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","A n a nyɩ bɔ ʊ, a ʊ: «Nka n'ɩbɩɩ nɩ, Zuuba?» «Mɔɔ m Yeezuu, gʊaa k'ɩbɩɩ nɩ fɩr kam ma bɩ. ");
INSERT INTO bib_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Bɩ, wuti, ɩ gasʊ tara nɔ ʊ b'ʊ, n hɔ k'ɩbɩɩ ɩ ga m, ɩ ba bɩ hɩrɛ ɩbɩɩ m.» ");
INSERT INTO bib_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Gʊɔɔ kʊ ŋ zu kʊ ʊ kan kɩ rɔ wɔɔ jɩm, dabɔʊ bɩ n a ka, ŋ n a dɔ kʊ bɔ an n'a hɩrɛ y. Ŋ yɩ leer bɩ mam, bɩ ŋ bɩr gɔsɩ yɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol n wuti tara ʊ b'ʊ, baa kan a mɩnyaa gaa ra bɩ kɩ haay, a bɩr lɛɛ yɩrɛ y. A zukuuzannɔ wɔɔ n a gaa a wɔ ma, ŋnɩ gasʊ m Damas ʊ. ");
INSERT INTO bib_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A n gɔɔta b'ʊ kan mɩm war bɩ kɩ dɔmɩm kaakʊ, a n hɔsɩ bɩ, b'a n hi mi sɔ y. ");
INSERT INTO bib_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Karɩndanyɩ deem ɩ nyɩnta Damas ʊ b'ʊ, a tɔ m Ananɩyas. Zuuba n a bir hɔhɩnkarɛ nɔ ʊ: «Ananɩyas!» A n a nyɩ bɔ ʊ, a ʊ: «Zuuba, ba mɔɔ n na!» ");
INSERT INTO bib_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Zuuba n a ya, an a hɩ, a ʊ: «Ɩ zaa kʊ n n'a birm ‹Zaa tɩrga› bɩ sa, ɩ ta Zidas har ʊ, ɩ gʊaa kʊ n n'a birm Sol bɩ laaka da. Tarsɩ gʊaa m. A ɩ b'ʊ, an nɩ yaa dam, ");
INSERT INTO bib_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","a gʊaa k'a tɔ m Ananɩyas bɩ yɩ hɔhɩnkarɛ nɔ ʊ, an gasʊ, an a wɔ ka ra k'a mɩm n lɛɛ yɩ.» ");
INSERT INTO bib_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananɩyas n a nyɩ bɔ ʊ, a ʊ: «Zuuba, mɔɔ ma mɩŋŋa, gʊɔɔ nɩ gʊaa naa do mim dɩndam, ŋn'a zibəəro bʊnyaarɔ k'a ŋ ba ɩbɩɩ gʊɔɔ wɔɔ m bɩ mim dɩndam sɔ Zerizalɛm nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Bɩ, wosocɛmannɩbənno jɩtannɔ wɔɔ zaa ka ʊ an bʊr naa ʊ, k'a bɩ gʊɔɔ haay kʊ ŋ nɩ yaa darɛ ɩbɩɩ tɔ ma rɔ wɔɔ sur.» ");
INSERT INTO bib_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bɩ, Zuuba a hɩ m, a ʊ: «Ta bala, gʊaa naa do makra hɔ m, mɔɔ n a bɔ ʊ k'an mɔɔ tɔ hɩ kɩfɩɩrɔ kan cinno kɩ, Israyɛl zannɔ kɩ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Bɩ, mɔɔ mɩŋŋa fɩryɩrɛ do haay k'a n'a yɩm mɔɔ tɔ minto bɩ hɩnkam nɩ.» ");
INSERT INTO bib_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananɩyas n ta, an aa gasʊ har ʊ b'ʊ, an a wɔrɔ ka ra, an n'a hɩrɛ, a ʊ: «M danyɩ Sol, Zuuba Yeezuu niŋŋə k'a hɩnka ɩbɩɩ m, ɩ zaa sa, ɩ nɩ zɛm b'ɩ mɔɔ nyɔɔ, kʊ m b'a ka k'ɩ mɩm n lɛɛ yɩ, kʊ Sɛnt-Ɛspri n'ɩbɩɩ heer han.» ");
INSERT INTO bib_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Lɛɛm bɩ, bɔ a kʊ ʊ ɩ ʊ zɔ kapra y'a to a mɩm ʊ an sur tara ʊ, a mɩm nɩ lɛɛ yɩm. A n wuti, an batɛm si. ");
INSERT INTO bib_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Bɩ, Sol k'a hɔbɩrɛ bɩ bɩ, a a ya, an paŋŋa yɩ. A gɔɔta an dɔmɩnnɔ ba kan karɩndanyɩnɔ kʊ ŋ nɩ Damas nɔ ʊ rɔ wɔɔ kɩ poore, ");
INSERT INTO bib_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","bɩ, a a hɩ zɩɩfʊrɔ sokʊmacɛrɔ wɔɔ ʊ lɛɛm, a ʊ Yeezuu bɩ Woso Nyɩ m. ");
INSERT INTO bib_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Gʊɔɔ haay kʊ ŋ n'a tʊr kam ma rɔ wɔɔ zɛ kədə, ŋn'a hɩrɛ, ŋ ʊ: «Gʊaa naa do bɛɛ nyɩnta an nɩ fɩr kam gʊɔɔ kʊ ŋ nɩ yaa dam tɔ naa do minto Zerizalɛm ʊ rɔ wɔɔ ma bɩ ra? Bʊr bɛɛ a ʊ tɔkkɛ k'a bɩ ŋ gʊr, a ŋ sur a ta ŋ nɩ wosocɛmannɩbənno jɩtannɔ wɔɔ zi ra?» ");
INSERT INTO bib_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Bɩ, Sol paŋŋa y'a dam la, an nɩ bʊr m zɩɩfʊrɔ kʊ ŋ nɩ Damas ʊ b'ʊ rɔ wɔɔ ra kan a meerbaa bɩ kɩ, an n'a hɩrɛ, a ʊ: Yeezuu bɩ, a m *Krista. ");
INSERT INTO bib_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","K'a maasɩrɛ ba bɩ, zɩɩfʊrɔ wɔɔ duro a dɩnda kan kʊ kɩ, k'a Sol zɛ k'an ga. ");
INSERT INTO bib_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sol n hɔ kʊ ŋ ʊ k'a ba bɩ dɔ. Ŋ nɩ dɔ tara bɩ cɛlɛrɔ wɔɔ ma sinuu ʊ kan gunuu ʊ kɩ, k'a a da ma, a ku a zɛ. ");
INSERT INTO bib_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bɩ, gunuu deem ʊ, karɩndanyɩnɔ wɔɔ a da kasɩ ʊ, ŋn'a busu, ŋn'a zer bar m pəŋŋə bɩ kur. ");
INSERT INTO bib_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol k'a lee ku Zerizalɛm ʊ bɩ, a a ŋʊa k'a a zɛ kʊ ra kan karɩndanyɩnɔ wɔɔ kɩ. Bɩ, ŋ haay ɩ nyi bam nɩ, bala ŋ n yɛ, ŋn'a si paan… karɩndanyɩ y. ");
INSERT INTO bib_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas n a gaa, an ta m kristazibəəzannɔ wɔɔ zi, an Zuuba k'a hɩnka m hɔ niŋŋə zaa bire ʊ bɩ dɩnda ŋ nɩ, kan meerbaa niŋŋə k'a ba bɩ kɩ. A Yeezuu tɔ dɩnda Damas ʊ kan sɩra kɩ. ");
INSERT INTO bib_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Bɩ kur kɛɛrɛ bɩ, Sol ɩ minkarɛ ŋ nɩ, an nɩ zum kʊ ʊ kan ŋ kɩ Zerizalɛm ʊ, an nɩ Zuuba tɔ hɩm kan nyɛɛsʊm kɩ. ");
INSERT INTO bib_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A tɩr kan zɩɩfʊrɔ kʊ ŋ nɩ grɛkkɩ lemim hɩm nɔ wɔɔ kɩ, ŋn'ɩ bɩr bɩsɩ kam kan kʊ kɩ. Brɔɔ n bɔkarɛ ŋn'a kam ma k'a zɛ gər. ");
INSERT INTO bib_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Danyɩnɔ wɔɔ kʊ ŋ naa ma bɩ, ŋ y'a gaa, ŋnɩ ta m Sezaree ʊ, b'ʊ bɩ ŋ y'a ka, an ta Tarsɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Sɩrakarɛzannɔ kʊ ŋ nɩ Zidee ʊ kan Galilee kɩ, Samarii kɩ ʊ rɔ wɔɔ ɩ mɩsɩrbaa bam kan laafɩɩ kɩ, ŋn'ɩ paŋŋa yɩm, ŋn'ɩ tam kan Zuuba nyibəə kɩ, Sɛnt-Ɛspri paŋŋa minto y'a ka, ŋ lɛ n n'a dam la. ");
INSERT INTO bib_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pɩyɛɛr k'a nɩ bɩrm lɛɛ haay ʊ bɩ, a ta wosogʊɔɔ kʊ ŋ nɩ Lida ʊ rɔ wɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A n aa gʊaa yɩ b'ʊ a tɔ m Enee. Yɩnyar a ʊ an nɩ wʊtam kan mɛgarɛ kɩ a gargʊ burə ʊ dɔɔraa sinnyə. ");
INSERT INTO bib_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pɩyɛɛr n a hɩ m, a ʊ: «Enee, Yeezuu Krista y'ɩ waam. Wuti, ɩ ɩ wʊtarahɔ bɩ gʊr ɩ zi m.» A n wuti lɛɛm sɔ. ");
INSERT INTO bib_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lida gʊɔɔ wɔɔ haay kan Sarɔɔn kʊ bɩncɛ fapɩda zannɔ wɔɔ kɩ bɩ kʊ ŋ naa yɩ bɩ, ŋ y'a bɔ a taam, ŋnɩ zu Zuuba ʊ. ");
INSERT INTO bib_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lʊ ɩ nyɩnta ʊ Zoppee ʊ, karɩndanyɩ m, a tɔ m Tabɩta, a lɛ taa k'a hɩ, a ʊ: ‹Dɔrkas› grɛkkɩ lemim m. (A jɩ k'a hɩ a ʊ: ‹Mee›). A ziro mɩŋŋɔɔ ba gʊta, an n'a dam cicirzannɔ han sɔ. ");
INSERT INTO bib_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bala, dɔmɩnnɔ wɔɔ duro ʊ, a yaaba zɛ, an ga. Kʊ ŋ y'a gər bɩ zʊr, ŋn'a nya bɩ, ŋ yaa a wʊta cɛ nɔ k'a nɩ mim ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida k'an jɩnjɛɛm Zoppee ma bɩ, karɩndanyɩnɔ wɔɔ a ma ŋ ʊ, Pɩyɛɛr ta b'ʊ. Ŋ nɩ gʊɔɔ yaarɔ hɩɩyɔɔ nyɔɔ ma kʊ ŋ n'aa a bir ncɩnaaʊ: «Ɩ tɔ ʊ ɩ wɔɔ zɛ ʊ dɩɩtaa-dɩɩtaa.» ");
INSERT INTO bib_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Lɛɛm bɩ, Pɩyɛɛr wuti, an zu kʊ ʊ kan ŋ kɩ. K'a yaa lee ku bɩ, ŋ y'a ka an ta cɛ k'a nɩ mim ʊ b'ʊ, zonno wɔɔ haay n jɩm a lɛɛ, ŋn'ɩ nyi karɛ. Ŋ nɩ huuro kan gɔbgarɔ kɩ kʊ Dɔrkas nyɩnta an nɩ bam dɔmɩm k'a nyɩnta ʊ kan ŋ kɩ rɔ wɔɔ hɩnka m. ");
INSERT INTO bib_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pɩyɛɛr n a ka gʊaa haay n bɔ, an sʊnta, an yaa da. A n a wusigə an a nya gər bɩ rɛ, an a hɩ, a ʊ: «Tabɩta, wuti!» A n a mɩm gʊ, k'a Pɩyɛɛr yɩ bɩ, a wuti an nyɩnta. ");
INSERT INTO bib_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pɩyɛɛr n a wɔ dɔ rɛ, an wuti an jɩm. A n wosogʊɔɔ wɔɔ bir kan zonno wɔɔ kɩ, an a hɩnka ŋ nɩ mɩsɩr. ");
INSERT INTO bib_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Zoppee zannɔ haay a ma, gʊɔɔ gʊta n sɩra ka Zuuba ʊ. ");
INSERT INTO bib_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pɩyɛɛr gɔɔta an maasɩrɛ ba Zoppee ʊ, zappa kʊ n n'a birm Sɩmɔɔn bɩ har ʊ. ");
INSERT INTO bib_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Gʊaa ɩ nyɩnta Sezaree ʊ, a tɔ m Kɔrnɛy. Sʊrdaa zɔrɔ lɛɛzaa m. Sʊrdaarɔ zɔrsɔddɩ zɛkʊra kʊ n n'a birm «Italik» bɩ barla an ta ʊ. ");
INSERT INTO bib_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Gʊaa m an sɩra ka Woso ʊ paan…, an nɩ nyi bam Woso m kan a har zannɔ kɩ haay. A y'a dam zɩɩfʊrɔ cicirzannɔ gʊtɔɔ han, an nɩ yaa dam Woso m dɔmɩm haay. ");
INSERT INTO bib_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Hindeem ʊ, wakatɩ kaakʊ zeezi yirbəə n bɩ, a Woso malɛɛka yɩ paan… Makra nɔ ʊ, an gasʊ a har ʊ, an n'a birm, a ʊ: «Kɔrnɛy!» ");
INSERT INTO bib_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔrnɛy n dɩga ma sɩɩ…, dabɔʊ n a nyasʊ, an a nyɩ bɔ ʊ, a ʊ: «A lɔ, Zuuba?» Malɛɛka bɩ n a hɩ m, a ʊ: «Ɩbɩɩ yaadarɛrɔ kan ɩ zibəəro mɩŋŋɔɔ k'ɩbɩɩ ba rɔ wɔɔ kɩ minto, Woso a hɔɔn da ɩbɩɩ ma. ");
INSERT INTO bib_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bɩ, naa ma bɩ, gʊɔɔ nyɔɔ Zoppee ʊ kʊ ŋ n'aa Sɩmɔɔn, gʊaa niŋŋə kʊ n so ra, n n'a tɔ ka Pɩyɛɛr bɩ gaa ŋnɩ bʊr m. ");
INSERT INTO bib_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Zer a ʊ Sɩmɔɔn vanta k'an zappa bɩ har ʊ higʊta lɛ ra.» ");
INSERT INTO bib_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Malɛɛka k'a meer ba kan kɩ bɩ k'a nyaam bɩ, Kɔrnɛy a zibəənyɩnɔ bir hɩɩya kan a sʊrdaarɔ gʊaa deem k'a sɩra ka Woso ʊ paan… bɩ kɩ, ");
INSERT INTO bib_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","an mim haay k'a ba bɩ dɩnda ŋ nɩ, an ŋ nyɔɔ Zoppee ʊ. ");
INSERT INTO bib_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bɩ dɔ k'a mɛ bɩ, kʊ ŋ zaa sa ŋn'ɩ tam bɩ, ŋ y'a zɔ kʊ bɩ ma. Bɩ ma bɩ, Pɩyɛɛr der cɛ bɩ bɛŋŋʊ ra k'a yaa da. Nyɩnta a ʊ sinuu zeezi. ");
INSERT INTO bib_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Bɩ jɛ ʊ, nɔ a nyasʊ, an nyɩnta an a ŋʊa k'a hɔbɩrɛ bɩ. N nɩ hɔbɩrɛ bam k'a ka ʊ. Lɛɛm bɩ, a hɔhɩnkarɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A n brama yɩ an a gʊ, hɔ niŋŋə n a to brama, an bɔ kʊ ʊ kan pɛɛra gʊta kɩ, n n a bɔ kʊ ʊ, an b'a cɩnta tara ʊ. ");
INSERT INTO bib_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A nɔ ʊ bɩ, hɔmɩsɩr do haay n ta ʊ: hɔ gam si, bɔɔ n n'a gaatam tara ʊ, kan bɔɔ n nɩ werm brama rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Leer n a hɩ m, a ʊ: «Pɩyɛɛr, aya, ŋ zɩnzɛ, ɩ ŋ bɩ!» Pɩyɛɛr n a nyɩ bɔ ʊ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","«Ayo Zuuba, mɔɔ mɩsɩrbaa nɔ ʊ, mɔɔ n hɔ bʊnyaa kan dintim hɔ kɩ bɩ cɩna y. Wɔɔ do sɩhɔ m.» ");
INSERT INTO bib_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Leer n a ya, an a hɩ m a hɩɩya hɔ ma, a ʊ: «Hɔ kʊ Woso dintim gʊ ma bɩ, ɩ b'a bir dintim hɔ y.» ");
INSERT INTO bib_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Naa do ba gallɛm kaakʊ, hɔ bɩ n a bɔ, an ta brama lɛɛm. ");
INSERT INTO bib_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pɩyɛɛr n a mɩŋŋa lar a hɔɔn ʊ gallɛm hɔka hɔhɩnkarɛ naa do jɩ ma. Lɛɛm bɩ, Kɔrnɛy zibəəzannɔ kʊ ŋ laaka da jɩsa kan bɩsɩ kɩ Sɩmɔɔn har ma rɔ wɔɔ lee ku hallɛ ma. ");
INSERT INTO bib_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ŋ nɩ bir darɛ, k'a a dɔ kʊ Sɩmɔɔn kʊ n so ra, n n a tɔ ka Pɩyɛɛr bɩ, zer a ʊ har bɩ do ʊ gɛ. ");
INSERT INTO bib_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pɩyɛɛr n gɔɔta an n'a hɔɔn dam hɔhɩnkarɛ k'a a yɩ bɩ ma. Sɛnt-Ɛspri n a hɩ m, a ʊ: «Ba gʊɔɔ kaakʊrɔ n n'a karɛ ɩ ma na. ");
INSERT INTO bib_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Zer zɔɔ-zɔɔ ɩ zaa sa kan ŋ kɩ, ɩ bɩ bɩsɩ ka y. Bala, mɔɔ yɩ ŋ nyɔɔ.» ");
INSERT INTO bib_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pɩyɛɛr n zer, an gʊɔɔ wɔɔ zɛ ʊ, an a hɩ, a ʊ: «Mɔɔ ba n nɩ. Mɔɔ awɔɔ n'a karɛ m ma bɩ. Bɔ minto y'a ka awɔɔ n bʊr naa ʊ?» ");
INSERT INTO bib_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ŋ n'a nyɩ bɔ ʊ, ŋ ʊ: «Sʊrdaa zɔrɔ lɛɛzaa Kɔrnɛy k'an gʊaa tɩrga, an nɩ nyi bam Woso m, a tɔ n nɩ lɛbɔʊrɛ yɩm zɩɩfʊrɔ do barla bɩ, Woso malɛɛka a hɩnka m, a ʊ, an a ka, k'ɩbɩɩ m bʊr a har ʊ, k'a b'a tʊr ka ɩ ma.» ");
INSERT INTO bib_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pɩyɛɛr n ŋ si, an a ka ŋnɩ gasʊ, an wʊtaʊrɛcɛ ka ŋ ʊ. Bɩ, dɔ k'a mɛ bɩ, a cem kan ŋ kɩ, kan Zoppee danyɩnɔ gɔsɩnnɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ŋ lee ku Sezaree ʊ, dɔmɩm hɩɩya hinni ʊ. Kɔrnɛy n a banka, an nɩ dɔrɛ ŋ ma. A a do gʊɔɔ bir kan a gʊaasɩbɔɔ paan…rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Dɔmɩm kʊ Pɩyɛɛr lee ku ma bɩ, Kɔrnɛy wuti, an a zɛ ʊ, an sʊnta a taa, an a da ʊ. ");
INSERT INTO bib_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pɩyɛɛr n a wɔ dɔrɛ, an a busu brama, an n'a hɩrɛ, a ʊ: «Wuti! Gʊaa m mɔɔ m sɔ.» ");
INSERT INTO bib_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ŋ n sʊʊra ba kan kʊ kɩ, ŋn'ɩ gasʊm. K'a bɩ sʊr gʊɔɔ ma, ŋn'a zɛ kʊ ra gʊta bɩ, ");
INSERT INTO bib_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","a a hɩ, a ʊ: «Awɔɔ dɔ a ʊ a cisə ba kan zɩɩfʊ kɩ k'an a zɛ kʊ ra kan saana kɩ, gɛɛ an gasʊ a har ʊ ra! Bɩ, Woso a hɩnka mɔɔ m, a ʊ, mɔɔ n m ga m, kʊ m dɩga gɔsɩ ma, m a ba hɔ bʊnyaa gɛɛ dintim zaa y. ");
INSERT INTO bib_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Bɩ y'a ka, k'ɩbɩɩ mɔɔ bir bɩ, mɔɔ n bɩsɩ ka zɛrɛ ma y. Bɩ naa ma bɩ, mɔɔ lɛ n taa kʊ m m birle bɩ jɩ dɔ.» ");
INSERT INTO bib_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔrnɛy n a nyɩ bɔ ʊ, a ʊ: «A dɔmɩm kaakʊ her, ncɩnaaʊ nyi m, mɔɔ n nɩ yaa darɛ m har ʊ yirbəə wakatɩ kaakʊ ma. Lɛɛm bɩ, gʊaa n a hɩnka mɔɔ lɛɛ, a huuro n nɩ gum, ");
INSERT INTO bib_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","an a hɩ mɔɔ m, a ʊ: Kɔrnɛy, n y'ɩbɩɩ yaadarɛ si, bɩ Woso ɩbɩɩ ganwʊrɛrɔ k'ɩbɩɩ ŋ ka cicirzannɔ ʊ rɔ wɔɔ tɔ da a nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Bɩ minto bɩ, gʊaa nyɔɔ Zoppee ʊ k'an aa gʊaa k'a tɔ m Sɩmɔɔn n nɩ so ra, n n a tɔ ka Pɩyɛɛr bɩ bir, k'an bʊr naa ʊ. Zer a ʊ Zoppee zappa k'a tɔ m Sɩmɔɔn bɩ har ʊ, higʊta lɛ ra. ");
INSERT INTO bib_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Bɩ y'a ka, mɔɔ n nyɔɔ da lɛɛm kʊ n n'ɩbɩɩ bir, ɩbɩɩ yɛ sɔ, k'ɩ bʊr wɔɔ zi. Ba wɔɔ n'ɩbɩɩ taa naa ʊ haay na, k'ʊ ʊ tʊr ka hɔ haay kʊ Zuuba a hɩ ɩbɩɩ m k'ɩ hɩ wɔɔ m bɩ ma.» ");
INSERT INTO bib_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pɩyɛɛr n bɔkarɛ, an a lɛ gʊ, an a hɩ, a ʊ: «Sɩra m, mɔɔ dɔ kɛɛrɛ mɔɔ ʊ, Woso bɩr gʊɔɔ jirə bɔrɛ y. ");
INSERT INTO bib_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Bɩ do haay nɔ ʊ, gʊaa k'a nɩ nyi bam nɩ, an nɩ tɩrgabaa zi bam bɩ, a y'a sire a jɩr ʊ. ");
INSERT INTO bib_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Woso a mɩŋŋa lemim nyɔɔ Israyɛl zannɔ ma, an Yeezuu Krista k'an gʊɔɔ haay Zuuba bɩ laafɩɩ lemim nyɩnta bɩ hɩ. ");
INSERT INTO bib_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Awɔɔ hɔ niŋŋə k'a ba Zidee kʊ haay ʊ bɩ dɔ. A sɩŋŋɩda a sa Galilee ʊ Zaan batɛm lemim hɩrɛ bɩ jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nazarɛtɩ Yeezuu bɩ do, awɔɔ dɔ a ʊ, bɩ Woso a bɔ ʊ, an Sɛnt-Ɛspri kan a paŋŋa kɩ zer a mim ʊ. A bɔ lɛɛ haay ʊ, an mɩŋŋabaa zi ba, an nɩ gʊɔɔ kʊ ŋ nɩ Sʊtaana lɔmbaa nɔ ʊ rɔ wɔɔ waam, bala, Woso ɩ kan kɩ. ");
INSERT INTO bib_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","A zibəə haay k'a a ba zɩɩfʊrɔ kʊ ʊ, kan Zerizalɛm kɩ ʊ bɩ, a kasɛtɩzannɔ m wɔɔ m. Ŋ y'a zeŋŋə gɔ ma, ŋn'a zɛ gər. ");
INSERT INTO bib_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Woso a mɩm bɔ ʊ a dɔmɩm kaakʊ hɔ ma, an lɛ ka ʊ k'an a taʊrɛ hɩnka. ");
INSERT INTO bib_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Gʊaa haay bɛɛ a a hɩnka nɩ y, a hɩnka a ʊ kasɛtɩzannɔ kʊ Woso lɛɛ ka an ŋ bɔ ʊ rɔ wɔɔ m, wɔɔ k'ʊ hɔ bɩ, ʊ hɔ mi kan kɩ a mɩmbɔʊrɛ kur gəəno bire ʊ rɔ wɔɔ. ");
INSERT INTO bib_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","A lɛ ka wɔɔ ʊ kɛɛrɛ k'ʊ a hɩ do bɩ m, k'ʊ a kasɛtɩ naa do ka, ʊ ʊ: A mɩŋŋa Woso a bɔ ʊ kan nyɩnta mɩsɩɩrɔ kan gəəno kɩ dʊdɔkər. ");
INSERT INTO bib_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","A mɩŋŋa wosolɛsinnɩsorazannɔ n'a kasɛtɩ kam, ŋ ʊ: Gʊaa haay k'a sɩra ka ʊ bɩ y'a mimbʊnyaarɔ sugur yɩrɛ, a tɔ ma.» ");
INSERT INTO bib_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kʊ Pɩyɛɛr gɔɔta an nɩ meer bɩ bam bɩ, Sɛnt-Ɛspri bɩ zer gʊaa haay k'a nyɩnta an n'a tʊr kam meerbaa bɩ ma rɔ wɔɔ ra. ");
INSERT INTO bib_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Zɩɩfʊrɔ sɩrakarɛzannɔ kʊ ŋ Pɩyɛɛr da zaa ʊ rɔ wɔɔ zɛ kədə, kʊ ŋ Sɛnt-Ɛspri ganwʊrɛ yɩ an zer do vantɔɔ gʊɔɔ gʊta ra sɔ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ŋ gʊɔɔ wɔɔ duro ma, ŋn'ɩ meer bam do y'a hʊnhɔ lemim m, ŋn'a lɛ bɔm Woso ʊ. Pɩyɛɛr n a ya, an a hɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Gʊaa y'a dam ma, an a ta tolle, a ʊ, ŋ bɩ batɛm ka hi m gʊɔɔ nɔɔn duro ʊ ra? Ŋ y'a ba, am wɔɔ hɔ bɩ m, ŋnɩ Sɛnt-Ɛspri yɩ ra!» ");
INSERT INTO bib_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","A n lɛ ka, kʊ n nɩ batɛm ka ŋ ʊ Yeezuu Krista tɔ ma, ŋn'a yɛ han k'a n a ya, an gɔɔta kan a kɩ dɔmɩm poore nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kristazibəəzannɔ kan danyɩnɔ wɔɔ kɩ kʊ ŋ nyɩnta Zidee ʊ rɔ wɔɔ a ma ŋ ʊ, do vantɔɔ gʊɔɔ wɔɔ Woso lemim bɩ si kɛɛrɛ. ");
INSERT INTO bib_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kʊ Pɩyɛɛr a bɔ an ta Zerizalɛm ʊ bɩ, zɩɩfʊrɔ sɩrakarɛzannɔ wɔɔ a sɩŋŋɩda sa, ŋn'ɩ bɩsɩ kam kan kɩ, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Ɩbɩɩ gasʊ gʊɔɔ kʊ ŋ n gasʊ baŋŋʊ ʊ rɔ wɔɔ zi, ɩ hɔbɩrɛ bɩ kan ŋ kɩ!» ");
INSERT INTO bib_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pɩyɛɛr n a bɔ, an mim bɩ sa a jɩ ma deem-deem, an n'a hɩrɛ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Nyɩnta mɔɔ ʊ Zoppee kʊ nɔ ʊ, m nɩ yaa dam, mɔɔ m hɔhɩnkarɛ yɩ. Hɔ niŋŋə y'a to brama, an nɩ zerm, an bɔ kʊ ʊ kan pɛɛra gʊta kɩ, n n a bɔ kʊ ʊ, an bɩ lee ku mɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kʊ mɔɔ nɩ dɩgam ma sɩɩ… bɩ, mɔɔ tara burə hɔɔ yɩ, ŋ gam n si-si, poohɔɔ, bɔɔ n'a gaatam nɔ, kan bɔɔ nɩ werm brama rɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mɔɔ leer ma, an n'a hɩm mɔɔ m, a ʊ: Pɩyɛɛr, wuti, ɩ ŋ zɩnzɛ, ɩ ŋ sʊ. ");
INSERT INTO bib_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mɔɔ n a hɩ, mɔɔ ʊ: Fɩɩgaa Zuuba, mɔɔ mɩsɩrbaa nɔ ʊ, hɔ bʊnyaa gɛɛ dintim hɔ n gasʊ mɔɔ lɛ ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Leer bɩ n a ya, an a to brama, an n'a hɩm mɔɔ m a hɩɩya hɔ ma, a ʊ: Hɔ kʊ Woso dintim gʊ ma bɩ, ɩ b'a bir dintim hɔ y. ");
INSERT INTO bib_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Naa do ba gallɛm kaakʊ, a haay n a bɔ, an ta brama. ");
INSERT INTO bib_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Lɛɛm bɩ, gʊaa kaakʊ a hɩnka har kʊ wɔɔ n ta ʊ b'ʊ. Ŋ bɔ ŋ y'a ʊ Sezaree ʊ, ŋnɩ ŋ nyɔɔ mɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Sɛnt-Ɛspri n a hɩ mɔɔ m, a ʊ, m ta kan ŋ kɩ, bɩ, m bɩ bɩsɩ ka y. Danyɩnɔ sɔrdɩrɔ nɔɔn duro mɔɔ da zaa ʊ, wɔɔ n aa gasʊ gʊaa kʊ n y'a hɩ ma bɩ har ʊ. ");
INSERT INTO bib_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","A n malɛɛka bɩ k'a a hɩnka hɔ niŋŋə a har ʊ bɩ sa, an a dɩnda wɔɔ m, an n'a hɩrɛ, a ʊ: Gʊaa nyɔɔ Zoppee ʊ k'an a ka kʊ Sɩmɔɔn kʊ n so ra, n n a tɔ ka Pɩyɛɛr bɩ n bʊr. ");
INSERT INTO bib_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","A minno kʊ ŋ n'a kam ɩbɩɩ n bʊmbɔrɛ yɩ kan ɩ har gʊɔɔ kɩ bɩ dɩndarɛ ɩbɩɩ m. ");
INSERT INTO bib_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kʊ mɔɔ meerbaa bɩ sa bɩ, Sɛnt-Ɛspri zer ŋ la, amb'a a ba wɔɔ m a sɩŋŋɩda ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mɔɔ hɔ kʊ Zuuba a hɩ bɩ tɔ da m nɔ ʊ, a ʊ: Zaan hi batɛm ka denter, b'awɔɔ, awɔɔ batɛm sim Sɛnt-Ɛspri nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kʊ Woso ganwʊrɛ deem ka gʊɔɔ nɔɔn duro ʊ ncɩnaaʊ amb'a a ka wɔɔ ʊ, dɔmɩm kʊ wɔɔ sɩra ka Zuuba Yeezuu Krista ʊ bɩ, nka m mɔɔ m kʊ m m ta Woso m tolle k'a b'a zi ba?» ");
INSERT INTO bib_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Naa k'a a hɩ bɩ, gʊɔɔ wɔɔ heer a da, ŋn'a lɛ bɔm Woso ʊ, ŋ ʊ: «Woso heerlʊrlɛ k'a nɩ mɩsɩrbaa kam bɩ ka do vantɔɔ haay ʊ sɔ.» ");
INSERT INTO bib_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Gʊɔɔ kʊ ŋ y'a si, ŋnɩ hɩsɩga da fɩr kʊ ŋ y'a yɩ Etɩyɛnnɩ garɛ kur bɩ, ŋ ta Fenisii ʊ kan Siipɩr kɩ, Antɩyɔs kɩ ʊ. Ŋ bɩr Woso lemim bɩ pa dam gɔsɩ vanta m, kʊ zɩɩfʊrɔ wɔɔ bɛɛ bala y. ");
INSERT INTO bib_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bɩ, Siipɩr zannɔ kan Sirɛnnɩ zannɔ kɩ gɔsɩnnɔ yɩ ŋ barla, kʊ ŋ lee ku Antɩyɔs ʊ, ŋnɩ Zuuba Yeezuu lemim nyɩnta bɩ pa da grɛkkɩ zannɔ wɔɔ m sɔ. ");
INSERT INTO bib_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Zuuba paŋŋa nyɩnta an nɩ kan ŋ kɩ, hallɩ gʊɔɔ kʊ ŋ sɩra ka ŋn'a bɔ ŋnɩ zu Zuuba ʊ rɔ wɔɔ lɛ n'a dam la gʊta. ");
INSERT INTO bib_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Zerizalɛm sɩrakarɛzannɔ wɔɔ mim naa do dɩndarɛ ma, n n Barnabas nyɔɔ Antɩyɔs ʊ. ");
INSERT INTO bib_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","K'a lee ku, an Woso barka bɩ yɩ, an nɩ zi bam bɩ, a heer yɩ nyɩnta, an ŋ dʊndɔ haay, kʊ ŋ heer n gɔɔta an bɩr kan Zuuba kɩ kɔɔkɔɔ. ");
INSERT INTO bib_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nyɩnta a ʊ gʊaa tɩrga, Sɛnt-Ɛspri n a han kan sɩrakarɛ kɩ. Gʊɔɔ gʊta n zu Zuuba zaa ʊ. ");
INSERT INTO bib_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas ta Tarsɩ ʊ k'a yaa a ka Sol ma. ");
INSERT INTO bib_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","A n aa a yɩ, an a gaa, an bʊr m Antɩyɔs ʊ. Ŋ nɩ dɔɔraa deem ba kan kʊ kɩ, ŋn'ɩ zi bam sokʊma bɩ do ʊ, ŋn'ɩ hɔ dɩndam gʊɔɔ gʊta m. Antɩyɔs ʊ n lɛɛ ka ʊ, n nɩ karɩndanyɩnɔ wɔɔ bir kristagʊɔɔ. ");
INSERT INTO bib_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Dɔmɩnnɔ wɔɔ duro ʊ bɩ, wosolɛsinnɩsorazannɔ a to Zerizalɛm ʊ, ŋnɩ ta Antɩyɔs ʊ. ");
INSERT INTO bib_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ŋ gʊaa deem kʊ n n'a birm Agabus bɩ wuti, an a hɩ Sɛnt-Ɛspri paŋŋa m, a ʊ: nɔ gʊta n'a dam tara burə ʊ jilli. A nyɩnta ʊ denter, cir Kloodɩ dɔmɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Karɩndanyɩnɔ wɔɔ n a cɩnta kan kʊ kɩ, gʊaa biyəə kan a wɔhɔ kɩ, k'a nyɔɔ a danyɩnɔ kʊ ŋ nɩ Zidee ʊ rɔ wɔɔ daahan minto. ");
INSERT INTO bib_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bɩ ŋ y'a ba, ŋnɩ Barnabas kan Sol kɩ bɔ ʊ, ŋnɩ ŋ nyɔɔ gʊɔɔgusinno wɔɔ ma kan daahan bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Bɩ ma bɩ, cir *Hɩrɔɔdɩ a ka, ŋnɩ gʊɔɔ gɔsɩnnɔ kʊ ŋ nɩ zum Yeezuu ʊ rɔ wɔɔ gʊr, k'a fɩr ka ŋ ma. ");
INSERT INTO bib_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A a ka, n n Zaan danyɩ Zakkɩ bɩ zɛ kargʊ m. ");
INSERT INTO bib_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","K'a dɩga a zɩɩfʊrɔ wɔɔ heer nyɔɔ mim naa do ma bɩ, a a ya, an a ka, ŋnɩ Pɩyɛɛr nyasʊ. Nyɩnta a ʊ, bur kʊ n n nyʊnyɔɔ da ma *cibsa dɔmɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","K'a a ka, ŋn'a nyasʊ, ŋn'a du lɔnnɔcɛ ʊ bɩ, a a ka sʊrdaarɔ n dɔ ma gʊaa bueeresɔrdɩ, ŋn'a sinsim kʊ m si-si, k'a b'a dʊdɔ ka pakkɩ cenle kur gʊɔɔ lɛɛ. ");
INSERT INTO bib_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Dɔmɩm kʊ Pɩyɛɛr nɩ lɔnnɔcɛ ʊ bɩ, sokʊma bɩ y'a tɔŋ ʊ kan Woso yaadarɛ kɩ kʊsɩ-kʊsɩ a minto. ");
INSERT INTO bib_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","N Pɩyɛɛr kʊsɩ baŋŋarɔ m hɩɩya. A dɔ k'a nɩ mɛm kʊ Hɩrɔɔdɩ n a bɔ bɩ, gum bɩ do ʊ, Pɩyɛɛr ɩ hinceem bam sʊrdaa hɩɩya bire ʊ, sʊrdaarɔ nɩ dɔm lɔnnɔcɛ bɩ lɛ ma. ");
INSERT INTO bib_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Lɛɛm bɩ, Zuuba malɛɛka sʊr zɛ, lɛɛgure n cɛ bɩ han haay. Malɛɛka bɩ n Pɩyɛɛr zɛ pa-pa a boon ma, an a gu, a ʊ: «Wuti zɔɔ-zɔɔ!» Baŋŋarɔ wɔɔ n a hʊnhʊr Pɩyɛɛr wɔrɔ wɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malɛɛka bɩ n a ya, an a hɩ m, a ʊ: «Ɩ hɔsoaʊ bɩ sa, ɩ so ɩ ʊ, k'ɩ ɩ kʊsɔrɔ wɔɔ da ʊ!» A n a ba maam. Malɛɛka bɩ n a ya, an a hɩ, a ʊ: «Ɩ zaba bɩ sa, ɩ da ɩ ra, k'ɩ zu mɔɔ ʊ!» ");
INSERT INTO bib_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pɩyɛɛr n bɔ, an zu a jɛ ʊ. B'a n a dɔ a ʊ, hɔ kʊ malɛɛka b'a ba bɩ, sɩra nɩ y, a ɩ dɩgam ma a ʊ makra awɔɔ yɩ. ");
INSERT INTO bib_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ŋ n lɛɛ ka, ŋnɩ cem lɛɛkarɛ bɩncɛ bɩ han kan a dɔmazannɔ kɩ, ŋn'a ya, ŋnɩ cem a hɩɩya hɔ bɩ han, ŋn'a lee ku pɔyaa cɛlɛ k'a nya kʊ bɩ rɛ bɩ ma. A n a gʊ a zim ŋ lɛɛ. Kʊ ŋ bɔ garga ra bɩ, ŋnɩ ta, ŋn'aa zada bɩ ku, lɛɛm bɩ, malɛɛka b'a gʊ Pɩyɛɛr ma. ");
INSERT INTO bib_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pɩyɛɛr hɔɔn n zer kɛɛrɛ. A n a hɩ, a ʊ: «Naa ma bɩ, mɔɔ dɔ kɛɛrɛ. Sɩra m, Zuuba a malɛɛka nyɔɔ, an bɩ mɔɔ bɔ Hɩrɔɔdɩ wɔ ʊ kan zɩɩfʊrɔ kɩ, kan hɔ haay kʊ zɩɩfʊrɔ wɔɔ a cɩnta k'a ba mɔɔ m bɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","K'a hɔɔn bɩ zer bɩ, a a hʊr, an ta Zaan kʊ n so ra, n n a tɔ ka Markɩ bɩ da Maarii har ʊ. B'ʊ bɩ, gʊɔɔ gʊta nyɩnta b'ʊ, ŋn'ɩ yaa dam. ");
INSERT INTO bib_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","K'a cɛlɛ bɩ zɛ bɩ, Zibəənyɩlʊ k'a tɔ m Rode bɩ bʊr k'a bɩ dɩga a. ");
INSERT INTO bib_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","A Pɩyɛɛr leer dɔ, kan heernyɔɔ kɩ, cɛlɛ bɩ gʊrɛ tɔ bɔ a nɔ ʊ, an a wusigə an bra si, k'a yaa hɩ a ʊ, Pɩyɛɛr bʊr, an nɩ cɛlɛ ma. ");
INSERT INTO bib_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ŋ n a hɩ m, ŋ ʊ: «Ɩbɩɩ mim y'a wusigə ra?» A n gɔɔta, an n'a hɔ bɩ ra, a ʊ sɩra m. Ŋ n a hɩ, ŋ ʊ: A malɛɛka bɛɛ ra? ");
INSERT INTO bib_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pɩyɛɛr n gɔɔta, an nɩ cɛlɛ bɩ zɛm. Ŋ n kɔ ŋn'a gʊ, kʊ ŋ y'a yɩ bɩ, ŋ n zɛ kədə. ");
INSERT INTO bib_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","A n meer ba a wɔ m, a ʊ, ŋnɩ zɛ pi. Hɔ kʊ Zuuba a ba, an a bɔ lɔnnɔcɛ ʊ bɩ, a bɩ jɩsa an n'a dɩndarɛ ŋ nɩ, an b'a nyambʊr, a ʊ: «K'a ta, a yaa hɩ *Zakkɩ m kan danyɩnɔ wɔɔ kɩ.» A n bɔ, an ta bɩncɛ vanta ʊ. ");
INSERT INTO bib_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Dɔmɩrɛ ma bɩ, tatʊr gʊta nyɩnta ʊ sʊrdaarɔ wɔɔ bire ʊ. Ŋ n a dɔ kʊ Pɩyɛɛr a ba lɔ y? ");
INSERT INTO bib_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hɩrɔɔdɩ n a ka, ŋn'a ka ma, bɩ ŋ n a yɩ y. A n a ka, ŋnɩ sʊrdaarɔ wɔɔ lar, an lɛ ka a ʊ, ŋnɩ ŋ zɩnzɛ. Bɩ jɛ ʊ bɩ, Pɩyɛɛr a to Zidee ʊ, an ta Sezaree ʊ, an aa gɔɔta b'ʊ dɔmɩm poore nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hɩrɔɔdɩ heer wuti kan Tiir zannɔ kɩ, Sidɔn zannɔ kɩ. Brɔɔ n a lɛ ba deem, ŋnɩ bʊr k'a b'a yɩ. Ŋ n gʊaasɩbabaa da cirhar dɩgamazaa Blastus ma, ŋn'a zɛ kʊ ra, ŋnɩ bʊr k'a bɩ kʊ ma. Bala, ŋ kʊ bɩ hɔbɩrɛ bɩ, bɔ a nawʊm cir bɩ kʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Dɔmɩm kʊ ŋ y'a bɔ ʊ bɩ k'a a ku bɩ, Hɩrɔɔdɩ a cirbəəhuu da a ra, an nyɩnta duu burə ʊ, an nɩ gʊtabaa meer bam kan gʊɔɔ wɔɔ kɩ, ");
INSERT INTO bib_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ŋn'ɩ zee dam Hɩrɔɔdɩ mim ʊ, ŋ ʊ: «Woso leer n naa, gʊaa hɔ bɛɛ y!» ");
INSERT INTO bib_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Lɛɛm bɩ, Zuuba malɛɛka Hɩrɔɔdɩ zɛ, k'a n a lɛ bɔ Woso ʊ bɩ minto. Mukuno n a bɩ, an ga. ");
INSERT INTO bib_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Dɔmɩm bɩ do ʊ, Woso lemim y'a dam la, karɩndanyɩnɔ wɔɔ lɛ n n'a zum la. ");
INSERT INTO bib_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas kan Sol kɩ kʊ ŋ y'a dɔ, ŋ ʊ, a zi bɩ ba an nya Zerizalɛm ʊ bɩ, ŋ y'a bɔ ŋn'ɩ tam Antɩyɔs ʊ. Ŋ Zaan kʊ n so ra ŋn'a tɔ ka Markɩ bɩ gaa kan a kɩ, ŋnɩ ta m. ");
INSERT INTO bib_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Sokʊma kʊ n y'a cɩnta Antɩyɔs ʊ bɩ, wosolɛsinnɩsorazannɔ ɩ nyɩnta b'ʊ kan karɩnsaambɔɔ kɩ: Barnabas, Sɩmɩnyɔɔ kʊ n n'a birm Nizɛɛr bɩ kɩ, Sirɛnnɩ Lusiyus kɩ, kan cir Hɩrɔɔdɩ Antipas nyɩbaa zukuuzaa Manayɛn kɩ, Sol kɩ. ");
INSERT INTO bib_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hindeem ʊ, kʊ ŋ nɩ yaa dam Zuuba m, ŋn'a lɛ kʊsɩm bɩ, Sɛnt-Ɛspri a hɩ, a ʊ: «K'a Barnabas kan Sol kɩ bɔ ʊ a hɔ, zibəə kʊ mɔɔ ŋ bir ma bɩ minto.» ");
INSERT INTO bib_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kʊ ŋ y'a lɛ kʊsɩ, ŋnɩ yaa da ŋn'a nya bɩ, ŋ y'a wɔ ka ŋ la, ŋnɩ ŋ da zaa ra. ");
INSERT INTO bib_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kʊ Sɛnt-Ɛspri ŋ nyɔɔ bɩ, Barnabas kan Sol kɩ zer Selesii ʊ, ŋnɩ da kɔɔlʊʊ b'ʊ, ŋn'ɩ ta Siipɩr ʊ, kʊ m bɩ, hi m bɩr ma. ");
INSERT INTO bib_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kʊ ŋ lee ku Salamin ʊ bɩ, ŋ Woso lemim pa da zɩɩfʊrɔ sokʊmacɛrɔ ʊ. Zaan nyɩnta kan ŋ kɩ, an n'a darɛ ŋ han. ");
INSERT INTO bib_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kʊ ŋ y'a da tara kʊ hi bɩr ma haay bɩ zi, ŋnɩ lee ku Pafɔs ʊ bɩ, ŋ yaa nyɩsɩzaa deem zɛ ʊ. Ŋʊaarlɛsinnɩsorazaa m, zɩɩfʊ m, ŋn'a birm Bar-Yeezuu. ");
INSERT INTO bib_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","A nyɩnta tara bɩ do lɛɛzaa Sɛrziyus Polus, k'a nyɩnta gʊaa hɔɔnzaa bɩ jɩrmazannɔ wɔɔ barla. Tara bɩ lɛɛzaa bɩ m Barnabas kan Sol kɩ bir, bala, a nyɩnta an a ŋʊa k'a Woso lemim bɩ ma. ");
INSERT INTO bib_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nyɩsɩzaa bɩ do kʊ n n'a birm Elimas, grɛkkɩ lemim bʊʊrɔzaa, bɩ n yɛ ŋ nɩ y, an n'a kam ma k'a a ka kʊ tara bɩ lɛɛzaa bɩ bɩ sɩra ka y. ");
INSERT INTO bib_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sol kʊ n n'a birm Pol bɩ kʊ Sɛnt-Ɛspri a han b'ɩ dɩgam ma sɩɩ…, ");
INSERT INTO bib_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","an n'a hɩm nɩ, a ʊ: «Ɩbɩɩ k'ɩ hɔɔn bʊnyaa ka, kan ŋʊaarbaa kɩ bɩ, Sʊtaana nyɩ ra, sɩra jɩm naa, ɩbɩɩ bɩ Zuuba zaa tɩrga bɩ zarlɛ tom na? ");
INSERT INTO bib_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ba Zuuba wɔ n n'ɩbɩɩ ra na: ɩbɩɩ y'ɩ bam bʊʊ dɔmɩm poore nɔ ʊ, ɩbɩɩ b'ɩ yarɛ ɩ woso gure yɩ y.» Lɛɛm bɩ, monsigə kan gunuu kɩ a ku ra, an n'a bɩrm lɛɛ haay ʊ, an n'a kam gʊaa ma k'an a gaa. ");
INSERT INTO bib_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tara bɩ lɛɛzaa bɩ k'a naa yɩ bɩ, a a ba sɩrakarɛzaa, bala, Zuuba karɩnda bɩ gasʊ a hɔɔn ʊ paan…. ");
INSERT INTO bib_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol kan a zukuuzannɔ wɔɔ kɩ a hʊr Pafɔs ʊ, ŋnɩ da kɔɔlʊʊ ʊ, ŋnɩ ta Panfilii kʊ Pɛrzee ʊ. Bɩ, Zaan a gʊ ŋ ma, an a wusigə Zerizalɛm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ŋ n a hʊr Pɛrzee ʊ, ŋn'a zaa sa, ŋn'aa lee ku Pisidii Antɩyɔs ʊ. Ŋ n gasʊ sokʊmacɛ ʊ *sabaa hinni ʊ, ŋnɩ nyɩnta. ");
INSERT INTO bib_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kʊ ŋ lɛrɔ kan wosolɛsinnɩsorazannɔ kɩ ciro karɩnda ba, ŋn'a nya bɩ, sokʊmacɛ cinno wɔɔ a ka, ŋn'a hɩ ŋ nɩ, ŋ ʊ: «Ʊ danyɩnɔ, k'awɔɔ ɩ dʊndɔ m k'a ka gʊɔɔ wɔɔ m, zaa ta ʊ!» ");
INSERT INTO bib_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol n wuti, an a wɔ busu, a ʊ: «Israyɛl zannɔ kan awɔɔ k'a nɩ nyi bam Woso m nɔ wɔɔ kɩ, k'a tʊr ka mɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Wɔɔ do Israyɛl Woso bɩ wɔɔ zɩrɔ bɔ ʊ. Do k'a nyɩnta Eziptɩ ʊ bɩ, a a da ra gʊta, bɩ, kan a wɔ paŋŋa kɩ, a a ka ŋnɩ bɔ, ");
INSERT INTO bib_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","a hɔbɩrɛ ka ŋ ʊ poohɔɔn ʊ dɔɔraa busi nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Bɩ jɛ ʊ bɩ, a do saanhɩna zɩnzɛ Kanaan kʊ ʊ, an a ka, ŋna so ŋ tararɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","A ga kʊ ʊ naa haay a ba kan dɔɔraa zɔrsi busoor kɩ. Bɩ kur bɩ, a dʊdɔkənno ka ŋ ʊ an ta, an wosolɛsinnɩsorazaa Sanwɛl ku. ");
INSERT INTO bib_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ŋ n cir yɛ, Woso n Bɛnzamɛn do gʊaa Kis nyɩ Sol ka ŋ ʊ. A cirbəə bɩrɛ dɔɔraa busi ku. ");
INSERT INTO bib_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Woso n wɔ saa bɩ ma, an Davɩd bɔ ʊ, an a ka ŋ ʊ k'an yɩ cir. A n a kasɛtɩ ka b'ʊ, an n'a hɩrɛ, a ʊ: ‹Mɔɔ Zesee nyɩ Davɩd yɩ, mɔɔ heer gʊaa m, an nɩ hɔ kʊ mɔɔ lɛ n taa haay bɩ bam.› ");
INSERT INTO bib_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Amba Woso k'a ler bɔ bɩ, a Yeezuu bɔ Davɩd do nɔ ʊ k'an yɩ Israyɛl bʊmbɔrɛzaa. ");
INSERT INTO bib_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","K'a n bʊr cɩna bɩ, Zaan lɛɛ ka an bɩ mimbʊnyaarɔ tore batɛm pa da Israyɛl zannɔ m haay. ");
INSERT INTO bib_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Zaan zibəə k'a bʊr an nɩ nyam bɩ, a a hɩ, a ʊ: Awɔɔ y'a hɔɔn dam a ʊ, nka m mɔɔ nɩ? Gʊaa k'awɔɔ nɩ dɔm ma bɩ bɛɛ m mɔɔ nɩ y. Bɩ, gʊaa ɩ zɛm mɔɔ kur, bɩ mɔɔ n m ga m, m a kʊsɔrɔ bar hʊr y.» ");
INSERT INTO bib_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«M danyɩnɔ, Abraham donyɩnɔ, kan bɔɔ nɩ nyi bam Woso m awɔɔ bire ʊ rɔ wɔɔ kɩ, bʊmbɔrɛ lemim naa do nyɔɔ n y'a ʊ wɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Zerizalɛm zannɔ kan a cinno kɩ n Yeezuu dɔ y. Ŋ n wosolɛsinnɩsorazannɔ lemim kʊ n n'a karɩnda bam sabaa biyəə hinni ʊ bɩ jɩ ma sɔ y. Bɩ, kʊ ŋ y'a nyasʊ, ŋn'a ka zɛ ma bɩ, ŋ y'a ka wosolɛsinnɩsorazannɔ lemim bɩ n kʊ yɩ. ");
INSERT INTO bib_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kʊ ŋ n mim yɩ a gʊr zi an a ga zɛ m bɩ, ŋ y'a yɛ Pɩlatɩ han k'an a ka kʊ n n'a zɛ gər. ");
INSERT INTO bib_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bɩ, kʊ ŋ hɔ kʊ n y'a gʊrsɩra ba a minto bɩ ba an nya bɩ, gʊɔɔ a zer gɔ bɩ ma, ŋn'a da yaa ʊ. ");
INSERT INTO bib_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bɩ, Woso a mɩm bɔ ʊ gəəno bire ʊ. ");
INSERT INTO bib_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Bɩ, a a hɩnka dɔmɩm gʊta nɔ ʊ gʊɔɔ kʊ ŋ zu kʊ ʊ kan kɩ Galilee ʊ, ŋnɩ ta Zerizalɛm ʊ rɔ wɔɔ m, brɔɔ m kasɛtɩzannɔ kɛɛrɛ gʊɔɔ lɛɛ.» ");
INSERT INTO bib_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Bɩ wɔɔ sɔ, lemim nyɩnta naa do, wɔɔ n'a pa darɛ awɔɔ m, lerbɔrɛ kʊ Woso a bɔ wɔɔ zɩrɔ m bɩ, ");
INSERT INTO bib_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Woso a ba wɔɔ mɩŋŋɔɔ minto, wɔɔ k'ʊ nɩ ŋ nyɩnɔ bɩ minto, a Yeezuu mɩm bɔ ʊ amb'a n y'a gʊrsɩra ba laarɔ ci ʊ, laa hɩɩya hɔ nɔ ʊ bɩ m: Mɔɔ nyɩ n'ɩbɩɩ m, her naa, mɔɔ n'ɩbɩɩ Zɩ. ");
INSERT INTO bib_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Woso a mɩm bɔ ʊ gəəno bire ʊ, k'a b'a da ma, an vɔn y, a mɩŋŋa y'a hɩ, a ʊ: Mɔɔ Davɩd hɔɔmɩŋŋɔɔ kʊ ŋ nɩ ta ʊ paan… rɔ wɔɔ karɛ awɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Bɩ minto y'a ka, an n'a hɩm lɛɛ vanta ʊ laarɔ ci ʊ: A b'a gʊaa mɩŋŋa bɩ tore, an vɔn y. ");
INSERT INTO bib_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Bala, Davɩd k'a Woso zi bɩ ba a dɔmɩm ʊ bɩ, a bɩ ga, ŋn'a bir a zɩrɔ zi, a mɛsim n vɔn. ");
INSERT INTO bib_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Bɩ gʊaa kʊ Woso a mɩm bɔ ʊ bɩ, a mɛsim n vɔn y. ");
INSERT INTO bib_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","M danyɩnɔ, k'a dɔ mɩŋŋa a ʊ, gʊaa bɩ do minto y'a ka mimbʊnyaarɔ sugur pa n nɩ dam awɔɔ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","A mɩŋŋa minto, gʊaa biyəə k'a nɩ sɩra kaŋ ʊ bɩ, a y'a mimbʊnyaarɔ haay sugur yɩrɛ, bɩ lɛ kʊ Moyiisi a ka bɩ b'a dam ma an a ka awɔɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","K'a dundo a zi, kʊ hɔsɩ bɩ ba awɔɔ m amba hɔ kʊ wosolɛsinnɩsorazannɔ a hɩ bɩ nɩ y. Ŋ y'a hɩ, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","K'a dɩga a, sɔ gʊɔɔ m zannɔ, k'a zɛ kədə, k'a nyaam! Mɔɔ zi bam awɔɔ dɔmɩm ʊ, zibəə m, awɔɔ n nɩ bɩsɩ kam ma, baa kʊ gʊaa a dɩnda awɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol kan Barnabas kɩ kʊ ŋ bʊr ŋn'ɩ bɔm bɩ, ŋ y'a yɛ ŋ han gʊta, kʊ ŋ nɩ so minno nɔɔn duro ra sabaa k'a nɩ zɛm bɩ ma. ");
INSERT INTO bib_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Gʊɔɔ wɔɔ kʊ ŋ hɩsɩga da bɩ, zɩɩfʊrɔ gʊta kan do vantɔɔ gʊɔɔ kʊ ŋ nɩ zum zɩɩfʊrɔ wɔɔ lɛrɔ wɔɔ ʊ rɔ wɔɔ kɩ, Pol kan Barnabas kɩ da zaa ʊ. Sʊʊra kʊ ŋ n'a bam bɩ, ŋ yɩ ŋ dʊndɔm, kʊ ŋ nɩ gɔɔta Woso barka nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabaa k'a nya ʊ bɩ k'a ku bɩ, tara bɩ zannɔ haay a zɛ kʊ ra k'a a tʊr ka Woso lemim ma. ");
INSERT INTO bib_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Zɩɩfʊrɔ kʊ ŋ gʊɔɔ wɔɔ yɩ gʊta ncɩnaaʊ bɩ, jɩmbaa ŋ heer han, ŋn'ɩ Pol meerbaarɔ wɔɔ nyɩ bʊmbɔŋ ʊ, ŋn'a sʊnsɔ wʊrɛ. ");
INSERT INTO bib_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pol kan Barnabas kɩ a heer ba kookoo, ŋn'a hɩ ŋ nɩ, ŋ ʊ: «Awɔɔ Woso lemim b'a ga m, an lɛɛ ka, an hɩ awɔɔ m! K'awɔɔ kaanm Woso lemim bɩ m bɩ, awɔɔ a mɩŋŋɔɔ dʊdɔ yar kan mɩsɩrbaa k'a nyarɛ ba ʊ bɩ kɩ, a hɩnka a ʊ: awɔɔ lɛ baa k'a yɩ y. Kɛɛrɛ naa, ʊ wusigə wɔɔ nawʊm do vantɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bala, lɛ kʊ Zuuba a ka wɔɔ bɩ n naa: Mɔɔ ɩbɩɩ bɔ ʊ k'ɩ yɩ lɛɛgure do gʊta minto, k'ɩ bʊmbɔrɛ ganwʊrɛ bɩ sa, ɩ ta m durnya lɛ cɩnta jɩ ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kʊ ŋ minno nɔɔn duro ma bɩ, do vantɔɔ gʊɔɔ wɔɔ, kan heernyɔɔ kɩ, ŋ y'a lɛ bɔm Zuuba Woso lemim ʊ. Bɩ, gʊɔɔ haay kʊ ŋ nɩ mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩm nɔ wɔɔ sɩra ka. ");
INSERT INTO bib_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Zuuba lemim bɩ lee ku lɛɛ haay ʊ. ");
INSERT INTO bib_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Zɩɩfʊrɔ wɔɔ n bɔkarɛ ŋn'ɩ lannɔ tɔzannɔ kʊ ŋ nɩ Woso daŋ ʊ paan… rɔ wɔɔ nyʊnnyɔɔta kan tara gʊɔɔgusinno wɔɔ kɩ k'a fɩr ka Pol ma kan Barnabas kɩ, k'a la ŋ la, kʊ ŋ nɩ bɔ a tara bɩ ra. ");
INSERT INTO bib_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Brɔɔ n taanyisi gʊngʊ a gannɔ ma ŋ minto, ŋnɩ ta Ikonɩyɔm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kʊ karɩndanyɩnɔ wɔɔ nɩ, Sɛnt-Ɛspri kan heernyɔɔ kɩ ŋ heer han. ");
INSERT INTO bib_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikonɩyɔm ʊ bɩ, ŋ y'a ba am biisi hɔ bɩ m. Pol ta kan Barnabas kɩ, ŋn'aa gasʊ zɩɩfʊrɔ sokʊmacɛ ʊ. Ŋ meerbaa b'a ka, gʊɔɔ gʊta kʊ ŋ nɩ zɩɩfʊrɔ kan grɛkkɩrɔ kɩ n a ba sɩrakarɛzannɔ. ");
INSERT INTO bib_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bɩ, zɩɩfʊrɔ niŋŋoo kʊ ŋ n yɛ sɩrakarɛ bɩ ma rɔ wɔɔ do vantɔɔ gʊɔɔ wɔɔ nyʊnnyɔɔta, ŋ heer nɩ busum kan danyɩnɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pol kan Barnabas kɩ gɔɔta b'ʊ tee…, ŋn'ɩ meer bam kan heerkoodəbaa kɩ Zuuba minto. Zuuba a kasɛtɩ ka ŋ ʊ. Bala, a mɩŋŋa yɩ ŋ meerbaa sɩra hɩnka, an a ka, ŋn'a da ma, ŋn'ɩ hoserlo bam kan makrarɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tara nɔ zannɔ wɔɔ n a jir lɛ hɩɩya: gɔsɩnnɔ nɩ kan zɩɩfʊrɔ wɔɔ kɩ, gɔsɩnnɔ nɩ kan kristazibəəzannɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Do vantɔɔ gʊɔɔ wɔɔ kan zɩɩfʊrɔ wɔɔ kɩ, a cinno kɩ, lɛ sa k'a zibəə bʊnyaa ba kristazibəəzannɔ wɔɔ m, k'a ŋ gʊngʊɛɛn jaarɔ m. ");
INSERT INTO bib_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kʊ Barnabas kan Pol kɩ hɔ kʊ ŋ ʊ k'a ba bɩ dɔ bɩ, ŋ y'a si, ŋnɩ ta Likawonii kʊrɔ ʊ, Listɩr kan Derbe kɩ, kan ŋ bɔlɛɛmarɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","B'ʊ sɔ bɩ, ŋ y'ɩ lemim nyɩnta bɩ pa darɛ. ");
INSERT INTO bib_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listɩr kʊ gʊaa deem n ta ʊ, a b'a dam ma an jɩm a gannɔ ra y. Yɩ a ʊ lʊgɔbaa bɩ m, a n ta fɩɩgaa y. ");
INSERT INTO bib_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Hindeem ʊ, an nyɩnta an n'a tʊr kam Pol meerbaa ma. Pol nɩ dɩgam ma sɩɩ…. K'a yɩ a nɩ sɩrakarɛ m k'a laafɩɩ yɩ bɩ, ");
INSERT INTO bib_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","a a hɩ kan paŋŋa kɩ, a ʊ: «Wuti ɩ jɩm, ɩ gannɔ ra!» Gʊaa bɩ n wuti lɛ deem, an nɩ tam. ");
INSERT INTO bib_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Gʊɔɔ wɔɔ kʊ ŋ hɔ kʊ Pol a ba bɩ yɩ bɩ, ŋ y'a leer busu brama, ŋn'a hɩm Likawonii lemim m, ŋ ʊ: «Wosoro y'a ba gʊɔɔ, ŋnɩ zer wɔɔ bire ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ŋ n'ɩ Barnabas birm ‹*Zes›, ŋn'ɩ Pol birm ‹*Hermɛs›, bala, a ɩ nyɩnta meerbaazaa. ");
INSERT INTO bib_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zes yaadarɛcɛ bɩ, pəŋŋə kʊ n y'a bɩr kʊ bɩ ma bɩ lɛ ma n ta ʊ. A mannɩbər b'a ka ŋnɩ ta ŋʊannɔ m, ŋnɩ lɛɛrɔ waa, ŋn'a dɩnda ŋ wer, ŋnɩ ta ŋ nɩ kʊ bɩ lɛ ma. A n a zɛ kʊ ra kan gʊɔɔ wɔɔ kɩ, k'a mannɩ ba. ");
INSERT INTO bib_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kristazibəəzannɔ Barnabas kan Pol kɩ kʊ ŋ mim naa do ma bɩ, ŋ heer a zar gʊta, ŋn'a huuro kɩnkaansʊm, ŋnɩ bra si, ŋn'ɩ tam gʊɔɔ wɔɔ zi kan zee kɩ. ");
INSERT INTO bib_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Ŋ ʊ: «Gʊɔɔ ra, bɔ awɔɔ n'a bam naa? Wɔɔ, gʊɔɔ m wɔɔ m sɔ am awɔɔ hɔ bɩ m! Lemim nyɩnta kʊ wɔɔ n'a pa darɛ awɔɔ m naa, k'a wɔ saa hɔbaarɔ nɩbɩɩrɔ nɔɔn duro ma, k'a zu Woso k'an mɩsɩr, an brama da kan tara kɩ, higʊta kɩ kan hɔ haay k'an a nɔ ʊ bɩ kɩ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kʊ biisi bɩ nɩ, a do haay to, ŋn'ɩ zure a zaarɔ ʊ, ");
INSERT INTO bib_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","b'a hɔ mɩŋŋa ba awɔɔ m, bala, a lahi ka awɔɔ ʊ, kan mɔsa kɩ, a hɔbɩrɛ ka awɔɔ ʊ, an n'awɔɔ heer nyɔɔm.» ");
INSERT INTO bib_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Meerbaarɔ nɔɔn duro bʊraama ka gʊɔɔ wɔɔ ʊ. B'a n nyɩnta naanaa k'a gʊɔɔ wɔɔ da jɩm ʊ kʊ ŋ bɩ mannɩ bɩ ba y. ");
INSERT INTO bib_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Bɩ jɛ ʊ bɩ, zɩɩfʊrɔ y'a to Antɩyɔs ʊ kan Ikonɩyɔm kɩ, ŋnɩ bɩ gʊɔɔ wɔɔ nyʊnnyɔɔta. Ŋ n Pol gʊngʊɛɛn jaarɔ m, ŋn'a gɩngaata, ŋnɩ bɔ m tara nɔ ʊ, ŋn'ɩ dɩgam ma, ŋ ʊ, ga a ʊ. ");
INSERT INTO bib_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bɩ, karɩndanyɩnɔ wɔɔ kʊ ŋ y'a zɛ kʊ ra, ŋnɩ bɩr ma bɩ, a wuti, an gasʊ tara nɔ ʊ. Dɔ k'a mɛ bɩ, a a hʊr kan Barnabas kɩ, ŋnɩ ta Derbe ʊ. ");
INSERT INTO bib_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kʊ ŋ lemim nyɩnta bɩ pa da Derbe ʊ ŋnɩ karɩndanyɩnɔ yɩ gʊta bɩ, ŋ y'a bɔ, ŋnɩ bɔ Listɩr ʊ, Ikonɩyɔm kan Pisidii Antɩyɔs kɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ŋ karɩndanyɩnɔ wɔɔ heer yo, ŋnɩ ŋ dʊndɔ kʊ ŋ nɩ gɔɔta a sɩrakarɛ nɔ ʊ, ŋn'a hɩ, ŋ ʊ: «A a ga m, wɔɔ n fɩr yɩ gʊta, k'ʊ bɔkarɛ, ʊ gasʊ Woso cirbəə nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ŋ lɛɛzannɔ bɔ ʊ kristagʊɔɔ sokʊma biyəə nɔ ʊ, ŋnɩ yaarɔ da ŋn'a lɛ kʊsɩ, ŋnɩ yaa da lɛɛzannɔ wɔɔ tɔ ma, ŋnɩ ŋ da Zuuba kʊ ŋ sɩra ka ʊ bɩ wɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ŋ bɔ Pisidii ʊ, ŋnɩ ta Panfilii ʊ, ");
INSERT INTO bib_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ŋnɩ lemim nyɩnta bɩ pa da Pɛrzee ʊ, ŋnɩ cem, ŋnɩ ta Atalɩyaa ʊ. ");
INSERT INTO bib_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ŋ n a to b'ʊ, ŋnɩ da kɔɔlʊʊ ʊ, ŋnɩ ta Antɩyɔs ʊ, tara niŋŋə kʊ ŋ y'a yɛ ʊ Woso han, k'a nɩ ŋ barka da ʊ zibəə kʊ ŋ y'a ba naa minto b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kʊ ŋ lee ku bɩ, ŋ sokʊma bɩ bir, ŋnɩ hɔ haay kʊ Woso a da ŋ han ŋn'a ba bɩ dɩnda ŋ nɩ, an lɛ da bɩ, hɔ kʊ Woso a ba, do vantɔɔ ŋn'a ba sɩrakarɛzannɔ bɩ. ");
INSERT INTO bib_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ŋ maasɩrɛ ba b'ʊ kan karɩndanyɩnɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Gʊɔɔ gɔsɩnnɔ y'a to Zidee ʊ, ŋnɩ bɩ karɩnda ba danyɩnɔ wɔɔ m, ŋ ʊ: «K'awɔɔ n gasʊ baŋŋʊ b'ʊ, a zu Moyiisi yɩnnɩbayɩ zibəə b'ʊ, awɔɔ bɩ bʊmbɔrɛ yɩrɛ y.» ");
INSERT INTO bib_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Mim naa do wuti bʊgʊr gʊta m kan bɩsɩkarɛ kɩ gʊɔɔ wɔɔ kan Pol kɩ Barnabas kɩ bire ʊ. Danyɩnɔ wɔɔ n a cɩnta kʊ Pol kan Barnabas kɩ, gʊɔɔ gɔsɩnnɔ kɩ n ta Zerizalɛm ʊ kʊ ŋ n'aa kristazibəəzannɔ wɔɔ yɩ kan kristagʊɔɔ lɛɛzannɔ wɔɔ kɩ mim naa do minto. ");
INSERT INTO bib_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Antɩyɔs kristagʊɔɔ sokʊma bɩ n dɩga ŋ zaa sarɛ mim ma. Ŋ bɔ Fenisii ʊ kan Samarii kɩ, ŋn'ɩ do vantɔɔ gʊɔɔ heerlʊrlɛ mim dɩndam, b'a yɩ heernyɔɔ gʊta kan ʊ danyɩnɔ wɔɔ kɩ haay. ");
INSERT INTO bib_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kʊ ŋ lee ku Zerizalɛm ʊ bɩ, sokʊma a nya ŋ zi, an ŋ si, kristazibəəzannɔ kan kristagʊɔɔ lɛɛzannɔ kɩ, ŋnɩ hɔ kʊ Woso a da ŋ han ŋn'a ba bɩ sa, ŋn'a dɩnda ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Farizɛɛnrɔ sɩrakarɛzannɔ wuti ŋn'a hɩ ŋ ʊ, a a ga m kʊ ŋ nɩ do vantɔɔ gʊɔɔ wɔɔ gasʊ baŋŋʊ ʊ, kʊ ŋ nɩ lɛ ka, kʊ ŋ nɩ zu Moyiisi lɛrɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kristazibəəzannɔ wɔɔ kan kristagʊɔɔ lɛɛzannɔ wɔɔ kɩ a so kʊ ma, k'a dɩga mim naa do ma. ");
INSERT INTO bib_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kʊ ŋ bɩsɩ bɩ ka tee… bɩ, Pɩyɛɛr wuti an a hɩ, a ʊ: «M danyɩnɔ, awɔɔ dɔ a ʊ, a sɩŋŋɩda ʊ bɩ, Woso mɔɔ bɔ ʊ awɔɔ bire ʊ, kʊ do vantɔɔ gʊɔɔ m lemim nyɩnta bɩ ma mɔɔ lɛ m, kʊ ŋ n'a si. ");
INSERT INTO bib_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Woso k'a heerlɔ wɔɔ dɔ bɩ, a kasɛtɩ ka ŋ ʊ, an Sɛnt-Ɛspri bɩ ka ŋ ʊ, amba a a ka wɔɔ ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Woso n ŋ gʊ wɔɔ ma poore tɔkkɛ y, sɩrakarɛ minto y'a ka an ŋ heerlɔ wɔɔ sʊrgɔ. ");
INSERT INTO bib_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kɛɛrɛ bɩ, bɔ minto y'a ka, an nɩ Woso makra barɛ? A n nɩ mɔr gorezaa bɩ kam karɩndanyɩnɔ wɔɔ ra, bɩ wɔɔ zɩrɔ kan wɔɔ mɩŋŋɔɔ kɩ n a da ma, ʊ n'a busure? ");
INSERT INTO bib_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Bɩ, wɔɔ si wɔɔ ʊ, Zuuba Yeezuu barka minto y'a ka wɔɔ n bʊmbɔrɛ yɩ, am ŋ hɔ bɩ m.» ");
INSERT INTO bib_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ŋ haay n zɛ pi, ŋn'a tʊr kam Pol kan Barnabas kɩ ma, brɔɔ nɩ hoserlo kan makrarɔ kɩ kʊ Woso a ka ŋ nɩ ba haay do vantɔɔ kʊ ʊ bɩ dɩndarɛ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kʊ ŋ y'a nya bɩ, Zakkɩ meerbaa bɩ si, a ʊ: «M danyɩnɔ, k'a tʊr ka mɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Sɩmɩnyɔɔ hɔ kʊ Woso a ba a sɩŋŋɩda ʊ, k'a dɩga a do ma, a bɔ ʊ gʊɔɔ kʊ ŋ ba zɩɩfʊrɔ wɔɔ barla bɩ tɔ da wɔɔ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Bɩ wosolɛsinnɩsorazannɔ yɛ bɩ ma sɔ, bala, n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: ");
INSERT INTO bib_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Bɩ jɛ ʊ bɩ, mɔɔ zɛm bɩ Davɩd har k'a a da bɩ banka m a dɔ, zeero kʊ ŋ gɔɔta rɔ wɔɔ, mɔɔ yɩ m yarɛ, m ŋ dɔ, m ŋ jɩm brama. ");
INSERT INTO bib_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kʊ gʊɔɔ kʊ ŋ gɔɔta rɔ wɔɔ n a ka Zuuba ma, kan do vantɔɔ haay kʊ ŋ nɩ mɛm mɔɔ tɔ ma rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Zuuba ɩ naa hɩ, a y'a ka ŋnɩ hɔɔ nɔɔn duro dɔ biisi hɔɔ tee…. ");
INSERT INTO bib_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Bɩ minto y'a ka mɔɔ m hɔɔn da, mɔɔ ʊ, a n a ga m, wɔɔ n fɩr ka do vantɔɔ gʊɔɔ kʊ ŋ yɛ Woso ma rɔ wɔɔ ma y. ");
INSERT INTO bib_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ʊ ci ba ŋ ma, ʊ a hɩ ŋ nɩ, ʊ ʊ, ŋ bɩ *wosobaawɔnnɔ mannɩbarɛ sim sʊ y, ŋ bɩ jaan da y, ŋ bɩ hɔ gər sim sʊ, kan ma kɩ sɔ y. ");
INSERT INTO bib_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Sɩra m, a dɔɔraa laatʊ, gʊɔɔ ɩ tara nɔ biyəə ʊ, ŋnɩ Moyiisi lɛrɔ karɩnda bam *sabaa hinni haay ʊ ŋ sokʊmacɛrɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kristazibəəzannɔ wɔɔ kan kristagʊɔɔ lɛɛzannɔ wɔɔ kɩ, sokʊma bɩ kɩ, a cɩnta k'a gʊɔɔ bɔ ʊ a barla a ŋ nyɔɔ kan Pol kɩ Barnabas kɩ Antɩyɔs ʊ. Nyɩnta a ʊ Ziidi kʊ n n'a birm Barsabas, kan Silas kɩ, gʊɔɔ m, ŋ nɩ daʊrɛ m danyɩnɔ wɔɔ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ŋ n ci naa do ka ŋ ʊ: «Kristazibəəzannɔ kan kristagʊɔɔ lɛɛzannɔ kɩ, ʊ danyɩnɔ kɩ ɩ yaa darɛ a danyɩnɔ do vantɔɔ kʊ ŋ nɩ Antɩyɔs ʊ kan Siirii kɩ, Silisii kɩ rɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Wɔɔ ma ŋ ʊ, wɔɔ gʊɔɔ gɔsɩnnɔ ɩ b'awɔɔ wʊnwar kʊ ma, ŋn'awɔɔ heer zar, ŋnɩ dabɔʊ da awɔɔ ma kan a meerbaarɔ kɩ, bɩ wɔɔ n ŋ nyɔɔ y. ");
INSERT INTO bib_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Wɔɔ ʊ lɛ ba deem, ʊ a cɩnta k'ʊ gʊɔɔ bɔ ʊ, ʊ ŋ nyɔɔ kan ʊ gʊaasɩbɔɔ paan…rɔ Barnabas kan Pol kɩ. ");
INSERT INTO bib_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Gʊɔɔ m, ŋn'a mɩsɩrbaa ka zɛ ma, Zuuba Yeezuu Krista tɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Bɩ minto y'a ka, wɔɔ n nɩ Ziidi kan Silas kɩ nyɔɔrɛ awɔɔ ma, kʊ ŋ nɩ bɩ minno nɔɔn duro hɩ awɔɔ m a lɛ m. ");
INSERT INTO bib_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Sɛnt-Ɛspri kan wɔɔ mɩŋŋɔɔ kɩ, wɔɔ ʊ hɔɔn da, ʊ ʊ, a n a ga m, k'ʊ ʊ ya, ʊ mɔr gorezaa vanta ka awɔɔ ra, kʊ mim pakrarɔ nɔɔn duro bɛɛ y: ");
INSERT INTO bib_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","A bɩ wosobaawɔnnɔ mannɩbarɛ sim sʊ y, kan ma kɩ, hɔɔ gəəro kɩ, b'a bɩ jaan da sɔ y. K'awɔɔ zu naa haay ʊ, awɔɔ ba mɩŋŋa. Woso y'a darɛ a han.» ");
INSERT INTO bib_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Gʊɔɔ kʊ n yɩ ŋ bɔ ʊ rɔ wɔɔ, a leer so, ŋn'a hʊr, ŋnɩ ta Antɩyɔs ʊ, ŋn'aa gʊɔɔ wɔɔ so kʊ ma, ŋnɩ ci bɩ ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ci bɩ karɩnda bɩ barɛ ŋ heer nyɔɔ, kʊ ŋ dʊndɔrɛ ncɩnaaʊ yɩ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ziidi kan Silas kɩ kʊ ŋ nɩ wosolɛsinnɩsorazannɔ wɔɔ, ŋ danyɩnɔ wɔɔ dʊndɔ kan meerbaarɔ kɩ, ŋnɩ ŋ paŋŋa da ra. ");
INSERT INTO bib_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ŋ gɔɔta b'ʊ dɔmɩm poore, danyɩnɔ wɔɔ n bɩ zaa ka ŋ ʊ, ŋn'a bɔ ŋnɩ ta gʊɔɔ kʊ ŋ yɩ nyɔɔ rɔ wɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Kʊ Barnabas kan Pol kɩ nɩ, ŋ gɔɔta Antɩyɔs ʊ, ŋn'ɩ hɔ dɩndarɛ, ŋn'ɩ Zuuba lemim nyɩnta bɩ pa dam kan gʊɔɔ gʊta kɩ sɔ. ");
INSERT INTO bib_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","K'a yɩ poore bɩ kur bɩ, Pol a hɩ Barnabas m, a ʊ: «Ʊ ʊ wusigə, ʊ aa dɩga ʊ danyɩnɔ wɔɔ ma kʊ biyəə kʊ wɔɔ Zuuba lemim nyɩnta pa da ʊ b'ʊ. K'ʊ dɩga a kʊ ŋ y'a bam lɔ gɛ.» ");
INSERT INTO bib_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas n a ŋʊa k'a Zaan kʊ n n'a birm Markɩ bɩ gaa a ta m. ");
INSERT INTO bib_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bɩ, Pol n yɛ k'a gaa y, bala, a nyɩnta an nɩ zum kʊ ʊ kan ŋ kɩ, an a gʊ ŋ ma Panfilii ʊ, a n a ya, an zi ba kan ŋ kɩ y. ");
INSERT INTO bib_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ŋ bɩsɩ ka kan kʊ kɩ maam-maam, bɩsɩ bɩ n bɩ ŋ gʊngʊ kʊ ma gʊaa biyəə n ta a lɛ, a lɛ. Barnabas Markɩ gaa, an da kɔɔlʊʊ ʊ an ta Siipɩr ʊ. ");
INSERT INTO bib_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol n Silas gaa, danyɩnɔ wɔɔ n yaa da, kʊ Zuuba n a barka ka ŋ ʊ. Ŋ n cem. ");
INSERT INTO bib_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pol bɔ Siirii kan Silisii kɩ kʊrɔ ʊ, an nɩ kristagʊɔɔ sokʊmarɔ wɔɔ paŋŋa dam la. ");
INSERT INTO bib_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol kan Silas kɩ ta ŋn'aa lee ku Derbe ʊ, ŋnɩ cem ŋnɩ ta Listɩr ʊ. Karɩndanyɩ deem n nɩ b'ʊ, a tɔ m Timote, a da bɩ zɩɩfʊ m, an a ba sɩrakarɛzaa, a zɩ bɩ grɛkkɩ m. ");
INSERT INTO bib_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","A danyɩnɔ kʊ ŋ nɩ Listɩr ʊ kan Ikonɩyɔm kɩ rɔ wɔɔ y'a lɛ bɔrɛ a tɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol n a ŋʊa k'a gaa. A n a gaa, an a gasʊ baŋŋʊ ʊ zɩɩfʊrɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ minto, bala, ŋ haay a dɔ, ŋ ʊ, a zɩ bɩ grɛkkɩ m. ");
INSERT INTO bib_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tara nɔ rɔ kʊ ŋ nɩ bɔrɛ ŋ ʊ rɔ wɔɔ, ŋ yɩ lɛrɔ kʊ Zerizalɛm kristazibəəzannɔ wɔɔ a cɩnta kan kristagʊɔɔ lɛɛzannɔ wɔɔ kɩ bɩ hɩrɛ ŋ nɩ, ŋn'a yɛrɛ ŋ han kʊ ŋ nɩ zu ŋ ʊ mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kristagʊɔɔ sokʊmarɔ wɔɔ sɩrakarɛ paŋŋa n'a dam la, ŋ lɛ n'a dam la dɔmɩm biyəə. ");
INSERT INTO bib_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol kan Silas kɩ bɔ Frizii ʊ kan Galasii kɩ, Sɛnt-Ɛspri n a ta ŋ nɩ tolle, kʊ ŋ bɩ lemim bɩ pa da Azii ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kʊ ŋ lee ku Mizii jireyaa ʊ bɩ, ŋ y'a ŋʊa k'a ta Bitinii ʊ, bɩ, Yeezuu Ɛspri bɩ ŋ da jɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ŋ n cem, ŋnɩ bra Mizii ʊ, ŋn'aa lee ku Trowas ʊ. ");
INSERT INTO bib_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Gum deem ʊ, Pol Woso hɔhɩnkarɛ yɩ: Masedʊan gʊaa deem y'a hɩnka m, an jɩm brama, an n'a wɔ zɩnzɛm nɩ, a ʊ: «Bʊr Masedʊan ʊ, ɩbɩɩ ɩ da wɔɔ han!» ");
INSERT INTO bib_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol hɔhɩnkarɛ bɩ yɩrɛ jɛ ʊ bɩ, wɔɔ wuti zɔɔ-zɔɔ k'ʊ ta Masedʊan ʊ, bala, wɔɔ si wɔɔ ʊ Woso n nɩ wɔɔ birm kʊ aa lemim nyɩnta pa da b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Da kʊ wɔɔ ʊ kɔɔlʊʊ ʊ Trowas ʊ bɩ, wɔɔ ta tɩrga kan Samotrasɩ kɩ. A dɔ k'a mɛ bɩ, wɔɔ ta Neyapolis ʊ. ");
INSERT INTO bib_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ʊ ʊ to b'ʊ, ʊ ta Filipii ʊ, ʊ gam ma, Masedʊan kʊrɔ haay tara nɔ gʊta m bɩ. A gʊɔɔ wɔɔ n a so a mɩŋŋa ʊ am Rɔm zannɔ paan…rɔ wɔɔ hɔ bɩ m. Wɔɔ dɔmɩm poore ba tara nɔ bɩ do ʊ. ");
INSERT INTO bib_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","*Sabaa hinni ʊ, wɔɔ bɔ tara nɔ ʊ, ʊ ta bɔrkɔ lɛ ra. Bɩncɛ bɩ do ʊ bɩ, wɔɔ ʊ hɔɔn da, ʊ ʊ, yaadarɛ bɩncɛ nyɩntam b'ʊ. Kʊ wɔɔ nyɩnta bɩ, wɔɔ Yeezuu mim dɩnda kan lannɔ kʊ ŋ y'a so kʊ ma b'ʊ rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ŋ gʊaa deem k'a tɔ m Lidii, garhuuro hɛɛrɛzaa m, bɩ nyɩnta, an n'a tʊr kam wɔɔ ma. Tɩyatɩɩr kʊ nyɩ m, an nɩ Woso daŋ ʊ. Zuuba a heer gʊ k'an bʊr a ma, an a tʊr ka Pol meerbaa bɩ ma. ");
INSERT INTO bib_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","K'a batɛm si bɩ, a mɩŋŋa kan a har gʊɔɔ kɩ bɩ, a a yɛ wɔɔ han, an n'a hɩrɛ, a ʊ: «K'awɔɔ y'a hɔɔn darɛ a ʊ, mɔɔ ɩ zum Zuuba ʊ, k'a bʊr, a bɩ wʊta mɔɔ har ʊ.» A n ma wɔɔ ma, wɔɔ n kɔ ʊ yɛ. ");
INSERT INTO bib_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Hindeem ʊ, wɔɔ nɩ tam yaadarɛ bɩncɛ ʊ, lʊpoo n bɩ wɔɔ zɛ ʊ, lɔ m, bʊʊrɔzaa m. A wɔ bɩ kure ɩ busoo karɛ a zuubɔɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","A n nɩ zum wɔɔ jɛ ʊ, Pol kan wɔɔ kɩ, an nɩ zee darɛ, a ʊ: «Gʊɔɔ nɔɔn duro Woso k'a lɛ da haay zibəənyɩnɔ m. Bʊmbɔrɛ zaa ŋ n'a pa darɛ awɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","A ba a ʊ, ncɩnaaʊ dɔmɩm gʊta nɔ ʊ. Pol n bɩ kɔ, an a bɔ, an a hɩ zinə bɩ m, a ʊ: «Yeezuu Krista tɔ ma, mɔɔ lɛ ka ɩbɩɩ ʊ: bɔ lʊ naa do mɛ ʊ!» Lɛɛm bɩ, a bɔ a mɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","A zuubɔɔ wɔɔ kʊ ŋ y'a yɩ a busoo bɩ yɩrɛ n a zɛ ra bɩ, ŋ Pol nyasʊ kan Silas kɩ, ŋnɩ ŋ gɩngaata, ŋnɩ ta ŋ nɩ daasɩ ʊ, jɩtannɔ taa. ");
INSERT INTO bib_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Brɔɔ n ŋ gaa, ŋn'aa ŋ hɩnka dʊdɔkənno m, ŋ ʊ: «Gʊɔɔ nɔɔn duro nɩ wɔɔ kʊ naa nyankʊrɛ. Zɩɩfʊrɔ m. ");
INSERT INTO bib_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ŋ nɩ hɔ k'a bɩr zum wɔɔ Rɔm zannɔ lɛrɔ ʊ bɩ dɩndam.» ");
INSERT INTO bib_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Zamaa n wuti nyaa m kan Pol rɔ kɩ. Dʊdɔkənno wɔɔ n lɛ ka, ŋnɩ ŋ huuro bʊmbɔ ŋ ma, ŋnɩ ŋ zɛ madɩɩrɔ m. ");
INSERT INTO bib_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ŋ zɛ kʊ ŋ y'a ʊ gʊta bɩ, ŋ bɔkarɛ, ŋnɩ ŋ du lɔnnɔcɛ ʊ. Ŋ n lɛ ka lɔnnɔcɛ dɔmazaa b'ʊ kan dɩga ŋ ma mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Gʊaa kʊ ŋ lɛ naa do ka ʊ bɩ, a yɩ ŋ du cɛnɔzaa b'ʊ, an ŋ da gɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Dibsir k'a da bɩ, Pol kan Silas kɩ ɩ yaa dam, ŋn'ɩ Woso lɛbɔʊrɛ laa lɔm, lɔnnɔ vantɔɔ wɔɔ n'a tʊr karɛ ŋ ma. ");
INSERT INTO bib_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tara n nyiŋŋə lɛ deem, a nyiŋŋəre bɩ paŋŋa n cɛ jɩr bɩ yinyi. Cɛ bɩ lɛrɔ wɔɔ haay n gʊngʊ lɛɛm, lɔnnɔ wɔɔ haay baŋŋarɔ wɔɔ n sur pəŋŋə bɩ ma. ");
INSERT INTO bib_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Lɔnnɔcɛ dɔmazaa bɩ n wuti hinceem ma, a lɔnnɔcɛ lɛrɔ wɔɔ yɩ ŋn'ɩ gʊm, a hɔɔn ʊ bɩ lɔnnɔ wɔɔ a si ŋ y'a ʊ. A n a kargʊ gaa ʊ, k'a a mɩŋŋa zɛ m. ");
INSERT INTO bib_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pol n zee da kan paŋŋa kɩ, a ʊ: «Ɩ bɩ hɔsɩ ba ɩ mɩŋŋa nɩ y. Wɔɔ haay ta ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Lɔnnɔcɛ dɔmazaa bɩ n sɛ yɛ, an bra si, an gasʊ, an aa sʊnta Pol kan Silas kɩ taa mɛhinkə m. ");
INSERT INTO bib_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","A n ŋ gaa, an bɔ ŋ nɩ garga ra, an n'a hɩrɛ ŋ nɩ, a ʊ: «Gʊɔɔ ra, mɔɔ y'a bam lɔ kʊ m bʊmbɔrɛ yɩ?» ");
INSERT INTO bib_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ŋ n a nyɩ bɔ nʊ, ŋ ʊ: «Sɩra ka Zuuba Yeezuu ʊ, ɩ bʊmbɔrɛ yɩm, ɩbɩɩ kan ɩ har gʊɔɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ŋ n Zuuba lemim bɩ dɩnda m, kan gʊɔɔ haay kʊ ŋ n'a har ʊ rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lɔnnɔcɛ dɔmazaa bɩ n ŋ gaa gunuu ʊ b'ʊ lɛɛm, k'a yaa ŋ nyinno sʊrgɔ. Wakatɩ bɩ do ʊ sɔ bɩ, a batɛm si kan a har gʊɔɔ kɩ haay. ");
INSERT INTO bib_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","A n ŋ gaa, an ta ŋ nɩ a cɛ ʊ, an hɔbɩrɛ ka ŋ ʊ, an n'a heer nyɔɔm kan a har gʊɔɔ wɔɔ kɩ, k'a sɩra ka Woso ʊ bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Dɔ k'a mɛ bɩ, dʊdɔkənno wɔɔ a dɔmazannɔ nyɔɔ kʊ ŋ n'aa a hɩ lɔnnɔcɛ dɔmazaa bɩ m, kan wɔ saa gʊɔɔ wɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Lɔnnɔcɛ dɔmazaa bɩ n mim naa do hɩ Pol m, a ʊ: «Dʊdɔkənno wɔɔ nyɔɔ da, ŋ ʊ, ŋnɩ wɔ saa awɔɔ ma. Ncɩnaaʊ bɩ, k'a bɔ a doo kan laafɩɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Bɩ Pol a hɩ, a ʊ: «Ŋ y'a ka, ŋnɩ wɔɔ zɛ zamaa bire ʊ, bɩ ŋ n wɔɔ dʊdɔ ka y, wɔɔ kʊ wɔɔ n Rɔm zannɔ, ŋn'a ka, ŋnɩ wɔɔ du lɔnnɔcɛ ʊ. Ŋ n bɔkarɛ, ŋn'a ŋʊam k'a a kʊna, a wɔɔ bɔ. Bɩ bɩ kʊ yɩrɛ y. Ŋ n bʊr a zim, ŋnɩ bɩ wɔɔ bɔ.» ");
INSERT INTO bib_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Gʊɔɔ wɔɔ n a wusigə, ŋn'aa naa haay hɩ dʊdɔkənno wɔɔ m, nyibəə n gasʊ ŋ ʊ, kʊ y'a hɩ ŋ nɩ, ŋ ʊ Rɔm zannɔ n a mɩ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ŋ n bʊr, ŋnɩ bɩ sugur yɛ ŋ han, ŋnɩ ŋ bɔ, ŋn'a yɛ ŋ han, kʊ ŋ nɩ bɔ tara bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kʊ ŋ bɔ lɔnnɔcɛ ʊ b'ʊ bɩ, Pol kan Silas kɩ ta, ŋn'aa Lidii yɩ, ŋnɩ danyɩnɔ wɔɔ yɩ ŋnɩ ŋ heer ba kookoo, ŋnɩ cem. ");
INSERT INTO bib_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ŋ bɔ Anfipolis ʊ kan Apolonii kɩ, ŋn'aa lee ku Tesaloniki ʊ. Zɩɩfʊrɔ wɔɔ sokʊmacɛ n nɩ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Amb'a tɩr a ba biisi bɩ, Pol ta, an aa ŋ yɩ, an sʊʊra ba kan ŋ kɩ *sabaa hinni ʊ, an a ta kʊ rɛ gallɛm kaakʊ, an nɩ Wosoci bɩ ");
INSERT INTO bib_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","bɔrɛ ŋ nɩ kʊ zi, a ʊ Krista a ga m, an fɩr yɩ, an ga, an a mɩm bɔ ʊ gəəno bire ʊ. A n n'a hɩrɛ, a ʊ: «Krista kʊ mɔɔ n'a pa darɛ awɔɔ m bɩ, Yeezuu m.» ");
INSERT INTO bib_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Zɩɩfʊrɔ gɔsɩnnɔ yɛ, ŋn'a zɛ kʊ ra kan Pol kɩ Silas kɩ, kan grɛkkɩrɔ kʊ ŋ nɩ Woso daŋ ʊ rɔ wɔɔ kɩ gʊta, kan lannɔ tɔzannɔ kɩ gʊta. ");
INSERT INTO bib_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Zɩɩfʊrɔ wuti kan jɩmbaa heerbusu kɩ, ŋnɩ gʊɔɔ nɩbɩɩrɔ gaa zaa bire ʊ, ŋn'a ka tara bɩ gʊɔɔ wɔɔ n yar, ŋnɩ taranɔ bɩ nya kʊ rɛ. Ŋ n ta Zasɔn har ʊ, ŋn'a kam Pol ma kan Silas kɩ, k'a ŋ gaa a ta ŋ nɩ gʊɔɔ wɔɔ taa. ");
INSERT INTO bib_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kʊ ŋ n ŋ yɩ bɩ, ŋ Zasɔn gaa kan danyɩnɔ gɔsɩnnɔ kɩ, ŋnɩ ta ŋ nɩ dʊdɔkənno taa, ŋn'ɩ zee darɛ, ŋ ʊ: «Gʊɔɔ nɔɔn duro nɩ durnya bɩ dam, ŋnɩ cem ŋnɩ bʊr naa ʊ kɛɛrɛ, ");
INSERT INTO bib_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Zasɔn n ŋ si a har ʊ. Ŋ haay kaanm Rɔm cir lɛ m, ŋ ʊ, cir vanta n ta ʊ, a tɔ m Yeezuu.» ");
INSERT INTO bib_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Zeero nɔɔn duro gʊɔɔ wɔɔ da bɔ ʊ, kan dʊdɔkənno wɔɔ kɩ, ");
INSERT INTO bib_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ŋnɩ busoo si Zasɔn kan danyɩnɔ wɔɔ kɩ han, ŋn'a cɩnta, ŋnɩ bɔkarɛ, ŋnɩ wɔ saa ŋ ma. ");
INSERT INTO bib_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Lɛɛm bɩ, danyɩnɔ wɔɔ a ka Pol kan Silas kɩ n cem kan Beree kʊ kɩ gunuu ʊ. Kʊ ŋ lee ku bɩ, ŋ ta zɩɩfʊrɔ sokʊmacɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Zɩɩfʊrɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ mɩŋŋa, an lɛ da Tesaloniki zannɔ wɔɔ ra. Ŋ lemim bɩ si kan a heer kɩ haay. Dɔmɩm haay, ŋ yɩ dɩgam Wosoci b'ʊ, k'a dɩga a hɔ kʊ ŋ n'a hɩm bɩ sɩra m gɛ. ");
INSERT INTO bib_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Gʊta a ba sɩrakarɛzannɔ ŋ bire ʊ kan grɛkkɩ lannɔ tɔzannɔ kɩ, gʊɔɔyaarɔ kɩ gʊta. ");
INSERT INTO bib_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tesaloniki zɩɩfʊrɔ wɔɔ kʊ ŋ y'a ma, ŋ ʊ, Pol ɩ Beree ʊ an nɩ Woso lemim pa dam bɩ, ŋ lee ku b'ʊ, k'a a ya, a gʊɔɔ nyʊnnyɔɔta. ");
INSERT INTO bib_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Danyɩnɔ wɔɔ n a ba zɔɔ, ŋnɩ Pol da zaa ra an ta kan higʊta bɩ lɛ ra kɩ, bɩ ma bɩ, Silas kan Timote kɩ gɔɔta b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Gʊɔɔ kʊ ŋ Pol da zaa ʊ rɔ wɔɔ a gaa ŋnɩ ta m Atɛnnɩ ʊ, ŋn'a wusigə kan Pol lɛ kɩ, kʊ Silas kan Timote kɩ n a jɩ sa zɔɔ-zɔɔ. ");
INSERT INTO bib_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol k'a nɩ dɔrɛ ŋ ma Atɛnnɩ ʊ bɩ, a heer a zar kan *wosobaawɔnnɔ kʊ ŋ nɩ tara bɩ nɔ ʊ, ŋnɩ ŋ daŋ ʊ rɔ wɔɔ kɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","A n gasʊ sokʊmacɛ deem ʊ, an nɩ meer bam kan zɩɩfʊrɔ wɔɔ kɩ, kan gʊɔɔ kʊ ŋ nɩ Woso daŋ ʊ rɔ wɔɔ kɩ, dɔmɩm haay daasɩrɔ ʊ, a y'a bam kan gʊaa haay k'a nɩ zɛm bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Hɔɔnkamazannɔ, Epikiriyɛɛnrɔ kan Stoyisɛɛnrɔ kɩ, nyɩnta b'ʊ ŋn'ɩ sʊʊra bam kan kɩ. Gɔsɩnnɔ n'a hɩrɛ, ŋ ʊ: «Para-paradarɛzaa naa do ʊ lɔ?» Gɔsɩnnɔ ʊ: «Wosoro daarɔ an nɩ ŋ pa darɛ!» Kʊ sɩra nɩ, Pol ɩ Yeezuu pa dam, kan a mɩmbɔʊrɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ŋ n a nyasʊ k'a ta m ci kʊ n n'a birm Arewopaazɩ bɩ mim ʊ. Ŋ n a hɩ, ŋ ʊ: «Ɩbɩɩ ɩ da ma, ɩ karɩnda daa k'ɩbɩɩ n'a bam naa jɩ dɩnda wɔɔ n na? ");
INSERT INTO bib_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Bala, ɩbɩɩ ɩ minno daarɔ dɩndam wɔɔ m, bɩ y'a ka wɔɔ lɛ n taa k'ʊ ŋ jɩ dɔ.» ");
INSERT INTO bib_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atɛnnɩ zannɔ wɔɔ kan saanarɔ kɩ bɩr hɔsɩ bam, kʊ minno daarɔ dɩndarɛ kan a tʊr ka ma kɩ bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pol n jɩm brama Arewopaazɩ ʊ b'ʊ, a ʊ: «Atɛnnɩ zannɔ, dɩga kʊ mɔɔ nawʊm awɔɔ ma naa, sɩrakarɛzannɔ gʊtɔɔ n'awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kʊ mɔɔ m da awɔɔ kʊ bɩ zi bɩ, hɔ haay k'a n'awɔɔ yaadarɛ mɔr bɩ, mɔɔ yɩ. Mɔɔ yɩ, n n a gʊrsɩra ba mannɩduu niŋŋə ma ncɩnaaʊ: ‹Woso kʊ gʊaa n a dɔ minto.› Hɔ k'awɔɔ n'a daŋ ʊ, b'awɔɔ n a dɔ bɩ, bɩ mɔɔ bʊr kʊ m b'a pa da awɔɔ m naa. ");
INSERT INTO bib_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Woso k'a durnya da, kan hɔ haay k'a n'a nɔ ʊ bɩ kɩ, a m brama kan tara kɩ Zuuba. A bɩr gasʊm wosocɛrɔ kʊ gʊɔɔ a dɔ a wɔ m nɔ wɔɔ nɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Hɔsɩ zibəə ba ma y. A bɩr a kam ma kʊ gʊaa n a da a han hɔ niŋŋə ma y. Bala, a n nɩ mɩsɩrbaa, hoonsi, kan hɔ haay kɩ kam gʊaa haay ʊ. ");
INSERT INTO bib_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","K'an gʊaa deem mɛ kɩ, a do haay da kʊ ŋ nɩ bɩr tara burə lɛɛ haay ʊ. A dɔmɩnnɔ bɔ kʊ zi gʊɔɔ minto, kan ŋ tararɔ jirə kɩ, ");
INSERT INTO bib_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","kʊ ŋ n'a da ma, ŋn'a wɔ dɩnda, ŋn'a ka Woso ma, gɛɛ ŋ y'a yɩm gɛ, an bɔkarɛ a bɩ laatʊ wɔɔ gʊaa biyəə ma y. ");
INSERT INTO bib_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Bala, A mɩŋŋa zi wɔɔ mɩsɩrbaa n ta ʊ, ʊ nɩ tarɛ, ʊ nɩ meeyaa m. Amba awɔɔ gʊrsɩrabənno gɔsɩnnɔ a hɩ bɩ m: ‹A dogʊɔɔ m wɔɔ m.› ");
INSERT INTO bib_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kʊ Woso dogʊɔɔ m wɔɔ m bɩ, wɔɔ n ʊ ga m, ʊ ʊ hɔɔn da, ʊ ʊ, Woso bɩ sarma nɩ, gɛɛ wanzurfu, gɛɛ jaa kʊ gʊaa a banka, an a bɔ ʊ a hɔɔn ʊ bɩ nɩ y. ");
INSERT INTO bib_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Bɩ, Woso n a ya, an nɩ dɩgam dɔmɩm kʊ gʊɔɔ wɔɔ nɩ badɔ nɔ ʊ bɩ ma y. A y'a hɩrɛ ŋ nɩ kɛɛrɛ, kʊ ŋ haay n a bɔ a mimbʊnyaarɔ ʊ bɩncɛ haay ʊ. ");
INSERT INTO bib_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","A dɔmɩm deem bɔ ʊ, an a cɩnta, kʊ gʊaa k'a bɔ ʊ bɩ n bɩ durnya dʊdɔ ka kan sɩra kɩ. Bɩ, a a kasɛtɩ hɩnka gʊɔɔ haay m, an a mɩm bɔ ʊ gəəno bire ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Gəəno mɩmbɔʊrɛ mim kʊ ŋ b'a ma bɩ, gɔsɩnnɔ ɩ yaa wʊm Pol ma, niŋŋoo n n'a hɩrɛ, ŋ ʊ: «K'ʊ mim naa do minto m, wɔɔ y'ʊ yarɛ, ʊ tʊr ka ɩbɩɩ ma dɔmɩm vanta ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","A yɩ ncɩnaaʊ, Pol n a gʊ ŋ ma. ");
INSERT INTO bib_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Gɔsɩnnɔ n bɔkarɛ, ŋnɩ yɛ a meerbaa bɩ ma, ŋn'a ba sɩrakarɛzannɔ. Arewopaazɩzaa Denii nyɩnta ʊ, kan lʊ deem kʊ n n'a birm Damariisi bɩ kɩ, kan gɔsɩnnɔ kɩ sɔ. ");
INSERT INTO bib_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bɩ jɛ ʊ bɩ, Pol a hʊr Atɛnnɩ ʊ, an ta Korɛntɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","B'ʊ bɩ, a zɩɩfʊ deem zɛ ʊ, a tɔ m Akilas. Pɔn kʊ gʊaa m, an a to Italii ʊ lɛɛm an bʊr kan a lʊ Prisil kɩ. Kʊ sɩra nɩ, cir Kloodɩ lɛ ka, kʊ zɩɩfʊrɔ haay n bɔ *Rɔm ʊ. Pol n kʊ ma kan ŋ kɩ, ");
INSERT INTO bib_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","bɩ, kʊ wɔzibəə deem ŋ n'a bam bɩ, (zappabaa m,) a zer ŋ har ʊ, ŋn'ɩ zi bɩ bam kan kʊ kɩ. Huucɛrɔ pɛɛrarɔ ŋn'ɩ ŋ barɛ. ");
INSERT INTO bib_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","*Sabaa hinni haay, a ɩ karɩnda dɩndam zɩɩfʊrɔ sokʊmacɛ b'ʊ, an n'a tɔŋ ʊ kan zɩɩfʊrɔ wɔɔ kɩ grɛkkɩrɔ wɔɔ kɩ, kʊ ŋ n'a si. ");
INSERT INTO bib_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas kan Timote kɩ kʊ ŋ y'a to Masedʊan ʊ, ŋnɩ lee ku bɩ, ŋ bɩ dɩga a Pol ɩ karɩnda bam, an n'a hɩm zɩɩfʊrɔ wɔɔ m, a ʊ Krista bɩ, Yeezuu m. ");
INSERT INTO bib_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Zɩɩfʊrɔ wɔɔ bɩsɩ ka kan Pol kɩ, ŋnɩ meerbaa bʊnyaa ba. Pol n a huuro zɛ fər, an a hɩ ŋ nɩ, a ʊ: «K'awɔɔ n bʊmbɔrɛ yɩ, a taar y'awɔɔ mim ʊ. Mɔɔ mim bɛɛ m bɩ dɔ y. Naa ma kɛɛrɛ bɩ, ta mɔɔ nawʊm do vantɔɔ zi.» ");
INSERT INTO bib_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","A n a hʊr bɩncɛ bɩ do ʊ, an ta gʊaa kʊ n n'a birm Titiyus Zistus bɩ har ʊ. Woso daʊrɛzaa m, a har bɩ n jɩnjɛɛm sokʊmacɛ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus k'a m sokʊmacɛ bɩ cir b'a ba sɩrakarɛzaa kan a har gʊɔɔ kɩ haay. Korɛntɩ zannɔ gʊtɔɔ, kʊ ŋ n'a tʊr kam Pol ma rɔ wɔɔ, a ba sɩrakarɛzannɔ sɔ, ŋnɩ batɛm si. ");
INSERT INTO bib_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Gum deem ʊ, Zuuba a hɩ Pol m, a hɔhɩnkarɛ nɔ ʊ, a ʊ: «Ɩ da bɩ bɔ ʊ y, ɩ bɩr a hɩm, ɩ bɩ zɛ pi y. ");
INSERT INTO bib_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kʊ sɩra nɩ, mɔɔ ɩ kan ɩbɩɩ kɩ, bɩ gʊaa ba ʊ, an n'ɩbɩɩ nyasʊm k'a fɩr ka ɩ ma y, bala, mɔɔ gʊɔɔ ta ʊ gʊta tara naa do nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pol dɔɔraa ba b'ʊ deem kan a kur kɩ, an nɩ Woso lemim dɩndarɛ ŋ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Dɔmɩm kʊ Galɩyɔn nyɩnta ʊ Akayii tara lɛɛzaa bɩ, zɩɩfʊrɔ wɔɔ a lɛ ba deem, ŋnɩ wuti jɩmbaa m kan Pol kɩ, ŋn'a gaa, ŋnɩ ta m Galɩyɔn dʊdɔkarɛ bɩncɛ ʊ, ŋn'a hɩrɛ, ŋ ʊ: ");
INSERT INTO bib_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«Gʊaa naa do, karɩnda an n'a bam gʊɔɔ m, a ʊ, gʊɔɔ n yaa da Woso m kan yaadarɛ k'a n a gaakʊmba kan wɔɔ lɛrɔ kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol ʊ k'a nyɩ bɔ ʊ, Galɩyɔn n a nyɩ bɔ zɩɩfʊrɔ wɔɔ nʊ, a ʊ: «Zɩɩfʊrɔ ra, kʊ zi niŋŋə a ba a bɩ tɩrga, gɛɛ zibəə bʊnyaa a ba, mɔɔ yɩ m tʊr karɛ awɔɔ ma, bala, a a yɔ. ");
INSERT INTO bib_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Bɩ, k'awɔɔ bɩsɩ bɩ karɛ bɩ, meerbaa m, gɛɛ tɔrɔ m, gɛɛ awɔɔ mɩŋŋɔɔ lɛrɔ m bɩ, pakra a ba awɔɔ m. Mɔɔ lɛ baa kʊ m nyɩnta minno nɔɔn duro dʊdɔkər y.» ");
INSERT INTO bib_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","A n la ŋ la dʊdɔkarɛ bɩncɛ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ŋ haay n Sɔstɛn, sokʊmacɛ cir bɩ nyasʊ, ŋn'a zɛ dʊdɔkarɛ bɩncɛ ʊ b'ʊ, bɩ, Galɩyɔn n a war hɔbaa naa do ma y. ");
INSERT INTO bib_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol a ya, an maasɩrɛ ba Korɛntɩ ʊ. Bɩ jɛ ʊ bɩ, a a gʊ danyɩnɔ wɔɔ ma, an da kɔɔlʊʊ ʊ, k'a ta Siirii ʊ. Akilas kan Prisil kɩ zu kʊ ʊ kan kɩ. Pol a mim zɩnzɛra Sɛnkrɛs ʊ, bala, a ler bɔ Woso m. ");
INSERT INTO bib_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ŋ lee ku Efɛɛzɩ ʊ. B'ʊ bɩ, Pol a gʊ a zukuuzannɔ wɔɔ ma. A ta, an aa gasʊ zɩɩfʊrɔ sokʊmacɛ ʊ b'ʊ, an nɩ bɩsɩ kam kan ŋ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Brɔɔ n a yɛ han kan a dɔmɩm bɩ zu ra, an a gu, ");
INSERT INTO bib_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","an a gʊ ŋ ma, an n'a hɩrɛ, a ʊ: «Mɔɔ zɛm bɩ bʊr awɔɔ zi dɔmɩm niŋŋə ʊ, kʊ Woso yɛ.» A n da kɔɔlʊʊ ʊ, Efɛɛzɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","K'a lee ku Sezaree ʊ an bɔ kɔɔlʊʊ b'ʊ bɩ, a cem an ta Zerizalɛm ʊ, an aa yaa da danyɩnɔ wɔɔ m, an cem an ta Antɩyɔs ʊ, ");
INSERT INTO bib_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","an aa maasɩrɛ ba b'ʊ poore. A n cem, an ta Galasii kan Frizii kɩ gʊrgarɔ haay ʊ, an nɩ karɩndanyɩnɔ wɔɔ haay heer bam kookoo. ");
INSERT INTO bib_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Zɩɩfʊ deem kʊ n n'a birm Apolɔs, an yɩ Alɛsandrii ʊ bɩ lee ku Efɛɛzɩ ʊ. Hɔɔn zaa m, an mim dɔ. A n Wosoci bɩ dɔ sɔ. ");
INSERT INTO bib_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Zuuba zaa b'a dɩnda zʊr-zʊr, a y'a pa darɛ kan a heer kɩ haay, an nɩ karɩnda dɩndam gʊɔɔ m, an nɩ hɔ haay k'a ba Yeezuu minto bɩ dɩndam, an nɩ zure a zaa ʊ. Bɩ, batɛm kʊ Zaan nyɩnta an a kam b'a dɔ bala. ");
INSERT INTO bib_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","A n nɩ meer bam kan wɩsɩrabaa kɩ sokʊmacɛ ʊ b'ʊ. Prisil kan Akilas kɩ kʊ ŋ y'a meerbaa ma bɩ, ŋ y'a gaa, ŋnɩ Woso zaa bɩ dɩnda m zʊr-zʊr, ŋn'a paŋŋa da ra. ");
INSERT INTO bib_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","K'a nyɩnta, an n'a ŋʊam k'a ta Akayii ʊ bɩ, danyɩnɔ wɔɔ ʊ: A a ga m. Ŋ n ci ba karɩndanyɩnɔ wɔɔ ma, kʊ ŋ n'a si mɩŋŋa. K'a lee ku b'ʊ bɩ, a daahan gʊta ka gɔsɩnnɔ ʊ, gʊɔɔ kʊ Woso barka minto ŋ sɩra ka Yeezuu ʊ rɔ wɔɔ. ");
INSERT INTO bib_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Bala, a meerbaa bɩ paŋŋa bʊr zɩɩfʊrɔ wɔɔ ra gʊɔɔ wɔɔ bire ʊ, a ɩ Wosoci bɩ jɩ hɩrɛ ŋ nɩ sɩrɩɩ-sɩrɩɩ, a ʊ: Krista bɩ, Yeezuu m. ");
INSERT INTO bib_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Dɔmɩm kʊ Apolɔs nyɩnta ʊ Korɛntɩ ʊ bɩ, Pol bɔ kʊ bɩ gʊrgarɔ kʊ ŋ nɩ cigaarɔ wɔɔ ʊ, an ta Efɛɛzɩ ʊ, an karɩndanyɩnɔ gɔsɩnnɔ yɩ b'ʊ, ");
INSERT INTO bib_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","an ŋ lar, a ʊ: «K'awɔɔ a ba sɩrakarɛzannɔ bɩ, awɔɔ Sɛnt-Ɛspri si ra?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Wɔɔ n Sɛnt-Ɛspri mim ma cɩna y.» ");
INSERT INTO bib_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pol n laaka da, a ʊ: «Batɛm kara awɔɔ si kɛɛrɛ?» Ŋ n a nyɩ bɔ ʊ, ŋ ʊ: «Zaan batɛm bɩ m.» ");
INSERT INTO bib_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol n a hɩ ŋ nɩ, a ʊ: «Zaan nyɩnta, an nɩ heerlʊrlɛ batɛm kam, an n'a hɩm gʊɔɔ m kʊ ŋ nɩ sɩra ka gʊaa k'a nɩ zɛm bɩ bʊr awɔɔ jɛ ʊ b'ʊ. A lɛ taa k'a hɩ, a ʊ: Yeezuu.» ");
INSERT INTO bib_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kʊ ŋ naa ma bɩ, ŋ batɛm si Zuuba Yeezuu tɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pol n a wɔrɔ ka ŋ la, Sɛnt-Ɛspri n zer ŋ la, ŋn'ɩ meer bam leminno vantɔɔ m, ŋn'ɩ Woso lɛ si ŋn'ɩ som la. ");
INSERT INTO bib_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Gʊɔɔ kʊ ŋ nyɩnta b'ʊ rɔ wɔɔ lɛ a zɔ bueerehɩɩya ma. ");
INSERT INTO bib_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol tɩr ta sokʊmacɛ ʊ, an bɩr Woso cirbəə bɩ mim dɩndam kan wɩsɩrabaa kɩ, an ta an mom kaakʊ ku. Kʊ gʊɔɔ kʊ ŋ n'a tʊr kam nɔ wɔɔ n a si sɩra. ");
INSERT INTO bib_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Gɔsɩnnɔ kʊ ŋ heer ka, ŋ bɩr yɛm k'a si bɩ, ŋ nyɩnta, ŋn'ɩ Yeezuu zaa bɩ sʊnsɔ wʊm gʊɔɔ bire ʊ. Pol n bɔ ŋ bire ʊ, an karɩndanyɩnɔ wɔɔ gaa a hɔ, an ta ŋ nɩ Tiranɔsɩ karɩndacɛ ʊ, an nɩ hɔ dɩndarɛ ŋ nɩ dɔmɩm haay. ");
INSERT INTO bib_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","A ba a ʊ ncɩnaaʊ an ta, an dɔɔraa hɩɩya ku, bɩ minto y'a ka Azii zannɔ, zɩɩfʊrɔ, kan grɛkkɩrɔ kɩ n a ku, ŋnɩ Zuuba lemim bɩ ma. ");
INSERT INTO bib_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Woso n nɩ hoserlo kʊ ŋ lɔɔ ba ʊ bam kan Pol kɩ. ");
INSERT INTO bib_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Baa kʊ n pɛɛra gɛɛ huu a nɔ a mɛ ma, n a nɔ yaabazannɔ ma, ŋ yɩ laafɩɩ yɩrɛ, zinəro wɔɔ nɩ bɔrɛ ŋ mɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Zɩɩfʊrɔ gʊɔɔ n ta ʊ ŋnɩ bɩmbɩrm, ŋn'a dam ma, ŋn'ɩ lam zinəro ra. Hindeem ʊ ŋ n'a ŋʊa k'a la zinəro ra gʊɔɔ mɛ ʊ Zuuba Yeezuu tɔ m. Ŋ n'a hɩrɛ, ŋ ʊ: «Mɔɔ y'a hɩrɛ awɔɔ m Yeezuu kʊ Pol n n'a pa dam bɩ tɔ ma, k'a bɔ!» ");
INSERT INTO bib_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Zɩɩfʊrɔ wosocɛmannɩbər jɩtaarɛ deem kʊ n n'a birm Seva b'ɩ nyɩnɔ m saanhɩna, ŋn'ɩ zibəə naa do barɛ. ");
INSERT INTO bib_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Zinə n a hɩ ŋ nɩ, a ʊ: «Mɔɔ Yeezuu dɔ, kʊ nka m Pol m, mɔɔ dɔ. B'awɔɔ, nkɔɔ n'awɔɔ nɩ?» ");
INSERT INTO bib_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Gʊaa kʊ zinə n a mɛ ʊ bɩ n der ŋ ma haay, an a da ŋ ma, an fɩr ka ŋ ma, ŋnɩ bra si, ŋnɩ bɔ har ʊ b'ʊ dɩgɩ, kan nyinno kɩ. ");
INSERT INTO bib_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efɛɛzɩ kʊ jilli, zɩɩfʊrɔ kan grɛkkɩrɔ kɩ kʊ ŋ nɩ b'ʊ rɔ wɔɔ haay mim naa do ma. Nyibəə n gasʊ ŋ haay ʊ, ŋn'a lɛ bɔ Zuuba Yeezuu tɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Gʊɔɔ kʊ ŋ sɩra ka ʊ rɔ wɔɔ barla, gʊta bʊr, ŋn'a leer busu brama, ŋn'a minno bɔrɛ a lɛ ma. ");
INSERT INTO bib_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Gʊɔɔ gʊta kʊ ŋ gɔɔta, ŋn'a mɩŋŋa ka wɔkure ʊ rɔ wɔɔ a ciro wɔɔ gʊr, ŋnɩ bɩ ŋ so kʊ ra, ŋnɩ sɛ nya ŋ ʊ, gʊaa haay taa. Ciro wɔɔ haay kʊ ŋ y'a busoo lɛ zɛ bɩ, a wanzurfu busoo ma waa busoor. ");
INSERT INTO bib_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ncɩnaaʊ bɩ, kan Zuuba paŋŋa kɩ, lemim bɩ nɩ tam lɛɛ, a paŋŋa n'a dam la. ");
INSERT INTO bib_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Minno nɔɔn duro kʊ ŋ cem bɩ, Pol a cɩnta a hɔɔn ʊ, k'a bɔ Masedʊan ʊ kan Akayii kɩ ʊ, a ta Zerizalɛm ʊ. A n n'a hɩrɛ, a ʊ: «K'a lee ku b'ʊ, k'a cem a ta Rɔm ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","A a daahanzannɔ hɩɩyɔɔ Timote kan Erastɩ kɩ nyɔɔ Masedʊan ʊ, a mɩŋŋa n gɔɔta Azii ʊ an maasɩrɛ ba poore. ");
INSERT INTO bib_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Dɔmɩm bɩ do ʊ, nyaarɔ gʊtɔɔ bɩ wuti ŋnɩ ba Zuuba zaa bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nyɔkka deem n nɩ b'ʊ a tɔ m Demetrus, an nɩ Artemis yaadarɛcɛ nyʊgɔrɔ bam wanzurfu m kan nyɔkkarɔ vantɔɔ kɩ, ŋn'ɩ busoo yɩm gʊta. ");
INSERT INTO bib_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","A nyɔkkarɔ wɔɔ duro so kʊ ma kan tar deem zibəəzannɔ kɩ, a ʊ: «M gʊaasɩbɔɔ, awɔɔ dɔ a ʊ, wɔɔ wɔzibəə naa do nɩ hɔbɩrɛ kam wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","B'awɔɔ yɩ, an n'a mam: Efɛɛzɩ nɔ bɛɛ m bala y, Azii ʊ haay Pol naa do n'a dɩndam gʊɔɔ haay m, a ʊ, wosoro kʊ wɔɔ nɩ ŋ barɛ ʊ wɔ m nɔɔn duro, wosoro bɛɛ y. Gʊɔɔ gʊta ŋn'ɩ zure a hɔ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Wɔɔ zibəə bɩ zarlɛ minto bɩ bɛɛ wɔɔ nɩ nyi bam nɩ bala y, wɔɔ wosolʊ gʊta Artemis cɛ bɩ bɔʊrɛ m. Bala, Artemis kʊ Azii zannɔ kan durnya naa haay kɩ n'a daŋ ʊ bɩ, a bɩ daʊrɛ yɩm dɔ y.» ");
INSERT INTO bib_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kʊ ŋ naa ma bɩ, ŋ heer busu, ŋnɩ zee da, ŋn'a hɩrɛ, ŋ ʊ: «Efɛɛzɩ zannɔ Artemis n gʊta!» ");
INSERT INTO bib_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mim naa do a kərgu kʊnɔ bɩ haay ra, an a zɛ kʊ ma, ŋnɩ bra si, ŋnɩ ta sarbarɛ bɩncɛ ʊ b'ʊ, ŋnɩ Masedʊan zannɔ Gayus kan Aristarkɩ kɩ kʊ ŋ nɩ Pol zukuuzannɔ wɔɔ nyasʊ, ŋnɩ ta ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol n a cɩnta, k'a ta sokʊma bɩ bɩncɛ ʊ. Bɩ, karɩndanyɩnɔ wɔɔ n a to an ta y. ");
INSERT INTO bib_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Azii cinno gɔsɩnnɔ k'a gʊaasɩbɔɔ m nɔ wɔɔ nyɔɔ da kʊ n n'a hɩ m, ŋ ʊ: a b'a ka a mim ma, a ʊ, ta a ʊ sarbarɛ bɩncɛ ʊ b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lɛɛ bɩ n a ba bʊrgʊ. Gʊaa biyəə n'a hɔɔnhɔ hɩm, tatʊr ŋ n'a bam bala, gʊɔɔ gʊta n a dɔ kʊ bɔ minto m, a a so kʊ ma y. ");
INSERT INTO bib_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Gʊɔɔ ɩ nyɩnta sokʊma bɩ bire ʊ, ŋnɩ mim bɩ dɩnda Alɛsandɩr kʊ zɩɩfʊrɔ wɔɔ a bɔ ʊ n a ka lɛɛ bɩ m. Alɛsandɩr n a wɔ busu, k'a meer ba kan zamaa bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kʊ ŋ y'a dɔ, ŋ ʊ zɩɩfʊ m bɩ, ŋ haay a lɛ ba deem, ŋn'ɩ zee dam. Ŋ zee bɩ darɛ wakatɩ hɩɩya ku. Ŋ ʊ: «Efɛɛzɩ zannɔ Artemis n gʊta!» ");
INSERT INTO bib_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Gʊrsɩrabər b'a gu an a da ma, an gʊɔɔ wɔɔ da bar ʊ, a ʊ: «Efɛɛzɩ zannɔ, gʊaa ta ʊ, a n a dɔ, a ʊ, Efɛɛzɩ kʊ zannɔ nɩ dɔm Artemis gʊta cɛ bɩ ma, kan a jaa k'a a to brama an a da bɩ kɩ ra? ");
INSERT INTO bib_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kʊ ŋ n bɩsɩ ka hɔ naa do ma bɩ, a a ga m, awɔɔ m bʊr a ma, a b'a ka, a ba zɔɔ-zɔɔ y. ");
INSERT INTO bib_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Awɔɔ bʊr gʊɔɔ m naa ʊ, ŋ n mim zu ʊ wɔɔ wosolʊ bɩ ma y, ŋ n a sʊnsɔ wʊ sɔ y. ");
INSERT INTO bib_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kʊ Demetrus kan zibənno wɔɔ kɩ ɩ mim m kan gʊaa kɩ, dʊdɔkarɛ dɔmɩm ta ʊ. Taralɛɛzannɔ ta ʊ. K'a ta kʊ m dʊdɔkarɛ bɩncɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kʊ minno gɔsɩnnɔ ta ʊ kʊ kʊ bɩ gʊɔɔ a so kʊ ma, ŋ dɩgam minno wɔɔ duro ma. ");
INSERT INTO bib_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Her naa, mim b'a da ma, an yɩ bʊnyaa kan wɔɔ kɩ. Bala, n y'a da ma, n nɩ mim ka wɔɔ ra sokʊma naa do minto. Sokʊma naa do jɩ ba ʊ y, kʊ n wɔɔ lar wɔɔ bɩ hɔsɩ yɩm ʊ a hɩ y.» ");
INSERT INTO bib_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Bɩ, naa k'a hɩ bɩ, a gʊɔɔ wɔɔ da zaa ra. ");
INSERT INTO bib_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Bʊgʊr bɩ k'a b'a da bar ʊ bɩ, Pol karɩndanyɩnɔ wɔɔ so kʊ ma, a nɩ ŋ dʊndɔ. Bɩ jɛ ʊ bɩ, a a leer so ŋ nɩ, an Masedʊan zaa sa. ");
INSERT INTO bib_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","A a da a gʊrgarɔ zi, an danyɩnɔ wɔɔ dʊndɔ gʊta, an bɔkarɛ an lee ku Grɛsɩ ʊ, ");
INSERT INTO bib_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","an aa nyɩnta b'ʊ mom kaakʊ. Dɔmɩm k'a nɩ daŋ ʊ kɔɔlʊʊ ʊ k'a ta Siirii ʊ bɩ, zɩɩfʊrɔ wɔɔ kʊ ŋ kʊ ma k'a nyasʊ bɩ, a a hɔɔn da, an a bɔ an bɔ Masedʊan ʊ. ");
INSERT INTO bib_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Gʊɔɔ kʊ ŋ zu kʊ ʊ kan kɩ rɔ wɔɔ, Beree kʊ gʊaa Piirus nyɩ Sopatrɔs kan Tesaloniki kʊ gʊɔɔ Aristarkɩ kan Sekundus kɩ, Derbe kʊ gʊaa Gayus kɩ, kan Timote kɩ, kan Azii kʊ gʊɔɔ Tisikkɩ kɩ, Trofim kɩ sɔ. ");
INSERT INTO bib_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Gʊɔɔ nɔɔn duro lɛɛ ka lɛɛ, ŋnɩ ta, ŋn'ɩ dɔm wɔɔ ma Trowas ʊ. ");
INSERT INTO bib_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kʊ wɔɔ nɩ, wɔɔ ʊ hʊr Filipii ʊ, bur kʊ n n nyʊnyɔɔ da ma bɩ dɔmɩnnɔ kur, ʊ da kɔɔlʊʊ ʊ k'ʊ aa n ŋ ku. Dɔmɩm soor jɛ ʊ bɩ, wɔɔ lee ku Trowas ʊ. Wɔɔ n gɔɔta b'ʊ dɔmɩm saanhɩna. ");
INSERT INTO bib_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Hatʊ hinni ʊ, wɔɔ ʊ zɛ kʊ ra, k'ʊ bur zɩnzɛ ra. A dɔ k'a nɩ mɛm kʊ Pol n a hʊr bɩ, a meerbaa sa, an n'a bam kan danyɩnɔ wɔɔ kɩ, meerbaa bɩ maasɩrɛ ba, an ta an a zɔ dibsir zeezi ma. ");
INSERT INTO bib_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Fɩtɩrɛrɔ nyɩnta ʊ gʊta cɛmim kaakʊ hɔ kʊ wɔɔ ʊ so kʊ ma ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nyukumbueere deem k'a tɔ m Etikɩ bɩ nyɩnta cɛ bɩ tokoro lɛ ra, hinceem gʊta n a nyasʊ. Bɩ ma bɩ, Pol meerbaa bɩ n nya y. Hinceem bɩ k'a a nyasʊ gʊta bɩ, a bra cɛmim kaakʊ hɔ b'ʊ, an a da tara ʊ. Kʊ ŋ bʊr k'a b'a busu bɩ, ŋ yaa dɩga a a ga. ");
INSERT INTO bib_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol n zer, an bra si an ta zi, an aa a busu a za ʊ, an n'a hɩrɛ, a ʊ: «A da bɩ bɔ ʊ y. A mɩsɩr!» ");
INSERT INTO bib_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pol k'a a bɔ an der bɩ, a bur bɩ zɛ ra, an a bɩ. Bɩ jɛ ʊ bɩ, a meerbaa bɩ maasɩrɛ ba an ta an wutigʊta ku. Bɩ kur bɩ, a cem. ");
INSERT INTO bib_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bɩ, nyukumbueere k'a mɩm bɔ ʊ bɩ, ŋ y'a gaa, ŋnɩ doo m. B'a yɩ heernyɔɔ gʊta, ŋ haay minto. ");
INSERT INTO bib_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Wɔɔ kɔɔlʊʊ sa, ʊ lɛɛ ka lɛɛ, k'ʊ aa zer Asɔs ʊ, kʊ aa Pol k'a zaa sa a gam ma bɩ zɛ ʊ b'ʊ, ʊ a busu, amba a cɩnta bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","K'a wɔɔ zɛ ʊ Asɔs ʊ bɩ, wɔɔ busu kɔɔlʊʊ b'ʊ k'ʊ ta Mitilɛnnɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","B'ʊ bɩ, dɔ k'a mɛ bɩ, wɔɔ da kɔɔlʊʊ b'ʊ, ʊ ʊ zɔ Kiyo ma. A dɔmɩm hɩɩya hinni ʊ, wɔɔ bɔ Samɔs ʊ, bɩ dɔ k'a mɛ bɩ, wɔɔ jɩm poore Trogiliyɔn ʊ, ʊ cem, ʊ lee ku Milɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol a cɩnta k'a bɩ jɩm Efɛɛzɩ ʊ y, k'a lɛ baa k'a maasɩrɛ ba Azii ʊ bɩ minto. Nyɩnta a ʊ, an n'a bam zɔɔ-zɔɔ k'a a da ma, k'a lee ku Zerizalɛm ʊ, Pantɩkɔtɩ dɔmɩm bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pol a to Milɛ ʊ, an Efɛɛzɩ kristagʊɔɔ sokʊma lɛɛzannɔ wɔɔ bir. ");
INSERT INTO bib_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kʊ ŋ b'a zɛ ʊ bɩ, a a hɩ ŋ nɩ, a ʊ: «Awɔɔ mɩsɩrbaa kʊ mɔɔ ba dɔmɩm haay, mɔɔ leekure sɩŋŋɩda ʊ Azii ʊ bɩ dɔ. ");
INSERT INTO bib_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mɔɔ Zuuba zi ba kan mɩŋŋa zerle kɩ, kan nyifeer kɩ, kan fɩryɩrɛ do haay kʊ zɩɩfʊrɔ a cɩnta k'a mɔɔ nyasʊ, a mɔɔ zɛ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mɔɔ n hɔsɩ k'a zibəə m ta awɔɔ ma bɩ nyaakʊm da awɔɔ nɩ y. Mɔɔ lemim nyɩnta pa da, m hɔ dɩnda awɔɔ m gʊɔɔ bire ʊ, amba harlɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mɔɔ kasɛtɩ ka, m zɩɩfʊrɔ kan grɛkkɩrɔ kɩ bir, kʊ ŋ n'a bɔ a taam ŋnɩ zu Woso ʊ, kʊ ŋ nɩ sɩra ka wɔɔ Zuuba Yeezuu ʊ. ");
INSERT INTO bib_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Bɩ naa ma bɩ, Sɛnt-Ɛspri mɔɔ ba a lɔ, kʊ m zaa sa, m ta Zerizalɛm ʊ. Mɔɔ n a dɔ kʊ bɔ n n'aa ba mɔɔ m b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kan bɩ kɩ haay, Sɛnt-Ɛspri a hɩ mɔɔ m, kʊ haay kʊ mɔɔ nɩ bɔŋ ʊ, a ʊ, baŋŋarɔ kan fɩryɩrɛ kɩ ɩ dɔm mɔɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Bɩ, mɔɔ bɩr kɔm sɩ ma, m mɩŋŋa mɩsɩrbaa minto y. Mɔɔ lɛ n taa bɩ, kʊ m zu m zaa ʊ mɩŋŋa, kan zibəə kʊ Zuuba Yeezuu a ka mɔɔ ʊ bɩ kɩ. Kʊ m Woso barka lemim nyɩnta bɩ kasɛtɩ ka.» ");
INSERT INTO bib_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Mɔɔ dɔ mɩŋŋa kɛɛrɛ, mɔɔ ʊ, awɔɔ b'a yarɛ a mɔɔ meer yɩ y, awɔɔ haay, awɔɔ kʊ mɔɔ bɔ, m Woso cirbəə pa da a m nɔ wɔɔ. ");
INSERT INTO bib_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mɔɔ m da ma, m a hɩ awɔɔ taa her: Awɔɔ gɔsɩ taar ba mɔɔ mim ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mɔɔ n hɔsɩ nyaakʊm da awɔɔ m fɩɩga y. A n lɛ da bɩ, mɔɔ hɔ kʊ Woso a cɩnta haay k'a ba bɩ hɩ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bɩ minto bɩ, k'a dundo a mɩŋŋɔɔ zi, kan bakʊ bɩ haay kʊ Sɛnt-Ɛspri awɔɔ ba a dɔmazannɔ wɔɔ kɩ, k'a nyɩnta Woso gʊɔɔ sokʊma k'a cɩnta kan a mɩŋŋa ma kɩ bɩ dundonno. ");
INSERT INTO bib_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mɔɔ dɔ mɩŋŋa, mɔɔ ʊ, mɔɔ hʊrlɛ jɛ ʊ, poojino bʊnyaarɔ gasʊrɛ awɔɔ zi, ŋnɩ bakʊ bɩ zar. ");
INSERT INTO bib_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Baa gʊɔɔ bɔrɛ awɔɔ mɩŋŋɔɔ barla, ŋnɩ karɩndanyɩnɔ wɔɔ hɔɔn lʊr kan meerbaa bʊnyaarɔ kɩ, ŋnɩ ŋ da a tar la. ");
INSERT INTO bib_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Bɩ minto bɩ, k'a dundo a zi, k'a tɔ da a nɔ ʊ: Dɔɔraa kaakʊ nɔ ʊ, mɔɔ awɔɔ gʊaa biyəə dʊndɔ gunuu ʊ kan a sinuu ʊ kɩ, m nyifeer nɔ ʊ, bɩ mɔɔ n mɛnyɔɔ da y. ");
INSERT INTO bib_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Bɩ naa ma kɛɛrɛ bɩ, mɔɔ awɔɔ ka Woso ʊ kan a meerbaa barka k'a paŋŋa n ta ʊ, an n'a dam ma, an awɔɔ sɩrakarɛ da ra, k'a b'a zɛ kʊ ra kan wosogʊɔɔ wɔɔ kɩ hɔjirle nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mɔɔ hɔɔn n a ka gɔsɩ wanzurfu zi, gɛɛ sarma, gɛɛ huu y. ");
INSERT INTO bib_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Awɔɔ mɩŋŋɔɔ a dɔ a ʊ, m wɔ naa mɔɔ zi ba m, m a yɩ, an a ga mɔɔ m kan m zukuuzannɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mɔɔ hɔ haay hɩnka awɔɔ m, k'ɩ zi ba ncɩnaaʊ, ɩ hɔ yɩrɛ, ɩ ɩ dam paŋŋawarzannɔ han, k'a Zuuba Yeezuu minno k'a ŋ hɩ rɔ wɔɔ tɔ da a nɔ ʊ sɔ: Hɔ ka gʊaa ʊ jɩra gʊaa n'a ka ɩ ʊ m.» ");
INSERT INTO bib_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","K'a minno nɔɔn duro hɩ bɩ, a sʊnta kan ŋ kɩ haay an yaa da. ");
INSERT INTO bib_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ŋ haay n zɛ nyi da ʊ, ŋn'a burgu Pol wer ma. ");
INSERT INTO bib_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","K'a hɩ, a ʊ, awɔɔ b'a yarɛ a mɔɔ meer yɩ bɩ, yɩ ŋ heer zar an lɛ da. Bɩ jɛ ʊ bɩ, ŋnɩ zu kʊ ʊ kan kɩ, ŋn'aa a da zaa ʊ kɔɔlʊʊ bɩ jir ʊ. ");
INSERT INTO bib_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kʊ wɔɔ ʊ gʊ ŋ ma bɩ, wɔɔ da kɔɔlʊʊ ʊ, ʊ ta tɩrga kan Kɔɔs kɩ. Bɩ dɔ k'a mɛ bɩ, wɔɔ ta Rodɛs ʊ, ʊ ʊ to b'ʊ, ʊ ta Pataraa ʊ. ");
INSERT INTO bib_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kʊ wɔɔ kɔɔlʊʊ yɩ an nɩ tam Fenisii ʊ bɩ, wɔɔ da ʊ, ʊ cem. ");
INSERT INTO bib_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kʊ wɔɔ ta, ʊ n'ʊ zɔm Siipɩr ma bɩ, wɔɔ da, ʊ jɩsa ʊ, ʊ ta Siirii ʊ, ʊ aa zer Tiir ʊ bɩncɛ niŋŋə kʊ kɔɔlʊʊ bɩ n'a mɔr bɩ zerŋ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Wɔɔ gɔɔta b'ʊ dɔmɩm saanhɩna, bala, wɔɔ sʊr karɩndanyɩnɔ ma b'ʊ. Kan Sɛnt-Ɛspri paŋŋa kɩ, brɔɔ a hɩ Pol m, ŋ ʊ, a bɩ ta Zerizalɛm ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Wɔɔ cenle dɔmɩm k'a ku bɩ, wɔɔ ʊ wusigə. K'ʊ wɔɔ nɩ tam bɩ, ŋ haay wɔɔ da zaa ʊ, lannɔ kan nyɩnɔ kɩ, ŋnɩ bɔ tara nɔ b'ʊ. Wɔɔ n sʊnta hi bɩ lɛ ra, ʊ yaa da. ");
INSERT INTO bib_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ʊ ʊ leer so kʊ m kɛɛrɛ, ʊ da kɔɔlʊʊ b'ʊ, ŋn'a wusigə, ŋnɩ doo. ");
INSERT INTO bib_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kʊ wɔɔ kɔɔlʊʊ bɩ sa Tiir ʊ b'ʊ bɩ, wɔɔ yaa lee ku Potolemayiisi ʊ. Kʊ wɔɔ yaa da danyɩnɔ wɔɔ m, ʊ a nya bɩ, wɔɔ gɔɔta b'ʊ kan ŋ kɩ dɔmɩm deem. ");
INSERT INTO bib_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","A dɔ k'a mɛ bɩ, wɔɔ ʊ hʊr, ʊ ta Sezaree ʊ, ʊ aa zer lemim nyɩnta padarɛzaa Filipi har ʊ. Saanhɩnarɔ kʊ n nyɩnta n nɩ ŋ bɔ ʊ Zerizalɛm ʊ rɔ wɔɔ gʊaa deem m. Wɔɔ n gɔɔta kan kɩ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","A nyɩmbɔnnɔ si, ŋ n yar dɔ y. Ŋ n'ɩ wosolɛ sire ŋn'ɩ som la. ");
INSERT INTO bib_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kʊ wɔɔ gɔɔta b'ʊ an maasɩrɛ ba bɩ, wosolɛsinnɩsorazaa deem bɩ lee ku, Zidee kʊ gʊaa m, a tɔ m Agabus. ");
INSERT INTO bib_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","K'a bɩ wɔɔ yɩ bɩ, a Pol hɔsoaʊ bɩ sa, an a gannɔ sur m kan a wɔrɔ kɩ, an n'a hɩrɛ, a ʊ: «Hɔ kʊ Sɛnt-Ɛspri n'a hɩm bɩ ba n nɩ. Ba hɔ kʊ n n'a bam hɔsoaʊ naa do zaa bɩ m Zerizalɛm ʊ na: Zɩɩfʊrɔ y'a nyasʊm, ŋn'a sur, ŋn'a da do vantɔɔ gʊɔɔ wɔ ʊ!» ");
INSERT INTO bib_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Wɔɔ kan kʊ bɩ danyɩnɔ wɔɔ kɩ, wɔɔ yɛ Pol han k'a bɩ ta Zerizalɛm ʊ b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","A n a nyɩ bɔ wɔɔ nʊ, a ʊ: «Bɔ minto awɔɔ nɩ nyi karɛ, an nɩ mɔɔ heer zarlɛ? Mɔɔ surle bɛɛ mɔɔ yɛ ma bala y. Baa kʊ garɛ m Zerizalɛm ʊ Zuuba Yeezuu tɔ ma, mɔɔ yɛ.» ");
INSERT INTO bib_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","K'a bɩr yɛm kʊ ŋ nɩ bʊr a la bɩ, wɔɔ n yɛ, ʊ ta mim bɩ m laatʊ y, ʊ n n'a hɩrɛ, ʊ ʊ: «Kʊ Zuuba hɔɔnhɔ n ba!» ");
INSERT INTO bib_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Dɔmɩnnɔ wɔɔ duro nyarɛ ma bɩ, kʊ wɔɔ ʊ banka ʊ nya bɩ, wɔɔ ta Zerizalɛm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sezaree karɩndanyɩnɔ kʊ ŋ nɩ tam k'a yaa wɔɔ da zaa ʊ rɔ wɔɔ, ta wɔɔ m ʊ aa zer Siipɩr gʊaa Mɩnasɔɔn har ʊ. Karɩndanyɩ m, a dɔmɩm laatʊ. ");
INSERT INTO bib_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kʊ wɔɔ lee ku Zerizalɛm ʊ bɩ, danyɩnɔ wɔɔ wɔɔ si kan heernyɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Dɔ k'a mɛ bɩ, Pol ta kan wɔɔ kɩ Zakkɩ har ʊ. Bɩncɛ bɩ do kristagʊɔɔ lɛɛzannɔ wɔɔ nyɩnta ŋn'a so kʊ ma ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol k'a yaa da ŋ nɩ bɩ, a hɔ haay kʊ Woso a ka, an a ba do vantɔɔ bire ʊ bɩ jɩ sa deem-deem, an n'a dɩndarɛ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Gʊɔɔ kʊ ŋ n'a tʊr kam Pol ma rɔ wɔɔ, y'a lɛ bɔm Woso ʊ, ŋn'a hɩm nɩ, ŋ ʊ: «Ʊ danyɩ, zɩɩfʊrɔ wɔɔ tisi-tisi a ba sɩrakarɛzannɔ, bɩ ŋ haay lɛrɔ wɔɔ nyasʊ kɔɔkɔɔ. ");
INSERT INTO bib_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bɩ, ŋ y'a ma ŋn'ɩbɩɩ mim dɩndam, ŋ ʊ, ɩbɩɩ ɩ hɔ dɩndam zɩɩfʊrɔ kʊ ŋ nɩ do vantɔɔ bire ʊ rɔ wɔɔ m, kʊ ŋ nɩ wɔ saa Moyiisi lɛrɔ wɔɔ ma, kʊ ŋ b'a ya, ŋn'a nyɩnɔ gasʊ baŋŋʊ y, kʊ ŋ nɩ yɩnnɩbayɩ bɩ to. ");
INSERT INTO bib_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Kʊ a ba lɔ? Gʊɔɔ wɔɔ y'a marɛ, ŋ ʊ, ɩbɩɩ bʊr. ");
INSERT INTO bib_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Hɔ kʊ wɔɔ n'a hɩrɛ ɩbɩɩ m bɩ ba. Wɔɔ ɩ gʊɔɔyaarɔ m si, ŋnɩ ler bɔ Woso m. ");
INSERT INTO bib_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ŋ gaa, ɩ dintim gʊ ɩ ma kan ŋ kɩ, k'ɩ da ŋ han kan busoo kɩ, kʊ ŋ n'a lerbɔrɛ nyambʊr m, ŋn'a a da ma, ŋn'a mim bɔ. Ncɩnaaʊ bɩ, gʊaa haay y'a dɔrɛ ŋ ʊ, hɔ haay kʊ ŋ y'a ma ɩbɩɩ minto bɩ, ŋʊaar m, b'ɩbɩɩ mɩŋŋa ɩ zum lɛrɔ wɔɔ ʊ, ɩ nɩ ŋ sim mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kʊ do vantɔɔ gʊɔɔ kʊ ŋ y'a ba sɩrakarɛzannɔ wɔɔ nɩ, wɔɔ hɔ kʊ wɔɔ cɩnta bɩ ci ba ŋ ma: ‹Ŋ bɩ *wosobaawɔnnɔ mannɩbarɛ sim sʊ y, kan ma kɩ, kan hɔ gər sim kɩ, bɩ ŋ bɩ jaan da y.› » ");
INSERT INTO bib_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bɩ dɔ k'a mɛ bɩ, Pol gʊɔɔ wɔɔ gaa, an dintim gʊ a ma sɩŋŋɩda sa hɔdeem kan ŋ kɩ. A n ta Wosocɛ ʊ, k'a dintim gʊ a ma bɩ nyarɛ dɔmɩm cɩnta, k'an yɩ hindeem ʊ kan gʊɔɔ kʊ ŋ yaa ler bɔ Woso m nɔ wɔɔ ganwʊrɛ karɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kʊ dɔmɩm saanhɩna b'a zɔ nyarɛ ma bɩ, Azii zɩɩfʊrɔ wɔɔ kʊ ŋ y'a ka a hɔɔn zi ŋn'a yɩ Wosocɛ ʊ b'ʊ bɩ, ŋ gʊɔɔ wɔɔ nyʊnnyɔɔ, ŋnɩ Pol nyasʊ Wosocɛ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ŋ n'ɩ zee darɛ, ŋ ʊ: «Israyɛl zannɔ, k'a bʊr a da wɔɔ han! Ba gʊaa k'a bɩmbɩr lɛɛ haay ʊ, an n'a dɩndam zɩɩfʊrɔ wɔɔ m, a ʊ, ŋn'ɩ kaanm a do m kan lɛrɔ kɩ, Wosocɛ naa do kɩ bɩ n na. A bɔɔla m, an gasʊ grɛkkɩrɔ m Wosocɛ ʊ b'ʊ, an nɩ dintim kam bɩncɛ mɩŋŋa naa do ma ncɩnaaʊ.» ");
INSERT INTO bib_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bala, ŋ nyɩnta, ŋnɩ Efɛɛzɩ kʊ gʊaa Trofim yɩ tara nɔ ʊ b'ʊ kan Pol kɩ. Ŋ n'a hɔɔn darɛ, ŋ ʊ Pol bɩ, a gaa a ʊ, an gasʊ m Wosocɛ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tara bɩ n yar jilli, gʊɔɔ n bra si, ŋnɩ bʊr yuu…. Ŋ n Pol nyasʊ, ŋnɩ bɔ m Wosocɛ ʊ b'ʊ, ŋnɩ cɛlɛrɔ wɔɔ tɩnta lɛɛm. ");
INSERT INTO bib_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ŋ n'a kam ma k'a zɛ gər, sʊrdaa tisi lɛɛzaa bɩ n mim naa do ma, ŋ ʊ: «Zerizalɛm haay a zɛ kʊ ma.» ");
INSERT INTO bib_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","A n sʊrdaarɔ wɔɔ bir lɛɛm, an ŋ so kʊ ma kan sʊrdaa zɔrɔ lɛɛzannɔ wɔɔ kɩ, an a ka ŋnɩ la gʊɔɔ wɔɔ ra ŋnɩ bɔ. Kʊ gʊɔɔ wɔɔ sʊrdaa tisi lɛɛzaa bɩ yɩ kan a sʊrdaarɔ wɔɔ kɩ bɩ, ŋ Pol zɛrɛ to. ");
INSERT INTO bib_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Sʊrdaa tisi lɛɛzaa bɩ n a zɔ, an Pol nyasʊ, an lɛ ka, a ʊ, ŋn'a sur baŋŋa m hɩɩya. A n a lar a ʊ, kʊ nka n'awɔɔ m, bɩ, kʊ bɔ a ba sɔ. ");
INSERT INTO bib_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bɩ, gʊɔɔ wɔɔ bire ʊ, gʊaa biyəə nɩ zee darɛ, ŋ bɩr mim zaa deem hɩrɛ y. Kʊ sʊrdaa tisi lɛɛzaa bɩ bɩr hɔsɩ jɩ mam paan… bʊgʊr bɩ minto bɩ, a lɛ ka a ʊ, ŋnɩ Pol gaa ŋnɩ ta m sʊrdaarɔ wʊtajɩ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kʊ Pol yaa lee ku derlɛ bɩncɛ bɩ ra bɩ, sʊrdaarɔ wɔɔ a busu, gʊɔɔ wɔɔ kʊ ŋ n'a tɔŋ ʊ k'a ku bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Bala, zamaa bɩ haay ɩ zure a jɛ ʊ kan zee kɩ, ŋ ʊ: «K'a zɛ gər.» ");
INSERT INTO bib_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Dɔmɩm kʊ ŋ ʊ, k'a gasʊ m sʊrdaarɔ wʊtajɩ ʊ bɩ, Pol a hɩ sʊrdaa tisi lɛɛzaa bɩ m, a ʊ: «Mɔɔ n da ma, m meer ba kan ɩbɩɩ kɩ ra?» Sʊrdaa tisi lɛɛzaa bɩ n a nyɩ bɔ ʊ, a ʊ: «Ɩbɩɩ ɩ grɛkkɩ lemim mam na? ");
INSERT INTO bib_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ɩbɩɩ bɛɛ m Eziptɩ gʊaa niŋŋə k'a gʊɔɔ zɩnzɛrɛ zannɔ gaa dɔmɩnnɔ kʊ ŋ cem dɩɩtaa-dɩɩtaa rɔ nɔɔn nɔ ʊ, gʊaa tisi si, ɩ ta ŋ nɩ poohɔɔn ʊ bɩ ra?» Pol n a nyɩ bɔ ʊ, a ʊ: «Mɔɔ gɛɛ? Zɩɩfʊ n mɔɔ m, m to mɔɔ ʊ Silisii kʊ Tarsɩ ʊ. Tara gʊta nyɩ n mɔɔ m. ");
INSERT INTO bib_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","K'ɩ sugur ba, ɩ zaa ka m ʊ, kʊ m meer ba kan zamaa bɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","A n zaa ka ʊ, Pol n wuti an jɩm brama zerjɩ bɩ ra, an a wɔ busu zamaa bɩ m, ŋnɩ zɛ sɩɩ…, an meerbaa bɩ sa ebree lemim m, an n'a hɩrɛ ŋ nɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«M danyɩnɔ, kan m zɩrɔ kɩ, k'a tʊr ka, kʊ m m gumə mim dɩnda awɔɔ m kɛɛrɛ.» ");
INSERT INTO bib_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kʊ ŋ Pol ma an ebree lemim sa k'a hɩ bɩ, ŋ bʊgʊr bɩ to haay. ");
INSERT INTO bib_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Zɩɩfʊ n mɔɔ m, yɩ mɔɔ Silisii kʊ Tarsɩ ʊ, bɩ tʊr mɔɔ ʊ naa ʊ, tara naa do nɔ ʊ. Gamalɩyɛl ɩ wɔɔ zɩrɔ wɔɔ lɛrɔ wɔɔ dɩnda mɔɔ m zʊr-zʊr. Mɔɔ nyɩnta m Woso zuure nyasʊ kɔɔkɔɔ, amba awɔɔ haay m her naa m. ");
INSERT INTO bib_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mɔɔ nyɩnta, m fɩr ka gʊɔɔ ma karɩnda naa do zuure ma, m gɔsɩnnɔ zɩnzɛ, m gɔsɩnnɔ sur, m ŋ du lɔnnɔcɛ ʊ, lannɔ kan yaarɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Wosocɛmannɩbər jɩtaarɛ kan do bɩ jɩtannɔ wɔɔ kɩ a da ma, ŋn'a kasɛtɩ ka. Ciro mɔɔ ŋ si ŋ han wɔɔ danyɩnɔ zɩɩfʊrɔ kʊ ŋ nɩ Damas ʊ rɔ wɔɔ minto. Bɩ mɔɔ ɩ tam Damas ʊ, kʊ m aa sɩrakarɛzannɔ kʊ ŋ nyɩnta b'ʊ rɔ wɔɔ sur, m bʊr ŋ nɩ Zerizalɛm ʊ, kʊ ŋ nɩ bɩ fɩr ka ŋ ma. ");
INSERT INTO bib_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Mɔɔ m zaa sa, m nɩ tarɛ, m m zɔ Damas ma. Lɛɛm bɩ, sinuu zeezi, lɛɛgure gʊta n a to brama an b'a ku mɔɔ ra. ");
INSERT INTO bib_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mɔɔ n m do tara ʊ, mɔɔ nɩ leer marɛ, an n'a hɩrɛ, a ʊ: ‹Sol, Sol, bɔ minto ɩ nɩ fɩr kam mɔɔ ma?› ");
INSERT INTO bib_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mɔɔ n a nyɩ bɔ ʊ, mɔɔ ʊ: ‹Nka n'ɩbɩɩ nɩ, Zuuba?› Leer bɩ n a ya, an a hɩ, a ʊ: ‹Nazarɛtɩ Yeezuu m mɔɔ m, mɔɔ ɩbɩɩ nɩ fɩr karɛ m ma.› ");
INSERT INTO bib_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Mɔɔ zukuuzannɔ wɔɔ lɛɛgure bɩ yɩ mɩŋŋa, bɩ ŋ bɩr leer k'a nɩ meer bam kan mɔɔ kɩ bɩ marɛ y. ");
INSERT INTO bib_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mɔɔ n laaka da: ‹Bɔ mɔɔ m ga m, m a ba Zuuba?› Zuuba n a nyɩ bɔ mɔɔ nʊ, a ʊ: ‹Wuti, ɩ ta Damas ʊ. K'ɩ lee ku b'ʊ, hɔ k'ɩbɩɩ ɩ ga m, ɩ ba bɩ, n y'a hɩrɛ ɩbɩɩ m deem-deem.› ");
INSERT INTO bib_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Bɩ, kʊ lɛɛgure naa do mɔɔ mɩm bɩ ta bɩ, mɔɔ zukuuzannɔ wɔɔ a wɔ dɔ mɔɔ rɛ, mɔɔ n lee ku Damas ʊ. ");
INSERT INTO bib_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Gʊaa niŋŋə n nɩ b'ʊ, a tɔ m Ananɩyas. A nyɩnta gʊaa mɩŋŋa, an nɩ lɛrɔ wɔɔ sim mɩŋŋa, zɩɩfʊrɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ n'a lɛ bɔŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","A n bʊr, an bɩ mɔɔ yɩ, an a hɩ mɔɔ m, a ʊ: ‹M danyɩ Sol, k'ɩ mɩm n lɛɛ yɩ!› Lɛɛm bɩ, mɔɔ mɩm a gʊ, m a yɩ. ");
INSERT INTO bib_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","A n a hɩ mɔɔ m, a ʊ: ‹Wɔɔ zɩrɔ Woso ɩ bɔ ʊ, k'ɩ hɔɔnhɔ dɔ, k'ɩ Gʊaa tɩrga bɩ yɩ, k'ɩ mɩŋŋa lɛ meerbaa ma. ");
INSERT INTO bib_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Sɩra m, ɩbɩɩ ɩ ga m, ɩ bɩr kasɛtɩzaa a minto gʊaa haay taa kan hɔ haay k'ɩbɩɩ yɩ, ɩ ma sɔ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Bɔ minto, ɩ nɩ sɩnsɩm karɛ? Aya! Wuti ɩ batɛm si, k'ɩ tɔ bir, ɩ ɩ mimbʊnyaarɔ dintim gʊ ɩ ma.› ");
INSERT INTO bib_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Kʊ mɔɔ m wusigə Zerizalɛm ʊ bɩ, hindeem ʊ, mɔɔ nɩ yaa dam Wosocɛ ʊ, ");
INSERT INTO bib_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","mɔɔ n Zuuba yɩ hɔhɩnkarɛ nɔ ʊ, an n'a hɩrɛ, a ʊ: ‹A ba zɔɔ, ɩ ɩ hʊr Zerizalɛm ʊ, bala, ŋ bɩ mɔɔ kasɛtɩ k'ɩbɩɩ n'a kam bɩ sire y.› ");
INSERT INTO bib_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mɔɔ n a nyɩ bɔ ʊ, mɔɔ ʊ: ‹Zuuba, ŋ y'a dɔ mɩŋŋa, ŋ ʊ, mɔɔ ɩ nyɩnta, m nɩ tam sokʊmacɛrɔ ʊ, m nɩ gʊɔɔ kʊ ŋ sɩra ka ɩbɩɩ ʊ rɔ wɔɔ gʊrm, m a ka, ŋn'ɩ ŋ dum lɔnnɔcɛ ʊ, ŋn'ɩ ŋ zɛm madɩɩrɔ m. ");
INSERT INTO bib_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ɩbɩɩ kasɛtɩzaa Etɩyɛnnɩ ma k'a bra tara ra bɩ, mɔɔ mɩŋŋa nyɩnta b'ʊ sɔ, m m zɛ kʊ ra kan gʊɔɔ kʊ ŋ n'a zɛm nɔ wɔɔ kɩ, m dɔ ŋ huuro ma.› ");
INSERT INTO bib_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","A n a hɩ mɔɔ m, a ʊ: ‹Ta, ɩbɩɩ nyɔɔ mɔɔ nawʊm do vantɔɔ kʊrɔ ʊ.› » ");
INSERT INTO bib_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Zɩɩfʊrɔ wɔɔ kʊ ŋ y'a tʊr ka Pol ma, an ta an meerbaarɔ nɔɔn duro ku bɩ, ŋ wuti, ŋn'ɩ zee dam, ŋ ʊ: «K'a gʊaa ncɩnaaʊ bɩ bɔ durnya ʊ! A n a ga m, an bɩr mɩsɩr y.» ");
INSERT INTO bib_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Kʊ ŋ nɩ zee dam bɩ, ŋ y'a huuro bɔ a ra, ŋnɩ taa gʊr, ŋn'a nyɔɔm brama, ");
INSERT INTO bib_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","sʊrdaa tisi lɛɛzaa bɩ n lɛ ka, kʊ ŋ nɩ gasʊ Pol m, sʊrdaarɔ wʊtajɩ b'ʊ, ŋn'a zɛ, k'a laaka da han a dɔ, kʊ bɔ minto m zɩɩfʊrɔ wɔɔ nɩ zee darɛ awɔɔ ma gɛ. ");
INSERT INTO bib_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kʊ ŋ n'a bankam k'a Pol wʊta k'a zɛ bɩ, a a hɩ sʊrdaa zɔrɔ lɛɛzaa k'a nɩ zibəə ʊ b'ʊ bɩ m, a ʊ: «Rɔm zannɔ gʊaa kʊ ŋ n'a dʊdɔ ka bɩ, awɔɔ a ga m a zɛ madɩr m na?» ");
INSERT INTO bib_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Sʊrdaa zɔrɔ lɛɛzaa k'a naa ma bɩ, a ta an aa hɩ sʊrdaa tisi lɛɛzaa bɩ m, a ʊ: «Bɔ ɩbɩɩ k'ɩ ba naa? Gʊaa bɩ, Rɔm zannɔ gʊaa m!» ");
INSERT INTO bib_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Sʊrdaa tisi lɛɛzaa bɩ n a bɔ, an bɩ Pol lar, a ʊ: «Rɔm zannɔ gʊaa n'ɩbɩɩ m paan… ra, k'ɩ hɩ m m?» Pol n a nyɩ bɔ ʊ, a ʊ: «Ɩɩn…» ");
INSERT INTO bib_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Sʊrdaa tisi lɛɛzaa bɩ n a hɩ m, a ʊ: «Mɔɔ busoo bɔ gʊta kʊ m bɔkarɛ, m m ba Rɔm zannɔ gʊaa.» Pol n a hɩ m, a ʊ: «Mɔɔ naa, yɩ mɔɔ a nɔ ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Lɛɛm bɩ, gʊɔɔ kʊ ŋ nyɩnta k'a Pol zɛ rɔ wɔɔ a to. Sʊrdaa tisi lɛɛzaa bɩ k'a a dɔ a ʊ, Rɔm zannɔ gʊaa m Pol m, awɔɔ n a sur bɩ, dabɔʊ a nyasʊ. ");
INSERT INTO bib_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Dɔ k'a mɛ bɩ, sʊrdaa tisi lɛɛzaa bɩ k'a lɛ n taa k'a a dɔ paan… kʊ bɔ minto m, zɩɩfʊrɔ wɔɔ nɩ mim kam Pol ra bɩ, a a ka, ŋnɩ baŋŋarɔ wɔɔ bʊmbɔ ma. A n a ka, ŋnɩ wosocɛmannɩbənno jɩtannɔ wɔɔ bir kan dʊdɔkənno wɔɔ kɩ, an ŋ so kʊ ma, an a ka Pol n bʊr ŋ taa. ");
INSERT INTO bib_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol n dɩga dʊdɔkənno wɔɔ ma sɩɩ…, an a hɩ, a ʊ: «M danyɩnɔ, mɔɔ mɩsɩrbaa ba kan noom fu kɩ Woso mɩm ʊ, an ta, an her naa ku.» ");
INSERT INTO bib_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Bɩ, wosocɛmannɩbər jɩtaarɛ Ananɩyas lɛ ka a gʊɔɔ kʊ ŋ n'a jɩr ʊ rɔ wɔɔ ʊ, a ʊ, ŋn'a zɛ a lɛ ma. Pol n a hɩ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","«Ɩbɩɩ Woso n n'ɩ zɛm, noonkundəzaa ra! Nyɩnta ɩbɩɩ ʊ naa ʊ, ɩ zu lɛrɔ ʊ, k'ɩ mɔɔ dʊdɔ ka, ɩ bɔkarɛ ɩ kaanm lɛrɔ wɔɔ m, ɩ lɛ ka kʊ ŋ nɩ mɔɔ zɛ ra?» ");
INSERT INTO bib_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Gʊɔɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ n həən si ma, ŋ ʊ: «Wosocɛmannɩbər jɩtaarɛ b'ɩbɩɩ n'a sʊnsɔ wʊm naa ra?» Pol n a nyɩ bɔ ʊ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","«Mɔɔ n a dɔ mɔɔ ʊ wosocɛmannɩbər jɩtaarɛ nɩ y, m danyɩnɔ. Kʊ sɩra nɩ, n y'a gʊrsɩra ba, n ʊ: ‹Ɩ b'ɩ do cir sʊnsɔ wʊ y.› » ");
INSERT INTO bib_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol k'a b'a dɔ, a ʊ, gʊɔɔ wɔɔ sadisɛɛnrɔ m kan farizɛɛnrɔ kɩ bɩ, a a leer busu brama dʊdɔkənno wɔɔ bire ʊ, a ʊ: «Farizɛn m mɔɔ m, m danyɩnɔ, farizɛɛnrɔ nyɩ m mɔɔ m. Kʊ mɔɔ si mɔɔ ʊ gəəno y'a mɩm bɔŋ ʊ bɩ y'a ka ŋn'ɩ mɔɔ dʊdɔ kam.» ");
INSERT INTO bib_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","K'a meer naa do ba an a nya bɩ, nyaa wuti farizɛɛnrɔ wɔɔ bire ʊ kan sadisɛɛnrɔ wɔɔ kɩ. Zamaa bɩ n a gʊngʊ. ");
INSERT INTO bib_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadisɛɛnrɔ wɔɔ ʊ, gəəno mɩmbɔʊrɛ ba ʊ y, malɛɛka ba ʊ, nyi ba ʊ sɔ y. Farizɛɛnrɔ n bɔkarɛ, ŋn'a sim, ŋ ʊ, ŋ ta ʊ. ");
INSERT INTO bib_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Bʊgʊr paan… nyɩnta ʊ. Wosocikarɩnsaambɔɔ gɔsɩnnɔ wuti farizɛɛnrɔ wɔɔ bire ʊ ŋnɩ meer ba kan heerbusu kɩ, ŋ ʊ: «Wɔɔ n gʊaa naa do kʊrɔ ma yɩ y. Kʊ nyi ɩ meer ba kan kɩ, gɛɛ malɛɛka, wɔɔ n a dɔ y.» ");
INSERT INTO bib_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kʊ nyaa bɩ nɩ paŋŋa yɩm bɩ, sʊrdaa tisi lɛɛzaa b'ɩ nyi bam, ŋ y'a Pol kɩnkaansʊ. A lɛ ka kʊ gʊɔɔ n a bɔ bire ʊ, ŋnɩ ta m sʊrdaarɔ wʊtajɩ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Gunuu bɩ do ʊ, Zuuba a hɩnka Pol m, a ʊ: «Ɩ da bɩ bɔ ʊ, amba ɩbɩɩ mɔɔ kasɛtɩ ka Zerizalɛm ʊ bɩ, ɩbɩɩ mɔɔ kasɛtɩ kam Rɔm ʊ maam sɔ.» ");
INSERT INTO bib_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Dɔ k'a mɛ bɩ, zɩɩfʊrɔ wɔɔ a dɩnda ŋn'a zɛ kan kʊ kɩ, ŋn'a wer si k'a bɩ hɔ bɩ, a hɔ mi k'a n Pol zɛ gər y. ");
INSERT INTO bib_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kutim-kutim naa do nɔ ʊ, gʊɔɔ wɔɔ lɛ lɛ da busi ra, ŋn'a wer bɩ si. ");
INSERT INTO bib_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ŋ n ta, ŋn'aa wosocɛmannɩbənno jɩtannɔ wɔɔ yɩ kan jɩtannɔ wɔɔ kɩ, ŋn'a hɩ ŋ nɩ, ŋ ʊ: «Wɔɔ ʊ wer si, ʊ ʊ, kʊ wɔɔ n Pol zɛ gər y, wɔɔ bɩ hɔ bɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kɛɛrɛ bɩ, awɔɔ kan dʊdɔkənno wɔɔ kɩ, k'a kʊ yɩ, k'a hɩ sʊrdaa tisi lɛɛzaa bɩ m k'an a gaa, an a ka a ʊ, ɩ ʊ, awɔɔ lɛ n taa k'a b'a banka a lar. Kʊ wɔɔ nɩ, hɔ kʊ wɔɔ n n'a bam, ʊ a ku, ʊ a zɛ b'a n lee ku bɩ, wɔɔ ɩ bɩ dɔ.» ");
INSERT INTO bib_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pol danlʊ nyɩ n minno nɔɔn duro ma. A n ta sʊrdaarɔ wʊtajɩ ʊ, an aa gasʊ, an a hɩ Pol m. ");
INSERT INTO bib_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pol n sʊrdaa zɔrɔ lɛɛzaa deem bir, an a hɩ m, a ʊ: «Nyukumbueere naa gaa, ɩ ta m sʊrdaa tisi lɛɛzaa bɩ zi, a lɛ n taa k'a meer ba kan kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Sʊrdaa zɔrɔ lɛɛzaa bɩ n a gaa, an ta m sʊrdaa tisi lɛɛzaa bɩ zi, an a hɩ m, a ʊ: «Lɔ Pol b'ɩ mɔɔ bir, an a yɛ mɔɔ han, kʊ m nyukumbueere naa do gaa, m bʊr m ɩbɩɩ zi. A lɛ n taa k'a meer ba kan ɩbɩɩ kɩ.» ");
INSERT INTO bib_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Sʊrdaa tisi lɛɛzaa bɩ n a gaa a wɔ ma, an bɔ m toore ma, an a lar, a ʊ: «Bɔ ɩbɩɩ ʊ k'ɩ hɩ mɔɔ nɩ?» Nyukumbueere bɩ n a hɩ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","«Zɩɩfʊrɔ wɔɔ a dɩnda ŋn'a zɛ kan kʊ kɩ, k'a yɛ ɩbɩɩ han, k'ɩ Pol gaa ɩ bʊrm booti m dʊdɔkənno wɔɔ taa, ɩ ʊ, ŋ lɛ n taa k'a banka a lar a mim bɩ jɩ ma mɩŋŋa k'a a dɔ. ");
INSERT INTO bib_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ɩ bɩ ŋ meerbaa bɩ si y. Ŋ lɛ dam gʊaa busi ra, ŋnɩ kunku ma. Ŋ y'a wer si k'a bɩ hɔsɩ bɩ, a bɩ hi mi k'awɔɔ n Pol zɛ gər y. Ŋ y'a banka, ŋnɩ nya, ŋn'ɩ dɔrɛ ɩbɩɩ zaakarɛ ma.» ");
INSERT INTO bib_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Sʊrdaa tisi lɛɛzaa bɩ n nyukumbueere bɩ da zaa ra, an a hɩ m, a ʊ: «Ɩ b'a hɩ gɔsɩ nɩ, ɩ ʊ, ɩ hɔ naa do hɩ mɔɔ nɩ y.» ");
INSERT INTO bib_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Sʊrdaa tisi lɛɛzaa bɩ n sʊrdaa zɔrɔ lɛɛzannɔ bir hɩɩya, an a hɩ ŋ nɩ, a ʊ: «K'a a banka, k'a ta Sezaree ʊ yirbəə wakatɩ nɛɛhʊ ma, sʊrdaarɔ zɔɔhɩra, siirozannɔ busaanhɩna, kannɩzannɔ zɔɔhɩra. ");
INSERT INTO bib_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","K'a siiro banka, kʊ Pol n da ŋ ʊ an lee ku kan laafɩɩ kɩ tara lɛɛzaa Feligsi zi.» ");
INSERT INTO bib_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","A n ci ba, an a hɩ ncɩnaaʊ: ");
INSERT INTO bib_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Mɔɔ Klodiyus Liziyas nɩ yaa dam tara lɛɛzaa mɩŋŋa Feligsi m. ");
INSERT INTO bib_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Zɩɩfʊrɔ ɩ gʊaa kʊ mɔɔ n'a nyɔɔrɛ ɩbɩɩ zi naa nyasʊ ŋn'a ŋʊam k'a zɛ. Kʊ mɔɔ b'a ma ŋ ʊ Rɔm gʊaa m bɩ, mɔɔ ta kan m sʊrdaarɔ kɩ, m aa yɔ. ");
INSERT INTO bib_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Kʊ mɔɔ lɛ n taa kʊ m mim kʊ ŋ y'a ka ra bɩ dɔ bɩ, mɔɔ ka ŋnɩ ta m ŋ dʊdɔkənno taa. ");
INSERT INTO bib_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mɔɔ bɩ dɩga a, bɩsɩ ŋ n'a kam, a lɛrɔ wɔɔ ma, ŋnɩ mim ka ra. B'a n hɔsɩ ba, an a ga zɛ m, gɛɛ ŋn'a sur baŋŋarɔ nɩ y. ");
INSERT INTO bib_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Bɩ, kʊ mɔɔ ma ŋ ʊ, zɩɩfʊrɔ wɔɔ ɩ dundom zi k'a zɛ bɩ y'a ka, mɔɔ n'a nyɔɔrɛ ɩbɩɩ zi zɔɔ-zɔɔ. Mɔɔ hɩ gʊɔɔ kʊ ŋ mim ka ra rɔ wɔɔ m sɔ, kʊ ŋ nɩ bʊr ɩbɩɩ zi, ŋnɩ b'a gumə lemim hɩ.» ");
INSERT INTO bib_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sʊrdaarɔ wɔɔ n lɛ kʊ n y'a ka ŋ ʊ bɩ si, ŋnɩ Pol gaa, ŋnɩ ta m gunuu ʊ Antipatris ʊ. ");
INSERT INTO bib_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Dɔ k'a mɛ bɩ, kannɩzannɔ wɔɔ m Pol to siirozannɔ wɔɔ m, ŋn'a wusigə, ŋnɩ bʊr sʊrdaarɔ wʊtajɩ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kʊ ŋ yaa lee ku Sezaree ʊ bɩ, siirozannɔ wɔɔ ci bɩ ka tara lɛɛzaa b'ʊ, ŋnɩ Pol hɩnka m sɔ. ");
INSERT INTO bib_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Tara lɛɛzaa bɩ n ci bɩ karɩnda ba, an laaka da kʊ Pol bɩ, a to a ʊ gʊrga kara ʊ gɛ. K'a a dɔ a ʊ, a to a ʊ Silisii ʊ bɩ, a a hɩ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«Gʊɔɔ k'ʊ ŋ mim ka ɩbɩɩ ra bɩ, kʊ ŋ bʊr, mɔɔ yɩ m tʊr karɛ ɩbɩɩ meerbaa ma.» A n lɛ ka, a ʊ, ŋnɩ dɔ ma naa ʊ, hargʊta kʊ Hɩrɔɔdɩ a dɔ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Dɔmɩm soor jɛ ʊ bɩ, wosocɛmannɩbər jɩtaarɛ Ananɩyas kan jɩtannɔ kɩ, meerbaa dɔrɛzaa deem Tɛrtulus kɩ bʊr. Ŋ n ta Pol mim bɩ m tara lɛɛzaa Feligsi taa. ");
INSERT INTO bib_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bɩ m Pol bir, Tɛrtulus n a sɩŋŋɩda sa, an nɩ mim karɛ a lɛ m, a ʊ: «Feligsi mɩŋŋa, ɩbɩɩ minto y'a ka wɔɔ n laafɩɩ yɩ gʊta, lʊnlʊrlɛrɔ k'ɩbɩɩ ŋ ba wɔɔ bire ʊ wɔɔ do naa minto, bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Dɔmɩm haay, lɛɛ haay ʊ, Feligsi mɩŋŋa, wɔɔ ɩ barka darɛ ɩbɩɩ m zibəəro mɩŋŋɔɔ nɔɔn duro minto. ");
INSERT INTO bib_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kʊ mɔɔ lɛ baa kʊ m ɩbɩɩ kɔ gʊta bɩ, meerbaa bɩ bɩ gʊta y. Meerbaa nyɩntam poore, bɩ mɔɔ y'a yɛrɛ ɩbɩɩ han, kʊ bamɩŋŋazaa n'ɩbɩɩ m bɩ, wɔɔ dɔ, wɔɔ ʊ, ɩbɩɩ y'ɩ tʊr kam ma kan bʊraama k'ɩbɩɩ n tam wɔɔ n a dɔ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Wɔɔ yɩ gʊaa naa do, minzaa m. A nyaa zɛ an n'a dam durnya naa zɩɩfʊrɔ haay bire ʊ. Nazarɛtɩ gʊngʊrɛzannɔ wɔɔ karɩnda jɩtaarɛ deem m. ");
INSERT INTO bib_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","A a ŋʊa k'a wɔɔ Wosocɛ bɩ zar, bɩ y'a ka wɔɔ n a nyasʊ.  ");
INSERT INTO bib_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Wɔɔ ʊ kʊ a dʊdɔ ka, ʊ lɛrɔ wɔɔ nɔ ʊ. Sʊrdaa tisi lɛɛzaa Liziyas n a ma, an b'a bɔ wɔɔ bire ʊ kan paŋŋa gʊta kɩ, an lɛ ka gʊɔɔ kʊ ŋ mim ka ra rɔ wɔɔ ʊ, kʊ ŋ nɩ bʊr ɩbɩɩ zi. ");
INSERT INTO bib_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ɩbɩɩ ɩ da ma, ɩ lar ɩ zim: Ɩbɩɩ hɔ niŋŋə k'a ka wɔɔ nɩ mim kam la bɩ jɩ dɔm.» ");
INSERT INTO bib_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Zɩɩfʊrɔ wɔɔ n yo meerbaa naa do ra, ŋ ʊ, sɩra m. ");
INSERT INTO bib_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Tara lɛɛzaa b'a wɔ busu, an zaa ka Pol ʊ, k'an meer ba. Pol n a nyɩ bɔ ʊ, a ʊ: «Mɔɔ dɔ mɔɔ ʊ, ɩbɩɩ ɩ so gʊrga naa do dʊdɔ karɛ ʊ a dɔɔraa laatʊ, mɔɔ heer nyɩnta sɔ, kʊ m m meer ba. ");
INSERT INTO bib_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","K'ɩbɩɩ lɛ taa, ɩbɩɩ ɩ da ma, ɩ laaka da. Ta kʊ mɔɔ ʊ Zerizalɛm ʊ bɩ, a dɔmɩm n lɛ da bueerehɩɩya ra y, mɔɔ ta Zerizalɛm ʊ, kʊ m aa yaa da. ");
INSERT INTO bib_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Gɔsɩ n mɔɔ yɩ m nɩ bɩsɩ kam Wosocɛ ʊ kan gʊaa kɩ, gɛɛ, m nyaa zɛ m a da sokʊmacɛ ʊ, gɛɛ, lɛɛ vanta ʊ tara nɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Gʊɔɔ nɔɔn duro b'a dam ma, ŋnɩ hɔsɩ yɩ ŋn'a ka mɔɔ ra, ŋ ʊ sɩra nɩ y. ");
INSERT INTO bib_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ba hɔ kʊ mɔɔ dɔ bɩ n na: Wɔɔ zɩrɔ Woso zi mɔɔ n'a bam, m nɩ zum Zuuba Yeezuu zaa kʊ ŋ ʊ gʊngʊrɛzaa m b'ʊ. Kʊ zaa bɩ do nɩ, mɔɔ ɩ hɔ haay kʊ n y'a gʊrsɩra ba lɛrɔ ci nɔ ʊ bɩ sim kan wosolɛsinnɩsorazannɔ ciro kɩ. ");
INSERT INTO bib_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mɔɔ ta Woso taafeerle naa do m, mɔɔ ʊ: Gʊɔɔ mɩŋŋɔɔ kan gʊɔɔ bʊnyaarɔ kɩ y'a mɩm bɔŋ ʊ. Ŋ mɩŋŋɔɔ maam sɔ. ");
INSERT INTO bib_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Bɩ minto y'a ka, mɔɔ nɩ m tɔŋ ʊ dɔmɩm haay kʊ m bɩ mim zu ʊ Woso ma kan gʊɔɔ kɩ y. Bɩ, naa minto bɩ, dabɔʊ ba mɔɔ ma y. ");
INSERT INTO bib_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Mɔɔ bɔrɛ dɔɔraa laatʊ, m m bɔ, m bʊr kɛɛrɛ, kʊ m bɩ daahan ka m dogʊɔɔ cicirzannɔ ʊ, kʊ m bɩ mannɩ ba sɔ. ");
INSERT INTO bib_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Bɩ, ŋ bɩ mɔɔ yɩ Wosocɛ ʊ, bɩ ma bɩ, mɔɔ dintim gʊ m ma. Gʊaa cir n nyɩnta ʊ y, bɩ bʊgʊr n nyɩnta ʊ sɔ y, ");
INSERT INTO bib_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","kʊ Azii zɩɩfʊrɔ gɔsɩnnɔ bɛɛ nyɩnta b'ʊ y. Brɔɔ y'a ga m, ŋn'a hɩnka ɩbɩɩ taa, ŋnɩ mim yɩ ŋn'a ka mɔɔ ra, hɔ kʊ mɔɔ ba bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Gɛɛ k'a bɛɛ m bɩ, gʊɔɔ kʊ ŋ nɩ naa ʊ rɔ wɔɔ a da ma, ŋnɩ hɔ kʊ mɔɔ ba, ŋnɩ ta mɔɔ m dʊdɔkənno wɔɔ taa bɩ hɩ. ");
INSERT INTO bib_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Hɔ deem naa mɔɔ jɩm brama, m zee da, m a hɩ ŋ bire ʊ: Gəəno mɩmbɔʊrɛ minto y'a ka, ŋn'ɩ mɔɔ dʊdɔ karɛ awɔɔ taa her.» ");
INSERT INTO bib_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Bala, Feligsi Zuuba Yeezuu zaa bɩ mim dɔ. N gʊɔɔ wɔɔ da zaa ra, an n'a hɩrɛ, a ʊ: «Kʊ sʊrdaa tisi lɛɛzaa Liziyas bɩ bʊr naa ʊ, mɔɔ y'awɔɔ mim bɩ dʊdɔ karɛ.» ");
INSERT INTO bib_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","A n lɛ ka sʊrdaa zɔrɔ lɛɛzaa b'ʊ, a ʊ, an dɔ Pol ma, b'a b'a du y. A b'a ta a gʊaasɩba sɩ m tolle, a nyasʊm minto y. ");
INSERT INTO bib_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Dɔmɩm k'a cem poore bɩ, Feligsi nyɩnta kan Drusil a lʊ kʊ zɩɩfʊ m bɩ kɩ. A n a ka, ŋnɩ Pol bir k'an Krista sɩrakarɛ mim dɩnda a m. ");
INSERT INTO bib_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Bɩ, Pol k'a nɩ meer bɩ bam an nɩ tam tɩrgabaa, bʊraama, dʊdɔ k'a nɩ zɛm bɩ kɩ bɩncɛ ʊ bɩ, Feligsi da bɔ ʊ, an Pol meerbaa bɩ zɛ ra, a ʊ: «Naa ma bɩ, ɩ wusigə, ɩ ta ɩ bɩncɛ ʊ. Mɔɔ zɛm b'ɩ bir dɔmɩm niŋŋə ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Feligsi nyɩnta an n'a hɔɔn darɛ, a ʊ, Pol busoo karɛ a ʊ. Bɩ y'a ka an tɩr nyɔɔ da, ŋn'aa bir hallɩ gallɛm gʊta k'a bɩ sʊʊra ba. ");
INSERT INTO bib_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Dɔɔraa hɩɩya k'a cem bɩ, Pɔrsiyus Fɛstus ɩ Feligsi bɩncɛ sa. Feligsi k'a lɛ n taa k'a bɩr mɩŋŋa zɩɩfʊrɔ wɔɔ mɩm ʊ bɩ, a Pol to lɔnnɔcɛ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Bala, Fɛstus k'a lee ku a gʊrga ʊ b'ʊ bɩ, a dɔmɩm kaakʊ kur bɩ, a a hʊr Sezaree ʊ, an ta Zerizalɛm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","B'ʊ bɩ, wosocɛmannɩbənno jɩtannɔ kan zɩɩfʊrɔ gʊɔɔ gʊtɔɔ kɩ bʊr k'a mim ka Pol ra a taa. Ŋ n a yɛ Fɛstus han, k'an sugur ba a m, ");
INSERT INTO bib_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","an zaa ka, kʊ n nɩ ta Pol m Zerizalɛm ʊ. Bala, ŋ y'a dɩnda, ŋn'a zɛ kan kʊ kɩ a minto, k'a bɩ daata zɛ ra, a ku a zɛ gər zaa ra. ");
INSERT INTO bib_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fɛstus n a nyɩ bɔ ʊ, a ʊ, Pol gɔɔtam Sezaree lɔnnɔcɛ ʊ. Bɩ, kan bɩ kɩ haay, k'a yɩ poore, a y'a bɔrɛ a ta b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","«A a ya, an a hɩ a ʊ, gʊɔɔ kʊ ŋ mim bɩ dɔ mɩŋŋa, awɔɔ bire ʊ rɔ wɔɔ, ŋnɩ zu kʊ ʊ kan mɔɔ kɩ, k'ʊ ta Sezaree ʊ, kʊ hɔ niŋŋə ta an ta ʊ gʊaa naa do minto, kʊ ŋ nɩ bʊr ŋnɩ mim ka ra.» ");
INSERT INTO bib_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛstus n maasɩrɛ ba ŋ bire ʊ y, a n lɛ da dɔmɩm sinnyə m gɛɛ bu nɩ y. K'a lee ku Sezaree ʊ bɩ, a dɔ k'a mɛ bɩ, a yaa nyɩnta a dʊdɔkarɛ bɩncɛ ʊ, an a ka n n bʊr Pol m. ");
INSERT INTO bib_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Bɩ k'a lee ku b'ʊ bɩ, zɩɩfʊrɔ kʊ ŋ y'a to Zerizalɛm ʊ ŋnɩ bʊr lɔ wɔɔ bɩr ma, ŋnɩ ŋʊaar gʊta ba, ŋ n'a kam la kan minno gʊtɔɔ kɩ, bɩ ŋ b'a dam ma, ŋn'a kasɛtɩ ka y. ");
INSERT INTO bib_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pol n a gumə mim hɩ sɔ, an n'a hɩrɛ, a ʊ: «Mɔɔ n mim zu ʊ zɩɩfʊrɔ lɛrɔ ma, gɛɛ ŋ Wosocɛ, gɛɛ Rɔm cir ma y.» ");
INSERT INTO bib_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Kʊ Fɛstus lɛ n taa k'a bɩr mɩŋŋa kan zɩɩfʊrɔ wɔɔ kɩ bɩ, a a hɩ Pol m, «Ɩbɩɩ lɛ taa kʊ ŋ nɩ ta ɩbɩɩ m Zerizalɛm ʊ, kʊ m aa ɩ dʊdɔ ka gɛɛ?» ");
INSERT INTO bib_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pol n a nyɩ bɔ ʊ, a ʊ: «Rɔm cir dʊdɔkarɛ bɩncɛ mɔɔ n ta ʊ naa, naa ʊ ŋn'ɩ mɔɔ dʊdɔ kaŋ ʊ. Ɩbɩɩ mɩŋŋa a dɔ paan…, ɩ ʊ, mɔɔ n mim zu ʊ zɩɩfʊrɔ ma y. ");
INSERT INTO bib_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kʊ mim mɔɔ zu ʊ paan…, an a ga mɔɔ zɛ m, mɔɔ bɩ m bɔrɛ m kur y. Bɩ, kʊ minno kʊ gʊɔɔ nɔɔn duro a ba, n n'a kam mɔɔ ra b'a jɩ ba ʊ rɔ nɔɔn nɩ, gʊaa ba lɛ m, an n'a dam ma, a n mɔɔ ka ŋ ʊ y. Mɔɔ lɛ taa kʊ m ta Rɔm cir taa.» ");
INSERT INTO bib_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fɛstus kʊ ma kan a gʊɔɔ wɔɔ kɩ an a hɩ Pol m, a ʊ: «Ɩbɩɩ yɛ k'ɩ ta Rɔm cir taa, ta ɩbɩɩ n nɩ zɛm b'a ʊ b'ʊ.» ");
INSERT INTO bib_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Dɔmɩm k'a cem poore bɩ, cir Agripaa kan a danlʊ Berenisi kɩ ta Sezaree ʊ, ŋnɩ ta k'a yaa yaa da Fɛstus m. ");
INSERT INTO bib_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Kʊ ŋn'ɩ maasɩrɛ bam b'ʊ poore bɩ, Fɛstus Pol mim bɩ sa, an a dɩnda cir bɩ m, a ʊ: «Gʊaa n nɩ naa ʊ, Feligsi n a to lɔnnɔcɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Dɔmɩm kʊ mɔɔ ta ʊ Zerizalɛm ʊ bɩ, wosocɛmannɩbənno jɩtannɔ kan zɩɩfʊrɔ jɩtannɔ kɩ bʊr, ŋnɩ bɩ mim ka ra, ŋn'a zɛrɛ yɛrɛ. ");
INSERT INTO bib_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mɔɔ n a nyɩ bɔ ŋ nʊ, mɔɔ ʊ, Rɔm zannɔ yɩnnɩbayɩ zibəə bɛɛ k'a gʊaa bɔ a ka kʊ ŋ n'a zɛ gər, bɩ gʊɔɔ kʊ ŋ nɩ mim kam la rɔ wɔɔ ba ʊ, k'an aa a gumə mim dɩnda kan mim kʊ ŋ y'a ka ra bɩ kɩ y. ");
INSERT INTO bib_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bɩ minto y'a ka, ŋnɩ bʊr naa ʊ, mɔɔ n m ya, m dɔ hɔsɩ ma y, a dɔ k'a mɛ bɩ, mɔɔ n nyɩnta, m dʊdɔkarɛ bɩncɛ ʊ, m a ka, ŋnɩ bʊr gʊaa bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kʊ ŋ bʊr dʊdɔ bɩ ma bɩ, gʊɔɔ kʊ ŋ nɩ mim kam la rɔ wɔɔ, ŋ n mim sɩ gurezaa yɩ, ŋn'a ka ra, amba mɔɔ m hɔɔn da ma bɩ nɩ y. ");
INSERT INTO bib_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ŋ Woso zaa zuure minnɔ m bala, kan gʊaa deem kʊ n n'a birm Yeezuu k'a ga Pol n'a hɩm a ʊ, a mɩsɩr bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Kʊ mɔɔ n hɔ kʊ mɔɔ n n'a bam bɩ dɔ bɩ, mɔɔ yɛ han, k'a lɛ taa k'a ta Zerizalɛm ʊ, kʊ m aa mim bɩ dʊdɔ ka b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Bɩ kʊ Pol a hɩ a ʊ, a lɛ n taa k'a gɔɔta lɔnnɔcɛ ʊ, an ta an dɔmɩm kʊ cir gʊta n n'a mim bɩ dʊdɔ kam ma bɩ ku bɩ, mɔɔ lɛ ka, kʊ ŋ nɩ dɔ ma, an ta, an dɔmɩm kʊ mɔɔ n'a nyɔɔŋ ʊ Rɔm cir zi bɩ ku.» ");
INSERT INTO bib_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripaa n a hɩ Fɛstus m, a ʊ: «Mɔɔ lɛ n taa kʊ n gʊaa naa do meerbaa ma sɔ.» Fɛstus n a nyɩ bɔ ʊ, a ʊ: «Booti m bala, ɩbɩɩ y'ɩ tʊr karɛ a meerbaa ma.» ");
INSERT INTO bib_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Dɔ k'a mɛ bɩ, Agripaa kan Berenisi kɩ lee ku dʊdɔkarɛ bɩncɛ ʊ b'ʊ kan cirbəə gʊta kɩ, sʊrdaarɔ jɩtannɔ yɩ ŋ da zaa ʊ kan tara bɩ gʊɔɔ gʊtɔɔ kɩ. Fɛstus n lɛ ka, ŋnɩ bʊr Pol m. ");
INSERT INTO bib_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fɛstus n meerbaa sa, a ʊ: «Cir Agripaa kan awɔɔ haay woo…, k'a nɩ naa ʊ bɩ, awɔɔ ɩ gʊaa naa do yɩrɛ. Zɩɩfʊrɔ wɔɔ haay bɩ mɔɔ yɩ a minto Zerizalɛm ʊ, an ta an lee ku naa ʊ kan zee kɩ, ŋ ʊ, ŋ b'a ya, ŋn'a to mɩsɩr y. ");
INSERT INTO bib_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kʊ mɔɔ nɩ, mɔɔ n zibəə bʊnyaa yɩ, an a ba, an a ga a zɛ nɩ y. Bɩ, k'a ʊ, k'a lee ku Rɔm cir zi bɩ, mɔɔ cɩnta, kʊ m a nyɔɔ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bɩ kʊ mɔɔ ba meerbaa m paan…, kʊ m a gʊrsɩra ba cir gʊta ma k'an Pol mim bɩ dɔ bɩ, bɩ minto y'a ka, mɔɔ n a ka, an bʊr awɔɔ taa, an lɛ da ɩbɩɩ taa naa ʊ cir Agripaa, kʊ wɔɔ lar, naa jɛ ʊ, mɔɔ hɔsɩ yɩrɛ, m a gʊrsɩra ba Rɔm cir ma. ");
INSERT INTO bib_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kʊ mɔɔ lɔ nyɔɔ ncɩnaaʊ, bɩ mɔɔ n a kʊrɔma k'an a mim ʊ bɩ yɩ, yarmabaa zibəə m.» ");
INSERT INTO bib_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripaa n a hɩ Pol m, a ʊ: «Zaa ta ʊ k'ɩ meer ba kɛɛrɛ, ɩ ɩ mɩŋŋa bʊmbɔ.» Pol n a wɔ busu, an a gumə lemim hɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Mɔɔ heer nyɔɔ, cir Agripaa, kʊ mɔɔ zaa yɩ kʊ m meer ba ɩbɩɩ taa her, kʊ m m gumə mim dɩnda, mim haay kʊ zɩɩfʊrɔ mɔɔ a ka wɔɔ ra bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Bala, ɩbɩɩ minkə ŋ bɩsɩkarɛ gʊta m kan ŋ yɩnnɩbayɩ zibəə kɩ. Bɩ y'a ka, mɔɔ n'a yɛrɛ ɩbɩɩ han, k'ɩ tʊr ka mɔɔ meerbaa ma kan bʊraama kɩ. ");
INSERT INTO bib_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Mɔɔ mɩsɩrbaa k'a nyɩnta hɔ niŋŋə, m nyɩbaa ma, kan nyɩnta kʊ mɔɔ ʊ hɔ niŋŋə, m dogʊɔɔ bire ʊ Zerizalɛm ʊ bɩ kɩ, zɩɩfʊrɔ wɔɔ haay a dɔ. ");
INSERT INTO bib_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Kʊ ŋ lɛ taa, ŋ y'a da ma, ŋn'a kasɛtɩ ka, ŋ y'a dɔ a dɔɔraa laatʊ, ŋ ʊ, farizɛn m mɔɔ m. Gʊɔɔ niŋŋoo kʊ ŋ nɩ yɛm wɔɔ Woso zaa zuure ma paan…, an lɛ da ŋ haay ra rɔ wɔɔ. ");
INSERT INTO bib_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Bɩ her naa, kʊ mɔɔ Woso lerbɔrɛ k'a ba wɔɔ zɩrɔ m bɩ si bɩ, bɩ y'a ba mɔɔ dʊdɔ her. ");
INSERT INTO bib_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Wɔɔ do haryaa bueerehɩɩya b'ɩ yaa dam Woso m sinuu ʊ kan a gunuu ʊ kɩ, ŋ bɩr a tore y. Kʊ ŋn'ɩ dɔm lerbɔrɛ bɩ do ma bɩ minto. Kʊ mɔɔ lerbɔrɛ naa do ta m heer lɛ bɩ y'a ka, m cir Agripaa, zɩɩfʊrɔ wɔɔ nɩ mim kam mɔɔ ra. ");
INSERT INTO bib_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Bɔ minto m, b'awɔɔ n a si a ʊ, Woso ɩ gəəno mɩm bɔŋ ʊ? ");
INSERT INTO bib_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Kʊ mɔɔ nɩ, mɔɔ nyɩnta m a si mɩŋŋa mɔɔ ʊ lɛ m, kʊ m yar ba kan Nazarɛtɩ Yeezuu bɩ tɔ bɩ kɩ, paŋŋa do haay m. ");
INSERT INTO bib_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Bɩ, bɩ mɔɔ ba Zerizalɛm ʊ, wosocɛmannɩbənno jɩtannɔ wɔɔ ɩ lɛ naa do ka mɔɔ ʊ. Mɔɔ mɩŋŋa sɩrakarɛzannɔ gʊr gʊta, m m du lɔnnɔcɛ ʊ. Gʊɔɔ kʊ n yɩ ŋ zɩnzɛ rɔ wɔɔ, mɔɔ hɩ mɔɔ ʊ, a a ga m. ");
INSERT INTO bib_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Gallɛm gʊta, mɔɔ ta sokʊmacɛrɔ ʊ, m fɩr ka ŋ ma, m paŋŋa ba ŋ ma, kʊ ŋ nɩ Yeezuu sʊnsɔ wʊ. Bɩ, kan jɩmbaa heerbusu gʊta kɩ, mɔɔ yɩ ŋ jɩ bɔm tararɔ gɔsɩnnɔ ra, m nɩ fɩr karɛ ŋ ma. ");
INSERT INTO bib_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Bɩ minto y'a ka, hindeem ʊ, wosocɛmannɩbənno jɩtannɔ wɔɔ n zaa ka mɔɔ ʊ kan paŋŋa haay kɩ, kʊ m ta Damas ʊ mim naa do minto. ");
INSERT INTO bib_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Cir, kʊ mɔɔ nɩ tam bɩ, kʊ sinuu b'a zɔ bɩ, mɔɔ lɛɛgure yɩ, an a to brama, a gure n lɛ da wosogure ra, an b'a ku mɔɔ ra kan m zukuuzannɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Wɔɔ haay, wɔɔ ʊ dundo tara ʊ, mɔɔ n leer ma, an n'a hɩm mɔɔ m ebree lemim m, a ʊ: Sol, Sol, bɔ minto, ɩ nɩ fɩr kam mɔɔ ma? A ba ɩbɩɩ nawʊrɛ, ɩ mɩŋŋa m! ");
INSERT INTO bib_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mɔɔ n a nyɩ bɔ ʊ, mɔɔ ʊ: ‹Nka n'ɩbɩɩ nɩ, Zuuba?› Zuuba n a ya, an a hɩ, a ʊ: ‹Yeezuu m mɔɔ m, mɔɔ ɩbɩɩ n nɩ fɩr karɛ ŋ ma. ");
INSERT INTO bib_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Bɩ, wuti ɩ jɩm! Ba hɔ k'a ka mɔɔ n m hɩnka ɩbɩɩ m bɩ n na: Mɔɔ ɩbɩɩ bɔ ʊ k'ɩ nyɩnta mɔɔ zibəənyɩ, mɔɔ kasɛtɩzaa kan hɔ niŋŋə k'ɩbɩɩ mɔɔ yɩ ʊ naa kɩ, kan a vantɔɔ kʊ mɔɔ n nɩ zɛm bɩ m hɩnka ɩbɩɩ m nɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mɔɔ lɛɛ kam m ɩbɩɩ bʊmbɔ ɩ do kan do vantɔɔ kʊ mɔɔ n n'ɩbɩɩ nyɔɔrɛ ŋ ma rɔ wɔɔ kɩ wɔ ʊ, ");
INSERT INTO bib_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","k'ɩ yaa nɩ ŋ mɩm gʊ, k'ɩ ŋ bɔ monsigə nɔ ʊ, ɩ ta ŋ nɩ lɛɛgure ʊ, k'ɩ bɔ ŋ nɩ Sʊtaana lɔmbaa nɔ ʊ, ɩ ta ŋ nɩ Woso zi, kʊ ŋ n sɩra ka mɔɔ ʊ, kʊ ŋ n'a mimbʊnyaarɔ sugur yɩ, bɩ, kʊ ŋ nɩ hɔjirle yɩ, kan gʊɔɔ kʊ ŋ y'a mɩŋŋɔɔ ka Woso ʊ rɔ wɔɔ kɩ.› ");
INSERT INTO bib_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Bɩ tɛkka ma, cir Agripaa, mɔɔ n bɩsɩ ka hɔ kʊ Zuuba a hɩ mɔɔ m hɔhɩnkarɛ naa do nɔ ʊ bɩ ma y. ");
INSERT INTO bib_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","A sa mɔɔ ʊ Damas zannɔ ma kan Zerizalɛm zannɔ kɩ, an lɛ da, Zidee jilli kʊ zannɔ kɩ, bɩ jɛ ʊ kan do vantɔɔ kʊ gʊɔɔ kɩ, m a dɩnda kʊ ŋ n'a bɔ a taam, ŋnɩ yɛ Woso ma, kʊ ŋ n'a mimbʊnyaarɔ sugur yɩ, kʊ ŋ nɩ mɩsɩrbaa ba, k'an zu kʊ ʊ kan ŋ heerlʊrlɛ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Bɩ minto y'a ka, mɔɔ nɩ Wosocɛ ʊ, zɩɩfʊrɔ wɔɔ n bɩ mɔɔ nyasʊ, ŋn'a gɩnga k'a mɔɔ mee bɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Woso n ku mɔɔ ra mɩŋŋa, an ta an dɔmɩm naa do ku. Mɔɔ gɔɔta m nɩ kasɛtɩ kam gʊɔɔ poorero kan gʊɔɔ gʊtɔɔ kɩ taa. Wosolɛsinnɩsorazannɔ kan Moyiisi kɩ lɛɛ ka ŋnɩ hɔ k'a nɩ zɛm bɩ hɩ. Mɔɔ bɩr hɔsɩ vanta hɩrɛ, an lɛ da bɩ ra y. ");
INSERT INTO bib_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ŋ ʊ: ‹Krista fɩr yɩrɛ, b'a lɛɛ kam an a mɩm bɔ ʊ gəəno bire ʊ, an nɩ lɛɛgure pa dam zɩɩfʊrɔ m kan do vantɔɔ gʊɔɔ kɩ.› » ");
INSERT INTO bib_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pol k'a lee ku bɩncɛ naa do ʊ a meerbaa nɔ ʊ bɩ, Fɛstus a leer busu, an a hɩ, a ʊ: «Hɔɔzaa n'ɩbɩɩ naa Pol! Ɩbɩɩ hɔdɔrɛ maam-maam bɩ y'ɩbɩɩ bam hɔɔzaa!» ");
INSERT INTO bib_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pol n a hɩ, a ʊ: «Hɔɔzaa bɛɛ m mɔɔ nɩ y, Fɛstus mɩŋŋa, sɩra meerbaa mɔɔ n'a bam, hɔɔntaʊrɛ m. ");
INSERT INTO bib_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Cir Agripaa bɩ minno nɔɔn duro dɔ mɩŋŋa haay, bɩ y'a ka, mɔɔ m dam ma, m meer ba a lɛɛ kan heerkoodəbaa kɩ. Mɔɔ si mɔɔ ʊ, hɔsɩ n ba a mɩm ma sɛɛrɛ y. Bala, minno nɔɔn duro n ba gʊrga k'a nyaakʊm da ʊ y. ");
INSERT INTO bib_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Cir Agripaa, ɩbɩɩ wosolɛsinnɩsorazannɔ mim si ra? Mɔɔ dɔ mɔɔ ʊ, ɩbɩɩ ŋ mim si» ");
INSERT INTO bib_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripaa n a hɩ Pol m, a ʊ: «Kan ɩbɩɩ meerbaa bɩ kɩ, gɔɔta a ʊ poore, k'ɩbɩɩ n mɔɔ ba kristagʊaa ra?» ");
INSERT INTO bib_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pol n a hɩ, a ʊ: «K'a a ŋʊa, an gɔɔta poore gɛɛ gʊta, mɔɔ ŋʊa, kʊ Woso yɛ, a bɩ nyɩntarɛ ɩbɩɩ bala y, gʊɔɔ haay kʊ ŋ n'a tʊr kam mɔɔ meerbaa ma her lɔ wɔɔ, awɔɔ y'a bam amba mɔɔ m, bɩ baŋŋarɔ kʊ ŋ nɩ mɔɔ wɔ ma rɔ nɔɔn duro bɩ nyɩntarɛ awɔɔ wɔ ma y.» ");
INSERT INTO bib_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Cir bɩ n wuti kan tara lɛɛzaa bɩ kɩ, Berenisi kɩ, kan gʊɔɔ kʊ ŋ nɩ nyɩntam kan ŋ kɩ rɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Kʊ ŋn'a hʊrm bɩ, ŋ sʊʊra ba kan kʊ kɩ ŋn'a hɩrɛ, ŋ ʊ: «Gʊaa naa do n hɔsɩ ba, an a ga zɛ m gɛɛ baŋŋarɔ nɩ y.» ");
INSERT INTO bib_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripaa n a hɩ Fɛstus m, a ʊ: «Kʊ gʊaa naa do bɛɛ y'a ŋʊa k'a ta mim bɩ m Rɔm cir taa, a a ga m, ŋnɩ wɔ saa.» ");
INSERT INTO bib_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kʊ ŋ y'a cɩnta kʊ wɔɔ n da kɔɔlʊʊ ʊ, ʊ ta Italii ʊ bɩ, ŋ Pol kan lɔnnɔ gɔsɩnnɔ kɩ da sʊrdaa zɔrɔ lɛɛzaa k'a tɔ m Zuliyus bɩ wɔ ʊ, sʊrdaarɔ zɔrsɔddɩ zɛkʊra kʊ n n'a birm Ogista zɛkʊra, bɩ y'a so ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Wɔɔ da kɔɔlʊʊ ʊ k'a a to Adramitɩyɔm an nɩ tam Azii kʊrɔ kʊ ŋ nɩ hi lɛ ra rɔ wɔɔ ʊ. Aristarkɩ ɩ nyɩnta kan wɔɔ kɩ. Masedʊan kʊ Tesaloniki gʊaa m. ");
INSERT INTO bib_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Dɔ k'a mɛ bɩ, wɔɔ lee ku Sidɔn ʊ, bɩ kʊ jɩnlɛ poore m bɩ, Zuliyus a ba Pol m mɩŋŋa. A zaa ka ʊ, k'an aa dɩga a gʊaasɩbarɔ ma, brɔɔ n nyasʊ m. ");
INSERT INTO bib_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kʊ wɔɔ bɔ b'ʊ bɩ, wɔɔ da kɔɔlʊʊ b'ʊ, ʊ bɔ Siipɩr jɩr ʊ, k'a n'a ta wɔɔ m hɩnhɛr bɩ k'a nya wɔɔ rɛ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","A m bɩ, wɔɔ n higʊta k'a nɩ Silisii kan Panfilii kɩ jɩr ʊ bɩ zɛ ra, ʊ aa lee ku Lisii kʊ Miir ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Sʊrdaa zɔrɔ lɛɛzaa bɩ k'a Alɛsandrii kɔɔlʊʊ yɩ b'ʊ an nɩ tam Italii ʊ bɩ, a a ka wɔɔ n da ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kɔɔlʊʊ bɩ n ta poore-poore dɔmɩm gʊta nɔ ʊ, ʊ aa lee ku kan kɔrɛ kɩ Kinɩdɩ ʊ. Hɩnhɛr bɩ k'a nya wɔɔ rɛ bɩ, wɔɔ b'ʊ dam ma, ʊ ta tɩrga bɩ, wɔɔ bɔ Salmonɛ jɩr ʊ, ʊ aa bɔ Krɛtɩ jɩr ʊ, k'a n'a ta wɔɔ m hɩnhɛr bɩ minto. ");
INSERT INTO bib_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Wɔɔ fɩr yɩ kan kɔɔlʊʊ bɩ kɩ, ʊ bɔkarɛ ʊ aa lee ku bɩncɛ kʊ n n'a birm Jɩnjɩ-Mɩŋŋa b'ʊ, Lazaya kʊ jɩr ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Dɔmɩnnɔ cem gʊta, kɔɔlʊʊ bɩ tarɛ nyibəə n ta ʊ, bɩ ma bɩ, lɛkʊsɩrɛ dɔmɩm cem. Pol n ŋ dʊndɔ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«M gʊaasɩbɔɔ, mɔɔ dɔ mɔɔ ʊ tarɛ naa do hɔ zarm gʊta, a nyaanɩm gʊɔɔ gʊta m, kɔɔlʊʊ bɩ bɛɛ bala kan mɔr bɩ kɩ y, wɔɔ mɩŋŋɔɔ kɩ sɔ.» ");
INSERT INTO bib_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Sʊrdaa zɔrɔ lɛɛzaa bɩ, a tʊr an n'a kam gʊaa k'a nɩ kɔɔlʊʊ bɩ bram bɩ ma kan kɔɔlʊʊ bɩ zaa hɔnyɩ kɩ ma, an lɛ da Pol meerbaa bɩ ra. ");
INSERT INTO bib_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Bɩncɛ niŋŋə kʊ wɔɔ jɩm ʊ bɩ, k'a bɩ bɩncɛ mɩŋŋa nyɛɛm dɔmɩm ʊ bɩ, ŋ gʊɔɔ gʊta a zɛ kʊ ra, ŋn'a lɛ ba deem k'a zu zaa ʊ, kʊ dɩga a, k'ʊ lee kum jɩnjɩ k'a nɩ Krɛtɩ kʊ Fenigsi ʊ b'ʊ, k'an a ta wɔɔ m nyɛɛm hɩnhɛr minto. K'ʊ nyɩnta b'ʊ nyɛɛm dɔmɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Hɩnhɛr poore wuti jɩsa, bɩ minto y'a ka, ŋn'a hɔɔn da, ŋ ʊ, a y'a dam ma, a zaa sa. Ŋ kɔɔlʊʊ bɩ hʊr, ŋn'a na Krɛtɩ gəm b'ʊ, ŋn'ɩ tam. ");
INSERT INTO bib_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","K'a yɩ poore bɩ, hɩnhɛr gʊta kʊ n n'a birm Erakilɔn bɩ wuti tara bɩ zeezi, an bʊr kan paŋŋa kɩ, an b'a ku ŋ la. ");
INSERT INTO bib_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","A n kɔɔlʊʊ bɩ gaa an cenim, wɔɔ b'ʊ dam ma, ʊ a bɔ y. Wɔɔ n a to an a gaa, an nɩ tam nɩ, kʊ lɛɛ ka m, ʊ n a dɔ y. ");
INSERT INTO bib_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","K'a nɩ tam zɔɔ-zɔɔ bɩ, wɔɔ yaa lee ku tara poore k'a nɩ hi bire ʊ, n n'a birm Koda bɩ jɩr ʊ, an a ta wɔɔ m hɩnhɛr bɩ minto. Wɔɔ ʊ tɔ ʊ kan kɔrɛ gʊta kɩ, ʊ ʊ da ma, ʊ kɔɔlʊʊ poore bɩ gaa, ʊ a bɔ hi b'ʊ, ʊ a da kɔɔlʊʊ gʊta b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kʊ ŋ kɔɔlʊʊ poore bɩ gaa ŋn'a da kɔɔlʊʊ b'ʊ an nya bɩ, ŋ bar sunso kɔɔlʊʊ gʊta b'ʊ kɛɛrɛ. Kʊ ŋ nɩ nyi bam kɔɔlʊʊ bɩ yaa wɔ Sɩrtɩ nyɩntaa b'ʊ bɩ, ŋnɩ hɔ kʊsɩ kɔɔlʊʊ bɩ jɛ ma, ŋn'a da hi b'ʊ, k'a n'a tarɛ bɩ bɔrɛ, ŋn'a to an nɩ tarɛ a hɔɔnhɔ ma. ");
INSERT INTO bib_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Bɩ dɔ k'a mɛ bɩ, hɩnhɛr gʊta bɩ k'a nɩ fɩr kam wɔɔ ma tee… bɩ, ŋ mɔrlɔ kʊ ŋ yɩ da kɔɔlʊʊ b'ʊ rɔ wɔɔ waa ʊ, ŋnɩ ŋ zar higʊta b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","A dɔmɩm kaakʊ hinni ʊ bɩ, kɔɔlʊʊ bɩ zibəəzannɔ wɔɔ kɔɔlʊʊ bɩ mɔdrɔ wɔɔ zar hi b'ʊ a zim. ");
INSERT INTO bib_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Woso kan monyaarɔ kɩ n a hɩnka dɔmɩnnɔ wɔɔ nɔ ʊ y, bɩ hɩnhɛr bɩ hɔnrɛ bʊnyaabaa gɔɔta an nɩ fɩr kam wɔɔ ma. Wɔɔ n a dɔ kʊ wɔɔ bɔrɛ y. ");
INSERT INTO bib_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","A dɔmɩm laatʊ, ŋ n hɔbɩrɛ bɩ y. Pol n wuti an jɩm brama ŋ bire ʊ, an a hɩ ŋ nɩ, a ʊ: «Awɔɔ yɩ ra, gʊɔɔ, kʊ mɔɔ dʊndɔrɛ b'awɔɔ si, ʊ n ʊ hʊr Krɛtɩ ʊ, fɩr kʊ wɔɔ yɩ naa kan mɔr k'a zar naa kɩ bɩ wɔɔ yɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Bɩ naa ma bɩ, mɔɔ y'a yɛrɛ awɔɔ han, k'a heer ba kookoo. Awɔɔ gʊaa deem taan… bɩ garɛ y, kɔɔlʊʊ bɩ y'a deem n n'a zarm bala. ");
INSERT INTO bib_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Woso k'a a so mɔɔ ʊ, mɔɔ n'a zi bam bɩ malɛɛka a hɩnka mɔɔ m gum naa ʊ bala, an a hɩ mɔɔ m, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ɩ da bɩ bɔ ʊ y, Pol. A a ga m, ɩbɩɩ m ta Rɔm cir taa, bɩ Woso gʊɔɔ k'ɩbɩɩ nɩ zum kʊ ʊ kan ŋ kɩ rɔ wɔɔ meeyaa da ɩbɩɩ wɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ncɩnaaʊ bɩ, yaarɔ, k'a heer ba kookoo! Mɔɔ sɩra ka Woso ʊ, a bam amba a a hɩ mɔɔ m bɩ m. ");
INSERT INTO bib_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Wɔɔ yaa nʊ lo tara niŋŋə k'a nɩ hi bire ʊ bɩ ra.» ");
INSERT INTO bib_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","A gunuu bueeresi hɔ, wɔɔ nyaam ʊ higʊta bɩ burə ʊ. Dibsir k'a a zɔ bɩ, kɔɔlʊʊ bɩ zibəəzannɔ wɔɔ a dɔ a hɔɔn ʊ, ŋ ʊ, wɔɔ ʊ zɔ tara ma. ");
INSERT INTO bib_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ŋ n higʊta bɩ nɔ makra ba mɛtɩr busi, kʊ ŋ ta lɛɛ poore bɩ, ŋ y'a ya, ŋn'a makra ba ŋn'a yɩ mɛtɩr bukərku. ");
INSERT INTO bib_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kʊ ŋn'ɩ nyi bam kɔɔlʊʊ bɩ yaa a zɛ ci ma bɩ, ŋ pɔyaa gorezannɔ zo si, ŋn'a kʊsɩ baŋŋarɔ m jɛ ʊ, ŋn'a yɛm kʊ dɔ n mɛ zɔɔ. ");
INSERT INTO bib_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Kɔɔlʊʊ bɩ zibəəzannɔ hɔ ba ɩ ʊ, a hɩ ŋ y'a ʊ k'a baŋŋarɔ gɔsɩnnɔ zo hi bɩ nɔ ʊ, k'an kɔɔlʊʊ bɩ nyasʊ, ŋn'a nyaakʊm da k'a bra si kan kɔɔlʊʊ poore bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pol n a hɩ, sʊrdaa zɔrɔ lɛɛzaa bɩ m kan sʊrdaarɔ wɔɔ kɩ, a ʊ: «Kʊ gʊɔɔ nɔɔn duro n gɔɔta kɔɔlʊʊ bɩ nɔ ʊ, awɔɔ, awɔɔ bɩ bɔrɛ y.» ");
INSERT INTO bib_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Sʊrdaarɔ wɔɔ n kɔɔlʊʊ poore bɩ barlɔ wɔɔ zɩnzɛ ra, ŋn'a to an ta an cem. ");
INSERT INTO bib_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kʊ ŋn'ɩ dɔm dɔmɩrɛ ma bɩ, Pol gʊaa haay bir, an a yɛ ŋ han, kʊ ŋ nɩ hɔbɩrɛ bɩ, an n'a hɩrɛ, a ʊ: «Awɔɔ dɔmɩm bueeresi her, awɔɔ n hɔ bɩ y. A n nɩ dɔm ma kʊ hɩnhɛr bɩ n a da jɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Bɩ minto bɩ, mɔɔ y'a yɛrɛ awɔɔ han k'a hɔ bɩ, awɔɔ laafɩɩ minto m. Bala, minkə deem taan… bɩ nyaanɩm gʊaa mim ʊ naa ʊ y.» ");
INSERT INTO bib_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","K'a naa hɩ bɩ, a bur sa, an barka da Woso m gʊaa haay mɩm m, an a zɛ ra, an n'a sʊrɛ. ");
INSERT INTO bib_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ŋ haay heer n ka bɩ jɛ ʊ, ŋnɩ hɔbɩrɛ bɩ bɩ. ");
INSERT INTO bib_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Wɔɔ haay wuti, gʊaa zɔɔhɩra busaanhɩna yaa sɔrdɩ kɔɔlʊʊ bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kʊ hɔbɩrɛ bɩ ŋ ka bɩ, ŋ hɔyaa bɩ waa kɔɔlʊʊ bɩ nɔ ʊ, ŋn'a zar hi b'ʊ, k'a gore bɩ n a bɔrɛ. ");
INSERT INTO bib_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Dɔ k'a mɛ bɩ, kɔɔlʊʊ bɩ zibəəzannɔ wɔɔ n a ya, ŋnɩ tara bɩ dɔ y. Bɩncɛ ŋ y'a yɩ hi bɩ lɛ ra, an zerle bɩncɛ. Ŋ lɛ n taa k'a a da ma, k'a kɔɔlʊʊ bɩ da jɩm ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ŋ n baŋŋarɔ wɔɔ zɩnzɛ, ŋnɩ pɔyaarɔ wɔɔ to hi b'ʊ, kʊ kɔɔlʊʊ bɩ n a da ma, an ta. Ŋ n kɔɔlʊʊ bɩ bɩrlɛ hɔ bɩ ba yɔhɔ-yɔhɔ, ŋnɩ kɔɔlʊʊ bɩ pɛɛra poore bɩ busu, ŋnɩ kɔɔlʊʊ bɩ to, an nɩ tam bɩncɛ gər zeezi. ");
INSERT INTO bib_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kɔɔlʊʊ bɩ n aa der nyɩntaa dimbir la, lɛɛ bɩ n wɔ, a b'a dam ma a n bɔ y. Bɩ ma bɩ, hikurero wɔɔ b'a jɛ bɩ zɛ, an a kɩnkaansʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sʊrdaarɔ wɔɔ n a ŋʊa k'a lɔnnɔ wɔɔ zɩnzɛ, kʊ ŋ gɔsɩnnɔ darɛ dɔ ŋ yaa a si hi bɩ burə ʊ. ");
INSERT INTO bib_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Bɩ, sʊrdaa zɔrɔ lɛɛzaa bɩ k'a ŋʊa k'a Pol bʊmbɔ bɩ, a n yɛ kʊ ŋ nɩ ŋ zɩnzɛ y. A lɛ ka gʊɔɔ kʊ ŋ darɛ dɔ rɔ wɔɔ ʊ, kʊ ŋ nɩ lɛɛ ka, ŋn'a da hi b'ʊ, kʊ ŋ n'aa tara gər bɩ ku. ");
INSERT INTO bib_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Gʊɔɔ kʊ ŋ gɔɔta rɔ wɔɔ dam gɔrɔ ʊ gɛɛ kɔɔlʊʊ bɩ kəəro wɔɔ ʊ. A yɩ ncɩnaaʊ, ŋ haay n lee ku tara ʊ kan laafɩɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kʊ wɔɔ bɔ mim pakra bɩ nɔ ʊ bɩ, wɔɔ ma ŋ ʊ, tara k'a nɩ hi bire ʊ bɩ tɔ m Maltɩ. ");
INSERT INTO bib_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Tara bɩ zannɔ wɔɔ wɔɔ si kan daʊrɛ gʊta kɩ. Ŋ sɛ gʊta hɛ, ŋnɩ wɔɔ gaa, ŋnɩ wɔɔ zɔ ma, bala, la a sɩŋŋɩda ba, an nɩ barɛ, nyɛɛm n ta ʊ. ");
INSERT INTO bib_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol n nyʊkɔ gər gʊr a zangʊrga ʊ, an b'a da sɛ bɩ rɛ. Kʊ sɛ bɩ nɩ nyʊkɔ bɩ bɩm bɩ, cɩrka bɔ sɛ b'ʊ, an a sɔ wɔ Pol wɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Tara bɩ zannɔ kʊ ŋ cɩrka bɩ yɩ, an nɩ zeŋŋəm Pol wɔ ma bɩ, ŋ y'a hɩm kʊ m, ŋ ʊ: «Gʊaa naa do nyɩntam gərzer paan… A bɔ hi bɩ nɔ ʊ kan laafɩɩ kɩ, bɩ Woso tɩrgabaazaa lɛ baa a mɩsɩrbaa ma y.» ");
INSERT INTO bib_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pol n a wɔ vɩga zɛ, cɩrka bɩ n a da sɛ b'ʊ, b'a n busu ma y. ");
INSERT INTO bib_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ŋ n jɩm, ŋn'ɩ dɩgarɛ a wɔ bɩ ma, a hanrɛ gɛɛ, a y'a dore, an ga lɛɛ nɩ? Bɩ, kʊ ŋ dɩgarɛ bɩ maasɩrɛ ba, bɩ ŋ n hɔsɩ yɩ an ba bɩ, ŋ y'a hɔɔndarɛ bɩ lʊr, ŋ ʊ: «Woso m!» ");
INSERT INTO bib_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Lɛɛ bɩ do ʊ bɩ, tararɔ nyɩnta ʊ, lɛɛkarɛ dʊdɔkər Publiyus y'a so ŋ ʊ. A wɔɔ si, an nyasʊ wɔɔ m mɩŋŋa dɔmɩm kaakʊ. ");
INSERT INTO bib_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","A zɩ nyɩnta an nɩ wʊtam kan mɛmarɛ kɩ, yoor kɩ. Pol n ta, an aa dɩga a, an aa a wɔ busu, an a ka ra, an yaa da, an a waa. ");
INSERT INTO bib_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Naa do minto bɩ, tara bɩ gʊɔɔ gɔsɩnnɔ wɔɔ haay kʊ ŋ nɩ yaaba m nɔ wɔɔ ɩ zɛm zi, ŋ n'a waam sɔ. ");
INSERT INTO bib_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Wɔɔ daʊrɛ yɩ gʊta, kʊ wɔɔ ʊ bɔ, ʊ n nɩ cenim bɩ, ŋ hɔ haay k'a zibəə n ta wɔɔ ma rɔ wɔɔ ka wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Mom kaakʊ jɛ ʊ bɩ, wɔɔ da kɔɔlʊʊ k'a gɔɔta tara bɩ do ra b'ʊ nyɛɛm dɔmɩm ʊ. Alɛsandrii kɔɔlʊʊ m, a tɔ m Diyoskiir. ");
INSERT INTO bib_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Wɔɔ zer Sirakɩɩzɩ ʊ k'ʊ hoon si dɔmɩm kaakʊ. ");
INSERT INTO bib_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kʊ wɔɔ cem b'ʊ bɩ, wɔɔ ʊ da higʊta bɩ lezi, ʊ aa lee ku Regiyo ʊ. Bɩ dɔ k'a mɛ bɩ, hɩnhɛr wuti jɩsa, dɔmɩm hɩɩya hinni ʊ, wɔɔ yaa lee ku Puzɔl ʊ. ");
INSERT INTO bib_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Wɔɔ ʊ danyɩnɔ yɩ b'ʊ, ŋn'a yɛ wɔɔ han k'ʊ gɔɔta kan a kɩ dɔmɩm saanhɩna. Nyɩnta a ʊ ncɩnaaʊ, ʊ bɔkarɛ, ʊ lee ku Rɔm ʊ. ");
INSERT INTO bib_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Wɔɔ danyɩnɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ kʊ ŋ wɔɔ zɛrɛ bɩ ma bɩ, ŋ bʊr, ŋnɩ bɩ wɔɔ zɛ ʊ bɩncɛ kʊ n n'a birm Apiyus-Daasɩ kan Tavɛrnɩ-Kaakʊ kɩ ʊ. Pol k'a ŋ yɩ bɩ, a barka da Woso m, a heer paŋŋa n a da ra. ");
INSERT INTO bib_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kʊ wɔɔ lee ku Rɔm ʊ bɩ, n zaa ka Pol ʊ, k'an a ka a mɩŋŋa har ma, kʊ sʊrdaa deem n bɩr dɔm ma. ");
INSERT INTO bib_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Dɔmɩm kaakʊ k'a cem bɩ, a Rɔm zɩɩfʊrɔ jɩtannɔ wɔɔ bir, kʊ ŋ nɩ kʊ zɛ ʊ. Kʊ ŋ y'a so kʊ ma bɩ, a a hɩ ŋ nɩ, a ʊ: «M danyɩnɔ, mɔɔ n hɔsɩ ba m dogʊɔɔ wɔɔ nɩ y, mɔɔ n wɔɔ zɩrɔ wɔɔ yɩnnɩbayɩ zibəəro zar sɔ y. Ŋ mɔɔ ba lɔ Zerizalɛm ʊ, ŋnɩ mɔɔ da Rɔm zannɔ wɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Kʊ ŋ laaka dɩnda ŋ nɩ mim bɩ jɩ dɔ kɛɛrɛ bɩ, ŋ y'a ŋʊa k'a wɔ saa mɔɔ ma, bala, ŋ n hɔsɩ yɩ mɔɔ gʊr zi an a ga zɛ nɩ y. ");
INSERT INTO bib_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Zɩɩfʊrɔ wɔɔ kʊ ŋ ʊ, a bɩ yɛm bɩ, bɩ y'a ka mɔɔ n a yɛ kʊ Rɔm cir n mɔɔ dʊdɔ ka. Mɔɔ bɛɛ y'a hɩ, kʊ m mim ka m do ra y. ");
INSERT INTO bib_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Bɩ y'a ka mɔɔ n a yɛ kʊ m awɔɔ yɩ, kʊ m sʊʊra ba kan awɔɔ kɩ. Kʊ sɩra nɩ, Israyɛl taaheerlɛ minto y'a ka, mɔɔ nɩ baŋŋarɔ nɔɔn duro m.» ");
INSERT INTO bib_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ŋ n a nyɩ bɔ nʊ, ŋ ʊ: «Kʊ wɔɔ nɩ, wɔɔ n ci sɩ yɩ, an a to Zidee ʊ, an n'ɩbɩɩ mim dɩndarɛ y, bɩ, wɔɔ danyɩ sɩ n a to an b'ɩbɩɩ mim dɩnda, gɛɛ tɔbɔrɛ bʊnyaa y. ");
INSERT INTO bib_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Wɔɔ lɛ n taa k'ɩbɩɩ n hɔ k'ɩbɩɩ n'ɩ hɔɔn dam ma bɩ hɩ k'ʊ a ma, bala, lɛɛ haay ʊ, wɔɔ dɔ mɩŋŋa ŋ bɩr yɛm gʊngʊrɛ k'ɩbɩɩ nɩ zuŋ ʊ naa ʊ y.» ");
INSERT INTO bib_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ŋ n dɔmɩm cɩnta kan kʊ kɩ, ŋnɩ bʊr gʊta, ŋnɩ b'a yɩ a har ʊ. Pol sʊʊra ba kan ŋ kɩ dɔgta m an ta an yirbəə ku. Woso cirbəə bɩ mim a sa an a dɩnda, an Moyiisi lɛrɔ kan wosolɛsinnɩsorazannɔ wɔɔ kɩ mim dɩnda ŋ nɩ, k'a a da ma, kʊ ŋ n'a dɔ, ŋ ʊ, Krista bɩ Yeezuu m. ");
INSERT INTO bib_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Gɔsɩnnɔ hɔ k'a dɩnda bɩ si, niŋŋoo n a si y. ");
INSERT INTO bib_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kʊ ŋ bʊr ŋn'ɩ cenim bɩ, ŋ n kʊ ma y: Pol n mim deem hɩ ŋ nɩ, a ʊ: «Sɛnt-Ɛspri meer k'a ba kan Ezayii kɩ awɔɔ zɩrɔ minto bɩ, sɩra m. A a hɩ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ta ɩ yaa do naa do yɩ, ɩ hɩ m, ɩ ʊ: Awɔɔ y'a tʊr kam mɩŋŋa, b'awɔɔ b'a jɩ marɛ y. Awɔɔ dɩgam mɩŋŋa, b'awɔɔ b'a yɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Bala, do naa do heer b'ɩ monsigə ʊ, ŋ tʊr ga, ŋ lɛ baa k'a lɛɛ yɩ a mɩm nɩ y, ŋ lɛ baa k'a tʊr n mim ma y, ŋ lɛ baa k'a heer n a jɩ dɔ y, ŋ lɛ baa k'a a bɔ a taam k'a zu mɔɔ ʊ, kʊ mɔɔ n ŋ waa y. Woso n a hɩ bɩ n naa. ");
INSERT INTO bib_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","K'a dɔ kɛɛrɛ, a ʊ, Woso bʊmbɔrɛ naa do nyɔɔ n y'a ʊ do vantɔɔ ma, bɩ ŋ y'a sim.»  ");
INSERT INTO bib_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pol k'a meer naa do ba bɩ, zɩɩfʊrɔ wɔɔ a hʊr ŋnɩ bɩsɩ kam gʊta kan kʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pol mɩsɩrbaa ba ncɩnaaʊ dɔɔraa hɩɩya tɔr b'ʊ, an a mɩŋŋa busoo bɔ, an n'a mɩsɩrbaa ba n nɩ. Gʊɔɔ haay kʊ ŋ nɩ zɛm zi rɔ wɔɔ, a yɩ ŋ sim mɩŋŋa, ");
INSERT INTO bib_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","an nɩ Woso cirbəə pa darɛ, an nɩ Zuuba Yeezuu Krista mim dɩndam kan heerkoodəbaa kɩ, bɩ gɔsɩ bɩr a tam nɩ tolle y.");
INSERT INTO bib_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mɔɔ mɩŋŋa, Pol, Krista Yeezuu zibəənyɩ m mɔɔ m, mɔɔ ɩ ci naa do ba awɔɔ ma. Woso mɔɔ bir kʊ m m ba a zibəəzaa, a mɔɔ bɔ ʊ m hɔ, k'a mɔɔ nyɔɔ kʊ m aa lemim nyɩnta bɩ pa da. ");
INSERT INTO bib_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Lemim nyɩnta bɩ do Woso nyɩnta an a ler bɔ tee… Wosoci nɔ ʊ, a lɛsinnɩsorazannɔ lɛ m bɩ. ");
INSERT INTO bib_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Lemim nyɩnta bɩ do bɩ, a Nyɩ Yeezuu Krista, wɔɔ Zuuba bɩ mim an n'a dɩndam. K'a mɛsim nɔ ʊ nɩ, Davɩd do gʊaa m. ");
INSERT INTO bib_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Bɩ, kʊ *Sɛnt-Ɛspri zibəə nɩ, Woso a mɩm bɔ ʊ gəəno bire ʊ, hɔ bɩ do n a hɩnka a ʊ, Woso Nyɩ m an nɩ paŋŋa m. ");
INSERT INTO bib_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Yeezuu Krista minto m mɔɔ n barka yɩ, m m ba a zibəəzaa, kʊ m a ka kʊ do haay gʊɔɔ m sɩra ka ʊ, ŋnɩ zu ʊ. ");
INSERT INTO bib_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Awɔɔ ɩ gʊɔɔ wɔɔ duro barla, bala, Yeezuu Krista y'awɔɔ bir k'a so awɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Awɔɔ haay kʊ sɩrakarɛzannɔ n'awɔɔ m, an nɩ Rɔm ʊ, Woso awɔɔ ŋʊa, an awɔɔ bir k'a nyɩnta a gʊɔɔ barla. A yɛ mɔɔ nawʊm kʊ wɔɔ Zɩ Woso, kan Zuuba Yeezuu Krista kɩ m barka kan laafɩɩ kɩ ka awɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","A n lɛɛ ka bɩ, mɔɔ ɩ yaa dam Woso kʊ mɔɔ n'a zi bam bɩ m barka, Yeezuu Krista nɔ ʊ, awɔɔ haay minto, bala, durnya nɔ ʊ jilli n y'awɔɔ sɩrakarɛ mim dɩndam. ");
INSERT INTO bib_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Woso zi mɔɔ n'a barɛ kan m heer kɩ haay, a Nyɩ bɩ lemim nyɩnta bɩ padarɛ nɔ ʊ, a m mɔɔ kasɛtɩzaa, a a dɔ a ʊ, mɔɔ dɔmɩm haay yaadarɛ nɔ ʊ, mɔɔ y'awɔɔ tɔ darɛ m nɔ ʊ, ");
INSERT INTO bib_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","m n'a yɛm han, k'a hɔɔnhɔ m, kʊ m kɔ, m zaa yɩ, m bʊr awɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Mɔɔ lɛ taa paan… kʊ m awɔɔ yɩ, kʊ m Sɛnt-Ɛspri ganwʊrɛrɔ jir kan awɔɔ kɩ, k'awɔɔ paŋŋa n a da ra gʊta, ");
INSERT INTO bib_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","gɛɛ, k'ʊ kʊ paŋŋa da ra, awɔɔ kan mɔɔ kɩ, sɩrakarɛ deem kʊ wɔɔ n ta m bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","M danyɩnɔ, mɔɔ lɛ taa k'awɔɔ n a dɔ a ʊ, mɔɔ gɩnga gallɛm hɔka kʊ m bʊr awɔɔ zi, bɩ, an ta an her ku naa, mɔɔ n m da ma y. A ŋʊa mɔɔ ʊ kʊ m bɩ lee ku awɔɔ zi b'ʊ, kʊ m zibəə n nyɩ da, amba a a da kʊrɔ vantɔɔ ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Hɔɔngʊrɛzannɔ kan bahɔɔngʊrɛzannɔ kɩ mim pakra ba mɔɔ ma, mindonno kan bamindonno kɩ mim pakra ba mɔɔ ma sɔ. ");
INSERT INTO bib_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Naa y'a ka mɔɔ lɛ n taa paan… kʊ m lemim nyɩnta pa da awɔɔ m sɔ, awɔɔ k'a nɩ Rɔm ʊ rɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nyannɩ bɩr mɔɔ zɛm lemim nyɩnta bɩ tɔ ma y, bala, Woso paŋŋa m, an nɩ gʊaa haay k'a sɩra ka bʊmbɔm. Zɩɩfʊrɔ a lɛɛ ka ŋ ma, an bɔkarɛ an lee ku do vantɔɔ wɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Wɔɔ y'a yɩm sɔ denter, lemim nyɩnta bɩ nɔ ʊ Woso tɩrgabaa n'a hɩnkaŋ ʊ, Woso ɩ gʊaa k'a sɩra ka bɩ bam tɩrga, sɩra k'a a ka Woso ʊ bɩ minto bala, amba n y'a gʊrsɩra ba Wosoci nɔ ʊ, n ʊ: ‹Gʊaa k'an tɩrga sɩrakarɛ tɔ ma bɩ mɩsɩrbaa bam.› ");
INSERT INTO bib_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Woso a to brama an a heerbusu hɩnka, kʊ gʊɔɔ bɩr a daŋ ʊ, mimbʊnyaarɔ ŋn'ɩ ŋ bam, ŋ bʊnyaabaa n a ka, sɩra bɩr dɔm dɔ sɔ y. ");
INSERT INTO bib_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Denter m, hɔ k'a n'a karɛ ŋnɩ Woso dɔ n a nyaakʊm da y, Woso a hɩnka kʊ ŋ n'a dɔ mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Paŋŋa kʊ Woso n ta m b'a jirə ba ʊ bɩ, kan Woso mɩŋŋa taʊrɛ kɩ bɩ, gɔsɩ bɩr ŋ yɩrɛ y, bɩ durnya darɛ tɛkka ma, gʊaa a da ma an ŋ yɩ hɔɔ kʊ Woso ŋ da rɔ wɔɔ nɔ ʊ, naa minto bɩ, gʊɔɔ bɩ gumə yɩm fɩɩga y. ");
INSERT INTO bib_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ŋ Woso dɔ, bɩ ŋ bɩr Woso daŋ ʊ, ŋn'a barka darɛ amba Woso a ga m bɩ nɩ y. Naa n a ka, ŋ hɔɔndarɛ n'a ba daŋŋada, ŋ n kʊrɔ hɔɔn ma, ŋn'ɩ monsigə ʊ. ");
INSERT INTO bib_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ŋ y'a hɩrɛ a ma mindɔrɛzannɔ, an bɔkarɛ taajɛmzannɔ m, ");
INSERT INTO bib_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","a ga kʊ ŋ y'a ʊ m, kʊ ŋ nɩ Woso k'a nɩ lɛbɔʊrɛ m, an nɩ mɩsɩrbaa m tee… bɩ da ʊ bɩ, bɩ to ŋ y'a ʊ ŋn'ɩ *wosobaawɔnnɔ kʊ ŋ bɔ kʊ ʊ kan gʊaa k'a nɩ ga m kɩ, bɛnnɔ kɩ, hɔɔgansiro kɩ, tara burə hɔɔ kʊ ŋ n'a gaatam nɔ kɩ daŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Naa minto m, Woso n ŋ to ŋn'ɩ dintim zibəəro kʊ ŋ lɛ n taa rɔ wɔɔ barɛ a hɔɔnhɔ ma, ŋn'a mɛ gore bɔŋ ʊ mim k'a nyannɩ n ta ʊ barɛ nɔ ʊ kan kʊ kɩ. ");
INSERT INTO bib_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bala, ŋ Woso sɩra minno wɔɔ to ŋnɩ ŋʊaar sa, ŋn'ɩ yaa dam hɔɔ kʊ Woso ŋ da rɔ wɔɔ m, ŋn'ɩ zure ŋ ʊ, an bɔkarɛ Woso ŋ y'a ga m, ŋn'a da ʊ, a m hɔ haay darɛzaa. Woso n lɛbɔʊrɛ yɩ dɔmɩm haay! Amina! ");
INSERT INTO bib_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Naa minto m, Woso n ŋ to, kʊ ŋ nɩ bɩr a nyannɩ minno lɛtaamarɔ bam. Ŋ lannɔ wɔɔ bɩr a kam ma sɔ, k'a bɩr kan yar kɩ y, wʊta ŋ nawʊm lannɔ kan kʊ kɩ, an bɔkarɛ, naa barɛ n a ga nɩ y. ");
INSERT INTO bib_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Yaarɔ wɔɔ maam sɔ, ŋ bɩr a kam ma, k'a bɩr kan lʊ kɩ y, a ŋʊa ŋ nawʊm paan…, k'a bɩr wʊtam kan a muno yaarɔ kɩ. Yaarɔ kan yaarɔ kɩ nɩ nyannɩ zi bam kan kʊ kɩ, naa n a ka sɔ, ŋn'a nyaanlɛ zibəə fɩryɩrɛ k'a a ga m yɩrɛ a mɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kʊ ŋ n a ŋʊa k'a Woso dɔ bɩ, Woso n ŋ to a hɔɔn daŋŋada bɩ nɔ ʊ, kʊ ŋ nɩ hɔ k'a n'a ga barɛ m bɩ ba. ");
INSERT INTO bib_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Zibəə k'a n a ga barɛ m do haay ba ŋ nawʊm, mimbʊnyaa do haay, gʊɔɔ lɛtaama bʊnyaa do haay, bʊnyaabaa do haay, jɩmbaa n ŋ heer han, gərzɛrɛ ba n nɩ, nyaabarɛ ba n nɩ, zambʊbarɛ ba n nɩ, zibəə daŋŋada haay, ");
INSERT INTO bib_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ŋn'ɩ tɔ bɔm, ŋn'ɩ gʊɔɔ tɔ zaar barɛ, ŋnɩ sɔ Woso m, ŋ bɩr gʊɔɔ daŋ ʊ y, ŋn'a mɩŋŋɔɔ busum, ŋn'a lɛ bɔrɛ a mɩŋŋɔɔ ʊ, ŋn'ɩ bɔm mimbʊnyaa daarɔ barɛ m, ŋ bɩr yɛm a zɩrɔ lɛ ma y, ");
INSERT INTO bib_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ŋ hɔɔn ba ʊ y, ŋ bɩr jɩnlɛ a lɛ ra y, gʊaa mim bɩr ŋ kɔrɛ y, gʊaa cicir bɩr ŋ zɛrɛ y. ");
INSERT INTO bib_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","A n bɔkarɛ, ŋ y'a dɔ mɩŋŋa ŋ ʊ, Woso lɛ y'a hɩrɛ a ʊ, gʊaa k'a nɩ ziro nɔɔn duro barɛ a ga zɛ m. Kan naa kɩ haay ŋ gɔɔta ŋn'ɩ tam lɛɛ kan minno nɔɔn duro barɛ kɩ. A n a na ma bɩ, kʊ ŋ gʊaa yɩ sɔ, an nɩ minno nɔɔn duro barɛ, bɩ ŋ nɔ yɩ. ");
INSERT INTO bib_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ncɩnaaʊ bɩ, nka n'ɩbɩɩ nɩ, ɩbɩɩ k'ɩ n'ɩ gʊɔɔ dʊdɔ yarlɛ? Ɩbɩɩ bɩ gumə yɩrɛ y, gʊɔɔ dʊdɔ k'ɩbɩɩ n'a yarm bɩ, ɩ mɩŋŋa dʊdɔ ɩ n'a yarm, bala, ɩbɩɩ yɩ ŋ dʊdɔ yarm, b'ɩbɩɩ ɩ zi kʊ ŋ n'a bam bɩ bam sɔ. ");
INSERT INTO bib_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Wɔɔ dɔ denter m, ʊ ʊ, gʊɔɔ kʊ ŋ nɩ minno nɔɔn duro bam nɔ wɔɔ, Woso yɩm dʊdɔ yarm sɩra m, amba ŋ zibəə bʊnyaa b'a ga m bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ɩbɩɩ k'ɩ nɩ gʊɔɔ kʊ ŋ nɩ minno nɔɔn duro bam nɔ wɔɔ dʊdɔ yarm bɩ, b'ɩbɩɩ y'a barɛ, am ŋ hɔ bɩ m bɩ, ɩ hɔɔn ɩbɩɩ da ɩ ʊ, ɩ bɔm lɛm Woso dʊdɔyarlɛ bɩ nɔ ʊ ra? ");
INSERT INTO bib_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Gɛɛ, ɩbɩɩ bɩr dɩgam Woso ŋʊarɛ gʊta k'an ta m ɩbɩɩ minto, an nɩ bʊrlɛ a ma, k'a mɩŋŋa ba ɩbɩɩ m bɩ ma hɔsɩ ra? Ɩbɩɩ n a dɔ ɩ ʊ, a ba k'a nawʊrɛ ɩbɩɩ m mɩŋŋa bɩ, a hɩ a ʊ, k'ɩbɩɩ m toore yɩ, ɩ ɩ bɔ ɩ taam la? ");
INSERT INTO bib_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","B'ɩbɩɩ da bɩr bɔŋ ʊ y, ɩ lɛ baa k'ɩ ɩ bɔ ɩ taam y, bɩ, a ba k'ɩbɩɩ n nawʊrɛ ncɩnaaʊ naa, hʊnhʊrlɛ gʊta ɩbɩɩ n'a bankarɛ ɩ minto, dɔmɩm kʊ Woso n n'a heerbusu hɩnkaŋ ʊ, an dʊdɔ ka kan sɩra kɩ bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Hinni bɩ do ʊ bɩ, a gʊaa biyəə zibəə nyɔɔdʊ kaŋ ʊ, amba a a ga m bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Gʊɔɔ kʊ ŋ n'a tɔŋ ʊ, k'a mɩŋŋa ba tee…, ka Woso nɔ yɩ, ŋn'a kam Woso lɛbɔʊrɛ ma, kan a daʊrɛ kɩ ma, kan mɩsɩrbaa k'a bɩr a zaar bam kɩ ma rɔ wɔɔ, Woso mɩsɩrbaa k'a nyarɛ ba ʊ karɛ ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Bɩ, kʊ gʊɔɔ kʊ ŋ nɩ bɩsɩ kam Woso ma, ŋ bɩr zum sɩra ʊ y, ŋn'a bʊnyaa bam nɔ wɔɔ nɩ, Woso y'a nɔmaa kan a heerbusu kɩ hɩnkarɛ ŋ nɩ. ");
INSERT INTO bib_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kʊsɩ kan fɩr kɩ gʊɔɔ kʊ ŋ n'a bʊnyaa bam nɔ wɔɔ yɩm, zɩɩfʊrɔ n nɩ lɛɛ kam, do vantɔɔ wɔɔ n a nya ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Bɩ, Woso lɛbɔʊrɛ, daʊrɛ, kan laafɩɩ kɩ kam gʊaa haay k'a n'a mɩŋŋa bam b'ʊ, zɩɩfʊrɔ n nɩ lɛɛ kam, do vantɔɔ wɔɔ n a nya ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Bala, Woso bɩr gʊɔɔ jirə bɔrɛ y. ");
INSERT INTO bib_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Gʊɔɔ kʊ ŋ nɩ mimbʊnyaa bam, ŋ n Moyiisi lɛrɔ wɔɔ dɔ rɔ wɔɔ, ŋ gɩngam sɔ, bɩ Moyiisi lɛrɔ bɛɛ n nɩ nyɩntarɛ ŋ dʊdɔ karɛ zaa y, bɩ gʊɔɔ kʊ ŋ lɛrɔ wɔɔ dɔ, ŋn'a gu ŋn'ɩ mimbʊnyaa bam nɔ wɔɔ, lɛrɔ wɔɔ n nɩ nyɩntarɛ ŋ dʊdɔ karɛ zaa. ");
INSERT INTO bib_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Bala, gʊɔɔ kʊ ŋ n'a tʊr kam lɛrɔ wɔɔ ma bala rɔ wɔɔ bɛɛ m tɩrga Woso mɩm ʊ y, gʊɔɔ kʊ ŋ nɩ zure ŋ ʊ rɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","A a da ma, gʊɔɔ kʊ zɩɩfʊrɔ bɛɛ nɩ ŋ mɩ y, ŋ n Moyiisi lɛrɔ wɔɔ dɔ rɔ wɔɔ, nɔɔ m hɔ kʊ lɛrɔ wɔɔ n'a hɩm bɩ ba, bɩ ŋ n a dɔ y. A ba kʊ ŋ nawʊrɛ ncɩnaaʊ bɩ ŋ n lɛrɔ wɔɔ dɔ bɩ, naa y'a hɩnkarɛ a ʊ, ŋ lɛ cɩnta a mɩŋŋɔɔ m. ");
INSERT INTO bib_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ncɩnaaʊ bɩ, ŋ y'a hɩnkarɛ ŋ ʊ, hɔ kʊ lɛrɔ wɔɔ lɛ n taa bɩ, n y'a gʊrsɩra ba a heer ʊ, ŋ heer ɩ kasɛtɩ kam, kan ba ŋ mɩŋŋɔɔ tɩr a dɔ ŋ ʊ, a mɩŋŋa ba gɛɛ a bʊnyaa ba bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Nyɩnta a nawʊrɛ ncɩnaaʊ dʊdɔkarɛ hinni ʊ, amba lemim nyɩnta kʊ mɔɔ n'a pa dam bɩ n'a hɩm bɩ m, Woso zaa kam Krista Yeezuu ʊ k'an hɔ haay k'a nyaakʊm da gʊɔɔ heer ʊ bɩ dʊdɔ ka. ");
INSERT INTO bib_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ɩbɩɩ k'ɩ n'a hɩrɛ ɩ ma zɩɩfʊ, ɩ nɩ yom lɛrɔ wɔɔ ma, ɩ n'ɩ lɛ bɔrɛ ɩ mɩŋŋa ʊ, ɩ ʊ, ɩ Woso dɔ, ");
INSERT INTO bib_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ɩbɩɩ k'ɩ hɔɔnhɔ dɔ, lɛrɔ wɔɔ tɔ ma bɩ, ɩbɩɩ hɔ k'a ga barɛ m bɩ dɔ ɩ bɔ kʊ la m. ");
INSERT INTO bib_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ɩbɩɩ y'ɩ hɔɔn darɛ ɩ ʊ, zaa hɩnka bʊʊrɔ m zaa n'ɩbɩɩ m, ɩ nɩ lɛɛ gum monsigəzannɔ m, ");
INSERT INTO bib_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ɩ ʊ, bahɔdonno dʊndɔrɛzaa n'ɩ mɩ, gʊɔɔ poorero karɩnsaamba, a gɩnga ɩbɩɩ nawʊm ɩ ʊ, ɩbɩɩ hɔ dɔ, ɩ sɩra dɔ mɩŋŋa lɛrɔ wɔɔ minto. ");
INSERT INTO bib_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","A lɔ ɩbɩɩ nɩ hɔ dɩndam gʊɔɔ m, ɩ bɩr a dɩndarɛ ɩ mɩŋŋa nɩ? Ɩbɩɩ y'a hɩm gʊɔɔ m, ŋ bɩ koor ba y, ɩ bɔkarɛ ɩ nɩ koor barɛ. ");
INSERT INTO bib_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ɩbɩɩ y'a hɩrɛ ŋ bɩ jaan da y, ɩ bɔkarɛ ɩ n'a darɛ, ɩbɩɩ sɔ *wosobaawɔnnɔ daʊrɛ m, ɩ bɔkarɛ ɩ nɩ gasʊrɛ ŋ daʊrɛ cɛrɔ ʊ, ɩ nɩ ŋ bɔm. ");
INSERT INTO bib_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ɩbɩɩ y'ɩ heer nyɔɔm lɛrɔ wɔɔ k'ɩbɩɩ ŋ dɔ bɩ tɔ ma, b'ɩbɩɩ ɩ Woso gore bɔŋ ʊ, k'ɩbɩɩ nɩ bɩsɩ kam lɛrɔ wɔɔ ma bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Amba n y'a gʊrsɩra ba Wosoci nɔ ʊ bɩ, n ʊ: ‹Awɔɔ zɩɩfʊrɔ, awɔɔ y'a kam, do vantɔɔ wɔɔ nɩ Woso sʊnsɔ wʊm.› ");
INSERT INTO bib_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","K'ɩbɩɩ ɩ zum lɛrɔ wɔɔ ʊ, gasʊ k'ɩbɩɩ ʊ baŋŋʊ ʊ bɩ jɩ ta ʊ, bɩ k'ɩbɩɩ y'ɩ gum lɛrɔ wɔɔ zuure ma, baa k'ɩbɩɩ gasʊ baŋŋʊ ʊ, a bɔ kʊ ʊ, ɩ ʊ, ɩbɩɩ n gasʊ baŋŋʊ ʊ y. ");
INSERT INTO bib_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Bɩ, kʊ gʊaa k'a n gasʊ baŋŋʊ ʊ ɩ hɔ kʊ lɛrɔ wɔɔ n'a hɩm bɩ barɛ, Woso bɩ dɩgarɛ a zaa ma ɩ ʊ, gasʊ a ʊ baŋŋʊ ʊ ra? ");
INSERT INTO bib_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Bɩ, gʊaa k'a nɩ zum lɛrɔ wɔɔ ʊ b'a n gasʊ baŋŋʊ ʊ bɩ, a y'ɩbɩɩ dam nyannɩ ʊ, bala, ɩbɩɩ gasʊ baŋŋʊ ʊ, ɩ nɩ lɛrɔ wɔɔ m, bɩ, ɩbɩɩ bɩr zure ŋ ʊ y. ");
INSERT INTO bib_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Zɩɩfʊ paan… bɩ, gʊaa k'a m zɩɩfʊ gʊɔɔ mɩm ʊ bɩ bɛɛ y, mɛsim gasʊ baŋŋʊ ʊ bɛɛ m baŋŋʊgasʊrɛ paan… y. ");
INSERT INTO bib_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Bɩ, zɩɩfʊ paan… bɩ, heer an ta ʊ, baŋŋʊgasʊrɛ paan… bɩ, heer hɔ bɩ m. A to a nawʊm *Sɛnt-Ɛspri zi, a bɩr a tom Moyiisi lɛrɔ wɔɔ nɔ ʊ y. Zɩɩfʊ bɩ do lɛbɔʊrɛ bɩr a tom gʊɔɔ zi y, a to a nawʊm Woso zi. ");
INSERT INTO bib_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ncɩnaaʊ naa, k'ɩ zɩɩfʊ, bɔ ɩ n'a yɩrɛ a nɔ ʊ, baŋŋʊgasʊrɛ nyɔɔdʊ m bɔ nɩ? ");
INSERT INTO bib_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","A nyɔɔdʊ ta ʊ gʊta denter. Bala, a lɛɛkarɛ hɔ bɩ, zɩɩfʊrɔ wɔɔ Woso a lemim da ŋ wɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","K'ʊ a hɩ, ʊ ʊ lɔ? Ŋ gʊɔɔ gɔsɩnnɔ kʊ ŋ n sɩra ba minto b'a da ma, an a ka Woso bɩ gɔɔtarɛ a sɩrabarɛ nɔ ʊ ra? ");
INSERT INTO bib_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Fɩɩga! Baa, kʊ gʊaa haay ŋʊaarzaa, Woso gɔɔta an nɩ sɩra m, amba n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: Kʊ n n'ɩ dɔ tɩrga ɩ meerbaa nɔ ʊ, bɩ k'ɩ bʊr ɩ jɩnnɔ ra dʊdɔkarɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Bɩ, kʊ wɔɔ batɩrgabaa ɩ Woso tɩrgabaa hɩnkarɛ, bɔ wɔɔ k'ʊ a hɩ? K'ʊ a hɩ, ʊ ʊ, Woso gumə ba ʊ kan wɔɔ hʊnhʊrlɛ kɩ a nɔmaa nɔ ʊ ra? Meer naa do kʊ wɔɔ ba naa, gʊɔɔ hɔɔndarɛ meerbaa m. ");
INSERT INTO bib_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","A bɩ ncɩnaaʊ y, kʊ n bɛɛ m, Woso y'a bam lɔ k'a durnya dʊdɔ ka? ");
INSERT INTO bib_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Gɛɛ, gʊaa a da ma, an a hɩ a ʊ, kʊ mɔɔ ŋʊaarbarɛ y'a kam Woso sɩra n'a hɩnkam paan… a lɛbɔʊrɛ minto, bɔ m kɛɛrɛ, an mɔɔ ba mimbʊnyaazaa, an nɩ mɔɔ dʊdɔ karɛ? ");
INSERT INTO bib_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","A lɔ wɔɔ bɩr mimbʊnyaa barɛ, k'a mɩŋŋa m nyɩnta ʊ? Gʊɔɔ gɔsɩnnɔ ɩ wɔɔ tɔ bʊnyaa hɩm, ŋn'a hɩrɛ ŋ ʊ, naa wɔɔ n'a dɩndam gʊɔɔ m. Kʊ Woso bɩ gʊɔɔ wɔɔ duro dʊdɔ yar, a gumə ta ʊ. ");
INSERT INTO bib_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ʊ a nyambʊr ʊ a hɩ, ʊ ʊ lɔ? Wɔɔ zɩɩfʊrɔ, lɛ wɔɔ da gʊɔɔ vantɔɔ wɔɔ m na? Fɩɩga! Wɔɔ lɛɛ ka ʊ a hɩnka, ʊ ʊ, gʊaa haay, kʊ zɩɩfʊ m, gɛɛ zɩɩfʊ bɛɛ, ŋ yɩ mimbʊnyaa lɔmbaa nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Amba n y'a gʊrsɩra ba Wosoci ʊ bɩ m, n ʊ: Gʊaa tɩrga ba ʊ y, baa deem taan… tɔkkɛ, ");
INSERT INTO bib_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Woso mindor ba ʊ y, baa deem taan… ba ʊ, an n'a kam Woso ma y. ");
INSERT INTO bib_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ŋ haay, ŋ y'a nyʊnnyɔɔ, ŋ haay jilli, a bʊnyaa ŋn'a bam. Ŋ barla bɩ, a mɩŋŋabarɛzaa ba ʊ y, baa deem taan… tɔkkɛ. ");
INSERT INTO bib_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ŋ lɛ meerbaa ɩ gʊɔɔ zaar bam. Bra ŋn'a bɩmbam gʊɔɔ m, a lɛ meerbaa m, ŋ nɛɛm ɩ busum am cɩrka sɛ m. ");
INSERT INTO bib_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Ler kʊsɩ bɔrɛ yɩ ŋ lɛ han, kan meerbaa k'a nɩ busum gʊɔɔ ma kɩ. ");
INSERT INTO bib_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ŋ kaarɛ kan gərzɛrɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Kʊ ŋ bɔ lɛɛ bɩ do ʊ, lɛɛ zaarbarɛ kan kʊsɩ kɩ ŋn'a tore a jɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ŋ n laafɩɩ zaa dɔ y. ");
INSERT INTO bib_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ŋ mɩm ʊ bɩ, Woso daʊrɛ jɩ ba ʊ y. ");
INSERT INTO bib_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","A n bɔkarɛ, wɔɔ dɔ, ʊ ʊ, hɔ haay kʊ lɛrɔ wɔɔ n'a hɩm bɩ, a hɩ a nawʊm gʊɔɔ kʊ lɛrɔ wɔɔ a so ŋ ʊ rɔ wɔɔ m. Kʊ gɔsɩ b'a da ma, an gumə ka a mɩŋŋa ʊ y, kʊ durnya haay m kʊrɔ gumə ma Woso taa. ");
INSERT INTO bib_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Bɩ y'a ka, ‹gɔsɩ b'a bam tɩrga Woso mɩm ʊ›, lɛrɔ wɔɔ zi k'a ŋ ba minto y, lɛrɔ wɔɔ, gʊaa mimbʊnyaa ŋn'a hɩnkam nɩ bala. ");
INSERT INTO bib_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kɛɛrɛ naa, Woso hɔ k'a a ba, an wɔɔ ba tɩrga, bɩ lɛrɔ wɔɔ mim b'a nɔ ʊ bɩ hɩnka, amba lɛrɔ wɔɔ kan wosolɛsinnɩsorazannɔ wɔɔ kɩ ciro nyɩnta ŋn'a hɩ bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Woso ɩ gʊɔɔ bam tɩrga, kʊ ŋ sɩra ka Yeezuu Krista ʊ minto, a ba a nawʊrɛ ncɩnaaʊ, gʊɔɔ haay kʊ ŋ sɩra ka Krista ʊ rɔ wɔɔ m, bala, ŋ hɔdeem, a bɩr ŋ jirə bɔrɛ y. ");
INSERT INTO bib_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ŋ haay mimbʊnyaa ba, ŋ y'a do Woso lɛbɔʊrɛ gasʊʊrɛ ma. ");
INSERT INTO bib_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Bɩ, Woso ŋ ba tɩrga nɩbɩr, a cicirzɛrɛ nɔ ʊ, Krista Yeezuu k'a nɩ ŋ bʊmbɔm mimbʊnyaa nɔ ʊ bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","A mɩŋŋa Woso a bɔ ʊ, k'an ga gʊɔɔ kʊ ŋ nɩ sɩra kaŋ ʊ rɔ wɔɔ mimbʊnyaarɔ sugur yɩrɛ minto, k'a tɩrgabaa hɩnka, bala, a nyɩnta an bʊr a ma biisi, a n gʊɔɔ hʊnhʊr ŋ mimbʊnyaarɔ tɔ ma y. ");
INSERT INTO bib_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Bɩ her naa, Woso ɩ zaa k'a n'a sam, an nɩ gʊɔɔ bam tɩrga bɩ hɩnkam, bala, a lɛ taa k'a gʊɔɔ kʊ ŋ sɩra ka Yeezuu ʊ rɔ wɔɔ ba tɩrga, k'a gɔɔta a tɩrgabaa nɔ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Lɛ bɔ a mɩŋŋa ʊ zaa ta ʊ dɔ ra? Fɩɩga! Bɔ minto? Bala, a n ta ʊ kɛɛrɛ bɩ, lɛrɔ wɔɔ zuure bɛɛ y, sɩrakarɛ m. ");
INSERT INTO bib_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Sɩra m, wɔɔ dɔ ʊ ʊ, sɩrakarɛ tɔ ma m, n nɩ gʊaa bam tɩrga, bɩ lɛrɔ wɔɔ zuure tɔ ma bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Gɛɛ, Woso bɩ, zɩɩfʊrɔ Woso m bala ra? Do vantɔɔ wɔɔ Woso bɛɛ sɔ ra? Ɩɩn…, do vantɔɔ wɔɔ Woso m sɔ. ");
INSERT INTO bib_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Bala, Woso deem taan… n ta ʊ, an nɩ zɩɩfʊrɔ bam tɩrga ŋ sɩrakarɛ tɔ ma, an nɩ do vantɔɔ bam tɩrga sɔ, ŋ sɩrakarɛ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Wɔɔ sɩrakarɛ bɩ, lɛrɔ wɔɔ ba a nawʊm hɔ k'a jɩ ba ʊ ra? A bɛɛ m bɩ y, lɛrɔ wɔɔ gore an n'a daŋ ʊ paan…. ");
INSERT INTO bib_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Kɛɛrɛ naa, bɔ mim wɔɔ n'a hɩm ʊ yaaba Abraham bɩncɛ ʊ? Bɔ hɔ a a yɩ a zi nɩ? ");
INSERT INTO bib_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","K'a ɩ yɩrɛ ɩ ʊ, Abraham ba n y'a ʊ tɩrga, a zibəə tɔ ma, a a da ma an a lɛ bɔ a mɩŋŋa ʊ, b'a bɩ ncɩnaaʊ y, a b'a dam ma an a lɛ bɔ a mɩŋŋa ʊ Woso taa y. ");
INSERT INTO bib_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Bala, Wosoci bɩ y'a hɩrɛ, a ʊ: ‹Abraham sɩra ka Woso ʊ, am naa Woso n a ba tɩrga, a sɩrakarɛ tɔ ma.› ");
INSERT INTO bib_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kʊ gʊaa zi ba, a yawʊra n n'a bam, yawʊra bɩ do, ganwʊrɛ bɛɛ y, hɔ k'a zaa b'a ga m bɩ m bɩ. ");
INSERT INTO bib_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Bɩ gʊaa k'a n hɔsɩ zi ba y, an sɩra ka Woso k'a nɩ mimbʊnyaabər bam tɩrga b'ʊ bɩ, Woso ɩ dɩgam bɩ zaa ma tɩrga, a sɩrakarɛ minto. ");
INSERT INTO bib_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Davɩd ɩ gʊaa kʊ Woso dɩga a tɩrga b'a zibəə tɔ ma bɛɛ b'ɩ heernyɩnta mim hɩm sɔ, a ʊ: ");
INSERT INTO bib_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Mimbirenyɩntazannɔ m gʊɔɔ kʊ Woso ŋ kʊrɔmarɔ sugur ka ŋ ʊ, an ŋ mimbʊnyaarɔ gʊngʊ ŋ ma rɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Mimbirenyɩntazaa m gʊaa kʊ Woso bɩr a mimbʊnyaa darɛ a heer ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Mimbirenyɩnta naa do zɩɩfʊrɔ wɔɔ hɔ m a minto ra, gɛɛ do vantɔɔ wɔɔ a da ma ŋn'a yɩ sɔ ra? Wɔɔ y'a hɩrɛ, ʊ ʊ: ‹Abraham sɩra ka Woso ʊ, Woso n a ba tɩrga, a sɩrakarɛ minto.› ");
INSERT INTO bib_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ba naa a ʊ brɔ dɔmɩm ʊ? Gasʊ k'a b'a ʊ baŋŋʊ ʊ bɩ m gɛɛ, gɛɛ a lɛɛ ka a baŋŋʊgasʊrɛ bɩ nɩ? Gasʊ k'a b'a ʊ baŋŋʊ ʊ bɩ dɔmɩm bɛɛ y, a lɛɛ ka, bɩ ma bɩ, a n gasʊ baŋŋʊ ʊ y. ");
INSERT INTO bib_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Dɔmɩm kʊ Abraham n gasʊ baŋŋʊ ʊ bɩ, Woso a ba tɩrga, bɩ jɛ nɩ, Woso n bɔkarɛ, an a da ʊ, k'an gasʊ baŋŋʊ ʊ. Kʊ bɩ m nyɩnta makra, an a hɩnka a ʊ, Woso Abraham ba tɩrga, a sɩrakarɛ tɔ ma. Ncɩnaaʊ nɩ, Abraham n a ba gʊɔɔ kʊ ŋ nɩ sɩra kam Woso ʊ haay yaaba, baa kʊ ŋ n gasʊ baŋŋʊ ʊ y. Kʊ Woso n brɔɔ ba tɩrga sɔ, ŋ sɩrakarɛ minto. ");
INSERT INTO bib_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Gʊɔɔ kʊ ŋ gasʊ baŋŋʊ ʊ rɔ wɔɔ yaaba m sɔ, bɩ gʊɔɔ kʊ ŋ gasʊ baŋŋʊ ʊ ŋnɩ sɩra ka Woso ʊ rɔ wɔɔ m, amba Abraham sɩra ka Woso ʊ, bɩ ma bɩ a n gasʊ baŋŋʊ ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Woso k'a durnya soʊre ler bɔ Abraham m kan a yaŋŋɔɔ wɔɔ kɩ m bɩ, lɛrɔ zuure minto bɛɛ y, k'a Abraham ba tɩrga, a sɩrakarɛ tɔ ma bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kʊ hɔ kʊ Woso a ler bɔ bɩ yɩ n nawʊm lɛrɔ zuure tɔ ma, sɩrakarɛ jɩ ba ʊ dɔ y, lerbɔrɛ bɩ nyɔɔdʊ ba ʊ sɔ y. ");
INSERT INTO bib_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Bala, lɛrɔ wɔɔ ɩ zɛm Woso nɔmaa m, bɩ, k'a ɩ yɩrɛ ɩ ʊ, lɛrɔ ba ʊ y, lɛrɔ bɩsɩkama ba ʊ sɔ y. ");
INSERT INTO bib_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Naa y'a ka sɩrakarɛ n nɩ hɔ kʊ Woso a ler bɔ bɩ yɩm, k'an yɩ Woso ganwʊrɛ k'a n'a kam, kʊ lerbɔrɛ bɩ n nyɩnta Abraham yaŋŋɔɔ haay hɔ. Yaŋŋɔɔ kʊ ŋ nɩ lɛrɔ wɔɔ m nɔ wɔɔ bɛɛ m a deem nɩ y, yaŋŋɔɔ kʊ ŋ sɩra ka am Abraham hɔ bɩ m nɔ wɔɔ m sɔ, ʊ woo…, ʊ zɩ m Abraham m. ");
INSERT INTO bib_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Denter m, n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: ‹Ɩbɩɩ cɩnta mɔɔ ʊ, k'ɩ yɩ doro gʊta zɩ.› Wɔɔ zɩ m Abraham m, Woso k'a sɩra ka ʊ bɩ taa. Woso k'a nɩ gəəno mɩm bɔŋ ʊ, an n'a kam hɔ k'a ba ʊ nɩ nyɩntaŋ ʊ m. ");
INSERT INTO bib_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abraham sɩra ka an a ta a heer lɛ a ʊ, a hɔ kʊ Woso a ler bɔ bɩ yɩm, baa kʊ hɔsɩ ba ʊ, an nɩ yom ma k'a a dɔ a ʊ, a hɔ kʊ Woso a ler bɔ bɩ yɩm bɩ, a a gu an sɩra ka, an b'a ba doro gʊta yaaba, amba Woso a hɩ m, a ʊ: ‹Ɩbɩɩ yaŋŋɔɔ zɛm bɩ yɩ gʊta› bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abraham dɔɔraa k'a bɩ ta an zɔrɔ ku, Saara n gusi sɔ ŋ b'a dam ma ŋnɩ nyɩ yɩ dɔ bɩ, Abraham sɩrakarɛ paŋŋa gɔɔta a n a bɔrɛ y. ");
INSERT INTO bib_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","A n sɩnsɩm ka Woso lerbɔrɛ bɩ ma y, bɩ, sɩrakarɛ bɩ paŋŋa ka ʊ, an a lɛ bɔ Woso ʊ. ");
INSERT INTO bib_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","A n a nyasʊ a heer ʊ kɔɔkɔɔ a ʊ, kʊ Woso hɔ ler bɔ, a ɩ paŋŋa m sɔ, k'a ka k'an kʊ yɩ. ");
INSERT INTO bib_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Naa minto m, Woso n Abraham ba tɩrga, a sɩrakarɛ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Kʊ n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: ‹Woso Abraham ba tɩrga› bɩ, Abraham y'a deem tɔ ma bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Wɔɔ tɔ ma n sɔ, bala, n wɔɔ bam tɩrga, wɔɔ kʊ wɔɔ nɩ sɩra kam, Woso k'a wɔɔ Zuuba Yeezuu mɩm bɔ ʊ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Woso a ka n n'a zɛ gər wɔɔ mimbʊnyaarɔ tɔ ma, an a mɩm bɔ ʊ, k'a wɔɔ ba tɩrga. ");
INSERT INTO bib_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Woso wɔɔ ba tɩrga, wɔɔ sɩrakarɛ minto, wɔɔ n laafɩɩ yɩ kan Woso kɩ, wɔɔ Zuuba Yeezuu Krista tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Yeezuu Krista minto m, wɔɔ n b'ʊ dam ma, ʊ Woso cicirzɛrɛ yɩ sɩrakarɛ nɔ ʊ, cicirzɛrɛ bɩ do wɔɔ jɩm ʊ kɔɔkɔɔ, bɩ wɔɔ y'ʊ heer nyɔɔm, kʊ wɔɔ nɩ taaheerlɛ m, ʊ ʊ, ʊ zɛm bɩ nyɩnta Woso lɛbɔʊrɛ nɔ ʊ bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","A n lɛ da bɩ, wɔɔ y'ʊ heer nyɔɔrɛ ʊ fɩryɩrɛ nɔ ʊ, bala, wɔɔ dɔ, ʊ ʊ, fɩryɩrɛ n nɩ zɛm tʊntɔʊrɛ m, ");
INSERT INTO bib_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","tʊntɔʊrɛ n nɩ zɛm mim dama m, mim dama n nɩ zɛm taaheerlɛ m. ");
INSERT INTO bib_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Taaheerlɛ naa do bɩ wɔɔ dam nyannɩ ʊ y, bala, Woso a ŋʊarɛ k'an ta m wɔɔ minto bɩ da wɔɔ heer ʊ an a han, Sɛnt-Ɛspri k'a ka wɔɔ ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Sɩra m, dɔmɩm kʊ Woso a cɩnta bɩ k'a ku bɩ, wɔɔ n nɩ paŋŋawar nɔ ʊ, ʊ b'ʊ dam ma, ʊ ʊ yɔ bɩ, Krista ga wɔɔ mimbʊnyaazannɔ wɔɔ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","A wer ta ʊ, kʊ gʊaa n yɛ, an ga gʊaa tɩrga tɔ ma. A a da ma gʊaa n yɛ, an ga gʊaa mɩŋŋa tɔ ma barɛ m. ");
INSERT INTO bib_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Hɔ kʊ Woso a ba k'a wɔɔ ŋʊa k'a nawʊm bɩ hɩnka bɩ ba n nɩ: Wɔɔ nyɩnta mimbʊnyaabənno, Krista n a gu an ga wɔɔ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Woso k'awɔɔ ba tɩrga, Krista k'a ga wɔɔ tɔ ma bɩ minto bɩ, an lɛ da haay bɩ, a wɔɔ bɔ lɛ m Woso heerbusu nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Bala, nyɩnta kʊ wɔɔ ʊ Woso jɩnnɔ bɩ, a zu kʊ ʊ kan a Nyɩ bɩ garɛ kɩ, an wɔɔ zɛ kʊ ra kan a kɩ. K'a wɔɔ zɛ kʊ ra kan a kɩ kɛɛrɛ bɩ, an lɛ da bɩ, a wɔɔ bʊmbɔm sɔ a Nyɩ bɩ mɩsɩrbaa m. ");
INSERT INTO bib_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Naa bɛɛ n'a deem nɩ y, wɔɔ y'ʊ heer nyɔɔm sɔ Woso nɔ ʊ, wɔɔ Zuuba Yeezuu Krista tɔ ma, a ɩ wɔɔ zɛ kʊ ra kan Woso kɩ. ");
INSERT INTO bib_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Gʊaa deem taan… y'a ka mimbʊnyaa n gasʊ durnya ʊ, Adam m. Mimbʊnyaa bɩ do m bʊr zɛ m. Yɩ a ʊ, ncɩnaaʊ, zɛ n a kərgu gʊɔɔ haay ra, bala, ŋ haay mimbʊnyaa ba. ");
INSERT INTO bib_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Mimbʊnyaa lɛɛ ka an nɩ durnya ʊ, Woso n bɔkarɛ an lɛrɔ wɔɔ ka Moyiisi ʊ, bɩ, dɔmɩm kʊ lɛrɔ wɔɔ ba ʊ bɩ, Woso bɩr gʊɔɔ mimbʊnyaa taar karɛ ŋ la y. ");
INSERT INTO bib_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Kan bɩ kɩ, an a sa Adam dɔmɩm bɩ ma, an ta Moyiisi dɔmɩm ra bɩ, zɛ a so gʊɔɔ ʊ, baa gʊɔɔ kʊ ŋ n Adam mimbʊnyaa bɩ lɔɔ ba rɔ wɔɔ, zɛ brɔɔ zɛ sɔ. Adam nyɩnta Krista k'a a ga m, an bʊr bɩ bɔkʊʊrɛzaa. ");
INSERT INTO bib_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Bɩ, Woso ganwʊrɛ k'a n'a kam vam bɩ n bɔ kʊ ʊ kan Adam kʊrɔma bɩ kɩ y. Sɩra m, gʊaa deem kʊrɔma ɩ bʊr gʊaa cir zɛ m, bɩ Woso ganwʊrɛ bɩ gʊtabaa lɛ da, Woso ganwʊrɛ bɩ do ka gʊɔɔ ʊ, gʊaa deem taan… tɔ ma, Yeezuu Krista m, bɩ tɔ ma m, Woso n barka ka gʊaa cir ʊ gʊta. ");
INSERT INTO bib_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Hɔ kʊ Woso ganwʊrɛ bɩ n nɩ zɛm nɩ bɩ bɩ hɔdeem kan hɔ kʊ gʊaa deem kʊrɔma n nɩ zɛm nɩ bɩ kɩ y. Bala, Adam deem taan… kʊrɔma kʊ Woso a dʊdɔ yar b'a ka, gʊaa haay nɩ mimbʊnyaa kɔrɛ nɔ ʊ. A n bɔkarɛ, mimbʊnyaarɔ kʊ ŋ yɩ ŋ ba gʊta bɩ kur bɩ, Woso ganwʊrɛ bɩ ŋ ba tɩrga. ");
INSERT INTO bib_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","A yɩ sɩra, gʊaa deem mimbʊnyaa y'a ka, zɛ n a so gʊaa haay ʊ gʊaa deem bɩ tɔ ma, bɩ Yeezuu Krista deem tɔ ma, gʊɔɔ ɩ hɔ yɩm Woso zi gʊta, a y'a ganwʊrɛ gʊta bɩ karɛ ŋ ʊ nɩbɩr, an nɩ ŋ bam tɩrga. Krista tɔ ma, ŋ mɩsɩrbaa barɛ, ŋnɩ cirbəə bɩ. ");
INSERT INTO bib_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","K'a yɩ ncɩnaaʊ, gʊaa deem kʊrɔma k'a a ka, gʊaa haay nɩ mimbʊnyaa kɔrɛ nɔ ʊ bɩ, maam sɔ bɩ, gʊaa deem tɩrgabaa zibəə gʊaa haay bʊmbɔ an ŋ ba tɩrga, kʊ ŋ nɩ mɩsɩrbaa ba. ");
INSERT INTO bib_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Gʊaa deem bɩsɩkarɛ k'a ka gʊɔɔ haay n a ba mimbʊnyaabənno Woso mɩm ʊ bɩ, maam sɔ bɩ, gʊaa deem k'a yɛ Woso hɔɔnhɔ ma b'a ka, gʊɔɔ gʊta n a ba tɩrga Woso mɩm ʊ. ");
INSERT INTO bib_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","A n bɔkarɛ, bʊr kʊ lɛ b'ʊ bɩ, a a ka mimbʊnyaa n a ba gʊta, bɩ, lɛɛ kʊ mimbʊnyaa pasɩ ʊ bɩ, Woso barka nyɩnta ʊ gʊta an lɛ da. ");
INSERT INTO bib_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ncɩnaaʊ bɩ, amba mimbʊnyaa a so gʊɔɔ ʊ zɛ tɔ ma bɩ, maam sɔ bɩ, Woso barka y'a som gʊɔɔ ʊ tɩrgabaa tɔ ma, k'a ka, kʊ wɔɔ n mɩsɩrbaa k'a nyarɛ ba ʊ yɩ wɔɔ Zuuba Yeezuu Krista tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Bɔ wɔɔ k'ʊ a hɩ kɛɛrɛ? Ʊ gɔɔta ʊ bɩr mimbʊnyaa bam, kʊ Woso cicirzɛrɛ n a da ra gɛ? ");
INSERT INTO bib_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ayy…, fɩɩga! Kʊ mimbʊnyaa mim bɩncɛ nɩ, gəəno m wɔɔ m, wɔɔ y'a bam lɔ kɛɛrɛ k'ʊ mɩsɩrbaa ba mimbʊnyaa nɔ ʊ? ");
INSERT INTO bib_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Awɔɔ n a dɔ a ʊ, batɛm kʊ wɔɔ si bɩ, ʊ ba wɔɔ ʊ deem kan Krista Yeezuu kɩ a garɛ bɩ nɔ ʊ ra? ");
INSERT INTO bib_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Batɛm bɩ sire nɔ ʊ bɩ, wɔɔ bir n y'a ʊ kan kɩ a zɛ bɩ nɔ ʊ, k'an bɩr yɩrɛ ɩ ʊ, kʊ Krista a mɩm bɔ ʊ gəəno bire ʊ Zɩ paŋŋa m bɩ, maam sɔ bɩ, kʊ wɔɔ n mɩsɩrbaa daa ba. ");
INSERT INTO bib_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Bala, ʊ ba kʊ wɔɔ ʊ deem kan kɩ a zɛ nɔ ʊ bɩ, wɔɔ y'ʊ bam deem kan kɩ sɔ a mɩmbɔʊrɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ʊ a dɔ mɩŋŋa, ʊ ʊ, mɩsɩrbaa kʊ wɔɔ n ta m biisi bɩ, n y'a wɔ gɔdarkʊra ma kan Krista kɩ. Kʊ mimbʊnyaa k'a nɩ wɔɔ ʊ bɩ paŋŋa n a da, k'ʊ bɩ nyɩnta mimbʊnyaa lɔnnɔ dɔ y. ");
INSERT INTO bib_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Denter m, gʊaa k'a ga bɩ, mimbʊnyaa paŋŋa ba zi dɔ y. ");
INSERT INTO bib_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Bala, kʊ wɔɔ ga kan Krista kɩ bɩ, wɔɔ sɩra ka, ʊ ʊ, ʊ mɩsɩrbaa bam kan kɩ sɔ. ");
INSERT INTO bib_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Bala, Krista k'a a mɩm bɔ ʊ gəəno bire ʊ bɩ, a bɩ gam dɔ y, zɛ paŋŋa ba zi dɔ y. ");
INSERT INTO bib_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Krista ga gallɛm deem, an a gʊ kʊ ma kan mimbʊnyaa kɩ, dɔmɩm haay minto. Dɩɩtaa naa, a mɩsɩr, bɩ mɩsɩrbaa bɩ ba a nawʊm Woso tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Awɔɔ sɔ, k'a dɔ a ʊ, awɔɔ gɩnga, a a gʊ kʊ ma kan mimbʊnyaa kɩ, bɩ awɔɔ ɩ mɩsɩrbaa bam kɛɛrɛ Woso tɔ ma, Yeezuu Krista zɛkʊra nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","A b'a ya, a ka kʊ mimbʊnyaa n a so a mɛ k'a nɩ zɛm bɩ ga b'ʊ y, a yaa a ka awɔɔ n zu a mɛsim lɛtaamarɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","A b'a mɛ vəŋŋəro sa, a ŋ ka mimbʊnyaa ʊ, k'an ŋ sa an ŋ ba a zibəə mɔr y. Awɔɔ n'a bam bɩ, k'a mɩŋŋɔɔ sa a ka Woso ʊ, a mɩm awɔɔ bɔ ʊ gəəno bire ʊ, k'a mɛ vəŋŋəro wɔɔ sa, a ŋ ba zi mɩŋŋa barɛ mɔr. ");
INSERT INTO bib_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Mimbʊnyaa bɛɛ y'a so awɔɔ ʊ dɔ y, bala, awɔɔ ba lɛ nɔ ʊ y, Woso barka nɔ awɔɔ n ta ʊ. ");
INSERT INTO bib_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Naa jɩ m bɔ nɩ? Kʊ lɛ bɛɛ y'a so wɔɔ ʊ dɔ, bɩ Woso barka wɔɔ n'a nɔ ʊ bɩ, wɔɔ y'a nam bɩ lɛ m, k'ʊ mimbʊnyaa ba ra? Ayy…, fɩɩga! ");
INSERT INTO bib_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Awɔɔ n a dɔ a ʊ, k'awɔɔ a mɩŋŋa sa, a ka gʊaa ʊ k'a zu a hɔɔnhɔ ʊ, gʊaa k'awɔɔ nɩ zure a hɔɔnhɔ ʊ bɩ lɔnnɔ n'awɔɔ m na? A ɩ yɩrɛ ɩ ʊ, kʊ mimbʊnyaa lɔnnɔ n'awɔɔ nɩ, bɩ mimbʊnyaa a ka awɔɔ n gɩnga, gɛɛ kʊ Woso hɔɔnhɔ awɔɔ nɩ zuŋ ʊ, bɩ Woso mɩsɩrbaa k'an tɩrga ka awɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Bɩ, ʊ Woso barka da. Nyɩnta k'awɔɔ ʊ biisi mimbʊnyaa lɔnnɔ rɔ wɔɔ, awɔɔ bɩ zu hɔdɩndarɛ kʊ ŋ y'a dɩnda awɔɔ m b'ʊ kan a heer kɩ haay. ");
INSERT INTO bib_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Awɔɔ yɔ kʊ n y'a ʊ mimbʊnyaa wɔ ʊ bɩ, awɔɔ a ba tɩrgabaa lɔnnɔ. ");
INSERT INTO bib_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Makrarɔ yaargarɛrɔ mɔɔ ŋ sa meerbaa bɩ nɔ ʊ, k'awɔɔ n hɔ kʊ mɔɔ n'a hɩm bɩ jɩ ma, bala, awɔɔ bɩr a dam ma, an nɩ minno wɔɔ jɩ marɛ y. Amba awɔɔ nyɩnta biisi, a a mɩŋŋɔɔ ba dintim kan zibʊnyaa do haay kɩ zibəə lɔnnɔ, a a ba Woso bɩsɩkamazannɔ bɩ, kɛɛrɛ naa, k'a mɩŋŋɔɔ ba tɩrgabaa zibəə lɔnnɔ, k'a mɩsɩrbaa mɩŋŋa ba Woso mɩm m. ");
INSERT INTO bib_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Nyɩnta k'awɔɔ ʊ mimbʊnyaa lɔnnɔ rɔ wɔɔ, tɩrgabaa zibəə mim n nyɩnta awɔɔ ma y. ");
INSERT INTO bib_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Bɔ awɔɔ yɩ, zibəəro wɔɔ duro nɔ ʊ? Ŋ nyannɩ ta awɔɔ m her, bala, ŋ nyambʊrlɛ bɩ, zɛ m. ");
INSERT INTO bib_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Bɩ kɛɛrɛ naa, n y'awɔɔ yɔ mimbʊnyaa wɔ ʊ, a a ba Woso lɔnnɔ, hɔ k'awɔɔ n'a yɩrɛ a nɔ ʊ bɩ, mɩsɩrbaa k'a Woso nɔ yɩ m, a nyambʊrlɛ bɩ, mɩsɩrbaa k'a nyarɛ ba ʊ bɩ yɩrɛ m. ");
INSERT INTO bib_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Bala, mimbʊnyaa yawʊra bɩ, zɛ m, bɩ ganwʊrɛ kʊ Woso n'a kam nɩbɩr bɩ, mɩsɩrbaa k'a nyarɛ ba ʊ bɩ m, wɔɔ Zuuba Yeezuu Krista zɛkʊra nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","M danyɩnɔ, awɔɔ hɔ kʊ mɔɔ n n'a ŋʊam kʊ m a hɩ awɔɔ m naa dɔ mɩŋŋa, bala, awɔɔ lɛrɔ dɔ. Ba gʊaa gɔɔta an mɩsɩr bɩ lɛ tɩr a so ʊ. K'a zaa bɩ ga, lɛ n a so ʊ dɔ y. ");
INSERT INTO bib_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ʊ makra sa: lɛrɔ wɔɔ nɔ ʊ, n y'a cɩnta kʊ lʊ b'a gʊ a zim ma k'a zim bɩ bɛɛ bɩ ga y, bɩ k'a zim bɩ ga, lɛ k'a so lʊ b'ʊ k'an gɔɔta an bɩr kan a zim bɩ kɩ a mɩsɩrbaa dɔmɩm ʊ bɩ n a ya, an a so lʊ b'ʊ dɔ y. ");
INSERT INTO bib_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Bɩ, kʊ lʊ bɩ gʊaa vanta sa a zim bɩ nɩ meeyaa m, lʊ bɩ bir n nawʊm jaandər. Bɩ k'a zim bɩ bɩ ga, lɛ bɩ n a ya, an a so ʊ dɔ y, a a da ma an gʊaa vanta sa, bɩ n b'a dam ma n a hɩ ma jaandər y. ");
INSERT INTO bib_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","M danyɩnɔ, a maam sɔ, lɛrɔ wɔɔ y'a so awɔɔ ʊ biisi. Kɛɛrɛ naa, a zɛ awɔɔ ʊ kʊ ra kan Krista k'a ga wɔɔ tɔ ma bɩ kɩ, lɛ n a ya, an a so awɔɔ ʊ dɔ y, awɔɔ gɩnga sɔ. Gʊaa vanta y'a so awɔɔ ʊ kɛɛrɛ, gʊaa k'a mɩm bɔ ʊ gəəno bire ʊ bɩ m, kʊ wɔɔ n'ʊ da ma ʊ zibəəro mɩŋŋɔɔ ba Woso tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Bala, nyɩnta kʊ wɔɔ ʊ biisi, ʊ nɩ mɩsɩrbaa bam mɛsim lɛtaamarɔ nɔ ʊ bɩ, lɛrɔ wɔɔ minto bɩ, lɛtaamarɔ bʊnyaarɔ nyɩnta ŋn'ɩ wɔɔ mɛ jilli bɩ dam zi bʊnyaarɔ barɛ ʊ, ŋn'ɩ tam wɔɔ m zɛ bɩncɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Biisi bɩ, lɛrɔ wɔɔ, wɔɔ ba n y'a ʊ a lɔnnɔ, ŋn'a so wɔɔ ʊ, kɛɛrɛ naa, lɛrɔ wɔɔ bɩncɛ ʊ, gɩnga wɔɔ ʊ, Woso wɔɔ bɔ ŋ wɔ ʊ. Kɛɛrɛ naa, wɔɔ ʊ da ma, ʊ Woso zi ba zaa daa nɔ ʊ, Sɛnt-Ɛspri zaa m, lɛrɔ zaa gusire k'a nɩ Moyiisi ci ʊ bɩ bɛɛ dɔ y. ");
INSERT INTO bib_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Naa jɩ m bɔ nɩ? Mimbʊnyaa m, lɛrɔ wɔɔ m na? Ayy…, fɩɩga! Bɩ, kʊ lɛrɔ wɔɔ bɛɛ m, mɔɔ b'a dɔm kʊ bɔ m mimbʊnyaa y. Bala, mɔɔ bɩ gʊaa hɔ lɛtaamarɔ dɔrɛ, kʊ lɛrɔ wɔɔ bɛɛ y'a cɩnta, ŋ ʊ: ‹Ɩ b'a ka ɩ lɛ m bɩr gʊaa hɔ zi y.› ");
INSERT INTO bib_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","A m naa, mimbʊnyaa n a na lɛrɔ kʊ ŋ y'a cɩnta rɔ wɔɔ ma, an zaa yɩ mɔɔ gʊr zi, an mɔɔ lɛ ka gʊaa hɔ lɛtaama do haay zi. Bala, kʊ lɛrɔ wɔɔ ba ʊ, mimbʊnyaa bɩ, hɔ gər m. ");
INSERT INTO bib_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Biisi bɩ, lɛrɔ wɔɔ kʊ ŋ ba ʊ bɩ, mɔɔ mɩsɩr. Bɩ, lɛrɔ kʊ ŋ bɩ bʊr bɩ, mimbʊnyaa n a mɩm bɔ ʊ, mɔɔ m ga. ");
INSERT INTO bib_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Ncɩnaaʊ bɩ, mɔɔ mɩŋŋa mim bɩ nɔ ʊ bɩ, lɛrɔ kʊ ŋ nɩ mɩsɩrbaa ler bɔm mɔɔ m, brɔɔ a ka mɔɔ n ga. ");
INSERT INTO bib_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Bala, a na mimbʊnyaa b'ʊ lɛrɔ wɔɔ lɛ m, an bra ba mɔɔ m, an a ka, lɛrɔ wɔɔ n mɔɔ zɛ gər. ");
INSERT INTO bib_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Bɩ kʊ lɛrɔ wɔɔ a to ŋ y'a ʊ Woso zi, lɛ biyəə mɩŋŋa, a tɩrga, hɔ mɩŋŋa m. ");
INSERT INTO bib_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Bɩ, hɔ k'an mɩŋŋa bɩ y'a ka mɔɔ n ga ra? Ayy…, fɩɩga! Mimbʊnyaa ɩ mɔɔ zɛ, hɔ mɩŋŋa a a sa, an mɔɔ zɛ m gər. Yɩ a ʊ, ncɩnaaʊ, kʊ mimbʊnyaa bʊnyaabaa n a hɩnka. Lɛrɔ wɔɔ y'a ka, mimbʊnyaa bʊnyaabaa gʊtabaa n a hɩnka paan…. ");
INSERT INTO bib_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Wɔɔ dɔ, ʊ ʊ, lɛrɔ wɔɔ a to ŋ y'a ʊ Woso zi. Bɩ kʊ mɔɔ nɩ, gʊaa m mɔɔ m bala, mimbʊnyaa n mɔɔ si, an mɔɔ ba a lɔ. ");
INSERT INTO bib_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mɔɔ bɩr m zi kʊ mɔɔ n'a bam jɩ dɔrɛ y, hɔ kʊ mɔɔ lɛ n taa kʊ m a ba bɩ, mɔɔ bɩr bɩ barɛ y, hɔ kʊ mɔɔ lɛ baa kʊ m a ba bɩ, mɔɔ n'a bam. ");
INSERT INTO bib_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Bɩ, k'a nɩ yɩrɛ ɩ ʊ, hɔ kʊ mɔɔ lɛ baa bɩ, bɩ mɔɔ n'a bam bɩ, mɔɔ yɛ kɛɛrɛ m ʊ, lɛrɔ wɔɔ mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","A ɩ yɩrɛ ɩ ʊ, hɔ bʊnyaa kʊ mɔɔ n'a bam bɩ, mɔɔ bɛɛ n'a barɛ y, mimbʊnyaa k'a nɩ mɔɔ nɔ ʊ bɩ n'a bam. ");
INSERT INTO bib_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Bala, mɔɔ dɔ mɔɔ ʊ, mɔɔ gʊr zi, (b'ʊ k'a hɩ a ʊ: mɔɔ mɛsim nɔ ʊ bɩ) hɔ mɩŋŋa ba ʊ y. Mɔɔ ɩ zi mɩŋŋa barɛ lɛtaama m, bɩ mɔɔ ba a barɛ paŋŋa nɩ y. ");
INSERT INTO bib_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mɔɔ bɩr zi mɩŋŋa kʊ mɔɔ n'a ŋʊam bɩ barɛ y, zi bʊnyaa kʊ mɔɔ bɩr a ŋʊam bɩ mɔɔ n'a bam. ");
INSERT INTO bib_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Kʊ hɔ kʊ mɔɔ lɛ baa bɩ mɔɔ n'a bam bɩ, mɔɔ mɩŋŋa bɛɛ n'a barɛ y, mimbʊnyaa k'a nɩ mɔɔ ʊ bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Mɔɔ tɩr a yɩm, kʊ mɔɔ ʊ, kʊ m zu lɛrɔ wɔɔ ʊ, mɔɔ ba a paŋŋa nɩ y. Zi bʊnyaa barɛ paŋŋa mɔɔ m ta m bala. ");
INSERT INTO bib_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","A ɩ yɩrɛ ʊ, mɔɔ heer nɔ ʊ, mɔɔ Woso lɛrɔ wɔɔ ŋʊa, ");
INSERT INTO bib_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","bɩ, mɔɔ ɩ lɛ vanta yɩrɛ an nɩ zi bam mɔɔ mɩsɩrbaa nɔ ʊ, an nɩ zoo bam kan lɛrɔ niŋŋoo kʊ mɔɔ hɔɔn nɩ kan ŋ kɩ rɔ wɔɔ kɩ. Lɛ vanta bɩ do k'a nɩ mɔɔ ʊ bɩ n'a kam, mɔɔ nɩ m bam mimbʊnyaa paŋŋa k'a nɩ mɔɔ ʊ bɩ lɔ. ");
INSERT INTO bib_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Cicirzaa m mɔɔ m! Nka nɩ mɔɔ yɔm mɛ k'a nɩ tam mɔɔ m zɛ bɩncɛ ʊ bɩ wɔ ʊ? ");
INSERT INTO bib_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Woso m, Yeezuu Krista wɔɔ Zuuba bɩ tɔ ma, Woso m lɛbɔʊrɛ yɩ! Naa haay tɔ ma, a ɩ yɩrɛ ɩ ʊ, kʊ mɔɔ mɩŋŋa nɩ, mɔɔ hɔɔn mɔɔ ba Woso lɛrɔ wɔɔ lɔ, mɔɔ mɛsim n bɔkarɛ an mɔɔ ba mimbʊnyaa lɔ. ");
INSERT INTO bib_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Kɛɛrɛ naa, Woso b'a yarɛ an gʊɔɔ kʊ ŋ nɩ Krista Yeezuu nɔ ʊ rɔ wɔɔ dʊdɔ yar y. ");
INSERT INTO bib_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Bala, Yeezuu Krista nɔ ʊ, lɛ kʊ *Sɛnt-Ɛspri a sa k'a mɩsɩrbaa ka mɔɔ ʊ bɩ, a mɔɔ bʊmbɔ lɛ k'a nɩ mimbʊnyaa m k'a nyɩnta k'a mɔɔ gaa a ta mɔɔ m zɛ nɔ ʊ bɩ wɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Hɔ kʊ Moyiisi lɛrɔ wɔɔ n a da ma ŋn'a ba, gʊɔɔ kʊ ŋ n'a da ma ŋnɩ zu ʊ bɩ minto bɩ, Woso hɔ bɩ do ba. Woso k'a a Nyɩ bɩ nyɔɔ mɛsim nɔ ʊ, an bʊr mimbʊnyaabənno mɛsim m k'a bɩ ŋ yɔ mimbʊnyaa wɔ ʊ bɩ, a mimbʊnyaa dʊdɔ yar. ");
INSERT INTO bib_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Naa do ba Woso ʊ, kʊ tɩrgabaa kʊ lɛrɔ wɔɔ a cɩnta bɩ n kʊ yɩ, wɔɔ gʊr zi. Wɔɔ k'ʊ bɩr mɩsɩrbaa bam dɔ mɛsim nɔ ʊ bɩ, Sɛnt-Ɛspri paŋŋa nɔ ʊ m. ");
INSERT INTO bib_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Bala, gʊɔɔ kʊ ŋ nɩ mɛsim mɩsɩrbaa bam nɔ wɔɔ, hɔ kʊ mɩsɩrbaa bɩ do lɛ n taa ŋn'a kam ma, bɩ gʊɔɔ kʊ ŋ nɩ mɩsɩrbaa bam Sɛnt-Ɛspri paŋŋa mɩsɩrbaa nɔ ʊ rɔ wɔɔ, hɔ kʊ Sɛnt-Ɛspri lɛ n taa bɩ ŋn'a kam ma. ");
INSERT INTO bib_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Mɛsim hɔɔnhɔrɔ kama bɩ, ta a nawʊm gʊaa m zɛ bɩncɛ ʊ, bɩ, Sɛnt-Ɛspri hɔɔnhɔ kama bɩ, ta a nawʊm gʊaa m mɩsɩrbaa kan laafɩɩ kɩ bɩncɛ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Bala, Woso jɩnnɔ m mɛsim hɔɔnhɔrɔ wɔɔ m, bala, mɛsim bɩr zum Woso lɛ ʊ y, a b'a dam ma sɔ an zu ʊ y. ");
INSERT INTO bib_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Maam sɔ bɩ, gʊɔɔ kʊ ŋ nɩ yɛm mɛsim hɔɔnhɔ ma rɔ wɔɔ, b'a dam ma, ŋnɩ Woso nɔ yɩ y. ");
INSERT INTO bib_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","K'awɔɔ nɩ, mɛsim bɛɛ y'a so awɔɔ ʊ y, Sɛnt-Ɛspri y'a so awɔɔ ʊ, bala, Woso Ɛspri b'ɩ y'awɔɔ nɔ ʊ. Kʊ gʊaa ba Krista Ɛspri bɩ nɩ, Krista gʊaa bɛɛ n'a zaa nɩ y. ");
INSERT INTO bib_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Bɩ, Krista y'awɔɔ nɔ ʊ, sɩra m, awɔɔ mɛ bɩ zɛm bɩ ga mimbʊnyaa tɔ ma. Bɩ, kʊ n y'awɔɔ ba tɩrga minto bɩ, Sɛnt-Ɛspri mɩsɩrbaa y'awɔɔ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Kʊ Woso k'a Yeezuu mɩm bɔ ʊ gəəno bire ʊ bɩ Ɛspri y'awɔɔ nɔ ʊ, Woso bɩ do, k'a Yeezuu Krista mɩm bɔ ʊ gəəno bire ʊ bɩ zum kʊ ʊ kan a Ɛspri bɩ kɩ, an mɩsɩrbaa ka awɔɔ mɛ k'a nɩ zɛm bɩ ga b'ʊ. ");
INSERT INTO bib_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ncɩnaaʊ bɩ, m danyɩnɔ, pakra bɛɛ m, kʊ wɔɔ n zu mɛsim hɔɔnhɔ b'ʊ dɔ y, Sɛnt-Ɛspri n'a ŋʊam bɩ wɔɔ ʊ ga m, ʊ a ba. ");
INSERT INTO bib_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Bala, k'awɔɔ y'a mɩsɩrbaa bam a mɛsim hɔɔnhɔ nɔ ʊ, awɔɔ gɩngarɛ, bɩ k'awɔɔ a mɛsim hɔɔnhɔ zibəəro wɔɔ da jɩm ʊ Sɛnt-Ɛspri paŋŋa nɔ ʊ, awɔɔ mɩsɩrbaa bam. ");
INSERT INTO bib_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Bala, gʊɔɔ haay kʊ Woso Ɛspri n nɩ karɛ ŋ lɛɛ rɔ wɔɔ, brɔɔ m Woso nyɩnɔ. ");
INSERT INTO bib_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ɛspri kʊ Woso a ka awɔɔ ʊ bɩ bɩr awɔɔ bam lɔnnɔ, k'awɔɔ n a ya a bɩr nyibəə nɔ ʊ y, Ɛspri bɩ do, awɔɔ ba a nawʊm Woso nyɩnɔ, an n'a kam wɔɔ nɩ Woso birm, ʊ ʊ: ‹Aba›, a jɩ k'a hɩ a ʊ: ‹Baaba›. ");
INSERT INTO bib_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ɛspri bɩ do n n'a kam wɔɔ n n'a dɔrɛ ʊ heer ʊ mɩŋŋa, ʊ ʊ, Woso nyɩnɔ m wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Kʊ Woso nyɩnɔ m wɔɔ m bɩ, wɔɔ n nɩ zɛm b'ʊ so hɔnta k'a cɩnta wɔɔ m b'ʊ, wɔɔ zɛm b'ʊ so ʊ kan Krista kɩ, bala, kʊ wɔɔ fɩr yɩ kan kɩ, wɔɔ nyɩntam kan kɩ a lɛbɔʊrɛ nɔ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mɔɔ y'a gɩngam mɔɔ ʊ, fɩr k'ʊ n'a yɩm her naa b'a dam ma fɩɩgaa, an a makra ba kan lɛbɔʊrɛ kʊ Woso n nɩ zɛm b'a hɩnka wɔɔ m bɩ kɩ y. ");
INSERT INTO bib_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ncɩnaaʊ nɩ, durnya nɩ dɔm Woso nyɩnɔ hɩnkarɛ dɔmɩm ma, kan a heer kɩ haay. ");
INSERT INTO bib_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Durnya bɩ haay a ba hɔ vam, a bɛɛ y'a ŋʊa maam nɩ y, Woso k'a a da vambaa ma bɩ minto m, bɩ durnya gɔɔta an n'a gɩngam k'a bɩ bɔ vambaa bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Bala, Woso durnya bɩ yɔm vambaa lɔmbaa bɩ wɔ ʊ sɔ k'an zɛkʊra yɩ kan Woso nyɩnɔ wɔɔ soamɩŋŋaʊ kɩ, kan ŋ lɛbɔʊrɛ bɩ kɩ sɔ. ");
INSERT INTO bib_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","A n bɔkarɛ wɔɔ dɔ, ʊ ʊ, durnya bɩ jilli ɩ fɩr yɩm, an nɩ kɔrɛ nɔ ʊ dɩɩtaa, amba lʊ k'a nɩ nyoosi bam bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Durnya bɩ bɛɛ n'a deem nɩ y, wɔɔ ɩ fɩr yɩm ʊ heer ʊ, dɔ kʊ wɔɔ nawʊm dɔmɩm kʊ Woso n nɩ zɛm bɩ wɔɔ ba a nyɩnɔ paan…rɔ, an wɔɔ mɛ bʊmbɔ bɩ ma. Woso Sɛnt-Ɛspri ka wɔɔ ʊ lɛɛkarɛ ganwʊrɛ, k'ʊ bɔkarɛ ʊ bɩ ganwʊrɛrɔ kʊ ŋ gɔɔta rɔ wɔɔ yɩ. ");
INSERT INTO bib_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Bala, wɔɔ bʊmbɔrɛ yɩ, bɩ gɩnga nɔ ʊ m. Kʊ gʊaa ɩ hɔ k'a n'a gɩngam k'a b'a yɩ bɩ yɩrɛ a mɩm m, gɩnga bɛɛ m bɩ dɔ y, nka n'a yarɛ an hɔ k'a n'a yɩrɛ a mɩm m gɩnga? ");
INSERT INTO bib_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Bɩ, kʊ wɔɔ ɩ hɔ kʊ wɔɔ bɩr a yɩrɛ ʊ mɩm m bɩ gɩngarɛ, dɔ wɔɔ nawʊm ma kan bʊraama kɩ. ");
INSERT INTO bib_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Maam sɔ bɩ, Sɛnt-Ɛspri ɩ zɛm sɔ, an n'a dam wɔɔ han, ʊ paŋŋawar nɔ ʊ. Bala, kʊ wɔɔ n yaadarɛ dɔ an a ga kʊ ʊ ba bɩ, Sɛnt-Ɛspri mɩŋŋa ɩ yaa dam wɔɔ tɔ ma, hoonsibɔɔrɛ kʊ gʊaa b'a dam ma an a jɩ hɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Bɩ, Woso k'a hɔ k'a nɩ gʊaa heer ʊ dɔ bɩ, a hɔ kʊ Sɛnt-Ɛspri lɛ n taa bɩ dɔ. Bala, yaa kʊ Sɛnt-Ɛspri n'a dam wosogʊɔɔ wɔɔ tɔ ma bɩ, a da a nawʊm amba Woso n lɛ n taa bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Wɔɔ dɔ sɔ, ʊ ʊ, Woso n n'a kam mim haay woo… nɩ kʊ zɛŋ ʊ, ŋn'ɩ yɩm mɩŋŋa gʊɔɔ haay kʊ ŋ nɩ Woso ŋʊam nɔ wɔɔ ma, gʊɔɔ k'a ŋ bir amba a a cɩnta bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Bala, gʊɔɔ kʊ Woso lɛɛ ka, an ŋ bɔ ʊ rɔ wɔɔ, a a cɩnta sɔ kʊ ŋ nɩ bɩ bɔ kʊ ʊ kan a Nyɩ bɩ kɩ, k'a Nyɩ bɩ m yɩ Nyɩ jɩtaarɛ danyɩnɔ cir bireyaa ʊ. ");
INSERT INTO bib_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Gʊɔɔ kʊ Woso lɛɛ ka an ŋ bɔ ʊ rɔ wɔɔ, a ŋ bir sɔ, ŋ bir k'a ʊ bɩ, a ŋ ba tɩrga, k'a ŋ ba tɩrga bɩ, a ŋ tɔ busu a lɛbɔʊrɛ nɔ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Bɔ wɔɔ n'ʊ yarɛ ʊ a hɩ? Kʊ Woso ɩ kan wɔɔ kɩ, nka m nɩ bʊrm wɔɔ ra? ");
INSERT INTO bib_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Woso n a mɩŋŋa Nyɩnnɩ bɩ bɔ lɛ m y, a a ka ŋn'a zɛ wɔɔ haay tɔ ma. K'a a yo an yɛ naa do ma bɩ, a hɔ haay kam wɔɔ ʊ kan a Nyɩ bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Nka m nɩ mim kam gʊɔɔ kʊ Woso ŋ bɔ ʊ rɔ wɔɔ ra? Gɔsɩ, bala, Woso nɩ ŋ bam tɩrga. ");
INSERT INTO bib_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Nka m nɩ ŋ dʊdɔ yarlɛ? Gɔsɩ, bala, Yeezuu Krista ɩ ga, an lɛ da bɩ, a a mɩm bɔ ʊ, an nɩ nyɩntam Woso bɩsɩ ʊ, an nɩ yaa dam wɔɔ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Nka m nɩ wɔɔ gʊm ŋʊarɛ kʊ Krista n ta m wɔɔ minto bɩ ma? Fɩryɩrɛ m gɛɛ heerzɛkʊma nɩ, gʊɔɔ kʊ ŋ nɩ cicir kam wɔɔ ma rɔ m gɛɛ nɔ nɩ, ta dɩgɩbaa m gɛɛ mim kʊsɩ nɩ, gɛɛ zɛ nɩ? ");
INSERT INTO bib_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Amba n y'a gʊrsɩra ba Wosoci ʊ bɩ m, n ʊ: Ɩbɩɩ tɔ ma m, n nɩ wɔɔ zɩnzɛm wakatɩ haay nɔ ʊ, n yɩ dɩgam wɔɔ ma, am seero kʊ ŋ nɩ tam k'a yaa n ŋ zɩnzɛ rɔ wɔɔ hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Bɩ, naa haay nɔ ʊ, damazannɔ paan…rɔ m wɔɔ m, a zaa k'a wɔɔ ŋʊa bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Bala, mɔɔ dɔ kan heerkoodəbaa kɩ, m ʊ: zɛ, gɛɛ mɩsɩrbaa, malɛɛkarɔ gɛɛ paŋŋasoʊrezannɔ kʊ ŋ nɩ ta ʊ, hɔ k'an ta ʊ her, gɛɛ an nɩ zɛm booti m, paŋŋazannɔ haay, ");
INSERT INTO bib_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","mim ʊ paŋŋazannɔ, gɛɛ paŋŋazannɔ kʊ ŋ nɩ tara ʊ, gɛɛ hɔ kʊ Woso a da haay, sɩ b'a dam ma an wɔɔ gʊ ŋʊarɛ kʊ Woso n ta m, wɔɔ tɔ ma, wɔɔ Zuuba Yeezuu Krista zɛkʊra bɩ nɔ ʊ bɩ ma y. ");
INSERT INTO bib_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Sɩra mɔɔ n'a hɩm, Krista zɛkʊra nɔ ʊ, mɔɔ bɩr ŋʊaar barɛ y, Sɛnt-Ɛspri a zɛ kʊ ra kan mɔɔ heer kɩ, ŋnɩ mɔɔ sɩra bɩ hɩrɛ kasɛtɩ karɛ. ");
INSERT INTO bib_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Mɔɔ ɩ heerzaarbarɛ gʊta m, m heer nɩ busum dɔmɩm haay. ");
INSERT INTO bib_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Mɔɔ y'a ŋʊam k'an bɩr yɩrɛ ɩ ʊ, Woso kaanm mɔɔ m, m bɩr laatʊ Krista ma, m danyɩnɔ, m zɩrɔ wɔɔ, mɔɔ do gʊɔɔ wɔɔ tɔ ma, k'a ɩ yɩrɛ, ɩ ʊ, naa yɩm ŋ bʊmbɔrɛ. ");
INSERT INTO bib_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Ŋ mɩŋŋɔɔ m Israyɛl zannɔ, Woso n ŋ bɔ ʊ k'a ŋ ba a nyɩnɔ, an a lɛbɔʊrɛ ka ŋ ʊ kan a gʊaasɩbabaa zaarɔ kɩ, a lɛrɔ kɩ, a Woso daʊrɛ zaa kɩ, lerbɔrɛrɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Ŋ yaabɔɔ m Abraham m, Izakkɩ kan Zakɔɔb kɩ m. Kʊ yɩrɛ nɔ ʊ nɩ, Krista bɩ, ŋ do gʊaa m. Krista mɩŋŋa nɩ hɔ haay burə ʊ. A m Woso, a tɔ m lɛbɔʊrɛ yɩ dɔmɩm haay nɔ ʊ. Amina! ");
INSERT INTO bib_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","A bɩr yɩrɛ ɩ ʊ, jɩra Woso ʊ ler k'a bɔ bɩ ra wa, bɩ, Israyɛl yaŋŋɔɔ wɔɔ haay bɛɛ m Israyɛl do gʊɔɔ paan…rɔ y, ");
INSERT INTO bib_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Abraham yaŋŋɔɔ haay bɛɛ n a nyɩnɔ paan…rɔ y, bala, Woso a hɩ Abraham m, a ʊ: ‹Izakkɩ n n'ɩ nyɩnɔ kʊ mɔɔ ŋ ler bɔ ɩbɩɩ m nɔ wɔɔ yɩrɛ.› ");
INSERT INTO bib_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Naa k'a hɩ, a ʊ: nyɩnɔ kʊ gʊaa nɩ ŋ yɩrɛ, am gʊaa haay hɔ bɩ m bɩ, brɔɔ bɛɛ m Woso nyɩnɔ y, bɩ nyɩnɔ kʊ n yɩ ŋ ler bɔ rɔ wɔɔ, brɔɔ n nɩ dɩgarɛ ŋ ma yaŋŋɔɔ paan…rɔ. ");
INSERT INTO bib_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Ler kʊ Woso a bɔ bɩ ba n nɩ: ‹Kʊ dɔmɩm kʊ mɔɔ cɩnta b'a ku, mɔɔ yɩ m yarɛ m bʊr, Saara m nyɩyar yɩ.› ");
INSERT INTO bib_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Naa bɛɛ n a deem nɩ y, cirgərenyɩnɔ kʊ Rebeka ŋ yɩ rɔ wɔɔ zɩ deem, wɔɔ yaaba Izakkɩ m. ");
INSERT INTO bib_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","A n bɔkarɛ, Woso y'a mɩŋŋa zaa m, an n'a gʊaa bɔŋ ʊ a hɔɔnhɔ ma, a bɩr dɩgam zi kʊ gʊɔɔ a ba bɩ ma y, dɩga a nawʊm a mɩŋŋa lɛtaama ma, an nɩ gʊɔɔ birm. Woso k'a lɛ n taa kʊ zaa naa do n gɔɔta an bɩr ta ʊ bɩ, an a to nyɩnɔ wɔɔ m yɩ y. Maam bɩ, ŋ n a da ma ŋnɩ hɔ mɩŋŋa, gɛɛ hɔ bʊnyaa ba y. ");
INSERT INTO bib_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","A n lɛɛ ka nyɩnɔ wɔɔ yɩrɛ ma bɩ, a a hɩ Rebeka m, a ʊ: ‹Nyɩnɔ wɔɔ poore bɩ n n'a som jɩtaarɛ b'ʊ.› ");
INSERT INTO bib_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Amba n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: ‹Mɔɔ Zakɔɔb ŋʊa, m Eso bɔ m jɛ m› bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Bɔ wɔɔ kʊ a hɩ? Kʊ a hɩ, ʊ ʊ, Woso bɩr a zi bam tɩrga ra? Ayy…, fɩɩga! ");
INSERT INTO bib_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Bala, Woso a hɩ Moyiisi m, a ʊ: ‹Gʊaa kʊ mɔɔ lɛ n taa bɩ, mɔɔ nɩ m ŋʊarɛ zi bam kan kɩ, gʊaa kʊ mɔɔ lɛ n taa bɩ, mɔɔ n'a cicir zɛ m.› ");
INSERT INTO bib_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Woso mɩŋŋabaa bɩ bɩr zum kʊ ʊ kan gʊaa hɔɔnhɔ kɩ y, b'a ba a zibəə ma sɔ y. Woso deem an ta ma, kʊ nka a lɛ n taa b'a bɩ zaa cicir zɛ. ");
INSERT INTO bib_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Naa minto m Wosoci bɩ n'a hɩ Eziptɩ cir m, a ʊ: ‹Mɔɔ y'ɩbɩɩ cɩnta cir kʊ m m paŋŋa bɩ hɩnka, bɩsɩ k'ɩ n'a kam mɔɔ ma bɩ nɔ ʊ, kʊ mɔɔ tɔ m bɔ durnya lɛɛ haay ʊ.› ");
INSERT INTO bib_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ncɩnaaʊ bɩ, kʊ nka Woso lɛ n taa, b'a cicir zɛ, kʊ nka a lɛ n taa sɔ, b'a ka sɔ a zaa n a ba bɩsɩkər heerkarɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Gʊaa a da ma an a hɩ, a ʊ: «K'a ɩ yɩrɛ ncɩnaaʊ, bɔ m Woso n a ya, an nɩ həən sim gʊɔɔ ma? Bala, nka n'a dam ma an bɩsɩ ka a hɔɔnhɔ ma?» ");
INSERT INTO bib_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Bɩ, ɩbɩɩ k'ɩ m gʊaa, bɔ zaa n'ɩbɩɩ m k'ɩ bɩsɩ ka kan Woso kɩ? Taanm y'a hɩm a dɔrɛ zaa bɩ m, a ʊ: «Bɔ m, ɩbɩɩ m mɔɔ dɔ ncɩnaaʊ gɛ?» ");
INSERT INTO bib_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mɔrdor y'a so ji k'a nɩ zi bam nɩ b'ʊ, a a da ma, an ji deem-deem bɩ yɔɔ an mɔr dɔ m cibsa tɔ ma, an mɔr dɔ m sɔ, dɔmɩm haay zibəə tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Woso a ŋʊa k'a a nɔmaa hɩnka, a a ŋʊa sɔ kʊ n n'a paŋŋa dɔ, an bɔkarɛ, gʊɔɔ kʊ ŋ y'a ga dʊdɔyarlɛ m Woso nɔ k'a ma ʊ kan ŋ kɩ bɩ minto rɔ wɔɔ, Woso a gu an bʊr a mɩŋŋa ma, an ŋ dʊdɔ yar y. ");
INSERT INTO bib_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","K'a lɛbɔʊrɛ gʊtabaa hɩnka gʊɔɔ k'a nɩ ŋ cicir zɛm nɔ wɔɔ m. Lɛɛ a ka an brɔɔ banka k'a lɛbɔʊrɛ ka ŋ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Bɩ, gʊɔɔ wɔɔ duro m wɔɔ m, a n wɔɔ bir zɩɩfʊrɔ barla bala y, wɔɔ bir a ʊ sɔ doro vantɔɔ gʊɔɔ barla. ");
INSERT INTO bib_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Naa Woso a hɩ wosolɛsinnɩsorazaa Ozee ci ʊ bɩ, a a hɩ, a ʊ: Do kʊ mɔɔ do bɛɛ m bɩ, mɔɔ y'a hɩm ma, m do, do kʊ mɔɔ bɩr a ŋʊam biisi bɩ, mɔɔ y'a hɩm ma, m ŋʊarɛ do. ");
INSERT INTO bib_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Lɛɛ kʊ n y'a hɩm nɩ hɔɔ, n ʊ: ‹Mɔɔ do bɛɛ n'awɔɔ m bɩ,› lɛɛ bɩ do n ŋ birŋ ʊ, n ʊ: ‹Woso k'an mɩsɩr bɩ nyɩnɔ.› ");
INSERT INTO bib_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ezayii Israyɛl do bɩ mim hɩ sɔ, a ʊ: ‹Baa kʊ Israyɛl gʊɔɔ wɔɔ pasɩ, an higʊta lɛ ra nyɩntaayaa m bɩ, gʊɔɔ kʊ ŋ nɩ bʊmbɔrɛ yɩrɛ ŋ barla rɔ wɔɔ, bɩ yɩm gʊta y. ");
INSERT INTO bib_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Bala, Zuuba hɔ k'a nyɩnta an a hɩ haay bɩ bam tara burə ʊ zɔɔ-zɔɔ.› ");
INSERT INTO bib_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Amba Ezayii a ya, an a hɩ, a ʊ: Kʊ hɔ haay Zuuba bɩ bɛɛ yaŋŋɔɔ to wɔɔ m poore y, bɔ wɔɔ nawʊm kʊ ʊ kan Sodɔm kʊ kɩ, ʊ ʊ ba am Gomɔɔr kʊ hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Naa jɩ m bɔ nɩ? Do vantɔɔ gʊɔɔ wɔɔ kʊ ŋ n nyɩnta ŋ n'a ka tɩrgabaa ma rɔ wɔɔ, ŋ tɩrgabaa yɩ, tɩrgabaa k'a a to sɩrakarɛ nɔ ʊ m. ");
INSERT INTO bib_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","A n bɔkarɛ, Israyɛl gʊɔɔ kʊ ŋ n'a kam lɛro kʊ ŋ nɩ tɩrgabaa karɛ ŋ ʊ rɔ wɔɔ ma bɩ, ŋ n a da ma, ŋ n zu lɛrɔ wɔɔ duro ʊ y. ");
INSERT INTO bib_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Bɔ minto nɩ? A ɩ yɩrɛ ɩ ʊ, Israyɛl n a ka ma k'a yɩ mɩŋŋa Woso mɩm ʊ sɩrakarɛ nɔ ʊ y, a ka a ʊ ma, k'a yɩ mɩŋŋa zibəəro mɩŋŋɔɔ barɛ nɔ ʊ. Ncɩnaaʊ nɩ, ŋn'a gəm zɛ, gənzɛrɛ jaa bɩ ma, ");
INSERT INTO bib_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","amba n y'a gʊrsɩra ba Wosoci ʊ bɩ m, n ʊ: K'a dɩga a, mɔɔ ɩ gənzɛrɛ jaa cɩntam *Siyɔn ʊ, jaa m, an nɩ gʊaa dom. Bɩ kʊ gʊaa sɩra ka ʊ, a bɩ nyannɩ bɩrɛ y. ");
INSERT INTO bib_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","M danyɩnɔ, hɔ kʊ mɔɔ lɛ n taa, m n'a yɛm Woso han bɩ, a yɛ mɔɔ nawʊm kʊ zɩɩfʊrɔ wɔɔ n bʊmbɔrɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Bala, mɔɔ m da ma, m a hɩ, m ʊ, ŋ y'a tʊntɔŋ ʊ Woso kama nɔ ʊ, bɩ hɔdɔrɛ ɩ jɩra tʊntɔʊrɛ bɩ do nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Kʊ ŋ n Woso k'a nɩ gʊaa bam tɩrga bɩ zaa jɩ dɔ bɩ, a mɩŋŋɔɔ m tɩrgabaa zaa ŋ y'a cɩnta, naa do a ka ŋ n zu zaa kʊ Woso nɩ gʊaa bam tɩrga b'ʊ y. ");
INSERT INTO bib_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Bala, Krista hɔ kʊ Moyiisi lɛrɔ wɔɔ a cɩnta bɩ ba haay an a nya, kɛɛrɛ naa, gʊaa haay k'a sɩra ka Yeezuu Krista ʊ bɩ, Woso ɩ bɩ zaa bam tɩrga. ");
INSERT INTO bib_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Moyiisi tɩrgabaa k'a n'a tom lɛrɔ nɔ ʊ bɩ mim hɩ, a ʊ: ‹Gʊaa k'a nɩ zum lɛrɔ wɔɔ haay ʊ bɩ mɩsɩrbaa bam lɛrɔ wɔɔ tɔ ma.› ");
INSERT INTO bib_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Tɩrgabaa kʊ sɩrakarɛ n'a kam bɩ mim ba n nɩ: ‹Ɩ b'a hɩ ɩ heer ʊ, ɩ ʊ, nka n nɩ tam brama?› Naa do naa, a hɩ ɩbɩɩ ʊ, k'ɩ ʊ, nka n nɩ tam brama an a ka Krista m zer? ");
INSERT INTO bib_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Ɩ b'a hɩ sɔ, ɩ ʊ, ‹nka n nɩ zerm tara noom ʊ?› Ncɩnaaʊ naa, a hɩ ɩbɩɩ ʊ, k'ɩ ʊ, nka n nɩ zerm an a ka Krista m bɔ gəəno bire ʊ? ");
INSERT INTO bib_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Lemim nyɩnta bɩ y'a hɩrɛ a ʊ lɔ kɛɛrɛ? A y'a hɩrɛ, a ʊ: ‹Lemim bɩ y'ɩ jɩr ʊ, ɩbɩɩ lɛ kan ɩ heer kɩ an ta ʊ.› A n bɔkarɛ, sɩrakarɛ lemim bɩ do wɔɔ n n'a pa dam naa. ");
INSERT INTO bib_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","K'ɩbɩɩ bɔ ɩ lɛ ma gʊaa haay lɛɛ, ɩ ʊ, Yeezuu Krista m Zuuba, k'ɩbɩɩ sɩra ka ɩ heer ʊ, ɩ ʊ, Woso a mɩm bɔ ʊ gəəno bire ʊ, ɩbɩɩ bʊmbɔrɛ yɩrɛ. ");
INSERT INTO bib_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Bala, kʊ gʊaa sɩra ka a heer ʊ, bɩ Woso a ba tɩrga. Kʊ gʊaa a sɩrakarɛ bɔ a lɛ ma gʊaa haay lɛɛ, bɩ Woso a zaa bʊmbɔ. ");
INSERT INTO bib_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Bala, Wosoci a hɩ, a ʊ: ‹Kʊ gʊaa sɩra ka ʊ, a bɩ nyannɩ bɩrɛ y.› ");
INSERT INTO bib_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Naa minto bɩ, zɩɩfʊ kan do vanta gʊaa kɩ b'a hʊnhɔ y, ŋ haay Zuuba deem, an nɩ hɔ mɩŋŋa bam gʊɔɔ haay kʊ ŋ nɩ yaa dam nɩ rɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Bala, gʊaa biyəə k'a nɩ Zuuba tɔ birm bɩ, a bʊmbɔrɛ yɩm. ");
INSERT INTO bib_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Bɩ, ŋ y'a bam lɔ ŋn'a bir, kʊ ŋ n sɩra ka ʊ? Ŋ y'a bam lɔ ŋnɩ sɩra ka ʊ, kʊ ŋ n a mim ma? Ŋ y'a bam lɔ ŋn'a mim ma, kʊ gʊaa n a pa da ŋ nɩ? ");
INSERT INTO bib_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Bɩ, gʊaa y'a bam lɔ k'a mim pa da, kʊ n n'a nyɔɔ? Amba n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: ‹Gʊɔɔ kʊ ŋ nɩ zɛm k'a bɩ lemim nyɩnta bɩ pa da rɔ wɔɔ leekure ɩ heernyɩnta kam.› ");
INSERT INTO bib_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Bɩ, gʊɔɔ wɔɔ haay bɛɛ lemim nyɩnta bɩ si y. Amba wosolɛsinnɩsorazaa Ezayii a hɩ, a ʊ: ‹Zuuba, nka ɩ sɩra ka lemim kʊ wɔɔ pa da b'ʊ?› ");
INSERT INTO bib_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Naa minto bɩ, bɔ sɩrakarɛ n nawʊm lemim kʊ gʊaa n'a tʊr kam ma bɩ nɔ ʊ, bɩ lemim bɩ do k'a n'a mam bɩ, Krista lemim m. ");
INSERT INTO bib_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Bɩ, mɔɔ laaka dam kɛɛrɛ wa, Israyɛl do bɩ n lemim bɩ ma ra? Ŋ y'a ma sɩɩn! Bala, n y'a da Wosoci ʊ, n ʊ: ‹Ŋ leer lee ku tara burə haay ra, ŋ meerbaarɔ m ta durnya lɛzojɩ ʊ.› ");
INSERT INTO bib_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Mɔɔ yɩ m yarɛ m laaka da sɔ, Israyɛl do bɩ, an lemim bɩ jɩ ma ra? A lɛɛkarɛ hɔ, Moyiisi a hɩ, a ʊ: ‹Mɔɔ y'a karɛ awɔɔ m jɩm ba do kʊ mɔɔ do paan… bɛɛ m bɩ minto, mɔɔ y'a karɛ awɔɔ nɔ n ma ʊ, do k'a hɔɔn ba ʊ tɔ ma.› ");
INSERT INTO bib_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ezayii n a ya, an a hɩ, a ʊ: ‹Gʊɔɔ kʊ ŋ bɩr a kam mɔɔ ma rɔ wɔɔ ɩ mɔɔ yɩ, mɔɔ m hɩnka gʊɔɔ kʊ ŋ n hɔsɩ yɛ mɔɔ han rɔ wɔɔ m.› ");
INSERT INTO bib_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Kʊ Israyɛl mim nɩ, Woso a hɩ, a ʊ: ‹Dɔmɩm haay, mɔɔ m wɔ nyɔɔ do k'a bɩr yɛrɛ y, an nɩ bɩsɩ kam bɩ zi.› ");
INSERT INTO bib_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Kʊ m m ya, m laaka da wa, Woso bɩ a bɔ a ʊ, a do b'ʊ ra? Ayy…, fɩɩga, mɔɔ n a gɩnga y! Bala, Israyɛl gʊaa m mɔɔ mɩŋŋa m, Abraham yaŋŋa m mɔɔ m, m to mɔɔ ʊ Bɛnzamɛn do bɩ barla. ");
INSERT INTO bib_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","‹Woso n a bɔ a do k'a lɛɛ ka an a bɔ ʊ b'ʊ y.› Awɔɔ hɔ kʊ Wosoci bɩ n'a hɩm *Elii k'a bʊr an bɩ Israyɛl mimbʊnyaarɔ k'a ŋ ba rɔ wɔɔ dɩnda Woso m bɩ dɔ. ");
INSERT INTO bib_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","A a hɩ, a ʊ: ‹Zuuba, ŋ y'ɩbɩɩ lɛsinnɩsorazannɔ wɔɔ zɩnzɛ, ŋn'ɩbɩɩ mannɩjaarɔ wɔɔ wurgə, mɔɔ ɩ gɔɔta m deem, ŋn'a kam ma k'a mɔɔ mee bɔ ʊ.› ");
INSERT INTO bib_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Bɩ, bɔ Woso a hɩ nɩ? A a hɩ, a ʊ: ‹Mɔɔ m gʊɔɔ bɔ ʊ tisi saanhɩna, m hɔ, ŋ n kukurə zɛ, ŋ n yaa da *wosobaawɔm Baal nɩ y.› ");
INSERT INTO bib_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Ncɩnaaʊ bɩ, her dɔmɩm naa nɔ ʊ sɔ naa, gʊɔɔ ta ʊ poore, Woso n ŋ bɔ ʊ a hɔɔn n'a ŋʊa tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Ŋ bɔ a ʊ, a hɔɔn n'a ŋʊa tɔ ma, ŋ zibəəro tɔ ma bɛɛ y, kʊ m bɛɛ m, Woso hɔɔn bɔʊrɛ bɩ bɩ yɩm hɔɔn bɔʊrɛ paan… y. ");
INSERT INTO bib_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Kʊ a hɩ, ʊ ʊ lɔ? Hɔ kʊ Israyɛl n'a kam ma bɩ, an a yɩ y, bɩ gʊɔɔ kʊ Woso ŋ bɔ ʊ rɔ wɔɔ a yɩ. Gʊɔɔ kʊ ŋ gɔɔta rɔ wɔɔ heer karɛ ba, k'a bɩ hɔsɩ jɩ ma y. ");
INSERT INTO bib_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Amba n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: ‹Woso a ka ŋ hɔɔn n a ta, ŋ mɩm n ta ʊ, bɩ ŋ bɩr lɛɛ yɩrɛ y, ŋ tʊr n ta ʊ, bɩ ŋ bɩr mim marɛ y, an ta an her dɔmɩm ku.› ");
INSERT INTO bib_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Davɩd a hɩ sɔ, a ʊ: ‹Kʊ ŋ hɔbɩrɛ n nyɩnta ŋ ma am baŋŋa k'a nɩ hɔ sam bɩ m, am zaŋŋa hɔ bɩ m, kʊ ŋ n'a dundo, ŋnɩ hʊnhʊrlɛ yɩ a n'a gakʊ ʊ kan ŋ zibəəro kɩ. ");
INSERT INTO bib_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Kʊ monsigə n ka ŋ mɩm la, kʊ ŋ bɩ lɛɛ yɩ dɔ y, kʊ ŋ nɩ bɩr kuntəm tee….› ");
INSERT INTO bib_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Mɔɔ m ya, m nɩ laaka dam, zɩɩfʊrɔ wɔɔ kʊ ŋ y'a gəm zɛ naa, a do ŋ y'a ʊ fɩɩga ra? Ayy…, fɩɩga, mɔɔ n a gɩnga y! Bɩ, ŋ kʊrɔma bɩ minto bɩ, do vantɔɔ gʊɔɔ bʊmbɔrɛ yɩ, kʊ bɩ n a ka kʊ zɩɩfʊrɔ wɔɔ m jɩm ba ŋ ma. ");
INSERT INTO bib_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","A n bɔkarɛ, k'a ɩ yɩrɛ ɩ ʊ, ŋ kʊrɔma a ka durnya m hɔnta yɩ, kʊ ŋ terma b'a ka do vantɔɔ gʊɔɔ wɔɔ m hɔnta yɩ, kʊ ŋ bɩ bʊmbɔrɛ yɩ, bɩ bɛɛ nɩ zɛm hɔ m an lɛ da ra? ");
INSERT INTO bib_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Kɛɛrɛ bɩ, do vantɔɔ gʊɔɔ, mɔɔ y'a hɩrɛ awɔɔ m, m ʊ: kristazibəəzaa m mɔɔ m, an mɔɔ nyɔɔ do vantɔɔ wɔɔ tɔ ma. Maam bɩ, mɔɔ yɩ m zibəə bɩ tɔ busure. ");
INSERT INTO bib_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","A gɩnga mɔɔ nawʊm maam, kʊ m do gʊɔɔ wɔɔ m jɩm ba, k'an bɩr yɩrɛ ɩ ʊ, gɔsɩnnɔ bʊmbɔrɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ŋ bɔ kʊ Woso ʊ a rɛ b'a ka durnya n a zɛ kʊ ra kan Woso kɩ, k'a a ya, an ŋ gaa, bɔ n nɩ nyɩntaŋ ʊ? Nyɩnta a nawʊm mɩsɩrbaa, gʊɔɔ kʊ ŋ gɩnga rɔ wɔɔ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","K'a ɩ yɩrɛ ɩ ʊ, Woso hɔ m lɛbiisi bur bɩ nɩ, bur bɩ haay Woso hɔ m sɔ. Kʊ Woso hɔ m gɔ bɩ nyim nɩ, Woso y'a so gɔ bɩ vəŋŋəro haay ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Israyɛl gʊɔɔ wɔɔ bɔ kʊ ʊ kan gɔ kʊ n n'a bankam mɩŋŋa kɩ, n n'a vəŋŋəro gɔsɩnnɔ zɩnzɛ ra. Kʊ zɩɩfʊ bɛɛ n'ɩbɩɩ m bɩ, bɔ ɩbɩɩ ʊ kʊ rɛ kan pooyaa gɔ vəŋŋə kʊ n y'a sa, n n'a naasʊ gɔ mɩŋŋa bɩ vəŋŋəro wɔɔ bɩncɛ ma kɩ. Maam bɩ, gɔ kʊ n y'a banka bɩ nyinno wɔɔ y'ɩbɩɩ tʊrm sɔ. ");
INSERT INTO bib_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Naa minto bɩ, ɩbɩɩ n'ɩ ga m, ɩ gɔ bɩ vəŋŋəro gɔsɩnnɔ kʊ n yɩ ŋ zɩnzɛ ra rɔ wɔɔ gore bɔ ʊ y. Ɩbɩɩ y'a bam lɔ k'ɩ lɛ bɔ ɩ mɩŋŋa ʊ? Ɩbɩɩ bɛɛ m ta gɔ bɩ nyinno wɔɔ nɩ y, gɔ bɩ nyinno wɔɔ m ta ɩbɩɩ m. ");
INSERT INTO bib_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","A a da ma, ɩbɩɩ n a hɩ mɔɔ m, ɩ ʊ: «Bɩ, gɔ bɩ vəŋŋəro zɩnzɛ n y'a ʊ ra, kʊ mɔɔ n ŋ bɩncɛ sa wa.» ");
INSERT INTO bib_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Sɩra m, n zɩnzɛ n y'a ʊ ra kʊ n y'a do sɩrakarɛ ma bɩ tɔ ma, ɩbɩɩ n ŋ bɩncɛ sa, ɩ sɩrakarɛ minto. Bɩ, dundo ɩ zi, ɩ bɩ ɩ mɩŋŋa busu y, nyi ba. ");
INSERT INTO bib_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Bala, zɩɩfʊrɔ wɔɔ m gɔ bɩ vəŋŋəro paan…rɔ, bɩ Woso n ŋ to gɔ bɩ ma y, a a da ma an a ba ɩbɩɩ m maam sɔ, a b'ɩbɩɩ tore y. ");
INSERT INTO bib_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Dɩga Woso ŋʊarɛ kan a nyaa kɩ zaa ma. A nyaa ta ʊ kan gʊɔɔ kʊ ŋ sɩrakarɛ to rɔ wɔɔ kɩ, an bɔkarɛ an mɩŋŋa kan ɩbɩɩ kɩ. Bɩ, pakra m k'ɩbɩɩ m gɔɔta a ŋʊarɛ bɩ nɔ ʊ, kʊ m bɛɛ m, n y'ɩbɩɩ zɛm la, am vəŋŋəro wɔɔ hɔ bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Kʊ zɩɩfʊrɔ wɔɔ a bɩsɩkarɛ bɩ to, n y'a yarɛ, n nɩ ŋ cɩnta a bɩncɛ gusire b'ʊ. Bala, Woso a da ma, an a ya an ŋ cɩnta lɛɛ kʊ ŋ nyɩnta ʊ hɔɔ b'ʊ. ");
INSERT INTO bib_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Ɩbɩɩ kʊ zɩɩfʊ bɛɛ n'ɩbɩɩ m bɩ, bɔ ɩbɩɩ ʊ kʊ ʊ kan pooyaa gɔ vəŋŋə kʊ n y'a zɛ ra n n'a naasʊ har gɔ kʊ n n'a bankam bɩ kɩ ma, an bɔkarɛ a n a ga m y. Zɩɩfʊrɔ wɔɔ, har gɔ bɩ vəŋŋəro m, a naanaa an cem kʊ n n'a ya, n nɩ ŋ naasʊ gɔ kʊ ŋ nɩ kan kɩ hɔɔ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","M danyɩnɔ, mɔɔ lɛ baa kʊ mim k'a nyaakʊm da naa n nyɩnta awɔɔ ma yirgu y, k'awɔɔ bɩ dɩga a mɩŋŋɔɔ ma mindɔrɛzannɔ y. A ɩ yɩrɛ ɩ ʊ, Israyɛl gʊɔɔ gɔsɩnnɔ y'a ba heerkarɛzannɔ, bɩ nyɩnta a nawʊrɛ ncɩnaaʊ, kʊ do vantɔɔ gʊɔɔ wɔɔ haay kʊ ŋ nɩ bʊmbɔrɛ yɩm nɔ wɔɔ m tolle ba ŋnɩ bʊmbɔrɛ yɩ. ");
INSERT INTO bib_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ncɩnaaʊ bɩ, Israyɛl gʊɔɔ wɔɔ haay ŋ zɛm bɩ bʊmbɔrɛ yɩ, amba n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: Bʊmbɔrɛzaa bɩ y'a tom Siyɔn ʊ, a Zakɔɔb yaŋŋɔɔ wɔɔ mimbʊnyaarɔ gʊngʊrɛ ŋ ma, ");
INSERT INTO bib_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","gʊaasɩbabaa kʊ mɔɔ n'a darɛ ŋ ma bɩ n naa. Dɔmɩm kʊ mɔɔ nɩ zɛm bɩ ŋ mimbʊnyaarɔ gʊngʊ ŋ ma bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kʊ gʊaa k'a dɩga Israyɛl gʊɔɔ wɔɔ kʊ ŋ y'a gu lemim nyɩnta bɩ ma bɩ ma, a a da ma an a hɩ a ʊ, Woso jɩnnɔ nɩ ŋ mɩ, bɩ, awɔɔ daahan m bɩ, bɩ kʊ Woso gʊaa bɔʊrɛ bɩ nɔ nɩ, Woso ŋ ŋʊa ŋ yaabɔɔ wɔɔ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Bala, Woso bɩr hɔ k'a a ka bɩ sire y, a bɩr a hɔɔn lʊrm sɔ gʊɔɔ k'a ŋ bir lɔ wɔɔ mim bɩncɛ ʊ y. ");
INSERT INTO bib_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Biisi bɩ, awɔɔ nyɩnta bɩsɩ ka Woso ma zannɔ, bɩ her naa, Woso awɔɔ cicir zɛ, kʊ zɩɩfʊrɔ bɩsɩ ka ma bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Her sɔ naa, brɔɔ bɩsɩ ka Woso ma, k'an bɩr yɩrɛ ɩ ʊ, awɔɔ cicir kʊ n y'a zɛ bɩ jɛ ʊ, kʊ n nɩ ŋ cicir zɛ sɔ. ");
INSERT INTO bib_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Bala, Woso a ka gʊɔɔ haay nɩ bɩsɩkarɛ nɔ ʊ, k'a ŋ haay cicir zɛ. ");
INSERT INTO bib_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Woso hɔnta, a mindɔrɛ kan a hɔdɔrɛ kɩ nɔyaa ta ʊ gʊta maam-maam! Gɔsɩ b'a dam ma, an hɔ k'a a cɩnta nɔ dɔ y, gɔsɩ b'a dam ma, an a zaarɔ jɩ dɔ y. ");
INSERT INTO bib_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Wosoci y'a hɩrɛ, a ʊ: Nka ɩ Zuuba hɔɔndarɛ dɔ? Gɛɛ, nka ɩ nyɩnta a dʊndɔrɛzaa? ");
INSERT INTO bib_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Gɛɛ, nka ɩ lɛɛ ka an hɔ ka ʊ, k'an a zɩm ka a zaa ʊ? ");
INSERT INTO bib_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Bala, hɔ haay bɩ, a to a ʊ a zi, an ta ʊ a paŋŋa tɔ ma, an ta ʊ a mɩŋŋa tɔ ma. Woso m lɛbɔʊrɛ yɩ dɔmɩm haay! Amina! ");
INSERT INTO bib_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","M danyɩnɔ, k'a yo Woso n a ŋʊarɛ zi ba kan awɔɔ kɩ ncɩnaaʊ bɩ, a yɛ mɔɔ nawʊrɛ awɔɔ han k'a mɩŋŋɔɔ ka Woso ʊ, amba mannɩ k'an mɩsɩr, Woso n a so ʊ, an mɩŋŋa ma bɩ m. Daʊrɛ naa do nɩ Woso nɔ yɩm. ");
INSERT INTO bib_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","A bɩ zu her durnya naa mɩsɩrbaa zaarɔ ʊ y, bɩ k'a yɛ a zu Woso zaarɔ ʊ, k'awɔɔ hɔɔndarɛ n a lʊr jilli, an awɔɔ banka. Maam bɩ, awɔɔ Woso hɔnhɔ, hɔ k'an mɩŋŋa, an a nɔ yɩ, an mɩŋŋa paan… bɩ dɔrɛ. ");
INSERT INTO bib_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Woso barka bɩ tɔ ma, mɔɔ m da ma m a hɩ awɔɔ gʊaa biyəə m, m ʊ: a b'a mɩŋŋɔɔ m busu a heer ʊ y. Bɩ, gʊaa biyəə n dɩga a mɩŋŋa ma, amba Woso sɩrakarɛ hɔ jir a n'a hɔ ka ʊ bɩ m. B'a b'a ka an bra ba a mɩŋŋa m y. ");
INSERT INTO bib_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Gʊaa mɛ vəŋŋə bɩ deem nɩ y, ŋ gʊta, ŋn'a hʊnhɔ sɔ, wɔɔ mɛ vəŋŋəro bɩr zi deem barɛ y. ");
INSERT INTO bib_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Ncɩnaaʊ sɔ bɩ, wɔɔ kʊ wɔɔ m gʊta bɩ, mɛ deem m wɔɔ m Krista zɛkʊra bɩ nɔ ʊ, ʊ nɩ zɛkʊra m kan kʊ kɩ, gʊaa biyəə kan a bɩncɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Gʊaa biyəə nɩ ganwʊrɛ do m a hʊnhɔ, an a ga kʊ ʊ kan barka kʊ Woso a ka ʊ bɩ kɩ m. Kʊ wosolɛsinnɩsora ganwʊrɛ nɩ, k'a zaa m bɩr zi bam nɩ, k'an a ga kʊ ʊ kan sɩrakarɛ kɩ. ");
INSERT INTO bib_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Kʊ gʊaa vanta ɩ daahan ganwʊrɛ nɩ, k'an bɩr a daahan zi bam, k'a vanta ɩ hɔdɩndarɛ ganwʊrɛ nɩ, k'an a hɔdɩndarɛ zi ba. ");
INSERT INTO bib_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Kʊ gʊaa vanta ɩ dʊndɔrɛ ganwʊrɛ nɩ, k'an a zi ba. Gʊaa k'a nɩ hɔ kam, k'an a ka kan a heer kɩ haay. Kʊ lɛɛzannɔ n a zi ba mɩŋŋa-mɩŋŋa, kʊ gʊaa cicirzɛrɛzaa n a cicirzɛrɛ zi ba kan heernyɩnta kɩ. ");
INSERT INTO bib_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","K'a kʊ ŋʊa sɩra m. K'a sɔ hɔ bʊnyaa m, a zi mɩŋŋa barɛ nyasʊ kɔɔkɔɔ. ");
INSERT INTO bib_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","K'a bɩr a kam kʊ ŋʊarɛ ma kan a heer kɩ haay, amba danyɩnɔ nɩ kʊ ŋʊam bɩ m. K'a bɩr lɛ zɛm kʊ daʊrɛ ma. ");
INSERT INTO bib_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","K'a yakʊ to, a Zuuba zi ba kaarɛ-kaarɛ. ");
INSERT INTO bib_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","K'a heernyɔɔ ba taaheerlɛ nɔ ʊ, a bʊr a ma cicir nɔ ʊ, k'a a yo ʊ yaadarɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","K'a da wosogʊɔɔ kʊ hɔ jɩra ŋ ma rɔ wɔɔ han, k'a bɩ kɔ saanɔɔ sire ma y. ");
INSERT INTO bib_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Gʊɔɔ kʊ ŋ nɩ cicir karɛ awɔɔ ma rɔ wɔɔ, k'a yɛ Woso han k'an hɔ mɩŋŋa ba ŋ nɩ. K'a lɛ nyɩnta da gʊɔɔ nʊ, a b'a bʊnyaa da ŋ nʊ y. ");
INSERT INTO bib_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","K'a heer nyɔɔ kan gʊɔɔ kʊ ŋ n'a heernyɔɔm nɔ wɔɔ kɩ, k'a nyi ka kan gʊɔɔ kʊ ŋ nɩ nyi kam nɔ wɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","K'a kʊ ma mɩŋŋa, a b'a mɩŋŋɔɔ busu y. ‹A b'a gu zibəə poore barɛ ma y, a bɩ dɩga a mɩŋŋɔɔ ma mindonno y.› ");
INSERT INTO bib_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","A bɩ zi bʊnyaa ba a sompi gʊaa nʊ y. ‹K'a a ka ma k'a mɩŋŋa ba gʊɔɔ haay mɩm ʊ.› ");
INSERT INTO bib_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","K'a ɩ yɩrɛ ɩ ʊ, awɔɔ an ta a ma, k'a a yo ʊ k'a bɩr laafɩɩ m kan gʊɔɔ haay kɩ. ");
INSERT INTO bib_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","M danyɩnɔ ŋʊarɛrɔ, a b'a zɩm bɔ a zim nɩ y, bɩ k'a to kʊ Woso n a nɔmaa zi ba, bala, n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: ‹Mɔɔ m Zuuba, mɔɔ nɩ zɩm bɔm, mɔɔ n nɩ gʊaa biyəə hɔ k'a a ga m kaŋ ʊ.› ");
INSERT INTO bib_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","N y'a ya n a gʊrsɩra ba, n ʊ: ‹Bɩ kʊ nɔ y'ɩ jɩm zɛrɛ, k'ɩ hɔbɩrɛ ka ʊ k'an a bɩ. Kʊ mɩsɩ y'a zɛm, k'ɩ hi ka ʊ k'an a mi. Bala, a ba k'ɩbɩɩ nawʊm maam bɩ, sɛkɩna ɩbɩɩ n'a karɛ a mim la bɩ.› ");
INSERT INTO bib_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Ɩ b'a to mimbʊnyaa m bʊr ɩ ra y, b'a mɩŋŋa ba k'ɩ bʊr a bʊnyaa ra. ");
INSERT INTO bib_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Gʊaa haay a ga m, an zu lɛɛzannɔ kʊ ŋ nɩ dɩgam kʊ bɩ ma rɔ wɔɔ lɛ ʊ. Bala, lɛɛzaa ba ʊ, k'a a to bɛɛ ʊ Woso zi y. Kʊrɔ lɛɛzannɔ kʊ ŋ nɩ ta ʊ haay rɔ nɔɔm, Woso yɩ ŋ cɩncɩnta. ");
INSERT INTO bib_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Ncɩnaaʊ bɩ, kʊ gʊaa bɩsɩ ka lɛɛzannɔ ma, bɩsɩ a ka lɛ kʊ Woso a cɩnta bɩ ma. Gʊɔɔ kʊ ŋ nɩ bɩsɩ karɛ ŋ ma rɔ wɔɔ dʊdɔyarlɛ yɩrɛ. ");
INSERT INTO bib_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Bala, gʊɔɔ kʊ ŋ n'a mɩŋŋa bam nɔ wɔɔ b'a dam ma, ŋnɩ nyi ba lɛɛzannɔ nɩ y, bɩ, a bʊnyaabənno wɔɔ nyi barɛ ŋ nɩ. K'ɩ lɛ baa k'ɩ nyi ba lɛɛzannɔ m, k'ɩ zi mɩŋŋa ba, ŋ y'a lɛ bɔrɛ ɩ ʊ, ");
INSERT INTO bib_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","bala, Woso zi ŋ n'a bam, k'a ka k'ɩbɩɩ n a mɩŋŋa ba. Bɩ k'ɩbɩɩ y'a bʊnyaa barɛ, k'ɩ nyi ba ŋ nɩ. Bala, paŋŋa kʊ ŋ nɩ ta m k'a gʊaa hʊnhʊr bɩ, a bɩ vam nɩ y. Woso zi ŋ n'a bam, k'a Woso nɔmaa hɩnka a bʊnyaabarɛzaa m. ");
INSERT INTO bib_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Bɩ minto nɩ, gʊaa n a ga m, an zu kʊ lɛɛzannɔ wɔɔ lɛ ʊ. Kʊ Woso nɔmaa n b'a yɩ minto bɛɛ n'a deem nɩ y. Kʊ heer kɔrɛ bɩ nyɩnta ʊ sɔ y. ");
INSERT INTO bib_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Naa tɔ ma m sɔ, awɔɔ n nɩ yawʊrlɔ kam, bala, a sirezannɔ wɔɔ, Woso yɩ ŋ da ʊ kʊ ŋ n'a ba mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","K'a gʊaa biyəə hɔ k'awɔɔ m ta m ka ʊ. Kʊ yawʊr m, k'a ka a zaa ʊ. Kʊ hɔhɛɛrɛ gɛɛ a sire yawʊr m, k'a ka sɔ. Kʊ gʊaa k'awɔɔ a ga m a lɛ si bɩ nɩ, k'a lɛ si. A n a ga m awɔɔ n a da ʊ bɩ, k'a da ʊ. ");
INSERT INTO bib_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Awɔɔ, a b'a ka kʊ gʊaa zɩm m bɩr ta awɔɔ ra y, kʊ bɩ m kʊ ŋʊarɛ m. Gʊaa k'a mim ŋʊa bɩ, a zaa hɔ kʊ lɛrɔ wɔɔ a cɩnta bɩ ba haay. ");
INSERT INTO bib_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Bala, lɛrɔ kʊ ŋ n'a hɩrɛ ŋ ʊ: ‹Ɩ bɩ jaan da y, ɩ bɩ gər zɛ y, ɩ bɩ koor ba y, ɩ b'a ka ɩ lɛ m bɩr gʊaa hɔ zi y.› Nawɔnnɔ haay kan lɛrɔ kʊ ŋ gɔɔta rɔ wɔɔ kɩ haay, a zɛ ŋ yaa ʊ kʊ ra lɛ naa do nɔ ʊ: ‹Ɩ mim ŋʊa amba ɩ ɩ mɩŋŋa ŋʊa bɩ m.› ");
INSERT INTO bib_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Gʊaa k'a n'a mim ŋʊam bɩ, a bɩr hɔsɩ bʊnyaa bam nɩ y. Bɩ y'a ka, kʊ gʊaa ɩ ŋʊarɛ m, a zu lɛrɔ wɔɔ ʊ haay. ");
INSERT INTO bib_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","K'awɔɔ dɔmɩm kʊ wɔɔ m ta ʊ naa mim dɔ bɩ, wakatɩ m, an a ga m k'awɔɔ n gu hinceem ma. Her naa, bʊmbɔrɛ bɩ jɩnjɛɛm wɔɔ ma, an lɛ da dɔmɩm kʊ wɔɔ sɩŋŋɩda sa ʊ, ʊ sɩra ka ʊ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Gum da gʊta, dɔmɩrɛ a zɔ, bɩ minto bɩ, ʊ monsigə zibəəro to, ʊ lɛɛgure yarmɔr da ʊ ma. ");
INSERT INTO bib_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ʊ ta sɩra nɔ ʊ, amba a a ga m n nɩ ta sinsebir ʊ bɩ m. Ʊ b'ʊ zɛ kʊ ra k'ʊ hɔ bɩ maam-maam y, k'ʊ hɔ mi maam-maam sɔ y. Ʊ bɩ jaan da y, ʊ bɩ mɛsim zi daŋŋadɔɔ ba y, ʊ bɩ nyaa ba kan kʊ kɩ y, ʊ bɩ jɩmbaa da kʊ ma y. ");
INSERT INTO bib_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","K'a mɩsɩrbaa daa kʊ Zuuba Yeezuu Krista mɩsɩrbaa m bɩ ba, a b'a ya, a a hɔɔn da a mɩŋŋɔɔ m mɛsim mɩsɩrbaa gusire bɩ ma, k'a lɛtaamarɔ ba y. ");
INSERT INTO bib_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","K'a gʊaa kʊ paŋŋawarzaa m sɩrakarɛ nɔ ʊ bɩ si, b'a ba hɔɔndarɛrɔ mim dɩnda bʊnyaa y. ");
INSERT INTO bib_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Makra ba n nɩ, gʊaa deem y'a gɩngarɛ a ʊ, a a da ma a hɔ haay bɩ, deem n bɔkarɛ, a sɩrakarɛ paŋŋawar minto bɩ, dʊlɛɛrɔ an ŋ bɩrɛ. ");
INSERT INTO bib_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Gʊaa k'a nɩ hɔ haay bɩm bɩ n a ga m, an gʊaa k'a bɩr a bɩm bɩ gore bɔ ʊ y, bɩ gʊaa k'a bɩr a bɩm bɩ, a bɩ gʊaa k'a n'a bɩm bɩ dʊdɔ ka y, bala, Woso a zaa si a zi. ");
INSERT INTO bib_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Nka n'ɩbɩɩ m, k'ɩ gʊaa vanta zibəənyɩ dʊdɔ ka? K'a jɩm kɔɔkɔɔ, gɛɛ k'a do, a zuuba bɩ mim m bɩ. B'a jɩnɩm kɔɔkɔɔ sɔ, bala, Zuuba ɩ paŋŋa m k'a ka k'an jɩm. ");
INSERT INTO bib_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Makra vanta ba n nɩ sɔ: Gʊaa niŋŋə zi, dɔmɩnnɔ wɔɔ lɛ da kʊ m, a vanta zi, dɔmɩnnɔ wɔɔ hɔdeem. A a ga m kʊ gʊaa biyəə n hɔ k'an ta m a heer ʊ bɩ dɔ mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Gʊaa k'a nɩ dɩgarɛ a ʊ, dɔmɩnnɔ wɔɔ lɛ da kʊ m bɩ, a ba a nawʊm Zuuba tɔ ma, gʊaa k'a nɩ hɔ haay bɩm bɩ, Zuuba tɔ ma m sɔ, bala, a ɩ Woso barka darɛ. Gʊaa k'a bɩr hɔ haay bɩm bɩ, Zuuba tɔ ma m sɔ, an nɩ Woso barka darɛ. ");
INSERT INTO bib_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Bala, wɔɔ gʊaa deem ba ʊ, an nɩ mɩsɩrbaa bam a mɩŋŋa minto y, bɩ gʊaa ba ʊ sɔ, an nɩ gam a mɩŋŋa minto sɔ y. ");
INSERT INTO bib_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Bala, kʊ wɔɔ mɩsɩr, Zuuba tɔ ma m wɔɔ nɩ mɩsɩrbaa bam, kʊ wɔɔ gɩnga, gɩnga wɔɔ ʊ Zuuba tɔ ma sɔ. Kʊ wɔɔ mɩsɩr gɛɛ kʊ wɔɔ gɩnga, Zuuba ɩ gɔɔta an a so wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Bala, a hɩ Krista ʊ k'a nyɩnta gəəno kan mɩsɩɩrɔ kɩ Zuuba, bɩ minto m an ga an a ya an a mɩm bɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","B'ɩbɩɩ, bɔ m ɩ n'ɩ danyɩ dʊdɔ karɛ? B'ɩbɩɩ, bɔ minto m sɔ, ɩ n n'ɩ danyɩ gore bɔŋ ʊ? Wɔɔ haay naa, Woso wɔɔ birm a dʊdɔkarɛ duu bɩ taa, k'a bɩ wɔɔ dʊdɔ ka. ");
INSERT INTO bib_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Bala, n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: Amba mɔɔ mɩŋŋa Zuuba m mɩsɩr denter naa m, mɔɔ y'a hɩ m ʊ: Gʊaa haay kukurə zɛrɛ m taa, gʊaa biyəə yaa darɛ, an a leer busu an a hɩ, a ʊ, mɔɔ m Woso. ");
INSERT INTO bib_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Maam bɩ, wɔɔ gʊaa biyəə y'a mɩŋŋa mim nyɩ bɔŋ ʊ Woso taa. ");
INSERT INTO bib_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Ʊ b'ʊ ya, ʊ kʊ dʊdɔ yar y. Bɩ, k'a ka ma k'a bɩ hɔsɩ ba fɩɩga k'an a ka, k'a danyɩ n a do, gɛɛ an mimbʊnyaa ba y. ");
INSERT INTO bib_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Zuuba Yeezuu zɛkʊra nɔ ʊ, mɔɔ dɔ mɩŋŋa m heer ʊ, m ʊ, hɔsɩ ba ʊ an dintim nɩ y. Bɩ, kʊ gʊaa a hɔɔn da, a ʊ, hɔ naa do dintim m, a ba a nawʊm dintim a mɩŋŋa ma. ");
INSERT INTO bib_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","K'ɩbɩɩ ka ɩ danyɩ heer n a zar hɔbɩrɛ tɔkkɛ k'ɩbɩɩ n'a bɩm tɔ ma, ɩbɩɩ bɩr tam ŋʊarɛ nɔ ʊ dɔ y. Ɩ b'a ka kʊ gʊaa kʊ Krista ga a tɔ ma bɩ m nyaam ɩ hɔ k'ɩ n'a bɩm bɩ tɔ ma y. ");
INSERT INTO bib_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","A b'a ka hɔ k'an mɩŋŋa awɔɔ ma bɩ m bʊr tɔ bɔrɛ m awɔɔ jɛ ʊ y. ");
INSERT INTO bib_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Bala, Woso cirbəə bɩ, hɔbɩrɛ kan hɔmire kɩ mim bɛɛ y, tɩrgabaa kan laafɩɩ kɩ, heernyɩnta kʊ Sɛnt-Ɛspri n'a kam bɩ kɩ mim m. ");
INSERT INTO bib_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Gʊaa k'a nɩ Krista zi barɛ ncɩnaaʊ bɩ, Woso nɔ ɩ yɩm la, gʊɔɔ n'a ŋʊam sɔ. ");
INSERT INTO bib_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Naa tɔ ma bɩ, ʊ ʊ ka hɔ k'a nɩ zɛm laafɩɩ m kan wɔɔ haay sɩrakarɛ talɛɛ kɩ bɩ ma. ");
INSERT INTO bib_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Ɩ bɩ Woso zibəə zar hɔbɩrɛ tɔ ma y. Hɔ haay mɩŋŋa, sɩra m, bɩ, kʊ gʊaa hɔ niŋŋə k'a nɩ zɛm gʊaa vanta dore m bɩ bɩ, a bʊnyaa. ");
INSERT INTO bib_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Hɔ k'an mɩŋŋa bɩ ba n nɩ: Kʊ sim sʊrɛ, gɛɛ bɛɛ mire, gɛɛ hɔ vanta barɛ y'a karɛ ɩbɩɩ danyɩ n'a do, ɩ b'a ba y. ");
INSERT INTO bib_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ɩ sɩrakarɛ k'ɩ n ta m hɔ bɩ do minto bɩ to ɩ zi, Woso lɛɛ. Heernyɩntazaa m gʊaa k'a n'a ŋʊam k'a mim ba b'a heer bɩr a dʊdɔ yarm bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Bɩ, gʊaa k'a nɩ hɔ bɩm an bɔkarɛ a heer nɩ sɩnsɩm kam hɔ bɩ do ma bɩ, Woso a dʊdɔ yar, bala, a zibəə bɩ n a to heer sɩrakarɛ nɔ ʊ y. A n bɔkarɛ hɔ haay k'a n a to heer sɩrakarɛ nɔ ʊ bɩ, mimbʊnyaa m. ");
INSERT INTO bib_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Wɔɔ kʊ wɔɔ paŋŋa m ta ʊ rɔ wɔɔ, ʊ b'ʊ ka ʊ hɔɔnhɔ lɛtaama barɛ ma y. Bɩ, k'ʊ ʊ da gʊɔɔ kʊ ŋ ba paŋŋa bɩ do m nɔ wɔɔ han a paŋŋawar bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","A a ga m kʊ gʊaa biyəə n a ka ma k'a yɩ mɩŋŋa a mim tɔ ma, a daahan kan a sɩrakarɛ kɩ dara minto. ");
INSERT INTO bib_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Bala, Krista n a ka hɔ k'a mɩŋŋa nɔ yɩ ma y, bɩ, n y'a gʊrsɩra ba Wosoci b'ʊ, n ʊ: ‹Ɩbɩɩ sʊnsɔrɔ kʊ gʊɔɔ n'a wʊm nɔ wɔɔ a ba mɔɔ sʊnsɔrɔ.› ");
INSERT INTO bib_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","A n bɔkarɛ, hɔ kʊ n lɛɛ ka n n'a gʊrsɩra ba haay bɩ, a ba n y'a ʊ kʊ wɔɔ m hɔ dɔ, k'an bɩr yɩrɛ ɩ ʊ, bʊraama kan heerwʊtarɛ kʊ Wosoci bɩ n'a kam bɩ tɔ ma, wɔɔ ʊ da ma ʊ nyasʊ taaheerlɛ m. ");
INSERT INTO bib_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","A yɛ mɔɔ nawʊm, kʊ Woso k'a a so bʊraama ʊ kan heerwʊtarɛ kɩ bɩ n a ka k'awɔɔ m bɩr hɔɔndarɛ deem m kan kʊ kɩ, amba Krista Yeezuu lɛ n taa bɩ m, ");
INSERT INTO bib_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","k'a a da ma, a a lɛ bɔ wɔɔ Zuuba Yeezuu Zɩ kʊ Woso m b'ʊ, zɛkʊra deem nɔ ʊ, leer deem m. ");
INSERT INTO bib_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","K'a bɩr kʊ sim mɩŋŋa, amba Krista awɔɔ si bɩ m, Woso lɛbɔʊrɛ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","A hɩ mɔɔ nawʊrɛ awɔɔ m paan… Krista bɩ, a ba a ʊ zɩɩfʊrɔ zibəənyɩ, k'a a da ma a ka kʊ Woso lerbɔrɛrɔ ŋ yaabɔɔ m nɔ wɔɔ ŋ kʊ yɩ, k'a Woso sɩra hɩnka maam. ");
INSERT INTO bib_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Bʊr a ʊ sɔ, kʊ do vantɔɔ gʊɔɔ wɔɔ n a lɛ bɔ Woso ʊ, a mɩŋŋabaa tɔ ma, amba n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: Naa minto bɩ, mɔɔ yɩ m lɛ bɔrɛ ɩbɩɩ ʊ doro bire ʊ, mɔɔ laa lɔm m ɩ tɔ da ʊ. ");
INSERT INTO bib_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Wosoci b'a ya, an a hɩ, a ʊ: Doro vantɔɔ, k'a a heer nyɔɔ kan Zuuba do bɩ kɩ. ");
INSERT INTO bib_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","A n a ya, an a hɩ, a ʊ: Doro haay, k'a a lɛ bɔ Zuuba ʊ. Kʊrɔ haay gʊɔɔ, k'a lɛ bɔ ʊ sɔ. ");
INSERT INTO bib_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Ezayii ci a hɩ sɔ, a ʊ: Yese yaŋŋa bɩ zɛm, a wutire an ka doro lɛɛ, doro wɔɔ n yo ma. ");
INSERT INTO bib_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","A yɛ mɔɔ nawʊm, kʊ Woso k'a so taaheerlɛ ʊ bɩ n a ka, k'awɔɔ n'a mɩŋŋɔɔ ka ʊ, bɩ k'a n'a ka sɔ, kʊ heernyɔɔ kan laafɩɩ kɩ n'awɔɔ han gʊta, Sɛnt-Ɛspri paŋŋa tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","M danyɩnɔ, mɔɔ dɔ mɩŋŋa m ʊ, awɔɔ ɩ mɩŋŋabaa m gʊta, a hɔ k'a a ga dɔrɛ m haay dɔ, an n'a dam ma a kʊ dʊndɔ. ");
INSERT INTO bib_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","A n bɔkarɛ, ci naa do nɔ ʊ naa, mɔɔ lɛɛ niŋŋoo gʊrsɩra ba kan heerkoodəbaa kɩ, k'an bɩr yɩrɛ ɩ ʊ, mɔɔ hɔɔ niŋŋoo tɔ da awɔɔ nɔ ʊ. A ba mɔɔ ʊ ncɩnaaʊ, barka niŋŋə kʊ Woso a ka mɔɔ ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Woso a k'a mɔɔ n Krista Yeezuu zi ba, amba wosomannɩbər hɔ bɩ m. Bɩ zibəə bɩ do, lemim nyɩnta bɩ padarɛ m. Ncɩnaaʊ bɩ, kʊ mɔɔ ɩ do vantɔɔ gʊɔɔ ka ŋ ʊ mannɩ ganwʊrɛ, kʊ bɩ n Woso nɔ yɩ, kʊ Sɛnt-Ɛspri n zer la, k'an yɩ mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Krista Yeezuu zɛkʊra bɩ nɔ ʊ, mɔɔ m da ma, m m heer nyɔɔ, Woso zi kʊ mɔɔ n'a bam bɩ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Kʊ mɔɔ kʊ m hɔ niŋŋə mim hɩ, hɔ kʊ Krista a ka mɔɔ n a ba kʊ do vantɔɔ gʊɔɔ wɔɔ m zu Woso ʊ bɩ m. Naa ba a ʊ, meerbaarɔ kan zibəəro kɩ nɔ ʊ, ");
INSERT INTO bib_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","hoserlo kan makrarɔ paŋŋa kɩ, Sɛnt-Ɛspri paŋŋa kɩ nɔ ʊ. Yɩ a ʊ, ncɩnaaʊ, mɔɔ m lemim nyɩnta bɩ pa da lɛɛ haay ʊ mɩŋŋa, an a sa Zerizalɛm ma an ta Iliiri kʊrɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Bɩ, lɛɛrɔ kʊ n nɩ Krista mim ma ʊ cɩna rɔ wɔɔ, mɔɔ lemim nyɩnta bɩ pa da ŋ ʊ. A ba mɔɔ ʊ ncɩnaaʊ, kʊ mɔɔ n a ŋʊa kʊ m zi ba lɛɛ kʊ gʊaa lɛɛ ka an zibəə sɩŋŋɩda sa ʊ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Hɔ kʊ n y'a gʊrsɩra ba Wosoci b'ʊ bɩ mɔɔ ba, n ʊ: Gʊɔɔ kʊ n n'a mim dɩnda ŋ nɩ rɔ wɔɔ y'a yɩm, gʊɔɔ kʊ ŋ n hɔsɩ ma a mim nɔ ʊ rɔ wɔɔ y'a mim jɩ dɔrɛ.› ");
INSERT INTO bib_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Naa do ɩ tɩr a nya mɔɔ ʊ, mɔɔ bɩr m dam ma m nɩ zɛrɛ awɔɔ zi y. ");
INSERT INTO bib_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Bɩ, kɛɛrɛ naa, mɔɔ zibəə nya kʊrɔ wɔɔ duro ʊ. A dɔɔraa laatʊ mɔɔ n n'a ŋʊam kʊ m bʊr awɔɔ zi. ");
INSERT INTO bib_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Kʊ mɔɔ bʊr m nɩ tam Ɛspanyɩ ʊ, mɔɔ bɔm b'ʊ. A ŋʊa mɔɔ nawʊm kʊ m bɩ dɩga awɔɔ ma. Kʊ mɔɔ bɩ zer awɔɔ ra, m nyɩnta kan awɔɔ kɩ m a ga m tɛkka m, k'awɔɔ m dɩga mɔɔ zaa bɩ sarɛ mim ma, kʊ m cem. ");
INSERT INTO bib_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Her-her naa, ta mɔɔ nawʊm Zerizalɛm ʊ, daahan m, wosogʊɔɔ kʊ ŋ nɩ b'ʊ rɔ wɔɔ tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Bala, Masedʊan kʊ bɩ kan Akayii kʊ bɩ kɩ wosogʊɔɔ wɔɔ lɛ sa, k'a busoo zɩnzɛ kʊ ra, a ka Zerizalɛm wosogʊɔɔ ŋʊazannɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Ŋ mɩŋŋɔɔ ɩ lɛ bɩ sa a zim, bɩ sɩra nɔ ʊ, cicirzannɔ wɔɔ duro a ga hɔ naa do yɩrɛ m ŋ zi, bala, Krista gʊɔɔ kʊ zɩɩfʊrɔ n ŋ mɩ Zerizalɛm ʊ rɔ wɔɔ a Woso dɔrɛhɔ jir kan do vantɔɔ gʊɔɔ wɔɔ kɩ. Naa tɔ ma bɩ, do vantɔɔ gʊɔɔ kʊ Krista gʊɔɔ m nɔ wɔɔ a ga m ŋn'a da ŋ han kan hɔnta kʊ ŋ nɩ tam bɩ kɩ sɔ. ");
INSERT INTO bib_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Kʊ mɔɔ zi naa do ba m a nya, m zɩnzɛkʊra busoo bɩ ka ŋ ʊ, mɔɔ bɔrɛ awɔɔ zi, m cem m ta Ɛspanyɩ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Mɔɔ dɔ mɔɔ ʊ, kʊ mɔɔ bʊr m nɩ zɛrɛ awɔɔ zi, zɛ mɔɔ nawʊm kan Krista barka gʊta kɩ. ");
INSERT INTO bib_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","M danyɩnɔ, a yɛ mɔɔ nawʊrɛ awɔɔ han, wɔɔ Zuuba Yeezuu Krista tɔ ma, kan ŋʊarɛ kʊ Sɛnt-Ɛspri n n'a kam bɩ kɩ minto, k'a yar ba kan mɔɔ kɩ a yaadarɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","K'a yaa da, kʊ basɩrakarɛzannɔ kʊ ŋ nɩ Zidee ʊ rɔ wɔɔ b'a da mɔɔ ma y. Bɩ, kʊ wosogʊɔɔ kʊ ŋ nɩ Zerizalɛm ʊ rɔ wɔɔ m daahan kʊ mɔɔ n nɩ tam nɩ bɩ si mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","K'a n bɩr yɩrɛ ʊ, kʊ Woso yɛ sɔ, mɔɔ lee kure awɔɔ zi heernyɔɔ gʊta m, m hoon si awɔɔ bire ʊ. ");
INSERT INTO bib_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Kʊ Woso k'a nɩ laafɩɩ kam bɩ m bɩr kan awɔɔ haay kɩ. Amina! ");
INSERT INTO bib_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Wɔɔ danlʊ Febe k'a nɩ zi bam Sankre kristagʊɔɔ sokʊma bɩ nɔ ʊ bɩ, mɔɔ n'a hɩ m, a kasɛtɩ mɩŋŋa. ");
INSERT INTO bib_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","K'a si a zi Zuuba tɔ ma, amba a a ga barɛ m wosogʊɔɔ kan kʊ kɩ bire ʊ bɩ m, k'a bʊr a lɛ n taa awɔɔ daahan ma, k'a a da han a mim haay nɔ ʊ. A mɩŋŋa a da gʊɔɔ han gʊta, a a da mɔɔ mɩŋŋa han sɔ. ");
INSERT INTO bib_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","K'a yaa da Priska kan Akilas kɩ m, mɔɔ zibəəkɔɔnrɔ m Krista Yeezuu zibəə bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Ŋ y'a mɩŋŋɔɔ mee ka zɛ ma, k'a mɔɔ bɔ lɛm. Mɔɔ yɩ m deem bɛɛ nɩ ŋ barka darɛ y, do vantɔɔ wɔɔ kristagʊɔɔ sokʊmarɔ wɔɔ haay yɩ ŋ barka dam sɔ. ");
INSERT INTO bib_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","K'a yaa da sɩrakarɛzannɔ kʊ ŋ n'a som kʊ ma ŋ har ʊ rɔ wɔɔ m. K'a yaa da mɔɔ gʊaasɩba Epayinɛtɩ bɩ m, a ɩ lɛɛ ka an sɩra ka Krista ʊ Azii kʊrɔ wɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","K'a yaa da Maarii k'a zi ba gʊta awɔɔ tɔ ma bɩ m. ");
INSERT INTO bib_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","K'a yaa da Andronikus kan Zuniyas kɩ m, mɔɔ danyɩnɔ m, bɩ, n nyɩnta n nɩ ŋ du lɔnnɔcɛ ʊ kan mɔɔ kɩ. Kristazibəəzannɔ wɩsɩrɔ m, ŋ lɛɛ ka mɔɔ m ŋn'a ba kristagʊɔɔ. ");
INSERT INTO bib_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","K'a yaa da Ampliyatus m, mɔɔ ŋʊarɛzaa m Zuuba zuure nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","K'a yaa da Urbɛn m, wɔɔ zibəəkɔɔn m Krista zibəə bɩ nɔ ʊ, kan mɔɔ ŋʊarɛzaa Sɩtakɩs kɩ m. ");
INSERT INTO bib_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","K'a yaa da Apelɛs m, a a sɩra ka Krista ʊ hɩnka hɔ gʊta nɔ ʊ. K'a yaa da Aristobul hargʊɔɔ m. ");
INSERT INTO bib_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","K'a yaa da Herodɩnyɔ m, mɔɔ danyɩ m. K'a yaa da Narsis hargʊɔɔ kʊ ŋ sɩra ka Zuuba ʊ rɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","K'a yaa da Trifɛn kan Trifozɩ kɩ m, Zuuba zi ŋn'a bam. K'a yaa da Pɛrzidɩ m mɩŋŋa, a zi ba gʊta Zuuba tɔ ma. ");
INSERT INTO bib_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","K'a yaa da Rufus m, Zuuba zibəənyɩ wɩsɩ m. K'a yaa da a da bɩ m, mɔɔ da m sɔ. ");
INSERT INTO bib_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","K'a yaa da Asɩnkritɩ m, Flegɔn m, Hermɛs m, Patrobas m, Hermas m, kan danyɩnɔ vantɔɔ kʊ ŋ nɩ kan ŋ kɩ rɔ wɔɔ m. ");
INSERT INTO bib_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","K'a yaa da Filolɔg kan Zuli kɩ m, Neere kan a danlʊ kɩ m, Olɩmpas kan wosogʊɔɔ kʊ ŋ nɩ kan ŋ kɩ rɔ wɔɔ m haay. ");
INSERT INTO bib_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","K'a yaa da kʊ m mɩŋŋa danyɩbaa nɔ ʊ, kan kʊ daʊrɛ kɩ, ŋʊarɛ kɩ. Krista sokʊmarɔ wɔɔ haay ɩ yaa darɛ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","M danyɩnɔ, a yɛ mɔɔ nawʊrɛ awɔɔ han k'a dundo a zi, kan gʊɔɔ kʊ ŋ nɩ gʊɔɔ gʊngʊ kʊ ma zi bam nɔ wɔɔ kɩ, ŋnɩ sɩrakarɛzannɔ nyʊnnyɔɔ m, bɩsɩ kʊ ŋ n'a kam hɔdɩndarɛ k'awɔɔ yɩ bɩ ma. K'a gʊ ŋ ma laatʊ. ");
INSERT INTO bib_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Bala, gʊɔɔ ncɩnaaʊ rɔ wɔɔ, Zuuba Krista zi bɛɛ ŋ n'a barɛ y, a mɩŋŋɔɔ nɔ zi ŋn'a bam. Bra ŋ n'a bam bahɔdonno m, meerbaarɔ nyɩntɔɔ kan a ŋʊaar mindɩndarɛrɔ kɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Gʊaa haay a dɔ, a ʊ, awɔɔ ɩ yɛm Zuuba ma. Mɔɔ heer nyɩnta kan awɔɔ kɩ naa tɔ ma, bɩ mɔɔ lɛ n taa k'awɔɔ m yɩ mindɔrɛzannɔ, zi mɩŋŋa barɛ nɔ ʊ. K'a yɩ gʊɔɔ kʊ mim bɩr zar darɛ ŋ ma zannɔ, mimbʊnyaa nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Woso k'a a so laafɩɩ ʊ bɩ Sʊtaana hɔɔnsɩrɛ awɔɔ gannɔ taa dɩɩtaa. Bɩ kʊ wɔɔ Zuuba Yeezuu barka m bɩr kan awɔɔ kɩ. ");
INSERT INTO bib_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Mɔɔ zibəəkɔɔn Timote ɩ yaa darɛ awɔɔ m, mɔɔ danyɩnɔ Lusiyus, Zasɔn, kan Sosipatɛɛr k'ɩ yaa darɛ awɔɔ m. ");
INSERT INTO bib_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Bɩ, mɔɔ mɩŋŋa Tɛɛrtiyus, kʊ Pol a da ci naa do barɛ ʊ bɩ, mɔɔ ɩ yaa darɛ awɔɔ m Zuuba k'a nɩ wɔɔ zɛm kʊ ra bɩ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus k'a mɔɔ si a har ʊ, kristagʊɔɔ sokʊma bɩ haay n nɩ kʊ zɛŋ ʊ a har ʊ b'ɩ yaa darɛ awɔɔ m. Erastɩ, kʊ bɩ busoocɩntər bɩ, kan Kaartus kɩ ɩ yaa darɛ a m.  ");
INSERT INTO bib_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","A yɛ mɔɔ nawʊm, kʊ wɔɔ Zuuba Yeezuu Krista barka m nyɩnta kan awɔɔ haay kɩ. Amina! ");
INSERT INTO bib_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Woso ɩ paŋŋa m k'awɔɔ sɩrakarɛ paŋŋa da ra, amba lemim nyɩnta kʊ mɔɔ n n'a pa dam bɩ n n'a hɩm bɩ m, Yeezuu Krista lemim kʊ mɔɔ n'a pa dam, Woso hɔ k'a nyaakʊm da gɔsɩ n a dɔ y, an a hɩnka wɔɔ m, ʊ a dɔ bɩ m. Hɔ bɩ do Woso nyɩnta an a nyaakʊm da biisi tee… bɩ, ");
INSERT INTO bib_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","kɛɛrɛ naa, wosolɛsinnɩsorazannɔ ciro wɔɔ a hɩnka lɛɛgure nɔ ʊ gʊaa haay m, amba Woso k'a nyarɛ ba ʊ lɛ ka bɩ m, a lɛ ka kʊ n nɩ ta m doro haay zi kʊ ŋ n'a dɔ, ŋnɩ sɩra ka, ŋnɩ zu ʊ. ");
INSERT INTO bib_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Kʊ Woso y'a deem k'an ta mindɔrɛ m bɩ m lɛbɔʊrɛ yɩ, Yeezuu Krista tɔ ma, dɔmɩm haay! Amina!");
INSERT INTO bib_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Mɔɔ mɩŋŋa Pol, Woso ɩ mɔɔ bir a hɔɔnhɔ nɔ ʊ kʊ m yɩ Krista Yeezuu zibəəzaa, mɔɔ m kan wɔɔ danyɩ Sɔstɛn kɩ m nɩ ci bɩ bam. ");
INSERT INTO bib_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","A ba wɔɔ nawʊm Woso gʊɔɔ sokʊma k'a nɩ Korɛntɩ ʊ bɩ ma, gʊɔɔ kʊ Woso ŋ bɔ ʊ a hɔ Krista Yeezuu zɛkʊra nɔ ʊ rɔ wɔɔ, an ŋ bir kʊ ŋ nɩ mɩsɩrbaa mɩŋŋa ba rɔ wɔɔ, kan gʊɔɔ kʊ ŋ nɩ lɛɛ haay ʊ, ŋnɩ yaa dam wɔɔ Zuuba Yeezuu Krista m nɔ wɔɔ kɩ, Yeezuu mɩŋŋa m brɔɔ Zuuba, a m wɔɔ Zuuba sɔ. ");
INSERT INTO bib_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","A yɛ wɔɔ nawʊm kʊ wɔɔ Zɩ Woso, kan wɔɔ Zuuba Yeezuu Krista kɩ m barka kan laafɩɩ kɩ ka awɔɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Mɔɔ ɩ yaa dam Woso m barka dɔmɩm haay awɔɔ tɔ ma, barka k'a ka awɔɔ ʊ Krista Yeezuu nɔ ʊ bɩ minto. ");
INSERT INTO bib_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Bala, a tɔ ma bɩ, awɔɔ Woso ganwʊrɛrɔ do haay yɩ, an lɛ da bɩ, awɔɔ ɩ lemim, kan hɔdɔrɛ kɩ ganwʊrɛrɔ m. ");
INSERT INTO bib_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","A n ta ʊ sɔ bɩ, Krista kasɛtɩ bɩ paŋŋa yɩ awɔɔ zi, ");
INSERT INTO bib_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","bɩ n a ka *Sɛnt-Ɛspri ganwʊrɛ sɩ n jɩra awɔɔ ma y, awɔɔ k'a nɩ dɔm wɔɔ Zuuba Yeezuu Krista hɩnkarɛ dɔmɩm ma rɔ wɔɔ. ");
INSERT INTO bib_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","A mɩŋŋa n nɩ paŋŋa karɛ awɔɔ ʊ k'an ta an dɔmɩnnɔ nyarɛ ku, k'an bɩr yɩrɛ ɩ ʊ, hinni kʊ wɔɔ Zuuba Yeezuu Krista n nɩ zɛŋ ʊ bɩ, kʊ hɔsɩ minsi bɩ nyɩnta awɔɔ gʊr zi y. ");
INSERT INTO bib_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Woso k'a awɔɔ bir, k'awɔɔ m zɛkʊra yɩ kan a Nyɩ Yeezuu Krista kʊ wɔɔ Zuuba m bɩ kɩ bɩ, taalɛrazaa m. ");
INSERT INTO bib_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","M danyɩnɔ, a yɛ mɔɔ nawʊrɛ awɔɔ han, wɔɔ Zuuba Yeezuu Krista tɔ ma, k'a kʊ ma, a b'a ka gʊngʊrɛ n nyɩnta awɔɔ bire ʊ y, k'a zɛ kʊ ra a bɩr hɔɔn deem m, kan hɔɔndarɛ deem kɩ m. ");
INSERT INTO bib_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Bala, m danyɩnɔ, Kolowe gʊɔɔ a dɩnda mɔɔ m, ŋ ʊ, awɔɔ bɩr kʊ marɛ y. ");
INSERT INTO bib_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Hɔ kʊ mɔɔ ʊ kʊ m a hɩ bɩ ba n nɩ: Awɔɔ gʊaa biyəə y'a hɩrɛ a ʊ: «Pol gʊaa n mɔɔ m, naa zaa a ʊ, Apolɔs gʊaa n mɔɔ m, naa ʊ, Sefas gʊaa n mɔɔ m. Naa a ya, a ʊ, Krista gʊaa n mɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Krista a gʊngʊ ra? Pol n y'a wɔ gɔdarkʊra ma awɔɔ minto ra? Pol tɔ minto m n nɩ batɛm ka awɔɔ ʊ ra? ");
INSERT INTO bib_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Mɔɔ ɩ yaa dam Woso m barka, bala mɔɔ n batɛm ka awɔɔ gɔsɩ ʊ, kʊ Krispus kan Gayus kɩ bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Ncɩnaaʊ bɩ, awɔɔ gɔsɩ b'a dam ma an a hɩ a ʊ, mɔɔ batɛm ka a ʊ, m tɔ ra y. ");
INSERT INTO bib_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Mɔɔ batɛm ka Stefanas har gʊɔɔ ʊ sɔ, kʊ naa bɛɛ y, mɔɔ n batɛm ka gʊaa vanta ʊ m a dɔ y. ");
INSERT INTO bib_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Bala, Krista n mɔɔ nyɔɔ kʊ m bɩ batɛm ka y, mɔɔ nyɔɔ a ʊ kʊ m bɩ lemim nyɩnta pa da. Mɔɔ n yo mindɔrɛ ma m n'a pa bɩ darɛ y. A ba mɔɔ ʊ maam kʊ Krista gɔdarkʊra bɩ bɩ bɔ vam y. ");
INSERT INTO bib_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Gʊɔɔ kʊ ŋ nɩ nyaanɩm nɔ wɔɔ ɩ dɩgam lemim kʊ wɔɔ n'a pa dam, ʊ n'a hɩm, ʊ ʊ, Krista ga gɔdarkʊra ma bɩ ma hɔɔzaabaa lemim. Bɩ, kʊ wɔɔ kʊ wɔɔ bʊmbɔrɛ yɩ rɔ wɔɔ nɩ, Woso paŋŋa m gɔdarkʊra lemim bɩ m. ");
INSERT INTO bib_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Bala, n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: «Mɔɔ mindɔrɛzannɔ mindɔrɛ zaar bam, m hɔɔntaʊrɛzannɔ hɔɔn zaar ba.» ");
INSERT INTO bib_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Mindɔrɛzaa ɩ ka? Lɛrɔ karɩnsaamba ɩ ka? Her durnya naa do meerbaawaasɩzaa ɩ ka? Woso a ka durnya mindɔrɛ n a ba hɔɔzaabaa mim. ");
INSERT INTO bib_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Bala, Woso hɔɔn bɔ ʊ a mɩŋŋa mindɔrɛ nɔ ʊ, kʊ durnya b'a da ma an a dɔ durnya mindɔrɛ nɩ y, bɩ, k'a gʊɔɔ kʊ ŋ nɩ sɩra kam nɔ wɔɔ bʊmbɔ hɔɔzaabaa lemim padarɛ bɩ m. ");
INSERT INTO bib_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Zɩɩfʊrɔ wɔɔ, a ka brɔɔ n nawʊm hoserlo ma, grɛkkɩrɔ wɔɔ n'a kam mindɔrɛ ma, ");
INSERT INTO bib_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","bɩ wɔɔ, Krista kʊ n y'a wɔ gɔdarkʊra ma bɩ wɔɔ n'a pa dam, zɩɩfʊrɔ ɩ dɩgam naa ma nyannɩ, do vantɔɔ gʊɔɔ nɩ dɩgam ma hɔɔzaabaa. ");
INSERT INTO bib_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Bɩ, kʊ gʊɔɔ kʊ Woso ŋ bir lɔ wɔɔ nɩ, kʊ zɩɩfʊrɔ m, gɛɛ grɛkkɩrɔ nɩ, Krista kʊ wɔɔ n'a pa dam b'ɩ yɩrɛ ɩ ʊ, Woso paŋŋa m, bɩ Woso mindɔrɛ m sɔ. ");
INSERT INTO bib_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Bala, hɔ k'a bɔ kʊ ʊ, ɩ ʊ, Woso hɔɔzaabaa m bɩ, hɔ bɩ do hɔɔntaʊrɛ lɛ da gʊɔɔ mindɔrɛ m, sɔ bɩ, hɔ k'a bɔ kʊ ʊ, ɩ ʊ, Woso paŋŋawar m bɩ, a paŋŋa lɛ da gʊɔɔ paŋŋa m. ");
INSERT INTO bib_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","M danyɩnɔ, k'a dɩga a mɩŋŋɔɔ ma mɩŋŋa k'a dɔ a ʊ, awɔɔ kʊ Woso a bir lɔ wɔɔ, awɔɔ barla, gʊɔɔ ba ʊ gʊta ŋnɩ mindɔrɛzannɔ durnya mɩm ʊ y, ŋnɩ paŋŋazannɔ sɔ y, ŋnɩ har wɩsɩ gʊɔɔ y. ");
INSERT INTO bib_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Bɩ, hɔ kʊ hɔɔzaabaa m durnya ʊ bɩ, Woso bɩ sa, k'a nyannɩ da mindɔrɛzannɔ ma, hɔ kʊ paŋŋawar m durnya nɔ ʊ bɩ, Woso bɩ sa, k'a nyannɩ da hɔ k'a nɩ paŋŋa m bɩ ma. ");
INSERT INTO bib_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Hɔ k'a bɩ zore an yaarsɩ durnya ʊ bɩ, hɔ k'a nyɔɔdʊ ba ʊ bɩ, Woso hɔ bɩ do sa, k'a nyaam hɔ kʊ gʊɔɔ nɩ dɩgam ma hɔ bɩ m, ");
INSERT INTO bib_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","kʊ gɔsɩ b'a da ma an a mɩŋŋa busu Woso lɛɛ y. ");
INSERT INTO bib_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Woso mɩŋŋa tɔ ma m, awɔɔ m zɛkʊra yɩ kan Krista Yeezuu kɩ, a mɩŋŋa y'a ba wɔɔ mindɔrɛ k'a a to Woso zi, a ɩ wɔɔ ba tɩrga Woso mɩm ʊ, an n'a kam wɔɔ nɩ mɩsɩrbaa bam Woso tɔ ma, an nɩ wɔɔ bʊmbɔm mimbʊnyaa nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Kʊ hɔ kʊ n y'a gʊrsɩra ba Wosoci b'ʊ bɩ n kʊ yɩ, n ʊ: «Gʊaa k'a ʊ, k'a lɛ bɔ a mɩŋŋa ʊ, a b'a lɛ bɔ a mɩŋŋa ʊ y, an a lɛ bɔ hɔ kʊ Zuuba a ba b'ʊ. ");
INSERT INTO bib_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","M danyɩnɔ, bʊr kʊ mɔɔ ʊ awɔɔ zi bɩ, mɔɔ n bʊr lɛmindɔrɛ m gɛɛ mindɔrɛ m kʊ m bɩ Woso kasɛtɩ bɩ ka awɔɔ ʊ y. ");
INSERT INTO bib_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Bala, mɔɔ hɔɔn bɔ ʊ, kʊ m bɩ hɔsɩ mim dɩnda awɔɔ zi b'ʊ, kʊ Yeezuu Krista mim bɛɛ y, an lɛ da bɩ a wɔ kʊ n y'a ʊ gɔdarkʊra ma bɩ mim m. ");
INSERT INTO bib_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Ncɩnaaʊ nɩ, mɔɔ n nyɩnta awɔɔ bire ʊ, paŋŋawar nɔ ʊ, dabɔʊ nɔ ʊ, kan mɛhinkəre kɩ. ");
INSERT INTO bib_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Mɔɔ meerbaa kan mɔɔ pa bɩ darɛ kɩ n nyɩnta lɛmindɔrɛ meerbaa nɔ ʊ y, bɩ nyɩnta ʊ Sɛnt-Ɛspri paŋŋa zibəə hɩnkarɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Nyɩnta a ʊ ncɩnaaʊ k'awɔɔ sɩrakarɛ bɩ bɩ yo gʊɔɔ mindɔrɛ ma y, bɩ k'an yo Woso paŋŋa ma. ");
INSERT INTO bib_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","A n bɔkarɛ, mindɔrɛ paan… wɔɔ n'a dɩndam kristagʊɔɔ kʊ ŋ sɩrakarɛ yaa ka rɔ wɔɔ m. Mindɔrɛ naa do n a to durnya naa do nɔ ʊ, b'a n a to durnya paŋŋazannɔ kʊ ŋ nɩ b'a zaar bam nɔ wɔɔ zi y. ");
INSERT INTO bib_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Woso mindɔrɛ wɔɔ n'a dɩndam, hɔ k'a n dɔ biisi m, n n a nyaakʊm da, Woso mɩŋŋa ɩ nyɩnta an a cɩnta, bɩ ma bɩ durnya ba ʊ y, kʊ wɔɔ n bɩ nyɩnta a lɛbɔʊrɛ nɔ ʊ. ");
INSERT INTO bib_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Durnya naa do paŋŋazannɔ gɔsɩ n nyɩnta an a dɔ y, bala, k'a dɔ ŋ y'a ʊ, ŋ bɩ Zuuba k'a a so lɛbɔʊrɛ ʊ bɩ wɔm gɔdarkʊra ma y. ");
INSERT INTO bib_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Bɩ, amba n y'a gʊrsɩra ba Wosoci ʊ, n ʊ: «Hɔ kʊ gʊaa mɩm n a yɩ cɩna y, a tʊr n a ma cɩna y, hɔ kʊ gʊaa n a hɔɔn da ma cɩna y, hɔ bɩ do haay Woso a cɩnta gʊɔɔ kʊ ŋ n'a ŋʊam nɔ wɔɔ m.» ");
INSERT INTO bib_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Denter m, wɔɔ, Woso hɔ bɩ do hɩnka wɔɔ m Sɛnt-Ɛspri nɔ ʊ. Bala, Sɛnt-Ɛspri ɩ hɔ haay taa zɛm, baa hɔ kʊ Woso a nyaakʊm da paan… haay, a y'a taa zɛm sɔ. ");
INSERT INTO bib_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Nka m nɩ gʊɔɔ barla, an gʊɔɔ mim dɔ? K'a maam, hɔɔn k'a nɩ kan kɩ bɩ m. Maam sɔ bɩ, hɔ k'a nɩ Woso gʊr zi bɩ, gɔsɩ b'a dam ma an a dɔ kʊ Woso Ɛspri bɛɛ y. ");
INSERT INTO bib_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Kʊ wɔɔ nɩ, wɔɔ n durnya ɛspri yɩ y, bɩ, Woso Ɛspri wɔɔ yɩ, kʊ wɔɔ n'ʊ da ma ʊ Woso barka ganwʊrɛrɔ wɔɔ dɔ. ");
INSERT INTO bib_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Bɩ, kʊ wɔɔ yɩ ŋ mim dɩndam, wɔɔ bɩr a dɩndam gʊaa mindɔrɛ nɩ y, bɩ, a dɩnda wɔɔ nawʊm Sɛnt-Ɛspri mindɔrɛ m, ʊ nɩ Woso hɔɔ jɩ dɩndam, Sɛnt-Ɛspri hɔdɩndarɛ m. ");
INSERT INTO bib_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Gʊaa k'a nɩ mɛsim hɔɔn m bala bɩ, a bɩr yɛm hɔ k'a a to Woso Ɛspri zi bɩ ma y. Hɔɔzaabaa m kan kɩ, a b'a dam ma an a jɩ ma y, bala, Woso Ɛspri n'a dam ma an a ka gʊaa n a dɔ. ");
INSERT INTO bib_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Bɩ gʊaa k'a nɩ Woso Ɛspri m bɩ, a ɩ hɔ haay dʊdɔ kam bɩ gɔsɩ b'a dʊdɔ karɛ y. ");
INSERT INTO bib_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Bala, n y'a da Wosoci ʊ, n ʊ: «Nka ɩ Woso hɔɔndarɛ dɔ, k'a hɔ dɩnda nɩ?» A n bɔkarɛ, wɔɔ, Krista hɔɔndarɛ wɔɔ n ta m. ");
INSERT INTO bib_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","M danyɩnɔ, kʊ mɔɔ nɩ, mɔɔ n wɔ ʊ m meer ba kan awɔɔ kɩ am