﻿USE sofia;
DROP TABLE IF EXISTS sofia.bhu_vpl;
CREATE TABLE bhu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bhu_vpl WRITE;
INSERT INTO bhu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","अब्राहम कर पुरखा, दाऊद कर पुरखा यीसु मसीह कर पुरखा हइ मेर हबै। ");
INSERT INTO bhu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहम कर टोरवा इसहाक रथै अउ इसहाक कर टोरवा याकूब होथै, फेर याकूब लग यहूदा अउ ओखर भाई पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदा कर टोरवा रथै पेरेस अउ जोरह उनखर दाय कर नाम तामार रथै, पेरेस, हेस्रोन कर बाफ रथै, हेस्रोन एराम कर बाफ रथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","एराम अम्मीनादाब कर बाफ रथै, अम्मीनादाब लग नहसोन अउ नहसोन लग सलमोन पइदा हुइस। ");
INSERT INTO bhu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सलमोन लग बोवज पइदा होथै, बोवज कर दाय कर नाम राहाब रथै, बोवज अउ रूत लग ओबेद पइदा होथै अउ ओबेद इसै कर बाफ रथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","अउ इसै लग दाऊद राजा पइदा होथै, उरिय्याह कर बिधवा डउकी दवारा दाऊद लग सुलेमान पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सुलेमान लग रहबाम पइदा होथै, रहबाम कर लरका अबिय्याह लग आसा पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","अउ आसा यहोसाफात कर बाफ रथै, यहोसाफात लग योराम पइदा होथै अउ योराम लग उज्जियाह पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्जियाह योताम कर बाफ रथै, अउ योताम लग आहाज पइदा होथै, आहाज लग हिजकिय्याह पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हिजकिय्याह लग मनस्सिह पइदा होथै, मनस्सिह आमोन कर बाफ रथै। अउ आमोन लग योसिय्याह पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","अउ इस्राएल कर मनसेन कर गुलाम बनाय के बेबीलोन लइ जात टेम योसिय्याह लग यकुन्याह अउ ओखर भाई पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बेबीलोन हे लइ जाय के बाद यकुन्याह कर सालतीयल कर बाफ बनथै अउ फेर सालतीयल लग जरूब्बाबिल पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","जरूब्बाबिल लग अबीहूद पइदा होथै अउ अबीहूद लग इल्याकीम अउ इल्याकीम लग अजोर पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अजोर सदोक कर बाफ रथै, सदोक लग अखीम अउ अखीम लग इलीहूद पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","इलीहूद इलियाजार कर बाफ रथै अउ इलियाजार लग मत्तान अउ मत्तान लग याकूब पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","अउ याकूब लग यूसुफ पइदा होथै, जउन मरियम कर डउका रथै, मरियम लग यीसु पइदा होथै, जउन मसीह कहाथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","इहैमेर अब्राहम लग दाऊद तक चउदाठे पुरखा होथै अउ दाऊद लग लइके गुलाम बनाय के, बेबीलोन पहुंचाय जाय तक के चउदह पुरखा होथै अउ गुलाम बनाय के बाबुल पहुंचाय जाय तक मसीह कर पइदा तक चउदह पुरखा हुइस। ");
INSERT INTO bhu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","यीसु मसीह कर पइदा हइ मेर होथै, जब ओखर दाय मरियम कर ओली फलदान यूसुफ कर संग होथै, पय असना होथै कि काज होय लग पहिलेन मरियम पवितर आतमा कर दवारा देह हे हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","यूसुफ धरमी मनसे होय के कारन मरियम कर बेज्जती नेहको करै के चाहथै, पय ओही लुके छुपे उतरवामै के बिचार करथै, ");
INSERT INTO bhu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","जब यूसुफ हइ बातन के बारे हे सोचथै बिचारथै, ता उके सपना हे परभु कर स्वरगदूत आय के कथै, हे यूसुफ दाऊद कर टोरवा, अपन डउकी मरियम के अपन घर छो लाने लग झइ डर काखे जउन ओखर देह हे हबै, ऊ पवितर आतमा के दवारा हबै। ");
INSERT INTO bhu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ऊ अक्ठी टोरवा पइदा करही, तै ओखर नाम यीसु धरबे काखे ऊ अपन मनसेन कर उनखर पापन लग मुकति करही। ");
INSERT INTO bhu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","हइ सगलू इहैनिता हुइस, कि भगवान कर संदेस जउन बचन परभु ग्यानी मनसे के दवारा कहे रथै, ऊ पूर होय। ");
INSERT INTO bhu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“देखा, अक्ठी कुमारी देह हे होही अउ अक्ठी टोरवा के पइदा करही। अउ ओखर नाम इम्मानुएल रखे जही,” जेखर मतलब हबै “भगवान हमर संग हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","जब यूसुफ नींद लग जागथै, ता परभु के स्वरगदूत कर आदेस के जसना ऊ मरियम लग काज कर लेथै अउ ऊ अपन घर हे लइ आनथै। ");
INSERT INTO bhu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","अउ जब तक मरियम टोरवा के पइदा नेहको करिस, तब तक यूसुफ ओखर लिघ्घो नेहको गइस अउ यूसुफ ओखर नाम यीसु धरथै। ");
INSERT INTO bhu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","यीसु के जनम यहूदिया परदेस बैतलहम सहर हे हुइस, ऊ टेम हेरोदेस राजा रथै, यीसु कर जनम के बाद वैदी मनसे पूरब देस लग यरुसलेम सहर छो आय रथै। ");
INSERT INTO bhu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","यहूदिन के राजा जेखर पइदा होय हबै ऊ कछो हबै? काखे हम दिन उगती छो ओखर तरइया देखे हबन अउ ओहि हम निहुर के परनाम करै आय हबन। ");
INSERT INTO bhu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","जब हेरोदेस राजा हइ बात सुनथै, ता ऊ बोहत घबडा जथै अउ यरुसलेम कर मनसेन चिन्ता हे पड जथै। ");
INSERT INTO bhu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","तब राजा यहूदी समाज के खास पुजारी अउ गुरुन के अकजुट करके पूछथै, मसीह कर पइदा कछो हुइ सकथै? ");
INSERT INTO bhu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","उन मनसे राजा लग कथै, “यहूदिया कर बैतलहम हे काखे ग्यानी मनसे कर किताब हे ओसनेन लिखररे गय हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","हे बैतलहम, जउन यहूदा के परदेस हे हबै, तुम कउनो मेर लग यहूदा के अधिकारी सहर मसे नान नेहको हवस, काखे तुम्हर लग अक्ठी राजा निकडही, जउन मोर मनसे इस्राएल कर बरेदी होही। ");
INSERT INTO bhu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","तब हेरोदेस ज्योतिसिन के चुपके लग बुलवाय के पूछथै, तरइया ठीक कउन टेम दिखाई दय रहिस? ");
INSERT INTO bhu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","राजा ज्योतिसिन लग हइ कहिके बैतलहम पठोथै “कि जायके ऊ लरका कर बारे हे ठीक-ठीक पता लगामै, जब मिल जही ता मोके गुठेइहा, ता महुं ओखर परनाम करहुं।” ");
INSERT INTO bhu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","उन राजा कर बात के सुनके उछो लग कढ जथै, अउ जउन तरइया दिन उगती छो देखे रथै, ऊ उनखर आगू-आगू चलै लागथै अउ जउन जिघा हे लरका रथै, ऊ जिघा के उप्पर जाय के रुक गइस। ");
INSERT INTO bhu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","उन तरइया के देखके बोहत मगन होथै। ");
INSERT INTO bhu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","उन घर के भित्तर जाय के बाद हे, वैदी यीसु के ओखर दाय मरियम के संग देखथै, उन मुंह के बल गिरके ओही निहुर के परनाम करथै अउ अपन-अपन थइली खोलके उके सोना अउ लोबान अउ गन्धरस के बलि चढाथै। ");
INSERT INTO bhu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","तब उनही सपना हे भगवान वैदिन के चेतन्त कर देथै, कि हेरोदेस के लिघ्घो लउट के झइ जइहा, ता उन दूसर गली लग अपन देस छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","वैदिन के जाय के बाद परभु कर अक्ठी स्वरगदूत सपना हे आय के यूसुफ लग कथै “उठ जा अउ लरका के अउ ओखर दाय के लइके मिस्र देस छो कढ जा, जब तक मै तुमही नेहको कइहों, तब तक उहै छो रहबे, काखे, हेरोदेस हइ लरका के मारै के डांटथै।” ");
INSERT INTO bhu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","यूसुफ उठिस अउ लरका अउ ओखर दाय के लइके रातो रात मिस्र देस छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","अउ हेरोदेस राजा के मरै तक उहै छो रथै, ता ऊ बचन जउन परभु ग्यानी मनसेन के दवारा कहै रथै, कि मै अपन टोरवा कर मिस्र देस लग बाहिर बुलवइहो, ऊ बात पूर हुइ सकै। ");
INSERT INTO bhu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","जब हेरोदेस हइ देखथै, कि ज्योतिसी मोके नरे हबै, ता ऊ गुस्सा लग भर जथै अउ सिपाही के पठोय के ज्योतिसी दवारा ठीक-ठीक बताय हर बात के जसना, बैतलहम अउ ओखर अगल बगल जिघा के सगलू लरका के दुइ साल के या ओखर लग नान रथै, सबझन के मरवा डारथै। ");
INSERT INTO bhu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","तब जउन बचन इरमियाह ग्यानी मनसे के दवारा कहे रथै, ऊ बात पूर हुइस। ");
INSERT INTO bhu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामाह सहर हे दुख भरे अक्ठी आरो सुने गइस, आरो रोमै के, गहिरा बिलाप के रथै, राहेल अपन लरकन के निता रोथै, चाहथै नेहको कि कउ उके धीर धरे, काखे ओखर सगलू लरका मर चुके रथै।” ");
INSERT INTO bhu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","हेरोदेस राजा के मरै के बाद परभु कर स्वरगदूत मिस्र हे यूसुफ के सपना दइके कथै, ");
INSERT INTO bhu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“उठ, लरका अउ ओखर दाय के लइके इस्राएल देस छो कढ जा, काखे जउन लरका के मारै चाहथै ऊ मर गय हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","यूसुफ उठिस अउ लरका अउ ओखर दाय के लइके इस्राएल देस छो लउट अइस। ");
INSERT INTO bhu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","पय जब यूसुफ हइ सुनथै, कि अरखिलाउस अपन बाफ हेरोदेस के जिघा यहूदिया परदेस हे राज करथै, ता ऊ उछो जाय लग डरथै, फेर भगवान लग आदेस पाय के ऊ गलील परदेस छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","अउ नासरत नाम के सहर छो जायके बस जथै, ताकि ऊ बचन पूर होय जउन ग्यानी मनसेन के दवारा गुठेय गय रथै, “ऊ नासरी कहाही।” ");
INSERT INTO bhu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","उन दिनन हे यूहन्ना पानी हे बतिस्मा देय बाले यहूदिया परदेस कर पटउरा हे आय के, अउ हइ परचार करथै। ");
INSERT INTO bhu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","पाप लग मन बदला, काखे स्वरग कर राज लिघ्घो हबै। ");
INSERT INTO bhu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","यूहन्ना उहै मनसे रथै जेखर बारे हे यसायाह ग्यानी मनसे के दवारा कहे रथै, “कि पटउरा छो गोहराय बाले के आरो हबै, परभु के निता रास्ता तइयार करा अउ ओखर गली सिध्धा करा।” ");
INSERT INTO bhu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","यूहन्ना उंटवा कर चूंदी के बन्डी ओढे रथै अउ कनिहा हे खलरी कर पट्टी बांधे रथै अउ ऊ चिड्डा अउ पतेरा कर मोहरस खाय करथै। ");
INSERT INTO bhu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","यरुसलेम सहर के सगलू यहूदिया परदेस के मनसे अउ यरदन नदिया के अगल बगल के इलाका लग यूहन्ना के लिघ्घो आमै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","उन अपन-अपन पापन के मानके, यरदन नदिया हे यूहन्ना लग बतिस्मा लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","जब ऊ देखथै कि बोहत लग फरीसी अउ सदुकिया बतिस्मा लेय के निता अउत हबै, ता ऊ उनखर लग कथै, “हे सपुवा कर टोरवा तुमही कोहर गुठे दय हबै, कि तुम परभु कर सजा लग बच जइहा?” ");
INSERT INTO bhu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","असना काम करा कि जेखर लग दिखाई दे कि तै अपन पाप लग मन बदलै के योग फडुहा लाबा। ");
INSERT INTO bhu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","अउ अपन मन हे हइ झइ सोचा कि हम अब्राहम कर टोरवा हबन, मै तुम्हर लग कथो, भगवान हइ पथरा लग अब्राहम कर निता, लरका पइदा कर सकथै। ");
INSERT INTO bhu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","अब रूख के जर हे टंगिया लग चुके हबै, जउन रूख निक्खा फडुहा नेहको देथै, ऊ काटे जही अउ आगी हे झपोय जही। ");
INSERT INTO bhu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","मै तुमके मन बदलै के पानी हे बतिस्मा देथो, पय जउन मोर बाद हे आमै बाले हबै, ऊ मोर लग बोहत बलवान हबै, मै ओखर बूट उठामै के लायक नेहको हबो अउ ऊ तुमके पवितर आतमा अउ आगी लग बतिस्मा देही। ");
INSERT INTO bhu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ओखर सूपा ओखर हाथ हे हबै, ऊ अपन खनेड निक्खा साफ करही, ऊ अपन गोहूं कर कोठला हे अकजुट करही, पय भूसा के ऊ आगी हे झपोही, जउन कबहुन नेहको भुताही। ");
INSERT INTO bhu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ऊ टेम यीसु गलील नगर लग यरदन नदिया कर पाखा हे यूहन्ना लग बतिस्मा लेय के निता आथै। ");
INSERT INTO bhu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","पय यूहन्ना ओही मना करत कथै, मोके तोर हाथ लग पानी हे बतिस्मा लेय के जरूरत हबै, अउ तै मोर हाथ लग पानी हे बतिस्मा लेय का चाहथस? ");
INSERT INTO bhu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","यीसु जबाब देथै, अब ओसनेन होमै दे काखे हमके इहैमेर करै के सब नियाइपन के पूर करै के जरूरी हबै, ता ऊ ओखर बात के मान लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","यीसु पानी हे बतिस्मा लेय के बाद हे, जसनेन पानी लग बाहिर आथै, ओखर निता बादर उघर जथै अउ ऊ भगवान कर आतमा परेवा के जसना, अपन उप्पर आउत देखथै। ");
INSERT INTO bhu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","अउ स्वरग लग आरो आथै, हइ मोर पिरिया टोरवा हबै, एखर लग मै बोहत मगन हबो। ");
INSERT INTO bhu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","पवितर आतमा यीसु के पतेरा छो लइ जथै, ता भुतवा के दवारा ओखर परिक्छा होय। ");
INSERT INTO bhu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","यीसु चालीस रोज अउ चालीस रात उपास करथै, एखर बाद हे उके भूख लागथै। ");
INSERT INTO bhu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","तब परखै बाले यीसु के लिघ्घो आय के कथै, “अगर तै भगवान कर टोरवा हबस, ता कहि दे कि हइ पथरा रोटी बन जाय।” ");
INSERT INTO bhu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","यीसु उके जबाब देथै, “पवितर किताब हे लिखवरे हबै, कि मनसे केबल रोटी खाय लग नेहको, पय ऊ सब बात लग जिन्दा रही जउन भगवान कर मुंह लग निकडथै।” ");
INSERT INTO bhu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","तब भुतवा यीसु के पवितर सहर यरुसलेम हे लइ जथै, अउ उके बिनती भवन के चुट्ठी हे लइ जायके कथै। ");
INSERT INTO bhu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","अगर तै भगवान कर टोरवा हबस, ता खुद के तरी छो गिराय दे, काखे तोर बारे हे असना लिखररे हबै, कि ऊ अपन स्वरगदूत के आदेस देही, अउ तोके हाथो हाथ हे उठाय लेही, कहुं असना झइ होय कि तोर गोड हे पीरा होय। ");
INSERT INTO bhu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","यीसु ओखर लग कथै, इहो लिखररे हबै, कि तै परभु भगवान कर परिक्छा झइ कर। ");
INSERT INTO bhu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","फेरै भुतवा ओही अक्ठी बोहत डोंगर कर चुट्ठी हे लइ जायके सगलू दुनिया कर राज अउ उनखर महिमा दिखाइस। ");
INSERT INTO bhu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","भुतवा यीसु लग कथै, “अगर तै गिरके मोके निहुर के परनाम करबे, ता मै हइ सगलू कुछ तोके दइ देहुं।” ");
INSERT INTO bhu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","यीसु जबाब देथै, हे भुतवा इछो लग दुरिहां कढ जा, काखे पवितर किताब हे लिखवरे हबै, अपन परभु भगवान के परनाम कर अउ उहै के सेबा अउ उपास कर। ");
INSERT INTO bhu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","तब भुतवा उछो लग कढ जथै अउ स्वरगदूत आय के यीसु कर सेबा करै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","यीसु हइ सुनिस कि यूहन्ना के जेल हे बेड दइन, ता ऊ गलील इलाका छो कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ऊ नासरत सहर छांड के कफरनहूम सहर हे रहै लगिस, हइ सहर जबूलून अउ नप्ताली परदेस हे हबै। ");
INSERT INTO bhu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","जउन मेर यसायाह ग्यानी मनसे के दवारा कहे रथै, ऊ बात पूर हुइस। ");
INSERT INTO bhu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","जबूलून अउ नप्ताली के देस दहार के टाठा हे, यरदन नदिया के ऊ पार गैर यहूदी के गलील। ");
INSERT INTO bhu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","उन जउन अंधियार हे निबास करै बाले हबै, अक्ठी तेज उजियार के दरसन करिस, उन मनसे जउन असना जिघा हे निबास करथै, जेखर उप्पर मिरतू छाया हबै, उजियार हुइस। ");
INSERT INTO bhu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ऊ टेम लग यीसु परचार करै के अउ हइ संदेस सुनामै लगिस, पाप लग मन बदला काखे स्वरग कर राज लिघ्घो आय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","यीसु गलील कर दहार कर पाखा हे घूमत रथै, ऊ दुइठे भाई के देखथै समोन जउन पतरस कहाथै, अउ ओखर भाई अन्द्रियास के, जउन जाला लगाउत देखथै, काखे उन ढिमरा रथै। ");
INSERT INTO bhu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","यीसु उनखर लग कथै, “मोर पाछू आबा मै तुमही मनसे के दिलन के पकडै बाले बनाहुं।” ");
INSERT INTO bhu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","उन हरबी जाला के छांड के ओखर पाछू आ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","फेर यीसु उछो लग आगू बढथै, ता दुइठे भाई याकूब अउ ओखर भाई यूहन्ना के, उन अपन बाफ जबदी के संग नाह जिहाज हे जाला के निरवारथै, यीसु उनही बलाथै। ");
INSERT INTO bhu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","उन हरबी नाह जिहाज अउ अपन बाफ के छांड के ओखर संग आ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","यीसु सगलू गलील इलाका हे उनखर बीच यहूदी मंडली हे स्वरग के राज कर संदेस के बारे हे परचार करथै, अउ हर मेर के नंगहन अउ ढिलवन के निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","अउ सगलू सीरिया देस हे यीसु कर नाम बगर जथै, नंगहा मनसे, भुतवन लग परेसान, मिरगी अउ लकवा बालेन के ओखर लिघ्घो लानथै, यीसु उनही निक्खा कर देथै। ");
INSERT INTO bhu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","इहैनिता गलील अउ दिकापुलिस मतलब दस सहर के परदेस, यरुसलेम, यहूदिया, अउ यरदन नदिया के ऊ पार के मनसे झुन्ड के झुन्ड ओखर पाछू चलथै। ");
INSERT INTO bhu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","यीसु भीड के देखके डोंगर छो चढ जथै, अउ उछो बइठ गइस ता ओखर चेला ओखर लिघ्घो आथै। ");
INSERT INTO bhu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","अउ ऊ उनही हइ सिक्छा देय लागथै। ");
INSERT INTO bhu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","धन्य हबै ऊ जउन मन के दीन हबै, काखे स्वरग कर राज उनखर निता हबै। ");
INSERT INTO bhu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","धन्य हबै ऊ जउन सोक करथै, काखे उनके सान्ति मिलही। ");
INSERT INTO bhu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","धन्य हबै ऊ जउन नम्र हबै, काखे ऊ भुंइ के अधिकारी हुइहिन। ");
INSERT INTO bhu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","धन्य हबै ऊ जउन नियाइपन के भूखे अउ पियासे हबै, काखे ऊ भरपूर करे जही। ");
INSERT INTO bhu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","धन्य हबै ऊ जउन दया करथै, काखे ओखरो उप्पर दया करे जही। ");
INSERT INTO bhu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","धन्य हबै ऊ जेखर मन सुध्द हबै, काखे ऊ भगवान के देखही। ");
INSERT INTO bhu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","धन्य हबै ऊ जउन मेल जोल करवाथै, काखे ऊ भगवान कर टोरवा कहाही। ");
INSERT INTO bhu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","धन्य हबै ऊ जउन नियाइपन के कारन सताय जही, काखे स्वरग कर राज उनखरै हबै। ");
INSERT INTO bhu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","धन्य हबै तुम, जब मनसे मोर चेला होय के कारन तुम्हर बेज्जती करही, तुमके तंग करही अउ कइनमेर के झूठ दोस लगइहिन। ");
INSERT INTO bhu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","हसा अउ मगन हुइहा, काखे तुम्हर निता स्वरग हे बोहत बडा इनाम हबै, तुम्हर पहिले ग्यानी मनसेन के उनही इहैमेर तंग करे रहिन। ");
INSERT INTO bhu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","तुम हइ भुंइ के नून हबा, अगर ओखर सोद बेकार हुइ जाय, ता ऊ कउन चीज लग नमकीन बनाय जाय सकथै? ता ऊ कउनो काम के नेहको हबै, सिबाय उके बाहिर फटके जथै अउ मनसेन के गोड लग कचरे जथै। ");
INSERT INTO bhu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","तुम दुनिया के उजेड हबा, जउन सहर डोंगर हे बसे हर हबै, ऊ लुक नेहको सकै। ");
INSERT INTO bhu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","मनसे चिमनी जलाय के खटिया कर तरी नेहको, पय पिरभिटिया हे मडाथै, ता ऊ घर के सगलू झन के उजेड मिलै। ");
INSERT INTO bhu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","इहैमेर तुम्हर उजेड मनसेन कर आगू चमकै, जेही उन तुम्हर निक्खा काम के देखके स्वरग के बाफ कर महिमा करै। ");
INSERT INTO bhu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“हइ झइ सोचा कि मूसा कर नियम के किताब अउ ग्यानी मनसे के किताब के नास करै नेहको, बलुक उके पूर करै आय हव।” ");
INSERT INTO bhu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","मै तुम्हर लग सही कथो, जब तक बादर अउ भुंइ समापत नेहको हुइ जथै, तब तक मूसा कर नियम के किताब अक-अक्ठी बात अउ अक-अक्ठी सब्द रही, ऊ तब तक बने रही, तब तक ऊ पूर नेहको जही। ");
INSERT INTO bhu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","इहैनिता जउन कउ हइ नान लग नान आदेस मसे कउनो अक्ठी बात के नेहको मानही, अउ ओसनेन मनसेन के सिखामै, ऊ स्वरग कर राज हे नान कहाही, पय जउन उन आदेस के मानही अउ उनही सिखाही उहै स्वरग के राज हे बडा कहाही। ");
INSERT INTO bhu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","काखे मै तुम्हर लग कथो, अगर तुम्हर नियाइपन गुरू अउ फरीसी मनसे नियाइपन लग बडके नेहको हबै, ता तोके भगवान के स्वरग के राज हे घुसै के नेहको मिलही। ");
INSERT INTO bhu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","तुम सुन चुके हबा, सियान मनसेन लग कथै, कि खून झइ करबे, अगर जउन कउ खून करही ऊ अदालत हे सजा के लायक होही। ");
INSERT INTO bhu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","पय मै तुम्हर लग हइ कथो, कि कउ अपन भाई या बेहन लग गुस्सा करही, ऊ स्वरग के अदालत हे सजा के लायक होही, जउन कउ अपन भाई के बेकार कहि, ऊ स्वरग के अदालत के सजा के लायक होही, जउन कउनो के मूरुख कहि, ऊ नरक के आगी के लायक होही। ");
INSERT INTO bhu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","इहैनिता अगर तै बेदी हे अपन बलि चढाथस अउ उहां हइ सुरता आ जाय कि तोर भाई के मन हे तोर निता कुछ बुराई हबै, ");
INSERT INTO bhu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ता अपन बलि उहै बेदी के आगू छांड दे अउ जाय के पहिले अपन भाई लग मेल जोल कर ले अउ तब आय के अपन बलि चढा। ");
INSERT INTO bhu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","तोर बैरी तोके अदालत हे लइ जात टेम जब रास्ता हे होय, ता तै ओही हरबी अपन संगी बनाय ले, कहुं असना झइ होय कि तोके नियाव करै बाले के हाथ हे सउप दे अउ नियाव करै बाले सिपाही के जउन तोके जेल हे डाल देही। ");
INSERT INTO bhu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","मै तुम्हर लग सही कथो, तै जेल लग तब तक नेहको छुटबे जब तक तै पाई-पाई नेहको चुका पइहे। ");
INSERT INTO bhu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","तुम जानथा कि हइ कहे गय रथै, गलत काम झइ करा। ");
INSERT INTO bhu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","पय मै तुम्हर लग हइ कथो, कि जउन कउ डउकी के बुरी नजर लग देखथै, ऊ अपन मन हे ओखर लग गलत काम कर चुकिस। ");
INSERT INTO bhu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","अगर तोर खउनी आंखी तोर लग पाप करवावै ता उके निकाडके फटक दे, काखे तोर निता इहै निक्खा हबै, कि तोर देह लग अक्ठी अंग बेकार हुइ जाय अउ तोर देह नरक हे झइ डाले जाय। ");
INSERT INTO bhu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","अगर तोर खउनी हाथ तोके पाप करवावै ता उके खपलके फटक दे, कि तोर निता फायदा इहै हे हबै, कि तोर देह मसे अक्ठी बेकार हुइ जाय अउ तोर सगलू देह नरक हे झइ डाले जाय। ");
INSERT INTO bhu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","इहो लिखररे हबै, जउन कउ अपन डउकी लग छोड छुट्टी चाहथै, ता उके छोड छुट्टी दे। ");
INSERT INTO bhu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","पय मै तुम्हर लग हइ कथो, जउन कउ अपन डउकी के गलत काम के सिबाय कउनो अउ कारन लग छोडथै, ता ऊ ओखर लग गलत काम करवाथै अउ जउन कउ ऊ छांडे हर डउकी लग काज करथै, ऊ गलत काम करथै। ");
INSERT INTO bhu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","तुम हइ सुन चुके हबा, कि सियानन लग कहे गय रथै, झूठी किरिया झइ खाबे, पय परभु के आगू खाय हर किरिया के पूर करबे। ");
INSERT INTO bhu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","पय मै तुम्हर लग हइ कथो, कि कबहुन किरिया झइ खाबे, न स्वरग के, काखे ऊ भगवान कर राजगद्दी हबै, ");
INSERT INTO bhu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","न भुंइ के काखे ऊ ओखर गोड के चउकी हबै, न यरुसलेम के काखे ऊ महाराजा के सहर हबै। ");
INSERT INTO bhu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","अउ न अपन मूड के किरिया खइहा, काखे तै अकोठे चूंदी के चरका अउ न करिया कर सकथस। ");
INSERT INTO bhu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","अगर तुम्हर बात हां के हां होय अउ न के न होय, काखे एखर लग बोहत होथै, ऊ बुराई लग पइदा हुइस। ");
INSERT INTO bhu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","तुम हइ सुन चुके हबा, कि आंखी के बदला आंखी अउ दांत के बदला दांत। ");
INSERT INTO bhu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","पय तुम्हर लग कथो, कउनो बुरे मनसे के बदला झइ लेबे। बलुक अगर कउ तुम्हर दहिना गाल हे झापड मारे, ता अपन टेटरा गाल के ओखर पल्ला के देबे। ");
INSERT INTO bhu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","अगर कउ केस लडके तोर खुरथा पइजामा के लेय चाहथै, ता ओही अपन खुरथा पइजामा दइ दे। ");
INSERT INTO bhu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","जउन कउ तोके बगैर मजदूरी हे अक्ठी कोस लइ जाय चाहथै, ता ओखर संग दुइ कोस जाय के निता तइयार रहबे। ");
INSERT INTO bhu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","अगर जउन कउ तुम्हर लग मांगै, ता उके दइ देबे, अउ जउन तुम्हर लग उधार लेय के चाहथै, ता उके मना झइ करबे। ");
INSERT INTO bhu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“तुम सुन चुके हबा कि कहे गय हबै कि अपन परोसी लग माया कर अउ बैरी लग बैर कर।” ");
INSERT INTO bhu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","पय मै तुम्हर लग इहो कथो, कि अपन बैरी लग माया कर अउ सताय बाले के निता बिनती कर। ");
INSERT INTO bhu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","असना करै लग अपन स्वरग कर बाफ कर टोरवा-टोरिया ठहरिहा, काखे ऊ निक्खा अउ बेकार दोनोन हे अपन बेरा निकारथै अउ धरमी अउ पापी दोनोन हे पानी बरसाथै। ");
INSERT INTO bhu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","काखे अगर तै अपन माया करै बाले लग माया कर, ता तोके काहिन इनाम मिलही? का असना पइसा उगाहै बाले असना नेहको करथै? ");
INSERT INTO bhu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","अगर तै सिबाय अपन भाई के सोगत करथस, ता कउन बडा काम करथस? का गैर यहूदी मनसे असना नेहको करथै? ");
INSERT INTO bhu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","इहैनिता जरूरी हबै, कि तुम दया करै बाले बना, जसना तुम्हर स्वरग कर बाफ दया बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","सचेत रहा, भगवान चाहथै कि उन काम के मनसेन के आगू देखामै के निता झइ करा, नहि ता अपन भगवान बाफ लग जउन स्वरग हे हबै, ओखर लग कुछु फडुहा नेहको पइहा। ");
INSERT INTO bhu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","इहैनिता जब तुम दान दइहा, ता अपन आगू ढिढोरा झइ पिटवाबा, जसना कुछ ढोंगी मनसे मंडली अउ गली हे करथै, कि मनसे उनखर बडाई करै। मै तुम्हर लग सही कथो, कि ऊ अपन फडुहा पाय चुकिन। ");
INSERT INTO bhu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","पय जब तुम दान दइहा, ता तोर लिघ्घो बाले मनसे झइ जानै पामै या झइ समझै पामै कि केतका देथस। ");
INSERT INTO bhu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ताकि तोर दान गुप्त हे रहै अउ तोर बाफ जउन गुप्त हे देखथै, तब तोके फडुहा देही। ");
INSERT INTO bhu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","जब तुम बिनती करत हबा, ता ढोंगहन कर जसना झइ करिहा, उन मनसेन के दिखामै के निता, मंडली हे अउ गली कर मोड हे ठाड हुइ के बिनती करथै, मै तुम्हर लग सही कथो, उनही उनखर फडुहा मिल चुकिस। ");
INSERT INTO bhu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","जब तुम बिनती करत हबा, ता अपन कोठा हे जा अउ दूरा ढाप के अपन स्वरगी बाफ लग गुप्त रूप लग बिनती करा। तब तोर बाफ जउन गुप्त हे करे हर कामन के देखथै, तोके फडुहा देही। ");
INSERT INTO bhu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","बिनती करत टेम गैर यहूदी के जसना बकर-बकर झइ करा, काखे उन समझथै कि उनखर बोहत बोलै लग उनखर बिनती सुने जही। ");
INSERT INTO bhu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","इहैनिता उनखर मेर झइ बना, काखे तुम्हर स्वरगी बाफ तुम्हर मांगै लग पहिलेन जानथै, कि तुम्हर कउन-कउन चीजन के जरूरत हबै। ");
INSERT INTO bhu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","इहैनिता तुम हइ मेर लग बिनती करा, हे हमर बाफ, तै जउन स्वरग हे हबस, तोर नाम पवितर माने जाय। ");
INSERT INTO bhu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","तोर राज आबै, जसना तोर इक्छा स्वरग हे पूर होथै, ओसनेन हइ भुंइ हे होय। ");
INSERT INTO bhu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","हमर दिन भर के रोटी आज हमके दे। ");
INSERT INTO bhu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","जउन मेर हम अपन अपराधन के छमा करे हबन, ओसनेन हमर गलती के छमा कर। ");
INSERT INTO bhu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","अउ हमही परिक्छा हे झइ डाल, पय बुराई लग बचा, पराकरम अउ महिमा सबरोज तोर आय। ओसनेन होय। ");
INSERT INTO bhu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","इहैनिता अगर तुम दूसर मनसेन के गलती के छमा करिहा, ता तुम्हर स्वरग के बाफ तुमही छमा करही। ");
INSERT INTO bhu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","अगर तुम दूसर मनसेन के गलती के छमा नेहको करिहा, ता तुम्हर स्वरग कर बाफ तुम्हर गलती के छमा नेहको करही। ");
INSERT INTO bhu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","जब कबहुन तुम उपास करथा, ता ढोंगहन के जसना तुम्हर मुंह उदास झइ रहै अउ उन अपन मुंह के इहैनिता उतारै रथै, ताकि दूसर मनसे उनखर उपास के जानै, मै तुम्हर लग सही कथो, कि अपन फडुहा पाय चुके हबै। ");
INSERT INTO bhu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","पय जब तुम उपास करथा, ता अपन मूड हे तेल लगाबा अउ अपन मुंह के धो लेया, ");
INSERT INTO bhu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","जेखर लग मनसेन के नेहको, पय केबल तुम्हर स्वरग के बाफ के जउन गुप्त हबै तै उपास हबस, तब तुम्हर जउन गुप्त कामन के देखथै तोके फडुहा देही। ");
INSERT INTO bhu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","तुम अपन निता भुंइ हे डेरा झइ जोडा, जिहां किरवा अउ पाई खथै अउ जिहां चोरटा छेदा बनाय के चोराय लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","पय अपन निता स्वरग हे डेरा अकजुट करा, जिहां किरवा अउ पाई नेहको लगही, न चोरटा छेदा बनाय के चोराही। ");
INSERT INTO bhu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","काखे जिहां तुम्हर डेरा हबै, उहै छो तुम्हर मन लगे रही। ");
INSERT INTO bhu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","देह के चिमनी आंखी हबै, इहैनिता अगर तुम्हर आंखी निक्खा हबै, ता सगलू देह उजेड होही। ");
INSERT INTO bhu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","अगर तुम्हर आंखी बेकार हुइ जाय, ता तोर सगलू देह अंधियार लग भर जही, इहैनिता अगर तुम्हर भित्तर के उजेड अंधियार होय, ता हइ केतका बडा अंधियार होही। ");
INSERT INTO bhu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","कउनो मनसे दुइठे मालिक के सेबा नेहको कर सकथै, काखे ऊ अकझन लग बैर करही अउ दूसर लग माया करही, या अकझन के इज्जत करही अउ दूसर के नरही, तुम भगवान अउ डेरा दोनोन के सेबा नेहको कर सकथा। ");
INSERT INTO bhu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","मै तुम्हर लग कथो, चिन्ता झइ करा अउ न अपन जीवन चलामै के निता कि हम का खइ या का पी अउ न अपन देह के निता कि हम का पेहनी। का जीवन खाना लग अउ का देह के खुरथा पइजामा लग बढके नेहको हबै? ");
INSERT INTO bhu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","बादर के चिरइयन के देखा, ऊ न तो बोमै न काटै न कोठला हे भरथै, तउभरमा तुम्हर स्वरग कर बाफ चिरइयन के खबाथै, का तुम्हर कीमत उनखर लग बढके नेहको हबै? ");
INSERT INTO bhu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","तुम मसे कउन असना मनसे हबै? जउन चिन्ता करके अपन उमर अक्ठी पल अउ बढाय सकथै। ");
INSERT INTO bhu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","अउ बन्डी के चिन्ता काखे करथा? देखा पतेरा के फूलन के कइसन बढथै, उन न ता मेहनत करथै अउ न खुरथा पइजामा बनाथै। ");
INSERT INTO bhu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","तउभरमा मै तुम्हर लग कथो, कि सुलेमान अइसो अराम अउ कउनो ओखर जसना सुन्दर खुरथा पइजामा नेहको पहिन सकै। ");
INSERT INTO bhu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","इहैनिता जब भगवान पटउरा के चारा के सजउटी हइ सीमा तक करथै, जेखर जीवन चुटु टेम कर हबै अउ जउन आने रोज आगी हे लेस दय जही, का ऊ तुमही कहुं बोहत सोभायमान नेहको करही? कसना कमजोर हबै तुम्हर बिस्वास। ");
INSERT INTO bhu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","इहैनिता चिन्ता झइ करा कि हम का खइ या का पी अउ का पहिनब? ");
INSERT INTO bhu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","हइ सब चीजन के तो गैर यहूदी ढूंढथै, तुम्हर स्वरग के बाफ जानथै कि तुमही हइ सगलू चीजन के जरूरत हबै। ");
INSERT INTO bhu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","इहैनिता पहिले तुम भगवान कर राज अउ नियाइपन के खोज करा, ता हइ सगलू चीज तुमही मिल जही। ");
INSERT INTO bhu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","इहैनिता कल के चिन्ता झइ करा, कल अपन चिन्ता खुदय कर लेही आज के दुख आज के निता बोहत हबै। ");
INSERT INTO bhu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","दूसरन के नियाव झइ करा, ताकि भगवान तुम्हर नियाव झइ करै। ");
INSERT INTO bhu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","जउन मेर लग तुम नियाव करथा, उहै मेर तुम्हर उप्पर नियाव करे जही अउ जउन नाप लग तुम नापथा, उहै नाप लग तुम्हर निता नापे जही। ");
INSERT INTO bhu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","जब तुमही अपनै आंखी के किरकिरी पतय नेहको, ता तुम अपन भाई बेहन के आंखी के किरकिरी काखे देखथा? ");
INSERT INTO bhu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","जब तुम्हरेन आंखी हे किरकिरी हबै, ता तुम अपन भाई बेहन लग कसना कहि सकथा, लाबा, मै तुम्हर आंखी के किरकिरी निकार दो? ");
INSERT INTO bhu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","हे ढोंगहा, आगू अपन आंखी के किरकिरी निकार, फेर तै अपन भाई बेहन के आंखी लग किरकिरी निकार सकहे। ");
INSERT INTO bhu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","पवितर चीज कुकरा के झइ देया अउ अपन मोती सुमरन के आगू झइ फेका, कहुं असना झइ होय कि उन उके अपन गोड तरी कचरै अउ फिर के तोके चीर फार डारै। ");
INSERT INTO bhu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","जब तुम मांगिहा, ता तुमही दय जही, डटेहा ता पइहा, ठोकठोकाउत रइहा ता तुम्हर निता कंवाड उघारे जही। ");
INSERT INTO bhu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","काखे जउन मांगथै, उके मिलथै, जउन डटेथै, ऊ पाथै अउ जउन ठोकठोकाथै, ओखर निता कंवाड उघारे जथै। ");
INSERT INTO bhu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","तुम्हर मसे असना बाफ कउ हबै जेखर टोरवा रोटी मांगही, ता ऊ ओही पथरा देही? ");
INSERT INTO bhu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","या जब ऊ ओखर लग मछडी मांगै ता ऊ उके सपुवा देही। ");
INSERT INTO bhu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","बेकार हुइके अगर तुम अपन लरकन के निक्खा चीज देथा, ता तुम्हर स्वरग कर बाफ अपन मांगै बालेन के निक्खा चीज काखे नेहको देही। ");
INSERT INTO bhu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","इहैनिता जसना बेउहार अपन निता तुम दूसर मनसेन लग चाहथा, ओसनेन बेउहार तुमो उनखर संग करा, काखे मूसा कर नियम के किताब अउ ग्यानी मनसे के सिक्छा इहै हबै। ");
INSERT INTO bhu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","सांकर रास्ता हुइके परबेस करा, काखे बिनास के दूरा चाकर हबै अउ उहां तक जाय बाले रास्ता लिखडी हबै अउ असना बोहत लग मनसे हबै, जउन चाकर रास्ता हे चलथै। ");
INSERT INTO bhu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","पय सांकर हबै ऊ दूरा अउ कठिन हबै ऊ रास्ता, जउन जीवन कर तरफ लइ जथै अउ हइ रास्ता हे रेंगै बाले चुटु हस मनसे हबै। ");
INSERT INTO bhu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ठगरा ग्यानी मनसेन लग बचे रहबे, उन गेडरा कर रूप हे बिगवा तुम्हर लिघ्घो आथै, पय भित्तर लग चीर खाय बाले बिगवा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","उनखर फडुहा लग तुम उनही चीन जइहा, कांटा बाले पुडरा लग अंगूर न बिजहा अकजुट कर पाथै अउ न किटिल्ली मसे अंजीर टोरथै। ");
INSERT INTO bhu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","इहैमेर हर अक्ठी निक्खा रूख हे निक्खा फडुहा फरथै अउ बेकार रूख हे बेकार फडुहा फरथै। ");
INSERT INTO bhu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","निक्खा रूख बेकार फडुहा नेहको देय सकथै, अउ न बेकार रूख अच्छा फडुहा लान सकथै। ");
INSERT INTO bhu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","जउन रूख निक्खा फडुहा नेहको फरथै, ओही खपलके आगी हे झपोय दय जथै। ");
INSERT INTO bhu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","इहैनिता उनखर कामन लग चीन्हे जइहा। ");
INSERT INTO bhu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“जउन मनसे मोके परभु-परभु कहिके गोहराथै, उनखर मसे सगलू कउ स्वरग छो नेहको जइही, पय जउन मोर स्वरगी बाफ कर इक्छा पूर करही, उहै मनसे स्वरग राज हे परबेस करही।” ");
INSERT INTO bhu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ऊ नियाव कर रोज बोहत मनसे मोर लग कइहिन परभु, परभु का हम तोर नाम लग आगू कर बात नेहको करन अउ तोर नाम लग भुतवन के नेहको निकारन? अउ तोर नाम लग बोहत चकित के काम नेहको करन? ");
INSERT INTO bhu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तब मै उनही सही-सही कहि दइहों, मै तुमही नेहको जानथो, हे अधरम करै बाले मोर आगू लग दुरिहां हुइ जा। ");
INSERT INTO bhu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","इहैनिता जउन कउ मोर बात के सुनथै अउ ओहमा चलथै, ऊ दिमाक बाले के जसना हबै, जउन अपन घर पथरा हे बनाथै। ");
INSERT INTO bhu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","पानी बरसथै, बाढ आइस, बडेरा चलिस अउ ऊ घर लग टकराइस तउभरमा ऊ घर नेहको गिरिस, काखे ओखर नीह पथरा हे डाले गय रथै। ");
INSERT INTO bhu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","जउन मनसे मोर बातन के सुनथै, पय ऊ उन बात हे नेहको चलथै, ऊ मूरुख के जसना हबै, जउन अपन घर कुदरा हे बनाय रथै। ");
INSERT INTO bhu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","पानी बरसथै, बाढ आइस अउ बोहत बडेरा चलिस अउ ऊ घर लग टकराइस ता ऊ घर भसक जथै। ");
INSERT INTO bhu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","जब यीसु हइ सगलू बात के गुठे चुकथै, ता मनसे सुनके बोहत चकित हुइ गइन। ");
INSERT INTO bhu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","काखे यीसु उन नियम के गुरू के जसना नेहको, पय बडा हक के संग सिक्छा देथै। ");
INSERT INTO bhu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","जब यीसु डोंगर लग उतरथै, ता मनसेन के बडा भीड ओखर पाछू हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","उहै अक्ठी कोढी रथै, जउन यीसु के लिघ्घो आय के उके निहुर के परनाम करके कथै, “हे परभु, अगर तै चाहथस, ता मोके सुध्द कर सकथस।” ");
INSERT INTO bhu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","यीसु हाथ बढाय के ओहि छियत कथै, मै चाहथो कि तै निक्खा हुइ जा, उहै टेम ऊ मनसे कोढ नंगहा लग सुध्द हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","यीसु ओखर लग कथै, “देख हइ बारे हे कउनो लग कुछु झइ कहबे। जायके खुद के पुजारी के दिखा अउ फेर मूसा कर आदेस के जसना बलि चढा ताकि मनसेन के तोर निक्खा होमै के गवाह बनै।” ");
INSERT INTO bhu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","जब यीसु कफरनहूम सहर छो आथै, ता अक्ठी रोमन सिपाही ओखर लिघ्घो अइस अउ ओखर लग मदद के निता बिनती करत कथै, ");
INSERT INTO bhu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“हे परभु, मोर सेबक के घर हे नांगा हे पडे हबै, उके लोकवाबाव मार दय हबै, उके बोहत पीरा होथै।” ");
INSERT INTO bhu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","तब यीसु सिपाही लग कथै, “मै आय के उके निक्खा कर देहुं।” ");
INSERT INTO bhu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","तब सिपाही जबाब देथै, “हे परभु, मै हइ लायक नेहको हबो, कि तै मोर छानी तरी आ, इहैनिता तै इहै लग कहि दइहे, ता मोर सेबक निक्खा हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","मै साहबन के तरी हंव अउ सिपाही मोर तरी हबै, जब मै कउनो लग कथो, उछो जा, ता ऊ जथै अउ दूसर लग कथो, हइछो आ, ता ऊ आथै अउ अपन हरवाह के कथो हइ के ता ऊ करथै।” ");
INSERT INTO bhu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","यीसु हइ सुनके चकित होथै, अपन पाछू आमै बाले मनसेन लग कथो, मै तुम्हर लग सही कथो, मै एतका मजबूत बिस्वास इस्राएल हे कउनो के भित्तर नेहको पाय हबो। ");
INSERT INTO bhu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","मै तुम्हर लग कथो, दिन उगती अउ दिन बुडती लग बोहत मनसे आय के अब्राहम, इसहाक अउ याकूब के संग, स्वरग कर राज के खाना हे समलित हुइहिन। ");
INSERT INTO bhu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","पय जेही मोर राज हे होमै चाही, उनही अंधियार हे डाल दय जही, जिहां रोइहिन अउ दांत पिसहिन। ");
INSERT INTO bhu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","तब यीसु सिपाही लग कथै, जा जसना तोर बिस्वास हबै, ओसनेन तोर निता होय अउ ओखर सेबक उहै टेम निक्खा हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","जब यीसु पतरस के घर पहुंचथै, तब ऊ देखथै, कि पतरस के फुवा के बुखार चढे हबै। ");
INSERT INTO bhu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","यीसु ओखर हाथ छिथै अउ उहै टेम ओखर बुखार उतर गइस, फेर ऊ ओखर सेबा करै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","जब सांझ हुइ गइस ता मनसे ओखर लिघ्घो लाय करथै, जउन भुतवा लग बोहत परेसान रथै, यीसु उन भुतवा के अपन बचन लग निकाडथै अउ सगलू नंगहन के निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","हइ इहैनिता होथै ताकि जउन बात यसायाह ग्यानी मनसे के दवारा कहे गय रथै, ऊ पूर होय, “ऊ अपन उप्पर हमर कमजोर, नांगा के लइ लइस अउ हमर बोझ के उठाय लइस।” ");
INSERT INTO bhu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","यीसु जब अपन अगल बगल भीड के देखिस, ता ऊ अपन चेलन के दहार के दूसर पार जायके आदेस देथै, ");
INSERT INTO bhu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","उहै टेम अक्ठी नियम के गुरू आय के यीसु लग कथै, हे गुरू, तै जिहां कहुं जइहे, महुं तोर संग जहों। ");
INSERT INTO bhu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","यीसु ओखर लग कथै, “सिकटा के टोंका होथै अउ बादर के चिरइया के गोंदा होथै, पय मनसे कर टोरवा के लिघ्घो सोमैके अउ अराम करै के निता जिघा नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","अक्ठी चेला ओखर लग कथै, “परभु, मोके पहिले अपन बाफ के माटी हे गाढै के निता जाय दे।” ");
INSERT INTO bhu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","यीसु ओखर लग कथै, मोर संग हुइ जा अउ जउन मनसे मन लग मरे हबै, उनखर निता हइ काम छांड देया। ");
INSERT INTO bhu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","जब यीसु नाह जिहाज हे बइठिस, ता ओखर चेलो ओखर संग हुइ लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","उहै टेम दहार हे एतका भयंकर बडेरा उठिस कि नाह जिहाज लेहरा लग बुडे लग जथै, पय यीसु ऊ टेम सोउत रथै। ");
INSERT INTO bhu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","तब चेला ओखर लिघ्घो आय के उके जगाउत कथै, “हे परभु हमही बचा ले, नहि ता हम सगलू मर जउबे।” ");
INSERT INTO bhu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","यीसु उनखर लग कथै, “हे अबिस्वासी तुम काखे डरथा?” तब ऊ उठके बडेरा अउ पानी के गधारिस अउ उहै टेम सब कुछ सान्त हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","चेला चकरा गइन अउ कहै लागथै, हइ कइसन मेर के मनसे हबै, कि बडेरा अउ पानी ओखर बात मानथै। ");
INSERT INTO bhu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","जब यीसु दहार के दूसर पार गदरेनियो परदेस के इलाका हे पहुंचथै, ता ओखर मुलाकात दुइठे मनसे लग हुइस, जउन मरघटी लग निकडके ओखर लग मिले आथै, उनखर भित्तर भुतवा रथै अउ ऊ एतका भयंकर रथै, कि ऊ गली लग कोनो के हिम्मत नेहको होथै कि ऊ रास्ता लग गुजर सकै। ");
INSERT INTO bhu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ऊ यीसु के देखके चिरलायके कथै, “हे भगवान कर टोरवा हमर लग तै काहिन चाहथस? का टेम पूर होय लग आगुन तै इछो हमही पीरा दे के निता आय हबस?” ");
INSERT INTO bhu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","उहां चुटु दुरिहां हे अक्ठी सुमरा के बडका झुन्ड चरत रथै। ");
INSERT INTO bhu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","भुतवा यीसु लग बिनती करके कथै, कि “अगर तै हमही निकाडथस, ता हमही ऊ सुमरा के झुन्ड हे पठोय दे।” ");
INSERT INTO bhu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","यीसु उनखर लग कथै, “निकड जा।” तब भुतवा ऊ मनसे मसे निकडके उन सुमरन हे कढ जथै अउ सगलू सुमरा के झुन्ड डोंगर के करखा लग कुदर के पानी हे बुड के मर गइन। ");
INSERT INTO bhu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","सुमरा चरामै बाले बरेदी भगिन अउ सहर छो जायके जेहमा भुतवा रथै अउ जउन घटना घटे रथै, ऊ पूर गुठेथै। ");
INSERT INTO bhu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","हइ सुनके सगलू सहर के मनसे यीसु लग मिलै के निता आमै लगिन अउ उन उके देखके, ओखर लग बिनती करके कथै, हमर इलाका लग कढ जा। ");
INSERT INTO bhu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ताकि इहैनिता तुम जान लेया, फेर यीसु नाह जिहाज हे चढके दहार के ऊ पार अपन सहर कफरनहूम छो आय गइस। ");
INSERT INTO bhu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","कुछ मनसे लोकवा के अक्ठी नंगहन के खटिया हे सोबाय के यीसु के लिघ्घो लानथै, यीसु उनखर बिस्वास देखके ऊ लोकवा नंगहा लग कथै, “हे टोरवा हिम्मत धर तोर पाप छमा हुइ गय हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","तब कुछ यहूदी गुरू अपन मन हे सोचथै, “हइ तो भगवान के बुराई करथै।” ");
INSERT INTO bhu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","उनखर हइ बिचार जानके यीसु कथै, “तुम अपन मन हे बेकार बिचार काखे करथा? ");
INSERT INTO bhu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","बोहत जरूरी काहिन हबै? हइ कहो कि तोर पाप छमा हुइस, या हइ कहो कि ठाड हुइ जा अउ रेंग बाग? ");
INSERT INTO bhu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ता तुम हइ जान लेया कि मनसे कर टोरवा के भुंइ हे पाप छमा करै के हक हबै।” तब नंगहा लग कथै, “ठाड हुइ जा अउ अपन खटिया उठाय के अपन घर छो कढ जा।” ");
INSERT INTO bhu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ऊ ठाड हुइस अउ अपन घर छो कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","हइ देखके मनसे डर गइन अउ भगवान के महिमा करै लगिन, जउन मनसेन के असना हक दय हबै। ");
INSERT INTO bhu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","यीसु जब उहां लग आगू बढथै, ता ऊ मत्ती नाम कर अक्ठी मनसे के पइसा उगाहै बाले चबुतरा हे बइठे हर देखथै, ऊ ओखर लग कथै, “मोर पाछू आ” ऊ उठके ओखर पाछू हुइ लइस। ");
INSERT INTO bhu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","जब यीसु मत्ती के घर हे खाना खाय के निता बइठथै, ता बोहत लग पइसा उगाहै बाले अउ पापी मनसे चेलन के संग खाना खाइन। ");
INSERT INTO bhu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","हइ देखके फरीसी मनसे यीसु के चेलन लग पूछथै, तुम्हर गुरू पइसा उगाहै बाले अउ पापिन के संग खाना काखे खथै? ");
INSERT INTO bhu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","हइ बात सुनके यीसु उनखर लग कथै, “निक्खा मनसे के गुनिया के जरूरत नेहको होथै, पय नंगहा मनसेन के जरूरत होथै। ");
INSERT INTO bhu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","अब तुम जा अउ हइ किस्सा के मतलब समझा, मै बलि नेहको चाहथो बलुक दया चाहथो, काखे धरमी मनसेन के निता नेहको पय पापिन के बुलामै आय हव।” ");
INSERT INTO bhu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","फेर पानी हे बतिस्मा देय बाले यूहन्ना के चेला यीसु के लिघ्घो आथै अउ ओखर लग पूछथै, “हम अउ फरीसी बोहत उपास करथन, पय तोर चेला काखे उपास नेहको करथै?” ");
INSERT INTO bhu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","यीसु उनखर लग कथै, जब तक दुलहा उनखर संग हबै, का बरतिहा मनसे दुख मनाय सकथै? पय ऊ रोज आही जब दुलहा उनखर लग अलगे कर दय जही, तब उन उपास करही। ");
INSERT INTO bhu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","कउ जुनहा खुरथा पइजामा हे नबा चिथरा नेहको लगाथै, काखे ऊ चिथरा जुनहा खुरथा पइजामा के फाड दइ अउ ऊ बोहत चिथर जही। ");
INSERT INTO bhu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","इहैमेर मनसे हरबी निकाडे हर अंगूर कर रस्सा, जुनहा खलरी के झोरा हे नेहको भरथै, असना करै लग ऊ झोरा चिथर जथै अउ अंगूर कर रस्सा बहि जथै अउ ऊ झोरा बेकार हुइ जथै, इहैनिता मनसे नबा अंगूर कर रस्सा नबा झोरा हे भरथै, जेखर लग दाखरस अउ झोरा दुनो बचे रथै। ");
INSERT INTO bhu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","यीसु उन मनसेन के जब हइ बात कहत रथै, तबै यहूदी मुखिया ओखर लिघ्घो आथै अउ ओखर आगू निहुर के परनाम करत कथै, “अभिनैन मोर टोरिया मर गय हबै, ता तै चलके ओखर उप्पर अपन हाथ धरहे, ता ऊ जिन्दा हुइ जही।” ");
INSERT INTO bhu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","यीसु उठके अपन चेलन के संग ओखर संग चले गइस। ");
INSERT INTO bhu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","उहै टेम अक्ठी डउकी रथै, जेही बारा साल लग खून बोहै के नांगा रथै अउ ऊ पाछू लग यीसु के लिघ्घो आथै अउ ओखर खुरथा पइजामा के छोर के छि लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","काखे ऊ अपन मन हे हइ कथै, अगर मै ओखर खुरथा पइजामा के छि लइहों ता निक्खा हुइ जइहों। ");
INSERT INTO bhu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","यीसु पाछू फिर के उके देखथै अउ ओखर लग कथै, “टोरिया हिम्मत रख, तोर बिस्वास तोके निक्खा कर दय हबै” अउ ऊ डउकी उतकै टेम निक्खा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","जब यीसु ऊ मुखिया के घर छो पहुंचथै, ता उहां बसुरी बजामै बाले अउ मनसेन के हल्ला मचाउत देखथै। ");
INSERT INTO bhu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","तब यीसु मनसेन लग कथै, “इछो लग बाहिर हुइ जा, टोरिया नेहको मरे हबै, पय ऊ सोथै” हइ बात सुनके उन मनसे ओखर मजाक उडाथै। ");
INSERT INTO bhu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","जब मनसेन के बाहिर छो के देथै, ता यीसु टोरिया के कोठा हे जाय के ओखर हाथ पकर के उठाथै अउ ऊ उठ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","हइ बात के खबर ऊ सगलू देस हे बगर गइस। ");
INSERT INTO bhu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","जब यीसु उछो लग जाय लगिस, ता दुइठे अंधरा मनसे चिरलाउत ओखर पाछू हुइ लेथै, “हे दाऊद कर टोरवा हमर उप्पर दया कर।” ");
INSERT INTO bhu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","जब यीसु घर के भित्तर पहुंचथै, ता उन अंधरा मनसे ओखर लिघ्घो आथै, ता यीसु उनखर लग पूछथै, “का तुमही बिस्वास हबै, कि मै तोके निक्खा कर सकथों?” उन कथै, “हंव परभु।” ");
INSERT INTO bhu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तब यीसु उनखर आंखी के छुवत कथै, “तुम्हर निता ओसनेन होय जसना तुम्हर बिस्वास हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","अउ उनखर आंखी उघर गइस, फेर यीसु उनही समझाय के कथै, “एखर बारे हे कउ के पता झइ होय।” ");
INSERT INTO bhu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","पय उन जायके ऊ सगलू देस हे यीसु के बारे हे खबर फइला देथै। ");
INSERT INTO bhu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","जब उन दुनो उहां लग निकडथै, तबै कुछ मनसे अक्ठी बउरा मनसे यीसु के लिघ्घो लइके आनथै, जेहमा भुतवा समाय रथै, इहैनिता ऊ कुछ नेहको बोल पाउत रहिस। ");
INSERT INTO bhu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","जब यीसु भुतवा के ओखर लग निकार देथै, ता ऊ बउरा बोलै लागथै, ता मनसे हइ देखके चकरा जथै अउ कथै, “हम इस्राएल हे असना कबहुन नेहको देखे हबन।” ");
INSERT INTO bhu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","पय फरीसी कथै, “हइ तो भूतन के मुखिया के मदद लग बाहिर निकाडथै।” ");
INSERT INTO bhu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","यीसु सगला गांव-गांव अउ सहर-सहर हे जायके यहूदी मंडली हे संदेस देथै, अउ भगवान कर राज के बारे हे परचार करथै, उछो ऊ सबैमेर के नंगहा अउ ढिलवन के निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","जब यीसु मनसेन के भीड के देखथै, ता उनखर परति दया आइस, काखे उन मनसे ओसनेन सताय हर अउ बेसहारा रथै, जसना उन गेडरा होथै, जिनखर कउनो बरेदी नेहको रथै। ");
INSERT INTO bhu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","यीसु अपन चेलन लग कथै, “पके हर खेतबा बोहत हबै, पय कटइया चुटुहस हबै। ");
INSERT INTO bhu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","इहैनिता खेत के मालिक लग बिनती करा, कि ऊ अपन खेत के काटै के निता कटइयन के पठोय दे।” ");
INSERT INTO bhu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","यीसु अपन बाराठे चेलन के अपन लिघ्घो बुलाय के उनही भुतवन के निकारै के अउ सबैमेर के नंगहन अउ ढिलवन के निक्खा करै के हक देथै। ");
INSERT INTO bhu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","उन बाराठे चेलन के नाम हबै, सबले पहिले समोन जउन पतरस कहाथै, ओखर भाई अन्द्रियास, जबदी के टोरवा याकूब अउ ओखर भाई यूहन्ना, ");
INSERT INTO bhu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिप्पुस, बरतुल्मै, थोमा अउ पइसा उगाहै बाले मत्ती, हलफई के टोरवा याकूब अउ तद्दै, ");
INSERT INTO bhu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","समोन, कनानी अउ यहूदा इस्करियोती जउन यीसु के पकडोथै। ");
INSERT INTO bhu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","यीसु इन बाराठे चेलन के हइ आदेस दइके पठोथै, “गैर यहूदी के इछो झइ जइहा अउ न सामरिया के कोनो इलाका हे घुसिहा।” ");
INSERT INTO bhu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","पय इस्राएल के घराना के भुलाय हर गेडरा के लिघ्घो जइहा। ");
INSERT INTO bhu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","जात टेम हइ परचार करा, कि स्वरग कर राज लिघ्घो आय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","नंगहन के सुध्द करा, मरे हरन के जिन्दा करा, कोढिन नंगहन के निक्खा करा, भुतवा के निकारा, तुम फिरी हे पाय हबा फिरी हे देया। ");
INSERT INTO bhu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","अपन खलरी कर थइला हे सोना, पइसा अउ चांदी झइ लइहा। ");
INSERT INTO bhu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","गली के निता न झोरा रखिहा, न दुइठे जोडा खुरथा पइजामा, न बूट अउ न डंडा काखे मेहनत करै बालेन के मजदूरी मिलय के चाही। ");
INSERT INTO bhu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","जउन कोनो सहर, गांव छो जइहा, ता पता करिहा कि उछो बिस्वासओग मनसे कोहर हबै, तब तक तुम गांव नेहको छडिहा, तब तक उहै मनसे के घर हे रइहा। ");
INSERT INTO bhu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","जब तुम कउनो के घर हे जइहा ता ऊ घर के मनसेन के नमस्ते करत कइहा “तुमही सान्ति मिलै।” ");
INSERT INTO bhu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","अगर ऊ घर के मनसे लायक होही, ता तुम्हर सान्ति उनखर तक पहुंचही, अगर उन लायक नेहको होही, ता तुम्हर सान्ति तुम्हर लिघ्घो लउट आही। ");
INSERT INTO bhu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","अगर कउ तुम्हर पोहनाई नेहको करथै अउ तुम्हर बात नेहको सुनथै, ता ऊ घर या ऊ सहर छांडत टेम अपन गोड के धूधुरा के उहै झार दइहा। ");
INSERT INTO bhu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","मै तुम्हर लग सही कथो, नियाव के रोज सदोम अउ अमोरा सहर के हालत, ऊ सहर लग बोहत सहै के लायक होही। ");
INSERT INTO bhu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","देखा मै तुमही बिगवा के बीच हे गेडरा के मेर पठोथो, इहैनिता सपुवा के मेर चत्तुर अउ परेवा के जसना भोला बनिहा। ");
INSERT INTO bhu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","मनसेन लग सचेत रइहा, काखे उन तुमही पकड के यहूदी पंचायत के दइ दइहीं अउ उन तुमही ऊ अपन यहूदी मंडली हे कोडा लग पिटवाही। ");
INSERT INTO bhu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","इहैनिता साहबन अउ राजन के आगू बोलाय जही, मोर कारन तुम मोर हे बिस्वास करथा, तुमही मोका दय जही कि तुम उनही अउ गैर यहूदिन के मोर बारे हे गवाह दइ सका। ");
INSERT INTO bhu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","जब उन तुमही पकडही ता चिन्ता झइ करिहा, कि तुमही काहिन बोलै के हबै अउ काहिन कइहा, काखे ऊ टेम तुमही बताय दय जही कि तुमही काहिन बोलैका हबै। ");
INSERT INTO bhu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","काखे बोलै बाले तुम नेहको हबा, पय तुम्हर भगवान बाफ के आतमा हबै, जउन तुम्हर लग बोलहि। ");
INSERT INTO bhu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","मनसे अपन भाई के मार डरही अउ बाफ अपन लरका के संग ओसनेन करही अउ लरका अपन दाय बाफ के बिरोध ठाड हुइहीं अउ उनही मरवा डरहिन। ");
INSERT INTO bhu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","मोर नाम के खातिर सगलू मनसे तुम्हर लग नफरत करही, पय जउन आखरी तक धीर धरे रही उहै मुकति पाही। ");
INSERT INTO bhu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","जब उन तुमही अक्ठी सहर हे सतइही, ता तुम दूसर सहर छो भग जइहा, मै तुम्हर लग सही कथो, तुम इस्राएल देस के सगलू सहर हे घूमो नेहको पइहा कि एतका तक हे मनसे कर टोरवा यीसु आय जही। ");
INSERT INTO bhu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","चेला अपन गुरू लग बढके नेहको होथै अउ न हरवाह अपन मालिक लग बडा होथै। ");
INSERT INTO bhu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","चेलन के गुरू के बरोबर होय हे अउ हरवाहन के मालिक के बरोबर होमै हे संतोस करैका चाही, अगर मनसे घर के मुखिया के भुतवा कथै, ता उन ओखर घर बालेन के का कुछ नेहको कइहीं? ");
INSERT INTO bhu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","इहैनिता मनसेन लग झइ डरिहा, काखे जउन कुछ लुके हबै सब उघारे जही अउ हर ऊ चीज जउन लुके हबै, परगट करे जही। ");
INSERT INTO bhu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","मै अंधियार हे जउन कुछ तुम्हर लग कथो, उके तुम उजियार हे गुठेवा अउ मै जउन कुछ तुम्हर कान हे कहे हबो, तुम उनखर घर के छानी हे चढ के परचार करा। ");
INSERT INTO bhu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","जउन जीव के मार सकथै अउ आतमा के नेहको मार सकथै, उनखर लग झइ डेराबा, सिबाय ऊ भगवान लग डेराबा जउन तुम्हर देह अउ आतमा दोनोन के नरक हे नास कर सकथै। ");
INSERT INTO bhu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","का अक्ठी पइसा हे दुइठे गलइया नेहको बिकथै? तउभरमा तुम्हर बाफ के जानै बिना अउ ओखर इक्छा के बिना भुंइ हे नेहको गिर सकथै। ");
INSERT INTO bhu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","तुम्हर तो मूड के चूंदियो तक गिनरे हर हबै। ");
INSERT INTO bhu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","इहैनिता झइ डेराबा तुम्हर कीमत गलइयन लग बढ के हबै। ");
INSERT INTO bhu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","जउन कउ मनसेन के आगू मोके मान लेही, ओहि महुं अपन स्वरगी बाफ के आगू मान लेहूं। ");
INSERT INTO bhu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","अउ जउन कउ मनसेन के आगू मोके मना करही, महुं अपन स्वरगी बाफ के आगू उके मना करहुं। ");
INSERT INTO bhu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","असना झइ समझा कि मै दुनिया हे सान्ति लइके आय हबो, मै सान्ति नेहको, बलुक तलबार लग काटै के निता आय हबो। ");
INSERT INTO bhu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","मै हइ करै आय हबो कि, टोरवा, बाफ के बिरोध हे, टोरिया, दाय के बिरोध हे, पुतउ, फुवा के बिरोध हे हुइहिन। ");
INSERT INTO bhu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","तुम्हर बैरी तुम्हर घर के मनसे हुइहिन। ");
INSERT INTO bhu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“जउन अपन दाय-बाफ के मोर लग बोहत माया करथै, ऊ मोर होय के काबिल नेहको हबै। जउन अपन टोरवा टोरियन के मोर लग बोहत माया करथै, ऊ मोर होय के काबिल नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","जउन चेला अपन क्रूस उठाय के मोर पाछू नेहको रेंगही ऊ मोर काबिल नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","जउन मनसे अपन परान बचामै चाहथै, ऊ उके खोय देही अउ जउन मोर निता अपन परान देही, ऊ जीवन पाही।” ");
INSERT INTO bhu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“जउन तुमही सोगत करथै, ऊ मोके सोगत करथै अउ जउन मोके अपनाथै, ऊ भगवान के अपनाथै जउन मोके पठोय हबै। ");
INSERT INTO bhu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जउन ग्यानी मनसे के इहैनिता अपनाथै कि ऊ ग्यानी मनसे हबै, उके उहै इनाम मिलही जउन ग्यानी मनसेन के मिलथै। अउ अगर तुम कउनो धरमी मनसे के इहैनिता अच्छी कथै, काखे ऊ नियाइपन करथै अउ उके उहै इनाम मिलही जउन नियाइपन काम करै बालेन के मिलथै। ");
INSERT INTO bhu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","जउन कउ इन नान मसे कउनो के चेला मान के उके गिलास भर पानी पियाही, ता मै तुम्हर लग सही कथो, कि ऊ अपन इनाम कबहुन नेहको गमाही।” ");
INSERT INTO bhu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","जब यीसु अपन बारहठे चेलन के निरदेस देय के बाद हे, उहां लग कढ गइस अउ ऊ यहूदियन के सहर हे सिक्छा अउ संदेस के परचार करै लगिस। ");
INSERT INTO bhu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","जब यूहन्ना जेल हे रथै ता यीसु मसीह के कामन के बारे हे सुनथै ता ऊ अपन चेलन के दवारा संदेस पठोइस ");
INSERT INTO bhu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","कि “का तै उहै हबस जउन आय बाले रथै, या हम कउनो अउ के ओरगी?” ");
INSERT INTO bhu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","यीसु जबाब देथै, जउन कुछु बात तुम सुने हबा अउ देखे हबा, जाय के यूहन्ना के गुठे देया, ");
INSERT INTO bhu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","अंधरा देखथै अउ लेंगरा रेंगथै, कोढी सुध्द होथै बहिरा सुनथै अउ मरे हर मनसे जिन्दा होथै अउ गरीबन के संदेस सुनाय जथै। ");
INSERT INTO bhu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ऊ धन्य हबै, जिनही मोर बारे हे कउनो संका नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","यूहन्ना के चेला जाय बाले रथै, कि यीसु मनसेन के भीड हे यूहन्ना के बारे हे गुठेमै लगथै, तुम पतेरा हे का देखै गय रहा? का हवा लग डोलाय जाय बाले सरकन्डे के? ");
INSERT INTO bhu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ता फेर तुम काहिन देखै गय रहा, का निक्खा बन्डी पहिरे हर मनसे के? नेहको देखा जउन निक्खा बन्डी पहिरथै, ऊ तो राजभवन हे होथै। ");
INSERT INTO bhu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ता तुम काहिन देखै आय हबा का कउनो ग्यानी मनसे के, हां मै तुमही गुठेथो कि जेही तुम देखे हबा ऊ कउनो ग्यानी मनसे लग बोहत बडा हबै। ");
INSERT INTO bhu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","हइ उहै हबै जेखर बारे हे किताब हे लिखररे हबै, भगवान कथै, देख मै तोर लग आगू अपन दूत पठोथो ऊ तोर निता गली बनाही। ");
INSERT INTO bhu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","मै तुम्हर लग सही कथो, बतिस्मा देय बाले यूहन्ना लग बडा कउनो मनसे पइदा नेहको होय हबै, तउभरमा स्वरग के राज हे नान लग नान यूहन्ना लग बडा हबै। ");
INSERT INTO bhu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","यूहन्ना पानी हे बतिस्मा देय बाले के रोज लग आज तक स्वरग के राज हे पूरे ताकत लग भित्तर जात हबै अउ बल परयोग करै बाले ओखर उप्पर राज करथै। ");
INSERT INTO bhu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","यूहन्ना के टेम लग सगलू ग्यानी मनसे अउ मूसा कर नियम के आगू कर बात गुठेमै बाले करत रहिन। ");
INSERT INTO bhu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","अगर तुम ओखर संदेस हे बिस्वास करै के निता तइयार हबा ता यूहन्ना एलिय्याह हबै, जेखर आवै के पहिलेन लग गुठे गय रहिस, ");
INSERT INTO bhu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","जेखर कान होय ऊ सुन ले। ");
INSERT INTO bhu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","पय हइ पुरखा के बरोबरी केखर लग करव? ऊ बजार हे बइठके उन लरकन के जसना हबै जउन अक दूसर लग पुकार के कहत हबै, ");
INSERT INTO bhu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","हम तुम्हर निता बसुरी बजायन, पय तै नेहको नाचे तुम्हर निता दुख के गाना गयों पय तै नेहको रोय। ");
INSERT INTO bhu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","पानी हे बतिस्मा देमै बाले यूहन्ना न तो रोटी खाइस अउ न दारू पीस, इहैनिता मनसे कथै, कि ओखर भित्तर भुतवा हबै। ");
INSERT INTO bhu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","जब मनसे कर टोरवा आइस ता ऊ खाइस अउ पीस अउ सगलू मनसे कथै, हइ मनसे के देखा हइ मनसे लदहा अउ दरुहा हबै अउ पइसा उगाहै बाले अउ पापिन के संगी हबै, पय भगवान के ग्यान अउ ओखर काम लग परमानित होथै। ");
INSERT INTO bhu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","तब यीसु ऊ सहर के धितकारै लगिस, काखे ऊ उहां कइनठे सक्ति के काम करे रथै, काखे उहां के मनसे पाप करै के नेहको छांडथै अउ न अपन मन बदलथै। ");
INSERT INTO bhu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","यीसु कथै, “हाय खुराजीन अउ हे बैतसदा जउन सक्ति के काम तुम्हर हे करे गय रहिस, अगर ऊ काम सूर अउ सैदा सहर हे करे होतिस, ता बोरा ओढ के अउ राख हे बइठ के अपन पापन लग कबहुन के उन मनसे पाप करै के मन बदला अउ छांड देतिन। ");
INSERT INTO bhu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","इहैनिता तुम्हर लग कथो, ऊ रोज भगवान नियाव के रोज सूर अउ सैदा के दसा तुम्हर उप्पर जादा दया करही। ");
INSERT INTO bhu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","हे कफरनहूम काखे तै सोचथस कि तोके स्वरग के महिमा लग उप्पर उठाय जही? तै तो नरक छो जइहे, जउन सक्ति के काम तोर लग करे गय रहिस, अगर ऊ सदोम हे करे जातिस ता ऊ सहर आज तक बने रहतिस। ");
INSERT INTO bhu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","पय मै तुम्हर लग कथो, कि नियाव के रोज भगवान गमोरा अउ सदोम के तुम्हर उप्पर जादा दया करही।” ");
INSERT INTO bhu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","उहै टेम यीसु कथै, हे बाफ, तै स्वरग अउ भुंइ के परभु हबस, मै तोके धन्यबाद देथो, काखे तै हइ बातन के, उनखर लग जउन ग्यानी हबै अउ समझदार हबै, गुप्त हे धरे हबै अउ जउन नान लरका हबै उनखर निता परगट करे हबस। ");
INSERT INTO bhu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","मोर बाफ मोके सब कुछु दय हबै, बाफ के सिबाय कउनो टोरवा के नेहको जानथै अउ टोरवा के सिबाय बाफ के कउनो नेहको जानथै, सिबाय उन जेही टोरवा परगट करै चाहथै। ");
INSERT INTO bhu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","मोर बाफ मोके सगलू कुछ सउप दय हबै, बाफ के सिबाय अउ कउ टोरवा के नेहको जानथै अउ टोरवा के छांडके बाफ के कउ नेहको जानथै अउ टोरवा उके परगट करै के चाहथै। ");
INSERT INTO bhu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“हे सगलू थके अउ गरू लग दबररे हर मनसे मोर लिघ्घो आबा, मै तुमही बिसराम दइहों। ");
INSERT INTO bhu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","मोर जुंवा अपन उप्पर लइला अउ मोर लग सीखा, काखे मै आतमा लग कोमर अउ नरम हंव अउ तुम अपन मन हे अराम पइहा। ");
INSERT INTO bhu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","काखे मोर जुंवा बोहत लिखडी हबै अउ मोर बोझा हरू हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","लगभग उहै टेम यीसु सुस्ताय कर रोज के दिन गोहूं के खेत हुइके जथै, ओखर चेलन के भूख लगथै अउ गोहूं के बालिन के टोर के खाय लगिन। ");
INSERT INTO bhu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","फरीसी मनसे चेलन के असना करत देखके कथै, “देखा, तोर चेला उहै करथै जउन सुस्ताय कर रोज काम करै के मना हबै अउ तोर चेला उहै करथै।” ");
INSERT INTO bhu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","यीसु उनखर लग कथै, “का तुम नेहको पढे हबा कि जब दाऊद अउ उनखर संगिन के भूख लगथै, ता दाऊद हन काहिन करिन? ");
INSERT INTO bhu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ऊ भगवान के बिनती घर हे घुस के भगवान कर चढाय हर बलि पवितर रोटी के कसके खाइन? काखे ओही अउ ओखर संगिन के उनखर रोटी खान पियन मूसा कर नियम के बिरोध रथै, ऊ रोटी के केबल पुजारी मनसेन के खाय पिये के उचित रथै। ");
INSERT INTO bhu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","मूसा कर नियम के किताब के नेहको पढे हबै, कि सुस्ताय कर रोज बिनती भवन के पुजारी खुदय सुस्ताय कर रोज के अपवितर करथै अउ तउभरमा ऊ दोसी नेहको ठहरिन। ");
INSERT INTO bhu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","पय मै तुम्हर लग कथो, इछो कउ हबै जउन बिनती भवन लग बड्डे हबै। ");
INSERT INTO bhu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","अगर तुम पवितर किताब हे जउन लिखवरे हबै, उके जाने होता कि मै मनसेन हे दया चाहथो, बलि नेहको ता तुम उनही झूठ नेहको ठहराउता जउन बेकसूर हबै। ");
INSERT INTO bhu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","हव, मनसे कर टोरवा सुस्ताय कर रोज के परभु हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","फेर यीसु उछो लग कढ जथै अउ यहूदी मंडली हे पहुंचथै। ");
INSERT INTO bhu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","उछो अक्ठी मनसे रथै जेखर हाथ झुराय हर रथै, उन मनसे यीसु लग पूछथै, “मूसा कर नियम के जसना सुस्ताय कर रोज कउनो के निक्खा करै के उचित हबै?” उन इहैनिता पूछथै कि ओखर हे दोस लगाय सकि। ");
INSERT INTO bhu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","यीसु उनही जबाब देथै “मानलेया, तुम्हर मसे कउनो के लिघ्घो अक्ठिन गेडरा हबै अउ ऊ गेडरा सुस्ताय कर रोज कोनो खोदरा हे गिर जही, ता का तुम उके पकड के बाहिर नेहको निकडिहा। ");
INSERT INTO bhu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","मनसे ता गेडरा लग कहुं बड्डे हबै। इहैनिता सुस्ताय कर रोज निक्खा करै के नियम के जसना उचित हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","तब यीसु ऊ झुराय हर हाथ बाले मनसे लग कथै, “अपन हाथ मोर छो आगू बढा” ऊ अपन हाथ आगू बढाथै अउ ऊ दूसर हाथ के जसना निक्खा हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","एखर बात फरीसी मनसे मंडली लग बाहिर जाय के यीसु के खिलाफ अक्ठी योजना बनामै लगिन। ");
INSERT INTO bhu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","यीसु हइ बात जान जथै अउ उछो लग कढ गइस अउ मनसेन के भीड ओखर संग हुइ लइन अउ ऊ सगलू नंगहा मनसेन के निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","पय यीसु उनही चेतन्न करथै, कि तुम मोर बारे हे मनसेन के कुछु झइ गुठेहा। ");
INSERT INTO bhu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","हइ इहैनिता हुइस कि जउन बचन यसायाह ग्यानी मनसेन के परभु गुठेय रथै ऊ पूर होय: ");
INSERT INTO bhu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“हइ मोर सेबक हबै जेही मै चुने हबो, हइ मोर पिरिया हबै मै ओखर लग मगन हबो, मै अपन आतमा एही दइहों, अउ ऊ गैर यहूदी के सब मनसेन के नियाव करही। ");
INSERT INTO bhu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","हइ न तो झगडा करही अउ न चिरलाही अउ न चउगडडा हे कउ ओखर आरो सुनही। ");
INSERT INTO bhu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ऊ न टटेर के डंडा के टोर पाही अउ न जगमगात चिमनी के। ऊ तब तक ठाड रही, जब तक ऊ नियाव के जीत के कारन नेहको बन जही। ");
INSERT INTO bhu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","अउ गैर यहूदी ओखर नाम हे आसा लगाय रइहीं।” ");
INSERT INTO bhu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","फेर मनसे यीसु के लिघ्घो अक्ठी अंधरा अउ बउरो मनसे के लानथै जेहमा भुतवा रथै, यीसु उनही निक्खा कर देथै, ऊ देखै अउ बोलय लगिन। ");
INSERT INTO bhu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","सगलू मनसे हइ देखके चकराय जथै, “कहुं इहै तो नेहको हबै दाऊद के लरकन मसे।” ");
INSERT INTO bhu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","फरीसी मनसे हइ देख के कथै, “हइ मनसे भुतवन के मुखिया बालजबूल के मदद लग भुतवन के निकाडथै।” ");
INSERT INTO bhu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","यीसु उनखर मन के बात जान के कथै, जउन राज हे फूट हुइ जाय ऊ नास हुइ जथै अउ जउन सहर या घर हे फूट हुइ जाय, ता ऊ बरबाद हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","अगर भुतवा भुतवन के निकाडथै, ता उन अपनै हे बैरी बन जथै ता उनखर राज कसना बने रही? ");
INSERT INTO bhu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","अगर मै भुतवन के मुखिया बालजबूल के मदद लग भुतवन के निकाडथों, ता तुम्हर टोरवा जेखर सहायता लग भुतवन के निकाडथै? इहैनिता उहै तुम्हर नियाव करही। ");
INSERT INTO bhu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","मै भुतवन के भगवान के आतमा के सक्ति लग निकाडथों, एखर लग हइ सिध्द होथै कि भगवान कर राज तुम्हर लिघ्घो आय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","फेर कउ बलवान मनसे के घर हे घुस के ओखर डेरा कसके चोराय सकथै, जब तक कि पहिले ऊ बलवान मनसे के बान्ध नेहको लेही, तबै ऊ ओखर घर के चोराय सकथै। ");
INSERT INTO bhu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","जउन मोर संग नेहको हबै ऊ मोर बैरी हबै अउ मोर संग अक्ठी जिघा नेहको करथै, समेटय हे मदद नेहको करथै, ऊ उनही भटकाथै। ");
INSERT INTO bhu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","इहैनिता तुम्हर लग कथो कि सबैमेर के बुराई अउ पाप के छमा के दय जही, पय पवितर आतमा के बुराई करै बाले मनसे के छमा नेहको करे जही। ");
INSERT INTO bhu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","जउन कउ मनसे कर टोरवा के बिरोध हे अगर कुछ कथै, ता उके छमा करे जा सकथै, पय पवितर आतमा के बिरोध हे कुछु कइहीं ता उके छमा नेहको करे जही न तो हइ दुनिया हे अउ न स्वरग हे। ");
INSERT INTO bhu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","अगर तुमही निक्खा फडुहा चाही ता निक्खा रूख होय, अगर रूख निक्खा नेहको हबै ता फडुहो निक्खा नेहको मिलही। ");
INSERT INTO bhu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","अरे सपुवा के लरका तुम बेकार हुइके कसके निक्खा बात गुठे सकथा? जउन मन हे भररे हर हबै उहै बात मुंह लग बाहिर निकडथै। ");
INSERT INTO bhu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","निक्खा मनसे मन हे निक्खा बात धररे हबै, उहै मसे निक्खा बात निकडथै अउ बेकार मनसे अपन बेकार मन लग बेकार बात निकडथै। ");
INSERT INTO bhu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","अउ “मै तुम्हर लग कथो, कि जउन-जउन बेकार बात मनसेन के मुंह लग निकडथै, ऊ नियाव के रोज ऊ हर अक्ठी बात के हिसाब देयका पडही। ");
INSERT INTO bhu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","काखे तुम अपन बातन लग बेकसूर अउ दोसी ठहराय जइहा।” ");
INSERT INTO bhu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","तब कुछ गुरू अउ फरीसी मनसे जबाब हे कथै, “गुरू जी हम तोर तरफ लग अक्ठी अदभुत निसानी देखै चाहथन।” ");
INSERT INTO bhu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","यीसु उनही जबाब दइके कथै, हइ युग के बेकार अउ अबिस्वासी मनसे चिन्हा देखै चाहथै, ग्यानी मनसे योना के चिन्हा के छांड के, उनही अउ कउनो निसानी नेहको दय जही। ");
INSERT INTO bhu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","जउन मेर योना तीन रोज अउ तीन रात अक्ठी केतका बड मछडी के लादा हे रथै, उहै मेर मनसे कर टोरवा तीन रोज अउ तीन रात भुंइ के भित्तर रही। ");
INSERT INTO bhu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","नियाव के दिन नीनवे सहर के रहै बाले निबासी हइ पीढी के मनसेन के संग ठाड हुइ अउ उनही दोसी ठहराही, काखे उन योना के संदेस सुनके मन बदलथै अउ देखा, इछो तो कउ कउनो योना लग बड के हबै। ");
INSERT INTO bhu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","नियाव के रोज दख्खिन के रानी हइ पीढी के मनसेन के संग ठाड होही अउ पाप करै के छांड दइहीं, काखे ऊ भुंइ के दूसर छोर लग सुलेमान के संदेस सुनै आथै अउ इछो तो सुलेमान लग महान हबै। ");
INSERT INTO bhu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","बेकार आतमा फेरै लग आथै, “जब कोनो भुतवा मनसे के छांडथै ता ऊ सुस्ताय के खोज हे झुराय हर जिघा हे भटकत रथै, पय उके सुस्ताय के जिघा नेहको मिल पाथै। ");
INSERT INTO bhu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","तब ऊ कथै कि जउन घर के मै छांडे रहों, मै फेरै लउट जहुं ता ऊ लउटथै अउ उके अब खाली, साफ सुथरा अउ सजररे हर पाथै। ");
INSERT INTO bhu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ता ऊ फेर लउटथै अउ अपन संग सातठे अउ भुतवन के लइके आथै जउन बोहत बेकार रथै, फेर ऊ सगलू भुतवा आय के उछो रहै लग जथै अउ ऊ मनसे के दसा आगू ले बत्तर जीवन हुइ जथै, आज के हइ बेकार मनसेन के दसा ओसनेन होही।” ");
INSERT INTO bhu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","यीसु मनसेन के भीड के सिक्छा देथै कि एतका हे ओखर दाय अउ भाई उछो आय के ठाड रथै, उन यीसु लग बात करै के चाहथै। ");
INSERT INTO bhu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","उन मनसेन के भीड मसे अकझन यीसु लग कथै, “देखा, तोर दाय अउ भाई बाहिर ठाड हबै अउ तोर लग बात करै के चाहथै।” ");
INSERT INTO bhu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","यीसु उनखर लग कथै, “कउन हबै मोर दाय? अउ कोनहर हबै मोर भाई।” ");
INSERT INTO bhu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","तब अपन चेलन के तरफ अंगिठियाथै ऊ कथै, “देखा, हइ हबै मोर दाय अउ मोर भाई। ");
INSERT INTO bhu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","काखे जउन कउ मोर स्वरग के बाफ के इक्छा के जसना काम करथै, उहै हबै मोर भाई बेहन अउ मोर दाय।” ");
INSERT INTO bhu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","उहै रोज यीसु ऊ घर के छांड के झील के टाठा हे सिक्छा देय के निता बइठ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ओखर लिघ्घो एतका बडा मनसेन के भीड जुड जथै कि यीसु अक्ठी नाह जिहाज हे बइठ जथै अउ सगलू भीड झील के पाखा हे ठाड रथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","अउ यीसु किस्सा सुनाय के, उनही बोहत कुछ बात सिखोय लागथै, “अक्ठी किसान बिजहा बोमै निकरथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","बोउत टेम कुछ बिजहा गली के पाखा हे गिरथै अउ चिरइया आय के उके खा लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","कुछ बिजहा पथरहली भुंइ हे गिरथै अउ खूब माटी नेहको मिलै के कारन हरबी दाना फुटुक जथै, काखे उहां माटी गहिड हे नेहको रथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","पय जब बेरा निकडथै अउ खूब घाम लगै लग पउधा झुराय जथै, काखे ऊ जर नेहको पकडे रथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","कुछ बिजहा पुडरा के बीच हे गिरथै, पय पुडरा बढके उके दबाय देथै।” ");
INSERT INTO bhu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","अउ कुछ बिजहा निक्खा भुंइ हे गिरथै अउ ऊ बढके बढिहा फडुहा लानथै, कोनो तीस गुना, कउनो साठ गुना अउ सव गुना। ");
INSERT INTO bhu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","जेखर “कान होय ऊ सुन ले।” ");
INSERT INTO bhu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","फेर यीसु के चेला आय के ओखर लग पूछथै, “तै काखे मनसेन के किस्सा हे सिक्छा हे बात करथस?” ");
INSERT INTO bhu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","यीसु चेलन के जबाब देथै, हइ इहैनिता हबै कि स्वरग राज के लुके हर के जानै के ग्यान तुमही दय गय हबै, उन मनसेन के नेहको। ");
INSERT INTO bhu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","काखे जेखर लिघ्घो हबै, उके अउ दय जही अउ ओखर लिघ्घो बोहत हुइ जही, पय जेखर लिघ्घो नेहको हबै, ओखर लग वहु लइ ले जही जउन ओखर लिघ्घो हबै। ");
INSERT INTO bhu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","इहैनिता मै उनखर लग किस्सा के परयोग करके बात करथो, काखे ऊ देखथै तउभरमा ऊ अंधरा बनथै अउ सुनथै तउभरमा ऊ नेहको सुनथै अउ नेहको समझथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","उनखर बारे हे यसायाह ग्यानी मनसे आगू कर बात कहे हर उनखर हे पूर होथै, तुम सुनिहा जरूर, पय नेहको समझिहा, तुम देखत तो रइहा पय तुमही कउनो ग्यान नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","काखे हइ मनसेन के मन बेकार हुइ गय हबै अउ हइ कान लग बोहत सुनै लगे हबै, उन अपन आंखी मूंद लय हबै, जेखर लग कहुं असना झइ होय कि आंखी लग देखै, अउ कानन लग सुनै, अउ दिमाक लग समझै, अउ मोर पल्ला लउट आमै, ता मै उनही निक्खा कर दो। ");
INSERT INTO bhu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","पय धन्य हबै तुम्हर आंखी काखे उन देखथै अउ धन्य हबै तुम्हर कान काखे उन सुनथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","मै तुम्हर लग सही कथो, ग्यानी मनसे अउ धरमी मनसे जउन बातन के देखै चाहथै अउ उन नेहको देख पाइन, पय तुम देखथा अउ जउन बातन के उन सुनै चाहथै, उनही तुम सुनथा, पय उन नेहको सुन पाइन। ");
INSERT INTO bhu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“अब तुम बिजहा बोमै बाले किसान के किस्सा कर मतलब सुना। ");
INSERT INTO bhu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ऊ बिजहा जउन गली कर टाठा हे गिरे रथै, ओखर मतलब हबै, कि जब कउ स्वरग के राज के संदेस सुनथै, अउ उके नेहको समझथै, ता भुतवा आय के ओखर मन हे जउन बिजहा बोय रथै उके चुराय लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ऊ बिजहा जउन पथरइला भुंइ हे गिरथै, ओखर मतलब हबै ऊ मनसे जउन संदेस सुनथै अउ उके खुसी लग हरबी अपनाय लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","पय ओखर तरी तक जर हे नेहको रथै अउ चुटु देर तक रही पाथै, जब संदेस के कारन कस्ट अउ दिग्गत आथै ता ऊ जलदिन घबरा जथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","पुडरा हे गिरे हर बिजहा कर मतलब हबै, ऊ मनसे जउन संदेस के सुनथै, पय दुनिया के चिंता अउ डेरा के लालच हे आय के परभु कर बचन के छांड देथै अउ ऊ मनसे आगू नेहको बड पाथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","निक्खा भुंइ हे गिरे हर बिजहा के मतलब हबै, ऊ मनसे जउन संदेस के सुनथै अउ समझथै ऊ आगू बड जथै, ऊ बिजहा तीस गुना अउ साठ गुना अउ सव गुना फडुहा लानथै।” ");
INSERT INTO bhu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","यीसु उनही अक्ठी अउ किस्सा सुनाथै, “स्वरग कर राज ऊ मनसे के जसना हबै, जउन अपन खेत हे बढिहा बिजहा बोय रथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","पय जब मनसे सोय रथै, तब ओखर बैरी आथै अउ गोहूं के बीच हे चारा बोय के कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","जब गोहूं फुटकथै अउ ओहमा बाली आथै, ता जंगली बिजहा के चारा दिखाई दइस। ");
INSERT INTO bhu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ता खेत के मालिक के लिघ्घो आयके ओखर हरवाह ओखर लग कथै, मालिक, तै खेत हे बढिहा बिजहा बोय रहस न? फेर हइ जंगली चारा के पउधा कछो लग आइस? ");
INSERT INTO bhu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","तब मालिक उनखर लग कथै, हइ कोनो बैरी के काम हबै, ओखर हरवाह ओखर पूछथै, तै का चाहथस कि हम जाय के चारा के नींद दइ? ");
INSERT INTO bhu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","मालिक जबाब दइस, नेहको, असना झइ होय कि जंगली चारा उखालत टेम गोहूं उखाल डारा। ");
INSERT INTO bhu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","गोहूं अउ जंगली चारा के काटै तक संग बढै देया, ऊ टेम मै मजदुरिहन के आदेस देहुं, जंगली चारा अक्ठी जिघा करके बोझा बांध देया, कि उनके लेस दय जाय, पय गोहूं मोर कोठला हे अक्ठी जिघा करा।” ");
INSERT INTO bhu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","यीसु उनखर आगू अक्ठी अउ किस्सा कथै, कि “स्वरग कर राज राई के दाना कर जसना हबै, जेही कोनो मनसे लइके अपन खेत हे बोय दय हबै। ");
INSERT INTO bhu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","राई बिजहा सगलू बिजहा लग नान तो हबै, पय बढके सगलू सबजी भाजिन लग बड्डे हुइ जथै अउ असना रूख बनथै, कि बादर के चिरइया आयके ओखर डगइल हे सोथै।” ");
INSERT INTO bhu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","यीसु अक्ठी अउ किस्सा सुनाथै, कि “स्वरग कर राज ऊ खमीर कर जसना हबै, जेही कोनो डउकी लइके तीन किलो पिसान हे मिला देथै, धीरे-धीरे ऊ खमीर हुइ गइस।” ");
INSERT INTO bhu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","यीसु किस्सन हे हइ सगलू बात मनसेन लग कथै, ऊ बिगर किस्सा के उनखर लग कुछु नेहको कथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","जेखर लग ग्यानी मनसे के हइ बात पूर हुइ जाय, मै किस्सा के दवारा बोलहुं, दुनिया के सुरुवात लग जउन लुके हबै, उके मै परगट करहुं। ");
INSERT INTO bhu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","यीसु मनसेन के बिदा करके घर आथै, ता उनखर चेला ओखर लिघ्घो आयके कथै, खेत के जंगली चारा के किस्सा हमके समझाय दे। ");
INSERT INTO bhu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","यीसु उनके जबाब देथै, बढिहा बिजहा बोमै बाले मनसे कर टोरवा हबै। ");
INSERT INTO bhu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","खेत दुनिया हबै, बढिहा बिजहा राज के लरका हबै, जंगली चारा भुतवा कर लरका हबै। ");
INSERT INTO bhu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","बोमै बाले बैरी भुतवा हबै, कटनी दुनिया कर आखरी हबै मजदूर स्वरगदूत हबै। ");
INSERT INTO bhu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","जउन मेर मनसे जंगली चारा के पउधा अक्ठी जिघा करके आगी हे लेस देथै, ओसनेन दुनिया कर आखरी हे होही। ");
INSERT INTO bhu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","मनसे कर टोरवा अपन स्वरगदूतन के पठोही अउ उन ओखर राज मसे सब मनसे ठोकड के कारन बनथै अउ अधरम करै बालेन के अक्ठी जिघा करही। ");
INSERT INTO bhu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","उनही आगी के कुन्ड हे डाल देही, उहां उन मनसे लगेतार रोहीं अउ दांत चबाउत रइहीं। ");
INSERT INTO bhu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","तब धरमी मनसे अपन बाफ भगवान कर राज हे, बेरा के जसना चमकही। जेखर कान होय ऊ सुन ले। ");
INSERT INTO bhu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“स्वरग कर राज खेत हे लुके हर डेरा के जसना हबै, जेही कोनो मनसे पाथै अउ उके लुकाय देथै अउ मगन हे ऊ अपन सगलू डेरा बेच के ऊ खेत के खरीद लेथै।” ");
INSERT INTO bhu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“स्वरग कर राज ऊ सेठ के जसना हबै, जउन निक्खा मोती के खोज हे रथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","जब उके अक्ठी कीमती मोती मिलिस, ता ऊ जायके अपन सगलू कुछु बेच दइस अउ ऊ मोती के खरीद लइस।” ");
INSERT INTO bhu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","फेर स्वरग कर राज समुन्दर हे डाले हर ऊ जाला के जसना हबै, जउन हरमेर के मछडी समेट लानथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","जब जाला भर गइस ता ढिमरा उके टाठा हे खींच लानथै, तब उन बइठके निक्खा मछडी चुन चुनके छन्नी हे जमा करथै अउ बेकार मछडी फटक देथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","दुनिया कर आखरी हे असनै होही, स्वरगदूत आयके अउ धरमी मनसे मसे, पापिन मनसेन के नबेर के अलग करही। ");
INSERT INTO bhu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","अउ उनके आगी के कुन्ड हे डाल देही, उहां उन मनसे रोइहीं अउ दांत पिसहिन। ");
INSERT INTO bhu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","यीसु अपन चेलन लग कथै, “तुम हइ सगलू बात समझथा?” उन जबाब देथै, जी “हंव।” ");
INSERT INTO bhu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","यीसु अपन चेलन लग कथै, “हइ कारन सगलू नियम के गुरू जउन स्वरग कर राज के चेला बने हबै, ऊ अक्ठी असना घर के मालिक के जसना हबै, जउन अपन मन लग नबा अउ पुरान चीज निकाडथै।” ");
INSERT INTO bhu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","यीसु किस्सा के खतम करके उहां लग कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","यीसु अपन देस छो आइस अउ मनसेन के यहूदी मंडली हे सिक्छा देय लगथै, चकित हुइके कथै “इके हइ दिमाक अउ अदभुत काम करै के सक्ति कछो लग मिलिस? ");
INSERT INTO bhu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","का हइ कारीगर कर टोरवा नेहको हबै? का मरियम एखर दाय नेहको? का याकूब, यूसुफ, समोन अउ यहूदा एखर भाई नेहको? ");
INSERT INTO bhu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","का एखर सगलू बेहन हमर बीच नेहको रथै? ता हइ सगलू इके कछो लग मिलिस?” ");
INSERT INTO bhu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","उन यीसु के परति गुस्सा लग भर गइन। हइ बात हे यीसु उनखर लग कथै, अपन सहर अउ अपन घर के अलाबा ग्यानी मनसे कहुं बेज्जती नेहको होथै। ");
INSERT INTO bhu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","मनसेन के अबिस्वास के कारन यीसु ऊ सहर हे बोहत सक्ति के काम नेहको करिस। ");
INSERT INTO bhu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","उहै टेम हेरोदेस जउन देस के अक्ठी गलील के सासन हेरोदेस के राजा रथै, यीसु के बारे हे सुनथै। ");
INSERT INTO bhu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ऊ अपन सेबकन लग कथै, हइ बतिस्मा देय बाले यूहन्ना हबै मरे हर मसे जिन्दा हुइ गय, इहै कारन हबै कि चकित के काम करै के सक्ति एहमा मउजूद हबै। ");
INSERT INTO bhu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","हेरोदेस अपन भाई फिलिप्पुस के डउकी हेरोदियास के कारन यूहन्ना के गिरिपतार करिस अउ उनके बांध के जेल हे बेडवा दइस। ");
INSERT INTO bhu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","काखे यूहन्ना ओखर लग कहे रथै, “भाई के डउकी के रखैके तोर निता उचित नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","हेरोदेस यूहन्ना के मार डालै चाहथै, पय ऊ मनसेन लग डरथै, काखे मनसे यूहन्ना के ग्यानी मनसे मानथै। ");
INSERT INTO bhu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","हेरोदेस के जनमदिन के मउका हे हेरोदियास के टोरिया पहुनन के आगू नाचके हेरोदेस के बोहत मगन करिस ");
INSERT INTO bhu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","कि ऊ किरिया खाय के ऊ “जउन कुछु चाहबे उके देयका जुबान दइस।” ");
INSERT INTO bhu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ओखर दाय उके पहिलेन लग सिखाय दय रथै, इहैनिता ऊ बोलिस, “मोके इहै टेम टठिया हे यूहन्ना बतिस्मा देय बाले के मूड चाही।” ");
INSERT INTO bhu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","हेरोदेस राजा के बोहत दुख हुइस, पय अपन किरिया अउ पहुनन के कारन ऊ ओखर मांग पूर करै के आदेस देथै, यूहन्ना के मूड इके दइ देया। ");
INSERT INTO bhu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","अउ हेरोदेस राजा अपन सुपाहिन के जेल हे पठोय के यूहन्ना के मूड कटवाय दइस। ");
INSERT INTO bhu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","यूहन्ना के मुन्डी टठिया हे लाय गइस अउ टोरिया के दइ दे गइस अउ ऊ उके अपन दाय के लिघ्घो लइ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","यूहन्ना के चेला आइन अउ उन ओखर लोथ लइ गय, उन उके मरघटी हे रखथै अउ जायके यीसु के एखर खबर दइन। ");
INSERT INTO bhu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","यीसु हइ खबर सुनके उहां लग नाह जिहाज हे चढके अक्ठी पटउरा के पल्ला सूनसान हे कढ गइस, जब मनसेन के एखर पता चलिस, तब उन सहरन लग निकर के पइदल ओखर पाछू चल दइन। ");
INSERT INTO bhu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","जब यीसु नाह जिहाज लग बाहिर निकडके टाठा हे आथै, ता ऊ बोहत मनसे के भीड देखथै, ता उके उनखर हे दया आथै अउ ऊ उनखर नंगहन के निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","संझा होय लग चेला ओखर लिघ्घो आयके कथै, परभु हइ सूनसान जिघा हबै अउ बोहत देरी हुइ गय हबै, इहैनिता भीड के जाय दे, ता गांव हे जायके अपन खाय के निता कुछु खरीद लइ आमै। ");
INSERT INTO bhu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","यीसु जबाब दइस “इनही कहुं जाय के जरूरत नेहको हबै, तुमै करा इनखर निता खाय के जुगाड।” ");
INSERT INTO bhu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","चेला ओखर लग कथै, “हमर लिघ्घो पांचठे रोटी अउ दुइठे मछडी के छांड अउ कुछु नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","यीसु कथै, “उनके मोर लिघ्घो लइ आन।” ");
INSERT INTO bhu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","यीसु मनसेन के चारा हे बइठै के आदेस दइस, तब ऊ पांच रोटी अउ दुइठे मछडी अपन हाथ हे लइके स्वरग के पल्ला खाना के निता धन्यबाद देय के बाद, रोटी टोर-टोर के चेलन के दइस अउ चेला मनसेन के। ");
INSERT INTO bhu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","सगलू मनसेन पेट भर खथै अउ एखर अलाबा बचे हर रोटी के खन्डन के चेला बाराठे छन्नी उठाथै। ");
INSERT INTO bhu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","भोजन करै बाले मसे डउकी अउ लरकन के छांड के करीबन पांच हजार डउका रथै। ");
INSERT INTO bhu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","एखर तुरन्त बाद यीसु अपन चेलन के नाह जिहाज हे चढाइस, कि उन नाह जिहाज हे चढके उनखर लग आगू झील के ऊ पार कढ जाय, जब तक ऊ मनसेन के बिदा कर सकै। ");
INSERT INTO bhu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","यीसु मनसेन के बिदा करै के बाद, भगवान बाफ लग बिनती करै के डोंगर छो कढ गइस अउ संझा होय लग ऊ उछो अकेल्ले रथै। ");
INSERT INTO bhu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","नाह जिहाज ऊ टेम झील के टाठा लग झील के बीचोबीच हे जाय चुकथै, ऊ लेहरा लग नाह जिहाज डोलथै, काखे हबा आगू लग चलथै। ");
INSERT INTO bhu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","सुब्बेन लगभग तीन अउ छय बजे के टेम के बीच यीसु झील हे चलत उनखर लिघ्घो आइस। ");
INSERT INTO bhu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ओखर चेला जब यीसु के झील हे चलत देखथै, ता उन चकराय के अपने हे गुठेमै लगथै, हइ तो कउनो भुतवा हबै अउ उन डर के मरे किरराय उठिन। ");
INSERT INTO bhu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","यीसु उनखर लग हरबी कथै, हिम्मत धरा, मै यहों, झइ डर। ");
INSERT INTO bhu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पतरस ओखर लग कथै, परभु अगर तहिन हबस ता मोके आदेस दे, कि मै पानी हे रेंगत तोर लिघ्घो आय जांव। ");
INSERT INTO bhu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","यीसु कथै, “आ जा।” पतरस नाह जिहाज लग उतरथै अउ पानी हे रेंगत यीसु के पल्ला बढिस। ");
INSERT INTO bhu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ऊ जब तेज हबा देखथै, ता ऊ डर गइस, जब ऊ बुडै लगिस ता किरराय के कथै, “हे परभु मोके बचा।” ");
INSERT INTO bhu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","यीसु हरबी हाथ बढाय के उके पकड लेथै अउ कथै, “हे चुटु बिस्वास करे बाले, तै संका काखे करथस।” ");
INSERT INTO bhu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","तब उन दुनो नाह जिहाज हे चढ जथै अउ हवा रुक गइस। ");
INSERT INTO bhu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","जउन चेला नाह जिहाज हे रथै, उन यीसु के परनाम करथै अउ कथै, “तै सही हे भगवान कर टोरवा हबस।” ");
INSERT INTO bhu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","दहार पार करके उन गन्नेसरत गांव के भुंइ हे आइन। ");
INSERT INTO bhu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","उहां के मनसे यीसु के चीन लइन अउ अगल बगल के सगलू गांव हे खबर फइलाय दइन अउ सबमेर के नंगहन के यीसु के लिघ्घो लानथै। ");
INSERT INTO bhu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","अउ ओखर लग बिनती करै लग जथै, कि ऊ उनके अपन खुरथा पइजामा के छोर के छियदे अउ जेतका झन छीथै अउ सगलू मेर के नंगहा लग निक्खा हुइ गइन। ");
INSERT INTO bhu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","तब यरुसलेम लग कुछ फरीसी अउ नियम के गुरू यीसु के लिघ्घो आयके कहै लगथै। ");
INSERT INTO bhu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","तोर चेला हमर सियानन के रीति रिबाज के काखे नेहको मानथै? बिना हाथ धोय रोटी खथै। ");
INSERT INTO bhu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","यीसु जबाब देथै, अपन रीति रिबाज के कारन तुम भगवान के आदेस के काखे उलंघन करथा? ");
INSERT INTO bhu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","भगवान कथै, अपन बाफ अउ अपन दाय के इज्जत के अउ जउन कउ अपन बाफ या अपन दाय के बेज्जती करथै, उके जरूर मार दय जाय चाही। ");
INSERT INTO bhu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","पय तुम कथा जउन कउ अपन बाफ या अपन दाय लग कथै, काखे मै अपन सगलू कुछु भगवान के बलि चढाय जाय चुके हबै, जेखर लग मै जेखर तुम्हर मदद कर सको। ");
INSERT INTO bhu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","तब लग ओखर लग अपन बाफ के आदर करै के जरूरी नेहको समझथा, इहैमेर तुम अपन रीति रिबाज के निता भगवान के आदेस के टोरत हबा। ");
INSERT INTO bhu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","अरे ढोंगहा तुम्हर बारे हे यसायाह आगू कर बात ठीक गुठे रहिस, ऊ निक्खा कहे रथै, ");
INSERT INTO bhu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","हइ मनसे सिबाय अपन मुंह लग मोर इज्जत करथै, पय इनखर मन मोर लग दुरिहां हबै। ");
INSERT INTO bhu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","मोर निता उनखर उपास बेकार हबै, काखे उनखर सिक्छा सिबाय मनसेन के दवारा बनाय हर नियम हबै। ");
INSERT INTO bhu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","तब यीसु मनसेन के अपन लिघ्घो बुलाय के उनखर लग कथै, “सुना अउ समझा। ");
INSERT INTO bhu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","मनसे के मुंह के भित्तर लग जउन कुछु जथै, ऊ मनसे के असुध्द नेहको करथै, बलुक ओखर मुंह लग निकडे हर सब्द उके असुध्द करथै।” ");
INSERT INTO bhu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","तब चेला आयके यीसु लग कथै, “का तोके पता हबै, कि तोर सब्द लग फरीसी के बोहत बेकार लगथै?” ");
INSERT INTO bhu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","यीसु जबाब देथै, हर अक्ठी पउधा जेही स्वरग हे मोर बाफ नेहको लगाय हबै, उके उसेल दय जही। ");
INSERT INTO bhu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","उनही छांडा अउ अंधरन के अंधरा नेता हबै, इहैनिता अक्ठी अंधरा दुसर अंधरा के गली दिखाथै, ता ऊ दोनो झन खोदरा हे गिरही। ");
INSERT INTO bhu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","हइ सुनके पतरस ओखर लग कथै, “हमके असुधता के बारे हे अउ किस्सा के मतलब हमके गुठे।” ");
INSERT INTO bhu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","यीसु कथै, “का तुम अबहुन तक नेहको समझे हबा? ");
INSERT INTO bhu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","काखे तुम हइ नेहको समझथा कि जउन कुछु मुंह लग जथै, ऊ लादा लग हुइके बाहिर निकड जथै? ");
INSERT INTO bhu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","पय जउन कुछ मुंह लग बाहिर आथै, ऊ मन लग निकडथै, इहैनिता मनसेन के असुध्द करथै। ");
INSERT INTO bhu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","काखे कि बेकार सोच हत्या करै बाले, दूसर के डउकी, गलत काम करै बाले, चोरटा, झूठ गवाह अउ चुगुलखोरी हइ सब मन लग निकडथै। ");
INSERT INTO bhu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","इहै हबै जउन मनसेन के असुध्द करथै, बेगैर हाथ धोय भात खाय लग मनसेन के असुध्द नेहको करथै।” ");
INSERT INTO bhu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","फेर यीसु उछो लग निकडके सूर अउ सैदा परदेस छो कढ गइन। ");
INSERT INTO bhu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ऊ इलाका लग अक्ठी गैर यहूदी डउकी आथै अउ किरराय लागथै, “हे परभु दाऊद के टोरवा मोर हे दया के, मोर टोरिया के भुतवा बोहत परसान करथै।” ");
INSERT INTO bhu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","यीसु ओखर लग कुछु नेहको कथै, ता ओखर चेला ओखर लिघ्घो आथै अउ बिनती करै लग जथै, “इके बिदा करा, काखे ऊ हमर पाछू किररावत हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","यीसु जबाब देथै, “मोके सिबाय इस्राएल के मनसेन के भुलाय हर गेडरा के बिना कउनो अउ के निता नेहको पठोय गय हबो।” ");
INSERT INTO bhu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ता ऊ डउकी यीसु के आगू निहुर के परनाम करथै, “हे परभु मोर मदद के।” ");
INSERT INTO bhu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","यीसु जबाब दइके कथै, हइ सही नेहको हबै कि “लरकन के खाना लइके उके कुकरा के आगू डाल दय जाय।” ");
INSERT INTO bhu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ऊ डउकी कथै, “हइ सही हबै परभु पय इहां तक कि कुकरा अपन मालिक के टेबुल लग गिरे हर जूठा लग अपन लादा भर लेथै।” ");
INSERT INTO bhu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","तब यीसु कथै, “हे डउकी तोर बिस्वास बोहत बडा हबै, जउन तै चाहथस ऊ पूर होय।” अउ ओखर टोरिया उहै टेम निक्खा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","फेर यीसु उछो लग चल दइस अउ गलील परदेस के दहार के टाठा हे पहुंचिस, ऊ अक्ठी डोंगर हे चढके बइठ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","तब बडा भीड यीसु के लिघ्घो आ गइस, जेहमा लेंगरा, लुलवा, अंधरा, बउरा अउ कइनमेर के नंगहा मनसे रथै अउ मनसे इन के यीसु के गोड के लिघ्घो सोबाय देथै अउ यीसु उनके निक्खा कर देथै। ");
INSERT INTO bhu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","जब भीड देखथै कि बउरा बोलथै, अपंग निक्खा होथै अउ लेंगरा रेंगथै, अंधरा देखथै, ता चकित हुइके इस्राएल के मनसे भगवान के महिमा करथै। ");
INSERT INTO bhu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","तब यीसु अपन चेलन के लिघ्घो बुलाथै अउ कथै, “मोके हइ भीड हे दया आउत हबै, काखे हइ मनसे तीन रोज लग लगेतार मोर संग हबै अउ इनखर लिघ्घो कुछु खाय के निता नेहको हबै, मै इनके भूखे नेहको पठोमै चाहथो काखे हुइ सकथै, कउ रास्ता हे थक के बिहोस झइ हुइ जाय।” ");
INSERT INTO bhu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","तब ओखर चेला कथै, “एतका बडा भीड के निता असना पतेरा जिघा हे एतका खाना हमके कछो लग मिलही?” ");
INSERT INTO bhu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","तब यीसु उनखर लग पूछथै, “तुम्हर लिघ्घो केतका रोटी हबै?” उन कथै “सातठे रोटी हबै अउ कुछ नान-नान मछडी हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","यीसु मनसेन के भुंइ हे बइठे के निता आदेस देथै। ");
INSERT INTO bhu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","अउ यीसु सातठे रोटी अउ कुछ मछडी के लइस, भगवान के धन्यबाद करके टोरथै अउ अपन चेलन के दइस अउ फेर चेला मनसेन के दइन। ");
INSERT INTO bhu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","मनसेन तब तक खात रथै, जब तक उनखर लादा नेहको भर गइस, फेर ओखर चेला बचे हर खंडन लग सात टोपरी रोटी भरिन। ");
INSERT INTO bhu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","डउकी अउ लरकन के छांड के उहां चार हजार डउका रथै। ");
INSERT INTO bhu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","भीड के बिदा करके यीसु नाह जिहाज हे चढके, मगदन गांव के इलाका हे आइन। ");
INSERT INTO bhu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","फरीसी अउ सदूकी मनसे यीसु के लिघ्घो आथै, उन यीसु के परिक्छा के निता यीसु लग बिनती करथै, “तै हमके कउनो स्वरग कर चिन्हा दिखा।” ");
INSERT INTO bhu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","यीसु उनखर लग कथै, “सांझ के टेम तुम कथा, मउसम निक्खा रही, काखे बादर लाल हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","सुब्बेन होय लग कथा, “आज आंधी आही, काखे बादर लाल अउ बादर लग घेररे हर हबै, तुम बादर के इसारा के चीन लेथा, पय टेम के चिन्हा के भेद काखे नेहको चीनथा। ");
INSERT INTO bhu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","हइ दुस्ट अउ अबिस्वासी मनसे निसानी खोजथा, पय ग्यानी मनसे योना के निसानी के छांडके अउ कउनो चिन्हा उनही नेहको दय जही।” अउ यीसु उनही छांड के कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","यीसु के चेला दहार के दूसर पल्ला जात टेम, रोटी लेय के बिसर जथै। ");
INSERT INTO bhu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","यीसु उनखर लग कथै, “देखा, फरीसी अउ सदूकी के खमीर ग्यान लग बचे रइहा।” ");
INSERT INTO bhu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ऊ अपनै हे सोचै लग जथै, कि “हम रोटी नेहको लाय हबन इहैनिता यीसु असना कथै।” ");
INSERT INTO bhu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","यीसु उनखर मन के बात जान के कथै, “हे चुटु बिस्वास करै बाले मनसे, तुम हइ काखे सोचथा कि हमर लिघ्घो रोटी नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","तुम अबहुन तक हे नेहको समझ पाय हबा का? सुरता करा कि उन पांच हजार मनसेन के निता पांचठे रोटी हे पुर गय रहिस अउ केतका छन्नी भर रोटी उठाय रहा। ");
INSERT INTO bhu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","अउ तुमही सुरता नेहको हबै कि चार हजार मनसेन के निता सातठे रोटी अउ फेर तुम केतका टोपरी रोटी उठाय रहा। ");
INSERT INTO bhu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","काखे नेहको समझथा, कि मै रोटी के बारे हे हइ नेहको गुठेथो, बकि फरीसी अउ सदूकी के खमीर लग सचेत रहैके कथो।” ");
INSERT INTO bhu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ता चेला समझ गइन कि यीसु रोटी के खमीर लग नेहको, बकि फरीसी अउ सदूकी के सिक्छन लग बचे रहैका कथै। ");
INSERT INTO bhu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","जब यीसु कैसरिया फिलिप्पी हे आथै, ता ऊ अपन चेलन लग पूछथै, “मनसे कर टोरवा के बारे हे काहिन कथै, कि मै कोन हबो?” ");
INSERT INTO bhu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","चेला जबाब देथै, “कुछ मनसे कथै तै पानी हे बतिस्मा देय बाले यूहन्ना हबस, दूसर मनसे कथै, तै एलिय्याह हबस अउ मनसे कथै, तै इरमियाह ग्यानी मनसे मसे कोनो अक्ठी हबस।” ");
INSERT INTO bhu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","यीसु चेलन लग कथै, तुम मोके काहिन कथा कि मै कोनहर हबो? ");
INSERT INTO bhu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","समोन पतरस जबाब देथै, “तै मसीह हबस, तै जिन्दा भगवान कर टोरवा हबस।” ");
INSERT INTO bhu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","यीसु उके कथै, “हे समोन, यूहन्ना के टोरवा तै धन्य हबस, काखे गूदा अउ खून नेहको पय हइ बात कोनो मनसे लग नेहको, बकि मोर बाफ जउन स्वरग हे हबै, हइ बात तोर हे परगट करे हबै। ");
INSERT INTO bhu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","मै तोर लग कथो कि तै पतरस हबस अउ इहै पथरा हे मै अपन मंडली बनाहुं अउ नरक के सक्ति ओहमा हाबी नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","मै तोके स्वरग राज के चाभी देथो, ताकि भुंइ हे जउन कुछु तै बंधहे ऊ भगवान के दवारा स्वरग छो बंधर जही अउ जउन कुछु तै भुंइ हे खोलबे ऊ स्वरग हे उघरही।” ");
INSERT INTO bhu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","फेर यीसु अपन चेलन के चेताथै, कि तुम कोनो मनसेन के झइ गुठेहा कि मै मसीह हबो। ");
INSERT INTO bhu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","उहै टेम लग यीसु अपन चेलन के गुठेमै लग जथै, कि “मोके यरुसलेम नगर छो जायके पडही अउ जरूरी हबै कि मै उछो पुजारी, सियान अउ गुरू के हाथ लग बोहत दुख उठाय जहुं अउ मार डारे जइहों अउ तीसर रोज जिन्दा हुइ जइहों।” ");
INSERT INTO bhu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","पतरस यीसु के अलगेन लइ जाय के गधार के कथै, “हे परभु भगवान तोर हे दया करै। तोर संग असना कबहुन झइ होय।” ");
INSERT INTO bhu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","यीसु पतरस के पल्ला फिर के कथै, “हे भुतवा मोर आगू लग दुरिहां कढ जा, तुम मोर ठोकड के कारन बनत हबस, तुम भगवान कर बातन हे नेहको बकि मनसेन के बात सोचथस।” ");
INSERT INTO bhu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","फेर यीसु अपन चेलन लग कथै, “जउन कोनो मोर पाछू आमै चाहथै, ता अपन खुद के इंकार अउ पापन के छांड देय अउ अपन क्रूस उठाय के मोर पाछू हुइ जा। ");
INSERT INTO bhu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","जउन कउ अपन जीव बचामै चाहथै, ऊ उके खोही, पय जउन कउ मोर निता अपन जीवन खोही, उहै उके पाही। ");
INSERT INTO bhu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","अगर कउ अपन जीवन दइके सगलू दुनिया के पाय जही ता उके काहिन फायदा? अपन जीवन के फेरै लग पामै के निता कउ भला काहिन दइ सकथै? ");
INSERT INTO bhu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","काखे मनसे कर टोरवा अपन स्वरगदूतन के संग अपन बाफ के महिमा हे जलदी आमै बाले हबै अउ ऊ अक-अक्ठी मनसेन के उनखर करम के जसना मेर सजा देही। ");
INSERT INTO bhu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","मै तुम्हर लग सही कथो, इछो कुछ असना मनसे ठाड हबै, तब तक नेहको मरही जब तक उन मनसे कर टोरवा के ओखर राज हे आउत नेहको देख लेही।” ");
INSERT INTO bhu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","छय रोज कर बाद यीसु पतरस, याकूब अउ ओखर भाई यूहन्ना के अक्ठी ऊंच डोंगर छो अपन संग लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","उछो उनखर आगू यीसु कर सकल बदल गइस, ओखर मुंह बेरा के जसना चमक उठिस अउ ओखर बन्डी असना चमकै लगिस जसना उजियार मेर ");
INSERT INTO bhu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","अउ उहां चेलन के मूसा अउ नबी एलिय्याह उनखर संग बात चीत करत दिखाई देथै। ");
INSERT INTO bhu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","तब पतरस यीसु लग कथै, परभु हमर निता निक्खा हबै कि हम सगलू इहै रहबो, अगर तै आदेस दे ता हम तीनठे माडा बनाबो, अक्ठी तोर निता अउ मूसा निता अउ अक्ठी एलिय्याह कर निता। ");
INSERT INTO bhu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","पतरस हइ बात करत रथै कि अक्कैदारिन बादर के छाया आयके यीसु के ढाप लेथै, ता बादर लग आरो आथै, “हइ मोर पिरिया टोरवा हबै, मै एखर लग बोहत खुस हव, एखर बातन के सुना।” ");
INSERT INTO bhu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","जब चेला हइ बात के सुनथै, ता ऊ डर के मारे मुंह के बल गिर पडथै। ");
INSERT INTO bhu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","तब यीसु उनखर लिघ्घो आथै अउ उनके छि के कथै, “झइ डेराबा, ठाड हुइ जा।” ");
INSERT INTO bhu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","जब उन अपन आंखी उठाइन ता यीसु के सिबाय अउ कउनोन के नेहको देखथै। ");
INSERT INTO bhu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","जब यीसु डोंगर लग तरी उतरत टेम यीसु उनही आदेस देथै, “जउन कुछ तुम देखे हबा, तब तक कउनो के झइ गुठेहा, जब तक मनसे कर टोरवा के मरे हर मसे जिन्दा नेहको हुइ जाय।” ");
INSERT INTO bhu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","फेर चेला ओखर लग पूछथै, “ता गुरू हइ काखे कथै, कि आगू एलिय्याह के आमै के जरूरी हबै?” ");
INSERT INTO bhu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","यीसु जबाब देथै, एलिय्याह जरूर आमै बाले हबै अउ ऊ सगलू कुछु सुधारही। ");
INSERT INTO bhu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","पय मै तुम्हर लग सही कथो, कि एलिय्याह आय चुके हबै अउ मनसे ओहि नेहको चीन्हिन, पय जसना चाहिन ओसनेन ओखर संग करिन, इहैनिता मनसे कर टोरवा उनखर हाथ लग दुख उठाही। ");
INSERT INTO bhu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","तब चेला समझ जथै, कि यीसु यूहन्ना पानी हे बतिस्मा देय के बारे हे कथै। ");
INSERT INTO bhu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","जब यीसु भीड के लिघ्घो पहुंचथै, ता अक्ठी मनसे ओखर लिघ्घो आथै अउ घुटवा टेक के कथै। ");
INSERT INTO bhu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“हे परभु, मोर टोरवा के उप्पर दया कर उके मिरगी मारथै, ऊ बोहत तडपथै, ऊ आगी हे या कबहुन पानी हे गिर जथै। ");
INSERT INTO bhu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","मै तोर चेला के लिघ्घो लइ गय रहों, पय तोर चेला ओहि निक्खा नेहको कर सकिन।” ");
INSERT INTO bhu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","तब यीसु कथै, “हे अबिस्वासी अउ बेकार मनसे, मै तुम्हर संग कब तक रइहों? तुम्हर कब तक सइहों? ओही मोर लिघ्घो लाबा।” ");
INSERT INTO bhu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","तब यीसु भुतवा के आदेस देथै अउ भुतवा ओखर भित्तर लग निकड जथै अउ ऊ उहै टेम लरका निक्खा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","फेर चेला अकेले हे यीसु कर लिघ्घो आयके पूछथै, “कि हम भुतवा के काखे नेहको निकाड सकन?” ");
INSERT INTO bhu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","यीसु उनखर लग कथै, तुम्हर भित्तर बिस्वास कर कमी हबै, मै तुम्हर लग सही कथो कि अगर तुम्हर लिघ्घो राई के दाना के बरोबर बिस्वास हबै, ता तुम हइ डोंगर लग कइहा इछो लग उछो कढ जा, ता ओसनेन होही अउ तुम्हर निता कुछु काम कठिन नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","पय हइ भुतवन के झुन्ड बिनती अउ उपास के बगैर नेहको निकडथै। ");
INSERT INTO bhu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","जब सगलू चेला गलील सहर हे आइन तब यीसु उनखर लग कथै, “मनसे कर टोरवा उन मनसेन के हाथ पकडोय जाय बाले हबै, ");
INSERT INTO bhu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","अउ ओहि मार डलहिन, पय ऊ तीसर रोज के बाद फेरै जिन्दा हुइ जही।” तब हइ बात सुनके चेला बोहत दुखी हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","जब यीसु अउ ओखर चेला कफरनहूम सहर हे आथै, ता जउन मंडली के पइसा उगाहै बाले आयके पतरस लग कथै, “का तुम्हर गुरू मंडली के पइसा नेहको देथै?” ");
INSERT INTO bhu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","पतरस जबाब देथै, “हव, देथै” जब पतरस घर हे पहुंचिस। ता ओखर बोलै लग पहिले यीसु पूछथै, “हे समोन तुम काहिन सोचथा? हइ भुंइ के राजा करजा केखर लग लेथै? अपन नागरिक लग।” ");
INSERT INTO bhu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पतरस कथै, “दूसर के लरकन लग।” तब यीसु ओखर लग कथै, “नागरिक के पइसा नेहको देय चाही। ");
INSERT INTO bhu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","तउभरमा हम उनखर ठोकड के कारन झइ बनब, तै पानी के दहार हे बनसी लगाबे अउ जउन आगू मछडी पकड हे आही ओखर मुंह के उघारत टेम तुमके चांदी के अक्ठी खोटन्ना मिलही, उके ले आबे अउ मोर बदला पइसा दइ दइहा।” ");
INSERT INTO bhu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","तब यीसु के चेला ओखर लिघ्घो आय के पूछथै, “स्वरग कर राज हे सबले बडा कोन हबै?” ");
INSERT INTO bhu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","यीसु अक्ठी नान लरका के अपन लिघ्घो बुलाय के उनखर बीच हे ठाड करके कथै। ");
INSERT INTO bhu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","मै तुम्हर लग सही कथो, जब तक कि तुम नेहको बदलिहा अउ लरकन के जसना नेहको बन जइहा, तब तक स्वरग कर राज हे घुस नेहको सकिहा। ");
INSERT INTO bhu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","स्वरग कर राज हे सब लग बड्डे ऊ हबै, जउन खुद के कोमर करथै अउ ऊ लरकन के जसना बन जथै। ");
INSERT INTO bhu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","अउ जउन कउ मोर नाम लग नान लरका के सोगत करथै, ऊ मोर सोगत करथै। ");
INSERT INTO bhu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","जउन कउ मोर उप्पर बिस्वास करे बाले के कउनो अकझन के बिस्वास लग बहकाथै, ता ओखर निता इहै निक्खा होतै कि ओखर नटेरी हे चकिया के पथरा बांधे जातिस अउ ऊ गहीर समुन्दर हे बुडाय दय जातिस, ");
INSERT INTO bhu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","हइ दुनिया हे मनसेन के ठोकड के कारन बनथै इहैनिता हइ दुनिया के हाय। ");
INSERT INTO bhu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","अगर तोर हाथ या गोड तोर रुकावट बनै, ता उके खपलके फटक देय, तोर निता इहै निक्खा होही कि तुम लेंगरा या लुलवा हुइके जीवन हे घुसा, पय दुइठे हाथ या दुइठे गोड के रहत भरमा तै सबरोज के निता आगी हे डालय जाय। ");
INSERT INTO bhu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","अगर तोर आंखी पाप के कारन बनै, ता ओही निकाडके अपन लग दुरिहां फटक दे, इहै निक्खा हबै अन्धरा हुइके तै जीवन हे घुसबे, पय दुइठे आंखी के रहत भरमा तै नरक के आगी हे डालय जाय। ");
INSERT INTO bhu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","इहैनिता देखा, मोर इन नान मसे कउनो अक्कोझन के बेकार झइ समझिहा, काखे मै तुम्हर लग कथो, कि स्वरग हे उनखर स्वरगदूत सबरोज मोर बाफ के नजर हे रथै। ");
INSERT INTO bhu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","काखे मनसे कर टोरवा भुलाय हर के बचामै आय हबै। ");
INSERT INTO bhu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","तुम्हर काहिन बिचार हबै? अगर अक्ठी मनसे के लिघ्घो सवठे गेडरा होंय, उनखर मसे अक्ठी गेडरा भुलाय जथै, ता ऊ निन्यानबे के छांड के भुलाय हर अक्ठी गेडरा के खोजै के निता नेहको जही? ");
INSERT INTO bhu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ऊ जरूर जही अउ जब ऊ पाय जही, ता मै सही कथो, कि भुलाय हर गेडरा के निता बोहत मगन होही, जेतना निन्यानबे के निता नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","हइ मेर लग तुम्हर स्वरग के बाफ नेहको चाहथै, कि हइ नान मसे कउनो अक्कोठे नास होय। ");
INSERT INTO bhu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","अगर तुम्हर भाई तोर बिरोध अपराध करथै, ता अकेल्ले हे जाय के ओही समझा, अगर ऊ तोर बात के सुनही, ता तै अपन भाई के जीत लय हबस। ");
INSERT INTO bhu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","अगर ऊ नेहको सुनथै, ता अक्ठी दुइ झन के अपन संग लइ जा, तब दुइ या तीनठे गवाह लग हर बात के फइसला करे जही, दुइठे या तीन गवाह लग निहचित करे जाय, जसना कि हइ पवितर किताब कथै। ");
INSERT INTO bhu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","अगर ऊ उनखरो नेहको सुनथै, ता मंडली लग गुठे दे, पय ऊ मंडली के बात नेहको सुनथै, ता तै उके गैर यहूदी मनसे अउ पइसा उगाहै बाले जसना समझ ले। ");
INSERT INTO bhu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“मै तुम्हर लग सही कथो, कि जउन कुछ तुम हइ भुंइ हे बंधिहा ऊ स्वरग हे बंधरही, जउन कुछ तुम हइ भुंइ हे छोरिहा ऊ स्वरग हे छोररही।” ");
INSERT INTO bhu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","मै फेरै तुम्हर लग सही कथो, कि अगर कउनो के बारे हे तुम मसे दुइ झन भुंइ हे अक्ठी मन होय के मंगिहा ता स्वरग हे रहै बाले मोर बाफ के दवारा ऊ मिल जही। ");
INSERT INTO bhu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","काखे जिहां कहुं मोर नाम लग दुइ या तीन झन अकजुट होथै, उछो उनखर बीच हे मै खुद होतो। ");
INSERT INTO bhu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","तब पतरस ओखर लिघ्घो आयके कथै, “हे परभु, मोके अपन भाई के केतका बार अपन तरफ लग अपराध करै हे छमा कर देयका चाही? का सात बेर तक?” ");
INSERT INTO bhu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","यीसु उनखर लग कथै, मै हइ नेहको कथो, “कि सिबाय सात बार, पय सात के सत्तर गुना छमा करैका चाही।” ");
INSERT INTO bhu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","इहैनिता स्वरग कर राज कि बरोबरी ऊ राजा के संग करै जथै, जेही अपन हरवाह लग हिसाब किताब करै के सोचे रथै। ");
INSERT INTO bhu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","जब ऊ अपन हरवाहन के संग अपन हिसाब किताब करै लग जथै, ता अक्ठी असना मनसे के ओखर लिघ्घो लाय गय रथै, जउन दस हजार सोना कर खोटन्ना के करजा रथै। ");
INSERT INTO bhu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","पय ओखर लिघ्घो करजा चुकामै के कउनो रास्ता नेहको रथै, ओखर मालिक आदेस देथै, कि ऊ हरवाह के ओखर डउकी लरका अउ ओखर सगलू डेरा के बेच के करजा चुकाय जाय। ");
INSERT INTO bhu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","एतका हे हरवाह ओखर गोड तरी गिरके परनाम करके कथै, मालिक धीर धर, मै सगलू कुछु लउटा देहुं। ");
INSERT INTO bhu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","तब मालिक हरवाह के उप्पर दया आ जथै अउ ओखर करजा के छमा कर देथै अउ ओही जाय देथै। ");
INSERT INTO bhu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“पय जब हरवाह बाहिर छो निकडथै, ता ओखर संगी हरवाह मसे मिलथै, जउन ओखर लग अक्ठी सव चांदी के पइसा के करजदार रथै, ऊ हरवाह के पकडके ओखर नटेरी दबाउत कथै, जउन मोर लग करजा लय हबस उके लउटा दे।” ");
INSERT INTO bhu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","हइ मेर ओखर संगी हरवाह ओखर गोड हे गिरके ओखर लग बिनती करथै, धीर धर मै सगलू करजा लउटा दइहों। ");
INSERT INTO bhu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","पय ऊ नेहको मनीस अउ जायके तब तक जेल हे बेडवा देथै, जब तक कि ऊ अपन करजा नेहको लउटाय दे। ");
INSERT INTO bhu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","दूसर हरवाह हइ सगलू घटना के देखके बोहत दुखी होथै अउ ऊ जउन घटना घटे रथै, सगलू अपन मालिक के जायके गुठे देथै। ");
INSERT INTO bhu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तब ओखर मालिक ओही बुलाके कथै, हे दुस्ट हरवाह तै जउन मोर लग बिनती करे रहस, मै तोर करजा के छमा कर दयों काखे तै मोर लग दया के भीख मांगे रथस। ");
INSERT INTO bhu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","जसना मै तोर उप्पर दया करे रथो, का तहुं अपन संगी हरवाह हे दया नेहको करैका चाही? ");
INSERT INTO bhu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","अउ ओखर मालिक बोहत गुस्सा होथै अउ ऊ हरवाह के सजा दे निता जेल पठोय दइस, जब तक कि ऊ पूर करजा नेहको लउटाय दइस। ");
INSERT INTO bhu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“इहैमेर अगर तुम हर अक झन के अपन भाई-बेहन के पूर मन लग छमा नेहको करही, ता मोर स्वरग के बाफ तुम्हर संग असनेन करही।” ");
INSERT INTO bhu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","तब यीसु हइ बात कहै के बाद ऊ गलील सहर लग लउट के यहूदिया के परदेस हे यरदन नदिया के ऊ पार छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","अक्ठी बोहत मनसे के भीड यीसु के पाछू हुइ लेथै, जेही ऊ सगलुन रोगिया मनसेन के निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","फरीसी मनसे यीसु के परिक्छा के निता आयके कहै लागथै, “का हइ निक्खा हबै कि कउनो मनसे अपन डउकी के कउनो कारन लग छोड छुट्टी देय के का उचित हबै?” ");
INSERT INTO bhu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","यीसु जबाब देत कथै, “का तुम पवितर किताब हे नेहको पढे हबा, कि दुनिया के बनामै के सुरुवात हे उनही अक्ठी डउकी अउ अक्ठी डउका के सकल हे बनाय रहिस। ");
INSERT INTO bhu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","अउ इहैनिता उन अपन दाय अउ बाफ के छांड के डउका अपन डउकी के संग दोनो झन अक्कै संग अउ दोनो देह मिलके अक्ठी हुइ जइहिन। ");
INSERT INTO bhu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","इहैनिता ऊ दोनो झन दुइठे नेहको, पय ऊ अक्ठिन देह हबै, इहैनिता जेही भगवान जोडे हबै, उके मनसे बिरकामै झइ।” ");
INSERT INTO bhu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“उन यीसु लग कथै, फेर मूसा हइ बात काखे कहे रथै, कि छोड छुट्टी कर आदेस दइ के डउकी के छांड दइहा?” ");
INSERT INTO bhu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","यीसु उनखर लग कथै, “तुम्हर कठोर मन के कारन मूसा तुमही छोड छुट्टी देय के निता आदेस दय रहिस, पय सुरुवात हे असना नेहको रहिस। ");
INSERT INTO bhu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ता मै तुम्हर लग कथो कि जउन गलत काम के छांड के अपन डउकी के कउनो अउ कारन के निता छांड के दूसर डउकी के संग काज करथै, ता ऊ गलत काम करथै, अउ जउन कउ छांडे हर डउकी लग काज करही, ता उहो गलत काम करथै।” ");
INSERT INTO bhu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","चेला यीसु लग कथै, “अगर डउकी अउ डउका के बीच असना बात हबै ता उके काज नेहको करै के चाही।” ");
INSERT INTO bhu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","फेर यीसु उनखर लग कथै, “सब कउ हइ बात के नेहको मान सकथै, केबल उन मनसे बात मान सकथै जिनही हइ बरदान मिले हबै। ");
INSERT INTO bhu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","काखे कुछ नपुंसक मनसे असना हबै, जउन दाय के लादा लग असनेन पइदा हुइन अउ कुछ नपुंसक मनसे असना हबै, जेही मनसे नपुंसक बनाइन अउ कुछ नपुंसक मनसे असना हबै, जउन स्वरग के राज के निता खुद के नपुंसक बनाय हबै, जउन हइ सिक्छा के स्बीकार कर सकथै, ऊ मनसे स्बीकार कर ले।” ");
INSERT INTO bhu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","फेर कुछ मनसे लरकन के यीसु के लिघ्घो लानथै, कि ऊ उनखर मूड हे हाथ धरके आसीस दे अउ उनखर निता बिनती करै, पय ओखर चेला उनही गधारथै। ");
INSERT INTO bhu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","यीसु कथै, “लरकन के मोर लिघ्घो आमै देया अउ उनही झइ बरजा, काखे स्वरग के राज हे ओसनेन मनसेन के निता हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","फेर ऊ लरकन के मूड हे अपन हाथ धरथै अउ उछो लग कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","अक्ठी मनसे यीसु कर लिघ्घो आय के कथै, “हे गुरू सबरोज के जीवन पामै के निता मोके काहिन निक्खा काम करैका चाही?” ");
INSERT INTO bhu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","यीसु ओखर लग कथै, “भलाई के बारे हे मोर लग काखे पूछथस? अक्ठी तो निक्खा हबै। अगर तै सबदिना के जीवन हे जाय चाहथस, ता आदेस के मान।” ");
INSERT INTO bhu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ऊ यीसु लग पूछथै, “कउन आदेस?” यीसु कथै, “खून झइ करबे, गलत काम झइ करबे, झइ चोराबे, झूठ गवाह झइ देबे। ");
INSERT INTO bhu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","अउ अपन दाय बाफन के इज्जत करबे अउ जसना तै अपन खुद के माया करथस, ओसनेन अपन परोसी लग माया कर।” ");
INSERT INTO bhu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ऊ टोरवा यीसु लग कथै, “मै हइ सगलू आदेस के बचपन लग मानत आय हबो, अब मोर हे कउन बात के कमी हबै?” ");
INSERT INTO bhu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","यीसु ओखर लग कथै, “अगर निक्खा बनै चाहथस, ता जा अउ जउन कुछु तोर लिघ्घो हबै, ऊ डेरा के बेच के गरीबन के दइदे, ता तोके स्वरग छो डेरा मिलही अउ आयके मोर पाछू हुइ जा।” ");
INSERT INTO bhu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","पय जब जबान टोरवा हइ बात सुनथै, ता ऊ उदास हुइ के कढ जथै, काखे ओखर लिघ्घो बोहत डेरा जयजात रथै। ");
INSERT INTO bhu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","यीसु अपन चेलन लग कथै, “मै तुम्हर लग सही कथो कि धन्नड मनसेन के स्वरग के राज हे जाय के बोहत कठिन हबै। ");
INSERT INTO bhu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","मै तुम्हर लग फेरै कथो, अक्ठी सूजी के छेद लग उंटवा के निकरै के बोहत लिखडी हबै।” पय धन्नड मनसे के भगवान कर राज हे जाय के बोहत कठिन हबै। ");
INSERT INTO bhu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","फेर ओखर चेला हइ बात सुनथै, ता चकित हुइके कथै, “ता फेर केखर मुकति हुइ सकथै?” ");
INSERT INTO bhu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","यीसु उनही देखत कथै, मनसे के निता लिखडी नेहको हबै, पय भगवान के निता सगलू कुछ लिखडी हबै। ");
INSERT INTO bhu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","पतरस यीसु लग कथै, “देख हम सगलू कुछ छांड के तोर पाछू हुइ लय हबन ता हमही काहिन मिलही?” ");
INSERT INTO bhu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","यीसु उनखर लग कथै, मै तुम्हर लग सही कथो कि नबा रचना हे मनसे कर टोरवा अपन महिमा के राजगद्दी हे बइठही, ता तुमो जउन मोर पाछू होय लय हबै, बारहठे राजगद्दी हे बइठ के इस्राएल बारहठे गोतिन के नियाव करिहा। ");
INSERT INTO bhu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","अउ मोर निता जउन कउ अपन घर या भाई या बेहन अउ दाय-बाफ लरकन या खेतवन के मोर नाम के निता छांड दय हबै, उके सव गुना मिलही अउ सबरोज के जीवन के अधिकारी बनहिन। ");
INSERT INTO bhu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“पय बोहत लग मनसे जउन आगू हबै, ऊ पाछू हुइ जइही अउ जउन पाछू हबै ऊ आगू हुइ जइहिन।” ");
INSERT INTO bhu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","स्वरग कर राज अक्ठी मालिक के जसना हबै, जउन सकरहा अपन बगिया के अंगूर के लेय के निता निकडथै। ");
INSERT INTO bhu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ऊ मजदुरिहन के संग अक्ठी चांदी के पइसा रोजदिन मजदूरी देय के तय करथै अउ उनही अपन अंगूर के बगिया हे काम करै के निता पठोय देथै। ");
INSERT INTO bhu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","लगभग नव बजे के टेम ऊ मालिक फेर घर लग बाहिर निकडथै अउ देखथै कि कुछ मनसे बजार हे इछो-उछो बेकार ठाड हबै। ");
INSERT INTO bhu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ता ऊ उनखर लग कथै, तुमो मोर अंगूर के बगिया हे अइहा, मै तुमही सही मजदूरी दइहों। ");
INSERT INTO bhu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","अउ उनो गइन फेर ऊ लगभग दुपहरी अउ तीन बजे बाहिर जाय के ऊ ओसनेन करथै। ");
INSERT INTO bhu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ऊ सांझ के पांच बजे फेर बाहिर निकडथै, ऊ उछो अउ मजदुरिहन के ठाड देखथै, ऊ उनखर लग कथै, तुम इछो दिन भर काखे बेकार ठाड हबा? ");
INSERT INTO bhu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ऊ ओखर लग कथै, इहैनिता इछो ठाड हबन कि कउ हमही काम हे नेहको लगाइन, ऊ उनखर लग कथै, तुमो मोर अंगूर के बगिया हे काम करै जा। ");
INSERT INTO bhu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","सांझ हुइ गइस ता बगिया के मालिक अपन हरवाह लग कथै, सुरू लग लइके आखरी तक आमै बाले मजदुरिहन के बुलाय के मजदूरी दइ दे। ");
INSERT INTO bhu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","जब उन मजदुरिहा अइन, जउन मनसे पांच बजे काम हे लगाय गय रहिस, उनही चांदी के पइसा अक-अक्ठी मिलथै। ");
INSERT INTO bhu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","हइ मेर उन मनसेन लग आगू आय रथै, उन हइ समझिन कि हमही बोहत मिलही, पय उनोन के अक-अक्ठी खोटन्ना मिलथै। ");
INSERT INTO bhu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","जब उनही पइसा मिलथै, ता मालिक लग कुडकुडाय के कथै, ");
INSERT INTO bhu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","जउन बाद हे काम हे लगे रहिन उन बस अक घंटा काम करे हबै अउ तै हमुन के ओतकै दय हबस, जेतका उनही जब कि हम सगलू दिन बोहत घाम हे काम करे हबन। ");
INSERT INTO bhu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","पय उनखर मसे अकझन के जबाब देथै, हे संगी मै तुम्हर संग, कोनो अनियाव नेहको करथो, का तहिन मोर लग अक्ठी खोटन्ना हे काम करै के निता राजी नेहको होय रहस? ");
INSERT INTO bhu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","जउन तोर हबै उके उठा अउ कढ जा, मोर मन हइ हबै कि जेतका तोके देहुं, ओतकै हइ पाछू बाले के दइहों। ");
INSERT INTO bhu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","का हइ सही नेहको हबै, कि मै अपन पइसा के जउन कुछु चइहो उहै करिहों? का मोर उदार होयके तुम्हर आंखी हे खटकत हबै? ");
INSERT INTO bhu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","इहैमेर जउन पाछू हबै, ऊ आगू हुइ जही अउ जउन आगू हबै, ऊ पाछू हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","यीसु अपन बारहठे चेलन के संग, यरुसलेम छो जथै, ता ऊ उनही बगल हे लइ जाय के कहै लगिस। ");
INSERT INTO bhu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","सुना हम यरुसलेम सहर छो जथन अउ मनसे कर टोरवा पुजारिन अउ यहूदी नियम के गुरू अउ पंडितन के हाथ हे पकडोय जही। ");
INSERT INTO bhu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","फेर ओखर बेज्जती कराही अउ कोडा मरवामै के उके गैर यहूदिन के हाथ हे सउप देही अउ उके बेज्जती करही फेर उके क्रूस हे टांग देही, पय ऊ तीसर रोज जिन्दा हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","फेर जबदी के टोरवन के दाय अपन टोरवन के संग यीसु के लिघ्घो आयके परनाम करथै अउ कुछु ओखर लग मांगथै। ");
INSERT INTO bhu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","यीसु ओखर लग पूछथै, तै काहिन चाहथस? ऊ कथै, हइ आदेस दे कि मोर हइ दोनो टोरवा तोर राज हे अक्ठी तोर दहिना पल्ला अउ दूसर तोर टेटरा पल्ला बइठै। ");
INSERT INTO bhu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","यीसु जबाब देथै, तुम नेहको जानथा, कि का मांगथा, जउन मै दुख के खोरवा के पिये बाले हव, का तुम ऊ दुख के पीरा के सहि सकथस? उन कथै, हव सहि सकथन। ");
INSERT INTO bhu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","यीसु उनखर लग कथै, सही हे तुम ऊ पीरा के सहि लइहा, पय मोर टेटरा अउ दहिना पल्ला बइठामै के मोर हक नेहको हबै, पय जिनखर निता मोर बाफ के तरफ लग तइयार करे गय हबै, उनखरै निता हबै। ");
INSERT INTO bhu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","जब दसोठे चेला हइ बात सुनथै, ता दोनो भाई के उप्पर बोहत गुस्साथै। ");
INSERT INTO bhu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","तब यीसु उनही अपन लिघ्घो बुलाय के कथै, तुम जानथा कि गैर यहूदिन के मुखिया उनखर हे राज करही अउ जउन बड्डे हबै, ऊ उनखर हे हक जताथै। ");
INSERT INTO bhu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","पय तुम्हर बीच हे असना नेहको होयका चाही, बाकि तुम्हर मसे जउन सबले बडा बनै चाहथै, ऊ तुम्हर सेबक बनै। ");
INSERT INTO bhu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","अउ तुम्हर हे जउन कोनो परधान बनै चाहथै, ऊ तुम्हर हरवाह बनै। ");
INSERT INTO bhu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","जसना कि मनसे कर टोरवा ऊ इहैनिता नेहको आय हबै कि ओखर सेबा करे जाय, पय इहैनिता आय हबै कि खुदय सेबा करै अउ बोहत मनसेन के पाप लग छंडामै के निता अपन जीव दे। ");
INSERT INTO bhu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","जब यीसु यरीहो सहर छो निकडथै, ता उछो अक्ठी बोहत मनसेन के भीड ओखर पाछू हुइ लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","उछो दुइठे अन्धरा मनसे सडक के टाठा हे बइठे रथै, जब उन हइ सुनथै कि यीसु जथै ता उन चिरलाथै, हे परभु दाऊद कर टोरवा हमर उप्पर दया कर। ");
INSERT INTO bhu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","अउ मनसे उनही गधारथै कि चुप रह, पय उन अउ बोहत चिरलायके कथै, हे परभु दाऊद कर टोरवा हमर उप्पर दया कर। ");
INSERT INTO bhu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ता यीसु उछो रुक जथै अउ उनही अपन लिघ्घो बुलवाइस अउ कथै तुम काहिन चाहथा? कि मै तुम्हर निता करव। ");
INSERT INTO bhu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","उन ओखर लग कथै, परभु हम देखै चाहथन। ");
INSERT INTO bhu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","यीसु के उनखर उप्पर दया आथै अउ ऊ उनखर आंखिन के छिथै अउ उन उहै टेम देखै लग जथै अउ उन यीसु के पाछू हुइ लइन। ");
INSERT INTO bhu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","यीसु अउ ओखर चेला जब यरुसलेम के जैतून डोंगर के लिघ्घो बैतफगे हे पहुंचथै, ता यीसु दुइठे चेलन के हइ कहिके पठोथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“लिघ्घो के गांव हे जा, उहां पहुंचतै खुट्टा हे बंधररे हर अक्ठी गदही मिलही अउ ओखर संग ओखर लरका हुइ उके छोर के मोर लिघ्घो लइ आबा। ");
INSERT INTO bhu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","अगर कउ तुमही कुछु कइहिन ता उनखर लग कहबे, परभु के ऐखर काम हबै अउ हरबी उके दइ देही।” ");
INSERT INTO bhu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","हइ इहैनिता होथै, कि ग्यानी मनसेन के बचन पूर होय: ");
INSERT INTO bhu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सियोन के नगरी लग कहा, देख तोर राजा तोर लिघ्घो आथै, ऊ नरम हबै अउ गदहा हे बइठे हबै, पय गदही कर लरका हे।” ");
INSERT INTO bhu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","यीसु जसना अपन चेलन लग कथै, ता चेला ओसनेन करथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","चेला गदही के लरका के लानथै, ओखर उप्पर बिछउना बिछाथै अउ यीसु ओखर उप्पर बइठ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ता बोहत मनसे अपन बन्डी के गली हे बिछाथै अउ खजूर के डगइल के गली हे बिछाथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","मनसेन कर भीड आगू पाछू रेंगै बाले चिरलाय-चिरलायके कथै, दाऊद कर टोरवा के जय होय जय होय, धन्य हबै ऊ जउन परभु कर नाम लग आथै, भगवान कर महिमा होय। ");
INSERT INTO bhu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","जब यीसु यरुसलेम नगर हे गुजरथै, ता सगलू नगर हे खलबली मच जथै अउ मनसे कहै लागथै, हइ कोहर हबै? ");
INSERT INTO bhu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","मनसे कथै, हइ गलील के नासरत के ग्यानी मनसे यीसु हबै। ");
INSERT INTO bhu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","यीसु बिनती भवन हे जाय के उन सबझन के जउन मन्दिर हे खरीदथै अउ बेचथै, उनही बाहिर निकार देथै अउ पइसा उगाहै बाले अउ परेवा बेचै बाले के टेबुलन के पलट देथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","अउ यीसु उन मनसेन लग कथै, पवितर किताब हे लिखररे हबै, मोर घर बिनती कर घर कहाही, पय तुम मनसे इके लुटेरन के अड्डा बनाउत हबा। ");
INSERT INTO bhu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","बिनती भवन हे कुछ अंधरा लेंगरा लुलवा मनसे यीसु कर लिघ्घो आथै, उनके ऊ निक्खा कर देथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","तब पुजारी अउ यहूदी नियम कर गुरू ऊ चकित के कामन के देखके बोहत गुसाथै, जउन ऊ करथै अउ बिनती भवन हे लरकन के बोहत आरो लग चिरलात सुनथै, “जय होय दाऊद के ऊ टोरवा धन्य हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ता उन ओखर लग पूछथै, “तै सुनथस उन काहिन कथै?” यीसु उनखर लग कथै, “हव, सुनथो, का तुम पवितर किताब हे नेहको पढे हबा, तै लरकन अउ दूध पियत लरकन लग भजन करवाय हबै?” ");
INSERT INTO bhu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ता यीसु उनही छांड के यरुसलेम नगर के बाहिर बैतनिय्याह गांव छो कढ जथै अउ उहैं रात गुजाडथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","आने रोज बिहनेन यरुसलेम नगर छो यीसु वापिस आथै, ता उके भूख लगथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","तब यीसु सडक के पाखा हे अंजीर कर अक्ठी रूख देखथै, ऊ ओखर लिघ्घो जथै, पय पत्तन के अलाबा अउ कुछु नेहको पाथै, ता यीसु रूख लग कथै, अब लग तोर हे कबहुन फडुहा नेहको लगही अउ अंजीर के रूख हरबी झुराय गइस। ");
INSERT INTO bhu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","हइ देखके चेला चकित होथै अउ उन कथै, हइ अंजीर के रूख एतका हरबी कसके झुराय गइस। ");
INSERT INTO bhu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","यीसु उनही जबाब देथै, मै तुम्हर लग सही कथो, अगर तुम बिस्वास करथा अउ संका नेहको करथा, ता तुम न बलुक ऊ करिहा, जउन मै अंजीर के रूख लग करे हव, पय अगर हइ डोंगर लग कइहा, उठ अउ समुन्दर हे जाय गिर, ता ओसनेन हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","अउ जउन कुछु तुम बिस्वास के संग बिनती हे मंगिहा, ऊ तुमही मिल जही। ");
INSERT INTO bhu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","जब यीसु बिनती भवन हे जाय के भगवान कर बारे हे मनसेन के गुठेथै, ता परधान पुजारी अउ मनसेन के सियान ओखर लिघ्घो आयके पूछथै, “तै हइ काम केखर हक लग करथस? अउ तोके हइ हक कोहर दय हबै?” ");
INSERT INTO bhu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","यीसु उनही जबाब देथै, महुं तुम्हर लग अक्ठी बात पूछथो, अगर तुम मोके गुठेहा ता महुं तुमही गुठेहूं कि हइ काम केखर हक लग करथो। ");
INSERT INTO bhu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","यूहन्ना के बतिस्मा केखर पल्ला लग मिलथै? स्वरग के पल्ला लग या मनसेन के पल्ला लग? तब उन अपन हे खुसुर फुसुर करै लग जथै, अगर हइ मेर कहबो कि भगवान के पल्ला लग हबै, ता ऊ हमही कहि ता तुम ओखर उप्पर बिस्वास काखे नेहको करा? ");
INSERT INTO bhu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","अगर हम कहबो कि मनसे के पल्ला लग हबै, ता हमही मनसेन के भीड लग डर हबै, काखे उन यूहन्ना के ग्यानी मनसे मानथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","इहैनिता उन यीसु के जबाब देथै, “हम नेहको जानथन” तब यीसु उनखर लग कथै, “ता महुं तुमही नेहको बताहुं, कि हइ काम मै केखर हक लग करथो।” ");
INSERT INTO bhu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","तुम्हर काहिन बिचार हबै? कउनो मनसे के दुइठे टोरवा रथै, ऊ बड्डे टोरवा के लिघ्घो जायके कथै, बेटवा आज बगिया हे जा अउ काम करबे। ");
INSERT INTO bhu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","पय टोरवा जबाब देथै, मै नेहको जहुं, बाद हे ओखर मन बदल गइस अउ ऊ बगिया कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","फेर ऊ बाफ दूसर टोरवा के लिघ्घो जायके ओसनेन कथै, उहो जबाब देथै, हव जहुं, पय नेहको गइस। ");
INSERT INTO bhu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","बताबा उन दुनो मसे कोहर अपन बाफ के बात पूर करथै? उन कथै बड्डे टोरवा, ता यीसु उनही कथै, “मै तुम्हर लग सही कथो, कि पइसा उगाहै बाले, गलत काम करै बाले भगवान कर राज हे तुम्हर लग आगुन जइही।” ");
INSERT INTO bhu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","हइ मै इहैनिता कथो, काखे बतिस्मा देय बाले यूहन्ना तुमही जीवन के सही रास्ता देखामै आइस अउ तुम ओखर उप्पर बिस्वास नेहको करा, पय पइसा उगाहै बाले अउ गलत काम करै बालेन हे बिस्वास करिन अउ तुम जब हइ देखा, तउभरमा तुम मन नेहको फिराया अउ न ओखर हे बिस्वास करा। ");
INSERT INTO bhu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“अक्ठी अउ किस्सा सुना, अक्ठी मालिक रथै,” जउन अंगूर के बगिया लगाथै, ओखर चारो चउगिरदा बखरी रुंधवा देथै अउ ऊ ओहमा रस निकारै के निता कुन्ड खोदथै अउ रहै के निता अक्ठी मडइचा बनवाथै अउ किसानन के ठेका दइके परदेस छो कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","जब अंगूर उतारै के टेम आइस, ता ऊ बगिया के मालिक अपन हरवाहन के किसानन के लिघ्घो पठोथै, ताकि उन अपन हिस्सा के अंगूर लइ आमै। ");
INSERT INTO bhu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","पय किसान ओखर हरवाहन के पकरके कउनोन के सोटथै अउ कउनोन के मार डारथै अउ कउनोन के पथरा लग मारथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","एखर बाद मालिक पहिले लग बोहत हरवाह के पठोथै अउ उन किसान उनखरो संग ओसनेन करथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","आखरी हे ऊ मालिक अपन टोरवा के उनखर लिघ्घो हइ सोचके पठोथै, कि उन मोर टोरवा के इज्जत करही। ");
INSERT INTO bhu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","पय किसान टोरवा के देखके अपनै हे गुठेमै लग जथै, हइ तो हइ बगिया के हकदार हबै, ता आबा इहो के मार डारी अउ एखर बगिया के झटक लइ। ");
INSERT INTO bhu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","उन उके पकर लाइन अउ बगिया लग बाहिर निकार के मार डारथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“जब अंगूर बगिया के मालिक आही, ता उन किसानन के संग काहिन करी?” ");
INSERT INTO bhu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","उन यीसु लग कथै, ऊ उन बेकार मनसेन के मार डारी अउ अपन बगिया के ठेका दूसर किसानन के दइ देही, जउन टेम हे फडुहा के हिस्सा देयत रइहीं। ");
INSERT INTO bhu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","यीसु उनखर लग कथै, का तुम पवितर किताब के कबहुन नेहको पढे हबा, जउन पथरा के मिसतिरी बेकार समझ के फटक दय रथै, उहै कोन्टा के नीह के पथरा बन गइस, हइ परभु के काम हबै, अउ हमर नजर हे अदभुत हबै। ");
INSERT INTO bhu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","इहैनिता मै तुम्हर लग कथो, भगवान कर राज तुम्हर लग लइ ले जही अउ असना मनसेन के दइ दे जही, जउन ओखर सही फडुहा लइहीं। ");
INSERT INTO bhu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“जउन हइ पथरा हे गिरही, ऊ चूरचूर हुइ जही अउ जेखर हे ऊ पथरा गिरही, उके पीस डारी।” ");
INSERT INTO bhu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","पुजारी अउ फरीसी मनसे यीसु के किस्सा के सुनके उन जान जथै, कि हमर बारे हे कथै। ");
INSERT INTO bhu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","अउ उन यीसु के पकरै चाहथै, पय मनसेन लग डेराय जथै, काखे उन यीसु के ग्यानी मनसे मानथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","यीसु फेरै मनसेन कर किस्सा सुनामै लग जथै, उन कथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","स्वरग कर राज ऊ राजा के जसना हबै, जउन अपन टोरवा कर काज हे भन्डारा करथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","राजा अपन हरवाहन के पठोथै, कि जउन मनसेन के नेउता दय हबा, उन मनसेन के बुला लामै, जिनखर काज कर भन्डारा हे नेउता दय गय हबै, पय उन पहुना नेहको आमै चाहथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","राजा अपन हरवाहन के हइ गुठेके पठोथै, पहुनन लग कइहा, देखा मै अपन भन्डारा तइयारी कर लय हबन, मोर गेडरा अउ मोट-मोट बइला मार डारे हबन, सगलू कुछ तइयार हबै काज के भन्डारा हे आबा। ");
INSERT INTO bhu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","पय कउ पहुना राजा हे धियान नेहको दिहिन कउ खेत छो ता कउ काम धन्धा करै के कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","अउ कुछ पहुना राजा के हरवाहन के पकरके उनखर बेज्जती करथै अउ उनही मार डारथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","राजा के बोहत गुस्सा आथै, अपन सिपाही पठोय के उन सगलू मारै बालेन के मरवा डारथै अउ उनखर सहर के लेस देथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","तब राजा अपन हरवाहन लग कथै, काज हे भन्डारा तइयार हबै, पय मनसे एखर काबिल नेहको हुइन। ");
INSERT INTO bhu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","इहैनिता गली के चवराहा हे जा अउ जेतका मनसे तुमही मिलही, उन सब झन के काज के भन्डारा हे बोलाय लाबा। ");
INSERT INTO bhu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","हरवाह सडकन हे जायके अउ निक्खा बेकार जेतका मनसे मिलथै, ऊ उनही बोलाय लानथै अउ काज कर मडवा तरी पहुनन लग भर गइन। ");
INSERT INTO bhu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“राजा पहुनन के देखै के निता भित्तर छो आइस, ता ऊ उहां अक्ठी मनसे के देखथै, जउन काज कर बन्डी नेहको पहिरे रथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ता राजा ओखर लग पूछथै, हे सखा, तै काज कर बन्डी बगैर पहिरे इछो काखे आय हबस? पय ऊ मनसे कुछु जबाब नेहको देथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ता राजा अपन हरवाहन लग कथै, एखर हाथ गोड के बांध के, उके बाहिर अंधियार हे फटक देया, जिहां हइ रोइ अउ दांत चबाही।” ");
INSERT INTO bhu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","काखे बुलाय हर मनसे तो बोहत हबै, “पय चुने हर मनसे चुटु हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ऊ टेम फरीसी मनसे अपन हे सोचै बिचारै लग जथै, कि यीसु के ओखर खुद के बातन हे फसइ। ");
INSERT INTO bhu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","उन फरीसी मनसे अपन चेलन के हेरोदिया समूह के संग यीसु के लिघ्घो पठोथै, उन मनसे कथै, हे “गुरू हम जानथन, कि तै सही हबस अउ भगवान के गली के सिक्छा देथस, मनसे का सोचहीं एखर बारे हे चिंता नेहको करथस, काखे तै मनसेन के मुंह देखके बात नेहको करथस। ");
INSERT INTO bhu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","इहैनिता हमही गुठे, मूसा कर नियम के जसना तोर का सोच हबै? कि कैसर रोमन राजपाल के पइसा देय के उचित हबै कि नेहको?” ");
INSERT INTO bhu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","यीसु उनखर बेकार सोच के जानके कथै, “हे ढोंगहा मनसे तुम मोके काखे फसामै के सोचथा। ");
INSERT INTO bhu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","यीसु कथै, चांदी के पइसा मोके देखाबा, जेखर लग तुम पइसा चुकाथा।” तब उन ओखर लिघ्घो अक्ठी पइसा लइके आथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","यीसु उनखर लग पूछथै, “हइ छाप अउ नाम केखर हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","उन जबाब देत कथै, कैसर रोमन राजपाल के तब यीसु उनखर लग कथै। जउन कैसर के हबै, ऊ कैसर के देया अउ जउन भगवान कर हबै, ऊ भगवान के देया। ");
INSERT INTO bhu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","हइ बात सुनके उन चकित हुइ जथै अउ उके छांड के कढ गइन। ");
INSERT INTO bhu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","उहै रोज सदूकी समाज के मनसे यीसु के लिघ्घो आथै अउ पूछथै, मरे हर मनसे जिन्दा नेहको होथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","उन यीसु लग सबाल पूछथै, “हे गुरू मूसा गुठे हबै कि कोनो मनसे बिना लरका होबाय मर जाय, ता ओखर भाई ओखर बिधवा डउकी लग काज करके, अपन भाई के निता लरका पइदा करै। ");
INSERT INTO bhu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","अब हमर इहां सातठे भाई रहिन आगू बाले भाई काज करके, बिना लरका होबाय मर गइस अउ अपन डउकी के अपन भाई के निता छांड गइस। ");
INSERT INTO bhu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","इहैमेर दूसर अउ तीसर करथै अउ सातोठे भाइन के संग ओसनेन होथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","अउ आखरी हे उहो डउकी मर गइस। ");
INSERT INTO bhu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","अब हमर पूछै के हइ हबै, जिन्दा होय के बाद हे उन सातोठे भाइन मसे केखर डउकी होही? काखे ऊ सगलू झन के डउकी रह चुकथै।” ");
INSERT INTO bhu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","यीसु उनही जबाब देथै, का तुम पवितर किताब अउ भगवान के सक्ति के नेहको जानथा, इहैनिता तुम गलत सोचत बिचारत हबा। ");
INSERT INTO bhu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","फेरै जिन्दा होय लग न डउका काज करही अउ न डउकी काज हे दय जही, बलुक स्वरग हे भगवान के स्वरगदूतन के जसना होही। ");
INSERT INTO bhu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","जिहां तक मरे हर जिन्दा होय के सबाल हबै, का तुम हइ बचन नेहको पढे हबा? जउन भगवान तुम्हर लग कहे हबै। ");
INSERT INTO bhu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","मै अब्राहम के भगवान अउ इसहाक के भगवान अउ याकूब के भगवान हबो? ऊ मरे हर के नेहको, पय जिन्दा के भगवान हबै। ");
INSERT INTO bhu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","हइ सुनके मनसे ओखर सिक्छा लग बोहत चकित हुइ गइन। ");
INSERT INTO bhu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","जब फरीसी मनसे सुनथै, कि यीसु सदूकी मनसे के मुंह के बन्द कर दय हबै, ता उन अक्ठी जिघा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","उनखर मसे अक्ठी नियम के गुरू, यीसु के फसामै के निता पूछथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","गुरू नियम के किताब हे सबले बड्डे आदेस कउन हबै? ");
INSERT INTO bhu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","यीसु उनखर लग कथै, “तै भगवान अपन परभु लग सगलू मन, अपन सगलू परान अउ अपन सगलू दिमाक लग माया कर। ");
INSERT INTO bhu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","हइ सब लग पहले बड्डे अउ खास आदेस हबै। ");
INSERT INTO bhu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","अउ दुसर आदेस ओखरै के जसना हबै, कि तै अपन परोसिन लग माया कर, जसना तै खुदय लग माया करथस। ");
INSERT INTO bhu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","इहै दुइठे आदेस हे सगलू नियम के किताब अउ ग्यानी मनसे सिक्छा कर अधार हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","जब फरीसी मनसे अक्ठी जिघा जुडे रथै, ता यीसु उनखर लग पूछथै। ");
INSERT INTO bhu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","मसीह के बारे हे तुम काहिन सोचथा? ऊ केखर टोरवा हबै? उन जबाब देथै, “दाऊद कर।” ");
INSERT INTO bhu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","यीसु उनखर लग कथै, ता दाऊद आतमा हे हुइके, उके परभु काखे कथै? ");
INSERT INTO bhu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","परभु मोर परभु लग कथै, मोर दहिना हाथ पल्ला बइठ जा, जब तक कि मै तोर बैरी के तोर गोड तरी नेहको कर देहुं। ");
INSERT INTO bhu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“अगर दाऊद उके परभु कथै, ता ऊ ओखर टोरवा कसके हुइ सकथै?” ");
INSERT INTO bhu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","एखर जबाब हे कउनो फरीसी यीसु के कुछु नेहको बोल सकिन, उहै रोज लग कोनो मनसे यीसु लग कुछु सबाल पूछै के हिम्मत नेहको होथै। ");
INSERT INTO bhu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ऊ टेम यीसु अपन चेलन लग अउ मनसेन के भीड लग कथै, ");
INSERT INTO bhu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","गुरू कर हक मतलब गुठेमै बाले अउ फरीसी मूसा कर राजगद्दी हे बइठे हबै। ");
INSERT INTO bhu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","इहैनिता उन तुम्हर लग जउन कुछु कइहिन उहै करिहा अउ मनिहा, पय उनखर लग कउनो काम झइ करइहा, अउ न उनखर जसना काम करिहा, काखे उन कथै पय नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","उन मनसेन के खान्दा हे एतका गरू लाद देथै कि उन उके उठाय के रेंगों नेहको सकै अउ मनसेन हे दबाव दिखाथै कि उन उके लइके रेंगै। पय उन खुद उनखर मसे कउनो मेर के अंगठी तक नेहको डोलामै चाहथै। ");
INSERT INTO bhu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","उन निक्खा काम इहैनिता करथै, कि मनसे उनही देखै, सहीमा ऊ अपन तबीज के चउडा अउ अपन खुरथा पइजामा के झालर के जसना लम्बा बनाथै, ताकि मनसे उनही धरमी मनसे समझै। ");
INSERT INTO bhu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","उन तेउहार हे सब लग ऊंच जिघा पामै के चाहथै अउ मंडली हे खास राजगद्दी चाहथै। ");
INSERT INTO bhu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","बजार हे बडा इज्जत के संग नमस्ते करामै के चाहथै अउ चाहथै कि मनसे उनही गुरू कहिके बुलामै। ");
INSERT INTO bhu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","पय तुम गुरू झइ कहवइहा, काखे तुम्हर अक्ठिन गुरू हबै अउ तुम सगलू भाई-बेहन हबा। ");
INSERT INTO bhu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","भुंइ हे कउनोन के बाफ झइ कइहा, काखे तुम्हर अक्ठिन बाफ हबै, जउन स्वरग छो हबै। ");
INSERT INTO bhu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","अउ न स्वामी कहवइहा, काखे तुम्हर अक्ठिन स्वामी हबै अउ ऊ मसीह हबै। ");
INSERT INTO bhu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","तुम्हर मसे खास मनसे उहै होही, जउन तुम्हर सेबक बनही। ");
INSERT INTO bhu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","जउन कउ खुद के बड्डे करही, उके नान कर दय जही अउ जउन कउ खुद के नान करही, उहै के बड्डे करे जही। ");
INSERT INTO bhu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“हे ढोंगहा गुरू अउ फरीसी तुमही लानत हबै, तुम मनसेन के निता स्वरग राज कर दूरा के बन्द करथा, न खुद ओहमा घुसथा अउ न उनही जाय देथा, जउन जाय के निता परयास करथै।” ");
INSERT INTO bhu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","हे ढोंगहा गुरू अउ फरीसी तुमही लानत हबै, तुम बिधवन के घरन के खाय डारथा अउ दूसर के देखामै के निता बोहत टेम तक पराथना करथा, इहैनिता तुमही बोहत सजा मिलही। ");
INSERT INTO bhu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","हे ढोंगहा यहूदी गुरू अउ फरीसी, तुमही लानत हबै, तुम अकझन के अपन पल्ला लामै के निता सगलू भुंइ अउ बादर अक्ठी कर देथा अउ जब उन तुम्हर पल्ला आ जथै, ता उके अपन लग दुइ गुना नरक बना देथा। ");
INSERT INTO bhu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","हे अंधरा सियान, तुमही लानत हबै, जउन तुम कथा, कि हइ बिनती भवन के किरिया खइहा ता कुछु जरूरी नेहको हबै, पय कउनो मन्दिर के सोना के किरिया खइहा, ता ऊ किरिया के मानैके जरूरी हबै। ");
INSERT INTO bhu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","अरे मूरुख अउ अंधरा कउन बड्डे हबै? ऊ बिनती भवन के सोना या ऊ मन्दिर जउन सोना के पवितर बनाइस। ");
INSERT INTO bhu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","तुम इहो कथा, कि कउनो बेदी के किरिया खाथै, ता कउनो मतलब नेहको, पय जउन कउ बलि ओहमा धररे हर हबै, अगर कउ ओखर किरिया खाथै ता ऊ अपन किरिया लग बंधररे हबै। ");
INSERT INTO bhu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","हे अंधरा, कउन बड्डे हबै, बलि के चढावा या बेदी जेहमा चढावा पवितर हुइ जथै? ");
INSERT INTO bhu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","इहैनिता जउन बेदी के किरिया खाथै, ता ऊ बेदी के संग बेदी हे जउन धररे हर हबै, उहो किरिया खाय लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","जउन मन्दिर के किरिया खथै, ता ऊ बिनती भवन के भित्तर जउन कुछु हबै, ओखरो किरिया खाय लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","जउन स्वरग के किरिया खथै, ऊ भगवान कर राजगद्दी अउ ओहमा बइठे बाले के किरिया खाथै। ");
INSERT INTO bhu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","हे ढोंगहा गुरू अउ फरीसी तुमही लानत हबै, तुम्हर जउन कुछु हबै, तुम ओखर दसमा हिस्सा, इहां तक कि अपन पुदीने अउ साउख अउ जीरा के दसमा हिस्सा भगवान के देथा, पय फेरै तुम नियम के किताब के जरूरी बातन के, मतलब नियाव अउ दया अउ बिस्वास के छांड देथा, जरूरी हबै कि इहो करत रइहा अउ उनोन के मानैके चाही। ");
INSERT INTO bhu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","हे अंधरा सियान तुम तो मच्छड के छान लेथा, पय उंटवा के खा जथा। ");
INSERT INTO bhu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","हे ढोंगहा गुरू अउ फरीसी तुमही लानत हबै, तुम खोरिया अउ टठिया के उपरै-उप्पर धोथा, पय भित्तर लग उन चीजन लग जउन लडाई अउ स्वारथी लग भररे हर हबै। ");
INSERT INTO bhu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","हे अंधरा, फरीसी पहिले भित्तर लग खोरिया के अउ टठिया के धोय ले, ता ऊ बहिर लग सुध्द साफ दिखही। ");
INSERT INTO bhu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","हे ढोंगहा गुरू अउ फरीसी तुमही लानत हबै, तुम चूना लग लिपररे हर मरघटी के जसना हबै, जउन उप्पर लग निक्खा दिखथै, पय भित्तर छो लहासन के हाडा अउ सबैमेर के असुध्द लग भररे हर हबै। ");
INSERT INTO bhu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","इहैनिता तुम उप्पर लग मनसेन के धरमी काम दिखाथा, पय भित्तर हे कपट अउ अधरम लग भररे हर हबा। ");
INSERT INTO bhu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","हे ढोंगहा गुरू अउ फरीसी तुमही लानत हबै, तुम ग्यानी मनसेन के मरघटी के निक्खा बनाथा अउ धरमी मनसे के मरघटी के सजाथा। ");
INSERT INTO bhu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","अउ हइ कथा, अगर हम अपन पुरखन के रोज हे होतन, उन जउन करे अउ जउन ग्यानी मनसेन के हत्या करे हबै उनखर सहमति नेहको होतन। ");
INSERT INTO bhu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","हइमेर लग मनसे अपन पल्ला हइ गवाही देथा कि तुम ग्यानी मनसे के खून करै बालेन के लरका हबा। ");
INSERT INTO bhu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","इहैनिता जउन तुम्हर पुरखन के पाप के गघरी पूर तरह लग भर दा। ");
INSERT INTO bhu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“हे सपुवा अउ नांग कर लरका, तुम कइसन सोचथा कि तुम नरक कर सजा लग बच जइहा? ");
INSERT INTO bhu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","इहैनिता मै तुमही गुठेथो, कि मै तुम्हर लिघ्घो ग्यानी मनसे अउ दिमाक बाले अउ गुरू के पठोहूं, तुम उन मसे कुछ के मार डरिहा अउ बोहतन के क्रूस हे टंगइहा अउ कुछ के अपन मंडली हे कोडा मरिहा अउ सहर-सहर हे मारत फिरिहा। ");
INSERT INTO bhu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","जेही धरमी हाबिल लग लइके बिरिक्याह कर टोरवा जकरयाह तक, जेही तुम बेदी अउ मन्दिर के बीच हे मार डारे रथा, जेतका धरमी मनसेन के खून भुंइ हे बहोय गय हबै, ऊ सगलू तुम्हर मुंडी हे पडही। ");
INSERT INTO bhu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","मै तुम्हर लग सही कथो, हइ सगलू बात हइ टेम के मनसेन हे आय पडही। ");
INSERT INTO bhu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“हे यरुसलेम सहर हे यरुसलेम सहर तै ग्यानी मनसेन के मार डारथा अउ जउन तोर लिघ्घो संदेस पठोमै बालेन के पथरा लग मार डारथा, मै केतका बार चाहे रहों कि जसना कुकडी अपन छउनन के पोखडी के बीच हे अकजुट करथै, ओसनेन महुं तोर लरकन के अक्ठी जिघा कर लयो, पय तुम मोके हइ नेहको करै दया। ");
INSERT INTO bhu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","अब तुम्हर मन्दिर तुम्हर निता बरबाद हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","मै तुम्हर लग कथो, अब लग तुम मोके तब तक नेहको देखिहा, जब तक तुम हइ नेहको कइहा, धन्य हबै ऊ, जउन परभु के नाम लग आथै।” ");
INSERT INTO bhu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","बिनती भवन के छांडके यीसु जब उहां लग हुइके जथै, ता ओखर चेला उके मन्दिर के पक्का भवन दिखामै ओखर लिघ्घो आथै। ");
INSERT INTO bhu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","यीसु उनखर लग कथै, “तुम हइ भवन के सिध्धा ठाड देखथा, मै तुमही सही कथो, इहां अक्ठी पथरा हे दूसर पथरा टिक नेहको सकथै, अक्ठी-अक्ठी पथरा गिराय दय जही।” ");
INSERT INTO bhu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","जब यीसु जैतून डोंगर हे बइठे रथै, ता सुनसान हे चेला ओखर लिघ्घो आयके कथै, “हमके गुठे हइ बात कब होही? जब तै फेर अइहे अउ हइ दुनिया कर आखरी होय के चिन्हा काहिन होही?” ");
INSERT INTO bhu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","यीसु उनही जबाब देथै, सचेत रइहा तुमही कउनो झइ बहकामै। ");
INSERT INTO bhu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","मै इहैनिता कथो, कि मोर नाम लग बोहत मनसे आयके हइ गुठेके बहकाही, कि मै मसीह हमो अउ बोहत झन के बहकाय दइहिन। ");
INSERT INTO bhu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","तुम झगडा के बात सुनिहा अउ झगडा के बारे हे झूठमूठ के बात सुनिहा, पय देखा तुम झइ डेरइहा असना तो होही पय आखरी अबे नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","सगलू अक्ठी रास्ट दूसर देस के बिरोध हे ठाड हुइहीं अउ राज-राज हे चढाई करही अउ जिहां-तिहां अकाल पडही, सब जिघा भुंइडोल होही। ");
INSERT INTO bhu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","पय हइ बात तो बलुक पीरा के सुरुवात होही। ");
INSERT INTO bhu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ऊ टेम मनसे तुमही सजा देय के निता पकरवइही अउ ऊ तुमही मरवा डरही अउ मोर नाम के कारन सगलू देस के मनसे घिनइहिन। ");
INSERT INTO bhu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ऊ टेम बोहत लग मनसे के माया जुडाय जही अउ बिस्वास कम हुइ जही अउ ऊ अक्ठी दूसर साहबन के हाथन हे दइ दइहीं अउ अक्ठी दूसर लग घिनइही। ");
INSERT INTO bhu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","बोहत लग झूठे ग्यानी मनसे ठाड हुइहीं अउ मनसेन के ठगही। ");
INSERT INTO bhu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","काखे कि अधरम बढ जही, इहैनिता बोहत लग मनसे के माया जुडाय जही। ");
INSERT INTO bhu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","पय जउन आखरी तक बने रही, ओखरै मुकति होही। ");
INSERT INTO bhu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","स्वरग कर राज हइ संदेस सगलू दुनिया हे परचार करे जही, कि सगलू देस हे गवाह सुनाय जही तब अंत आ जही। ");
INSERT INTO bhu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“इहैनिता जब तुम बोहत नास चीज के, जेखर बारे हे दानिय्यल ग्यानी मनसे दवारा करै गय हबै, मन्दिर के पवितर जिघा हे ठाड हुइके देखा” पढय बाले खुदय जान जथै कि एखर मतलब काहिन हबै। ");
INSERT INTO bhu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ता जउन मनसे यहूदिया परदेस हे हबै उन डोंगर छो भाग जाय के चाही। ");
INSERT INTO bhu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","जउन अपन घर के छानी हे होय, ऊ घर के छत लग कुछु चीज ले के निता तरी झइ उतरै। ");
INSERT INTO bhu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","अउ जउन बाहिर खेत हे काम करथै, ऊ पाछू लउट के अपन घर छो खुरथा पइजामा ले फेरै झइ आबै। ");
INSERT INTO bhu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“उन डउकिन के निता जउन लादा हे हुइ, या जेखर दूध पियत लरका हुइ, ऊ रोज बोहत पीरा के रोज होही, ओखर निता हाय, हाय।” ");
INSERT INTO bhu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","बिनती करा कि तुम मनसेन के पूस के रोज अउ सुस्ताय कर रोज भागय के झइ पडै। ");
INSERT INTO bhu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","काखे उन रोज हे असना पीरा आही, जब भगवान हइ दुनिया के बनाय रथै, तब लग आज तक कबहुन नेहको आय हबै अउ न कबहुन होही। ");
INSERT INTO bhu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","अगर भगवान ऊ रोज के नेहको घटोतिस, ता कउनो नेहको बच पउतिन पय कुछ चुने हर मनसेन के कारन ऊ रोज के कम कर दय जही। ");
INSERT INTO bhu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ऊ टेम अगर कोनो मनसे तुम्हर लग गुठे हबै, कि देखा मसीह इछो हबै, या उछो हबै ता कोनो के बिस्वास झइ करिहा। ");
INSERT INTO bhu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","काखे कि ठगै बाले मनसे अउ ठगरा मसीह अउ ठगरा ग्यानी मनसे, ऊ टेम ठाड हुइके बोहत चकित बाले चिन्हा देखाही अउ इहां तक कि चुने हर मनसेन के बहका देही। ");
INSERT INTO bhu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","देखा मै तुमही आगू लग गुठे दय हबो। ");
INSERT INTO bhu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","इहैनिता अगर तुम्हर लग गुठेही कि देखबे ऊ पतेरा छो हबै, ता उछो झइ जइहा या देखा ऊ कोठा हे हबै कोठा के भित्तर लुके हबै ता उनखर बिस्वास झइ करिहा। ");
INSERT INTO bhu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","काखे जउन मेर बिजली दिन उगती लग निकरके दिन बुडती तक चमकथै, उहै मेर मनसे कर टोरवा आमै के टेम होही। ");
INSERT INTO bhu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","जिहां कहुं लहास होही, उहै छो गिधवा जुडहिन। ");
INSERT INTO bhu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“उन रोज के पीरा ओखर हरबी बाद बेरा अंधियार हुइ जही, जोंधइया उजेड नेहको दइ, तरइया बादर लग गिर जइहिन अउ बादर के सक्ति के डोलाय जही। ");
INSERT INTO bhu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ऊ टेम मनसे कर टोरवा यीसु के आमै के चिन्हा बादर हे दिखही अउ दुनिया के सगलू मनसे छाती पिटहिन अउ मनसे कर टोरवा के बोहत सक्ति अउ सान के संग बादर हे आउत देखही। ");
INSERT INTO bhu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ऊ अपन स्वरगदूतन के तुरही के बोहत आरो के संग पठोही अउ उनखर चुने हर मनसेन के चारो दिसन लग बादर के अक्ठी छोर लग दूसर छोर तक अक्ठी जिघा करही।” ");
INSERT INTO bhu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“अंजीर रूख कर किस्सा लग सिक्छा लेया जब ओखर डगइल कोमर होथै अउ ओखर पत्ता फुटकथै, ता तुम जान जथा, कि जेठ बइसाख के टेम लिघ्घो आय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ओसनेन जब तुम हइ घटना देखिहा, ता जान लइहा कि ऊ लिघ्घो हबै बलुक दूरा हे हबै। ");
INSERT INTO bhu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","मै तुम्हर लग सही कथो, जब तक हइ बात पूर नेहको हुइ जही ता हइ बिरादरी के मनसे नेहको मरही। ");
INSERT INTO bhu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","बादर अउ भुंइ टर जइही, पय मोर बात कबहुन नेहको टरही।” ");
INSERT INTO bhu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ऊ रोज अउ ऊ टेम के बारे हे कोनो कुछु नेहको जानही, न स्वरग हे स्वरगदूत अउ न टोरवा जनहीं केबल भगवान बाफ जानथै। ");
INSERT INTO bhu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","जसना नूह के टेम होय रहिस, ओसनेन मनसे कर टोरवा के आमै के टेम होही। ");
INSERT INTO bhu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","पानी बाढ के पहिलेन नूह नाव हे चढै के रोज तक, मनसे खात पियत अउ काज बिहाव करत रथै। ");
INSERT INTO bhu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","अउ जब तक पानी नेहको आथै अउ सब के बोहा नेहको दइस, तब तक उनही कुछु नेहको पता होथै, उहै मेर मनसे कर टोरवा के आमै के टेम होही। ");
INSERT INTO bhu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","उहै टेम खेत हे काम करत टेम, दुइठे मनसेन मसे अक्ठी मनसे उठा लय जही अउ अक्ठी उहै छांड दय जही। ");
INSERT INTO bhu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","चकिया दरत दुइठे डउकी मसे, अक्ठी डउकी के उठा लय जही अउ अक्ठी डउकी के उहै छांड दय जही। ");
INSERT INTO bhu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","इहैनिता जागत रइहा, काखे तुमही नेहको खबर हबै कि परभु कउन रोज आही। ");
INSERT INTO bhu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","हइ निक्खा मेर समझ लेया अगर घर के मालिक के पता होतिस कि चोरटा रात के कउन टेम आही, ता ऊ जागत रहितै अउ अपन घर हे चोरी नेहको होंय देतिस। ");
INSERT INTO bhu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","इहैनिता तुम तइयार रहा, काखे जउन टेम तुम सोचतो नेहको हबा उहै टेम मनसे कर टोरवा आय जही।” ");
INSERT INTO bhu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“तुम सोचिहा कि इमानदार अउ समझदार हरवाह कउन हबै, जेही ओखर मालिक अपन घर के देखरेख करे बाले जबाबदारी सउप दे कि सही टेम हे खाना देय? ");
INSERT INTO bhu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","धन्य हबै ऊ हरवाह, जेखर मालिक लउटत हे उके ओसनेन करत पाय। ");
INSERT INTO bhu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","मै तुमही सही कथो, कि ऊ उके अपन सगलू धन डेरा के हकदार बनाही। ");
INSERT INTO bhu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","पय ऊ हरवाह बेकार होय अउ मन हे हइ सोच बिचार आमै लगे, कि मालिक के लउटै हे तो बोहत देरी होत हबै। ");
INSERT INTO bhu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","इहैनिता ऊ अपन संगी हरवाहन लग झगडा करै लग जथै अउ दरुहन के संग खाय पिय के सुरू कर देही। ");
INSERT INTO bhu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ता ऊ हरवाह के मालिक असना रोज आही, जउन रोज ऊ ओखर आमै के टेम नेहको सोचथै उके खबर तक नेहको चलही। ");
INSERT INTO bhu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","तब मालिक उके बोहत सजा देही, हइ मेर ओखर हीसा के आखरी हुइ जही जउन मेर ढोंगहन के होथै, उछो सबदिना रोना अउ दांत चबाउत रइहीं। ");
INSERT INTO bhu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ऊ रोज स्वरग कर राज उन दसठे कुमारिन के मेर होही, जउन चिमनी लइके दुलहा लग मिलै निकडथै।” ");
INSERT INTO bhu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","उन मसे पांचठे समझदार रथै अउ पांचठे मूरुख रथै। ");
INSERT INTO bhu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","मूरुख कुमारिन अपन चिमनी के संग तेल नेहको रखे रहिन। ");
INSERT INTO bhu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","पय उन समझदार कुमारिन अपन चिमनी के संग चुकरा हे तेल रखे रहिन। ");
INSERT INTO bhu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","काखे दुलहा के आमै हे देरी होथै, ता उन डउकी ऊंघात-ऊंघात सोय जथै। ");
INSERT INTO bhu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","आधा रात हे गोहराथै, देखा दुलहा डउका आथै। ओखर मुलाखात करै हरबी चला। ");
INSERT INTO bhu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","तब सगलू कुमारिन उठके अपन-अपन चिमनी के बत्ती निक्खा करै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","मूरुख कुमारिन समझदार कुमारिन लग कथै, अपन तेल मसे हमुन के चुटको हस दइदा, काखे हमर चिमनी बिताथै। ");
INSERT INTO bhu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","पय समझदार कुमारिन उनखर लग कथै, बिलकुन हइ हमर अउ तुम्हर निता पूर नेहको होही, निक्खा हइ होही कि तुम दुकान हे जाय के तेल खरीद ले आना। ");
INSERT INTO bhu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","जब उन मूरुख कुमारिन तेल खरीदय जथै कि एतका हे दुलहा डउका आय जथै, जउन समझदार कुमारिन तइयार रथै उन दुलहा डउका के संग काज बाले घर हे कढ जथै अउ कंवाड बन्द कर दय गइस। ");
INSERT INTO bhu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","कुछ टेम बाद मूरुख कुमारी हइ कहत आथै, हे परभु हे परभु हमर निता कंवाड उघार दे। ");
INSERT INTO bhu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","पय दुलहा डउका जबाब देथै, मै तुम्हर लग सही कथै, मै तुमही नेहको चीनथो। ");
INSERT INTO bhu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","इहैनिता जागत रहा, काखे तुम ऊ घडी के अउ ऊ टेम के नेहको जानथा, कि कब मनसे कर टोरवा आही। ");
INSERT INTO bhu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","स्वरग कर राज ऊ मनसे के जसना होही, जउन दूसर देस जात टेम अपन हरवाहन के बोलाथै अउ उनही अपन डेरा सउप देथै। ");
INSERT INTO bhu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ऊ मालिक सबझन के उनखर सक्ति के हिसाब लग, अक्ठी हरवाह के सोना के पांचठे पइसा, दूसर हरवाह के दुइठे पइसा अउ फेर तीसर हरवाह के अक्ठी पइसा देथै, एखर बाद हे ऊ परदेस कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","तब जेही पांचठे सोना के पइसा मिलथै, ऊ लेन-देन करके पांचठे पइसा अउ कमाय लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","हइ मेर लग जेही दुइठे पइसा मिले रथै, उहो दुइठे पइसा अउ कमाय लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","पय जेही अक्ठी पइसा मिले रथै, ऊ जाय के मालिक के पइसा के भुंइ हे खोद के लुकाय देथै। ");
INSERT INTO bhu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","बोहत रोज के बाद ऊ हरवाहन के मालिक वापिस लउटके ऊ हरवाहन लग हिसाब मांगथै। ");
INSERT INTO bhu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","जेही पांचठे पइसा मिले रथै, ऊ पांचठे पइसा अउ लायके मालिक लग कथै, मालिक देख, मै पांचठे पइसा अउ कमाय लय हव। ");
INSERT INTO bhu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ओखर मालिक कथै, बोहत बढिहा, निक्खा अउ इमानदार हरवाह, तै चुटु हस सोना के पइसा हे इमानदार रहे हस, मै तोके बोहत चीजन के उप्पर हक देहुं, अपन मालिक के मगन हे सहपारटी हुइ जा। ");
INSERT INTO bhu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","एखर बाद जेही दुइठे पइसा मिले रथै, उहो आयके कथै, मालिक तै मोके दुइठे पइसा दय रहस, देख मै दुइठे अउ पइसा कमाय हव। ");
INSERT INTO bhu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ओखर मालिक ओखर लग कथै, बोहत बढिहा, निक्खा अउ इमानदार हरवाह, तै चुटु हस पइसा हे इमानदार रहस, मै तोके बोहत चीजन के उप्पर हक देहुं, अपन मालिक के मगन हे सहपारटी हुइ जा। ");
INSERT INTO bhu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","तब ऊ आखरी हे आथै, जेही अक्ठी पइसा मिले रथै, ऊ आयके कथै, हे मालिक मै तोके जानथो, कि तै कठोर मनसे हबस, तै जिहां लग नेहको बोथस, उछो लग काटथस अउ जिहां नेहको छिटथस उछो लग बटोरथस। ");
INSERT INTO bhu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","इहैनिता मै डेराय गय रहों अउ जाय के तोर पइसा के भुंइ हे लुकाय दय रथो, देख, हइ तोर पइसा हबै। ");
INSERT INTO bhu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ओखर मालिक जबाब देथै, तै बेकार अउ आलसी हरवाह हबस, तै जानत रहस ना, कि जिहां मै नेहको बोथो, उहै काटथो, जिहां नेहको बोथो, उछो लग दाना बटोरथो, ");
INSERT INTO bhu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","इहैनिता तोके सोनरन के लिघ्घो मोर पइसा जमा कर देके चाही, ताकि मै लउटत टेम ओखर लग बेयाज सहित लइ लेतो। ");
INSERT INTO bhu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“इहैनिता एखर लग सोना के पइसा लइके ओही दइ देया, जेखर लिघ्घो दसठे पइसा हबै। ");
INSERT INTO bhu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","काखे जेखर लिघ्घो हबै, ओही अउ दय जही अउ ओखर लिघ्घो बोहत हुइ जही, पय जेखर लिघ्घो नेहको हबै, जउन ओखर लिघ्घो हबै उहो के लइ ले जही। ");
INSERT INTO bhu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","इहैनिता हइ ढिलवा हरवाहन के बाहिर के अंधियार हे फटिक देया, जिहां मनसे रोथै अउ दांत पीसथै।” ");
INSERT INTO bhu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“जब मनसे कर टोरवा अपन महिमा हे आही अउ सगलू स्वरगदूत ओखर संग आही, ता ऊ अपन महिमा के राजगद्दी हे बिराजमान होही। ");
INSERT INTO bhu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","अउ सगलू देस ओखर लिघ्घो अकजुट करे जही अउ ऊ उनही अक्ठी दूसर लग अलगे करे जही, जसना बरेदी गेडरा के छेरियन लग अलगे करथै। ");
INSERT INTO bhu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ऊ गेडरन के अपन दहिना पल्ला अउ छेरियन के टेटरा पल्ला ठाड करही। ");
INSERT INTO bhu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","तब राजा अपन दहिना हाथ बाले मनसेन लग कहि, हे मोर बाफ के आसीस पाय हर मनसे आबा ऊ राज कर हकदार बना, जउन सुरू लग दुनिया तुम्हर निता तइयार करे गय हबै, ");
INSERT INTO bhu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","काखे जब मै भुखाय रहों ता तै मोके खाय के निता दय, जब मै पियासे रहों ता तै मोके पानी पिलाय, मै परदेसी रहों ता तै मोके अपन इहां ठहराय रहस। ");
INSERT INTO bhu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","मै बिना खुरथा पइजामा के रहों ता तै मोके खुरथा पइजामा ओढाय, मै नंगहा रहों ता तै मोर सेबा करे, मै जेल हे रहों ता तै मोर लग मिले आय रहस। ");
INSERT INTO bhu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","तब धरमी मनसे उके जबाब देइहिन, हे परभु हम तोके कब भुखे देखे रहन, ता खाना खबाय रहन? कब पियासे देखन अउ पानी पिलाय रहन? ");
INSERT INTO bhu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","हम कब तोके परदेसी देखके घर के भित्तर बुलायन? अउ बिना खुरथा पइजामा के देखके बन्डी ओढायन? ");
INSERT INTO bhu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","अउ कब हम तोके नंगहा या जेल हे देखन अउ तोर लग मिलै आयन? ");
INSERT INTO bhu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","तब राजा उनही जबाब देही मै तुम्हर लग सही कथो, कि तुम जउन मोर हइ नान लग नान भाई-बेहनन मसे कउनो अक झन कर संग करे हबा, ऊ तुम मोर संग करे हबा।” ");
INSERT INTO bhu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","तब राजा अपन टेटरा पल्ला बालेन लग कहि, हे पापी मनसे मोर लग दुरिहां हुइ जा अउ सबरोज बाले आगी हे कढ जा, जउन भुतवा अउ ओखर स्वरगदूत के निता तइयार करे गय हबै। ");
INSERT INTO bhu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","काखे मै भुखाय रथो ता तुम मोके खाना नेहको दया अउ जब मै पियासे रथो, ता तुम मोके पानी नेहको पिलाया। ");
INSERT INTO bhu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","मै परदेसी रहों अउ तुम मोके अपन घर हे नेहको ठहराया अउ जब मै बिना बन्डी के रहों, ता तुम मोके बन्डी नेहको ओढाया, जब नंगाय अउ जेल हे रहों अउ तुम मोर उप्पर धियान नेहको दया। ");
INSERT INTO bhu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“तब ऊ जबाब दइहिन, हे परभु हम तोके कब भुखे, पियासे, परदेसी, बिना खुरथा पइजामा के या नंगाय या जेल हे देखन अउ तोर सेबा नेहको करन? ");
INSERT INTO bhu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","तब राजा उनही जबाब देही, मै तुम्हर लग सही कथो, कि तुम उन नान लग नान भाई-बेहन मसे कउनो अक झन के संग नेहको करा, ऊ तुम मोर संग नेहको करा। ");
INSERT INTO bhu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","फेर हइ मनसे सबरोज के सजा के निता पठोय जही, पय धरमी मनसे सबरोज के जीवन हे परवेस करही।” ");
INSERT INTO bhu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","हइ सगलू बातन के कहे के बाद यीसु अपन चेलन लग कथै, ");
INSERT INTO bhu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“तुम जानथा कि दुइ रोज के बाद फसह के तेउहार हबै अउ मनसे कर टोरवा बैरिन के दवारा क्रूस हे टंगाय के निता पकडामै बाले हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","तब खास पुजारी अउ सियान यहूदी नेता कैफा नाम के खास पुजारी के अंगना हे अक्ठी जिघा जुडिन। ");
INSERT INTO bhu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","अउ अपनै हे सोच बिचार करथै, कि यीसु के चुपके लग उके पकडवाय के मरवा डारी। ");
INSERT INTO bhu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","पय उन कथै, “हमके हइ तेउहार के टेम हे नेहको करै के चाही, कहुं असना झइ होय कि मनसे भगदड करै।” ");
INSERT INTO bhu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","जब यीसु बैतनिय्याह हे समोन कोढी के घर छो रथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ता एतका हे अक्ठी डउकी संगमरमर के खोरिया हे मंहगी महकनी तेल लइके यीसु के लिघ्घो आथै, जब ऊ भात खाय के निता बइठे रथै, ता ओखर मूड हे कुढाय देथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","हइ देखके चेला गुस्साय जथै अउ कहै लग जथै, “हइ महकनी तेल के काखे बरबाद करे गइस? ");
INSERT INTO bhu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","एही निक्खा दाम हे बेच सकत रहन अउ फेर ऊ पइसा के गरीबन हे बाट देतन।” ");
INSERT INTO bhu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","यीसु हइ बात सुनके अपन चेलन के कथै, “हइ डउकी के काखे तंग करथा? ऊ मोर निता निक्खा काम करै हबै। ");
INSERT INTO bhu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","गरीब मनसे तुम्हर संग हरमेसा रइहिन, पय मै तुम्हर संग हरमेसा नेहको रइहों। ");
INSERT INTO bhu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ऊ डउकी मोर देह हे जउन महकनी तेल के कुढाय हबै, ऊ मोर देह के गाडे जाय के निता करे हबै। ");
INSERT INTO bhu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","मै तुम्हर लग सही कथो, कि सगलू दुनिया हे जछो-जछो हइ मोर संदेस के परचार करे जही, उछो-उछो एखर काम के सुनाय जही अउ ओही सुरता करे जही।” ");
INSERT INTO bhu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","जब यहूदा इस्करियोती जउन बारहठे चेलन मसे अक्ठी रथै, जउन पुजारी के लिघ्घो जायके कथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","अगर मै यीसु के तुम्हर हाथ हे पकडवाय देहुं ता मोके काहिन दइहा? उन ओही तीसठे चांदी के खोटन्ना गिन के दइ देथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","अउ यहूदा उहै टेम लग यीसु के पकडोमै के मउका ढूंढै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","बेगैर खमीर रोटी के तेउहार के पहिले रोज चेला यीसु के लिघ्घो आयके पूछथै, “तै कछो चाहथस कि हम तोर निता खास तेउहार हे खाय के निता तइयारी करी?” ");
INSERT INTO bhu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","यीसु कथै, “सहर हे अमुक मनसे के लिघ्घो जाय के उके कहबे, कि गुरू कहे हबै मोर टेम लिघ्घो हबै, मै तोर घर हे अपन चेलन के संग तेउहार मनामै बाले हव।” ");
INSERT INTO bhu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","यीसु जसना आदेस दय रथै, चेला ओसनेन करथै अउ तेउहार के तइयारी करिन। ");
INSERT INTO bhu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","जब सांझ हुइ जथै ता यीसु अपन बारहठे चेलन के संग भात खाय के निता बइठथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","जब उन भात खथै ता यीसु उनखर लग कथै, “मै तुम्हर लग सही कथो कि तुम मसे अकझन मोके पकडोही।” ");
INSERT INTO bhu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","हइ बात सुनके चेला बोहत मुरझाय जथै अउ सगलू चेला ओखर लग पूछै लग जथै, “हे परभु, का ऊ मै तो नेहको हबो?” ");
INSERT INTO bhu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","यीसु जबाब देथै, “जउन मोर संग टठिया हे हाथ डार के खथै उहै मोके पकडोही। ");
INSERT INTO bhu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","मनसे कर टोरवा के बारे हे जसना किताब हे लिखवरे हबै, पय ऊ मनसे के लानत हबै, जउन मनसे के दवारा मनसे कर टोरवा पकडोय जही, ऊ मनसे के निता केतका निक्खा होतिस कि ऊ पइदा झइ होतिस।” ");
INSERT INTO bhu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","तब पकडोमै बाले यहूदा कथै, “हे गुरू मै जरूर उहै यहों तब ऊ ओखर लग कथै,” “तै सही कथस।” ");
INSERT INTO bhu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","जब उन भात खात रथै ता यीसु रोटी लेथै अउ आसीस मांग के टोरथै अउ चेलन के दइके कथै, “लेया, खा हइ मोर देह हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","फेर ऊ खोरिया लइके भगवान के धन्यबाद करथै अउ उनही दइके कथै, “तुम सबझन इके पिया, ");
INSERT INTO bhu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","काखे हइ टीमा के मोर खून हबै, जउन बोहत मनसेन के निता उनखर पाप के छमा करै के निता बहोय जही। ");
INSERT INTO bhu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","मै तुम्हर लग कथो, कि ऊ रोज तक अंगूर कर रस नेहको पिहों, जब तक अपन बाफ कर राज हे तुम्हर संग नबा अंगूर कर रस नेहको पिहों।” ");
INSERT INTO bhu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","फेरै यीसु तेउहार के भजन गायके जैतून डोंगर छो कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","तब यीसु उनखर लग कथै, तुम सबझन आजै के रात हे मोके छांड के भाग जइहा, काखे किताब हे लिखवरे हबै, मै बरेदी के मारहूं अउ गेडरन के झुन्ड तितर-बितर हुइ जइही। ");
INSERT INTO bhu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","पय मै जिन्दा होय के बाद हे तुम्हर लग पहिले गलील परदेस छो कढ जहुं। ");
INSERT INTO bhu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","पतरस हइ बात सुनके कथै, सबझन बिस्वास लग चाहे भले डगमगाय के छांड दइहिन, पय मै तोके नेहको छडिहों। ");
INSERT INTO bhu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","यीसु ओखर लग कथै, मै तोर लग सही कथो कि आज के रात हे कुकडी बांसही, ओखर पहिले तै मोके तीन बार चिन्है लग इन्कार करबे। ");
INSERT INTO bhu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","पतरस यीसु लग कथै, अगर मोके तोर संग मरैके पडही। तउ मै तोके चिन्है लग कबहुन मना नेहको करिहों अउ बाकी चेला ओसनेन कथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","तब यीसु अपन चेलन के संग गतसमनी नाम के अक्ठी जिघा हे जथै अउ अपन चेलन के कहै लागथै, इहै छो बइठिहा जब तक मै बिनती करै जथो। ");
INSERT INTO bhu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","फेर यीसु पतरस अउ जबदी के दोनोठे टोरवा के अपन संग लइ जथै, ऊ दुख अउ उकुल-बुकुल महसूस करै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","फेर यीसु उनखर लग कथै, “मोर मन बोहत मुरझाय हस हबै, जसना की मोर जीव निकडै बाले हबै, तुम इहै छो रूका अउ मोर संग जागत रइहा।” ");
INSERT INTO bhu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","फेर यीसु चुटु दुरिहां जाय के मुंह के बल गिरथै अउ बिनती करै लग जथै, “हे मोर बाफ हुइ सकै ता मरै के दुख के खोरवा मोर लग टर जाय, तउभरमा जसना मै चाहथो ओसना नेहको पय जसना तै चाहथस ओसनेन होय।” ");
INSERT INTO bhu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","फेर यीसु चेलन के लिघ्घो आथै ता उनही सोउत पाथै अउ पतरस लग कथै, “का तुम तीनो मोर संग अको घरी नेहको जाग सकथा? ");
INSERT INTO bhu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","जागत रहा अउ बिनती करत रहा, कि तुम परिक्छा हे झइ पडिहा आतमा तइयार हबै, पय देह ढिलवा हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","फेर यीसु दूसर बार जाय के हइ बिनती करथै, “हे मोर बाफ अगर हइ दुख के खोरवा पिये बिना नेहको टर सकथै, ता तोर इक्छा पूर होय।” ");
INSERT INTO bhu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","तब यीसु चेलन के लिघ्घो आयके देखथै, ता उनही फेरै सोउत पाथै, काखे उनखर आंखी नींद लग मुदरथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","यीसु उनही छांडके फेर कढ गइस अउ उहै मेर फेर तीसर बार बिनती करथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ता यीसु चेलन के लिघ्घो आयके कथै, “का तुम अबहुन तक आराम लग सोथा? सुना ऊ टेम आय गय हबै अउ मनसे कर टोरवा पापिन मनसेन के हाथ हे पकडोय जाय बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उठा, चला देखा मोर पकडै बाले लिघ्घो आय गय हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","यीसु हइ बात कहत रथै, कि यहूदा जउन बारहठे चेलन मसे अक्ठी रथै, ऊ आथै अउ ओखर संग परधान पुजारी, यहूदी सिपाही अउ सियान के बोहत भीड तलबार लठिया लइके आथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","यहूदा जउन यीसु के पकडोय बाले रथै, उनके हइ इसारा देयत कथै कि जेही मै चुम्मा लइहों, उहै यीसु होही उके पकड लइहा। ");
INSERT INTO bhu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","अउ हरबी यीसु के लिघ्घो आयके कथै, हे गुरू नमस्ते अउ ओही बोहत चुम्मा लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","यीसु उनखर लग कथै, हे संगी जउन काम के निता तुम आय हबा। ऊ करा तब उन ओखर लिघ्घो आयके पकड लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","यीसु के चेलन मसे अकझन तलबार निकाडथै अउ पुजारी के सैनिक के कान के काट देथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ता यीसु चेलन लग कथै, “अपन तलबार धर लेया, काखे जउन तलबार चलाथै उन सबझन तलबार लग मारे जइहिन। ");
INSERT INTO bhu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","का तुम नेहको जानथा कि मै अपन बाफ लग बिनती करके अउ स्वरगदूतन के बारहठे सिपाहिन लग कहुं जादा मोर लिघ्घो पठोय देही? ");
INSERT INTO bhu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","पय अगर मै असना करिहों ता पवितर किताब हे लिखवरे हर हइ कइसन पूर होही? हइ होना जरूरी हबै हइ ओसनेन होय।” ");
INSERT INTO bhu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ऊ टेम यीसु मनसेन के भीड लग कथै, का तुम तलबार अउ लठिया लइके मोके चोरटन के जसना पकरै के निता इछो आय हबा? मै सबरोज बिनती भवन हे बइठके संदेस देय करत रहों, ता तुम मोके नेहको पकरा। ");
INSERT INTO bhu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","पय हइ सब इहैनिता होथै, कि ग्यानी मनसेन के पवितर किताब हे जउन लिखररे हबै ऊ बात पूर होय। एतका हे सगलू चेला यीसु के छांड के भाग जथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","तब यीसु के पकर के कैफा नाम के पुजारी के लिघ्घो लइ जथै, जछो गुरू अउ सियान जुडेहर रथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ता पतरस दुरिहां पाछू-पाछू पुजारी के अंगना तक आथै, उछो सिपाहिन के संग बइठके हइ देखथै, कि का होथै हइ देखथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","पुजारी अउ सगलू दरबार यीसु के मारै अउ उके फसामै के निता झूठी गवाह ढूंढथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","बोहत मनसे झूठी गवाही देथै पय उन यीसु के नेहको फसा सकिन, आखिर हे दुइझन बोलिन, ");
INSERT INTO bhu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“हइ मनसे कथै, मै भगवान के मन्दिर के गिराय सकथों अउ उके तीसर रोज हे ठाड कर सकथों।” ");
INSERT INTO bhu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","तब पुजारी ठाड हुइ के यीसु लग कथै, “इन मनसे तोर बिरोध हे जउन अरोप थोपथै, का एखर जबाब तोर लिघ्घो नेहको हबै?” ");
INSERT INTO bhu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","पय यीसु चुप्पे रथै, ता पुजारी कथै मै तोके जिन्दा भगवान के किरिया देथो, अगर तै भगवान कर टोरवा मसीह हबस, ता हमके गुठे। ");
INSERT INTO bhu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","यीसु उनखर लग कथै, “हव, मै हबो। पय मै तुमही गुठेथो कि अब ले तुम मनसे कर टोरवा के ऊ सबले सक्तिमान भगवान के दहिना पल्ला बइठे हर अउ आसमान के बादर हे आउत देखिहा।” ");
INSERT INTO bhu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","पुजारी हइ सुनके एतका गुस्साय गइस कि ऊ अपन बन्डी चीर डारथै अउ कथै, “हइ जउन बात कहे हबै ऊ भगवान के बुराई के बात करे हबै, अब हमही अउ कउनो गवाह के जरूरत नेहको हबै, काखे सबझन भगवान के बिरोध हे कहत सुने हबन। ");
INSERT INTO bhu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ता तुम काहिन सोचथा?” उन सबझन जबाब देथै, “हइ अपराधी हबै। हइ मिरतू के ओग हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","तब उन यीसु के मुंह उप्पर थूंकथै अउ उके मुटका मारथै अउ दूसर मनसे झापड मारके कथै, ");
INSERT INTO bhu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“हे मसीह, अगर तै मसीह हबस ता हमके आगू कर बात गुठे कि तोके कोन हर मारे हबै?” ");
INSERT INTO bhu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ता पतरस बाहिर छो अंगना हे बइठे रथै, कि अक्ठी हरवाहिन ओखर लिघ्घो आयके कथै, “तहु गलीली के रहैबाले यीसु के संग रहस।” ");
INSERT INTO bhu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","तब पतरस सबझन के आगू मना करत कथै, “मै नेहको जानथो तै काहिन कथस।” ");
INSERT INTO bhu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","जब पतरस बाहिर फेरका हे गइस, ता दूसर नोकरानी उके देखिस अउ ऊ ठाडे मनसेन लग कथै, “हइ मनसे यीसु नासरी के संग रथै।” ");
INSERT INTO bhu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","तब पतरस किरिया खाय के फेरै मना करथै, “मै ऊ मनसे के नेहको जानथो।” ");
INSERT INTO bhu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","एखर चुटु टेम के बाद अगल-बगल मनसे ठाडे रथै, ता पतरस के लिघ्घो आयके कथै, “सहीमा तै उनखर मसे अकझन हबस, काखे तोर बोली लग पता चलथै।” ");
INSERT INTO bhu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","तब पतरस गुस्साय के किरिया खाय लग जथै, मै ऊ मनसे के नेहको जानथो, “तब ओतकै टेम कुकडी बांस देथै। ");
INSERT INTO bhu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","तब पतरस के यीसु के गुठे हर बात सुरता आथै, कि तै कुकडी बासै के पहिले तीन बार मोके मना करबे।” अउ पतरस बाहिर छो जाय के सिसक-सिसक के रोमै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","सुबेन्नेन टेम सगलू परधान पुजारी अउ समाज के यहूदी सियान यीसु के मरवामै के निता सोंचथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","फेर उन यीसु के बांधिन अउ लइ जाय के राज्यपाल पिलातुस के पकरा देथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","यीसु के पकडवामै बाले यहूदा जब हइ देखथै कि यीसु के दोसी ठहराथै, ता ऊ बोहत पछताइस अउ ऊ परधान पुजारी अउ सियान यहूदी नेतन के चांदी के ऊ तीसठे खोटन्ना लउटा देथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ऊ कथै, “मै अक्ठी बेकसूर मनसे के मार डारे के निता पकरवाय के पाप करे हबो” उन मनसे कथै, “हमही एखर ले का मतलब? तै जान।” ");
INSERT INTO bhu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ता यहूदा चांदी के खोटन्ना के मन्दिर के भित्तर फटक के कढ गइस अउ बाहिर जाय के फांसी लगाय लइस। ");
INSERT INTO bhu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","परधान पुजारी ऊ खोटन्नन के उठाय लेथै अउ कथै, हमर नियम के जसना हइ खोटन्नन के बिनती भवन के भन्डार छो रखैके उचित नेहको हबै, काखे एखर खरचा कउनो के खून के निता करे गय रहिस। ");
INSERT INTO bhu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","इहैनिता उन उहै पइसा लग कुम्हरा के खेतबा खरीदय के फइसला करिन, कि जउन बाहिर लग यरुसलेम आमै बाले परदेसी मनसे जउन मर जथै, उनही इहै खेतबा हे गाडे जही। ");
INSERT INTO bhu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","इहैनिता अबहुन तकमा ऊ खेत के खून के खेत के नाम लग जाने जथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","इहैमेर भगवान के ग्यानी मनसे इरमियाह के दवारा कथै हइ बचन पूर हुइस, “उन चांदी के तीसठे खोटन्ना लेथै, ऊ पइसा जेही इस्राएल के मनसे उके देय के निता जुगाड बनाय रथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","अउ परभु दवारा मोके दय गय आदेस के जसना ओखर लग कुम्हरा के खेतबा खरीद लेथै।” ");
INSERT INTO bhu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","यीसु के राज्यपाल के आगू लानथै, अउ राज्यपाल ओखर लग पूछथै, “का तै यहूदी मनसे के राजा हबस?” यीसु कथै, “हव जसना तुम कहत हबा।” ");
INSERT INTO bhu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","दूसर पल्ला लग परधान पुजारी अउ सियान यहूदी नेता ओखर उप्पर दोस लगाउत रथै, पय यीसु कउनो जबाब नेहको देथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","तब पिलातुस ओखर लग पूछथै, “का तै नेहको सुनथस कि उन तोर उप्पर केतका दोस लगाथै।” ");
INSERT INTO bhu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","पय यीसु पिलातुस के कउनो दोस के जबाब नेहको देथै अउ पिलातुस हइ बात लग बोहत चकित हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","तेउहार के मोका हे राज्यपाल के परम्परा रथै, कि ऊ कउनो अक्ठी कैदी के जेही मनसेन के भीड चाहथै, उके उनखर निता छांड देथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","यीसु के टेम बरअब्बा नाम के अक्ठी बदनाम जेलियर उहां रथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","पिलातुस उनखर लग पूछथै, “तुम काहिन चाहत हबा मै तुम्हर निता केही छांडव, बरअब्बा के या यीसु के जउन मसीह कहाथै?” ");
INSERT INTO bhu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","पिलातुस जानथै कि उन उके डाह के कारन पकरवाय हबै। ");
INSERT INTO bhu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","पिलातुस जब नियाव के गद्दी हे बइठथै, ता ओखर डउकी ओखर लिघ्घो अक्ठी खबर पठोथै, “ऊ धरमी मनसे के संग कुछु झइ करबे, काखे मै ओखर बारे हे अक्ठी सपना देखे हमो, जेखर लग मै आज सगला दिन बैजुन्ग रहे हबो।” ");
INSERT INTO bhu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","पय परधान पुजारी अउ सियान यहूदी नेता मनसे के भीड के बहकाथै-उकसाथै, कि उन पिलातुस लग बरअब्बा के छांडै के निता अउ यीसु के मारे के निता मांग करथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","राज्यपाल मनसेन लग पूछथै, “तुम काहिन चाहथा? दोनो झन मसे तुम्हर निता केही छांडो,” उन जबाब देथै “बरअब्बा के।” ");
INSERT INTO bhu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","तब पिलातुस उनखर लग पूछथै, “ता मै यीसु के काहिन करव जउन मसीह कहाथै?” सबझन कथै, “उके क्रूस हे टंगाबा।” ");
INSERT INTO bhu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","पिलातुस पूछथै, “ऊ काहिन अपराध करे हबै?” पय उन अउ बोहत चिरलाय लागथै, “उके क्रूस हे टांगय देया।” ");
INSERT INTO bhu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","जब पिलातुस देखथै कि यीसु के बचामै के निता कउनो जुगाड नेहको हबै, बलुक मनसेन के चिरलाना अउ गुस्सा भडकत जथै, ता ऊ पानी मंगवाय के मनसेन के आगू अपन हाथ धोय के कथै, “मै हइ धरमी मनसे के खून के दोसी नेहको हबो, एही अब तुम जाना।” ");
INSERT INTO bhu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","सगला मनसे जबाब देथै, “एखर खून के जबाबदारी हमर हे अउ हमर लरकन हे होही।” ");
INSERT INTO bhu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","तब पिलातुस उनखर निता बरअब्बा के छांड देथै अउ यीसु के कोडा लगवाय के क्रूस हे टंगामै के निता सिपाहिन के दइ देथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","फेर सिपाही यीसु के राज्यपाल के घर के भित्तर लइ जथै, उछो ओखर चारो पल्ला सिपाही बोहत बड घर हे जुडथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","उन यीसु के बन्डी उतार देथै अउ चमकै बाले लाल रंग के बन्डी पहिनाथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","कांटा बाले पुडरा के बने हर अक्ठी मुकुट मेर ओखर मूड हे धर देथै अउ ओखर दहिना हाथ हे अक्ठी डंडा धरा देथै अउ ओखर आगू निहुर के मजाक उडाउत कथै, “यहूदी के राजा नमस्ते।” ");
INSERT INTO bhu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","फेर उन ओखर मुंह हे थूकिन अउ डंडा छंडाय के ओखर मूड हे मारै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","जब ओखर मजाक उडा चुकथै ता यीसु के बन्डी के उतार लइन अउ ओखर खुद के बन्डी के पहिराय के क्रूस हे टंगामै के निता लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","जब सहर लग निकडत टेम सिपाही कुरैन के रहै बाले समोन नाम के अक्ठी कुरेनी के पाथै, उन ओखर उप्पर दबाव डारिन कि यीसु के क्रूस के उठाय के रेंगै। ");
INSERT INTO bhu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","जब उन गुलगुता जेखर मतलब हबै, “खोपडी के जिघा।” ऊ जिघा हे पहुंचिन, ");
INSERT INTO bhu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","उन यीसु के जहर मिलेहर दारू पिये के निता देथै, यीसु उके चीखिस पय उके पिये लग मना कर देथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","सिपाही यीसु के क्रूस हे टंगाय देथै अउ चिट्ठी डार के जेखर नाम आइस उन ओखर बन्डी के अपन हे बांट लेथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","एखर बाद हे सिपाही उछो बइठ के उके ताकथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","उन यीसु के मूड के उप्पर ओखर दोस चिट्ठी लिखके टंगाय देथै, “हइ यहूदी के राजा यीसु हबै।” ");
INSERT INTO bhu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","उहै टेम यीसु के संग उन दुइठे चोरटन के क्रूस हे टंगाथै, अकझन के दहिना पल्ला अउ दूसर के टेटरा पल्ला। ");
INSERT INTO bhu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","उछो लग आमै-जाय बाले मनसे यीसु के बुराई करत अउ मूड डोलाउत, ");
INSERT INTO bhu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","हइ कथै, “अरे मन्दिर के गिरामै बाले अउ तीन रोज हे ओही फेरै लग बनामै बाले, खुद के बचा। अगर तै भगवान कर टोरवा हबस ता क्रूस लग तरी छो उतर आ।” ");
INSERT INTO bhu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ओसनेन परधान पुजारी, नियम के गुरू अउ सियान यहूदी नेतन के संग ओही हइ कहिके मजाक उडाथै, ");
INSERT INTO bhu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“दूसर के मुकति करै बाले हइ अपन मुकति नेहको कर सकथै, हइ इस्राएल के राजा हबै, हइ क्रूस लग अभिनैन तरी उतरै ता हमु बिस्वास करबो। ");
INSERT INTO bhu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","हइ भगवान हे बिस्वास करथै अगर भगवान एखर लग मगन हबै, ता अब इके बचामै, काखे हइ कहे रहिस, मै भगवान कर टोरवा हबो।” ");
INSERT INTO bhu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","जउन चोरटा यीसु के संग क्रूस हे टंगाय रथै, उनो इहैमेर यीसु के मजाक उडाथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","एखर बाद हे दुपहरी लग लइके तीन बजे तक सगलू भुंइ हे बोहत अंधियार छाय गइस। ");
INSERT INTO bhu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","करीबन तीन बजे यीसु बोहत आरो लग चिरलाथै, “एली-एली लमा सबक्तनी?” एखर मतलब हबै, “हे मोर भगवान हे मोर भगवान तै मोके काखे छांड दय?” ");
INSERT INTO bhu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","उहां ठाडे मसे कुछ मनसे हइ सुनके कथै, हइ एलिय्याह के गोहराथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","फेर हरबी उनखर मसे अक्ठी मनसे दउरके सिरका हे बुडाय के स्पंज अक्ठी डंडा हे टांग के लानथै अउ यीसु के पिये के देथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","पय दूसर मनसे कहत रथै, कि छांडा देखथन कि एलिय्याह इके बचामै आथै या नेहको। ");
INSERT INTO bhu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","यीसु फेर बोहत आरो लग चिरलाथै अउ ओखर परान निकड जथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","उहै टेम मन्दिर के परदा उप्पर लग तरी तक चिथर के दुइठे खन्डा हुइ जथै अउ भुंइ थरथराय जथै अउ पटपर फट जथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","अउ इहां तक कि मरघटी के पथरा उघर जथै अउ भगवान के मनसे मसे मरे हर बोहत देह जी उठथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ऊ यीसु के जिन्दा होय के बाद हे ऊ मरघटी लग निकड के यरुसलेम सहर छो जथै अउ बोहत मनसे उनही देखिन। ");
INSERT INTO bhu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","रोमी सिपाही अउ ओखर संग जउन मनसे यीसु के चवकीदारी करथै, भुंइडोल अउ दूसर घटना के देखके डेराय जथै अउ कहै लागथै “हइ सहीमा भगवान कर टोरवा रहिस?” ");
INSERT INTO bhu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","उहां बोहत डउकी दुरिहां लग देखथै, जउन गलील सहर लग यीसु के सेबा करे रथै अउ ओखर मदद करे रथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","उन मसे मरियम मगदलीनी याकूब अउ योसेस के दाय अउ जबदी के लरका के दाय रथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","संझा हुइ जाय के बाद अरिमतियाह सहर लग यूसुफ नाम के धन्नड मनसे आथै, ऊ खुदय यीसु के चेला बन गय रथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ऊ पिलातुस राजा कर लिघ्घो जाय के यीसु के लोथ मांगथै अउ पिलातुस आदेस देथै कि लोथ उनही दइ दे जाय। ");
INSERT INTO bhu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","यूसुफ यीसु के लोथ के लइ जायके सुध्द साफ पिछउरी हे लपेटिस। ");
INSERT INTO bhu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","अउ ऊ नबा मरघटी हे मढाय देथै, जेही ऊ पथरा के काट के अपन निता बनवाय रथै, फेरै ऊ पथरा के माडा के दूरा हे अक्ठी बड्डे पथरा के ढनगाय के कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","मरियम मगदलीनी अउ दूसर डउकी मरियम उहां मरघटी के आगू बइठे रथै। ");
INSERT INTO bhu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","अगले रोज जउन सुस्ताय के रोज रथै, खास पुजारी अउ फरीसी पिलातुस के लिघ्घो गइन। ");
INSERT INTO bhu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","उन कथै, “परभु हमके सुरता हबै, कि ऊ नरै बाले अपन बीते हर टेम हे कहे रथै, कि मै तीन रोज बाद फेरै जी उठिहों। ");
INSERT INTO bhu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","इहैनिता तीसर रोज तक मरघटी कर देखरेख करै के आदेस दय जाय, कहुं असना झइ होय कि ओखर चेला ओखर लोथ के चुराय झइ लइ जाय अउ मनसेन लग कइहिन कि मरे हर मसे जिन्दा हुइ गय हबै, हइ आखरी झूठ पहिले लग बोहत बेकार होही।” ");
INSERT INTO bhu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पिलातुस उनखर लग कथै, “तुम्हर लिघ्घो चवकीदार हबै, जा अउ जसना तुमके निक्खा लगै ओसनेन देखरेख के जुगाड करा।” ");
INSERT INTO bhu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","उन कढ जथै अउ उन मरघटी के माडा के दूरा कर पथरा हे सील लगाइन अउ चवकीदारन के मरघटी हे ताकै के निता बइठाय देथै। ");
INSERT INTO bhu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","सुस्ताय कर रोज कर बाद हप्ता के पहिलेन रोज अइतवार के सुबेन्नेन रथै, मरियम मगदलीनी अउ दूसर मरियम मरघटी के देखै आथै। ");
INSERT INTO bhu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","काखे स्वरग लग परभु कर अक्ठी स्वरगदूत उहां उतरथै अउ ऊ टेम बोहत भुंइडोल हुइस, स्वरगदूत उहां आयके पथरा के टरकाय के ओहमा बइठ गइस। ");
INSERT INTO bhu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ओखर रूप बादर के बिजली के जसना चमकथै अउ ओखर बन्डी बरफ के मेर रथै। ");
INSERT INTO bhu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","स्वरगदूत के देखके चवकीदार थरथराय लागथै अउ डेराय गइन। ");
INSERT INTO bhu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","तब स्वरगदूत डउकिन लग कथै, “झइ डेराबा, काखे मोके पता हबै, जउन यीसु के क्रूस हे चढाय रथै, ओही तुम ढूंढथा। ");
INSERT INTO bhu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ऊ इछो नेहको हबै, पय ऊ कहे हर बचन के जसना जी उठे हबै, स्वरगदूत कथै, आबा ऊ जिघा देखा जछो ओखर देह धररे रथै। ");
INSERT INTO bhu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","अब हरबी जाय के ओखर चेलन के गुठेबा, कि यीसु मरे हर मसे जिन्दा हुइ गय हबै अउ ऊ तुम्हर लग पहिले गलील छो पहुंचही, तुम उहै ओही पइहा, जउन मै तुम्हर लग कहे हव उके सुरता रखिहा।” ");
INSERT INTO bhu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","उन डउकी हरबी मरघटी लग कढ गइन अउ उन डेरात अउ मगन लग भर जथै अउ यीसु के चेलन के संदेस देय के निता दउरत गइन। ");
INSERT INTO bhu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","यीसु अचनकै गली हे उन डउकिन लग मिलथै अउ कथै, “खुस रहा” उन यीसु के लिघ्घो आइन ओखर परनाम करके भजन करिन। ");
INSERT INTO bhu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","तब यीसु उनखर लग कथै, “झइ डेराबा, जा अउ मोर भाई के हइ संदेस देया, कि ऊ गलील परदेस छो जाय उहैं मोके पइहिन।” ");
INSERT INTO bhu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","जब उन डउकी गलिन हे रथै, ता जउन कुछु घटना घटे रथै चवकीदार सहर हे आयके उन परधान पुजारिन के सगलू कुछ बात गुठे देथै। ");
INSERT INTO bhu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","जब उन सियानन के संग अकजुट हुइके बात चीत करथै अउ चवकीदारन के बोहत पइसा दइके कथै, ");
INSERT INTO bhu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","मनसेन लग हइ कइहा कि रात हे जब हम सोउत रहन, ता ओखर चेला आयके ओखर लोथ के चोराय लइ गइन। ");
INSERT INTO bhu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","पय हइ बात बडे साहब राज्यपाल के लिघ्घो पहुंचही, ता हम उके समझाय लेयब अउ तुम्हर निता कउनो चिन्ता के बात नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","उन चवकीदार पइसा लइके ओसनेन करथै, जसना उनखर लग कहे रथै, हइ किस्सा फइल गइस अउ हइ बात आज तक यहूदी मनसे जानथै। ");
INSERT INTO bhu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","तब ग्यारठे चेला गलील परदेस के ऊ डोंगर हे कढ गइन, जिहां यीसु चेलन के जाय के आदेस दय रथै। ");
INSERT INTO bhu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","उन यीसु के देखके ओखर गोड तरी गिरके परनाम करथै, पय कुछ चेलन के सक होथै। ");
INSERT INTO bhu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","यीसु उनखर लिघ्घो आयके कथै, “मोके स्वरग हे अउ भुंइ हे सगलू हक दय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","इहैनिता जाय के सगलू देसन के मनसेन के चेला बनाबा अउ उनही बाफ, टोरवा अउ पवितर आतमा के नाम लग पानी हे बतिस्मा देया। ");
INSERT INTO bhu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","जउन बात मै तुमही आदेस दय हबो, उनके मानय के सिखाबा अउ देखा, हइ दुनिया कर आखरी तक हरमेसा तुम्हर संग हबो।”");
INSERT INTO bhu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","भगवान कर टोरवा यीसु मसीह कर संदेस सुरू। ");
INSERT INTO bhu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","जसना यसायाह ग्यानी मनसे के किताब हे लिखवरे हबै: “देखा मै अपन दूतन के तोर आगू पठोहूं, जउन तुम्हर निता गली तइयार करही। ");
INSERT INTO bhu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","कउनो मनसे पटउरा लग गोहराथै, परभु के गली तइयार करा अउ पकडंडी गली सिध्धा करा।” ");
INSERT INTO bhu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","इहैनिता यूहन्ना आथै, “जउन पतेरा छो पानी लग बतिस्मा देथै,” “अउ अपन पाप लग छमा के निता मन बदलै के बतिस्मा के परचार करथै।” ");
INSERT INTO bhu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","सगलू यहूदी इलाका अउ यरुसलेम सहर के बोहत मनसे यूहन्ना के लिघ्घो आथै, अउ अपन पाप के मानके यरदन नदिया हे ओखर लग बतिस्मा लेथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यूहन्ना उंटवा के चूंदी के बन्डी बनाय के ओढथै अउ कनिहा हे खलरी बांधे रथै, ऊ चिड्डा अउ रस खाय करथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","यूहन्ना परचार करथै, “मोर बाद आमै बाले हबै, मोर लग बड्डे बल बाले हबै, मै ओखर बूट के डोरा बांधे लायक नेहको हव। ");
INSERT INTO bhu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","मै तोके पानी लग बतिस्मा देथो, पय ऊ तोके पवितर आतमा लग बतिस्मा देही।” ");
INSERT INTO bhu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","उन रोज हे यीसु यहूदियन इलाका गलील के नासरत नगर छो आथै, अउ यूहन्ना के दवारा यरदन नदिया हे बतिस्मा लेथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","जब यीसु पानी लग उप्पर निकडथै बादर उघरथै, अउ भगवान कर आतमा परेवा के जसना ओखर उप्पर उतरत दिखाई देथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ता बादर लग आरो आथै, तै मोर पिरिया टोरवा हबस, मै तोर लग बोहत मगन हव। ");
INSERT INTO bhu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","हरबी भगवान कर आतमा, यीसु के पतेरा छो लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","पटउरा हे चालीस रोज अउ चालीस रात भुतवा यीसु के परिक्छा लेथै, अउ ऊ गोरुन के संग रहिस, अउ स्वरगदूत ओखर सेबा करत रथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","यूहन्ना के जेल हे जाय के बाद हे, यीसु गलील नगर छो आयके भगवान कर राज के संदेस परचार करथै, ");
INSERT INTO bhu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","यीसु कथै, “टेम पूर हुइस भगवान कर राज लिघ्घो आ गय हबै, अपन पापन के छांड देया, अउ संदेस हे बिस्वास करा।” ");
INSERT INTO bhu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","गलील के दहार के बगल हे जात टेम, यीसु समोन अउ ओखर भाई अन्द्रियास के दहार हे जाला फन्दाउत देखथै, काखे ऊ मनसे ढिमरा रथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","यीसु उनखर लग कथै, तुम मोर पाछू हुइ लेया मै तुमके मछडी पकडै बाले के जिघा हे मनसेन के भगवान कर राज हे लामै बाले बनाहुं। ");
INSERT INTO bhu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ढिमरा मनसे हरबी जाला के छांड के, यीसु के पाछू आ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","एखर बाद जबदी के टोरवा याकूब, अउ याकूब के भाई यूहन्ना के नाह जिहाज हे जाला के सुधारत देखथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ऊ हरबी याकूब अउ यूहन्ना के बुलाथै, अउ ऊ अपन बाफ जबदी के काम करै बाले के संग नाह जिहाज के छांड के यीसु के पाछू आ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","यीसु ओखर चेला कफरनहूम इलाका हे आथै, जउन यहूदियन के सुस्ताय कर रोज मंडली हे जाय के सिक्छा देय लगथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","यीसु मूसा कर नियाव के गुरू के जसना नेहको बलुक बड्डे हक के जसना सिक्छा देथै, इहैनिता मनसे ओखर बातन लग बोहत चकरा जथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","यहूदी मंडली हे अक्ठी मनसे आय रथै, जउन भुतवा लग जकडरे रथै, ");
INSERT INTO bhu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","भुतवा चिरलायके कथै, “हे यीसु नासरी मोके तोर लग कउनो काम नेहको आय? का तै हमके मारै आय हवस? मै तोके जनथो, भगवान के दवारा पठोय हर पवितर मनसे हबस।” ");
INSERT INTO bhu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","यीसु भुतवा के गधारे के कथै, “चुप रह, अउ मनसे के जीवन लग निकड जा।” ");
INSERT INTO bhu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ता भुतवा मनसे के मरोडथै, अउ बोहत चिरलायके मनसे के जीवन लग निकड जथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","तब यहूदिन के बिनती भवन हे बइठे हर मनसे बोहत चकराय जथै, अउ अपन हे गुठेमै लागथै, “ई काहिन बात हबै? हइ तो कउनो नबा संदेस हबै ऊ हक के संग भुतवा के आदेस देथै, अउ भुतवा ओखर बातन के मानथै।” ");
INSERT INTO bhu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","यीसु के संदेस हरबी गलील इलाका के अगल-बगल के पूरे परदेस हे बगर जथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","यहूदी मंडली लग निकडके, अपन चेला याकूब अउ यूहन्ना के संग हे समोन अउ अन्द्रियास के घर आथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","यीसु के गुठेथै कि समोन के फुवा नंगाय हबै, अउ उन हरबी ओखर बारे हे ओखर लग कथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","तब ओखर लिघ्घो गइस अउ ओखर हाथ पकडके उके उठाथै, अउ उहै टेम ओखर नांगा निक्खा हुइ जथै, अउ यीसु के सेबा करै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","सांझ के टेम जब बेरा बुढे लगथै, ता मनसे अपन कइन मेर के नंगहन के अउ जउन मनसे के भुतवा पकडे रथै उके यीसु के लिघ्घो लानथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","अउ नगर के सगलू मनसे घर के दूरा के लिघ्घो पहुंच जथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","यीसु कइन मेर के नंगहन के निक्खा करथै अउ बोहत भुतवन के भगाथै, अउ भुतवन के बोलै नेहको देथै, काखे ऊ ओही चीनथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","कुकडी बोलै लग आगू यीसु उठके अउ घर के छांड के, बिनती करै के निता सुनसान जिघा हे कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","तब समोन अउ ओखर संगी यीसु के खोजै लग जथै, ");
INSERT INTO bhu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","तब यीसु के पा जथै, ता ओखर लग कथै “तोके सगलू मनसे खोजथै।” ");
INSERT INTO bhu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","यीसु उनखर लग कथै, “हम दूसर इलाका हे जउबे, अउ उछो मोके परचार करैका हबै, काखे कि मै इहैनिता आय हव।” ");
INSERT INTO bhu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","इहैनिता यीसु सगलू गलील इलाका हे अउ ओखर मंडली हे जाय के परचार करत रथै अउ भुतवा के निकाडत रथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","अक्ठी कोढी मनसे यीसु कर लिघ्घो आथै, अउ बिनती करिस, “अउ ओखर आगू घुटवा टेक के कथै, तै चाहबे ता मोके सुध्द कर सकथस।” ");
INSERT INTO bhu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","यीसु ओखर परति दया लग भर जथै, अउ कोढी के छिके कथै, “मै चाहथो कि तै सुध्द हुइ जा।” ");
INSERT INTO bhu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ऊ मनसे कोढ लग सुध्द हुइ जथै, अउ ओखर खलरी निक्खा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","तब यीसु उके हरबी चेतन्न करके पठो देथै, ");
INSERT INTO bhu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","यीसु कोढी लग कथै, “देख, कउनो के कुछु झइ गुठेबे, पय जाय के अपन खुद के पुजारी के देखाबे, अउ सुध्द होमै के बारे हे गुठेबे, मूसा जउन नियाव ठहराय हबै, उके बलि चढावा अउ उनखर हे गवाह होय।” ");
INSERT INTO bhu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ऊ मनसे अपन निक्खा होय के बारे हे जाय के परचार करथै, इहै कारन लग यीसु के छुट्ठम छुट्ठा नगर हे जाय के बन्द हुइ जथै, ऊ डोंगर छो रहे लागथै, अउ चारो चउगिरदा लग मनसे ओखर लिघ्घो आउत रथै। ");
INSERT INTO bhu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","कुछ रोज के बाद ऊ कफरनहूम सहर छो आथै, अउ उहां के पूरे इलाका हे खबर बगर जथै, कि यीसु घर हे हबै सबरोज के जसना रहै करत रथै। ");
INSERT INTO bhu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","एतका झन मनसे उहां अकजुट होथै, कि दूरा के लिघ्घो तक जिघा नेहको रथै, अउ यीसु संदेस के परचार करै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ता चारठे मनसे लोकवा बाले मनसे के यीसु के लिघ्घो लानथै। ");
INSERT INTO bhu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","बोहत भीड के कारन ओखर लिघ्घो नेहको पहुंचथै, ता उन जछो ऊ रथै, उहै के छानी के खपरा के टरकाय के ऊ लोकवा मनसे के खटिया सहित यीसु कर आगू उतार देथै। ");
INSERT INTO bhu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","यीसु चारोठे मनसे के बिस्वास के देखके लोकवा मनसे लग कथै, “हे टोरवा तोर पाप छमा हुइस।” ");
INSERT INTO bhu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","उहां बइठे नियाव के गुरू अपन-अपन मन हे खयाल करै लागथै, ");
INSERT INTO bhu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“हइ मनसे असना कसना कथै? ई तो भगवान के बुराई करथै, ओखर बगैर कउनो पाप छमा नेहको कर सकथै।” ");
INSERT INTO bhu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","यीसु हरबी अपन आतमा हे जान लेथै, कि नियाव के सिक्छा दे बाले अपन मन हे असना खयाल करथै, इहैनिता ऊ उनखर लग कथै, “तुम अपन मन हे काखे खयाल करथा? ");
INSERT INTO bhu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","का ई बोहत लिखडी हबै कि लोकवा बाले मनसे लग कहों, कि तोर पाप छमा हुइस, या ई कहों कि अपन खटिया उठाय के रेंग बाग? ");
INSERT INTO bhu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","पय तुम जान लेया कि मनसे कर टोरवा के भुंइ हे पाप छमा करै के हक हबै।” ऊ लोकवा नंगहा लग कथै, ");
INSERT INTO bhu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“मै तोर लग कथो, उठ, अउ अपन खटिया के उठाय के अपन घर छो कढ जा।” ");
INSERT INTO bhu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ऊ हरबी उठथै, अउ अपन खटिया के उठाय के अपन घर छो कढ जथै, उहां बइठे मनसे देखके सगलू चकरा जथै, अउ भगवान के महिमा करथै, “हम असना कबहुन नेहको देखे हबन।” ");
INSERT INTO bhu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","यीसु फेरै लग गलील दहार के पाखा हे जथै, अउ सगलू झन ओखर लिघ्घो आ जथै अउ ऊ संदेस गुठेमै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","जइसनैन ऊ पइसा उगाहै बाले के जिघा लग जात रथै, उहै हलफई के टोरवा पइसा उगाहै बाले के जिघा हे बइठे हर देखथै, ता ओखर लग कथै “तै मोर पाछू हुइ जा” अउ लेवी यीसु के पाछू हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","जब यीसु अउ चेला लेवी के घर हे भात खाय के निता बइठे रथै, ता बोहत मनसे पइसा उगाहै बाले अउ पापिन ओखर संग बइठके भात खाथै। ");
INSERT INTO bhu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","कुछ नियाव के गुरू अउ फरीसी ई देखथै, कि यीसु पइसा उगाहै बाले अउ पापिन के संग भात खात रथै, ता ओखर चेला लग कथै, “ऊ पापिन अउ पइसा उगाहै बाले के संग काखे खाथै पीथै।” ");
INSERT INTO bhu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","यीसु हइ बातन के सुनथै नियाव के सिक्छा दे बाले अउ फरीसी लग कथै, “धरमी मनसे के गुनिया पंडा के जरूरत नेहको होय, पय नंगहन के हबै ओसनेन मोर बुलउवा धरमी मनसे के निता नेहको, पय पापिन के बलामै आय हबो।” ");
INSERT INTO bhu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","यूहन्ना कर चेला बतिस्मा देय बाले अउ फरीसी के चेला उपास करथै, ऊ मनसे यीसु के लिघ्घो आयके कथै, यूहन्ना कर चेला अउ फरीसी कर चेला ता उपास रखथै, पय तोर चेला उपास काखे नेहको रखथै? ");
INSERT INTO bhu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","यीसु उनखर लग कथै, जब तक दुलहा बरतिहन के संग रथै, का उन उपास कर सकथै? जब तक दुलहा उनखर संग हबै तब तक बरतिहा उपास नेहको कर सकथै। ");
INSERT INTO bhu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","पय असना रोज आही जब दुलहा के बरतिहन लग दुरिहां कर दय जही, ता ऊ टेम हे उपास करही। ");
INSERT INTO bhu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“नबा खुरथा पइजामा के जुनहा पहिरै के खुरथा पइजामा हे कउ नबा नेहको लगाथै, काखे ऊ खुरथा पइजामा ओखर मसे कुछ तिनर जथै मतलब नबा जुनहा कपडा लग लगाही अउ ऊ चिथर जही। ");
INSERT INTO bhu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","अंगूर कर रस्सा अउ जुनहा खलरी के थइली हे कउ नेहको धरथै, असना करै लग अंजीर के रस खलरी कर थइली दोनो चिथर जही, इहैनिता नबा अंगूर कर रस्सा अउ खलरी के बेकार कर देही।” ");
INSERT INTO bhu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","यहूदियन के सुस्ताय कर रोज जब यीसु अपन चेला के संग खेत लग गुजरथै, तब चेला गोहूं के बाली के टोरे लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","फरीसी मनसे उके कथै, देख हइ सुस्ताय कर रोज कामकाज काखे करथै? जउन जरूरी नेहको आय। ");
INSERT INTO bhu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ऊ उनखर लग कथै, “का तोके पता नेहको आय कि जरूरत के टेम जब दाऊद अउ दाऊद के संगी भुखाय रथै, ता दाऊद काहिन करथै? ");
INSERT INTO bhu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","बलि के रोटी याजक के सिबाय कउनो के खाये के उचित नेहको रथै, तोके पता नेहको आय कि अबियातार पुजारी के टेम भगवान के बिनती भवन हे जथै, दाऊद अपन साथिन के संग मिलके रोटी खथै।” ");
INSERT INTO bhu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ता यीसु उनखर लग कथै, “सुस्ताय कर रोज मनसे के निता बनाय गय हबै, न कि मनसे सुस्ताय के रोज निता। ");
INSERT INTO bhu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","इहैनिता मनसे कर टोरवा सुस्ताय कर रोज के परभु हबै।” ");
INSERT INTO bhu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","जब यीसु मंडली हे फेरै जथै, ता उहां अक्ठी मनसे रथै जेखर हाथ झुराय हर रथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","कुछ फरीसी मनसे ओखर ताक हे रथै, कि उके कसके पकडी कि यीसु सुस्ताय कर रोज हे उके निक्खा करथै कि नेहको। ");
INSERT INTO bhu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","यीसु झुराय हर हाथ बाले मनसे लग कथै, तै आगू ठाड हुइ जा। ");
INSERT INTO bhu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ता यीसु फरीसी लग पूछथै, सुस्ताय कर रोज हे निक्खा करै के हमर नियाव के जसना हबै? निक्खा करै के या बेकार पय सगलू मनसे चुप्पे रथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","तब यीसु उनखर मन के ठोस के देखके निरास होथै, अउ गुस्साय के चारो चउगिरदा देखथै अउ ओखर लग कथै, अपन हाथ मोर पल्ला लान अउ ओखर हाथ निक्खा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ता फरीसी मनसे बाहिर निकरै के बाद हरबी हेरोदियो राजा के मनसे यीसु के पकडै के बारे हे सोचथै, कि उके कसके मारी। ");
INSERT INTO bhu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","यीसु अपन चेला के यहूदिया इलाका लग आथै, अउ दहार छो जथै ता गलील नगर लग मनसेन के बोहत भीड ओखर पाछू आ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","जब हइ सुनथै कि ऊ बोहत चकित के काम करथै, ता यरुसलेम अउ इदुमिया इलाका लग यरदन नदिया के ऊ पार लग सूर अउ सैदा नगर के अगल-बगल लग भीड यीसु के लिघ्घो आथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","यीसु अपन चेला लग कथै, मोर निता अक्ठी नान हस नाह जिहाज तइयार करके रखबे कि भीड के कारन मनसे मोके झइ दबा पामै। ");
INSERT INTO bhu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","इहैनिता यीसु के लिघ्घो बोहत नंगहा मनसे के निक्खा करथै, अउ उन उके छुयै के निता मरे जथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","यीसु के भुतवा देखथै ता नंगहा मनसे ओखर आगू गिर पडथै अउ चिरलायके कथै, “कि तै भगवान कर टोरवा हबस।” ");
INSERT INTO bhu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","यीसु उनही समझाय करथै कि कउनो के झइ गुठेबे कि मै कोहर हबो। ");
INSERT INTO bhu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","एखर बाद यीसु डोंगर छो जथै, अउ ऊ जेही चाहथै चेलन के अपन लिघ्घो बुलाथै, अउ उन ओखर लिघ्घो आ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ता यीसु बारहठे मनसे के चुनथै, कि चेला ओखर संग-संग रहै अउ उनही परचार करै के पठोथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","अउ भुतवा के निकाडय के हक रखै। ");
INSERT INTO bhu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","बुलाय हर मनसे के नाम हबै, समोन, जेखर नाम यीसु पतरस रखथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","जबदी कर टोरवा याकूब अउ ओखर भाई यूहन्ना, जेखर नाम यीसु बुवनरगिस रखथै जेखर मतलब होथै गरजन कर टोरवा। ");
INSERT INTO bhu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","अउ अन्द्रियास, फिलिप्पुस, बरतुल्मै अउ मत्ती, थोमा, हलफई कर टोरवा याकूब, तद्दी, समोन कनानी। ");
INSERT INTO bhu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","अउ यहूदा इस्करियोती जउन यीसु के पकडोथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","जब ऊ घर छो आथै, ता बोहत झन के कारन यीसु अउ ओखर चेला रोटी नेहको खा पाथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","जब यीसु के घर बाले हइ सुनथै, ता ओखर घर के मनसे उके पकडै के निता निकडथै, काखे उनही लागथै कि यीसु के दिमाक ठिकाना हे नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ऊ यरुसलेम लग नियाव के गुरू आयके कथै, कि यीसु हे परेत हबै अउ ऊ भुतवा के मुखिया के मदद लग उके निकाडथै, ");
INSERT INTO bhu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","इहैनिता यीसु पंडित के लिघ्घो बुलाथै, अउ किस्सा दइके गुठेथै कि भुतवन के भुतवा कसके निकाड सकथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","अगर कउनो राज अपनै हे झगडै अउ फूट पड जाय ता कसके स्थिर रही सकथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","अगर कउनो घर हे झगडा हुइ जाय, या फूट पड जही, ता ऊ कसके स्थिर रही सकथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","इहैनिता भुतवा अपन बैरी हुइके अपन हे झगडा करवामै के चाहथै, ता निक्खा नेहको रह सकथै पय भुतवन के बढाय के टेम आ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","अगर कउनो मनसे जउन बलवान हबै, जब तक ओही बांध नेहको ले तब तक ओखर घर के नेहको लूट सकथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“मै तोर लग सही कथो, सगलू मनसे के बुराई अउ पापी जउन करथै पाप छमा कर दय जही। ");
INSERT INTO bhu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","पय जउन कोनो पवितर आतमा के तरफ बुराई करही, ऊ मनसे के कबहुन छमा नेहको करै जही ऊ मनसे सबरोज के निता पापी ठहरही।” ");
INSERT INTO bhu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","काखे उन कथै पंडित कहे करथै, “कि ओखर भित्तर भुतवा हबै।” ");
INSERT INTO bhu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ता यीसु के दाय अउ भाई आथै अउ बाहिर लग उके बुलाथै। ");
INSERT INTO bhu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","यीसु के अगल-बगल बइठे मनसे ओखर लग कथै, “देख तोर दाय भाई अउ बेहन बाहिर ठाड हमै अउ तोके खोजथै।” ");
INSERT INTO bhu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","यीसु पूछथै, “मोर दाय अउ मोर भाई कउन हबै?” ");
INSERT INTO bhu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","अउ जउन ओखर अगल-बगल बइठे रथै, उनखर लग कथै, “देखा मोर दाय अउ मोर भाई हइ हबै। ");
INSERT INTO bhu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","काखे जउन मनसे भगवान के बातन के जसना चलथै देखो, उहै मोर दाय बेहन, अउ भाई हबै।” ");
INSERT INTO bhu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","यीसु दहार कर पाखा हे अपन चेलन के भगवान के बारे हे गुठेत रथै, ओतकै टेम मनसेन के भीड ओखर लिघ्घो आ जथै, इहैनिता ऊ अक्ठी नाह जिहाज हे बइठ जथै अउ सगलू झन भुंइ हे दहार के पाखा हे ठाढ रथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","यीसु बोहत बात मनसेन के किस्सा सिखाथै, ऊ अक्ठी किस्सा मनसे के सुनाथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","सुना, अक्ठी मनसे जउन किसान रथै, ऊ बिजहा बोमै निकडथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","बिजहा बोवत टेम कुछ गली के पाखा हे गिरथै, अउ चिरइया आयके उके खा लेथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","कुछ बिजहा पथरा भुंइ हे गिरथै जिहां बिजहा के गहिरा भुंइ नेहको मिले के कारन हरबी जम जथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","पय बेरा निकडत टेम जर नेहको पकडय के कारन बिरवा झुराय जथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","कुछ बिजहा पुडरा हे गिरथै, अउ पुडरा बढिस ता बिजहा के मूंद देथै, इहैनिता बिजहा कुछु फडुहा नेहको दे सकिस। ");
INSERT INTO bhu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","पय कुछ बिजहा निक्खा भुंइ हे गिरथै, अउ बिजहा जम के फर गइस कोनो बिजहा तीस गुना, कोनो साठ गुना, कोनो सव गुना फायदा देथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ता यीसु कथै, “जेखर लिघ्घो सुनै के निता कान हबै, ऊ सुन लेया।” ");
INSERT INTO bhu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","मनसे कर बोहत भीड ऊ जिघा लग कढ जथै, यीसु के चेला पूछथै, हे गुरू ई किस्सा कर मतलब काहिन हबै? ");
INSERT INTO bhu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ता यीसु उनखर लग कथै, “तुम के भगवान कर राज के बारे हे गुठे दय गय हबै, पय दूसर मनसे के निता सगलू ई बात किस्सा लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","इहैनिता कि, “उन देखत हर देखै, अउ उन नेहको समझतिन, अउ सुनतिन ता, अउ भगवान के पल्ला फिरतिन, ता ऊ उनखर पाप छमा कर देतिस।” ");
INSERT INTO bhu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","फेरै यीसु अपन चेलन लग कथै, “का तुम ई किस्सा के नेहको समझथा? ता फेरै अउ सगलू किस्सन के कसना समझिहा? ");
INSERT INTO bhu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","जउन बिजहा बोमै के काम करथै, ऊ मनसे बचन बोथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","जउन गली के पाखा हे बिजहा गिरे हबै, ओखर मतलब ई हबै, कि जब बचन बोय जथै, ता भुतवा उके जउन कुछु बचन बोय जथै, ऊ उके चोराय लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ओसनेन जउन पथरा हे बिजहा गिरथै, ओखर मतलब ई हबै, कि मनसे के जउन बचन सिखाथै, उके हरबी सुनके मगन हुइके अपनाय लेथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","पय अपन भित्तर मजबूत जर नेहको होय लग, चुटु रोज के निता रथै, एखर बाद हे अपनाय जाय बाले भगवान के बचन सबरोज के निता उनखर भित्तर नेहको होमै के कारन बिस्वास लग भटक जथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","जउन बिजहा पुडरा हे गिरथै, ओखर मतलब ई हबै, जउन मनसे बचन सुनथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","अउ दुनिया के चिन्ता धन के लालच, अउ सबैमेर के गलत इक्छा के कारन, भगवान कर बचन के मूंद देथै, अउ बगैर दाना के रह जथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","जउन बिजहा निक्खा खेत के भुंइ हे बोबररे हबै, ओखर मतलब ई हबै, जउन भगवान कर बचन सुनथै अउ अपनाथै, ता दाना लानथै कोनो तीस गुना, कोनो साठ गुना, कोनो सव गुना।” ");
INSERT INTO bhu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","यीसु चेलन लग कथै, का हम चिमनी के इहैनिता जलाथै, कि खटिया के तरी धरै? या फेर पिरभिटिया हे मढाथै ");
INSERT INTO bhu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","इहैनिता कि कउनो चीज लुके नेहको हबै, अउ दिख जाय, अउ जउन लुके हबै उहो दिख जही। ");
INSERT INTO bhu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","फेरै यीसु उनखर लग कथै, जेखर कान हबै ऊ सुन ले। ");
INSERT INTO bhu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","फेरै उनखर लग कथै, “चेतन्ना रहा कि का सुनथा, जउन नाप ले नापथस दूसर के निता, उहै नाप ले भगवान तोर निता नापही, अउ उके बोहत दय जही। ");
INSERT INTO bhu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","काखे जउन कोनो के लिघ्घो हबै, उके अउ मिलही, जेखर लिघ्घो नेहको हबै, ओखर लिघ्घो जउन कुछु हबै, उहो के लइ लय जही।” ");
INSERT INTO bhu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","फेरै यीसु कथै, भगवान कर राज असना हबै, जसना अक्ठी मनसे निक्खा भुंइ हे बिजहा बोथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","रात के सोथै, अउ दिन के जागथै, अउ बिजहा कसना जमी, अउ कसना बढही मनसे नेहको जानही। ");
INSERT INTO bhu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","भुंइ अपनै-अपन फडुहा लाथै, आगू दाना फुटकथै, तब बाली होथै, अउ फेरै गोहूं के बाली के तइयार करथै, अउ भुंइ पउधा के बढाथै, अउ उके तइयार करथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","जब दाना पक जथै, ता किसान काटै के निता हंसिया के निस्तार करथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","फेरै यीसु कथै, भगवान कर राज केखर जसना हबै? अउ किस्सा दइके भगवान कर बारे हे कसना समझाउ। ");
INSERT INTO bhu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","भगवान कर राज राई के दाना के जसना हबै, खेत के निक्खा भुंइ हे बोय जाय बाले बिजहन मसे ई नान हबै। ");
INSERT INTO bhu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","पय जमै के बाद हे सगलू पउधा लग बोहत बडा डगइल हुइ जथै, कि बादर कर चिरइया आयके ओखर हे गोंदा बनाय के रथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","यीसु चेलन के हइ मेर के बोहत किस्सा गुठे गुठेके उनखर समझै के जसना बचन सुनाथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","यीसु बिना किस्सा कहे अपन चेला लग कुछु नेहको कथै, पय सुनसान जिघा हे उनही सगलू किस्सा कर मतलब बताय करथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ऊ रोज जब सांझ होथै, ता ऊ अपन चेला लग कथै, आबा दहार के ऊ पल्ला चलथन। ");
INSERT INTO bhu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","चेला ऊ भीड के छांड के जउन नाह जिहाज हे यीसु आगू लग बइठे रथै, अउ उनो उहै नाह जिहाज हे चढके दहार के ऊ पल्ला कढ जथै, अउ उनखर नाह जिहाज के संग अउ दूसर नाह जिहाज रथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","तब भयंकर आंधी बडेरा आथै, जेखर लग पानी के लहरा उठै लागथै, जेखर कारन नाह जिहाज पानी लग भर जथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","जब यीसु नाह जिहाज के पाछू मूड हे मुडोसा धरके सोउत रथै, ता चेला यीसु के जगायके कथै, हे गुरू, काखे तोके फिकर नेहको हबै? कि हम मरै बाले हबन। ");
INSERT INTO bhu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","यीसु नाह जिहाज हे ठाड होथै, अउ ऊ हबा अउ बडेरा के गधारिस, अउ कथै, चुप्पे हुइ जा, अउ उहां सब कुछ चुप्पे हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ता यीसु चेला लग कथै, तुम काखे डरथा? काखे तोके अभिन्नो बिस्वास नेहको आय? ");
INSERT INTO bhu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","चेला बोहत डर जथै, अउ अपन हे गुठेमै लागथै, ई कउन आय, ओखर तो आंधी बडेरा बातन के मानथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","जब यीसु अउ ओखर चेला दहार के ऊ पल्ला गिरासेनियो के इलाका छो पहुंचथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","जब यीसु नाह जिहाज लग उतरथै, ता अक्ठी मनसे मरघटी मसे निकड के आथै, जेखर भित्तर भुतवा रथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ऊ मनसे मरघटी हे रथै, अउ ऊ मनसे के कउनो सांकड लग नेहको बांध सकथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ऊ मनसे के कइन बार हाथ अउ गोड के सांकड लग बांध देथै, पय ऊ सांकड अउ डोरा के टोर देथै, ओही कउनो मनसे अपन बस हे नेहको कर सकथै, काखे कि ऊ बोहत बलवान रथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ऊ मनसे रात-दिन मरघटी अउ डोंगर छो बोहत चिरलाय करथै, अउ अपन के पथरा लग अधमरहा कर लेथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ऊ यीसु के दुरिहां लग देखथै, अउ दउडके आथै, अउ ओखर आगू निहुर के परनाम करथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ऊ चिरलायके कथै, हे यीसु परम परधान भगवान कर टोरवा, मोके तोर लग का काम? तोके भगवान कर किरिया हबै, कि मोके सजा झइ दे। ");
INSERT INTO bhu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ऊ ओखर लग कथै, हे भुतवा हइ मनसे के जीवन लग बाहिर निकड जा। ");
INSERT INTO bhu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ऊ ओखर लग पूछथै, “तोर काहिन नाम हबै?” ऊ कथै, “मोर नाम सेना हबै? काखे हम बोहत हबन।” ");
INSERT INTO bhu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ऊ यीसु लग बोहत बिनती करके कथै, हम के हइ इलाका लग बाहिर झइ पठो। ");
INSERT INTO bhu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","उछो डोंगर के उतारू रथै, जछो सुमरा के बोहत झुंड चरथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ऊ ओखर लग गिडगिडाय के बिनती करथै, हमके सुमरा के झुंड हे पठोय दे, कि हम सुमरा के भित्तर रहबो। ");
INSERT INTO bhu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","यीसु फेरै ओखर लग कथै, हे भुतवा मनसे के जीवन लग निकडके सुमरा के भित्तर कढ जा, अउ सुमरा कर झुंड दुइ हजार के रथै, एतका हरबी सगलू सुमरा डोंगर के उतारू लग, दहार हे बुड के मर जथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","सुमरा के बरेदिया दउरके सहर अउ गांव छो जाय के संदेस सुनाथै, जउन कुछु होथै, मनसेन उके देखे बर आथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","यीसु के लिघ्घो आयके, ऊ मनसे के देखथै, जेखर भित्तर बोहत भुतवा रथै, ऊ बन्डी ओढे, अउ पूरे सान्ति के संग बइठे देखके गांव के मनसे डर जथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","गांव के मनसे उके देखथै, जेखर भित्तर भुतवा रथै, अउ ऊ सुमरा के बारे हे सगलू कुछ बात गुठेथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ता गांव के मनसे यीसु लग बिनती करके कथै, हमार इलाका लग कढ जा। ");
INSERT INTO bhu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","जब यीसु नाह जिहाज हे चढ जथै, ता जेहमा पहिले भुतवा रथै, ओखर लग बिनती करके कथै, मोके अपन संग रहै दे। ");
INSERT INTO bhu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","पय यीसु नंगहा मनसे के मना कर देथै, अउ ऊ कथै अपन घर छो कढ जा, अउ अपन मनसे के गुठे कि तोर निता दया करै हबै, अउ परभु बड्डे काम करै हबै। ");
INSERT INTO bhu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","नंगहा मनसे दिकापुलिस सहर छो कढ जथै, उहां परचार करै लागथै, कि यीसु मोर निता बोहत बडा काम करै हबै, अउ सगलू मनसे सुनके चकित हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","जब यीसु नाह जिहाज लग उतर के दहार के ऊ पल्ला जथै, दहार के पाखा हे रथै, ता बोहत भीड ओखर लिघ्घो अकजुट हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","याइर नाम के अक्ठी मनसे रथै, जउन बिनती भवन के अक्ठी मुखिया रथै, जउन यीसु के देखके गोड हे गिरथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","अउ यीसु लग बिनती करके कथै, मोर अक्ठी नान टोरिया हबै, जउन बोहत नांगा हे हबै, अउ ऊ हरबी मरै बाले हबै तै मोर घर छो चल अउ हाथ धरबे ता निक्खा हुइ जही, अउ जिन्दा रही। ");
INSERT INTO bhu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ता यीसु ओखर संग कढ जथै, अउ यीसु कर पाछू चलय लग जथै, इहां तक कि मनसे यीसु के उप्पर गिरे पडे लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","अक्ठी डउकी रथै, जेही बारह साल लग खून बोहे के नांगा रथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ऊ बोहत गुनिया के देखाय रथै, अउ अपन सगलू डेरा के बडोय डारथै, अउ ऊ निक्खा नेहको होथै, पय ओखर नांगा अउ बोहत बढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ऊ यीसु कर बारे हे सुनके भीड हे ओखर पाछू आ जथै, अउ ओखर खुरथा पइजामा के छि लेथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ऊ सोचथै, अगर मै ओखर बन्डी के छि लेहूं, ता मै निक्खा हुइ जहुं। ");
INSERT INTO bhu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","अउ ओखर बन्डी के जसनेन छिथै, ता ओखर खून बोहे के बन्द हुइ जथै, अउ ओही अपन देह हे पता हुइ जथै कि मै निक्खा हुइ गय हबो। ");
INSERT INTO bhu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","यीसु हरबी समझ जथै, कि मोर देह लग सक्ति निकडे हबै, अउ पाछू फिर के पूछथै, मोर बन्डी के कोनहर छि हबै। ");
INSERT INTO bhu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ओखर चेला कथै, “तै देखथस कि भीड तोर उप्पर गिरे जथै, अउ तै कथस कि मोर बन्डी के कोनहर छि हबै?” ");
INSERT INTO bhu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","यीसु छिय बाले मनसे के देखै के निता, चारो चउगिरदा देखथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ता ऊ जान जथै, कि मै निक्खा हुइ गय हव, ऊ डउकी डर जथै अउ थरथरात ओखर लिघ्घो आथै, अउ ओखर गोड हे गिरके ओही सगलू हाल सही गुठे देथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ऊ नंगहा डउकी लग कथै, टोरिया तोर बिस्वास तोके निक्खा करै हबै, सान्ति लग जा, अउ सगलू दुख लग बचे रहबे। ");
INSERT INTO bhu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","यीसु ऊ डउकी लग बात करत रहिस, ता बिनती भवन के मुखिया के घर लग मनसे आयके कथै, तोर टोरिया मर गय हबै, गुरू के दुख काखे देथस? ");
INSERT INTO bhu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","जउन बात के मनसे कहत रहिन, ऊ बातन के यीसु नेहको सुनथै, बिनती भवन के मुखिया लग कथै, “झइ डर, अउ बिस्वास कर।” ");
INSERT INTO bhu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","यीसु पतरस, याकूब अउ ओखर भाई यूहन्ना के संग लइ जथै, एखर सिबाय कउनो के नेहको आमै देथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","बिनती भवन के मुखिया घर हे पहुंचथै, ता मनसेन के बोहत रोबत अउ चिरलात देखथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ऊ घर के भित्तर जाय के मनसेन लग कथै, तुम काखे रोथा? टोरिया नेहको मरे हबै, ऊ सोथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","मनसे ओखर मजाक उडाथै, पय यीसु उनही घर के बाहिर छो निकाडके टोरिया के दाय-बाफ अउ अपन चेला के संग भित्तर जथै, जिहां ऊ मरे हर रथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ऊ ओखर हाथ पकडके कथै, “तालिताकुम्मी, जेखर मतलब हबै, हे टोरिया मै तोर ले कथो, उठ वो।” ");
INSERT INTO bhu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ऊ उठ जथै, अउ रेंगय-बागय लग जथै, टोरिया बारह साल के रथै, उके देखके मनसे बोहत चकरा जथै। ");
INSERT INTO bhu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","यीसु ओखर दाय-बाफ लग कथै, अउ आदेस देथै, देखा हइ बात कउनो के झइ गुठेहा, अउ कथै, “उके कुछु खाय के निता देया।” ");
INSERT INTO bhu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","गिरासेनियो इलाका लग निकरके, यीसु नासरत गांव हे आथै, अउ चेला ओखर पाछू आ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","यहूदी के सुस्ताय कर रोज यीसु मंडली हे जाय के सिक्छा देमै लागथै, अउ बोहत मनसे सुनके चकरा जथै, अउ गुठेमै लागथै, हइ सिक्छा कोन हर दय हबै? हइ कसना सक्ति के काम करथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","का हइ उहै कारीगर तो नेहको आय, जउन मरियम कर टोरवा, अउ याकूब, योसेस, यहूदा, अउ समोन कर भाई हबै? का ओखर बेहन इहां हमर बीच हे नेहको रथै? इहैनिता यीसु अपन भाई-बेहन के बारे हे बेज्जती होथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","यीसु उनखर लग कथै, ग्यानी मनसे अपन देस, अउ घर परवार के छांड के, अउ कहुं ओखर बेज्जती नेहको होथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","उहां यीसु कोनो सक्ति के काम नेहको करिस, कुछ नंगहा हे हाथ धरके उनके निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","अउ यीसु मनसेन के उप्पर अबिस्वास अउ संका होथै, अउ यीसु चारो-चउगिरदा गांव हे परचार करत रथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","यीसु बारहठे चेलन के अपन लिघ्घो बुलाथै, अउ उनही दुइ-दुइ करके पठोथै, अउ उनही भुतवा निकाडै के हक देथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","यीसु उनही कथै, अपन यातरा के निता डंडा के छांड के, अउ कुछु झइ धरिहा, न रोटी, न खलरी के झोरा, न परस हे पइसा। ");
INSERT INTO bhu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","पय बूट अउ दुइ-दुइठे खुरथा पइजामा झइ पहनिहा। ");
INSERT INTO bhu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","अउ यीसु उनही कथै, जब तुम कोनो घर हे जइहा ता, जब तक ऊ गांव नेहको छांड दइहा, तब तक उहै घर हे रइहा। ");
INSERT INTO bhu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","जउन घर हे तुम्हर पहुनाई नेहको होही, अउ तुम्हर बातन के नेहको सुनही, ता तुम ऊ घर के छांड के, अउ ओखर चीन के निता, अपन गोड के धूधुर झार देबे, कि उनखर हे गवाह होही। ");
INSERT INTO bhu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ता उन जाय के परचार करथै, कि अपन पापन के छांड देया। ");
INSERT INTO bhu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","चेला बोहत भुतवा के निकाडथै, अउ नंगहा मनसे के महके बाले तेल लगाके निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","हेरोदेस राजा यीसु कर बारे हे सुनथै, काखे ओखर नाम बोहत बगर जथै, अउ कुछ मनसे कथै, यूहन्ना जउन बतिस्मा देय बाले, ऊ मरै लग जी उठे हबै, इहैनिता ओखर ले सक्ति के काम परगट होथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","दूसर मनसे कथै, “ई एलिय्याह हबै” अउ दूसर कथै, कि ई पुरान टेम के ग्यानी मनसे के जसना हबै। ");
INSERT INTO bhu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","हेरोदेस राजा यीसु कर बारे सुनके कथै, जउन यूहन्ना कर मुन्डी के मै कटवाय रहों, का ऊ जी उठे हबै। ");
INSERT INTO bhu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","हेरोदेस राजा अपन सिपाही के आदेस दइके यूहन्ना बतिस्मा देय बाले के सांकड लग बंधवाय के जेल हे बेडवा देथै, अउ ऊ हेरोदियास के कारन करथै, काखे कि ऊ अपन भाई फिलिप्पुस के डउकी लग काज करै रथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","काखे यूहन्ना हेरोदेस लग कहे रथै, अपन भाई के डउकी लग काज करै हबस, जउन उचित नेहको आय। ");
INSERT INTO bhu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","इहैनिता हेरोदियास यूहन्ना ले बैर करथै, अउ हइ चाहथै, कि उके मरवा डाली, पय हेरोदेस के कारन नेहको मार पाइस, ");
INSERT INTO bhu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","काखे हेरोदेस यूहन्ना के धरमी अउ पवितर डउका जानके डरे करथै, अउ ओही बचाय रखथै। अउ यूहन्ना के बातन के सुनके बोहत चकराथै, पय ओखर बातन के मगन लग सुनै करथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","अखिर निक्खा टेम हे हेरोदेस, अपन पइदाइस रोज के टेम हे, अपन रिस्तेदार सेनापति अउ गलील सहर के बडे मनसेन के निता भन्डारा करथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","जब हेरोदियास के टोरिया आयके नाचथै, अउ हेरोदेस आमै बाले पहुनन के मगन कर देथै, ता राजा ओखर लग कथै, तै जउन कुछु मांगबे, मै तोके देहुं। ");
INSERT INTO bhu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","अउ राजा किरिया खाये के कथै, मोर लग जउन कुछु मांगबे, मै तोके देहुं, इहां तक कि आधा राज देहुं। ");
INSERT INTO bhu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","बाहिर जाय के ऊ अपन दाय लग कथै, “मै काहिन मांगो?” ऊ कथै, “यूहन्ना बतिस्मा देय बाले कर मुन्डी।” ");
INSERT INTO bhu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ता टोरिया हरबी भित्तर जथै, हेरोदेस राजा लग बिनती करके कथै, मै चाहथो कि तै यूहन्ना बतिस्मा देय बाले कर मुन्डी टठिया हे मंगवाय दे। ");
INSERT INTO bhu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ता राजा के बोहत दुख होथै, पय ऊ जुबान दइ चुकथै, अउ ऊ किरिया खाय के कारन अउ पहुना के कारन ऊ मना नेहको कर पाथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","तब राजा अपन सिपाही के आदेस देथै, कि जेल हे जाय के यूहन्ना के मुन्डी खपलके लाबा। ");
INSERT INTO bhu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ता सिपाही जेल हे जथै, अउ यूहन्ना कर मुन्डी के खपलके अक्ठी टठिया हे धरके लानथै, अउ टोरिया के देथै, ऊ अपन दाय के लइके देथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ई बातन के चेला सुनथै, कि उके मार डारे हबै, ता ओखर लोथ के लइज के मरघटी हे गाड देथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","चेला यीसु कर लिघ्घो अकजुट होथै, जउन कुछु करथै, अउ सिखाथै, सगलू उके गुठेथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","यीसु उनखर लग कथै, आबा हम अलग कोनो सुनसान जिघा हे जाय के चुटु सुत्ताय लइ, काखे मनसे के अउत-जात बने रथै, अउ खाना खाये के टेम नेहको मिलथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","इहैनिता यीसु नाह जिहाज हे चढके, सुनसान जिघा हे कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","उन गलील नगर छो झील के ऊ पार जथै, अउ बोहत मनसे उनही देखथै, कि उछो लग कढ गय हबै, ता यीसु अउ ओखर चेलन लग आगुन उन उछो पहुंच जथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","यीसु नाह जिहाज लग उतरथै अउ भीड के देखथै, अउ ऊ उनही दया लग देखथै, काखे बगैर बरेदी के गेडरा रथै, जेखर कोनो देख रेख करै बाले नेहको रथै, अउ उनही बोहत बातन के सिखाथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","जब सांझ हुइ जथै, ता चेला यीसु लग कथै, हइ जिघा सुनसान हबै, अउ बोहत देरी हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","उनही पठोय दे, अउ चारो चउगिरदा गांव मोहल्ला हे कढ जाय, अपन खाय के निता जुगाड करले। ");
INSERT INTO bhu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","यीसु जबाब देथै, “तुमिन उनखर निता खाये के जुगाड करा,” चेला ओखर लग कथै, “का हम आठ महीना के मजदूरी के चांदी के पइसा लग कछो लग खरीदी, इनही खाना कछो लग दइ?” ");
INSERT INTO bhu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","यीसु चेलन लग कथै, जाय के देखा, कि कोनो के लिघ्घो रोटी हबै, उन पता करके कथै, पांच रोटी अउ दुइठे मछडी हबै। ");
INSERT INTO bhu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","तब यीसु चेलन लग कथै, कि सगलू मनसे के हरियर चारा हे लाइन बार बइठा देया। ");
INSERT INTO bhu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","अउ चेला उनही सव-सव, अउ पचास-पचास अक्ठी कतार बइठा देथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","यीसु पांचठे रोटी अउ दुइठे मछडी के लेथै, अउ स्वरग छो देखथै, भगवान के धन्यबाद करथै, अउ रोटी टोर-टोर के चेलन के देथै, अउ सगलू मनसे के बांटथै अउ उहै मेर सगलू मछडी के बांट देथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","सगलू मनसे खाइन, अउ सब कर लादा टुल्य हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","अउ सगलू मनसे खाये के बाद हे, चेला बचे हर रोटी अउ मछडी के खन्डा लग बारह छन्नी भरथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","खाय बाले हे केबल पांच हजार डउकन के गिनती रथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","हरबी यीसु अपन चेला के नाह जिहाज हे बइठा देथै, अउ कथै मोर लग आगुन्नै बैतसदा नगर छो पहुंच जाय, अउ ऊ भीड के अपन घर छो पठो देथै, ");
INSERT INTO bhu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","यीसु भीड के पठोय देय के बाद हे, ऊ डोंगर छो बिनती करै के निता कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","सांझ के टेम हे नाह जिहाज जब दहार के बीच हे रथै, अउ यीसु भुंइ हे रथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","हबा बोहत चलथै, ता चेला बोहत डेराय जथै, यीसु चेलन के डेरात देखथै, ता करीबन मुरगोसा टेम ऊ पानी हे रेंगत आउत रहिस, अउ उनखर बगल हुइके आगू जाय के चाहथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","पय चेला यीसु के पानी हे रेंगत देखथै, ता उके भुतवा समझ के चिरलाय लग जथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","यीसु के सगलू झन देखके उन डर जथै, पय ऊ हरबी उनखर लग कथै, तुम हिम्मत धरा मै हबो। ");
INSERT INTO bhu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","तब यीसु चेलन के लिघ्घो नाह जिहाज हे आथै, अउ बडेरा रुक जथै, अउ उन बोहत चकरा जथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","चेला पांचठे रोटी अउ दुइठे मछडी के बारे हे नेहको समझथै, काखे उनखर मन ठोस हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","यीसु अउ चेला नाह जिहाज लग उतर के गन्नेसरत इलाका झील छो पहुंचथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","जबय यीसु नाह जिहाज लग उतरथै, ता मनसे हरबी उके चीन जथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","जिछो-जिछो यीसु जथै, मनसे अगल-बगल के देस परदेस इलाका लग, अपन नंगहन के खटिया हे लानथै। ");
INSERT INTO bhu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","यीसु जउन गांव, कउनो सहर या मोहल्ला छो जथै, उहां मनसे अपन नंगहन के बजार छो लइ आनथै, अउ ओखर लग बिनती करथै, कि ऊ अपन खुरथा पइजामा के छोर के छियदे, जउन ओही छि लेथै, ऊ निक्खा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ता फरीसी मूसा कर नियाव के गुरू, जउन यरुसलेम इलाका लग आथै, यीसु के लिघ्घो अकजुट हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","उन देखथै कि यीसु के चेला के असुध्द, मतलब बिना हाथ धोय रोटी खात देखथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","काखे फरीसी अपन सियान के रीति रिबाज के हिसाब लग चलथै, जब तक सबझन यहूदी मनसे अपन हाथ नेहको धो लेथै, तब तक भात नेहको खथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","अउ बजार लग आयके जब तक असनाद नेहको लेथै, तब तक खाना नेहको खाथै, अउ बोहत बात हबै, जउन पंडितन के गोहदा हे रथै, जसना कि खोरिया, लुटिया, खटियन के अउ तांबा के टठिया के मांजथै धोथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","तब उन फरीसी अउ नियाव के गुरू ओखर लग पूछथै, तोर चेला सियानन के रीति रिबाज के जसना काखे नेहको चलथै, बिना हाथ धोय खाना खाय लेथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","यीसु उनखर लग कथै, यसायाह तुम्हार ढोंगहन के बारे हे निक्खा आगू कर बात हबै, जसना किताब हे लिखररे हबै, हइ मनसे मुंह लग मोर महिमा करथै, पय मन लग इज्जत नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ई बेकार हे मोर उपास करथै, काखे हइ मनसेन के, बात के भगवान के बात कथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","भगवान कर आदेस के छांड कर मनसेन के आदेस रीति रिबाज के मानथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","यीसु उनके कथै, “तुम अपन पुरखन के रीति रिबाज के मानय के निता, भगवान कर आदेस के नेहको मानथा। ");
INSERT INTO bhu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","काखे भगवान कर दास मूसा जउन अपन किताब हे लिखे हबै, अपन दाय-बाफ के आदर करा, अउ जउन कउ उनही गधरहिन या मारही, उके मरै के सजा दय जही। ");
INSERT INTO bhu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","अगर तुम असना कथा, कि कोनो अपन दाय-बाफ लग कहे, जउन कुछु काम करा, अउ तोके फायदा होय, भगवान के निता बलि चढामै। ");
INSERT INTO bhu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","हइ मेर लग तुम ओखर दाय-बाफ के सेबा करै लग दुरिहां कर देथा। ");
INSERT INTO bhu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","हइ मेर लग अपन आदेस, जउन तुम रीति रिबाज बनाय हबा, अउ भगवान कर बचन के दुरिहां करथा, अउ इहैमेर बोहत गलत बात हबै, जउन तुम करथा।” ");
INSERT INTO bhu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","यीसु मनसेन के अपन लिघ्घो बुलाथै, अउ उनखर लग कथै, तुम मोर सगलू बात के सुना, अउ समझा। ");
INSERT INTO bhu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","असना कउनो चीज नेहको हबै, जउन मनसे के भित्तर जथै उके असुध्द करथै, जउन मनसे के भित्तर लग बाहिर निकडथै, उके असुध्द करथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","अगर कोनो के लिघ्घो कान हबै, ता ऊ सुनै। ");
INSERT INTO bhu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","जब यीसु भीड के छांड के घर छो आ जथै, ता ओखर चेला किस्सा के बारे हे पूछथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","यीसु चेलन लग कथै, का तुमो नेहको समझे हबा? काखे तुम नेहको जानथा, कि जउन कुछु चीज मनसे के मुंह लग भित्तर जथै, ऊ मनसे के असुध्द नेहको करथै? ");
INSERT INTO bhu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","काखे ऊ उनखर मन हे नेहको पय लादा हे जथै, अउ लादा लग बाहिर निकड जथै, इहैनिता यीसु खाये बाले चीजन के सुध्द कहे हबै। ");
INSERT INTO bhu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","यीसु कथै, “जउन मनसे के मन हे आथै, उहै बात मनसेन के असुध्द करथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","मनसेन के मन लग असना निकरथै, गलत खयाल, गलत काम बाले, चोरी, हत्या। ");
INSERT INTO bhu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","लालच, दोख, ठगना, लफन्गा, बेकार नजर, बुराई, अकड, मूरख असना-असना बात निकाडथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ई सगलू बेकार बात उनखर भित्तर लग निकडथै, अउ मनसेन के असुध्द करथै।” ");
INSERT INTO bhu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","यीसु गन्नेसरत नगर लग सूर अउ सैदा परदेस हे आथै, ऊ अक्ठी घर हे जथै, अउ ऊ नेहको चाहथै कि कोनो मोके जान सकै पय उके जान जथै, ");
INSERT INTO bhu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","अक्ठी डउकी रथै, ओखर टोरिया के भित्तर भुतवा रथै, ऊ यीसु के खबर सुनके आइस, अउ ऊ ओखर गोड हे गिरथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","सीरिया देस के यूनानी डउकी अउ सुरुफिनीकी गैर यहूदी के रथै, ऊ ओखर लग बिनती करके पूछथै, मोर टोरिया के भित्तर भुतवा हबै, उके निकाड दे। ");
INSERT INTO bhu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","यीसु ओखर लग कथै, आगू लरका के खाय देया, ई जरूरी नेहको आय कि रोटी के, कुकरा के आगू फेकै के निक्खा नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ऊ डउकी यीसु के जबाब देथै, “सही हबै परभु, तउभरमा लरकन के जूठा बचे हर के कुकरा खाय लेथै।” ");
INSERT INTO bhu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","यीसु उके कथै, ई बातन के कारन कढ जा, तोर टोरिया ले भुतवा निकड गय हबै। ");
INSERT INTO bhu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ऊ अपन घर जाय के देखथै, ता ओखर टोरिया खटिया हे सोय रथै, अउ भुतवा निकड जथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","फेरै यीसु सूर अउ सैदा लग गुजरत दिकापुलिस इलाका होवत गलील नगर के झील छो पहुंचथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ता मनसे अक्ठी बहिरा जउन बउरो रथै, उके यीसु के लिघ्घो लइके आथै अउ ओखर लग बिनती करथै, कि अपन हाथ ओखर उप्पर मडाय दे। ");
INSERT INTO bhu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ता यीसु उनही भीड लग अलग लइ जथै, अउ अपन अंगठी बहिरा के कान हे गुसेडथै अउ थूक के बउरा के जीभ के छीथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","अउ स्वरग छो निहार के यीसु कथै, इप्फत्तह एखर मतलब हबै खुल जा। ");
INSERT INTO bhu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ता हरबी बहिरा के कान खुल जथै, अउ बउरा साफसुथरा गुठेमै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","यीसु उनही आदेस देथै, कि मोर बारे हे कोनो के झइ गुठेबे। पय ऊ बोहत बरजै लग ओतकय बोहत ऊ परचार करथै। ");
INSERT INTO bhu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","मनसे बोहत चकराय के कहे लागथै, “ऊ जउन कुछु करै हबै, निक्खा करै हबै, यीसु बहिरा के कान अउ बउरा के गुठेमै के सक्ति दय हबै।” ");
INSERT INTO bhu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ऊ टेम हे जब बड्डे भीड अकजुट होथै, ता मनसेन के लिघ्घो कुछु खाय के निता नेहको रथै, यीसु अपन चेला के बुलाके कथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","इहैनिता कि मनसे मोर संग तीन रोज लग हबै, अउ मनसे के लिघ्घो खाय के निता कुछु नेहको हबै, मोके इनखर उप्पर दया आथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","अगर मै मनसे के भुखे घर पठोहूं, ता गली हे थक जही, अउ बिहोस हुइ जही, काखे भीड बोहत दुरिहां लग आय रथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","यीसु के चेला कथै, ई नान जिघा हे बोहत मनसे के निता रोटी कछो लग लानबो कि पेट भर खाय? ");
INSERT INTO bhu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","यीसु अपन चेलन लग पूछथै, तोर लिघ्घो केतका रोटी हबै? उन कथै, सात रोटी हबै। ");
INSERT INTO bhu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","यीसु सगलू मनसे के भुंइ हे बइठे के निता बोलथै, अउ ऊ सात रोटी लेथै, अउ भगवान के धन्यबाद दइके टोरिस, अउ चेलन के देथै अउ चेला उनके पोरसै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","मनसे के लिघ्घो चुटु हस नान मछडी रथै, अउ यीसु के देथै, यीसु धन्यबाद करके मछडी के बांटै के आदेस देथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ता मनसे रोटी खायके अघाय जथै, अउ खाये के बाद हे सात टोपरी रोटी बच जथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","अउ मनसे के गिनती करीबन चार हजार के रथै, एखर बाद हे यीसु उनही घर छो पठोय देथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","यीसु उहां लग अपन चेला के संग पानी बाले नाह जिहाज हे, चढके दलमनूता परदेस हे कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","फेरै फरीसी मनसे ओखर लिघ्घो आयके पुछै लागथै, यीसु के परखै के निता ओखर लग कोनो स्वरग के चिन्हा मांगथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","यीसु अपन आतमा हे बोहत सांस लइके कथै, हइ जमाना के मनसे काखे चिन्हा के खोजथै? मै सही कथो, हइ जमाना के मनसे के कउनो चिन्हा नेहको दय जही। ");
INSERT INTO bhu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","यीसु फरीसी के छांड के पानी बाले जिहाज हे बइठ के ऊ पार छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","चेला अपन संग रोटी धरै के निता बिसर जथै, अउ पानी बाले नाह जिहाज हे उनखर लिघ्घो अक्ठी रोटी रथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","यीसु उनही गुठेथै, “फरीसी अउ हेरोदेस राजा के बातन लग चतुर रइहा।” ");
INSERT INTO bhu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","चेला अपन हे सोचथै अउ कथै, हमर लिघ्घो रोटी नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","तब यीसु जान जथै, अउ उनखर लग कथै, तुम असना काखे सोचथा, कि हमर लिघ्घो रोटी नेहको हबै? का तुम अबहुन तक नेहको जानथा, अउ समझथा? का तुम्हर मन अबहुन ठोस हबै? ");
INSERT INTO bhu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","काखे तुम्हर आंखी रहत भरमा नेहको देखथा, अउ कान रहत भरमा नेहको सुनथा? अउ सुरता नेहको धरथा। ");
INSERT INTO bhu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","जब मै पांच हजार मनसेन के निता पांच रोटी टोरे रहों, ता तुम रोटी के केतका खन्डा छन्नी हे भर के उठाय रहा? चेलन कथै, बारह छन्नी। ");
INSERT INTO bhu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","अउ जब मै चार हजार मनसे के निता सातठे रोटी टोरे रहों, ता तुम रोटी के केतका खन्डा उठाय रहा? चेला कथै, सात टोपरी। ");
INSERT INTO bhu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","यीसु उनखर लग कथै, काखे तुम अबहुन तक नेहको समझे हबा? ");
INSERT INTO bhu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","जब यीसु बैतसदा नगर छो आथै, अउ अक्ठी अन्धरा मनसे रथै, कुछ मनसे ओही यीसु के लिघ्घो लइके आथै, अउ ओखर लग बिनती करके कथै, हे यीसु अन्धरा मनसे के छि दे। ");
INSERT INTO bhu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","यीसु ओखर हाथ पकडके गांव लग बाहिर छो लइ जथै, अउ ओखर आंखी हे थूकिस अउ ओखर उप्पर हाथ धरिस, अउ ओखर लग पूछथै, “तोके कुछु दिखथै?” ");
INSERT INTO bhu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","अउ ऊ कथै, “मै मनसेन के देखथो, उन मोके रेंगत दिखथै, अउ रूख के जसना दिखाई देथै।” ");
INSERT INTO bhu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","तब यीसु दुबारा ओखर आंखी हे रखथै, अउ अन्धरा निक्खा हुइ जथै, अउ साफ-साफ देखै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","यीसु ओखर लग ई कही के घर पठोथै, “ई गांव के भित्तर गोडो झइ मडाबे।” ");
INSERT INTO bhu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","यीसु अउ ओखर चेला कैसरिया फिलिप्पी के अगल-बगल गांव हे जथै, जब ऊ गली हे उनखर लग पूछथै, “मनसे मोके काहिन कथै?” ");
INSERT INTO bhu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","चेला जबाब देथै, यूहन्ना जउन बतिस्मा देय बाले, कउनो कथै एलिय्याह, अउ कउनो ग्यानी मनसे हइ कउनो अक्ठी मसे आय कथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","यीसु उनखर लग पूछथै, तुम मोके काहिन कथा? “पतरस जबाब देथै, भगवान कर पल्ला लग आय हर मसीह हवस।” ");
INSERT INTO bhu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","तब यीसु पतरस लग समझाय के कथै, “कि मोर बारे हे कउनो लग झइ गुठेबे।” ");
INSERT INTO bhu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","यीसु अपन चेलन के सिखामै लागथै, मनसे कर टोरवा जरूरी हबै कि सताय जही, अउ सियान, पुजारी अउ नियाव के गुरू के दवारा बेकार समझ के मारे जहुं, पय तीसर रोज जी उठहुं। ");
INSERT INTO bhu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","यीसु ई बातन के चेलन लग साफ-साफ कही देथै, पतरस ई बातन के सुनके उके अलग लइ जाय के गधारे लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","यीसु फिर के अपन चेला के पल्ला देखथै, अउ पतरस के गधार के कथै, “हे भुतवा, मोर आगू लग दुरिहां हुइ जा। काखे तै भगवान के बातन के नेहको, पय मनसे के बातन हे मन लगाथस।” ");
INSERT INTO bhu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","यीसु अपन चेला के संग भीड के बुलाथै, अउ भीड के कथै, जउन कउनो मोर पाछू आही, ऊ अपन हे इन्कार करै, अउ अपन क्रूस उठाय के मोर पाछू हुइ ले। ");
INSERT INTO bhu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","अगर जउन कउनो अपन परान बचामै चाहथै, ऊ उके खो देही, पय जउन कउ मोर संदेस के निता परान खोही, ओखर जीवन बचही। ");
INSERT INTO bhu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","जउन मनसे दुनिया के पाय जही, अउ अपन परान के दुख उठाही, ता उके का फायदा होही? ");
INSERT INTO bhu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","मनसे अपन परान के पलटा काहिन देही? ");
INSERT INTO bhu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","जउन कउनो मनसे चाल खराब बाले अउ पापिन के जात के बीच हे मोर बातन के सुनै, अउ माने के निता लजाही, ता मनसे कर टोरवा जब पवितर स्वरगदूत के संग अपन बाफ के महिमा के संग सजा दे आहुं ता महुं लजाहूं। ");
INSERT INTO bhu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","यीसु मनसे लग कथै, “मै तुम्हर लग सही कथो, जउन इहां ठाडे हबै, कउनो असना मनसेन हबै, जब तक कि भगवान कर राज के सक्ति के अउत नेहको देख ले, तब तक नेहको मरही।” ");
INSERT INTO bhu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","छय रोज के बाद यीसु पतरस अउ याकूब, यूहन्ना के अपन संग सुनसान डोंगर के टिल्ली हे लइ जथै, उहां चेलन के आगू ओखर सकल बदल जथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ओखर बन्डी बरफ के जसना चरका चमके लागथै, जसना कि सगलू भुंइ हे असना धोबिया नेहको आय, कि ओही चरका कर सकै। ");
INSERT INTO bhu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","अउ यीसु के मूसा अउ एलिय्याह के संग बात करत दिखाई देथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","पतरस यीसु लग कथै, “हे गुरू, हमर इहां रहै के निता निक्खा हबै, इहैनिता हम तीन घर बनइ, अक्ठी तोर निता, अक्ठी मूसा कर निता, अक्ठी एलिय्याह कर निता।” ");
INSERT INTO bhu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","काखे सगलू चेला बोहत डराय रथै, उनके कुछु समझ हे नेहको आथै, कि हम काहिन कही? ");
INSERT INTO bhu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","तब बादर उनके ढाप लेथै, अउ ऊ बादर लग हइ आरो सुनाई देथै, कि ई मोर पिरिया टोरवा हबै, मै एखर लग बोहत मगन हव, एखर बातन के सुना। ");
INSERT INTO bhu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","तब चेला चारो-चउगिरदा देखथै, ता उहां कउनो नेहको रथै, सिबाय चेला अउ यीसु रथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","जब डोंगर लग तरी उतरथै, ता यीसु चेलन लग कथै, जब तक मनसे कर टोरवा मरै लग जिन्दा नेहको होही, तब तक जउन कुछु तुम देखे हबा, ऊ आदेस दइके कथै कउनो के झइ गुठेइहा। ");
INSERT INTO bhu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","चेला ई बात के मन हे सुरता रखथै, अउ अपन हे अपनै हे खुसुर-फुसुर करै लागथै, “मरै लग जिन्दा होय के एखर काहिन मतलब होही?” ");
INSERT INTO bhu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","चेलन यीसु लग पूछथै, “नियाव के गुरू काखे कथै, का एलिय्याह के आगू आमै के जरूरी हबै?” ");
INSERT INTO bhu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","यीसु जबाब देथै, “एलिय्याह सहीमा आगू आयके सब कुछु सुधारही, पय मनसे कर टोरवा के निता ई लिखे हबै, कि ऊ बोहत दुख उठाही, अउ बेज्जती करे जही। ");
INSERT INTO bhu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","पय मै तोर लग सही गुठेथो, कि एलिय्याह आ चुके हबै, अउ जसना एलिय्याह के बारे हे लिखे हबै, जसना यहूदी नियम के सिक्छा फरीसी मनसे चाहथै, ओसनेन ओखर संग बेउहार करथै।” ");
INSERT INTO bhu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","जब यीसु चेला के लिघ्घो आथै, ता ऊ देखथै अपन चारो-चउगिरदा, अक्ठी बोहत बड्डे भीड अकजुट हबै, अउ यहूदी नियाव के गुरू उनखर लग सबाल करथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","हरबी यीसु के सबझन मनसे देखत, चकित होथै, ओखर पल्ला दउडके ओखर लग बिनती करथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","यीसु यहूदी नियाव के सिक्छन लग पूछथै, “चेलन लग काहिन पूछत रहा?” ");
INSERT INTO bhu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","भीड लग अक्ठी मनसे जबाब देथै, “हे परभु मै अपन टोरवा के, तोर लिघ्घो लाय रहों, ओखर भित्तर अक्ठी बउरा भुतवा हबै। ");
INSERT INTO bhu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","जिहां मोर टोरवा के भुतवा पकडथै, उहै पटक देथै, ओखर मुंह लग गेजरा भर जथै, अउ दांत के चाबथै, मोर टोरवा रोज दिन झुराथै, मै तोर चेला लग कहे रहों, कि भुतवा के निकाड दा। पय उके नेहको निकाड पाथै।” ");
INSERT INTO bhu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ई बातन के सुनके यीसु कथै, “हे अबिस्वासी मनसे मै तुम्हर संग कब तक रइहों? कब तक तुम्हर सइहों? ऊ लरका के मोर लिघ्घो लाबा।” ");
INSERT INTO bhu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","तब मनसे ऊ टोरवा के, ओखर लिघ्घो लाथै जब भुतवा यीसु के देखथै। ता ओही पटकिस अउ ऊ भुंइ हे गिरथै अउ मुंह लग गेजरा बोहे लगिस अउ लोटय लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","यीसु टोरवा के बाफ लग पूछथै, एखर दसा कब लग हबै, ता ओखर बाफ कथै, नान लग हबै। ");
INSERT INTO bhu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","भुतवा उके मरै के निता कइन बार आगी हे, कबहुन पानी हे गिराथै, अगर तै कुछु कर सकथस, ता हमर उप्पर दया कर। ");
INSERT INTO bhu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","यीसु ओखर लग कथै, असना तुम काखे गुठेथा, कि अगर तै कर सकथस ता बिस्वास करिहा ता, सब कुछु हुइ सकथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ऊ ओखर लग कथै, मै बिस्वास करथो, मोर अबिस्वास के बढामै के निता मदद करा। ");
INSERT INTO bhu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","जब यीसु देखिस कि मनसे दउडके चले आथै, तब भुतवा के गधारत कथै, हे बउरा भुतवा मै तोके आदेस देथो, कि टोरवा के जीवन लग निकड जा, अउ फेर कबहुन झइ आबे। ");
INSERT INTO bhu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","तब भुतवा चिरलायके बोहत मरोडत टोरवा कर जीव लग निकड जथै, अउ ऊ मरै के जसना हुइ जथै, तब मनसे कथै, ऊ मर गय हबै। ");
INSERT INTO bhu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","पय यीसु टोरवा कर हाथ पकडके उके उठाइस अउ ऊ ठाड हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","जब यीसु घर छो आथै, ता चेला अकेल्ले हे ओखर लग पूछथै, हम ऊ भुतवा के काखे नेहको निकाड सकन? ");
INSERT INTO bhu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","यीसु उनखर लग कथै, हइ मेर कर भुतवा, “बिना बिनती अउ उपास करै बाहिर नेहको निकडथै।” ");
INSERT INTO bhu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","फेरै यीसु घर लग जाय के, अउ गलील इलाका छो हुइके गुजडिस, ऊ नेहको चाहथै, कि उहां कउनो ई बात के जानै। ");
INSERT INTO bhu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","यीसु अपन चेला के सिखोत कथै, “मनसे कर टोरवा मनसेन कर हाथ पकडोय जही, अउ उके मार डालही, अउ ऊ मरै कर बाद हे, ऊ तीन रोज कर बाद हे जिन्दा हुइ जही।” ");
INSERT INTO bhu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","चेला हइ बात के नेहको समझथै अउ पूछै के निता डर जथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","फेरै यीसु कफरनहूम छो पहुंचथै, ऊ घर हे आयके चेलन लग पूछथै, तुम अपन हे कउन बातन हे झगडा करथा? ");
INSERT INTO bhu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","उन सान्त रथै इहैनिता कि चेला गली हे झगडा करथै, कि हमर लग कउन बड्डे बड हबै। ");
INSERT INTO bhu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","यीसु अपन बारहठे चेलन के बुलाय कर कथै, अगर कोनो बड्डे बड बनै चाहथै, ता उके सबझन लग नान, अउ सबके सेबक बनै के पडही। ");
INSERT INTO bhu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","यीसु अक्ठी नान लरका के, लइके चेलन के बीच हे ठाड करथै, अउ नान लरका के कोरा हे लइके कथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“जउन कउ असना अक्ठी लरका के मोर नाम लग अपनाही, ऊ मोके अपनाही, अउ जउन कउ मोके अपनाथै, ऊ मोके नेहको पय मोके पठोमै, बाले के अपनाथै।” ");
INSERT INTO bhu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","तब यूहन्ना ओखर लग कथै, हे गुरू हम अक्ठी मनसे के देखे हबन, जउन तोर नाम लग भुतवा के निकाडथै, हम उके मना करन, काखे ऊ मनसे हमर संग नेहको आबै। ");
INSERT INTO bhu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","यीसु कथै, उके मना झइ करा, काखे जउन मनसे मोर नाम लग सक्ति के काम करथै, अउ हरबी मोर बारे हे बुरा कही। ");
INSERT INTO bhu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","काखे जउन हमर सताव हे नेहको हबै, ऊ हमर पल्ला हबै। ");
INSERT INTO bhu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","जउन मनसे मोर नाम लग, तोके अक्ठी गिलास हे पानी पियाथै, अउ कथै, तुम मसीह के हबा, मै तुम्हर लग सही कथो, कि ऊ मनसे अपन फल नेहको खोही। ");
INSERT INTO bhu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","पय जउन ई नान लग मोर उप्पर बिस्वास करथै, कउनो के निता पाप के कारन बनही, ऊ मनसे के निता निक्खा ई होही, कि अक्ठी चकिया के पथरा ओखर नटेरी हे, गठियाय के उके समुन्दर के गहिरा हे बोड दय जही। ");
INSERT INTO bhu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","अगर तुम्हर हाथ पाप के कारन बनही, ता उके खपलके फटक दे, ता तोर निता इहै निक्खा हबै, कि तुम लुलवा हाथ सबरोज के जीवन हे जा, अगर दोनो हाथ के संग हे नरक के आगी हे झपोय दय जही, जउन आगी कबहुन नेहको बुझही। ");
INSERT INTO bhu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","जिहां नरक के आगी कबहुन नेहको बुझथै, अउ जिहां किरवा नेहको मरथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","अगर तोर गोड तोके पाप के कारन बनही, ता गोड के खपल डार, इहै निक्खा हबै कि लेंगरा सबरोज के जीवन हे जा, अगर दोनो गोड रहत भरमा नरक हे झपोय दय जही। ");
INSERT INTO bhu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","जिहां नरक के आगी कबहुन नेहको बुझथै, अउ किरवा नेहको मरथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","अगर तोर आंखी तोके पाप के कारन बनही, ता उके निकाड दे, ई निक्खा हबै कि अक्ठी आंखी लग भगवान कर राज हे जा, अगर दोनो आंखी रहत भरमा नरक हे झपोय दय जही। ");
INSERT INTO bhu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","जिहां नरक हे किरवा नेहको मरथै, आगी अउ पीरा कबहुन नेहको बढाथै। ");
INSERT INTO bhu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","जसना कि नून के बलि के निता सुध्द करथै, ओसनेन हर अक्ठी मनसे के आगी लग सुध्द करे जही। ");
INSERT INTO bhu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“नून निक्खा हबै, अगर नून के मिठास खराब हुइ जाय ता खाना के कसना खाये के निता बनाय जा सकथै?” अपन के नून बनाबा, अउ अक्ठी दूसर लग माया के जीवन होय। ");
INSERT INTO bhu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","जब यीसु घर लग निकडके, यहूदिया मनसे के इलाका हे यरदन नदिया के पार आथै, अउ मनसे के बड्डे भीड ओखर के लिघ्घो आ जथै, अउ ऊ भगवान कर राज के बारे हे गुठेमै लागथै, ");
INSERT INTO bhu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","तब फरीसी मनसे यीसु के लिघ्घो आयके पूछे लागथै, का ई उचित हबै? कि डउका अपन डउकी के छांडै। ");
INSERT INTO bhu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","यीसु जबाब देथै, मूसा तुमके काहिन आदेस दय हबै? ");
INSERT INTO bhu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","फरीसी मनसे कथै, “मूसा छोड छुट्ठी के चिट्ठी लिखे अउ छांडै के इजाजत दय हबै।” ");
INSERT INTO bhu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","यीसु उनखर लग कथै, तुम्हर मन कठोर होय के कारन मूसा तुम्हर निता हइ आदेस लिखे हबै। ");
INSERT INTO bhu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","दुनिया के सुरू लग भगवान मनसे के डउका अउ डउकी के निता बनाय हबै। ");
INSERT INTO bhu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","हइ कारन मनसे अपन दाय-बाफ लग, अलगे हुइके अपन डउकी के संग रही, अउ जुडे रही। ");
INSERT INTO bhu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","अउ दोनो अक्ठी देह के होही, इहैनिता डउका अउ डउकी अब दुइठे नेहको पय अक्ठी देह हबै। ");
INSERT INTO bhu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","इहैनिता जिनही भगवान जोडी बनाय हबै, उके मनसे झइ बिरकामै। ");
INSERT INTO bhu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","जब उन घर हे जाथै, ता चेला यीसु लग पूछथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","यीसु उनखर लग कथै, “जउन डउका अपन डउकी के छांड के, दूसर डउकी लग काज करके लानथै, ता पहिले के बिरोध डउका ओखर संग गलत काम करथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","अगर डउकी अपन डउका के छांड के, दूसर लग काज कर लेथै, ता ऊ बेभिचार गलत काम करथै।” ");
INSERT INTO bhu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","फेरै मनसे नान लरकन के, यीसु के लिघ्घो लानथै, कि ऊ उनखर उप्पर हाथ धरै, पय चेला उनही गधार देथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","यीसु ई देखके, निक्खा नेहको लगिस अउ यीसु कथै, उनही मोर लिघ्घो आमै देया, उनके झइ मना करा, काखे कि भगवान कर राज हे, नान लरकन के जसना मन बालेन के निता हबै। ");
INSERT INTO bhu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","मै तोर लग सही कथो, जउन कउ भगवान कर राज गद्दी के, नान लरका के जसना नेहको अपनाही, ऊ मनसे स्वरग हे नेहको जा सकथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","तब यीसु नान लरकन के अपन हाथ हे लेथै, अउ उनखर उप्पर हाथ धरिस, अउ उनही आसिरबाद देथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","जबय यीसु गली हे जात रथै, ता अक्ठी मनसे दउरके आथै, अउ ओखर आगू घुटवा टेक के पूछथै, हे निक्खा गुरू, सबरोज के जीवन पामै के निता मै काहिन करव? ");
INSERT INTO bhu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","यीसु ओखर लग कथै, तुम मोके निक्खा काखे कथा? भगवान के छांड के कउनो निक्खा नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","तै आदेस के जनथस, गलत काम झइ करा, खून झइ करा, चोरी झइ करा, झूठे गवाह झइ दइहा, झइ नरा, अउ दाय-बाफ कर इज्जत करा। ");
INSERT INTO bhu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","धनी मनसे ओखर लग कथै, गुरू जी, मै हइ सब काम नान लग करत आय हव। ");
INSERT INTO bhu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","यीसु ओही देखके ओखर लग माया करिस, अउ ओखर लग कथै, तोर भित्तर अक्ठी कमी हबै, जा जउन कुछ तोर लिघ्घो हबै, उके बेच के, उके गरीबन के बांट दे अउ तोके स्वरग हे धन डेरा मिलही। अउ आ मोर पाछू हुइ जा। ");
INSERT INTO bhu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ई बातन के सुनके, धनी मनसे के सकल हे उदासी छाय गय, अउ मुरझाय के अपन घर छो कढ जथै, काखे ऊ बोहत धनी रथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","यीसु चारो-चउगिरदा देखके अपन चेला लग कथै, जउन मनसे धनी हबै, ओखर निता भगवान कर राज हे जाय के निता केतका दिग्गत हबै। ");
INSERT INTO bhu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","चेला यीसु के बातन लग बोहत चकराय जथै, ई बातन के ऊ फेरै कथै, हे नान लरका, जउन मनसे धन हे बिस्वास करथै, ओखर निता भगवान कर राज हे जाय के निता बोहत दिग्गत हबै। ");
INSERT INTO bhu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","अक्ठी उंटवा के नाक ले धागा सुज्जी कर छेदा लग घुस सकथै, पर अक्ठी धनी मनसे भगवान कर राज हे जाय के निता बोहत दिग्गत हबै। ");
INSERT INTO bhu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","चेला बोहत चकराय के अपन हे कथै, ता फेर केखर मुकति हुइ सकथै? ");
INSERT INTO bhu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","यीसु चेलन पल्ला देखिस अउ कथै, मनसे ई काम नेहको कर सकथै, पय भगवान लग सगलू कुछु कर सकथै, काखे ओखर लग सगलू कुछ लिखडी हबै। ");
INSERT INTO bhu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पतरस यीसु लग कहे लागथै, देखा, सगलू कुछु छांड के हम तोर पाछू आय गय हबन। ");
INSERT INTO bhu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","यीसु कथै, मै तुम्हर लग सही कथो, सबझन मनसे हबै, जउन मोर कारन अउ मोर संदेस के कारन अपन घर, भाई, बेहन, दाय-बाफ या लरकन, या खेत के छांड दय होय, ");
INSERT INTO bhu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","हइ जीवन हे बोहत कुछ पइहिन, सव गुना घर, भाई, बेहन, दाय-बाफ, लरका, खेत के पय सताव आही, पय आमै बाले पीढी हे सबरोज के निता जीवन उनके मिलही। ");
INSERT INTO bhu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“पय जउन बोहत आगू हबै, ऊ पाछू होही, अउ जउन पाछू हबै, ऊ आगू होही।” ");
INSERT INTO bhu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","यीसु अउ चेले यरुसलेम के गली लग जात रथै, अउ यीसु आगू-आगू जात रहिस, अउ बहुत डेराय रहिन अउ चेला यीसु के पाछू रेंगत रथै, अउ चेला रथै, तब यीसु अपन बारहठे चेलन के सगलू बात गुठेमै लागथै, जउन यीसु के संग होय बाले रथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","यीसु उनखर लग कथै, “हम यरुसलेम नगर छो जथन, अउ मनसे कर टोरवा पुजारी अउ नियाव के गुरू के हाथ पकडोय जही, अउ उके मरै के सजा दय जही, अउ मै गैर यहूदी के हाथ हे दइ दे जही। ");
INSERT INTO bhu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","अउ मनसे मोर मजाक उडाही, अउ उन थूकही, कोढन हे मरहिन, अउ मार डरही, पय तीन रोज के बाद फेरै जिन्दा हुइ जहुं।” ");
INSERT INTO bhu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","तब जबदी कर टोरवा याकूब, अउ यूहन्ना यीसु कर लिघ्घो आयके कथै, हे गुरू, हम चाहथन कि जउन कुछु तोर लग बिनती करके मगबो, तै हमर निता करबे। ");
INSERT INTO bhu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","यीसु कथै, तुम काहिन चाहथा? कि मै तुम्हर निता करव। ");
INSERT INTO bhu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","याकूब अउ यूहन्ना यीसु लग कथै, काखे तोर महिमा के निता, हम दोनो भाई लग अक्ठी तोर टेटरा पल्ला, अउ दुसर दहिना पल्ला बइठबे। ");
INSERT INTO bhu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","यीसु उनखर लग कथै, तुम नेहको जानथा कि का मांगथा? जउन दुख के प्याला पीय बाले हव, का तुम सहि सकथा? अउ जउन मै बतिस्मा ले बाले हव, का तुम लइ सकिहा? ");
INSERT INTO bhu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","अउ उन कथै, हव हम कर सकथन, यीसु उनखर लग कथै, जउन दुख भोगे बाले हव, तुम भोग सकथा, अउ जउन बतिस्मा ले बाले हव, का तुम लइ सकथा। ");
INSERT INTO bhu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ई मोर हाथ हे नेहको हबै, कि केही अपन टेटरा या दहिना पल्ला बइठाहूं, पय ई जेखर निता तइयार करै गय हबै, उहै के मिलही। ");
INSERT INTO bhu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ई बातन के सुनके, बाकी चेलन याकूब अउ यूहन्ना लग गुस्साय जथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","पय यीसु उनके अपन लिघ्घो बुलाय के कथै, “तोके ई पता हबै, कि गैर यहूदी साहब मनसे, अपन हक जमाथै, अउ मनसे के उप्पर राज करथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","असना तुम्हर बीच हे नेहको होय चाही। तुम्हर लग जउन कउ दूसर लग बड्डे होय चाहथै, ऊ पहिले दूसर के सेबक बनै। ");
INSERT INTO bhu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","अगर तुम्हर लग जउन कउ बड्डे बनै चाहथै, ऊ पहिले सब के हरवाह बनै। ");
INSERT INTO bhu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","काखे मनसे कर टोरवा अपन सेबा करामै के निता नेहको, पय तुम्हर सेबा करै आय हबै, अउ सगलू मनसे जात के पापन लग छंडाय के निता जीवन दे आय हबै।” ");
INSERT INTO bhu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","अक्ठी रोज यीसु अउ चेला यरीहो नगर छो आथै, अक्ठी बड्डे भीड अकजुट होथै, जबय यीसु अउ ओखर चेलन यरीहो नगर छो निकडके जथै, ता गली हे तिमाई के लरका जउन अन्धरा बरतिमाई रथै, जउन अन्धरा भीख मांगै के निता, गली के टाठा हे बइठे रथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","जबय बरतिमाई के पता चलथै, कि उहै गली लग यीसु गुजरथै, ता ऊ बोहत चिरलाय लागथै, हे यीसु नासरी दाऊद के लरका, मोर उप्पर दया कर। ");
INSERT INTO bhu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","बोहत मनसे अन्धरा भिखारी के गधार के कथै, चुप्पे हुइ जा, पय अन्धरा भिखारी अउ बोहत चिरलाय लागथै, हे दाऊद के लरका, मोर उप्पर दया कर। ");
INSERT INTO bhu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","अउ ऊ रुक जथै, अउ कथै, अन्धरा मनसे के मोर लिघ्घो लाबा, अउ मनसेन उके बुलाय के कथै, हिम्मत धर, अउ ठाड हुइ जा, यीसु तोके बुलाथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ऊ अपन खुरथा पइजामा के फेकिस, अउ कूदके यीसु के लिघ्घो आ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","यीसु ओखर लग कथै, तै काहिन चाहथस, कि मै तोर निता करव? अन्धरा मनसे कथै, हे परभु, मै देखै चाहथो। ");
INSERT INTO bhu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","यीसु कथै, “जा तोर बिस्वास तोके निक्खा करै हबै।” अउ ऊ हरबी देखै लगथै, अउ यीसु के संग हे रेंगै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","जसना ही यीसु यरुसलेम नगर के लिघ्घो आथै, अउ बैतफगे अउ बैतनिय्याह गांव के लिघ्घो पहुंचथै, जैतून के डोंगर हे यीसु मसीह दुइठे चेला के गुठे के पठोथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","चेलन लग कथै, कि आगू बाले गांव छो जा, जसना तुम उहां पहुंचिहा, तुम अक्ठी गदही कर लरका बंधररे हर पाबे, जेखर उप्पर कबहुन कोनो नेहको बैठे हबै, उके छोर के लइ आनबे। ");
INSERT INTO bhu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","अगर कोनो तोके कुछु बोलहिन, ता ई तुम काखे करथा, ता बोलबे कि परभु के एखर जरूरत हबै, ता ऊ मनसे तुमके लइ जाय देही। ");
INSERT INTO bhu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","चेलन उहां लग निकड गइन, अउ उहां पहुंचथै, ता दूरा के लिघ्घो अक्ठी गदही कर लरका बंधररे हर पाथै अउ उके छोरथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","उछो ठाढे कुछ मनसे उनखर लग कथै, तुम काखे गदही कर लरका के छोरथा। ");
INSERT INTO bhu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","जसना यीसु कहे रथै, ओसनेन चेलन मनसे लग कहि देथै, तब मनसे उनिन के जाय देथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","चेलन गदही कर लरका के, यीसु के लिघ्घो लइ जथै, उन जबान गदहा के पिठार हे बन्डी मडाथै, अउ यीसु गदहा के पिठार हे बइठ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","बोहत मनसे अपन बन्डी के, उतार के गली हे बिछाथै, अउ मनसे रूख के डेरइया खपलके, अउ गली हे बिछाय देथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","आगू-आगू जाय बाले, अउ पाछू-पाछू जाय बाले मनसे चिरलाय-चिरलायके कथै, जय होय, धन्य हबै ऊ जउन परभु के नाम लग आथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","हमर बाफ दाऊद के राज महान हबै, जउन परभु के नाम लग आथै, धन्यबाद हबै, जय होय। ");
INSERT INTO bhu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","यीसु यरुसलेम नगर छो पहुंच के बिनती भवन हे आथै, ऊ चारो चउगिरदा देखथै, इहैनिता बोहत देरी हुइ जथै, ऊ चेलन के संग बैतनिय्याह गांव छो रेंग दइस, ऊ अपन बारहठे चेलन के संग बैतनिय्याह हे पहुंचथै अउ संझा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","सकारे जब हुइस ता यीसु बैतनिय्याह गांव लग निकडिस, अउ ऊ भुखाय रथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ऊ अंजीर के रूख के देखके ओखर लिघ्घो जथै, यीसु के पत्ता के सिबाय कुछु नेहको मिलथै, काखे फडुहा के टेम नेहको रथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","यीसु अंजीर के रूख लग कथै, “अब लग तोर कबहुन फडुहा नेहको फरही।” अउ चेला ई बात के सुनथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","एखर बाद यीसु यरुसलेम नगर छो आथै, अउ ऊ भगवान के बिनती भवन हे आथै, अउ उहां, बनिया कर समानन के बिकरी नामा करथै, उनही बाहिर निकाडे लागथै, अउ ऊ समान बदलै बालै के अउ परेवा बिकनै बाले के खुरसी के पलटाय देथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","अउ यीसु बिनती भवन हे कउनो के भाडे बरतन लइके आमै जाय नेहको देथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","यीसु ई कथै, का ई नेहको लिखे हबै, भगवान के बिनती भवन सगलू जातन के निता कहाही, पय तुम मनसे हुइके चोरटा के ठीहा बनाय डारे हबा। ");
INSERT INTO bhu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ई बात के सुनके पुजारी, अउ नियाव के गुरू यीसु के मारै के निता मउका खोजै लागथै। काखे ऊ ओखर लग डरथै, इहैनिता सगलू मनसे ओखर बातन लग चकराय रथै, ");
INSERT INTO bhu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","संझा होथै ता, यीसु अउ चेला यरुसलेम नगर छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","भिनसारे टेम यीसु, अउ ओखर चेलन रास्ता लग जथै, तब उन अंजीर कर रूख के जर तक झुराय हर देखथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पतरस के यीसु के कहे हर बात सुरता आय जथै, अउ पतरस यीसु लग कथै, “हे गुरू, देखा ई अंजीर कर रूख के तै सराप दे रहस, ऊ रूख झुराय गय हबै।” ");
INSERT INTO bhu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","यीसु उके कथै, “भगवान के उप्पर बिस्वास करा। ");
INSERT INTO bhu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","मै तुम्हर लग सही कथो, कि जउन कउ हइ डोंगर लग कही, कि तै टर जा, अउ समुन्दर हे कढ जा अउ अपन मन हे सक झइ करै, पय बिस्वास करै, कि जउन मै कथो, ऊ हुइ जही ता ओखर निता ओसनेन हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","इहैनिता मै तुम्हर लग कथो, कि जउन कुछु तुम बिनती करके मांगथा, ता बिस्वास करै कि ऊ तोके मिल जही, अउ तुम्हर निता ओसनेन हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","बिनती करत टेम अगर तुम्हर मन हे, कउनो के निता कुछु बिरोध हबै, उके छमा कर देया, तब तुम्हर बाफ जउन स्वरग छो हबै, तुम्हर पाप छमा करही। ");
INSERT INTO bhu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","अगर तुम छमा नेहको करिहा, ता तुम्हर बाफ जउन स्वरग हे रथै, ऊ तोर पापन के छमा नेहको करही।” ");
INSERT INTO bhu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","यीसु अउ चेले यरुसलेम नगर छो आथै, जब ऊ बिनती भवन छो घूमत रथै, ता बलि चढामै बाले पुजारी अउ नियाव के गुरू सियान, ओखर लिघ्घो आयके पूछै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","उन ओखर लग पूछथै, तै हइ काम केखर हक लग करथस? अउ हइ हक तोके कोन दय हबै, कि तै हइ काम करथस? ");
INSERT INTO bhu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","यीसु उनखर लग कथै, महुं तुम्हर लग अक्ठी बात पूछहूं, अगर मोके जबाब देबे, तब महुं तुमके गुठेहूं, कि हइ काम केखर हक लग करथो। ");
INSERT INTO bhu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","यीसु कथै, मोके गुठेवा, यूहन्ना बतिस्मा देय बाले स्वरग के पल्ला लग हबै, कि मनसे के पल्ला लग हबै? ");
INSERT INTO bhu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","तब ऊ अपन हे सोचै लागथै, अगर हम कहबो कि स्वरग के पल्ला लग हबै, ता यीसु कहि कि तुम यूहन्ना कर उप्पर बिस्वास काखे नेहको करथा? ");
INSERT INTO bhu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","अउ अगर हम कहबो, कि मनसे के पल्ला लग हबै, ता मनसे के डर हबै, काखे सगलू मनसे जानथै, कि यूहन्ना निक्खा ग्यानी मनसे रथै। ");
INSERT INTO bhu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","तब उन ओही जबाब देथै, हम नेहको जानथन, “यीसु उनखर लग कथै महुं तुमके नेहको गुठेहूं, कि मै हइ काम केखर हक लग करथो।” ");
INSERT INTO bhu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","यीसु अक्ठी किस्सा दइके पंडित मनसे लग बात करै लागथै, कथै, अक्ठी मनसे रथै, जउन बगिया हे अंगूर के पउधा लगाथै, पउधा के निता बखरी बनाथै, अउ अक्ठी कुंवा बनाथै, अउ मडइचा बनाथै, एखर बाद हे अंगूर के बगिया के किराया हे दइके दूसर देस कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","अंगूर पके के टेम हे, ऊ अपन अक्ठी हरवाह के पठोथै, कि किसान अंगूर के बगिया लग आधा हीसा हरवाह के दइदे। ");
INSERT INTO bhu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","पय किसानन उके पकडके पीटिन, अउ जुछ्छे हाथ लउटाय के पठो देथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","जउन मालिक रथै, ऊ दूसर हरवाह के किसानन लिघ्घो पठोथै, अउ उन ओखर मूड के फोर देथै, अउ उके घर छो लउटाय के पठो देथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","फेरै ऊ तीसर हरवाह के पठोथै, किसान उहो के मार डालथै, तब ऊ मनसे अउ बोहत हरवाहन के पठोथै, उनो हरवाहन के पीटिन अउ दोनोन के मार डालथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","अब अकठिन बचे हबै, जउन ओखर पिरिया लरका रथै, आखरी हे उहां उके किसान के लिघ्घो, हइ सोचके पठोथै, कि मोर लरका आय अउ ओखर इज्जत करही। ");
INSERT INTO bhu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","पय उन कथै, कि इहै हकदार हबै, हम इके मार डालबो, ता अंगूर के बगिया सगलू धन हमर हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","अउ किसान उहो के पकडके मार डालथै, अउ अंगूर के बगिया के बाहिर छो फटक देथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","इहैनिता बगिया के मालिक काहिन करही? ऊ आयके किसान के मारही, अउ अंगूर के बगिया दूसर के दइ देही। ");
INSERT INTO bhu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","का तुम पवितर किताब हे, हइ बचन के नेहको पढे हवा, जउन पथरा के राज मिसतिरी बेकार समझे रथै, उहै कोना के सिरा मुख्य पथरा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ई परभु के पल्ला लग होथै, अउ हमर आंखी हे अदभुत हबै। ");
INSERT INTO bhu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","जउन यहूदी मुखिया रथै, उन यीसु के पकडै के चाहथै, पय समझ जथै, कि ई किस्सा हमर निता कहे हबै। पय उन मनसे लग डर जथै अउ उके छांड के कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","कुछ फरीसी जउन हेरोदियो के समूह मसे कुछ मनसेन यीसु के अपन बातन हे फसामै के निता, अपन चेलन के ओखर लिघ्घो पठोथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","उन यीसु लग कथै, हे परभु, हम जानथन कि तै सही हवस, तै कोनो मेर के चिन्ता नेहको करथस, काखे तै मनसे के सकल देखके बात नेहको करथस। पय तै भगवान के रास्ता के बारे हे गुठेथस। कैसर के अपन कमाई के आधा हीसा दे का उचित हबै कि नेहको? ");
INSERT INTO bhu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","इहैनिता हमके गुठे, तै काहिन सोचथस? रोमी के राजा के देय के निता जरूरी हबै कि नेहको? यीसु उनखर कपट के जानके उनखर लग कथै, मोके काखे परखथा? अक्ठी चांदी के पइसा के मोर लिघा लाबा, ता महुं उके देखहुं। ");
INSERT INTO bhu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ऊ पइसा के लइके आथै, यीसु उनखर लग कथै, ई छाप अउ नाम केखर हबै? उन कथै, कैसर कर। ");
INSERT INTO bhu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","यीसु उनखर लग कथै, “जउन कैसर के हबै, ऊ कैसर के देया, जउन भगवान कर हबै, भगवान के देया।” तब उन ओखर बातन के सुनके बोहत चकराय जथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","कुछ सदूकी कथै, जउन मनसे मर जथै, ऊ कबहुन जिन्दा नेहको होथै, उन यीसु कर लिघ्घो आयके पूछथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","हे गुरू, मूसा हमर निता, जउन लिखे हबै, कि अगर कोनो के भाई बिना लरका होबाय मर जाय, अउ ओखर डउकी ओसनेन रही जाय, ता ओखर भाई ओखर डउकी लग काज कर सकथै, अउ अपन भाई के निता लरका पइदा करही। ");
INSERT INTO bhu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","काखे कि ऊ सातठे भाई रथै, सबले आगू बाले भाई काज करके बिना लरका होबाय मर जथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","अउ दूसर भाई, उहै डउकी लग काज करथै, उहो बिना लरका होबाय मर जथै, अउ ओसनेन तीसर भाई करथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","अउ सातो भाई ऊ डउकी लग काज करथै, बिना लरका के मर जथै, आखरी हे उहो डउकी मर जथै, अउ कउनो लरका नेहको होथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","जब सगलू मरे मसे जिन्दा हुइहिन ता, ऊ उनखर मसे केखर डउकी होही? काखे ऊ डउकी सातो भाई के डउकी हुइ चुकथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","यीसु उनखर लग कथै, “का तुम कउन कारन लग बिसरे हबा, तुम पवितर किताब के नेहको जानथा, अउ भगवान कर सक्ति के नेहको जानथा। ");
INSERT INTO bhu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","जब मरे मसे जिन्दा हुइ जही, ता डउका अउ डउकी काज नेहको करही, ऊ मनसे स्वरग हे स्वरगदूत के जसना होही। ");
INSERT INTO bhu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","मरे हर मसे जी उठे के बारे हे, का तुम मूसा कर किताब हे पुडरा कर किस्सा नेहको पढे हबा, भगवान उनखर लग कथै, मै अब्राहम के भगवान अउ इसहाक के भगवान अउ याकूब के भगवान हव? ");
INSERT INTO bhu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","भगवान मरे हर के नेहको, पय जिन्दा मनसे के भगवान हबै, काखे तुम बड्डे भूल हे पडे हबा।” ");
INSERT INTO bhu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","मूसा कर नियाव के गुरू मसे अक्ठी धरमगुरू इन बातन के जानके कि यीसु सदूकीन के निक्खा सबाल के जबाब देथै, ओखर लिघ्घो आयके पूछथै, हे परभु, सगलू आदेस लग बड्डे आदेस कउन हबै? ");
INSERT INTO bhu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","यीसु ओही जबाब देथै, “सगलू आदेस लग हइ बड्डे आदेस हबै, हे इस्राएल देस के मनसे सुना, हमर परभु भगवान अकठिन हबै, ");
INSERT INTO bhu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","अउ तै परभु अपन भगवान लग पूर मन लग, अपन सगलू परान लग अउ सगलू अक्किल लग अपन सगलू बल लग माया के, इहै बड्डे आदेस हबै। ");
INSERT INTO bhu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","अउ दूसर आदेस ई हबै, तै अपन परोसी लग अपन जसना माया रखबे, इन दोनो के सिबाय अउ कउनो बड्डे आदेस नेहको आय।” ");
INSERT INTO bhu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","नियाव के गुरू ओखर लग कथै, हे परभु तै सही कथस, अक्ठी भगवान हबै, एखर सिबाय अउ कोनो नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","अउ अपन भगवान लग अपन पूर मन लग, अउ अक्किल लग, अउ परान अउ बल के संग माया करबे, अउ अपन परोसी लग अपन जसना माया करबे, सगलू बलि चढावा पूजा लग बढके हबै। ");
INSERT INTO bhu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","यीसु सही जबाब सुनके नियम के गुरू लग कथै, “तुम भगवान कर राज लग दुरिहां नेहको हबस।” एखर बाद हे फेरै ओखर लग सबाल पूछय के हिम्मत नेहको होथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","यीसु बिनती भवन हे सिक्छा देत टेम उनखर लग कथै। नियाव के गुरू काखे कथै, कि मसीह के दाऊद कर टोरवा कथै? ");
INSERT INTO bhu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","इहैनिता कि खुदय दाऊद, पवितर आतमा के मदद लग कथै, कि परभु मोर परभु लग कहिस, मोर दहिना पल्ला बइठ, जब तक मै तोर बैरी के गोड तरी नेहको ला देयो। ");
INSERT INTO bhu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","इहैनिता दाऊद अगर परभु कथै, ता फेरै ऊ ओखर टोरवा कसना हुइस? अउ सगलू मनसे यीसु के बातन के सुनत रहिन। ");
INSERT INTO bhu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","सिक्छा देत टेम यीसु कथै, नियाव के गुरू लग चेतन्न रहा, ऊ मनसे लम्बा-लम्बा खुरथा पइजामा ओढ के बजार हे बागथै, ऊ मनसेन लग नमस्ते सुनय के पसंद करथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","अउ तेउहार के टेम हे, सभा घर हे सगलू लग निक्खा कोठा अउ मंडली हे आगू खुरसी के ताक हे रथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","पय हइ मनसे लम्बा बिनती करै के दिखाथै, बिधवा डउकी के डेरा के झटक लेथै, अउ ओखर घर के हडप लेथै, इन मनसे के बोहत सजा मिलही। ");
INSERT INTO bhu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","तब ऊ चेला के अपन लिघ्घो बुलाय के कथै, मै तुम्हर लग सही कथो कि बिनती भवन हे कउन मेर लग पइसा डालथै, अउ बोहत धनी मनसे रथै, उन बोहत कुछ पइसा दान पेटी हे डालथै, उनखर मसे गरीब बिधवा डउकी सब लग बढके डालथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","अक्ठी गरीब बिधवा डउकी रथै, उहां आयके दुइठे तांबा के चिल्लर डालथै, जउन दुइ सव के बरोबर रथै। ");
INSERT INTO bhu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","यीसु अपन चेला के अपन लिघ्घो बुलाय के कथै, “मै तुम्हर लग सही कथो, कि जउन मनसे दान पेटी हे पइसा डालथै, उन सबझन लग हइ गरीब बिधवा डउकी सबले बढके डाले हबै। ");
INSERT INTO bhu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","काखे कि सगलू मनसे अपन बढत मसे दय हबै, पय ई डउकी अपन गरीबी हे रही के अपन सगलू उमर भर के कमाई के पइसा डाल देथै।” ");
INSERT INTO bhu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","जब यीसु बिनती भवन लग निकडथै, ता ओखर अक्ठी चेला ओखर लग कथै, “हे परभु, देख, इहां कइनमेर के पथरा अउ केतका निक्खा इमारत हबै।” ");
INSERT INTO bhu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","यीसु उनखर लग कथै, “का तुम ई इमारत के बात करथा? इहां असना कउनो पथरा नेहको हबै जउन तरी लग गिराय नेहको जही।” ");
INSERT INTO bhu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ऊ यीसु के लिघ्घो अकान्त हे आथै, अउ जैतून के डोंगर हे बिनती भवन के जउन घटिया के लिघ्घो बइठे रथै, तब पतरस, याकूब अउ यूहन्ना, अउ अन्द्रियास ओखर लग पूछथै। ");
INSERT INTO bhu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“हमही गुठे कि असना कब होही? अउ ई सगलू बात कब होही, ऊ टेम के चिन्हा काहिन होही?” ");
INSERT INTO bhu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","यीसु उनखर लग कथै, चेतन्न रहा, कि तोके कोनो झइ बहकामै। ");
INSERT INTO bhu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","इहैनिता कि मोर नाम लग हर अकझन कइहिन कि मै मसीह हबो। ");
INSERT INTO bhu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","जब तुम लडाई के उप्पर लडाई के खबर सुनइहा, ता झइ घबरइहा, काखे ई सगलू बातन के होय के जरूरी हबै, पय एखर मतलब हइ आखरी टेम नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","काखे जात लग जात, अउ अक्ठी राज के दूसर राज के संग लडाई करही, अगल-बगल जिघा हे भुंइडोल आकाल होही, हइ आगू परथम कनिहा के पीरा सुरू होय के टेम हबै। ");
INSERT INTO bhu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","पय तुम चेतन्न रइहा, काखे मनसे तोके मंडली हे सोप देही, अउ तुमही मंडली हे पिटही, मोर नाम के चलते तुमही राजपाल अउ राजा के आगू ठाढ करही, कि उनखर निता गवाह होय। ");
INSERT INTO bhu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","हइ संदेस सबझन मनसेन के सुनाय जही, अउ सगलू देस के मनसे हे परचार करे जही। ");
INSERT INTO bhu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","जब मनसे तोके लइ जाय के निता पकडाही, ता आगू लग चिन्ता झइ करबे, कि का गुठेहूं जउन आगुन हइ बात गुठे दय जही, उहै कहबे, काखे गुठेय बाले तुम नेहको हबा, पय पवितर आतमा हबै। ");
INSERT INTO bhu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ऊ रोज भाई अपन भाई के, अउ बाफ अपन टोरवा के, अउ लरका अपन दाय-बाफ के बिरोध होही, अउ मरवा डरही। ");
INSERT INTO bhu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","अउ मोर नाम के कारन मनसे, तुम्हर लग घिनाही पय जउन आखरी तक बिस्वास करी, उहै के मुकति होही। ");
INSERT INTO bhu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","पय जब तुम ऊ मारै बाले घिनाय हर चीज जिहां जरूरी नेहको उहां ठाढ देखिहा, तब जउन यहूदिया हे होय, ता भाग के डोंगर छो कढ जाय। ");
INSERT INTO bhu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","जउन मनसे घर के छानी हे हबै, कुछु चीज के निता तरी झइ उतरै, अउ घर के भित्तर नेहको जाय, काखे ओखर निता टेम नेहको रही ");
INSERT INTO bhu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","जउन मनसे अपन खेत हे हबै, ऊ अपन खुरथा पइजामा के निता घर झइ लउटै। ");
INSERT INTO bhu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","पय दुख हबै उन डउकिन के, जउन लादा हे हबै अउ दूध पिलामै बाले उनके निता हाय, उनखर निता बोहत कठिन होही। ");
INSERT INTO bhu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","हइ बिनती करा कि, हइ जाड के टेम झइ होय। ");
INSERT INTO bhu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","काखे ई रोज हे असना दुख होही कि, दुनिया के सुरू लग जउन भगवान बनाय हबै, अब तक नेहको होय हबै, अउ न कबहुन होही। ");
INSERT INTO bhu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","अगर परभु हइ रोज के चुटु नेहको करथै, ता कोनो जीव नेहको बचतिस, पय चुने हर मनसेन के कारन ऊ रोज के गिनती चुटु करै हबै। ");
INSERT INTO bhu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ऊ टेम कोनो तुम्हर लग कही, देखा, मसीह इछो हबै, उछो हबै, ता ऊ बातन के झइ बिस्वास करिहा, ");
INSERT INTO bhu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","काखे झूठे मसीह अउ झूठ बोलै बाले ग्यानी मनसे अइहिन, अउ चिन्हा अउ चकित मेर काम दिखाही, अउ हुइ सकथै भगवान कर चुने हर मनसेन के भटकोय देही। ");
INSERT INTO bhu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","पय तुम सचेत रइहा, काखे मै तुमही सगलू बातन के आगुन लग गुठे दय हबो। ");
INSERT INTO bhu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ऊ टेम हे अउ ऊ दुख के बाद हे, बेरा अंधियार हुइ जही, अउ जोधइया के उजेड नेहको देही, ");
INSERT INTO bhu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","अउ बादर ले तरइया गिरै लगहिन, अउ बादर के सक्ति डोलाय जही। ");
INSERT INTO bhu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","तब मनसे कर टोरवा के बड्डे सक्ति अउ महिमा के संग बादर हे अउत मनसे देखही। ");
INSERT INTO bhu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ऊ टेम भगवान अपन स्वरगदूत के पठोही, भुंइ के ओराछोर लग बादर के ऊ ओराछोर तक, चारो चउगिरदा लग अपन चुने हर मनसेन के अकजुट करही। ");
INSERT INTO bhu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","अंजीर कर रूख लग ई किस्सा के सिखा, जब ओखर डगइल कोवड होथै, ता पत्ता निकडे लागथै, ता तुम जान जथा, कि जेठ के मोसम लिघ्घो हबै। ");
INSERT INTO bhu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","इहैमेर जब तुम, ई बातन के होत देखिहा, ता जान लइहा कि टेम लिघ्घो हबै, बलुक फेरका के दूरा हे हबै। ");
INSERT INTO bhu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","मै तुम्हर लग कथो, जब तक ई बात पूर नेहको होही, तब तक हइ पुरखा के मनसे नेहको मरहिन। ");
INSERT INTO bhu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","बादर अउ भुंइ बढय जही, पय मोर बात कबहुन नेहको बढाही। ");
INSERT INTO bhu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ऊ रोज या ऊ टेम कब आही, स्वरग कर स्वरगदूत कउनो के पता अउ न टोरवा के, सिबाय भगवान बाफ जानथै। ");
INSERT INTO bhu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","जागत रहा अउ तइयार रहा, काखे तुमके नेहको पता कि ऊ टेम कब आही। ");
INSERT INTO bhu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ऊ मनसे के जसना हबै, जउन ऊ अपन घर के छांडथै, अउ दुरिहां के यातरा करै के निता निकडथै, ऊ अपन हरवाह के हक देथै, अउ हर अक्ठी के काम देथै, अउ दूरा लिघ्घो रहै बाले के जगा रहै के निता आदेस देथै। ");
INSERT INTO bhu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","इहैनिता जागत रइहा, काखे तोके पता नेहको हबै, कि घर के मालिक कब आही, सांझ के टेम, बोहत रात के टेम, मुरगोसा के टेम, या बेरा निकडत टेम। ");
INSERT INTO bhu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","कहुं असना झइ होय, कि ऊ छिन्नै आ जाय, अउ तोके सोवत पाबै। ");
INSERT INTO bhu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","अउ जउन तुम्हर लग कथो, ऊ सब लग कथो, जगत रहा।” ");
INSERT INTO bhu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","फसह के तेउहार अउ अखमीरी के रोटी, के तेउहार हे दुइ रोज बाकी रथै, अउ पुजारी अउ नियाव के गुरू ताक हे रथै, कि यीसु के धोखा हे कसना पकडी, अउ मार डारी। ");
INSERT INTO bhu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","पय हइ कथै, “तेउहार के रोज झइ करा, नही ता बोहत झगडा ठाढ हुइ जही।” ");
INSERT INTO bhu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","जब यीसु बैतनिय्याह के गांव हे, समोन जउन कोढी के घर हे खाना खाये के बइठे रथै, ता अक्ठी डउकी जटामासी सुध्द महकनी तेल चुकरा हे लइके आथै, अउ ऊ ढक्कन के खोलके, ओखर मुड हे उलद देथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","कुछ मनसे गुसायके कथै, ई महकनी तेल के बेकार काखे करथा? ");
INSERT INTO bhu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","काखे हइ महकनी तेल के तो तीन सव चांदी के पइसा, जउन अक्ठी साल के कीमत के बरोबर रथै, बेच के गरीबन के मदद कर सकथन, सगलू कउ मनसे ई बात के चढाई करथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","यीसु कथै, “उके छांड देया उके काखे तंग करथा? उहां मोर संग निक्खा काम करै हबै। ");
INSERT INTO bhu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","इहैनिता कि गरीब मनसे तुम्हर संग सगलू रोज रही, जब तुम चइहा ओखर मदद कर सकथा, पय मै तुम्हर संग सबरोज नेहको रइहों। ");
INSERT INTO bhu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","उहां ऊ करिस, जउन ऊ कर सकथै, एखर पहिले कि मै पाटे जहुं, ऊ मोर देह हे महकनी तेल लग अभिसेक करिस। ");
INSERT INTO bhu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","मै तुम्हर लग सही कथो, कि ई दुनिया हे जिहां कहुं संदेस के परचार करै जही, जउन ऊ करै हबै, मनसे उके सुरता करही।” ");
INSERT INTO bhu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","तब यहूदा इस्करियोती जउन बारहठे चेलन मसे अक्ठी रथै, यीसु के उनखर हाथ पकडवामै के निता, पुजारी के लिघ्घो जथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","जब पुजारी ई बातन के सुनथै ता ऊ मगन होथै, अउ कुछ चांदी के पइसा देय के निता टीमा करथै, अउ यहूदा निक्खा टेम के मउका ढूंढै लागथै कि यीसु के कउनो मेर लग पकडोय दइहों। ");
INSERT INTO bhu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","अखमीरी रोटी के तेउहार के पहले रोज, जेहमा ऊ फसह के गेडरा का बलि कछो चढाबे, चेला ओखर लग कथै, फसह के गेडरा के कछो बलि चढाउब? तै कछो चाहथस? कि हम भात खाय निता तइयार करबो। ");
INSERT INTO bhu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","यीसु दुइठे चेला के हइ गुठेय के पठोथै, नगर हे जा, अउ तुमके अक्ठी मनसे, पानी के गघरी उठाउत मिलही, ओखर पाछू कढ जाबे। ");
INSERT INTO bhu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","अउ ऊ जउन घर हे जही, ऊ घर के मालिक लग कहबे, कि गुरू जानै चाहथै, कि ऊ पहुना के घर कछो हबै? मै अपन चेलन के संग ऊ तेउहार हे खाना खहुं ऊ कछो हबै। ");
INSERT INTO bhu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ऊ तुमके अक्ठी उप्पर सजरेहर कोठा दिखाही, उहां हम सब कुछ तइयार करबे। ");
INSERT INTO bhu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","चेला निकडके यरुसलेम सहर छो आथै, अउ जसना यीसु उनखर लग कहे रथै, ओसनेन पाथै, अउ तेउहार के भन्डारा तइयार करथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","जब सांझ हुइस ता यीसु बारहठे चेलन के संग आथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","जब चेला अउ यीसु के संग हे, बइठ के भात खाथै, ता ऊ कथै, “मै सही-सही कथो, कि जउन मोर संग खाथै, अकझन मोके पकडोही।” ");
INSERT INTO bhu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ऊ सगलू चेला मुरझा जथै, उन यीसु लग पूछथै, अउ अकझन कहे लागथै, “का ऊ मै तो नेहको?” ");
INSERT INTO bhu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","यीसु उनखर लग कथै, “ऊ बारहठे चेलन हे अकझन हबै, जउन मोर टठिया मसे हाथ डालके रोटी खथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","काखे मनसे कर टोरवा कर बारे हे जसना लिखवारे हबै, ऊ मरही, पय ऊ मनसे हे हाय, बैरिन के हाथ हे पकडोय जही कि ऊ मनसे के पइदा झइ होथै, ता ओखर निता निक्खा होतै।” ");
INSERT INTO bhu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","जब यीसु खात रहिस, ता ऊ रोटी लेथै, अउ आसीस मांग के अउ टोर के चेलन के देथै, अउ कथै, ला ई मोर देह आय। ");
INSERT INTO bhu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","यीसु खोरिया लेथै, अउ भगवान के धन्यबाद देथै, अउ उनही देथै अउ सगलू झन पीथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","अउ ऊ उनखर लग कथै, ई मोर ऊ खून आय, जउन बोहत मनसे के निता बहोय जही, जउन भगवान के टीमा हबै। ");
INSERT INTO bhu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","मै तुम्हर लग सही कथो, कि अंगूर कर रस ऊ रोज तक फेर कबहुन नेहको पीहुं, जब तक कि भगवान कर राज हे मै नबा अंगूर कर रस नेहको पीहुं। ");
INSERT INTO bhu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","भजन गाय के बाद हे, यीसु अउ ओखर चेला जैतून कर डोंगर छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","यीसु चेलन लग कथै, इहै रात लग तुम सब कउ मोके छांड के भाग जइहा, काखे लिखे हबै मै बरेदी के मारहूं, अउ गेडरा छिदिर-बिदिर हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","पय मोर जी उठे के बाद हे, तुम्हर लग आगू मै गलील इलाका छो जहुं। ");
INSERT INTO bhu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","पतरस ओखर लग कथै, भले सब कउ तोके धोखा दइहीं, पय मै धोखा नेहको देहुं। ");
INSERT INTO bhu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","यीसु पतरस लग कथै, मै सही कथो, आज के रात कुकडी दुइ बार बांसय के पहिले, तै तीन बार मोके मना करबे। ");
INSERT INTO bhu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","पय पतरस अउ जोर दइके कथै, हिम्मत के संग बोलथै, भले मोके तोर संग मरै का पडही, मै तोके मना नेहको करहुं, ओसनेन बातन के सगलू झन दोहराथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","फेरै यीसु अउ चेला गतसमनी नाम के अक्ठी जिघा रथै, उहां आथै अउ ऊ उनखर लग कथै, जब तक तुम इहां बइठा तब तक मै बिनती करके आथो। ");
INSERT INTO bhu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","पतरस, याकूब अउ यूहन्ना के यीसु अपन संग लइ जथै, ऊ अपन मन लग बोहत तंग अउ उदास रथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ऊ उनखर लग कथै, मोर मन बोहत दुखी हबै, अउ लागथै कि मोर परान निकड जही, तुम इछो रहा अउ जागत रहा। ");
INSERT INTO bhu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","चुटु दुरिहां जाय के यीसु भुंइ हे गिरके बिनती करै लागथै, अगर हुइ सकथै, ता ई दुख के टेम मोर उप्पर लग टर जाय। ");
INSERT INTO bhu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ऊ कथै, “हे बाफ, तोर लाने सगलू कुछु लिखडी होही, ई दुख के खोरवा मोर लग दुरिहां कर दे, तउभरमा मोर इक्छा नेहको, पय तोर इक्छा पूर होय।” ");
INSERT INTO bhu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","लउट के आथै ता, यीसु सब कउ के सोउत पाथै, अउ पतरस लग कथै, हे समोन तै सोथस? का अको घरी तुम मोर संग नेहको जाग सकथा? ");
INSERT INTO bhu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","जागत रहा, अउ बिनती करत रहा, कि तुम परिक्छा हे झइ पडा, आतमा तइयार हबै, पय जीवन ढिलवा हबै। ");
INSERT INTO bhu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","फेरै यीसु बिनती करै कढ जथै, अउ उहै बात के कथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","लउटके आथै, ता ऊ फेरै उनके सोउत पाथै, उनखर आंखी नींद हे रथै, अउ नेहको जानथै कि, काहिन जबाब दइ। ");
INSERT INTO bhu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","तीसर बार ऊ आथै, अउ उनखर लग कथै, “अबे तक तुम सोथा? अउ सुत्ताथा बस टेम आ गय हबै, देखा मनसे कर टोरवा पापिन के हाथ पकडोय जही। ");
INSERT INTO bhu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","उठा, इहां लग कढ जइ, देखा, मोके पकडोय बाले लिघ्घो हबै।” ");
INSERT INTO bhu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","यीसु ई बात के गुठेवत रथै, ता बारहठे चेलन मसे अक्ठी यहूदा नाम के चेला आथै, ओखर संग हे पुजारी अउ नियाव के गुरू अउ सियान के पल्ला लग अपन सेनन के पठोय रथै, उनखर हाथ हे तलबार अउ लठिया रथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ऊ पकडोय बाले उनके गुठेय रथै, कि अक्ठी इसारा देहुं, अउ ओही मै चूमहुं, उके पकडके सुरक्छित के संग हे लइ आनबे। ");
INSERT INTO bhu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ऊ आइस, अउ हरबी ओखर लिघ्घो जाय के कथै, “हे गुरू” अउ चूमीस। ");
INSERT INTO bhu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","तब उन यीसु के पकडिन अउ उके बांध देथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","पय उन मसे अक्ठी चेला अपन तलबार निकाडके, पुजारी के अक्ठी हरवाह के कान के काट देथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","यीसु उनखर लग कथै, का तुम चोरटा जानके मोके पकडै के निता, तलबार अउ लठिया लइके आय हबा? ");
INSERT INTO bhu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","बिनती भवन हे सबरोज मै सिखाय करथो, ता ऊ टेम तुम मोके नेहको पकडा, पय पवितर किताब के बात पूर होय। ");
INSERT INTO bhu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","तब सगलू चेला, उके छांड के उहां लग भाग जथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","अक्ठी जबान मनसे, जउन अपन देह हे पिछउरी ओढे रथै, यीसु के संग कढ जथै, पय कुछ मनसे जबान मनसेन के पकडै के चाहथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","पय ऊ मनसे अपन पिछउरी के छांड के कुटेल्ले आय जथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","यीसु के पुजारी के लिघ्घो लइ जथै, जिहां सगलू निक्खा नियाव के गुरू अउ सियान मनसे, अउ धरमगुरू अकजुट रथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पतरस दुरिहां लग चले आथै, ऊ पुजारी के अंगना के भित्तर तक जथै, अउ सिपाही के संग बइठ के आगी तापय लागथै ");
INSERT INTO bhu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","पुजारी अउ यहूदियन के दरबार हे, यीसु के मरे के सजा सुनय के निता गवाही के निता ढूंढथै, पय नेहको मिलथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","बोहत मनसे ओखर पल्ला झूठी गवाह देथै, पय उनखर गवाह नेहको मेराथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","तब कुछ मनसे ठाड हुइके, यीसु के पल्ला झूठी गवाही देयत कथै, ");
INSERT INTO bhu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","हम यीसु के ई कहत सुनै रहन, मै ई हाथ के बनाय हर मन्दिर के गिरा देहों, अउ तीन रोज हे दूसर बनाय देहुं, जउन हाथ लग नेहको बने होही। ");
INSERT INTO bhu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","तउभरमा उनखर गवाह नेहको मेराथै, ");
INSERT INTO bhu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","तब पुजारी ठाढ हुइके यीसु लग पूछथै, तोर खिलाप हे काहिन गवाही देथै? तै काखे जबाब नेहको देथस? ");
INSERT INTO bhu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","यीसु चुप्पे रथै, पुजारी फेरै लग पूछथै, “का तै ऊ भगवान धन्य के टोरवा मसीह हबस?” ");
INSERT INTO bhu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","यीसु कथै, “हे हव, अउ तुम मनसे कर टोरवा के सगलू सक्ति के संग, स्वरग अउ बादर के संग आउत देखिहा।” ");
INSERT INTO bhu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","तब पुजारी अपन बन्डी के चीरथै, अउ कथै, अब हमके कउनो गवाहन के जरूरत नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","तुम ई भगवान के बुराई सुनै हबा, ता तुम काहिन सोचथा? ऊ सगलू मनसे यीसु के कथै, कि ई मरै के सजा के लायक हबै। ");
INSERT INTO bhu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","कुछ मनसे यीसु के उप्पर थूकै लागथै, कुछ मनसे ओखर सकल के ढाप के मारथै, अउ कथै, आगू कर बात गुठे अउ सिपाही उके चउथेरा मारथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","जब पतरस तरी के अंगना छो रथै, ता पुजारी के अक्ठी हरवाहिन मसे आथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","पतरस के आगी तापत देखथै, ऊ धियान लग देखथै, ता कहै लागथै, “तहु यीसु नासरी के संग रथस।” ");
INSERT INTO bhu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","मना करत पतरस कथै, तै का गुठेमै चाहथस, मोके कुछ समझ हे नेहको आथै, जब ऊ दूरा लग बाहर छो आ जथै, तब कुकडी बांसथै। ");
INSERT INTO bhu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ऊ हरवाहिन उके देखके जउन ओखर लिघ्घो ठाढे रथै, फेरै कहे लागथै, ई उनखर मसे अक्ठी हबै। ");
INSERT INTO bhu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","पय पतरस फेरै मना कर देथै, चुटु टेम के बाद हे, उन जउन ठाढे रथै, तब फेरै ओखर लग कथै, “सही तै उन मसे अक्ठी हबस, तै गलीली हबस।” ");
INSERT INTO bhu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","पय ऊ किरिया खाय के कथै, जउन मनसे के बारे हे तुम कथा, उके मै नेहको जानथो। ");
INSERT INTO bhu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","तब दूसर बार कुकडी बांसथै, तब पतरस के ऊ बात सुरता आथै, जउन यीसु कहे रथै, एखर पहिले कि कुकडी दुइ बार बांसही, तै तीन बार मोके मना करबे, ई बात के सोचके पतरस सिसक-सिसक के रोमै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","बिहन्ने पुजारी, सियान, नियाव के गुरू अउ यहूदियन के दरबार सलाह करके यीसु के बंधुवाय के लइ जाय के पिलातुस राजा के हाथ हे सउप देथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पिलातुस ओखर लग पूछथै, “का तुम यहूदी के राजा हवस?” ऊ जबाब देथै, “असना तहिन कथस।” ");
INSERT INTO bhu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","पुजारी बोहत बातन लग यीसु के उप्पर दोस लगाथै, ");
INSERT INTO bhu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पिलातुस फिरै पूछथै, “काखे जबाब नेहको देथस, देखा, तोर उप्पर हे काहिन दोस लगाथै।” ");
INSERT INTO bhu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","फेरै यीसु जबाब नेहको देथै, इहैनिता पिलातुस बोहत चकराय जथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","तेउहार के टेम पिलातुस उन मनसेन के निता कउनो अक्ठी जेलर के छांडथै, जेही उन चाहथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","अक्ठी जेलर जउन बरअब्बा नाम के रथै, अपन संगी बलवइया के संग बन्द रथै, जउन बलवा हे खून करै रथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","जसना पिलातुस मनसेन के निता करै करथै, ओसनेन मनसे मांग करै लागथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पिलातुस कथै, काहिन तुम चाहथा, कि यहूदी के राजा के तुम्हर लाने छांड देया? ");
INSERT INTO bhu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","पिलातुस के पता रथै, कि पुजारी डाह के कारन यीसु के मोर हाथ हे सउपे हबै। ");
INSERT INTO bhu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","पय पुजारी भीडन के भडकाय के उन पिलातुस लग कथै, कि यीसु के बदले बरअब्बा के छांड देया। ");
INSERT INTO bhu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ई सुनके पिलातुस राजा फिरै उनखर लग पूछथै, जउन तुम यहूदी के राजा कथा? “तुम काहिन चाहथा कि मै ओखर संग करव?” ");
INSERT INTO bhu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","फेरै लग ऊ चिरलाथै, “उके क्रूस हे टंगाबा।” ");
INSERT INTO bhu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पय पिलातुस उनखर लग पूछथै, ऊ काहिन गुनाह करै हबै? अउ मनसे बोहत लग चिरलाय लागथै, “उके क्रूस हे टंगाबा।” ");
INSERT INTO bhu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","तब भीड के मगन करै के निता पिलातुस बरअब्बा के छांड देथै, अउ यीसु के कोडा लगवाय के क्रूस हे टंगामै के निता सउप देथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","सेना यीसु के राज किला घर के भित्तर के अंगना हे लइ जथै, उन मनसे सगलू रोमी सिपाही के बुलवा लेथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","उन मनसे उके मलमल के बन्डी ओढथै, अउ कांटा के मुकुट बनाय के ओखर मुन्डी हे मडाथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","अउ हइ कहिके उके नमस्ते करै लागथै, अउ मजाक उडाउत कथै, हे यहूदी के राजा, लम्बा टेम तक जिन्दा रहै। ");
INSERT INTO bhu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","उन मनसे यीसु के मुन्डी हे डंडा मारथै थूकथै, अउ ओखर आगू निहुर के परनाम करथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","मजाक उडाय के बाद हे, उन मनसेन यीसु के मलमल के बन्डी के उतार के, फेरै ओखरै बन्डी के ओढाय के क्रूस हे टंगामै के निता बाहिर छो लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","उन मनसे अक्ठी समोन कुरेनी नाम के मनसे रथै, जउन सिकन्दर अउ रूफुस मनसे के दादा रथै, जउन गांव लग आथै, उके पकडके मजबूर करथै, अउ क्रूस उठाय के निता बोलथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","उके गुलगुता नाम के जिघा हे लइ जथै, जेखर मतलब होथै, खोपडी के जिघा होथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","उन मनसे यीसु के गन्धरस मिलाय हर अंगूर के रस पिये के देथै, पय ऊ पिये लग बरज देथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","जब यीसु के क्रूस हे टांग देथै, अउ ओखर बन्डी के चिट्ठी डालके अपन हे बांट लेथै, कि देखे केही का मिलही। ");
INSERT INTO bhu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","बिहन्ने कर टेम नव बजे उन मनसे उके क्रूस हे टंगाइन। ");
INSERT INTO bhu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","उके हइ अरोप लगाथै, कि यहूदी के राजा हबै। ");
INSERT INTO bhu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","दुइठे चोरटा जउन यीसु के संग क्रूस हे टंगाय जथै, अक्ठी के दहिना पल्ला अउ दूसर के टेटरा पल्ला हे टांग देथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","तब पवितर किताब के हइ बचन, यीसु के पापन के संग गिने जही, हइ बचन पूर होथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ऊ गली लग गुजरे बाले मनसे अपन मूंड के डोला-डोलाय के यीसु के बुराई करथै, अरे हइ देखा, मन्दिर के गिरामै बाले अउ तीसर रोज हे बनाय बाले। ");
INSERT INTO bhu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","क्रूस लग उतर के खुद के बचाय ले। ");
INSERT INTO bhu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","इहैमेर लग खास पुजारी अउ नियाव के गुरू के संग मिलके अपन हे मजाक उडाथै, उहां ता दूसर के बचाय हबै, पय खुद के नेहको बचा सकथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","अब इस्राएल के राजा अउ मसीह क्रूस लग अभिनैन उतर के आ, ता हम देखी अउ बिस्वास करी, जिनही यीसु के संग टंगाय रथै, उन ओखर निन्दा करथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","दुपहरी हे देस के पुरा इलाका हे अंधियार छाय जथै, जउन दुपहरी के तीन बजे तक छाय रथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","दुपहरी के तीसर टेम यीसु बोहत आरो हे चिरलायके कथै, इलोई-इलोई लमा सबक्तनी? एखर मतलब हबै, हे मोर भगवान, हे मोर भगवान, तै मोके काखे छांड दय हबस? ");
INSERT INTO bhu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","उहां ठाढे मनसे ई सुनके कथै, देखा, ऊ एलिय्याह के बुलाथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","उन मसे अक्ठी दउरके इस्पंज के सिरका हे डुबोथै, अउ डंडा हे रखके उके चुसाथै, अउ कथै रुक जा देख, एलिय्याह उके क्रूस लग उतारै के निता आथै कि नेहको, ");
INSERT INTO bhu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","तब यीसु बोहत आरो लग चिरलायके अपन परान छांड देथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","मन्दिर के परदा, उप्पर लग तरी तक दुइ खुन्डा हे फट जथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","जब उहां आगू ठाढ चवकीदार यीसु के हइ मेर चिरलात अउ जान देत सुनथै, ता कथै, ई मनसे सही हे हइ भगवान कर टोरवा रहिस। ");
INSERT INTO bhu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","कुछ दुरिहां ठाढ डउकी देखथै, उनखर हे मरियम मगदलीनी योसेस अउ याकूब के दाय मरियम अउ सलोमी रथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","जब यीसु गलील नगर छो रथै, तब लग ई ओखर संग रहिके ओखर सेबा करे करथै, एखर सिबाय यरुसलेम देस हे आय बाले दूसर डउकियो रथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","जब सांझ हुइ गइस ता इहैनिता कि तइयारी के रोज रथै, जउन पवितर रोज के पहिले अक्ठी रोज होथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","अरिमतियाह नगर के रहै बाले यूसुफ आथै, जउन दरबार के सदस्य रथै, ऊ भगवान कर राज के ओरगथै, ऊ बोहत हिम्मत के संग पिलातुस के लिघ्घो जथै, अउ यीसु के लोथ के मांगथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","पिलातुस राजा चकराय जथै, कि यीसु मर चुके हबै, उहां चवकीदार के बुलाके पूछथै कि उके मरे केतका देरी हुइ गय हबै? ");
INSERT INTO bhu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","चवकीदार लग सगलू पता लगाय के बाद, पिलातुस राजा यीसु के लोथ यूसुफ के देबाय देथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","युसुफ यीसु के लोथ के उतार के अपन संग लाथै, अउ रेसम के पिछउरी हे लपेटीस अउ पथरा के खोदके बनाय गय मरघटी हे मंडाय देथै, अउ माडा के दूरा हे पथरा ढनगाय देथै। ");
INSERT INTO bhu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम मगदलीनी अउ योसेस के दाय देखत रहिन, कि ओखर लोथ के कछो मंडाय हबै। ");
INSERT INTO bhu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","जब सुस्ताय कर रोज बढाय जथै, ता मरियम मगदलीनी अउ याकूब के दाय मरियम अउ सलोमी महकनी तेल खरीदिस, ता ऊ यीसु के लोथ हे लगामै निता। ");
INSERT INTO bhu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","बेरा निकडे बाले रथै, कि बड्डे बिहन्ने हप्ता के पहिले रोज, उन मरघटी हे पहुंचथै। ");
INSERT INTO bhu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","अपन हे कहै लगथै, मरघटी हे घुसै के दूरा के पथरा के कउन टरकाही? ");
INSERT INTO bhu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","जब उहां पहुंच के देखथै, कि पथरा जउन बोहत बड्डे बड रथै, पहिले लग ढलगे हबै। ");
INSERT INTO bhu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","मरघटी के भित्तर गइन ता, उन अक्ठी जबान के देखथै, जउन लम्बा रथै, अउ चरका खुरथा पइजामा ओढे खउनी पल्ला बइठे हर देखिन, अउ बोहत चकरा जथै। ");
INSERT INTO bhu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ऊ उनखर लग कथै, झइ चकित होबा, तुम यीसु नासरी के जउन क्रूस हे चढाय गय हबै, उके ढूंढथा, ऊ जी उठे हबै, हइ जिघा के देखा, जिहां ओही मडाय रथै। ");
INSERT INTO bhu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","पय तुम जा, अउ ओखर चेला अउ पतरस लग गुठे, कि ऊ तुम्हर लग आगू गलील नगर छो पहुंचही, जसना ऊ तुम्हर लग गुठे रहै, तुम उके उहै छो देखिहा। ");
INSERT INTO bhu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","हरबी मरियम मगदलीनी मरघटी लग निकडके ऊ दउरे जथै, काखे ऊ बोहत चकित रथै, उन कउनो लग कुछु नेहको कथै, काखे कि उन डेराय रहिन। ");
INSERT INTO bhu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","हप्ता के पहिले बिहन्ने रोज जिन्दा होय के बाद हे, यीसु अगुन्नै मरियम मगदलीनी के दिखाई देथै, जेहमा लग यीसु सातठे भुतवा के निकाडे रथै। ");
INSERT INTO bhu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","जउन मनसे यीसु के संग रथै, ऊ रोउत रहिन अउ दुख हे पडे रथै, उनही मरियम मगदलीनी जाय के गुठेथै। ");
INSERT INTO bhu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","जब उनही पता चलथै, कि यीसु जिन्दा हुइ गय हबै, अउ मनसे ओही देखे रथै, तउभरमा मरियम के उप्पर बिस्वास नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","एखर बाद यीसु अलगे मेर लग दुइठे चेलन के दिखाई देथै, जउन गांव के पल्ला जथै। ");
INSERT INTO bhu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","उन जाय के बाकी मनसे के खबर गुठेथै, पय उनो बिस्वास नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","गेराठे चेला जब भात खाये के बइठत रहै, ता यीसु अचानक आथै, अउ उनखर अबिस्वास अउ मन के कठोर होय लग बिस्वास नेहको करथै, ता ऊ गधारिस इहैनिता कि ओखर जी उठे के बाद देखेबाले के बात पय उन बिस्वास नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","यीसु उनखर कथै, दुनिया हे जाय के सगलू मनसेन के संदेस के परचार करा। ");
INSERT INTO bhu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","जउन बिस्वास करथै, अउ बतिस्मा लेथै, उहै मुकति पइहिन, पय जउन बिस्वास नेहको करथै, ऊ मनसे दोसी ठहरहिन। ");
INSERT INTO bhu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","जउन मनसे बिस्वास करथै, ऊ ई चिन्हा होही ऊ मोर नाम लग भुतवा के निकाडही, अउ नबा-नबा बोली बोलहिन। ");
INSERT INTO bhu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","अगर सपुवा उनखर हाथ हे लपट जाय अउ कउ उनके जहर दइदे, तउ उनके नुसकान नेहको होही, ऊ मनसे नंगहा के उप्पर हाथ मडाही, अउ उन निक्खा हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","उन मनसेन लग बात करथै, परभु यीसु के स्वरग छो उठाय लइ जथै, अउ तब ऊ भगवान के दहिना पल्ला बइठ गइस। ");
INSERT INTO bhu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","अउ चेला उहां लग निकडके हर जिघा परचार करथै, अउ परभु उनखर संग चिन्हा अउ चकित के दवारा संग होथै, बचन के मजबूत करथै। ओसनेन होय।");
INSERT INTO bhu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","कइन झन, मनसे उन घटना के लिखके अक्ठी जिघा करै के काम करे हबै, जउन हमर बीच हे घटिस। ");
INSERT INTO bhu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","उहै बात हमके उन मनसेन के दवारा गुठे गय रथै, जिनही सुरुवात लग घटत देखथै जउन भगवान के बचन के सेबक रहिन। ");
INSERT INTO bhu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","मै सुरु लग सब बातन के सचेत लग सिखे हबो, इहैनिता हे महोदय थियुफिलुस मोके तोर निता उनखर कतार बिबरन लिखे के सही जान पडिस। ");
INSERT INTO bhu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","जेखर लग तुम उन बातन के जरूर जान लेया कि जउन तुमके सिखाय गय हबै ऊ केतका मजबूत हबै। ");
INSERT INTO bhu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","उन रोज हे यहूदिया राजा हेरोदेस के सासन काल हे अबिय्याह दल के अक्ठी पुजारी रथै, जेखर नाम जकरयाह रथै, ओखर डउकी के नाम इलीसिबा रथै, जउन हारुन के घराना के रथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","उन दुनो भगवान के नजर हे धरमी मनसे रथै, उन परभु के सगलू आदेसन के अउ नियम के पालन हे निरदोस रथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","उनखर कोनो लरका नेहको रथै, काखे इलीसिबा बांझ रथै अउ उन दुनो डोकराय जथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","जब जकरयाह के ठहराय के क्रम लग अपन समुदाय के संग भगवान के आगू पुजारी के काम करथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ता पुजारी के परम्परा के जसना परची डालके उके चुने गइस, कि ऊ परभु के मन्दिर हे जायके धूप जलामै। ");
INSERT INTO bhu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","जब दिया जलामै के टेम आइस, ता बाहिर अक्ठी जिघा मनसे बिनती करथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","उहै टेम जकरयाह के आगू परभु के स्वरगदूत उके दिया के बेदी के दहिना पल्ला दिखाई देथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","जकरयाह स्वरगदूत के देखके चकराय गइस अउ डेराय गइस। ");
INSERT INTO bhu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","फेर स्वरगदूत जकरयाह लग कथै, झइ डेराबा काखे कि तोर पराथना सुन लय गय हबै, इहैनिता तोर डउकी इलीसिबा अक्ठी टोरवा के पइदा करी अउ तै ओखर नाम यूहन्ना रखबे। ");
INSERT INTO bhu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ऊ तोके मगन अउ खुसी दइ अउ ओखर पइदा लग अउ बोहत लग मनसे खुसी हुइहिन। ");
INSERT INTO bhu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","काखे ऊ परभु के नजर हे महान होही, ऊ कबहुन ऊ दाखरस अउ दारू नेहको पीहीं, अपन पइदाइस काल लग ऊ पवितर आतमा लग भरपूर होही। ");
INSERT INTO bhu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ऊ इस्राएली के बोहत लग मनसेन के उनखर परभु भगवान के पल्ला लउटामै के उतसुक करी। ");
INSERT INTO bhu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ऊ एलिय्याह के सक्ति अउ आतमा हे स्थित होय परभु के आगू-आगू चलही, ऊ बाफन के मन उनखर लरकन के पल्ला वापिस मोड दइ अउ आदेस नेहको माने बालेन के असना सोच के पल्ला उतसाहित करी, जेखर लग उन धरमी के जसना सोच रखही, हइ सब उन मनसेन के परभु के खातिर तइयार करै के निता करी। ");
INSERT INTO bhu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","तब जकरयाह स्वरगदूत लग कथै, मै हइ कसके जनहुं कि हइ सही हबै? काखे मै अक्ठी डोकरा मनसे हव अउ मोर डउकी डोकरी हुइ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","तब स्वरगदूत जबाब देत कथै, “मै जिब्राईल हव, मै उहै हव, जउन भगवान के आगू ठाड रथो, मोके तोर लग बात करै के अउ हइ संदेस के गुठेमै के पठोय गय हबो। ");
INSERT INTO bhu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","अउ देख काखे तै मोर सब्दन हे, जउन निस्चित टेम आमै हे सही सिध्द होही, बिस्वास नेहको करे इहैनिता तै बउरा हुइ जइहे अउ ऊ रोज तक नेहको बोल पइहे जब तक हइ पूर नेहको हुइ जाय।” ");
INSERT INTO bhu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","मन्दिर के बाहिर मनसे जकरयाह के ओरगथै अउ उन चकित होथै, कि जकरयाह एतका देर बिनती भवन हे काखे रुके हबै। ");
INSERT INTO bhu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","जब जकरयाह बाहिर आइस ता उनखर लग बोल नेहको सकिस, ता उन समझ गइन कि ऊ मन्दिर हे कउनो दरसन देखे हबै, ऊ उनखर लग हाथ हे इसारा करत रथै अउ मुंह लग बोल नेहको सकिस। ");
INSERT INTO bhu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","अउ फेर असना हुइस कि जब ओखर सेबा काल के टेम पूर हुइ गइस, ता जकरयाह वापिस अपन घर छो लउट गइस। ");
INSERT INTO bhu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","कुछ रोज बाद ओखर डउकी इलीसिबा लादा हे हुइस, अउ हइ कहत खुद के पांच महिना तक लुकोय रखिस। ");
INSERT INTO bhu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","परभु समाज हे मोर लाज दुरिहां करै के निता मोर मदत करे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","छठमा महिना स्वरगदूत जिब्राईल भगवान के पल्ला लग, गलील परदेस नासरत नामक सहर हे अक्ठी कुमारी के लिघ्घो पठोय गइस। ");
INSERT INTO bhu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","अक्ठी कुमारी के लिघ्घो पठोइस जेखर ओली राजा दाऊद के घराना यूसुफ नाम के डउका लग होथै, ऊ कुमारी के नाम मरियम रथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","जिब्राईल स्वरगदूत ओखर लिघ्घो आइस अउ बोलिस, “तोर हे किरपा होय हबै, तोर जय होय परभु तोर संग हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","मरियम हइ बात के सुनके बोहत चकित हुइ गइस अउ मन हे सोचै लग जथै, नमस्ते के मतलब काहिन हुइ सकथै? ");
INSERT INTO bhu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","स्वरगदूत ओखर लग कथै, मरियम झइ डर, भगवान के अनुगरह किरपा तोर हे होय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","सुन तै लादा हे होबे अउ अक्ठी टोरवा के पइदा करिहे अउ तै ओखर नाम यीसु रखबे। ");
INSERT INTO bhu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ऊ बडा होही अउ परम परधान भगवान कर टोरवा कहाही अउ परभु ओखर बाफ दाऊद के राजगद्दी उके दइ। ");
INSERT INTO bhu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ऊ सबरोज तक याकूब के घराना हे राज करी अउ ओखर राज के अंत कबहुन खतम नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरियम स्वरगदूत लग कथै, “हइ कसके सम्भव होही? काखे मै तो कुमारी हव।” ");
INSERT INTO bhu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","स्वरगदूत जबाब देथै, “तोर लिघ्घो पवितर आतमा आही अउ परम परधान के सक्ति तोके अपन छाया हे लइ लेही, हइमेर ऊ पइदा लय बाले पवितर लरका भगवान कर टोरवा कहाही। ");
INSERT INTO bhu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","अउ देखबे तोर बेहन इलीसिबा के डोकरी हे टोरवा होय बाले हबै अउ ओखर लादा हे छय माह के हबै, मनसे कथै कि ऊ बांझ हबै। ");
INSERT INTO bhu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","काखे जउन बचन भगवान के निता कुछु कठिन नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियम कथै, देख मै परभु के हरवाहिन हव, तोर बचन के जसना होय तब ऊ स्वरगदूत ओखर लिघ्घो लग कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","मरियम हरबी यहूदा परदेस के डोंगर इलाका छो अक्ठी सहर हे कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","जब मरियम जकरयाह के घर छो पहुंचथै अउ इलीसिबा के नमस्ते करिस। ");
INSERT INTO bhu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","जब इलीसिबा मरियम के नमस्ते के सुनिस, ता लरका ओखर लादा हे उछल पडिस अउ इलीसिबा पवितर आतमा लग भरपूर हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","इलीसिबा बोहत आरो लग कथै, “मरियम तै सगलू डउकिन हे धन्य हबस अउ जउन लरका के तै पइदा करही ऊ धन्य हबै। ");
INSERT INTO bhu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","इलीसिबा कथै, मोके हइ किरपा कछो लग हुइस, कि मोर परभु के दाय मरियम मोर लिघ्घो आइस? ");
INSERT INTO bhu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","अउ देख जसनेन तोर नमस्ते के आरो मोर कान तक पहुंचिस, ता मोर लादा के लरका खुसी लग उछल पडिस। ");
INSERT INTO bhu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","तै धन्य हबस जउन हइ बिस्वास करिन, कि परभु जउन कुछ बात गुठे हबै ऊ पूर हुइके रही।” ");
INSERT INTO bhu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","मरियम कथै, मोर परान परभु के भजन करथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","मोर आतमा परभु के महिमा करथै, मोर आतमा मोर मुकति करै बाले भगवान हे मगन हबै। ");
INSERT INTO bhu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ऊ अपन दीन हरवाहिन के सुधि लइस, अब लग पुरखा दर पुरखा मोके धन्य कइहीं। ");
INSERT INTO bhu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","काखे सक्तिसाली भगवान मोर निता बडा-बडा काम करै हबै, पवितर हबै ओखर नाम ");
INSERT INTO bhu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","जउन मनसे भगवान लग डरथै, ता उनखर हे अक्ठी पीढी लग दूसर पीढी तक दया करथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","भगवान अपन हाथ के सक्ति दिखाइस, ऊ घमंडिन मनसेन के छिदिर-बिदिर कर दइस। ");
INSERT INTO bhu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","भगवान राजन के उनखर राजगद्दी लग तरी उतार दइस, अउ बिनम्र मनसेन के उप्पर उठाइस। ");
INSERT INTO bhu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ऊ भुखहन के बढिहा चीजन लग टुल्ल करिस, अउ धनिन के छूछे हाथ लउटा दइस। ");
INSERT INTO bhu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ऊ अपन दया के सुरता करके, अपन सेबक इस्राएल के संभालिस। ");
INSERT INTO bhu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","जसना टीमा भगवान हमर सियानन लग करे रथै, कि अब्राहम, अउ उनखर लरका के परति ओखर दया सबरोज बने रही। ");
INSERT INTO bhu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम इलीसिबा के संग लगभग तीसर महिना तक ओखर संग रहिस, अउ फेर मरियम अपन घर नासरत सहर छो लउट गइस। ");
INSERT INTO bhu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","इलीसिबा के प्रसव पीरा के टेम पूर हुइस, अउ ऊ अक्ठी टोरवा के पइदा करिस। ");
INSERT INTO bhu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","जब इलीसिबा के परोसी अउ ओखर परवार के मनसे हइ बात सुनिन, कि परभु ओखर हे बडा दया करे हबै, तब उन ओखर संग खुसी बनाथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","आठै रोज के बाद इलीसिबा अपन लरका के बिनती भवन हे ओखर सुध्दिकरन खतना करामै के निता लइ गइस, अउ ओखर नाम बाफ के नाम हे जकरयाह रखै चाहथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","पय लरका के दाय कथै, “नेहको, एखर नाम यूहन्ना रखे जही।” ");
INSERT INTO bhu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","इलीसिबा कथै, रिस्तेदार हे हइ नाम तो कउनोन के नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ता इलीसिबा ओखर बाफ जकरयाह के इसारा करके पूछथै, तै एखर का नाम धरै चाहथस? ");
INSERT INTO bhu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","जकरयाह लिखे के निता सिलेट मांगथै अउ लिख देथै, “एखर नाम यूहन्ना हबै” हइ देखके सगलू मनसे चकित हे पड गइन। ");
INSERT INTO bhu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","उहै टेम जकरयाह के मुंह अउ जीभ के बन्धन खुल गइस, अउ ऊ भगवान के धन्यबाद करै लगिस। ");
INSERT INTO bhu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","सगलू परोसिन डेराय गइन, अउ यहूदिया परदेस के डोंगर इलाका छो एखर बात अउ चरचा चउगिरदा बगर गइस। ");
INSERT INTO bhu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","अउ उहां के सगलू सुनै बाले मनसे अपन मन हे सोचके कथै, पता नेहको, “हइ लरका का बनी?” काखे परभु के हाथ ओखर हे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","तब यूहन्ना के बाफ जकरयाह पवितर आतमा लग भर जथै, अउ हइ कहत आगू कर बातन के गुठेथै, ");
INSERT INTO bhu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","धन्य हबै परभु, इस्राएल के भगवान ऊ अपन परजा के सुधि लय हबै, अउ ओखर मुकति करे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","भगवान अपन सेबक दाऊद के घराना हे हमर निता अक्ठी मुकति, करै बाले पइदा करिस। ");
INSERT INTO bhu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","जसना कि ऊ बोहत पहिलेन अपन पवितर ग्यानी मनसे के दवारा टीमा करे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","कि ऊ हमर सतरू अउ हमर बैरिन लग अउ जउन हमर लग घिनाथै, उनखर लग हमके मुकति दिलाय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","अउ अपन पवितर टीमा के सुरता, करके हमर पुरखन हे दया करी। ");
INSERT INTO bhu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ऊ किरिया खाय के हमर बाफ अब्राहम, लग गुठे रहिस। ");
INSERT INTO bhu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","कि ऊ हइ देही, कि अपन बैरी के हाथ लग छुटकर। ");
INSERT INTO bhu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","अउ अपन जीवन भर हर रोज भगवान कर आगू हम पवितरता अउ धरमी मनसे बनके ओखर सेबा कर सकि। ");
INSERT INTO bhu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“हे लरका, अब तै परम परधान के ग्यानी मनसे कहइहे, काखे तै ओखर गली तइयार करै के निता, परभु के आगू-आगू चलहे। ");
INSERT INTO bhu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","तै भगवान के मनसे के उनखर पापन के छमा के दवारा, मुकति के ग्यान दइहे। ");
INSERT INTO bhu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","हमर भगवान के बडी दया के कारन, हमके उप्पर स्वरग लग उजियार मिलही। ");
INSERT INTO bhu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","जेखर लग ऊ अंधियार अउ मिरतू के छांय हे बइठै बालेन के उजियार मिलै, कि एखर दवारा सान्ति के गली के दिसा मिलै।” ");
INSERT INTO bhu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","लरका यूहन्ना बढत गइस, अउ आतमिक रूप लग बलवान होत गइस इस्राएल के आगू परगट होय के रोज तक निरजन जिघा छो रथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","उन रोजन हे अवगुस्तुस कैसर राजा के पल्ला लग अक्ठी आदेस निकारिस, कि सगलू रोमी दुनिया के नाम लिखवामै जाय। ");
INSERT INTO bhu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","हइ पहली नाम लिखवाई रथै, हइ उन रोज होय रथै जब सीरिया के राजपाल क्विरिनियुस राजा रथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","सगलू मनसे अपन नाम लिखवामै के निता अपन-अपन सहर हे गइन। ");
INSERT INTO bhu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","यूसुफ दाऊद के घराना अउ बिरादरी के रथै, इहैनिता गलील परदेस के नासरत सहर लग यहूदिया परदेस हे दाऊद के सहर बैतलहम छो गइस। ");
INSERT INTO bhu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","कि यूसुफ अपन मंगेतर मरियम के संग जउन लादा हे रथै नाम लिखवामै जथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","जब ऊ उहां रथै, तब मरियम के लरका पइदा होय के टेम आय गइस। ");
INSERT INTO bhu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","अउ मरियम अपन पहिले टोरवा के पइदा करिस, अउ ओही फरिया हे लपेट के सार हे सोबाय देथै, काखे रुकै के निता कउनो जिघा नेहको मिलथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","यहूदिया परदेस हे बरेदिया रात के टेम मइदान हे अपन गडरन के ताकथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","उहै टेम परभु के अक्ठी स्वरगदूत बरेदियन के लिघ्घो आथै, अउ परभु के तेज उनखर चारो पल्ला चमकथै, अउ उन बोहत डेराय जथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","स्वरगदूत बरेदियन लग कथै, झइ डर देखिहा मै तुमही बडा खुसी के संदेस सुनाथों, जउन सगलू मनसेन के निता होही। ");
INSERT INTO bhu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","काखे आज दाऊद के सहर हे तुम्हर निता अक्ठी मुकति करै बाले पइदा लय हबै, इहै परभु मसीह हबै। ");
INSERT INTO bhu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ओखर चिन्हारी के निसानी हइ हबै, कि तुम अक्ठी लरका के फरिया हे लपटरे हर अउ सार हे सोउत पइहा। ");
INSERT INTO bhu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","उहै टेम अचानक स्वरगदूत के स्वरगी सेना के बिसाल समूह दिखाई देथै, जउन हइ कहत भगवान के भजन करथै, ");
INSERT INTO bhu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","सबले ऊंच स्वरग हे भगवान कर महिमा, अउ भुंइ हे उन मनसेन के सान्ति मिलै, जिनखर लग ऊ मगन हबै। ");
INSERT INTO bhu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","जब स्वरगदूत बरेदी लग बिदा हुइके स्वरग छो कढ जथै, ता बरेदिया अक्ठी दूसर लग हइ कथै, आबा हम बैतलहम सहर छो जाय के, ई बात के जउन हमार संग होय हबै, अउ परभु हमके उजागर करे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","इहैनिता बरेदी हरबी चल दिहिन, अउ उहां जायके उन मरियम अउ यूसुफ के पाइन, अउ देखिन कि लरका सार हे सोय हर हबै। ");
INSERT INTO bhu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","बरेदिया जब उके देखथै, ता हइ लरका के बारे हे जउन संदेस उनके दय गय रथै, उके उन सब के बताय दइन। ");
INSERT INTO bhu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","सगलू सुनै बाले मनसे बरेदिन के बातन हे चकित हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","पय मरियम ई सगलू बात के अपन मन हे सम्हार के रखिस, अउ सोच बिचार करत रथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","जसना बरेदिन लग कहे गय रथै, ओसनेन उन सगलू कुछ देखथै, अउ सुनथै, इहैनिता उन भगवान के बडाई करत लउट गइन। ");
INSERT INTO bhu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","अउ जब लरका के सुध्दिकरन खतना के अठमा रोज आइस ता ओखर नाम यीसु रखे गइस, उके हइ नाम मरियम के लादा हे आय लग पहिलेन स्वरगदूत दवारा दय गय रथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","जब मूसा कर नियम के जसना ओखर सुध्दिकरन के रोज पूर हुइस, ता मरियम अउ यूसुफ लरका के यरुसलेम सहर लइ गइन कि उके परभु के अरपित करै। ");
INSERT INTO bhu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","जसना कि परभु के नियम के किताब हे लिखररे हबै, पहिले लरका परभु के निता भेंट करे जाय। ");
INSERT INTO bhu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","अउ परभु के नियम कथै, अक्ठी जोडी परेवा या परेवा के दुइठे छउना लायके बलिदान करै, इहैनिता नियम के अनुसार बलि चढामै लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ऊ टेम यरुसलेम सहर हे समोन नाम के अक्ठी धरमी अउ भजन करै बाले मनसे रथै, ऊ इस्राएल के सान्ति के इन्तजार हे रथै, अउ पवितर आतमा ओखर संग रथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","अउ उके पवितर आतमा लग हइ परकासन मिले रथै, कि जब तक ऊ परभु मसीह के नेहको देख लइ, तब तक ओखर मिरतू नेहको हुइ। ");
INSERT INTO bhu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ऊ पवितर आतमा के सिखाय लग मन्दिर छो आथै, अउ ओखर दाय बाफ लरका यीसु के निता नियम पूर करै के उदेस्य लग उके बिनती भवन के भित्तर छो लानथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ता समोन यीसु के अपन कोरा हे लइस, अउ भगवान के धन्यबाद करके कथै, ");
INSERT INTO bhu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","हे मालिक तै अपन बात के जसना, अपन हरवाह के सान्ति के संग बिदा कर। ");
INSERT INTO bhu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","काखे मोर आंखी मुकति के देख लय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","जेही तैहां सगलू देस के मनसेन के निता तइयार करे हबस। ");
INSERT INTO bhu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","हइ गैर यहूदी के परकास देय के निता उजियार, अउ तोर खास मनसे इस्राएल के निता महिमा होय। ");
INSERT INTO bhu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","मरियम अउ यूसुफ अपन टोरवा के बारे हे हइ बातन के सुनके चकित हे पड गइन। ");
INSERT INTO bhu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","समोन उके आसीस दइस, अउ लरका के दाय मरियम लग हइ कथै, देखबे हइ लरका अक्ठी असना चिन्हा हबै जेखर बिरोध करहिन, एखरै कारन इस्राएल हे बोहत झन के पतन अउ उत्थान हुइ। ");
INSERT INTO bhu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","अउ हइ तलबार तोर परान के आर पार छेद दइ, हइमेर बोहत झन के बिचार परगट हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","हन्ना नाम के अक्ठी ग्यानी मनसे रथै, जउन आसेर के बिरादरी फनूएल के बिटिया रथै, अउ बोहत बुढिया रथै, अउ काज होये के बाद अपन डउका के संग सिबाय सात साल रथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","अउ फेर बिधवा हुइ गइस, अब ऊ चवरासी साल के रथै, ऊ बिनती भवन लग बाहिर नेहको जथै अउ उपास अउ पराथना करत दिन रात भगवान के सेबा हे लगे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","हन्ना उहै टेम आयके भगवान के धन्यबाद देय लगथै, अउ जउन मनसे यरुसलेम सहर के मुकति के ओरगथै, ऊ उन सब के ऊ लरका के बारे हे गुठेवै लगिन। ");
INSERT INTO bhu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","जब यूसुफ अउ मरियम परभु के नियम के अनुसार सगलू कुछ पूर कर लेय के बाद उन गलील परदेस हे अपन नासरत सहर छो लउट गइस। ");
INSERT INTO bhu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","लरका यीसु अपन उमर हे बढत गइस, अउ दिमाक लग भरपूर होत गइस, ओखर हे भगवान के अनुगरह किरपा बने रथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","यीसु के दाय बाफ हर साल फसह के तेउहार बनामै के निता यरुसलेम सहर छो जाय करथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","जब यीसु बारा साल के हुइस, ता ऊ रीति रिबाज के जसना यरुसलेम सहर छो जथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","जब तेउहार के रोज पूर होथै, ता यूसुफ अउ मरियम अपन घर छो लउटथै, ता लरका यीसु यरुसलेम सहर छो रह जथै, अउ ओखर दाय-बाफ हइ नेहको जानथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","यूसुफ अउ मरियम हइ बात के समझथै, कि ऊ यातरी समूह मनसेन के संग होही, इहैनिता उन अक्ठी रोज के यातरा पूर करै के बाद उके अपन परवार अउ संगिन के बीच खोजै लगथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","अउ जब यीसु उनके नेहको मिलथै, तब उन खोजत-खोजत यरुसलेम छो लउट गइन। ");
INSERT INTO bhu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","तीसर रोज के बाद उन यीसु के बिनती भवन हे गुरून के बीच बइठ के उनखर बात सुनथै, अउ उनखर लग सबाल पूछत पाथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","सगलू सुनै बाले मनसे यीसु के समझ अउ ओखर जबाब लग चकित रथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ओखर दाय बाफ उके देखके अचम्भा हे पड गइन, ओखर दाय यीसु लग पूछथै, “बेटवा तै हमर संग असना काखे करे? मै अउ तोर बाफ केतका चिन्तित हुइके तोके खोजत रहन।” ");
INSERT INTO bhu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","यीसु अपन दाय बाफ लग कथै, “तुम मोके काखे खोजत रहा? का तुम नेहको जानथा, कि मोके अपन बाफ के घर हे होयका जरूरी हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","पय यीसु के हइ बात उनके समझ हे नेहको आइस। ");
INSERT INTO bhu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","यीसु उनखर संग नासरत सहर छो लउट गइस, अउ उनखर कबजा हे रथै, ओखर दाय सगलू बात के अपन मन हे सम्हार के रखथै। ");
INSERT INTO bhu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","यीसु दिमाक अउ देह हे अउ भगवान अउ मनसेन के अनुगरह हे बढत गइस। ");
INSERT INTO bhu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","तिबिरियुस कैसर राजा के पन्दरा साल हे जब पुन्तियुस पिलातुस यहूदिया परदेस के राजपाल रथै, अउ गलील हे हेरोदेस ओखर भाई फिलिप्पुस इतूरैया अउ तरखोनीतिस परदेसन के सासक अउ लिसानियास अबिलेने परदेस के चवथाई राजा रथै। ");
INSERT INTO bhu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","हन्ना अउ कैफा जउन महायाजक रथै, तब जकरयाह कर टोरवा यूहन्ना के जब ऊ पतेरा हे रथै, भगवान के पल्ला लग अक्ठी बचन मिलथै। ");
INSERT INTO bhu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","इहैनिता यरदन नदिया के अगल-बगल सगलू इलाका हे यूहन्ना जाय के पाप छमा के निता मन बदलै के बतिस्मा कर परचार करै लगथै। ");
INSERT INTO bhu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","जसना यसायाह ग्यानी मनसे के, किताब हे लिखररे हबै, पतेरा हे गोहरामै बाले के सब्द सुनाई देथै, कि परभु के गली सिध्धा तइयार कर, अउ ओखर सगलू डहर साम्हू कर। ");
INSERT INTO bhu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","सगलू घटिया भर दय जही, अउ सगलू डोंगर अउ डोंगरी तरी करे जही, टेढवा गली सिध्धा, अउ ऊंच नीच रास्ता समथल करे जही। ");
INSERT INTO bhu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","अउ सगलू जीव भगवान के मुकति के देखहिन। ");
INSERT INTO bhu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","जउन मनसे यूहन्ना लग बतिस्मा लइ के ओखर लिघ्घो आथै, यूहन्ना उनखर लग कथै, “हे सपुवा के लरका तुमही कोहर भगवान के आमै बाले परकोप लग भागै के निता सचेत कर दइस? ");
INSERT INTO bhu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","सच्चे मन बदलै के परमाड देया अउ अपन मन हे हइ झइ कहा कि हम अब्राहम कर लरका हबन, मै तुम्हर लग कथो, भगवान हइ पथरन लग अब्राहम के निता लरका पइदा कर सकथै। ");
INSERT INTO bhu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","रूख के जर हे टंगिया रखे जाय चुके हबै, जउन रूख निक्खा फडुहा नेहको देथै, ओही खपलही अउ आगी के भट्ठा हे डार दय जही।” ");
INSERT INTO bhu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","मनसेन के भीड यूहन्ना लग पूछथै, “ता हमही काहिन करैका चाही?” ");
INSERT INTO bhu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","यूहन्ना जबाब दइस, “जउन मनसे के लिघ्घो दुइठे खुरथा पइजामा हबै, ऊ अक्ठी खुरथा उके दइ दे, जेखर लिघ्घो नेहको हबै अउ जेखर लिघ्घो भोजन हबै, वहु ओसनेन करी।” ");
INSERT INTO bhu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","पइसा उगाहै बाले मनसे बतिस्मा लेय के निता ओखर लिघ्घो आथै अउ यूहन्ना लग पूछथै, “हे गुरू हमही काहिन करैका चाही?” ");
INSERT INTO bhu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","यूहन्ना उनखर लग कथै, “जेतका पइसा तुम्हर निता जरूरी हबै, ओतकै लेया ओखर लग बोहत झइ लेया।” ");
INSERT INTO bhu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","सिपाही यूहन्ना लग पूछथै अउ हमके गुठे हम काहिन करी? ता ऊ जबाब देथै, कउनो के धन डेरा धमकाय के अउ ओखर लग झूठ आरोप लगाय के ओखर लग पइसा झइ लेया तुम अपन बेतन लग संतुस्ट रहा। ");
INSERT INTO bhu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","मनसे बडी आसा के संग ओरगथै अउ यूहन्ना कर बारे हे अपन मन हे हइ सोचथै, कि कहुं इहै तो मसीह नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","इहैनिता यूहन्ना उन सब लग कथै, “मै तो तुमही पानी लग बतिस्मा देथो पय अक्ठी आमै बाले हबै, जउन मोर लग बोहत सक्तिसाली हबै मै तो ओखर बूट के डोरा के गांठी छोरै के काबिल नेहको हबो, ऊ तुमके पवितर आतमा अउ आगी लग बतिस्मा देही। ");
INSERT INTO bhu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ऊ हाथ हे सूपा लइ चुके हबै, जेखर लग ऊ गोहूं के भूसा लग अलगे करके अपन खनेड के निक्खा साफ करके कोठला हे धरही पय भूसा के कबहुन नेहको बुझै बाले आगी हे डारी।” ");
INSERT INTO bhu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","इहैमेर बोहत लग बातन के सिक्छा दइके मनसेन के समझाथै अउ संदेस सुनाउत रथै। ");
INSERT INTO bhu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","बाद हे यूहन्ना ऊ चवथाई देस के राजा हेरोदेस के ओखर भाई के डउकी हेरोदियास के संग ओखर बेकार काम के कारन गधारथै। ");
INSERT INTO bhu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","तब हेरोदेस अक्ठी अउ कुकरम करिस ऊ यूहन्ना के बन्दी बनाय के जेल हे बेडवा दइस। ");
INSERT INTO bhu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","जब सगलू मनसे बतिस्मा लेथै, ता यीसु बतिस्मा लेथै अउ जब यीसु बिनती करथै तबै बादर उघर जथै। ");
INSERT INTO bhu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","अउ पवितर आतमा अक्ठी परेवा के देह धारन करके ओखर हे तरी उतरथै अउ बादर लग आरो सुनाई देथै, कि “तै मोर पिरिया टोरवा हबस, मै तोर लग बोहत मगन हव।” ");
INSERT INTO bhu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","यीसु जब अपन सेबा के काम सुरू करथै, ता ऊ लगभग तीस साल कर रथै, मनसे उके यूसुफ कर लरका समझथै यूसुफ एली कर टोरवा रथै। ");
INSERT INTO bhu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","अउ ऊ मत्तात जउन लेवी के, लेवी जउन मलकी के, मलकी जउन यन्ना के, यन्ना जउन यूसुफ के, ");
INSERT INTO bhu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","युसुफ जउन मत्तियाह के, मत्तियाह जउन आमोस के, आमोस जउन नहूम के, नहूम जउन असल्याह के, असल्याह जउन नोगह के ");
INSERT INTO bhu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","नोगह जउन मात के, मात जउन मत्तियाह के, मत्तियाह जउन सिमी के, सिमी जउन योसेख के, योसेख जउन योदाह के, ");
INSERT INTO bhu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","योदाह जउन यूहन्ना के, यूहन्ना जउन रेसा के, रेसा जउन जरूब्बाबिल के, जरूब्बाबिल जउन सालतीयल के, सालतीयल जउन नेरी के। ");
INSERT INTO bhu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","नेरी जउन मलकी के, मलकी जउन अद्दी के, अद्दी जउन कोसाम के, कोसाम जउन इलमोदाम के, इलमोदाम जउन एर के, ");
INSERT INTO bhu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","अउ ऊ यीसु के, अउ ऊ इलाजार के, इलाजार जउन योरामी के, योरामी जउन मत्तात के, मत्तात जउन लेवी के, ");
INSERT INTO bhu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","लेवी जउन समोन के, समोन जउन यहूदा के, यहूदा जउन यूसुफ के, यूसुफ जउन योनान के, योनान जउन इलयाकीम के, ");
INSERT INTO bhu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","इलयाकीन जउन मलेआह के, मलेआह जउन मिन्नाह के, मिन्नाह जउन मत्तात के, नातान के अउ ऊ दाऊद के, ");
INSERT INTO bhu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","दाऊद जउन इसै के, इसै जउन ओबेद के, ओबेद जउन बोवज के, बोवज जउन सलमोन के, सलमोन जउन नहसोन के, ");
INSERT INTO bhu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","नहसोम जउन अम्मीनादाब के, अम्मीनादाब के, अरनी के, अरनी जउन हेस्रोन के, हेस्रोन जउन पेरेस के, पेरेस जउन यहूदा के, ");
INSERT INTO bhu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","यहूदा जउन याकूब के, याकूब जउन इसहाक के, इसहाक जउन अब्राहम के, अब्राहम जउन तिरह के, तिरह जउन नाहोर के, ");
INSERT INTO bhu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","नाहोर जउन सरुग के, सरुग जउन रऊ के, रऊ जउन फिलिग के, फिलिग जउन एबिर के, एबिर जउन सिलह के, ");
INSERT INTO bhu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","सिलह जउन केनान के, केनान जउन अफरछद के, अफरछद जउन सेम के, सेम जउन नूह के, नूह जउन लिमिक के, ");
INSERT INTO bhu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","लिमिक जउन मथूसिलह के, मथूसिलह जउन हनोक के, हनोक जउन इरिद के, इरिद जउन महललेल के, महललेल जउन केनान के, ");
INSERT INTO bhu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","केनान जउन एनोस के, एनोस जउन सेत के, सेत जउन आदम के अउ आदम भगवान कर टोरवा रथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","यीसु पवितर आतमा लग भरपूर हुइ के, यरदन नदिया लग लउट आथै, ता आतमा उके पतेरा छो लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","उहां भुतवा चालीस रोज ओखर परिक्छा लेथै, यीसु उन दिना हे ऊ कुछु नेहको खाय रथै, जब चालीस रोज गुजर जथै, ता यीसु के भूख लगिस। ");
INSERT INTO bhu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","भुतवा यीसु लग कथै, “अगर तै भगवान कर टोरवा हबस, ता हइ पथरा लग कहि दे कि रोटी बन जाय।” ");
INSERT INTO bhu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","पय यीसु भुतवा के जबाब देथै, किताब हे लिखररे हबै मनसे सिबाय रोटी लग नेहको जिन्दा रही। ");
INSERT INTO bhu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","फेर भुतवा यीसु के ऊंच जिघा छो लइ जथै, अउ चुटु टेम हे दुनिया कर सगलू राज दिखाथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","भुतवा यीसु लग कथै, “मै हइ सगलू राज के हक तोके दइ देहों, काखे ऊ मोके दय गय हबै, अउ मै जेही चाहथो ओहि दइ सकथों। ");
INSERT INTO bhu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","भुतवा कथै, अगर तै मोर परनाम करिहों ता हइ सगलू तोर हुइ जही।” ");
INSERT INTO bhu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","यीसु उके जबाब दइके कथै, “किताब हे लिखररे हबै, अपन परभु भगवान के परनाम करा अउ ओखरै सेबा करै के चाही।” ");
INSERT INTO bhu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ता भुतवा यीसु के यरुसलेम सहर छो लइ गइस, अउ उहां बिनती भवन के फुलगी हे लइजाय के उहां ठाढ कर देथै अउ ओखर लग कथै, अगर तै भगवान कर टोरवा हबस, ता इहां लग कूद जा। ");
INSERT INTO bhu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","काखे किताब हे लिखररे हबै, तोर बारे हे भगवान अपन स्वरगदूत के आदेस दइ, कि उन तोर रक्छा करै। ");
INSERT INTO bhu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ऊ तोके अपन हाथ हे सम्हार लेही, कि तोर गोड के पथरा लग चोट झइ लगै। ");
INSERT INTO bhu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","यीसु भुतवा के जबाब दइके कथै, “किताब हे हइ लिखररे हबै, तै अपन परभु भगवान कर परिक्छा झइ ले।” ");
INSERT INTO bhu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","भुतवा यीसु के सगलू परकार के परिक्छा लेय के बाद ऊ उछो लग छांड के कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","फेर आतमा के सक्ति लग भरपूर हुइके यीसु गलील परदेस छो लउट आइस, अउ ओखर बात अगल-बगल के सगलू इलाका छो फइल गइस। ");
INSERT INTO bhu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","यीसु उनखर मंडली छो सिक्छा देय लगिस, अउ सगलू मनसे ओखर बडाई करथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","जब यीसु नासरत सहर हे आइस, जिहां ओखर पालन पोसड होय रथै, अउ अपन आदत के जसना सुस्ताय कर रोज के टेम ऊ यहूदी मंडली छो पवितर किताब पढै के निता ठाड हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","“ता उके यसायाह ग्यानी मनसे के किताब दय गइस, जब यीसु किताब खोलके ऊ जिघा निकारिस, जिहां लिखररे हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“परभु कर आतमा मोर संग हबै, काखे ऊ मोर अभिसेक करे हबै, ऊ मोके पठोय हबै, कि मै कंगालन के संदेस सुनाव, अउ जेलियरन के मुकति करो, अउ अंधरन के फेरै आंखी देय के संदेस दों, मै दलित मनसेन के आजाद करव।” ");
INSERT INTO bhu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","अउ परभु के किरपा के टेम बतामै, के निता पठोय गय हव। ");
INSERT INTO bhu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","फेर यीसु किताब के बन्द करके हरवाह के वापिस दइ देथै अउ बइठ गइस, मंडली हे सगलू मनसेन के आंखी उके देखथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ता यीसु उनखर लग कथै, “आज तुम्हर सुनेहर पवितर किताब के हइ सब्द पूर हुइ गइस।” ");
INSERT INTO bhu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","सगलू मनसे यीसु के बडाई करथै, ओखर मुंह लग जउन निक्खा सब्द निकरथै, उन सगलू चकित रथै, उन पूछथै, “का हइ यूसुफ कर टोरवा नेहको हबै?” ");
INSERT INTO bhu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","यीसु उनखर लग कथै, “तुम जरूर हइ कहावत सुनिहा, हे पंडा पहिले तै अपन खुद के निक्खा कर, तुम मोर लग हइ कइहा, कफरनहूम सहर छो जउन कुछु होय हबै, हम ओखर बारे हे सुने हवन, अब ऊ इहां अपन सहर हे कर।” ");
INSERT INTO bhu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","यीसु मनसेन लग कथै, मै तुम्हर लग सच कथो, ग्यानी मनसेन के सोगत अपन सहर छो नेहको होथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","सच्चाई कर बात हइ हबै कि नबी एलिय्याह के रोज हे जब साढे तीन साल लग बादर लग पानी नेहको बरसथै अउ सगलू देस हे बोहत भुखमरी पडथै, ता ऊ टेम इस्राएल देस हे बोहत लग विधवा डउकी रथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","तबो एलिय्याह उनखर हे कउनो के लिघ्घो नेहको पठोय गइस, बलुक सीदोन देस के सारफत सहर हे रहैबाले अक्ठी विधवा डउकी के लिघ्घो। ");
INSERT INTO bhu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","अउ नबी एलीसा के रोज हे इस्राएल देस हे बोहत लग कोढी रथै, तउभरमा उनखर मसे कउनो कोढी सुध्द नेहको करे गइस सिबाय सीरिया देस के रहै बाले नामान कोढी सुध्द करे गइस। ");
INSERT INTO bhu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","हइ सुनके मंडली सभा के सगलू मनसे बोहत गुस्सा हुइ गइन। ");
INSERT INTO bhu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","उन ठाढ हुइन अउ उन यीसु के सहर ले बाहिर निकार देथै, अउ जउन डोंगर के इटिल्ली हे लइ जथै, जिहां ओखर सहर बसे रथै, ऊ यीसु के ऊ इटिल्ली हे लइ जथै, ताकि उके तरी ढकेल दे। ");
INSERT INTO bhu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","पय यीसु उनखर बीच लग निकरके अपन गली छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","यीसु गलील परदेस के कफरनहूम सहर छो आथै, अउ सुस्ताय कर रोज मनसेन के सिक्छा देय लगथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","मनसे ओखर सिक्छा सुनके चकित रथै, काखे ऊ हक के संग बोलथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","मंडली हे अक्ठी मनसे रथै, जेखर हे असुध्द बेकार भुतवा समाय रथै, ऊ जोर लग चिरलाथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“हे यीसु नासरी तै मोर लग काहिन चाहथस? का तै हमके नास करै आय हबस? मै जानथो कि तै कउन हबस, तै भगवान कर पवितर जन हबस।” ");
INSERT INTO bhu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","यीसु हइ कहत भुतवा के डांटथै, चुप रह अउ हइ मनसे लग बाहिर निकर जा, भुतवा सबके आगू उके भुंइ हे पटकथै, अउ ओखर नुसकान करे बेगैर ओहमा लग निकर गइस। ");
INSERT INTO bhu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","सगलू मनसे चकित रथै, उन अपनै हे कथै, हइ कइसन बचन आय? ऊ हक अउ सक्ति के संग भुतवा के आदेस देथै, अउ ऊ निकर जथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","एखर बाद यीसु के चरचा अगल-बगल के सगलू जिघा हे होय लगथै। ");
INSERT INTO bhu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","तब यीसु मंडली लग निकड के समोन के घर छो गइस, समोन के फुवा के तेज दुख्खन हे पडे हर रथै, अउ मनसे ओखर निता यीसु लग बिनती करिन। ");
INSERT INTO bhu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","यीसु ओखर लिघ्घो जायके दुख्खन के डांटिस अउ दुख्खन उहै टेम उतर जथै, अउ झट्टैने उठके मनसेन के सेबा करै हे लग गइस। ");
INSERT INTO bhu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","जब बेरा बुडै लग जथै, ता सगलू मनसे कइन मेर के दुख्खन हे पडे रथै, अउ उनही यीसु के लिघ्घो लानथै, यीसु अक अकझन के उप्पर हाथ धरके उनही निक्खा कर दइस। ");
INSERT INTO bhu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","भुतवा बोहत झन मसे चिरलात बाहिर निकरथै, अउ यीसु लग कथै, “तै भगवान कर टोरवा हबस” पय यीसु उनके डांटथै अउ उनके गुठेमै लग रोकथै, काखे भुतवा जानथै कि ऊ मसीह हबै। ");
INSERT INTO bhu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","बडे सुबेन्नेन यीसु घर लग निकरके कउनो सुनसान जिघा छो कढ जथै, पय मनसे उके ढूंढत-ढूंढत ओखर लिघ्घो पहुंच जथै, अउ उनखर लग अनुरोध करथै कि ऊ हमके छांड के झइ जाय। ");
INSERT INTO bhu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","पय यीसु उनही जबाब दइस, मोके दूसर सहर छो भगवान कर राज कर संदेस सुनामै के जरूरी हबै, इहैनिता मै पठोय गय हबो। ");
INSERT INTO bhu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","अउ यीसु यहूदिया परदेस के मंडली हे परचार करै लगिस। ");
INSERT INTO bhu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","अक रोज यीसु गन्नेसरत झील के टाठा लग ठाड रथै, ता मनसे भगवान कर बचन सुनै के निता ओखर चउगिरदा पल्ला घेरे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ऊ टेम उन झील के पाखा छो लगे हर दुइठे नाह जिहाज के देखथै, ढिमरा उतर के जाला के धोउत रथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","यीसु उनखर मसे अक्ठी नाह जिहाज लग जउन समोन के रथै, चढ गइस अउ उन ओखर लग कथै, नाह जिहाज के टाठा लग कुछ दुरिहां लइ चला एखर बाद ऊ बइठ गइस अउ नाह जिहाज लग मनसेन के सिक्छा देय लगथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","बात करै के बाद उन समोन लग कथै, नाह जिहाज गहीर पानी हे लइ चला अउ मछडी पकरै के निता अपन जाला उछो डाला। ");
INSERT INTO bhu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","समोन जबाब देथै, स्वामी रात भर मेहनत करै भरमा हम कुछु नेहको पकड सकन, पय तोर कहे लग मै जाल डारे देथो। ");
INSERT INTO bhu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","असना करे लग बोहत मछडी जाल हे फस गइस कि उनखर जाल फटै लगिस। ");
INSERT INTO bhu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","उन दूसर नाह जिहाज के अपन संगिन के इसारा करिस कि उन आयके उनखर मदत करै, उन आइन अउ उन दुनो नाह जिहाज के मछडिन लग एतका भर लइन कि नाह जिहाज पानी हे बुडै लगथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","हइ देखके समोन पतरस यीसु के गोड हे गिरके कथै, “परभु मोर लिघ्घो लग कढ जा, मै तो पापी मनसे हव।” ");
INSERT INTO bhu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","काखे जाल हे बोहत मछडिन के फसै के कारन समोन अउ ओखर संगी चकित रथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","इहै हाल याकूब अउ यूहन्ना के होइस, हइ जबदी के टोरवा समोन सहपारटी रथै, यीसु समोन लग कथै, “झइ डर काखे अब तुम जिन्दा मनसेन के पकरे करिहा।” ");
INSERT INTO bhu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","जब उन अपन नाह जिहाज के पाखा लग लानथै, तब उन सगलू कुछ छांडके यीसु के पाछू हुइ लेथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","अक बेर जब यीसु कउनो सहर छो रथै, ता ओखर लिघ्घो अक्ठी मनसे आइस, ओखर देह कोढ नंगहा लग भरे हर रथै, ऊ यीसु के देखके अपन मुंह के बल गिर पडिस, अउ ओखर लग मदत के निता बिनती करिस, “परभु अगर तै चइहे ता मोके सुध्द कर सकथस।” ");
INSERT INTO bhu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","यीसु अपन हाथ बढाय के कोढी के छिके कथै, “मै इहै चाहथो कि तै सुध्द हुइ जा” अउ उतकै टेम कोढ नांगा लग निक्खा हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","यीसु उके आदेस देथै, “कउनो लग झइ कहबे, पय जा अउ अपन खुद के पुजारी के देखा, अउ अपन सुध्द होय के सबूत देया, अउ मूसा कर आदेस के जसना बलि चढावा, जेखर लग सगलू मनसेन के अक्ठी गवाही हुइ जाय कि तै कोढ नांगा लग निक्खा हुइ गय हबस।” ");
INSERT INTO bhu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","तउभरमा यीसु के चरचा अउ बोहत जोर लग फइलत गइस, झुन्ड के झुन्ड मनसे ओखर संदेस सुनै के अउ अपन नांगा लग निक्खा होय के निता, ओखर लिघ्घो आमै लागथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","पय यीसु अलगे जायके सुनसान जिघा हे बिनती करे करथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","अक रोज यीसु सिक्छा देत रथै, ता उहां फरीसी नियाव के गुरू बैठे हर रथै, उन गलील अउ यहूदिया परदेस के यरुसलेम सहर लग आय रथै, नंगहन के निक्खा करै के निता, परभु कर सक्ति उनखर संग रथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","उहै टेम कुछ मनसे अक्ठी लोकवा के नंगहा के खटिया हे सोबाय के उछो लानथै, उन उके भित्तर लइ जायके यीसु के आगू धरै के जुगाड खोजथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","पय जब भीड के कारन ओही घर के भित्तर लइ जाय के कउनो उपाय नेहको दिखथै, ता उन छानी हे चढ गइन अउ उन खपरा के टार के खटिया के संग लोकवा के नंगहा के मनसेन के बीच हे यीसु कर आगू उतार दइन। ");
INSERT INTO bhu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","उनखर बिस्वास के देखके यीसु कथै, “हे मनसे तोर पाप छमा हुइ गइस।” ");
INSERT INTO bhu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","फरीसी अउ नियाव के गुरू अक दूसर लग पूछै लागथै, “हइ भगवान कर बुराई करथै हइ कउन हबै? भगवान कर अलाबा कउन पाप छमा कर सकथै?” ");
INSERT INTO bhu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","यीसु उनखर सबाल के जानके जबाब देथै, “तुम अपन मन हे हइ सबाल काखे उठाथा? ");
INSERT INTO bhu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","का कहेका सरल होही, हइ कहबे कि तोर पाप छमा कर दय गय हबै अउ हइ कहेका कि ठाड हो अउ रेंग बाग? ");
INSERT INTO bhu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","पय इहैनिता कि तुमही पता हुइ जाय कि मनसे कर टोरवा के भुंइ हे पाप छमा करै के हक हबै” ऊ लोकवा के नंगहा लग बोलिस, “मै तोर लग कथो ठाढ हुइ जा अउ अपन खटिया उठाय के घर छो जा।” ");
INSERT INTO bhu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","उहै टेम सबके आगू उठके ठाड हुइस अउ जउन खटिया हे सोय रथै, उके उठायके भगवान कर बडाई करत अपन घर छो कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","उन सगलू चकराय जथै, अउ भगवान के बडाई करे लागथै, अउ उनखर हे डर छाय गइस, उन कथै, “आज हम अदभुत काम देखे हबन।” ");
INSERT INTO bhu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","एखर बाद यीसु बाहिर निकरथै, ता लेवी नाम के अक्ठी पइसा उगाहै बाले सिपाही के चवकी हे बइठे हर देखथै, यीसु ओखर लग कथै, मोर पाछू आ। ");
INSERT INTO bhu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ऊ उठके ठाड हुइस अउ अपन सगलू कुछ छांड के यीसु कर पाछू हुइ लेथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","लेवी अपन घर हे यीसु कर आदर हे अक्ठी बडा भोज के आयोजन करिस, उहां पइसा उगाहै बाले के अलाबा उछो कइझन मनसे यीसु अउ लेवी के संग भोजन करै बइठथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","हइ देखके ऊ समूह के फरीसी अउ नियाव के गुरू चेलन लग कहै लगथै, “तुम पइसा उगाहै बाले अउ पापिन के संग काखे खात पियत हबा?” ");
INSERT INTO bhu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","यीसु उनके जबाब देथै, “निक्खा मनसे के नेहको बलुक नंगहन मनसे के गुनिया के जरूरत होथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","यीसु कथै मै धरमी मनसे के नेहको पय पापिन के मन बदलै के निता बुलामै आय हबो।” ");
INSERT INTO bhu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","उन यीसु लग कथै, यूहन्ना के चेला सबदिना उपास रथै, अउ बिनती करथै अउ ओसनेन फरीसी के चेला करथै, पय तोर चेला खात पियत रथै। ");
INSERT INTO bhu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","यीसु उनखर लग कथै, “जब तक दुलहा उनखर संग हबै, का तुम बरतिहन लग उपास करा सकथा? ");
INSERT INTO bhu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","पय ऊ रोज आही, जब दुलहा उनखर लग लइ ले जही, उन ऊ टेम उपास करही।” ");
INSERT INTO bhu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","यीसु उनके हइ किस्सा सुनाथै, “कउ मनसे नबा खुरथा पइजामा के आधा फाड के ओही जुनहा खुरथा पइजामा हे नेहको लगाथै, अगर असना करथै ता नबा खुरथा पइजामा फट जही, नबा खुरथा पइजामा के संग जुनहा कपडा के मेल नेहको खही। ");
INSERT INTO bhu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","उहैमेर कउनो मनसे जुनहा खलरी के थइला लग नवा अंगूर के रस नेहको भरथै, अगर भरथै ता नवा दारू जुनहा खलरी के थइला के फाड दइ दाखरस बहि जही अउ खलरी बढाय जही। ");
INSERT INTO bhu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","नबा अंगूर कर रस के नबा खलरी के थइला हे नेहको भरै चाही। ");
INSERT INTO bhu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","पुरान अंगूर के रस पीके नबा नेहको चाहथै, ऊ कथै पुरान बढिहा हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","सुस्ताय कर रोज यीसु गोहूं के खेत लग हुइके गुजरथै, ता ओखर चेला गोहूं दाना के फडुहा के टोर के हाथ लग मीज के खाय लागथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","हइ देखके कुछ फरीसी कथै, “जउन काम सुस्ताय कर रोज मना हबै, तुम काखे उहै काम करथा?” ");
INSERT INTO bhu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","यीसु जबाब दइस, “का तुम नेहको पढे हबा, कि जब दाऊद अउ ओखर संगिन के भूख लगथै, ता दाऊद काहिन करिस? ");
INSERT INTO bhu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","दाऊद भगवान कर घर हे जायके चढावा के रोटी उठाइस अउ खुद खाइस, अउ अपन संगिन के खबाथै, सिबाय पुजारिन के छांडके कउनो अउ के उनही खांय के निता उचित नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ता यीसु उनखर लग कथै, “मनसे कर टोरवा सुस्ताय कर रोज के परभु हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","कउनो दूसर सुस्ताय कर रोज यीसु यहूदी मंडली हे जायके सिक्छा देथै, उहां अक्ठी मनसे रथै, जेखर दहिना हाथ झुराय गय रथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","नियाव के गुरू अउ फरीसी हइ बात के ताक हे रथै, कि अगर यीसु सुस्ताय कर रोज कउनो के निक्खा करी, ता ओखर हे आरोप लगाय सकि। ");
INSERT INTO bhu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","यीसु उनखर सोच के जानथै, तउभरमा झुराय हर हाथ बाले मनसे लग कथै, “उठ अउ सबके बीच हे ठाड हुइ जा।” ऊ उठिस अउ ठाड हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","यीसु उन मनसेन लग कथै, मै तुम्हर लग पूछथो, सुस्ताय कर रोज कउनो के निक्खा करै के जरूरी हबै, या कउनो के नुसकान पहुंचामै के, कउनो के जीवन बचामै के जरूरी हबै, या कउनो के जीवन के नास करै के? ");
INSERT INTO bhu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","यीसु चउगिरदा पल्ला सब के देखके ऊ मनसे लग कथै, अपन हाथ के आगू बढा अउ ओसनेन करथै अउ ओखर हाथ निक्खा हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","हइ देखके फरीसी अउ नियाव के गुरू गुस्सा लग जलै लागथै, अपने हे सोच बिचार करै लग जथै, कि अब यीसु के संग काहिन करे जाय। ");
INSERT INTO bhu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ऊ रोज यीसु बिनती करै के निता अक्ठी डोंगर छो जथै, अउ सगलू रात भगवान लग बिनती करत गुजार दइस। ");
INSERT INTO bhu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","बिहन्ने होय लग यीसु अपन चेलन के अपन लिघ्घो बुलवाथै, अउ उनखर मसे बारहठे के चुन के उनखर चेला नाम देथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","समोन जेखर ऊ पतरस नाम दइस, अउ ओखर भाई अन्द्रियास याकूब अउ यूहन्ना फिलिप्पुस बरतुल्मै। ");
INSERT INTO bhu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मत्ती अउ थोमा अउ हलफई कर टोरवा याकूब अउ समोन जेही जेलोतेस कथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","याकूब के टोरवा यहूदा अउ यहूदा इस्करियोती जउन धोखा दइस ");
INSERT INTO bhu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","यीसु अपन बारहठे चेलन के संग डोंगर लग तरी उतर के मइदान जिघा हे ठाड हुइस, उहां ओखर बोहत लग चेला रथै, अउ बोहत मनसेन के भीड रथै, उन सगलू मनसे यहूदा परदेस, यरुसलेम सहर सूर अउ सैदा के समुन्दर के टाठा लग आय रथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","उन यीसु कर संदेस सुनै अउ अपन नंगहा लग आजाद होय के निता आय रथै, यीसु जउन भुतवा लग नंगाय हर मनसेन के निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","सगलू मनसे यीसु के छियै के परयास करथै, काखे ओखर लग सक्ति निकर के बोहत लग मनसेन के निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","यीसु अपन चेलन के देखके कथै, “धन्य हबा तुम जउन दीन हबा, काखे भगवान कर राज तुम्हरेन हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“धन्य हबा तुम, जउन अबे भुखाय हबा, काखे तुम अघाय जइहा, धन्य हबा तुम जउन आज रोउथा, काखे तुम हसिहा।” ");
INSERT INTO bhu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“धन्य हबा तुम, जब मनसे कर टोरवा यीसु के चलते मनसे तुम्हर लग बैर करही, तुम्हर बहिस्कार अउ बेज्जती करही अउ तुम्हर नाम गलत समझ के काट देइहिन।” ");
INSERT INTO bhu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ऊ रोज मगन हुइके खुसी बनइहा अउ कुदिहा, काखे स्वरग हे तुमके इनाम मिलही, उनखर सियान ग्यानी मनसे के संग ओसनेन करथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“पय हाय तुमही जउन तुम धनड्ड हबा, काखे तुम अपन सुख सान्ति पाय चुके हबा।” ");
INSERT INTO bhu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","हाय तुमही जउन अबे अघाय गय हबा, काखे तुम भुखाय हर रहिया, हाय तुमही जउन अबे हसथा, काखे तुम दुख होही अउ रोइहा। ");
INSERT INTO bhu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“हाय तुमही जब सगलू मनसे तुम्हर परसंसा करथै, काखे उनखर दाय बाफ ठगरा ग्यानी मनसेन के संग ओसनेन करथै।” ");
INSERT INTO bhu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","यीसु कथै, मै सगलू सुनै बाले मनसेन लग कथो, अपन बैरिन लग माया करा जउन तुम्हर लग घिनाथै उनखर संग अच्छाई करा। ");
INSERT INTO bhu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","जउन तोके सराप देथै, उनही आसीस देया जउन तुम्हर संग बेकार बेउहार करथै, उनखर निता बिनती करा। ");
INSERT INTO bhu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","अगर कउ तुम्हर अक्ठी गाल हे झापड मारी, ता दूसर गाल ओखर आगू कर दइहा, जउन कउ तुम्हर खुरथा पइजामा के झटक लइ ता उके अपन खुरथा पइजामा दइ दइहा। ");
INSERT INTO bhu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","जउन कउ तुमही मांगथै, उके दय करा अउ जउन तोर कुछु चीज झटक लइ, ता ओही फेरै झइ मांगबे। ");
INSERT INTO bhu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","दूसर लग अपन परति जसना बेउहार चाहथा, तुम उनखरो संग ओसनेन बेउहार करे करा। ");
INSERT INTO bhu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","अगर तुम उनखरै लग माया करथा जउन तुम्हर लग माया करथै, ता एहमा तुमही का फायदा हबै? पापी मनसे अपन माया करै बालेन लग माया करथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","अगर तुम उनखरै मदद करथा, जउन तुम्हर मदद करथै, ता एहमा तुम्हर काहिन बडाई हबै? पापी मनसे असना करथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","अगर तुम उनही उधार देथा, जिनखर लग फेरै पामै के आसा करथा, ता एहमा तुम्हर का बडाई हबै? पूर-पूर पामै के आसा हे पापी पापिन के उधार देथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","पय तुम अपन बैरिन लग माया करा, उनखर निक्खा करा अउ फेरै पामै के आसा झइ करके उधार देया, तबै तुम्हर इनाम बडा हुइ अउ तुम परम परधान भगवान के लरका बन जइहा, काखे ऊ उनखर परति किरपा अउ दुस्ट मनसेन लग दया करथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","दयालु बना, जसना तुम्हर स्वरगी बाफ दयालु हबै। ");
INSERT INTO bhu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","दोसी झइ ठहराबा, ता तुमो दोसी नेहको ठहराय जइहा, कउनो के परति फइसला झइ देया, ता तुम्हरो परति फइसला नेहको दय जही, छमा करा ता तुमो के छमा मिली। ");
INSERT INTO bhu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","देया ता तुमोन के दय जही, ठूसठूस के अउ डोलाय-डोलाय के अउ छलकत लग तुम्हर गोद हे डारे जही, काखे जउन तउल लग तुम तउलथा, उहै तउल लग तुम्हरो निता तउले जही। ");
INSERT INTO bhu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","यीसु उनके अक्ठी किस्सा सुनाथै, का कउनो अंधरा दूसर अंधरा के गली दिखाय सकथै? का दोनो अंधरा गढहा हे नेहको गिरही? ");
INSERT INTO bhu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","यीसु कथै, चेला गुरू लग बडे नेहको होथै, पय पूर सिक्छा पाय के बाद ऊ अपन गुरू के जसना बन जथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","यीसु कथै, जब तुमही अपन आंखी के किरकिरी नेहको पता, ता तुम अपन भाई के आंखी के किरकिरी काखे देखथा। ");
INSERT INTO bhu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","जब तुमही अपन आंखी के किरकिरी नेहको दिखथै, ता अपन भाई लग कसके कहि सकथस, भाई आ मै तोर आंखी के किरकिरी निकाड दो? अरे ढोंगहा पहिले अपन आंखी के किरकिरी के निकाड तब तै अपन भाई के किरकिरी के निकाडै के निता निक्खा देख सकिहे। ");
INSERT INTO bhu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“कउनो बढिहा रूख बेकार फडुहा नेहको देथै, अउ न कउनो बेकार रूख बढिहा फडुहा देथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","सगलू रूख अपन फडुहा लग चिन्हाथै, मनसे न तो कांटा बाले पुडरा लग अंजीर के फडुहा टोरथै अउ न कांटा बाले पुडरा लग अंगूर के फडुहा टोरथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","निक्खा मनसे अपन मन लग निक्खा खजाना लग निक्खा चीज निकाडथै अउ जउन बेकार हबै, ऊ अपन भन्डार लग बेकार चीज निकाडथै, काखे जउन हिरदय हे भरे हबै उहै मुंह लग बाहिर आथै।” ");
INSERT INTO bhu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“जब तुम मोर बात हे नेहको चलथा, ता हे परभु, हे परभु काखे मोके कथा? ");
INSERT INTO bhu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","जउन मनसे मोर लिघ्घो आथै अउ मोर बात सुनथै अउ उनखर हे चलथै, ऊ केखरै जसना हबै? मै तुमही गुठेथो। ");
INSERT INTO bhu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ऊ उस मनसे के जसना हबै, जउन घर बनाउत टेम भुंइ हे खोदरा करके पथरा हे नीह डालिस, बाढ आइस अउ नदिया के पानी ऊ घर हे टकराइस पय ऊ पानी घर के नेहको गिराय सकिस, काखे ऊ घर बोहत मजबूत बने रथै। ");
INSERT INTO bhu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","पय जउन मोर बात के सुनथै अउ नेहको मानथै, ऊ उस मनसे के जसना हबै जउन भुंइ के बगैर नीह डारे कुदरा हे अपन घर बनाय हबै, जब बाढ ओखर लग टकराइस ता ऊ गिर गइस अउ गिरके बरबाद हुइ गइस।” ");
INSERT INTO bhu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","मनसेन के अपन ई सगलू बात सुनामै के बाद यीसु कफरनहूम सहर हे आइस। ");
INSERT INTO bhu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","उहां अक्ठी रोमन सिपाही के खास हरवाह जउन बोहत नंगाय रथै अउ मरै बाले रथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","जब सिपाहिन के सिपाही यीसु के चरचा सुनिस ता कुछ सियान यहूदी के यीसु के लिघ्घो हइ बिनती करै के निता पठोथै, कि ऊ आयके ओखर हरवाह के निक्खा कर दे। ");
INSERT INTO bhu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","उन यीसु के लिघ्घो आयके ओखर लग बिनती करके कथै, “ऊ सेना साहब ऊ काबिल हबै, कि तै ओखर निता असना कर। ");
INSERT INTO bhu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ऊ हमर रास्ट लग माया करथै, अउ उहै हमर निता मंडली सभा बनवाय हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","यीसु उनखर संग कढ गइस, जब ऊ ओखर घर के लिघ्घो पहुंचै बाले रथै, तब सेना सिपाही अपन सखा के दवारा यीसु के लिघ्घो हइ कहिके संदेस पठोथै, कि परभु तै कस्ट झइ कर, काखे कि मै हइ काबिल नेहको हबो, कि तै मोर छानी तरी आबै। ");
INSERT INTO bhu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","सिपाहिन के साहब कथै, मै इहैनिता खुद के हइ काबिल नेहको समझथो, कि तोर लिघ्घो आंव तै अक्ठी सब्द कहि दे ता मोर सेबक निक्खा हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","मै खुदय साहबन के वस हे रथो अउ सिपाही मोर वस हे रथै, जब मै अकझन लग कथो जा, ता ऊ जथै अउ अपन हरवाह लग कथो, हइ कर ता ऊ करथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","हइ सुनके यीसु सेनानायक के बात हे चकित होथै, ऊ अपन पाछू आउत मनसेन के पल्ला मुडके कथै, मै तुम मनसेन लग कथो, इस्राएल हे मै एतका मजबूत बिस्वास नेहको पायों। ");
INSERT INTO bhu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","अउ पठोय हर मनसे अपन घर छो लउटके आथै, ता अपन हरवाह के चंगा पाथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","एखर कुछ टेम बाद हे, यीसु नाईन सहर छो जथै, यीसु के चेला अउ मनसेन के बोहत भीड ओखर संग रथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","जब यीसु नाईन सहर के परवेस दूरा के लिघ्घो पहुंचथै, ता मनसे अक्ठी मरे हर मुरदा के बाहिर मरघटियानी छो लइ जथै, ऊ अपन दाय के अक्ठिन टोरवा रथै अउ ओखर दाय बिधवा रथै अउ सहर के बोहत लग मनसे ओखर संग रथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","दाय के देखके परभु दया लग भर जथै अउ बिधवा डउकी लग कथै “झइ रो” ");
INSERT INTO bhu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","अउ यीसु लिघ्घो आयके सिहरी के छीथै अउ लोथ के लइ जाय बाले मनसे रुक जथै, यीसु कथै, “हे टोरवा मै तोर लग कथो उठ।” ");
INSERT INTO bhu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ता ओतकै टेम मरे हर टोरवा जिन्दा हुइ गइस, अउ ऊ गुठेमै लग जथै अउ यीसु ओखर दाय के सउप देथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","सगलू मनसे देखके उनखर भित्तर डर छाय जथै, अउ उहां सगलू मनसे भगवान के बडाई करै लग जथै, अउ मनसे कथै हमर बीच हे अक्ठी बोहत बडा ग्यानी मनसे आय हबै, अउ भगवान अपन परजा के सुधि लय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","यीसु के बारे हे हइ बात यहूदिया परदेस अउ अगल बगल के सगलू इलाका हे फइल गइस। ");
INSERT INTO bhu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","यूहन्ना के चेला ई सब बातन के खबर के जउन कुछु उहां देखथै, आयके गुठेथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","यूहन्ना अपन दुइठे चेलन के बुलाय के परभु के लिघ्घो पूछै के निता पठोथै, “का जउन आमै बाले रथै, जेही हम ओरगथन का तहिन हबस?” ");
INSERT INTO bhu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","दुइठे चेला यीसु के लिघ्घो आयके कथै, यूहन्ना जउन बतिस्मा देय बाले, हमके तोर लिघ्घो पूछै के निता पठोय हबै, का आमै बाले तहिन हबस या अउ कउनो दूसर के ओरगी? ");
INSERT INTO bhu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","उहै टेम यीसु बोहत लग नंगहन के अउ भुतवन लग निक्खा करथै, अउ बोहत अंधरन के आंखी देथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","तब यीसु यूहन्ना के चेलन लग कथै, जा, तुम जउन सुनथा अउ देखथा, हइ सगलू बात यूहन्ना के गुठेइहा, कि अंधरा देखथै अउ लेंगरा रेंगथै, कोढिन सुध्द करे जथै, बहिरा सुनथै मुरदा जिन्दा करे जथै अउ गरीबन के संदेस सुनाय जथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","धन्य हबै ऊ मनसे जउन मोर बारे हे भ्रम हे नेहको पडथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","यूहन्ना दवारा पठोय हर चेलन के कढ जाय के बाद यीसु मनसेन के यूहन्ना के बारे हे गुठेमै लागथै, तुम निरजन परदेस हे काहिन देखय गय रहा? का हवा लग हिलत हर सरकन्डे के? ");
INSERT INTO bhu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ता तुम काहिन देखै गय रहा? बढिहा खुरथा पइजामा पहिरै बाले मनसे के? नेहको मंहगा खुरथा पइजामा पहिरै बाले अउ मउज मस्ती हे जीवन गुजारै बाले मनसे पक्का घर हे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","गुठेबा तुम काहिन देखै गय रहा? का कउनो ग्यानी मनसे के? निस्चय मै तुम्हर लग कथो, ग्यानी मनसे लग बडा मनसे के। ");
INSERT INTO bhu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","हइ उहै हबै जेखर बारे हे किताब हे लिखररे हबै, भगवान कथै, देखा मै अपन दूत के तुम्हर आगू पठोथो, ऊ तुम्हर आगू तुम्हर गली तइयार करी। ");
INSERT INTO bhu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","मै तुम्हर लग कथो, जउन डउकिन लग पइदा होय हबै, उनखर मसे यूहन्ना लग बडे कउनो नेहको तउ भगवान कर राज हे जउन सगलू लग नान हबै, ऊ यूहन्ना लग बडा हबै। ");
INSERT INTO bhu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","सगलू मनसे अउ पइसा उगाहै बाले सिपाही जब हइ सुनथै, ता उन यूहन्ना के बतिस्मा लेय के कारन हइ स्वीकार करिन कि भगवान के योजना सही हबै। ");
INSERT INTO bhu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","पय फरीसी मनसे अउ नियम के गुरू यूहन्ना लग बतिस्मा नेहको लेथै, अपन बारे हे भगवान के योजना के बेकार कर देथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","यीसु आगू कथै, मै हइ पुरखा के मनसेन के बरोबरी केखर लग करव? ऊ केखर जसना हबै? ");
INSERT INTO bhu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ऊ बजार हे बइठे हर लरकन के जसना हबै, जउन अक्ठी दूसर लग पुकार के कथै, हम तुम्हर निता बसुरी बजायन, पय तुम नेहको नाचे, हम तोर निता रोय के गाना गायन, पय तै नेहको रोय। ");
INSERT INTO bhu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","यूहन्ना बतिस्मा देय बाले अउ ऊ न रोटी खाइस अउ दाखरस पीइस अउ एखर हे तुम काहिन कथा, ओखर हे भुतवा लगे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","मनसे कर टोरवा आइस ऊ मनसे के जसना खात पियत हबै अउ तुम कथा, “देखा हइ मनसे लदहा अउ दरुहा हबै, पइसा उगाहै बाले के साहब अउ पापिन के संगी हबै। ");
INSERT INTO bhu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","पय भगवान के सिक्छा ओखर सगलू परजा दवारा परमाडित करे गय हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","अक्ठी फरीसी मनसे यीसु के अपन संग खाना खाय के निता बिनती करिस, यीसु उस फरीसी के घर छो गइस अउ खाना खाय के निता बइठ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","सहर के अक्ठी पापिन डउकी के हइ पता होथै, कि यीसु ऊ फरीसी मनसे के घर खाना खाथै, ता संगमरमर के बरतन हे महकनी तेल लइके आइस। ");
INSERT INTO bhu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","अउ रोउत यीसु के पाछू ओखर गोड के लिघ्घो ठाड हुइ गइस, अउ अपन आंसू लग यीसु के गोड धोय के अपन बाल लग पोछै लगिस, ऊ बेर-बेर ओखर गोड के चूमथै अउ महकनी तेल लगाथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","जउन फरीसी यीसु के नेउता देथै, ऊ हइ देखके मन ही मन कथै, “अगर हइ मनसे ग्यानी मनसे होतिस, ता जरूर जान जातिस, जउन डउकी इके छीथै ऊ कउन अउ कसना हबै, ऊ तो पापिन हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","यीसु समोन लग कथै, मोके तोर लग कुछु गुठेमै के हबै, ऊ जबाब दइस, हे गुरू गुठे। ");
INSERT INTO bhu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","यीसु कथै, कउनो बनिया के दुइठे करजा बाले मनसे रथै, अक्ठी के पांच सव चांदी के पइसा के करजा रथै अउ दूसर के लिघ्घो पचास के। ");
INSERT INTO bhu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","उनखर लिघ्घो करजा चुकामै के निता कुछु नेहको रहिस, इहैनिता बनिया दुनो के करजा के छमा के दइस, उन दुनो मसे कोनहर ओखर लग अधिक माया करी? ");
INSERT INTO bhu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","समोन जबाब दइस, मोर समझ हे उहै मनसे जेखर बोहत करजा छमा हुइस, “यीसु ओखर लग कथै, तै सही जबाब दइ हबस।” ");
INSERT INTO bhu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","तब यीसु मसीह पापिन डउकी के पल्ला मुडके समोन लग कथै, का तै हइ डउकी के देखथस, मै तोर घर छो आयों अउ तै मोके गोड धोबय के निता पानी नेहको दय, पय ई डउकी मोर गोड के अपन आंसू लग धोइस, अउ अपन मूड के चून्दी लग मोर गोड के पोंछिस। ");
INSERT INTO bhu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","तै चुम्मा लग मोर सोगत नेहको करे, पय जब लग तोर घर आय हव, तब लग ई डउकी मोर गोड के लगेतार चूमथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","तै मोर मूड हे तेल नेहको लगाय, पय ई डउकी मोर गोड हे महकनी तेल लगाय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","इहैनिता मै तोर लग कथो, एखर पाप जउन बोहत हबै छमा हुइ गय हबै, काखे हइ बोहत माया करे हबै, पय जेही चुटु छमा करे गय हबै, ऊ माया चुटु लग करथै। ");
INSERT INTO bhu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","तब यीसु ऊ डउकी लग कथै, “तोर पाप छमा हुइ गइस।” ");
INSERT INTO bhu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","यीसु के संग खाना खाय बाले अक दूसर लग गुठे लगथै, “हइ कउन हबै, जउन पापन के छमा करथै?” ");
INSERT INTO bhu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","पय यीसु ऊ डउकी लग कथै, “तोर बिस्वास तोर मदत करे हबै, सान्ति लग जा” ");
INSERT INTO bhu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","एखर कुछ टेम बाद यीसु सहर-सहर अउ गांव-गांव हे बाग-बाग के सिक्छा देथै, अउ भगवान कर राज के संदेस सुनामै लगिस अउ बारहठे चेला ओखर संग रथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","अउ कुछ डउकी रथै, जउन भुतवा अउ नांगा लग निक्खा होय रथै, मरियम जेखर उपनाम मगदलीनी रथै, अउ जेखर लग सातठे भुतवा निकरे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","हेरोदेस राजा के भन्डारी खुजा कर डउकी यूहन्ना, सूसन्नाह अउ बोहत डउकी रथै, जउन अपन खुद के डेरा लग यीसु अउ ओखर चेलन के सेबा के जुगाड करथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","मनसेन के बोहत भीड अक जिघा होथै, ता सहर के मनसे यीसु के लिघ्घो आथै ऊ टेम यीसु हइ किस्सा सुनाथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“अक्ठी किसान बिजहा बोमै निकडथै, बिजहा बोउत-बोउत कुछ बिजहा गली के टाठा हे गिरथै अउ उन गोड लग कचरे गइस अउ बादर के चिरइया उनके खाय लेथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","कुछ बिजहा पथरा बाले भुंइ हे गिरथै अउ ऊ जमथै निक्खा माटी नेहको मिलिस ता झुराय जथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","कुछ बिजहा कांटा बाले पुडरा के बीच हे गिरथै अउ संग-संग बढै बाले कांटा उके दबाय देथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","पय कुछ बिजहा निक्खा भुंइ हे गिरिस अउ जम के सव गुना फडुहा लाइस।” एतका गुठेके बाद यीसु पुकार के कथै, “जेखर सुनै के कान होय ऊ सुन ले।” ");
INSERT INTO bhu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","चेला यीसु लग पूछथै, हइ किस्सा के काहिन मतलब हबै? ");
INSERT INTO bhu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","यीसु कथै “भगवान के राज के छुपे हर बात जानै के निता सिक्छा तुमके दय गय हबै, पय दूसर के बलुक किस्सा मिले हबै, जेखर लग ऊ देखके नेहको देखही अउ सुनके नेहको समझही।” ");
INSERT INTO bhu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","हइ किस्सा के मतलब हइ मेर हबै, भगवान कर बचन बिजहा हबै। ");
INSERT INTO bhu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","गली के पाखा हे जउन बिजहा गिरथै, ऊ मनसे हबै, जउन बचन सुनथै, पय कहुं असना झइ होय कि ऊ बिस्वास करै अउ मुकति पाय ले, इहैनिता भुतवा आयके ओखर मन लग बचन लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","पथरा हे गिरेहर बिजहा ऊ मनसे हबै, जउन भगवान कर बचन के सुनके मगन लग उके सुइकार कर लेथै, पय उनखर हे जर नेहको हबै ऊ कुछ टेम बिस्वास करथै अउ परिक्छा के टेम उन बिस्वास हे ढिलवा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","कांटा बाले पुडरा हे गिरेहर बिजहा ऊ मनसे हबै जउन बचन सुनथै, पय आगू चलके उन चिन्ता धन डेरा अउ जीवन के अइसो अराम हे फस जथै अउ भगवान लग दुरिहां हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","निक्खा भुंइ लग गिरेहर बिजहा ऊ मनसे हबै, जउन बचन सुनके उके सच्चे अउ निस्कपट मन हे समार के रखथै अउ अपन धीर धरै के कारन फडुहा लानथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","यीसु कथै, कउनो मनसे चिमनी के जराय के भडवन के तरी नेहको मूंदथै अउ न उके खटिया के तरी धरथै, पय उके पिरभिटिया हे रखथै, ता घर के भित्तर आमै बाले मनसे के उजियार मिलै। ");
INSERT INTO bhu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","असना कुछ लुके नेहको हबै, जउन जाने नेहको जही अउ असना कुछ गुप्त नेहको हबै, जउन ग्यान अउ उजियार नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“यीसु कथै, एखर लग चवकस रहा, कि तुम कउन मेर सुनथा, काखे कि जेखर लिघ्घो हबै, उके अउ दय जही अउ जेखर लिघ्घो कुछु नेहको हबै, ओखर लिघ्घो लग वहु लइ ले जही जेही ऊ अपन समझथै।” ");
INSERT INTO bhu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","यीसु कर दाय अउ भाई ओखर लग मिलै आथै, पय मनसे के भीड के कारन ओखर लिघ्घो नेहको जाय सकथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","मनसे यीसु लग कथै, “तोर दाय अउ भाई बाहिर ठाड हबै, उन तोर लग मिलै चाहथै।” ");
INSERT INTO bhu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","पय यीसु उनके जबाब देथै, “मोर दाय अउ भाई उन हबै, जउन भगवान कर बचन सुनथै अउ उके मानथै।” ");
INSERT INTO bhu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","अक रोज यीसु अपन चेलन के संग नाह जिहाज हे चढथै अउ उनखर लग कथै, “आबा हम दहार के ऊ पल्ला चली” अउ उन नाह जिहाज हे बइठके चल देथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","जब नाह जिहाज चलत जथै, तब यीसु सोय जथै, उहै टेम दहार हे बोहत आंधी बडेरा आथै अउ उनखर नाह जिहाज हे पानी भरै लग जथै, अउ उन समस्या हे फस जथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","चेला यीसु के लिघ्घो आयके ओही जगाथै, अउ कथै, स्वामी-स्वामी हम बुडथन हमके बचाय ले, ता यीसु उठथै अउ आंधी बडेरा अउ लहरा के डांटथै, अउ ऊ थम गइस अउ उहां सान्ति छाय गइस। ");
INSERT INTO bhu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","तब यीसु अपन चेलन लग कथै, “तुम्हर बिस्वास कछो गइस?” उन डरथै अउ अचम्भित हुइके अक दूसर लग गुठेवै लग जथै, “हइ कउन मनसे हबै? हइ आंधी बडेरा अउ पानी के आदेस देथै अउ उन ओखर आदेस मानथै।” ");
INSERT INTO bhu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","यीसु नाह जिहाज लग उतर के गिरासेनियो के परदेस छो पहुंचथै, जउन दहार के ऊ पल्ला गलील परदेस के आगू हबै। ");
INSERT INTO bhu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","यीसु जब नाह जिहाज लग भुंइ लग उतरथै, ता ऊ सहर के अक्ठी भुतवा लग बइहा मनसे यीसु के लिघ्घो आइस, ऊ बोहत रोज ले खुरथा पइजामा नेहको पहनथै, अउ घर छो नेहको, बलुक मरघटियानी छो रहे करथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","यीसु के देखके चिरलाय उठथै अउ यीसु के गोड हे गिरके जोर आरो लग कथै, “हे परम परधान भगवान कर टोरवा यीसु, मोर लग तोके काहिन काम हबै? मै तोर लग बिनती करथो, मोके दुख झइ दे” ");
INSERT INTO bhu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","काखे यीसु भुतवा के ऊ मनसे मसे बाहिर निकर जाय का आदेस देथै, काखे भुतवा उके घरी-घरी पकर लेथै, अपन वस हे रखै के निता मनसे उके सांकड अउ डोरा लग बांध देथै, पय बांधे हर के टोर देथै अउ भुतवा उके पतेरा छो लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","यीसु ओखर लग पूछथै, “तोर नाम काहिन हबै?” ऊ कथै, मोर नाम सेना हबै, काखे ऊ मनसे हे बोहत लग भुतवा लगे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ऊ यीसु लग बिनती करके कथै, हमके नरक छो झइ पठो। ");
INSERT INTO bhu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","उहां डोंगर छो सुमरा के अक्ठी बोहत बडा झुन्ड चरथै, भुतवा यीसु लग बिनती करके कथै, हमके सूरा के झुन्ड हे जाय के आदेस दे अउ यीसु उनके सूरा के झुन्ड हे जाय के आदेस देथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","तब भुतवा ऊ मनसे मसे निकरके सुमरन के देह लग जाय घुसथै, ऊ सगलू सुमरा के झुन्ड डोंगर के टिल्ली लग तरी छो झील के दहार हे गिरथै अउ उन बुड के मर गइन। ");
INSERT INTO bhu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","35","हइ देखके सुमरा चरामै बाले बरेदी भाग गइन, अउ उन सहर अउ गांव हे एखर खबर फइलाय दइन। अउ जउन होने रहिस उके देखै के निता आथै, अउ यीसु के लिघ्घो आयके जउन मनसे लग भुतवा निकरे रथै, उके यीसु के गोड के लिघ्घो कपडा पहिरे अउ साथ बइठे हर देख के डर गइन। ");
INSERT INTO bhu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","जउन मनसे हइ सगलू अपन आंखी लग देखे रथै, उन मनसे के गुठेइस कि कउन मेर के भुतवा लग हइ मनसे परसान रहै, अब ऊ चंगा हुइ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","तब गिरासेनियो परदेस के अगल बगल के सगलू मनसे हइ बिनती करिन, “तै हमर इछो लग कढ जा” काखे उन मनसे बोहत डेराय गय रथै, यीसु नाह जिहाज हे बइठ के लउट गइस। ");
INSERT INTO bhu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","जउन मनसे के जीव ले भुतवा निकडथै, ऊ यीसु लग बिनती करके कथै, यीसु मोके अपन संग रहै दे पय ऊ उके बिदा करत कथै, ");
INSERT INTO bhu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","अपन घर छो लउट जा अउ मनसेन के हइ गुठे, कि भगवान तोर निता काहिन-काहिन करे हबै। ऊ कढ गइस अउ सगलू सहर हे परचार करै लग गइस, कि यीसु मोर निता बडा-बडा काम करे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","जब यीसु फेरै लउटथै, ता मनसे ओखर सोगत करथै, काखे उन सगलू मनसे यीसु के ओरगथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ता ऊ टेम बिनती भवन हे याइर नाम के अक्ठी मुखिया आइस, अउ यीसु के गोड लग गिरके बिनती करै लगिस कि ऊ ओखर इहां जाय के किरपा करे। ");
INSERT INTO bhu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","काखे ओखर बारह साल के टोरिया मरै बाले रथै, यीसु ओखर संग कढ गइस, गली हे मनसेन के भीड चउगिरदा पल्ला यीसु के दबाय डारथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","उहां अक्ठी डउकी बारह साल लग खून बोहय के नांगा हे रथै, ऊ अपन सगलू जीवन भर मेहनत के कमाई गुनिया हे खरचा कर चुकथै, अउ कउनो उके निक्खा नेहको कर सकिन। ");
INSERT INTO bhu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ऊ डउकी पाछू ले आयके यीसु के कपडा के चुप्पे लग छि लेथै, अउ उहै टेम ओखर खून बोहय के बन्द हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","यीसु कथै, “मोके कोनहर छिय हबै?” जब सगलू मनसे मना करथै, ता पतरस अउ ओखर संगी यीसु लग कथै, “हे स्वामी मनसेन के बोहत भीड हबै, अउ तोर गोड तरी गिरे पडथै अउ तैहां पूछथस कि मोके कोनहर छिय हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","पय यीसु कथै, “कोनो मोके बिस्वास लग छिय हबै, काखे कि मै अनुभव करे हव कि मोर लग सक्ति निकरे हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","जब डउकी हइ देखथै मै नेहको लुक सकथों, ता ऊ डेरात आइस अउ यीसु के गोड हे गिर जथै, अउ सगलू मनसेन के आगू गुठेइस कि परभु मै तोके छिय हबो, काखे मोके बारह साल लग नांगा हे रहों, अउ मै अपन सगलू डेरा के गुनिया पंडा हे लुटाय चुके हबो, पय निक्खा नेहको होयों, इहैनिता मै तोर बन्डी के छिय हबो, अउ मै हरबी निक्खा हुइ गय हव। ");
INSERT INTO bhu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","यीसु ओखर लग कथै, “टोरिया तोर बिस्वास तोके निक्खा करे हबै, सान्ति लग घर जा।” ");
INSERT INTO bhu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","यीसु ई बात के कहत रहिस, ता ओतकै टेम बिनती भवन के मुखिया इहां लग अक्ठी मनसे आइस, अउ कथै, “तोर टोरिया मर गय हबै, अब तै गुरू के परसान झइ कर।” ");
INSERT INTO bhu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","हइ सुनके यीसु ओखर लग कथै, “झइ डर बस बिस्वास कर, ऊ चंगा हुइ जही।” ");
INSERT INTO bhu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","जब यीसु याइर के घर छो पहुंचिस ता उन पतरस यूहन्ना याकूब अउ टोरिया के दाय-बाफ के छांड के कउनो के अपन संग घर के भित्तर नेहको आमै देथै। ");
INSERT INTO bhu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","सगलू मनसे रोथै अउ ओखर निता विलाप करथै, यीसु कथै, “झइ रोबा, ऊ मरे नेहको हबै, बलुक टोरिया सोथै।” ");
INSERT INTO bhu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","उन यीसु के खिल्ली उडामै लागथै, काखे उन जानथै कि ऊ मर गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","यीसु टोरिया के हाथ पकड के कथै, “हे टोरिया उठ।” ");
INSERT INTO bhu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","टोरिया के परान लउट आइस अउ उहै टेम उठ बइठिस, यीसु आदेस दइस कि उके कुछु खाय के देया। ");
INSERT INTO bhu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","टोरिया के दाय बाफ चकित हुइ गइन, पय यीसु आदेस दइस कि हइ घटना के चरचा कउनोन लग झइ करबे। ");
INSERT INTO bhu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","यीसु बारहठे चेलन के अक्कै संग बुलवाथै, अउ उनही सगलू भुतवा अउ बिमारी के निक्खा करै के सक्ति अउ हक दइस। ");
INSERT INTO bhu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","यीसु उनके भगवान कर राज के परचार करै के अउ नंगहन के निक्खा करै के निता पठोइस। ");
INSERT INTO bhu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","यीसु चेलन लग कथै, “रास्ता के निता कुछु झइ लइहा, न डंडा न झोरा अउ न खाय के निता रोटी, न पइसा लइहा अउ अपन निता दुइ दुइठे खुरथा पइजामा झइ रखबे। ");
INSERT INTO bhu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","जउन घर हे जइहा उहै छो रइहा अउ उहै लग बिदा हुइ जइहा। ");
INSERT INTO bhu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","अगर मनसे तुम्हर सोगत नेहको करही, ता तुम उनखर सहर लग निकरै के बाद अपन गोड के धूधुर के झार दइहा, कि उनखर हे गवाह होय।” ");
INSERT INTO bhu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","चेला चले गइन अउ सब के संदेस सुनाउत अउ मनसेन के निक्खा करत गांव-गांव घूमै लगिन। ");
INSERT INTO bhu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","सासक हेरोदेस हइ सगलू बातन के चरचा सुनके सोंच हे पड गइस, काखे कुछ मनसे कथै कि यूहन्ना मरे हर मसे जिन्दा हुइ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","कुछ मनसे कथै, एलिय्याह परगट होय हबै, अउ कुछ मनसे कथै, कि पुरान ग्यानी मनसेन मसे कउ ग्यानी मनसे फेरै जिन्दा हुइ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","हेरोदेस राजा लग कथै, “यूहन्ना कर मूड मै खुद कटवाय दय रहों, फेर हइ कउन हबै? जेखर बारे हे मै असना बात सुनथो?” अउ ऊ यीसु लग मिलै के इक्छा करथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","चेला लउट के आइन अउ यीसु के गुठेइन कि उन मनसेन काहिन-काहिन करे हबै, यीसु उनके अपन संग लइके बैतसदा सहर के पल्ला सुनसान जिघा हे लइ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","पय मनसेन के एखर बारे हे पता हुइ गइस, अउ उनो ओखर पाछू हुइ लेथै, यीसु उनखर सोगत करिस, भगवान कर राज के बारे हे गुठेइस अउ जिनही निक्खा होय के जरूरत रथै उनही निक्खा करिस। ");
INSERT INTO bhu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","सांझ होंय बाले रथै, इहैनिता बारहठे चेला यीसु के लिघ्घो आयके कथै, “मनसेन के भीड के पठोय दे, ता उन अगल-बगल के गांव हे जाय के रहै के निता, अउ खाय के निता जुगाड कर सकै, काखे इहां हम सुनसान जिघा हे हवन।” ");
INSERT INTO bhu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","यीसु अपन चेलन के जबाब दइस, “तुमिन उनही खाय के देया” ता चेला कथै, “हमर लिघ्घो पांचठे रोटी अउ दुइठे मछडी हबै अउ एखर सिबाय हमार लिघ्घो कुछु नेहको हबै, तै काहिन चाहथस कि हमिन खुद जायके इन सगलू मनसेन के निता खाना खरीदी?” ");
INSERT INTO bhu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","उछो करीबन पांच हजार डउका रथै, यीसु अपन चेलन लग कथै, “उन मनसेन के पचास-पचास के झुन्ड हे उनके बइठा देया।” ");
INSERT INTO bhu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","अउ चेला ओसनेन करिन अउ सब के बइठा दइन। ");
INSERT INTO bhu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","तब यीसु पांचठे रोटी अउ दुइठे मछडी हाथ हे लइके स्वरग पल्ला देखके भगवान के धन्यबाद देथै, अउ फेर रोटी के टोरिस, अउ अपन चेलन के दइस, ता उन मनसेन के पोरसै। ");
INSERT INTO bhu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","सगलू मनसे मछडी अउ रोटी खायके अघाय गइन, अउ बचे हर रोटी के खन्डा लग बारा छन्नी भर गइस। ");
INSERT INTO bhu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","यीसु अक रोज अकान्त जिघा हे बिनती करथै, अउ चेला ओखर संग रथै, ता यीसु अपन चेलन लग पूछथै, “मै कोन हबो, मोर बारे हे मनसे काहिन कथै?” ");
INSERT INTO bhu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","“उन जबाब दइन, यूहन्ना बतिस्मा देय बाले अउ कुछ मनसे कथै, एलिय्याह अउ कुछ मनसे कथै, पुरान ग्यानी मनसे मसे कउनो आगू कर बात गुठे बाले जउन फेरै जिन्दा हुइ गय हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","यीसु उनखर लग कथै “पय तुम काहिन कथा?” कि मै कोनहर हव? चेलन मसे पतरस जबाब दइस, “भगवान कर मसीह” ");
INSERT INTO bhu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","यीसु अपन चेलन के कडी चेतावनी अउ आदेस दइस, कि उन हइ बात कउनो के झइ गुठेमै। ");
INSERT INTO bhu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","यीसु कथै, “मनसे कर टोरवा के बोहत परेसानी उठामै के होही, हइ जरूरी हबै सियान अउ पंडित अउ नियाव के गुरू दवारा बेकार समझ के मार डरहीं अउ ऊ तीसर रोज जिन्दा हुइ जाय।” ");
INSERT INTO bhu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","तब यीसु सगलू मनसेन लग कथै, “जउन मोर अनुसरन करै चाहथै, ऊ आत्मतयाग करै अउ सबरोज अपन क्रूस उठायके मोर पाछू हुइ ले। ");
INSERT INTO bhu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","काखे जउन अपन जीव बचामै चाहथै, ऊ यीसु के खोय दइ अउ जउन मोर कारन अपन जीव खोही, उहै उके सुरक्छित रखही। ");
INSERT INTO bhu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","मनसे के एखर लग काहिन फायदा, अगर ऊ सगलू दुनिया के पाय लइ, पय अपन खुद के गमाय दइ। ");
INSERT INTO bhu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","जउन मोके अउ मोर सिक्छा के मानै हे लजाथै, ता मनसे कर टोरवा सुइकार करै हे लजई, जब ऊ अपन बाफ अउ पवितर स्वरगदूत के महिमा के संग आही। ");
INSERT INTO bhu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","मै तुम्हर लग सही कथो, इहां ठाड मनसेन मसे कुछ असना मनसे हबै, तब तक मिरतू के स्वाद नेहको चकही, जब तक उन भगवान कर राज नेहको देख लइहिन।” ");
INSERT INTO bhu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","हइ बातन के कउनो आठै रोज बाद यीसु पतरस, यूहन्ना अउ याकूब के अपन संग लइ गइस, अउ बिनती करै के निता अक्ठी डोंगर हे गइस। ");
INSERT INTO bhu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ता बिनती करत टेम यीसु के चेहरा सकल बदल गइस, अउ ओखर खुरथा पइजामा चरका हुइके चमकथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","अचनकै चेला दुइठे डउकन के यीसु के संग बात करत देखिन, उन मूसा अउ एलिय्याह रथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","अउ उन महिमा के संग दिखाई दइन, अउ ओखर मरै के बारे हे गुठेथै, जउन यरुसलेम सहर छो होय बाले रथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पतरस अउ ओखर संगी भारी नींद हे सोय रथै, जब पूर तरह अपन नींद लग जाग उठथै, ता उन यीसु के महिमा के अउ ओखर संग ठाडे दुइठे डउकन के देखिन। ");
INSERT INTO bhu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","मूसा अउ एलिय्याह यीसु के लिघ्घो लग जाय लागथै, पतरस यीसु लग कथै, हे परभु हमके इहां रहै के निता बढिहा हबै, हम इछो तीनठे तम्बू बनाबो, अक्ठी तोर निता अक्ठी मूसा कर निता अउ अक्ठी एलिय्याह कर निता, उके पता नेहको रथै, कि ऊ काहिन कथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","जब पतरस हइ बात कहत रथै, कि बादर उके आयके उनके ढाप लइस, ता उन डेराय गइन। ");
INSERT INTO bhu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","बादर मसे अक्ठी आरो सुनाई दइस, “हइ मोर टोरवा हबै, मोर चुने हर, एखर आदेस के माना।” ");
INSERT INTO bhu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","आरो बन्द होय के बाद यीसु अकेल्ले दिखाई दइस, चेला एखर बारे हे चुप रथै, अउ उन जउन देखथै, ओखर बारे हे ऊ रोज कउन लग कुछु नेहको कथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","दूसर रोज डोंगर लग उतरै के बाद हे, अक्ठी बडा मनसेन के भीड यीसु लग मिलै के निता आथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","भीड मसे अक्ठी मनसे चिरलाय के कथै, “हे गुरू तोर लग हइ बिनती हबै, कि तै मोर टोरवा के चंगा कर दे, काखे मोर अक्ठिन टोरवा हबै। ");
INSERT INTO bhu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","उके अक्ठी भुतवा पकडथै, जेखर लग ऊ चिरला उठथै, भुतवा उके असना मरोडथै, कि ओखर मुंह लग गजरा निकरै लागथै अउ उके अधमरहा कर देथै अउ बोहत कठिनाई लग उके छांडथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","मै तोर चेलन लग निकारै के बिनती करे रहों, पय ऊ भुतवा के नेहको निकार सकिन।” ");
INSERT INTO bhu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","यीसु जबाब दइस, “हे अबिस्वासी अउ गरजुहा मनसे अउ जिद करै बाले मनसे मै कब तक तुम्हर संग रइहों अउ तुम्हर बात कब तक सइहों? अपन टोरवा के मोर लिघ्घो लान।” ");
INSERT INTO bhu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","जब टोरवा यीसु के लिघ्घो आथै, ता भुतवा फेरै उके भुंइ हे पटक के मरोडै लागथै, पय यीसु भुतवा के डांटिस, अउ भुतवा टोरवा के जीवन लग निकड गइस, यीसु टोरवा के निक्खा करके ओखर बाफ के सउप दइस। ");
INSERT INTO bhu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","भगवान के हइ काम देखके, सगलू मनसे चकित हुइ जथै। सगलू मनसे यीसु के काम के देखके चकित हुइ जथै, ता यीसु अपन चेलन लग कथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","जउन बात मै कथो, तुम धियान लग सुना, मनसे कर टोरवा यीसु मनसे के हाथ हे पकडोय बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","पय हइ बात उनखर समझ हे नेहको आइस, एखर मतलब उनखर लग लुके रही गइस, कि कहुं उन समझ न ले, उन एखर बारे हे यीसु लग पूछै के डरथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","चेलन के बीच हइ बात के लइके बिबाद हुइस, कि ओखर मसे सबले बड्डे कोनहर हबै। ");
INSERT INTO bhu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","यीसु हइ बात जान जथै, कि उनखर मन हे काहिन हबै, ता ऊ अपन लिघ्घो अक्ठी लरका के ठाड करिस, ");
INSERT INTO bhu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","अउ उनखर लग कथै, जउन कउ मोर नाम लग हइ लरका के सोगत करथै, ऊ मोर सोगत करथै, अउ जउन मोर सोगत करथै, ऊ भगवान के सोगत करथै, जउन मोके पठोय हबै, काखे तुम्हर मसे जउन नान हबै, उहै बड्डे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","यूहन्ना कथै, “हे परभु हम अक्ठी मनसे के तोर नाम लइके भुतवा के निकारत देखे हवन, ता हम उके रोकै के परयास करेन, काखे ऊ हमर जसना तोर अनुसरन नेहको करथै।” ");
INSERT INTO bhu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","यीसु यूहन्ना लग कथै, “उके झइ रोक काखे जउन तुम्हर बैरी नेहको हबै, ऊ तुम्हर पल्ला हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","जब यीसु के स्वरग छो उठाय लय जाय के रोज लिघ्घो आइस, तब यीसु यरुसलेम सहर छो जाय के सोंचथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","यीसु संदेस देय बाले के अपन आगू पठोइस, उन आगू गइन अउ सामरिया के अक्ठी गांव हे पहुंचिन, यीसु के आमै के तइयारी करै। ");
INSERT INTO bhu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","पय उहां के मनसे यीसु के सोगत नेहको करिन, काखे ऊ यरुसलेम सहर छो जथै। ");
INSERT INTO bhu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","जब ओखर चेला याकूब अउ यूहन्ना हइ देखथै, ता सबाल करिन, “परभु अगर तै आदेस दे, ता हम बिनती करी कि बादर ले इनही नास करै के निता आगी के बारिस हुइ जाय” ");
INSERT INTO bhu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","यीसु उनखर पल्ला घूमके उनके डांटथै अउ कथै, तुम नेहको समझथा, तुम हइ कउन मतलब लग कथा। ");
INSERT INTO bhu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","मनसे कर टोरवा मनसेन के मारै के निता नेहको आय हबै, पय उनखर मुकति करे के निता आय हबै, अउ ऊ दूसर गांव छो कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","यीसु अपन चेलन के संग यातरा करथै, ता गली हे कउनो कथै, “तै जिहां कहुं जइहे, महुं तोर पाछू-पाछू जइहों।” ");
INSERT INTO bhu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","यीसु जबाब देथै, “सिकटा के लिघ्घो रहै के निता माडा रथै, अउ बादर छो उडै बाले चिरइया के गोंदा रथै, पय मनसे कर टोरवा यीसु के निता मूड धरै के जिघा नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","यीसु दूसर मनसे लग कथै, मोर पाछू आ, पय ऊ जबाब देथै, “परभु मोके पहिले अपन बाफ के लोथ के गाडयाओ।” ");
INSERT INTO bhu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ता यीसु ओखर लग कथै, “मरे हर के लोथ गाडै दे, पय तै जायके भगवान कर राज के बारे हे मनसेन के गुठे।” ");
INSERT INTO bhu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","फेर दूसर कउ बोलिस, “परभु मै तोर संग जइहों, पय आगू मोर अपन घर बालेन लग बिदाई लइ आओ।” ");
INSERT INTO bhu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","“यीसु ओखर लग कथै, नागर के मुठिया पकरै के बाद जउन मुडके पाछू देखथै, ऊ भगवान कर राज के काबिल नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","एखर बाद परभु बहत्तरठे चेलन के चुनथै, अउ जउन-जउन सहर अउ गांव हे खुदय जाय बाले रथै, उहां दुइ-दुइ करके उनके अपन आगू पठोइस। ");
INSERT INTO bhu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","यीसु उनखर लग कथै, फसल बोहत हबै, पय मजदुरिहा चुटु हस हबै, इहैनिता फसल के मालिक लग बिनती करा कि ऊ अपन फसल काटै के निता मजदुरिहा के पठोबै। ");
INSERT INTO bhu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","जा मै तुमही बिगवा के बीच मेमना के तरह पठोथो। ");
INSERT INTO bhu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","तुम न थइला, न झोरा अउ न बूट लइ जइहा, अउ न गली हे कउनो के नमस्ते करिहा। ");
INSERT INTO bhu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","जब कउनो घर छो जइहा, ता सबले पहिले हइ कइहा, हइ घर हे सान्ति होय। ");
INSERT INTO bhu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","अगर उहां कउ सान्ति के काबिल होही, ता ओखर हे तुम्हर सान्ति रुकही, अगर असना नेहको होथै, ता सान्ति तुम्हर लिघ्घो लउट आही। ");
INSERT INTO bhu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","उहै घर छो रुके रइहा, अउ ओखर लिघ्घो जउन होही, उहै खइहा पीहा, काखे मजदूर के ओखर मजदूरी मिलै चाही, घर-घर झइ जइहा। ");
INSERT INTO bhu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","जब तुम कउनो सहर छो जइहा, अउ मनसे तुम्हर सोगत करही, ता जउन कुछु तुमही परोसही, उहै खइहा। ");
INSERT INTO bhu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","उहां के नंगहन के निक्खा करिहा, अउ उनखर लग कइहा, भगवान कर राज तुम्हर लिघ्घो आय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","अगर तुम कउनो सहर हे जथा, अउ मनसे तुम्हर सोगत नेहको करही, ता उहां के बजारन हे जायके कइहा, ");
INSERT INTO bhu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","अपन गोड हे लगे हर तुम्हर सहर के धूधुर हम तुम्हर आगू झार देथन, तब जान लेया कि भगवान कर राज लिघ्घो आ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","मै तुम्हर लग हइ कथो, ऊ रोज लग ऊ सहर के हालत के अपेक्छा सदोम के हालत कही अधिक सहै लायक होही। ");
INSERT INTO bhu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","तुम्हर हे हाय हबै खुराजीन सहर हाय हबै, बैतसदा सहर तुम्हर हे अगर उन सक्ति के काम तुम्हर हे करे गय हबै, हइ काम सूर अउ सैदा सहर छो करे गय होतिस, ता फट्टी ओढ के अउ राख हे बइठ के सगलू पाप लग मन बदल के बिनती कर लय होतिन। ");
INSERT INTO bhu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","इहैनिता नियाव के टेम तुम्हर हालत के अपेक्छा सूर अउ सैदा के हालत कहुं अधिक सहै लायक होही। ");
INSERT INTO bhu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","अउ तै कफरनहूम का तै स्वरग ले उप्पर उठाय जइहे? बिलकुन नेहको, तोके तो तरी नरक छो गिराय दय जही। ");
INSERT INTO bhu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“जउन तुम्हर बात सुनथै, ऊ मोर बात सुनथै, अउ जउन तुम्हर तिरस्कार करथै, ऊ मोर तिरस्कार करथै, अउ जउन मोर तिरस्कार, ऊ ओखर तिरस्कार करथै जउन मोके पठोय हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","उन बहत्तरठे चेला मगन हुइके वापिस लउटिन, अउ बोलिन, “परभु भुतवा तक तोर नाम हे, हमर आदेस मानथै।” ");
INSERT INTO bhu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","यीसु उनही जबाब दइस, “मै भुतवा के स्वरग लग बिजली के जसना स्वरग लग गिरत देखे हव। ");
INSERT INTO bhu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","यीसु अपन चेलन लग कथै, सुना मै तुमके सपुवा अउ बीछी के गोड लग कचरै, अउ बैरी के सगलू सक्ति के कुचरै के सक्ति दय हबो, अउ कउनो तुमही नुसकान नेहको पहुंचाय सकही। ");
INSERT INTO bhu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","पय इहैनिता मगन झइ हुइहा, कि भुतवा तुम्हर वस हे हबै, बलुक इहैनिता मगन हुइहा, कि तुम्हर नाम स्वरग छो लिखे गय हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","उहै टेम यीसु पवितर आतमा हे हुइके मगन लग भर के कथै, हे बाफ स्वरग अउ भुंइ के परभु मै तोके धन्यबाद देथो, काखे तै हइ बात ग्यानिन अउ होसियारन लग छुपाय रखे, पय लरकन हे परगट करे हस, हव बाफ इहै तोके बढिहा लगिस। ");
INSERT INTO bhu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","सगलू कुछ मोर बाफ दवारा सउपे गय हबै, कउनो नेहको जानथै, कि टोरवा कोन हबै, सिबाय बाफ के सिबाय कउ नेहको जानथै, कि बाफ कोन हबै, पय बलुक टोरवा अउ ऊ जेखर हे टोरवा उके परगट करै के सही समझिस। ");
INSERT INTO bhu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","तब यीसु अपन चेलन के पल्ला घूमके अकान्त हे उनखर लग कथै, “धन्य हबै ऊ आंखी, जउन हइ सगलू कुछ देखथै, जेही तुम देखथा। ");
INSERT INTO bhu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","काखे मै तुम्हर लग कथो, तुम जउन कुछ देखथा, उनके केतका ग्यानी मनसे अउ राजा देखै चाहथै, पय उन उके नेहको देख पाइन, अउ जउन बात तुम सुनथा, उन उके सुनै चाहथै, पय उन उके सुन नेहको पाइन।” ");
INSERT INTO bhu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","तब अक्ठी नियम के गुरू ठाड होथै अउ यीसु के परिक्छा लय के निता यीसु लग पूछथै, हे “गुरू सबरोज के जीवन पामै के निता मोके काहिन करै के चाही?” ");
INSERT INTO bhu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","यीसु ओखर लग कथै, “मूसा कर नियम हे काहिन लिखररे हबै? ओहमा तुम काहिन पढथस?” ");
INSERT INTO bhu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","पुजारी जबाब देथै, तै “अपन परभु भगवान के अपन सगलू मन अउ अपन सगलू परान, अउ अपन सगलू सक्ति अउ सगलू दिमाक लग अपन परभु लग माया करा, अउ अपन परोसी के अपन मेर माया करा।” ");
INSERT INTO bhu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","यीसु पुजारी लग कथै, “तै निक्खा जबाब दय, इहै करा, ता तुम जिन्दा रइहा।” ");
INSERT INTO bhu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","पय ऊ अपन खुद के धरमी मनसे दिखामै के निता यीसु लग पूछथै, “ता मोर परोसी कोनहर हबै?” ");
INSERT INTO bhu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","यीसु उके जबाब दइस, “अक्ठी मनसे यरुसलेम सहर ले यरीहो सहर छो जथै, अउ चोरटा उके चउगिरदा घेर लइन, अउ ओखर बन्डी झटक लइन अउ उके मारपीट के अउ अधमरहा छांडके कढ गइन। ");
INSERT INTO bhu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","उहै गली छो अक्ठी पुजारी गुजरथै, अउ उके अधमरहा मनसे के देखके ऊ कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","उहैमेर अक्ठी लेवी नाम के मनसे उहां आइस, अउ उहो उके देखके कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","अक्ठी सामरी यातरी उहै गली लग हुइके जथै, ता उके देखके ऊ दया लग भर गइस। ");
INSERT INTO bhu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ऊ ओखर लिघ्घो गइस अउ ऊ ओखर खत्ता हे तेल अउ दाखरस डालके चिथरा बांधथै, अउ ऊ अपन घोडवा हे बैइठाय के उके धरमसाला हे लइ गइस अउ ऊ ओखर देखरेख करथै। ");
INSERT INTO bhu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","दूसर रोज सामरी यातरी धरमसाला के मालिक के दुइठे चांदी के पइसा दइके कथै, एखर धियान रखबे, अउ एखर लग अधिक जउन कुछ तोर खरचा होही, ता लउटके आहुं ता चुकाय दइहों।” ");
INSERT INTO bhu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","यीसु नियाव के गुरू लग पूछथै, गुठे तोर सोंच लग चोरटन के बीच हे घेररे हर मनसे के परोसी इन तीनठे मसे कोनहर हुइस? ");
INSERT INTO bhu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","नियाव के गुरू कथै, “उहै मनसे जउन ओखर हे दया करिस।” यीसु कथै, “जा तहु ओसनेन कर, जसना ऊ करिस।” ");
INSERT INTO bhu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","यीसु अउ ओखर चेला यातरा करथै, तब यीसु अक्ठी गांव छो पहुंचथै, उहां मारथा नाम के अक्ठी डउकी अपन घर छो यीसु के सोगत करिस। ");
INSERT INTO bhu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","अउ मरियम नाम के ओखर अक्ठी बेहन रथै, ऊ परभु यीसु के गोड के लिघ्घो बइठके, यीसु के सिक्छा सुनथै। ");
INSERT INTO bhu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","पय मारथा सेबा करत चिन्तित हुइ गइस, अउ यीसु के लिघ्घो आयके कथै, परभु तोके कुछ चिन्ता नेहको हबै, कि मोर बेहन काम के पूर भार मोके अक्केलेन दइ दय हबै? उके कहि दे कि ऊ मोर मदत करै। ");
INSERT INTO bhu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","परभु उके जबाब देथै, “मारथा हे मारथा तै बोहत बातन के बारे हे चिन्तित अउ परसान रथस। ");
INSERT INTO bhu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","यीसु कथै, बलुक अक्ठिन बात जरूरी हबै मरियम बडा भाग चुने हबै, जउन ओखर लग छंडाय नेहको जही।” ");
INSERT INTO bhu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","अक रोज यीसु कउनो जिघा हे बिनती करथै, बिनती समापत होय लग ओखर अक्ठी चेला यीसु लग कथै, “परभु हमके बिनती करै के सिखा, जसना यूहन्ना अपन चेलन के सिखाय हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","यीसु चेलन लग कथै, जब तुम बिनती करथा, तब हइ कहा, हे हमर बाफ तोर नाम पवितर माने जाय, तोर राज आबै। ");
INSERT INTO bhu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","हमर रोज दिना के रोटी दय के। ");
INSERT INTO bhu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","हमर पाप छमा के, काखे हमु अपन बैरिन के छमा करथन, अउ हमके परिक्छा हे झइ पडै दे। ");
INSERT INTO bhu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","यीसु चेलन लग हइ कथै, “मान लेया कि तुम्हर हे कउनो आधा रात के अपन कउनो संगी के लिघ्घो जायके कही, संगी मोके तीनठे रोटी उधार देया। ");
INSERT INTO bhu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","काखे मोर अक्ठी संगी यातरा करके मोर घर छो आय हबै, उके भात खबामै के निता मोर लिघ्घो कुछु नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","अउ ऊ घर के भित्तर लग जबाब दे, मोके परेसान झइ कर, अब कंवाड बन्द हुइ चुके हबै, अउ मोर लरका बच्चा मोर संग डसना लग हबै, मै उठके तुमके कुछु नेहको दइ सकथों। ");
INSERT INTO bhu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","मै तुम्हर लग कथो, ऊ संगी के चलते भले उठके उके कुछु झइ दे, पय ओखर लाज छांडके मांगै के कारन ऊ उठी अउ ओखर जरूरत पूर करी। ");
INSERT INTO bhu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","मै तुम लग कथो, मंगिहा ता तुमके दय जही, खोजिहा ता तुम पइहा, अउ ठकठकइहा ता तुम्हर निता कंवाड उघाडे जही। ");
INSERT INTO bhu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","काखे मांगथै, उके मिलथै, जउन खोजथै, ऊ पाथै, अउ जउन ठकठकाथै, ओखर निता कंवाड उघाडे जथै। ");
INSERT INTO bhu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","अगर तुम्हर टोरवा तुम्हर लग मछडी मांगी, ता तुम्हर मसे असना कउन बाफ हबै, जउन मछडी के बदला उके सपुवा दइ? ");
INSERT INTO bhu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","मतलब अडवा मांगै, ता उके बीछी दइ? ");
INSERT INTO bhu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","बेकार होय लग तुम अपन लरकन के सबले निक्खा चीज देथा, ता स्वरग हे रहै बाले बाफ अपन मांगै बालेन के पवितर आतमा काखे नेहको देही?” ");
INSERT INTO bhu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","यीसु अक्ठी भुतवा के जउन बउरा रथै, भुतवा के निकाडथै बउरा मनसे बोलै लगिस अउ मनसे चकित हे पड गइन। ");
INSERT INTO bhu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","पय उन मसे कुछ मनसे कथै, “हइ भुतवा के मुखिया के मदत लग भुतवन के निकाडथै।” ");
INSERT INTO bhu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","कुछ मनसे यीसु के परिक्छा लेय के निता उनखर लग स्वरग के कउनो चिन्ह मांगिस। ");
INSERT INTO bhu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","पय यीसु जानथै कि उन का सोचथै, यीसु उनखर लग कथै जउन राज हे फूट पड जथै, ऊ राज उजड जथै अउ जउन परवार हे फूट पड जथै, ऊ परवार बरबाद हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","अगर भुतवा अपन बिरोध काम करै लग जाय ता ओखर राज स्थिर कसके रह सकथै? मै सब इहैनिता कथो, काखे तुम कथा, कि मै भुतवा के मदत लग भूत निकाडथों। ");
INSERT INTO bhu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","भुतवा के परेतन के मदत लग निकाडथों, ता तुम्हर टोरवा केखर मदत ले उनके निकाडथै? इहैनिता ऊ तुम्हर नियाव करी। ");
INSERT INTO bhu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","पय अगर मै भगवान के मदद लग भूत परेत के निकाडथों, ता भगवान कर राज तुम्हर लिघ्घो आय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","जब अक्ठी बलवान मनसे हथियार बांध के अपन घर ता ओखर धन डेरा के कउ नेहको चोरथै। ");
INSERT INTO bhu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","पय ओखर लग बोहत बलवान कउनो मनसे ओखर हे टूट पडै अउ उके हराय दे, ता जउन हथियार के भरोसा करथै, झटक लेथै, ता ऊ ओखर डेरा के लूट बांट देथै। ");
INSERT INTO bhu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","जउन मनसे मोर संग नेहको हबै, ऊ मोर बैरी हबै अउ जउन मनसे मोर संग नेहको बटोरथै ऊ बगराथै। ");
INSERT INTO bhu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","जब असुध्द आतमा कउनो मनसेन लग बाहिर निकरथै, ता ऊ अराम खोजै के निता सुखाय हर जिघा हे भटकथै फिरथै, आराम नेहको मिलै लग ऊ कथै, जिहां लग मै आय हबो, उहै अपन घर छो फेरै लउट जहुं। ");
INSERT INTO bhu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","लउटै लग ऊ घर के साफ सुथरा अउ सजे सजाय पाथै। ");
INSERT INTO bhu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","तब ऊ जायके अपन ले बोहत बेकार सातठे अउ भुतवन के अपन संग लइ आनथै, अउ ओहमा अमाय जथै जेहमा पहिले रथै अउ उस मनसे के हालत पहिले लग अउ बोहत बेकार हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","यीसु मसीह जब हइ सिक्छा देथै, ता भीड मसे अक्ठी डउकी पुकार के कथै, “धन्य हबै ऊ डउकी जउन तोके पइदा करे हबै अउ तोर पालन पोसड करे हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","पय यीसु कथै, “धन्य हबै ऊ मनसे, जउन भगवान के बचन सुनथै अउ उके मानथै।” ");
INSERT INTO bhu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","जब मनसेन के भीड अक जिघा होय लगिन, ता यीसु कथै, हइ बेकार मनसे हबै, काखे इन मनसे कुछ निसानी चाहथै, इहैनिता योना के निसानी के सिबाय उनके अउ कोनो निसानी नेहको दय जही। ");
INSERT INTO bhu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","जउन मेर योना नीनवे सहर के रहै बालेन के अक्ठी निसानी बन गय रथै, उहै मेर मनसे कर टोरवा हइ पीढी के निता अक्ठी निसानी बनही। ");
INSERT INTO bhu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","नियाव के रोज दख्खिन देस के रानी हइ पीढी के मनसेन के संग ठाढ हुइ ऊ उनके दोस ठहराही, काखे ऊ सुलेमान के दिमाक लग परिपूर बात सुनै के निता दुनिया के ओराछोर लग, अउ देखा ऊ हइ हबै, जउन सुलेमान लग बड्डे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","नीनवे सहर के मनसे नियाव के रोज हइ पीढी के संग अक जिघा हुइहिन, अउ हइ पीढी के बुराई करही, काखे उन योना के परचार सुनके मन फिराय रथै, पय आज इहां ऊ ग्यानी मनसे यूहन्ना लग बडा हबै। ");
INSERT INTO bhu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“कउनो मनसे चिमनी जलाय के कोनो मनसे उके असना जिघा हे लुकोय के नेहको धरथै, जिहां ऊ लुक जाय अउ न कउनो भडवा के तरी, पय उके सही पिरभिटिया हे धरथै, कि जेखर लग भित्तर आमै बाले मनसे देख सकै। ");
INSERT INTO bhu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","तुम्हर आंखी तुम्हर देह के चिमनी हबै, अगर तुम्हर निक्खा आंखी हबै, ता तुम्हर सगलू आंखी उजियार रही, पय अगर तुम्हर आंखी खराब हुइ जइ, ता तुम्हर सगलू देह अंधियार हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","इहैनिता हइ बात के सुरता करा, कि जउन उजियार तुम्हर हे हबै, ऊ अंधियार झइ हुइ जाय। ");
INSERT INTO bhu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","अगर तुम्हर सगलू देह उजियार हे हबै अउ ओखर कोनो देह हे अंधियार नेहको हबै, ता ऊ सगलू जिघा उजियार दइ, जसना अक्ठी चिमनी जलाय लग तुमके उजियार करथै।” ");
INSERT INTO bhu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","जब यीसु मसीह अपन संदेस खतम कर चुकथै, ता अक्ठी फरीसी मनसे यीसु के भोजन करै के निता बिनती करिस, यीसु मसीह ओखर संग गइस अउ भोजन करै के निता बइठ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","फरीसी हइ देखके कि चकित हुइस, कि यीसु भोजन लग आगू अपन हाथ गोड नेहको धोय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","परभु ओखर लग कथै, हे फरीसी मनसे तुम खोरिया अउ टठिया के बाहिर लग मांजथा धोथा, पय तुम्हर देह के भित्तर लालच अउ बुराई भरे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","हे मूरुख मनसे जउन बाहिर भाग के बनाय हबै, का उहै भीतरी भाग के नेहको बनाय हबै? ");
INSERT INTO bhu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","तुम्हर हे जउन भित्तर बसे हबै, उके दान हे दइ देया, तब तुम अउ तुम्हर सगलू कुछ सुध्द हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“हे फरीसी मनसे तुमही हाय हबै, तुम पुदीने, सुदाब अउ कइनमेर के सबजी के दसमा हिस्सा देथा, पय मनसे के परति नियाव अउ भगवान के परति माया के अपेक्छा करथा, हइ उहै हबै, जिनही पूर करै के जरूरी हबै, दूसर के अपेक्छा के करे बगैर।” ");
INSERT INTO bhu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","हे फरीसी मनसे तुम्हर उप्पर हाय काखे तुम बिनती भवन हे निक्खा आसन ढूंढथा, अउ बाजार हे मनसे दवारा नमस्ते पसंद करथा। ");
INSERT INTO bhu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","हाय हबै तुमही काखे तुम छुपे हर मरघटी के जसना हबा, जिनखर मनसे अनजाने हे रेंगथै बागथै। ");
INSERT INTO bhu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","अक्ठी नियम के गुरू मनसे यीसु लग कथै, “हे गुरू असना गुठेके तै हमर बेज्जती करथस।” ");
INSERT INTO bhu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","यीसु कथै, हाय हबै, तुमके गुरू काखे तुम मनसे नियमन के असना बोझा लाद देथा, जेही उठामै के कठिन होथै, तुम खुदय उनखर मदत के निता अपन अक्ठी अंगठी तक नेहको लगाथा। ");
INSERT INTO bhu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","हाय हबै तुमही, काखे तुम ग्यानी मनसेन के मरघटी बनाथा, जब कि तुम्हर सियान उनके मारे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","हइमेर तुम अपन सियानन के काम के गवाही देथा, अउ उनखर पूर तरह लग समरथन करथा, काखे उनही मारे रथै, अउ तुम उनखर मरघटी बनाथा। ");
INSERT INTO bhu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","इहैनिता भगवान के सिक्छा कथै, मै उनखर लिघ्घो ग्यानी मनसे अउ चेला पठोहूं, ऊ उनखर मसे केतनोन के मार डरहिन, अउ केतनोन के परेसान करहिन। ");
INSERT INTO bhu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","इहैनिता दुनिया के सुरु होय लग आज तक सगलू ग्यानी मनसेन के खून बोहै के हिसाब इहै पुरखन लग लय जही। ");
INSERT INTO bhu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","हाबिल लग लइके जकरयाह के खून तक, जिनखर हत्या बेदी अउ मन्दिर के बीच करे गय रथै, हव, मोर बिस्वास करा, एखर हिसाब इहै पुरखा लग लय जही। ");
INSERT INTO bhu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“हाय हबै तुमही, नियम के गुरू मनसे ग्यान के चाभी तो पाय गय हबा, अउ तुम खुद परवेस नेहको करे हबा अउ जउन परवेस करथै, उनोन के रोक दय हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","जब यीसु ऊ घर लग निकडथै, तब नियाव के गुरू अउ फरीसी मनसे यीसु के पाछू पड गइन, अउ बोहत लग बातन हे सबाल करै लगिन। ");
INSERT INTO bhu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","अउ घात हे लगे रथै, कि ओखर मुंह लग निकरे हर कउनो बात हे फसइ। ");
INSERT INTO bhu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","एतका हे हजारन मनसेन के भीड अकजुट हुइ गइस, इहां तक मनसे अक दूसर हे गिरे पडथै, तब यीसु सबले आगू अपन चेलन लग कहै लगिस, फरीसी के कपट रूपी खमीर मतलब ढोंगहा लग सचेत रइहा। ");
INSERT INTO bhu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","असना कुछु मुंदररे नेहको हबै, जउन उघारे नेहको जही अउ असना कुछु लुके हर नेहको हबै जउन जाने नेहको जही। ");
INSERT INTO bhu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ऊ सब्द जउन तुम अंधियार हे गुठे हबै, उके उजियार हे सुने जही, जउन कुछु तुम भित्तर कोठा हे गुठे हबा, ऊ छानी लग पुकार-पुकार के परचार करे जही। ");
INSERT INTO bhu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“मोर संगी मोर बात सुना, उनखर लग झइ डर, जउन देह के नास कर सकथै, पय ओखर बाद अउ कुछु नेहको कर सकथै। ");
INSERT INTO bhu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","पय मै तुमही गुठेथो, केखर लग डरै चाही, ओखरै लग डर जउन देह के नास करै के बाद नरक हे डालै के सक्ति हबै, हव मै तुम्हर लग कथो ओखरै लग डर।” ");
INSERT INTO bhu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","का दुइ पइसा हे पांचठे गलइया नेहको बिकथै? फेर भगवान उनखर मसे अकोठेन के नेहको भूलथै। ");
INSERT INTO bhu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","सच तो हइ हबै कि तुम्हर मूंड के अक्ठी चूंदी तक गिनररेहर हबै, झइ डर, तुम्हर दाम कइठे गलइयन लग कहुं अधिक बढके हबै। ");
INSERT INTO bhu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","मै तुम्हर लग कथो, जउन मोके मनसेन के आगू सुइकार करथै, उके मनसे कर टोरवा यीसु मसीह भगवान के स्वरगदूतन के आगू सुइकार करी। ");
INSERT INTO bhu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","पय जउन मोके मनसे के आगू सुइकार नेहको करी, ऊ भगवान कर स्वरगदूत के आगू सुइकार नेहको करे जही। ");
INSERT INTO bhu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","अगर कउ मनसे कर टोरवा के बिरोध हे कउनो सब्द कथै, उके तो छमा कर दय जही, पय पवितर आतमा के बुराई, छमा नेहको करे जही। ");
INSERT INTO bhu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“जब तुमके बिनती भवन अउ सजा देय बाले अउ सासक के आगू खींच लइ जइही, ता एखर बारे हे चिन्ता झइ करबे, कि तुम कसना अउ काहिन जबाब दइहा, पय अपन पल्ला लग काहिन कहिबे। ");
INSERT INTO bhu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","काखे उहै टेम पवितर आतमा तुमके खुद सिखाय दइ कि काहिन गुठेवै के सही हुइ।” ");
INSERT INTO bhu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","मनसे के भीड मसे कउनो मनसे यीसु लग कथै, गुरू जी मोर भाई लग गुठे दे, कि मोर बाफ के डेरा के बटवाय। ");
INSERT INTO bhu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","यीसु उके जबाब दइस, हे “भाई कउन मोके तुम्हर नियाव या बाटै बाले चुने हबै?” ");
INSERT INTO bhu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","यीसु मनसेन लग कथै, सचेत रइहा सबैमेर के लालच लग बचे रइहा, काखे कउनोन के लिघ्घो केतका धन डेरा काखे न होय, ऊ समस्या के बहुतायत लग भले जीवन नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","फेर यीसु उनही अक्ठी किस्सा गुठेथै, “कउनो धनी मनसे के खेत लग बोहत दाना उपजथै। ");
INSERT INTO bhu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ऊ मनसे मन हे बिचार करिस अब मै काहिन करव? दाना रखै के निता मोर लिघ्घो जिघा नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","तब ऊ कथै, मै अक्ठी जुगाड कर सकथों, कि मै अपन दाना के धरै के निता कोठला के टोर के, बोहत बड कोठला बनाहुं, अउ उहै हे अपन सगलू दाना अउ सगलू धन डेरा धरहुं। ");
INSERT INTO bhu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","अउ अपन परान लग गुठेहूं, अरे मोर परान बोहत साल के निता धन डेरा तोर लिघ्घो धरे हबै, इहैनिता खा-पी अउ मउज उडा। ");
INSERT INTO bhu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","भगवान ओखर लग कथै, अरे मूरुख इहै रात तोर परान लइ ले जही, ता जउन कुछ तै जोरे हबस ऊ केखर होही?” ");
INSERT INTO bhu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ओसनेन हाल उन मनसेन के होथै, “जउन अपन निता डेरा कुढयाथै, पय भगवान कर नजर हे, ऊ धनी नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","यीसु अपन चेलन लग कथै, इहैनिता मै तुम्हर लग कथो, चिन्ता झइ करा कि हम काहिन खाबो या अपन देह के बारे हे कि हम काहिन पहिनब। ");
INSERT INTO bhu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","काखे जीवन खाना लग अउ देह बन्डी लग बढके हबै। ");
INSERT INTO bhu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कउवन के धियान देया, उन नेहको बोथै अउ नेहको काटथै अउ उनखर न बखारी अउ न कोठला हबै, तउ भगवान उनके खबाथै तुम चिरइयन लग बढके हबा। ");
INSERT INTO bhu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","चिन्ता करके तुम्हर मसे कोहर अपन उमर के अक घरी बढाय सकथै। ");
INSERT INTO bhu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","अगर तुम अक्ठी नान काम नेहको कर सकथा, ता फेर दूसर बातन के चिन्ता काखे करथा? ");
INSERT INTO bhu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","पतेरा के फूलन के देखा, उन न मेहनत करथै अउ न काटथै, मै तुम्हर लग कथो, राजा सुलेमान अपन सगलू जीवन हे उनखर मसे कउनो अक्ठी के जसना बन्डी नेहको पहिन सकिस। ");
INSERT INTO bhu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","इहैनिता पटउरा के अगर भगवान चारा के जउन आज पटउरा हे हबै, अउ कल आगी हे डार दय जही, इहैमेर पहिराथै, ता हे सक्की बिस्वासी मनसे ऊ तुमके काखे नेहको पहिराही? ");
INSERT INTO bhu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","इहैनिता तुम हइ खोज हे झइ रहा, कि तुम का खइहा अउ का पीहा, अउ न एखर कउनो चिन्ता करा। ");
INSERT INTO bhu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","हइ सगलू चीजन के खोज दुनिया के सगलू मनसे करथै, तुम्हर बाफ जानथै, कि तुमके एखर जरूरत हबै। ");
INSERT INTO bhu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","इहैनिता भगवान कर राज के खोज हे लगे रहा, अउ हइ चीज तुमके मिल जही। ");
INSERT INTO bhu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“तुम जउन गिनती हे कम हबा, हे झुन्ड झइ डर, काखे तुम्हर बाफ तुमके राज देय के किरपा करे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","अपन डेरा के बेच के मिलेहर पइसा के गरीबन हे बांट देया, अपन निता असना थइला हे धन डेरा अक जिघा करा, जेही नस्ट नेहको करे जाय सकथै, स्वरग हे अक जिघा करे हर डेरा हे न चोरटा के पहुंच हबै, अउ न पाई कीडा खतम कर पई। ");
INSERT INTO bhu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","तुम्हर मन उहै लगे होही, जिहां तुम्हर पइसा हबै” ");
INSERT INTO bhu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“हरमेसा तइयार रहा अउ अपन चिमनी बारे रखा। ");
INSERT INTO bhu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","तुम उन हरवाहन के जसना बना जउन अपन मालिक के गली देखथै, कि ऊ काज लग कब लउटही, ताकि मालिक आयके कंवाड ठोकठोकाही, ता उन हरबी ओखर निता कंवाड उघाड दइ। ");
INSERT INTO bhu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","धन्य हबै ऊ हरवाह जेही मालिक आयके जगे हर पइ, मै तुम्हर लग सही कथो, ओखर हरवाह बन्डी पहिरके उके खाना के निता बइठाही अउ खुदय उके खाना पोरसी। ");
INSERT INTO bhu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","धन्य हबै ऊ हरवाह, जेही मालिक रात के दूसर या तीसर टेम आमै लग उहै मेर जागेहर पाही, ");
INSERT INTO bhu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","हइ सही मेर समझ लेया, अगर घर के मालिक के पता होतै कि जरूरी हबै, कि घर के मालिक के पता होतै कि चोरटा कउन टेम आही, ता ऊ अपन घर हे नेहको घुसै देथै। ");
INSERT INTO bhu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","तुमो हरमेसा तइयार रहा, काखे कि जउन टेम तुम ओखर आमै के सोंच नेहको करथा, उहै टेम मनसे कर टोरवा आ जही।” ");
INSERT INTO bhu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","पतरस यीसु लग पूछथै, “परभु का तै हइ किस्सा हमर निता कथस? या सगलू मनसेन के निता।” ");
INSERT INTO bhu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","यीसु कथै, कोनहर असना समझदार अउ दिमाक बाले हबै, जेखर मालिक अपन हरवाह के उप्पर सही टेम, पय ग्यानी भन्डारी कोनहर हबै, जेही ओखर मालिक अपन हरवाह अउ हरवाहिन के चुने हबै, ताकि सही टेम हे उनही भोजन के समान देय। ");
INSERT INTO bhu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","धन्य हबै ऊ हरवाह, जेखर मालिक लउटै लग उके असना करत पइ। ");
INSERT INTO bhu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","मै तुम्हर लग सही कथो, ऊ हरवाह के अपन सगलू धन डेरा लग अधिकारी बनाही। ");
INSERT INTO bhu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","पय अगर ऊ सेबक अपन मन हे सोचै लगै, अबे तो मोर मालिक के लउटै हे बोहत देरी हबै, अउ ऊ हरवाह हरवाहिन के पिटाई करै लगी, अउ खाय पीके नसा हे भुत्त हुइ जाय। ");
INSERT INTO bhu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ता ऊ हरवाह के मालिक, असना रोज आ जइ, जब उके नेहको ओरगी, अउ उहै टेम जेखर बारे हे उके पता नेहको हबै, ता मालिक उके कठोर दन्ड दइके ओखर गिनती अबिस्वासी हे कर दइ। ");
INSERT INTO bhu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","हरवाह अपन मालिक के इक्छा के जानथै, अउ ओखर निता तइयार नेहको रथै, अउ न ओखर इक्छा के जसना काम करिस, ऊ बोहत पिटान पाही। ");
INSERT INTO bhu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","पय जउन अनजाने हे मार खाय के काम करे हबै, ऊ चुटु मार खाही जेही बोहत दय गय हबै, ओखर लग बोहत लय जही अउ जेही सउपे गय हबै ओखर लग बोहत लय जही। ");
INSERT INTO bhu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","मै भुंइ हे आगी लगामै आय हबो, अउ मै का चाहथो, कि हइ आगी अभिनैन सिलग जही। ");
INSERT INTO bhu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","पय मोके बतिस्मा लेय के जरूरी हबै अउ जब तक हइ काम नेहको हुइ जथै, मै केतका परसान हबो। ");
INSERT INTO bhu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","यीसु कथै, का तुम समझथा, कि मै भुंइ हे सान्ति लइके आय हबो? मै तुम्हर लग कथो, नेहको मै फूट डलवामै आय हव। ");
INSERT INTO bhu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","काखे अब अगर अक्ठी घर हे पांचठे मनसे होही, ता उनखर हे फूट हुइ, तीसर मनसे दूसर के बिरुध अउ दूसर मनसे तीसर के बिरुध। ");
INSERT INTO bhu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","बाफ बेटवा के बिरुध अउ बेटवा बाफ के बिरुध होही, दाय अपन बिटिया के बिरुध, बिटिया दाय के बिरुध, सास बहू के बिरुध अउ बहू सास के बिरुध हुइ जइही। ");
INSERT INTO bhu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","यीसु मनसे के भीड लग हइ कथै, अगर तुम दिनबुडती के पल्ला बादर उठत देखिहा, ता हरबी गुठेथा, कि बरसा होय बाले हबै, अउ ओसनेन होथै। ");
INSERT INTO bhu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","जब हवा दख्खिन के पल्ला चलथै, “ता जान जइहा, कि ओसनेन होथै। ");
INSERT INTO bhu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","हे ढोंगहा, अगर तुम बादर अउ भुंइ चीनथा, ता ऊ टेम के भेद काखे स्वरग के देखके, अपन राय हइ टेम के देखके तुम अभिनैन के टेम, काखे राय करै के नेहको जानथा? ");
INSERT INTO bhu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“तुम अपन निता सही गलत के फइसला काखे नेहको कर लेथा? ");
INSERT INTO bhu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","जब तुम अपन बैरी के संग सजा देय बाले के लिघ्घो जथा, ता गली हे ओखर लग समझामै के परयास करा, कहुं असना झइ होय कि ऊ तुमके सजा देय बाले के लिघ्घो घसीट के लइ जाय, अउ सजा देय बाले तुमके सिपाही के हबाले कर दे अउ सिपाही तुमके जेल हे डाल दे। ");
INSERT INTO bhu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","मै तुम्हर लग सही कथो, जब तक तुम सगलू पइसा नेहको चुकाय दइहा, तब तक उछो लग छुटकर नेहको पइहा।” ");
INSERT INTO bhu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","उहै टेम कुछ मनसे यीसु के उन गलीली मनसेन के बारे हे गुठेमै आथै, जेखर खून पिलातुस राजा उनखर चढावा के संग मिलाय दय रथै। ");
INSERT INTO bhu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","यीसु उनखर लग कथै, “का तुम समझथा, कि हइ गलीली मनसे दूसर सगलू गलीलियन लग बोहत पापी रथै, काखे उनखर हे असना समस्या पडिस? ");
INSERT INTO bhu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","मै तुम्हर लग कथो, असना नेहको हबै, पय अगर तुम पस्चाताप नेहको करिहा, ता तुम सब उहैमेर नस्ट हुइ जइहा। ");
INSERT INTO bhu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","अउ का तुम समझथा, कि सिलोह के पगरा गिरै लग जउन अठाराठे मनसे दबरर के मर गइन, उन यरुसलेम के सगलू रहै बाले लग बोहत अपराधी रथै? ");
INSERT INTO bhu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","मै तुम्हर लग कथो, असना नेहको हबै, पय अगर तुम पस्चाताप नेहको करिहा, ता तुम सगलू उहै मेर नस्ट हुइ जइहा।” ");
INSERT INTO bhu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","तब यीसु हइ किस्सा सुनाथै, “अक्ठी मनसे अपन अंगूर के बगिया हे अक्ठी अंजीर के रूख रथै, ऊ ओहमा फडुहा खोजै आइस, पय उके अकोठे फडुहा नेहको मिलथै। ");
INSERT INTO bhu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ता ऊ अंगूर के बगिया के मालिक लग कथै, देखा मै तीन साल ले हइ अंजीर के रूख हे फडुहा खोजै आथो, पय मोके अकोठे फडुहा नेहको मिलिस, इके काट डाल, हइ भुंइ के काखे छेके हर हबै? ");
INSERT INTO bhu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","पय मालिक जबाब दइस, मालिक हइ साल इके रहै देया, मै एखर चारो पल्ला खोद के खादा डालहुं। ");
INSERT INTO bhu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","अगर आने साल हइ अंजीर के रूख फडुहा नेहको दइ, ता इके कटवाय दय जही।” ");
INSERT INTO bhu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","यीसु सुस्ताय कर रोज बिनती भवन हे सिक्छा देथै। ");
INSERT INTO bhu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","उहां अक्ठी डउकी रथै, उके अठारा साल लग कमजोरी करै बाले आतमा लगे रथै, जेखर कारन ओखर देह झुक के कुबडी हुइ गय रथै, अउ कउनो मेर ऊ सिध्धा नेहको हुइ पाथै। ");
INSERT INTO bhu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","यीसु उके देखके अपन लिघ्घो बुलाथै, अउ ओखर लग कथै, “तै अपन नांगा लग आजाद हुइ गय हवस।” ");
INSERT INTO bhu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","यीसु ओखर हे हाथ धरिस, उहै टेम ऊ डउकी सिध्धा ठाड हुइ गइस अउ भगवान के बडाई करै लगथै। ");
INSERT INTO bhu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","यहूदी आराधनालय के मुखिया गुस्साय जथै काखे यीसु सुस्ताय कर रोज ऊ डउकी के निक्खा करे रथै, यीसु मनसेन लग कथै, “छय रोज हबै जेहमा काम करै के सही हबै, इहैनिता उहै रोज निक्खा होय के निता आबा सुस्ताय कर रोज नेहको।” ");
INSERT INTO bhu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","पय परभु जबाब दइस, “ढोंगहा का तुम्हर मसे सबझन सुस्ताय कर रोज अपन बइला अउ गदहा के ढील के उके पानी पिलामै नेहको लइ जथै? ");
INSERT INTO bhu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","अउ का हइ डउकी के जउन अब्राहम के टोरिया हबै जेही भुतवा अठारा साल लग बांध रखथै, का उके सुस्ताय कर रोज इके बन्धन लग छंडामै के सही नेहको रहिस?” ");
INSERT INTO bhu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","यीसु के बात सुनके सगलू बिरोधी लजाय गइन, पय सगलू मनसे ओखर काम के देखके मगन होथै। ");
INSERT INTO bhu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","यीसु कथै, “भगवान कर राज केखर जसना हबै? मै एखर बराबरी केखर लग करव? ");
INSERT INTO bhu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","भगवान कर राज राई दाना के बिजहा के जसना हबै, जेही कउनो मनसे अपन बारी हे बोथै, अउ बिजहा जम के अक्ठी रूख बन जथै, इहां तक कि बादर के चिरइया आयके ओखर डगइल हे बसेरा करै आथै” ");
INSERT INTO bhu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","यीसु फेरै कथै, “मै भगवान कर राज के बराबरी केखर लग करो? ");
INSERT INTO bhu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ऊ उस खमीर के जसना हबै, जेही लइके कउनो डउकी दस किलो पिसान हे मिलाय दइस अउ ऊ सगलू पिसान खमीर हे बदल गइस।” ");
INSERT INTO bhu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","यीसु सहर-सहर अउ गांव-गांव हे सिक्छा देत, यरुसलेम सहर के पल्ला जथै। ");
INSERT INTO bhu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","कउनो मनसे यीसु लग सबाल पूछथै, “परभु का चुटु हस मनसे मुकति पइहीं?” यीसु जबाब दइस, ");
INSERT INTO bhu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","सांकर दूरा लग जाय के, पूर परयास करा, काखे मै तुम्हर लग कथो परयास करै लग बोहत लग मनसे परवेस नेहको कर पइहिन। ");
INSERT INTO bhu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","जब घर के मालिक उठके कंवाड ढाक चुके होही, ता तुम बाहिर ठाड हुइके कंवाड ठोकठोकाउत अउ कइहा, परभु हमर निता कंवाड उघाड दे, ऊ तुमके हरबी जबाब दइ, मै तुमके नेहको जानथो, तुम कछो लग आय हबा। ");
INSERT INTO bhu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","तब तुम कइहा, हम तोर संग खाय पिय रहन, अउ तै हमर बजार हे सिक्छा दय रथस, ");
INSERT INTO bhu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","पय यीसु तुम्हर लग कही, मै तुमके नेहको जानथो, कि तुम कछो लग आय हबा, कुकरमी तुम सगलू मोर लिघ्घो लग दुरिहां हटा। ");
INSERT INTO bhu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","जब तुम अब्राहम, इसहाक, याकूब अउ सगलू ग्यानी मनसे के, भगवान कर राज हे देखिहा अउ तुमके खुदय बाहिर ढकेल दय जही, तब तुम रोइहा अउ दांत पिसिहा। ");
INSERT INTO bhu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","चारो दिसन लग मनसे आयके, भगवान कर राज के भोज हे सहभागी होही। ");
INSERT INTO bhu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","अउ सच्चाई हइ हबै कि जउन पाछू हबै, ऊ आगू करे जही अउ जउन आगू हबै ऊ पाछू करे जही। ");
INSERT INTO bhu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","उहै टेम कुछ फरीसी मनसे आयके, यीसु लग कथै, “इछो लग कढ जा, काखे हेरोदेस राजा तोंही मार डारै चाहथै।” ");
INSERT INTO bhu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","यीसु उनखर लग कथै, जायके ऊ सिकटा लग गुठेबा, मै आज अउ कल भुतवा के निकाडहूं, अउ मनसेन के चंगा करिहों अउ तीसर रोज मोर काम पूर हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","तउमा हइ जरूरी हबै, कि आज, कल अउ परसो यातरा करव, काखे हइ नेहको हुइ सकथै, कि कउनो ग्यानी मनसे के यरुसलेम सहर के बाहिर मारे जाय। ");
INSERT INTO bhu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“हे यरुसलेम, हे यरुसलेम, तै ग्यानी मनसेन के हत्या करथस अउ अपन लिघ्घो पठोय हर संदेस देय बालेन के पथरन लग मार डारथस, मै केतका बेर चाहो कि तोर लरका के अक जिघा कर लो, जसना कुकडी अपन लरकन के अपन डेखना के तरी अक जिघा कर लेथै, पय तै मोके हइ करै नेहको दय। ");
INSERT INTO bhu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","इहैनिता तुम्हर घर तुम्हर निता छांड दय जही, मै तुम्हर लग कथो, तब तक मोके नेहको देखिहा, जब तक ऊ टेम नेहको आ जाय, तुम हइ नेहको कइहा, धन्य हबै, ऊ जउन परभु के नाम लग आथै।” ");
INSERT INTO bhu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","यीसु सुस्ताय कर रोज कउनो फरीसी साहब के इछो भोजन करै जथै, उन मनसे ओखर ताक हे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","यीसु के आगू फुलनी रोग लग पीडित अक्ठी मनसे आथै। ");
INSERT INTO bhu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","यीसु उन फरीसी अउ नियम के गुरून लग सबाल करथै, “सुस्ताय कर रोज कउनो के निक्खा करै के नियम के जसना सही हबै या नेहको?” ");
INSERT INTO bhu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","पय उन चुप रथै, तब यीसु ऊ नंगहा हे हाथ धरके उके चंगा कर दइस अउ ओखर बिदा करिस। ");
INSERT INTO bhu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","तब यीसु उनखर लग कथै, “हइ गुठेबा, अगर तुम्हर मसे कउनो के टोरवा या बइला सुस्ताय कर रोज खोदरा हे गिर जाय, ता का तुम उके हरबी बाहिर नेहको निकरिहा?” ");
INSERT INTO bhu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","उनखर लिघ्घो हइ सबाल के कउनो जबाब नेहको रथै। ");
INSERT INTO bhu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","यीसु हइ देखथै, कि पहुना मनसे अपन निता खास-खास जिघा चुन लेथै, ता ऊ उनही हइ किस्सा सुनाथै। ");
INSERT INTO bhu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“जब कउ तुमही काज हे नेउता दे, ता तुम अपन निता आदर के ओग के जिघा झइ चुनबे, हइ सम्भव हबै, कि ऊ तुम्हर लग अधिक कउनो आदर के ओग मनसे के नेउता दय हुइ। ");
INSERT INTO bhu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","अउ जउन तुमही दुनो के नेउता दय हबै, आयके तुम्हर लग कहे, इनही अपन जिघा देया, तब तुमही लज्जित हुइके सबले पाछू जिघा हे बइठै के पडी। ");
INSERT INTO bhu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","इहैनिता जब तुमही नेउता मिलै, ता जायके सबले पाछू जिघा हे बइठिहा, जेखर लग नेउता देय बाले आयके तुम्हर लग कही, मोर संगी उठा अउ ऊंच जिघा हे बइठा, इहैमेर सब पहुना के आगू तुम्हर आदर हुइ। ");
INSERT INTO bhu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","काखे जउन अपन खुद के बडा मानथै, ऊ नान करे जही अउ जउन अपन खुद के नान मानथै ऊ बडा करे जही।” ");
INSERT INTO bhu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","तब यीसु अपन नेउता देय बालेन लग कथै, “जब तुम दिन या रात के भोज हे कउनो के नेउता करा, ता अपन संगिन के बुलाबा अउ भाई सखा सियानन या धनी परोसिन के नेउता झइ देया, असना झइ होय कि उनो तुमके नेउता दइके पलटा चुकाय दे। ");
INSERT INTO bhu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","बलुक जब तुम भोज देया, ता गरीबन, असहाय, लुलुवन अउ अंधरन के नेउता देया। ");
INSERT INTO bhu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","तब तुम धन्य हुइहा उन मनसे तुम्हर पलटा नेहको चुकाय सकथै, पलटा तुमके धरमी मनसे के दवारा जिन्दा होय के टेम पलटा चुकाय दय जही।” ");
INSERT INTO bhu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ओखर संग भोजन करै बाले मसे कउनो मनसे हइ सुनके यीसु लग कथै, “धन्य हबै, ऊ, जउन भगवान कर राज हे भोजन करी।” ");
INSERT INTO bhu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","हइ सुनके यीसु कथै, “कउनो मनसे अक्ठी बडा भोज के आयोजन करिस अउ बोहत लग मनसेन के नेउता दइस। ");
INSERT INTO bhu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","भोजन के टेम ऊ अपन हरवाह दवारा पहुनन के हइ कहिके पठोथै, कि आबा, काखे अब सगलू कुछ तइयार हबै। ");
INSERT INTO bhu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","पय उन सगलू झन बहाना करै लागथै, पहिले हरवाह लग कथै, मै खेतवा खरीद लय हबो अउ मोके ओही देखै जाय के हबै, मै तोर लग बिनती करथो मोर पल्ला लग छमा मांग लइहा। ");
INSERT INTO bhu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","दूसर मनसे कथै, मै पांचठे गाडी बइला खरीद लय हबो अउ मै उनके देखै जथो, तुम्हर लग बिनती करथो, मोर पल्ला लग छमा मांग लइहा। ");
INSERT INTO bhu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","अक्ठी अउ मनसे कथै, मै काज करे हबो, इहैनिता मै नेहको आय सकथों। ");
INSERT INTO bhu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","हरवाह अपन घर छो लउट के आथै, ता ऊ अपन मालिक लग सगलू बात गुठेथै, ई बात सुनके ऊ घर के मालिक बोहत गुस्साथै अउ अपन हरवाह लग कथै, ऊ सहर के बाजार छो जा, जछो गली हे दीन हीन अउ बेसहारा अउ अंधरा अउ लेंगरा के इछो बुलाय लइ आनबे। ");
INSERT INTO bhu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","जब हरवाह अपन मालिक लग कथै, मालिक तोर आदेस के पालन करे गय हबै, पय अउ कुछ जिघा बाकी हबै। ");
INSERT INTO bhu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ता घर के मालिक हरवाह के आदेस दइस, अब तै सहर के बाहिर के सडक अउ बखरी के पल्ला जा अउ मनसेन के भित्तर लामै के निता मजबूर कर कि मोर घर भर जाय। ");
INSERT INTO bhu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","अउ मै तुम्हर लग कथो, जउन आगू बुलाय गय हबै, उनखर मसे कउनो मनसे मोर भोजन के नेहको खाय पइहिन।” ");
INSERT INTO bhu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","यीसु के संग-संग मनसेन के अक्ठी बडी भीड चलथै, ता ऊ उनखर पल्ला घूमके मनसेन लग कथै। ");
INSERT INTO bhu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","अगर कउ मोर लिघ्घो आथै अउ अपन दाय बाफ डउकी अउ लरिका, अपन भाई बेहन अउ इहां तक कि खुदय अपन जीवन के मोर लग बोहत महत्व देथै, ता ऊ मोर चेला नेहको हुइ सकथै। ");
INSERT INTO bhu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","जउन मनसे अपन क्रूस उठायके नेहको चलथै, ऊ मोर चेला नेहको हुइ सकथै। ");
INSERT INTO bhu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","तुम्हर मसे असना कोहर हबै, जउन पगरा बनामै चाहथै, अउ आगू बइठके खरचा के अनुमान न लगामै, कि मोर लिघ्घो काम पूर करै के निता खूब पइसा हबै या नेहको? ");
INSERT INTO bhu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","कहुं असना झइ होय कि ऊ नीह कोड लय होय अउ काम पूर नेहको कर पाउत होंय ता देखैबाले मजाक उडाही। ");
INSERT INTO bhu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","अरे देखा हइ मनसे काम तो करिस, पय हइ उके पूर नेहको कर सकिस। ");
INSERT INTO bhu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","असना कोहर राजा हुइ, जउन दूसर राजा लग युध्द करै के पहिलेन हइ बिचार न करी कि ऊ अपन दस हजार सुपाहिन के संग अपन बिरुध बीस हजार के सेना लग सामना कर सकथै, या नेहको? ");
INSERT INTO bhu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","अगर ऊ सामना नेहको कर सकथै, ता जब तक दूसर राजा दूर हबै, ऊ राजदूतन के पठोय के ओखर आगू सान्ति परस्ताव रखी। ");
INSERT INTO bhu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“इहैमेर तुम्हर मसे जउन मनसे अपन सगलू कुछ नेहको छांड दइ, ऊ मोर चेला नेहको हुइ सकथै। ");
INSERT INTO bhu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“नून निक्खा हबै, पय अगर ऊ अपन मिठास खो दइ, ता ऊ कसना नमकीन करे जही? ");
INSERT INTO bhu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ऊ न तो भुंइ के कउनो काम के रही, अउ न खादा के काम हे आथै, मनसे उके बाहिर फटक देथै अउ जेखर सुनै के कान हबै ऊ सुन ले।” ");
INSERT INTO bhu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","अक रोज सगलू पइसा उगाहै बाले अउ पापी मनसे यीसु के लिघ्घो बात सुनै के निता आथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","पय फरीसी अउ नियाव के गुरू “हइ देखके बडबडाय लग जथै, हइ मनसे पापिन लग मिलथै अउ उनखर संग खाथै-पीथै।” ");
INSERT INTO bhu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","तब यीसु उनके हइ किस्सा सुनाथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","अगर तुम्हर मसे कउनो के लिघ्घो सवठे गेडरा होय अउ उनखर मसे अक्ठी गेडरा भुलाय जाय, ता ऊ निन्यानबे गेडरन के पतेरा हे छांड के ऊ अक्ठी गेडरा के जब तक ढूंढही, जब तक कि ऊ गेडरा उके नेहको मिल जाय। ");
INSERT INTO bhu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","अउ जब उके गडरा मिल जथै, ता ऊ मगन हुइके उके अपन खांधा हे उठाय लेथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","जब ऊ मनसे अपन घर छो आथै, ता अपन संगी अउ परोसिन के, अपन लिघ्घो बुलाय के उनखर लग कथै, मोर संग मगन करा काखे मोके मोर भुलाय हर गेडरा मिल गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","मै तुम्हर लग कथो, इहैमेर निन्यानबे धरमी मनसे के अपेक्छा, जेही पस्चाताप करै के जरूरी नेहको हबै, ऊ अक्ठी पापी के निता स्वरग छो कहुं बोहत मगन बनाय जही, जउन मन बदलथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“कउन असना डउकी होही, जेखर लिघ्घो दसठे चांदी के पइसा हुइ अउ उनखर मसे अक्ठी पइसा भुलाय जाय, ता ऊ चिमनी जलाके के घर के झारी बहारी जब तक उके पइसा मिल नेहको जाय, तब तक ऊ उके खोजत रही? ");
INSERT INTO bhu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","पइसा मिल जाय लग ऊ अपन सखी अउ परोसिन के बुलाय के गुठे, मोर खुसी हे सामिल हुइ जा, काखे भुलाय हर पइसा मिल गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","मै तुम्हर लग कथो, स्वरग हे इहैमेर भगवान कर स्वरगदूत ऊ पापी मनसे के निता खुसी बनाथै, जउन पस्चाताप करथै।” ");
INSERT INTO bhu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","फेर यीसु कथै, “कउनो मनसे के दुइठे टोरवा रथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ता नान टोरवा अपन बाफ लग कथै, डेरा मसे मोर हिस्सा मोके दइ दे अउ बाफ दुनो हे अपन धन डेरा बांट देथै।” ");
INSERT INTO bhu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","कुछ रोज के बाद नान टोरवा अपन सगलू पइसा लइ जाय के, अक्ठी दुरिहां देस छो कढ जथै अउ उहां जाय के ऊ अपन सगलू पइसा उडाय देथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","जब ऊ सगलू पइसा खरचा कर चुकथै, ता ऊ देस हे बोहत भुखमरी आथै अउ ऊ बोहत गरीब हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","इहैनिता ऊ उहै देस के रहै बाले अक्ठी मनसे के इहां गइस, ऊ उके अपन खेत हे सुमरा चरामै के निता पठोथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","अउ सुमरा के चारा लग अपन लादा भरै के निता तरस जथै, कउनो उके खाय के निता कुछु नेहको देथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","तब ऊ होस हे आइस अउ हइ सोचै लगिस, मोर बाफ के घर छो केतका मजदूर के जरूरत लग अधिक खाय के मिलथै अउ इछो मै भूख मरथो। ");
INSERT INTO bhu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","मै उठके अपन बाफ के लिघ्घो जहुं अउ ओखर लग कइहों कि “बाफ जी मै स्वरग के बिरुध अउ तोर बिरुध पाप करे हबो। ");
INSERT INTO bhu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","मै तोर टोरवा कहामै के काबिल नेहको हबो, तै मोके अपन मजदुरिहा समझ के अपन लिघ्घो रख ले।” ");
INSERT INTO bhu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","तब ऊ उठके अपन बाफ के घर लउट गइस अउ ऊ दुरिहां रथै। बाफ उके देखके दया लग भर गइस अउ दउडके उके लगे लगाय लइस अउ उके चूमथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“टोरवा बाफ लग कथै, बाफ जी, मै स्वरग के बिरोध हे अउ तोर परति पाप करे हव, मै तोर टोरवा कहामै के काबिल नेहको हबो।” ");
INSERT INTO bhu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","पय बाफ अपन हरवाहन लग कथै, बिगर देरी करे लग निक्खा-निक्खा कपडा लानके इके पहिराबा अउ एखर अंगठी हे मुंदरी अउ गोड हे बूट पहिराबा। ");
INSERT INTO bhu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","अक्ठी बडा बोकडा के मारा, ता हमु खउबे अउ ओखर संग खुसी बनई। ");
INSERT INTO bhu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","काखे मोर हइ टोरवा मर गय रहिस अउ फेरै जिन्दा हुइ गय हबै, हइ भुलाय गय रहिस अब ऊ फेरै मिल गय हबै अउ उन खुसी बनामै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ओखर बडका टोरवा खेत लग काम करके घर छो लउटथै, जब घर के लिघ्घो आथै, ता उके गामै बजामै अउ नाचै के आरो सुनाई देथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ता ऊ अक्ठी सेबक के बुलाय के पूछथै, हइ सब काहिन होथै? ");
INSERT INTO bhu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","हरवाह ओखर लग कथै, तोर भाई लउट आय हबै अउ तोर बाफ बडा बोकडा कटवाय हबै, काखे कि उके भला निक्खा पाय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“हइ सब देखके ऊ गुस्सा लग भर गइस अउ घर के भित्तर जायके नेहको चाहथै, इहैनिता ओखर बाफ उके सटियामै के निता बाहिर आथै। ");
INSERT INTO bhu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","पय ऊ अपन बाफ के जबाब देथै, मै एतका साल लग तोर सेबा करे हव अउ कबहुन तोर आदेस के उलंघन नेहको करे हव, पय कबहुन तै मोके अक्ठी छेडी के लरका तक मोके नेहको दय हबस, कि महुं अपन संगिन के संग खुसी बनाय सको। ");
INSERT INTO bhu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","पय जब तोर हइ नान टोरवा आय हबै, जउन बेकार कामन हे तोर धन डेरा बढोय डारे हबै अउ तै ओखर निता पाले हर बोकडा कटवाय हबस। ");
INSERT INTO bhu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","बाफ ओखर लग कथै, टोरवा तै तो सबदिना मोर संग रथस अउ जउन कुछ मोर हबै, ऊ सगलू कुछ तोरै तो हबै। ");
INSERT INTO bhu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","हमर निता खुसी बनामै के सही हबै, काखे तोर हइ भाई मर गय रहै, अब जिन्दा हुइ गय हबै, ऊ जउन भुलाय गय रहै, ऊ अब मिल गय हबै” ");
INSERT INTO bhu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","यीसु अपन चेलन के अक्ठी किस्सा सुनाथै, कउनो धनी मनसे के अक्ठी भन्डारी रथै, मनसे ओखर मालिक के आगू ओखर हे दोस लगाइन, कि ऊ तोर सगलू धन डेरा के उडाय देथै। ");
INSERT INTO bhu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","इहैनिता मालिक उके बुलाय के कथै, हइ मै तोर बारे हे का सुनथो? अपन भन्डारी के हिसाब किताब दे, काखे तै अब मोर भन्डारी नेहको रही सकथस। ");
INSERT INTO bhu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ता ऊ भन्डारी मनै मन सोचै लग जथै, अब मै काहिन करव? मालिक मोर लग भन्डारी के पद छीनथै, माटी खोदै के मोर हे बल नेहको आय, भीख मांगै हे मोके लाज लागथै। ");
INSERT INTO bhu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","मै समझ गयों कि का करहुं ताकि मै भन्डारी के पदवी लग हटाय जाय के बाद मनसे अपन घर हे मोर सोगत करै। ");
INSERT INTO bhu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ऊ अपन मालिक के हर अक्ठी करजा बाले मनसे के बुलाथै अउ पहिले करजा बाले लग कथै, तुम्हर हे मोर मालिक के केतका करजा हबै। ");
INSERT INTO bhu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ऊ कथै, तीन हजार लीटर जैतून के तेल भन्डारी ओखर लग कथै, अपन करजा चिट्ठी लेया अउ हरबी पचास लिख दे। ");
INSERT INTO bhu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","फेर दूसर मनसे लग पूछथै अउ तोर उप्पर केतका करजा हबै? ऊ गुठेथै, तीन हजार किलो गोहूं, भन्डारी ओखर लग कथै, अपन खाता हे चवबीस हजार लिख दे। ");
INSERT INTO bhu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","मालिक ठगरा भन्डारी के चतुराई लग परसंसा करथै, दुनिया के मनसे उजियार के लरका के तुलना हे अपन बिरादरी के संग अपन-अपन आचरन बेउहार हे केतका अधिक होसियार हबै। ");
INSERT INTO bhu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","मै तुम्हर लग कथो, अधरम के धन डेरा लग अपन निता संगी बना लेया, जब हइ धन डेरा बढोय जही, तुमके सबरोज के निबासी घर हे सोगत करही। ");
INSERT INTO bhu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","जउन चुटु हस बात हे इमानदार हबै, ता बड्डे बातन लग बिस्वासयोग होथै, जउन चुटु बात हे बेइमान हबै, ता ऊ बड्डे बातन हे बेइमान होही। ");
INSERT INTO bhu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","अगर तुम दुनिया के डेरा हे भरोसा लायक नेहको हबा, ता तुमके सही डेरा कोनहर सउपही? ");
INSERT INTO bhu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","अउ अगर तुम दूसर के चीज हे इमानदार नेहको हबा, ता तुमही तुम्हर धन डेरा कोनहर देही? ");
INSERT INTO bhu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“कउनो हरवाह दुइठे मालिक के सेबा नेहको कर सकथै, काखे कि ऊ अकझन लग बैर करी अउ दूसर लग बोहत माया करी अउ अकझन लग मिले रही अउ दूसर के बेकार समझही अउ तुम भगवान अउ धन डेरा दुइठे मालिक के सेबा नेहको कर सकथा।” ");
INSERT INTO bhu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","फरीसी मनसे जउन पइसा के लालची रथै, हइ सगलू बात सुनके यीसु के मजाक उडाथै। ");
INSERT INTO bhu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","यीसु उनखर लग कथै, तुम मनसेन के आगू बोहत धरमी मनसे बनै का ढोंग करथा, पय भगवान तुम्हर मन के जानथै, जउन बात मनसे के नजर हे खास हबै, ऊ भगवान के नजर हे असुध्द हबै। ");
INSERT INTO bhu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“यूहन्ना बतिस्मा देय बाले के आमै तक मूसा कर नियम अउ ग्यानी मनसे परभावित रथै, ओखर बाद भगवान कर राज के संदेस सुनाय जथै अउ बोहत मनसे भगवान कर लिघ्घो आमैके परयास करत हबै। ");
INSERT INTO bhu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","स्वरग अउ भुंइ टर जही, ता टर जाय, पय भगवान कर नियम के अक्ठी बिन्दी नेहको मिट सकथै।” ");
INSERT INTO bhu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","जउन डउका अपन डउकी के छांड के, कउनो दूसर डउकी लग काज करथै, ता ऊ गलत काम करथै अउ ऊ डउका जउन छांडे हर डउकी लग काज करथै, उहो डउका गलत काम करथै। ");
INSERT INTO bhu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","यीसु कथै, अक्ठी धनी मनसे रथै, जउन निक्खा अउ मंहगा बन्डी ओढथै अउ सबरोज सुखबिलास अउ खुसी लग अपन जीवन गुजारे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","अउ अक्ठी लाजर नाम के गरीब मनसे पडे रथै, अउ ओखर देह घाव लग भरे हर रथै अउ ऊ धनी मनसे के परवेस दूरा के लिघ्घो छांड दय जथै। ");
INSERT INTO bhu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ऊ चाहथै कि धनी मनसे के जूठा लग अपन लादा भरै, अउ कुकरा आयके ओखर खत्ता के चाटथै। ");
INSERT INTO bhu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ऊ लाजर भिखारी अक रोज मर गइस, अउ स्वरगदूत उके लइ जायके अब्राहम के कोरा हे पहुंचाय दइन, कुछ रोज बाद ऊ धनी मनसे मर गइस, अउ उके भुंइ हे गाड दइन। ");
INSERT INTO bhu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","नरक हे धनी मनसे तडपथै, अउ अपन आंखी उठायके दुरिहां लग अब्राहम के कोरा हे लाजर के बइठे हर देखथै। ");
INSERT INTO bhu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ऊ अब्राहम के गोहराय के कथै, बाफ अब्राहम मोर हे दया कर, अउ लाजर के मोर लिघ्घो पठोय दे, कि ऊ पानी हे अपन अंगठी बुडोय के, मोर जीभ के ठंडवाय दे, काखे कि मै इछो आगी हे तडपथों। ");
INSERT INTO bhu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","अब्राहम ओखर लग कथै, टोरवा सुरता कर कि तुमके जीवन हे बढिहा चीज पाय चुके हबस अउ लाजर के बेकार चीज, पय अब ऊ सान्ति पाथै, पय तै तडपथस। ");
INSERT INTO bhu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","अउ फेर एखर अलाबा तुम्हर अउ हमर बीच हे अक्ठी बडा खाई बनाय गय हबै, जेखर इछो लग उछो जाय बाले उछो नेहको जाय पइहिन, अउ न कउनो उछो लग इछो आय सकहिन। ");
INSERT INTO bhu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","धनी मनसे कथै, बाफ तोर लग अक्ठी बिनती हबै, तै लाजर के मोर बाफ के घर छो पठोय दे। ");
INSERT INTO bhu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","काखे मोर पांचठे भाई हबै, ता लाजर उनके चेतन्न कर दे, कहुं असना झइ होय कि उन पीरा के जिघा छो आ जाय। ");
INSERT INTO bhu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","अब्राहम ओखर लग कथै, मूसा अउ ग्यानी मनसे के किताब उनखर लिघ्घो हबै, उन ओखर सुनै। ");
INSERT INTO bhu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","धनी मनसे कथै, असना नेहको हे बाफ अब्राहम पय अगर कउ मरे हर मसे उनखर लिघ्घो जाय, ता उन मन बदलहिन। ");
INSERT INTO bhu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“अब्राहम ओखर लग कथै, जब उन मूसा अउ ग्यानी मनसेन के आदेस के नेहको मानथै, ता उन कउनो फेरै जिन्दा होय हर मनसे के बिस्वास नेहको करहिन” ");
INSERT INTO bhu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","यीसु अपन चेलन लग कथै, “निस्चय हबै कि पाप के ठोकड जरूर आही, पय हाय हबै ऊ मनसे जेखर कारन मनसे परिक्छा हे पडथै। ");
INSERT INTO bhu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","जउन मनसे हइ नान मसे कउनो अक्ठी के निता ठोकड के कारन बनथै, ओखर निता निक्खा इहै होतिस कि ओखर नटेरी हे चकिया के पाट बांध के उके गहिरा समुन्दर हे फटक दय जातिस।” ");
INSERT INTO bhu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","इहैनिता तुम खुदय के परति सचेत रहा, अगर तुम्हर भाई अपराध करथै, ता उके डांट अउ अगर ऊ पस्चाताप करथै, ता उके छमा कर दे। ");
INSERT INTO bhu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“अगर ऊ रोज तुम्हर बिरुध सात बेर पाप करथै, अउ सात बेर पस्चाताप करै ता उके छमा कर देया” ");
INSERT INTO bhu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","चेला परभु लग कथै, “हमर बिस्वास के बढाय दे” ");
INSERT INTO bhu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","परभु कथै, अगर तुम्हर बिस्वास राई दाना के बरोबर होतिस, ता तुम हइ सहतूत के रूख लग कहिता कि जर लग उखड के समुन्दर हे जा, अउ ऊ तुम्हर बात मान लेतिस। ");
INSERT INTO bhu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“अगर तुम्हर हरवाह हर जोत के या गेडरा चारा चराय के खेत लग लउटथै, ता तुम्हर हे असना कोनहर मालिक हबै जउन ओखर लग गुठेही, आबा, हरबी खाना खाय के बइठ जा? ");
INSERT INTO bhu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","का ऊ नेहको गुठेही, कि मोर खाना तइयार करा, जब तक मै खइहों पिहों तब तक कनिहा बांध के मोर सेबा कर, एखर बाद हे तहु खाय पी लइहे? ");
INSERT INTO bhu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","का मालिक के ऊ हरवाह के इहैनिता धन्यबाद देय चाही कि ऊ ओखर आदेस के माने हबै? ");
INSERT INTO bhu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","तुमो ओसनेन हबा, सगलू आदेसन के मानै के बाद तुमही कहै चाही हम अलाल हरवाह हबन, हम अपन जिम्मेदारी पूर करे हबन।” ");
INSERT INTO bhu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","यीसु यरुसलेम सहर छो जथै सामरिया अउ गलील परदेस के इलाका लग हुइके जात रथै। ");
INSERT INTO bhu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","यीसु जसके अक्ठी देहात छो पहुंचथै, ता उके दसठे कोढी मनसे मिलथै। ");
INSERT INTO bhu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","उन दुरिहां ठाड हुइके बोहत आरो लग गोहराके कथै, हे यीसु हे मालिक हमर उप्पर दया कर। ");
INSERT INTO bhu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","यीसु जब उनही देखथै ता कथै, जा अउ अपन खुद के पुजारिन के दिखइहा अउ रेंगतै-रेंगत उन सुध्द हुइ जथै। ता ऊ भगवान कर बडाई करत लउटथै। ");
INSERT INTO bhu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","पय उन दसठे कोढिन मसे अक्ठी मनसे जब देखथै, कि मै कोढ नंगहा लग निक्खा हुइ गय हबो, ता ऊ लउट के यीसु के लिघ्घो आथै अउ ऊ बोहत आरो लग भगवान कर बडाई करै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ऊ यीसु के धन्यबाद देत ओखर गोड हे मुंह के बल गिर पडिस, अउ ऊ सामरी रथै। ");
INSERT INTO bhu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","यीसु ओखर ले पूछथै, का अबहुन तक दसोठे कोढी मनसे सुध्द नेहको हुइन, फेर ऊ नवठे मनसे कछो हबै। ");
INSERT INTO bhu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","का ई परदेसी मनसे के छांड के, कउनो मनसे भगवान के, बडाई करै नेहको लउटिन। ");
INSERT INTO bhu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","यीसु ओखर लग कथै, ठाड हुइ जा अउ कढ जा, तोर बिस्वास तोके निक्खा करे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","जब फरीसी मनसे यीसु लग पूछथै, भगवान कर राज कब आही, ता ऊ जबाब देथै, “भगवान कर राज असना परगट रूप लग नेहको आथै। ");
INSERT INTO bhu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","मनसे हइ बात नेहको गुठेइही, ऊ इछो हबै, या उछो हबै, काखे देखा भगवान कर राज तो तुम्हर बीच हे हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","पय ऊ चेलन के गुठेथै, असना टेम आही, जब तुम मनसे कर टोरवा के रोज मसे अक्ठी रोज के देखै के चइहा, पय उके नेहको देख पइहा। ");
INSERT INTO bhu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","अउ मनसे तुम्हर लग कइहीं, देखा इछो हबै या देखा उछो हबै, तुम उछो झइ जइहा अउ न उनखर पाछू हुइहा। ");
INSERT INTO bhu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","असना बादर हे बिजली अक्ठी छोर लग निकरके, दूसर छोर तक चमकथै, ओसनै मनसे कर टोरवा के आमै के टेम होही। ");
INSERT INTO bhu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","पय आगू उके बोहत दुख भोगै के होही अउ ई पीढी के मनसे उके बेकार ठहराय जही। ");
INSERT INTO bhu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","जसना नूह के रोज हे होय रहिस, ओसनेन मनसे कर टोरवा के रोज होही। ");
INSERT INTO bhu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","जब तक नूह जिहाज हे नेहको चढिस ऊ टेम मनसे खात पियत अउ काज करवामै हे लगे रहिन, तब जल प्रलय आयके उनही नस्ट कर देथै। ");
INSERT INTO bhu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","जसना लूत के रोज हे होथै अउ मनसे खात पियत लेन देन करत, रुख लगाथै, अउ अपन घर बनाथै। ");
INSERT INTO bhu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","पय ऊ रोज जब लूत सदोम लग बाहिर निकडथै, ता बादर लग आगी, अउ गन्धरस गिरै लागथै, अउ उन सगलू मनसे नस्ट हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","जब मनसे कर टोरवा के आमै के टेम होही, ता ओसनेन होही। ");
INSERT INTO bhu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ऊ रोज कउनो मनसे घर के छानी हे होही, ता ओखर चीज घर के भित्तर हबै, ता उके ले निता तरी झइ उतरै, इहैमेर कउनो मनसे अपन खेत हे हबै, ता ऊ पाछू झइ लउटै। ");
INSERT INTO bhu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लूत के डउकी के घटना के सुरता करिहा। ");
INSERT INTO bhu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","जउन मनसे अपन जीवन बचामै चाहथै, उके खोय देही अउ जउन अपन जीव खोही ऊ उके जिन्दा रखही। ");
INSERT INTO bhu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","मै तुम्हर लग कथो, ऊ रात दुइठे मनसे अक्ठी खटिया हे होही, उनखर मसे अक्ठी मनसे के, स्वरग छो उठाय लय जही, अउ दूसर मनसे के छांड दय जही। ");
INSERT INTO bhu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","दुइठे डउकी अक्कै संग जोतवा चलाउत रइहीं, उनखर मसे अक्ठी डउकी के उठाय लय जही, अउ अक्ठी डउकी के छांड दय जही। ");
INSERT INTO bhu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","दुइझन मनसे खेत हे हुइहिन अउ अकझन के लइ लय जही, दूसर के छांड दय जही। ");
INSERT INTO bhu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ई सुनके चेला यीसु लग पूछथै, हे परभु ई कछो होही? ऊ उनखर लग कथै, जछो लोथ हबै, उहै छो गिधवा बइठही। ");
INSERT INTO bhu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","यीसु चेलन के हइ बात गुठेमै के निता, कि उनही सबरोज बिनती करै चाही अउ निरास नेहको होय चाही, हइ किस्सा सुनाइस। ");
INSERT INTO bhu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","यीसु कथै कउनो सहर हे अक्ठी न्यायधीस रहिस, जउन न भगवान लग डरथै अउ न कउनो मनसे के इज्जत करथै। ");
INSERT INTO bhu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","उहै सहर छो अक्ठी विधवा डउकी रथै, ऊ ओखर लिघ्घो आयके कहे करथै, मोर अनियाय के खिलाफ, उनखर लग मोके इन्साफ दिलवा। ");
INSERT INTO bhu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","कुछ रोज तक ऊ न्यायधीस, ओखर बिनती के परवाह नेहको करथै, पय बाद हे ऊ अपन मनै मन हइ कथै, मै न भगवान लग डरथो, अउ न कउनो मनसे के परवाह करथो। ");
INSERT INTO bhu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","पय हइ बिधवा डउकी मोके परसान करथै, इहैनिता मै एखर निता नियाव के जुगाड करहुं, जेखर लग ऊ बेर-बेर आय के मोके परसान करथै। ");
INSERT INTO bhu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","परभु कथै, “सुना अधरमी न्यायधीस काहिन कथै? ");
INSERT INTO bhu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ता का भगवान अपन चुने हर मनसेन के निता नियाव के जुगाड नेहको करी, जउन रात दिना चिरलात रथै, का ऊ उनखर बारे हे देरी करी? ");
INSERT INTO bhu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","मै तुम्हर लग कथो, ऊ हरबी उनखर निता नियाव करी, पय जब मनसे कर टोरवा आही, ता का ऊ भुंइ हे बिस्वास पाही?” ");
INSERT INTO bhu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","फेर यीसु उन मनसेन के निता कथै, अपन खुद के धरमी मनसे मानथै, अउ कउनोन के बेकार नेहको समझथै, हइ किस्सा सुनाइस। ");
INSERT INTO bhu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","दुइठे मनसे बिनती करै बिनती भवन छो गइन, अक्ठी फरीसी मनसे रथै, अउ दूसर पइसा उगाहै बाले सिपाही रथै। ");
INSERT INTO bhu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","फरीसी मनसे ठाडे ठाड हइमेर बिनती करत रथै, हे भगवान मै तोके धन्यबाद देथो, कि मै दूसर मनसेन के जसना लालची, अन्यायी, अउ बेभिचारनी नेहको हबो अउ न हइ पइसा उगाहै बाले साहब के जसना हबो। ");
INSERT INTO bhu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","मै हप्ता हे दुइ बार उपास रथो, अउ अपन सगलू कमाई के दसमा हीसा दान देथो। ");
INSERT INTO bhu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“पय पइसा उगाहै बाले सिपाही दुरिहां ठाड रथै अउ इहां तक कि स्वरग छो, अपन आंखी तक नेहको उठावत रहिस, अपन छाती ठोक के कथै, हे भगवान मै पापी हबो मोर हे दया कर। ");
INSERT INTO bhu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","यीसु कथै मै तुम्हर लग सच कथो, ऊ पहिला नेहको बलुक हइ धरमी मनसे पाप लग आजाद हुइ के अपन घर छो गइस काखे जउन कउ खुदय के बडडे बनाही ऊ तरी छो करे जही, अउ जउन अपन खुदय के नान बनाही ऊ उप्पर छो उठाय जही।” ");
INSERT INTO bhu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ऊ मनसे नान लरकन के यीसु के लिघ्घो लइ आनथै, कि ऊ उनही छुवै, पय जब चेला देखथै, ता मनसेन के गधारथै। ");
INSERT INTO bhu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","पय यीसु लरकन के अपन लिघ्घो बुलाथै, अउ चेलन लग कथै, इन नान लरकन के मोर लिघ्घो आमै देया, उनही झइ रोक, काखे कि भगवान कर राज असनेन के हबै। ");
INSERT INTO bhu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","मै तुमके सही कथो, कि असना कउनो मनसे के भगवान कर राज हे, अक्ठी नान लरका के जसना नेहको अपनाथै, स्वरग हे कबहुं नेहको जाय पइहीं। ");
INSERT INTO bhu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","कउनो सरदार यीसु लग पूछथै, निक्खा गुरू सबरोज के जीवन पामै के निता मोके काहिन करै के चाही। ");
INSERT INTO bhu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","यीसु ओखर लग कथै, मोके निक्खा काखे कथा? भगवान के छांड के कउनो मनसे निक्खा नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","तुम आदेस के जानथा, गलत काम नेहको करबे, खून नेहको करबे, चोरी नेहको करबे, झूठी गवाही ले बचबे अउ अपन दाय बाफ के इज्जत करिहा। ");
INSERT INTO bhu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ऊ कथै, हइ काम सगलू मै, लडकपन ले करत आय हबो। ");
INSERT INTO bhu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","यीसु ई बातन के सुनथै, ता ऊ उनखर ले कथै, अबहुन तोर हे अक्ठी बात के कमी हबै, तोर लिघ्घो जउन कुछ धन डेरा हबै, सगलू के बेच डार अउ फेर जउन कुछ पइसा मिलही उके गरीबन हे बांट दे, एखर ले तोके स्वरग हे धन डेरा मिलही, आ अउ मोर पाछू हुइ ले। ");
INSERT INTO bhu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","जब मालिक ई बात सुनथै, ता ऊ बोहत दुखी होथै, काखे ऊ बोहत धनमान रथै। ");
INSERT INTO bhu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","जब यीसु ई बात देखथै, कि ऊ मनसे बोहत दुखी हबै, ता ऊ कथै, उन मनसेन के लिघ्घो धन डेरा हबै, भगवान कर राज हे जाय के निता केतका दिग्गत हबै। ");
INSERT INTO bhu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","कउनो उंटवा के सूजी के नाक मसे निकरै के लिखडी हबै, पय कउनो धनी मनसे के, भगवान कर राज हे जाय के निता बोहत दिग्गत हबै। ");
INSERT INTO bhu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","उन मनसे ई बात सुनके कथै, गुठेबा मुकति केखर होही? ");
INSERT INTO bhu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","यीसु कथै, ऊ बात जउन मनसे के निता बोहत दिग्गत हबै, पय भगवान के निता सगलू बात बोहत लिखडी हबै। ");
INSERT INTO bhu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","“पतरस कथै, देख हमर लिघ्घो जउन कुछु रहिस, तोर पाछू आमै के निता, हम ऊ सगलू कुछु छांड दय हबन।” ");
INSERT INTO bhu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","यीसु उनखर लग कथै, मै तुम्हर लग सही कथो, असना कउनो मनसे नेहको हबै, जउन भगवान कर राज के निता, घर बार या डउकी या भाई या दाय-बाफ, लरकन के छांड दय होय, ");
INSERT INTO bhu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","अउ हइ लोक हे कई गुना, कुछु नेहको मिलै, अउ आमै बाले टेम हे, ऊ सबरोज के जीवन के नेहको पाय जही। ");
INSERT INTO bhu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","यीसु अपन बारहठे चेलन के अक्कै संग लइ जाय के कथै, सुना, हम यरुसलेम सहर छो जथन, मनसे कर टोरवा के बारे हे ग्यानी मनसे के दवारा जउन कुछु लिखे गय हबै ऊ पूर होही। ");
INSERT INTO bhu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","काखे कि ऊ दूसर जातन के हाथ हे पकडोय जही अउ ओखर खिल्ली उडाय जही, अउ ओखर निन्दा करही अउ ओखर उप्पर हे थुकहिन। ");
INSERT INTO bhu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","उन मनसे यीसु के पिटहिन, अउ उजाड डालही, अउ तीसर रोज ऊ फेरै जिन्दा हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ई सगलू बात चेलन के दिमाक हे नेहको घुसडथै, अउ उनखर ई बात लुके रथै, अउ जउन कुछु बात अपन चेलन लग गुठेवत रथै, ता ऊ समझ नेहको पाथै। ");
INSERT INTO bhu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","जब यीसु यरीहो सहर के लिघा पहुंचथै, ता अक्ठी अंधरा भिखारी मनसे, सडक के टाठा हे बइठके मनसेन लग भीख मांगत देखथै। ");
INSERT INTO bhu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","जब अंधरा, मनसेन के जाय के आरो सुनथै, ता ऊ पूछथै, इछो काहिन होथै? ");
INSERT INTO bhu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","मनसे ओखर लग कथै, यीसु नासरी जथै। ");
INSERT INTO bhu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ता अंधरा मनसे चिरलायके कथै, “हे यीसु दाऊद कर टोरवा, मोर उप्पर दया कर।” ");
INSERT INTO bhu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ऊ मनसे जउन ओखर आगू रेंगत रहिन ऊ ओही डांटथै, चुप्पे रह पय ऊ अउ बोहत चिरलाय लागथै अउ कथै, “हे दाऊद कर टोरवा मोर उप्पर दया कर।” ");
INSERT INTO bhu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","यीसु रेंगत-रेंगत रुक जथै अउ ऊ आदेस दइके कथै, अंधरा मनसे के मोर लिघ्घो लावा, अउ जब ओही यीसु के लिघा लानथै, ता यीसु ओखर लग पूछथै। ");
INSERT INTO bhu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","तै काहिन चाहथस, कि मै तोर निता करव, ऊ कथै, हे परभु, मै देखै चाहथो। ");
INSERT INTO bhu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","यीसु ओखर लग कथै, जा देखै लग, “तोर बिस्वास तोर आंखी के निक्खा करै हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ता अंधरा मनसे अपन आंखी लग देखै लग जथै, अउ भगवान कर बडाई करत यीसु के पाछू कढ जथै, अउ सगलू मनसे ऊ काम के देखके भगवान कर भजन करथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","यीसु यरीहो सहर हे परवेस हुइके जथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","उहां जक्कई नाम के अक्ठी मनसे रथै, ऊ पइसा उगाहै बाले के मुखिया रथै, अउ ऊ धनी मनसे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ऊ धनी मनसे यीसु के देखै चाहथै, कि ऊ कोनहर हबै, पय मनसे के भीड के कारन ओही, ऊ नेहको देख सकथै, काखे कि ऊ बामन गुज्जी रथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ता जक्कई यीसु के देखै के निता, आगू दउर के जथै, अउ ऊ ऊमर के रूख हे चढ जथै, काखे कि यीसु उहै गली लग जाय बाले रथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","जब यीसु ऊमर के रूख के लिघ्घो पहुंचथै, ता उप्पर देखके जक्कई लग कथै, हे जक्कई रूख लग हबा उतर के आ, आज मोके तोर घर हे रहै के जरूरी हबै। ");
INSERT INTO bhu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","तब जक्कई हरबी रूख लग तरी उतरथै, अउ खुसी के संग अपन इहां यीसु के सोगत करिस। ");
INSERT INTO bhu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","हइ देखके सगलू मनसे जलै लग जथै, अउ कथै यीसु तो पापी मनसे के महिमान बनै गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","पय जक्कई सबके आगू ठाढ हुइस, अउ ऊ परभु लग कथै, हे परभु देख मै अपन आधा डेरा गरीबन के दइ देहुं, अउ मै कउनो गलती लग कुछु लय हबो, ता उके चारगुना लउटाय दइहों। ");
INSERT INTO bhu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","यीसु कथै, “आज हइ घर हे मुकति आय हबै, काखे जक्कई अब्राहम के अक्ठी टोरवा हबै। ");
INSERT INTO bhu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","काखे कि मनसे कर टोरवा भुलाय हर मनसे के खोजै, अउ उनखर मुकति करै के निता आय हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ऊ मनसे ई बात के सुनथै, ता यीसु उनही अक्ठी अउ किस्सा गुठेथै, काखे कि यीसु यरुसलेम देस के लिघा रथै अउ सोचथै, कि भगवान कर राज हरबी सुरू होय बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","यीसु कथै, अक्ठी धनी मनसे बोहत दुरिहां देस हे चला, अपन निता राज पाठ के फेरै लामै के निता सोचथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ऊ अपन दसठे हरवाहन के अपन लिघ्घो बुलवाथै, अउ उनही सबझन के दस-दसठे खोटन्ना देथै, अउ उनके कथै, जब तक मै नेहको लउट आंव तब तक ऐहमा लेन देन करिहा। ");
INSERT INTO bhu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","पय ओखर सहर के दूसर मनसे, ओखर लग बुराई करत रथै, इहैनिता ओही मारै के निता, ओखर पाछू अक्ठी मनसे के पठोथै, काखे हम नेहको चाहथन, कि ई मनसे हमर उप्पर राज करै। ");
INSERT INTO bhu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","राजपद पाय के जब ऊ फेरै लउटथै, ता ऊ अपन हरवाहन के जेही पइसा दय रथै, उनही अपन लिघ्घो बुलवाथै, ता पता करै कि लइ दइ के, ऊ मनसे केतका-केतका कमाय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","तब अक्ठी हरवाह मनसे लग आयके कथै, हे मालिक तोर पइसा लग, मै दसठे चांदी के खोटन्ना अउ कमाय हबो। ");
INSERT INTO bhu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","मालिक ओखर लग कथै, बढिहा हबै तुम चुटु लग पइसा हे इमानदार हबस, इहैनिता अब तुम दस सहर हे हक रख। ");
INSERT INTO bhu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","फेर दूसर हरवाह आथै अउ कथै, हे मालिक तोर खोटन्ना लग पांचठे खोटन्ना अउ कमाय हव। ");
INSERT INTO bhu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","मालिक ओही पांचठे सहर के जिम्मेदारी दइ देथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","तीसर हरवाह आयके कथै, हे मालिक देख ई हबै, तोर पइसा जउन तै मोके दय रथस, मै इके निक्खा साफी हे गठियाय के धरे रहों। ");
INSERT INTO bhu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","मै तोर लग डेराय रहों, काखे कि तै अक्ठी बेकार मनसे हबस, तै जउन धराय नेहको हबस, तै उहो के लइ लेथस, अउ जउन तै बोय नेहको हबस, वहु के काट लेथस। ");
INSERT INTO bhu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","मालिक ओखर लग कथै, हे मूरख नवकर मै तोके अपन सब्द के आधार हे तोके नियाव करहुं, तै तो जानथस, कि मै जउन नेहको धरथो, उके उठाय लेथो, अउ जउन मै नेहको बोथो वहु के काट लेथो। ");
INSERT INTO bhu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","तो तै मोर देय हर पइसा, काखे बैंक हे नेहको धरे हबस, ता बेयाज के संग मोके मोर पइसा मिलतै। ");
INSERT INTO bhu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","उहां ठाढे मनसे मालिक लग कथै, ई मनसे ले पइसा लइके उके दइदा, जउन सगलू लग बोहत कमाय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","उन कथै, मालिक ओखर लिघ्घो ता आगू लग दसठे खोटन्ना हबै। ");
INSERT INTO bhu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","मालिक कथै, जेखर लिघ्घो हबै, उके अउ मिलही, जेखर लिघा हबै, वहु के लइ ले जही। ");
INSERT INTO bhu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","पय मोर ऊ बैरी के मोर लिघा इहां ले आबा, जउन नेहको चाहथै, कि मै उनखर उप्पर राज करहुं, मोर आगू उनके उजाड देया। ");
INSERT INTO bhu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","हइ बात गुठेके बाद हे यीसु आगू रेंगत यरुसलेम सहर छो आगू-आगू रेंगथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","अउ फेर जब ऊ बैतफगे अउ बैतनिय्याह हे ऊ डोंगर के लिघ्घो पहुंचथै, जउन जैतून के डोंगर कहाथै, ता ऊ अपन दुइठे चेलन के ई बात गुठेके पठोथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","जउन गांव तुम्हार आगू हबै, उहां जा जसना तुम उछो पहुंचिहा, ता उहां तुमही गदहा के अक्ठी, लरका खुट्टा हे बधररे हर मिलही, जेखर उप्पर कउनो मनसे कबहुन सवार नेहको करे होय, उके छोर के हइछो लग आनबे। ");
INSERT INTO bhu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","अउ कउनो तुम्हर लग पूंछहिन, तुम हइके काखे छोरथा, ता तुम ओखर लग ई बात गुठेबे कि परभु के एखर जरूरत हबै। ");
INSERT INTO bhu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","जउन पठोय गय रथै, उन मनसे उछो गइन अउ यीसु उनही, जउन बात गुठे रथै, उनही ओसनेन ही मिलथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","जब उन मनसे गदहा कर लरका के छोरत रहिन, ता ओखर मालिक उनखर लग पूछथै, तुम गदहा के लरका के काखे छोरथा। ");
INSERT INTO bhu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","उन चेला कथै, परभु के एखर जरूरत हबै। ");
INSERT INTO bhu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","उन मनसे गदहा के लरका के यीसु के लिघ्घो लइके आथै, अउ उन अपन बन्डी के उतार के गदहा के लरका के उप्पर बिछाय देथै, अउ यीसु के ओखर उप्पर बइठा देथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","जब यीसु जथै, ता मनसे अपन बन्डी अउ चदरा के उतार के गली हे ओखर आगू बिछावत जात रथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","अउ जब यीसु जैतून के डोंगर के तरी छो पहुंचथै, ता चेलन के केतका भीड उन सगलू चकराय के काम के जउन उन देखथै, ऊ बोहत आरो लग खुसी के संग भगवान कर भजन करै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","निक्खा हबै ऊ राजा जउन परभु के नाम लग आथै, स्वरग छो सान्ति, अउ बादर हे भगवान कर महिमा होय। ");
INSERT INTO bhu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","तब भीड मसे कुछ फरीसी मनसे गुठे लागथै, हे गुरू, अपन चेलन के डांट। ");
INSERT INTO bhu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","यीसु उनके जबाब देथै, मै तुम्हर लग कथो, कि अगर हइ मनसे चुप रइहीं, ता पथरा चिरला उठहिन। ");
INSERT INTO bhu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","सहर के लिघा आथै, ता यीसु ऊ सहर के देखके रोय पडथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","अउ कथै, निक्खा होतै, अगर तुम आजय सान्ति देय बाले बातन के जाने होतो, पय ऊ बात तुम्हर नजर हे लुके हबै। ");
INSERT INTO bhu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ऊ रोज तोर उप्पर आही, जब तोर बैरी चारो ओर दिग्गत ठाड के देहिन, ता ऊ तोके घेर लेही, अउ सगलू पल्ला लग तोके दीब डरहिन। ");
INSERT INTO bhu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ऊ तोके माटी हे मिलाय देहिन, अउ तोर भित्तर रहै बाले, तोर लरका के तोर चारदिबारी के भित्तर, ऊ अक्ठी पथरा के उप्पर दूसर पथरा नेहको रहै देही, काखे कि भगवान तोर लिघ्घो आय हबै, तै ऊ टेम के नेहको चिन्ह पाय। ");
INSERT INTO bhu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","जब यीसु मन्दिर छो जथै, अउ जउन मनसे उहां दुकान लगाय रथै, उनही बाहिर छो निकाडै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","यीसु उनखर लग कथै, पवितर किताब हे लिखररे हबै, मोर घर बिनती के घर होही, पय तुम हइके चोरटन के जिघा बनाय डारे हबा। ");
INSERT INTO bhu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","यीसु सबरोज मन्दिर हे सिखावत रथै, पय प्रधान याजक अउ नियाव के गुरू, अउ अगुवा उके उजाडै के निता सोचथै। ");
INSERT INTO bhu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","अउ ऊ मनसे कुछु नेहको के पाथै, काखे कि ऊ सगलू मनसे बोहत धियान लग यीसु के बातन के सुनथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","अक रोज यीसु बिनती भवन छो मनसेन के सिक्छा देथै अउ संदेस सुनाथै, कि मुखिया याजक अउ नियाव के गुरू सियानन मनसेन के संग ओखर लिघ्घो आथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","मनसे यीसु लग पूछथै, “हमके गुठे तै हइ काम केखर हक लग करथस, ऊ कउन हबै जउन तोके हइ हक दय हबै?” ");
INSERT INTO bhu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","यीसु उनही जबाब देथै, “मै तुम्हर लग अक्ठी सबाल पूछथो तुम मोके गुठेबा? ");
INSERT INTO bhu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","यूहन्ना कर बतिस्मा स्वरग के पल्ला लग रथै, या मनसेन के पल्ला लग?” ");
INSERT INTO bhu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","उन मनसे अपनै हे गुठेमै लागथै, अगर हम गुठेबो कि स्वरग के पल्ला लग, ता यीसु गुठेही कि तुम मनसे यूहन्ना हे बिस्वास काखे नेहको करा? ");
INSERT INTO bhu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","अगर हम गुठेबो ऊ मनसे के पल्ला लग हबै, ता सगलू मनसे हमके पथरा मरही, काखे कि यूहन्ना के ग्यानी मनसे समझथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","इहैनिता उन यीसु के जबाब देथै, “हम नेहको जानथन कि ऊ केखर पल्ला लग रथै।” ");
INSERT INTO bhu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","“यीसु उनखर लग कथै, मै तुमके नेहको गुठेहूं, कि मै हइ काम केखर हक लग करथो।” ");
INSERT INTO bhu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","फेर यीसु मनसेन के हइ किस्सा सुनाथै, कउनो मनसे अंगूर के बगिया लगाइस अउ उके कुछ किसानन के ठेका हे दइके बोहत रोज के निता परदेस चले गइस ");
INSERT INTO bhu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","टेम आमै हे ऊ फसल के हिस्सा पामै के निता किसानन के लिघ्घो अक्ठी हरवाह के पठोथै, कि उन बगिया के बारी के कुछ फडुहा के बांटा उके दे, पय किसान उके मारथै पीटथै अउ छूछे हाथ लउटाय देथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","फेरै ऊ दूसर हरवाह के पठोथै, ओखरो संग ओसनै करथै अउ छूछे हाथ लउटाय देथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ता ऊ तीसर हरवाह के पठोथै, पय उहो के अधमरहा करके बाहर छो निकाड देथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ता ऊ बगिया के मालिक कथै, मै काहिन करव, अब मै अपन पिरिया टोरवा के, उनखर लिघ्घो पठोहूं, सायद उके देखके, उन मनसे ओखर इज्जत करै। ");
INSERT INTO bhu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","पय उके देख के किसान, अपने हे कथै, इहै डेरा के मालिक हबै, आबा इहो के मार डारी, ता सगलू कुछु डेरा हमर हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ऊ मनसे बगिया के बाहिर निकार के मार डारिन, इहैनिता अंगूर के बगिया के मालिक उनखर संग का करी? ");
INSERT INTO bhu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ऊ आही अउ उन किसानन के मार डारही, अउ अंगूर के बगिया के दूसर मनसे के दइ देही, हइ बात सुनथै, ता गुठेथै असना भगवान झइ करै। ");
INSERT INTO bhu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","उनखर पल्ला निहाडथै, अउ कथै, ता फेर हइ काहिन लिखवरे हर हबै, जउन पथरा के मिसतिरी बेकार समझे रथै, पथरा कोन्टा के मुखिया बन जथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","जउन कउ पथरा हे गिरही ता खुन्डा-खुन्डा हुइ जइही, अउ जेखर उप्पर ऊ पथरा गिरही ता ऊ पिसरर जही। ");
INSERT INTO bhu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ऊ टेम नियाव के गुरू अउ प्रधान याजक ताक हे रथै, कि यीसु के कउनो मेर पकर लइ, काखे उन मनसेन लग डर गइन, यीसु किस्सा लग उनखर पल्ला इसारा करथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ऊ मनसे यीसु के ताक हे रथै, अउ उन बदमासन के पठोथै, कि धरम के भेस बदल के, यीसु के कउनो बात के पकडै, ता ओही न्यायधीस के हाथ हे सउप दइ। ");
INSERT INTO bhu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","इहैनिता उन पूछथै अउ कथै, गुरू हम जानथन, कि जउन निक्खा बात हबै, तै उहै बात के गुठेथस अउ उहै के आदेस देथस अउ न तै कउनो के पल्ला लेथस, पय निक्खा भगवान कर रास्ता के सिक्छा देथस। ");
INSERT INTO bhu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","गुठे कि हम कैसर राजा बयाज देय का उचित हबै कि नेहको? ");
INSERT INTO bhu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","यीसु उनखर आदत के समझ जाथै, इहैनिता उनखर लग कथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","चांदी के पइसा मोके दिखाबा, ओखर उप्पर केखर छाप अउ नाम हबै, उन मनसे कथै कैसर कर। ");
INSERT INTO bhu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","यीसु उनखर लग कथै, ता फेरै जउन कैसर कर हबै, ओही कैसर के देया अउ जउन भगवान कर हबै ओही भगवान के देया। ");
INSERT INTO bhu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ऊ मनसे ओखर जबाब हे मगन हुइके चुप रह जथै अउ ऊ मनसेन के आगू जउन कुछ बात गुठे रहिस, ऊ बात हे यीसु के नेहको पकड पाथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","मरे हर मनसे जिन्दा होयके नेहको हबै, बिस्वास नेहको करै बाले सदूकी मनसे, आयके यीसु लग सबाल पूछथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“हे गुरू मूसा लिखे हबै कि, अगर कउनो मनसे मर जाय अउ ओखर लरका नेहको हबै अउ ओखर डउकी हबै, ता ओखर भाई ऊ बिधवा डउकी लग, काज करके अपन भाई के निता लरका पइदा करै। ");
INSERT INTO bhu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","सातठे भाई रथै, पहिले बाले भाई कउनो डउकी ले काज करथै, अउ ऊ बिना कउनो लरका होबाय के मर जथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","फेर दूसर भाई ओखर लग काज करथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","उहै मेर तीसर भाई ऊ डउकी लग काज कर लेथै, अउ सगलू भाई उहै मेर करथै, इहैमेर सातो बिना लरका होबाय मर जथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","कुछ रोज हे ऊ डउकी मर जथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","अब गुठेबा जिन्दा होय लग, उन मसे केखर डउकी होही, काखे कि सातो भाई लग काज करे रथै।” ");
INSERT INTO bhu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","यीसु उनखर लग कथै, या हइ पीढी के डउका अउ डउकी काज करथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","पय ऊ मनसे जउन पीढी के कउनो हिस्सा जसना, अउ मरे हर मसे जिन्दा होय के निता ठहराय गय हबै, ऊ न तो काज करही अउ न काज करके बिदाई करे जही। ");
INSERT INTO bhu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","अउ ऊ फेरै कबहुन नेहको मरही, काखे कि उन स्वरगदूतन के जसना हबै, ऊ भगवान कर टोरवा हबै, काखे कि ऊ जिन्दा होय हर के टोरवा हबै। ");
INSERT INTO bhu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","अब मरे हर जिन्दा होही या नेहको? मूसा पुडरा कर किस्सा हे गुठेय हबै, कि ऊ परभु के अब्राहम, इसहाक अउ याकूब मरै के, केतका टेम के बाद हे, ऊ भगवान के अब्राहम, इसहाक अउ याकूब के भगवान कथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ऊ मरे हर के भगवान नेहको, पय जिन्दा मनसे के भगवान हबै, उन सगलू मनसे जउन ओखर लिघ्घो हबै, उन जिन्दा हबै। ");
INSERT INTO bhu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ई बात सुनके कुछ नियाव के गुरू कथै, हे गुरू तै सही कथस। ");
INSERT INTO bhu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","अउ फेरै ओखर लग कउनो मनसे अउ सबाल पूछय के हिम्मत नेहको कर सकिन। ");
INSERT INTO bhu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","फेर यीसु उनखर लग कथै, “ऊ कथै कि मसीह दाऊद कर टोरवा हबै हइ बात कसना हुइ सकथै?” ");
INSERT INTO bhu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","काखे कि भजन संहिता के किताब हे दाऊद खुदय कथै, कि परभु मोर परभु लग कथै, मोर दहिना हाथ के पल्ला बइठ। ");
INSERT INTO bhu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","जब मै तोर बैरी के तोर गोड के तरी नेहको कर दइहों। ");
INSERT INTO bhu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“जब दाऊद मसीह के परभु कथै, ता ऊ दाऊद कर टोरवा कसना हुइ सकथै?” ");
INSERT INTO bhu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","मनसे उनखर बात के सुनथै, ता यीसु अपन चेलन लग कथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","नियाव के गुरू मनसे लग चेतन्त रइहा, उनके लम्बा-लम्बा खुरथा पइजामा ओढ के फिरै के निक्खा लगथै, ऊ बाजार हे मनसेन लग नमस्ते लेत फिरत हबै, उनके सभा सम्मेलन हे आगू के जिघा अउ दावत हे निक्खा जिघा पसंद करथै। ");
INSERT INTO bhu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ऊ बिधवन कर घर लूट लेथै अउ दिखामै के निता लम्बा चवडा बिनती करथै, उनही बोहत लग सजा मिलही। ");
INSERT INTO bhu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","यीसु आंखी उप्पर उठाय के अमीर मनसे के बिनती भवन के दान पेटी के खजाना हे अपन दान डालथै। ");
INSERT INTO bhu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ऊ अक्ठी गरीब बिधवा डउकी तांबा के दुइठे नान खोटन्ना डालत देखथै। ");
INSERT INTO bhu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“यीसु कथै, मै तुम्हर लग सही कथो, कि दूसर सगलू मनसे मसे हइ गरीब बिधवा डउकी सब लग बोहत दान दय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","हइ बात मै इहैनिता कथो, काखे कि ई सगलू मनसे अपन ऊ धन डेरा मसे जेही उनके जरूरत नेहको रहिस दान दइन, पय ई डउकी गरीब हबै, तउभरमा जिन्दा रहै के निता जउन कुछु ओखर लिघ्घो रहिस, सगलू कुछ दइ दइस।” ");
INSERT INTO bhu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","जब कुछ मनसे बिनती भवन के बारे हे चरचा करत रथै, कि ऊ निक्खा पथरा अउ भगवान के दान देय हर भेंट लग कसना सजाय गय हबै, ता यीसु कथै। ");
INSERT INTO bhu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ऊ रोज आही जब ई जउन तुम देखथा, ओहमा अक्ठी पथरा दूसर पथरा लग टिके नेहको रह पाही, पय सगलू गिराय जही। ");
INSERT INTO bhu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ऊ मनसे ओखर ले पूछथै अउ गुठेथै, “हे गुरू हइ बात सब कब होही? अउ बात जउन होंय बाले हबै ओखर काहिन चिन्ह होही।” ");
INSERT INTO bhu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","यीसु कथै, चेतन्त रइहा, कही कउनो तुमही भडकाय झइ जाय, काखे कि मोर नाम लग बोहत मनसे अइहिन अउ गुठेही, ऊ मै हबो अउ टेम आ गय हबै उनखर पाछू झइ जाबे। ");
INSERT INTO bhu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","जब तुम लडाई झगडा के चरचा सुनिहा ता झइ डरिहा, काखे कि इनखर बात पहिले होही अउ उनखर अन्त हरबी नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","तब यीसु उनखर लग कथै, अक्ठी जात दूसर जात के बिरोध हे ठाड हुइहिन, अउ अक्ठी राज दूसर राज के बिरोध हे चढाई करही। ");
INSERT INTO bhu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","भयानक भुंइडोल आही अउ कउनो जिघा पय अकाल पडही अउ महामारी होही, बादर हे बोहत घटनाय घटही अउ महान चिन्ह सुरू होही। ");
INSERT INTO bhu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","पय ई बातन के आगू ऊ मनसे तुमही बन्दी बना लइहीं अउ सतइही, ऊ तुम्हर उप्पर अधिकार के आदेस चलाय के निता तुमके मंडली दरबार हे दइ देइही अउ फेर मोर नाम के कारन ऊ तुमही, राजा अउ राजपालो के आगू लइ जइही। ");
INSERT INTO bhu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","एखर लग तुमही, मोर बारे हे गवाह देय के मउका मिलही। ");
INSERT INTO bhu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","इहैनिता अपन मन हे ठान लेया, कि हम पहिले लग जबाब देवै के निता चिन्ता झइ करिहा। ");
INSERT INTO bhu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","काखे कि मै तुमके अइसन दिमाक अउ अइसन सब्द देहुं, कि तुम्हर कउनो बैरी तुम्हार सामना अउ खन्डन नेहको कर सकही। ");
INSERT INTO bhu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","पय तुम्हर दाय-बाफ भाई सखा सगा अउ संगी तुमही धोखा लग पकरही, अउ तुम्हर हे कुछ मनसे के मरवा डरही। ");
INSERT INTO bhu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","मोर नाम के कारन सगलू मनसे तुम्हर लग घिनाही। ");
INSERT INTO bhu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","पय तुम्हर मूड के अक्ठी चूंदी बाका नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","अपन धीरज लग तुम अपन परान के बचाय रखिहा। ");
INSERT INTO bhu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","जब तुम यरुसलेम सहर के सेना लग छिन्दररे देखबे ता, समझ लेबे कि ओखर बरबादी लिघ्घो हबै। ");
INSERT INTO bhu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ता जउन मनसे यहूदिया हे हबै, ऊ डोंगर छो कढ जाय अउ जउन यरुसलेम के भित्तर हबै, ऊ बाहिर कढ जाय अउ जउन गांव हे हबै, ऊ सहर छो आबै के परयास झइ करै। ");
INSERT INTO bhu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","काखे कि ऊ टेम पलटा लेय के निता होही, ता जउन लिखररे हबै, ऊ सगलू बात पूर होही। ");
INSERT INTO bhu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","उन डउकी के निता जउन लादा हे होही अउ जउन उनखर निता दूध पियाउत होही, ऊ रोज केतका भयंकर होही, काखे कि ऊ रोज भुंइ छो बोहत दिग्गत आही अउ ई मनसे भगवान के उप्पर गुस्सा हुइहिन। ");
INSERT INTO bhu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","अउ जउन तलबार के धार ले गिराय दय जही, अउ बन्दी बनके सगलू देसन हे पठोय दय जही, अउ यरुसलेम दूसर जातन के गोड तरी तब तक कचरै जही, जब तक गैर यहूदी के टेम पूर नेहको हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“बेरा, जोधइया अउ तरइया हे चिन्हा सुरू होही अउ भुंइ हे सगलू जात हे दिग्गत आही अउ सागर हे उधल पुथल लग घबरा जइहिन। ");
INSERT INTO bhu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","डर के कारन अउ दुनिया हे आमै बाले दिग्गत के देखत-देखत मनसे के जीव हे जीव नेहको रही, काखे बादर के सक्ति डोलाय जही। ");
INSERT INTO bhu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","अउ तब ऊ मनसे कर टोरवा के अपन सक्ति अउ महान महिमा के संग बादर हे आउत देखही। ");
INSERT INTO bhu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","जब ई बात होय लगी ता, अपन मूड उप्पर के पल्ला उठाबे, काखे कि तुम्हर मुकति होय के लिघ्घो आय चुके होही।” ");
INSERT INTO bhu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ऊ उनखर लग अक्ठी किस्सा गुठेथै, अउ सगलू रूख अउ अंजीर के रूख के देखा। ");
INSERT INTO bhu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","वहमा जइसन फूल फुटकथै, ता तुम अपन खुद जान जथा, कि बइसाख कर टेम आ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ओसनेन तुम जब ई बातन के घटत देखिहा ता जान लइहा कि भगवान कर राज लिघ्घो हबै। ");
INSERT INTO bhu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","मै तुम्हर लग सही कथो, कि जब तक सगलू बात नेहको घट जही तब तक हइ पीढी कर मनसे नेहको बढाही। ");
INSERT INTO bhu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","बादर अउ भुंइ टर जही, पय मोर बात कबहुन नेहको टर सकथै। ");
INSERT INTO bhu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","इहैनिता सचेत रहा ताकि तुम्हार मन भोग बिलास हे कही मतबालेपन अउ हइ जीवन चिन्ता लग सुस्त झइ होबे, अउ ऊ रोज हरबी तुम लिघ्घो आमैके पडही। ");
INSERT INTO bhu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","इहैनिता कि ई टेम सगलू भुंइ हे रहैबाले मनसे हे इहै मेर जसना आय पडही। ");
INSERT INTO bhu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","यीसु कथै, सबरोज जागत रहा अउ बिनती करत रहा, ताकि तुम हइ आमै बाले परेसानी लग बच सकिहा अउ मनसे कर टोरवा के आगू हिसाब दइ सकिहा। ");
INSERT INTO bhu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","यीसु दिन हे बिनती भवन हे संदेस दे करथै अउ रात हे जैतून नामक डोंगर छो रहै करथै। ");
INSERT INTO bhu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","अउ भिनसारे कर टेम सगलू मनसे बिनती भवन हे यीसु के बात सुनै के निता आय करथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","फसह के तेउहार जेही, अखमीरी रोटी के तेउहार गुठे जथै लिघ्घो रथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","परधान याजक अउ नियाव के गुरू जउन मनसेन लग डरथै अउ जुगाड खोजथै, कि यीसु के कसना मारी। ");
INSERT INTO bhu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","यीसु के बारहठे चेलन मसे अक्ठी चेला जेखर नाम यहूदा इस्करियोती रथै, ओखर जीव हे भुतवा समाय जथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","परधान याजक अउ बिनती भवन के सुरक्छा पहरेदार के मुखिया मनसेन लग ऊ बात गुठेथै, कि ऊ कउन मेर यीसु के उनखर हाथ हे पकरवाबै। ");
INSERT INTO bhu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","उन बोहत मगन हुइन अउ उके धन डेरा देय के सहमत हुइ गइन। ");
INSERT INTO bhu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","यहूदा बचन दइस अउ असना मउका ढूंढै लग जथै, जब यीसु के संग मनसे के भीड नेहको होही, ता उके उनखर हाथ हे पकडोय दइहों। ");
INSERT INTO bhu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","जब अखमीरी रोटी के तेउहार ऊ रोज आथै, जब गेडरा के चढावा चढामै के जरूरी रथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","यीसु पतरस अउ यूहन्ना के हइ गुठेके पठोथै, कि जाय के खाना के निता फसह के भोज तइयारी करै। ");
INSERT INTO bhu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ऊ उनखर लग पूछथै तुम हमर लग काहिन चाहथा, हम कछो ओखर तइयारी करी? ");
INSERT INTO bhu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","यीसु उनखर लग कथै तुम जसना सहर हे घुसिहा, ता तुमही पानी लग भरेहर अक्ठी गघरी लइ जात अक्ठी मनसे मिलही, ता ओखर पाछू हुइ लेबे जेखर घर छो ऊ जइ, तुमो ओखर पाछू कढ जाबे। ");
INSERT INTO bhu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","अउ घर के मालिक ले गुठेइहा, गुरू तोर ले पूछे हबै, कि ऊ पहुना के घर कछो हबै, जेहमा मै अपन चेलन के संग फसह तेउहार के भोजन कर सको? ");
INSERT INTO bhu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ऊ तुमही अक्ठी सजररे हर कोठा दिखाही, उहै सगलू तइयारी करबे। ");
INSERT INTO bhu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","जसना उके यीसु गुठे रथै, ऊ ओसनेन पाथै अउ ऊ फसह तेउहार के तइयारी करथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","अउ जब ऊ रोज अउ ऊ टेम आय जथै, ता यीसु अपन चेलन के संग भोजन करै बइठ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","यीसु उनखर लग कथै, “पीरा उठाबै लग आगू बोहत मन इक्छा रहिस, कि फसह तेउहार के भोजन तुम्हर संग खांव। ");
INSERT INTO bhu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","काखे कि मै तुम्हर लग कथो, कि जब तक भगवान कर राज हे, ई बात पूर नेहको हुइ जही, तब तक मै परभु भोज कबहुं नेहको खइहों।” ");
INSERT INTO bhu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ता यीसु हाथ हे खोरिया लेथै, अउ भगवान के धन्यबाद करथै अउ चेलन ले कथै, “इके अपन हे बांट लेया। ");
INSERT INTO bhu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","काखे कि मै तुम्हर लग कथो, कि जब तक भगवान कर राज नेहको आही, तब लग मै अंगूर के रस्सा के कबहुन नेहको पिहों।” ");
INSERT INTO bhu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","यीसु रोटी लेथै अउ भगवान के धन्यबाद करै के बाद रोटी टोरथै अउ अपन चेलन के हइ कहिके देथै, हइ मोर देह हबै जउन तुम्हर निता दय जथै कि मोर सुरता हे इहैमेर तुम करिहा। ");
INSERT INTO bhu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ओसनेन उन खाय के बाद, हइ कहत खोरिया देथै अउ कथै, ई खोरिया मोर ऊ खून के जसना, अक्ठी नबा टीमा के निसानी हबै जउन तुम्हर निता बहोय जथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","पय देखा मोके धोखा दइके पोकडोही अउ ओखर हाथ इहै टेबुल हे मोर संग हबै। ");
INSERT INTO bhu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","मनसे कर टोरवा कथै जसना होय के हबै ओसनेन मोर संग होही, पय हाय ऊ मनसे हे जेखर दवारा ऊ पकडोय जही। ");
INSERT INTO bhu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ता चेला अपनै हे गुठेमै लग जथै, कि हमर मसे कोनहर हबै जउन ई मेर के काम करही। ");
INSERT INTO bhu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","चेलन हे अक दूसर लग झगडा हुइ जथै, कि हमर मसे कोनहर सबले बड समझथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","पय यीसु उनखर लग कथै, गैर यहूदिन के राजा उनखर हे सासन करथै अउ ऊ जउन उनखर हे हक के परयोग करथै, खुदय के मनसे के उपकारक कहुवामै चाहथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","पय तुम ओसनै नेहको हबा, बलुक तुम्हर लग जउन बडे हबै, ऊ सबले नान के जसना होय चाही, अउ जउन राजा हबै, ऊ हरवाह के जसना होय चाही। ");
INSERT INTO bhu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","काखे बडे कोनहर हबै, जउन खाना खाय बइठे हबै, या ऊ जउन खाना परोसथै, काखे खाना खाय बाले के बडा नेहको समझे जथै, काखे मै तुम्हर सबझन के बीच हे, हरवाह के जसना हबो। ");
INSERT INTO bhu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","तुम ऊ हबा जउन, मोर परिक्छा हे सबरोज मोर संग रथा। ");
INSERT INTO bhu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","अउ जसना मोके भगवान बाफ अक्ठी राज दय हबै, ओसनेन महुं तुम्हर निता अक्ठी राज देथो। ");
INSERT INTO bhu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ता मोर राज हे तुम टेबुल हे खइहा अउ पीहा, अउ राजगद्दी हे बइठ के इस्राएल के उन बारहठे गोतिन के फइसला करिहा। ");
INSERT INTO bhu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","यीसु कथै, समोन हे समोन देखा भुतवा तुम मनसेन के मांग लय हबै, ता तुमके गोहूं के जसना फटकही। ");
INSERT INTO bhu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","पय मै तुम्हार निता बिनती करे हबो, कि तुम्हर बिस्वास झइ डगमगाय अउ जब तै लउटबे ता तोर भाई के बल बढही। ");
INSERT INTO bhu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","पय समोन ओखर ले कथै, हे परभु मै तोर संग जेल जाय अउ मरै के तइयार हबो। ");
INSERT INTO bhu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","यीसु कथै, हे पतरस मै तोर ले कथो कि जब तक कुकडी बांस नेहको लेही, तब तक तै तीन बार मना नेहको कर लेबे कि तै मोके जानथस। ");
INSERT INTO bhu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","यीसु अपन चेलन ले कथै, मै तुमके जब बगैर परस, बगैर थइला, या बगैर बूट के पठोथो, ता का तुमके कउनो चीज के कमी होय रहिस? उन कथै, कउनो चीज के कमी नेहको हुइस। ");
INSERT INTO bhu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ता यीसु “उनखर लग कथै, इहां ले अब जेखर लिघ्घो अक्ठिन परस हबै, ऊ उके ले अउ अक्ठी थइला लइ ले जेखर लिघ्घो तलबार नेहको हबै, ऊ अपन खुरथा पइजामा बेच के अक्ठी तलबार खरीद ले। ");
INSERT INTO bhu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","मै तुम्हर लग कथो, कि जउन कुछ लिखररे हबै, ऊ पूर होही अउ ऊ हबै कि सगलू चोरटा हे, महुं चोरटा गिने गय हबो, मोर बारे हे लिखरेर हर सगलू बात पूर होही।” ");
INSERT INTO bhu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ऊ गुठेथै, “हे परभु देख इहां दुइठे तलबार हबै।” हइ बात हे ऊ उनखर लग कथै, “बोहत हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","तब यीसु बाहिर निकरके, अपन रीति के जसना जैतून डोंगर छो बिनती करै जथै अउ चेला ओखरै पाछू हुइ लेथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ऊ जिघा पहुंच के यीसु चेलन लग कथै, बिनती करा कि तुम परिक्छा हे झइ पडा। ");
INSERT INTO bhu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","अउ कउनो पथरा के जेतका दुरिहां तक फेके जाय सकथै, ओतकै दुरिहां जाय के यीसु घुटवा के बल झुकथै अउ बिनती करै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","हे बाफ अगर तोर मरजी हबै ता, ई दुख के कटोरा मोर ले दुरिहां कर दे, पय मोर मरजी नेहको, बलुक तोर मरजी पूर होय। ");
INSERT INTO bhu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ता अक्ठी स्वरग के दूत यीसु के दिखाई देथै, जउन उके सक्ति देथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","यीसु बोहत पीरा हे चिन्तित हुइके, जब भगवान लग बिनती करै लग जथै अउ ओखर पसीना खून के बून्द बडी-बडी भुंइ हे टपकथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ता यीसु बिनती करके उठथै अउ अपन चेलन के लिघ्घो आयके, उनही उदास के मारे सोउत पाथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","अउ उनखर लग कथै, “काखे सोथा? उठा अउ बिनती करा कि तुम परिक्छा हे झइ पडा।” ");
INSERT INTO bhu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","यीसु ई बात गुठेवत रथै, ता अचानक मनसेन के भीड अउ ऊ बारहठे चेलन मसे अक्ठी चेला जेखर नाम यहूदा रथै, अउ मनसेन के आगू उनखर अगुवाई करथै अउ ओखर लिघ्घो आथै कि ओखर चुम्मा ले। ");
INSERT INTO bhu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","यीसु उनखर लग कथै, हे यहूदा का तै चुम्मा लइके मनसे कर टोरवा के पकडवामै चाहथस? ");
INSERT INTO bhu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ओखर संगी जब हइ देखथै, कि काहिन होय बाले हबै, ता कथै “हे परभु का हम तलबार चलइ?” ");
INSERT INTO bhu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","अउ उनखर मसे अक्ठी महायाजक के हरवाह, ओखर दहिना पल्ला के कान के काट देथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ई बात लग यीसु कथै, अब बस करा अउ ओखर कान के छुइ के निक्खा कर देथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ता यीसु परधान याजक अउ बिनती भवन के पंडित मंडली के सुरक्छा सिपाही अउ सियानन लग कथै, का तुम मोके चोरटा समझ के, तलबार अउ लठिया लइके आय हबा? ");
INSERT INTO bhu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","मै सबरोज बिनती भवन हे तुम्हर संग रहत रहों, ता तुम मसे मोर खिलाफ हाथ नेहको उठाया, इहैनिता ई टेम के तुमिन मालिक हबा अउ अंधियार के सक्ति तुम्हर हे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","फेरै उन मनसे यीसु के पकरके महायाजक के घर छो लइ जथै, पतरस दुरिहां लग ओखर पाछू-पाछू चलथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","अउ जब ऊ मनसे अंगना हे आगी जलाय के अकजुट बइठे रथै, ता पतरस उनखर बीच हे आयके बइठ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ता अक्ठी हरवाहिन पतरस के, आगी के उजेड हे बइठे हर देखके, ओखर तरफ अंगठियाय के कथै इहो तो यीसु के संग हे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","पतरस जल्दी कथै, हे डउकी मै तो ऊ मनसे के नेहको जानथो। ");
INSERT INTO bhu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","चुटु टेम के बाद हे अक्ठी दूसर मनसे उके देखथै अउ कथै, तै उन मसे अक्ठी हबस पय पतरस कथै, हे मनसे मै नेहको यहों। ");
INSERT INTO bhu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","करीबन अक घन्टा के बाद हे कउनो अउ मनसे कथै, “सहीमा हइ मनसे ओखर संग रथै, काखे कि ई गलीली मनसे हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","पतरस कथै, भाई मै नेहको जानथो, कि तै केखर बारे हे कथस, कि एतका टेम कुकडी बांस देथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","अउ परभु मुडके पतरस के पल्ला देखथै, ता पतरस परभु के ऊ बात के सुरता आथै जउन ऊ उके गुठे रथै, अभिनैन कुकडी बांसतै मोके तीसर बार मना करबे। ");
INSERT INTO bhu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","अउ पतरस भीड लग बाहिर छो निकडके, सिसक-सिसक के रोथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","जउन मनसे यीसु के पकडै रथै, ऊ मनसे ओखर मजाक अउ उके मारै पीटै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","अउ यीसु के आंखी हे पट्टी बांध के पूछथै, आगू कर बात गुठे कि तोके कोनहर मारे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ऊ मनसे ओखर बुराई करै के निता ओखर बिरोध हे कथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","जसना बिहन्ने होथै, ता सियान, मुखिया, परधान याजक अउ नियाव के गुरू मनसे मिलके आथै, अउ यीसु के दरबार छो लइ जथै अउ ओखर लग पूछथै। ");
INSERT INTO bhu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","हमके गुठे का तै मसीह हबस ऊ उनखर लग कथै, यदि मै तुम्हर लग गुठेइहों ता तुम मोर बात के बिस्वास नेहको करिहा। ");
INSERT INTO bhu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","अउ यदि मै सबाल करिहों, ता तुम जबाब नेहको दइ पइहा। ");
INSERT INTO bhu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","मनसे कर टोरवा कथै, अब लग मै सर्वसक्तिमान भगवान कर दहिना पल्ला बइठहुं। ");
INSERT INTO bhu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ई बात ले सगलू मनसे कथै, “का तै भगवान कर टोरवा हबस?” यीसु कथै, “तुम खुदय कथा, काखे मै हबो।” ");
INSERT INTO bhu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","उन कथै अब हमही कउनो मेर के गवाह के जरूरी नेहको हबै, काखे हम खुदय ऐखर मुंह लग बात सुन लय हबन। ");
INSERT INTO bhu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ता सगलू दरबार उठके यीसु के, पिलातुस राजा के लिघ्घो लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ऊ मनसे यीसु हे अरोप लगाथै अउ ऊ कथै हम इके हमर मनसेन के बहकाउत, हइ मनसे के पकरे हवन, हइ कैसर के बयाज चुकामै के बिरोध करथै अउ अपन खुद के मसीह अउ राजा गुठेबत सुने हवन। ");
INSERT INTO bhu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","पिलातुस राजा यीसु लग पूछथै, “का तै यहूदी कर राजा हबस?” ऊ उके जबाब देथै, “तहिन तो कथस, मै उहै हबो।” ");
INSERT INTO bhu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ता पिलातुस राजा प्रधान याजक अउ मनसेन के भीड लग कथै, मै हइ मनसे हे कउनो मेर के गलती नेहको पाथो। ");
INSERT INTO bhu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","उन हइ कहत निबेदन करथै, “हइ गलील परदेस लग लइके इहां तक यहूदा परदेस के कोना-कोना हे अपन सिक्छा लग मनसेन के भडकाउत रथै।” ");
INSERT INTO bhu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","पिलातुस राजा हइ बात सुनके पूछथै, का हइ मनसे गलीली सहर के रहैबाले हबै? ");
INSERT INTO bhu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","अउ हइ जानके कि ऊ गलील के सासक हेरोदेस राजा के इलाका के हबै, ता ऊ उके हेरोदेस राजा के लिघ्घो पठोय देथै, उहो उन रोज यरुसलेम सहर छो रथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हेरोदेस राजा यीसु के देखथै ता ऊ बोहत मगन होथै, काखे कि कइ रोज लग उके देखै चाहथै, काखे कि ऊ ओखर बारे हे सुने रथै अउ उके कउनो चिन्ह के काम करत देखै के आसा रखथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ऊ यीसु के बोहत केतका सबाल पूछथै, पय ऊ उके कउनो जबाब नेहको देथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","खास याजक अउ नियाव के गुरू मनसे उहै छो ठाड रथै, अउ ओखर उप्पर तन मन लग दोस लगाथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","हेरोदेस राजा अपन सिपाही समेत, ओखर संग गलत बेउहार करथै, अउ ओखर मजाक उडाथै, उके अक्ठी चमकीला खुरथा पइजामा पहिराथै, पिलातुस राजा के लिघ्घो फेरै पठोय देथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ऊ रोज हेरोदेस राजा अउ पिलातुस राजा अक दूसर के संगी बन जथै, एखर लग आगू उनखर हे बैर रथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पिलातुस राजा अउ प्रधान याजक, अउ सरदार के बुलाय के उनखर ले कथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","तुम इके मनसेन के भटकामै बाले, मनसे के जसना हे मोर लिघ्घो लाय हबा अउ देखा मै तुम्हर आगू एखर जांच करे हबो, पय जउन बातन के इलजाम लगाथा, ऊ बातन के बारे हे मै एखर जीवन हे कउनो गलती नेहको पाथो। ");
INSERT INTO bhu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","अउ देखिस कि हेरोदेस कुछ दोस नेहको पाथै, काखे कि ऊ इके फेरै हमर लिघ्घो पठोय दय हबै, जसना कि तुम देख सकथा, ई असना कुछु नेहको करै हबै, कि मारै के जबाबदारी होय। ");
INSERT INTO bhu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","इहैनिता इके मै पिटवाय के छांड देथो। ");
INSERT INTO bhu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","असना जरूरी रथै, कि तेउहार के टेम हे, ऊ कउनो अक्ठी अपराधी के बरी कर देही। ");
INSERT INTO bhu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","पय सगलू मनसे अक्कै संग मिलके चिरलाथै अउ कथै, ई मनसे के लइ जा, हमर निता बरअब्बा के छांड देया। ");
INSERT INTO bhu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","बरअब्बा के सहर हे मार धाड अउ मारे के जुरुम हे, जेल हे बेडे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पिलातुस यीसु के छोड देय चाहथै, इहैनिता ऊ मनसेन के समझाथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","पय ऊ मनसे चिरलाय के कथै, “उके क्रूस हे टंगाबा, इके क्रूस हे टंगाबा।” ");
INSERT INTO bhu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","पिलातुस तीसर बार पूछथै, काखे ऊ कउन गलती करे हबै, मोके एखर पल्ला कउनो मेर के बुराई नेहको मिलथै, इहैनिता मै इके कोडा लगवा के छांड देथो। ");
INSERT INTO bhu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","पय ऊ मनसे बोहत आरो करके चिरलाय के मांग करै लागथै, इके क्रूस हे टंगाबा अउ मनसेन के चिरलाना बोहत बढ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","पिलातुस राजा फइसला कर देथै, कि उनखर बिनती के जसनै करै चाही। ");
INSERT INTO bhu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ऊ मनसे के जउन बलवा अउ हत्या के कारन जेल हे बेडे गय रथै अउ जेही ऊ मांग करथै, छांड देथै अउ यीसु के उनखर बिचार के जसना सउप देथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","जब ऊ मनसे यीसु के लइ जात रथै, तब ऊ कुरेनी जिघा के रहै बाले समोन नाम के, अक्ठी मनसे के जउन अपन गांव लग आथै, ता उके पकड लेथै अउ ओखर उप्पर क्रूस के टांग के उके यीसु के पाछू रेंगै के मजबूर करथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","मनसेन के कडुक बड अक्ठी भीड यीसु के पाछू रेंगत रथै अउ एहमा कुछ डउकियो रथै, जउन ओखर निता रोउत रथै अउ दुखी होथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","यीसु उनखर पल्ला मुडथै, अउ कथै, यरुसलेम के टोरिया मोर निता झइ रोबा, बाकि खुदय अपन निता अउ अपन लरकन के निता रोबा। ");
INSERT INTO bhu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","काखे असना रोज आउथे जब मनसे गुठेही ऊ डउकी धन्य हबै, जउन बांझ हबै अउ धन्य हबै ऊ कोंखी जउन कउनो के पइदा नेहको देथै, अउ ऊ छाती धन्य हबै जउन कबहुं दूध नेहको पिलाथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","फेरै ऊ डोंगर लग कइहा, हमर हे गिर पड अउ डोंगर के इटिल्ली लग कइहा हमही ओढा ले। ");
INSERT INTO bhu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","काखे कि जब मनसे हरियर रूख के संग असना करथै, ता ऊ रूख जउन झुराय जही ता ओही कसना करही? ");
INSERT INTO bhu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","उन अन्य दुइठे मनसे जउन दोनो चोरटा रथै, यीसु के संग मरै के सजा निता लइ जात रथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","जब ऊ मनसे ऊ जिघा हे पहुंचथै, जेही मुन्डी के जिघा कथै, ता ऊ उन दोनो चोरटा के संग यीसु के क्रूस हे टंगाय देथै, अक्ठी चोरटा के ओखर दहिना पल्ला अउ दूसर चोरटा के टेटरा पल्ला। ");
INSERT INTO bhu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ता यीसु कथै, हे बाफ इनके छमा करबे, काखे हइ मनसे नेहको जानथै, कि ई काहिन करथै, फेर ऊ चिट्ठी डालके ओखर बन्डी अपने हे बांट लेथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","उहां ठाड हुइके सगलू मनसे देखथै अउ यहूदी नेता सरदार यीसु के मजाक करत कथै, हइ दूसर के बचाइस, यदि हइ भगवान कर चुने हर मसीह हबै, ता एही अपन खुदय मदद करै देया। ");
INSERT INTO bhu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","अउ सिपाही ओखर लिघा आयके मजाक करथै अउ ऊ उके सिरका पिय के देथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","अउ कथै, यदि तै यहूदी के राजा हबस ता अपन खुद के बचाय ले। ");
INSERT INTO bhu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","अउ ओखर उप्पर ई बात के इलजाम चिट्ठी लगाय देथै, “हइ यहूदी के राजा हबै।” ");
INSERT INTO bhu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","उहां टंगाय गय चोरटा मसे अक्ठी यीसु के बुराई करथै अउ कथै, का तै मसीह नेहको हबस? ता हमके अउ अपन खुदय के बचा ले। ");
INSERT INTO bhu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","पय दूसर चोरटा उके गधार के कथै, का तै भगवान लग नेहको डरथस? तहु के उहै सजा मिलथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","पय हमके दन्ड न्याय पूर मिले हबै, काखे कि हम जउन कुछु गलती करे हमन ओखर सजा मिलै हबै, पय ई मनसे कुछु बुरा काम नेहको करे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ता ऊ कथै, हे यीसु जब तै अपन राज हे आबे, ता मोके सुरता रखबे। ");
INSERT INTO bhu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","यीसु कथै, मै तोर लग सही कथो, आजय तै मोर संग स्वरग लोक हे होबे। ");
INSERT INTO bhu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","लगभग दुपहरी लग लइके, तीसर टेम तक सगलू देस हे अंधियार छाय जथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","बेरो नेहको चमकथै, उछो मन्दिर के परदा चिथर के दुइ खन्डा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","अउ यीसु बोहत आरो लग चिरलायके कथै, “हे बाफ मै अपन आतमा तोर हाथ हे साउपथों।” अउ ई बात कहि के ओखर परान निकड जथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","जब रोमी सिपाही जउन कुछ घटना घटे रथै, उके देखथै, ता भगवान कर बडाई करथै अउ कथै जरूर हइ मनसे धरमी रहिस। ");
INSERT INTO bhu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","उछो देखै के निता आय हर मनसेन के भीड अक जिघा रथै, उके देखथै ता ऊ रोबत लउट जथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","पय ऊ सगलू मनसे जउन यीसु के चीनथै, ऊ डउकी समेत जउन गलील सहर ले, ओखर संग आय रथै अउ उन दुरिहां ठाड हुइके ई सबझन देखत रथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","उहां यूसुफ नाम के अक्ठी मनसे रथै, जउन दरबार के अक्ठी सदस्य रथै अउ ऊ धरमी मनसे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","अउ ऊ उनखर बात अउ उनखर काम लग मगन नेहको होथै, अउ ऊ यहूदी के अरिमतियाह सहर के रहै बाले मनसे रथै अउ भगवान कर राज के ओरगत रथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","अउ पिलातुस राजा के लिघ्घो जाय के, यीसु के लोथ मांगथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ऊ लोथ के क्रूस लग तरी छो उतारथै अउ मलमल के पिछउरी हे उके लपेट देथै, फेर उके मरघटी हे जउन पथरा के कटे हर माडा हे मडाय देथै, जेहमा कबहुन कउनो मनसे के नेहको रखे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ऊ सुस्ताय कर रोज रथै अउ तेउहार कर रोज सुरू होय बाले रथै। ");
INSERT INTO bhu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","अउ ऊ डउकी जउन गलील सहर छो यीसु के संग आय रथै, जउन यीसु के पाछू हुइ जथै अउ ऊ जाय के मरघटी के देखथै कि ओखर लोथ कसना रखे हबै। ");
INSERT INTO bhu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","फेर ऊ लउट के महकनी चीज, अउ महकनी तेल तइयार करथै, अउ सुस्ताय कर रोज आदेस के जसना सुत्ताथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","पय हप्ता के आगू रोज सकरहा, उन डउकी मरघटी हे महकनी चीज के, जेही उन तइयार करे रथै लइ के मरघटी के लिघ्घो आथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","अउ उके मरघटी हे जउन, पथरा के बने हर माडा के दूरा के पथरा टरकाय हर मिलथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","उन मरघटी के माडा हे भित्तर जाय के देखथै, पय परभु यीसु के लोथ नेहको पाथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","जब उन ई बात लग चिन्ता हे रथै, कि उनखर लिघ्घो चकमकात चरका खुरथा पइजामा पहिरे हर दुइठे मनसे, आयके ठाड हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","डर के मारे उन भुंइ छो अपन मुंह झुकाय रथै, ऊ दुइठे मनसे उनखर लग कथै, जउन जिन्दा हबै उके तुम मरे हर हे काखे खोजथा? ");
INSERT INTO bhu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ऊ इछो नेहको हबै, पय ऊ जिन्दा हुइ गय हबै, सुरता करा कि ऊ गलील सहर छो रहत, तुम्हर लग कहे रथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ऊ कथै कि जरूरी हबै, कि मनसे कर टोरवा पापिन मनसे के हाथ हे पकडोय जही अउ क्रूस हे टंगाय जही अउ तीसर रोज जिन्दा हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ता डउकी के ओखर बात सुरता आथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","अउ डउकी मरघटी लग लउटके आथै, अउ ई सगलू बात ग्यारहठे चेलन अउ दूसर मनसेन के सगलू बात गुठेथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","जउन चेला लग हइ बात कथै, उन मरियम मगदलीनी अउ यूहन्ना अउ याकूब के दाय मरियम अउ उनखर संग दूसर डउकियो रथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","पय उनखर बात चेलन के फालतू लगथै, इहैनिता उनखर हे बिस्वास नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ता पतरस ठाड होथै अउ दउरत मरघटी के लिघ्घो पहुंचथै, ऊ झुक के देखथै, कि उके पिछउरी के सिबाय कुछु नेहको दिखथै, फेर अपन मन हे जउन कुछ होय रथै, ऊ चकित हुइके घर छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","उहै रोज उनखर मसे दुइठे चेला हइ सगलू घटना हे बात करत यरुसलेम सहर लग कउनो, दस कोस दुरिहां बसे इम्माऊस नाम के गांव छो जथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","जउन घटना घटे रहिस, सगलू बातन के उन मनसे अपन हे बात चीत गुठेबत जात रथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","जब हइ बातन के चरचा अउ सोच बिचार करथै, ता खुदय यीसु उहां आय के अउ उनखर संग हुइ लेथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","पय चेलन के आंखी बन्द कर देथै, कि उके नेहको पहचान सकथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","यीसु उनखर लग कथै, तुम गली हे रेंगत अक दूसर लग केखर बारे हे चरचा करथा? अउ उन निरास ठाडे रही गइन। ");
INSERT INTO bhu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ई बात सुनके उन मसे क्लियुपास नाम के अक्ठी मनसे रथै, ऊ कथै का तै यरुसलेम हे अकेल्ले परदेसी हबस, जउन हइ नेहको जानथस कि उहां हइ रोज काहिन होय हबै? ");
INSERT INTO bhu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","यीसु उनखर लग कथै, का हुइस? उन जबाब देथै, बात यीसु नासरी के हबै, ऊ भगवान अउ सगलू मनसे के नजर हे काम अउ बचन के सक्तिसाली नबी रहिस। ");
INSERT INTO bhu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","अउ हम ओखर बारे हे बात गुठेबत रहन कि हमर मुखिया याजक, अउ सासक उके पकडवा दइन अउ ऊ उके क्रूस हे टांग दइन ");
INSERT INTO bhu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","हम आसा करथन कि उहै इस्राएल के मुकति करी, हइ सगलू बात के अलाबा हइ आज तीसर रोज आगू के घटना हबै। ");
INSERT INTO bhu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","अउ हमर मसे कइठे डउकी हमके आस्चर्य हे डाल दय हबै, उन बडे सकरहा मरघटी हे गइन। ");
INSERT INTO bhu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","पय उनके ओखर देह नेहको मिलथै अउ डउकी लउट के कथै, कि हमके स्वरगदूत दिखाई दइस, जउन हइ गुठेथै कि यीसु जिन्दा हबै। ");
INSERT INTO bhu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","फेर हम मसे कुछ संगी मरघटी हे जथै, जसना कि डउकियो कहे रथै अउ उन ओसनेन पाथै, पय उन यीसु के नेहको देखिन। ");
INSERT INTO bhu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ता यीसु उनखर लग कथै, तुम केतका निरबुध्दि ग्यानी मनसे जउन कुछ गुठे हबै, तुम ओखर हे बिस्वास करै हे केतका मंद हबा। ");
INSERT INTO bhu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","काखे मसीह के निता हइ जरूरी नेहको रहिस, कि ऊ दुख उठा के अपन महिमा हे परबेस करी? ");
INSERT INTO bhu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ता ऊ मूसा ले अउ सगलू ग्यानी मनसेन लग सुरुवात करके सगलू पवितर किताब मसे अपन बारे हे लिखररे बातन के मतलब उनही समझा दिहिस। ");
INSERT INTO bhu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","जब ऊ उस गांव कर लिघ्घो पहुंच गइन जिहां उन जात रथै, यीसु असना दिखाइस कि ऊ आगू जायके चाहथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","पय चेला हइ कहिके उनखर लग बिनती करिन हमर संग रही जा साम होथै, अउ अब दिन बुड चुके हबै, ऊ उनखर संग ठहरै के निता भित्तर गइस। ");
INSERT INTO bhu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","जब यीसु उनखर संग भोजन करै मेज लग बइठथै, ता ऊ रोटी लेथै अउ आसीस मांगिस अउ टोर के चेलन के देय लगथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ता चेलन के आंखी उघर गइस अउ उन यीसु के चीन लेथै, पय उनखर आंखी लग लुक जथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ता चेला अक दूसर लग कथै, जब ऊ गली हे हमर लग बात करथै अउ पवितर किताब के मतलब हमके समझाउत रथै, ता का हमर मन हे उत्तेजना पइदा नेहको हुइस। ");
INSERT INTO bhu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ऊ उहै टेम उठके यरुसलेम सहर के वापिस लउट जथै, उहां ऊ ग्यारहठे चेला अउ उनखर संगिन के अक जिघा पाथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","जउन बात ऊ गुठे रथै, परभु सही हे जिन्दा होय हबै अउ समोन के दिखाई दइस। ");
INSERT INTO bhu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","तब दुनो चेला गुठेथै कि गली हे काहिन-काहिन हुइस, अउ उन यीसु के रोटी टोरत टेम कसना चीनही। ");
INSERT INTO bhu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","उन हइ सगलू घटना हे बात चीत करथै, कि यीसु उनखर बीच आयके ठाड हुइ गइस ऊ उनखर लग कथै, “तुमके सान्ति मिलै।” ");
INSERT INTO bhu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","पय उन मनसे घबरा गइन अउ डेराय जथै अउ ऊ मनसे समझथै, कि हम कउनो भुतवा के देखथन। ");
INSERT INTO bhu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","यीसु उनखर लग कथै, तुम मनसे काखे घबराथा? अउ तुम्हर मन हे संका काखे होथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","मोर हाथ अउ मोर गोड के देखा, कि मै उहै हबो अउ मोके छीके देखा, काखे कि आतमा के हाडा अउ मांस नेहको होथै, जसना तुम मोर हे देखथा। ");
INSERT INTO bhu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","हइ बात गुठेके यीसु उनही अपन हाथ अउ गोड दिखाथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","जब चेलन के खुसी के मारे बिस्वास नेहको करथै अउ उन चकित हे रथै, तब यीसु कथै, “का इहां तुम्हर लिघ्घो खाय के कुछु हबै?” ");
INSERT INTO bhu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","उन यीसु के भुंजररे हर मछडी के अक्ठी खन्डा देथै। ");
INSERT INTO bhu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ऊ उके लइस अउ उनखर आगू खाइस। ");
INSERT INTO bhu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","यीसु चेलन लग कथै, मै तुम्हर संग रहत टेम तुम मनसेन लग कहे रथो, कि जउन कुछु मूसा कर नियम हे अउ ग्यानी मनसेन के किताब हे अउ भजन संहिता हे मोर बारे हे लिखे हबै, सगलू पूर होय के जरूरी हबै। ");
INSERT INTO bhu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","तब यीसु चेलन के दिमाक खोल देथै, कि उन पवितर किताब के समझ सकै। ");
INSERT INTO bhu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","अउ उनखर लग कथै, “नियम के किताब हे असना लिखवरे हबै, कि मसीह दुख भोगी अउ तीसर रोज मिरतू मसे जिन्दा हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","अउ ओखर नाम हे यरुसलेम लग लइके सगलू देस के पाप छमा के निता मन बदलै के परचार करे जही। ");
INSERT INTO bhu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","तुम हइ बातन के गवाह हबा। ");
INSERT INTO bhu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","देखा मोर बाफ जउन बरदान के टीमा करे हबै, उके मै तुम्हर हे पठोहूं, इहैनिता जब तक तुम उप्पर के बल लग भरपूर नेहको हुइ जइहा तुम सहर हे रुके रहबे।” ");
INSERT INTO bhu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","एखर बाद यीसु चेलन के बैतनिय्याह गांव तक लइ गइस अउ ऊ अपन हाथ उठायके उनही आसीस दइस। ");
INSERT INTO bhu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","आसीस देयत-देयत ऊ उनखर लग अलगे हुइ गइस अउ स्वरग छो उठाय लइ गइस। ");
INSERT INTO bhu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","चेला ओखर परनाम करके बडी खुसी कर संग यरुसलेम लउट आइन। ");
INSERT INTO bhu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","अउ उन लगातार बिनती भवन हे उपस्थिति हुइके भगवान कर महिमा करत ऊ अपन टेम बितामै लगथै।");
INSERT INTO bhu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","सुरू हे बचन रथै अउ बचन भगवान के संग रथै अउ बचन भगवान रथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","इहै सुरू हे भगवान कर संग रथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","सगलू कुछु ओखर दवारा पइदा हुइस अउ जउन कुछु पइदा होय हबै, उन मसे कउनो चीज ओखर बिना पइदा नेहको होय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","उहै हे जीवन रथै अउ ऊ जीवन मनसेन के निता परकास रथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ऊ उजियार अंधियार हे चमकथै अउ अंधियार उके नेहको दबाय सकिस। ");
INSERT INTO bhu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","भगवान अक्ठी मनसे के पठोथै, जेखर नाम यूहन्ना रथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","यूहन्ना गवाही दे के निता आथै, कि ऊ उजियार के बारे हे गवाही दे, जेखर लग सगलू मनसे ओखर दवारा बिस्वास करै। ");
INSERT INTO bhu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ऊ खुदय उजियार नेहको रथै, पय यूहन्ना उजियार के गवाही दय के निता आथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","सही उजियार जउन हर अक्ठी मनसे के उजियार कर देथै, दुनिया हे आमै बाले रथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","सब्द दुनिया हे रथै अउ दुनिया ओखर दवारा पइदा होथै अउ दुनिया ओही नेहको चीनथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ऊ अपनन के लिघ्घो आथै अउ ओखर अपनेन मनसे उके गरहन नेहको करिन। ");
INSERT INTO bhu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","पय जेतका मनसे उके अपनाथै अउ ओखर नाम हे बिस्वास करथै, उन सगलू के भगवान के संतान बनै के हक देथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ऊ न खून लग, न देह के इक्छा लग, न मनसे के इक्छा लग, पय भगवान लग पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","अउ बचन देह धारन करके हमर बीच हे आइस, हम ओखर असना महिमा देखन जसना बाफ के अकठिन टोरवा के महिमा, जउन अनुगरह अउ सही लग भरपूर हुइके हमर बीच रहिस। ");
INSERT INTO bhu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","यूहन्ना ओखर बारे हे गवाही देथै अउ पुकार के कथै, “हइ उहै हबै, जउन मोर बाद आथै, ऊ मोर लग बढके हबै, काखे ऊ मोर लग पहिले रथै।” ");
INSERT INTO bhu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ओखर भरपूरी लग हम सगलू के उप्पर अनुगरह के उप्पर अनुगरह मिलथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","इहैनिता नियम मूसा कर दवारा दय गय हबै, पय अनुगरह अउ सही यीसु मसीह के दवारा आय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","भगवान के कउनो मनसे कबहुन नेहको देखे हबै, सिबाय, अक्ठी टोरवा, जउन बाफ लग हबै, उहै हमके भगवान लग मिलाय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यूहन्ना के गवाही हइ हबै, कि जब यहूदी मनसे यरुसलेम सहर छो पुजारिन अउ लेवियों के उनखर लग हइ पूछै के निता पठोथै, “कि तै कोन हबस?” ");
INSERT INTO bhu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ता यूहन्ना गवाही देथै, अउ बिना झिझके बोलथै, “कि मै मसीह नेहको हबो।” ");
INSERT INTO bhu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","तब उन यूहन्ना लग पूछथै, “ता फेर तै कउन हबस?” “का तै एलिय्याह हबस?” ऊ कथै, “मै एलिय्याह नेहको हबो।” का तै ग्यानी मनसे हबस? ऊ जबाब देथै, “नेहको।” ");
INSERT INTO bhu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","तब उन फेरै पूछथै, “ता तै कोन हबस? ताकि हम अपन पठोय बाले के जबाब दइ। तै अपन बारे हे काहिन कथस?” ");
INSERT INTO bhu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","यूहन्ना कथै, “जसना यसायाह ग्यानी मनसे कथै,” मै पतेरा छो अक्ठी पुकारे बाले के आरो आंव, “परभु के रास्ता सिध्धा करा।” ");
INSERT INTO bhu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","हइ मनसे के फरीसी मनसेन पठोय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","उन यूहन्ना लग हइ सबाल पूछथै, “अगर तै मसीह नेहको हबस अउ एलिय्याह नेहको अउ कउनो ग्यानी मनसे नेहको, ता फेर बतिस्मा काखे देथस?” ");
INSERT INTO bhu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","यूहन्ना उनही जबाब देथै, “मै पानी लग बतिस्मा देथो, पय तुम्हर बीच हे अक्ठी मनसे ठाढ हबै, जेही तुम नेहको जानथा। ");
INSERT INTO bhu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ऊ मोर बाद हे आमै बाले हबै, जेखर बूट के डोरा के मै छोरै के काबिल नेहको हबो।” ");
INSERT INTO bhu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","हइ बात यरदन नदिया के पार बैतनिय्याह गांव हे होथै, जछो यूहन्ना बतिस्मा देथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","दूसर रोज यूहन्ना यीसु के अपन पल्ला अउत देखके कथै, “देख हइ भगवान कर गेडरा हबै, जउन दुनिया भर के पाप के उठाय लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","हइ उहै हबै, जेखर बारे हे मै कहै रहों, कि अक्ठी मनसे मोर बाद आथै, जउन मोर लग बड्डे हबै, काखे ऊ मोर पइदा लग पहिलेन रथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","मै उके नेहको चीनथो, पय इहैनिता पानी लग बतिस्मा देमै आय हबो, ताकि ऊ इस्राएल देस हे परगट हुइ जाय।” ");
INSERT INTO bhu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","यूहन्ना हइ गवाही देथै, “मै आतमा के परेवा के सकल हे बादर लग उतरत देखथो अउ ऊ यीसु के उप्पर बइठ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","मै उके नेहको जानत रहों, पय जउन मोके पानी लग बतिस्मा देमै के पठोय रथै, ऊ मोर लग कहै रथै, जेखर उप्पर तै पवितर आतमा के उतरत अउ बइठत देखबे, उहै पवितर आतमा लग बतिस्मा दे बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","अउ मै देखे हबो अउ गवाही देथो, कि इहै भगवान कर टोरवा हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","दूसर रोज फेरै यूहन्ना अपन दुइठे चेला के संग ठाड रथै, ");
INSERT INTO bhu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","जब यूहन्ना यीसु के अपन लिघ्घो आउत देखथै, ता कथै, “देख हइ भगवान कर गेडरा हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","तब ऊ दोनोठे चेला ओखर हइ बात सुनके यीसु के पाछू हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","यीसु उनही अपन पाछू अउत देखथै, उनखर लग कथै, “तुम काहिन खोजथा?” उन ओखर लग कथै, “हे गुरू जी, तै कछो रथस?” ");
INSERT INTO bhu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","यीसु उनखर लग कथै, चलके खुदय देख ला, तब चेला ओखर रहै के जिघा देखथै अउ ऊ रोज ओखर संग रथै, असना रोज के दसमा घंटा के करीब रथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","जउन चेला यूहन्ना के बात के सुनके ओखर पाछू आ जथै, अक्ठी समोन पतरस रथै अउ पतरस के भाई अन्द्रियास रथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","अन्द्रियास पहिले अपन सगा भाई समोन लग मिलके कथै, “हमही मसीह मिल गय हबै जेखर मतलब हबै, अभिसेक करे हर हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","फेर अन्द्रियास अपन भाई समोन के यीसु के लिघ्घो लानथै, यीसु ओही देखके कथै, तै यूहन्ना कर टोरवा समोन हवस, तै अब लग कैफा जेखर मतलब, पतरस कहाबे। ");
INSERT INTO bhu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","दूसर रोज यीसु गलील परदेस छो जाय चाहथै, उछो ओखर भेंट फिलिप्पुस लग होथै, यीसु ओखर लग कथै, “मोर पाछू आबा।” ");
INSERT INTO bhu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","फिलिप्पुस, अन्द्रियास अउ पतरस बैतसदा सहर के निबासी रथै। ");
INSERT INTO bhu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","फिलिप्पुस नतनएल लग मिलके ओखर लग कथै, “जेखर बात मूसा किताब हे अउ ग्यानी मनसे लिखे हबै, ऊ हमही मिल गय हबै, ऊ नासरत के रहै बाले यूसुफ के टोरवा यीसु नासरी हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नतनएल ओखर लग कथै, “का कउनो निक्खा चीज नासरत लग निकर सकथै?” फिलिप्पुस ओखर लग कथै, “चलके देख लेया।” ");
INSERT INTO bhu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","यीसु नतनएल के अपन पल्ला अउत देखके ओखर बारे हे कथै, “देख, हइ अक्ठी सही इस्राएली हबै एखर भित्तर कउनो कपट नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नतनएल यीसु लग कथै, “तै मोके कसना जानथस?” यीसु ओही जबाब देथै, “फिलिप्पुस तोके बुलाय लग पहिलेन, जब तै अंजीर के रूख के तरी रहस तब मै तोके देखे रहों।” ");
INSERT INTO bhu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","नतनएल ओही जबाब देथै, “हे गुरू तै भगवान कर टोरवा हबस, तै इस्राएल के राजा हबस।” ");
INSERT INTO bhu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","यीसु ओही जबाब देथै, “मै जउन तोर लग कथो, कि मै तोके अंजीर के रूख तरी देखे रहों, का तै इहैनिता बिस्वास करथस? तै एखर लग बड्डे-बड्डे काम देखबे।” ");
INSERT INTO bhu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","फेरै ओखर लग कथै, “मै तुम्हर लग सही-सही कथो, तै स्वरग के उघरत अउ भगवान कर स्वरगदूतन के मनसे कर टोरवा के उप्पर उतरत अउ उप्पर जात देखिहा।” ");
INSERT INTO bhu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","तीसर रोज गलील सहर के काना हे कउनो के काज रथै अउ उहां यीसु के दाय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","जेखर घर हे काज रथै, उन यीसु अउ ओखर चेलन के बुलाय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","उहां जब अंगूर कर रस बढाय जथै, तब यीसु के दाय कथै, “उनखर लिघ्घो अंगूर कर रस नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","यीसु ओखर लग कथै, “हे डउकी मोर लग काखे कथस, मोके तोर लग काहिन काम? अबे मोर टेम नेहको आय हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","फेर ओखर दाय ओखर सेबकन लग कथै, जउन कुछु ऊ तुम्हर लग कहि उहै करिहा। ");
INSERT INTO bhu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","उहां सुध्द करन के निता पानी भर के पथरा के छय गघरी रखथै, हइ गघरी ओसनेन रथै जसना यहूदी पवितर असनादै के निता काम हे लाथै, हर अक्ठी गघरी हे कउनो अस्सी लग अक सव बीस लीटर पानी समाथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","यीसु उनखर लग कथै, गघरी हे पानी भर देया तब उन गघरी हे पानी फुल्य भर देथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","तब ऊ उनखर लग कथै, अब निकाडके दावत के परधान के लिघ्घो लइ जा। अउ उन ओसनेन करथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","जब दावत के परधान ऊ पानी के पीथै, जउन अंगूर के रस्सा बन जथै अउ उनके पता नेहको चलथै, कि दाखरस कछो लग आय हबै, पय जउन सेबक पानी के निकाडथै ऊ जानथै, ता ऊ परधान दुलहा के बुलवाइस, ");
INSERT INTO bhu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","अउ ओखर लग कथै, हर अक्ठी मनसे पहिले निक्खा अंगूर कर रस देथै अउ जब मनसे पी के टुल्य हुइ जथै, तब फेर घटिया देथै, पय तुम निक्खा अंगूर के रस बचाय के रखे हबस। ");
INSERT INTO bhu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","यीसु गलील सहर के काना गांव हे अपन हइ पहिले चकित कर काम दिखाथै अउ अपन महिमा के परगट करथै अउ ओखर चेला यीसु हे बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","एखर बाद ऊ ओखर दाय अउ ओखर भाई अउ ओखर चेला कफरनहूम सहर छो कढ जथै अउ उछो कुछ रोज रथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहूदी के फसह के तेउहार लिघ्घो रथै अउ यीसु यरुसलेम छो गइस। ");
INSERT INTO bhu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","तब यीसु मन्दिर के भित्तर बइला, गेडरा अउ परेवा बेचै बाले अउ पइसा बदलै बाले बनियन के बइठे हर पाथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","तब यीसु डोरा लग कोडा बनाय के सगलू गेडरा अउ बइलन के बिनती भवन लग निकाड देथै, यीसु बनियन के सिक्का के फटक देथै अउ टेबुलन के पलट देथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","यीसु परेवा बेचै बाले लग कथै, हइ सगलू इछो लग लइजा, मोर बाफ के घर के बजार झइ बनाबा। ");
INSERT INTO bhu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","तब ओखर चेलन के सुरता आथै, कि किताब हे लिखवरे हबै, “तुम्हर घर के धुन मोर भक्ति आगी के मेर जलत हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","हइ बात यहूदी यीसु लग कथै, “तै हमके असना चकित चिन्हा दिखाबे? जेखर लग हम हइ जान सकि कि तै असना करै के हक हबै अउ हइ साबित हुइ सकै?” ");
INSERT INTO bhu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","यीसु उनके जबाब देथै, हइ मन्दिर के गिरा देया, मै उके तीन रोज हे ठाढ कर दइहों। ");
INSERT INTO bhu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","यहूदी कथै, हइ मन्दिर के बनामै हे छियालीस साल लगे हबै अउ तै कथस तीन रोज हे ठाढ कर दइहों? ");
INSERT INTO bhu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","पय यीसु अपन देह के मन्दिर के बारे हे कथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","इहैनिता जब ऊ मरे मसे जी उठथै, तब ओखर चेलन के सुरता आथै, कि यीसु कहे रथै अउ उन पवितर किताब अउ ऊ बचन हे जउन यीसु कहै रथै, बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","जब यीसु यरुसलेम हे फसह के टेम तेउहार हे रथै, ता बोहत मनसेन ओखर चिन्हा के जउन ऊ दिखाथै, देखके ओखर नाम हे बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","पय यीसु उन मनसेन के उप्पर बिस्वास नेहको करथै, काखे ऊ सबके मन के बात के जानथै। ");
INSERT INTO bhu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","अउ यीसु के जरूरी नेहको रथै, कि मनसे के बारे हे कउ गवाही दे, काखे ऊ खुदय जानथै, कि मनसे के मन हे का हबै? ");
INSERT INTO bhu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","फरीसी मसे नीकुदेमुस नाम के अक्ठी मनसे रथै, ऊ यहूदी के सरदार रथै। ");
INSERT INTO bhu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","नीकुदेमुस रात के टेम हे यीसु के लिघ्घो आयके कथै, “हे गुरू, हम जानथन कि तै, भगवान के पल्ला लग आय हबस, काखे जउन चिन्हा के तै दिखाथस, भगवान के मदद के बिना कउनो नेहको कर सकथै।” ");
INSERT INTO bhu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","यीसु उके जबाब देथै, “मै तोर लग सही-सही कथो, जब तक कउनो नवा जनम नेहको हुइ, तब तक ऊ भगवान कर राज के नेहको देख सकथै।” ");
INSERT INTO bhu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","नीकुदेमुस ओखर लग पूछथै, “मनसे डोकरा हुइ जही, ता कसना फेरै लग पइदा हुइ सकथै? का ऊ अपन दाय के लादा हे दुबारा जायके पइदा लइ सकथै?” ");
INSERT INTO bhu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","यीसु जबाब देथै, “मै तोर लग सही-सही कथो, जब तक कउनो मनसे पानी अउ आतमा लग नेहको पइदा होही, तब तक ऊ भगवान कर राज हे परवेस नेहको कर सकथै। ");
INSERT INTO bhu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","काखे जउन देह लग पइदा होय हबै, ऊ देह हबै अउ जउन आतमा लग पइदा होय हबै, ऊ आतमा हबै। ");
INSERT INTO bhu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","मै तुम्हर लग जउन कहे हव, ओखर उप्पर झइ चकरा, तुमही नबा मेर लग पइदा होय के जरूरी हबै। ");
INSERT INTO bhu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","हवा जउन चाहथै, उछो चलथै अउ तुम ओखर आरो के सुनथा, पय नेहको जानथा, कि ऊ कछो लग आथै अउ कछो जथै, जउन कउ आतमा लग पइदा होय हबै, ऊ ओसनेन हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","नीकुदेमुस ओही जबाब देथै, हइ कसना हुइ सकथै? ");
INSERT INTO bhu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","हइ बात सुनके यीसु ओखर लग कथै, तै इस्राएलिन के गुरू हुइके हइ बात के नेहको समझथस? ");
INSERT INTO bhu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","मै तोर लग सही कथो, कि हम जउन जानथन, उहै कथन अउ जेही हम देखे हबन, हम ओखर गवाह देथन, पय तुम हमर गवाही नेहको स्वीकारथा। ");
INSERT INTO bhu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","जब मै तुमही भुंइ के बात कथो, ता तै बिस्वास नेहको करथस, अगर मै तुम्हर लग स्वरग के बात गुठेहूं, ता फेर कसना बिस्वास करिहा? ");
INSERT INTO bhu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","कउ मनसे स्वरग हे नेहको चढे हबै, सिबाय अक्ठी मतलब, मनसे कर टोरवा जउन स्वरग लग उतरे हबै। ");
INSERT INTO bhu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","जसना मेर मूसा पतेरा हे सपुवा के उप्पर उठाय रथै, ओसनेन मनसे कर टोरवा उप्पर उठाय जही। ");
INSERT INTO bhu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ताकि जउन कउ बिस्वास करी, ऊ सबरोज के जीवन पाही। ");
INSERT INTO bhu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“भगवान हइ दुनिया लग अइसन माया करिस, कि ऊ अपन अक्ठी टोरवा के दइ दइस, ताकि जउन कउ ओखर उप्पर बिस्वास करही, ऊ नेहको मरही, बलुक सबरोज के जीवन पाही। ");
INSERT INTO bhu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","भगवान अपन टोरवा के दुनिया हे इहैनिता नेहको पठोइस कि दुनिया हे सजा के आदेस दे, पय इहैनिता दुनिया ओखर दवारा मुकति पाबै।” ");
INSERT INTO bhu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","जउन मनसे ओखर उप्पर बिस्वास करही, ऊ दोसी नेहको ठहराय जही, जउन बिस्वास नेहको करथै, ऊ दोसी ठहर चुके हबै, काखे ऊ भगवान कर अक्ठी टोरवा के नाम हे बिस्वास नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","अउ सजा के आदेस के कारन हइ हबै कि उजियार दुनिया हे आइस अउ मनसे उजियार के छांडके अंधियार के जादा पसंद करिन, काखे उनखर काम बेकार रथै। ");
INSERT INTO bhu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","जउन मनसे बुराई करथै, ऊ उजियार लग चिढथै, अउ उजियार के लिघ्घो नेहको आथै, कि असना झइ होय कि ओखर काम परगट हुइ जाय। ");
INSERT INTO bhu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","जउन मनसे सही हे चलथै, ऊ उजियार के लिघ्घो आथै, ताकि ओखर नाम परगट हो, कि ऊ भगवान के पल्ला लग करे गय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","एखर बाद यीसु अउ ओखर चेला यहूदिया देस हे आथै अउ यीसु उहां चेलन के संग रही के बतिस्मा दे लागथै। ");
INSERT INTO bhu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","यूहन्ना सालोम सहर के लिघ्घो ऐनोन हे बतिस्मा दय करथै, काखे उहां बोहत पानी रथै अउ मनसे आयके बतिस्मा ले करथै। ");
INSERT INTO bhu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","यूहन्ना ऊ टेम हे, जेल हे नेहको धंधे रथै। ");
INSERT INTO bhu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","उहां यूहन्ना के चेला कउनो यहूदी धरम गुरू के संग सुध्दिकरन के बारे हे झगडा हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","अउ उन यूहन्ना के लिघ्घो जायके ओखर लग कथै, हे गुरू, जउन यरदन नदिया के ऊ पल्ला तोर संग रथै अउ जेखर बारे हे तै गवाही दय रहस, ऊ पानी हे बतिस्मा देथै अउ सगलू मनसे ओखर लिघ्घो जाय लगिन। ");
INSERT INTO bhu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","यूहन्ना जबाब देथै, जब तक मनसे के स्वरग लग नेहको दय जही, तब तक ऊ कुछु नेहको पा सकथै। ");
INSERT INTO bhu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","तुम खुदय मोर गवाह हबा, कि मै कहे रथो, कि मै मसीह नेहको आंव, पय ओखर लग आगू पठोय गय हव। ");
INSERT INTO bhu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","जेखर दुलहिन हबै, उहै दुलहा हबै, पय दुलहा के संगी जउन ओखर लिघ्घो ठाढ हबै, ओखर बात सुनथै, दुलहा के सब्द लग बोहत खुस होथै, अब मोर हइ खुसी पूर होथै। ");
INSERT INTO bhu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","जरूरी हबै, कि ओखर महिमा बढै जाय अउ मै घटत जाव। ");
INSERT INTO bhu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","जउन उप्पर लग आथै, ऊ बड्डे हबै, जउन भुंइ लग आथै, ऊ भुंइ के हबै, ऊ भुंइ के बात करथै, जउन स्वरग लग आथै, ऊ सब लग उप्पर हबै। ");
INSERT INTO bhu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","यूहन्ना जउन कुछु देखथै अउ सुनथै, ओखर गवाही देथै अउ ओखर गवाही के कउ नेहको स्वीकरथै। ");
INSERT INTO bhu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","जउन ओखर गवाही के मानथै, ऊ हइ बात हे छाप लागय दइस, कि भगवान सही हबै। ");
INSERT INTO bhu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","काखे जेही भगवान पठोय हबै, ऊ भगवान के बारे हे कथै, काखे भगवान के बात कथै, काखे ऊ नाप के पवितर आतमा नेहको देथै। ");
INSERT INTO bhu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","बाफ अपन टोरवा लग माया करथै अउ ऊ सगलू चीज ओखर हाथ हे दइ दय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","जउन टोरवा हे बिस्वास करथै, सबरोज के जीवन ओखरै हबै, पय जउन भगवान के बात के नेहको मानथै, उके जीवन नेहको मिलही, पय भगवान कर गुस्सा ओखे उप्पर बने रही। ");
INSERT INTO bhu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","जब यीसु के पता चलथै, कि फरीसी सुने हबै, कि यीसु यूहन्ना लग बोहत बतिस्मा देथै अउ उनही चेला बनाउत हबै। ");
INSERT INTO bhu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","पय यीसु खुदय नेहको, बलुक ओखर चेला बतिस्मा देथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","तब ऊ यहूदिया के छांडके फेरै गलील सहर छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","अउ यीसु के सामरिया परदेस हुइके जाय के जरूरी रथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","इहैनिता ऊ सामरिया परदेस के अक्ठी सूखार सहर हे आइस, हइ सहर ऊ जमीन के लिघ्घो रथै, जउन याकूब अपन टोरवा यूसुफ के दय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","अउ उहां याकूब के कुंवा रथै अउ यीसु यातरा लग रेंगत थक जथै अउ ऊ कुंवा के लिघ्घो बइठ जथै, ऊ टेम करीबन दुपहरी रथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","एतका हे अक्ठी सामरी डउकी पानी भरै आथै, यीसु ओखर लग कथै, “मोके पानी पिला।” ");
INSERT INTO bhu_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","काखे ओखर चेला सहर छो भोजन ले गय रहै। ");
INSERT INTO bhu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ऊ सामरी डउकी ओखर लग कथै, तै यहूदी हुइके मोर जसना सामरी डउकी लग काखे पानी मांगथस? काखे यहूदी सामरी मनसेन के संग कउनो मेर के सबंध नेहको रखथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","यीसु जबाब देथै, अगर तै भगवान के बरदान के जानथस अउ इहो जानथस कि ऊ कउन हबै जउन तोर लग कथै, “मोके पानी पिला, ता तै ओखर लग मांगबे अउ ऊ तोके जीवन के पानी देही।” ");
INSERT INTO bhu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","डउकी ओखर लग कथै, “हे परभु, तोर लिघ्घो पानी भरै के कुछु बरतन नेहको हबै अउ कुंवा गहिड हबै, ता फेर ऊ जीवन के पानी तोर लिघ्घो कछो लग आही? ");
INSERT INTO bhu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","जरूर तै हमर बाफ याकूब लग बडा हबस, जउन हमही हइ कुंवा दइस, अउ अपन टोरवा अउ अपन गोरू के संग खुदय कुंवा के पानी पी करथै।” ");
INSERT INTO bhu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","यीसु ओही जबाब देथै, “जउन कउ हइ पानी पीहीं, उके फेरै पियास लगही, ");
INSERT INTO bhu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","पय जउन कउ मोर दय हर पानी के पीहीं, उके पियास कबहुन नेहको लगही, जउन पानी उके मै देहुं, पानी ओहमा झरना बन जही, जउन जीवन भर के निता झिरही।” ");
INSERT INTO bhu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","सामरी डउकी ओखर लग कथै, “हे परभु ऊ पानी मोके दइ दे, ताकि मोके फेरै पियास झइ लगै अउ पानी भरै के एतका दुरिहां आमैके झइ पडै।” ");
INSERT INTO bhu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","यीसु ओखर लग कथै, जा, “अपन डउका के इहां बुला के ला।” ");
INSERT INTO bhu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","सामरी डउकी जबाब देथै, “मोर कउनो डउका नेहको हबै।” यीसु ओखर लग कथै, “तै बिलकुन ठीक कहे हबस, कि मोर कउनो डउका नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","काखे तै पांचठे डउका कर चुके हवस अउ जेखर लिघ्घो तै हबस, ऊ तोर डउका नेहको हबै, ई तै सही कहे हबस।” ");
INSERT INTO bhu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","डउकी ओखर लग कथै, “हे परभु, मोके लागथै, कि तै ग्यानी मनसे हबस। ");
INSERT INTO bhu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","हमर परदादा ई डोंगर छो भजन करथै अउ तै कथस, कि यरुसलेम महिमा के जिघा हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","यीसु ओखर लग कथै, “हे नारी, मोर बातन के बिस्वास कर कि ऊ टेम आय गय हबै, कि तै न तो हइ डोंगर छो बाफ के भजन करिहा अउ ना यरुसलेम छो। ");
INSERT INTO bhu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","तुम जेही नेहको जानथा, ओखर भजन करथा, पय हम यहूदी उके जानथन, जेखर भजन करथन, काखे मुकति यहूदी मसे हबै। ");
INSERT INTO bhu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","पय ऊ टेम आय गय हबै, जब सही मन लग भजन आतमा अउ सच्चाई लग करही, स्वरगी बाफ असना भजन करै बालेन के चाहथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","भगवान आतमा हबै अउ जरूरी हबै, कि ओखर भजन करै बाले आतमा सच्चाई लग करै।” ");
INSERT INTO bhu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","डउकी ओखर लग कथै, “मै जानथो, कि मसीह जउन अभिसिक्त कहाथै, ऊ आमै बाले हबै, जब ऊ आही ता हमही सगलू बात गुठेही।” ");
INSERT INTO bhu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","यीसु ओखर लग कथै, मै तोर लग बात करथो, मै उहै यहों। ");
INSERT INTO bhu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","एतका हे ओखर चेला आ जथै अउ चकराय जथै, कि यीसु सामरी डउकी लग बात करथै, तउभरमा कउनो नेहको पूछथै, “तोही काहिन चाही?” या “का निता ओखर लग बात करथस?” ");
INSERT INTO bhu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तब सामरी डउकी अपन गघरी के छांड के सहर छो जायके मनसेन लग कथै, ");
INSERT INTO bhu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“आबा अक्ठी मनसे के देखा, जउन सगलू कुछु मोके गुठे दय हबै, जउन मै काम करे रथो, कहुं इहै तो मसीह नेहको हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","इहैनिता उहां के रहे बाले मनसे सहर लग निकड के ओखर लिघ्घो आमै लागथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","इहै टेम ओखर चेला यीसु लग बिनती करथै, “हे गुरू कुछ खाय ले।” ");
INSERT INTO bhu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","पय यीसु उनखर लग कथै, मोर लिघ्घो खाय के निता असना खाना हबै, जेखर बारे हे तुम नेहको जानथा। ");
INSERT INTO bhu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","तब चेला अपन हे कथै, “का कउ ओखर निता कुछु खाय के लाय हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","यीसु चेलन लग कथै, मोर खाना इहै हबै कि अपन पठोमै बाले के इक्छा के जसना चलो अउ ओखर काम पूर कर सको। ");
INSERT INTO bhu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“का तुम नेहको कहत रहा, कि अब कटनी काटै के चार माह बचे हबै, पय मै तुम्हर लग कथो, देखा, अपन आंखी लग खेत के, ऊ काटै के निता पक चुके हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","काटै बाले मजदूरी पाथै अउ सबरोज के जीवन के निता फडुहा समेटथै, जेखर लग बोमै बाले अउ काटै बाले दोनो झन मिलके खुसी बनामै। ");
INSERT INTO bhu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","काखे इहां हइ किस्सा ठीक बइठथै, कि अक्ठी बोथै अउ दूसर काटथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","मै तुमही ऊ खेत काटै के निता पठोयों, जेहमा तुम मेहनत नेहको करा, पय दूसर मेहनत करिन अउ तुमही ओखर मेहनत के फडुहा मिलत हबै। ");
INSERT INTO bhu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ऊ सामरी डउकी हइ गवाही देथै, “ऊ मोके सगलू गुठेइस, जउन मै करे रथो।” हइ गवाही के कारन ऊ सहर के बोहत मनसेन यीसु के उप्पर बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","जब ऊ सामरी डउकी यीसु के लिघ्घो आथै अउ ओखर लग बिनती करै लागथै, हमर इछो रही ले, इहैनिता यीसु उहां दुइ रोज रथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","यीसु के बचन सुनके बोहत मनसे बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","अउ सामरी मनसे डउकी लग कथै, “अब हम तोर गुठे लग बिस्वास नेहको करथन, काखे खुदय सुने हबन अउ जानथन, कि इहै सही हे दुनिया के मुकतिदाता हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","दुइ रोज के बाद यीसु उहां लग निकड के गलील परदेस छो कढ जथै, ");
INSERT INTO bhu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","काखे यीसु खुदय हइ गवाही देथै, ग्यानी मनसे अपन देस हे इज्जत नेहको पाथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","जब ऊ गलील परदेस छो पहुंचथै, ता गलीली मनसेन खुसी के संग ओखर सोगत कथै, काखे जेतका काम यरुसलेम हे तेउहार के टेम करे रथै, ऊ सगलू मनसे देखे रथै, काखे उनो तेउहार हे रथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","तब फेर यीसु गलील परदेस के काना हे आथै, जिहां यीसु पानी के अंगूर कर रस बनाथै, ऊ परदेस के साहब रथै, जेखर टोरवा कफरनहूम हे नंगाय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","हइ सुनके कि यीसु यहूदिया लग गलील परदेस छो आय हबै, ऊ साहब ओखर लिघ्घो जथै अउ ओखर लग बिनती करै लागथै, कि चलके मोर टोरवा के निक्खा कर दे, काखे मोर टोरवा मरै बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","यीसु ओखर लग कथै, जब तक मनसे चिन्हा अउ चकित काम नेहको देखहा, तब तक कबहुन बिस्वास नेहको करिहा। ");
INSERT INTO bhu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","साहब ओखर लग कथै, “हे परभु मोर टोरवा के मरे लग अगुन्नै चल।” ");
INSERT INTO bhu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","यीसु ओखर लग कथै, “जा तोर टोरवा जिन्दा हबै।” ऊ मनसे यीसु के कहे हर बात हे बिस्वास करथै अउ अपन घर छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ऊ रास्ता हे रथै, कि ओखर हरवाह रास्ता हे मिलथै अउ गुठेथै, “कि तोर लरका जिन्दा हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","सेबक लग पूछथै, ऊ केतका टेम निक्खा हुइ गय रहिस? ऊ कथै कल दुपहरी करीबन अक बजे ओखर बुखार उतर गइस। ");
INSERT INTO bhu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","लरका के बाफ जान जथै, कि उहै टेम हुइस, जेतका टेम यीसु मोर लग कहे रहिस, कि तोर टोरवा जिन्दा हबै, तब ओखर सगलू घर परवार यीसु हे बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","हइ दूसर चकित बाले चिन्ह के काम रथै, जउन यीसु यहूदिया के गलील परदेस छो आयके करथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","कुछ रोज के बाद यीसु यहूदिन के तेउहार हे यरुसलेम छो जथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरुसलेम हे गेडरन के फाटक के लिघ्घो अक्ठी झिरिया हबै, इब्रानी भासा हे इके बैतसदा कहे जथै, एखर बगल हे पांचठे अंगना हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ओहमा बोहत नंगहा अन्धरा लेंगरा अउ लोकवा बाले मनसे पानी के डोले के आसरा हे पडे रथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","जउन मनसे पानी के डोलय के ओरगत रथै काखे उन मानथै कि भगवान कर स्वरगदूत झिरिया हे उतर के पानी के डोलय करथै, पानी डोलतै मन्तर जउन कउ आगुन कूदथै, ऊ निक्खा होय जथै, चाहे ओखर कउनो मेर के बिमार काहेका झइ होय। ");
INSERT INTO bhu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","उछो अक्ठी मनसे रथै, जउन अडतिस साल लग नंगाय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","जब यीसु उके उहां पडे हर देखथै अउ हइ जानके कि ऊ बोहत दिन लग हइ हालत हे पडे हबै, यीसु ओखर लग पूछथै, “का तै निक्खा होमै के चाहथस?” ");
INSERT INTO bhu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ऊ नंगहा मनसे ओखर लग कथै, “हे परभु, मोर लिघ्घो कउ मदद करै बाले नेहको हबै, कि जब पानी डोलत टेम मोके झिरिया के कुन्ड हे कउ उतारै, मोर पहुंचत भरमा दूसर कउ मोर लग आगुन कूद जथै।” ");
INSERT INTO bhu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","यीसु ओखर लग कथै, “उठ, अपन खटिया उठाय के कढ जा।” ");
INSERT INTO bhu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ऊ मनसे हरबी निक्खा हुइ जथै अउ अपन खटिया उठाय के चलै फिरै लग जथै, ऊ रोज सुस्ताय कर रोज रथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","इहैनिता यहूदी ओखर लग जउन निक्खा होय रहै पूछथै अउ कहे लागथै, आज सुस्ताय कर रोज हबै अउ हमर नियम के बिरोध हबै, कि तै अपन खटिया उठा। ");
INSERT INTO bhu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ऊ यहूदी के जबाब देथै, जउन मोके निक्खा करै हबै, उहै मोके कहिस, कि अपन खटिया उठाय के रेंग बाग। ");
INSERT INTO bhu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","यहूदी मनसे ओखर लग पूछथै, ऊ कोन मनसे हबै? जउन तोर लग कहिस कि खटिया उठाय के रेंग बाग? ");
INSERT INTO bhu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","जउन निक्खा हुइ गय रहै, ऊ नेहको जानथै, कि ऊ कोन हबै, काखे ऊ जिघा हे बोहत भीड होमै के कारन यीसु उहां लग कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ओखर बाद हे ऊ मनसे यीसु लग बिनती भवन हे मिलथै, तब यीसु ओखर लग कथै, देख, तै निक्खा हुइ गय हवस, फेरै पाप झइ करबे, असना झइ होय कि, एखर लग कउनो बडा नांगा तोर उप्पर आ जाय, ऊ मनसे उहां लग कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","अउ ऊ मनसे जाय के यहूदिन लग गुठे देथै, कि जउन मोके निक्खा करै हबै, ओखर नाम यीसु हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","हइ कारन यहूदी यीसु के परेसान करै लागथै, काखे ऊ अइसन काम सुस्ताय कर रोज करथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","यीसु उनखर लग कथै, मोर बाफ अबे तक काम करत हबै, इहैनिता महुं लगेतार काम करथो। ");
INSERT INTO bhu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","अब यहूदी अउ पुजारी ओही मार डालै के परयास करै लग जथै, काखे ऊ सुस्ताय कर रोज के नियम के तो तोडथै, बलुक भगवान के अपन बाफ कहिके खुद के भगवान के बरोबर गुठेथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","यीसु उनखर लग कथै, मै तुम्हर लग सही-सही कथो, टोरवा खुदय लग नेहको कर सकथै, ऊ केबल उहै कर सकथै जउन बाफ के करत देखथै, जसना बाफ करथै, ओसनेन टोरवो करथै, ");
INSERT INTO bhu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","काखे बाफ टोरवा लग माया करथै अउ जउन-जउन काम खुदय करथै, ऊ सगलू काम टोरवा के दिखाथै, ऊ उके अउ बडा काम दिखाही, जेही तुम देखके चकित हुइ जइहा। ");
INSERT INTO bhu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","काखे जसना बाफ मरे हर के जिन्दा करथै अउ उनही जीवन देथै, ओसनेन टोरवा जेही चाहथै, ओही जीवन देथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","बाफ कउनो के नियाव नेहको करथै, ऊ नियाव करै के पूर हक टोरवा के दइ दय हबै, ");
INSERT INTO bhu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","इहैनिता सगलू मनसे जसना बाफ के इज्जत करथै, ओसनेन टोरवा के इज्जत करै, जउन टोरवा के इज्जत नेहको करथै, ऊ बाफ के इज्जत नेहको करथै, जउन टोरवा के पठोय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","मै तुम्हर लग सही कथो, जउन मोर बचन सुनके मोर पठोय बाले भगवान के उप्पर बिस्वास करथै, सबरोज के जीवन ओखरेन हबै अउ ओखर हे सजा के आदेस नेहको होथै, पय ऊ मिरतू के पार करके जीवन हे घुस चुके हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","मै तुम्हर लग सही-सही कथो, ऊ टेम आ गय हबै, जब सगलू मर गय हबै, उन भगवान कर टोरवा के आरो सुनहिन अउ हर अकझन सुनै बाले जीवन पाय जइही, ");
INSERT INTO bhu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","काखे जउन मेर बाफ खुद हे जीवन धारन करे हर हबै, उहै मेर अपन टोरवो के खुद हे जीवन धारन करै के हक दय हबै, ");
INSERT INTO bhu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","अउ उके मनसे कर टोरवा होय के कारन नियाव करै के हक दय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","हइ बात हे झइ चकरावा काखे ऊ टेम आय गय हबै, कि जेतका मरघटी हे हबै, टोरवा के सब्द के सुनके जिन्दा हुइहिन। ");
INSERT INTO bhu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","जेतका मनसे निक्खा काम करे हबै, ऊ जीवन हे फेरै लग जिन्दा हुइहीं अउ जेतका मनसे बेकार काम करै हबै, ऊ सजा के निता जिन्दा हुइहिन। ");
INSERT INTO bhu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","मै खुद कुछु नेहको कर सकथों, मै बाफ लग जउन सुनथो उहै के आधार हे नियाव करथो अउ मोर नियाव जरूरी हबै काखे मै अपन इक्छा लग कुछु नेहको कर सकथों, बलुक ओखर इक्छा लग करथो, जउन मोके पठोय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","अगर मै खुदय अपन गवाही देथो, ता मोर गवाही सही नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","अक्ठी अउ हबै जउन मोर गवाही देथै अउ मै जानथो कि ऊ मोर बारे हे जउन गवाही देथै, ऊ सही हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","तुम यूहन्ना के लिघ्घो अपन मनसे के पठोय रहा अउ यूहन्ना सही गवाही दय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","हइ नेहको कि मोके कउनो मनसे के गवाह के जरूरत हबै, पय मै इहैनिता कथो कि तुम मुकति पाय सका। ");
INSERT INTO bhu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","यूहन्ना जलत अउ चमकत चिमनी रथै अउ तुमही चुटु टेम हे ओखर उजियार हे खुसी मनामै के निक्खा लागथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","पय मोर लिघ्घो जउन गवाही हबै, ऊ यूहन्ना के गवाही लग बडा हबै, काखे जउन काम बाफ मोके पूर करै के सउपे हबै, मतलब इहै काम जउन मै करथो, ऊ काम हइ बात के गवाह हबै, कि बाफ मोके पठोय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","बाफ जउन मोके पठोय हबै, ऊ मोर गवाही दय हबै, तुम ओखर सब्द के कबहुन नेहको सुने हबा अउ न ओखर रूप देखे हबा। ");
INSERT INTO bhu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","तुम ओखर बचन मन हे बनाय के नेहको रखथा, काखे जउन ऊ पठोय हबै, ओखर उप्पर बिस्वास नेहको करथा। ");
INSERT INTO bhu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","तुम पवितर किताब के पढथा, काखे तुम्हर सोच हबै कि तुमही उनखर दवारा सबरोज के जीवन मिलै ऊ उहै जेखर गवाही देथै। ");
INSERT INTO bhu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","तउभरमा तुम जीवन पामै के निता मोर लिघ्घो नेहको आमै चाहथा। ");
INSERT INTO bhu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","मै मनसेन लग महिमा नेहको चाहथो। ");
INSERT INTO bhu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","पय मै तुमही जानथो, कि तुम्हर हे भगवान के माया नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","मै अपन बाफ के नाम लग आय हबो, पय तुम मोके नेहको अपनाथा, अगर दूसर कउ अपनेन नाम लग आथै, ता तुम ओही अपनाय लेथा। ");
INSERT INTO bhu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","तुम अक दूसर लग आदर चाहथा, पय ऊ आदर जउन महान भगवान के पल्ला लग हबै, ओही नेहको चाहथा। तब तुम कसना बिस्वास कर सकथा? ");
INSERT INTO bhu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","हइ झइ समझा कि मै बाफ के आगू तुम्हर उप्पर दोस लगइहों, तुम्हर उप्पर दोस लगामै बाले तो मूसा हबै, जेखर उप्पर आसा करथा। ");
INSERT INTO bhu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","अगर तुम मूसा हे बिस्वास करे होता, ता मोरो उप्पर बिस्वास करता, काखे ऊ मोर बारे हे लिखे हबै। ");
INSERT INTO bhu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","अगर तुम ओखर लिखवरे हर बचन हे बिस्वास नेहको करथा, ता मोर बात के कसके बिस्वास करिहा? ");
INSERT INTO bhu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","इन बातन के बाद यीसु गलील के समुन्दर तिबिरियास के ऊ पार कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","तब अक्ठी बडा भीड ओखर पाछू हुइ जथै, काखे मनसे ऊ चकित बाले चिन्ह के काम देखे रथै, जउन यीसु नंगहन हे दिखाय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","तब यीसु डोंगर छो चढके अपन चेलन के संग उहां बइठ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","यहूदी के फसह के तेउहार लिघ्घो रथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","फेर यीसु देखथै कि अक्ठी बडा भीड के अपन लिघ्घो आउत देखथै अउ यीसु फिलिप्पुस लग कथै, “कि हम इनखर खाय के निता कछो लग रोटी खरीद के लाबो?” ");
INSERT INTO bhu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","यीसु फिलिप्पुस के परखै के निता हइ बात कहे रथै, काखे ऊ खुदय जानथै, कि ऊ का करही। ");
INSERT INTO bhu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिप्पुस ओही जबाब देथै, दुइ सव चांदी के पइसा के रोटी इतनी हस नेहको होही, कि हर कउ के चुटु-चुटु मिल सकै। ");
INSERT INTO bhu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","यीसु के चेला मसे समोन पतरस के भाई अन्द्रियास लग कथै, ");
INSERT INTO bhu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“इहां अक्ठी टोरवा हबै, जेखर लिघ्घो जबा के पांचठे रोटी हबै अउ दुइठे मछडी हबै, पय एतका मनसेन के निता ऊ का होही?” ");
INSERT INTO bhu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","यीसु कथै, मनसेन के बइठा देया, उहां बोहत हरियर चारा रथै अउ मनसे के बइठा देथै अउ डउकन के गिनती करीबन पांच हजार रथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तब यीसु रोटी लेथै अउ भगवान के धन्यबाद देथै अउ अपन चेलन के दइ देथै, उन बइठे हर मनसेन हे बांट देथै अउ उहै मेर मछडी के जेतका चाहथै बांट देथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","जब सगलू मनसे खाय के टुल्य हुइ गइन, ता यीसु अपन चेलन लग कथै, “बचे हर रोटी के खन्डा के उठाय लेया, ताकि कुछु झइ फटके जाय।” ");
INSERT INTO bhu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","चेला रोटी के उठाइन अउ जबा के पांचठे रोटी के खन्डा जउन खाय लग बचे हर रथै, बाराठे छन्नी हे भरिन। ");
INSERT INTO bhu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","मनसे यीसु के हइ चकित चिन्ह के काम देखके बोले लग जथै, जरूर इहै ग्यानी मनसे हबै, जउन दुनिया हे आमै बाले रथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","यीसु जान जथै, कि मनसे मोके राजा बनामै के निता पकडै चाहथै, ता यीसु डोंगर छो अक्केलेन कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","संझा हुइ जथै ता ओखर चेला समुन्दर के पाखा हे कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","उन नाह जिहाज हे चढके समुन्दर के ऊ पार कफरनहूम सहर पल्ला जाय लगथै, ऊ टेम रात हुइ जथै अउ असना होथै, कि यीसु अबहुन तक उनखर लिघ्घो नेहको आय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","उहै टेम बोहत हवा के कारन समुन्दर हे लहरा बढै लागथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","जब धीरे-धीरे तीन चार किलो मीटर के करीबन निकर गइन, ता चेला देखथै कि यीसु समुन्दर के उप्पर रेंगत नाह जिहाज के लिघ्घो अउत हबै अउ उन बोहत डेराय जथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","पय यीसु चेलन लग कथै, मै आंव, “झइ डेराबा।” ");
INSERT INTO bhu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","तब ऊ ओही नाह जिहाज के उप्पर चढाय बाले रथै, पय नाह जिहाज ऊ जिघा हे पहुंच जथै, जिछो उन जाय चाहथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","जउन मनसे समुन्दर के ऊ पार रह गय रथै, उन दूसर रोज देखथै, कि उहां अक्ठी नाह जिहाज रथै, अउ यीसु अपन चेलन के संग ऊ नाह जिहाज हे नेहको चढे रथै अउ ओखर चेला अकेले कढ गय रथै, ");
INSERT INTO bhu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","अब तिबिरियास सहर के पल्ला लग कुछ दूसर नाह जिहाज ऊ जिघा के लिघ्घो आइस, जिहां परभु यीसु बडा भीड के रोटी खबाय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","इहैनिता जब भीड देखथै कि इछो यीसु नेहको हबै अउ न ओखर चेला, ता उनो नाह जिहाज हे चढके ओही खोजत कफरनहूम सहर छो पहुंचथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","उन समुन्दर के पार करके अउ उछो यीसु के पाय के कथै, “हे गुरू तै इछो कब आय?” ");
INSERT INTO bhu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","यीसु उनही जबाब देथै, मै तुम्हर लग सही कथो, तुम मोके इहैनिता नेहको खोजथा, कि तुम चकित के काम देखे हबा, बलुक इहैनिता कि तुम पेट भर रोटी खाय हबा। ");
INSERT INTO bhu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ऊ भोजन के निता मेहनत झइ करा, जउन नास हुइ जही, पय ओखर निता मेहनत करा जउन सबरोज के जीवन ठहरथै, जउन मनसे कर टोरवा तुमही देही काखे बाफ भगवान उहै हे छाप लगाय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","उन मनसे यीसु लग पूछथै, भगवान कर काम करै के निता हम काहिन करी? ");
INSERT INTO bhu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","यीसु जबाब देथै, भगवान कर काम हइ हबै कि जेही ऊ पठोय हबै, ओखर हे बिस्वास करा। ");
INSERT INTO bhu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","तब उन ओखर लग कथै, फेर तै कउन चिन्हा दिखा सकथस, कि हम ओही देखके तोर उप्पर बिस्वास करी? तै काहिन कर सकथस? ");
INSERT INTO bhu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","हमर परदादा पतेरा हे मन्ना खाइन, जसना लिखवरे हर हबै, ऊ खाय के निता उनही स्वरग लग मन्ना दइस। ");
INSERT INTO bhu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","यीसु उनखर लग कथै, मै तुम्हर लग सही-सही कथो कि मूसा तुमही ऊ रोटी स्वरग लग नेहको दइस, बलुक मोर बाफ तुमही स्वरग लग सही रोटी देथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","काखे भगवान के रोटी ऊ हबै, जउन स्वरग लग उतर के दुनिया के जीवन देथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","तब उन यीसु लग कथै, हे परभु, हइ रोटी हमही सबरोज दय कर। ");
INSERT INTO bhu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","यीसु उनखर लग कथै, जीवन के रोटी हे आंव, जउन मोर लिघ्घो आही, ऊ कबहुन भूखे नेहको रही अउ जउन मोर उप्पर बिस्वास करही, ऊ कबहुन पियास नेहको रही। ");
INSERT INTO bhu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","मै तुम्हर लग पहिलेन कहि चुके हबो कि तुम मोके देखके बिस्वास नेहको करथा। ");
INSERT INTO bhu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","बाफ जेही मोके सउप देथै, ऊ सगलू मोर लिघ्घो आही अउ जउन कउ मोर लिघ्घो आथै, मै उके कबहुन नेहको छंडिहों। ");
INSERT INTO bhu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","काखे मै अपन इक्छा लग नेहको, बलुक अपन पठोमै बाले भगवान के इक्छा पूर करै के निता स्वरग लग आय हबो। ");
INSERT INTO bhu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","जउन मोके पठोय हबै, ओखर इक्छा हइ हबै कि जउन कुछु ऊ मोके सउपे हबै, मै उन मसे अकोठेन नास नेहको होमै देहुं, बलुक उनही सगलू के आखरी रोज हे फेरै जिन्दा करिहों। ");
INSERT INTO bhu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","मोर बाफ के इक्छा हइ हबै, कि जउन टोरवा के देखै अउ ओखर हे बिस्वास करै, ऊ सबरोज के जीवन पाही अउ मै उके आखरी रोज फेरै जिन्दा करिहों। ");
INSERT INTO bhu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","यीसु कथै, “स्वरग लग उतरे हर रोटी हे आंव।” हइ बात लग यहूदी मनसे कुडकुडामै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“का हइ यूसुफ के टोरवा यीसु नेहको हबै? हम एखर दाय बाफ के जानथन, ता अब हइ कसके कहि सकथै, कि मै स्वरग लग उतरे हबो?” ");
INSERT INTO bhu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","यीसु उनही जबाब देथै अपन हे झइ कुडकुडाबा। ");
INSERT INTO bhu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","कउ मोर लिघ्घो तब तक नेहको आय सकथै, जब तक मोर पठोमै बाले बाफ उनही अपन पल्ला खींच झइ लेय, मै ओही आखरी रोज हे फेरै जिन्दा कर दइहों। ");
INSERT INTO bhu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ग्यानी मनसे के किताब हे लिखवरे हबै, कि ऊ सब भगवान के पल्ला लग सिखाय हर होही, जउन कउ बाफ लग सुनिस अउ सिखे हबै, ऊ मोर लिघ्घो आथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“हइ झइ समझा कि कउ बाफ के देखे हबै, सिबाय उहै बाफ के देखे हबै, जउन भगवान के पल्ला लग आय हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","मै तुम्हर लग सही-सही कथो कि जउन कउ बिस्वास करथै, सबरोज के जीवन उहै के हबै। ");
INSERT INTO bhu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","जीवन के रोटी हे आंव। ");
INSERT INTO bhu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","तुम्हर पुरखा पतेरा हे रोटी खाइन तउभरमा मर गइन। ");
INSERT INTO bhu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","मै जउन रोटी के बारे हे कथो, ऊ स्वरग लग उतरे हबै अउ जउन उके खथै ऊ नेहको मरही। ");
INSERT INTO bhu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","स्वरग लग उतरे हर ऊ जीवन के रोटी हे आंव, अगर कउ हइ रोटी मसे खाही, ता ऊ सबरोज जिन्दा रही अउ जउन रोटी मै देहुं, ऊ मोर देह हबै जउन मै दुनिया कर मनसेन के निता बलि करिहों। ");
INSERT INTO bhu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","हइ सुनके यहूदी मनसे अपन हे खुसफुसाय लग जथै, हइ मनसे हमही खाय के निता अपन देह कसके दइ सकथै? ");
INSERT INTO bhu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","यीसु उनखर लग कथै, मै तुम्हर लग सही-सही कथो, कि जब तक तुम मनसे कर टोरवा के मांस के नेहको खइहा अउ ओखर खून नेहको पिहा, तब तक तुम्हर हे जीवन नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","जउन मोर देह खथै अउ मोर खून पीथै, ऊ सबरोज के जीवन पाही अउ मै ओही आखरी रोज फेरै जिन्दा करिहों। ");
INSERT INTO bhu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","काखे मोर देह सही हे खाय के खाना हबै अउ मोर खून सही हे पिय के चीज हबै। ");
INSERT INTO bhu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","जउन मोर देह के खथै अउ मोर खून पीथै, उहै हबै जउन मोर हे बने रथै अउ मै उनखर हे। ");
INSERT INTO bhu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","जसना जिन्दा बाफ भगवान मोके पठोय हबै अउ मोके बाफ लग जीवन मिलथै, ओसनेन उहो हबै, जउन मोके गरहन करथै, ऊ मोर लग जीवन पाही। ");
INSERT INTO bhu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","इहै ऊ रोटी हबै, जउन स्वरग लग उतरे हर हबै, हइ ऊ रोटी के जसना नेहको हबै, जउन सियानन खाय रथै, उन तो मर गइन, पय जउन हइ रोटी खइहीं, ऊ हरमेसा जिन्दा रही। ");
INSERT INTO bhu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","हइ बात यीसु कफरनहूम के अक्ठी यहूदी मंडली हे सिक्छा देत टेम कथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","हइ सुनके ओखर बोहत चेलन मसे कथै, “हइ तो कठोर सिक्छा हबै, एही कउन मान सकथै?” ");
INSERT INTO bhu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","यीसु अपन मन हे जान गइस कि मोर चेला हइ बात लग खुसफुसाथै, ऊ उनखर लग कथै, का तुम एखर लग डेराथा? ");
INSERT INTO bhu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","तुम तब का करिहा जब तुम मनसे कर टोरवा के उप्पर स्वरग हे जात देखिहा, जिहां ऊ पहिले रथै? ");
INSERT INTO bhu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","आतमै हबै, जउन जीवन देथै, देह लग कुछु फायदा नेहको होथै, मै तुम्हर लग जउन बात कहे हव, ऊ आतमा अउ जीवन हबै। ");
INSERT INTO bhu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","तउभरमा तुम्हर हे कुछ असना मनसे हबै, जउन बिस्वास नेहको करथै, यीसु तो पहिले लग जानथै कि कउन मोर हे बिस्वास नेहको करथै अउ कउन मोर संग बिस्वासघात करही। ");
INSERT INTO bhu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","यीसु फेर कथै, “इहैनिता मै तुम्हर लग कथो कि मोर लिघ्घो तब तक कउ नेहको आय सकथै, जब तक बाफ उके मोर लिघ्घो नेहको आमै देही।” ");
INSERT INTO bhu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","हइ कारन यीसु के चेलन मसे बोहत मनसे वापिस कढ जथै अउ उन ओखर संग छांड देथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","हइ देखके यीसु उन बाराठे चेलन लग कथै, “का, तुमो चले जाय के चाहथा?” ");
INSERT INTO bhu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","समोन पतरस जबाब देथै, परभु हम केखर लिघ्घो जइ? ऊ बात तोरै लिघ्घो हबै, जउन सबरोज के जीवन देथै। ");
INSERT INTO bhu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","अउ हम बिस्वास करथन अउ जानथन, कि भगवान के पवितर टोरवा तहिन हबस। ");
INSERT INTO bhu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","यीसु उनही जबाब देथै का मै तुमही बाराठे चेलन के नेहको चुने हव? तउभरमा तुम्हर बीच हे अक्ठी मनसे भुतवा हबै। ");
INSERT INTO bhu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","हइ बात ऊ समोन इस्करियोती के टोरवा यहूदा के बारे हे कथै, काखे इहै जउन बाराठे मसे अक्ठी रथै, यीसु के पकडामै बाले रथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","हइ बातन के बाद यीसु गलील सहर के आने जिघा हे यातरा करै लगिस, ऊ यहूदा परदेस जाय के निता नेहको चाहथै, काखे यहूदी मनसे ओही मार डारै के चाहथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","यहूदिन के अक्ठी तेउहार तम्बू के खुसी लिघ्घो रथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","इहैनिता यीसु कर भाई ओखर लग कथै, “तोके हइ परदेस के छांडके यहूदिया परदेस छो कढ जा, जेखर लग तै जउन बडा काम करथस, ओही तोर चेलो देख सकै। ");
INSERT INTO bhu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","जउन नाम कमामै चाहथै, ऊ लुक के काम नेहको करथै, जब तै असना काम करथस, ता खुद के दुनिया के आगू परगट कर दे।” ");
INSERT INTO bhu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","काखे यीसु कर भाई ओखर उप्पर बिस्वास नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तब यीसु उनखर लग कथै, मोर टेम अबे नेहको आय हबै, पय तुम्हर टेम तो कबहुन आय सकथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","दुनिया तोर लग बैर नेहको कर सकथै, बलुक ऊ मोर लग बैर करथै, काखे मै ओखर बारे हे हइ गवाही देथो, कि ओखर काम बेकार हबै। ");
INSERT INTO bhu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","तुम तेउहार के निता जा। मै हइ तेउहार के निता नेहको जहुं, काखे मोर टेम अबे तक पूर नेहको होय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","असना कहिके यीसु गलील सहर छो रुक जथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","जब ओखर भाई तेउहार हे कढ जथै, तब यीसु खुल के नेहको, बलुक गुप्त रूप हे उहां गइस। ");
INSERT INTO bhu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","यहूदी धरमगुरू तेउहार हे यीसु के खोजै लग जथै अउ मनसेन लग पूछथै, “ऊ कछो हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","यीसु के बारे हे मनसे खुसफुसाय लग जथै, कुछ मनसे कथै “ऊ निक्खा मनसे हबै।” कुछ मनसे कथै, नेहको ऊ मनसेन के भरमामै बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","तउभरमा यहूदिन के डर के मारे कउ मनसे यीसु के बारे हे खुलके बात नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","जब तेउहार के आधा रोज गुजर जथै, ता यीसु बिनती भवन हे जथै, अउ मनसेन के सिक्छा दे लग जथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","तब यहूदी नेता चकित हुइ के कहे लागथै, हइ मनसे कबहुन नेहको पढे लिखे हबै, “एही किताब के ग्यान कछो लग मिले हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","यीसु उनही जबाब देथै, हइ सिक्छा मोर नेहको पय ओखर हबै, जउन मोके पठोय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","अगर कउ ओखर इक्छा पूर करै के ठान लेही, ता ऊ हइ जान जही कि मोर सिक्छा भगवान के तरफ लग हबै या अपन तरफ लग बोलथो। ");
INSERT INTO bhu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","जउन अपन तरफ लग बोलथै, ऊ अपन निता इज्जत चाहथै, पय जउन ओखर निता बडाई चाहथै, जउन उके पठोय हबै, ऊ सही हबै, अउ ओहमा कउनो खोट नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","का मूसा तुमही नियम नेहको दइस, तउभरमा तुम्हर हे कउनो नियम के पालन नेहको करथा, “तुम मोके काखे मार डारै के चाहथा?” ");
INSERT INTO bhu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","मनसे जबाब देथै, तोंही भुतवा लगे हबै, कोन तोके मार डारै के चाहथै? ");
INSERT INTO bhu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","यीसु उनही जबाब देथै, मै अक्ठी काम करे हबो, ता तुम सगलू चकित करथा। ");
INSERT INTO bhu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","सुना, इहै कारन मूसा तुमही खतना करामै के नियम दय हबै, हइ नियम मूसा कर नेहको रथै, बलुक तुम्हर सियानन लग चले आय हबै, तुम सुस्ताय कर रोज हे मनसे के सुध्दिकरन खतना करथा। ");
INSERT INTO bhu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","तुम सुस्ताय कर रोज मनसेन के खतना इहैनिता करथा, कि मूसा कर नियम झइ टूटै, ता तुम मोर उप्पर काखे गुस्सा करथा, कि मै सुस्ताय के रोज अक्ठी मनसे के पूर तरह लग निक्खा कर दयों? ");
INSERT INTO bhu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","मुंह देखके नियाव झइ करा, बलुक सही नियाव करा। ");
INSERT INTO bhu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तब यरुसलेम के कुछ मनसे कथै, “का हइ ऊ नेहको हबै, जेही यहूदी नेता मार डालै के परयास करथै? ");
INSERT INTO bhu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","पय देखा, ऊ तो खुल्लम खुल्ला बात करथै अउ कउ ओही कुछु नेहको कथै, का यहूदी नेता अउ सरदार सही जान गय हबै, कि इहै मसीह हबै? ");
INSERT INTO bhu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","एही तो हम जानथन, कि ई मनसे कछो लग आय हबै, पय जब मसीह आही, ता कउ नेहको जानही, कि ऊ कछो कर हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","तब यीसु बिनती भवन हे सिक्छा देयत पुकार के कथै, तुम मोके जानथा अउ इहो जानथा कि मै कछो लग आय हव, मै अपन इक्छा लग नेहको आय हव, पय जउन मोके पठोय हबै, ऊ सही हबै अउ तुम ओही नेहको जानथा। ");
INSERT INTO bhu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","मै ओही जानथो, काखे मै ओखर इछो लग आय हव अउ उहै मोके पठोय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","हइ सुनके उन यीसु के पकडै के चाहथै, पय कउ ओही हाथ तक नेहको लगा पाथै, काखे ओखर टेम अब तक नेहको आय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ऊ भीड मसे बोहत मनसे यीसु हे बिस्वास करथै अउ कहै लागथै, कि जब मसीह आही, ता का एखर लग बोहत चकित के काम दिखाही, जउन हइ मनसेन हे देखाय हबै? ");
INSERT INTO bhu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","फरीसी हइ सुनिन कि मनसेन हे यीसु के बारे हे हइ मेर के खुसफुसाय लग जथै अउ पंडित अउ फरीसिन ओही पकडै के निता सिपाहिन के पठोथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","हइ देखके यीसु कथै, मै चुटु देर तक तुम्हर संग रइहों, एखर बाद मै ओखर लिघ्घो कढ जइहों, जउन मोके पठोय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","तुम मोके खोजिहा, पय नेहको पइहा, मै जिहां हव, उछो तुम नेहको आय सकिहा। ");
INSERT INTO bhu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","यहूदी नेता अपन हे कथै, ऊ कछो जही, कि हम उके नेहको पाबो? का हइ यूनानियन के बीच बसे हर यहूदियन के लिघ्घो जही अउ यूनानियन के सिक्छा देही? ");
INSERT INTO bhu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ओखर कहै के मतलब काहिन हबै, “कि तुम मोके खोजिहा, पय नेहको पइहा अउ जिहां मै हव, उहां तुम नेहको आय सकथा?” ");
INSERT INTO bhu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","फेर तेउहार के आखरी रोज, जउन खास रोज रथै, यीसु ठाढ हुइस अउ ऊ पुकार के कथै, “अगर कउ पियासे हबै, ता ऊ मोर लिघ्घो आबै। ");
INSERT INTO bhu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","जउन कउ मोर हे बिस्वास करथै, ऊ अपन पियास बुझामै। जसना कि पवितर किताब हे लिखवरे हबै, ओखर भित्तर लग जीवन के पानी के नदिया बह निकडही।” ");
INSERT INTO bhu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","यीसु हइ बात पवितर आतमा के बारे हे कथै, जउन कउ बिस्वास करही ओही पवितर आतमा मिलही, काखे पवितर आतमा अब तक नेहको उतरे रथै, काखे यीसु के महिमा के निता नेहको उठाय गय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","तब भीड मसे कुछ मनसे हइ बात सुनके कथै, सहीमा ऊ ग्यानी मनसे हबै जउन आमै बाले रथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","कुछ मनसे कथै, हइ मसीह हबै, पय कुछ मनसे कथै, का मसीह गलील परदेस लग आही? ");
INSERT INTO bhu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","का पवितर किताब हे हइ नेहको लिखवरे हबै, कि दाऊद के बिरादरी लग अउ बैतलहम गांव लग मसीह आही, जिहां दाऊद रहे करथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","हइ मेर यीसु के बारे हे मनसेन हे फूट पडिस। ");
INSERT INTO bhu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","कुछ मनसे यीसु के पकडै के चाहथै, पय कउ ओही नेहको पकड पाइन। ");
INSERT INTO bhu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","तब सिपाही पंडित अउ फरीसी के लिघ्घो लउथै, तब उन उनखर लग पूछथै, “तुम पकडके ओही काखे नेहको लाया?” ");
INSERT INTO bhu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","सिपाही जबाब देथै, जसना ऊ मनसे बोलथै, ओसना कबहुन कउनो बात नेहको बोलथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","तब फरीसी कथै, का तुमो तो ओखर बहकाबे हे नेहको आय गय हबा? ");
INSERT INTO bhu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","का यहूदी नेता सरदार या फरीसी मसे कउनो ओखर उप्पर बिस्वास करे हबै? ");
INSERT INTO bhu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","पय जउन मनसे किताब के नियम के ग्यान नेहको जानथै ऊ भगवान के पल्ला लग सरापित हबै। ");
INSERT INTO bhu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","नीकुदेमुस जउन पहिले बेर यीसु लग मिलै आथै अउ उन फरीसिन मसे अक्ठी रथै, ऊ उनखर लग कथै। ");
INSERT INTO bhu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“का हमर नियम कउनो मनसे के, जब तक पहिले ओखर बात नेहको सुन ले अउ हइ पता न लगाय ले कि ऊ काहिन करे हबै? तब उके दोसी ठहराथै।” ");
INSERT INTO bhu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","उन निकोदेमुस के पूछथै, “कहुं तहु तो गलीली नेहको हबस? किताब के पढ अउ देख कउनो ग्यानी मनसे के आमैके गलीली परदेस लग नेहको होथै।” ");
INSERT INTO bhu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","एखर बाद सब कउ अपन-अपन घर छो कढ गइन। ");
INSERT INTO bhu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","यीसु जैतून के डोंगर छो गइस। ");
INSERT INTO bhu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","यीसु बिहन्ने फेर बिनती भवन हे आथै, ता सगलू मनसे ओखर लिघ्घो आइन अउ ऊ बइठके उनही सिक्छा दे लगिस। ");
INSERT INTO bhu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","उहै टेम गुरू अउ फरीसी अक्ठी डउकी के लानथै, जउन गलत काम करत पकडै गय रथै अउ ओही सब मनसे के आगू ठाढ कर देथै। ");
INSERT INTO bhu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","उन यीसु लग कथै, हे गुरू, हइ डउकी गलत काम करत पकडे गय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","मूसा कर नियम हे हमही आदेस दय गय हबै, कि असना डउकिन के पथरा लग मार डारै चाही, तै हइ डउकी के बारे हे का कथस? ");
INSERT INTO bhu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","उन यीसु के परखै के निता हइ बात कथै, ताकि ओखर उप्पर दोस लगामै के निता कउनो मोका पामै, पय यीसु निहुर के अंगठी लग भुंइ हे लिखे लगथै। ");
INSERT INTO bhu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","जब उन यीसु लग पूछै बाले रथै, ता ऊ ठाढ हुइके उनखर लग कथै, “तुम मसे जउन कउ पाप नेहको करै हुइहा, ता उहै सबले आगू ओही पथरा मारै।” ");
INSERT INTO bhu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","अउ फेर ऊ निहुर के भुंइ हे लिखे लग जथै। ");
INSERT INTO bhu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","हइ सुनके बडका लग लइके नान तक सबके सब अक्ठी-अक्ठी करके बाहिर निकड जथै, केबल यीसु अउ ऊ डउकी, जउन ओखर आगू ठाड रथै रही गइस। ");
INSERT INTO bhu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","यीसु ठाढ हुइके ओखर लग कथै, “हे डउकी, ऊ सब कछो गइन? का कउनो तोही सजा नेहको दइन?” ");
INSERT INTO bhu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ऊ जबाब देथै, हे परभु, कउनो नेहको, यीसु ओखर लग कथै, महुं तोके सजा नेहको देथो, जा दुइबारा फेर पाप झइ करबे। ");
INSERT INTO bhu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","यीसु मनसेन लग फेर कथै, “दुनिया के उजियार हे आंव, जउन मोर पाछू चलही, ऊ अंधियार हे नेहको चलही, पय ऊ जीवन के उजियार पाही।” ");
INSERT INTO bhu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","फरीसी ओखर लग कथै, “तै अपन बारे हे खुदय गवाही देथस, तोर गवाही सही नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","यीसु उनही जबाब देथै, भले ही मै अपन बारे हे गवाही देथो, “तउभरमा मोर गवाही सही हबै, काखे मै जानथो, कि मै कछो लग आय हव अउ कछो जथो? पय तुम नेहको जानथा कि मै कछो लग आय हव अउ कछो जथो। ");
INSERT INTO bhu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","तुम देह के जसना नियाव करथा, मै कउनो मेर के नियाव नेहको करथो। ");
INSERT INTO bhu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","अउ अगर मै कउनो के नियाव करथो, ता मोर नियाव सही होही, काखे मै अकेल्ले नेहको हबो, पय मै अउ मोर बाफ हबै, जउन मोके पठोय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","तुम्हर पवितर किताब हे लिखररे हबै, कि दुइ झन के गवाही सही होथै। ");
INSERT INTO bhu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","अक्ठी तो मै अपन बारे हे गवाही देथो अउ दूसर मोर बाफ, जउन मोके पठोय हबै, ऊ मोर बारे हे गवाही देथै।” ");
INSERT INTO bhu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","उन यीसु लग कथै, तोर बाफ कछो हबै? यीसु जबाब देथै, न तुम मोके जानथा, न मोर बाफ के अगर मोके जनता ता मोर बाफ के जान जाता। ");
INSERT INTO bhu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","हइ बात ऊ मन्दिर हे सिक्छा देत दान पेटी घर हे कहे रथै अउ कउनो यीसु के नेहको पकडिन, काखे ओखर टेम अबे तक नेहको आय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","यीसु फेर मनसेन लग कथै, मै जथो अउ तुम मोके खोजत-खोजत अपन पाप हे मर जइहा, मै जछो जइहों, तुम उछो नेहको आय सकिहा। ");
INSERT INTO bhu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","हइ बात हे यहूदी नेता अपन हे सोचै लग जथै, “कहुं हइ आत्महतिया तो नेहको करही? हइ तो कथै, जछो मै जथो, उछो तुम नेहको आ सकिहा।” ");
INSERT INTO bhu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","यीसु उनखर लग कथै, तुम तरी के रहै बाले हबा, मै उप्पर के रहै बाले हव, तुम हइ दुनिया के हबा, मै हइ दुनिया के नेहको हव। ");
INSERT INTO bhu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","इहैनिता मै तुम्हर लग कथो, कि तुम अपन पाप हे मर जइहा, काखे जब तक तुम बिस्वास नेहको करिहा कि मै ऊ हव, जउन मै कथो कि मै हव, ता तुम अपनै पाप हे मर जइहा। ");
INSERT INTO bhu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","तब मनसे ओखर लग पूछथै, तै कोन हबस? यीसु उनखर लग कथै, उहै हव, जउन सुरुवात लग तुम्हर लग कहत आय हव। ");
INSERT INTO bhu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","तुम्हर बारे हे मोके बोहत कुछु कहै के हबै अउ निरनय करै के हबै, पय जउन मोके पठोय हबै सही हबै अउ जउन मै ओखर लग सुने हव, उहै दुनिया के गुठेथो। ");
INSERT INTO bhu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","पय उन मनसे नेहको समझ पाथै कि यीसु उनखर लग भगवान बाफ के बारे हे कथै। ");
INSERT INTO bhu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","तब यीसु उनखर लग कथै, जब तुम मनसे कर टोरवा के क्रूस हे चढाइहा, तब हइ जान जइहा कि मै उहै हव अउ मै अपन तरफ लग कुछु नेहको करथो, पय मै जउन कुछ कथो, उहै कथो, जसना बाफ मोके सिखाय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","मोर पठोय बाले मोर संग हबै, ऊ मोके अकेल्ले नेहको छांडथै, काखे मै हरमेसा उहै काम करथो, जउन उके निक्खा लगथै। ");
INSERT INTO bhu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","यीसु के हइ बात सुनके बोहत मनसे बिस्वास करिन। ");
INSERT INTO bhu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","जउन यहूदी यीसु हे बिस्वास करथै, उनखर लग कथै, अगर तुम मोर बचन हे मजबूत बने रइहा, ता सहीमा मोर चेला हुइहा। ");
INSERT INTO bhu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","तुम सत्य के जनिहा अउ सत्य तुमही आजाद करही। ");
INSERT INTO bhu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","यहूदी नेता यीसु के जबाब देथै, हम अब्राहम के लरका हबन, हम कबहुन कउनो के गुलामी नेहको होयन, फेर तै कसके कथस, कि तुम आजाद हुइ जइहा? ");
INSERT INTO bhu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","यीसु उनही जबाब देथै, मै तुम्हर लग सही-सही कथो, जउन कउ पाप करत रथै, ऊ पाप के गुलाम हबै। ");
INSERT INTO bhu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","हरवाह मनसे सबरोज घर हे नेहको रथै, पय टोरवा हरमेसा रथै। ");
INSERT INTO bhu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","इहैनिता अगर टोरवा तुमही आजाद करही, ता सहीमा तुम आजाद हुइ जइहा। ");
INSERT INTO bhu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","मै जानथो कि तुम अब्राहम के पीढी लग हबा, इहैनिता तुम मोके मार डारै के निता ताके बइठे हबा, काखे तुम मोर बचन हिरदय लग स्वीकार नेहको करे हबा। ");
INSERT INTO bhu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","मै अपन बाफ के इहां जउन देखे हव, उहै कथो अउ तुम उहै करथा, जउन अपन बाफ लग सुने हबा। ");
INSERT INTO bhu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","उन यीसु लग कथै, हमर बाफ अब्राहम हबै, यीसु उनखर लग कथै, अगर तुम अब्राहम के लरका हुइता, ता अब्राहम के जसना काम करता। ");
INSERT INTO bhu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","तुम मोके मारैका चाहथा, असना मनसे के जउन भगवान लग सुने हर सत्य बचन तुमही गुठे दइस, अब्राहम असना नेहको करिस। ");
INSERT INTO bhu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","तुम तो अपन बाफ के जसना काम करथा, उन यीसु लग कथै, हम गलत काम लग पइदा नेहको होय हबन, हमर अक्ठिन बाफ हबै अउ ऊ भगवान हबै। ");
INSERT INTO bhu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","यीसु उनखर लग कथै, “अगर भगवान तुम्हर बाफ होतिस, ता तुम मोर लग माया करता, काखे मै भगवान के पल्ला लग आय हव, मै अपन इक्छा लग नेहको आय हव, भगवान मोके पठोय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","तुम मोर बात इहैनिता नेहको समझथा कि तुम्हर हे मोर बचन सुनै के छमता नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","तुम तो अपन बाफ भुतवा लग हबा अउ अपन बाफ के इक्छा के पूर करै के चाहथा, ऊ तो सुरू लग खूनी रथै, ऊ सत्य हे ठाड नेहको रथै, काखे ओखर हे सत्य नेहको हबै जब ऊ झूठ बोलथै, ता अपनेन आदत के जसना बोलथै, काखे ऊ झूठा हबै अउ झूठ कर बाफ हबै। ");
INSERT INTO bhu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","मै सही बोलथो, इहैनिता तुम मोर हे बिस्वास नेहको करथा। ");
INSERT INTO bhu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","तुम मसे कउन मोर हे पाप के दोस लगाय सकथै, अगर मै सही बोलथो, ता तुम मोर हे बिस्वास काखे नेहको करथा? ");
INSERT INTO bhu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","जउन भगवान के हबै, ऊ भगवान के बात सुनथै, तुम इहैनिता नेहको सुनथा, कि तुम भगवान के नेहको हबा।” ");
INSERT INTO bhu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","हइ बात सुनके यहूदी नेता यीसु लग कथै, “का हमर हइ कहना निक्खा नेहको हबै कि तै सामरी हबस अउ तोर भित्तर भुतवा हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","यीसु जबाब देथै, मोर भित्तर भुतवा नेहको हबै, मै अपन बाफ के इज्जत करथो, पय तुम मोर बेज्जती करथा। ");
INSERT INTO bhu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","मै अपन बडाई नेहको चाहथो, पय अक्ठी हबै जउन बडाई चाहथै अउ ऊ भगवान हबै जउन नियाव करथै। ");
INSERT INTO bhu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","मै तुम्हर लग सही-सही कथो, कि अगर कउ मनसे मोर बचन हे चलथै, ता ऊ कबहुं मिरतू के नेहको देखही। ");
INSERT INTO bhu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","यहूदी नेता यीसु लग कथै, अब हमही पक्का हुइ गय हबै, कि तोर भित्तर भुतवा हबै, अब्राहम अउ ग्यानी मनसे मर गइन, पय तै कथस, अगर मोर बचन के जसना चलही, ता ऊ कबहुं मिरतू के नेहको देखही। ");
INSERT INTO bhu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","का तै हमर बाफ अब्राहम लग बडा हबस? ऊ तो मर गइस अउ ग्यानी मनसे मर गइन, तै अपनै के काहिन समझथस? ");
INSERT INTO bhu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","यीसु जबाब देथै, “अगर मै खुद अपन महिमा करिहों, ता ऊ महिमा कउनो मतलब नेहको हबै, पय मोर महिमा करै बाले बाफ हबै, जेही तुम अपन भगवान मानथा। ");
INSERT INTO bhu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","तुम ओही नेहको जानथा, पय मै ओही जानथो, अगर मै कहितो, कि मै ओही नेहको जानथो, ता मै तुम्हर मेर ठगरा हुइ जाथो, पय मै ओही जानथो, अउ ओखर बचन के आदेस हे चालथो। ");
INSERT INTO bhu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","तुम्हर बाफ अब्राहम मोर दिन देखै के आस हे मगन होय रथै, उन एही देखिस अउ मगन हुइस।” ");
INSERT INTO bhu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","यहूदी नेता ओखर लग कथै, अबे तोके पचास साल तक नेहको होय हबै, अउ तै अब्राहम के देख चुके हवस? ");
INSERT INTO bhu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","यीसु उनखर लग कथै, “मै तुम्हर लग सही-सही कथो, अब्राहम के पइदा होय लग पहिलेन मै हव।” ");
INSERT INTO bhu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","हइ सुनथै उन यीसु के मारै के निता पथरा उठाथै, पय यीसु लुक के बिनती भवन लग हुइके निकड जथै। ");
INSERT INTO bhu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","जब रास्ता हे यीसु अक्ठी मनसे के देखथै, जउन पइदाइसी अन्धरा रथै। ");
INSERT INTO bhu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","यीसु के चेला ओखर लग पूछथै, हे गुरू कोन पाप करे हबै, कि हइ अन्धरा पइदा हुइस, हइ मनसे या एखर दाय-बाफ? ");
INSERT INTO bhu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","यीसु जबाब देथै, न तो हइ मनसे पाप करे हबै, अउ न एखर दाय-बाफ, पय हइ सब इहैनिता पइदाइसी अंधरा हबै, कि एखर जीवन हे भगवान के काम परगट होय। ");
INSERT INTO bhu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","जउन मोके पठोय हबै, हमही ओखर काम के दिनै हे करै के जरूरी हबै, रात आउत हबै जब कउनो मनसे काम नेहको कर सकथै। ");
INSERT INTO bhu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","जब तक मै दुनिया हे हव, तब तक दुनिया के उजेड हव। ");
INSERT INTO bhu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","हइ कहिके यीसु भुंइ हे थूकिस अउ ऊ थूक लग माटी के सानिस अउ अंधरा के आंखी हे लगाय दइस। ");
INSERT INTO bhu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","यीसु ओखर लग कथै, “जा, सिलोह के झिरिया हे धोय लइहे।” सिलोह के मतलब हबै पठोय हर, अउ ऊ जाय के धोइस, अउ देखत लउट आथै। ");
INSERT INTO bhu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","तब ओखर परोसी अउ उन मनसे जउन पहिले भीख मांगत देखे रहिन, उन मनसे कथै, “का उहै मनसे तो नेहको हबै, जउन रास्ता के टाठा हे बइठ के भीख मांगे करत रहिस?” ");
INSERT INTO bhu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","कुछ मनसे कथै, “हां, उहै मनसे हबै” कुछ मनसे कथै, “नेहको, ओखरेन मेर कउ अउ आय।” अन्धरा मनसे कथै, “मै उहै आंव।” ");
INSERT INTO bhu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","तब मनसे ओखर लग पूछथै, “तोर आंखी कसना उघर गइस?” ");
INSERT INTO bhu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ऊ जबाब देथै, यीसु नाम के अक्ठी मनसे भुंइ हे थूक के माटी सानिस अउ मोर आंखी हे लगाके कथै, सिलोह हे जाय के धोय लइहे, मै जाय के धोय लयो अउ देखे लगो। ");
INSERT INTO bhu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","फेरै उन ओखर लग पूछथै, “ऊ कछो हबै?” ऊ कथै, “मै नेहको जानथो।” ");
INSERT INTO bhu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","कुछ मनसे ऊ मनसे के जउन पहिले अन्धरा रथै, उके फरीसिन के लिघ्घो लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","जउन रोज यीसु माटी सानके अंधरा कर आंखी के उघारे रथै, ऊ सुस्ताय कर रोज रथै। ");
INSERT INTO bhu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","हइ मेर फरीसी मनसे अक बेर फेरै पूछथै, “ऊ आंखी के उजेड कसना पाइस? ऊ गुठेथै, ऊ मोर आंखी हे माटी लगाइस फेर मै धोयों अउ अब देखथो।” ");
INSERT INTO bhu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","हइ बात हे कुछ फरीसी मनसे कहे लागथै, हइ मनसे भगवान के पल्ला लग नेहको आय। काखे ऊ सुस्ताय कर रोज के नियम के नेहको मानथै, दूसर मनसे कथै, “पापी मनसे असना चकित के चिन्ह कइसन दिखाय सकथै?” हइ मेर उनखर बीच हे झगडा हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","उन फेरै अन्धरा मनसे लग पूछथै, “जउन तोर आंखी खोले हबै, ओखर बारे हे तै काहिन कथस?” ऊ जबाब देथै, “ऊ ग्यानी मनसे हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","यहूदी नेता के बिस्वास नेहको होथै, कि ऊ अंधरा रथै अउ अब ऊ देखै लगिस, इहैनिता उन ओखर दाय-बाफ के बुलाथै, ");
INSERT INTO bhu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","अउ उनखर लग पूछथै, “का हइ तुम्हर टोरवा हबै, जेखर बारे हे तुम हइ कथा कि हइ जनम लग अंधरा रथै? ता अब हइ कइसन के देखै लगिस?” ");
INSERT INTO bhu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ओखर दाय-बाफ जबाब देथै, “हम जानथन कि हमर टोरवा हबै अउ जनम लग अंधरा रथै, ");
INSERT INTO bhu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","पय अब हम नेहको जानथन कि हइ कइसन देखै लगिस, या कउन एखर आंखी के उजेड दय हबै, ऊ लरका तो नेहको हबै, तुमिन एखर लग खुदय पूछ लेया, ऊ अपन बारे हे खुदय गुठे देही।” ");
INSERT INTO bhu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","हइ बात ओखर दाय-बाफ इहैनिता कथै कि उन यहूदी नेता लग डरथै, काखे यहूदी नेता पहिलेन अक्ठी मन हुइ चुकथै, कि अगर कउ यीसु मसीह के मनही, ता ओही मंडली लग निकाड दय जही। ");
INSERT INTO bhu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","इहै कारन ओखर दाय-बाफ कथै, “ऊ खुदय जानथै, ओखरै लग पूछ लेया।” ");
INSERT INTO bhu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","तब यहूदी नेता ऊ मनसे के जउन अंधरा रथै, दुइबारा बुलाय के ओखर लग कथै, भगवान कर महिमा के इछो मउजूद जानके सही गुठे हम जानथन कि ऊ मनसे पापी हबै। ");
INSERT INTO bhu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","अन्धरा मनसे जबाब देथै, “मै नेहको जानथो, कि ऊ पापी हबै कि नेहको मै अक्ठी बात जानथो, कि मै अन्धरा रहों अउ अब मै देखथो।” ");
INSERT INTO bhu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","उन ओखर लग फेरै पूछथै, “ऊ मनसे असना का करिस कि तोर आंखी के उजेड मिल गइस?” ");
INSERT INTO bhu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","अन्धरा मनसे उनखर लग कथै, “मै तुमही गुठे चुके हव, पय तुम नेहको सुने हबा, अब दूसर बेर काहिन सुने के चाहथा? का तुमो ओखर चेला बने चाहथा?” ");
INSERT INTO bhu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","उन यहूदी नेता ओही गधार के कथै, “तहिनहस ओखर चेला, हम तो मूसा कर चेला हबन। ");
INSERT INTO bhu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","हम जानथन कि भगवान मूसा लग बात करे रहिस, पय हइ मनसे के बारे हे हम नेहको जानथन कि ऊ कछो लग आय हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","अन्धरा मनसे उनही जबाब देथै, “इहै तो चकित के बात हबै, कि तुम इहो नेहको जानथा कि ऊ कछो लग आय हबै, तउभरमा ऊ मोर आंखी के उजेड दय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","हम जानथन कि भगवान पापिन के बिनती नेहको सुनथै, ऊ उन मनसेन के सुनथै, जउन ओखर सेबक हबै अउ ओखर इक्छा पूर करथै। ");
INSERT INTO bhu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","दुनिया के सुरू लग हइ बात कबहुन सुने हे नेहको आइस कि कउनो जनम के अन्धरा के आंखी के उजेड दय होय। ");
INSERT INTO bhu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","अगर हइ मनसे भगवान के पल्ला लग नेहको आय होतिस, ता कुछु नेहको कर सकथै।” ");
INSERT INTO bhu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","उन अन्धरा मनसे लग कथै, “तै तो बिलकुन पाप हे पइदा होय हबस तै हमही पढामै चले हबस?” अउ यहूदी नेता ओही मंडली लग बाहिर निकाड देथै। ");
INSERT INTO bhu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","जब यीसु सुनिस कि यहूदी नेता अंधरा मनसे के मंडली लग बाहिर निकार दय हबै, इहैनिता यीसु ओखर लग मिलै आथै अउ कथै, “का तै मनसे कर टोरवा हे बिस्वास करथस?” ");
INSERT INTO bhu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","अन्धरा मनसे कथै, “हे परभु ऊ कोन हबै, कि मै ओखर हे बिस्वास करव?” ");
INSERT INTO bhu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","यीसु ओखर लग कथै, “तै ओही देखे हबस अउ जउन तोर संग बात करथै, ऊ उहै हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","अन्धरा मनसे यीसु के गोड तरी गिर के कथै, हे परभु मै बिस्वास करथो। ");
INSERT INTO bhu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","यीसु कथै, मै हइ दुनिया हे नियाव करै के निता आय हव, जउन कउ अन्धरा हबै, ऊ देखै लगै अउ जउन कउ देखथै, ऊ अन्धरा हुइ जइ। ");
INSERT INTO bhu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","कुछ फरीसी मनसे ओखर संग रथै, उन हइ बात सुनके कथै, “का हमु अन्धरा हबन?” ");
INSERT INTO bhu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","यीसु उनखर लग कथै, “अगर तुम अन्धरा होता ता तुमही पाप नेहको लगतिस, पय तुम तो कथा कि हम देखथन इहैनिता तुम्हर पाप बने रथै।” ");
INSERT INTO bhu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“मै तुम्हर लग सही कथो, जउन कउ दूरा लग गेडरन के सार हुइके नेहको घुसथै अउ ऊ कउनो दूसर रास्ता हुइके चढके आथै, ऊ चोरटा अउ लूटे बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","पय जउन दूरा लग भित्तर घुसथै, ऊ गेडरन के बरेदी हबै। ");
INSERT INTO bhu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ओखर निता चउकीदार दूरा उघार देथै अउ गेडरा ओखर आरो चीनथै अउ ऊ अपन गेडरा के नाम लइ लइके बुलाथै अउ बाहिर छो लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","जब बरेदी अपन सगलू गेडरन के बाहिर निकार लइ जथै, ता ऊ गेडरन के आगू-आगू चलथै अउ गेडरा ओखर पाछू-पाछू आथै, काखे गेडरा ओखर आरो के चीनथै। ");
INSERT INTO bhu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","उन गेडरा कउनो अनचिन्हार के पाछू नेहको चलथै, बलुक ओखर लग दुरिहां भागही, काखे उन ऊ अनचिन्हार के आरो नेहको चीनथै।” ");
INSERT INTO bhu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","यीसु मनसेन के हइ किस्सा सुनाथै, पय उन नेहको समझथै कि ऊ उनखर लग का कहत हबै। ");
INSERT INTO bhu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","इहैनिता यीसु उनखर लग फेरै कथै, मै तुम्हर लग सही-सही कथो, गेडरा के निता दूरा हे आंव। ");
INSERT INTO bhu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","जेतका मोर लग आगू आइन उन सगलू चोरटा अउ लूटे बाले आय, पय गेडरा उनखर बात के नेहको सुनिन। ");
INSERT INTO bhu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","दूरा हे आंव, अगर कउ मोर दूरा हुइके भित्तर घुसही, ता ऊ मुकति पाही, अउ भित्तर बाहिर आय जाय करही अउ चारा पाही। ");
INSERT INTO bhu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","चोरटा कउनो अउ काम के निता नेहको आथै, बलुक चुरामै अउ खून अउ बरबाद करै के निता आथै, मै इहैनिता आय हव, कि मनसे जीवन पामै, अउ बहुतायत के जीवन पामै। ");
INSERT INTO bhu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","निक्खा बरेदी हे आंव, निक्खा बरेदी गेडरा के निता अपन परान दइ देथै। ");
INSERT INTO bhu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","मजदूर, जउन बरेदी नेहको हबै, अउ न गेडरा के मालिक हबै, जब बिगवा आथै, ता गेडरा के छांड के भाग जथै, अउ बिगवा उनही पकड लेथै, अउ उन इछो-उछो हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ऊ इहैनिता भाग जथै, कि ऊ मजदूर हबै, अउ ओही गेडरा के कउनो चिन्ता नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","निक्खा बरेदी हे आंव, जउन मेर बाफ मोके जानथै अउ मै बाफ के जानथो, उहैमेर मै अपन गेडरन के जानथो, अउ मोर गेडरा मोके जानथै, मै गेडरन के निता अपन परान देथो। ");
INSERT INTO bhu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","मोर अउ गेडरा हबै, जउन हइ सार के नेहको हबै, मोके उनोन के लामै के निता जरूरी हबै, उन मोर आरो सुनही, तब अक्ठिन झुन्ड होही अउ अक्ठिन बरेदी होही। ");
INSERT INTO bhu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","भगवान बाफ मोर लग इहैनिता माया करथै, कि मै अपन परान देथो, ताकि मै ओही दुबारा फेरै लग पाय लो। ");
INSERT INTO bhu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","कउनो मोर लग परान नेहको झटक सकथै, बलुक मै खुदय अपन इक्छा लग परान देथो, मोके अपन परान देय के हक हबै, अउ फेरै दुइबारा लइ ले के हक हबै, मोके अपन बाफ के तरफ लग हइ आदेस मिले हबै। ");
INSERT INTO bhu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","यीसु के हइ बचन के कारन यहूदी मनसेन हे फेरै फूट पडथै। ");
INSERT INTO bhu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","बोहत मनसे कहै लागथै, “हइ पगला गय हबै, एखर उप्पर भुतवा हबै, तुम ओखर बात के काखे सुनथा?” ");
INSERT INTO bhu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","कुछ मनसे कथै, “हइ बात अइसन मनसे के भित्तर नेहको हुइ सकथै, जेहमा भुतवा होय, का भुतवा अन्धरा के आंखी के खोल सकथै?” ");
INSERT INTO bhu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","उन दिनन हे यरुसलेम हे परकास के तेउहार मनाय जात रहिस अउ ऊ जाड के टेम रथै। ");
INSERT INTO bhu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","यीसु बिनती भवन हे सुलेमान के अंगना हे टेहलत रथै। ");
INSERT INTO bhu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","यहूदी नेता यीसु के लिघ्घो आयके उके घेर लेथै अउ पूछथै, “तै हमही कब तक संका हे रखबे? अगर तै मसीह हबस ता हमर लग साफ गुठे दे।” ");
INSERT INTO bhu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","यीसु जबाब देथै, “मै तुम्हर लग कहि चुके हव, पय तुम बिस्वास नेहको करथा, जउन काम मै अपन बाफ के नाम लग करथो, उहै मोर गवाह हबै। ");
INSERT INTO bhu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","पय तुम इहैनिता बिस्वास नेहको करथा, काखे मोर गेडरन मसे नेहको हबा। ");
INSERT INTO bhu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","मोर गेडरा मोर आरो के सुनथै, मै उनही जानथो अउ उन मोर पाछू-पाछू चलथै। ");
INSERT INTO bhu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","मै उनही सबरोज के जीवन देथो, उन कबहुन नास नेहको हुइहिन अउ कउनो उनही मोर हाथ लग नेहको छांडय पइहिन। ");
INSERT INTO bhu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","जउन कुछु मोर बाफ उनही मोके सउपे हबै, ऊ सब लग बडा हबै अउ ओही बाफ के हाथ लग कउ नेहको छांडय सकहिन। ");
INSERT INTO bhu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","मै अउ बाफ अक्ठिन हबन।” ");
INSERT INTO bhu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","यहूदी मनसे यीसु के मारै के निता फेरै पथरा उठाइन। ");
INSERT INTO bhu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","यीसु उनखर लग कथै, “मै अपन बाफ के पल्ला लग तुम्हर आगू बोहत निक्खा काम करे हव, उन मसे कउन काम के निता तुम मोके पथरा मारैका चाहथा?” ");
INSERT INTO bhu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहूदी नेता ओही जबाब देथै, “कउनो निक्खा काम के निता नेहको पय भगवान के बुराई करै के निता हम तोके पथरा लग मारैका चाहथन, काखे तै मनसे हुइके खुद के भगवान मानथस।” ");
INSERT INTO bhu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","यीसु उनही पूछथै, का तुम्हर नियम के किताब हे नेहको लिखररे हबै, मै कहे रथो, तुम सब कउ भगवान हबा? ");
INSERT INTO bhu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","जिनही भगवान कर संदेस दय गय रथै, उनही भगवान कहिके सम्बोधन करे गय हबै, अउ पवितर किताब के बात गलत नेहको हुइ सकथै। ");
INSERT INTO bhu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ता जेही बाफ सुध्द ठहराय के दुनिया हे पठोय हबै, ओखर लग तुम हइ कसना कहि सकथा, कि तै भगवान के बुराई करथस, काखे मै कथो, “मै भगवान कर टोरवा हव? ");
INSERT INTO bhu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","अगर मै अपन बाफ के काम नेहको करथो, ता मोर हे बिस्वास झइ करा। ");
INSERT INTO bhu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","अगर मै हइ काम करत हव, ता भले तुम मोर हे बिस्वास झइ करा, इन कामन हे तो बिस्वास करा कि तुम जान सका अउ समझ लेया कि बाफ भगवान मोर हे हबै अउ मै बाफ हे हव।” ");
INSERT INTO bhu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","उन अक बेर फेरै यीसु के पकडै के परयास करथै, पय ऊ उनखर हाथ लग बच के निकड जथै। ");
INSERT INTO bhu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","फेर यीसु यरदन नदिया के पार ऊ जिघा हे कढ जथै, जिहां यूहन्ना पहिले बतिस्मा दे करथै अउ ऊ उहै ठहरथै। ");
INSERT INTO bhu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","बोहत मनसे ओखर लिघ्घो आयके कथै, “यूहन्ना कउनो चिन्हा नेहको देखाइस पय जउन कुछु यूहन्ना एखर बारे हे कथै, ऊ सब कुछ सही निकडिस।” ");
INSERT INTO bhu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","अउ उछो बोहत मनसे यीसु हे बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","लाजर नाम के अक्ठी मनसे नांगा हे रथै, मरियम अउ ओखर बेहन मारथा बैतनिय्याह गांव के रहै बाले रथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","मरियम उहै डउकी रथै, जउन परभु के उप्पर महकनी तेल डार के ओखर गोड के अपन चूंदी लग पोछथै, इहै के भाई लाजर नंगाय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","इहैनिता दोनो बेहन यीसु के खबर पठोथै, हे परभु, देख जेखर लग तै माया करथस, ऊ नंगाय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","हइ सुनके यीसु कथै, हइ नांगा मिरतू के नेहको, बलुक भगवान कर महिमा के निता हबै, कि ओखर दवारा भगवान कर टोरवा के महिमा होय। ");
INSERT INTO bhu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","यीसु मारथा अउ ओखर बेहन अउ लाजर लग माया करथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","तउभरमा जब यीसु सुनथै, कि लाजर नंगहा हबै, जउन जिघा हे यीसु रथै, उहां दुइ रोज अउ रुक जथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","एखर बाद चेलन लग कथै, आबा, हम फेरै यहूदिया परदेस छो चली। ");
INSERT INTO bhu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","चेला ओखर लग कथै, “हे गुरू अबहुन यहूदी तोर उप्पर पथरा मारै के चाहथै अउ तै फेरै उछो जाय चाहथस?” ");
INSERT INTO bhu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","यीसु जबाब देथै, “का दिन के बारह घंटा नेहको होथै? अगर कउ दिन हे रेंगथै ता ठोकड नेहको खाथै, काखे हइ दुनिया के उजियार के देखथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","पय अगर जउन कउ रात हे चलै ता ठोकड खाथै, काखे ओहमा उजेड नेहको होथै।” ");
INSERT INTO bhu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","एतका कहै के बाद यीसु अपन चेलन लग कथै, हमर संगी लाजर सोय गय हबै, पय मै ओही जगामै के निता जथो। ");
INSERT INTO bhu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","तब चेला ओखर लग कथै, हे परभु अगर लाजर सोय गय हबै, ता ऊ निक्खा हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","यीसु ओखर मिरतू के बारे हे कहे रथै, पय चेला समझथै कि ऊ नींद हे सो जाय के बारे हे कहे हबै। ");
INSERT INTO bhu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तब यीसु उनखर लग सही कहि देथै, “लाजर मर गय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","अउ मै तुम्हर कारन खुस हव, कि मै उछो नेहको हव, जेखर लग तुम बिस्वास करा, पय अब आबा, हम ओखर लिघ्घो चली।” ");
INSERT INTO bhu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तब थोमा जउन दिदमुस कहाथै, अपन संगी चेलन लग कथै, “आबा हमु ओखर संग मरै के चली।” ");
INSERT INTO bhu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","उछो पहुंचै के बाद यीसु के हइ पता होथै, कि लाजर के मरघटी हे धरे चार रोज हुइ चुके हबै। ");
INSERT INTO bhu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बैतनिय्याह यरुसलेम के लिघ्घो कउनो तीन किलो मीटर दुरिहां रथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","इहैनिता उनखर भाई के मिरतू के सान्ति देय के निता यहूदी नेता अउ यहूदी परदेस के मनसे मारथा अउ मरियम के लिघ्घो आय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","जब मारथा यीसु के आमै के खबर सुनिस ता, ओखर लग मिलै के कढ गइस, पय मरियम घर हे बइठे रथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मारथा यीसु लग कथै, “हे परभु, अगर तै इछो हुइते, ता मोर भाई बिलकुन नेहको मरतै। ");
INSERT INTO bhu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","अउ मै जानथो, कि जउन कुछु तै भगवान लग मंगहे, भगवान तोके देही।” ");
INSERT INTO bhu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","यीसु ओखर लग कथै, “तोर भाई फेरै जिन्दा हुइ जही।” ");
INSERT INTO bhu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मारथा यीसु लग कथै, “मै जानथो, कि आखरी रोज हे पुनरुत्थान के टेम ऊ फेरै जिन्दा होही।” ");
INSERT INTO bhu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","यीसु ओखर लग कथै, “पुनरुत्थान अउ जीवन हे आंव, जउन कउ मोर उप्पर बिस्वास करथै, ऊ अगर मरो जइ तउभरमा जिन्दा रही। ");
INSERT INTO bhu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","अउ जउन कउ जिन्दा हबै अउ मोर हे बिस्वास करथै, ऊ सबरोज तक नेहको मरही, का तै हइ बात हे बिस्वास करथस?” ");
INSERT INTO bhu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","मारथा यीसु लग कथै, “हां परभु मै बिस्वास करथो, कि भगवान कर टोरवा मसीह जउन दुनिया हे आमै बाले रथै, ऊ तहिन हबस।” ");
INSERT INTO bhu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","हइ कहिके मारथा कढ गइस अउ अपन बेहन मरियम के बुलाके चुपके लग कथै, “गुरू इहां हबै अउ तोके बुलाथै।” ");
INSERT INTO bhu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","हइ बात सुनतै हरबी उठके यीसु लग मिलै के निता आइस। ");
INSERT INTO bhu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","यीसु अबे गांव हे नेहको पहुंचे रथै, बलुक उहै जिघा हे रथै, जछो मारथा यीसु लग मिले रथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","तब जउन यहूदी मनसे मरियम के घर सान्ति देय के निता आय रथै, उन हइ देखके कि मरियम अचनकै उठके बाहिर छो कढ गइस, ओखर पाछू आमै लग जथै, काखे उन हइ समझथै, कि ऊ मरघटी हे रोमै के जथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","जब मरियम ऊ जिघा पहुंचथै, जिहां यीसु रथै, ता ओही देखके ओखर गोड हे गिर जथै अउ कथै, “हे परभु अगर इछो हुइते ता मोर भाई लाजर नेहको मरतै।” ");
INSERT INTO bhu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","जब यीसु ओही अउ उन यहूदी मनसेन के जउन ओखर संग आथै, रोउत देखथै, ता आतमा हे बोहत उदास अउ बेचैन होथै अउ लम्बा सांस लेथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","अउ कथै, “तुम ओही कछो मढाय हबा?” उन ओखर लग कथै, “हे परभु चलके देख ले।” ");
INSERT INTO bhu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","यीसु रोइस। ");
INSERT INTO bhu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","तब यहूदी मनसे कहै लागथै, देखा, “यीसु ओखर लग केतका माया करथै।” ");
INSERT INTO bhu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","पय उन हे कुछ मनसे कथै, “हइ तो अंधरा के आंखिन के खोलिस, ता हइ मनसे के मिरतू लग नेहको बचाय सकथै?” ");
INSERT INTO bhu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","यीसु फेरै गहरी सांस लेथै अउ मरघटी हे आथै, ऊ मरघटी गुफा रथै अउ ओखर दूरा हे पथरा मढाय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","यीसु कथै, पथरा के हटाबा, लाजर के बेहन मारथा यीसु लग कथै, “हे परभु, ओहमा अब बदबु आथै, काखे ओही मरे चार रोज हुइ चुके हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","यीसु ओखर लग कथै, का मै तुम्हर लग नेहको कहै रथो, कि अगर तै बिस्वास करिहों, ता भगवान के महिमा के देखहे? ");
INSERT INTO bhu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तब मनसे ऊ पथरा के हटाथै, यीसु उप्पर देख के कथै, “हे बाफ, मै तोके धन्यबाद देथो, कि तै मोर बिनती के सुन लय हबस। ");
INSERT INTO bhu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","मै जानथो कि तै हरमेसा मोर बिनती सुनथस, पय जउन भीड अगल बगल ठाढ हबै, उनखर कारन मै हइ कथो, जेखर लग उन बिस्वास करै कि तै मोके पठोय हबस।” ");
INSERT INTO bhu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","हइ कहके ऊ बडा आरो लग पुकारथै, “हे लाजर बाहिर निकड आ।” ");
INSERT INTO bhu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","जउन मर गय रथै, ऊ कफन लग हाथ गोड हे बंधररे हर बाहिर निकड के आय जथै अउ ओखर मुंह कपडा लग लिपटे रथै, यीसु ओखर लग कथै, “ओही खोल देया अउ जाय देया।” ");
INSERT INTO bhu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","तब जउन यहूदी मरियम के लिघ्घो आय रथै, हइ काम देखके उन मसे बोहत मनसे यीसु हे बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","पय उनखर मसे कुछ मनसे फरीसिन के लिघ्घो जाय के यीसु के काम के खबर देथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","तब परधान याजक अउ फरीसी दरबार लगाइन अउ कथै, “हम काहिन करी? हइ मनसे बोहत चिन्ह दिखाथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","अगर हम उके ओसनेन रहै देथन ता सगलू कउ ओखर हे बिस्वास कर लइहिन अउ रोमी मनसे आय के हमर मंदिर अउ हमर मनसेन के नास कर दइहिन।” ");
INSERT INTO bhu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","तब उन मसे कैफा नाम के अक्ठी मनसे जउन ऊ साल के पुजारी रथै, उनखर लग कथै, “तुम कुछु नेहको जानथा। ");
INSERT INTO bhu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","अउ न हइ समझथा कि तुम्हर निता निक्खा हबै, कि हमर मनसेन मसे अक्ठी मनसे मरै अउ सगलू देस के मनसे नास झइ होय।” ");
INSERT INTO bhu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","हइ बात अपन पल्ला लग नेहको कथै, बलुक ऊ साल के पुजारी होय के कारन ऊ हइ आगू कर बात गुठेथै, कि यीसु पूर दुनिया के मनसेन के निता मरही। ");
INSERT INTO bhu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","अउ न केबल यहूदी मनसेन के निता, बलुक इहैनिता कि भगवान के भटके हर टोरवन के अकजुट कर दे। ");
INSERT INTO bhu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","पय उहै रोज लग यहूदी नेता यीसु के मारै के निता योजना बनामै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","इहैनिता यीसु ऊ टेम लग यहूदी परदेस हे पूरी तरह लग आमै जाय के बंद कर देथै, ऊ पतेरा छो निकटवर्ती परदेस इफ्राईम नाम के अक्ठी सहर छो कढ जथै अउ अपन चेलन के संग उहै रहै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","यहूदिन के फसह तेउहार लिघ्घो रथै, ऊ तेउहार के पहिलेन अपन खुद के सुध्द करैके निता बोहत मनसे अपन गांव लग यरुसलेम सहर छो कढ गय रहिन। ");
INSERT INTO bhu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","उन यीसु के खोजै लग जथै अउ बिनती भवन हे ठाढ हुइके अपन हे बात करै लग जथै, “तुम काहिन सोचथा? का ऊ तेउहार हे नेहको आथै?” ");
INSERT INTO bhu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","पंडित अउ फरीसी हइ आदेस दे रथै, कि अगर कउ मनसे जानथै कि यीसु कछो हबै, ता ऊ एखर पूर खबर दे, ताकि उके पकड सकि। ");
INSERT INTO bhu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","यीसु फसह के तेउहार लग छय रोज पहले बैतनिय्याह गांव हे आथै, जिहां लाजर रथै, जेही यीसु मरे हर मसे जिन्दा करे रथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","उहां मनसे यीसु के निता भोजन तइयार करथै अउ मारथा सेबा करथै, यीसु के संग भोजन करै बाले लाजरो रथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","तब मरियम कीमती महकनी तेल लइके यीसु के गोड हे डालथै, अपन चूंदी लग ओखर गोड पोछथै इतर लग घर सुगन्धित हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","पय यीसु के चेला मसे यहूदा इस्करियोती नाम के अक्ठी चेला जउन ओही पकडोय हे लगे रथै, ऊ हइ कथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“हइ महकनी तेल तीन सव चांदी के पइसा हे बेच के गरीबन के काखे नेहको दय गय हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ऊ हइ बात इहैनिता नेहको कथै, कि ऊ उके गरीबन के चिन्ता रथै, बलुक इहैनिता कि ऊ चोरटा रथै अउ ओखर लिघ्घो थइली रथै अउ ओहमा जउन कुछु डाले जथै, ऊ निकाड लय करथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","यीसु कथै, “इके रहन देया, ऊ हइ मोर गाडे जाय के तइयारी हे हइ सगलू कुछु करे हबै। ");
INSERT INTO bhu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","काखे गरीब तो तुम्हर संग सबरोज रइहिन, पय मै तुम्हर संग सबरोज नेहको रइहों।” ");
INSERT INTO bhu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","जब फसह तेउहार हे आय यहूदी के बडी भीड के हइ पता चलथै, कि यीसु बैतनिय्याह गांव हे हबै, ता ओखर लग मिलै आथै, न केबल ओखर लग बलुक ऊ लाजर के देखै के निता आय रथै, जेही यीसु मरै के बाद हे फेरै जिन्दा कर दय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","तब परधान याजक लाजर के मार डारै के बिचार करथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","काखे यीसु के कारन बोहत यहूदी अपन नेता के छांडके यीसु हे बिस्वास करै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","दूसर रोज, फसह तेउहार हे आय हर मनसेन के जब पता चलथै कि यीसु यरुसलेम हे आथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","इहैनिता उन खजूर के डगइल लेथै अउ यीसु लग मिलै के जाय लग जथै अउ पुकारै लग जथै, जय होय, धन्य इस्राएल के राजा जउन परभु के नाम लग आथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","जब यीसु के अक्ठी गदही के लरका मिलथै, ता ऊ ओखर उप्पर बइठ जथै, जसना किताब हे लिखररे हबै। ");
INSERT INTO bhu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","हे सियोन के टोरिया झइ डर, देख तोर राजा गदहा के, लरका के उप्पर बइठके आथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","पहिले ओखर चेला हइ बात नेहको समझथै, पय जब यीसु के महिमा परगट हुइस ता उनही सुरता आथै, कि हइ बात ओखर बारे हे लिखररे हबै अउ मनसे ओखर संग इहैमेर के बेउहार करथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","तब भीड के उन मनसे गवाही देथै, जउन ऊ टेम यीसु के संग रथै, जब ऊ लाजर के मरघटी हे मरे हर मसे जिन्दा करथै, उन मनसे देखे रथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","इहै कारन मनसे ओखर लग मिलै के निता आय रथै, काखे उन सुने रथै कि ऊ इहै हबै जउन चकित के काम देखाय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","तब फरीसी मनसे अपन हे कथै, “देखथा, तुम कुछु नेहको के पइहा, देखा सगलू दुनिया ओखे पाछू चलथै।” ");
INSERT INTO bhu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","जउन मनसे ऊ तेउहार हे भजन करै आय रथै, उनखर हे कुछ यूनानी रथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","उन गलील परदेस के बैतसदा गांव के रहै बाले फिलिप्पुस के लिघ्घो आयके ओखर लग बिनती करथै, साहब, हम यीसु लग मिलै चाहथन, तब फिलिप्पुस अन्द्रियास के आयके गुठेथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","तब अन्द्रियास अउ फिलिप्पुस जायके यीसु लग कथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","हइ बात हे यीसु उनखर लग कथै, ऊ टेम आय गय हबै, कि मनसे कर टोरवा के महिमा होय। ");
INSERT INTO bhu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","मै तुम्हर लग सही-सही कथो, कि जब तक गोहूं के दाना भुंइ हे गिर के नेहको सर जथै, तब तक ऊ अकेल्ले रथै, पय जब सर जथै, ता बोहत फडुहा लाथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","जउन अपन परान लग माया करथै, ऊ अपन परान के खोय देही, पय ऊ जउन हइ दुनिया हे अपन परान लग माया नेहको करथै, उके सबरोज के जीवन के निता रखही। ");
INSERT INTO bhu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","अगर कउ मोर सेबा करै ता मोर पाछू हुइ ले अउ जिहां मै हव उहां मोर सेबक होही, अगर कउ मोर सेबा करै, ता बाफ ओखर इज्जत करही। ");
INSERT INTO bhu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","अब मोर जीवन के उकुल बुकुल लागथै, इहैनिता अब मै का कहो, हे बाफ, मोके हइ दुख के टेम लग बचाय ले, पय मै इहै टेम के निता आय हव। ");
INSERT INTO bhu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","हे बाफ, अपन नाम के महिमा के, ऊ टेम स्वरग लग हइ आरो सुनाई देथै, “मै अपन नाम के महिमा करे हव अउ फेरै ओखर महिमा करिहों।” ");
INSERT INTO bhu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","तब जउन मनसे ठाढ हुइके सुनथै, उन कथै, कि बादर गरजिस, कुछ मनसे कथै, “स्वरगदूत ओखर लग बोले हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","हइ बात हे यीसु कथै, हइ आरो मोर निता नेहको बलुक तुम्हर निता होय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","अब हइ दुनिया के नियाव होही, अब हइ दुनिया के सरदार के निकाड दय जही। ");
INSERT INTO bhu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","अउ मै जब भुंइ लग उप्पर उठाय जहुं, ता सबझन के अपन पल्ला खीचहुं। ");
INSERT INTO bhu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","हइ बातन के दवारा यीसु बतामै चाहथै कि मोर मिरतू कइसन मेर के होही। ");
INSERT INTO bhu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","हइ बात हे मनसे ओखर लग कथै, “हम किताब के हइ बात सुने हबन कि मसीह सबरोज रही, फेर तै काखे कथस, कि मनसे कर टोरवा के उप्पर उठाय के जरूरी हबै, हइ मनसे के टोरवा कोन हर हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","यीसु उनखर लग कथै, “उजियार अब चुटु देर तक तुम्हर बीच हे रही, जब तक उजियार तुम्हर संग हबै, तब तक आगू बढत जा, असना झइ होय कि अंधियार तुमही आयके घेरय। जउन अंधियार हे रेंगथै, ऊ नेहको जानथै कि कछो जथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","जब तक उजियार तुम्हर संग हबै, उजियार हे बिस्वास करा, ताकि तुम उजियार के लरका बना।” यीसु हइ बात कहिके कढ गइस अउ उनखर लग लुक गइस। ");
INSERT INTO bhu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","तउभरमा यीसु उनखर आगू हइ सगलू चकित के चिन्ह परगट करिस पय मनसे बिस्वास नेहको करिन। ");
INSERT INTO bhu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ताकि यसायाह ग्यानी मनसे के बात पूर होय जउन ऊ कथै, “हे परभु, हमर संदेस हे कोन बिस्वास करै हबै? अउ केखर उप्पर सक्ति परगट करे गय हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","उन हइ कारन बिस्वास नेहको कर सकिन, काखे यसायाह ग्यानी मनसे इहो कहे हबै। ");
INSERT INTO bhu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“भगवान उनखर आंखिन के अन्धरा, अउ उनखर मन ठोस कर दय हबै, ताकि उन अपन आंखी लग झइ देख सकै, अउ दिमाक लग झइ समझ पामै, अउ मोर पल्ला झइ मुड सकै, जेखर लग मै उनही निक्खा कर सको।” ");
INSERT INTO bhu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यसायाह हइ बात इहैनिता कथै, कि उन ओखर महिमा देखे रथै अउ ऊ ओखर बारे हे बात करिस। ");
INSERT INTO bhu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","तउभरमा साहब मसे बोहत यीसु हे बिस्वास करथै, पय फरीसिन के कारन अपन बिस्वास के परगट नेहको कर पाथै, काखे असना करै लग उनही मंडली लग निकाड झइ देय के डर रथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","उनही मनसेन के दवारा दय गय बडाई भगवान के दवारा दय गय बडाई लग बोहत जादा पिरिया रथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","यीसु पुकार के कथै, “जउन मोर हे बिस्वास करथै, ऊ मोर हे नेहको बलुक मोर पठोय बाले हे बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","अउ जउन मोके देखथै, ऊ ओही देखथै, जउन मोके पठोय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","मै दुनिया हे उजियार बनके आय हव, जउन कउ मोर हे बिस्वास करही ऊ अंधियार हे नेहको रइहीं। ");
INSERT INTO bhu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","अगर कउ मोर बात के सुनके नेहको मानथै, ता मै ओही दोसी नेहको ठहराहुं, काखे मै दुनिया के दोसी ठहरामै के निता नेहको, बलुक दुनिया के मुकति करै के निता आय हव। ");
INSERT INTO bhu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","जउन कउ मोके नकारथै अउ मोर बात के नेहको स्वीकरथै, ओही दोसी ठहरामै बाले अक्ठी हबै, जउन ओही सजा देही, मतलब जउन बात मै कहे रहों, उहै आखरी रोज हे ओही सजा देही। ");
INSERT INTO bhu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","काखे मै अपन पल्ला लग बात नेहको करथो, पय बाफ जउन मोके पठोय हबै, उहै मोके आदेस दय हबै, कि काहिन-काहिन कहे के हबै अउ काहिन-काहिन बोलै के हबै। ");
INSERT INTO bhu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","अउ मै जानथो कि ओखर आदेस के मतलब हबै, सबरोज के जीवन, इहैनिता मै जउन कुछु बोलथो, ठीक ओसनेन कथो, जसना बाफ मोर लग कहे हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","फसह के तेउहार लग पहिले, यीसु जानथै कि मोर ऊ टेम आय पहुंचे हबै, कि हइ दुनिया छांडके बाफ के लिघ्घो जायके हबै, ता अपन मनसेन लग जउन दुनिया हे हबै, जसना माया करत आय हबै, आखरी तक ओसनेन माया करिस। ");
INSERT INTO bhu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","यीसु अपन चेलन के संग खाना खात रहै, समोन इस्करियोती के टोरवा यहूदा के मन हे भुतवा हइ सोच डाल चुकथै, कि ऊ यीसु के धोखा लग पकडोही। ");
INSERT INTO bhu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","यीसु हइ जानथै कि बाफ सगलू कुछु ओखर हाथ हे सउप दय हबै अउ ऊ भगवान कर लिघ्घो लग आय हबै अउ भगवान कर लिघ्घो जात हबै। ");
INSERT INTO bhu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","यीसु खाना खाय के उठके अपन उप्पर के कपडा उतार देथै अउ साफी लइके अपन कनिहा हे बांध लइस। ");
INSERT INTO bhu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तब यीसु परात हे पानी भर के चेलन के गोड धोइस अउ कनिहा हे बांधे हर साफी लग उनखर गोड पोछथै। ");
INSERT INTO bhu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","जब ऊ समोन पतरस के लिघ्घो आथै, तब पतरस ओखर लग कथै, “हे परभु तै मोर गोड काखे धोथस?” ");
INSERT INTO bhu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","यीसु जबाब देथै, जउन मै करथो, “तुम अबे नेहको समझिहा, कि मै काहिन करथो, बाद हे समझिहा?” ");
INSERT INTO bhu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पतरस यीसु लग कथै, “मै तोही अपन गोड के कबहुन नेहको धोमै दइहों।” हइ सुनके यीसु ओखर लग कथै, “अगर मै तुम्हर गोड नेहको धुइहों, ता तुम्हर मोर संग कउनो मेर नाता नेहको रह जही।” ");
INSERT INTO bhu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","समोन पतरस यीसु लग कथै, “हे परभु, तै मोर गोडै भर नेहको मोर हाथ अउ मूडो के धोय दे।” ");
INSERT INTO bhu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","यीसु उनखर लग कथै, “जउन असनाद चुके हबै, ओही गोड के सिबाय अउ कुछु धोमै के जरूरत नेहको, ऊ बिलकुन सुध्द हबै अउ तुम सुध्द हबा, पय सबके सब सुध्द नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","यीसु हइ जानथै कि कउन मोर संग बिस्वासघात करही, इहैनिता हइ कथै, तुम सबके सब सुध्द नेहको हबा। ");
INSERT INTO bhu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","जब यीसु चेलन के गोड धोय के अउ अपन कपडा पहिन के खाना खाय के निता फेर बइठ जथै, ता उनखर लग कथै, तुम का समझा कि मै तुम्हर संग का करे हव? ");
INSERT INTO bhu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","तुम मोके गुरू अउ परभु कथा अउ ठीक कथा, काखे मै उहै आंव। ");
INSERT INTO bhu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","अगर मै परभु अउ गुरू होय के तुम्हर गोड धोय हव, ता तुमो अक-दूसरे के गोड धोमै चाही। ");
INSERT INTO bhu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","मै तुमही करके देखाय हबो, कि जसना मै तुम्हर संग करे हव, ओसनेन तुमो करे करिहा। ");
INSERT INTO bhu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","मै तुम्हर लग सही-सही कथो, हरवाह अपन गुरू लग बडा नेहको होथै अउ न पठोय हर अपन पठोय बाले लग। ");
INSERT INTO bhu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","तुम हइ बात जानथा अउ एखर जसना चलिहा ता तुम्हर जीवन धन्य हबै। ");
INSERT INTO bhu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","मै तुम सबके बारे हे नेहको कथो, मै जानथो कि मै कउन-कउन मनसेन के चुने हव, पय हइ इहैनिता होथै कि पवितर किताब के हइ बचन पूर होय, जउन मोर रोटी खाथै, उहै मोर बिरोध हे ठाड हबै। ");
INSERT INTO bhu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","हइ सगलू घटना घटै लग पहिलेन तुमही गुठेथो कि जब हइ सगलू घटना घटही ता तुम मोर हे बिस्वास करा कि मै उहै हव। ");
INSERT INTO bhu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","मै तुम्हर लग सही-सही कथो, कि जउन मोर पठोय बाले के सोगत करथै, ऊ मोके सोगत करथै अउ जउन मोके स्वीकार करथै, ऊ मोर पठोय बाले के स्वीकार करथै। ");
INSERT INTO bhu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","हइ बात कहिके यीसु आतमा हे बेचैन होथै अउ ऊ हइ गवाही दइस, कि मै तुम्हर लग सही-सही कथो, कि तुम्हर मसे अकझन मोके पकडोही। ");
INSERT INTO bhu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","चेला चिन्ता हे हुइ जथै अउ अक दूसर के देखै लग जथै, कि ऊ केखर बारे हे कथै। ");
INSERT INTO bhu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","यीसु के चेला मसे अक्ठी जेखर लग ऊ बोहत माया करथै, ऊ यीसु के लिघ्घो बइठे रथै। ");
INSERT INTO bhu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","समोन पतरस ओखर लग इसारा लग पूछथै, “परभु असना केखर बारे हे कथस?” ");
INSERT INTO bhu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ऊ चेला यीसु लग पूछथै, “हे परभु, ऊ कोन हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","यीसु जबाब देथै, “जेही मै हइ रोटी के खन्डा टठिया हे बुडोय के दइहों, उहै हबै।” अउ ऊ रोटी के खन्डा के बुढाय के समोन इस्करियोती के टोरवा यहूदा के देथै। ");
INSERT INTO bhu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","रोटी के खन्डा लेतै यहूदा हे भुतवा समाय गइस, तब यीसु ओखर लग कथै, “तोहीं जउन करै के हबै, ऊ हरबी कर।” ");
INSERT INTO bhu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","खाना खाय बाले मसे कउनो नेहको समझ पाथै, कि यीसु हइ बात ओखर लग काखे कथै। ");
INSERT INTO bhu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","यहूदा के लिघ्घो पइसा के थइली रथै, इहैनिता कुछ चेला हइ समझिन कि यीसु ओखर लग कथै, कि जउन कुछु हमही तेउहार के निता चाही ऊ खरीद के लइ आबै, या गरीबन के कुछ दइदे। ");
INSERT INTO bhu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","यहूदा रोटी के खन्डा लइके हरबी बाहिर कढ गइस अउ ऊ टेम रात रथै। ");
INSERT INTO bhu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","जब यहूदा बाहिर कढ गइस एखर बाद यीसु कथै, “अब मनसे कर टोरवा के महिमामय हुइस अउ ओखर दवारा भगवान कर महिमा होय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","अगर ओखर दवारा भगवान कर महिमा हुइ, ता भगवानो अपन दवारा ओखर महिमा करही अउ हरबी महिमामय करही। ");
INSERT INTO bhu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","मै अब चुटु देर तुम्हर संग हव, फेरै तुम मोके खोजिहा अउ जसना मै यहूदी नेता लग कहे हबो, ओसनेन मै अब तुम्हर लग कथो जछो मै जथो, उछो तुम नेहको आय सकिहा। ");
INSERT INTO bhu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","मै तुमही अक्ठी नबा आदेस देथो, कि तुम अक दूसर लग माया करा, जसना मै तुम्हर लग माया करथो, ओसनेन तुमो अक दूसर लग माया करा। ");
INSERT INTO bhu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","अगर तुम अक दूसर लग माया करिहा, ता उहै लग सब कउ जनहीं कि तुम मोर चेला हबा।” ");
INSERT INTO bhu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","समोन पतरस यीसु लग कथै, “हे परभु,” तै कछो जथस? यीसु ओही जबाब देथै, “मै जछो जथो, उछो तुम हइ टेम मोर पाछू नेहको आ सकथा, बलुक एखर बाद हे तुम मोर पाछू अइहा।” ");
INSERT INTO bhu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पतरस ओखर लग कथै, “हे परभु, मै हइ टेम तोर पाछू काखे नेहको आय सकथों? मै तो तोर निता अपन परान तक दइ दइहों।” ");
INSERT INTO bhu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","यीसु जबाब देथै, “तै मोर निता अपन परान दइहे? मै तोर लग सही-सही कथो, कि कुकडी बांसय लग पहिलेन तै मोके तीन बार चीन्हे लग मना करबे।” ");
INSERT INTO bhu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","तुम्हर मन दुखी झइ होय, भगवान हे बिस्वास करा अउ मोरो हे बिस्वास करा। ");
INSERT INTO bhu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","मोर बाफ के घर छो बोहत रहै के जिघा हबै, अगर असना नेहको होथै ता मै तुम्हर लग कहि देतों, काखे मै तुम्हर निता जिघा तइयार करै जथो। ");
INSERT INTO bhu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","उछो मै जायके तुम्हर निता जिघा तइयार करै के बाद मै फेरै अइहों अउ तुमही अपन संग लइ जइहों, जेखर लग जछो मै हबो, उहै छो तुमो रहा। ");
INSERT INTO bhu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","जछो मै जथो, तुम उछो के रास्ता जानथा। ");
INSERT INTO bhu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमा यीसु लग कथै, “हे परभु हम नेहको जानथन कि तै कछो जथस, ता उछो के रास्ता कइसन जान सकथन?” ");
INSERT INTO bhu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","यीसु कथै, सत्य, रास्ता अउ जीवन हे आंव, मोर बिना कउ बाफ के लिघ्घो नेहको पहुंच सकथै। ");
INSERT INTO bhu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","अगर तुम सही हे मोके जाने होता, ता मोर बाफो के जनता, अब लग तुम ओही जानथा अउ तुम ओही देखे हबा। ");
INSERT INTO bhu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिप्पुस यीसु लग कथै, “हे परभु, तै हमही बाफ के दरसन करवाय दे, इहै हमर निता बोहत हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","यीसु कथै, हे फिलिप्पुस, मै एतका रोज लग तुम्हर संग हव, का तउभरमा तुम मोके नेहको जाना? जउन मोके देखे हबै, ऊ बाफ के देखे हबै, फेर तुम कसके कहि सकथा, कि हमही बाफ के दरसन करा? ");
INSERT INTO bhu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","का तुम बिस्वास नेहको करथा, कि मै बाफ हे हव अउ बाफ मोर हे हबै? जउन बात मै तुम्हर लग कथो, ऊ मै अपन तरफ लग नेहको कथो, बलुक बाफ मोर हे रहिके अपन काम पूर करथै। ");
INSERT INTO bhu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","मोर बिस्वास करा कि मै बाफ हे हव अउ बाफ मोर हे हबै, नहि ता उन कामन के कारन बिस्वास करा। ");
INSERT INTO bhu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","मै तुम्हर लग सही-सही कथो, कि जउन मोर हे बिस्वास करथै, उन सगलू काम करहीं, जउन काम मै करथो, बलुक इनखरो लग बडा-बडा काम करही, काखे अब मै बाफ के लिघ्घो जथो। ");
INSERT INTO bhu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","जउन कुछु तुम मोर नाम लग मंगिहा, ओही मै पूर करिहों, जेखर लग टोरवा के दवारा बाफ के महिमा होय। ");
INSERT INTO bhu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","अगर तुम मोर नाम लग जउन कुछु मंगिहा, ता मै ओही पूर करिहों। ");
INSERT INTO bhu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","अगर तुम मोर लग माया करथा, ता मोर आदेस के मनिहा। ");
INSERT INTO bhu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","मै बाफ लग बिनती करिहों, अउ ऊ तुमही अक्ठी दूसर मदद करै बाले देही, जउन सबरोज तुम्हर संग रही। ");
INSERT INTO bhu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ऊ सत्य के आतमा हबै, जेही दुनिया स्वीकार नेहको करथै, काखे दुनिया न तो ओही देखे हबै, अउ न ओही जानथै, तुम ओही जानथा, काखे ऊ तुम्हर हे निबास करथै, अउ ऊ तुम्हर संग हरमेसा बने रही। ");
INSERT INTO bhu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","मै तुमही अकेले नेहको छंडिहों, मै तुम्हर लिघ्घो फेरै लउट के अइहों। ");
INSERT INTO bhu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","चुटु टेम रह गय हबै, फेर दुनिया मोके नेहको देखही, पय तुम मोके देखिहा, मै जिन्दा हव, इहैनिता तुमो जिन्दा रइहा। ");
INSERT INTO bhu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ऊ रोज तुम जान जनिहा, कि मै अपन बाफ हे हव, अउ तुम मोर हे अउ मै तुम्हर हे। ");
INSERT INTO bhu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","जउन मोर आदेस मानथै अउ ओखर पालन करथै, उहै मोर लग माया करथै, अउ जउन मोर लग माया करथै, उनखर लग बाफ माया करही अउ महुं उनखर लग माया करिहों, अउ खुद के उनखर हे परगट करिहों। ");
INSERT INTO bhu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ऊ यहूदा जउन यहूदा इस्करियोती अलगे हबै, यीसु लग कथै, “हे परभु, असना का हुइ गय हबै कि तै खुद के तो हमर हे परगट करै चाहथस? पय दुनिया हे नेहको।” ");
INSERT INTO bhu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","यीसु उनखर लग कथै, अगर जउन कउ मोर लग माया करही, उन मोर बात के मनही अउ मोर बाफ उनखर लग माया करही अउ हम उनखर लिघ्घो अउबे अउ उनखर संग रहिबे। ");
INSERT INTO bhu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","जउन मोर लग माया नेहको करथै, ऊ मोर बचन नेहको मानथै, अउ जउन बचन तुम सुनथा, ऊ मोर नेहको बलुक ऊ बाफ के हबै, जउन मोके पठोय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","मै तुम्हर संग रहत तुम्हर लग हइ बात कहे हव। ");
INSERT INTO bhu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","पय मदद करै बाले मतलब, पवितर आतमा, जेही बाफ मोर नाम लग पठोही, ऊ तुमही सगलू बात सिखाही, अउ जउन कुछु मै तुम्हर लग कहे हव, ऊ ओखर तुमही सुरता कराही। ");
INSERT INTO bhu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","तुम्हर निता मै सान्ति छांडे जथो, मै अपन सान्ति तुमही देथो, जसना दुनिया देथै, मै तुमही ओसना नेहको देथो, तुम्हर मन झइ घबराय अउ झइ डेराय। ");
INSERT INTO bhu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","मोर बात सुरता रखिहा, मै जथो अउ तुम्हर लिघ्घो फेर लउट के आहुं, अगर तुम मोर लग माया करथा, ता हइ बात लग खुस हुइता कि मै बाफ के लिघ्घो जथो, काखे बाफ मोर लग बडा हबै। ");
INSERT INTO bhu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","अबे मै हइ घटना घटै लग पहिले तुम्हर लग कहि दय हव, कि जब घटना घटै तब तुम बिस्वास करा। ");
INSERT INTO bhu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","अब मै तुम्हर लग अउ बोहत बात नेहको करिहों, काखे हइ दुनिया के सरदार आउत हबै, ऊ मोर कुछ नेहको कर सकथै, ");
INSERT INTO bhu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","पय हइ जरूरी हबै कि दुनिया जान जाय कि मै बाफ लग माया करथो, अउ जसना बाफ मोके आदेस दय हबै, मै ओसनेन करथो, उठा, इछो लग चली। ");
INSERT INTO bhu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","यीसु कथै, “सही अंगूर के रूख हे आंव अउ मोर बाफ किसान हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","जउन डगइल मोर हे हबै, अउ फडुहा नेहको फडथै, ओही खपल डालथै, जउन फडुहा फडथै, ओही छठियाथै, ताकि ऊ अउ जादा फडै। ");
INSERT INTO bhu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","तुम ऊ बचन के कारन जउन मै तुम्हर लग कहे हव, सुध्द हुइ चुके हबा। ");
INSERT INTO bhu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","तुम मोर हे बने रइहा अउ मै तुम्हर हे बने रइहों, जउन मेर डगइल अगर रूख हे नेहको बने रही, ता अपनै लग नेहको फड सकथै, उहै मेर तुमो मोर हे नेहको बने रइहा, ता तुमो फडुहा नेहको लान सकिहा। ");
INSERT INTO bhu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","मै रूख आंव, तुम डगइल हबा, जउन मोर हे बने रथै अउ मै उनखर हे, ऊ बोहत फडथै, काखे मोर लग अलगे रही के तुम कुछु नेहको कर सकथा। ");
INSERT INTO bhu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","अगर कउ मोर हे मजबूत बने नेहको रही, ता ऊ डगइल के जसना फटक दय जथै जउन झुराय जथै, ओही मनसे उठाय के आगी हे झपोय देथै अउ ऊ जर जथै। ");
INSERT INTO bhu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","अगर तुम मोर हे मजबूत बने रइहा अउ मोर बात तुम्हर हे मजबूत बने रही, ता जउन चइहा मंगिहा ऊ तुमही मिल जही। ");
INSERT INTO bhu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","मोर बाफ के महिमा इहै लग होथै, कि तुम बोहत आतमन के मोर लिघ्घो लाना, तबै तुम मोर चेला कहाइहा। ");
INSERT INTO bhu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","जउन मेर बाफ मोर लग माया करथै, ओसनेन महुं तुम्हर लग माया करथो, तुम मोर माया हे बने रइहा। ");
INSERT INTO bhu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","अगर तुम मोर आदेस के मनिहा, ता मोर माया हे बने रइहा, जसना मै अपन बाफ के आदेस के माने हबो अउ ओखर माया हे बने रथो। ");
INSERT INTO bhu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","मै तुम्हर लग इहैनिता कथो, कि मोर खुसी तुम्हर हे रहै अउ तुम्हर खुसी पूर हुइ जाय। ");
INSERT INTO bhu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","मोर आदेस हइ हबै कि जसना मै तुम्हर लग माया करथो, ओसनेन तुमो अक दूसर लग माया करा। ");
INSERT INTO bhu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","एखर लग बडा माया कउनोन के नेहको हबै, कि कउ अपन संगी के निता अपन परान के दइ दे। ");
INSERT INTO bhu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","अगर तुम मोर आदेस के मनिहा, ता तुम मोर संगी हबा। ");
INSERT INTO bhu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","अब लग मै तुमही हरवाह नेहको कइहों, काखे हरवाह नेहको जानथै, कि ओखर मालिक का करे बाले हबै, बलुक मै तुमही संगी कहे हव, काखे जउन बात मै अपन बाफ लग सुने हव, ऊ सगलू तुमही गुठे दय हव। ");
INSERT INTO bhu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","तुम मोके नेहको चुने हबा, बलुक मै तुमही इहैनिता चुने हव अउ ठहराय हव, कि दुनिया हे तुम जाय के फडुहा लाबा अउ तुम्हर फडुहा बने रहै, कि तुम मोर नाम लग जउन कुछु बाफ लग मंगिहा ता ऊ तुमही देही। ");
INSERT INTO bhu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","मै तुमही हइ आदेस इहैनिता देथो, कि तुम अक दूसर लग माया करा। ");
INSERT INTO bhu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","अगर दुनिया तुम्हर लग बैर करथै, ता धियान रखा कि तुम्हर लग पहिले उन मोर लग बैर करे हबै। ");
INSERT INTO bhu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","अगर तुम दुनिया के हुइता, ता दुनिया तुमही अपन समझ के माया करतिन, पय तुम दुनिया के नेहको हबा, काखे मै तुमही दुनिया लग चुने हव, इहैनिता दुनिया तुम्हर लग बैर करथै। ");
INSERT INTO bhu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","जउन बात मै तुम्हर लग कहे हव, ओही सुरता रखिहा, हरवाह अपन मालिक लग बडा नेहको होथै, अगर उन मोके सताय हबै, ता उन तुमो के सतइहिन, अगर उन मोर बचन के मानथै, ता तुम्हरो बात के मनहिन। ");
INSERT INTO bhu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","उन हइ सब कुछ मोर नाम के कारन तुम्हर संग करही, काखे जउन मोके पठोय हबै ओही उन नेहको जानथै। ");
INSERT INTO bhu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","अगर मै नेहको आतों अउ उनही सिक्छा नेहको देतों, ता उन दोसी नेहको होतिन, पय अब उनखर लिघ्घो अपन पाप के छुपामै के निता कउनो मेर के बहाना नेहको बचे हबै। ");
INSERT INTO bhu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","जउन मोर लग बैर करथै ऊ मोर बाफो लग बैर करथै। ");
INSERT INTO bhu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","अगर मै उनखर बीच हे चकित के काम नेहको करे होतो, जेही कउनो अउ कबहुं नेहको करिन, ता उन पापी नेहको ठहरतिन, पय अब तो उन देख के मोर लग अउ मोर बाफ लग बैर करे हबै। ");
INSERT INTO bhu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","हइ इहैनिता हुइस कि मूसा कर नियम के बचन पूर होय, उन मोर लग बेकार हे बैर करिन। ");
INSERT INTO bhu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","पय जब मदद करै बाले आही, जेही मै बाफ के इछो लग तुम्हर लिघ्घो पठोहूं, मतलब सही के आतमा, जउन बाफ लग निकडथै, तब ऊ मोर बारे हे गवाही देही। ");
INSERT INTO bhu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","अउ तुमो मोर बारे हे गवाही दइहा, काखे तुम सुरू लग मोर संग रहे हबा। ");
INSERT INTO bhu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","हइ बात मै तुम्हर निता इहैनिता कहे हव, कि तुम भरमामै लग बचे रइहा। ");
INSERT INTO bhu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","उन तुमही मंडली लग निकाड देही, एतको नेहको, ऊ टेम आउथे, जब तुम्हर हत्या करै बाले हइ समझही कि मै भगवान कर सेबा करथो। ");
INSERT INTO bhu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","उन हइ इहैनिता करही कि उन न तो बाफ के जानथै, अउ न मोके जानथै। ");
INSERT INTO bhu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","हइ सच्चाई मै इहैनिता परगट करथो, कि जब हइ सब होमै लगही ता तुमही सुरता आबै कि इनखर बारे हे मै तुमही पहिलेन लग गुठे दय रहों, मै तुमही सब कुछ सुरुवात हे इहैनिता नेहको गुठे रहों कि ऊ टेम मै तुम्हर संग रहों। ");
INSERT INTO bhu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","अब मै अपन पठोय बाले के लिघ्घो जथो, अउ तुम मसे कउ मोर लग नेहको पूछथा, कि तै कछो जथस? ");
INSERT INTO bhu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","मै जउन बात तुम्हर लग कहे हव, इहैनिता तुम्हर मन चिन्ता लग भर गय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","तउभरमा मै तुम्हर लग सही कथो, मोर जाना तुम्हर निता फायदा हबै, अगर मै नेहको जहुं, ता ऊ मददगार तुम्हर लिघ्घो नेहको आही, अगर मै जहुं, ता ओही मै तुम्हर लिघ्घो पठोहूं। ");
INSERT INTO bhu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","जब ऊ दुनिया हे आही, ता पाप, नियाइपन अउ सजा के बारे हे दुनिया के दोसी सिध्द के देही। ");
INSERT INTO bhu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","पाप के बारे हे काखे उन मोर हे बिस्वास नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","नियाइपन के बारे हे, काखे मै बाफ के लिघ्घो जथो अउ फेर तुम मोके नेहको देख पइहा। ");
INSERT INTO bhu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","नियाव के बारे हे काखे हइ दुनिया के सरदार दोसी ठहराय जाय चुके हबै। ");
INSERT INTO bhu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","मोके तुम्हर लग अउ बोहत कुछु कहेका हबै, पय अबे तुम ऊ नेहको सह सकिहा। ");
INSERT INTO bhu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","जब ऊ सही के आतमा आही, ता तुमही सगलू सही के रास्ता तुमही गुठेही, काखे ऊ अपन तरफ लग नेहको कहि, बलुक ऊ जउन कुछु सुनही उहै कहि अउ तुमही आमै बाले बातन के बारे हे गुठेही। ");
INSERT INTO bhu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ऊ मोर महिमा करही, काखे ऊ मोर तरफ लग जउन मिले हबै, ऊ तुमही उहै गुठेही। ");
INSERT INTO bhu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","जउन कुछु बाफ के हबै, ऊ सगलू मोर हबै, इहैनिता मै कथो कि उके मोर तरफ लग जउन मिले हबै, ऊ तुमही उहै गुठेही। ");
INSERT INTO bhu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“चुटु टेम बाद तुम मोके नेहको देखिहा अउ फेर चुटु टेम बाद मोके देखिहा।” ");
INSERT INTO bhu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","हइ बात सुनके यीसु के कुछ चेला अपन हे कथै, “ऊ हमर लग का कथै कि, चुटु टेम बाद तुम मोके नेहको देखिहा अउ फेर चुटु टेम बाद मोके देखिहा? अउ इहो कि मै बाफ के लिघ्घो जथो? एखर का मतलब हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","चेला कथै, “ऊ जउन चुटु टेम कथै, एखर काहिन मतलब हबै? हम ओखर बात नेहको समझ पउत हबन।” ");
INSERT INTO bhu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","यीसु हइ जानथै कि उन मोर लग कुछु पूछै चाहथै, यीसु उनखर लग कथै, “का तुम अपन हे मोर हइ बात के बारे हे पूछै के चाहथा, कि चुटु टेम बाद मोके तुम नेहको देखिहा अउ फेर चुटु टेम बाद मोके देखिहा?” ");
INSERT INTO bhu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","मै तुम्हर लग सही-सही कथो, कि रोइहा अउ छाती पिटिहा, पय दुनिया खुसी मनइ, तुम दुखी हुइहा, पय तुम्हर दुख खुसी हे बदल जही। ");
INSERT INTO bhu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","पीरा के टेम आमै लग डउकी के दुख होथै, काखे ओखर टेम आय गय हबै, पय जब लरका पइदा करै के बाद ऊ अपन दुख के बिसर जथै, काखे उके खुसी होथै कि दुनिया हे अक्ठी मनसे के जनम होय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","उहै मेर तुम अबे दुखी हबा, पय मै तुम्हर लग फेरै दुइबारा मिलहुं, जेखर लग तुम्हर मन खुसी होही अउ तुम्हर खुसी तुम्हर लग कउनो नेहको छंडाय पइहिन। ");
INSERT INTO bhu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ऊ रोज तुम मोर लग कुछु नेहको पुछिहा मै तुम्हर लग सही-सही कथो, अगर तुम मोर नाम लग बाफ लग जउन कुछु मंगिहा ता ऊ तुमही देही। ");
INSERT INTO bhu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","अबे तक तुम मोर नाम लग कुछु नेहको मांगे हबा, मंगिहा ता पइहा, जेखर लग तुम्हर खुसी पूर हुइ जाय। ");
INSERT INTO bhu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","हइ टेम मै हइ सब बात तुमही किस्सा हे गुठे हव, पय ऊ टेम आउत हबै, जब मै बाफ के बारे हे किस्सन हे नेहको, पय साफ सब्द हे तुमही गुठेहूं। ");
INSERT INTO bhu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ऊ रोज तुम मोर नाम हे बाफ लग मंगिहा, मै हइ नेहको कथो कि मोहिन के तुम्हर तरफ लग बाफ लग बिनती करैका पडही। ");
INSERT INTO bhu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","बाफ तो खुदय तुमही माया करथै, काखे तुम मोर लग माया करथा अउ तुम हइ बिस्वास करे हबा कि मै बाफ कर तरफ लग आय हबो। ");
INSERT INTO bhu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","मै बाफ लग निकड के दुनिया हे आय हव, अब मै फेरै दुनिया के छांड के बाफ के लिघ्घो जथो। ");
INSERT INTO bhu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","तब चेला कथै, “हां, अब तै किस्सा हे नेहको कथस, बलुक साफ सब्द लग समझाथस। ");
INSERT INTO bhu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","अब हम समझ गय हबन कि तै सगलू कुछु जानथस अउ हइ जरूरी नेहको हबै कि कउ तोर लग कुछु पूछै, इहैनिता हम बिस्वास करथन कि तै भगवान कर तरफ लग आय हबस।” ");
INSERT INTO bhu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","हइ सुनके यीसु उनखर लग कथै, “का तुम अब बिस्वास करथा? ");
INSERT INTO bhu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","देखा, ऊ टेम आउत हबै, बलुक आय गय हबै, जब तुम इछो-उछो हुइ जइहा अउ मोके अकेले छांडके तुम सब अपन-अपन रास्ता चुन लइहा, तउभरमा मै अकेले नेहको हबो, काखे बाफ मोर संग हबै। ");
INSERT INTO bhu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","मै तुम्हर लग हइ सब इहैनिता कहे हव, कि तुम मोर हे सान्ति पाय सका, दुनिया हे तुमही दुख सहै का पडही, पय हिम्मत धरा, मै दुनिया के जीत लय हव।” ");
INSERT INTO bhu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","यीसु हइ सब बात कहे के बाद, अपन आंखी स्वरग के तरफ उठाय के बिनती करथै, हे बाफ, ऊ टेम आय गय हबै, अपन टोरवा के महिमा कर कि टोरवा तोरो महिमा करै। ");
INSERT INTO bhu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","काखे तै ओही सगलू मनसेन के उप्पर हक दय हबस, कि ऊ सगलू सबरोज कर जीवन दे, जेही तै सउपे हबस। ");
INSERT INTO bhu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","उन तोही, जउन अक्ठिन सही भगवान के अउ यीसु मसीह के, जेही तै पठोय हबस, जान लेय, कि इहै सबरोज कर जीवन हबै। ");
INSERT INTO bhu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","जउन काम तै मोके करै के दय रथस, ओही पूर करके मै भुंइ हे तोर महिमा करै हव। ");
INSERT INTO bhu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","इहैनिता बाफ तै मोके अपन संग उहै महिमा लग महिमा कर, जउन महिमा मोर तोर संग दुनिया के बनै लग पहिलेन रथै। ");
INSERT INTO bhu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","तै जउन मनसेन के दुनिया मसे चुनके मोके सउपे हबस, उनखर हे मै तोर नाम परगट करे हव, उन तोर रथै, अउ तै उनही मोके सउपे हबस अउ उन तोर बचन के पालन करे हबै। ");
INSERT INTO bhu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","अब उन जान गय हबै, कि जउन कुछु तै मोके दय हबस, ऊ सगलू तोर पल्ला लग हबै। ");
INSERT INTO bhu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","काखे जउन बचन तै मोके दय, मै उनही दइ दय हव, उन उके स्वीकार करे हबै, सही हे जान गय हबै, कि मै तोर पल्ला लग आय हव, अउ बिस्वास कर लय हबै, कि तहिन मोके पठोय हबस। ");
INSERT INTO bhu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","मै उनखर निता बिनती करथो, मै दुनिया के निता बिनती नेहको करथो, पय उनखर निता जिनही तै मोके सउपे हबस, काखे उन तोर हबै। ");
INSERT INTO bhu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","जउन कुछु मोर हबै, ऊ सगलू तोर हबै, अउ जउन तोर हबै ऊ मोर हबै, मै उनखर हे महिमा परगट करे हव। ");
INSERT INTO bhu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","अब मै दुनिया हे नेहको रइहों, मै तोर लिघ्घो आउथो, पय उन सब दुनिया हे हबै, हे पवितर बाफ उनही अपन ऊ नाम हे, जउन तै मोके दय हबस, उनखर मदद कर कि उन अक्ठी हुइ जाय, जसना हम अक्ठी हबन। ");
INSERT INTO bhu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","जब मै उनखर संग रहों, मै उनही तोर ऊ नाम हे, जउन तै मोके दय रथस, उनही बचायों, मै उनखर रक्छा करे हव, उनखर मसे कउनो नास नेहको होय हबै, सिबाय बिनास के टोरवा के छांडके, उहो इहैनिता कि पवितर किताब कर बचन पूर होय। ");
INSERT INTO bhu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","अब मै तोर लिघ्घो आउथो, जब तक मै दुनिया हे हव, हइ सगलू बात कथो, जेखर लग उन मोर खुसी लग भरपूर हुइ जाय। ");
INSERT INTO bhu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","मै तोर बात के उनखर लिघ्घो पहुंचाय दय हव, दुनिया उनखर लग बैर करिस, काखे जउन मेर मै दुनिया के नेहको हव, उहै मेर उनो दुनिया कर नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","मै हइ बिनती नेहको करथो कि तै उनही दुनिया लग उठाय ले, बलुक हइ कि तै उनही भुतवा लग बचाय रखिहे। ");
INSERT INTO bhu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","उन हइ दुनिया कर नेहको हबै, जउन मेर मै हइ दुनिया के नेहको हव। ");
INSERT INTO bhu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","तै सत्य लग उनही सुध्द कर, तोर बचन सत्य हबै। ");
INSERT INTO bhu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","जउन मेर तै मोके दुनिया हे पठोय हबस, उहै मेर महुं उनही दुनिया हे पठोय हव। ");
INSERT INTO bhu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","उनखर निता मै खुद के सउपथो, ताकि उनो सच्चाई हे सउपरर जाय। ");
INSERT INTO bhu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","मै न केबल उनखर निता बिनती करथो, बलुक उनखरो निता जउन ओखर बचन सुन के मोर हे बिस्वास करही। ");
INSERT INTO bhu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","बाफ, उन सब अक्ठी होय, जउन मेर तै मोर हे हबस अउ मै तोर हे, उहै मेर उनो हमर हे अक्ठी होय, जेखर लग दुनिया हइ बिस्वास करै कि तै मोके पठोय हबस। ");
INSERT INTO bhu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","तै मोके जउन महिमा दय रथस, ओही मै उनही दइ दय हव, कि जसना हम अक्ठी हबन, ओसनेन उनो अक्ठी होय। ");
INSERT INTO bhu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","मै उनखर हे अउ तै मोर हे, जेखर लग उन पूरी तरह लग अक्ठी हुइ जाय अउ दुनिया हइ जान लेय कि तै मोके पठोय हबस अउ जउन मेर तै मोर लग माया करे, उहै मेर उनखरो लग माया करे हबस। ");
INSERT INTO bhu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","हे बाफ, मै चाहथो कि जिनही तै मोके सउपे हबस, मोर संग उहै छो रहै जछो मै हव, जेखर लग उन मोर महिमा के देख सकै, जउन तै मोके दय हबस, काखे दुनिया बनै के पहिलेन लग तै मोर लग माया करे हबस। ");
INSERT INTO bhu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","नियाव करे बाले बाफ, दुनिया तो तोके नेहको चीनिन, पय मै तोके चिन्है हव, उनही पता हुइ गय हबै, कि तै मोके पठोय हबस। ");
INSERT INTO bhu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","मै उनही तोर नाम गुठे हव अउ गुठेवत रइहों, जेखर लग तै जउन माया मोके दय, ऊ माया उनखर हे बने रहै अउ महुं उनखर हे बने रहों। ");
INSERT INTO bhu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","यीसु हइ बात कहिके बाद अपन चेलन के संग किद्रोन घाटी के ऊ पार गइन, उछो अक्ठी बगइचा रथै, जेहमा यीसु अउ ओखर चेला गइन। ");
INSERT INTO bhu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","यीसु के पकडोय बाले यहूदा ऊ जिघा के जानथै, काखे यीसु अपन चेलन के संग उछो जाय करत रहिन। ");
INSERT INTO bhu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","इहैनिता यहूदा, सिपाही, पंडित अउ फरीसिन के संग उछो पहुंच जथै अउ उनखर लिघ्घो मसाले, चिमनी अउ हथियार रथै। ");
INSERT INTO bhu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","यीसु जान जथै कि ओखर संग काहिन-काहिन होय बाले हबै, ऊ आगू बढिस अउ उनखर लग कथै, “केही खोजथा?” ");
INSERT INTO bhu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","उन कथै, “यीसु नासरी के।” यीसु उनखर लग कथै, “मै उहै आंव, उछो बिस्वासघात करे बाले,” यहूदा उनखर संग ठाढ रथै। ");
INSERT INTO bhu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","जब यीसु उनखर लग कथै, “मै उहै आंव” ता उन पाछू हटके भुंइ हे गिर पडथै। ");
INSERT INTO bhu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","यीसु फेरै उनखर लग पूछथै, “तुम केही खोजथा?” उन बोलथै, “यीसु नासरी के।” ");
INSERT INTO bhu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","यीसु उनही जबाब देथै, “मै तुम्हर लग कहि चुके हव, कि हे आंव, अगर मोके खोजत हबा ता इनही जाय देया।” ");
INSERT INTO bhu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","हइ इहैनिता होथै कि यीसु के बचन पूर हुइ जाय, “जिनही तै मोके दय हबस, उनखर मसे मै अकोठेन नास नेहको होमै दयों।” ");
INSERT INTO bhu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","समोन पतरस के लिघ्घो अक्ठी तलबार रथै, ऊ खीचिस अउ पंडित के हरवाह के मारथै, ओखर दहिना पल्ला के कान काट देथै, ऊ सेबक के नाम मलखुस रथै। ");
INSERT INTO bhu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","तब यीसु पतरस लग कथै, “अपन तलबार अपन लिघ्घो धर, जउन खोरिया बाफ मोके दय हबै, का मै ओही नेहको पियों?” ");
INSERT INTO bhu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","तब सिपाहिन के दल अउ सेना अधिकारी अउ यहूदी साहब यीसु के पकडके बांध लइन। ");
INSERT INTO bhu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","उन पहिले यीसु के हन्ना पंडित के लिघ्घो लइ जथै, काखे ऊ साल के पंडित कैफा कर ससुर रथै। ");
INSERT INTO bhu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","हइ उहै कैफा रथै, जउन यहूदी नेता के सलाह दय रथै, निहका इहै हबै कि हमर निता अक्ठी डउका मरै। ");
INSERT INTO bhu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","समोन पतरस अउ अक्ठी दूसर चेला यीसु के पाछू-पाछू कढ गइन, हइ चेला पुजारी लग चिन्हारी रथै, इहैनिता ऊ यीसु संग पुजारी के अंगना हे कढ गइन। ");
INSERT INTO bhu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","पय पतरस बाहिर दूरा हे ठाढ रथै, तब ऊ दूसर चेला जउन पंडित के चिन्हारी के रथै, बाहिर निकडिस अउ चउकीदार लग कहिके पतरस के भित्तर छो लइ आनथै। ");
INSERT INTO bhu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ऊ डउकी जउन दूरा चउकीदार रथै, पतरस लग कथै, “कहुं तहु तो ऊ मनसे के चेला मसे तो नेहको हबस?” पतरस ओखर लग कथै, “मै नेहको हबो।” ");
INSERT INTO bhu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","जाड के कारन हरवाह अउ सिपाही कोइला के आगी जलाय रथै अउ ठाढ हुइके आगी तापत रथै अउ पतरसो उनखर संग आगी तापथै। ");
INSERT INTO bhu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","पुजारी हन्ना यीसु लग ओखर चेला के बारे हे अउ ओखर सिक्छा के बारे हे जांच पडताल करथै। ");
INSERT INTO bhu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","यीसु कथै, “मै दुनिया कर आगू खुलके बात करे हव, मै मंडली अउ बिनती भवन हे जछो सगलू यहूदी अकजुट होय करथै, सबरोज सिक्छा दयों, मै गुप्त रूप लग कुछु नेहको कहे हव। ");
INSERT INTO bhu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","तै मोर लग काखे जांच पडताल करथस? उनखर लग पूछ, जउन मोर सिक्छा सुने हबै, उन जानथै कि मै काहिन-काहिन कहे हव।” ");
INSERT INTO bhu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","हइ बात सुनतै उहां ठाढ अक्ठी सिपाही यीसु के अक चउथेरा मार के कथै, “का पंडित के जबाब देयका तोर इहै तरीका हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","यीसु ओखर लग कथै, “अगर मोर कहैका गलत हबै, ता ऊ बुराई के गवाही देया, अगर मै जउन कहे हव, ऊ सही हबै, ता फेर तुम मोके काखे मारथस?” ");
INSERT INTO bhu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","एखर बाद हन्ना यीसु के बंधे हाथ कैफा परधान पंडित के लिघ्घो पठोय देथै। ");
INSERT INTO bhu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","समोन पतरस ऊ टेम ठाढ हुइ के आगी तापत रहिस, कुछ मनसे ओखर लग कथै, “कहुं तै ओखर चेला मसे तो नेहको हबस?” ऊ मना करके कथै, “मै नेहको आंव।” ");
INSERT INTO bhu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","पंडित के अक्ठी हरवाह ऊ मनसे के रिस्तेदार रथै, जेखर कान पतरस काट दय रथै, ऊ पूछथै, “का मै तोके ओखर संग बगइचा हे नेहको देखे रथो?” ");
INSERT INTO bhu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पतरस फेरै मना कर देथै अउ उहै टेम कुकडी बांस देथै। ");
INSERT INTO bhu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","तब उन यीसु के कैफा के लिघ्घो राजभवन छो लइ जथै अउ मुरगोसा के टेम रथै, यहूदी नेता राजभवन घर के भित्तर इहैनिता नेहको जथै, कि गैर यहूदिन के मिलन लग असुध्द झइ हुइ जइ, बलुक फसह के खाना खाय सकै। ");
INSERT INTO bhu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","तब पिलातुस बाहिर निकड के उनखर लग मिलिस अउ कथै, “तुम हइ मनसे के उप्पर कउन बात हे दोस लगाथा?” ");
INSERT INTO bhu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","उन ओही जबाब देथै, “अगर हइ मनसे अपराधी नेहको होतै ता हम तोर हाथ हे नेहको साउपथन।” ");
INSERT INTO bhu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पिलातुस उनखर लग कथै, “तुम इही लइ जाय के अपन नियम के जसना एखर नियाव करा।” यहूदी नेता कथै, “हमही हक नेहको हबै कि कउनो के जीव लइ।” ");
INSERT INTO bhu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","हइ इहैनिता हुइस कि यीसु के ऊ बात पूर हुइ जाय, जेखर दवारा हइ इसारा करे रथै कि उनखर मिरतू कउन मेर के होही। ");
INSERT INTO bhu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","तब पिलातुस फेरै राजभवन घर के भित्तर गइस अउ यीसु के बुलाय के ओखर लग पूछथै, “का तै यहूदिन कर राजा हबस?” ");
INSERT INTO bhu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","यीसु जबाब देथै, “का तै हइ बात अपन पल्ला लग कथस? या दूसर मोर बारे हे तोर लग कहै हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातुस कथै, “का मै यहूदी यहों? तोरै बेरादरी के मनसे अउ पंडित तोके मोर हाथ हे सउपे हबै, तै काहिन करे हबस?” ");
INSERT INTO bhu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","यीसु कथै, मोर राज हइ दुनिया के नेहको हबै, “अगर मोर राज हइ दुनिया के होथै, ता मोर सेबक लडतै अउ मै यहूदिन के हाथ हे नेहको सउपे जइतो, पय मोर राज इछो के नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","पिलातुस यीसु लग कथै, “ता, तै राजा हबस?” यीसु जबाब देथै, “तै कथस कि मै राजा आंव, मै इहैनिता पइदा लयो अउ दुनिया हे आय हव कि सही के बारे हे गवाह दो। जउन कउ सही के हबै, ऊ मोर सब्द सुनथै।” ");
INSERT INTO bhu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातुस ओखर लग कथै, “सही काहिन हबै?” हइ कहिके फेरै बाहिर कढ गइस अउ यहूदी नेता के लिघ्घो जायके कथै, मै ओखर भित्तर कउनो दोस नेहको पाथो। ");
INSERT INTO bhu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","पय तुम्हर अक्ठी रीति रिबाज हबै, कि मै फसह के तेउहार के टेम हे तुम्हर निता अक्ठी जेलियर के छंडिहों, तुम काहिन चाहथा कि मै तुम्हर निता यहूदिन कर राजा के छांड दो? ");
INSERT INTO bhu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","तब उन फेरै चिल्लाय के कथै, “एही नेहको, बलुक हमर निता बरअब्बा के छांड दे।” अउ बरअब्बा अक्ठी बदमास रथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","तब पिलातुस यीसु के भित्तर लइ जायके कोडा लगवाथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","सिपाही कांटा बाले पुडरा के मुकुट गुथके ओखर मूंड हे मढाथै अउ ओही भाटा रंग के खुरथा पइजामा ओढाथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","अउ उन अक्ठी-अक्ठी करके ओखर लिघ्घो आयके ओखर मुंह हे झापड मारत कहे लागथै, यहूदिन के राजा कर जय। ");
INSERT INTO bhu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","पिलातुस फेरै राजभवन के बाहिर निकड के मनसेन लग कथै, “देखा, मै ओही तुम्हर आगू फेरै बाहिर लानथो, जेखर लग तुम हइ जान लेया कि मै ओहमा कुछु दोस नेहको पाथो।” ");
INSERT INTO bhu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","तब यीसु कांटा के मुकुट अउ भाटा रंग के खुरथा पइजामा पहिन के बाहिर निकडिस अउ पिलातुस मनसेन लग कथै, “देखा हइ मनसे के।” ");
INSERT INTO bhu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","जब पंडित अउ सिपाही यीसु के देखतै चिल्ला के कथै, “एही क्रूस हे टंगाबा क्रूस हे” पिलातुस उनखर लग कथै, “एही तुमै लइ जा अउ क्रूस हे टंगाबा, मै तो ओहमा कउनो मेर के दोस नेहको पाय हव।” ");
INSERT INTO bhu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदी नेता जबाब देथै, “हमरो अक्ठी नियम हबै, अउ ऊ नियम के जसना हइ मिरतू सजा के काबिल हबै, काखे ऊ खुद के भगवान कर टोरवा मानथै।” ");
INSERT INTO bhu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","जब पिलातुस हइ बात सुनथै, ता अउ बोहत डेराय गइस, ");
INSERT INTO bhu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ऊ फेरै राजभवन घर के भित्तर जायके यीसु लग पूछथै, “तै कछो कर हबस?” पय यीसु ओही कुछु जबाब नेहको देथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","पिलातुस यीसु लग कथै, “तै मोर लग काखे नेहको बोलथस? का तै मोके नेहको जानथस कि तोके छांड देमै के हक हबै अउ तोके क्रूस हे टंगामै के हक हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","यीसु जबाब देथै, “अगर तोके उप्पर लग हक नेहको दय गय होतिस, ता तोर मोर हे कउनो हक नेहको होथै, इहैनिता जउन मोके तोर हाथ हे सउपे हबै, ओखर पाप बोहत हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","हइ बात हे पिलातुस ओही छांड देमै के चाहथै, पय यहूदी नेता चिल्ला-चिल्लाय के कहे लग जथै, “अगर तै एही छांड दइहे, ता तै कैसर के संगी नेहको हबस, जउन खुद के राजा कथै, ऊ कैसर के बिरोध करथै।” ");
INSERT INTO bhu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","हइ बात सुनके पिलातुस यीसु के बाहिर लामै के आदेस दइस, अउ नियाव आसन हे बइठ गइस, जउन ऊ जिघा हे रथै, जेही इब्रानी भासा हे गब्बता मतलब चबुतरा कहे जथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","हइ फसह तेउहार के तइयारी के रोज रथै अउ करीबन दुपहरी के टेम रथै, तब पिलातुस यहूदी नेता लग कथै, “इहै हबै तुम्हर राजा।” ");
INSERT INTO bhu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","हइ बात सुनके उन चिल्लाय उठथै, “एही लइ जा, एही क्रूस हे टंगाबा” पिलातुस उनखर लग कथै, “का मै तुम्हर राजा के क्रूस हे टंगाय दो?” पंडित जबाब देथै, “कैसर के छांड के अउ कउनो राजा नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","तब पिलातुस यीसु के क्रूस हे टंगामै के निता उनखर हाथ सउप देथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","तब यीसु के ऊ जिघा लइ जथै, जउन इब्रानी भासा हे गुलगुता कहाथै, जेखर मतलब हबै खोपडी के जिघा अउ यीसु अपन क्रूस के खुदय उठाथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","उछो उन यीसु अउ ओखर संग दुइठे अउ मनसेन के क्रूस हे टंगाथै, अक्ठी के दहिना पल्ला अउ दूसर के टेटरा पल्ला अउ बीच हे यीसु के। ");
INSERT INTO bhu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पिलातुस अक्ठी दोस चिट्ठी लिखवाय के क्रूस हे लगवाय देथै अउ ओहमा हइ मेर लिखररे रथै, “यीसु नासरी यहूदिन के राजा।” ");
INSERT INTO bhu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","बोहत यहूदिन हइ दोस चिट्ठी पढिन, काखे ऊ जिघा जछो यीसु के क्रूस हे टंगाय रथै, ऊ सहर के लिघ्घो रथै अउ दोस चिट्ठी इब्रानी अउ लातीनी अउ यूनानी भासा हे लिखररे हर रथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","तब यहूदी पंडित पिलातुस लग कथै, यहूदिन के राजा झइ लिख, बलुक ऊ कहे रथै, “मै यहूदिन कर राजा हव।” ");
INSERT INTO bhu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातुस जबाब देथै, “मै जउन लिख दयों, ऊ लिख दयों।” ");
INSERT INTO bhu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","जब सिपाही यीसु के क्रूस हे टंगाय चुकथै, ता ओखर खुरथा पइजामा लइके चार खन्डा करथै अउ खुरथा पइजामा के अपन हे बांट लेथै, पय खुरथा पइजामा बिना सिलरे हर उप्पर लग तरी तक रथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","जब उन अपन हे कथै, हम एही झइ चीरी, पय ऐहमा चिट्ठी डाली कि हइ केही मिलही। हइ इहैनिता होथै कि पवितर किताब हे जउन कहै गय रथै, कि ऊ पूर होय, उन मोर बन्डी हे चिट्ठी डालिन, अउ उन मोर खुरथा पइजामा के बांट लेथै, अउ सिपाही ओसनेन करथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","यीसु के दाय अउ ओखर दाय के बेहन, क्लोपास के डउकी मरियम अउ मरियम मगदलीनी यीसु के क्रूस के लिघ्घो ठाढ रथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","जब यीसु अपन दाय अउ चेला के जेखर लग ऊ माया करथै, अपन लिघ्घो ठाढ देखथै, ता अपन दाय लग कथै, “हे डउकी, देख हइ तोर लरका हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","तब यीसु चेला लग कथै, हइ तोर दाय हबै अउ उहै टेम लग ऊ चेला उके घर लइ गइस। ");
INSERT INTO bhu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","एखर बाद यीसु हइ जानथै कि अब सगलू कुछु पूर हुइ चुके हबै, पवितर किताब हे जउन कहे गय रथै ऊ पूर करै के निता कथै, “मै पियासे हव।” ");
INSERT INTO bhu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","उहां दाखरस के सिरका लग भररे हर अक्ठी बरतन मढरेहर रथै, पय उन सिरका हे डंडा के फुलाय के जूफा हे धरके ओखर मुंह हे लगाथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","जब यीसु दाखरस के सिरका लेथै, ता कथै, पूर हुइस। अउ मूंड तरी करके मर गइस। ");
INSERT INTO bhu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ऊ फसह के तइयारी के रोज रथै, सुस्ताय कर रोज ओखर लोथ के क्रूस हे झइ लटके रहै, काखे सुस्ताय के ऊ रोज बोहत खास रथै, इहैनिता यहूदी पिलातुस लग बिनती करथै, ऊ आदेस दे कि उनखर गोड टोर दय जाय अउ उनखर लोथ उछो लग टरकाय दे जाय। ");
INSERT INTO bhu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","इहैनिता सिपाही आयके यीसु के संग क्रूस हे चढाय हर पहिले मनसे के गोड टोर देथै, फेर दूसरो के। ");
INSERT INTO bhu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","जब यीसु के लिघ्घो आयके देखथै, कि ऊ मर चुके हबै, ता ओखर गोड के नेहको टोरिन। ");
INSERT INTO bhu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","पय अक्ठी सिपाही भाला लग ओखर कोंखी हे गोदथै अउ ओहमा लग हरबी खून अउ पानी निकडथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","जउन हइ देखे हबै, ऊ एखर गवाही दय हबै अउ उनखर गवाही सही हबै अउ ऊ जानथै कि ऊ सही कथै, कि तुमो बिस्वास करा। ");
INSERT INTO bhu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","हइ इहैनिता होथै कि पवितर किताब हे जउन बात कहे गय रथै, ऊ पूर होय, “ओखर अकोठे हाडा नेहको टोरे जाय।” ");
INSERT INTO bhu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","फेर पवितर किताब हे अक्ठी बात अउ लिखररे हबै, जउन मनसे छेदे रथै, ऊ ओखरै पल्ला देखही। ");
INSERT INTO bhu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","एखर बाद अरिमतियाह गांव के यूसुफ नाम अक्ठी मनसे रथै, जउन यहूदी नेता के डर के कारन यीसु के गुप्त चेला रथै, ऊ पिलातुस लग यीसु के लोथ के उतार लइके बिनती करथै, पिलातुस उनखर बिनती के सुन लेथै अउ यूसुफ आयके यीसु कर लोथ के लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","तब नीकुदेमुसो पहुंचथै, जउन पहिले रात के टेम यीसु लग मिलै आय रथै, ऊ करीबन तैतीस किलो गन्धरस अउ महकनी तेल लइ आनथै, ");
INSERT INTO bhu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","तब उन यीसु के लोथ लेथै अउ यहूदी नियम के जसना गाढथै अउ ओही महकनी तेल के संग पिछउरी हे लपेटथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","जिहां यीसु के क्रूस हे टंगाय गय रथै, उछो अक्ठी बगइचा रथै अउ बगइचा हे अक्ठी नबा मरघटी रथै, जेहमा कबहुन कउनो के नेहको गाडे गय रथै। ");
INSERT INTO bhu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","इहैनिता यीसु के चेला ओखर लोथ के उहै मरघटी हे मढाय देथै, काखे ऊ लिघ्घो रथै अउ ऊ यहूदिन के तइयारी के रोज रथै। ");
INSERT INTO bhu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","मरियम मगदलीनी हप्ता के पहिले रोज सुबेन्नेन मरघटी के लिघ्घो पहुंचिस ऊ देखथै, कि मरघटी लग पथरा टरके हर हबै। ");
INSERT INTO bhu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","हइ देखके ऊ दउरत समोन पतरस अउ ऊ दूसर चेला के लिघ्घो आइस, जेही यीसु माया करथै, मरियम ओखर लग कथै, “उन परभु के मरघटी मसे उठाय लइ गय हबै अउ हम नेहको जानथन, कि उन उके कछो धरे हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","पतरस अउ ऊ दूसर चेला मरघटी के पल्ला चल पडिस। ");
INSERT INTO bhu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","उन दुनो संग-संग दउडथै, दूसर चेला पतरस के पाछू छांडके आगू निकर गइस अउ मरघटी हे आगू पहुंचिस। ");
INSERT INTO bhu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ऊ झुक के हइ देखिस कि पिछउरी पडे हर हबै, पय ऊ मरघटी के भित्तर नेहको गइस। ");
INSERT INTO bhu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","समोन पतरस ओखर पाछू पहुंचिस अउ मरघटी के भित्तर गइस ऊ देखथै कि पिछउरी पडे हर हबै। ");
INSERT INTO bhu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","अउ यीसु के मूंड हे जउन साफी बंधे रथै, ऊ कपडा के संग पडे हर नेहको, बलुक दूसर जिघा सोच के अलगे धरे हर हबै। ");
INSERT INTO bhu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","तब दूसर चेला जउन मरघटी हे आगू पहुंचे रथै, भित्तर जथै अउ देखिस अउ बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","काखे उन अब तक पवितर किताब के ऊ लेख नेहको समझ पाथै, जउन मेर यीसु कर मिरतू मसे जिन्दा होय के जरूरी रथै। ");
INSERT INTO bhu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","एखर बाद चेला अपन-अपन घर छो लउट गइन। ");
INSERT INTO bhu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","मरियम मरघटी के लिघ्घो बाहिर रोउत ठाड रथै, ऊ रोउत-रोउत झुक के मरघटी के भित्तर नजर लगाइस। ");
INSERT INTO bhu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","अउ जिहां यीसु के लोथ रखे गय रथै, उहां चरका बन्डी पहिरे हर दुइठे स्वरगदूत मेर बइठे हर देखथै, अक्ठी के सिरहाने अउ दूसर के पैताने, ");
INSERT INTO bhu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","स्वरगदूत मरियम लग कथै, “हे डउकी, तै काखे रोथस?” ऊ जबाब दइस, “उन मोर परभु के उठाय लइ गय हबै अउ मै नेहको जानथो कि उके उन कछो धरे हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ऊ हइ कहिके मुडथै अउ ऊ यीसु के उछो ठाड देखिस, पय ऊ उके चीन्ह नेहको सकिस कि ऊ यीसु हबै। ");
INSERT INTO bhu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","यीसु ओखर लग कथै, “हे डउकी, तै काखे रोथस? तै केही खोजथस?” मरियम उके बगइचा के मालिक समझ के ओखर लग कथै, “हे महोदय, अगर तै ओही उठाय लय हबस, ता मोके गुठे कि ओही कछो धरे हबस अउ मै ओही लइ जहुं।” ");
INSERT INTO bhu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","यीसु ओखर लग कथै, “मरियम।” ऊ मुडके ओखर लग इब्रानी भासा हे कथै, “रब्बूनी।” मतलब, “हे गुरू।” ");
INSERT INTO bhu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","यीसु ओखर लग कथै, “मोके झइ छि काखे मै अब तक बाफ के लिघ्घो उप्पर नेहको गयों, पय मोर भाई के लिघ्घो जाय के उनही कहि दे, कि मै अपन बाफ अउ तुम्हर बाफ अउ अपन भगवान अउ तुम्हर भगवान के लिघ्घो उप्पर जथो।” ");
INSERT INTO bhu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरियम मगदलीनी जाय के चेला के संदेस गुठेथै, “मै परभु के देखे हव अउ ऊ मोर लग बात करे हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","उहै रोज जउन हप्ता के पहिले रोज रथै संझा के टेम रथै, जब चेला यहूदिन के डर के मारे चेला घर के दूरा बन्द करके अक जिघा रथै, तब यीसु उनखर बीच हे आयके ठाढ हुइ जथै अउ यीसु चेलन लग कथै, “तुमके सान्ति मिलै।” ");
INSERT INTO bhu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","अउ हइ कहिके यीसु अपन हाथ कोंखी उनही दिखाइस, तब चेला परभु के देखके खुस होथै। ");
INSERT INTO bhu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","यीसु फेरै उनखर लग कथै, “तुमके सान्ति मिलै, जसना बाफ मोके पठोय हबै ओसनेन मै तुमके पठोथो।” ");
INSERT INTO bhu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","हइ कहिके ऊ उनखर उप्पर फूंकथै अउ उनखर लग कथै, “पवितर आतमा लेया। ");
INSERT INTO bhu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","तुम मनसेन के पाप छमा करिहा, ऊ पाप छमा करे गय हबै अउ जउन मनसेन के पाप छमा नेहको करिहा, ऊ पाप छमा नेहको होही।” ");
INSERT INTO bhu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","जब यीसु आथै, ऊ टेम बाराठे चेला मसे अक्ठी मतलब थोमा जउन दिदमुस कहाथै, उनखर संग नेहको रथै। ");
INSERT INTO bhu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","जब दूसर चेला ओखर लग कहे लागथै, “हम परभु के देखे हबन” तब थोमा उनखर लग कथै, “जब तक मै खिलिया के निसानी ओखर हाथ हे नेहको देख लेहूं अउ खिलिया के जिघा अपन अंगठी नेहको डाल लेहूं अउ ओखर कोंखी हे अपन अंगठी नेहको डाल लेहूं, तब तक मै बिस्वास नेहको करिहों।” ");
INSERT INTO bhu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","आठ रोज के बाद ओखर चेला फेरै घर के भित्तर अकजुट रथै अउ थोमा ओखर संग रथै अउ दूरा बन्द रथै, तब यीसु आइस अउ उनखर बीच हे ठाढ हुइ गइस अउ कथै, “तुमके सान्ति मिलै।” ");
INSERT INTO bhu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","तब यीसु थोमा लग कथै, अपन अंगठी लग मोर हाथ के छिके देख अउ अपन हाथ बढाय के मोर कोंखी हे डाल अउ अबिस्वासी नेहको, बलुक बिस्वासी बन जा। ");
INSERT INTO bhu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","थोमा जबाब देथै, हे परभु, हे परभु मोर भगवान। ");
INSERT INTO bhu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","यीसु ओखर लग कथै, “का तै इहैनिता बिस्वास करे हबस कि तै मोके देखे हबस? धन्य ऊ हबै, जउन बिना देखे बिस्वास करथै।” ");
INSERT INTO bhu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","यीसु बोहत चिन्हा चकित के काम चेलन के दिखाइस, जउन हइ किताब हे नेहको दय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","पय हइ इहैनिता दय गय हबै, कि तुम बिस्वास करा कि यीसु भगवान कर टोरवा मसीह हबै अउ बिस्वास करके ओखर नाम लग जीवन पामै। ");
INSERT INTO bhu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","एखर बाद यीसु खुद के तिबिरियास समुन्दर के लिघ्घो चेलन के आगू परगट होथै अउ हइ मेर होथै। ");
INSERT INTO bhu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","समोन पतरस अउ थोमा जउन दिदमुस कहाथै अउ गलील परदेस के काना सहर नतनएल के रहै बाले रथै अउ जबदी के दुइठे टोरवा अउ यीसु के दुइठे चेला मसे अक जिघा रथै। ");
INSERT INTO bhu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","समोन पतरस उनखर लग कथै, “मै मछडी पकडै जथो।” उनो ओखर लग कथै, “हमु तोर संग चलबो।” उन निकड के नाह जिहाज हे चढथै, पय ऊ रात उनही कुछु नेहको मिलथै। ");
INSERT INTO bhu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","सकरहा यीसु समुन्दर के लिघ्घो आयके ठाढ रथै, तउभरमा चेला नेहको चीनथै कि ऊ यीसु हबै। ");
INSERT INTO bhu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","यीसु उनखर लग कथै, “हे लरिका, का तुम्हर लिघ्घो कुछु खाय के निता मछडी हबै?” उन जबाब देथै, “कुछु नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","यीसु उनखर लग कथै, “नाह जिहाज के दहिना पल्ला जाला डाला, ता तुमही मिलही।” जब उन जाला डालिन अउ एतका मछडी फस गइन कि उन जाला नेहको तीन पाउत रहिन। ");
INSERT INTO bhu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","तब ऊ चेला जेखर लग यीसु माया करथै, पतरस लग कथै, “हइ परभु हबै।” जब समोन पतरस हइ सुनथै कि ऊ परभु हबै, ता ऊ अपन कनिहा हे साफी लपेट लेथै, काखे ऊ कपडा नेहको पहिने रथै अउ दहार हे कूद जथै। ");
INSERT INTO bhu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","दूसर चेला नान हस नाह जिहाज हे मछडी लग भररे हर जाला के तीनत आथै, काखे ऊ समुन्दर के टाठा लग बोहत दुरिहां नेहको रथै, केबल दुइ सव मीटर के दुरिहां हे रथै। ");
INSERT INTO bhu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","जब उन समुन्दर के टाठा हे उतरथै, ता उन कोइला के आगी हे धररे हर मछडी अउ रोटी के देखथै। ");
INSERT INTO bhu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","यीसु उनखर लग कथै, “जउन मछडी तुम अबे पकडे हबा, उन मसे कुछ मछडी लइ आबा।” ");
INSERT INTO bhu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","जब समोन पतरस नाह जिहाज हे चढके जाला के समुन्दर के टाठा हे लइ आनथै, ऊ जाला हे अक सव तिरपन बडका-बडका मछडी रथै अउ एतका मछडी होय लग जाला नेहको फटथै। ");
INSERT INTO bhu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","यीसु उनखर लग कथै, “आबा भोजन कर लेया।” चेलन मसे कउनो के हिम्मत नेहको होथै कि यीसु लग पूछ सकै, कि तै कोन हबस, काखे उन जानथै, कि हइ परभु हबै। ");
INSERT INTO bhu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","यीसु उनही रोटी लइके दइस अउ ओसनेन मछडी के दइस। ");
INSERT INTO bhu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","हइ मेर मरे हर मसे जिन्दा होय के बाद हइ तीसर बार यीसु चेलन के दिखाई देथै। ");
INSERT INTO bhu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","खाना खाय के बाद यीसु समोन पतरस लग कथै, “हे समोन, यूहन्ना कर टोरवा, का तै इनखर लग बढके मोर लग माया करथस?” पतरस ओखर लग कथै, “हां परभु तै तो जानथस, कि मै तोर लग माया करथो।” यीसु ओखर लग कथै, “मोर गेडरा के चरा।” ");
INSERT INTO bhu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","यीसु फेरै दूसर बेर पतरस लग कथै, “हे समोन यूहन्ना के टोरवा, का तै मोर लग माया करथस?” ऊ यीसु लग कथै, “हां परभु तै जानथस कि मै तोर लग माया करथो।” यीसु ओखर लग कथै, “मोर गेडरा के देखरेख कर।” ");
INSERT INTO bhu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","यीसु फेर तीसर बेर ओखर लग कथै, “हे समोन यूहन्ना कर टोरवा का तै मोर लग माया करथस?” हइ सुनके पतरस गुस्सा होथै, कि ऊ तीसर बार असना पूछथै, “का तै मोर लग माया करथस?” पतरस यीसु लग कथै, “हे परभु, तै तो मन के बात जानथस, तै हइ जानथस कि मै तोर लग माया करथो।” यीसु ओखर लग कथै, “मोर गेडरन के चरा।” ");
INSERT INTO bhu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","मै तुम्हर लग सही-सही कथो, जब तुम जबान रइहा, तब तुम खुद अपन कनिहा हे साफी बांध के जछो चाहथस, उछो घूमत-बागत रहा, पय जब डोकरइहा तब तुम अपन हाथ फइलइहा अउ दूसर मनसे तुम्हर कनिहा बांध के तुमही उछो लइ जइही, जछो तुम जाय के निता नेहको चइहा। ");
INSERT INTO bhu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","इन बातन के दवारा हइ इसारा देथै, कि पतरस कउन मेर के मिरतू लग भगवान कर महिमा करही, तब यीसु पतरस लग कथै, “मोर पाछू हुइ ले।” ");
INSERT INTO bhu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पतरस मुडके उन चेलन के पाछू-पाछू आउत देखथै, जेखर लग यीसु माया करथै, जउन अखमीरी रोटी के खाना के टेम ओखर लिघ्घो बइठे रथै, जउन पूछथै, “हे परभु, तोर पकडोय बाले कोन हबै?” ");
INSERT INTO bhu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","पतरस उनही देखके यीसु लग कथै, “हे परभु, एखर का होही?” ");
INSERT INTO bhu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","यीसु उनखर लग कथै, “अगर मै चइहो कि ऊ मोर आमै तक रुके रहै ता तोके एखर लग का? तुम तो मोर पाछू चला।” ");
INSERT INTO bhu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","हइ बात भाइयन के बीच फइल गइस कि ऊ चेला नेहको मरही। पय यीसु ओखर लग हइ नेहको कथै कि ऊ नेहको मरही बलुक हइ कि “अगर मै चइहो कि ऊ मोर आमै तक रहै, ता तुमही एखर लग का?” ");
INSERT INTO bhu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","हइ उहै चेला हबै, जउन हइ बातन के गवाही देथै अउ जउन हइ बातन के लिखे हबै अउ हम जानथन कि ओखर गवाही सही हबै। ");
INSERT INTO bhu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","यीसु बोहत चकित के काम करे हबै, अगर अक्ठी-अक्ठी करके ओखर बारे हे लिखे जाय, ता मै सोचतों, कि पवितर किताब हे जउन लिखे जथै, ऊ दुनिया भर हे नेहको समा पउतै।");
INSERT INTO bhu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","हे पिरिया थियुफिलुस, मै अपन पहिली किताब उन सगलू बातन कर बारे हे लिखे हव, जिनके सुरु लग यीसु करिस अउ सिखाइस। ");
INSERT INTO bhu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ऊ उस रोज तक पवितर आतमा के दवारा अपन चुने हर चेलन के आदेस दय जाय के बाद उके स्वरग छो उठाय नेहको लय गइस। ");
INSERT INTO bhu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","यीसु अपन मिरतू कर बाद ऊ अपन खुद के बोहत लग मजबूत सबूत कर संग उनखर आगू परगट करिस कि ऊ जिन्दा हबै, ऊ चालीस रोज तक उनही दिखाई देत रथै अउ उनखर लग भगवान कर राज के बारे हे बात करथै। ");
INSERT INTO bhu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","यीसु चेलन के संग भोजन करत टेम उनही आदेस दइस, कि उन “यरुसलेम नगर झइ छांडै बलुक बाफ जउन टीमा करे हबै, ओही ओरगत रहा ऊ कथै, मै तुमही ऊ टीमा कर बारे हे गुठे दय हबो। ");
INSERT INTO bhu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","यीसु कथै, यूहन्ना पानी हे बतिस्मा दय रथै, पय कुछ रोज के बाद तुमही पवितर आतमा लग बतिस्मा दय जही।” ");
INSERT INTO bhu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","जब चेला यीसु के संग अक जिघा रथै, तब उन हइ सबाल करथै, “परभु का तै हइ टेम इस्राएल के राज फेरै स्थापित करही?” ");
INSERT INTO bhu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","यीसु जबाब दइस, “बाफ जउन काल अउ निस्चित टेम अपन खास हक हे धरे हबै, उनही जानै के तुम्हर काम नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","पय पवितर आतमा तुम्हर हे उतरी अउ तुमही बल देही अउ तुम यरुसलेम छो, सगलू यहूदिया अउ सामरिया परदेसन हे अउ भुंइ के आखरी छोर तक मोर गवाह हुइहा।” ");
INSERT INTO bhu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","एतका कहै के बाद यीसु उनखर देखत-देखत उप्पर उठाय लय गइस अउ अक्ठी बादर उन चेलन के आंखी के अंधियार कर दइस। ");
INSERT INTO bhu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ओखर जात टेम जब ऊ बादर कर पल्ला निहारत रथै, ता देखथै, दुइठे डउका चरका खुरथा पइजामा पहिरे हर, उनखर लिघ्घो आयके ठाढ होथै। ");
INSERT INTO bhu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","अउ उनखर लग कथै, “हे गलीली मनसे, तुम काखे ठाढ हुइके बादर के पल्ला निहारथा? इहै यीसु, जउन तुम्हर लिघ्घो लग स्वरग हे उठाय लय गय हबै, जउन मेर लग तुम उके स्वरग छो जात देखे हबा, उहै मेर लग फेरै लउटाही।” ");
INSERT INTO bhu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","फेर चेला जैतून नाम डोंगर लग जउन यरुसलेम लग करीबन अक कोस के दुरिहां हे हबै, यरुसलेम छो लउट आथै। ");
INSERT INTO bhu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","जब ऊ यरुसलेम सहर हे पहुंचिन तब उप्पर बाले पटउंहा हे गइन, जछो पतरस, यूहन्ना अउ याकूब अउ अन्द्रियास अउ फिलिप्पुस अउ थोमा अउ बरतुल्मै अउ मत्ती अउ हलफई कर टोरवा याकूब अउ समोन जेलोतेस अउ याकूब कर टोरवा यहूदा जिहां उन रुके रथै। ");
INSERT INTO bhu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","उनखर संग कुछ डउकी अउ यीसु कर दाय मरियम अउ ओखर भाई रथै, हइ सगलू खुदय के अक संग हुइके बिनती हे लगे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","कुछ रोज बाद पतरस बिस्वासी भाई के आराधनालय हे अक सव बीस मनसेन के संख्या करीबन रथै, पतरस ठाढ हुइके कहै लगिस। ");
INSERT INTO bhu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“हे भाइयो,” जरूरी रहिस कि पवितर किताब के ऊ आगू कर बात पूर हुइ जाय, जउन पवितर आतमा दाऊद के मुंह लग यहूदा कर बारे हे करे रथै, यहूदा तो यीसु के पकरवामै बाले कर मुखिया बन गइस। ");
INSERT INTO bhu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","यहूदा हमर समूह के सदस्य रथै अउ सेबा हे ओखरो हाथ रथै। ");
INSERT INTO bhu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ऊ अपन बेकार कमाई लग अक्ठी खेत खरीदथै अउ ऊ मुन्डी के भार गिरथै अउ ओखर लादा फट जथै अउ ओखर सगलू आंटी पोटा बाहिर निकड आइस। ");
INSERT INTO bhu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","सगलू यरुसलेम के रहैबाले के पता चल जथै, इहैनिता उनखर भासा हे ऊ खेत के हकलदमा कथै, जेखर मतलब हबै, खून कर खेत। ");
INSERT INTO bhu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","काखे भजन संहिता कर किताब हे लिखररे हबै, कि ओखर घर उजड जाय अउ ओहमा कउ झइ रहै, ओहमा असना लिखवरे हबै, ओखर सेबा के जिघा कउ अउ के मिलै। ");
INSERT INTO bhu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","इहैनिता जरूरी हबै कि जेतका टेम तक परभु यीसु हमर बीच आउत जात रहै। ");
INSERT INTO bhu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","मतलब यूहन्ना कर बतिस्मा लग लइके परभु के स्वरग छो जाय के रोज तक जउन मनसे बरोबर हमर संग रथै, उन मसे अक्ठी हमर संग परभु के फेरै जिन्दा होयके गवाह बनै। ");
INSERT INTO bhu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","एखर बाद उन दुइठे मनसे के हाजिर करथै, यूसुफ के जउन बरसबा कहाथै अउ जेखर उपनाम यूसतुस रथै अउ मत्तियाह कर। ");
INSERT INTO bhu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","तब उन हइमेर बिनती करिस, “परभु तै सबके हिरदय जानथस, हइ परगट कर कि तै इन दुनो मसे केही चुने हबस, ");
INSERT INTO bhu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ताकि ऊ उस सेबा अउ चेला पदवी के जिघा ग्रहन करे, जेखर लग पतित होय कि यहूदा अपन जिघा के कढ गइस।” ");
INSERT INTO bhu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ऊ उन दुनो के निता चिट्ठी डालिस, चिट्ठी मत्तियाह कर नाम निकरिस अउ उन ग्यारह चेलन के संग सामिल कर लय गइस। ");
INSERT INTO bhu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","जब आठै खाय के यहूदी तेउहार के पचासमा रोज आथै, ता सगलू चेला अक जिघा जुडथै, ");
INSERT INTO bhu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ता अचनकै बडी बडेरा के जसना आरो बादर लग सुनाई दइस अउ सगलू घर जिहां उन बइठे हर रथै, गूंज उठिस। ");
INSERT INTO bhu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","अउ आगी के धांग के जसना फइलत अउ जीभ उहां फटत दिखाई देय लगथै, ऊ आगी के अलगे-अलगे जीभ हर अक झन के उप्पर आय ठहरिस। ");
INSERT INTO bhu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","उन सगलू पवितर आतमा लग भरपूर हुइ गइन अउ जउन आरो के बरदान पवितर आतमा उनही दइस, ओखर जसना कइन मेर भासा हे बोलै लगिन। ");
INSERT INTO bhu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","बादर के तरी रहै बाले उन यरुसलेम हे दुनिया कर सगलू देसन लग आय हर यहूदी रहे करथै। ");
INSERT INTO bhu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","जब हइ आरो गरजथै, तब अक्ठी बडी भीड अक जिघा हुइ गइस, ऊ चकराय गइस काखे बिस्वास करै बाले भाइन के उन अपन खुदय के भासा बोलत सुनथै। ");
INSERT INTO bhu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ऊ सगलू अचम्भित हुइके गुठेमै लग जथै, देखा, हइ जउन बोलथै का सगलू गलीली परान्त के नेहको? ");
INSERT INTO bhu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","फेर हमर लग हर अक झन हमर अपन बोली भासा हे बोलत कसना सुनथन? ");
INSERT INTO bhu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","हम पारथी, मेदी, एलामी, मेसोपोटामिया कर निबासी, यहूदिया अउ कप्पदूकिया, पुन्तुस अउ आसिया, ");
INSERT INTO bhu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फ्रूगिया, पंफूलिया, मिस्र अउ लीबिया देस जउन कुरेने के अगल-बगल हबै, इन सब परदेसन के मनसे रोम लग आय हर यातरी जेहमा पइदाइसी रोमी रथै। ");
INSERT INTO bhu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","अउ यहूदी अच्छी धारन करैबाले मनसे क्रेती अउ “अरब कर रहैबाले हम सबझन भगवान कर चकित के काम के अपन-अपन भासा हे सुनथन” ");
INSERT INTO bhu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","उन सब मनसे चकित अउ सक हे पड जथै अउ अक दूसर लग पूछै लग जथै कि “हइ सब काहिन बात हबै?” ");
INSERT INTO bhu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","पय दूसर मनसे चेलन के मजाक उडाउत कथै, “इन सबझन बोहत दारू पी हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","फेर उन ग्यारह झन के संग पतरस ठाढ होथै अउ ऊंच आरो लग मनसेन के सम्बोधन करत कथै, हे यहूदी संगी अउ यरुसलेम के सगलू संगी मोर बात के धियान सुना अउ मोके हइ बात के मतलब गुठेमै देया। ");
INSERT INTO bhu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ऊ मनसे नसा हे नेहको हमै, जसना तुम समझथा काखे अबे तो सकरहा कर नव बजे हबै। ");
INSERT INTO bhu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","पय ऊ बात हबै, जेखर बारे हे योएल नबी ग्यानी मनसे के दवारा गुठे रथै, ");
INSERT INTO bhu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","भगवान हइ कथै, कि मै आखरी के रोज, हे सगलू मनसे हे अपन आतमा दइहों, ता तुम्हर टोरवा टोरिया आगू कर बात गुठेही, अउ तुम्हर जबान दरसन देखही, अउ तुम्हर सियान सपना देखही। ");
INSERT INTO bhu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","उन रोज हे अपन हरवाह, अउ हरवाहिन हे अपन आतमा दइहों, अउ उन आगू कर बात गुठेही। ");
INSERT INTO bhu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","अउ मै उप्पर बादर हे चकित कर काम, अउ तरी भुंइ हे चिन्हा मतलब खून, आगी अउ कुहिटा कर बादर दिखाहुं। ");
INSERT INTO bhu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","बेरा अंधियार, अउ जोधइया खून कर जसना ललका हुइ जही, परभु के महान अउ महिमा आमै के आगू लग। ");
INSERT INTO bhu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","जउन कउ परभु कर नाम लेही उके परभु बचाही। ");
INSERT INTO bhu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“हे इस्राएली भाई, मोर बातन के धियान लग सुना, भगवान यीसु नासरी के दवारा तुम्हर बीच केतका चकित के काम करे हबै अउ चिन्हा दय हबै, जउन भगवान तुम्हर बीच ओखर दवारा करके दिखाय हबै, एखर लग साबित होथै कि ऊ भगवान के तरफ लग आय हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ऊ यीसु के भगवान सही योजना अउ निस्चित ग्यान के जसना तुमही धराय गय हबै अउ तुम पापी मनसेन के सहयोग लग उके क्रूस हे टंगाय के मार डाला। ");
INSERT INTO bhu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","पय भगवान उके मरै के पीरा लग छंडाइस अउ फेरै लग जियाइस, मिरतू हे एतका सक्ति नेहको रथै, कि उके बन्दी बनाय के रखै। ");
INSERT INTO bhu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","काखे कि दाऊद ओखर बारे हे कथै, मै परभु के सबरोज अपन आंखी हे देखत रहों, काखे कि ऊ मोर दहिना पल्ला हबै, ता मै झइ हिलो। ");
INSERT INTO bhu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","इहैनिता मोर मन मगन हबै, अउ मोर जीभ मगन हबै, मोर देह आसा हे जीय। ");
INSERT INTO bhu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","काखे परान के नरक हे पवितर बिस्वास करैबाले, सेबकन के मरघटी हे सरै नेहको देही। ");
INSERT INTO bhu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","तै मोके जीवन के पल्ला जाय के गली दिखाय हबै, तै मोके अपन दरसन के दवारा मगन लग भर दइहे। ");
INSERT INTO bhu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","हे मोर भाइयो, मै अपन पुरखा दाऊद राजा कर बारे हे तुम्हर लग हिम्मत के संग गुठे सकथों, कि ऊ तो मर गइस अउ गाडे गइस अउ ओखर मरघटी आज तक हमार इहां मउजूद हबै। ");
INSERT INTO bhu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ऊ अक्ठी ग्यानी मनसे रहिस, ऊ जानथै कि भगवान मोर लग किरिया के संग हे उके टीमा दय कि ओखर पुरखन मसे कउनो अकझन के ओखर राजगद्दी हे बइठाही। ");
INSERT INTO bhu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","इहैनिता जउन मसीह के भभिस्य हे घटै बाले हबै, उके देखत दाऊद हइ कथै, “ओहमा मिरतू दुनिया नरक हे नेहको छांडिस, अउ न ओखर देह के मरघटी हे सरै दइ” ");
INSERT INTO bhu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","इहै यीसु कर भगवान जिलाथै, जेखर हम सगलू झन हइ बात के गवाह हबन। ");
INSERT INTO bhu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","भगवान के दहिना हाथ लग ऊंच पदवी पाय के यीसु परम बाफ के टीमा के जसना पवितर आतमा पाइस, फेर ऊ हइ आतमा के हमर हे उडेल दइस, जेही अब तुम देखथा अउ सुनथा। ");
INSERT INTO bhu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","काखे कि दाऊद तो स्वरग हे नेहको गइस पय ऊ खुदय कथै, परभु भगवान मोर परभु लग कथै, मोर दहिना पल्ला बइठे रहा, ");
INSERT INTO bhu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","जब तक कि मै तोर बैरी के तोर गोड तरी के चउकी नेहको बना देहुं। ");
INSERT INTO bhu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","इहैनिता सगलू इस्राएल सही हे जान लेया कि भगवान हइ यीसु के तुम क्रूस हे लटकाय दय रथा, परभु अउ मसीह दुनो ठहराय रथै। ");
INSERT INTO bhu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","मनसे जब हइ सुनथै ता उन चकित होथै पतरस अउ चेलन लग कथै, “हे भाइयो हमके काहिन करै चाही?” ");
INSERT INTO bhu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","तब पतरस उनखर लग कथै, “मन बदला अउ अपन पापन के छमा पामै के निता तुम्हर मसे हरेक झन के यीसु मसीह के नाम लग पानी हे बतिस्मा ले चाही अउ तुमही पवितर आतमा के बरदान मिलही। ");
INSERT INTO bhu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","काखे कि हइ टीमा तुम अउ तुम्हर लरका अउ ऊ सगलू दुरिहां कर मनसे के निता हबै, जिनही परभु हमर भगवान अपन लिघ्घो बुलाय हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पतरस अउ बोहत लग बचन दवारा उनही चेतन्त करथै अउ बिनती के संग उनखर लग कथै, “हइ नास होमै बाले पुरखन लग अपन खुद के बचाय रखिहा।” ");
INSERT INTO bhu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","उनखर मसे बोहत झन ओखर बात के सुनके बिस्वास करिन अउ उनही पानी लग बतिस्मा दइस, हइमेर ऊ रोज उनखर संग करीबन तीन हजार मनसे जुड गइन। ");
INSERT INTO bhu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","अउ बिस्वास करै बालेन के साझा जीवन चेलन लग दिमाक पामै अउ संगति रखै अउ रोटी टोरै अउ बिनती करै हे मगन रथै। ");
INSERT INTO bhu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","चेलन कर दवारा बोहत लग चकित के काम के चिन्हा परगट अउ हर अक्ठी मनसे चकित लग भर गइन। ");
INSERT INTO bhu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","अउ सगलू बिस्वास करैबाले लगेतार संगति हे रथै अउ उनखर लिघ्घो जउन कुछु रथै, उन उके अपनै हे बांटचोंट लेथै। ");
INSERT INTO bhu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","उन अपन धन डेरा अउ चीजन के बेच भांज के अउ ओखर लग मिलै बाले पइसा के हर अकझन के जेखर जसना जरूरत रथै बांट देथै। ");
INSERT INTO bhu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","उन सबरोज बिनती भवन हे अक संग मिलथै, उन अपन घर हे अक संग खाना बांटचोंट के अउ सच्चे मन लग मगन के संग मिलजुल के खाना खथै। ");
INSERT INTO bhu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","सगलू मनसे के अच्छी भावना के मगन लेत भगवान कर भजन करत जउन रोजदिन परभु के दवारा मुकति पाथै, उनखर संग जोड देथै। ");
INSERT INTO bhu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","अक रोज पतरस अउ यूहन्ना दुपहरी के तीन बजे बिनती करै के टेम बिनती भवन छो जथै। ");
INSERT INTO bhu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","कुछ मनसे अक्ठी मनसे के लइ जथै, जउन पइदाइस लग लेंगरा रथै, उन उके रोजदिना लान के बिनती भवन के सुन्दर नाम के दूरा के लिघ्घो छांड देथै, जेखर लग ऊ बिनती भवन के भित्तर जाय बालेन लग भीख मांग सकै। ");
INSERT INTO bhu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","जब ऊ पतरस अउ यूहन्ना के बिनती भवन छो जात देखथै, ता उनखर लग भीख मांगथै। ");
INSERT INTO bhu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","पतरस अउ यूहन्ना उके धियान लग देखथै, पतरस कथै, “हमर पल्ला देख।” ");
INSERT INTO bhu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","मतलब ऊ उनखर लग कुछु पामै के ओरगथै। ");
INSERT INTO bhu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","पय पतरस कथै, “मोर लिघ्घो चांदी अउ सोना तो नेहको हबै, पय जउन कुछु हबै मै तोके देथो, यीसु मसीह नासरी के नाम लग रेंग बाग।” ");
INSERT INTO bhu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","फेर ऊ ओखर दहिना हाथ पकरके उके ठाड करथै ऊ उहै टेम ठाड हुइ जथै अउ इछो उछो रेंगै बागै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ऊ खुसी लग अपन गोड हे ठाड हुइ जथै अउ इछो उछो रेंगै बागै लग जथै, फेर ऊ उनखर संग उछलत कूदत बिनती भवन हे गइस अउ भगवान कर भजन करत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","अउ सगलू मनसे उके रेंगत बागत अउ भगवान कर भजन करत देखथै। ");
INSERT INTO bhu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","मनसे उके चीन्ह लेथै, कि हइ उहै हबै जउन सुन्दर नाम के बिनती भवन हे बइठके भीख मांगे करथै अउ ओखर संग जउन घटना घटिस, उके देखके चकित हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","जब ऊ पतरस अउ यूहन्ना कर संग रथै, इहैनिता सगलू मनसे बोहत चकराय के, सुलेमान नाम के अंगना कहाथै, उनखर लिघ्घो दउरे आथै। ");
INSERT INTO bhu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","हइ देखके पतरस मनसेन लग कथै, “हे इस्राएली भाइयो तुम काखे चकराथा अउ हमार पल्ला काखे आंखी काढ कर देखथा? लागथै कि हमिन अपन सक्ति अउ भक्ति लग हइ मनसे के रेंगै बागै के काबिल बनाय हबन।” ");
INSERT INTO bhu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहम, इसहाक अउ याकूब कर भगवान हमर बाफ दादन के भगवान अपन सेबक यीसु के बडा महिमा परदान करिस, पय तुम उके साहबन के हाथ हे सउप दया अउ पिलातुस के आगू इन्कार करा, जब कि पिलातुस उके छांड देय के निस्चित करथै, ");
INSERT INTO bhu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","तुम ऊ पवितर अउ धरमी मनसे के नकारे हबै, एखर बदला हे पिलातुस लग मांग करै कि तुम्हर निता अक्ठी खून करै बाले के छांड दय जाय। ");
INSERT INTO bhu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","तुम जीवन के गली दिखामै बाले के मार डारे हबा, पय भगवान मरे हर मसे उके फेरै लग जिन्दा कर दइस अउ जेखर गवाह हबन। ");
INSERT INTO bhu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","काखे हम यीसु कर नाम हे बिस्वास करथन, इहैनिता हइ ओखर नाम हबै, जउन हइ लेंगरा मनसे के सक्ति दय हबै, जेही तुम देखथा अउ जानथा जेखर गोड हे बल दय हबै, उहै बिस्वास जउन यीसु लग मिलथै, तुम सबके आगू हइ मनसे के पूरी रीत लग निक्खा करे हबै। ");
INSERT INTO bhu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","अउ हे भाइयो, मै जानथो कि हइ काम तुम अनजाने हे करे हबा, ओसनेन तुम्हर सरदार करे हबै। ");
INSERT INTO bhu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","पय जउन बातन के भगवान ग्यानी मनसे के आगू गुठे दय हबै, कि ओखर मसीह दुख उठाही अउ उनही ऊ इहैमेर लग पूर करथै। ");
INSERT INTO bhu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","इहैनिता मन बदला अउ भगवान के पल्ला लउट आबा तबय तुम्हर पाप के छमा करही। ");
INSERT INTO bhu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ताकि आतमिक बल के टेम परभु भगवान कर पल्ला लग आबै अउ परभु तुम्हर निता मसीह के पठोबै, जेही ऊ तुम्हर निता उके पहिलेन लग चुन के रखे हबै। मतलब यीसु के, ");
INSERT INTO bhu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","जरूरी हबै कि ऊ स्वरग हे ऊ टेम तक रही, जब तक कि हइ सगलू बात पहिलेन जइसन सुधारे नेहको जही, बोहत पहिलेन लग जेखर बारे हे भगवान अपन पवितर ग्यानी मनसेन के दवारा गुठे हबै। ");
INSERT INTO bhu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","मूसा कथै, परभु भगवान तुम्हर भाई निता अपन मनसे मसे अक्ठी ग्यानी मनसे के पठोही अउ जउन कुछु करै के कहि तै उहै करबे। ");
INSERT INTO bhu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","पय जउन कउ मनसे ग्यानी मनसे कर बात नेहको मनही उके भगवान मनसे लग अलग करै अउ नास करे जही। ");
INSERT INTO bhu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","अउ समूएल नबी लग लइके ओखर बाद बाले तक जेतका ग्यानी मनसे बोलथै, हइ रोज के आदेस करे हबै। ");
INSERT INTO bhu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","तुम ग्यानी मनसे के लरका अउ टीमा के हिस्सा हबा, जेही भगवान तुम्हर बाफ दादन के संग करे रथै, जब ऊ अब्राहम लग कथै, तोर पीढी के दवारा दुनिया के सगलू घर भरेन के मनसे आसीस पइहिन। ");
INSERT INTO bhu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“भगवान अपन सेबक के चुनथै, पहिलेन तुम्हर लिघ्घो पठोय दइस, ताकि तुमही तुम्हर सगलू रास्ता लग आसीस देही।” ");
INSERT INTO bhu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","जब ऊ मनसेन लग हइ बात कथै, ता धरमी काम करै बाले अउ बिनती भवन के पुजारी अउ सदूकी उनखर हे चढ आथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ऊ उनखर लग हइ बात हे चिडे रथै कि पतरस अउ यूहन्ना उन मनसेन के सिखाउत रथै, कि यीसु मरे हर मसे जी उठे हबै, इनखर लग हइ साबित करथै कि मरे हर जी उठ सकथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","उन उके बन्दी बनाय लेथै, काखे कि ऊ टेम संझा हुइ चुके रथै, इहैनिता उनके जेल हे रखिन। ");
INSERT INTO bhu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","पय जउन ऊ संदेस सुनिन उनखर मसे बोहत झन ओखर हे बिस्वास करिन अउ हइमेर लग उनखर गिनती करीबन पांच हजार मनसे हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","आने रोज यहूदी कर अगुवा, सरदार अउ नियम के गुरू यरुसलेम हे जुडथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","महाजक हन्ना, कैफा, यूहन्ना, सिकन्दर अउ पुजारिन के घराना के सगलू मनसे पधारथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","उन हइ चेलन के ठाड हुइके पूछै लग जथै, तुम केखर सक्ति अउ केखर नाम लग काम करथस? ");
INSERT INTO bhu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","फेर पवितर आतमा लग भर के पतरस उनखर लग कथै, “हे मनसेन के नेता सरदार सियानन कर नेता। ");
INSERT INTO bhu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","पय आज हमर लग अक्ठी लेंगरा मनसे के संग धरमी काम के बारे हे हइ पूछतांछ करे जथै, कि ऊ निक्खा हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ता तुम सब के अउ इस्राएल के मनसेन के हइ पता होमैके चाही, कि हइ काम यीसु मसीह नासरी कर नाम लग हुइस, जेही तुम क्रूस हे टंगाया अउ जेही भगवान मरे हर मसे फेरै लग जिन्दा कर दइस। उहै के दवारा लग निक्खा हुइस, हइ मनसे तुम्हर आगू ठाड हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","हइ यीसु उहै, पथरा जउन तुम घर बनामै बाले मिसतिरी नकारे रथै, उहै सब लग खास पथरा बन गइस। ");
INSERT INTO bhu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","कउनो दूसर मनसे के दवारा मुकति नेहको हबै काखे स्वरग के तरी मनसेन हे कउ दूसर नाम नेहको दय गय हबै, जेखर दवारा हम मुकति पाय सकि। ");
INSERT INTO bhu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","जब उन पतरस अउ यूहन्ना के हिम्मत देखथै अउ हइ जानथै, कि हइ अनपढ अउ सच्चे मनसे हबै, ता अचम्भित हे पड गइन, फेर उन उनही चीनथै कि हइ यीसु कर संग रह चुके हबै। ");
INSERT INTO bhu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","पय ऊ उस मनसे के जउन निक्खा होय रथै, उनखरै संग ठाड देखथै, इहैनिता उनखर लिघ्घो कहै के निता कुछु नेहको रथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","उनही यहूदी आराधनालय लग निकाडे जाय के कथै अउ फेर ऊ अपनै हे सोच बिचार करै लगथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","पय हइ मनसे कर संग काहिन करी? काखे यरुसलेम नगर के सगलू रहै बालेन हे परगट हबै, कि इनखर दवारा अक्ठी प्रसिध्द चिन्हा देखाय गय हबै, मनसे सोचै लगथै अउ हम इनही मना नेहको कर सकथन। ");
INSERT INTO bhu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","पय हम उनही चेताय दइ इहैनिता कि हइ बात मनसे हे अउ जादा झइ फइल जाय, उनही हइ नाम लग फेर कउनो मनसे लग बात झइ करै। ");
INSERT INTO bhu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ता उनके बुलवाथै अउ धमकी देखके हइ कथै, यीसु के नाम ले कुछु झइ गुठेइहा अउ झइ सिखइहा। ");
INSERT INTO bhu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","पय पतरस अउ यूहन्ना उनही जबाब दइन, “तुमिन नियाव करा कि भगवान के आगू हमर निता हइ जरूरी होही कि भगवान के आदेस न मानके तुम्हर आदेस मानी। ");
INSERT INTO bhu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","हम जउन कुछु देखे अउ सुने हबन, हम उके बताय लग नेहको चूकबो।” ");
INSERT INTO bhu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","फेर उनही ऊ बोहत हडकाय के छांड देथै, काखे उनही सजा देय के कउनो मेर के बहाना नेहको मिलिस, काखे जउन घटना घटे रथै, ओखर निता सगलू मनसे भगवान कर बडाई करथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","अउ जेखर उप्पर हइ निक्खा करै के चिन्हा के काम देखाय गय रथै, ऊ चालीस साल लग जादो रथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","पतरस अउ यूहन्ना के छांड दय गइस, ऊ फेरै लग ऊ मनसे के समूह हे गइन अउ उनखर लग जउन कुछ खास याजक अउ सियान लग कथै, उनही सगलू बात गुठे देथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","पय बिस्वास करै बाले हइ सुनिन ता मिलके बोहत आरो लग भगवान लग बिनती करै लगिन परभु तहिन हबस स्वरग, भुंइ, समुन्दर उनखर भित्तर जउन कुछ हबै, उनही बनाय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","तै अपन पवितर आतमा के दवारा अपन सेबक, हमर पुरखा दाऊद के मुंह लग कहे रथस, उन गैर यहूदी मनसे के पता नेहको काखे अपन घमंड दिखाथै? अउ देस-देस के मनसे बेकार के साजिस बनाइन? ");
INSERT INTO bhu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","परभु अउ ओखर मसीह के बैरी हे भुंइ के राजा ठाड होथै, अउ राज करैबाले सरदार, अकै संग अक जिघा होथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","हेरोदेस अउ पुन्तियुस पिलातुस हइ सहर हे गैर यहूदी अउ इस्राएली के मिलके तोर पवितर सेबक यीसु के बिरोध हे, जेही तै मसीह के सकल हे अभिसेक करे रथै, सही हे अकजुट हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","उन अक जिघा हुइन अउ ताकि तोर सक्ति अउ इक्छा के जसना जउन कुछु पहिलेन लग निहचित रथै, ऊ पूर हुइ सकै। ");
INSERT INTO bhu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","हे परभु उनखर उप्पर धियान दे अउ अपन सेबकन के हइ बरदान दे, कि तोर सब्द बडे हिम्मत लग सुनामै। ");
INSERT INTO bhu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","जब कि तै निक्खा करै के निता तै हाथ बढाय अउ चिन्हा अउ चकित कर काम तोर पवितर सेबक दवारा यीसु कर नाम लग करे जथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","जब ऊ बिनती कर चुकथै, ता ऊ जिघा जिहां ऊ अक जिघा रथै डोल जथै, अउ ऊ सगलू पवितर आतमा लग भर जथै अउ ऊ बिगर डरे भगवान कर बचन सुनामै लगिन। ");
INSERT INTO bhu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","बिस्वास करै बाले कर समूह अक मन रथै, कउ हइ नेहको कहि सकथै, कि ओखर कउनो चीज ओखर आय, उनखर लिघ्घो जउन कुछु होथै, उन अपनै हे बांट लेथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","अउ ऊ चेला सामुहिक सक्ति के संग परभु यीसु फेरै जी उठै के गवाही दय करथै, अउ उन सब हे बडा अनुगरह रथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ऊ समूह मसे कउनो के कउनो मेर के बात लग कमी नेहको रथै, काखे जेखर लिघ्घो खेत, या घर होथै, उनही बेच के जउन पइसा मिलथै ओही लानथै, ");
INSERT INTO bhu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","अउ चेलन के गोड तरी धर देथै अउ जिनही जउन मेर जरुरत होथै अउ मनसेन के जरुरत के जसना उनही दय रथै। ");
INSERT INTO bhu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","अउ यूसुफ नाम के साइप्रस सहर हे पइदा हुइस अउ अक्ठी लेवी रथै, जेही चेला बरनबास कहिके पुकारथै, “मतलब सान्ति कर टोरवा” ");
INSERT INTO bhu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ऊ अक्ठी खेत बेच दइस जेखर ऊ मलिक रथै, अउ ऊ पइसा के लानके चेलन के गोड तरी धर देथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हनन्याह नाम के अक्ठी मनसे अउ ओखर डउकी सफीरा मिलके अपन कुछ डेरा मसे अक्ठी खेत बेचथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","अपन डउकी के जानकारी हे कुछ पइसा अपन लिघ्घो बचाय के रख लेथै अउ कुछ पइसा चेलन के दइ देथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","पतरस उनखर लग कथै, “हे हनन्याह भुतवा तोर मन हे हइ बात काखे डाले हबै, कि तै पवितर आतमा लग झूठ बोले हबस अउ खेत के बेचे हर कुछ पइसा बचाय के रख लय? ");
INSERT INTO bhu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","जब तक तै बेचे नेहको रथस ऊ तोर नेहको रहिस, जब तै उके बेचे ता ओखर लग पइसा मिलिस उहो तोर हक हे रहिस, फेर तै अपन मन हे झूठ बोलय के काखे सोचे? तै मनसे लग झूठ नेहको बोले हबस, पय भगवान लग झूठ बोले हबस।” ");
INSERT INTO bhu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","हनन्याह हइ बात सुन के गिर जथै अउ ओखर परान निकड गइस, जउन कउ हइ बात के सुनिन उनखर हे डर अमा गइस। ");
INSERT INTO bhu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","कुछ जबान उके चरका कफन हे लपेटथै अउ बाहिर छो लइ जाय के गाड देथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","लगभग तीन घंटा के बाद ओखर डउकी भित्तर आथै, हइ घटना के बारे हे कुछु नेहको जानथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","पतरस ओखर लग कथै, मोके बता तै अउ तोर डउका ऊ खेत एतकै हे बेचे रथै, ओखर डउकी कथै, हव एतकै हे बेचे रहन। ");
INSERT INTO bhu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","पतरस ओखर लग कथै, “दोनो झन परभु के आतमा के परिक्छा लेय के निता सहमत हबा, देख तोर डउका के गाडै बाले दूरा हे ठाड हबै अउ उन तहु के उठाय के लइ जही।” ");
INSERT INTO bhu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ऊ उहै टेम पतरस के गोड तरी गिरथै अउ मर जथै, जबान भित्तर आयके उके मरे हर पाथै अउ ऊ बाहिर लइ जाय के ओखर डउका के लिघ्घो गाड देथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","एखर लग सगलू मंडली हे अउ जेतका मनसे हइ बातन के चरचा सुनथै उनखर हे बोहत डर समाय जथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","चेलन के दवारा मनसेन के बीच बोहत लग चिन्हा अउ चकित के काम होथै, उन सब बिस्वास करै बाले सुलेमान के अंगना हे अक जिघा जुडथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ऊ समूह हे सामिल होमै के हिम्मत नेहको कर पाथै, पय मनसे उनखर बडाई करथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","पय परभु हे बिस्वास करै बाले डउका अउ डउकी बोहत बढत जथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","सही हइ हबै कि मनसे अपन नंगहन के लइके खटिया हे गलिन हे सोबाथै, ताकि जब पतरस उछो लग निकडही ता उनखर मसे कुछ हे ओखर छाय पड जाय। ");
INSERT INTO bhu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","यरुसलेम सहर के अगल-बगल के सहरन लग बोहत मनसे अक जिघा हुइ जात रहिन, उन अपन संग नंगहन अउ असुध्द आतमा के सताय हर मनसेन के लानथै अउ सगलू मनसे निक्खा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","हइ सब देख के पुजारी अउ ओखर सगलू संगी, जउन सदूकियन के समूह बोहत जादा जलन लग भर जथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","उन चेलन के पकरके जेल हे बेड देथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","पय ऊ रात के टेम हे परभु के अक्ठी स्वरगदूत जेल के दूरा उघार देथै, उनही बाहिर निकार के कथै, ");
INSERT INTO bhu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","जा बिनती भवन हे ठाड हुइके हइ नबा जीवन के सब बात मनसेन के सुनाबा। ");
INSERT INTO bhu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","उन हइ सुनके बडा सकरहा बिनती भवन हे जाय के सिक्छा देय लगिन, तब पुजारी अउ उनखर संगी उछो पहुंचिन, ता उन यहूदी अगुवा अउ इस्राएल सियानन सगलू पंचायत बुलवाथै अउ चेलन के लामै के निता सिपाहिन के जेल पठोथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","पय जब सिपाही जेल हे पहुंचथै, ता चेलन के जेल हे नेहको पाथै, ता उन लउटके एखर संदेस देथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","जब हम जेल हे पहुंचेन ता हम पायन कि जेल के सुरक्छा के तारा लगे हर रथै अउ दूरा हे पहरेदारन के ठाडे पायन पय दूरा खोलन ता भित्तर हमके कउनो नेहको मिलिन। ");
INSERT INTO bhu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","बिनती भवन के मुखिया के साहबन अउ परधान याजक हइ बात सुनिन, ता इन चकित हुइन कि उन चेलन के काहिन होय होही। ");
INSERT INTO bhu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","एतकै हे कउनो आयके उनही संदेस गुठेथै, “देखा जउन मनसेन के जेल हे बेड दय रहा, उन बिनती भवन हे ठाड हुइ के मनसेन के सिक्छा देथै।” ");
INSERT INTO bhu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","बिनती भवन के सुरक्छा करमी के मुखिया अपन सिपाहिन के संग उछो गइन, बिना बल ताकत के नेहको लानथै, काखे उनही डर रथै कि मनसे कहुं पथरा झइ मारै। ");
INSERT INTO bhu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","उन चेलन के यहूदी महासभा के आगू ठाड करथै, फेर महायाजक उनखर लग पूछथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“का हम तुमही कडाइ लग चेताय नेहको रहन, कि हइ नाम लग सिक्छा झइ दइहा, पय तुम सगलू यरुसलेम अपन सिक्छा लग भर दय हबा अउ हइ मनसे के खून के अरोप हमर उप्पर लादत हबा।” ");
INSERT INTO bhu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","हइ बात हे पतरस अउ दूसर चेला हइ जबाब देथै, “हमही मनसेन के आदेस लग जादा भगवान कर आदेस के मानैके चाही। ");
INSERT INTO bhu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","जेही तुम क्रूस हे खीला ठोकवाय के मार डारे रथा, पय हमर सियानन के भगवान यीसु के फेरै जिन्दा कर दय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","भगवान उके मुख्य अउ मुकतिदाता के सबले ऊंच पद दइके अपन दहिना हाथ छो बइठाय हबै, कि ऊ इस्राएल के मन बदलै अउ पाप छमा करही। ");
INSERT INTO bhu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","इन बात के हम गवाह हबन अउ पवितर आतमा, जेही भगवान उन मनसेन के दय हबै, जउन ओखर आदेस के मानथै।” ");
INSERT INTO bhu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","जब महासभा कर सदस्य हइ सुनथै ता उन बोहत गुस्सा हुइ जथै अउ उन चाहथै कि चेलन के मार डारी। ");
INSERT INTO bhu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","पय उनखर मसे अक्ठी फरीसी जेखर नाम गमलीएल रथै, जउन भला बुरा के गुरू रथै अउ सगलू मनसेन हे आदर के संग पंचायत हे ठाड होथै अउ आदेस देथै कि चेलन के चुटु टेम के निता बाहिर जाय के आदेस दइस। ");
INSERT INTO bhu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","तब पंचायत कर मनसेन लग हइ कथै, हे इस्राएली के मनसे तुम इनखर संग काहिन करै चाहथा, ओही सोच समझ के करिहा। ");
INSERT INTO bhu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","का तुमही सुरता हबै कुछ रोज पहिले अपन खुद बडा कहै बाले अक्ठी थियूदास परगट होय रहिस, लगभग चार सव मनसे ओखर पाछू चलथै, पय मारे गइस अउ ओखर बिस्वासी तितर-बितर हुइ गइन मतलब कुछु नेहको निकडिस। ");
INSERT INTO bhu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","एखर बाद नाम लिखामै कर रोज हे, गलीली सहर के रहै बाले यहूदा रथै, उहो कुछ मनसेन के अपन पाछू कर लेथै, उहो मारे गइस अउ ओखरो बिस्वासी इछो-उछो हुइ गइन। ");
INSERT INTO bhu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","इहैनिता हइ मामला के बारे हे मै तुम्हर लग कथो, इन मनसेन लग दुरिहां रइहा उनखर बारे हे कउ बिरोध झइ करा, उनही अकेल्ले छांड देया, पय इनखर हइ काम मनसेन के पल्ला लग होही, ता अपनै खुद खतम हुइ जही। ");
INSERT INTO bhu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","पय अगर हइ भगवान के तरफ लग होही, ता तुम इनही नेहको मिटा पइहा अउ हइ बोहत सम्भव हबै, कि तुम भगवान कर बिरोधी परमाडित हुइहा, पंचायत गमलीएल के बात मान लेथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","उन चेलन के बुलाय के उनही कोडा लगवाथै अउ उनही आदेस देथै, कि यीसु के नाम के चरचा झइ करै अउ उनही छांड देथै। ");
INSERT INTO bhu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","काखे चेला असना समझथै कि यीसु नाम कर निता कम से कम मार सहै के काबिल ठहरन। ");
INSERT INTO bhu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","फेर बिनती भवन अउ घर-घर हे सब रोज लगेतार ऊ सिक्छा देथै अउ यीसु मसीह कर सुभ संदेस सुनाउत रहै। ");
INSERT INTO bhu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","कुछ रोज बाद चेलन के गिनती बढथै ता यूनानी भासा बोलै बाले बिस्वासी अउ इब्रानी बोलै बाले यहूदी बिस्वासी हे अक्ठी झगडा हुइ जथै, काखे यूनानी बोलै बाले यहूदी बिस्वासी हइ दाबा करथै, उनखर सेबा हे बिधवन डउकिन कर रोज दिना के खाय पीय बाले चीजन हे अनदेखा करथै। ");
INSERT INTO bhu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","बारहठे चेला, चेलन के सगलू मंडली के अक जिघा बुलाय के कथै, हमर निता भगवान के बचन के सेबा के छांडके खाय पीय अउ पइसन के जुगाड करै के जरूरी नेहको आय। ");
INSERT INTO bhu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","इहैनिता भाई बेहन तुम अपन बीच लग सातठे डउकन के अपनै मसे चुन लेया, जउन पवितर आतमा अउ दिमाक ग्यान लग भरपूर होय, कि हम उनही हइ काम के निता जबाबदारी दइ। ");
INSERT INTO bhu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","पय हमर धियान बिनती हे अउ बचन के सेबा हे लगे रहिबे। ");
INSERT INTO bhu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","हइ सलाह लग सगलू मंडली बोहत मगन हुइन, उन स्तिफनुस नाम के मनसे के अउ जउन बिस्वास अउ पवितर आतमा लग भरे रथै अउ फिलिप्पुस, प्रुखुरूस, नीकानोर, तीमोन, परमिनास, अन्ताकियावासी, नीकुलाउस के, जउन यहूदी धरमी काम करै बाले के अपनाय लेथै, उके चुन लेथै। ");
INSERT INTO bhu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","उनही चेलन के आगू ठाड करथै अउ उन बिनती करके उनखर हे अपन हाथ धरिन। ");
INSERT INTO bhu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","अउ हइ मेर भगवान के बचन लगेतार फइले लगिस अउ यरुसलेम हे चेलन के गिनती बोहत बढ गइस, पुजारी के अक्ठी बडका समूहो हइ बिस्वास हे बढै लगिन। ");
INSERT INTO bhu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तिफनुस अक्ठी असना मनसे रथै, अनुगरह अउ सक्ति लग भरपूर रथै, ऊ मनसेन के बीच बडा-बडा चकित के काम अउ चकित के चिन्हा परगट करे करथै। ");
INSERT INTO bhu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","पय आजाद करे हर यहूदी मनसे के मंडली कुछ मनसे जउन लिबिरतीनो कहाथै, कुरेनी अउ सिकन्दरिया अउ किलिकिया आसिया इलाका लग आय हर यहूदी रथै, उन स्तिफनुस के बिरोध हे बाद बिबाद करै लगिन। ");
INSERT INTO bhu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","पय ऊ आतमा जेखर लग बात करत रथै अउ ओखर दिमाक के आगू नेहको टिक पाथै। ");
INSERT INTO bhu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","फेर उन कुछ मनसेन के लालच दइके बुलवाइन, “हम मूसा अउ भगवान के बिरोध हे निन्दा के बात कहत सुने हबन।” ");
INSERT INTO bhu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","हइ मेर उन मनसेन के सियान नेतन के अउ यहूदी धरमी गुरुन के उकसाइन, फेर उन आयके उके पकर लइन अउ यहूदी पंचायत के आगू लानथै। ");
INSERT INTO bhu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","उन ऊ ठगरा गवाहन के लानिन जउन कथै, “हइ मनसे हइ पवितर जिघा अउ नियम के बिरोध हे बोलथै। ");
INSERT INTO bhu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","हम इके कहत सुने हबन यीसु नासरी हइ बिनती भवन के नास कर देही अउ हमर परम्परा के बदल दइ जेही हमके मूसा दय हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ता सगलू मनसे जउन पंचायत हे बइठे रथै, उके धियान लग देखथै, ता ओखर चेहरा स्वरगदूत के जसना दिखथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ता पुजारी कथै, “का हइ बात सही हबै?” ");
INSERT INTO bhu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","स्तिफनुस कथै, “हे भाइयो अउ सियानन मोर बात सुना, हरान हे बसै लग आगू जब हमर दादा अब्राहम मेसोपोटामिया हे रथै, ता महिमामय भगवान उके दरसन देथै।” ");
INSERT INTO bhu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","अउ कथै, तै अपन देस अउ अपन घरबार के छांड के ऊ देस छो जा जेही मै तोके दिखाहुं। ");
INSERT INTO bhu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","तब ऊ कसदियो के देस के छांड के हरान हे जाय के बसथै, जछो लग ओखर बाफ के मरै के बाद भगवान उके हइ सहर हे आमै के सिक्छा दइस जछो तुम रहत हबा। ");
INSERT INTO bhu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","पय भगवान ऊ बारिसदार हे कुछु नेहको दइस, इहां तक गोड धरै तक के जिघा नेहको दइस, पय ओखर कउनो लरका नेहको रथै, तउभरमा भगवान ओखर लग टीमा करथै कि हइ देस ऊ उके अउ ओखर बारिसदार के ओखर डेरा के जसना मेर दइहों। ");
INSERT INTO bhu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","भगवान हइ कथै, “तोर बारिसदार अनजान देस हे अनचिन्हार हुइ के रइहे अउ चार साल तक उनही गुलाम बनाय के उनखर संग बेकार बरताव करे जही।” ");
INSERT INTO bhu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","फेर भगवान कथै, हरवाह बनामै बाले ऊ जात के मै सजा दइहों अउ ऊ एखर बाद उन ऊ देस लग बाहिर आय जही अउ हइ जिघा हे उन मोर सेबा करही। ");
INSERT INTO bhu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","भगवान अब्राहम के सुध्दिकरन खतना के रिबाज लग निसानी लगा के टीमा देथै, अउ हइ मेर ऊ इसहाक कर बाफ बनिस, ओखर पइदा होय कर बाद आठै रोज ओखर सुध्दिकरन करथै, फेर इसहाक लग याकूब अउ याकूब लग बारहठे कुर लग डउका पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","याकूब कर टोरवा अपन भाई यूसुफ लग इसाय करथै, उन उके मिस्र हे हरवाह बनाय के निता बेच देथै, पय भगवान ओखर संग रथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","अउ ऊ उके सगलू दुख लग छंडाइस। भगवान यूसुफ के दिमाक दइस अउ ऊ उके हइ काबिल बनाइस जेही ऊ मिस्र के राजा फिरोन के अनुगरह के काबिल बन सकै, फिरोन ऊ मिस्र के राजपाल अउ अपन घरबार के साहब बनाथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","फेर सगलू मिस्र अउ कनान देस हे भुखमरी पडथै, बडा दुख छाय गइस, हमर सियानन के खाय के निता कुछु नेहको रथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","जब याकूब सुनथै कि मिस्र देस हे दाना हबै, ता ऊ अपन टोरवा हमर सियानन के मिस्र हे पठो, ऊ उनही मिस्र हे पहली बेर भेंट होथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","दूसर बेर यूसुफ यातरा के टेम अपन भाई हे परगट करथै, तब फिरोन मिस्र राज के यूसुफ के परवार के बारे हे पता चलथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","तब यूसुफ अपन बाफ याकूब अउ अपन घरबार के सगलू मनसे के बुलवामै के पठोथै, जउन पछत्तर झन रथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ता याकूब मिस्र देस हे आथै अउ ऊ उछो ओसनेन परान निकरथै जसना हमर सियानन के परान निकरे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","उनखर लोथ उछो लग वापिस सकेम लइ जथै, उछो मरघटी हे धरथै अउ उहै मरघटी रथै जेही अब्राहम हमोर कर टोरवा के कुछ पइसा दइ के खरीदे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","जब भगवान अब्राहम के जउन बचन दय रथै, ऊ टीमा के पूर होय के टेम लिघ्घो आइस, ता मिस्र हे हमर मनसेन के गिनती बोहत जादा बड गइस। ");
INSERT INTO bhu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","आखरी हे मिस्र देस हे अक्ठी असना राजा के राज हुइस जउन यूसुफ के बारे हे कुछु नेहको जानथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ऊ हमर मनसेन के संग गुस्सामेर बेउहार करथै, ऊ सियानन के बडा आदेस के संग मजबूर करिन, कि उन अपन लरकन के बाहिर मरै के निता छांडिन, ताकि ऊ जिन्दा झइ रह पाबै। ");
INSERT INTO bhu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ऊ टेम मूसा पइदा होथै, ऊ भगवान के नजर हे बोहत सुन्दर लरका रथै, ऊ तीन माह तक अपन बाफ के घर हे पाले पोसे गइस। ");
INSERT INTO bhu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","जब उके घर के बाहिर छांड दइन, ता फिरोन के टोरिया उके अपन टोरवा बनाय के उठाय लइ जथै अउ अपन टोरवा के मेर पालथै पोसथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","मूसा कर मिस्रिन के सगलू पढाइ लिखाइ के सिक्छा दइस, ऊ बात करै हे अउ काम करै हे बोहत बलवान रथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","जब मूसा चालीस साल के होथै, ता ओखर मन हे आथै कि मै अपन इस्राएली भाई के लिघ्घो जाय के ठानिस। ");
INSERT INTO bhu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","जब अक बार ऊ देखथै कि ओखर मसे अक्ठी के संग गलत बेउहार करे गइस, ता ऊ उके बचाइस अउ मिस्री के मनसे के मार के ऊ मनसेन के बदला लइ लइस। ");
INSERT INTO bhu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ऊ सोंचथै कि अपन भाई जान जही कि उनही छंडामै के निता भगवान ओखर हाथ लग उनखर मुकति करही, पय ऊ उके नेहको समझ पाइस। ");
INSERT INTO bhu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","बिहाने रोज जब उन अपन हे लडथै, ता ऊ उनखर लिघ्घो पहुंचथै अउ हइ कहत उनखर हे बीच बचाव करके मेलजोल करवाथै, हे भाई दोनो इस्राएली भाई हबा तुम अपन हे काखे झगडथा, काखे अक दूसर के नुसकान पहुंचामै चाहथा। ");
INSERT INTO bhu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ऊ मनसे अपन परोसी लग झगडत रहिस, मूसा कर मारत कथै, हमर राजा के नियाव करे के निता कोहर मुखिया बनाय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","जसना तुम कल ऊ मिस्री के मार डारे हबस, का ओसनेन तै मोके मार डालै के चाहथस। ");
INSERT INTO bhu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","मूसा हइ सुनथै ता उछो लग भाग जथै अउ मिद्दान देस हे अक्ठी अनचिन्हार के जसना रहै लग जथै, उछो ओखर दुइठे टोरवा पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","जब पूर चालीस साल हुइ चुकथै, ता सीनै डोंगर के लिघ्घो अक्ठी जलत पुडरा हे धन्धकत के बीच हे ओखर आगू स्वरगदूत परगट हुइस। ");
INSERT INTO bhu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","मूसा हइ देखथै ता देखय के निता पुडरा के लिघ्घो गइस ता उके परभु के आरो सुनाई देथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","मै तोर सियानन के भगवान हबो, अब्राहम के इसहाक के अउ याकूब के भगवान हबो, डर लग थरथराउत मूसा कुछु देखय के हिम्मत नेहको कर सकिस। ");
INSERT INTO bhu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ता परभु ओखर लग कथै, अपन गोड लग बूट उतार काखे जउन जिघा हे ठाडे हबस, ऊ पवितर भुंइ हबै। ");
INSERT INTO bhu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मै मिस्र हे अपन मनसेन के संग होत हबै अतियाचार के देखे हबो अउ उनखर पीरा अउ रोमै के आरो सुने हबो, इहैनिता उनही छंडामै के निता तरी छो उतरे हबो, आ अब तोके मै मिस्र देस छो पठोहूं। ");
INSERT INTO bhu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","जउन मूसा कर उन हइ कहिके नकारे रथै, तोके कउन हमर हे साहब अउ नियाव बाले ठहराय हबै, उहै के भगवान ऊ स्वरगदूत के दवारा जउन ओखर निता पुडरा हे परगट होथै, राजा अउ मुकतिदाता के सकल हे पठोइस। ");
INSERT INTO bhu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ऊ उनही मिस्र देस के भुंइ अउ ललका समुन्दर अउ पटउरा मसे चालीस साल तक चकित के काम करत अउ चिन्हा देखाउत ऊ बाहिर निकाड लाइस। ");
INSERT INTO bhu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","हइ उहै मूसा हबै, जउन इस्राएल के लरकन लग कहे रथै, तुम्हर भाइन मसे तुम्हर निता भगवान अक्ठी मेर जसना ग्यानी मनसे के पठोही। ");
INSERT INTO bhu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","हइ उहै हबै, जउन निरजन परदेस के मंडली हे ऊ स्वरगदूत के संग रथै, जउन सीनै डोंगर हे ओखर लग बात करिस, ऊ हमर सियानन के संगो रथै, भगवान लग जिन्दा बचन मिलथै, जेही हमर लिघ्घो तक पहुंचिस। ");
INSERT INTO bhu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","पय हमर सियान मानै के निता मना कर देथै अउ अपन मन हे मिस्र के पल्ला लउट गइन। ");
INSERT INTO bhu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","उन हारुन लग कथै, हमर निता असना देउता के बनामै कि ऊ हमके रास्ता देखामै, काखे हम नेहको जानथन कि ऊ मूसा के काहिन हुइस, जउन हमके मिस्र देस लग निकाड लाइस? ");
INSERT INTO bhu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","उहै रोज उन अक्ठी बछवा के मूरती बनाइन अउ ओखर आगू बलि चढाथै अउ अपन हाथन के बनाय हर मूरती के निता मगन हुइन। ");
INSERT INTO bhu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","जब भगवान उनखर लग दुरिहां हुइ गइस अउ ऊ उनही बादर के तरइयन के उपास करै के निता छांड देथै, जसना कि ग्यानी मनसे के किताब हे लिखवरे हबै, हे इस्राएल के मनसे का तुम पतेरा हे, चालीस साल तक गोरू के बलि, अउ दाना के बलि मोहिन के चढाउत रहा। ");
INSERT INTO bhu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","तुम मोलेक के तम्बू के अउ अपन भगवान रिफान के तरइया के, मतलब उन पुतलन के जेही तुम भजन करै के निता बनाय रथा, इहैनिता मै मनसेन के बेबीलोन के ऊ पल्ला बसाहुं। ");
INSERT INTO bhu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","गवाह के तम्बू ऊ वीराने हे हमर सियान के संग रथै, हइ तम्बू उहै निसानी हे बनाय गय हबै, जसना कि पुतलन के देखे रथै उहै के जसना उके बना। ");
INSERT INTO bhu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","हमर सियानन उके पाय के तबय उछो लग आथै, जब यहोसू के अगुवाई हे उन जातन हे हक पाइन, जेखर लग हमर सियान कर आगू भगवान निकाड के बाहिर करथै अउ दाऊद के टेम तक उहै रथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ओखर हे भगवान अनुगरह करिस, ऊ बिनती करथै कि याकूब के भगवान कर निता ऊ अक जिघा मन्दिर बनाबै। ");
INSERT INTO bhu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","पय सुलेमान भगवान कर निता मन्दिर बनवाथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","पय परम परधान हाथ के बनाय हर घरन हे नेहको रथै, जसना कि ग्यानी मनसे कथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","परभु कथै, स्वरग मोर राजगद्दी हबै, अउ भुंइ मोर गोड के पिढवा हबै, कउन मेर के तुम घर बनइहा? अउ मोर सुत्ताय के जिघा कछो होही? ");
INSERT INTO bhu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","का हइ सगलू मोर हाथ के बनाय हर नेहको हबै? ");
INSERT INTO bhu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","स्तिफनुस आगू बोलतेन रहिस केतका तुम ढीठ हबा, मन अउ कान लग बिना सुध्दिकरन के हबा तुम अपन सियानन के जसना हबा, तुम सबदिना पवितर आतमा के बिरोध करे हबा। ");
INSERT INTO bhu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","उन तो ग्यानी मनसेन के मार डारिन जउन बोहत पहिलेन लग भगवान के धरमी मनसे के आदेस कर दइस, जेही तुम धोखा दइके पकरवाय के मारो डारा। ");
INSERT INTO bhu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","तुम उहै हबा जेही स्वरगदूतन के दवारा दय गइस भगवान के नियम बिधान के पाय तो गइन, पय ओखर हे नेहको चलिन। ");
INSERT INTO bhu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ओसनेन पंचायत के सदस्य स्तिफनुस के सुनके, बोहत गुस्साय उठथै अउ ओखर हे दांत जबामै लगिन। ");
INSERT INTO bhu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","पय स्तिफनुस पवितर आतमा लग भर के स्वरग छो निहारथै अउ भगवान कर महिमा के अउ भगवान कर दहिना पल्ला ठाडे यीसु के देखथै, ");
INSERT INTO bhu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ऊ कथै देखा मै देखथो कि स्वरग उघरे हर हबै अउ मनसे कर टोरवा भगवान के दहिना पल्ला ठाड हबै। ");
INSERT INTO bhu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","एतका हे उन बोहत चिरलाय के अपन कान मूंद लेथै अउ सब मिलके स्तिफनुस हे झपटथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","अउ उके घसीटत नगर के बाहिर निकाड के उके पथरा मारै लग जथै, गवाह अपन बन्डी साऊल नाम के अक्ठी जबान के गोड कर लिघ्घो उतार के धर देथै। ");
INSERT INTO bhu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","जब मनसे स्तिफनुस हे पथरा मारथै, ता ऊ हइ बिनती करत रथै, “हे परभु यीसु मोर आतमा के स्वीकार कर।” ");
INSERT INTO bhu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","फेर घुटवा के बल गिर जथै, “हे परभु हइ पाप के उनखर हे झइ लगाबे।” एतका कहि के ऊ मर जथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","हइ मेर साऊल स्तिफनुस के मारै के सहयोग करथै, उहै रोज लग यरुसलेम के मंडली हे बोहत मारपीट सुरू हुइ जथै अउ चेलन के छांड के सगलू के सगलू बिस्वासी मनसे यहूदिया अउ सामरिया देस हे तितर-बितर हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","कुछ सेबक स्तिफनुस के मरघटी हे धरथै अउ ओखर निता रोथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","साऊल ऊ टेम मंडली के परेसान करथै अउ घर-घर हे घुस के डउका अउ डउकिन के किढलाउत जेल हे बेड दय करथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","जउन बिस्वासी तितर-बितर हुइ जथै, उन सब जिघा घूम-घूम के संदेस कर परचार करथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","फिलिप्पुस सामरिया सहर छो अक्ठी सहर हे गइन अउ उहां के मनसेन के मसीह के परचार करै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","जब मनसे खुद फिलिप्पुस के बात सुनथै अउ ओखर दवारा करे गय, चकित चिन्हा के परगट करे करथै अउ जउन बातन के ऊ गुठेथै, ओहमा धियान देय लगथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","बोहत मनसेन मसे जिनखर हे भुतवा समाय रथै, उन बोहत आरो लग चिरलाउत बाहिर निकडथै अउ बोहत लोकवा बिमारी अउ लेंगरा निक्खा हुइ गइन। ");
INSERT INTO bhu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ऊ सहर हे बड्डे मगन ही मगन छाय गइस। ");
INSERT INTO bhu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","समोन नाम के अक्ठी मनसे रथै, बोहत टेम लग जादू-टोना कर काम करथै अउ सामरिया के मनसेन के चकित करथै अउ अपन खुद के बड्डे डउका कहामै के दावा करथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","नान लग लइके बड्डे तक सगलू मनसे ओखर बात मानथै अउ कथै, “हइ मनसे हे भगवान कर सक्ति हबै जउन महासक्ति कहाथै।” ");
INSERT INTO bhu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ऊ बोहत रोज लग उनही अपन जादूगिरी दवारा मनसेन के चकित करके रखथै, इहैनिता उन ओखर बात मानथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","पय जब उन फिलिप्पुस के बातन हे बिस्वास करथै, ऊ उनही भगवान कर राज अउ यीसु मसीह के नाम के संदेस कर परचार करथै, ता उन डउका-डउकी सब बतिस्मा लइन। ");
INSERT INTO bhu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","खुद समोन उनखर हे बिस्वास करथै अउ बतिस्मा लेय के बाद फिलिप्पुस के संग रहै लगथै, हइ चिन्हा अउ महान सक्ति के काम होवत देख के बडा चकित होथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","जब यरुसलेम सहर हे चेला हइ सुनथै कि सामरिया सहर मनसे भगवान कर बचन के स्वीकार करे हबै, ता उन पतरस अउ यूहन्ना के उनखर लिघ्घो पठोथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","जब उन उछो पहुंचिन अउ उनखर निता बिनती करथै, कि पवितर आतमा पामै। ");
INSERT INTO bhu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","काखे अबे तक पवितर आतमा उनखर मसे कउनो हे नेहको उतरे रथै, उन तो केबल परभु यीसु के नाम हे पानी लग बतिस्मा दय रथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ता पतरस अउ यूहन्ना उनखर हे हाथ धरिन अउ उन पवितर आतमा पाय जथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","जब समोन हइ देखथै कि चेलन के हाथ धरै लग पवितर आतमा मिलथै, ता ऊ उनखर लिघ्घो पइसा लायके आथै, ");
INSERT INTO bhu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“हइ सक्ति मोके दइदे, कि महुं जेखर हे हाथ धरो, ऊ पवितर आतमा पामै।” ");
INSERT INTO bhu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","पतरस कथै, तोर पइसा तोर संग नास होय, कि तै भगवान के दान पइसा हे खरीद के सोचथस। ");
INSERT INTO bhu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","हमर कामन हे तोर काम अउ हीसा नेहको हबै काखे तोर मन भगवान के आगू सिध्धा नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","तै हइ बेकार बिचार लग मन बदला अउ परभु लग बिनती कर हुइ सकथै जउन तोर बेउहार हबै, ऊ बिचार के निता तोके छमा कर दय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","काखे कि मै देखतो कि तै कडवाहट लग भररे हस अउ पाप के चुंगुल हे फसे हबस। ");
INSERT INTO bhu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","समोन पतरस अउ यूहन्ना के जबाब देथै, किरपा करके खुद मोर निता “तुम परभु लग बिनती करा, ताकि जउन कुछु तुम कहे हबा ऊ मोर हे झइ होय।” ");
INSERT INTO bhu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","अपन गवाही दइके परभु के संदेस सुन चुके हबा, तब उन यरुसलेम सहर छो लउट जथै, उन हइ यातरा कर दवारा सामरिया के बोहत लग गांवन हे संदेस सुनाथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","इन रोज हे परभु के अक्ठी स्वरगदूत फिलिप्पुस के कथै, “ठाड हो अउ दख्खिन के पल्ला जा, जउन यरुसलेम सहर लग गाजा छो जथै।” हइ पतेरा गली हबै। ");
INSERT INTO bhu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ऊ तइयार हुइके कढ जथै, अउ टेम इथियोपिया देस के अक्ठी खोजा अउ कूसियन के रानी कन्दाके के खजाना के साहब रथै, ऊ आराधना के निता यरुसलेम छो गइस। ");
INSERT INTO bhu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","लउटत टेम अपन रथ हे बइठे यसायाह आगू कर बात गुठेमै बाले के किताब पढथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","पवितर आतमा फिलिप्पुस लग कथै, “ऊ रथ के लिघ्घो जा अउ उहै ओखर लिघ्घो रुकबे।” ");
INSERT INTO bhu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिप्पुस जब ऊ रथ के लिघ्घो गइस, तब ऊ उके यसायाह आगू कर बात गुठेमै बाले के किताब पढत सुनथै अउ पूछथै, का तै जउन पढथस उके समझथस। ");
INSERT INTO bhu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","साहब जबाब देथै, “जब तक कउ मोके नेहको समझाही, तब तक मै कइसन के समझ पइहों?” ऊ फिलिप्पुस लग बिनती करथै, कि ऊ रथ हे चढके ओखर संग बइठ जाय। ");
INSERT INTO bhu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","पवितर किताब के जउन पद के पढथै ऊ हइ रथै, “ऊ मरै बाले गेडरा के जसना लइजात रहिन, अउ गेडरा ऊन काटै बाले के जसना चुप्पेचाप रथै, उहै मेर ऊ अपन मुंह नेहको खोलथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","असना दीन दसा हे नियाव लग दुरिहां करिन, ओखर पुरखा के कोनहर चरचा करही? काखे भुंइ हे ओखर जीवन खतम करे जथै।” ");
INSERT INTO bhu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","साहब फिलिप्पुस लग पूछथै, “मै तोर लग बिनती करथो, हइ गुठे कि आगू कर बात गुठेमै बाले हइ केखर बारे हे कथै?” अपन बारे हे या कउनो दूसर के बारे हे? ");
INSERT INTO bhu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","फेर फिलिप्पुस पवितर किताब के हइ भाग लग सुरू करथै अउ हइ किताब ले लइके यीसु कर संदेस के सुनाथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","यातरा करत-करत उन रास्ता हे अक जिघा पानी के लिघ्घो पहुंचथै, ऊ कथै, “इछो पानी हबै, अब मोके बतिस्मा ले हे काहिन देरी हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिप्पुस जबाब देथै, “अगर तै सगलू मन लग बिस्वास करथस, ता कोनो बाधा नेहको हबै।” ऊ कथै, “मै बिस्वास करथो कि यीसु मसीह भगवान कर टोरवा हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ऊ रथ ठाड करै के आदेस देथै अउ फिलिप्पुस अउ साहब खोजा दुनोझन पानी हे उतरथै अउ फिलिप्पुस उके पानी लग बतिस्मा देथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","जब उन पानी लग बाहिर आइन, ता परभु के आतमा के अगुवाई लग फिलिप्पुस दूसर रास्ता लग कढ जथै अउ खोजा उके फेर कबहुं नेहको देखथै अउ ऊ मगन करत अपन गली कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","फिलिप्पुस अपन के अस्दोद सहर हे पाथै, जब तक ऊ कैसरिया हे पहुंचथै तब तक रास्ता हे संदेस सुनाय करथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","साऊल हे अबे परभु के चेलन के डरुहाउत अउ मार डारै के सुर हे रथै अउ महापुजारी के लिघ्घो जथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","अउ दमिस्क के यहूदी मंडली आराधनालय के जिघा के नाम मांग के हक के निता चिट्ठी लिखथै, कि डउका होय या डउकी होय बन्दी बनाय के यरुसलेम छो ले आवा। ");
INSERT INTO bhu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","जब साऊल यातरा करत-करत दमिस्क सहर के लिघ्घो पहुंचथै, ता अकदम बादर ले अक्ठी उजियार ओखर आंखी हे चमकथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","अउ भुंइ हे गिर पडथै अउ हइ सब्द सुनथै, “हे साऊल-हे साऊल तै मोके काखे परेसान करथस।” ");
INSERT INTO bhu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","साऊल कथै, हे परभु तै कोन हबस? ऊ कथै, “मै यीसु हबो, जेही तै परेसान करथस। ");
INSERT INTO bhu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ठाड हो अउ सहर छो जा उहां तोके गुठे दे जही कि काहिन करै के हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","जउन मनसे ओखर संग यातरा करत रहिन, अक्का-बक्का हुइ जथै, उन आरो तो सुनथै पय कउनो के नेहको दिखथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","साऊल भुंइ लग उठथै, पय जब ऊ अपन आंखी उघारथै ता ऊ कुछु नेहको देख पाथै, ता उन ओखर हाथ पकडके दमिस्क हे लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ऊ तीन रोज तक न तो देख पाथै अउ न खाय पाथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमिस्क हे हनन्याह नाम के अक्ठी बिस्वासी चेला रथै, परभु उके दरसन दइके कथै, “हे हनन्याह।” परभु मै इछो हबो, तोर सेबा हे हाजिर हबो। ");
INSERT INTO bhu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","परभु ओखर लग कथै, “सिध्धा कहामै बाले गली हे जा अउ यहूदा के घर हे तरसुस निबासी साऊल नाम के अक्ठी मनसे के पता लगा, ऊ हइ टेम बिनती करथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ऊ अक्ठी दरसन हे देखथै कि हनन्याह नाम के अक्ठी मनसे घर हे आय के ओखर हे हाथ धरथै, ता ऊ फेरै लग देख सकै।” ");
INSERT INTO bhu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हनन्याह जबाब देथै, “हे परभु मै हइ मनसे के बारे हे बोहत झन लग सुने हबो, कि तोर पवितर मनसेन के संग हइ यरुसलेम सहर हे केतका बार सताय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","अउ इछो हइ मुख्य पुजारी लग तोर नाम हे बिस्वास रखै बालेन के बन्दी बनामै के उके हक हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","पय परभु ओखर लग कथै, “तै जा काखे हइ मनसे के गैर यहूदी राजन अउ इस्राएल मनसेन के आगू मोर नाम लेमै के निता मै इके चुने हबो। ");
INSERT INTO bhu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","मै खुदय उके गुठेहूं कि ऊ मोर नाम के कारन केतका दुख भोगय के पडही।” ");
INSERT INTO bhu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","तब हनन्याह कढ जथै अउ ऊ घर हे घुसथै ऊ साऊल हे हाथ धर के कथै, “हे भाई साऊल जउन परभु यीसु तोके इछो आउत टेम गली हे दरसन दय रथै, उहै मोके पठोय हबै, ताकि तै फेरै लग देख सकस अउ पवितर आतमा लग भर जा।” ");
INSERT INTO bhu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","फेर जल्दी ओखर आंखी लग छिलपा मेर गिरथै अउ ऊ फेरै देखय लग जथै, ऊ ठाड हुइके पानी लग बतिस्मा लेथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","फेरै लग बल पाथै, दमिस्क चेलन के संग कुछ दिना तक रुके रथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","अउ ऊ यहूदी मंडली हे यीसु के परचार करै लगथै, कि ऊ भगवान कर टोरवा हबै। ");
INSERT INTO bhu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","सगलू सुनै बाले चकित हे पड के कथै, “का हइ ऊ मनसे नेहको हबै, जउन यरुसलेम सहर हे यीसु के नाम के महिमा करै बालेन के मारत रहिस? का ऊ इहैनिता तो नेहको आय हबै कि ऊ उनही बांध के महापुजारी के लिघ्घो लइ जाही?” ");
INSERT INTO bhu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","पय साऊल के परचार अउ सक्तिसाली होत गइस, हइ बात के परमाड दइ-दइ के यीसु मसीह इहै हबै, ऊ दमिस्क के रहै बाले यहूदी के मुंह बन्द करत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","बोहत रोज गुजर जाय के बाद यहूदी अक संग मिलके उके मार डारय के जुगाड बनाथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","पय साऊल के उनखर मारै के पता पाय जथै, उन उनही मार डारै के मकसद लग उन सहरन के दूरन हे तकइया रात-दिन लगाय रथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","पय साऊल के चेला ओही अक रात लइ गइन अउ उन साऊल के टोपरी हे बइठ के दिबार के उप्पर लग लटकाय के उके तरी छो उतार देथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","जब साऊल यरुसलेम सहर छो पहुंचथै, ता ऊ बिस्वासिन हे मिलै-जुलै के परयास करथै, पय उन सब बिस्वासी ओखर लग डरथै, काखे उनही बिस्वास नेहको होथै, कि ऊ सहीमा यीसु के चेला बन गय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","तब बरनबास उके चेलन कर लिघ्घो लइ गइन अउ ऊ उनही बताथै, कि साऊल परभु के गली हे कउन मेर देखिस अउ परभु ओखर लग कसना बात करिस, दमिस्क हे कउन मेर ऊ बिना डरे लग यीसु के नाम के परचार करिस। ");
INSERT INTO bhu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","अउ साऊल यरुसलेम हे उनखर संग आमै जाय लगिस, अउ बिना डरे परभु के नाम के परचार करै लगिस। ");
INSERT INTO bhu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ऊ यूनानी भासा यहूदियन लग बातचीत अउ बहस करे करथै, पय उन मनसे उके मार डारे चाहथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","जब बिस्वास करै बालेन भाई बेहनन के एखर पता चलथै, ता उन साऊल के कैसरिया बन्दरगाह छो लइ गइन अउ उछो लग तरसुस सहर छो पठो देथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","इहैमेर सगलू यहूदिया, गलील अउ सामरिया कर मंडली के सान्ति हे दिन गुजारथै। ऊ मंडली सक्तिसाली होमय लगिस अउ पवितर आतमा के उतसुक पाय के सक्तिसाली हुइस अउ उन गिनती हे बढत गइन, काखे उन परभु के डेराय कर अपन जीवन बइतीत करथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","पतरस चारो चउगिरदा फिरत अक रोज लुद्दा सहर हे भगवान कर पवितर मनसेन लग मिलय पहुंचथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","उछो उके एनियास नाम के अक्ठी लोकवा नंगहा मनसे मिलथै, जउन आठ साल लग खटिया हे पडे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पतरस ओखर लग कथै, “एनियास यीसु मसीह तोके निक्खा करथै, ठाड हो अउ अपन जठना ठीक कर।” अउ ऊ उहै जल्दी ठाड हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","तब लुद्दा अउ सारोन के सगलू निबासी उके देखथै अउ उन परभु कर पल्ला फिरथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","याफा सहर हे तबीता नाम कर चेला तबीता के यूनानी अनुवाद दोरकास हबै, ऊ अपन धरमी काम करिस अउ निक्खा दिन गुजारत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","उहै रोज ऊ नांगा हे मर गइस, मनसे उके नहुवाय के ओखर लोथ के अटारी बाले पटउंहा हे धर देथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लुद्दा याफा सहर के लिघ्घो हबै। जब चेला सुनथै कि पतरस उछो हबै, ता उन दुइठे मनसेन के पठोय के ओखर लग हइ बिनती करिन, कि तै हरबी हमर इछो आ। ");
INSERT INTO bhu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","तब पतरस उहै टेम उनखर संग चल देथै, जब ऊ याफा पहुंचथै, ता मनसे ओही अटारी के पटउंहा हे लइ गइन। उछो सगलू बिधवा डउकी रोउत ओखर चारो चउगिरदा आय के ठाड होथै अउ उन खुरथा पइजामा अउ बन्डी उनही देखामै लगिन, जेही दोरकास उनखर संग रहत टेम बनाय रथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","पतरस सबझन के बाहिर छो करथै अउ घुटवा टेक के बिनती करथै, एखर बाद ऊ लोथ कर पल्ला मुड के कथै, “हे तबीता ठाड हुइ जा।” ओतकै टेम ओखर आंखी उघर जथै अउ पतरस के देखके ठाड हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","पतरस हाथ बढाय के पवितर मनसे अउ बिधवन के बुलाय के उनही उके जिन्दा सउप देथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","हइ बात सगलू याफा हे बगर जथै अउ बोहत मनसे परभु हे बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","पतरस बोहत रोज तक याफा हे समोन नाम के कउनो खलरी के धंधा करै बालेन के इछो रथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया हे कुरनेलियुस नाम के अक्ठी मनसे रथै, उछो रोमन सिपाही रथै, इतालियानी सिपाही गुट कहे जथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","अउ ऊ हरवाह रहिस अउ अपन सगलू घर कर मनसे भगवान लग डरथै। अउ यहूदी गरीब मनसेन के बोहत दान देथै अउ बराबर भगवान लग बिनती करत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ऊ रोज के तीसर टेम के लिघ्घो दरसन हे सही रूप लग देखथै, कि भगवान कर अक्ठी स्वरगदूत ओखर लिघ्घो भित्तर आयके कथै, हे कुरनेलियुस ");
INSERT INTO bhu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","कुरनेलियन डेरात अउ स्वरगदूत के पल्ला देखत कथै हे परभु काहिन हबै? ऊ ओखर लग कथै, तोर बिनती अउ तोर दान सुरता के निता भगवान कर आगू पहुंचथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","अउ अब कुछ मनसेन के याफा पठोथै, समोन नाम कर मनसे के जउन पतरस कहाथै, उके बुलाइस। ");
INSERT INTO bhu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ऊ खलरी के धंधा करै बाले समोन नाम के मनसे के इछो गउतरिहा बनाय के ठहराइस अउ ओखर घर समुन्दर के बगल हे हबै। ");
INSERT INTO bhu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","जब ऊ स्वरगदूत जउन ओखर लग बात करे रथै, कढ गइस ता ऊ दुइझन हरवाह अउ जउन ओखर लिघ्घो उपस्थित रथै, अपन खास सहपारटी मसे अक्ठी अच्छी भक्त सिपाही के बुलवाथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","अउ उनही सगलू बात गुठेय के याफा के पठोथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","दूसर रोज जब ऊ रेंगत बागत नगर के लिघ्घो पहुंचथै, ता दुपहरी कर टेम पतरस छत हे बिनती करै चढ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","उके भूख लगथै अउ कुछ खाय चाहथै, पय जब ऊ तइयारी करथै, तब पतरस सपना देखिस। ");
INSERT INTO bhu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","अउ ऊ देखथै, कि बादर उघरे हर हबै अउ अक्ठी बडा चदरा के जसना तरी छो उतरथै, उके चउगिरदा खुटान लग पकडके भुंइ हे उतारथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","जेहमा भुंइ के सगलू मेर के चवपाई अउ रेंगै बाले जानबर अउ बादर कर चिरइया रथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","फेर आरो सुनाई देथै, हे पतरस उठ अउ इके मार खा। ");
INSERT INTO bhu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","पतरस कथै, “परभु कबहुन नेहको, काखे मै कबहुन असुध्द खाना नेहको खाय हव।” ");
INSERT INTO bhu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","फेर दूसर बार उके आरो सुनाई देथै, जउन कुछ भगवान सुध्द ठहराय हबै, उके असुध्द झइ कह। ");
INSERT INTO bhu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","तीसर बार असना होथै, तब जल्दी ऊ चीज बादर हे उठाय लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","जब पतरस अपन मन हे दुबिधा हे रथै, कि हइ दरसन जउन मै देखे हबो, ऊ काहिन हुइ सकथै, ता देखा ऊ मनसे जिनही कुरनेलियुस पठोय रथै, समोन के घर छो पता लगाय के दूरा हे आयके ठाड होथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","अउ ऊ ऊंच आरो लग पूछथै, का समोन जउन पतरस कहाथै, ऊ पहुना इहै घर छो ठहरे हबै? ");
INSERT INTO bhu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पतरस अभिन्नो ऊ दरसन के बारे हे सोचथै, कि आतमा ओखर लग कथै, देख तीनठे मनसे तोके खोजथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","पय उठके तरी छो जा अउ बिना डरे उनखर संग होय ले काखे मै उनही पठोय हव। ");
INSERT INTO bhu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","तब पतरस उतर के उन मनसेन लग कथै, देखा जेखर खोज तुम करथा ऊ मै हबो, तुम्हर आमैके काहिन मतलब हबै? ");
INSERT INTO bhu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","उन कथै, कुरनेलियुस सिपाही जउन मनसे भगवान लग डरथै अउ यहूदी हे बोहत धरमी आदर के काबिल मनसे हबै, ऊ अक्ठी पवितर स्वरगदूत लग हइ आदेस पाथै, कि तोके अपन घर बुलाय के तोर लग बचन संदेस सुनै। ");
INSERT INTO bhu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","हइ मेर पतरस उनही भित्तर बुलाइस अउ उहां रात बिताइन फेर आने रोज तइयार हुइके उनखर संग कढ गइस, अउ कुछ बिस्वासी भाई मसे याफा के रहै बाले हबै, ओखर संग हुइ लेथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","दूसर रोज ऊ कैसरिया नगर छो पहुंचथै अउ कुरनेलियुस अपन बिरादरी अउ प्रिय साथिन के अक जिघा करके उनही ओरगथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","जब पतरस भित्तर आथै, ता कुरनेलियुस ओखर मुलाखात करथै अउ ओखर गोड हे गिरके उके नमस्ते करथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","पय पतरस उके उठाय के हइ कथै, महुं अक्ठी मनसे हव। ");
INSERT INTO bhu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","अउ ओखर संग बात चीत करत भित्तर छो जथै अउ बोहत मनसेन के अकठ्ठा पइस अउ देखिस, ");
INSERT INTO bhu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ओखर लग कथै, तुम जानथा कि गैर यहूदी के संग उठक बइठक करना या ओखर इहां जाबे अउ यहूदी कर निता अधरम बेकार हबै, पय भगवान मोके गुठे हबै, कि कउनो मनसे के अपवितर या असुध्द मनसे नेहको गुठेहूं। ");
INSERT INTO bhu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","इहैनिता तोर बुलाय लग मै बिगर कउनो अपत्ति के इहां आय हबो अब मै पूछै चाहथो, कि तै मोके काखे बुलाय? ");
INSERT INTO bhu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","कुरनेलियुस कथै, इहै टेम पूर चार रोज हुइस, मै अपन घर हे मुरगोसा बिनती करथो, ता अचनकै अक्ठी डउका चमचमात खुरथा पइजामा ओढे हर मोर आगू आय के ठाढ हुइ गइस। ");
INSERT INTO bhu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","अउ कथै, कुरनेलियुस तोर बिनती सुन लय गय हबै अउ दीन दुखियन के दय गय तोर दान भगवान के आगू सुरता करे गय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","इहैनिता कउनो के याफा नगर छो पठोय के समोन के जउन पतरस कहाथै बुला, ऊ समुन्दर के टाठा हे समोन खलरी के धंधा करै बाले के घर हे पहुना बनके ठहरे हबै। ");
INSERT INTO bhu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","इहैनिता इछो आय अउ बोहत निक्खा करे, इहैनिता परभु जउन आदेस दय हबै, अब हम सगलू इहां भगवान कर आगू हबन ता जउन कुछ भगवान तोर लग गुठे हबै उके सुना। ");
INSERT INTO bhu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","तब पतरस कथै, अब मोके जरूरी हबै, कि भगवान कउनो के पक्छपात नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","बलुक मनसे कउनो जात के काखे न होय, पय मनसे भगवान लग डरथै अउ धरमी काम करथै, ऊ उके स्वीकार करथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","इहै हबै, ऊ संदेस जउन अपन यीसु मसीह के दवारा जउन सब के परभु हबै, सान्ति के संदेस के उपदेस देत इस्राएल कर मनसेन के भगवान दय रथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","नासरत के रहैबाले यीसु कर बारे हे अउ बात सगलू यहूदिया देस हे जउन होय हबै, उके तुम मनसे जानथा, ऊ सगलू गलील परदेस हे सुरु हुइस, ऊ बतिस्मा के बाद जेखर परचार यूहन्ना करे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","भगवान उहै यीसु नासरी के पवितर आतमा अउ सक्ति लग अभिसेक करे रथै अउ ऊ चारो पल्ला घूम-घूम के निक्खा काम करथै अउ भुतवा के बस हे आय हर मनसेन के निक्खा करथै काखे भगवान उनखर संग रथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","उन जउन कुछ यहूदिया परदेस अउ यरुसलेम हे करिस, ओखर गवाह हम हबन, उहै यीसु के मनसे क्रूस के लकडी हे चढाय के मार डारिन। ");
INSERT INTO bhu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","पय भगवान उके मिरतू मसे तीसर रोज जिन्दा करिस अउ परगट रूप लग दिखाई दइस। ");
INSERT INTO bhu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","सगलू मनसेन के नेहको बलुक उन गवाहन के जिनही भगवान आगू लग चुन लय रथै, ऊ गवाह हम हवन, मिरतू मसे ओखर जिन्दा होय कर बाद हम ओखर संग खायन पियन। ");
INSERT INTO bhu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","अउ ऊ हमही आदेस देथै, कि हम मनसेन हे परचार करी अउ गवाही दइ कि हइ उहै हबै, जेही भगवान जिन्दा अउ मिरतू के नियाव करै बाले नियुक्त करे हबै। ");
INSERT INTO bhu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ओखर बारे हे सगलू ग्यानी मनसे गवाही देथै, कि जउन कउ यीसु हे बिस्वास करी, उके ओखर नाम के दवारा पापन के छमा मिलही। ");
INSERT INTO bhu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पतरस हइ बात कहत रहै कि पवितर आतमा उन सगलू हे उतर आइस, जउन ओखर संदेस सुनथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","अउ जेतका सुध्दिकरन खतना करे हर पतरस के संग आय हर यहूदी बिस्वासी हइ देखके चकित रह गइन, कि पवितर आतमा के बरदान गैर यहूदिन हे उडेले गइस। ");
INSERT INTO bhu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","काखे उन गैर यहूदिन के अपन भासा हे बोलत अउ भगवान कर महिमा करत सुनथै, तब पतरस कथै। ");
INSERT INTO bhu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","हइ मनसे हमर जसना पवितर आतमा पाय हबै, ता का कउनो उके पानी के बतिस्मा देय लग मना कर सकथै? ");
INSERT INTO bhu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","अउ पतरस आदेस दइस कि उन यीसु मसीह के नाम हे बतिस्मा ले, ता उन पतरस लग हइ बिनती करिस, तै कुछ रोज हमर इहां रहबे। ");
INSERT INTO bhu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","चेला अउ यहूदिया परदेस के बिस्वासी भाई बेहन के पता चलिस, कि गैर यहूदी भगवान कर बचन स्वीकार कर लय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","जब पतरस यरुसलेम पहुंचथै, जउन बिस्वासी सुध्दिकरन खतना बिरोध हे रथै, उन ओखर बिरोध करिन। ");
INSERT INTO bhu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","तै खतना रहित मनसे के संग, इहां जाय तै उनखर संग खाना खाय रहिन। ");
INSERT INTO bhu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","हइ बात हे पतरस सही हे सुरु लग जउन कुछु घटे रथै, उहै सुनिस अउ उके समझाउत कथै। ");
INSERT INTO bhu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","मै याफा सहर छो बिनती करत आतमा लग भरे रहिस अउ अक्ठी दरसन देखिस, कि अक्ठी चीज भेजिस चदरा कर जसना चउगिरदा छोर लग लटकरे हर बादर लग उतर के मोर लिघ्घो आथै। ");
INSERT INTO bhu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","जब मै ओही धियान लग देखो, ता ओहमा भुंइ के चवपाई अउ बनपसु अउ रेंगय बाले जानबर अउ बादर कर चिरइया देखव, ");
INSERT INTO bhu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","अउ हइ आरो सुनथै, हे पतरस ठाड हो मार अउ खा। ");
INSERT INTO bhu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","पय मै कथो, परभु निस्चित रूप लग नेहको, काखे मै कबहुन कउनो के बेकार अउ असुध्द खाना के नेहको खायन। ");
INSERT INTO bhu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","दूसर बार फेरै बादर लग आरो सुनाई दइस, जेही भगवान सुध्द ठहराय हबै, उके तै असुध्द झइ समझ। ");
INSERT INTO bhu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","तीसर बार असना होथै, तब सगलू कुछ फेर बादर हे खींच लय जथै। ");
INSERT INTO bhu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","अउ देखा जल्दी तीनठे मनसे जउन कैसरिया ले मोर लिघ्घो पठोय गय रथै, ऊ घर हे जेहमा हम रहन, आयके ठाड रहिन। ");
INSERT INTO bhu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","आतमा मोर लग उनखर संग बिना डरे जायके कथै, हइ याफा के छह भाई मोर संग गइन अउ हम ऊ मनसे के घर के भित्तर गयन। ");
INSERT INTO bhu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ऊ हमके गुठेइस, कि ऊ अक्ठी स्वरगदूत के अपन घर हे ठाडे देखव, जउन याफा नगर हे मनसे पठो कि समोन जउन पतरस कहलाथै, बुलवा। ");
INSERT INTO bhu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ऊ तुम्हर लग असना बात गुठेही, जेखर दवारा तै अउ तोर सगलू बिरादरी मुकति पइहिन। ");
INSERT INTO bhu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","जब सुरु करिस, ता पवितर आतमा उनखर उप्पर उतर आइस, ओसनेन जसना सुरु लग हमर उप्पर उतरे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तब मोके परभु के ऊ बचन सुरता आथै, जउन ऊ गुठे रहिस, यूहन्ना तो पानी लग बतिस्मा दइस, पय तुम पवितर आतमा ले बतिस्मा पइहा। ");
INSERT INTO bhu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","मतलब जब भगवान गैर यहूदी के दान दय हबै, जउन हमके परभु यीसु मसीह हे बिस्वास करै लग मिले रहिस, ता मै कउनो होतो जउन भगवान के रोक सकथै? ");
INSERT INTO bhu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","हइ बात सुनके बुराई करै के बन्द कर देथै अउ भगवान के बडाई करके गुठेय लागथै, तब तो भगवान गैर यहूदिन के जीवन के निता मन बदलै के दान दय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","जउन मनसे ऊ दुख के मारे जउन स्तिफनुस के जसना पडे रहिस, जउन बिस्वासी छिदिर बिदिर हुइ गय रथै, ऊ घूमत फीनीके अउ साइप्रस अउ अन्ताकिया हे पहुंचथै, पय यहूदी के छांडके कउनो अउ के संदेस नेहको सुनथै। ");
INSERT INTO bhu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","इहै बिस्वासी मसे कुछ साइप्रस अउ कुरेनी के रथै, इहैनिता जब ऊ अन्ताकिया छो आयके यूनानियन के परभु यीसु के संदेस के सुनामै लगिन। ");
INSERT INTO bhu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","परभु के सक्ति उनखर हे रथै अउ बोहत मनसे बिस्वास करके परभु के पल्ला फिरै। ");
INSERT INTO bhu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","जब ओखर बात यरुसलेम नगर के मंडली के सुनै हे आथै, ता उन बरनबास के अन्ताकिया पठोथै। ");
INSERT INTO bhu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","उहां पहुंच के अउ भगवान कर अनुगरह के देखके मगन होथै अउ सगलू के सिक्छा देथै, कि तन मन लगाय के परभु लग लिपटे रइहा। ");
INSERT INTO bhu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","काखे बरनबास अक्ठी निक्खा मनसे रथै अउ पवितर आतमा अउ बिस्वास ले परिपून रथै अउ दूसर मनसे परभु हे आयके मिलथै। ");
INSERT INTO bhu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","तब ऊ साऊल के खोजय के निता तरसुस छो पठोय देथै। ");
INSERT INTO bhu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","जब ऊ ओखर लग मिलथै, ता उके अन्ताकिया छो लानथै अउ असना होथै, कि ऊ अक साल तक मंडली के संग मिलथै अउ बोहत मनसेन के संदेस देत रथै अउ चेला सब लग आगुन अन्ताकिया हे मसीही कहलाथै। ");
INSERT INTO bhu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","उहै रोज हे कइन झन ग्यानी मनसे यरुसलेम नगर ले अन्ताकिया छो आथै। ");
INSERT INTO bhu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","उनखर मसे अगबुस नाम अक्ठी मनसे ठाड हुइके पवितर आतमा के अगुवाई लग आगू कर बात गुठेथै, कि सगलू दुनिया हे बोहत भुखमरी होही, ऊ भुखमरी क्लोदियुस कर टेम हे हुइस। ");
INSERT INTO bhu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ता चेला फइसला लेथै, कि सबझन अपन पइसा के जसना यहूदिया हे रहै बाले भाई के मदद के निता कुछ पठोमै के निस्चित करथै। ");
INSERT INTO bhu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","इहैनिता उन ओसनेन करिन अउ उन बरनबास अउ साऊल के हाथ अपन सियानन के लिघ्घो दान भेजिन। ");
INSERT INTO bhu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ऊ टेम हेरोदेस राजा मंडली के कइझन मनसेन के सतामै के सुरु करथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ऊ यूहन्ना कर भाई याकूब के तलबार लग मरवा डारिस। ");
INSERT INTO bhu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","जब ऊ देखथै, कि यहूदी मनसे एखर लग मगन होथै, ता ऊ पतरस के पकड लेथै। अउ ऊ रोज अखमीरी रोटी के तेउहार के दिनन के बात हबै। ");
INSERT INTO bhu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ऊ उके पकड के जेल हे बेडथै अउ चार-चार सिपाही के चार पहर हे रखथै, ओखर उप्पर नियाव करै के निता तेउहार कर बाद उके मनसेन के आगू बाहिर लानै। ");
INSERT INTO bhu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","जेल हे पतरस के बेडे रथै, पय मंडली ओखर निता भगवान लग बिनती करत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","जब हेरोदेस राजा उके मनसेन कर आगू लामै के रथै, उहै रात पतरस दुइठे सांकड ले बंधररे हर दुइठे सिपाही के बीच हे सोउत रथै अउ सेबकन के दूरा हे जेल कर लिघ्घो सेना नायक देख-रेख करत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ता देखा परभु कर अक्ठी स्वरगदूत आयके ठाड होथै अउ अचानक जेल के कोठा हे, उजियार भर गइस अउ पतरस के पसली हे हाथ मारके उके जगाथै अउ कथै ठाड हो हरबी चल अउ ओखर हाथन लग सांकड उघर के गिर पडथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","तब स्वरगदूत ओखर लग कथै, कमर बांध अउ अपन बूट पहिन ले। ऊ ओसनेन करथै, ऊ अपन खुरथा पइजामा पहिन के मोर पाछू होय ले। ");
INSERT INTO bhu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ऊ निकरके ओखर पाछू हुइ लेथै, पय हइ नेहको जानथै, कि जउन कुछ स्वरगदूत करथै, ऊ सही हबै, मै हइ समझो कि सपना देखथो। ");
INSERT INTO bhu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","तब आगुन अउ दूसर पहर हे निकर के ऊ लोहा कर फेरका छो जथै, जउन सहर के पल्ला हबै, ऊ उनखर निता अपने अपन उघर जथै अउ ऊ निकरके अक्ठी गली हुइ के जथै अउ जल्दिन स्वरगदूत उके छाडके कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","फेर पतरस के जसना होस आइस, ऊ बोलिस “अब मोर समझ हे आय हबै, कि हइ सही हे सही हबै, कि परभु अपन स्वरगदूत के पठोय के हेरोदेस के सक्ति लग मोके छंडाय हबै अउ यहूदी मनसे मोर उप्पर जउन कुछु घटै के सोचथै, ओखर लग उहै मोके बचाय हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","हइ बात जानके ऊ यूहन्ना कर दाय मरियम के घर छो आथै, जउन मरकुस कहाथै, उहां बोहत लग मनसे अक जिघा हुइके बिनती करत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","जब ऊ फेरका के कंवाड ठोकठोकाथै, ता रूदे नाम के अक्ठी हरवाहिन देखै के आथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","पतरस के आरो चीन्ह के ऊ खुसी कर मारे फेरका के कंवाड नेहको उघारथै, पय दउडके भित्तर जथै अउ गुठेथै, कि पतरस दूरा हे ठाडे हबै। ");
INSERT INTO bhu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","उन ओखर लग बोलथै, “तय पगला गय हबस।” पय ऊ पूर बिस्वास रथै, कि हइ ओसनेन हबै हइ बात हे उन कथै, “ऊ ओखर स्वरगदूत होही।” ");
INSERT INTO bhu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","उछो पतरस फेरका के कंवाड ठोकठोकाउत रथै, मतलब ऊ कंवाड उघारथै अउ उके देखके चकित रहि जथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","तब ऊ उनही हाथ लग इसारा करथै, कि सान्त रइहा अउ उनही गुठेथै, कि परभु कउन मेर लग मोके जेल लग निकार लाय हबै, फेर कथै याकूब अउ बोहत बिस्वासी भाई के हइ बात गुठे देबे, तब निकर के दूसर जिघा कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","मुरगोसा सुपाहिन हे बोहत हलचल मच जथै, कि पतरस के काहिन हुइस? ");
INSERT INTO bhu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","एखर बाद हेरोदेस राजा पतरस के खोज करै के आदेस देथै, पय उके नेहको खोज पाथै, ता ऊ सिपाही लग पुछिन जानिन अउ उनही मार डालै के आदेस देथै। हेरोदेस राजा यहूदिया लग जायके कैसरिया हे रहै लागथै अउ उहां ऊ कुछ रोज गुजारिस। ");
INSERT INTO bhu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हेरोदेस राजा सूर अउ सैदा के मनसेन लग बोहत गुस्साय रथै। ऊ अक्ठी समूह बनाय के ओखर लग मिलै आइन, राजा कर खास करमचारी बलास्तुस के समझाय के उन हेरोदेस लग सान्ति के बिनती करिन, काखे उनखर देस कर राजा के देस लग खाना खाय के मिलथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","अक्ठी निस्चित रोज हेरोदेस अपन राज खुरथा पइजामा पहिन के अपन राज गद्दी हे बइठिस अउ मनसेन के उपदेस देय लगथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ता मनसे चिल्लाथै, “हइ तो कउनो देउता के आरो हबै मनसेन कर नेहको।” ");
INSERT INTO bhu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","उहै टेम परभु के अक्ठी स्वरगदूत हरबी उके मारथै, काखे ऊ भगवान के महिमा नेहको देथै अउ ऊ किरवा पर के मर जथै। ");
INSERT INTO bhu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","पय भगवान के बचन बढत अउ बगरत गइस। ");
INSERT INTO bhu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","जब बरनबास अउ साऊल अपन सेबा पूर कर चुकथै, ता यूहन्ना के जउन मरकुस कहलाथै, संग लइके यरुसलेम नगर छो लउटथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अन्ताकिया के मंडली हे बोहत ग्यानी मनसे रथै, जसना बरनबास अउ समोन नीगर कहलाथै अउ लूकियुस कुरेनी अउ चवथाई देस के राजा हेरोदेस के निजी माना अउ साऊल। ");
INSERT INTO bhu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","जब ऊ उपास सहित परभु लग बिनती करथै, ता पवितर आतमा कथै, मोर निता बरनबास अउ साऊल के अक्ठी खास काम के निता बुलाय हबै, उके मोर निता अलगे करा। ");
INSERT INTO bhu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","तब उन उपास अउ बिनती करके अउ साऊल हे हाथ धरके उनही बिदा करथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","हइमेर पवितर आतमा के दवारा पठोय हर सिलूकिया बन्दरगाह छो जथै, अउ उहां ले जिहाज हे चढके साइप्रस दीप छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","अउ सलमीस हे पहुंच के भगवान के सब्द यहूदी के मंडली हे सुनाथै, यूहन्ना, उनखर हरवाह रथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","उन पूर टापू के दउरा करै के बाद हे पाफुस आइन, उहां यीसु नाम के अक्ठी यहूदी जादूगर अउ ठगरा ग्यानी मनसेन लग उनखर मुलाखात हुइस, ");
INSERT INTO bhu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ऊ हाकिम सिरगियुस पोलुस के संग रथै। जउन होसियार डउका रथै। ऊ बरनबास अउ साऊल के अपन लिघ्घो बुलाय के भगवान के बचन सुनामै चाहथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","पय इलीमास टोनहा काखे कि इहै ओखर नाम के मतलब हबै, ओखर बिरोध करके राजपाल के बिस्वास के रोकै चाहथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","तब साऊल जेखर नाम पोलुस हबै, पवितर आतमा ले परिपून हुइके, ओखर हे नजर लगाइस। ");
INSERT INTO bhu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","हे सगलू कपट अउ सगलू चतुराई ले भरे हर भुतवा कर टोरवा, तै हर अक्ठी निक्खा बात के बैरी हबस, काखे तै परभु के सिध्धा रास्ता के टेढवा करै के नेहको छांडही? ");
INSERT INTO bhu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","अब देख परभु के हाथ तोर बिरोध उठे हबै अउ कुछ टेम इलीमास अंधरा हुइहे अउ दिन के बेरा के नेहको देखहे, तब जल्दी धुंधलापन अउ अंधियार ओखर हे छाय जथै अउ ऊ इछो-उछो टटोलय लागथै, ताकि कउ ओखर हाथ पकरके उके लइ जाय। ");
INSERT INTO bhu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","तब हाकिम जउन होथै, उके देखके अउ परभु के उपदेस ले बोहत चकित हुइ के बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पोलुस अउ ओखर संगी पाफुस ले जिहाज रुके पंफूलिया के पिरगा छो आथै, अउ यूहन्ना उनही छाडके यरुसलेम नगर छो लउट जथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","पिरगा ले आगुन बढके ऊ पिसिदिया के अन्ताकिया छो पहुंचथै, अउ सुस्ताय कर रोज यहूदी मंडली हे जाय के बइठ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","नियम अउ ग्यानी मनसेन के किताब लग पढै के बाद यहूदी मंडली के सरदार उनखर लिघ्घो संदेस पठोथै, हे भाइयो यदि मनसे खुसी के निता तुम्हर मन हे कउनो बात हबै, ता गुठेवा। ");
INSERT INTO bhu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","हइ बात हे पोलुस ठाड होथै अउ अपन हाथ लग इसारा करके कथै, हे इस्राएल के मनसे अउ भगवान के महिमा करै बाले अउ डरै बाले गैर यहूदी सुना। ");
INSERT INTO bhu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इस्राएल के भगवान हमही चुनिस, जब हमर मनसे मिस्र हे ठहरे रथै, ऊ उनही महान देस बनाथै अउ महासक्ति लग ऊ उके बाहिर छो निकाडथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ऊ चालीस साल तक पटउरा जिघा हे उन सहत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","अउ कनान देस हे सातठे जातिन के नास करके धरती इस्राएल के मनसे के अधिकारी के रूप हे दइ देथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","हइ सगलू कुछु करीबन साढे चार सव साल लगिस, एखर बाद समूएल ग्यानी मनसेन तक उनही नियाव करै बालेन के चुनिस। ");
INSERT INTO bhu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","फेर उन अक्ठी राजा के मांग करिस, तब भगवान चालीस साल के निता बिन्यामीन के कुर अक्ठी मनसे कीस कर टोरवा साऊल के चुनथै जउन राज करथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","फेर भगवान उके हटाय के दाऊद के उनखर राजा बनाइस अउ उनखर बारे हे हइ गवाही दइस, मोके अपन मन के अनुरूप अक्ठी मनसे इसै कर टोरवा दाऊद मिल गइस, ऊ मोर सब इक्छा पूर करी। ");
INSERT INTO bhu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","भगवान अपन टीमा के जसना उके दाऊद के घराना हे इस्राएल के निता अक्ठी मुकति करै बाले मतलब यीसु के पइदा करिस। ");
INSERT INTO bhu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","यीसु के आमै ले आगुन यूहन्ना सगलू इस्राएल के सगलू परजा के मन बदलै के बतिस्मा के परचार करथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","जब यूहन्ना अपन सेबा पूर करै बाले रथै, ता ऊ कथै, तुम मोके काहिन समझथा? मै ऊ नेहको पय देखा, मोर बाद अक्ठी आमै बाले हबै, जेखर गोड के बूट के डोरा के मै खोलै के काबिल नेहको हबो। ");
INSERT INTO bhu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","हे इस्राएली भाइयो, अब्राहम कर टोरवा अउ सगलू भगवान के महिमा करै बाले अउ डरै बाले गैर यहूदिया मुकति कर संदेस हमर लिघ्घो पठोय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","काखे कि यरुसलेम नगर के रहै बाले अउ उनखर मुखिया उके नेहको चीनथै अउ न ग्यानी मनसे के बात समझथै, जउन सुस्ताय कर रोज पढ के सुनाय जथै, इहैनिता उके दोसी ठहराय के हइ बातन के पूर करथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","अउ उनही मिरतू के सजा देय के कारन नेहको मिलथै, तउ उन पिलातुस लग उके मरवा डारै के मांग करथै कि उके मार डारे जाय। ");
INSERT INTO bhu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","जब उन ओखर बारे हे पवितर किताब हे जउन लिखवरे हबै, ऊ सगलू बात पूर करथै, ता उके क्रूस ले उतार के मरघटी हे धर देथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","पय भगवान यीसु के मिरतू के बाद फेरै लग जिन्दा करिस। ");
INSERT INTO bhu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","पय फेर ऊ बोहत रोज तक ऊ उनखर बीच हे परगट होत रहिस, जउन गलील लग यरुसलेम तक उनखर संग रथै अउ अब उहै इस्राएली मनसेन के निता उनखर गवाह हबै। ");
INSERT INTO bhu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","हम तुमके हइ संदेस सुनाथन, कि भगवान हमर सियानन लग जउन टीमा करे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","यीसु के मर जाय के बाद फेरै जिन्दा करके उनखर लरकन के निता भगवान उहै टीमा के हमर निता पूर करिस, जसना कि भजन संहिता के दूसर भजन हे लिखवरे हबै, तै मोर टोरवा हबस, आज तोर बाफ बने हबो। ");
INSERT INTO bhu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","अउ ओखर हइ मेर लग मरे हर मसे जिन्दा करै के बारे हे कि ऊ देह कबहुन झइ सडही ऊ हइ कथै, मै दाऊद हे पवितर अउ अटल आसीस देहुं, जेखर टीमा मै दाऊद लग करे रहों। ");
INSERT INTO bhu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","इहैनिता ऊ अक्ठी अउ दूसर भजन हे गुठे हबै, तै अपन पवितर जन के सरै नेहको दइहे। ");
INSERT INTO bhu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","फेर दाऊद अपन टेम हे भगवान के मकसद के जसना अपन सेबा के काम पूर करके मरिस, ओखर पुरखा के संग गाडे गइस अउ ओखर देह सर गइस। ");
INSERT INTO bhu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","पय जेही भगवान फेरै जिन्दा करे हबै, ऊ सरै नेहको पाइस। ");
INSERT INTO bhu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","हे इस्राएली भाइयो तुम जान लेया उहै के दवारा ओखर उप्पर बिस्वास करथै, ऊ अपन पाप लग छमा पाथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","हे इस्राएली भाइयो, तुमके जान लेय चाही कि यीसु के दवारा पापन के छमा के उपदेस तुमके दय गय हबै, अउ इहै के दवारा हर कउ जउन बिस्वास करथै, ऊ पाप लग मुकति पा सकथै, जउन मूसा कर नियम मुकति नेहको दइ सकथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","इहैनिता सचेत रहा, जउन ग्यानी मनसे कहे रथै ऊ तुम्हर हे झइ घटै। ");
INSERT INTO bhu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","हे बुराई करै बाले मनसे देखा, बोहत चकित हुइके मर जा, काखे जउन आज मै करथो, अउ तुमके समझाय, भरमा बिस्वास नेहको करथा। ");
INSERT INTO bhu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","जब पोलुस अउ बरनबास उहां लग जथै, ता मनसे आगू सुस्ताय कर रोज असना अउ बात गठेमै के बिनती करिन। ");
INSERT INTO bhu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","जब सभा खतम हुइस, ता बोहत गैर यहूदी मनसे भक्त पोलुस अउ बरनबास के पाछू हुइ लेथै, पोलुस अउ बरनबास उनखर लग बात चीत करत बिनती करिस कि भगवान कर अनुगरह हे लगेतार जीवन बिताबा। ");
INSERT INTO bhu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","आगू सुस्ताय कर रोज के परभु के बचन सुनै के निता लगभग सगलू नगर उमड पडिन। ");
INSERT INTO bhu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","पय यहूदी भीड के देखके जलन लग भर जथै, पोलुस जउन कुछु कथै, ऊ बात हे बुराई करै लग जथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","तब पोलुस अउ बरनबास निडर हुइके कथै, जरूरी रहिस कि भगवान कर बचन आगू तुमके सुनाय जथै, पय जब तुम उके दूर हटाथा अउ अपन के सबरोज कर जीवन के जसना नेहको ठहराथा, देखा हम गैर यहूदी के पल्ला फिरथन। ");
INSERT INTO bhu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","काखे कि परभु हमके हइ आदेस दय हबै, मै तोके गैर यहूदी के निता ज्योति ठहराय हबो, ताकि तै भुंइ के छोर तक मुकति के दूरा हबै। ");
INSERT INTO bhu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","हइ बात सुनके गैर यहूदी खुस होथै अउ परभु के बचन के बडाई करै लग जथै, अउ जेतका अनन्त जीवन के निता ठहराय गय रथै, उन बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","तब परभु के बचन ऊ सगलू देस हे बगरै लागथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","हर रोज भगवान कर महिमा करै बाले यहूदिया डउकी अउ सहर के खास मनसे उकसाइन अउ पोलुस अउ बरनबास के बिरोध उपद्रव करवाय के उनही अपन सीमा ले निकाड देथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","हे पोलुस अउ बरनबास उनखर बिरोध हे अपन गोड के धूधुर झार के इकुनियुम छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","चेला मगन अउ पवितर आतमा लग भरपूर हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","इहैमेर असनेन घटना इकुनियुम हे घटिस, पोलुस अउ बरनबास इकुनियुम मंडली हे गइन, उन हइ मेर के बात करिन कि बोहत लग गिनती हे यहूदी अउ यूनानी बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","पय जउन यहूदी बिस्वास नेहको करथै, उन गैर यहूदिन के भडकाथै अउ उनखर मन हे बिस्वास करै बाले भाई बेहन के परति दोस भर देथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","अउ बोहत रोज तक उहां रथै अउ परभु के भरोसा हे हियाव लग बात करथै, अउ ऊ उनखर हाथ ले चिन्हा अउ अदभुत काम करवाय के अपन अनुगरह के सब्द हे गवाही देथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","पय सहर के मनसे हे फूट पड जथै, एखरै ले केतका तो यहूदी के पल्ला अउ केतका तो चेलन के पल्ला हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","फेर जब गैर यहूदी सरदार अउ यहूदी अपन नेतन के संग मिलके उनखर संग बेकार बेउहार करै के अउ उनखर उप्पर पथरा मारै के चाल चलिन। ");
INSERT INTO bhu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ता ऊ हइ बात के जान जथै, अउ लुकाउनिया के लुस्तरा अउ दिरबे नगर हे अउ अगल बगल के परदेस हे भाग जथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","अउ यीसु कर सुभ संदेस के परचार करथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्तरा हे अक्ठी मनसे बइठे हर रथै, ऊ अपन गोड लग लेंगरा रथै अउ पइदाइसी लग लेंगरा रथै, रेंगय-बागय के कबहुन नेहको पाइस। ");
INSERT INTO bhu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","अउ पोलुस के बात के बोलत सुनथै, ऊ ओखर पल्ला टकटकी लगाय के देखथै, कि उके निक्खा हुइ जाय के बिस्वास हबै। ");
INSERT INTO bhu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","अउ बोहत आरो लग कथै, अपन गोड के बल सीधा ठाड हुइ जा, तब ऊ उछल के रेंगै-बागै लागिस। ");
INSERT INTO bhu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","मनसे पोलुस के काम के देखके लुकाउनिया के भासा हे पुकार के कहे लगिस, देउता उनखर रूप हे हुइ के हमार लिघ्घो उतर आय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","उन बरनबास के ज्यूस अउ पोलुस के हिरमेस कथै, काखे कि ऊ बात करै हे मुखिया रथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ज्यूस के ऊ मन्दिर के पुजारी जउन उनखर नगर के आगू रथै, बइला फूलन के माला फेरका हे लायके मनसेन के संग बलि करै चाहथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","पय चेला बरनबास अउ पोलुस हइ सुनिन ता उन अपन बन्डी चीर डारिन अउ ऊ बोहत आरो हे हइ कथै, भीड हे गुस जथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“हे संगी, तुम हइ काखे करथा? हमु उहै मनसे हबन, जसना तुमो हबा, इहां हम तुमके संदेस सुनामै आय हबन, ताकि हइ बेकार बातन लग मुडके ऊ जिन्दा भगवान के पल्ला लउटा जउन स्वरग, भुंइ, सागर अउ एहमा जउन कुछु हबै सगलू के बनाय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","गुजरे हर टेम हे ऊ सगलू मनसेन के उनखर अपन-अपन रास्ता हे चल दइन। ");
INSERT INTO bhu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","पय तुमके ऊ अपन खुद अपन गवाह देय बिगर नेहको छांडिस। काखे ऊ तुम्हर संग भलाई करिस, ऊ बादर लग पानी दइस अउ मउसम के जसना फसल दइस, ऊ तुमही भोजन देथै अउ तुम्हर मन के खुसी लग भर देथै।” ");
INSERT INTO bhu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","हइ गुठे के उन मनसेन के बडी परेसानी लग रोकथै, कि उनखर निता बलि नेहको करै। ");
INSERT INTO bhu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","पय कुछ यहूदी अन्ताकिया सहर अउ इकुनियुम लग आयके मनसेन के अपन पल्ला कर लेथै अउ पोलुस के पथरा मारथै, अउ मरे हर समझ के उके नगर के बाहिर छो किढलाय के लइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","पय जब चेला ओखर चउगिरदा पल्ला आयके ठाड होथै, ता ऊ उठके नगर छो लउट गइस अउ दूसर रोज बरनबास के संग दिरबे छो कढ गइस। ");
INSERT INTO bhu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","पोलुस अउ बरनबास ऊ सहर के मनसेन के संदेस सुनाय के अउ बोहत लग चेला बनाय के, लुस्तरा अउ इकुनियुम अउ अन्ताकिया छो लउट आथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","अउ चेला के बिस्वास के स्थिर करत रथै अउ हइ उपदेस देथै, कि बिस्वास हे बने रहा अउ हइ कहत सिखाथै, हमके बोहत दुख उठाय के भगवान कर राज हे परवेस करै के होही। ");
INSERT INTO bhu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","उन हर मंडली हे सियानन के चुनिस अउ उपास सहित बिनती करके उनही परभु के हाथ हे सउप दइस जेहमा उन बिस्वास करे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","तब पिसिदिया परदेस पार करके पंफूलिया परदेस छो पहुंचथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","फेर पिरगा नगर हे बचन सुनाय के अत्तलिया नगर छो आथै। ");
INSERT INTO bhu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","अउ उहां ले ऊ नाह जिहाज हे अन्ताकिया छो जथै, जिहां ऊ उस काम के निता जउन ऊ पूर करै रथै, भगवान कर अनुगरह हे सउपे गय रहै। ");
INSERT INTO bhu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","जब ऊ अन्ताकिया पहुंचथै, ता उन मंडली के मनसेन के अकजुट करिन, जउन कुछ भगवान उनखर संग करे रथै, ओही सगलू बात के सुनाइन अउ भगवान घोसना करिस, कि भगवान गैर यहूदिन के निता बिस्वास के दूरा उघार दय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","अउ उन चेला के संग बोहत रोज तक रथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","फेर कुछ मनसे यहूदिया ले आयके भाइयो के सिखामै लागथै, अगर मूसा कर रीति तुम्हर सुध्दिकरन नेहको होय ता तुम मुकति नेहको पाय सकथा। ");
INSERT INTO bhu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","जब पोलुस अउ बरनबास के उनखर लग बोहत झगडा अउ बाद बिबाद होथै, ता हइ नेहको ठहराय जथै कि पोलुस अउ बरनबास अउ उनखर मसे कुछ मनसे हइ बात के बारे हे चेला अउ सियानन के लिघ्घो यरुसलेम छो जाय। ");
INSERT INTO bhu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","मंडली उहां लग कुछ दुरिहां तक पहुंचाथै अउ उन फीनीके अउ सामरिया ले होत गैर यहूदिन के मन फिरामै के संदेस सुनाउत जथै अउ सगलू भाई बोहत मगन होथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","जब यरुसलेम छो पहुंचथै, ता मंडली अउ चेला सियान उनखर लग खुसी के संग मिलथै अउ उनही गुठेथै कि भगवान उनखर संग हुइके कसना काम करे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","पय फरीसिन के पंथ मसे जउन बिस्वास करे रथै, उन मसे कुछ ठाड हुइके कथै, उनही सुध्दिकरन करामै अउ मूसा कर नियाव के आदेस देय के चाही। ");
INSERT INTO bhu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","तब चेला अउ सियान हइ बात के बारे हे बिचार करै के निता अकजुट होथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","तब पतरस बोहत बात बिबाद हुइ जाय के बाद ठाड हुइके उनखर ले कथै, हे भाइयो तुम जानथा कि बोहत रोज हुइस, भगवान तुम मसे मोके चुने हबै कि मोर मुंह ले गैर यहूदी संदेस के बचन सुनके बिस्वास करै। ");
INSERT INTO bhu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","मन के जांचै बाले भगवान उनही हमार जसना पवितर आतमा दइके उनही गवाही देथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","अउ बिस्वास के दवारा उनखर मन सुध्द करके हमर हे अउ उनखर हे कुछु भेद नेहको रथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ता अब तुम काखे भगवान के परिक्छा करथा कि चेला के नटेरी हे जिम्मेदारी के जुंवा धरै के सक्ति रहिस, जेही न हमर दाय-बाफ उठाय सकिन अउ न हम उठाय सकथन। ");
INSERT INTO bhu_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","हव हमार हइ बिस्वास हबै कि जउन रीति ले उन परभु यीसु के अनुगरह ले मुकति पइहिन उहै रीति ले हमु पाबो। ");
INSERT INTO bhu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","तब सगलू सभा चुपचाप बरनबास अउ पोलुस के बात सुनै लागथै, कि भगवान उनखर दवारा गैर यहूदी हे कसना बडे चिन्हा अउ अदभुत काम दिखाय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","जब ऊ चुप रथै ता याकूब गुठे लागथै, “हे भाइयो, मोर बात सुना। ");
INSERT INTO bhu_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","समोन गुठेइस कि भगवान आगू पहले गैर यहूदी हे कसना किरपा दया हबै, कि उनखर मसे अपन नाम के निता अक्ठी मनसे बनाय लेया। ");
INSERT INTO bhu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","एखर लग ग्यानी मनसे के बात मिलथै, जसना कि लिखे हबै,” ");
INSERT INTO bhu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","एखर बाद मै फेर आयके, दाऊद के गिरे हर जिघा उठाहुं, अउ ओखर खंडहर के फेरै बनाहुं, अउ उके ठाड करहुं। ");
INSERT INTO bhu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","इहैनिता कि बचे हर मनसे मतलब सगलू, गैर यहूदी जउन मोर नाम के कहाथै, परभु के खोजथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","हइ उहै परभु गुठेथै, जउन जगत हे सुरुवात ले इन बातन के संदेस देत आय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","इहैनिता मोर बिचार हइ हबै कि गैर यहूदिन मसे जउन मनसे भगवान के पल्ला फिरथै, हम उनके दुख नेहको दइ, ");
INSERT INTO bhu_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","पय उनही लिख के भेजथै, कि उन मूरती के असुध्द अउ गलत काम अउ गला घोटे हर के मांस ले अउ खून ले दुरिहां रहबे। ");
INSERT INTO bhu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","काखे प्राचीन काल ले नगर मूसा कर नियाव के परचार करै बाले चले आथै अउ ऊ हर सुस्ताय कर रोज मंडली हे पढे जथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","तब सगलू मंडली सहित चेला अउ सियान के निक्खा लागथै, कि अपन मसे कुछ मनसेन के चुनै, मतलब यहूदा जउन बरसब्बा कहाथै अउ सीलास के जउन भाइन मसे मुखिया रथै अउ उनही पोलुस अउ बरनबास के संग अन्ताकिया छो पठोथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","उन उनखर हाथ हे लिख के पठोथै, “अन्ताकिया अउ सीरिया अउ किलिकिया के रहै बाले भाइन के जउन गैर यहूदी मसे हबै, चेला अउ सियान भाइन के नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","हम सुने हबन कि हमर मसे कुछ मनसे उहां जाय के, तुमही अपन बातन ले धकपकाय देथै अउ तुम्हर मन उलट दय हबै, पय हम उनही आदेस नेहको देथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","इहैनिता हम अकचित सही समझे कि चुने मनसेन के अपन पिरिया बरनबास अउ पोलुस के संग तुम्हर लिघ्घो पठोबै। ");
INSERT INTO bhu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","हइ असना मनसे हबै, जउन अपन जीवन हमार परभु यीसु मसीह के नाम के निता दिग्गत हे डाले हबै। ");
INSERT INTO bhu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","इहैनिता हम यहूदा अउ सीलास के पठोय हबै, जउन अपन मुंह लग हइ बात गुठे देबो। ");
INSERT INTO bhu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","पवितर आतमा के अउ हमके सही जान पडिस कि हइ जरूरी बात के छांड के तुम अउ चिन्ता हे झइ डालै। ");
INSERT INTO bhu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","तुम मूरतिन अउ बलि करे हर ले अउ खून ले अउ नटेरी घोटे हर के मास ले अउ गलत काम बाले डउकी ले दुरिहां रइहा। एखर ले दुरिहां रहा ता तुम्हर भला होही। आगू सुभ।” ");
INSERT INTO bhu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","फेर उन बिदा हुइके अन्ताकिया पहुंचथै अउ बइठक के अक जिघा करके ऊ चिट्ठी उनही दइ देथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","उन चिट्ठी पढ के ऊ उपदेस के बात ले अति मगन होथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहूदा अउ सीलास जउन खुद ग्यानी मनसे रथै, बोहत बातन ले भाइन के सिक्छा दइके स्थिर करथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","उन कुछ रोज रहके भाइन ले सान्ति के संग बिदा होथै, कि अपन पठोय बाले के लिघ्घो जाय। ");
INSERT INTO bhu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","पय सीलास उहां रहै के निक्खा लागथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","पय पोलुस अउ बरनबास अउ अन्ताकिया हे रह जथै, अउ दूसर बोहत ले मनसेन के संग परभु के बचन के उपदेस करत अउ संदेस सुनाउत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","कुछ रोज बाद पोलुस बरनबास लग कथै, जउन नगर हे हम परभु के बचन सुनाय रहन, आबा फेर ओहमा रेंगके अपन भाइन के देखी कि उन कसना हबै। ");
INSERT INTO bhu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","तब बरनबास यूहन्ना के जउन मरकुस कहाथै, संग लेय के बिचार करथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","पय पोलुस उके जउन पंफूलिया हे उनखर ले अलगे हुइ जथै अउ काम उनखर संग नेहको करथै, संग लेय जाय का निक्खा नेहको समझथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","मतलब असना बिबाद उठथै, कि उन अक दूसर लग अलगे हुइ जथै अउ बरनबास, मरकुस के लइके जिहाज हे साइप्रस छो कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पय पोलुस सीलास के चुन लेथै अउ भाइन ले परभु के अनुगरह हे सउपे जाय के उहां ले चल देथै। ");
INSERT INTO bhu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","अउ ऊ मंडली के ठाड करत सीरिया अउ किलिकिया लग होत निकरथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","पोलुस दिरबे अउ लुस्तरा छो जथै। उहां तीमुथियुस नाम के अक्ठी चेला रथै, जउन कउनो बिस्वासी यहूदी दाय कर टोरवा रथै, पय ओखर बाफ यूनानी रथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ओखर लुस्तरा अउ इकुनियुम के भाइन हे निक्खा बोल चाल रथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पोलुस तीमुथियुस के अपन संग लइ जाय के चाहथै, इहैनिता उके अपन संग लइ आनथै, ऊ जिघा हे रहै बाले यहूदिन के कारन ओखर सुध्दिकरन करिन, काखे सगलू जानथै कि ओखर बाफ यूनानी हबै। ");
INSERT INTO bhu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","तब नगर हे जात हर उन नियाव के जउन यरुसलेम के चेला अउ सियान निस्चित करे रथै, कि उन मनसे ओखर पालन करै। ");
INSERT INTO bhu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","इहैमेर मंडली बिस्वास हे स्थिर होत गइस अउ संख्या हे रोजदिना बढत गइस। ");
INSERT INTO bhu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","पवितर आतमा पोलुस सीलास अउ तिमोथी के आसिया परदेस हे बचन के परचार करै लग मना करिस, इहैनिता उन फ्रूगिया अउ गलातिया परदेस के दउरा करिस। ");
INSERT INTO bhu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","उन मूसिया के लिघ्घो पहुंच के, बितूनिया इलाका हे जाय चाहथै, पय यीसु के आतमा उनही जाय नेहको देथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","इहैनिता उन मूसिया ले हुइके तरोआस हे आथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","उहां पोलुस रात के अक्ठी दरसन देखथै कि अक्ठी मकिदुनिया के डउका ठाढ होथै ओखर लग बिनती करके कथै, तै समुन्दर “पार के मकिदुनिया हे आ, अउ हमर मदद कर।” ");
INSERT INTO bhu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","हइ दरसन के तुरन्त बाद हइ रास्ता निकारत भगवान मनसेन के बीच संदेस के परचार करै के निता बुलाय हबै, हम मकिदुनिया जाय के ठान लयन। ");
INSERT INTO bhu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","इहैनिता तरोआस लग हम समुन्दर यातरा सुरु करेन, हम जिहाज लग सिध्धा सुमातराके तक गयन अउ दूसर रोज नियापुलिस हे आयन। ");
INSERT INTO bhu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","उहां ले हम फिलिप्पी पहुंचिन, जउन मकिदुनिया प्रान्त के मुख्य नगर अउ रोमियो के बस्ती हबै अउ हम ऊ नगर हे कुछ रोज तक रहन। ");
INSERT INTO bhu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","सुस्ताय कर रोज हम सहर के फेरका के बाहिर नदिया के पाखा हइ समझ के जथन कि उहां बिनती करै के जिघा होही अउ बइठके उन डउकी लग जउन अक जिघा रथै, बात करै लागथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","लुदिया नाम के थुआतीरा सहर के बैगनी कपडा बेचै बाले अउ भगवान कर आराधना करथै, ऊ डउकी हमर बात सुनत रथै। परभु ओखर मन के दूरा खोलथै कि ऊ पोलुस के बातन हे मन खुसी लग सुनै। ");
INSERT INTO bhu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","फेर अपन पूरे घराना सहित बतिस्मा लेय के बाद ऊ हमर लग हइ बिनती करथै, “कि तै मोके परभु के महिमा करै बाले बिस्वासी मानथस, ता आबा मोर घर हे रहा।” इहैनिता ऊ हमके जाय के निता तइयार कर लइस। ");
INSERT INTO bhu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","जब हम बिनती करै के जिघा हे गयन, ता हमके अक्ठी जबान हरवाहिन मिलथै जेहमा आगू कर बात गुठे बाले आतमा रथै अउ भभिस्य गुठेवै लग अपन मालिक कर निता बोहत कुछ कमाथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ऊ पोलुस अउ हमार पाछू आयके चिल्लाय लागथै, “हइ मनसे परम परधान भगवान के हरवाह हबै, जउन हमके मुकति के रास्ता गुठेथै।” ");
INSERT INTO bhu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ऊ बोहत रोज तक असना करत रथै पय आखरी हे पोलुस परेसान हुइ गइस अउ मुडके उस आतमा लग कथै, “मै तोके यीसु मसीह के नाम लग आदेस देथो कि हइ मसे निकड जा।” अउ ऊ उहै टेम उस टोरिया मसे निकड गइस। ");
INSERT INTO bhu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","जब ओखर मालिक देखथै कि हमार कमाई के आसरा खतम हुइ गय, ता पोलुस अउ सीलास के पकडके चउक हे मुखिया के लिघ्घो खींच लइ जथै ");
INSERT INTO bhu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","अउ उनही सिपाहिन के लिघ्घो लइ जथै अउ कथै, “हइ मनसे हमर सहर हे असान्ति फइलाथै हइ यहूदी हबै। ");
INSERT INTO bhu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","अउ हइ रीति रिबाज के परचार करथै, जिनके ग्रहन करै के या मानैके हम रोमन अधिकारी के निता जरूरी नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","तब भीड के मनसे ओखर बिरोध हे अक जिघा हुइ गइन, अउ सिपाही ओखर कपडा चीर डारिन अउ उनके डंडा मारै के आदेस देथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","उन पोलुस अउ सीलास के डंडा लग बोहत मारथै अउ जेल हे बेड देथै अउ उन जेल के दारोगा के आदेस देथै, कि उनही सचेत लग उनखर देखरेख करै। ");
INSERT INTO bhu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","दारोगा असना आदेस पाके उनही जेल के भित्तर कोठा हे रखथै अउ भारी लकडी के कठवा हे गोड के बांध देथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","आधी रात के करीबन पोलुस अउ सीलास बिनती करत भगवान कर भजन गाउत जथै अउ जेलियर उनखर बात सुनत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","एतका हे अक्ठी बोहत भुंइडोल आथै, इहां तक कि जेल के नीह डोल जथै अउ हरबी सगलू दूरा उघर जथै अउ सबके बन्धन छोरर जथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","जेल के सिपाही जाग के देखिस ता कि जेल दूरा उघरे हबै, ता अपन तलबार निकाडिस अउ सोचिस कि कैदी भाग गय हबै अउ खुद के मारै बाले रथै, ");
INSERT INTO bhu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","पय पोलुस ऊंच आरो लग पुकार के कथै, “अपन खुद के नुसकान झइ पहुंचा, काखे कि हम सब इछो हबन।” ");
INSERT INTO bhu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","तब ऊ चिमनी मंगवाय के भित्तर कांपत गइस अउ पोलुस अउ सीलास के गोड हे गिर जथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","अउ उनके बाहिर लानके कथै, “हे सज्जनो, मुकति पामै के निता मै काहिन करव?” ");
INSERT INTO bhu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","उन कथै, “परभु यीसु मसीह हे बिस्वास कर, ता तै अउ तोर बिरादरी मुकति पाही।” ");
INSERT INTO bhu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","अउ उन ओही अउ ओखर सगलू घर के मनसेन के परभु के बचन सुनाथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","रात के उहै टेम ऊ उनके लइजाय के उनखर घाव धोबै, अउ ऊ अपन सगलू मनसे समेत हरबी बतिस्मा लइन। ");
INSERT INTO bhu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","तब ऊ उनके अपन घर हे लइ जाय के उनखर आगू भोजन रखथै, अउ सगलू बिरादरी भगवान के उप्पर बिस्वास करिन अउ सगलू बिरादरी के संग खुसी मनाथै। ");
INSERT INTO bhu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","जब दिन होथै तब रोमन साहब लग अपन सिपाही के कहला पठोथै कि उन मनसेन के छांड देया। ");
INSERT INTO bhu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","फेर जेल के अधिकारी हइ बात पोलुस लग कथै, “सिपाही तुमके छांड देय के आदेस लग पठोय देय हबै। इहैनिता अब निकरके सान्ति लग कढ जा।” ");
INSERT INTO bhu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","पय पोलुस उनखर लग कथै, “उन हमके जउन रोमी मनसे हबै, दोसी ठहराय बिगर मनसेन के आगू मारथै अउ जेल हे बेड देथै। अब का हमके चुपके लग निकले हबै? असना झइ पय उन खुद आके हमके बाहिर निकारै।” ");
INSERT INTO bhu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","सिपाही हइ बात सिपाही लग कथै अउ उन हइ सुनके कि रोमी हबै, बोहत डर जथै, ");
INSERT INTO bhu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","उन आयके उनखर लग छमा मांगिस अउ उन बाहिर छो लइ जाय के बिनती करिन कि उन सहर छांड के कढ जाय। ");
INSERT INTO bhu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","उन जेल लग निकरके लुदिया के इहां जथै अउ भाइन लग मुलाकात करके उनके सान्ति देथै अउ कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","फेर उन अम्फिपुलिस अउ अपुल्लोनिया सहर लग हुइके थिस्सलुनीके छो पहुंचथै, जिहां यहूदी कर अक्ठी मंडली रथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","पोलुस अपन मेर के जसना उनखर लिघ्घो जथै, उन तीसर सुस्ताय कर रोज हे उनखर संग पवितर किताब लग बाद बिबाद करथै ");
INSERT INTO bhu_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","अउ पवितर किताब लग लइके उनके समझाउत हइ सिध्द करथै, कि मसीह के समस्या झेलै के रथै अउ उके मरे हर मसे जी उठै के जरूरी रथै, ऊ कथै, “हइ यीसु हबै, जेखर मै तुम्हर बीच हे परचार करथो, मसीह हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","उनखर मसे केतका झन अउ यूनानियन मसे बोहत लग भगवान भक्त, अउ बोहत कुलीन डउकी मान लेथै अउ पोलुस अउ सीलास के संग मिल जथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","पय यहूदी गुस्सा हे जरत रथै, उन कुछ केराय के गुन्डा के अकजुट करिस अउ अक्ठी समूह बनाय के सहर हे दंगा करवा दइन, उन यासोन के घर धावा बोल दइस अउ हइ परयास करै लगिन, कउनो मेर पोलुस अउ सीलास के मनसेन के लिघ्घो लइ आनै। ");
INSERT INTO bhu_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","पय जब उनके नेहको पाइन ता उन यासोन के अउ कुछ दूसर भाई के सहर के अधिकारी कर आगू किढलाय के लानथै अउ चिल्लाथै, “हइ मनसे दुनिया हे उलट पुलट करथै, अब हमर सहर हे आय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","अउ यासोन उनके अपन घर हे ठहराय हबै, हइ मनसे कैसर रोमन राजपाल के बिरोध हे करथै अउ कथै, अक्ठी दूसर राजा हबै, जेखर नाम यीसु हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","जब भीड अउ सहर के अधिकारी हइ सुनिन ता ऊ भडक जथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","इहैनिता उन यासोन अउ बाकी मनसेन लग जमानत लइके उनके छांड देथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","भाइयो ने हरबी रातो रात पोलुस अउ सीलास के बिरिया पठोय देथै अउ उन उहां पहुंच के यहूदी के मंडली हे जथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","हइ मनसे तो थिस्सलुनीके के यहूदियन लग भले रहिस अउ उन बोहत लग बचन गरहन करिन अउ सबरोज पवितर किताब हे खोजथै, कि हइ बात योंही हबै कि नेहको। ");
INSERT INTO bhu_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","इहैनिता उनखर हे बोहत झन अउ यूनानी कुलीन डउकिनो मसे अउ डउकन मसे बोहत बिस्वास करिन। ");
INSERT INTO bhu_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","पय जब थिस्सलुनीके के यहूदी जान जथै, कि पोलुस बिरिया हे भगवान के बचन सुनाथै, ता उहां आथै, मनसेन के दंगा अउ भरमामै के सुरु कर देथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","तब भाई हरबी पोलुस के बिदा करथै कि समुन्दर के टाठा हे कढ जथै पय सीलास अउ तीमुथियुस उहै ठहरे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पोलुस के लइ जाय बाले मनसेन एन्थेस पहुंचाय देथै अउ सीलास अउ तीमुथियुस के निता हइ आदेस देथै, कि ओखर लिघ्घो हरबी आ जाय उहै लग चल पडिन। ");
INSERT INTO bhu_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","जब पोलुस एन्थेस हे ओही ओरगथै, ता सहर के मूरती लग भररे हर देखके बोहत दुख हुइस। ");
INSERT INTO bhu_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","इहैनिता हर रोज यहूदी मंडली हे यहूदी अउ भगवान के डरै बाले यूनानी लग बाद बिबाद करत रथै, एतना ही नेहको पय हर रोज बजार हे जउन मनसे अउत-जउत करथै, उनखर लग वाद-बिबाद करथै अउ बजारन हे जउन कउ होथै उनखरो लग वाद-बिबाद करथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","तब इपिकूरी अउ स्तोईकी देखै बाले मसे ओखरो लग बाद बिबाद करै लागथै अउ कुछ कथै, “हइ बकवादी काहिन करै चाहथै?” पय दूसर कथै, “ऊ दूसर देउतन के परचार करैबाले पता चलथै” काखे पोलुस यीसु के जिन्दा हुइके संदेस सुनाथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","तब उन उके अपन संग अरियुपगुस पय लइ जथै अउ पूछथै, “का हम जान सकथन कि हइ नवा भेद जउन तै सुनथस, काहिन हबै? ");
INSERT INTO bhu_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","काखे तै अनोखी बात हमके सुनाथस, इहैनिता हम जानै चाहथन कि एखर मतलब काहिन हबै” ");
INSERT INTO bhu_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","इहैनिता कि सगलू एथेसवासी अउ परदेसी जउन उहां रथै, नबा बात गुठेमै अउ सुनामै के सिबाय अउ कउनो काम हे टेम नेहको बिताथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","तब अरियुपगुस के बीच हे ठाड हुइके पोलुस कथै, “हे एन्थेस के मनसे मै देखथो कि अक्ठिन हर बात हे नियाइपन के बडा मानै बाले हबा। ");
INSERT INTO bhu_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","काखे मै फिरथो तब तुम्हर पूजै के चीजन के देखत रहों, ता अक्ठी असना बेदी पायों, जेहमा लिखे रहै, अनजाने भगवान के निता इहैनिता जेही तुम बिगर जाने पूजथा, मै तुमके ओखर संदेस सुनाथों। ");
INSERT INTO bhu_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","जउन भगवान दुनिया अउ ओखर सगलू चीजन के बनाइस, ऊ स्वरग अउ भुंइ के मालिक हुइके हाथ के बनाय हर मन्दिर हे नेहको रथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","न कउनो चीज के जरुरत के कारन मनसेन के हाथन के सेबा लेथै, काखे ऊ खुद सब के जीवन अउ जीव अउ सांस अउ सगलू कुछ देथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ऊ अक्ठी मूल लग मनसेन के सगलू जाति सगलू भुंइ हे रहै बाले कर निता बनाय हबै अउ उनके ठहराय हर टेम अउ निबास के सीमन के इहैनिता बांधथै, ");
INSERT INTO bhu_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","कि उन भगवान के खोजै, सहीमा उके टटोलके पामै, तउभरमा ऊ हम मसे कउनो लग दुरिहां नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","काखे कि हम उहै हे जिन्दा रहथन अउ चलत फिरत अउ स्थिर रथन, इहै मेर खुद तुम्हर लेखक कथै, काखे हम उहै के लरका हबन। ");
INSERT INTO bhu_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","अउ काखे हम भगवान कर टोरवा हबन, इहैनिता हमके कबहुन नेहको सोचै चाही कि ऊ छाप अस्तित्व सोना, चांदी लग बने हर, या मिसतिरी लग बने कउनो मूरती जसना हबै। ");
INSERT INTO bhu_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","बीते हर टेम हे भगवान हइ अग्यानता के धियान नेहको देथै, पय अब सगलू मनसेन के पाप लग मन बदलै के आदेस देथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ऊ अक रोज निस्चित करथै, जब ऊ अपन नियुक्त करे गइस, अक्ठी डउका के दवारा नियाव के संग दुनिया के निरनय करही, भगवान मरे हर मसे उके जिलायके ऊ हर कउनो के हइ बात के सबूत दय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","मरे हर के जिन्दा होय के बात सुनके कुछ मनसे तो मजाक करै लागथै अउ कुछ कथै, “हम हइ बारे हे फेरै लग तोर बचन के सुन के सुनब।” ");
INSERT INTO bhu_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","पोलुस उनखर बीच मसे निकड जथै। ");
INSERT INTO bhu_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","कुछ मनसेन बिस्वास के लइन अउ ओखर संग हुइ लइन। उनखर हे अरियुपगुस के सदस्य दियुनुसियुस अउ दमरिस नाम कर अक्ठी डउकी अउ कइठे मनसे उनखर संग रथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","एखर बाद पोलुस एन्थेस सहर के छांड के कुरिन्थुस सहर हे आथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","उहां ऊ पुन्तुस के रहै बाले अक्विला नाम के अक्ठी यहूदी लग मिलथै, जउन हाल हे अपन डउकी प्रिसकिल्ला के संग इटली लग आय रथै, उन इटली इहैनिता छांडे रथै, कि क्लोदियुस सगलू यहूदिन के रोम लग निकड जाय के आदेस दय रथै, इहैनिता पोलुस उनखर लग मिलै गइस। ");
INSERT INTO bhu_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","अउ उनखर संग रहै अउ काम करै लगिन, काखे उन अक्ठी काम करथै तम्बू बनामै के। ");
INSERT INTO bhu_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","पोलुस सगलू सुस्ताय कर रोज हे मंडली हे लडाई झगडा करथै, अउ यहूदी अउ यूनानिन के समझामै के परयास करथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","जब सीलास अउ तीमुथियुस मकिदुनिया लग आथै, ता पोलुस बचन सुनामै के परयास हे यहूदी के गवाही देय लागथै कि यीसु ही मसीह हबै। ");
INSERT INTO bhu_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","पय जब उन मनसे पोलुस कर बिरोध करै अउ बुराई करै लगिन, ता उन अपन बन्डी के धूधुर झार के उनखर लग हइ कथै, तुम्हर खून तुम्हर मूड पडे मोर अन्त करन सुध्द हबै, मै अब लग गैर यहूदिन के लिघ्घो जहुं। ");
INSERT INTO bhu_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","हइ मेर पोलुस उहां लग चल पडथै, तीतुस अउ यूस्तुस नाम के अक्ठी मनसे के घर गइस ऊ भगवान कर उपास रथै ओखर घर यहूदी मंडली लग लगे हर रथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","तब मंडली के सरदार क्रिसपुस अपन सगलू परवार समेत परभु हे बिस्वास करिन, अउ उन बोहत लग कुरिन्थवासी जछो पोलुस लग बचन सुने रथै, बिस्वास करके बतिस्मा लेथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","परभु अक रात दरसन के दवारा पोलुस लग कथै, “झइ डर, बलुक बोलत जा अउ चुप्पे झइ रह, ");
INSERT INTO bhu_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","काखे कि मै तोर संग हव, अउ कउनो तोर पय चढाई करके तोर हानि नेहको करही काखे कि हइ सहर हे मोर बोहत लग मनसे हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","इहैनिता ऊ उनही भगवान के बचन सिखाउत डेढ साल तक रथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","जब गल्लियन अखाया देस के हाकिम रथै, ता यहूदी मनसे अकठ्ठा करके पोलुस हे चढ आथै, अउ उके न्याय आसन के आगू लइ आनथै, ");
INSERT INTO bhu_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“हइ मनसेन के समझाथै कि भगवान के उपास असना मेर लग करै, जउन नियम के खिलाप हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","पोलुस अपन मुंह खोले बाले रथै, कि राजपाल गल्लियन के यहूदिन लग कथै, “हे यहूदिन, अगर हइ बारे हे कउनो अन्याय कउनो गंभीर अपराधन के होथै, ता तुम्हर बात मोर लाने कुछु कारन होथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","पय यदि लडाई झगडा सब्दो अउ नामो अउ तुम्हर खुदय के नियम के बारे हे हबै, ता तुमिन जाना काखे कि मै इन बातन के नियाइपन नेहको बनै चाहथो।” ");
INSERT INTO bhu_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","अउ ऊ यहूदियन के न्याय आसन के आगू लग निकाड देथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","इहैनिता उन पंचायत के मुखिया सोस्थिनेस के धर दबोचा अउ न्याय आसन के आगू उके पीटे लागथै, पय गल्लियन उनखर उप्पर चुटको धियान नेहको दइन। ");
INSERT INTO bhu_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","बोहत रोज कर बाद पोलुस बिस्वासी के संग रुके रथै, फेर भाई लग बिदा लइके ऊ जिहाज के रास्ता सीरिया छो आथै अउ ओखर संग प्रिसकिल्ला अउ अक्विला रथै, पोलुस किंख्रिया हे अपन मूड मुडवाइस, काखे ऊ अक्ठी मन्नत मांगे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ऊ इफिसुस छो पहुंचिस अउ पोलुस प्रिसकिल्ला अउ अक्विला के उहै छांड देथै अउ खुद मंडली हे जायके यहूदी लग झगडा करै लागथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","जब उन पोलुस लग बिनती करथै, “हमार संग अउ कुछ रोज रह।” ता ऊ मना कर देथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","पय जात टेम उनखर लग कथै, “अगर भगवान के इक्छा होही ता मै तुम्हर लिघ्घो फेरै आहुं।” फेर ऊ इफिसुस लग नाह जिहाज हे चढ के कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","अउ कैसरिया हे उतर के यरुसलेम छो जथै अउ मंडली के नमस्ते करके अन्ताकिया हे गइस। ");
INSERT INTO bhu_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","कुछ टेम बितामै कर बाद ऊ बिदा लेथै, अउ गलातिया अउ फ्रूगिया के इलाका हे अक जिघा लग दूसर जिघा के यातरा करत सगलू बिस्वास करै बाले चेला अउ बढै लगिन। ");
INSERT INTO bhu_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ऊ टेम ऊ अपुल्लोस नाम कर अक्ठी यहूदी रथै, ऊ सिकन्दरिया के रहै बाले रथै, ऊ होसियार मनसे रथै अउ पवितर किताब के पूर ग्यान रथै अउ ऊ इफिसुस हे आथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ऊ परभु कर रास्ता के वरदान पाय रथै अउ मन लगाके यीसु के बचन के बडे साचेत कर संग जउन सही रथै, उहै सिखाथै पय ऊ केबल यूहन्ना के बतिस्मा के बात जानथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ऊ मंडली हे निडर हुइके बोलै लागथै, पय प्रिसकिल्ला अउ अक्विला ओखर बात सुनके उके अपन इहां लइ जथै अउ भगवान कर रास्ता के बारे हे पूर निक्खा लग समझाइन। ");
INSERT INTO bhu_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","जब अपुल्लोस अखाया छो जायके चाहथै, ता भाई बिस्वास करे बाले उत्साहित करथै अउ उहां के चेलन के ओखर सोगत करै के निता चिट्ठी पठोथै, जब उहां पहुंचिस ता उहां के मनसेन कर निता बोहत मददगार होथै, जउन भगवान के अनुगरह लग बिस्वास कर लय रथै। ");
INSERT INTO bhu_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","काखे कि ऊ पवितर किताब लग परमान दइके कि यीसु मसीह हबै, बडी परयास लग यहूदी के सबके आगू सबाल जबाब करथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ऊ टेम असना हुइस, कि जब अपुल्लोस कुरिन्थुस हे रथै, तब पोलुस भीतरी परदेसन लग यातरा करत इफिसुस हे पहुंचथै, उहां उके कुछ चेला मिलथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","उनखर लग कथै, “का तुम बिस्वास करत टेम पवितर आतमा पाया?” उन ओखर लग कथै “हम तो पवितर आतमा के बात नेहको सुने हबन कि पवितर आतमा होथै।” ");
INSERT INTO bhu_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","पोलुस ओखर लग कथै, “ता फेर तुम केखर बतिस्मा लय हबा?” उन कथै, “यूहन्ना के बतिस्मा।” ");
INSERT INTO bhu_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","पोलुस कथै, “यूहन्ना मन बदलै के बतिस्मा देथै, उनखर लग कथै कि जउन मोर बाद आमै बाले हबै, ओखर मतलब यीसु हे बिस्वास करैके।” ");
INSERT INTO bhu_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","हइ सुनके उन परभु यीसु के नाम हे बतिस्मा लेथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","जब पोलुस उनखर उप्पर हाथ धरथै, ता पवितर आतमा उनखर हे उतरथै अउ उन दूसर भासा बोलै अउ आगू कर बात करै लागथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","उन कुल मिलाय के करीबन बारहठे डउका रथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","फेर पोलुस यहूदी मंडली हे कढ जथै अउ तीन महिना बिना डरे बोलत रथै, ऊ यहूदियन के संग लडाई झगडा करत उनखर भगवान कर राज के बारे हे समझाय करथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","पय उनखर मसे कुछ मनसे ढीठ रथै, उन बिस्वास करै लग मना कर देथै अउ मनसेन समूह के आगू परभु के रास्ता के बेकार कहै लागथै, तब पोलुस बिस्वास करै बालेन के अपन संग लइस, उनके छांडके कढ गइस अउ चेलन के अलगे कर लइस अउ तुरतरुस के पाठसाला हे रोज दिन सिक्छा दे लगिस। ");
INSERT INTO bhu_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","एखर बाद हइ होथै, कि दुइ साल तक असना ही चलत रथै, एखर बाद हइ होथै कि सगलू आसिया के रहै बाले यहूदी अउ यूनानी सब परभु कर बचन सुन लइन। ");
INSERT INTO bhu_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","भगवान पोलुस के हाथ लग बोहत चकित के काम करत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","इहां तक कि ओखर छुवै उरमाल अउ साफी के नंगहन के लिघ्घो लइ जाय करथै अउ उन नंगहा निक्खा हुइ जथै, अउ भुतवा उनखर मसे निकड जथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","पय कुछ यहूदी मनसेन जउन भुतवा निकारत इछो-उछो घूमत बागत रथै, हइ कहै लग जथै, कि जिनखर हे भुतवा समाय रथै, उनखर उप्पर परभु यीसु के नाम लइके परयोग करथै अउ कथै, मै तुमके ऊ यीसु कर नाम हे जेखर परचार पोलुस करथै, आदेस देथो, ");
INSERT INTO bhu_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","अक्ठी स्क्किवा नाम के अक्ठी यहूदी महा पुजारी के सातठे टोरवा रथै, जउन असनैन करथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","पय भुतवा उनही जबाब देथै, “यीसु के मै जानथो अउ पोलुस के चीनथो, पय तुम कउन हबा?” ");
INSERT INTO bhu_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","अउ ऊ मनसे जेहमा भुतवा रथै, उनखर उप्पर झपटथै अउ लडाई लग काबू पाय के दोनो के हरा देथै, हइ मेर ऊ बिना कपडा के अधमरहा हुइके घर लग निकड के भाग गइस। ");
INSERT INTO bhu_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","हइ बात इफिसुस के रहैबाले सगलू यहूदी अउ यूनानी जान जथै, अउ उन सब पर भय छाय जथै अउ परभु यीसु के नाम के बडाई करथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","जउन बिस्वास करथै, उनखर मसे बोहत झन आयके अपन कामन के मान लेथै अउ परगट करिस। ");
INSERT INTO bhu_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","जादू करै बाले मसे बोहत अपन किताब अक जिघा करके सबके आगू जराय देथै अउ जब उनखर दाम जोडे जथै, ता पचास हजार खोटन्ना के बरोबर रथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","इहैमेर परभु के बचन बल पूरबक फइलथै अउ प्रबल होत जथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","जब हइ बात होय चुकथै ता पोलुस आतमा हे ठानथै कि मकिदुनिया अउ अखाया लग हुइके यरुसलेम छो जहुं अउ कथै, “उहां जाय के बाद मोके रोम सहर के देखै के जरूरी हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","उन अपन तीमुथियुस अउ इरास्तुस नाम कर दुइठे मतलब सेबा करै बालेन के मकिदुनिया पठो देथै, अउ खुदय आसिया हे कुछ टेम गुजारथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","अउ ऊ टेम परभु के हइ रास्ता के कारन इफिसुस हे बोहत गंभीर परेसानी हुइस। ");
INSERT INTO bhu_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ऊ देमेतरियुस नाम कर अक्ठी मनसे जउन चांदी के काम करै बाले सोनरा रथै, ऊ अरतिमिस देबी के चांदी के मन्दिर बनवाथै, जेखर लग मिसतिरिन के बोहत फायदा मिलथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ऊ उनही हइ काम लग जुडे हर दूसर मिसतिरिन के अक जिघा करथै, “हे मनसे, तुम जानथा कि हइ काम लग हमके केतका फायदा मिलथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","तुम देख सकथा अउ सुन सकथा, हइ पोलुस न इफिसुस हे बलुक करीबन आसिया के दुरिहां के इलाका हे मनसेन के बहकाय के बदल देथै, ऊ कथै, मनसेन के हाथन लग बनाय हर देउता बिलकुन देउता नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","इनखर लग न सिबाय हइ बात के डर हबै, कि हमार काम धंधा बदनाम होही, बलुक बडा देबी अरतिमिस के बिनती भवन के मान सम्मान समापत हुइ जाय के डर रथै, अउ जउन देबी के उपास पूर आसिया अउ पूर दुनिया के दवारा करे जथै, ओखर ऊ गरिमा छिन जायके डर हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","उन हइ सुनके गुस्सा लग भर जथै अउ चिरलाय के गुठे लागथै, “इफिसियन के अरतिमिस देबी बडा हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","सगलू सहर हे खलबली फइल गइस इहैनिता मनसे मकिदुनिया लग आइन, अउ पोलुस के यातरा करत गयुस अउ अरिस्तर्खुस के धर दबोचिस अउ उनके रंगसाला जिघा हे लइ आनिस। ");
INSERT INTO bhu_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","जब पोलुस मनसेन के लिघ्घो भित्तर जाय चाहथै ता चेला उके नेहको जाय देथै। ");
INSERT INTO bhu_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","कुछ इलाका के अधिकारी जउन ओखर संगी रथै, ओखर लग कहलवा पठोथै अउ बिनती करथै, कि उहां रंगसाला हे आमै के झइ सोचै। ");
INSERT INTO bhu_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","सभा हे हल्ला मचे रथै, कउनो कुछ चिल्लात रथै। ता कउनो कुछ सब मनसे हइ नेहको जानथै कि उन काखे अक जिघा होय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","तब यहूदी सिकन्दर के जेखर नाम भीड मसे जिम्मेदारी के रूप आगे के देथै, फेर अपन हाथन के हिलाय-हिलाय के सिकन्दर मनसेन आगू बचाव के प्रस्तुत करै के चाहिस। ");
INSERT INTO bhu_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","पय जब उन जान गयन कि ऊ यहूदी हबै, ता सगलू कउ अक्ठी आरो लग दुइ घन्टा तक चिरलात रथै, “इफिसियन के अरतिमिस, बडा हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","तब सहर के मन्तरी मनसेन के सान्त करके कथै, “हे इफिसुस के मनसेन, का दुनिया हे कउनो असना मनसे हबै, जउन हइ नेहको जानथै कि इफिसियन के सहर बडा देवी अरतिमिस अउ स्वरग लग गिरे हर पथरा के पवितर मूरती हबै। ");
INSERT INTO bhu_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","जब कि इन बातन के मना नेहको कर सकथै, ता जरूरी हबै कि तुम सान्त रहा अउ बिगर सोचे समझे कुछु झइ करा। ");
INSERT INTO bhu_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","काखे तुम हइ मनसेन के लाय हबा जउन न मन्दिर के लूटै बाले हबै अउ न हमार देवी के बुराई करे हबै। ");
INSERT INTO bhu_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","अगर देमेतरियुस अउ ओखर संगी कारीगरन के कउनो लग झगडा हबै ता कचहरी खुले हबै अउ सिपाही भी हबै उनखर उप्पर अक दूसर हे मुकदमा चला सकथन। ");
INSERT INTO bhu_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","पय तुम एखर लग बोहत कुछ जानै के चाहथा, ता एखर फइसला नागरिकन के कानूनी पंचायत हे बिचार करे जही। ");
INSERT INTO bhu_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","अब जउन कुछु हबै, एखर जसना हमके हइ डर हबै, कि आज के उपद्रव के दोस हमर उप्पर झइ लगामै जाय, हइ दंगा के निता हमर लिघ्घो कउनो कारन नेहको, जेखर लग हम हइ बातन के सही ठहरा सकि।” ");
INSERT INTO bhu_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","हइ गुठेके पंचायत के समापत करिस। ");
INSERT INTO bhu_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","उनही बुलाय के उत्साहित के सब्दन लग बढाइस अउ पोलुस चेला के बुलाय के समझाथै, अउ उनखर लग बिदा लइके मकिदुनिया के पल्ला कढ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","उनही संदेस के दवारा मनसेन के उत्साहित करत ऊ यूनान देस आ गइस। ");
INSERT INTO bhu_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","जब तीसर महीना रहके उहां ले जिहाज हे सीरिया के पल्ला जाय रथै, ता यहूदी ओखर घात हे लगे रथै, इहैनिता ऊ हइ निस्चय करथै कि मकिदुनिया हुइके लउट जाय। ");
INSERT INTO bhu_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","बिरिया के पुर्रुस कर टोरवा सोपतरुस, थिस्सलुनीके के रहै बाले अरिस्तर्खुस अउ सिकुन्दुस दिरबे के निबासी गयुस अउ तीमुथियुस अउ आसिया इलाका के तुखिकुस अउ तिरिफिमुस ओखर संग रथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ऊ मनसे पहिलेन कढ जथै अउ तरोआस हे ओरगथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","अउ हम अखमीरी रोटी रोज के बाद फिलिप्पी ले जिहाज हे चढके पांच रोज हे, तरोआस हे ओखर लिघ्घो पहुंचथै अउ सात रोज तक उहै रहै। ");
INSERT INTO bhu_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","हप्ता के रात जब हम रोटी टोरै के निता अक जिघा हुइन, ता पोलुस जउन दूसर रोज कढ जाय हे रथै, उनखर लग बात करिस अउ आधी रात तक बात करत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","जउन पटउंहा हे अक्ठी कमरा रथै, जिहां हम अक जिघा अकजुट रथन उहां बोहत चिमनी बरत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","अउ यूतुखुस नाम के अक्ठी जबान झरोकिया हे बइठे रथै, ऊ भारी नींद लग सोय रथै, काखे पोलुस लगेतार बोले जथै, इहैनिता उके भारी नींद आय जथै, इहैनिता ऊ तीसर मंजिल लग गिर जथै, जब उके उठाइन ता, ऊ मर चुके रथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पय पोलुस उतर के ओखर ले लिपट जथै अउ गले लगाय के कथै, “झइ डेरा काखे ऊ अभिन्नो जीवन हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","फेर अटारी हे कढ जथै अउ उनखर लग रोटी टोर के बाटिस अउ खाइस, फेर ऊ उनखर संग बोहत देर बेरा निकरत टेम बात चीत करत रथै, फेर ऊ उनखर लग बिदा लेथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","अउ ऊ जबान के घर छो जिन्दा लइ आनिस अउ उनके बोहत सान्ति मिलिस। ");
INSERT INTO bhu_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","हम नाह जिहाज छो पहिलेन पहुंच गयन अउ अस्सुस छो चल पडिन, उहां पोलुस के हम के जिहाज हे ले का रथै, काखे ऊ असना परयोजन बनाय रथै, कि ऊ उहां तक खुदय पइदल आमैके चाहथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","जब पोलुस अस्सुस हे मिलिस, ता हम उके नाह जिहाज हे चढाय लयन अउ मितुलेने छो चल पडही। ");
INSERT INTO bhu_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","उहां ले जिहाज खोलके हम दूसर रोज खियुस के आगू पहुंचथै, अउ अगले रोज सामुस हे जा लगे फेर मिलेतुस हे आथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","काखे पोलुस जिहां तक हुइ सकै पिन्तेकुस्त के रोज तक यरुसलेम पहुंचै के हरबी करथै, ता निस्चय करथै, कि इफिसुस हे रुकिन अउ बिना रुके आगू चले जात रहै, जेखर ऊ आसिया हे टेम नेहको बितामै के पडै। ");
INSERT INTO bhu_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ऊ मिलेतुस ले इफिसुस के मंडली के सियानन के संदेस पठोय के अपन लिघ्घो बुलवाइस। ");
INSERT INTO bhu_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","जब ऊ ओखर लिघ्घो आथै, ता उनखर ले कथै, “तुम जानथा कि आगू रोज ले जब मै आसिया हे पहुंचथै, हर टेम तुम्हर संग कउन परकार हे रहिस, ");
INSERT INTO bhu_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","मतलब बडी दीनता लग अउ आंसू बहाय के अउ उन परिक्छा हे जउन यहूदी के कारन मोर हे आय पडथै, मै परभु के सेबा करै रहों ");
INSERT INTO bhu_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","अउ जउन बात तुम्हर लाभ के रहिस, उनही गुठेमै अउ मनसेन के आगू अउ घर-घर सिखामै लग कबहुन नेहको झिझकथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","यहूदी अउ यूनानी के मै समान भाव लग मन बदलै के भगवान के पल्ला मोके कहत रथै, अउ हमर परभु यीसु हे बिस्वास के परति उनके सचेत करथो। ");
INSERT INTO bhu_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","अउ पवितर आतमा के वस हुइ के मै यरुसलेम जथो, मै नेहको जानथो, कि मोर संग उहां काहिन घटही ");
INSERT INTO bhu_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","केबल हइ कि पवितर आतमा हर सहर हे गवाही दइ के मोर लग कथै कि बन्धन अउ पीरा तोके ओरगथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","पय मै अपन जीवन के कउनो कीमत नेहको, मै ऊ बस ऊ धूप के सेबा के पूर करे चाहथो, जेही मै परभु यीसु दय हबै, हइ भगवान के अनुगरह के संदेस के गवाही दय के।” ");
INSERT INTO bhu_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","अब देखा, मै जानथो कि तुम सब जेहमा मै भगवान कर राज के परचार करत फिरथै, मोर मुंह फेर नेहको देखिहा। ");
INSERT INTO bhu_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","इहैनिता मै आज गवाही दइ के कथो, कि तुम्हर मसे कउनो के खून के दोसी मै नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","काखे मै भगवान के सगलू इक्छा के तुम के सब मेर लग गुठेमै के नेहको झिझकथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","इहैनिता अपन अउ पूरे झुन्ड के चवकसी करा जेहमा पवितर आतमा तुमके मुखिया ठहराय हबै, कि तुम भगवान के मंडली के रखबाली करा, जेही ऊ अपन खून ले खरीद लय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","मै जानथो कि मोर जाय के बाद फाडै बाले बिगवा तुम्हर बीच हे अइहिन अउ निक्खा समूह के नेहको छोडहिन। ");
INSERT INTO bhu_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","इहां तक कि असना टेम आही, कि तुम्हर बीच मसे असना मनसेन ठाढ हुइहिन जउन चेलन के अपन पाछू होमै के बातन के घुमाय फिराय के संदेस करही। ");
INSERT INTO bhu_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","इहैनिता जागत रहा अउ स्मरन करा कि मै तीन साल तक रात दिना आंसू बहाय के हर अक्ठी के चेतावनी देय के नेहको छोडिस। ");
INSERT INTO bhu_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“अब मै तुम के भगवान अउ ओखर अच्छा संदेस के अनुगरह के हाथन हे सउपथो, उहै तुमके बनाय बाले हबै अउ तुमके उन मनसे के संग जेखर पवितर करे जा चुके हबै, उहै तुम्हर उतराधिकारी देवाय सकथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","मै कउनो के चांदी, सोना या खुरथा पइजामा के लालच नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","तुम खुदय जानथा कि इहै हाथ मोर अउ मोर संगिन के सेबा अउ जरूरत पूर करिस। ");
INSERT INTO bhu_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","मै तुमके सब कुछ करके दिखाथै कि इहैमेर ले मेहनत करत कमजोर के सम्भालना अउ परभु यीसु के बचन स्मरन रखै का जरूरी हबै, जउन ऊ खुदय कथै लेय लग दय धन्य हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","हइ गुठेय के बाद ऊ घुटवा टेक के अउ उन सब के संग बिनती करथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तब सबझन रोइन अउ पोलुस के गले लिपटे उके चूमै करै लागथै। ");
INSERT INTO bhu_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","उन बिसेसकर हइ बात लग सोकित रथै जउन ऊ गुठे रहिस कि तुम मोर मुंह फेर नेहको देखिहा। तब उन उके नाह जिहाज तक छांड आथै। ");
INSERT INTO bhu_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","फेर हम उनखर लग बिदा हुइ के सागर हे अपन नाह जिहाज छोर दयन अउ सिध्धा रास्ता लग कोस हे आय गयन अउ फेर दूसर रोज रुदुस हे, फेर उहां ले हम पतरा के चले गयन। ");
INSERT INTO bhu_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","उहां हम अक्ठी नाह जिहाज लयन जउन फीनीके परदेस छो जथै ");
INSERT INTO bhu_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","जब साइप्रस दिखाई देथै, ता हम उके टेटरा पल्ला छांड के सीरिया छो मुड गइन, काखे नाह जिहाज सूर सहर उतारै के रथै अउ हमु उहां उतर गयन। ");
INSERT INTO bhu_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","उछो हमके बिस्वासी मिलिन, जिनखर संग हम सात रोज तक रहन, अउ आतमा सक्ति लग चेला पोलुस के यरुसलेम जाय के निता रोकय चाहथै। ");
INSERT INTO bhu_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","पय उहां रुकय के अपन टेम पूर करके हम बिदा लयन अउ अपन यातरा पूर करथै, अपन डउकी अउ अपन लरकन के लइके नगर के बाहिर आइस उहां सागर हे घुटवा के बल झुक के बिनती करन। ");
INSERT INTO bhu_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","तब अक दूसर लग बिदा हुइके, हम तो नाह जिहाज हे चढिन अउ अपन घर लउट गइन। ");
INSERT INTO bhu_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","सूर लग नाव दवारा लगेतार यातरा के हम पतुलिमइस हे पहुंचन, अउ भाई के सोगत के उनखर संग अक रोज रथन। ");
INSERT INTO bhu_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","अगले रोज हम उहां ले चलके कैसरिया हे आय, अउ फिलिप्पुस संदेस परचारक के घर हे जउन सातठे मसे अक्ठी रथै जाय के ओखर इहां रहै। ");
INSERT INTO bhu_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ओखर चार कुमारी टोरिया रथै, जउन आगू कर बात करथै। ");
INSERT INTO bhu_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","जब हम उहां बोहत रोज तक रह चुकन, ता अगबुस नाम के अक्ठी ग्यानी मनसे यहूदिया लग आथै। ");
INSERT INTO bhu_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ऊ हमार लिघ्घो आयके पोलुस के कटिबन्ध लेथै अउ अपन हाथ गोड बांध के कथै, “पवितर आतमा हइ कथै, कि जउन मनसे के हइ खलरी के पट्टा हबै, ओही यरुसलेम हे यहूदी इहैमेर लग बांधहिन अउ दूसर जातन के हाथ हे सवपहिन।” ");
INSERT INTO bhu_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","जब हइ बात सुनन, ता अउ उहां के मनसे पोलुस ले बिनती करथन कि यरुसलेम छो झइ जाय। ");
INSERT INTO bhu_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","पय पोलुस जबाब दइस, “तुम काहिन कथा रोय-रोय के मोर दिल दुख करे हबै? मै तो परभु यीसु के नाम के निता यरुसलेम हे न केबल बांधे जाय के निता बरन मरै के निता तइयार हबो।” ");
INSERT INTO bhu_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","जब ऊ बात मानथै ता हम हइ गुठे के चुप हुइ गयन, परभु के इक्छा पूर होय। ");
INSERT INTO bhu_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","कुछ रोज गुजरे के बाद हम अपन समान के बान्धन अउ यरुसलेम छो चल गइन। ");
INSERT INTO bhu_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरिया ले कुछ चेला हमार संग हुइ लइन, अउ हमके मनासोन नाम के साइप्रस के अक्ठी पुरान चेला के इहां लग आथै, कि हम ओखर घर हे रही। ");
INSERT INTO bhu_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","जब हम यरुसलेम छो पहुंचिन, ता उहां के बिस्वासी भाई हमर बडा सोगत करिन। ");
INSERT INTO bhu_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","अगले रोज पोलुस हम के लइ के याकूब लग मिलै गइस, जिहां सब सियान अक जिघा रथै। ");
INSERT INTO bhu_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","तब पोलुस उनके सोगत करिस, जउन काम भगवान ओखर सेबा के दवारा गैर यहूदी हे करे रथै, अक्ठी -अक्ठी करके सगलू गुठेथै। ");
INSERT INTO bhu_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","उन हइ सुनके भगवान के महिमा करिन फेर ओखर लग कथै, “हे भाई पोलुस, तै तो देखथस, इहां केतका गैर यहूदी हबै, जउन बिस्वास के लय हबै अउ उन नियम किताब के परति धुन लगाय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","उन तोर बारे हे कहे गय हबै, तै गैर यहूदी के बीच रहै बाले सगलू यहूदियन के मूसा कर सिक्छा के छांड के ग्यान देथै अउ ओखर लग कथै, कि नेहको मै अपन लरकन के सुध्दिकरन करवायो अउ न रीति रिबाजन हे चली। ");
INSERT INTO bhu_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ता फेर काहिन करे जाय? मनसे जरूरी सुनहिन तै आय हबस। ");
INSERT INTO bhu_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","इहैनिता जउन हम तोर लग कथन, ऊ हमार इहां चार मनसे हबै जउन मन्नत माने हबै। ");
INSERT INTO bhu_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","हइ मनसेन के लइ जा अउ उनखर संग सुध्दिकरन समूह हे मिल जा अउ उनखर खरचा दइ, ताकि ऊ अपन मूड के बाल मुडवा ले, एखर लग सगलू मनसेन जान जइहिन, कि उन तोर बारे हे सुने हबै, ओहमा कउनो सही नेहको हबै, बलुक तै तो खुदय नियम के जसना जीवन जिये। ");
INSERT INTO bhu_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","पय उन गैर यहूदिन के बारे हे जउन बिस्वास करथै, हम हइ निरनय करी, लिखके पठोय हबन कि उन मूरतिन के आगू बलि करे हर मांस ले अउ खून ले अउ नटेरी घोटे हर मांस ले अउ गलत काम लग बचे रहै।” ");
INSERT INTO bhu_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","हइ मेर पोलुस उन मनसेन के अपन संग लइ आनथै अउ उन मनसेन के संग खुद के अगले रोज सुध्द कर लेथै, फेर ऊ बिनती भवन हे गइस, जिहां ऊ घोसना करिस, सुध्दिकरन के रोज कब पूर होही अउ हमर मनसे हर अकझन के निता बलि कब चढय जही। ");
INSERT INTO bhu_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","जब ऊ सात रोज पूर होय पर रथै, ता आसिया इलाका के कुछ यहूदी पोलुस के बिनती भवन हे देख के सब मनसेन के भिडकाथै अउ चिरलाय के ओही पकर लेथै। ");
INSERT INTO bhu_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“हे इस्राएली, मदद कर हइ उहै मनसे हबै, जउन मनसेन के अउ नियम लग अउ हइ जिघा के बिरोध हे हर जिघा सब मनसेन के सिखाथस, इहां तक कि यूनानिन के बिनती भवन हे लइके ऊ पवितर स्थान के अपवितर करे हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","इहैनिता कथै, कि तिरिफिमुस नाम के अक्ठी इफिसी सहर हे उन ओखर संग देखत असना समझाय रथै, कि पोलुस उके बिनती भवन हे लइ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","तब सगलू सहर हे हल्लागुल्ला मच जथै अउ मनसे दउडके अक जिघा होथै अउ पोलुस के पकरके बिनती भवन के बाहिर किढलाय लानथै अउ हरबी दूरा बन्द करे गइस। ");
INSERT INTO bhu_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ऊ उके मारै के सोचत रथै, कि रोमी सिपाही के सेना नायक के लिघ्घो हइ संदेस पहुंचिस कि सगलू यरुसलेम हे खलबली मच गइस। ");
INSERT INTO bhu_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ऊ हरबी बाद सिपाही अउ सेना के अधिकारिन के अपन संग लइस अउ पोलुस हे हमला करै बाले यहूदियन के पल्ला बढिन, यहूदियन जब ऊ सेना नायक अउ सिपाही के देखिस ता उन पोलुस के पीटै के बन्द के देथै। ");
INSERT INTO bhu_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","तब सेना नायक पोलुस के लिघ्घो आइस अउ बन्दी बनाय लइस। ऊ उके दुइ सांकड हे बान्ध देय के आदेस देथै, फेर ऊ पूछथै, कि ऊ कउन हबै अउ ऊ काहिन करे हबै? ");
INSERT INTO bhu_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","पय भीड मसे कउ कुछ चिल्लात रथै। जब हल्ला गुल्ला के मारे ऊ निक्खा सच्चाई नेहको जान सकथै, ता उके गढ हे लइ जाय के आदेस देथै। ");
INSERT INTO bhu_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","जब पोलुस सीढी के लिघ्घो पहुंचथै, ता असना होथै कि भीड के दबाव के मारे सुपाहिन के उठाय के लइ जाय पडथै। ");
INSERT INTO bhu_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","काखे मनसेन के भीड हइ चिरलात ओखर पाछू पडे रथै, “ओही मार डाला।” ");
INSERT INTO bhu_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","जब ऊ अंगना के भित्तर लइ जाय बाले रथै, कि पोलुस सेनापति के सरदार लग पूछथै, का तै यूनानी भासा जानथस? ");
INSERT INTO bhu_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","तै मिस्री तो नेहको, जउन कुछ टेम पहिले बिद्रोह सुरु करवाय रहस अउ जउन हइ रेगिस्थान हे चार हजार अतंकवादी के मदद करथै। ");
INSERT INTO bhu_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पोलुस कथै, “मै किलिकिया के तरसुस सहर के रहै बाले यहूदी यहों अउ अक्ठी परसिध्द सहर के रहै बाले यहों। मै तोर लग चाहथो, कि तै मोके इनखर बीच बोलन दे।” ");
INSERT INTO bhu_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","जब ऊ आदेस दिहिस, ता पोलुस सीढी हे ठाड हुइके मनसेन के हाथ ले इसारा करथै। जब उन चुप हुइ जथै ता ऊ इब्रानी भासा हे गुठे लागथै। ");
INSERT INTO bhu_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","पोलुस कथै, “हे मोर यहूदी भाई अउ संगी जसना सज्जन मनसे मोर बचाव हे मोके जउन कुछु कहै का हबै उके सुना।” ");
INSERT INTO bhu_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","उन हइ सुनिन कि ऊ हमर ले इब्रानी भासा हे कथै, ता उन चुप हुइ गइन, पोलुस कथै। ");
INSERT INTO bhu_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","मै अक्ठी यहूदी मनसे हबो, जउन किलिकिया के तरसुस हे मोर पइदाइस हुइस, पय हइ सहर हे गमलीएल के गोड लिघ्घो बइठ के हमर सियानन के नियमन के जसना बडी कडाइ के संग सिक्छा पाय हव, भगवान के परति मै बडा समरपित रहों, जसना आज तुम सबझन हबा। ");
INSERT INTO bhu_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","मै डउका अउ डउकिन के बांध के अउ जेल हे डालके, इस परभु के रास्ता बाले के इहां तक सतायों कि उनके मरवाउ डालो। ");
INSERT INTO bhu_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","खुदय महा पुजारी अउ सियानन के सगलू हइ बात के गवाह हबै, मै दमिस्क हे इनखर भाई के नाम उनखर लग चिट्ठी लयो, अउ परभु के रास्ता बाले समूह के उहां रहै बाले मनसेन के पके के बन्दी के रूप हे यरुसलेम लामै के निता मै गय रथो, ता उनही सजा दिलाय सको। ");
INSERT INTO bhu_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","जब मै रेंगत-रेंगत दमिस्क के लिघ्घो पहुंचो, ता असना हुइस कि दुपहरी के टेम अक्ठी बडी उजियार बादर ले मोर चउगिरदा पल्ला चमकथै। ");
INSERT INTO bhu_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","अउ मै भुंइ हे गिर पडो अउ हइ आरो सुना, हे साऊल, हे साऊल तै मोके काखे सताथस? ");
INSERT INTO bhu_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","मै जबाब दयों, हे परभु तै कोहर आस ऊ मोके जबाब दिहिस, मै यीसु नासरी हबो, जेही तै सताथस। ");
INSERT INTO bhu_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","मोर संगिन उजियार तो देखिन, पय जउन मोर लग गुठेथै ओखर सब्द के नेहको सुना। ");
INSERT INTO bhu_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","तब मै कथो, हे परभु मै का करव? परभु मोर लग कथै, ठाढ हुइ जा अउ दमिस्क हे जा, उहां तोके सगलू बात गुठेही, जेही करै के निता चुने गय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","जब ऊ उजियार के तेज के मारे मोके कुछु दिखाई नेहको देथै, ता मै अपन संगिन के हाथ पकरे हर दमिस्क हे आथै। ");
INSERT INTO bhu_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","उहां सहर हे हनन्याह नाम के अक्ठी मनसे रथै, ऊ नियम के पालन करै बाले अक्ठी भक्त रथै, उहां के रहै बाले सगलू यहूदिन के संग उनखर अच्छी बोल चाल रथै। ");
INSERT INTO bhu_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","अउ ठाढ हुइके मोर ले कथै, हे भाई साऊल, फेर देखै लग, उहै टेम मोर आंखी उघर गइस अउ मै उके देखो। ");
INSERT INTO bhu_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","तब ऊ कथै, हमार दादा के भगवान मोके इहैनिता चुने हबै, कि तै ओखर इक्छा के जानय, ऊ अक्ठिन धरमी के देखय अउ ओखर मुंह ले बात सुनय। ");
INSERT INTO bhu_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","काखे तै ओखर तरफ ले सगलू मनसेन के आगू उन बातन के गवाह होही जउन तै देखे अउ सुने हबस। ");
INSERT INTO bhu_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","इहैनिता तय, अब देर झइ के ठाढ हुइ जा, बतिस्मा लइ ले अउ ओखर नाम पुकारत अपन पाप के धोय डार। ");
INSERT INTO bhu_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“फेर असना हुइस कि जब मै यरुसलेम छो लउट के बिनती भवन हे बिनती करत रथो, तबय मै दरसन मै देखो। ");
INSERT INTO bhu_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","अउ ओही देखथै कि ऊ मोर लग कथै, हरबी करके यरुसलेम ले हरबी निकर जा, काखे ऊ मोर बारे हे तोर गवाही नेहको मानही। ");
INSERT INTO bhu_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","हे परभु ऊ तो खुदय जानथस कि मै तोर हे बिस्वास करय बाले के जेल हे बेडथै अउ यहूदी मंडली हे पिट लगवाथै। ");
INSERT INTO bhu_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","जब तोर गवाह स्तिफनुस के खून बहोय जथै, तब मै समरथन करै के उहै ठाढ रथो, जउन ओखर खून करे रथै, मै ओखर बन्डी के देख रेख करत रहों। ");
INSERT INTO bhu_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","अउ ऊ मोर ले कथै, कढ जा काखे मै तोर गैर यहूदिन के लिघ्घो दुरिहां पठोहूं।” ");
INSERT INTO bhu_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","हइ बात सुनत रहै, ता फेर ऊंच आरो हे पुकार के चिल्लाय उठिस, असना मनसे जिन्दा के काबिल नेहको एही भुंइ लग मिटा के, उके मार डारा। ");
INSERT INTO bhu_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","जब ऊ चिरलात अउ बन्डी फेकै अउ बादर अउ आकास हे धूधुर उडाथै ");
INSERT INTO bhu_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","तब सेनापति सरदार आदेस देथै, कि पोलुस के अकेले हे लइ जाय, ऊ कथै, कि कोडा लगाय-लगाय के ओखर लग पूछ तांछ करे जाय, ताकि पता होय कि ओखर उप्पर मनसेन के हइ मेर चिल्लाय का कारन हबै। ");
INSERT INTO bhu_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","पय जब ऊ कोडा लगामै के निता बांधिन, तब उहां ठाढ सिपाही पोलुस लग कथै, “कउनो रोमी नागरिक के, जउन अपराधी नेहको पाय गय होय, कोडा लगामै का तुम्हार निता उचित हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","हइ सुनके अधिकारी सिपाही के लिघ्घो गइस अउ बोलिस, “तय के करथस? काखे हइ तो रोमी नागरिक हबै” ");
INSERT INTO bhu_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","तब पलटन के सरदार ओखर लिघ्घो आयके कथै, “मोके गुठे का तै रोमी हबस?” ऊ कथै, “हव।” ");
INSERT INTO bhu_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","हइ बात हे सिपाही जबाब देथै, हइ नागरिकता के पामै लग, मोके बोहत पइसा खरचा करै का पडे हबै, पोलुस कथै पय मै तो पइदाइसी रोमी नागरिक यहों। ");
INSERT INTO bhu_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","जउन मनसे ओखर पूछ तांछ करै के कथै, हरबी पाछू हट गइन अउ ऊ सिपाही हइ समझ के कि ऊ अक्ठी रोमी नागरिक हबै अउ ऊ उके बांधे हबै, बोहत डेराय गइन। ");
INSERT INTO bhu_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","काखे ऊ सेनापति हइ बात के सही-सही पता लगामै चाहथै, कि यहूदियन पोलुस हे आरोप काखे लगाइन, इहैनिता ऊ अगले रोज ओखर बंधन खोल दइस। फेर खास परधान याजक अउ उच्च यहूदी पंचायत के बुलउवा पठोइस अउ पोलुस के उनखर आगू लायके टाड के दइस। ");
INSERT INTO bhu_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पोलुस महासभा के पल्ला सिध्धा देखके कथै, हे भाइयो मै आज तक भगवान के निता बिलकुन निक्खा सोंच लग जीवन गुजारे हव। ");
INSERT INTO bhu_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","एहमा महायाजक हनन्याह पोलुस के लिघ्घो ठाड मनसेन के आदेस देथै कि ओखर गाल हे अक झापड मारै। ");
INSERT INTO bhu_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","तब पोलुस उनखर लग कथै, अगर चरका पोतररे हर भीठी तोर उप्पर भगवान के मार पडही, तै इहां जुगाड के नियम के जसना मोर कसना नियाव करै के बइठे हबस, कि तै नियम के बिरोध हे मोके झापड मारै के आदेस देथस। ");
INSERT INTO bhu_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","जउन पोलुस के लिघ्घो ठाड मनसेन लग कथै, भगवान के महायाजक बेज्जती करै के हिम्मत तोके कसके हुइस? ");
INSERT INTO bhu_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पोलुस जबाब देथै, “मोर इस्राएली भाइयो मोके पता नेहको कि हइ महा पुजारी हबै। काखे किताब हे लिखवरे हबै, तै अपन परजा के सरदार के निता नेहको बोलै चाहे।” ");
INSERT INTO bhu_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","तब पोलुस के पता चलिस कि उनखर लग कुछ मनसे सदूकी हबै, अउ आधा फरीसी ता पंचायत के बीच ऊ बोहत आरो हे कहिस, हे भाई मै फरीसी यहों, अक्ठी फरीसी के टोरवा यहों, मिरतू के बाद फेरै लग जी उठै के परति मोर आसा के कारन मोर उप्पर केस चलाय गइस। ");
INSERT INTO bhu_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ओखर असना कहै लग फरीसी अउ सदूकियन हे अक्ठी बिबाद खडा हुइ जथै अउ पंचायत के बीच फूट पडा। ");
INSERT INTO bhu_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","सदूकी हइ कथै, कि फेरै लग जिन्दा नेहको होथै अउ न स्वरगदूत होथै अउ न ही आतमा, पय फरीसी हइ बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","तब बोहत हल्ला मच गइस, अउ कुछ गुरू जउन फरीसिन के समूह मसे कुछ धरमी मनसे उठिन अउ कडाइ बात कहै लगिस, “हइ मनसे हे हम कउनो गलती नेहको पाथन, अगर कउनो आतमा कउनो स्वरगदूत एखर लग बात करे हबै, ता एखर लग कह?” ");
INSERT INTO bhu_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","काखे हइ बिबाद सुरु हुइ चुकथै, ता एखर लग सेनापति के सरदार डर गइस कि कहुं ऊ पोलुस के खन्डा-खन्डा झइ के डारै, इहैनिता ऊ सिपाहिन के आदेस देथै, कि ऊ तरी जायके पोलुस के उनखर लग अलगे करके भित्तर छो लइ जाय। ");
INSERT INTO bhu_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","उहै रात परभु पोलुस के लिघ्घो ठाड हुइके कथै, हे पोलुस हिम्मत रख काखे जसना तै यरुसलेम हे मोर गवाही दय हबस, उहै मेर रोम हे मोर गवाही देय का होही। ");
INSERT INTO bhu_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","दूसर रोज सुबेन्नेन कुछ यहूदी अक्ठी साजिस बनाइस अउ उन किरिया लइन कि जब तक पोलुस के मार नेहको डारी, तब तक न कुछु खउब न पीयब। ");
INSERT INTO bhu_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","जउन मनसे हइ जुगाड बनाथै, उन चालीस लग बोहत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ऊ खास याजक अउ सियानन के लिघ्घो गइन अउ बोलिन, अउ हम किरिया खाय हम कि जब तक पोलुस के मार नेहको डारी, तब न हम खउब न पीयब। ");
INSERT INTO bhu_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","अब तुम अउ यहूदी पंचायत सेनापति लग कहा, कि उके तुम्हर लिघ्घो लइ आइन, हइ बहाना बनाउत तुम ओखर बारे हे अउ अच्छी तरह लग पूछ तांछ करै के चाहथा। एखर लग आगुन ऊ इछो पहुंचै, हम उके मार डारै के तइयार हबन। ");
INSERT INTO bhu_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","पय पोलुस के बेहन के टोरवा जब हइ साजिस के बारे हे सुनिस ता, किला हे जायके पोलुस के सगलू बात गुठे देथै। ");
INSERT INTO bhu_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","इस पर पोलुस कउनो अक्ठी अधिकारी के बुलाय के ओखर लग कथै, हइ जबान के सिपाही के लिघ्घो लइ जा, काखे इके ओखर कुछु कहै के हबै। ");
INSERT INTO bhu_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","इहैनिता ऊ उके सेनापति के लिघ्घो लइ गइस अउ बोलिस जेलर पोलुस मोके बुलाय के बिनती करिस कि हइ जबान के तोर लिघ्घो पहुंचामै के कथै, काखे ऊ तोर लग कहेके चाहथै। ");
INSERT INTO bhu_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","सिपाही ओखर हाथ पकरके अउ अलगे लइ जाय के पूछथै तै मोर ले काहिन गुठेमै चाहथस। ");
INSERT INTO bhu_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ऊ कथै यहूदी साजिस बनाय हबै, कि तोर लग बिनती करै कि पोलुस के पंचायत हे लाय कि मानो ऊ अउ निक्खा ओखर जांच करै चाहथै। ");
INSERT INTO bhu_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","काखे बोहत मनसे घात लगाय उके ओरगथै, उन हइ किरिया खाय हबै, कि जब तक उके मार न लइ तब तक न खाबे न पियब, बस तोर अनुमति के परतिक्छा हे उन बइठे हबै। ");
INSERT INTO bhu_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","फेर सिपाही जबान के हइ आदेस दइके पठोय देथै, तै हइ कउनो के झइ बताबे कि तै मोके एखर जानकारी दय हबस। ");
INSERT INTO bhu_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","फेर सिपाही अपन सेना नायक के बुलाय के कथै, दुइ सव सिपाही, सत्तर घोडवा अउ दो सव भाला बालेन के कैसरिया जाय के निता तइयार रखा। रात के नव बजे निकरै के निता तइयार रहबे। ");
INSERT INTO bhu_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","अउ पोलुस के सबारी के निता घोडवा तइयार रखा, कि उके फेलिक्स हाकिम के लिघ्घो सान्ति ले पहुंचा देय। ");
INSERT INTO bhu_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","तब पोलुस सिपाही के अक्ठी चिट्ठी लिखिस। ");
INSERT INTO bhu_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","महामहिम फेलिक्स हाकिम के क्लोदियुस लूसियास के नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","हइ मनसे के यहूदी पके लेथै अउ ऊ उके मारै बाले रथै, कि मै हइ जानके कि हइ अक्ठी रोमी नागरिक हबै, ता अपन सिपाही के संग जायके छंडाय लायो। ");
INSERT INTO bhu_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","मै जानै चाहत रहों कि ओखर कउन कारन दोस लगाथै इहैनिता उनखर महासभा हे लइ गइन। ");
INSERT INTO bhu_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","तब मै जान लयो कि ऊ अपन नियम के बिबादन के बारे हे ओखर हे दोस लगाथै, पय मार डारै जाय या बांधे जाय के ओग ओहमा कउनो दोस नेहको। ");
INSERT INTO bhu_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","फेर जब मोके जानकारी मिलिस कि उहां हइ मनसे के बिरोध हे अउ कउ साजिस रचे हबै, ता मै इके हरबी तोर लिघ्घो पठोय दय हव। अउ एखर उप्पर आरोप लगामै बालेन के हइ आदेस दइ देथै, कि एखर बिरोध लगाय गय अपन आरोप के तोर आगू रखै। ");
INSERT INTO bhu_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","मतलब जसना सिपाहिन के आदेस दय गय रथै, ओसनेन पोलुस के लइके रात हे अन्तिपतरिस हे लइ आनथै। ");
INSERT INTO bhu_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","दूसर रोज ऊ घुडसवारन के पोलुस के संग जाय दइस अउ उन खुदय किला के लउट आथै। ");
INSERT INTO bhu_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","उन कैसरिया पहुंचे हाकिम के चिट्ठी दइस अउ पोलुस के ओखर लिघ्घो ठाड करिस। ");
INSERT INTO bhu_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","राजपाल चिट्ठी पढिस अउ पोलुस लग पूछिस कि कउन परदेस के रहै बाले हबै, जब उके पता चलिस कि ऊ किलिकिया के रहै बाले आय। ");
INSERT INTO bhu_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ता ऊ ओखर लग कथै, तोर उप्पर आरोप लगाय बाले जब आ जइहिन, मै तबै तोर सुनवाइ करहों, ऊ आदेस देथै कि पोलुस के सुरक्छा के भित्तर हेरोदेस के घर हे रखे जाय। ");
INSERT INTO bhu_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पांच दिन बाद हनन्याह महा पुजारी कुछ सियान नेता अउ तिरतुल्लुस नाम के अक्ठी बकील के पंचायत लइके कैसरिया आइस ऊ राजपाल के आगू पोलुस के बिरुध निबेदन चिट्ठी परस्तुत करिस। ");
INSERT INTO bhu_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","फेर फेलिक्स के आगू पोलुस के पेसी के कारवाही सुरु करत, तिरतुल्लुस नाम के अक्ठी बकील बोलिस, हे महोदय फेलिक्स तुम्हर कारन बडे सान्ति के संग जथै, अउ तुम्हर दुरिहां के कारन सेम हे बोहत लग कइठे सुधार होय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","एही हम हर जिघा अउ हर मेर लग धन्यबाद के संग मानथन। ");
INSERT INTO bhu_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","मै तुम्हर लग अउ बोहत टेम न लेत मोर बिनती हबै कि किरपा संछिप्त हे सुन ले। ");
INSERT INTO bhu_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","हमर सोच हबै कि हइ मनसे संक्रामक नंगहा के जसना हबै, हइ दुनिया भर के सगलू यहूदिन हे आंदोलन करत फिरथै, अउ नासरी कुपंथ के मुखिया हबै। ");
INSERT INTO bhu_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ऊ बिनती भवन के अपवितर करै के चाहथै, पय हम इके पकरे हवन। हम उके अपन नियाव के जसना दंड दय होते ");
INSERT INTO bhu_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","पय सेनापति लूसियास आयके इके बडी परेसानी लग हमर हाथ लग झटक लइस अउ हइमेर दोस लगामै बाले के आदेस दइस कि उन तोर आगू उपस्थित होय। ");
INSERT INTO bhu_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","अउ हमके तोर आगू अपन आरोप परस्तुत होय के आदेस देथै, कि तै खुद स्थिति के जांच के हइ सगलू अरोपन लग सबंधित सच्चाई के जान सकै। ");
INSERT INTO bhu_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","हइ अरोप हे यहूदी सामिल हुइ गइन, ऊ द्रढता के संग कथै, कि हइ सब बात सही हबै। ");
INSERT INTO bhu_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","फेर राजपाल जब पोलुस के बोलै के लिता इसारा करिस ता ऊ जबाब देत कथै, तै बोहत साल लग हइ देस के न्यायधीस हबै, हइ जानथै कि मै खुसी के संग अपन बचाव प्रस्तुत करथो। ");
INSERT INTO bhu_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","तै खुद जान सकथस कि तोर निता यरुसलेम हे अबे आराधना करै के निता यरुसलेम आयों, बारह रोज लग अधिक नेहको हुइस। ");
INSERT INTO bhu_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","उहां बिनती भवन हे न आराधना हे, न सहर हे, अउ न मनसेन के भडकाउत पाय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","अउ न तो उन बातन के, जेखर उन अब मोर हे दोस लगाथै, तोर आगू सही परमाडित नेहको के सकथै। ");
INSERT INTO bhu_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","पय तोर आगू हइ स्वीकार करथो, कि मै अपन पुरखन के रास्ता हे चल के भगवान के सेबा करथो, मै ऊ बात हे बिस्वास करथो, जेही मूसा कर नियम बताथै अउ जउन ग्यानी मनसेन के किताब हे लिखवरे हर हबै। ");
INSERT INTO bhu_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","अउ भगवान लग आसा हबै ओसनेन बिस्वास करथो, जसना हइ मनसे रथै, कि धरमी अउ बेकार दुनोन के मिरतू हे जिलाय जइहिन। ");
INSERT INTO bhu_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","इहैनिता महुं भगवान अउ मनसेन के आगू सब रोज अपन सोंच के सुध्द बनाय रखै के निता परयास करत रथो। ");
INSERT INTO bhu_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","अउ बोहत साल के बाद मै यरुसलेम हे अपन गरीब मनसेन के दान पहुंचामै, अउ भेंट चढामै आय रहों। ");
INSERT INTO bhu_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","आसिया के कुछ यहूदी मोके सुध्द दसा हे बिनती भवन के भित्तर हइ सब करत पाइस, मोर संग न कउनो भीड रथै अउ न उहां कउनो उपद्रव होथै। ");
INSERT INTO bhu_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","आसिया लग आय कुछ यहूदी उहां मउजूद रथै, अगर मोर बिरुध उनखर लिघ्घो कुछु हबै ता उनके तोर आगू उपस्थित हुइके आरोप लगामै चाही। ");
INSERT INTO bhu_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","या हइ मनसे जउन इहां हबै उन बतामै कि जब मै यहूदी महासभा के आगू ठाढ रथो, तब उन मोर हे का खोट पाइस। ");
INSERT INTO bhu_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","हव अक्ठी बात जरूरी हुइस कि मै उनखर बीच ठाढ हुइके ऊंच आरो लग हइ कथै, मिरतू के फेरै जिन्दा के बारे हे आज तै मनसेन के आगू मोर हे मुकदमा चलाथस। ");
INSERT INTO bhu_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","फेलिक्स के हइ रास्ता के बारे हे अच्छी जानकारी रथै, ऊ सुनवाइ रोक देथै अउ यहूदी धरमी मनसे लग कथै, सेना नायक लूसियास के आय लग मै तुम मनसेन के मुकदमा के फइसला करहुं। ");
INSERT INTO bhu_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ऊ सिपाहिन के आदेस दइस कि पोलुस के पहरे हे धरे जाय, पय उनही कुछु आजाद रहै के अउ उनखर संगी हे कउनो उनखर सेबा परचार करै लग झइ रोके जाय। ");
INSERT INTO bhu_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","कुछ रोज के बाद फेलिक्स अपन डउकी द्रुसिल्ला के, जउन यहूदनी रथै, संग लइके आथै अउ पोलुस के बुलवाय के ऊ बिस्वास के बारे हे जउन मसीह यीसु हे हबै, बात सुनिस। ");
INSERT INTO bhu_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","पय जब पोलुस नियाइपन अच्छाई, आत्म संयम अउ आय बाले नियाव के बारे हे बोलथै, ता फेलिक्स डर गइस अउ बोलिस, “हइ टेम तै कढ जा मउका मिलत हे मै तोके फेरै बुलइहो।” ");
INSERT INTO bhu_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","उहै टेम उके हइ आसा रथै, कि पोलुस उके कुछु पइसा देही, इहैनिता फिलिक्स पोलुस लग बात चीत करै के निता बेर-बेर बुलाथै। ");
INSERT INTO bhu_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","दुइ साल असना बीत जाय के बाद फेलिक्स के जिघा पुरकियुस, फेस्तुस स्वीकार के लेथै, काखे फेलिक्स यहूदिन के खुस रखै के चाहथै, इहैनिता ऊ पोलुस के जेल हे बनाय के रख देथै। ");
INSERT INTO bhu_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","फेस्तुस ऊ परदेस हे पहुंचै के तीसर रोज बाद कैसरिया ले यरुसलेम के गइस। ");
INSERT INTO bhu_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","उहां खास पुजारी अउ यहूदिया के मुखिया पोलुस के बिरुध लगाय गय आरोप ओखर आगू रखिन अउ ओखर लग बिनती करिन। ");
INSERT INTO bhu_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ऊ फेस्तुस लग हइ निबेदन करिस, कि ऊ पोलुस के यरुसलेम बुलामै के अनुगरह किरपा करै, काखे ऊ गली हे पोलुस के मार डालै के जुगाड बनाथै। ");
INSERT INTO bhu_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","फेस्तुस जबाब देथै, “पोलुस कैसरिया हे बन्दी हबै अउ मै खुद हरबी उहां जाय बाले हबो।” ");
INSERT INTO bhu_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","फेर कथै, “तुम्हर हे जउन हक रखथै उन संग चलै अउ अगर ऊ मनसे कउनो अपराध करे हबै, ता ऊ उहां ओखर उप्पर अरोप लगाय।” ");
INSERT INTO bhu_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","फेस्तुस कउ आठ दस रोज उनखर बीच हे रहिके कैसरिया छो कढ गइस, अउ अगले रोज अदालत हे नियाव सिहासन हे बइठके ऊ आदेस दइस कि पोलुस के ओखर आगू लाय जाय। ");
INSERT INTO bhu_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","जब पोलुस उहां पहुंचथै, ता ऊ यहूदी जउन यरुसलेम लग आय रथै, यहूदी उके घेर के ठाड हुइ गइन, उन ओखर उप्पर बोहत आरोप लगाइन, पय ऊ साबित नेहको के सकिन। ");
INSERT INTO bhu_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","पय पोलुस खुद के बचाव करत कथै, “मै यहूदिन के बिरोध हे कुछु अपराध नेहको करे यहों, न बिनती भवन के खिलाप हे अउ न कैसर के बिरोध हे।” ");
INSERT INTO bhu_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","पय फेस्तुस यहूदी साहबन के मगन करै चाहथै, इहैनिता जबाब हे ऊ पोलुस लग कथै, “का तै यरुसलेम जाय के चाहथस? ता मै उहां तोर उप्पर लगाय गय हइ आरोप के नियाव के सको।” ");
INSERT INTO bhu_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","पोलुस कथै, हइ टेम “मै कैसर रोमन राजपाल नियाव के आगू ठाड हव। मोर नियम इहां होयके चाही, मै यहूदिन के संग बुरा नेहको करे यहों, इके तै बोहत अच्छी मेर लग जानथस। ");
INSERT INTO bhu_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","अगर मै कउनो अपराध के दोसी हव अउ मै कुछ असना करे हव, जेखर सजा मिरतू हबै ता मै मरै लग बचै नेहको चइहो, पय अगर हइ मनसे मोर उप्पर जउन आरोप लगाय गइस, ओहमा कउनो सही नेहको हबै, ता मोके कउनो उनके नेहको सउप सकथै। इहै कैसर रोमन राजपाल लग मोर बिनती हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","फेस्तुस अपन पंचायत सदस्यन लग सलाह लइस अउ जबाब देथै, “तै कैसर रोमन राजपाल लग फेरै बिनती करे हबस, इहैनिता तोके ओखर आगू लइ जाय जही।” ");
INSERT INTO bhu_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","कुछ रोज गुजरै के बाद अग्रिप्पा राजा अउ ओखर बेहन बिरनीके राजपाल फेस्तुस लग मुलाखात करै कैसरिया हे आइस। ");
INSERT INTO bhu_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","जब ऊ उहां कइ रोज गुजर चुकिस, ता फेस्तुस राजा के आगू पोलुस के केस के हइ मेर समझाइस, “इहां अक्ठी असना मनसे हबै, जेही फेलिक्स जेलियर के रूप हे छांडे गय रथै। ");
INSERT INTO bhu_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","जब मै यरुसलेम हे रथै, ता परधान पुजारी अउ यहूदी सियान ओखर बिरोध के मोके खबर देथै अउ निबेदन करिन कि उके सजा दय जाय। ");
INSERT INTO bhu_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","पय रोमी हे असना नियम नेहको हबै कि कउनो मनसे के जब तक प्रतक्छय रूप लग आमने सामने न ठाड करे जाय अउ ओखर उप्पर लगाय गय अरोप लग उके बचै का मउका झइ दय जाय, उके सजा के निता सउपे जाय। ");
INSERT INTO bhu_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","इहैनिता उन मनसे जब मोर संग इहां आइन ता मै बिगर देरी करे, अगले रोज न्याय आसन हे बइठ के ऊ मनसे के लामै के आदेस दयों। ");
INSERT INTO bhu_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","जब ओखर उप्पर दोस लगामै बाले बोलै के ठाड हुइन ता उन ओखर उप्पर अइसन कउ दोस नेहको लगाइन, जसना कि मै सोचत रहों। ");
INSERT INTO bhu_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","बलुक उन अपन धरमी के कुछ बातन हे अउ यीसु के नाम के अक्ठी मनसे हे जउन मर चुके हबै, उनखर हे कुछ बैर के चरचा करथै, पय पोलुस के दाबा हबै, कि ऊ जिन्दा हबै। ");
INSERT INTO bhu_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","मोर समझ हे नेहको आइस कि हइ बातन के छानबीन कसके करे जाय इहैनिता मै पोलुस लग पूछो कि का तै यरुसलेम जाय चाहथस, जेखर लग उहां हइ बातन के बारे हे तुम्हर नियाव करे जाय। ");
INSERT INTO bhu_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","पय पोलुस जब बिनती करी कि उके कैसर रोमन राजपाल के नियाव के निता उहां धरे जाय ता मै आदेस दयों, कि मै जब तक उके कैसर रोमन राजपाल के लिघ्घो नेहको पठोय देहुं उके इहै धरे जाय।” ");
INSERT INTO bhu_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","हइ बात हे अग्रिप्पा फेस्तुस लग कथै, हइ मनसे के सुनवाइ मै खुदय करै चाहथो, “फेस्तुस कथै, तै उके कल सुन लइहे।” ");
INSERT INTO bhu_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","इहैनिता अगले रोज अग्रिप्पा अउ बिरनीके बडी पहिन ओढ के संग आइस, अउ उन सेनापति के अउ सहर के खास मनसे के संग पंचायत भवन हे गइस। फेस्तुस आदेस देथै अउ पोलुस के उहां लग लइ गइन। ");
INSERT INTO bhu_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","फेस्तुस कथै, राजा “अग्रिप्पा अउ सगलू इहां आय हर मनसे, तुम हइ मनसे के देखथा, जेखर बारे हे सगलू यहूदी समाज यरुसलेम हे अउ इहां मोर लग चिल्लाय-चिल्लाय के मांग करथै, कि इके अब अउ जिन्दा नेहको रहै चाही। ");
INSERT INTO bhu_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","पय मै जांच करव कि हइ असना कुछु अपराध नेहको करे हबै, कि इके मिरतू के सजा दय जाय, काखे हइ खुदय रोमन राजपाल लग फेरै बिचार करै के बिनती करे हबै, इहैनिता मै इके उहां पठोमै के निरनय लय हव। ");
INSERT INTO bhu_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","पय एखर बारे हे परभु राजपाल के लिघ्घो लिख पठोमै के मोर लिघ्घो कउनो निस्चित बात नेहको हबै, मै इके इहैनिता तुम्हर आगू खास रूप लग हे राजा अग्रिप्पा तुम्हर आगू लाय हबो ताकि हइ जांच पडताल के बाद लिखे के मोर लिघ्घो कुछु होय। ");
INSERT INTO bhu_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","कुछु हुइ जाय मोके कउनो जेलियर के आरोप चिट्ठी तइयार करे बिगर उहां पठोय देबे, मोके फालतू लगथै।” ");
INSERT INTO bhu_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","राजा अग्रिप्पा पोलुस ले कथै, “तोके अपन बारे हे बोलै के आदेस हबै।” तब पोलुस अपन हाथ उठाइस अउ अपन बचाव हे बोलै के सुरु करथै, ");
INSERT INTO bhu_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“हे राजा अग्रिप्पा, मै खुदय के भागय समझथो, कि यहूदिन मोर उप्पर जउन आरोप लगाय हबै, उन सगलू बातन के बचाव हे, मै तोके धन्य समझथो।” ");
INSERT INTO bhu_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","बिसेस करके इहैनिता सही हबै कि तै यहूदिन के सब रिबाज अउ झगडा के जानथो। मतलब मै बिनती करथो, धीरज के संग मोर बात सुना। ");
INSERT INTO bhu_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","सगलू यहूदी जानथै, कि मै सुरु लग खुद अपन देस हे अउ यरुसलेम हे नान लग मै कसना चाल चलन के जीवन जिये हबो। ");
INSERT INTO bhu_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ऊ मोके बोहत टेम लग जानथै अउ अगर ऊ चाहथै, ता मोर बात के गवाही दइ सकथै, मै कइसन धरमी रीति रिबाज हे मै कट्टर जीवन अक्ठी फरीसी के जसना जीवन जिये हव। ");
INSERT INTO bhu_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","पय अब मोर हे मुकदमा चलथै, काखे मोके ऊ टीमा के आसा हबै, जउन भगवान हमर पुरखन लग करे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","उहै टीमा हबै जेखर आसा लगाय हम बारह कुर अपन बारे हे मन लग दिन रात महिमा करथन, अउ हे राजा इहै आसरा के कारन मोर उप्पर यहूदी आरोप लगाथै। ");
INSERT INTO bhu_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","तुम मसे कउनो हइ बात बिस्वास के काबिल काखे नेहको लगथै, कि भगवान मरे हर के जिलाय देथै। ");
INSERT INTO bhu_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“मै खुदय सोचत रहों, नासरी यीसु के नाम के बिरोध करै के निता जउन बने पडै ऊ बोहत कुछु करव। ");
INSERT INTO bhu_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","अउ मै यरुसलेम हे असना करे रहों अउ परधान याजकन ले हक पाके बोहत ले पवितर मनसेन के जेल हे डालिस, अउ जब उन मार डारे जात रहिन ता मै उनखर बिरोध हे अपन सहमति दय रथो। ");
INSERT INTO bhu_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","अउ यहूदी मंडली हे उनके सजा दय करथो अउ भगवान के बुराई ऊ बिस्वास के छांडै के निता दबाव के परयास करथो, उनखर पल्ला मोर गुस्सा एतका अधिक रथै कि उनके सतामै के निता बाहर के सहर तक गयों। ");
INSERT INTO bhu_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“इहै मकसद के संग दमिस्क के पल्ला जथो परधान याजकन के हक अउ आदेस चिट्ठी पाय के। ");
INSERT INTO bhu_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","हे राजा, जब मै दुपहरी के टेम जब रास्ता हे रथो, तब मै बादर लग अक्ठी उजियार के उतरत देखथो, ओखर उजियार बेरा लग तेज रथै अउ मोर मनसेन के चउगिरदा पल्ला चमकिस। ");
INSERT INTO bhu_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","जब हम सब भुंइ हे गिर पडेन, ता मै इब्रानी बोली हे, मोर ले हइ कहत अक्ठी सब्द सुनथै, हे साऊल हे साऊल, तै मोके काखे सताथस? कलिन्द्रा चाकू हे गिरै या चाकू कलिन्द्रा हे, पय कटै का कलिन्द्रा के हबै। ");
INSERT INTO bhu_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","मै पूछो, हे परभु तै कोहर हबस? परभु कथै, मै यीसु हबो, जेही तै सताथस। ");
INSERT INTO bhu_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","पय अब तै उठ, अपन गोड पर ठाढ हो काखे मै तो इहैनिता दरसन दय हव कि तोके अक्ठी हरवाह के रूप हे चुने हव, जउन कुछु देखे हस अउ उनके जिनखर निता मै तोके दरसन दइहों ओखर तै गवाह रइहे। ");
INSERT INTO bhu_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","अउ मै तोके तोर मनसेन लग अउ गैर यहूदी लग बचाउत रइहों, जिनखर लिघ्घो मै तोके पठोथो। ");
INSERT INTO bhu_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","कि तै उनखर आंखी उघार कि उन अंधियार लग उजियार के पल्ला अउ भुतवा के हक ले भगवान के पल्ला फिरै, कि पापन के छमा अउ उन मनसेन के संग जउन मोर हे बिस्वास करै लग पवितर करे गइन बरदान पामै। ");
INSERT INTO bhu_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“हे राजा अग्रिप्पा, तब लग ऊ दरसन के आदेस के कबहुन मै उलंघन नेहको करव। ");
INSERT INTO bhu_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","पय आगू दमिस्क के, फेर यरुसलेम के अउ तब यहूदिया के सगलू देस के रहैबालेन के, अउ गैर यहूदी के मै हइ परचार करव, कि उन पछताप करय, भगवान के पल्ला मुडै अउ मन बदलै के काबिल काम करै। ");
INSERT INTO bhu_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","इहै कारन हबै कि जब मै बिनती भवन हे रहों, यहूदी मोके पके लइन अउ मोके मारै के परयास हे रथै। ");
INSERT INTO bhu_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","पय मै भगवान के मदद लग मै आज तक बने हव अउ नान बडे सबके आगू गवाही देथो, अउ उन बातन के छांड कुछ नेहको कथो जउन मूसा आगू कर बात गुठे हबै, उनखर लग अधिक मै कुछु नेहको कथो। ");
INSERT INTO bhu_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","कि मसीह के दुख उठामै काहिन होही अउ उहै सब ले आगुन मरे हर मसे जी उठके, अउ यहूदी अउ गैर यहूदी हे उजियार के संदेस दइ।” ");
INSERT INTO bhu_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ऊ अपन बचाव हे जब हइ बातन के कहेन बाले रथै, ता फेस्तुस चिल्लाय के कथै, “पोलुस तोर दिमाक खराब हुइ गय हबै, तोर बोहत पढाइ तोके बइहा बनाथै।” ");
INSERT INTO bhu_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","पय पोलुस कथै, “हे फेस्तुस, मै बइहा नेहको यहों, पय सही अउ मुद्दे के बात करथो। ");
INSERT INTO bhu_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","खुदय राजा हइ बातन के जानथै, मै निडर हुइके बोलथो, हइ बात जानथा अउ मोके बिस्वास हबै कि इन बातन मसे कउनो बात ओखर लग छुपे नेहको हबै, काखे हइ घटना कउनो कोन्टा हे नेहको हुइस। ");
INSERT INTO bhu_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","हे राजा अग्रिप्पा, का तै ग्यानी मनसे के कहे हर बात हे बिस्वास करथस? मै जानथो, कि तै बिस्वास करथस।” ");
INSERT INTO bhu_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","हइ बात हे अग्रिप्पा पोलुस लग कथै, का तै हइ सोचथस कि इतनी लिखडी लग मसीही बनै के निता मनाय लेहे? ");
INSERT INTO bhu_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पोलुस जबाब देथै, “चुटु टेम या चाहे बोहत टेम हे भगवान लग मोर हइ बिनती हबै कि न सिबाय तै बलुक सगलू जउन आज लग मोर बात सुनथै, ओसनेन हुइ जइन, जसना मै हव, सिबाय हइ बंधन के।” ");
INSERT INTO bhu_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","तब राजा अग्रिप्पा राजपाल फेस्तुस अउ बिरनीके अउ उनखर संग बइठे हर मनसे उठ गइन। ");
INSERT INTO bhu_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","उहां लग बाहिर निकरके ऊ अपन हे बात करत कहै लागथै, हइ मनसे कुछु नेहको करे हबै, जेही उके मिरतू के सजा या जेल हे बन्द रख सकि। ");
INSERT INTO bhu_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","अग्रिप्पा फेस्तुस ले कथै, “अगर हइ मनसे कैसर रोमन राजपाल के आगू फेरै बिनती नेहको करे होते ता हइ मनसे के छांड दय जाय सकतिस।” ");
INSERT INTO bhu_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","जब हइ निस्चित हुइ गइस कि हम जिहाज दवारा इटली जउबे, ता पोलुस अउ कुछ दूसर बन्दिन के यूलियुस नाम के सिपाही के हाथ दइ देथै। यूलियुस किला अवगुस्तुस के सेना के दल रथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","हम आसिया परदेस के बन्दरगाह के जाय बाले अन्द्रमुत्तियुम नगर के अक्ठी नाह जिहाज हे बइठ के रवाना हुइ गयन, मकिदुनिया देस के थिस्सलुनीके नगर के रहै बाले अरिस्तर्खुस नाम अक्ठी बिस्वासी हमर संग रथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","अगले रोज हम सैदा हे लंगर डालेन, इहां यूलियुस पोलुस के परति दया दिखाई अउ ऊ पोलुस के संगिन के इहां जाय अउ उनखर मदत करै के इजाजत दइ दइस। ");
INSERT INTO bhu_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","उछो लग समुन्दर गली लग हुइ के कढ जथै, हम साइप्रस के आड हे हुइके चलत रहन काखे हबा हमर पल्ला रथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","फेर हम किलिकिया, पंफूलिया के समुन्दर के पार करत लूसिया अउ मूरा पहुंचन। ");
INSERT INTO bhu_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ऊ सिपाही के सिकन्दरिया इटली जाय बाले अक्ठी नाह जिहाज मिलथै ओहमा हमही चढाय दइस। ");
INSERT INTO bhu_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","धीम-धीम परेसानी लग आगू बढत कनिदुस के आगू पहुंचेन, काखे बडेरा हमही आगू नेहको बढै देथै, ता हम सलमोने के आगू लग क्रेते के आड हे अपन नाह जिहाज के बढामै लगन। ");
INSERT INTO bhu_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","क्रेते के टाठा-टाठा बडी परेसानी लग जिहाज के आगू बढाउत अक्ठी असना जिघा हे पहुंचन, जेखर नाम रथै सुरक्छित समान उतारै बाले जिघा ले लसया सहर लिघ्घो रथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","टेम बोहत गुजर जथै नाह जिहाज के आगू बढामै का खतरा रथै, काखे तब तक उपास के रोज गुजर जथै, इहैनिता पोलुस उनही सलाह देत कथै, ");
INSERT INTO bhu_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“हे भाई, मोके लागथै कि हमर समुन्दर के यातरा खतरा हबै, न केबल समान अउ नाह जिहाज बलुक हमर जीवन के।” ");
INSERT INTO bhu_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","पय पोलुस जउन कथै ओखर हे धियान देय हे सेना सिपाही जिहाज के मालिक अउ नाह जिहाज चलामै बाले बिस्वास करिन। ");
INSERT INTO bhu_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ऊ बन्दरगाह अगहन के टेम रथै इहैनिता मनसे फीनिक्स पहुंच के उछो जाड उहै छो गुजारब, अउ निस्चय करिन कि फीनिक्स क्रेते असना माल उतारै बाले हबै, जेखर दख्खिन अउ दिन बुडती अउ उत्तर दिन बुडती दोनो के आगू पडथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","जब दख्खिन हबा चुटु-चुटु चलै लागथै, ता उन सोचिन जसना उन चाहथै ओसनेन रही ता उन लोहा के सांकड के उठाय के क्रेते के टाठा-टाठा पहुंच गइन। ");
INSERT INTO bhu_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","पय अउ चुटु देर हे अक्ठी पानी लग घेररेहर टापू के पल्ला लग बोहत बडेरा आथै, जेही उत्तरी बडेरा कथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जिहाज बडेरा लग घेरर जथै, तब मुसकिल रथै कि बडेरा के चीरत जिहाज आगू बढथै, इहैनिता हम परयास करै के छांड दयन अउ बडेरा के संग नाह जिहाज के बोहै के निता छांड दयन। ");
INSERT INTO bhu_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","तब कउदा नाम के अक्ठी नान ले टापू के आड हे बहत हम दिग्गत ले नाह जिहाज के वस हे के सकेन। ");
INSERT INTO bhu_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","फेर मल्लाहन उके उठाय के दूसर जुगाड करके नाह जिहाज के तरी ले बांधथै, अउ सुरतिस के चोरबालू पर टिक जाय के डर ले पाल अउ सामान उतार के बहत चल देथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","जब हम बडेरा ले बोहत हिलकोचे अउ धक्के खायन, ता दूसर रोज ऊ नाह जिहाज के माल फेकै लागथै ");
INSERT INTO bhu_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","अउ तीसर रोज उन अपन हाथन ले नाह जिहाज के साज समान फटक देथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","जब कइन रोज तक न बेरा, न तरइया दिखाई देथै अउ बडी बडेरा चलथै, ता आखिर हे हमार बचै के सगलू आसा बढाय गइस। ");
INSERT INTO bhu_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","जब उन बोहत टेम लग कुछु नेहको खाय रथै, ता पोलुस उनके गोहदा हे ठाढ हुइके कथै, “हे मनसे चाही कि तुम मोर बात मानके क्रेते लग न नाह जिहाज खोलते अउ न हइ समस्या आतिस अउ न हइ नुसकान उठातेन। ");
INSERT INTO bhu_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","पय अब मै तुमके समझाथो कि हिम्मत धरा, काखे तुम मसे कउनो के जीवन के दिग्गत नेहको होही, पय केबल नाह जिहाज नस्ट होही। ");
INSERT INTO bhu_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","काखे भगवान जेखर मै हबो अउ जेखर सेबा करथो, ओखर स्वरगदूत आजय रात मोर लिघ्घो आयके कथै, ");
INSERT INTO bhu_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","हे पोलुस, झइ डेराबा तोके कैसर रोमन राजपाल के आगू ठाढ होय का जरूरी हबै देख, भगवान सब के जउन तोर संग यातरा करथै, तोके दय हबै। ");
INSERT INTO bhu_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","इहैनिता, हे सज्जनो, हिम्मत रख काखे मै भगवान हे बिस्वास करथो, कि जसना मोर लग गुठे गइस, ओसनेन होही। ");
INSERT INTO bhu_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","पय हमके कउनो टापू हे जायके होही।” ");
INSERT INTO bhu_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","जब चउदमा रात आथै अउ हम अद्रिया समुन्दर हे भटकत रहन, ता आधी रात के केउंटा अनुमान करिस कि हम कउनो देस के लिघ्घो पहुंचथन। ");
INSERT INTO bhu_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","थाह लेय हे उन बीस पुरसा दहार पानी पाथै, अउ चुटु आगू बढके फेर थाह लैथै ता पन्दरा पुरसा पाथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","तब पथरहली जिघा ले टेकराय के डर ले उन जिहाज के पाछू पल्ला चार लंगर डालिन, अउ सुबेन्नेन होय के ओरगथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","पय जब केउंटा नाह जिहाज पर ले भागै चाहथै, इहैनिता उन गलही लग लंगर डालै के बहाने नाह जिहाज समुन्दर हे उतार दिहिन, ");
INSERT INTO bhu_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ता पोलुस सिपाही अउ सिपाहिन ले कथै, “अगर हइ नाह जिहाज पर नेहको रहै, ता तुम नेहको बच सकथा।” ");
INSERT INTO bhu_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","तब सिपाही डोरा काट के नाह जिहाज समुन्दर हे छांड देथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","जब सुब्बेन होय रथै तब पोलुस हइ कथै, सब के भोजन करै के निता समझाथै, “आज चउदह रोज हुइस कि तुम आस देखत भूखे रहा अउ कुछ भोजन नेहको करे। ");
INSERT INTO bhu_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","इहैनिता तुमके समझाथो कि कुछ खाय लो, जेखर ले तुम्हर बचाव होय काखे तुम मसे कउनो के मूड के अक्ठी चूंदी नेहको गिरही।” ");
INSERT INTO bhu_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","हइ गुठेके ऊ रोटी लइके सबके आगू भगवान के धन्यबाद करथै अउ टोर के खाय लागथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","तब उन सब हिम्मत धरके भोजन करै लागथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","हम सब मिलके नाह जिहाज पर दुइ सव छिहत्तर जन रहन। ");
INSERT INTO bhu_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","जब उन भोजन करके अघाय गइन, ता गोहूं के समुन्दर हे फटक के नाह जिहाज हलका करै लागथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","जब दिन उगथै ता उन ऊ देस के नेहको पहचानथै, पय अक्ठी खाडी देखथै जेखर पाखा चउडा रथै, अउ बिचार करथै कि अगर हुइ सकै ता इहै तट पर नाह जिहाज के टिकामै। ");
INSERT INTO bhu_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","तब उन लंगर के खोलके समुन्दर हे छांड देथै अउ उहै टेम पतवारन के बन्धन छोर दिहिन, अउ हवा के आगू अगला पाल चढायके पाखा के पल्ला चलेन। ");
INSERT INTO bhu_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","पय दुइठे समुन्दर के मिलन के जिघा पकरके उन नाह जिहाज के टिकाथै, अउ गलही लग लंगर तो धक्का खाय के गडरर जथै अउ नेहको टर सकथै पय पाछू लहर के बल लग टूटै लागथै। ");
INSERT INTO bhu_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","तब सिपाहिन के हइ बिचार होथै कि बन्दिन के मारे डालय, असना नेहको होय कि कउनो पइर के निकर भागय। ");
INSERT INTO bhu_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","पय सिपाही पोलुस के कथै, कि जउन पइर सकथै, आगू कूदके पाखा हे निकर जाय ");
INSERT INTO bhu_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","अउ बाकी कउ पटरन पर, अउ कउ नाह जिहाज के दूसर चीजन के सहारे निकर जाय। इहैमेर ले सब कउ भुंइ हे बच निकडथै। ");
INSERT INTO bhu_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","जब हम बच निकरन। ता पता हुइस कि हइ व्दीप के नाम माल्टा हबै। ");
INSERT INTO bhu_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","उहां के रहै बाले मनसे हमर संग संगी के जसना दया करिन काखे सरदी रथै अउ बरसा होमै लगथै, इहैनिता उन आगी जलाय के अउ हमर सबके सोगत करिस। ");
INSERT INTO bhu_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","जब पोलुस लकडी के अक्ठी बोझवा बनाइस अउ ऊ जब लकडी के आगी हे धरथै, ताकि गरमी मिलै ता गरमी के कारन अक्ठी सपुवा निकरिस अउ ओखर हाथ हे लपट गइस। ");
INSERT INTO bhu_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","उहां के रहै बाले जब ऊ सपुवा के ओखर हाथ हे लपटे हर देखथै, ता ऊ अपन हे कहे लागथै, जरूर इहै मनसे खुनहा हबै अउ हइ सागर लग बच गय हबै पय इके भगवान के नियाव जिन्दा नेहको रहै दइस। ");
INSERT INTO bhu_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","तब पोलुस सपुवा के आगी हे फेक दइस अउ उके कुछ नुसकान नेहको हुइस। ");
INSERT INTO bhu_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ऊ मनसे ओरगत रथै कि ऊ फूल जही, या अचानक भुंइ हे गिरके मर जइही, पय बोहत देर लग ओरगै के बाद ऊ देखथै कि उके असाधरन रूप लग कुछु नेहको हुइस, ता उनखर सोच बदल गइस अउ उन कथै “हइ कउनो देउता हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","उस टापू के अगल बगल पुबलियुस मुखिया के जमीन रथै, ऊ अपन घर लइ जायके ऊ तीन रोज संगी के जसना सोगत सत्कार करिस। ");
INSERT INTO bhu_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","पुबलियुस के बाफ बुखार अउ पेचिस लग नंगहा रथै। मतलब पोलुस ओखर लिघ्घो घर हे जाय के बिनती करथै अउ ओखर हे हाथ धरके उके निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","हइ घटना के बाद ऊ दीप लग सगलू नंगहा उहां आइन अउ सगलू कउ निक्खा हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","उन हमार बोहत इज्जत करिन, अउ जब हम रेंगय लागेन ता जउन कुछ हमर निता जरूरी रहिस, जिहाज हे धर दिहिन। ");
INSERT INTO bhu_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","हम तीन माह के बाद हम सिकन्दरिया के अक्ठी नाह जिहाज पर गयन, जउन ऊ व्दीप हे जाड गुजारन अउ जेखर निसानी रथै, “दियुसकूरी।” ");
INSERT INTO bhu_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","हम सुरकूसा हे लंगर डालके हम तीन रोज उछो रहन। ");
INSERT INTO bhu_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","उहां लग हम घूमके रेगियुस हे आयन अउ अक रोज के बाद दख्खिन हबा चलिस, तब हम दूसर रोज पुतियुली बन्दरगाह छो पहुंचेन। ");
INSERT INTO bhu_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","उहां हम के बिस्वासी भाई मिलिस, अउ उनखर गुठे लग हम उनखर इहां सात रोज तक रहन अउ इहैमेर हम रोम तक आय गइन। ");
INSERT INTO bhu_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","उहां के भाई हमर समाचार सुनके अप्पियुस के चउक अउ तीन सराय तक हम भेंट करय के निकर गयन, देखके पोलुस भगवान के धन्यबाद दइस अउ ऊ खुस हुइस। ");
INSERT INTO bhu_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","जब हम रोम हे पहुंचेन, ता पोलुस के अक्ठी सिपाही के संग जउन ओखर देख रेख करथै, अकेल्ले रहै के आदेस मिल गइस। ");
INSERT INTO bhu_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","तीसर रोज के बाद ऊ यहूदी के मुखिया मनसेन के बुलवाथै, अउ जब उन अक जिघा हुइन ता ऊ कथै “हे भाइयो, मै अपन मनसेन के या दाय-बाफ के बेउहार के बिरोध हे कुछ नेहको करव, तउमा बन्दी बनाय के यरुसलेम ले रोमन के हाथ सउपे गइस। ");
INSERT INTO bhu_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","उन मोके जांच के छांड देय चाहथै, काखे मोर हे मरय के ओग कउनो गलती नेहको रथै। ");
INSERT INTO bhu_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","पय यहूदी एखर बिरोध हे बोलय लागथै, ता मोके कैसर रोमन राजपाल के दुहाइ देयका पडिस, हइ नेहको कि मोके अपन मनसेन पर कउनो गलती थोपी। ");
INSERT INTO bhu_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","इहैनिता मै तुमही बुलाथों कि तुम्हर लग मिलो अउ बात चीत करव काखे इस्राएल कि आसा के निता मै हइ सांकड ले बंधररे हर हबो।” ");
INSERT INTO bhu_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","उन ओखर ले कथै, “न हम तोर बारे हे यहूदिया ले चिट्ठी पायन, अउ न भाइन मसे कउनो आयके तोर बारे हे कुछ गुठेइन अउ न बुरा के। ");
INSERT INTO bhu_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","पय तोर बिचार काहिन हबै? उहै हम तोर ले सुनय चाहथन, काखे हम जानथन कि हर जिघा हइ मत के बिरोध हे मनसे बात करथै।” ");
INSERT INTO bhu_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","तब उन ओखर निता अक रोज ठहराइन, अउ बोहत लग मनसे ओखर इहां अक जिघा हुइन, अउ ऊ भगवान कर राज कि गवाही देत अउ मूसा कर नियम अउ ग्यानी मनसे के किताब लग यीसु के बारे हे समझाय के भिनसरहा ले सांझ तक चरचा करत रथै। ");
INSERT INTO bhu_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","तब कुछ मनसे उन बातन के मान लेथै अउ कुछ बिस्वास नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","जब उन अपने हे अक मत नेहको हुइन, ता पोलुस के हइ बात गुठे लग चले गइन, “पवितर आतमा यसायाह ग्यानी मनसे दवारा तुम्हर दाउ दादन लग सही गुठे हबै।” ");
INSERT INTO bhu_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","जाय के इन मनसेन लग कहा, कि सुनत तो रइहा, पय नेहको समझिहा अउ देखत, तो रइहा पय नेहको बूझिहा। ");
INSERT INTO bhu_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","काखे इन मनसेन के मन मोटा, अउ उनखर कान भारी हुइ गय हबै, अउ उन अपन आंखी बन्द करे हबै, असना न होय कि, उन कहुं आंखी लग देखय, अउ कान लग सुनय, अउ मन ले समझय, अउ फेर मै उनके निक्खा करी। ");
INSERT INTO bhu_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","मतलब तुम जानथा, “कि भगवान के हइ मुकति के संदेस गैर यहूदी के लिघ्घो पठोय गय हबै अउ उन जरूर सुनही।” ");
INSERT INTO bhu_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","जब ऊ कथै ता यहूदी अपनय हे बोहत झगडा करै लागथै अउ झगडा करत उहां लग कढ गइन। ");
INSERT INTO bhu_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ऊ पूर दुइ साल अपन भाडे के घर हे रहिस, ऊ सब मनसेन के सोगत करथै जउन ओखर लग मिलै आथै। ");
INSERT INTO bhu_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","अउ जउन ओखर लिघ्घो आथै, उन सबले मिलथै अउ बिगैर रोकटोक के बोहत निडर हुइके भगवान कर राज के परचार करथै अउ परभु यीसु मसीह के बारे हे सिक्छा देथै।");
INSERT INTO bhu_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","हइ चिट्ठी पोलुस के तरफ लग जउन यीसु मसीह के हरवाह हबै अउ चेला होय के निता बोलाय गय हबै अउ भगवान के ऊ संदेस के निता चुने गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","जेखर टीमा भगवान पहिलेन लग अपन ग्यानी मनसे के दवारा ऊ संदेस के टीमा करथै। ");
INSERT INTO bhu_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","अपन टोरवा हमर परभु यीसु मसीह के बारे हे ऊ देह के भाव दाऊद के घराना लग पइदा हुइस। ");
INSERT INTO bhu_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","पय पवितर आतमा के दवारा मरे हर मसे जिलाय जाय के कारन जेही सक्ति के संग भगवान कर टोरवा के गुठेय गय हबै, इहै यीसु मसीह हमर परभु हबै। ");
INSERT INTO bhu_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ओखर माध्यम लग हमके सगलू सिधान्त आदेस के निता अनुगरह के चेला मिले हबै, कि ओखर नाम के कारन सगलू मनसे बिस्वास करके ओखर बात मानै। ");
INSERT INTO bhu_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","जउन मसे तुमो यीसु मसीह के होमै के निता बुलाय गय हबा। ");
INSERT INTO bhu_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","तुम्हर सबके नाम जउन रोम सहर हे भगवान बाफ के पिरिया हबै अउ चेला होय के निता बुलाय गय हबै अउ हमर भगवान अउ परभु यीसु मसीह तुमके अपन अनुगरह किरपा अउ सान्ति देय। ");
INSERT INTO bhu_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","सब लग पहिले मै तुम सबके निता यीसु मसीह दवारा अपन भगवान के धन्यबाद देथो, काखे दुनिया भर हे तुम्हर बिस्वास के चरचा बगर गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","भगवान जेखर सेबा हे अपन आतमा लग ओखर टोरवा कर संदेस के बारे हे करथो, उहै मोर गवाह हबै, कि मै अपन बिनती हे तुमही लगेतार सुरता करत रथो, ");
INSERT INTO bhu_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","अउ हरमेसा बिनती अउ पराथना हे निबेदन करथो कि भगवान के इक्छा लग कउनो न कउनो मेर लग मोके आखरी हे तुम्हर लिघ्घो आमैके मउका मिलै। ");
INSERT INTO bhu_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","काखे मोके तोर लग मिलै के बडी इक्छा हबै, जेखर लग मै आतमिक मनसेन के बिस्वास मजबूत बनामै के निता अनुगरह के बरदान देय चाहथो। ");
INSERT INTO bhu_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","कि तै अउ मै आपस हे अक दूसर के बिस्वास के दवारा उतसुक हुइ जइ। ");
INSERT INTO bhu_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","हे भाई, मै चाहथो कि तुमही पता होय कि मै तुम्हर लिघ्घो बेर-बेर आमैके योजना बनायो, ताकि जसना फडुहा मै गैर यहूदी हे पाय हव, ओसनेन तुम्हरो लग पाय सको, पय अब तक उछो आमै के निता रोके गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","मै यूनानी अउ दूसर यूनानी, दिमाक बाले अउ मूरुख सगलू मनसेन के करजा बाले मानथो। ");
INSERT INTO bhu_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","इहैनिता मै तुमही जउन रोम सहर हे रथा, मै उन सब के संदेस सुनामै के निता सबरोज तइयार हव। ");
INSERT INTO bhu_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","मै संदेस के निता सरमिन्दा नेहको यहों, काखे ओहमा पहिले यहूदी अउ फेर यूनानी गैर यहूदी जउन कउ बिस्वास करथै, ओखर मुकति के निता भगवान कर सक्ति हबै। ");
INSERT INTO bhu_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","काखे संदेस हे हइ दरसाय गय हबै, कि भगवान मनसे के अपन जसना सही कइसन बनाथै, हइ सुरु लग आखरी तक बिस्वास हे टिके हबै, जसना कि किताब हे लिखे हबै, धरमी मनसे बिस्वास लग जिन्दा रही। ");
INSERT INTO bhu_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","उन मनसेन हे जउन सत्य के अधरम लग दबाथै, बेकार काम अउ सब बुराई हे स्वरग लग भगवान कर क्रोध परगट होही। ");
INSERT INTO bhu_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","कारन इहै हबै कि भगवान कर बारे हे जउन कुछु जाने जाय सकथै, ऊ उनखर उप्पर परगट हबै, खुदय भगवान उनखर उप्पर परगट करे हबै। ");
INSERT INTO bhu_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","तब ले नेहको दिखाई देय बाले गुन अउ सबरोज के सक्ति देय बाले दुनिया के दयनिक आचरन दुनो के साफ-साफ समझे अउ देखे जाय सकथै, उनही भगवान बनाय हबै असना गुठेय जथै। ");
INSERT INTO bhu_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","काखे उन भगवान के जानत भरमा ऊ भगवान के ओग बडाई अउ धन्यबाद नेहको दइन उनखर सगलू चिन्ता बेकार हे चले गइस अउ उनखर मन अंधियार लग भर गइन। ");
INSERT INTO bhu_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ऊ अपनै के हुसियार मानके मूरुख बन गइन। ");
INSERT INTO bhu_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","अउ हरमेसा के जीवन देय बाले भगवान के महिमा के मरै बाले मनसे, चिरइया, जानबर, सपुवा लग मिलत जुलत मूरतिन हे उन बनाय दइन। ");
INSERT INTO bhu_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","इहै कारन भगवान उनही उनखर मन के बेकार कामन के जसना, असुध्द करै के निता छांड दय हबै, कि उन अक दूसर के देह के अपवितर करी। ");
INSERT INTO bhu_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","उन झूठ के संग भगवान के सही के सउदा के दइन, अउ उन दुनिया बनामै बाले के छांड के ओखर बनाय हर चीजन के उपास करै लग गइन, भगवान धन्य हबै, ओसनेन होय ");
INSERT INTO bhu_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","इहैनिता भगवान उनही बेकार कामन के कबजा हे छांड दइस, इहां तक कि उनखर डउकियो डउकन के संग, देह रिस्ता बनामै के छांड के, डउकिन के संग देह सबंध बनामै लगिन। ");
INSERT INTO bhu_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","इहै मेर डउका डउकिन लग देह सबंध बनामै के छांड दइन, अउ उन आपस हे जले लगिन, अउ डउका डउकन के संग बेकार काम करै लगिन, उन अपन बेकार कामन के कारन सही सजा मिलिस। ");
INSERT INTO bhu_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","अउ भगवान हे बिस्वास नेहको करिन भगवान उनही ओसनेन बिगर दिमाक बाले रहै दइस अउ अपन मन के इक्छा लग बेकार-बेकार काम करै लगिन जउन नेहको करै चाही। ");
INSERT INTO bhu_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","उन हर मेर के बेकार काम, दुस्टता, लालच अउ बुराई लग भर गइन, उन इसाय लगिन, खून, बैर, छल अउ कानाफूसी लग भर गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","उन बेकार कहै बाले बुराई करै बाले भगवान लग बिरोध करै बाले घमंडी ढोंगहा, बेकार-बेकार बातन के बनामै बाले अउ दाय बाफ के आदेस नेहको मानै बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","मूरुख, धोखा देय बाले, माफ नेहको करै बाले अउ न दया करै बाले बन गइन। ");
INSERT INTO bhu_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","उन तो भगवान कर आदेस जानथै, कि असना काम करै बाले, मरै के सजा के भागी होही, तउभरमा असना काम करथै, बलुक करै बालेन के मदत करथै। ");
INSERT INTO bhu_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","इहैनिता हे मनसे तुम जउन दूसर हे दोस लगाथा, तुम कउनो बहाना नेहको बनाय सकथा, काखे जउन बात हे तुम मनसेन के बुराई करथा, तुम खुदय उहै काम करथा। ");
INSERT INTO bhu_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","हम जानथन कि हइमेर काम करै बाले के बिरोध भगवान के नियाव सच्चाई हे आसरित हबै। ");
INSERT INTO bhu_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","हे मनसे तै असना काम करे बाले के उप्पर दोस लगाथस अउ तै खुदय ऊ काम करथस, ता तै का समझथस कि भगवान कर नियाव लग बच जइहे? ");
INSERT INTO bhu_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","का तै भगवान कर किरपा अउ सहन सीलता अउ धीर रूपी डेरा के बेकार जानथै, का हइ नेहको समझथै कि भगवान कर दया तोके मन बदलै करै के अगुवाई करथै। ");
INSERT INTO bhu_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","पय अपन कठोरता अउ कबहुन पस्चाताप नेहको करै बाले मन के कारन ओखर गुस्सा के अपन निता ऊ रोज के निता अक जिघा करथै, जब भगवान के सच्चा नियाव परगट होही। ");
INSERT INTO bhu_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","भगवान सब मनसेन के उनखर कामन के जसना पलटा देही। ");
INSERT INTO bhu_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","जउन मनसे सब रोज धीरज पूरक भलाई अउ महिमा इज्जत अउ जउन कबहुन नेहको मरै बाले के खोज हे लगे रही, उनही ओखर बदले हे सबरोज के जीवन देही। ");
INSERT INTO bhu_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","पय जउन मनसे खुदय के स्वारथी के खोज हे रथै, अउ जउन सच्चाई के खोज नेहको करथै, अउ जउन अनियाय करथै उनखर हे गुस्सा बोहत भडकही। ");
INSERT INTO bhu_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","अउ बुराई करै बाले सगलू मनसे के कस्ट अउ संकट आगू यहूदी अउ फेर यूनानी के सहै का पडही। ");
INSERT INTO bhu_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","अउ निक्खा काम करै बाले हर मनसे के पहिले यहूदी अउ फेर यूनानी के महिमा, इज्जत अउ सान्ति मिलही। ");
INSERT INTO bhu_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","काखे भगवान कउनो के पक्छपात नेहको करथै। ");
INSERT INTO bhu_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","जउन कउ मूसा कर नियम के वस हे नेहको हबै, अगर उन पाप करे हुइहिन, ता उन बिना मूसा कर किताब के नास हुइ जइहिन अउ जउन किताब के वस हे रहिके पाप करे हबै, उनही किताब के जसना सजा दय जही। ");
INSERT INTO bhu_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","काखे भगवान के नजर हे धरमी उन नेहको हबै, जउन मूसा कर किताब के बात सुनथै, पय धरमी मनसे उन हबै, जउन मूसा कर किताब के मानथै अउ चलथै। ");
INSERT INTO bhu_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","जब गैर यहूदी, जिनही मूसा कर किताब नेहको मिले हबै, उन खुदय ओखर आदेस के मानथै, ता उनखर लिघ्घो मूसा कर किताब न होत भरमा उन मूसा कर किताब खुद हबै। ");
INSERT INTO bhu_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","उन अपन मन हे लिखे हर नियम के काम के दिखाथै, उनखर मन खुदय गवाही देथै, अउ उनखर मन उनही कबहुन दोसी ता कबहुन बेकसूर ठहराथै। ");
INSERT INTO bhu_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","हइ सगलू बात ऊ रोज परगट करे जही, जब भगवान मोर संदेस के जसना, यीसु मसीह दवारा मनसेन के गुप्त पाप जउन करथै उनखर नियाव करही। ");
INSERT INTO bhu_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","अगर तै खुद के यहूदी कथस अउ मूसा कर नियम हे भरोसा धरथस अउ अपन भगवान हे गर्व करथस, ");
INSERT INTO bhu_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","अगर तुम ओखर इक्छा के जानथस जउन निक्खा हबै अउ उके परमाडित करथा, काखे तोके नियम दवारा आदेस दय जथै। ");
INSERT INTO bhu_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","अउ तै अपन खुदय हे बिस्वास करथस, कि अंधरन के गली दिखामै बाले अउ अंधियार हे पडे हर मनसेन के उजेड हव। ");
INSERT INTO bhu_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","भुखाय हरन के उपदेस लरकन के सिक्छा देय बाले हव, ग्यान अउ सत्य हइ सब मूसा कर किताब लग मिले हबै। ");
INSERT INTO bhu_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","पय तुम जउन दूसर के ग्यान देथस, अउ खुद के ग्यान नेहको देथा, तै परचार करथस, “कि चोरी झइ करा” अउ खुदय चोरी करथा। ");
INSERT INTO bhu_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","तै कथस, “कि गलत काम झइ करा” अउ खुदय गलत काम करथस, तै मूरती पूजा लग घिरना करथस, पय मंदिरन के पइसा लूटथस? ");
INSERT INTO bhu_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","तै मूसा कर नियम हे गर्व करथस, अउ मूसा कर नियम के उलंघन दवारा भगवान कर बेज्जती करथस। ");
INSERT INTO bhu_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","काखे जसना कि नियम हे लिखवरे हबै, “तुम्हर कारन अबिस्वासी गैर यहूदी हे भगवान के नाम के बुराई होत हबै।” ");
INSERT INTO bhu_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","खतना करामै लग जरूर फायदा होथै, अगर तै मूसा कर नियम के पालन करथस, पय अगर तै मूसा कर नियम के उलंघन करथस, ता तुम्हर खतना बेकार हबै। ");
INSERT INTO bhu_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","इहैनिता अगर कउ बिना खतना के मनसे मूसा कर नियम के मानथै, तब का ओखर बिना खतना होय हर जसना नेहको माने जही। ");
INSERT INTO bhu_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","गैर यहूदी खतना कराय बिगर नियम के पूर पालन करथै, उन तुम्हर नियाव करही, काखे तुम लिखित नियम अउ खतना लग खतम होय हर नियम के उलंघन करथा। ");
INSERT INTO bhu_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","काखे यहूदी ऊ नेहको जउन बाहरी रूप लग यहूदी हबै अउ खतना ऊ नेहको, जउन बाहरी अउ सरीर हबै। ");
INSERT INTO bhu_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","सही यहूदी ऊ हबै जउन भित्तर लग यहूदी हबै, सही खतना आतमा के दवारा मन के खतना हबै, न कि लिखेहर नियम के असना मनसे के बडाई मनसे नेहको बलुक भगवान कर तरफ लग करे जथै। ");
INSERT INTO bhu_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ता दूसर के अपेक्छा यहूदी के जादा का मिलिस? अउ खतना लग का फायदा? ");
INSERT INTO bhu_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","सब मेर लग बोहत कुछ सबले आगू यहूदिन के भगवान के बचन सउपे गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","अगर कउनो बिस्वास नेहको करै बाले निकडही, ता का हुइस? का उनखर बिस्वास नेहको होय लग भगवान के सच्चाई बेकार ठहरी का? ");
INSERT INTO bhu_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","दुनिया के सगलू ठगै बाले साबित होय सकथै पय भगवान सही हबै, जउन अपन बचन के पालन करत रही जसना के पवितर किताब हे लिखररे हबै, तुम अपन बातन हे धरमी मनसे साबित होय सकथै, अउ नियाव होमै लग जीत पइहा। ");
INSERT INTO bhu_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","पय हमार अधरम भगवान के नियाइपन दिखाथै ता हम काहिन कहि? का हइ जब भगवान गुस्सा होय लग उनही अधरमी कहे जही? मै हइ सगलू सही नजर लग कथो। ");
INSERT INTO bhu_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","कबहुन नेहको पय भगवान अन्याय होतिस, ता ऊ दुनिया के नियाव कसना के सकतिस? ");
INSERT INTO bhu_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","अगर मोर झूठ के चलते भगवान कर सच्चाई ओखर महिमा के निता, बोहत करके परगट होथै, ता मोके पापी घोसित काखे करे जथै। ");
INSERT INTO bhu_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","तब काखे नेहको कहिस, हमही बुराई करै देया, ताकि अच्छाई आय सकै, कुछ मनसे सहीमा मोर हे हइ बात कहै के इल्जाम लगाय के मोर बेज्जती करे हबै, कि ओखर निन्दा करे जाय असना होय चाही। ");
INSERT INTO bhu_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","तब का हम उनखर लग बढिहा हबन, बिलकुन नेहको हम पहिलेन हइ साफ के चुके हबन कि यहूदी अउ यूनानी सगलू पाप के वस हे हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","पवितर किताब के लेख इहै हबै, कउनो धरमी मनसे नेहको, अकोठे नेहको कउनो नेहको, जेहमा सोचै के सक्ति होय। ");
INSERT INTO bhu_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","कोनो समझदार नेहको हबै अउ कउनो भगवान के खोजै बाले नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","सबझन भगवान लग दुरिहां हुइ गइन, उन सब निकम्मा हुइ गइन कउनो किरपा करै बाले नेहको अकोठे नेहको। ");
INSERT INTO bhu_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","उनखर नठेरी मरघटी के जसना उघरे हबै, उन अपन जीभ लग झूठ बोलथै, उनखर बिबडा हे सपुवा के जहर हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","उनखर मुंह सराप अउ गारी गलउज लग भररे हर हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","उनखर गोड खून बहामै के निता एतका झटने उठत हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","उनखर गली हे बिनास अउ कलेस बिछरे हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","उन सान्ति के गली नेहको जानिन। ");
INSERT INTO bhu_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","उनखर आंखी हे भगवान के डर नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","अब हमही हइ पता हुइ गइस कि नियम के निरदेस उनखरै लग कथै, जउन नियम के वस हे हबै, कि सबके मुंह बन्द हुइ जाय अउ पूर दुनिया भगवान के आगू निरनय के निता काबिल ठहरे। ");
INSERT INTO bhu_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","काखे बलुक नियम के पालन करै के दवारा कउनो मनसे भगवान के आंखी हे धरमी मनसे घोसित नेहको हुइस, मूसा कर नियम के दवारा पाप के चिन्हारी होथै। ");
INSERT INTO bhu_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","पय अब टेम हइ हबै कि नियम के बिगर भगवान के नियाइपन परगट हुइ गय हबै, जेखर गवाही मूसा कर नियम अउ ग्यानी मनसे देथै। ");
INSERT INTO bhu_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","मतलब मसीह यीसु हे बिस्वास दवारा पाइस भगवान के नियाइपन, जउन उन सबके निता हबै, जउन मसीह यीसु हे बिस्वास करथै, काखे कउनो भेद नेहको। ");
INSERT INTO bhu_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","काखे सगलू झन पाप करे हबै अउ सगलू झन भगवान कर महिमा लग दुरिहां हुइ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","पय भगवान के अनुगरह लग पाप के छडामै के दवारा हर अक्ठी ऊ सेतमेत छडामै हे धरमी मनसे घोसित करे जथै, जउन मसीह यीसु हे हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","भगवान यीसु मसीह के मनसेन के निता बलि के रूप हे दइ दइस, खून बहोय लग गली बनिस, ओखर हे बिस्वास रखै बालेन लग मनसेन के पाप माफ के दय जाय, भगवान अपन नियाइपन दिखामै के निता पुरान टेम हे धीर धरिस अउ मनसेन के पाप के अनदेखा के दइस। ");
INSERT INTO bhu_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","कि ऊ हइ टेम के युग हे अपन नियाइपन परगट करै कि ऊ खुद के अउ उके धरमी मनसे घोसित करै, जेखर बिस्वास परभु यीसु मसीह हे हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","तब हमर घमंड कछो रहिस? एखर बहिस्कार के दय गय हबै, कामन के सिधान्त के दवारा नेहको? हइ हुइस बिस्वास के दवारा। ");
INSERT INTO bhu_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","हमर मान हइ हबै, मनसे नियम के पालन करै के दवारा नेहको पय अपन बिस्वास के दवारा धरमी मनसे घोसित करे जथै। ");
INSERT INTO bhu_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","का भगवान सिबाय यहूदियन के भगवान हबै? का ऊ गैर यहूदी के भगवान नेहको? ऊ जरूर गैर यहूदिन के भगवान हबै। ");
INSERT INTO bhu_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","काखे अक्ठिन भगवान हबै, जउन खतना करै बाले के बिस्वास लग अउ बिना खतना बालेन के बिस्वास के दवारा नियाइपन ठहराही। ");
INSERT INTO bhu_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ता का हम मूसा कर नियम के बिस्वास के दवारा बेकार कहथन? बिलकुन नेहको पय नियम के सिध्द करथन। ");
INSERT INTO bhu_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","इहैनिता हम काहिन कहि कि हमर सरीरिक बाफ अब्राहम के एहमा का मिलिस? ");
INSERT INTO bhu_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","काखे अगर अब्राहम के ओखर काम के कारन धरमी ठहराय जथै, ता ओखर गर्व करै के बात रथै, पय भगवान कर आगू ऊ सही हे गर्व नेहको के सकथै। ");
INSERT INTO bhu_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","पवितर किताब काहिन कथै? हइ कि अब्राहम भगवान हे बिस्वास करिस, अउ जेखर कारन ऊ धरमी मनसे गिनै गइस। ");
INSERT INTO bhu_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","अब जउन काम करथै, उके मजदुरिहा के उपहार के रूप हे नेहको बलुक हक के रूप हे दय जथै। ");
INSERT INTO bhu_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","पय अगर कउनो मनसे काम करै के सिबाय ऊ भगवान हे बिस्वास करथै, जउन पापी के छांड देथै, ता ओखर बिस्वास ओखर धरमी मनसे होयके कारन बन जथै। ");
INSERT INTO bhu_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","बिगर काम के अलाबा भगवान उके धरमी मनसे ठहराथै, उके दाऊद धन्य कथै। ");
INSERT INTO bhu_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","धन्य हबै, ऊ जेखर अधरम छमा हुइस, अउ ओखर पाप छमा करे गइस। ");
INSERT INTO bhu_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","“धन्य हबै ऊ मनसे जेखर पाप के परभु नेहको गिने हबै।” ");
INSERT INTO bhu_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ता का धन्य मनसे उहै हबै, जेखर खतना होय हबै, या उनखर निता जिनखर खतना नेहको हुइस, हम हइ घोसना करथन, अब्राहम अपन बिस्वास के दवारा नियाइपन धरमी मनसे गिने गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ता ऊ कसके माने गइस? खतना के दसा हे या बिगर खतना के दसा हे? खतना के दसा हे नेहको पय बिगर खतना के दसा हे। ");
INSERT INTO bhu_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","अब्राहम बिना खतना कराय बिस्वास के दवारा नियाइपन धरमी मनसे गिने गइस, ओखर उप्पर सील के रूप हे खतना चिन्हा लगाय गइस, हइ मेर ऊ उन सबके बाफ बनिस, जउन खतना कराय बिना बिस्वास करथै, जेखर लग उनखर बिस्वास के दवारा धरमी मनसे माने जाय। ");
INSERT INTO bhu_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","अब्राहम उन खतना बालेन के बाफ बनिस, जउन न केबल खतना हे बिस्वास रथै, बलुक हमर बाफ अब्राहम के ऊ बिस्वास के रास्ता हे चलथै, जउन ऊ खतना के आगू भगवान हे बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","भगवान अब्राहम अउ ओखर लरकन लग टीमा करिस कि उन दुनिया के वारिस हुइहिन, हइ इहैनिता नेहको हुइस कि अब्राहम नियम के माने हबै, बलुक इहैनिता कि ऊ बिस्वास करिस अउ भगवान उनही बिस्वास के दवारा धरमी मनसे माने हबै। ");
INSERT INTO bhu_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","अगर नियम के वस हे रहै बाले वारिस बनथै, ता बिस्वास बेकार हबै अउ टीमा बेकार हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","मनसे दवारा नियम के नेहको माने जाय लग भगवान के गुस्सा भडकथै, जछो नियम नेहको उछो पापो नेहको। ");
INSERT INTO bhu_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","सब कुछ बिस्वास हे अउ इहैनिता अनुगरह हे बिस्वास रथै, ऊ टीमा न केबल उन मनसे हे, जउन नियम के मानथै, बलुक सगलू वंस हे लागू होथै अउ उन सगलुन के उप्पर जउन अब्राहम के जसना बिस्वास करथै, अब्राहम हम सबके बाफ हबै। ");
INSERT INTO bhu_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","जसना लिखवरे हबै “मै तोके गैर यहूदी के बाफ बनाय हव।” भगवान के नजर हे अब्राहम हमर बाफ हबै, उन ऊ भगवान के उप्पर बिस्वास करिस, जउन मरे हर के फेरै जिन्दा के देथै अउ उन चीजन के पहिचान हे लाथै, जिनखर कउनो पहिचान नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","सगलू आसा के खिलाप अब्राहम बिस्वास हे बने रथै, इहैनिता सही देस के बाफ बनिस जसना कि ओखर लग उहां रथै, कि तुम्हर अनगिनत बंसज होही। ");
INSERT INTO bhu_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","अब्राहम जानत रहै कि ओखर देह कमजोर हुइ गय हबै, अउ मोर उमर सव साल के हुइ गय हबै, अउ मोर डउकी सारा बांझ हबै, तउभरमा ओखर बिस्वास नेहको डगमगाइस। ");
INSERT INTO bhu_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","फेर भगवान के टीमा के बारे हे बिस्वास लग नेहको डोलिस, पय अपन बिस्वास हे मजबूत रहिस अउ भगवान के महिमा करिस। ");
INSERT INTO bhu_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","उके पूर बिस्वास रथै कि भगवान जउन टीमा दय हबै, उके पूर करै हे ऊ पूरी तरह अटल हबै। ");
INSERT INTO bhu_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","“हइ बिस्वास के कारन भगवान उके धरमी मनसे माने हबै।” ");
INSERT INTO bhu_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ओखर निता धरमी मनसे माने गइस, हइ सब्द बलुक उनखर बारे हे नेहको ");
INSERT INTO bhu_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","बलुक हमारो निता हबै, अगर हम भगवान हे बिस्वास करब, जेही हमर परभु यीसु के मिरतू लग जिन्दा करे हबै ता हमु बिस्वास के कारन धरमी मनसे माने जउबे। ");
INSERT INTO bhu_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","उहै यीसु हमर पाप के कारन पकडाय गइस अउ हमर नियाव करै के निता जी उठिस। ");
INSERT INTO bhu_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","इहैनिता जब हम अपन बिस्वास के दवारा धरमी मनसे घोसित करे जाय चुके हबै, ता भगवान के संग हमर मेल जोल परभु यीसु मसीह के दवारा होय चुके हबै। ");
INSERT INTO bhu_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","जिनखर माध्यम लग हम फेरै अनुगरह हे बिस्वास दवारा पहुंच गय हवन, जेखर लग हम अब ठाड हबै अउ हम भगवान के महिमा के आसा हे घमंड करथन। ");
INSERT INTO bhu_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","एतको नेहको हम पीरा अउ समस्या हे घमंड करबे, काखे हम जानथन कि पीरा समस्या लग धीर पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","अउ धीर मसे खरा सोभाव अउ खरा सोभाव मसे आसा पइदा होथै। ");
INSERT INTO bhu_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","अउ आसा लग लज्जा नेहको होथै, काखे भगवान हमही पवितर आतमा दय हबै अउ ओखर निता भगवान कर माया हमर मन हे भरे हबै, ");
INSERT INTO bhu_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","जब हम ढिलवा रहन, तब मसीह यीसु पापी मनसेन के निता मरिस। ");
INSERT INTO bhu_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","कउनो नियाइपन के निता कउनो मरे ऊ ढिलवा हबै, पय कउनो धरमी मनसे के निता मरै के हिम्मत करै। ");
INSERT INTO bhu_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","पय हम पापी रहन, जब यीसु मसीह हमर निता मरिस, असना करके भगवान अपन माया परगट करिस। ");
INSERT INTO bhu_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","अगर हम मसीह के खून के कारन धरमी मनसे ठहराय गय हबन, ता हम जरूर मसीह के दवारा भगवान के क्रोध लग बच जउबे। ");
INSERT INTO bhu_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","हम बैरी रहन, जब भगवान के संग हमर मेल ओखर टोरवा के मिरतू दवारा हुइ गइस अउ भगवान के संग मेल हुइ जाय के बाद, ओखर टोरवा के जीवन दवारा जरूर हमर मुकति हुइस। ");
INSERT INTO bhu_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","एतको नेहको, परभु यीसु मसीह के कारन हम भगवान हे मगन हवन, जेखर कारन हम हइ मेलजोल के दसा तक पहुंचे हबन। ");
INSERT INTO bhu_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","अक्ठी मनसे के कारन हइ दुनिया हे पाप परबेस करिस अउ पाप के दवारा मिरतू अउ मिरतू सगलू मनसेन हे समाय गइस, काखे सगलू मनसे पाप करिन। ");
INSERT INTO bhu_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","मूसा कर नियम लग पहिले दुनिया हे पाप रहिस, पय नियम के अभाव हे पाप के लेखा नेहको रखे रथै। ");
INSERT INTO bhu_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","फेरै आदम लग मूसा तक मिरतू उनखर हे राज करथै, जेहमा आदम उन आदेस के नेहको टोरथै, मतलब पाप नेहको रथै, आदम ऊ मनसे के रूप हबै जउन आमै बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","अपराध बरदान के जसना नेहको, अक्ठी मनसे के अपराध के कारन कइझन के मिरतू हुइस, भगवान के अनुगरह अउ अक्ठी मनसे, मसीह यीसु के अनुगरह हे नियाव मिल गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","अक्ठी मनसे के अपराध अउ भगवान के बरदान हे कउनो बराबरी नेहको हबै, अक्ठी अपराध के कारन सजा के आदेस दय गइस अउ अपराध के बाद मुकति के बरदान दय गइस जेहमा नियाव मिल गइस। ");
INSERT INTO bhu_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","काखे जब अक्ठी मनसे के अपराध के कारन अक्ठिन मनसे के दवारा मिरतू के सासन हुइ गइस, ता एखर लग कहुं बोहत फइले हर बडा अनुगरह अउ नियाइपन के ऊ बरदान जउन उनखर जीवन हे ऊ अक्ठी मनसे यीसु मसीह के दवारा सगलू के पाप लग नियाव मिलिस। ");
INSERT INTO bhu_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","इहैमेर हम देखथन कि जउन मेर अक्ठिन मनसे के अपराध के कारन सगलू के सजा के आदेस मिलिस, उहैमेर अक्ठी मनसे के धरमी काम के कारन सब के पाप लग जीवन मिलिस। ");
INSERT INTO bhu_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","काखे जसना अक्ठी मनसे के आदेस नेहको मानै लग बोहत मनसे पापी कहइहों, ओसनेन अक्ठी मनसे के आदेस मानै लग बोहत लग धरमी मनसे बनाय दय जही। ");
INSERT INTO bhu_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","बाद हे मूसा कर नियम दय गइस अउ एखर लग अपराध के गिनती बढ गइस, पय जिहां पाप बढिस, उहां अनुगरहो ओखर लग कहुं बोहत बढिस। ");
INSERT INTO bhu_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","जउन मेर पाप मिरतू हे सासन करिस, उहैमेर अनुगरह नियाइपन के दवारा हमर परभु मसीह यीसु हे सबरोज के जीवन निता सासन करही। ");
INSERT INTO bhu_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","हम काहिन कहि, कि हम पाप करतै रही? भगवान के अनुगरह अपन उप्पर होत रहे। ");
INSERT INTO bhu_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","बिलकुन नेहको, हइ कसना सम्भव हबै, कि हम जउन पाप के परति मर चुके हबै, उहै हे जीवन गुजारी। ");
INSERT INTO bhu_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","का तुम हइ नेहको जानथा कि यीसु मसीह के जउन बतिस्मा हम सब के मिले हबै, ऊ उनखर मिरतू के बतिस्मा हबै? ");
INSERT INTO bhu_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","हम उनखर मिरतू के बतिस्मा गरहन के ओखर संग इहैनिता गाडे गय हवन कि जउन मेर मसीह बाफ के महिमामय सक्ति लग मरे हर मसे जी उठे हबै, उहैमेर हमु अक्ठी नबा जीवन जी। ");
INSERT INTO bhu_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","अगर हम हइमेर मसीह के जसना मर के ओखर संग अक हुइ गय हवन ता हमु ओखरै के जसना फेरै जिन्दा हे ओखर संग अक्ठी होब। ");
INSERT INTO bhu_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","हमही कबहुन नेहको बिसरे के चाही कि हमर पुरान आदत मसीह के संग क्रूस हे टंगाय जाय चुके हबै, जेखर लग पाप के देह मर जाय अउ हम फेर पाप के हरवाह झइ बनी। ");
INSERT INTO bhu_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","काखे जउन मर चुके हबै, ऊ पाप के गुलामी लग आजाद हुइ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","हमही बिस्वास हबै कि अगर हम मसीह के संग मर गय हबै, ता हम ओखर संग जिन्दा रहबे। ");
INSERT INTO bhu_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","काखे हम जानथन कि मसीह मरे हर मसे जिन्दा होय के बाद फेर कबहुन नेहको मरिस अब मिरतू के ओखर हे कउनो हक नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ऊ अकबेर हम सबके के निता पाप हे मर गइस ऊ जिन्दा हुइ गइस अउ भगवान के निता जीथै। ");
INSERT INTO bhu_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","इहैनिता तुमो अपन खुद के पाप के परति मरे हर अउ मसीह यीसु हे भगवान के परति जिन्दा समझा। ");
INSERT INTO bhu_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","अब तुम अपन नास होय बाले देह हे पाप के राज सुइकार झइ करा अउ ओखर लालच के वस हे झइ रहा। ");
INSERT INTO bhu_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","तुम अपन देह के अंगन के अनियाय के साधन बनै के निता पाप के अरपित झइ करा, तुम अपन के मिरतू मसे फेरै जिन्दा समझ के भगवान के परति अरपित करा अउ अपन अंगन के नियाइपन के साधन बनै के निता भगवान के सउप देया। ");
INSERT INTO bhu_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","तुम्हर हे पाप के कउनो हक झइ रही, अब तुम नियम के नेहको बलुक अनुगरह के वस हे हबा। ");
INSERT INTO bhu_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ता का हम इहैनिता पाप करी कि हम नियम के नेहको, बलुक अनुगरह के वस हवन? बिलकुन नेहको। ");
INSERT INTO bhu_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","का तुम नेहको समझथा कि तुम अपन आदेस के मानै बाले हरवाह के रूप हे जेखर परति अरपित करथै अउ जेखर आदेस के पालन करथै, तुम उहै के गुलाम बन जथा? हइ गुलाम चाहे पाप के होय, जेखर परिनाम मिरतू हबै, चाहे भगवान के होय, जेखर आदेस मानै के परिनाम नियाइपन हबै। ");
INSERT INTO bhu_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","भगवान के धन्यबाद कि तुम जउन पहिले पाप के गुलाम रथा, अब सगलू हिरदय लग ऊ मानके सिक्छा के गली हे रेंगै लगा, जउन अनुगमन के निता तुमही दय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","तुम पाप लग मुक्त हुइके नियाइपन के गुलाम बन गय। ");
INSERT INTO bhu_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","का तुमही हइ अहसास नेहको कि कउनो के आदेस मानै के परति समरपित हुइ जाय लग तुम उहै के हरवाह बन जथा, जेखर तुम आदेस मानथा? चाहे ऊ मालिक पाप होय या असुध्द अउ अधरम के अधीन करे रथै, जेखर आखरी हबै मिरतू या आदेस के मानै बाले जेखर आखरी हबै नियाइपन, जेखर लग पवितर हुइ जाय। ");
INSERT INTO bhu_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","काखे जब तुम पाप के हरवाह रथा, ता नियाइपन धरमी के तरफ लग अजाद रहा। ");
INSERT INTO bhu_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ऊ टेम तुमही उन काम लग का फायदा हुइस? अब उनखर कारन तुमही लज्जा होथै, काखे उनखर परिनाम मिरतू हबै। ");
INSERT INTO bhu_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","पय अब पाप लग आजाद हुइ के तुम भगवान के गुलाम बन गय अउ पवितरता के फल उत्पन्न करथै, जेखर परिनाम हबै सबरोज के जीवन। ");
INSERT INTO bhu_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","काखे पाप के मजदूरी ता मरै के हबै, पय भगवान के बरदान हमर परभु यीसु मसीह हे सबरोज के जीवन हबै। ");
INSERT INTO bhu_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","भाई अउ बेहन, का तुम हइ नेहको जानथा, मै नियम के जाने बालेन लग बोलथो, कि मनसे हे नियम के हक तबै तक हबै, जब तक ऊ जिन्दा हबै? ");
INSERT INTO bhu_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","काज होय हर डउकी ऊ अपन डउका के नियम लग बंधे रथै, जब तक ऊ जिन्दा रथै, अगर डउका मर जथै, ता ऊ अपन डउका के बंधन लग आजाद हुइ जथै। ");
INSERT INTO bhu_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","इहैनिता अगर कउनो डउकी के डउका के जियत जउन कउ दूसर डउका के हुइ जाय, ता उके बेभिचारनी कहाथै, पय ओखर डउका मर जइ, ता ऊ मूसा कर नियम के जसना ओखर लग आजाद हुइ गइस अउ कउनो दूसर डउका के संग रहै लग जाय, ता कउनो पाप नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","हे मोर भाई, असना मसीह के देह के दवारा नियम के निता तुमो मर चुके हबा, इहैनिता अब तुमो कउनो दूसर लग रिस्ता जोड सकथै, ओखर लग जउन मरे हर मसे फेरै लग जिन्दा करे गय हबै, ताकि हम भगवान के निता फडुहा के लान सकि। ");
INSERT INTO bhu_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","काखे जब हम मनसे के आदत जसना जियत रहन, हमर पाप पूरी तरह लालसा जउन नियम के दवारा आय रथै, हमर अंग हे हाबी रथै, ताकि हम असना खेती करी, जेखर परिनाम मिरतू हबै। ");
INSERT INTO bhu_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","पय अब नियम लग मुकति मिल गय हबै, काखे जउन नियम हमही बांध के धरे रथै, ओखर निता हम मर गय हबन, अउ अब पुरान नियम के दवारा नेहको बलुक आतमा के नबा रीति के दवारा हम अपन भगवान के सेबा करथन। ");
INSERT INTO bhu_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","एखर का मतलब हबै कि नियम पाप हबै? कबहुन नेहको फेर नियम के दवारा पाप के पता चलिस अगर नियम नेहको कहे होतिस, लालच झइ करा ता मै हइ नेहको जानथो कि लालच का हबै। ");
INSERT INTO bhu_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","हइ आदेस लग फायदा उठायके पाप मोर हे सबमेर के लालच पइदा करिस, नियम के कारन पाप मरे हर हबै। ");
INSERT INTO bhu_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","अक्ठी टेम रथै, जब नियम नेहको रथै अउ मै जिन्दा रथो, पय आदेस के आमै लग पाप जिन्दा हुइस। ");
INSERT INTO bhu_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","अउ मोर मिरतू हुइ गइस अउ ऊ आदेस जेखर लग जीवन के निता रथै, मोर मिरतू के कारन बनिस। ");
INSERT INTO bhu_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","काखे पाप आदेस लग फायदा उठायके मोके नर दइस अउ मारो दइस। ");
INSERT INTO bhu_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","इहैनिता मूसा कर नियम पवितर हबै अउ आदेस पवितर हबै, धरमी अउ निक्खा हबै। ");
INSERT INTO bhu_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","तब का ऊ, जउन निक्खा हबै, मोर निता मिरतू के कारन हुइ गइस? बिलकुन नेहको, भलाई के दवारा पाप मोर हे मिरतू पइदा के दइस, कि पाप के पाप के रूप हे परदरसित करे जाय अउ आदेस के दवारा हइ बोहत पापमय परमाडित हुइस। ");
INSERT INTO bhu_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","हम जानथन कि मूसा कर नियम तो आतमिक हबै, पय मै देह अउ पाप के हाथ हे बिके हर हरवाह हबो। ");
INSERT INTO bhu_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","मै नेहको समझथो कि मै का करथो, जउन मै करै चाहथो ऊ नेहको पय मै जेखर लग घिरना करथो मै उहै करथो। ");
INSERT INTO bhu_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","अउ अगर मोके हइ निक्खा नेहको लगथै, मै उहै करथो, ता मै हइ बात मान लेहूं, कि मूसा कर नियम बोहत बढिहा हबै। ");
INSERT INTO bhu_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","इहैनिता अब हइ काम करै बाले मै नेहको, मोर हे बसे हर पाप करथै। ");
INSERT INTO bhu_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","मोके पता हबै कि मोर धरमी मोर हे नेहको हबै मतलब मनसे के देह के सोभाव हे भले मोर मन हे निक्खा करै के मरजी हबै, पय मै निक्खा नेहको कर सकथों। ");
INSERT INTO bhu_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","जब मै नियम के देखथो, भलाई करै के इक्छा करथो, ता बुराई मोर लिघ्घो रथै। ");
INSERT INTO bhu_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","पय अगर मै उहै काम करथो, जेही मै नेहको चाहथो, ता काम करै बाले मै नेहको हबो, बलुक मोर भित्तर रहै बाले पाप हबै। ");
INSERT INTO bhu_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","इहैमेर मोर अनुभव हइ हबै, कि जब मै भलाई करै के इक्छा करथो ता बुराइन करथो। ");
INSERT INTO bhu_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","काखे मै मनसे के भित्तर आतमा लग भगवान के नियम लग बोहत मगन रथो। ");
INSERT INTO bhu_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","पय मै अपन देह के अंग हे अक दूसर नियम देखथो, हइ मोर दिमाक हे मउजूद नियम के बिरोध लडथै, हइ मोके पाप के नियम के जउन मोर देह के अंग हे मउजूद हबै, गुलाम बनाय रखिस। ");
INSERT INTO bhu_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","मै केतका पापी मनसे हबो, हइ मिरतू के अधीन रहै बाले देह लग मोके कोन आजाद करी? ");
INSERT INTO bhu_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","हमर परभु यीसु मसीह के दवारा भगवान कर धन्यबाद होय, इहैनिता अपन दिमाक लग तो भगवान के नियम के, पय देह लग पाप के नियम के सेबा करथो। ");
INSERT INTO bhu_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","जउन मनसे यीसु मसीह हे हबै, उनखर हे सजा के आदेस नेहको, काखे उन देह के जसना नेहको पय पवितर आतमा के नियम के जसना चलथै। ");
INSERT INTO bhu_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","काखे मसीह यीसु हे बसे हर जीवन लग मूसा कर नियम तोके पाप अउ मिरतू के किताब लग आजाद के दय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","जउन मूसा कर ऊ नियम जउन मनसे के पाप के आदत के कारन ढिलवा बना दय रथै, नेहको के सकिस उके भगवान अपन टोरवा के हमर जसना देह हे पठोय के जेखर लग हम पाप करथन, ओखर भवतिक देह के पाप बाले बनाय के, पाप के हराय के पूर करिस। ");
INSERT INTO bhu_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","कि हम जउन पापी आदत के जसना नेहको पय पवितर आतमा के जसना आदत रखी, मूसा कर नियम के जसना पूर हुइ जाय। ");
INSERT INTO bhu_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","काखे देह के इक्छा रखै बाले मनसे अपन देह हे मन लगाथै, पय अन्तरयामी आतमा के बातन हे मन लगाथै। ");
INSERT INTO bhu_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","देह हे मन लगामै के तो मिरतू हबै, पय आतमा हे मन लगामै के जीवन अउ सान्ति हबै, ");
INSERT INTO bhu_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","काखे देह हे मन लगाना तो, भगवान लग बैर करैका हबै, काखे असना न तो भगवान कर नियम के दवारा हबै अउ न हुइ सकथै। ");
INSERT INTO bhu_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","जउन मनसे देह के आदत के वस हे हबै, ऊ भगवान के खुस नेहको के सकथै। ");
INSERT INTO bhu_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","पय तुम पापी आदत के नेहको पय पवितर आतमा हे होय अगर सहीमा तुम्हर हे भगवान कर आतमा रथै, जउन मनसे के भित्तर मसीह के आतमा नेहको रथै, ऊ मसीह के नेहको हुइ सकै। ");
INSERT INTO bhu_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","अगर मसीह तुम्हर भित्तर रथै, ता पाप के कारन तोर देह मर चुके हबै, पय तउभरमा भगवान के धरमी काम के कारन तोर आतमा ही तुम्हर जीवन हबै। ");
INSERT INTO bhu_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","अगर ओखर आतमा लग मसीह के मरे हर मसे जिन्दा करिस, तुम्हर हे वास करथै, ता जउन तुम्हर मरन देह के अपन आतमा के दवारा हइ तुम्हर हे बसे हर हइ जिन्दा रखी। ");
INSERT INTO bhu_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","इहैनिता हे भाई हम देह के करजा बाले नेहको हबै, कि हमही देह के जसना जीवन नेहको जियेका चाही। ");
INSERT INTO bhu_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","काखे अगर तुम देह के जसना दिन कटिहा ता मरिहा, अगर आतमा लग देह के पाप के मरिहा, ता जिन्दा रइहा। ");
INSERT INTO bhu_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","इहैनिता कि जेतका मनसे भगवान के आतमा के जसना चलथै, उहै भगवान कर टोरवा हबै। ");
INSERT INTO bhu_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","काखे ऊ आतमा जउन तुमही मिले हबै, तुमही फेरै लग हरवाह बनामै या डरामै के निता नेहको हबै, बलुक ऊ आतमा जउन तुम पाय हबा, पय तुमही गोद लेय बाले के आतमा दय गय हबै, जेखर लग हम चिल्ला उठथन, “हे बाफ।” ");
INSERT INTO bhu_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ऊ पवितर आतमा खुदय हमर आतमा के संग मिलके गवाही देथै, कि हम भगवान कर टोरवा हबन। ");
INSERT INTO bhu_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","काखे हम ओखर टोरवा हबन, हमु ओखर वारिस हबन, भगवान अउ मसीह के संग हम वारिस हबन, अगर सहीमा ओखर संग दुख उठाथन, तबै हमही ओखर संग महिमा मिलही। ");
INSERT INTO bhu_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","मै समझथो कि हमर उप्पर जउन महिमा परगट होयका हबै, ओखर बरोबरी हे हइ टेम के दुख कुछु नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","काखे हइ दुनिया बडी आसा के संग ऊ टेम के ओरगे हबै, जब भगवान कर टोरवा के परगट करे जही। ");
INSERT INTO bhu_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","हइ रचना तो उदेस्य के बिगर हुइ गय हबै, हइ अपन इक्छा के जसना नेहको पय भगवान के इक्छा के जसना होय हबै, जउन उके हइ आसा हे अधीन के दय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","कि खुदय दुनिया बिनास के गुलाम लग मुकति पाय के भगवान कर टोरवा के महिमा अउ आजाद के मगन होही। ");
INSERT INTO bhu_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","हमही पता हबै कि आज तक सगलू दुनिया कस्ट अउ दुख लग कराहथै। ");
INSERT INTO bhu_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","अउ सिबाय दुनिया परेसान हुइके नेहको तडपथै, पय हमु परेसान होथन, जिनही आतमा के फडुहा मिलिस, जउन खुदय कराहथै, अउ लेपालक टोरवा बनै के मतलब अपन देह के मुकति के निता ओरगथन। ");
INSERT INTO bhu_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","जउन चीज के आसा के दवारा करे जथै, ऊ देखै हे आय, ता फेर आसा कछो हबै, काखे जउन चीज के कउ देखथै, आसा काहिन करी? ");
INSERT INTO bhu_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","अगर हमर आसा के बारे ऊ हबै, जेही हम देखे नेहको हबन, तब हम धीर लग अउ बोहत आसा हे ओरगथन। ");
INSERT INTO bhu_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","पवितर आतमा हमर ढिलवा हे हमर मदत करथै, हम हइ नेहको जानथन कि हम कसना बिनती करै चाही, पय आतमा खुदय हुकरी भर के जउन सब्द दवारा परगट नेहको करे जाय सकथै, हमर निता बिनती करथै। ");
INSERT INTO bhu_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","भगवान हमर मन के बात जानथै अउ समझाथै, कि आतमा के मकसद काहिन हबै? काखे आतमा भगवान के इक्छा के जसना हरवाहन के निता बिनती करथै। ");
INSERT INTO bhu_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","हम जानथन कि जउन मनसे भगवान लग माया करथै, अउ ओखर मकसद के जसना बुलाय गय हबै, भगवान उनखर भलाई के निता सगलू बातन हे उनखर मदत करथै। ");
INSERT INTO bhu_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","जिनही पहिलेन लग भगवान चुने हबै कि उन पहिलेन अपन टोरवा के स्वरूप ठहराय हबै, काखे ऊ बोहत लग भाइन हे भाई बन सके। ");
INSERT INTO bhu_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","इन सगलू बातन के देखत हम काहिन कह सकथन? अगर भगवान हमर पल्ला हबै ता हमर बिरोध कोहर कर सकथै। ");
INSERT INTO bhu_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","अउ काहिन कहि? अगर भगवान हमर तरफ हबै, ता कोहर हमर बैरी होही? ");
INSERT INTO bhu_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","भगवान अपन खास टोरवा के नेहको बचाइस, ऊ हम सब के निता उके सउप दइस, ता एतका देय के बाद का ऊ हमही अपन टोरवा के संग सब कुछ फिरी हे नेहको देही? ");
INSERT INTO bhu_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","जिनही भगवान चुने हबै, उनखर हे कोहर आरोप लगाय सकि? भगवान उनही नियाइ ठहरामै बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","फेर कोहर हबै जउन हमही सजा के हुकुम देही, यीसु मसीह हे जउन मर गय रथै, अउ मुरदा लग जिन्दा होही अउ भगवान के दहिना पल्ला हबै अउ ऊ हमर निता निबेदन करथै। ");
INSERT INTO bhu_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","कोहर हमही मसीह के माया लग अलगे के सकथै, का समस्या या संकट का अतियाचार भूख कंगाली जोखिम या तलबार? ");
INSERT INTO bhu_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","जसना लिखवरे हबै, तोर निता दिन भर हमर हत्या होथै, हम बलि होय के निता गेडरा के जसना समझे जथै। ");
INSERT INTO bhu_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","पय हइ सगलू बातन हे हम भगवान के दवारा जउन हमर लग माया करिस, बिजय लग बढके हबै। ");
INSERT INTO bhu_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","काखे मै हइ जानथो, कि न तो मिरतू, न जीवन, न स्वरगदूत, न परधान, न भभिस्य, न सक्ति, ");
INSERT INTO bhu_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","न ऊंच न गहिड अउ न कउ अउ दुनिया के कउनो जीव हमही भगवान के माया लग जउन हमर परभु यीसु मसीह हे हबै, बिरका नेहको सकहिन। ");
INSERT INTO bhu_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","मै यीसु मसीह हे सही कथो, मै झूठ नेहको बोलथो अउ मोर मन पवितर आतमा हे गवाही देथै। ");
INSERT INTO bhu_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","मोके बोहत दुख हबै अउ मोर मन लगेतार पीरा हे रथै। ");
INSERT INTO bhu_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","काखे मै इहै चाहत रहों कि अपन भाई के निता, जउन देह के मेर लग मोर बिरादरी हबै, खुदय मसीह लग सापित हुइ जथो अउ मसीह लग अलगे हुइ जांव। ");
INSERT INTO bhu_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","जउन इस्राएली हबै अउ जिनही भगवान के कोरा हे लय हर टोरवा होमैके हक हबै, जउन भगवान के महिमा के दरसन के चुके हबै, जउन भगवान के दाबेदार भागीदारी हबै, जिनही उपास अउ बचन टीमा परदान करे हबै। ");
INSERT INTO bhu_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","बडा पुरखा उनखरै हबै अउ देह के रिस्ता मसीह उनखरै मसे आय, परम परधान भगवान के जुगजुग धन्य हबै, ओसनेन होय। ");
INSERT INTO bhu_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","असना नेहको हबै कि भगवान अपन बचन पूर नेहको करिस, काखे जउन इस्राएल के टोरवा हबै, उन सगलू इस्राएली नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","अउ न अब्राहम के टोरवा होमै के कारन उन सगलू सहीमा अब्राहम कर टोरवा हबै, बलुक जसना भगवान कथै, तोर टोरवा इसहाक के दवारा अपन बिरादरी बढइहिन। ");
INSERT INTO bhu_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","एखर मतलब हइ हबै, कि जउन देह लग जनम लेथै, ऊ भगवान कर टोरवा नेहको हबै, बलुक जेखर जनम टीमा के जसना होय हबै, उहै भगवान कर टोरवा माने जही। ");
INSERT INTO bhu_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","काखे टीमा के बचन हइ हबै, “मै सही टेम हे फेरै अइहों अउ तब सारा के अक्ठी टोरवा पइदा होही।” ");
INSERT INTO bhu_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","एतको नेहको, रिबका के लादा हे अक्ठी टोरवा मतलब हमर पुरखा इसहाक लग दुइठे लरका हुइस। ");
INSERT INTO bhu_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ता अब तक न टोरवा पइदा हुइस अउ न ऊ भला अउ बुरा करे रथै, इहैनिता भगवान के इक्छा हइ हबै कि ओखर चुने के जसना निक्खा काम के कारन लग नेहको पय बुलाय जाय के कारन लग बने रहै। ");
INSERT INTO bhu_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ऊ कथै बडडे टोरवा, नान टोरवा के सेबा करी। ");
INSERT INTO bhu_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","जसना लिखवरे हबै, “मै याकूब लग माया करव अउ एसाव लग बैर।” ");
INSERT INTO bhu_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","इहैनिता हम काहिन कहि? का हइ बारे हे भगवान अन्यायी हबै? बिलकुन नेहको। ");
INSERT INTO bhu_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","“भगवान मूसा लग कथै, मै जेखर उप्पर दया करै चाहथो, उहै के उप्पर दया करिहों अउ जेखर उप्पर किरपा करै चाहथो, उहै के उप्पर किरपा करिहों।” ");
INSERT INTO bhu_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","इहैनिता हइ मनसे के इक्छा या ओखर मेहनत हे नेहको, बलुक दया करै बाले भगवान के उप्पर रथै। ");
INSERT INTO bhu_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","काखे मूसा कर पवितर किताब हे भगवान फिरोन लग कथै, “मै तोके इहैनिता ठाड करै रथो कि मै अपन सक्ति तोर उप्पर दिखाय सको अउ मोर नाम सगलू भुंइ हे परचार हुइ सकै।” ");
INSERT INTO bhu_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","इहैनिता भगवान जेखर उप्पर दया चाहथै, ओखर उप्पर दया करथै अउ जेही चाहथै, उके कठोर बनाय देथै। ");
INSERT INTO bhu_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","तुम मोर लग कइहा, “भगवान के मनसे हे काखे दोस लगाथा भगवान के इक्छा के बिरोध कोहर के सकथै?” ");
INSERT INTO bhu_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","हे मनसे तुम कोन हबा, जउन भगवान काहिन जबाब देथा? का बनाय हर चीज बनामै बाले लग पूछ सकथै, “कि तै मोके असना काखे बनाय हबस?” ");
INSERT INTO bhu_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","का कुम्हरा के माटी हे हक नेहको? कि अक्ठिन लोंदी मसे अक्ठिन भडवा आदर के निता अउ दूसर के बेज्जती के निता बनाय। ");
INSERT INTO bhu_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","पय एहमा का हबै, अगर भगवान अपन गुस्सा दिखामै के निता अउ अपन सक्ति परगट करै के निता उन मनसेन के जउन गुस्सा के निता रथै अउ जिनखर नास होय बाले रथै, बोहत धीर के संग उन बातन के सहन करिन। ");
INSERT INTO bhu_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ऊ असना इहैनिता करिस कि ऊ दया के उन हकदारन के उप्पर अपन महिमा के सक्ति के परगट करै चाहथै, जिनही ऊ पहिलेन लग ऊ महिमा के निता तइयार करे रथै। ");
INSERT INTO bhu_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","असना दया के हकदार हम हवन, जिनही ऊ न केबल यहूदियन मसे बुलाय हबै, बलुक गैर यहूदी मसे बुलाय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","जसना कि होसे के किताब हे लिखवरे हबै, “जउन मोर मनसे नेहको रथै, उनही मै अपन कइहों, अउ जउन मोर हे पिरिया नेहको रथै, मै उनही पिरिया कइहों। ");
INSERT INTO bhu_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","अउ जउन जिघा हे ऊ उनखर लग कहे रथै, तुम मोर मनसे नेहको हबा, उहै जिन्दा भगवान कर टोरवा कहइहिन।” ");
INSERT INTO bhu_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ग्यानी मनसे यसायाह इस्राएल के बारे हे पुकार के कथै, “इस्राएलियन के गिनती समुन्दर के कुदरा के जसना काखे झइ हुइ जाय, पय उन मसे केबल चुटु हस बच पइहिन। ");
INSERT INTO bhu_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","काखे परभु के आदेस लग हरबी भुंइ हे अपन बात पूर करी।” ");
INSERT INTO bhu_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","जसना ग्यानी मनसे यसायाह आगुन कहे रथै, सेनाओ के परभु हमर निता पुरखा नेहको छांडथै, ता हम सदोम सहर के जसना अउ अमोरा सहर के जसना पूरी तरह लग नास हुइ जइतन। ");
INSERT INTO bhu_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","हम काहिन कहि? एखर मतलब हइ हबै कि गैर यहूदी जउन नियाइपन के खोज हे नेहको लगे रथै, नियाइपन, मतलब बिस्वास के बल हे नियाइपन पइन। ");
INSERT INTO bhu_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","पय इस्राएली मनसे जउन असना किताब हे चलै चाहथै जउन उनके नियाइपन बनाथै, पय ओखर जसना नेहको चल सकिन। ");
INSERT INTO bhu_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","काखे नेहको? काखे उन एखर पालन बिस्वास लग नेहको करथै, बलुक अपन करम लग करत रहै, ऊ डोंगर हे ठोकड खाय गइन, जउन ठोकड दिलाथै। ");
INSERT INTO bhu_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","जसना लिखवरे हबै, देखा, “मै सियोन हे अक्ठी पथरा रखथो, जउन ठोकड दिलाथै अउ परिक्छा हे डालै बाले पथरा धरथै, पय ऊ जउन ओहमा बिस्वास करथै, उके कबहुन निरास नेहको होमैके हबै।” ");
INSERT INTO bhu_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","हे भाई मोर आसा अउ भगवान लग मोर पराथना हइ हबै, कि उनखर मुकति होय। ");
INSERT INTO bhu_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","उनखर बारे हे मै हइ गवाही देथो, कि उनखर हे भगवान के परति खुसी तो हबै, पय उनखर हइ खुसी पूरब ग्यान के जसना नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","भगवान के नियाइपन के बारे हे अग्यानता अउ अपन नियाइपन के स्थापना करै के खुसी हे उन खुद के भगवान के नियाइपन के वस नेहको करिन। ");
INSERT INTO bhu_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","काखे मसीह के नियम के परिपूरता तक पहुंचाथै, अउ सगलू बिस्वास करै बालेन के नियाइपन परदान करथै। ");
INSERT INTO bhu_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","मूसा कर नियम हे आधारित नियाइपन के बारे हे लिखथै, जउन मनसे हइ बात के मानी, उके इनखर दवारा जीवन मिलही। ");
INSERT INTO bhu_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","पय जउन बिस्वास के दवारा नियाइपन हबै ओखर निता असना लिखे हबै, कि तुम अपन हिरदय हे असना बिचार झइ करा कि स्वरग हे उप्पर कोहर चढी मतलब मसीह के तरी लामै के निता। ");
INSERT INTO bhu_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","अधलोक हे कोहर जही? या मसीह के मरे हर मसे उप्पर लामै के निता। ");
INSERT INTO bhu_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","पय पवितर किताब काहिन कथै? बचन तुम्हर लिघ्घो हबै, ऊ तुम्हर मुंह हे अउ तुम्हर मन हे हबै, हइ बिस्वास के ऊ बचन हबै, जेखर हम परचार करथन। ");
INSERT INTO bhu_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","काखे अगर तुम मुंह लग सुइकार करथा कि यीसु परभु हबै, अउ मन लग बिस्वास करथा कि भगवान उके मरे हर मसे जिन्दा करिस, ता तुमही मुकति मिलही। ");
INSERT INTO bhu_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","काखे नियाइपन के निता मन लग बिस्वास करै लग धरमी मनसे ठहरथै, अउ मुंह लग सुइकार करै लग उके मुकति मिलही। ");
INSERT INTO bhu_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","काखे पवितर किताब हइ कथै, जउन कउ ओखर हे बिस्वास करही ऊ बेज्जती नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","अब यहूदी अउ यूनानी गैर यहूदिन हे छुवाछूत नेहको हबै, इहैनिता ऊ सबके परभु हबै, अउ सब नाम लेय बालेन के निता गहिरा दिल हबै। ");
INSERT INTO bhu_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","काखे जउन कउ परभु यीसु के नाम लेही, उहै मुकति पाही। ");
INSERT INTO bhu_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","जेखर हे तुम्हर बिस्वास नेहको हबै, ता उन ओखर नाम कसके ले? अउ जेखर बारे हे नेहको सुने हबै, ता ओखर हे कसके बिस्वास करै? अउ परचार करै बाले के बिगर उन कसके सुनै। ");
INSERT INTO bhu_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","अउ अगर ऊ पठोय नेहको जाय, ता कउनो परचारक कसके बन सकथै? पवितर किताब हे लिखररे हबै, कल्यान के संदेस सुनामै बाले के गोड केतका सुन्दर लगथै, जउन निक्खा बातन के संदेस सुनाथै। ");
INSERT INTO bhu_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","पय सब ऊ निक्खा संदेस हे कान नेहको लगाइन नबी यसायाह कथै, हे परभु कोहर हमर निक्खा संदेस हे बिस्वास करे हबै। ");
INSERT INTO bhu_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","इहैमेर हम देखथन कि संदेस सुनै लग बिस्वास पइदा होथै, अउ जउन सुनाय जथै, ऊ मसीह के बचन हबै। ");
INSERT INTO bhu_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","पय मै कथो, कि जउन नेहको सुनिन जरूर सुनै हबै, काखे लिखे हबै उनखर आरो सगलू दुनिया हे अउ उनखर बात, भुंइ के छोर तक पहुंच गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","मै फेर कथो, इस्राएल मनसेन के पता नेहको रथै, पहिले मूसा नबी कथै, मै गैर यहूदी मनसेन लग, तुम्हर हिरदय हे जलन पइदा करिहों, मै हइ मूरुख देस लग, तोके गुस्सा दिलाहूं। ");
INSERT INTO bhu_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","फेर यसायाह हिम्मत करके परभु के हइ कथन सुनाइस, जउन मोके नेहको खोजथै, उन मोके पाइन अउ जउन मोर बारे हे सबाल नेहको पूछथै, उनखर हे मै अपन के परगट करेव। ");
INSERT INTO bhu_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","इस्राएली के बारे हे ऊ कथै, मै सगलू अपन हाथ हे आदेस पालन करै बाले परजा के पल्ला फइलाथै। ");
INSERT INTO bhu_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ता मोर सबाल हइ हबै, का भगवान अपन मनसेन के छांड दय हबै? नेहको बिलकुन नेहको काखे खुदय मै अक्ठी इस्राएली हव, अब्राहम के बिरादरी के हव, अउ बिन्यामीन के कुर के। ");
INSERT INTO bhu_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","भगवान अपन ऊ परजा के, जेही ऊ अपनाइस, नेहको छांडे हबै, का तै नेहको जानथस कि पवितर किताब हे नबी एलिय्याह के बारे हे काहिन कथै? जब ऊ भगवान के आगू इस्राएल हे दोस लगाथै। ");
INSERT INTO bhu_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","परभु उन तोर ग्यानी मनसेन के बध करे हबै, उन तोर बेदिन के नस्ट के डाले हबै, मै अकेल्ले बच गय हव अउ उन मोर परान लेय चाहथै। ");
INSERT INTO bhu_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","एखर हे भगवान के जबाब काहिन रथै? मै सात हजार मनसेन के अपन निता बचाय रखे हबै, जउन बाल देउता के आगू घुटवा नेहको टेकिन। ");
INSERT INTO bhu_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","इहैमेर हइ टेम भगवान के अनुगरह के चुने हर कुछ मनसे बाकी हबै। ");
INSERT INTO bhu_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","अगर हइ ओखर अनुगरह दवारा हुइस, ता मनसेन के कामन के उप्पर नेहको हबै, ता अनुगरह नेहको रह जही। ");
INSERT INTO bhu_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ता एखर परिनाम काहिन निकरिस? इस्राएली जउन बात खोज हे रथै अउ उन नेहको पाय सकिन, पय चुने हर मनसे उके पाय लइन अउ दूसर मनसे सुनै नेहको चाहथै। ");
INSERT INTO bhu_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","जसना कि पवितर किताब हे लिखे हबै, भगवान पवितर आतमा के दवारा उनखर दिमाक के जर बनाय दय हबै, ऊ उनही असना आंखी दइ दइस, जउन नेहको दिखथै अउ असना कान जउन सुनथै नेहको अउ उनखर हइ दसा आज तक बने हर हबै। ");
INSERT INTO bhu_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","अउ दाऊद कथै, उनखर भोजन उनखर निता फान्दा अउ जाला बनै, ऊ उनखर निता पतन अउ सजा के कारन होय। ");
INSERT INTO bhu_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","उनखर आंखी धुंधरी पड जाय, जेखर लग उन देख नेहको सकै, अउ उनखर कमर स्थाई रूप लग झुक जाय। ");
INSERT INTO bhu_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","पय मै पूछथो का उनही असना ठोकड लगिस कि उन कबहुन झइ उठ पामै? नेहको बिलकुन नेहको यहूदिन के गिरै के दवारा उनखर अपराध के कारन गैर यहूदी के मुकति मिले हबै, कि यहूदिन हे जलनभाव पइदा हुइ जाय। ");
INSERT INTO bhu_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","जब यहूदिन के अपराध अगर उनखर गिरना दुनिया के निता डेरा अउ उनही कमी गैर यहूदी के निता डेरा के कारन होथै, ता उनही भरपूरी लग का कुछ नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","मै गैर यहूदिन लग हइ कथो, मै तो गैर यहूदिन हे परचार करै पठोय गयों अउ मै गैर यहूदी के निता चेला हबो, ता मै अपन सेबा के बडाई करथो। ");
INSERT INTO bhu_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","कि मै कउनो मेर लग अपन बिरादरिन हे जलन पइदा के सको अउ एखर दवारा उनखर मसे कुछ मनसेन के मुकति हुइ सकै। ");
INSERT INTO bhu_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","काखे अगर उनखर परितयाग के इहैनिता भगवान के संग दुनिया के मेल हुइ गय हबै, ता उनखर सुइकार के परिनाम का होही? मरे हर के निता जीवन। ");
INSERT INTO bhu_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","अगर बलि के पहिले पेडा पवितर हबै, ता सगलू गुडरेहर पिसान पवितर हबै, अगर जर पवितर हबै ता डगइल पवितर हबै। ");
INSERT INTO bhu_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","पय अगर कुछ डगइल टोरे गइस अउ तुम जउन अक्ठी जंगली जैतून हबा, उनखर हे लगाय गय हबा अउ उनखर संग जैतून रूख के जर के अंग होय के कारन अच्छी किसम के सहभागी बन गय हबा। ");
INSERT INTO bhu_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ता तुम अपन के डगइल लग बढके झइ समझा, अगर तुम गरभ करै चाहथा, ता सुरता रखा कि तुम जर के नेहको संभारे बलुक जर तुमही संभारथै। ");
INSERT INTO bhu_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","तुम कइहा डगइल इहैनिता काटके अलगे के दय गइस, कि मोके कलम लगाय जाय। ");
INSERT INTO bhu_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ठीक हबै उन अबिस्वास के कारन काट के अगले के दय गइस अउ तुम बिस्वास के बल हे अपन जिघा हे बने हबै अउ घमंड झइ करा पय सचेत रहा। ");
INSERT INTO bhu_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","अगर भगवान मूल डगइल हे दया नेहको करिस, ता ऊ तुम्हर हे दया नेहको करी। ");
INSERT INTO bhu_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","भगवान के दया अउ कठोरता हे बिचार करा गिरे हर मनसेन के निता कठोरता अउ भगवान तुम्हर निता किरपा अगर तुम सहीमा उनखर किरपा के खेरवा हे बने रथा, नहि ता तुमही काट के अलगे के दय जही। ");
INSERT INTO bhu_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","दूसर पल्ला अगर अबिस्वासी झइ रइहिन ता उहो कलम के जसना लगाय जही, काखे भगवान उनही फेर लगामै के सक्ति रखथै। ");
INSERT INTO bhu_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","अगर तुम अपन गुन लग जंगली जैतून के डगइल होय, उके खपल के अपन सोभाव के बिरोध हे जैतून कलम लगाय गय हबा, ता कहुं बोहत सरल लग अपन आचरन के दवारा अपन जसना कलम लगाय जाय सकथै। ");
INSERT INTO bhu_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","हे मोर भाइयो हइ बात लुकेहर बात सही हबै तुमही कथो, हइ बात मनसेन के चलाही, कि तुम केतका दिमाक बाले हबा, इस्राएली मनसेन के हइ हरमेसा के ढीठ नेहको हबै, फेर हइ तब तक चली जब तक पूर गैर यहूदी भगवान के लिघ्घो नेहको आय जही। ");
INSERT INTO bhu_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","अउ हइमेर सगलू इस्राएली के बचाही जसना लिखररे हबै, बचामै बाले आही अउ सियोन लग आही, अउ ऊ याकूब के नास्तिकता के दुरिहां करी। ");
INSERT INTO bhu_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","जब मै उनखर पाप हर लइ जहुं, तब उनखर लग मोर हइ टीमा होही। ");
INSERT INTO bhu_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","संदेस के नजर लग उन गैर यहूदी के कारन भगवान के बैरी हबै, पय चुने जाय के कारन लग उन सियानन के भगवान के किरपा के काबिल हबै। ");
INSERT INTO bhu_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","काखे भगवान के बरदान अउ बुलउवा अटल हबै। ");
INSERT INTO bhu_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","जसना तुम परचीन काल लग भगवान के आदेस नेहको माने हबा, ओसनेन यहूदी आदेस नेहको माने हबै, पय अब तुम्हर हे भगवान के किरपा होय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ओसनेन उनो अब आदेस नेहको मानिन, कि तुम हे जउन दया होथै, ऐखर लग उनखरो उप्पर दया होय। ");
INSERT INTO bhu_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","काखे भगवान सब के आदेस नेहको मानै के निता बन्दी बनाय के रखे हबै, उन सगलू हे दया करै। ");
INSERT INTO bhu_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","भगवान के डेरा अउ दिमाक अउ सिक्छा बोहत गंभीर हबै, ओखर सोच केतका गहिड कुन्ड हबै अउ ओखर रास्ता के कउनो नेहको जान सकथै। ");
INSERT INTO bhu_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","परभु के दिमाक के कोहर जानही? या सलाह देय बाले कोहर होही? ");
INSERT INTO bhu_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","या कोहर आगू उके कुछु दय हबै, जेखर पलटा कुछु दय जाय। ");
INSERT INTO bhu_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","काखे ओखरै पल्ला लग अउ ओखरै दवारा अउ ओखरै निता सब कुछ हबै, ओखर महिमा जुगजुग होत रहै, ओसनेन होय। ");
INSERT INTO bhu_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","हे भाई अउ बेहन, भगवान के बडी दया के उजियार हे तुम सबले मोर बिनती हबै, कि तुम अपन देह के भगवान के निता मगन करै बाले सुध्द बलि चढावा, इहै तुम्हर सच्ची सेबा हबै। ");
INSERT INTO bhu_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","तुम हइ दुनिया के जसना आचरन झइ करा, बलुक सगलू कुछ नबा नजर लग देखै अउ अपन आदत बदल ले, हइमेर तुम जान जाबे, कि भगवान के चाहथै अउ ओखर निक्खा सुइकार ओग, समझदार अउ सबले बढिहा हबै। ");
INSERT INTO bhu_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","अउ मोके दय गइस बडी अनुगरह के दवारा मै तुम्हर मसे सगलू के बिनती करत कथो, कि कउनो खुद के बोहत झइ समझै, पय खुदय के बारे हे तुम्हर गिनती भगवान दवारा दय गइस बिस्वास के परिनाम जसना होय। ");
INSERT INTO bhu_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","जउन मेर हमर अक्ठी देह हे कइठे अंग होथै अउ सगलू अंगन के काम अक जसना नेहको होथै। ");
INSERT INTO bhu_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","उहैमेर हम जउन अनेक हबन मसीह हे अक्ठी देह अउ अक दूसर के अंग हबन। ");
INSERT INTO bhu_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","हमही मिलेहर अनुगरह के जसना हमर बरदान अलगे-अलगे हबै, हमके आगू कर बात गुठेमै बाले के बरदान मिले हबै, ता बिस्वास के जसना ओखर इस्तेमाल करै। ");
INSERT INTO bhu_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","अगर सेबा करै के बरदान मिले हबै, ता हमके सेबा करै के चाही, अगर हमके सिक्छा देय के बरदान होय ता हमके सिखामै चाही। ");
INSERT INTO bhu_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","अगर अक दूसर के खुसी करै के बरदान हबै, ता खुसी करा अउ अगर अक दूसर के देय के बरदान हबै, ता उदारता लग देया अउ जेही अगुवाई करै के बरदान मिले हबै, ता मगन लग अगुवाई करतै रहा अउ जेही दया के बरदान मिले हबै, उके दया करै चाही। ");
INSERT INTO bhu_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","तुम्हर माया निस्कपट होय, तुम बुराई लग घिरना करा अउ अच्छाई हे लगे रहा। ");
INSERT INTO bhu_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","भाई-भाई हे जसना माया होथै, ओसनेन अक दूसर लग माया रखा, अपनै हे अक दूसर के इज्जत करा अउ अक दूसर लग बढ चढके करा। ");
INSERT INTO bhu_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","परयास करै हे आलसी झइ करा, पवितर आतमा लग खुसी हे भरे रहा, परभु के सेबा करतै रहा। ");
INSERT INTO bhu_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","आसा हे खुसी, दुख हे धीर अउ बिनती हे नियम बनाय रखा। ");
INSERT INTO bhu_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","पवितर मनसेन के जरूरत के निता दान दय करा अउ पहुनन के सेबा करा। ");
INSERT INTO bhu_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","अपन सतामै बालेन के निता तुम्हर मुंह ले आसिरबाद निकरे, हव आसिरबाद न कि सराप। ");
INSERT INTO bhu_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","खुसी बनामै बालेन के संग खुसी बनाबा अउ रोमै बालेन के संग रोबा। ");
INSERT INTO bhu_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","अपनै हे मेलजोल के भाव बनाय रखा, अहंकारी झइ बना, बलुक दीन दुखियन लग मिलत जुलत रहा, अपन खुद के होसियार झइ समझा। ");
INSERT INTO bhu_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","बुराई के बदला बुराई झइ करा, सत्य हे जउन बढिहा हबै, ओसनेन करै के बिचार करा। ");
INSERT INTO bhu_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","जिहां तक हुइ सकै, अपन पल्ला लग सगलू के संग सान्ति बनाय रखा। ");
INSERT INTO bhu_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","हे पिरिया भाई तुम खुदय के नियाव झइ करा, पय उके भगवान के क्रोध हे छांड देया, काखे पवितर किताब हे लिखररे हबै, परभु कथै, पलटा लेय के मोर काम हबै, मै पलटा लेहूं। ");
INSERT INTO bhu_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","अगर तुम्हर बैरी भूखे हबै, ता उके खाना खबाबा, अगर ऊ पियासे हबै, ता उके पानी पियाबा, काखे असना करै लग ऊ तोर माया मेर बेउहार लग अंगरा के ढेर लगाही। ");
INSERT INTO bhu_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","बुराई लग हार झइ माना, बलुक अच्छाई के दवारा बुराई के जीत लेया। ");
INSERT INTO bhu_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","हर अक्ठी मनसे सरकारी साहबन के अधीन रहै, काखे भगवान के इजाजत लग हक दय जथै, बरतमान साहब के नियम भगवान के पल्ला लग हबै। ");
INSERT INTO bhu_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","इहैनिता जउन असना साहब के बिरोध करथै, ऊ भगवान कर नियम के बिरोध करथै अउ बिरोध करै बाले सजा पाही। ");
INSERT INTO bhu_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","सरदार निक्खा काम करै बालेन हे नेहको, बलुक बेकार काम करै बालेन हे डर पइदा करथै, का तुम साहबन के डेर लग आजाद रहै चाहथा? ता उहै काम करा जउन सही हबै अउ उन तुम्हर परसंसा करही। ");
INSERT INTO bhu_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","काखे उन तुम्हर अच्छाई के निता भगवान के हरवाह हबै पय अगर तुम बेकार काम करथा, ता उनखर लग डर, काखे ओखर हाथ हे तलबार बेकार नेहको हबै, ऊ भगवान के चुने हर सेबक हबै, ओखर क्रोध के साधन हुइके कुकरमिन के सजा देथै। ");
INSERT INTO bhu_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","इहैनिता न सिबाय क्रोध लग बचै के निता बलुक अन्तरातमा के कारन तुमही साहबन के अधीन रहै चाही। ");
INSERT INTO bhu_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","तुम इहैनिता राज बेयाज चुकथा, साहब भगवान के जनसेबक हबै अउ उन अपन सेबा हे लगे रथै। ");
INSERT INTO bhu_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","जेही जउन कुछु देय जाय के निरधारित हबै, उके ऊ देया, जेही पइसा देय के हबै, उके पइसा देया, जेही पइसा उके पइसा देया, जेखर लग डरै का चाही, ओखर लग डर अउ जेखर इज्जत जरूरी हबै, ओखर इज्जत करा। ");
INSERT INTO bhu_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","अक दूसर लग माया करैका छांडके दूसर कउनो बातन के करजदार नेहको होय चाही, काखे जउन दूसर के माया करथै, ऊ मूसा कर नियम के मान लय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","काखे गलत काम झइ करा, हत्या झइ करा, चोरी झइ करा, लालच झइ करा अउ एखर अलाबा अगर कउ दूसर आदेस होय ता ओखर मतलब इहै हबै, अपन परोसी के निता तुम्हर माया ओसनेन होय जसना तुम्हर खुदय के निता हबै। ");
INSERT INTO bhu_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","माया परोसी के संग बुरा नेहको करथै, इहैनिता जउन माया करथै, ऊ नियम के पूर करथै। ");
INSERT INTO bhu_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","जरूरी हबै कि तुम टेम के चीन्हिस तुम्हर नींद लग जाग जाय के टेम आय चुके हबै, ऊ टेम के बराबरी हे, जब हम हइ बिस्वास के अपनाय रथन, हमर मुकति के परति लिघ्घो हबै। ");
INSERT INTO bhu_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","रात बोहत गुजर गय हबै अउ बेरा निकरै बाले हबै, इहैनिता हम अंधियार के कामन के छांडके उजेड के हथियार धारन के लइ। ");
INSERT INTO bhu_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","हमर स्वभाव टेम के जसना, दिन के ओग होय, हम रंगरेलियों अउ दरुहा अउ बेभिचार अउ भोगबिलास, झगडा अउ जलन लग दुरिहां रहै। ");
INSERT INTO bhu_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","तुम परभु यीसु मसीह के धारन करा अउ देह के बेकार इक्छा पूर करै के परयास झइ करा। ");
INSERT INTO bhu_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","जउन बिस्वास हे कमजोर हबै, ओही अपन संगति हे रखला, पय संका हे ओखर नियाव करै के छमता हे झगडा झइ करा। ");
INSERT INTO bhu_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","अक्ठी मनसे के पूर बिस्वास हबै, कि सब कुछ खाय के सही हबै, पय जउन बिस्वास हे ढिलवा हबै, ऊ सबजी भाजी खथै। ");
INSERT INTO bhu_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","नेहको खाय बाले खाय बालेन के दोस झइ लगामै अउ नेहको खाय बाले खाय बालेन हे कमी झइ खोजै काखे भगवान उके अपनाय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","तुम कोहर हबा, जउन भगवान के हरवाह जन के दोसी ठहराबा? असना मनसे अपन परभु के आगू जिम्मेदारी हबै, इहैनिता भगवान बाफ उके ठाड रखै हे सक्तिसाली हबै। ");
INSERT INTO bhu_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","अक्ठी मनसे सोचथै, कि अक रोज दूसर रोज लग निक्खा हबै, दूसर मनसे सोचथै, कि हर रोज अक जसना हबै, एखर बारे हे हर मनसे अपन मन हे पूर बिस्वास करथै। ");
INSERT INTO bhu_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","जउन कउनो रोज के मानथै, ऊ परभु के निता मानथै, जउन खथै, ऊ परभु के निता खथै, काखे ऊ भगवान के धन्यबाद करथै, अउ जउन नेहको खथै, ऊ परभु के निता नेहको खथै, अउ भगवान के धन्यबाद करथै। ");
INSERT INTO bhu_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","काखे हमर मसे कउनो अपन निता नेहको जीथै, अउ न कउ अपन निता मारथै। ");
INSERT INTO bhu_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","अगर हम जिन्दा हबन, ता परभु के निता जिन्दा हबन, अउ अगर मरथन ता परभु के निता मरथन, पय हम जिन्दा रही या मरी, हम परभु के हबन। ");
INSERT INTO bhu_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","काखे मसीह इहैनिता मरिस अउ जिन्दा हुइ गइस, कि ऊ मरे हर मसे अउ जिन्दन के, दोनोन के परभु हबै। ");
INSERT INTO bhu_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","तै अपन भाई हे काखे दोस लगाथा? या तै फेर काखे अपन भाई के बेकार समझथा? हम सबके सब भगवान के नियाव के रोज सिहासन के आगू ठाड हुइबे। ");
INSERT INTO bhu_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","काखे लिखवरे हबै, परभु कथै, जसना मै जिन्दा हव अउ कथो, कि सबझन के घुटवा मोर आगू हे झुकही, अउ सब जीभ भगवान के सुइकार करी। ");
INSERT INTO bhu_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","इहैनिता हमर मसे सबझन भगवान के अपन-अपन हिसाब-किताब दइहीं। ");
INSERT INTO bhu_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","इहैनिता हम अक दूसर के दोस लगामै के छांडके अपनै हे निहचित के लेय कि कउनो अपन भाई के गली हे ठोकड के कारन पइदा झइ करै अउ न जाल बिछामै। ");
INSERT INTO bhu_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","मै जानथो अउ परभु यीसु हे मोके बिस्वास हुइस, कि कोनो चीज अपने अपन हे बेकार नेहको होथै, पय जउन उके बेकार समझथै, ओखर निता बेकार हबै। ");
INSERT INTO bhu_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","अगर तोर भाई तोर भात के निता गुसाथै, ता फेर तै माया के जसना नेहको रेंगथै, जेखर निता यीसु मसीह मरिस, कि तै अपन भात के दवारा नास झइ के। ");
INSERT INTO bhu_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","तुम्हर आगू जउन निक्खा हबै, ओखर बारे हे बुराई झइ करा। ");
INSERT INTO bhu_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","काखे भगवान कर राज खाय-पिये के नेहको, पय धरमी अउ मेलजोल अउ खुसी हबै, पवितर आतमा लग होथै। ");
INSERT INTO bhu_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","काखे जउन मसीह के सेबा करथै, ऊ भगवान के मगन करथै अउ मनसेन के बिस्वास करै बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","हम असना बातन हे लगे रही जेखर लग सान्ति के बढाबा मिलथै, अउ जेखर दवारा अक दूसर के उन्नत के सकथन। ");
INSERT INTO bhu_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","भात के निता भगवान के काम झइ बिगडै, सब कुछ सुध्द तो हबै, पय ऊ मनसे के निता बेकार हबै, जेही ओखर भात लग ठोकड लगथै। ");
INSERT INTO bhu_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","निक्खा तो हइ हबै, कि तै झइ गोस खा, अउ झइ दारू पिया अउ न असना कुछ करा जेखर लग तोर भाई के ठोकड लगै। ");
INSERT INTO bhu_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","तोर जउन बिस्वास हबै, उके भगवान के आगू अपन मन हे धर, धन्य हबै ऊ जउन ऊ बात हे जेही ऊ निक्खा समझथै, अपन खुद के दोसी नेहको ठहराथै। ");
INSERT INTO bhu_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","पय जउन संकोच करै के खथै, ऊ सजा के भागी ठहर चुके हबै, काखे ऊ बिस्वास लग नेहको खथै अउ जउन कुछ बिस्वास लग नेहको होथै, ऊ पाप हबै। ");
INSERT INTO bhu_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","इहैनिता हम सक्तिसाली हबै करके, हमही ढिलवा मनसे के कमजोरी हे मदत करै चाही अउ खुद के मगन नेहको करै चाही। ");
INSERT INTO bhu_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","हमर मसे सबझन अपन परोसी के ओखर भलाई के निता, मगन करा कि ओखर उन्नत होय। ");
INSERT INTO bhu_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","काखे मसीह अपन खुद के मगन नेहको करिस, पय जसना लिखवरे हबै, तोर बुराई करै बाले के, बुराई मोर हे आ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","जेतका बात आगू लग लिखवरे गय हबै, ऊ हमरेन सिक्छा के निता लिखवरे हबै, कि हम धीर अउ भगवान कर बचन के उकसामै के दवारा आसा रखा। ");
INSERT INTO bhu_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","धीर अउ सान्ति के दाता भगवान तुमही हइ बरदान दे, कि मसीह यीसु के जसना सक दूसर लग अक्ठिन मन रहा। ");
INSERT INTO bhu_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ताकि तुम अक्ठी मन अउ अक्ठी आरो हे, परभु यीसु मसीह के बाफ भगवान कर महिमा करा। ");
INSERT INTO bhu_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","इहैनिता जसना मसीह भगवान कर महिमा के निता तुमही सुइकार करे हबै, ओसनेन तुम अक दूसर के सुइकार करा। ");
INSERT INTO bhu_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","इहैनिता मै कथो कि मसीह जउन बादा बाफ दादा के दय गय रहिस, भगवान के सच्चाई के परमाड देय के निता, उनही मजबूत करै के निता, खतना करे हर मनसेन के सेबक मानथै। ");
INSERT INTO bhu_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","अउ इहैनिता कि गैर यहूदिन के दया मिले, भगवान के भजन करै, जसना लिखवरे हबै, इहैनिता मै गैर यहूदी हे धन्यबाद करहुं, अउ तोर नाम के महिमा के भजन गाहुं। ");
INSERT INTO bhu_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","फेर कथै, हे गैर यहूदी के सफ्फा मनसे, ओखर चेलन के संग मगन होबा, ");
INSERT INTO bhu_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","अउ फेर, हे गैर यहूदी के सब मनसे परभु के भजन करा, अउ हे देस-देस के सगलू मनसे ओखर बडाई करा। ");
INSERT INTO bhu_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","अउ फेर यसायाह कथै, इसै फेर अक्ठी जर परगट होही, अउ गैर यहूदी आसा रखही। ");
INSERT INTO bhu_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","भगवान जउन आसा के दाता हबै, तुमही बिस्वास करै हे सबैमेर के मगन, अउ सान्ति लग भरपूर करा, कि पवितर आतमा के सक्ति लग तुम्हर आसा बढत जाय। ");
INSERT INTO bhu_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","हे मोर भाइयो जिहां तक तुम्हर बारे हे बिना संकोच हव अउ बिस्वास हे तुम खुदय निक्खा अउ सगलू ग्यान लग पूर हबा अउ पूर समझ के संग अक दूसर के चेतन्त दइ सका। ");
INSERT INTO bhu_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","तउभरमा मै कहुं-कहुं सुरता करवामै के निता, तुमही जउन बोहत हिम्मत करके लिखो, हइ ऊ दया के कारन हुइस, जउन भगवान मोके दय हबै। ");
INSERT INTO bhu_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","कि मै गैर यहूदी के निता मसीह यीसु के हरवाह हुइके, भगवान के संदेस के सेबा याजक के जसना करव, जेखर लग गैर यहूदी के बलि चढामै, पवितर आतमा लग सुध्द बनके सुइकार करे जाय। ");
INSERT INTO bhu_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","इहैनिता उन बातन के बारे हे, जउन भगवान लग मतलब रखथै, मै मसीह यीसु हे बडाई के सकथों। ");
INSERT INTO bhu_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","काखे उन बातन के छांड मोके अउ कोनो बात के बारे हे, कहे के हिम्मत नेहको, जउन मसीह गैर यहूदी के वस हे होय के निता, बचन अउ करम, ");
INSERT INTO bhu_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","अउ चिन्हा अउ अदभुत कामन के सक्ति लग अउ भगवान के पवितर आतमा के सक्ति लग मोरेन दवारा करिस, इहां तक कि मै यरुसलेम लग लइके, चारो चउगिरदा इल्लुरिकुस तक मसीह के संदेस के पूर-पूर परचार करव। ");
INSERT INTO bhu_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","पय मोर मन के मगन हइ हबै, कि जछो-जछो मसीह के नाम नेहको लेथै, उहै संदेस सुनाहूं असना झइ होय कि दूसर के नीह हे घर बनाव। ");
INSERT INTO bhu_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","पय जसना लिखवरे हबै, ओसनेन होय, जिनखर लिघ्घो संदेस नेहको पहुंचे हबै उहै देखही, अउ जउन नेहको सुनै हबै, उहै समझही। ");
INSERT INTO bhu_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","इहैनिता मोके तुम्हर लिघ्घो आमै लग बेर-बेर रोकथै। ");
INSERT INTO bhu_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","पय अब इन देसन हे मोर काम करै के निता अउ जिघा नेहको रथै अउ मै बोहत सालन लग तुम्हर लिघ्घो आमै के सोचत रहों। ");
INSERT INTO bhu_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","इहैनिता जब मै स्पेन छो जहुं, ता तुम्हर लिघ्घो होत जहुं, काखे मोके आसा हबै कि ऊ यातरा हे तुम्हर लग मुलाखात होही अउ जब तुम्हर संग उठा-बइठक लग मोर मन कुछ भर जही, ता तुम मोके कुछ दुरिहां तक पठोय दइहा। ");
INSERT INTO bhu_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","पय अबे तो मै पवितर मनसेन के सेबा, करै के निता यरुसलेम छो जथो। ");
INSERT INTO bhu_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","काखे मकिदुनिया अउ अखाया के मनसेन के हइ, निक्खा लगिस कि सहभागी के कमरा हे यरुसलेम के पवितर मनसेन हे, गरीबन के निता कुछ चन्दा करी। ");
INSERT INTO bhu_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","उनही तो निक्खा लगिस, पय उन उनखर करजदार हबै, काखे अगर गैर यहूदी उनखर आतमिक बातन हे साझा होय, ता उनोन के निक्खा हबै, कि देहन बातन हे उनखर सेबा करी। ");
INSERT INTO bhu_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","इहैनिता मै हइ काम पूर करके अउ उनखर हइ चन्दा सउप के तुम्हर लिघ्घो होवत ओसनेन स्पेन के जइहों। ");
INSERT INTO bhu_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","अउ मै जानथो के जब मै तुम्हर लिघ्घो अइहों, ता मसीह के पूर आसीस के संग अइहों। ");
INSERT INTO bhu_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","हे भाइयो, हमर परभु यीसु मसीह के अउ पवितर आतमा के माया के धियान दिलाय के मै तुमही उकसामै के निता भगवान लग बिनती करथो कि मोर संग मिलके लवलीन रइहों। ");
INSERT INTO bhu_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","मै यहूदिया के अबिस्वासी लग बचे रइहों अउ मोर ऊ सेबा जउन यरुसलेम के निता हबै, पवितर मनसे के भाही, ");
INSERT INTO bhu_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","अउ मै भगवान के इक्छा लग तुम्हर निता खुसी के संग आयके तुम्हर संग अराम पाहूं। ");
INSERT INTO bhu_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","सान्ति के भगवान तुम सगलू के संग रहै। ओसनेन होय। ");
INSERT INTO bhu_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","मै किंख्रिया सहर के मंडली के सेबिका हमर बेहन फीबे के निता तुम्हर लग बिनती करथो, ");
INSERT INTO bhu_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","तुम परभु हे ओखर हरवाह के सोगत करा अउ ओही कउनो चीज के जरूरत होही, ता हर मेर लग ओखर सहयोग करा, काखे ऊ बोहत झन के अउ मोरो बडा सहयोग करे हबै। ");
INSERT INTO bhu_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","यीसु मसीह हे अपन दोनो सहकर्मी प्रिस्का अउ अक्विला के नमस्ते, ");
INSERT INTO bhu_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","जउन मोर परान बचामै के निता अपन हे जीवन दुख हे डार दय रथै अउ केबल मै नेहको पय गैर यहूदी के सगलू मंडली उनखर धन्यबाद करथै। ");
INSERT INTO bhu_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","उनखर घर हे अक जिघा होमै बाले मंडली के नमस्ते। मोर पिरिया दोस इपैनितुस के जउन मसीह के निता आसिया परदेस के पहिले फडुहा हबै, नमस्ते ");
INSERT INTO bhu_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","अउ मरियम के नमस्ते, जउन तुम्हर निता बोहत मेहनत करिस, ");
INSERT INTO bhu_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","मोर सहकर्मी अउ मोर संग जेल हे बन्द होय रहिन अन्द्रुनीकुस अउ बेहन यूनियास के नमस्ते। जउन चेलन हे सम्मानित हबै अउ मोर लग पहिले मसीह के चेला बनिन। ");
INSERT INTO bhu_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","अम्पलियातुस के जउन परभु हे मोर पिरिया हबै, नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","उरबानुस के जउन मसीह हे हमर सहकर्मी हबै अउ मोर पिरिया इस्तखुस के नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","जउन मसीह हे अपिल्लेस के अउ अरिस्तुबुलुस के परवार के नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","मोर परवार हेरोदियन के अउ नरकिस्सुस के परवार के जउन परभु हे हबै नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","तरुफोना अउ तरूफोसा के जउन परभु हे मेहनत करथै नमस्ते। पिरिया पिरसिस के, जउन परभु हे बोहत मेहनत करिस, नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","रूफुस के जउन परभु हे चुने हर हबै अउ ओखर दाय के जउन मोरो दाय हबै, दोनो झन के नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","असुंक्रितुस, फिलगोन, हिरमेस, पतरुबास, हर्मास अउ उनखर संग के भाई के नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","फिलुलुगुस, यूलिया, नेर्युस अउ ओखर बेहन अउ उलुम्पास अउ उनखर संग के सगलू पवितर मनसेन के नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","अपन हे पवितर चुम्मा लग नमस्ते। तुमही मसीह के सगलू मंडली के पल्लन लग नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","हे भाई अउ बेहन मै तुम्हर लग बिनती करथो, कि जउन सिक्छा के बिरोध फूट डालै अउ फसामै के ठोकड बनथै, उनही जांच लय करा अउ उनखर लग दुरिहां रहा। ");
INSERT INTO bhu_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","काखे असना मनसे हमर परभु मसीह के सेबा नेहको करथै, पय अपन पेट के निता सेबा करथै अउ चिकनी चुपडी बातन लग सिधे साधे मन के मनसेन के बहकाय देथै। ");
INSERT INTO bhu_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","तुम्हर नियम मानै के चरचा सगलू मनसे हे बगर गय हबै, इहैनिता मै तुम्हर बारे हे खुसी हबो, पय मै हइ चाहथो कि तुम भलाई के निता होसियार अउ बुराइन के निता सीधा बने रइहा। ");
INSERT INTO bhu_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","मुकति के परभु भगवान भुतवा के तुम्हर गोड लग जलदी कुचरवा दइहों। हमर परभु यीसु मसीह के अनुगरह तुम्हर हे होतै रहै। ");
INSERT INTO bhu_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","मोर सहकर्मी तीमुथियुस के अउ मोर बेरादरी लूकियुस अउ यासोन अउ सोसिपतरुस के तुमही नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","मोर पतरी के लिखे बाले तिरतियुस के परभु हे तुम के नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","गयुस जउन मोर अउ मंडली के पहुनाई करै बाले हबै, उनखर तुमही नमस्ते। इरास्तुस जउन गांव के भन्डारी हबै अउ भाई क्वारतुस के नमस्ते। ");
INSERT INTO bhu_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","हमर परभु यीसु मसीह के किरपा तुम सब हे बनी रहै। ");
INSERT INTO bhu_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","अब जउन तुमही मोर संदेस पय यीसु मसीह के संदेस के परचार के जसना ठाड के सकथै, सत्य के उजियार के जसना जउन पाछू अनन्त काल लग लुके रथै। ");
INSERT INTO bhu_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","पय अब परगट होय के पुरखन सनातन भगवान के नियम लग ग्यानी मनसेन के किताब के दवारा सब जातन के गुठेय गय हबै कि उन बिस्वास लग नियम मानैबाले हुइ जइहा, ");
INSERT INTO bhu_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","उहै अक्ठी होसियार भगवान के यीसु मसीह के दवारा सबरोज महिमा होतै रहै। ओसनेन होय।");
INSERT INTO bhu_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","हमर भाई सोस्थिनेस के संग पोलुस के पार लग जेही भगवान अपन इक्छा के जसना यीसु मसीह के चेला बनै के निता चुने के निता बुलाय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","भगवान के ऊ मंडली के नाम जउन कुरिन्थियुस हे हबै, जेही यीसु मसीह हे उनखर नाम, जउन मसीह यीसु हे पवितर करै गइन, जेही भगवान पवितर मनसे बनै के निता उनखर संग चुने हबै। जउन हर जिघा हमर अउ उनखर परभु यीसु मसीह के नाम लेयत रथै। ");
INSERT INTO bhu_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","हमर बाफ भगवान के तरफ लग अउ हमर परभु यीसु मसीह के तरफ लग तुम सबझन के ओखर अनुगरह अउ सान्ति पाउत रहा। ");
INSERT INTO bhu_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","तुमही यीसु मसीह के दवारा भगवान कर अनुगरह पाय हबा। एखर निता मै अपन भगवान के सबदिना धन्यबाद देथो। ");
INSERT INTO bhu_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","मसीह के संदेस तुम्हर बीच हइ मेर के मजबूत हुइ गय हबै कि तुम मसीह हे सगलू बातन, सगलू बचन अउ सगलू ग्यान के सबैमेर के बरदानन लग भरपूर हुइ गय हबा। ");
INSERT INTO bhu_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","मसीह के बारे हे हम जउन मेर संदेस दय हबन ऊ तुम्हर बीच गवाह हबै। ");
INSERT INTO bhu_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","तुम्हर हे कउनो मेर के बरदान के कमी नेहको हबै, अउ तुम हमर परभु यीसु मसीह के परगट होय के निता ओरगथन। ");
INSERT INTO bhu_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","भगवान तुमही आखरी तक बिस्वास हे मजबूत बनाय रखही, जेखर लग तुम हमर परभु यीसु मसीह के रोज तक बेकसूर पइहा। ");
INSERT INTO bhu_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","भगवान बिस्वासओग हबै, उहै तुमही अपन टोरवा हमर परभु यीसु मसीह के संगति हे बुलाय हबै। ");
INSERT INTO bhu_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","हे भाई अउ बेहन, मै तुम्हर लग हमर परभु यीसु मसीह के नाम लग बिनती करथो, कि तुम्हर हे कउनो लडाई झगडा झइ होय, तुम सबझन अक संग मिल के रहा, अक्ठी मन अउ अक्ठी उदेस्य हे रहा। ");
INSERT INTO bhu_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","काखे हे मोर भाइयो खलोय के परवार के मनसेन लग खबर चले हबै कि तुम्हर बीच आपसी हे झगडा हबै। ");
INSERT INTO bhu_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","हे मोर भाई अउ बेहन मोर कहे के मतलब हइ हबै कि तुम्हर मसे कउ कथै, “मै पोलुस के हबो” ता कउनो कथै, “मै अपुल्लोस के हबो” तीसर कथै, “मै कैफा के हबो” अउ कउ कथै, “मै तो मसीह के हबो।” ");
INSERT INTO bhu_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","का मसीह बटर गय हबै? का पोलुस तुम्हर निता क्रूस हे टंगरे रहिस? का तुमही पोलुस के नाम लग पानी हे बतिस्मा पाय हबा? ");
INSERT INTO bhu_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","भगवान के धन्यबाद करथो कि मै क्रिसपुस अउ गयुस के छांड के तुम्हर मसे कउनो के पानी हे बतिस्मा नेहको दयों। ");
INSERT INTO bhu_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","इहैनिता कउ हइ नेहको कहि सकथै कि तुमही पोलुस के नाम हे पानी हे बतिस्मा पाय हबा। ");
INSERT INTO bhu_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","मै स्तिफनास के परवार के पानी हे बतिस्मा दयों, जिहां तक मोके सुरता हबै, मै एखर अलाबा कउनोन के पानी हे बतिस्मा नेहको दय हबो। ");
INSERT INTO bhu_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","काखे मसीह मोके बतिस्मा देय के निता नेहको, पय संदेस सुनामै के निता पठोय हबै, मै हइ काम के निता मनसे के ग्यान लग सगलू भासा के निस्तार नेहको करेव, जेखर लग मसीह के क्रूस के संदेस बेकार ठहरय। ");
INSERT INTO bhu_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","जउन नास होय बाले रास्ता हे चलथै, उन क्रूस के ग्यान के मुरखता समझथै। पय हमर निता जउन मुकति के रास्ता हे चलथै, ऊ भगवान के सक्ति हबै। ");
INSERT INTO bhu_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","काखे मूसा कर किताब हे लिखवरे हबै, “मै ग्यानिन के ग्यान नास करिहों, अउ समझदारन के समझ के बेकार के दइहों।” ");
INSERT INTO bhu_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","हइ दुनिया के ग्यानी मनसे, गुरू अउ मूसा कर किताब के जानकार कछो हबै? का भगवान हइ दुनिया के ग्यानिन के मूरुख नेहको ठहराइस? ");
INSERT INTO bhu_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","भगवान अपन दिमाक के जसना कबहुं हइ नेहको चाहिस कि हइ दुनिया अपन ग्यान के दवारा भगवान के झइ चीन सकै। इहैनिता भगवान संदेस के परचार मूरखन के दवारा बिस्वास करै बाले के मुकति दे। ");
INSERT INTO bhu_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","यहूदी तो चिन्ह मांगथै अउ यूनानी ग्यान चाहथै। ");
INSERT INTO bhu_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","पय हम तो ऊ क्रूस हे टंगाय गय मसीह के परचार करथन, जउन गैर यहूदिन के निता ठोकड के कारन हबै अउ आने यहूदी के निता मुरखता हबै। ");
INSERT INTO bhu_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","पय भगवान के चुने हर मनसे के निता, चाहे उन यहूदी होय या यूनानी, इहै मसीह भगवान के सक्ति अउ भगवान के ग्यान हबै। ");
INSERT INTO bhu_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","काखे भगवान के मुरखता मनसेन के ग्यान लग बोहत ग्यान मान, अउ भगवान के ढिलवा मनसेन के सक्ति लग बोहत सक्तिसाली हबै। ");
INSERT INTO bhu_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","हे भाई अउ बेहन अपन बुलाय जाय के बारे हे सोचा कि दुनिया के नजर हे तुम्हर मसे बोहत कम मनसे ग्यानी, सक्तिसाली अउ होसियार रहिन। ");
INSERT INTO bhu_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ग्यानिन के बेज्जती करै के निता भगवान उन मनसेन के चुने हबै, जउन दुनिया के नजर हे मूरुख हबै। सक्तिसालिन के बेज्जती करै के निता भगवान उन मनसेन के चुने हबै, जउन दुनिया के नजर हे ढिलवा हबै। ");
INSERT INTO bhu_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","भगवान दुनिया के उनही चुनिस जउन नीच हबै, बेकार हबै जिनखर लग घिनाथै, अउ जउन कुछु हइ नेहको हबै। भगवान इनही चुनिस ताकि दुनिया जेही कुछ समझथै, उके ऊ नास के सकै। ");
INSERT INTO bhu_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","जेखर लग कउनो मनसे भगवान कर आगू घमंड झइ करै। ");
INSERT INTO bhu_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","उहै भगवान के बरदान लग तुम यीसु मसीह के अंग बन गय हबै। भगवान मसीह के हमर ग्यान, धरमी काम, पवितर अउ पाप लग मुकति करै बाले बनाय दइस। ");
INSERT INTO bhu_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","जसना कि मूसा कर किताब हे लिखवरे हबै, “अगर कउ के घमंड करैका हबै ता ऊ परभु हे घमंड करै।” ");
INSERT INTO bhu_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","हे भाई, मै तुम्हर इछो न तो बातन के चतुराई के ऊज करै आयों अउ न अच्छी ग्यान देखामै आय हबो, पय मै तुम्हर इछो भगवान के ग्यान के उजागर करै आय हबो। ");
INSERT INTO bhu_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","काखे मै हइ ठान लय रहों कि तुम्हर बीच यीसु मसीह जउन क्रूस हे टंगाय हर मसीह के छांड अउ कउनो बात के बारे हे धियान नेहको दइहों। ");
INSERT INTO bhu_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","सही हे मै तुम्हर बीच दीन हुइके अउ डेरात कांपत तुम्हर लिघ्घो आय रहों। ");
INSERT INTO bhu_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","मोर बचन अउ मोर परचार मनसेन के ग्यान भररे हर बचन के लोभामै बाले नेहको पय पवितर आतमा अउ सक्ति के सबूत रथै, ");
INSERT INTO bhu_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","कि तुम्हर बिस्वास ऊ भगवान के सक्ति हे होय, न कि मनसेन के ग्यान हे। ");
INSERT INTO bhu_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","उन मनसेन के बीच, जउन मजबूत हुइ गय हबै, हमु ग्यान के बात करथन। हइ ग्यान न तो हइ दुनिया के हबै अउ न हइ दुनिया के मुखियन के, हइ सब ग्यान बढोय जाय बाले हबै। ");
INSERT INTO bhu_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","एखर जिघा हे हम तो भगवान के ऊ रहस्यमय ग्यान के देथन जउन लुके हर रथै, अउ जेही सुरुवात लग भगवान हमर महिमा के निता ठहराय रथै। ");
INSERT INTO bhu_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","अउ जेही हइ दुनिया के मुखिया नेहको समझिन, काखे अगर उन उके समझ पातिन ता उन ऊ महिमामय परभु के क्रूस हे नेहको टंगातिन। ");
INSERT INTO bhu_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","हम उन बातन के बारे हे कथन, जेखर बारे हे मूसा कर किताब हे हइ लिखवरे हबै, “भगवान अपन चेलन के निता तइयार करे हबै, ओही कउनो कबहुं नेहको देखे हबै, अउ न कउनो सुने हबै, अउ न कउ ओखर बारे हे सोचे हबै।” ");
INSERT INTO bhu_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","पय भगवान उन बातन के आतमा के दवारा हमर निता परगट करिस, आतमा सगलू बातन के ढूंड लेथै इहां तक कि भगवान के लुके हर बातन के ढूंड लेथै। ");
INSERT INTO bhu_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","असना कोन हर हबै जउन दूसर मनसे के मन के बात जानले, सिबाय ऊ मनसे के आतमा के जउन ओखर अपन भित्तर हबै, इहैमेर भगवान के बातन के भगवान कर आतमा के छांड के अउ कउ नेहको जान सकथै। ");
INSERT INTO bhu_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","हमही दुनिया के आतमा नेहको, बकि ऊ आतमा मिले हबै, जउन भगवान लग हबै, जेखर लग हम भगवान लग पाय हर बरदान चीन सकि। ");
INSERT INTO bhu_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","हम उनखर निता, जउन आतमिक हबै, आतमिक बातन के उजागर मनसे के ग्यान के बचन के दवारा नेहको पय आतमिक बचन हे करथन। ");
INSERT INTO bhu_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","बिना आतमा के मनसे भगवान कर आतमा के बात के गरहन नेहको करथै, काखे इनही ऊ मूरुख मानथै अउ उके समझै लग बाहिर हबै, काखे आतमा के सहायता लग ऊ सिक्छा के परख पवितर आतमा के दवारा करे जथै। ");
INSERT INTO bhu_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","आतमिक मनसे सगलू बातन के परख करथै, पय कउ ऊ मनसे के परख नेहको के सकथै। ");
INSERT INTO bhu_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","जसना मूसा कर किताब हे कहे हबै, “परभु के मन कोहर जानथै? कउन उके सिखाही?” अउ हमर हे तो मसीह के मन सबले बडा हबै। ");
INSERT INTO bhu_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","हे भाई, मै तुम्हर लग ओसना बात नेहको कर सको जसना आतमिक मनसेन लग करथो, मोके एखर उलटा तुम्हर लग ओसना बात करैके पडिस जसना दुनिया मनसेन लग करे जथै। यानी कि उनखर लग जउन अबे मसीह हे लरका हबै। ");
INSERT INTO bhu_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","मै तुमही दूध पिलायो। मै तुमही ठोस भात इहैनिता नेहको खबायों कि तुम एही नेहको पचाय सकता। ");
INSERT INTO bhu_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","तुम हइ टेम इके नेहको पचाय सकता, काखे तुम अब तक देह के स्वभाव के हबा, तुम्हर मसे जलन अउ झगडा होथै। का हइ बात के सबूत नेहको हबै कि तुम देह के स्वभाव के हबा, अउ दुनिया के मनसेन के रीति हे नेहको चलथै? ");
INSERT INTO bhu_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","जब तुम्हर मसे कउ कथै, “मै पोलुस के हबो” अउ दूसर कथै, “मै अपुल्लोस के हबो” ता का तुम दुनिया के मनसेन मेर बेउहार नेहको करथा? ");
INSERT INTO bhu_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","अच्छा तुमिन गुठेबा अपुल्लोस का हबै? अउ पोलुस का हबै? हम तो केबल ऊ सेबक हबन जेखर दवारा तुम बिस्वास के गरहन करे हबै, हमर मसे हर अकझन उहै काम करे हबै जउन परभु हमही सउपे हबै। ");
INSERT INTO bhu_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","मै पउधा लगायों, अपुल्लोस उके पानी ढोरिस, पय भगवान उके बडा करे हबै। ");
INSERT INTO bhu_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","हइ मेर न तो ऊ जउन बिजहा बोय रहिस तउन बडा आहिस, अउ न ऊ जउन पानी ढोरिस, बकि बडा तो भगवान हबै जउन उके बढाय हबै। ");
INSERT INTO bhu_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ऊ जउन बिजहा बोमै बाले अउ पानी ढोरै बाले दुनोझन अक्ठिन काम करथै, अउ सब अपन-अपन मेहनत के जसना अपन मजदूरी पाही। ");
INSERT INTO bhu_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","हम भगवान के सेबा हे सहकर्मी हबन अउ तुम भगवान कर खेत, तुम भगवान के मन्दिर हबा। ");
INSERT INTO bhu_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","भगवान लग मिले हर अनुगरह के जसना मै घर बनामै के निता अच्छी मिसतिरी के जसना नीह खनिस, कउ दूसर नीह के उप्पर रद्दा रखथै, हरेक झन के चेतन्न रहैका हबै कि ऊ कउन मेर घर बनाथै। ");
INSERT INTO bhu_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","जउन नीह डाले गय हबै, ओही छांड के दूसर कउ नीह नेहको डाल सकथै, अउ ऊ नीह यीसु मसीह हबै। ");
INSERT INTO bhu_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","अगर हइ नीह हे दूसर मनसे अपन-अपन घर बनामै के काम हे सोना, चांदी, बोहत मंहगा बाले पथरा, लकडी, चारा, या भूसा के रद्दा रखै, ");
INSERT INTO bhu_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ता हर अकझन के काम परगट करे जही, नियाव के रोज जउन आगी के संग परगट होही, उके परगट करही अउ ऊ आगी के दवारा हर अकझन के काम के परिक्छा लय जही। ");
INSERT INTO bhu_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","जेखर काम नीह के उप्पर घर बने हर ठाड रही, उहै मजदूरी पाही। ");
INSERT INTO bhu_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","जेखर घर आगी लग लेसर जही, उके मजदूरी नेहको मिलही। तउभरमा ऊ घर बच जही, जसना कउ जलत आगी लग बच जथै। ");
INSERT INTO bhu_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","का तुम नेहको जानथा कि तुम भगवान कर मन्दिर हबा, अउ भगवान के आतमा तुम्हर भित्तर हे रथै? ");
INSERT INTO bhu_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","अगर कउ भगवान कर मन्दिर के नास करही, ता भगवान उके नास करही, काखे भगवान कर मन्दिर पवितर हबै, अउ ऊ मन्दिर तुम हबा। ");
INSERT INTO bhu_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","कउ अपन के धोखा झइ देया, अगर तुम्हर मसे कउ खुद के दुनिया के नजर लग ग्यानी समझत होय, ता ऊ सहीमा ग्यानी बनै के निता अपन के मूरुख बनाय लेय। ");
INSERT INTO bhu_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","काखे हइ दुनिया के ग्यान भगवान कर नजर हे मूरुख हबै। जसना मूसा कर किताब हे लिखवरे हबै, “ऊ ग्यानिन के उनखर होसियारिन हे फसथै” ");
INSERT INTO bhu_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","अउ इहो लिखवरे हबै, “परभु जानथै कि ग्यानिन के सोच बिचार बेकार हबै।” ");
INSERT INTO bhu_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","इहैनिता कउ मनसेन हे घमंड झइ करा, काखे सब कुछु तुम्हर हबै। ");
INSERT INTO bhu_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","चाहे ऊ पोलुस, अपुल्लोस, या कैफा होय, दुनिया होय, जीवन या मरन होय, बरतमान होय या भभिस्य होय, ऊ सब कुछु तुम्हर हबै। ");
INSERT INTO bhu_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","पय तुम मसीह कर हबा अउ मसीह भगवान कर हबै। ");
INSERT INTO bhu_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","हमर बारे हे कउनो मनसेन के हइ मेर सोचै के चाही कि हम मसीह के सेबक हबन। अउ भगवान हमही अउ लुके हर भेद के भन्डारी सउपे हबै। ");
INSERT INTO bhu_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","अउ फेर जिनही हइ लुके हर भेद भन्डारी सउपे हबै, उनखर हे हइ जिम्मेदारी हबै कि उन बिस्वास के काबिल होय। ");
INSERT INTO bhu_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","मोके एखर चुटको चिन्ता नेहको हबै कि तुम मोर नियाव करा या परखा मनसेन के कउ अउ अदालत मोके काबिल समझा, मै खुदय अपन नियाव या परख नेहको करथो। ");
INSERT INTO bhu_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","मै अपन हे कउनो पाप नेहको पाथो, पय एखर मतलब नेहको हबै कि मै निस पाप हबो, काखे मोर परखे बाले परभु हबै। ");
INSERT INTO bhu_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","इहैनिता ठीक टेम आमै लग पहिले मतलब जब तक परभु नेहको आथै, तब तक कउनो बात के नियाव झइ करा, उहै अंधियार हे लुके बातन के उजागर करही, अउ मन के बातन के परगट करही, ऊ टेम भगवान के तरफ लग हर अकझन महिमा पाही। ");
INSERT INTO bhu_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","हे भाई अउ बेहन, मै तुम्हर निता अपन खुद अउ अपुल्लोस के उदाहरन दय हबो कि जेखर लग हमर उदाहरन लग हइ सिक्छा लइ सका कि कउनो मनसे पवितर किताब के बेज्जती झइ करिहा, अउ तुम अकझन के पक्छ लेयत अउ दूसर झन के बिरोध करत गुस्सा हे झइ भर जइहा। ");
INSERT INTO bhu_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","कउन हबै ऊ, जउन तुमही दूसर लग बोहत मानथै, तुम्हर लिघ्घो काहिन हबै, जउन तुमही नेहको दय गय होय? अउ अगर तुमही सब कुछ दान हे पाय हबा, ता तुम असना घमंड काखे करथा? जसना कि तुमही नेहको दय गय होय। ");
INSERT INTO bhu_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","तुम सोचथा कि जउन कउनो चीज के तुमही जरूरत रहिस, अब ऊ सब कुछ तुम्हर लिघ्घो हबै। तुम सोचथा कि अब हम धनी हुइ गय हबा, तुम हमर बिना राजा बन बइठे हबै, केतका निक्खा होतिस कि तुम सही हे राजा हुइता तकि तुम्हर संग हमु राज करतन। ");
INSERT INTO bhu_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","काखे मोर ख्याल लग भगवान हम चेलन के काम के मामला हे उन मनसेन के जसना सबले आखरी हे जिघा दय हबै, जेही मिरतू के सजा दइ चुके हबै। काखे हम सगलू दुनिया के निता स्वरगदूतन अउ मनसेन के आगू तमासा बन गय हबन। ");
INSERT INTO bhu_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","हम मसीह के कारन मूरुख हबन, पय तुम मसीह के समझदार बिस्वासी हबा, हम ढिलवा हबन, अउ तुम बलमान हबा, तुमही इज्जत मिलथै, अउ हमर बेज्जती होथै। ");
INSERT INTO bhu_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","हम हइ टेम भुखे अउ पियासे हबन, फटे पुरान बन्डी पहेनथन, अउ मार खाथन अउ इछो उछो भटकत फिरथन, ");
INSERT INTO bhu_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","अउ अपन हाथ लग मेहनत करत-करत थक जथन, मनसे हमर बेज्जती करथै अउ हम आसीस देथन, उन हमर हे अतियाचार करथै अउ हम सहथन। ");
INSERT INTO bhu_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","हम गारी खाय के आसीस देथन, बिरोध होय लग हम उके सहथन, जब हम बदनाम हुइ जथन, तउभरमा हम बिनती करथन कि जसना हइ दुनिया के मइल अउ सबके निता कूरा कचरा बने हर हबन। ");
INSERT INTO bhu_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","मै तुमही बेज्जती करै के निता हइ बात नेहको लिखथो, पय अपन पिरिया टोरवा जानके तुमके समझाथो। ");
INSERT INTO bhu_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","काखे हुइ सकथै कि मसीह हे तुम्हर सिखामै बाले हजारन हुइहिन, पय तुम्हर बोहत बाफ नेहको हबै। मै संदेस के दवारा यीसु मसीह हे तुमही पइदा करे हबै। ");
INSERT INTO bhu_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","इहैनिता मै तुम्हर लग बिनती करथो कि तुम मोर मेर चाल चला। ");
INSERT INTO bhu_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","इहैनिता मै तीमुथियुस के तुम्हर लिघ्घो पठोय हबो, जउन मोर पिरिया अउ परभु हे बिस्वासओग टोरवा हबै, उहै तुमही मसीह यीसु हे मोर चाल चलन के सुरता कराही, ठीक जसना सिक्छा एखर बारे हे मै हर लिघ्घो, हर अक्ठी मंडली हे संदेस देथो। ");
INSERT INTO bhu_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","पय कुछ मनसे हइ समझ के घमंड लग फूले नेहको समाय, कि मै तुम्हर इछो नेहको अइहों। ");
INSERT INTO bhu_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","अगर परभु के इक्छा होही, ता मै जलदिन तुम्हर लिघ्घो अइहों अउ उनखर बातन लग नेहको, पय उनखर काम के सक्ति लग उन घमंडिन के देखै चाहथो। ");
INSERT INTO bhu_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","काखे भगवान कर राज बातन हे नेहको पय सक्ति हे हबै। ");
INSERT INTO bhu_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","तुम काहिन चाहत हबा? का मै डंडा लइके तुम्हर लिघ्घो आंव, या माया अउ दया के आतमा के संग? ");
INSERT INTO bhu_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","तुम्हर बीच होत हबै गलत काम के खबर चारो चउगिरदा बगर गय हबै, असना गलत काम जउन गैर यहूदी हे नेहको होथै, कउनो तो अपन बाफ के डउकिन के रख लय हबै। ");
INSERT INTO bhu_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","तउभरमा तुम घमंड हे फूले हबा, तुमही दुखी होमै चाही अउ जउन असना काम करे हबै ओखर बिरोध करै के चाही। ");
INSERT INTO bhu_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","मै तो देह के नाते दुरिहां रहों, पय आतमा के नाते तुम्हर बीच हबो, जउन हइ काम करे हबै, मै ओखर नियाव के डारे हबो, मानलेया मै सही हे उछो मउजूद हबो। ");
INSERT INTO bhu_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","जब तुम परभु यीसु मसीह के नाम हे अक जिघा जुडिहा, अउ मसीह यीसु के सक्ति के संग आतमा हे मै तुम्हर बीच हुइहों, ");
INSERT INTO bhu_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","तब ऊ मनसे के परेत के सउप देब, जेखर लग ओखर देह नास होय, पय परभु के रोज ओखर आतमा के मुकति होय। ");
INSERT INTO bhu_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","तुम्हर घमंड करै के बिलकुन अच्छा नेहको हबै, का तुम नेहको जानथा कि चुटु हस खमीर लग सगलू गुडरेहर पीसान खमीर हुइ जथै? ");
INSERT INTO bhu_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","निकार के फटिका हइ खमीर के कि तुम अक्ठी नबा सुध्द गुडरेहर पिसान बन जा, जसना कि तुम अखमीरिन हबा, काखे हमर अखमीरी रोटी के बाद के तेउहार सही हे मसीह के बलि के दवारा पूर होय हबै। ");
INSERT INTO bhu_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","इहैनिता हम न तो पुरान खमीर लग अउ न बुराई अउ भुतवा के खमीर लग, बकि सुध्द अउ सच्चाई के अखमीरी रोटी लग तेउहार मनामै के चाही। ");
INSERT INTO bhu_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","मै तुम्हर लग अपन चिट्ठी हे लिखे रहों, कि बेभिचारनी लग कउनो मतलब झइ रखिहा। ");
INSERT INTO bhu_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","मोर मतलब हइ बिलकुन नेहको हबै कि तुम दुनिया के उन सगलू मनसेन लग, जउन बेकार काम करै बाले, लालची, ठगै बाले या मूरती पूजा लग कउनो मतलब झइ रखा, नहि ता तुमही दुनिया लग बाहिर हुइ जाय के पडही, ");
INSERT INTO bhu_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","बकि मै लिखे हव कि अगर कउनो भाई कहामै बाले कउ मनसे बेभिचारी, लालची, मूरती पूजा, निदरा करै बाले, दरुहा या झूठ बोलय बाले हबै, ता उनखर संग्गत झइ करिहा अउ असना मनसेन के संग भातो झइ खइहा। ");
INSERT INTO bhu_vpl VALUES ("C15_12","076_5_12","1CO","5","12","13","मंडली के बाहिर बाले मनसेन के नियाव करैका मोर काम नेहको हबै, भगवान बाहिर बालेन के नियाव करही, पय बिस्वासिन के नियाव का तुम खुद नेहको के सकथा? जसना मूसा कर किताब हे कहे गय हबै, “अपन बीच लग दुस्ट मनसेन के निकार देया।” ");
INSERT INTO bhu_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","का तुम्हर मसे कउ असना हबै, जउन अपन साथिन के संग लडाई हुइ जाय, अउ भगवान के पवितर मनसेन के लिघ्घो न जाय के पापी मनसेन के अदालत हे जाय के हिम्मत करत होय? ");
INSERT INTO bhu_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","का तुम नेहको जानथा कि भगवान के पवितर मनसे दुनिया के नियाव करही? अउ जब तुम्हर दवारा सगलू दुनिया के नियाव करे जही, ता का अपन हइ नान-नान झगडन के नियाव करै के काबिल नेहको हबा? ");
INSERT INTO bhu_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","का तुम हइ नेहको जानथा कि हम स्वरगदूतन के नियाव करबो? ता ओखर आगू हइ दुनिया के झगडा काहिन हबै? ");
INSERT INTO bhu_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","अगर तुम्हर बीच दुनिया भर के झगडा जीवन हे हबै ता का तुम्हर बीच कउनो असना दिमाक बाले मनसे नेहको हबै, जउन अपन मंडली के संगी बिस्वासिन के झगडा के अपन दिमाक लग नेहको नियाव के सकै? ");
INSERT INTO bhu_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","मै तुमही लजुवामै के निता हइ कथो, का तुम्हर बीच अक्कोठे असना होसियार मनसे नेहको हबै, जउन अपन मसीही भाई के आपसी झगडा के पटाय सकै? ");
INSERT INTO bhu_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","एखर का जरूरत हबै कि भाई अपन भाई हे केस चलाबै? इहां तक कि अबिस्वासिन के अदालत हे जाय। ");
INSERT INTO bhu_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","सहीमा तुम्हर हे बडका दोस तो हइ हबै कि अपनै हे केस अदालत करथा, एखर बदला हे खुद जुरुम काखे नेहको सहि लेया? अपन नुसकान काखे नेहको होय देया? ");
INSERT INTO bhu_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","तुम तो खुदय जुरुम करथा, अउ मसीही भाई के लूटथा। ");
INSERT INTO bhu_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","का तुम हइ नेहको जानत हबा कि जुरुम करै बाले मनसे भगवान कर राज के हकदार नेहको होही? धोखा हे झइ रहा, बेभिचारनी, मूरती पूजा, पराय डउकिन के संग गलत काम, लुचपन, पराय डउकन के संग गलत काम, ");
INSERT INTO bhu_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","चोरटा, लालची, दरुहा, निदरा, धोखाधडी करै बाले भगवान कर राज के हकदार नेहको हुइहिन। ");
INSERT INTO bhu_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","तुम मनसेन मसे कुछ ओसनेन रहिन, पय अब परभु यीसु मसीह के नाम लग अउ हमर भगवान कर आतमा के दवारा तुम धोबररे हबा अउ सुध्द करे गइस अउ धरमी काम करै बाले ठहराय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","तुम्हर मसे कउ हइ कइहीं, “मोके सब कुछ करै के अनुमति हबै।” हव, पय सब कुछ फायदा नेहको, मै कहि सकथों, “मोके सब कुछ करै के अनुमति हबै” पय मै कउनो चीज के गुलामी नेहको बनिहों। ");
INSERT INTO bhu_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","कउ इहो कइहीं, “पय खाना लादा के निता हबै अउ लादा खाना के निता हबै।” हव, पय भगवान दोनो के नास के देही। देह गलत काम के निता नेहको, बलुक परभु के निता हबै, अउ परभु हमर देह के निता हबै। ");
INSERT INTO bhu_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","भगवान जउन मेर परभु यीसु के फेरै जिन्दा करिस, उहै मेर हमुन के अपन सक्ति लग फेर जिन्दा करही। ");
INSERT INTO bhu_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","का तुम हइ नेहको जानथा कि तुम्हर देह मसीह के अंग हबै? ता का मै मसीह के अंग लइके ओही बेसिया के अंग बनाय दो? कबहुन नेहको। ");
INSERT INTO bhu_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","का तुम हइ नेहको जानथा कि जेखर मुलाखात बेसिया लग होथै, ऊ उनखर संग अक्ठिन देह हुइ जथै? काखे मूसा कर किताब कथै, “उन दोनो अक्ठिन देह हुइ जही।” ");
INSERT INTO bhu_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","पय जेखर मुलाखात परभु लग हुइ जथै, ऊ ओखर संग अक्ठी आतमा बन जथै। ");
INSERT INTO bhu_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","गलत काम लग दुरिहां रइहा, जेतका पाप मनसे करथै ऊ देह के बाहिर हबै, पय गलत काम करै बाले अपनेन देह के बिरोध पाप करथै। ");
INSERT INTO bhu_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","का तुम नेहको जानथा कि तुम्हर देह पवितर आतमा के मन्दिर हबै? ऊ तुमही भगवान के तरफ लग मिले हबै, अउ ऊ तुम्हर भित्तर रथै, अउ ऊ आतमा हे तुम्हर कउनो हक नेहको हबै, ");
INSERT INTO bhu_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","काखे तुम यीसु के खून के दवारा खरीद गय हबा, इहैनिता तुम अपन देह लग भगवान कर महिमा करा। ");
INSERT INTO bhu_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","अब उन बातन के बारे हे जउन तुम चिट्ठी हे लिखके पूछे हबा, हइ निक्खा हबै कि कउ डउका कउनो डउकी के झइ छुय। ");
INSERT INTO bhu_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","पय गलत काम लग बचै के निता हर अक्ठी डउका के डउकी होय, अउ हर अक्ठी डउकी के डउका होय। ");
INSERT INTO bhu_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","हइ जरूरी हबै कि डउका अपन डउकी के हक पूर करै अउ ओसनेन डउकियो अपन डउका के हक पूर करै। ");
INSERT INTO bhu_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","डउकी अपन देह के हक नेहको, ऊ डउका के हक हबै अउ ओसनेन डउको अपन देह के हक नेहको, ऊ डउकी के हबै। ");
INSERT INTO bhu_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","तुम अक दूसर के ऊ हक लग दुरिहां झइ करा अगर असना करिहा, ता दोनो झन के सहमति लग अउ कुछ टेम के निता, जेखर लग बिनती के छुट्टी पाबा अउ एखर बाद पहिले जसना रहा, कहुं असना झइ होय कि परेत असहमती के कारन तुमही लालच हे फसाय दे। ");
INSERT INTO bhu_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","मै हइ आदेस के जसना मेर नेहको, पय अनुमति के जसना मेर कथो। ");
INSERT INTO bhu_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","मै हइ चाहथो कि जसना मै हबो ओसनेन सब मनसे होय, पय भगवान के तरफ लग हर अकझन के निक्खा बरदान मिले हबै कउनो के अक मेर के, अउ कउनोन के दूसर मेर के। ");
INSERT INTO bhu_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","अब मै उनखर लग कहे चाहथो जेखर काज नेहको होय हबै अउ जउन बिधवन हबै, अगर उन मोर मेर रहै चाहथै, ता हइ उनखर निता निक्खा हबै। ");
INSERT INTO bhu_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","अगर उन अपन खुद हे धीर नेहको धर सकै ता काज करले, काखे वासना रहै लग निक्खा हबै काज कर लेयका चाही। ");
INSERT INTO bhu_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","अब जेखर काज हुइ गय हबै, परभु के हइ आदेस हबै, कि डउकी अपन डउका लग अलगे झइ होबै, ");
INSERT INTO bhu_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","अगर उन अलगे हुइ जथै, ता बिना डउकी के रहै चाही या अपन डउका के संग फेरै रहै लग जाय, अउ न डउका अपन डउकी के छांडै। ");
INSERT INTO bhu_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","दूसर मनसेन लग मोर हइ कहना हबै कि अगर कउनो बिस्वासी भाई के डउकी परभु हे बिस्वास नेहको करत होय अउ अपन डउका के संग रहै चाहथै, ता ऊ भाई उके झइ छांडै। ");
INSERT INTO bhu_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","अगर कउनो बिस्वासी डउकी के डउका हमर परभु हे बिस्वास नेहको करत होय, अउ ऊ अपन डउकी के संग रहै चाहथै, ता ऊ डउकी अपन डउका के झइ छांडै। ");
INSERT INTO bhu_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","काखे बिस्वास नेहको करै बाले डउका अपन डउकी के दवारा पवितर करे गय हबै, अउ बिस्वास नेहको करै बाले डउकी अपन बिस्वासी डउका के दवारा सुध्द करे गय हबै, नहि ता तुम्हर लरका बच्चा असुध्द होतिन, पय अब ऊ पवितर हबै। ");
INSERT INTO bhu_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","दूसर तरफ, अगर बिस्वास नेहको करै बाले डउका अबिस्वासी हबै, अगर ऊ अलगे होमै चाहथै ता अलगे होमै दा, असना दसा हे बिस्वास करे बाले भाई बेहन के गुलाम हे नेहको, पय भगवान हमही सान्ति के जीवन बितामै के निता बोलाय हबै। ");
INSERT INTO bhu_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","तै का जानथस, हुइ सकथै कि डउकी अपन डउका के मुकति के कारन बन जाय, अउ डउका अपन डउकी के मुकति के कारन बन जाय। ");
INSERT INTO bhu_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","परभु हर अकझन के बोलाय हबै अउ जेही जउन मेर चुने हबै, उके ओसनेन जियेका चाही, सगलू मंडली हे मोर इहै आदेस देथो। ");
INSERT INTO bhu_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","जब कउनो के भगवान के दवारा बोलाउत टेम खतना हुइ चुके होय, ता ऊ हइ बात के लुकामै के कोसिस झइ करै, अगर बोलाउत टेम ओखर खतना नेहको होय हो, ता ऊ अपन खतना झइ कराबै, ");
INSERT INTO bhu_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","न तो खतना कराबै के कउनो मतलब आहिस, अउ जउन खतना नेहको कराय ओखरो कउनो मतलब नेहको हबै, मतलब तब हबै जब भगवान कर आदेस के मानै। ");
INSERT INTO bhu_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","हर अकझन जउन दसा हे बुलाय गय हबै, उहै रहै। ");
INSERT INTO bhu_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","तुम बोलाय जाय के टेम हरवाह रहा, ता एखर चिन्ता झइ करा, अगर तुम आजाद हुइ जइहा, ता मोका के फायदा उठाय लेया, ");
INSERT INTO bhu_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","काखे परभु के दवारा बोलाय जाय के टेम जउन हरवाह रथै, ऊ परभु हे आजाद करे हर मनसे हबै, उहैमेर जेही ऊ टेम बोलाय गय हबै, जब ऊ आजाद रथै, अब ऊ मसीह के हरवाह हबै। ");
INSERT INTO bhu_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","तुम यीसु के खून के दवारा खरीदे गय हबा, अब मनसेन के हरवाह झइ बना। ");
INSERT INTO bhu_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","हे भाई अउ बेहन, हर अकझन जउन दसा हे बुलाय गय हबा, ऊ उहै भगवान कर संगत हे रहै। ");
INSERT INTO bhu_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","टोरवा अउ टोरियन के बारे हे मोके परभु के तरफ लग कउनो मेर के आदेस नेहको मिले हबै, पय परभु कर दया लग बिस्वास करै बाले के काबिल होय के निता मै अपन सलाह देथो। ");
INSERT INTO bhu_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","मै समझथो कि अबे के दुख हे इहै निक्खा हबै कि मनसे जउन दसा हे हबै, उहै दसा हे रहै। ");
INSERT INTO bhu_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","अगर तोर डउकी हबै ता ओखर लग अलगे होमै के निता परयास झइ करा, अगर तुम्हर काज नेहको होय हबै? ता डउकी के खोज झइ करा। ");
INSERT INTO bhu_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","अगर तुम काज करत हबा, ता एहमा कउनो मेर के पाप नेहको अउ अगर कुमारी टोरिया काज करवाथै, ता ऊ पाप नेहको करथै। पय असना मनसे के हइ जीवन हे जरूर दुख सहै का पडही, अउ मै सही हे तुमही इन सब लग बचामै चाहथो। ");
INSERT INTO bhu_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","हे भाई मै तुम्हर लग हइ कथो, कि टेम चुटु हस हबै, अब लग जउन काज करवाय हर हबै उनो हइ मेर रहै जसना कि काज नेहको होय हबै, ");
INSERT INTO bhu_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","जउन दुखी हबै, उन असना रहै कि कउनो दुख नेहको हबै, जउन मगन हबै, उन असना मनामै कि कउनो मगन नेहको हबै, जउन कुछु चीज के धंधा करत होय, उन असना करै कि उनखर लिघ्घो कुछु चीज नेहको हबै, ");
INSERT INTO bhu_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","जउन हइ दुनिया के चीजन के ऊज करथै उन असना करै कि कउनो चीजन के ऊज नेहको करथै, काखे हइ दुनिया के चीज अबे के टेम हे अछप्प होत हबै। ");
INSERT INTO bhu_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","मै तो चाहथो कि तुमही कउनो चिन्ता झइ होय, जउन बिना काज बाले डउका हबै, ऊ परभु के बातन के चिन्ता करथै कि परभु के कसना मगन के सकि। ");
INSERT INTO bhu_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","जउन सादीसुधा हबै, ऊ मनसे दुनिया भर के बातन के चिन्ता करथै, ऊ अपन डउकी के मगन करै चाहथै। ");
INSERT INTO bhu_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","सादीसुधा अउ कुमारिन बाले हे अलगेन सोच हबै, बिना काज बाले परभु के चिन्ता हे रथै, ऊ जीवन अउ आतमा हे पवितर होय, पय सादीसुधा दुनिया के चिन्ता हे रथै कि अपन डउका के कसना मगन करी। ");
INSERT INTO bhu_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","मै तुम्हर फायदा के निता हइ कथो, न कि रोकथाम लगामै के निता। पय इहैनिता कि जसना निक्खा लागथै ओसनेन करे जाय, कि तुम अकचित हुइके परभु के सेबा हे लगे रहा। ");
INSERT INTO bhu_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","अगर कउनो के लगथै कि ऊ अपन कुमारी टोरिया के काज करै हे देर करथै, ता ऊ अपन टोरिया के संग अन्याय करथै, काखे ओखर उमर ढलथै, ऊ टोरिया उहै करै जउन उके समझमा आउथे, ओही काज करै देया एहमा कउनो पाप नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","पय जउन अपन मन हे ठाने हबै, जउन कउनो मेर के दबाव नेहको हबै, अउ अपन मन हे हइ बात के गांठ बान्ध लय होय कि ऊ अपन कुमारी टोरिया के बिना काज करै रखै, ता ऊ निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","इहैनिता जउन अपन कुमारी टोरिया कर काज करथै, ऊ निक्खा करथै, अउ जउन काज नेहको करथै, ऊ अउ निक्खा करथै। ");
INSERT INTO bhu_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","जब तक कउनो डउकी के डउका जिन्दा हबै, तब तक ऊ ओखर लग बन्धररे हबै, अगर ओखर डउका मर जथै, ता ऊ अपन इक्छा लग दूसर काज करे लग आजाद हबै, पय जरूरी इहो हबै कि ऊ डउका परभु हे बिस्वास करत होय। ");
INSERT INTO bhu_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","तउभरमा अगर ऊ बिना दूसर काज करवाय रही जथै, ता ऊ धन्य हबै। हइ मोर सोच हबै अउ मोके बिस्वास हबै कि भगवान कर आतमा मोरो हे हबै। ");
INSERT INTO bhu_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","मूरतिन के आगू बलि करे हर चीज के बारे हे हम जानथन कि हम सब ग्यानी हबन, सही हे ग्यान हमही घमंड बनाथै, जबकि माया हमही उन्नत करथै। ");
INSERT INTO bhu_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","अगर कउ हइ समझथै कि मै ग्यानी हबो ता सही हे ऊ अब तक नेहको जानिस कि कउन मेर जानै के चाही। ");
INSERT INTO bhu_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","अगर कउ भगवान लग माया करथै, ता भगवान उके चीनथै। ");
INSERT INTO bhu_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","जिहां तक मूरतिन के बलि चढाय हर चीज के खाय के सबाल हबै, हम हइ बात के चुटु-बोहत जानथन कि सगलू दुनिया हे कहुं मूरती हे कुछु नेहको हबै, पय अक्ठी के छांड के अउ कउ भगवान नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","पय बादर अउ भुंइ हे बोहत लग देउता हबै, जसना कि कइनठेन देउता अउ कइनठेन परभु हबै, ");
INSERT INTO bhu_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","पय हमर निता अक्ठिन भगवान हबै ऊ बाफ, जेखर लग सब कुछ पइदा होय हबै अउ जेखर लिघ्घो हमही जायके हबै अउ अक्ठिन परभु हबै, ऊ यीसु मसीह जेखर दवारा सब कुछ चीज बने हबै अउ हमु ओखरन दवारा बने हबन। ");
INSERT INTO bhu_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","पय हइ ग्यान सब के नेहको मिले हबै, कुछु मनसे असना हबै जउन अब तक मूरती पूजा करथै, उन हइ समझ के परसाद खथै कि देउता के बलि चढाय हर हबै अउ उनखर कमजोर मन असुध्द हुइ गय हबै। ");
INSERT INTO bhu_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","“खाना हमही भगवान के लिघ्घो नेहको पहुंचाय सकथै।” अगर हम मूरती हे चढाय हर परसाद नेहको खाबो ता ओखर लग हमही कउनो नुसकान नेहको, अउ अगर हम ऊ परसाद के खथन, ता ओखर लग हमही कउनो फायदा नेहको होही। ");
INSERT INTO bhu_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","पय चेतन्न रइहा कि तुम्हर हइ आजादी कहुं कमजोर मनसेन के निता ठोकड पाप के कारन झइ बनै। ");
INSERT INTO bhu_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","अगर कउनो के मन कमजोर हबै, अउ ऊ तुम्हर मेर ग्यानिन मनसे के मन्दिर के मूरती हे चढरेहर परसाद खात देख लइहीं, ता का उहो मूरती हे बलि चढरेहर चीज के खाय के निता हिम्मत नेहको करही? ");
INSERT INTO bhu_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","हइ मेर तुम्हर ग्यान के कारन ऊ ढिलवा भाई या बेहन के नास हुइ जथै, जेखर निता मसीह क्रूस हे मरिस। ");
INSERT INTO bhu_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","हइ मेर भाई अउ बेहन के बिरोध पाप करै लग अउ उनखर ढिलवा मन के ठेस पहुंचामै लग तुम मसीह के बिरोध पाप करथै। ");
INSERT INTO bhu_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","इहैनिता अगर मोर खाना मोर भाई या बेहन के निता पाप के कारन बनथै, ता मै फेर कबहुन कउनो मेर के गोस नेहको खइहों। कहुं असना झइ होय कि मै अपन भाई या बेहन के निता पाप के कारन बनो। ");
INSERT INTO bhu_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","का मै आजाद मनसे नेहको? का मै चेला नेहको? का मै हमर परभु यीसु के नेहको देखव? का तुम परभु हे मोर मेहनत के फल नेहको? ");
INSERT INTO bhu_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","मै दूसर के नजर हे भले चेला नेहको हबो, पय तुम्हर निता जरूर हबो, काखे तुम परभु हे मोर चेलन हे चिन्हा हबै। ");
INSERT INTO bhu_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","जउन मोर हे दोस लगाथै, उनखर लग अपन पछ हे मोर हइ कहना हबै, ");
INSERT INTO bhu_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","का हमही तुम्हर खाना खाय पिय के हक नेहको? ");
INSERT INTO bhu_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","का दूसर चेला, परभु के भाई अउ कैफा के जसना हमही अपन बिस्वासी बेहन के काज करे हर डउकी के अपन संग लइ जाय के हक नेहको? ");
INSERT INTO bhu_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","का मै अउ बरनबास अपन जीवन चलामै के निता काम करै के मजबूर हबन? ");
INSERT INTO bhu_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","कबहुं सुनै हे आय हबै कि कउन सैनिक हबै, जउन सिपाही हे सेबा करत टेम अपन खरचा खुदय उठाउत होय? कउनो हबै, जउन बगिया हे अंगूर लगाबै अउ खुद ओखर फडुहा नेहको खात होय? या कउनो असना हबै, जउन अपन गोरुन के दूध नेहको पियत होय? ");
INSERT INTO bhu_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","का मै हइ सिरिफ मनसेन के रीति लग कथो? का मूसा कर नियम हइ नेहको कथै? ");
INSERT INTO bhu_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","काखे मूसा कर किताब हे लिखवरे हबै, “दांय फांदत टेम बइला के मुंह झइ बांधा” का भगवान बइलन भर के चिन्ता करथै? ");
INSERT INTO bhu_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","का ऊ हमरे निता नेहको कथै? हइ जरूर हमर निता लिखे गय हबै, जरूरी हबै कि किसान आसा हे खेत जोतथै, अउ जउन दांय फांदथै, ऊ दांय के भागी लग जउन दाना झरही उहै लग पामै के आसा करै। ");
INSERT INTO bhu_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","अगर हम तुम्हर हे आतमिक बचन बोय हबन, ता का तुम्हर लग दुनिया दाना के आसा करैका कउनो बडा बात हबै? ");
INSERT INTO bhu_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","अगर तुम्हर हे दूसर के हक हबै, ता का तुम्हर हे हमर हक उन सबले बढके नेहको होही? तउ हम हइ हक के ऊज नेहको करेन, पय हम मसीह के संदेस के परचार हे कउ रुकावट झइ करै, इहैनिता हम सबैमेर के दुख सहथन। ");
INSERT INTO bhu_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","का तुमही नेहको पता कि बिनती भवन हे काम करै बालेन के खाना पीना मन्दिर लग मिलथै, अउ जउन बलि चढाय जथै, उन उहै बलि मसे अपन भाग पाथै? ");
INSERT INTO bhu_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","इहै मेर परभु के आदेस हबै कि उन, जउन भगवान के संदेस के परचार करथै, उहै के दवारा अपन रोजी रोटी कमाय। ");
INSERT INTO bhu_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","पय मै हइ हक के ऊज नेहको करेव अउ हइ मै इहैनिता नेहको लिखथो कि अब मोर निता असना करे जाय, मै भले मर जइहों, पय मै अपन के हइ बडाई लग अनजान नेहको होय दइहों। ");
INSERT INTO bhu_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","मै हइ बात हे घमंड नेहको करथो कि मै संदेस के परचार करथो, मोके तो असना करै के निता जरूरी हबै, लानत हबै मोके अगर संदेस के परचार नेहको करिहों, ");
INSERT INTO bhu_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","अगर मै अपन इक्छा लग हइ करतेव, ता मोके कुछ मजदूरी मिलतिस, पय मै अपन इक्छा लग नेहको करथो, मोके भन्डारी के काम सउपे गय हबै, मै ओही पूर करथो। ");
INSERT INTO bhu_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","तब का हबै मोर मजदूरी? हइ कि मै भगवान के संदेस के परचार फिरी हे करत रहों अउ एखर लग सबंध अपन हक के ऊज नेहको करव। ");
INSERT INTO bhu_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","सब मनसेन लग आजाद होमै लग मै खुद के सबके गुलाम बनाय लयो, जेखर लग मै बोहत मनसेन के जीत सको। ");
INSERT INTO bhu_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","मै यहूदियन के निता यहूदी बनो कि उनही जीत सको, जउन मनसे मूसा कर नियम के वस हे हबै, उनखर निता मै अक्ठी असना मनसे बनेव जउन मूसा कर नियम के वस हे हबै। अगर मै खुद मूसा कर नियम के वस हे नेहको हबो, मै इहैनिता करेव कि मै मूसा कर नियम के वस हे हबै उनही जीत सको। ");
INSERT INTO bhu_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","मूसा कर नियम के निता मै जउन भगवान कर नियम लग हीन नेहको पय मसीह के नियम लग वस हे ठहराय, नियम मेर बना कि नियम के तीन ले आबा। ");
INSERT INTO bhu_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","मै ढिलवन के निता ढिलवन मेर बनेव, जेखर लग मै उनही जीत सको, मै सब झन के निता सब कुछ बन गयों, जेखर लग कउनो न कउनो मेर लग कुछ मनसेन के मुकति हुइ जाय। ");
INSERT INTO bhu_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","मै हइ सब भगवान कर संदेस के निता करथो, जेखर लग महुं दूसरन के संग उनखर आसिरबाद के सहभागी बन जांव। ");
INSERT INTO bhu_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","का तुम नेहको जानथा कि दउरै हे तो सब दउरै बाले दउरथै, पय इनाम अकैझन के मिलथै? तुम असना दउरा कि इनाम पाय सका। ");
INSERT INTO bhu_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","हर अक्ठी खेल, जउन खेल हे भाग लेथै, उन हर बात हे धीर धरथै, उन नास होय बाले इनाम मुकुट पामै के निता असना करथै, जब कि हम जउन इनाम मुकुट कबहुं नास नेहको होमै बाले हबै ओखर निता करथन। ");
INSERT INTO bhu_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","इहैनिता मै अक्ठी जरूरी इनाम आगू धर के दउरथो, मै असना हवा हे मुटका नेहको मारथो। ");
INSERT INTO bhu_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","मै अपन देह के मारत पीटत अउ वस हे करथो, कहुं असना झइ होय कि दूसर के परचार करै के बाद मै खुदै कउनो मेर लग बेकार ठहरों। ");
INSERT INTO bhu_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","हे भाई अउ बेहन मै तुमही सुरता करवाथो कि हमर परदादा बादर के छाय हे चलिन, सब समुन्दर के नकिन, ");
INSERT INTO bhu_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","अउ हइ मेर बादर अउ समुन्दर लग “पानी हे बतिस्मा” लइके सब के सब मूसा कर सहपारटी बनिन। ");
INSERT INTO bhu_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","अउ सबझन अक्ठिन आतमिक खाना खाइन, ");
INSERT INTO bhu_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","अउ सब अक्ठिन आतमिक पानी पीन, काखे उन अक्ठी आतमिक पथरा के पानी पियत रहिन, जउन उनखर संग-संग रेंगत रहिस अउ ऊ पथरा मसीह रहिस। ");
INSERT INTO bhu_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","तउभरमा उनखर मसे बोहत मनसेन लग भगवान मगन नेहको हुइस, इहैनिता उन पतेरा हे मर गइन। ");
INSERT INTO bhu_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","हइ सगलू घटना हमर निता चेतावनी हबै कि हमही उनखर मेर बेकार चीजन के लालच नेहको करैका चाही। ");
INSERT INTO bhu_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","उनखर मसे कुछ मनसे के जसना तुम मूरती पूजा करे बाले झइ बना, जेखर बारे हे हइ लिखवरे हबै, “उन बइठिन खाय पीय के निता अउ उठिन ता खुसी मनामै के निता।” ");
INSERT INTO bhu_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","हम उनखर मेर गलत काम झइ करी, जसना कि उनखर मसे कुछ मनसे गलत काम करिन अउ अकै रोज हे तेइस हजार मर गइन। ");
INSERT INTO bhu_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","अउ न हम परभु यीसु मसीह के परखी, जसना उनखर मसे केतको मनसे करिन, अउ सपुवा के चाबै लग नास हुइ गइन। ");
INSERT INTO bhu_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","अउ न तुम कुनमुना, जसना कि उनखर मसे कुछ मनसे कुनमुनाइन अउ नास करै बाले दूत उनही नास के दइस। ");
INSERT INTO bhu_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","उनखर संग जउन गुजरिस हइ घटना चिन्हा हबै, जउन हमर निता सचेत के जसना लिखे गय हबै काखे हम ऊ पीढी हे हबन, जउन दुनिया आखरी टेम के लिघ्घो हबै। ");
INSERT INTO bhu_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","इहैनिता ऊ जउन हइ समझाथै कि मै बिस्वास हे मजबूत हबो, ऊ चेतन्न रहै कि कहुं असना झइ होय कि गिर परै। ");
INSERT INTO bhu_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","कउ असना परिक्छा तुम्हर हे झइ आबै, जउन सगलू मनसेन के निता सहै लग बाहिर हबै, भगवान बिस्वास हबै, ऊ तुमही कउनो असना परिक्छा हे नेहको परै देही, जउन तुम्हर सहै लग बाहिर होय पय ऊ परिक्छा के संग उपायो करही कि तुम बिस्वास हे मजबूत रही सका। ");
INSERT INTO bhu_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","इहैनिता हे मोर पिरिया तुम मूरती पूजा लग दुरिहां रहा। ");
INSERT INTO bhu_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","मै तुमही समझदार जानके हइ कथो, जउन मै कथो उके तुम परखा। ");
INSERT INTO bhu_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","का आसीस के खोरवा, जेहमा हम आसीस मागथन, का मसीह के खून के सहपारटी नेहको बनाथै? का ऊ रोटी जेही हम टोरथन, हमही मसीह के देह के सहपारटी नेहको बनाथै? ");
INSERT INTO bhu_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","रोटी तो अक्ठिन हबै, इहैनिता हम सब अक्ठिन रोटी के भागी हबन, देह अक्ठी हबै, काखे हम सब उहै अक्ठी रोटी हे सहभागी होथन। ");
INSERT INTO bhu_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","इस्राएलिन के बारे हे सोचा, जउन बेदी हे चढाय हर बलि खथै, का एखर दवारा उन अक्ठी नेहको हुइ जथै? ");
INSERT INTO bhu_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","मै हइ नेहको कथो कि मूरती के बलि चढाय हर चीज कउनो मतलब हबै अउ न ऊ मूरती के कउनो मतलब हबै। ");
INSERT INTO bhu_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","पय जसना मूसा कर किताब हे कहे गय हबै, “जउन बलि चढाय जथै ऊ भगवान के नेहको, पय भूतन के बलि चढाय जथै।” मै हइ नेहको चाहथो कि तुम भूतन के सहभागी बना। ");
INSERT INTO bhu_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","तुम परभु के खोरवा अउ भुतवा के खोरवा दोनोन मसे नेहको पी सकते हबा, तुम परभु के टेबुल अउ भुतवा के टेबुल दोनोन के सहभागी झइ बना। ");
INSERT INTO bhu_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","का हम परभु के गुस्सा देमै चाहथन? का हम ओखर लग बोहत बलवान हबन? ");
INSERT INTO bhu_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","“सब कुछ करै के अनुमति हबै” पय सब कुछ फायदा नेहको, “सब कुछ करै के अनुमति हबै” पय सब कुछ उन्नत के निता नेहको। ");
INSERT INTO bhu_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","सब कउ अपन भलाई के निता नेहको, पय दूसर के भलाई के निता परयास करा। ");
INSERT INTO bhu_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","बजार हे जउन गोस बिकथै, उके तुम अन्तर आतमा के सान्ति के निता बिना पूछे जांचे खाय सकथा, ");
INSERT INTO bhu_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","काखे जसना मूसा कर किताब हे कहे गय हबै, “भुंइ अउ ओहमा जउन कुछु हबै ऊ सब परभु के हबै।” ");
INSERT INTO bhu_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","जब अबिस्वासिन मसे कउ तुमही नेउता देथै, अउ तुम जायके चाहथा, ता जउन कुछु तुम्हर आगू पोरसे जही उके मन के सान्ति के निता बिना पूछे जांचे खाय सकथा। ");
INSERT INTO bhu_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","पय अगर कउ तुम्हर लग कथै, “हइ तो भुतवा के चढाय हर चीज हबै” ता जउन तुमही गुठेय हबै, ओखे कारन अउ मन के कारन उके झइ खइहा। ");
INSERT INTO bhu_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","मोर मतलब तुम्हर मन लग नेहको, बलुक दूसर मनसे के मन लग हबै, काखे मोर आजादी दूसर के मन के कारन बाधा नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","अगर मै धन्यबाद के पराथना करै के बाद खाना खाय हे सहभागी हुइ गय हबो, ता जउन खाना के निता मै भगवान के धन्यबाद करथो, ओखर कारन कउनो के मोर बुराई करै के हक नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","इहैनिता तुम चाहे खा या पिया, जउन कुछु करा सब भगवान के महिमा के निता करा। ");
INSERT INTO bhu_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","तुम कउनो के ठोकड के कारन झइ बना, न यहूदिन के निता, न यूनानियन के निता, न भगवान के मंडली के निता। ");
INSERT INTO bhu_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","महुं अपन भलाई के निता नेहको, पय दूसर के भलाई के धियान रखके सब बातन हे सब के मगन करै के परयास करथो, जेखर लग उन मुकति पाय सकै। ");
INSERT INTO bhu_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","जउन मेर मै मसीह के जसना चाल चलथो, तुमो मोर मेर चाल चला। ");
INSERT INTO bhu_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","तुम मोर हर बात के धियान रखत हबा अउ जउन रीति रिबाज मै तुमही सउपे हबो, उनखर हे मजबूत बने रथा, इहैनिता मै तुम्हर बडाई करथो। ");
INSERT INTO bhu_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","मै चाहथो कि तुम हइ जान लेया कि हर अक्ठी डउका के मूड मसीह यीसु हबै, अउ डउकी के मूड डउका हबै, अउ मसीह के मूड भगवान हबै। ");
INSERT INTO bhu_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","जउन डउका मूड ओढ के बिनती या आगू कर बात गुठेथै, ऊ अपन मूड मसीह के बेज्जती करथै, ");
INSERT INTO bhu_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","अउ जउन डउकी मूड उघारे बिनती या आगू कर बात गुठेथै, ऊ अपन मूड के बेज्जती करथै, काखे ऊ मुन्डा होमै के बरोबर हबै। ");
INSERT INTO bhu_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","अगर कउनो डउकी अपन मूड नेहको ओढथै, ता ऊ चूंदी कटवाय ले, चूंदी कटवाना या मुन्डी हुइ जाना हइ लाज के बात हबै, ऊ अपन मूड ओढ ले। ");
INSERT INTO bhu_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","डउका के अपन मूड नेहको ढाकै चाही, काखे ऊ भगवान के छाप अउ ओखर महिमा के गवरव हबै, जब कि डउकी डउका के महिमा के गवरव हबै। ");
INSERT INTO bhu_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","डउका डउकी लग नेहको बने हबै, पय डउकी डउका लग बने हबै, ");
INSERT INTO bhu_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","अउ डउका के रचना डउकी के निता नेहको बने हबै, बलुक डउका के निता डउकी के रचना होय हबै। ");
INSERT INTO bhu_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","इहैनिता स्वरगदूतन के कारन डउकी के जरूरी हबै कि अपन मूड के ओढे रहै। ");
INSERT INTO bhu_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","तउभरमा परभु हे तो डउकी के बिना डउका कुछु नेहको हबै, अउ डउका के बिना डउकी कुछ नेहको हबै। ");
INSERT INTO bhu_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","काखे जसना डउका लग डउकी के रचना होय हबै, ओसनेन डउका के पइदा डउकिन लग होथै, पय सगलू चीज के रचना भगवान लग होय हबै। ");
INSERT INTO bhu_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","तुमिन सोच बिचार करा, का हइ जरूरी हबै कि डउकी बिना मूड ओढे भगवान लग बिनती करै? ");
INSERT INTO bhu_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","का खुद के हइ सिक्छा नेहको देथै कि डउकन के लम्बा चूंदी रखैके लाज के बात हबै, ");
INSERT INTO bhu_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","जब कि डउकिन लम्बा चूंदी उनही मेरात हबै, काखे हइ उनही ओढै के निता देय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","अगर कउनो एखर बारे हे बात बिबाद करैका चाहथै, ता ऊ हइ जान ले कि न तो हमर इछो कउनो दूसर रीति रिबाज फइले हबै अउ न भगवान के मंडली के असना नियम हबै। ");
INSERT INTO bhu_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","हइ आदेस देयत मै तुम्हर कउनो बडाई नेहको करथो, मंडली हे तुम्हर जुडे लग भलाई नेहको पय बुराइन होथै। ");
INSERT INTO bhu_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","सबले पहली बात हइ हबै, कि जब तुम मंडली हे अक जिघा जुडथा, ता मोके सुनै हे हइ आय हबै कि तुम्हर हे फूट होय रथै, अउ मै हइ बात हे कुछ बिस्वासो करथो। ");
INSERT INTO bhu_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","तुम्हर हे फूट होमैके अक मेर लग जरूरी हबै, जेखर लग हइ पता चलै कि तुम्हर मसे कउन मनसे तेज हबै। ");
INSERT INTO bhu_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","जउन मेर लग तुम खाना के निता जुडथा, उके परभु भोज कहामै के ओग नेहको हबै, ");
INSERT INTO bhu_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","काखे सगलू मनसे हरबी खाना खाय हे लग जथै, हइ मेर कउनो तो भुखाय रह जथै अउ कउनो तो अंगूर के रस जरूरत लग जादा पी लेथै। ");
INSERT INTO bhu_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","का खाय पिये के निता तुम्हर घर नेहको हबै? या का तुम भगवान के मंडली के बदनाम करैका अउ गरीबन के बेज्जती करैका चाहत हबा? मै तुमही काहिन कहो? का तुम्हर बडाई करव? मै हइ बात के निता तुम्हर बडाई नेहको के सकथों। ");
INSERT INTO bhu_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","काखे हइ बात मोके परभु लग पहुंचे हबै, अउ मै तुमही पहुंचाय हबो कि परभु यीसु जउन रात ऊ पकडोय गय रहिस, रोटी लइस, ");
INSERT INTO bhu_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","अउ धन्यबाद करके उके टोरिस अउ कथै, “हइ मोर देह हबै जउन तुम्हर निता हबै मोर सुरता के निता इहैमेर करिहा।” ");
INSERT INTO bhu_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","इहैमेर खाना के बाद ऊ खोरवा लइस अउ कहिस, “हइ खोरवा मोर खून हे नबा टीमा हबै, जब कबहुन पीहा ता मोर सुरता के निता इहैमेर करिहा।” ");
INSERT INTO bhu_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","काखे जब कबहुन तुम हइ रोटी खइहा अउ हइ खोरवा मसे पीहा, ता परभु के मिरतू के जब तक ऊ नेहको आय जही तब तक परचार करत रइहा। ");
INSERT INTO bhu_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","इहैनिता जउन मनसे मजाक मेर लग परभु के रोटी खइहिन या ओखर खोरवा मसे पीहीं, ऊ परभु के देह अउ खून के पापी ठहरही। ");
INSERT INTO bhu_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","इहैनिता मनसे अपन खुद के परख ले तब हइ रोटी मसे खाय, अउ हइ खोरवा मसे पिये। ");
INSERT INTO bhu_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","काखे जउन खात पियत टेम परभु के देह के नेहको चीनथै, ऊ हइ खाय पिये लग अपन उप्पर नियाव लाथै। ");
INSERT INTO bhu_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","हइ कारन तुम्हर हे बोहत लग ढिलवा अउ नंगहा हबै अउ बोहत लग मरो गइन। ");
INSERT INTO bhu_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","अगर हम अपन मन के सही तरीका लग जांच लेयब ता सजा नेहको पउबे। ");
INSERT INTO bhu_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","तउभरमा जब परभु हमही दोसी ठहराथै, ता हइ हमर सुधार के निता हबै, जेखर हम दुनिया के संग दोसी झइ ठहरी। ");
INSERT INTO bhu_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","इहैनिता हे मोर भाई अउ बेहन जब तुम परभु भोज के निता जुडथा, ता अक दूसर के ओरगे करा। ");
INSERT INTO bhu_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","अगर कउनो के भूख लगै ता अपन घर हे खाय ले तुम्हर अक जिघा जुडे लग तुम नियाव के कारन झइ बना, बाकी बातन के मै आयके सही करिहों। ");
INSERT INTO bhu_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","हे भाई बेहन मै नेहको चाहथो, कि तुम आतमिक के बरदान के बारे हे अनचिन्हार रहा। ");
INSERT INTO bhu_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","तुमही सुरता हुइ कि मसीह हे अबिस्वासी गैर यहूदी रहा, तब तुम बउरी मूरतिन के पाछू चलै के निता भटकाय दय गय रहिन, ");
INSERT INTO bhu_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","इहैनिता मै तुमही गुठेय देथो कि कउनो मनसे भगवान के आतमा के अगुवाई हुइके हइ नेहको कहि सकथै, “यीसु सरापित होय” अउ कउनो मनसे पवितर आतमा के बिना हइ नेहको कहि सकथै, कि “यीसु परभु हबै।” ");
INSERT INTO bhu_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","बरदान तो कइन मेर के होथै, पय आतमा अक्ठिन हबै। ");
INSERT INTO bhu_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","अउ सेबा कइन मेर के होथै, पय परभु अक्ठिन हबै। ");
INSERT INTO bhu_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","काम करै के तरीका कइन मेर के हबै, पय अक्ठिन भगवान हबै, जउन सब मनसेन हे ओखर परभाव पइदा करथै। ");
INSERT INTO bhu_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","सगलू मनसेन के सब के फायदा के निता आतमा के उजेड मिलथै। ");
INSERT INTO bhu_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","कउनो के आतमा के दवारा दिमाक के बात दय जथै, अउ दूसर के उहै आतमा के दवारा सिक्छा के बात। ");
INSERT INTO bhu_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","अउ कउनोन के उहै आतमा लग बिस्वास करै के बरदान मिलथै, अक्ठिन आतमा कउनो के नंगहन के निक्खा करैका बरदान दय जथै। ");
INSERT INTO bhu_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","कउनोन के सक्ति के काम करैका, अउ कउनोन के आगू कर बात करै के निता, अउ कउनोन के आतमा के जांच करै के, अउ कउनोन के आने मेर के भासा बोलय के, अउ कउनोन के उन भासन के मतलब गुठेमै के बरदान देथै। ");
INSERT INTO bhu_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","इन सबझन के अक्ठिन आतमा हइ सब करथै, ऊ अपन इक्छा के जसना सबझन के अलगे-अलगे बरदान देथै। ");
INSERT INTO bhu_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","मनसेन के देह अक्ठिन हबै, पय ओखर कइनठेन अंग होथै, अउ देह के अंग कइनठेन होय लग देह अक्ठिन हबै, इहैमेर मसीह हबै। ");
INSERT INTO bhu_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","हम यहूदी हुइ या यूनानी, गुलाम हे हुइ या आजाद, अक्ठिन देह होय के निता अक्ठिन आतमा हे हमर पानी हे बतिस्मा करे गय हबै, अउ हम सबझन के अक्ठिन आतमा पियाय गय हबै। ");
INSERT INTO bhu_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","देह हे तो अक्ठी नेहको पय बोहत अंग हबै। ");
INSERT INTO bhu_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","अगर गोड कहि, “मै हाथ नेहको, इहैनिता देह के नेहको हबो,” ता का ऊ हइ कारन देह के अंग नेहको? ");
INSERT INTO bhu_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","अगर कान कहि, “मै आंखी नेहको हव, इहैनिता देह के नेहको हव,” ता का ऊ हइ कारन देह के अंग नेहको? ");
INSERT INTO bhu_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","अगर सगलू देह आंखी होतिस, ता ऊ कइसन के सुन सकतिस? अगर सगलू देह कान होतिस, ता ऊ कइसन के सूंघ सकतिस? ");
INSERT INTO bhu_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","पय सहीमा भगवान अपन इक्छा के जसना सगलू अंग के देह हे जिघा दय हबै। ");
INSERT INTO bhu_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","अगर सब के सब अक्ठिन अंग होतिन, ता देह कछो होतिस? ");
INSERT INTO bhu_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","सहीमा बोहत लग अंग होय लग अक्ठिन हबै देह हबै। ");
INSERT INTO bhu_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","आंखी हाथ लग नेहको कहि सकथै, “मोके तोर जरूरत नेहको हबै,” अउ मूड गोड लग नेहको कहि सकथै, “मोके तोर जरूरत नेहको हबै।” ");
INSERT INTO bhu_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","पय एखर उलटा देह के जउन अंग सबले कमजोर समझे जथै, ऊ बोहत जरूरी हबै ");
INSERT INTO bhu_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","देह के जउन अंगन के हम कमजोर समझथन, ओखर बोहत इज्जत करथन अउ बेकार अंगन के हम बोहत धियान रखे रथन। ");
INSERT INTO bhu_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","हमर सोभा बाले अंगन के ऐखर जरूरत नेहको होथै, पय भगवान देह के असना बनाय देथै कि जउन अंग के इज्जत के कमी होथै उहै के अउ बोहत इज्जत मिलथै। ");
INSERT INTO bhu_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","हइ इहैनिता हुइस कि देह हे फूट पइदा झइ होय, बलुक ओखर सगलू अंग अक दूसर के धियान रखै। ");
INSERT INTO bhu_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","अगर अक्ठी अंग हे पीरा होथै, ता ओखर संग सगलू अंगन के पीरा होथै अउ अगर अक्ठी अंग के बडाई होथै, ता ओखर संग सगलू अंग खुसी मनाथै। ");
INSERT INTO bhu_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","इहैमेर तुम सब मिलके मसीह के देह हबा, अउ तुम्हर मसे सबझन ओखर अक्ठी अंग हबा। ");
INSERT INTO bhu_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","भगवान मंडली हे कइन-कइन मेर के मनसेन के ठहराय हबै, आगू चेलन के, दूसर ग्यानी मनसे के, तीसर ग्यान देय बाले, अउ फेर सक्ति के काम करै बाले के, तब उन मनसेन के, जिनही निक्खा करै के बरदान पाय हबै, अउ भला करै बालेन के, अउ सासन देख रेख करै बाले अउ सबैमेर के भासा बोलै बालेन के। ");
INSERT INTO bhu_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","का सगलू चेला हबै? का सगलू ग्यानी मनसे हबै? का 