﻿USE sofia;
DROP TABLE IF EXISTS sofia.bht_vpl;
CREATE TABLE bht_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bht_vpl WRITE;
INSERT INTO bht_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ऐ यीशु मसीह दे पूर्वजां दे ना दी सूची है, सै राजा दाऊद दा बंशज था, जड़ा अब्राहम दा बंशज था। ");
INSERT INTO bht_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहम ला इसहाक पैदा होया, इसहाक ला याकूब पैदा होया, कने याकूब ला यहूदा कने उदे भाई पैदा होये। ");
INSERT INTO bht_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदा कने तामार ला पेरेस कने जेरह पैदा होया, कने पेरेस ला हिस्रोन पैदा होया, कने हिस्रोने ला एराम पैदा होया। ");
INSERT INTO bht_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","एराम ला अम्मीनादाब पैदा होया, कने अम्मीनादाब ला नहशोन, कने नहशोन ला सलमोन पैदा होया। ");
INSERT INTO bht_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सलमोन कने राहब ला बोअज पैदा होया, कने बोअज कने रुत ला ओबेद पैदा होया, कने ओबेद ला यिशै पैदा होया। ");
INSERT INTO bht_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","कने यिशै ला दाऊद राजा पैदा होया। कने दाऊदे ला सुलैमान, सै उसा जनानिया ला पैदा होया जड़ी पेहले ऊरिय्याह दी घरे बाली थी। ");
INSERT INTO bht_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सुलैमान ला रहबाम पैदा होया, कने रहबाम ला अबिय्याह पैदा होया, कने अबिय्याह ला आसा पैदा होया। ");
INSERT INTO bht_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","आसा ला यहोशाफात पैदा होया, कने यहोशाफात ला योराम पैदा होया, कने योराम ला उज्जियाह पैदा होया। ");
INSERT INTO bht_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्जियाह ला योताम पैदा होया, योताम ला आहाज पैदा होया, कने आहाज ला हिजकिय्याह पैदा होया। ");
INSERT INTO bht_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हिजकिय्याह ला मनश्शे पैदा होया, मनश्शे ला आमोन पैदा होया, कने आमोने ला योशिय्याह पैदा होया। ");
INSERT INTO bht_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","योशिय्याह ला यकुन्याह, कने उदे भाई पैदा होये। यकुन्याह कने उदे भाई इस्राएलियां जो कैदी बणाई करी बाबेल देशे जो लेई जाणे ला पेहले पैदा होये थे। ");
INSERT INTO bht_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","कैदी होईकरी बाबेल पुजाणे बाद यकुन्याहे ला शालतियल पैदा होया, कने शालतियेल ला जरुब्बाबेल पैदा होया। ");
INSERT INTO bht_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","जरुब्बाबेल ला अबीहूद पैदा होया, अबीहूद ला एलयाकीम पैदा होया, एलयाकीम ला अजोर पैदा होया। ");
INSERT INTO bht_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अजोर ला सादोक पैदा होया, सादोके ला अखीम पैदा होया, कने अखीम ला एलीहूद पैदा होया। ");
INSERT INTO bht_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","एलीहूद ला एलीआजार पैदा होया, एलीआजार ला मत्तान पैदा होया, कने मत्ताने ला याकूब पैदा होया। ");
INSERT INTO bht_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","याकूब ला यूसुफ पैदा होया, जड़ा मरियमा दा घरेबाला था, कने मरियम ला यीशु पैदा होया जिसयो मसीह बोलदे न। ");
INSERT INTO bht_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","अब्राहम ला लेईकरी दाऊदे दीकर सारियां चौदा पीढ़ियां होईयां, राजा दाऊदे ला बेबीलोन जो कैदी बणाई करी पुजाणे दीकर चौदा पीड़ियां, कने कैदी बणी करी बाबेल पुजाणे दे बकते ला लेईकरी मसीह दीकर चौदा पीढ़ियां होईयां। ");
INSERT INTO bht_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","यीशु मसीह दा जन्म होणे ला पेहले इयां होया, कि जालू उदी माता मरियम दी मंगणी यूसुफे सोगी होई गेई, तां उना दा बियाह होणे ला पेहले ही सै पबित्र आत्मा दिया शक्तिया ला गर्भबती होई गेई। ");
INSERT INTO bht_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","उसा दा होणेबाला घरेबाला यूसुफ बड़ा ही धर्मी था, कने उसा जो बदनाम नी करणा चांदा था, इस तांई उनी उसा जो डोल करी छडी देणे दे बारे च मने च सोचया। ");
INSERT INTO bht_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","जालू सै इना गल्लां दे बारे च सोचा दा था, तालू प्रभु दे स्वर्गदूते उदे सुपने च आई करी बोलया, “हे यूसुफ! राजा दाऊदे दे बंशज, तू मरियम जो अपणी घरे बाली बणाणे ला मत डर क्योंकि जड़ा उसा दे पेटे च है, सै पबित्र आत्मा दिया शक्तिया ने है। ");
INSERT INTO bht_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","कने उना इक जागत जमणा है, कने तू उदा ना यीशु रखयां, क्योंकि उनी अपणे लोकां जो उना दे पापां ला छुटकारा देणा है।” ");
INSERT INTO bht_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ऐ सारा कुछ इस तांई होया कि जड़ा बचन परमेश्वरे दा संदेश देणेबाले यशायाह बोलया था, सै पूरा होऐ, ");
INSERT INTO bht_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“दिख, इकी कुआरिया गर्भबती होंणा कने उना इक जागत जमणा है, कने उदा ना इम्मानुएल रखणा है,” जिसदा मतलब ऐ है, की परमेश्वर साड़े सोगी है। ");
INSERT INTO bht_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","तालू यूसुफ निंद्रा ला उठया, कने जियां स्वर्गदूते उसयो बोलया था, उनी मरियम ने बियाह किता, कने उसा जो अपणे घरे लेई आया। ");
INSERT INTO bht_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","जालू दीकर उना पुत्र नी जमया तालू दीकर उनी उसा ने कोई वैवाहिक संबंध नी रखया: कने यूसुफे उदा ना यीशु रखया। ");
INSERT INTO bht_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","जालू राजा हेरोदेस यहूदिया प्रदेश च शासन करा दा था, तालू यीशु दा जन्म उस प्रदेश दे बैतलहम शेहरे च होया। तालू तारयां दा ज्ञान रखणेबाले केई ज्योतिषी पूर्व दिशा ला यरूशलेम शेहरे च आई करी पूछणा लग्गे, ");
INSERT INTO bht_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“कि सै बच्चा कुथु है? जड़ा यहूदियां दा राजा बणने तांई पैदा होया है। क्योंकि असां पूर्व दिशा च उदे जन्म दे बारे च दसणे बाला तारा दिखया है, कने उसयो नमस्ते करणा आयो न।” ");
INSERT INTO bht_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","हेरोदेस राजा यहूदियां दे राजे दे जन्म दे बारे च सुणीकरी डरी गिया। कने मते सारे यरूशलेम शेहर दे बासी भी डरी गे। ");
INSERT INTO bht_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","कने तालू उनी लोकां दे सारे बड्डे याजकां कने व्यवस्था जो सिखाणे बालयां जो सदया कने उना ला पुछया, कि मसीह दा जन्म कुथु होंणा है? ");
INSERT INTO bht_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","उना राजा हेरोदेस जो बोलया, कि मसीह दा जन्म यहूदिया प्रदेश दे बैतलहम शेहरे च होणा है। क्योंकि परमेश्वरे दा संदेश देणेबालयां इयां ही लिखया है: ");
INSERT INTO bht_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“हे यहूदिया प्रदेश दे बैतलहम शेहरे दे लोको, तू कुसी भी तरीके ला यहूदा दे अधिकारियां चे सबते छोटा नी है; क्योंकि तिजो चे इक माणु निकलना है, जिनी मेरी प्रजा इस्राएले दी रखबाली करणी है।” ");
INSERT INTO bht_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","तालू राजा हेरोदेसे ज्योतिषियां जो डोल करी सदीकरी उना ला पुछया, कि तारा कुस बेले दिखया था, क्योंकि राजा उस बच्चे दी उम्र जाणना चांदा था। ");
INSERT INTO bht_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","कने उनी उना जो ऐ बोली करी बैतलहम शेहर च भेजया, “जा” कने उस बच्चे दे बारे च ठीक ढंगे ने पता करा, कने जालू सै मिली जांगा तां मिंजो खबर भेजनयो ताकि मैं भी उसयो नमस्ते करे। ");
INSERT INTO bht_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","सै राजे दी गल्ल सुणीकरी चली गे, कने जड़ा तारा उना पूर्व दिशा च दिखया था, सै तारा उना दे अग्गे-अग्गे चलया, कने उस घरे उपर रुकी गिया, जिथू सै बच्चा था। ");
INSERT INTO bht_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","कने सै उस तारे जो दिखीकरी बड़े खुश होये। ");
INSERT INTO bht_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","कने उस घरे जाई करी उस बच्चे जो कने उदिया माता मरियम जो सोगी दिखया, कने झुकी करी बच्चे जो नमस्ते किता, कने अपणा-अपणा थैला खोली करी उसयो सोना, कने लोबान, कने गंधरस दी भेंट चढ़ाई। ");
INSERT INTO bht_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","कने उना जो सुपने च परमेश्वरे ला चेतावनी मिल्ली कि राजा हेरोदेस बाल मुड़ी करी मत जांदे, कने ज्योतिषियां हेरोदेस जो खबर नी दिती कने होर रस्ते ला होईकरी अपणे देशे जो चली गे। ");
INSERT INTO bht_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","उना दे जाणे बाद दिखा, प्रभु दे इकी स्वर्गदूते यूसुफे दे सुपने च आई करी बोलया, “उठ! कने उस बच्चे जो कने उदिया माता जो लेईकरी मिस्र देशे जो चली जा; कने जालू दिकर मैं तिजो नी बोलगा तालू दीकर ओथु ही रियां, क्योंकि राजा हेरोदेस इस बच्चे जो तोपा दा है, ताकि उसयो मारी दे।” ");
INSERT INTO bht_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","कने सै तालू ही राती उठी करी बच्चे जो कने उदिया माता जो लेईकरी मिस्र देशे जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","कने राजा हेरोदेस दे मरणे दीकर सै ओथु ही रिया। इस तांई कि सै बचन पूरा हो जड़ा परमेश्वरे दा संदेश देणेबाले होशे बड़ा पहले बोलया था: “कि मैं अपणे पुत्रे जो मिस्र देश ला सदया।” ");
INSERT INTO bht_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","जालू हेरोदेस जो पता लग्गा कि ज्योतिषियां मिंजो धोखा दिता है। तालू उसयो बड़ा गुस्सा आया, कने उनी सिपाईयां जो भेजी करी ज्योतिषियां दे ठीक-ठीक दसयो बकते दे मुताविक बैतलहम शेहरे च कने उस दे अखे-बखे दे सारे बचयां जो जड़े दो सालां दे या उसला भी लोके थे, सै सारे मारवाई दिते। ");
INSERT INTO bht_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","तालू जड़ा बचन परमेश्वरे दा संदेश देणेबाले यिर्मयाह दे जरिये बोलया गिया था, सै पूरा होई गिया ");
INSERT INTO bht_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामाह शेहर च लोकां जो कुसकी दी बड़े जोरे ला रोणे दी अबाज सुणोया दी थी, राहेल अपणे बचयां तांई रोआ दी थी; कने चुप नी होणा चांहदी थी, क्योंकि सै हुण मरी गियो थे।” ");
INSERT INTO bht_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","यूसुफ मरियम कने बच्चा यीशु हल्ले दीकर मिस्र देशे च ही थे। राजा हेरोदेस दे मरणे बाद तां प्रभु दे स्वर्गदूते यूसुफे दे सुपने च आई करी बोलया, ");
INSERT INTO bht_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“उठ, कने बच्चे कने उदिया माता मरियम जो लेईकरी इस्राएल देशे जो चली जा, क्योंकि राजा हेरोदेस कने सै लोक जड़े बच्चे जो मारणा चांदे थे, सै सब मरी गियो न।” ");
INSERT INTO bht_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","सै उठया, कने बच्चे कने उदिया माता जो लेईकरी मिस्र देशे ला इस्राएल देशे जो बापिस आई गिया। ");
INSERT INTO bht_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","पर जालू यूसुफे ऐ सुणया कि अरखिलाउस अपणे पिता राजा हेरोदेस दिया जगा पर यहूदिया प्रदेश च राज करा दा है, तां सै ओथु जांणे ला डरया, कने उसयो परमेश्वरे सुपने च चेतावनी दिती, कने सै गलील प्रदेशे जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","कने यूसुफ नासरत नाऐ दे इक ग्रांऐ च जाई बसया, ताकि सै बचन पूरा हो, जड़ा परमेश्वरे दा संदेश देणेबालयां यीशु दे बारे च बोलया था: “कि यीशु मसीह जड़ा नासरत ला है कने इसी नाऐ ने जाणया जाणा।” ");
INSERT INTO bht_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","उना दिना च यूहन्ना बपतिस्मा देणेबाला यहूदिया प्रदेश दी इक सुनसान जगा च आई करी ये प्रचार करदा था कि: ");
INSERT INTO bht_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","अपणे पापां जो मनी लिया कने गलत कम्मा जो छडी दिया, क्योंकि स्वर्गे दा राज्य नेड़े ओआ दा है। ");
INSERT INTO bht_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ऐ सै ही है, जिदी चर्चा परमेश्वरे दा संदेश देणेबाले यशायाह किती थी, “सुनसान जगा ला इक हक्का पांणे बाले दी अबाज सुणाआ दी है, परमेश्वरे ओणे तांई, अपणे आपे जो तैयार करा, कने अपणे मने दी सोच समझा जो खरा रखा, उनी ओणा है।” ");
INSERT INTO bht_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","यूहन्ना ऊंटे दे बालां दे बणयो कपड़े पांदा था, कने अपणे लके च चमड़े दा पटा बनदा था, कने टिड्डे कने मखिर खांदा था। ");
INSERT INTO bht_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","तालू यरूशलेम शहरे दे कने सारे यहूदिया प्रदेशे दे, कने यरदन खड्डा दे अखे-बखे दे सारे इलाके दे लोक उदे बाल आये। ");
INSERT INTO bht_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","कने उना लोकां अपणे पापां जो मनया, कने यूहन्ना उना सारयां जो यरदन खड्डा च बपतिस्मा दिता। ");
INSERT INTO bht_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","कने जालू उनी मते फरीसियां कने सदूकियां जो बपतिस्मा लेंणे तांई अपणे बाल ओंदा दिखया, तां उनी उना जो बोलया, तुसां लोक जहरीले सांपा सांई बुरे न, तुहाड़ा ऐ सोचणा गलत है, कि सिर्फ तुसां बपतिस्मा लेणे ने अपणे पापां दी सजा ला बची जाणा जड़ी परमेश्वरे तुसां जो देणी है। ");
INSERT INTO bht_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","इस तांई अपणे पापां जो मन्नी करी बुरे कम्मा जो छडी करी अपणे पश्चाताप जो साबित करा। ");
INSERT INTO bht_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","कने अपणे-अपणे मना च ऐ मत सोचा, कि साड़ा पिता अब्राहम है; क्योंकि मैं तुहांजो बोला दा है, कि परमेश्वर इना पथरां ला भी अब्राहमे तांई ओलाद पैदा करी सकदा है। ");
INSERT INTO bht_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","कने हुण कुहाड़ी रुखां दिया जड़ा च रखियो है, इस तांई की जड़ा-जड़ा रुख खरा फल नी दिंगा, सै बड्डी करी अग्गी च फूकी देणा है। ");
INSERT INTO bht_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“तुसां पापां दा पश्चाताप करिके मन बदला, इस तांई मैं तुहांजो पांणिये ने बपतिस्मा दिन्दा है, पर जड़ा मेरे बाद ओणे बाला है, सै मिंजो ला भी शक्तिशाली है; मैं तां उदे जुते चुकणे जोगा भी नी है, उनी तुहांजो पबित्र आत्मा कने अग्गी ने बपतिस्मा देणा है। ");
INSERT INTO bht_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","उदा सूप्प उदे हथे च है, कने उनी अपणी कणक गांणे बाली जगा ढंगे ने साफ करणी, कने कणक पेड़ुआं च गठेरी रखणी, पर भूऐ जो उसा अग्गी च फुकणा जड़ी कदी बुझदी ही नी।” ");
INSERT INTO bht_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","उस बेले यीशु गलील प्रदेशे दिया यरदन खड्डा कंडे पर यूहन्ना बाल उसला बपतिस्मा लेणे तांई आया। ");
INSERT INTO bht_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","पर यूहन्ना उसयो ऐ बोली करी रोकणा लग्गा, कि मिंजो तां तेरे हथे ला बपतिस्मा लेणे दी जरूरत है, कने तू मेरे बाल आया है? ");
INSERT INTO bht_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","यीशुऐ उसयो ऐ जबाब दिता, “हुण तां इयां ही होणा दे, क्योंकि सांझो इस तरीके ने सै सब कुछ करणा चाईदा जड़ा परमेश्वर चांदा है।” तां यूहन्ना उदी गल्ल मनी लेई। ");
INSERT INTO bht_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","कने यीशु बपतिस्मा लेईकरी झट पांणिऐ ला बाहर आया, कने दिखया, उदे तांई अम्बर खुली गिया, कने उनी परमेश्वरे दिया आत्मा जो कबुतरे सांई उतरदे कने अपणे उपर ओंदे दिखया। ");
INSERT INTO bht_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","कने दिखा, स्वर्गे ला ऐ अबाज सुणोई की, “ऐ मेरा प्यारा पुत्र है, कने तिजो ला मैं खुश है।” ");
INSERT INTO bht_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","तालू पबित्र आत्मा यीशुऐ जो सुनसान जगा च लेई गेई ताकि शैतान उसयो लालच देई सके। ");
INSERT INTO bht_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","यीशु चाली दिन, कने चाली रात, बिना कुछ खादयो ओथु रिया, कने जालू उसयो भूख लग्गी। ");
INSERT INTO bht_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","तालू शैताने उदे बखे आई करी उसयो बोलया, “अगर तू परमेश्वरे दा पुत्र है, तां बोल, कि ऐ पथर रोटियां बणी जान, ताकि तू इना जो खाई सके।” ");
INSERT INTO bht_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","यीशुऐ जबाब दिता, “कि पबित्र शास्त्र च लिखया है, कि माणु सिर्फ रोटियां ला ही नी, पर परमेश्वरे दे बोलयो बचना जो मन्नी करी जिन्दा रेंदा है।” ");
INSERT INTO bht_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","तालू शैतान यीशुऐ जो पबित्र यरूशलेम शेहर च लेई गिया कने परमेश्वरे दे मंदरे दिया चुंडिया पर खरेड़ी दिता। ");
INSERT INTO bht_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","कने उसयो बोलया, अगर तू परमेश्वरे दा पुत्र है, तां ऐथू ला छाल मारी करी दस कने तिजो कुथी भी चोट नी लगणी है; क्योंकि पबित्र शास्त्र च लिखया है, कि उनी स्वर्गदूतां जो हुकम देणा; कने उना तिजो हथो हथ सभांली लेणा है; कुथी इयां ना होए कि तेरे पैरां च पथरे ला चोट लग्गी जा। ");
INSERT INTO bht_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","यीशुऐ उसयो बोलया, “कि पबित्र शास्त्र च ऐ भी लिखया है, कि लोकां जो अपणे प्रभु परमेश्वरे जो नी परखणा चाईदा।” ");
INSERT INTO bht_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","फिरी शैतान उसयो इक बड़े उच्चे पहाड़े पर लेई गिया, कने सारे संसारे दे राज्य कने उना दी धन दौलत दस्सी करी, ");
INSERT INTO bht_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","उनी बोलया, कि अगर तू मेरे पैरां पेईकरी मिंजो नमस्ते करगा, तां मैं ऐ सब कुछ तिजो देई दिंगा। ");
INSERT INTO bht_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","तालू यीशुऐ उसयो बोलया, शैतान दूर होई जा, क्योंकि पबित्र शास्त्र च लिखया है: “तू सिर्फ अपणे प्रभु परमेश्वरे जो नमस्ते कने सिर्फ उदी ही भक्ति कर।” ");
INSERT INTO bht_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","तालू शैतान उदे बखे ला चली गिया, कने स्वर्गदूत आई करी यीशुऐ दी सेबा करणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","जालू उनी ऐ सुणाया कि यूहन्ना जो पकड़ी करी जेला च बन्द करी लिया है, तां सै यहूदिया प्रदेश जो छडी करी गलील प्रदेशे जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","कने सै नासरते जो छडी करी कफरनहूम शेहरे च जड़ा गलील झिला दे कंडे था, जिथू जबूलून कने नप्ताली दे गोत्र रेंदे थे, ओथु जाई करी रेणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ताकि जड़ा परमेश्वरे दा संदेश देणेबाले यशायाह बोलया था, सै पूरा हो। ");
INSERT INTO bht_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“तुसां लोक जड़े जबूलून कने नप्ताली गोत्र दे इलाके च रेंदे न, ऐ इलाके उस रस्ते पर न जड़े गलील दरियाये दे बखे कने यरदन खड्डा दे पूर्वी कंडे पर है, ऐ गलील प्रदेशे दे ऐसे इलाके न जिथू होर जातियां दे लोक रेंदे न।” ");
INSERT INTO bht_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","परमेश्वरे जो जाणयो बिना नेहरे च रेणेबाले लोकां इक बडी ज्योति दिखणी; इना ज्योतिया उना लोकां जो मुक्ति दा रस्ता दसणा, जड़े परमेश्वरे जो जाणयो बिना जिन्दगी जिंदे न कने हमेशा दिया मौता दे रस्ते पर चलयो न। ");
INSERT INTO bht_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","उस बेले ला यीशुऐ प्रचार करणा कने ऐ बोलणा शुरू किता, “कि मन बदला क्योंकि स्वर्गे दा राज्य बखे आई रिया है।” ");
INSERT INTO bht_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","इक दिन जालू यीशु गलील झिला दे बखे-बखे चलया था, तां दो मछवारे भाईयां जो झिला च जाल पांदे दिखया, उना चे इक शमौन था जिसयो पतरस बोलदे न कने उदा भाई अन्द्रियास था। ");
INSERT INTO bht_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","यीशुऐ उना जो बोलया, “ओआ कने मेरे चेले बणा; मैं तुहांजो सिखांगा कि लोकां जो मेरे बाल कियां लोणा कने कियां मेरे चेले बणणा है।” ");
INSERT INTO bht_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","उना झट जाल छडया कने उदे पिच्छे चली पे। ");
INSERT INTO bht_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","जालू यीशु थोड़ा अग्गे चलया, उनी होर दो भाईयां जो दिखया जिना दे ना याकूब कने यूहन्ना थे, कने सै जब्दी दे पुत्र थे, सै किस्तिया पर जाले जो ठीक करा दे थे, कने यीशुऐ उना जो भी सदया। ");
INSERT INTO bht_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","सै झट किस्तिया कने अपणे पिता जो छडी करी उदे पीच्छे चली पे। ");
INSERT INTO bht_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","यीशु सारे गलील प्रदेशे च गुमदा रेंदा कने उना दे यहूदी जंज घरां च उपदेश दिन्दा कने राज्य दा शुभसमाचार दा प्रचार, कने लोकां दियां सारियां बिमारियां कने कमजोरियां जो ठीक करदा जांदा था। ");
INSERT INTO bht_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","कने सारे सीरिया प्रदेश च यीशुये दे कम्मा दी खबर फैली गेई कने लोक सारे बिमारां जो, जिना जो केई किस्मा दियां बिमारियां कने दुखां जकड़या था, कने जिना च बुरियां आत्मा थियां, कने मिर्गिया दे दौरे बाले, कने लकवे दे रोगियां जो उस बाल लेईकरी आऐ कने यीशुऐ उना सारयां जो ठीक करी दिता। ");
INSERT INTO bht_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","कने गलील प्रदेश कने दिकापुलिस शेहरे कने यरूशलेम शेहर कने यहूदिया प्रदेशे ला कने यरदन खड्डा दे पारे ला भिड़ा दी भीड़ उदे पिच्छे चली पेई। ");
INSERT INTO bht_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","यीशु भिड़ा जो दिखीकरी, पाहड़े पर थोड़ा उपर चली गिया, कने उना जो शिक्षा देणे तांई ओथु बेई गिया तां उदे चेले उदे बाल आये। ");
INSERT INTO bht_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","कने उना जो शिक्षा देणी शुरू किती: ");
INSERT INTO bht_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“धन्य न सै लोक, जड़े मने दे दीन न जिना जो परमेश्वर दी जरुरतां दा ऐहसास है, क्योंकि स्वर्गे दा राज्य उना दा ही है। ");
INSERT INTO bht_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","धन्य न सै लोक, जड़े शोक करदे न, क्योंकि परमेश्वरे उना जो शांती देणी। ");
INSERT INTO bht_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","धन्य न सै लोक, जड़े नम्र न, क्योंकि धरती उना दी होणी है। ");
INSERT INTO bht_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","धन्य न सै लोक, जड़े धार्मिकता ने जिन्दगी जिणे दी सच्ची भूख प्यास रखदे न, क्योंकि परमेश्वरे उना जो रजांणा है। ");
INSERT INTO bht_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","धन्य न सै लोक जड़े दयालु न, क्योंकि परमेश्वरे उना पर दया करणी। ");
INSERT INTO bht_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","धन्य न सै लोक, जिना दे मन साफ न, क्योंकि उना परमेश्वरे जो दिखणा। ");
INSERT INTO bht_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","धन्य न सै लोक, जड़े इकी दुज्जे दा मेल कराणे बाले न, क्योंकि उना जो परमेश्वरे दा पुत्र बोलया जाणा। ");
INSERT INTO bht_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","धन्य न सै लोक, जड़े धर्मे दे कम्म करणे दिया बजा ने सताऐ जांदे न, क्योंकि स्वर्गे दा राज्य उना दा ही है। ");
INSERT INTO bht_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","धन्य न तुसां, जालू माणुऐ मेरिया बजा ने तुहाड़ी निन्दा करणी कने तुसां जो सताणा क्योंकि तुसां मेरे चेले न कने झूठ बोली-बोली करी तुहाड़े खिलाफ हर तरां दियां बुरियाँ गल्लां बोलगे। ");
INSERT INTO bht_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","तालू तुसां खुश कने मगन होनयो क्योंकि तुहाड़े तांई स्वर्गे च बडा इनाम है। इस तांई कि जड़े बड़े बकते पहले परमेश्वरे दा संदेश देणेबाले थे उना जो भी इयां ही सताया था। ");
INSERT INTO bht_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","तुसां धरतिया पर लोकां तांई लूँणे सांई न; पर अगर लूँणे दा स्वाद बिगड़ी जा, तां फिरी सै कुसा चिजा ने लूँणका करणा? फिरी सै कुसी कम्मे दा नी है, सिर्फ इसी तांई कि इसयो बार सुटी दिया ताकि माणुआं दे पैरा हेठ ओए। ");
INSERT INTO bht_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","तुसां पुरे संसारे तांई ज्योति न। जड़ा शेहर पाहड़े पर बस्या है, सै कदी छुपी नी सकदा। ");
INSERT INTO bht_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","कने लोक दिय्या बाली करी टोकरुऐ हेठ नी रखदे न, पर उसयो उपर धारिया पर रखदे न, ताकि घरे दे सारे लोकां जो लौ होऐ। ");
INSERT INTO bht_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","तियां ही तुहाड़ी लौ भी माणुआं सामणे चमके तां सै तुहाड़े भले कम्मा जो दिखीकरी तुहाड़े पिता दी बड़ाई करन, जड़ा स्वर्गे च है। ");
INSERT INTO bht_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ऐ मत समझा कि, मैं मूसा दी व्यवस्था या परमेश्वरे दा संदेश देणेबालयां दिया गल्लां जो खत्म करणा आया है, मैं उना जो खत्म करणा नी, पर उना जो पूरा करणा आया है। ");
INSERT INTO bht_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","क्योंकि मैं तुसां ने सच्च बोलदा है, कि अम्बर कने धरती खत्म होई जांगे, पर परमेश्वरे दिया व्यवस्था ला कुछ भी, ऐथू दीकर इक बिंदु या मात्रा भी पूरा होयो बिना नी टलनी है। व्यवस्था दियां सारियां भविष्यवाणियाँ पुरियां होणियां न। ");
INSERT INTO bht_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","इस तांई जड़ा कोई छोटे ला छोटे हुकम चे कुसकी इकी जो भी नी मनगा, कने तियां ही लोकां जो सिखांगा, तां उसयो स्वर्गे दे राज्य च सारयां ला छोटा बोलणा, पर जड़ा कोई उना दा पालन करगा कने उना जो सिखांगा, सिर्फ उसयो ही स्वर्गे च महान बोलणा है। ");
INSERT INTO bht_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","मैं तुसां ने बोलदा है, कि अगर तुसां चे कोई स्वर्ग दे राज्य च जाणा चांदा है, तां तुसां जो व्यवस्था जो सिखाणे बाले कने फरीसियां ला बदीकरी परमेश्वरे दी व्यवस्था दा पालन करणा चाईदा। ");
INSERT INTO bht_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","तुसां सुणया होंणा, व्यवस्था जो सिखाणे बालयां साड़े पूर्वजां जो दसया कि ‘हत्या मत करदे’, कने जड़ा कोई हत्या करगा उसयो यहूदी सभा च सजा मिलणी है। ");
INSERT INTO bht_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","पर मैं तुसां जो ऐ बोलदा है, कि जड़ा कोई अपणे भाईऐ पर गुस्सा करगा, उसयो यहूदी सभा च सजा मिलणी : कने जड़ा कोई अपणे भाईऐ जो नकम्मा बोलगा उसयो महासभा च परमेश्वरे सजा देणी; जड़ा कोई अपणे भाईऐ जो निकम्मा कने मुर्ख बोले; उसयो नरके दी अग्गी दी सजा मिलणी। ");
INSERT INTO bht_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","इस तांई अगर तू अपणी भेंट चढ़ाणे तांई मंदरे जो लोऐ, कने ओथु तिजो याद ओऐ, कि मेरे भाईऐ दे मने च मेरे तांई कोई शिकायत है, ");
INSERT INTO bht_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","तां अपणी भेंट ओथु ही मंदरे दे सामणे छडी दे, कने पेहले जाई करी अपणे भाईये ने मेल मिलाप कर, तां फिरी आई करी अपणी भेंट चढ़ा। ");
INSERT INTO bht_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","कचेरी जांदे बकते रस्ते च ही तू अपणे बिरोधी ने राजीनामा करी ले, ताकि तेरा बिरोधी तिजो न्याय करणे बाले दे हथे ना देई दे, कने न्याय करणे बाला तिजो जेला च पाई दे। ");
INSERT INTO bht_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","मैं तुसां ने सच्च बोलदा है जालू दीकर तू इक-इक पैसा नी भरी दिंगा तालू दीकर तू जेलखाने ला नी छुटी सकदा है।” ");
INSERT INTO bht_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","तुसां सुणी बैठयो न कि परमेश्वरे हुकम दितया था, कि व्यभिचार मत करदे। ");
INSERT INTO bht_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","पर मैं तुसां ने ऐ बोलदा है, जड़ा कोई कुसा जनानिया जो बुरिया नजरा ने दिखे तां सै अपणे मने च उसा ने व्यभिचार करी बैठा है। ");
INSERT INTO bht_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","अगर तेरी सजी हख तेरे पाप दी बजा बणे, तां उसा जो कडी करी सट्टी दे; क्योंकि तेरे तांई ऐ ही खरा है कि तेरे अंगा चे इकी दा नाश होई जाऐ ताकि तेरा बाकी शरीर नरक जाणे ला बची जा। ");
INSERT INTO bht_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","कने अगर तेरा सज्जा हथ तेरे पाप करणे दी बजा बणे, तां तू उसयो बडी करी सुटी दे, क्योंकि तेरे तांई ऐ ही खरा है कि तेरे अंगा चे इक हिसा नाश होई जा, ताकि तेरा बाकी शरीर नरक जाणे ला बची जा। ");
INSERT INTO bht_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","मूसा दिया व्यवस्था च ऐ भी बोलया था, कि जड़ा कोई अपणिया घरे बालिया जो तलाक देणा चांदा है, तां उसा जो तलाकनामा दे। ");
INSERT INTO bht_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","पर मैं तुसां जो ऐ बोलदा है, कि जड़ा कोई अपणिया घरे बालिया जो व्यभिचार दे सिवा कुसी होरसी बजा ने छडी दे, तां सै उसा ला व्यभिचार करवांदा है; कने जड़ा उसा छडिया ने बियाह करे, सै व्यभिचार करदा है। ");
INSERT INTO bht_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","फिरी तुसां सुणी बैठयो न, कि व्यवस्था जो सिखाणे बालयां साड़े पूर्वजां बोलया था, झुठियां कसमां मत खांदे, पर परमेश्वरे दे सामणे खादियां अपणियां कसमां जो पुरियां करनयो। ");
INSERT INTO bht_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","पर मैं तुसां ने ऐ बोलदा है, कि कदी कसम मत खांदे; ना ही स्वर्गे दी, क्योंकि स्वर्ग परमेश्वरे दा सिंहासन है। ");
INSERT INTO bht_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ना ही धरतिया दी, क्योंकि सै उदे पैरां दी चौंकी है; कने ना ही यरूशलेम शेहर दी क्योंकि सै महान राजा परमेश्वरे दा शेहर है। ");
INSERT INTO bht_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","कने अपणे सरे दी भी कसम मत खांदा क्योंकि तू अपणे इक बाले जो भी ना चिट्टा, कने ना काला करी सकदा है। ");
INSERT INTO bht_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","पर तुहाड़ी गल्ल हां दी हां, कने ना दी ना हो; क्योंकि जड़ा कुछ इसला जादा होंदा है, सै शैतान ला होंदा है। ");
INSERT INTO bht_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","फिरी तुसां सुणी बैठयो न कि मूसा दिया व्यवस्था च लिखया है, कि अगर कोई तेरी हखी जो फोड़ी दे तां तुमी उदे बदले च उदी हख फोड़ी दे, कने इयां ही दंद दे बदले दंद तोड़ी दिया। ");
INSERT INTO bht_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","पर मैं तुसां ने ऐ बोलदा है, कि तुसां बदला मत लेंदे; पर जड़ा तेरिया सजिया खाडिया पर थपड़ मारे, तां उदे सामणे दुई खाडी भी करी दिया। ");
INSERT INTO bht_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","कने अगर कोई तिजो पर मुकद्दमा करी के जबरदस्ती तेरा कुरता लेणा चांदा है, तां उसयो अपणिया धोतिया भी लेणा दिया। ");
INSERT INTO bht_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","कने कोई रोमी सिपाई तिजो जबरदस्ती ही इक मील भर लेई जांदा है, तां उदे सोगी दो मील चली जा। ");
INSERT INTO bht_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","कने जड़ा कोई तिजो ला कुछ मंगे, तां उसयो देई दे; कने जड़ा तिजो ला उधार लेंणा चांदा है, उसयो मना मत करदे। ");
INSERT INTO bht_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","तुसां सुणी बैठयो न कि व्यवस्था च लिखया है; कि अपणे पड़ोसियां ने प्यार रखा, कने दुश्मणा ने दुशमणी रखा। ");
INSERT INTO bht_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","पर मैं तुसां ने ऐ बोलदा है, कि अपणे दुशमणा ने प्यार रखा, कने जड़ा तुसां जो सतादां है उस तांई प्राथना करा। ");
INSERT INTO bht_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","जिसने तुसां अपणे स्वर्गीय पिता दी ओलाद बणना है, क्योंकि सै खरे लोकां कने बुरे लोकां दोना उपर अपणा सूरज निकालदा है, कने धर्मियां कने अधर्मियां दोनो पर बरखा बरसांदा है। ");
INSERT INTO bht_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","क्योंकि अगर तुसां अपणे चाहणे बालयां ने ही प्यार रखन, तां परमेश्वरे तुसां जो फल नी देणा, क्योंकि चुंगी लेंणे बाले भी इयां ही करदे न? ");
INSERT INTO bht_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","कने अगर तुसां सिर्फ अपणे मसीह भाईंयां जो ही नमस्ते करदे न, तां तुसां दुज्जे लोकां दे बदले कोई बडा कम्म नी करदे न। क्योंकि होर जातियां जड़ियां परमेश्वरे दे हुकमा दा पालन नी करदियां न, सै भी तां इयां ही करदे न? ");
INSERT INTO bht_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","इस तांई तुहांजो उना जो प्यार करणा चाईदा जड़े तुहांजो प्यार नी करदे इस तरीके ने तुसां सिद्ध बणा, जियां तुहाड़ा स्वर्गीय पिता सिद्ध है। ");
INSERT INTO bht_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ध्यान रखा तुसां माणुआं जो दसणे तांई अपणे भले कम्म मत करा, नी तां तुहांजो अपणे स्वर्गीय पिता परमेश्वरे ला कोई इनाम नी मिलणा। ");
INSERT INTO bht_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","इस तांई जालू तू दान करे, तां इदा दिखावा मत करदा, जियां डोंगी लोक यहूदी जंज घरे च कने गलियां च करदे न, ताकि लोक उना दी बड़ाई करन, मैं तुसां ने सच्च बोलदा है, कि उना जो लोकां ला अपणा इनाम मिली गिया है। ");
INSERT INTO bht_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","पर जालू तू दान करे, तां तेरा दान गुप्त हो जड़ा लोकां च कुसी जो भी पता ना चले। ");
INSERT INTO bht_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ताकि तेरा दान गुप्त रे, कने तालू तेरा पिता परमेश्वरे जड़ा गुप्त च दिखदा है, उनी तिजो उदा इनाम देणा। ");
INSERT INTO bht_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","जालू तू प्रार्थना करे, तां कपटियां सांई मत करदा क्योंकि सै लोकां जो दसणे तांई यहूदी जंज घरे च कने सड़कां दे मोड़ा पर खड़ोई करी प्राथना करदे न, सै इस तांई करदे न ताकि लोक उना जो दीखन कने प्रशंशा करन। मैं तुसां ने सच्च बोलदा है, कि उना जो अपणा इनाम मिली गिया है। ");
INSERT INTO bht_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","पर जालू तू प्राथना करगा, तां अपणे कमरे अंदर जा, कने दरबाजा बंद करिके अपणे पिता परमेश्वरे ने प्राथना कर जिसयो कुनी नी दिखया है, तालू तेरे पिता परमेश्वरे जड़ा गुप्त च दिखदा है, उनी तिजो इदा इनाम देणा। ");
INSERT INTO bht_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","पर प्राथना करदे बेले होर जातियां सांई बेकार च बड़बड़ा मत करा, क्योंकि सै समझदे न कि उना दे बड़बड़ाणे ने परमेश्वरे उना दी सुणी लेणी है। ");
INSERT INTO bht_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","इस तांई तुसां उना सांई मत बणा, क्योंकि तुहाड़ा पिता परमेश्वरे तुहाड़े मंगणे ला पैहले ही जाणदा है, कि तुहाड़ियां क्या-क्या जुरूरतां न। ");
INSERT INTO bht_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","इस तांई तुसां जो इस तरीके ने प्राथना करणा चाइदी की: है साड़े पिता परमेश्वर, जड़ा तू स्वर्गे च है; तुहाड़ा ना पबित्र मनया जाये। ");
INSERT INTO bht_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","सारे माणुआं पर तू राज्य करे। जियां तेरी इच्छा स्वर्गे च पुरी होंदी है, तियां ही धरतिया च भी पूरी होऐ। ");
INSERT INTO bht_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","सांझो हर रोज सै खाणा दे जड़ा सांझो उस दिने तांई चाईदा है। ");
INSERT INTO bht_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","कने जियां असां अपणे गुनागारां जो माफ कितया है, तियां ही तू भी साड़े पापां जो माफ कर। ");
INSERT INTO bht_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","कने साड़ी परख ना ले, पर सांझो शैताने ला बचा। क्योंकि राज्य कने पराक्रम कने महिमा सदा तेरी है। आमीन। ");
INSERT INTO bht_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","इस तांई अगर तुसां माणुआं दे गुनहां जो माफ करगे जड़े उना तुहाड़े खिलाफ कितयो, तां तुहाड़े स्वर्गीय पिता परमेश्वरे भी तुहाड़े गुनहां माफ करणे। ");
INSERT INTO bht_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","कने अगर तुसां माणुआं दे गुनाहां जो माफ नी करगे, तां तुहाड़े पिता परमेश्वरे तुहाड़े गुनाहां भी माफ नी करणे। ");
INSERT INTO bht_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","जालू तुसां बरत रखन, तां कपटियां सांई तुहाड़े मुऐ पर उदासी नी होणा चाईदी क्योंकि सै अपणा मु उदास बणाई रखदे न, ताकि लोकां जो पता लग्गे कि उना बरत रख्या है। मैं तुसां ने सच्च बोलदा है, कि उना जो अपणा इनाम मिली गिया है। ");
INSERT INTO bht_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","पर जालू तू बरत रखे तां अपणे सिरे पर तेल मल कने मुऐ जो धोई ले। ");
INSERT INTO bht_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ताकि लोकां जो नी, पर तेरे पिता परमेश्वरे जो पता लग्गे जिसयो कुनी नी दिखया है, उनी तिजो इदा इनाम देणा। ");
INSERT INTO bht_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","अपणे तांई धरतिया च धन दौलत मत गठेरा, जिथू कीड़ा कने भुत्थी खराब करदी है, कने जिथू चोर नजर रखदे न कने ताले तोड़ी करी चोरी लेई जांदे न। ");
INSERT INTO bht_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","पर भलाई करी के अपणे तांई स्वर्गे च धन दौलत गठेरा, जिथू ना तां कीड़ा लगदा है, ना भुत्थी खराब करदी है, कने जिथू ना कोई नजर रखदा कने ना कोई चोरदा है। ");
INSERT INTO bht_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","क्योंकि तेरा मन हमेशा ओथु लग्गी रेणा जिथू तेरी धन दौलत है। ");
INSERT INTO bht_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","हखी शरीरे तांई इक दिय्ये सांई न, इस तांई अगर तेरियां हखी साफ न, तां तेरे सारे शरीरे च भी लौ होंणी। ");
INSERT INTO bht_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","पर अगर तेरियां हखी बुरियाँ न, तां तेरा सारा शरीर भी नेहरे च होणा; इसा बजा ने जड़ी लौ तिजो च है, अगर सै नेहरा होए तां सै नेहरा कितणा जादा होणा! ");
INSERT INTO bht_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","कोई माणु इक ही बकते दो मालकां दी सेबा नी करी सकदा, क्योंकि उनी इकी ने दुश्मनी कने दुऐ ने प्यार रखणा, या इकी ने मिली के रेणा कने दुऐ जो घटिया समझणा। तुसां परमेश्वर कने धन दौलत दोनो दी सेबा नी करी सकदे। ");
INSERT INTO bht_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","इस तांई मैं तुसां ने बोलदा है, कि अपणी रोजे दी जिन्दगी जिणे तांई ऐ चिंता मत करदे असां क्या खांणा, कने क्या पिणा, कने ना अपणे शरीरे तांई कि क्या पेनणा, क्या अपणे प्राण खाणे ला कने शरीर कपड़े ला बदीकरी नी है? ");
INSERT INTO bht_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","अम्बरे दे पंछियां जो दिखा। सै ना कुछ रांदे न, ना बडदे न, ना खेतरां च बटोलदे न, तमी तुहाड़ा स्वर्गीय पिता परमेश्वर उना जो खुआंदा है। तुसां क्या इना पंछियां ला जादा कीमती नी न? ");
INSERT INTO bht_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","तुसां चे ऐसा कुण है, जड़ा चिंता करणे ने अपणिया जिन्दगिया च इक घड़ी भी बधाई सकदा है? ");
INSERT INTO bht_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","कने कपड़यां तांई कजो चिंता करदे न? जंगली फुलां पासे ध्यान दिया, कि सै कियां बडुदें न, सै ना तां मेहनत करदे न, कने ना ही कपड़े बणादे न। ");
INSERT INTO bht_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","तमी मैं तुसां ने बोलदा है, कि जालू राजा सुलैमान बाल बड़ा भरी धन दौलत थी, तालू भी उनी उना चे कुसी सांई भी कपड़े नी पायो थे। ");
INSERT INTO bht_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","इस तांई अगर परमेश्वर बणे दे घाऐ जो, जड़ा अज है, कने कल अग्गी च फुकया जांणा, तमी परमेश्वर घाऐ जो इतणी सुन्दरता दिन्दा है, तां हे अल्पविश्वासियों, तां उनी पक्का तुसां दी देखभाल करणी है, पर परमेश्वरे पर तुहाड़ा भरोसा इतणा घट्ट कजो है? ");
INSERT INTO bht_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","इस तांई तुसां चिंता करिके ऐ मत बोलदे, कि असां क्या खांगे, या क्या पींगे, या क्या पेनगे? ");
INSERT INTO bht_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","क्योंकि होर जातियां इना सारियां चीजा दियां तोपा च रेंदियां न, कने तुहाड़ा स्वर्गीय पिता परमेश्वर जाणदा है, कि तुसां जो ऐ सारियां चिजा चाईदियां न, इना दी चिंता मत करा। ");
INSERT INTO bht_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","इस तांई पेहले तुसां परमेश्वरे दे राज्य कने धार्मिकता दी जिन्दगी जिणे दी कोशिश करा, तां तुसां जो ऐ सारियां चिजा मिली जाणियां। ");
INSERT INTO bht_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","इस तांई कल्ले तांई चिंता मत करा, क्योंकि कल दा दिन अपणी चिंता अपु करी लेंदा है; अज्जे तांई अज्जे दा दुख ही बतेहरा है। ");
INSERT INTO bht_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","दुजयाँ पर दोष मत ला, ताकि परमेश्वर तुहांजो पर भी कोई दोष ना लाये। ");
INSERT INTO bht_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","क्योंकि जियां तुसां कुसी पर दोष लांदे न, तियां ही परमेश्वरे तुहांजो पर भी दोष लगाणा; कने जियां तुसां दुजयां ने व्यवहार करदे न, तियां ही परमेश्वरे तुहाड़े सोगी करणा। ");
INSERT INTO bht_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","तू कजो अपणे विश्वासी भाईऐ दियां छोटियां-छोटियां गलतियां जो दिखदा है, जड़ियां उदिया हखी च पियो छोटे दे कखे सांई न, अगर तेरिया जिन्दगिया च मते पाप न, जड़ा तेरिया अपणी हखी च इक लठे सांई है, तां सै तिजो कनी नी मिलदा? ");
INSERT INTO bht_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","जालू तेरे अंदर ही मते पाप न, तां तू खुद ला घट पाप बाले कुसी भाईये दी मदद कियां करी सकदा है। ");
INSERT INTO bht_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","कपटियों, पेहले तां अपणे आपे दे पापां जो सुधारी ले, तां तू अपणे भाईये दिया हखी दे कखे जो ढंगे ने दिखीकरी कडी सकदा है, कने तां दुजयां जो उना दे छोटे पापां जो सुधारणे च मदद करी सकणा। ");
INSERT INTO bht_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","उना लोकां जो परमेश्वरे दा संदेश मत सुणा जड़े बचना जो सुणना नी चांदे। अगर तुसां ऐसा करदे न, तां ऐ ऐसा होणा जियां पबित्र चिजां जो कुतयां अग्गे फेंकी देणा, या जियां सूअरां दे अग्गे हीरे मोती फेंकणा, उना तां सै पैरां हेठ गरेचणे कने फिरी करी तुसां पर ही हमला करणा। ");
INSERT INTO bht_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","तुसां जो जड़ा चाईदा सै परमेश्वरे ला मंगा कने उनी तुसां जो देणा; अगर तुसां तोपगे, तां तुसां जो मिलणा; अगर खटखटांगे, तां तुहाड़े तांई खुलणा। ");
INSERT INTO bht_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","क्योंकि जड़ा कोई मंगदा है, उसयो मिलदा है; जड़ा तोपदा है, उसयो मिलदा है; कने जड़ा दरबाजा खटखटांदा है, उदे तांई खोलया जाणा। ");
INSERT INTO bht_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","तुसां चे कोई भी ऐसा माणु नी है, जड़ा अपणे पुत्रे दे रोटी मंगणे पर उसयो पथर दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","इयां ही अगर तुहाड़ा जागत तुसां ला खांणे जो मछी मंगे तां क्या तुसां उसयो जरिला सप्प दिन्दे न? ");
INSERT INTO bht_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","जालू तुसां बुरे होईकरी, अपणे बचयां जो खरियाँ चिजा देणा जाणदे न, तां तुहाड़े स्वर्गीय पिता परमेश्वरे अपणे मंगणे बालयां जो खरियाँ चिजा कनी दिंगा? ");
INSERT INTO bht_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","इसा बजा ने जड़ा कुछ तुसां चांदे न, कि माणु तुहाड़े सोगी करे, तां तुसां तियां ही उना सोगी करा; क्योंकि मूसा दी व्यवस्था कने परमेश्वरे दा संदेश देणेबाले दी शिक्षा दा मतलब ऐई है। ");
INSERT INTO bht_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","तुसां सिर्फ सुंगड़े फाटके ला परमेश्वरे दे राज्य अंदर जा, क्योंकि जड़ा फाटक चौड़ा कने असान रस्ता है, सै बरबादिया पासे लेई जांदा है; कने मते भरी लोक न जड़े इस रस्ते ला जांदे न। ");
INSERT INTO bht_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","क्योंकि सुंगड़ा सै फाटक है, कने औखा है सै रस्ता जड़ा अनन्त जिन्दगी बाल पुजांदा है, सै लोक थोड़े ही न जिना जो ऐ रस्ता मिलदा है। ");
INSERT INTO bht_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","असां परमेश्वरे दे संदेश देणेबाले लोक न, ऐसा अपणे आपे जो बोलणे बाले झूठे लोकां ला चौकने रिया। सै उना भेड़ियां सांई न जिना अपणे आपे जो भेडां दियां खल्ली ने ढक्या है, लोकां जो यकीन दिलाणे तांई कि सै सच्ची च भेडां न, पर सै असल च भेड़िये न जड़े लोकां पर हमले करदे न। ");
INSERT INTO bht_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","उना दे कम्मा ने तुसां उना जो पछेणी लेणा है। लोक क्या झिल्लां ला अंगूर, या कंडे बाले झिल्लां ला अंजीर तोड़दे न? ");
INSERT INTO bht_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","इयां ही इक खरा रुख खरा फल दिन्दा है, कने बेकार रुख बुरा फल दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","खरा रुख बुरा फल नी देई सकदा, कने ना बेकार रुख खरा फल देई सकदा है। ");
INSERT INTO bht_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","जड़ा-जड़ा रुख खरा फल नी दिन्दा है, सै बडी देणा है, असां परमेश्वरे दे संदेश देणेबाले लोक न ऐसा अपणे आपे जो बोलणे बाले झूठे लोकां जो ऐई सजा मिलणी है। ");
INSERT INTO bht_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","तुसां उना दे कम्मा ने जड़े सै करदे न उना जो पछेणी लेणा है। ");
INSERT INTO bht_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","जड़ा मिंजो ने, हे प्रभु, हे प्रभु बोलदा है, उना सारयां ही स्वर्गे दे राज्य च प्रवेश नी करणा है, सिर्फ उना ही जड़े मेरे स्वर्गीया पिता परमेश्वरे दिया मरजिया पर चलदे न। ");
INSERT INTO bht_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","न्याये दे रोजे मतयां लोकां मिंजो ने बोलणा; प्रभु जी, प्रभु जी, क्या असां तेरे नाऐ दी भविष्यवाणी नी किती, कने तेरे नाऐ ने बुरियां आत्मा जो नी कडया, कने तेरे नाऐ ने कितणे ही चमत्कारी कम्म नी किते? ");
INSERT INTO bht_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तालू मैं उना ने खुली करी बोली देणा है, कि मैं तां तुसां जो जाणदा ही नी, बुरे कम्म करणे बाले लोको, ऐथू ला चली जा। ");
INSERT INTO bht_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","इस तांई जड़ा कोई मेरियां गल्लां सुणीकरी उना जो मनदा है, सै उस अकला बाले माणुऐ सांई है, जिनी अपणा घर चट्टान पर बणाया है। ");
INSERT INTO bht_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","कने अम्बर बरया कने बाढ़ आई, कने तूफान चलया, कने सै उस घरे ने टकराया, पर सै घर नी डेथा, क्योंकि उस दी नीव चट्टाना पर बणईयो थी। ");
INSERT INTO bht_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","पर जड़ा कोई मेरियां इना गल्लां जो सुणदा है, कने उना पर नी चलदा है, सै उस मुर्ख माणुऐ सांई है जिनी अपणा घर रेता पर बणाया है। ");
INSERT INTO bht_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","कने अम्बर बरया, कने बाढ़ आई, तूफान चले, कने उस घरे ने टकराऐ कने सै घर डेई करी सारा भजी टूटी गिया। ");
INSERT INTO bht_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","जालू यीशु ऐ गल्लां बोली बैठा, तां इयां होया कि सारी भीड़ उस दे उपदेशे ने हेरान होई। ");
INSERT INTO bht_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","क्योंकि सै उना जो व्यवस्था जो सिखाणे बालयां सांई नी, पर अधिकारियां सांई उना जो उपदेश दिन्दा था। ");
INSERT INTO bht_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","जालू यीशु उस पाहड़े ला थल्ले उतरया, तां इक बड़ी बडी भीड़ उदे पिच्छे चली पेई। ");
INSERT INTO bht_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","इकी कोढ़िये यीशुऐ बाल आई करी उसयो नमस्ते किते कने बोलया, “कि प्रभु जी अगर तू चाआं, तां मिंजो ठीक करी सकदा है।” ");
INSERT INTO bht_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","यीशुऐ हथ अग्गे करी के उसयो छुता, कने बोलया, “मैं चांदा है कि तू ठीक होई जा” कने तालू ही उस कोढ़िये दा कोढ़ ठीक होई गिया। ");
INSERT INTO bht_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","यीशुऐ उसयो बोलया, “दिख, कुसी ने कुछ मत बोलदा, पर जाई करी अपणे आपे जो याजकां ने दस, कि तु खरा होईया कने परमेश्वरे जो भेंट चढ़ा जिदे बारे च मूसा व्यवस्था च लिखया है, ताकि लोक जाणी सकन कि तु खरा होई गिया।” ");
INSERT INTO bht_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","यीशु जालू कफरनहूम शेहर च आया तां इकी रोमी सुबेदारे उस बाल आई करी बिनती किती, ");
INSERT INTO bht_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“प्रभु जी, मेरे नोकरे जो लकवे दी बिमारी होई गियो है, कने सै हिली-जुली नी सकदा है, कने बड़ा दुखी है।” ");
INSERT INTO bht_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","यीशुऐ उसयो बोलया, “मैं आई करी उसयो ठीक करगा।” ");
INSERT INTO bht_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","सुबेदारे जबाब दिता, कि प्रभु जी, मैं इस लाइक नी है कि, कि तू मेरे घरे ओऐ, पर तू सिर्फ हुकम करी दे, तां ही मेरे नोकरे ठीक होई जाणा। ");
INSERT INTO bht_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","मैं ऐ समझदा है क्योंकि मैं भी अधिकारियां दे थल्ले कम्म करणे बाला माणु है। कने मेरे अधीन सपाई कम्म करदे न, कने जालू इकी सपाईऐ जो बोलदा है कि, तू जा, तां सै चली जांदा है; कने दुऐ जो बोलदा है कि, तू ऐथू आ, तां सै आई जांदा है; कने जालू मैं अपणे नोकरे जो बोलदा, कि ऐ कर, तां सै करी दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ऐ सुणीकरी यीशुऐ हेरानी होई, कने जड़े उदे पिच्छे ओआ दे थे उना ने बोलया, “मैं तुसां ने सच्च बोलदा है, कि मैं इस्राएल देशे च इक भी ऐसा माणु नी दिखया, जड़ा इस गैर-यहूदी माणुऐ सांई मिंजो पर भरोसा करदा है। ");
INSERT INTO bht_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","कने मैं तुसां ने बोलदा है, कि मतयां होर जाति दे लोकां पूर्व कने पशचमें ला आई करी अब्राहम कने इसहाक कने याकूबे सोगी स्वर्ग राज्य दे भोज च शामिल होणा है। ");
INSERT INTO bht_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","पर इस्राएलियां जो बाहर नेहरे च पाई देणा है, ओथु उना रोणा कने दंद पीणे न।” ");
INSERT INTO bht_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","कने यीशुऐ सूबेदारे जो बोलया, “घरे जा, जदेया तेरा भरोसा है, तदेया ही तेरे तांई हो। कने उदा सेवक तालू ही ठीक होई गिया।” ");
INSERT INTO bht_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","कने यीशु जालू पतरसे दे घरे पुज्जा, तां उनी उदिया ससु जो बिस्तरे च पिया दिखया कने उसा जो बुखार चढ़या था। ");
INSERT INTO bht_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","कने उनी उसा दा हथ छुता कने उसा दा बुखार उतरी गिया, कने सै उठी करी उदी सेबा करणा लगी पेई। ");
INSERT INTO bht_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","कने जालू संज होई तालू सै यीशुऐ बाल मते सारे लोकां जो लेईकरी आये जिना च बुरियां आत्मा थियां, कने उनी उना आत्मा जो अपणे बचने ने कडी दिता, कने सारे मरिजां जो ठीक करी दिता। ");
INSERT INTO bht_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ताकि जड़ा बचन यशायाह परमेश्वरे दा संदेश देणेबाले बोलया था, सै पूरा हो: उनी अपु साड़ियां कमजोरियां लेई लियां, कने साड़ियां बिमारियाँ जो हटाई दिता। ");
INSERT INTO bht_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","यीशुऐ जालू अपणे चारो पासे मती भरी भीड़ दिखीकरी, यीशुऐ अपणे चेलयां जो बोलया, तां “ओआ असां गलील झीला दे पारले पासे चलदे।” ");
INSERT INTO bht_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","कने जियां ही सै जाणे जो तैयार होऐ, तां इकी व्यवस्था जो सिखाणे बाले उस बखे आई करी बोलया, “गुरू जी, मैं तुहाड़ा चेला बणने तांई जिथू कुथी तू जांगा, मैं भी तेरे पिच्छे-पिच्छे चली पोंणा है।” ");
INSERT INTO bht_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","यीशुऐ उसयो बोलया, “लोमड़ियां जो रेहणे तांई कुडी न, कने अम्बरे दे पंछियां दे आले होंदे न; पर मिंजो, माणुऐ दे पुत्रे बाल इक भी घर नही है, जिथू मैं सोई सकें।” ");
INSERT INTO bht_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","इक होर चेले उसने बोलया, “प्रभु जी, मिंजो पेहले घर बापस जाणा दे। मेरे पिता दे मरणे बाद, मैं उसयो दफनाणा, कने तां फिरी मैं आई करी तेरा चेला बणगा।” ");
INSERT INTO bht_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","यीशुऐ उसयो बोलया, “मेरा चेला बणने तांई मेरे पिच्छे आई जा; कने जड़े लोक आत्मिक रुपे ने मरयो न, उना जो मुर्दयां जो दफनाणा दे।” ");
INSERT INTO bht_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","जालू सै किस्तिया पर चढ़या, तां उदे चेले उदे पिच्छे चली आऐ। ");
INSERT INTO bht_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","कने इकदम झीला च तूफान चलणा लग्गी पिया कने किस्ति लैहरां ने डूबणा लगी पेई, कने यीशु सुतया था। ");
INSERT INTO bht_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","तालू चेलयां बखे आई करी उसयो जगाया, कने बोलया, “प्रभु जी, सांझो बचाई ले, असां डुबी करी मरणे बाले न।” ");
INSERT INTO bht_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","यीशुऐ उना जो बोलया, “हे अल्पविश्वासियों, कजो डरा दे न?” तालू उनी उठी करी पांणिऐ कने तुफाने जो झिड़कया, कने सब कुछ शान्त होई गिया। ");
INSERT INTO bht_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","कने सै सारे हेरान होए कने बोलणा लग्गे, “कि ऐ कदिया माणु है? ऐथू दीकर कि तूफान कने लैहरां भी इदा हुकम मंदे न।” ");
INSERT INTO bht_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","जालू सै उस पार गदरेनियों जगा च पुज्जे, तां उसयो दो माणु मिल्ले जिना च बुरियां आत्मा थियां, सै कब्रिस्तान ला निकलदे बेले यीशुऐ मिल्ले, सै आत्मा बड़ियाँ खतरनाख थियां, कि कोई भी उस रस्ते ला नी जाई सकदा था। ");
INSERT INTO bht_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","कने दिखा, उना जोरे ने बोलया, “परमेश्वरे दे पुत्र, साड़ा तिजो ने क्या कम्म है? तू क्या बकते ला पेहले ही सांझो दुख देणा आया है?” ");
INSERT INTO bht_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","उना ला थोड़ी दूर इक सूअरां दा झुण्ड चुग्गा दा था। ");
INSERT INTO bht_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","बुरियां आत्मा उसने ऐ बोली करी बिनती किती, अगर तू सांझो कडणा है, तां इना सूअरां बिच भेजी दे। ");
INSERT INTO bht_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","यीशुऐ उना जो बोलया, “जा!” सै निकली करी सुअरां च चली गियां, कने सारे सूअर भेठी ला रीड़की करी पाणिऐ च जाई पे कने डूबी करी मरी गे। ");
INSERT INTO bht_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","उना दे रखबाले नठी करी शेहर च ऐ खबर सुणाई, कने जीना च बुरियां आत्मा थियां उना दे बारे च भी दसया। ");
INSERT INTO bht_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","तालू जड़े लोक दिखणा आयो थे, सै यीशुऐ ने बिनती करिके बोलणा लग्गे, कि साड़े इलाके ला चली जा। ");
INSERT INTO bht_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","फिरी सै किस्तिया पर चढ़ी करी पारले पासे गिया, कने अपणे शेहर कफरनहूम जो आया। ");
INSERT INTO bht_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","कने कुछ लोक इकी धरंगे दे मरीजे जो मंझे पर रखीकरी उस दे बाल लेई आये। यीशुऐ उना दा भरोसा दिखीकरी, उस लकवे दे मरिजे ने बोलया, “हे पुत्र, हौंसला रख; तेरे पाप माफ होइ गे।” ");
INSERT INTO bht_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","कने, इसा गल्ला पर केई व्यवस्था जो सिखाणे बालयां ऐ सोचया, कि ऐ तां परमेश्वरे दी निंदा करा दा है। ");
INSERT INTO bht_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","यीशुऐ उना दे मने दी गल्ल जाणी करी बोलया, “तुसां अपणे-अपणे मने च बुरा बिचार कजो करा दे न?” ");
INSERT INTO bht_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","असान क्या है, ऐ बोलणा कि, तेरे पाप माफ होये, या ऐ बोलणा कि उठ कने चल फिर। ");
INSERT INTO bht_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","पर इस तांई कि तुसां जाणी सकन कि मिंजो माणुऐ दे पुत्रे जो धरतिया पर पाप माफ करणे दा हक है। तालू उनी धरंगे दे मरीजे जो बोलया: उठ, कने अपणे मंझे जो चुक, कने अपणे घरे जो चली जा। ");
INSERT INTO bht_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","कने सै उठी करी अपणे घरे जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","लोक ऐ दिखीकरी हेरान होई गे कने परमेश्वरे दी महिमा करणा लग्गे, जिनी आदमियां जो ऐदिया हक दितया है। ");
INSERT INTO bht_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ओथु ला अग्गे जाई करी यीशुऐ मत्ती नाऐ दे इक माणुऐ जो कर लेणे दिया चौकिया पर बैठयो दिखया, कने उसयो बोलया, “मेरे चेले बणा।” सै उठी करी उस दे पिच्छे चली पिया। ");
INSERT INTO bht_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","कने जालू यीशु घरे रोटियां खांणा बैठा, तां मते चुंगी लेणेबाले कने पापी आई करी उस दे चेलयां सोगी रोटी खांणा बैठे। ");
INSERT INTO bht_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ऐ दिखीकरी फरीसियां उदे चेलयां ने बोलया, “तुहाड़ा गुरू चुंगी लेंणे बाले कने पापियां सोगी कजो खांदा है?” ");
INSERT INTO bht_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","जालू यीशुऐ ऐ सुणया तां उना जो बोलया, “जड़े लोक खरे न उना जो वैद्ये दी जरूरत नी होंदी है, पर जड़े बिमार न उना जो है। ");
INSERT INTO bht_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","इस तांई तुसां जाई करी इदा मतलब सीखी लिया, कि मैं बलिदान नी पर दया चांदा है; क्योंकि मैं धर्मियां जो नी पर पापियां जो सदणा आया है।” ");
INSERT INTO bht_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","तालू यूहन्ना दे चेलयां उस बाल आई करी बोलया, “क्या बजा है कि असां कने फरीसी बरत रखदे न, पर तेरे चेले तां बरत नी रखदे?” ");
INSERT INTO bht_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","यीशुऐ उना ने बोलया, “क्या बराती, जालू दीकर लाड़ा उना सोगी है, दुखी होई सकदे न? पर सै दिन ओणे न जालू लाड़े उना ला बख कितया जाणा, उस बेले उना बरत रखणा। ");
INSERT INTO bht_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","लोक नोऐ कपड़े दा रफु पराणे कपड़यां च कोई नी लांदा है, नी तां उनी रफुये धोणे ने सुकड़ी जाणा, कने पुराणा कपड़ा होर जादा फटी जाणा। ");
INSERT INTO bht_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","नोऐ अंगूरा दे रसे जो परांणिया खलड़िया च कोई नी भरदा है नी तां नोआ अंगूर रस खलड़िया जो फाड़ी दिन्दा है, कने अंगूरा दा रस निकली जांदा ऐ, तांई तां नोआ अंगूर रस नोईयां खलड़िया च भरदे न।” ");
INSERT INTO bht_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","सै उना ने ऐ गल्लां बोला दा ही था, इकी यहूदी जंज घर दे सरदारे आई करी उसयो नमस्ते किते कने बोलया, “मेरी कुड़ी हुणी मरी है, पर ओथु आई करी उसा पर हथ रख, तां उना जिंदिया होई जाणा।” ");
INSERT INTO bht_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","यीशु उठी करी अपणे चेलयां समेत उदे पिच्छे चली पिया। ");
INSERT INTO bht_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","कने इक जनानी थी जिसा जो बाहरां सालां ला खून निकलने दी बिमारी थी, उना पिच्छे ला आई करी यीशुऐ दे कपड़यां जो छुई लिया। ");
INSERT INTO bht_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","क्योंकि सै अपणे मने च बोला दी थी कि, अगर मैं उस दे कपड़े जो छुई लेंगी तां मैं ठीक होई जांणा। ");
INSERT INTO bht_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","यीशुऐ फिरी करी उसा जो दिखया कने बोलया, “पुत्री हौंसला रख; तेरा भरोसा जड़ा मिजों पर था उनी भरोसे तिजो खरा कितया है।” कने सै जनानी उसी बेले ठीक होई गेई। ");
INSERT INTO bht_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","यीशु जालू उस सरदारे दे घरे पुज्जा, कने बंसरी बजाणे बाले कने भिड़ा जो रोंदे दिखया, ");
INSERT INTO bht_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","तालू बोलया, “हटी जा, कुड़ी मरियो नी है, पर सुतियो है”, इसा गल्ला पर सारे हंसणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","पर जालू भीड़ कडी दिती, तां उनी अंदर जाई करी कुड़िया दा हथ पकड़या, कने सै जिन्दी होई पेई। ");
INSERT INTO bht_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","कने इसा गल्ला दी चर्चा सारे देशे च फेली गेई। ");
INSERT INTO bht_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","जालू यीशु ओथु ला थोड़ा अग्गे गिया, तां दो अन्ने उदे पिच्छे ऐ बोलदे आये, कि हे दाऊदे दे बंशज, सांझो पर दया कर। ");
INSERT INTO bht_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","जालू सै घरे च पुज्जा, तां सै अन्ने उस बाल आये, कने यीशुऐ उना जो बोलया, “क्या तुहांजो भरोसा है कि मैं ऐ करी सकदा है?” उना उसने बोलया, “हां प्रभु।” ");
INSERT INTO bht_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तालू यीशुऐ उना दियां हखी जो छुई करी बोलया, “तुहाड़े भरोसे दे अनुसार तुहाड़े तांई होई जा।” ");
INSERT INTO bht_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","कने उना जो मिलणा लग्गी पिया, कने यीशुऐ उना जो समझाई करी बोलया, “ध्यान रे, तुसां कुस्यो भी मत दसदे, कि मैं तुहाड़े तांई क्या कितया है।” ");
INSERT INTO bht_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","पर उना निकली करी सारे देशे च उदी खबर फैलाई दिता। ");
INSERT INTO bht_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","जालू सै दो अन्ने माणु बाहर जा दे थे, तां कुछ लोक इकी माणुये जो यीशुऐ बाल लेई आये कने सै बोली नी सकदा था, क्योंकि उदे च बुरी आत्मा थी। ");
INSERT INTO bht_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","जालू यीशुऐ बुरिया आत्मा जो उस माणुये ला कडी दिता, तां सै बोलणा लग्गी पिया। कने भीड़ हेरान होई गेई कने बोलणा लग्गी, कि इस्राएल देशे च ऐसा कदी नी दिखया। ");
INSERT INTO bht_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","पर फरीसियां बोलया, बुरियां आत्मा दा सरदार उसयो शक्ति दिन्दा है कने बुरियां आत्मा जो कडदा है। ");
INSERT INTO bht_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","यीशु कने उदे चेले गलील प्रदेश दे केई शेहरां कने ग्रां चे होईकरी गे, कने यीशु यहूदी जंज घरां च उपदेश दिन्दा, कने परमेश्वरे दे राज्य दा शुभसमाचार प्रचार करदा, कने हर तरा दियां बिमारियाँ कने कमजोरियां जो ठीक करदा गिया। ");
INSERT INTO bht_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","यीशु किस्तिया ला उतरया कने उनी मती भरी भीड़ दिखी, कने उसयो उना पर तरस आया, क्योंकि उना दा कोई अगुवा नी था जड़ा उना दी रखबाली करी सके, जियां भेडां बिना ग्वाले होंदियां न, सै बेचेन कने भटकयो होयो थे। ");
INSERT INTO bht_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","तालू उनी अपणे चेलयां ने बोलया, “जियां खेतरां च मती फसल होंदी है, तियां ही मते भरी लोक न जड़े परमेश्वरे दा संदेश सुणने तांई तैयार न, पर परमेश्वरे दे राज्य दे बारे च दसणे तांई लोक घट न। ");
INSERT INTO bht_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","इस तांई फसला दे मालिके ने प्राथना करा कि सै फसला तांई होर मजदूर भेजे।” ");
INSERT INTO bht_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","फिरी उनी अपणे बाहरां चेलयां जो अपणे बाल सदया, कने उना जो बुरियां आत्मा पर हक दिता, कि उना जो कडन कने हर तरा दियां बिमारियाँ कने, हर तरा दियां कमजोरियां जो दूर करन। ");
INSERT INTO bht_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","इना बाहरां प्रेरितां दे ना ऐ न: पेहला शमौन, जिसयो पतरस बोलदे न, कने उदा भाई अन्द्रियास; जब्दी दा पुत्र याकूब, कने उदा भाई यूहन्ना; ");
INSERT INTO bht_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिप्पुस कने बरतुल्मै, थोमा, कने चुंगी लेंणे बाला मत्ती, हलफई दा पुत्र याकूब कने तद्दै। ");
INSERT INTO bht_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","शमौन कनानी, कने यहूदा इस्करियोती, जिनी यीशुऐ जो पकड़ाई भी दिता। ");
INSERT INTO bht_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","इना बाहरां चेलयां जो यीशुऐ ऐ हुकम देईकरी भेजया, “कि होर जातियां बाल मत जांदे, कने सामरियां दे कुसी भी शेहरे दे अंदर मत जांदे। ");
INSERT INTO bht_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","इस्राएले दे लोकां बाल जा, जड़े परमेश्वरे ला दूर होई गियो न, जियां भेडां गवाची करी अपणे रखबाले ला दूर चली जांदियां न। ");
INSERT INTO bht_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","कने चलदे-चलदे ऐ प्रचार करा कि, स्वर्गे दा राज्य नेड़े आई रिया है। ");
INSERT INTO bht_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","बिमारां जो ठीक करा: मरयां जो जिन्दा करा, कने कोढ़ियां जो शुद्ध करा: बुरियां आत्मा जो निकाला: तुसां लोकां दी मदद करणे दा कुछ भी मत लेंदे, क्योंकि परमेश्वर भी तुहाड़ी मदद करणे दा कुछ नी लेंदा है। ");
INSERT INTO bht_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","कने अपणे थेलयाँ च सोना, चांदी, कने तांबे दे सिक्के मत गठेरदे। ");
INSERT INTO bht_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","रस्ते तांई ना कोई थेली रखा, ना दो कुरते, ना जुते, ना सोठी लेंणी, क्योंकि मजदूरे जो खाणा कने रेणे दी जगा मिलणी चाईदी। ");
INSERT INTO bht_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","जिस कुसी शेहरे या ग्रांऐ जांगे तां ओथु पता करा कि कुण काबील माणु है कने जालू दीकर ग्रांऐ ला नी निकलगे, तालू दीकर उदे घरे ही रिया। ");
INSERT INTO bht_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","घरे अंदर जांदे बेले उस घरे जो आशीष दिनयो। ");
INSERT INTO bht_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","अगर उस घरे दे लोक काबील होंगे, तां तुहाड़ी शांति उना बाल पूजणी, पर अगर सै तुहाड़ा स्वागत नी करगे तां तुहाड़ी शांति तुहाड़े बाल बापस आई जांणी। ");
INSERT INTO bht_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","जिसा जगा दे लोक तुहांजो अपनांगे नी कने तुहाड़े उपदेश नी सुणगे, ओथु ला जांदे बेले अपणे पैरां दी धुड़ जाड़ी दिनयो, इयां करणे ने तुसां उना जो चेताबनी दिन्दे न कि, परमेश्वरे तुसां जो सजा देणी क्योंकि तुसां उपदेश नी मनया। ");
INSERT INTO bht_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","मैं तुसां ने सच्च बोलदा है, कि न्याय बाले रोजे सै शेहरे जिथू दे लोक परमेश्वर दा बचन नी मंदे, उना दी हालत सदोम कने अमोरा शेहरां दे लोकां दी हालत ला भी जादा भयानक होणी है।” ");
INSERT INTO bht_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","दिखा, मैं तुहांजो भेडां सांई भेड़ियां बिच भेजदा है। तुसां सप्पां सांई चलाक बणा, कने कबुतरां सांई भोले बणा। ");
INSERT INTO bht_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“पर तुसां लोकां ला हमेशा चौकने रेणा। क्योंकि लोकां तुहांजो कैदी बणाना कने यहूदी जंज घरे च पेश करणा कने तुहांजो कोड़े मारणे, कने मेरिया बजा ने तुहांजो हाकिमा कने राजयां दे सामणे न्याय तांई महासभा च पेश करणा। ");
INSERT INTO bht_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","तुसां मेरे तांई हाकिमा कने राजयां दे सामणे उना पर, कने होर जातियां पर गबाह बणने तांई पेश किते जाणे न। ");
INSERT INTO bht_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","जालू सै तुहांजो पकड़ागें तां चिंता मत करदे, कि असां कियां; कने क्या बोलणा है: क्योंकि जड़ा कुछ तुसां बोलणा है सै तुहांजो उसी बेले पता लग्गी जाणा। ");
INSERT INTO bht_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","क्योंकि बोलणे बाले तुसां नी न, पर तुहाड़े पिता परमेश्वरे दी पबित्र आत्मा तुसां च बोलदी है। ");
INSERT INTO bht_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","उसी बेले, जड़े लोक मिजों पर भरोसा नी करदे न, उना अपणे भाईयां जो अधिकारियां दे हथे मारणे तांई देई देणा, क्योंकि सै मिंजो पर भरोसा करदे न। पिता अपणे बचयां सोगी इयां ही करणा है कने बचयां माता-पिता दे खिलाफ होईकरी उना जो मारी देणा है। ");
INSERT INTO bht_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","क्योंकि तुसां मेरे चेले न उदिया बजा ने सारे लोकां तुसां ने बैर करणा है, पर जड़ा आखरी दीकर सबर रखगा उदा ही उद्धार होणा। ");
INSERT INTO bht_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","जालू सै तुहांजो इकी शेहरे च तंग करगे, तां तुसां दुऐ शेहरे जो चली जानयो। मैं तुसां ने सच्च बोलदा है, तुहाड़ी इस्राएले देशे दे इकी शेहरे ला दुज्जे शेहरे दी यात्रा पूरी भी नी होणी है, कने मैं, माणुऐ दे पुत्रे आई जाणा है। ");
INSERT INTO bht_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","चेला अपणे गुरुऐ ला, कने नौकर अपणे मालिके ला बडा नी होंदा है। ");
INSERT INTO bht_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","काफी है कि चेले दा गुरुऐ दे बराबर, कने नौकरे दा मालिके दे बराबर होणा; अगर सै मिंजो घरे दे मालिके जो शैतान बोलदे न, तां उना मेरे घरे दे लोकां जो कितणे बुरे ना ने बोलणा है। ");
INSERT INTO bht_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","पर उना लोकां ला मत डरदे जड़े तुसां जो धमकांदे न, क्योंकि सै बकत ओणे बाला है जालू जड़ा कुछ भी ढक्या है, सै खोलया जाणा है; कने सै सारा कुछ जड़ा छुपया है, सै लोकां दे सामणे ओणा है। ");
INSERT INTO bht_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","जड़ा कुछ मैं तुसां ने नेहरे च बोलदा है, उसयो चेले सारे सामणे बिना कुसी डरे दे बोली सकदे न, कने जड़ा तुसां बल्ले-बल्ले सुणदे न, उसयो छती पर चढ़ी करी प्रचार करा। ");
INSERT INTO bht_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","सै जड़े शरीरे जो मारी सकदे न, पर सै आत्मा जो नी मारी सकदे न, उना ला डरदे मत, पर परमेश्वर ला डरा, जड़ा आत्मा कने शरीर दोनो जो नरके च मारी सकदा है। ");
INSERT INTO bht_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","क्या बड़ी घट कीमता च दो चिड़ियाँ नी बिकदियां? तमी तुहाड़े पिता परमेश्वरे दिया मरजिया बिना उना चे इक भी मरी करी धरतिया पर नी पेई सकदी। ");
INSERT INTO bht_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","परमेश्वर तुहाड़ी जिन्दगिया दी हर गल्ला दी परवाह करदा है। सै ऐ भी जाणदा है कि तुहाड़े सिरे पर कितणे बाल न। ");
INSERT INTO bht_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","इस तांई डरा मत, क्योंकि तुसां चिड़ियाँ ला भी जादा किमती न। ");
INSERT INTO bht_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","जड़ा कोई लोकां दे सामणे मिंजो परमेश्वर मन्नी लेंगा, उसयो मैं भी अपणे स्वर्गीय पिता दे सामणे अपणे चेले मन्नी लेंगा। ");
INSERT INTO bht_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","पर अगर सै दूजयां दे सामणे ऐ बोलणे ला डरदे न, कि असां यीशुऐ दे चेले न, तां मैं अपणे पिता परमेश्वरे जो जड़ा स्वर्गे च, दसी देणा कि, सै मेरे चेले न। ");
INSERT INTO bht_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ऐ मत सोचा कि मैं धरतिया पर लोकां बिच शांती लोणे तांई आया है; मैं तां लोकां च लड़ाई करवाणा आया है।” ");
INSERT INTO bht_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","मैं तां इस तांई आया है, ताकि माणुऐ जो उस दे पिता परमेश्वरे ला, कने कुड़िया जो उसा दिया माता ला, कने नुंआ जो उसा दिया ससु दे खिलाफ भड़काणा है। ");
INSERT INTO bht_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","माणुऐ दे दुश्मन उस दे घरे दे ही लोक होणे न। ");
INSERT INTO bht_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","जड़ा अपणे माता पिता जो मिंजो ला जादा प्यार करदा है, सै मेरा चेला बणने दे लायक नी है, कने जड़ा कुड़िया या जागते जो मिंजो ला जादा प्यारा करदा है, सै भी मेरा चेला बणने लायक नी। ");
INSERT INTO bht_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","जड़ा मेरिया बजा ने दुख सेहन कने मरणे तांई तैयार नी है, सै मेरा चेला बणने दे लायक नी है। ");
INSERT INTO bht_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","कोई माणु ऐसा नी करगा कने अपणे प्राणा जो बचाणा चांहगा, उनी परमेश्वरे सोगी आत्मिक जिन्दगी जिणे दा मोका गबाई देणा है। पर जड़ा माणु मिजों पर भरोसा करगा कने मेरे शुभसमाचार दिया बजा ने मरगा उस माणुऐ जो परमेश्वरे सोगी सदा तांई दी जिन्दगी मिलणी। ");
INSERT INTO bht_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","जड़ा तुहांजो अपनांदा है, सै मिंजो भी अपनांदा है; कने जड़ा मिंजो अपनांदा है, सै मेरे भेजणे बालयां जो अपनांदा है। ");
INSERT INTO bht_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जड़ा परमेश्वरे दा संदेश देणेबालयां जो परमेश्वरे दा संदेश देणेबाला समझीकरी अपनाऐ, उसयो परमेश्वरे दा संदेश देणेबालयां सांई इनाम मिलणा; कने जड़ा धर्मी माणुऐ जो धर्मी माणु समझीकरी अपनाऐ, उसयो धर्मिये सांई इनाम मिलणा है। ");
INSERT INTO bht_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","जड़ा कोई इना लोकयां चे इकी जो भी मेरा चेला समझीकरी सिर्फ इक कटोरा ठंडे पांणिऐ दा पिया, उसयो पक्का ही इनाम मिलणा है। ");
INSERT INTO bht_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","जालू यीशु अपणे बाहरां चेलयां जो हुकम देई बेठा, तां सै उना दे गलील जिले दे नगरां च उपदेश कने प्रचार करणे तांई ओथु ला चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","यूहन्ने जेला च मसीह दे कम्मा दी खबर सुणीकरी, अपणे चेलयां जो उसला ऐ पूछणे जो भेजया। ");
INSERT INTO bht_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“क्या तू ही मसीह है जिसयो भेजणे दा बायदा परमेश्वरे कितया था, या असां कुसी दुजे दी नियाल रखन?” ");
INSERT INTO bht_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","यीशुऐ जबाब दिता, “जड़ा कुछ तुसां दिखदे कने सुणदे न, सै सारा कुछ जाई करी यूहन्ना ने बोली दिया। ");
INSERT INTO bht_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","कि अन्नयां जो मिलदा है, कने लंगड़े चलदे न, कोढ़ियां दा कोढ़ ठीक होआ दा, कने टोंणे सुणदे न, मुर्दे जिंदे किते जांदे न, कने गरीबां जो शुभसमाचार सुणाया जांदा है। ");
INSERT INTO bht_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","कने धन्य न सै, जड़े मिंजो पर शक नी करदे।” ");
INSERT INTO bht_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","यूहन्ना दे चेले जालू ओथु ला चली गे, तां यीशु यूहन्ना दे बारे च लोकां जो बोलणा लग्गा, “तुसां सुनसान जगा च क्या दिखणा गियो थे? क्या होआ ने हिलदे होऐ सरकंडे जो? इदा मतलब ऐ है कि जड़ा बड़ी असानी ने अपणे बिचार बदली दे, सै ऐसा माणु है जड़ा डरदा है कि दुज्जे लोक उदे बारे च क्या सोचगे कने बोलगे। ");
INSERT INTO bht_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","तां फिरी तुसां क्या दिखणा गियो थे? क्या इक माणुये जो जिनी बड़े मेंहगे कपड़े पायो थे? दिखा जड़े लोक मेंगे कपड़े पांदे न सै मेहलां च रेंदे न। ");
INSERT INTO bht_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","तां फिरी कजो गियो थे? कि क्या कुसी परमेश्वरे दा संदेश देणेबाले जो दिखणे तांई? हाँ, मैं तुसां ने बोलदा है, कि परमेश्वरे ला भी बड्डे जो? ");
INSERT INTO bht_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","यूहन्ना सेई माणु है जिदे बारे च पबित्र शास्त्र च दसया, कि दिख, मैं अपणे संदेश देणेबाले दूते जो तेरे अग्गे भेजदा है, जिनी तेरे ओंणे तांई लोकां जो तैयार करणा है। ");
INSERT INTO bht_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","मैं तुसां ने सच्च बोलदा है, कि जड़े लोक जनानिया ला पैदा होयो न, उना चे यूहन्ना बपतिस्मा देणेबाले ला बडा कोई नी होया; पर स्वर्गे दे राज्य च जड़ा सारयां ला छोटा है, सै उसला बडा है। ");
INSERT INTO bht_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","जालू ला यूहन्ना बपतिस्मा देणेबाले प्रचार करणा शुरू कितया है, उस बकते ला लेईकरी हुणे दीकर स्वर्गे दा राज्य जबरदस्ती ने अग्गे बदा दा है, कने हिंसक लोक उस हमला करा दे न। ");
INSERT INTO bht_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","क्योंकि सारे परमेश्वरे दा संदेश देणेबालयां दियां कताबां च कने मूसा दिया व्यवस्था च यूहन्ना बपतिस्मा देणेबाले दे ओणे दीकर परमेश्वर दे राज्य दे बारे च लिखया है। ");
INSERT INTO bht_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","कने तुसां मेरी गल्ल मनणा चांदे न, कि एलिय्याह जिदे ओणे दी भविष्यवाणी कितियो थी, सै एलिय्याह ही है। ");
INSERT INTO bht_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","जिस बाल सुणने दा मन हो, सै ध्यान देईकरी इना गल्लां जो सुणे, कने समझी ले।” ");
INSERT INTO bht_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","मैं इस युगे दे लोकां दी तुलना कुसने दें? सै उना जागतां सांई न, जड़े बजारां च बेईकरी इकी दुजे जो पुकारी करी बोलदे न। ");
INSERT INTO bht_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“कि असां तुहाड़े तांई खुशिया दे गाणे गाऐ, कने तुसां नचे नी; असां शोक दे गीत भी गाऐ, फिरी भी तुसां रोए नी।” ");
INSERT INTO bht_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","क्योंकि यूहन्ना बार-बार बरत रखदा कने ना शराब पिन्दा था, कने सै बोलदे न कि उदे च बुरी आत्मा है। ");
INSERT INTO bht_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","पर मैं माणुऐ दा पुत्र खांदा पिंदा है, कने सै बोलदे न, “कि पेटू कने शराबी माणु है, कने चुंगी लेंणे बाले कने पापियां दा मित्र है। पर इक माणुऐ दे कम्मा ऐ साबित करणा कि अकला बाला कुण है।” ");
INSERT INTO bht_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","तालू यीशुऐ उना शेहरां च रेणेबाले लोकां जो फटकार लगाई, जिथू उनी बड़े भरी चमत्कार दे कम्म कितयो थे; क्योंकि उना अपणे पापां दा पश्चाताप नी कितया था। ");
INSERT INTO bht_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","हाय, खुराजीन शेहर दे कने बैतसैदा शेहर दे लोको! जड़े चमत्कारी कम्म तुहाड़े शेहर च कितयो न, अगर सै कम्म सूर कने सैदा च कितयो होंदे, तां ओथु दे लोक बड़े पेहले टाट ओढ़ी लेंदे, कने धुड़ अपणे उपर छिड़की लेंदे ऐ दसणे तांई कि उना अपणे पापां ला पश्चाताप करी लिया है। ");
INSERT INTO bht_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","पर मैं तुसां ने बोलदा है; कि न्याय दे रोज जड़ी सजा सूर कने सैदा जो देणी है, सै सजा तुहाड़िया सजा ला बड़ी घट होणी है। ");
INSERT INTO bht_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","हे कफरनहूम शेहरे दे लोको, तुसां क्या स्वर्गे दीकर उच्चे करणे न? तुसां तां पताले दीकर थले करणे न; जड़े अनोखे कम्म तुहाड़े च कितयो न, अगर सै सदोम शेहर च होंदे, तां उनी अजे दीकर बणी रेणा था। ");
INSERT INTO bht_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","पर मैं तुसां ने बोलदा है; कि न्याय दे रोज जड़ी सजा सदोम शेहरे दे लोकां जो देणी है, सै सजा तुहाड़िया सजा ला बड़ी घट होंणी है। ");
INSERT INTO bht_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","तिस्सी बेले यीशुऐ बोलया, “हे पिता, स्वर्गे कने धरतिया दे प्रभु, मैं तेरा धन्याबाद करदा है, तू इना गल्लां जो ज्ञानियां कने समझदारां लोकां ला लुकाई रखया, कने लोक बचयां सांई न उना पर प्रगट किता है। ");
INSERT INTO bht_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हाँ, पिता जी, क्योंकि तिजो ऐ ही ठीक लग्गा।” ");
INSERT INTO bht_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","मेरे पिते मिंजो सब कुछ दितया है, कने पिता दे बिना कोई पुत्रे जो नी जांणदा है, कने ना ही कोई पिता जो जाणदा है सिर्फ पुत्र ही है जड़ा पिता जो जाणदा है। कने जिना लोकां जो पुत्र चुणदा है उना लोकां ही पिता जो जाणना है। ");
INSERT INTO bht_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“सारे मेहनत करणे बालयो कने भोझ हेठ दबूयो लोको, मेरे बाल ओआ; मैं तुहांजो अराम देणा। ");
INSERT INTO bht_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","मेरा जुआ अपणे उपर चुकी लिया; कने मिंजो ला सिखा; क्योंकि मैं मने ला नरम कने दयालु है; कने तुसां जो अपणे मने च अराम मिलणा। ");
INSERT INTO bht_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","क्योंकि जड़ा करणे दा हुकम मैं तुहांजो दिन्दा है, सै करणा मुशकिल नी है।” ");
INSERT INTO bht_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","उस बेले यीशु सब्ते दे रोजे खेतरां चे होईकरी चलया था, कने उस दे चेलयां जो भूख लग्गी, कने सै बेलां तोड़ी-तोड़ी करी खाणां लग्गी पे। ");
INSERT INTO bht_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","फरीसियां ऐ दिखीकरी उसयो बोलया, “दिख, तेरे चेले सै कम्म करा दे न, जड़ा सब्ते दे रोज करणा ठीक नी।” ");
INSERT INTO bht_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","यीशुऐ उना जो बोलया, “क्या तुसां परमेश्वरे दे बचन च कदी नी पढ़या, कि राजा दाऊदे तालू क्या किता, जालू उसयो कने उस दे मित्रां जो भूख लग्गी थी? ");
INSERT INTO bht_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","सै कियां परमेश्वरे दे घरे च गिया, कने परमेश्वर जो चढ़ाईयां रोटियां खादियां, जिना जो खाणां ना उस तांई कने ना उदे मित्रां तांई व्यवस्था दे अनुसार ठीक था, पर सिर्फ याजकां तांई ठीक था? ");
INSERT INTO bht_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","या क्या तुसां मूसा दी व्यवस्था च नी पड़या है, कि याजक सब्ते दे रोज मंदरे च सब्ते दे रोजे दिया विधिया जो तोड़ने पर भी निर्दोष होंदे न?” ");
INSERT INTO bht_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","पर मैं तुसां जो बोलदा है, इदा मतलब है, कि मैं तुहाड़े बाल आया है कने मैं मंदरे ला भी जादा बहुमूल्य है। ");
INSERT INTO bht_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","अगर तुसां जाणदे न कि पबित्र शास्त्र च इना अखरां दा मतलब क्या है, मेरे तांई बलियां चढ़ाणे दी बजाऐ, तुसां दुजयां तांई दयालु बणा कने मेरे इना निर्दोष चेलयां दी निंदा नी करदे। ");
INSERT INTO bht_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","“मैं माणुऐ दा पुत्र ऐ बोलणे दा हक रखदा है, कि लोकां जो सब्ते बाले रोजे जो क्या करणे दी अनुमति है।” ");
INSERT INTO bht_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ओथु ला चलीकरी करी सै यहूदी जंज घर च आया। ");
INSERT INTO bht_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ओथु इक माणु था जिदा इक हथ सुक्की कने बेकार होई गिया था, कने फरीसियां यीशुऐ पर दोष लांणे तांई उसला पुछया, कि क्या सब्ते दे रोज चंगा करणा ठीक गल्ल है? ");
INSERT INTO bht_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","यीशुऐ उना जो बोलया, “मन्नी लिया कि तुसां चे कुसकी दी इक ही भेड़ है। कने सै सब्ते दे रोजे खड्डे च पेई जा, कने सै उसा जो पकड़ी करी खड्डे ला नी कडे? ");
INSERT INTO bht_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","भला, माणुऐ दी कीमत भेडां ला कितणी जादा बदीकरी है। इस तांई सब्ते दे रोजे लोकां जो खरा करणा ठीक गल्ल।” ");
INSERT INTO bht_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","कने यीशुऐ उस माणुऐ जो बोलया, “अपणा हथ कर रुआं।” उनी अपणा हथ किता, कने उदा हथ दुऐ हथे सांई ठीक होई गिया। ");
INSERT INTO bht_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","तालू फरीसी झट बाहर आई करी कुछ लोकां कने मिलिकरी यीशुऐ दे खिलाफ सलाह करणा लग्गे, कि उसयो कियां मारणा है। ");
INSERT INTO bht_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ऐ जांणी करी यीशु ओथु ला चली गिया। कने मते सारे लोक उदे पिच्छे चली पै, कने उनी सारयां जो ठीक किता। ");
INSERT INTO bht_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","कने यीशुऐ चेतावनी देईकरी उना जो हुकम दिता, “कि मेरे बारे च कुसी ने भी मत दसदे कि मैं परमेश्वर दा पुत्र है।”। ");
INSERT INTO bht_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ताकि जड़ा बचन यशायाह परमेश्वरे दा संदेश देणेबाले बोलया था सै पूरा हो: ");
INSERT INTO bht_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“दिखा, ऐ मेरा सेवक है, जिसयो मैं चूंणया है, मेरा प्यारा, जिसते मेरा मन खुश है, मैं अपणी आत्मा उस पर पांणी है, कने उनी होरनी जातियां जो न्याय दा संदेश देणा। ");
INSERT INTO bht_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ना उनी कोई लड़ाई करणी, कने ना उनी कोई हल्ला पाणा, कने ना ही सै लोकां बिच घमंडी सांई जोरे ने कोई भाषण नी देणा। ");
INSERT INTO bht_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","उनी कुसदा भी नुकसान नी करणा जड़ा भजयो टुटयो सरकंडे सांई कमजोर न, कने जिसयो भी कोई समस्या है सै सुलगती बतिया सांई न, उनी इसा जो कोई नुकसान नी करणा, पर उनी पक्का करणा कि न्याय किता जाऐ। ");
INSERT INTO bht_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","कने होरनी जातियां उदे नाऐ पर आस रखणी है।” ");
INSERT INTO bht_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","तालू लोक इक अन्ने कने गूंगे जो जिदे च बुरी आत्मा थी, उसयो उदे बाल लेई आये, कने उनी उसयो ठीक किता कने सै गूंगा बोलणा कने उसयो मिलणा लगी पिया। ");
INSERT INTO bht_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","इसा गल्ला पर सारे लोक हेरान होए, कने बोलणा लग्गे, “क्या ऐ माणु मसीहा होई सकदा है, जड़ा राजा दाऊदे दे बंशे ला है, जिसयो असां नियाला दे न।” ");
INSERT INTO bht_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","पर फरीसियां ऐ गल्ल सुणीकरी बोलया, ऐ तां बुरियां आत्मा दे सरदार शैताने दिया सहायता लेईकरी बुरियां आत्मा जो कडदा है। ");
INSERT INTO bht_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","उनी उना दे मने दी गल्ल सुणीकरी उना ने बोलया, “अगर कुसी राज्य च लोक अपु च ही लड़दे रेंगे तां सै राज्य बड़े बकते तक नी टिकी सकदा है। कने अगर कुसी घरे दे माणु अपु च ही लड़ी पोंगे तां सै घर नी बणी सकदा।” ");
INSERT INTO bht_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","अगर शैतान ही शैताने जो कड्डे, तां उनी अपणा ही बैरी होई जाणा, तां उनी अपणा ही नाश करी लेणा है, तां फिरी उस दा राज्य कियां बदी सकदा है, ");
INSERT INTO bht_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","अगर मैं शैताने दिया मददा ने बुरियां आत्मा जो कडदा है, तां तुहाड़े चेले कुसदिया मददा ने बुरियाँ आत्मा जो कडदे न? इस तांई उना ही तुहाड़ा न्याय करणा है। ");
INSERT INTO bht_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","पर अगर मैं परमेश्वरे दिया आत्मा दिया सहायता ने बुरियां आत्मा जो कडदा है, तां परमेश्वरे दा राज्य तुहाड़े बाल आई पुज्जा है। ");
INSERT INTO bht_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","जालू दीकर तुसां जोरे बाले माणुऐ जो नी बनगे, तां तुसां उदे घरे च नी बड़ी सकदे कने उदियां चीजां जो नी चोरी सकदे न। ");
INSERT INTO bht_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“जड़ा मेरे सोगी नी है, सै मेरे खिलाफ है, कने जड़ा मेरे सोगी नी बटोलदा है, सै खलारदा है। ");
INSERT INTO bht_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","इस तांई तां मैं तुसां ने बोलदा है, कि माणुऐ दी ओलादी दे सारे पाप कने निंदा जड़ा सै परमेश्वर या कुसी दे खिलाफ करदे न, परमेश्वरे उना दे पाप माफ करी देणे न, पर जड़ा कोई पबित्र आत्मा दे खिलाफ निंदा करगा, तां सै परमेश्वरे कदी भी माफ नी करणा है। ");
INSERT INTO bht_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","पर जड़ा कोई माणुऐ दे पुत्रे दे बारे च कोई बुरी गल्ल बोलगा, उदा ऐ अपराध माफ होई जाणा, पर जड़ा कोई पबित्र आत्मा दे बारे च बुरा बोलगा, उदी ऐ गलती ना तां इस लोक च ना ही ओणे बाले युग च माफ होणी।” ");
INSERT INTO bht_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“अगर रुख खरा है, तां उदे फले जो भी खरा होणा, अगर रुख बेकार है, तां उदे फल भी बेकार होणे न, क्योंकि रुख फले ने ही पछेणया जांदा है।” ");
INSERT INTO bht_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“तुसां जहरीले सपां दे बचयां सांई न, तुसां बुरे होईकरी कियां खरियाँ गल्लां बोली सकदे न? क्योंकि जड़ा मने च भरया है सै ही मुऐ च ओंदा है। ");
INSERT INTO bht_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","इक भला माणु मने दे भले भंडारे ला भलियाँ गल्लां कडदा है, कने इक बुरा माणु मने दे बुरे भंडारे ला बुरियाँ गल्लां कडदा है। ");
INSERT INTO bht_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","कने मैं तुसां ने बोलदा है, कि जड़ियां-जड़ियां बेकार गल्लां माणुऐ बोलणियां न, उना सारियां गल्लां दा लेखा न्याय दे रोजे देणा है। ");
INSERT INTO bht_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","क्योंकि परमेश्वरे न्याय करणा है कने हर इक माणुऐ जो उदियां बोलियां गल्लां दिया बजा ने दोषी या निर्दोषी ठहराया जाणा है।” ");
INSERT INTO bht_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","इसा गल्ला पर मते व्यवस्था जो सिखाणे बालयां कने फरीसियां उसयो बोलया, “गुरू जी, असां तिजो ला इक स्वर्गे दा कोई चमत्कार दिखणा चांदे न, जिसने पता लग्गे कि तिजो परमेश्वरे भेजया है।” ");
INSERT INTO bht_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","पर यीशुऐ उना जो जबाब दिता, तुसां चमत्कार इस तांई मंगदे न क्योंकि तुसां बुरे लोक न कने भरोसा नी करदे न, पर परमेश्वरे दा संदेश देणेबाले योना ने जड़ा होया उस जो छडी करी होर कोई तुसां जो चमत्कार नी मिलणा है। ");
INSERT INTO bht_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","योना तिन्न रात दिन पांणिऐ दे इकी बड़ी बडिया मच्छिया दे पेटे च रिया, तियां ही, मैं माणुऐ दे पुत्रे भी तिन्न रात दिन धरतिया दे अंदर रेणा। ");
INSERT INTO bht_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","नीनवे शेहरे दे लोकां न्याय दे रोजे इस युगे दे लोका सोगी उठी करी उना जो दोषी ठेहराणा, क्योंकि उना योना दा प्रचार सुणीकरी मन बदलया, पर तुसां तां पश्चाताप करणे मना करदे न; कने दिखा, ऐथू तां सै है जड़ा योना ला भी बडा है। ");
INSERT INTO bht_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","दक्षिणे दिया राणिया न्याय दे रोजे इस युगे दे लोकां सोगी उठी करी उना जो दोषी ठेहराणा, क्योंकि सै सुलैमान दा ज्ञान सुणने तांई बड़ी दुरे ला आयियो थी; कने दिखा, ऐथू सै है जड़ा सुलेमाने ला भी बडा है, पर तुसां पश्चाताप करणे मना करदे न। ");
INSERT INTO bht_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“जालू बुरी आत्मा माणुऐ ला निकली जांदी है, तां सै सुकियां जगा च अराम तोपदी फिरदी है, पर उसा जो अराम नी मिलदा है। ");
INSERT INTO bht_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","तां सै अपणे आपे ने बोलदी है, कि जिस माणुऐ ला मैं आई है उसी माणुऐ दे अंदर चली जां कने बापस आई करी उस माणुऐ जो उस खाली घरे सांई पांदी है, जिसयो छेल करी साफ कने सजाया हो।” ");
INSERT INTO bht_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","तालू बुरी आत्मा जाई करी अपणे ला होर बुरियाँ सत्त आत्मा जो अपणे सोगी लेई ओंदी है, कने सै उस माणुऐ दे अंदर जाई करी रेणा लगदी है, कने उस माणुऐ दी हालत पहले ला भी बुरी होई जांदी है। इस युगे दे बुरे लोकां ने भी इयां ही होणा है। ");
INSERT INTO bht_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","जालू सै भिड़ा ने गल्लां करा दा ही था, तां उस दी माता कने भाई बाहर खड़ुतयो थे, कने उसने गल्लां करणा चांदे थे। ");
INSERT INTO bht_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","कुनकी उसने बोलया, “दिख, तेरी माता कने तेरे भाई बाहर खड़ोतयो न, कने तिजो ने गल्लां करणा चांदे न।” ");
INSERT INTO bht_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ऐ सुणीकरी उनी बोलणे बाले जो जबाब दिता, “कुण है मेरी माता? कने कुण न मेरे भाई?” ");
INSERT INTO bht_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","कने अपणे चेलयां पासे हथ करिके बोलया, दिखा, “मेरी मां कने मेरे भाई ऐ न। ");
INSERT INTO bht_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","क्योंकि जड़ा कोई मेरे स्वर्गीय पिता दिया मरजिया पर चले, सै ही मेरा भाई, कने बेहन, कने माता है।” ");
INSERT INTO bht_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","तिस्सी रोजे यीशु घरे ला निकली करी दरियाये दे बखे जाई बैठा। ");
INSERT INTO bht_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","कने उस बाल मती भरी भीड़ गिठी होई गेई, कने सै किस्तिया पर चढ़ी गिया, कने सारी भीड़ दरियाये दे बखे खड़ोई रेई। ");
INSERT INTO bht_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","कने उनी उना ने कहाणियां च मतियां सारियां गल्लां बोलियां, “दिखा, इक बी रांणे बाला बी रांणा निकलया। ");
INSERT INTO bht_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","रांदे बेले थोड़े बी रस्ते दे बखे पेई गे कने सै तां पंछियां आई करी चुगी ले। ");
INSERT INTO bht_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","कने थोड़े बी पथरलिया जमिना पर पे जिथू उसयो जादा मिटी नी मिली, कने जादा मिटी नी होणे दिया बजा ला तौली लूंगी पै। ");
INSERT INTO bht_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","कने जालू खड़ी धुप पेई, तां सै फकुई गे, क्योंकि उना दियां जड़ा डुगियां नी थियां तां सै सुकी गे। ");
INSERT INTO bht_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","कने थोड़े बी झिल्लां च पै, कने जालू झिल्ल बडुऐ तां उना से बी डकी ले। ");
INSERT INTO bht_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","पर थोड़े बी खरिया जमिना पर पे, कने सै बी लुंगे, कने मते सारे फल देणेबाले होए; केईयां सौ गुणा, केईयां सठ गुणा, केईयां ती गुणा।” ");
INSERT INTO bht_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","जिस बाल सुणने तांई कन्न न सै ध्यान लाईकरी गल्ला जो सुणे, कने इसा गल्ला जो समझी ले। ");
INSERT INTO bht_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","कने चेलयां यीशुऐ बखे आई करी पुछया, “तू उना ने कहाणिया च कजो गल्लां करदा है?” ");
INSERT INTO bht_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","उनी जबाब दिता, “तुहांजो स्वर्गे दे राज्य दे भेदां जो समझणे दी समझ दितियो है, पर उना जो नी। ");
INSERT INTO bht_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","जिस कुसी बाल सै समझणे दी इच्छा है, जड़ा परमेश्वर सिखांदा है, उसयो होर देणा, पर जड़ा समझणे दी इच्छा नी रखदा, कि मैं क्या सिखादां, तां सै जड़ा समझया है, परमेश्वरे से भी उसला लेई लेणा।” ");
INSERT INTO bht_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","मैं उना ने कहाणिया च गल्लां इस तांई करदा है, कि सै दिखदे होए भी, नी दिखदे; कने सुणदे होए भी, नी सुणदे न; कने ना समझदे न। ");
INSERT INTO bht_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","कने उना दे बारे च यशायाह दी ऐ भविष्यवाणी पुरी होंदी है: “तुसां कन्ना ला सुणना तां है, पर समझणा नी है; कने हखी ला दिखणा ता है, पर कुछ मिलणा नी है।” ");
INSERT INTO bht_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","“क्योंकि इना लोकां दा मन कठोर होई गिया है, कने सै कन्ना ला उच्चा सुणदे न, कने उना अपणिया हखी बंद करी लियां न; कुथी इयां ना हो कि सै हखी ला दिखन, कने कना ला सुणन कने मने ला समझन, कने अपणे पापां दा पश्चाताप करगे, कने मैं उना जो ठीक करे।” ");
INSERT INTO bht_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“पर धन्य न तुहाड़ियां हखी, क्योंकि सै दिखदियां न; कने तुहाड़े कन्न, कि सै सुणदे न। ");
INSERT INTO bht_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","क्योंकि मैं तुसां ने सच्च बोलदा है, कि मते परमेश्वरे दा संदेश देणेबाले कने धर्मी चांदे थे कि जड़ियां गल्लां तुसां दिखदे न, दिखन, पर दिखियां नी; कने जड़ियां गल्लां तुसां सुणदे न, सुणन, पर सुणियां नी।” ");
INSERT INTO bht_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","हुण तुसां बी राणे बाले दी कहाणिया दा मतलब सुंणा: ");
INSERT INTO bht_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“जड़ा कोई राज्य दा बचन सुणीकरी नी समझदा, उदे मने च जड़ा कुछ राया था, उसयो शैतान झट पट जादां कने उना दे मने ला बचन कडी दिन्दा है जड़ा उना सुणया था; ऐ सै ही बी है, जड़ा रस्ते दे बखे राया था। ");
INSERT INTO bht_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","कने जड़ा पथरिलिया जमिना च राया था, ऐ सै माणु न, जड़े बचना जो सुणीकरी उना जो झट खुशिया ने ग्रहण करी लेंदे न। ");
INSERT INTO bht_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","पर परमेश्वर दे बचना जो मने दिया गहराईया च बदणा नी दिन्दे, उदे बाद जालू बचने दिया बजा ने उना पर कला क्लेश या परेशानी होंदी है, तां सै बचना ला पिच्छे हट्टी जांदे न। ");
INSERT INTO bht_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","जड़े बी झिल्लां च पियो न, ऐ सै माणु न जिना बचन सुणया, पर सै संसारे दियां चिंता जो लेईकरी दुखी, कने संसारिक चिंजा दा लालच उना दे मने च रेंदा है, ऐ सब परमेश्वर दे बचन च रुकावट पांदा है। कने सै बचन उना तांई फायदेमंद नी होंदा। ");
INSERT INTO bht_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","कने जड़े बी खरिया जमिना पर रायो थे, ऐ सै माणु न, जड़े बचन सुणीकरी ग्रहण करदे न, कने फल दिन्दे न, कोई सौ गुणा, कोई सठ गुणा, कने कोई ती गुणा।” ");
INSERT INTO bht_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","यीशुऐ उना जो इक होर कहाणी सुणाई, “स्वर्गे दा राज्य उस माणुऐ सांई है जिनी अपणे खेतरे च खरा भी राया। ");
INSERT INTO bht_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","पर जालू लोक सोआ दे थे तां उना दे दुशमण आई करी कणका बिच जंगली भी राई करी चली गे। ");
INSERT INTO bht_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","जालू लूंगा निकलियाँ कने बेलां लगियां, तां जंगली दांणयां दियां लूंगा भी मिलणा लगियां।” ");
INSERT INTO bht_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","इस गल्ला पर घरे दे नौकरां आई करी उसला बोलया, हे मालिक, तू क्या अपणे खेतरां च खरा भी नी लाया था? फिरी खेतरे च जंगली दांणे दे बूटे कुथु ला आऐ? ");
INSERT INTO bht_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","उनी उना जो बोलया, ऐ कुसी दुशमणे दा कम्म है। नोकरां उसला बोलया, तेरी क्या मर्जी है, कि असां जाई करी जंगली बूटयां जो जड़ा ला पुटी देन? ");
INSERT INTO bht_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","उनी बोलया, नी, ऐसा मत करा इयां ना होऐ कि जंगली दांणे दे बूटयां जो जड़ा ला पुटदे बेले उना सोगी कणका दे बूटे भी पुटुई जान। ");
INSERT INTO bht_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","बडणे दीकर दोनो जो बडूणा दिया, कने बडणे दे बेले मैं बडणे बालयां ने बोलणा है, कि पेहले जंगली दांणे दे बूटयां जो बटोली करी फूंकणे तांई गढियां बन्नी लियां, कने कणका जो मेरे खेतरे च गठेरा। ");
INSERT INTO bht_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","उनी उना जो इक होर कहाणी सुणाई, “स्वर्गे दा राज्य इक राई दे दांणे सांई है, जिसयो कुनी माणुऐ लेईकरी अपणे खेतरां च राई दिता। ");
INSERT INTO bht_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","सै सारे बियां ला छोटा होंदा है, पर जालू सै बडा होई जांदा है तालू सै सारे साग पतयां ला भी बडा होंदा है; कने ऐसा रुख बणी जांदा है, कि अम्बरे दे पंछी आई करी उदिया डालियाँ पर घोंसले बणादे न।” ");
INSERT INTO bht_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","उनी इक होर कहाणी उना जो सुणाई, “स्वर्गे दा राज्य खमिरे (तराक) सांई है, जिसयो कुनी जनानिया लेईकरी तीन पसेरी आटे च मलाई दिता कने होंदे-होंदे सै सारा खमीर बणी गिया।” ");
INSERT INTO bht_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ऐ सारियां गल्लां यीशुऐ कहाणिया दे जरिये लोकां ने बोलियां, कने जड़ा कुछ सै सिखांदा, सै कहाणिया ने ही सिखांदा था। ");
INSERT INTO bht_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","कि जड़ा बचन परमेश्वरे दा संदेश देणेबाले बोलया था, सै पूरा होऐ: “मैं कहाणी बोलणे तांई अपणा मु खोलणा है: मैं उना गल्लां जो जड़ियां संसारे दे शुरू होणें ला गुप्त न उना जो सामणे लोंगा।” ");
INSERT INTO bht_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","तालू यीशु भिड़ा जो छडी करी घरे च आया, कने उदे चेलयां उदे बाल आई करी बोलया, “खतरे दे जंगली दांणे दी कहाणी समझाई दे।” ");
INSERT INTO bht_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","उनी उना जो जबाब दिता, “खरे भी रांणे बाला मैं माणुऐ दा पुत्र है।” ");
INSERT INTO bht_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","खेतर संसारे दे लोक न, खरा बी राज्य दे लोक न, कने जंगली भी शैताने दे लोक न। ");
INSERT INTO bht_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","जिनी दुशमणे उना जो राया सै शैतान है; बडणा संसारे दा खात्मा हे: कने बडणे बाला स्वर्गदूत है। ");
INSERT INTO bht_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","जियां जंगली दांणे दे बीऐ दे बूटे फुकणे तांई गठेरदे न, तियां ही संसारे दे खात्मे च होणा है। ");
INSERT INTO bht_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","मैं माणुऐ दे पुत्रे अपणे स्वर्गदूते जो भेजणा, कने उना उदे राज्य च सारियां पाप दियां बजां जो, कने बुरे कम्म करणे बालयां जो उखाड़ी देणा है। ");
INSERT INTO bht_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","कने स्वर्गदूतां उना जो अग्गी दे कुण्डे च पांणा, कने उना ओथु रोंणा कने दंद पीणे न। ");
INSERT INTO bht_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","उस बेले धर्मियां अपणे पिता दे राज्य च सूरजे सांई चमकणा है। जिस बाल सुणने तांई कन्न न सै ध्यान लाईकरी गल्ला जो सुणे, कने इसा गल्ला जो समझी ले। ");
INSERT INTO bht_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“स्वर्गे दा राज्य खतरे च लुकयो खजाने सांई है, जड़ा कुसी माणुऐ जो मिलया है, कने उनी लुकाई रखया, खुशिया दे मारयो जाई करी उनी अपणा सारा कुछ बेची करी, कने उस खेतरे जो खरदी लिया।” ");
INSERT INTO bht_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“फिरी स्वर्गे दा राज्य इक व्यपारिये सांई है, जड़ा खरे मोतियाँ दिया तोपा च था। ");
INSERT INTO bht_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","जालू उसयो इक बड़ा भरी मेहंगा मोती मिला, तां उनी अपणा सारा कुछ बेची दिता, कने सै मोती खरीदी लिया।” ");
INSERT INTO bht_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“फिरी स्वर्गे दा राज्य उस मच्छियां पकड़ने बाले बड्डे जाल्ले सांई है, जिसयो समुद्रे च पाया, कने सै हर तरा दियां मच्छियां जो बटोली लेई आया। ");
INSERT INTO bht_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","कने जालू जाल्ल भरुई गिया, तां मछवारे जाल्ले जो खिंज्जी करी किनारे जो लेई आये, कने बेईकरी खरियाँ-खरियाँ मच्छियां जो भांडयां च पाया कने बेकार-बेकार सुटी दितियां। ");
INSERT INTO bht_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","संसारे दे अंत च इयां ही होणा है; स्वर्गदूते आई करी बुरे लोकां कने धर्मियां जो लग करणा, ");
INSERT INTO bht_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","कने बुरे लोकां जो अग्गी दे कुण्डे च पांणा। ओथु उना रोंणा कने दंद पींणे न।” ");
INSERT INTO bht_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“तुसां क्या ऐ सारियां गल्लां समझी गे?” उना उसला बोलया, “हाँ।” ");
INSERT INTO bht_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","उनी उना ने बोलया, “तांई तां हर इक व्यवस्था जो सिखाणे बाला जड़ा स्वर्गे दे राज्य दा चेला बंणया है, उस ग्रहस्थ दे सांई है जड़ा अपणी पराणियां कने नोइयां चिजां जो अपणे भंडारे ला कडदा है जिथू सै दुजयां दिया मदद करणे तांई उना जो गठेरदा।” ");
INSERT INTO bht_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","जालू यीशु सारी कहाणी बोली बैठा, तां ओथु ला चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","कने अपणे देशे च आई करी उना दे यहूदी जंज घर च उना जो ऐसा उपदेश देणा लगा; कने सै हेरान होईकरी बोलणा लग्गे, “कि इसयो ऐ अकल कने चमत्कारी कम्म करणे दी शक्ति कुथु ला मिली? ");
INSERT INTO bht_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","क्या ऐ तरखाणे दा जागत नी है? कने क्या इदिया माता दा ना मरियम कने इदे भाईयां दे ना याकूब कने यूसुफ कने शमौन कने यहूदा नी न? ");
INSERT INTO bht_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","कने क्या इदियां सारियां बेहणा साड़े बिच नी रेंदिया न? फिरी इनी ऐ सारा कुछ कुथु ला सिखया?” ");
INSERT INTO bht_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","इयां उना उदिया बजा ला ठोकर खादी, पर यीशुऐ उना जो बोलया, “परमेश्वरे दा संदेश देणेबालयां दा अपणे ग्रां कने घरे छडी करी, उसयो हर कुथी इज्जत मिलदी है।” ");
INSERT INTO bht_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","कने उनी ओथु उना दे भरोसा नी करणे दिया बजा ला जादा अनोखे कम्म नी किते। ");
INSERT INTO bht_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","कने हुण राजा हेरोदेसे यीशुऐ दे कम्मा दी चर्चा सुणी जड़े यीशु करा दा था। ");
INSERT INTO bht_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","कने अपणे सेवकां ने बोलया, “ऐ सेई यूहन्ना बपतिस्मा देणेबाला यूहन्ना है! सै मरयां च जिन्दा होई गिया है, ये ही बजा है कि उदे बाल इना चमत्कारां जो करणे तांई परमेश्वर दी शक्ति है!” ");
INSERT INTO bht_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","क्योंकि हेरोदेसे अपणे भाई फिलिप्पुस दी घरे बाली हेरोदियास दिया बजा ला, यूहन्ना जो पकड़ी करी बन्या, कने जेला च पाई दिता था। ");
INSERT INTO bht_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","क्योंकि यूहन्ने उसयो बोलया था, कि इसा जो रखणा तिजो तांई ठीक नी है। ");
INSERT INTO bht_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","कने सै उसयो मारी देणा चांदा था, पर सै लोकां ला डरदा था, क्योंकि सै उसयो परमेश्वरे दा संदेश देणेबाला मंदे थे। ");
INSERT INTO bht_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","पर जालू हेरोदेस दा जन्म दिन आया, तां हेरोदियास दिया कुड़िया त्योहारे च नची करी हेरोदेसे जो खुश किता। ");
INSERT INTO bht_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","इसा गल्ला पर उनी कसम खाई करी बचन दिता, कि जड़ा कुछ तू मंगगी, सै मैं तिजो दिंगा। ");
INSERT INTO bht_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","उना अपणिया माता दे बहकावे च आई करी बोलया, “यूहन्ना बपतिस्मा देणेबाले दा सिर थालिया च रखीकरी मिंजो ऐथू मंगबाई दे।” ");
INSERT INTO bht_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ऐ सुणीकरी राजा बड़ा उदास होया, पर अपणिया कसमां, कने सोगी बोणे बालयां दिया बजा ने, हुकम दिता, कि यूहन्ना दा सर इसा जो देई दिया। ");
INSERT INTO bht_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","राजे इक सिपाइऐ जो हुकम दिता, कि जेला च जा, कने यूहन्ना दा मुंड बड्डी करी उदे बाल लेईकर आ। ");
INSERT INTO bht_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","सिपाईऐ जेला च जाई करी उदा सिर कटया, कने इक थालिया च रखीकरी लेई आया कने उसा कुड़िया जो देई दिता, कने कुड़िया अपणिया माता जो देई दिता। ");
INSERT INTO bht_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","तालू यूहन्ना दे चेलयां उदिया लाशा जो ले जाई करी दबाई दिता, कने जाई करी यीशुऐ जो खबर दिती। ");
INSERT INTO bht_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","जालू यीशुऐ ऐ सुंणा, तां किस्तिया च चढ़ी करी ओथु ला कुसी सुनसान जगा जो, एकांत च चली गिया; कने लोक ऐ सुणीकरी शेहरे-शेहरे ला पैदल चली करी उदे पिच्छे चली गे। ");
INSERT INTO bht_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","उनी निकली करी मते भरे लोकां दी भीड़ दिखी, कने उना पर तरस खादा, कने उनी उना चे जड़े मरीजां जो ठीक किता। ");
INSERT INTO bht_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","जालू संज होई, तां उदे चेलयां उदे बाल आई करी बोलया, “ऐ तां सुनसान जगा है, कने देर होआ दी है; कने लोकां जो भेजी दिया ताकि सै ग्रां च जाई करी अपणे तांई खांणा खरीदी लेन।” ");
INSERT INTO bht_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","पर यीशुऐ उना जो बोलया, “उना दा जाणा जरूरी नी है। तुसां ही इना जो खाणे जो दिया।” ");
INSERT INTO bht_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","उना उसला बोलया, “साड़े बाल ऐथू पंज रोटियां कने दो मछियां जो छडी करी होर कुछ नी है।” ");
INSERT INTO bht_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","उनी बोलया, “उना जो ऐथू मेरे बाल लेई ओआ।” ");
INSERT INTO bht_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","तालू उनी लोकां जो घाऐ पर बोणे जो बोलया, कने उनी सै पंज रोटियां कने दो मछियां लियां; कने स्वर्गे पासे दिखीकरी धन्याबाद किता, कने रोटियां तोड़ी-तोड़ी करी चेलयां जो दितियां, कने चेलयां लोकां जो। ");
INSERT INTO bht_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","सारे खाई करी रजी गे। कने जालू रोटी खायी बैठे तालू चेलयां बाकी बचियाँ रोटियां कने मछियां गिठेरेइयां कने उसला बाहरा टोकरियाँ भरुई गियां। ");
INSERT INTO bht_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","कने खांणे बाले चे जनानिया कने बचयां जो छडी करी लगभग पंज हजार मर्द थे। ");
INSERT INTO bht_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","कने उनी तोले-तोले अपणे चेलयां जो किस्तिया पर चढ़ने तांई बोलया, ताकि सै उसला पेहले पार पुज्जी जान, तालू दीकर कि मैं लोकां जो भेजी करे। ");
INSERT INTO bht_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","सारे लोकां जो भेजणे बाद, यीशु पहाड़े पर प्राथना करणे तांई गिया; संझा जो सै ओथु किल्ला था। ");
INSERT INTO bht_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","उस बेले किस्ति झिल्ला बिच लेहरां ने डगमगा दी थी, क्योंकि होआ सामणे ला ओआ दी थी। ");
INSERT INTO bht_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","कने तां भयागा तड़के यीशु झिल्ला पर चली करी उना बाल आया। ");
INSERT INTO bht_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","पर जालू चेलयां उसयो झिला पर चलदे दिखया, तां से घबराई गे, कने बोलणा लग्गे कि, “भुत है ऐ!” ");
INSERT INTO bht_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","पर यीशुऐ उना ने झट गल्लां कितियां कने बोलया, “हिम्मत रखा, डरा मत, मैं यीशु है।” ");
INSERT INTO bht_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पतरसे उसयो जबाब दिता, “हे प्रभु, अगर तू है, तां तू मिंजो अपणे बाल पांणिऐ पर चली करी ओणे दा हुकम दे।” ");
INSERT INTO bht_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","उनी बोलया, “आ।” तालू पतरस किस्तिया ला उतरी करी यीशुऐ पासे चलणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","पर होआ जो महसूस करी डरी गिया, कने जालू डूबणा लगा तां चिलाई करी बोलया, “हे प्रभु, मिंजो बचा।” ");
INSERT INTO bht_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","यीशुऐ झट हथ गां करी के उसयो थमी लिया, कने उसला बोलया, “हे घटविश्वासी, तू कजो शक किता?” ");
INSERT INTO bht_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","जालू सै किस्तिया पर चढ़ी गिया, तां होआ भी रुकी गेई। ");
INSERT INTO bht_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","इसा गल्ला पर जड़े किस्तिया पर थे, उना उसयो झुकी करी नमस्ते करी के बोलया, “सच्ची, तू परमेश्वरे दा पुत्र है।” ");
INSERT INTO bht_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","सै पार उतरी करी गन्नेसरत प्रदेश दे कन्डै पुज्जे। ");
INSERT INTO bht_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","कने ओथु दे लोकां उसयो पछेणी लिया कने अखे-बखे दे सारे देशे च बोली भेजया, कने सारे बिमारां जो उदे बाल लेई आये। ");
INSERT INTO bht_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","कने उसने बिनती करणा लग्गे कि सै सिर्फ अपणे कपड़यां जो छुणा दे, कने जितणे भी छुंदे थे, सै सारे ठीक होई जांदे थे। ");
INSERT INTO bht_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","तालू यरूशलेम ला कुछ फरीसी कने व्यवस्था जो सिखाणे बाले यीशुऐ बाल आई करी बोलणा लग्गे, ");
INSERT INTO bht_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“तेरे चेले पूर्वजां दे रीती रिबाजां जो कजो टालदे न, कि बिना हथ धोतयो रोटी खांदे न?” ");
INSERT INTO bht_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","यीशुऐ उना जो जबाब दिता, “तुसां अपणे बणायो नियमा दिया बजा ला कजो परमेश्वरे दे हुकमे जो टालदे न?” ");
INSERT INTO bht_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","क्योंकि परमेश्वरे बोलया है, “कि अपणे माता पिता दा आदर करा, कने जड़ा कोई अपणे माता पिता जो श्राप दिंगा, सै पक्का मारी देणा।” ");
INSERT INTO bht_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“पर तुसां लोकां जो इजाजत दिन्दे न की, अपणे माता-पिता जो ऐ बोली दिया कि जड़ा कुछ मैं तुहांजो देणा था, सै मैं परमेश्वर जो देणे दी कसम खादियो है।” ");
INSERT INTO bht_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","तां सै अपणे पिता दा आदर नी करदा है, इयां ही तुसां भी अपणे रीती रिबाजा दिया बजा ला परमेश्वरे दा हुकम तोड़ी दितया है। ");
INSERT INTO bht_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","यशायाह तुहाड़े बारे च ठीक बोलया था, जिनी पबित्र शास्त्र च तुसां कपटियां दे बारे च लिखया है, ");
INSERT INTO bht_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“कि ऐसे लोक गल्लां ने तां मेरा आदर करदे न, पर इना दे मन मिंजो ला बड़े दूर न। ");
INSERT INTO bht_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","कने ऐ बेकार ही मेरी भक्ति करदे न, क्योंकि माणुऐ दे तरीकेयां जो धर्म उपदेश बणाई करी सिखांदे न।” ");
INSERT INTO bht_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","कने यीशुऐ लोकां जो अपणे बाल सदीकरी उना ने बोलया, “सुंणा, कने समझा। ");
INSERT INTO bht_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","जड़ा मुऐ च जांदा है, सै माणुऐ जो अशुद्ध नी करदा है, पर जड़ा मुऐ ला निकलदा है, सै माणुऐ जो अशुद्ध करदा है।” ");
INSERT INTO bht_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","तालू चेलयां आई करी बोलया, “क्या तिजो ऐ पता है कि फरीसियां ऐ बचन सुणीकरी ठोकर खादी?” ");
INSERT INTO bht_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","उनी जबाब दिता, “हर इक बूटा जड़ा मेरे स्वर्गीय पिता नी लाया है, सै पुटुई जाणा है।” ");
INSERT INTO bht_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“उना जो जाणा दिया; सै रस्ता दसणे बाले अन्ने न, कने अगर अन्ना अन्ने जो रस्ता दसे, तां दोनो खड्डे च पोंणा है।” ");
INSERT INTO bht_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ऐ सुणीकरी पतरसे उसला बोलया, “ऐ कहाणी सांझो समझाई दे।” ");
INSERT INTO bht_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","उनी बोलया, “क्या तुसां भी हले दीकर नी समझे?” ");
INSERT INTO bht_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“क्या तुहांजो पता नी है, कि जड़ा कुछ मुऐ च जांदा है सै पेटे च पौंदा है, कने संडास ने बाहर निकली जांदा है? ");
INSERT INTO bht_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","पर जड़ा कुछ मुऐ ला निकलदा है, सै मने ला निकलदा है, सै ही माणुऐ जो अशुद्ध करदा है। ");
INSERT INTO bht_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","क्योंकि बुरे बिचार, मारणा, परस्त्रीगमन, व्यभिचार, चोरी, झूठी गबाई कने निंदा मने ला ही निकलदे न। ");
INSERT INTO bht_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ऐ ही है जड़े माणुऐ जो अशुद्ध करदे न, पर बिना हथ धोतयो खांणा खाणां माणुऐ जो अशुद्ध नी करदा है।” ");
INSERT INTO bht_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","यीशु ओथु ला निकली करी, सूर कने सैदा दे देशां जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","उस देशे ला इक कनानी जनानी आई, कने जोरे-जोरे ने बोलणा लगी, “है प्रभु। दाऊदे दी ओलाद, मिंजो पर दया कर, मेरिया कुड़िया जो बुरी आत्मा बड़ी भरी सतांदी है।” ");
INSERT INTO bht_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","पर उनी उसा जो कोई जबाब नी दिता, कने उदे चेलयां आई करी उसने बिनती करिके बोलया, “इसा जो भेजी दे; क्योंकि सै साड़े पिच्छे डडदी ओआ दी है।” ");
INSERT INTO bht_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","यीशुऐ जबाब दिता, “इस्राएले दे घराने दियां गवाचियां भेडां जो छडी करी मिंजो होर कुसी बाल नी भेजया है।” ");
INSERT INTO bht_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","पर सै आई, कने उसयो नमस्ते करिके बोलणा लगी, “है प्रभु, मेरी मदद कर।” ");
INSERT INTO bht_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","उनी जबाब दिता, “बचयां दी रोटी लेईकरी कुतयां दे अग्गे पाणा ठीक नी है।” ");
INSERT INTO bht_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","उनी बोलया, “सच्च है प्रभु; पर कुत्ते भी सै ही टुकड़े खांदे न, जड़ा उना दे मालिकां दे मजे ला हेठ पोंदे न।” ");
INSERT INTO bht_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","इसा गल्लां पर यीशुऐ उसा जो जबाब दिता, “हे जनानी, तेरा भरोसा बडा है; जियां तू चांदी है, तेरे तांई तियां ही हो।” कने उसा दी कुड़ी उसी बेले ठीक होई गेई। ");
INSERT INTO bht_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","यीशु ओथु ला गलील झिला बखे आया, कने पाहड़े पर चढ़ी करी ओथु बेई गिया। ");
INSERT INTO bht_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","तालू भिड़ा दी भीड़ उदे बखे आई। कने अपणे सोगी केई लंगड़े, अन्ने, जल्ले, टुंडे, कने होर मते सारयां जो लेईकरी उदे बाल आये; कने उना जो उदे पैरा च रखी दिता, कने उनी उना सारयां जो ठीक किता। ");
INSERT INTO bht_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","जालू लोकां दिखया कि, जल्ले बोलणा, कने टुंडे ठीक होंणा, कने लट्टे चलदे, कने अन्नयां जो मिलदा है, तां हेरान होऐ कने इस्राएले दे परमेश्वरे दी बड़ाई करणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","यीशुऐ अपणे चेलयां जो सदीकरी बोलया, “ऐ लोक मिजों सोगी तिन्ना रोजां ला रे दे न। उना बाल खाणे तांई कुछ नी है कने मिंजो इसा गल्ला पर तरस ओआ दा है; कने मैं इना जो भूखा नी भेजणा चांदा है; कुथी इयां ना हो कि सै रस्ते च थकी करी रेई ना जान।” ");
INSERT INTO bht_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","चेलयां उसयो बोलया, “सांझो ऐथू सुनसान जगा च कुथु ला इतणियां रोटियां मिलगियां कि असां इतणियां बडिया भिड़ा जो खुआन?” ");
INSERT INTO bht_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","यीशुऐ उना ला पूछया, “कि तुहाड़े बाल कितणियां रोटियां न?” उना बोलया, “सत रोटियां कने थोड़ियां दियां छोटियां मछियां न।” ");
INSERT INTO bht_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","तालू यीशुऐ लोकां जो धरतिया पर बोंणे दा हुकम दिता कने सै बेई गे, ");
INSERT INTO bht_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","कने उदे बाद उनी सै सत रोटियां कने मछियां लियां, कने परमेश्वरे दा धन्यबाद करिके तोड़ियां, कने अपणे चेलयां जो रोटीयां तोड़ी करी दिन्दा गिया ताकि सै उना जो लोकां च बंडी देन। ");
INSERT INTO bht_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","फिरी बादे च सारे लोक खाई करी रजी गे कने उदे बाद चेलयां बाकी बचयो टुकड़यां जो सत टोकरियां च भरी लिया। ");
INSERT INTO bht_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","कने खांणे बालयां चे जनानिया कने बचयां जो छडी करी चार हजार मर्द थे। ");
INSERT INTO bht_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","तालू सै भिड़ा जो भेजी करी किस्तिया पर चढ़या, कने मगदन देशे दिया सीमा पर आया। ");
INSERT INTO bht_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","फरीसियां कने सदूकियां यीशुऐ बाल आई करी उसयो परखणे तांई बोलया, “कि सांझो स्वर्गे दा कोई चमत्कार दस।” ");
INSERT INTO bht_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","उनी उना जो जबाब दिता, “संझा जो तुसां बोलदे न, कि मौसम खरा रेंणा है, क्योंकि अम्बर लाल है।” ");
INSERT INTO bht_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","कने ब्यागा जो बोलदे न, कि अज तूफान ओंणा क्योंकि अम्बर लाल कने धुंधला है तुसां अम्बरे दे लछण दिखीकरी फरक दसी सकदे न, पर बकते दे निशाणा दा फरक कनी दसी सकदे न? ");
INSERT INTO bht_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“इस युगे दे बुरे कने व्यभिचारी लोक निशाण तोपदे न, पर योना दे निशाणे जो छडी करी उना जो कोई होर निशाण नी मिलणा।” कने सै उना जो छडी करी चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","कने चेले झीला दे पार जांदे बेले रोटियां लेणा भूली गियो थे। ");
INSERT INTO bht_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","कने यीशुऐ उना जो चेतावनी दिती कि, “फरीसियां कने सदूकियां दे खमिरे ला बचणे तांई चौकने रेनयो।” ");
INSERT INTO bht_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","सै अपु चे बिचार करिके बोलणा लग्गे, कि यीशुऐ ऐ इस तांई बोलया क्योंकि “असां रोटियां नी लोंदियां।” ");
INSERT INTO bht_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ऐ जाणी करी, यीशुऐ उना ने बोलया, “हे घटविश्वासियों, तुसां कजो अपु चे बिचार करा दे कि साड़े बाल रोटिया नी न?” ");
INSERT INTO bht_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","तुसां क्या हले दीकर नी समझे? कने उना पंजा हजारां दियां पंज रोटिया याद नी न, कने ना ही ऐ कि कितणियां टोकरियाँ चुकियां थियां? ");
INSERT INTO bht_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","कने ना ही उना चार हजार दियां सत रोटियां, कने ना ही ऐ कि तुसां कितणियां टोकरियां चुकियां थियां? ");
INSERT INTO bht_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“तुसां कनी समझदे कि मैं तुसां ने रोटियां दे बारे च नी बोलया? पर फरीसियां कने सदूकियां दे बचना ला चौकने रेणे दे बारे च बोलया है।” ");
INSERT INTO bht_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","तालू उना जो समझ आया, कि उनी रोटिया दे खमिरे तांई नी, पर फरीसियां कने सदूकियां दिया शिक्षा ला चौकने रेणे तांई बोलया था। ");
INSERT INTO bht_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","यीशु कैसरिया फिलिप्पी दे प्रदेशे च आया कने उनी अपणे चेलयां ला पूछया, “लोक मिंजो, माणुऐ दे पुत्रे जो क्या बोलदे न?” ");
INSERT INTO bht_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","चेलयां जबाब दिता कुछ लोक बोलदे न कि तुसां यूहन्ना बपतिस्मादाता न; पर कोई-कोई एलिय्याह, कने कोई-कोई बोलदे न कि पुराणे जमाने दे परमेश्वरे दा संदेश सुनाणे बालयां चे कोई इक है। ");
INSERT INTO bht_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","यीशुऐ उना जो बोलया, “पर तुसां मिंजो क्या बोलदे न?” ");
INSERT INTO bht_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","शमौन पतरसे जबाब दिता, “तू जिंदे परमेश्वरे दा पुत्र मसीह है।” ");
INSERT INTO bht_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","यीशुऐ उसयो जबाब दिता, “हे शमौन, योना दे पुत्र, तू धन्य है; क्योंकि मासे या खूने नी, पर मेरा पिता परमेश्वर जड़ा स्वर्गे च है, उनी ऐ गल्ल तिजो पर प्रगट कितियो है। ");
INSERT INTO bht_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","कने मैं भी तिजो ने बोलदा है, कि तू पतरस है, कने मैं इसी पथरे पर अपणी कलीसिया बणाणी, कने अधोलोक दे फाटक उदे पर प्रबल नी होणे।” ");
INSERT INTO bht_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“मैं तिजो स्वर्गे दे राज्य दियां चाबियां दिंगा: कने जड़ा कुछ तू धरतिया पर बणांगा; सै स्वर्गे च भी बणना, कने जड़ा कुछ तू धरतिया पर खोलगा, सै स्वर्गे पर भी खुलणा।” ");
INSERT INTO bht_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तालू उनी चेलयां जो समझाया कि, “कुसी ने भी मत बोलदे कि, मैं मसीह है।” ");
INSERT INTO bht_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","उस बेले यीशु चेलयां जो दसणा लगा, “मिंजो जरूरी है कि मैं यरूशलेम जां, कने यहूदी अगुवे, बड्डे याजकां, कने यहूदी व्यवस्था जो सिखाणे बालयां दे हथां ला मते दुख झेलें, कने सै मिंजो मारी देन, कने फिरी मैं तिन्ना रोजां बाद मरयां चे जिन्दा होई जां।” ");
INSERT INTO bht_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","पतरस यीशुऐ जो बखिया लेई गिया कने इसा गल्ला पर झिड़कणा लग्गा, “है प्रभु, परमेश्वर ना करे। कि तिजो पर कदी ऐसा होऐ।” ");
INSERT INTO bht_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","उनी मुड़ी करी पतरसे जो बोलया, “शैताने सांई कम्म करणा बंद कर! मेरे सामणे ला दूर होई जा! क्योंकि तू परमेश्वरे सांई नी, पर तू माणुऐ सांई सोचा दा है।” ");
INSERT INTO bht_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","यीशुऐ भिड़ा जो अपणे चेलयां समेत अपणे बाल सदीकरी बोलया, “जड़ा कोई मेरा चेला बनणा चांदा है, उसयो अपणिया शरीरे दियां इच्छां कने जड़ियां तरकिबां बणाईयां उना जो छडी करी! मिजों तांई मरणे जो तैयार रैणा पोणा, सेई मेरा चेला बणी करी मिजों पिच्छे चली सकदा है।” ");
INSERT INTO bht_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","कोई माणु ऐसा नी करगा कने अपणे प्राणा जो बचाणा चांहगा, उनी परमेश्वर सोगी आत्मिक जिन्दगी जिणे दा मोका गबाई देणा है। पर जड़ा माणु मिजों पर भरोसा करगा कने मेरे शुभसमाचार दिया बजा ने मरगा उस माणुऐ जो परमेश्वरे सोगी सदा तांई दी जिन्दगी मिलणी। ");
INSERT INTO bht_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","अगर तुसां संसारे दा सब कुछ पाई लेंगे कने परमेश्वरे सोगी सदा दी जिन्दगी जिणे दा मोका गबाई दिंगे, तां उदा क्या फायदा? इक माणु परमेश्वरे जो क्या देई सकदा है, जड़ा उदी सदा दी जिन्दगी खरिदगा? कुछ नी! ");
INSERT INTO bht_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","मैं, माणुऐ दे पुत्रे अपणे स्वर्गदूते सोगी अपणे पिता दिया महिमा च ओंणा है, कने उस बेले उनी हर इकी जो उदे कम्मा दे अनुसार उसयो फल देणा है। ");
INSERT INTO bht_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","मैं तुसां ने सच्च बोलदा है, “कि जड़े ऐथू खड़ोतयो न, उना चे केई ऐसे न, कि जालू दीकर मिंजो, माणुऐ दे पुत्रे जो उदे राज्य च ओंदे नी दिखी लेन, तालू दीकर मौता दा स्वाद नी चखणा है।” ");
INSERT INTO bht_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","छे रोजां बाद यीशुऐ पतरस कने याकूब कने उदे भाई यूहन्ना जो सोगी लिया, कने उना जो एकांत च कुसकी उच्चे पहाड़े पर लेई गिया। ");
INSERT INTO bht_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","कने उना दे सामणे यीशुऐ दा रूप बदलुई गिया। कने उदे कपड़े चमकदार सफेद होई गे, ");
INSERT INTO bht_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","तालू उना तिन्ना चेलयां, परमेश्वरे दा संदेश देणेबाले मूसा कने एलिय्याह जो, जड़े बड़े पेहले जिन्दा थे उना जो यीशुऐ सोगी गल्लां करदे दिखया। ");
INSERT INTO bht_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","इसा गल्ला पर पतरसे यीशुऐ जो बोलया, “प्रभु जी, साड़ा ऐथू रेंणा ठीक है, इस तांई असां ऐथू तीन तम्बू बणांदे न, इक तेरे तांई, इक मूसा तांई, इक एलिय्याह तांई।” ");
INSERT INTO bht_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","पतरस बोला दा ही था, तालू इक चमकीला बदल आया कने उना जो अपणी छाया ने ढकी लिया, बदले च परमेश्वरे जो बोलदे सुणया, “कि ऐ मेरा प्यारा पुत्र है, कने मैं इसला खुश है, कने जड़ा ऐ बोलदा है उसयो ध्याने ला सुणा।” ");
INSERT INTO bht_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","चेले ऐ सुणी के मुऐ भार पेई गे, कने बड़े डरी गे। ");
INSERT INTO bht_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","यीशुऐ उना जो बखे आई करी छुता, कने बोलया, “उठा कने डरा मत।” ");
INSERT INTO bht_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","तालू उना अपणे चारो पासे नजर मारी, तां मूसा कने एलिय्याह ओथु नी थे, कने उना जो सिर्फ यीशु ही मिल्ला। ");
INSERT INTO bht_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","जालू यीशु कने उदे तिन्न चेले पहाड़े ला उतरा दे थे, तालू यीशुऐ उना जो हुकम दिता कि, “कुसी जो भी मत दसदे कि तुसां क्या दिखया जालू दीकर मैं, माणुऐ दा पुत्र मरयां चे जिन्दा ना होई जा।” ");
INSERT INTO bht_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","कने चेलयां उसला पुछया, “मूसा दी व्यवस्था जो सिखाणे बाले यहूदी गुरू कजो बोलदे थे मसीहा ला पेहले एलिय्याह ओणा था? अगर ओणा था, तां हाली दिकर कजो नी आया सै?” ");
INSERT INTO bht_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","यीशुऐ उना जो जबाब दिता, “ऐ तां सच्च है कि एलिय्याह पेहले आई करी सब कुछ सुधारणा है।” ");
INSERT INTO bht_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","पर मैं तुसां ने बोलदा है, “एलिय्याह ता पेहले ही आई चुकया था, कने लोकां उसयो नी पछेणया; पर जियां सै करणा चांदे थे तियां ही उदे सोगी किता। इसी तरीके ने ही माणुऐ दे पुत्रे जो भी उना दे हथे ला दुख होणे न।” ");
INSERT INTO bht_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","तालू चेलयां समझया कि उनी सांझो ने यूहन्ना बपतिस्मा देणेबाले दे बारे च बोलया है। ");
INSERT INTO bht_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","जालू सै भिड़ा बखे पुज्जे, तां इक माणु उना बाल आया, कने गोडे भार बेईकरी बोलणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“प्रभु जी, मेरे पुत्रे पर दया कर। क्योंकि उसयो मिर्गी दे दौरे पोंदे न, उसयो बड़ी तकलीफ होंदी है, कने बार-बार अग्गी च, कने बार-बार पांणिऐ च पेई जांदा है। ");
INSERT INTO bht_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","कने मैं उसयो तेरे चेलयां बाल लांदा था, पर सै उसयो ठीक नी करी सके।” ");
INSERT INTO bht_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ऐ सुणीकरी यीशुऐ उना जो जबाब दिता, “हे अविश्वासी लोकों, मैं कालू दीकर तुहाड़े सोगी रेंगा, कने कालू दीकर तुहाड़े अविश्वास जो सेहन करगा? उसी जागते जो मेरे बाल लोआ।” ");
INSERT INTO bht_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","तालू यीशुऐ उसयो झिड़कया, कने बुरी आत्मा उसला निकली गेई; कने जागत उसी बेले ठीक होई गिया। ");
INSERT INTO bht_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","जालू यीशु किला था, तां उदे चेले उस बाल आऐ कने उसयो पुछया कि, “असां उसा बुरी आत्मा जो कजो नी कडी सके?” ");
INSERT INTO bht_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","यीशुऐ उना ने बोलया, “अपणे भरोसे दिया कमिया दिया बजा ला। क्योंकि मैं तुसां ने सच्च बोलदा है, अगर तुहाड़ा भरोसा राईया दे दांणे बराबर भी होंदा, तां इसी पाहड़े ने बोली सकदे न, कि ऐथू ला खिसकी करी ओथु चली जा, तां उनी चली जाणा; कने कोई भी गल्ल तुहाड़े तांई मुशकिल नी होणी। ");
INSERT INTO bht_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(पर ऐ जात बिना प्राथना कने बिना बरते दे नी निकलदी।)” ");
INSERT INTO bht_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","जालू चेले गलील प्रदेशे च थे, तां यीशुऐ उना ने बोलया, “मैं, माणुऐ दा पुत्र माणुआं दे हथे पकड़ाया जाणा है। ");
INSERT INTO bht_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","कने उना मिंजो मारी देणा, कने मैं तीजे रोजे मरयां चे जिंदा होई जांणा।” इना गल्लां जो सुणीकरी चेले बड़े उदास होए। ");
INSERT INTO bht_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","जालू सै कफरनहूम शेहरे च पुज्जे, तां मंदरे दा कर लेंणे बालयां, पतरसे बाल आई करी पुछया, कि क्या तुहाड़ा गुरू मंदरे दा कर नी दिन्दा है? ");
INSERT INTO bht_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","उनी बोलया, “हाँ, दिन्दा है।” जालू सै घरे आया, तां यीशुऐ पतरसे दे पूछणे ला पेहले ही उसयो बोलया, “हे शमौन तू क्या समझदा है? धरतिया दे राजे महसूल या कर कुसला लेंदे न? अपणे पुत्रां ला कि परायां ला?” ");
INSERT INTO bht_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पतरसे उना ने बोलया, “परायां ला।” यीशुऐ उसला बोलया, “तां पुत्र बची गे।” ");
INSERT INTO bht_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","तमी असां उना जो ठोकर ना खुआन, तू झिला दे बखे जाई करी बीडी पा, कने जड़ी मछी पेहले निकलगी, उसा जो पकड़यां; उसा दा मुउ खोलणे पर इक सिक्का मिलणा है, उसयो लेईकरी मेरे कने अपणे बदले उना जो कर देई दियां। ");
INSERT INTO bht_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","उस बेले चेले यीशुऐ बाल आई करी पूछणा लग्गे, “स्वर्गे दे राज्य च बडा कुण है?” ");
INSERT INTO bht_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","इस गल्लां पर उनी इक जागते जो अपणे बाल सदीकरी उना बिच खरेड़या, ");
INSERT INTO bht_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","कने बोलया, “मैं तुसां ने सच्च बोलदा है, कि तुसां अपणा मन बदला, कने बचयां सांई बणा, तां तुसां स्वर्गे दे राज्य च जाई सकदे न। ");
INSERT INTO bht_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","जड़ा कोई अपणे आपयो बचयां सांई छोटा करगा, उनी स्वर्गे दे राज्य च बडा होणा। ");
INSERT INTO bht_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","कने जड़ा कोई मेरे नाऐ ला इक ऐसे बच्चे जो अपनांदा है सै मिंजो भी अपनांदा है।” ");
INSERT INTO bht_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","पर जड़ा कोई इना छोटयां चे कुसी इकी जो भी भरोसे ला भटकांदा है या उना दे पाप करणे दी बजा बणदा है, उदे तांई तां खरा होंदा, कि उदे गले च बड्डे घराटे दा पथर लटकाई करी उसयो डुगे समुंद्रे च डोबी दिन्दे। ");
INSERT INTO bht_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“ठोकरां दियां बजा ने संसारे पर हाय! ठोकर लगणा जरूरी है; पर हाय उस माणुऐ पर जिदे जरिये ठोकर लगदी है।” ");
INSERT INTO bht_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“अगर तेरा हथ या पैर तेरे पापां दी बजा बणा दा, तां उना जो बडी करी फेंकी दे; तेरे तांई ऐ ही ठीक है कि तू टुंडा या लंगड़ा होईकरी हमेशा दिया जिन्दगिया च प्रवेश करे, कि दो हथ पैर होंदे होए भी तू कदी नी बुझणे बालिया अग्गी च जां। ");
INSERT INTO bht_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","अगर तेरी हख तेरे पाप दी बजा बणे, तां उसा जो कडी करी फेंकी दे। तेरे तांई ऐ ही ठीक है कि काणा होईकरी हमेशा दिया जिन्दगिया च प्रवेश करे, कि दो हखी दे होंदे होए भी तू कदी नी बुझणे बालिया नरके दिया अग्गी च जां।” ");
INSERT INTO bht_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“दिखा, तुसां इना छोटयां चे कुसयो भी घटिया मत समझदे; क्योंकि मैं तुसां ने बोलदा है कि स्वर्गे च उना दे स्वर्गदूत हमेशा मेरे स्वर्गीय पिता दे सोगी रेंदे न।” ");
INSERT INTO bht_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(क्योंकि मैं, माणुऐ दा पुत्र गवाचयां जो बचाणा आया है।) ");
INSERT INTO bht_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“तुसां क्या सोचदे न? अगर कुसी माणुऐ दियां सौ भेडां न, कने उना चे इक गवाची जा, तां क्या सै उना निन्यानबे जो बाकी रखबालयां बाल छडी करी, पाहड़े पर जाई करी, उसा गवाचिया जो नी तोपगा?” ");
INSERT INTO bht_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","“कने अगर ऐसा हो कि सै भेड उसयो मिली जाऐ, तां मैं तुसां ने सच्च बोलदा है, कि उनी निन्यानबे भेडां तांई इतणा खुश नी होणा, जितणा कि इसा भेडां तांई होणा। ");
INSERT INTO bht_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","तियां ही तुहाड़ा पिता जड़ा स्वर्गे च है उदी इच्छा नी है, कि इना छोटयां चे इक भी खत्म होऐ।” ");
INSERT INTO bht_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“अगर तेरा मसीह भाई तिजो ने कोई जुल्म करे, तां जा कने उस सोगी किल्ले च गल्ल बात करिके समझा; अगर सै तेरी सुणे ले कने अपणी गलती मन्नी ले, तां तू अपणे मसीह भाईऐ जो बापिस पाई लिया।” ");
INSERT INTO bht_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","कने अगर सै नी सुणे, तां इक दो जणे होर लेई जा सोगी, क्योंकि मूसा दिया व्यवस्था दे अनुसार, “हर इक अरोप जो दो या उसला जादा गबाह ला सही साबित करणा चाईदा।” ");
INSERT INTO bht_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","अगर सै उना दी भी नी मन्ने, तां तू कलीसिया ने बोली दे, पर अगर सै कलीसिया ने भी नी मन्ने, तां तू उसयो जियां तुसां होर जातियां सोगी व्यवहार करदे न, तियां ही उसयो कलीसिया ला कडी दिया। ");
INSERT INTO bht_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“मैं तुसां ने सच्च बोलदा है, जड़ा कुछ तुसां धरतिया पर बणाणा है, उनी सै स्वर्गे च भी बणाणा है कने जड़ा कुछ तुसां धरतिया पर खोलणा है, सै स्वर्गे च भी खोलणा है।” ");
INSERT INTO bht_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","मैं तुसां ने फिरी बोलदा है, अगर धरतिया पर तुसां चे दो जणे कुसा गल्लां तांई इक मन होईकरी मंगगे, तां सै उना तांई मेरे पिता दिया तरफा ला जड़ा स्वर्गे च है होई जाणी। ");
INSERT INTO bht_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","“क्योंकि जिथू दो या तीन मेरे नाऐ ने गिठे होंदे न ओथु मैं उना बिच होंदा है।” ");
INSERT INTO bht_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","तालू पतरसे बखे आई करी, उसयो बोलया, “प्रभु जी, अगर मेरा मसीह भाई जुल्म करदा रे, तां मैं उसयो कितणी बरी माफ करे, क्या सत बरी दीकर?” ");
INSERT INTO bht_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","यीशुऐ उसयो बोलया, “मैं तिजो ने ऐ नी बोलदा, कि सत बरी नी, पर तिजो उसयो माफ करी देणा चाईदा।” ");
INSERT INTO bht_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“इस तांई स्वर्गे दे राज्य उस राजे सांई न, जड़ा अपणे सेवकां ला लेखा लेणा चांदा था। ");
INSERT INTO bht_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","जालू सै लेखा लेणा लग्गा, तां इकी बंदे जो उदे सामणे लांदा सै दस हजार सोने दे सिकयां दे बोरे दा कर्जदार था। ");
INSERT INTO bht_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","कने उदे बाल बापस करणे तांई कुछ भी नी था, तां उदे मालिके बोलया, कि ऐ कने इदी घरे बाली कने बाल-बच्चे कने जड़ा कुछ भी इदा है सै सब कुछ बेची दिया, कने कर्ज चुकाई दिया। ");
INSERT INTO bht_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","इसा गल्ला पर उनी सेवके पैरां च पेईकरी नमस्ते किते, कने बोलया, हे मालिक, सबर रख, मैं सारा कुछ भरी दिंगा। ");
INSERT INTO bht_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","तालू उदे मालिके उस पर तरस खाई करी उसयो छडी दिता, कने उदा कर्ज भी माफ करी दिता। ");
INSERT INTO bht_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","पर जालू सै सेवक बाहर निकलया, तां उसयो इक सोगी कम्म करणे बाला साथी मिला, जिनी उसला सो दीनारां (सो दीनार: सो चांदी दे सिक्के) दा कर्ज लिया था; उनी उदा गला पकड़ी करी उसयो बोलया, जड़ा कुछ तेरे पर कर्ज है उसयो भरी दे। ");
INSERT INTO bht_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","उदे साथी सेवके उदे पैरां पेईकरी, उसने बिनती करणा लगा; कि सबर रख मैं सारा भरी दिंगा। ");
INSERT INTO bht_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","पर सै नी मनया, कने उनी जाई करी उसयो जेला च पाई दिता, ताकि जालू दीकर सै कर्ज नी भरगा, तालू दीकर ओथु ही रे। ");
INSERT INTO bht_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","कने उदे साथी सेवक ऐ दिखीकरी बड़े उदास होए, कने जाई करी ऐ सारा हाल अपणे मालिके ने सुणाई दिता।” ");
INSERT INTO bht_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तालू उदे मालिके उसयो सदीकरी बोलया, “हे दुष्ट सेवक, तू जड़ी मिंजो ने बिनती किती थी, तां मैं तेरा सारा कर्ज माफ करी दिता। ");
INSERT INTO bht_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","इस तांई जियां मैं तिजो पर दया किती थी, तियां ही तिजो भी अपणे साथी सेवके दा कर्ज माफ करी देणा चाईदा था?” ");
INSERT INTO bht_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","कने उदे मालिके गुस्से च आई करी उसयो सजा देंणे बालें दे हथे देई दिता, ताकि जालू दीकर सै सारा कर्ज नी भरगा, तालू दीकर उना दे हवाले रे। ");
INSERT INTO bht_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“इयां ही अगर तुसां चे हर कोई अपणे मसीह भाई जो मने ला माफ नी करगा, तां मेरा पिता जड़ा स्वर्गे च है, उनी तुसां जो भी माफ नी करणा।” ");
INSERT INTO bht_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","जालू यीशु ऐ गल्लां बोली बैठा, तां गलील प्रदेशे ला चली गिया; सै यहूदिया प्रदेशे ला निकले कने यरदन खड्डा दे दुज्जे पासे चली गे। ");
INSERT INTO bht_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","कने मते भरी लोक उदे पिच्छे चली पे, कने ओथु यीशुऐ उना सारयां जो ठीक किता। ");
INSERT INTO bht_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","तालू फरीसी उदे बाल आऐ कने उसयो परखणे तांई उसला पुछया, “क्या हर इक छोटिया बजा ला अपणिया घरे बाली जो छडी देणा ठीक है?” ");
INSERT INTO bht_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","उनी जबाब दिता, “तुसां क्या पढ़या नी है, कि जिनी उना जो बणाया है, उनी शुरू ला ही नर कने नारी बणाई करी, बोलया। ");
INSERT INTO bht_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","इस बजा ला माणुऐ अपणे माता-पिता ला लग होईकरी अपणिया घरे बालिया सोगी रेणा, कने इना दोनो इक तन होणा? ");
INSERT INTO bht_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","कने सै दोनो हुण इक तन न, क्योंकि हुण सै दो जणे नी, पर इक माणुऐ सांई न। इस तांई उसा जनानिया कने मर्दे जो बख नी करणा चाईदा जिना जो परमेश्वरे बियाह दे बंधना च बनया है।” ");
INSERT INTO bht_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","उना यीशुऐ ने बोलया, “फिरी मूसा ऐ कजो बणाया, कि उसा जो तलाक देईकरी छडी दिया?” ");
INSERT INTO bht_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","यीशुऐ उना ने बोलया, “मूसा तुहाड़े मने दिया कठोरता दिया बजा ला तुहांजो अपणिया घरे बालिया जो छडी देंणे दा हुकम दिता, पर शुरू च ऐसा नी था। ");
INSERT INTO bht_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","मैं तुसां ने बोलदा है, कि जड़ा कोई व्यभिचार जो छडी करी कुसा होरसी बजा ने अपणिया घरे बालिया जो छडी करी दुईया ने बियाह करे, तां सै व्यभिचार करदा है।” ");
INSERT INTO bht_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","चेलयां उसने बोलया, “अगर मरदे दा जनानिया सोगी ऐसा रिश्ता है, तां बियाह नी करणा ही ठीक है।” ");
INSERT INTO bht_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","उनी उना ने बोलया, “सारे ऐ बचन ग्रहण नी करी सकदे, सिर्फ सै ही जिना जो परमेश्वरे इस तरीके ने जिन्दगी जिणे दी शक्ति दितयो है। ");
INSERT INTO bht_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","क्योंकि कुछ नपुंसक ऐसे न जड़े माऊ दे पेटे ला ही ऐसे न; कने कुछ नपुंसक ऐसे न, जिना जो माणुआं नपुंसक बणाया है: कने कुछ नपुंसक ऐसे न, जिना अपणे आपे जो स्वर्गे दे राज्य तांई नपुंसक बणाया है, जड़े इसयो समझी सकदे न, सै समझी लिया।” ");
INSERT INTO bht_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","तालू लोक बचयां जो उदे बाल लेईकरी आऐ, ताकि सै उना पर हथ रखे कने प्राथना करे; पर चेलयां उना जो झिड़कां दीतियां। ");
INSERT INTO bht_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","यीशुऐ बोलया, “बचयां जो मना मत करा कने इना जो मेरे बाल ओणा दिया, जड़े इना बचयां सांई भरोसेमदं न उना स्वर्गे दे राज्य च रेणा।” ");
INSERT INTO bht_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","कने सै उना पर हथ रखीकरी, ओथु ला चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","इक माणुऐ यीशुऐ बाल आई करी बोलया, “गुरू जी, मैं कुण दिया भला कम्म करे, ताकि मिंजो हमेशा दी जिन्दगी मिल्ले?” ");
INSERT INTO bht_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","यीशुऐ उसयो बोलया, “तू मिंजो ला भलाईया दे बारे च कजो पूछा दा है? भला ता इक ही है; पर अगर तू हमेशा दिया जिन्दगिया च प्रवेश करणा चांदा है, तां तू हुकमा जो मना कर।” ");
INSERT INTO bht_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","उनी उसला पुछया, “कुण दे हुकम?” यीशुऐ बोलया, “ऐ कि हत्या नी करणी, व्यभिचार नी करणा, चोरी नी करणी, झूठी गबाई नी देंणी; ");
INSERT INTO bht_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","अपणे माता पिता दी इज्जत करणी, कने अपणे पड़ोसियां सोगी अपणयां सांई प्यार रखणा।” ");
INSERT INTO bht_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","उनी मुंडे यीशुऐ जो बोलया, “इना सारियां गल्लां जो तां मैं मनदा है, हुण मिंजो च कुसा गल्लां दी कमी है?” ");
INSERT INTO bht_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","यीशुऐ उसयो बोलया, “अगर तू सिद्ध होणा चांदा है, तां जा कने जड़ा कुछ तेरा है उसयो बेची करी गरीबां जो देई दे, तां तिजो स्वर्गे दा धन मिलणा, इयां करणे बाद आ कने मेरा चेला बणिया।” ");
INSERT INTO bht_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","पर ऐ गल्ल सुणीकरी उस जवान मुंडे दे चेहरे पर उदासी छाई गेई, कने सै दुखी होइ करी चली गिया, क्योंकि सै बड़ा भरी अमीर था। ");
INSERT INTO bht_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","तालू यीशुऐ अपणे चेलयां जो बोलया, “मैं तुसां ने सच्च बोलदा है, कि अमीरां दा स्वर्गे दे राज्य च जाणा बड़ा मुशकिल है। ");
INSERT INTO bht_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ऊंटे दा सुइया दे नके चे निकलना असान है, पर अमीरां दा परमेश्वरे दे राज्य च जाणा बड़ा भरी मुशकिल है। ");
INSERT INTO bht_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ऐ सुणीकरी चेले बड़े हेरान होईकरी बोलया, तां कुण अपणे पापां दी सजा मिलणे ला बची सकदा है?” ");
INSERT INTO bht_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","यीशुऐ उना दे पासे दिखीकरी बोलया, “जड़ा माणु नी करी सकदे, पर परमेश्वरे सब कुछ करी सकदा है।” ");
INSERT INTO bht_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","तालू पतरसे यीशुऐ जो बोलया, “दिख, असां तां सारा कुछ छडी करी तेरे पिच्छे आयो न: तां सांझो क्या मिलणा है?” ");
INSERT INTO bht_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","यीशुऐ उना जो बोलया, “मैं तुसां ने सच्च बोलदा है, कि नोऐ संसारे च जालू माणुऐ दे पुत्रे अपणिया महिमा दे सिंहासने पर बोंणा है, तां तुसां भी जड़े मेरे पिच्छे आयो न, बाहरां सिंहासना पर बेईकरी इस्राएले दे बाहरां गोत्रों दा नयाय करणा है।” ");
INSERT INTO bht_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“कने जिनी घरां जो या भाई, बेहणा जो या माता-पिता जो या बाल-बच्यां जो या खेतरां जो मेरे नाऐ तांई छडी दितया है, उसयो सो गुणा मिलणा, कने सै हमेशा दिया जिन्दगिया दा अधिकारी होणा। ");
INSERT INTO bht_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","पर मते लोक जड़े हुण महान कने अग्गे न, उसी बकते सै पीच्छे होणे, कने जड़े पीच्छे न, सै उसी बकते पेहले होणे न।” ");
INSERT INTO bht_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","स्वर्गे दा राज्य इसा कहाणिया सांई है, इक जमींदार था, सै ब्यागा निकलया, ताकि अपणे अंगूरा दे बागे च कम्म करणे तांई मजदुरां जो लगां। ");
INSERT INTO bht_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","कने उनी मजदुरां ने इक रोज कम्म करणे तांई इक मजदूरी रखी, अपणे अंगूरा दे बागे च कम्म करणे तांई भेजया। ");
INSERT INTO bht_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","फिरी कोई नौ कि बजे ब्यागा निकली करी, होर लोकां जो बजारे च बेकार खड़ुतयो दिखया, ");
INSERT INTO bht_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","कने उना जो बोलया, “तुसां भी अंगूरा दे बागे च जा, कने जड़ा ठीक है, सै तुहांजो दिंगा।” तां सै भी कम्म करणे तांई गे। ");
INSERT INTO bht_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","फिरी उनी दोपहर कने संझा तिन्न बजे भी निकली करी तियां ही किता। ");
INSERT INTO bht_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","कने लगभग पंज कि बजे निकली करी होरां जो खड़ोतया दिखया, कने उना जो बोलया, “तुसां कजो ऐथू दिन भर बेकार खड़ोई रेंदे?” उना उसया बोलया, “इस तांई, कि कुनी भी सांझो मजदूरिया च नी लाया।” ");
INSERT INTO bht_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","उनी उना जो बोलया, “तुसां भी अंगूरा दे बागे च कम्म करणा जा।” ");
INSERT INTO bht_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","संझा जो अंगूरा दे बागे दे मालिके अपणे भण्डारिये जो बोलया, “मजदुरां जो सदीकरी जड़े सारयां ला आखिर च आयो उना ला लेईकरी जड़े सारयां ला पेहले कम्म करणा आयो मजदुरां जो उना दी मजदूरी देई दे।” ");
INSERT INTO bht_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","जालू सै आऐ जड़े पंज बजे कम्मे पर लगयो थे, तां उना जो इक दिने दी दिहाड़ी इक दीनार मिली। ");
INSERT INTO bht_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","जड़े पेहले आयो थे उना ऐ समझया, कि सांझो जादा मिलणा पर उना जो भी इक दिने दी दिहाड़ी इक दीनार ही मिली। ");
INSERT INTO bht_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","जालू उना जो इक दिनार मिला, तां सै घरे दे मालिके उपर बुड़बुड़ाणे लग्गे। ");
INSERT INTO bht_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","कि जड़े संझा दे पंज बजे आये कने इक ही घंटा कम्म किता, तू उना जो भी उतनी ही दिहाड़ी दिती जितनी तू सांझो दिती, असां दिन भर भार चुक्या कने धुप खादी? ");
INSERT INTO bht_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","तालू बगीचे दे मालिके उना चे इकी जो जबाब दिता, “कि हे मित्र, मैं तिजो ने कोई गलत नी करा दा। क्या मैं तिजो पुरे दिन कम्म करणे दा इक दीनार नी बोलया था? ");
INSERT INTO bht_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","जड़ी दिहाड़ी तेरी है, सै ले कने चली जा; मेरी मर्जी ऐ है कि जितणा मैं तिजो दें, उतणा ही इस इक घंटा कम्म करणे बाले जो भी दें। ");
INSERT INTO bht_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","मिंजो हक है कि मैं अपणे पैसे जो अपणिया मरजिया ने खर्ची सके। तिजो जलन नी होणा चाईदी कि मैं दुजयाँ तांई दयालु है। ");
INSERT INTO bht_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","पर मते लोक जड़े हुण महान कने अग्गे न, उसी बकते सै पीच्छे होणे, कने जड़े पीच्छे न, सै उसी बकते पेहले होणे न।” ");
INSERT INTO bht_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","यीशु यरूशलेम शेहरे जो जांदे बेले बाहरां चेलयां जो एकांत च लेई गिया, कने रस्ते च उना ने बोलणा लगा। ");
INSERT INTO bht_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“दिखा, ध्याने ने सुणा, असां यरूशलेम चलयो न, कने मैं माणुऐ दा पुत्र बड्डे याजकां कने यहूदी व्यवस्था जो सिखाणे बालयां दे हथे पकड़ाया जाणा है, कने उना मिंजो मौत दी सजा देणी है। ");
INSERT INTO bht_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","कने होर जातियां दे हथे देई देणा है। कने उना मेरा मजाक उड़ाणा है, मिंजो पर थुकणा, कने मिंजो कोड़े मारणे, कने मिंजो सूली पर चढ़ाई करी मारी देणा है, कने मैं तिजे दिने मरयां चे जिंदे होई जाणा है।” ");
INSERT INTO bht_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","तालू जब्दी दे पुत्रां दिया माऊ अपणे बचयां सोगी उदे बाल आई करी उसयो नमस्ते किते, कने उसला कुछ मंगणा लग्गी। ");
INSERT INTO bht_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","यीशुऐ उसा जो बोलया, “तू क्या चांहदी है?” उना उसयो बोलया, “ऐ बचन दे, कि मेरे ऐ दोनो पुत्र तेरे राज्य च, इक तेरे सजे पासे कने इक खबे पासे बेई सकन।” ");
INSERT INTO bht_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","यीशुऐ जबाब दिता, “तुसां जो नी पता कि तुसां क्या मंगा दे? हुण जड़े दुख मैं सेहणे न, क्या तुसां उना दुखां जो सेहन करी सकदे न?” उना उसने बोलया, “हाँ करी सकदे न।” ");
INSERT INTO bht_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","यीशुऐ उना जो बोलया, “तुसां भी सारे दुख सेहणे न, जियां मैं सेहणे। पर अपणे सजे कने खबे पासे बठैलना मेरा कम्म नी है, पर जिना तांई मेरे पिता दिया तरफा ला तैयार कितया है, उना तांई ही न।” ");
INSERT INTO bht_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ऐ सुणीकरी बाकी दसो चेले याकूब कने यूहन्ना पर गुस्सा करणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","तां यीशुऐ उना जो अपणे बाल सदीकरी बोलया, “तुहांजो पता है ना, कि जड़े लोक प्रधान मने जादें थे, सै अपणे अधिकारां दा इस्तेमाल अपणे अधीन लोकां दे उपर हक जमाणे तांई करदे न। उना दे अगुवे लोक अपणी गल्ल मनाणे तांई हक जतांदे न। ");
INSERT INTO bht_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","तुसां चे जड़ा महान बणना चांदा है, उसयो बाकियां दी सेबा करणी चाईदी। ");
INSERT INTO bht_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","कने जड़ा कोई तुसां चे प्रधान बणना चांदा हो, सै सारायां दा नौकर बणे। ");
INSERT INTO bht_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","मैं ऐ इस तांई बोलदा है क्योंकि मैं माणुऐ दा पुत्र, इस संसारे च सारयां दी सेबा करणे तांई आया है, मैं इस तांई नी आया कि लोकां ला अपणी सेबा करां। मैं तां लोकां जो पापां ला छुटकारा कराणे तांई अपणे प्राण कीमत च देणा आया है।” ");
INSERT INTO bht_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","जालू सै यरीहो शेहरे ला निकला दे थे, तां इक बड़ी बडी भीड़ उदे पिच्छे चली पेई। ");
INSERT INTO bht_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","दो अन्ने, जड़े सड़का बखे बैठयो थे, ऐ सुणीकरी कि यीशु जा दा है, पुकारी करी बोलणा लग्गे, “हे प्रभु, दाऊदे दे बंशज, सांझो पर दया कर।” ");
INSERT INTO bht_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","लोकां उना जो झिड़कां दितियां, कि चुप रिया, पर सै होर भी जोरे ने चीलाई करी बोलणा लग्गे, “हे प्रभु, दाऊदे दी ओलाद, सांझो पर दया कर।” ");
INSERT INTO bht_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","तालू यीशुऐ खड़ोई करी, उना जो सदया, कने बोलया, “तुसां क्या चांदे न कि मैं तुहाड़े तांई करे?” ");
INSERT INTO bht_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","उना उसने बोलया, “प्रभु जी, ऐ कि साड़ियां हखी खुली जांन।” ");
INSERT INTO bht_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","यीशुऐ तरस खाई करी उना दियां हखी छूतियां, कने उना जो झट मिलणा लगी पिया, कने सै उदे पिच्छे चली पै। ");
INSERT INTO bht_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","जालू सै यरूशलेम दे बखे पुज्जे कने जैतून रुखां दे पाहड़े पर बैतफगे जगा च आऐ, तां यीशुऐ दो चेलयां जो ऐ बोली करी भेजया, ");
INSERT INTO bht_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“अपणे सामणे बाले ग्रां च जा, ओथु पुजदे ही इक गधी बनियो होणी कने सोगी उसा दा बच्चा भी बनया होंणा। उना जो खोली करी मेरे बाल लेई ओआ। ");
INSERT INTO bht_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","अगर कोई तुहांजो ला पुच्छे, कि ऐ क्या करा दे न? तां बोलनयो, कि साड़े प्रभु जो इदी जरूरत है, कने उनी माणुऐ तुसां जो लेई जाणा देणा है।” ");
INSERT INTO bht_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ऐ इस तांई होया, कि जड़ा बचन परमेश्वरे दा संदेश देणेबाले बोलया था, सै पूरा हो: ");
INSERT INTO bht_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सिय्योन दिया कुड़िया ने बोला, दिख, तेरा राजा तेरे बाल ओआ दा है; सै नम्र है, कने गधे पर बैठया है; मतलब कि लादूऐ दे बच्चे पर बेईकरी ओआ दा है।” ");
INSERT INTO bht_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","चेलयां जाई करी, तियां ही किता, जियां यीशुऐ उना ने बोलया था। ");
INSERT INTO bht_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","गधी कने उसा दा बच्चा लांदा कने उना पर अपणे कपड़े बछाई दिते, कने यीशु उस पर बेई गिया। ");
INSERT INTO bht_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","कने मते लोकां अपणे कपड़े रस्ते च बछाऐ, कने केई लोकां रुखा जो छांगी करी डालियाँ रस्ते च बछाईयां। ");
INSERT INTO bht_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","कने थोड़े लोक यीशु दे अग्गे-अग्गे चलयो थे, कने थोड़े लोक पिच्छे चलयो थे, सै सारे खुशिया ने बोला दे थे, “दाऊदे दे बंशज दी होशाना; धन्य सै जड़ा प्रभु दे नाऐ ने ओंदा है, स्वर्ग च होशाना।” ");
INSERT INTO bht_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","जालू यीशु यरूशलेम शेहरे च पुज्जा, तां सारे नगरे च हिल पेई गेई, कने लोक बोलणा लग्गे, “ऐ कुण है?” ");
INSERT INTO bht_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","लोकां बोलया, “ऐ गलीले प्रदेश दे नासरते ग्रां दा परमेश्वरे दा संदेश देणेबाला यीशु है।” ");
INSERT INTO bht_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","यीशुऐ परमेश्वरे दे मंदरे च जाई करी व्यपारी लोकां जो मंदरे ला कडी दिता, जड़े ओथु जानवर कने चिजां खरीदणे बचने दा कम्म करा दे थे। कने पेसे बदलने बाले साहुकारां दे मेज पलटी दिते, कने कबुतरां जो बेचणे बालयां दियां चौकियाँ जो बाहर सुटी दिता। ");
INSERT INTO bht_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","कने यीशुऐ उना जो बोलया, पबित्र शास्त्र ऐ बोलदा है कि, “लोक मेरे घरे जो प्राथना दा घर बोलदे न, जिथू सारे लोक प्राथना तांई ओंदे न? पर तुसां तां इसयो डाकुआं ने भरुईयो गुफा सांई बणाई दितया है।” ");
INSERT INTO bht_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","तालू अन्ने कने लंगड़े, मंदरे च उदे बाल आये, कने यीशुऐ उना जो खरा करी दिता। ");
INSERT INTO bht_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","पर जालू बड्डे याजकां कने व्यवस्था जो सिखाणे बालयां इना अनोखे कम्मा जो दिखया, जड़े यीशुऐ किते कने मंदरे च जागतां जो दाऊदे दे बंशजे जो होशाना बोलदे सुणया, तां सै गुस्सा होई गे, ");
INSERT INTO bht_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","कने उसयो बोलणा लग्गे, “तू क्या सुंणा दा है कि ऐ क्या बोला दे न?” यीशुऐ उना ने बोलया, “हाँ; तुसां क्या ऐ कदी नी पढ़या की: जागतां कने दूध पिंदे बचयां दे मुऐ ला तू स्तुति कराई?” ");
INSERT INTO bht_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","तालू सै उना जो छडी करी नगरे दे बाहर बैतनिय्याह ग्रां जो गिया, कने ओथु रात बिताई। ");
INSERT INTO bht_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ब्यागा जालू सै नगरे जो बापस ओआ दा था, तालू यीशुऐ जो भूख लग्गी। ");
INSERT INTO bht_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","सड़का बखे अंजीर दा इक रुख दिखया, कने सै उस बाल गिया, कने उस रुखे च पतयां जो छडी करी होर कुछ नी था, उनी उसयो बोलया, “हुण तिजो पर कदी फल नी लगणे न।” कने अंजीरे दा रुख झट सुकी गिया। ");
INSERT INTO bht_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ऐ दिखीकरी चेले बड़े हेरान होए, कने बोलणा लग्गे, “ऐ अंजीरे दा रुख झट कियां सुकी गिया?” ");
INSERT INTO bht_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","यीशुऐ उना जो जबाब दिता, “मैं तुसां ने सच्च बोलदा है; अगर तुसां भरोसा रखन, कने शक नी करन; तां सिर्फ तुसां ऐ नी करणा जड़ा इस अंजीरे दे रुखे ने किता है, अगर तुसां इस पाहड़े जो भी बोलगे कि ऐथू ला पुटुई जा, कने समुंद्रे च जाई पो, तां ऐ होई जाणा।” ");
INSERT INTO bht_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“कने जड़े कुछ तुसां प्राथना च भरोसे ने मंगगे सै सारा कुछ तुसां जो मिलणा।” ");
INSERT INTO bht_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","सै मंदरे च जाई करी उपदेश करा दा था, तां बड्डे याजकां कने यहूदी व्यवस्था जो सिखाणे बालयां कने यहूदी अगुवे उदे बाल आये कने उसयो पुछणा लग्गे, “तू ऐ कम्म कुसदे अधिकारे ला करदा है? कने तिजो ऐ हक कुनी दितया है?” ");
INSERT INTO bht_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","यीशुऐ उना जो जबाब दिता, “मैं भी तुहांजो ला इक गल्ल पूछदा है, अगर तुसां मिंजो जबाब दिंगे, तां मैं दसगा कि ऐ कम्म मैं कुसी हके ने करदा है। ");
INSERT INTO bht_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","यूहन्ना जो लोकां जो बपतिस्मा देणे तांई कुनी भेजया था? क्या सै परमेश्वरे भेजया था या माणुऐ? मिंजो दसा।” तालू सै अपु चे बोलणा लग्गे कि अगर असां बोलया कि, “परमेश्वर जड़ा स्वर्गे च है उनी भेजया है, तां यीशुऐ सांझो ला पुछणा, कि तुसां युहन्ना पर भरोसा कन्नी किता?” ");
INSERT INTO bht_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","कने अगर बोलन माणुऐ दिया तरफा ला तां सांझो भीड़ा दा डर है, क्योंकि सै उना लोकां ला डरदे थे, जड़े यूहन्ना जो परमेश्वर दे पासे ला आया इक सच्चा परमेश्वरे दा संदेश देणेबाला मंदे थे। ");
INSERT INTO bht_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","उना यीशुऐ जो जबाब दिता, “असां नी जाणदे।” यीशुऐ भी उना जो बोलया, “तां मैं भी तुहांजो नी दसणा, कि ऐ कम्म मैं कुस हके ने करदा है।” ");
INSERT INTO bht_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“तुसां इसा कहाणिया ला क्या सोचदे कने समझदे न? कुसी माणुऐ दे दो जागत थे; उनी पेहले बाल जाई करी बोलया, अज अंगूरा दे बागे च जाई करी कम्म कर।” ");
INSERT INTO bht_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","उनी जबाब दिता, मैं नी जाणा, पर बादे च उसयो पछताबा होया कने फिरी चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","फिरी दुज्जे बाल जाई करी इयां ही बोलया, उनी जबाब दिता, जी हाँ मैं जांदा है, पर सै गिया नी। ");
INSERT INTO bht_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","इना दोना चे कुनी परमेश्वरे दी इच्छा पुरी किती है? उना बोलया, “पेहले बाले।” यीशुऐ उना ने बोलया, “मैं तुसां ने सच्च बोलदा है, कि कर लेणेबाले कने वेश्यां तुहांजो ला पेहले परमेश्वरे दे राज्य च प्रवेश करणा है। ");
INSERT INTO bht_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","मैं ऐ इस तांई बोलया क्योंकि जालू यूहन्ना बपतिस्मा देणेबाले तुहांजो दसया कि कियां सही तरीके ने जीणा है, कने तुसां उदा भरोसा नी किता। पर कर लेंणे बालयां कने वेश्यां अपणे पापां जो छडी दिता कने उदा भरोसा किता: कने तुसां ऐ दिखीकरी बादे च भी नी पछताय कि उदा भरोसा करी लेंदे।” ");
INSERT INTO bht_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“इक होर कहाणी सुंणा: इक माणुऐ बागे च अंगूर लाये। उनी बागे दे चारों पासे बाड़ लगवाया, कने इक जगा अंगूरा दे रसे जो निचोड़ने तांई बणाई, कने निगरानी रखणे तांई इक उचिया जगा पर कमरा बणाया। फिरी उनी बागे जो कुछ किसाना जो ठेके पर देई दिता, कने परदेस जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","फिरी जालू अंगूर पक्की गे, तां उनी अपणे नोकरां जो ठेकेदारे बाल अपणा अंगूरा दे बागे दा हिस्सा लोंणे तांई भेजया। ");
INSERT INTO bht_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","पर ठेकेदारां उदे नोकरां जो पकड़ी करी, कोई कूटया, कोई मारी दिता; कने केईयां जो पथरा ने मारया। ");
INSERT INTO bht_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","फिरी उनी पेहले ला भी जादा होर नोकरां जो भेजया, कने उना ठेकेदारां उना सोगी भी तियां ही किता। ");
INSERT INTO bht_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","आखरी च उनी अपणे पुत्रे जो उना बाल ऐ सोची करी भेजया, कि उना मेरे पुत्रे दी इज्जत करणी। ");
INSERT INTO bht_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","पर ठेकेदारां पुत्रे जो दिखीकरी अपु चे बोलया कि, ऐ तां वारिस है, ओआ असां इसयो मारी दिन्दे न, कने इदी सारी जगा जमीन साड़ी होई जाणी। ");
INSERT INTO bht_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","कने उना उसयो पकड़या कने अंगूरा दे बागे ला बार कडी करी मारी दिता। ");
INSERT INTO bht_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","इस तांई कि जालू अंगूरा दे बागे दा मालिक ओंगा तां, तां सै ठेकेदारां सोगी क्या करगा?” ");
INSERT INTO bht_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","उना उसने बोलया, “उनी उना बुरे लोकां जो बुरे तरीके ने खत्म करी देणा; कने अंगूरा दे बागे दा ठेका होर किसाना जो देई देणा, जड़े उसयो बकते पर फल दिंगे।” ");
INSERT INTO bht_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","यीशुऐ उना ने बोलया, “तुसां क्या कदी पबित्र शास्त्रां च ऐ नी पढ़या: जिस पथरे जो राजमिस्त्रियां बेकार बोलया था, सै ही पथर कुंणे च सिरे दा पथर बणया? ऐ प्रभु दिया तरफा ला होया, पर साड़िया नजरा च अनोखा है।” ");
INSERT INTO bht_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","इस तांई मैं तुसां ने बोलदा है, कि परमेश्वरे दा राज्य तुहांजो ला लेई लेंणा है, कने ऐसे लोका जो देई देणा है जड़े सै ही करगे जड़ा परमेश्वर चादां है। ");
INSERT INTO bht_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“जड़ा इस पथरे पर पोंगा, उदा चूर भुर होई जांणा; जिदे पर सै पथर पोंगा, उसयो पि सड़ना उनी।” ");
INSERT INTO bht_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","बड्डे याजकां कने फरीसी उदिया इसा कहाणिया जो सुणीकरी समझी गे, कि सै साड़े बारे च बोला दा है। ");
INSERT INTO bht_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","कने सै उसयो पकड़ना चांदे थे पर लोकां ला डरी गे क्योंकि सै उसयो परमेश्वरे दा संदेश देणेबाला मंदे थे। ");
INSERT INTO bht_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","यीशुऐ फिरी उना जो कहाणी सुणाई, ");
INSERT INTO bht_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“स्वर्गे दा राज्य इक कहाणिया सांई है, इक राजा था जिनी अपणे पुत्रे दा बियाह किता।” ");
INSERT INTO bht_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","उनी अपणे नोकरां जो भेजया कि जिना जो नियुंद्र दितियो उना लोकां जो बियाह दिया धामा च सदा; पर सै कोई ओणा नी चांदे थे। ");
INSERT INTO bht_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“फिरी उनी होर नोकरां जो ऐ बोली करी भेजया, कि नियुंद्र दितियो लोकां ने बोला: दिखा मैं धाम तैयार करी दितियो है, कने सारा कुछ तैयार है; कने तुसां बियाये दिया धामा च ओआ। ");
INSERT INTO bht_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","पर सै बहाना लाइ करी चली गे: कोई अपणे खेतरां जो, कोई अपणे कम्म धंधे जो। ");
INSERT INTO bht_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","बाकी लोक जड़े बचा थे उना नोकरां जो पकड़ी करी उना दा अनादर किता कने मारी दिता। ");
INSERT INTO bht_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","जालू राजे ऐ सुणया तालू राजे जो गुस्सा आया, कने उनी अपणी सेना भेजी करी उना हत्यारां जो मरवाया, कने उना दे शेहरे जो फुकी दिता। ");
INSERT INTO bht_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","तालू उनी अपणे नोकरां ने बोलया, बियाये दी धाम तां तैयार है, पर सदयो लोक खांणे जोगे नी न। ");
INSERT INTO bht_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","इस तांई तुसां हर जगा जा, कने जितणे भी लोक तुसां जो मिलन, सबना जो बियाये दिया धामा तांई सदी लोआ। ");
INSERT INTO bht_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","उना नोकरां हर जगा पर जाई करी क्या बुरे, क्या भले, जितणे भी मिल्ले, सब गठेरे; कने बियाये बाला घर परोंणया ने भरुई गिया। ");
INSERT INTO bht_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","जालू राजा परोंणया जो दिखणे तांई अंदर आया, तां उनी ओथु इक माणुऐ जो दिखया, जिनी बियाये तांई खरे कपड़े नी पायो थे। ");
INSERT INTO bht_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","राजे उसला पुछया, है मित्र, तू बिना बियाये दे नोऐ कपड़े पाई करी ऐथू कजो आया? कने सै चुप होई गिया। ");
INSERT INTO bht_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","तालू राजे नोकरां ने बोलया, इदे हथ-पैर बन्नी करी इसयो काल कोठढी च पाई दिया, ओथु उनी रोणा कने, दंद पीणे। ");
INSERT INTO bht_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","क्योंकि परमेश्वरे मते लोकां जो अपणे बाल सदया है पर थोड़े ही न जड़े चुंणयो न।” ");
INSERT INTO bht_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","तालू फरीसियां जाई करी अपु चे बिचार किता, कि उसयो कुस तरीके ने गल्लां च फसान। ");
INSERT INTO bht_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","उना अपणे चेलयां जो हेरोदियां सोगी उदे बाल ऐ बोलणे जो भेजया, “गुरू जी, असां जो पता है कि तुसां हमेशा सच्च बोलदे न, कने परमेश्वरे दा रस्ता सच्चाईया ने दसदा है, कने कुदी भी परवाह नी करदे न, क्योंकि तू माणुऐ दा मुऐ दिखीकरी गल्ल नी करदा है। ");
INSERT INTO bht_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","इस तांई सांझो दस कि तू क्या सोचदा है? महाराजा जो कर देणा ठीक है, कि गलत है।” ");
INSERT INTO bht_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","यीशुऐ उना दी बुराई जाणी करी बोलया, “है कपटियों, मिंजो कजो परखदे न?” ");
INSERT INTO bht_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","करे दा सिक्का मिंजो दसा। “तालू सै उदे बाल इक दीनार लेई आये।” ");
INSERT INTO bht_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","उनी, उना ला पुछया, “ऐ आकृति कने ना कुसदा है?” ");
INSERT INTO bht_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","उना उसने बोलया, महाराजा दा। तालू उनी उना जो बोलया, “जड़ा महाराजा दा है, सै महाराजा जो, कने जड़ा परमेश्वरे दा है, सै परमेश्वरे जो दिया।” ");
INSERT INTO bht_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ऐ सुणीकरी सै हेरान होये, कने उसयो छडी करी चली गे। ");
INSERT INTO bht_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","उसी रोजे सदूकी जड़े बोलदे थे कि मरयां दा जिन्दा होणा है ही नी सै यीशुऐ बाल आऐ, कने उसला पुछया, ");
INSERT INTO bht_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“गुरू जी, मूसा बोलया था, कि अगर कोई बिना ओलादी मरी जा, तां उदा भाई उदिया घरे बालिया ने बियाह करी के अपणे भाई तांई बंश पैदा करे। ");
INSERT INTO bht_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","हुण साड़े ऐथू सत भाई थे; पेहला भाई बियाह करिके मरी गिया; कने ओलाद नी होणे दिया बजा ने अपणिया घरे बालिया जो अपणे भाईऐ तांई छडी गिया। ");
INSERT INTO bht_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","तां दुऐ भाईऐ उसा ने ही बियाह करी लिया कने से भी बिना ओलादी मरी गिया, कने इयां ही तिजे भाई ने होया कने सतां भाईयां उसा ने बियाह किता कने सतो भाई बिना ओलादी मरी गे। ");
INSERT INTO bht_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","सबना दे बाद सै जनानी भी मरी गेई। ");
INSERT INTO bht_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","हुण, सांझो दस सतां भाईयां उसा जनानिया ने बियाह कितया था, जालू सै मरणे दे बाद फिरी जिन्दे होंगे, तां सै जनानी कुदी घरे बाली होणी?” ");
INSERT INTO bht_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","यीशुऐ उना जो बोलया, “तुसां दो बजा ने गलत न, तुसां पबित्र शास्त्र जो नी जाणदे ने जड़ा मरणे दे बाद लोकां जो जिन्दा रेणे दे बारे च दसदा है। तुसां ऐ नी जाणदे कि परमेश्वर बाल मरे होये लोकां जो जिन्दा करणे दी शक्ति है।” ");
INSERT INTO bht_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","क्योंकि जालू उना मरयां चे जिन्दा होणा, तां उना लोका दे बियाह नी होणे; जियां स्वर्गे च रेणेबाले स्वर्गदूत बियाह नी करदे। ");
INSERT INTO bht_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“मरयां चे जिन्दा होणे दे बारे तुसां क्या मूसा दिया कताबां च नी पढ़या जड़ा परमेश्वरे तुसां जो बोलया: ");
INSERT INTO bht_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","मैं अब्राहम दा परमेश्वर, कने इसहाक दा परमेश्वर, कने याकूब दा परमेश्वर है? सै मरयां दा नी, पर जिन्दया दा परमेश्वर है।” ");
INSERT INTO bht_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ऐ सुणीकरी लोक उदे उपदेशे ला हेरान होए। ");
INSERT INTO bht_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","जालू फरीसियां सुंणया कि यीशुऐ सदूकियां दा मु बंद करी दितया है, तां सै गिठे होए। ");
INSERT INTO bht_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","उना चे इकी यहूदी मूसा दी व्यवस्था जो सिखाणे बाले परखणे तांई, यीशुऐ ला पुछया, ");
INSERT INTO bht_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“गुरू जी, परमेश्वरे जड़े भी हुकम दितयो न, उना सारयां चे सारयां ला बडा हुकम कुण दिया है?” ");
INSERT INTO bht_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","उनी उना जो बोलया, “तू अपणे प्रभु परमेश्वर ने अपणे सारे तन मन कने सारे प्राण कने अपणिया सारिया अकला सोगी प्यार कर।” ");
INSERT INTO bht_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","सारयां ला बडा कने मुख्य हुकम तां ऐ ही है। ");
INSERT INTO bht_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","कने उस सांई ऐ दूजा हुकम भी है, कि तू अपणे पड़ोसियां सोगी अपणे सांई प्यार रख। ");
INSERT INTO bht_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","“इना दो हुकमा पर ही सारी व्यवस्था कने भविष्यवाणियां अधारित न।” ");
INSERT INTO bht_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","जालू फरीसी गिठे थे, तां यीशुऐ उना ला पुछया, ");
INSERT INTO bht_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“मसीह दे बारे च तुसां क्या सोचदे न? सै कुदा पुत्र है?” उना यीशुऐ ने बोलया, “दाऊदे दा बंशज।” ");
INSERT INTO bht_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","यीशुऐ उना ला पुछया, “तां दाऊद आत्मा च होईकरी उसयो प्रभु कजो बोलदा है?” ");
INSERT INTO bht_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“प्रभुऐ, मेरे प्रभु ने बोलया, मेर सजे पासे बो, जालू दीकर मैं तेरे दुशमणा जो तेरे पैरां हेठ नी करी दें।” ");
INSERT INTO bht_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“भला, जालू दाऊद ही उसयो प्रभु बोलदा है, तां सै उदा पुत्र कियां होया?” ");
INSERT INTO bht_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","उदे जबाबे च कोई भी कुछ नी बोली सकया। पर उस रोजे ला कुसयो भी फिरी उसला पूछणे दी हिम्मत नी होई। ");
INSERT INTO bht_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","तालू यीशुऐ भिड़ा कने अपणे चेलयां जो बोलया, ");
INSERT INTO bht_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“फरीसियां कने व्यवस्था जो सिखाणे बालयां जो मूसा दिया व्यवस्था दी व्याख्या करणे दा हक है।” ");
INSERT INTO bht_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","इस तांई सै तुसां ने जड़ा कुछ बोलगे सै तुसां करणा कने मनणा, पर जड़ा सै करदे न सै मत करदे; क्योंकि सै उपदेश दा दिन्दे न पर उना दा पालन नी करदे। ");
INSERT INTO bht_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","सै अपु अपणी व्यवस्था दा पालन करणे दी कोशिश भी नी करदे। कने ऐसे नियम बणादे न जिना दा पालन करणा बड़ा मुशकिल है। ");
INSERT INTO bht_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","सै अपणे सारे कम्म लोकां जो दसणे तांई करदे न: सै अपणिया बांई कने मथे पर पट्टियां बनदे न जिना च पबित्र शास्त्र दे बचन लिखयो होंदे न, कने अपणे कपड़यां दियां झालरां बदांदे न। ");
INSERT INTO bht_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","धामा च समानित जगा च बोणा चांदे न, कने यहूदी जंज घर च भी खास-खास आसना पर बोणा पंसद करदे न, ");
INSERT INTO bht_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","बजारां च सारे लोक उना जो नमस्ते कने सारे उना जो गुरू जी बोलन सै उना जो खरा लगदा है। ");
INSERT INTO bht_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","पर तुसां गुरू मत बणदे, क्योंकि तुहाड़ा इक ही गुरू है: कने तुसां सारे भाई-बेहणा सांई न। ");
INSERT INTO bht_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","कने अपणे पिता जो छडी करी कुसयो भी धरतिया पर अपणे पिता परमेश्वरे दा आदर मत दिन्दे क्योंकि तुहाड़ा इक ही पिता है, जड़ा स्वर्ग च है। ");
INSERT INTO bht_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","कने कुसी दे गुरू भी मत बणदे, क्योंकि तुहाड़ा इक ही गुरू है, मतलब कि यीशु मसीह। ");
INSERT INTO bht_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","जड़ा तुसां चे बडा है, सै तुहाड़ा सेवक बणे। ");
INSERT INTO bht_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","जड़ा कोई अपणे आपे जो बडा बणांगा, सै नम्र करी देणा: कने जड़ा कोई अपणे आपे जो छोटा बणांगा, सै बडा करी देणा। ");
INSERT INTO bht_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“हे कपटी व्यवस्था जो सिखाणे बाले कने फरीसियों, तुहांजो तांई बड़ा बुरा होणा है। तुसां लोकां जो स्वर्गे दे राज्य च जाणे दी इजाजत नी दिन्दे, ना तां अपु स्वर्गे च जाणा, कने ना तां स्वर्ग जांणे बालयां जो जांणा दिन्दे न।” ");
INSERT INTO bht_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“हे कपटी व्यवस्था जो सिखाणे बालयो कने फरीसियां, तुहांजो तांई बड़ा बुरा होणा है। तुसां धोखे कने वेईमानिया ने विधवां दे घरां दी चिजां पर कब्जा करी लेंदे है। कने लोकां जो दसणे तांई बड़ी देरा दीकर प्राथना करदे न, परमेश्वरे इना जो बड़ी बुरी सजा देणी है।” ");
INSERT INTO bht_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“हे कपटी यहूदी व्यवस्था जो सिखाणे बाले कने फरीसियों, तुहांजो तांई बड़ा बुरा होणा है। तुसां इक जणे जो अपणे भरोसे च लोंणे तांई सारियां जगा च दुरे-दुरे दीकर गुमदे फिरदे रेंदे न, कने जालू सै भरोसे च आई जांदा है, तां उसयो अपणे ला दुगणा नरक जाणे जोगा बणाई दिन्दे न।” ");
INSERT INTO bht_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","हे अन्ने अगुवाई करणे बालयो, तुहांजो तांई बड़ा बुरा होणा है, कि तुसां सिखांदे न कि अगर कोई मंदरे दी कसम खा तां कोई फरक नी है, पर अगर कोई मंदरे दे सोने दी कसम खा तां उदे तांई कसम पूरी करणा जरूरी होई जांदा है। ");
INSERT INTO bht_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","है मूर्खो, कने अन्नयो कुण बडा है, मंदरे दा सोना या सै मंदर जिसला सै सोना पबित्र होंदा है? ");
INSERT INTO bht_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","कने फिरी तुसां ऐ भी सिखांदे न कि अगर कोई वेदी दी कसम खा तां कुछ फर्क नी है, पर जड़ी भेंट उस पर चढ़ाई है, अगर कोई उसा दी कसम खा तां फर्क पोंदा है। ");
INSERT INTO bht_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","हे अन्नयो, कुण बडा है, भेंट या वेदी जिसने भेंट पबित्र होंदी है? ");
INSERT INTO bht_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","इस तांई जड़ा वेदी दी कसम खांदा है, सै उदी कने जड़ा कुछ उसा पर है, उदी भी कसम खांदा है। ");
INSERT INTO bht_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","कने जड़ा मंदरे दी कसम खांदा है, सै उदी कने उदे च रेणेबाले परमेश्वरे दी भी कसम खांदा है। ");
INSERT INTO bht_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","कने जड़ा स्वर्गे दी कसम खांदा है, सै परमेश्वरे दे सिहांसने दी भी कने उस पर बोणे बाले दी भी कसम खांदा है। ");
INSERT INTO bht_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","यहूदी व्यवस्था जो सिखाणे बाले कने फरीसियों, तुहांजो तांई बड़ा बुरा होणा है। तुसां पुदीने, कने सौंफ, कने जीरे, दा तां दसमां हिसा दिन्दे न, पर तुसां व्यवस्था दियां जरूरी गल्लां जो मतलब कि न्याय, कने दया, कने इमानदार होणा छडी दिता है; तुहांजो दशमांश तां दिन्दे रेणा चाईदा था, पर इना गल्लां जो भी नी छडणा चाईदा था। ");
INSERT INTO bht_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","हे अन्ने यहूदी अगुवो, (अगुवाई करणे बाले) तुसां जड़े नियम जरूरी नी न उना जो तां बड़िया साबधानिया ने मंदे न, जियां कि पिंदे बेले माखियाँ जो दूर करदे पर परमेश्वरे दी जरूरी गल्लां जो मंदे नी न! ऐ ऊंटे जो निगलने सांई है। ");
INSERT INTO bht_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“यहूदी व्यवस्था जो सिखाणे बाले कने फरीसियों, तुहांजो तांई बड़ा बुरा होणा है। तुसां ऐसे कटोरे कने भांडे सांई न जड़े तां उपरे-उपरे ला तां साफ न, पर अंदरे ला अजे भी गंदे न। सै ऐ कि, तुसां अपणे आपे जो भले लोकां सांई दसदे न, पर तुहाड़े मन लालची कने मतलबी न।” ");
INSERT INTO bht_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","हे अन्ने फरीसी, पेहले तुसां जो लालची कने मतलबी होणा रोकी देणा चाईदा तां तुसां से ही करी सकणा जड़ा धर्म है। ");
INSERT INTO bht_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“यहूदी व्यवस्था जो सिखाणे बाले कने फरीसियों, तुहांजो तांई बड़ा बुरा होणा है। तुसां तां उना सफेदी कितियां कबरां सांई न जड़ियां उपरे ला तां छेल मिलदियाँ न, पर अंदर मुर्दयां दियां हडियाँ कने हर तरा दियां गंदगिया ने भरूइयां न।” ");
INSERT INTO bht_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","इना कबरां सांई तुसां भी उपरे ला तां माणुऐ जो धर्मी लगदे न, पर तुसां अंदरे ला कपट कने पापां ने भरूयो न। ");
INSERT INTO bht_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“यहूदी व्यवस्था जो सिखाणे बाले कने फरीसियों, तुहांजो तांई बड़ा बुरा होणा है। तुहाड़े पूर्वजां जिना परमेश्वरे दा संदेश देणेबालयां जो मारया था उना दियां कबरां जो सजांदे न कने धर्मी लोकां दियां कबरां जो सम्मानित करदे न।” ");
INSERT INTO bht_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","कने बोलदे न कि, अगर असां अपणे बाप दादयां दे बकते च होंदे तां असां परमेश्वरे दा संदेश देणेबालयां दिया हत्या च हिस्सेदार नी होंदे। ");
INSERT INTO bht_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","इसला तां तुसां अपु ही साबित करदे न कि तुसां उना लोकां दे बंशज न जिना परमेश्वरे दा संदेश देणेबालयां दी हत्या कितियो। ");
INSERT INTO bht_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","तुसां उस बुराईया जो पूरा करणे बाले न जिसयो तुहाड़े पूर्वजां शुरू कितया था। ");
INSERT INTO bht_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","हे जहरीले सप्पां दे बचयां सांई लोको कने करैतों दे बच्चयों, तुसां नरके दिया सजा ला नी बचणा है। ");
INSERT INTO bht_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","इस तांई मैं तुहाड़े बाल परमेश्वरे दा संदेश देणेबालयां जो भेजदा है। कने, बुद्धिमान, कने व्यवस्था जो सिखाणे बालयां जो भेजदा है; तुसां इना चे थोड़यां जो मारी देणा हे, कने केईयां जो सूली पर चढ़ाना कने केईयां जो अपणे यहूदी जंज घर च कोड़े मारणे, कने इकी शेहरे ला दुजे शेहरे जो नठाणे न। ");
INSERT INTO bht_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","धर्मी हाबिल ला लेईकरी बिरिक्याह दे पुत्रे जकर्याह दीकर, जिसयो तुसां मंदरे कने वेदिया दे बिच मारया था, जितणया धर्मियां दी हत्या इसा धरतिया च होईयो है, उना सारयां तांई तुसां जो दोषी बोलणा। ");
INSERT INTO bht_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“मैं तुसां ने सच्च बोलदा है, इना सारियां हत्या दी सजा इस बकते दे लोकां पर आई पोणी है।” ");
INSERT INTO bht_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“यरूशलेम शेहरे दे लोको, हे यरूशलेम दे लोको! तुसां जड़े परमेश्वरे दा संदेश देणेबालयां जो मारी दिन्दे न, कने जीना जो तुहांजो बाल भेजदे न, उना जो पथरा ने मारदे न, कितणी बरी मैं चाया कि जियां मुर्गी अपणे बचयां जो बचाणे तांई फंगा हेठ गिठे करी लेंदी है, तियां ही मैं भी तुसां जो गिठे करी लेणा, पर तुसां नी चांदे कि ऐसा हो।” ");
INSERT INTO bht_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","दिखा, तुहाड़ा मंदर तुहाड़े तांई उजाड़ी छडया है। ");
INSERT INTO bht_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","“क्योंकि मैं तुसां ने बोलदा है, हुणी ला जालू दीकर तुसां नी बोलगे, कि धन्य है सै, जड़ा प्रभु दे अधिकारे ने ओंदा है, तालू दीकर तुसां मिंजो फिरी कदी नी दिखणा है।” ");
INSERT INTO bht_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","जालू यीशु मंदरे ला निकली करी जा दा था, तां उदे चेले उसयो मंदरे दी बनाबटा जो दसणे तांई उदे बाल आये। ");
INSERT INTO bht_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","उनी उना जो बोलया, “क्या तुसां ऐ सारा कुछ दिखा दे न। मैं तुसां ने सच्च बोलदा है, ऐथू इक भी पथरे पर पथर नी रेंणा है, जड़ा ढाया नी जाणा है।” ");
INSERT INTO bht_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","जालू सै जैतून रुखां दे पाहड़े पर बैठया था, तां चेलयां उदे बाल आई करी उसला पुछया, “सांझो दस ऐ सब कुछ कालू होणा है? कने जालू ऐ सब कुछ पूरा होणेबाला होंगा तां उदा क्या निशाण होणा है?” ");
INSERT INTO bht_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","यीशुऐ उना जो जबाब दिता, “ध्यान रख्यो कि तुहांजो कोई भटकाई न दे।” ");
INSERT INTO bht_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","क्योंकि मते सारे लोकां मेरे नाए ने दाबा करिके ओणा है। उना बोलणा है, मैं मसीहा हूँ कने उना मतयां लोकां जो भटकाणा है। ");
INSERT INTO bht_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","जालू तुसां लड़ाईयां, कने लड़ाईयां दियां गल्लां सुणगे तां डरदे मत; क्योंकि इना दा होणा जरूरी है, पर तालू संसारे दा खात्मा नी होणा है। ");
INSERT INTO bht_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","क्योंकि जातियां ने जातियां कने राज्य ने राज्यां ने इक दुजे ने लड़ाईयां करणियां न। कने हर कुथी हिलण होणे न कने अकाल पोणे न। ");
INSERT INTO bht_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ऐ तकलीफ कने दुख इयां होणा जियां इक माँ जो बच्चे दे जन्म देणे दिया शुरूआत च होंदा है। ");
INSERT INTO bht_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“तालू सै लोक जड़े तुहाड़े खिलाफ न, उना तुहांजो दुख देणे तांई पकड़ाई देणा है, कने तुहांजो मारी देणा है, कने सारियां जातियां दे लोकां तुसां ने दुशमणी रखणी है क्योंकि तुसां मिंजो पर भरोसा रखदे न।” ");
INSERT INTO bht_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","तालू मतयां मिंजो पर भरोसा करणा बंद करी देणा, कने इक दुज्जे जो पकड़ाणा कने इक दुजे ने दुशमणी रखणी। ");
INSERT INTO bht_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","मतयां परमेश्वरे दे संदेश देणेबालयां झूठे लोकां ओणा है, कने उना मतयां जो भटकाणा। ");
INSERT INTO bht_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","पाप बदणे दिया बजा ने मतयां इक दुज्जे ला प्यार करणा बंद करी देणा है। ");
INSERT INTO bht_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","पर जड़ा जिंदगी दे अंत दीकर मिंजो पर भरोसा रखगा सै ही बचाया जाणा है। ");
INSERT INTO bht_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","कने स्वर्गे दे राज्य दा ऐ शुभसमाचार दा प्रचार सारे संसारे च करणा है, ताकि सारे देशां दियां सारियां जातियां जो इसयो मनणे दा मोका मिल्ले, तालू अंत होई जाणा है। ");
INSERT INTO bht_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“इस तांई जालू तुसां इक उजाड़ने बाली बड़ी बुरी चिजा जो यरूशलेम मंदिर च खड़ोतयो दिखगे, जिदी चर्चा परमेश्वरे दा संदेश देणेबाले दानिय्येले किती थी, (जड़े पढ़न, सै समझन)।” ");
INSERT INTO bht_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","तालू यहूदिया प्रदेशे दे लोकां जो जान बचाणे तांई पहाड़ा जो नसणा पोणा। ");
INSERT INTO bht_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","जड़े छती पर होंगे, सै अपणे घरे चे समान लेंणे तांई थले मत उतरदे। ");
INSERT INTO bht_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","कने जड़े खेतरां च होंगे, सै अपणे कपड़े लेंणे तांई बापस मत जांदे। ");
INSERT INTO bht_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","उना रोजां च उना जनानिया तांई बड़ा बुरा बकत होणा जड़ियां लैरथियां होणियां न, कने उना जनानियां तांई जड़ियां नियाणे जो दूध पियादियां होंगियां। ");
INSERT INTO bht_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","इस तांई प्राथना करा कि ऐ बुरा बकत सर्दियां दे दिना च या सब्ते दे दिना ना हो, जालू सफर करणा मुशकिल हो। ");
INSERT INTO bht_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","क्योंकि उना दिना लोकां जो बड़े दुख होणे न, जदिया संसार दे शुरू ला हुणे दीकर कदी नी होया कने ना कदी होणा। ");
INSERT INTO bht_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“अगर परमेश्वरे उसी बुरे बकते जो नी घटादां, तां कोई भी माणु नी बचदा। पर उना चुणयो होए लोकां दिया बजा ला, जिना जो परमेश्वरे चुणयां है, बकत घटणा है।” ");
INSERT INTO bht_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“उस बेले तुसां जो कोई बोले, कि दिखा, मसीह ऐथू है! या ओथु है! तां भरोसा मत करदे।” ");
INSERT INTO bht_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","क्योंकि झूठे मसीह कने परमेश्वरे दा संदेश देणेबाले झूठे लोकां मतयां ओणा है, कने उना बड़े चमत्कार कने अनोखे कम्म दसणे न, ताकि होई सके तां जड़े चुंणयो न उना जो भटकाई देंन। ");
INSERT INTO bht_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","मैं पेहले ला ही तुसां ने ऐ सब कुछ बोली दिता है। ");
INSERT INTO bht_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","इस तांई अगर सै तुसां ने बोलन, कि दिखा, सै सुनसान जगा च है, तां बाहर मत निकलदे; दिखा, सै कोठढ़ियां च है, तां भरोसा मत करदे। ");
INSERT INTO bht_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","क्योंकि जियां बिजली पूर्व ला निकली करी पश्चिम दीकर चमकदी जांदी है, तियां ही माणुऐ दे पुत्रे भी ओंणा है। ");
INSERT INTO bht_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“जिथू लाश होऐ, ओथु ही इल्लां गिठियां होणा है।” ");
INSERT INTO bht_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“उना दिना च, बुरा कने दुखे बाल बकत मुकी जाणे दे बाद, सूरजे च अंधेरा होई जाणा, कने चद्रमें रौशनी नी देणी। अम्बरे ला तारायां पेई जाणा, कने अम्बरे दियां शक्तियाँ हिलाईयां जाणियां।” ");
INSERT INTO bht_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“तालू मैं, माणुऐ दे पुत्रे दा निशाण अम्बरे च मिलणा, तालू धरतिया दे सारे कुलां दे लोकां छाती पिटणी; कने माणुऐ दे पुत्रे जो बड़े सामर्थ्य कने महिमा सोगी बदलां पर ओंदे दिखणा।” ");
INSERT INTO bht_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","“उनी तुरही दी जोरे दिया अबाजा ने अपणे स्वर्गदूतां जो भेजणा है, ताकि सै उना सारे लोकां जो गठेरी करी, जिना जो मैं चुणयां है कने उना संसारे दे चारों पासयां ला लोका जो गठेरणा है।” ");
INSERT INTO bht_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“अंजीर दे रुखे दिया कहाणिया ला ऐ सिखा : जालू उदिया डालियाँ नरम होई जांदियां न कने पत्ते निकलना लगदे न, तां तुहांजो पता लगी जांदा है कि गर्मियां ओंणे बालियां न। ");
INSERT INTO bht_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","इयां ही जालू तुसां इना सारियां गल्लां जो होंदे दिखदे न, तां समझी जा कि मैं, माणुऐ दे पुत्रे दा ओणा नेड़े ही है, मतलब कि दरबाजे पर ही है।” ");
INSERT INTO bht_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","मैं तुसां ने सच्च बोलदा है, कि जालू दीकर ऐ सारियां गल्लां पुरियां नी होई जांदियां न, तालू दीकर इसा पीढ़िया दा अंत नी होणा है। ");
INSERT INTO bht_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","अम्बर कने धरती खत्म होई जाणे, पर मेरियां बोलियां गल्लां कदी नी टलनिया न, सै हमेशा रेंणियां न। ");
INSERT INTO bht_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ऐ गल्लां कुसी रोजे या कुसा घड़िया होणिया न कोई भी नी जाणदा है, ना स्वर्गदूत कने ना ही मैं माणुऐ दा पुत्र, पर सिर्फ पिता ही उसी रोजे कने घड़िया जो जाणदा है। ");
INSERT INTO bht_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“जियां नूह दे रोज थे, तियां ही माणुऐ दे पुत्रे दा ओंण भी होणा है।” ");
INSERT INTO bht_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","क्योंकि जियां जल-प्रलय ला पेहले दे दिना च, जिस रोजे दीकर नूह जहाजे पर नी चढ़या था, तालू दीकर लोक खांदे पिंदे थे, कने उना चे बियाह होंदे थे। ");
INSERT INTO bht_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","कने जालू दीकर जल-प्रलय आई करी उना जो रूड़ाई नी लेई गेई, तालू दीकर उना जो कुछ भी पता नी था, तियां ही मैं माणुऐ दे पुत्रे भी ओणा है। ");
INSERT INTO bht_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","उस बेले दो जणे खेतरे च होणे न, इक लेई लेंणा है कने दूजा छडी जाणा है। ");
INSERT INTO bht_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","दो जनानिया चक्की पिसा दियां होणिया, इक लेई जांणी, कने दुई छडी देंणी है। ");
INSERT INTO bht_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“इस तांई जागदे रिया, क्योंकि तुहांजो नी पता है कि तुहाड़े प्रभुये कुस रोजे ओणा है।” ");
INSERT INTO bht_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","पर ऐ जाणी लिया कि अगर घरे दे मालिके जो पता होंदा कि चोरे कालू ओंणा है, तां सै जागदा रेंदा, कने अपणे घरे चोरी नी होणा दिन्दा। ");
INSERT INTO bht_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","इस तांई तुसां भी तैयार रिया, क्योंकि जिसा घड़िया दे बारे च सोचदे भी नी न, उसा घड़िया माणुऐ दे पुत्रे आई जाणा है। ");
INSERT INTO bht_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","सै भरोसे जोगा कने अकला बाला नोकर कुण है, जिसयो मालिके अपणे नोकारां चाकरां दा सरदार बणाया है, ताकि बकते पर उना जो खांणा खाणे दे? ");
INSERT INTO bht_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","धन्य है सै दास, जिसयो उदा मालिक आई करी उसयो ऐदिया करदा दिखे। ");
INSERT INTO bht_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","मैं तुसां ने सच्च बोलदा है; सै उसयो अपणिया सारिया संपतिया दा अधिकारी बणाणा है। ");
INSERT INTO bht_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“पर अगर सै बुरा नोकर सोचणा लग्गे, कि मेरे मालिके जो ओंणे जो देर है।” ");
INSERT INTO bht_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","कने अपणे सोगी नोकरां जो कूटणा लग्गे, कने शराबियां सोगी खा पिऐ। ");
INSERT INTO bht_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","तां उस नोकरे दे मालिके ऐसे रोजे बापस ओणा है, जिस रोजे सै उदी राह नी दिखा दा हो, कने ऐसी घड़ी कि उसयो पता ना हो, ");
INSERT INTO bht_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","कने उसयो सकत सजा देईकरी, उदा हिस्सा कपटियां सोगी जोड़े, तालू उनी रोंणा कने दंद पिणे। ");
INSERT INTO bht_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","फिरी यीशुऐ अपणे चेलयां ने बोलया, जालू मैं, माणुऐ दे पुत्रे बापस ओणा है, तालू स्वर्गे दा राज्य ऐसा होणा है: दसां कुआरियां अपणिया मशालां लेईकरी लाड़े जो मिलने तांई उदे बियाये जो जाणा। ");
INSERT INTO bht_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","उना चे पंज जणियां मुर्ख कने पंज समझदार थियां। ");
INSERT INTO bht_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","उना मुर्ख कुआरियां अपणिया मशालां तां लियां, पर अपणे सोगी जादा तेल नी लांदा। ");
INSERT INTO bht_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","पर समझदार कुआरियां अपणियां मशालां सोगी अपणिया-अपणिया कुपियाँ च तेल भी भरी लांदा। ");
INSERT INTO bht_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","जालू लाड़े जो ओणे च देर होई, तां सै बोर होणा लगियां, कने सै सोई गियां। ");
INSERT INTO bht_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","पर अधिया राती रोल्ला पिया, कि दिखा, लाड़ा ओआ दा है, उसला मिलणे तांई चला। ");
INSERT INTO bht_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","तालू सै सारियां कुंवारियां उठी करी अपणिया-अपणिया मशालां ठीक करणा लगियां। ");
INSERT INTO bht_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","कने मुर्खां समझदारां ने बोलया, अपणे तेले च थोड़ा सांझो भी दिया, क्योंकि साड़ियां मशालां बुझी जा दियां न। ");
INSERT INTO bht_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","पर समझदारां जबाब दिता, कि ऐ साड़े कने तुहाड़े तांई कदी पूरा नी होणा; ठीक तां ऐ है, कि तुसां बेचणे बाले बाल जाई करी अपणे तांई खरदी लिया। ");
INSERT INTO bht_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","जालू सै खरीदणा जा दियां थियां, तां लाड़ा आई रिया, कने जड़ियां तैयार थियां, सै उदे सोगी बियाह बाले घरे जो चली गियां कने घरे दा दरबाजा बंद करी दिता। ");
INSERT INTO bht_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“इदे बाद सै दुईयां कुआरियां भी वापिस आई करी रोंदे होऐ लाड़े जो सदणा लगियां, है स्वामी, है स्वामी, साड़े तांई दरबाजा खोली दिया।” ");
INSERT INTO bht_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“उनी जबाब दिता, कि मैं तुसां ने सच्च बोलदा है कि, मैं तुहांजो नी जाणदा है।” ");
INSERT INTO bht_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“इस तांई जागदे रिया, क्योंकि तुसां नी जाणदे मेरे बापस ओणा दा रोज, कने सेह बकत कालू ओणा है।” ");
INSERT INTO bht_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“फिर यीशु ने इक होर कहाणी दसी कि मैं जालू बापस ओणा है, तालू स्वर्गे दा राज्य ऐसा होणा: इक माणु था जिनी परदेस जांदे बेले अपणे नोकरां जो सदीकरी अपणी सारी जमीन जयादात उना जो देई दिती।” ");
INSERT INTO bht_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","उनी इकी जो पंज तोड़े, दुज्जे जो दो, कने तरिये जो इक, हर इकी जो उदिया शक्तिया दे अनुसार दिता, कने फिरी परदेस चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","तालू जिसयो पंज तोड़े मिलयो थे, उनी झट जाई करी उना ने लेंन-देंन किता, कने पंज तोड़े होर कमाई ले। ");
INSERT INTO bht_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","इसी तरीके ने जिसयो दो मिलयो थे, उनी भी दो होर कमाई ले। ");
INSERT INTO bht_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","पर जिसयो इक ही तोड़ा मिलया था, उनी जाई करी मिटी खूणी, कने अपणे मालिके दे पेसे लुकाई दिते। ");
INSERT INTO bht_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","मते रोजां बाद मालिके आई करी उना नोकरां जो गिठे सदया कि उना उदे पैसयां ने क्या किता। ");
INSERT INTO bht_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","जिसयो पंज तोड़े मिलयो थे, उनी पंज तोड़े होर आंणी करी बोलया, है मालिक, तू मिंजो पंज तोड़े दिते थे, दिख मैं पंज तोड़े होर कमायो न। ");
INSERT INTO bht_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","उदे मालिके उसयो बोलया, धन्य, तू खरा कने भरोसे दे लाइक नोकर है, तू थोड़े पैसयां जो सम्भालने कने भरोसे दे लाइक रिया है; मैं तिजो होर मतियां चिजा दा अधिकारी बणाणा है। अपणे मालिके सोगी खुश हो। ");
INSERT INTO bht_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","कने जिसयो दो तोड़े मिलयो थे, उनी भी आई करी बोलया, है मालिक तू मिंजो दो तोड़े दिते थे, दिख, मैं दो तोड़े होर कमायो न। ");
INSERT INTO bht_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","उदे मालिके उसयो बोलया, धन्य, तू खरा कने भरोसे दे लाइक नोकर है, तू थोड़े पैसयां जो सम्भालने कने भरोसे दे लाइक रिया, मैं तिजो मतियां चिजा दा अधिकारी बणांगा। अपणे मालिके सोगी खुश हो। ");
INSERT INTO bht_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","तालू जिसयो इक तोड़ा मिलया था, उनी आई करी बोलया, हे मालिक, मैं तिजो जाणदा था कि तू बड़ा सकत माणु है: तु दुजे लोका दे कम्मे ला फायदा कमाणे दी आस रखदा है, कने जिथू तू नी खलारदा है ओथु तू बटोलदा है। ");
INSERT INTO bht_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","तांई तां मैं डरी गिया कि अगर मैं तेरा पैसा गवाई दिता तां तू मिंजो सजा देणी, इस तांई जाई करी मैं तेरा तोड़ा मिटिया च लुकाई दिता; दिख, जड़ा तेरा है, सै ऐ है। ");
INSERT INTO bht_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","उदे मालिके उसयो जबाब दिता, हे दुष्ट कने आलसी नोकर; तिजो पता था कि, मैं दुजे लोका दे कम्मे ला फायदा कमाणे दी आस रखदा है। ");
INSERT INTO bht_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","तां तिजो ऐसा करणा चाईदा था कि, मेरा पैसा सर्राफों जो देई दिन्दा, फिरी मैं आई करी अपणा पैसा उना ला ब्याजे समेत लेई लेंदा। ");
INSERT INTO bht_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","तालू मालिके बाकी नोकरां जो बोलया, “तोड़े जो इसला लेई लिया, कने जिदे बाल दस तोड़े न, उसयो देई दिया। ");
INSERT INTO bht_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","जिना बाल समझणे दी इच्छा है जड़ा परमेश्वर सिखांदा है, उसयो परमेश्वरे होर समझ देणी, पर जड़ा समझणे दी इच्छा नी रखदा, कि मैं क्या सिखादां, तां सै जड़ा समझया है, परमेश्वरे सै भी उसला लेई लेणा।” ");
INSERT INTO bht_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","कने इस नकमे नोकरे जो नेरे च पाई दिया, जिथू उनी रोंणा कने दंद पींणे। ");
INSERT INTO bht_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“जालू मैं, माणुऐ दे पुत्रे अपणिया महिमा च ओंणा है, कने स्वर्गदूते उदे सोगी ओणा, तालू लोकां दा न्याय करणे तांई उनी अपणे महिमा दे सिहांसने पर विराजमान होणा।” ");
INSERT INTO bht_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","कने सारियां जातियां मेरे सामणे गिठियां करणियां न; जियां पुहाल भेडां जो बकरियां ला लग करी दिन्दा है, तियां ही उनी भी उना जो इक दुजे ला लग करणा है। ");
INSERT INTO bht_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","कने मैं धर्मी लोका जो अपणे सजे पासे कने अधर्मियां लोका जो खबे पासे खरेड़ना है। ");
INSERT INTO bht_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“तालू मैं राजे अपणे सजे पासे बोणे बालयां ने बोलणा कि, हे मेरे पिता दे धन्य लोको, ओआ, कने उस राज्य दे अधिकारी बणी जा, जड़ा संसारे दे शुरू होंणे ला तुहाड़े तांई तैयार कितया है।” ");
INSERT INTO bht_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","क्योंकि मैं जालू भूखा था, तां तुसां मिंजो खांणे जो खाणा दिता, जालू मैं प्यासा था, तां तुसां मिंजो पांणी पियाया, मैं इक परदेसी था, तुसां मिंजो अपणे घरे रियाया। ");
INSERT INTO bht_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","जालू मैं नगां था, तुसां मिंजो कपड़े दिते, मैं बिमार था, तुसां मेरा हाल चाल पुछया, मैं जेला च था, तां तुसां मिंजो ने मिलणा आये। ");
INSERT INTO bht_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“तालू धर्मियां उसयो जबाब देणा, कि प्रभु जी, असां कालू तिजो भूखा दिखया कने खुआया? या प्यासा दिखया, कने पांणी पियाया?” ");
INSERT INTO bht_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","असां कालू तिजो परदेसी दिखया कने अपणे घरे रियाया या नंगा दिखया, कने कपड़े दिते? ");
INSERT INTO bht_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","असां तिजो कालू बिमार कने जेला च दिखया, कने तिजो ने मिलणा आये? ");
INSERT INTO bht_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“तालू मैं राजे उना जो जबाब देणा, मैं तुसां ने सच्च बोलदा है, कि जड़ा तुसां मेरे इना छोटे ला छोटे चेले चे कुसी इकी दे सोगी कितया है, सै ही मेरे सोगी कितया है।” ");
INSERT INTO bht_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“तालू उनी खबे पासे बालयां ने बोलणा है, हे श्रापित लोको मेरे सामणे ला इसा कदी नी बुझणे बालिया अग्गी च चली जा, जड़ी शैताने कने उदे दूतां तांई परमेश्वरे तैयार कितया है।” ");
INSERT INTO bht_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","क्योंकि मैं भूखा था, तुसां मिंजो खांणे जो नी दिता, मैं प्यासा था, कने तुसां मिंजो पांणी नी पियाया; ");
INSERT INTO bht_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","मैं परदेसी था, कने तुसां मिंजो अपणे घरे नी रियाया; मैं नंगा था, कने तुसां मिंजो कपड़े नी दिते; कने मैं बिमार कने जेलां च था, तां तुसां मेरा हाल चाल नी पुछया। ");
INSERT INTO bht_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“तालू उना जबाब देणा, कि प्रभु जी, असां तिजो कालू भूखा, या प्यासा, या परदेसी, या नंगा, या बिमार, या जेला च दिखया, कने तेरी सेबा या टहल नी किती?” ");
INSERT INTO bht_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“तालू मैं उना जो जबाब देणा, मैं तुसां ने सच्च बोलदा है कि तुसां जड़ा इना छोटे ला छोटे चेले चे कुसी इकी दे सोगी नी कितया है, से मेरे सोगी भी नी किता है।” ");
INSERT INTO bht_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","कने सै जड़े खबे पासे न इना जो हमेशा दी सजा मिलणी है पर धर्मी लोका हमेशा दिया जिन्दगिया च प्रवेश करणा है। ");
INSERT INTO bht_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","जालू यीशु ऐ सारियां गल्लां बोली बैठा, तां अपणे चेलयां ने बोलणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“तुहांजो पता है, कि दो दिना बाद फसह दा त्योहार होणेबाला है, कने माणुऐ दा पुत्र सूली पर चढ़ाणे तांई पकड़ाया जाणा है।” ");
INSERT INTO bht_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","तालू बड्डे याजक कने प्रजा दे यहूदी अगुवे कैफा नाऐ दे महायाजक दे अंगणे च गिठे होए, ");
INSERT INTO bht_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","कने अपु चे बिचार करणा लग्गे कि यीशुऐ जो धोखे ने पकड़ी करी मारी देंन। ");
INSERT INTO bht_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","पर सै बोलदे थे, कि त्योहारे दे बकत नी, कुथी इयां ना होऐ कि लोकां च रोल्ला पेई जा। ");
INSERT INTO bht_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","जालू सै बैतनिय्याह ग्रां च शमौन कोढ़ी दे घरे था, जिसयो यीशुऐ ठीक कितया था। ");
INSERT INTO bht_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","जालू यीशु खांणा खाणे तांई बैठया था तां इक जनानी संगमरमरे दे भांडे च बड़ा मेंहगा इत्र लेईकरी उदे बाल आई कने, तां उना सै इत्र उदे सिरे पर नियोरी दिता। ");
INSERT INTO bht_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ऐ दिखीकरी उदे चेले हेरान होए कने बोलणा लग्गे, “इस इतणे मेंगे इत्रे जो सत्यानाश नी करणा चाईदा? ");
INSERT INTO bht_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","इसयो तां खरे दामे च बेची करी कंगालां जो बंडी सकदे थे।” ");
INSERT INTO bht_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ऐ जाणी करी यीशुऐ उना ने बोलया, जनानिया जो कजो तंग करा दे न? उना मिंजो ने खरा किता है। ");
INSERT INTO bht_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","कंगालां तां तुहाड़े सोगी हमेशा रेंणा है, पर मैं तुहाड़े सोगी हमेशा नी रेणा है। ");
INSERT INTO bht_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","इना जड़ा इत्र मेरे शरीरे पर नियोरया है, सै इना मिंजो मरणे ला पहले ही दफनाणे दी तैयारी किती है। ");
INSERT INTO bht_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","“मैं तुसां ने सच्च बोलदा है, कि सारे संसार च जिथू कुथु भी ऐ शुभसमाचार सुणाया जांगा, ओथु इसा दे इस कम्मे दी चर्चा भी इसा दिया यादा च होणी।” ");
INSERT INTO bht_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","यहूदा इस्करियोती, जड़ा बाहरां चेलयां चे इक था, उनी बड्डे याजकां बाल जाई करी बोलया, ");
INSERT INTO bht_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","अगर मैं उसयो तुहाड़े हथे पकड़ाई दे, “तां मिंजो क्या दिंगे? उना उसयो ती चांदिये दे सिक्के तोली करी देई दिते।” ");
INSERT INTO bht_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","कने सै तालू ला ही उसयो पकड़ाने दा मोका तोपणा लगी पिया। ");
INSERT INTO bht_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","अखमीरी रोटिया दे त्योहारे दे पेहले रोजे, चेले यीशुऐ बाल जाई करी पूछणा लग्गे, “तू कुथु फसह खांणा चांदा है, ओथु असां जाई करी तेरे तांई फसह खांणे दी तैयारी करन?” ");
INSERT INTO bht_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","उनी बोलया, “शेहरे च जा कने अमुक नाऐ दे माणुऐ बाल जाई करी बोला, कि गुरू बोला दा है, कि मेरा बकत नेड़े है, कने मैं अपणे चेलयां सोगी तेरे ऐथू फसह दा त्योहारे मनाणा है।” ");
INSERT INTO bht_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","चेलयां यीशुऐ दा हुकम मनया, कने फसह तैयार किता। ");
INSERT INTO bht_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","जालू संज होई तां सै चेलयां सोगी खांणा खाणे तांई बैठा। ");
INSERT INTO bht_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","कने जालू सै रोटी खाणां बैठयो थे, तां यीशुऐ बोलया, “मैं तुसां ने सच्च बोला दा है, कि तुसां चे इकी जणे मिंजो पकड़ाणा है।” ");
INSERT INTO bht_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","इसा गल्ला पर सै बड़े उदास होई गे, कने सारे उसयो पूछणा लग्गे, “हे गुरू, क्या सै मैं है?” ");
INSERT INTO bht_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","उनी जबाब दिता, “जिनी मिंजो सोगी थालिया च हथ पाया है, उनी ही मिंजो पकड़ाणा है।” ");
INSERT INTO bht_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","“माणुऐ दे पुत्रे मरी जाणा है, क्योंकि ऐ सब कुछ पबित्र शास्त्रां च लिखया है, पर उस माणुऐ जो बड़ी बुरी सजा होणी है जड़ा मिंजो धोखा दिन्दा है जिनी मिंजो पकड़वाणे च सहायता करणी है! अगर उस माणुऐ दा जन्म ही नी होया होंदा तां ही उदे तांई खरा होंदा।” ");
INSERT INTO bht_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","तालू उसयो पकड़ाणे बाले यहूदे बोलया, “गुरू जी, क्या सै मैं है?” उनी उसयो बोलया, “तू बोली बैठा।” ");
INSERT INTO bht_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","जालू सै खा दे थे तां यीशुऐ रोटी लेई, कने परमेश्वरे दा धन्यबाद करी के तोड़ी, कने चेलयां जो दिती कने बोलया, “लिया, खाई लिया; ऐ मेरा शरीर है।” ");
INSERT INTO bht_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","फिरी उनी दाखरस दे कटोरे जो चुकी करी परमेश्वरे दा धन्यबाद किता, कने चेलयां जो दिता कने बोलया, “तुसां सारे इस कटोरे चे पिया, ");
INSERT INTO bht_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","क्योंकि ऐ बाचा दा मेरा सै खून है, जड़ा मतयां लोकां दिया भलाईया तांई बहाया जाणा है।” ");
INSERT INTO bht_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","“मैं तुहांजो ने सच्च बोलदा है, मैं दाखा दा ऐ रस उस दिने दीकर नी पींणा, जालू दीकर पिता दे राज्य च नोआ दाखरस नी पी लेंगा।” ");
INSERT INTO bht_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","फिरी यीशुऐ कने उदे चेलयां फसह दे त्योहारे दे भजन गाई करी यरूशलेम शहरे दे बाहर जैतून रुखां दे पाहड़े पर चली गे। ");
INSERT INTO bht_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","तालू यीशुऐ उना ने बोलया, “तुसां सारयां ही अज राती अपणे भरोसे ला भटकी जाणा है; क्योंकि पबित्र शास्त्र च लिखया है कि मैं पुहाल मारी देणा है; कने झुंडे दियां भेडां तितर-बितर होई जाणा।” ");
INSERT INTO bht_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","पर मैं मरी के जिन्दा होणे ला बाद तुहांजो ला पेहले गलील प्रदेश च पूजणा है। ");
INSERT INTO bht_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","पर पतरसे यीशुऐ जो बोलया, “चाहे सारे छडी करी नसी जांगे पर मैं नी नसगा।” ");
INSERT INTO bht_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","यीशुऐ उसयो बोलया, “मैं तिजो ने सच्च बोलदा है, कि अज ही इसा राती मुर्गे जो दो बार बांग देणे ला पेहले तू मिंजो तीन बरी बोलणा है, कि मिं‍जो नी जाणदा है।” ");
INSERT INTO bht_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","पतरसे यीशुऐ ने बोलया, अगर मिंजो तेरे सोगी मरणा भी पौंगा, तमी मैं तिजो ला कदी नी मना करगा। कने इयां ही सारयां चेलयां भी बोलया। ");
INSERT INTO bht_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","तालू यीशु अपणे चेलयां सोगी गतसमनी नाऐ दिया इक जगा च आया कने अपणे चेलयां ने बोलणा लग्गा, “ऐथू बेई रिया, जालू दीकर मैं प्राथना करें।” ");
INSERT INTO bht_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","सै पतरस कने जब्दी दे दोनो पुत्रां जो सोगी लेई गिया, कने उदास कने रोणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","तालू उनी उना जो बोलया, “मेरा मन बड़ा उदास है, ऐथू दीकर कि मेरे प्राण निकली चलयो न। तुसां ऐथू ही रुका, कने मेरे सोगी जागदे रिया।” ");
INSERT INTO bht_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","फिरी यीशु थोड़ा अग्गे गिया, कने गोडे भार पेई गया कने मुह धरतिया पर करी प्राथना करणा लग्गा,, “हे मेरे पिता, अगर होई सके तां ऐ कटोरा मिंजो ला टली जाऐ, तमि जियां मैं चांदा है तियां नी हो, पर जियां तू चांदा है, तियां ही हो।” ");
INSERT INTO bht_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","फिरी जालू यीशु बापस आया कने उना चेलयां जो सुतया दिखीकरी उनी पतरसे जो बोलया, “हे शमौन, तू सुतया है? तुसां इक घंटा भी मेरे सोगी जागदे नी रेई सके? ");
INSERT INTO bht_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","जागदे कने प्राथना करदे रिया ताकि मिजों पर भरोसा रखणा नी छडन। आत्मा तां खरा करणा चांहदी है पर शरीरे च जोरे दी कमी है।” ");
INSERT INTO bht_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","फिरी उनी दुजी बरी जाई करी ऐ प्राथना किती कि, “हे मेरे पिता, अगर ऐ मेरे पित्यो बिना नी हटी सकदा है, तां तेरी इच्छा पुरी होए।” ");
INSERT INTO bht_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","तालू उनी आई करी उना जो फिरी सुत्या दिखया, क्योंकि उना दियां हखी निंद्रा ने भरूइयां थियां। ");
INSERT INTO bht_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","उना जो छडी करी सै फिरी चली गिया, कने सेई गल्ल दोवारा बोली करी, तिजी बरी प्राथना किती। ");
INSERT INTO bht_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","तालू उनी चेलयां बाल आई करी उना जो बोलया, हुण सोंदे रिया कने अराम करा: दिखा, सै घड़ी आई गेई है, कने माणुऐ दा पुत्र पापियां दे हथे पकड़ाया जाणा है। ");
INSERT INTO bht_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","“उठा कने चला। दिखा, जिनी माणुऐ मिजों पकड़वाणा है सै बखे आई रिया है।” ");
INSERT INTO bht_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","जालू यीशुऐ ऐ बोला दा ही था, यहूदा जड़ा बाहरां चेलयां चे इक था, सै अपणे सोगी मते सारे लोकां जो लेईकरी आया जिना तलवारां कने डंडे लियो थे, ऐ सारे लोक बड्डे याजकां, यहूदी व्यवस्था दे गुरूआं कने यहूदी अगुवां भेजयो थे। ");
INSERT INTO bht_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","उनी यीशुऐ जो पकड़णने बालयां जो ऐ बोलया था कि : “जिदी मैं चूमी लेंगा, सै ही यीशु है, उसयो तुसां पकड़ी लेनयो।” ");
INSERT INTO bht_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","उनी झट यीशुऐ बाल आई करी बोलया, “गुरू जी, नमस्ते!” कने उदी चूमी लेई। ");
INSERT INTO bht_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","यीशुऐ उसयो बोलया, “हे मित्र, जिसी कम्मे तांई तू आया है, उसयो करी ले।” तालू उना बखे आई करी यीशुऐ जो पकड़ी लिया। ");
INSERT INTO bht_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","यीशुऐ दे साथियां चे इकी अपणी तलवार कडी कने महायाजके दे इकी नोकरे पर चलाई करी उदा कन बडी दिता। ");
INSERT INTO bht_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","तालू यीशुऐ उसला बोलया, अपणिया तलवारा मयाना च रख क्योंकि जड़े तलवारां चलादें न सै तलवारा ने ही खत्म करणे न। ");
INSERT INTO bht_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","तिजो क्या पता नी है कि मैं अपणे पिता ने विनती करी सकदा है, कने उनी स्वर्गदूते दियां बाहरां पलटना ला भी जादा स्वर्गदूत मेरे बाल हुण हाजिर करी देणे? ");
INSERT INTO bht_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","“पर पबित्र शास्त्रां दियां सै गल्लां कि इयां ही होणा जरूरी है कियां पुरियां होणियां?” ");
INSERT INTO bht_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","यीशुऐ उना जो बोलया, तुसां क्या तलवारां कने डांगा लेईकरी मिंजो डाकुआं सांई पकड़ना आयो न? पर मैं जालू हर रोज मंदरे च बेईकरी उपदेश दिन्दा था, तालू तां तुसां मिंजो नी पकड़या। ");
INSERT INTO bht_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","“पर ऐ इस तांई होया कि पबित्र शास्त्रां दियां गल्लां पुरियां होन।” जालू ऐ होया तां उदे सारे चेले उसयो छडी करी नसी गे। ");
INSERT INTO bht_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","तालू यीशुऐ जो पकड़ने बाले उसयो कैफा नाऐ दे महायाजक बाल लेई आऐ, जिथू यहूदी व्यवस्था जो सिखाणे कने यहूदी अगुवे गिठे होयो थे। ");
INSERT INTO bht_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","कने पतरस दुरे-दुरे ला उना दे पिच्छे-पिच्छे महायाजक दे अंगणे दीकर गिया, कने अंत दिखणे तांई अंदर जाई करी पयादयां बखे बेई गिया। ");
INSERT INTO bht_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","बड्डे याजक कने यहूदी महासभा दे सदस्य यीशुऐ जो मारी देणे तांई उदे खिलाफ च गबाई तोपा दे थे, ");
INSERT INTO bht_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","पर मते झूठे गबाह ओणे पर उना जो कोई गबाई नी मिली। आखरी च दो जणे आऐ, ");
INSERT INTO bht_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","कने बोलया, “कि इनी बोलया था कि मैं परमेश्वरे दे मंदरे जो ढाई सकदा है, कने फिरी उसयो तिन्ना रोजां च बणाई सकदा है।” ");
INSERT INTO bht_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","तालू महायाजके बिच खड़ोई करी यीशुऐ जो बोलया, “तू क्या कोई जबाब नी देणा? ऐ लोक तेरे खिलाफ क्या गबाई देद न?” ");
INSERT INTO bht_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","पर यीशु चुप ही रिया। तालू महायाजके उसयो बोलया “मैं तिजो जिंदे परमेश्वरे दी कसम दिन्दा है, कि अगर तू परमेश्वरे दा पुत्र मसीह है, तां सांझो ने बोली दे।” ");
INSERT INTO bht_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","यीशुऐ उसयो बोलया, “उनी अपु मन्नी लिया; कने मैं, माणुऐ दा पुत्र तुसां ने ऐ भी बोलदा है, कि हुण तुसां माणुऐ दे पुत्रे जो सर्वशक्तिमान दे सजे पासे बैठया, कने अम्बरे दे बदला पर ओंदे दिखणा है।” ");
INSERT INTO bht_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","जालू महायाजके यीशुऐ जो ऐ बोलदे सुणया तां उनी गुस्से च अपणे कपड़े फाड़ी दिते, कने बोलया, “हुण सांझो कुसी गबाह दी जरूरत नी है। तुसां परमेश्वर दी निंदा करदे सुणया, तुहाड़ी क्या सलाह है इसा गल्ला पर?” उना सारायां फेसला किता कि यीशुऐ परमेश्वरे दी निंदा किती है। ");
INSERT INTO bht_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","तुसां क्या सोचदे न? उना जबाब दिता, ऐ तां मारी देंणे जोगा है। ");
INSERT INTO bht_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","तालू उना उदे मुऐ पर थूक्या कने उसयो मुक्के मारे, कने बाकियां थप्पड़ मारी करी बोलया, ");
INSERT INTO bht_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","हे मसीह, अगर तु परमेश्वरे दा संदेश देणेबाला है! तां सांझो दस कुनी तिजो मारया, ");
INSERT INTO bht_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","पतरस बाहर अंगणे च बैठया था तां इकी दासिया उदे बाल आई करी बोलया, “तू भी तां यीशु गलीली सोगी था।” ");
INSERT INTO bht_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","उनी सारयां दे सामणे ऐ बोली करी मना किता कि, “मैं नी जाणदा कि तू क्या बोला दी है।” ");
INSERT INTO bht_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","जालू सै बाहर डेवढ़िया पर गिया, तां दुईया नोकराणिया उसयो दिखीकरी उना ने बोलया जड़े ओथु बैठयो थे कि, “ऐ भी तां यीशु नासरिये सोगी था।” ");
INSERT INTO bht_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","उनी कसम खाई करी फिरी मना किता, “मैं इस माणुऐ जो नी जाणदा है।” ");
INSERT INTO bht_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","थोड़िया देरा बाद जड़े लोक ओथु खड़ुतयो थे, उना पतरसे बाल आई करी उसयो बोलया, “सच्ची तू भी इना चे इक है; क्योंकि तेरी बोली तेरा सच्च दसा दी है।” ");
INSERT INTO bht_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","पतरस अपु जो कोसणा लग्गा, कसम खाणा लग्गा, मैं इस माणुऐ जो नी जाणदा। कने झट मुर्गे बांग देई दिती। ");
INSERT INTO bht_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","तालू पतरसे जो यीशुऐ दियां बोलियां गल्लां याद आईयां, मुर्गे दिया बांगा देंणे ला पेहले तू मिंजो तिन्न बरी मना करणा है। कने सै बाहर जाई करी जोरे-जोरे ने रोंणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","कने ब्यागा तड़के होंदे ही झट उना बड्डे याजकां, कने यहूदी अगुवां, कने व्यवस्था जो सिखाणे बालयां कने महासभा दे सारे लोकां यीशुऐ जो मारी देणे दी सलाह किती। ");
INSERT INTO bht_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","कने उना यीशुऐ जो बन्नया, कने न्याय करणे तांई यहूदिया प्रदेश दे राज्यपाल पिलातुस दे हबाले करी दिता। ");
INSERT INTO bht_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","जालू यीशुऐ जो पकड़ाणे बाले यहूदा जो पता चला कि सै मरवाणे तांई दोषी ठेहराया गिया है तां सै बड़ा पछताया कने उना ती चांदिये दे सिक्कयां जो बड्डे याजकां कने यहूदी अगुवां जो बापस देई आया। ");
INSERT INTO bht_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","कने बोलया, मैं बेकसूर जो मारणे तांई पकड़ाणे दा पाप किता है, उना बोलया, “सांझो क्या है? इस तांई तू ही जिम्मेबार है।” ");
INSERT INTO bht_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","तालू सै उना सिक्यां जो मंदरे दे अंगणे च फेंकी करी बाहर चली गिया, कने जाई करी उनी अपु फा लेई लिया। ");
INSERT INTO bht_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","बड्डे याजकां उना सिक्यां जो लेईकरी बोलया, “साड़े नियम दे हिसावे ने इना पेंसया जो मंदिर दे भंडारे च रखणा ठीक रैणा है, क्योंकि ऐ इक माणुऐ जो मरवाणे तांई दितया दाम है।” ");
INSERT INTO bht_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","उना सलाह करिके उना सिक्यां ने परदेशियां जो दबाणे तांई कुम्हारे ला खेतर खरीदी लिया। ");
INSERT INTO bht_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","इसा बजा ने उस खेतरे जो अजे दीकर खूने दा खेतर बोलदे न। ");
INSERT INTO bht_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","तालू जड़ा बचन यिर्मयाह परमेश्वरे दा संदेश देणेबाले बोलया था सै पूरा होया: “उना सै ती सिक्के जड़े इस्राएल दे लोकां यहूदा जो दितयो थे लेई ले। ");
INSERT INTO bht_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","कने जियां प्रभुऐ मिंजो हुकम दितया था तियां ही उना जो कुम्हारे दे खेतरे दे दामे च देई दिता।” ");
INSERT INTO bht_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","जालू यीशु राज्यपाले दे सामणे खड़ोतया था, तां हाकिमे उसयो पुछया, तू क्या यहूदियां दा राजा है? यीशुऐ उसयो बोलया, “तू अपु ही बोला दा है।” ");
INSERT INTO bht_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","जालू बड्डे याजक कने यहूदी अगुवे उस पर दोष ला दे थे, तां उनी कोई जबाब नी दिता। ");
INSERT INTO bht_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","इस पर पिलातुसे उसयो बोलया, “तू क्या सुंणा दा नी है कि, ऐ तेरे खिलाफ च कितणियां गबाईयां देद न?” ");
INSERT INTO bht_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","पर उनी उसयो इकी भी गल्ला दा जबाब नी दिता, ऐथू दीकर कि राज्यपाल जो बड़ी हेरानी होई। ");
INSERT INTO bht_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","हर साले फसह दे त्योहारे च, राज्यपाल पिलातुस इक केदिये जो छडी दिन्दा था, जिसयो लोक चांदे थे कि सै छूटे। ");
INSERT INTO bht_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","उस बेले बरअब्बा नाऐ दा इक मनया नामी कैदी था। ");
INSERT INTO bht_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","जालू सै गिठे होए तां पिलातुसे उना जो बोलया, “तुसां कुस्यो छुडाणा चांदे न, ताकि मैं तुहाड़े तांई उसयो छडी दें? बरअब्बे जो या यीशुऐ जो जिसयो मसीह बोलदे न?” ");
INSERT INTO bht_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","क्योंकि सै जाणदा था कि उना उसयो जलनिया ने पकड़ाया है। ");
INSERT INTO bht_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","जालू सै न्याय दिया कुर्सिया पर बैठया था तां उदिया घरे बालिया उसयो बोली भेजया था कि, “तू उस धर्मिये दे मामले च हथ मत पांदा; क्योंकि मिंजो अज राती सूपने च उदिया बजा ने बड़ा दुख होया है।” ");
INSERT INTO bht_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","पर बड्डे याजकां लोकां दिया भिड़ा जो भड़काया, कि पिलातुस ला यीशुऐ जो छडणे दी बजाये बरअब्बा जो छडणे दी माँग करा, कने यीशुऐ जो मारणे तांई बोला। ");
INSERT INTO bht_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","राज्यपाले उना ला पुछया, इना दोना चे कुस्यो चांदे न, ताकि मैं तुहाड़े तांई छडी दें? उना बोलया, “बरअब्बा” जो। ");
INSERT INTO bht_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","पिलातुसे उना ला पुछया, फिरी यीशुऐ दा क्या करणा, जिसयो मसीह बोलदे न? “सबना बोलया, इसयो सूली पर चढ़ाई दिया।” ");
INSERT INTO bht_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","पिलातुसे उना जो बोलया, “कजो इनी क्या बुरा कितया है?” पर भीड़ होर भी जोरे ने चिलाणा लग्गी कि, “इसयो सूली पर चढ़ाई करी मारी दिया।” ");
INSERT INTO bht_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","जालू पिलातुसे दिखया, कि कुछ नी बणा दा है कने उल्टा होर जादा रोल्ला होंदा जादा है, तां उनी पांणी लेईकरी भिड़ा दे सामणे अपणे हथ धोते कने बोलया, “मैं इस धर्मिये दे खूने ला निर्दोष है; हुण तुसां ही जाणा।” ");
INSERT INTO bht_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","सबना लोकां जबाब दिता, “इदे खूने दा इल्जाम सांझो पर कने साड़िया ओलादी पर होऐ।” ");
INSERT INTO bht_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","बरअब्बा जो उना तांई छडी दिता, कने यीशुऐ जो कोड़े लगबाई करी सूली पर चढ़ाणे तांई रोमी सिपाईयां दे हबाले देई दिता। ");
INSERT INTO bht_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","तालू राज्यपाले दे सिपाईयां यीशुऐ जो किले च लेईजाई करी उदे चोरो पासे सारी पलटन खरेड़ी दिती। ");
INSERT INTO bht_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","उदे सारे कपड़े उतारी करी उसयो बैंगणी रंगे दे कपड़े पेहनाइ दिते, ");
INSERT INTO bht_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","कने कंडयां दा मुकुट बणाई करी उदे सिरे पर रख्या; कने उदे सजे हथे च सरकंडा दिता। कने यीशुऐ दे सामणे झुकी करी उदा मजाक उड़ाणा लग्गे कने बोलया, “हे यहूदियां दे राजा नमस्ते।” ");
INSERT INTO bht_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","कने उस पर थूक्या कने सेई सरकंडा लेईकरी उदे सिरे च मारणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","जालू सै उदा मजाक उड़ाई बैठे, तां उना सै कपड़े उतारी करी उदे अपणे कपड़े उसयो पेहनाऐ, फिरी उसयो सूली पर चढ़ाणे तांई शेहरे ला बाहर लेई गे। ");
INSERT INTO bht_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","बाहर जांदे बेले उना जो शमौन नाऐ दा इक कुरेनी माणु मिल्ला, उना उसयो बेकार च ही पकड़या ताकि सै उदिया सूलिया जो चुकी करी लेई चले। ");
INSERT INTO bht_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","कने उसयो गुलगुता नाऐ दिया जगा च मतलब जिसयो खोपड़ी दी जगा बोलदे न, ओथु पुज्जी करी, ");
INSERT INTO bht_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","उना उसयो कोड़ा रस मिलाई करी दाखरस पीणे जो दिता, पर उनी चखी करी नी पिता। ");
INSERT INTO bht_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","तालू उना उसयो सूली पर चढ़ाया, कने चिठियां पाई करी उदे कपड़े बंडी ले। ");
INSERT INTO bht_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","कने ओथु बेईकरी उदा पेहरा देणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","कने उदा दोष उदे सिरे पर लाई दिता कि “ऐ यहूदियां दा राजा यीशु है।” ");
INSERT INTO bht_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","तालू उदे सोगी दो डाकू इक सजे पासे कने इक खबे पासे सूली पर चढ़ाऐ। ");
INSERT INTO bht_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","कने ओंणे-जांणे बाले लोक सिरे हिलाई-हिलाई करी उदी निंदा करदे थे। ");
INSERT INTO bht_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","कने बोलदे थे कि, “ओ मंदरे जो ढांणे बाल्या कने उसयो तिन्ना रोजां च बणाणे बाल्या, अपणे आपे जो तां बचा। अगर तू परमेश्वरे दा पुत्र है, तां सूली ला उतरी आ।” ");
INSERT INTO bht_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","इसी तरीके ने ही बड्डे याजक, व्यवस्था जो सिखाणे बाले कने यहूदी अगुवे समेत सारे उदा मजाक उड़ाई करी बोला दे थे कि, ");
INSERT INTO bht_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","इनी होरना जो तां बचाया पर अपणे आपे जो नी बचाई सकदा है। ऐ तां इस्राएले दा राजा है। अगर तू हुण सूली ला उतरी ओऐ, तां असां तिजो पर भरोसा करणा। ");
INSERT INTO bht_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","इनी परमेश्वरे पर भरोसा रखया है, अगर सै इसयो चांदा है, तां हुण इसयो छुड़ाई ले, क्योंकि इनी बोलया था कि, मैं परमेश्वरे दा पुत्र है। ");
INSERT INTO bht_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","इयां ही सै डाकू भी उदी बुराई करदे थे जड़े उदे सोगी सूली पर चढ़ायो थे। ");
INSERT INTO bht_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","उस रोजे दोपेरा ला लेईकरी तिजे पहर दीकर सारे देशे च नेहेरा होई गिया। ");
INSERT INTO bht_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","तिजे पहर दे बखे यीशुऐ बड़े जोरे ने पुकारी बोलया, “एली, एली, लमा शबक्तनी?” मतलब “है मेरे परमेश्वर, तू मिंजो कजो छडी दिता?” ");
INSERT INTO bht_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","जड़े ओथु थे, उना चे कितणयां ऐ सुणीकरी बोलया, “सै तां एलिय्याह जो पुकारा दा है।” ");
INSERT INTO bht_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","उना चे इक बन्दा झट दोड़या, कने उनी स्पंज लेईकरी सिरके च डुबोई, कने सरकंडे पर रखीकरी उसयो चुसाया। ");
INSERT INTO bht_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","होरनी बोलया, “रुकी जा, दिखदे न कि, एलिय्याह इसयो बचाणा ओंदा है कि नी।” ");
INSERT INTO bht_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","तालू यीशुऐ फिरी बड़े जोरे ने चिलाई करी अपणे प्राण छडी दिते। ");
INSERT INTO bht_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","कने दिखा, मंदरे दा परदा उपरे ला लेईकरी थले दीकर फटी करी उदे दो टुकड़े होई गे, कने धरती कमी पेई कने पथर तिड़की गे। ");
INSERT INTO bht_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","कने कबरां खुली गियां, कने मरे हुय मते पबित्र लोकां दे शव जिन्दा होई गे, ");
INSERT INTO bht_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","कने जिन्दा होणे बाद सै कबरां ला निकली करी पबित्र शेहरां च गे, कने मत्यां जणया उना जो दिखया। ");
INSERT INTO bht_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","तालू सूबेदार कने जड़े उदे सोगी यीशुऐ दा पेहरा देदे थे, सै भूकम्प कने जड़ा कुछ ओथु होया था, उसयो दिखीकरी बड्डे भरी डरी गे, कने बोलणा लग्गे, “ऐ तां सच्ची ही परमेश्वरे दा पुत्र था।” ");
INSERT INTO bht_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ओथु मतियां जनानिया जड़ियां गलील प्रदेशे ला ही यीशुऐ दी सेबा करदियां उदे सोगी आईयां थियां, सै दुरे ला ही दिखा दियां थियां। ");
INSERT INTO bht_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","उना चे मरियम मगदलीनी, कने याकूब कने योसेस दी माता मरियम कने जब्दीये दे पुत्रां दी माता भी थी। ");
INSERT INTO bht_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","जालू संज होई तां यूसुफ नाऐ दा अरिमतिया शेहरे दा इक अमीर माणु जड़ा अपु भी यीशुऐ दा चेला था, ओथु आया। ");
INSERT INTO bht_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","उनी पिलातुस बाल जाई करी यीशुऐ दी लाश मंगी। कने पिलातुसे देंणे दा हुकम देई दिता। ");
INSERT INTO bht_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","यूसुफे लाश लेई कने उसयो चीटिया चादरा च लपेटया, ");
INSERT INTO bht_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","कने उसयो अपणिया नोईया कबरां च रख्या, जड़ी उनी चट्टाना च बंणबाइयो थी, कने कबरां दे दरबाजे पर बडा पथर रखीकरी चली गिया। ");
INSERT INTO bht_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","कने मरियम मगदलीनी कने दुई मरियम ओथु कबरां दे सामणे बेठियां थियां। ");
INSERT INTO bht_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","दुऐ रोजे जड़ा तैयारिया दे रोजे ला अगला दिन था, उस रोजे बड्डे याजकां कने फरीसियां पिलातुसे बाल गिठे होईकरी बोलया, ");
INSERT INTO bht_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“हे महाराजा, सांझो याद है, कि उनी भटकाणे बाले जालू जिंदे बेले बोलया था कि, मैं उना रोजां बाद फिरी जिन्दा होई जाणा है। ");
INSERT INTO bht_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","हुकम दे कि तिन्ना रोजां दीकर सिपाई कबरां दी रखबाली करन, कुथी इयां ना हो कि उदे चेले आई करी उसयो कडी नी लेई जान, कने लोकां जो बोलन कि सै मरयां चे जिन्दा होई गिया है। तालू पिछला धोखा पेहले ला भी बुरा होणा है।” ");
INSERT INTO bht_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पिलातुसे उना जो बोलया, “तुहाड़े बाल सिपाई तां हेन जा कने अपणिया समझा दे अनुसार रखबाली करा।” ");
INSERT INTO bht_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","इस तांई उना जाई करी कबरा पर अपणे निशाणे सोगी प्रवेश दरबाजे जो बंद करिरी सुरक्षित बणाई दिता ताकि कोई इसयो अपणिया जगा ला नी हटाऐ। ");
INSERT INTO bht_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","सब्ते दे रोजे बाद हफ्ते दे पेहले रोजे पौ फटदे ही मरियम मगदलीनी कने दुई मरियम कबरां जो दिखणा आईयां। ");
INSERT INTO bht_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","कने दिखा इक बडा हिलण होया, क्योंकि प्रभुऐ दा इक स्वर्गदूत स्वर्गे ला उतरया था, कने बखे आई करी उनी पथरे जो हटाई दिता, कने उस पर बेई गिया। ");
INSERT INTO bht_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","उदा रूप बिजा सांई था कने उदे कपड़े बर्फा सांई चिट्टे थे। ");
INSERT INTO bht_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","उदे डरे ने पेहरेदार कम्मी पे, कने मुर्दयाँ सांई होई गे। ");
INSERT INTO bht_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","स्वर्गदूते जनानिया जो बोलया, “डरा मत, मिंजो पता है कि तुसां यीशुऐ जो तोपा दियां न जिसयो सूली पर चढ़ाया था। ");
INSERT INTO bht_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","सै ऐथू नी है, सै तां अपणे बचने दे अनुसार जिन्दा होई गिया है। ओआ इसा जगा जो दिखा जिथू प्रभु रखया था, ");
INSERT INTO bht_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","झट जाई करी उदे चेलयां ने बोला कि, सै मरयां चे जिन्दा होई गिया है; सै तुसां ला पेहले गलील प्रदेश जाई रिया है, ओथु तुहांजो उदे दर्शण होणे! दिखा, मैं तुसां ने बोली दिता है।” ");
INSERT INTO bht_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","कने सै डर कने बड़िया खुशिया ने कबरा ला बापस जाई करी उदे चेलयां जो खबर देंणे तांई दोड़ी गियां। ");
INSERT INTO bht_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","तालू यीशु उना जो मिला। कने बोलया, “नमस्ते।” कने उना बखे आई करी उदे पैरां जो पकड़ी करी उसयो दण्डवत किता। ");
INSERT INTO bht_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","तालू यीशुऐ उना ने बोलया, “डरा मत; मेरे चेलयां जो जाई करी बोला, कि गलील प्रदेशे जो चली जा ओथु मिंजो दिखणा है।” ");
INSERT INTO bht_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","सै जनानियां चेलयां जो ऐ खबर देणा ही चलियां थियां कि, सिपाइयां जड़े कबरा दी रखबाली करा दे थे उना शेहरे च आई करी सारा हाल बड्डे याजकां जो सुणाया। ");
INSERT INTO bht_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","तालू बड्डे याजकां, यहूदी अगुवे सोगी गिठे होईकरी सलाह बणाई। उना सिपाईयां जो रिशवत दे रूप च मता सारा धन देणे दा फेसला किता, कने उना जो बोलया। ");
INSERT INTO bht_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","तुसां सारे लोकां ने ऐ बोलनयो कि राती जालू असां सुतयो थे, तां उदे चेले आई करी उसयो चोरी लेई गे। ");
INSERT INTO bht_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","कने अगर ऐ गल्ल राज्यपाले दे कना दीकर पुजगी कि तुसां रखबाली दे बकते सोई गियो थे, तां असां उसयो समझाई लेंगे कने तुसां जो चिंता करणे दी जरूरत नी है असां बचाई लेंगे। ");
INSERT INTO bht_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","उना पेसा लेईकरी जियां उना जो सिखया था, तियां ही किता। ऐ गल्ल अजे दीकर यहूदियां च प्रचलित है। ");
INSERT INTO bht_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","कने गयारा चेले गलील प्रदेशे दे उस पाहड़े पर गे, जड़ा यीशुऐ उना जो दसया था। ");
INSERT INTO bht_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","कने उना उदे दर्शण पाई करी उसयो नमस्ते किते, पर कुसी-कुसी जो शक होया की यीशु जिन्दा होया है। ");
INSERT INTO bht_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","यीशुऐ उना बाल आई करी बोलया, स्वर्ग कने धरतिया दा सारा हक मिंजो दितया है। ");
INSERT INTO bht_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","इस तांई तुसां जाई करी सारियां जातियां दे लोकां जो चेले बणा; कने उना जो पिता, पुत्र, कने पबित्र आत्मा दे नाऐ ने बपतिस्मा दीया। ");
INSERT INTO bht_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","“कने उना जो सारियां गल्लां जिना दा मैं तुहांजो हुकम दितया है, उना जो मनणा सिखा : कने दिखा, मैं संसारे दे अंत दीकर हमेशा तुहाड़े सोगी है।”");
INSERT INTO bht_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","परमेश्वरे दे पुत्र यीशु मसीह दा शुभसमाचार इयां शुरू होया। ");
INSERT INTO bht_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","जियां परमेश्वरे दा संदेश देणेबाले यशायाह दिया कताबा च लिखया है: परमेश्वरे अपणे पुत्र, मसीह जो बोलया, “दिख, मैं अपणे संदेश देणेबाले दूते जो तेरे अग्गे भेजदा है, जिनी तेरे तांई रस्ता ठीक करणा है। ");
INSERT INTO bht_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","उसा सुनसान जगा च अबाज सुणुआ दी है कि परमेश्वर दे ओणे तांई, अपणे आपे जो तैयार करा, कने अपणे मने दी सोच समझा जो खरा रखा उनी ओणा है।” ");
INSERT INTO bht_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","यूहन्ना जड़ा संदेश देणा आया था, सै सुनसान जगा च रेंदा था कने ऐ प्रचार करदा था की, अपणे पापां जो मन्नी लिया कने गलत कम्मा जो छडी दिया तां तुहांजो परमेश्वरे माफ करणा कने बपतिस्मा लिया। ");
INSERT INTO bht_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","मते सारे यहूदिया प्रदेश दे लोक, कने यरूशलेम शेहर दे रेणेबाले लोक निकली करी उदे बाल आये, कने अपणे पापां जो मन्नी लिया कने यूहन्ने उना लोकां जो यरदने खड्डा च बपतिस्मा दिता। ");
INSERT INTO bht_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यूहन्ना ऊंटे दे बालां दे बणयो कपड़े पांदा था, कने अपणे लके च चमड़े दा पट्टा बनी रखदा था कने टिड्डे कने मखिर खांदा था। ");
INSERT INTO bht_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","जालू यूहन्ना ऐ प्रचार करदा था की, “जड़ा मेरे बाद ओंणे बाला है, सै मिंजो ला भी शक्तिशाली है, मैं तां उदे जुतयां दे तस्मे खोलणे दे काबील भी नी है। ");
INSERT INTO bht_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","मैं तां तुहांजो पांणिऐ ने बपतिस्मा दिता है, पर उनी तुहांजो पबित्र आत्मा ने बपतिस्मा देणा है।” ");
INSERT INTO bht_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","उना दिना जालू यूहन्ना बपतिस्मा दिन्दा था तालू यीशु नासरत ग्रांऐ ला गलील प्रदेशे च आया, जिथू यरदन खड्डा च यीशुऐ यूहन्ना ला बपतिस्मा लिया। ");
INSERT INTO bht_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","जालू यीशु पांणिये ला निकली करी बाहर आया तां यूहन्ने स्वर्गे जो खुलदे दिखया कने स्वर्ग ला इक पबित्र आत्मा जो कबुतरे दे रुपे च अपणे उपर ओंदे दिखया। ");
INSERT INTO bht_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","कने परमेश्वरे स्वर्ग ला ऐ आकाशवाणी किती, “की तू मेरा प्यारा पुत्र है, कने तिजो ला मैं खुश है।” ");
INSERT INTO bht_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","यीशुऐ दे बपतिस्मा लेणे बाद पबित्र आत्मा उसयो झट सुनसान जगा पासे भेजी दिता। ");
INSERT INTO bht_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","यीशु उसा सुनसान जगा च चालियां रोजां दीकर रिया, ओथु शैताने उदी परख लेई। सै बंणे दे जानवरां सोगी रिया, कने स्वर्गदूत यीशुऐ दी सेबा करदे थे। ");
INSERT INTO bht_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","कुछ बकत बीतणे बाद राजा हेरोदेसे यूहन्ना जो पकड़ी लिया कने उसयो जेला च पाई दिता, तालू यीशु गलील प्रदेश च गिया कने उना लोकां जो परमेश्वरे दे राज्य दा शुभसमाचार सुणाया। ");
INSERT INTO bht_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","कने बोलया, “परमेश्वरे जड़ा बकत दसया था सै आई गिया है, स्वर्गे दा राज्य बखे आई रिया है, अपणा मन बदला कने अपणे पापां ला पश्चाताप करा, कने परमेश्वर दे शुभसमाचारे पर भरोसा करा।” ");
INSERT INTO bht_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","इक दिन जालू यीशु गलील झिला दे बखे चलया था, तां उनी शमौन कने उदे छोटे भाई अन्द्रियास जो झिला च जाल पांदे दिखया: क्योंकि सै मच्छियां पकणने दा कम्म करदे थे। ");
INSERT INTO bht_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","यीशुऐ उना जो बोलया, “ओआ कने मेरे चेले बणा; मैं तुहांजो सिखांगा कि लोकां जो मेरे बाल कियां लोणा कने कियां मेरे चेले बणणा है।” ");
INSERT INTO bht_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","उना झट जाल छडया कने उदे पिच्छे चली पे। ");
INSERT INTO bht_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","जालू यीशु थोड़ा अग्गे चलया, उनी होर दो भाईयां जो दिखया जिना दे ना याकूब कने यूहन्ना थे, कने सै जब्दी दे पुत्र थे, सै किस्तिया पर जाले जो ठीक करा दे थे। ");
INSERT INTO bht_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","यीशुऐ उना जो दिखया कने उना जो बोलया मेरे सोगी चला कने मेरे चेले बणा; कने सै अपणे पिता जब्दी कने मजदूरां जो किस्तिया पर छडी करी, उदे चेले वणने तांई उदे पीच्छे चली पे। ");
INSERT INTO bht_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","यीशु कने उदे चेले कफरनहूम शेहरे च आये, कने सै सब्त दे रोजे यहूदी जंज घरे च जाई करी उपदेश करणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","कने लोक उदे उपदेश सुणीकरी बड़े हेरान होए; क्योंकि सै उना जो यहूदी व्यवस्था जो सिखाणे बालयां सांई नी, पर अधिकारे ने उपदेश दिन्दा था। ");
INSERT INTO bht_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","जालू यीशु उपदेश दे दा था, तालू यहूदी जंज घर च इक माणु था, जिदे बिच इक बुरी आत्मा थी। ");
INSERT INTO bht_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","उनी जोरे ने बोलया, “हे नासरत दे यीशु मसीह, तु सांझो कजो तंग करदा है? तू क्या सांझो खत्म करणा आया है? मिंजो पता है की, तू कुण है? तु ही परमेश्वर दा पबित्र पुत्र मसिहा है, जड़ा परमेश्वरे ला आया है।” ");
INSERT INTO bht_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","यीशुऐ बुरिया आत्मा जो झिड़कया कने बोलया, “चुप रे; कने इस माणुऐ ला निकली जा।” ");
INSERT INTO bht_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","तालू सै बुरी आत्मा उसयो मरोड़ी करी, कने जोरे ला चिलाई करी उदे चे निकली गेई। ");
INSERT INTO bht_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","यहूदी जंज घरे च आयो सारे लोक हेरान होइ गे, कने इसा गल्ला जो इकी दुजे ला पुछणा लग्गे, “ऐ कदिया उपदेश है? असां कदी भी इतणे हके ला उपदेश दिन्दे नी सुणया है!” कने बुरी आत्मा इदियां गल्लां जो मंदियां भी हेन। ");
INSERT INTO bht_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","कने उदे बाद यीशुऐ जड़ा भी किता, उदे बारे च लोक इकी दुज्जे जो दसदे रे कने झट सारे गलील प्रदेशे दे लोकां ने यीशुऐ दे बारे च सुणी लिया। ");
INSERT INTO bht_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","जियां ही यीशु कने उदे चेले यहूदी जंज घर ला निकले, तां सै शमौन कने अन्द्रियास दे घरे जो गे कने याकूब कने यूहन्ना उदे सोगी थे। ");
INSERT INTO bht_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","उस बकत शमौने दिया ससु जो बड़ा भरी बुखार था कने सै बिस्तरे च पियो थी, जालू यीशु घरे पुज्जा तालू उसयो कुनकी चेले दसया कि शमौने दिया ससु जो बुखार है। ");
INSERT INTO bht_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","तालू यीशुऐ उसा दे बखे जाई करी उसा दा हथ पकड़ी करी उसा जो जगाया, कने उसा दा बुखार खरा होई गिया, कने सै उना दी सेबा करणा लगी पेई। ");
INSERT INTO bht_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","उसी रोजे संझा दे बकते जालू सब्ते दा दिन मुकी गिया, उदे नगरे च मते लोक बिमार थे कने जिना च बुरियां आत्मा थियां, उना सारयां जो यीशुऐ बाल लेई आये। ");
INSERT INTO bht_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","मते सारे लोक घरे दे दरबाजे सामणे गिठे होई गये। ");
INSERT INTO bht_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","उनी मतयां जो जिना जो बड़े प्रकार दियां बिमारियाँ थियां, उना जो ठीक किता, कने मतियां बुरियां आत्मा कडी दितियां, कने बुरियां आत्मा जाणदियां थियां की ऐ परमेश्वर दा पुत्र है, उना जो बोलणे दा हुकम नी था। ");
INSERT INTO bht_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ब्यागा ध्याड़ा निकलने ला पेहले, यीशु उठया कने निकली करी इक सुनसान जगा पर जाई करी ओथु प्राथना करणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","तालू शमौन कने उदे सोगियां जो पता लग्गा, की सै चली गिया, तां सै उसयो तोपणा गे। ");
INSERT INTO bht_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","जालू सै मिल्ला, तां उना उसयो दसया, “की मते सारे लोक तिजो तोपा दे थे।” ");
INSERT INTO bht_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","यीशुऐ उना जो बोलया, “चला; असां अखे बखे दे ग्रांऐ च चलदे न ताकि ओथु भी परमेश्वर दे संदेश दा प्रचार करी सकन, क्योंकि मैं इसी तांई इसी संसारे च आया है।” ");
INSERT INTO bht_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","कने यीशु सारे गलील प्रदेश दे यहूदी जंज घरां च जाई-जाई करी उपदेश दिन्दा, कने बुरियां आत्मा जो कडदा था। ");
INSERT INTO bht_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","इक कोढ़ी माणु था, सै यीशुऐ बाल आया, कने उदे सामणे गोडे भार बेईकरी, उसयो बिनती किती कने बोलया, “मैं जाणदा है कि तू चाआं तां मिंजो ठीक करी सकदा है।” ");
INSERT INTO bht_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","यीशुऐ उस पर तरस खाई करी अपणा हथ गां किता जिसयो कोढ़ था, कने उसयो छूता कने बोलया, “मैं चांदा है की तू ठीक होई जा।” ");
INSERT INTO bht_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","कने झट उदा कोढ़ ठीक होणा लगी पिया, कने सै ठीक होई गिया। ");
INSERT INTO bht_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","तालू यीशुऐ उसी माणुऐ जो सकत चेतावनी देईकरी भेजया, ");
INSERT INTO bht_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","कने उसयो बोलया, “दिख, कुसी ने कुछ मत बोलदा, पर जाई करी अपणे आपे जो याजकां ने दस, की तु खरा होईया कने परमेश्वरे जो भेंट चढ़ा जिदे बारे च मूसा बड़ी पेहले लिखया था, ताकि लोक जाणी सकन की तु खरा होई गिया।” ");
INSERT INTO bht_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","पर सै बाहर जाई करी इसा गल्ला दा बड़ा भरी प्रचार करणा लग्गा कने उनी ऐ ऐथू दीकर फेलाई दिती, कि यीशुऐ उसयो खरा करी दिता कने यीशु शरेआम बाहर शेहरे च नी जाई सकदा था, फिरी सै बाहर सुनसान जगा च रिया; कने चारो पासे दे लोक उदे बाल ओंदे रे। ");
INSERT INTO bht_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","मतयां रोजां बाद जालू यीशु कफरनहूम शेहरे च मुड़ी करी आया कने तां ओथु दे लोकां जो पता चली गिया कि सै घरे आया है। ");
INSERT INTO bht_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","फिरी मते सारे लोक गिठे होए, उस बजा ने घरे मती भीड़ होई गेई, ऐथू दिकर की दरबाजे बाल भी जगा नी रेई; कने सै उना जो परमेश्वर दे बचने चे प्रचार करा दा था। ");
INSERT INTO bht_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","कने इक धरंग होयो मरीजे जो चार माणु मंझे पर चुकी करी उदे बाल लेई आये। ");
INSERT INTO bht_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","पर जालू सै भीड़ा दिया बजा ला यीशुऐ बखे नी जाई सके, तां उसा छती जो जिसा हेठ सै बैठया था, उना से पुटी करी रस्ता बणाई दिता, कने जालू सै पुटी बैठे, तां उना उसयो मंझे समेत छती ला थले लटकाई दिता। ");
INSERT INTO bht_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","यीशुऐ उना दा भरोसा अपणे उपर दिखीकरी, उस धरंग होयो मरीजे जो बोलया, हे पुत्र, “मैं तेरे पापां जो माफ किता।” ");
INSERT INTO bht_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","तालू केई यहूदी व्यवस्था जो सिखाणे बाले ओथु बैठयो थे, सै अपणे-अपणे मने च सोचणा लग्गे, ");
INSERT INTO bht_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ऐ माणु ऐसियां गल्लां कजो बोला दा है? ऐ तां परमेश्वरे दी निंदा करा दा है। परमेश्वरे जो छडी करी होर कुण पापां जो माफ करी सकदा है?” ");
INSERT INTO bht_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","यीशुऐ अपणी आत्मा च झट जाणी लिया, की सै अपणे मने च ऐसा सोचा दे न, कने उनी यहूदी गुरूआं जो बोलया, “तुसां ऐसा कजो सोचा दे न। ");
INSERT INTO bht_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","क्या धंरग होयो मरीजे जो ऐ बोलणा सोखा है, की तेरे पाप माफ होये, या ऐ बोलणा की, उठ अपणे मंजे जो चुकी करी हंड फिर? ");
INSERT INTO bht_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","पर मैं तुहांजो दसणा चांदा है की मैं, माणुऐ दा पुत्र जिसयो धरतिया पर पाप माफ करणे दा हक है।” कने उस धरंग होयो मरीजे जो बोलया, ");
INSERT INTO bht_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“मैं तिजो बोलदा है की, उठ, कने अपणे मंझे जो चुक कने अपणे घरे जो चली जा।” ");
INSERT INTO bht_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","सै झट उठया कने मंझा चुक्या कने चली गिया, सारे लोक जड़े दिखा दे थे सै हेरान होए, कने सारे लोक परमेश्वर दी बड़ाई करिके बोलणा लग्गे, “असां इयोदिया कदी नी दिखया।” ");
INSERT INTO bht_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","इक बरी फिरी यीशु निकली करी झिला बखे गिया, कने मते सारे लोक उदे बाल आऐ, कने सै उना जो परमेश्वर दे बचना दा उपदेश देणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","यीशु जियां ही अग्गे निकलया, तालू उनी लेवी नाये दे कर लेणेबाले माणुऐ जो दिखया, जिदा दुज्जा ना मत्ती था। उदे पिता दा ना हलफईस था। जड़ा अपणिया चौकियां पर बैठया था, जिथू से कर लेंदा था। कने यीशुऐ उसयो बोलया, “मेरे चेले बणा।” कने सै उठी करी सारा कम्म कार छडी करी यीशु पिच्छे चली पिया, कने उदा चेला बणी गिया। ");
INSERT INTO bht_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","उदे बाद यीशु कने उदे चेले लेवी दे घरे राती रोटीयां खांणा बैठयो थे। तालू मते भरी चुंगी लेणेबाले कने पापी भी चेलयां सोगी रोटियां खाणे तांई बैठयो थे। सै मते भरी थे जड़े यीशुऐ पिच्छे चलयो थे। ");
INSERT INTO bht_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","मूसा दिया व्यवस्था जो सिखाणे बाले कने फरीसियां जालू ऐ दिखया, की जिना जो लोक पापी बोलदे थे, सै उना सोगी रोटीयां खा दा है, तां उना लोका यीशुऐ दे चेलयां जो बोलया, “ऐ तां चुंगी लेणेबाले कने पापियां सोगी खांदा पिंदा है।” ");
INSERT INTO bht_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","जालू यीशुऐ ऐ सुणया तां उना जो बोलया, “जड़े लोक खरे न उना जो वैद्ये दी जरूरत नी होंदी है, पर जड़े बिमार न उना जो है। मैं उना लोकां जो सदणे जो नी आया जड़े अपणे आपे जो धर्मी मंदे न, पर की जड़े लोक अपणे आपे जो पापी मंदे न, मैं उना तांई आया है।” ");
INSERT INTO bht_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","यूहन्ना दे चेले, कने फरीसी बरत रखदे थे सै बिना कुछ खादयो रेंदे थे; इक दिन उना चे कुछ चेले यीशुऐ बाल आये कने पुछया की, “यूहन्ना दे चेले कने फरीसियां दे चेले बरत कजो रखदे न, पर तेरे चेले तां बरत रखदे नी न?” ");
INSERT INTO bht_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","यीशुऐ उना जो बोलया, “मरे चेले कने मैं, लाड़ा कने उदे मित्रां सांई न। क्या लाड़े दे मित्र तालू दीकर बरत रखी सकदे ने जालू दिकर पुरे बियाये च उदे सोगी न? जालू दीकर लाड़ा उना सोगी है तालू दीकर सै बरत नी करी सकदे न। ");
INSERT INTO bht_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","पर सै दिन ओणे न, जालू लाड़ा उना ला लग कितया जाणा है, तालू इना बरत रखणे न। ");
INSERT INTO bht_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","लोक नोऐ कपड़े दा रफु पराणे कपड़यां च कोई नी पांदा है, नी तां उनी रफुये धोणे ने सुकड़ी जाणा, कने पुराणा कपड़ा होर जादा फटी जाणा। मेरियां गल्लां भी पुराणे रिती रिबाजां सोगी जोड़गे तां इसी कपड़े सांई से भी बेकार होई जाणियां। ");
INSERT INTO bht_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","नोऐ अंगूरा दे रसे जो परांणिया खलड़िया दे झोले च कोई नी रखदा है, नी तां नोआ अंगूर रस खलड़िया जो फाड़ी दिन्दा है, कने अंगूर रस खलड़िया जो खत्म करी दिन्दा है; तांई तां नोआ अंगूर रस नोईयां खलड़िया च नी रखदे न।” ");
INSERT INTO bht_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","इयां होया की यीशु कने उदे चेले सब्ते दे रोजे खेतरां च होईकरी जा दे थे; कने उदे चेले चलदे-चलदे बेलां जो तोड़ी करी खाणा लग्गी पे। ");
INSERT INTO bht_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","तालू फरीसियां बोलया, “की तेरे चेले इयोदे कम्म कजो करदे न जड़े नियमा दे अनुसार सब्त दे दिने करणा ठीक नी होंदे न?” ");
INSERT INTO bht_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","यीशुऐ उना जो बोलया, “तुसां क्या कदी नी पढ़या की जालू साड़े महान राजा दाऊदे जो जरूरत पेई, कने जालू सै कने उदे साथी भूखे थे तां उनी क्या किता था? ");
INSERT INTO bht_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","कि इक अबियातार नाऐ दा महायाजक था, जालू दाऊद कने उदे सोगी मित्र भुखे थे, तालू उना परमेश्वरे दे तम्बू च जाई करी रोटियां खादियां जड़ियां परमेश्वरे जो चढ़ाईयां थियां, कने अपणे सोगियां जो भी खुआईयां, इना रोटियां जो खांणे दा हक याजकां जो छडी करी होर कुसयो नी था।” ");
INSERT INTO bht_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","तालू यीशुऐ उना जो बोलया, “परमेश्वरे लोकां दिया भलाईया वासते सब्ते दा रोज बणाया है, उनी सब्ते बाले रोजे उना उपर भार पाणे तांई नी बणाया है। ");
INSERT INTO bht_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","मैं, माणुऐ दा पुत्र ऐ बोलणे दा हक रखदा है कि लोकां जो सब्ते बाले रोजे जो क्या करणे दी अनुमति है।” ");
INSERT INTO bht_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","इक होर सब्ते बाले रोजे यीशु यहूदी जंज घर च आया; ओथु इक माणु था, जिदा इक हथ सुक्की कने बेकार होई गिया था। ");
INSERT INTO bht_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","कने फरीसी यीशुऐ उपर कोई दोष लाणे तांई बहाना तोपा दे थे, तालू कुछ माणु यीशुऐ जो बडिया गोरा ने दिखणा लग्गे, की यीशु उसया सब्ते बाले रोजे खरा करगा की नी। ");
INSERT INTO bht_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","यीशुऐ उस सुक्यो हथे बाले जो बोलया, “सारयां लोका दे बिच खड़ोई जा।” ");
INSERT INTO bht_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","कने उना ने बोलया, “क्या परमेश्वर सांझो सब्ते दे रोजे लोकां जो खरा कम्म करणे दा हुकम दिन्दा है, कि नीच कम्म करणे दा? क्या सांझो सै कुसी माणुऐ दे प्राण बचाणे दा हुकम दिन्दा कि मारणे दा?” पर सै सारे चुप रे। ");
INSERT INTO bht_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","यीशुऐ जो जालू गुस्सा आया तालू उनी उना लोकां दे चारों पासे दिखया। कने यीशु बड़ा उदास होया की सै बड़े कठोर कने जिद्दी माणु न। कने उस माणुऐ जो बोलया, “अपणा हथ कर रुआं।” उनी किता, कने उदा हथ खरा होई गिया। ");
INSERT INTO bht_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","तालू फरीसी झट बाहर आई करी राजा हेरोदियां दे गिरोह दे कुछ लोकां कने मिली करी उदे खिलाफ सलाह करणा लग्गे, की उसयो कियां मारणा है। ");
INSERT INTO bht_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","कने उदे बाद यीशु अपणे चेलयां सोगी झिल्ला दे पासे चली गिया: कने गलील प्रदेशे ला बड़ी भरी भीड़ उदे पिच्छे चली पेई। ");
INSERT INTO bht_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","कने यहूदिया जिले, कने यरूशलेम शेहर कने इदूमिया जिले ला, कने यरदने खड्डा दे पारे ला, कने सूर कने सैदा शेहरे दे अखे बखे लोक ऐ सुणीकरी यीशु वाली आये, कि यीशु बड़े हेरान कने चकित करणे बाले कम्म करदा है। ");
INSERT INTO bht_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","यीशुऐ अपणे चेलयां जो बोलया, “मिजों बोणे तांई इक छोटी किस्ती लेईकरी ओआ, ताकि लोक मिंजो वाली भीड़ नी लगाई सकन।” ");
INSERT INTO bht_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","उनी उसी रोजे मतयां जो ठीक किता। उदिया बजा ला, मते सारे लोक जड़े बिमार थे, सै यीशुऐ जो छुंणे दी कोशिश करा दे थे। ");
INSERT INTO bht_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","कने बुरियां आत्मा ला जकड़यो लोक, जालू यीशुऐ जो दिखदे थे, तां यीशुऐ जो इज्जत देणे तांई उदे पैरां अग्गे डेई पोंदे थे, कने जोरे-जोरे ने बकदे थे, “की तू परमेश्वरे दा पुत्र है।” ");
INSERT INTO bht_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","कने यीशुऐ चेतावनी देईकरी बुरी आत्मां जो बोलया, “कि मेरे बारे च कुसी ने भी मत दसदे कि मैं परमेश्वर दा पुत्र है।” ");
INSERT INTO bht_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","उदे बाद यीशु इक धारा पर चढ़ी गिया, कने उना जो अपणे बाल सदया जिना जो सै चांदा था, कने सै उदे बाल आये। ");
INSERT INTO bht_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","तालू उनी बाहरां माणुऐ जो चुणयां। जड़े उदे खास चेले बणे, उनी उना जो प्रेरित दा ना दिता, कने सै चांदा की सै उदे सोगी-सोगी रेंन, कने यीशु उना जो भेजे की सै प्रचार करन, ");
INSERT INTO bht_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","कने बुरियां आत्मा जो कडणे दा हक दिता। ");
INSERT INTO bht_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ऐ सै बाहरा चेले न, जिना जो यीशुऐ चुणया था: शमौन जिदा ना उनी पतरस रखया; ");
INSERT INTO bht_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ऐ दो भाई जिना दा ना याकूब कने यूहन्ना है, सै जब्दी दे पुत्र थे, जिसयो यीशु ने बुअनरगिस बोलया, कने उदा मतलव गड़कने बाले माणु। ");
INSERT INTO bht_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","कने अन्द्रियास, कने फिलिप्पुस, कने बरतुल्मै, कने मत्ती, कने थोमा, कने हलफईये दा पुत्र याकूब, कने तद्दै, कने शमौन कनानी जड़े क्रांति लयोणे बाले थे, ");
INSERT INTO bht_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","कने यहूदा इस्करियोती, जिनी उसयो दुशमणा दे हथे पकड़ाई भी दिता था। ");
INSERT INTO bht_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","कने यीशु ग्रांऐ दे कुसी घरे च आया, कने ओथु इतणी भीड़ गिठी होई गेई, की उसयो रोटी खाणे दा भी बकत नी मिला। ");
INSERT INTO bht_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","जालू उदे रिशतेदारां ऐ सुणया, तां सै उसयो घरे जो लेई जाणे तांई आये, क्योंकि सै बोलदे थे, की इदे होस ठीक होणे च नी है। ");
INSERT INTO bht_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","कने सै जड़े मूसा दी व्यवस्था जो सिखाणे बाले थे, सै यरूशलेम शेहरे ला आयो थे, सै भी ऐ बोलदे थे की, “इदे च शैतान है,” कने “सै बुरियां आत्मा दा सरदार है, कने शैताने दिया मददा ने बुरियां आत्मा जो कडदा है।” ");
INSERT INTO bht_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","इस तांई सै उना जो बखे सदीकरी, उना जो कहाणिया च बोलणा लग्गा, “क्या शैतान अपणी ही बुरी आत्मां जो लोकां ला बार कडणे तांई जोर पांगा? नी, जरा भी नी!” ");
INSERT INTO bht_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","अगर कुसी राज्य च लोक अपु च ही लड़दे रेंगे तां सै राज्य बड़े बकते तक नी टिकी सकदा है। ");
INSERT INTO bht_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","कने अगर कुसी घरे दे माणु अपु च ही लड़ी पोंगे तां सै घर नी चली सकदा। ");
INSERT INTO bht_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","अगर शैतान अपणा ही बैरी बणिया कने अपु ने ही लड़गा, तां उनी अपणा ही नाश करी लेणा है। ");
INSERT INTO bht_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","कोई भी माणु जोरे बाले माणुऐ दे घरे जो नी लुटी सकदा, जालू दीकर सै पेहले, उस माणुऐ जो बन्नी नी ले; तां जाई करी सै उदे घरे जो लुटी सकदा है। ");
INSERT INTO bht_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“मैं तुसां ने सच्च बोलदा है, की माणुऐ दी ओलादी दे सारे पाप कने निंदा जड़ा सै परमेश्वर या कुसी दे खिलाफ करदे न, परमेश्वरे उना दे पाप माफ करी देणे न; ");
INSERT INTO bht_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","पर जड़ा कोई पबित्र आत्मा दे खिलाफ निंदा करगा, तां सै परमेश्वरे कदी भी माफ नी करणा है। कने परमेश्वर इसी पापे तांई उस माणुऐ जो हमेशा तांई दोषी मनणा है।” ");
INSERT INTO bht_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","यीशुऐ ऐ इस तांई बोलया क्योंकि सै ऐ बोलदे थे, की उसयो बुरिया आत्मा जकड़या है। ");
INSERT INTO bht_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","तालू यीशु दी मां कने उदे भाई आये, कने उना बाहर खड़ोई करी उसयो बुलाबा भेजया। ");
INSERT INTO bht_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","भीड़ उदे अखे बखे बैठियो थी, कने उना उसला बोलया, “दिख, तेरी माता कने तेरे भाई तिजो तोपा दे न।” ");
INSERT INTO bht_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","यीशुऐ उना जो जबाब दिता, “मेरी माता कने मेरे भाई कुण न?” ");
INSERT INTO bht_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","कने उनी उना पासे नजर दिती जड़े उदे अखे बखे बैठयो थे कने बोलया, “दिखा, मेरी माता कने मेरे भाई न। ");
INSERT INTO bht_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","सै सेई ही करदे न जड़ा परमेश्वर चांदा है, सै ही मेरे भाई, बेहण कने माता पिता न।” ");
INSERT INTO bht_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","यीशु फिरी गलील झिला दे बखे उपदेश देणा लग्गा, कने ओथु इतणी भरी भीड़ गिठी होई गेई, की सै झिला च इक किस्तिया पर चढ़ी करी बेई गिया, कने सारे लोक झिला दे बखे खड़ोई रे। ");
INSERT INTO bht_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","कने सै उना जो कहाणी सुणाणा लग्गा, कने अपणे उपदेश च उना ने बोलया, ");
INSERT INTO bht_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“सुंणा इक किसान अपणे खेतरे च बी रांणे तांई गिया। ");
INSERT INTO bht_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","रांदे बेले थोड़े बी रस्ते दे बखे पेई गे कने सै तां पंछियां आई करी चुगी ले। ");
INSERT INTO bht_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","कने थोड़े बी पथरलिया जमिना पर पे जिथू उसयो जादा मिटी नी मिली, कने जादा मिटी नी होणे दिया बजा ने तौली लूंगी पै। ");
INSERT INTO bht_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","कने जालू खड़ी धुप पेई, तां सै फकुई गे, क्योंकि उना दियां जड़ा डुगियां नी थियां तां सै सुकी गे। ");
INSERT INTO bht_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","कने थोड़े बी झिल्लां च पे, कने जालू झिल्ल बदे तां उना सै बी डकी ले, कने उना फल नी दिता। ");
INSERT INTO bht_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","पर थोड़े बी खरिया जमिना पर पे, कने सै बी लुंगे, कने मते सारे फल देणेबाले होए; केईयां ती गुणा, केईयां सठ गुणा, केईयां सौ गुणा।” ");
INSERT INTO bht_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","तालू उनी बोलया, “जिस बाल सुणने तांई कन्न न सै ध्यान लाईकरी गल्लां जो सुणे, कने इसा गल्ला जो समझी ले।” ");
INSERT INTO bht_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","जालू यीशु किल्ला रेई गिया, तां बाहरा चेले कने जड़े सोगी थे सै उसला इसा कहाणिया दा मतलब पुछणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","उनी उना जो बोलया, “तुसां तां परमेश्वरे दे राज्य दियां छुपियां होईयां सच्चियां गल्लां दसियां न, पर ऐ कहाणी बाहरे बाले लोकां तांई थी, सै जड़े मिजों पर भरोसा नी रखदे। ");
INSERT INTO bht_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","जियां कि पवित्रशास्त्र च लिखया है, सै तिनां जो मिलदे होए भी नी मिलदा कन्ना ने सुणदे होए भी सै नी सुणदे कने समझदे; इयां नी होऐ की सै अपणे बुरे कम्मा जो छडी देन, कने उना जो माफ करणा पोऐ।” ");
INSERT INTO bht_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","फिरी यीशुऐ उना जो बोलया, “तुसां इना गल्लां जो नी समझगे, तां फिरी तुसां होरा कहाणियां जो कियां समझगे। ");
INSERT INTO bht_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","इसा कहाणिया दा ऐ मतलव है, बी राणे बाला इयोदिया है जियां कोई परमेश्वरे दे बचना दा प्रचार लोकां च करदा है। ");
INSERT INTO bht_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","जड़ा बी रसते च पिया उदी तुलना उना लोकां ने कितियो है, जड़ा परमेश्वर दे बचन सुणदे न। पर शैतान झट पट जादां कने उना दे मने ला बचन कडी दिन्दा है जड़ा उना सुणया था। ");
INSERT INTO bht_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","कने थोड़े लोक उस पथरे वालिया जमिना सांई न जिथू बी पिया था, ऐ सै माणु न, जड़े बचना जो सुणीकरी उना जो झट खुशिया ने ग्रहण करी लेंदे न। ");
INSERT INTO bht_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","पर परमेश्वर दे बचना जो मने दिया गहराईया च बदणा नी दिन्दे, उदे बाद जालू बचने दिया बजा ने उना पर कला क्लेश या परेशानी होंदी है, तां सै बचना ला पिच्छे हट्टी जांदे न। ");
INSERT INTO bht_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","जड़े बी झिल्लां च पियो न, ऐ सै माणु न जिना बचन सुणया, ");
INSERT INTO bht_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","पर सै संसारे दियां चिंता जो लेईकरी दुखी, कने संसारिक चिंजा दिया मोहमाया च फसी जांदे न, ऐ सब कुछ परमेश्वरे दे बचन च रुकावट पांदा है। कने सै बचन उना तांई फायदेमंद नी होंदा। ");
INSERT INTO bht_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","कने जड़े बी खरिया जमिना पर रायो थे, ऐ सै माणु न, जड़े बचन सुणीकरी ग्रहण करदे न, कने फल दिन्दे न, कोई ती गुणा, कोई सठ गुणा, कने कोई सौ गुणा।” ");
INSERT INTO bht_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","यीशुऐ उना जो बोलया, “क्या कोई दिय्ये जो जल्लाई करी उसयो इक टोकरू या मंजोलिया दे जिक इस तांई रखदा है की उदिया लौई जो लुकाई सके? ना जरा भी नी। दिय्ये जो ताके उपर रखदे न, जिथू ला उदी लोअ चमकी सके।” ");
INSERT INTO bht_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","क्योंकि जड़ा कुछ भी लुकया है, सै सामणे करणा; कने हर इक गुप्त गल्ल सामणे आई जाणी है। ");
INSERT INTO bht_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“जिस बाल सुणने तांई कन्न न सै ध्यान लाईकरी गल्ला जो सुणे, कने इसा गल्ला जो समझी ले।” ");
INSERT INTO bht_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","यीशुऐ उना जो बोलया, “ध्यान रखा, की जितणा तुसां ध्याने ने बचना जो सुणगे, तुसां जो उतणा ही जादा समझ ओणा है, उदे साबे ने परमेश्वरे तुहांजो देणा है। जिस नापे ने तुसां नापदे न उसी नापे ने तुहाड़े तांई नापया जाणा है, कने तुसां जो जादा दितया जाणा है। ");
INSERT INTO bht_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","जिना बाल जड़ा परमेश्वर सिखांदा है उसयो समझणे दी इच्छा है, उना जो परमेश्वरे होर समझ देणी, पर जड़ा समझणे दी इच्छा नी रखदा, की मैं क्या सिखादां, तां सै जड़ा समझया है, परमेश्वरे उसला सै भी लेई लेणा।” ");
INSERT INTO bht_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","यीशुऐ उना जो बोलया, “परमेश्वरे दा राज्य ऐसा है, जियां कोई किसान खेतरे च बी रांदा है, ");
INSERT INTO bht_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","जालू उनी बी राई दिते उनी फिरी दुबारा मुड़ी करी बी नी दिखया कने अपणे रोजाने बाले कम्मा करदा रिया। पर जड़ा उनी बी राऐ थे, सै बी लुंगे कने बड्डे होए, कने से जाणदा भी नी की ऐ कियां होया। ");
INSERT INTO bht_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","धरती अपु ही फल दिन्दी है, पेहले लूंगा, फिरी सिल्ले, फिरी सिल्यां च तैयार दांणा। ");
INSERT INTO bht_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","पर जालू सै दाणे पकी जांदे न, तालू सै किसान ओंदा कने दराटिया ने बडणा लगदा, क्योंकि बडणे दा बकत आई गिया था।” ");
INSERT INTO bht_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","फिरी यीशुऐ कहाणी सुणाई, “असां परमेश्वरे दे राज्य दी तुलना इयां करी सकदे न, जियां तुसां जो मैं कहाणी दसदा। ");
INSERT INTO bht_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","कने परमेश्वर दा राज्य धरती दे सारे बियां ला सबला छोटे बी राईऐ दे बियां सांई है। ");
INSERT INTO bht_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","पर जालू जमिना च रांदे न, तां सै उगी करी सारे साग पतरां ला बडा होई जांदा है, कने उदियां इतणियां बडियां डालियाँ निकलदियां न की अम्बरे दे पंछी भी उदिया छोआं च रेहणे तांई डालियाँ च घोंसले बणाई सकदे न।” ");
INSERT INTO bht_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","कने सै लोकां जो परमेश्वरे दे राज्य दे बारे च दसणे तांई हरबरी कहाणिया दा इस्तेमाल करदा था, जड़ियां उना जो समझ आई जान। ");
INSERT INTO bht_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","कने सै हमेशा परमेश्वरे दे राज्य दियां गल्लां कहाणिया च बोलदा था, पर जालू सै किल्ला होंदा था, तां सै अपणे चेलयां जो सारियां गल्लां दसदा था। ");
INSERT INTO bht_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","उसी दिने सझां दे बेले, उनी अपणे चेलयां ने बोलया, “ओआ, असां गलील झीला दे पार चलदे न।” ");
INSERT INTO bht_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","कने चेले भी भिड़ा जो छडी करी उसा किस्तिया पर चढ़ी गे, जिसा पर यीशु बैठया था। कने सै यीशुऐ जो अपणे कने लेई गे। ओथु उना सोगी होर भी किस्तियां थियां। ");
INSERT INTO bht_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","तालू सै झीला जो पार करा दे थे, तां बड़ा भरी तूफान आया कने लेहरां किस्ती ने बजियां, किस्तिया च पाणी भरुईया कने किस्ती डुबणे वाली थी। ");
INSERT INTO bht_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","कने यीशु पिछले हिस्से च सुतया था, तालू उना उसयो जगाई करी बोलया, “गुरू जी, तिजो क्या साड़ी कोई फिकर नी है, की असां मरणे बाले न?” ");
INSERT INTO bht_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","तालू उनी उठी करी तुफाने जो डांटया, कने लेरां जो बोलया, “शांत रिया, रुकी जा!” कने हवा रुकी गेई कने झील शांत होई गेई। ");
INSERT INTO bht_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","कने उनी तालू चेलयां ला पुछया, “तुसां कजो डरदे न? क्या तुहांजो हले दीकर मिंजो पर भरोसा नी है?” ");
INSERT INTO bht_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","सै बड़े भरी डरी गे कने अपु चे बोलणा लग्गे, “ऐ कदिया माणु है? ऐथू तक की तूफान कने लैहरां भी इदा हुकम मंदे न।” ");
INSERT INTO bht_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","यीशु कने उदे चेले गलील झिला दे पार गिरासे दे लोकां दिया जगा च पुज्जे, ");
INSERT INTO bht_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","जालू यीशु किस्तिया ला थले उतरया तालू इक माणु जिसयो बुरिया आत्मा जकड़या था, सै कब्रिस्तान ला निकलया कने यीशुऐ बाल आया। ");
INSERT INTO bht_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","सै कब्रिस्तान च रेंदा था कने लोक उसयो बन्नी करी नी रखी पांदे थे, ऐथू दिकर की लोहे दे सुगंला ने भी नी। ");
INSERT INTO bht_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","क्योंकि उसयो बड़ी बरी बेड़ियाँ कने सुंगला ने बनया था, पर सै उना सुंगला जो तोड़ी दिन्दा, कने बेड़ियाँ दे टोटे-टोटे करी दिन्दा था, कने उसयो कोई भी काबू च नी करी सकदा था। ");
INSERT INTO bht_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","सै रात दिन कब्रिस्तान कने पाहड़ा च जोरे-जोरे बकदा रेंदा, कने अपणे आपे जो पथरा ने जख्मी करदा रेंदा था। ");
INSERT INTO bht_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","सै यीशुऐ जो दुरे ला ही दिखीकरी दोड़या, कने यीशुऐ जो इज्जत देणे तांई उदे पैरां अग्गे डेई पिया। ");
INSERT INTO bht_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","उनी जोरे ने चिलाई करी बोलया, “यीशु जी, परमपिता परमेश्वरे दे पुत्र, तु मिंजो कजो सता दा है? तु परमेश्वरे दे ना लेईकर कसम खा की तु मिंजो नी सतांगा।” ");
INSERT INTO bht_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","उनी ऐ बोलया क्योंकि यीशुऐ उसयो पेहले ही हुकम देई दितया था, “हे बुरी आत्मा, इस माणुऐ ला तु निकली जा।” ");
INSERT INTO bht_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","यीशुऐ उसा बुरिया आत्मा जो पुछया, “तेरा क्या ना है?” उनी बोलया, “मेरा ना सेना है, क्योंकि असां मते सारे न।” ");
INSERT INTO bht_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","कने उना बुरियां आत्मा उसला बड़ी बिनती किती, “की सांझो गिरासे दे इलाके ला बाहर मत भेजा।” ");
INSERT INTO bht_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ओथु धारा पर इक सूअरां दा झुण्ड चुग्गा दा था। ");
INSERT INTO bht_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","कने बुरियां आत्मा यीशुऐ ने बिनती करिके बोलया, “की सांझो इना सूअरां च भेजी दे ताकि असां इना दे अंदर जाई सकन।” ");
INSERT INTO bht_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","यीशुऐ उना जो हुकम दिता कने सै बुरियां आत्मा उसी माणु ला निकली करी सूअरां दे अंदर समाई गियां, कने उसी झुण्डे च कोई दो हजार सूअर थे, कने खड़े डडे पासे दौड़े कने रिड़की करी झिला च जाई पे कने डूबी करी मरी गे। ");
INSERT INTO bht_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","उना दे पुहालां नठी करी शेहर कने ग्रांऐ च ऐ खबर सुणाई, कने जड़ा होया था लोक उसयो दिखणा आये। ");
INSERT INTO bht_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","यीशुऐ बाल आई करी, उना उसयो दिखया जिदे च बुरियां आत्मा थियां, उसयो कपड़े पाई करी कने खरा बैठया दिखीकरी सै डरी गे। ");
INSERT INTO bht_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","दिखणे बालयां उदा जिदे बिच बुरियां आत्मा थियां, कने सूअरां दा पूरा हाल, बाकियां जो दसया। ");
INSERT INTO bht_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","तालू जड़े लोक दिखणा आयो थे, सै यीशुऐ ने बिनती करिके बोलणा लग्गे, कि साड़े इलाके ला चली जा। ");
INSERT INTO bht_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","जालू यीशु किस्तिया पर जाणे तांई चढ़या, तां सै जिदे च पेहले बुरियां आत्मा थियां, सै यीशुऐ ने बिनती करणा लग्गा, “की मिंजो भी अपु सोगी रेंणा दे जियां बाहरा चेले उदे सोगी रेंदे थे।” ");
INSERT INTO bht_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","पर यीशुऐ उसयो अपणे सोगी चलणे तांई मना करी दिता, कने उसयो बोलया, “अपणे घरे जाई करी अपणे लोकां जो दस, की प्रभुऐ तिजो पर दया करिके तेरे तांई कदेया कम्म किता है।” ");
INSERT INTO bht_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","तालू सै माणु अपणे घरे दे इलाके च चली गिया। फिरी उनी सारे दिकापुलिस जिदा मतलव “दस शेहर” च ऐ प्रचार करणा शरू किता, कि यीशुऐ मेरे तांई बड़ा कुछ कितया है, कने उसयो सुणनेबाले सारे लोक हेरान होऐ। ");
INSERT INTO bht_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","जालू यीशु दोबारा किस्तिया च गलील झिला पारे जो गिया, कने बड़े भरी लोक उस बाल गिठे होई गे। सै झिला बखे ही था, ");
INSERT INTO bht_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","यहूदी जंज घरे दे सरदारां चे इक याईर नाये दा सरदार आया, सै यीशुऐ दी इज्जत मान तांई यीशुऐ दे पैरां अग्गे डेई पिया, ");
INSERT INTO bht_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","कने उनी ऐ बोली करी बड़ी बिनती किती, “की मेरी लोकी कुड़ी मरणा लगियो है, कने तू साड़े घरे आई करी उसा जो छु, ताकि सै ठीक होई जा कने मरणे ला बची जा।” ");
INSERT INTO bht_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","तालू ही यीशु उस सोगी चली पिया, कने मते भरे लोक उदे पिच्छे चली पे, सै यीशुऐ दे उपर डेई पोंदे थे। ");
INSERT INTO bht_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","भिड़ा च इक जनानी थी जिसा जो बाहरां सालां ला खून निकलने दी बिमारी थी। ");
INSERT INTO bht_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","उना मते वेद्यां हथा ला दुख झेलया था कने अपणे सारे पेसे खर्चणे बाद भी सै खरी नी होई। कने उसा दा हाल बड़ा बुरा होई गिया था। ");
INSERT INTO bht_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","जालू उना सुणया यीशुऐ लोकां जो खरा कितया है, तां उना सोचया, “कि मैं उदे कपड़यां जो छुई लें, तां मैं खरिया होई जाणा।” तांई तां उना भिड़ा च यीशु दे पिच्छे आईके उदे कपड़यां जो छुता। ");
INSERT INTO bht_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","क्योंकि सै बोलदी थी, “अगर मैं उदे कपड़यां जो भी छुई लेंगी, तां ही मैं ठीक होई जाणा।” ");
INSERT INTO bht_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","कने झट उसा दा खून चलणा बंद होई गिया, उना अपणे शरीरे ला मेहसूस करी लिया की मैं इसा बिमारिया ला ठीक होई गियो है। ");
INSERT INTO bht_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","यीशु भिड़ा च पिच्छे मुड़या कने पुछया, “मेरे कपड़यां जो कुनी छुता?” उनी ऐसा इस तांई पुछया क्योंकि उसयो पता लगी गिया की उदे चे सामर्थ्य निकली, कने कोई माणु खरा होया है। ");
INSERT INTO bht_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","उदे चेलयां उसयो बोलया, “तू दिखा दा है, की तेरे अखे बखे इतणी भरी भीड़ है, कने तू पुछदा है, की कुनी मिंजो छूता?” ");
INSERT INTO bht_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","तालू यीशुऐ उसी माणुऐ जो दिखणे तांई जिनी ऐ कम्म कितया था, चारो पासे नजर दौड़ाई। ");
INSERT INTO bht_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","तालू सै जनानी जाणी गिया की मैं खरी होई गियो, तालू सै आई कने यीशुऐ दे पैरां च पेई गेई कने पैर बंदे। कने यीशुऐ जो दसया की मैं तिजो छुतया था। उना सोचया कि उनी उसा पर गुस्सा होणा उसा गल्ला दिया वजा ला सै डरी कने कम्मी पियो थी। ");
INSERT INTO bht_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","यीशुऐ उसा जो बोलया, “कुड़िये, तेरा भरोसा जड़ा मिजों पर था उनी भरोसे तिजो खरा कितया है, शांति ने चली जा, हुण तु अपणिया इसा बिमारिया ला बची करी रियां।” ");
INSERT INTO bht_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","यीशु हले उसा ने गल्ल करा दा ही था, यहूदी जंज घरे दे सरदारे दे घरे ला कुछ लोकां आई करी बोलया, “की तेरी कुड़ी तां मरी गेई है” हुण गुरुऐ जो कजो तकलीफ दे दा है? ");
INSERT INTO bht_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","जड़ी गल्ल सै बोला दे थे, उसा गल्ला जो यीशुऐ अंणसुणी करिके यहूदी जंज घरे दे सरदारे जो बोलया, “डर मत, सिर्फ मिजों पर भरोसा रख।” ");
INSERT INTO bht_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","तालू यीशुऐ सिर्फ पतरस, याकूब कने याकूब दे भाई यूहन्ना कने याईर जो ही अपणे कने ओणा दा हुकम दिता, होर कुसयो भी अपणे सोगी ओंणा नी दिता। ");
INSERT INTO bht_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","कने यहूदी जंज घरे दे सरदारे दे घरे च पुज्जी करी, उनी लोकां जो रोंदे कने डडदे दिखया। ");
INSERT INTO bht_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","तालू यीशुऐ कमरे अंदर जाई करी उना जो बोलया, “तुसां इयां डडा कने रोआ मत? कुड़ी मरियो नी है पर सुतियो है।” ");
INSERT INTO bht_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","सै सुणीकरी, सारे लोक यीशुऐ पर हसणा लग्गे, तालू उनी सारयां जो बाहर कडी दिता। कने कुड़िया दे माता पिता कने अपणे चेलयां जो सोगी लेईकरी कमरे अंदर गिया जिथू कुड़ी पियो थी। ");
INSERT INTO bht_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","कने यीशुऐ कुड़िया दा हथ पकड़ी करी उसा जो बोलया, “तलिता कूमी,” जिसदा मतलब है की, “हे छोटी कुड़िऐ, मैं तिजो बोलदा है, उठ।” ");
INSERT INTO bht_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","कने कुड़ी झट उठी करी हंडणा लग्गी पेई, सै बाहरां सालां दी थी। जालू इयां होया तां सारे लोक कुड़िया जो दिखीकरी हेरान होई गे। ");
INSERT INTO bht_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","फिरी यीशुऐ उसा दे माता पिता जो समझाई करी हुकम दिता की इसा गल्ला दा कुसयो पता नी लग्गे की उनी मरियो कुड़ियो जो जिन्दा कितया है। कने इसा कुड़िया जो खांणे जो दिया कुछ। ");
INSERT INTO bht_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","तालू यीशु कफरनहूम शेहरे ला चली गिया, सै अपणे ग्रां नासरत जो आया, कने उदे चेले भी उदे सोगी आये। ");
INSERT INTO bht_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","यीशु सब्ते बाले रोजे यहूदी जंज घर च परमेश्वरे दे बचना दा उपदेश देणा लग्गा, कने मते लोक सुणीकरी हेरान होई गे कने बोलणा लग्गे, “इनी माणुऐ ऐ गल्लां कुथु ला सिखियां न? कने इसयो ऐ सारा ज्ञान कने चमत्कार करणे दी शक्तियां कुनी दितियां? कने सामर्थ्य दे कम्म कियां इदे ला होंदे न? ");
INSERT INTO bht_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ऐ सिर्फ तरखाणे दा पुत्र है, जड़ा मरियम दा पुत्र, कने याकूब, योसेस, यहूदा कने शमौन दा भाई है। कने इदिया बेंहणा भी ऐथू साड़े सोगी न” कने उना यीशुऐ पर भरोसा करणे जो मना करी दिता। ");
INSERT INTO bht_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","यीशुऐ उना जो बोलया, की परमेश्वरे दे संदेश देणेबालयां दा अपणे ग्रां कने अपणे रिशतेदारां अपणे घरे छडी करी, हर कुथी उदी इज्जत मान होंदा है। ");
INSERT INTO bht_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","कने ओथु उसी पर कुनी भरोसा नी किता, इसा बजा ला उनी ओथु थोड़े बिमारां पर हथ रखीकरी खरा किता उदे अलावा ओथु होर कोई चमत्कार नी करी सकया। ");
INSERT INTO bht_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","कने यीशु उना दे अविश्वास ने बड़ा हेरान होया कने उदे बाद यीशु अखे बखे दे ग्रांऐ च गिया कने परमेश्वर दे बचना दा उपदेश दिता। ");
INSERT INTO bht_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","थोड़े बकते बाद यीशुऐ बाहरां चेलयां जो अपणे बाल सदया कने उना जो बुरी आत्मा कडणे दा हक दिता। उना जो दो-दो करिके लग-लग ग्रांऐ भेजणा लग्गा, कने उना जो बुरियां आत्मा जो लोकां चे कडणे दा हक दिता। ");
INSERT INTO bht_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","कने यीशुऐ उना जो हुकम दिता, की अपणे रस्ते तांई सिर्फ इक सोठी लेनयो। ना तां खाणे तांई रोटी लेणी, ना तां झोला, ना ही बटुए च पेसे, ");
INSERT INTO bht_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","पर जुते पाई लेनयो कने होर कोई कपड़े पाणे तांई मत लेंदे। ");
INSERT INTO bht_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","यीशुऐ उना जो बोलया, “की कोई तुहांजो अपणे घरे रेहणे तांई सदगा, जालू दीकर तुसां उसी ग्रांऐ च रेंगे, तालू दीकर उसी दे घरे च परोणे बणी करी रिया। ");
INSERT INTO bht_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","जिसा जगा दे लोक तुहांजो अपनांगे नी कने तुहाड़ी सुणगे नी, ओथु ला जांदे बेले अपणे पैरां दी धुड़ जाड़ी दिनयो, ताकि उना लोकां जो पता लग्गे की परमेश्वरे दिया तरफा ला मिलणे बाली सजा दे सै अपु ही जिम्मेबार न।” ");
INSERT INTO bht_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","तालू चेलयां जाई करी घोषणा किती की अपणा मन बदला कने अपणे पापां दा पश्चाताप करा, कने परमेश्वरे दे शुभसमाचार पर भरोसा करा, कने परमेश्वरे पासे मुड़ा। ");
INSERT INTO bht_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","कने उना मतियां बुरियां आत्मा जो कडया, कने मतयां बिमारां जो जैतुन दा तेल मली करी खरा किता। ");
INSERT INTO bht_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","कने हुण राजा हेरोदेसे यीशु दे कम्मा दी चर्चा सुणी जड़े यीशु करा दा था, क्योंकि मते सारे लोक यीशुऐ जो जाणदे थे कने उदे बारे च चर्चा करा दे थे। कने बोला दे थे की ऐ सेई यूहन्ना बपतिस्मा देंणे वाला है, सै मरयां चे जिन्दा होई गिया है, ऐई बजा है कि उदे बाल ऐ चमत्कार करणे तांई परमेश्वरे दी शक्ति है। ");
INSERT INTO bht_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","कने होरनी लोकां बोलया है, “परमेश्वरे दा संदेश दे बाला एलिय्याह है। कने बाकियां बोलया, ऐ सै परमेश्वरे दा संदेश देणेबाला है, जड़े बड़े जमाने पेहले रेंदे थे।” ");
INSERT INTO bht_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","हेरोदेसे ऐ सुणीकरी बोलया, “ऐ यूहन्ना बपतिस्मा देणेबाला है, मैं अपु उदा मुंड बडबाया था, पर सै मरी करी फिरी जिन्दा होई गिया है।” ");
INSERT INTO bht_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","हेरोदेस थोड़े बकते पेहले अपणे भाई फिलिप्पुस दी घरे बाली हेरोदियास ने बियाह करी लिया था। ");
INSERT INTO bht_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","तालू यूहन्ना उसयो बोलया, “ऐ तु खरा नी किता तु अपणे भाईये दी लाड़ी लेई ली!” तांई तां हेरोदियास जो खुश करणे तांई, हेरोदेसे यूहन्ना जो पकड़ी करी उसयो जेला च पाई दिता। ");
INSERT INTO bht_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","तांई तां हेरोदियास यूहन्ना ने दुशमणी रखदी थी कने सै चांहदी थी, की उसयो मरवाई दे, पर ऐसा होई नी सकया, ");
INSERT INTO bht_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","हरबरी जालू हेरोदेस यूहन्ना जो बोलदे सुणदा था, तां सै डरदा था, क्योंकि युहन्ना इक पबित्र कने धर्मी माणु था, पर तमी सै उसयो सुणना पसंद करदा था। कने सिपाहियां जो उदी रखाबाली करणे तांई रखया, हेरोदेस उदियां गल्लां सुणीकरी डरी जांदा था, पर सै खुशिया ने सुणदा था। ");
INSERT INTO bht_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","थोड़े बकते बाद, हेरोदेसे अपणा जन्म दिन मनाया। उनी अपणे बड्डे प्रधान अधिकारियां, सेना दे बड्डे खास अगुवां कने गलील प्रदेशे दे अगुवां जो धामा च सदया। इसा धामा च हेरोदियास जो यूहन्ना जो मरवाणे दा मोका मिली गया। ");
INSERT INTO bht_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","कने हेरोदियास दी कुड़ी अंदर आई, कने नची करी हेरोदेस कने उदे सोगी धाम खाणा आये परोणयां जो खुश किता, तालू राजे कुड़िया जो बोलया, “तू जड़ा मर्जी मिंजो ला मंग, मैं तिजो दिंगा।” ");
INSERT INTO bht_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","कने हेरोदेसे उसा ला ऐ बायदा किता, “की मेरे अधे राज्य दीकर जड़ा कुछ तू मिंजो ला मंगगी सै मैं तिजो दिंगा।” ");
INSERT INTO bht_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","उना बाहर जाई करी अपणिया माता ला पुछया, की मैं क्या मंगे? माता बोलया की, “उसयो बोल की सै यूहन्ना बपतिस्मा देणेबाले दा मुडं बड्डी करी मिंजो दे।” ");
INSERT INTO bht_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","कने सै झट अंदर राजे बाल आई, कने उसने बिनती किती की, “मैं चांहदी है, की तू हुणी यूहन्ना बपतिस्मा देणेबाले दा मुंड बड्डी करी मिंजो इक थालिया च दे।” ");
INSERT INTO bht_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ऐ सुणीकरी राजा बड़ा उदास होया, पर अपणिया कसमां, कने सोगी बोणे बालयां दिया बजा ला उसा दिया गल्ला जो टालना नी चांदा था। ");
INSERT INTO bht_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","राजे इक सिपाइऐ जो हुकम दिता, कि जेला च जा, कने यूहन्ना दा मुंड बड्डी करी उदे बाल लेईकर आ। ");
INSERT INTO bht_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","सिपाईऐ जेला च जाई करी उदा सिर कटया, कने इक थालिया च रखीकरी लेई आया कने उसा कुड़िया जो देई दिता, कने कुड़िया अपणिया माता जो देई दिता। ");
INSERT INTO bht_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","जालू यूहन्ना दे चेलयां जो पता चला की उसयो मारी दितया है, यूहन्ना दे चेले आये, कने उना उदिया लाशा जो चुकी करी कबरा च रखी आये। ");
INSERT INTO bht_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","जालू सै प्रेरित जिना जो यीशुऐ भेजया था, सै यीशु बाल बापस आये कने उदे चारों बखे खड़ोइ गे, कने जड़ा कुछ उना किता, कने सिखया था, सारा कुछ उसयो दसया। ");
INSERT INTO bht_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","मते सारे लोक ओंदे जांदे थे कने इसा बजा ला यीशु कने उदे चेलयां जो रोटियां खाणे दा बकत नी मिलदा था। तालू यीशुऐ चेलयां जो बोलया, “असां कुथी सुनसान जगा चलदे जिथू किल्ले रेई सकन कने थोड़ा बकत अराम करी सकन।” ");
INSERT INTO bht_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","इस तांई सै किस्तिया च बेईकरी सुनसान जगा च चली गे। ");
INSERT INTO bht_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","कने मतयां लोकां उना जो जांदे दिखया कने पछेणी लिया की सै कुथु जाणा लगयो न। कने अखे बखे दे नगरां दे लोक गिठे होईकरी यीशु कने उदे चेलयां ला पेहले ओथु पैदल दौड़ी करी पुज्जी गे। ");
INSERT INTO bht_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","यीशु किस्तिया ला उतरया कने उनी मती भरी भीड़ दिखी, कने उना पर तरस खादा, क्योंकि उना दा कोई अगुवा नी था, जड़ा उना दी रखबाली करी सके, जियां बिना गवाले भेडां होंदियां न, “फिरी सै उना जो परमेश्वर दे राज्य दियां मतियां गल्लां सिखाणा लग्गा।” ");
INSERT INTO bht_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","जालू संज होंणा लग्गी, तां उदे चेले उदे बखे आई करी बोलणा लग्गे, “ऐ सुनसान जगा है, कने दिन बड़ा ढली गिया है। ");
INSERT INTO bht_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","इना जो भेजी दे, ताकि ऐ अखे बखे दे ग्रां कने बासियां च जाई करी, अपणे तांई कुछ खाणे जो खरीदी लेन।” ");
INSERT INTO bht_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","यीशुऐ उना जो जबाब दिता, “तुसां ही इना जो खाणे जो दिया।” उना यीशुऐ जो बोलया, “की तु चांदा है की असां जान कने दो सौ दिना दी मजदुरिया बराबर दियां रोटीयां खरदी करी इना जो खुआन?” ");
INSERT INTO bht_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","यीशुऐ उना जो बोलया, “जाई करी दिखा तुहाड़े बाल कितणियां रोटियां न?” उना पता करी के बोलया, “पंज रोटियां कने दो मछियां भी हेन।” ");
INSERT INTO bht_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","तालू यीशुऐ उना जो हुकम दिता की, सबना जो सेले घाऐ पर बैठाई दिया। ");
INSERT INTO bht_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","सै सौ-सौ करिके कने पंजा-पंजा करिके झुण्डा च बेई गे। ");
INSERT INTO bht_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","कने यीशुऐ सै पंज रोटियां कने दो मछियां लियां, कने स्वर्गे पासे दिखीकरी परमेश्वर दा धन्यबाद किता, कने रोटियां तोड़ी करी दो टोटे किते कने चेलयां जो दिन्दा गिया, ताकि सै लोकां जो परोसन, कने सै दो मछियां भी उना च बंडी दितियां। ");
INSERT INTO bht_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","सारे खाई करी रजी गे। ");
INSERT INTO bht_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","कने जालू रोटी खायी बैठे तालू चेलयां बाकी बचियाँ रोटियां कने मछियां गिठेरेइयां कने उसला बाहरा टोकरियाँ भरुई गियां। ");
INSERT INTO bht_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","जिना रोटियां खादियां सै पंज हजार सिर्फ मर्द थे, उना बच्चे कने जणासा जो गिणया नी था। ");
INSERT INTO bht_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","तालू यीशुऐ झट पट अपणे चेलयां जो बोलया की सै किस्तिया पर चढ़ी जा कने झिला दे पारले पासे बैतसैदा शेहरे जो चली जा, जालू दीकर की सै सारे लोकां जो भेजी नी ले। ");
INSERT INTO bht_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","सारे लोका जो भेजणे बाद, यीशु पहाड़े पर प्राथना करणे तांई गिया। ");
INSERT INTO bht_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","कने जालू संज होई, तालू किस्ति गलील झिला दे बिच थी, कने यीशु किला झिला बखे था। ");
INSERT INTO bht_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","जालू उनी दिखया की सै बड़े घबराई गियो न, क्योंकि हवा उना दे खिलाफ चलियो थी, तां ब्यागा तड़के यीशु झिला पर चली करी उना बाल आया, कने सै उना ला बखे ला निकलना चांदा था। ");
INSERT INTO bht_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","पर जालू उना उसयो झिला पर चलदे दिखया, तां से डडणा लग्गी पै, उना जो लगया की सै भुत है, तां सै दिखीकरी डरी गे, ");
INSERT INTO bht_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","क्योंकि सारे उसयो दिखीकरी घबराई गियो थे। पर यीशुऐ उना ने झट गल्लां कितियां कने बोलया, “हिम्मत रखा, डरा मत, मैं यीशु है।” ");
INSERT INTO bht_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","तालू सै उना बाल आया कने किस्तिया पर चढ़ी गिया, कने हवा रुकी गेई, कने सै बड़े हेरान होणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","हाली उना दिखया भी था की पिछलिया धियाड़िया यीशुऐ पंज रोटीयां ने पंज हजार ला जादा लोकां जो खाणा खुआया था, सै हाली भी उसयो नी समझयो थे, की यीशु कुण है। क्योंकि उना दे मन कठोर थे। ");
INSERT INTO bht_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","जालू यीशु कने उदे चेले इक किस्तिया च गलील दिया झिल्ला च गन्नेसरत प्रदेशे दे बखे पुज्जे, कने किस्ति घाटे पर बन्नी दिती। ");
INSERT INTO bht_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","कने जालू सै किस्तिया ला उतरे, तां लोकां उसयो झट पछेणी लिया, ");
INSERT INTO bht_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","सै झट पट ही सारे इलाके च गे, कने बिमारां जो मंझयां पर चुकी करी लेई गे जिथू उना जो खबर मिली की यीशु ओथु है। ");
INSERT INTO bht_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","कने जिथू कुथी सै ग्रां, शेहरां या बस्तियां च जांदा था, तां लोक बिमारां जो बजारां च रखीकरी उसला बिनती करदे थे, की सै सिर्फ अपणे कपड़यां जो छुणा दे, कने जितणे भी छुंदे थे, सै सारे ठीक होई जांदे थे। ");
INSERT INTO bht_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","तालू इक रोज फरीसी कने केई यहूदी व्यवस्था जो सिखाणे बाले जड़े यरूशलेम शेहरे च आयो थे, उसयो सुणने तांई गिठे होऐ, ");
INSERT INTO bht_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","कने उना दिखया की उदे चेले बिना हथ धोते रोटी खा दे थे, जड़ा की यहूदी रिबाजे अनुसार अपबित्र था। ");
INSERT INTO bht_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","फरीसी कने सारे यहूदी खाणा खाणे ला पेहले अपणे बजुर्गां दे रीती रिबाजे पर चलदे थे कने जालू दीकर सै ढंगे ने हथ नी धोई लेन खाणां नी खांदे थे, ");
INSERT INTO bht_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","कने बजारे ला ओणे दे बाद, जालू दीकर से अपणे रिती रिबाजा दे अनुसार नोई नी लेन, साफ नी होंदे तालू दीकर खाणां नी खांदे, कने उना दे वजुर्गां दे होर भी बतेरे रिबाज थे, जिना जो सै मंदे थे, जियां की कटोरे, लोटे, कने तांबे दे भांडयां जो धोंणा कने मांजणा। ");
INSERT INTO bht_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","तांई तां उना फरीसियां कने व्यवस्था जो सिखाणे बालयां उसयो पुछया, “की तेरे चेले साड़े सियाणे दियां रिबाजां जो नी मंदे?” सै तां बिना हथ धोयो रोटी खांदे न? ");
INSERT INTO bht_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","यीशुऐ उना जो जबाब दिता, “यशायाहे ठीक था, जिनी पबित्र शास्त्र च तुहाड़े सांई कपटियां दे बारे च लिखया है, की ऐसे लोक गल्लां ने तां मेरा आदर करदे न, पर इना दे मन मिंजो ला बड़े दूर न। ");
INSERT INTO bht_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","इना दी कितियो भक्ति मेरे तांई बेकार है, क्योंकि ऐ लोकां जो माणुऐ दियां दसियां गल्लां जो परमेश्वर दियां गल्लां दस्सी करी मनणे तांई बोलदे न। ");
INSERT INTO bht_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","क्योंकि तुसां परमेश्वरे दे हुकमा जो मनणा बंद करी दितया है, कने माणुऐ दे रिबाजां जो मंना दे न।” ");
INSERT INTO bht_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","कने यीशुऐ उना ने बोलया, “तुसां अपणे बणायो नियमा जो मनणे तांई चलाकिया ने परमेश्वरे दे हुकम जो टाली दिन्दे न। ");
INSERT INTO bht_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","उदाहरण तांई, मूसा ने बोलया है, की अपणे माता पिता दा आदर करा, कने जड़ा कोई अपणे माता पिता जो श्राप दिंगा, सै पक्का मारी देणा। ");
INSERT INTO bht_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","पर तुसां लोकां जो ऐ दसदे न की, अपणे माता पिता दी मदद नी करणा कने उना दे हिस्से दियां चिंजा उना जो छडी करी परमेश्वर जो देणा ठीक है। कने तुसां लोकां जो इजाजत दिन्दे अपणे माता पिता जो ऐ बोलणे दी की जड़ा कुछ मैं तुहांजो देणा था, सै मैं परमेश्वर जो देणे दी कसम खादियो है, कने मैं हुण तुसां दी मदद नी करी सकदा, इसला तुसां लोकां जो ऐ बोलदे की हुणे ला तुसां जो माता पिता दी सेबा करणे दी कोई जरूरत नही है। ");
INSERT INTO bht_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","इयां बोली करी, जिना रीती रिबाजां जो तुसां लोकां दीकर पुजाया है, सै परमेश्वरे दियां बोलियां गल्लां जो बेकार होणे दी बजा बणी जांदा है।” ");
INSERT INTO bht_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","तालू यीशुऐ लोकां जो अपणे बाल सदीकरी उना जो बोलया, “तुसां सारे मेरी सुंणा, कने समझा। ");
INSERT INTO bht_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ऐसी कोई चीज नी ऐ जड़ी माणुऐ च बाहर ला आई करी उसयो अशुद्ध करदी है, पर माणुऐ जो अशुद्ध सै करदा है जड़ा उदे अंदरे ला निकलदा है। ");
INSERT INTO bht_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","जिस बाल सुणने तांई कन्न न सै ध्यान लाईकरी गल्ला जो सुणे, कने इसा गल्ला जो समझी ले।” ");
INSERT INTO bht_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","जालू सै भीड़ा दे बखे ला घरे दे अंदर गिया, तां उदे चेलयां यीशुऐ जड़ा बोलया था, उसा कहाणिया दा मतलव पुछया। ");
INSERT INTO bht_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","यीशुऐ उना ने बोलया, “क्या तुसां भी ऐसे ना समझन? क्या तुहांजो नी पता, की जड़ा भी खाणा माणु खांदा है, सै उसयो अशुद्ध नी करी सकदा। ");
INSERT INTO bht_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","क्योंकि सै उदे मने च नी, पर उदे पेटे च जांदी है, कने संडास च निकली जांदी है,” यीशुऐ दा बोलणे दा मतलब ऐ था, की सारियां खांणे बालियां चीजा ठीक न। ");
INSERT INTO bht_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","लोक जड़ा बुरा सोचदे न, “सै ही बोलदे न कने करदे, सै ही उना जो परमेश्वर दे सामणे अशुद्ध करदा है। ");
INSERT INTO bht_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","क्योंकि अंदर ला, मतलब की माणुऐ दा मन ही बुरियां चिजा दी जड़ है। बुरे-बुरे बिचार, व्यभिचार, चोरी, हत्या, परस्त्रीगमन, ");
INSERT INTO bht_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","लालच, बुराई, धोखा, लुचापन, बुरी नजर, निंदा, घमंड, कने मुर्खता निकलदी है। ");
INSERT INTO bht_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ऐ सारियां गल्लां मने ला निकलदियां न कने माणुऐ जो अशुद्ध करदियां न।” ");
INSERT INTO bht_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","इदे बाद यीशु कने उदे चेले ओथु ला उठी करी सूर कने सैदा दे शेहरे दे अखे बखे बालिया जगा जो चली गे। ओथु सै इकी घरे च गिया, कने सै चांदा था, की उसयो कोई नी जाणी सके की सै ओथु रुकया है। पर लोकां जो बड़ा तोला पता लग्गी गिया था कि सै ओथु रुकया है। ");
INSERT INTO bht_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","कने इक जनानी उदी चर्चा सुणीकरी आई, जिसा दिया छोटिया कुड़िया जो बुरिया आत्मा जकड़या था, सै झट उदे पैरां च पेई गेई। ");
INSERT INTO bht_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","सै जनानी यहूदी नी थी। सै सीरिया ग्रांऐ दे सुरुफिनिकी नाये दे इलाके च जमियो थी। कने उना उसला बिनती किती, की मेरिया कुड़िया चे बुरिया आत्मा जो कडी दे। ");
INSERT INTO bht_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","यीशुऐ उसा जो बोलया, “पेहले बचयां जो रजणा दे, क्योंकि बचयां ला रोटियां लेईकरी कुतयां दे अग्गे पाणा ठीक नी है।” ");
INSERT INTO bht_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","उना जबाब दिता, प्रभु ऐ सच्च है, पर कुत्ते भी तां बचयां दे मेजे हेठ रोटिया दे चूरे चारे जो खाई लेंदे न। ");
INSERT INTO bht_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","यीशुऐ उसा जो बोलया, “इसा गल्ला दा जबाब भरोसे ने दिता, उदिया बजा ने बुरी आत्मा तेरिया कुड़िया चे निकली गियो है कने तु हुण घरे चली जा।” ");
INSERT INTO bht_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","कने उना अपणे घरे आई करी दिखया कुड़ी मंजे पर पियो है, कने बुरी आत्मा कुड़िया ला निकली गियो है। ");
INSERT INTO bht_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","फिरी यीशु कने उदे चेले अखे बखे दे इलाके जो छडी करी सिदोन शेहरे जो निकली गे। फिरी सै दिकापुलिस “दस शेहर” चे होईकरी गलील झिला बालिया जगा च पुज्जा। ");
INSERT INTO bht_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","कने लोक इक टोणे जो जड़ा थथलान्दा भी था, उसयो उस बाल लेईकरी आये कने बिनती किती की, इसयो खरा करी दे। ");
INSERT INTO bht_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","तालू सै उसयो भिड़ा ला लग लेई गिया, कने अपणियां उंगलियां उदे कना च पाईयां, कने अपणा थुक अपणिया उंगलियां च लगाया कने उसी माणुऐ दी जीभा जो छूता। ");
INSERT INTO bht_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","कने स्वर्गे पासे दिखीकरी लम्बा साह लिया। फिरी उसी माणुऐ जो बोलया, “इप्फतह।” मतलब की “खुली जा” ");
INSERT INTO bht_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","कने इकदम ही सै साफ-साफ सुणना लगी पिया, कने बिना कुसी तंगिया ने सै साफ-साफ बोलणा लगी पिया। ");
INSERT INTO bht_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","तालू यीशुऐ उना जो समझाया की कुसी ने मत बोलदे, पर उनी जितना उना जो समझाया उतणा ही सै बोलणा लगी पिया। ");
INSERT INTO bht_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","सै बड़े ही हेरान होईकरी बोलणा लग्गे, “यीशुऐ जड़ा कुछ किता सै सब कुछ खरा ही कितया है,” यीशु टोणयां जो सुणने दी, कने गुंगयां जो बोलणे दी शक्ति दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","उसी बकते दी गल्ल है जालू मते सारे लोक दिकापुलिस च यीशुऐ बाल गिठे होऐ, कने उना बाल खाणे तांई कुछ नी था, तां यीशुऐ अपणे चेलयां जो सदीकरी उना जो बोलया, ");
INSERT INTO bht_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ऐ लोक मिजों सोगी तिन्ना रोजां ला रेह दे न। उना बाल खाणे तांई कुछ नी है कने मिंजो इसा गल्ला पर तरस ओआ दा है। ");
INSERT INTO bht_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","कने इना च थोड़े लोक बड़े दुरे ला आयो थे। अगर मैं इना जो भूखा घरे भेजी दें, तां इना रस्ते च थकी जाणा कने बेहोश होई जाणा। ");
INSERT INTO bht_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","उदे चेलयां उसयो जबाब दिता की, ऐथू सुनसान जगा च इतणी रोटियां कुनी कतां ला लोंणियां, की ऐ सारे जणे रजी जान? ");
INSERT INTO bht_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","यीशुऐ उना जो पूछया, “तुहाड़े बाल कितणियां रोटियां न?” उना बोलया, “साड़े वाली सत रोटियां न।” ");
INSERT INTO bht_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","तालू यीशुऐ लोकां जो धरतिया पर बोंणे दा हुकम दिता कने सै बेई गे, कने उदे बाद सै सत रोटियां लियां, कने परमेश्वरे दा धन्यबाद करिके तोड़ियां, कने अपणे चेलयां जो रोटीयां दे टुकड़े दिन्दा गिया ताकि सै उना जो लोकां च बंडी देन। ");
INSERT INTO bht_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","उना बाल थोड़ियां छोटियां मछियां भी थियां, कने यीशुऐ परमेश्वरे दा धन्यबाद करिके सै अपणे चेलयां जो दितियां, कने लोकां जो परोसणे दा हुकम देई दिता। ");
INSERT INTO bht_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","फिरी सारे लोक खाई करी रजी गे कने उदे बाद चेलयां बाकी बचियाँ रोटियां दे टुकड़यां जो सत टोकरियां च भरी लिया। ");
INSERT INTO bht_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","कने सै लोक लगभग चार हजार थे, कने यीशुऐ उना लोकां जो विदा किता। ");
INSERT INTO bht_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","कने यीशु चेलयां सोगी किस्तिया पर चढ़ी करी दलमनुता इलाके जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","फिरी फरीसी आई करी यीशुऐ ने गल्ल बात करणा लग्गे, क्योंकि सै उसयो फसाणा चांदे थे इस तांई उना उसयो पूछया स्वर्गे दा कोई चमत्कार दस। जिसने ऐ साबित होई जां की परमेश्वरे तिजो शक्ति दितियो है। ");
INSERT INTO bht_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","उनी उना दे अविश्वास ला नराज होईकरी लम्बा साह लिया कने बोलया, “इस युगे दे लोक कजो चमत्कार तोपदे न? मैं तुहांजो ने सच्च बोलदा है, की इस युगे दे लोकां जो कोई चमत्कार नी देणा है।” ");
INSERT INTO bht_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","फिरी सै फरीसियों जो छडी करी, अपणे चेलयां सोगी किस्तिया पर चड़ी गिया कने गलील झिला दे चारों पासयां ला होंदे होए चली गया। ");
INSERT INTO bht_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","यीशुऐ दे चेले रोटियां लेणा भूली गियो थे, कने उदिया वजा ने उना बाल किस्तिया च इक रोटिया जो छडी करी कख भी नी था। ");
INSERT INTO bht_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","कने यीशुऐ उना जो चेतावनी दिती कि, “फरीसियां कने हेरोदेस दे खमिरे ला बचणे तांई चौकने रेनयो।” ");
INSERT INTO bht_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","सै अपु चे बिचार करिके बोलणा लग्गे, कि यीशुऐ ऐ इस तांई बोलया क्योंकि “साड़े बाल रोटीयां घट न।” ");
INSERT INTO bht_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ऐ जाणी करी यीशुऐ उना ने बोलया, “तुसां कजो अपु चे बिचार करा दे कि साड़े बाल रोटिया नी न? क्या तुसां अपणे मने जो इतणा कठोर बणाई लिया, तुसां क्या हले दीकर समझे नी? ");
INSERT INTO bht_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","तुसां बाल हखी कने कन्न होंदे होए भी नी दिखी कने सुणी सकदे। कने क्या तुहांजो कुछ भी याद नी है? ");
INSERT INTO bht_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","की तालू तुसां बचियाँ रोटियां दे टुकड़यां जो कितणियां टोकरियां च भरया था, जालू मैं पंज हजार लोकां जो पंज रोटियां ला खुयाया था?” उना बोलया, “बाहरा टोकरियाँ।” ");
INSERT INTO bht_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“कने जालू चार हजार लोकां तांई सत रोटियां थियां तां कितणे टोकरे भरी करी चुके थे?” उना बोलया, सत टोकरे। ");
INSERT INTO bht_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","यीशुऐ उना जो बोलया, “तुसां हाली दीकर कजो नी समझदे की मैं कुण है?” ");
INSERT INTO bht_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","तालू यीशु कने उदे चेले बैतसैदा शेहरे च आऐ, कने लोक इक अन्ने जो उदे बाल लेईकरी आऐ कने उसला बिनती किती की इसी माणुऐ जो छु कने खरा करी दे। ");
INSERT INTO bht_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","तालू यीशुऐ उस अन्ने दा हथ पकड़ी करी उसयो ग्रां दे बाहर लेई गिया। कने यीशुऐ अपणा थुक उदिया हखी पराला लाया कने उस पर हथ रखे, कने उसयो पुछया, “क्या तिजो कुछ मिल्ला दा है?” ");
INSERT INTO bht_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","उनी नजरां उपर करी के बोलया, “मैं माणुऐ जो दिखा दा है, पर सै साफ नी मिल्ला दे, सै मिंजो रुखां सांई चलदे मिला दे न।” ");
INSERT INTO bht_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","तालू यीशुऐ दोबारा उदियां हखी पर हथ रखे, कने अन्ने गोरा ने दिखया, कने उदियां हखी ठीक होई गियां, कने उसयो सब कुछ साफ-सुथरा मिलणा लगी पिया। ");
INSERT INTO bht_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","कने यीशुऐ उसयो हुकम दिता कि अपणे घरे जो मुड़ी जा, पर ऐथू जड़ा होया ग्रांऐ बालयों जो दसणे तांई, ग्रांऐ दे अंदर पैर भी मत रखदा। ");
INSERT INTO bht_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","यीशु कने उदे चेले बैतसैदा शेहरे जो छडी करी कैसरिया फिलिप्पी शेहरां दे बखे आले ग्रां च चली गे, कने रस्ते च उनी अपणे चेलयां जो पुछया, “की लोक मेरे बारे च क्या बोलदे न, की मैं कुण है? ");
INSERT INTO bht_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","चेलयां जबाब दिता कुछ लोक बोलदे ने कि तुसां यूहन्ना बपतिस्मा देणेबाले न; पर कोई-कोई एलिय्याह बोलदा, कने कोई-कोई बोलदे न कि पुराणे जमाने दे परमेश्वरे दा संदेश देणेबालयां चे कोई इक है।” ");
INSERT INTO bht_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","फिरी यीशुऐ पुछया, “पर तुसां मिंजो क्या बोलदे न?” पतरसे उसयो जबाब दिता, “तू मसीहा है, जड़ा परमेश्वरे दिया तरफा ला भेजया है।” ");
INSERT INTO bht_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","तालू यीशुऐ उना जो हुकम दिता की मेरे बारे च कुसी ने मत बोलदे की, मैं मसीहा है कने परमेश्वरे मिंजो भेजया है। ");
INSERT INTO bht_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","तालू यीशु अपणे चेलयां जो सिखाणा लग्गा, कि मैं, जड़ा माणुऐ दा पुत्र है, “मिंजो मते दुख सेहणे पोणे न, कने यहूदी अगुवे, बड्डे याजकां, कने यहूदी व्यवस्था जो सिखाणे बालयां मिंजो अपनाणा नी है, कने मैं मारी देणा है, कने फिरी मैं तिन्ना रोजां बाद मरयां चे जिन्दा होई जाणा है।” ");
INSERT INTO bht_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","यीशुऐ उना जो ऐ गल्ल साफ तरिके ने बोली दिती। पतरस यीशुऐ जो बखिया लेई गिया कने इसा गल्ला पर झिड़कणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","तालू यीशु पिच्छे मुड़या कने चेलयां जो दिखया कने पतरसे जो झिड़की करी बोलया, “शैताने सांई कम्म करणा बंद कर! मेरे सामणे ला दूर होई जा! क्योंकि तू परमेश्वरे दे सांई नी, पर तू माणुऐ सांई सोचदा है।” ");
INSERT INTO bht_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","यीशुऐ भिड़ा जो अपणे चेलयां सोगी अपणे बाल सदीकरी बोलया, “जड़ा कोई मेरा चेला बणना चांदा है, उसयो अपणिया शरीरे दियां इच्छां कने जड़ियां तरकिबां बणाईयां उना जो छडी करी कने जड़ा मिजों तांई मरणे जो तैयार रेंदा है, सेई मेरा चेला बणी करी मिजों पिच्छे चली सकदा है। ");
INSERT INTO bht_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","कोई माणु इयोदिया नी करगा कने अपणे प्राणा जो बचाणा चांहगा, उनी परमेश्वरे सोगी आत्मिक जिन्दगी जिणे दा मोका गबाई देणा है। पर जड़ा माणु मिजों पर भरोसा करगा कने मेरे शुभसमाचार दिया बजा ने मरगा उस माणुऐ जो परमेश्वरे सोगी सदा तांई दी जिन्दगी मिलणी। ");
INSERT INTO bht_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","अगर तुसां संसारे दा सब कुछ पाई लेंगे कने पर परमेश्वरे सोगी सदा दी जिन्दगी जिणे दा मोका गवाई दिंगे, तां उदा क्या फायदा? ");
INSERT INTO bht_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","इक माणु परमेश्वरे जो क्या देई सकदा है, जड़ा उदी हमेशा दी जिन्दगी खरिदगा? कुछ नी! ");
INSERT INTO bht_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","तुहाड़े च अगर कोई माणु मिजों अपणा परमेश्वर कने मेरियां शिक्षा दा पालन करणे जो मना करदा है, क्योंकि तुसां डरदे न की गैर विश्वासी कने पापी लोकां तुहाड़ा मजाक उड़ाणा। फिरी जालू मैं माणुऐ दे पुत्रे, पबित्र स्वर्गदूतां सोगी धरतिया पर ओणा है, तां मैं उना लोकां जो भी अपणा चेला मनणे ला मना करी देणा है। तालू सारयां लोकां मेरी महिमा दिखणी जड़ी मेरे पिता दी है।” ");
INSERT INTO bht_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","यीशुऐ भिड़ा कने अपणे चेलयां जो बोलया, मैं तुहांजो ने सच्च बोलदा है, “ऐथू खड़ोतयो लोकां चे कुछ लोक ऐसे न, उना तालू दीकर जिन्दे रेणा है जालू दीकर सै परमेश्वरे दे राज्य जो शक्तिशाली रुपे च अपणे बिच ओंदे नी दिखी लेन।” ");
INSERT INTO bht_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","इक हफ्ते बाद यीशु पतरस, याकूब कने यूहन्ना जो इक उच्चे पहाड़े पर लेई गिया कने ओथु उना सिबा होर कोई नी था, कने उना दे सामणे यीशुऐ दा रूप बदलुई गिया। ");
INSERT INTO bht_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","कने उदे कपड़े चिट्टे होईकरी चमकणा लग्गे। धरतिया पर इयोदे चिट्टे कपड़े कोई भी धोबी धोई करी नी करी सकदा। ");
INSERT INTO bht_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","तालू उना तिन्ना चेलयां, दो परमेश्वरे दे संदेश देणेबाले मूसा कने एलिय्याह जो, जड़े बड़े पेहले जिन्दा थे उना जो यीशुऐ सोगी गल्लां करदे दिखया। ");
INSERT INTO bht_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ऐ सब दिखीकरी पतरसे यीशुऐ जो बोलया, “गुरू जी, साड़ा ऐथू रेंणा ठीक है, इस तांई असां ऐथू तीन तम्बू बणांदे न, इक तेरे तांई, इक मूसा तांई, इक एलिय्याह तांई।” ");
INSERT INTO bht_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","पतरसे ऐ इस तांई बोलया की, सै कने दुज्जे दो चेले डरी गियो थे, कने नी जाणदे थे क्या बोलणा क्या करणा। ");
INSERT INTO bht_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","तालू इक बदल आया कने उनी उना जो अपणी छाया हेठ ढकी लिया, कने उना बदले च परमेश्वरे जो बोलदे सुणया, “कि ऐ मेरा प्यारा पुत्र है, कने मैं इसला खुश है, कने जड़ा ऐ बोलदा है, उसयो ध्याने ने सुणा।” ");
INSERT INTO bht_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","तालू उना अपणे चारो पासे नजर मारी, तां मूसा कने एलिय्याह ओथु नी थे, कने उना जो सिर्फ यीशु ही मिल्ला। ");
INSERT INTO bht_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","जालू यीशु कने उदे तिन्न चेले पहाड़े ला उतरा दे थे, तालू यीशुऐ उना जो हुकम दिता कि, “कुसी जो भी मत दसदे कि तुसां क्या दिखया जालू दीकर मैं, माणुऐ दा पुत्र मरयां चे जिन्दा ना होई जा।” ");
INSERT INTO bht_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","चेलयां जड़ा पहाड़े पर होया उदे बारे च कुसी जो भी नी दसया, पर सै इसा गल्ला दे बारे चर्चा करणा लग्गे की, “मरयां चे जिन्दा होई जाणा” इदा क्या मतलब था। ");
INSERT INTO bht_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","कने चेलयां उसला पुछया, “मूसा दी व्यवस्था दे अनुसार व्यवस्था जो सिखाणे बाले बोलदे थे, मसिहा ला पेहले एलिय्याह ओणा था? अगर ओणा था, तां हाली दिकर कजो नी आया सै?” ");
INSERT INTO bht_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","यीशुऐ उना जो जबाब दिता, ऐ तां सच्च है कि एलिय्याह पेहले आई करी सब कुछ सुधारणा है। पर कजो माणुऐ दे पुत्रे दे बारे च ऐसा लिखया है, की उनी बड़े दुख सेहणे न, कने उसयो निच समझणा है। ");
INSERT INTO bht_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","पर मैं तुसां ने बोलदा है, एलिय्याह ता पेहले ही आई चुकया था, साड़े अगुवां उदे कने बड़ा बुरा व्यवहार कितया। जियां सै करणा चांदे थे, जदिया की पबित्र शास्त्रां च बड़ी पेहले ही बोलया था की उना करणा। ");
INSERT INTO bht_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","जालू यीशु कने तिन्न चेले बाकी चेलयां बाल मुड़ी करी आये, तां दिखया की उना दे चारो पासे तां बड़ी भरी भीड़ लगियो है, कने व्यवस्था जो सिखाणे बाले उना सोगी बेहस करा दे थे। ");
INSERT INTO bht_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","कने जियां ही सारे लोकां यीशुऐ जो दिखया, दिखदे ही बड़े हेरान होये, कने उदे बाल दौड़ी करी आये कने उसयो नमस्ते किते। ");
INSERT INTO bht_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","यीशुऐ उना ला पुछया, “तुसां इना सोगी बेहस कुसा गल्ला पर करा दे न?” ");
INSERT INTO bht_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","भिड़ा चे इकी माणुऐ उसयो जबाब दिता, “गुरू जी, मैं अपणे पुत्रे जो तेरे बाल लेईकरी आया था, इदे च बुरी आत्मा है, जिना इसयो गूंगा बणाई दितया है। ");
INSERT INTO bht_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","जालू भी बुरी आत्मा उदे अंदर ओंदी है, तां सै उसयो गुस्से ने जमिना पर पटकी दिन्दी, कने उदे मुऐ ला झाग निकलदा, कने दंदा पिंदा, सकत होई जांदा। मैं तुहाड़े चेलयां जो बोलया की बुरिया आत्मा जो बाहर कडी दिया पर सै उना ला नी होया।” ");
INSERT INTO bht_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ऐ सुणीकरी यीशुऐ उना जो जबाब दिता, “हे अविश्वासी लोकों, मैं कालू दीकर तुहाड़े सोगी रेंगा, कने कालू दीकर तुहाड़े अविश्वास जो सेहन करगा? उस जागते जो मेरे बाल लोआ।” ");
INSERT INTO bht_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","तालू सै जागते जो यीशुऐ बाल लेई आये कने जालू बुरिया आत्मा यीशुऐ जो दिखया, तां उना आत्मा जागते जो झट मरोड़या, कने धरतिया पर फकोड़ी दिता, कने सै मुऐ ला झाग निकालदे-निकालदे बिलटियां मारणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","यीशुऐ जागते दे पिता ला पुछया, “ऐ कालू ला होआ दा है?” कने उनी बोलया, “जालू ला ऐ लोका दिया नियाणा होंदा था। ");
INSERT INTO bht_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","मती बरी बुरिया आत्मा इसयो मारणे तांई अग्गी कने पाणिये च सुट्टी दितया था, पर अगर तू कुछ करी सके, तां सांझो पर तरस खाई करी साड़ी सहायता कर।” ");
INSERT INTO bht_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","यीशुऐ उना जो बोलया, “अगर तू करी सकदा है, ऐ क्या गल्ल होई? जड़ा मिंजो पर भरोसा करदा है, उदे तांई सब कुछ होई सकदा है।” ");
INSERT INTO bht_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","बच्चे दे पिते झट पैरां च पेईकरी जोरे ने बोलया, “प्रभु जी, मेरी सहायता करा की मैं तुसां पर भरोसा करे।” ");
INSERT INTO bht_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","जालू यीशुऐ दिखया, की मते सारे लोक उसयो दिखणे तांई गिठे होआ दे थे, तां उनी बुरिया आत्मा जो ऐ बोली करी झिड़कां दितियां की, “हे बुरी आत्मा, जड़ी इसी जागते जो गूंगा कने बेहरा बणा दी कने बोलणा नी दे दी, मैं तिजो हुकम दींदा है की, इसयो छडी दे, कने फिरी कदी मत ओंदी।” ");
INSERT INTO bht_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","तालू बुरिया आत्मा चिलाई करी जागते जो मरोड़ी करी सटया, कने निकली गेई कने सै जागत बिना हिल्ले ओथु लाशा सांई पेई रिया था, ऐथू दीकर की मते लोक बोलणा लग्गे की, ऐ तां मरी गिया है। ");
INSERT INTO bht_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","पर यीशुऐ उदा हथ पकड़ी करी उसयो उठालया, कने सै खड़ोई गिया। ");
INSERT INTO bht_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","बादे च जालू यीशु कने उदे चेले घरे च किले थे, तालू उदे चेलयां पुछया कि, “असां बुरिया आत्मा जो कजो नी कडी सके?” ");
INSERT INTO bht_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","यीशुऐ उना जो जबाब दिता, “ऐसियां बुरियाँ आत्मा जो प्राथना कने बरत कितयो बिना माणुआं ला बाहर नी कडी सकदे।” ");
INSERT INTO bht_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","बादे च यीशु कने उदे चेलयां उना जगा जो छडी दिता कने गलील प्रदेशे ला निकले। कने यीशु नी चांदा था की कोई उसयो जाणे की सै कुथु है। ");
INSERT INTO bht_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","क्योंकि यीशु अपणे चेलयां सोगी मता बकत बिताणा चांदा था कने उना जो सिखाणा चांदा था। कने उना ने बोला दा था की, “माणुऐ दा पुत्र, मेरे दुशमणा दे हथे पकड़ाया जाणा है, कने उना लोका मिंजो मारी देणा है, कने मरणे दे तरिये रोजे मरयां चे जिन्दा होई जाणा है।” ");
INSERT INTO bht_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","पर ऐ गल्ल उना दिया समझा च नी आई, कने चेले पूछणे ला डरदे थे जड़ा यीशुऐ बोलया था। ");
INSERT INTO bht_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","यीशु कने उदे चेले कफरनहूम शेहरे च अपणे घरे जो आये; कने जालू से घरे अंदर थे, तालू यीशु उना जो पुछणा लग्गा, “रस्ते च तुसां कुसा गल्ला पर बेहसा दे थे?” ");
INSERT INTO bht_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","सै चुप रे, क्योंकि उना रस्ते च ऐ बेहस कितियो थी कि, असां चे बडा कुण है। ");
INSERT INTO bht_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","तालू यीशु बेई गिया कने बाहरां चेलयां जो अपणे बाल गिठा होणे जो बोलया, कने उना जो बोलया, “जड़ा कोई सारयां ला महान बणना चांदा है, तां सै अपु जो सारयां ला निच समझे कने सारायां दा सेवक बणे।” ");
INSERT INTO bht_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","तालू यीशुऐ बखे इक बच्चा खुड़ोतया था, यीशुऐ बच्चे जो गल्ले लगाया कने चेलयां जो बोलया। ");
INSERT INTO bht_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“जड़ा कोई माणु इयां ही इक बच्चे पर दया दसदा है, सै सच्ची मेरा इज्जत मान करदा है। कने कोई मेरी इज्जत मान करदा है, तां सै मेरा ही नी बल्कि मेरे परमेश्वरे दी इज्जत मान करदा है, जिनी मिजों भेजया है।” ");
INSERT INTO bht_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","तालू यूहन्ना उसयो बोलया, “गुरू जी, असां इकी माणुऐ जो तेरे नाए दी शक्ति ने बुरियां आत्मा जो कडदे दिखया है, कने असां उसयो मना भी किता, क्योंकि सै साड़े सांई तेरा चेला नी था।” ");
INSERT INTO bht_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","यीशुऐ बोलया, “उसयो मना मत करा अगर कोई मेरे नाये ने चमत्कार करदा है, क्योंकि ऐसा कोई नी है, जड़ा मेरे नाऐ ने सामर्थ्य दे कम्म करे, कने जल्दी मिंजो बुरा बोली सके, ");
INSERT INTO bht_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","क्योंकि जड़े साड़े बेरी नी है, सै साड़े सोगी साथी न।” ");
INSERT INTO bht_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","जड़ा कोई इक कटोरा पांणिये दा तुहांजो इस तांई पियां, की तुसां जो मसीह दे चेले बोलदे न, मैं तुसां ने सच्च बोलदा हे की उनी अपणा फल कुसा भी हालत च नी गवांणा है। ");
INSERT INTO bht_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","पर अगर कोई इना छोटयां चे, जड़े मिंजो पर भरोसा करदे न, उना दे पापां दी बजा बणे तां उना तांई ऐई ही खरा है की अपणे गले च पथर बन्नी करी दरियाये च छलांग लगाई दे। ");
INSERT INTO bht_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","सारियां बुराइयां जो छडी दिया जिना ने पाप होंदा है! बुराइयां जो पुरे तरीके ने छडी दिया, जियां की तुसां इक हथ बड्डा दे, जड़ा तुहाड़े पापां दी बजा बणदा है। अगर तुसां स्वर्ग जो जांदे न, भले ही तुसां बाल इक ही हथ है, सै तुसां तांई खरा है। कने अगर तुसां बाल दोनो हथ न, कने तुसां नरके जान, तां इसला भयानक कुछ नी है। ");
INSERT INTO bht_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","नरके दिया उसा जगा पर जिथू सारयां दे जिस्मा जो खाणे बाले कीड़े कदी नी मरदे कने बलियो अग्ग कदी नी बुझदी। ");
INSERT INTO bht_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","सारियां बुराइयां जो छडी दिया जिना ने पाप होंदा है, बुराइयां जो पुरे तरीके ने छडी दिया जियां की तुसां इक पैर बड्डा दे, जड़ा तुहाड़े पापां दी बजा बणदा है। अगर तुसां स्वर्ग जो जांदे न, भले ही तुसां बाल इक ही पैर है, सै तुसां तांई खरा है। कने अगर तुसां बाल दोनो पैर न, कने तुसां नरके जान, तां इसला भयानक कुछ नी है। ");
INSERT INTO bht_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","नरके दिया उसा जगा पर जिथू सारयां दे जिस्मा जो खाणे बाले कीड़े कदी नी मरदे कने बलियो अग्ग कदी नी बुझदी। ");
INSERT INTO bht_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","सारियां बुराइयां जो छडी दिया जिना ने पाप होंदा है, बुराइयां जो पुरी तरह छडी दिया जियां की तुसां इक हखी जो कडा दे, जड़ा तुहाड़े पापां दी बजा बणदा है। अगर तुसां स्वर्ग राज्य जो जांदे न, भले ही तुसां बाल इक ही हख है, सै तुसां तांई खरा है। कने अगर तुसां बाल दोनो हखी न, कने तुसां नरके जान, तां इसला भयानक कुछ नी है। ");
INSERT INTO bht_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","नरके दी उसा जगा पर जिथू सारयां दे जिस्मा जो खाणे बाले कीड़े जड़े कदी नी मरदे कने बलियो अग्ग कदी नी बुझदी। ");
INSERT INTO bht_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","क्योंकि हर इक जणा अग्गी ने शुद्ध किता जाणा, जियां की बलिदान नुणे ने शुद्ध होंदा है। ");
INSERT INTO bht_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","नुण इक जरूरी चिज है, पर अगर उदा स्वाद चली जा, तां उदा स्वाद कियां वापिस लोणा? तुसां च लूँणे सांई खुबियां होणी चाईदियां, कने अपु चे मिली झूली कने शांतिया ने रिया। ");
INSERT INTO bht_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","यीशुऐ अपणे चेलयां सोगी कपरनहुम शहर छडी दिता, सै यहूदिया प्रदेशे ला निकले कने यरदन खड्डा दे दुऐ पास्से चली गे। कने इक बरी फिरी भीड़ उदे बाल गिठी होई गेई, कने सै उना जो हरबरी सांई उपदेश देणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","तालू फरीसी उदे बाल आऐ कने उसयो परखणे तांई उसला पुछया, “क्या मूसा दिया व्यवस्था च इक मरदे जो अपणिया घरे बालिया जो तलाक देणे दा हक है?” ");
INSERT INTO bht_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","यीशुऐ उना जो जबाब दिता, “मूसा तुहांजो तलाक दे बारे च क्या हुकम दितया है?” ");
INSERT INTO bht_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","उना बोलया, “मूसा हुकम दितया की त्याग पत्र लिखी करी अपणी घरे बालिया जो देई दिया कने उसा जो छडी दिया।” ");
INSERT INTO bht_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","यीशुऐ उना जो बोलया, “तुसां हरबरी परमेश्वरे दे हुकमें जो मनणे तांई मुकरी जांदे न, क्योंकि तुसां दा मन कठोर है, इस तांई मूसा ऐ लिखया था। ");
INSERT INTO bht_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","पर पबित्र शास्त्रां च लिखया है कि जालू परमेश्वरे संसार बणया था, तालू उनी इक मर्द तांई इक जनानी बणाई। ");
INSERT INTO bht_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","जालू इक मर्द जनानिया ने बियाह करदा है, तां सै दोनों इक होई जान्दे न, क्योंकि सै दोंनो इक जान न। ");
INSERT INTO bht_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","कने सै दोनो हुण इक तन न, क्योंकि हुण सै दो जणे नी, पर इक माणुऐ सांई न। ");
INSERT INTO bht_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","इस तांई उसा जनानिया कने मर्दे जो बख नी करणा चाईदा जिना जो परमेश्वरे बियाह दे बंधना च बनया है।” ");
INSERT INTO bht_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","कने बादे च, जालू सै चेलयां सोगी घरे च किल्ला था, तालू चेलयां तलाक दे बारे च उसला पुछया। ");
INSERT INTO bht_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","यीशुऐ उना जो जबाब दिता, “जड़ा अपणिया घरे बालिया जो छडी करी दुईया ने बियाह करे तां सै उसा पेहलिया दे खिलाफ च व्यभिचार करदा है। ");
INSERT INTO bht_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","कने अगर घरे बाली अपणे घरे बाले जो छडी करी कुसी होरसी ने बियाह करे, तां सै व्यभिचार करदी है।” ");
INSERT INTO bht_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","फिरी लोक बचयां जो यीशुऐ बाल लोणा लग्गे ताकि सै उना पर हथ रखीकर उना जो आशीष दे, पर चेलयां उना लोकां जो डांटया। ");
INSERT INTO bht_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","यीशुऐ जो ऐ सब दिखीकरी गुस्सा आया कने उना जो बोलया, “बचयां जो मना मत करा कने इना जो मेरे बाल ओंणा दिया, जड़े इना बचयां सांई भरोसेमदं न उना परमेश्वरे दे राज्य च रेणा। ");
INSERT INTO bht_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","मैं तुसां ने सच्च बोलदा है, परमेश्वरे अपणे राज्य च सिर्फ उना लोकां जो ओणा देणा है जड़े परमेश्वरे दे राज्य जो बचयां सांई अपनांदे न।” ");
INSERT INTO bht_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","कने यीशुऐ बचयां जो गल्ले ने लाया, कने उना पर हथ रखीकरी यीशुऐ आशीष दिती। ");
INSERT INTO bht_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","जालू यीशु कने उदे चेलयां यात्रा करणा शुरू किती थी, तां इक माणु उदे बाल दौड़ी करी आया कने इज्जत मान तांई उदे पैरां अग्गे डेई पिया कने उसला पूछणा लग्गा की, “हे उत्तम गुरू, मैं क्या कम्म करां की परमेश्वर मिंजो हमेशा दी जिन्दगी दे? ");
INSERT INTO bht_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","यीशुऐ उसयो बोलया, तुसां मिंजो कजो उत्तम बोलदे न, उत्तम तां सिर्फ इक ही है, सै परमेश्वर है।” ");
INSERT INTO bht_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","“तू परमेश्वर दे हुकमा जो तां जाणदा है की : हत्या नी करणी, व्यभिचार नी करणा, चोरी नी करणी, झूठी गबाई नी देंणी, बेईमानी नी करणी, कने अपणे माता पिता दा आदर करणा।” ");
INSERT INTO bht_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","उनी यीशुऐ बोलया, “गुरू जी, इना सबना हुकमा जो तां मैं बचपने ला ही मनदा आया है।” ");
INSERT INTO bht_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","यीशुऐ उस पासे नजर करी के प्यारे ने दिखया कने उसयो बोलया, “इक कम्म है जड़ा तिजो हाली भी करणे दी जरूरत है। जा, कने जड़ा कुछ तेरा है उसयो बेची करी गरीबां जो देई दे, तां तिजो स्वर्गे दा धन मिलणा, इयां करणे बाद आ कने मेरा चेला बणिया।” ");
INSERT INTO bht_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","तालू माणुऐ यीशुऐ दी इसा गल्ला जो सुणया, कने उदे चेहरे पर उदासी छाई गेई, कने सै दुखी होईकरी चली गिया, क्योंकि सै बड़ा भरी अमीर था। ");
INSERT INTO bht_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","यीशुऐ चारो पासे दिखीकरी अपणे चेलयां जो बोलया, “अमीरां दा परमेश्वरे दे राज्य च जाणा बड़ा मुशकिल है।” ");
INSERT INTO bht_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","तालू चेले यीशुऐ दियां गल्लां सुणी की हेरान होई गे, यीशुऐ बोलया मेरे भाईयो, जड़ा कोई अपणे पैसयां उपर भरोसा करदा है, उना तांई परमेश्वरे दे राज्य जो जाणा बड़ा मुशकिल है। ");
INSERT INTO bht_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ऊंटे दा सुइया दे नाके चे निकलना असान है, पर अमीरां दा परमेश्वरे दे राज्य च जाणा बड़ा भरी मुशकिल है। ");
INSERT INTO bht_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","जालू चेलयां ऐ सुणया, तां सै बड़े हेरान होईकरी अपु चे बोलणा लग्गे, “तां कुण अपणे पापां दी सजा मिलणे ला बची सकदा है?” ");
INSERT INTO bht_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","यीशुऐ उना दे पासे दिखीकरी बोलया, “जड़ा माणु नी करी सकदे, पर सै परमेश्वर करी सकदा है, क्योंकि परमेश्वरे सब कुछ करी सकदा है।” ");
INSERT INTO bht_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पतरस यीशुऐ जो बोलणा लग्गा, सांझो क्या मिलणा? असां तां तुहाड़े चेले बणने तांई अपणा सारा कुछ छडी दितया है। ");
INSERT INTO bht_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","यीशुऐ चेलयां जो बोलया, “मैं तुहांजो ने सच्च बोलदा है, मेरे चेले बणने तांई कने शुभसमाचार दा प्रचार करणे तांई तुसां च जिनी भी घरे जो छडया, या अपणे भाई बेहण, माता-पिता, अपणिया जमिना जो छडया है। ");
INSERT INTO bht_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","उसयो इस बकते सौ गुणा ना मिल्ला हो, जिनी अपणा टबर, भाई कने बेहणां, माता-पिता, बाल बचयां जो या खेतरां जो छडया हो। पर उसयो तकलिफां कने ओणे बाले बकते च हमेशा दी जिन्दगी मिलणी है। ");
INSERT INTO bht_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","पर मते लोक न जड़े हुण महान कने अग्गे न, उसी बकते सै पीच्छे होणे, कने जड़े पीच्छे न, सै उस बकते पेहले होणे न।” ");
INSERT INTO bht_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","सै यरूशलेम शेहर जो जांदे बेले जालू रस्ते च थे, तां यीशु उना दे अग्गे-अग्गे चलया था, कने उदे चेले बड़े हेरान होऐ की जिथू सै चलयो थे, ओथु मते लोका उना दा बिरोध किता था, कने जड़े लोक उदे सोगी थे, सै इसा गल्ला ला डरयो थे, की यरूशलेम शेहर च उना दा क्या होणा। तालू सै फिरी उना बाहरां चेलयां जो इकी तरफा लेईकरी उना ने गल्लां बोलणा लग्गा, जड़ियां उस सोगी होणे बालियां थियां। ");
INSERT INTO bht_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“दिखा, ध्याने ने सुणा, असां यरूशलेम शेहरे जो चलयो न, कने मैं माणुऐ दा पुत्र बड्डे याजकां कने यहूदी व्यवस्था जो सिखाणे बालयां दे हथे पकड़ाया जाणा है, कने उना मिंजो मौत दी सजा देणी है, कने होर जातियां दे हथे देई देणा है। ");
INSERT INTO bht_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","कने उना मेरा मजाक उड़ाणा है, मिंजो पर थुकणा, कने मिंजो कोड़े मारणे, कने मिंजो मारी देणा है, कने मैं तिजे दिने मरयां चे जिंदे होई जाणा है।” ");
INSERT INTO bht_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","याकूब कने यूहन्ना दो भाई, जड़े जब्दी दे पुत्र थे उना यीशुऐ बाल आई करी बोलया, “गुरू जी, असां कुछ तिजो ला मंगणा चांदे न, सेई तू साड़े तांई कर।” ");
INSERT INTO bht_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","यीशुऐ उना ला पूछया, “तुसां क्या चांदे न की मैं तुहाड़े तांई करे?” ");
INSERT INTO bht_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","उना यीशुऐ जो बोलया, “असां तुसां दे महिमामय राज्य च तुसां दे बखे इज्जत बाली जगा च बोंणा चांदे न। असां चे इक तुहाड़े खबे कने इक सज्जे हथे बखे बोंणा चांदे न।” ");
INSERT INTO bht_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","यीशुऐ उना जो बोलया, “तुसां जो नी पता कि तुसां क्या मंगा दे? हुण जड़े दुख मैं सेहणे न, क्या तुसां उना दुखां जो सेहन करी सकदे न? क्या तुसां मरणे तांई तैयार न क्योंकि मैं जल्दी ही मरणे बाला है?” ");
INSERT INTO bht_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","उना उसला बोलया, “असां करी सकदे न।” यीशुऐ उना ने बोलया, “तुसां भी सारे दुख सेहणे न, जियां मैं सेहणे। तुसां जो भी मारया जाणा है, जियां मिजों मारणा है। ");
INSERT INTO bht_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","मिजों ऐ तय करणे दा हक नी है, की मेरे सज्जे कने खबे कुसयो सै जगा मिलणी है, सै जगा उना लोकां तांई न, जिना जो परमेश्वर चुणयां है।” ");
INSERT INTO bht_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ऐ सुणीकरी बाकी दसो चेले याकूब कने यूहन्ना पर गुस्सा करणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","तां यीशुऐ उना जो अपणे बाल सदीकरी उना जो बोलया, “तुहांजो पता है ना, कि जड़े लोक प्रधान मने जादें थे, सै अपणे अधिकारां दा इस्तेमाल अपणे अधीन लोकां दे उपर हक जमाणे तांई करदे न। उना दे अगुवे लोक अपणी गल्ल मनाणे तांई हक जतांदे न। ");
INSERT INTO bht_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","पर तुहांजो उना सांई नी होणा चाईदा, तुहांजो चे जड़ा महान बणना चांदा है, उसयो बाकियां दी सेबा करणी चाईदी। ");
INSERT INTO bht_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","कने जड़ा कोई तुसां चे प्रधान बणना चांदा हो, सै सारायां दा नौकर बणे। ");
INSERT INTO bht_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","मैं ऐ इस तांई बोलदा है क्योंकि मैं, माणुऐ दा पुत्र, इस संसारे च सारयां दी सेबा करणे तांई आया है, मैं इस तांई नी आया कि लोकां ला अपणी सेबा करां। मैं तां लोकां जो पापां ला छुटकारा कराणे तांई अपणे प्राण कीमत च देणा आया है।” ");
INSERT INTO bht_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","यरूशलेम शेहर दे रस्ते च जांदे, यीशु कने चेले येरीहो च आये, जालू सै कने उदे चेले कने इक बड़ी भीड़ यरीहो शेहरे ला निकला दी थी, इक बरतिमाई नाऐ दा अन्ना भिखारी सड़का दे बखे बैठया था। सै तिमाई दा जागत था। ");
INSERT INTO bht_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","सै ऐ सुणीकरी की यीशु नासरत शेहरे ला है, जड़ा रस्ते च चलया था, डडी-डडी करी बोलणा लग्गा, “हे यीशु, राजा दाऊदे दे बंशज, मिंजो पर दया कर।” ");
INSERT INTO bht_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","उसयो मतयां झिड़कां दीतियां की चुप रे, पर सै होर जोरे ने बोलणा लग्गा की, “हे यीशु, राजा दाऊदे दे बंशज, मिंजो पर दया कर।” ");
INSERT INTO bht_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","तालू यीशुऐ ऐ सुणया कने रुकी करी बोलया, “उसयो ऐथू लोआ।” कने लोकां उस अन्ने जो सदीकरी बोलया, “हिम्मत रख, उठ सै तिजो सदा दा है।” ");
INSERT INTO bht_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","कने अन्ने माणुऐ झट अपणे उपर ओडियो चादर सुटी कने उठी करी यीशुऐ बाल आया। ");
INSERT INTO bht_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","यीशुऐ उसयो पुछया, “तू क्या चांदा है की मैं तेरे तांई करे?” अन्ने उसयो बोलया, “गुरू जी, ऐ की मिंजो मिलणा लगी पोऐ।” ");
INSERT INTO bht_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","यीशुऐ उसयो बोलया, “मैं तिजो ठीक करा दा क्योंकि तु मिजों पर भरोसा करदा है। हुण तू घरे जो जाई सकदा है” कने उसयो मिलणा लग्गी पिया, कने रस्ते च यीशुऐ पिच्छे चली पिया। ");
INSERT INTO bht_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","जियां यीशु कने उदे चेले यरूशलेम शेहरे दे बखे पुज्जे, सै जैतून रुखां दे पाहड़े दे कंडे बैतफगे कने बैतनिय्याह ग्रांऐ च आये, तां यीशुऐ अपणे दो चेलयां जो ऐ बोली करी भेजया, ");
INSERT INTO bht_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“सामणे दे ग्रां च जा, कने ओथु पुजदे ही तुहांजो इक गधिया दा बच्चा बन्नया मिलणा है, उदे उपर हली कोई नी बैठया था। सै खुंडे च बन्नया होणा उसयो खोली करी लेई ओआ। ");
INSERT INTO bht_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","अगर कोई तुहांजो ला पुच्छे, कि ऐ क्या करा दे न? तां बोलनयो, कि साड़े प्रभु जो इदी जरूरत है। कने उनी जल्दी ही बापस करी देणा है।” ");
INSERT INTO bht_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","चेलयां ग्रांऐ च जाई करी उस गधिया दे बच्चे जो इक घरे दे दरबाजे बखे खुंडे ने बनया दिखया, कने सै उसयो खोलणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","कने जड़े ओथु खड़ुतयो थे उना चे कोई-कोई बोलणा लग्गे की ऐ क्या करा दे न, इस गधी दे बच्चे जो कजो खोला दे न? ");
INSERT INTO bht_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","जियां यीशुऐ बोलया था, तियां ही चेलयां उना जो बोली दिता उना गधिया दे बच्चे जो जाणा दिता। ");
INSERT INTO bht_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","कने दो चेलयां उस गधिया दे बच्चे जो यीशुऐ बाल लांदा, कने उस पर अपणे उपरे बाले कपड़े उदिया पीठी पर पाई दिते कने यीशु उस पर बेई गिया कने यरूशलेम शेहरे दी पास्से चलणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","तालू मतयां सारयां लोकां अपणे कपड़े रस्ते च बछाई दिते कने उदा आदर मान किता। कने केईयां रस्ते च पत्रां बालियां डालियाँ बडी-बडी करी बछाई करी उदा मान आदर किता। ");
INSERT INTO bht_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","कने थोड़े लोक यीशु दे अग्गे-अग्गे चलयो थे, कने थोड़े लोक पिच्छे चलयो थे, सै सारे खुशिया ने जोरे ने बोला दे थे, “होशाना; परमेश्वर इसला खुश है जड़ा उदे हके सोगी ओंदा है। ");
INSERT INTO bht_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","परमेश्वरे दा अनुग्रह ओणे बाले राज्य पर है, जड़े साडे़ सियाणे राजा दाऊद दे राज्य सांई है, धन्य हे! परमेश्वर जड़ा स्वर्गे च रेंदा है, उदी होशाना हो।” ");
INSERT INTO bht_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","जालू यीशु यरूशलेम शेहरे च पुज्जा कने तां सै परमेश्वरे दे मंदरे दे अंदर गिया, कने सारे पासे दिखया कने सै अपणे बाहरां चेलयां सोगी बैतनिय्याह ग्रांऐ जो मुड़ी गिया, क्योंकि संज होई गियो थी। ");
INSERT INTO bht_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","दुज्जे दिने जालू यीशु कने उदे चेले बैतनिय्याह ग्रांऐ ला यरूशलेम शेहरे जो चलयो थे, तालू यीशुऐ जो भूख लग्गी। ");
INSERT INTO bht_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","कने उनी पत्तयां ने भरया होया अंजीरे दा रुख दिखया कने सै उदे बखे गे, ताकि कुछ खाणे जो मिली जा, पर ओथु पतयां जो छडी करी होर कोई फल नी मिल्ला, क्योंकि फल देंणे दी रित नी थी। ");
INSERT INTO bht_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","कने यीशुऐ उस रुखे जो बोलया, “अज्जे ला बाद तेरा फल कुनी नी खाणा। कने उदे चेले सुंणा दे थे।” ");
INSERT INTO bht_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","“उदे बाद यीशु कने उदे चेले सै यरूशलेम शेहरे च आऐ,” उनी उना लोकां जो परमेश्वर दे मंदरे ला कडी दिता, जड़े ओथु जानवर कने चिजां खरीदणे बचने दा कम्म करा दे थे। यीशुऐ पैसयां बदलने बाले मंजे जो, कने कबुतरां जो बेचणे बालयां दे पिंजरयां जो बाहर सुटी दिता। ");
INSERT INTO bht_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","“कने उनी लोकां जो हुकम दिता की मंदरे दे अंगणे ला होईकरी चिजां जो लिणा बंद करा। ");
INSERT INTO bht_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","कने यीशुऐ उना जो बोलया, पबित्र शास्त्र ऐ बोलदा की, लोक मेरे घरे जो प्राथना दा घर बोलदे न, जिथू सारे लोक प्राथना तांई ओंदे न? पर तुसां तां इसयो डाकुआं ला भरुईयो गुफा सांई बणाई दितया है।” ");
INSERT INTO bht_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","बड्डे याजकां कने यहूदियां दिया व्यवस्था जो सिखाणे बालयां ऐ सुणया, जड़ा यीशुऐ बोलया कने कितया, तां सै उसयो मारणे दा मौका तोपणा लग्गे, पर सै लोकां ला डरा दे थे, क्योंकि सारे लोक यीशुऐ दियां गल्लां ने हेरान थे। ");
INSERT INTO bht_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","जालू संझा दा बेला होया, तां यीशु कने उदे चेले शेहर छडी करी बैतनिय्याह ग्रां जो मुड़ी गे। ");
INSERT INTO bht_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","फिरी ब्यागा तड़के बेले यीशु कने उदे चेले यरूशलेम शेहरे जो ओआ दे थे, तालू उना अंजीरे दे रुखे जो दिखया तां सै सुकी गिया था। ");
INSERT INTO bht_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पतरसे जो सै गल्ल याद आई, कने उनी यीशुऐ जो बोलया, “गुरू जी, दिख। ऐ अंजीरे दा रुख जिसयो तू श्राप दितया था सै सारा सुकी गिया है।” ");
INSERT INTO bht_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","यीशुऐ उसयो जबाब दिता की, “परमेश्वरे पर भरोसा रख जड़ा तुसां मंगगे से सारा कुछ मिलणा। ");
INSERT INTO bht_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","मैं तुसां ने सच्च बोलदा है, की अगर कोई इस पहाड़े जो बोले की, की ऐथू ला उठ कने समुंद्रे च जाई करी पेई जा, कने अपणे मने च कोई शक नी रखे, पर भरोसा रखे, की जड़ा मैं बोलदा है सै होई जा, तां उस तांई तदिया होई जाणा है। ");
INSERT INTO bht_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","इस तांई मैं तुहांजो बोलदा है की जड़ा कुछ तुसां प्राथना करिके मंगा, तां भरोसा करी लिया की तुहांजो मिली गिया है, तां सै तुहांजो मिली जाणा। ");
INSERT INTO bht_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","जालू कदी तुसां प्राथना करदे न, तां अगर तुहाड़े मने च कुसी तांई बैर है, तां उसयो माफ करी दिया, इस तांई की तुहाड़ा पिता परमेश्वर जड़ा स्वर्गे च रेंदा है, उनी तुसां दे पाप माफ करी देणे। ");
INSERT INTO bht_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","पर अगर तुसां माफ नी करगे, तां तुहाड़े पिता परमेश्वरे जड़ा स्वर्गे च है, उनी भी तुहाड़ा पाप माफ नी करणा।” ");
INSERT INTO bht_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","यीशु कने उदे चेले यरूशलेम शेहरे जो मुड़ी करी आये, जालू सै मंदरे च गुमा दा था तां बड्डे याजक कने यहूदी व्यवस्था जो सिखाणे बालयां कने यहूदी अगुवे उदे बाल आये कने पूछणा लग्गे, ");
INSERT INTO bht_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“उना उसयो बोलया, ऐ कम्म तू कुसी हके ने करा दा है? कने तिजो ऐ हक कुनी दितया है?” ");
INSERT INTO bht_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","यीशुऐ उना जो बोलया, “मैं भी तुहांजो ला इक गल्ल पूछदा है, अगर तुसां मिंजो जबाब दिंगे, तां मैं दसगा कि ऐ कम्म मैं कुसी हके ने करदा है। ");
INSERT INTO bht_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","यूहन्ना जो लोकां जो बपतिस्मा देणे तांई कुनी भेजया था? क्या सै परमेश्वरे भेजया था या माणुऐ? मिंजो दसा।” ");
INSERT INTO bht_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","तालू सै अपु चे बोलणा लग्गे कि अगर असां बोलया कि, “परमेश्वर जड़ा स्वर्गे च है उनी भेजया है, तां यीशुऐ सांझो ला पुछणा, कि तुसां युहन्ना पर भरोसा कन्नी किता?” ");
INSERT INTO bht_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","अगर असां बोलया की, सै माणुऐ दे पास्से ला आया है, तां सै जबाब नी देई सके, क्योंकि सै उना लोकां ला डरदे थे, जड़े ऐ मंदे थे की यूहन्ना परमेश्वर दे पासे आया इक सच्चा परमेश्वरे दा संदेश देणेबाला था। ");
INSERT INTO bht_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","उना यीशुऐ जो जबाब दिता, सांझो नी पता कुन्नी यूहन्ना बपतिस्मा देणेबाले जो भेजया। यीशुऐ उना जो जबाब दिता, “मैं भी तुहांजो नी दसणा की मिंजो ऐसे कम्म करणे दा हक कुनी दितया है।” ");
INSERT INTO bht_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","इदे बाद, यीशु यहूदी अगुवां ने कहाणियां च गल्लां करणा लग्गा, इक माणुऐ बागे च अंगूर लाये। उनी अंगूरा दे बागे दे चारों पासे बाड़ लगवाया, कने इक जगा अंगूरा दे रसे जो निचोड़ने तांई बणाई, कने निगरानी रखणे तांई इक उचिया जगा पर कमरा बणाया। फिरी उनी बागे जो कुछ किसाना जो ठेके पर देई दिता, कने परदेस चली गिया। ");
INSERT INTO bht_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","फिरी जालू अंगूर पक्की गे, तां उनी अपणा इक नोकर ठेकेदारे बाल अपणा अंगूरे दे बागे दा हिस्सा लोंणे तांई भेजया। ");
INSERT INTO bht_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","पर ठेकेदारां उसयो पकड़या कने मारी कुट्टी करी बिना कुछ दितयो खाली हथ भेजी दिता। ");
INSERT INTO bht_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","बागे दे मालिके इक होर नोकर भेजया, ठेकेदारां उदा सिर फोड़या कने उदी बेस्ती किती। ");
INSERT INTO bht_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","फिरी बागे दे मालिके इक होर नोकरे जो भेजया, कने उना उसयो मारी दिता। तां उनी होर मतयां जो भेजया, पर ठेकेदारे उना चे केईयां जो कुटया, कने केईयां जो मारी दिता। ");
INSERT INTO bht_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","हुण बागे दे मालिके बाल भेजणे तांई सिर्फ इक ही माणु था। जड़ा उदा अपणा प्यारा जागत था। उना बाल भेजया की सै मेरे जागते दी इज्जत करगे। ");
INSERT INTO bht_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","पर उना ठेकेदारां उदे जागते जो ओंदे दिखया, कने उना अपु चे सलाह किती की, ऐई तां बारिस है, इनी तां अंगूरे दे बागे दा मालिक बणना, ओआ असां इसयो मारी दिन्दे न, तां सारी जयादात साड़ी होई जाणी। ");
INSERT INTO bht_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","कने उना उसयो पकड़ी करी मारी दिता, कने उदी लाशा जो अंगूरे दे बागे बाहर फेंकी दिता। ");
INSERT INTO bht_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“तां हुण, अंगूर दे बागे दा मालिक क्या करगा? क्या उनी आई करी उना ठेकेदारां जो खत्म करी दिगां, कने दाखां दे बागे दा ठेका कुसी होरसी जो दिंगा। ");
INSERT INTO bht_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","क्या तुसां पबित्र शास्त्रे दा ऐ हिस्सा नी पढ़या जिदे च मसीह दी तुलना इक खास पथरे ने करदा है? सै बोलदा है, जिस पथरे जो राजमिस्त्रियें बेकार बोलया था कने सुटी दितया, सै ही पथर, सबना ला खास पथर बणी गिया। ");
INSERT INTO bht_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","प्रभु परमेश्वरे इयोदिया किता, कने साड़िया नजरा च ऐ बड़ा ही अनोखा है।” ");
INSERT INTO bht_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","तां उना उसयो पकड़ना चाया, क्योंकि सै समझी गियो थे, उनी साड़े बरोध च ऐ कहाणी बोलियो है। पर सै यीशुऐ जो पकड़ी नी सके क्योंकि सै लोकां ला डरा दे थे, इस तांई सै यीशुऐ जो किल्ला छडी करी चली गे। ");
INSERT INTO bht_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","तालू उना उसयो गल्लां च फसाणे तांई केई फरीसियां कने राजा हेरोदियां दे दले दे लोकां जो उस बाली भेजया। ");
INSERT INTO bht_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","उना आई करी उसयो बोलया, “गुरू जी, सांझो पता है की, तुसां हमेशा सच्च बोलदे न, कने तुसां इसा गल्ला ला नी डरदे की दुज्जे लोक तुहाड़े बारे च क्या सोचदे न, कुसदी परबाह नी करदे न, क्योंकि तुसां सारयां कने इकोदिया व्यवहार करदे न, तू तां परमेश्वरे दा रस्ता सचाइया ने दसदा है। तां हुण सांझो दस। क्या महाराजा जो कर देणा साड़िया व्यवस्था दे खिलाफ है या नही? ");
INSERT INTO bht_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","असां जो कर देणा चाईदा या नी देणा चाईदा?” यीशुऐ उना दा कपट जाणी करी उना जो बोलया, “तुसां मिंजो ला कुछ गलत बुलबाई करी फसाणे दी कोशिश कजो करा दे न? इक चांदी दा सिक्का मिंजो बाल लेईकरी ओआ, मैं उसयो दिखें।” ");
INSERT INTO bht_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","सै लेई आऐ, कने यीशुऐ उना जो पुछया, “मिजों दसा की इस चांदी दे सिक्के च कुसदा चित्र बणया कने कुसदी मोहर लगियो?” उना बोलया, “महाराजा दा।” ");
INSERT INTO bht_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","यीशुऐ उना जो बोलया, “जड़ा महाराजा दा है, सै महाराजे जो दिया, कने जड़ा परमेश्वरे दा है, सै परमेश्वरे जो दिया।” तालू सै उस पर बड़े हेरान होए। ");
INSERT INTO bht_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","यहूदियां दे धर्मी दल दे थोड़े लोक जिना जो सदूकी भी बोलदे न, तालू थोड़े यहूदी अगुवे यीशुऐ बाल आये। कने सै भरोसा नी करदे थे, कि लोक मरणे दे बाद फिरी जिन्दे होई सकदे ने। उना यीशुऐ ला पुछया, ");
INSERT INTO bht_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“गुरू जी, मूसा साड़े तांई लिखया है, की अगर कुसी दा भाई बिना ओलादी मरी जा, कने उदी घरे बाली जिन्दा रे, तां उदा भाई उदिया घरे बालिया सोगी बियाह करिके अपणे भाई तांई बंश पैदा करे। ");
INSERT INTO bht_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","स्दुकियां यीशुऐ जो इक कहाणी सुणाई की, इक घरे च सत भाई थे। सबते बडे भाईये इकी जनानिया ने बियाह किता, जालू सै मरी गया तां उदी कोई भी ओलाद नी थी। ");
INSERT INTO bht_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","तां दुऐ भाईऐ उसा सोगी ही बियाह करी लिया कने सै भी बिना ओलादी मरी गिया, कने इयां ही तिजे भाईये किता, ");
INSERT INTO bht_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","कने सतां भाईयां उसा ने बियाह किता कने सतो भाई बिना ओलादी मरी गे। सबना दे बाद सै जनानी भी मरी गेई। ");
INSERT INTO bht_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","हुण, सांझो दस सतां भाईयां उसा जनानिया ने बियाह कितया था, जालू सै मरणे दे बाद फिरी जिन्दे होंगे, तां सै जनानी कुदी घरे बाली होणी?” ");
INSERT INTO bht_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","यीशुऐ उना जो बोलया, “तुसां दो बजा ने गलत न, तुसां पबित्र शास्त्र जो नी जाणदे ने जड़ा मरणे दे बाद लोकां जो जिन्दा रेणे दे बारे च दसदा है। तुसां ऐ नी जाणदे न की परमेश्वरे बाल मरयो लोकां जो जिन्दा करणे दी शक्ति है। ");
INSERT INTO bht_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","क्योंकि जालू उना मरयां चे जिन्दा होणा, तां उना लोका दे बियाह नी होणे; जियां स्वर्गे च रेणेबाले स्वर्गदूत बियाह नी करदे। ");
INSERT INTO bht_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","मरयां चे जिन्दा होणे दे बारे च, तुसां क्या मूसा दिया कताबां च नी पढ़या जालू झाड़िया जो अग्ग लगियो थी, तां उसा जगा पर क्या होया था, परमेश्वरे मूसा ने गल्ल किती कने बोलया, मैं अब्राहम, इसहाक, कने याकूब दा परमेश्वर है, जिदी ऐ अराधना करदे थे। ");
INSERT INTO bht_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","तांई तां मरयो लोकां दा परमेश्वर नी है। पर जिन्दया दा परमेश्वर है, तुसां बड़े गलत न।” ");
INSERT INTO bht_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","कने यहूदी मूसा दी व्यवस्था जो सिखाणे बालयां चे इकी ऐ चर्चा सुणी, जड़ी यीशु कने सदुकी अपु चे करा दे थे, कने ऐ जाणी करी की यीशुऐ उना जो ठीक तरीके ने जबाब दिता, तां सै यीशुऐ बाल आया कने पुछया, “की परमेश्वरे जड़े भी हुकम दितयो न, उना सारयां चे सारयां ला बडा हुकम कुण दिया है?” ");
INSERT INTO bht_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","यीशुऐ जबाब दिता, “सबना हुकमा ला बडा हुकम ऐ है: इस्राएल दे लोको तुसां सुणा। प्रभु साड़ा परमेश्वर जिसदी असां अराधना करदे न, सै इक ही प्रभु है। ");
INSERT INTO bht_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","कने तू अपणे प्रभु परमेश्वर ने अपणे सारे मने ने, कने अपणे सारे प्राणा ने, कने अपणिया सारिया अकला ने, कने अपणिया सारिया शक्तियां ने प्यार रखनयो। ");
INSERT INTO bht_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","परमेश्वर दा दुज्जा हुकम ऐ है, की जितणा तुसां अपणे आपे जो प्यार करदे न, दूजयां ने भी उतणा ही प्यार करा, परमेश्वरे इना दो हुकमा ला बड्डे होर कोई हुकम नी दितया न।” ");
INSERT INTO bht_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","मूसा दिया व्यवस्था जो सिखाणे बालयां उसयो बोलया, “गुरू जी,” बिलकुल ठीक। तू सच्च बोलया है, सै ही परमेश्वर है, कने उसयो छडी करी होर कोई नी है। ");
INSERT INTO bht_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","कने उसला सारे मन, कने सारिया अकला ने, कने सारे प्राणा ने, कने सारिया ताकता ने प्यार रखणा, कने पड़ोसियां ने अपणयां सांई प्यार रखणा, ऐ सब परमेश्वरे जो जानवरां दियां बलियाँ चढ़ाणे ला जादा जरूरी है। ");
INSERT INTO bht_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","जालू यीशुऐ दिखया की उनी सोची समझीकरी जबाब दिता, तां यीशुऐ उसयो बोलया, “तू परमेश्वरे दे राज्य च प्रवेश करणे दे नेड़े है।” कने फिरी होर कुसी जो उसला कुछ पूछणे दी हिम्मत नी होई। ");
INSERT INTO bht_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","फिरी यीशुऐ परमेश्वरे दे मंदरे च उपदेश दिन्दे होये बोलया की, व्यवस्था जो सिखाणे बाले कियां बोली सकदे न की मसीह राजा दाऊदे दा बंशज है? ");
INSERT INTO bht_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ऐथू दिकर कि राजा दाऊद, जालू परमेश्वर दी पबित्र आत्मा उसयो बोलणे दी शक्ति दिती, तां उनी बोलया, “परमेश्वरे मेरे मसीह जो अपणे बखे इज्जत मान कने हक दी पदवी च बोणे तांई बोलया था, हालांकि उनी उदे सारे दुशमणा जो पूरी तरहा उदे अधीन करी दिता।” ");
INSERT INTO bht_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“ऐथू दिकर कि राजा दाऊदे भी मसीह जो प्रभु करी के बोलया, तां सै दाऊद दा बशंज कियां होया?” कने लोक उसयो बड़े मजे ने सुणदे थे। ");
INSERT INTO bht_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","यीशुऐ अपणे उपदेश च उना ने बोलया, “व्यवस्था जो सिखाणे बालयां ला साबधान रिया, जड़े लोकां जो दसणे तांई लम्बे कने मेंगे कपड़े पाणा पसंद करदे, कने उना जो बड़ा पसंद है की लोक उना जो बजारां च नमस्ते करन, ");
INSERT INTO bht_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","कने यहूदी जंज घरां च खास-खास आसना पर बोणा पंसद करदे न। कने खांदे बेले खास जगा चांदे न। ");
INSERT INTO bht_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","सै धोखे कने वेईमानिया ने विधवां दे घरां दी चिजां पर कब्जा करी लेंदे न। कने लोकां जो दसणे तांई बड़ी देरा दीकर प्राथना करदे न, परमेश्वरे ला इना जो बड़ी बुरी सजा मिलणी है।” ");
INSERT INTO bht_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","यीशु मंदरे दे भंडारे सामणे बेईकरी दिखा दा था की लोक परमेश्वरे दे मंदरे दे भंडारे च कियां पैसा पांदे न, कने मते अमीरां लोकां बड़ा सारा पैसा पाया। ");
INSERT INTO bht_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","इतणे च इक गरीब बिधवा आई करी दो तांबे दे सिक्के पाये, जिना दी कीमत बड़ी घट्ट थी। ");
INSERT INTO bht_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","तालू उनी अपणे चेलयां जो अपणे बखे सदीकरी बोलया, “मैं तुसां ने सच्च बोलदा कि इस मंदरे दे भंडारे च जितणया भी दान पाया है, उना सबना ला बदीकरी इना गरीब बिधवा पाया है।” ");
INSERT INTO bht_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","क्योंकि सबना अपणे भंडारे चे थोड़ा दिया दिता, पर इना गरीब बिधवा इसा बाल जितना भी था, सारा पाई दितया है। ");
INSERT INTO bht_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","जालू यीशु मंदरे ला निकला दा था, तां उदे चेलयां चे इकी उसयो बोलया, “गुरू जी, दिख, कितणियां छेल ईमारता न कने बड्डे-बड्डे पत्थरां ने बणियां न कने कितणे-कितणे बड्डे घर न।” ");
INSERT INTO bht_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","यीशुऐ उसयो बोलया, “तुसां इना बड्डे-बड्डे घरां जो दिखा दे न, इक दिन इना चे ऐथू इक भी घर नी बचणा है, ऐथू दीकर की इक पथरे उपर पथर नी रेंणा है, जड़ा डाया नी जांणा।” ");
INSERT INTO bht_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","जालू यीशु मंदरे ला जैतून रुखां दे पाहड़े पर चली गिया कने मंदरे दे सामणे बेई गिया, तां पतरस, याकूब, यूहन्ना कने अन्द्रियास यीशुऐ बाल आये कने तालू यीशुऐ बाल कोई नी था, कने उसला पुछया, ");
INSERT INTO bht_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“सांझो दस ऐ सब कुछ कालू होणा है? कने जालू ऐ सब कुछ पूरा होणेबाला होंगा तां उदा क्या निशान होणा है?” ");
INSERT INTO bht_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","यीशुऐ उना ने बोलया, ध्यान रख्यो की तुहांजो कोई धोखा न दे। ");
INSERT INTO bht_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","मते सारे लोकां मेरे नाए ने दाबा करिके ओणा है। उना बोलणा है, मैं मसीहा हूँ कने उना मतयाँ लोकां जो भटकाणा है। ");
INSERT INTO bht_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","जालू तुसां लड़ाईयां, कने लड़ाईयां दियां गल्लां सुणगे तां डरदे मत; क्योंकि इना दा होणा जरूरी है, पर तालू संसारे दा खात्मा नी होणा है। ");
INSERT INTO bht_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","क्योंकि जातियां ने जातियां कने राज्य ने राज्यां इक दुज्जे ने लड़ाईयां करणियां न। कने हर कुथी हिलण होणे न कने अकाल पोणे न। ऐ तकलीफ कने दुख ऐदिया होणा जदिया की जालू माँ बच्चे जो जन्म देणा लगदी है। ");
INSERT INTO bht_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“पर तुसां जो हमेशा चौकने रेणा चाईदा, क्योंकि लोकां तुहांजो कैदी बणाना कने यहूदी जंज घरा च देणा कने तुहांजो मार पोंणी, कने मेरिया बजा ने तुहांजो हाकिमा कने राजयां सामणे न्याय तांई महासभा च पेश करणा है, ताकि तुसां उना जो मेरे तांई गबाई देन। ");
INSERT INTO bht_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","कने सारे देशां च, तुहांजो कने होर जड़े मिजों उपर भरोसा करदे न, तुहांजो संसारे दे अंत होणे दे पेहले सारयां लोकां जो शुभसमाचार सुणाणा है। ");
INSERT INTO bht_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","जालू तुहांजो कैदा च पाणा है, तां तुसां इदी चिंता मत करदे, की असां क्या बोलणा है। क्योंकि उस बेले पबित्र आत्मा तुसां दे जरिये गल्लां करणियां न। ");
INSERT INTO bht_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","उसी बेले, जड़े लोक मिजों पर भरोसा नी करदे न, उना अपणे भाईयां जो जेला च करी लेणा, जड़े मिजों पर भरोसा करदे ने सै मरवाई देणे न। पिता अपणे बचयां सोगी इयां ही करणा है, कने बचयां मां-प्यो दे खिलाफ होईकरी उना जो मारी देणा है। ");
INSERT INTO bht_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","क्योंकि तुसां मेरे चेले न उदिया बजा ने सारे लोकां तुसां ने बैर करणा है, पर जड़े लोक मिजों पर भरोसा रखदे न कने आखरी दीकर सेहन करगा, उना दा ही उद्धार होणा है।” ");
INSERT INTO bht_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","जालू तुसां इक मसीह बिरोधी जो यरूशलेम मंदरे च खड़ोतयो दिखणा, जिथू उसयो नी होणा चाईदा। यहूदिया प्रदेशे दे लोकां जो जान बचाणे तांई पाड़ा पर नसणा पोणा। ");
INSERT INTO bht_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","जड़ा कोई अपणी घरे दिया छती पर हो, तां सै समान लेणे तांई थले ना उतरे, ना ही अंदरे जो जा। ");
INSERT INTO bht_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","कने जड़ा खेतरां च होऐ, सै अपणे कपड़े लेंणे तांई मुड़ी करी घरे ना ओऐ। ");
INSERT INTO bht_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ऐ उना जनानिया तांई बड़ा बुरा बकत होणा जड़ियां लैरथियां न, कने उना जनानियां तांई जड़ियां नियाणे जो दूध पियादियां न, उना जो अपणी जान बचाणे तांई नसणा बड़ा मुशकिल होई जाणा। ");
INSERT INTO bht_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","इस तांई प्राथना करा की ऐ बुरा बकत सर्दियां च ना हो, जालू सफर करणा मुशकिल हो। ");
INSERT INTO bht_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","क्योंकि उना दिना लोकां जो बड़े दुख होणे न, उना लोकां कदी भी ऐसे दुखां दा सामणा नी कितया होणा, जालू ला परमेश्वरे संसार बणाया है। ");
INSERT INTO bht_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","अगर परमेश्वरे उस बुरे बकते जो नी घटादां, तां कोई भी माणु नी बचदा। पर उना चुणयो होए लोकां दिया बजा ला, जिना जो परमेश्वरे चुणयां है, बकत घटाणा है। ");
INSERT INTO bht_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","अगर उस बेले कोई तुसां जो बोले, की दिखा, मसीह ऐथू है। या दिखा, ओथु है। तां उदा भरोसा मत करदे। ");
INSERT INTO bht_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","क्योंकि झूठे मसीह कने झूठे परमेश्वरे दा संदेश देणेबालयां ओणा है, उना लोकां जो धोखा देणे तांई जिना जो परमेश्वरे चुणयां है, उना चमत्कार कने अनोखे कम्म दसणे न। ");
INSERT INTO bht_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","पर तुसां चौकने रिया, दिखा मैं तुहांजो सारियां गल्लां होणे ला पेहले ही बोली दितियां न। ");
INSERT INTO bht_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“उना दिना च, बुरा कने दुखे बाल बकत मुकी जाणे दे बाद, सूरजे च अंधेरा होई जाणा, कने च चद्रमें लौ नी देणी। ");
INSERT INTO bht_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","अम्बरे ला तारायां पेई जाणा, कने अम्बरे दियां शक्तियाँ हिलाईयां जाणियां। ");
INSERT INTO bht_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","तालू लोकां मिजों, माणुऐ दे पुत्रे जो धरतिया पर बदलां उपर ओंदे कने उना मेरी शक्ति कने महिमा जो दिखणा। ");
INSERT INTO bht_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","मैं अपणे स्वर्गदूतां जो धरतिया पर भेजगा, ताकि सै उना सारे लोकां जो गठेरी करी, जिना जो मैं चुणयां है, कने उना संसारे दे चारों पासयां ला लोका जो गठेरणा है।” ");
INSERT INTO bht_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“अंजीर दे रुखे ला ऐ सिखा, जालू उदियां डालियाँ निकलदियां न कने पत्ते निकलना लगदे न, तां तुसां जो पता लगी जांदा है, की गर्मियां दी रित नेड़े ओआ दी है।” ");
INSERT INTO bht_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","जालू तुसां इना चिजां जो होंदे होये दिखगे, तां तुसां जाणी लेनयो, की सै माणुऐ दा पुत्र ओंणे बाला है, कने ऐ दुर नी है। ");
INSERT INTO bht_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","मैं तुसां ने सच्च बोलदा है, इसा पीढ़िया दे सारे लोकां तालू दिकर नी मरणा है, जालू दिकर ऐ सब होई ना जा। ");
INSERT INTO bht_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","अम्बर कने धरती खत्म होई जाणे, पर मेरियां बोलियां गल्लां कदी नी टलनिया न, सै हमेशा रेंणियां न। ");
INSERT INTO bht_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ऐ गल्लां कुसी रोजे या कुसा घड़िया होणिया न कोई भी नी जाणदा है, ना स्वर्गदूत कने ना ही मैं, माणुऐ दा पुत्र, पर सिर्फ पिता परमेश्वर ही उसी रोजे कने घड़िया जो जाणदा है। ");
INSERT INTO bht_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","दिखा, जागदे कने प्राथना करदे रिया; क्योंकि तुहांजो नी पता की कालू मैं मुड़ी करी ओणा। ");
INSERT INTO bht_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","मेरा धरती छडणा कने बापिस ओणा इयां होणा है, जियां परदेस जांदे बेले अपणा घर छडी जाऐ, कने अपणे नोकरां जो हक दे, कने सारयां जो अपणा-अपणा कम्म दसी दे, कने द्वार पालां जो पेहरेदारी करणे दा हुकम दिता कने उदे वापिस ओणे तांई तैयार रे। ");
INSERT INTO bht_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","तुसां नी जाणदे न कि घरे दे मुखिया कालू मुड़ी के ओणा है, तां तुसां पेरादारी करनयो, क्योंकि मैं घरे दा मुखिया संझा जो या अधिया राती जो, या मुर्गे दिया बांगा देंणे दे बेले या ब्यागा जो कालू भी आई सकदा है। ");
INSERT INTO bht_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","इयां नी होऐ की मैं अचानक ओंऐ कने मैं इयां नी दिखणा चांदा की तुसां विना तयारी दे होन। ");
INSERT INTO bht_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","कने जड़ा मैं तुहांजो बोलदा है, सै ही सारायां जो बोलदा है, की मेरे ओणे दीकर तैयार रिया।” ");
INSERT INTO bht_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","दो दिना बाद फसह कने अखमीरी रोटिया दा त्योहार होणेबाला था। कने बड्डे याजक कने व्यवस्था जो सिखाणे बाले इसा गल्लां दिया तोपा च थे, की यीशुऐ जो कियां धोखे ने पकड़ी करी मारी देन। ");
INSERT INTO bht_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","पर बोलदे थे की, “सांझो त्योहारे दे बेले ऐ नी करणा चाईदा। कुथी इयां ना हो की लोकां च रोला नी पेई जा।” ");
INSERT INTO bht_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","जालू सै बैतनिय्याह ग्रां च शमौन कोढ़ी दे घरे था, जिसयो यीशुऐ कोढ़े दिया बिमारिया ला खरा कितया था। सै ओथु रोटी खांणा बैठया था, तां इक जनानी उदे घरे जो आई कने उना इक बोतल लांदियो थी; जड़ी संगमरमर दी थी, उसा बोतला च जटामासी तेले ने बणाया बड़ा मेंहगा इत्र था, कने उना बोतला दा मुह तोड़ी करी सारा इत्र यीशुऐ दे सिरे पर नियोरी दिता। ");
INSERT INTO bht_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","पर केई लोक मने च बोलणा लग्गे, “इस मेंगे इत्रे जो सत्यानाश नी करणा चाईदा था। ");
INSERT INTO bht_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","क्योंकि ऐ इत्र इतणा मेहंगा था की, इस इत्र दी कीमत इक साले दिया मजदुरिया बराबर थी, कने इसयो बेचिकरी गरीबां जो बंडी सकदे थे।” कने सै उसा जो बुरी हाले झिड़कणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","यीशुऐ बोलया, “इसा जो किली छडी दिया, इसा जो तंग करणा बंद करा, इयां तां मिंजो पर इत्र पाणा खरी गल्ल है। ");
INSERT INTO bht_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","गरीब तां हमेशा तुहाड़े सोगी रेंदे न, कने तुसां उना ने जालू मर्जी खरा करी सकदे न, पर मैं तुहाड़े सोगी सदा नी रेंणा है। ");
INSERT INTO bht_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","इना जनानिया मेरे तांई खरा कम्म कितया है, ऐ जड़ा कुछ करी सकदी थी, सै इना किता, इना मेरे शरीरे पर इत्र मलया है, इना मिंजो मरणे ला पहले ही दफनाणे दी तैयारी किती है। ");
INSERT INTO bht_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","मैं तुसां ने सच्च बोलदा है, सारे संसार च जिथू भी शुभसमाचार दा प्रचार होंगा, इना जनानिया जड़ा कितया ओथु इसा दे इस कम्मे दी चर्चा भी उसा दिया यादा च किती जाणी है।” ");
INSERT INTO bht_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","तालू यहूदा इस्करियोती जड़ा बाहरां चेलयां चे इक था, सै यीशुऐ जो पकड़ाणे च सहायता करणे तांई बड्डे याजकां बाल गिया। ");
INSERT INTO bht_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","सै ऐ सुणीकरी खुश होए, कने उसयो पेसे देंणे जो मन्नी गे, कने सै यीशुऐ जो धोखे ने यहूदी अगुवां दे हथे पकड़ाणे दा तां मौका तोपा दे थे। ");
INSERT INTO bht_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","अखमीरी रोटिया दे त्योहारे दे पेहले दिने, जिस रोजे फसह दी बलि दिन्दे थे, उदे चेलयां उसयो पुछया, “तुसां सांझो कुथु भेजणा चांदे न की असां फसह दे त्योहारे दा खाणा बणाई करी खाई सकन?” ");
INSERT INTO bht_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","उनी अपणे दो चेलयां जो ऐ बोली करी भेजया, “की यरूशलेमे शेहरे जो जा, कने ओथु तुहांजो इक माणु घड़े चुकी करी चलया मिलणा, उदे पिच्छे चली जानयो। ");
INSERT INTO bht_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","कने सै जिस घरे जो जांगा, उस घरे दे मालिके जो बोलयो: की गुरू जी ने पूछया है, की मेरा कने मेरे चेलयां दा फसह दा खाणा खाने बाला कमरा कुथु है? ");
INSERT INTO bht_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","उनी तुहांजो इक उपरे आला सजया सजाया कने तैयार कितया बडा कमरा दसी देणा है, कने तुसां ओथु साड़े तांई तैयारी करा।” ");
INSERT INTO bht_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","दो चेले निकली करी नगरे च आये कने जियां यीशुऐ उना जो बोलया था, तियां ही था, कने उना फसह त्योहारे दा खाणा तैयार किता। ");
INSERT INTO bht_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","जालू संज होई, तां यीशु बारां चेलयां सोगी उदे घरे जो आया। ");
INSERT INTO bht_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","कने जालू सै रोटी खाणां बैठयो थे, तां यीशुऐ बोलया, “मैं तुसां ने सच्च बोलदा है, की तुहांजो चे इकी जणे, जड़ा मेरे सोगी रोटी खा दा है, मिंजो पकड़ावाणे तांई मेंरयां दुशमणा दी सहायता करणी है।” ");
INSERT INTO bht_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","जालू उदे बाद उना ऐ गल्ला सुणिया तां उना पर उदासी छाई गेई कने सै इक-इक करी के उसने बोलणा लग्गे, “क्या सै मैं है?” ");
INSERT INTO bht_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","यीशुऐ उना जो बोलया, “सै बाहरां चेलयां चे इक है, जड़ा मेरिया थालिया च डुबोई करी खा दा है। ");
INSERT INTO bht_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","क्योंकि मैं, माणुऐ दे पुत्रे मरी जाणा है, ऐ सब कुछ पबित्र शास्त्रां च लिखया है, पर उस माणुऐ जो बड़ी बुरी सजा होणी है, जड़ा मिंजो धोखा दिन्दा है जिनी मिंजो पकड़वाणे च सहायता करणी है, अगर उस माणुऐ दा जन्म ही नी होया होंदा तां ही उदे तांई खरा होंदा।” ");
INSERT INTO bht_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","जालू सै खा दे थे, तां यीशुऐ रोटी लेई, कने परमेश्वरे दा धन्यवाद करी के तोड़ी, कने अपणे चेलयां जो देईकरी बोलया, “खाई लिया, ऐ मेरा शरीर है।” ");
INSERT INTO bht_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","फिरी उनी दाखरस दे कटोरे जो चुकी करी परमेश्वरे दा धन्यबाद किता, कने चेलयां जो दिता, कने उना सारयां उस कटोरे च पीता। ");
INSERT INTO bht_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","कने यीशुऐ उना जो बोलया, “ऐ दाखरस मेरा खून है, मेरा खून केईयां लोकां दी भलाई तांई बहाया जाणा है, ऐ उसा बाचा जो साबित करगा, जड़ा परमेश्वरे अपणे लोकां सोगी कितया है। ");
INSERT INTO bht_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","मैं तुहांजो ने सच्च बोलदा है, मैं उसी दिने बाद कदी भी धाखा दा रस नी पींणा, जालू दीकर परमेश्वरे दे राज्य च नोआ दाखरस नी पी लेंगा।” ");
INSERT INTO bht_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","फिरी यीशुऐ कने उदे चेलयां फसह दे त्योहारे दे भजन गाई करी यरूशलेम शहरे दे बाहर जैतून रुखां दे पाहड़े पर चली गे। ");
INSERT INTO bht_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","तालू यीशु पहाड़े दे पासे चलया था उनी चेलयां जो बोलया, तुसां सारयां मिजों छडी करी नसी जाणा है, क्योंकि पबित्र शास्त्रे च लिखया है, सै सच्च होणा है: “मैं रखवाले जो मारणा कने भेडां तितर बितर होई जाणा है।” ");
INSERT INTO bht_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","पर मैं मरी के जिन्दा होणे ला बाद तुहांजो ला पेहले गलील प्रदेश च पूजणा है, कने तुहांजो ने मिलणा है। ");
INSERT INTO bht_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","पर पतरसे यीशुऐ जो बोलया, “चाहे सारे छडी करी नसी जांगे पर मैं नी नसगा।” ");
INSERT INTO bht_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","यीशुऐ उसयो बोलया, “मैं तिजो ने सच्च बोलदा है, की अज ही इसा राती मुर्गे जो दो बार बांग देणे ला पेहले तू मिंजो तीन बरी बोलणा है, की मिं‍जो नी जाणदा है।” ");
INSERT INTO bht_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","पर उनी होर भी जोर देईकरी बोलया, “अगर मिंजो तेरे सोगी मरणा भी पोंगा तमी मैं कदी नी बोलणा की मैं तिजो नी जाणदा।” इयां ही बाकी सारयां चेलयां भी बोलया। ");
INSERT INTO bht_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","फिरी जालू यीशु कने उदे अनुयायी गतसमनी नाए दे इक बागे च आये, कने उनी अपणे चेलयां जो बोलया, “ऐथू बेई रिया, जालू दीकर मैं प्राथना करें। ");
INSERT INTO bht_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","कने यीशु पतरस, याकूब कने यूहन्ना जो बागे च थोड़ा दिया अग्गे लेई गिया, कने सै बड़ा ही दुखी कने बेचेन होणा लग्गा, ");
INSERT INTO bht_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","कने उना ने बोलया, ‘मेरा मन बड़ा उदास है, ऐथू दीकर कि मेरे प्राण निकली चलयो न, तुसां ऐथू रुका कने जागदे रिया।’” ");
INSERT INTO bht_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","फिरी यीशु थोड़ा अग्गे गिया, कने गोडे भार बेई गिया कने मुह धरतिया पास्से करी प्राथना करणा लग्गा, “की अगर होई सके तां ऐ घड़ी मिंजो ला टली जा।” ");
INSERT INTO bht_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","कने बोलया, “पिता जी, तिजो ला सब कुछ होई सकदा है, ऐ जड़ा दुख ओणे बाला है, ऐ टली जाये पर जियां तुसां चांदे न तियां ही होऐ।” ");
INSERT INTO bht_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","फिरी जालू यीशु बापस आया कने तिन्न चेलयां जो सुतया दिखीकरी उनी पतरसे जो बोलया, “हे शमौन, तू सुतया है? तुसां इक घंटा भी मेरे सोगी जागदे नी रेई सके? ");
INSERT INTO bht_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","जागदे कने प्राथना करदे रिया ताकि मिजों पर भरोसा रखणा नी छडन। आत्मा तां खरा करणा चांहदी है पर शरीरे च जोरे दी कमी है।” ");
INSERT INTO bht_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","कने यीशु फिरी बापिस चली गिया, कने सै ही बोली करी प्राथना किती। ");
INSERT INTO bht_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","कने उनी फिरी आई करी उना जो सुतया दिखया, क्योंकि से जागते रेईकरी बड़े थकी गियो थे, जालू यीशुऐ उना जो जगाया कने उना जो नी पता था की उसयो क्या बोलन। ");
INSERT INTO bht_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","फिरी तीजी बरी आई करी उना जो बोलया, “हुण सोंदे रिया कने अराम करा, तुसां बड़ा सोई लिया हुण से बकत आई गिया है, जालू मैं, माणुऐ दा पुत्र पापियां दे हथे पकड़ाया जाणा है। ");
INSERT INTO bht_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","उठा कने चला। दिखा, जिनी माणुऐ मिजों पकड़वाणा है, सै बखे आई रिया है।” ");
INSERT INTO bht_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","जालू यीशु ऐ बोला दा ही था, तां यहूदा जड़ा बाहरां चेलयां चे इक था, सै ओथु आया, सै अपणे सोगी मते सारे लोकां जो लेईकरी आया जिना तलवारां कने डंडे लियो थे, ऐ सारे लोक बड्डे याजकां, यहूदी व्यवस्था जो सिखाणे बाले कने यहूदी अगुवां भेजयो थे। ");
INSERT INTO bht_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","कने यीशुऐ जो पकड़ाणे बाले यहूदा उना दी सहायता किती, कने उना जो पेहले ही दस्सी दितया था, की जिसयो मैं गुरू बोलगा कने गले लाईकरी चुम्मी लेंगा, तां उसयो पकड़ी करी ढंगे ने लेई जानयो। ");
INSERT INTO bht_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","कने युहदा आया कने उनी झट यीशु दे बखे जाई करी बोलया, “गुरू जी।” कने गले लाईकरी उदी चुम्मी लेई। ");
INSERT INTO bht_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","तालू उना उसयो कस्सी करी पकड़ी लिया कने बन्दी बणाई लिया। ");
INSERT INTO bht_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","जड़े उदे बखे खड़ोतयो थे, उना चे इकी जणे अपणी तलवार कडी कने महायाजके दे नोकरे पर चलाई दिती कने उदा इक कन बडी दिता। ");
INSERT INTO bht_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","यीशुऐ उना जो बोलया, “तुसां क्या मिंजो डाकू समझीकरी तलवारां कने डांगा लेईकरी बन्दी बणाने तांई आयो? ");
INSERT INTO bht_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","मैं तां रोज ही मंदरे च तुहाड़े सोगी रेईकरी उपदेश दिन्दा था, तालू तां तुसां मिंजो बन्दी नी बणाया पर ऐ इस तांई होया की पबित्र शास्त्रां च लिखया पुरा होऐ।” ");
INSERT INTO bht_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","जालू ऐ होया तां उदे सारे चेले उसयो छडी करी नसी गे। ");
INSERT INTO bht_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","इक जवान अपणे नंगे शरीरे पर चादर ओडी करी उदे पिच्छे चली पिया; कने लोक उसयो यीशुऐ दा चेला समझीकरी पकड़ना लग्गा। ");
INSERT INTO bht_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","पर सै चादरा छडी करी नंगा ही नठी गिया। ");
INSERT INTO bht_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","फिरी सै यीशुऐ जो महायाजके दे घरे बाल लेई आये; कने सारे बड्डे याजक, कने यहूदी अगुवे कने व्यवस्था जो सिखाणे बाले ओथु गिठे होई गे। ");
INSERT INTO bht_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पतरस भी उना दे पिच्छे-पिच्छे महायाजके दे अंगणे च जाई रिया, कने मंदरे दे सिपाईयां सोगी बेईकरी अग्ग तपणा लगी पिया। ");
INSERT INTO bht_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","बड्डे याजक कने यहूदी महासभा दे सदस्य यीशुऐ जो मारी देंणे तांई उदे खिलाफ च गबाई तोपा दे थे, पर उना जो कोई गबाई नी मिली। ");
INSERT INTO bht_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","क्योंकि मते लोक उदे खिलाफ च झुठियां गबाईयां दिन्दे थे, पर उना दियां गबाईयां इक दियां नी थियां। ");
INSERT INTO bht_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","तां कितणयां ही लोकां उठी करी उदे खिलाफ ऐ झूठी गबाई दिती। ");
INSERT INTO bht_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“असां इसयो ऐ बोलदे सुणया है, की मैं माणुऐ दे बणायो मंदिर जो डाई करी तिन्ना रोजां च नोआ मंदिर बणाई लेणा, जड़ा हथा ने नी बणया होणा है।” ");
INSERT INTO bht_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ऐ गबाई भी उना दी इक देई नी निकली। ");
INSERT INTO bht_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","तालू महायाजके बिच खड़ोई करी यीशुऐ ला पुछया, तू कोई जबाब कनी दिन्दा? ऐ लोक तेरे खिलाफ क्या गबाई दिन्दे न? ");
INSERT INTO bht_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","पर सै चुप ही रिया, कने उनी कोई जबाब नी दिता: महायाजके उसयो फिरी पूछया, “क्या तु उस परमधन्य परमेश्वरे दा पुत्र मसीह है, जिदी असां अराधना करदे न?” ");
INSERT INTO bht_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","यीशुऐ बोलया, “हां मैं है: कने तुसां मिंजो माणुऐ दे पुत्रे जो सबते शक्तिशाली परमेश्वर दे सजे पासे हके कने बैठयो दिखणा, कने अम्बरे च बदलां सोगी ओंदे दिखणा है।” ");
INSERT INTO bht_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","जालू महायाजके यीशुऐ जो ऐ बोलदे सुणया तां उनी गुस्से च अपणे कपड़े फाड़ी दिते, कने बोलया, “हुण सांझो कुसी गबाह दी जरूरत नी है। ");
INSERT INTO bht_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","तुसां इसयो परमेश्वरे दी निंदा करदे सुणया, तुहाड़ी क्या सलाह है इसा गल्ला पर?” उना सारायां फेसला किता की यीशुऐ परमेश्वर दी निन्दा कितियो, इस तांई इसयो मौत दी सजा मिल्ले। ");
INSERT INTO bht_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","तालू कोई तां उस पर थुकणा लग्गे, कने कोई उदा मु ढकणा कने मूके मारणा, कने मजाक उड़ाई करी बोलणा लग्गे, “गुरू जी, अगर तु परमेश्वरे दा संदेश देणेबाला है, तां सांझो दस कुनी तिजो मारया, कने सिपाईयां उसयो पकड़ी करी थप्पड़ मारे।” ");
INSERT INTO bht_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","जालू पतरस थल्ले अंगणे च अग्गी सेका दा था, तां महायाजक दिया नोकराणियां चे इक ओथु आई, ");
INSERT INTO bht_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","कने उना पतरसे जो अग्ग तपदे दिखया कने उसयो ध्याने ने दिखीकरी बोलणा लग्गी, “तू भी तां इस यीशु नासरत बाले दा सोगी था।” ");
INSERT INTO bht_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","सै मुकरी गिया, कने बोलणा लग्गा, मैं नी जाणदा इसयो कने मिंजो नी पता की तू क्या बोला दी है। फिरी सै बारले पासे चली गिया, कने मुर्गे बांग देई दिती। ");
INSERT INTO bht_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","सै नोकराणी बखे खड़ोतयो बंदयां ने फिरी बोलणा लग्गी, की ऐ उदे चेलयां चे इक है। ");
INSERT INTO bht_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","पर सै फिरी मुकरी गिया। कने थोड़िया देरा बाद उना जड़े बखे खड़ोतया थे, उना पतरसे जो बोलया, “पक्का तू उना चे ही इक है, जियां तु बोलदा है इसला लगदा तु भी गलील प्रदेश ला है, तु उदे चेलयां चे इक है।” ");
INSERT INTO bht_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","पतरस अपु जो कोसणा लग्गा, कसम खाणा लग्गा, की जिस माणुऐ दी तुसां गल्ल करा दे न उसयो मैं नी जाणदा। ");
INSERT INTO bht_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","तां तालू मुर्गे दुज्जी बरी बांग दिती: तालू पतरसे जो यीशुऐ दी गल्ल याद आई जड़ी उसयो बोलियो थी, “की मुर्गे जो दो बार बांग देंणे ला पेहले तू मिंजो तिन्न बरी मुकरणा है।” तालू पतरस अपणे दुखे जो नी संभाली पाया कने दुखी होईकरी जोर-जोर ने रोणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","कने ब्यागा तड़के होंदे ही झट उना बड्डे याजकां, कने यहूदी अगुवां, कने व्यवस्था जो सिखाणे बालयां कने महासभा दे सारे लोकां सलाह करिके के यीशुऐ जो बन्नया, कने न्याय करणे तांई यहूदिया प्रदेश दे राज्यपाल पिलातुस दे हबाले करी दिता। ");
INSERT INTO bht_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","कने पिलातुसे उसयो पुछया, “क्या तू यहूदियां दा राजा है?” यीशुऐ उसयो जबाब दिता, “जड़ा तू बोला दा है, ऐ सही है।” ");
INSERT INTO bht_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","कने बड्डे याजक उस पर बड़ियां गल्लां दा दोष ला दे थे। ");
INSERT INTO bht_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पिलातुसे उसयो फिरी पुछया, “तू क्या कोई जबाब नी देणा है, दिख ऐ तिजो पर कितणियां गल्लां दा दोष ला दे न?” ");
INSERT INTO bht_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","यीशु फिरी चुप रिया कने कोई जबाब नी दिता, ऐ दिखीकरी पिलातुस बड़ा हेरान होया। ");
INSERT INTO bht_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","हर साले फसह दे त्योहारे च, पिलातुस इक केदिये जो छडी दिन्दा था, जिसयो लोक चांदे थे की सै छूटे। ");
INSERT INTO bht_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","कने बरअब्बा नाऐ दा इक माणु बाकी क्रंतिकारियां सोगी कैदा च था, जिना रोम सरकार दे खिलाफ च लोकां दी हत्या कितियो थी। ");
INSERT INTO bht_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","कने भीड़ पीतालुस दे बखे आई कने उसने बिनती करणा लग्गी, कने साड़े तांई इक कैदी जो छडी दे जियां तू हरबरी करदा है। ");
INSERT INTO bht_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पिलातुसे उना जो जबाब दिता, क्या तुसां चांदे न की, मैं तुहाड़े तांई यहूदियां दे राजे जो छडी दें? ");
INSERT INTO bht_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","क्योंकि सै जाणदा था, की बड्डे याजकां यीशुऐ जो जलनिया ने पकड़ाया था। ");
INSERT INTO bht_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","पर बड्डे याजकां लोकां दिया भिड़ा जो भड़काया, कि पिलातुस ला यीशु जो छडणे दी बजाये बरअब्बा जो छडणे दी माँग करा। ");
INSERT INTO bht_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ऐ सुणीकरी पिलातुसे उना ला फिरी पुछया, “तां जिसयो तुसां यहूदियां दा राजा बोलदे न, उदा मैं क्या करे?” ");
INSERT INTO bht_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","भीड़ा दे लोक चिलाणा लग्गे, “उसयो सूली पर चड़ाई करी मारी दिया।” ");
INSERT INTO bht_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलातुसे उना जो बोलया, “कजो इनी क्या बुरा कितया है?” पर भीड़ होर भी जोरे ने चिलाणा लग्गी की, “इसयो सूली पर चढ़ाई करी मारी दिया।” ");
INSERT INTO bht_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","तालू पिलातुसे भिड़ा जो खुश करणे तांई बरअब्बा जो उना तांई छडी दिता, कने यीशुऐ जो कोड़े लगबाई करी सूली पर चढ़ाणे तांई रोमी सिपाईयां दे हबाले देई दिता। ");
INSERT INTO bht_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","सिपाई उसयो किले दे अंदरे बाले अंगणे च लेई गे जिसयो प्रीटोरियुम बोलदे न, कने सारिया सिपाईयां दिया पलटना जो सदी लेई आये। ");
INSERT INTO bht_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","कने यीशुऐ दा मजाक उड़ाणे तांई उना उसयो बैंगणी रंगे दे कपड़े पेहनाये, कने कंडयां दा मुकट बणाई करी उदे सिरे पर रखया, ");
INSERT INTO bht_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","कने सै यीशुऐ दा मजाक उड़ाणे तांई उसयो ऐ बोलदे थे की, “हे यहूदियां दे राजा, नमस्ते।” ");
INSERT INTO bht_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","सै बार-बार उदे सिरे पर भारी सरकंडे ने मारदे थे, कने उदी बेजती करणे तांई उस पर थुका दे थे, कने उसयो इज्जत मान देणे तांईं अराधना करणे जो गोडे भार बेईकरी उसयो नमस्ते करणे दा नाटक करा दे थे। ");
INSERT INTO bht_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","जालू सै उदा मजाक उड़ाई बैठे, तां उना सै बैंगणी कपड़े उतारी करी उदे अपणे कपड़े उसयो पेहनाऐ, फिरी उसयो सूली पर चढ़ाणे तांई शेहरे ला बाहर लेई गे। ");
INSERT INTO bht_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","जालू सै शेहरे बाहर चलयो थे, तां शमौन नाऐ दा माणु कुरेनी ग्रांऐ ला ओआ दा था, उदे पुत्र सिकन्दर कने रुफुस थे। कने सिपाईयां शमोन जो हुकम दितया की सै सूली जो चुकी करी उसा जगा लेई जा जिथू उना यीशुऐ जो सूली पर चढ़ाणा था। ");
INSERT INTO bht_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","सिपाई यीशुऐ जो गुलगुता नाए दिया जगा पर लेई आये, जिदा मतलब है खोपड़ी दी जगा। ");
INSERT INTO bht_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","तालू सिपाईयां यीशुऐ जो गन्धरस नाऐ दी दवा, दाखरस च मिलाई करी पीणे तांई यीशुऐ जो दिता ताकि उसयो पीड़ा दा असर नी होऐ, पर उनी पिणे जो मना करी दिता। ");
INSERT INTO bht_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","फिरी उना यीशुऐ जो हथां पैरां पर किल्लां ठोकी करी सूली पर चढ़ाया, कने उदे कपड़यां तांई पर्चियां पाईयां, ऐ दिखणे तांई की क्या कुसयो मिलदा है, कने कपड़यां जो अपु चे बंडी लिया। ");
INSERT INTO bht_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ब्यागा दे कोई नौ की बजे, जालू उना यीशुऐ जो सूली पर चढ़ाया। ");
INSERT INTO bht_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","सिपाईयां यीशुऐ दिया सूलिया उपर लकड़ी दी पट्टी लाई दिती। उदे च यीशुऐ दा दोष लिखया था, की ऐ “यहूदियां दा राजा।” ");
INSERT INTO bht_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","उना उदे सोगी दो डाकू, इक उदे सजे पासे कने इक उदे खबे पासे सूली पर चढ़ाये। ");
INSERT INTO bht_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","तालू सै पबित्र शास्त्रे दा बचन सच्च होई गिया जड़ा मसीह दे बारे च बोलया था, की सै अपराधियां सांई गिणया जाणा, कने सै पुरा होया। ");
INSERT INTO bht_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","कने रस्ते च जाणे बाले सारे लोक सिर हिलाई-हिलाई करी, उदी ऐ बोली करी निंदा करदे थे, “वाह रे। मंदरे जो ढाणे बाले, कने तिन्ना रोजां च बणाणे बाले। ");
INSERT INTO bht_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","सूली ला उतरी करी अपणे आपे जो बचाई ले।” ");
INSERT INTO bht_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","इयां ही बड्डे याजक कने मूसा दी व्यवस्था जो सिखाणे बाले अपु चे मजाके च बोलदे थे, “की इनी होरनी जो बचाया, पर अपणे आपे जो नी बचाई सकदा। ");
INSERT INTO bht_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ऐ माणु जड़ा इस्राएल दा राजा, मसीह होणे दा दाबा करदा है, हुण सूली ला उतरी आऐ तां, असां दिखीकरी भरोसा करी लेणा कि ऐ साड़ा राजा है।” कने जड़े उदे सोगी दो जणे सूलिया पर चढ़ायो थे, सै भी उदी निंदा करा दे थे। ");
INSERT INTO bht_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","दोपहर बाहरा बजे ला तिन्न बजे दीकर सारे देशे च नेहेरा होई गिया। ");
INSERT INTO bht_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","दोपेरा दे तिजे पेहर यीशुऐ बड़े जोरे ने पुकारी करी बोलया, “इलोई, इलोई, लमा शबक्तनी?” जिसदा मतलब है, “मेरे परमेश्वर, मेरे परमेश्वर, तू मिंजो कजो छडी दिता?” ");
INSERT INTO bht_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","कने कुछ लोक जड़े उदे बखे खड़ोतयो थे, उना सुणया जड़ा यीशुऐ बोलया पर सै समझे नी कने बोलणा लग्गे, “दिखा, ऐ एलिय्याह जो सहायता तांई पुकारा दा है।” ");
INSERT INTO bht_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","कने उना लोकां च इक जणा दौड़ी करी गिया कने उनी स्पंज लेईकरी सिरके च डुबाया, कने सरकंडे दे उपर बन्नी करी यीशुऐ जो चुसाया, कने बोलया, “रुकी जा कुछ मत करा, दिखदे न की, एलिय्याह इसयो उतारणे तांई ओंदा है की नी।” ");
INSERT INTO bht_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","तालू यीशु बड़े जोरे ने बोली करी मरी गया। ");
INSERT INTO bht_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","कने सै मोटा परदा जड़ा मंदरे च टंगया होया था, जड़ा सारयां जो परमेश्वर दी मोजुदगी च अंदर ओणे जो रोकदा था, उपरे ला थले दीकर फटी गिया कने उदे दो टुकड़े होई गे। ");
INSERT INTO bht_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","जड़ा सूबेदार उदे सामणे खड़ोतया था, उनी जालू यीशुऐ दी पुकार सुणी कने उसयो दिखया की सै कियां मरया, तां उनी बोलया, “सच्ची ऐ माणु, परमेश्वरे दा पुत्र था।” ");
INSERT INTO bht_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","कने केई जनानिया भी दुरे ला दिखा दियां थियां: उना चे इक मरियम भी थी जड़ी मगदल नाऐ दे शेहरे ला थी, सलोमी कने मरियम जड़े छोटा याकूब कने योसेस दी मां थी। ");
INSERT INTO bht_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","जालू सै गलील प्रदेशे च था तां सै उदे पिच्छे चलदियां थियां, कने उदी सेबा करदियां थियां, कने होर भी मतियां जनानिया थियां, जड़ियां उदे सोगी यरूशलेम शेहर च आईयां थियां कने सै उसयो दुरे ला दिखा दियां थियां। ");
INSERT INTO bht_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","जालू संज होई गेई, तां इस तांई की सै तैयारिया दा दिन था, जड़ा सब्ते दे इक रोज पेहले होंदा है। ");
INSERT INTO bht_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","अरिमतिया शेहरे दा रेहणे बाला यूसुफ नाऐ दा इक माणु था, सै यहूदी सभा दा इक बड़ा मनया तनया मंत्री था, कने अपु भी परमेश्वरे दे राज्य दी नियाल रखदा था। सै हिम्मत करिके पिलातुस बाल गिया कने उनी यीशुऐ दी लाश दफनाणे तांई मंगी। ");
INSERT INTO bht_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","पिलातुस जो भरोसा नी होया, की यीशु इतणी तोल्ली मरी गिया, कने उनी सुबेदारे जो सदीकरी पूछया, की क्या ऐ सच्च है, की यीशुऐ मरयो बड़ी देर होई गियो है? ");
INSERT INTO bht_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","जालू उनी सुबेदारे ला हाल पता करी लिया, तां पिलातुसे यूसुफे जो लाश लेई जाणे दी अनुमति देई दिती। ");
INSERT INTO bht_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","तालू उनी इक मलमल दी चादर खरीदी, कने लाश उतारी करी यहूदी रिबाजां सांई मलमल दिया चादरा च लपेटी लिया, कने दफनाणे तांई कबरां च रखया कने सै कबर चट्टाना जो कटी करी बणाईयो थी, कने उनी कबरां दा मु बंद करणे तांई इक गोल पथर लुड़काई करी रखी दिता। ");
INSERT INTO bht_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम जड़ी मगदलीनी शेहरे ला थी कने योसेस दी मां मरियम दिखा दियां थियां की, सै कुथु रखया है। ");
INSERT INTO bht_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","अगली संझा जालू सब्ते दे दा रोज होई गिया, तां उना जनानियां जिना दे नां मरियम मगदलीनी, याकूबे दी मां मरियम, सलोमी उना सुगंध बालियां चिंजा खरीदियां, ताकि यीशुऐ दिया लाशा पर मलन, क्योंकि ऐ सारा यहूदियां दा रिती रिबाजा था। ");
INSERT INTO bht_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ब्यागा तड़के तुआरे बाले दिने, सै कबरां पर गियां, ");
INSERT INTO bht_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","कने अपु चे बोला दियां थियां की, “साड़े तांई कबरां दे रखयो बडे कने भारी पथरे जो कुण हटांगा?” ");
INSERT INTO bht_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","पर जालू उना यीशुऐ दी कबरा पासे दिखया, तां दिखया की सै पथर तां पेहले ला ही हटया होया है। ");
INSERT INTO bht_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","कने जालू सै कबरा दे बखे पुजियां कने अंदर गियां, उना ओथु इक नौजवान जागते जो चिट्टे चमकदार कपड़े पाई करी उदे सजे पासे बैठया दिखया, कने सै बड़ियां हेरान होईयां कने डरी गियां। ");
INSERT INTO bht_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","उनी जवान माणुऐ उना जनानियां जो बोलया, डरा मत, तुसां यीशु नासरत बाले जो तोपा दियां न, जिसयो सूली पर चढ़ाया था। सै जिन्दा होई गिया है, ऐथू नी है; दिखा ऐ सेई जगा है, जिथू उना उसयो रखया था। ");
INSERT INTO bht_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","पर हुण तुसां जा, कने ऐ गल्ल तुसां पतरस कने यीशुऐ दे बाकी चेलयां जो बोला की यीशुऐ तुहांजो ला पेहले गलील प्रदेशे जो जाणा है, जियां उनी तुहांजो ने बोलया था, तुसां उसयो ओथु दिखणा है। ");
INSERT INTO bht_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","जालू उना ऐ सुणया, तालू सै कबरां ला निकली करी नठी गियां क्योंकि सै घबराई करी कमी पियाँ थियां। कने उना रस्ते च कुसी होरसी ने कुछ नी बोलया। ");
INSERT INTO bht_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","हफ्ते दे पेहले तुआरे ब्याग होंदे ही सै जिन्दा होईकरी सबना ला पेहले यीशु मरियम मगदलीनी जो मिल्ला, जिसा चे उनी सत बुरियां आत्मा कडियां थियां। ");
INSERT INTO bht_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","सै यीशु दे चेलयां बाली गेई, चेले बड़े भरी गमे च थे कने रोआ दे थे, उना जड़ा कुछ उना दिखया था, सै उना जो सुणाया। ");
INSERT INTO bht_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","पर जालू उना उसा ला सुणया की यीशु जिन्दा है, कने उना उसयो दिखया है, उना भरोसा नी किता। ");
INSERT INTO bht_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","उदे बाद यीशु दुज्जे दो होर चेलयां सामणे आया, जड़े यरूशलेमे शेहरे ला अपणे घरे जो ओआ दे थे, पर पेहले उना उसयो नी पछाणा, क्योंकि उदी भेस भुशा पेहले ला लग थी। ");
INSERT INTO bht_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","जालू उना जाणी लिया सै कुण है, तालू सै दौड़ी करी दुज्जयां जो दसणा गे, पर उना भी भरोसा नी किता। ");
INSERT INTO bht_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","इदे बाद यीशु उना गयारां चेलयां जो भी मिल्ला, जालू सै रोटी खाणां बैठयो थे, तां यीशुऐ उना जो झिड़कया, क्योंकि यीशुऐ जो जिन्दा होणे बाद दिखया, फिरी भी उना भरोसा नी कितया था। ");
INSERT INTO bht_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","कने यीशुऐ उना जो बोलया, “तुसां सारे संसार च जाई करी लोकां जो परमेश्वर दे शुभसमाचार दा प्रचार करा। ");
INSERT INTO bht_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","जड़ा कोई मिजों पर भरोसा करगा कने बपतिस्मा लेंगा परमेश्वरे उसयो उदे पापां दी सजा ला बचाणा, पर जड़ा मिंजो पर भरोसा नी करगा तां उसयो सजा मिलणी है। ");
INSERT INTO bht_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","कने जड़े लोक मिजों पर भरोसा करगे सै चमत्कारी निशाण उना दे बाली होणे न, उना मेरे नाए ने बुरियां आत्मा जो कडणा, कने मैं उना जो नोईयां-नोईयां भाषा बोलणे दे काबील बणागां। ");
INSERT INTO bht_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","मैं उना जो बचाणा है, जड़े सप्पां जो भी चुकी लेंगे, कने जहरीली चीज भी पी लेंगे, मैं तमी उना जो मरणा नी दिगां, उना बिमारां पर हथ रखणा कने उना जो मेरे नाऐ ला खरा करणा है।” ");
INSERT INTO bht_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","तालू उदे बाद प्रभु यीशु उना ने गल्लां करणे बाद परमेश्वरे यीशुऐ जो स्वर्गे च सदी लिया, कने यीशु परमेश्वरे दे सजे पासे इज्जत बाले सिहांसन पर बैठी गिया। ");
INSERT INTO bht_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","तालू चेले सारयां पास्से गे कने हर जगा परमेश्वरे दा प्रचार किता, कने प्रभु उना सोगी कम्म करदा रिया, कने उना चमत्कारां दे जरिये जड़े सोगी-सोगी होंदे थे, बचना जो पुरा करदा रिया। आमीन।");
INSERT INTO bht_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","श्रीमान थियुफिलुस तांई मतयां लोकां साड़े बिच होइयां घटना दे बारे च इक दस्ताबेज लिखणे दी कोशिश कितियो है। ");
INSERT INTO bht_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","उना बिलकुल सेई लिखया जड़ा सान्झो उना लोकां दसया था, जिना शुरू ला ही यीशुऐ दी सेबकाई जो अपणी हखी ने दिखया था कने जड़े बादे च परमेश्वरे दे बचने दे सेवक बणे। ");
INSERT INTO bht_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","इस तांई श्रीमान थियुफिलुस मैं भी इना सारियां गल्लां दी जांच परख किती कने मिंजो ऐ ठीक लग्गा की तुहाड़े तांई इना घटना जो क्रमानुसार लिखें। ");
INSERT INTO bht_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","मैं ऐ इस तांई करा दा ताकि तुहांजो हर उसा गल्ला दा पता पुरिया सचाइया ने लग्गे जड़ियां लोकां तुहांजो दसियां न। ");
INSERT INTO bht_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","जालू हेरोदेस यहूदिया प्रदेश दा राजा था, अबिय्याह दी टोलिया च जकर्याह नाऐ दा इक याजक था, कने उदी घरे बालिया दा ना एलीशिबा था कने सै भी इस्राएल दे पेहले याजक हारून दे बंशे ला थी। ");
INSERT INTO bht_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","सै दोयो ही परमेश्वरे दे सामणे धर्मी थे, कने सै प्रभु दे सारे हुकम कने नियम पर सच्चे चलणे बाले थे। ");
INSERT INTO bht_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","पर उना दी कोई ओलाद नी थी, क्योंकि एलीशिबा बच्चा पैदा नी करी सकदी थी, कने सै दोयो ही बुड्डे थे। ");
INSERT INTO bht_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","इक दिन जालू जकर्याह यरूशलेम शेहरे दे मंदरे च परमेश्वरे दे सामणे याजके दे रुपे च सेबा करा दा था, क्योंकि उस हफ्ते उदिया टोलिया दी याजक सेबा दी बारी थी। ");
INSERT INTO bht_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","याजकां दे पर्ची पाणे बाले रिबाजे दे हिसावे ने जकर्याह दे नाऐ दी पर्ची निकली की प्रभु दे मंदरे च जाई करी धूप बाल्ले। ");
INSERT INTO bht_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","जालू सै धूप लगाणे दे बेले सारे लोक बाहर अंगणे च खड़ोई करी प्राथना करा दे थे। ");
INSERT INTO bht_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","तालू जकर्याह जो प्रभु दा स्वर्गदूत धुपे दिया बेदिया दे सजे पासे खड़ोतया दुसा। ");
INSERT INTO bht_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","कने जकर्याह उसयो दिखीकरी घबराई गिया कने सै बड़ा भरी डरी गिया। ");
INSERT INTO bht_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","पर स्वर्गदूते उसयो बोलया, “ओ जकर्याह डर मत क्योंकि परमेश्वरे तेरी प्राथना सुणी लिइयो है, तेरिया घरे बालिया एलीशिबा इक जागत जमणा है, कने तू उदा ना यूहन्ना रखयां। ");
INSERT INTO bht_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","कने तिजो खुशी होणी: कने मते लोकां उदे पैदा होंणे दिया बजा ने खुश होणा। ");
INSERT INTO bht_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","क्योंकि उनी परमेश्वरे दे सामने बड़ा महान होणा; कने उनी कदी भी कोई ऐसी चीज नी खाणी पिणी जिसने कोई नशा होंदा है; कने उनी अपणे पैदा होणे ला पेहले ही पबित्र आत्मा ने परिपूर्ण होई जाणा है। ");
INSERT INTO bht_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","कने उनी इस्राएलियां च मतयां लोकां जो उना दे प्रभु परमेश्वरे दे बाल बापस लोणा है। ");
INSERT INTO bht_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","यूहन्ना इक ऐसा माणु होणा है उनी परमेश्वरे दा संदेश देणेबाले एलिय्याह सांई आत्मा च शक्तिया ने भरपूर होणा है कने प्रभु दा रस्ता तैयार करणा है। ताकि माता पिता दा मन बाल बचयां दे पासे फेरी दे, कने हुकम नी मनणे बालयां जो धर्मियां सांई जीणा सिखाणा; कने प्रभु तांई इक खरी प्रजा तैयार करे। ");
INSERT INTO bht_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","जकर्याह स्वर्गदूते ला पुछया, ऐ मैं कियां यकीन करे की साड़े ने ऐसा होणा? क्योंकि मैं तां बुड्डा है, कने मेरी घरे बाली भी बुड्डी होई गियो है।” ");
INSERT INTO bht_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","स्वर्गदूते उसयो जबाब दिता, “मैं जिब्राईल है, जड़ा परमेश्वरे दे सामने खड़ोई रेंदा है, कने मिंजो तेरे ने गल्लां करणा कने तिजो ऐ शुभसमाचार सुणाणें तांई भेजया है। ");
INSERT INTO bht_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","कने दिख जीस दिने दीकर ऐ बच्चा पैदा नी होंगा कने मेरियां बोलियां गल्लां सही बकत पर पुरियां नी होंगिया उसी रोजे दीकर तिजो ला बोली नी होंणा, क्योंकि जड़ियां गल्लां मैं तिजो बोलियां न तू उना गल्लां दा भरोसा नी किता।” ");
INSERT INTO bht_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","लोक जकर्याह जो निय्याला दे थे क्योंकि याजक मंदरे च धुप लगाणे बाद बाहर आई करी लोकां जो आशीर्वाद दिन्दा था, पर उसयो बड़ी देर होई गेई थी अंदर, तां लोक बड़े हेरान होऐ? ");
INSERT INTO bht_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","जालू सै मंदरे ला बाहर आया, तालू सै उना ने बोली नी सकया, तालू सै समजी गे, की इसयो मंदरे च कोई दर्शण होया है, कने सै उना ने इशारे च गल्लां करा दा था, सै गूंगा होई गिया। ");
INSERT INTO bht_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","जालू मंदरे च उदिया याजक सेबा दे दिन पूरे होई गे, तां सै यरूशलेम शेहरे ला अपणे घरे जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","कुछ दिना बाद उदी घरे बाली एलीशिबा लेरथी होई; कने पंज महीने दीकर अपणे आपे जो लोकां ला लुकाई रखया। ");
INSERT INTO bht_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","की प्रभुऐ मेरे तांई भला कम्म किता है, माणुआं च मेरिया बांजपन दिया बदनामिया जो दुर करणे तांई इना दिना च प्रभुऐ मेरे उपर कृपा करिके मिंजो तांई ऐसा किता है। ");
INSERT INTO bht_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","जालू एलीशिबा जो छेमा मिना लगया था तालू परमेश्वरे दिया तरफा ला जिब्राईल स्वर्गदूत गलील प्रदेश दे नासरत शेहरे च इक कुवारिया बाल गिया, ");
INSERT INTO bht_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","जिसा दी मंगणी राजा दाऊदे दे बंशे दे यूसुफ नाऐ दे इक मरदे ने होईयो थी; उसा कुवारिया दा ना मरियम था। ");
INSERT INTO bht_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","कने स्वर्गदूते अन्दर आई करी उसा जो बोलया, “खुशी कने तेरी जय हो, परमेश्वरे तिजो पर कृपा किती है! परमेश्वर तेरे सोगी है।” ");
INSERT INTO bht_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","सै इस बचने ला बड़ी घबराई गेई, कने सोचणा लग्गी की इसा गल्ला दा क्या मतलब है? ");
INSERT INTO bht_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","स्वर्गदूते उसा जो बोलया, “हे मरियम, डर मत, क्योंकि तिजो पर परमेश्वरे दी कृपा होईयो है। ");
INSERT INTO bht_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","कने दीख, तू लेर्थिया होणा है, कने तिजो इक जागत पैदा होणा है; कने तू उदा ना यीशु रखयां। ");
INSERT INTO bht_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","कने उनी बड़ा महान होणा; कने उसयो परमेश्वरे दा पुत्र बोलया जाणा; कने प्रभु परमेश्वरे उसयो उदे पूर्वज दाऊदे सांई राजा बणाना है। ");
INSERT INTO bht_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","कने उनी इस्राएल दे लोकां पर हमेशा राज करणा; कने उदे राज्य दा कदी अंत नी होणा।” ");
INSERT INTO bht_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरियमा स्वर्गदूते जो बोलया, ऐ कियां होणा? मेरा तां अजे बियाह भी नी होया है। ");
INSERT INTO bht_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","स्वर्गदूते उसा जो जबाब दिता, पबित्र आत्मा तिजो पर उतरणा है, कने परमेश्वरे दिया शक्तिया तिजो पर छां करणी है, तांई तां तेरा जन्म लेणे बाला जागत पबित्र होणा है, सै परमेश्वरे दा पुत्र बोलया जाणा। ");
INSERT INTO bht_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","कने सुण तेरी रिशतेदार एलीशिबा दे भी बुडे बारे बच्चा होणेबाला है, ऐ इसा दा छेमा महिना है जिसा जो लोक बांज बोलदे थे। ");
INSERT INTO bht_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","क्योंकि परमेश्वर सब कुछ करी सकदा है। ");
INSERT INTO bht_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियमा बोलया, “दीख, मैं प्रभु दी दासी है, जियां तू बोलया है सेई मेरे सोगी हो।” तालू स्वर्गदूत ओथु ला चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","कुछ दिना बाद मरियम उठी करी यहूदिया प्रदेश दे इक पाहड़ी इलाके दे इकी ग्रां जो गेई। ");
INSERT INTO bht_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","कने जकर्याह दे घरे पुजिकरी एलीशिबा जो नमस्ते किते। ");
INSERT INTO bht_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","जियां ही एलीशिबा मरियमा दे नमस्ते सुणे, तियां ही बच्चा उसा दे पेटे च उछली पिया, कने इलीशिबा पबित्र आत्मा ने परिपूर्ण होई गेई। ");
INSERT INTO bht_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","कने तिन्ना बड़े जोरे ने बोलया, “तू सारियां जनानिया चे बड़ी भरी धन्य है, कने जड़ा बच्चा तू जमणा है सै धन्य है। ");
INSERT INTO bht_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","कने मैं बड़ी सोभाग्यशाली है, की मेरे प्रभु दी माँ मिंजो ने मिलणा आई है? ");
INSERT INTO bht_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","दिख जियां ही तेरे नमस्ते बोलणे दी अबाज मेरे कना च पेई तियां ही मेरे पेटे च बच्चा खुशिया ने उछली पिया। ");
INSERT INTO bht_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","कने तू धन्य है, क्योंकि तू भरोसा किता जड़ियां गल्ला प्रभुये दी तरफा ने बोलियां न, कने सै परमेश्वरे पुरियां करणियां न।” ");
INSERT INTO bht_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","तालू मरियमा बोलया, मैं परमेश्वरे दी स्तुति करदी है। ");
INSERT INTO bht_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","कने मैं अपणे उद्धार करणे बाले परमेश्वरे ला बड़ी खुश है। ");
INSERT INTO bht_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","क्योंकि उनी मिंजो अपणिया दासियाँ दिया दीनता पर नजर किती है; इस तांई दिखा, हुण सारे युगां-युगां दे लोकां मिंजो धन्य बोलणा है। ");
INSERT INTO bht_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","क्योंकि उनी अपणिया शक्तिया ने मिंजो तांई बड्डे-बड्डे कम्म कितयो न, कने उदा ना पबित्र है। ");
INSERT INTO bht_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","जड़े परमेश्वरे दा डर मंदे न, उना पर उदी दया पीढ़ियाँ ला पीढ़ियाँ दीकर बणी रेंदी है। ");
INSERT INTO bht_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","उनी अपणी महान शक्ति ने बड्डे-बड्डे कम्म किते न, कने जड़े बड़े घमंडी थे उना जो हराई दिता। ");
INSERT INTO bht_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","परमेश्वरे राजयां ला राज करणे दा हक लेई लेणा है; कने गरीबां जो उच्चा करदा है। ");
INSERT INTO bht_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","उनी भुखयाँ जो खरियाँ-खरियाँ चीजा ने रजाया, कने अमीरां जो खाली हथ कडी दिता। ");
INSERT INTO bht_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","परमेश्वरे साड़े पूर्वजां ने कितयो बायदे जो याद किता कने अपणे सेवक इस्राएल दे लोकां दी मदद करणा आया है। ");
INSERT INTO bht_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","उनी अब्राहम जो कने उदे सारे बंशजा जो हमेशा तांई दया दसणे तांई याद कितया है! ");
INSERT INTO bht_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम पूरे तिन मिहने उसा सोगी रेईकरी घरे जो बापस गेई। ");
INSERT INTO bht_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","तालू एलीशिबा दा बच्चा पैदा करणे दा बकत पूरा होया, कने उना इक पुत्र जमया। ");
INSERT INTO bht_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","उसा दे पड़ोसियां कने रिश्तेदारां ऐ गल्ल सुणीकरी की प्रभुये उसा पर बड़ी बडी दया किती है, कने सै उसा सोगी बड़े खुश होऐ। ");
INSERT INTO bht_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","कने जालू सै अठमे रोजे उदा खतना करणे तांई आये। तालू सै उदा ना उदे पिता दे नाऐ पर जकर्याह रखणा लगे, ");
INSERT INTO bht_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","तां उदिया माता एलीशिबा बोलया, “नी; इदा ना यूहन्ना रखा।” ");
INSERT INTO bht_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","उना उसा जो बोलया, “ऐ ना तां तेरिया रिश्तेदारिया च कुसी दा भी नी है।” ");
INSERT INTO bht_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","तालू उना उदे पिता जो इशारा करी के पूछया की तू इदा ना क्या रखणा चांदा है? ");
INSERT INTO bht_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","कने उनी लिखणे बाली पट्टी मंगाई करी लिख्या, इदा ना यूहन्ना है, कने सारे हेरान होऐ। ");
INSERT INTO bht_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","तालू ही उदी अबाज बापस आई गेई; कने सै परमेश्वरे दा धन्यबाद करणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","कने उदे अखे-बखे दे लोकां पर डर बेठी गिया; कने उना सारियां गल्लां दी चर्चा यहूदिया प्रदेशे दे पाहड़ी इलाकयां च फेली गेई। ");
INSERT INTO bht_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","कने सारयां सुणने बालयां लोकां अपणे मने च बिचार करिके बोलया, ऐ बच्चा कदिया होंगा? “क्योंकि इदे सोगी प्रभु दी शक्ति है। ");
INSERT INTO bht_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","कने उदा पिता जकर्याह पबित्र आत्मा ने परिपूर्ण होई गिया, कने भविष्यवाणी करणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","प्रभु, इस्राएल दे परमेश्वर दी स्तुति करा, क्योंकि सै अपणे लोकां जो मिलणा आया है, कने अपणे लोकां जो छुड़ाया है। ");
INSERT INTO bht_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","जड़ा प्रभु दे सेवक, राजा दाऊद दा बंशज है उनी साड़े तांई इक शक्तिशाली उद्धार करणे बाले जो भेजया है। ");
INSERT INTO bht_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","बड़े पेहले प्रभुये अपणे पबित्र परमेश्वरे दा संदेश देणेबाले दे जरिये बोलया, जड़े संसार दे आदि ला होंदे आऐ न, मतलब की उनी सांझो साड़े दुशमणा ला कने उना सारियां शक्तियाँ ला बचाणा जड़े सान्झो ने नफरत करदे न। ");
INSERT INTO bht_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","उनी अपणे पबित्र बायदे जो याद करिके साड़े पूर्वजां पर दया करणी, ");
INSERT INTO bht_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","उनी साड़े पूर्वज अब्राहम ने कसम खाई करी बायदा किता, ");
INSERT INTO bht_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","की उनी सांझो साड़े दुश्मणा ला बचाणा, ");
INSERT INTO bht_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ताकि असां उदे सामणे पबित्रता, धार्मिकता कने बिना कुसी डरे जिन्दगी भर उदी सेबा करी सकन। ");
INSERT INTO bht_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","कने हे बच्चे, तिजो परम प्रधान परमेश्वरे दा संदेश देणेबाला बोलया जाणा है क्योंकि तू प्रभु दे अग्गे-अग्गे चलणा कने माणुआं जो तैयार करणा, ");
INSERT INTO bht_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","कने इनी अपणे लोकां जो सिखाणा की पापा दी माफी दे जरिये छुटकारा पाई सकदे न। ");
INSERT INTO bht_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ऐ साड़े परमेश्वरे दिया उसा दया ने होणा है; जियां सूरज सांझो रोशनी देणे तांई चमकदा है, तियां ही मसीह भी साड़े बाल स्वर्गे ला ओणा है। ");
INSERT INTO bht_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","पाप च कने मौता दी छोआं च बोंणे बालयों जो रोशनी देणी है, इना रोशनिया सान्झो जिन्दगी च मार्गदर्शन करणा, जड़ा सांझो परमेश्वर सोगी शांति दिन्दा है।” ");
INSERT INTO bht_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","कने सै जागत यूहन्ना बडा होईकरी आत्मा च बलशाली होंदा गिया, कने इस्राएल दे लोकां दे सामणे ओणे दीकर सै सुनसान जगा च रिया। ");
INSERT INTO bht_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","उना दिना च रोमी महाराजा औगुस्तुस कैसरे सारे रोमी सम्राज्य दी जनगणना करणे दा हुकम दिता। ");
INSERT INTO bht_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ऐ पैली जनगणना उस बेले होई, जालू क्विरिनियुस सीरिया प्रदेश दा राज्यपाल था। ");
INSERT INTO bht_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","कने सारे लोक जनगणना च ना लिखाणे तांई अपणे-अपणे शेहरे जो गे जिथू उना दे पूर्वज थे। ");
INSERT INTO bht_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","यूसुफ भी तांई तां गलील प्रदेश दे नासरत शेहरे ला यहूदिया प्रदेशे दे राजा दाऊद दे शेहर बैतलहम शेहरे जो गिया था, क्योंकि सै राजा दाऊद दा बंशज कने परिबारे दा था। ");
INSERT INTO bht_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ताकि अपणी मंगैतर मरियम जड़ी लेरथी थी, उसा सोगी जाई करी ना लिखाइ दे। ");
INSERT INTO bht_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","जालू सै बैतलहम शेहरे च थे तां उसा दे बच्चा जमणे दे दिन पुरे होई गे। ");
INSERT INTO bht_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","कने उना अपणा जेठा पुतर जमया कने उसयो कपड़े च लपेटी करी खुरलिया च रखया; क्योंकि उना तांई सरां च जगा नी थी। ");
INSERT INTO bht_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","कने उस देशे च कुछ पुआल थे, जड़े मैदाना च रेईकरी अपणे धंणे दा पैरा दिन्दे थे। ");
INSERT INTO bht_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","कने प्रभु दा इक स्वर्गदूत उना बखे आई खड़ोता; कने प्रभु दी चमक उना दे चारो पास्से चमकी, कने सै बड़े डरी गे। ");
INSERT INTO bht_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","तालू स्वर्गदूते उना ने बोलया, “डरा मत; दिखा मैं तुहांजो इक बड़ी खुशिया दा शुभसमाचार सुणांदा है; जड़ा सारे लोकां तांई होणा, ");
INSERT INTO bht_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","की अज राजा दाऊद दे शेहर बैतलहम च तुहाड़े तांई इक उद्धारकर्ता जमया है, सेई मसीह प्रभु है। ");
INSERT INTO bht_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","मैं तुहाड़े तांई उना दी ऐ पछेण दिन्दा की सै बच्चा कुण है, तुहांजो इक बच्चा फालड़ु च लपेटया कने खुरलिया च पिया मिलणा है।” ");
INSERT INTO bht_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","तालू उस स्वर्गदूते सोगी इक स्वर्गदूतां दी टोली परमेश्वरे दी स्तुति कने ऐ बोलदे होए प्रगट होई, ");
INSERT INTO bht_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“स्वर्ग च परमेश्वरे दी महिमा कने धरतिया पर जिना लोकां ला सै खुश हे शांति हो।” ");
INSERT INTO bht_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","जालू स्वर्गदूत उना बखे ला स्वर्गे जो चली गे, तालू पुआलां अपु चे बोलया, “ओआ, असां बैतलहम शेहरे च जाई करी ऐ गल्ल जड़ी होइयो है, कने जड़ा प्रभुये सांझो ने दसया है, उसयो दिखन।” ");
INSERT INTO bht_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","कने उना झट पट जाई करी मरियम कने यूसुफ जो कने खुरलिया च उस बच्चे जो पिया दिखया। ");
INSERT INTO bht_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","इना जो दिखीकरी उना सै गल्लां जड़ियां उस बच्चे दे बारे च स्वर्गदूतां ने बोलिया थी, सै सबना जो दसणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","कने सारे लोकां जालू ऐ गल्लां सुणियां जड़ियां गल्लां उना पुआलां बोलियां, तां सै बड़े हेरान होऐ। ");
INSERT INTO bht_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","पर मरियम इना सारियां गल्लां जो मने च रखीकरी सोचदी रेई। ");
INSERT INTO bht_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","कने जियां उना स्वर्गदूतां पुआलां जो बोलया, तियां ही सारा सुणिकरी कने दिखीकरी परमेश्वरे दी महिमा कने स्तुति करदे बापस चली गे। ");
INSERT INTO bht_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","जालू यीशुऐ जो पैदा होयो अठ रोज पुरे होऐ, कने उदे खतने दा बकत आया, तां उदा ना यीशु रखया, जड़ा स्वर्गदूते उदे पेटे च ओंणे ला पेहले बोलया था। ");
INSERT INTO bht_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","जालू मूसा दिया व्यवस्था दे अनुसार उना दे शुद्ध होंणे दे दिन पुरे होऐ तां सै उसयो यरूशलेम शेहरे दे मंदरे च लेई गे, ताकि उसयो प्रभु दे सामणे लेई ओंन। ");
INSERT INTO bht_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","जियां की मूसा दिया व्यवस्था च लिखया है: “हर जेठा पुतर प्रभु तांई पबित्र होणा।” ");
INSERT INTO bht_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","मूसा दिया व्यवस्था दे बचना दे अनुसार, “पंडुकों दा इक जोड़ा, या कबुतरां दे दो बच्यां दी बलि दिया।” ");
INSERT INTO bht_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","उस बकते यरूशलेम शेहरे च शमौन नाऐ दा इक माणु था। कने सै माणु बड़ा धर्मी कने भक्त था। कने बड़िया बेसबरिया ने मसीह दे ओणे दी नियाल रखा था की सै आऐ कने इस्राएल दे लोकां जो तसल्ली दे, कने पबित्र आत्मा उस सोगी थी। ");
INSERT INTO bht_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","कने उसयो पबित्र आत्मा दसया था कि, तू प्रभु दे मसीह जो दिखणे ला पेहले मरणा नी है। ");
INSERT INTO bht_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","उस दिन उसयो आत्मा अगुवाई किती तां सै मंदरे च आया। कने जालू माता-पिता यीशुऐ जो अंदर लेई आये, ताकि उस तांई व्यवस्था दे रीती रिबाजां दे अनुसार करन, ");
INSERT INTO bht_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","तां उनी बच्चा यीशु जो गोदा च लिया कने परमेश्वरे दा धन्यबाद करिके बोलया, ");
INSERT INTO bht_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","प्रभु जी, हुण तू मिंजो अपणे सेवके जो अपणे बायदे दे अनुसार शांतिया ने मरणा दे; ");
INSERT INTO bht_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","क्योंकि मैं उस उद्धारकर्ता जो दिखी लिया है। ");
INSERT INTO bht_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","जिसयो तू सारे लोकां जो बचाणे तांई भेजया है। ");
INSERT INTO bht_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ताकि सै होर जातियां जो परमेश्वरे दा रस्ता दसणे तांई लौ बणे, कने तेरे अपणे लोक इस्राएल दी महिमा करन। ");
INSERT INTO bht_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","कने यीशुऐ दे माता पिता उना गल्लां जो जड़ियां शमौने उदे बारे च बोलियां, सै उना गल्लां ने बड़े हेरान हुंदे थे। ");
INSERT INTO bht_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","तालू शमौने उना जो आशीष देईकरी, उदिया माता मरियम ने बोलया, दिख, सै तां इस्राएल च मतयां लोकां दे विनाश कने उद्धार तांई, इसयो परमेश्वरे दिया तरफा ला इक नशाण दे रुपे च भेजया है, जिदे खिलाफ च गल्लां कितियां जाणियां न। ");
INSERT INTO bht_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","इक भयंकर दुखे कने इक तलबारा सांई विनी देणा इसला मतयां लोकां दे दिले दे बिचार सामणै होणे न। ");
INSERT INTO bht_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","कने आशेर दे गोत्र ला हन्नाह नाऐ दी फनुएल दी इक कुड़ी परमेश्वरे दा संदेश देणेबाली थी: कने सै बड़ी बुड्डी थी, सै बियाह होणें ला सतां साला दीकर अपणे घरे बाले ने रेई सकी थी। ");
INSERT INTO bht_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","सै चोरासियाँ सालां दी बिधबा थी: कने सै मंदरे जो नी छडती थी पर दिन रात बरत कने प्राथना करी-करी भक्ति करदी थी। ");
INSERT INTO bht_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","सै उस बेले ओथु आई करी परमेश्वर दा धन्यबाद करणा लग्गी, कने उना सारयां ने, जड़े यरूशलेम शेहरे दे लोकां जो छुड़ाणे तांई मसीह जो भेजणे तांई परमेश्वरे दी राह दिखदे थे, उदे बारे च गल्लां करणा लग्गी। ");
INSERT INTO bht_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","कने जालू यूसुफ कने मरियम प्रभु दीया व्यवस्था दे अनुसार सारा कुछ करी बेठे तां सै गलील प्रदेश च अपणे शेहर नासरत जो बापस चली गे। ");
INSERT INTO bht_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","बच्चा बडा कने जोरे बाला होंदा गिया; कने अकला बाला होंदा गिया; कने परमेश्वरे दा अनुग्रह उस पर था। ");
INSERT INTO bht_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","यीशुऐ दे माता पिता हर साल फसह दा त्योहार मनाणे तांई यरूशलेम शेहरे जो जांदे थे। ");
INSERT INTO bht_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","जालू सै बाहरां सालां दा होया, तालू सै त्योहारे दे रिबाजे ने अनुसार यरूशलेम शेहरे जो गे। ");
INSERT INTO bht_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","जालू यीशुऐ दे माता-पिता उना दिना जो पूरा करिके के बापस ओणा लग्गे, तां सै जागत ओथु यरूशलेम शेहरे च ही रेई पिया, कने उदे माता पिता जो इसा गल्ला दा पता नी था। ");
INSERT INTO bht_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","सै ऐ समझीकरी, की सै होर यात्रियां सोगी होंणा, कने इक दिन होई गिया कने सै अपणे रिश्तेदार कने जान पछेणा बालयां च तोपणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","पर जालू नी मिल्ला, तां सै तोपदे-तोपदे यरूशलेम शेहरे जो बापिस चली गे। ");
INSERT INTO bht_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","कने तिन्ना रोजां बाद उना उसयो यरूशलेम शेहरे दे मंदरे दे अंगणे च उपदेशकां दे बिच बैठया, कने उना जो सुणदे कने उना ला सबाल पुछदे दिखया। ");
INSERT INTO bht_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","कने जड़े भी उसयो सुंणा दे थे, सै उदिया समझा कने उदे जबाबा ला हेरान थे। ");
INSERT INTO bht_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","तालू यीशुऐ दे माता पिता उसयो दिखीकरी हेरान होऐ, कने उदिया माता उसयो बोलया, “पुत्र, तू सांझो ने इयोदिया व्यवहार कजो किता? दिख, तेरे पिता कने मैं, तिजो तोपा दे कने बेचेन थे।” ");
INSERT INTO bht_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","उनी उना ने बोलया, “तुसां मिंजो कजो तोपा दे थे? क्या तुहांजो पता नी था, की मिंजो अपणे पिता दे घरे होना जरूरी है?” ");
INSERT INTO bht_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","पर जड़ी गल्ल उनी उना ने बोली, उना सै गल्ल समझी नी। ");
INSERT INTO bht_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","तालू सै उना कने गिया, कने नासरत नगर च आया, कने उना दे कुले च रिया; कने उदिया माता ऐ सारियां गल्लां मने च रखियाँ। ");
INSERT INTO bht_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","कने यीशु अकला कने डील-डौल च कने परमेश्वर कने माणुऐ दे अनुग्रह च अग्गे बददा गिया। ");
INSERT INTO bht_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","रोमी महाराजा तिबिरियुस कैसर दे राज्य दे पद्रमें साले च, जालू पुन्तियुस पिलातुस यहूदिया प्रदेश दा राज्यपाल था, कने गलील प्रदेश च राजा हेरोदेस राज करा दा था कने इतुरैया कने त्रखोनितिस दे इलाके च उदा भाई फिलिप्पुस, कने अबिलेने प्रदेश च राजा लिसानियास राज्य करा दे थे। ");
INSERT INTO bht_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","कने जालू हन्ना कने कैफा बड्डे याजक थे, उस बकते परमेश्वरे दा बचन सुनसान जगा च जकर्याह दे पुत्र यूहन्ना बाल पुज्जा। ");
INSERT INTO bht_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","कने यूहन्ना यरदन खड्डा दे अखे-बखे दे सारे देशां च जाई करी प्रचार करदा था, की अपणे पापां जो मन्नी लिया कने गलत कम्मा जो छडी दिया तां तुहांजो परमेश्वरे माफ करणा कने बपतिस्मा लिया। ");
INSERT INTO bht_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","जियां यशायाह परमेश्वरे दा संदेश देणेबाले दे बचना दीया कताबां च लिखया है, “सुनसान जगा च इक पुकारणे बाले दी अबाज सुणुआ दी है की प्रभु दा रस्ता तैयार करा, कने उदियां सड़कां सिदियां बणा।” ");
INSERT INTO bht_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","हर इक घाटी भरी दिती जाणी, कने हर इक पहाड़ कने टीला थले करी देणा; कने जड़ा ढेरा है सै सीधा, कने जड़ा उच्चा सै नीठा है सै पद्दरा रस्ता बणाना। ");
INSERT INTO bht_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","कने सारे लोकां उसयो दिखणा है जिसयो परमेश्वरे उना जो बचाणे तांई भेजया है। ");
INSERT INTO bht_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","जड़ी भीड़ा दी भीड़ उसला बपतिस्मा लेणे तांई निकली करी ओंदी थी, सै उना जो बोलदा था की, “तुसां लोक जहरीले सांपा सांई बुरे न, तुहाड़ा ऐ सोचणा गलत है की सिर्फ तुसां बपतिस्मा लेणे ने अपणे पापां दी सजा ला बची जाणा जड़ी परमेश्वरे तुसां जो देणी है। ");
INSERT INTO bht_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","सजा ला बचने तांई ऐसे कम्म करा जिना ने पता चले की तुसां सच्ची ही पश्चाताप किता है; कने अपणे-अपणे मने च ऐ मत सोचा, परमेश्वरे सान्झो सजा नी देणी क्योंकि साड़ा पिता अब्राहम है; क्योंकि मैं तुसां ने बोलदा है की, परमेश्वर तुहाड़ी जगा लेणे तांई इना पथरां ला भी अब्राहम तांई ओलाद पैदा करी सकदा है। ");
INSERT INTO bht_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","कने हुण कुहाड़ी रुखां दिया जड़ा च रखियो है, हर इक माणु उस रुखे सांई है जड़ा खरा फल नी दिन्दा है, उसयो परमेश्वरे दोषी बोलणा है कने सै रुख बड्डी करी अग्गी च फूकी देणा।” ");
INSERT INTO bht_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","कने लोकां उसला पुछया, “तां असां परमेश्वरे दिया सजा ला बचणे तांई क्या करन?” ");
INSERT INTO bht_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","युहन्ना उना जो जबाब दिता, “जिसदे बाल दो कुरते न, सै उसयो बंडी दिया जिना बाल नी न, कने जिसदे बाल खाणां है, सै भी इयां करन।” ");
INSERT INTO bht_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","कने कर लेणेबाले भी बपतिस्मा लेंणा आये, कने उसला पुछया, “गुरू जी, असां क्या करन?” ");
INSERT INTO bht_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","यूहन्ने उना जो बोलया, “जितणा तुहांजो अधिकारियां बोलया लेणे तांई, उसला जादा चुंगी मत लेंदे।” ");
INSERT INTO bht_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","कने सिपाईयां भी उसला पुछया, असां क्या करन? उनी उना जो बोलया, कुसी ने लड़ाई मत करदे, कने कुसी पर झूठा दोष मत लांदे, कने अपणिया तनखाई पर खुश रेंणा। ");
INSERT INTO bht_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","जालू सारयां लोकां मसीह दे तोल्ली ओणे दी आस लगाईयो थी, कने सारे अपणे-अपणे मने च यूहन्ना दे बारे च सोचा दे थे, की सै ही मसीहा ता नी है। ");
INSERT INTO bht_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","तां यूहन्ने उना सारयों जो जबाब दिता, “मैं तां तुहांजो पाणिये ने बपतिस्मा दिन्दा है, पर सै ओणेवाला है, सै मिंजो ला भी शक्तिशाली है; मैं तां उस जोगा भी नी है की उदे जुतयां दे तस्मे भी खोली सके, उनी तुहांजो पबित्र आत्मा ने कने अग्गी ने बपतिस्मा देणा है। ");
INSERT INTO bht_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","उदा सूप्प, उदे हथे च है; कने उनी अपणा खेतर ढंगे ने साफ करणा; कने कणका जो अपणे खेतरे च गिठेरगा, पर भुऐ जो अग्गी च फुकी देणा है, सै अग्ग कदी नी बुझदी है।” ");
INSERT INTO bht_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","सै बड़ियाँ सारियां शिक्षा देईकरी लोकां जो शुभसमाचार सुणांदा रिया। ");
INSERT INTO bht_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","पर जालू यूहन्ना गलील प्रदेश दे इलाके दे राजा हेरोदेस जो उदे भाई फिलिप्पुस दिया घरे बाली हेरोदियास दे बारे च, कने उना दे सारे बुरे कम्मा दे बारे च जड़े उनी कितयो थे, उना दी निंदा किती। ");
INSERT INTO bht_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","तां ही तां राजा हेरोदेसे सारयां ला बड़ी करी बुरा कम्म किता, की यूहन्ना जो जेला च पाई दिता। ");
INSERT INTO bht_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","जालू सारे लोकां बपतिस्मा लिया, कने यीशु भी बपतिस्मा लेईकरी प्राथना करा दा था, तां स्वर्ग खुली गिया। ");
INSERT INTO bht_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","कने पबित्र आत्मा शरीरे दे रुपे च कबुतर बणी करी उस पर उतरी, कने आकाशवाणी होई: तू मेरा प्यारा पुत्र है, तिजो ला मैं खुश है। ");
INSERT INTO bht_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","जालू यीशु अपु उपदेश करणा लग्गा तां सै लगबग तियां सालां दा था कने (जदिया समझया जांदा है) की यूसुफ दा पुत्र था; कने यूसुफ एली दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","कने एली मत्तात दा पुत्र, कने मतात लेवी दा पुत्र, कने लेवी मलकी दा पुत्र, कने मलाकी यन्ना दा, कने यन्ना यूसुफ दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","कने यूसुफ मत्तित्याह दा, कने मत्तित्याह आमोस दा पुत्र, कने आमोस नहूम दा, कने नहूम असल्याह दा पुत्र, कने असल्याह नोगह दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","कने नोगह मात दा पुत्र, कने मात मत्तित्याह दा पुत्र, कने मत्तित्याह शिमी दा, कने शिमी योसेख दा पुत्र, कने योसेस योदाह दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","कने योदाह यूहन्ना दा पुत्र, कने यूहन्ना रेसा दा पुत्र, कने रेसा जरुब्बाबेल दा, कने जरुब्बाबेल शालतियेल दा पुत्र, कने शालतियेल नेरी दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","कने नेरी मलकी दा पुत्र, कने मलकी अद्दी दा पुत्र, कने अद्दी कोसाम दा पुत्र, कने कोसाम इलमोदाम दा पुत्र, कने इलमोदाम एर दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","कने एर येशू दा पुत्र, कने येशू एलीएजेर दा पुत्र, कने एलीएजेर योरीम दा पुत्र, कने योरीम मत्तात दा पुत्र, कने मत्तात लेवी दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","कने लेवी शमौन दा पुत्र, कने श्मौन यहूदा दा पुत्र, कने यहूदा यूसुफ दा पुत्र, कने यूसुफ योनान दा, कने योनान एलयाकीम दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","कने एलयाकीम मलेआह दा पुत्र, कने मलेआह मिन्नाह दा पुत्र, कने मिन्नाह मत्तता दा पुत्र, कने मत्तता नातान दा पुत्र, कने नातान दाऊद दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","कने दाऊद यिशै दा पुत्र, कने यिशै ओबेद दा पुत्र, कने ओबेद बोअज दा पुत्र, कने बोअज सलमोन दा पुत्र, कने सलमोन नहशोन दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","कने नहशोन अम्मीनादाब दा पुत्र, कने अम्मीनादाब अरनी दा पुत्र, कने अरनी हिस्रोन दा पुत्र, कने हिस्रोन पेरेस दा पुत्र, कने पेरेस यहूदा दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","कने पेरेस याकूब दा पुत्र, कने याकूब इसहाक दा पुत्र, कने इसहाक अब्राहम दा पुत्र, कने सै तेरह दा पुत्र, कने तेरह नाहोर दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","कने नाहोर सरुग दा पुत्र, कने सरुग रुऊ दा पुत्र, कने रुऊ फिलिग दा पुत्र, कने फिलिग एबिर दा पुत्र, कने एबिर शिलह दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","कने शिलह केनान दा पुत्र, कने केनान अरफक्षद दा पुत्र, कने अरफक्षद शेम दा पुत्र, कने सै नूह दा पुत्र, कने नूह लेमेक दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","कने लेमेक मथूशिलह दा पुत्र, कने मथूशिलह हनोक दा पुत्र, कने हनोक यिरिद दा पुत्र, कने यिरिद महललेल दा पुत्र, कने महललेल केनान दा पुत्र, ");
INSERT INTO bht_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","कने केनान एनोश दा पुत्र, कने एनोश शेत दा पुत्र, कने शेत आदम दा पुत्र, कने शेत परमेश्वरे दा पुत्र था। ");
INSERT INTO bht_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","फिरी यीशु पबित्र आत्मा ने परिपूर्ण होईकरी यरदन खड्डा ला बापस आया; कने आत्मा दी अगुवाई ने सुनसान जगा च रिया; ");
INSERT INTO bht_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","कने शैतान चालियां रोजां दीकर उदी परख करदा रिया। उना रोजां च उनी कुछ नी खादा कने जालू सै रोज पुरे होई गे, तालू उसयो भूख लग्गी। ");
INSERT INTO bht_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","कने शैताने उसयो बोलया, “अगर तू परमेश्वरे दा पुत्र है तां इसी पथरे जो बोल की, तू रोटी बणी जा।” ");
INSERT INTO bht_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","यीशुऐ उसयो जबाब दिता, “पबित्र शास्त्र च लिखया है: माणुऐ सिर्फ रोटियां ने ही जिंदे नी रेणा।” ");
INSERT INTO bht_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","तालू सै शैतान उसयो लेई गिया कने पल भर च ही सारे संसारे दे राज्य उसयो दस्से। ");
INSERT INTO bht_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","कने उसयो बोलया, मैं ऐ सारे हक, कने सारा धन दौलत तिजो दिंगा, क्योंकि सै मिंजो दितया है: कने जिसयो दिल करदा उसयो देई दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","इस तांई अगर तू मिंजो नमस्ते करगा, तां ऐ सारा तेरा होई जाणा। ");
INSERT INTO bht_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","यीशुऐ उसयो जबाब दिता, “पबित्र शास्त्र च इयां लिखया है: तू अपणे परमेश्वरे जो नमस्ते कर; कने उदी ही उपासना कर।” ");
INSERT INTO bht_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","तालू उनी उसयो यरूशलेम शेहर च लेईजाई करी मंदरे दिया चुंडिया पर खड़ेरया, कने उसयो बोलया, “अगर तू परमेश्वरे दा पुत्र है, तां अपणे आपे जो ऐथू ला थले फेंकी दे। ");
INSERT INTO bht_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","क्योंकि पबित्र शास्त्र च लिखया हे, उनी तेरे तांई अपणे स्वर्गदूतां जो हुकम देणा, की सै तिजो बचान। ");
INSERT INTO bht_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","कने उना तिजो हथो हथ सभांली लेणा पर इयां ना हो की तेरे पैरां च पथरे ने चोट लग्गी जा।” ");
INSERT INTO bht_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","यीशुऐ उसयो जबाब दिता, पबित्र शास्त्र च ऐ भी लिखया है: तू अपणे प्रभु परमेश्वरे दी परख मत करदा। ");
INSERT INTO bht_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","जालू शैतान सारियां परखां करी बैठा, तालू सै थोड़ी देरां तांई उदे बखे ला चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","फिरी यीशु आत्मा दिया शक्तिया ने परिपूर्ण होईकरी गलील प्रदेश जो बापिस गिया, कने उदी चर्चा अखे-बखे दे देशां च फेली गेई। ");
INSERT INTO bht_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","कने सै उना ही यहूदी जंज घरां च उपदेश करदा रिया, कने सारे उदी बड़ाई करदे थे। ");
INSERT INTO bht_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","कने सै नासरत च बापस आया; जिथू पलया बडोयो था; कने अपणे रिबाजे दे अनुसार सब्त दे रोजे पबित्र शास्त्र पढ़ने तांई यहूदी जंज घर च जाई करी खड़ोई गिया। ");
INSERT INTO bht_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","परमेश्वरे दा संदेश देणेबाले यशायाह दी कताब पढ़ने जो उसयो दिती। कने उनी कताब खोलिकरी सै जगा कडी जिथू ऐ लिखया था: ");
INSERT INTO bht_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“प्रभु दी आत्मा मिंजो सोगी है, इस तांई उनी कंगालां जो शुभसमाचार सुनाणे तांई मेरा अभिषेक कितया है, कने मिंजो इस तांई भेजया है, की केदियां जो छुटकारे दा कने अन्नयां जो नजर मिलणे दा शुभसमाचार दा प्रचार करे कने कुचले होया जो छुडां। ");
INSERT INTO bht_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","कने प्रभु दे खुश रेणें दे साले दा प्रचार करे।” ");
INSERT INTO bht_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","तालू उनी कताब बंद करी के सेवके दे हथे च देई दिती, कने बैठी गिया: कने यहूदी जंज घर दे सारे लोकां दियां नजरां उस पर थियां। ");
INSERT INTO bht_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","तालू सै उना ने बोलणा लग्गा, “अज ही तुहाड़े सुणने ने ऐ लेख पूरा होया है।” ");
INSERT INTO bht_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","कने सारयां लोकां उदी प्रशंशा किती, जड़ियां अनुग्रह दियां गल्लां उदे मुऐ ला निकलदियां थियां, उना ला हेरान होए; कने बोलणा लग्गे, “क्या ऐ यूसुफे दा पुत्र नी है?” ");
INSERT INTO bht_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","उनी उना जो बोलया, “तुसां मिंजो पर ऐ कहावत जरुर बोलणी है, की हे बैद्य, अपणे आपे जो खरा कर। जड़ा कुछ असां सुणाया है की तू कफरनहूम शेहरे च कितया है, उसयो अपणे देशे च भी कर।” ");
INSERT INTO bht_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","कने उनी बोलया, “मैं तुहांजो ने सच्च बोलदा है, कुसी भी परमेश्वरे दा संदेश देणेबालयां जो अपणे देशे च इज्जत नी मिलदी। ");
INSERT INTO bht_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","मेरी गल्ल सुणा। की परमेश्वरे दा संदेश देणेबाले एलिय्याह दे दिना च जालू साडे तिन्ना सालां दीकर कोई बरखा नी होई, ऐथू दीकर की सारे इस्राएल देशे च बड़ा भरी अकाल पिया, तां इस्राएल देशे च मतियां बिधबा थियां। ");
INSERT INTO bht_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","पर एलिय्याह जो इस्राएल च उना चे कुसी बाल भी नी भेजया गिया, सिर्फ सिदोन शेहर दे बखे साफरत दे इलाके च इक होर जाति दी बिधवा बाल भेजया। ");
INSERT INTO bht_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","कने परमेश्वरे दा संदेश देणेबाले एलीशा दे बकते इस्राएल देशे च बतेरे कोढ़ी थे, पर सीरिया दा वासी नामान जो छडी करी उना चे कोई भी ठीक नी किता, नामान होर जाति दा था।” ");
INSERT INTO bht_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ऐ सारियां गल्लां सुणिकरी जितणे भी यहूदी जंज घर च थे, सारे गुस्से होई गे। ");
INSERT INTO bht_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","कने उना उठी करी उसयो शेहरे ला बाहर कडया, कने जिस पाहड़े पर उना दा शेहर बसया था, उसयो उदिया चुंडिया पर लेई चले, ताकि उसयो ओथु ला थले फेंकी करी मारी देन। ");
INSERT INTO bht_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","पर सै उना दे बिचे ला निकली करी चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","फिरी यीशु गलील प्रदेश दे कफरनहूम शेहर च गिया, कने सब्त दे रोजे लोकां जो उपदेश दिन्दा था। ");
INSERT INTO bht_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","सै उदे उपदेशे ने हेरान होई गे क्योंकि यीशु बचन अधिकारे ने बोलदा था। ");
INSERT INTO bht_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","तालू ही यहूदी जंज घर च इक माणु था, जिदे बिच इक बुरी आत्मा थी। ");
INSERT INTO bht_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","उनी जोरे ने बोलया, “हे नासरत दे यीशु, तु सांझो कजो परेशान करदा है? तू क्या सांझो खत्म करणा आया है? मिंजो पता है की, तू कुण है? तु ही परमेश्वर दा पबित्र पुत्र मसिहा है, जड़ा परमेश्वरे ला आया है।” ");
INSERT INTO bht_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","यीशुऐ बुरिया आत्मा जो झिड़कया कने बोलया, चुप रे; कने इस माणुऐ ला निकली जा, तालू सै बुरी आत्मा उसयो बिच पटकी करी बिना नुकसान कितयो उस बन्दे ला निकली गेई। ");
INSERT INTO bht_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","इस पर सबना जो हेरानी होई, कने सै अपु चे गल्लां करी के बोलणा लग्गे, “ऐ कदिया बचन है? की सै हक कने सामर्थ्य ने बुरियां आत्मा जो हुकम दिन्दा है, कने बुरी आत्मा इसदियां गल्लां जो मंदियां भी न।” ");
INSERT INTO bht_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","इदे बाद यीशुऐ दी चर्चा सारे पासे होणा लग्गी पेई। ");
INSERT INTO bht_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","सै यहूदी जंज घर ला उठी करी शमौने दे घरे जो गिया कने शमौने दिया ससु जो बुखार चड़या था, कने उना उसा तांई यीशुऐ ने बिनती किती। ");
INSERT INTO bht_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","उनी उसा बखे खड़े होईकरी बुखारे जो डांटया कने बुखार उतरी गिया कने सै झट पट उठी करी उदी सेबा करणा लग्गी पेई। ");
INSERT INTO bht_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","सूरजे डुबणे दे बेले जिना -जिना लोकां जो लग-लग तरा दियां बमारियां थियां उना सारयां लोका जो यीशुऐ बाल लेई आये, कने उनी इकी-इकी पर हथ रखीकरी सारयां जो ठीक किता। ");
INSERT INTO bht_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","कने बुरियां आत्मा चिखदियां कने बोलदियाँ होइयां मतयां लोकां ला निकली गियां की, “तू परमेश्वरे दा पुत्र है” पर सै उना जो डांटदा था, कने बोलणा नी दिन्दा था, क्योंकि उना जो पता था की ऐ मसीह है। ");
INSERT INTO bht_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","जालू दिन होया तां सै निकली करी इक सुनसान जगा पर चली गिया, कने भिड़ा दी भीड़ उसयो तोपदे उस बाल आई, कने उसयो रोकणा लग्गी, की ऐथू ला ना जा। ");
INSERT INTO bht_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","पर यीशुऐ उना ने बोलया, “मिंजो होर-होर शेहरां च भी परमेश्वरे दे राज्य दा शुभसमाचार सुणाणा जरूरी है, क्योंकि मैं इसी तांई संसारे च भेजया है।” ");
INSERT INTO bht_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","कने सै गलील प्रदेश दे यहूदी जंज घर च प्रचार करदा रिया। ");
INSERT INTO bht_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","इक दिन जालू यीशु गलील दे झिला दे कंडे पर खड़ोतया था, तां भीड़ परमेश्वरे दा बचन सुणने तांई उस पर डेई पोआ दी थी। ");
INSERT INTO bht_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","की उनी झिला दे बखे दो किस्तिया लगियां दिखियां, कने मछबारे उना ला उतरी करी मच्छियां पकड़णे बाले जाले जो धोआ दे थे। ");
INSERT INTO bht_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","उना किस्तिया चे इकी पर, जड़ी शमौने दी थी, चढ़ी करी यीशुऐ उसला बिनती किती की, किनारे ला थोड़ी हटाई ले, तालू सै किस्तिया पर बेईकरी लोकां जो उपदेश देणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","जालू यीशु लोकां ने गल्लां करी बैठा, तां उनी शमौने जो बोलया, “डुगे पांणिऐ च लेई चल, कने मच्छियां पकड़ने तांई अपणे जाले जो फेंक।” ");
INSERT INTO bht_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","शमौने उसयो जबाब दिता, “हे मालिक, असां सारी रात मेहनत किती कने कुछ नी पकड़या; पर तेरे बोलने ने असां जाल फेंका दे न।” ");
INSERT INTO bht_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","जालू पतरस कने उदे साथियां जाल पाया, तां मतियां भरी मछियां जाले च फसी गियां, कने उना दे जाल फटणा लग्गी पिया थे। ");
INSERT INTO bht_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","इस पर उना अपणे साथियां जो इशारा किता जड़े दुईयां किस्तिया पर थे, ताकि आई करी साड़ी मदद करा: कने उना आई करी, दोनो किस्तिया मच्छियां ने इतणियां भरी लियां की सै डूबणा लगी पियां थियां। ");
INSERT INTO bht_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ऐ दिखीकरी शमौन पतरस यीशुऐ दे पैरां च पेई गिया, कने बोलया, “प्रभु जी, मेरे बखे ला चली जा, क्योंकि मैं पापी माणु है।” ");
INSERT INTO bht_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","क्योंकि इतणियां मछियां पकड़णे ने उसयो कने उदे साथियां जो बड़ी हेरानी होई; ");
INSERT INTO bht_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","कने तियां ही उदे साथी जब्दी दे पुत्र याकूब कने यूहन्ना भी बड़े हेरान होऐ। तालू यीशुऐ शमौने ने बोलया, “डरा मत, हुण ला तुसां माणुआं जो मेरे चेले बणना सिखाणा है।” ");
INSERT INTO bht_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","कने सै किस्तिया जो किनारे पर लेई आऐ, कने सब कुछ छडी करी उदे पिच्छे चली पे। ");
INSERT INTO bht_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","जालू यीशु कुसी शेहरे च था, तां दिखा, ओथु इक माणु था, जिसयो कोढ़ होया था कने सै यीशुऐ जो दिखीकरी मुऐ दे भार पेई गिया, कने बिनती करणा लगा कि, “प्रभु जी अगर तू चा तां मिंजो ठीक करी सकदा है।” ");
INSERT INTO bht_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","यीशुऐ हथ अग्गे करी के उसयो छुता कने बोलया, “मैं चांदा है की तू ठीक होई जा” कने तालू ही उदा कोढ़ ठीक होई गिया। ");
INSERT INTO bht_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","तालू उनी उसयो समझाया, “कुसी ने कुछ मत बोलदा, पर जाई करी अपणे आपे जो याजकां जो दस, की तु खरा होईया कने परमेश्वरे जो भेंट चढ़ा जिदे बारे च मूसा हुकम दितया है, ताकि लोक जाणी सकन की तु खरा होई गिया।” ");
INSERT INTO bht_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","पर यीशु दे बारे च खबर होर भी जादा फेलदी गेई, कने भिड़ा दी भिड़ उसयो सुणने तांई कने अपणियां बिमारियाँ ला ठीक होणे तांई गिठी होई। ");
INSERT INTO bht_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","पर यीशु मसीह हमेशा सुनसान जगा च जाई करी किल्ला प्राथना करदा था। ");
INSERT INTO bht_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","कने इक रोज ऐसा होया की सै उपदेश दे दा था, कने फरीसी कने व्यवस्था जो सिखाणे बाले ओथु बैठयो थे, जड़े गलील प्रदेश कने यहूदिया प्रदेशे दे इलाके दे हर इक ग्रां ला कने यरूशलेम शेहरे ला आयो थे; कने ठीक करणे तांई प्रभु दी शक्ति उस सोगी थी। ");
INSERT INTO bht_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","कने दिखा लोक इक माणुऐ जो मंझे पर चुकी लेई आऐ, कने सै धंरगे दा मरीज था, कने सै उसयो अंदर लेई जाणे कने यीशुऐ दे सामणे रखणे दी तरकीब तोपा दे थे। ");
INSERT INTO bht_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","कने जालू भिड़ा दिया बजा ने अंदर नी लेईजाई सके तां उना छती पर चड़ी करी कने खपरैलां जो हटाई करी, उना उसयो मंझे समेत कमरे बिच यीशु दे सामणे उतारी दिता। ");
INSERT INTO bht_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","उनी उना दा भरोसा दिखीकरी बोलया, “हे माणु, तेरे पाप माफ होऐ।” ");
INSERT INTO bht_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","तालू व्यवस्था जो सिखाणे बाले कने फरीसी गल्लां करणा लग्गे, “ऐ कुण है, जड़ा परमेश्वरे दी निंदा करा दा है? परमेश्वरे जो छडी करी होर कुण पापां जो माफ करी सकदा है?” ");
INSERT INTO bht_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","यीशुऐ उना दे मने दियां गल्लां जो जाणी करी बोलया, “की तुसां अपणे मने च क्या गल्लां करा दे न? ");
INSERT INTO bht_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","क्या बोलणा असान है? क्या इयां बोलणा, की तेरे पाप माफ होये, या की इयां बोलणा की उठ कने हंड फिर? ");
INSERT INTO bht_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","पर ऐ इस तांई की तुहांजो पता लग्गे की मिंजो, माणुऐ दे पुत्रे जो धरतिया पर पाप माफ करणे दा हक भी है।” उनी उस धंरगे दे मरिजे जो बोलया, “मैं तिजो ने बोलदा है, उठ कने अपणे मंझे जो चुकी करी अपणे घरे चली जा।” ");
INSERT INTO bht_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","सै झट पट उदे सामणे उठया, कने जिस पर सै लेटया था उसयो चुकी करी, परमेश्वरे दी बड़ाई करदा होया अपणे घरे जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","तालू सारे हेरान होऐ कने परमेश्वरे दी बड़ाई करणा लग्गे, सारे डरीकरी बोलणा लग्गे, “अज असां बड़ियाँ अनोखियां गल्लां दिखियां।” ");
INSERT INTO bht_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","कने उदे बाद यीशु बाहर गिया, कने उनी लेवी नाऐ दे इक कर लेणेबाले जो चुंगिया दिया चोकिया पर बैठया दिखया, कने उसयो बोलया, “की मेरा चेला बण।” ");
INSERT INTO bht_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","तालू सै सब कुछ छडी करी उठया कने उदे पिच्छे चली पिया। ");
INSERT INTO bht_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","कने लेवी अपणे घरे यीशुऐ तांई इक बड़ी बडी धाम दिती; कने चुंगी लेणेबाले कने होर मते भरी लोकां उदे सोगी खाणां खादा था। ");
INSERT INTO bht_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","कने फरीसी कने मूसा दी व्यवस्था जो सिखाणे बाले उदे चेलयां जो ऐ बोली करी गल्लां करणा लग्गे, “की तुसां चुंगी लेणेबाले कने पापियाँ सोगी कजो खांदे पिंदे न?” ");
INSERT INTO bht_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","यीशुऐ उना जो जबाब दिता, वैद्य भले चंगे लोका तांई नी होंदा, पर सै बिमारां तांई जरूरी होंदा है। ");
INSERT INTO bht_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","मैं धर्मियों जो नी, पर पापियों जो मन बदलने तांई सदणा आया है। ");
INSERT INTO bht_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","फरीसी कने मूसा दिया व्यवस्था जो सिखाणे बालयां यीशुऐ जो बोलया, “यूहन्ना दे चेले तां बराबर बरत रखदे कने प्राथना करदे न, कने तियां ही फरीसियाँ दे भी करदे न, पर तेरे चेले तां खांदे पिंदे न।” ");
INSERT INTO bht_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","यीशुऐ उना जो बोलया, “क्या तुसां बरातियां ला बरत करवाई सकदे न जालू दीकर लाड़ा उना सोगी होऐ? ");
INSERT INTO bht_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","पर सै दिन ओणे न, जिना च लाड़ा उना ला बख कितया जाणा है, तालू बरातियां उना रोजां च बरत रखणे न।” ");
INSERT INTO bht_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","यीशुऐ उना ने इक होर कहाणी बोली: कोई भी माणु नोऐ कपड़यां जो फाड़िकरी पराणे कपड़यां च रफु नी लांदा है, अगर कोई इयां करदा है तां नोआ कपड़ा धोणे बाद छोटा होई जांदा है, जिसने पराणे कपड़े होर फटी जाणा कने सै पराणा कपड़ा उस सोगी मेल नी खाणां। ");
INSERT INTO bht_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","नोऐ अंगूरा दे रसे जो परांणिया खलड़िया च कोई नी रखदा है नी तां नोआ अंगूर रस परांणिया खलड़िया जो फाड़ी करी निकली जांदा है, कने अंगूर रस खलड़िया जो बरबाद करी दिन्दा है, ");
INSERT INTO bht_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","तांई तां नोआ अंगूर रस नोईयां खलड़िया च ही रखणा चाईदा। ");
INSERT INTO bht_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","कोई माणु पराणा अंगूर रस पी करी नौआ नी पिणा चांदा क्योंकि सै बोलदा है, की परांणा ही खरा है। ");
INSERT INTO bht_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","फिरी सै सब्ते दे रोजे खेतरां चे होईकरी चलया था, कने उदे चेले बेलां तोड़ी-तोड़ी करी कने हथा ने मल्ली-मल्ली करी खांदे जा दे थे। ");
INSERT INTO bht_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","तालू फरीसियाँ चे कोई बोलणा लग्गे, “तुसां सै कम्म कजो करदे न जड़ा सब्ते दे रोज करणा ठीक नी है?” ");
INSERT INTO bht_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","यीशुऐ उना जो जबाब दिता, की तुसां ऐ नी पढ़या, कि राजा दाऊदे जालू सै कने उदे साथी भूखे थे तां उना क्या किता? ");
INSERT INTO bht_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","दाऊद कियां परमेश्वरे दे घरे गिया, कने भेंट चढ़ाईयां रोटियां लेईकरी खादियां कने अपणे साथियां जो भी दितियां, जिना जो सिर्फ याजक लोक ही खाई सकदे थे? ");
INSERT INTO bht_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","कने यीशुऐ उना ने बोलया, “मैं माणुऐ दा पुत्र ऐ बोलणे दा हक रखदा है कि लोकां जो सब्ते बाले रोजे क्या करणा चाईदा कने क्या नी करणा चाईदा।” ");
INSERT INTO bht_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","कने इक दिन इयां होया की सै कुसी होर सब्ते दे रोजे यहूदी जंज घर च जाई करी उपदेश देणा लग्गा; कने ओथु इक माणु था, जिदा सज्जा हथ सुक्या था। ");
INSERT INTO bht_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","व्यवस्था जो सिखाणे बालयां कने फरीसी उस पर दोष लगाणे दे मोके दीया ताका पर थे, की दिखदे न की सै सब्त दे रोजे ठीक करदा है की नी। ");
INSERT INTO bht_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","पर सै उना दे बिचार जाणदा था; तांई तां उनी सुक्यो हथे बाले माणुऐ जो बोलया, “उठ, खड़ोई जा।” सै उठी होया। ");
INSERT INTO bht_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","यीशुऐ उना जो बोलया, “मैं तुसां ला ऐ पुछदा है की सब्त दे रोजे क्या ठीक है, भला करणा या बुरा करणा; जान बचणा या मारणा?” ");
INSERT INTO bht_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","तालू यीशुऐ उना लोकां पासे दिखया। कने उस माणुऐ जो बोलया, “अपणा हथ कर रुआं।” उनी किता, कने उदा हथ खरा होई गिया। ");
INSERT INTO bht_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","पर ऐ दिखीकरी फरीसी कने मूसा दी व्यवस्था जो सिखाणे बाले बड़े गुस्सा होई गे कने अपु चे बोलणा लग्गे की असां यीशुऐ दा क्या करन? ");
INSERT INTO bht_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","उदे बाद यीशु धारा पर प्राथना करणे तांई गिया, कने परमेश्वरे ने प्राथना करणे च सारी रात बिताई। ");
INSERT INTO bht_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","जालू दिन होया, तां उनी अपणे चेलयां जो सदीकरी उना चे बाहरा चुणी ले, कने उना जो प्रेरित बोलया। ");
INSERT INTO bht_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","कने सै ऐ न: शमौन जिदा ना उनी पतरस भी रखया; कने उदा भाई अन्द्रियास, कने याकूब, कने यूहन्ना, कने फिलिप्पुस, कने बरतुलमै, ");
INSERT INTO bht_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","कने मत्ती, कने थोमा, कने हलफई दा पुत्र याकूब, कने शमौन जिसयो जेलोतेस बोलदे न, ");
INSERT INTO bht_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","कने याकूब दा पुत्र यहूदा, कने यहूदा इस्करियोती, जड़ा उसयो पकड़वाणे बाला बणया। ");
INSERT INTO bht_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","तालू सै उना सोगी उतरिकरी चौरस दिया जगा पर खड़ोता, कने उदे चेलयां दी मती भीड़ कने सारे यहूदिया प्रदेश, कने यरूशलेम शेहर, कने सूर कने सैदा शेहरां दे कने समुद्रे दे बखे ला बतेरे लोक, ");
INSERT INTO bht_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","जड़े उदी सुणना कने अपणियां बमारियां ला ठीक होणे तांई उस बाल आयो थे, ओथु थे। कने बुरियां आत्मा दे सताये होऐ लोक भी ठीक होंदे थे। ");
INSERT INTO bht_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","कने सारे उसयो छूणा चांदे थे, क्योंकि उसला शक्ति निकलदी थी जड़ी सबना जो ठीक करदी थी। ");
INSERT INTO bht_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","तालू उनी अपणे चेलयां पासे दिखीकरी बोलया, “धन्य न तुसां, जड़े दीन न, क्योंकि परमेश्वरे दा राज्य तुहाड़ा है।” ");
INSERT INTO bht_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“धन्य न तुसां, जड़े की हुण भूखे न; क्योंकि तुसां रजाऐ जाणे न। धन्य न तुसां, जड़े की हुण रोंदे न, क्योंकि तुसां हसणा है।” ");
INSERT INTO bht_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“धन्य न तुसां, जालू माणुऐ दे पुत्रे दिया बजा ने लोकां तुहांजो ने दुशमणी रखणी है, कने तुसां जो कडी देणा, कने तुहाड़ी निंदा करणी, कने तुहाड़ा ना बुरा समझीकरी तुहांजो बडी देणा है।” ");
INSERT INTO bht_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“उस रोजे खुश होनयो, क्योंकि तुहाड़े तांई स्वर्गे च बडा इनाम है। उना दे बाप-दादे भी परमेश्वरे दा संदेश देणेबालयां सोगी इयां ही करदे थे।” ");
INSERT INTO bht_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“पर तुहाड़े तांई बड़ी बुरी सजा होणी जड़े बड़े अमीर न, क्योंकि तुहांजो पेहले ही अपणी खुशी मिली गियो है।” ");
INSERT INTO bht_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“तुहाड़े तांई बड़ी बुरी सजा होणी जड़े हुण रजी करी खांदे न, क्योंकि उना भूखे रेणा है। तुहाड़े तांई बड़ी बुरी सजा होणी; जड़े हुण हसदे न, क्योंकि बादे च शोक करणा कने रोणा है।” ");
INSERT INTO bht_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“तुहाड़े तांई बड़ी बुरी सजा होणी, जालू सारे माणु तुहांजो खरा बोलगे, क्योंकि तुहाड़े पूर्वजां उना लोकां दे बारे च खरियाँ गल्लां बोलियां जड़े परमेश्वरे दे संदेश देणेबाले झूठे लोक थे। इसला पता चलदा की तुसां भी परमेश्वरे दे संदेश देणेबाले झूठे लोक न।” ");
INSERT INTO bht_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","पर तुसां सुणने बालयां जो मैं बोलदा है, की अपणे दुश्मणा ने प्यार रखा; जड़े तुहांजो ने बैर करन, उना दा भला करा। ");
INSERT INTO bht_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","जड़े तुहांजो श्राप देन, उना जो आशीष दिया; जड़े तुहाड़ी बेजती करन, उना तांई प्राथना करा। ");
INSERT INTO bht_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","जड़ा तेरिया इकी खाडिया पर थपड़ मारगा तां तू दूजी भी उस पासे करी दे, कने जड़ा तेरी चादर खोई ले, उसयो अपणा कुरता देणे ला भी मत रोक। ");
INSERT INTO bht_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","जड़ा कोई तिजो ला मंगे, उसयो देई दे; कने जड़ा तेरी चिज खोई ले, उसला मंगदा मत। ");
INSERT INTO bht_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","कने जियां तुसां चांदे न की लोक तुहांजो ने करन, तुसां भी उना ने तदिया ही करा। ");
INSERT INTO bht_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","अगर तुसां अपणे ने प्यार रखणेबाले ने प्यार रखन, तां तुहाड़ी क्या बड़ाई? क्योंकि पापी भी तां अपणे ने प्यार रखणे बालयां सोगी प्यार रखदे न। ");
INSERT INTO bht_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","कने अगर तुसां अपणे ने भलाई करणे बाले ने ही भलाई करदे न, तां तुहाड़ी कोई कजो बड़ाई करे? क्योंकि पापी भी तां इयां ही करदे न। ");
INSERT INTO bht_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","कने अगर तुसां उसयो ही उधार दिन्दे न, जिसला बापस मिलणे दी आस रखदे न, तां तुहाड़ी कोई कजो बड़ाई करे? क्योंकि पापी भी पापियां जो उधार दिन्दे न, ताकि उतणा ही बापस मिल्ले। ");
INSERT INTO bht_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","अपणे दुश्मणा ने प्यार रखा, कने भलाई करा, कने फिरी बापस नी मिलणे दी इच्छा नी रखीकरी उधार दिया; कने तुहाड़े तांई बडा इनाम होणा है; कने तुसां परम प्रधान परमेश्वर दे सन्तान बणना, क्योंकि सै उना पर जड़े परमेश्वरे दा धन्यबाद नी करदे न कने बुरे लोकां पर भी दया करदे न। ");
INSERT INTO bht_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","जियां तुहाड़ा पिता दयाबान है, तियां ही तुसां भी दयाबान बणा। ");
INSERT INTO bht_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“कुसी पर दोष मत लगा; तां तुहांजो पर भी परमेश्वरे दोष नी लगाणा: कुसी जो सजा नी देणी, तुसां भी दुजयां जो माफ करगे तां तुहांजो भी परमेश्वरे माफ करणा।” ");
INSERT INTO bht_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","दिया करा, तां तुहांजो भी मिलणा। लोकां पूरा नाप दबाई-दबाई करी कने हिलाई-हिलाई करी कने उभरदा होया तुहाड़िया गोदा च पांणा, क्योंकि जिस नापे ने तुसां नापदे न, उसी नापे ने तुहाड़े तांई भी नापया जाणा। ");
INSERT INTO bht_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","फिरी यीशुऐ उना ने न इक होर कहाणी बोली: क्या कोई अन्ना माणु, कुसी अन्ने जो रस्ता दसी सकदा है? क्या इना दोना खड्डे च नी पोंणा? ");
INSERT INTO bht_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","चेला अपणे गुरुऐ ला बडा नी होंदा, पर जड़ा कोई पूरा शिक्षित होंगा, सै ही अपणे गुरुऐ सांई होणा। ");
INSERT INTO bht_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","तू कजो अपणे भाईऐ दियां छोटियां-छोटियां गलतियां जो दिखदा है, जड़ियां उदिया हखी च पिये छोटे दे कखे सांई न, कने तिजो अपणियां बडियां-बडियां गलतियां नी मिलदियाँ, जड़ियां तेरियां हखी च इक लठे सांई न। ");
INSERT INTO bht_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","जद की तिजो अपणी ही हखी दा लठा नी मिलदा है, तां अपणे भाईये जो कियां बोली सकदा है, भाई रुक मैं तेरी हखी दे तिनके जो कडी दिन्दा है? हे कपटी मने दे लोको पेहले तां अपणी हखी दे लठे जो कडा, तां जड़ा तिनका तेरे भाईऐ दी हखी च है, उसयो ढंगे ने दिखीकरी कडी सकदे न। ");
INSERT INTO bht_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","कोई ऐसा खरा रुख नी है, जड़ा बेकार फल दे, कने ना ही तां कोई बेकार रुख है, जड़ा खरा फल दे। ");
INSERT INTO bht_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","हर कोई रुख अपणे फले ने पछयेणा जांदा है; क्योंकि लोक झिल्लां चे अंजीर नी तोड़दे न, कने ना बेरी दे झीले ला अंगूर तोड़दे न। ");
INSERT INTO bht_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","भला माणु अपणे मने दे भले भंडारे ला खरियाँ गल्लां कडदा है; कने बुरा माणु अपणे मने दे बुरे भंडारे ला बुरियाँ गल्लां ही कडदा है; क्योंकि जड़ा मने च भरुया होंदा हे सेई मुऐ च ओंदा है। ");
INSERT INTO bht_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","जालू तुसां मेरा बोलया नी मंदे, तां कजो मिंजो प्रभु-प्रभु बोलदे न? ");
INSERT INTO bht_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","जड़ा कोई मेरे बाल ओंदा है, कने मेरियां गल्लां सुणीकरी उना जो मनदा है, मैं तुहांजो दसदा है की सै कुसदे सांई है? ");
INSERT INTO bht_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","सै उस माणुऐ सांई है, जिनी घर बणादे बेले ढुगी जमीन खणीकरी पथरां दी नियां बणाईयां न, कने जालू बाढ़ आई तां पांणी उस घरे ने लग्गा, पर उसयो हिलाई नी सकया, क्योंकि सै पक्का बणया था। ");
INSERT INTO bht_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“पर जड़े सुणीकरी नी मंदे न, सै उस माणुऐ सांई न, जिनी मिटीया पर बिना नियां दा घर बणाया है, जालू उस पर पांणी लगया, तालू सै झट ढेई गिया, कने सै ढेईकरी टूटी भजी गिया।” ");
INSERT INTO bht_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","जालू सै लोकां जो अपणिया सारियां गल्लां सुणाई बैठा, तां कफरनहूम शेहर च आया। ");
INSERT INTO bht_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","कने ओथु कुसकी सूबेदारे दा इक सेवक जड़ा उदा बड़ा खास सेवक था, सै बमारिया ने मरणे बाला था। ");
INSERT INTO bht_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","उनी यीशु मसीह दे बारे च सुणया कने सुणिकरी केई बड्डे यहूदी अगुवां जो उसला ऐ बिनती करणे तांई उदे बाल भेजया, की आई करी मेरे दासे जो ठीक करी दे। ");
INSERT INTO bht_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","सै यीशु बाल आये कने उसला बड़ी बिनती करी के बोलणा लग्गे, “ऐ सेनापति इस काबील है की, तू उस तांई ऐ कम्म करे, ");
INSERT INTO bht_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","क्योंकि सै साड़िया जातियां ने प्यार रखदा है, कने उनी ही साड़े यहूदी जंज घर जो बणाया है।” ");
INSERT INTO bht_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","यीशु उना सोगी-सोगी चलया, पर जालू सै घरे ला थोड़ी दूर था, तां सुबेदारे उसयो अपणे केई साथियां बाल बोली भेजया, प्रभु जी, इतणा कष्ट मत कर, क्योंकि मैं इस लायक नी है की, तू मेरे घर आये। ");
INSERT INTO bht_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","इसा बजा ला मैं अपणे आपे जो इसी लायक नी समझया की, तेरे बाल ओऐ, पर तू बचन ही बोली दे तां ही मेरा सेवके ठीक होई जांणा। ");
INSERT INTO bht_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","मैं भी अधिकारियां दे थल्ले कम्म करणे बाला माणु है, कने मेरे अधीन सपाई कम्म करदे न, कने जालू इकी सपाईऐ जो बोलदा है कि, तू जा, तां सै चली जांदा है; कने दुऐ जो बोलदा है कि, तू ऐथू आ, तां सै आई जांदा है; कने जालू मैं अपणे नोकरे जो बोलदा, कि ऐ कर, तां सै करी दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ऐ सुणिकरी यीशु हेरान होया, कने उनी मु फेरिकरी उसा भिड़ा ने जड़ी उदे पिच्छे ओआ दी थी बोलया, “मैं तुहांजो ने बोलदा है, कि मैं इस्राएल च भी ऐदिया भरोसा नी दिखया।” ");
INSERT INTO bht_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","कने जड़े साथी भेजयो थे सै घरे बापस आये, कने उस सेवके जो दिखया तालू सै ठीक होई गिया था। ");
INSERT INTO bht_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","थोड़े रोजां बाद सै नाईन नाऐ दे इक शेहरे जो गिया, कने उदे चेले कने बड़ी भरी भीड़ उदे सोगी चलियो थी। ");
INSERT INTO bht_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","जालू सै शेहरे दे फाटके बखे पुज्जा, तां ओथु लोक इकी मुर्दे जो बाहर लेई चलयो थे कने सै अपणिया माऊ दा इकलोता पुत्र था, कने सै बिधवा थी, कने शेहरे दे मते लोक उसा सोगी थे। ");
INSERT INTO bht_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","उसा जो दिखीकरी प्रभु जो उसा पर बड़ा तरस आया, कने यीशुऐ उसा जो बोलया की, “रो मत।” ");
INSERT INTO bht_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","तालू यीशुऐ जाई करी अर्थिया जो छुता; कने जड़े अर्थिया लेईकरी चलयो थे सै रुकी गे, तालू यीशुऐ बोलया, “हे जवान, मैं तिजो बोलदा है, की उठ जा!” ");
INSERT INTO bht_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","तालू सै मुर्दा जिंदा होई गिया, कने बोलणा लगी पिया: कने उनी उसयो उदिया माऊ जो देई दिता। ");
INSERT INTO bht_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ऐ सब कुछ दिखीकरी सै सारे डरी गे; कने सै परमेश्वरे दी बड़ाई करी के बोलणा लग्गे, “साड़े बिच इक परमेश्वरे दा संदेश देणेबाला बड़ा महान माणु आया है, कने परमेश्वर अपणे लोकां दी मदद करणे तांई आया है।” ");
INSERT INTO bht_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","कने उदे बारे च ऐ गल्ल सारे यहूदिया प्रदेशे दे इलाके कने अखे-बखे दे देशे च फेली गेई। ");
INSERT INTO bht_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","कने यूहन्ना जो उदे चेलयां इना सारियां गल्लां दी खबर दिती। ");
INSERT INTO bht_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","तालू यूहन्ने अपणे चेलयां चे दो चेलयां जो सदीकरी प्रभु बाल ऐ पुछणे तांई भेजया, “की क्या तू ही मसीह है, जिसयो भेजणे दा बायदा परमेश्वरे कितया था या असां कुसी दुजे दी नियाल रखन?” ");
INSERT INTO bht_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","उना यीशुऐ बाल जाई करी बोलया की, “यूहन्ना बपतिस्मा देणेबाले सांझो तेरे बाल ऐ पूछणे तांई भेजया है, की क्या तू ही मसीह है, जिसयो भेजणे दा बायदा परमेश्वर ने कितया था या असां कुसी दुजे दी नियाल रखन?” ");
INSERT INTO bht_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","उसी बेले यीशुऐ मतयां जो बिमारियाँ कने पीड़ा, कने बुरियां आत्मा ला छुड़ाया; कने मते अन्नयां जो हखी दितियां। ");
INSERT INTO bht_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","कने यीशुऐ उना ने बोलया, जड़ा कुछ तुसां दिखया कने सुणाया है, जाई करी यूहन्ना जो बोली दिया, “की जड़े अन्ने थे उना जो मिलणा लग्गी पिया, कने जड़े लंगड़े थे सै चलदे फिरदे न, कने कोढ़ियां दा कोढ़ ठीक होइ गिया है, कने जड़े टोंणे थे सै सुणना लगी पे, कने मुर्दे जिन्दे होई जांदे न, कने कंगालां जो शुभसमाचार सुणाया जांदा है। ");
INSERT INTO bht_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","धन्य न सै, जड़े मिंजो पर शक नी करदे न।” ");
INSERT INTO bht_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","जालू यूहन्ना दे भेजयो संदेश देणेबाले दूत चली गे, तां यीशु यूहन्ना दे बारे च लोकां ने बोलणा लग्गा, की तुसां सुनसान जगा च क्या दिखणा गियो थे? क्या होआ ने हिलदे होऐ सरकंडे जो? ");
INSERT INTO bht_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","तां फिरी तुसां क्या दिखणा गियो थे? क्या नरम कपड़े लायो माणु जो? जड़ा मेंगे कपड़े पांदा है, कने ठाठ-बाठ ने मेहलां च रेंदा है। ");
INSERT INTO bht_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","तां फिरी क्या दिखणा गियो थे? क्या कुसी परमेश्वरे दा संदेश देणेबाले जो? हां, मैं तुहांजो ने बोलदा है, की तुसां परमेश्वरे दे संदेश देणेबाले ला भी बड्डे जो दिखया है। ");
INSERT INTO bht_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ऐ सै ही है, जिसदे बारे च पबित्र शास्त्रां च लिखया है: “दिख, मैं अपणे संदेश देणेबाले दूते जो तेरे अग्गे-अग्गे भेजदा है, जिनी तेरा अग्गे दा रसता तैयार करणा है।” ");
INSERT INTO bht_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“मैं तुहांजो ने बोलदा है, जड़े जनानिया ला जमयो न, उना च यूहन्ना ला बडा कोई नी: पर जड़ा परमेश्वरे दे राज्य च छोटे ला छोटा है, सै उसला भी बडा है।” ");
INSERT INTO bht_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","जालू उना यीशुऐ दियां बोलियां गल्लां जो सुणया, तां सारयां लोकां ऐथू दीकर की कर लेणेबालयां भी यूहन्ना ला बपतिस्मा लेईकरी परमेश्वरे जो सच्चा मनी लिया है। ");
INSERT INTO bht_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","पर फरीसियां कने व्यवस्था जो सिखाणे बालयां उसला बपतिस्मा लेणे ला मना करी दिता कने परमेश्वरे दिया मर्जिया जो जड़ी उना तांई थी उसा जो अपनाणे ला मना करी दिता। ");
INSERT INTO bht_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","मैं इस युगे दे लोकां दी तुलना कुसने दें कि सै कुदे सांई न। ");
INSERT INTO bht_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","सै उना जागतां सांई न, जड़े बजारां च बेईकरी इकी दुजे जो पुकारी करी बोलदे न। की असां तुहाड़े तांई खुशिया दे गाणे गाऐ, कने तुसां नचे नी; असां रोए, कने तुसां छाती नी पिटी। ");
INSERT INTO bht_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","क्योंकि यूहन्ना बार-बार बरत रखदा कने ना शराब पिन्दा था, कने सै बोलदे न कि उदे च बुरी आत्मा है। ");
INSERT INTO bht_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","मैं माणुऐ दा पुत्र खांदा पिंदा है; कने तुसां बोलदे न, दिखा, पेटू कने शराबी माणु, कने कर लेणेबालयां दा कने पापियां दा साथी है। ");
INSERT INTO bht_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“पर ज्ञान दी सच्चाई उदियां सारियां ओलादी दे सामणे आई है।” ");
INSERT INTO bht_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","फिरी कुनकी फरीसीऐ उसला बिनती किती, की मरे सोगी खाणां खा; कने यीशु उस फरीसिऐ दे घरे जाई करी रोटी खाणां बैठा। ");
INSERT INTO bht_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","कने दिखा, उस शेहरे दी इक पापी जनानिया जो जालू ऐ पता लग्गा की फरीसी दे घरे यीशु रोटी खाणां आया है, तां सै संगमरमर दे भांडे च बड़ा मेंगा इत्र लेई आई। ");
INSERT INTO bht_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","कने उदे पैरां बखे बेईकरी रोई-रोई करी, पैरां जो आंसुआं ने सेड़णा लग्गी कने अपणे बाला ने पुंजया कने उदे पैरां जो बार-बार चुमणा लग्गी कने इत्र यीशुऐ दे पैरां च मलया। ");
INSERT INTO bht_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ऐ दिखीकरी, सै फरीसी जिनी यीशुऐ जो सदया था, अपणे मने च सोचणा लग्गा, “अगर ऐ परमेश्वरे दा संदेश देणेबाला होंदा तां इसयो पता लगी जांदा, की ऐ जड़ी उसयो छुआ दी है, सै कुण है कने कदेई जनानी है? क्योंकि सै तां पापी जनानी है।” ");
INSERT INTO bht_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","यीशुऐ उदे बिचारां जो जाणी करी उना जो जबाब च बोलया, हे शमौन, मिंजो तिजो ने कुछ बोलणा है। उनी बोलया, “गुरू जी, बोला।” ");
INSERT INTO bht_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","तालू यीशुऐ इक कहाणी सुणाई, “कुसकी महाजने दे दो देंणदार थे, इक पंजसो दिना दी मजदुरिया दा कने दुआ पंजा दिना दी दियाड़ी दा देंणदार था।” ");
INSERT INTO bht_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","पर जालू उना बाल बापस करणे जो कुछ नी रिया, तां उनी महाजने दोनो जणयां दा कर्ज माफ करी दिता। उना दोनों चे कुनी उस महाजने ने जादा प्यार रखणा। ");
INSERT INTO bht_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","शमौने जबाब दिता, “मेरिया समझा च तां सै माणु जिदा जादा कर्ज माफ करी दिता।” यीशुऐ उसला बोलया, तू ठीक जबाब दिता है। ");
INSERT INTO bht_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","कने उसा जनानिया पासे फिरी करी उनी शमौने ने बोलया, “क्या तू इसा जनानिया जो दिखया इना क्या किता? मैं तेरे घरे जो आया पर तू मिंजो पैरां धोंणे तांई पाणी नी दिता, पर इना मेरे पैर आंसुआं ने धोते, कने अपणे बाला ने पूंजे।” ");
INSERT INTO bht_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","तू गले लाईकरी मेरा स्वागत नी किता, पर जालू ला मैं आया है तालू ला इना मेरी इज्जत करणा नी छडी है। ");
INSERT INTO bht_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","तू मेरे सरे च तेल नी मलया; पर इना मेरे पैरां च इतणा मेहंगा इत्र मली करी मेरा इज्जत मान किता है। ");
INSERT INTO bht_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“तांई ता मैं तिजो ने बोलदा है; की मते सारे पाप जड़े इना कितयो न, सारे माफ होऐ, क्योंकि इना जादा प्यार किता है; पर जिदा थोड़ा माफ होया है, सै घट प्यार करदा है।” ");
INSERT INTO bht_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","कने उनी जनानिया ने बोलया, “तेरे पाप माफ होऐ।” ");
INSERT INTO bht_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","तालू जड़े लोक ओथु रोटी खाणां बैठयो थे, सै अपणे-अपणे मने च सोचणा लग्गे, “ऐ कुण ऐ जड़ा पापां जो भी माफ करदा है क्योंकि परमेश्वर ही ऐ करी सकदा है।” ");
INSERT INTO bht_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","पर उनी जनानिये ने बोलया, “परमेश्वरे तिजो बचाई लिया है क्योंकि तू मिंजो पर भरोसा किता है, कने शांतिया ला चली जा।” ");
INSERT INTO bht_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","उदे बाद यीशु शेहरे-शेहरे च कने ग्रांऐ-ग्रांऐ च जाई करी प्रचार करदे होऐ कने परमेश्वरे दे राज्य दा शुभसमाचार सुणाणे लग्गा कने सै बाहरा चेले भी उदे सोगी थे। ");
INSERT INTO bht_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","कने कुछ जनानिया भी जिना जो बुरियां आत्मा कने बिमारियाँ ला ठीक कितया था, कने उना दे ना ऐ न: मरियम जड़ी मगदल ग्रां ला थी, जिसा ला सत बुरियां आत्मा निकलियाँ थियां। ");
INSERT INTO bht_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","कने राजा हेरोदेस दे भण्डारी खोजा दी घरेबाला योअन्ना कने सूसन्नाह कने मतियां जनानिया अपणिया कमाईया ने यीशु कने उदे चेलयां दी सेबा करदियां थियां। ");
INSERT INTO bht_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","जालू मती भरी भीड़ गिठी होई, कने शेहरे-शेहरे दे लोक उदे बाल चली ओंदे थे, तां उनी इक कहाणी उना जो सुणाई: ");
INSERT INTO bht_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","इक किसान अपणे खेतरे च बी रांणे तांई निकलया: रांदे बेले थोड़े बी रस्ते दे बखे पेयी गे कने सै तां पंछियां आई करी चुगी ले। ");
INSERT INTO bht_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","कने थोड़े बी पथरलिया जमिना पर पे जिथू उसयो जादा मिटी नी मिली, कने जादा मिटी नी होणे दिया बजा ने तौली लूंगी पै, कने जालू खड़ी धुप पेई, तां सै फकुई गे, क्योंकि उना दियां जड़ा डुगियां नी थियां तां सै सुकी गियां। ");
INSERT INTO bht_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","कने थोड़े बी झिल्लां च पै, कने जालू झिल्ल बदे तां उना से बी डकी ले, कने उना फल नी दिता। ");
INSERT INTO bht_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","पर थोड़े बी खरिया जमिना पर पे, कने सै बी लुंगे, कने मते सारे फल देणेबाले होए; केईयां ती गुणा, केईयां सठ गुणा, केईयां सौ गुणा फल दिता। “ऐ बोलिकरी उनी जोरे ने बोलया, जिस बाल सुणने तांई कन्न न सै ध्यान लाईकरी गल्ला जो सुणे, कने इसा गल्ला जो समझी ले।” ");
INSERT INTO bht_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","उदे चेलयाँ उसयो पुछया, “की इसा कहाणिया दा क्या मतलव है?” ");
INSERT INTO bht_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","उनी बोलया, तुहांजो परमेश्वरे दे राज्य दे भेदां जो समझणे दी समझ दितियो है, पर ऐ कहाणियां बाकियां तांई सुणादा है, इस तांई की “सै दिखदे होऐ भी ना दीखन, कने सुणदे होऐ भी ना समझन।” ");
INSERT INTO bht_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","इसा कहाणिया दा मतलब ऐ की: बी तां परमेश्वरे दा बचन है। ");
INSERT INTO bht_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","रस्ते बखे बाले सै न, जिना सुणाया; पर शैतान झट पट जादां कने उना दे मने ला बचन कडी दिन्दा है, ताकि कुथी इयां ना होये की सै भरोसा करी लेन कने उना दा उद्धार होई जा। ");
INSERT INTO bht_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","कने जड़ा पथरिलिया जमिना च राया था, ऐ सै माणु न, जड़े बचना जो सुणीकरी उना जो झट खुशिया ने ग्रहण करी लेंदे न। पर परमेश्वर दे बचना जो मने दिया गहराईया च बदणा नी दिन्दे, उदे बाद जालू बचने दिया बजा ने उना पर कला क्लेश या परेशानी होंदी है, तां सै बचना ला पिच्छे हट्टी जांदे न। ");
INSERT INTO bht_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","जड़े बी झिल्लां च पियो न, ऐ सै माणु न जिना बचन सुणया, पर सै संसारे दियां चिंता जो लेईकरी दुखी, कने संसारिक चिंजा दा लालच उना दे मने च रेंदा है, ऐ सब परमेश्वरे दे बचना च रुकावट पांदा है। कने सै बचन उना तांई फायदेमंद नी होंदा। ");
INSERT INTO bht_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","कने खरियाँ जमिना बाले बी सै न, जड़े बचन सुणीकरी भले कने खरे मने ने सम्भाली करी रखदे न, सै सबर ने फल दिन्दे न। ");
INSERT INTO bht_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","कोई दिय्या बाली करी भांडे ने नी ढकदा है, कने ना मंझे हेठ रखदा है, पर धारिया पर रखदे न, ताकि अंदर ओणे बालयां जो लौ होऐ। ");
INSERT INTO bht_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“क्योंकि जड़ा कुछ भी लुकया है, सै सामणे करणा है; कने हर इक गुप्त गल्ल सामणे आई जाणी है। ");
INSERT INTO bht_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","जिना बाल समझणे दी इच्छा है जड़ा परमेश्वर सिखांदा है, उसयो परमेश्वरे होर समझ देणी, पर जड़ा समझणे दी इच्छा नी रखदा, की मैं क्या सिखादां, तां सै जड़ा समझया है, परमेश्वरे सै भी उसला लेई लेणा।” ");
INSERT INTO bht_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","उदी माता कने उदे भाई उस बाल आऐ, पर भीड़ा दिया बजा ने मिली नी सके। ");
INSERT INTO bht_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","कने उसयो बोलया, “तेरी माता कने तेरे भाई बाहर खड़ोतयो न कने तिजो ने मिलणा चांदे न।” ");
INSERT INTO bht_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","उनी उदे जबाब च बोलया, “मेरी माता कने मेरे भाई ऐ ही न, जड़े परमेश्वरे दे बचना जो सुणदे कने मंदे न।” ");
INSERT INTO bht_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","फिरी इक रोज सै कने उदे चेले किस्तिया पर चढ़े, कने उनी उना ने बोलया, “ओआ, गलील झीला दे पार चलदे न।” कने उना किस्ति खोली दिती। ");
INSERT INTO bht_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","जालू किस्ति चलियो थी तां सै सोई गिया: कने झीला च तूफान आई गिया, कने किस्ति पाणिऐ ने भरूणा लगी पेई कने सै खतरे च थे। ");
INSERT INTO bht_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","तालू उना यीशुऐ बखे आई करी उसयो जगाया, कने बोलया, “हे स्वामी। हे स्वामी। असां डूबणा लगी पियो न।” तालू उनी उठी करी पाणिऐ कने तुफाने जो डांटया कने सै रुकी गे, कने सै शान्त होई गिया। ");
INSERT INTO bht_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","यीशुऐ उना ने बोलया, तुहाड़ा भरोसा कुथु था? पर सै डरी गे, कने हेरान होईकरी अपु चे बोलणा लग्गे, “ऐ कदिया माणु है? ऐथू दीकर की तूफान कने लैहरां भी इदा हुकम मंदे न।” ");
INSERT INTO bht_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","फिरी सै गिरासे दे लोकां दे देशे च पुज्जे, जड़ा उसी पार गलील प्रदेशे दे सामणे है। ");
INSERT INTO bht_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","जालू सै किनारे पर उतरया, तां उस ग्रांऐ दा इक माणु उसयो मिल्ला, जिदे च बुरी आत्मा थी। कने सै कपड़े नी पांदा था, कने ना घरे रेंदा था, सै कब्रिस्तान च रेंदा था। ");
INSERT INTO bht_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","सै यीशुऐ जो दुरे ला ही दिखीकरी दोड़या, कने यीशुऐ जो इज्जत देणे तांई उदे पैरां अग्गे डेई पिया। उनी जोरे ने चिलाई करी बोलया, “हे यीशु, परमपिता परमेश्वरे दे पुत्र। मिंजो तिजो ने क्या कम्म? मैं तिजो ने बिनती करदा है, मिंजो दुख ना दे।” ");
INSERT INTO bht_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","क्योंकि सै उसा बुरिया आत्मा जो उस माणुऐ ला निकलने दा हुकम दे दा था, क्योंकि सै उदे च बार-बार प्रबल होंदी थी। लोक उसयो रसियाँ कने सुंगला ने बनदे थे, तमी सै सब केसी जो तोड़ी दिन्दा था, कने बुरी आत्मा उसयो सुनसान जगा जो नठाई लेई जांदी थी। ");
INSERT INTO bht_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","यीशुऐ उसयो पुछया, “तेरा क्या ना है?” उनी बोलया, “मेरा ना सेना है, क्योंकि मतियां बुरियां आत्मा उदे च समाई गियां थियां।” ");
INSERT INTO bht_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","कने उना उसला बिनती किती की, “सांझो अथाह कुंडे च जाणे दा हुकम मत दींदा।” ");
INSERT INTO bht_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ओथु पाहड़े पर इक बड़ा बडा सूअरां दा झुण्ड चुग्गा दा था, उना उसला बिनती किती, “सांझो उना च समाणा दे।” कने यीशुऐ उना जो जाणा दिता। ");
INSERT INTO bht_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","तालू सै बुरियां आत्मा उस माणुऐ ला निकली करी सूअरां दे झुण्डे च समाई गियां कने सै झुण्ड पहाड़े ला रिड़की करी दरियाये च पेई गिया कने सारे सूअर डूबी करी मरी गे। ");
INSERT INTO bht_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","उना दे पुहालां नठी करी शेहर कने ग्रांऐ च ऐ खबर सुणाई। ");
INSERT INTO bht_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","कने जड़ा होया था लोक उसयो दिखणा आये कने जिस माणुऐ ला बुरियां आत्मा निकलियाँ थियां, उसयो यीशुऐ बखे कपड़े पाइकरी कने ठीक -ठाक बैठया दिखीकरी सै डरी गे। ");
INSERT INTO bht_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","कने दिखणे बालयां उना जो दसया, की सै बुरियां आत्मा ने सताया होया माणु कियां ठीक होया। ");
INSERT INTO bht_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","तालू गिरासे दे लोकां दे देशे अखे-बखे दे लोकां यीशुऐ ने बिनती किती, की साड़े ऐथू ला चली जा: क्योंकि सै बड़े डरी गियो थे। कने सै किस्तिया पर चढ़ी करी चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","जिस माणुऐ चे बुरियां आत्मा निकलियाँ थियां, सै यीशुऐ ने बिनती करणा लग्गा, की मिंजो अपणे सोगी रेंणा दे, पर यीशुऐ उसयो भेजी करी बोलया। ");
INSERT INTO bht_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“की अपणे घरयो बापस चली जा कने लोकां ने बोली दे, की परमेश्वरे तेरे तांई कदे बड्डे-बड्डे कम्म किते न।” कने सै जाई करी सारे शेहरे च प्रचार करणा लग्गा, की यीशुऐ मेरे तांई कदे बड्डे-बड्डे कम्म किते न। ");
INSERT INTO bht_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","जालू यीशु बापस ओआ दा था, तां लोक उसला खुशिया ने मिल्ले; क्योंकि सै यीशुऐ जो निय्याला दे थे। ");
INSERT INTO bht_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","यहूदी जंज घर दे सरदारां चे इक याईर नाये दा सरदार आया, सै यीशुऐ दी इज्जत मान तांई यीशुऐ दे पैरां अग्गे डेई पिया, कने उनी ऐ बोली करी बड़ी बिनती किती, “मेरे घरे जो चल।” ");
INSERT INTO bht_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","क्योंकि उदी बाहरां सालां दी इक ही कुड़ी थी, कने सै मरणे बाली थी। जालू सै चलदा था, तां लोक यीशुऐ पर डेई पोंदे थे। ");
INSERT INTO bht_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","कने इक जनानी जिसा जो बाहरां सालां ला खून चलणे दी बिमारी थी, कने उना अपणी सारी कमाई वेद्यां पिच्छे खर्ची बैठियो थी कने तमी कूदे भी हथे ला ठीक नी होइयो थी, ");
INSERT INTO bht_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","उना पिच्छे ला आई करी उदे कपड़े दे कुंणे जो छुता, झट उसा दा खून निकलन बंद होई गिया। ");
INSERT INTO bht_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","इस पर यीशुऐ बोलया, मिंजो कुनी छूता? जालू सारे मुकरणा लग्गे, तां पतरस कने उदे साथियां बोलया, “हे स्वामी, तू दिखा दा हे की तेरे अखे बखे इतणी भरी भीड़ है, कने तिजो पर ढेई पोंदे न।” ");
INSERT INTO bht_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","पर यीशुऐ बोलया, “कुनकी मिंजो छुता है मिंजो पता लगी गिया है की मिंजो ला शक्ति निकली है।” ");
INSERT INTO bht_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","जालू जनानिया दिखया, की मैं लुकी नी सकदी, तालू कमदी होई आई, कने उदे पैरां पर पेईकरी सारे लोकां सामणे दसया, की मैं तिजो कजो छुता है, कने कियां मैं झट ठीक होई गेई। ");
INSERT INTO bht_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","उनी उसा जो बोलया, “बेटी तेरा भरोसा जड़ा मिजों पर था उनी भरोसे तिजो ठीक कितया है, शांतिया ला चलिया।” ");
INSERT INTO bht_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","यीशु हले उसा ने गल्ल करा दा ही था, यहूदी जंज घरे दे सरदारे दे घरे ला कुछ लोकां आई करी बोलया, “की तेरी कुड़ी तां मरी गेई है” हुण गुरुऐ जो कजो तकलीफ दे दा है? ");
INSERT INTO bht_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","जड़ी गल्ल सै बोला दे थे, उसा गल्लां जो यीशुऐ अंणसुणी करिके यहूदी जंज घर दे सरदारे जो बोलया, “डर मत, सिर्फ मिजों पर भरोसा रख, तां उना ठीक होई जाणा।” ");
INSERT INTO bht_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","घरे आई करी उनी पतरस, कने यूहन्ना, कने याकूब कने कुड़िया दे माता-पिता जो छडी करी होर कुसयो भी अंदर नी ओणा दिता। ");
INSERT INTO bht_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","कने सारे उसा तांई रोआ दे थे, पर उनी बोलया, “रोआ मत; सै मरियो नी है पर सुतियो है।” ");
INSERT INTO bht_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","सै ऐ जाणी करी, की मरी गियो है उदा मजाक उड़ाणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","पर उनी उसा कुड़िया दा हथ पकड़या कने पुकारिकरी बोलया, “हे कुड़ी उठ।” ");
INSERT INTO bht_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","तालू उदे प्राण बापस आई गे कने सै झट उठी बैठी; फिर उनी हुकम दिता की, इसा जो कुछ खाणे जो दीया। ");
INSERT INTO bht_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","उसा दे माता-पिता हेरान होऐ, पर उनी उना जो चेतावनी दिती, की ऐ जड़ा होया है, सै कुसी ने मत बोलदे। ");
INSERT INTO bht_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","फिरी यीशुऐ उना बाहरां चेलयां जो सदिकरी उना जो सारियां बुरियां आत्मा जो कडणे कने बमारियाँ जो दूर करणे दी शक्ति कने हक दिता। ");
INSERT INTO bht_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","कने उना जो परमेश्वरे दे राज्य दा प्रचार करणे, कने बिमारियाँ जो ठीक करणे तांई भेजया। ");
INSERT INTO bht_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","कने उनी उना ने बोलया, की अपणे रस्ते तांई सिर्फ इक सोठी लेनयो। ना तां खाणे तांई रोटी लेणी, ना तां झोला, ना ही बटुए च पेसे, पर जुते पाई लेनयो कने होर कोई कपड़े पाणे तांई मत लेंदे। ");
INSERT INTO bht_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","अगर कोई तुहांजो अपणे घरे रेहणे तांई सदगा, जालू दीकर तुसां उसी ग्रांऐ च रेंगे, तालू दीकर उसी दे घरे च परोणे बणी करी रुकी रिया। ");
INSERT INTO bht_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“जिसा जगा दे लोक तुहांजो अपनांगे नी कने तुहाड़ी सुणगे नी, ओथु ला जांदे बेले अपणे पैरां दी धुड़ जाड़ी दिनयो, ताकि उना लोकां जो पता लग्गे की परमेश्वरे दिया तरफा ला मिलणे बाली सजा दे सै अपु ही जिम्मेबार न।” ");
INSERT INTO bht_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","सै निकलिकरी ग्रांऐ-ग्रांऐ च जाई करी शुभसमाचार सुंणा दे, कने हर कुथी लोकां जो ठीक करदे फिरदे थे। ");
INSERT INTO bht_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","कने देशे दी चौथाई दा राजा हेरोदेस ऐ सारा कुछ सुणिकरी घबराई गिया, क्योंकि मतयां बोलया, की यूहन्ना मरी करी जिन्दा होई गिया है। ");
INSERT INTO bht_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","कने मतयां ऐ बोलया, की एलिय्याह दिखया है: कने केईयां बोलया की पराणे परमेश्वरे दा संदेश देणेबाले चे कोई जिन्दा होया है। ");
INSERT INTO bht_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","पर राजा हेरोदेसे बोलया, “यूहन्ना बपतिस्मा देणेबाले दा तां मैं सिर कटबाया था तां हुण ऐ कुण है, जिसदे बारे च ऐसिया गल्लां सुणादा मैं?” कने हेरोदेसे जो उसयो दिखणे दी इच्छा होई। ");
INSERT INTO bht_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","जालू सै प्रेरित जिना जो यीशुऐ भेजया था, सै यीशुऐ बाल मुड़ी करी आये कने उदे चारों बखे खड़ोई, कने जड़ा कुछ उना किता, कने सिखया था, उसयो दसी दिता, कने सै उना जो लग करिके बैतसैदा नाऐ दे इकी शेहरे जो लेई गिया। ");
INSERT INTO bht_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ऐ जाणी करी भीड़ उदे पिच्छे चली पेई, कने सै खुशिया ने उना ने मिला, कने उना सोगी परमेश्वरे दे राज्य दियां गल्लां करणा लग्गा, कने जड़े ठीक होणा चांदे थे उना जो ठीक किता। ");
INSERT INTO bht_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","जालू संज होणा लग्गी, तां उना बाहरां आई करी उसयो बोलया, “भिड़ा जो बिदा कर, ताकि असां अखे बखे दे ग्रां कने बस्तियां च जाई करी अपणे रेणें तांई कने रोटिया दा इंतजाम करन, क्योंकि असां ऐथू सुनसान जगा च न।” ");
INSERT INTO bht_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","यीशुऐ उना जो बोलया, “तुसां ही उना जो खाणे जो दिया।” उना बोलया, “साड़े बाल पंज रोटियां कने दो मछियां जो छडी करी कुछ होर कुछ नी है; पर हाँ, अगर असां जाई करी इना सारयां लोकां तांई रोटियां खरीदी लेई ओन, तां होई सकदा है।” ");
INSERT INTO bht_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(क्योंकि ओथु लगबग पंज हजार मर्द थे।) कने उनी अपणे चेलयां ने बोलया, उना जो पंजा-पंजा करिके झुण्डा च बठाई दिया। ");
INSERT INTO bht_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","उना तियां ही किता, कने सबना जो बठाई दिता। ");
INSERT INTO bht_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","तालू उनी सै पंज रोटियां कने दो मछियां लिईयां, कने स्वर्गे पासे दिखीकरी धन्याबाद किता, कने तोड़ी-तोड़ी करी चेलयां जो दिन्दा गिया ताकि सै लोकां जो परोसी देंन। ");
INSERT INTO bht_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","सारे खाई करी रजी गे। कने जालू रोटी खायी बैठे तालू चेलयां बाकी बचियाँ रोटियां कने मछियां गिठेरेइयां कने उसला बाहरा टोकरियाँ भरुई गियां। ");
INSERT INTO bht_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","जालू यीशु एकांत च प्राथना करा दा था, कने चेले उदे सोगी थे, तां उनी उना ला पुछया, “लोक मिंजो क्या बोलदे न?” ");
INSERT INTO bht_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","चेलयां जबाब दिता कुछ लोक बोलदे ने कि तुसां यूहन्ना बपतिस्मा देणेबाले न; पर कोई-कोई बोलदे एलिय्याह है, कने कोई-कोई बोलदे न कि पुराणे जमाने दे परमेश्वरे दा संदेश देणेबालयां चे कोई इक है। ");
INSERT INTO bht_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","यीशुऐ उना ला पुछया, “पर तुसां मिंजो क्या बोलदे न?” “पतरसे जबाब दिता, परमेश्वरे दा मसीहा।” ");
INSERT INTO bht_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","तालू यीशुऐ उना जो समझाई करी बोलया, “ऐ कुसी ने मत बोलदे।” ");
INSERT INTO bht_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","कने उनी बोलया, कि मैं, जड़ा माणुऐ दा पुत्र है, “मिंजो मते दुख सेहणे पोणे न, कने यहूदी अगुवे, बड्डे याजकां, कने यहूदी व्यवस्था जो सिखाणे बालयां मिंजो अपनाणा नी है, कने मैं मारया जाणा है, कने फिरी मैं तिन्ना रोजां बाद मरयां चे जिन्दा होई जाणा है।” ");
INSERT INTO bht_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","यीशुऐ उना सबना जो बोलया, “जड़ा कोई मेरा चेला बनणा चांदा है, उसयो अपणिया शरीरे दियां इच्छां कने जड़ियां तरकिबां बणाईयां न उना जो छडी करी! कने जड़े मिजों तांई मरणे जो तैयार रेंदे न सेई मेरे चेले बणी करी मिजों पिच्छे चली सकदे न। ");
INSERT INTO bht_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","कोई माणु ऐसा नी करगा कने अपणे प्राणा जो बचाणा चांहगा, उनी परमेश्वरे सोगी आत्मिक जिन्दगी जिणे दा मोका गबाई देणा है। पर जड़ा माणु मिजों पर भरोसा करगा कने मेरे शुभसमाचार दिया बजा ने मरगा उस माणुऐ जो परमेश्वरे सोगी सदा तांई दी जिन्दगी मिलणी। ");
INSERT INTO bht_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","अगर तुसां संसारे दा सब कुछ पाई लेंगे कने पर परमेश्वरे सोगी हमेशा दी जिन्दगी जिणे दा मोका गवाई दिंगे, तां उदा क्या फायदा? इक माणु परमेश्वरे जो क्या देई सकदा है, जड़ा उदी हमेशा दी जिन्दगी खरिदगा? कुछ नी! ");
INSERT INTO bht_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","तुहाड़े च अगर कोई माणु मिजों अपणा परमेश्वर कने मेरियां शिक्षा दा पालन करणे जो मना करदा है, क्योंकि तुसां डरदे न की गैर विश्वासी कने पापी लोकां तुहाड़ा मजाक उड़ाणा। फिरी जालू मैं माणुऐ दा पुत्र, पबित्र स्वर्गदूतां सोगी धरती पर ओणा है, तां मैं उना लोकां जो भी अपणा चेला मनणे ला मना करी देणा है, तालू सारयां लोकां मरी महिमा दिखणी जड़ी मेरे पिता दी है।” ");
INSERT INTO bht_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“मैं तुसां ने सच्च बोलदा है, की जड़े ऐथू खड़ुतयो न, उना चे कोई-कोई ऐसे न, की जालू दीकर परमेश्वरे दा राज्य नी दिखी लेंगे, तालू दीकर उना मौत दा स्वाद नी चखणा है।” ");
INSERT INTO bht_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","इना गल्लां दे कोई अठ रोज बाद सै पतरस, कने यूहन्ना कने याकूब जो सोगी लेईकरी प्राथना करणे तांई पहाड़े पर गिया। ");
INSERT INTO bht_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","जालू सै प्राथना करा दा ही था, तां उदे चेहरे दा रूप बदलुई गिया, कने उदे कपड़े चिट्टे होईकरी चमकणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","कने दिखा, दो परमेश्वरे दे संदेश देणेबाले मूसा कने एलिय्याह जो, जड़े बड़े पेहले जिन्दा थे उना जो यीशुऐ सोगी गल्लां करदे दिखया। ");
INSERT INTO bht_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ऐ महिमा सोगी मिल्ले, कने उदे मरणे दी चर्चा करा दे थे, जड़ा यरूशलेम च होणेबाला था। ");
INSERT INTO bht_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पतरस कने उदे साथी निंद्रा ने भरुयो थे, जालू ढंगे ने उठी होऐ, तां उदी महिमा; कने उना दो आदमियां जो, जड़े उदे बखे खड़ुतयो थे, दिखया। ");
INSERT INTO bht_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","जालू सै उदे बखे ला जाणा लग्गे, तां पतरसे यीशुऐ जो बोलया, “प्रभु जी, साड़ा ऐथू रेंणा ठीक है, इस तांई असां ऐथू तीन तम्बू बणांदे न, इक तेरे तांई, इक मूसा तांई, इक एलिय्याह तांई।” पतरसे ऐ इस तांई बोलया की, सै कने दुज्जे दो चेले डरी गियो थे, कने नी जाणदे थे क्या बोलणा क्या करणा। ");
INSERT INTO bht_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","सै ऐ बोला दा ही था, की इक बदले आई करी उना जो डकी लिया, जालू सै उस बदले ने घिरणा लग्गे तां सै डरी गे। ");
INSERT INTO bht_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","कने उस बदले चे ऐ अबाज निकली, “ऐ मेरा प्यारा पुत्र है, कने मैं इसला खुश है, कने जड़ा ऐ बोलदा है उसयो ध्याने ने सुणा।” ");
INSERT INTO bht_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ऐ अबाज होंदे ही यीशुऐ जो उना किल्ला दिखया; कने सै चुप रे, कने जड़ा कुछ उना दिखया था, उदी कोई गल्ल उना रोजा च कुनी नी किती। ");
INSERT INTO bht_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","कने दुऐ रोजे जालू सै पहाड़े ला उतरे, तां इक बड़ी बडी भीड़ उसला मिलणा आई। ");
INSERT INTO bht_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","तालू भिड़ा चे इक माणुऐ जोरे ने बोलया, गुरू जी, मैं तिजो ने बिनती करदा है, की मेरे पुत्रे पर दया कर; क्योंकि सै मेरा इकलोता पुत्र है। ");
INSERT INTO bht_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","कने इक बुरी आत्मा उसयो पकड़ी लेंदी है, कने सै इकदम बकणा लगी पोंदा है, कने सै आत्मा उसयो ऐसा मरोड़दी है, की उदे मुऐ ला झाग निकली पोंदा है; कने उसयो गरेची करी बड़िया मुशकिला ने छडदी है। ");
INSERT INTO bht_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","कने मैं तेरे चेलयां ने बिनती किती, की इसा जो कडी दिया; पर सै कडी नी सके। ");
INSERT INTO bht_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ऐ सुणीकरी यीशुऐ उना जो जबाब दिता, “हे अविश्वासी लोकों, मैं कालू दीकर तुहाड़े सोगी रेंगा, कने कालू दीकर तुहाड़े अविश्वास जो सेहन करगा उसी जागते जो मेरे बाल लोआ।” ");
INSERT INTO bht_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","सै ओआ दा ही था की बुरिया आत्मा उसयो पटकी करी मरोड़या, पर यीशुऐ बुरिया आत्मा जो डांटया कने जागते जो ठीक करिके उदे पिता जो देई दिता। ");
INSERT INTO bht_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","तालू सारे लोक परमेश्वरे दी इसा शक्तिया ला हेरान होऐ। पर जालू सारे लोक उना सारे कम्मा ने जड़े सै करदा था, हेरान होआ दे थे, तां उनी अपणे चेलयां ने बोलया, ");
INSERT INTO bht_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ऐ गल्लां तुसां मत भुलदे, क्योंकि माणुऐ दा पुत्र, मेरे दुशमणा दे हथे पकड़ाया जाणा है।” ");
INSERT INTO bht_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","पर ऐ गल्ल उना दिया समझा च नी आई, कने ऐ उना ला छिपी रेई; ताकि उना जो पता नी लग्गे, कने सै इसा गल्ला दे बारे च पुछणे ला डरदे थे। ");
INSERT INTO bht_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","फिरी उना च ऐ बेहस होणा लग्गी की, की सांझो चे बडा कुण है? ");
INSERT INTO bht_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","पर यीशुऐ उना दे मने दी गल्ल जाणी लेई, कने इक बच्चे जो लेईकरी अपणे बखे खड़ेरया, ");
INSERT INTO bht_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","कने उना ने बोलया, “जड़ा कोई मेरे नाऐ ने इस बच्चे जो अपनांदा है, सै मिंजो अपनांदा है, कने जड़ा कोई मिंजो अपनांदा है, सै मिंजो भेजणे बाले जो अपनांदा है, क्योंकि जड़ा तुहाड़े चे सबना ला छोटा है, सेई बडा है।” ");
INSERT INTO bht_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","तालू यूहन्ने बोलया, “प्रभु जी, असां इकी माणुऐ जो तेरे नाए दिया शक्तिया ने बुरियां आत्मा जो कडदे दिखया है, कने असां उसयो मना भी किता, क्योंकि सै साड़े सांई तेरा चेला नी था।” ");
INSERT INTO bht_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","यीशुऐ उसयो बोलया, “उसयो मना मत करा; क्योंकि जड़े साड़े बैरी नी है, सै साड़े सोगी साथी न।” ");
INSERT INTO bht_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","जालू यीशुऐ दे स्वर्ग जाणे दे दिन पुरे होणे बाले थे, तालू उनी यरूशलेम जाणे दा बिचार पका किता। ");
INSERT INTO bht_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","यीशुऐ ओथु जाणे ला पेहले अपणे अग्गे संदेश देणेबाले दूत भेजे: सै सामरियों दे इक ग्रांऐ जो गे, ताकि उदे तांई जगा तैयार करन। ");
INSERT INTO bht_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","पर उना लोकां उसयो उतरणा नी दिता, क्योंकि सै यरूशलेम शेहरे जो चलया था। ");
INSERT INTO bht_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ऐ दिखीकरी उदे चेलयां याकूब कने यूहन्ना ने बोलया, “प्रभु जी; क्या तू चांदा है, की असां हुकम देन, की अम्बरे ला अग्ग पोये कने उना जो भस्म करी दे?” ");
INSERT INTO bht_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","पर यीशुऐ उना जो मुड़ी करी डांटया कने बोलया, “तुसां नी जाणदे न की तुसां कदेई आत्मा दे न। ");
INSERT INTO bht_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","क्योंकि माणुऐ दा पुत्र लोकां दे प्राणा जो खत्म करणे तांई नी पर बचाणे तांई आया है।” कने सै कुसकी होरसी ग्रांऐ जो चली गे। ");
INSERT INTO bht_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","जालू सै रस्ते च चलयो थे, तालू कुनकी उसयो बोलया, “जिथू-जिथू तू जांगा, मैं भी तेरे पिच्छे जाणा।” ");
INSERT INTO bht_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","यीशुऐ उसयो बोलया, “लोमड़ियां जो रेहणे तांई कुडी न, कने अम्बरे दे पंछियां दे घोंसले होंदे न; पर मिंजो, माणुऐ दे पुत्रे बाल इक भी घर नही है, जिथू मैं सोई सकें।” ");
INSERT INTO bht_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","उनी दूऐ ने बोलया, “मेरे चेले बणी जा।” उनी बोलया, “प्रभु जी, मिंजो पेहले जाणा दे ताकि मैं अपणे पिता जो दबी ओऐ।” ");
INSERT INTO bht_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","उनी उसला बोलया, “जड़े लोक आत्मिक रुपे ने मरयो न, उना जो अपणे मुर्दे दबाणा दे, पर तू जाई करी परमेश्वरे दे राज्य दा शुभसमाचार सुंणा।” ");
INSERT INTO bht_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","इक होरनी बन्दे बोलया, “प्रभु जी, मैं तेरे पिच्छे ओंगा; पर पेहले मिंजो जाणा दे ताकि मैं अपणे घरे दे लोकां ने बिदा लेई ओंऐ।” ");
INSERT INTO bht_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","यीशुऐ उसयो बोलया, “जड़ा कोई अपणा हथ हले पर रखीकरी पिच्छे दिखदा है, सै परमेश्वरे दे राज्य जोगी नी है।” ");
INSERT INTO bht_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","इदे बाद प्रभुऐ सत्तर होर चेले रखे कने जीसी-जीसी शेहरे कने जगा पर उनी अपु जाणे दी योजना बणाईयो थी ओथु उना जो दो-दो करिके अग्गे भेजया। ");
INSERT INTO bht_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","कने उनी उना जो बोलया, “पकियो फसला दे खेतर बड़े न; पर मजदूर थोड़े न: इस तांई खेतरे दे मालिके ने बिनती करा, की सै अपणे खेतरां जो बडणे तांई मजदूर भेजी दे।” ");
INSERT INTO bht_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","जा; दिखा मैं तुहांजो भेडां सांई भेड़ियां दे बिच भेजदा है। ");
INSERT INTO bht_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","इस तांई ना बटुआ, ना झोली, ना जुते; कने ना ही रस्ते च कुसयो नमस्ते करा। ");
INSERT INTO bht_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","जिसदे भी घरे जा, पेहले बोला, इस घरे दा कल्याण हो। ");
INSERT INTO bht_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","अगर ओथु कोई मेहमाना दा आदर करणे बाला होंगा; तां तुहाड़ी आशीष उस पर होणी, नी तां तुहाड़े बाल बापस आई जाणी। ");
INSERT INTO bht_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","उसी घरे च रिया, उस घरे ला तुहांजो जड़ा कुछ मिलदा है, सेई खा पिया; क्योंकि मजदूरे जो तां अपणी मजदूरी मिलणा चाईदी; घरे-घरे मत फिरदे। ");
INSERT INTO bht_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","कने जिसी शेहरे च जांगे, कने ओथु दे लोक तुहांजो अपणे घरे खुशिया ने अपनांगे, तां जड़ा कुछ तुहाड़े सामणे रखगे सै ही खा। ");
INSERT INTO bht_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ओथु दे बिमारां जो ठीक करा: कने उना जो बोलणा, परमेश्वरे दा राज्य तुहाड़े बखे आई रिया है। ");
INSERT INTO bht_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","पर जिस शेहरे च जांगे, कने ओथु दे लोक तुहांजो अपनांगे नी, तां उना दे बजारां च जाई करी बोला, ");
INSERT INTO bht_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","तुहाड़े शेहरे दी धुड़ भी, जड़ी साड़े पैरां च लगियो है, असां तुहाड़े सामणे झाड़ी दिन्दे न, तमी ऐ समझी लिया, की परमेश्वरे दा राज्य तुहाड़े बखे आई रिया है। ");
INSERT INTO bht_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“मैं तुसां ने सच्च बोलदा है, की न्याय बाले रोजे सै शेहरे जिथू दे लोक परमेश्वरे दा बचन नी मंदे, उना दी हालत सदोम दे लोकां दी हालत ला भी जादा भयानक होणी है।” ");
INSERT INTO bht_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“हाय! खुराजीन शेहर कने बैतसैदा शेहर दे लोको! जड़े अनोखे कम्म तुहाड़े शेहरे च कितयो न, अगर सै कम्म सूर कने सैदा शेहरे च किते जांदे, तां सै ऐ दसणे तांई की उना अपणे पापां ला पश्चाताप करी लिया है, तां बड़े पेहले टाट ओढ़ी लेंदे, कने धुड़ी अपणे उपर छिड़की लेंदे।” ");
INSERT INTO bht_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","की परमेश्वरे दे न्याय दे रोज जड़ी सजा सूर कने सैदा शेहरे दे लोकां जो देणी है, सै सजा तुहाड़िया सजा ला घट होणी है। ");
INSERT INTO bht_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","हे कफरनहूम शेहरे दे लोको तुसां क्या स्वर्गे दीकर उच्चे किते जाणे न? तुसां तां पताल लोक दीकर थले किते जाणे न। ");
INSERT INTO bht_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“जड़ा तुहाड़ी सुणदा है, सै मेरी सुणदा है, जड़ा तुहांजो तुच्छ समजदा है, सै मिंजो भी तुच्छ समझदा है; कने जड़ा मिंजो तुच्छ समजदा है, सै मेरे भेजने बाले जो भी तुच्छ समजदा है।” ");
INSERT INTO bht_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","सै सत्तर चेले खुशिया ने बापस आई करी बोलणा लग्गे, प्रभु जी, बुरियां आत्मा भी साड़ी गल्ल मन्नी जालू असां उना जो तेरे नाऐ ने हुकम दिता। ");
INSERT INTO bht_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","यीशुऐ उना ने बोलया, जालू बुरियां आत्मा तुहाड़ा हुकम मनया, तां मैं शैताने जो बिजलिया सांई स्वर्गे ला पोंदे दिखया। ");
INSERT INTO bht_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","मैं तुहांजो सपां कने बिच्छुआं जो मारणे, कने शैताने दी शक्तिया पर हक दितया है; कने कुसा भी चीजा ने तुहांजो कोई नुकसान नी होणा। ");
INSERT INTO bht_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","पर तुसां इसला खुश मत होआ, की बुरियां आत्मा तुहाड़ा हुकम मंदियां न, पर इसला खुश होआ की तुहाड़े ना स्वर्गे च लिखयो न। ");
INSERT INTO bht_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","तालू सै पबित्र आत्मा च होईकरी खुश होई गिया, कने बोलया, पिता जी, स्वर्गे कने धरतिया दे प्रभु, मैं तेरा धन्यबाद करदा है, की तू इना गल्लां जो ज्ञानिया कने समजदारां ला लुकाई रखया, कने बचयां पर प्रगट कितया है, पिता जी, क्योंकि तिजो ऐई खरा लग्गा। ");
INSERT INTO bht_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“मेरे पिता मिंजो सब कुछ देई दितया है; कने कोई नी जाणदा है की पुत्र कुण है सिर्फ पिता ही जाणदा है, कने पिता कुण है ऐ भी कोई नी जाणदा, सिर्फ पुत्र जाणदा कने सै जिदे पर पुत्र उसयो प्रकट करणा चांगा।” ");
INSERT INTO bht_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","तालू यीशुऐ चेलयां पासे मुड़ी करी उना जो एकांत च बोलया, “धन्य न सै हखी, जड़ियां गल्लां तुसां दिखदे न उना गल्लां जो सै भी दिखदियां न। ");
INSERT INTO bht_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","क्योंकि मैं तुहांजो ने बोलदा है, की परमेश्वरे दे संदेश देणेबाले मते लोक कने राजे चांदे थे, की जड़ियां गल्लां तुसां दिखदे न उना जो दिखा; पर नी दिखियां कने जड़ियां गल्लां तुसां सुणदे न उना जो सुंणा, पर नी सुणियां।” ");
INSERT INTO bht_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","इक दिन जालू यीशु लोकां जो सिखा दा था तां इक यहूदी मूसा दी व्यवस्था जो सिखाणे बालयां चे उठया; कने ऐ बोली करी उदी परख लेंणा लग्गा, “गुरू जी, हमेशा दी जिन्दगिया दा बारिस बणने तांई मैं क्या करे?” ");
INSERT INTO bht_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","यीशुऐ उसयो बोलया, “मूसा दी व्यवस्था च क्या लिखया है? तू उना जो कियां समझदा है?” ");
INSERT INTO bht_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","उनी जबाब दिता, “तू अपणे प्रभु परमेश्वरे सोगी अपणे सारे तन मन कने अपणे सारे प्राण कने अपणे सारे जोरे ने कने अपणिया सारिया अकला ने प्यार कर; कने अपणे पड़ोसिये ने अपणयां सांई प्यार रख।” ");
INSERT INTO bht_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","यीशुऐ उसयो बोलया, “तू ठीक जबाब दिता, ऐई कर तां तिजो हमेशा दी जिन्दगी मिलणी।” ");
INSERT INTO bht_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","पर उनी अपणे कम्मा जो सही ठेहराणे तांई यीशुऐ ला पुछया, तां मेरा पड़ोसी कुण है? ");
INSERT INTO bht_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","यीशुऐ उसयो इक कहाणिया दे जरिये जबाब दिता, इक माणु यरूशलेम शेहर ला यरीहो शेहर जो चलया था, कने डाकुयाँ उस पर हमला करी दिता कने उदे कपड़े उतारी दिते, कने उसयो मारी-कुट्टी करी अदमरा करी के छडी गे। ");
INSERT INTO bht_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","कने इयां होया की उस रस्ते चे इक यहूदी याजक चलया था, पर याजके उसयो दिखीकरी उदी कोई मदद नी किती कने ओथु ला चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","इयां ही इक लेवी जड़ा यहूदी मंदरे च कम्म करदा था उसा जगा पर आया, उनी भी उसयो दिखीकरी उदी कोई मदद नी किती कने दुज्जे पासे ला चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","पर इक सामरिया प्रदेश दा इक माणु उसा जगा ला निकलया जिथू सै जख्मी माणु पिया था, उसयो दिखीकरी उस पर तरस आई गिया। ");
INSERT INTO bht_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","कने उदे बखे आई करी उनी उदे जखमा पर तेल कने दाखरस लाईकरी पट्टी बन्नी, कने अपणिया सवारिया पर चड़ाई करी उसयो संरा च लेई गिया, कने उदी सेबा किती। ");
INSERT INTO bht_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","दूऐ रोजे उनी दो दीनार (दो दीनार मतलब दो दिना दी मजदूरी) देईकरी उसा सरां दे मालके जो दिते, कने बोलया, इसदी सेबा करनयो, कने जड़ा कुछ तेरा होर लगगा, सै मैं तिजो बापस आई करी देई दिंगा। ");
INSERT INTO bht_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","तालू यीशुऐ पुछया “हुण तेरिया समझा च जिस पर डाकुआं हमला कितया था, उदा इना तिन्ना चे पड़ोसी कुण होया?” ");
INSERT INTO bht_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","उनी बोलया, “सै ही जिनी उस पर तरस खादा था।” यीशुऐ उसयो बोलया, “जा, तू भी इयां ही कर।” ");
INSERT INTO bht_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","यीशु कने उदे चेले जालू चलयो थे, तां सै इक ग्रांऐ च गिया, ओथु मार्था नाऐ दी इकी जनानिया उसयो अपणे घरे ओंणे दा नियोता दिता। ");
INSERT INTO bht_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","कने मरियम नाऐ दी उसा दी इक बेंहण थी; सै प्रभु दे पैरां बखे बेईकरी उदी शिक्षा जो सुणा दी थी। ");
INSERT INTO bht_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","पर मार्था रोटियां बणादे-बणादे घबराई गेई कने उदे बखे आई करी बोलणा लग्गी, प्रभु जी, क्या तिजो जरा भी चिंता नी है की मेरिया बेंहणा मिंजो सारे कम्म करणे तांई किल्ला छडी दितया है? इस तांई उसा जो बोल, की मेरी मदद कर। ");
INSERT INTO bht_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","यीशुऐ उसा जो जबाब दिता, “मार्था, हे मार्था; तू बड़ियां गल्लां तांई चिन्ता करदी कने घबरांदी है। ");
INSERT INTO bht_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","पर इक ही गल्ला दी चिंता करणे दी जरूरत है, कने मरियमा से कम्म तोपी लिया है, कने इसा जो इसला दूर नी किता जाणा है।” ");
INSERT INTO bht_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","यीशु कुसकी जगा पर प्राथना करा दा था। कने जालू सै प्राथना करी बैठा, तां उदे चेलयां चे इकी चेले उसयो बोलया, “प्रभु जी, जियां यूहन्ने अपणे चेलयां जो प्राथना करणा सिखया है तियां ही सांझो सिखाई दे।” ");
INSERT INTO bht_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","यीशुऐ उना ने बोलया, तुसां इस तरीके ने प्राथना करणा चाइदी की: है साड़े पिता परमेश्वर, जड़ा तू स्वर्गे च है; तेरा ना सारे लोकां च पबित्र मनया जा, कने तेरा राज्य सांझो च ओऐ। ");
INSERT INTO bht_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","सांझो हर रोज सै खाणा दे जड़ा सांझो उस दिने तांई चाईदा है। ");
INSERT INTO bht_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","कने जियां असां सांझो सोगी गलत करणे बालयां जो माफ कितया है, तियां ही तू भी साड़ियां गलतियां जो माफ कर कने सांझो परख च फसणे ला बचा। ");
INSERT INTO bht_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","कने यीशुऐ उना ने बोलया, तुसां चे कुण है, जिसदा इक मित्र हो, कने सै अधिया राती जो उदे घरे जाई करी उसयो बोले, मिंजो तिन्न रोटियां दे। ");
INSERT INTO bht_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","क्योंकि मेरा इक मित्र हुणी मिंजो मिलणे तांई आया है कने मिंजो बाल उसयो खुआणे तांई कुछ नी है। ");
INSERT INTO bht_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","कने सै अंदरे ला जबाब दिन्दा है, मिंजो तंग मत कर; हुण तां दरबाजा बंद है, कने मेरे बच्चे मेरे सोगी बिस्तरे च सुतयो न, इस तांई मैं उठीकरी तिजो कुछ नी देई सकदा। ");
INSERT INTO bht_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","मैं तुहांजो ने जड़ा बोलदा है उसयो समझा, अगर सै उदा मित्र होणे पर भी उसयो उठी करी री नी देणा चा, फिरी भी उस दोस्ते दे बार-बार बिनती करणे पर उदिया जरुरतां दे अनुसार उतणा उठी करी जरुर दिंगा। ");
INSERT INTO bht_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“तुसां जो जड़ा चाईदा सै परमेश्वरे ला मंगा कने उनी तुसां जो देणा; अगर तुसां तोपगे, तां तुसां जो मिलणा; अगर खटखटांगे, तां तुहाड़े तांई खुलणा।” ");
INSERT INTO bht_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","क्योंकि जड़ा कोई मंगदा है, उसयो मिलदा है; जड़ा तोपदा है, उसयो मिलदा है; कने जड़ा खटखटादां है, उदे तांई खुलदा है। ");
INSERT INTO bht_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","तुहाड़े चे कुण ऐदिया पिता होंगा, की जालू उदा पुत्र रोटी मंगे, तां उसयो पथर दे: या मच्छी मंगे तां मछिया दे बदले सप दे? ");
INSERT INTO bht_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","या अंडा मंगे तां उसयो बिच्छु देई दे? ");
INSERT INTO bht_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","“अगर तुसां बुरे होईकरी अपणे बचयां जो खरियाँ चिजा देणा जाणदे न, तां तुहाड़े स्वर्गीय पिता परमेश्वरे अपणे मंगणे बाले जो केई जादा बदीकरी पबित्र आत्मा देणे तांई तैयार है।” ");
INSERT INTO bht_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","फिरी उनी इक गूंगी बुरी आत्मा जो कडया; जालू सै बुरी आत्मा निकली गेई, तां सै गूंगा बोलणा लगी पिया; कने लोकां जो हेरानी होई। ");
INSERT INTO bht_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","पर उना चे कितणयां ही बोलया, “ऐ तां बुरियां आत्मा दे सरदार शैताने दी मदद लेईकरी बुरियां आत्मा जो कडदा है।” ");
INSERT INTO bht_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","होरनी उदी परख लेणें तांई उसला स्वर्गे दा कोई निशाण दसणे तांई बोलया। ");
INSERT INTO bht_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","पर उनी, उना दे मने दियां गल्लां जो जाणी करी, उना ने बोलया, “अगर कुसी राज्य च लोक अपु चे ही लड़दे रेंगे तां सै राज्य उजड़ी जांदा है। कने अगर कुसी घरे दे माणु अपु चे ही लड़दे रेंगे तां सै घर भी उजड़ी जांदा है।” ");
INSERT INTO bht_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","अगर शैतान अपणी ही बुरी आत्मा दे खिलाफ लड़गा, तां उनी अपणा ही नाश करी लेणा है, तां फिरी उदा राज्य कियां बदी सकदा है? क्योंकि तुसां मेरे बारे च तां बोलदे न, की ऐ तां शैताने दिया मददा ने बुरिया आत्मा जो कडदा है। ");
INSERT INTO bht_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“भला अगर मैं शैताने दिया मददा ने बुरियां आत्मा जो कडदा है, तां तुहाड़ी ओलाद कुसदिया मददा ने बुरियां आत्मा जो कडदी है? इस तांई तुहाड़िया ओलादी ही तुहाड़ा न्याय करणा है।” ");
INSERT INTO bht_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","पर अगर मैं परमेश्वरे दिया शक्तिया ने बुरियां आत्मा जो कडदा है, तां परमेश्वरे दा राज्य तुहाड़े बखे आई रिया है। ");
INSERT INTO bht_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","जालू जोरे बाला माणु हथियार लेईकरी अपणे घरे दी रखबाली करदा है, तां उदी संमत्ति बची रेंदी है। ");
INSERT INTO bht_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","पर जालू उसला जादा जोरे बाला उसला लड़ी करी उसयो जीती लेंदा है, तां उदे सै हथियार जिना पर उसयो भरोसा था, उना जो खोई लेंदा है कने उदिया संपतिया जो लुटी करी बंडी दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“जड़ा मेरे सोगी नी है सै मेरे खिलाफ है, कने जड़ा मेरे सोगी नी बटोलदा है सै खलारदा है।” ");
INSERT INTO bht_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","जालू बुरी आत्मा माणुऐ ला निकली जांदी है, तां सै सुकियां जगा च अराम तोपदी फिरदी है, पर उसा जो अराम नी मिलदा है। तां सै अपणे आपे ने बोलदी है, कि मैं अपणे तिस्सी घरे जो बापस चली जाणा है, जिस माणुऐ ला निकली थी, ");
INSERT INTO bht_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","“जालू सै बापस ओंदी है तां उस माणुऐ जो उस घरे सांई पांदी है, जिसयो छेल करी साफ कने सजाया हो।” ");
INSERT INTO bht_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","तालू सै बुरी आत्मा जाई करी अपणे ला होर बुरियाँ सत्त आत्मा जो अपणे सोगी लेई ओंदी है, कने सै उदे अंदर बड़ी करी ओथु रेंदियां न, कने उस माणुऐ दी हालत पहले ला भी बुरी होई जांदी है। ");
INSERT INTO bht_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","जालू यीशु ऐ सब गल्लां बोला दा ही था तां भिड़ा चे इकी जनानिया उचिया अबाजा ने बोलया, “धन्य हे सै जनानी जिना तिजो पैदा किता कने तिजो अपणा दूध पियाया।” ");
INSERT INTO bht_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","उनी बोलया, “हाँ, पर धन्य न सै, जड़े परमेश्वरे दा बचन सुणीकरी मंदे न।” ");
INSERT INTO bht_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","जालू बड़े भरी लोकां दी भीड़ गिठी होआ दी थी तां सै बोलणा लग्गा, “इस युगे दे बुरे लोक चिन्न चमत्कार तोपदे न, पर परमेश्वरे दा संदेश देणेबाले योना दे चिन्न चमत्कार जो छडी करी उना जो कोई होर कोई चिन्न नी मिलणा।” कने यीशु उना जो छडी करी चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","जियां योना नीनवे शेहरे दे लोकां तांई चिन्न बणया, तियां ही मैं माणुऐ दा पुत्र भी इस युगे दे लोकां तांई चिन्न होणा है। ");
INSERT INTO bht_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","दक्षिणे दिया राणिया न्याय दे रोजे इस बेले दे आदमियां दे सोगी उठी करी, उना जो दोषी बोलणा है, क्योंकि सै राजा सुलैमान दा ज्ञान सुणने तांई बड़ी दुरे ला आई, कने दिखा ऐथू सै है जड़ा सुलेमान ला भी बडा है। ");
INSERT INTO bht_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","नीनवे शेहरे दे लोकां न्याय दे रोजे इस बेले दे लोकां सोगी खड़े होईकरी, इसा पीढ़ी दे लोकां जो दोषी बोलणा है; क्योंकि उना योना दा प्रचार सुणिकरी मन बदलया है कने दिखा, ऐथू सै है जड़ा योना ला भी बडा है। ");
INSERT INTO bht_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“कोई माणु दिय्या बाली करी थले या टोकरुऐ हेठ नी रखदा है, पर धारिया पर रखदा हे ताकि अंदरे ओणे बालयां जो लौ होऐ।” ");
INSERT INTO bht_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","तेरियां हखी तेरे शरीरे तांई इक दिय्ये सांई न, इस तांई अगर तेरी हख साफ है, तां तेरा सारा शरीर भी लौ लुआन है; पर अगर सै बुरी है, तां तेरा शरीर भी नेहरे च है। ");
INSERT INTO bht_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","तांई तां ध्यान रखा, की जड़ी लौ तिजो च है सै नेहेरा ना होई जाये। ");
INSERT INTO bht_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","इस तांई अगर तेरा सारा शरीर लौ लुआन हो, कने उदा कोई हिसा नेहरे च नी रे, तां सारे दा सारा शरीर ऐसा लौ लुआन होणा, जियां उस बेले होंदा है, जालू दिय्या अपणिया लौइ ने तिजो लौ दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","जालू यीशु अपणा प्रचार खत्म करी बेठा, तां इकी फरीसिये उसला बिनती किती, की मेरे घरे रोटी खाणां चल; कने सै अंदर जाई करी रोटी खाणां बैठा। ");
INSERT INTO bht_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","फरीसी जो ऐ दिखीकरी बड़ी हेरानी होई की यीशुऐ खाणां खाणे ला पेहले अपणे रिती रिबाजा ने हथ पैर नी धोते। ");
INSERT INTO bht_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","प्रभु यीशुऐ उसयो बोलया, “हे फरीसियों, तुसां ऐसे भांडे न, जड़े तां उपरे-उपरे ला तां साफ न, पर तुसां दे मने अंदर लालच कने बुराई भरुईयो है।” ");
INSERT INTO bht_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","हे मूर्खों, जिनी बाहरे दा हिसा बणाया है, क्या उनी ही अंदरे दा हिसा नी बणाया है? ");
INSERT INTO bht_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","गरीब लोकां जो दान देईकरी अपणा मन अंदरे ला साफ करा, तां दिखा सब कुछ तुहाड़े तांई पबित्र होई जाणा। ");
INSERT INTO bht_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“पर हे फरीसियों, तुहाड़े तांई बड़ा बुरा होणा है! तुसां पुदीने कने जीरे दा, कने सारिंया भान्तिया दे साग पतयां दा दसमां हिसा दिन्दे न, पर न्याय जो कने परमेश्वरे दे प्यारे जो टाल्ली दिन्दे न; तुहांजो इयां करणा चाईदा था की इना जो भी करदे रेंदे कने उना जो भी नी छडदे।” ");
INSERT INTO bht_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","हे फरीसियों, तुहांजो तांई बड़ा बुरा होणा है! तुसां यहूदी जंज घर च खास-खास जगा च आसन कने ऐ चांदे न की बाजारां च लोक तुहांजो नमस्ते बोलन। ");
INSERT INTO bht_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“तुहांजो तांई बड़ा बुरा होणा है। क्योंकि तुसां उना लुकियां कबरां दे सांई न, जिना पर लोक चलदे न, पर जाणदे नी न।” ");
INSERT INTO bht_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","तालू इकी व्यवस्था जो सिखाणे बाले उसयो जबाब दिता, “गुरू जी, ऐसिया गल्लां बोली करी तू साड़ी निंदा करा दा है।” ");
INSERT INTO bht_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","उनी बोलया, “हे व्यवस्था जो सिखाणे बालयो, तुहांजो तांई बड़ा बुरा होणा है। तुसां ऐसे बोझे जो माणुऐ पर लददे न, जिसयो चुकणा बड़ा मुशकिल है, पर तुसां अपु उना बोझां जो अपणिया इकी उंगलियां ने भी नी हिलांदे न।” ");
INSERT INTO bht_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","तुहांजो तांई बड़ा बुरा होणा है। तुसां उना परमेश्वरे दा संदेश देणेबालयां दियां कबरां बणादें न, जिना जो तुहाड़े बाप दादयां मारी दितया था। ");
INSERT INTO bht_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","इसा गल्ला दे तुसां गबाह न, कने अपणे बाप दादयां दे कम्मा ने सहमत न; क्योंकि उना तां उना जो मारी दिता कने तुसां उना दियां कबरां बणादे न। ");
INSERT INTO bht_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","इस तांई तां परमेश्वरे दिया अकला भी बोलया है, की मैं उना बाल परमेश्वरे दा संदेश देणेबालयां कने प्रेरितां जो भेजगी, कने उना इना चे कितणयां जो मारी देणा, कने कितणयां जो सताणां है। ");
INSERT INTO bht_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ताकि जितणे भी परमेश्वरे दा संदेश देणेबालयां दा खून इस संसारे दे शुरू ला बहाया है, सबना दा लेखा, इस युगे दे लोंका ला लेंणा है। ");
INSERT INTO bht_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","हाबिल दिया हत्या ला लेईकरी परमेश्वर दा संदेश देणेबाले जकर्याह दिया हत्या दीकर जिसयो बेदी कने मंदरे दे बिच मारया था; मैं तुसां ने सच्च बोलदा है; उदा लेखा इस बकते दे लोकां ने लेंणा है। ");
INSERT INTO bht_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“व्यवस्था जो सिखाणे बालयां लोकां पर लानत है! क्योंकि तुहांजो बाल स्वर्ग जाणे दा रस्ते दा पता था। पर तां भी तुसां उसी रस्ते पर नी चले कने दुजे लोकां जो भी जाणे ला रोकी लिया है।” ");
INSERT INTO bht_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","जालू सै ओथु ला निकलया, तां व्यवस्था जो सिखाणे बाले कने फरीसी बड़े पिच्छे पेई गे, कने छेड़ना लग्गे, की सै बड़ियां गल्लां दी चर्चा करे, ");
INSERT INTO bht_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","कने उदिया ताका पर लगी रे, की उदे मुऐ दी कोई गल्ल पकड़न। ");
INSERT INTO bht_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","इतणे च ओथु जालू हजारां दी भीड़ होई गेई, ऐथू दीकर की लोक इकी दुऐ पर डेई पोंदे थे, तां यीशुऐ सबना ला पेहले अपणे चेलयां ने बोलया, फरीसियां दी कपटरूपी जिन्दगी ला जड़ी खमिरे सांई है उसा ला बची करी रेनयो। ");
INSERT INTO bht_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","क्योंकि कुछ भी ढक्या नी है, जड़ा खोलया नी जाणा है; कने कुछ छुपया नी है, जड़ा सामणे नी ओणा है। ");
INSERT INTO bht_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","तांई तां जड़ा कुछ, तुसां नेहरे च बोलया है, सै लौइ च सुणाया जाणा, कने जड़ा तुसां अंदर कमरयां च कन्ना च बोलया है, उदा छती पर चढ़ी करी प्रचार होंणा। ");
INSERT INTO bht_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“पर मैं तुसां ने बोलदा है, जड़े मेरे साथी न, कि जड़े शरीरे जो मारी सकदे न, पर सै आत्मा जो नी मारी सकदे न, उना ला डरदे मत।” ");
INSERT INTO bht_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","मैं तुहांजो चेतावनी दिन्दा है की तुहांजो कुसने डरना चाईदा, तुहांजो उस परमेश्वरे ला डरणा चाईदा जिसयो तुहांजो मारणे ला बाद नरके च भेजणे दा हक है। ");
INSERT INTO bht_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“क्या बड़ी घट कीमत च पंज चीड़ियाँ नी बिकदियां? तमी परमेश्वर उना चे इकी जो भी नी भुलदा।” ");
INSERT INTO bht_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","बल्कि तुहाड़े सिरे दे सारे बाल भी गिणयो न, इस तांई डरा मत, तुसां परमेश्वरे तांई मतियां चीड़ियाँ ला भी बदीकरी कीमती न। ");
INSERT INTO bht_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","मैं, माणुऐ दे पुत्र तुहांजो बोलदा है जड़े कोई बोलदे न, की सै मेरे चेले न, उसयो मैं भी अपणे स्वर्गीय पिता परमेश्वर दे सामणे अपणे चेले मनी लेंगा। ");
INSERT INTO bht_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","पर अगर सै दूजयां दे सामणे ऐ बोलणे ला डरदे न, कि असां यीशुऐ दे चेले न, तां परमेश्वरे भी अपणे स्वर्गदूतां सामणे तुहांजो चेला नी मनणा है। ");
INSERT INTO bht_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","पर जड़ा कोई माणुऐ दे पुत्रे दे बारे च कोई बुरी गल्ल बोलगा, उदा ऐ अपराध माफ होई जाणा, पर जड़ा कोई पबित्र आत्मा दे बारे च बुरा बोलगा, उदा अपराध माफ नी होणा है। ");
INSERT INTO bht_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“जालू लोक तुहांजो यहूदी जंज घर च कने हाकिमां कने अधिकारियां दे सामणे लेई जांगे, तां चिंता मत करदे की असां कियां या क्या जबाब देंन, या क्या बोलन।” ");
INSERT INTO bht_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","क्योंकि पबित्र आत्मा तुहांजो तालू ही सिखाई देणा, की क्या बोलणा चाईदा। ");
INSERT INTO bht_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","फिरी भिड़ा चे इकी माणुऐ यीशुऐ बोलया, “गुरू जी, मेरे भाईऐ जो बोल, की पिता दी जमीन जयादात मिंजो देई दे।” ");
INSERT INTO bht_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","यीशुऐ उसयो बोलया, “हे माणु, कुनी मिंजो तुहाड़ा न्याय करणे बाला या धन बंडणे बाला बणाया है?” ");
INSERT INTO bht_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","कने यीशुऐ उना जो बोलया, “ध्यान रखा, कने हर तरा दिया मोहमाया ने अपणे आपे जो बचाई रखा; क्योंकि कदी भी जिन्दगी उदिया जमीन जायदाद ला जादा नी होंदी।” ");
INSERT INTO bht_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","यीशुऐ उना जो इक कहाणी सुणाई, कुसकी अमीरे दिया जमिना च मती भरी फसल होई। ");
INSERT INTO bht_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","तालू सै अपणे मने च सोचणा लग्गा, की मिंजो नी समझ ओआ दी की मैं क्या करे, क्योंकि मेरे बाल तां इतणी जगा ही नी है, जिथू मैं अपणी सारिया फसला जो रखी सके। ");
INSERT INTO bht_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","कने उनी बोलया, मैं इयां करणा है की अपणे गोदामें दियां बखारियां जो तोड़ी करी उना ला बडियां बणाणियां न; कने ओथु अपणी सारी संपति कने फसल रखणी; ");
INSERT INTO bht_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","कने इदे बाद अपणे आपे ने बोलणा, की तेरे बाल मते साला तांई मती धन दौलत कने फसल रखियो है; मजे ने खा पी, सूखे ने रे। ");
INSERT INTO bht_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","पर परमेश्वरे उसयो बोलया, हे मुर्ख! इसा राती तू मरी जा; तां तालू जड़ा कुछ तू गठेरया है, सै कुसदा होणा? ");
INSERT INTO bht_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“इयां ही उस माणुऐ ने भी होणा है जड़ा सब कुछ अपणे तांई गठेरदा, पर परमेश्वरे दिया सेबा करणे तांई अपणी क्षमता कने धन दौलत खर्च नी करदा।” ");
INSERT INTO bht_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","फिरी उनी अपणे चेलयां ने बोलया, तांई तां मैं तुहांजो बोलदा है, अपणी जिन्दगी दी चिंता मत करा, की असां क्या खांगे; ना ही अपणे शरीरे दी की असां क्या पांगे। ");
INSERT INTO bht_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","क्योंकि रोटिया ला जिन्दगी कने कपड़यां ला शरीर जादा बदीकरी है। ");
INSERT INTO bht_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कोयां पर ध्यान दिया; ना सै रादें न, ना सै बडदे न, न उना बाल खेतर; ना उना दे गोदाम होंदे न जिथू से गठेरी सकन, तमी परमेश्वर उना जो पालदा है। तुहाड़ी कीमत पंछियां ला भी बदीकरी है। ");
INSERT INTO bht_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","तुसां चे ऐसा कुण है, जड़ा चिंता करणे ने अपणिया जिन्दगिया च इक घड़ी भी बधाई सकदा है? ");
INSERT INTO bht_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","इस तांई अगर तुसां सबना ला छोटा कम्म भी नी करी सकदे, तां जिन्दगी च दुजियां गल्लां दी कजो चिंता करदे न? ");
INSERT INTO bht_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“जंगली फुलां दे बारे च सोचा की सै कियां बडुदें न, सै ना तां मेहनत करदे न, कने ना ही कपड़े पांदे न, तमी मैं तुसां ने बोलदा है, की जालू राजा सुलैमान बाल धन दौलत थी, तालू भी उनी जंगली फुलां चे कुसी सांई भी कपड़े नी पायो थे।” ");
INSERT INTO bht_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","इस तांई अगर परमेश्वर दरबड़े दे घाऐ जो, जड़ा अज है, कने कल अग्गी च फुकया जांणा, तमी परमेश्वर घाऐ जो इतणी सुन्दरता दिन्दा है, तां हे अल्पविश्वासियों, तां उनी पक्का तुहाड़ी देखभाल करणी है, तुहाड़ा भरोसा इतणा घट्ट कजो है? ");
INSERT INTO bht_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","कने तुसां इसा गल्लां दिया तोपा च मत रिया, की क्या खांगे कने क्या पींगे, कने ना ही शक करा। ");
INSERT INTO bht_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","क्योंकि जड़े लोक परमेश्वरे जो नी जाणदे सै इना चिजां जो तोपदे रेंदे न; कने तुहाड़ा पिता जाणदा है, तुहांजो इना चिजां दी जरूरत है। ");
INSERT INTO bht_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","पर उदे राज्य दिया तोपा च रिया, तां ऐ चिजां भी तुहांजो मिली जाणियां। ");
INSERT INTO bht_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","तुसां मेरे तांई भेडां दे झुण्ड सांई न, इस तांई कुसा भी गल्ला दे बारे च मत डरा; क्योंकि तुहाड़े परमेश्वर पिता जो ऐ खुशी है, की तुहांजो राज्य दे। ");
INSERT INTO bht_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","अपणिया जमीन जयादात जो बेचिकरी दान करी दीया; कने अपणे तांई ऐसे बटुऐ बणां, जड़े पराणे नी होंदे, इदा मतलब की स्वर्गे च ऐसा धन गठेरा जड़ा घटदा नी है कने जिसदे नेड़े चोर नी जांदा है, कने खराब करणे बाला कीड़ा नी लगदा। ");
INSERT INTO bht_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","क्योंकि जिथू तुहाड़ा धन है, ओथु तुहाड़ा मन भी लगया रेंदा है। ");
INSERT INTO bht_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","हमेशा सेबा करणे तांई तैयार रिया कने सारी रात तुहाड़े दिय्ये बलदे रेंन। ");
INSERT INTO bht_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","कने तुसां उना माणुऐ सांई बणा, जड़े अपणे मालिके जो निय्याला दे होन, की सै बियाह ला कालू बापस ओंगा; की सै जालू आई करी दरबाजा खट खटागां तां झट उदे तांई खोली देन। ");
INSERT INTO bht_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","धन्य न सै सेवक, जिना जो मालिक आई करी उदे बापस ओणे दी निय्याल रखदे दिखे; मैं तुहांजो ने सच्च बोलदा, की उनी इक सेवके सांई कपड़े पाई करी उना जो रोटी खाणां बठाणा, कने अपु उना जो खांणे तांई परोसणा। ");
INSERT INTO bht_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","अगर सै अधिया राती या ब्यागा पेहर च आई करी उना जो जागदा दिखे, तां सै सेवक धन्य न। ");
INSERT INTO bht_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","पर तुसां ऐ जाणी लिया, की अगर घरे दा मालिक जाणदा, की चोरे कुसा घड़िया ओणा है, तां सै जागदा रेंदा, कने अपणे घरे च चोरी नी होणा दिन्दा। ");
INSERT INTO bht_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","तुसां भी मेरे बापस ओणे तांई तैयार रिया; क्योंकि मैं, माणुऐ दे पुत्रे ऐसिया घड़िया स्वर्गे ला ओणा जालू तुसां मेरे ओणे दी उम्मीद नी कितियो होणी है। ");
INSERT INTO bht_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","तालू पतरसे बोलया, “प्रभु जी, क्या ऐ कहाणी तू सांझो ही बोला दा है की सबना जो बोलदा है।” ");
INSERT INTO bht_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","प्रभु यीशुऐ बोलया, “सै भरोसे लाइक कने अकला बाला भंडारी कुण है, मालिक जिसयो नोकरां-चाकरां दा सरदार बणाऐ ताकि सै उना जो टेमे दा खांणे पिंणे दा समान दे।” ");
INSERT INTO bht_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","धन्य है सै सेवक, जिसयो उदा मालिक आई करी ऐसा ही करदा दिखे। ");
INSERT INTO bht_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","मैं तुहांजो ने सच्च बोलदा; उनी उसयो अपणिया सारिया संपतिया दा मालिक बणाई देणा। ");
INSERT INTO bht_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","पर अगर सै सेवक सोचणा लग्गे, की मेरे मालिके जो ओणे च हल्ले बड़ा बकत है, कने सै दासां कने दासियाँ जो मारणा-कुटणा कने खाणां-पिणा कने शराबी होणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","तां उस दासे दे मालिके ऐसे रोजे ओणा है जिस दिने सै उसयो निय्याला दा नी होणा, कने ऐसी घड़ी जिसा जो सै जाणदा ना होणा, तालू उदे मालिके ओणा, उसयो खरियाँ झिड़कां देईकरी उदी गिणती अविश्वासियां सोगी करी देणा। ");
INSERT INTO bht_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","कने सै सेवक जड़ा मालिके दी इच्छा जाणदा था, कने तैयार नी रिया कने ना उदिया मरजिया चलया, उनी बड़ी मार खांणी। ");
INSERT INTO bht_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","पर जिसयो पता नी होईकरी मार खाणे जोगा कम्म करे उनी घट मार खांणी, तांई तां जिसयो जादा दितया है उसला जादा मंगया जाणा है; कने जिसयो जादा सौंपया है, उसला जादा दा हिसाब लेणा है। ");
INSERT INTO bht_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","मैं धरतिया पर अग्ग लगाणा आया है; बस ऐ ही चांदा है, की हुण ही लगी जांदी! ");
INSERT INTO bht_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","मिंजो जल्द ही इक भयंकर पीड़ झेलणा पोणी है; कने जालू दीकर सै पीड़ नी झलगा तालू दीकर मैं बड़ा बेचेन है। ");
INSERT INTO bht_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","तुसां क्या सोचदे न की मैं धरतिया पर लोकां बिच मेल मिलाप करणा आया है? मैं बोलदा है, नी मैं लग करणा आया है। ");
INSERT INTO bht_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","क्योंकि अगर कुसी इकी घरे दे पंज जणे न, तां उना अपु चे बख रेणा है, तिन्ना जाणया जड़े मिंजो पर भरोसा नी करदे उना दों जणयां दा बिरोध करणा जड़े मिंजो पर भरोसा करदे न। ");
INSERT INTO bht_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","पिता पुत्रे ने, कने पुत्रे पिता ने बेर रखणा; माता कुड़िया ने, कने कुड़िया माता ने, ससु नुआ ने, कने नुआ ससु ने बैर रखणा है। ");
INSERT INTO bht_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","कने यीशुऐ भिड़ा ने भी बोलया, जालू तुसां बदलां जो पशचिम ला उठदे दिखदे न, तां झट बोलदे न, की बरखा होणी है, कने इयां ही होंदा है। ");
INSERT INTO bht_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","कने जालू दक्षिणी होआ चलदी दिखदे न तां बोलदे की लू चलणी, कने इयां ही होंदा है। ");
INSERT INTO bht_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","हे कपटियों, तुसां धरती कने अम्बरे दे रुपे च भेद करी सकदे न, पर इस युगे च परमेश्वर क्या करा दा है, उदे बारे च भेद कजो नी जाणदे न। ");
INSERT INTO bht_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","तुसां जो अपु ही फेसला करणा चाईदा की तुहाड़े तांई क्या ठीक है? ");
INSERT INTO bht_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","जालू तू अपणे मुद्दई सोगी न्याय करणे बाले बाल चलया है, तां रस्ते च ही उसला छुटणे दी कोसिस करी ले इयां ना हो, की सै तिजो जजे बाल लेई जाऐ, कने जज सिपाई बाल देई दे कने सिपाई तिजो जेला च पाई दे। ");
INSERT INTO bht_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","मैं तुहांजो बोलदा है, कि जालू दीकर तू दमड़ी-दमड़ी नी देई दिंगा तालू दीकर ओथु ला नी छुटी सकणा है। ");
INSERT INTO bht_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","उस बेले कुछ लोक आई रे, कने उना यीशुऐ ने बोलया, की रोमी राज्यपाल पिलातुसे गलील प्रदेशे दे थोड़े लोकां दी हत्या करी दितियो थी, जालू से मंदिर च बलि चढ़ा दे थे। ");
INSERT INTO bht_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ऐ सुणीकरी यीशुऐ उना जो जबाब च ऐ बोलया, “क्या तुसां ऐ समझदे न, की ऐ गलील प्रदेश दे लोक, बाकी सारयां गलीली लोकां ला जादा पापी थे की उना पर ऐ मुशकिल पेई?” ");
INSERT INTO bht_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","मैं तुसां ने बोलदा, की नी थे; पर अगर तुसां भी अपणे पापां जो नी मनगे कने मन नी बदलगे तां तुसां भी इयां ही खत्म होणा है। ");
INSERT INTO bht_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","या क्या तुसां समजदे न, की उना ठारा जणयां दे बारे च तुहाड़ा क्या बोलणा है जालू उना पर शीलोह दा गुम्मट पिया, कने सै दबुई करी मरी गे: क्या सै यरूशलेम शेहरे दे होर सारे रेणे बालयां ला जादा पापी थे? ");
INSERT INTO bht_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","“मैं तुसां ने बोलदा है, की नी थे; पर अगर तुसां मन नी बदलया तां तुसां भी इना सांई ही खत्म होणा।” ");
INSERT INTO bht_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","फिरी उनी ऐ कहाणी भी सुणाई, की कुसकी अंगूरा दे बागे च इक अंजीरे दा रुख लगया था: सै उदे च फल तोपणा हर साल आया, पर नी मिल्ले। ");
INSERT INTO bht_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","तालू उनी बागे दे रखबाले जो बोलया, दिख मैं तिन्ना सालां ला इस अंजीरे दे रुखे च फल तोपणा ओंदा है, पर मिलदे नी न, इसयो बडी दे क्योंकि ये खरिया जमिना जो खराब करा दा है। ");
INSERT INTO bht_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“उनी उसयो जबाब दिता, की हे मालिक इसयो इस साल तां रेंणी दे; की मैं इदे चारो पासे खूणी करी खाद पां। ");
INSERT INTO bht_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","अगली बरी अगर ऐ फलगा तां ठीक नितां इसयो बडी दियां।” ");
INSERT INTO bht_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","सब्ते दे रोजे यीशु इकी यहूदी जंज घर च उपदेश दे दा था। ");
INSERT INTO bht_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","कने ओथु इक जनानी थी, जिसा जो ठारां सालां ला इक बुरी आत्मा बिकलांग करी रखया था, कने सै बड़ी जादा कुबड़ी होई गियो थी, कने कुसी भी तरीके ने सिदी नी होई सकदी थी। ");
INSERT INTO bht_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","यीशुऐ उसा जो दिखीकरी सदया, कने बोलया, “हे नारी, तू इसा अपणिया बिमारिया ला छुटी गेई।” ");
INSERT INTO bht_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","तालू उनी उसा पर हथ रखे, कने सै झट सीधी होई गेई, कने परमेश्वरे दी बड़ाई करणा लग्गी। ");
INSERT INTO bht_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","इस तांई की यीशुऐ उसा जो सब्ते दे रोजे ठीक किता था, यहूदी जंज घरे दा सरदार लोकां ने बोलणा लग्गा, “इक हफ्ते च छे रोज न, जिना च असां कम्म करी सकदे न, इना रोजा च आई करी ठीक होआ; पर सब्ते दे रोजे नी।” ");
INSERT INTO bht_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ऐ सुणिकरी प्रभु यीशु जबाब दिता, “हे कपटियों, क्या सब्ते दे रोजे तुसां सारे जणे अपणे दांदा या गधे जो बेकां ला खोलिकरी पाणी पिणा नी लेई जांदे?” ");
INSERT INTO bht_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ऐ जनानी जड़ी अब्राहमे दे बंशज है, जिसयो शैताने ठारां सालां ला बन्नी रखया था, क्या ठीक नी था की सब्ते दे रोजे अपणे बंधने ला छुडाई जांदी? ");
INSERT INTO bht_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","जालू उनी ऐ गल्लां बोलियाँ, तां उदे सारे बिरोधी शरमिंदा होई गे, कने सारी भीड़ उना महान कम्मा ने जड़े सै करदा था, खुश होई। ");
INSERT INTO bht_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","फिरी यीशुऐ बोलया, “परमेश्वरे दा राज्य कुसदे सांई है? कने मैं उदी तुलना केसने करे?” ");
INSERT INTO bht_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","“सै राईया दे इकी दाणे सांई है, जिसयो इकी माणुऐ लेईकरी अपणिया जमिना च राया है: कने सै बड़ोईकरी रुख बणी गिया; कने अम्बरे दे पंछियां उदियां डालियाँ पर अपणे घोंसले बणाऐ।” ");
INSERT INTO bht_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","उनी फिरी बोलया, मैं परमेश्वरे दे राज्य दी तुलना केसने करें? ");
INSERT INTO bht_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","“सै खमिरे सांई है, जिसयो इकी जनानिया लेईकरी बडे सारे आटे च पाया, कने होंदे-होंदे सारा अटा खमीर बणी गिया।” ");
INSERT INTO bht_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","सै शेहर-शेहर, कने अपणे चेलयां सोगी ग्रां-ग्रां होईकरी उपदेश दिन्दा होया यरूशलेम शेहर दे पासे जा दा था। ");
INSERT INTO bht_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","कने कुंनकी यीशुऐ पुछया, “प्रभु जी, क्या परमेश्वरे कुछ लोकां जो ही अनन्तकाल दी सजा ला बचाणा है?” उनी उना जो बोलया, ");
INSERT INTO bht_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","परमेश्वरे दे राज्य च जाणे दी कोशिश करा, क्योंकि परमेश्वरे दे राज्य च अंदर जाणा सुंगड़े दरबाजे ला अंदर जाणे सांई है, क्योंकि मैं तुसां ने बोलदा है, की मतयाँ अंदर जाणे दी कोशिश करणी है, पर जाई नी सकणा है। ");
INSERT INTO bht_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","जालू परमेश्वर जड़ा घरे दा मालिक है उठी करी दरबाजा बंद करी बैठया हो, कने तुसां बाहर खड़ोई करी दरबाजा खट खटाई करी कने बिनती करी बोलन, प्रभु जी, साड़े तांई खोली दे, कने सै जबाब दे की मैं तुहांजो नी जाणदा, तुसां कुथु ला आयो न? ");
INSERT INTO bht_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“तालू तुसां बोलणा लगणा, की असां तेरे सामणे खादा पीता कने तू साड़े बजारां च उपदेश दिता।” ");
INSERT INTO bht_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","पर परमेश्वरे बोलणा, मैं तुसां ने बोलदा है, मैं नी जाणदा तुसां कुथु ला न। हे बुरे कम्म करणे बालयों, तुसां सारे मिंजो ला दूर होई जा। ");
INSERT INTO bht_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ओथु रोणा कने दंद पीणे: जालू तुसां पूर्वज अब्राहम कने इसहाक कने याकूब कने सारे परमेश्वरे दे संदेश देणेबालयां जो परमेश्वरे दे राज्य च बैठया कने अपणे आपे जो बाहर कडया दिखणा। ");
INSERT INTO bht_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","तालू पुरे संसारे ला लोक आई करी परमेश्वरे दे राज्य दिया दावता च हिस्सेदार होंगे। ");
INSERT INTO bht_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“कने दिखा, जड़े पिछले न, उना पेहले होई जाणा, कने जड़े पेहले न, उना पिछले होणा।” ");
INSERT INTO bht_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","उसा घड़िया कितणे ही फरीसियां आई करी उसयो बोलया, ऐथू ला निकली करी चली जा; क्योंकि राजा हेरोदेस तिजो मारी देणा चांदा है। ");
INSERT INTO bht_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","उनी उना ने बोलया, जाई करी उस माणुऐ जो बोली दिया जड़ा लोमड़ियां सांई चलाक है, की दिख मैं अज कने कल सारी बुरी आत्मा जो कडदा कने बिमारां जो ठीक करदा है कने तिजे रोजे अपणा कम्म पूरा करणा है। ");
INSERT INTO bht_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","तमी मिंजो अज कने कल कने परसु सफर करणा जरूरी है, क्योंकि इक परमेश्वरे दा संदेश देणेबाला सिर्फ यरूशलेम शेहरे च ही मारया जाणा है। ");
INSERT INTO bht_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“हे यरूशलेम शेहर दे लोको! तुसां इना परमेश्वरे दा संदेश देणेबालयां जो मारी दिता है, जड़े पेहले रेंदे थे कने उना लोकां जो पथरां ने मारदे न जिना जो तुहाड़े बाल भेजया; कितणी ही बरी मैं ऐ चाया, की जियां मुर्गी अपणयां बचयां जो अपणे फंगा थले गिठे करदी है, तियां ही मैं भी तेरे बचयां दी रखबाली करे, पर तू ऐ नी चाया।” ");
INSERT INTO bht_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","“दिखा, तुहाड़ा मंदिर तुहाड़े तांई उजाड़ी छडया है, कने मैं तुसां ने बोलदा है; जालू दीकर तुसां नी बोलगे, की धन्य है सै, जड़ा प्रभु दे नाऐ ने ओंदा है, तालू दीकर तुसां मिंजो कदी नी दिखणा है।” ");
INSERT INTO bht_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","फिरी यीशु सब्ते दे रोजे फरीसियां दे सरदारां चे कुसकी दे घरे रोटी खाणां खाणे तांई गिया: कने सै यीशु जो ढंगे ने ताका दे थे की कोई गलती तोपी सकन। ");
INSERT INTO bht_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ओथु इक माणु था, जिसदे हथ कने पैर सूजी गियो थे। ");
INSERT INTO bht_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","इसा गल्ला पर यीशुऐ व्यवस्था जो सिखाणे बालयां कने फरीसियों ने बोलया, “क्या सब्ते दे रोजे लोकां जो ठीक करणे दी अनुमति व्यवस्था च है, की नी है?” ");
INSERT INTO bht_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","पर सै चुपचाप ही रे। तालू यीशुऐ उस पर हथ रखीकरी ठीक किता, कने जाणा दिता। ");
INSERT INTO bht_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","कने उना जो बोलया, “मन्नी लिया कि तुसां चे कुसकी दा जागत या दांद सब्ते दे रोजे खुऐ च पेई जा कने उसयो उस रोजे झट बाहर ना कडे?” ");
INSERT INTO bht_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","सै इना गल्लां दा कोई भी जबाब नी देई सके। ");
INSERT INTO bht_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","तालू उनी दिखया, की सदयो लोक कियां सै जगा चुणी लेंदे जिथू सबते खास लोक बोंदे न, तां यीशुऐ उना जो इक कहाणी सुणाई करी उना ने बोलया, ");
INSERT INTO bht_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","जालू कोई तिजो बियाये दिया धामा च सदगा, तां तुसां उना खास आसना च मत बोंदा, कुथकी इयां ना हो की उनी तिजो ला भी बड़े खास बंदे जो न्युंद्र दितियो हो। ");
INSERT INTO bht_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","कने जिनी तिजो कने उसयो दोनो जो न्युंद्र दितियो है, सै आई करी तिजो ने बोले, की इसयो जगा दे, तालू तिजो शरमिंदा होईकरी सारयां ला पिच्छे बालिया जगा च बोणा पोऐ। ");
INSERT INTO bht_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","पर जालू तिजो सदगे, तां सारयां ला पिच्छे बालिया जगा जाई करी बेई जा, की जालू सै, जिनी तिजो सदया हे सै ओऐ, कने तिजो ने बोले की हे मित्र, अग्गे जाई करी खास बाली जगा च बैठ; तालू तेरे सोगी बोंणे बालयां दे सामणे तेरी बड़ाई होंणी। ");
INSERT INTO bht_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“क्योंकि जड़ा कोई अपणे आपे जो बडा महान बणांगा, उसयो छोटा किता जाणा; कने जड़ा कोई अपणे आपे जो छोटा बणांगा, सै सबते महान कितया जाणा।” ");
INSERT INTO bht_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","तालू यीशुऐ अपणे न्युंद्र देणेबाले फरीसियो जो भी बोलया, “जालू तू दिने दा या राती दा खाणां खांगा, तां अपणे दोस्तां या भाईयां या रिश्तेदारां या अमीर पड़ोसियां जो मत सददा, की इयां ना हो, की सै भी तिजो सदन, कने जड़ा तू खाणा खुआया उदा बदला होई जाऐ।” ");
INSERT INTO bht_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“पर जालू तू रोटी खाऐ, तां गरीबां जो, लंगड़यां जो कने अन्नयां जो सदी लियां। ");
INSERT INTO bht_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","तालू तू धन्य होणा, क्योंकि उना बाल तिजो देंणे तांई कुछ नी है, पर जालू धर्मी लोकां दे फिरी जिन्दा होई जाणा तालू परमेश्वरे तुहांजो इदा इनाम देणा।” ");
INSERT INTO bht_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","उदे सोगी रोटी खाणे बालयां चे इकी ऐ गल्लां सुणिकरी उसयो बोलया, “धन्य है सै, जड़ा परमेश्वरे दे राज्य दिया धाम च शामिल होंगा।” ");
INSERT INTO bht_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","उनी उसयो बोलया, कुनकी माणुऐ बड़ी बडी धाम दिती कने मतयां जो सदया। ");
INSERT INTO bht_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","जालू खाणां तैयार होई गिया, तां उनी अपणे नोकरे जो भेजया कि जिना जो नियुंद्र दितियो उना लोकां जो बोली ओआ, की ओआ, खाणां तैयार है। ");
INSERT INTO bht_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","पर सै सारे दे सारे माफी मंगणा लग्गे, पेहले माणुऐ उसला बोलया, मैं खेतर खरीदया है कने जरूरी है की मैं उसयो दिखें; मैं तिजो ने बिनती करदा है, की मिंजो माफ करी दे। ");
INSERT INTO bht_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","दूऐ माणुऐ बोलया, मैं पंज जोड़ी दांद खरिदयो न, कने उना जो परखणा जाणा है; मैं तिजो ने बिनती करदा है की मिंजो माफ करी दे। ");
INSERT INTO bht_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","इकी होरनी बोलया, की मैं बियाह कितया है, इस तांई मैं नी आई सकदा है। ");
INSERT INTO bht_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","उनी सेवके आई करी अपणे मालिके ने ऐ गल्ल सुणाई। तालू घरे दे मालिके गुस्से च आई करी बोलया, शेहरे दे बजारां कने गलियां च जाई करी झट कंगालां, टुंडे, लंगड़यां कने अन्नयां जो ऐथू लेई ओआ। ");
INSERT INTO bht_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","सेवके फिरी बोलया, हे मालिक, जियां तू बोलया था, तियां ही कितया है; फिरी भी जगा है। ");
INSERT INTO bht_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“मालिके सेवके ने बोलया, सड़कां कने बागां च जाई करी लोकां जो मजबूर करी के लेई आऐ ताकि मेरा घर भरुई जा। ");
INSERT INTO bht_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","क्योंकि मैं तुसां ने बोलदा है, की पेहले सदयो होए लोकां चे कोई भी मेरिया रोटिया जो नी चखगा।” ");
INSERT INTO bht_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","कने जालू मती भीड़ यीशुऐ सोगी चलियो थी, तां उनी पिच्छे मुड़ी करी उसला बोलया। ");
INSERT INTO bht_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“जड़े लोक मेरे बाल ओंदे न, सै तालू दीकर मेरे चेले नी बणी सकदे, जालू दिकर अपणे माता-पिता कने घरे बाली कने बच्चे कने भाई बेंहण कने अपणे आपे ला जादा प्यारा मिंजो ने नी करदे।” ");
INSERT INTO bht_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","जड़ा मेरिया बजा ला दुख सेहन कने मरणे तांई तैयार नही है, सै भी मेरा चेला बणने दे लायक नही है। ");
INSERT INTO bht_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“अगर तुसां चे कोई इक बड़ा बड्डा घर बणाणा चांदा हो, तां उनी सबते पेहले बेईकरी इसा गल्ला दा हिसाब लाणा की इसयो बणाणे च कितणा खर्चा ओणा, कने दिखणा की इसयो पूरा करणे तांई पूरा पैसा है की नी।” ");
INSERT INTO bht_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","अगर उनी इयां नी किता, तां उनी जालू नियां पाई करी घरे जो पूरा तैयार नी करी सकणा, तां सारे दिखणे बाले ऐ बोलिकरी उदा मजाक उड़ाणा, ");
INSERT INTO bht_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","की इनी माणुऐ घर बणाणा तां शुरू किता, पर पूरा बणाई नी सकया? ");
INSERT INTO bht_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“अगर इक राजा दस हजार माणुआं जो लेईकरी दुऐ राजे ने लड़ना चलया हो, जड़ा बी हजार माणुआं जो लेईकरी उस पर हमला करणा ओआ दा हो, तां सबते पेहले बेईकरी इसा गल्ला पर बिचार करे की जड़ा बी हजार लेईकरी मिंजो ने लड़ना ओआ दा है, क्या मैं उदा सामणा करी सकदा है की नी?” ");
INSERT INTO bht_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","नितां उदे दूर रेंदे ही, उसला संधी करणे दे बारे च गल्ल बात करणे तांई सै दूतां जो भेजे। ");
INSERT INTO bht_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","इयां ही तुसां चे जड़ा कोई अपणा सब कुछ छडी दे, सै ही मेरा चेला होई सकदा है। ");
INSERT INTO bht_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","लूँण तां खरा होंदा है, पर अगर उदा स्वाद बिगड़ी जा, तां उदा स्वाद कियां नमकीन करणा? ");
INSERT INTO bht_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","“सै तां ना जमिना दे ना तां खादी दे कम्मे ओंदा है: उसयो तां लोक बाहर फेंकी दिन्दे न। जिस बाल सुणने तांई कन्न न सै ध्यान लाईकरी गल्ला जो सुणे, कने इसा गल्ला जो समझी ले।” ");
INSERT INTO bht_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","सारे कर लेणेबाले कने पापी लोक यीशु बाल ओंदे थे ताकि उदी सुणन। ");
INSERT INTO bht_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","कने फरीसी कने व्यवस्था जो सिखाणे बाले बोलणा लग्गे, “ऐ तां पापी लोकां ने मिलदा है कने उना सोगी खाणा खांदा है।” ");
INSERT INTO bht_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","तालू उनी उना जो ऐ कहाणी सुणाई; ");
INSERT INTO bht_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“अगर तुसां चे कुसी बाल सो भेडां होन, कने उना चे इक गबाची जाये तां सै उना नड़िनुऐ भेडां जो सुनसान जगा च छडी करी, उसा गवाचिया जो तालू दीकर तोपे जालू दीकर सै मिल्ली न जा।” ");
INSERT INTO bht_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","कने जालू मिली जांदी है, तां सै बड़िया खुशिया ने उसा जो मुंडे पर चुकी लेंदा है। ");
INSERT INTO bht_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","कने अपणे घरे आई करी दोस्तां कने पड़ोसियां जो गिठे करी के बोलदा है, मेरे सोगी खुशी मना क्योंकि मेरी गबाचियो भेड मिली गेई है। ");
INSERT INTO bht_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","मैं तुसां ने बोलदा है; की इयां ही इक मन बदलने बाले पापिये दे बारे च स्वर्गे च इतणी ही खुशी होणी, जितनी की उना नड़िनुए धर्मियां दे बारे च नी होंदी जड़े सोचदे न की सै धर्मी न, कने जिना जो पश्चाताप दी जरूरत नी है। ");
INSERT INTO bht_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","तालू यीशुऐ इक होर कहाणी सुणाई अगर कुसी जनानिया बाल दस चांदी दे सिक्के होन, कने उना चे इक सिक्का गबाची जाऐ; तां सै दिय्या वाली करी कने पूरे घरे च बोंखरिया ने सोतया, तालू दीकर सै ध्यान लगाई करी तोपदी रेई जालू दीकर तोपी ना ले। ");
INSERT INTO bht_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","कने जालू मिली जांदा है, तां सै अपणियां सेलियाँ कने पड़ोसियां जो गठेरी करी बोलदी है, की ओआ मरे सोगी खुशी मना क्योंकि मेरा गबाचया सिक्का मिली गिया है। ");
INSERT INTO bht_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“मैं तिजो ने बोलदा है; की इयां ही इक पापी माणु जालू अपणे पापां जो मन्नी लेदां है, तां परमेश्वरे दे स्वर्गदूत उस पापी तांई खुशी मनादे न।” ");
INSERT INTO bht_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","फिरी उनी इक होर कहाणी सुणाई, इकी माणुऐ दे दो पुत्र थे। ");
INSERT INTO bht_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","उना चे छोटे जागते पिता ने बोलया, पिता जी, की जड़ा हिसा मेरा जमीन जयादात च है, सै हुण मिंजो देई दिया। कने पिता उना जो अपणी सारी जमीन जयादाद दोनो जागतां बिच बंडी दिती। ");
INSERT INTO bht_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“कने कुछ दिना बाद की छोटा पुत्र सारा कुछ गठेरी करी दूर कुसी देशे जो चली गिया कने ओथु बुरे कम्मा कने खाणे पिणे च अपणी सारी धन दौलत उड़ाई दिती।” ");
INSERT INTO bht_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","जालू सै सारा कुछ खर्ची बैठा, कने उसी देशे बड़ा बडा अकाल पेई गिया, कने उस बाल खाणे पीणे जो कुछ नी बचया। ");
INSERT INTO bht_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","कने सै उसी देशे दे रेहणे बाले इक माणुऐ दे घरे कम्म करणे तांई गिया। उनी उसयो अपणे खेतरां च सूअरां जो चुगाणे तांई भेजया। ");
INSERT INTO bht_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","कने सै इतणा भूखा था, की सै उना फलियाँ जो खाणे ने इतणा खुश था जिना जो सूअर खांदे थे, क्योंकि उसयो कोई कुछ नी दिन्दा दा खाणे जो। ");
INSERT INTO bht_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","जालू उसयो समझ आई तां सोचणा लग्गा कने बोलणा लग्गा, की मेरे पिता दे कितणे ही मजदुरां जो खाणे ला जादा रोटी मिलदी है, पर मैं ऐथू भूखा मरा दा। ");
INSERT INTO bht_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","मैं हुण उठी करी री अपणे पिता बाल जाणा है कने बोलणा की पिता जी मैं परमेश्वर दे खिलाफ च कने तेरिया नजरा च पाप कितया है। ");
INSERT INTO bht_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","हुण इसी जोगा नी है की तेरा पुत्र बणे, मिंजो अपणे इकी मजदूरे सांई ही रखी ले। ");
INSERT INTO bht_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","तालू उनी उस देशे जो छडी दिता कने अपणे पिता बाल जाणे तांई बापस चली पिया, सै अजे दूर ही था, की उदे पिता जो उसयो दिखीकरी तरस आई गिया, कने उस पासे दोड़ी करी उसयो गल्ले लाई लिया, कने बड़े चूमे ले। ");
INSERT INTO bht_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","पुत्रे उसला बोलया, पिता जी, मैं परमेश्वरे दे खिलाफ च कने तेरिया नजरा च पाप कितया है; कने मैं हुण तेरा पुत्र होणे जोगा नी रिया है। ");
INSERT INTO bht_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","पर पिता अपणे नोकरां ने बोलया, झट छेल दे कपड़े कडी करी इसयो पेहना, कने इदिया उंगलियां च गुन्ठिया कने पैरां च जूतियां पेहना, ");
INSERT INTO bht_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","कने इक बड़ी बडी धाम तैयार करा ताकि असां खाई करी खुशी मनान। ");
INSERT INTO bht_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","क्योंकि मैं सोचया था की मेरा ऐ पुत्र मरी गिया है, पर ऐ मरया नी है: गवाची गिया था, पर हुण मिली गिया है। कने सै खुशी मनाणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","जालू ऐ सब होआ दा था पर उदा जेठा पुत्र खेतरां च कम्म करा दा था। कने सै जालू घरे बखे पुज्जा, तां उनी गाणे-बजाणे कने नचणे दा रोल्ला सुणया। ");
INSERT INTO bht_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","कने उनी इकी नोकरे जो सदीकरी पुछया, ऐ क्या होआ दा है? ");
INSERT INTO bht_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","उनी उसला बोलया, तेरा भाई घर बापिस आया है, कने तेरे पिता बड्डी धाम तैयार कितयो है, क्योंकि सै भला चंगा घर बापस आया है। ");
INSERT INTO bht_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ऐ सुणिकरी उसयो बड़ा गुस्सा आई गिया कने सै घरे अंदर नी जादा था, इस तांई उदा पिता बाहर आई करी उसयो अंदर चलणे तांई मनाणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","उनी पिता जो जबाब दिता, की दिख; की मैं इतणे सालां ला तेरी सेबा करा दा है, कने कदी तेरी गल्ल नी टाल्ली, तमी तू मिंजो अजे दीकर कदी तू मिंजो कुछ खरा नी दिता, की मैं अपणे दोस्तां सोगी खुशी मनां। ");
INSERT INTO bht_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","पर जालू तेरा ऐ पुत्र आया, जिनी तेरी सारी धन दौलत कन्जरियां पिच्छे उड़ाई करी आया है, तां तू इदे तांई बडी धाम लगायी। ");
INSERT INTO bht_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“उनी उसला बोलया, मेरा पुत्र तू हेमेशा मेरे सोगी है; कने जड़ा कुछ मेरा है सै सब कुछ तेरा ही है। ");
INSERT INTO bht_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","पर हुण तिजो खुशी मनाणी कने मगन होणा चाईदा क्योंकि तेरा ऐ भाई मरी गिया था पर ऐ मरया नी है: गवाची गिया था, पर हुण मिली गिया है।” ");
INSERT INTO bht_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","फिरी उनी चेलयां जो भी कहाणी सुणाई, कुसकी इक अमीर बन्दे दा इक भंडारी था, कने लोकां उदे सामणे उस पर इलजाम लगाया की ऐ तेरिया धन दौलत जो उड़ाई दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","कने उनी अमीर बंदे अपणे भंडारी जो सदीकरी बोलया, ऐ क्या है जड़ा मैं तेरे बारे च मैं क्या सुंणादा है? तू मेरे पैसयां दा क्या कितया है सारा हिसाब दे; क्योंकि तू अजे बाद भंडारी नी है। ");
INSERT INTO bht_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“तालू भंडारी सोचणा लग्गा, की हुण मैं क्या करे? क्योंकि मेरा मालिक मिंजो भंडारी दे कम्मे ला कडा दा है: कोई मेहनत बाला कम्म तां मिंजो ला होंदा नी, कने भीख मंगणे ने मिंजो शर्म ओंदी है।” ");
INSERT INTO bht_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","मिंजो पता है की क्या करणा ताकि जालू मिंजो भंडारिये दे कम्मे ला कडया जांगा तां लोक मेरी मदद करन। ");
INSERT INTO bht_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","कने उनी अपणे मालिके दे देंणदारां जो इक-इक करी के सदया कने पेहले ला पुछया, की तिजो पर मेरे मालिके दा कितणा कर्ज है? ");
INSERT INTO bht_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","उनी बोलया, 3,700 लिटर तेल, तालू उनी उसला बोलया, की अपणी खाता बही ले कने बेईकरी झट 1,850 लिटर तेल लिखी दे। ");
INSERT INTO bht_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","फिरी दुज्जे ला पुछया, तिजो पर कितणा कर्ज है? उनी उसला बोलया, 20,000 किलो कणक, तालू उनी उसयो बोलया, अपणा बही खाता ले कने 16,000 किलो कणक लिखी दे। ");
INSERT INTO bht_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","मालिके उस अधर्मी भंडारी दी तारीफ किती, की उनी चलाकिया ने कम्म कितया है; क्योंकि इसा दुनिया दे लोक अपणे बकते दे लोकां सोगी व्यवहार करणे च ज्योति दे लोकां ला जादा चलाक न। ");
INSERT INTO bht_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","कने मैं तुसां ने बोलदा है, की संसारिक पेसे ने अपणे तांई मित्र बणाई लिया; ताकि जालू ऐ पैसा नी रेंगा तां अनन्तकाल दे घरे च तुहांजो रेहणे तांई जगा दे। ");
INSERT INTO bht_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","जड़ा छोटिया-छोटिया गल्लां च भरोसे दे लायक है, सै बडियां गल्लां च भी भरोसे दे लायक है: छोटिया-छोटिया गल्लां च भरोसे दे लायक नी है, सै बडियां गल्लां च भी भरोसे दे लायक नी है। ");
INSERT INTO bht_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","इस तांई जालू तुसां संसारिक पैसे च भरोसे दे लायक नी, तां तुहांजो स्वर्गे दा धन कुनी देणा? ");
INSERT INTO bht_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","अगर तुसां होरसी दे पैसे च भरोसे दे लायक बणी रे, तां जड़ा तुहाड़ा है, उसयो तुहांजो कुण दिंगा? ");
INSERT INTO bht_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“कोई सेवक दो मालिकां दी सेबा नी करी सकदा: क्योंकि उनी इकी ने बेर कने इकी ने प्यार रखणा; या इकी ने मिली की रेंणा कने दुज्जे जो बुरा समझणा: तुसां परमेश्वर कने धन दौलत दोनो दी सेबा नी करी सकदे।” ");
INSERT INTO bht_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","फरीसी जड़े लालची थे, ऐ सारियां गल्लां सुणिकरी उदा मजाक उड़ाणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","यीशुऐ उना ने बोलया, “तुसां तां माणुऐ दे सामणे अपणे आपे जो सही दसदे न: पर परमेश्वर तुहाड़े मने जो जाणदा है, जड़ी चीज आदमियां दिया नजरा च बड़ी जरूरी है, सै परमेश्वरे दिया नजरा च बुरी है।” ");
INSERT INTO bht_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","जालू यूहन्ना बपतिस्मा देणेबाला आया, उसला पेहले मूसा दी व्यवस्था कने परमेश्वरे दा संदेश देणेबाले तुहाड़े मार्गदर्शक थे, पर परमेश्वरे दे राज्य दा शुभसमाचार दा प्रचार सुणाया जादा है, कने हर कोई परमेश्वरे दे राज्य अंदर जाणे तांई उताबले न। ");
INSERT INTO bht_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“परमेश्वरे दिया व्यवस्था दे इक बिन्दुए दे मिटी जाणे ला, अम्बर कने धरतिया दा खत्म होई जाणा असान है।” ");
INSERT INTO bht_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","उदाहरण तांई जड़ा कोई अपणिया घरे बालिया जो छडी करी दुजिया ने बियाह करदा है, सै ब्यभिचार करदा है, कने जड़ा कोई ऐदिया जनानिये ने बियाह करदा है, सै भी व्यभिचार करदा है। ");
INSERT INTO bht_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","यीशुऐ इक होर कहाणी सुणाई इक अमीर माणु था सै बड़े मेंगे कने मलमले दे कपड़े पेहनदा था कने हर रोज शानदार खाणा खादां कने ठाठ बाठ ने रेंदा था। ");
INSERT INTO bht_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","कने लाजर नाऐ दा इक गरीब जिदे शरीरे च फोडे़ थे उसयो लोक उस अमीर माणुऐ दे घरे बाहर छडी दिन्दे थे। ");
INSERT INTO bht_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","कने सै चांदा था, की अमीर माणुऐ दे खाणे बाद बचयो जूठे टुकड़यां ने अपणा पेट भरे, कने कुत्ते भी आई करी उदे जखमा जो चटदे थे। ");
INSERT INTO bht_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","कने इयां होया की सै गरीब मरी गिया, कने स्वर्गदूत लाजर जो पूर्वज अब्राहम बाल लेई गिया। कने सै अमीर भी मरया कने दबी दिता, ");
INSERT INTO bht_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","कने पताल च पीड़ा ने तड़फदे होऐ उनी उपर दिखया कने दुरे ला लाजर जो अब्राहमे दे बखे बैठया दिखया। ");
INSERT INTO bht_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","कने उनी जोरे ने अबाज लाईकरी बोलया, हे पिता अब्राहम, मिंजो पर दया करी के लाजरे जो मिंजो बाल भेजी दे, ताकि सै मिंजो अपणिया उंगलियां दे सिरे जो सेड़ी करी मेरिया जीभा जो ठंडा करे, क्योंकि मैं इसा अग्गी ने तड़पा दा है। ");
INSERT INTO bht_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","पर अब्राहमे बोलया, हे पुत्र याद कर, की तू अपणिया जिंदगियां च खरियाँ चिजा लेई बैठया है, कने तियां ही लाजर जो सारियां बुरियां चिजां पर इसयो हुण ऐथू शांति मिल्ला दी है, कने तू तड़फा दा है। ");
INSERT INTO bht_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","कने इना सारियां गल्लां जो छडी करी साड़े कने तुहाड़े बिच इक बड़ी बड्डी खाई है ताकि जड़ा ऐथू ला उस पार जाणा चा सै ना जाई सके, कने ना कोई ओथु ला इस पार साड़े बाल आई सके। ");
INSERT INTO bht_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","उनी बोलया, हे पिता जी, मैं तिजो ने बिनती करदा है, की तू लाजर जो मेरे पिता दे घरे भेज, ");
INSERT INTO bht_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","क्योंकि मेरे पंज भाई न, मैं चांदा है की लाजर जाऐ कने मेरे भाईयां जो चेताबनी दे, इयां ना होऐ की सै भी इसा पीड़ा दिया भयानक जगा च ओन। ");
INSERT INTO bht_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","अब्राहमे उसला बोलया, उना बाल चेताबनी देणे तांई तां मूसा दी व्यवस्था कने परमेश्वरे दा संदेश देणेबाले न, उना जो इना जो सुणना चाईदा। ");
INSERT INTO bht_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“उनी बोलया, नि, पिता अब्राहम; पर अगर कोई उना जो चेताबनी दे, तां उना अपणे पापां दा पश्चाताप करणा है। ");
INSERT INTO bht_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","अब्राहमे उसयो बोलया, जद सै मूसा कने परमेश्वरे दा संदेश देणेबालयां दी नी मंदे न, तां अगर कोई मरयां चे जिन्दा होई जा तां उना उदी गल्लां दा भी भरोसा नी करणा।” ");
INSERT INTO bht_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","फिरी यीशुऐ अपणे चेलयां बोलया, ऐ गल्ल ता पक्की है कि परिक्षां माणुऐ पर जरुर ओणियां न जड़ा उना जो पाप करणे दी बजा बणगा, पर हाय उसी माणुऐ पर, जिदिया बजा ने सै ओंदियां न। ");
INSERT INTO bht_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","पर जड़ा कोई इना छोटयां चे कुसी इकी जो भी भरोसे ला भटकांदा है या उना दे पाप करणे दी बजा बणदा है, उदे तांई तां खरा होंदा, कि उदे गले च बड्डे घराटे दा पथर लटकाया जाऐ, कने डुगे समुंद्रे च डोबया जाऐ। ");
INSERT INTO bht_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“ध्यान रखा; अगर तेरा मसीह भाई गलत कम्म करे तां उसयो समजाआ, कने अगर सै पछतांगा तां उसयो माफ करी दे।” ");
INSERT INTO bht_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“अगर सै दिन भर च सत बरी तिजो ने गलत करे कने सतों बरी तेरे बाल आई करी बोले, की मैं पछतादां है, तां उसयो माफ करी दे।” ");
INSERT INTO bht_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","तालू प्रेरितां प्रभु यीशु ने बोलया, “साड़े भरोसे जो होर जादा बढ़ा कने मजबूत करा।” ");
INSERT INTO bht_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","प्रभुऐ बोलया, अगर तुहाड़ा भरोसा राईया दे दांणे बराबर भी होंदा, तां अगर तुसां इस तुते दे रुखे जो बोलदे की तू जड़ा ला उखड़ी करी समुद्रे च लगी जा, तां उनी तुहाड़ी मनी लेणी। ");
INSERT INTO bht_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","अगर तुहाड़ा सेवक हल जोती करी, या भेडां चुगाई करी बापस घरे जो ओऐ, तां उसयो बोले, झट आ कने रोटी खाई ले? ");
INSERT INTO bht_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ना, उनी तां इयां बोलणा, की मिंजो तांई रोटी बणा कने जालू दीकर मैं रोटी खां तालू दीकर मेरी सेबा करणे तांई तैयार रे इदे बाद तू भी खाई लियां? ");
INSERT INTO bht_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","क्या तुसां अपणे सेवके जो उस कम्मे जो करणे तांई धन्यबाद नी करगे जड़ा तुसां उसयो करणे तांई बोलया था? ");
INSERT INTO bht_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“इयां ही जालू तुसां सै सब कुछ करी लिया हो जड़ा तुसां जो करणे तांई बोलया था, तां तुसां जो ऐ बोलणा चाईदा, असां निकम्मे सेवक न; की जड़ा सांझो करणा चाईदा था सेई असां कितया है।” ");
INSERT INTO bht_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","जालू यीशु कने उदे चेले यरूशलेम शेहरे जाणे बाले रस्ते पर चलयो थे, सै सामरियां कने गलील प्रदेश ला होईकरी जा दे थे। ");
INSERT INTO bht_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","कने कुसकी ग्रांऐ ला जांदे बेले उसयो दस कोढ़ी मिल्ले। ");
INSERT INTO bht_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","कने उना दुरे ला ही खड़ोई करी, “जोरे ने बोलया, यीशु जी, मालिक जी, सांझो पर दया कर।” ");
INSERT INTO bht_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","यीशुऐ उना जो दिखीकरी बोलया, “यरूशलेम दे मंदिर च जाओ; कने अपणे आपे जो याजकां जो दस्सा कि तुसां खरे होई गियो न” कने सै जांदे-जांदे ही ठीक होई गे। ");
INSERT INTO bht_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","तालू उना चे इकी ऐ दिखया की मैं ठीक होई गिया है, सै जोरे ने बोली करी परमेश्वरे दी बड़ाई करदा यीशुऐ बाल बापस आया; ");
INSERT INTO bht_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","कने यीशुऐ दे पैरां पर झुकी करी धन्याबाद करणा लग्गा; कने सै सामरी था। ");
INSERT INTO bht_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","इसा गल्ला पर यीशुऐ बोलया, क्या सै दसो जणे ठीक नी होऐ, तां सै होर नौ जणे कतां न? ");
INSERT INTO bht_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","“क्या इस गैर यहूदी जो छडी करी कोई होर नी निकलया, जड़ा परमेश्वरे दी बड़ाई करदा है?” ");
INSERT INTO bht_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","तालू यीशुऐ उसला बोलया, “उठी करी चली जा; क्योंकि तू भरोसा कितया है की तु ठीक होई गिया है।” ");
INSERT INTO bht_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","जालू फरीसियां उसयो पुछया, की परमेश्वरे दा राज्य कालू ओणा है? तां यीशुऐ उना जो जबाब दिता, “परमेश्वरे दा राज्य इयोदिया नी है, जिसयो तुसां दिखी सकदे न। ");
INSERT INTO bht_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","कने लोकां ऐ नी बोलणा, की दिखा, ऐथू है, या ओथु है। क्योंकि दिखा, परमेश्वरे दा राज्य तुहाड़े बिच है।” ");
INSERT INTO bht_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","कने यीशुऐ चेलयां ने बोलया, सै दिन ओणे न, जिना च तुसां माणुऐ दे पुत्रे दे रोजां चे इकी रोजे जो दिखणा चाणा है, पर नी दिखी सकणा है। ");
INSERT INTO bht_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","लोकां तुसां ने बोलणा, दिखा मसीह ओथु है! या दिखा ऐथू है! पर तुसां चली मत जांदे कने पिच्छे ही मत होई जांदे। ");
INSERT INTO bht_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","क्योंकि जियां बिजली अम्बरे दे इकी छोरे ला दुए छोरे दीकर चमकदी है, तियां ही मैं माणुऐ दे पुत्रे भी अपणे रोजे च सामणे ओणा है। ");
INSERT INTO bht_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","पर पेहले बड़ा जरूरी है, की सै बड़े जादा दुख झेले, कने उसयो इसा पीढ़ी दे लोक निच बोलन। ");
INSERT INTO bht_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","जियां साड़े पूर्वज नूह दे रोजां च होया था, तियां ही माणुऐ दे पुत्रे दे रोजां च होणा है। ");
INSERT INTO bht_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","जिस रोजे दीकर नूह जहाजे पर नी चढ़या, उस दिने दीकर लोक खांदे पिंदे थे, कने उना च बियाह शादियां होंदिया थियां; तालू जल-प्रलय आई कने सब कुछ खत्म करी दिता। ");
INSERT INTO bht_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","कने तियां रिती ला ही साड़े पूर्वज लूत दे रोजां च होया था जड़ा सदोम शेहरे च रे दा था, की लोक खांदे-पिंदे कने लेंण देंण करदे, कने पेड़ लागांदे कने घर बणादें थे; ");
INSERT INTO bht_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","पर जिस रोजे लूत सदोमे ला निकलया, उस रोजे अम्बरे ला अग्ग गन्धक बरसी कने सारे लोकां जो जड़े शेहर च रेंदे थे खत्म करी दिता। ");
INSERT INTO bht_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","कने सै रोज भी इयोदिया होणा, जालू मैं माणुऐ दे पुत्रे इयां ही इकदम दोबारा बापिस ओणा है। ");
INSERT INTO bht_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","उस रोजे जड़ा छती पर होंगा, कने उदा समान घरे हो, तां सै उसयो लेंणे तांई थले ना उतरे, कने तियां ही जड़ा खेतरे जो गिया हो सै बापस नी ओऐ। ");
INSERT INTO bht_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","साड़े पूर्वज लूत दी घरे आली जो याद रखा, की उसा कने क्या होया था। ");
INSERT INTO bht_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","जड़ा कोई अपणे प्राणा जो बचाणा चांहगा, उनी परमेश्वरे सोगी आत्मिक जिन्दगी जिणे दा मोका खोई देणा है। जड़ा कोई मेरे तांई अपणी जान गबांगा उसयो परमेश्वरे सोगी सदा तांई दी जिन्दगी मिलणी। ");
INSERT INTO bht_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","मैं तुसां ने बोलदा है, उसा राती दो माणु इकी मंझे पर होणे, पर इक लेई जाणा कने दुज्जे जो छडी देणा है। ");
INSERT INTO bht_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","“दो जनानिया सोगी चक्की पियाँ दियां होणियां, इक लेई जाणी कने दुई छडी देणी। ");
INSERT INTO bht_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(दो जणे खेतरे च होणे न, इक लेई जाणा कने दूजा छडी देणा।)” ");
INSERT INTO bht_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ऐ सुणीकरी उना उसला पुछया, हे प्रभु ऐ कुथु होणा है? उनी उना ने बोलया, हर कोई जाणदा है ऐ कुथु होणा है तियां सारे जाणदे न जिथू लाश है, ओथु इल्लां गिठियां होंदियां न। ");
INSERT INTO bht_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","फिरी यीशुऐ अपणे चेलयां जो इदे बारे बोलया की रोज प्राथना करणा कने कदी हिम्मत नी छडणी चाईदी, इस तांई उना ने ऐ कहाणी सुणाई: ");
INSERT INTO bht_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“कुसकी शेहरे च इक न्यायधीश रेंदा था; सै ना परमेश्वरे ला डरदा था ना कुसी माणुऐ दी परवाह करदा था।” ");
INSERT INTO bht_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","कने उसी शेहरे च इक बिधवा भी रेंदी थी: जड़ी उदे बाल आई करी बोलदी थी, की मेरा न्याय करी के मिंजो दुशमणे ला बचाई ले। ");
INSERT INTO bht_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","कने बड़े दिना दीकर तां मनया नी पर आखरी च मने च सोची करी बोलया, मैं ना परमेश्वरे ला डरदा, कने ना आदमियां दी परवाह करदा है; ");
INSERT INTO bht_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","तमी ऐ बिधवा मिंजो तंग करदी रेंदी है, इस तांई मैं इसा दा न्याय करणा है, कुथी इयां ना हो की बार-बार आई करी आखरी च मिंजो बुरी तरह थकाई दे। ");
INSERT INTO bht_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","प्रभु ने बोलया, सुंणा, की इनी अधर्मी न्यायधीशे क्या बोलया है, उस बारे च ध्याने ने सोचा। ");
INSERT INTO bht_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","क्या परमेश्वर अपणे चुणयो लोकां दा न्याय नी करणा, जड़े रात-दिन उदे सामणे रोंदे न; परमेश्वरे उना दी मदद करणे च देर नी करणी है? ");
INSERT INTO bht_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","“मैं तुसां ने बोलदा है; उनी झट उना दा न्याय करणा; तमी जालू मैं, माणुऐ दे पुत्रे बापस धरती ओंणा, तां मिंजो हेरानी होंदी है की क्या मिंजो धरतिया पर ऐसा माणु मिलगा जड़ा मिंजो पर भरोसा करदा हो।” ");
INSERT INTO bht_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","कने यीशुऐ उना लोकां ने जड़े अपणे बारे च सोचदे न, की असां धर्मी न, कने दुजयां जो निच बोलदे थे, ऐ कहाणी सुणाई ");
INSERT INTO bht_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“दो माणु मंदरे च प्राथना करणा गे; इक फरीसी था कने दूजा कर लेणे बाला था। ");
INSERT INTO bht_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","फरीसी खड़ोई करी अपणे मने च इयां प्राथना करणा लग्गा, की हे परमेश्वर, मैं तेरा धन्यबाद करदा है, की मैं होरनी माणुऐ सांई बुरा करणे बाला, अन्यायी कने व्यभिचारी नी है, कने ना ही इस कर लेणेबाले सांई है। ");
INSERT INTO bht_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","मैं हफ्ते च दो बरी बरत रखदा है; मैं अपणिया कमाईया दा दसमां हिसा भी तुसां जो दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","पर कर लेणेबाले दुर खड़ोई करी, स्वर्गे पासे दिखणा भी नी चाया, पर सै दुखे ने अपणिया छातिया पिटी-पिटी करी बोलणा लग्गा, हे परमेश्वर मैं पापी है, मिंजो पर दया कर, मिंजो माफ कर। ");
INSERT INTO bht_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","यीशुऐ बोलया मैं तुसां ने बोलदा है, की ऐ चुंगी लेणे वाला था ना की फरीसी माणु जड़ा परमेश्वरे सामणे धर्मी दसया; क्योंकि जड़ा कोई अपणे आपे जो बड़ा महान बणागा, सै छोटा करी देणा है; कने जड़ा अपणे आपे जो छोटा बणागा, उसयो आदर मान मिलणा।” ");
INSERT INTO bht_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","फिरी लोक अपणे बचयां जो यीशुऐ बाल लोणा लग्गे, ताकि सै उना पर हथ रखे; कने चेलयां दिखीकरी उना जो डांटया। ");
INSERT INTO bht_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","यीशुऐ बचयां जो अपणे बाल सदीकरी बोलया, बचयां जो मना मत करा कने इना जो मेरे बाल ओंणा दिया, क्योंकि परमेश्वरे दा राज्य उना दा है जड़ा इना बचयां सांई है। ");
INSERT INTO bht_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","मैं तुसां ने सच्च बोलदा है, परमेश्वरे अपणे राज्य च सिर्फ उना लोकां जो ओणा देणा है जड़े परमेश्वरे दे राज्य जो बचयां सांई अपनांदा है। ");
INSERT INTO bht_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","कुंनकी यहूदी अधिकारिये उसला पुछया, “उत्तम गुरू जी, मैं क्या कम्म करां की परमेश्वर मिंजो हमेशा दी जिन्दगी दे?” ");
INSERT INTO bht_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","यीशुऐ उसयो बोलया, तुसां मिंजो कजो उत्तम बोलदे न, उत्तम तां सिर्फ इक ही है, सै परमेश्वर है। ");
INSERT INTO bht_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","तू परमेश्वरे दे हुक्मा जो तां जाणदा है की: “व्यभिचार नी करणा, झूठी गबाई नी देंणी, अपणे माता पिता दा आदर करणा।” ");
INSERT INTO bht_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","उनी बोलया, “मैं तां इना सबना हुक्मा जो तां बचपन ला मनदा आया है।” ");
INSERT INTO bht_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ऐ सुणीकरी, यीशुऐ उसला बोलया, तिजो च अजे भी इक गल्ला दी कमी है, जा, कने जड़ा कुछ तेरा है उसयो बेची करी गरीबां जो देई दे, तां तिजो स्वर्गे दा धन मिलणा, इयां करणे बाद आ कने मेरा चेला बणिया। ");
INSERT INTO bht_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","सै ऐ सुणीकरी बड़ा उदास होई गिया, क्योंकि सै बड़ा अमीर था। ");
INSERT INTO bht_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","यीशुऐ उसयो दिखीकरी बोलया, अमीरां दा परमेश्वरे दे राज्य च जाणा बड़ा मुशकिल है। ");
INSERT INTO bht_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ऊंटे दा सुइया दे नाके चे निकलना असान है, पर अमीरां दा परमेश्वरे दे राज्य च जाणा बड़ा भरी मुशकिल है। ");
INSERT INTO bht_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","कने सुणने बालयां बोलया, “अगर ऐसा है तां कुण अपणे पापां दी सजा मिलणे ला बची सकदा है?” ");
INSERT INTO bht_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","यीशुऐ जबाब दिता, “जड़ा माणुऐ ला नी होई सकदा है सै परमेश्वरे ला होई सकदा है।” ");
INSERT INTO bht_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","पतरसे यीशुऐ जो पुछया, दिख, असां तां घर-बार छडी करी तेरे पिच्छे चलयो न। ");
INSERT INTO bht_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","यीशुऐ उना जो जबाब दिता, “मैं तुसां ने सच्च बोलदा है, जिनी भी परमेश्वरे दे राज्य तांई घर, या घरे बाली, या भाई, या माता पिता, या बाल बचयां जो छडी दितया हो। ");
INSERT INTO bht_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","कने इस बेले केई गुणा जादा मिलणा; पर परलोके च हमेशा दी जिन्दगी मिलणी।” ");
INSERT INTO bht_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","फिरी यीशुऐ बाहरां चेलयां जो एकांत च लेईजाई करी उना ने बोलया, दिखा, असां यरूशलेम शेहरे जो जाणा है, कने जितणियां भी गल्लां मेरे, माणुऐ दे पुत्रे तांई परमेश्वरे दा संदेश देणेबालयां लिखियां न सै सारियां पुरियां होणियां न। ");
INSERT INTO bht_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","“क्योंकि सै होर जातियां दे हथे देई देणा है। कने उना मेरा मजाक उड़ाणा है, कने मेरी निंदा करी के मिंजो पर थुकणा, ");
INSERT INTO bht_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","कने मिंजो कोड़े मारणे, कने मिंजो मारी देणा है, कने मैं तिजे दिने मैं मरयां चे जिंदे होई जाणा है।” ");
INSERT INTO bht_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","कने चेलयां इना गल्लां चे कोई भी गल्ल नी समझ आई: कने ऐ गल्ल उना च ही लुक्की रेई, कने जड़ा बोलया था सै उना दिया समझा च नी आया। ");
INSERT INTO bht_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","जालू यीशु यरीहो शेहरे दे बखे पुज्जा, तां इक अन्ना सड़का कंडे बेईकरी भिख मंगा दा था। ");
INSERT INTO bht_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","कने भिड़ा दी चलने दी अबाज सुणीकरी पुछणा लग्गा, ऐ क्या होआ दा है? ");
INSERT INTO bht_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","उना उसयो दसया, “नासरत दा यीशु मसीह जा दा है।” ");
INSERT INTO bht_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","तालू उनी अबाज लाईकरी बोलया, “हे यीशु, राजा दाऊदे दे बंशज, मिंजो पर दया कर।” ");
INSERT INTO bht_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","जड़े अग्गे-अग्गे चलयो थे, सै उसयो डांटणा लग्गे की चुप रे: पर सै होर जोरे ने बकणा लग्गा, “हे राजा दाऊदे दी बंशज मिंजो पर दया कर।” ");
INSERT INTO bht_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","तालू यीशुऐ ऐ सुणया कने रुकी करी बोलया, “उसयो ऐथू लोआ।” कने तालू सै बखे आया तां यीशुऐ उसयो पुछया, ");
INSERT INTO bht_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“तू क्या चांदा है की मैं तेरे तांई करे?” अन्ने उसने बोलया, गुरू जी, ऐ की मिंजो मिलणा लगी पोऐ। ");
INSERT INTO bht_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","यीशुऐ उसयो बोलया, “दिखणा लग, तेरे भरोसे जड़ा मिंजो पर है तिजो ठीक करी दिता है।” ");
INSERT INTO bht_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","कने सै झट मिलणा लगी पिया; कने परमेश्वरे दी बड़ाई करदा होया उदे पिच्छे चली पिया, कने सारे लोंका ऐ दिखीकरी परमेश्वरे दी स्तुति किती। ");
INSERT INTO bht_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","यीशु यरीहो शेहर ला होईकरी जा दा था। ");
INSERT INTO bht_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","कने दिखा, जक्कई नाऐ दा इक माणु था जड़ा चुंगी लेणेबालयां दा सरदार कने अमीर था। ");
INSERT INTO bht_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","सै यीशुऐ जो दिखणा चांदा था की सै कुण दिया है? पर भिड़ा दिया बजा ने सै दिखी नी सका दा था। क्योंकि सै छोटे कदे दा माणु था। ");
INSERT INTO bht_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","तालू सै उसयो दिखणे तांई अग्गे दोड़ी करी इक गूलर दे रुखे पर चढ़ी गिया, क्योंकि यीशु उसी रस्ते ला जाणे बाला था। ");
INSERT INTO bht_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","जालू यीशु उसा जगा पर पुज्जा जिथू जक्कई था, तां यीशुऐ उपरे पासे दिखीकरी बोलया, हे जक्कई, झट उतरी आ; क्योंकि अज मिंजो तेरे घरे रेंणा जरूरी है। ");
INSERT INTO bht_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","सै झट रुखे ला उतरया कने यीशुऐ जो खुशिया ने अपणे घरे जो लेई गिया, कने खुशिया सोगी उदा स्वागत किता। ");
INSERT INTO bht_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ऐ दिखीकरी सारे लोक बुड़बड़ाणा लग्गे, “की सै तां इक पापी माणुऐ दे घरे चली गिया है।” ");
INSERT INTO bht_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","जक्कई खाणे दे बकते खड़ोई करी यीशु ने बोलणा लग्गा, “प्रभु जी, दिख मिंजो बाल जड़ा कुछ है सै गरीबां जो दिन्दा है, कने अगर मैं लोकां ला चुंगी लेणे च बेईमानी कितियो है तां उसयो चार गुणा बापस करी दिन्दा है।” ");
INSERT INTO bht_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","तालू यीशुऐ उसला बोलया, अज इसी घरे दे लोकां बिच उद्धार आया है, क्योंकि ऐ भी अब्राहमे दा बंशज है। ");
INSERT INTO bht_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","“क्योंकि मैं, माणुऐ दा पुत्र गवाचयां जो तोपणा कने उना जो अनन्त सजा ला बचाणे तांई आया है।” ");
INSERT INTO bht_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","जालू लोक ऐ गल्लां सुंणा दे थे तां यीशुऐ उना जो इक कहाणी सुणाई, इस तांई की सै यरूशलेम शेहरे दे नेड़े था, कने लोकां जो लगया की परमेश्वरे दा राज्य बस हुण ओणे बाला है। ");
INSERT INTO bht_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","यीशुऐ बोलया, इक अमीर माणु दुर देशे जो चलया ताकि राजपद पाई करी बापस आई जा। ");
INSERT INTO bht_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","कने उनी अपणे दस सेवकां जो दस मुहरां दितियां, कने उना ने बोलया, मेरे बापस ओणे दीकर लेण देण करनयो। ");
INSERT INTO bht_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","पर उदे शेहरे बाले उसला बैर रखदे थे, उदे पिच्छे संदेश देणेबाले दूतां ने बोली भेजया, की असां नी चांदे न की ऐ सांझो पर राज करे। ");
INSERT INTO bht_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","जालू सै राजपद लेईकरी बापस आया, तां इयां होया की उनी अपणे सेवकां जो जिना जो मुहरां दितियां थियां, अपणे बाल सदया ताकि पता लग्गे की लेणे देणे ने उना क्या-क्या कमाया है। ");
INSERT INTO bht_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","तालू पेहले आई करी बोलया, हे मालिक तेरियां मुहरां ने मैं दस होर मुहरां कमाईया न। ");
INSERT INTO bht_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","उनी उसला बोलया, उत्तम सेवक, बड़ा खरा किता, तू बड़े ही थोड़े च भरोसे बाला निकलया हुणे ला तू दसां नगरां दा अधिकारी। ");
INSERT INTO bht_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","दुज्जे आई करी बोलया, हे मालिक तेरिया मुहरां ने मैं पंज होर मुहरां कमाईया न। ");
INSERT INTO bht_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","उनी उसला बोलया, जा तू भी पंजा नगरां दा अधिकारी। ");
INSERT INTO bht_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","कने तिजे आई करी बोलया, हे मालिक दिख, तेरी मोहर ऐ है, जिसा जो मैं गमछे च बनी करी रखया था। ");
INSERT INTO bht_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","क्योंकि मैं तिजो ला डरदा था, क्योंकि तू बड़ा सकत माणु है: जड़ा तू नी रखया होंदा उसयो तू चुकी लेंदा, कने जड़ा तू नी राया है, उसयो तू बडदा है। ");
INSERT INTO bht_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","उनी उसला बोलया, हे निकम्मे सेवक, मैं तेरियां ही गल्लां ने तिजो दोषी बणादा है: तू मिंजो जाणदा था की मैं सकत माणु है, जड़ा मैं नी रखदा है उसयो चुकी लेंदा है, कने जड़ा मैं नी राया उसयो बडी लेंदा है? ");
INSERT INTO bht_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","तां तू मेरे पैसे बयाजे पर महाजना बाल कनी रखी दिते, इयां करदा तां मैं आई करी बयाजे समेत लेई लेंदा। ");
INSERT INTO bht_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","कने जड़े लोक उदे बखे खड़ोतयो थे, मालिके उना ने बोलया, इसला मुहरां जो लेई लिया, कने जिसदे बाल दस मुहरां न उसयो देई दिया। ");
INSERT INTO bht_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","उना मालिके ने बोलया, हे मालिक, उस बाल दस मुहरां तां हेन। ");
INSERT INTO bht_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","मालिके उना जो बोलया, “जिना बाल समझणे दी इच्छा है जड़ा परमेश्वर सिखांदा है, उसयो परमेश्वरे होर समझ देणी, पर जड़ा समझणे दी इच्छा नी रखदा, की मैं क्या सिखादां, तां थोड़ा जड़ा उसयो समझ आया से भी उसला लेई लेणा।” ");
INSERT INTO bht_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“पर मेरे उना बैरियां जो जड़े नी चांदे थे की मैं उना दा राजा बणा, उना जो मेरे सामणे लेई ओआ कने मारी दिया।” ");
INSERT INTO bht_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ऐ गल्लां बोली करी यीशु अपणे चेलयां सोगी यरूशलेम शेहरे दे पासे उना दे अग्गे-अग्गे चलया। ");
INSERT INTO bht_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","कने सै जालू जैतून रुखां दे पाहड़े पर बैतफगे कने बैतनिय्याह ग्रांऐ दे बखे पुज्जा, तां उनी अपणे दों चेलयां जो ऐ बोली करी भेजया, ");
INSERT INTO bht_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","सामणे दे ग्रां च जा, कने ओथु पुजदे ही तुहांजो इक गधिया दा बच्चा बन्नया मिलणा है, उदे उपर हिली कोई नी बैठया था, सै खुंडे च बन्नया होणा उसयो खोली करी लेई ओआ। ");
INSERT INTO bht_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“कने अगर कोई तुहांजो ला पुच्छे, की कजो खोला दे न, तां ऐ बोली देणा, कि प्रभु जो इसदी जरूरत है।” ");
INSERT INTO bht_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","जड़े चेले भेजयो थे, उना जाई करी सियुदा ही दिखया, जियां यीशुऐ बोलया था। ");
INSERT INTO bht_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","जालू सै गधे दे बच्चे जो खोला दे थे, तां उदे मालिके उना ला पुछया, “इसयो कजो खोला दे न?” ");
INSERT INTO bht_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","उना बोलया, “प्रभु जो इसदी जरूरत है।” ");
INSERT INTO bht_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","सै उसयो यीशुऐ बाल लेई आये कने अपणे कपड़े उदे उपर पाई दिते कने यीशु उस पर बैठी गिया। ");
INSERT INTO bht_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","जालू यीशु गधे पर बेईकरी जा दा था, तां मतयां लोकां अपणे कपड़े रस्ते च बछाई दिते। ");
INSERT INTO bht_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","यरूशलेम शेहरे जांदे बेले जालू यीशु जैतून रुखां दे पाहड़े दिया उतराईया च पुज्जा, तां चेलयां दी सारी मंडली उना सारे अनोखे कम्मा दिया बजा ने जड़े उना दिखयो थे, खुश होईकरी जोरे ने सारे परमेश्वरे दी स्तुति करणा लग्गे: ");
INSERT INTO bht_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“धन्य हो सै राजा, जड़ा प्रभु दे नाऐ ने ओंदा है। स्वर्गे च शांति कने अम्बरे च महिमा हो।” ");
INSERT INTO bht_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","तालू भिड़ा चे कितणे ही फरीसी उसयो बोलणा लग्गे, “गुरू जी, अपणे चेलयां जो ऐ गल्लां बोलणे तांई डांट।” ");
INSERT INTO bht_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","यीशुऐ जबाब दिता, “मैं तुसां ने बोलदा है, अगर ऐ लोक चुप रे, तां पथरां बोली पोंणा है।” ");
INSERT INTO bht_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","जालू यीशु यरूशलेम शेहरे बखे आया तां उस शेहरे जो दिखीकरी रोया। ");
INSERT INTO bht_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","कने बोलया, की तेरे तांई कितणा भला होंदा, कि तू, इस रोजे तू परमेश्वरे दिया शांतिया दियां गल्लां समझदा जड़ियां तिजो शान्ति दिन्दियां, पर हुण सै तेरिया नजरा ला लुक्की गियां न। ");
INSERT INTO bht_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","“क्योंकि सै दिन तिजो पर ओणे न जालू तेरे दुशमणा हर तरफा ला शेहर पर हमला करणा है, कने चारो पासे ला तुहांजो दबाई देणा है। ");
INSERT INTO bht_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","तेरे दुशमणा पूरी तराह ने शेहरे जो खत्म करी देणा कने तेरे सारे लोकां जो मारी देणा, कने तिजो च पथरे पर पथर भी नी छडणा है; क्योंकि तू सै मोका नी पछेणया जालू परमेश्वर तिजो बचाणे तांई आया था।” ");
INSERT INTO bht_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","तालू सै मंदरे च जाई करी बेचणे बालयां जो बाहर कडणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","कने यीशुऐ उना जो बोलया, पबित्र शास्त्र च लिखया है की, मेरा घर प्राथना दा घर होणा, पर तुसां तां इसयो डाकुआं ला भरुईयो गुफा सांई बणाई दितया है। ");
INSERT INTO bht_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","कने सै हर रोज मंदरे च उपदेश दिन्दा था: कने बड्डे याजक कने यहूदी व्यवस्था जो सिखाणे बालयां कने बड्डे लोक उसयो मारणे दा मोका तोपदे रेंदे थे। ");
INSERT INTO bht_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","पर कोई तरिका नी तोपी सके; की ऐ कियां करणा, क्योंकि सारे लोक उसयो बड्डे चाऐ ने सुणदे थे। ");
INSERT INTO bht_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","इक रोज ऐसा होया की जालू यीशु लोकां जो मंदरे च उपदेश दे दा था, कने शुभसमाचार सुंणा दा था, तां बड्डे याजक कने यहूदी व्यवस्था जो सिखाणे बाले कने यहूदी अगुवे यीशुऐ बाल आया। ");
INSERT INTO bht_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","कने बोलणा लग्गे, “सांझो दस, तू इना कम्मा जो कुस अधिकारे ने करदा है, कने सै कुण है, जीनी तिजो ऐ हक दितया है?” ");
INSERT INTO bht_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","यीशुऐ उना जो जबाब दिता, “मैं भी तुसां ला इक सबाल पुछदा है, मिंजो दसा तां मैं भी दसगा: ");
INSERT INTO bht_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","यूहन्ना जो लोकां जो बपतिस्मा देणे तांई कुनी भेजया था? क्या सै परमेश्वरे भेजया था या माणुऐ? मिंजो दसा।” ");
INSERT INTO bht_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","तालू सै अपु चे बोलणा लग्गे कि अगर असां ऐ बोलया कि, “परमेश्वर जड़ा स्वर्गे च है उनी भेजया है, तां यीशुऐ सांझो ला पुछणा, कि तुसां युहन्ना पर भरोसा कन्नी किता?” ");
INSERT INTO bht_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“अगर असां बोलया, माणुऐ दिया तरफा ला, तां सारे लोकां सांझो पथर मारणे, क्योंकि सारे लोक सची जाणदे न की यूहन्ना सच्चा परमेश्वरे दा संदेश देणेबाला था।” ");
INSERT INTO bht_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","उना जबाब दिता, “असां नी जाणदे, की सै कुसदिया तरफा ला था।” ");
INSERT INTO bht_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","यीशुऐ उना ने बोलया, “तां मैं भी नी दसणा की मैं ऐ कम्म कुसदे हके ने करदा है।” ");
INSERT INTO bht_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","तालू यीशु लोंका जो इक कहाणी सुणाणा लग्गा, इकी माणुऐ अंगूरा दा बाग लगाया, कने किसाना जो उदा ठेका देईकरी कने मतयां रोजां तांई परदेस जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","फिरी जालू अंगूर पक्की गे, तां उनी अपणा इक नोकरे जो ठेकेदारे बाल अपणा अंगूरे दे बागे दा हिस्सा लोंणे तांई भेजया। पर ठेकेदारां उसयो पकड़या कने मारी कुट्टी करी बिना कुछ दितयो खाली हथ भेजी दिता। ");
INSERT INTO bht_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","फिरी मालिके इक होर नोकर भेजया, कने उना उसयो भी मारी कुट्टी करी कने बेजती करिके खाली हथे भेजी दिता। ");
INSERT INTO bht_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","फिरी मालिके तिजे नोकरे जो भेजया, कने उना उसयो भी मारी कुट्टी करी बाहर कडी दिता। ");
INSERT INTO bht_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“तालू अंगूरा दे बागे दे मालिके बोलया, मैं क्या करे? मैं अपणे प्यारे पुत्रे जो उना बाल भेजदा है शायद सै मेरे पुत्रे दा आदर करन।” ");
INSERT INTO bht_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","जालू ठेकेदारां उसयो दिखया तां अपु चे बिचार करणा लग्गे, ऐ तां बारिस है; ओआ, असां इसयो मारी दिन्दे, ताकि सब कुछ साड़ा होई जा। ");
INSERT INTO bht_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","कने उना उसयो अंगूरा दे बागे ला बार कडी करी मारी दिता: तां दाखे दे बागे दे मालिके उना सोगी क्या करणा? ");
INSERT INTO bht_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“उनी आई करी उना ठेकेदारां दा नाश करणा, कने अंगूरा दे बागे जो कुसकी होरसी जो देई देणा। ऐ सुणीकरी लोकां बोलया, हे परमेश्वर इयां मत करदा।” ");
INSERT INTO bht_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","उनी उना पासे दिखीकरी बोलया, फिरी पबित्र शास्त्र च ऐ क्या लिखया है: जिसी पथरे जो राजमिस्त्रियां बेकार बोलया था, सेई कुणे दा सिरा बणया। ");
INSERT INTO bht_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“जड़ा कोई उस पथरे पर पोंगा उदे टोटे-टोटे होई जांणे, कने जिदे पर सै पोंगा, उनी सै पिई देणा।” ");
INSERT INTO bht_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","तालू ही बड्डे याजक कने यहूदी व्यवस्था जो सिखाणे बाले यीशुऐ जो पकड़ना चांदे थे, क्योंकि सै समझी गे, की उनी सांझो पर ऐ कहाणी बोलियो है, पर सै लोकां ला डरदे थे। ");
INSERT INTO bht_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","सै यीशुऐ जो फसाणे दिया ताका च थे। कने उना गुप्‍तचर भेजे, की सै धर्मी दा भेस बणाई करी उदी कोई गल्ल पकड़न, ताकि उसयो राज्यपाल कने अधिकारियां दे हथे देई देंन। ");
INSERT INTO bht_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","उना उसला ऐ पुछया, गुरू जी, असां जाणदे न की, तुसां हमेशा सच्च बोलदे न कने सिखांदा भी है, कने कुसदा भी पक्षपात नी करदा है; कने परमेश्वरे दा रस्ता सच्चाईया ने दसदा है। ");
INSERT INTO bht_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","“इस तांई सांझो दस की महाराजा जो कर देणा ठीक है की नी?” ");
INSERT INTO bht_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","उनी उना दी चलाकी दिखीकरी उना ने बोलया, ");
INSERT INTO bht_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","इक दीनार मिंजो दस्सा। इस पर कुसदी छाप कने ना है? उना बोलया, “महाराजा दा।” ");
INSERT INTO bht_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","यीशुऐ उना ने बोलया, “तां जड़ा महाराजा दा है, उसयो महाराजा जो दिया कने जड़ा परमेश्वरे दा है उसयो परमेश्वरे जो दिया।” ");
INSERT INTO bht_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","सै लोका सामणे उसा गल्ला जो पकड़ी नी सके, कने उदे जबाबे ने हेरान होईकरी चुप होई गे। ");
INSERT INTO bht_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","फिरी सदूकी जड़े बोलदे न, की मरयां दा जिन्दा होणा हेई नी, उना चे थोड़यां यीशुऐ बाल आई करी पुछया। ");
INSERT INTO bht_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","गुरू जी, मूसा दिया व्यवस्था च साड़े तांई ऐ लिखया है, “अगर कुसकी दा भाई अपणिया घरे वालिया दे होंदे बिना बच्चे दे मरी जा, तां उदा भाई उदिया घरे वालिया जो ब्याई ले, कने उदे तांई बंश पैदा करे।” ");
INSERT INTO bht_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","इक घरे च सत भाई थे, पेहला भाई बियाह करिके बिना ओलादी दे मरी गिया। ");
INSERT INTO bht_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","तां दुऐ भाईऐ उसा ने ही बियाह करी लिया कने से भी बिना ओलादी मरी गिया, ");
INSERT INTO bht_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","कने इयां ही तिजे भाई ने होया कने सतां भाईयां उसा ने बियाह किता कने सतो भाई बिना ओलादी मरी गे। ");
INSERT INTO bht_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","बादे च सै जनानी भी मरी गेई। ");
INSERT INTO bht_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","हुण, सांझो दस सतां भाईयां उसा जनानिया ने बियाह कितया था, जालू सै मरणे दे बाद फिरी जिन्दे होंगे, तां सै जनानी कुदी घरे बाली होणी? ");
INSERT INTO bht_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","यीशुऐ उना ने बोलया, इसी युगे दे लोकां च तां बियाह होंदे न। ");
INSERT INTO bht_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","पर जिना लोकां इस लाइक होणा है, की उसी युगे च कने मरयां चे जिन्दे होणा है, उना च बियाह नी होणे न। ");
INSERT INTO bht_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","फिरी उना मरणा भी नी; क्योंकि सै स्वर्गदूते सांई होणे, कने मरयां चे जिन्दा होणे ने सै परमेश्वरे दी ओलाद होणे न। ");
INSERT INTO bht_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","पर इसा गल्ला जो की मरयो होऐ भी जिन्दा होई जांदे न, मूसे झाड़ी बालिया कथा च सिखाया है, इस तांई “सै परमेश्वर जो अब्राहम दा परमेश्वर, कने इसहाक दा परमेश्वर, कने याकूब दा परमेश्वर बोलदा है।” ");
INSERT INTO bht_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","“परमेश्वर तां मुर्दयां दा नी पर जिंदया दा परमेश्वर है: क्योंकि उदे तांई सारे जिंदे न।” ");
INSERT INTO bht_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","तालू ऐ सुणिकरी कितणयां ही व्यवस्था जो सिखाणे बालयां बोलया, “गुरू जी, तू ठीक बोलया है।” ");
INSERT INTO bht_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","कने उना जो होर कुछ पूछणे दी हिम्मत नी होई। ");
INSERT INTO bht_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","फिरी यीशुऐ उना ला पुछया, मसीह जो राजा दाऊदे दा बंशज कियां बोलदे न? ");
INSERT INTO bht_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","राजा दाऊदे अपु भजन संहिता दिया कताबां च बोलया है: “प्रभुऐ मेरे प्रभु ने बोलया, ");
INSERT INTO bht_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","तू मेरे सिंहासने दे सजे पासे बो, जालू दीकर मैं तेरे बैरियां जो तेरे पैरां हेठ करी दें।” ");
INSERT INTO bht_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“राजा दाऊद तां उसयो प्रभु बोलदा है तां सै फिरी उदा बंशज कियां होया?” ");
INSERT INTO bht_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","जालू सारे लोक सुंणा दे थे, तां यीशुऐ अपणे चेलयाँ ने बोलया। ");
INSERT INTO bht_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“व्यवस्था जो सिखाणे बालयां ला साबधान रिया, जड़े लोकां जो दसणे तांई लम्बे कने मेंगे कपड़े पाणा पसंद करदे, कने उना जो बड़ा पसंद है की लोक उना जो बजारां च नमस्ते करन, कने यहूदी जंज घरां च कने खांदे बेले खास-खास आसना पर बोणा पंसद करदे न। ");
INSERT INTO bht_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","सै धोखे कने वेईमानिया ने विधवां दे घरां दी चिजां पर कब्जा करी लेंदे न। कने लोकां जो दसणे तांई बड़ी देरा दीकर प्राथना करदे न, परमेश्वरे ला इना जो बड़ी बुरी सजा मिलणी है।” ");
INSERT INTO bht_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","फिरी यीशुऐ मंदरे दे भंडारे दे सामणे बेईकरी अमीरां जो अपणा-अपणा दान पेटिया च पांदे दिखया। ");
INSERT INTO bht_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","इतणे च इक गरीब बिधवा आई करी दो तांबे दे सिक्के पाये, जिना दी कीमत बड़ी घट्ट थी। ");
INSERT INTO bht_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","तालू उनी बोलया, मैं तुसां ने सच्च बोलदा है, की इना गरीब बिधवा सबना ला बदीकरी इस भंडारे च पाया है। ");
INSERT INTO bht_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","क्योंकि सबना अपणे भंडारे चे थोड़ा दिया दिता, पर इना गरीब बिधवा इसा बाल जितना भी था सारा ही पाई दिता है। ");
INSERT INTO bht_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","जालू कुछ चेले मंदरे दे बारे च गल्लां करा दे थे, की सै कदे छेल पथरां ने कने चढ़ाईयां चिजां ने सवारया है, तां यीशुऐ बोलया, ");
INSERT INTO bht_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“सै दिन ओंणे न, जिना चिंजा दी तुसां बड़ी तारीफ़ करा दे न, इक दिन ओणा है इना भवना दे इक भी पथरे पर पथर नी रेणा है, जड़ा डाया नी जाणा है।” ");
INSERT INTO bht_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","चेलयां यीशुऐ ला पुछया, “गुरू जी, सांझो दस ऐ सब कुछ कालू होणा है? कने जालू ऐ सब कुछ पूरा होणेबाला होंगा तां उदा क्या निशान होणा है?” ");
INSERT INTO bht_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","यीशुऐ बोलया, ध्यान रख्यो की तुहांजो कोई धोखा न दे। मते सारे लोकां मेरे नाए ने दाबा करिके ओणा है। उना बोलणा है, मैं मसीहा हूँ; कने ऐ भी बोलणा की टेम नेड़े आई गिया है: तुसां उना पिच्छे मत चली जांदे। ");
INSERT INTO bht_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","जालू तुसां लड़ाईयां, कने दंगया दियां गल्लां सुणगे तां डरी मत जांदे; क्योंकि इना दा होणा जरूरी है, पर तालू संसारे दा खात्मा नी होणा है। ");
INSERT INTO bht_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","तालू यीशुऐ उना ने बोलया, क्योंकि जातियां ने जातियां ने कने राज्य ने राज्यां ने इक दुजे ने लड़ाईयां करणियां न। ");
INSERT INTO bht_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","कने हर कुथी हिलण होणे न कने अकाल पोणे, कने महामारियां पोंणिया न, कने अम्बरे च गल्लां कने बड्डे-बड्डे निशाण प्रगट होणे न। ");
INSERT INTO bht_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","पर इना सबना गल्लां ला पेहले उना लोकां तुहांजो कैदी बणाना कने यहूदी जंज घरे च देणा कने तुहांजो मार पोंणी, कने मेरिया बजा ने तुहांजो हाकिमा कने राजयां दे सामणे न्याय तांई पेश किते जाणे न, ");
INSERT INTO bht_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","पर ऐ तुहाड़े तांई गबाई देणे दा मोका बणी जाणा है। ");
INSERT INTO bht_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","इस तांई सब अपणे-अपणे मने च पेहले ही ठाणी लिया की असां जबाब देणे दी चिंता नी करणी है। ");
INSERT INTO bht_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","क्योंकि मैं तुहांजो ऐसे बोल कने दिमाग दिंगा, की तुहाड़े सारे बिरोधियां सामणा कने टाल्ली नी सकणा है। ");
INSERT INTO bht_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","कने तुहाड़े माता-पिता कने भाई कने रिश्तेदारां, कने दोस्तां भी तुहांजो पकड़ाणा है; ऐथू दीकर की तुहांजो चे कितणयां जो मरवाई देणा है। ");
INSERT INTO bht_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","कने मेरे नाऐ दिया बजा ला सबना लोकां तुहांजो ने बैर करणा है। ");
INSERT INTO bht_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","पर तुहाड़े सरे दा, इक बाल भी बांका नी होणा। ");
INSERT INTO bht_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","पर जड़ा जिंदगी दे अंत दीकर मिंजो पर भरोसा रखगा सै ही बचाया जाणा है। ");
INSERT INTO bht_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","जालू तुसां यरूशलेम जो सेना ने घिरया दिखन, तां समझी लिया की उदा बिनाश होणेबाला है। ");
INSERT INTO bht_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","यहूदिया प्रदेशे दे लोकां जो जान बचाणे तांई पहाड़ा जो नसणा पोणा। कने जड़े यरूशलेम दे अंदर होंन सै बाहर नसी जान; कने जड़े ग्रां च होंन सै उना च मत जांदे। ");
INSERT INTO bht_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","क्योंकि ऐ बदला लेणे दे ऐसे रोज होणे न, जिना च सारियां लिखियाँ होइयां गल्लां पुरियां होणियां न। ");
INSERT INTO bht_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ऐ उना जनानिया तांई बड़ा बुरा बकत होणा जड़ियां लैरथियां न, कने उना जनानियां तांई जड़ियां नियाणे जो दूध पियादियां न। क्योंकि देशे च बड़ा बडा क्लेश कने इना लोंका पर बड़ी मुसीबत होणी है। ");
INSERT INTO bht_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","उना जो तलबारां ने मारयां जाणा है, कने केई देशां दे लोक गुलाम बणाई करी लेई जाणे न, कने जालू दीकर बाकी जातियां दा बकत पूरा नी होंगा, तालू दीकर यरूशलेम बाकी जातियां दा गुलाम रेणा है। ");
INSERT INTO bht_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","कने सुरज कने चन्द्रमा कने तारयां च अनोखे निशाण मिलणे न, कने धरतिया पर, देशे-देशे दे लोकां जो परेशानी होणी है; क्योंकि उना उफणदे समुद्रे दियां लेहरां ने घबराई जाणा है। ");
INSERT INTO bht_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","कने डरे दिया बजा ने कने दुनिया च ओणे बालियां घटना दी राह दिखदे-दिखदे लोकां दीया जानी च जान नी रेंणी हे क्योंकि अम्बरे दियां शक्तियाँ हिलाईयां जाणियां न। ");
INSERT INTO bht_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","तालू उना मिजों माणुऐ दे पुत्रे जो सामर्थ्य कने बड़ी महिमा दे सोगी बदले पर ओंदे दिखणा है। ");
INSERT INTO bht_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“जालू ऐ गल्लां होणा लगन, तां सीधे होईकरी अपणे सिरे जो उपरे उठाणा; क्योंकि तुहाड़ा छुटकारा नेड़े होणा।” ");
INSERT INTO bht_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","यीशुऐ उना जो इक कहाणी सुणाई, अंजीरे कने सारे रुखां जो दिखा। ");
INSERT INTO bht_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","जियां ही उना दियां कुम्बलियां निकलदियां न, तां तुहांजो ऐ दिखीकरी पता लग्गी जांदा है, की गर्मियां ओंणे बालियां न। ");
INSERT INTO bht_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","इयां ही जालू तुसां ऐ गल्लां होंदे दिखन, तां समझी लिया की परमेश्वरे दा राज्य नेड़े है। ");
INSERT INTO bht_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“मैं तुसां ने सच्च बोलदा है, कि जालू दीकर ऐ सारियां गल्लां पुरियां नी होई जांदियां न, तालू दीकर इसा पीढ़िया दा अंत नी होणा है।” ");
INSERT INTO bht_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","“अम्बर कने धरती खत्म होई जाणे, पर मेरियां बोलियां गल्लां कदी नी टलनिया न, सै हमेशा रेंणियां न।” ");
INSERT INTO bht_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","इस तांई साबधान रिया, ऐसा ना हो की तुहाड़े मन नशे च संसारे दियां मोहमाया च कने इसा जिन्दगिया दिया चिंता च सुस्त होई जान, कने सै दिन तुहांजो पर फंदे सांई इकदम आई पोऐ। ");
INSERT INTO bht_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","क्योंकि उनी सारिया धरतिया पर रेंणेबालयां पर इयां ही आई पोंणा है। ");
INSERT INTO bht_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","“इस तांई जागदे रिया कने हर बेले प्राथना करदे रिया ताकि तुसां ओंणे बालियां परेशानियां ला बचणे कने मिजों माणुऐ दे पुत्रे दे सामणे खड़ोणे लाइक बणन।” ");
INSERT INTO bht_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","कने सै दिने मंदरे च उपदेश करदा था; कने राती जैतून रुखां दे पाहड़े पर जाई करी रेंदा था। ");
INSERT INTO bht_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","कने ब्यागा उसयो सुणने तांई मंदरे च उदे बाल ओंदे थे। ");
INSERT INTO bht_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","अखमीरी रोटिया दा त्योहारे जिसयो फसह बोलदे न, नेड़े ही था। ");
INSERT INTO bht_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","कने बड्डे याजक कने व्यवस्था जो सिखाणे बाले इसा गल्ला दिया तोपा च थे की, उसयो कियां मारन, पर सै लोकां ला डरदे थे। ");
INSERT INTO bht_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","कने शैतान यहूदा च बड़ी गिया, इसयो इस्करियोती भी बोलदे न कने सै बाहरां चेलयां चे इक था। ");
INSERT INTO bht_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","उनी जाई करी बड्डे याजकां कने सरदारां ने गलबात किती, की उसयो कियां उना दे हथे पकड़ा। ");
INSERT INTO bht_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","सै खुश होऐ, कने उसयो पेसे देंणे दा बचन दिता। ");
INSERT INTO bht_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","उनी मन्नी लिया, कने मोका तोपणा लग्गा, की बिना बुरा कितयो यीशुऐ उना दे हथे पकड़ाई दे। ");
INSERT INTO bht_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","तालू अखमीरी रोटिया दे त्योहारे दा दिन आया, जिदे च फसह दे मेमने दी बलि देणा जरूरी थी। ");
INSERT INTO bht_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","कने यीशुऐ पतरस कने यूहन्ना जो ऐ बोली करी भेजया, “जाई करी साड़े खाणे तांई फसह दा खाणा तैयार करा।” ");
INSERT INTO bht_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","उनी यीशुऐ पुछया, “तू कुथु चांदा है, की असां फसह दा खाणा तैयार करन?” ");
INSERT INTO bht_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","उनी अपणे दो चेलयां जो ऐ बोली करी भेजया, की यरूशलेमे शेहरे जो जा, कने ओथु तुहांजो इक माणु घड़े चुकी करी चलया मिलणा, उदे पिच्छे चली जानयो। ");
INSERT INTO bht_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","कने सै जिस घरे जो जांगा, उस घरे दे मालिके जो बोलयो: की गुरू जी ने पूछया है, की मेरा कने मेरे चेलयां दा फसह दा खाणा खाने बाला कमरा कुथु है? ");
INSERT INTO bht_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","“उनी तुहांजो इक उपरे आला सजया सजाया कने तैयार कितया बडा कमरा दसी देणा है, कने तुसां ओथु साड़े तांई तैयारी करा।” ");
INSERT INTO bht_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","उना जाई करी, जियां यीशुऐ उना ने बोलया था, सियुदा ही था, कने उना उसा जगा फसह दा खाणा तैयार किता। ");
INSERT INTO bht_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","जालू बकत होया, तां यीशु बारह प्रेरितां सोगी रोटी खाणां बैठा। ");
INSERT INTO bht_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","कने यीशुऐ उना ने बोलया, “की मिंजो बड़ी इच्छा थी, की दुख भोगणे कने मरणे ला पेहले फसह दे त्योहारे दा खाणा तुहाड़े सोगी खां। ");
INSERT INTO bht_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","क्योंकि मैं तुसां ने बोलदा है, की जालू दीकर सै परमेश्वरे दे राज्य च पूरा नी होंगा तालू दीकर मैं फसह दे त्योहारे दा खाणा दुबारा नी खांगा।” ");
INSERT INTO bht_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","तालू उनी अंगूर दे रस दा कटोरा लेईकरी परमेश्वरे दा धन्याबाद किता कने बोलया, “इसयो लिया कने अपु चे बंडी करी पी लिया। ");
INSERT INTO bht_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","क्योंकि मैं तुसां ने बोलदा है, की जालू दीकर परमेश्वरे दा राज्य नी ओंगा तालू दीकर मैं अंगूरा दा रस कदी नी पिंगा।” ");
INSERT INTO bht_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","फिरी उनी रोटी लेई, कने धन्याबाद करिके तोड़ी, कने उना जो ऐ बोली करी दिती, ऐ मेरा शरीर है, जड़ी तुहाड़े तांई दितया जांदा है: मिंजो याद करणे तांई ऐई करा-करा। ");
INSERT INTO bht_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","इयां ही उनी खाणां खाणे बाद कटोरा भी ऐ बोलदे दिता, ऐ अंगूर दे रसे दा कटोरा मेरे उस खूने च नोई बाचा है जड़ा तुहाड़े तांई भाया जाणा है। ");
INSERT INTO bht_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","पर दिखा, मिंजो पकड़वाणे बाले दा हथ मेरे सोगी मेरिया थालिया च है। ");
INSERT INTO bht_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","“क्योंकि मिंजो, माणुऐ दे पुत्रे दा जियां उदे तांई तय है तियां करदा है, पर हाय उस माणुऐ पर, जिसदिया बजा ने पकड़ाया जांदा है।” ");
INSERT INTO bht_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","तालू सै अपु चे बोलणा लग्गे की, “असां चे कुण है, जड़ा ऐ कम्म करगा?” ");
INSERT INTO bht_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","उना चे ऐ भी बेहस होई की, सांझो चे कुण बडा समझया जांदा है? ");
INSERT INTO bht_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","यीशुऐ उना ने बोलया, बाकी जातियां दे राजे उना पर प्रभुता करदे न; जड़े उना पर हक रखदे न, उना जो उपकारक बोलदे न। ");
INSERT INTO bht_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","पर तुसां ऐ दे मत बणदे; नितां जड़ा तुसां चे बडा है, सै छोटे दे बराबर कने जड़ा सबते बड्डा है सै सेबक दे बराबर बणे। ");
INSERT INTO bht_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","क्योंकि बडा कुण है; सै जड़ा रोटी खाणां बैठया या सै जड़ा सेबा करदा है? क्या सै नी जड़ा रोटिया खाणां बैठया है? पर मैं तुहाड़े बिच सेवके सांई है। ");
INSERT INTO bht_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","पर तुसां ही न, जड़े मेरियां परिक्षां च लगातार मेरे सोगी रे; ");
INSERT INTO bht_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","कने जियां मेरे पिता मिंजो तांई इक राज्य दितया है, तियां ही मैं भी तुहाड़े तांई राज्य दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ताकि तुसां मेरे राज्य च मेरिया मेजा पर खा पिया; कने सिंहसनां पर बेईकरी इस्राएले देशे दे बाहरां गोत्रों दे लोकां दा न्याय करा। ");
INSERT INTO bht_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“शमौन, हे शमौन, दिख, शैताने तुसां लोकां जो परखणे तांई परमेश्वर ला आज्ञा मंगी लियो है, कि भलाई जो बुराई ला बख करणा जियां किसान कणका ला भुऐ जो बख करदा है। ");
INSERT INTO bht_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","पर मैं तेरे तांई परमेश्वरे ला प्राथना किती है, की तेरा भरोसा मिजों ला नी जा: कने जालू तु पश्चाताप करें, तां अपणे भाईयां जो भी मिजों पर भरोसा करणे तांई मजबूत करें।” ");
INSERT INTO bht_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","पतरसे यीशुऐ बोलया, “प्रभु जी, मैं तेरे सोगी जेला जाणे कने मरणे जो भी तैयार है।” ");
INSERT INTO bht_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","पर यीशुऐ बोलया, “हे पतरस मैं तिजो ने बोलदा है, की अज मुर्गे तालू दीकर बांग नी देणी जालू दीकर तू तिन्न बरी मिंजो पछेणने ला मना करी बोंणा है।” ");
INSERT INTO bht_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","कने यीशुऐ उना ने बोलया, “जालू मैं तुहांजो बटुऐ, कने झोली, कने जुते बिना शुभसमाचार प्रचार करणे भेजया था, तां क्या तुहांजो कुसा भी चिजा दी कमी होई थी?” उना बोलया, “नी होई कुसा भी चिजा दी।” ");
INSERT INTO bht_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","उनी उना ने बोलया, “पर हुण लोक साड़े खिलाफ न हुण जिसदे बाल बटुआ है सै उसयो लेई ले, कने तियां ही झोली भी, कने जिसदे बाल तलबार नी है सै बाहरे दे कपड़े बेची करी खरीदी ले।” ");
INSERT INTO bht_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","क्योंकि मैं तुसां ने बोलदा है, की ऐ जड़ा पबित्र शास्त्र च लिखया है सै पूरा हो की, “सै अपराधियां सांई मनया गिया है, उदा पूरा होणा जरूरी है: क्योंकि मेरे बारे जड़ियां गल्लां लिखियां न सै पुरियां होंणे बालियां न।” ");
INSERT INTO bht_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","चेलयां बोलया, “प्रभु जी, दिख, ऐथू दो तलबारां न।” यीशुऐ उना ने बोलया, “बतेरियाँ न।” ");
INSERT INTO bht_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","तालू सै बाहर निकली करी रोजे सांई जैतून रुखां दे पाहड़े पर गिया, कने चेले उदे पिच्छे गे। ");
INSERT INTO bht_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","उसा जगा पर पुज्जी करी यीशुऐ उना ने बोलया, “प्राथना करा, की तुसां दी परख ना होऐ।” ");
INSERT INTO bht_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","फिरी यीशु थोड़ा अग्गे गिया, कने गोडे भार बेईकरी प्राथना करणा लग्गा, ");
INSERT INTO bht_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“पिता जी अगर तू चा तां इस कटोरे जो बखे ला हटाई ले, पर तमी मेरी नी पर तेरी इच्छा पुरी हो।” ");
INSERT INTO bht_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","तालू स्वर्गे दे इक स्वर्गदूते ओथु प्रगट होया जड़ा उसयो सामर्थ्य दिन्दा था। ");
INSERT INTO bht_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","कने सै बड़ा परेशान कने व्याकुल होईकरी कने दुखे ने प्राथना करणा लग्गा; कने उदा पसीना मना की खूने दियां बडियां-बडिया बूंदा सांई धरतिया पर पोआ था। ");
INSERT INTO bht_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","तालू सै प्राथना ला उठया कने अपणे चेलयां बखे आई करी उना जो उदासिया दे मारयो सुतया दिखया। ");
INSERT INTO bht_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","कने उना ने बोलया, “कजो सोआ दे न? उठा, प्राथना करा, की तुहाड़ी परख ना होऐ।” ");
INSERT INTO bht_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","जालू यीशु ऐ बोला दा ही था, की दिखा मते सारे लोक आऐ, यहूदा जड़ा बाहरां चेलयां चे इक था सै अग्गे-अग्गे ओआ दा था, सै यीशुऐ दे बखे आया, ताकि उदा चूमा लेई सके। ");
INSERT INTO bht_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","यीशुऐ उसयो बोलया, “हे यहूदा, क्या तू चूमा लेईकरी मिंजो, माणुऐ दे पुत्रे जो पकड़वा दा है?” ");
INSERT INTO bht_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","उदे साथियां जालू दिखया की क्या होणे वाला है, तां बोलया, “प्रभु जी, क्या असां तलबार चलान?” ");
INSERT INTO bht_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","कने चेलयां चे इकी महायाजके दे नोकरे पर तलबार चलाई करी उदा सजा कन उड़ाई दिता। ");
INSERT INTO bht_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","इस पर यीशुऐ बोलया, “हूंण बस करा।” कने उदा कन छुई करी उसयो ठीक किता। ");
INSERT INTO bht_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","तालू यीशुऐ बड्डे याजकां कने मंदरे दे रखबालयां दे अगुवां कने यहूदी अगुवां जो बोलया, तुसां क्या तलवारां कने डांगा लेईकरी मिंजो डाकुआं सांई पकड़ना आयो न। ");
INSERT INTO bht_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","“मैं जालू हर रोज मंदरे च बेईकरी उपदेश दिन्दा था, तालू तां तुसां मिंजो नी पकड़या; पर ऐ तुहाड़ा बकत है, कने नेहरे दा हक है।” ");
INSERT INTO bht_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","फिरी सै उसयो पकड़ी करी लेई चले, कने महायाजक दे घरे जो लेई आये कने पतरस दूरे-दूरे ला ही उना दे पिच्छे चलया था। ");
INSERT INTO bht_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","कने जालू सै अंगणे च अग्ग वाल्ली करी गिठे बैठे, तां पतरस भी उना दे बिच बेई गिया। ");
INSERT INTO bht_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","कने इक दासिया उसयो अग्गी दी लौई च बैठया दिखीकरी कने उदे पासे दिखीकरी बोलणा लग्गी, “ऐ भी तां यीशुऐ सोगी था।” ");
INSERT INTO bht_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","पर पतरसे ऐ बोली करी मना किता, की मैं इसयो नी जाणदा। ");
INSERT INTO bht_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","थोड़ी देरा बाद फिरी कुनकी होरनी उसयो दिखीकरी बोलया, “तु भी तां उना चे है।” पतरसे बोलया, “सै माणु मैं नी है।” ");
INSERT INTO bht_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","कोई इक घंटे बाद इक होर माणु बोलणा लग्गा, “पक्का ऐ भी उना सोगी ही था; क्योंकि ऐ भी गलीली है।” ");
INSERT INTO bht_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","पतरसे बोलया, “मिंजो नी पता की ऐ क्या बोला दा है?” पतरसे दे इयां बोलदे ही, मुर्गे झट बांग देई दिती। ");
INSERT INTO bht_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","तालू प्रभु यीशुऐ मुड़ी करी पतरसे पासे दिखया, कने पतरसे जो सै गल्ल याद आई जड़ी उनी बोलियो थी, “अज मुर्गे जो बांग देंणे ला पेहले, तू तिन्न बरी मिंजो मना करणा है।” ");
INSERT INTO bht_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","कने पतरस बाहर निकली करी बड़ा भरी रोणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","जिना माणुआं यीशुऐ जो पकड़या था, सै उदा मजाक उड़ाई करी उसयो कुटणा लग्गे; ");
INSERT INTO bht_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","कने उदियां हखी पर पट्टी बन्नी करी पुछया, “अगर तु परमेश्वरे दा संदेश देणेबाला है! तां सांझो दस कुनी तिजो मारया।” ");
INSERT INTO bht_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","कने उना होर भी बुरियां गल्लां उदे बारे च बोलियां। ");
INSERT INTO bht_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","जालू ब्याग होई तां यहूदी अगुवां कने बड्डे याजक कने व्यवस्था जो सिखाणे बाले गिठे होऐ, कने उसयो अपणिया महासभा च आंणी करी पुछया, ");
INSERT INTO bht_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","अगर तू मसीह है, तां सांझो ने बोली दे। यीशुऐ उना ने बोलया, “अगर मैं तुहांजो ने बोलें तां तुसां मनणा नी। ");
INSERT INTO bht_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","अगर मैं कोई सबाल पूछां, तां तुसां जबाब नी देणा। ");
INSERT INTO bht_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","पर हुणे ला मैं, माणुऐ दे पुत्रे सबते शक्तिशाली परमेश्वरे दे सजे पासे बेई रेणा।” ");
INSERT INTO bht_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","इस पर सारयां बोलया, “तां तु क्या परमेश्वरे दा पुत्र है?” यीशुऐ उना ने बोलया, “तुसां अपु ही बोलदे न, क्योंकि मैं है।” ");
INSERT INTO bht_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","तालू उना बोलया, “हुण सांझो गबाई दी क्या जरूरत है क्योंकि असां अपु ही इदे मुऐ ला सुणी लिया है।” ");
INSERT INTO bht_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","तालू सारी सभा उठी करी उसयो पिलातुस बाल लेई गेई। ");
INSERT INTO bht_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","कने सै ऐ बोली करी उस पर दोष लगाणा लग्गे, “असां इसयो साड़े लोकां जो बेहकांदे कने महाराजा जो कर देंणे ला मना करदे, कने अपणे आपे जो मसीह, कने राजा बोलदे सुणया है।” ");
INSERT INTO bht_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","पिलातुसे उसला पुछया, “क्या तू यहूदियां दा राजा है?” उनी उसयो जबाब दिता, “तू अपु ही बोला दा है।” ");
INSERT INTO bht_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","तालू पिलातुसे बड्डे याजकां कने लोकां ने बोलया, “मिंजो इस माणुऐ च कोई दोष नी मिलदा है।” ");
INSERT INTO bht_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","पर सै होर भी दबाब पाई करी जोरे ने बोलणा लग्गे, “यहूदिया प्रदेशे दे सारे लोकां च इदिया शिक्षा दिया बजा ने दंगे हो दे न, कने गलील प्रदेश च भी इयां ही किता कने हुण ऐथू आई गिया है।” ");
INSERT INTO bht_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ऐ सुणीकरी पिलातुसे पुछया, “क्या ऐ माणु गलील प्रदेश दा रेणे बाला है?” ");
INSERT INTO bht_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","कने ऐ जाणी करी की सै उस प्रदेश दा है जिथू राजा हेरोदेस राज करदा है, तां उसयो हेरोदेसे बाल भेजी दिता, क्योंकि उना दिना राजा हेरोदेस भी यरूशलेम च था। ");
INSERT INTO bht_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हेरोदेस यीशुऐ जो दिखीकरी बड़ा खुश होया, क्योंकि सै उसयो बड़े रोजां ला दिखणा चांदा था: उनी उदे बारे च सुणाया था, कने हेरोदेस यीशुऐ ला कुछ चमत्कार दिखणे दी आस रखदा था। ");
INSERT INTO bht_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","सै उसला मतियां गल्लां पुछदा रिया, पर उनी उना दा कोई भी जबाब नी दिता। ");
INSERT INTO bht_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","कने बड्डे याजक कने व्यवस्था जो सिखाणे बाले खड़ोई करी पुरे जोर शोर लाईकरी उस पर दोष लांदे रे। ");
INSERT INTO bht_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","तालू राजा हेरोदेसे अपणे सिपाईयां सोगी उदी बेजती करिके उदा मजाक उड़ाया, कने चटकिले कपड़े पेहनाइ करी उसयो पिलातुस बाल बापस भेजी दिता। ");
INSERT INTO bht_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","उस बकते दीकर पिलातुस कने हेरोदेस इकी दुऐ दे दुशमण थे, पर दोनो उसी रोजे मित्र बणी गे। ");
INSERT INTO bht_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पिलातुसे बड्डे याजकां कने सरदारां कने लोकां जो सदीकरी बोलया, ");
INSERT INTO bht_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","तुसां इस माणुऐ जो मेरे बाल लेई आये कने बोलया की दंगा कराणे तांई लोकां जो भटकांदा था। पर दिखा, मैं तुहाड़े सामणे इसदी जाँच किती, पर जिना गल्लां दा तुसां इदे पर दोष लगा दे न, मिंजो उना गल्लां दे बारे च उदे च कोई भी दोष नी मिल्ला है; ");
INSERT INTO bht_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","कने ना ही हेरोदेसे उस पर कोई दोष लाया, क्योंकि उनी इसयो साड़े बाल बापस भेजी दितया है क्योंकि इनी माणुऐ ऐसा कुछ नी कितया की इसयो मौत दी सजा मिल्ले। ");
INSERT INTO bht_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","“इस तांई मैं इसयो कोड़े मरवाई करी छडी देणा है।” ");
INSERT INTO bht_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","पिलातुस फसह दे त्योहारे दे बेले उना दे इकी केदिये जो छडी दिन्दा था। ");
INSERT INTO bht_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","तालू सारे मिली करी बोलणा लग्गे, इसयो मौत दी सजा दिया, कने साड़े तांई बरअब्बा जो छडी दे। ");
INSERT INTO bht_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","सै कुसकी दंगे दिया बजा ने जड़ा शेहरे च होया था, कने हत्या दिया बजा ने जेला च पाया था। ");
INSERT INTO bht_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पर पिलातुसे यीशुऐ जो छडणे दिया इच्छा ने लोंका जो फिरी समझाया। ");
INSERT INTO bht_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","पर सै जोरे-जोरे ने बोलणा लग्गे, “इसयो सूली पर चढ़ाई दिया! इसयो सूली पर चढ़ाई दिया!” ");
INSERT INTO bht_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","उनी तिजी बार फिरी बोलया, “कजो उनी क्या बुरा कितया है? पर मिंजो इदे च मौत दी सजा देंणे जोगी कोई गल्ल नी मिल्ला दी है, मैं इसयो मारी कुट्टी करी छडी देणा है।” ");
INSERT INTO bht_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","पर सै चिलाई-चिलाई करी पिच्छे ही पेई गे, की इसयो सूली पर चढ़ाई दिया, कने सै होर जोरे-जोरे ने बोलणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","पिलातुसे हुकम दिता, की इना दिया बिनतिया दे अनुसार करा। ");
INSERT INTO bht_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","कने उनी उस माणुऐ जो जड़ा दंगे कने हत्या दिया बजा ने जेला च था, जिसयो सै मंगदे थे, छडी दिता; कने यीशुऐ जो उना दिया इच्छा अनुसार उना जो देई दिता। ");
INSERT INTO bht_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","जालू सिपाई यीशुऐ जो लेई चलयो थे, तां उना शमौन नाऐ दे इक कुरेनी जो जड़ा ग्रांऐ ला ओआ दा था, उसयो पकड़ी करी उस पर सूली लदी दिती ताकि उसयो यीशुऐ दे पिच्छे-पिच्छे लेई चले। ");
INSERT INTO bht_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","कने लोंका दी बड़ी बडी भीड़ उना दे पिच्छे चली पेई, कने उना चे जनानिया भी मतियां थियां, जड़ियां उदे तांई छातिया पिटी करी रोआ दियां थियां। ");
INSERT INTO bht_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","यीशुऐ उना पासे मुड़ी करी बोलया, “हे यरूशलेम शेहरे दियां कुड़ियो, मेरे तांई मत रोआ; पर अपणे तांई कने अपणे बचयां तांई रोआ।” ");
INSERT INTO bht_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","क्योंकि दिखा, सै दिन दुख भरे दिन ओंणे न, जिना च लोकां बोलणा है, “धन्य न सै जनानियां जिना दे कदी बच्चे नी थे, कने जिना कदी बच्चे जम्मे नी, जिना ना कदी उना जो दूध पियाया।” ");
INSERT INTO bht_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","उस बेले, उना लोकां पहाड़ा ने बोलणा लगणा है, की सांझो पर पेई जा, कने पहाड़ियां ने की सांझो ढकी लिया। ");
INSERT INTO bht_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“क्योंकि अगर सै मिंजो इस तरीके ने मारदे न जड़ा हरे रुखे सांई है, तां जड़े लोक सुके रुखे सांई न उना ने क्या कुछ नी करणा।” ");
INSERT INTO bht_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","सै होर दो माणुआं जो यीशुऐ सोगी मारणे तांई लेई चले जिना बुरे कम्म कितयो थे। ");
INSERT INTO bht_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","जालू सै उसा जगा पर पुज्जे जिसा जो खोपड़ी बोलदे न, तां उना ओथु उसयो कने उना दो बुरे कम्म करणे बालयां जो भी इकी जो सजे पासे कने दुज्जे जो खबे पासे सूली पर लटकाया। ");
INSERT INTO bht_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","तालू यीशुऐ बोलया, “हे पिता, इना जो माफ कर, क्योंकि ऐ जाणदे नी न की ऐ क्या करा दे न?” कने उना पर्चियां पाई करी उदे कपड़े बंडी ले। ");
INSERT INTO bht_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","लोक खड़ोई करी दिखा दे थे, कने सरदार भी मजाक करिके बोलदे थे, इनी होरां जो बचाया, अगर ऐ परमेश्वरे दा मसीह है, कने उदा चुणयां होया है, तां अपणे आपे जो बचाई ले। ");
INSERT INTO bht_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","सिपाई भी बखे आई करी यीशुऐ जो पिणे तांई सिरका देईकरी उदा मजाक करिके बोलदे थे। ");
INSERT INTO bht_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“अगर तू यहूदियां दा राजा है, तां अपणे आपे जो बचा।” ");
INSERT INTO bht_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","कने उदे उपर इक दोष पत्र भी लगाया था: “ऐ यहूदियां दा राजा है।” ");
INSERT INTO bht_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","जड़े बुरे कम्म करणे बाले यीशुऐ सोगी लटकाये थे, उना चे इकी निंदा करिके बोलया, “क्या तू मसीह नी है? तां फिरी अपणे आपे जो कने सांझो बचा।” ");
INSERT INTO bht_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","इसा गल्लां पर दुज्जे उसयो डांटया, “क्या तू परमेश्वरे ला भी नी डरदा है?” तिजो भी तां से ही सजा मिलियो है, ");
INSERT INTO bht_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","“कने सांझो तां न्याय दे अनुसार सजा मिलियो है, क्योंकि सांझो तां अपणे कम्मा दा ठीक फल मिला दा है; पर इनी तां कोई गलत कम्म नी कितया है।” ");
INSERT INTO bht_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","तालू उनी बोलया, “यीशु जी, जालू तू अपणे राज्य च राजा होईकरी ओंगा, तां मिंजो याद रखयां।” ");
INSERT INTO bht_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","यीशुऐ उसला बोलया, “मैं तिजो ने सच्च बोलदा है की अज ही तू मेरे सोगी स्वर्गलोक च होणा है।” ");
INSERT INTO bht_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","कने लगभग दोपेहर ला लेईकरी तिन्न बजे दीकर सारे देशे च नेहेरा रिया, ");
INSERT INTO bht_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","कने सूरजे दी लोओ चली गेई, कने मंदरे दा मोटा परदा बिचे ला फटी करी दो टुकड़े होई गिया, ");
INSERT INTO bht_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","कने यीशुऐ जोरे ने बोलया, “पिता, मैं अपणी आत्मा तेरे हथां च दिन्दा हे।” ऐ बोली करी अपणे प्राण छडी दिते। ");
INSERT INTO bht_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","सुबेदारे जड़ा कुछ होया था दिखीकरी परमेश्वरे दी बड़ाई किती, कने बोलया, पका ऐ कोई धर्मी माणु था। ");
INSERT INTO bht_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","भीड़ जड़ी ऐ दिखणे तांई गिठी होईयो थी, इसा घटना जो दिखीकरी छातियां पिटदे होए अपणे घरां जो बापस चली गेई। ");
INSERT INTO bht_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","कने यीशुऐ दे सारे जाणने पछेणने बाले मित्र, कने जड़ियां जनानिया गलील प्रदेश ला उदे सोगी आईयां थियां, दूर खड़ोई करी जड़ा कुछ होया था सारा कुछ दिखा दियां थियां। ");
INSERT INTO bht_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","कने ओथु यूसुफ नाऐ दा इक माणु था सै महासभा दा सदस्य था कने सज्जन कने धर्मी था। ");
INSERT INTO bht_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","कने सै यहूदी अगुवां दे बिचारां कने उना दे कम्मा ला खुश नी था; कने सै यहूदियां दे शेहर अरिमतिया शेहरे दा रेहणे बाला कने परमेश्वरे दे राज्य दी नियाल्ल रखणे बाला था। ");
INSERT INTO bht_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","उनी पिलातुस दे बाल जाई करी यीशुऐ दी लाश मंगी, ");
INSERT INTO bht_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","कने लाशा जो सूली ला उतारी करी मलमले दिया चादरा च लपेटया, कने उसयो इक कबरा च रखया, जड़ी पथरे च खंणियो थी; कने उसा च कदी भी कोई नी रखया था। ");
INSERT INTO bht_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","सै रोज शुक्रवार था, जड़ा तैयारी वाला दिन था कने सब्ते दा रोज शुरू होणेबाला था। ");
INSERT INTO bht_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","कने उना जनानियां जड़ियां उदे सोगी गलील प्रदेशे ला आईयां थियां, पिच्छे-पिच्छे जाई करी कबर दिखी कने ऐ भी की उदी लाश कियां रखी है। ");
INSERT INTO bht_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","कने अपणे घरां जो बापस आई करी उना सुगंध बालियां चिजां कने इत्र यीशुऐ दिया लाशा पर मलणे तांई तैयार किता; कने सब्ते दे रोजे उना मूसा दिया व्यवस्था दे अनुसार अराम किता। ");
INSERT INTO bht_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","पर हब्ते दे पेहले रोजे सै बड़ी ब्यागा ही उना सुगंधित चिजां जो जड़ियां उना तैयार कितियां थियां, लेईकरी कबरां पर आईयां। ");
INSERT INTO bht_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","कने उना दिखया की कबरा दे दरबाजे ला पथर पेहले ला ही हटया होया है, ");
INSERT INTO bht_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","कने सै अंदर गियां कने दिखया पर यीशुऐ दी लाश ओथु नी थी। ");
INSERT INTO bht_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","जालू सै इसा गल्ला ने हेरान थियां तां दिखा, दो माणु चिट्टे चमकीले कपड़े पायो उना बखे खड़ोतयो थे। ");
INSERT INTO bht_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","जालू सै डरी गियां, कने उना मु धरतिया पासे हेठ करी दिते; तां उना स्वर्गदूतां जनानिया ने बोलया, “तुसां जिन्दया जो मरयां चे कजो तोपदे न?” ");
INSERT INTO bht_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","“सै ऐथू नी है, पर जिन्दा होई गिया है। याद कर उनी गलील प्रदेशे च रेंदे बेले तुसां ने बोलया था, ");
INSERT INTO bht_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","की जरूरी हे, की मैं, माणुऐ दा पुत्र पापियां दे हथे पकड़या जा, कने सूली पर चड़ाया जाऐ, कने तिजे दिने मरयां चे जिन्दा होई जाऐ।” ");
INSERT INTO bht_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","तालू यीशुऐ दियां गल्लां उना जो याद आईयां। ");
INSERT INTO bht_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","कने कबरा ला बापस आई करी उना गयारां चेलयां जो, कने बाकियां सबना जो, ऐ सारियां गल्लां सुणाई दीतियां। ");
INSERT INTO bht_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","जिना प्रेरितां ऐ गल्लां बोलियां, सै मरियम मगदलीनी कने योअन्ना कने याकूबे दी मां मरियम कने उना सोगी दियां सारियां जनानिया भी थियां। ");
INSERT INTO bht_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","पर उना दियां गल्लां उना जो कहाणियां सांई लगियां, कने चेलयां उना दा भरोसा नी किता। ");
INSERT INTO bht_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","तालू पतरस उठी करी दोड़ी करी यीशुऐ दिया कबरा पर गिया, कने निठे होईकरी अंदर दिखया ओथु उनी सिर्फ बस कपड़े पियो दिखे, कने जड़ा होया उसला हेरान होईकरी बापस घरे चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","उसी रोजे यीशु दे दो चेले इम्माऊस नाऐ दे इक ग्रांऐ जो चलयो थे, जड़ा यरूशलेम शेहरे ला कोई गयारा किलो मीटर दूर था। ");
INSERT INTO bht_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","कने सै इना सारियां गल्लां पर अपु चे गल्ल बात करा दे थे, जड़ियां होईयां थियां। ");
INSERT INTO bht_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","कने सै जालू अपु चे गल्ल बात कने पूछताछ करा दे थे, तां यीशु अपु आई करी उना सोगी चलणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","पर परमेश्वरे उना जो यीशुऐ जो पछेणने ला रोकी रखया था, ताकि सै उसयो पछेणी नी सकन। ");
INSERT INTO bht_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","तालू यीशुऐ उना ने पुछया, “ऐ क्या गल्लां न, जड़ियां तुसां चलदे-चलदे अपु चे करा दे न?” सै रुकी गे कने उना दे मु बड़े उदास लग्गा दे थे। ");
INSERT INTO bht_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ऐ सुणीकरी, उना चे क्लियुपास नाऐ दे इकी माणुऐ बोलया, “शायद तू यरूशलेम च किल्ला ही परदेसी है; की जिसयो पता नी है की, पिछले इना रोजां च ऐथू क्या-क्या होया है?” ");
INSERT INTO bht_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","यीशु उना ला पुछया, “क्या-क्या होया है?” उना उसला बोलया, नासरत ग्रां दे यीशु दे बारे च जड़ा असल च परमेश्वरे कने सारे लोंका दे बखे कम्म कने बचन च सामर्थी परमेश्वरे दा संदेश देणेबाला था। ");
INSERT INTO bht_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","बड्डे याजकां कने साड़े सरदारां उसयो पकड़ाई दिता, की उसयो मारणे दा हुकम दिता; कने उसयो सूली पर चढ़ाई दिता। ");
INSERT INTO bht_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","पर सांझो आस थी, की इनी ही इस्राएले देश दे लोकां जो रोम देश ला छुटकारा देणा, कने इना सारियां गल्लां दे सिवा इसा गल्लां जो अज तिजा दिन होई गिया। ");
INSERT INTO bht_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","कने हुण केई जनानिया सांझो हेरानिया च पाई दिता है, जड़ियां अज ब्यागा कबरा पर गियां थियां। ");
INSERT INTO bht_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","कने जालू उना जो उदी लाश नी मिल्ली, तां ऐ बोलदियां आईयां, की असां जो स्वर्गदूतां दे दर्शण होऐ, उना बोलया की यीशु जिन्दा है। ");
INSERT INTO bht_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","“तालू साड़े साथियां चे केई कबरा पर गे कने जियां उना जनानिया बोलया था, तियां ही ओथु था; पर यीशुऐ जो उना नी दिखया।” ");
INSERT INTO bht_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","तालू यीशुऐ उना दोनो चेलयां ने बोलया, “हे मूर्खों, जड़ा कुछ परमेश्वरे दा संदेश देणेबालयां दिया कताबां च लिखया है तुसां लोकां जो इना सारियां गल्लां पर भरोसा करणा बड़ा कठिन लगदा है।” ");
INSERT INTO bht_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","“ऐ जरूरी था, की मसीह ऐ सारे दुख झेले कने फिरी करी अपणिया महिमा च प्रवेश करे।” ");
INSERT INTO bht_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","तालू यीशुऐ उना जो पुरे पबित्र शास्त्रां चे, उनी मूसा ला शुरू करिके सारे परमेश्वरे दा संदेश देणेबालयां जितणियां गल्लां उदे बारे च बोलियां दियां, सै उना जो समजाइयां। ");
INSERT INTO bht_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","इतणे चे सै उस ग्रांऐ बखे पुज्जे, जिथू सै चलयो थे, कने यीशुऐ दे व्यवहारे जो दिखीकरी ऐसा लग्गा था, की सै चेलयां ला अग्गे बदणा चांदा है। ");
INSERT INTO bht_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","पर उना ऐ बोली करी उसयो रोकया, “साड़े सोगी रे; क्योंकि संज होई चलियो है, कने दिन बड़ा डली गिया है।” तालू सै उना सोगी रेहणे तांई अंदर गिया। ");
INSERT INTO bht_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","जालू यीशु उना सोगी रोटी खाणां बैठा, तां उनी रोटी लेईकरी धन्यबाद किता, उसा जो तोड़ी करी उना जो देणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","तालू उना दियां हखी खुली गियां; कने उना उसयो पछेणी लिया, कने सै उना दी हखी अग्गे ला गायब होई गिया। ");
INSERT INTO bht_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","उना अपु चे बोलया, “जालू सै रस्ते च सांझो ने गल्लां करा दा था, कने सांझो पबित्र शास्त्रां दा मतलब समझा दा था, तां क्या साड़े मना च उतेजना नी जागी?” ");
INSERT INTO bht_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","सै उसी बेले उठी करी यरूशलेम शेहरे जो बापस चली गे, कने उना गयारां चेलयां कने उदे साथियां जो गिठे दिखया। ");
INSERT INTO bht_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","जड़े गिठे होयो थे सै ऐ बोला दे थे, “प्रभु सची जिन्दा होई गिया है, कने शमौने जो मिलया है।” ");
INSERT INTO bht_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","तालू उना रस्ते दियां गल्लां उना जो दसियां कने ऐ भी बोलया की जालू सै रोटी तोड़ा दा था तां उना उसयो पछेणी लिया की सै यीशु है। ");
INSERT INTO bht_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","सै ऐ गल्लां करा दे ही थे, की यीशु अपु ही उना बिच प्रकट हुआ; कने उना ने बोलया, “तुहांजो शांति मिल्ले।” ");
INSERT INTO bht_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","पर सै घबराई गे, कने डरी गे, कने सोचणा लग्गे की असां भूते जो दिखा दे न। ");
INSERT INTO bht_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","यीशुऐ उना ने बोलया, कजो घबरा दे न? कने तुहाड़े मने च कजो शक होंदा है? ");
INSERT INTO bht_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","“मेरे हथ कने पैरां जो दिखा, की मैं सै ही है, मिंजो छुई करी दिखा; क्योंकि भुत दी हड्डी कने मास नी होंदा है जियां मिंजो च दिखदे न।” ");
INSERT INTO bht_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ऐ बोली करी उनी उना जो अपणे हथ पैर दस्से। ");
INSERT INTO bht_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","जालू खुशिया दे मारे उना जो भरोसा नी होया की यीशु जिन्दा है, कने हेरान होआ दे थे, तां यीशुऐ उना ला पुछया, “क्या ऐथू तुहाड़े बाल कुछ खाणे जो है?” ");
INSERT INTO bht_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","उना उसयो भुनियो मछिया दा टुकड़ा दिता। ");
INSERT INTO bht_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","यीशुऐ सै मछिया दा टुकड़ा लेईकरी उना दे सामणे खादा। ");
INSERT INTO bht_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","फिरी यीशुऐ उना ने बोलया, “ऐ मेरियां सै गल्लां न, जड़ियां मैं तुहाड़े सोगी रेईकरी तुहांजो ने बोलियां थियां, की जरूरी हे, की जितणियां गल्लां मूसा दिया व्यवस्था कने परमेश्वरे दा संदेश देणेबालयां कने भजना दियां कताबां च मेरे बारे च लिखिंयां न, सै सारियां सच्च साबित होन।” ");
INSERT INTO bht_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","तालू यीशुऐ उना जो पबित्र शास्त्र समझणे तांई मदद किती। ");
INSERT INTO bht_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","कने उना ने बोलया, की पबित्र शास्त्रां च ऐसा लिखया है की मसीह जो दुख झेलणे न, कने तिजे दिने मरयां चे जिन्दा होई जाणा है, ");
INSERT INTO bht_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","कने यरूशलेम शेहरे ला लेईकरी सारियां जातियां दे पापां दी माफी तांई शुभसमाचार दा प्रचार उदे नाऐ ने होणा है। ");
INSERT INTO bht_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“तुसां इना सारियां गल्लां दे गबाह न। ");
INSERT INTO bht_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","कने मैं अपु तुहांजो पर पबित्र आत्मा जो भेजणा है, जिसदा बायदा मेरे पिता कितया है। तालू दीकर शेहरे च इतंजार करणा होणा जालू दीकर तुहांजो स्वर्गे ला सामर्थ्य नी मिलदी।” ");
INSERT INTO bht_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","तालू सै उना जो बैतनिय्याह ग्रांऐ दीकर शेहर ला बाहर लेई गिया, कने उना जो हथ चुकी करी आशीष दिती; ");
INSERT INTO bht_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","कने उना आशीष दिन्दे ही उना ला लग होई गिया कने स्वर्गे जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","कने सै उसयो दण्डवत करिके बड़िया खुशिया ने यरूशलेम शेहरे जो बापस चली गे। ");
INSERT INTO bht_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","कने सै लगातार मंदरे च जाई करी परमेश्वरे दी स्तुति करदे थे।");
INSERT INTO bht_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","इस सारे संसारे दे बणने ला पेहले बचन था, कने बचन परमेश्वरे सोगी था कने सै बचन परमेश्वर था। ");
INSERT INTO bht_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","बचन इस सारे संसारे दे बणने ला पेहले ला ही परमेश्वरे सोगी था। ");
INSERT INTO bht_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","परमेश्वरे सारा कुछ उसी बचन ने ही बणाया है कने जड़ा कुछ भी बणाया है इदे चे कोई भी चीज बचन बिना नी बणियो है। ");
INSERT INTO bht_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","साड़ी शारीरिक कने आत्मिक जिन्दगी उना च ही थी, कने सै जिन्दगी सारे लोकां जो लौ दिन्दी जोत थी। ");
INSERT INTO bht_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","कने लौ नेहरे च चमकदी है; कने नेहरा उसा लौइ जो बुझाई नी सकया। ");
INSERT INTO bht_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","परमेश्वरे यूहन्ना नाऐ दे इक माणुऐ जो भेजया। ");
INSERT INTO bht_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","सै लौइ दे बारे च दसणे तांई आया था ताकि सारे लोक उदे जरिये उसा जोती पर भरोसा करन। ");
INSERT INTO bht_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","यूहन्ना अपु तां सै लौ नी था, पर सै उसा लौ दी गबाई देणा आया था। ");
INSERT INTO bht_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","“सै जड़ी सच्ची लौ है” जड़ी हर इक माणुऐ जो लौ करदी है, सै संसार च ओंणे बाली थी। ");
INSERT INTO bht_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","सै संसार च था, कने संसार उदे ने पैदा होया है, कने संसारे दे लोकां उसयो नी पछेणया। ");
INSERT INTO bht_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","सै अपणे लोकां च आया पर उसयो उदे अपणे लोकां नी अपनाया। ");
INSERT INTO bht_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","पर जितणया उसयो अपनाया, उनी उना जो परमेश्वरे दी ओलाद होंणे दा हक दिता, मतलब की सै जड़े उस पर भरोसा रखदे न: ");
INSERT INTO bht_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","सै ना तां माता-पिता दी इच्छा ला, कने ना तां माणुऐ दिया इच्छा ने, ना शरीरे दिया इच्छा ने, ना इक माणुऐ दिया ओलाद दी इच्छा ने, पर परमेश्वरे ला पैदा होया है। ");
INSERT INTO bht_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","कने बचन इक माणु बणया कने असां लोकां बिच रिया, कने असां उदी ऐसी महिमा दिखी, जदेई पिता दे इकलोते दी महिमा। जो पिता परमेश्वरे ला सचाइया कने अनुग्रह ने भरपूर होईकरी आया। ");
INSERT INTO bht_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","यूहन्ना उदे बारे च गबाई दिती, कने पुकारी करी बोलया, की ऐ सेई है, जिदे बारे च मैं बोलया था, की उनी मेरे बाद ओणा है, सै मिंजो ला भी बदीकरी है, क्योंकि सै मिंजो ला पेहले इस संसारे च मोजूद था। ");
INSERT INTO bht_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","क्योंकि उदी परीपूर्णता ने सांझो सारयां जो मिलया है मतलब अनुग्रह पर अनुग्रह। ");
INSERT INTO bht_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","व्यवस्था तां मूसा ने दितियो है, पर परमेश्वरे यीशु मसीह दे जरिये अनुग्रह कने सचाई दस्सी। ");
INSERT INTO bht_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","परमेश्वरे जो कुनी भी कदी नी दिखया है, सिर्फ उदे इकलोते पुत्रे जड़ा असल च परमेश्वर है, कने पिता परमेश्वर दे सबते नेड़े है, उनी सांझो दसया है, की परमेश्वर कदिया है। ");
INSERT INTO bht_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यूहन्ना दी गबाई ऐ है, की जालू यहूदी अगुवां यरूशलेम शेहरे ला याजकां कने लेवियां जो उसला ऐ पुछणे तांई भेजया, “तू कुण है?” ");
INSERT INTO bht_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","यूहन्ना उना जो साफ-साफ बोलया, “मैं मसीह नी है।” ");
INSERT INTO bht_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","तालू उना उसला पुछया, “तां फिरी कुण है? क्या तू परमेश्वरे दा संदेश देणेबाला एलिय्याह है?” उनी बोलया मैं नी है। तां क्या तू सै परमेश्वरे दा संदेश देणेबाला है जिसदा पिता परमेश्वरे बायदा कितया था? उनी जबाब दिता की, “नी।” ");
INSERT INTO bht_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","तालू उना यूहन्ना ला पुछया, “तां फिरी है कुण तू। ताकि असां अपणे भेजणे बालयां जो जबाब देई सकन। तू अपणे बारे च क्या बोलदा है?” ");
INSERT INTO bht_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","उनी बोलया, “जियां यशायाह परमेश्वरे दा संदेश देणेबाला बोलया है, की मैं सुनसान जगा च इक हक पांणे बाले दी अबाज है की तुसां प्रभुऐ दा रस्ता सीधा करा।” ");
INSERT INTO bht_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ऐ लोक फरीसियां दे पासे ला भेजयो थे। ");
INSERT INTO bht_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","उना उसला ऐ सबाल पुछया, की अगर तू मसीह नी है, कने ना एलिय्याह है, कने ना ही सै परमेश्वरे दा संदेश देणेबाला है जड़ा ओणे बाला था, तां फिरी तू बपतिस्मा कजो दिन्दा है? ");
INSERT INTO bht_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","यूहन्ना उना जो जबाब दिता, की मैं तां पांणिऐ ने बपतिस्मा दिन्दा है, पर तुहाड़े बिच इक माणु खड़ोतया है, जिसयो तुसां नी जाणदे न। ");
INSERT INTO bht_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","मतलब की मेरे बाद ओणे बाला है, मैं तां उदे जुतयां दे तस्मे खोलणे दे काबील नी है। ");
INSERT INTO bht_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ऐ गल्लां यरदने खड्डा दे पार बैतनिय्याह शेहर च होईयां, जिथू यूहन्ना लोकां जो बपतिस्मा दिन्दा था। ");
INSERT INTO bht_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","यूहन्ने दुज्जे रोजे यीशुऐ जो अपणे पासे ओंदे दिखीकरी बोलया, “दिखा, ऐ परमेश्वरे दा मेमना है, जिनी संसारे दे पाप चुकी लेई जाणे न। ");
INSERT INTO bht_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ऐ सेई है जिदे बारे च मैं बोलया था, की इकी माणुऐ मेरे पिच्छे ओंणा है, सै मिंजो ला भी बडा है, क्योंकि सै मिंजो ला भी पेहले था। ");
INSERT INTO bht_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","कने मैं उसयो पछेणदा नी था की सै मसीह था, इस्राएल देश दे लोकां जो ऐ दसणे तांई की सै कुण है, तां मैं पांणिऐ ने बपतिस्मा दिन्दा आया।” ");
INSERT INTO bht_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","कने यूहन्ने ऐ गबाई दिती की, मैं पबित्र आत्मा जो कबुतरे सांई स्वर्गे ला उतरदे दिखया है, कने सै उस पर रुकी गेई। ");
INSERT INTO bht_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","पर मैं तां उसयो पछेणदा नी था सै मसीह था, पर जिनी मिंजो पांणिऐ ने बपतिस्मा देणा भेजया, उनी ही मिंजो ने बोलया, की जिस पर तू आत्मा जो उतरदे कने रुकदे दिखगा; सेई पबित्र आत्मा ने बपतिस्मा देणेबाला है। ");
INSERT INTO bht_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","कने मैं दिखया, कने गबाई दिती है की मैं तुसां ने सच्च-सच्च बोलदा की ऐई परमेश्वरे दा पुत्र है। ");
INSERT INTO bht_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","दुज्जे रोजे फिरी यूहन्ना कने उदे दो चेले खड़ोतयो थे। ");
INSERT INTO bht_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","कने यीशु चलया था, तां उनी उदे पासे नजर करिके बोलया, “दिखा, ऐ परमेश्वरे दा मेमना है।” ");
INSERT INTO bht_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","तालू सै दोनो चेले यूहन्ना दी गल्ल सुणीकरी यीशुऐ दे पिच्छे चली पे। ");
INSERT INTO bht_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","यीशुऐ पिच्छे मुड़ी करी उना जो पिच्छे ओंदे दिखीकरी उना ला पुछया, तुसां कुदिया तोपा च न? उना उसला बोलया, “गुरू जी, तू कुथु रेंदा है?” ");
INSERT INTO bht_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","यीशु मसीह उना ने बोलया, “चला दिखी लिया।” तालू उना आई करी उदे रेहणे दी जगा दिखी, कने उस रोजे सै सोगी रे; कने ऐ दोपहर दे लगबग चार बजयो थे। ");
INSERT INTO bht_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","उना दोना चे इक तां शमौन पतरस दा भाई अन्द्रियास था, जड़े यूहन्ना दियां गल्लां सुणीकरी उदे पिच्छे आया था। ");
INSERT INTO bht_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","उनी पेहले अपणे सगे भाई शमौन ने मिली करी उसला बोलया, की सांझो मसीह मिली गिया है। ");
INSERT INTO bht_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","अन्द्रियास शमौने जो यीशुऐ बाल लेई आया: यीशुऐ उस पासे नजर करिके बोलया, तू यूहन्ना दा पुत्र शमौन है, तिजो पतरस बोलणा है। ");
INSERT INTO bht_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","दुज्जे रोजे यीशुऐ गलील प्रदेशे जो जाणे दा फेसला किता, कने फिलिप्पुस ने मिली करी बोलया, “मेर चेले बणने तांई मेरे पिच्छे चली पो।” ");
INSERT INTO bht_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","फिलिप्पुस तां अन्द्रियास कने पतरसे दे शेहर बैतसैदा दा रेंणेबाला था। ");
INSERT INTO bht_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","फिलिप्पुसे नतनएल ने मिली करी बोलया, “सांझो सै माणु मिल्ली गिया है जिदे बारे च मूसा दिया व्यवस्था च कने परमेश्वरे दा संदेश देणेबालयां लिखया था। सै नासरत शेहरे ला यूसुफे दा पुत्र यीशु है।” ");
INSERT INTO bht_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नतनएले उसला बोलया, क्या कोई खरी चीज भी नासरत शेहर ला निकली सकदी है? फिलिप्पुसे उसला बोलया, “चली करी दिखी ले।” ");
INSERT INTO bht_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","यीशुऐ नतनएल जो अपणे बाल ओंदे दिखीकरी उदे बारे च बोलया, दिखा, ऐ सची इस्राएल दा भरोसे बाला बंशज है: इदे च कोई कपट नी है। ");
INSERT INTO bht_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नतनएले यीशुऐ जो बोलया, “तू मिंजो कियां जाणदा है?” यीशुऐ उसयो जबाब दिता, फिलिप्पुसे तिजो जालू सदया, उसला पेहले जालू तू अंजीरे दे रुखे थले था, तालू मैं तिजो दिखया था। ");
INSERT INTO bht_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","नतनएले उसयो जबाब दिता, “गुरू जी, तू परमेश्वरे दा पुत्र है; तू इस्राएल दा महाराजा है।” ");
INSERT INTO bht_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","यीशुऐ उसयो जबाब दिता, “मैं तां तिजो ने बोलया, की मैं तिजो अंजीरे दे रुखे थले दिखया, क्या तू तां भरोसा करा दा है? तू इसला भी बड्डे कम्म दिखणे न।” ");
INSERT INTO bht_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","फिरी यीशुऐ उसयो बोलया, “मैं तुसां ने सच्च-सच्च बोलदा है की तुसां स्वर्गे जो खुलया कने परमेश्वरे दे स्वर्गदूते जो उपर जांदे कने मिंजो, माणुऐ दे पुत्रे उपर उतरदे दिखणा।” ");
INSERT INTO bht_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","फिरी दो दिन बाद गलील प्रदेशे दे काना शेहर च कुसकी दा बियाह था, कने यीशुऐ दी माता भी ओथु थी। ");
INSERT INTO bht_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","यीशु कने उदे चेले भी उसी बियाह च सदया थे। ");
INSERT INTO bht_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","जालू दाखरस घटी गिया, तां यीशुऐ दिया माता उसला बोलया, “की इना बाल दाखरस नी रिया।” ");
INSERT INTO bht_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","यीशुऐ उसला बोलया, “माता जी तुसां मिंजो कजो दस्सा दे? अजे मेरा टेम नी आया है की लोक मिंजो मसीह से रुपे च पछेणन।” ");
INSERT INTO bht_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","पर उदिया माता सेवकां ने बोलया, “जड़ा कुछ सै तुहांजो बोलगा, सेई करनयो।” ");
INSERT INTO bht_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ओथु यहूदियां दे अपणे धार्मिक रिबाजां दे अनुसार हथ धोणे दा रिबाज था। उना हथ धोणे तांई पथरे दे छे घड़े रखयो थे। जिना च लगभग सौ-सवा-सौ लिटर पांणी ओंदा था। ");
INSERT INTO bht_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","यीशुऐ उना ने बोलया, “घड़यां च पांणी भरी दिया।” उना घड़यां जो उपरे दीकर भरी दिता। ");
INSERT INTO bht_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","तालू यीशुऐ उना जो बोलया, “हूंण पाणी निकाली करी धामा दे प्रधाने बाल लेई जा।” सेबकां तियां ही कितया जियां उना जो करणे तांई बोलया। ");
INSERT INTO bht_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","जालू धामा दे प्रधाने सै पांणी चखया, तां सै दाखरस बणी गिया था कने उसयो नी पता था की सै कुथु ला आया है; पर जिना सेवकां पांणी कडया था सै जाणदे थे, तां धामा दे प्रधाने लाड़े जो सदीकरी, उसयो बोलया। ");
INSERT INTO bht_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","हर इक माणु पेहले सबना ला खरा दाखरस दिन्दा है, कने जालू लोक उसयो पी करी रजी जांदे न, तालू घटिया बाला धाखरस दिन्दा है; पर तू सबना ला बदिया दाखरस हले दीकर रखया है। ");
INSERT INTO bht_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","यीशुऐ गलील प्रदेशे दे काना शेहर च अपणा ऐ पेहला चमत्कार दसी करी अपणी महिमा दसी कने उदे चेलयां उस पर भरोसा किता की सै ही मसीह है। ");
INSERT INTO bht_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","इदे बाद सै कने उदी माता, उदे भाई, उदे चेले, कफरनहूम शेहर जो गे कने ओथु थोड़े दिन रे। ");
INSERT INTO bht_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहूदियां दा फसह दा त्योहारे नेड़े था, कने यीशु यरूशलेम शेहर जो गिया। ");
INSERT INTO bht_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","कने उनी मंदरे च दांद, कने भेडां, कने कबुतरां जो बेचणे बालयां जो बैठया दिखया। ");
INSERT INTO bht_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","तालू उनी रसियां जो कोड़ा बणाई करी, सारियां भेडां कने दांदा जो मंदरे ला कडी दिता, कने साहुकारां दे पेसे खलारी दिते, कने पिढ़ां जो पुठा सुटी दिता, ");
INSERT INTO bht_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","कने कबुतरां बेचणे बालयां ने बोलया, “इना जो ऐथू ला लेई जा। मेरे पिता दे घरे जो व्यापारे दा घर मत बणा।” ");
INSERT INTO bht_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","तां उदे चेलयां जो याद आया की पबित्र शास्त्र च लिखया है, “तेरे घरे दा जनून मेरे अंदर अग्गी सांई बलदा है।” ");
INSERT INTO bht_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","इस पर यहूदी अगुवां उसला बोलया, “तू सांझो क्या चमत्कार दसी सकदा है की जिसने साबित हो की तिजो परमेश्वरे दिया तरफा ला हक है।” ");
INSERT INTO bht_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","यीशुऐ उना जो जबाब दिता, “इसी मंदरे जो तोड़ी दीया, कने मैं इसयो उना रोजां च दोबारा बणाई दिंगा।” ");
INSERT INTO bht_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","यहूदी अगुवां बोलया, “इस मंदरे जो बणाणे जो छयाली साल लगयो न, कने तू क्या इसयो उना रोजां च बणाई दिंगा?” ");
INSERT INTO bht_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","पर यीशु जिस मंदरे दे बारे च बोला था, सै उदा शरीर था। ");
INSERT INTO bht_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","जालू यीशु मरी करी जिंदा होया था, तालू उदे चेलयां जो याद आया था की उनी ऐ बोलया था; कने पबित्र शास्त्र कने सै बचन जड़ा यीशुऐ बोलया था, उस पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","जालू यीशु यरूशलेम शेहर च फसह दे त्योहारे च था, तां मतयां उना चमत्कारां जो जड़े सै दसदा था दिखीकरी उस पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","पर यीशुऐ भरोसा नी किता की उना उस पर भरोसा कितया है, ");
INSERT INTO bht_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","कने उसयो कुसदी भी जरूरत नी थी जड़ा उसयो लोकां दे बारे च दस्से क्योंकि सै जाणदा था की उना दे दिलां च कने उना दे क्या इरादे न? ");
INSERT INTO bht_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","फरीसियां चे नीकुदेमुस नाऐ दा इक माणु था, जड़ा यहूदियां दा धार्मिक अगुवा था, सै इक फरीसी था। ");
INSERT INTO bht_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","उनी राती यीशुऐ बाल आई करी उसयो बोलया, “गुरू जी, असां जाणदे न, की परमेश्वरे तुहांजो सांझो सिखाणे तांई भेजया है, क्योंकि कोई भी इना चमत्कार जो जड़े तू दसदा है, अगर परमेश्वर दा साथ ना हो तां नी दसी सकदा है।” ");
INSERT INTO bht_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","यीशुऐ उसयो जबाब दिता, “मैं तिजो ने सच्च-सच्च बोलदा है, अगर कोई नोऐ सिरे ला नी जम्मे तां सै परमेश्वरे दा राज्य नी दिखी सकदा है।” ");
INSERT INTO bht_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","नीकुदेमुसे उसला बोलया, “माणु जालू बुड्डा होई जांदा है तां सै कियां जन्म लेई सकदा है? क्या सै अपणिया माता दे पेटे च दुज्जी बरी जाई करी जन्म लेई सकदा है?” ");
INSERT INTO bht_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","यीशुऐ जबाब दिता, मैं तिजो ने सच्च-सच्च बोलदा है, जालू दीकर कोई माणु पांणिऐ कने पबित्र आत्मा ने नी पैदा होऐ तालू दीकर सै परमेश्वरे दे राज्य च प्रवेश नी करी सकदा है। ");
INSERT INTO bht_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","माणु अपणे बचयां जो जन्म दिन्दे न। फिरी भी सिर्फ परमेश्वरे दी आत्मा ही तुसां जो परमेश्वरे दी ओलाद दे रुपे च बदली सकदा है। ");
INSERT INTO bht_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","हेरान मत हो, की मैं तिजो ने बोलया, तिजो दोबारा ला पैदा होणा जरूरी है। ");
INSERT INTO bht_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","हवा जिस पासे चांहदी है उस पासे चलदी है, कने तू उदी अबाज सुणदा है, पर ऐ पता नी की सै कुथु ला ओंदी है कने कुस पासे चली जांदी है? जड़ा कोई पबित्र आत्मा ने जमया है सै ऐदिया ही है। ");
INSERT INTO bht_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","नीकुदेमुसे उसयो जबाब दिता, “क्या ऐ गल्लां होई सकदियां न?” ");
INSERT INTO bht_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ऐ सुणीकरी यीशुऐ उसयो जबाब दिता, तू इस्राएलियां दा इक महान गुरू है, तिजो तां असल च इना गल्लां जो समझणा चाईदा है? ");
INSERT INTO bht_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","मैं तिजो ने सच्च-सच्च बोलदा है की सांझो जड़ा पता है, सै बोलदे न, पर जिसयो असां दिखदे न उदी गबाई दिन्दे न, कने असां जड़ा बोलदे न उस पर तुसां भरोसा नी करदे न। ");
INSERT INTO bht_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","जालू मैं तुसां ने धरतिया पर होणे बालियां गल्लां बोलियां, तां तुसां भरोसा नी किता, अगर मैं तुसां जो दस्से की स्वर्गे च क्या होणा है, तां क्या तुसां भरोसा करगे? ");
INSERT INTO bht_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","कोई स्वर्गे पर नी गिया, “पर सिर्फ मैं, माणुऐ दा पुत्र स्वर्गे ला थल्ले आया है।” ");
INSERT INTO bht_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","कने जियां मूसे सुनसान जगा च पितल दे सप्पे जो उपर चढ़ाया, तियां ही जरूरी है की मैं, माणुऐ दे पुत्रे जो भी उपर चड़ाया जाऐ। ");
INSERT INTO bht_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ताकि जड़ा कोई मिंजो पर भरोसा करे उदे च उसयो हमेशा दी जिन्दगी मिल्ले। ");
INSERT INTO bht_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“क्योंकि परमेश्वरे संसारे दे लोकां ने ऐसा प्यार किता की उनी अपणा इकलोता पुत्र देई ता, ताकि जड़ा कोई उस पर भरोसा करे, उदा नाश ना होऐ, पर उसयो हमेशा दी जिन्दगी मिल्ले। ");
INSERT INTO bht_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","क्योंकि परमेश्वरे अपणे पुत्रे जो संसारे दे लोकां पर सजा देंणे तांई नी भेजया है, पर इस तांई भेजया की उदे जरिये संसारे दे लोकां दा उद्धार होऐ। ");
INSERT INTO bht_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","जड़ा परमेश्वरे दे पुत्रे पर भरोसा करदे न, उस पर सजा दा हुकम नी होंदा, पर जड़े परमेश्वरे दे पुत्रे पर भरोसा नी करदे न, सै दोषी न क्योंकि उनी परमेश्वरे दे इकलोते पुत्रे दे नाऐ पर भरोसा नी किता। ");
INSERT INTO bht_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","कने सजा दा हुकम देंणे दी बजा ऐ की लौ संसारे च आई है, कने लोकां नेहरे जो लौइ ला जादा प्यार किता क्योंकि उना दे कम्म बुरे थे। ");
INSERT INTO bht_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","क्योंकि जड़ा कोई बुराई करदा है, सै लौइ ने बैर रखदा है, कने लौइ च नी ओंदा है, इयां ना हो कि उदे कम्मा पर दोष लगन। ");
INSERT INTO bht_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","पर जड़ा सचाइया पर चलदा है सै लौइ च ओंदा है, ताकि उदे कम्म प्रगट होन जड़ा परमेश्वरे चांदा की सै करन।” ");
INSERT INTO bht_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","इदे बाद यीशु कने उदे चेले यहूदिया प्रदेश च आये; कने सै ओथु उना सोगी रेईकरी बपतिस्मा देणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","कने यूहन्ना भी ऐनान ग्रां च जड़ा सामरिया इलाके दे शालेम शेहर दे नेड़े है ओथु बपतिस्मा दिन्दा था। क्योंकि ओथु मता पांणी था, कने लोक आई करी बपतिस्मा लेंदे थे। ");
INSERT INTO bht_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","क्योंकि यूहन्ना तालू दीकर जेला च नी पाया था। ");
INSERT INTO bht_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ओथु यूहन्ना दे चेलयां दा कुसकी यहूदिये सोगी रिबाजा दे हिसावे ने शुद्धी दे बारे च बेहस होई। ");
INSERT INTO bht_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","कने यूहन्ना दे चेलयां उस बाल आई करी उसला बोलया, “गुरू जी, जड़ा माणु यरदन खड्डा दे पारले पासे तेरे सोगी था, जिसदे बारे च तुसां गबाही दिती थी; दिख, सै बपतिस्मा दिन्दा है, कने सब उस बाल ओंदे न।” ");
INSERT INTO bht_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","यूहन्ने जबाब दिता, जालू दीकर माणुऐ जो स्वर्गे ला ना दितया जाऐ, उसयो तालू दीकर कुछ नी मिल्ली सकदा। ");
INSERT INTO bht_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","तुसां अपु मेरे गबाह न की क्या बोलया था, की मैं मसीह नी है, पर उदे पहले भेजया गिया है। ");
INSERT INTO bht_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","लाड़ा लाड़िये ने बियाह करी लेंदा है, पर लाड़े दा मित्र सोगी खड़ोई करी उदी सुणदा है, लाड़े दियां गल्लां ने बड़ा खुश होंदा है; तियां ही मेरा दिल खुश होई गिया है। ");
INSERT INTO bht_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","जरूरी है सै होर जादा खास होई जा कने मैं घट खास होई जां। ");
INSERT INTO bht_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“जड़ा स्वर्गे ला ओंदा है सै सबना ला बडा है, जड़ा धरतिया ला ओंदा है सै धरतिया दा है; कने धरती दियां गल्लां करदा है: जड़ा स्वर्गे ला ओंदा है, सै सबना ला उपर है। ");
INSERT INTO bht_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","जड़ा कुछ उनी दिखया, कने सुणाया है, उदी गबाई दिन्दा है; पर बड़े घट लोक उदे संदेश जो मंदे न। ");
INSERT INTO bht_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","पर जिना लोकां उदा संदेश मन्नी लिया उनी इसा गल्ला पर प्रमाण देई दिता की परमेश्वर सच्चा है। ");
INSERT INTO bht_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","क्योंकि जिसयो परमेश्वरे भेजया है सै परमेश्वरे दे बचना दा प्रचार करदे न क्योंकि ऐ सेई है जिसयो परमेश्वरे बिना नापी-तोली करी पबित्र आत्मा दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","पिता परमेश्वर पुत्रे ने प्यार करदा है, कने उनी सारियां चिंजा उदे हथां च देई दितियां। ");
INSERT INTO bht_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","जड़ा परमेश्वरे दे पुत्रे पर भरोसा रखदा है, हमेशा दी जिन्दगी उदी है; पर जड़ा पुत्रे जो नी मनदा है, उसयो अनन्त जिन्दगी नी मिलणी, पर परमेश्वरे दी सजा उसयो मिलणी है।” ");
INSERT INTO bht_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","फिरी जालू यीशुऐ जो पता लग्गा की फरीसियां सुणाया है की यीशु यूहन्ना ला जादा चेले बणांदा कने बपतिस्मा दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","यीशु नी पर उदे चेले बपतिस्मा दिन्दे थे, ");
INSERT INTO bht_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","तालू सै यहूदिया प्रदेश जो छडी करी फिरी अपणे चेलयां सोगी गलील प्रदेशे दे इलाके जो चली गिया, ");
INSERT INTO bht_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","कने उसयो सामरियां प्रदेश ला होईकरी जाणा जरूरी था, क्योंकि परमेश्वर भी ऐई चांदा था। ");
INSERT INTO bht_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","तांई तां सै सामरिया प्रदेश दे खूखार शेहरे दीकर आया, जड़ा उसा जमिना दे बखे है जड़ी याकूबे अपणे पुत्र यूसुफे जो दितियो थी। ");
INSERT INTO bht_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","कने याकूबे जड़ा खु ओथु बणाया था, सै हले दीकर भी ओथु ही था। कने यीशु रस्ते च थकी करी उस खुऐ पर इयां ही बेई गिया। कने ऐ गल्ल दोपहर दे बकते होई थी। ");
INSERT INTO bht_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","इतणे च इक सामरी जनानी पांणी भरना आई। यीशुऐ उसा जो बोलया की “मिंजो पींणे तांई पांणी दे।” ");
INSERT INTO bht_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","क्योंकि उदे चेले तां शेहरे च खाणा खरीदणा गियो थे। ");
INSERT INTO bht_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","इना सामरी जनानिया उसला बोलया, तू यहूदी होईकरी सामरी जनानिया ला पांणी कजो मंगा दा है? क्योंकि यहूदी सामरियां सोगी कुछ भी रिश्ता नी रखदे। ");
INSERT INTO bht_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","यीशुऐ जबाब दिता, “तू नी जाणदी है की परमेश्वर तिजो क्या देणा चांदा, कने ऐ भी नी जाणदी की कुण तिजो ला पांणी मंगा दा है। अगर तू जाणदी, तां तू मिंजो ला मंगदी, कने मैं तिजो जिन्दगिया दा पांणी दिन्दा जड़ा जिन्दगी दिन्दा है।” ");
INSERT INTO bht_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","जनानिया उसला बोलया, प्रभु जी, तेरे बाल पांणिऐ भरने तांई तां कुछ हे भी नी है, कने खु तां बड़ा डुगा है; तां फिरी सै जिन्दगिया दा पांणी तेरे बाल कुथु ला आया? ");
INSERT INTO bht_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","क्या तू साड़े पूर्वज याकूबे ला बडा है, जिनी सांझो ऐ खु दिता; कने उनी कने उदे बचयां कने डंगरां समेत इस खुऐ ला पीता? ");
INSERT INTO bht_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","यीशुऐ उसा जो जबाब दिता, जड़ा कोई इस पांणिऐ जो पिंगा उसयो फिरी त्रे लगी पोंणी, ");
INSERT INTO bht_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","पर जड़ा कोई उस पांणिऐ जो पिंगा जड़ा मैं उसयो देणा, तां उनी फिरी अनन्तकाल दीकर कदी त्रिणा नी होणा। जड़ा पांणी मैं उसयो दिंगा, सै उदे च इक पांणिऐ दा खु बणी जाणा, जड़ा उस पाणिऐ जो दिन्दा रेंदा है कने उसयो हमेशा दी जिन्दगी देणी। ");
INSERT INTO bht_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","उना जनानिया उसला बोलया, “प्रभु जी, सै पांणी मिंजो दे ताकि मिंजो त्रे ना लग्गे कने ना पांणी भरणे तांई बार-बार इतणी दुरे जो ओऐ।” ");
INSERT INTO bht_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","यीशुऐ उसा जो बोलया, “जा, अपणे घरे बाले जो ऐथू सदी लेई ओ।” ");
INSERT INTO bht_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","जनानिया जबाब दिता, “मेरा घरे बाले नी है।” यीशुऐ उसा ने बोलया, “तू ठीक बोलदी है, की मेरा घरेबाला नी है। ");
INSERT INTO bht_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","क्योंकि तू पंज घरे बाले करी बेठिइयो है, कने हुण तू जिस माणुऐ बाल है सै भी तेरा घरेबाला नी है; ऐ तू सच्च बोलया है।” ");
INSERT INTO bht_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","जनानिया उसला बोलया, “प्रभु जी, मिंजो लगदा है तू परमेश्वरे दा संदेश देणेबाला है। ");
INSERT INTO bht_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","साड़े सामरी पूर्वज इसी पाहेड़े पर परमेश्वरे दी भक्ति करदे थे, कने तुसां यहूदी लोक बोलदे न की सै जगा जिथू अराधना करणी चाईदी सै यरूशलेम शेहर च है।” ");
INSERT INTO bht_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","यीशुऐ उसा ने बोलया, “हे जनानिये, मेरिया गल्लां पर भरोसा कर की सै बकत ओंणा है, ना तां तुसां इसी पाहेड़े पर पिता दी भक्ति करणी है ना तां यरूशलेम शेहर च। ");
INSERT INTO bht_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","तुसां सामरी लोक जिसयो नी जाणदे न, उदी भक्ति करदे न; कने असां यहूदी लोक जिसयो जाणदे न उदी अराधना करदे न; क्योंकि उद्धार करणे बाले यहूदियां चे ही ओंणा है। ");
INSERT INTO bht_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","पर सै बकत ओंणा है, मतलब अजे भी है, जिदे च सच्चे भक्त पिता परमेश्वरे दी भक्ति आत्मा कने सचाइया ने करणी है, क्योंकि पिता परमेश्वर अपणे तांई ऐदे ही अराधना करणे बालयां जो तोपदा है। ");
INSERT INTO bht_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","परमेश्वर आत्मा है, कने जरूरी है की उदी अराधना करणे बाले आत्मा कने सचाइया ने भक्ति करन।” ");
INSERT INTO bht_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","जनानिया उसला बोलया, “मैं जाणदी है की मसीह जिसयो ख्रिस्तुस बोलदे न, ओंणे बाला है; जालू उनी ओणा है, तां उनी सांझो सारियां गल्लां दसी देणियां न।” ");
INSERT INTO bht_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","यीशुऐ उसा ने बोलया, “मैं जड़ा तिजो ने बोला दा है, सेई है।” ");
INSERT INTO bht_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","इतणे च उदे चेले आई गे, कने हेरान होणा लग्गे की सै जनानिया ने गल्लां करा दा है; पर तमी कुनी नी पुछया, तू क्या चांदा है? “कने कजो इसा ने गल्लां करा दा है?” ");
INSERT INTO bht_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तालू सै जनानी अपणा घड़ा छडी करी शेहरे जो चली गेई, कने लोंका ने बोलणा लग्गी, ");
INSERT INTO bht_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ओआ, इक माणुऐ जो दिखा, जिनी सब कुछ दसी दिता जड़ा मैं कितया। कुथी ऐई तां मसीह नी है?” ");
INSERT INTO bht_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","तालू सै शेहरे ला निकली करी यीशुऐ जो दिखणा ओंणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","इतणे च उदे चेले आई करी उसला बिनती करणा लग्गे, “गुरू जी, कुछ खाई ले।” ");
INSERT INTO bht_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","पर यीशुऐ उना ने बोलया, “मेरे बाल खांणे तांई ऐसा खांणा है जिसयो तुसां नी जाणदे न।” ");
INSERT INTO bht_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","तालू चेलयां अपु चे बोलया, “क्या कुनी इदे तांई कुछ खांणे जो लांदया है?” ");
INSERT INTO bht_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","यीशुऐ उना ने बोलया, मेरा खांणा परमेश्वरे दी इच्छा दा पालन करणा है जिनी मिंजो भेजया है, कने उस कम्मे जो पूरा करणा है जड़ा उनी मिंजो सौंपया। ");
INSERT INTO bht_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","क्या तुसां नी बोलदे, बडाई करणे जो अजे भी चार महीने पियो न? दिखा, मैं तुसां ने बोलदा है, अपणियां हखी खोला कने ओणे बाले लोकां जो दिखा। सै खतरां च पकियो फसला सांई न, कने बडाइ तांई तैयार न। ");
INSERT INTO bht_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","पेहले ला ही बडणे बाले कम्म करा दे न कने उना जो अपणी मजदूरी मिल्ला दी है। कने बी राणे बाला कने बडणे बाला दोनों मिलिकरी खुशी मनान। ");
INSERT INTO bht_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","क्योंकि इसा गल्ला पर ऐ कहावत ठीक बोंदी है: रांणे बाला कोई होर है कने बडणे बाला कोई होर है। ");
INSERT INTO bht_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","मैं तुहांजो उस खेतरे जो बडणे तांई भेजया जिस च तुसां मेहनत नी कितियो होरनी मेंहनत कितियो है, “तुसां उसा फसला जो गठेरणा (जिस तांई उना कम्म कितया है)।” ");
INSERT INTO bht_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","कने उस शेहरे दे मतयां सामरियां उसा जनानिया दे बोलणे ने यीशुऐ पर भरोसा किता; जिना ऐ बोलया था, की उनी सब कुछ दसी दिता, जड़ा मैं कितया है। ");
INSERT INTO bht_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","जालू से सामरी उदे बाल आये, तां उसला बिनती करणा लग्गे की साड़े ऐथू रे। तां सै ओथु दो रोज रिया। ");
INSERT INTO bht_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","कने उदे संदेश दिया बजा ने मतयां यीशुऐ पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","कने उना जनानिया बोलया, हुण असां तेरे बोलणे ने ही भरोसा नी करदे न, क्योंकि असां अपु ही सुणी लिया, कने असां जाणदे न की ऐई सच्ची दा संसारे दा उद्धार करणे बाला है। ");
INSERT INTO bht_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","फिरी सै उना दो रोजां बाद सै ओथु ला निकली करी गलील प्रदेश जो गिया। ");
INSERT INTO bht_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","क्योंकि यीशुऐ अपु ही बोलया था की परमेश्वरे दा संदेश देणेबाले दी अपणे देशे च इज्जत नी होंदी है। ");
INSERT INTO bht_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","जालू सै गलील प्रदेश गिया, तां गलील बासी खुशिया ने उसला मिल्ले; क्योंकि जितणे भी कम्म उनी यरूशलेम शेहर च त्योहारे बेले कितयो थे, उना सारयां कम्मा जो दिखया था, क्योंकि सै भी त्योहारे जो गियो थे। ");
INSERT INTO bht_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","तालू सै फिरी गलील प्रदेश दे काना शेहर च आया, जिथू उनी पांणिऐ जो दाखरस बणाया था। ओथु राजे दा इक सेवक था जिसदा पुत्र कफरनहूम शेहर च बीमार था। ");
INSERT INTO bht_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","सै ऐ सुणीकरी की यीशु यहूदिया प्रदेश ला गलील प्रदेशे च आया है, उदे बाल गिया कने उसला बिनती करणा लग्गा की चली करी मेरे पुत्रे जो ठीक करी दे: क्योंकि सै मरणे बाला था। ");
INSERT INTO bht_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","यीशुऐ उसयो बोलया, जालू तुसां चमत्कार कने अनोखे कम्म नी दिखी लेंगे तालू दीकर तुसां मिंजो मसीहा नी मनणा। ");
INSERT INTO bht_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","राजे दे सेवके उसला बोलया, “प्रभु जी, मेरे जागते दी मौत होणे ला पेहले चल।” ");
INSERT INTO bht_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","यीशुऐ उसयो बोलया, “जा तेरा जागत जिन्दा है।” उनी माणुऐ यीशुऐ दी गल्ल मन्नी कने चली गिया। ");
INSERT INTO bht_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","सै अजे रस्ते च ही चलया था, की उदे सेवक उस बाल आई रे कने बोलणा लग्गे, “तेरा जागत जिन्दा है।” ");
INSERT INTO bht_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","उनी उना ला पुछया, “की कुस बकते सै खरा होणा लग्गा?” उना उसला बोलया, “कल दोपहर इक बजे उदा भुखार उतरी गिया।” ");
INSERT INTO bht_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","तालू उस जागते दा पिता समझी गिया की ऐ उस बकते ही होया है जिस बकते यीशुऐ बोलया, तेरा जागत जिन्दा है, “कने उनी कने उदे सारे घरे बालयां यीशुऐ पर भरोसा किता।” ");
INSERT INTO bht_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ऐ दुज्जा चमत्कार था जड़ा यीशुऐ यहूदिया प्रदेश ला गलील प्रदेश च बापस आई करी किता। ");
INSERT INTO bht_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","इना गल्लां दे बाद यहूदियां दा इक त्योहार होया, कने यीशु यरूशलेम शेहर जो गिया। ");
INSERT INTO bht_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरूशलेम च भेडां दे फाटके बखे इक तलाब है जिसयो इब्रानी भाषा च बैतहसदा बोलदे न, कने उदे चारो पास्से पंज बरांडे न। ");
INSERT INTO bht_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","उना च मते बीमार, अन्ने, लंगड़े कने सुकयो अंगा बाले, पांणिऐ हिलणे दिया आसा च ओथु बेई रेंदे थे। ");
INSERT INTO bht_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","क्योंकि परमेश्वरे दे नियुक्त बकते पर स्वर्गदूत तलाब पर उतरी करी पांणिऐ जो हिलादें थे: पांणी हिलणे बाद जड़ा कोई भी पेहले अंदर जांदा था सै ठीक होई जांदा था चाऐ उदी कोई भी बिमारी हो। ");
INSERT INTO bht_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ओथु इक माणु था, सै ठतियां सालां ला बीमारिया च था। ");
INSERT INTO bht_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","यीशुऐ उसयो पिया दिखीकरी कने जाणी करी की ऐ इसा हालता च बड़े रोजां ला है, उसला पुछया, “क्या तू ठीक होणा चांदा है?” ");
INSERT INTO bht_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","उनी बिमारे जबाब दिता, “प्रभु जी, मेरे बाल कोई माणु नी है, की जालू पांणी हिले, तालू मिंजो तलाब दे अंदर जाणे तांई मदद करे, मैं तलाब दे अंदर जाणे दी कोशिश करदा है, हमेशा मेरे पुजणे ला पेहले ही कोई होर मेरला पेहले तलाब अंदर चली जांदा है।” ");
INSERT INTO bht_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","यीशुऐ उसला बोलया, “उठ, अपणिया चटाईया जो चुकी करी हंड फिर।” ");
INSERT INTO bht_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","सै माणु झट ठीक होई गिया, कने अपणिया चटाईया जो चुकी करी चलणा फिरणा लग्गी पिया। ");
INSERT INTO bht_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","जिस रोजे ऐ सब होया सै सब्ते दा दिन था। इस तांई यहूदी अगुवे उसला जड़ा ठीक होया था, बोलणा लग्गे, “मूसा दिया व्यवस्था दे अनुसार सब्ते दे रोजे, तिजो चटाईया जो चुकी करी लेई जाणा ठीक नी है।” ");
INSERT INTO bht_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","उनी उना जो जबाब दिता, “जिनी मिंजो ठीक किता उनी मिंजो बोलया है, अपणिया चटाईया चुकी करी चल फिर।” ");
INSERT INTO bht_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","उना उसला पुछया, “सै कुण माणु है जिनी तिजो ऐ बोलया, चटाई जो चुक कने चल फिर?” ");
INSERT INTO bht_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","पर जड़ा ठीक होई गिया था, सै नी जाणदा था की सै कुण है; क्योंकि उसा जगा पर भीड़ होंणे दिया बजा ने यीशु ओथु भिड़ा ने मिली गिया कने उना जो मिल्ला नी। ");
INSERT INTO bht_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","कुछ बकते बाद सै यीशुऐ जो मंदरे दे अंगणे च मिला, तालू उनी उसला बोलया, “दिख, तू तां ठीक होई गिया है; हुण दोबारा पाप मत करदा, इयां ना हो की इसला भी बडी मुसिबत तिजो पर आई जा।” ");
INSERT INTO bht_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","उनी माणुऐ जाई करी यहूदी अगुवां ने बोली दिता की जिनी मिंजो ठीक कितया है सै यीशु है। ");
INSERT INTO bht_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","इसा बजा ने यहूदी अगुवे यीशुऐ जो सताणां लग्गे, क्योंकि सै ऐसे-ऐसे कम्म सब्ते दे रोजे करदा था। ");
INSERT INTO bht_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","इसा गल्लां पर यीशुऐ उना ने बोलया, मेरा पिता परमेश्वर हले दीकर कम्म करदा है कने मिंजो भी कम्म करणा चाईदा। ");
INSERT INTO bht_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","यीशुऐ ऐ बोलया इसा बजा ने यहूदी अगुवे उसयो होर भी जादा मारणे दी कोशिश करणा लग्गे, की सै सिर्फ ऐई नी की सब्ते दे दिने दे रिबाजे जो तोड़ा दा, पर सै परमेश्वरे जो भी अपणा पिता बोली करी, अपणे आपे जो परमेश्वर दे बराबर बोला दा था। ");
INSERT INTO bht_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","इसी पर यीशुऐ उना ने बोलया, मैं तुसां ने सच्च-सच्च बोलदा है, मैं अपु ला कुछ नी करी सकदा है, सिर्फ सेई जड़ा सै पिता परमेश्वर जो करदे दिखदा है, क्योंकि जिना-जिना कम्मा जो सै करदा है उना जो मैं भी तियां ही करदा है। ");
INSERT INTO bht_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","इस तांई पिता परमेश्वर मिंजो ने प्यार करदा है कने जड़े-जड़े कम्म सै अपु करदा है, सै सारे उसयो दसदा है; कने उनी इना ला भी बड्डे कम्म उसयो दसणे न, ताकि तुसां हेरान होन। ");
INSERT INTO bht_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","क्योंकि जियां मेरा पिता परमेश्वर मरयां लोकां जो जिन्दा करदा है, तियां ही मैं भी जिना जो चांदा है उना जो जिन्दा करदा है। ");
INSERT INTO bht_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","पिता परमेश्वर कुसी दा भी न्याय नी करदा है, पर न्याय करणे दा सारा कम्म मिंजो देई दितया है, ");
INSERT INTO bht_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","इस तांई जियां सारे लोक पिता परमेश्वर दा आदर करदे न तियां ही मेरा भी आदर करन जड़ा मेरा आदर नी करदा, सै पिता परमेश्वर दा आदर भी नी करदा है जिनी उसयो भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","मैं तुसां ने सच्च-सच्च बोलदा है, जड़ा मेरा बचन सुणीकरी मेरे भेजणे बाले पर भरोसा करदा है, हमेशा दी जिन्दगी उदी है, कने उसयो सजा नी मिलणी है पर सै तां अनन्त मौता ला बची गिया है कने उनी पेहले ला ही जिन्दगी च प्रवेश करी लिया है। ");
INSERT INTO bht_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“मैं तुसां ने सच्च-सच्च बोलदा है, सै बकत ओणा है, कने हुण है, जिदे च मरयां परमेश्वरे दे पुत्र, मेरी अबाज सुणनी, कने जड़े सुणगे उना हमेशा तांई जी पोणा है।” ");
INSERT INTO bht_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","क्योंकि जियां पिता परमेश्वर अपणे अंदर जिन्दगी रखदा है, तियां ही उनी अपणे पुत्र, जो भी हक दितया है की सै अपणे आपे च जिन्दगी रखे; ");
INSERT INTO bht_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","क्योंकि मैं माणुऐ दा पुत्र है, इस तांई पिता परमेश्वरे मिंजो सारे लोकां जो न्याय करणे दा अधिकार दितया है। ");
INSERT INTO bht_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","इसला हेरान मत होआ, क्योंकि सै बकत ओंणा है, की सै सारे लोक जड़े मरी गियो न, उना मेरी मतलब की, माणुऐ दे पुत्रे दी अबाज सुणीकरी जिन्दे होई जाणा है। ");
INSERT INTO bht_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","जिना बाल अच्छी जिन्दगी थी, उना हमेशा दी जिन्दगी तांई जिन्दे होई जाणा है, सै जड़े बुराई च जिन्दगी बितान्दे न, उना दोषी होणे तांई जी पोणा है। ");
INSERT INTO bht_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“मैं अपणे आपे ला कुछ नी करी सकदा; मैं लोकां दा न्याय तियां ही करदा है जियां पिता परमेश्वर मिंजो उना दा न्याय करणे तांई बोलदा है, कने मेरा न्याय सही है; क्योंकि मैं अपणी मरजी नी, पर अपणे भेजणे बाले दी मर्जी चांदा है। ");
INSERT INTO bht_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","अगर मैं अपु ही अपणी गबाई दें, तां मेरी गबाई सच्ची नी है। ");
INSERT INTO bht_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","इक होर है जड़ा मेरा पिता परमेश्वर है, सै भी मेरे बारे च गबाई दिन्दा है, कने मैं जाणदा है की मेरी जड़ी सै गबाई दिन्दा है, सै सच्ची है। ");
INSERT INTO bht_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","तुसां यूहन्ना बपतिस्मा देणेबाले बाल संदेश देणेबाले भेजे कने उनी सचाइया दी गबाई दितियो है। ");
INSERT INTO bht_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","पर मैं अपणे बारे च माणुआं दी गबाई नी चांदा है; तमी मैं इसा गबाई दे बारे च दसया है जड़ी यूहन्ना दिती थी ताकि तुहाड़ा उद्धार होऐ। ");
INSERT INTO bht_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","युहन्ना इक दिय्ये सांई था; कने तुहांजो थोड़िया देरा तांई उदिया लौई च, मगन होणा खरा लग्गा। ");
INSERT INTO bht_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","पर मेरे बाल यूहन्ना ला भी बड्डी गबाई है: क्योंकि जड़ा कम्म पिता परमेश्वरे मिंजो पूरा करणे तांई दितया सै मेरे बारे च गबाई दिन्दा है। जड़ा कम्म मैं करी सकदा है, सै गबाई दिन्दा है की मिंजो पिता परमेश्वरे भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","कने पिता परमेश्वर जिनी मिंजो भेजया है, उना ही मेरी गबाई दितियो है तुसां ना तां उदी कदी अबाज सुणी, कने ना उसयो आमणे सामणे दिखया है। ");
INSERT INTO bht_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","कने उदे संदेशा जो मने च टिकाई करी नी रखदे, क्योंकि जिसयो परमेश्वरे भेजया है तुसां उदा भरोसा नी करदे। ");
INSERT INTO bht_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","तुसां पबित्र शास्त्रां च ध्याने ने पढ़ी करी तोपदे न, क्योंकि तुसां समझदे न की उना ने हमेशा दी जिन्दगी मिलदी है, कने ऐ सेई बचन है, जड़ा मेरी गबाई दिन्दा है; ");
INSERT INTO bht_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","पर ऐ सब होणे पर भी अनन्त जिन्दगी पांणे तांई मेरे बाल नी ओंणा चांदे न। ");
INSERT INTO bht_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","मैं माणुऐ ला आदर दी आस नी रखदा है। ");
INSERT INTO bht_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","क्योंकि मैं तुसां जो जाणदा है की तुसां अपणे मने च परमेश्वरे तांई प्यार नी रखदे न। ");
INSERT INTO bht_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","मैं अपणे पिता परमेश्वर दे अधिकारे ने आया है, कने तुसां मिंजो अपनांदे नी अगर कोई होर अपणे ही अधिकारे ने ओऐ, तां उसयो तुसां अपनाई लेंदे न। ");
INSERT INTO bht_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","तुसां मिंजो पर भरोसा नी करी सकदे न, क्योंकि तुसां इकी दुज्जे ला अपणी आदर मान चांदे न, कने तुसां इकलोते परमेश्वरे ला आदर मान पाणे दी कोशिश नी करदे न। ");
INSERT INTO bht_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ऐ मत समझा, की मैं पिता परमेश्वरे दे सामणे तुसां पर दोष लगा दा: मूसा, जिस पर तुसां आस रखियो है, उनी तुसां पर दोष लगाणे न। ");
INSERT INTO bht_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","क्योंकि अगर तुसां मूसा दा भरोसा करदे, तां मेरा भी भरोसा करदे, इस तांई की उनी भी मेरे बारे च पबित्र शास्त्र च लिखया है। ");
INSERT INTO bht_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","क्योंकि तुसां उदियां लिखियां गल्लां दा भरोसा नी करदे, तां तुसां पक्का ही मेरियां गल्लां दा भी नी करी सकदे।” ");
INSERT INTO bht_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","इना गल्लां दे बाद यीशु गलील झिला च मतलब की तिबिरियासे दिया झिला बखे गिया। ");
INSERT INTO bht_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","कने बड़ी भरी भीड़ उदे पिच्छे चली पेई क्योंकि जड़े अनोखे कम्म सै बिमारां पर दसदा था सै उना जो दिखदे थे। ");
INSERT INTO bht_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","तालू यीशु पहाड़े पर चढ़ी करी अपणयां चेलयां सोगी ओथु बैठा। ");
INSERT INTO bht_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","कने यहूदियां दे फसह दा त्योहारे नेड़े ही था। ");
INSERT INTO bht_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","तालू यीशुऐ नजरा चुकी करी मती भरी भिड़ा जो अपणे बाल ओंदे दिखया, कने फिलिप्पुस ने बोलया, “असां इना जो खांणे तांई रोटी कुथु ला खरदी लोंणी?” ");
INSERT INTO bht_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","पर यीशुऐ ऐ गल्ल उसयो परखणे तांई बोली; क्योंकि सै अपु जाणदा था की मैं क्या करणा है। ");
INSERT INTO bht_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिप्पुसे उसयो जबाब दिता, “इतणी रोटियां दी कीमत दो सो दिना दिया मजदुरिया दे बराबर होणी, सै भी उना तांई पूरी नि होणी की उना चे हर इकी जणे जो थोड़ी-थोड़ी मिल्ली जा।” ");
INSERT INTO bht_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","उदे चेलयां चे शमौन पतरस दे भाई अन्द्रियासे उसयो बोलया, ");
INSERT INTO bht_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ऐथू इक जागत है जिदे बाल जौ दियां पंज रोटियां न कने दो मछियां न, पर ऐ इतणे लोंका तांई काफी नी है।” ");
INSERT INTO bht_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","यीशुऐ बोलया, “लोकां जो बठाई दिया।” उसा जगा पर मता घा था: तालू सै लोक बैठी गे, कने सै गिणतिया च लगबग पंज हजार थे। ");
INSERT INTO bht_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तालू यीशुऐ रोटियां लियां, कने धन्यबाद करिके जड़े बैठयो थे उना जो बंडी दितियां: कने तियां ही मछियां जो भी जितणियां सै चांदे थे बंडी दितियां। ");
INSERT INTO bht_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","जालू सै खाई करी रजी गे तां उनी अपणे चेलयां ने बोलया, “बचयां टुकड़यां जो गठेरी लिया, ताकि कुछ बर्बाद ना होऐ।” ");
INSERT INTO bht_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","उना सै रोटियां दे टुकड़े गठेरे, कने सै पंज रोटियां दे टुकड़े जड़े खांणे बालयां ला बची गियो थे उना ने बाहरा टोकरियाँ भरियां। ");
INSERT INTO bht_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","तालू जड़ा अनोखा कम्म उनी करी के दसया उसयो दिखीकरी लोक बोलणा लग्गे; की सै परमेश्वरे दा संदेश देणेबाला है जड़ा संसारे च ओंणे बाला था, सै पका ऐई है। ");
INSERT INTO bht_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","यीशु ऐ जाणी करी की लोक मिंजो राजा बणाणे तांई आई करी पकड़ना चांदे न, फिरी पहाड़े पर किला ही चली गिया। ");
INSERT INTO bht_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","फिरी जालू संज होई, तां उदे चेले झिला कंडे पर आये, ");
INSERT INTO bht_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","कने किस्तिया पर चढ़ी करी झिला पार कफरनहूम शेहर जो जाणा लग्गे: उस बेले नेहरा होई गिया था, कने यीशु हले दीकर उना बाल नी पुजया था। ");
INSERT INTO bht_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","कने तुफाने दिया बजा ने झिला च लेहरां उठणा लगियां। ");
INSERT INTO bht_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","जालू सै चलदे-चलदे लगबग चार मील निकली गे, तां उना यीशुऐ जो झिला पर चलदे कने किस्तिया बखे ओंदे दिखया, कने चेले डरी गे। ");
INSERT INTO bht_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","पर यीशुऐ उना ने बोलया, “मैं है; डरा मत।” ");
INSERT INTO bht_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","सै उसयो किस्तिया पर चढ़ाणे तांई तैयार होऐ कने झट सै किस्ति उसा जगा जाई पुज्जी जिसा जगा सै चलयो थे। ");
INSERT INTO bht_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","दुज्जे रोजे उना भिड़ा, जड़ी झिला पार खड़ोतियो थी, ऐ दिखया की ऐथू इकी जो छडी करी होर कोई लोकी किस्ति नी थी, कने यीशु अपणयां चेलयां सोगी इसा किस्तिया पर नी चढ़या था, बस उदे चेले ही गियो थे। ");
INSERT INTO bht_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","होर लोकी किस्तियां तिबिरियास शेहरे ला उसा जगा पर आईयां, जिथू उना प्रभु दा धन्यबाद करणे बाद रोटी खादी थी। ");
INSERT INTO bht_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","जालू भिड़ा दिखया, की ऐथू ना यीशु है, ना उदे चेले, तां सै भी लोकियाँ-लोकियाँ किस्तिया पर चढ़ी करी यीशुऐ जो तोपदे कफरनहूम शेहर च जाई पुज्जे। ");
INSERT INTO bht_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","कने झिला दे पार उसला मिली करी उसयो बोलया, “गुरू जी, तू ऐथू कालू आया?” ");
INSERT INTO bht_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","यीशुऐ उना जो जबाब दिता, “मैं तुसां ने सच्च-सच्च बोलदा है, तुसां मिंजो इस तांई नी तोपा दे की तुसां अनोखे कम्म दिखयो, पर इस तांई की तुसां रोटियां खाई करी रजी गे। ");
INSERT INTO bht_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","खत्म होणे बाले खांणे पिच्छे मेहनत मत करा, पर उस खांणे तांई करा जड़ा हमेशा दिया जिन्दगिया दीकर रेंदा है, जड़ा मैं माणुऐ दे पुत्रे तुहांजो ऐ खाणा देणा है, क्योंकि पिता परमेश्वरे मिंजो ऐसा करणे दा हक दितया है।” ");
INSERT INTO bht_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","उना यीशुऐ ला पुछया, “परमेश्वरे दा कम्म करणे तांई असां क्या करन?” ");
INSERT INTO bht_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","यीशुऐ उना जो जबाब दिता, “परमेश्वर चांदा है की तुसां उस पर भरोसा करन जिसयो उनी भेजया है।” ");
INSERT INTO bht_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","तालू उना उसला पुछया, “फिरी तू कुण दिया चमत्कार दसदा है, कि असां उसयो दिखीकरी तिजो पर भरोसा करन? तू कुण दिया कम्म दसदा है? ");
INSERT INTO bht_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","साड़यां पूर्वजां सुनसान जगा च मन्ना खादा; जियां पबित्र शास्त्र च लिखया है, मूसा उना जो खांणे तांई स्वर्गे ला रोटी दिती।” ");
INSERT INTO bht_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","यीशुऐ उना बोलया, “मैं तुसां ने सच्च-सच्च बोलदा है तुहांजो सै रोटी स्वर्गे ला मूसा नी दितियो, पर मेरे पिता परमेश्वर तुहांजो स्वर्गे ला सच्ची रोटी दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","क्योंकि परमेश्वरे दी रोटी सेई है, जड़ी स्वर्गे ला उतरी करी संसारे दे लोकां जो जिन्दगी दिन्दी है।” ");
INSERT INTO bht_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","तालू उना उसला बोलया, “प्रभु जी, ऐ रोटी सांझो रोज ही दे कर।” ");
INSERT INTO bht_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","यीशुऐ उना ने बोलया, “रोटी जड़ी हमेशा दी जिन्दगी दिन्दी है सै रोटी मैं है: जड़ा मेरे बाल ओंगा उनी कदी भूखे नी होणा कने जड़ा मिंजो पर भरोसा करगा, सै कदी तरिणा नी होणा। ");
INSERT INTO bht_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","पर मैं तुसां ने पेहले ही बोलया था, की तुसां मिंजो दिखी भी लिया है तमी भरोसा नी करदे। ");
INSERT INTO bht_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","जड़ा कुछ पिता परमेश्वरे मिंजो दिन्दा है, सै सब मेरे बाल ओंणा है, कने जड़ा कोई मेरे बाल ओंगा उसयो मैं कदी नी कडगा। ");
INSERT INTO bht_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","क्योंकि मैं अपणी इच्छा नी, पर अपणे भेजणे बाले दी इच्छा पुरी करणे तांई स्वर्गे ला उतरया है। ");
INSERT INTO bht_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","कने मेरे भेजणे बाले दी इच्छा ऐ है की जड़ा कुछ उनी मिंजो दितया है, उदे चे मैं कुछ नी गबां पर उसयो आखरी रोजे इसयो फिरी ला जिन्दा करे। ");
INSERT INTO bht_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","क्योंकि मेरे पिता परमेश्वरे दी इच्छा ऐ है, की जड़ा कोई मिंजो दिखदा है, कने मिंजो पर भरोसा करे, उसयो हमेशा दी जिन्दगी मिल्ले; कने मैं उसयो आखरी रोजे फिरी जिन्दा करी दिंगा।” ");
INSERT INTO bht_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","तालू यहूदी अगुवे उस पर बुड़बड़ाणा लग्गे, इस तांई की उनी बोलया था, “जड़ी रोटी स्वर्गे ला उतरियो है सै मैं है।” ");
INSERT INTO bht_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","कने उना बोलया, “क्या ऐ यूसुफे दा पुत्र यीशु नी है, जिसदे माता-पिता जो असां जाणदे न? तां सै कजो बोलदा न की मैं स्वर्गे ला उतरया है?” ");
INSERT INTO bht_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","यीशुऐ उना जो जबाब दिता, “अपु चे मत बुड़बुड़ा। ");
INSERT INTO bht_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","कोई मेरे बाल नी आई सकदा है, जालू दीकर पिता परमेश्वर, जिनी मिंजो भेजया है, उसयो अपणे बाल खिची नी ले; कने मैं उसयो आखरी रोजे फिरी जिन्दा करी देणा है। ");
INSERT INTO bht_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","परमेश्वरे दा संदेश देणेबालयां लेखां च ऐ लिखया है, सै सारे परमेश्वरे दीया तरफा ला सिखाऐ होणे न। जिनी कुनी पिता परमेश्वर ला सिखया कने सुणाया है, सै मेरे बाल ओंदा है। ");
INSERT INTO bht_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","कुनी भी पिता परमेश्वर जो नी दिखया। मैं किल्ला ही है, जड़ा परमेश्वर दिया तरफा ला आया है, जिनी उसयो दिखया है। ");
INSERT INTO bht_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","मैं तुसां ने सच्च-सच्च बोलदा है, की जड़ा कोई मिंजो पर भरोसा करदा है, हमेशा दी जिन्दगी उदी है। ");
INSERT INTO bht_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","रोटी जड़ी जिन्दगी दिन्दी है सै मैं है। ");
INSERT INTO bht_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","तुहाड़े पूर्वजां सुनसान जगा च मन्ना खादा कने मरी गे। ");
INSERT INTO bht_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ऐ जिन्दगी दी रोटी है जड़ी स्वर्गे ला उतरदी है ताकि माणु इसयो खा कने कदी मरे ना। ");
INSERT INTO bht_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","जिन्दी रोटी जड़ी स्वर्गे ला उतरी सै मैं है। अगर कोई इसा रोटिया चे खा, तां हमेशा जिन्दा रेंणा, कने जड़ी रोटी मैं संसारे दिया जिन्दगिया तांई दिंगा, सै मेरा मास है।” ");
INSERT INTO bht_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","इस पर यहूदी अगुवे ऐ बोली करी अपु चे लड़ना लग्गे, “ऐ माणु सांझो कियां अपणा मास खांणे जो देई सकदा है?” ");
INSERT INTO bht_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","यीशुऐ उना ने बोलया, “मैं तुसां ने सच्च-सच्च बोलदा है जालू दीकर मेरा, माणुऐ दे पुत्रे दा मास नी खांगे, कने उदा खून नी पींगे, तुसां च जिन्दगी नी है। ");
INSERT INTO bht_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","जड़ा मेरा मास खांदा है, कने मेरा खून पिंदा है, हमेशा दी जिन्दगी उदी ही है, कने न्याये दे रोजे उसयो फिरी जिन्दा करणा। ");
INSERT INTO bht_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","क्योंकि मेरा शरीर सच्ची खांणे दी चीज है कने मेरा खून भी सच्ची पिंणे दी चीज है। ");
INSERT INTO bht_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","जड़ा मेरा मास खांदा है कने मेरा खून पिंदा है सै मिंजो च टिकी रेंदा है, कने मैं उदे च रेंदा है। ");
INSERT INTO bht_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","मेरा पिता परमेश्वर जिनी मिंजो भेजया है, सै जिन्दगी दिन्दा है। जियां उनी मिंजो जिन्दगी दितियो, तियां ही मैं भी उस माणुऐ जो जिन्दगी देणी जड़ा मेरे शरीरे जो खांदा है।” ");
INSERT INTO bht_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ऐ सै रोटी है, जड़ी स्वर्गे ला उतरी होई है; पर तुहाड़े पूर्वजां मन्ना खादा, कने मरी गे: जड़ा कोई ऐ रोटी खांगा, उनी हमेशा जिंदे रेंणा। ");
INSERT INTO bht_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ऐ गल्लां उनी कफरनहूम शेहरे दे इक यहूदी जंज घर च उपदेश दिन्दे बेले बोलियां। ");
INSERT INTO bht_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","तांई तां यीशुऐ दे चेलयां चे मतयां ऐ सुणीकरी बोलया, ऐ समझणा बड़ा मुश्किल है; की कुण इसयो मन्नी सकदा है? ");
INSERT INTO bht_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","यीशुऐ अपणे मने च ऐ जाणी करी की मेरे चेले अपु चे इसा गल्ला दे बारे च बुड़बुड़ा दे न, उना ला पुछया, “क्या ऐ गल्ल तुहांजो मिंजो पर भरोसा करणे ला रोकदी है? ");
INSERT INTO bht_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","कने अगर तुसां मिंजो माणुऐ दे पुत्रे जो स्वर्गे जांदे दिखगे, जिथू सै पेहले था, तां क्या होंगा? ");
INSERT INTO bht_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","परमेश्वरे दी आत्मा तां जिन्दगी देणेबाली है, शरीरे ने कोई फायदा नी है: जड़ियां गल्लां मैं तुसां ने बोलियाँ सै पबित्र आत्मा ने बोलियां न, कने ऐ गल्लां माणुआं जो जिन्दगी दीदियां न। ");
INSERT INTO bht_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","पर तुसां चे कितणे ऐसे न जड़े भरोसा नी करदे न।” क्योंकि यीशु तां पेहले ही जाणदा था की जड़े भरोसा नी करदे न, सै कुण न; कने कुनी उसयो पकड़वाणा है। ");
INSERT INTO bht_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","कने यीशुऐ बोलया, इसी तांई मैं तुसां ने बोलया था की जालू दीकर पिता परमेश्वर दिया तरफा ला ऐ बरदान ना होऐ, तालू दीकर सै मेरे बाल नी आई सकदा है। ");
INSERT INTO bht_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","इसी पर उदे चेलयां चे मते बापस फिरी गे कने उदे बाद कदी उस सोगी नी चले। ");
INSERT INTO bht_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","तालू यीशुऐ उना बाहरां चेलयां ने बोलया, “क्या तुसां भी चली जाणा चांदे न?” ");
INSERT INTO bht_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","शमौन पतरसे उसयो जबाब दिता, प्रभु जी, असां कुसदे बाल जाणा? हमेशा दिया जिन्दगिया दियां गल्लां तां तेरे बाल ही न। ");
INSERT INTO bht_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","कने असां भरोसा कितया है, कने जाणी गियो न, की परमेश्वरे दा पबित्र जन कने मसीहा तू ही है जिसयो परमेश्वरे भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","यीशुऐ उसयो जबाब दिता, “क्या मैं तुसां बाहरां चेलयां जो नी चुणयां है? तमी तुसां च इक माणु बुरा है।” ");
INSERT INTO bht_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ऐ उनी शमौन इस्करियोती दे पुत्र यहूदा दे बारे च बोलया, क्योंकि ऐई जड़ा उना बाहरां च था, जिनी उसयो पकड़वाणा था। ");
INSERT INTO bht_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","इना गल्लां बाद यीशु गलील प्रदेश च गुमदा रिया, क्योंकि यहूदी अगुवे उसयो मारणे दी कोशिश करा दे थे, इस तांई सै यहूदिया प्रदेश च गुमणा नी चांदा था। ");
INSERT INTO bht_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","कने यहूदी लोकां दा इक त्योहारे ओंणे बाला था जिसयो झोपड़ियां दा त्योहार बोलदे थे। ");
INSERT INTO bht_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","इस तांई यीशुऐ दे भाईयां उसयो बोलया, “ऐथू ला यहूदिया प्रदेश जो चली जा, की जड़े कम्म तू करदा है, उना जो तेरे चेले भी दिखन। ");
INSERT INTO bht_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","क्योंकि कोई भी जड़ा प्रसिद्ध होणा चांदा है सै लुकी करी कम्म नी करदा, अगर तू ऐ कम्म करदा है, तां अपणे आपे जो संसारे च सबना दे सामणे कर।” ");
INSERT INTO bht_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","क्योंकि यीशुऐ दे भाई भी उस पर भरोसा नी करदे थे। ");
INSERT INTO bht_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तालू यीशुऐ उना ने बोलया, “मेरा बकत हले नी आया है; पर तुहाड़े तांई कोई भी बकत सही है। ");
INSERT INTO bht_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","संसारे दे लोक तुसां ने बैर नी करी सकदे न, पर सै मिंजो ने बैर करदे न, क्योंकि मैं उदे खिलाफ ऐ गबाई दिन्दा है, की उना दे कम्म बुरे न। ");
INSERT INTO bht_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","तुसां त्योहारे जो जा; मैं हले इसी त्योहारे जो नी जांणा, क्योंकि हले दीकर मेरा बकत पूरा नी होया है।” ");
INSERT INTO bht_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","सै उना ने ऐ गल्लां बोली करी गलील प्रदेश च ही रिया। ");
INSERT INTO bht_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","पर जालू उदे भाई त्योहारे जो चली गे, तां सै बादे च लुकी करी ओथु गिया। ");
INSERT INTO bht_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","यहूदी लोक त्योहारे च ऐ बोली करी यीशुऐ जो तोपणा लग्गे की सै कुथु है? ");
INSERT INTO bht_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","कने लोंकां च उदे बारे च लुकी-लुकी करी मतियां गल्लां बोलियां: कुछ बोलदे थे की, “सै भला माणु है।” कने कितणे ही बोलदे थे, की नी सै लोकां जो भटकांदा है। ");
INSERT INTO bht_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","यहूदी अगुवे दे डरे दिया बजा ने कोई भी माणु उदे बारे च खुली करी नी बोलदा था। ");
INSERT INTO bht_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","कने जालू त्योहारे दा अधा रोज होई गिया; तां यीशु मंदरे च जाई करी उपदेश देणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","तालू यहूदी लोक हेरान होईकरी बोलणा लग्गे, की ऐ माणु बिना पबित्र शास्त्र पढ़यो ज्ञानी कियां बणी गिया? ");
INSERT INTO bht_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","यीशुऐ उना जो जबाब दिता, “मेरा उपदेश मेरा अपणा नी है, पर परमेश्वरे दिया तरफा ला है जीनी मिंजो भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","अगर कोई उदिया इच्छा पर चलणा चा, तां उनी जाणी लेंणा की मेरी शिक्षा परमेश्वरे दिया तरफा ला ओंदी है, पर उपदेशे दे बारे च जाणी लेंणा की सै परमेश्वरे दिया तरफा ला है। ");
INSERT INTO bht_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","जड़ा अपणिया तरफा ला कुछ बोलदा है, सै अपणी ही इज्जत मान चांदा है; पर जड़ा अपणे भेजणे बाले दा इज्जत मान चांदा है सै ही सच्चा है, कने उदे च धोखा नी है। ");
INSERT INTO bht_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","क्या मूसा परमेश्वरे दा संदेश देणेबाले तुहांजो व्यवस्था नी दितियो है? तमी तुसां चे कोई भी व्यवस्था पर नी चलदा है। तुसां कजो मिंजो मारी देणा चांदे न?” ");
INSERT INTO bht_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","लोंका जबाब दिता; “तिजो च बुरी आत्मा है! कुंण तिजो मारणा चांदा है?” ");
INSERT INTO bht_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","यीशुऐ उना जो जबाब दिता, “मैं इक कम्म सब्ते बाले दिने किता, कने तुसां सारे हेरान होई गे। ");
INSERT INTO bht_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","इसा बजा ने मूसा तुहांजो खतने दा हुकम दितया है, ऐ नी की सै मूसा दिया तरफा ला है पर ऐ पूर्वजां ला चली आईयो है, कने सब्ते दे रोजे तुसां माणुऐ दा खतना करदे न। ");
INSERT INTO bht_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","जालू सब्ते दे रोजे माणुऐ दा खतना करदे न ताकि मूसा दिया व्यवस्था दा हुकम न टली जा, तां तुसां मिंजो पर कजो इस तांई गुस्सा करदे न, की मैं सब्ते दे रोजे इकी माणुऐ जो पुरी तरा ठीक किता। ");
INSERT INTO bht_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","तुसां बाहरी रूप दिखीकरी न्याय मत करा, पर सच्चाईया ने न्याय करा।” ");
INSERT INTO bht_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तालू कितणे यरूशलेम शेहर दे रेणेबाले बोलणा लग्गे, “क्या ऐ सै ही नी है, जिसयो साड़े अगुवे मारणे दी कोशिश करा दे न? ");
INSERT INTO bht_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","पर दिखा, सै तां शरेआम गल्लां करदा है कने कोई उसयो कोई कुछ नी बोलदा है; क्या होई सकदा की यहूदी अगुवां सच्ची जाणी लिया है की, ऐई मसीह है? ");
INSERT INTO bht_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","इसयो तां असां जाणदे न, की ऐ कुथु दा है; पर मसीह जालू ओंणा है, तां कुसयो नी पता होणा है सै कुथु दा है।” ");
INSERT INTO bht_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","तालू यीशुऐ मंदरे च उपदेश दिन्दे होऐ जोरे ने बोलया, “तुसां मिंजो जाणदे न, कने ऐ भी जाणदे न की मैं कुथु दा है: मैं तां अपु ला नी आया है पर मिंजो भेजणे बाला भरोसेमंद है, उसयो तुसां नी जांणदे न। ");
INSERT INTO bht_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","पर मैं उसयो जाणदा है; क्योंकि मैं उदिया तरफा ला है कने मिंजो उनी ही भेजया है।” ");
INSERT INTO bht_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","इसा गल्ला पर अगुवां उसयो पकड़ना चाया पर तमी कुनी भी उसयो गिरफ्तार नी किता, क्योंकि उदा मरणे दा सही बकत हले दीकर नी आया था। ");
INSERT INTO bht_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","कने भिड़ा चे मतयां यीशुऐ पर भरोसा किता, कने बोलणा लग्गे, की जालू मसीहे ओंणा है, तां उनी क्या इदे भी जादा अनोखे कम्म दसणे जड़े इनी दसे न? ");
INSERT INTO bht_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","फरीसियां लोंका जो उदे बारे च ऐ गल्लां बल्ले-बल्ले करदे सुणाया; कने बड्डे याजकां कने फरीसियां उसयो पकड़ने तांई मंदरे दे रखबाले भेजे। ");
INSERT INTO bht_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","इस पर यीशुऐ बोलया, “मैं थोड़िया देरा दीकर तुहाड़े सोगी है; फिरी मैं अपणे भेजणे बाले दे बाल बापस चली जाणा है। ");
INSERT INTO bht_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","तुसां मिंजो तोपणा है, पर मैं मिलणा नी है; कने जिथू मैं है, ओथु तुसां आई नी सकदे।” ");
INSERT INTO bht_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","यहूदी अगुवां अपु चे बोलया, इनी कुथु जाणा की सांझो इनी मिलणा ही नी है। क्या सै उना बाल जांगा जड़े यूनान शेहरे च लग-लग जगा च रेंदे न, कने यूनान दे लोकां जो भी उपदेश दिंगा? ");
INSERT INTO bht_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","सै क्या बोलणा चांदा है, जड़ी उनी बोली, की तुसां मिंजो तोपणा है, पर मैं नी मिलणा है: कने जिथू मैं है, ओथु तुसां नी आई सकदे? ");
INSERT INTO bht_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","फिरी त्योहारे दे आखरी रोजे, जड़ा खास दिन है, यीशु खड़ोता कने जोरे ने बोलया, “अगर कोई त्रिणा है तां मेरे बाल ओऐ कने पांणी पिऐ? ");
INSERT INTO bht_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","जड़ा मिंजो पर भरोसा करगा, जियां पबित्र शास्त्रां च लिख्या है, उदे मने चे पाणिऐ दियां खड्डां जड़ियां जिन्दगी दिन्दियां सै चली पोणियां न।” ");
INSERT INTO bht_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","जालू यीशुऐ ऐ गल्ल बोली, तां सै पबित्र आत्मा दे बारे च बोला दा था, सै उना सारयां जो मिलदा है जड़े उस पर भरोसा करदे थे, क्योंकि पबित्र आत्मा हल्ले दीकर नी उतरया था। क्योंकि परमेश्वरे हले दीकर यीशु दी महिमा जो प्रगट नी कितया था। ");
INSERT INTO bht_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","तालू भिड़ा चे केई लोकां ऐ सुणीकरी बोलया, “सच्ची ऐई है सै परमेश्वरे दा संदेश देणेबाला है, जिसदी असां उम्मीद रखियो है।” ");
INSERT INTO bht_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","लोकां बोलया, ऐ मसीह है, पर कुनी बोलया, “कजो? क्या मसीह गलील प्रदेश ला ओंणा है? ");
INSERT INTO bht_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","पर पबित्र शास्त्रां च लिखया है, की मसीहे दाऊदे दे बंशे ला कने बैतलहम शेहरे ला ओंणा है, जिथू दाऊद रेंदा था?” ");
INSERT INTO bht_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","इयां यीशुऐ दिया बजा ने लोंकां च फूट पेई गेई। ");
INSERT INTO bht_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","उना चे कितणे ही उसयो पकड़ाणा चांदे थे, पर कोई भी उसयो गिरफ्तार नी करी सकया। ");
INSERT INTO bht_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","तालू सपाई बड्डे याजकां कने फरीसियां बाल बापस आऐ, कने उना सिपाईयां ला पुछया, “तुसां उसयो कनी लंदा?” ");
INSERT INTO bht_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","सिपाईयां जबाब दिता, की कुनी माणुऐ कदी भी ऐदिया गल्लां नी बोलियां। ");
INSERT INTO bht_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","फरीसियां उना जो जबाब दिता, “क्या तुसां भी भटकी गियो न? ");
INSERT INTO bht_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","क्या सरदारां या फरीसियां चे कुनी भी उस पर भरोसा किता है? ");
INSERT INTO bht_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","पर ऐ लोक जड़े मूसा दी व्यवस्था जो नी जाणदे, उना जो परमेश्वरे श्राप दितया है।” ");
INSERT INTO bht_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","नीकुदेमुसे, (जड़ा राती यीशुऐ बाल आया था कने उना चे इक था), उना ने बोलया, ");
INSERT INTO bht_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“क्या साड़ी व्यवस्था कुसी माणुऐ जो जालू दीकर पेहले उदे बारे च सुणीकरी समझी ना ले की सै क्या करदा है, उसयो सजा दिन्दी है?” ");
INSERT INTO bht_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","उना उसयो जबाब दिता, “क्या तुमी गलील प्रदेशे दा है? पबित्र शास्त्र च तोप कने तां तिजो पता चलणा, की गलील दे इलाके ला कोई परमेश्वरे दा संदेश देणेबाले प्रगट नी होंणा है।” ");
INSERT INTO bht_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","तालू सारे अपणे-अपणे घरे जो चली गे। ");
INSERT INTO bht_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","पर यीशु अपणे चेलयां सोगी जैतून रुखां दे पाहड़े पर गिया। ");
INSERT INTO bht_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","यीशु अगली ब्यागा तड़के मंदरे दे अंगणे च बापस आया, कने मते सारे लोक उदे बाल आये; कने सै बेठी करी उना जो उपदेश देणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","जालू सै बोला दा ही था, तां धार्मिक व्यवस्था जो सिखाणे बाले कने फरीसी इक जनानिया जो लेई आये जड़ी व्यभिचार च पकड़ियो थी, कने उसा जो सामणे खरेड़ी करी यीशुऐ बोलया, ");
INSERT INTO bht_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“गुरू जी, ऐ जनानी व्यभिचार करदे पकड़ियो है। ");
INSERT INTO bht_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","व्यवस्था च मूसा सांझो हुकम दितया है की ऐसे माणुऐ जो पथर मारी करी मारी दिया: तां तू क्या बोलदा है की सांझो क्या करणा चाईदा?” ");
INSERT INTO bht_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","उना यीशुऐ जो परखणे तांई ऐ गल्ल बोली थी ताकि उना जो यीशुऐ पर दोष लांणे तांई कोई गल्ल मिल्ले, पर यीशु झुकी करी उंगलियां ने जमिना पर लिखणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","जालू सै उसला पूछदे रे, तां उनी सिधे होईकरी उना ने बोलया, “तुसां चे जिनी भी कदी पाप नी कितया है, सै ही पेहले इसा जो पथर मारे।” ");
INSERT INTO bht_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","कने फिरी झुकी करी उंगलियां ने जमिना पर लिखणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","पर ऐ सुणीकरी बडयां ला लेईकरी छोटयां दीकर सारे इक-इक करी के निकली गे क्योंकि सै जाणदे थे की सै पापी न, कने सिर्फ यीशु कने सै जनानी ओथु रेई गेई। ");
INSERT INTO bht_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","यीशुऐ सिधे होईकरी उसा ने बोलया, “हे जनानी, सै कुथु गे? क्या कुनी तिजो सजा देंणे दा हुकम नी दिता?” ");
INSERT INTO bht_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","उना बोलया, “प्रभु जी, कुनी भी नी।” यीशुऐ बोलया, “मैं भी तिजो सजा देणे दा हुकम नी दिन्दा; हुण बापस घरे चली जा, कने हुण दोवारा कदी जिंदगी च पाप मत करदी।” ");
INSERT INTO bht_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","तां यीशुऐ लोंका ने फिरी बोलया, “संसारे दी लौ मैं है; जड़ा मेरियां गल्लां पर चलगा, उनी नेहरे च नी चलणा है, कने उसयो सै लौ मिलणी जड़ी हमेशा दी जिन्दगी दिन्दी है।” ");
INSERT INTO bht_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","फरीसियां उसला बोलया; “तू अपणी गबाई अपु ही दिन्दा है, तेरी गबाई सच्ची नी है।” ");
INSERT INTO bht_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","यीशुऐ उना जो जबाब दिता, “अगर मैं अपणी गबाई अपु दिन्दा है, तमी मेरी गबाई ठीक है, क्योंकि मैं जाणदा है, की मैं कुथु ला आया है कने कुथयो जांणा है? पर तुसां नी जाणदे की मैं कुथु ला ओंदा है या कुथयो जांणा है। ");
INSERT INTO bht_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","तुसां लोक इन्सानी सोच ने बाकी लोकां दा न्याय करदे न; मैं कुसदा भी न्याय नी करदा है। ");
INSERT INTO bht_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","कने अगर मैं न्याय करे भी तां मेरा न्याय सच्चा है; क्योंकि मैं किल्ला नी है, पर मैं पिता परमेश्वरे सोगी है, जिनी मिंजो भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","कने मूसा दिया व्यवस्था च लिखया भी है; दो जणया दी गबाई मिली करी ठीक होंदी है। ");
INSERT INTO bht_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","इक तां मैं अपु अपणी गबाई दिन्दा है, कने दूजा मेरा पिता परमेश्वर मेरी गबाई दिन्दा है जिनी मिंजो भेजया है।” ");
INSERT INTO bht_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","उना यीशुऐ ला पुछया, तेरा पिता कुथु है? यीशुऐ जबाब दिता, “ना तुसां मिंजो जाणदे न, ना तुसां मेरे पिता परमेश्वर जो, अगर मिंजो जाणदे होदें तां मेरे पिता परमेश्वर जो भी जाणदे।” ");
INSERT INTO bht_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ऐ गल्लां उनी मंदरे दे अंगणे च उपदेश दिन्दे भंडार घरे च बोलियां, कने कुनी भी उसयो नी पकड़या; क्योंकि उदे मरणे दा बकत हले दीकर नी आया था। ");
INSERT INTO bht_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","यीशुऐ फिरी उना ने बोलया, “मैं चली जाणा है, कने तुसां मिंजो तोपणा है कने तुसां अपणे पाप माफ होयो बिना ही मरी जाणा। जिथू मैं जांदा है, ओथु तुसां नी आई सकदे न।” ");
INSERT INTO bht_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","इस पर यहूदी अगुवां बोलया, क्या इनी अपणे आपे जो मारी लेणा है, की ऐ बोला दा है, “जिथू मैं जांदा है ओथु तुसां नी आई सकदे न?” ");
INSERT INTO bht_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","यीशुऐ उना ने बोलया, “तुसां इस संसारे च पैदा होयो न, पर मैं स्वर्गे ला आया है, तुसां इस संसारे द न, मैं संसारे दा नी है। ");
INSERT INTO bht_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","इस तांई मैं तुसां ने बोलया, कि तुसां अपणे पापां माफ होयो बिना ही मरी जाणा है, अगर तुसां भरोसा नी करदे की मैं सै ही है जड़ा ओंणे बाला है, तां तुसां मरी जाणा, कने तुहाड़े पाप माफ नी किते जाणे न।” ");
INSERT INTO bht_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","यहूदी अगुवां उसला पुछया, “तू कुण है?” यीशुऐ उना ने बोलया, जालू ला मैं उपदेश देणा शुरू कितया है तालू ला मैं दसदा आया है की मैं सेई है। ");
INSERT INTO bht_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","मिंजो तुहाड़े न्याय दे बारे च तुसां जो मता कुछ बोलणा है, पर मिंजो भेजणे बाला सच्चा है। कने जड़ा मैं उसला सुणदा है, सै ही संसारे दे लोकां जो बोलदा है। ");
INSERT INTO bht_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","सै हले दीकर ऐ नी समझी सके थे की सांझो ने पिता परमेश्वर दे बारे च बोला दा है। ");
INSERT INTO bht_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","तालू यीशुऐ बोलया, “जालू तुसां मिंजो, माणुऐ दे पुत्रे जो उपर चढ़ांगे, जालू ला मैं उपदेश देणा शुरू कितया है तालू ला मैं दसदा आया है की मैं सेई है, कने अपणे आपे ला कुछ नी करदा है, पर जियां मेरे पिता परमेश्वरे मिंजो सिखया है, तियां ही ऐ गल्लां बोलदा है। ");
INSERT INTO bht_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","कने मिंजो भेजणे बाला मेरे सोगी है, उनी मिंजो किल्ला नी छडया; क्योंकि मैं हमेशा ला ही कम्म करदा है, जिस ने सै खुश होंदा है।” ");
INSERT INTO bht_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","मतयां लोकां जिना यीशु जो ऐ गल्लां बोलदे सुणया, उस पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","तालू यीशुऐ उना यहूदी लोकां ने जिना उस पर भरोसा कितया था, बोलया, “अगर तुसां मेरी गल्लां च बणी रेंगे, तां सच्ची मेरे चेले न। ");
INSERT INTO bht_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","तुसां सच्च जो जाणना, कने सच्च ने तुहांजो अजाद करणा।” ");
INSERT INTO bht_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","उना उसयो जबाब दिता, “असां तां अब्राहम दे बंशज न, कने कदी कुसदे गुलाम नी रे; फिरी तू कजो बोला दा, की तुसां अजाद होई जाणा?” ");
INSERT INTO bht_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","यीशुऐ उना जो जबाब दिता, “मैं तुसां ने सच्च-सच्च बोलदा है की जड़ा कोई पाप करा दा है सै पापे दा गुलाम है। ");
INSERT INTO bht_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","कने सेवक हमेशा घरे च नी रेंदा है; पर पुत्र हमेशा घरे च रेंदा है। ");
INSERT INTO bht_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","इस तांई अगर पुत्र तुहांजो अजाद करगा तां, तुसां सच्ची दे अजाद होणा है। ");
INSERT INTO bht_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","मैं जाणदा है की तुसां अब्राहम दे बंशज दे न; तमी मेरे उपदेशां दा पालन नी करणा, तांई तां तुसां मिंजो मारी देणा चांदे न। ");
INSERT INTO bht_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","मैं उना चिंजा जो दस्सा दा है जिना जो मैं दिखया है जालू मैं पिता परमेश्वरे सोगी था, कने तुसां सै ही करदे रेंदे न जड़ा तुसां अपणे पिता ला सुणाया है।” ");
INSERT INTO bht_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","उना उसयो जबाब दिता, “साड़ा पूर्वज तां अब्राहम है।” यीशुऐ उना ने बोलया, अगर तुसां अब्राहम दे बंशज होंदे, तां जड़ा अब्राहम करदा था सै कम्म तुसां भी करदे। ");
INSERT INTO bht_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","अब्राहमे जड़ा किता, सै करणे दिया बजाऐ तुसां मिंजो मारणे दी कोशिश करा दे न, जिनी तुहांजो सच्चा बचन सुणाया जड़ा परमेश्वरे ला सुणाया ऐसा तां अब्राहमे नी कितया था। ");
INSERT INTO bht_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","तुसां अपणे पिता सांई कम्म करदे न, उना उसयो बोलया, “असां व्यभिचारे ने नी जमयो न, साड़ा सिर्फ इक ही पिता है सै ही परमेश्वर है।” ");
INSERT INTO bht_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","यीशुऐ उना ने बोलया, “अगर परमेश्वर तुहाड़ा पिता होंदा, तां तुसां मिंजो ने प्यार रखदे; क्योंकि मैं परमेश्वरे दिया तरफा ला आया है; मैं अपणिया इच्छा ने नी आया है, उनी ही मिंजो भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","जड़ा मैं कुछ बोलदा है सै तुसां कजो नी समझदे न? इस तांई तुसां मेरे संदेश जो मनणे तांई मना करदे न। ");
INSERT INTO bht_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","तुसां अपणे पिता शैताने ला न, कने अपणे पिता दियां जरुरतां जो पूरा करणा चांदे न। सै तां शुरू ला ही हत्यारा है, कने सै कदी भी सच्चा नी था, क्योंकि सच्च उदे अंदर है ही नी: जालू सै जूठ बोलदा है, तां सै अपणे सभावे ने जूठ बोलदा है; क्योंकि सै जूठा है, बल्कि जूठ दा पिता है। ");
INSERT INTO bht_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","पर मैं सच्च बोलदा है, इस तांई तुसां मेरा भरोसा नी करदे? ");
INSERT INTO bht_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","तुसां चे कुण मिंजो पापी साबित करी सकदा है? अगर मैं सच्चा है, तां तुसां मिंजो पर भरोसा कनी करदे? ");
INSERT INTO bht_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","जड़ा कोई भी परमेश्वरे ने रिश्ता रखदा है, सै परमेश्वरे दियां गल्लां सुणदा है; कने तुसां इस तांई नी सुणदे क्योंकि तुहाड़ा परमेश्वरे सोगी कोई रिश्ता नी है।” ");
INSERT INTO bht_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ऐ सुणीकरी यहूदी अगुवां उसयो बोलया, “क्या असां ठीक नी बोलदे न, की तू सामरी है, कने तेरे अंदर बुरी आत्मा है?” ");
INSERT INTO bht_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","यीशुऐ जबाब दिता, “मिंजो च बुरी आत्मा नी है; पर मैं अपणे पिता परमेश्वर दा आदर करदा है, कने तुसां मेरा निरादर करदे न। ");
INSERT INTO bht_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","मैं अपणा आदर मान नी चांदा है, पर इक है जड़ा चांदा है मिंजो आदर मान मिल्ले, कने सै सेई है जड़ा न्याय भी करदा है। ");
INSERT INTO bht_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","मैं तुसां ने सच्च-सच्च बोलदा है, अगर कोई माणु मेरियां शिक्षा पर चलगा, तां उनी कदी नी मरणा है।” ");
INSERT INTO bht_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","यहूदी अगुवां उसयो बोलया, “हुण सांझो पता लगी गिया की तिजो अंदर बुरी आत्मा है: अब्राहम मरी गिया है, कने परमेश्वरे दा संदेश देणेबाले भी मरी गियो न कने तू बोलदा है, अगर कोई मेरे संदेश जो मनगा तां उनी अनन्तकाल दीकर मरणा नी है।” ");
INSERT INTO bht_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","साड़ा पूर्वज अब्राहम तां मरी गिया है, क्या तू उसला भी बडा है? कने परमेश्वरे दा संदेश देणेबाले भी मरी गियो न, तू अपणे आपे जो क्या समझदा है। ");
INSERT INTO bht_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","यीशुऐ जबाब दिता, “अगर मैं अपु अपणी तारीफ करें, तां मेरी तारीफ कुछ नी, पर जड़ा मिंजो आदर मान दिन्दा है, सै मेरा पिता परमेश्वर है, कने जिसयो तुसां बोलदे न, की सै तुहाड़ा परमेश्वर है। ");
INSERT INTO bht_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","कने तुसां तां उसयो नी जाणया, पर मैं उसयो जाणदा है, कने अगर मैं बोले की मैं उसयो नी जाणदा है, तां मैं तुहाड़े सांई जूठा बणना: पर मैं उसयो जाणदा कने उदे हुकम मनदा है। ");
INSERT INTO bht_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","तुहाड़ा पूर्वज अब्राहम मेरा दिन दिखणे दिया आसा च बड़ा मगन था; कने उनी दिखया कने खुश होया।” ");
INSERT INTO bht_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","यहूदी अगुवां उसयो बोलया, “हले दीकर तू पंजा सालां दा भी नी है, फिरी भी तू अब्राहम जो दिखया है?” ");
INSERT INTO bht_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","यीशुऐ उना ने बोलया, मैं तुसां ने सच्च-सच्च बोलदा है, अब्राहम पैदा होणे ला पेहले, मैं है। ");
INSERT INTO bht_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","तालू लोकां यीशुऐ जो मारणे तांई पथर चुके, पर यीशु लुकी करी मंदरे ला निकली गिया। ");
INSERT INTO bht_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","फिरी यीशुऐ जांदे बेले इक माणुऐ जो दिखया, जड़ा जमदा ही अन्ना था। ");
INSERT INTO bht_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","कने उदे चेलयां उसला पुछया, “गुरू जी, कुनी पाप कितया था की ऐ अन्ना जमया, इनी माणुऐ, या उदे माता पिता?” ");
INSERT INTO bht_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","यीशुऐ जबाब दिता, ना तां इनी पाप कितया था, ना तां इदे माता पिता: पर ऐ इस तांई अन्ना जमया, की परमेश्वरे दी शक्ति इदे च प्रगट होऐ। ");
INSERT INTO bht_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","जिनी मिंजो भेजया है; सांझो झट ही उदे दितयो कम्मा जो पूरा करणा है: सै रात ओंणे बाली है जिदे च कोई कम्म नी करी सकदा है। ");
INSERT INTO bht_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","जालू दीकर मैं संसारे च है, तालू दीकर संसारे दी लौ मैं है। ");
INSERT INTO bht_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ऐ बोली करी उनी जमिना पर थूक्या कने उसी थूके ने मिटी सेड़ी कने सेई मिटी उस अन्ने दिया हखी पर लगाई करी। ");
INSERT INTO bht_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","उसयो बोलया, “जा, कने अपणा मु शीलोह दे कुण्डे च धोई ले” (शीलोह दे कुण्डे दा मतलब है भेजया है) तां उनी जाई करी धोता, कने जालू सै घरे जो बापस ओणा लग्गा तां उसयो मिलणा लगी पिया। ");
INSERT INTO bht_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","तालू उदे पड़ोसी कने होर लोक जिना उसयो पेहले भीख मंगदे दिखया था, इक दुज्जे ने बोलणा लग्गे, “क्या ऐ सै ही नी है, जड़ा बेईकरी भीख मंगदा था?” ");
INSERT INTO bht_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","केईयां लोंका बोलया, ऐ सैई है, होरनी बोलया, नी, पर उदे सांई है उनी बोलया, “मैं सेई है जड़ा बेईकरी भीख मंगदा था।” ");
INSERT INTO bht_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","तां सै उसला पूछणा लग्गे, “तेरियां हखी दी लौ कियां बापस आई?” ");
INSERT INTO bht_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","उनी जबाब दिता, “यीशु नाऐ दे इकी माणुऐ मिट्टी सेड़ी, कने मेरियां हखी पर लगाई करी मिंजो बोलया, शीलोह दे कुण्ड च जाई करी मु धोई ले, मैं गिया कने धोई करी मिंजो मिलणा लगी पिया।” ");
INSERT INTO bht_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","उना उसयो पुछया, सै माणु कुथु है? उनी बोलया, “मैं नी जाणदा।” ");
INSERT INTO bht_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","लोक उस मांणुऐ जो जड़ा पेहले अन्ना था उसयो फरीसियाँ बाल लेई गे। ");
INSERT INTO bht_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","जिस दिने यीशुऐ मिट्टी सेड़ी करी उदियां हखी ठीक कितियां थियां सै सब्ते दा रोज था। ");
INSERT INTO bht_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","फिरी फरीसियां भी उसयो पुछया; तेरी हखी कियां ठीक होईयां? उनी उना जो बोलया, “उनी मेरी हखी पर मिट्टी लाई, फिरी मैं धोई लेई, कने हुण मिंजो मिलणा लगी पिया।” ");
INSERT INTO bht_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","इस पर केई फरीसी बोलणा लग्गे, “ऐ माणु परमेश्वरे दिया तरफा ला नी है, क्योंकि सै सब्ते दे रोजे जो नी मंनदा है।” होरनी बोलया, इस सांई पापी माणु इस तरीके ने चमत्कार कियां दस्सी सकदा है? इसा गल्ला जो लेईकरी उना च फुट पेई गेई। ");
INSERT INTO bht_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","उना उस अन्ने ने फिरी बोलया, उनी तेरियां हखी ठीक कितियां न, तू उदे बारे च क्या बोलदा है? उनी बोलया, “सै परमेश्वरे दा संदेश देणेबाला है।” ");
INSERT INTO bht_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","पर यहूदी अगुवां जो भरोसा नी होया की ऐ अन्ना था कने हुण दिखणा लग्गी गिया है जालू दीकर उदे माता पिता जो सदया जिदियां हखी ठीक होईयां थियां। ");
INSERT INTO bht_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","कने उना ला पुछया, “क्या ऐ तुहाड़ा पुत्र है, इसयो तुसां बोलदे थे की अन्ना जमया था? फिरी इसयो कियां मिलणा लगी पिया है?” ");
INSERT INTO bht_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","उदे माता पिता जबाब दिता, “असां तां जाणदे न की ऐ साड़ा पुत्र है, कने अन्ना जमया था। ");
INSERT INTO bht_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","पर असां ऐ नी जाणदे की हुण कियां करी इसयो मिलणा लगी पीया है; कने ना ऐ जाणदे की कुनी इसदियां हखी ठीक कितियां; सै अपणे जबाब देणे तांई काफी बडा है; उसी ला पूछी लिया; उसी ला पुच्छी लिया उनी अपणे बारे च अपु बोली देणा है।” ");
INSERT INTO bht_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ऐ गल्लां उदे माता पिता तां बोलियां क्योंकि सै यहूदी अगुवां ला डरदे थे; क्योंकि यहूदी अगुवे एका करी के बैठयो थे, की अगर कोई भरोसा करे की सै मसीह है, तां सै यहूदी जंज घर ला कडी देणा। ");
INSERT INTO bht_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","इसा बजा ने उदे माता पिता बोलया की सै सबालां दा जबाब देणे तांई बतेरा बडा है, उसला ही पूछी लिया। ");
INSERT INTO bht_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","तालू यहूदी अगुवां उस माणुऐ जो फिरी सदया जड़ा अन्ना था उसयो बोलया, “परमेश्वरे दे सामणे बायदा कर की तू सच्च बोलगा; असां तां जाणदे न की सै माणु पापी है।” ");
INSERT INTO bht_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","उनी जबाब दिता, “मैं नी जाणदा सै पापी है या नी: मैं तां बस इक गल्ल जाणदा है की मैं अन्ना था कने हुण दिखदा है।” ");
INSERT INTO bht_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","उना उसला फिरी पूछया, “उनी तेरे ने क्या किता? उनी तिजो कियां ठीक किता?” ");
INSERT INTO bht_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","उनी उना ने बोलया, “मैं तां तुसां ने बोली बैठया है, कने तुसां नी सुणाया; हुण दुई बरी कजो सुणना चांदा न? क्या तुसां भी उदे चेले बणना चांदे न?” ");
INSERT INTO bht_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","तालू उना उसयो बुरा भला बोलया कने बोलया, तू ही उदा चेला है; असां तां परमेश्वर दे संदेश देणेबाले मूसा दे चेले न। ");
INSERT INTO bht_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","असां जाणदे न की परमेश्वरे मूसा ने गल्लां कितियां न; पर इस माणुऐ जो नी जाणदे न की कुथु ला आया है। ");
INSERT INTO bht_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","उनी उना जो जबाब दिता, ऐ तां हेरानिया दी गल्ल है की तुसां नी जाणदे कुथु दा है पर तमी उनी मेरियां हखी ठीक करी दितियां। ");
INSERT INTO bht_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","असां जाणदे न की परमेश्वर पापियां दी नी सुणदा है पर अगर कोई परमेश्वरे दा भक्त हो, कने उदिया इच्छा पर चलदा है, तां सै उदी सुणदा है। ");
INSERT INTO bht_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","जालू ला इस संसारे जो बणाया है तालू ला ऐ कदी नी सुणाया, की कुनी भी जनमे दे अन्ने दियां हखी ठीक कितियो होन। ");
INSERT INTO bht_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","अगर ऐ माणु परमेश्वरे दिया तरफा ला नी होंदा, तां उनी कुछ भी नी करी सकणा था। ");
INSERT INTO bht_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","उना उसयो जबाब दिता, तू तां बिलकुल पापां च जमया है, तू क्या सांझो सिखा दा है? तालू उना उसयो यहूदी जंज घर ला बाहर कडी दिता। ");
INSERT INTO bht_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","यीशुऐ सुणया, की उना उसयो यहूदी जंज घरे ला बाहर कडी दितया है; कने जालू उसला मिलया तां बोलया, “क्या तू परमेश्वरे दे पुत्रे पर भरोसा करदा है?” ");
INSERT INTO bht_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","उनी जबाब दिता, “श्रीमान जी, मिंजो दस की ऐ परमेश्वरे दा पुत्र कुण है, ताकि मैं उस पर भरोसा करी सके?” ");
INSERT INTO bht_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","यीशुऐ उसला बोलया, मैं, “तू मिंजो पेहले भी दिखया है कने मैं ही सै परमेश्वरे दा पुत्र है, जड़ा हुण तिजो ने गल्लां करा दा है।” ");
INSERT INTO bht_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","उनी बोलया, “प्रभु जी, मैं तिजो पर भरोसा करदा है।” कने उसयो दण्डवत किता। ");
INSERT INTO bht_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","तालू यीशुऐ बोलया, “मैं इस संसारे च इस न्याय जो करणे तांई आया है: ताकि अन्ने लोकां जो मिलणा लग्गी पोणा कने जिना लोकां जो मिलदा है सै अन्ने होई जाणे।” ");
INSERT INTO bht_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","जड़े फरीसी उदे सोगी थे, उना ऐ गल्लां सुणीकरी उसला बोलया, “क्या तू बोला दा है की असां भी अन्ने न?” ");
INSERT INTO bht_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","यीशुऐ उना ने बोलया, अगर तुसां अन्ने होंदे तां पापी नी होणा था पर हुण बोलदे न, की सांझो मिलदा है, इस तांई तुहाड़े पाप माफ नी किते जाणे न। ");
INSERT INTO bht_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“मैं तुसां ने सच्च-सच्च बोलदा है, की अगर कोई भेडां दिया गुराला दे दरबाजे ला नी अंदर ओऐ, पर होर कुसी पासे ला चढ़ी करी अंदर ओऐ, सै चोर कने डाकू है। ");
INSERT INTO bht_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","पर जड़ा दरबाजे चे जांदा है सै भेडां दा पुआल है। ");
INSERT INTO bht_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","उदे तांई द्वारपाल दरबाजा खोली दिन्दा है, कने भेडां उदी अबाज पछेणदियां न, कने सै अपणियां भेडां जो ना लेई-लेईकरी सददा है कने बाहर लेई जांदा है। ");
INSERT INTO bht_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","कने जालू सै अपणिया सारियां भेडां जो बार कडी बोंदा है, तां उना दे अग्गे-अग्गे चलदा है, कने भेडां उदे पिच्छे-पिच्छे चली पोंदिया न; क्योंकि सै उदी अबाज पछेणदियां न। ");
INSERT INTO bht_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","पर सै होरसी दे पिच्छे नी जांदियां, पर उना ला नठदियां न, क्योंकि सै होरसी दी अबाज नी पछेणदियां न।” ");
INSERT INTO bht_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","यीशुऐ उना ने ऐ कहाणी बोली, पर सै नी समझे की ऐ बोलणे दा क्या मतलब है। ");
INSERT INTO bht_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","तालू यीशुऐ उना ने फिरी बोलया, मैं तुसां ने सच्च-सच्च बोलदा है, की भेडां दा मैं ही दरबाजा है जिदे चे भेडां अंदर ओंदियां न। ");
INSERT INTO bht_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","जितणे मिंजो ला पेहले आये; सै सारे चोर कने डाकू न, पर मेरियां भेडां उना दी नी सुणी। ");
INSERT INTO bht_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","मैं ही दरबाजा है; अगर कोई मिंजो चे अंदर जा तां परमेश्वरे उदा उद्धार करणा कने उनी अंदर बाहर ओंदे जांदे रेणा कने उसयो खाणे पिणे जो मिलदी रेंणी। ");
INSERT INTO bht_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","चोर सिर्फ भेडां जो चोरणे कने मारणे कने खत्म करणे तांई ओंदा है। पर मैं इस तांई आया की उना जो सच्चाई च जिन्दगी कने भरपूरी दी जिन्दगी मिल्ले। ");
INSERT INTO bht_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","खरा पुआल मैं है; खरा पुआल भेडां तांई अपणी जान देई दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","भाड़े पर रखयो होया मजदूर जालू सै भेड़िये जो ओंदे दिखणा तां उनी नठी जाणा। उनी भेडां जो छडी देणा क्योंकि सै उना दा पुहाल नी है कने भेडां उदियां नी न। इस तांई भेड़िया उना पर हमला करदा है कने झुण्ड जो बखेरी दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","सै इस तांई नठी जांदा है की सै भाड़े दा मजदूर है, कने उसयो भेडां दी चिंता नी है। ");
INSERT INTO bht_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","खरा पुआल मैं है, मैं अपणियां भेडां जो जाणदा है कने मेरियां अपणियां भेडां मिंजो जाणदियां न, ");
INSERT INTO bht_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","जियां पिता परमेश्वर मिंजो जाणदा है, कने मैं पिता परमेश्वरे जो जाणदा है। कने मैं भेडां तांई मरणे तांई तैयार है। ");
INSERT INTO bht_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","कने मेरियां होर भी भेडां न, जड़ियां इसा गुराला दियां नी न, मिंजो उना जो लोंणा भी जरूरी है, उना मेरी अबाज पछेणनी है; तां फिरी इक झुण्ड कने इक ही पुआल होंणा है। ");
INSERT INTO bht_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","मैं अपणिया मरजिया ने जान दिन्दा है, इस तांई पिता परमेश्वर मिंजो ने प्यार करदा है, ताकि मैं दोबारा जिन्दा होई जा। ");
INSERT INTO bht_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","कोई मेरिया जिन्दगिया जो मिंजो ला नी लेई सकदा है, इसयो मैं अपणिया इच्छा ने दिन्दा है। मिंजो अपणी जिंदगी देंणे दा भी हक है, कने उना जो फिरी बापस लेणे दा भी हक है: क्योंकि ऐ सेई हुकम है जड़ा मिंजो मेरे पिता परमेश्वरे ला मिलया है। ");
INSERT INTO bht_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","इना गल्लां दिया बजा ने यहूदी लोकां च फिरी फुट पेई गेई। ");
INSERT INTO bht_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","उना चे मते बोलणा लग्गे, इदे च बुरी आत्मा है, कने सै पागल है; इसदी मत सुंणा? ");
INSERT INTO bht_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","होरनी बोलया, ऐ गल्लां ऐसे माणुऐ दियां नी न जिदे च बुरी आत्मा हो: इक बुरी आत्मा कदी भी नी इक अन्ने माणुऐ दी हखी ठीक करी सकदी है? ");
INSERT INTO bht_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","यरूशलेम शेहर च यहूदी मंदरे दी स्थापना दा त्योहार था, कने सर्दियां दी रित थी। ");
INSERT INTO bht_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","यीशु मंदरे दे अंगणे च घुमा दा था, जिसयो लोक सुलैमान राजे दा ओसारा बोलदे न। ");
INSERT INTO bht_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","तालू यहूदी अगुवां उसयो घरोटी लिया कने पुछया, “तू सांझो बड़े लम्बे बकते दीकर दुबिधा च रखया है। हुण सांझो साफ-साफ दस। क्या तू मसीह है।” ");
INSERT INTO bht_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","यीशुऐ उना जो जबाब दिता, “मैं तुसां ने बोली दितया है, कने तुसां मेरा भरोसा करदे ही नी न, जड़े कम्म मैं अपणे पिता परमेश्वरे दे हके ने करदा है सै ही मेरे गबाह न। ");
INSERT INTO bht_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","पर तुसां इस तांई मेरा भरोसा नी करदे न क्योंकि तुसां मेरियां भेडां चे नी न। ");
INSERT INTO bht_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","मेरियां भेडां मेरी अबाज पछेणदियां न, कने मैं उना जो जाणदा है, कने सै मेरे पिच्छे-पिच्छे चलदियां न। ");
INSERT INTO bht_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","मैं उना जो हमेशा दी जिन्दगी दिन्दा है, कने उना दा कदी नाश नी होणा, कने कोई उना जो मेरे हथां ला नी खोई सकदा है। ");
INSERT INTO bht_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","मेरा पिता परमेश्वर, जिनी उना जो मिंजो दितया है, सबना ला बडा है, कने कोई उना जो पिता परमेश्वरे दे हथे ला खोई नी सकदा। ");
INSERT INTO bht_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","मैं कने पिता परमेश्वर इक ही न।” ");
INSERT INTO bht_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","यहूदी अगुवां उसयो मारणे तांई फिरी पथर चुके। ");
INSERT INTO bht_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","इस पर यीशुऐ उना ने बोलया, “मैं पिता परमेश्वरे दिया तरफा ला तुहांजो मते भले कम्म दसयो न, उना चे कुस कम्मे तांई तुसां मिंजो पथर मारा दे न?” ");
INSERT INTO bht_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहूदी अगुवां यीशुऐ जबाब दिता, “भले कम्म तांई असां तिजो पथर नी मारा दे न, पर परमेश्वरे दी निंदा करणे दिया बजा ने कने इस तांई की तू माणु होईकरी अपणे आपे जो परमेश्वरे बोलदा है।” ");
INSERT INTO bht_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","यीशुऐ उना जो जबाब दिता, क्या पबित्र शास्त्र च ऐसा नी लिखया है की परमेश्वरे अपणे लोकां दे अगुवां ने बोलया की, तुसां ईश्वर न? ");
INSERT INTO bht_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","तुसां जाणदे न की पबित्र शास्त्र च कुछ भी बदलया नी जाई सकदा। इस तांई अगर उदे लोकां दे अगुवां जो “इश्वर” बोलया गिया हो। ");
INSERT INTO bht_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","तां जालू मैं बोलदा है, मैं परमेश्वरे दा पुत्र है तां तुसां मिंजो कजो बोलदे न, “तू निंदा करा दा है।” मैं सै ही है जिसयो पिता परमेश्वरे लग कितया कने मिंजो संसार च भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","अगर मैं अपणे पिता दा कम्म नी करदा तां, तुसां मेरा भरोसा मत करा। ");
INSERT INTO bht_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","पर अगर मैं करदा है, तां चाऐ मेरा भरोसा ना भी करा, पर उना कम्मा दा तां भरोसा करा, तालू तुसां जो पता चलणा कने समझणा की पिता परमेश्वर मिंजो च रेंदा है, कने मैं पिता परमेश्वर च रेंदा है। ");
INSERT INTO bht_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","तालू उना फिरी यीशुऐ जो पकड़ने दी कोशिश किती पर सै उना दे हथे ला बची करी निकली गिया। ");
INSERT INTO bht_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","फिरी यीशु यरदने खड्डा दे पार उसा जगा पर चली गिया, जिथू यूहन्ना पेहले बपतिस्मा दिन्दा था, कने ओथु रिया। ");
INSERT INTO bht_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","कने मते लोक उदे बाल आई करी उसला बोलदे थे, “यूहन्ना तां कोई चमत्कार नी दसया, पर जड़ा कुछ यूहन्ना इदे बारे च बोला दा सै सारा सच्च था।” ");
INSERT INTO bht_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","कने ओथु मतयां उदे पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","बैतनिय्याह ग्रां च इक लाजर नाऐ दा माणु बीमार था। मरियम कने मार्था उदियां बेहणा थियां। ");
INSERT INTO bht_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ऐ सै ही मरियम थी जिना बादे च प्रभुऐ दे पैरा उपर इत्र नियोरी करी उदे पैरां जो अपणे बाला ने पुंजया था, उसा दा ही भाई लाजर बीमार था। ");
INSERT INTO bht_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","उसा दिया बेंहणा यीशुऐ जो बोली भेजया, “प्रभु जी, दिख, जिसयो तू प्यार करदा है, सै बीमार है।” ");
INSERT INTO bht_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ऐ सुणीकरी यीशुऐ बोलया, “ऐ बिमारी मौत ने नी मुकणी, पर परमेश्वरे दिया महिमा तांई है, ताकि उसला मिंजो, परमेश्वरे दे पुत्रे दी महिमा हो।” ");
INSERT INTO bht_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","कने यीशु मार्था कने उदी बेंहण कने लाजरे ने प्यार करदा था। ");
INSERT INTO bht_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","पर उनी सुणाया, की सै बीमार है, जिसा जगा सै था, ओथु दो रोज होर रुकी गिया। ");
INSERT INTO bht_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","फिरी दो दिन बाद उनी चेलयां ने बोलया, “ओआ, असां फिरी यहूदिया प्रदेश दे इलाके दे बैतनिय्याह शेहरे जो चलदे न।” ");
INSERT INTO bht_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","चेलयां उसयो बोलया, “गुरू जी, हुंणी तां यहूदी अगुवे तिजो पथर मारणा चांदे थे, क्या फिरी भी तू ओथु चलया है?” ");
INSERT INTO bht_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","यीशुऐ जबाब दिता, “क्या दिने दे बाहरा घंटे नी होंदे न? अगर कोई दिने चले, तां उसयो ठोकर नी लगदी, क्योंकि सै इस संसारे दी लौई ने मतलब की सूरजे दी लौई ने दिखदे न। ");
INSERT INTO bht_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","पर अगर कोई राती जो चले, तां उसयो ठोकर लगणी, क्योंकि तालू उदे च लौ नी है।” ");
INSERT INTO bht_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","इदे बाद यीशुऐ उना ने बोलया, “साड़ा मित्र लाजर सोई गिया है, पर मैं उसयो जगाणा चलया है।” ");
INSERT INTO bht_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","तालू चेलयां उसयो बोलया, “प्रभु जी, अगर सै सोई गिया है, तां उनी ठीक ठाक होई जाणा।” ");
INSERT INTO bht_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","यीशुऐ तां उदिया मौता दे बारे च बोलया था: पर सै समझे की उनी निद्रां ने सोई जाणे दे बारे च बोलया। ");
INSERT INTO bht_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तालू यीशुऐ उना ने साफ बोली दिता की, लाजर मरी गिया है। ");
INSERT INTO bht_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","कने मैं तुहाड़े फायदे तांई खुश है की मैं ओथु नी था जिसने तुसां भरोसा करन। पर हुण ओआ, असां उदे बाल चलदे न। ");
INSERT INTO bht_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तालू थोमा जिसयो दिदुमुस बोलदे न, अपणे सोगी बाले चेले ने बोलया, “ओआ, असां भी उदे सोगी मरणे तांई चलदे न।” ");
INSERT INTO bht_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","जालू यीशुऐ जो बैतनिय्याह ग्रां च आई करी ऐ पता चला की उसयो चार दिन पेहले ही कबरा च दफनाई दितया है। ");
INSERT INTO bht_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बैतनिय्याह ग्रां यरूशलेम शेहर दे नेड़े लगभग कोई तिन किलो मीटर था। ");
INSERT INTO bht_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","कने मते यहूदी लोक मार्था कने मरियम बाल उदे भाईऐ दे बारे च शान्ति देणे तांई आयो थे। ");
INSERT INTO bht_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","जालू मार्था यीशुऐ दे ओंणे दी खबर सुणीकरी यीशुऐ ने मिलणा गेई, पर मरियम घरे बेई रेई। ");
INSERT INTO bht_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मार्था यीशुऐ जो बोलया, “प्रभु जी, अगर तू ऐथू होंदा, तां मेरा भाई कदी नी मरदा। ");
INSERT INTO bht_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","कने हुण भी जाणदी है, की जड़ा कुछ तू परमेश्वरे ला मंगगा, परमेश्वरे तिजो देणा।” ");
INSERT INTO bht_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","यीशुऐ उसा जो बोलया, “तेरा भाई फिरी जिंदा होई जाणा।” ");
INSERT INTO bht_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मार्था उसयो बोलया, मैं जाणदी है, “न्याय दे रोजे जालू हर कोई जिन्दा होई जाणा तालू उनी भी जिन्दा होई जाणा।” ");
INSERT INTO bht_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","यीशुऐ उसा ने बोलया, “मैं सै है जड़ा मरयो लोकां जो जिन्दगी च बापस लोंदा है, जड़ा कोई मिंजो पर भरोसा करदा है सै अगर मरी भी जा तमी, उनी जी पोंणा। ");
INSERT INTO bht_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","कने जड़ा कोई मिंजो पर भरोसा करदा है सै जिन्दा है, कने उनी अनन्तकाल दीकर नी मरणा। मार्था तू क्या इसा गल्ला पर भरोसा करदी है?” ");
INSERT INTO bht_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","उनी उसयो बोलया, “हाँ, प्रभु जी, मैं भरोसा करी लिया है, की परमेश्वरे दा पुत्र मसीह जड़ा संसारे च ओंणे बाला था, सै तू ही है।” ");
INSERT INTO bht_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ऐ बोली करी सै चली गेई, कने अपणी बेंहण मरियम जो होले करी सदीकरी बोलया, “गुरू ऐथू ही है, कने तिजो सदा दा है।” ");
INSERT INTO bht_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","सै सुणदे ही झट उठी करी उदे बाल आई। ");
INSERT INTO bht_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(यीशु हले दीकर भी ग्रांऐ ला बाहर ही था, पर उसा ही जगा च था जिथू मार्था उसला मिल्ली थी)। ");
INSERT INTO bht_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","तालू जड़े यहूदी लोक मरियम सोगी उसा दे घरे थे, कने उसा जो दिलासा देदे थे, कने दिखया की मरियम झट उठी करी बाहर चली गेई। इस तांई सै उसा दे पिच्छे-पिच्छे गे, ऐ सै समझीकरी की सै कबरा पर रोंणे तांई जा दी है। ");
INSERT INTO bht_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","जालू मरियम ओथु पुज्जी जिथू यीशु था, तां उसयो दिखदे ही उदे पैरां च पेईकरी बोलया, “प्रभु जी, अगर तू ऐथू होंदा तां मेरा भाई नी मरदा।” ");
INSERT INTO bht_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","जालू यीशुऐ उसा जो कने उसा सोगी आयो यहूदी लोकां जो रोंदे दिखया, तां यीशुऐ बड़ा ही दुखी होईकरी उना ला पुछया, ");
INSERT INTO bht_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","कने बोलया, तुसां उसयो कुथु दफनाया है? उना उसयो बोलया, “प्रभु जी, चली करी दिखी ले।” ");
INSERT INTO bht_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","यीशुऐ दियां हखी चे आंसू निकलना लग्गे। ");
INSERT INTO bht_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","तालू यहूदी लोक बोलणा लग्गे, “दिखा, सै उसने कदेया प्यार रखदा था।” ");
INSERT INTO bht_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","पर उना चे कितणे ही बोलया की, “इनी तां उस अन्ने दियां हखी ठीक कितियां न, क्या ऐ लाजरे जो मरणे ला नी बचाई सकदा था?” ");
INSERT INTO bht_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","यीशु मने च बड़ा ही दुखी होया कने कबरा पर आया, सै इक गुफा थी, कने गुफा दे मुऐ पर इक पथर रखया होया था। ");
INSERT INTO bht_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","यीशुऐ बोलया, “पथरे जो हटा।” उस मरयो दी बेंहण मार्था बोलणा लग्गी, “प्रभु जी, उदे चे तां हुण मुस्क ओआ दी है, क्योंकि उसयो मरयो चार रोज होई गियो न।” ");
INSERT INTO bht_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","यीशुऐ उस जो बोलया, “क्या मैं तिजो ने बोलया नी था की अगर तू मिंजो पर भरोसा करगी तां तू परमेश्वरे दी महिमा जो दिखगी।” ");
INSERT INTO bht_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तालू उना सै पथर हटाया, फिरी यीशुऐ स्वर्ग पासे दिखीकरी के बोलया, “पिता परमेश्वर जी, मैं धन्याबाद करदा है की तू मेरी सुणी लेई है।” ");
INSERT INTO bht_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","पर जड़ी भीड़ अखे बखे खड़ोतियो है, उना दिया बजा ने यीशुऐ जोरे ने बोलया, “मैं जाणदा है, की तू हमेशा मेरी सुणदा है, जिसने की सै भरोसा करन, की तू मिंजो भेजया है।” ");
INSERT INTO bht_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ऐ बोली करी उनी जोरे ने पुकारया, “हे लाजर बाहर निकली आ।” ");
INSERT INTO bht_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","जड़ा मरी गिया था, सै बाहर आया, कने उदा सारा शरीर पट्टियाँ च कने मु कपड़े च लपेटया होया था कने यीशुऐ उना जो बोलया, “इसयो खोली करी जाणा दिया।” ");
INSERT INTO bht_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","तालू जड़े यहूदी लोक मरियमा दे सोगी आयो थे, उना उदा ऐ कम्म दिखया कने उना चे मतयां उदे पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","उना चे कितणयां ही फरीसियां बाल जाई करी यीशुऐ दे कम्मा दी खबर दिती। ");
INSERT INTO bht_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","इस पर बड्डे याजकां कने फरीसियां दी महासभा दे लोंका जो गठेरी करी बोलया, “असां क्या करगे? ऐ माणु तां बड़े चमत्कार दसदा है। ");
INSERT INTO bht_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","अगर असां इसयो हुण भी नी रोकदे न, तां सारयां उस पर भरोसा करी लेंणा की सै ही मसीहा है, कने रोमी लोकां आई करी साड़े मंदरे कने देशे पर कब्जा करी लेंणा।” ");
INSERT INTO bht_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","तालू उना दिया सभा चे कैफा नाऐ दा इक माणु जड़ा उस साले दा महायाजक था, उनी बोलया, “तुसां कुछ भी नी जाणदे; ");
INSERT INTO bht_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","कने ना ऐ समझदे न, तुहाड़े तांई ऐ ठीक है, की साड़े लोकां तांई इक माणु मरे, नी की सारे इस्राएल देशे दे लोकां दा नाश होई जा।” ");
INSERT INTO bht_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ऐ गल्ल उनी अपणे आपे ला नी बोली, पर उस साले दे महायाजक दे रुपे च, उनी ऐ भविष्यवाणी किती, की यीशुऐ पुरे इस्राएल देशे तांई मरणा। ");
INSERT INTO bht_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","कने ना सिर्फ इना तांई ही नी। पर उनी परमेश्वरे दी होर ओलादी तांई भी मरणा जड़े इस संसारे च बिखरयो न, ताकि उना जो गठेरी सके। ");
INSERT INTO bht_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","यहूदी अगुवे उस रोजे ला ही उसयो मारने दी सलाह करणा लग्गी पे। ");
INSERT INTO bht_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","इसा साजिशा दिया बजा ने यीशुऐ यहूदियां दे बिच सरेआम घुमणा बंद करी दिता; यीशु ओथु ला सुनसान जगा दे नेड़े बाले प्रदेश दे इफ्राईम नाऐ दे इकी शेहरे जो चली गिया, कने अपणे चेलयाँ सोगी ओथु ही रेंणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","कने यहूदिया दे फसह दे त्योहारे दा बकत नेड़े था, कने मते लोक फसह ला पेहले यरूशलेम शेहर जो गे ताकि मंदरे च अपणे आपे जो शुद्ध करन। ");
INSERT INTO bht_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","कने यीशुऐ जो तोपदे कने मंदरे च खड़ोई करी अपु चे बोलणा लग्गे, “तुसां क्या समझदे न? क्या सै त्योहारे च नी ओंगा?” ");
INSERT INTO bht_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","कने बड्डे याजकां कने फरीसियां ऐ हुकम दितया था, की अगर कुस्यो पता लग्गे की यीशु कुथु है तां दसनयो, ताकि उसयो गिरफ्तार करी सकन। ");
INSERT INTO bht_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","फिरी यीशु फसह दे त्योहारे ला छे रोज पेहले बैतनिय्याह ग्रां च आया, जिथू लाजर जो मरयां चे जिन्दा किता था। ");
INSERT INTO bht_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ओथु उना उदे तांई धाम तैयार किती, कने यीशुऐ जो आदर मान देणे तांई मार्था सेबा करा दी थी, कने लाजर भी उना चे इक था, जड़े उदे सोगी रोटी खांणे तांई बैठयो थे। ");
INSERT INTO bht_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","तालू मरियमा जटामासी दा अधा सेर मेंहगा इत्र लेईकरी यीशुऐ दे पैरां पर नियोरया, कने अपणे बालां ने उदे पैर पूंजे, कने इत्रे दिया खुशबुआ ने सारा घर सुगन्धित होई गिया। ");
INSERT INTO bht_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","पर उदे चेलयाँ चे यहूदा इस्करियोती नाऐ दा इक चेला था जड़ा उसयो पकड़वाणा चांदा था, बोलणा लग्गा, ");
INSERT INTO bht_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ऐ इत्र तिनसो दीनारां च बेची करी गरीबां जो कनी देई दिता?” ");
INSERT INTO bht_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","उनी ऐ गल्ल इस तांई नी बोली की, की उसयो गरीबां दी चिंता थी, पर इस तांई की सै चोर था कने उदे बाल उना दे पैसयां दी थेली रेंदी थी, कने उसा च कोई कुछ पांदे थे, सै कडी लेंदा था। ");
INSERT INTO bht_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","यीशुऐ बोलया, “इसा जो तंग मत करा, इना बकत ला पहले मिंजो दफनाणे दी तैयारी तांई ऐ करा दी है। ");
INSERT INTO bht_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","गरीबां तां तुहाड़े सोगी हमेशा रेंणा है, पर मैं तुहाड़े सोगी हमेशा नी रेंणा।” ");
INSERT INTO bht_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","जालू लोकां सुणया की यीशु ओथु था तां तालू लोकां दी बड़ी भीड़ ओथु आई। सै सिर्फ यीशु जो ही नी पर लाजर जो भी दिखणा आयो थे जिसयो उनी मरयां चे जिन्दा कितया था। ");
INSERT INTO bht_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","तालू बड्डे याजकां लाजरे जो भी मारणे दी योजना बणाई। ");
INSERT INTO bht_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","क्योंकि उदिया बजा ने मते लोक उना जो नी अपनांदे थे, क्योंकि उना यीशुऐ पर भरोसा कितया। ");
INSERT INTO bht_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","दुज्जे दिने मतयां लोंका जड़े त्योहरे च आयो थे, ऐ सुणीकरी, की यीशु यरूशलेम शेहर च ओआ दा है। ");
INSERT INTO bht_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","इस तांई उना खजूरी दियां डालियाँ लियां, कने उसला मिलणे तांई निकले, कने चिलाणा लग्गे, “होशाना। इस्राएले दा राजा धन्य हो, जड़ा प्रभु दे नाऐ ने ओंदा है।” ");
INSERT INTO bht_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","जालू यीशुऐ जो इक गधे दा बच्चा मिल्ला तां सै उस पर बैठी करी यरूशलेम शेहर च आया, ऐ तियां ही होया जियां की पबित्र शास्त्र च लिखया है। ");
INSERT INTO bht_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“हे यरूशलेम शेहर दे लोकों, मत डरा; दिख तेरा राजा गधे दे बच्चे च सवार होईकरी ओआ दा है।” ");
INSERT INTO bht_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","यीशुऐ दे चेले, ऐ गल्लां पेहले नी समझे थे; पर जालू यीशुऐ दी महिमा प्रगट होई, तां उना जो याद आया, की जड़ा कुछ भी यीशुऐ ने होया सै ठीक तियां ही होया जियां की पबित्र शास्त्र च लिखया था; कने लोंका उदे कने ऐदिया व्यवहार कितया था। ");
INSERT INTO bht_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","तालू भिड़ा दे लोकां जड़े उस बेले यीशुऐ सोगी थे, सै दुज्जे लोकां जो दसणा लग्गे की उनी लाजरे जो कबरा ला सदीकरी, उसयो जिन्दा करी दिता। ");
INSERT INTO bht_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","मते लोक यीशुऐ ने मिलणे तांई आऐ, क्योंकि उना इस चमत्कार दे बारे च सुणाया था। ");
INSERT INTO bht_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","तालू फरीसियां अपु चे बोलया, “सोचा असां कुछ नी करी सकदे न, दिखा, संसार च हर कोई उदे पिच्छे होई चलया है।” ");
INSERT INTO bht_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ओथु कुछ यूनानी लोक थे जड़े फसह दे त्योहारे बेले भक्ति करणे तांई यरूशलेम शेहर च आयो थे। ");
INSERT INTO bht_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","उना गलील प्रदेश दे बैतसैदा शेहरे दे रेणेबाले फिलिप्पुस दे बाल आई करी उसला बिनती किती, “श्रीमान असां यीशुऐ ने मिलणा चांदे न।” ");
INSERT INTO bht_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","फिलिप्पुसे आई करी अन्द्रियास ने बोलया; तालू अन्द्रियास कने फिलिप्पुसे दोनो जाई करी यीशुऐ जो बोलया। ");
INSERT INTO bht_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","इस पर यीशुऐ उना जो बोलया, सै बकत आई गिया है, की मेरी, माणुऐ दे पुत्रे दी महिमा हो। ");
INSERT INTO bht_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","मैं तुसां ने सच्च-सच्च बोलदा है, की जालू दीकर कणका दा दाणा जमिना च पेईकरी मरी नी जांदा है, सै किला ही रेंदा है पर जालू मरी जांदा है, तां मते फल दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","जड़ा अपणे प्राणा ने प्यार करदा है, सै उना जो गबाई दिन्दा है; पर जड़ा इस संसारे च अपणे प्राणा जो प्यार नी करदा है; तां उनी हमेशा दिया जिन्दगिया तांई उदी रक्षा करणी है। ");
INSERT INTO bht_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","अगर कोई मेरी सेबा करे, तां मेरा चेला बणे; कने जिथू मैं है ओथु मेरे सेवके भी होणा; अगर कोई मेरी सेबा करे, तां पिता परमेश्वरे उदा आदर करणा। ");
INSERT INTO bht_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","हुंण मैं बड़ा बेचेन होआ दा है। इस तांई मैं क्या बोलें? पिता जी, मिंजो इसा दुखे दिया घड़िया ला बचाई ले? पर मैं संसार च इस तांई आया की दुख झेले कने मरी जां। ");
INSERT INTO bht_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","हे पिता परमेश्वर तू प्रगट कर की तू कितणा महिमामय है। तालू ऐ आकाशवाणी होई, “मैं प्रगट कितया है की मैं कितणा महिमा बाला है कने मैं ऐ फिरी प्रगट करगा।” ");
INSERT INTO bht_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","तालू सै लोक जड़े खड़ोई करी अबाज सुंणा दे थे, उना बोलया, की बदल गरजया, कने होरनी बोलया, “कोई स्वर्गदूत उसने बोलया।” ");
INSERT INTO bht_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","इसी पर यीशुऐ बोलया, “ऐ अबाज तुहाड़े भले तांई थी, मेरे तांई नी है। ");
INSERT INTO bht_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","हुण सै बकत है जालू परमेश्वरे संसारे दे लोकां दा न्याय करणा, कने हुण सै बकत है जालू यीशुऐ इस संसारे दे सरदार शैताने दी शक्ति जो खत्म करणा। ");
INSERT INTO bht_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","कने अगर मैं धरतिया ला उपर चढ़ाया जांगा, तां सारयां जो अपणे बाल लेई ओणा।” ");
INSERT INTO bht_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","इयां बोली करी उनी ऐ प्रगट करी दिता, की सै कियां मरणे बाला था। ");
INSERT INTO bht_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","इसा पर लोंका उसला बोलया, “असां पबित्र शास्त्र दी ऐ गल्ल सुणियो है, की मसीहे हमेशा जिन्दा रेंणा है, फिरी तू कजो बोला दा है, की माणुऐ दे पुत्रे जो उच्चे पर चड़ाणा जरूरी है? ऐ माणुऐ दा पुत्र कुण है?” ");
INSERT INTO bht_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","यीशुऐ उना ने बोलया, “(लौ) हुण थोड़िया देरा दीकर तुहाड़े बिच है, जालू दीकर लौ तुहाड़े सोगी है तालू दीकर चली रिया; इयां ना होए की नेहेरा तुहांजो घेरी ना ले; जड़ा नेहरे च चलदा है उसयो नी पता होंदा की कुथयो चलया है। ");
INSERT INTO bht_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","जालू दीकर लौ तुहाड़े सोगी है, लौ पर भरोसा करा की तुसां लौ दी ओलाद बणन।” ऐ गल्लां बोली करी यीशु चली गिया कने अपणे आपे जो उना ला लुकाई रखया। ");
INSERT INTO bht_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","कने यीशुऐ उना दे सामणे इतणे चमत्कार दस्से, तमी उना उदे पर भरोसा नी किता; ");
INSERT INTO bht_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ऐ इस तांई होया ताकि जड़ा यशायाह परमेश्वरे दा संदेश देणेबाले बोलया था सै सच्च होई जा; “प्रभु जी, साड़े संदेश पर कुनी भरोसा किता है? कने परमेश्वर दी पराक्रमी शक्ति कुदे पर प्रगट होई?” ");
INSERT INTO bht_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","इसा बजा ने सै भरोसा नी करी सके, क्योंकि यशायाहे फिरी बोलया: ");
INSERT INTO bht_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","परमेश्वरे उना दी हखी अन्निया करी दितियां ताकि सै दिखी नी सकन, कने उना दे दिमाग बंद करी दिते ताकि सै समझी नी सकन। नितां उना मिंजो पर भरोसा करी लेणा कने मैं उना जो ठीक करी दिन्दा। ");
INSERT INTO bht_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यशायाहे ऐ गल्लां इस तांई बोलियां, की उनी बकते ला पेहले उदी महिमा दिखी, कने उदे बारे च गल्लां कितियां। ");
INSERT INTO bht_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","मते अगुवां भी उदे पर भरोसा किता, पर फरीसियां दिया बजा ने सबना सामणे नी मंनदे थे, इस डरे ने नी की उना जो यहूदी जंज घर ला कडी दिंगे। ");
INSERT INTO bht_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","क्योंकि उना जो परमेश्वरे दी तारीफ़ ला, माणुऐ दी तारीफ़ जादा प्यारी लगदी थी। ");
INSERT INTO bht_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","यीशुऐ भिड़ा जो पुकारी करी बोलया, “जड़ा मेरे पर भरोसा करदा है, सै सिर्फ मिंजो पर नी पर मिंजो भेजणे बाले परमेश्वरे पर भरोसा करदा है। ");
INSERT INTO bht_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","कने जड़ा मिंजो दिखदा है, सै मिंजो भेजणे बाले परमेश्वरे जो दिखदा है। ");
INSERT INTO bht_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","मैं संसारे च इक लौ बणी करी आया है ताकि जड़ा मिंजो पर भरोसा करगा सै कदी नेहरे च नी रेंगा। ");
INSERT INTO bht_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","अगर कोई मेरियां गल्लां सुणीकरी उना दा पालन नी करे, तां मैं उसयो दोषी नी बोलणा है, क्योंकि मैं संसारे दे लोकां जो दोषी ठहराणे तांई नी आया, पर संसारे दा उद्धार करणे तांई आया है।” ");
INSERT INTO bht_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","जड़ा मिंजो तुच्छ समझदा है कने मेरियां गल्लां जो नी मंनदा है, उना दा न्याय करणे बाला तां इक ही है, मतलब की जड़ा बचन मैं बोलया है, उनी उसयो आखरी दिना च दोषी बणाणा। ");
INSERT INTO bht_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","क्योंकि मैं अपणे हक ने ऐ गल्लां नी कितियां न, पर पिता परमेश्वर जिनी मिंजो भेजया है उनी मिंजो हुकम दितया है की क्या-क्या बोलें? ");
INSERT INTO bht_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","कने मैं जाणदा है, की उदे हुक्मा जो मनणा हमेशा दिया जिन्दगिया दा रस्ता है, इस तांई मैं तुसां जो सेई बोलदा है जड़ा पिता परमेश्वर मिंजो बोलदा है। ");
INSERT INTO bht_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","फसह दे त्योहरे ला पेहले जालू यीशुऐ जाणी लिया, की मेरा सै बकत आई गिया है की मैं संसारे जो छडी करी अपणे पिता परमेश्वर बाल बापस चली जां, यीशु अपणे चेलयां सोगी हमेशा प्यार करदा रिया, जड़े संसार च यीशुऐ सोगी थे, जदिया प्यार सै करदा था, आखरी दीकर सियुदा ही प्यार रखदा रिया। ");
INSERT INTO bht_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","यीशु कने उदे चेले राती दा खाणा खा दे थे। शैताने पेहले ही यीशुऐ जो धोखा देणे तांई शमौन दे पुत्र यहूदा इस्करियोती दे मने च ऐ पाई दितया था, की उसयो पकड़वाई दे। ");
INSERT INTO bht_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","जालू यीशु ऐ जाणदा था की पिता परमेश्वरे मिंजो हर चिजा पर हक दितया है कने मैं परमेश्वरे दे बखे ला आया है, कने परमेश्वरे बाल बापस जांणा है। ");
INSERT INTO bht_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","खांणा खांदे बेले उठी करी यीशुऐ अपणे बाहरी कपड़े खोली दिते, कने अंगोछा लेईकरी अपणा लक्के च बन्नी लिया। ");
INSERT INTO bht_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तालू भांडे च पांणी लेईकरी चेलयां दे पैर धोई करी कने जड़ा अंगोछा लक्के च लपेटया था उसला पुंजणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","जालू यीशु शमौन पतरस दे बखे आया तालू पतरसे उसयो बोलया, “प्रभु जी, तू कजो मेरे पैरां धोणा लगया है?” ");
INSERT INTO bht_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","यीशुऐ उसयो जबाब दिता, “जड़ा मैं करदा है, तू हुण इदा मतलब नी जाणदा है, पर कुछ बकते बाद जाणना है।” ");
INSERT INTO bht_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पतरसे उसयो बोलया, मैं तुसां जो अपणे पैरां जो कदी नी धोणा देणा। ऐ सुणीकरी यीशुऐ उसयो बोलया, “अगर तू मिंजो अपणे पैर नी धोणे नी दिते, तां तू मेरा चेला नी है।” ");
INSERT INTO bht_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","शमौन पतरसे उसयो बोलया, “प्रभु जी, तां मेरे पैर ही नी बल्कि हथ कने सर भी धोई दे।” ");
INSERT INTO bht_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","यीशुऐ उसयो बोलया, “इक माणु जड़ा नोहोई बैठया है, सै बिलकुल साफ है, उसयो सिर्फ अपणे पैरा जो धोंणे दी जरूरत है। कने तुसां सारे शुद्ध न सिर्फ इकी जो छड्डी करी।” ");
INSERT INTO bht_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","सै तां अपयों पकड़ाणे बाले जो जाणदा था तांई तां उनी बोलया, “तुसां सारे दे सारे शुद्ध नी न।” ");
INSERT INTO bht_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","जालू यीशु उना दे पैरां जो धोई बैठा तां सै अपणे बाहरे बाले कपड़े पाई करी फिरी बेई गिया कने उना ने बोलणा लग्गा, “क्या तुसां समझे की मैं तुहाड़े सोगी क्या कितया है? ");
INSERT INTO bht_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","तुसां मिंजो गुरू, कने प्रभु, कने ठीक ही बोलदे न, क्योंकि मैं तुहाड़ा गुरू कने प्रभु है। ");
INSERT INTO bht_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","अगर मैं प्रभु कने गुरू होईकरी तुहाड़े पैर धोते, तां तुहांजो भी नम्र होईकरी इक दुज्जे दे पैर धोई करी मिंजो ला सिखणा चाईदा। ");
INSERT INTO bht_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","क्योंकि मैं तुहांजो इक नमूना दस्सी दितया है, की जियां मैं तुहाड़े सोगी किता, तुसां भी तियां ही करा। ");
INSERT INTO bht_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","मैं तुसां ने सच्च-सच्च बोलदा है, नोकर अपणे मालिके ला बडा नी होंदा, कने ना भेजया होया अपणे भेजणे बाले ला बड्डा होंदा। ");
INSERT INTO bht_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","हुण तां तुसां इना गल्लां जो जाणदे न, तां इना जो करा ताकि तुसां भी धन्य होन। ");
INSERT INTO bht_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","मैं तुसां सबना दे बारे च नी बोला दा है: जिना जो मैं चुणयां है, उना जो मैं जाणदा है: पर ऐ इस तांई होआ दा है ताकि पबित्र शास्त्रां च जड़ा लिखया है सै पूरा हो, जिनी मेरे सोगी रोटी खादी, उनी मिंजो धोखा दिता है। ");
INSERT INTO bht_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","हुण मैं तुहांजो उदे होणे ला पेहले दसी दिन्दा है ताकि जालू होई जांगा तां तुसां भरोसा करनयो की मैं सेई है। ");
INSERT INTO bht_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","मैं तुसां ने सच्च-सच्च बोलदा है, की जड़ा मेरे भेजयां जो अपनांदा है, सै मिंजो भी अपनांदा है, कने जड़ा मिंजो अपनांदा है, सै मेरे भेजणे बाले जो भी अपनांदा है।” ");
INSERT INTO bht_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ऐ गल्लां बोलणे बाद यीशु बड़ा ही दुखी होया कने अपणे चेलयां जो दसया, “मैं तुसां ने सच्च-सच्च बोलदा है, की तुसां चे इकी जणे मिंजो पकड़ाणा है।” ");
INSERT INTO bht_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","चेले ऐ शक करदे होऐ, इकी दुऐ पासे दिखणा लग्गे, ऐ कुसदे बारे च बोला दा है। ");
INSERT INTO bht_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","उदे चेलयां चे इक जिसने यीशु प्यार रखदा था, यीशुऐ दे बखे बैठया था। ");
INSERT INTO bht_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","तालू शमौन पतरसे उदे पासे इशारा करी के पुछया, “दसी दे तां, सै कुसदे बारे च बोला दा है?” ");
INSERT INTO bht_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","तालू उनी भी यीशुऐ दे बखे जाई करी पुछया, “प्रभु जी, सै कुण है?” ");
INSERT INTO bht_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","यीशुऐ जबाब दिता, “जिसयो मैं ऐ रोटिया दा टुकड़ा चटनिया च डोबी करी दिंगा, सै ही है।” कने उनी टुकड़ा चटनिया च डोबी करी शमौने दे पुत्र यहूदा इस्करियोती जो दिता। ");
INSERT INTO bht_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","कने जियां ही यहूदा टुकड़ा खादा, यीशुऐ उसयो बोलया, “जड़ा तू हुण करणा जा दा है, सै झट कर, तालू ही शैतान उदे च बड़ी गिया। ");
INSERT INTO bht_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","खाणा खाणे बालयां चे बाकी कुसियो भी पता नी था की यीशुऐ उसयो ऐसा कजो बोलया। ");
INSERT INTO bht_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","यहूदा बाल पैसयां दी थेली रेंदी थी, इस तांई कुनी-कुनी समझया, की यीशु उसयो बोला दा है, की जड़ा कुछ सांझो त्योहारे तांई चाईदा सै खरीदी ले, या गरीबां जो कुछ दे। ");
INSERT INTO bht_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","तालू सै रोटी दे टुकड़े जो खाई करी झट बाहरे जो चली गिया, कने राती दा बकत था। ");
INSERT INTO bht_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","जालू सै बाहर चली गिया तां यीशुऐ बोलया, हुण मेरी, माणुऐ दे पुत्रे दी महिमा होई, कने परमेश्वरे दी महिमा मिंजो च होई; ");
INSERT INTO bht_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","कने परमेश्वरे अपणे पुत्रे दी महिमा करणी, कने तोल्ली ही करणी है। ");
INSERT INTO bht_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","हे प्यारे बच्चो, मैं होर थोड़ी देर तुहाड़े बखे है; फिरी तुसां मिंजो तोपणा, कने जियां मैं यहूदियाँ जो बोलया, जिथू मैं जांणा, ओथु तुसां नी आई सकदे न, तियां ही मैं हुण तुहांजो भी बोलदा है। ");
INSERT INTO bht_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","मैं तुहांजो इक नौआं हुकम दिन्दा है, इक दुज्जे ने तियां ही प्यार करा: जियां मैं तुसां ने प्यार करदा है, तियां ही तुसां भी इक दुज्जे ने प्यार करा।” ");
INSERT INTO bht_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","अगर तुसां इक दुज्जे ने प्यार करगे, तां हर कुसी जो पता चलणा की तुसां मेरे चेले न। ");
INSERT INTO bht_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","शमौन पतरसे उसयो बोलया, “प्रभु जी, तू कुथु जांणा है?” यीशुऐ जबाब दिता, जिथू मैं जांणा है, ओथु तू मेरे पिच्छे नी आई सकदा? पर बादे च तुसां मेरे पिच्छे ओणा। ");
INSERT INTO bht_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पतरसे उसयो बोलया, “प्रभु जी, हुण मैं तेरे पिच्छे कनी आई सकदा है? मैं तां तेरे तांई अपणी जान देणे तांई तैयार है।” ");
INSERT INTO bht_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","यीशुऐ जबाब दिता, क्या तू मेरे तांई मरणा है? मैं तिजो ने सच्च-सच्च बोलदा है की मुर्गे जो बांग देणे ला पेहले तू मिंजो तिन्न बरी बोलणा की तू मिंजो नी जाणदा। ");
INSERT INTO bht_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“तुहाड़ा मन दुखी ना हो, तुसां परमेश्वरे पर भरोसा रखा कने मिंजो पर भी भरोसा रखा। ");
INSERT INTO bht_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","मेरे पिता परमेश्वर दे घरे रेहणे दियां मतियां जगा न, अगर नी हुंदियां, तां मैं तुसां ने बोली दिन्दा क्योंकि मैं तुहाड़े तांई जगा तैयार करणा जांदा है। ");
INSERT INTO bht_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","मेरे जाणे कने तैयारी करणे बाद, तां मैं फिरी आई करी तुहांजो अपणे सोगी लेई जांगा, ताकि जिथू मैं रें ओथु ही तुसां भी रेन। ");
INSERT INTO bht_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","उसा जगा दा रस्ता जिथू मैं जाणा है ओथु दा रस्ता तुसां जाणदे न।” ");
INSERT INTO bht_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमे उसला बोलया, “प्रभु जी, सांझो नी पता तू कुथु जाणा है, तां सांझो रस्ता कियां पता होंणा?” ");
INSERT INTO bht_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","यीशुऐ उना जो बोलया, “रस्ता कने सचाई कने जड़ा जिन्दगी दिन्दा है सै मैं ही है, मेरे बिना कोई भी पिता परमेश्वरे बाल नी पुज्जी सकदा है। ");
INSERT INTO bht_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","अगर तुसां मिंजो जाणया होंदा, तां मेरे पिता परमेश्वरे जो भी जाणदे, कने हुण उसयो जाणदे भी हेन, कने उसयो दिखया भी है।” ");
INSERT INTO bht_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिप्पुसे उसला बोलया, “प्रभु जी, पिता परमेश्वर दे दर्शण करवाई दे: इतणा ही साड़े तांई काफी है।” ");
INSERT INTO bht_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","यीशुऐ उसयो बोलया, हे फिलिप्पुस, मैं इतणे रोजां ला तुहाड़े सोगी है, क्या तू मिंजो नी जाणदा? जिनी मिंजो दिखया है उनी पिता परमेश्वर जो भी दिखया है: तू कजो बोला दा की पिता परमेश्वर दे दर्शण करवाई दे? ");
INSERT INTO bht_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","क्या तू भरोसा नी करदा है, की मैं पिता परमेश्वर च है, कने पिता परमेश्वर मिंजो च है। ऐ गल्लां जड़ियां मैं तुसां ने बोला दा है, अपणिया तरफा ला नी बोला दा, पर पिता परमेश्वरे मिंजो च रेईकरी जड़ा चांदा है सै ही करदा है। ");
INSERT INTO bht_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","मेरा ही भरोसा करा, की मैं पिता परमेश्वर च है; कने पिता परमेश्वर मिंजो च है; नितां जड़े चमत्कार मैं कितयो न उना दिया बजा ने मेरे पर भरोसा करा। ");
INSERT INTO bht_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","मैं तुसां ने सच्च-सच्च बोलदा है, की जड़ा मिंजो पर भरोसा करदा है, ऐ कम्म जड़े मैं करदा है उनी भी करणे, क्योंकि मैं पिता परमेश्वर बाल जाणा है। ");
INSERT INTO bht_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","कने जड़ा कुछ तुसां मेरे नाऐ ने मंगगे, सेई मैं करगा ताकि पुत्रे दे जरिये पिता परमेश्वर दी महिमा होऐ। ");
INSERT INTO bht_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","अगर तुसां मिंजो ला मेरे नाऐ ला कुछ मंगगे, तां मैं सै पूरा करणा। ");
INSERT INTO bht_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","अगर तुसां मिंजो ने प्यार करदे न, तां मेरे हुकमा जो मनगे। ");
INSERT INTO bht_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","कने मैं पिता परमेश्वर ने बिनती करगा, की सै तुहांजो इक होर मददगार दे, ताकि सै हमेशा तुहाड़े सोगी रे। ");
INSERT INTO bht_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","सै सच्च दी आत्मा, जड़ी पबित्र आत्मा है, सै परमेश्वरे दे बारे च सच्च जो प्रगट करदा है, क्योंकि संसार ना पबित्र आत्मा जो दिखदा है कने ना उसयो जाणदा है: तुसां पबित्र आत्मा जो जाणदे न, क्योंकि सै तुहाड़े सोगी रेंदा है कने उनी तुसां च होणा है। ");
INSERT INTO bht_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“मैं तुहांजो अनाथ नी छडणा है, मैं तुहाड़े बाल बापस ओणा। ");
INSERT INTO bht_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","थोड़े ही बकते च संसारे दे लोकां मिंजो नी दिखणा, पर तुसां मिंजो दिखणा क्योंकि मैं फिरी ला जिन्दा होणा है, इस तांई तुसां भी जिन्दा रेंणा है। ");
INSERT INTO bht_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","जिस रोजे मैं जिन्दे होईकरी बापस ओणा उसी दिने तुहांजो पता लगणा, की मैं अपणे पिता परमेश्वर च है कने तुसां मिंजो च न, कने मैं तुसां च है। ");
INSERT INTO bht_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","जड़े मेरे हुक्मा जो जाणदा है, कने सै हुक्मा जो मंनदा है, सै ही मिंजो ने प्यार करदा है, कने मैं भी उसला प्यार करणा है कने जड़ा मिंजो ने प्यार करदा है, उसला मेरे पिता परमेश्वरे भी प्यार करणा, कने मैं उसला प्यार रखणा, कने मैं अपणे आपे जो उदे पर प्रगट करणा है।” ");
INSERT INTO bht_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","उनी यहूदे जड़ा इस्करियोती नी था, उनी बोलया, “प्रभु जी, क्या होया की तू अपणे आपे जो सांझो पर प्रगट करणा चांदा है, कने संसारे दे लोकां पर नी?” ");
INSERT INTO bht_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","यीशुऐ उसयो जबाब दिता, मैं अपणे आपे जो ऐसे लोकां जो दसदा है जड़े कोई मिंजो ने प्यार करदे न, कने मेरियां सिखाईयां गल्लां जो मंदे न। कने मेरे पिता उसने प्यार रखणा कने असां आई करी उदे सोगी रेणा है। ");
INSERT INTO bht_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","जड़ा मिंजो ने प्यार नी करदा, सै मेरी सिखाईयां गल्लां जो नी मंनदा है, कने जड़ा मेरी शिक्षा तुसां सुणदे न, सै मेरियां नी न पर मेरे पिता परमेश्वर दी शिक्षा न, जिनी मिंजो भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ऐ गल्लां मैं तुहाड़े सोगी रेईकरी तुसां ने बोलियां न। ");
INSERT INTO bht_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","मददगार मतलब की पबित्र आत्मा जिसयो पिता परमेश्वरे मेरी जगा लेणे तांई भेजणा है, पबित्र आत्मा तुहांजो सारियां गल्लां सिखाणियां न, कने जड़ा कुछ मैं तुसां ने बोलया है, सै सब कुछ तुहांजो याद कराणा है। ");
INSERT INTO bht_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","मैं तुहांजो शांति दिन्दा है, मैं अपणी शांति तुहांजो दिन्दा है; ऐ सै शांति नी है जड़ी संसार देई सकदा है। तुसां अपणे मने जो दुखी कने डरया होया मत होणा दिया। ");
INSERT INTO bht_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","तुसां सुणाया, की मैं तुहांजो ने बोलया, “मैं जाणा है। कने तुहाड़े बाल फिरी बापस आई जाणा है अगर तुसां मेरे ने प्यार करदे न, तां इसा गल्लां ने खुश होंदे न, की मैं पिता परमेश्वर बाल जाणा है क्योंकि पिता परमेश्वर मिंजो ला बड़ा महान है।” ");
INSERT INTO bht_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","कने मैं हुण ऐ सब गल्लां होणे ला पेहले तुहांजो ने बोली दितियां न, की जालू सै होई जांगियां, तां तुसां मिंजो पर भरोसा करन। ");
INSERT INTO bht_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","हुण मेरे बाल तुसां ने तुहाड़े सोगी गल्लां करणे तांई जादा बकत नी क्योंकि इसी संसारे दे सरदारे शैताने ओणा है, कने मिंजो पर उदा कोई हक नी है। ");
INSERT INTO bht_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","मैं तियां ही करदा है जियां पिता परमेश्वरे मिंजो हुकम दिता, ऐ इस तांई की संसार दे लोकां जो पता लग्गे की मैं पिता परमेश्वरे ने प्यार करदा है। कने जियां पिता परमेश्वर मिंजो हुकम दिन्दा, मैं तियां ही करदा है। उठा, ऐथू ला चलदे न। ");
INSERT INTO bht_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","सच्ची दाखा दी बेल मैं हे; कने मेरा पिता परमेश्वर किसान है। ");
INSERT INTO bht_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","हर इक डाली जड़ी मिंजो ने लगियो है, कने नी फल्दी है, उस जो सै बडी दिन्दा है, कने जड़ी डाली फल्दी है उसा जो सै छांडदा है ताकि सै होर जादा फले। ");
INSERT INTO bht_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","जड़ी शिक्षा मैं तुसां जो दितियो है, उसा दिया बजा ने तुसां शुद्ध न। ");
INSERT INTO bht_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","तुसां मिंजो च बणी रिया, कने मैं तुहांजो च: जियां कोई डाली अगर दाखा दिया बेला ला टूटी जा, तां सै अपु नी फली सकदी, तियां ही तुसां मिंजो च बणी नी रेंगे तां, तुसां कुछ नी करी सकदे। ");
INSERT INTO bht_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","मैं दाख बेल है: कने तुसां डालियाँ न; जड़ा मिंजो च बणी रेंदा है, कने मैं उदे च, सै मता फलदा है, क्योंकि मिंजो ने लग होईकरी तुसां कुछ नी करी सकदे। ");
INSERT INTO bht_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","अगर कोई मिंजो च बणी नी रे, तां उसा डालियाँ जो बड्डी करी फेंकी दिन्दे न, कने जालू सै डालियाँ सुकी जांदियां न; कने लोक उना जो गठेरी करी अग्गी च पाई दिन्दे न, कने सै फकुई जान्दियां न। ");
INSERT INTO bht_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","अगर तुसां मिंजो ने बंणी रेन, कने मेरियां शिक्षा च तुसां बणी रेंगे तां तुसां जड़ा चांगे सै मंगा कने सै तुहाड़े तांई होई जाणा। ");
INSERT INTO bht_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","मेरे पिता परमेश्वर दी महिमा इसी ने होंदी है, की तुसां बड़ा जादा फल लोंगे, ऐई तुहाड़ा मेरे चेले होणे दा सबूत है। ");
INSERT INTO bht_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","जियां पिता परमेश्वरे मिंजो ने प्यार रख्या, तियां ही मैं भी तुहांजो ने प्यार किता, मेरे प्यारे च बंणी रिया। ");
INSERT INTO bht_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","अगर तुसां मेरे हुकमा जो मनगे, तां मेरे प्यारे च बंणी रेणा जियां की मैं अपणे पिता परमेश्वरे दे हुक्मा जो मनया है, कने उदे प्यारे च बणी रेंदा है। ");
INSERT INTO bht_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","मैं ऐ गल्लां तुहांजो इस तांई बोलियां न, ताकि तुसां च भी सेई खुशी हो जड़ी मिंजो च है, कने तुहाड़ी खुशी पुरी होई जा। ");
INSERT INTO bht_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","मेरा हुकम ऐ है, की जियां मैं तुसां ने प्यार रखया है तियां ही तुसां भी इकी दुज्जे ने प्यार रखा। ");
INSERT INTO bht_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","कुसी बाल ऐ दसणे तांई की सै अपणे मित्रां ने प्यार करदा है, इसला बडा होर कोई तरिका नी है की सै अपणे मित्रां जो बचाणे तांई अपणी जान देई दे। ");
INSERT INTO bht_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","जड़ा भी हुकम मैं तुहांजो दिन्दा है, अगर तुसां उसयो करन, तां तुसां मेरे मित्र न। ");
INSERT INTO bht_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","हुण मैं तुहांजो सेवक नी बोलणा, क्योंकि सेवक नी जाणदा है, की उदा स्वामी क्या करदा है: पर मैं तुहांजो मित्र बोलया है, क्योंकि मैं जड़ियां गल्लां अपणे पिता परमेश्वरे ला सुणियां, सै सारियां तुहांजो दस्सी दितियां न। ");
INSERT INTO bht_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","तुसां मिंजो नी चूंणया है पर मैं तुहांजो चूंणया है कने तुहांजो नियुक्त कितया है ताकि तुसां जाई करी फल देन; कने तुहाड़ा फल टिकाऊ रे, ताकि तुसां मेरे चेले न, इस तांई जड़ा कुछ तुसां मेरे ना ने मंगगे, सै तुहांजो दे। ");
INSERT INTO bht_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","इना गल्लां दा हुकम मैं इस तांई दिन्दा है, ताकि तुसां इकी दुज्जे ने प्यार रखन। ");
INSERT INTO bht_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","अगर संसार दे लोक तुहांजो ने बैर रखदे न, तां तुसां जाणदे न, की इना तुसां ला पेहले मिंजो ने भी बैर रखया। ");
INSERT INTO bht_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","अगर तुसां संसारे दे लोकां सांई होंदे, तां संसारे दे लोक अपणयां ने प्यार करदे न, पर इसा बजा ने की तुसां इस संसारे दे लोकां ने रिश्ता नी रखदे, कने मैं तुहांजो इस संसारे ला चूंणया है, इस तांई संसारे दे लोक तुहांजो ने बैर रखदे न। ");
INSERT INTO bht_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","जड़ा मैं तुसां जो दसया है, सेवक अपणे मालिके ला बडा नी होंदा है, इसयो याद रखा अगर उना मिंजो सताया, तां तुहांजो भी सताणां है; अगर उना मेरियां शिक्षा जो मनया, तां तुहाड़ी शिक्षा जो भी मनणा। ");
INSERT INTO bht_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","पर ऐ सारा कुछ लोकां इसा बजा ने तुहाड़े सोगी करणा क्योंकि तुसां मेरे चेले न, कने सै मेरे भेजणे बाले परमेश्वरे जो नी जाणदे न। ");
INSERT INTO bht_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","अगर मैं नी ओंदा कने उना ने गल्लां नी करदा, तां सै पापी नी बणदे पर हुण उना जो उना दे पापां तांई कोई भाना नी। ");
INSERT INTO bht_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","जड़ा मिंजो ने बैर रखदा है, सै मेरे पिता परमेश्वर ने भी बैर रखदा है। ");
INSERT INTO bht_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","अगर मैं उना च सै चमत्कार नी करदा, जड़े कुनी होरनी नी किते तां सै पापी नी बणदे, पर हुण उना मिंजो दिखी लिया है फिरी भी सै मिंजो कने मेरे पिता परमेश्वरे दोनो ने बैर करदे न। ");
INSERT INTO bht_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ऐ इस तांई होया की जड़ा उना दे पबित्र शास्त्र च लिखया है ऐ इना गल्लां जो पूरा करदा है, उना बिना कुसी बजा ने मिंजो ने नफरत किती। ");
INSERT INTO bht_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","पर जालू सै मददगार ओंगा, जिसयो मैं तुहाड़े बाल पिता परमेश्वरे दिया तरफा ला भेजगा, मतलब की सच्च दी आत्मा जड़ी पिता परमेश्वरे दिया तरफा ला निकलदी है, तां उनी मेरी गबाई देंणी। ");
INSERT INTO bht_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","कने तुसां भी गबाह न क्योंकि तुसां शुरू ला मेरे सोगी न। ");
INSERT INTO bht_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ऐ गल्लां मैं तुहांजो ने इस तांई बोलियां की कुथी तुसां भरोसा करणा ना छडी देन। ");
INSERT INTO bht_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","उना तुहांजो यहूदी जंज घर ला कडी देणा, कने सै बकत ओणा है, की अगर कोई तुहांजो मारी दिंगा, तां तुहाड़े हत्यारे ऐ समझणा है की सै परमेश्वरे दी सेबा करा दा है। ");
INSERT INTO bht_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","कने उना ऐ इस तांई करणा क्योंकि उना ना पिता परमेश्वर जो जाणया है कने ना ही मिंजो जाणदे न। ");
INSERT INTO bht_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","पर मैं ऐ गल्लां इस तांई तुसां ने बोलियां, ताकि जालू उना दा बकत ओऐ तां तुहांजो याद आई जा, मैं ऐ सब तुसां जो शुरू च इस तांई नी बोलया, क्योंकि उस बकत मैं तुहाड़े सोगी था। ");
INSERT INTO bht_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","हुण मैं अपणे भेजणे बाले बाल जाणा है कने तुसां चे कोई मिंजो ला नी पूछदा है, की मैं कुथु चलया है? ");
INSERT INTO bht_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","पर मैं जड़ियां ऐ गल्लां तुसां ने बोलियां न, इस तांई तुहाड़ा मन बड़ा दुखी होया है। ");
INSERT INTO bht_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","तमी मैं तुसां ने सच्च बोलदा है, की मेरा जाणा तुहाड़े तांई खरा है, क्योंकि अगर मैं नी जांगा, तां उनी दिलासा देणेबाले तुहाड़े बाल नी ओंणा, पर अगर मैं जांगा, तां उसयो तुहाड़े बाल भेजी दिंगा। ");
INSERT INTO bht_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","कने उनी आई करी संसारे दे लोकां जो पाप कने धार्मिकता कने न्याय दे बारे च यकीन दिलाणा। ");
INSERT INTO bht_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","पापे दे बारे च यकीन दिलाणा की सै मिंजो पर भरोसा करणे ने मना करदे न; ");
INSERT INTO bht_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","कने ऐ साबित करदा है की यीशु धर्मी था, इस तांई की मैं पिता परमेश्वर बाल चलया है, कने तुसां मिंजो फिरी नी दिखणा है, ");
INSERT INTO bht_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","कने न्याय दे बारे च भी यकीन दिलाणा की इस संसारे दे सरदार शैताने जो दोषी ठहराया है। ");
INSERT INTO bht_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","मैं तुहांजो ने होर भी मतियां गल्लां बोलणा चांदा है, पर हले तुसां इना जो सेहन नी करी सकदे न। ");
INSERT INTO bht_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","पर जालू सै मतलब की सच्च दिया आत्मा ओंणा है, तां आत्मा तुसां जो परमेश्वर दे बारे च जड़ा सच्च है सै समझाणा है, क्योंकि उनी अपणे अधिकारे ने नी बोलणा है, पर जड़ा कुछ परमेश्वरे ला सुणगा, सै ही उनी बोलणा है, कने होणे बालियां गल्लां तुहांजो दसणियां। ");
INSERT INTO bht_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","उनी मेरी महिमा करणी, क्योंकि उसयो मेरिया तरफा ला जड़ा मिलया है, उनी तुसां जो सै ही सिखाणा। ");
INSERT INTO bht_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","जड़ा कुछ पिता परमेश्वर दा है, सै सब मेरा है; तांई तां मैं बोलया था की, उनी मेरियां गल्लां चे लेईकरी तुहांजो दसणा है। ");
INSERT INTO bht_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“थोड़े बकते च तुसां मिंजो नी दिखणा, कने फिरी थोड़ी देरा च तुसां मिंजो दिखणा है।” ");
INSERT INTO bht_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","तालू उदे कितणयां ही चेलयां अपु चे बोलया, “ऐ क्या है, जड़ा सै सांझो ने बोला दा है, थोड़े बकते च तुसां मिंजो नी दिखणा, कने फिरी थोड़ी देरा च तुसां मिंजो दिखणा है? कने ऐ इस तांई की मैं पिता परमेश्वर बाल चलया है?” ");
INSERT INTO bht_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","चेले इकी दुज्जे ला पुछदे रे, “की सै क्या बोला दा है। क्या है ऐ थोड़े बकत बाद जिसदे बारे च सै बार-बार बोला दा है।” ");
INSERT INTO bht_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","यीशुऐ ऐ जाणी करी, की सै मिंजो ला इना गल्लां दा मतलब पूछणा चांदे न, उना जो बोलया, क्या तुसां अपु चे मेरिया इना गल्लां दे बारे च पूछा दे न, थोड़े बकते च तुसां मिंजो नी दिखणा, कने फिरी थोड़ी देरा च तुसां मिंजो दिखणा है? ");
INSERT INTO bht_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","मैं तुसां ने सच्च-सच्च बोलदा है; मेरिया मौता दे बाद तुसां रोंणा कने दुखी होणा है, पर संसारे दे लोकां खुश होणा है: तुसां जो दुख होणा, पर जालू मैं मरी करी दुबारा जिन्दा होणा तालू तुहाड़ा दुख खुशी च बदली जाणा। ");
INSERT INTO bht_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","जालू जनानी बच्चे जो जमणा लगदी है तां उसा जो बड़ी पिढ़ होंदी है, क्योंकि उसा दे दुखे दी घड़ी आईयो है, पर जालू सै बच्चा जम्मी बोंदी है तां इसा खुशिया ने की संसारे च इक माणु पैदा होया है, उस दुखे जो फिरी कदी याद नी करदी। ");
INSERT INTO bht_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","इयां ही हुण तुहांजो भी दुख है, पर मैं तुसां ने फिरी मिलणा है कने तुसां खुश होणा; कने तुहाड़ी खुशी तुहांजो ला कुनी नी खोंणी। ");
INSERT INTO bht_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","जालू मिंजो तुसां दोबारा दिखणा तालू मिंजो ला कुछ नी पूछणा: मैं तुसां ने सच्च-सच्च बोलदा है, अगर पिता परमेश्वरे ला कुछ मंगगे, तां उनी मेरे चेले होणे दिया बजा ने तुहांजो देणा। ");
INSERT INTO bht_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","हले दीकर तुसां मेरे नाऐ ने पिता परमेश्वरे ला कुछ नी मंगया; पर मंगगे तां मिलणा ताकि तुहाड़ी खुशी पूरी होई जा। ");
INSERT INTO bht_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“मैं तुहांजो ने ऐ गल्लां कहाणियां च बोलियां न, पर सै बकत ओणा है, की मैं तुसां ने होर कहाणियां च नी बोलणा है पर खुली करी पिता परमेश्वर दे बारे च दसणा। ");
INSERT INTO bht_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","उस बेले तुसां अपु मेरे नाऐ ने मंगणा, क्योंकि तुसां मेरे चेले न कने मैं तुसां जो बोलदा है, की मैं तुहाड़े तांई पिता परमेश्वर ने बिनती नी करणी। ");
INSERT INTO bht_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","क्योंकि मेरे पिता परमेश्वर तां अपु ही तुसां ने प्यार करदा है, इस तांई की तुसां मिंजो ने प्यार रखया है, कने ऐ भी भरोसा किता की, मैं पिता परमेश्वर दिया तरफा ला निकलया है। ");
INSERT INTO bht_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","मैं पिता परमेश्वर ला निकली करी संसारे च आया है, फिरी संसारे जो छडी करी पिता परमेश्वरे बाल जाणा है।” ");
INSERT INTO bht_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","उदे चेलयां बोलया, “दिख, हुण तां तू खुली करी बोला दा है, कने कोई कहाणी नी बोली।” ");
INSERT INTO bht_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","हुण असां जाणी गियो न, की तू सारा कुछ जाणदा है, कने तिजो कुसी दी जरूरत ही नी की कोई तिजो ला सबाल पुच्छे, इसला असां भरोसा करदे न, की तू परमेश्वरे ला निकलया है। ");
INSERT INTO bht_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ऐ सुणीकरी यीशुऐ उना ने बोलया, “की क्या तुसां हुण भरोसा करदे न? ");
INSERT INTO bht_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","दिखा, सै बकत ओंणा है बस आई रिया है की तुसां सारयां बख-बख होईकरी अपणे-अपणे रस्ते जाणा है, कने मिंजो किल्ला छडी देणा है, तमी मैं किल्ला नी क्योंकि मेरा पिता परमेश्वर मेरे सोगी है। ");
INSERT INTO bht_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","मैं ऐ गल्लां तुसां ने इस तांई बोलियां न, ताकि तुसां जो अंदरूनी शांति मिल्ले क्योंकि तुसां मेरे सोगी रिश्ता रखया, संसार च तुहांजो दुख होणा है, पर सबर रखा, मैं इस संसारे च राज करणे बाले शैताने जो हराई दीतया है।” ");
INSERT INTO bht_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","यीशुऐ अपणे चेलयां ने ऐ गल्लां बोलणे बाद कने अपणियां नजरां स्वर्गे पासे करिके बोलया, पिता परमेश्वर, सै बकत आई गिया है, की तू अपणे पुत्रे दी महिमा कर, ताकि पुत्र भी तेरी महिमा करे, ");
INSERT INTO bht_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","क्योंकि तू मिंजो सारयां लोकां पर हक दितया है, की जिना जो तू मिंजो दितया है, उना सबना जो सै हमेशा दी जिन्दगी दे। ");
INSERT INTO bht_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","कने हमेशा दी जिन्दगी ऐ है कि लोक तिजो जाणी सकन यानी कि इकलोते सच्चे परमेश्वरे जो। कने ऐ भी की सै मिंजो जाणन, यानी यीशु मसीह जो, जिसयो तू भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","जड़ा कम्म तू मिंजो करणे जो दितया था, उसयो पूरा करिके मैं धरतिया पर तेरी महिमा किती है। ");
INSERT INTO bht_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","इस तांई पिता परमेश्वर तू मिंजो अपणी महिमा ने महिमित कर, महिमा जड़ी संसारे दे होणे ला पेहले मेरी महिमा तेरे सोगी थी। ");
INSERT INTO bht_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","मैं तुसां जो उना चेलयां पर प्रगट कितया है, जड़े तुसां मिंजो संसारे चे दितयो न। सै तुहाड़े थे, कने तू उना जो मिंजो दिता। कने उना तेरे बचना जो मनया है। ");
INSERT INTO bht_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","हुण सै जाणी गियो न, की जड़ा कुछ तू मिंजो दितया है, सब कुछ तेरिया तरफा ला है। ");
INSERT INTO bht_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","क्योंकि जड़ा संदेश तू मिंजो दिता, मैं उना जो उना बाल देई दिता कने उना इना गल्लां पर भरोसा किता: कने सच्ची जाणी लिया है, की मैं तेरिया तरफा ला आया है, कने भरोसा करी लिया है की तू ही मिंजो भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","मैं उना तांई बिनती करदा है, सिर्फ उना तांई ही करदा है जड़े तू मिंजो दितयो न क्योंकि सै तेरे न। पर जड़े संसारे ने रिश्ता रखदे न उना तांई बिनती नी करदा है। ");
INSERT INTO bht_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","कने जड़ा कुछ मेरा है सै सब कुछ तेरा है; कने जड़ा तेरा है सै मेरा है; इना ने मेरी महिमा प्रगट होई है। ");
INSERT INTO bht_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","हुण मैं संसारे च नी रेंणा है, कने मैं तेरे बाल ओआ दा है पर मेरे चेलयां इस संसारे च रेणा है; हे पबित्र पिता, अपणे नाऐ दिया शक्तिया ने उना दी रक्षा कर, ताकि उना दा इक ही मन हो जियां साड़ा इक ही मन है। ");
INSERT INTO bht_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","जालू मैं उना सोगी था, तां मैं तेरे उस नाऐ ने जड़ा तू मिंजो दितया है, उना दी रक्षा किती। मैं उना दी देख रेख किती, कने बिनाशे दे पुत्रे जो छडी करी उना चे कूसदा भी नाश नी होया, इस तांई की पबित्र शास्त्रे च लिखियो गल्ल पुरी हो। ");
INSERT INTO bht_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","पर हुण मैं तेरे बाल ओणा है, कने ऐ गल्लां मैं संसारे च रेंदे होए बोलदा है, ताकि उना जो मेरी खुशी भरपूरी ने मिल्ले। ");
INSERT INTO bht_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","मैं तेरा संदेश उना बाल पुजाई दितया है, कने संसारे दे लोकां उना ने बैर किता, क्योंकि जियां मैं संसार दा नी है, तियां ही से भी संसारे दे नी न। ");
INSERT INTO bht_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","मैं ऐ बिनती नी करदा, की तू उना जो संसारे ला चुकी ले, पर ऐ की तू उना दी शैताने ला रक्षा कर। ");
INSERT INTO bht_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","जियां मैं संसारे दा नी है, तियां ही से भी इस संसारे दे नी न। ");
INSERT INTO bht_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","तेरा बचन सत्य है। उना जो सच्चाई च अपणे तांई लग कर। ");
INSERT INTO bht_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","जियां तू मिंजो संसारे च भेजया, तियां ही मैं भी इना जो संसारे च भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","कने मैं उना दे फायदे तांई अपणे आपे जो पबित्र करदा है ताकि सै भी सच्च ने पबित्र होन। ");
INSERT INTO bht_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","मैं बस अपणे चेलयां तांई ही बिनती नी करदा है, पर जड़े इना दी शिक्षा ने मिंजो पर भरोसा करगे उना तांई भी बिनती करदा है। ");
INSERT INTO bht_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","की सै सारे इक होन; जियां पिता तू मिंजो च है, कने मैं तिजो च है, तियां ही सै भी सांझो च होन, इस तांई की संसार दे लोक भरोसा करन, तू ही मिंजो भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","कने सै महिमा जड़ी तू मिंजो दिती, कने मैं उना जो दितियो है की सै तियां ही इक होन जियां असां इक न। ");
INSERT INTO bht_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","मैं उना च कने तू मिंजो च ताकि सै सिद्ध होईकरी इक होई जान, कने संसार जाणे की तू ही मिंजो भेजया है, कने जियां तू मिंजो ने प्यार रखया है, तियां ही उना ने भी प्यार रख। ");
INSERT INTO bht_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","पिता परमेश्वर, मैं चांदा है की जिना जो तू मिंजो दितयो है, जिथू मैं है, ओथु भी मेरे सोगी होन ताकि सै मेरिया उसा महिमा जो दिखन जड़ी तू मिंजो दितयो है, क्योंकि तू मिंजो संसारे दे बणने ला पेहले ला ही मिंजो ने प्यार रख्या है। ");
INSERT INTO bht_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","हे धार्मिक पिता, संसारे दे लोकां तिजो नी जाणया, पर मैं तिजो जाणदा है कने चेलयां भी जाणया की तू मिंजो भेजया है। ");
INSERT INTO bht_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","कने मैं तेरा ना उना जो दसया कने दसदे रेंणा है ताकि जड़ा प्यार तिजो मिंजो ने था, सेई उना चे रे कने मैं उना च रेणा। ");
INSERT INTO bht_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","जालू यीशुऐ प्राथना करणे बाद अपणे चेलयां सोगी किद्रोन दे नाल्ले पार गिया। ओथु इक बाग था, यीशु कने उदे चेले उस बागे दे अंदर गे। ");
INSERT INTO bht_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","उसयो पकड़बांणे बाला यहूदा भी उसा जगा जो जाणदा था, क्योंकि यीशु ओथु अपणे चेलयां सोगी जांदा था। ");
INSERT INTO bht_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","तालू यहूदा, सिपाईयां दी इक टोलिया सोगी कने बड्डे याजकां कने फरीसियां दे सेवकां जो लेईकरी उस बागे च आया कने हथां च दिय्ये, मशालां, कने हथियार लियो थे। ");
INSERT INTO bht_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","तालू यीशु, उना सबना गल्लां जो जाणी करी जड़ियां उसने होंणे बालियां थियां, अग्गे आई करी उना ला पुछया, की कुसयो तोपा दे न? ");
INSERT INTO bht_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","उना उसयो जबाब दिता, “नासरत नगर ला यीशुऐ जो।” यीशुऐ उना जो बोलया, की मैं ही यीशु है। उसयो पकड़वाणे बाला यहूदा भी उना सोगी खड़ोतया था। ");
INSERT INTO bht_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","यीशुऐ जो ऐसा बोलदे ही, की मैं ही नासरत दा यीशु है, सै पिच्छे हटी करी धरतिया पर ढेई पे। ");
INSERT INTO bht_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","तालू यीशुऐ उना ला फिरी पुछया की, तुसां कुसयो तोपा दे न, “उना बोलया, नासरत नगर दे यीशु जो।” ");
INSERT INTO bht_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","यीशुऐ जबाब दिता, “मैं तां तुसां जो बोली बैठया है की हाँ मैं ही यीशु है, अगर तुसां मिंजो तोपा दे न तां इना लोकां जो जाणा दिया, ऐ मेरे चेले न।” ");
INSERT INTO bht_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ऐसा इस तांई होया की, यीशुऐ जड़ा पेहले बोलया था सै सच्च होई जा: “जिना जो तू मिंजो दितया है उना चे मैं इकी जो भी नी गबाया है।” ");
INSERT INTO bht_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","तालू शमौन पतरसे अपणी तलवार कडी कने, महायाजके दे इकी नोकरे पर चलाई दिती कने उस दा इक कन उड़ाई दिता। उस सबके दा ना मलखुस था। ");
INSERT INTO bht_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","तालू यीशुऐ पतरसे ने बोलया, “अपणिया तलवारा जो मयाना च रख। जड़ा कटोरा मेरे पिता परमेश्वरे मिंजो दितया है, क्या मैं उसयो नी पिऐं?” ");
INSERT INTO bht_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","तालू सिपाईयां कने उना दे सूबेदारां कने यहूदी अगुवां दे नोकरां यीशु जो पकड़ी करी बन्नी दिता, ");
INSERT INTO bht_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","कने पहले उसयो हन्ना बाल लेई गे, क्योंकि सै उस साले दे महायाजक कैफा दा सौरा था। ");
INSERT INTO bht_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ऐ सेई कैफा नाऐ दा इक माणु था, जिनी यहूदी अगुवां जो सलाह दिती थी की साड़े लोकां तांई मरणा इक माणुऐ दा खरा है। ");
INSERT INTO bht_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","शमौन पतरस कने इक होर चेला भी यीशुऐ दे पिच्छे चली पे, इस चेले जो महायाजक जाणदे पछेणदे थे। इस तांई सै यीशुऐ पिच्छे-पिच्छे महायाजक दे अंगणे दीकर गिया, ");
INSERT INTO bht_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","पर पतरस बाहर दरबाजे पर खड़ोई रिया, तालू सै दुज्जा चेला जिसयो महायाजक जाणदे थे सै बाहर आया, कने उनी दरबाजे पर खड़ोतियो नोकराणियां जो बोली करी पतरसे जो अंदर लेई ओंदा। ");
INSERT INTO bht_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","उना नोकराणिया जड़ी दरबाजे पर खड़ोतियो थी, पतरसे जो बोलया, “की तू भी इस माणुऐ दे चेलयां चे तां नी ऐ?” उनी बोलया, “मैं नी है।” ");
INSERT INTO bht_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","सर्दियां दिया बजा ने मंदरे दे रखबाले कने सिपाई अग्ग बाली करी तपा दे थे, कने पतरस भी उना सोगी खड़ोई करी अग्ग तपा दा था। ");
INSERT INTO bht_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","तालू महायाजके यीशुऐ ला उदे चेले कने उदे उपदेशां दे बारे च पूछताछ किती। ");
INSERT INTO bht_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","यीशुऐ उसयो जबाब दिता, “मैं सबना च खुली करी गल्लां कितियां, मैं यहूदी जंज घर कने मंदरे च जाई करी हमेशा उपदेश दिता जिथू यहूदी गिठे होंदे थे, कने कुछ भी लुकी करी कुछ नी बोलया। ");
INSERT INTO bht_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","तू मिंजो ला ऐ सबाल कजो पूछा दा है? सुणने बालयां ला पुछ की मैं उना ने क्या बोलया है। सै जाणदे न की मैं क्या-क्या बोलया है।” ");
INSERT INTO bht_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","जालू यीशुऐ ऐसा बोलया, तां बखे खड़ोतयो मंदरे दे रखबालयां चे इकी रखबाले, यीशुऐ जो थपड़ मारी करी बोलया, “क्या तू महायाजक जो इयां जबाब दे दा?” ");
INSERT INTO bht_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","यीशुऐ उसयो जबाब दिता, अगर मैं गलत बोलया, तां साबित कर की मैं गलत बोलया; पर अगर खरा बोलया है तां मिंजो कजो मारा दा है। ");
INSERT INTO bht_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","यीशुऐ अजे भी बनया ही था, कने हन्ने उसयो तियां ही कैफा महायाजक बाल भेजी दिता। ");
INSERT INTO bht_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","शमौन पतरस खड़ोई करी अग्ग तपा दा था, तालू उस सोगी खड़ोतयो लोकां उसयो पुछया की, “कुथी तू भी तां उदे चेलयां चे तां नी है?” उनी बोलया, “मैं नी है।” ");
INSERT INTO bht_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","महायाजक दे नोकरां चे इकी नोकरे, जड़ा उदा रिशतेदारां चे था, कने उदा कन पतरसे बडी दितया था, उनी बोलया की तिजो तां मैं यीशुऐ सोगी बागे च नी दिखया था? ");
INSERT INTO bht_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पतरसे फिरी मना करी दिता, कने तालू झट मुर्गे बांग देई दिती। ");
INSERT INTO bht_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","फिरी यहूदी लोक यीशु जो कैफा बाल लेई आऐ कने किल्ले जो लेई गे, ऐ रोमी राज्यपाल पिलातुस दा मेहल था, कने ब्यागा दा बकत था पर सै अपु किले अंदर नी गे अगर जांदे तां उना अशुद्ध होई जाणा था, क्योंकि पिलातुस यहूदी नी था। अगर अशुद्ध होई जांदे तां फसह दी रोटी नी खाई सकदे थे। ");
INSERT INTO bht_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","तालू पिलातुस बाहर निकली करी उना बाल आया कने बोलणा लग्गा, “तुसां इस माणुऐ पर कुसा गल्लां दा अरोप लगा दे न?” ");
INSERT INTO bht_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","उना उसयो जबाब दिता, अगर ऐ अपराधी माणु नी होंदा तां असां इसयो तेरे बाल नी लोंदे। ");
INSERT INTO bht_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पिलातुसे उना जो बोलया, “तुसां ही इसयो लेईजाई करी अपणिया व्यवस्था दे अनुसार इसयो सजा दिया।” यहूदी अगुवां उसयो बोलया, “की सांझो कोई हक नी है की असां कुसी जो मौत दी सजा देई सकन।” ");
INSERT INTO bht_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ऐ इस तांई होया की यीशु दी सै गल्ल पूरी हो जड़ी उनी ऐ इशारा करदे बोली थी मेरी मौत कियां कुस तरीके ने होणी है। ");
INSERT INTO bht_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","तालू पिलातुस फिरी किल्ले दे अंदर गिया, कने यीशुऐ जो अंदर सदीकरी पुछया, “तू क्या यहूदी लोकां दा राजा है?” ");
INSERT INTO bht_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","यीशुऐ जबाब दिता, “तू क्या ऐ गल्ल अपणिया तरफा ला बोला दा है, की कुनी होरनी ऐ गल्ल तिजो मरे बारे च बोली है?” ");
INSERT INTO bht_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातुसे जबाब दिता, “तू जाणदा है की मैं यहूदी नही है? तेरिया ही जाति कने बड्डे याजकां तिजो मेरे हथे दितया है, तू क्या कितया है?” ");
INSERT INTO bht_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","यीशुऐ जबाब दिता, मेरा राज्य इस संसारे दा नी है, अगर मेरा राज्य इस संसारे दा होंदा तां मेरे चेलयां लड़णा था, कने मैं यहूदी अगुवां दे हथे गिरफ्तार नी होंदा: पर मेरा राज्य ऐथू दा नी है। ");
INSERT INTO bht_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","पिलातुसे उसयो बोलया, तू क्या राजा है? यीशुऐ जबाब दिता, “तू बोलदा है, की मैं राजा है, मेरा जन्म लेणा कने संसार च ओंणे दी बजा ऐ है की मैं सच्च दे बारे च सिखाई सके। जड़ा कोई परमेश्वरे ने सच्चा प्यार करदा है, कने मेरा बचन सुणदा है।” ");
INSERT INTO bht_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातुसे उसयो बोलया, “सच्च क्या है?” ऐ बोली करी सै फिरी यहूदी अगुवां बाल चली गिया कने उना ने बोलया, “मिंजो उदे च कोई भी दोष नी लग्गा दा है। ");
INSERT INTO bht_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","पर तुहाड़ा ऐ रिबाज है की मैं फसह दे त्योहारे च तुहाड़े तांई इक कैदी छडी दें। तुसां क्या चांदे न की मैं तुहाड़े तांई यहूदियां दे राजे जो छडी दें?” ");
INSERT INTO bht_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","तालू उना फिरी जोरे ने बोलया, “इसयो नी, पर साड़े तांई तू बरअब्बा जो छडी दे।” कने बरअब्बा इक डाकू था। ");
INSERT INTO bht_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","इसा गल्ला पर पिलातुसे सिपाईयां जो हुकम दिता की यीशुऐ जो लेई जा कने कोड़े मारा। ");
INSERT INTO bht_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","कने सिपाईयां कंडयां दा मुकट बणाया कने उदे सिरे पर रखया, कने उसयो बैंगणी कपड़े पेनाऐ, ");
INSERT INTO bht_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","कने उदे बखे आई करी बोलणा लग्गे, नमस्ते, यहूदियाँ दे राजा कने उसयो थपड़ मारे। ");
INSERT INTO bht_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","तालू पिलातुसे फिरी बाहर निकली करी लोंका ने बोलया, “मैं उसयो तुहाड़े बाल फिरी लोंदा है, ताकि तुहांजो पता लग्गे की मिंजो इदे च कुछ भी गलत नजर नी आया।” ");
INSERT INTO bht_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","तालू यीशुऐ जो कंडयां दा मुकट कने बैंगणी कपड़े पेनाइ करी बाहर लांदा कने पिलातुसे उना ने बोलया, “इस माणुऐ जो दिखा।” ");
INSERT INTO bht_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","जालू बड्डे याजकां कने मंदरे दे रखबालयां उसयो दिखया, तां चीलाई करी बोलया, “इसयो सूली पर चढ़ा, सूली पर चढ़ा!” पिलातुसे उना जो बोलया, “तुसां ही इसयो सूली पर चढ़ा, क्योंकि मिंजो इदे च कुछ भी गलत नी मिल्ला है।” ");
INSERT INTO bht_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदी अगुवां उसयो जबाब दिता, “साड़ी भी व्यवस्था है कने उसा व्यवस्था दे अनुसार सै मारी देणे दे जोगा है क्योंकि उनी अपणे आपे जो परमेश्वरे दा पुत्र बोलया है।” ");
INSERT INTO bht_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","जालू पिलातुसे ऐ गल्ल सुणी तां सै होर भी जादा डरी गिया। ");
INSERT INTO bht_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","कने फिरी किले दे अंदर गिया कने यीशुऐ जो बोलया, “तू कुथु दा है? पर यीशुऐ उसयो कोई भी जबाब नी दिता।” ");
INSERT INTO bht_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","पिलातुसे उसयो बोलया, “मिंजो ने कनी बोला दा है? क्या तू जाणदा नी की तिजो छडणे दा हक मिंजो है कने तिजो सूली पर चड़ाणे दा हक भी मिंजो है।” ");
INSERT INTO bht_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","यीशुऐ जबाब दिता, “अगर तिजो परमेश्वर दिया तरफा ला नी दितया होंदा, तां तेरा मिंजो पर कोई हक नी होंदा, इस तांई जिनी मिंजो तेरे हथे पकड़ाया है, उदा पाप जादा है।” ");
INSERT INTO bht_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ऐ जबाब सुणीकरी पिलातुसे उसयो छडणा चाया, पर यहूदियां चीलाई-चीलाई करी बोलया, “अगर तू इसयो छडी दिंगा तां तू महाराजा कैसरे दा मित्र नी है; जड़ा कोई भी राजा होणे दा दाबा करदा है कने अपणे आपे जो राजा बोलदा है सै महाराजा दा दुशमण है।” ");
INSERT INTO bht_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ऐ गल्लां सुणीकरी पिलातुस यीशुऐ जो बाहर लेई आया कने न्याय दे सिंहासने पर बैठा, कने सै जगा इक चबूतरा था जिसयो इब्रानी भाषा च गब्बता बोलदे न। ");
INSERT INTO bht_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ऐ फसह दे त्योहारे दे हफ्ते सबते दिया तयारियां दा रोज था कने दोपहर दे बकते: तालू उनी यहूदी लोकां जो बोलया, “ऐ ही है, तुहाड़ा राजा।” ");
INSERT INTO bht_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","पर सै चिलाणा लग्गे, इसयो मारी दे, इसयो मारी दे! कने इसयो सूली पर चढ़ा। पिलातुसे उना जो बोलया, क्या मैं तुहाड़े राजे जो सूली पर चढ़ा? बड्डे याजकां जबाब दिता, “महाराजा जो छडी करी साड़ा होर कोई राजा नी है।” ");
INSERT INTO bht_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","तालू पिलातुसे यीशुऐ जो उना दे हबाले करी दिता ताकि सै उसयो सूली पर चड़ाण। ");
INSERT INTO bht_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","तालू सै यीशुऐ जो लेई गे। उना यीशुऐ ला अपणी सूली अपु चुकबाई कने उसयो यरूशलेम शेहर दे बाहर खोपड़ी नाऐ दिया जगा जो लेई गे, कने जिसयो इब्रानी भाषा च गुलगुता बोलदे न। ");
INSERT INTO bht_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ओथु उना उसयो कने उदे सोगी दो माणुऐ जो सूली पर चढ़ाया, इकी जो इक पास्से कने, दुजे जो दुऐ पास्से, कने बिच यीशुऐ जो। ");
INSERT INTO bht_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","कने राज्यपाल पिलातुसे इक्की फटिया पर लिखी करी सूलिया पर लगाई दिती कने उसा पर ऐ लिखया था, “नासरत दा यीशु मसीह यहूदियाँ दा राजा।” ");
INSERT INTO bht_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ऐ फट्टी मते यहूदियाँ पढ़ी क्योंकि जिथू यीशुऐ जो सूली पर चढ़ाया था सै जगा यरूशलेम शेहरे दे बखे थी कने इब्रानी भाषा च कने लतीनी भाषा कने यूनानी भाषा च लिखियो थी। ");
INSERT INTO bht_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","तालू यहूदियाँ दे बड्डे याजक पिलातुसे बोलया, “यहूदियां दा राजा मत लिख पर ऐ की उनी बोलया, मैं यहूदियाँ दा राजा है।” ");
INSERT INTO bht_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातुसे जबाब दिता, “मैं जड़ा लिखी दितया है, सै नी बदलया जाणा है।” ");
INSERT INTO bht_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","जालू सिपाई यीशुऐ जो सूली पर चड़ाई बैठे, तां उदे कपड़े लेईकरी उना चार हिसयां च किते, चारो सिपाईयां तांई इक-इक हिसा कने कुरता भी लेई लिया, पर कुरते जो सितया नी था पर सै उपरे लेईकरी थले दीकर इक ही कपड़े ने बुणया था। ");
INSERT INTO bht_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","इस तांई उना अपु चे बोलया, “असां ऐ नी फाड़ना, पर इदे पर पर्चियां पांदे न की ऐ कुसदा होणा।” ऐ इस तांई होया, ताकि पबित्र शास्त्रे च लिखया गिया सच्च हो, “उना मेरे कपड़े अपु चे बंडी ले कने मेरे कपड़यां पर पर्चियां पाईयां, कने सिपाईयां इयां ही किता।” ");
INSERT INTO bht_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","पर यीशुऐ दे सूली बाल उदी माता कने उदिया माता दी बेहण, क्लोपास दी घरे बाली मरियम कने मगदल ग्रां दी मरियम खड़ोतियो थी। ");
INSERT INTO bht_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","यीशुऐ अपणिया माता जो कने उस चेले जो जिसने सै प्यार रखदा था उसयो बखे खड़ोतया दिखीकरी अपणी माता ने बोलया, “हे नारी, दिख, ऐ तेरा पुत्र है।” ");
INSERT INTO bht_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","तालू उनी चेले बोलया, “ऐ तेरी माता है।” कने उसी बेले सै चेला, उसा जो अपणे घरे लेई गिया। ");
INSERT INTO bht_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","इदे बाद यीशुऐ ऐ जाणी करी की मेरा सारा कम्म खत्म होई गिया है; इस तांई की पबित्र शास्त्रां दियां गल्लां सच्च साबित होन बोलया, “मैं तरिणा है।” ");
INSERT INTO bht_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ओथु इक सिरके ने बरुया बांडा रखया था, तां उना चे कुनकी सिरके ने सेड़यो स्पंजे जो जुफे दे रुखे दे डंडे पर रखीकरी उदे मुऐ ने लाया। ");
INSERT INTO bht_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","जालू यीशुऐ सै सिरका चखया, तां बोलया, “पूरा होया,” कने सर झुकाई करी अपणे प्राण छडी दिते। ");
INSERT INTO bht_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","हुण ऐ तैयारिया दा दिन था, कने अगले दिन सब्त कने फसह दोनों ही थे। ऐ यहूदी लोकां तांई इक खास दिन था, सै नी चांदे थे इस दिने लाशा सूली उपर रेन। इस तांई उना पिलातुसे ने बोलया की उना माणुआं दियां जंगा तोड़ी दिया ताकि उना दी मौत झट होई जा ताकि लाशां जो थले उतारया जाई सके। ");
INSERT INTO bht_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","तां सिपाईयां आई करी पेहले बाले दियां जंगा तोड़ियां फिरी दुजे दियां भी, जड़े यीशुऐ सोगी सूली पर चढ़ायो थे। ");
INSERT INTO bht_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","पर जालू यीशुऐ बाल आई करी दिखया की सै मरी गिया है, तां उदियां जंगा नी तोड़ियां। ");
INSERT INTO bht_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","पर सिपाईयां चे इकी बरछे ने उदा पंजर बेधया कने उदे च खून कने पांणी निकलया। ");
INSERT INTO bht_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","जिनी माणुऐ ऐ सब दिखया, उनी ऐ गबाई दिती है, ताकि तुसां भी यीशुऐ पर भरोसा करी सकन। कने उदी गबाई सच्ची है, कने सै जाणदा है, की सच्च बोला दा है। ");
INSERT INTO bht_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ऐ गल्लां इस तांई होईयां की पबित्र शास्त्रे च जड़ा लिखया है सै सच्च होई जा, “उदी कोई हड्डी नी तोड़ी जाणी।” ");
INSERT INTO bht_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","फिरी इक होर जगा पबित्र शास्त्र च लिखया है, “जिसयो उना बेधया है, उदे पर नजर करणी।” ");
INSERT INTO bht_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","इना गल्लां दे बाद अरिमतिया शेहरे दे यूसुफे, जड़ा यीशुऐ दा चेला था, (पर यहूदी अगुवां दे डरे ने इसा गल्ला जो लुकाई रखदा था), उनी पिलातुसे ने बिनती किती, की मैं यीशुऐ दिया लाशा जो लेई जां, कने पिलातुसे उदी बिनती सुणी, कने सै आई करी उदी लाशा जो लेई गिया। ");
INSERT INTO bht_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","नीकुदेमुस भी जड़ा पेहले यीशुऐ बाल राती गिया था कने लगबग तेती किलो गन्धरस कने एलवा लेई आया। ");
INSERT INTO bht_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","तालू इना दोनों यीशुऐ दी लाश लेई कने यहूदियां दे रिबाजे ने उस पर सै मुस्का बालियां चिंजा लगाई करी कपड़े दियां पट्टियां च लपेटया। ");
INSERT INTO bht_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","उसा जगा पर जिथू यीशु सूली पर चड़ाया था, ओथु इक बारी थी; कने उसा सो बारिया च इक नोई कबर थी, उसा च पेहले कदी कोई नी दफनाया था। ");
INSERT INTO bht_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","इस तांई उना यीशुऐ जो उसा कबरा दिया गुफा च रखी दिता क्योंकि सै बखे ही थी कने सै यहूदियां दे सब्त दी तैयारिया दा दिन भी था। ");
INSERT INTO bht_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","तुआरे ब्यागा तड़के मरियम जड़ी मगदल ग्रां दी थी, सै कने उसा सोगी होर भी जनानियां कबरा पर आईयां, उना कबरा दे दरबाजे ला पथरे जो हटया दिखया। ");
INSERT INTO bht_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","तालू सै दोड़ी कने शमौन पतरसे कने उसी दुऐ चेले बाल जिसने प्रभु प्यार रखदा था, आई करी बोलया, “सै प्रभु यीशुऐ दी लाशा जो कबरा ला कडी लेई गे; कने मैं नी जाणदी की उसयो कुथु रखया है।” ");
INSERT INTO bht_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","तालू पतरस कने सै दुज्जा चेला कबरा पासे चली पे। ");
INSERT INTO bht_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","कने दोनो सोगी-सोगी दोड़यो थे, पर दुआ चेला पतरसे ला तेज दौड़ी करी पेहले कबरा पर पुज्जी गिया। ");
INSERT INTO bht_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","कने निठा होईकरी अंदर दिखया की ओथु कपड़े दियां पट्टियां दा डेर लगया था: पर सै अंदर नी गिया। ");
INSERT INTO bht_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","तालू उदे पिच्छे-पिच्छे शमौन पतरस भी पुज्जी गिया कने कबरा दे अंदर गिया कने कपड़े पियो दिक्खे। ");
INSERT INTO bht_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","कने सै अंगोछा जड़ा सिरे पर लपेटया था, सै कपड़े सोगी नी पिया था पर सै इक लग जगा च मिल्ला। ");
INSERT INTO bht_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","तालू दुआ चेला भी जड़ा कबरा च पेहले पुजया था, अंदरे जो गिया कने दिखीकरी भरोसा किता कि यीशु मरयां चे जिन्दा होई गिया था। ");
INSERT INTO bht_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","पबित्र शास्त्रां च यीशु दे बारे च ऐ लिखया था की उनी मरणे बाद जिन्दा होणा है, पर सै हले दीकर नी समझी पायो थे। ");
INSERT INTO bht_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","तालू सै चेले अपणे घरे जो बापस चली गे। ");
INSERT INTO bht_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","पर मरियम रोंदी होई कबरा दे बाहर ही खड़ोई रेई कने रोंदे-रोंदे कबरा पास्से निठे होईकरी, ");
INSERT INTO bht_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","दो स्वर्गदूतां जो चमकदे कपड़े पाई करी इकी जो सोंदिया कने दुज्जे जो पोंदियां बैठया दिखया, जिथू यीशुऐ दी लाश रखियो थी। ");
INSERT INTO bht_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","स्वर्गदूतां मरियम ला पुछया, ओ जनानिये, तू कजो रोआ दी है? उनी उना जो बोलया, “सै मेरे प्रभु दिया लाशा जो चुकी लेई गे कने मिंजो नी पता की उसयो कुथु रखया है।” ");
INSERT INTO bht_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ऐ बोलणे दे बाद सै पिच्छे मुड़ी कने यीशुऐ जो खड़ोतया दिखया कने पछेणया नी की सै यीशु है। ");
INSERT INTO bht_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","यीशुऐ उसा ने बोलया, जनानिये तू कजो रोंदी है? कुसयो तोपा दी है? उना माली समझीकरी उसयो बोलया, “श्रीमान जी, अगर तू उदे शरीरे जो चुकया है तां मिंजो दसी दे की कुथु रखया है कने मैं उसयो लेई जांगी।” ");
INSERT INTO bht_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","यीशुऐ उसा जो बोलया, मरियम। उना उस पासे मुड़ी करी उसला इब्रानी भाषा च बोलया, गुरू जी। ");
INSERT INTO bht_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","यीशुऐ उसा जो बोलया, “मेरे पैरां च पेईकरी मिंजो मत रोक क्योंकि मैं हले दीकर उपर पिता परमेश्वर बाल नी गिया है, कने मेरे चेलयां बाल जाई करी उना जो बोली दे, की मैं अपणे पिता, कने तुहाड़े पिता, कने अपणे परमेश्वर, कने तुहाड़े परमेश्वरे बाल उपर चलया है।” ");
INSERT INTO bht_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरियम जड़ी मगदल ग्रां दी थी उना जाई करी चेलयां जो दसया, “मैं प्रभु जो दिखया, कने उनी मिंजो ने गल्लां कितियां।” ");
INSERT INTO bht_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","उसी तुआरे दिया संझा बेले सारे चेले इकी जगा गिठे होए, उना दरबाजे बंद करी ले क्योंकि यहूदी अगुवां ला डरयो थे, तालू यीशु आया कने बिच खड़ोई करी उना जो बोलया, “तुहांजो शांति मिल्ले।” ");
INSERT INTO bht_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","कने ऐ बोली करी उनी अपणे हथां कने पैरां दे जख्म दस्से: तालू चेले प्रभु जो दिखीकरी खुश होऐ। ");
INSERT INTO bht_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","यीशुऐ फिरी उना जो बोलया, “तुहांजो शांति मिले; जियां पिता परमेश्वरे मिंजो संसार च भेजया है, तियां ही मैं भी तुहांजो संसारे च भेजा दा है।” ");
INSERT INTO bht_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ऐ बोली करी उनी उना पर फुंक मारी कने बोलया, “पबित्र आत्मा जो अपनाओ। ");
INSERT INTO bht_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","अगर तुसां कुसी दे पाप माफ करगे, उना दे पाप माफ होए न, कने जिना दे पाप तुसां माफ नी करगे, उना अपणे पापां च फसी रेणा है।” ");
INSERT INTO bht_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","पर बाहरां चेलयां चे इक माणु थोमा जिसयो दिदुमुस बोलदे न, जालू यीशु आया तां सै उना सोगी नी था। ");
INSERT INTO bht_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","जालू होर चेले उसला बोलणा लग्गे, असां प्रभु जो दिखया है, तालू उनी उना जो बोलया, “जालू दीकर मैं उदे हथां च मेखां दे जख्म कने उना मेखां दे छेदां च कने उदे पसलियां च हथ नी पाई लेंगा, तालू दीकर मैं भरोसा नी करणा की सै मरयां च जिन्दा होई गिया है।” ");
INSERT INTO bht_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","अठां रोजा बाद उदे चेले फिरी घरे अंदर थे, कने थोमा उना सोगी था, कने दरबाजे बंद थे, तालू यीशुऐ आई करी कने बिच खड़ोई करी बोलया, “तुहांजो शांति मिल्ले।” ");
INSERT INTO bht_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","तालू उनी थोमा जो बोलया, अपणिया उंगलियां ने मेरे हथां जो छूईकरी दिख कने अपणे हथे जो अग्गे करी के मेरियां पसलियां च पा; कने शक करणा बंद कर कने भरोसा कर की मैं मरयां चे जिन्दा होई गिया है। ");
INSERT INTO bht_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ऐ सुणीकरी थोमे जबाब दिता, “मेरे प्रभु जी, मेरे परमेश्वर।” ");
INSERT INTO bht_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","यीशुऐ उसयो बोलया, “तू तां मिंजो दिखीकरी भरोसा किता है। धन्य न सै जड़े बिना दिखयो मिंजो भरोसा करदे न।” ");
INSERT INTO bht_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","यीशुऐ होर भी चमत्कार चेलयां दे सामणे दस्से, जड़े इसा कताबां च नी लिखयो न। ");
INSERT INTO bht_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","पर ऐ इस तांई लिखयो न, ताकि तुसां भरोसा करन, की यीशु ही परमेश्वरे दा पुत्र मसीह है: कने उस पर भरोसा करी के उदे नाऐ ने तुहांजो हमेशा दी जिन्दगी मिल्ले। ");
INSERT INTO bht_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","इना गल्लां दे बाद यीशुऐ अपणे आपे जो तिबिरियास झिला दे बखे चेलयां जो दर्शण दिते कने इस तरीके ने दर्शण दिते। ");
INSERT INTO bht_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","शमौन पतरस कने थोमा जिसयो दिदुमुस बोलदे न, कने गलील प्रदेश दे काना शेहरे दा नतनएल कने जब्दी दे पुत्र, कने उदे चेलयां चे दो जणे होर गिठे होए थे। ");
INSERT INTO bht_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","शमौन पतरसे उना जो बोलया, मैं मछियां पकड़ना चलया है। उना उसला बोलया, “असां भी तेरे सोगी चलदे न।” तां सै निकली करी किस्तिया पर चढ़ी गे, पर उसा राती उना कुछ नी पकड़या। ");
INSERT INTO bht_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","अगले दिने ब्याग होंदे ही यीशु कनारे पर खड़ोतया था, पर चेलयां उसयो पछेणया नी की ऐ यीशु है। ");
INSERT INTO bht_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","तालू यीशुऐ उना जो बोलया, हे मेरे प्यारो, क्या तुहाड़े बाल कुछ खांणे जो है? उना जबाब दिता, “नी।” ");
INSERT INTO bht_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","यीशुऐ उना जो बोलया, “किस्तिया दे सजे पास्से जाल फेंका, तां मिलणियां।” तालू उना जाल फेंकया, कने हुण मछियां जादा होणे दिया बजा ने उना ला जाल नी खिची होया। ");
INSERT INTO bht_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","इस तांई उस चेले ने जिसने प्रभु प्यार रखदा था पतरसे जो बोलया, “ऐ तां प्रभु है।” जालू शमौने ऐ सुणया की प्रभु यीशु है, तां उनी अपणे सै कपड़े पाई ले जड़े उनी कम्म करदे बेले उतारी दितयो थे कने पाणिये च छाल देई दिती। ");
INSERT INTO bht_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","पर होर चेले डोंगिया पर मछियां ने भरूऐ जाले जो खिंज्जी लेई आऐ, क्योंकि सै कनारे ला जादा दूर नी थे, कोई सो मीटर दूर थे। ");
INSERT INTO bht_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","जालू सै कनारे पर पुज्जे, तां उना कोलयां दिया अग्गी पर मछियां कने उदे बखे रोटियां रखियां दिखियां। ");
INSERT INTO bht_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","यीशुऐ उना जो बोलया, “जड़ियां मछियां तुसां हुण पकड़िया न, उना चे थोड़िया लेई ओआ।” ");
INSERT INTO bht_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","शमौन पतरसे डोंगिया पर चढ़ी करी इकसो त्रियूँजा मछियां ने भरया जाल कनारे पर खिचया, कने इतणियां मछियां होंणे ने भी जाल नी फटया। ");
INSERT INTO bht_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","यीशुऐ उना जो बोलया, “ओआ रोटी खाई लिया।” कने चेलयां चे कुसयो भी होंसला नी होया, की उसला पूछन, तू कुण है? “क्योंकि सै जाणदे थे की ऐ प्रभु ही है।” ");
INSERT INTO bht_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","यीशुऐ रोटी लेईकरी उना जो दिती, कने तियां ही मच्छी भी दिती। ");
INSERT INTO bht_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ऐ तिजी बरी है की यीशुऐ मरी करी जिंदा होणे बाद चेलयां जो दर्शण दिते न। ");
INSERT INTO bht_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","रोटी खाणे बाद यीशुऐ शमौन पतरसे जो पुछया, हे यूहन्ना दे पुत्र शमौन, क्या तू सच्ची इना बाकियां ला जादा मिंजो ने प्यार करदा है? उनी यीशुऐ जो बोलया, हां प्रभु; तू तां जाणदा है, की मैं तिजो पर भरोसा रखदा है, उनी उना जो बोलया, “मेरे छेलुआं दी रखबाली कर।” ");
INSERT INTO bht_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","यीशुऐ फिरी दूजी बरी उसयो पुछया, “हे यूहन्ना दे पुत्र शमौन, क्या तू मिंजो ने प्यार रखदा है?” उनी उसयो बोलया, “हाँ, प्रभु तू तां जाणदा हे की मैं तिजो ने प्यार करदा है?” उनी उसयो बोलया, “मेरियां भेडां दा पुआल बण।” ");
INSERT INTO bht_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","यीशुऐ तीजी बरी उसयो पुछया, “यूहन्ना दे पुत्र शमौन, क्या तू मिंजो ने प्यार करदा है?” पतरस उदास होई गिया, की उनी उसयो तीजी बरी ऐसा बोलया, “क्या तू मिंजो ने प्यार करदा है।” कने उनी बोलया, “प्रभु जी, तू तां सब कुछ जाणदा है की मैं तिजो ने प्यार करदा है।” यीशुऐ उसला बोलया, “मेरियां भेडां जो चुगा।” ");
INSERT INTO bht_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“मैं तुसां ने सच्च-सच्च बोलदा है, जालू तू जवान था, तां अपणे लक्के जो बन्नी करी जिथू चांदा था, ओथु गुमदा था; पर जालू तू बुडा होइ जाणा, तां तू अपणे हथां जो फेलांगा, कने कोई तिजो बन्नी लेंगा कने तिजो ओथु लेई जाणा जिथू तू जाणा नी चांदा।” ");
INSERT INTO bht_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","यीशुऐ ऐसा ऐ दसणे तांई बोलया की पतरसे कियां मरणा कने परमेश्वरे दी महिमा करणी है; ऐ बोली करी, उसयो बोलया, “मेरा चेला बणी रे।” ");
INSERT INTO bht_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पतरसे मुड़ी करी उस चेले जो पिच्छे ओंदे दिखया जिसने यीशु प्यार रखदा था। ऐ सै ही है जिनी फसह दी रोटी खाणे बेले यीशुऐ बखे बेईकरी पुछया था, “प्रभु जी, तिजो पकड़ाणे बाला कुण है?” ");
INSERT INTO bht_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","उसयो दिखीकरी पतरसे यीशुऐ जो बोलया, “प्रभु जी, इदे सोगी क्या होणा है?” ");
INSERT INTO bht_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","यीशुऐ उसयो बोलया, “अगर मैं चां की सै मेरे ओंणे दीकर जिन्दा रे, तां तिजो क्या? तू मेरा चेला बणी रे।” ");
INSERT INTO bht_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","तांई तां भाईयां च ऐ गल्ल फेली गेई की उनी दुज्जे चेले नी मरणा है; तमी यीशुऐ उसयो ऐ नी बोलया, की इनी नी मरणा है, पर ऐ की “अगर मैं चां की ऐ मेरे ओणे दीकर जिन्दा रे, तां तिजो इसला क्या?” ");
INSERT INTO bht_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","जिनी माणुऐ ऐ सब कुछ दिखया, उनी ऐ गबाई दिती है, ताकि तुसां भी यीशु पर भरोसा करी सकन। कने उदी गबाई सच्ची है। कने असां जाणदे न की सै सच्चाईया ने बोलदा है। ");
INSERT INTO bht_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","यीशुऐ होर भी मते कम्म किते, अगर उना सारे कम्मा जो लिखया जांदा, तां मिंजो लगदा की सारे संसार च इतणी भी जगा नी होणी थी की उना सारियां कताबां जो रखी सके।");
INSERT INTO bht_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","प्रिय थियुफिलुस, मैं अपणिया पेलिया कताबा च उना सारियां गल्लां दे बारे च दसया है, जड़ियां यीशुऐ स्वर्ग च जाणे ला पेहले करणा कने सिखाणियां शुरू कीतियां। ");
INSERT INTO bht_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","पर परमेश्वरे दे जरिये यीशुऐ जो स्वर्गे च चुकणे ला पेहले, यीशुऐ दुख झेले कने मरी गिया। उनी मते पक्के सबुतां ला उनी अपणे आपे जो जिन्दा दसया, कने चालियां रोजां दीकर सै उना चुणयां चेलयां जो मिलदा रिया, कने परमेश्वरे दे राज्य दियां गल्लां करदा रिया। यीशुऐ पबित्र आत्मा दिया सहायता ला प्रेरितां जो हुकम दिता कने उदे बाद परमेश्वरे उसयो स्वर्गे च चुकी लिया। ");
INSERT INTO bht_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","इक बरी यीशुऐ चेलयां ला मिली करी उना जो हुकम दिता की, “यरूशलेमे शेहरे ला बाहर मत जांदे, पर उस दान दी नियाल रखा जड़ा मेरे पिता परमेश्वरे तुहांजो देंणे दा बायदा कितया था, तुसां मिंजो उदे बारे च पेहले भी बोलदे सुणया है। ");
INSERT INTO bht_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","यूहन्ने तां पांणिऐ ला बपतिस्मा दितया है, पर थोड़े रोजा बाद परमेश्वरे तुहाड़े सोगी रेणे तांई पबित्र आत्मा जो भेजणा।” ");
INSERT INTO bht_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","बादे च जालू प्रेरित दोबारा यीशुऐ जो मिल्ले, तां उना यीशुऐ जो पुछया, “प्रभु जी, क्या तू हुण ही इस बकत इस्राएले जो रोमियां दी गुलामी ला अजाद करणे कने साड़े राज्य जो फिरी ला बसाणे दी योजना बणा दा है?” ");
INSERT INTO bht_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","यीशुऐ उना जो बोलया, “ऐ सारियां चिंजा कालू होणियां कने कुस बकत होणियां, ऐ सब कुछ तय करणे दा हक सिर्फ मेरे पिता परमेश्वर जो है, ऐ सब कुछ जाणने दी तुहांजो जरूरत नी है। ");
INSERT INTO bht_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","पर जालू पबित्र आत्मा तुहाड़े पर ओंणा तालू तुहांजो शक्ति मिलणी; कने यरूशलेम शेहरे च कने सारे यहूदिया कने सामरिया प्रदेशां च, कने संसारे दियां हर जगा दे लोकां मेरे बारे च गबाही देंणी है।” ");
INSERT INTO bht_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ऐ बोली करी उना दे दिखदे-दिखदे ही परमेश्वर यीशुऐ जो स्वर्गे च लेई गिया, कने इक बदले दिया बजा ला सै उसयो दिखी नी सके। ");
INSERT INTO bht_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","उदे जांदे बेले जालू सै अम्बरे पासे दिखा दे थे, तां अचानक दो माणु चिट्टे कपड़े पाई करी उना बखे प्रगट होए। ");
INSERT INTO bht_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","कने बोलणा लग्गे, “हे गलीली प्रदेशे दे माणुआं, तुसां कजो खड़ोई करी अम्बरे पास्से दिखा दे न? ऐई यीशु, जिसयो परमेश्वर स्वर्गे लेई गिया है, जियां तुसां उसयो स्वर्गे जांदे दिखया तियां ही उनी फिरी ओंणा है।” ");
INSERT INTO bht_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ऐ सारियां गल्लां जैतुन नाऐ दे पहाड़े पर होईयां जड़ा यरूशलेम शेहरे ला लगभग इक किलो मीटर दिया दुरिया पर था कने प्रेरित पहाड़े ला यरूशलेम शेहरे जो बापस आई गे। ");
INSERT INTO bht_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","कने जालू प्रेरित शेहरे च पुज्जे तां सै उपरे बाले कमरे च गे, जिथू सै रे दे थे। जड़े प्रेरित ओथु मोजूद थे सै ऐ न पतरस कने यूहन्ना कने याकूब कने अन्द्रियास कने फिलिप्पुस कने थोमा कने बरतुल्मै कने मत्ती कने हलफईऐ दा पुत्र याकूब, शमौन जड़ा क्रान्तिकारी था कने याकूब दा पुत्र यहूदा थे। ");
INSERT INTO bht_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ऐ सारे हमेशा गिठे होंदे थे कने सारे इक मन होईकरी लगातार प्राथना करदे थे। उना चे यीशु दे भाई कने यीशुऐ माता मरियम कने कुछ जनानियां भी थियां जिना यीशुऐ दी सहायता कितियो थी। ");
INSERT INTO bht_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","कने उना रोजां च इक रोज, जालू लगभग इक सौ बी मसीह भाई बेहण गिठे थे, तां पतरस उना दे बिच खड़ोई करी बोलणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","हे मसीह भाईयो बेहणो, पबित्र आत्मा बड़े पेहले राजा दाऊदे दे जरिये यहूदा दे बारे च दसया था, जिनी यीशुऐ जो गिरफ्तार करणे बालयां दी अगुवाई किती। ऐ जरूरी था की यहूदा दे बारे च पबित्र शास्त्रे च लिखया लेख पूरा हो। ");
INSERT INTO bht_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","बेशक यहूदा सांझो चे इक था, कने इसा सेवकाईया च भी हिस्सेदार बणया। ");
INSERT INTO bht_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","जियां की तुसां जाणदे न की उस पेसे ला जड़े यहूदा यीशुऐ जो चलाकिया ला पकड़ाणे तांई लियो थे, उनी उस पेसे ला इक खेतर लिया। जालू यहूदा फा लेई लिया तां सै थल्ले सिरे भार पेई गिया कने उदा पेट फटी गिया, कने उदियां सारियां आंतड़ियां बाहर आई गियां। ");
INSERT INTO bht_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","कने इसा गल्ला दे बारे च यरूशलेम शेहरे दे सारे लोकां जो पता लगी गिया, इस तांई सै लोक उस जगा जो अपणी भाषा च हलकदमा मतलब की खूने दा खेतर बोलणा लगी पे। ");
INSERT INTO bht_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","क्योंकि राजा दाऊदे भजन संहिता दिया कताबा च लिखया है, “उदा घर उजड़ी जा कने उस घरे च कोई नी बसे,” कने राजा दाऊदे दुज्जी जगा च ऐ भी लिखया है की, “उदी जगा कोई होर लेई ले।” ");
INSERT INTO bht_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","इस तांई ऐ जरूरी है की प्रभु यीशु जो मरयां चे जिन्दे होणे दा, साड़े सोगी गबाह बणने तांई इक माणुऐ जो चुणयां जा। सै माणु ऐसा होणा चाईदा जड़ा प्रभु यीशु दे सारे कम्मा दे बकते च मतलब की प्रभु यीशु जो यूहन्ना ला बपतिस्मा लेणे ला लेईकरी उसयो स्वर्गे च जाणे दीकर साड़े सोगी था। ");
INSERT INTO bht_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","तालू उना दों जणयां जो खरेड़या इक यूसुफे जो, जिसयो बरसब्बास बोलदे न, जिदा दुआ ना युसतुस है, कने दुआ मत्तियाह जो। ");
INSERT INTO bht_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","कने ऐ बोली करी प्राथना किती, “प्रभु जी, तू तां सारयां दे मना जो जाणदा है, ऐ प्रगट कर की इना दों जणयां चे तू कुण चूंणया है, ");
INSERT INTO bht_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","की सै इस सेबा दे कम्मे जो कने उस प्रेरित दी सै खाली जगा ले, जिसा जगा जो यहूदा छडी करी चली गिया जिथू उसयो जाणा चाईदा।” ");
INSERT INTO bht_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","तालू उना दोनो दे बारे च चिठियां पाईयां, कने चिठ्ठी मत्तियाह दे नाऐ दी निकली, कने सै उना गयारां प्रेरितां दे सोगी गिणया गिया। ");
INSERT INTO bht_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","जालू यहूदियां दे पिन्तेकुस्ते त्योहारे दा दिन आया, तां सारे भरोसा करणे बाले इकी जगा पर गिठे थे। ");
INSERT INTO bht_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","तालू अचानक अम्बरे ला इक अबाज सुणोई, सै अबाज तेज होआ सांई थी, कने उसा ने सारा घर जिथू सै बैठयो थे गूंजी पिया। ");
INSERT INTO bht_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","तालू उना दे सामणे अग्गी सांई चीजां दा झुण्ड प्रगट होया जड़ा जीभा दे अकारे दा लगा दा था, जड़ा लग होईकरी उना चे हर इक माणुऐ पर रुकदी गेई। ");
INSERT INTO bht_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","कने सै सारे पबित्र आत्मा ला भरुई गे, कने जियां ही पबित्र आत्मा उना जो बोलणे दी शक्ति दिती, सै होर-होर भाषा च बोलणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","उस बकत परमेश्वरे दा डर मनणे बाले केई यहूदी थे, जड़े की संसारे दे हर इक देशे ला त्योहारे मनाणे तांई आयो थे कने यरूशलेम शेहरे च रेंदे थे। ");
INSERT INTO bht_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","जालू उस तेज होआ दी अबाज होई थी तां भीड़ लगी गेई कने लोक हेरान होई गे, क्योंकि हर इक अपणी-अपणी भाषा च चेलयां जो बोलदे सुंणा दे था। ");
INSERT INTO bht_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","कने सै सारे हेरान होईकरी बोलणा लग्गे, “दिखा, ऐ जड़े लोक इस तरिके ला बोला दे न ऐ गलील प्रदेशे दे बासी न।” ");
INSERT INTO bht_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","तां ऐ क्या होआ दा है, जड़ा सांझो चे हर इक जणा इना जो अपणी-अपणी बोली च गल्लां करदे होये सुंणा दे है! ");
INSERT INTO bht_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","असां चे कुछ लोक पारथी इलाके ला न; कने कुछ मेदी कने कुछ लोक एलामी कने मेसोपोटामिया कने यहूदिया प्रदेशे कने कप्पदूकिया कने पुन्तुस कने आसिया प्रदेश, ");
INSERT INTO bht_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","कने फ्रूगिया कने पंफूलिया कने मिस्र देश कने लीबिया देशे कुछ इलाकयां दे न। जड़े कुरेने शेहर दे बखे न, कने इना सारे देशां दे रेणेबाले कने रोम शेहर ला ओणे बाले लोक, ");
INSERT INTO bht_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","मतलब की क्या यहूदी, कने क्या ही होर जातियां दे लोक जिना यहूदी धर्म अपनाई लिया था, क्रेती टापू दे लोक कने अरबी देश दे लोक भी न, पर अपणिया-अपणिया बोलिया च उना ला परमेश्वरे दे चमत्कारी कम्मा दी चर्चा सुणदे न। ");
INSERT INTO bht_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","कने सै सारे हेरान होए, कने उना जो समझ नी ओआ दा था की क्या होआ दा है। ");
INSERT INTO bht_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","पर केईयां मजाक करदे होऐ बोलया, “सै तां नोईया शराबा दे नशे च न।” ");
INSERT INTO bht_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","पतरस उना गयारां प्रेरितां सोगी खड़ोता, कने जोरे ला बोलणा लग्गा, “तुसां लोक जड़े साड़े सांई यहूदी न कने यरूशलेम शेहरे दे बासियों, मेरियां गल्लां ध्याने ला सुंणा मैं तुहांजो दसदा है की इसा घटना दा क्या मतलब है। ");
INSERT INTO bht_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","तुहांजो लगदा है की असां नशे च न, पर असां नशे नी न क्योंकि हले तां ब्यागा दे नौ बजे न। ");
INSERT INTO bht_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","पर ऐ चमत्कार जड़ा साड़े सोगी होया है, ऐ उसा गल्ला जो पूरा करदा है, जड़ी योएल परमेश्वरे दा संदेश देणेबाले दे जरिये पबित्र शास्त्र च परमेश्वरे बोलियो है: ");
INSERT INTO bht_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","परमेश्वर बोलदा है की, ‘आखरी दिना च ऐसा होणा है, की मैं अपणी आत्मा सारे माणुऐ जो देणी है कने तुहाड़े पुत्रां कने कुड़ियां भविष्यवांणियां करणियां, कने तुहाड़े जवाना दर्शण दिखणे कने तुहाड़े बुड्डे मर्दां सुपने दिखणे।’ ");
INSERT INTO bht_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","उना दिना च मैं अपणे नोकरां कने नोकरांणियां जो अपणी आत्मा देणी, कने उना भविष्यबांणी करणी। ");
INSERT INTO bht_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","कने मैं उपर अम्बरे च अनोखे कम्म, कने थले धरतिया पर चमत्कार, मतलब की खून कने अग्ग कने धूंऐ दे बदल दसणे। ");
INSERT INTO bht_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","प्रभु दा दिन ओणे ला पेहले सूरजे नेहरा होई जाणा कने चांदे खूने सांई होई जाणा। सै दिन महान कने तेजस्वी दिन होणा। ");
INSERT INTO bht_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","कने जड़ा कोई प्रभुऐ दा ना लेंगा, उदा उद्धार होणा।” ");
INSERT INTO bht_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","हे इस्राएल दे लोको इना गल्लां जो सुंणा: परमेश्वरे नासरत दे यीशु मसीह दे जरिये चमत्कार कने अनोखे कम्म किते कने तुसां अपु जाणदे न की ऐ सच्च है। इयां करिरी परमेश्वरे तुसां जो दसया की यीशु परमेश्वरे दा भेजया माणु है। ");
INSERT INTO bht_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","उसयो ही, जालू सै परमेश्वरे दी बणाईयो योजना कने पेहले ला ही ज्ञाने दे अनुसार पकड़ाया गिया, तां तुसां उसयो बुरे लोकां दे हथां ला किल्लां ठोकी करी सूली पर चढ़ाई करी मारी दिता। ");
INSERT INTO bht_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","फिरी भी परमेश्वरे उसयो मरणे दे बाद फिरी ला जिन्दा करी दिता। यीशु मरी गिया था पर परमेश्वरे उसयो मुर्दा रेणे ला बचाई लिया क्योंकि उदे तांई मरया रेणा संभव नी था। ");
INSERT INTO bht_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","क्योंकि राजा दाऊद यीशुऐ दे बारे च बोलदा है, “मैं प्रभु जो हमेशा अपणे सामणे दिखदा रिया क्योंकि सै मेरे सजे पास्से है, ताकि मैं उना लोकां ला नी डरें जड़े मिंजो नुक्सान पूजाणा चांदे न। ");
INSERT INTO bht_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","मेरा मन बड़ा खुश होया, कने मैं खुशिया ला बोलदा है; कने मेरे शरीरे जो भी आस लग्गी रेंणी। ");
INSERT INTO bht_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","क्योंकि तू मिंजो मुर्दा नी रेणा देणा। कने ना ही अपणे पबित्र जण दिया लाशा जो सड़ना देणा। ");
INSERT INTO bht_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","तू मिंजो जिन्दगिया दा रस्ता दसया है; तू मिंजो अपणिया मोजुदगी च खुशिया ला भरी देणा।” ");
INSERT INTO bht_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“हे मसीह भाईयो, मैं उस कुलपति राजा दाऊदे दे बारे च पुरिया हिम्मता ला बोली सकदा है की सै मरी गिया है कने दबया भी है कने उदी कबर अजे दीकर भी साड़े बिच है। ");
INSERT INTO bht_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","सै परमेश्वरे दा संदेश देणेबाला भी था, कने सै जाणदा था की परमेश्वरे मिंजो ने कसम खाई करी बायदा कितया है, ‘मैं तेरे बंशे चे इकी माणुऐ जो तेरे सिंहासने पर बठांगा।’” ");
INSERT INTO bht_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ऐ जाणी करी की भविष्य च परमेश्वर क्या करणा जा दा था, राजा दाऊदे यीशु मसीहे जो मरणे बाद जिन्दा होणे दी गल्ल किती है। उनी बोलया ना तां उनी उसयो मुर्दा रेणा दिता, कने ना ही अपणे पबित्र जण दिया लाशा जो सड़ना दिता। ");
INSERT INTO bht_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","इसी यीशुऐ जो परमेश्वरे जिन्दा किता, जिदे असां सारे गबाह न। ");
INSERT INTO bht_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","हुण सै स्वर्गे च परमेश्वरे दे सजे हथे सबना ला बड्डे इज्जता दे पदे पर बैठया है। कने पिता परमेश्वरे जदिया उसला बायदा कितया था, उनी अपणा पबित्र आत्मा यीशुऐ जो दिता कने यीशुऐ उदारता ला सै पबित्र आत्मा सांझो दिता है, जियां की तुसां अज दिखदे कने सुणदे न। ");
INSERT INTO bht_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","क्योंकि राजा दाऊद यीशु मसीह सांई शरीरे च स्वर्गे पर नी चढ़या; पर सै अपु ही बोलदा है, प्रभु परमेश्वरे मेरे प्रभु ला बोलया; मेरे सजे पास्से बैठ, ");
INSERT INTO bht_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","जालू दीकर मैं तेरे दुशमणा जो तेरे पैरां थले दिया चौंकिया सांई नी बणाई दें। ");
INSERT INTO bht_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","इस तांई इस्राएले दे सारे लोक इसा गल्ला दे बारे च पका ही जाणी लेन: की परमेश्वरे इसी यीशुऐ जो जिसयो तुसां सूली पर चढ़ाया, उसयो प्रभु भी कने मसीह भी बणाया। ");
INSERT INTO bht_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","जालू लोकां ऐ सुणया तां उना अपणे आपे जो दोषी महसूस किता, कने सै पतरस कने बाकी प्रेरितां ला पूछणा लग्गे, “हे मसीह भाईयों, असां क्या करन?” ");
INSERT INTO bht_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पतरसे उना जो बोलया, “मन बदला, कने तुसां सारे अपणे-अपणे पापां दी माफी तांई यीशु मसीह दे नाऐ ला बपतिस्मा लिया; तां तुसां जो पबित्र आत्मा दा दान मिलणा। ");
INSERT INTO bht_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","क्योंकि ऐ प्रतिज्ञा तुसां, कने तुहाड़िया ओलादा कने उना सारे दुरे-दुरे दे लोकां तांई भी है जिना जो साड़े प्रभु परमेश्वरे अपणे बाल सदया।” ");
INSERT INTO bht_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पतरसे होर भी मतियां गल्लां दी गबाई देईकरी उना जो समझाया कने बिनती किती की अपणे इस्राएली साथियां सांई मत बणा जड़े परमेश्वरे पर भरोसा नी करदे कने परमेश्वरे ला बिनती करा की सै तुहांजो बचाए। ");
INSERT INTO bht_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","कने जड़ा कुछ पतरसे बोलया, उस पर जिना भरोसा किता कने उना बपतिस्मा लिया; कने उसी दिने लगभग तिन जार माणु उना ने शामिल होई गे। ");
INSERT INTO bht_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","कने सै प्रेरितां ला शिक्षा लेंणे च, उना सोगी संगती रखणे च, प्रभु भोज कने प्राथना करणे च लीन रेंणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","कने प्रेरित जड़े अनोखे कम्म कने अनोखे चमत्कार करदे थे, इना ला यरूशलेम शेहर दे लोक डरे कने हेरान होए। ");
INSERT INTO bht_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","कने सै सारे भरोसा करणे बाले गिठे रेंदे थे, कने जड़ा कुछ भी उना बाल होंदा था सै सब कुछ सांझा करदे थे। ");
INSERT INTO bht_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","कने सै अपणिया-अपणिया जगा जमिना कने समाने जो बेची करी जदेई जिसयो जरूरत होंदी थी उसयो बंडी दिन्दे थे। ");
INSERT INTO bht_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","कने सै हर रोज इक मन होईकरी मंदरे च गिठे होंदे थे, कने रोटी खाणे तांई कने प्रभु भोज तांई इक दुज्जे दे घरे साफ मने ला खुशिया ला गिठे होंदे थे। ");
INSERT INTO bht_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","कने परमेश्वरे दी स्तुति करदे थे, कने सारे लोक उना ला खुश थे; कने जिना दा उद्धार होंदा था, उना जो प्रभु हर रोज उना च मिलाई दिन्दा था। ");
INSERT INTO bht_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","इक दिन पतरस कने यूहन्ना दोपहर दे तिन बजे प्राथना दे बेले मंदरे जो चलयो थे। ");
INSERT INTO bht_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","कने लोक इकी जन्म ला ही लंगड़े जो लोआ दे थे, जिसयो सै रोज ही मंदरे दे उस दरबाजे बाल बैठाई दिन्दे थे जिसयो सुंदर दरबाजा बोलदे न, ताकि सै मंदर जाणे बालयां ला भीख मंगी सके। ");
INSERT INTO bht_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","जालू उनी पतरस कने यूहन्ना जो मंदरे च जांदे दिखया, तां उनी उना ला भीख मंगी। ");
INSERT INTO bht_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","पतरसे कने यूहन्ने उदे पास्से ध्याने ला दिखीकरी बोलया, “साड़े पास्से दिख।” ");
INSERT INTO bht_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","सै उना ला कुछ मिलणे दी आसा च उना पास्से दिखणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","तालू पतरसे बोलया, “चांदी कने सोना तां साड़े बाल है नी, पर जड़ा मेरे बाल है सै तिजो दिन्दा है; नासरत दे यीशु मसीह दे नाऐ ला उठ कने चल फिर।” ");
INSERT INTO bht_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","कने पतरसे उदा सजा हथ पकड़ी करी उसयो उठाया; कने झट उदे पैरा कने गोडयां च जोर आई गिया। ");
INSERT INTO bht_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","कने सै उछली करी खड़ोई गिया, कने चलणा फिरणा लगी पिया; कने चलदा, कने छलांगा मारदे परमेश्वरे दी स्तुति करदा होया उना सोगी मंदरे दे अंगणे च गिया। ");
INSERT INTO bht_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","सारे लोकां उसयो चलदे फिरदे कने परमेश्वरे दी स्तुति करदे दिखीकरी, ");
INSERT INTO bht_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","उसयो पछेणी लिया की सै ही लंगड़ा भिखारी है, जड़ा मंदरे दे सुंदर दरबाजे पर बेईकरी भीख मंगदा था; कने इसा घटना ला जड़ी उदे सोगी होईयो थी, बड़े हेरान होऐ। ");
INSERT INTO bht_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","सै उस ओसारे च थे जिसयो सुलैमान दा ओसारा बोलदे न, कने सै लंगड़ा भिखारी जड़ा ठीक होई गिया था सै पतरस कने यूहन्ने दा साथ नी छडा दा था। सै सारे लोक उना पासे दौड़े कने उसयो दिखीकरी बड़े हेरान होए। ");
INSERT INTO bht_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ऐ दिखीकरी पतरसे लोकां जो बोलया, हे इस्राएलियां, तुसां इस माणुऐ पर कजो हेरान होआ दे, कने साड़े पास्से कजो घुरा दे न, जियां मन्ना की असां ही अपणिया भक्तिया कने शक्तिया ने इसयो चलणे फिरणे जोगा बणाई दितया है। ");
INSERT INTO bht_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","साड़ा परमेश्वर कने जड़ा अब्राहम, इसहाक, याकूब, कने साड़े पूर्वजां दा भी परमेश्वर है उनी अपणे सेवक यीशुऐ दी महिमा किती, पर तुसां यीशुऐ जो मरवाणे तांई रोमी अधिकारियां बाल पकड़ाई दिता, कने जालू पिलातुसे उसयो छडणे दा बिचार किता, तालू तुसां उदे सामणे यीशुऐ जो नकारी दिता। ");
INSERT INTO bht_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","तुसां यीशु मसीह जो नी अपनाया, जड़ा पबित्र कने धर्मी था। कने तुसां पिलातुसे ला चांदे थे की इक हत्यारे जो तुहाड़े तांई छडी दिया। ");
INSERT INTO bht_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","कने तुसां उसयो जड़ा हमेशा दी जिन्दगी दिन्दा है मारी दिता, पर परमेश्वरे उसयो फिरी ला जिन्दा किता, कने इसा गल्ला दे असां गबाह न। ");
INSERT INTO bht_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","यीशुऐ दे नाऐ पर भरोसा करणे दे जरिये ही इस माणुऐ जो ताकत मिल्ली है, जिसयो तुसां जाणदे न कने हुण तुहाड़े सामणे है। ऐ यीशु दा ना है कने जड़ा भरोसा उदे जरिये ओंदा है जिनी उसयो बिलकुल ठीक-ठाक करी दितया है, जियां की तुसां अपु भी दिखी सकदे न। ");
INSERT INTO bht_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","कने हे भाईयो, मैं जाणदा है की जालू तुसां कने तुहाड़े अगुवां यीशु मसीह जो मारी दिता तालू तुसां उदे बारे च अनजाण थे की सै कुण था। ");
INSERT INTO bht_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","पर जिना गल्लां जो सारे परमेश्वरे अपणे संदेश देणेबाले दे जरिये पेहले ही दसया था, की उदे मसीह जो दुख होणा कने सै मारी देणा है; तुहाड़े जरिये परमेश्वरे इना गल्लां जो पूरा करी के दसया। ");
INSERT INTO bht_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","इस तांई मन बदला कने परमेश्वर बाल बापस ओआ ताकि तुहाड़े पाप मिटी जान, तालू परमेश्वरे दिया तरफा ला आत्मिक शान्ति दा बकत ओणा। ");
INSERT INTO bht_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","कने उनी यीशुऐ जो भेजणा, जड़ा सै मसीह है जिसयो परमेश्वरे तुहाड़े तांई चुणया है। ");
INSERT INTO bht_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","यीशुऐ दा स्वर्गे च रेणा उस बेले दीकर जरूरी है जालू परमेश्वर उना सारियां चिंजा जो नोआ बणाई दींगा जड़ियां उनी बणाईयां न। बड़े बकत पेहले परमेश्वरे लोकां जो ऐ दसणे तांई पबित्र परमेश्वरे दे संदेश देणेबाले दे जरिये ऐसा करणे दा बायदा किता। ");
INSERT INTO bht_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","जियां की मूसा बोलया, “प्रभु परमेश्वरे तुहाड़े भाईयां चे तुहाड़े तांई मिंजो सांई इक परमेश्वरे दा संदेश देणेबाला भेजणा,” जड़ा कुछ सै तुसां ने बोलगा, उदी सुणनयो। ");
INSERT INTO bht_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","पर हर इक माणु जड़ा उस परमेश्वरे दा संदेश देणेबाले दी नी सुणे, लोकां चे उदा नाश होई जाणा। ");
INSERT INTO bht_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","कने शमूएल ला लेईकरी उदे बाद बालयां दीकर जितणे भी परमेश्वरे दे संदेश देणेबालयां ऐ गल्ल बोली उना सारयां इना दिना दा संदेश दितया है। ");
INSERT INTO bht_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","तुसां सारे परमेश्वरे दे संदेश देणेबालयां दी ओलाद कने उस बायदे दे हिस्सेदार न, जड़ा परमेश्वरे तुहाड़े पूर्वजां ला किता, जालू उनी अब्राहमे जो बोलया, “तेरे खानदाने ला धरतिया दे सारे घरानया जो आशीष मिलणी।” ");
INSERT INTO bht_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","जालू परमेश्वरे अपणे सेवक यीशुऐ जो चुणया, कने उनी उसयो सबना ला पेहले तुसां इस्राएली लोकां बाल भेजया, ताकि परमेश्वर तुसां चे हर इक जणे जो पाप दे रस्ते ला दुरे करिरी आशीष दे। ");
INSERT INTO bht_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","जालू पतरस कने यूहन्ना लोकां जो ऐ बोला दे थे, तां याजक कने मंदरे दे रखबालयां दा सरदार कने सदूकी उना बाल आऐ। ");
INSERT INTO bht_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","क्योंकि सै बड़े गुस्सा होऐ की पतरस कने यूहन्ना लोकां जो यीशुऐ दे बारे च सिखान्दे थे, की जड़े लोक मरी गियो न परमेश्वरे उना जो फिरी जिन्दा करी देणा, जियां उनी यीशुऐ जो मरयां चे फिरी जिन्दा करी दिता। ");
INSERT INTO bht_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","कने उना पतरस कने यूहन्ना जो गिरफ्तार करी अगले रोजे दीकर जेला च रखया क्योंकि संज होई गियो थी। ");
INSERT INTO bht_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","पर संदेश सुणने बालयां चे मतयां यीशुऐ पर भरोसा किता, उना भरोसा करणे बाले माणुआं दी संख्या लगभग पंज हजार होई गेई। ");
INSERT INTO bht_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","अगले रोजे उना दे सरदार कने यहूदी अगुवे कने व्यवस्था जो सिखाणे बाले यरूशलेम शेहर च इकी जगा पर गिठे होए। ");
INSERT INTO bht_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","कने जड़े लोक ओथु गिठे होए उना चे महायाजक हन्ना कने सारे महायाजके दे घराने दे लोक, जिना चे कैफा, यूहन्ना, सिकन्दर भी ओथु थे। ");
INSERT INTO bht_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","कने पतरस कने यूहन्ना जो बिच खरेड़ी करी पूछणा लग्गे, “इस माणुऐ जो ठीक करणे तांई कुनी शक्ति कने हक दिता?” ");
INSERT INTO bht_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","तालू पतरसे पबित्र आत्मा ला भरुई करी उना जो बोलया, “हे लोकां दे सरदारो कने यहूदी अगुवां, ");
INSERT INTO bht_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","असां इक कमजोर माणुऐ दी भलाई किती है, कने अज सांझो ला इदे बारे च पूछताछ करा दे न, की सै कियां ठीक होया। ");
INSERT INTO bht_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","तां तुसां सब कने सारे इस्राएले दे लोक जाणी लिया की ऐ नासरत दे यीशु मसीह दे नाऐ ला ठीक होया है। इसी यीशुऐ जो तुसां सूली पर चढ़ाया था, पर परमेश्वरे उसयो मरयां चे जिन्दा किता। अज उसी दे नाऐ ने ऐ माणु तुहाड़े सामणे भला चंगा खड़ोतया है। ");
INSERT INTO bht_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","यीशु मसीह सै ही पथर है जिसयो तुसां मिस्त्रियाँ फेंकी दितया था कने सेई पथर कुंणे दा सिरा बणी गिया। ");
INSERT INTO bht_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","यीशु जो छडी करी होर कुसी दुज्जे ला उद्धार नी है; क्योंकि स्वर्गे दे हेठ माणुऐ चे कोई होर दुआ ना नी दितया है, जिसला असां उद्धार पाई सकन।” ");
INSERT INTO bht_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","जालू उना पतरसे कने यूहन्ना दी हिम्मत दिखी, कने उना जो ऐ पता लग्गा की ऐ पढ़यो लिखयो नी न कने आम माणु न, फिरी उना जो ऐहसास होया, ऐ इस तांई है क्योंकि ऐ यीशुऐ सोगी थे। ");
INSERT INTO bht_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","पर उस माणुऐ जो जड़ा खरा होया था, पतरस कने यूहन्ना सोगी खड़ोतया दिखीकरी, सै सभा उना दे खिलाफ कुछ नी बोली सकी। ");
INSERT INTO bht_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","पर उना जो महासभा ला बाहर जाणे दा हुकम देईकरी, सै अपु चे बिचार बिमर्श करणा लग्गे, ");
INSERT INTO bht_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“असां इना माणुऐ सोगी क्या करन? क्योंकि ऐ तां साफ है की इना ऐ अदभुत चमत्कार कितया है कने सारे यरूशलेम शेहर दे रेणे बालयां जो पता है, कने असां ऐ दाबा नी करी सकदे की ऐ गल्ल नी होइयो है। ");
INSERT INTO bht_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","पर लोकां च ऐ गल्ल होर जादा नी फेलणा चाइदी, असां इना जो धमकाने, की ऐ इसी नाऐ ला फिरी कुसी माणुऐ ने गल्ल ना करन।” ");
INSERT INTO bht_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","तालू उना पतरस कने यूहन्ना जो सदया कने चेताबनी देईकरी बोलया, “यीशुऐ दे नाऐ ला कुछ नी बोलणा कने ना सिखाणा।” ");
INSERT INTO bht_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","पर पतरस कने यूहन्ने उना जो जबाब दिता, “तुसां ही न्याय करा, की क्या ऐ परमेश्वरे दिया नजरा च ठीक है, की असां परमेश्वरे दिया गल्लां ला बड़ी करी तुहाड़ियां गल्लां मनन? ");
INSERT INTO bht_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","क्योंकि ऐ तां सांझो ला होई नी सकदा, की जड़ा असां दिखया कने सुणाया है, सै ना बोलन।” ");
INSERT INTO bht_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","तालू उना पतरस कने युहन्ना जो दुबारा धमकाया कने छडी दिता। ऐ प्रेरित लोकां बिच मशहूर थे इसा बजा ला उना जो इना प्रेरितां जो सजा देंणे दा कोई तरिका नी मिला, इस तांई की जड़ी घटना होईयो थी उदिया बजा ला सारे लोक परमेश्वरे दी बड़ाई करदे थे। ");
INSERT INTO bht_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","सै माणु, जड़ा अदभुत चमत्कारे ला ठीक होया था, उदी उम्र चाली सालां ला जादा थी। ");
INSERT INTO bht_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","पतरस कने यूहन्ना छुटी करी अपणे साथियां बाल आये, कने जड़ा कुछ बड्डे याजकां कने यहूदी अगुवां उना ने बोलया था, उना जो सुणाई दिता। ");
INSERT INTO bht_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ऐ सुणीकरी, उना इक मन होईकरी उच्चिया अबाज ला परमेश्वरे ला प्राथना किती, “हे प्रभु, तू ही है जिनी स्वर्ग कने धरती कने समुंद्रे कने जड़ा कुछ उना च है बणाया है।” ");
INSERT INTO bht_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","तू पबित्र आत्मा ला अपणे सेवक कने साड़े पूर्वज राजा दाऊदे दे मुऐ ला बोलया, “होरनी जातियां कजो गुस्सा किता? कने देशां-देशां दे लोकां कजो बेकार गल्लां सोचियां? ");
INSERT INTO bht_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","कने राजा दाऊदे ऐ भी बोलया था की, धरतिया दे राजयां अपणे आपयो तैयार करणा, कने हाकिमा, प्रभु कने उदे मसीह दे बिरोध च गिठे होणा।” ");
INSERT INTO bht_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","कने ऐ गल्ल यरूशलेम शेहरे च सच्च होई की तेरे पबित्र सेवक यीशुऐ दे खिलाफ, जिदा तू अभिषेक किता, राजा हेरोदेसे कने पुन्तियुस पिलातुस राज्यपाल भी होर जातियां कने इस्राएलियां सोगी इसी शेहरे च गिठे होए, ");
INSERT INTO bht_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","उना सेई कितया जड़ा तेरिया शक्तिया कने इच्छा पेहले ही तय करी लिया था की होणा चाईदा। ");
INSERT INTO bht_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","प्रभु जी हुण, उना दियां धमकियां जो सुण कने अपणे दासां जो ऐ बरदान दे की तेरा बचन बड़िया हिमतां ने सुणान। ");
INSERT INTO bht_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","कने ठीक करणे तांई अपणा हथ गां कर ताकि चमत्कार कने अनोखे कम्म तेरे पबित्र सेबक यीशु दे नाऐ ला होन। ");
INSERT INTO bht_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","जालू सै प्राथना करी बैठे, तां सै जगा जिथू सै गठुयो थे हिली पेई, कने सै सारे पबित्र आत्मा ला भरुई गे, कने परमेश्वरे दा बचन हिम्मता ने सुणादे गे। ");
INSERT INTO bht_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","भरोसा करणे बालयां दी मंडली इक चित कने इक मने दे थे, उना दा सब कुछ साझे दा था कने ऐथू दीकर की कोई भी अपणिया धन दौलता पर अपणा होणे दावा नी करदा था। ");
INSERT INTO bht_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","कने प्रेरित बड़िया शक्तिया ला प्रभु यीशुऐ दे मरी करी जिन्दा होणे दी गबाई दिन्दे रे कने उना सारयां पर परमेश्वरे दा बड़ा अनुग्रह था। ");
INSERT INTO bht_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","कने उना चे कोई भी गरीब नी था, क्योंकि जिना बाल जमीन या घर थे, सै उना जो बेची करी, बिकियां चिजां दे पैसे लोंदे थे कने उसयो प्रेरितां बाल जमा करवाई दिन्दे थे। ");
INSERT INTO bht_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","कने जदेई जिसयो भी जरूरत होंदी थी उसयो बंडी दिन्दे थे। ");
INSERT INTO bht_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","कने यूसुफ नाऐ दा इक माणु था, सै लेवी गोत्र दा था कने साइप्रस टापू ला था। जिदा ना प्रेरितां बरनबास रखया, जिदा मतलब ऐसा माणु जड़ा दुजयां जो प्रोत्साहित करदा है। ");
INSERT INTO bht_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","उदे बाल कुछ जमीन थी, जिसा जो उनी बेचया, कने सै पैसे लोकां जो बंडणे तांई प्रेरितां जो देई दिते। ");
INSERT INTO bht_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हनन्याह नाऐ दे इकी माणुऐ, कने उदिया घरे बालिया सफीरा अपणिया जमिना दा छोटा दिया हिस्सा बेचया। ");
INSERT INTO bht_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","कने हनन्याये जो जड़े पैसे बेची करी मिल्ले उदे चे उनी कुछ अपणे तांई रखी लिया; कने ऐ गल्ल उदी घरे बाली भी जाणदी थी कने उना बाकी बचयो पैसे प्रेरितां जो देई दिते। ");
INSERT INTO bht_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","पर पतरसे बोलया, “हे हनन्याह! जड़ा शैताने तेरे मने च पबित्र आत्मा ला झूठ बोलणे दा बिचार पाया है कने तू अपणी बेचियो जमिना दे पैसे चे इक हिस्सा अपणे तांई रखी लिया है?” ");
INSERT INTO bht_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","क्या बेचणे ला पेहले सै जमीन तेरी नी थी? कने जालू जमीन बिकी गेई तां उसा दी कीमत क्या तेरे बशे च नी थी? तिजो इस बुरे कम्मे दे बारे च कदी नी सोचणा चाईदा था! तू सांझो ला नी, पर परमेश्वरे ला झूठ बोलया। ");
INSERT INTO bht_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ऐ गल्लां सुणदे ही हनन्याह जमिना पर पेई गिया, कने सै मरी गिया; कने जिना भी इस बारे च सुणया सै सारे डरी गे। ");
INSERT INTO bht_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","फिरी जवान माणु आऐ कने उसयो कफन च लपेटया करी कने बाहर लेईजाई करी दबी दिता। ");
INSERT INTO bht_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","लगबग तिन घंटे बाद उदी घरे बाली अंदर आई, ओथु जड़ा कुछ होया था उसा जो नी पता था। ");
INSERT INTO bht_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","तालू पतरसे उसा जो बोलया, “क्या तुसां दोना सै जमीन इतणे च ही बेचियो थी?” उना बोलया, “हाँ, इतणे च ही।” ");
INSERT INTO bht_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","पतरसे उसा जो बोलया, “ऐ क्या गल्ल है, की तुसां दोना प्रभुऐ दिया आत्मा जो परखने तांई इक सलाह कितयो है? दिख, जिना जवान माणुआं तेरे घरे बाले जो दबया है सै दरबाजे बार खड़ोतयो न, कने इना तिजो भी बाहर लेई जाणा।” ");
INSERT INTO bht_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","तालू सै झट जमिना पर पेई गेई, कने मरी गेई, कने उना जवान माणुआं अंदर आई करी दिखया तां सै मरी गियो थी, कने उना उसा जो बाहर लेईजाई करी उसा दे घरे बाले दे बखे दबाई दिता। ");
INSERT INTO bht_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","कने कलीसिया दे सारे लोक कने जितणयां इना गल्लां जो सुणया सै बड़े डरी गे। ");
INSERT INTO bht_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","प्रेरित मते चिन्न कने अदभुत कम्म लोकां दे बिच करदे थे, कने जड़े मसीह च भरोसा करणे बाले थे। सै अक्सर सारे इक चित होईकरी सुलैमाने दे ओसारे च गिठे होंदे थे। ");
INSERT INTO bht_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","पर जिना हल्ले दीकर यीशुऐ पर भरोसा नी कितया था उना चे कुसयो भी ऐ हिम्मत नी होंदी थी की, उना सोगी जाई मिलन; फिर भी लोक उना दी बड़ी इज्जत करदे थे। ");
INSERT INTO bht_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","कने प्रभु पर भरोसा करणे बाले मर्दां कने जनानियां दी गिणती बददी ही गेई। ");
INSERT INTO bht_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","जड़ा कुछ प्रेरित करा दे थे उसा बजा ला लोक बिमारां जो सड़का पर आंणी करी, मंझे कने पन्दी पर सुआई दिन्दे थे, ताकि जालू पतरस उस रस्ते ला जांगा, तां उदा प्रछोंआ उना चे कुसकी पर पेई जा। ");
INSERT INTO bht_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","कने यरूशलेम शेहरे दे अखे बखे दे नगरां दे लोक भी गिठे होंदे थे। कने सै बिमारां कने बुरियां आत्मा ला सताऐ लोकां जो लोंदे थे, कने सै सारे ठीक होई जांदे थे। ");
INSERT INTO bht_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","तालू महायाजक कने सारे यहूदी अगुवां दी टोली जिना जो सदूकी बोलदे न दे, सै प्रेरितां ला जलन करणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","तां अगुवां मंदरे दे रखबालयां जो हुकम दिता की प्रेरितां जो पकड़ी करी जेला च बंद करी दिया। ");
INSERT INTO bht_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","पर राती दे बकत प्रभु दे इकी स्वर्गदूते जेला दे दरबाजे खोली करी उना जो बाहर कडया कने प्रेरितां जो बोलया, ");
INSERT INTO bht_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“जा कने मंदरे च खड़े होईकरी, लोकां जो इस हमेशा दिया नोईया जिन्दगिया दा पूरा संदेश सुणा।” ");
INSERT INTO bht_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","कने प्रेरित बड़ी ब्यागा ही मंदरे च गे जियां उना जो स्वर्गदूते दसया था जाई करी सिखाणा शुरू किता। जालू महायाजक कने उदे साथी आऐ कने उना महासभा जो कने इस्राएलियां दे सारे यहूदी अगुवां जो गिठा किता, कने जेला च बोली भेजया की प्रेरितां जो लोआ। ");
INSERT INTO bht_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","पर मन्दरे दे रखबालयां ओथु पुजिकरी दिखया की सै जेला च नी न, कने उना बापस आई करी दसया, ");
INSERT INTO bht_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“जेल ढंगे ला बंद थी, कने बाहर दरबाजे पर पेहरेदार खरेड़यो थे, पर जालू असां दरबाजा खोलया, तां अंदर कोई नी था।” ");
INSERT INTO bht_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","जालू मंदरे दे रखबालयां दे सरदारां कने बड्डे याजकां ऐ खबर सुणी, तां हेरान होई गे कने उलझन च पेई गे की इदा क्या नतीजा होणा। ");
INSERT INTO bht_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","इतणे च कुनकी आई करी उना जो दसया, “दिखा, जिना जो तुसां जेला च बंद कितया था, सै माणु मंदरे च खड़ोई करी उपदेश देद न।” ");
INSERT INTO bht_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","जालू उना ऐ सुणया, तालू मंदरे दे रखबालयां दा सरदार कुछ रखबालयां जो सोगी लेईकरी मंदरे च गिया, कने प्रेरितां जो पकड़ी करी महासभा च लेई आया, पर उना सोगी कोई जोर जबरदस्ती नी किती, क्योंकि रखबाले लोकां ला डरा दे थे की लोक पथर मारी-मारी करी उना जो मारी ना देन। ");
INSERT INTO bht_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","जालू उना प्रेरितां जो महासभा दे सामणे खरेड़या तालू महायाजके उना ला पुछया, ");
INSERT INTO bht_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“क्या असां तुहांजो हुकम नी दितया था, की तुसां इस नाऐ ला शिक्षा मत दिन्दे? फिरी भी, तुसां सारे यरूशलेम शेहरे जो अपणिया शिक्षा ला भरी दिता है कने तुसां उस माणुऐ दी हत्या दा दोष जबरदस्ती सांझो पर लांणा चांदे न।” ");
INSERT INTO bht_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","तालू पतरसे कने, बाकियां प्रेरितां जबाब दिता, “माणुऐ दे हुकमे ला बदीकरी परमेश्वरे दे हुकमे जो मनणा ही साड़ा कम्म है। ");
INSERT INTO bht_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","साड़े पूर्वजां दे परमेश्वरे यीशुऐ जो मरयां चे जिन्दा करी दिता, जिसयो तुसां सूली पर लटकाई करी मारी दितया था। ");
INSERT INTO bht_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","उसयो ही परमेश्वरे प्रभु कने उद्धार करणे बाला बणाया है, कने अपणे सजे हथे ने सारयां ला उच्चे सिंहासने पर बेठाया है, ताकि इस्राएले दे लोक अपणे बुरे सोच बिचार कने बुरे रस्तयां जो छडी करी परमेश्वरे बाल मुड़ी ओन कने उदे जरिये उना जो अपणे पापां दी माफी मिल्ले। ");
INSERT INTO bht_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","असां कने पबित्र आत्मा भी इना गल्लां दे गबाह न, जिसा जो परमेश्वरे उना जो दितया है, कने जड़े उदा हुकम मंदे न।” ");
INSERT INTO bht_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","जालू महासभा दे लोकां ऐ सुणया तां उना जो बड़ा जादा गुस्सा आई गिया, कने प्रेरितां जो मारी देणा चांदे थे। ");
INSERT INTO bht_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","पर गमलीएल नाऐ दा इक फरीसी था, जड़ा व्यवस्था जो सिखाणे बाला कने सारे लोक उसयो बड़ा मंदे थे, उनी महासभा च खड़ाई करी प्रेरितां जो थोड़िया देरा तांई बाहर करी देंणे दा हुकम दिता। ");
INSERT INTO bht_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","तालू उनी महासभा दे लोकां जो बोलया, “हे इस्राएलियो, जड़ा कुछ भी इना माणुऐ ला करणा चांदे न सोची समझीकरी करनयो। ");
INSERT INTO bht_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","क्योंकि इना रोजां ला पेहले थियुदास ऐ बोलदा था, की मैं भी कुछ है; कने कोई चारसो माणु उदे सोगी होई गे, पर सै मारी दिता, कने जितणे लोक उदी मंदे थे सारे तितर बितर होई गे कने खत्म होई गे। ");
INSERT INTO bht_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","उदे बाद जनगणना दे दिना च गलील प्रदेशे दा बासी यहूदा आया, कने कुछ लोक अपणे पासे करी ले, सै भी मरी गिया, कने जितणे लोक उदे चेले थे, सारे लोक तितर बितर होई गे। ");
INSERT INTO bht_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","इस तांई तां मैं हुण तुसां जो बोला दा है, इना माणुऐ ला दूर ही रिया कने उना ला कोई कम्म मत रखा; क्योंकि अगर ऐ कम्म कने योजना माणुऐ दिया तरफा ला होंदी तां इना अपणे आप ही खत्म होई जाणा; ");
INSERT INTO bht_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","पर अगर परमेश्वरे दिया तरफा ला है, तां तुसां कदी नी मिटाई सकणा है, कुथी इयां ना हो की तुसां परमेश्वरे ला लड़ने बाले बंणन।” ");
INSERT INTO bht_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","तालू महासभा गमालिएल दी गल्ल मनी लेई, कने इस तांई प्रेरितां जो सदीकरी मारया कुटया; कने उना जो ऐ हुकम दिता की सै हुण यीशुऐ दे नाऐ च कुछ मत बोलदे कने फिरी उना जो छडी दिता। ");
INSERT INTO bht_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","कने जालू सै महासभा जो छडी करी चली गे, तालू प्रेरित इसा गल्ला ला खुश होए की परमेश्वरे उना जो यीशुऐ तांई बेइजत होणे जोगे समझया। ");
INSERT INTO bht_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","कने हर रोज मंदरे च कने घरे-घरे च, प्रेरित लोकां जो सिखांदे रे कने शुभसमाचार दा प्रचार करदे रे की यीशु ही मसीह है। ");
INSERT INTO bht_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","उना रोजां च चेलयां दी गिणती लगातार बदा दी थी, तालू यूनानी बोली बोलणे बाले यहूदी विश्वासी इब्रानी बोली बोलणे बाले यहूदी विश्वासियां दे खिलाफ शिकायत करणा लग्गे, की रोज खाणा कने पैसे बंडदे बकते यूनानी बिधवां जो सबना सांई खाणा कने पैसे नी दिन्दे। ");
INSERT INTO bht_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","तालू बाहरां प्रेरितां यरूशलेम शेहर दे बाकी चेलयां दी मंडलिया जो अपणे बाल सदीकरी बोलया, “असां प्रेरितां जो अपणा बकत परमेश्वरे दा बचन सिखाणे च लाणा चाईदा, ना की खुआणे पियांणे दी सेबा करणे च। ");
INSERT INTO bht_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","इस तांई हे मसीह भाईयो, अपणे चे सत्त ऐसे माणुआं जो चुणा जिना दे बारे च सब जाणदे न की सै पबित्र आत्मा ने कने अकला ने भरुयो न, ताकि असां ऐ जिम्मेदारी उना जो देई देंन। ");
INSERT INTO bht_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","पर असां तां प्राथना, बचन दा प्रचार कने शिक्षा देणे च लगी रेन।” ");
INSERT INTO bht_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ऐ गल्ल सारिया मंडलिया जो खरी लग्गी, कने उना स्तिफनुस नाऐ दे इक माणुऐ जो जड़ा भरोसे कने पबित्र आत्मा ला भरुई गिया था, कने फिलिप्पुस कने प्रुखुरुस कने निकानोर कने तीमोन कने परमिनास कने अन्ताकिया बासी नीकुलाउस जो जड़ा यहूदी धर्मे च आई गिया था, इना जो चुणी लिया। ");
INSERT INTO bht_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","कने इना जो सै प्रेरितां दे सामणे लेई आये कने उना तांई प्राथना किती कने उना पर हाथ रखीकरी उस कम्मे तांई नियुक्त किता। ");
INSERT INTO bht_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","कने परमेश्वरे दा बचन फेलदा गिया कने यरूशलेम शेहरे च चेलयां दी गिणती बददी गेई, कने केई यहूदी याजकां भी यीशु मसीह पर भरोसे दे इस संदेशे जो मन्नी लिया। ");
INSERT INTO bht_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तिफनुस अनुग्रह कने शक्तिया ला भरुई करी लोकां च बड्डे-बड्डे अनोखे कम्म कने चमत्कार दसदा था। ");
INSERT INTO bht_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","पर कुछ लोक जड़े उस यहूदी जंज घरे दे थे, जिसयो गुलाम मुक्त यहूदी जंज घर बोलदे थे, सै स्तिफनुसे दे खिलाफ होई गे। कने इना चे कुछ लोक कुरेने कने सिकंदरिया दे शेहरां ला आयो थे, कने कुछ लोक किलिकिया प्रदेश कने आसिया प्रदेश ला आयो थे। ऐ लोक स्तिफनुसे सोगी बेहस करणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","स्तिफनुसे जड़ा कुछ भी बोलया सै उदा जबाब नी देई सके क्योंकि पबित्र आत्मा उसयो बड़ी ही समझा ला बोलणे च सहायता किती। ");
INSERT INTO bht_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","इस तांई गुलाम मुक्त लोकां छुपके ला केई मर्दां जो रिश्वत देईकरी स्तिफनुसे दे बारे च झूठ बोलणे तांई भड़काया, “की असां इसयो मूसा कने परमेश्वरे दे खिलाफ च निंदा करदे सुणाया है।” ");
INSERT INTO bht_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","कने उना स्तिफनुसे दे खिलाफ लोकां जो, यहूदी अगुवां जो, कने व्यवस्था जो सिखाणे बालयां जो भड़काया कने उना आई करी स्तिफनुसे जो पकड़या कने उसयो महासभा दे सामणे लेई आये। ");
INSERT INTO bht_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","कने ओथु जूठे गबाह पेश किते, जिना स्तिफनुसे पर ऐ इलजाम लाया, “ऐ माणु इस पबित्र मन्दिर कने मूसा दिया व्यवस्था दे खिलाफ बोलणा नी छडदा है। ");
INSERT INTO bht_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","क्योंकि असां इसयो ऐ बोलदे सुणाया है, की नासरत बासी यीशुऐ इस मंदरे जो ढाई देणा है, कने रीती रिबाजां जो बदली देणा है जड़े मूसा सांझो दितयो न।” ");
INSERT INTO bht_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","तालू सारयां लोकां जड़े महासभा च बैठयो थे, उदे पासे घुरी करी दिखया तां उदा मु स्वर्गदूते दे मुऐ सांई चमका दा था। ");
INSERT INTO bht_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","तालू महायाजके स्तिफनुसे ला पूछया, “क्या ऐ इलजाम सच्च न?” ");
INSERT INTO bht_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","उनी बोलया, “हे भाईयों कने पितरो सुंणा, साड़े पूर्वज अब्राहम जो हारान ग्रां च आई करी बसणे ला पेहले जालू सै मेसोपोटामिया प्रदेश च था; कने तेजोमय परमेश्वरे उसयो दर्शण दिते। ");
INSERT INTO bht_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","कने उसयो बोलया, ‘तू अपणे देशे कने अपणे रिश्तेदारां ला निकली करी उसी देशे जो चली जा, जिसयो मैं तिजो दसगा।’ ");
INSERT INTO bht_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","तालू सै कसदियों दे देशे ला निकली करी हारान ग्रांऐ च जाई बसया; कने उदे पिता दिया मौता दे बाद परमेश्वरे उसयो ओथु ला आंणी करी इस देशे च बसाया जिदे च हुण तुसां बसदे न, ");
INSERT INTO bht_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","पर परमेश्वरे उसयो ऐथू विरासत च कुछ नी दिता, ऐथू दीकर की इक फुट जगा भी नी दिती, कने उस बेले उदी कोई ओलाद भी नी थी। फिर भी परमेश्वरे बायदा किता, की मैं ऐ देश तेरे कने तेरे बाद तेरे बंशे दे हथे दिंगा।” ");
INSERT INTO bht_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","कने परमेश्वरे ऐ भी बोलया, तेरे बंशे दे लोक पराये देशे च परदेशी होणे, कने उना लोकां उना जो गुलाम बणाई लेणा, कने चारसो सालां दीकर उना सोगी बुरा बर्ताब करणा। ");
INSERT INTO bht_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","फिरी परमेश्वरे बोलया, “जिसा जातियां दे उना गुलाम होणा है, उना जो मैं सजा देणी, कने उना उस देशे ला निकली करी इसी इस्राएल च मेरी भक्ति करणी।” ");
INSERT INTO bht_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","कने परमेश्वरे अब्राहम सोगी इक बायदा किता कने उसने बोलया की सै अपणे घरे दे सारे मर्दां दा खतना बायदे दे चिन्ह दे तौर पर करबाऐ; कने बादे च जालू इसहाक पैदा होया, तां अठमे रोजे उदा खतना किता, कने इसला बाद ऐ परमपरा चलदी रेई कने इसहाक ला याकूब कने याकूब ला साड़े बारा पूर्वज पैदा होऐ। ");
INSERT INTO bht_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","जलन दिया बजा ने यूसुफे दे भाईयां उसयो मिस्र देशे जाणे बालयां जो इक गुलाम दे रुपे च बेची दिता, पर परमेश्वर उदे सोगी था। ");
INSERT INTO bht_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","कने परमेश्वरे यूसुफे जो उदे सारियां मुसीबतां ला छुड़ाई करी मिसरे दे राजा फिरौन दे अग्गे अनुग्रह कने अकल दिती, कने फिरौन राजे उसयो मिस्र देशे पर कने अपणे सारे घरे दा अधिकारी बणाया। ");
INSERT INTO bht_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","जालू युसूफ मिस्र देशे दा गवर्नर था तालू सारे मिस्र कने कनान देशे च अकाल पिया; जिसने बड़ा भरी क्लेश होया, कने साड़े पूर्वजां जो खाणे जो नी मिलदा था। ");
INSERT INTO bht_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","पर याकूबे ऐ सुणाया, की मिस्र देशे च अनाज है, उना साड़े पूर्वजां जो अनाज लेणे तांई भेजया कने सै यूसुफे ने मिल्ले कने अनाज खरीदया पर उना यूसुफे जो नी पछेणया। ");
INSERT INTO bht_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","कने दुई बरी जालू सै अनाज लेणा गे, तां यूसुफ अपणे भाईयां जो दसया की मैं तुहाड़ा भाई यूसुफ है, कने यूसुफे दे परिबार दे बारे च फिरौन जो पता लग्गी गिया। ");
INSERT INTO bht_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","तालू यूसुफे अपणे पिता याकूब कने अपणे सारे रिश्तेदारां जो, जड़े पचतर माणु थे, उना जो मिस्र देश च ओणे तांई बुलाबा भेजया। ");
INSERT INTO bht_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","तालू याकूब मिस्र देश गिया; कने ओथु कुछ बकते बाद सै कने साड़े बाप दादे मरी गे। ");
INSERT INTO bht_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","कने उदे बंशज याकूब कने उदे पुत्रां दियां लाशां जो साड़े देश कनान च लेई गे, कने याकूब दिया लाशा जो उसा कबरा च दफनाया, जिसा जो अब्राहमे इक सही कीमता च खरीदया था, कने उना याकूब दे पुत्रां जो शकेम शेहरे दिया उसा जमिना च दफनाया, जिसयो याकूबे हामौर दे पुत्रां ला खरीदया था। ");
INSERT INTO bht_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","पर जालू उस बायदे जो पूरा होणे दा बकत नेड़े आया जड़ा परमेश्वरे अब्राहम ने कितया था, तां मिस्र देश च लोक बदी गे, कने मते सारे होई गे। ");
INSERT INTO bht_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","तालू मिस्र देश च दुआ राजा राज करणा लग्गा जड़ा यूसुफे जो नी जाणदा था। ");
INSERT INTO bht_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","उनी साड़िया जातियां सोगी चलाकी करिरी साड़े पूर्वजां ला इसा हदा दीकर बुरा व्यवहार कितया की, उना दे माता पिता जो अपणे बचयां जो फेंकणा पेई गिया ताकि सै मरी जान। ");
INSERT INTO bht_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","कने उस बेले मूसा पैदा होया, कने सै परमेश्वरे दिया नजरा च बडा ही छेल था; कने उसयो उना तिन मिहनयां दीकर उसयो उदे माता-पिता लुकाई करी पालया। ");
INSERT INTO bht_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","पर जालू सै उसयो होर जादा लुकाई नी सके, तां उना उसयो घरे बाहर रखी दिता कने तालू फिरौने दीया कुड़िया उसयो गोद लेई लिया, कने उसयो अपणे पुत्रे सांई पालया। ");
INSERT INTO bht_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","कने मूसा जो मिस्रियां दी सारी बिद्या पड़ाई, कने सै बड़ा ही प्रभाबशाली तरीके ने गल्लां कने कम्म करदा था। ");
INSERT INTO bht_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","जालू मूसा चालियां सालां दा होया, तां उदे मने च आया की अपणे इस्राएली रिशतेदारां ने मिल्ले। ");
INSERT INTO bht_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","कने उनी ओथु इक मिस्री माणुऐ जो इक इस्राएली माणुऐ सोगी बदसलूकी करदे दिखया, कने उसयो बचाया, कने मिस्री माणुऐ जो मारी करी उदा बदला लिया। ");
INSERT INTO bht_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","उनी सोचया, की मेरे भाईयां समझणा की परमेश्वरे मेरे हथे ने उना जो गुलामी ला अजाद करदा, पर उना नी समझया। ");
INSERT INTO bht_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","दुऐ रोजे मूसा दो इस्राएलियां बाल आया जड़े अपु चे लड़ा दे थे, कने उना बिच सुला कराणे तांई ऐ बोलया, की हे मर्दों, तुसां तां भाई-भाई न, तुसां कजो इकी दुऐ जो मारा दे न? ");
INSERT INTO bht_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","पर जड़ा अपणे पड़ोसीऐ जो मारा दा था, उनी मूसा जो धक्का दिता कने बोलया, तिजो कुनी सांझो पर राजा कने न्याय करणे बाला बणाया है? ");
INSERT INTO bht_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","क्या जियां कल तू मिस्र देशे दे माणुऐ जो मारी दिता क्या मिंजो भी मारणा चांदा है? ");
INSERT INTO bht_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ऐ गल्ल सुणीकरी, मूसा मिस्र देश ला नठया कने मिद्यान देशे च परदेसी बणी करी रेणा लग्गा: कने ओथु उदे दो पुत्र पैदा होए। ");
INSERT INTO bht_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","मिद्यान देशे च पुरे चाली साल रेहणे बाद, मूसा जो परमेश्वरे इक स्वर्गदूते दे रुपे च सीनै पहाड़े दिया सुनसान जगा च जलदिया झाड़िया दिया अग्गी बिच दर्शण दिते। ");
INSERT INTO bht_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","जालू मूसा उसा अग्ग लगियो झाड़िया जो दिखया जड़ी भस्म नी होआ दी थी, तां सै हेरान होया, कने जालू दिखणे तांई बखे गिया, तां प्रभु दी ऐ अबाज सुणोई, ");
INSERT INTO bht_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“मैं तेरे पूर्वज, अब्राहम, इसहाक कने याकूब दा परमेश्वर है, जिदी सै अराधना करदे थे।” तालू तां मूसा डरे ने कमी पिया, ऐथू दीकर की उसयो दिखणे दी हिम्मत नी रेई। ");
INSERT INTO bht_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","तालू प्रभुऐ उसयो बोलया, अपणे पैरां ला जुतयां उतारी दे, क्योंकि जिसा जगा तू खड़ोतया है, सै पबित्र जगा है। ");
INSERT INTO bht_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मैं सची अपणे लोकां दी दुर्दशा जो दिखया है, जड़ी मिस्र देश च है, कने उना दी तकलीफ कने उना दे रोणे जो सुणया है, इस तांई उना जो छुड़ाणे तांई उतरया है। हुण आ, मैं तिजो मिस्र देश च भेजणा। ");
INSERT INTO bht_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ऐ सै ही मूसा है जिसयो इस्राएलियां नकारी दितया था कने जिना बोलया, तिजो कुनी सांझो पर राजा कने न्याय करणे बाला बणाया है? उसयो ही परमेश्वरे राजा कने छुड़ाणे बाला बणाई करी, उस स्वर्गदूते दे जरिये भेजया जिनी उसयो झाड़िया च दर्शण दिते थे। ");
INSERT INTO bht_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","सै उना जो मिस्र देशे ला बाहर लेई आया कने उनी मिस्र देशे च कने लाल समुंद्रे पर कने सुनसान जगा च चालियां सालां दीकर अदभुत कम्म कने चिन्ह दस्से। ");
INSERT INTO bht_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ऐ सेई मूसा हे, जिनी इस्राएली लोकां जो बोलया, परमेश्वरे तुहाड़े भाईयां चे तुहाड़े तांई मिंजो सांई इक परमेश्वरे दा संदेश देणेबाला बणाणा है। ");
INSERT INTO bht_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","मूसा इक अगुवे दे रुपे च साड़े पूर्वजां दे सोगी था जालू सै सुनसान जगा च गिठे थे, तालू स्वर्गदूते सीनै पहाड़े पर मूसा ने गल्लां कितियां, कने ओथु मूसा जो जिन्दगी देणेबाले बचन मिल्ले कने उनी सै बचन सांझो दीकर पूजाऐ। ");
INSERT INTO bht_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","पर साड़े पूर्वज उदी मनणा नी चांदे थे; सै मने-मने च ही मिस्र देशे जो बापस जाणा चांदे थे, ");
INSERT INTO bht_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","कने उना मूसा दे भाई हारून ने बोलया, साड़े तांई ऐसा देवता बणा, जड़ा मिस्र देशे जो बापस जाणे तांई साड़े अग्गे-अग्गे चले; क्योंकि ऐ मूसा जड़ा सांझो मिस्र देशे ला कडी लेई आया है, असां नी जाणदे उसयो क्या होया है। ");
INSERT INTO bht_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","उना रोजां च उना इक बछड़े दी मूर्ति बणाई करी, उदिया मूर्तियां अग्गे बलि चढ़ाई, कने अपणे हथां दे कम्मा पर खुश होणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","फिरी परमेश्वरे उना जो अम्बरे दे तारे, चन्द्रमा, सूरजे जो अपणे देवतयां दे रुपे च पूजणे तांई छडी दिता, जियां परमेश्वरे दे संदेश देणेबालयां दीया कताबा च परमेश्वरे बोलया है, हे इस्राएल दे लोको, क्या तुसां सिर्फ मेरे तांई ही चालियां सालां दीकर सुनसान जगा च पशु बलि कने अन्नबली चड़ादें रे? ");
INSERT INTO bht_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","नही, तुसां उस तम्बूऐ जो डोता जिदे च तुहाड़े देवता मोलेक दी मूर्ति थी; कने तुसां अपणे देवता रिफान दे तारे जो चुकया, मतलब की उना मूर्तियाँ जो जिना जो तुसां भक्ति करणे तांई बणाया था। इस तांई मैं तुहांजो बाबेल देश च गुलाम बनाणा। ");
INSERT INTO bht_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","गबाई दा तम्बू रेगिस्तान च साड़े पूर्वजां बिच था; जियां की परमेश्वरे मूसा जो बोलया, जड़ा अकार तू दिखया है, उदे सांई इसयो बणा। ");
INSERT INTO bht_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","बड़े सालां बाद उसी तम्बूऐ जो साड़े पूर्वज यहोशुऐ सोगी ऐथू लेई आये। उस बकत ऐ देश होरनी जातियां दे हथे च था, पर परमेश्वरे उना जो साड़े पूर्वजां दे सामणे ला कडी दिता, कने सै तम्बू राजा दाऊदे दे बकते दीकर रिया। ");
INSERT INTO bht_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दाऊद पर परमेश्वरे अनुग्रह किता; दाऊदे याकूब दे परमेश्वरे जो रेहणे तांई मंदर बणाने दी बीनती किती। ");
INSERT INTO bht_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","पर जिनी परमेश्वरे दे मंदरे जो बणाया सै दाऊदे दा पुत्र सुलैमान था। ");
INSERT INTO bht_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","पर परमेश्वर हथा ने बणायो मंदरा च नी रेंदा है, जियां की यशायाह परमेश्वरे दे संदेश देणेबाले बोलया की, ");
INSERT INTO bht_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","परमेश्वर बोलदा है, स्वर्ग मेरा सिहांसन है कने धरती मेरे पैरां थल्ले दी चौंकी है, मेरे तांई तुसां कदिया मंदर बणांगे? कने मिंजो अराम करणे दी कुण देई जगा होणी? ");
INSERT INTO bht_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","मैं खुद स्वर्ग कने धरती दोनों जगा पर सब कुछ बणाया है। ");
INSERT INTO bht_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“हे जिदी लोको, तुसां परमेश्वरे दियां गल्लां मनणे कने सुणने ला मना करदे न, तुसां हमेशा पबित्र आत्मा दा बिरोध करदे न। जियां तुहाड़े पूर्वज करदे थे, तियां ही तुसां भी करदे न। ");
INSERT INTO bht_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","तुहाड़े पूर्वजां परमेश्वरे दे संदेश देणेबालयां चे हर कुसी जो सताया कने जिना ऐ भविष्यबांणी किती की मसीह जड़ा धर्मी है ओंणा है, उना जो भी मारी दिता, पर जालू मसीह आया, तां तुसां उसयो धोखा दिता कने उदी हत्या करी दिती। ");
INSERT INTO bht_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","तुहांजो स्वर्गदूते दी बणाईयो व्यवस्था तां मिली, पर उदा तुसां पालन नी किता।” ");
INSERT INTO bht_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ऐ गल्लां सुणीकरी यहूदी अगुवे स्तिफनुसे पर बड़े जादा गुस्सा होए कने स्तिफनुसे पर ददां जो पिणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","पर स्तिफनुसे पबित्र आत्मा ने भरुई करी स्वर्गे पासे दिखया कने परमेश्वरे दिया महिमा जो कने यीशुऐ जो परमेश्वरे दे सजे पासे खड़ोतया दिखीकरी, ");
INSERT INTO bht_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","बोलया, “दिखा, मैं स्वर्गे जो खुलया कने माणुऐ दे पुत्रे जो परमेश्वरे दे सजे पासे खड़ोतया दिखा दा है।” ");
INSERT INTO bht_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","जालू उना ऐ सब सुणया तालू उना जोरे ला चिलाया कने अपणे कना पर हथ रखी ले, ताकि सै स्तिफनुसे दी नी सुणन कने गिठे होईकरी स्तिफनुसे पर टूटी पे। ");
INSERT INTO bht_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","कने उसयो यरूशलेम शेहरे दे बाहर कडी करी पथर मारणा लग्गे, कने स्तिफनुसे पर इल्जाम लगाणे बाले लोकां अपणे बाहरे बाले कपड़े खोली करी शाऊले नाऐ दे जवान आदमिये बाल रखी दिते। ");
INSERT INTO bht_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","कने सै स्तिफनुसे जो पथर मारदे रे, कने सै ऐ बोली करी प्राथना करदा रिया, “प्रभु यीशु, मेरिया आत्मा जो लेई ले।” ");
INSERT INTO bht_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","फिरी गोडे भार बेईकरी जोरे ने पुकारया, “प्रभु जी, इस पापे तांई इना जो सजा मत दिन्दे।” कने ऐ बोली करी मरी गिया। ");
INSERT INTO bht_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","शाऊल स्तिफनुसे दिया हत्या च पूरा सहमत था। उसी रोजे ला यरूशलेम शेहरे दिया कलीसिया पर बड़ा जुल्म होणा लग्गा कने प्रेरितां जो छडी करी सारे दे सारे यहूदिया प्रदेशे च कने सामरिया प्रदेशां च तितर बितर होई गे। ");
INSERT INTO bht_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","कने कुछ मर्दां जड़े परमेश्वरे दी इज्जत करदे थे उना स्तिफनुसे जो दफनाई दिता, कने उदे तांई मते रोये। ");
INSERT INTO bht_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","शाऊल कलीसिया जो सता दा था, कने घरे-घरे जाई करी विश्वासी मर्दां कने जनानिया जो घसीटी-घसीटी करी जेलां च पाई दिन्दा था। ");
INSERT INTO bht_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","जड़े भरोसा करणे बाले तितर बितर होयो थे, सै जिथू कुथु भी गे लगातार शुभसमाचार सुणादे गे। ");
INSERT INTO bht_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","कने फिलिप्पुस सामरिया प्रदेशे दे इक शेहरे च जाई करी लोकां च मसीह दा प्रचार करणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","जालू उना फिलिप्पुसे जो बोलदे सुणया कने उदे कितयो चिन्हा जो दिखया, तां उना सारयां मिलिकरी उदे संदेशे जो ध्याने ला सुणया। ");
INSERT INTO bht_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","क्योंकि जालू फिलिप्पुसे हुकम दिता तां मतयां चे बुरियां आत्मा जोरे ने चिलांदियां होइयां निकली गियां कने मते लकवे दे रोगी कने लंगड़े भी ठीक होए। ");
INSERT INTO bht_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","तां उस शेहरे दे मते सारे लोक खुश होऐ। ");
INSERT INTO bht_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","उस शेहरे च इक शमौन नाऐ दा माणु था, कने सै काफी बकत ला सामरियां दे लोकां पर जादू टोंणा करा दा था, सै उदी काबिलियत ला बड़े हेरान थे, कने सै दावा करदा था की सै इक महान आदमी है। ");
INSERT INTO bht_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","कने सारे छोटयां ला लेईकरी बड्डे दीकर उसयो इज्जता ने बोलदे थे, “ऐ माणु परमेश्वरे दी सै शक्ति है, जिसयो महान बोलदे न।” ");
INSERT INTO bht_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","उनी मते रोजां ला उना जो अपणे जादूऐ दे कम्मा ने हेरान करी रखया था, तांई तां सै उसयो बड़े मंदे थे। ");
INSERT INTO bht_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","पर जालू लोकां परमेश्वरे दे राज्य कने यीशु मसीह दे ना दा शुभसमाचार फिलिप्पुस ला सुणया कने भरोसा किता, तालू सारे मर्दां कने जनानिया बपतिस्मा लिया। ");
INSERT INTO bht_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","तालू शमौने अपु भी फिलिप्पुसे दे शुभसमाचार पर भरोसा किता कने बपतिस्मा लेईकरी हर जगा फिलिप्पुसे सोगी जाणा लग्गा कने चमत्कार कने बड्डे-बड्डे कम्म होंदे दिखीकरी सै हेरान होंदा था। ");
INSERT INTO bht_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","जालू यरूशलेम शेहर च प्रेरितां सुणयां की सामरिया प्रदेश दे लोकां परमेश्वरे दा बचन मन्नी लिया है तां पतरसे कने यूहन्ना जो उना बाल भेजया। ");
INSERT INTO bht_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","कने उना ओथु जाई करी उना तांई प्राथना किती ताकि उना जो पबित्र आत्मा मिल्ले। ");
INSERT INTO bht_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","क्योंकि पबित्र आत्मा हले दीकर उना च कुसदे पर भी नी उतरया था, उना तां बस यीशुऐ दे नाऐ ने बपतिस्मा लिया था। ");
INSERT INTO bht_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","तालू पतरस कने यूहन्ने तिना पर हथ रखे कने उना जो पबित्र आत्मा मिल्ली। ");
INSERT INTO bht_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","जालू शमौने दिखया की प्रेरितां दे हथ रखणे ने पबित्र आत्मा मिलदी है, तां उनी पेसे देईकरी बोलया, ");
INSERT INTO bht_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ऐ शक्ति मिंजो भी दिया, ताकि मैं जिसदे पर हथ रखें, उसयो पबित्र आत्मा मिल्ले।” ");
INSERT INTO bht_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","पतरसे उसयो बोलया, “तू कने तेरे पैसे दोनों नाश होन, क्योंकि तू परमेश्वरे दा दान पैसयां ने खरीदणे दा बिचार किता। ");
INSERT INTO bht_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","इसा सेबा च ना तेरी हिस्सेदारी है, ना हिस्सा है; क्योंकि तेरा मन परमेश्वरे दे सामणे सच्चा नी है। ");
INSERT INTO bht_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","इस तांई तू अपणे मने ला इसा बुरिया सोचा जो कडी दे कने प्रभु ने प्राथना कर, तां होई सकदा प्रभु तेरी इसा बुरिया सोचा तांई तिजो माफ करे। ");
INSERT INTO bht_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","तू अपणे पापां ला पश्चाताप कर क्योंकि तू कड़वाट ने भरुया है कने पाप ने जकड़या होया है।” ");
INSERT INTO bht_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","शमौने जबाब दिता, “तुसां मेरे तांई प्राथना करा ताकि जड़ियां गल्लां तुसां बोलियां न, ऐसा कुछ भी मेरे सोगी न हो।” ");
INSERT INTO bht_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","पतरस कने यूहन्ना उस शेहरे च गबाई दिती कने प्रभु दे बचना दा प्रचार किता कने फिरी यरूशलेम शेहरे जो बापस चली गे। कने जांदे-जांदे बेले सामरिया प्रदेशे दे मतयां ग्रां च शुभसमाचार दा प्रचार किता। ");
INSERT INTO bht_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","फिरी प्रभु दे इकी स्वर्गदूते फिलिप्पुसे जो बोलया, “उठी करी दक्षिणे पासे उस रस्ते पर जा, जड़ा यरूशलेम शेहरे ला गाजा शेहर जो जांदा है, ऐ रेगिस्तानी रस्ता है।” ");
INSERT INTO bht_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","फिलिप्पुस उठी करी चली पिया, कने उसयो रस्ते च इक माणु मिल्ला सै इक खोजा कने कूशियों दी राणी कन्दाके दा मंत्री कने खजांची था, कने भक्ति करणे तांई यरूशलेम शेहर आया था। ");
INSERT INTO bht_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","कने सै रथे पर अपणे देशे जो बापस चलया था, कने परमेश्वरे दा संदेश देणेबाले यशायाह दी कताबा जो जोरे ने पढ़ा दा था। ");
INSERT INTO bht_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","तालू पबित्र आत्मा फिलिप्पुसे ने बोलया, “नेड़े होईकरी इसी रथे ने चली पो।” ");
INSERT INTO bht_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिप्पुस दोड़ी करी उस रथे बखे आया कने उसयो परमेश्वरे दा संदेश देणेबाले यशायाह दी कताबां जो पढ़दे सुणाया, तां उसला पुछया, “तू जड़ा पढ़ा दा है क्या उसयो समझदा भी है?” ");
INSERT INTO bht_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","उनी बोलया, “मैं इसयो नी समझी सकदा जालू दीकर मिंजो कोई इसयो समझांगा नी।” कने उनी फिलिप्पुसे ने बीनती किती की, रथे पर चढ़ी करी मेरे बखे बो। ");
INSERT INTO bht_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","पबित्र शास्त्रे दा जड़ा अध्याय सै पढ़ा दा था, सै ऐ था, “उसयो भेडां सांई मारणे तांई लेई गे, कने जियां मेमना ऊन कतरने बाले दे सामणे चुपचाप रेंदा है, तियां ही जालू लोकां उसयो दुख दिता तां उनी भी अपणा मु नी खोलया, ");
INSERT INTO bht_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","उदिया दीनता दिया बजा ला उदी बेईजती किती कने उसयो न्याय नी मिल्ला, शायद कोई भी उदे बंशजा दे बारे च नी दस्सी सकदा है, क्योंकि इदे ला पेहले की धरती पर उदा कोई बंश होंदा, लोकां उसयो मारी दिता।” ");
INSERT INTO bht_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","इसी पर खोजे फिलिप्पुसे ला पुछया, “मैं तिजो ने बिनती करदा है, मिंजो ऐ दस की परमेश्वरे दा संदेश देणेबाला कुसदे बारे च बोला दा है, अपणे या कुसी होरसी दे बारे च?” ");
INSERT INTO bht_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","तालू फिलिप्पुसे बोलणा शुरू किता, कने इस पबित्र शास्त्रे ला शुरू करिरी उसयो यीशुऐ दा शुभसमाचार सुणाया कने उनी खोजे ऐ गल्लां समझी लियां कने यीशुऐ पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","रस्ते च चलदे-चलदे सै कुसकी तलाबे बाल पुज्जे, तालू खोजे बोलया, “दिख ऐथू तलाब है, हुण मिंजो बपतिस्मा लेणे तांई क्या कमी है?” ");
INSERT INTO bht_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिप्पुसे बोलया, “अगर तू सारे मने ने भरोसा करदा है तां लेई सकदा है।” उनी जबाब दिता “मैं भरोसा करदा है की यीशु मसीह ही परमेश्वरे दा पुत्र है।” ");
INSERT INTO bht_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","तालू उनी रथ खरेड़ने दा हुकम दिता, कने फिलिप्पुस कने खोजा दोनो तलाबे दे पांणिऐ च उतरी गे, कने फिलिप्पुसे उसयो बपतिस्मा दिता। ");
INSERT INTO bht_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","जालू सै तलाबे ला निकली करी उपर आये, तां प्रभुऐ दी आत्मा फिलिप्पुसे जो चुकी लेई गेई, कने खोजे उसयो दोबारा नी दिखया, कने सै खुश होया की प्रभुऐ उसयो बचाया है कने अपणे देशे जो बापस चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","फिरी फिलिप्पुस अशदोह शेहर च प्रगट होया कने तालू ओथु ला यात्रा शुरू किती कने ग्रां-ग्रां च कने नगरां-नगरा च शुभसमाचार दा प्रचार करदा रिया जालू दीकर सै कैसरिया शेहरे च नी पूजी गिया। ");
INSERT INTO bht_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","शाऊल पर हले दीकर प्रभु यीशु दे चेलयां जो धमकांणे कने मारणे दा खून सबार था, इस तांई सै महायाजक बाल गिया। ");
INSERT INTO bht_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","कने उसला दमिश्क शेहरे दे यहूदी जंज घरा दे नाऐ पर अधिकार पत्र मंगे, की कोई भी मर्द कने जनानी जड़े यीशु मसीह दी शिक्षा जो मंदे न उना जो बन्नी करी यरूशलेम शेहर जो लेई ओंऐ। ");
INSERT INTO bht_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","पर जालू शाऊल कने उदे साथी दमिश्क शेहरे बखे पुज्जे, तां अचानक अम्बरे ला शाऊले दे चारो पासे इक लौ चमकी, ");
INSERT INTO bht_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","सै धरती पर पेई गिया, कने अबाज सुणी, जड़ी उसयो बोला दी थी, “हे शाऊल, हे शाऊल मिंजो कजो सता दा है?” ");
INSERT INTO bht_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","शाऊले पुछया, “प्रभु जी, तू कुण है?” उनी बोलया, “मैं यीशु है, जिसयो तू सता दा है।” ");
INSERT INTO bht_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","पर हुण उठी करी शहरे जो जा, कुनी तिजो दस्सी देणा, की तिजो क्या करणा है। ");
INSERT INTO bht_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","जड़े माणु उदे सोगी थे, चुपचाप रेई गे, क्योंकि उना जो अबाज सुणोंदी थी, पर कोई मिलदा नी था। ");
INSERT INTO bht_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","तालू शाऊल धरती ला उठया, पर जालू हखी खोलियां तां उसयो कुछ भी नी मिल्ला दा था कने सै उदा हथ पकड़ी करी दमिश्क शेहर लेई गे। ");
INSERT INTO bht_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","कने सै तिन्ना रोजां दीकर दिखी नी सकया, कने ना उनी कुछ खादा कने ना पीता। ");
INSERT INTO bht_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमिश्क शेहर च हनन्याह नाऐ दा इक चेला था, उसयो प्रभु यीशुऐ दर्शण च बोलया, हे हनन्याह। उनी बोलया, “हांजी प्रभु जी।” ");
INSERT INTO bht_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","तालू प्रभु यीशुऐ उसयो बोलया, “उठी करी सीधा नाऐ दिया गलिया च जा, कने यहूदा दे घरे शाऊल नाऐ दे इकी तरसुस शेहरे दे बासिये जो पूछी ले; क्योंकि सै प्राथना करा दा है, ");
INSERT INTO bht_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","उनी दर्शण च दिखया है की हनन्याह नाऐ दे इकी माणुऐ आई करी उस पर हथ रखे ताकि सै दोबारा दिखणा लग्गी पोऐ।” ");
INSERT INTO bht_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हनन्याह जबाब दिता, “प्रभु जी, मैं इस माणुऐ दे बारे च मतयां लोकां ला सुणया है, की इनी यरूशलेम शेहर च तेरे पबित्र लोकां सोगी बड़ा बुरा कितया है; ");
INSERT INTO bht_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","कने ऐथू भी इसयो बड्डे याजकां दिया तरफा ला हक मिलया है, की जड़े लोक तिजो पर भरोसा करदे न, उना जो बन्नी करी यरूशलेम शेहर जो लेई जा।” ");
INSERT INTO bht_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","पर प्रभुऐ उसयो बोलया, “तू चली जा; क्योंकि ऐ तां, मैं होरनी जातियां, कने राजयां, कने इस्राएलियां दे सामणे मेरे बारे च प्रचार करणे कने मेरी सेबा करणे तांई चूंणया है। ");
INSERT INTO bht_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","कने मैं उसयो दसणा है, की लोकां जो मेरे बारे च प्रचार करणे दिया बजा ला उसयो कदिया-कदिया दुख झेलणा पोंणा है।” ");
INSERT INTO bht_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","तालू हनन्याह उठी करी उस घरे च आया, जिथू शाऊल रे दा था, कने उदे पर अपणा हथ रखीकरी बोलया, “हे भाई शाऊल, प्रभु यीशुऐ मिंजो तेरे बाल भेजया है, जड़ा तिजो उस रस्ते च मिलया था, जालू तू ऐथू ओआ दा था। कने उनी मिंजो इस तांई भेजया ताकि तू फिरी दिखी सके, कने पबित्र आत्मा ने भरुई जाऐ।” ");
INSERT INTO bht_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","कने झट उदियां हखी ला छिलकयां सांई कुछ पिया, कने उसयो मिलणा लगी पिया, कने सै उठया कने उनी बपतिस्मा लिया, ");
INSERT INTO bht_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","फिरी खांणा खाई करी उसयो जोर आया। सै केई रोजां दीकर उना चेलयां सोगी रिया जड़े दमिश्क शेहर च थे। ");
INSERT INTO bht_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","कने झट दमिश्क शेहरे दे यहूदी जंज घरां च यीशुऐ दा प्रचार करणा लग्गी पिया, की यीशु ही परमेश्वरे दा पुत्र है। ");
INSERT INTO bht_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","कने सारे सुणनेबाले हेरान होईकरी बोलणा लग्गे, “क्या ऐ सेई माणु नी है, जड़ा यरूशलेम शेहरे च उना जो सतांदा था, जड़े लोक यीशु नाऐ दे बंदे पर भरोसा करदे थे, कने ऐथू भी तांई ही आया था, की उना लोकां जो बन्नी करी बड्डे याजकां बाल लेई जाऐ?” ");
INSERT INTO bht_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","पर शाऊल प्रचार करणे च होर भी जादा सामर्थी होंदा गिया, कने इसा गल्ला दा सबूत देई-देईकरी की यीशु ही मसीह है, दमिश्क शेहरे दे रेहणे बाले यहूदियां दा मु बंद करदा रिया। ");
INSERT INTO bht_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","जालू शाऊले जो दमिश्क शेहरे च रेंदे होए मते रोज होई गे, तां यहूदियां मिली करी उसयो मारणे दी तरकीब बणाई। ");
INSERT INTO bht_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","कने सै उसयो मारणे तांई दिन रात फाटकां पर इंतजार करदे रे, पर उना दी तरकीब शाऊले जो पता चली गेई। ");
INSERT INTO bht_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","इक राती चेले शाऊले जो पथरे दिया उचिया दिबारा पर लेई आऐ, जड़ी शेहरे दे चारो पासे बणियो थी। तालू उना दिबारां दे खुले हिस्से ला रस्सियां दे सहारे इक बडिया दिया टोकरिया च उसयो थले उतारी दिता। इयां करिरी सै दमिश्क शेहरे ला बची करी निकली गिया। ");
INSERT INTO bht_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","शाऊल यरूशलेम शेहरे जो गिया कने ओथु पुज्जी करी उनी चेलयां सोगी मिलणे दी कोशिश किती, पर सारे उसला डरदे थे, क्योंकि उना जो भरोसा नी होंदा था, की सै भी चेला है। ");
INSERT INTO bht_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","पर बरनबासे उसयो अपणे सोगी प्रेरितां बाल लेईजाई करी उना जो बोलया, की इनी कियां दमिश्क शेहर जाणे बाले रस्ते च प्रभु जो दिखया, कने प्रभु यीशुऐ उसला गल्लां कितियां; कने फिरी दमिश्क शेहरे च इनी कितणिया हिम्मता ला यीशुऐ दे नाऐ दा प्रचार किता। ");
INSERT INTO bht_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","प्रेरितां बरनबास पर यकीन किता, इस तांई शाऊल रुकी गिया कने उना सोगी यरूशलेम शेहरे दियां हर जगा पर गिया कने बिना डरयो यीशु मसीह दे बारे च प्रचार करदा था। ");
INSERT INTO bht_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","कने यूनानी बोली बोलणे बाले यहूदियां सोगी गल्ल बात कने बेहस करदा था; पर सै उसयो मारणे दी कोशिश करणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","तालू बाकी चेलयां जो इसा गल्ला दे बारे च पता चला तां सै शाऊले जो कैसरिया शेहरे च लेई आये, कने ओथु उना उदे तांई जहाजे ला तरसुस शेहर जांणे दा इंतजाम किता, जड़ा उदा अपणा शेहर था। ");
INSERT INTO bht_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","इयां सारे यहूदिया प्रदेश, कने गलील प्रदेश, कने सामरी प्रदेशां च कलीसिया जो चैन मिल्ला, कने सै मुजबुत होंदे गे, कने सै प्रभु यीशु मसीह दे डरे च जिन्दगी जिन्दे थे कने उना जो पबित्र आत्मा दे जरिये सहायता मिल्ली कने मतयां लोकां यीशु मसीह पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","फिरी इयां होया की पतरस हर प्रदेशे च फिरदा होया, इक रोज लुद्दा शेहरे च रेणेबाले पबित्र लोकां ला मिलणे तांई उना बाल पुज्जा। ");
INSERT INTO bht_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ओथु उसयो ऐनियास नाऐ दा इक लकवे दा रोगी माणु मिल्ला, सै अठां सालां ला मंजे पर पिया था। ");
INSERT INTO bht_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पतरसे उसयो बोलया, “हे ऐनियास। यीशु मसीह तिजो ठीक करदा है। उठ कने, अपणा बछाण चुक।” तालू सै झट उठी खड़ोता। ");
INSERT INTO bht_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","उसयो ठीक होया दिखीकरी सारे लुद्दा कने शारोन शेहरां दे सारे रेहणे बालयां प्रभु यीशुऐ पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","याफा शेहरे च इक तबीता नाऐ दी जनानी रेंदी थी, जड़ी यीशुऐ पर भरोसा करदी थी, जिसा दा यूनानी भाषा च ना “दोरकास” था। (जिदा मतलब की इक हिरण।) कने सै बड़े भरी भले कम्म कने गरीबां दी सहायता करदी थी। ");
INSERT INTO bht_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","उना रोजां च ही जालू पतरस लुद्दा शेहरे च था, तालू तबीता बीमार होईकरी मरी गेई, कने लोकां उसा जो नोहाई करी उपरे बाले कमरे च रखी दिता। ");
INSERT INTO bht_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लुद्दा शेहर याफा शेहर दे नेड़े था, चेलयां ऐ सुणीकरी की पतरस ओथु है तां दो माणु भेजी करी उसला बिनती किती की, “साड़े बाल ओंणे जो देर मत कर।” ");
INSERT INTO bht_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","तालू पतरस उठी करी उना सोगी चली पिया, कने जालू पुज्जी गिया, तां सै उसयो उसी उपरे बाले कमरे च लेई गे। कने सारियां बिधवा रोंदिया उदे बाल आईयां, कने जड़े कपड़े दोरकास उना सोगी रेंदे बणायो थे, उना जो दसणा लगियां। ");
INSERT INTO bht_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","तालू पतरसे सारयां जो बाहर करी दिता, गोडयां दे भार बेईकरी प्राथना किती, कने लाशा पासे दिखीकरी बोलया, “हे तबीता उठ।” तालू उना अपणिया हखी खोली दितियां, कने पतरसे जो दिखीकरी उठी बैठी। ");
INSERT INTO bht_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","उनी हथ देईकरी उसा जो उठाया कने पबित्र लोकां कने बिधवां जो सदीकरी उसा जो जिन्दा करी दसया। ");
INSERT INTO bht_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ऐ गल्ल सारे याफा शेहर च फेली गेई, कने मतयां प्रभु यीशु पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","कने पतरस याफा शेहरे च शमौन नाऐ दे कुसकी चमड़े दा धंधा करणे बाले दे ओथु मते रोजां दीकर रिया। ");
INSERT INTO bht_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया शेहरे च कुरनेलियुस नाऐ दा इक माणु था, सै इतालियानी नाऐ दिया पलटना दा सूबेदार था। ");
INSERT INTO bht_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","सै परमेश्वरे दा भक्त था, कने सै कने उदा सारा खानदान परमेश्वरे ला डरदा था, कने सै गरीब यहूदी लोंका जो बड़ा दान दिन्दा था, कने हर बकत परमेश्वरे ला प्राथना करणा लगी रेंदा था। ");
INSERT INTO bht_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","इक रोज, उनी दिने दे लगभग तिन बजे दे करीब इक दर्शण च बिलकुल साफ दिखया की परमेश्वरे दे इकी स्वर्गदूते उदे बाल अंदर आई करी बोलया, “हे कुरनेलियुस।” ");
INSERT INTO bht_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","कुरनेलियुसे स्वर्गदूते जो ध्याने ला दिखया कने डरीकरी बोलया, प्रभु जी क्या हुकम है? उनी उसयो बोलया, “तेरियां प्राथना कने तेरे दान याद तांई परमेश्वरे सामणे पुज्जे न। ");
INSERT INTO bht_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","हुण याफा शेहर च माणु भेजी करी शमौन जो, जिसयो पतरस बोलदे न, सदी ले। ");
INSERT INTO bht_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","सै शमौन, चमड़े दा धंधा करणे बाले दे ओथु परोंणा है, जिसदा घर समुद्रे बखे है।” ");
INSERT INTO bht_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","जालू सै स्वर्गदूत जिनी उसला गल्लां कितियां थियां चली गिया, तां उनी दो सेवकां कने इक भक्त सिपाइऐ जो सदया जड़े उदी सेबा तांई ओथु रेंदे थे, ");
INSERT INTO bht_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","कने उसयो सारियां गल्लां दसी करी याफा शेहरे जो पतरसे जो लोंणे तांई भेजया। ");
INSERT INTO bht_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","दुऐ रोजे कुरनेलियुस दे भेजयो सै तिन माणु चलदे-चलदे लगभग दोपेरा दे बकत शेहरे बखे पुज्जे, तां उसी बकत पतरस छती पर प्राथना करणा चढ़या। ");
INSERT INTO bht_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","उसयो भूख लग्गी कने सै कुछ खांणा चांदा था, कने जालू सै खांणा तैयार करा दे थे, तां सै बेसुध होई गिया। ");
INSERT INTO bht_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","कने उनी दिखया, की अम्बर खुली गिया, कने इक बडिया चादरा सांई कोई चीच चारो कुंणा ला रस्सिया ला बनियो धरती पासे उतरा दी है। ");
INSERT INTO bht_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","जिसा च धरतिया दे सै चारा पैरां बाले कने रेंगणेबाले जानवर कने अम्बरे दे पंछी थे, जिना दे बारे च मूसा दिया व्यवस्था च लिख्या है की सै अशुद्ध कने अपबित्र न कने यहूदिया जो इना जो खाणे तांई मना है। ");
INSERT INTO bht_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","कने उसयो इक अबाज सुणोई, “हे पतरस उठ, मार कने खा।” ");
INSERT INTO bht_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","पर पतरसे बोलया, “नी प्रभु, कदी नी, क्योंकि मैं कदी भी कोई अपबित्र या अशुद्ध चीज नी खादियो है।” ");
INSERT INTO bht_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","फिरी दूजी बरी उसयो अबाज सुणोई, “जड़ा कुछ परमेश्वरे शुद्ध करी दितया है, उसयो अशुद्ध मत बोल।” ");
INSERT INTO bht_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","तिन बरी इयां ही होया, तालू सै चादर अम्बरे जो बापस चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","जालू पतरस अपणे मने च परशानिया च था, की ऐ जड़ा मैं दर्शण दिखया ऐ क्या है? उसी बकत सै माणु जिना जो कुरनेलियुसे भेजया था, शमौने दे घरे दा पता लगाई करी दरबाजे पर आई खड़ोते। ");
INSERT INTO bht_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","कने पुकारी करी पूछणा लग्गे, “क्या शमौन जिसयो पतरस बोलदे न, ऐथू प्रोंणा है?” ");
INSERT INTO bht_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पतरस जड़ा उस दर्शने दे बारे च सोचा दा ही था, की पबित्र आत्मा उसयो बोलया, “दिख, तिन माणु तिजो तोपा दे न। ");
INSERT INTO bht_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","भले ही सै होर जाति दे न, उठी करी थले जा, कने बिना सोचया उना सोगी चली जा, मैं ही उना जो भेजया है।” ");
INSERT INTO bht_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","तालू पतरसे थले उतरी करी उना माणुऐ जो बोलया, “दिखा जिसयो तुसां तोपा दे न, सै मैं ही है, तुहाड़े ओंणे दी क्या बजा है?” ");
INSERT INTO bht_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","उना बोलया, कुरनेलियुस सूबेदार जड़ा धर्मी कने परमेश्वरे ला डरने बाला कने सारिया यहूदी जाति च सुनाम माणु है, उसयो इक पबित्र स्वर्गदूते ऐ बोलया है, की तिजो अपणे घरे सदीकरी तिजो ला उपदेश सुणे। ");
INSERT INTO bht_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","तालू उनी उना जो अंदर सदीकरी उना जो रेहणे तांई जगा दिती। कने दुऐ रोजे सै उना सोगी गिया, कने याफा शेहरे दे मसीह भाईयां चे कुछ उदे सोगी चली पे। ");
INSERT INTO bht_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","तिजे रोजे सै कैसरिया शेहरे च पुज्जे, कने कुरनेलियुस अपणे रिश्तेदारां कने प्यारे दोस्तां जो गिठे करिरी उना दा इंतजार करा दा था। ");
INSERT INTO bht_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","जालू पतरस अंदर ओआ दा था, तां कुरनेलियुस उसने मिल्ला, कने उदे पैरां च पेईकरी नमस्ते किता। ");
INSERT INTO bht_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","पर पतरसे उसयो चुकी करी बोलया, “खड़ा हो, मेरी अराधना मत कर मैं भी तां माणु ही है।” ");
INSERT INTO bht_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","कने उसने गल्लां करदे अंदर गिया, कने मतयां लोकां जो गिठे दिखीकरी ");
INSERT INTO bht_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","पतरसे उसयो बोलया, तुसां जाणदे न, की होरनी जातियां दी संगती करणा या उना दे ओथु जाणा भी असां यहूदियां तांई साड़िया व्यवस्था दे खिलाफ है। पर परमेश्वरे मिंजो दसया है कुसी भी माणुऐ जो अपबित्र या अशुद्ध नी बोलणा। ");
INSERT INTO bht_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","इस तांई जालू मिंजो सदया तालू मैं बिना कुछ बोलयो चली आया। हुण मैं पुछदा है की मिंजो कुसी कम्मे तांई सदया है? ");
INSERT INTO bht_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","कुरनेलियुसे बोलया, तिन रोज पेहले, इसी बकत, मैं अपणे घरे च लगभग दोपेरा दे तिन बजे दे करीब प्राथना करा दा था, तां इक मर्द चमकीले कपड़े पाई करी, मेरे सामणे आई खड़ोता। ");
INSERT INTO bht_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","कने उनी मिंजो बोलया, “हे कुरनेलियुस, तेरी प्राथना सुणी लियो है कने तेरे दान परमेश्वरे दे सामणे याद किते गे न। ");
INSERT INTO bht_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","इस तांई कुसकी जो याफा शेहर भेजी करी शमौने जो जिसयो पतरस बोलदे न, सद। सै समुद्रे दे बखे शमौन जड़ा चमड़े दा धंधा करणे बाले दे घरे च परोंणा है, जालू उनी ओणा, तां उनी तिजो परमेश्वरे दिया तरफा ला इक संदेश दसणा। ");
INSERT INTO bht_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","तां मैं झट तेरे बाल लोक भेजे, कने तू खरा किता की जड़ा तू आई गिया। हुण असां सारे ऐथू परमेश्वरे दे सामणे न, ताकि जड़ा कुछ परमेश्वरे तिजो बोलणे तांई बोलया है, असां उसयो सुणना।” ");
INSERT INTO bht_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","तालू पतरसे मु खोली करी बोलया, हुण मिंजो पक्का यकीन होया, की परमेश्वर कूसदा भी पक्ष नी करदा, ");
INSERT INTO bht_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","हर जातियां च जड़ा परमेश्वरे ला डरदा है कने धर्मे दे कम्म करदा है, उसयो परमेश्वर अपनाई लेंदा है। ");
INSERT INTO bht_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","तुसां उस संदेश जो जाणदे न जड़ा परमेश्वरे सांझो, मतलब की इस्राएल दे लोकां जो भेजया। उनी शान्ति दे बारे च शुभसमाचार सुणाया जड़ी लोकां जो यीशु मसीह पर भरोसा करणे ला मिली सकदी है। सै सारयां दा प्रभु है। ");
INSERT INTO bht_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","तुहांजो उस बचने दे बारे च पता है, जड़ा यूहन्ना दे बपतिस्मा दे प्रचारे बाद गलीले प्रदेश ला शुरू होईकरी सारे यहूदिया प्रदेशे च फेली गिया, ");
INSERT INTO bht_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","तुसां नासरत बासी यीशुऐ दे बारे च जाणदे न की परमेश्वरे कियां पबित्र आत्मा कने शक्तिया ला उदा अभिषेक किता; सै भलाई करदा कने जिना जो शैताने तंग कितया था, उना सारयां जो ठीक करदा गिया, क्योंकि परमेश्वर उदे सोगी था। ");
INSERT INTO bht_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","कने असां प्रेरितां उना सारियां चीजां दे बारे च लोकां जो दसया, जड़ियां यीशुऐ साड़े यहूदिया प्रदेश कने यरूशलेम शेहरे च कितियां, कने यरूशलेम शेहर च यहूदी अगुवां उसयो सूली पर लटकाई करी मारी दिता। ");
INSERT INTO bht_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","पर उसयो परमेश्वरे तिजे रोजे मरयां चे जिन्दा करी दिता, कने उसयो प्रगट भी किता है। ");
INSERT INTO bht_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","सारयां लोकां उसयो नी दिखया, पर उना गबाहां जो जिना जो परमेश्वरे पेहले ही प्रेरित चुणी लिया था, मतलब की सांझो जिना मरयां चे जिन्दा होणे बाद उदे सोगी खादा पीता। ");
INSERT INTO bht_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","कने उनी सांझो हुकम दिता की सारे लोकां जो शुभसमाचार दा प्रचार करा कने गबाई दिया, की यीशु सेई है जिसयो परमेश्वरे जिंदे कने मरयां दा न्याय करणे तांई बणाया है। ");
INSERT INTO bht_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","उदी सारे परमेश्वरे दे संदेश देणेबाले गबाई दिन्दे न की जड़ा कोई उदे पर भरोसा करगा, उसयो जड़ा मसीहे सूली पर किता उदिया बजा ला ही पापां दी माफी मिलणी है। ");
INSERT INTO bht_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","जालू पतरस ऐ गल्लां बोला दा ही था की सारे बचन सुणने बालयां पर पबित्र आत्मा उतरी आई। ");
INSERT INTO bht_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","कने जितणे भी यहूदी भरोसा करणे बाले पतरसे सोगी आयो थे, सै सारे हेरान होऐ की होरनी जातियां जो भी पबित्र आत्मा दा तोफा दिता है। ");
INSERT INTO bht_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","क्योंकि उना जो भांति-भांति दियां बोलियां कने परमेश्वरे दी बड़ाई करदे सुणाया। इस पर पतरसे बोलया, ");
INSERT INTO bht_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“क्या इना जो हुण कोई पांणिऐ ला रोकी सकदा है की इना जो बपतिस्मा ना मिल्ले, जिना जो साड़े सांई परमेश्वरे दिया तरफा ला पबित्र आत्मा मिलियो है?” ");
INSERT INTO bht_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","कने पतरसे उना जो हुकम दिता जड़े लोक कुरनेलियुस दे घरे गठुयो थे की यीशु मसीह दे नाऐ ने बपतिस्मा लिया। तालू उना पतरसे ला बिनती किती की थोड़े रोज होर रेई जा साड़े सोगी कने इस तांई सै कुछ रोजां तांई रेई पिया। ");
INSERT INTO bht_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","प्रेरितां कने चेलयां जड़े यहूदिया प्रदेशे च थे, उना सुणाया, की होरनी जातियां भी परमेश्वरे दा बचन मनी लिया है। ");
INSERT INTO bht_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","कने जालू पतरस यरूशलेम शेहर च आया, तां यहूदी विश्वासी उसला शिकायत करणा लग्गे, ");
INSERT INTO bht_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“तू होर जातियां दे लोकां दे घरे जाई करी उना सोगी रोटी खादी।” ");
INSERT INTO bht_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","तालू पतरसे उना जो शुरू ला सारियां गल्लां सुणाईयां, जड़ियां ओथु होइयां थियां; ");
INSERT INTO bht_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“मैं याफा शेहरे च प्राथना करा दा था, कने बेसुध होईकरी इक दर्शण दिखया, की इक बडिया चादरा सांई कोई चीच चारो कुंणा ला रस्सियां ला बनूईयो अम्बरे ला धरती पासे उतरी करी मेरे बाल आई। ");
INSERT INTO bht_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","जालू मैं उस पर ध्यान दिता, तां मैं धरतिया दे चारा पैरां बाले जानवर कने जंगली जानवर कने रेंगणेबाले जीव कने अम्बरे दे पंछी दिखे; ");
INSERT INTO bht_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","कने मैं इक अबाज सुणी जड़ी मिंजो बोला दी थी की, हे पतरस उठ मार कने खा। ");
INSERT INTO bht_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","मैं बोलया, ‘नी प्रभु जी! क्योंकि कोई अपबित्र या अशुद्ध चीज मेरे मुऐ च कदी नी गेई।’ ");
INSERT INTO bht_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","इदे जबाब च अम्बरे ला दूजी अबाज आई, जड़ा कुछ परमेश्वरे शुद्ध बणाया है, उसयो अशुद्ध मत बोल। ");
INSERT INTO bht_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","तिन बरी ऐदिया होया, तालू सारा कुछ अम्बरे पासे दोबारा चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","कने झट तिन माणु जड़े कैसरिया शेहरे ला मेरे बाल भेजयो थे, सै घरे दे दरबाजे पर आई खड़ोते, जिस घरे च असां थे। ");
INSERT INTO bht_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","तालू पबित्र आत्मा मिंजो बेझिझक उना सोगी चली जाणे जो बोलया, कने ऐ छे भाई भी मेरे सोगी चली पे, कने असां उस माणुऐ दे घरे पुज्जी गे। ");
INSERT INTO bht_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","कने उनी दसया, की मैं स्वर्गदूते जो अपणे घरे खड़ोतया दिखया, जिनी मिंजो बोलया, याफा शेहर जो इक माणु भेजी करी शमौने जो जिसयो पतरस बोलदे न, सदी ले। ");
INSERT INTO bht_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","उनी तिजो ने ऐसिया गल्लां बोलणियां न, जिना ने परमेश्वरे तिजो कने तेरे सारे घराने दे लोकां जो बचाणा। ");
INSERT INTO bht_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","जालू मैं गल्लां करणा लग्गा तां पबित्र आत्मा उना पर तियां ही उतरी, जियां शुरू च पिन्तेकुस दे त्योहारे दे बकत सांझो पर उतरियो थी। ");
INSERT INTO bht_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तालू मिंजो प्रभु दा सै बचन याद आया, जड़ा उनी बोलया, यूहन्ना तां पांणिऐ ला बपतिस्मा दिता, पर परमेश्वरे तुहाड़े सोगी रेणे तांई पबित्र आत्मा जो भेजणा। ");
INSERT INTO bht_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","इस तांई ऐ साफ है की परमेश्वरे उना होर जातियां जो भी सेई दान दिता, जड़ा सांझो प्रभु यीशु मसीह दे नाऐ पर भरोसा करणे ला मिल्ला, तां मैं कुण था जड़ा परमेश्वरे जो रोकी सकदा था?” ");
INSERT INTO bht_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ऐ सुणीकरी, यहूदी विश्वासी चुप रे, कने परमेश्वरे दी बड़ाई करी बोलणा लग्गे, “तां परमेश्वरे होर जातियां जो भी हमेशा दी जिन्दगी अपणे बुरे कम्मा जो छडी करी यीशु मसीह पर भरोसा करणे ने दान दिता है।” ");
INSERT INTO bht_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","स्तिफनुसे दे मारे जाणे बाद, केई यीशु मसीह पर भरोसा करणे बालयां यरूशलेम शेहरे जो छडी दिता कने तितर बितर होई गियो थे, सै चलदे-चलदे फीनीके इलाके कने साइप्रस द्वीप कने सीरिया प्रदेशे दे अन्ताकिया शेहर च पुज्जे, पर यहूदियां जो छडी करी कुसी होरसी जो परमेश्वरे दा बचन नी सुणादें थे। ");
INSERT INTO bht_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","पर उना च कुछ विश्वासी साइप्रस बासी कने कुरेनबासी थे, जड़े अन्ताकिया शेहरे च आऐ कने होर जातियां जो भी प्रभु यीशु दे शुभसमाचार दियां गल्लां सुणाणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","कने प्रभु दिया शक्तिया दा हथ उना पर था, कने मते लोकां उना दे प्रचार पर भरोसा किता कने प्रभु यीशु मसीह पर भरोसा करणा लगी पे। ");
INSERT INTO bht_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","तालू इना होईयां गल्लां दी खबर यरूशलेम शेहरे दिया कलीसिया सुणी, कने उना बरनबास जो अन्ताकिया शेहर भेजया। ");
INSERT INTO bht_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","सै ओथु पुज्जी करी, कने परमेश्वरे दे अनुग्रह जो दिखीकरी खुश होया, सारयां जो उपदेश दिता की तन मन लाईकरी प्रभु सोगी लिपटी रिया। ");
INSERT INTO bht_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","बरनबास इक भला माणु था, कने पबित्र आत्मा कने भरोसे ने भरुई गिया था, कने होर मते लोकां प्रभु यीशु मसीह पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","तालू बरनबास अन्ताकिया शेहर छडी करी शाऊल जो तोपणे तांई तरसुस शेहर जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","कने जालू उसने मिल्ला तां उसयो अन्ताकिया शेहर जो लेई आया, कने इयां होया की शाऊल कने बरनबास इक साले दीकर कलीसिया सोगी मिलदे कने मते लोकां जो यीशु मसीह दे बारे च सिखांदे रे, कने चेलयां जो सारयां ला पेहले अन्ताकिया शेहर च ही मसीही बोलया। ");
INSERT INTO bht_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","उना रोजां च केई भरोसा करणे बाले जड़े परमेश्वरे दा संदेश देणेबाले थे, यरूशलेम शेहर ला अन्ताकिया शेहर जो आऐ। ");
INSERT INTO bht_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","उना चे अगबुसे नाऐ दे परमेश्वरे दा संदेश देणेबाले खड़े होईकरी पबित्र आत्मा दिया प्रेरणा ला ऐ दसया, की सारे संसारे च बड़ा बड्डा अकाल पोंणा है, कने सै अकाल सम्राट क्लौदियुस दे बेले पिया। ");
INSERT INTO bht_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","तालू चेलयां यहूदिया प्रदेश दे मसीह पर भरोसा करणे बालयां तांई अपणी पौंच दे साबे ला सहायता देंणे दा फेसला किता। ");
INSERT INTO bht_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","कने उना इयां ही किता, कने बरनबास कने शाऊल दे हथे अगुवां बाल कुछ पैसे भेजी दिते। ");
INSERT INTO bht_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","उस बकत हेरोदेस राजे कलीसिया दे कुछ लोकां जो दुख देंणे तांई बन्दी बणाई लिया। ");
INSERT INTO bht_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","कने उनी प्रेरित याकूबे जो तलवारा ला मरवाई दिता, जड़ा प्रेरित यूहन्ना दा भाई था। ");
INSERT INTO bht_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","जालू उनी दिखया, की यहूदी लोक इसला खुश होंदे न, तां उनी पतरसे जो भी पकड़ी लिया। सै अखमीरी रोटिया दे त्योहारे दा बकत था। ");
INSERT INTO bht_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","कने राजा हेरोदेसे उसयो पकड़ी कर जेला च पाई दिता, कने उदी रखबालिया तांई, चार-चार सिपाईयां दे चार दलां दा पेहरा लाइ दिता। कने सै चांदा था की फसह दे त्योहारे बाद लोकां सामणे उदा न्याय करे। ");
INSERT INTO bht_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","पतरसे जो कुछ दिना तांई जेला च रखया, पर कलीसिया उदे तांई मन लाईकरी परमेश्वरे ला प्राथना करा दी थी। ");
INSERT INTO bht_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","कने जालू राजा हेरोदेसे उदा न्याय करणे तांई उसयो लोकां सामणे लोंणे बाला था, उसला इक रात पेहले पतरस दों सुंगला ला बनुया, दों स्पाईयां दे बिच सुतया था, कने पहरे दार दरबाजे पर जेला दी रखबाली करा दे थे। ");
INSERT INTO bht_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","तां अचानक प्रभु दा इक स्वर्गदूत पतरसे बखे आई खड़ोता कने उस कोठरी च इक चमकीली लौ होई गेई, कने उनी पतरसे दियां पसलिया पर हथ मारी करी उसयो जगाया, कने बोलया, “उठ, जल्दी उठ।” कने उदे हथां ला सुंगल खुली करी पेई गे। ");
INSERT INTO bht_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","तालू स्वर्गदूते उसयो बोलया, “लके बन, कने अपणे जुतयां पाई ले।” उनी तियां ही किता, फिरी स्वर्गदूते उसयो बोलया, “अपणे बाहरी कपड़े जो पाई करी मेरे पिच्छे चली पो।” ");
INSERT INTO bht_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","सै निकली करी उदे पिच्छे चली पिया, पर सै ऐ नी जाणदा था की जड़ा कुछ स्वर्गदूत करा दा है, ऐ सच्च था, पर सै ऐ समझा दा था की मैं दर्शण दिखा दा है। ");
INSERT INTO bht_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","तालू सै चली करी पेहले कने दुऐ पहरे ला निकली करी उस लोहे दे फाटके पर पुज्जे, जड़ा शेहरे पासे लेई जांदा था, सै फाटक उना तांई अपु ही खुली गिया, कने सै निकली करी इकी गलिया च होईकरी गे, इतणे च स्वर्गदूत उसयो छडी करी चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","तालू पतरसे होशा च आई करी बोलया, “हुण मिंजो सच्च पता लगी गिया है, की प्रभुऐ अपणा स्वर्गदूत भेजी करी मिजों राजा हेरोदेसे दे हथे ला छुड़ाई लिया है, कने यहूदी अगुवां दी सारी आस तोड़ी दिती।” ");
INSERT INTO bht_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ऐ जाणी करी की परमेश्वरे उसयो बचाई लिया है, तां सै मरियम दे घरे गिया, जड़ी यूहन्ना दी माता थी, कने उदा दुज्जा ना मरकुस भी था। ओथु मते चेले गिठे होईकरी प्राथना करा दे थे। ");
INSERT INTO bht_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","जालू पतरसे बाहरे बाले दरबाजे जो खड़काया तां रुदे नाऐ दी इक दासी सुणने तांई आई। ");
INSERT INTO bht_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","कने पतरसे दी अबाज पछेणी करी, खुशिया दे मारे उना दरबाजा नी खोलया, पर दोड़ी करी अंदर गेई, कने दसया की पतरस दरबाजे पर खड़ोतया है। ");
INSERT INTO bht_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","उना उसा जो बोलया, तू पागल है। पर सै अड़ी रेई की सै पतरस ही है, तालू उना बोलया, “सै पतरसे दा स्वर्गदूत होणा।” ");
INSERT INTO bht_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","पर पतरस दरबाजा खड़कांदा रिया कने उना दरबाजा खोलया, कने उसयो दिखीकरी हेरान होई गे। ");
INSERT INTO bht_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","तालू पतरसे उना जो हथे ला इशारा किता की चुप रिया, कने उनी दसया की प्रभुऐ कियां मिंजो जेला ला कडी लयोंदा है। फिरी बोलया, “याकूब कने भाईयां जो ऐ गल्ल दसी दिनयो।” तालू पतरस निकली करी दुज्जी जगा जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ब्यागा जेला दे सिपाईयां च बड़ा हल्ला पेई गिया की, पतरस कुथु गिया। ");
INSERT INTO bht_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","जालू राजा हेरोदेसे उसयो तोपणे दा हुकम दिता पर सै तोपी नी सके, तां पहरे दारां ला पूछताछ किती कने जालू सै जबाब नी देई सके तां उना जो मारणे दा हुकम देई दिता, कने पतरस यहूदिया प्रदेशे जो छडी करी कैसरिया शेहरे च जाई करी रेंणा लगा। ");
INSERT INTO bht_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","राजा हेरोदेस सूर कने सैदा शेहरे दे लोकां ला बड़ा जादा गुस्सा था। इस तांई उना शेहरां दे लोक राजा हेरोदेस ला मिलणे तांई इक मन होईकरी आये। सारयां ला पेहले, उना बलास्तुस ला सहायता मंगी जड़ा राजे दा खास कर्मचारी था। तां उना राजा हेरोदेसे ला शान्ति स्थापना तांई बोलया क्योंकि सै अपणे खांणे पिणे दियां जुरूरतां तांई राजे दे देशे पर निर्भर थे। ");
INSERT INTO bht_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","जिस रोजे राजा हेरोदेसे उना शेहरे दे लोकां ने मिलणे दा फेसला किता, उस रोज सै राज कपड़े पाई करी सिहांसने पर बैठा, कने प्रजा जो भाषण देणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","कने लोक उदी बड़ाई करणे तांई ऐ बोलणा लग्गे कि, “ऐ तां माणुऐ दी नी, पर कुसी देवते दी अबाज है।” ");
INSERT INTO bht_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","उसी बेले प्रभुऐ दे इकी स्वर्गदूते आई करी राजा हेरोदेस पर वार किता क्योंकि उनी परमेश्वरे दी महिमा नी किती कने उदे शरीरे च कीड़े पेई गे कने सै मरी गिया। ");
INSERT INTO bht_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","पर परमेश्वरे दा बचन फलदा गिया कने भरोसा करणे बालयां दी गिणती बददी गेई। ");
INSERT INTO bht_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","जालू बरनबास कने शाऊले यहूदिया प्रदेशे च अपणी सेबा दे कम्मे जो पूरा करी लिया तां सै यरूशलेम शेहरे ला अन्ताकिया शेहरे जो मुड़ी आऐ। यूहन्ना जिसयो मरकुस भी बोलदे न सै सोगी था। ");
INSERT INTO bht_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अन्ताकिया शेहरे दिया कलीसिया च परमेश्वरे दा संदेश देणेबाले कने गुरु थे; मतलब की बरनबास कने शमौन जिदा दुज्जा ना निगर भी था; कने लूकियुस कुरेनी शेहर, कने चौथाई देशे दे राज हेरोदेसे दा दूध भाई मनाहेम कने शाऊल। ");
INSERT INTO bht_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","जालू सै बरत रखीकरी प्रभु दी भक्ति करा दे थे, तां पबित्र आत्मा बोलया, “मेरे तांई बरनबास कने शाऊल जो मेरी सेबा करणे तांई लग करा जिदे तांई मैं उना जो सदया है।” ");
INSERT INTO bht_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","तालू उना बरत कने प्राथना करिरी कने उना पर हथ रखीकरी उना जो परमेश्वरे दा कम्म करणे तांई भेजया। ");
INSERT INTO bht_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","शाऊल कने बरनबास पबित्र आत्मा दे जरिये भेजे गे, सै अन्ताकिया शेहर ला सिलुकिया शेहरे दिया बन्दरगाह जो गे, कने ओथु ला जहाजे पर चढ़ी करी साइप्रस टापू दी सलमीस बंदरगाह जो चली गे। ");
INSERT INTO bht_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","सलमीस शेहर च पुज्जी करी, उना परमेश्वरे दा बचन यहूदी जंज घरां च सुणाया, कने यूहन्ना जिसयो मरकुस भी बोलदे थे सै उना दी सहायता करणे तांई उना सोगी था। ");
INSERT INTO bht_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","इदे बाद उना पुरे टापूऐ च इक शेहर ला दुज्जे शेहर दी यात्रा किती कने आखिर च पाफुस शेहरे च पुज्जे। ओथु उना जो बार-यीशु नाऐ दा इक जादूगर मिल्ला जड़ा यहूदी कने झूठा संदेश देणेबाला था। ");
INSERT INTO bht_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","सै टापूऐ दे राज्यपाल सोगी था, जिदा ना सिरगियुस पौलुस था, कने सै बड़ा बुद्धिमान माणु था। राज्यपाले बरनबास कने शाऊल जो परमेश्वरे दा बचन सुणने तांई अपणे बाल सदया। ");
INSERT INTO bht_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","पर जादूगर बार-यीशु, जिसया युनानी भाषा च एलीमास बोलदे न, उना दा बिरोध करदा रिया, उदी कोशिश थी की सै राज्यपाल जो यीशु मसीह पर भरोसा करणे ला रोके। ");
INSERT INTO bht_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","तालू शाऊले जिदा ना पौलुस भी है, पबित्र आत्मा ला भरुई करी जादूगरे पासे इक टक लाईकरी दिखीकरी बोलया, ");
INSERT INTO bht_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“हे सारे कपट कने चलाकिया ला भरूयो शैताने दी ओलाद, सारिया धार्मिकता दे दुशमण, क्या तू प्रभु दिया सचाइया जो भ्रष्ट करणा नी छडणा? ");
INSERT INTO bht_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","हुण दिख, प्रभु तिजो सजा देंणे बाला है, कने तू थोड़े बकते तांई अन्ना रेंणा कने तू सूरजे जो नी दिखी सकणा।” तालू झट धुंधलापन कने उदे अग्गे नेहेरा होई गिया, कने सै रुआं प्रां टटोलणा लग्गा ताकि कोई उदा हथ पकड़ी करी उदी सहायता करे। ");
INSERT INTO bht_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","तालू राज्यपाले जड़ा कुछ होया था, दिखीकरी कने प्रभु दियां शिक्षा ला हेरान होईकरी उनी यीशु मसीह पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पौलुस कने उदे साथियां पाफुस शेहरे ला समुंद्री यात्रा शुरू किती कने सै पंफूलिया प्रदेशे दे पिरागा शेहरे च जाई पुज्जे, कने यूहन्ना मरकुस उना जो छडी करी यरूशलेम शेहरे जो बापस आई गिया। ");
INSERT INTO bht_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","कने पिरागा शेहरे ला अग्गे चली करी गलातिया प्रदेश दे पिसिदिया जिल्ले दे बखे अन्ताकिया शेहर च पुज्जे; कने सब्ते दे रोजे च यहूदी जंज घर च जाई करी बैठी गे। ");
INSERT INTO bht_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","मूसा दी व्यवस्था कने परमेश्वरे दे संदेश देणेबालयां दी कताबां ला पढ़ने बाद यहूदियों दे जंज घरे दे सरदारां उना जो बोली भेजया, “हे भाईयो, अगर तुसां चे कुसी बाल लोकां जो शिक्षा देंणे तांई तुहाड़े मने च कोई बचन है तां बोला।” ");
INSERT INTO bht_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","तालू पौलुस खड़ा होया कने उना जो हथे ला चुप रेणे दा इशारा करिरी बोलया, “हे इस्राएलियां, कने परमेश्वरे ला डरने बाले होर जाति दे लोको, सुंणा।” ");
INSERT INTO bht_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इना इस्राएली लोकां दे परमेश्वरे साड़े पूर्वजां जो चूंणी लिया है, कने जालू ऐ मिस्र देशे च परदेसी होईकरी रेंदे थे, तां उना जो गिणतिया च बदाई दिता; कने उना जो अपणिया शक्तिया ला उस देशे ला कडी लांदा। ");
INSERT INTO bht_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","कने सै कोई चालियां साला दीकर सुनसान जगा च उना दी सेहदां रिया, चाहे सै बार-बार परमेश्वरे दे हुकम दे खिलाफ जांदे थे। ");
INSERT INTO bht_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","कने कनान देशे च सत जातियां जो खत्म करिरी उना दा इस्राएली लोकां जो बिरासत च देई दिता। ");
INSERT INTO bht_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","साड़े पूर्वजां मिस्र देशे च पुजणे बाद चार सौ पजां सालां बाद कनान देशे पर अधिकार करणा शुरू किता, इदे बाद परमेश्वरे दे संदेश देणेबाले शमूएल दे ओंणे दीकर परमेश्वरे इस्राएल दे लोकां पर राज करणे तांई मुखिए नियुक्त किते। ");
INSERT INTO bht_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","जालू शमूएल हले दीकर उना दा अगुवा ही था, उना इक राजा मंगया, तालू परमेश्वरे बिन्यामीन दे गोत्र चे इक माणुऐ जो मतलब की कीश दे पुत्र शाऊले जो उना दा राजा बणाया, उनी चालियां सालां दीकर इस्राएल दे लोकां पर राज किता। ");
INSERT INTO bht_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","फिरी परमेश्वरे शाऊल जो राजे दे पद ला हटाई करी उदिया जगा पर दाऊदे जो उना दा राजा बणाया, जिदे बारे च उनी गबाई दिती, मिंजो इक माणु, यिशै दा पुत्र दाऊद, मेरे मने दिया इच्छा दा माणु मिली गिया है। उनी मेरियां सारियां इच्छा पुरियां करणियां। ");
INSERT INTO bht_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","उदे ही बंशे चे परमेश्वरे अपणे बायदे दे अनुसार इस्राएले तांई इक उद्धारकर्ता, मतलब की यीशु भेजया। ");
INSERT INTO bht_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","जिदे ओंणे ला पेहले यूहन्ने प्रचार किता की सारे इस्राएली लोकां जो अपणे पापां दा पश्चाताप करणे कने परमेश्वरे पासे फिरणे कने बपतिस्मा लेंणे दी जरूरत है। ");
INSERT INTO bht_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","जालू यूहन्ना अपणी सेबा पुरिया करणे पर था, तां उनी बोलया, तुसां मेरे बारे च क्या सोचदे न? मैं मसीह नी है! दिखा, मेरे बाद इक ओंणे बाला है, सै बड़ा जादा महान है, मैं तां उदे जुतयां दे तस्मे खोलणे दे काबील भी नी है। ");
INSERT INTO bht_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“हे मसीह भाईयों, तुसां जड़े अब्राहमे दी ओलाद न कने परमेश्वरे ला डरणे बाले होर जाति दे लोको, परमेश्वरे साड़े बाल यीशु दे बारे च ऐ संदेश भेजया है जड़ा लोकां जो बचांदा है। ");
INSERT INTO bht_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","यरूशलेम शेहरे दे लोकां कने उदे अगुवां मसीह जो पछेणया नी कने उना परमेश्वरे दे संदेश देणेबालयां दे बचना जो नी समझया जिना जो सै हर सब्त दे रोजे पढ़दे थे। इस तांई उना उसयो दोषी बोली करी परमेश्वरे दे संदेश देणेबालयां दे बचना जो पूरा किता। ");
INSERT INTO bht_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","उना जो मौत दी सजा देंणे दे लायक उदे च कोई दोष नी मिल्ला, फिरी भी उना राज्यपाल पिलातुसे ला बिनती किती, की उसयो मारी दे। ");
INSERT INTO bht_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","कने जालू उना सै सब कुछ किता जड़ा पबित्र शास्त्र उदे बारे च बोलदा है, तां उदिया लाशा जो सूली ला उतारी करी कबरा च रखया। ");
INSERT INTO bht_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","पर परमेश्वरे उसयो मरयां चे जिन्दा किता, ");
INSERT INTO bht_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","कने जड़े चेले यीशुऐ सोगी गलील प्रदेश ला यरूशलेम शेहरे च आयो थे, उना जो बड़े रोजां दीकर मिलदा रिया; सै हुण लोकां सामणे उदे गबाह न। ");
INSERT INTO bht_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","असां तुहांजो उसा प्रतिज्ञा दे बारे च जड़ी पूर्वजां ला कितियो थी, ऐ शुभसमाचार सुणादें न, ");
INSERT INTO bht_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","की परमेश्वरे यीशुऐ जो मरयां ला जिन्दा करिरी, साड़े सोगी वायदे जो पूरा कितया, जड़े उना दी संतान न; जियां दुज्जे भजन संहिता च परमेश्वरे मसीह दे बारे च बोलया है की, तू मेरा पुत्र है, अज ही मैं तेरा पिता बणी गिया है। ");
INSERT INTO bht_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","परमेश्वरे यीशुऐ जो मरयां चे जिन्दा करणे दा बायदा कितया था, कने उसयो कबर च सड़ना नी दिता, परमेश्वरे ऐ बोलया है, मैं तिजो सै पबित्र कने पक्की आशीष देंणी जिना जो देंणे दा बायदा मैं राजा दाऊदे जो कितया था।” ");
INSERT INTO bht_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","राजा दाऊदे ऐ गल्ल होर भजन संहिता च भी बोलदा है की, “तू अपणे पबित्र जन जो सड़ना नी देणा।” ");
INSERT INTO bht_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","क्योंकि राजा दाऊद तां परमेश्वरे दिया इच्छा दे अनुसार अपणे बकते ने सेबा करिरी मरी गिया, कने अपणे पूर्वजां बाल जाई रिया, कने सड़ी भी गिया, इसला सांझो पता लगदा है की दाऊद इस भजन च अपणे बारे च गल्ल नी करा दा था। ");
INSERT INTO bht_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","पर सै यीशु मसीह दे बारे च बोला दा है जिसयो परमेश्वरे मरयां चे जिन्दा किता, कने सै सड़या भी नी। ");
INSERT INTO bht_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","इस तांई, हे यहूदी भाईयो; मैं चांदा है की तुसां ऐ जाणी लिया की यीशु मसीह दे जरिये ही तुहांजो पापां दी माफी मिलदी है। ");
INSERT INTO bht_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","तुसां कदी भी मूसा दिया व्यवस्था दे जरिये परमेश्वरे दिया नजरा च धर्मी नी बणी सकदे। पर हर इक जणा जड़ा यीशु मसीह पर भरोसा करदा है, सै परमेश्वरे दिया नजरा च धर्मी है। ");
INSERT INTO bht_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","इस तांई ध्यान रखा, की जड़ा परमेश्वरे दे संदेश देणेबालयां बोलया है, सै तुहाड़े सोगी ना हो: ");
INSERT INTO bht_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","हे निंदा करणे बालयो, दिखा, हेरान होआ, कने मिटी जा; क्योंकि मैं तुहाड़े दिना च इक कम्म करदा है; ऐसा कम्म, की अगर कोई तुसां ला उदी चर्चा करे, तां तुसां कदी भरोसा नी करणा। ");
INSERT INTO bht_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","जालू पौलुस कने बरनबास यहूदी जंज घरे ला बाहर निकला दे थे, तां लोक उना ला बिनती करणा लग्गे की, अगले सब्ते दे रोजे ऐ गल्लां सांझो दोबारा सुणानयो। ");
INSERT INTO bht_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","जालू सभा खत्म होई, तां मते यहूदी कने मते होर जातियां दे लोक जड़े यहूदी मते चे आयो थे पौलुस कने बरनबासे पिच्छे चली पे, कने उना जो गल्लां करिरी समझाया, की परमेश्वरे दे अनुग्रह च बणी रिया। ");
INSERT INTO bht_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","अगले सब्ते दे रोज शेहरे दे लगभग सारे लोक परमेश्वरे दा बचन सुणने जो गिठे होई गे। ");
INSERT INTO bht_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","पर जालू यहूदी अगुवां बड़िया भिड़ा जो दिखया तां सै प्रेरितां ला जलना लगे, कने पौलुसे दे बचना दे बिरोध च बोलया कने उदी बेईजती किती। ");
INSERT INTO bht_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","तालू पौलुस कने बरनबासे बिना डरयो बोलया, जरूरी था, की परमेश्वरे दा बचन पेहले तुहांजो सुणाया जांदा, पर तुसां उसयो नकारी दिता, कने अपणे आपे जो हमेशा दिया जिन्दगिया दे लायक नी समझदे न, तां हुण, असां होरनी जातियां बाल जांणा। ");
INSERT INTO bht_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","क्योंकि प्रभु यीशुऐ सांझो ऐ हुकम दितया है, “मैं तिजो होरनी जातियां तांई ज्योति बणाया है, तुहांजो संसार च हर जगा लोकां जो दसणा है की मैं कियां उना जो बचाई सकदा है।” ");
INSERT INTO bht_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ऐ सुणीकरी होर जातियां खुश होइयां, कने सै परमेश्वरे दे बचने दी बड़ाई करणा लग्गे, कने जितणे लोक हमेशा दिया जिन्दगिया तांई बणायो थे, उना भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","तालू प्रभु यीशु दा बचन उस इलाके च सारे पासे फेलणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","पर यहूदियां दे अगुवां भक्त कने कुलीन जनानिया जो कने शेहरे दे बड्डे लोकां जो भड़काया, कने पौलुस कने बरनबास पर हमला करवाई करी उना जो सीमा दे बार कडी दिता। ");
INSERT INTO bht_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","तालू पौलुस कने बरनबासे उना सामणे अपणे पैरां दी धुड़ झाड़ी, उना जो ऐ दसणे तांई की परमेश्वरे उना जो ठुकराई दितया है कने उना जो सजा देंणी। फिरी सै इकुनियुम शेहरे जो चली गे। ");
INSERT INTO bht_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","कने चेले अन्ताकिया शेहरे च आनंद ला कने पबित्र आत्मा ने भरूई गे। ");
INSERT INTO bht_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","इकुनियुम शेहर च ऐसा होया की पौलुस कने बरनबास यहूदी जंज घर च सोगी-सोगी गे, कने ऐसियां प्रभावशाली गल्लां कितियां की, यहूदियाँ कने होर जातियां दोंना चे मतयां यीशु पर भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","पर भरोसा नी करणे बाले यहूदियां होरनी जातियां दे मन मसीह भाईयां दे खिलाफ च भड़काए, कने उना दे मना च इना दे खिलाफ जहर भरी दिता। ");
INSERT INTO bht_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","कने पौलुस कने बरनबास मते रोजां दीकर ओथु रे, कने प्रभु यीशु दे भरोसे पर हिम्मता ला गल्लां करदे रे: कने प्रभु यीशुऐ उना जो अदभुत चिन्न चमत्कार करणे दी शक्ति दिती, ऐसा करी के यीशुऐ ऐ साबित किता की जिस अनुग्रह दे बारे च सै प्रचार करा दे न सै सच्चा है। ");
INSERT INTO bht_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","पर शेहरे दे लोकां च फुट पेई गियो थी, इसला कितणे ही तां यहूदियाँ पासे, कने कितणे ही प्रेरितां दे पासे होई गे। ");
INSERT INTO bht_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","तालू होर जातियां कने यहूदी लोकां अपणे सरदारां सोगी मिली करी उना पर हमला कने पथर मारणे फेसला किता। ");
INSERT INTO bht_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","जालू पौलस कने बरनबास जो इसा गल्ला दे बारे च पता लग्गी गिया, कने सै लुकाउनिया प्रदेशे दे लुस्त्रा कने दिरबे शेहरां च, कने अखे बखे दे इलाके च नठी गे। ");
INSERT INTO bht_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","पौलुस कने बरनबासे ओथु पुज्जी करी लोकां जो शुभसमाचार सुणाया। ");
INSERT INTO bht_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्त्रा शेहर च इक माणु बैठया था, उदे पैर कमजोर थे। सै जन्मे ला ही लगड़ा था, कने कदी नी चलया था। ");
INSERT INTO bht_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","सै पौलुसे जो गल्लां करदे सुंणादा था कने पौलुसे दिखया की उनी भरोसा करी लिया है कने सै खरा होई सकदा है। ");
INSERT INTO bht_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","कने जोरे ला बोलया, “अपणे पैरां भार सीधा खड़ा हो।” तालू सै उछली करी चलणा फिरणा लगी पिया। ");
INSERT INTO bht_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","लोकां पौलुस दा ऐ कम्म दिखीकरी लुकाउनिया बोलिया च जोरे ने बोलया, “देवता माणुऐ दे रुपे च साड़े बाल आया है।” ");
INSERT INTO bht_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","कने उना बरनबास जो यूनानी देवता ज्यूस दा ना दिता कने पौलुस जो हिर्मेस दा ना दिता, क्योंकि पौलुस मुख्य संदेश देंणे बाला था। ");
INSERT INTO bht_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","कने ज्यूसे दे उस मंदरे दा पुजारी जड़ा उना दे शेहरे सामणे था, दांद कने फुलां दे हार फाटके पर लेई आया क्योंकि सै लोकां सोगी बलि चढ़ाणा चांदा था। ");
INSERT INTO bht_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","पर बरनबास कने पौलुस प्रेरितां जालू सुणाया, तां सै बड़े परेशान होऐ कने अपणे कपड़े फाड़ी दिते, कने भिड़ा च चली गे, कने पुकारी करी बोलणा लग्गे, ");
INSERT INTO bht_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“हे लोको, तुसां क्या करदे न? असां भी तुहाड़े सांई दुखे सुख भोगणे बाले माणु न, कने तुहांजो शुभसमाचार सुणादे न, ताकि तुसां इना बेकार दियां चीजां ला लग होईकरी जिंदे परमेश्वरे पासे आई जा, जिनी स्वर्ग कने धरती कने समुंद्रे कने जड़ा कुछ उना च है बणाया है। ");
INSERT INTO bht_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","उनी होए युगां च सारियां जातियां जो अपणे-अपणे रस्ते च चलणा दिता। ");
INSERT INTO bht_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","सै हमेशा अपणे होणे दा सबूत उना खरियां चीजां ला दिन्दा है जड़ा सै करदा है, कने अम्बरे ला बरखा कने फलां बाली रित देईकरी तुहाड़े तांई खांणा कने तुहाड़े मना जो खुशिया ला भरदा रिया।” ");
INSERT INTO bht_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ऐ बोली करी भी उना लोकां जो बड़ी मुशकिला ला रोकया की उना तांई बलिदान मत करा। ");
INSERT INTO bht_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","पर कितणे ही यहूदियाँ अन्ताकिया कने इकुनियुम शेहरां ला आई करी लोकां जो अपणे पासे करी लिया, कने पौलुसे जो पथरा ने मारया कने उसयो मरया समझीकरी घसीटी करी शेहरे बाहर लेई गे। ");
INSERT INTO bht_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","पर जालू चेले उदे चारो पासे आई खड़ोते, तां सै उठी करी शेहरे जो बापस मुड़ी गिया कने दुऐ रोजे बरनबासे सोगी दिरबे शेहरे जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","पौलुस कने बरनबास दिरबे शेहरे दे लोकां जो शुभसमाचार सुणाई करी कने मते चेले बणाई करी। तालू सै लुस्त्रा शेहरे जो बापस चली गे। कने फिरी ओथु ला इकुनियुम शेहरे जो गे, कने फिरी सै पिसिदिया प्रदेश दे अन्ताकिया शेहरे जो गे। ");
INSERT INTO bht_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","कने हर शेहरे च चेलयां दे मना जो मजबूत करदे रे कने ऐ शिक्षा दिन्दे थे, की भरोसे च बणी रिया, कने ऐ बोलदे थे, “सांझो मते दुख झेली करी परमेश्वरे दे राज्य च दाखल होंणा पोंणा।” ");
INSERT INTO bht_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","कने उना हर इक कलीसिया च उना तांई अगुवे बणाऐ, कने प्राथना कने बरत करिरी उना जो प्रभु जो सोंपया जिदे पर उना भरोसा कितया था। ");
INSERT INTO bht_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","कने पिसिदिया प्रदेश ला होंदे होए सै पंफूलिया जिल्ले च जाई पुज्जे; ");
INSERT INTO bht_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","कने उना पंफुलिया जिल्ले दे पिरागा शेहरे च परमेश्वरे दे बचने दा प्रचार किता कने अत्तलिया शेहरे जो आई गे। ");
INSERT INTO bht_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","कने अत्तलिया शेहरे ला जहाजे पर अन्ताकिया शेहर जो मुड़ी आये, जिथू ला उना जो परमेश्वर दे अनुग्रह च सौंपीकरी उस कम्मे तांई भेजया था जिसयो उना जो पूरा किता। ");
INSERT INTO bht_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","अन्ताकिया शेहरे च पुज्जी करी उना कलीसिया गठेरी कने दसया, की परमेश्वरे साड़े सोगी होईकरी कदे बड्डे-बड्डे कम्म किते कने कियां परमेश्वरे होर जातियां जो यीशु मसीह पर भरोसा करणे दे काबिल बणाया। ");
INSERT INTO bht_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ओथु पौलुस कने बरनबास चेलयां सोगी मते रोज रे। ");
INSERT INTO bht_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","कुछ यहूदी मसीह पर भरोसा करणे बाले यहूदिया प्रदेशे ला अन्ताकिया शेहरे जो आऐ कने भरोसा करणे बालयां जो सिखाणा लग्गे: “अगर मूसा दिया व्यवस्था दे रिबाजे ला तुहाड़ा खतना नी होऐ तां तुहाड़ा उद्धार नी होई सकदा।” ");
INSERT INTO bht_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","जालू पौलुस कने बरनबास दा उना सोगी झगड़ा कने बड़ी बेहस होई तां कलीसिया दे अगुवां पौलुस कने बरनबास जो कने उना सोगी कुछ होर चेलयां जो यरूशलेम शेहरे जो जाणे तांई चुणया, ताकि सै इसा गल्ला दे बारे च प्रेरितां कने कलीसिया दे अगुवां सोगी चर्चा करन। ");
INSERT INTO bht_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","कलीसिया उना जो यात्रा तांई पैसे कने रोटीयां दा इंतजाम कराई करी भेजया, कने सै फीनीके कने सामरिया प्रदेशां ला होंदे होऐ कने ओथु दे भरोसा करणे बालयां जो दसया की होर जातियां दे लोकां कियां अपणे पापां जो मन्नी लिया कने गलत कम्मा जो छडी करी यीशु मसीह पर भरोसा किता है। ऐ शुभसमाचार सुणीकरी सारे भरोसा करणे बाले भाई बड़े खुश होए। ");
INSERT INTO bht_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","जालू सै यरूशलेम शेहरे च पुज्जे, तां कलीसिया कने प्रेरित कने अगुवे उना सोगी खुशिया ला मिल्ले, कने पौलुस कने बरनबासे दसया की परमेश्वरे उना सोगी होईकरी कदे-कदे कम्म किते थे। ");
INSERT INTO bht_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","पर फरीसियां दे दले दे लोकां चे जिना भरोसा कितया था, उना चे कितणयां ही उठी करी बोलया, “होर जातियां जो खतना कराणे कने मूसा दी व्यवस्था जो मनणे दा हुकम देणा चाईदा।” ");
INSERT INTO bht_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","तालू प्रेरित कने अगुवे इसा गल्ला दे बारे च बिचार करणे तांई गिठे होऐ। ");
INSERT INTO bht_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","तालू पतरसे बड़ी लम्बी बेहस होई जाणे बाद खड़ोई करी उना जो बोलया, “हे मसीह भाईयो, तुसां जाणदे न, कि मते रोज होऐ न, की परमेश्वरे तुसां चे मिंजो चूंणी लिया है, ताकि मेरे जरिये होर जातियां शुभसमाचार दा बचन सुणीकरी भरोसा करन।” ");
INSERT INTO bht_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","कने मने जो जाणने बाले परमेश्वरे उना जो भी साड़े सांई पबित्र आत्मा दिता, इयां करिके उनी दसया की उनी होर जातियां जो अपणे लोक होणे तांई चुणी लिया है। ");
INSERT INTO bht_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","कने भरोसे दे जरिये उना दे मन शुद्ध करिरी सांझो च कने उना च कोई भी फरक नी रखया। ");
INSERT INTO bht_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","तां हुण तुसां कजो परमेश्वरे जो परखदे न, की साड़ी यहूदी व्यवस्था कने रिती रिबाजां जो मणने तांई इना होर जातियां दे भरोसा करणे बालयां पर भारी बोज पान, जिसयो ना साड़े बाप दादे चुकी सकदे थे कने ना असां चुकी सकदे न। ");
INSERT INTO bht_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","इयां करणा ठीक नी है, साड़ा भरोसा तां ऐ है कि जियां उना जो प्रभु यीशुऐ दे अनुग्रह ला उद्धार मिलणा, तियां ही सांझो भी मिलणा, ना की मूसा दिया व्यवस्था जो मन्नी करी। ");
INSERT INTO bht_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","तालू सारी सभा चुपचाप होईकरी बरनबास कने पौलुस दी सुणना लग्गी, जियां ही उना अदभुत चिन्न चमत्कारां दे बारे दसया जड़े परमेश्वरे उना दे जरिये होर जातियां च किते। ");
INSERT INTO bht_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","जालू उना बोलणा बंद किता, तां याकूब बोलणा लग्गा, “हे मसीह भाईयो, मेरी सुंणा।” ");
INSERT INTO bht_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","शमौन पतरसे समझाया, कि परमेश्वरे पेहली बरी होर जातियां चे कुछ लोकां जो अपणे लोक होणे तांई चुणी करी उना जो आशीष दिती। ");
INSERT INTO bht_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","कने होर जातियां दा परमेश्वरे दे लोक बणना ऐ उसा गल्ला ला सहमत होंदा है, जिदे बारे च परमेश्वरे दे संदेश देणेबालयां पबित्र शास्त्र च बड़े पेहले लिखया था। ");
INSERT INTO bht_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“तालू मैं बापस ओंणा कने दाऊद दे राज्य जो दुबारा बणाणा जड़ा उदे दुशमणा वरबाद करी दितया है, कने उसयो दुबारा बणाई देणा। ");
INSERT INTO bht_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","इस तांई होर सारे लोक कने सारियां होर जातियां दे लोक जिना जो मैं अपणे लोक होणे तांई चुणया है, उना प्रभु जो तोपणा, ");
INSERT INTO bht_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ऐ सेई प्रभु बोलदा है जड़ा बड़े पेहले ला इना गल्लां दा समाचार दिन्दा आया है। ");
INSERT INTO bht_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","इस तांई मेरा बिचार ऐ है, कि सांझो होर जातियां तांई परमेश्वरे बाल मुड़ना कठिन नी बणाणा चाईदा; ");
INSERT INTO bht_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","पर असां उना जो इक चिठ्ठी लिखी भेजन, की सै उस खाणे जो ना खान जिसयो लोकां मूर्तियां जो चढ़ाया हो, कने ना व्यभिचार करदे कने ना ही गल्लां घोटी करी मारयो जानवरां दा मॉस खांदे कने ना ही खून खांदे। ");
INSERT INTO bht_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","क्योंकि पूराणे बकते ला शेहरे-शेहरे च मूसा दिया इस व्यवस्था दे प्रचार करणे बाले होंदे आये न, कने सै हर सब्ते दे रोजे यहूदी जंज घरां च पढ़ी जांदी है।” ");
INSERT INTO bht_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","तालू यरूशलेम शेहरे दिया सारिया कलीसिया कने प्रेरितां कने अगुवां जो ऐ खरा लग्गा, कि अपणे चे कुछ माणुआं जो चुणी करी पौलुस कने बरनबासे सोगी अन्ताकिया शेहरे जो भेजन, उना इस तांई यहूदा जो, जिसयो बरअब्बा भी बोलदे न, कने सीलास जो चुणया, कने ऐ दोनों कलीसिया च सारयां ला इज्जतदार अगुवे थे। ");
INSERT INTO bht_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","कने सै इसा चिठिया जो अपणे सोगी लेई गे जिसा च लिखया था की, “ऐ चिठ्ठी प्रेरितां कने अगुवां दिया तरफा ला है जड़े तुहाड़े भाई न, असां अन्ताकिया शेहरे दे कने सीरिया कने किलिकिया प्रदेशां दे होर जातियां दे लोकां जो जड़े यीशु मसीह पर भरोसा करदे न, उना जो नमस्ते भेजदे न। ");
INSERT INTO bht_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","असां सुणाया है कि, साड़े ऐथू यरूशलेम ला कुछ अगुवे ओथु गे कने उना दियां गल्लां ला तुहांजो बुरा लग्गा कने तुसां दुखी होऐ, पर असां उना जो हुकम नी दितया था। ");
INSERT INTO bht_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","इस तांई असां इक मन होईकरी यहूदा कने सीलास जो चुणने दा फेसला लिया, ताकि उना जो अपणे प्यारे भाई बरनबास कने पौलुसे सोगी तुहाड़े बाल भेजन। ");
INSERT INTO bht_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ऐ तां ऐसे माणु न, जिना अपणे प्राण साड़े यीशु मसीह दी सेबा तांई खतरे च पायो न। ");
INSERT INTO bht_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","कने असां यहूदा कने सीलास जो भेजया है, जिना तुहाड़े सामणे अपणे मुऐ ला ऐ गल्लां दस्सी देणियां न। ");
INSERT INTO bht_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","पबित्र आत्मा जो कने सांझो भी ऐ ठीक लग्गा कि इना जरूरी गल्लां जो छडी करी, तुहांजो पर होर बोझ ना पान; ");
INSERT INTO bht_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","कि तुसां मूर्तियां अग्गे चढ़ायो खाणे जो मत खांदे, कने व्यभिचार कने गला घोटी करी मारयो जानवरां दा मॉस कने उना दा खून मत खांदे। अगर तुसां इना ला दूर रेंगे तां तुहाड़ा भला होणा। शुभकामना।” ");
INSERT INTO bht_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","फिरी कलीसिया उना जो ओथु ला भेजी दिता कने अन्ताकिया शेहरे च पुज्जे, कने सभा जो गठेरी करी उना जो चिठ्ठी देई दिती। ");
INSERT INTO bht_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","कने सै उस उपदेशे जो पढ़ी करी बड़े खुश होए। ");
INSERT INTO bht_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","कने यहूदा कने सीलासे जड़े अपु भी परमेश्वरे दे संदेश देणेबाले थे, मतियां गल्लां ला भरोसा करणे बाले भाईयां जो सिक्षा देईकरी प्रोत्साहित कने मजबूत किता। ");
INSERT INTO bht_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","(यहूदा कने सिलास थोड़े हफ्ते ओथु रे, कने मसीह भाईयां उना जो शांति दी आशीष देईकरी यरूशलेम शेहरे दिया कलीसिया च बापस भेजी दिता।) ");
INSERT INTO bht_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","पर सीलासे अन्ताकिया शहरे च रेणे दा फेसला किता, इस तांई यहूदा किल्ला ही यरूशलेम शेहरे जो बापस चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","कने पौलुस कने बरनबास अन्ताकिया शेहरे च रेई पे, कने होर मते लोकां सोगी प्रभु यीशु दे बचना दी शिक्षा कने शुभसमाचार सुणादें रे। ");
INSERT INTO bht_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","थोड़े बकत बाद पौलुसे बरनबासे जो बोलया, “जिना-जिना शेहेरां च असां प्रभु दे बचन सुणायो थे, ओआ, ओथु बापस जाई करी अपणे विश्वासी भाईयां जो दिखदे न कि सै कदे न।” ");
INSERT INTO bht_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","तालू बरनबासे यूहन्ना जो जिसयो मरकुस बोलदे न, सोगी लेई जाणे दा बिचार किता। ");
INSERT INTO bht_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","पर पौलुसे बोलया यूहन्ने हार मन्नी लियो है कने सांझो छडी करी चली गिया है जालू असां पंफूलिया इलाके च थे, इस तांई उसयो सोगी लेई जाणा खरा नी समझया। ");
INSERT INTO bht_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ऐसी बेहस होई कि पौलुस कने बरनबास इकी दुज्जे ला लग होई गे, कने बरनबास, मरकुस जो लेईकरी जहाजे पर साइप्रस टापु जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पर पौलुसे सीलास जो चूंणी लिया, कने मसीह भाईयां उना जो परमेश्वरे दे अनुग्रह च सौंपी दिता कने फिरी सै दोनों ओथु ला अन्ताकिया शेहरे ला चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","कने फिरी सै पुरे सीरिया कने किलिकिया प्रदेशां च गे कने कलिसियां दे भरोसा करणे बालयां जो प्रोत्साहित करदे गे। ");
INSERT INTO bht_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","फिरी पौलुस दिरबे कने लुस्त्रा शेहरे च भी गे, कने ओथु तीमुथियुस नाऐ दा इक चेला था। उदी माता यहूदी विश्वासी थी, पर उदा पिता यूनान देशे दा था। ");
INSERT INTO bht_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","सै लुस्त्रा इकुनियुम शेहरां दे भरोसा करणे बाले भाईयां चे इज्जतदार था। ");
INSERT INTO bht_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पौलुसे दी इच्छा थी कि तीमुथियुस उदे सोगी चले, कने उनी तीमुथियुस दा खतना इस तांई कराया ताकि उस जगा दे यहूदी लोक उदी सुणन, क्योंकि सै सारे जाणदे थे, कि उदा पिता यूनानी था। ");
INSERT INTO bht_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","पौलुस कने उदे सोगी शेहरे-शेहरे जाई करी सै उना नियमां जो जड़ियां यरूशलेम शेहरे दे प्रेरितां कने अगुवां बणाईयां थियां, उना जो विश्वासियां बाल पुजांदे थे ताकि सै उना नियम दा पालन करन। ");
INSERT INTO bht_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","इयां कलीसिया भरोसे च मजबूत होंदी गेई कने हर रोज गिणतिया च बददी गेई। ");
INSERT INTO bht_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","कने सै फ्रूगिया कने गलातिया प्रदेशां चे होईकरी गे, क्योंकि पबित्र आत्मा उना जो आसिया प्रदेशे च बचन सुणाणे तांई मना किता। ");
INSERT INTO bht_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","कने उना मूसिया प्रदेशे दे बखे पुज्जी करी, बितूनिया प्रदेश जांणा चांदे थे; पर यीशुऐ दिया आत्मा उना जो जांणा नी दिता। ");
INSERT INTO bht_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","तां सै मूसिया प्रदेशे ला होईकरी बंदरगाह बाले शहर त्रोआस जो आऐ। ");
INSERT INTO bht_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ओथु पौलुसे राती इक दर्शण दिखया कि इक मकिदुनी प्रदेशे दा मर्द खड़ोतया, कने उसला बिनती करी के बोलदा है, “समुन्द्रे पार उतरी करी मकिदुनिया प्रदेश च आ, कने साड़ी सहायता कर।” ");
INSERT INTO bht_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","जालू पौलुसे ऐ दर्शण दिखया, तालू असां झट मकिदुनिया प्रदेशे जो जांणे दी योजना बणाई, ऐ समझीकरी कि परमेश्वरे सांझो शुभसमाचार सुणाणे तांई सदया है। ");
INSERT INTO bht_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","इस तांई असां त्रोआस शेहरे ला जहाजे जरिये सुमात्राके टापु च आऐ कने दुज्जे रोजे नियापुलिस शेहरे दिया बंदरगाह च आये। ");
INSERT INTO bht_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ओथु ला असां फिलिप्पी शेहरे च पुज्जे, जड़ा मकिदुनिया प्रदेशे दा मुख्य शेहर, कने रोमियां दी बस्ती है, कने असां उस शेहरे च थोड़े रोजां दीकर रे। ");
INSERT INTO bht_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","सब्ते दे रोजे असां शेहरे दे फाटके बाहर खड्डा बखे ऐ सोची करी गे कि ओथु यहूदियों दी प्राथना करणे दी जगा होणी, कने बेईकरी उना जनानिया ने गल्लां करणा लग्गे, जड़ियां ओथु गठुइयां थियां। ");
INSERT INTO bht_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","कने ओथु इक लुदिया नाऐ दी जनानी उना दे बचन सुणा दी थी जड़ी थुआतीरा शेहरे ला बैंजणी कपड़े बेचदी थी, सै परमेश्वरे दी भक्त थी, कने परमेश्वरे उसा दा मन खोलया, ताकि सै पौलुसे दियां गल्लां पर ध्यान लगाऐ। ");
INSERT INTO bht_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","कने जालू उना अपणे पुरे टब्बरे समेत बपतिस्मा लिया, तां उना बिनती किती, “अगर तुसां मिंजो परमेश्वरे पर भरोसा करणे बाली समझदे न, तां मेरे घरे रेंणा चला,” “कने सै सांझो मनाई करी अपणे घरे लेई गेई।” ");
INSERT INTO bht_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","इक रोज जालू असां प्राथना करणे बालिया जगा जो चलयो थे, तां सांझो इक दासी मिली, जिसा च इक ऐसी बुरी आत्मा थी, जिदिया सहायता ला सै भविष्य दिखी लेंदी थी, कने सै अपणे स्वामियां तांई मतां कुछ कमाई लोंदी थी। ");
INSERT INTO bht_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","सै पौलुसे कने साड़े पिच्छे आई करी चिलाणा लगी, “ऐ माणु परम प्रधान परमेश्वरे दा दास है, सै तुसां जो दसा दे न कि कियां बची सकदे न।” ");
INSERT INTO bht_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","सै मते रोजां दीकर इयां ही करदी रेई, कने पौलुस दुखी होई गिया, कने मुड़ी करी बुरी आत्मा जो बोलया, “मैं तिजो यीशु मसीह दे नाऐ ने हुकम दिन्दा है, कि इसा चे निकली जा, कने सै तालू ही निकली गेई।” ");
INSERT INTO bht_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","जालू उसा दे मालिके दिखया कि, साड़िया कमाईया दी आस तां चली गेई, तां सै पौलुस कने सीलासे जो पकड़ी करी चौके च प्रधाना बाल खिची लेई गे। ");
INSERT INTO bht_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","कने उना जो फौजदारिया दे हाकिमा बाल लेईजाई करी बोलया, “ऐ लोक जड़े यहूदी न, साड़े शेहरे च बड़ा हंगामा करा दे न, ");
INSERT INTO bht_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","कने ऐसे तरीके दसा दे न, जिना जो अपनाणा कने मनणा रोम देश च रेणे बालयां तांई ठीक नी है।” ");
INSERT INTO bht_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","तालू लोकां दी भीड़ पौलुस कने सीलासे दे बरोध च गिठी होईकरी चढ़ी आई, कने हाकिमा उना दे कपड़े फाड़ी करी उतारी दिते, कने उना जो डंडे मारणे दा हुकम दिता। ");
INSERT INTO bht_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","कने मते डंडे मारी करी उना जो जेला च पाई दिता, कने जेल अधिकारिये जो हुकम दिता कि साबधानी ला उना दी रखबाली करा। ");
INSERT INTO bht_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","कने ऐसा हुकम मिलणे ला उनी उना जो अंदरे बालिया कोठढ़िया च रखया कने उना दे पैरां जो लकड़िया दियां बेड़ियां ला जकड़ी दिता। ");
INSERT INTO bht_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","लगबग अधिया राती पौलुस कने सीलास प्राथना करदे होए परमेश्वरे दे भजन गा दे थे, कने कैदी उना दी सुंणा दे थे। ");
INSERT INTO bht_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","कने इतणे च अचानक इक बड़ा बडा हिलण होया; ऐथू दीकर कि जेला दियां नियां भी हिली गिईयां, झट सारे दरबाजे खुली गे, कने सारयां दे बंधन खुली गे। ");
INSERT INTO bht_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","कने दरोगा उठी होया, कने जेला दे दरबाजे खुले दिखीकरी समझया कि सारे कैदी नठी गियो न, कने सै तलबारा कडी करी अपणे आपे जो मारणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","पर पौलुसे जोरे ने पुकारी करी बोलया, “अपणे आपे जो कुछ मत करदा, क्योंकि असां सारे ऐथू ही न।” ");
INSERT INTO bht_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","तालू सै दिय्या मंगाई करी अंदरे गिया कने कमदा होया पौलुसे कने सीलासे अग्गे पेई गिया, ");
INSERT INTO bht_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","कने उना जो बार आंणी करी बोलया, “हे सजनो, उद्धार पांणे तांई मैं क्या करे?” ");
INSERT INTO bht_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","उना बोलया, “प्रभु यीशु पर भरोसा कर, तां तेरा कने तेरे घराने दा उद्धार होणा।” ");
INSERT INTO bht_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","कने उना उसयो कने उदे सारे घरे दे लोकां जो प्रभु दे बचन सुणाऐ। ");
INSERT INTO bht_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","कने राती उसी बेले उना जो लेईजाई करी उना दे जख्म धोते, कने उनी कने उदे लोकां उसी बेले बपतिस्मा लिया। ");
INSERT INTO bht_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","कने उनी उना जो अपणे घरे लेईजाई करी, उना अग्गे खांणा रखया, कने सारे घराने समेत परमेश्वरे पर भरोसा करिरी खुशी मनाई। ");
INSERT INTO bht_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","जालू अगलिया ब्यागा हकीमा सिपाईयां जो ऐ बोली भेजया कि उना माणुऐ जो छडी दिया। ");
INSERT INTO bht_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","दरोगे ऐ गल्ल पौलुसे जो सुणाई, “कि हाकिमा तुहांजो छडी देंणे दा हुकम भेजी दितया है, इस तांई हुण निकली करी शांतिया ने चली जा।” ");
INSERT INTO bht_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","पर पौलुसे उना जो बोलया, “उना सांझो जड़े रोम देश च रेणेबाले माणु न, बिना दोष साबित कितयो सांझो लोकां दे सामणे मारया कने जेला च पाया, कने हुण क्या सै चुपचाप बाहर निकाली देणा चांदे न? ऐसा नी होणा, पर सै अपु आई करी सांझो बार लेई जान।” ");
INSERT INTO bht_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","सिपाईयां ऐ गल्लां हाकिमा ने बोली दीतियां, कने सै ऐ सुणीकरी की सै रोम देशे दे नागरिक न, सै डरी गे, ");
INSERT INTO bht_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","कने आई करी उना ला माफी मंगी कने बार लेईजाई ‍‍करी बिनती किती कि शेहरे ला चली जा। ");
INSERT INTO bht_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","सै जेला ला निकली करी लुदिया दे ऐथू गे, कने चेलयां ला मिली करी उना जो शांति दिती, कने चली गे। ");
INSERT INTO bht_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","फिरी पौलुस कने सीलास अम्फिपुलिस शेहर कने अपुल्लोनिया शेहरे ला होईकरी थिस्सलुनीके शेहरे च आऐ, जिथू यहूदी जंज घर था। ");
INSERT INTO bht_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","कने पौलुस रोजे सांई उना बाल गिया, कने तिन सब्तां दे रोजां पर पबित्र शास्त्रां ला उना सोगी चर्चा किती। ");
INSERT INTO bht_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","कने उना गल्लां दा मतलब खोली-खोली करी समझांदा था कि मसीह जो दुख होणा, कने मरयां च जिन्दा होणा जरूरी था; “ऐई यीशु जिदे बारे च मैं प्रचार करता है, सेई मसिहा है।” ");
INSERT INTO bht_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","उना चे कुछ यहूदियां, कने परमेश्वर दा डर मनणे बाले यूनानियां कने मतियां खास जनानिया भरोसा उना दे बचना पर भरोसा करी लिया, कने पौलुसे कने सीलासे सोगी जुड़ी गे। ");
INSERT INTO bht_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","पर यहूदियां जलना ने भरुई करी बजारू लोकां चे केई बुरे माणुऐ जो अपणे सोगी लेई लिया, कने भीड़ लगाई करी शेहरे च दंगे करणा लग्गे, कने उना यासोने दे घरे पर हमला किता, सै पौलुस कने सीलासे जो लोकां दे सामणे लोंणा चांदे थे। ");
INSERT INTO bht_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","कने सै उना जो नी मिल्ले, कने सै चिलांदे होए यासोन कने उदे कुछ मसीह भाईयां जो शेहरे दे हाकिमा सामणे खिची लेई आये, “ऐ लोक जिना सारियां जगा च परेशानी पाईयो है, ऐथू भी आयो न।” ");
INSERT INTO bht_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","कने यासोने उना दा अपणे घरे च स्वागत किता, कने ऐ सारे महाराजा कैसरे दे हुकमा दा बिरोध करदे न कने बोलदे न कि इक होर राजा है जिदा ना यीशु है। ");
INSERT INTO bht_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","जालू लोकां कने शेहरे दे हाकिमा ऐ गल्लां सुणियां तां सै परेशान होई गे। ");
INSERT INTO bht_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","कने उना यासोन कने बाकी लोकां जो जमानता पर छडी दिता। ");
INSERT INTO bht_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","चेलयां झट रातो रात पौलुस कने सीलास जो बिरीया शेहरे च भेजी दिता, कने सै ओथु पुज्जी करी यहूदी जंज घर च गे। ");
INSERT INTO bht_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ऐ लोक तां थिस्सलुनीके शेहरे दे यहूदियां लोकां ला खुले दिले दे थे कने उना बड़िया लालसा ला बचन जो अपनाया कने रोज पबित्र शास्त्रां च इना गल्लां जो तोपदे रेंदे कि ऐ गल्लां ऐसियां हेन कि नी न। ");
INSERT INTO bht_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","इस तांई उना चे मतयां, कने यूनान देशां दियां इज्जतदार जनानिया चे कने मर्दां चे मतयां भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","पर जालू थिस्सलुनीके शेहरे दे यहूदियां जो पता चला कि पौलुस बिरीया शेहरे च भी परमेश्वरे दा बचन सुंणा दे है, तां सै ओथु आई करी भी लोकां जो भड़काणा कने हंगामा करणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","तालू चेलयां झट पौलुसे जो ओथु ला भेजी दिता कि तू समुंद्रे कंडे चली जा; पर सीलास कने तीमुथियुस बिरीया शेहरे च ही रेई गे। ");
INSERT INTO bht_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","सै लोक जड़े पौलुसे जो लेई चलयो थे, सै उस सोगी एथेंस शेहरे दीकर गे, पर पौलुस दे इसी हुकमे सोगी सै बिरीया शेहरे जो मुड़ी गे कि सीलास कने तीमुथियुस जो झट ही उदे बाल भेजी दिया। ");
INSERT INTO bht_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","जालू पौलुस एथेंस शेहरे च उना दा इंतजार करा दा था, तां शेहरे जो मूर्तियां ला भुरुया दिखीकरी उदा मन बड़ा दुखी होया। ");
INSERT INTO bht_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","इस तांई सै हर सब्त दे दिन यहूदी जंज घरे च यहूदियां कने परमेश्वर दा डर मनणे बाले होर जाति दे लोकां सोगी बाद-बिबाद करदा कने चौंका पर जड़े भी लोक मिलदे थे, उना ला हर रोज चर्चा करदा था। ");
INSERT INTO bht_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","तालू सै गुरू जड़े इपिकूरी कने स्तोईकी करी के जाणे जांदे थे, इना चे कुछ उसला बेहस करणा लग्गे, कने केईयां बोलया, ऐ बकवास करणे बाला क्या बोलणा चांदा है? पर दुजयां बोलया, ऐ कुसी होरसी देशे दे देवतयां दा प्रचारक लग्गा दा है, क्योंकि सै यीशु दा कने मरयां चे जिन्दा होणे दा शुभसमाचार सुणादां था। ");
INSERT INTO bht_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","तालू सै उसयो अपणे सोगी अरियुपगुस नाये दे यहूदी महासभा जो लेई गे कने पुछया, “क्या असां जाणी सकदे न, कि ऐ जड़ी नोई शिक्षा तू सिखा दा है, सै क्या है? ");
INSERT INTO bht_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","क्योंकि तू सांझो अनोखियां गल्लां सुंणादा है, इस तांई असां जाणना चांदे न की इना सारियां गल्लां दा क्या मतलब है?” ");
INSERT INTO bht_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","इस तांई की सारे एथेंस शेहरे दे बासी कने परदेसी जड़े ओथु रेंदे थे, नोईयां-नोइयां गल्लां बोलणे कने सुणने दे सिवा होर कुसी कम्मे च बकत नी बितांदे थे। ");
INSERT INTO bht_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","तालू पौलुसे अरियुपगुस नाये दी सभा दे बिच खड़ोई करी बोलया, हे एथेंस शेहरे दे लोको, मैं दिखा दा है कि तुसां हर गल्ला च देवतयां जो बड़ा मंदे न। ");
INSERT INTO bht_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","क्योंकि मैं गुमदे होए तुहाड़ियां अराधना करणे बालियां चीजां जो दिखा दा था, तां इक ऐसी वेदी भी मिली, जिसा पर लिखया था, “अनजाणे ईश्वरे तांई।” इस तांई तां जिसयो तुसां बिना जाणयो अराधना करदे न, मैं तुसां जो उदा समाचार सुंणादा है। ");
INSERT INTO bht_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","जिनी परमेश्वरे धरतिया कने उदियां सारियां चीजा जो बणाया है, सै स्वर्ग कने धरतिया दा मालिक होईकरी हथे ला बणायो मंदरा च नी रेंदा है। ");
INSERT INTO bht_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ना ही कुसी चिजा दिया जुरूरता दिया बजा ला उसयो माणुऐ दिया सहायता दी जरूरत नी है, क्योंकि सै तां अपु ही सारयां जो जिन्दगी कने सारयां प्राणियां जो सांस कने सब कुछ दिन्दा है जड़ा उना जो जरूरत है। ");
INSERT INTO bht_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","उनी शुरू च इक ही माणुऐ ला सारे माणुआं दियां सारियां जातियां सारिया धरतिया पर रेणे तांई बणाईयां न; कने उनी माणुऐ जो जिणे तांई उना दी उमर कने उना दिया जगा जो तय कितया, ");
INSERT INTO bht_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","परमेश्वरे इस तांई किता ताकि लोक उसयो तोपन, कने होई सकदा है। सै उना जो तोपदे-तोपदे मिली जाऐ, असल च सै सांझो ला कुसी ला भी दूर नी है। ");
INSERT INTO bht_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","क्योंकि सै सेई है जड़ा साड़े जिणे कने चलणे-फिरणे दी बजा बणदा है कने सै बणादां है जड़े असां असल च हेन; कने ठीक तियां ही जदिया तुहाड़े कवियां बोलया भी है, “असां तां उदे ही वंश भी न।” ");
INSERT INTO bht_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","इस तांई परमेश्वरे दी ओलाद होईकरी सांझो ऐ समझणा ठीक नी कि परमेश्वर, सोने या चांदी या पथरे सांई है, जड़े माणुऐ दिया सोचा कने कारिगिरिया ला बणायो न। ");
INSERT INTO bht_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","इस तांई परमेश्वरे लोका दिया अज्ञानता दे युगां उपर ध्यान नी दिता, पर हुण हर जगा सारे माणुआं जो, अपणे पापां जो मन्नी करी कने गलत कम्मा जो छडी देंणे दा हुकम दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","क्योंकि उनी इक दिन तय कितया है, जिदे च उनी उस माणुऐ जरिये धार्मिकता ला संसारे दा न्याय करणा है, जिसयो उनी नियुक्त कितया है, कने उसयो मरयां चे जिन्दा करी के, इसा गल्ला दा सबूत सारयां लोकां जो देई दितया है। ");
INSERT INTO bht_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","कितणे ही लोक उस बकत मजाक उड़ाणा लग्गे, जालू उनी मरयां चे जिन्दे होणे दी गल्ल बोली, पर कितणे ही बोलणा लग्गे, “ऐ गल्लां असां तिजो ला फिरी कदी सुणगे।” ");
INSERT INTO bht_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ऐ सुंणी करी पौलुस उना दे बीचे ला चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","पर कुछ लोक उस सोगी मिली गे, कने प्रभु पर भरोसा किता; जिना च दियुनुसियुस जड़ा अरियुपगुस दा सदस्य था, कने दमरिस नाऐ दी इक जनानी थी, कने उना सोगी होर भी कुछ लोक थे। ");
INSERT INTO bht_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","इदे बाद पौलुस एथेंस शेहरे जो छडी करी कुरिन्थुस शेहरे जो आया। ");
INSERT INTO bht_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","कने ओथु उसयो अक्विला नाए दा इक यहूदी मिल्ला, जिदा जन्म पुन्तुस प्रदेश च होया था; कने अपणी घरे बाली प्रिस्किल्ला सोगी इतालिया प्रदेश ला थोड़े बकत पेहले ही आया था, क्योंकि महाराजा क्लौदियुसे सारे यहूदियां जो रोम देशे ला निकली जाणे दा हुकम दितया था, उसी हुकमे दिया वजा ला सै कुरिन्थुस शेहरे जो आये। ");
INSERT INTO bht_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","पौलुस उना ला मिलणा गिया। पौलुस कने अक्विला दा इक ही कारोबार था; इस तांई तां सै उना सोगी रेईकरी कम्म करणा लग्गा, सै दोनों तम्बू बणाणे बाले थे। ");
INSERT INTO bht_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","कने पौलुस हर सब्ते दे रोजे यहूदी जंज घर च चर्चा करिरी यहूदियां कने यूनानियां जो भी यीशु मसीह पर भरोसा करणे तांई समझांदा था। ");
INSERT INTO bht_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","जालू सीलास कने तीमुथियुस मकिदुनिया प्रदेशे ला आये, तां पौलुसे तम्बूआं बणाणे दा कम्म छडी दिता कने अपणा सारा बकत बचन सुंणाणे च कने यहूदियां जो गबाई देणे च लाई दिता कि यीशु ही मसीहा है। ");
INSERT INTO bht_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","पर जालू यहूदी पौलुस दी बेइज्जती कने बिरोध करणा लग्गे, तां उनी अपणे कपड़यां दी धूड़ झाड़ी करी ऐ दसया की परमेश्वरे उना ला खुश नी है कने बोलया, “परमेश्वरे दे संदेश जो नी मनणे दिया बजा ला तुसां अपु ही उसा सजा तांई जिम्मेबार न, जड़ा तुसां जो परमेश्वर दी तरफा ला मिलणी है। मैं निर्दोष है। हुणे ला मैं होर जातियां बाल जाणा कने उना जो परमेश्वरे दे संदेश दा प्रचार करणा।” ");
INSERT INTO bht_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","कने पौलुस होर जाति दे लोकां जो बचन दी शिक्षा देंणे तांई यहूदियां दे जंज घरे ला चली करी तितुस युस्तुस नाऐ दे इक होर जाति दे माणुऐ दे घरे होर जातियां दे लोकां जो बचन दी शिक्षा देणा आया, कने सै माणु परमेश्वरे दी अराधना करदा था, कने उदा घर यहूदी जंज घरे ला नेड़े ही था। ");
INSERT INTO bht_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","तालू यहूदियों दे जंज घरे दे सरदार क्रिस्पुसे अपणे सारे परिबारे समेत प्रभुऐ पर भरोसा किता; कने मतयां कुरिन्थस शेहरे च रेणे बालयां लोकां पौलुसे जो सुणीकरी भरोसा किता कने बपतिस्मा लिया। ");
INSERT INTO bht_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","कने प्रभुऐ राती जो दर्शण देईकरी पौलुसे ने बोलया, “डर मत, बोली जा चुप मत रे; ");
INSERT INTO bht_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","क्योंकि मैं तेरे सोगी है, कने कोई तिजो पर हमला करी कि तेरा नुक्सान नी करी सकदा है, क्योंकि इस शेहरे च मते ऐसे लोक न जड़े मेरे लोक न।” ");
INSERT INTO bht_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","तांई तां पौलुस ओथु डेढ़ सालां दीकर परमेश्वरे दा बचन सिखांदा रिया। ");
INSERT INTO bht_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","जालू गल्लियो अखाया प्रदेशे दा हाकिम था तां यहूदी लोकां गिठे होईकरी पौलुसे दे खिलाफ खड़े होई गे, कने उसयो कचेरी च लेई गे कने बोलणा लग्गे, ");
INSERT INTO bht_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“कि परमेश्वरे दी भक्ति ऐसिया रितिया ला करा, जड़ा व्यवस्था ला बिलकुल उल्टा है।” ");
INSERT INTO bht_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","जालू पौलुस बोलणा ही लग्गा, तालू ही गल्लिया यहूदियां ला बोलया, “हे यहूदियों, अगर ऐ कोई अन्याय या बुराईया दी गल्ल होंदी तां ठीक था कि मैं तुहाड़ी सुणदा। ");
INSERT INTO bht_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","पर अगर ऐ बाद-बिबाद अखरां कने ना दा है, कने तुहाड़े यहूदी दी व्यवस्था दे बारे च है, तां तुसां ही जाणा; क्योंकि मैं इना गल्लां दा न्यायी नी बणना चांदा।” ");
INSERT INTO bht_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","कने गल्लियो हुकम दिता कि सै उना जो कडी दे कने उनी उना जो कचेरिया ला कडी दिता। ");
INSERT INTO bht_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","तालू सारे लोकां यहूदियों दे जंज घरे दे सरदार सोस्थिनेस जो पकड़ी करी कचेरिया सामणे ही मारणा शुरू करी दिता। पर गल्लिया इसा गल्ला दी कोई भी चिंता नी किती। ");
INSERT INTO bht_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पौलुस मते रोजां दीकर कुरिन्थुस शेहरे च रिया, फिरी मसीह भाईयां ला विदा लेईकरी क्रिंख्रिया शेहरे दिया बंदरगाह च जहाज तोपणे तांई चली गिया। कने उसी शेहरे च पौलुसे अपणा मुंडन कराई लिया, क्योंकि उनी इक सुखण सुखियो थी। बादे च सै पाणिये दे जहाजे ला सीरिया प्रदेश जो चली गिया। उदे सोगी प्रिस्किल्ला कने अक्विला भी थे। ");
INSERT INTO bht_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","कने सै इफिसुस शेहरे च आये कने पौलुसे प्रिसकिल्ला कने अक्विला जो ओथु ही छडी दिता। कने अपु इफिसुस शेहरे दे यहूदी जंज घर च जाई करी यहूदियां ने बाद-बिबाद करणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","उना उसला बिनती किती की, “साड़े सोगी थोड़े रोज होर रेई ले।” पर सै नी मनया; ");
INSERT INTO bht_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","पर पौलुस उना ला ऐ बोली करी विदा होया की, “अगर परमेश्वरे चाया तां मैं तुहाड़े बाल फिरी ओंगा।” तालू सै इफिसुस शेहरे ला जहाजे पर चढ़ी करी चली गिया; ");
INSERT INTO bht_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","कने सै कैसरिया शेहरे च उतरी करी यरूशलेम शेहरे जो गिया कने ओथु सै कलीसिया दे लोकां ला मिली करी अन्ताकिया शेहरे च आया। ");
INSERT INTO bht_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","फिरी थोड़े हफ्ते ओथु रेईकरी अन्ताकिया शेहरे ला चली गिया, कने गलातिया कने फ्रूगिया इलाकयां ला जांदे बेले ओथु दे सारे चेलयां जो मजबूत करदा गिया। ");
INSERT INTO bht_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","अपुल्लोस नाऐ दा इक यहूदी जिसदा जन्म सिकंदरिया शेहरे च होया था, सै बड़ा अकला बाला माणु था कने पबित्र शास्त्रां जो ढंगे ने जाणदा था, सै इफिसुस च आया। ");
INSERT INTO bht_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","उनी प्रभु दे रस्ते दी शिक्षा लियो थी, कने मन लाईकरी यीशुऐ दे बारे च सुणदा कने सिखांदा था, पर सै सिर्फ यूहन्ना दे बपतिस्मे दी गल्ल जाणदा था। ");
INSERT INTO bht_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","सै यहूदी जंज घरां च बिना डरयो बोलणा लग्गा, जालू प्रिस्किल्ला कने अक्विला उदियां गल्लां सुणीकरी, तां उना उसयो अपणे घरयो सदया कने परमेश्वरे दा रस्ता उसयो होर भी ढंगे ला दसया। ");
INSERT INTO bht_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","कने जालू अपुल्लोस अखाया प्रदेशे जो जाणा चांदा था, तां मसीह भाईयां उसयो प्रोत्साहित करिरी चेलयां जो लिखया कि सै उसला अच्छे ला मिलन, कने उनी ओथु पुज्जी करी उना लोकां दी बड़ी सहायता किती जिना अनुग्रह दिया बजा ला भरोसा कितया था। ");
INSERT INTO bht_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","क्योंकि सै सरेआम साबित करदा था की यहूदियां दी शिक्षा गलत है कने पबित्र शास्त्रे ला इदे सबूत भी दिन्दा था कि यीशु ही सै मसीहा है। ");
INSERT INTO bht_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","कने जालू अपुल्लोस कुरिन्थुस शेहरे च था, तां पौलुस सड़का दे जरिये अंदरूनी इलाके ला होईकरी इफिसुस शेहरे जो आया कने उदी मुलाकात कुछ चेलयां ला होई। ");
INSERT INTO bht_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","उनी बोलया, क्या तुहांजो भरोसा करदे बेले पबित्र आत्मा मिल्ली? उना उसयो बोलया, “असां तां पबित्र आत्मा दे बारे च सुणया भी नी है।” ");
INSERT INTO bht_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","तालू पौलुसे उना जो पुछया, “तां फिरी तुहाड़ा बपतिस्मा कियां होया?” उना बोलया, “असां यूहन्ना दा बपतिस्मा लिया।” ");
INSERT INTO bht_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","पौलुसे बोलया, “यूहन्ना उना लोकां जो बपतिस्मा दिता जिना पाप करणा छडी दितयो थे कने परमेश्वरे पासे मुड़ी गे, पर उनी इस्राएल दे लोकां जो बोलया कि उसी इकी पर विश्वास करा जड़ा मेरे बाद ओंणे बाला है, सै ही यीशु है।” ");
INSERT INTO bht_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ऐ सुणीकरी उना प्रभु यीशु दे नाऐ दा बपतिस्मा लिया। ");
INSERT INTO bht_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","कने जालू पौलुसे उना पर हथ रखया, तां उना पर पबित्र आत्मा उतरी, कने सै होर-होर बोलियां च बोलणा कने भविष्यवाणी करणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","सै सारे लगभग बारा मर्द थे। ");
INSERT INTO bht_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","कने तालू पौलुस यहूदी जंज घरे च जाई करी बिना डरयो तिन्न मिनयां दीकर बोलदा रिया, कने परमेश्वरे दे राज्य दे बारे च बेहस करदा कने समझांदा रिया। ");
INSERT INTO bht_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","पर उना बिचे ला कुछ लोक बड़े जिदी थे उना भरोसा करणे ला मना करी दिता, कने लोकां सामणे यीशु मसीह दे इस रस्ते जो बुरा भला बोलणा लग्गे, इस तांई पौलुस अपणे चेलयां जो सोगी लेईकरी ओथु ला चली गया, कने हर रोज तरन्नुस दे स्कूले च जाई करी भरोसा करणे बालयां जो परमेश्वरे दे बारे शिक्षा दिन्दा कने समझांदा था। ");
INSERT INTO bht_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","दो सालां दीकर ऐई होंदा रिया, कने आसिया प्रदेश दे रेहणे बाले सारयां यहूदियां कने सारे यूनानियां प्रभु दा बचन सुणी लिया। ");
INSERT INTO bht_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","कने परमेश्वर पौलुसे दे जरिये अनोखे चमत्कार दसदा था। ");
INSERT INTO bht_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ऐथू दीकर कि रूमालां कने तौलियां जो उदे शरीरे ला छुआई करी बिमारां पर रखदे थे, तां उना दियां बिमारियां खरियां होई जांदियां थियां; कने बुरियां आत्मा उना ला निकली जांदियां थियां। ");
INSERT INTO bht_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","पर कुछ यहूदी मर्द जड़े जादू टोणा करिरी बुरियां आत्मा जो कडदे थे, सै यीशु दा ना बुरियां आत्मा जो कडणे तांई करदे थे, कने सै ऐ बोलदे थे की, “मैं तुहांजो उस यीशु मसीह दे नाऐ ला जिदा प्रचार पौलुस करदा है बाहर निकलने दा हुकम दिन्दा है।” ");
INSERT INTO bht_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","कने स्क्किवा नाऐ दे इक यहूदी बड्डे याजके दे सत्त पुत्र थे, जड़े इयां ही करदे थे। ");
INSERT INTO bht_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","पर बुरियां आत्मा जबाब दिता, “यीशुऐ जो मैं जाणदी है कने पौलुसे जो भी जाणदी है, पर तू कुण है?” ");
INSERT INTO bht_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","कने उनी माणुऐ जिदे च बुरी आत्मा थी; उना पर झपटी करी, उना जो काबू करी लिया, कने उना दी ऐसी हालत किती, कि सै नंगे कने जख्मी होईकरी उसी घरे ला नठी गे। ");
INSERT INTO bht_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","कने जालू ऐ गल्ल इफिसुस शेहरे दे रेहणे बाले सारे यहूदी कने यूनानी जांणी गे, कने से सारे डरी गे; कने प्रभु यीशुऐ दे नाऐ दी महिमा किती। ");
INSERT INTO bht_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","कने जिना भरोसा कितया था, उना चे मतयां लोकां आई करी सबना सामणे अपणे गलत कम्मा जो मन्नी लिया। ");
INSERT INTO bht_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","कने जादू टोंणा करणे बालयां चे मतयां अपणियां-अपणियां पोथियाँ गिठियां करिरी सारे सामणे फुकी दितियां; कने जालू उना दी कीमत जोड़ी, तां सै पंजा झार चांदिये दे सिक्यां बराबर निकली। ");
INSERT INTO bht_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","इयां मतयां लोकां प्रभु यीशु दे बचना दे बारे च सुणया, कने बचन शक्तिशाली तरिके ला उना दियां जिंदगियां जो बदलदा गिया। ");
INSERT INTO bht_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","जालू ऐ गल्लां होई गियां तां पौलुसे मकिदुनिया प्रदेश कने अखाया प्रदेश दे भरोसा करणे बालयां ला मिलणे बाद यरूशलेम शेहरे जो जाणे दा फेसला किता, कने उनी बोलया, “यरूशलेम शेहरे जो जांणे बाद मिंजो रोम शेहरे जो जाणा भी जरूरी है।” ");
INSERT INTO bht_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","इस तांई उनी अपणे साथियां चे तीमुथियुस कने इरास्तुस जो मकिदुनिया प्रदेश अपु ला पेहले भेजी दिता, कने अपु कुछ बकत आसिया प्रदेशे दे इफिसुस शेहरे च रेई पिया। ");
INSERT INTO bht_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","उस बेले यीशु मसीह दे रस्ते दे बारे च बड़ा हंगामा होया। ");
INSERT INTO bht_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","क्योंकि देमेत्रियुस नाऐ दा इक चांदी दा कारीगर था, जड़ा अरतिमिस यूनानी देवी दे मंदरे दे चांदी दे ढांचे बणवांदे था, कने कारीगरां जो उना बणाणे तांई बड़े पैसे दिन्दा था। ");
INSERT INTO bht_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","दिमेत्रियुसे अपणे कारीगरां जो सदया कने इयोदियां चीजां दे कारीगरां जो गिठे करिरी बोलया, “हे भाईयो, तुसां जाणदे न कि इसी कम्मे ला सांझो कितणा पैसा मिलदा है। ");
INSERT INTO bht_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","कने तुसां दिखदे कने सुणदे न कि सिर्फ इफिसुस शेहरे च ही नी, बल्कि सारे आसिया प्रदेश दे सारे ग्रां च, इनी पौलुसे ऐ बोली करी मते लोकां जो समझाया कने भटकाया भी है, कि जड़ी हथां दी कारीगिरी है, सै ईश्वर नी है। ");
INSERT INTO bht_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","कने सिर्फ इसा इकी गल्ला दा ही डर नी है, कि साड़े इस कम्मे दी इज्जत मान चली जाणा; बल्कि ऐ की हुण लोकां महान देवी अरतिमिसा दे मंदरे जो भी महत्व नी देणा कने खुद देवी अरतिमिस जिसा जो पूरे आसिया प्रदेशे च कने सारे संसारे दे लोक पूजदे न उसा दी इज्जत मान नी होणा।” ");
INSERT INTO bht_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","सारे कारीगर ऐ सुणीकरी गुस्से च आई गे कने चीलाई-चीलाई करी बोलणा लग्गे, “इफिसियों दी अरतिमिस, महान है।” ");
INSERT INTO bht_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","शेहरे दे केई होर लोकां चिल्लाणे दियां अबाजां सुणियां कने सै भी जाई करी भिड़ा सोगी मिली गे कने सारे शेहरे च हंगामा होई गिया कने लोकां गयुस कने अरिस्तर्खुस कने मकिदुनिया प्रदेशे दे रेणे बालयां जो जड़े पौलुसे सोगी यात्री थे, पकड़ी लिया, कने गिठे होईकरी रंगशाला च दोड़ी गे। ");
INSERT INTO bht_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","पौलुस भी रंगशाला दे अंदर जाई करी लोकां ला गल्ल बात करणा चांदा था, पर चेलयां उसयो जाणा नी दिता। ");
INSERT INTO bht_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","आसिया दे हकीमा चे भी उदे दोस्तां उसयो बोली भेजया कने बिनती किती, की रंगशाला दे अंदर जाई करी अपणी जान खतरे च मत पांदा। ");
INSERT INTO bht_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","रंगशाला दे अंदर, सारे लोक चिल्ला दे थे, कोई कुछ बोला दा था कने कोई कुछ होर। सारा कुछ गड़ बड़ था, कने मते लोक तां ऐ जाणदे भी नी थे कि असां कजो गिठे होयो न। ");
INSERT INTO bht_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","तालू यहूदी लोकां सिकन्दरे जो भिड़ा चे धक्का देईकरी अग्गे करी दिता, कने सिकन्दरे लोकां जो चुप रेणे तांई हथे ला इशारा किता कने लोकां जो समझाणे दी कोशिश किती कि क्या होआ दा है। ");
INSERT INTO bht_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","पर जालू उना जो पता लग्गा कि सै यहूदी है, कने जड़े मसीही लोकां सांई मूर्तिपूजा नी करदे थे, तां सारे दे सारे इकी अबाजा च कोई दो घंटे दीकर चिलांदे रे, “इफिसियों दी अरतिमिस, महान है।” ");
INSERT INTO bht_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","तालू शेहरे दे मंत्रिऐ लोकां जो शांत करिरी बोलया, “हे इफिसियों दे वासियों, सारे जाणदे न कि इफिसुस शेहरे दे लोक महान देवी अरतिमिस दे मंदरे दी कने उदिया मूर्तिया दी रखबाली करदे न जड़ी अम्बरे ला पियो थी। ");
INSERT INTO bht_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","जालू कोई इना गल्लां ला इनकार नी करी सकदा है, तां ठीक है कि तुसां चुप रिया; कने बिना सोचया बिचारयो कुछ मत करा। ");
INSERT INTO bht_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","क्योंकि तुसां इना माणुऐ जो लेईकरी आयो न, जड़े ना ता मंदरे जो लूटणे बाले न, कने ना ही साड़िया देविया दी बुराई करणे बाले न। ");
INSERT INTO bht_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","इसी वजा ला अगर देमेत्रियुस कने उदे साथी कारीगरां जो कुसी ला कोई दिक्कत है तां कचेरी खुली है, उना दे मुकदमे दा इन्साफ करणे तांई अधिकारी भी हेन; ओथु लोक इकी दुज्जे पर इलजाम लगाई सकदे न। ");
INSERT INTO bht_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","पर अगर तुसां कुसी होर गल्ला दे बारे च कुछ पूछणा चांदे न, तां शेहरे दिया सभा च फेसला होणा। ");
INSERT INTO bht_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","क्योंकि मिजों डर है की राज्यपाले इस सारे हंगामे दे बारे च सुणना कने बोलणा कि असां रोमी सरकार दे खिलाफ विद्रोह करणे दी कोशिश करा दे थे। इस तांई कि इदी कोई बजा नी है, कि असां इसा भिड़ा दे गिठे होणे दा जबाब नी देई सकणा।” ");
INSERT INTO bht_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","कने ऐ बोली करी उनी सभा जो बीदा किता। ");
INSERT INTO bht_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","जालू हंगामा रुकी गिया तां पौलुसे चेलयां जो सदीकरी उत्साहित किता, कने उना जो अलविदा बोली करी मकिदुनिया प्रदेश जो चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","सै उस सारे प्रदशे चे होईकरी कने चेलयां जो बड़ा उत्साहित करिरी सै यूनान प्रदेश च आया। ");
INSERT INTO bht_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","तिन्न महीने रेईकरी जालू सै ओथु ला जाजे पर सीरिया प्रदेश जो जांणा लगया था, पर उनी सुणया कि यहूदियां उसयो रस्ते च मारणे दी सलाह बणाईयो है, इस तांई उनी फेसला किता की मकिदुनिया प्रदेशे ला बापस ओंदे होए सीरिया प्रदेशे जो जाऐ। ");
INSERT INTO bht_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","इसा यात्रा च बिरिया शेहरे दे वासी पुरूर्स दा पुत्र सोपत्रुस कने थिस्सलुनीकिया शेहरे ला अरिस्तर्खुस कने सिकुन्दुस कने दिरबे शेहरे दा गयुस, कने तीमुथियुस कने आसिया प्रदेशे दा तुखिकुस कने त्रुफिमुस उदे सोगी चली पै। ");
INSERT INTO bht_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","कने सोगी यात्री सांझो ला अग्गे चली गे कने त्रोआस शेहरे च पुज्जी करी सांझो नियालना लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","कने अखमीरी रोटियां दे त्योहारे दे बाद फिलिप्पी शेहरे ला जाजे पर चड़ी करी उना बाल पंजा रोजां बाद त्रोआस शेहरे च पुज्जे, कने सत्त रोज ओथु ही रे। ");
INSERT INTO bht_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","हफ्ते दे पेहले रोजे असां जालू प्रभु भोज खाणे तांई गिठे होए, तां पौलुसे जिनी दुऐ रोजे चली जाणा था, उना ला गल्लां कितियां, कने अधिया राती दीकर उना जो उपदेश दिन्दा रिया। ");
INSERT INTO bht_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","जिस उपरे बाले कमरे पर असां गिठे होयो थे, ओथु मते दिय्ये बल्यो थे। ");
INSERT INTO bht_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","कने युतुखुस नाऐ दा इक जवान खिड़किया च बेईकरी निंद्रा ने झुला दा था, कने जालू पौलुस बड़िया देरा दीकर गल्लां करदा रिया, तां सै निंद्रा दे झुटारे ने तिजिया मंजली ला पेई गिया, कने जालू कुछ लोकां आई करी उसयो चुक्या तां तालू दिकर सै मरी गिया था। ");
INSERT INTO bht_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पर पौलुस थले उतरया कने उदे बाल जाई करी उसयो गले ने लाईकरी बोलया, “घबरा मत; क्योंकि ऐ हल्ले भी जिंदा है।” ");
INSERT INTO bht_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","कने उनी दुबारा उपर जाई करी प्रभु भोज किता, कने अगली भयागा होणे दिकर गल्लां करदा रिया; कने फिरी सै चली गिया। ");
INSERT INTO bht_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","फिरी सै उस जवाने जो ओथु ला जिन्दा लेई गे, कने बड़े खुश होऐ। ");
INSERT INTO bht_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","पौलुसे अस्सुस शेहरे तांई जमिनी यात्रा करणे दा फेसला किता, बाकी असां लोक समुन्द्री जाजे ला अग्गे चली गे, कने असां ओथु ला उसयो अपणे सोगी जहाजे च लेई जाणे दी योजना बणा दे थे। ");
INSERT INTO bht_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","जालू पौलुस अस्सुस शेहरे च सांझो मिल्ला तां असां उसयो जाजे पर चढ़ाई करी मितुलेने शेहरे जो आये। ");
INSERT INTO bht_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","दुऐ रोजे ओथु ला यात्रा करदे होये असां खियुस टापू च पुज्जे कने उसला अगले रोजे उदे बखे ला होईकरी सामुस टापू च पुज्जे कने उसला अगले रोजे मीलेतुस शेहरे जो आऐ। ");
INSERT INTO bht_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","क्योंकि पौलुसे इफिसुस शेहरे च नी जाणे दा फेसला किता क्योंकि सै आसिया प्रदेशे च होर जादा बकत नी बिताणा चांदा था, ताकि कुथी ऐसा ना होए कि, उसयो आसिया शेहरे च देर लग्गे; क्योंकि सै जल्दिया च था, कि अगर होई सके, तां सै पिन्तेकुस्त दे त्योहारे बाले रोजे यरूशलेम शेहरे च बकते पर पुज्जे। ");
INSERT INTO bht_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","कने जालू असां मीलेतुस शेहरे च उतरे, तालू पौलुसे इफिसुस शेहरे दिया कलीसिया दे अगुवां जो संदेशा गलाई भेजया की, सै आई करी उसयो मिलन। ");
INSERT INTO bht_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","जालू सै उदे बाल आये, तां उनी उना जो बोलया, “तुसां जाणदे न, कि मैं कियां तुहाड़े सोगी रिया, पेहले ही रोजे ला जालू मैं आसिया प्रदेशे च पुज्जा, तां मैं सारा बकत तुहाड़े सोगी ही बिताया। ");
INSERT INTO bht_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","मतलब की बड़िया दीनता ला, कने रोई-रोई करी, कने उना परीक्षां च जड़ियां यहूदी लोकां दिया साजिशा दिया बजा ला मिंजो पर आईयां, मैं तमी प्रभु दी सेबा करदा रिया। ");
INSERT INTO bht_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","कने जड़ियां-जड़ियां गल्लां तुहाड़े फायदे दियां थियां, उना जो दसणे तांई कने लोका दे सामणे कने घरे-घरे जाई करी सिखाणे ला भी कदी नी डरया। ");
INSERT INTO bht_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","कने यहूदी लोकां कने होर जातियां सामणे गबाई दिन्दा रिया कि परमेश्वरे सामणे अपणे पापां जो मनी लिया कने गलत कम्मा जो छडी दिया, कने साड़े प्रभु यीशु पर भरोसा करा। ");
INSERT INTO bht_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","कने हुण, मैं पबित्र आत्मा दे जरिये मजबूर होईकरी यरूशलेम शेहरे जो चलया है, कने मिंजो नी पता कि ओथु मिंजो पर क्या-क्या बितणी है, ");
INSERT INTO bht_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","सिर्फ ऐई कि पबित्र आत्मा हर शेहरे च चेताबनी देईकरी मिंजो ला बोलदा है कि बंधन कने क्लेश तिजो तांई तैयार न। ");
INSERT INTO bht_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","पर मिंजो अपणी जिन्दगी ला कोई प्यार नी है, मैं तां बस अपणिया उसा दोड़ा जो, कने उस सेबा जो पूरा करणा चांदा, जड़ी मिंजो परमेश्वरे दे अनुग्रह दे शुभसमाचार पर गबाई देणे तांई प्रभु यीशुऐ ला मिलियो है। ");
INSERT INTO bht_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","कने मैं तुसां सारयां बिच परमेश्वरे दे राज्य दा प्रचार किता, कने हुण मैं जाणदा है तुसां चे कोई भी मिंजो दुबारा नी दिखणा। ");
INSERT INTO bht_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","इस तांई अजे दे दिन तुसां ला गबाई देईकरी बोलदा है, कि तुसां च अगर कोई भी यीशु पर भरोसा कितयो बिना मरी जादां है, तां से मेरी गलती नी है। ");
INSERT INTO bht_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","क्योंकि मैं तुसां जो सै सब कुछ दसया है जड़ा परमेश्वर चांदा है कि तुसां जाणन। ");
INSERT INTO bht_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","इसी तांई अपणी कने अपणे झुंडे दी देखभाल करा; जिना च पबित्र आत्मा तुहांजो अगुवा बणाया है ताकि तुसां परमेश्वरे दिया कलीसिया दी रखवाली करन, क्योंकि परमेश्वरे उना जो अपणे पुत्रे दा खून देईकरी खरीदया है। ");
INSERT INTO bht_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","मैं जाणदा है, कि मेरे जाणे बाद तुसां बिच झूठे गुरूआं ओणा है कने उना भरोसा करणे बालयां दा बड़ा नुकसान करणा। सै उना फाड़ने बाले भेड़ियां सांई होणे जड़े भेडां जो मारी दिन्दे न। ");
INSERT INTO bht_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ऐथू दिकर की तुहाड़े अपणे भरोसा करणे बालयां दे दले चे ऐसे लोक ओणे न, जिना चेलयां जो अपणे पिच्छे खीचणे तांई उल्टियां सिदियां गल्लां करणियां न। ");
INSERT INTO bht_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","इस तांई ध्यान रखा, कने याद रखा कि मैं तिन्ना सालां दीकर रात दिन रोई-रोई करी, हर इकी जो चेताबनी देणा नी छडया। ");
INSERT INTO bht_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","कने हुण मैं तुहांजो परमेश्वरे जो, कने उदे अनुग्रह दे बचना जो सौंपी दिन्दा है; जड़ा तुसां दे भरोसे जो मजबूत करी सकदा है, कने परमेश्वरे तुसां जो सै बिरासत देणी जिसा दा बायदा उनी उना सारयां लोकां ला कितया है जड़े उदे जरिये पबित्र कितयो न। ");
INSERT INTO bht_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","मैं कुदे भी सोने, चांदी या कपड़े दा लालच नी किता। ");
INSERT INTO bht_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","तुसां तां अपु ही जाणदे न कि इना हथां ही मेरी कने मेरे साथियां दी जरुरतां पुरियां कितियां न। ");
INSERT INTO bht_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","मैं तुहांजो सब कुछ करिरी दसया है की, कड़ी मेहनत करिरी सांझो कमजोरां दी सहायता करणी चाईदी कने प्रभु यीशु दे बचना जो याद रखणा जरूरी है, प्रभुऐ अपु ही बोलया है: लेणे ला देणा धन्य है।” ");
INSERT INTO bht_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ऐ बोली करी उनी घुटणे टेके कने उना सबना सोगी प्राथना किती। ");
INSERT INTO bht_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तालू सै सारे बड़े रोए कने पौलुसे दे गले लगी करी उसयो चुमणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","सै खासकर इसा गल्ला तांई दुखी थे, जड़ी उनी बोली थी, तुसां मिंजो फिरी दुबारा नी दिखणा। कने उना उसयो जाजे दीकर पूजाया। ");
INSERT INTO bht_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","असां जालू उना ला विदा लेईकरी समुंद्री यात्रा शुरू किती, तां असां सीधे रस्ते ला कोस टापु च आऐ, कने दुऐ रोजे रूदुस टापु च, कने ओथु ला पतरा शेहरे च पुज्जी गे; ");
INSERT INTO bht_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","कने पतरा शेहरे ला इक जाज सांझो फीनीके प्रदेश जो जांदा होया मिल्ला, कने असां उदे पर चढ़ी करी यात्रा शुरू करी दिती। ");
INSERT INTO bht_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","असां खबे पासे साइप्रस टापु दिखया कने असां ओथु ला निकली करी सीरिया प्रदेशे दिया सीमा पासे अग्गे चली गे कने सूर शेहरे च जाई पुज्जे क्योंकि ओथु जाजे ला समान उतारणा था। ");
INSERT INTO bht_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","कने ओथु असां कुछ चेलयां जो तोपया कने असां ओथु उना सोगी सत रोजां दीकर रे। उना पबित्र आत्मा दे जरिये हर बार पौलुसे ला यरूशलेम शेहरे जो नी जाणे दी विनती करदे रे। ");
INSERT INTO bht_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","सत्त रोज बाद जालू ओथु ला साड़े जाणे दा बकत आया, कने सै सारे जनानिया कने बचयां समेत सांझो शेहरे ला बारे दीकर पुजाया कने असां समुंद्रे बखे घुटणे टेकी करी प्राथना किती। ");
INSERT INTO bht_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","तालू इकी दुज्जे ला विदा होईकरी, असां तां जाजे पर चढ़ी गे, कने सै अपणे-अपणे घरे जो बापस चली गे। ");
INSERT INTO bht_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","जालू असां सूर शेहरे ला शुरू कितियो यात्रा पुरी करिरी असां पतुलिमयिस शेहरे च पुज्जे, कने मसीही भाईयां जो नमस्ते करिके उना सोगी इक रोज रे। ");
INSERT INTO bht_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","दुऐ रोजे असां ओथु ला चली करी कैसरिया शेहरे च आये, कने फिलिप्पुस शुभसमाचार प्रचार करणे बाले दे घरे जाई करी रे, सै उना सतां मर्दा चे इक था जिना जो यरूशलेम शेहरे च प्रेरितां विधवां दी देखभाल करणे तांई चुणयां था। ");
INSERT INTO bht_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","उदियां चार कुआरियां कुड़ियां थियां; जड़ियां भविष्यवाणी करदियां थियां। ");
INSERT INTO bht_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","जालू सांझो कैसरिया शेहरे च रेंदे होए मते रोज होई गे, तां ओथु अगबुसे नाऐ दा इक परमेश्वर दा संदेश देंणे वाला यहूदिया प्रदेशे ला आया। ");
INSERT INTO bht_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","उनी साड़े बाल आई करी पौलुसे दा कमरबंद लिया, कने उसयो अपणे हथा पैरां च बन्नी करी बोलया, “कि पबित्र आत्मा ऐ बोलदी है, कि जिस माणुऐ दा ऐ कमरबन्द है, उसयो यरूशलेम शेहरे च यहूदियां इयां ही बनणा है कने होर जातियां दे हथे देई देणा है।” ");
INSERT INTO bht_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","असां जालू ऐ गल्लां सुणियां, तालू असां कने ओथु दे लोकां पौलुसे ला बिनती किती कि, यरूशलेम शेहरे जो मत जांदा। ");
INSERT INTO bht_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","पर पौलुसे जबाब दिता, तुसां क्या करा दे न, रोई-रोई करी मेरा मन तोड़ा दे न? मैं तां प्रभु यीशुऐ दे नाऐ तांई यरूशलेम शेहरे च सिर्फ बनुणे तांई ही नी बल्कि मरणे तांई भी तैयार है। ");
INSERT INTO bht_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","जालू सै नी मनया तां असां ऐ बोली करी चुप होई गे, “प्रभुऐ दी इच्छा पुरी हो।” ");
INSERT INTO bht_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","थोड़े रोजां बाद असां तैयारी किती कने यरूशलेम शेहरे जो चली पे। ");
INSERT INTO bht_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरिया शेहरे दे भी कुछ चेले साड़े सोगी चली पे, कने सै सांझो मनासोन नाऐ दे बंदे दे घरे लेई गे, जड़ा यरूशलेम शेहरे च रेंदा था कने साइप्रस टापू दा था, सै सबना ला पेहले दे चेलयां चे इक था। ");
INSERT INTO bht_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","असां जालू यरूशलेम शेहरे च पुज्जे, तां भरोसा करणे बाले भाईयां साड़ा बड़िया खुशिया ला स्वागत किता। ");
INSERT INTO bht_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","दुऐ रोजे पौलुस सांझो सोगी याकूबे दे घरे गिया, जिथू सारे अगुवे गिठे होयो थे। ");
INSERT INTO bht_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","तालू पौलुसे उना जो नमस्कार किता, कने जड़े-जड़े कम्म परमेश्वरे पौलुसे दिया सेवकाईया दे जरिये होरनी जातियां च कितयो थे, सै सारे कम्म इक-इक करिरी उना जो दस्से। ");
INSERT INTO bht_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","अगुवां ऐ सुणीकरी परमेश्वरे दी महिमा किती, फिरी उना बोलया, हे भाई पौलुस, तू जाणदा है न, कि यहूदियां चे केई हजारां लोकां भरोसा किता है; कने सै सारे मूसा दिया व्यवस्था दा पालन बड़िया बफादारिया ला करदे न। ");
INSERT INTO bht_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","कने कुछ लोकां उना यहूदियां जो दसया जिना दा तेरे बारे च ऐ विशवास है, कि तू होर जातियां च रेणेबाले यहूदियां जो मूसा दी व्यवस्था जो छडी देणे तांई सिखांदा है, कने बोलदा है, कि ना बचयां दा खतना करा कने ना ही इना यहूदी रिती-रिबाजां पर चला। ");
INSERT INTO bht_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","तां फिरी क्या करणा चाईदा? उना जो पक्का ऐ पता लग्गी जाणा है कि तू ऐथू आया है। ");
INSERT INTO bht_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","इस तांई जड़ा असां तिजो बोलदे न, सै कर। साड़े ऐथू चार माणु न, उना जो सै मन्नत पूरी करणी है जड़ी उना परमेश्वरे दे सामणे मनियो है। ");
INSERT INTO bht_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","उना जो लेईकरी उना सोगी अपणे आपे जो शुद्ध करणे दिया बिधिया जो पूरा कर; कने उना तांई खर्चा दे, ताकि सै सिर मुंडवाई सकन। तालू सारयां जो पता लगणा, कि जड़ियां गल्लां उना तेरे बारे च सुणियां न, सै गल्लां सच नी न, कने तू अपु भी मूसा दिया व्यवस्था जो मन्नी करी उदे अनुसार चलदा है। ");
INSERT INTO bht_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","पर उना होर जातियां दे बारे च जिना भरोसा कितया है, असां ऐ फेसला करिरी चिठ्ठी लिखी भेजी है, की सै उस खाणे जो ना खान जिसयो लोकां मूर्तियां जो चढ़ाया हो, कने व्यभिचार मत करदे कने गल्लां घोटी करी मारयो जानवरां दा मॉस कने खून मत खांदे। ");
INSERT INTO bht_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","दूऐ रोजे पौलुसे उना माणुआं सोगी जाई करी अपु जो शुद्ध किता, तां सै मंदरे जो गे, कने ऐ घोषणा किती, कि शुद्धी दे रोज कालू मुकणे न, मतलब की उना चे हर इकी तांई भेंट चढ़ाणे दे दिन कालू पुरे होंणे। ");
INSERT INTO bht_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","जालू सै सत्त रोज पुरे होणे बाले थे, तां आसिया प्रदेशे दे कुछ यहूदियां पौलुसे जो मंदरे च दिखीकरी सारयां जो भड़काया, फिरी पौलुसे जो पकड़ी लिया कने चिल्लाणा लग्गे, ");
INSERT INTO bht_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“हे इस्राएलियां, सहायता करा; ऐ सै ही माणु है, जड़ा हर जगा साड़े यहूदी लोकां दे, कने मूसा दिया व्यवस्था दे कने इसा जगा दे खिलाफ च सारे लोकां जो सिखांदा है, ऐथू दीकर की होर जाति दे लोकां जो भी इस मंदरे च आंणी करी इस पबित्र जगा जो अपबित्र करी दिता है।” ");
INSERT INTO bht_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","उना ऐसा बोलया क्योंकि इसला पेहले इफिसुस शेहरे दे वासी त्रुफिमुस जो पौलुस सोगी शेहरे च दिखया था, कने समझदे थे कि पौलुस उसयो मंदरे च लेई आया है। ");
INSERT INTO bht_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","तालू शेहरे च हल्ला पेई गिया, कने लोक दोड़ी करी गिठे होऐ, कने पौलुसे जो पकड़ी करी मंदरे बार घसीटी लेई आये, कने झट दरबाजे बंद करी दिते। ");
INSERT INTO bht_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","जालू सै पौलुसे जो मारी देंणे दी कोशिश करा दे थे, तां रोमी सिपाईयां दे सरदारे जो खबर पुज्जी कि यरूशलेम शेहरे च मते सारे लोक हंगामा करा दे न। ");
INSERT INTO bht_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","तालू सै झट सिपाईयां कने सुबेदारां जो लेईकरी उना बाल आया; कने लोकां दिया भीड़ा सरदारे जो कने सिपाइयां जो दिखीकरी पौलुसे जो मारणा बंद करी दिता। ");
INSERT INTO bht_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","तालू पलटना दे सरदारे पौलुसे बाल आई करी उसयो पकड़ी लिया; कने दो सुंगला ला बनणे दा हुकम देईकरी पूछणा लग्गा, “ऐ कुण है, कने इनी क्या कितया है?” ");
INSERT INTO bht_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","पर भिड़ा चे कोई कुछ बोलणा लग्गा कने कोई कुछ, कने जालू रोले दिया बजा ला सच्चाई पता नी लग्गी, तां उसयो किले च लेई जांणे दा हुकम दिता। ");
INSERT INTO bht_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","जालू सै पोड़ियां पर पुज्जा, तां इयां होया कि भिड़ा दिया बजा ला सिपाईयां जो उसयो चुकी करी लेई जांणा पिया। ");
INSERT INTO bht_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","क्योंकि लोकां दी भीड़ ऐ बोली करी पिच्छे पियो थी, इसयो मारी दिया। ");
INSERT INTO bht_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","जालू सै पौलुसे जो किले च अंदर लेई जाणा लगयो थे, तां उनी पलटना दे सरदारे जो बोलया, क्या मिंजो इजाजत है कि मैं तिजो कुछ बोलें? उनी बोलया, “क्या तू यूनानी भाषा जांणदा है? ");
INSERT INTO bht_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","क्या तू सै मिस्र देशे दा माणु नी है, जिनी कुछ बकत पेहले सरकारा दे खिलाफ बिरोध कितया था कने चार जार आतंकियों जो सुनसान जगा च लेई गिया था?” ");
INSERT INTO bht_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पौलुसे बोलया, “नी, मैं तां इक यहूदी है, कने किलिकिया प्रदेशे दे खास तरसुस शेहरे दा रेणे बाला है। कने मैं तिजो ला बिनती करदा है, कि मिंजो लोकां ने गल्लां करणा दे।” ");
INSERT INTO bht_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","जालू उनी हुकम दिता, तां पौलुसे पथरे दिया पोड़ियां पर खड़ोई करी लोकां जो चुप रेणे तांई हथे ला इशारा किता। तालू सै चुप होई गे, तां सै इब्रानी भाषा बोलणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“हे भाईयों कने बजुर्गो सुणा, जड़े इल्जाम मिंजो पर लगयो न, उदे बचाव च मैं कुछ तुहाड़े सामणे बोलणा है।” ");
INSERT INTO bht_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","सै ऐ सुणीकरी कि सै सांझो ला इब्रानी भाषा च बोला दा है, सै होर भी चुप होई गे। तालू उनी बोलया: ");
INSERT INTO bht_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","मैं यहूदी है, मेरा जन्म किलिकिया प्रदेशे दे तरसुस शेहरे च होया है; पर इस शेहरे च गमलीएल दे पैरां बाल बेईकरी शिक्षा लियो है, कने पूर्वजां दी व्यवस्था भी मिंजो ठीक रीतिया ला सिखाई; कने हुण जदिया उत्साह परमेश्वरे तांई तुहाड़ा है, तदिया ही मेरा भी था। ");
INSERT INTO bht_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","मैं प्रभु यीशु मसीह दे रस्ते जो खत्म करणे तांई इदे चेलयां जो बड़ा सताया। मैं मर्द कने जनानिया दोनो जो बन्नी करी, जेला च पाई करी, उना जो मरवाई भी दिता। ");
INSERT INTO bht_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","खुद महायाजक कने अगुवां दी सारी सभा भी गबाह न कि, मैं उना ला यहूदी भाईयां तांई चिठियां लेईकरी दमिश्क शेहरे जो चलया था, ताकि जड़े ओथु न उना जो सजा देंणे तांई बन्नी करी यरूशलेम शेहरे जो लेई ओऐ। ");
INSERT INTO bht_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","जालू मैं चलदे-चलदे दमिश्क शेहरे बखे पुज्जा, तां इयां होया कि लगबग दोपहर दे बकते अचानक अम्बरे ला मेरे चारो पासे इक लौ चमकी। ");
INSERT INTO bht_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","कने मैं जमिना पर पेई गिया: कने ऐ अबाज सुणोई, हे शाऊल, हे शाऊल, तू मिंजो कजो तंग करदा है? ");
INSERT INTO bht_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","मैं जबाब दिता, हे प्रभु जी, तू कुण है? उनी मिंजो बोलया, मैं नासरत शेहरे दा रेणे बाला यीशु है, जिसयो तू तंग करदा है। ");
INSERT INTO bht_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","कने मेरे साथियां लौ चमकदी तां दिखी, कने जड़ा मिंजो सोगी बोला था उना उदी अबाज सुणी, पर सै समझी नी सके की अबाजा मिंजो ला क्या बोलया। ");
INSERT INTO bht_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","तालू मैं बोलया, प्रभु जी मैं क्या करे? प्रभुऐ मिंजो ने बोलया, उठी करी दमिश्क शेहरे जो जा कने जड़ा कुछ तू करणा है सै तिजो ओथु दसी देणा है। ");
INSERT INTO bht_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","जालू उसा लौई दिया चमका दिया बजा ला मिंजो कुछ भी मिल्ला दा नी था, तां मैं अपणे साथियां दा हथ पकड़ी करी दमिश्के शेहरे जो आया। ");
INSERT INTO bht_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","तालू हनन्याह नाऐ दा व्यवस्था दे अनुसार इक धर्मी माणु, जड़ा ओथु रेणेबाले सारे यहूदियां च इज्जतदार था, सै मेरे बाल आया, ");
INSERT INTO bht_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","कने मेरे बखे खड़ोई गिया कने मिंजो ला बोलया, हे भाई शाऊल, दुबारा दिखणा लग्गी पो। तालू ही मेरियां हखी खुली गियां कने मिंजो दुबारा मिलणा लग्गी पिया। ");
INSERT INTO bht_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","तालू उनी बोलया, साड़े बाप दादयां दे परमेश्वरे तिजो इस तांई चुणया है ताकि तू उदिया इच्छा जो जांणे, कने उस धर्मी जन जो दिखे, कने उदी अबाज सुणे। ");
INSERT INTO bht_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","क्योंकि तू उदिया तरफा ला सारे माणुआं सामणे इना गल्लां दा गबाह होणा, जड़ियां तू दिखियां कने सुणियां न। ");
INSERT INTO bht_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","हुण कजो देर करा दा है? उठ, कने बपतिस्मा ले, कने प्रभु दा ना लेईकरी अपणे पापां जो धोई ले। ");
INSERT INTO bht_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","मैं जालू फिरी यरूशलेम शेहरे च आई करी मंदरे च प्राथना करा दा था, तां मैं बेसुध होई गिया। ");
INSERT INTO bht_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","कने मैं प्रभु जो दिखया कने उसयो ऐ बोलदे सुणया, “झट पट करिरी यरूशलेम शेहरे ला निकली जा; क्योंकि जड़े लोक ऐथू न उना मेरे बारे च तेरी गबाई नी मनणी है।” ");
INSERT INTO bht_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","मैं बोलया, प्रभु जी मिंजो समझ नी आया की यरूशलेम शेहरे च यहूदियां मिजों पर भरोसा कनी करणा क्योंकि सै तां अपु ही जाणदे न की मैं तिजो पर भरोसा करणे बालयां जो जेला च पांदा कने मारदे-मारदे यहूदी जंज घरां ला लेई जांदा था। ");
INSERT INTO bht_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","कने जालू तेरे गबाह स्तिफनुसे जो मारा दे थे, तालू मैं भी ओथु खड़ोतया था, कने उसा गल्ला ला राजी था, कने उसयो मारणे बालयां दे कपड़यां दी रखवाली करा दा था। ");
INSERT INTO bht_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","कने प्रभूये मिंजो बोलया, तू चली जा: क्योंकि मैं तिजो होरनी जातियां बाल दूर-दूर भेजणा है। ");
INSERT INTO bht_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ऐथू दीकर तां लोक पौलुसे दिया गल्ला जो ध्याने ला सुणदे रे पर, फिरी सै जोरे ला बोलणा लग्गे, “ऐसे माणुऐ जो मारी दिया, इदा जिन्दा रेंणा ठीक नी।” उना ऐसा इस तांई बोलया क्योंकि सै नी मंदे थे की परमेश्वर यहूदियां जो छडी करी कुसी होरसी जातिया जो बचाई सकदा है। ");
INSERT INTO bht_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","जालू सै चिलांदे कने अपणे कपड़े फेंकदे कने अपणा गुस्सा दसणे तांई होआ च धुड़ उडांदे थे; ");
INSERT INTO bht_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","तां पलटना दे सूबेदारे बोलया, “इसयो किले च लेई जा; कने कोड़े मारी करी परखा, ताकि मैं भी जांणे कि लोक कुसा बजा ला इदे खिलाफ ऐसा बोला दे न।” ");
INSERT INTO bht_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","जालू सै उसयो कोड़े मारणे तांई बन्ना दे थे तां पौलुसे उस सुबेदारे ने बोलया जड़ा उदे बखे खड़ोतया था, “क्या ऐ ठीक कि तुसां इक रोमी माणुऐ जो, बिना दोष साबित होयो कोड़े मारन?” ");
INSERT INTO bht_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","सूबेदारे ऐ सुणीकरी सरदारे बाल जाई करी बोलया, “तू ऐ क्या करा दा है? ऐ तां रोमी माणु है।” ");
INSERT INTO bht_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","तालू सरदारे उदे बाल आई करी बोलया, मिंजो दस, क्या तू रोमी है? “उनी बोलया, हाँ।” ");
INSERT INTO bht_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ऐ सुणीकरी सरदारे बोलया, मैं रोमी होणे दा पद मते पैसे देईकरी लिया है। पौलुसे बोलया, “मैं तां जमदा ही रोमी है।” ");
INSERT INTO bht_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","तालू जड़े लोक उसयो परखा दे थे, सै झट उदे बखे ला हटी गे; कने सरदार भी ऐ जाणी करी कि ऐ रोमी है, कने मैं उसयो बनया है, सै डरी गे। ");
INSERT INTO bht_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","सूबेदार ऐ जाणना चांदा था कि यहूदी लोक उदे पर कजो दोष ला दे न, इस तांई उनी बड्डे याजकां कने सारिया महासभा जो गिठे होणे दा हुकम दिता। उना जो रिहा किता, पौलुसे जो थले आंणी करी उना दे सामणे खड़ा किता। ");
INSERT INTO bht_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पौलुसे महासभा पासे ध्यान लाईकरी दिखया, कने बोलया, “हे भाईयो, मैं अजे दीकर परमेश्वरे तांई बिलकुल सच्ची अंतरात्मा ला जिन्दगी कटी है।” ");
INSERT INTO bht_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","पौलुसे जड़ा बोलया सै सुणीकरी हनन्याह महायाजके, उना जो जड़े उदे बखे खड़ोतयो थे, पौलुस दे मुऐ पर थप्पड़ मारणे दा हुकम दिता। ");
INSERT INTO bht_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","तालू पौलुसे उना जो बोलया, “है पाखंडी, परमेश्वरे तिजो मारणा। तू मूसा दी व्यवस्था दे अनुसार मेरा न्याय करणे जो बैठया है, कने फिरी भी मिंजो मारणे दा हुकम देईकरी व्यवस्था दे खिलाफ जा दा है?” ");
INSERT INTO bht_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","जड़े बखे खड़ोतयो थे, उना बोलया, “क्या तू परमेश्वरे दे महायाजक दी बेईजती करदा है?” ");
INSERT INTO bht_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पौलुसे बोलया, “हे भाईयो, मैं नी जाणदा था, कि ऐ महायाजक है; क्योंकि पबित्र शास्त्र च लिखया है, अपणे लोकां दे प्रधाने जो बुरा मत बोल।” ");
INSERT INTO bht_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","तालू पौलुसे ऐ जाणी करी, कि कुछ सदूकी लोक न कने कुछ फरीसी लोक न, महासभा च पुकारी करी बोलया, “है भाईयो, मैं फरीसी कने फरीसियां दे बंशे दा है, कने मेरा मुकदमा इस तांई होआ दा है क्योंकि मिंजो आस है की परमेश्वरे मरयो लोकां जो दुबारा जिन्दा करणा।” ");
INSERT INTO bht_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","जालू उनी ऐ गल्ल बोली तां फरीसियां कने सदूकियां च होणा लग्गी, कने सभा च फुट पेई गेई। ");
INSERT INTO bht_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","क्योंकि सदूकी लोक ऐ भरोसा करदे न की लोकां मरणे बाद जिन्दा नी होंणा, ना कोई स्वर्गदूत न कने ना आत्मा है; पर फरीसी लोक इना सबना पर भरोसा करदे न। ");
INSERT INTO bht_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","तालू बड़ा रोला पिया कने कुछ व्यवस्था जो सिखाणे बाले जड़े फरीसी थे, उठी करी ऐ बोली करी बेहस करणा लग्गे, “सांझो इस माणुऐ च कोई बुराई नी मिली है; कने होई सकदा है की इक आत्मा या स्वर्गदूते उसला गल्ल किती हो।” ");
INSERT INTO bht_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","जालू लड़ाई बड़ी बदी गेई, तां पलटना दे सरदारे इसी डरे ला कि सै पौलुसे दे टोटे-टोटे नी करी देंन, इस तांई उनी पलटना जो हुकम दिता की सभा दे लोकां बीचे ला पौलुसे जो बचाई करी किले च लेई जा। ");
INSERT INTO bht_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","उसा ही राती प्रभु यीशुऐ पौलुस दे बखे आई करी बोलया, “हे पौलुस, हिम्मत रख; क्योंकि जियां तू यरूशलेम शेहरे च मेरी गबाई दितियो है, तियां ही तिजो रोम शेहरे च भी मेरी गबाई देंणी पोंणी है।” ");
INSERT INTO bht_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","जालू भ्याग होई तां कुछ यहूदी माणुआं गिठे होईकरी सलाह किती, कने कसम खादी कि जालू दीकर असां पौलुसे जो मारी ना देन, अगर असां खादा या पीता तां सांझो पर लानत है। ");
INSERT INTO bht_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","जिना ऐ कसम खादियो थी, सै चालियां जणयां ला जादा थे। ");
INSERT INTO bht_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","उना बड्डे याजकां कने यहूदी अगुवां बाल आई करी बोलया, “असां ऐ कसम खादियो है कि जालू दीकर असां पौलुसे जो मारी नी देंन, तालू दीकर असां अगर कुछ भी चखन तां सांझो पर लानत है। ");
INSERT INTO bht_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","इस तांई हुण तुसां कने महासभा मिलिकरी पलटना दे सरदारे जो समझा कि पौलुसे जो तुहाड़े बाल लेई ओऐ, भाना मारा कि तुसां उदे बारे च होर भी ठीक तरीके ला जांच करणा चांदे न, कने असां उदे पूजणे ला पेहले ही उसयो रस्ते च मारणे तांई तैयार रेंगे।” ");
INSERT INTO bht_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","पर पौलुसे दे भांजे सुणाया कि यहूदी लोक उसयो मारणे दी योजना बणा दे न, तां उनी किले च जाई करी पौलुसे जो खबर दिती। ");
INSERT INTO bht_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","पौलुसे सुबेदारां चे इकी जो सदीकरी बोलया, “इसी जवाने जो पलटना दे सरदारे बाल लेई जा, ऐ उसला कुछ बोलणा चांदा है।” ");
INSERT INTO bht_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","इस तांई सुबेदार पौलुसे दे भांजे जो पलटना दे सरदारे बाल लेईजाई करी बोलया, “केदी पौलुसे मिंजो सदीकरी बिनती किती, कि ऐ जवान पलटना दे सरदारे ला कुछ बोलणा चांदा है, इसयो उस बाल लेई जा।” ");
INSERT INTO bht_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","पलटना दे सरदारे उसयो हथ पकड़ी करी, कने उसयो लग लेईजाई करी पुछया, “तू मिंजो ला क्या बोलणा चांदा है?” ");
INSERT INTO bht_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","उनी बोलया, “यहूदियां गिठे होईकरी योजना बणाईयो, कि तिजो ला बिनती करन कि कल पौलुसे जो महासभा च लोऐ, कने ऐसा लग्गे कि तू होर ठीक ढंगे ला उदी जांच करणा चांदा है। ");
INSERT INTO bht_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","पर कृपा करिरी तू उना दिया बिनतिया पर ध्यान मत दिन्दा, क्योंकि उना चे चालियां ला जादा माणु पौलुसे जो मारणे दिया ताका पर न, उना ऐ कसम खादियो है कि जालू दीकर असां पौलुसे जो नी मारगे, तालू दीकर ना खाणा है ना पिणा है, कने सै हुण तैयार न कने तेरे बचने दा इतंजार करा दे न।” ");
INSERT INTO bht_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","तालू पलटना दे सरदारे जवाने जो ऐ हुकम देईकरी भेजया, “कुसी ला मत बोलदा कि तू मिंजो ला ऐ गल्लां बोलियां न।” ");
INSERT INTO bht_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","तालू पलटना दे सरदारे दो सूबेदारां जो सदीकरी बोलया, “अज राती नौ बजे दीकर दो सो सपाई, सत्तर सवार, कने दो सो भाले बाले, कैसरिया शेहरे जो जाणे तांई तैयार रखा।” ");
INSERT INTO bht_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","कने पौलुसे दिया सवारिया तांई घोड़े जो तैयार रखा ताकि उसयो फेलिक्स राज्यपाले बाल ठीक-ठाक पुजाई सकन। ");
INSERT INTO bht_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","पलटना दे सरदारे राज्यपाले जो इक चिठ्ठी भी लिखी: ");
INSERT INTO bht_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“महाप्रतापी फेलिक्स राज्यपाले जो क्लौदियुस लुसियास दिया तरफा ला नमस्कार; ");
INSERT INTO bht_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","इस माणुऐ जो यहूदी पकड़ी करी मारणा चांदे थे, पर जालू मिंजो पता लग्गा कि ऐ रोमी है, तां पलटन भेजी करी छुड़ाई लांदा। ");
INSERT INTO bht_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","कने मैं जाणना चांदा था, कि सै इस पर कुसा बजा ला दोष लांदे न, इस तांई उसयो उना दी महासभा च लेई गिया। ");
INSERT INTO bht_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","तालू मैं जाणी लिया, कि सै अपणिया यहूदी व्यवस्था दे विवादां दे बारे च उदे पर दोष लगा दे न, पर ऐ कोई ऐसा दोष नी है, जिदे तांई उसयो मौत दी सजा या जेल होए। ");
INSERT INTO bht_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","कने जालू मिंजो दसया कि सै इस माणुऐ जो मारणे दिया ताका पर न, तां मैं झट उसयो तेरे बाल भेजी दिता; कने उना यहूदियां जो जिना उस पर दोष लाया है हुकम दिता, कि तेरे सामणे उदे पर दोष लान।” ");
INSERT INTO bht_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","सिपाइयां जो जड़ा हुकम दितया था तियां ही सै पौलुसे जो लेईकरी रातो रात अन्तिपत्रिस शेहरे च लेई आऐ। ");
INSERT INTO bht_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","दुऐ रोजे उना घुड़सवारां जो पौलुसे सोगी कैसरिया शेहर जाणे तांई छडी दिता कने सपाई अपु पैदल यरूशलेम शेहरे दे किले जो मुड़ी आऐ। ");
INSERT INTO bht_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","उना कैसरिया शेहरे च पुज्जी करी राज्यपाले जो चिठ्ठी दिती; कने पौलुसे जो भी उदे सामणे खड़ा किता। ");
INSERT INTO bht_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","राज्यपाले चिठ्ठी पढ़ी करी पुछया, “ऐ कुसी देशे दा है? कने जालू ऐ सब जाणी लिया कि सै किलिकिया प्रदेशे दा है।” ");
INSERT INTO bht_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","तां उसयो बोलया, “जालू सै लोक ओंगे जिना तिजो पर दोष लाया है, तालू मैं तेरा मुकद्दमा सुणना है।” कने उनी पौलुसे जो राजा हेरोदेसे दे किले च पेहरे च रखणे दा हुकम दिता। ");
INSERT INTO bht_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पंजा रोजा बाद हनन्याह महायाजक केई यहूदी अगुवां कने तिरतुल्लुस नाऐ दे बकिले जो सोगी लेईकरी कैसरिया शेहरे च आया; उना राज्यपाल दे सामणे पौलुसे पर दोष लाऐ। ");
INSERT INTO bht_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","जालू पौलुसे जो ओथु सदया, तां तिरतुल्लुसे उस पर दोष लाईकरी बोलया, “हे महाप्रतापी फेलिक्स, तेरिया बजा ला असां बड़िया शांतिया ला रे दे न, कने तेरे इंतजाम ला इसा जातियां तांई कितणियां बुराइयां सुधरा दियां न। ");
INSERT INTO bht_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","इसयो असां हर जगा कने हर तरीके ला धन्याबाद सोगी मंदे न। ");
INSERT INTO bht_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","पर मैं तेरा जादा बकत नी लेंणा चांदा है, मैं तिजो ला बिनती करदा है, कि कृपा करिरी थोड़ी देर साड़ी सुणी ले। ");
INSERT INTO bht_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ऐ माणु संसारे दे सारे यहूदियां बिच मतभेद कने मुसीबत पैदा करा दा है, कने ऐ इक ऐसे कुपंथे दे अगुवां चे भी है, जिस पंथे जो लोक नासरत दे यीशुऐ दे पिच्छे चलणे बाला पंथ बोलदे न। ");
INSERT INTO bht_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","उनी मंदरे जो अशुद्ध करणा चाया, कने तालू असां उसयो बंदी बणाई लिया। असां उसयो अपणिया व्यवस्था दे अनुसार सजा देणा चांदे थे; ");
INSERT INTO bht_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","पर पलटना दे सरदारे लुसियासे आई करी जबरदस्ती उसयो साड़े हथा ला छुड़ाई लिया, ");
INSERT INTO bht_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","कने इदे पर दोष लांणे बालयां जो तेरे बाल ओंणे दा हुकम दिता। इना सारियां गल्लां जो जिना दे बारे च असां उदे पर दोष ला दे न, तू अपु ही उसयो जाँची करी सच्चाईया जो जाणी लेंणा है।” ");
INSERT INTO bht_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","यहूदियां भी उदा साथ देईकरी बोलया, ऐ गल्लां बिलकुल ठीक न। ");
INSERT INTO bht_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","जालू राज्यपाले पौलुसे जो बोलणे तांई इशारा किता तां उनी जबाब दिता: “मैं ऐ जाणी करी कि तुसां इस देशे दा बड़े सालां ला न्याय करा दा है, इस तांई मैं खुशिया ला अपणा जबाब दिन्दा है।” ");
INSERT INTO bht_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","तू अपु ही पता लगाई सकदा है, कि जालू ला मैं यरूशलेम शेहरे च अराधना करणा मन्दरे च आया है, मिंजो बारा रोजां ला उपर नी होऐ न। ");
INSERT INTO bht_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","उना मिंजो ना मंदरे च, ना यहूदी जंज घरां च, कने ना शेहरे च कुसी ने बेहस करदे या ना भिड़ा जो गिठा करदे दिखया; ");
INSERT INTO bht_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","कने ना ही सै उना गल्लां जो, जिना दे बारे च सै हुण मिंजो पर दोष ला दे न, तेरे सामणे सच्च साबित करी सकदे न। ");
INSERT INTO bht_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","पर मैं तेरे सामणे ऐ मनी लेंदा है, कि मैं मसीह दे पंथे दा चेला होईकरी अपणे पूर्वजां दे परमेश्वरे दी सेबा करदा है, जिसी पंथे जो ऐ माणु यहूदी झूठा पंथ बोलदे न: कने जड़ियां गल्लां मूसा दिया व्यवस्था च कने परमेश्वरे दा संदेश देणेबालयां दियां कताबां च लिखियाँ न, उना पर भरोसा करदा है। ");
INSERT INTO bht_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","कने परमेश्वरे पर आस रखदा है, जड़ी सै अपु भी रखदे न, कि परमेश्वरे धर्मी कने अधर्मी दोनो जो मरयां चे जिन्दा करी देणा। ");
INSERT INTO bht_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","इस तांई मैं अपु भी परमेश्वरे कने लोकां सामणे अपणी अंतरात्मा जो निर्दोष रखणे दी पूरी कोशिश करदा है। ");
INSERT INTO bht_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","मतयां सालां बाद मैं अपणे गरीब लोकां जो दान कने परमेश्वरे जो बलिदान चड़ाणे तांई यरूशलेम शेहरे च आया था। ");
INSERT INTO bht_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","उसी बकत उना मिंजो मंदरे च शुद्ध होणे दे रिबाजां जो पूरा करदे दिखया। ओथु ना तां कोई भिड़ थी कने ना ही कोई हल्ला था। ");
INSERT INTO bht_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","पर ओथु आसिया प्रदेशे दे कुछ यहूदी लोक थे, जिना हंगामा किता। अगर मैं कुछ गलत कितया था, तां उना जो मिंजो पर दोष लांणे तांई ऐथू तेरे सामणे होणा चाईदा था। ");
INSERT INTO bht_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","या इना माणुआं जो अपु ही बोलणा चाईदा, कि जालू मैं महासभा दे सामणे खड़ोतया था, तां उना जो मिंजो पर कुण दिया दोष मिल्ला? ");
INSERT INTO bht_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","सिर्फ इक दोष है जड़ा सै मेरे खिलाफ लाई सकदे न, सै ऐ है जालू मैं अंगणे च जोरे ला बोलया था, “पर ऐ मुकदमा मेरे पर इस तांई चलया है क्योंकि मैं भरोसा करदा है की परमेश्वरे उना लोकां जो जड़े मरी गियो न दुबारा जिन्दा करणा।” ");
INSERT INTO bht_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","राज्यपाल फेलिक्से जड़ा इसी पंथे दियां गल्लां जो अच्छे ला जाणदा था, उनी सुणवाई जो ऐ बोली करी स्थगित करी दिता, “कि जालू पलटना दा सरदार लुसियास ओंगा, तां तुहाड़िया गल्लां दा न्याय करगा।” ");
INSERT INTO bht_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","कने सूबेदार जो हुकम दिता, कि पौलुसे जो थोड़ी छुट देईकरी उसयो पेहरे च रखा, पर उदे दोस्तां चे कुसयो भी इदी सेबा करणे ला मत रोकदे। ");
INSERT INTO bht_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","थोड़े रोजां बाद राज्यपाल फेलिक्स अपणी घरे बाली द्रुसिल्ला जो, जड़ी यहूदी थी, सोगी लेईकरी पौलुसे ला मिलणा आया कने पौलुसे जो सदया, कने उस भरोसे दे बारे च उसला सुणया जड़ा यीशु मसीह पर है। ");
INSERT INTO bht_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","जालू पौलुसे धार्मिकता कने अपणी इच्छां पर काबू रखणा कने परमेश्वरे जरिये होंणे बाले न्याय दे बारे च दसणा शुरु किता, तां फेलिक्से डरीकरी जबाब दिता, “इस बकत तां तू जा; जालू मेरे बाल बकत होंगा तां मैं तिजो दुवारा सदी लेंगा।” ");
INSERT INTO bht_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","हालांकि फेलिक्स उना गल्लां दे बारे च डरदा था जड़ियां पौलुसे बोलियां थियां, फिरी भी सै पौलुसे जो सददा था, कने उस सोगी गल्लां करदा था क्योंकि सै सोचदा था की सै जेला ला छुटणे तांई उसयो कुछ पैसे दिंगा। ");
INSERT INTO bht_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","पर जालू दो साल बीती गे, तां पुरकियुस फेस्तुस, फेलिक्से दिया जगा पर राज्यपाल बणी गिया, कने फेलिक्स यहूदियां जो खुश करणे दिया इच्छा ला पौलुसे जो केदी ही छडी गिया। ");
INSERT INTO bht_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","उना रोजां बाद राज्यपाल फेस्तुस दे रुपे च यहूदिया प्रदेश च आया। फिरी सै कैसरिया शेहरे ला यरूशलेम शेहरे जो गिया। ");
INSERT INTO bht_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","तालू बड्डे याजकां, कने यहूदियां दे अगुवां, उदे सामणे पौलुसे पर दोष लाऐ; ");
INSERT INTO bht_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","कने उसला बिनती किती की उना दा समर्थन करे कि सै पौलुस जो यरूशलेम शेहरे च सदे, क्योंकि उना उसयो रस्ते च ही मारी देंणे थी योजना बणाईयो थी। ");
INSERT INTO bht_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","फेस्तुसे जबाब दिता, “पौलुस कैसरिया शेहरे च केदी है, कने मैं अपु जल्दी ओथु जाणा है।” ");
INSERT INTO bht_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","फिरी बोलया, “तुसां ने जड़े बड्डे माणु न, सै मेरे सोगी चलन, कने अगर उनी माणुऐ कुछ गलत कम्म कितया है, तां उस पर दोष लगान।” ");
INSERT INTO bht_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","यरूशलेम शेहरे च कोई अठ दस रोज रेईकरी सै कैसरिया शेहरे जो गिया: कने दुऐ रोजे न्याय-आसने पर बेईकरी पौलुसे जो लोंणे दा हुकम दिता। ");
INSERT INTO bht_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","जालू सै आया, तां यहूदी अगुवे जड़े यरूशलेम शेहरे ला आयो थे, उना अखे बखे खड़ोई करी उदे पर बड़े भरी दोष लाऐ, पर उना बाल इना दोषां जो सच्च साबित करणे तांई कोई सबूत नी था। ");
INSERT INTO bht_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","पर पौलुसे जबाब दिता, “मैं ना तां यहूदियां दिया व्यवस्था दे कने ना मंदरे दे, कने ना महाराजा कैसरे दे खिलाफ कोई अपराध कितया है।” ");
INSERT INTO bht_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","तालू फेस्तुसे यहूदी अगुवां जो खुश करणे दिया इच्छा ला पौलुसे जो पुच्छया, “क्या तू चांदा है की तेरे इना दोषां दी सुणवाई मेरे सामणे यरूशलेम शेहरे च हो?” ");
INSERT INTO bht_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","पौलुसे बोलया, “मैं महाराजा कैसरे दे न्याय-आसने सामणे खड़ोतया है: ठीक ऐई है की मेरे मुकद्दमे दी सुणवाई ऐथू ही होणा चाईदी। मैं यहूदी लोकां दे खिलाफ कोई भी अपराध नी कितया है, कने इसा गल्ला जो तू भी अच्छे ला जाणदा है। ");
INSERT INTO bht_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","अगर अपराधी है कने मौत दी सजा देंणे जोगा कोई कम्म कितया है, तां मैं मरणे ला नी मूकरदा है; पर जिना गल्लां दा ऐ मिंजो पर दोष ला दे न, अगर उना चे कोई गल्ल सच्च नी है, तां कुसी जो भी ऐ हक नी है की मिंजो इना दे हथे देई दे। मेरी बिनती है की मेरा न्याय महाराजा दे हथे ला होणा चाईदा।” ");
INSERT INTO bht_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","तालू फेस्तुसे अपणिया सभा सोगी बिचार करिरी जबाब दिता, “तू महाराजा केसरे दे हथे ला न्याय होंणे दी मांग किती है, तां तिजो महाराजा कैसरे बाल ही भेजणा है।” ");
INSERT INTO bht_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","थोड़े रोज होणे बाद राजा अग्रिप्पे कने उदी छोटी बेहण बिरनीके कैसरिया शेहरे च आई करी राज्यपाल फेस्तुसे ला मिल्ले। ");
INSERT INTO bht_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","उना जो ओथु मते रोज रेहणे बाद फेस्तुसे उना ने पौलुसे दे बारे च दसया, “इक माणु है, जिसयो फेलिक्स केदी छडी गिया है। ");
INSERT INTO bht_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","जालू मैं यरूशलेम शेहरे च था, तां बड्डे याजकां कने यहूदी अगुवां उस पर दोष लाऐ कने चांदे थे, कि उसयो मौत दी सजा हुकम मिल्ले। ");
INSERT INTO bht_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","पर मैं उना जो जबाब दिता, कि रोमियां दा ऐ रिबाज नी है, कि कुसी माणुऐ जो सजा देंणे तांई सौंपी देंन, जालू दीकर आरोपी जो अपणे दोष लांणे बालयां सामणे खड़े होईकरी दोषां दे जबाब देंणे दा मोका ना मिल्ले। ");
INSERT INTO bht_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","इस तांई जालू यहूदी अगुवे मेरे सोगी ऐथू कैसरिया शेहरे च आये, तां मैं कोई देर नी किती, कने दुऐ ही रोजे न्याय-आसने पर बेईकरी, पौलुसे जो अदालता च लोंणे दा हुकम दिता। ");
INSERT INTO bht_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","जालू उस पर दोष लांणे बाले खड़ुते, तां उना ऐसिया बुरियां गल्लां दा दोष नी लाया, जदिया मैं समजदा था। ");
INSERT INTO bht_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","पर उना बिच अपणे धर्मे जो लेईकरी कने यीशु नाऐ दे माणुऐ दे बारे च कुछ झगड़ा था, जड़ा मरी गिया था, पर पौलुस दाबा करदा था की यीशु जिन्दा है। ");
INSERT INTO bht_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","क्योंकि मिंजो नी पता था की इना गल्लां दी जांच पड़ताल कियां करे, इस तांई मैं पौलुसे जो पुच्छया, क्या तू यरूशलेम च शेहरे च मुकदमे दी सुणवाई तांई राजी है। ");
INSERT INTO bht_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","पर जालू पौलुसे बिनती किती की महाराजा कैसर ही मेरा न्याय करे, तां मैं हुकम दिता, कि जालू दीकर मैं उसयो महाराजा कैसरे बाल नी भेजें, उदी रखबाली किती जाऐ।” ");
INSERT INTO bht_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","तालू अग्रिप्पे फेस्तुसे जो बोलया, “मैं भी उस माणुऐ दी सुणना चांदा है।” उनी बोलया, “तू कल सुणी लियां।” ");
INSERT INTO bht_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","दुऐ रोजे, जालू अग्रिप्पे कने बिरनीके बड़ी धूम धाम ला आई करी पलटना दे सरदारां कने शेहरे दे खास-खास लोकां सोगी दरबारे च पुज्जे। तालू फेस्तुसे हुकम दिता, कि सै पौलुसे जो लेई ओआ। ");
INSERT INTO bht_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","फेस्तुसे बोलया, “हे राजा अग्रिप्पे, हे सारे लोक जड़े ऐथू साड़े सोगी न, तुसां इसी माणुऐ जो दिखा दे न, जिदे बारे च सारे यहूदियां यरूशलेम शेहरे च कने ऐथू भी चिलाई-चिलाई करी मिंजो ला बिनती किती, कि इदा जिन्दा रेंणा ठीक नी है। ");
INSERT INTO bht_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","पर मैं जांणी लिया कि उनी ऐदिया कुछ नी कितया है कि इसयो मौत दी सजा मिल्ले; कने जालू की उनी अपु ही बिनती किती की महाराजा धिराज मेरा न्याय करे, तां मैं उसयो भेजणे दा फेसला किता। ");
INSERT INTO bht_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","पर मिंजो उदे बारे च कोई भी पक्की गल्ल नी लगी कि महाराजा जो लिखें, इस तांई तां मैं उसयो तुहाड़े सामणे कने खास करिरी राजा अग्रिप्पे तेरे सामणे लांदा है, ताकि जांचणे बाद मिंजो कुछ लिखणे जो मिल्ले। ");
INSERT INTO bht_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","क्योंकि केदिये जो भेजणा कने जड़े दोष उदे पर लायो न, उना जो नी दसणा, मिंजो ठीक नी लग्गा दा है।” ");
INSERT INTO bht_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","राजा अग्रिप्पे पौलुसे जो बोलया, “तिजो अपणे बारे च बोलणे दी इजाजत है।” तालू पौलुसे हथ चुकी करी लोकां जो शांत किता, तालू सै अपणे बचाव च बोलणा लग्गा, ");
INSERT INTO bht_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","हे राजा अग्रिप्पे, जितणियां गल्लां दा यहूदी अगुवे मिंजो पर दोष लांदे न, अज तेरे सामणे उना दा जबाब देंणे तांई मैं अपणे आपयो जो धन्य समझदा है, ");
INSERT INTO bht_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","क्योंकि तू यहूदियां दे सारे रिबाजां कने समस्यां जो अच्छे ला जाणदा है। इस तांई मैं बिनती करदा है, अच्छे ला मेरी सुणी ले। ");
INSERT INTO bht_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","जदिया मेरा चाल-चलण बचपन ला लेईकरी अजे दीकर अपणे लोकां च कने यरूशलेम शेहरे च था, ऐ सब यहूदी जाणदे न। ");
INSERT INTO bht_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","सै मिंजो तालू ला जाणदे न जालू मैं बच्चा था, सै चांदे न तां इसा सच्चाईया दी गबाई भी देई सकदे न की, मैं फरीसियां दा इक सदस्य रिया है, जड़ा साड़े धर्मे दा सारयां ला कट्टर पंथ है। ");
INSERT INTO bht_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","अज मैं परमेश्वरे जरिये साड़े पूर्वजां जो दितयो बायदे दिया आसा दिया बजा ला ऐथू दोषिऐ दे रुपे च खड़ोतया है। ");
INSERT INTO bht_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","उसी बायदे जो पूरा होणे दी आसा च, साड़े बारा गोत्र अपणे सारे मने ला दिन रात परमेश्वरे दी सेबा करदे आये न। हे राजा, ऐ उसा आशा दिया बजा ला है की परमेश्वरे सेई करणा जड़ा उनी बायदा कितया था की ऐ यहूदी मिंजो पर दोष ला दे न। ");
INSERT INTO bht_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","तालू पौलुसे सुणने बालयां चे सारे यहूदियां जो बोलया, तुसां लोक भरोसा करदे न की परमेश्वर मरयां जो दुबारा जिन्दा करी सकदा है, तां तुसां इसा गल्ला पर भरोसा करणे जो कजो मना करदे न की उनी यीशु मसीह हो मरयां चे जिन्दा किता? ");
INSERT INTO bht_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“मेरा भी पक्का भरोसा था कि नासरत बासी यीशुऐ दे खिलाफ मिंजो मता कुछ करणा चाईदा।” ");
INSERT INTO bht_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","कने मैं यरूशलेम शेहरे च इयां ही कितया; कने बड्डे याजकां ला हक पाई करी बड़े पबित्र लोकां जो जेला च पाया, कने जालू उना जो मारी दिन्दे थे, तां मैं भी उना दे खिलाफ अपणी सेहमती दिन्दा था। ");
INSERT INTO bht_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","कने मैं हर यहूदी जंज घर च उना जो सजा दिलादां कने उना जो यीशुऐ दी निंदा करणे तांई मजबूर करदा था, ऐथू दीकर गुस्से ला ऐसा पागल होई गिया था कि दुज्जे शेहरां च जाई करी उना जो तंग करदा था। ");
INSERT INTO bht_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“इसी ही मकसदे सोगी जालू मैं बड्डे याजकां ला अधिकार कने हुकम दी चिठ्ठी लेईकरी दमिश्के शेहरे जो चलया था; ");
INSERT INTO bht_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","तां हे राजा, रस्ते च लगभग दोपेरा दे बेले मैं अम्बरे ला सूरजे दिया चमका ला भी जादा चमकदी इक लौ अपणे कने अपणे सोगी चलणे बालयां दे चारो पासे चमकदी दिखी। ");
INSERT INTO bht_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","कने जालू असां सारे धरती पर डेई पे, तां मैं इब्रानी भाषा च, मिंजो ला बोलदे इक अबाज सुणी, ‘हे शाऊल, हे शाऊल, तू मिंजो कजो तंग करदा है? हरबरी जालू तू मिंजो दुखी करणे दी कोशिश करदा है, तालू तू अपु जो ही दुखी करदा है।’ ");
INSERT INTO bht_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","मैं बोलया, प्रभु जी, तू कुण है? प्रभुऐ बोलया, मैं यीशु है जिसयो तू तंग करदा है। ");
INSERT INTO bht_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","पर तू उठ, अपणे पैरां पर खड़ा हो; क्योंकि मैं तिजो दर्शण इस तांई दिता है ताकि तिजो उना गल्लां दा भी सेवक कने गबाह बणां, जड़ियां तू दिखियां न, कने उना दा भी जिना तांई मैं तिजो दर्शण देणा है। ");
INSERT INTO bht_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","कने मैं तिजो तेरे लोकां ला कने होर जातियां ला बचादा रेंगा, जिना बाल मैं तिजो इस तांई भेजणा है। ");
INSERT INTO bht_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","कि तू उना दियां हखी खोले, ताकि सै नेहरे ला लौई पासे, कने शैताने दे अधिकारे ला परमेश्वरे पासे ओंन; तां परमेश्वरे उना दे पाप माफ करणे, कने उना लोकां सोगी बिरासत मिल्ले, जड़े मिंजो पर भरोसा करणे ला पबित्र होयो न। ");
INSERT INTO bht_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","इस तांई हे राजा अग्रिप्पा, मैं उस स्वर्गीय दर्शने दी गल्ला दा पालन किता, ");
INSERT INTO bht_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","मैं पेहले दमिश्के शेहरे दे, फिरी यरूशलेम शेहरे दे रेणे बालयां जो, फिरी सारे यहूदिया प्रदेश च कने होर जातियां जो प्रचार किता, कि पाप करणा छडी दिया कने परमेश्वरे पासे फिरी करी ऐसे कम्म करा ताकि तुहाड़िया जिन्दगिया ला पता लग्गे की तुसां अपणे पापां ला पश्चाताप करी लिया है। ");
INSERT INTO bht_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","इसा गल्ला दिया बजा ला यहूदी मिंजो मंदरे च पकड़ी करी मारी देंणे दी कोशिश करा दे थे। ");
INSERT INTO bht_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","पर परमेश्वरे दिया सहायता ला मैं अजे दीकर ठीक है कने छोटे बड्डे सारयां दे सामणे गबाई दिन्दा है। कने मैं इना गल्लां दे सिवा कुछ नी बोलणा है, सै परमेश्वरे दे संदेश देणेबालयां कने मूसा भी बोलया है कि होंणे बालियां न, ");
INSERT INTO bht_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","कि मसीह जो दुख झेलणा पोंणा है, कने सै मरयां चे जिन्दा होणेबाला पैला जन होणा, इस तरीके ला उनी यहूदियां च कने होर जातियां च ज्योति दा प्रचार किता।” ");
INSERT INTO bht_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","जालू पौलुस इसा रीतिया ला जबाब दे दा था, तां फेस्तुसे जोरे ला बोलया, “हे पौलुस, तू पागल है। मतिया बिद्या तिजो पागल करी दितया है।” ");
INSERT INTO bht_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","पर उनी बोलया, “हे महाप्रतापी फेस्तुस, मैं पागल नी है, पर सच्चाईया कने अकली दियां गल्लां बोला दा है। ");
INSERT INTO bht_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","राजा भी ऐ गल्लां जाणदा है जिदे सामणे मैं बिना डरयो बोला दा है, कने मिंजो भरोसा है इना गल्लां चे कोई भी गल्ल उसला छुपियो नी है, क्योंकि जड़ा यीशुऐ सोगी होया सै गुप्त च नी होया है। ");
INSERT INTO bht_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","हे राजा अग्रिप्पे, क्या तू परमेश्वरे दा संदेश देणेबालयां दा भरोसा करदा है? हां, मैं जाणदा है, कि तू भरोसा करदा है।” ");
INSERT INTO bht_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","हुण अग्रिप्पे पौलुसे जो बोलया, “कि तू क्या थोड़े दे समझाणे ला मिंजो मसीही बणाणां चांदा है?” ");
INSERT INTO bht_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पौलुसे बोलया, “मेरी परमेश्वरे ला ऐ प्राथना है कि क्या थोड़े च, कने क्या मते च, सिर्फ तू ही नी, पर जितणे भी लोक मेरी सुणदे न, मेरे इना बंधणा जो छडी करी मेरे सांई मसीह पर भरोसा करणे बाले होई जान।” ");
INSERT INTO bht_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","तालू राजा अग्रिप्पा कने राज्यपाल फेस्तुस कने उदी छोटी बेहण बिरनीके कने उदे सोगी बैठयो सारे उठी होऐ कने चली गे; ");
INSERT INTO bht_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","जालू सै बाहर जा दे थे, सै इक दुज्जे ला बोलणा लग्गे, “इनी माणुऐ ऐसा कोई अपराध नी कितया है जिदिया बजा ला उसयो मौत दी सजा या जेल हो।” ");
INSERT INTO bht_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","राजा अग्रिप्पे राज्यपाल फेस्तुसे जो बोलया, “अगर ऐ माणु महाराजा कैसरे ला अपणे न्याय दी मांग नी करदा, तां छुटी सकदा था।” ");
INSERT INTO bht_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","जालू फेस्तुस राज्यपाले ऐ गल्ल पक्की किती कि असां जाजे पर इतालिया प्रदेशे जो जांणा है, तां उना पौलुसे कने कुछ होर केदियां जो भी युलियुस नाऐ दे महाराजा औगुस्तुसे दिया पलटना दे इक सरदारे दे हथे सौंपी दिता। ");
INSERT INTO bht_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","अद्रमुत्तियुम शेहरे दे इक जाजे पर जड़ा आसिया प्रदेशे दे कंढे दिया जगा जो जाणे तांई तैयार था, असां उस पर चढ़ी करी समुंद्री यात्रा शुरू किती, कने अरिस्तर्खुस नाऐ दा इक माणु जड़ा मकिदुनी प्रदेशे दे थिस्सलुनीके शेहरे दा बासी था, सै साड़े सोगी था। ");
INSERT INTO bht_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","दुऐ रोजे असां सैदा शेहरे च पुज्जी गे कने युलियुसे पौलुसे पर कृपा करिरी उसयो दोस्तां बाल जाणा दिता ताकि उना ला जरूरी चीजां लेई ओऐ। ");
INSERT INTO bht_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ओथु ला असां दुबारा यात्रा शुरू किती कने होआ दा रुख उल्टा होणे दिया बजा ला असां साइप्रस टापू दिया आड़ा च होईकरी चले; ");
INSERT INTO bht_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","कने असां समुंद्री यात्रा करदे होए किलिकिया प्रदेश कने पंफूलिया शेहरे दे तट दे बखे ला होईकरी लूसिया प्रदेशे दे मुरा शेहरे च पुज्जे। ");
INSERT INTO bht_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ओथु सुबेदारे जो सिकंदरिया शेहरे दा इक जाज इतालिया प्रदेशे जो जांदा होया मिल्ला, कने उनी सांझो उस जाजे पर चढ़ाई दिता। ");
INSERT INTO bht_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","असां बड़े रोजा दीकर बले-बले यात्रा किती। साड़ा कनिदुस शेहरे दीकर पुजणा मुशकिल होई गिया था क्योंकि होआ उल्टी दिशा च चलिया थी, इस तांई असां क्रेते टापू दिया आड़ा चे, सलमोने दे इक छोटे दे टापू दे बखे ला होईकरी अग्गे बदे। ");
INSERT INTO bht_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","कने मुशकिला ला उदे किनारे-किनारे चली करी शुभलंगरबारी नाऐ दिया इकी जगा च पुज्जे, जिथू ला लसया शेहर नेड़े था। ");
INSERT INTO bht_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","जालू मते रोज बिती गे थे, कने समुंद्री यात्रा हुण बड़ी खतरनाख होई गियो थी क्योंकि सर्दियां दे मौसमे च होंणे बाला पश्चाताप दी बलि दा त्योहारे होई गिया था, कने ऐ सेई मौसम था ऐसा मौसम शुरू होई गिया था जालू समुन्द्र च मौसम बड़ा तूफानी होई जांदा है, इस तांई पौलुसे उना जो चेताबनी देईकरी बोलया, ");
INSERT INTO bht_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“हे सज्जनो, मिंजो ऐसा लग्गा दा है कि साड़ी ऐ यात्रा बड़ी नुकसानदायक है। ना सिर्फ जाजे कने समाने दा पर साड़े प्राणा दा भी नुकसान होणेबाला है।” ");
INSERT INTO bht_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","पर सूबेदारां जाजे दे कपताने कने जाजे दे मालिके दियां गल्लां जो पौलुसे दियां गल्लां ला बदीकरी मनया। ");
INSERT INTO bht_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","कने ऐ शुभलंगरबारी बन्दरगाह सर्दियां कटणे तांई खरी नी थी; इस तांई मतयां दा बिचार होया कि ओथु ला अग्गे चली करी कुसी तरिके ला होई सके तां फिनिक्स बन्दरगाह च पुज्जी करी सर्दियां कटन। ऐ तां क्रेते टापू दी इक बन्दरगाह है जिसा दा दरबाजा दक्षिण-पश्चिम कने उत्तर-पश्चिम दिशा च है। ");
INSERT INTO bht_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","जालू थोड़ी-थोड़ी दक्षिण होआ चलणा लग्गी, तां उना सोचया की उना दी योजना पूरी करणे तांई ठीक बकत है, इस तांई उना लंगर चुकया कने क्रेते टापू दे किनारे ला होंदे होऐ अग्गे बदणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","पर अचानक क्रेते टापू दिया जमिना ला इक बडा तूफान उठया, जिसयो उतरपुर्वी तूफान बोलदे न। ");
INSERT INTO bht_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जालू तूफान जाजे ला टकराया, तां जाज तुफाने अग्गे नी टिकी सकया, इस तांई असां उसयो होआ दे साबे जाणा दिता, कने इयां ही होआ सोगी चलदे गे। ");
INSERT INTO bht_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","तालू असां कौदा नाऐ दे इक टापूऐ दिया आड़ा च अग्गे बदे कने बड़िया मुशकिला ला जाजे दी जीवनरक्षक किस्तिया जो बचाया। ");
INSERT INTO bht_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","फिरी जाजे च कम्म करणे बालयां जीवनरक्षक किस्तिया जो चुकी करी ठीक किता, कने उना मजबूती तांई पतवार जो चारो पासे ला रस्सियां ला बन्नी दिता, कने सुरतिस दिया खाड़िया दिया रेता च फसी जाणे दे डरे ला, उना लंगरे जो थोड़ा थले उतारी करी जाजे जो होआ दे बहाबे सोगी-सोगी रुड़ने तांई छडी दिता। ");
INSERT INTO bht_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","कने जालू दुज्जे रोजे सांझो तुफाने दिया बजा ला धक्के लगे लगणा, तां सै जाजे ला माल फेंकणा लग्गे; ");
INSERT INTO bht_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","कने तरिऐ रोजे उना अपणे हथा ला जाजे दा साजो समान भी फेंकी दिता। ");
INSERT INTO bht_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","कने जालू मतयां रोजां दीकर ना सूरज ना तारे मिल्ले, कने तूफान लगातार चलया था, तां आखरी च साड़े बचणे दी सारी आस खत्म होंदी गेई। ");
INSERT INTO bht_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","जालू उना मते रोजां दीकर कुछ नी खादा, तां पौलुसे उना दे बिच खड़ोई करी बोलया, “हे लोको, तुहांजो मेरी सलाह मनणी चाईदी थी, क्रेते टापू ला अग्गे नी जांदे, तां ना ऐ मुसीबत ओंदी कने ना ऐ घाटा होंदा। ");
INSERT INTO bht_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","पर मैं हुण तुसां जो समझांदा है कि हिम्मत रखा, क्योंकि तुसां चे कुसी दे भी प्राण नी जाणे, पर सिर्फ जाजे दा नाश होणा। ");
INSERT INTO bht_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","क्योंकि परमेश्वर जिदा मैं है, कने जिदी सेबा मैं करदा है, उदे स्वर्गदूते पिछली राती मेरे बाल आई करी बोलया, ");
INSERT INTO bht_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","हे पौलुस, डर मत। तिजो महाराजा कैसरे दे सामणे खड़ा होणा जरूरी है। कने परमेश्वरे सबना जो बचाई लेंणा है जड़े तेरे सोगी यात्रा करा दे न। ");
INSERT INTO bht_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","इस तांई, हे भाईयो, हिम्मत रखा; क्योंकि मैं परमेश्वरे पर भरोसा करदा है, कि जियां मिंजो ला बोलया है, तियां ही होणा है। ");
INSERT INTO bht_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","पर साड़ा जाज कुसी टापूऐ पर टकराई टूटी जाणा।” ");
INSERT INTO bht_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","जालू चौदमी रात होई, कने असां अद्रिया समुद्रे च भटका दे थे, तां अधिया राती जाजे च कम्म करणे बालयां अणदाजा लाया कि असां कुसी देशे दे बखे पुजणे बाले न। ");
INSERT INTO bht_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","उना समुंद्रे दी गेहराई नापी तां सेंती मीटर निकली कने थोड़ा अग्गे जाई करी फिरी नापया तां सताईस मीटर निकलया। ");
INSERT INTO bht_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","तालू पथरीली जगा ला टकराणे दे डरे ला उना जाजे दे पिच्छे चार लंगर पाऐ, कने ब्याग होणे दी कामना करदे रे। ");
INSERT INTO bht_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","पर जाजे पर कम्म करणे बाले जाजे ला नठणा चांदे थे, कने उना जाजे दे सामणे लंगर पांणे दे बहाने जान बचाणे बाली किस्ती समुद्रे च उतारी दिती; ");
INSERT INTO bht_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","तां पौलुसे सिपाईयां कने सुबेदारां जो बोलया, “अगर ऐ जाजे पर नी रे, तां तुसां भी नी बची सकदे।” ");
INSERT INTO bht_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","तालू सिपाईयां रसियाँ बडी करी सै किस्ती फेंकी दिती। ");
INSERT INTO bht_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","जालू ब्याग होणे बाली थी, तां पौलुसे ऐ बोली करी, सबना जो रोटी खांणे तांई बिनती किती, “अज चौदा रोज होए कि तुसां चिंता करिरी भूखे रे, कने कुछ नी खादा। ");
INSERT INTO bht_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","इस तांई तुहांजो ला बिनती करदा है कि कुछ खाई लिया, जिसला तुसां बची सकन, क्योंकि तुसां चे कूसदा भी कोई बाल बांका नी होणा।” ");
INSERT INTO bht_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","कने ऐ बोली करी उनी रोटी लेईकरी सबना दे सामणे परमेश्वरे दा धन्याबाद किता कने तोड़ी करी खांणा लग्गा। ");
INSERT INTO bht_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","तालू उना सारयां जो हिम्मत मिल्ली कने रोटी खांणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","असां सारे मिली करी जाजे पर दो सो छिहतर जणे थे। ");
INSERT INTO bht_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","जालू सै रोटी खाई करी रजी गे, तां कणका जो समुद्रे च फेंकी करी जाजे जो हलका करणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","जालू दिन निकलया, तां उना उसी देशे जो नी पछेणया, पर इक खाड़ी दिखी जिसा दा चौरस किनारा था, कने बिचार किता कि होई सके तां जाजे जो ओथु लेईकरी चलन। ");
INSERT INTO bht_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","तालू उना लंगरा जो खोली करी समुद्रे च छडी दिता कने उसी बेले पाल दे रस्से खोली दिते, कने होआ दे सामणे अगला पाल चढ़ाई करी किनारे पासे चले। ");
INSERT INTO bht_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","पर जाज रेते दे डेरे ला टकराई गिया कने जाजे दा अगला हिस्सा रेते च फसी गिया, पर जाजे दा पिछला हिस्सा लेहरां दे जोरे ला टूटणा लगी पिया। ");
INSERT INTO bht_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","तालू सपाइयां दा ऐ बिचार होया कि केदियां जो मारी देंन, ऐसा ना होए कि कोई तेरी करी नठी जा। ");
INSERT INTO bht_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","पर सूबेदारां पौलुसे जो बचाणे तांई उना जो इस बिचार ला रोकया, कने ऐ बोलया, कि जड़े तेरी सकदे न, सै पेहले छाल देईकरी किनारे जो निकली जा। ");
INSERT INTO bht_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","कने बाकी कोई पटरां पर, कने कोई जाजे दियां होर चीजा दे सहारे निकली जा, कने इसा रीतिया ने सारे जमिना पर बची निकले। ");
INSERT INTO bht_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","जालू असां सारे सलामत बची करी किनारे पर पूजी गे, तालू सान्झो पता लग्गा कि इस टापूऐ दा ना माल्टा था। ");
INSERT INTO bht_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","कने ओथु रेणेबाले लोक बड़े दयालु थे, क्योंकि उना बरखा कने ठंड दिया बजा ला अग्ग वाली करी साड़ा स्वागत किता। ");
INSERT INTO bht_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","जालू पौलुसे लकड़ियां बटोली करी अग्गी पर रखियां, अग्गी दे सेके ला इक सप्प निकलया कने उदे हथे ने लिपटी गिया। ");
INSERT INTO bht_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","जालू ओथु दे रेणे बालयां उस कीड़े जो उदे हथे च लटकया दिखया, तां अपु चे बोलया, “सच्ची ऐ माणु हत्यारा है, कि समुद्रे च तां बची गिया, पर साड़ी न्याये दी देवी नी चांदी की ऐ जिन्दा रे।” ");
INSERT INTO bht_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","तालू उनी कीड़े जो अग्गी पर झटकी दिता, कने उसयो कोई नुक्सान नी होया। ");
INSERT INTO bht_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","पर सै लोक नियाला दे कि उनी सूजी जाणा है, या इकदम थले पेई कि मरी जाणा है, पर जालू सै मतिया देरा दीकर दिखदे रे कने दिखया कि उसयो कुछ नी होया है, तां उना लोकां दे बिचार ही बदलुई गे कने बोलणा लग्गे, “ऐ तां कोई देवता है।” ");
INSERT INTO bht_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","उसा जगा दे अखे बखे उस टापूऐ दे प्रधान पुबलियुसे दी जमीन थी: उनी सांझो अपणे घरे लेईजाई करी तिन रोज साड़ी खातिरदारी किती। ");
INSERT INTO bht_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","पुबलियुसे दे पिता जो बुखार कने पेचिश बिमारी थी। पौलुसे उदे बखे जाई करी प्राथना किती, कने उदे पर हथ रखीकरी उसयो ठीक किता। ");
INSERT INTO bht_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","जालू इयां होया, तां उस टापूऐ दे बाकी बिमार लोक भी पौलुसे बाल आये, कने ठीक होई गे। ");
INSERT INTO bht_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","उना साड़ी बड़ी इज्जत किती, कने तिन मिहने बाद जालू असां जाणा लग्गे, तां जड़ा कुछ साड़े तांई जरूरी था, उना जाजे पर रखी दिता। ");
INSERT INTO bht_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","असां तीन मिहने बाद सिकंदरिया जाजे पर यात्रा शुरू किती। ऐ जाज सर्दियां दिया बजा ला इस टापूऐ पर रुकया था, कने जाजे दे अगले हिस्से पर इक जोड़ी देवतयां दा इक निशाण दियुसकुरी बणया था। ");
INSERT INTO bht_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","सुरकुसा शेहरे च लंगर पाई करी असां तिन्न दिन दीकर रुकी रे। ");
INSERT INTO bht_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","असां ओथु ला अग्गे चली करी रेगियुम शेहरे च पुज्जे; इक दिन बाद दक्षिण होआ चली, तां असां दुज्जे रोजे पुतियुली शेहरे च पुज्जे। ");
INSERT INTO bht_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ओथु सांझो कुछ मसीह भाई मिल्ले, उना दे बोलणे ला असां ओथु सत्त रोज रे; ओथु ला असां जमिनी रस्ते ला रोम शेहरे पासे चले। ");
INSERT INTO bht_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","रोम शेहरे दे कुछ मसीही भाईयां सुणया की असां ओथु ओआ दे न, सै सांझो ला मिलणा कने सांझो रोम शेहर लेई जाणे तांई अप्पियुस शेहरे दे बजार कने तीन-सराए शेहरे दीकर आऐ, उना जो दिखीकरी पौलुसे परमेश्वरे दा धन्याबाद किता कने बड़ा खुश होया। ");
INSERT INTO bht_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","जालू असां रोम शेहरे च पुज्जे, तां पौलुसे जो इक सपाईऐ सोगी जड़ा उदी रखबाली करदा था, किले रेणे दा हुकम मिल्ली गिया। ");
INSERT INTO bht_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","तिन्ना रोजां बाद उनी यहूदी अगुवां दी इक सभा सदी, कने जालू सै गिठे होए तां उना जो बोलया, “हे यहूदी भाईयो, मैं अपणे लोकां दे या अपणे पूर्वजां दे रीती रिबाजां दे खिलाफ च कुछ नी किता, फिरी भी मिंजो केदी बणाई करी यरूशलेम शेहरे ला रोमी सरकार दे हथे देई दिता। ");
INSERT INTO bht_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","उना मिंजो जाँची करी छडी देणा चाया, क्योंकि मिंजो च मौत दी सजा देंणे जोगा कोई दोष नी था। ");
INSERT INTO bht_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","पर जालू यहूदी अगुवे इदे खिलाफ च बोलणा लग्गे, तां मिंजो बिनती करणा पेई की महाराजा कैसर मेरा न्याय करे; इस तांई नी कि मिंजो अपणे लोकां पर कोई दोष लांणा था। ");
INSERT INTO bht_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","इस तांई मैं तुहांजो सदया है, ताकि तुसां ला मिल्ले कने गलबात करे; क्योंकि इस्राएले दिया आसा तांई जड़ी की मसीह है, मैं इना जंजीरा ला जकड़या होया है।” ");
INSERT INTO bht_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","उना उसयो बोलया, “ना सांझो कोई तेरे बारे च यहूदिया प्रदेशे दे लोकां ला कोई चिठ्ठी मिली, कने ना साड़े भाईयां चे कुनी भी आई करी तेरे बारे च दसया, कने ना बुरा बोलया। ");
INSERT INTO bht_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","पर तेरा बचार क्या है? सेई असां सुणना चांदे न, क्योंकि असां जांणदे न, हर जगा इस मते दे बारे च लोक बिरोध करदे न।” ");
INSERT INTO bht_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","तालू यहूदी लोकां जड़े पौलुसे सोगी थे, उना उदे तांई इक दिन तय किता, कने मते भरी लोक उना बाल गिठे होऐ। कने पौलुस ब्यागा ला लेईकरी संझा दीकर मूसा दी व्यवस्था ला कने परमेश्वरे दा संदेश देणेबालयां दियां कताबां ला परमेश्वरे दे राज्य दी गबाई, कने यीशुऐ दे बारे च समझाई-समझाई करी दसदा रिया। ");
INSERT INTO bht_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","तालू थोड़े लोकां पौलुसे दियां गल्लां पर भरोसा किता, कने केईयां भरोसा नी किता। ");
INSERT INTO bht_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","जालू सै अपु चे सेमत नी होए, तां पौलुसे दिया इसा इकी गल्ला पर चली गे, “पबित्र आत्मा यशायाह परमेश्वरे दा संदेश देणेबाले दे जरिये तुहाड़े पूर्वजां ला ठीक बोलया है, ");
INSERT INTO bht_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","जाई करी इना लोकां ने बोल: कि सुणदे तां रेंणा, पर समझणा नी है, दिखदे तां रेंणा है, पर जाणना नी है; ");
INSERT INTO bht_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","क्योंकि इना लोकां दा मन मोटा। कने उना दे कन भारी होई गियो न, कने उना अपणियां हखी बंद कितियां न, इयां ना हो कि सै हखी ला दिखन, कने कना ला सुणन, कने मने ला समझन कने बदली जान, कने मैं उना जो ठीक करे। ");
INSERT INTO bht_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","इस तांई तुसां जाणा, कि परमेश्वरे दे इस उद्धारे दी कथा होर जातियां बाल भेजइयो है, कने उना मनणी।” ");
INSERT INTO bht_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","जालू उनी ऐ बोलया तां यहूदी अपु चे बेहस करणा लग्गे कने ओथु ला चली गे। ");
INSERT INTO bht_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","कने सै पुरे दो साल अपणे खर्चे पर किराऐ दे घरे च रिया, उना सबना दा स्वागत करदा था जड़े उसला मिलणा ओंदे थे, ");
INSERT INTO bht_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","कने बिना रोक टोक कने बिना डरयो होईकरी परमेश्वरे दे राज्य दा प्रचार करदा कने प्रभु यीशु मसीह दियां गल्लां सिखांदा रिया।");
INSERT INTO bht_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ऐ चिठ्ठी पौलुस दिया तरफा ला है, जड़ा प्रभु यीशु मसीह दा सेवक है, कने परमेश्वरे उसयो प्रेरित होणे तांई चुणया है, कने परमेश्वरे दा शुभसमाचार दा प्रचार करणे तांई नियुक्त कितया है। ");
INSERT INTO bht_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","पबित्र शास्त्र च परमेश्वरे अपणे संदेश देणेबालयां दे जरिये बड़े पेहले ही शुभसमाचार दा वायदा कितया था, ");
INSERT INTO bht_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ऐ शुभसमाचार उदे अपणे पुत्र, साड़े प्रभु यीशु मसीह दे बारे च है, उदा जन्म इक इन्सान दे रुपे च राजा दाऊदे दे बन्शे च होया था, ");
INSERT INTO bht_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","कने पबित्र आत्मा दिया शक्तिया ला जालू सै मरयां चे जिन्दा होया तालू उनी साबित किता की सै परमेश्वरे दा पुत्र है। कने सै यीशु मसीह साड़ा प्रभु है। ");
INSERT INTO bht_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","मसीह दे जरिये मिंजो अनुग्रह कने प्रेरिताई परमेश्वरे ला मिली ताकि उदे नाऐ दिया बजा ने सारियां जातियां दे लोक मसीह पर भरोसा करन कने उदे हुकमा जो मनन, ");
INSERT INTO bht_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","तुसां विश्वासी जड़े रोम शेहर च रेंदे न इना ही लोकां च शामिल न जिना जो परमेश्वरे यीशु मसीह दे होणे तांई चुणया है। ");
INSERT INTO bht_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ऐ चिठ्ठी रोम शेहर च रेणेबाले उना सारयां दे ना है जिना ने परमेश्वर प्यार करदा है, कने अपणे पबित्र लोक होणे तांई सदया है, साड़े पिता परमेश्वरे कने प्रभु यीशु मसीह दिया तरफा ला तुसां जो अनुग्रह कने शांति मिलदी रे। ");
INSERT INTO bht_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","पेहले मैं तुसां सारयां तांई यीशु मसीह दे जरिये अपणे परमेश्वरे दा धन्यबाद करदा है, क्योंकि मती सारियां जगां दे लोक तुसां दे यीशु मसीह पर भरोसे दे बारे च गल्लां करा दे न। ");
INSERT INTO bht_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","परमेश्वर जिसदी सेबा मैं अपणे पुरे मने ने उदे पुत्रे दे बारे च शुभसमाचार दा प्रचार करदा है, सेई मेरा गबाह है, की मैं अपणी प्राथना च तुसां लोकां जो लगातार याद करदा है, ");
INSERT INTO bht_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","कने हर रोज बिनती करदा है, की परमेश्वरे दी इच्छा ने कुसी ना कुसी तरीके ने आखरी च तुसां ने मिलणे दा मौका मिल्ले। ");
INSERT INTO bht_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","क्योंकि मैं तुसां ने मिलने दी बड़ी इच्छा है, ताकि मैं तुसां जो कोई आत्मिक बरदान दें जिसने तुसां भरोसे च होर भी मजबूत होई जान, ");
INSERT INTO bht_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","मेरे बोलने दा मतलब ऐ की मैं तुसां जो उत्साहित करी सकें क्योंकि तुसां जाणदे न की मैं कियां भरोसा किता कने तुसां मिंजो उत्साहित करी सकन क्योंकि मैं जाणदा है की तुसां कियां भरोसा किता। ");
INSERT INTO bht_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","कने हे मसीह भाईयो, मैं चांदा है की तुसां जाणी लिया की मैं तुसां बाल बार-बार ओणा चांदा, की जियां मैं होर जातियां च मसीह तांई चेले बणाऐ, तियां ही तुसां च भी चेले बणन, पर हले दीकर इदे च रुकाबट ओंदी रेई। ");
INSERT INTO bht_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","मेरी जिम्मेबारी सारयां लोकां जो शुभसमाचार सुणाणे दी है, चाऐ सै यूनानी भाषा जाणने बाले होन या नी जाणने बाले होन कने चाहे समझदार होन या नासमझ होन। इस तांई मेरी रोम शेहरे च तुसां ने मिलणे दी बड़ी इच्छा है। ");
INSERT INTO bht_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","इस तांई मैं तुसां जो भी जड़े रोम शेहरे च रेंदे न, शुभसमाचार सुणाणे जो भरपूर तैयार है। ");
INSERT INTO bht_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","क्योंकि मैं मसीह दे शुभसमाचार च घमंड करदा है, क्योंकि शुभसमाचार दी शक्ति ने ही परमेश्वरे शुरु ला यहूदियां जो बचाया कने हुण सारे संसारे दे लोकां जो बचांदा है। ");
INSERT INTO bht_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","क्योंकि शुभसमाचार च परमेश्वर दी धार्मिकता दे बारे च दसया है, ऐ धार्मिकता शुरु ला लेईकरी आखरी दीकर भरोसे दे जरिये होंदी है, जियां पबित्र शास्त्र च लिखया है, “जड़ा माणु भरोसे दे जरिये परमेश्वरे सोगी सही बणी रेंदा है, उनी ही जिन्दा रेणा।” ");
INSERT INTO bht_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","परमेश्वरे दा गुस्सा तां, जड़े बुराई कने अधार्मिक कम्म करदे न उना लोकां पर स्वर्गे ला प्रकट होंदा है, जड़े बुरे कम्म करणे दे जरिये लोकां जो परमेश्वरे दिया सच्चाईयां जो जाणने ला रोकदे न। ");
INSERT INTO bht_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","इस तांई की सै परमेश्वरे दे ज्ञाने दे बारे च असानी ने समझी सकदे न, क्योंकि परमेश्वरे ऐ ज्ञान उना पर प्रगट कितया है। ");
INSERT INTO bht_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","क्योंकि परमेश्वरे दी हमेशा दी शक्ति कने चरित्र जो दिखी नी सकदे, पर संसार दी शुरुआत ला ही परमेश्वरे इना जो अपणी सृष्टिया ने दसया है, इस तांई उना बाल कोई भाना नी है की सै परमेश्वर जो नी जाणदे। ");
INSERT INTO bht_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","इसा बजा ने की परमेश्वरे जो जाणने पर भी उना परमेश्वरे दे रुपे च इज्जत नी दिती, कने सोचणा लग्गे की ऐ बेकार गल्लां न, ऐथू दीकर की उना जो जियां सोचणा चाईदा तियां नी सोचया पर बेकार गल्लां सोचदे रे। ");
INSERT INTO bht_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","सै अपणे आपे जो बुद्धिमान जताई करी मुर्ख बणी गे, ");
INSERT INTO bht_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","कने हमेशा जिन्दा रेणेबाले परमेश्वरे दिया महिमा जो हमेशा जिन्दा नी रेणेबाले, कने पंछियां, कने चारां पैरां बाले, कने रेंगणेबाले जानवरां दियां मुर्तियां सांई बदली दिता कने इना दी पूजा करणा लग्गे। ");
INSERT INTO bht_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","इसा बजा ला परमेश्वरे उना जो उना दे मने दिया इच्छा अनुसार यौन अशुद्धता तांई छडी दिता, ताकि सै अपु चे बुरे कम्म करी के अपणे शरीरां दी अनादर करन। ");
INSERT INTO bht_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","क्योंकि सै परमेश्वरे दे बारे दिया सच्चाईया पर भरोसा करणे जो मना करदे न, कने सै उसयो मंदे जड़ा जुठ है। कने उना संसारे दी पूजा कने सेबा किती, कने ना की उस सृष्‍टिकर्ता दी सेबा किती। उस सृष्‍टिकर्ता दी जिनी सारे संसारे दियां चिजां जो बणाया है, उदी महिमा सदा होंदी रे। आमीन। ");
INSERT INTO bht_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","इस तांई तां परमेश्वरे उना जो उना दे बुरे बिचारां दे बशे च छडी दिता; ऐथू दीकर उना दियां जनानिया मर्दां सोगी जायज रिशतयां जो दुजियां जनानियां सोगी नाजायज रिशतयां च बदली दिता। ");
INSERT INTO bht_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","तियां ही मर्द भी जनानिया सोगी जायज रिशता छडी करी अपु चे व्यभिचार करिरी बरबाद होणे लग्गे, कने मर्दां-मर्दां सोगी व्यभिचार करिके अपणे ही शरीरे च अपणिया इसा गलतिया दी ठीक सजा मिल्ली। ");
INSERT INTO bht_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","क्योंकि जालू उना परमेश्वरे जो अपनाणा मुर्खता समझया, तां परमेश्वरे भी उना जो सारे नकम्मे कम्म करणे तांई उना दे नकम्मे मने दे बशे च छडी दिता। ");
INSERT INTO bht_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","इस तांई सै हर तरा दे गलत कम्मा च, बुराई च, कने लालच, कने बैरभाव ने भरुई गे; कने जलन, कने हत्या, कने लड़ाई झगड़े, कने धोखा, कने जलन ने भरुई गे, कने चुगलखोर, ");
INSERT INTO bht_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","गप्पां मारणे बाले, कने होरनी दी बेस्ती करणे बाले, लड़ाके, घमंडी, झूठे, डिंगमार, बुरियाँ गल्लां करणे बाले, कने माता पिता दी गल्ल नी मनणे बाले, ");
INSERT INTO bht_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","बेअकले, धोखेबाज, दया भाव नी है कने निर्दयी होई गियो न। ");
INSERT INTO bht_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","सै तां परमेश्वरे दे नियम जो जाणदे न की ऐसा कम्म करणे बाले मौत दी सजा जोगे न, तमि ना सिर्फ अपु ऐसे कम्म करदे न कने करणे बालयां ने खुश भी होंदे न। ");
INSERT INTO bht_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","इस तांई तू सोचदा है की, तू ऐसे लोकां दी निंदा करी सकदा है, जड़े दुज्जयां पर दोष लांदे न; क्योंकि जिसा गल्ला पर तू दुज्जे पर दोष लांदा है, उसा ही गल्ला च तू अपणे आपे जो दोषी बणांदा है, क्योंकि तू जड़ा दोष लांदा है सेई कम्म तू अपु करदा है। ");
INSERT INTO bht_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","कने असां जाणदे न की परमेश्वर ऐसे बुरे कम्म करणे बालयां जो न्याय अनुसार सजा दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","कने तू जड़ा ऐसे-ऐसे कम्म करणे बालयां पर दोष लांदा है, कने अपु सेई कम्म करदा है; तू क्या ऐ समझदा है की तू परमेश्वरे दिया सजा ला बची जाणा है? ");
INSERT INTO bht_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","तू क्या परमेश्वर दी भलाई, कने सेहनशीलता, कने धीरज रूपी धने जो बेकार समझदा है? क्या ऐ नी समझदा की परमेश्वरे दी भलाई तिजो अपणे पापां जो मनणा कने गलत कम्मा जो छडणा सिखांदी है? ");
INSERT INTO bht_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","पर क्योंकि तू जिदी कने अपणे पापां दा पश्चाताप करणे ला मना करी दिता, जिस रोज परमेश्वरे अपणा गुस्सा दसणा, उस रोज सच्चा न्याय होणा, जालू परमेश्वरे न्याय करणा तालू परमेश्वरे होर भी जादा दर्दनाक सजा देणी। ");
INSERT INTO bht_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","परमेश्वरे हर इकी जो उदे कम्मा दे अनुसार इनाम देणा है। ");
INSERT INTO bht_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","जड़े खरे कम्मा जो मेहनत करदे होऐ महिमा, कने आदर, कने अमरता दीया तोपा च न, उना जो परमेश्वरे हमेशा दी जिन्दगी देणी है; ");
INSERT INTO bht_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","पर जड़े मतलबी न कने सच्च जो नी मंदे न, पर बुरे कम्मा जो करदे न, उना पर परमेश्वरे दा गुस्सा कने प्रकोप पोणा है। ");
INSERT INTO bht_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","दुख कने मुशकिलां हर इक उस माणुऐ पर ओणियां न जड़े बुरा करदे न, परमेश्वरे पेहले यहूदियां दा न्याय करणा है कने बादे च उना दा न्याय करणा जड़े यहूदी नी न; ");
INSERT INTO bht_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","पर महिमा कने इज्जत कने शांती हर इकी जो मिलणी है, जड़ा भला करदा है, परमेश्वरे सारयां ला पेहले यहूदी लोकां जो देणा फिरी उना लोकां जो देणा जड़े यहूदी नी न। ");
INSERT INTO bht_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","क्योंकि परमेश्वर सबना सोगी इकोदिया व्यवहार करदा है। ");
INSERT INTO bht_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","इस तांई की होर जाति दे लोकां बिना मूसा दी व्यवस्था मिलयो ही पाप किता, उना जो बिना व्यवस्था दे ही परमेश्वरे सजा देणी, कने जिना यहूदी लोकां मूसा दी व्यवस्था मिलणे बाद पाप किता, उना जो परमेश्वरे मूसा दी व्यवस्था दे अनुसार सजा देणी; ");
INSERT INTO bht_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","क्योंकि परमेश्वरे दी नजरा च धर्मी लोक सै नी न, जड़े मूसा दी व्यवस्था जो सुणनेबाले न, पर परमेश्वरे दी नजरा च धर्मी लोक सै न जड़े व्यवस्था दा पालन करदे न। ");
INSERT INTO bht_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","फिरी जालू होर जातियां दे लोक जिना बाल मूसा दी व्यवस्था नी है, पर स्वभाबे ने ही इना कम्मा जो करदे न जड़े मूसा दी व्यवस्था च लिखयो न, तां उना बाल मूसा दी व्यवस्था नी होंणे पर भी से साबित करदे न की उना दे मने च ही व्यवस्था है। ");
INSERT INTO bht_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","सै दसदे न की परमेश्वरे दी व्यवस्था उना दे मना च लिखियो है, क्योंकि उना दी अंतरात्मा भी ऐई गबाई दिन्दी है की ऐ सच्च है, क्योंकि उना दे बिचार ही उना जो दसदे न की सै सही करा दे न की गलत करा दे न। ");
INSERT INTO bht_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ऐ सच्च उस रोज सामणे आई जाणा, जालू परमेश्वरे यीशु मसीह दे जरिये जिसदा मैं शुभसमाचार सुणादा है सारे माणुआं दी गुप्त गल्लां दा न्याय करणा है। ");
INSERT INTO bht_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","अगर तू अपणे आप जो यहूदी बोलदा है, कने व्यवस्था पर भरोसा रखदा है, कने घमंड करदा है की तू परमेश्वर दा खास जन है, ");
INSERT INTO bht_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","कने तिजो परमेश्वर दी इच्छा पता है, तू खरियाँ-खरियाँ गल्लां दा साथ दिन्दा है, क्योंकि तिजो इना दे बारे च मूसा दी व्यवस्था च सिखाया है; ");
INSERT INTO bht_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","कने तिजो इसा गल्ला दा पक्का पता है की, तू अन्ने लोकां जो परमेश्वर दा रस्ता दसदा है, कने तू उना लोकां तांई लौई सांई है जड़े नेहरे च रेंदे न, ");
INSERT INTO bht_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","कने बेअकलां जो सिखाणे बाला, कने बचयां दा गुरू है। तिजो पक्का पता है क्योंकि मूसा दी व्यवस्था तेरे बाल है, कने तू पूरी तरा सब कुछ जाणदा है कने तू जड़ा बोलदा है सै सच्च है। ");
INSERT INTO bht_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","इस तांई तू जड़ा बाकियां जो शिक्षा दिन्दा है, सै शिक्षा अपणे आपे जो कनी दिन्दा? तू जड़ा चोरी नी करणे दी शिक्षा दिन्दा है, कने अपु ही चोरी करदा है। ");
INSERT INTO bht_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","तू जड़ा ऐ सिखांदा है, “व्यभिचार मत करा,” अपु ही तां व्यभिचार करदा है! तू जड़ा मूर्तियाँ ने नफरत करदा है, अपु ही तां मंदरा जो लुटदा है! ");
INSERT INTO bht_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","तू इसा गल्ला पर घमंड करदा है की तेरे बाल परमेश्वरे दी व्यवस्था है, क्या तू अपु ही व्यवस्था जो नी मन्नी करी, परमेश्वरे दा अनादर नी करदा? ");
INSERT INTO bht_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“क्योंकि तुसां यहूदियां दिया बजा ने, होर जाति दे लोक परमेश्वरे दे बारे च बुरियां गल्लां करदे न,” तुहाड़े इना कम्मा दिया बजा ने पबित्र शास्त्र दियां गल्लां सच्च होइयां न। ");
INSERT INTO bht_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","मैं तिजो समझादां है, की तेरा खतना होणे दा फायदा तालू ही है अगर तू व्यवस्था जो पूरा करे, पर अगर व्यवस्था च जियां लिखया तू तियां नी करे, तां तुसां खतना होयो यहूदी लोक भी होर जातियां सांई न जिना दा खतना नी होया। ");
INSERT INTO bht_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","तां इदा मतलब है की अगर कोई माणु जिदा खतना नी होया कने सै व्यवस्था दे नियमा जो मनदा है, तां परमेश्वर ऐसे माणुऐ जो भी उस माणुऐ सांई दिखदा है जिदा खतना होया है। ");
INSERT INTO bht_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","कने जड़ा माणु शरीरिक रुपे च बिना खतना रिया सै अगर व्यवस्था जो मनदा है, तां क्या उनी तिजो पर जिस बाल मूसा दी व्यवस्था है कने खतना होणे पर भी व्यवस्था जो नी मनदा है, दोष नी लाणा? ");
INSERT INTO bht_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","क्योंकि सच्चा यहूदी सै नी जड़ा यहूदी पैदा होया कने जिदा खतना होया। ");
INSERT INTO bht_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","क्योंकि इक सच्चा यहूदी सै है जिदा मन परमेश्वरे सोगी सही है कने सच्चा खतना सिर्फ मूसा दे नियम-कानून मनणे नी है, पर मने दा बदलना है जड़ा की परमेश्वरे दी आत्मा ने होंदा है। ऐसे लोकां दी महिमा लोकां दे जरिये नी पर परमेश्वरे दिया तरफा ला होंदी है। ");
INSERT INTO bht_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","तां कोई बोली सकदा है की अगर खतना होई जाणे पर भी परमेश्वर यहूदियां जो अपनांदा नी तां यहूदी दा यहूदी होणे दा क्या फायदा, कने खतने दा क्या फायदा? ");
INSERT INTO bht_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","हाँ, इदा बड़ा फायदा है। क्योंकि सारयां ला जरूरी गल्ल ऐ है की, परमेश्वरे दा बचन यहूदियों जो दितया है। ");
INSERT INTO bht_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","अगर कुछ यहूदी परमेश्वर सोगी बफादार नी भी निकले तां भी क्या है? क्या इदा मतलब ऐ है की परमेश्वरे भी अपणे वायदे ला मुकरी जाणा जड़ा उनी यहूदी लोकां ने किता? ");
INSERT INTO bht_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","नी बिलकुल भी नी! परमेश्वर हमेशा सच्च बोलदा है, कने हर इक माणु झूठा होऐ, जियां पबित्र शास्त्र च परमेश्वरे दे बारे च लिखया है, “जिसने तू अपणियां गल्लां च धर्मी होऐ कने न्याय करदे बेले तेरी जय होऐ।” ");
INSERT INTO bht_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","पर अगर साड़े बुरे कम्म परमेश्वरे दी धार्मिकता दसदे न, तां असां क्या बोलणा? क्या ऐ गलत है की परमेश्वर गुस्सा होई जाऐ कने सांझो सजा दे? (ऐ तां मैं माणुऐ दिया रीतिया पर बोलदा है।) ");
INSERT INTO bht_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","नी बिलकुल भी नी! अगर परमेश्वर साड़ा यहूदियां दा न्याय करणे च सही नी है, तां सै सारे संसारे दे लोकां दा न्याय कियां करगा? ");
INSERT INTO bht_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","कुछ लोक बोली सकदे न, “पर अगर मेरा झूठ परमेश्वरे दिया सच्चाईया जो उजागर करदा है कने उसयो होर जादा महिमा मिलदी है तां सै कियां मेरा न्याय करी सकदा है कने मिंजो इक पापी दे रुपे च दोषी बणाई सकदा है?” ");
INSERT INTO bht_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","असां बोली सकदे न की “चला असां बुरे कम्म करन, ताकि इदे च कोई भलाई निकले?” जियां की सांझो पर ऐई दोष लगांदे भी न, कने थोड़े बोलदे न की इना दा ऐई बोलणा है। पर जड़े मेरे बारे च इयुदियां गल्लां करदे न सै सजा दे काबिल न। ");
INSERT INTO bht_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","तां फिरी क्या होया? क्या असां यहूदी लोक होर जातियां दे लोकां ला खरे न? नी बिलकुल भी नी! क्योंकि असां यहूदियाँ कने होर जातियां दोनो पर ऐ दोष लाई बैठयो न की सै सारे लोक पाप दिया शक्तिया दे बशे च न। ");
INSERT INTO bht_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","जियां पबित्र शास्त्र च लिखया है: “परमेश्वर दे सामणे कोई भी धर्मी नी है, इक भी नी।” ");
INSERT INTO bht_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ऐथू कोई भी माणु नी है जड़ा समझी सके की क्या सही है; कोई भी परमेश्वरे जो नी जाणना चांदा। ");
INSERT INTO bht_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","सारे परमेश्वरे ला दूर चली गे, कने सारे दे सारे परमेश्वरे तांई निकमे बणी गे; भलाई करणे बाला कोई भी नी, इक भी नी। ");
INSERT INTO bht_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","उना दा गला खुलियो कबरा सांई है जिसा ला बड़ी बदबू ओंदी है: क्योंकि सै अपणी जिबा ने बुरा बोलदे न, कने जड़ा बोलदे न सै सांपे दे जेहरे सांई खतरनाख होंदा है। ");
INSERT INTO bht_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","कने उना दे भाषण श्राप कने कड़वाट ने भरुयो न। ");
INSERT INTO bht_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","सै हत्या करणे तांई फुर्तीले न। ");
INSERT INTO bht_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","जिथू कुथी सै जांदे न सै बुराई कने दुख जो लेई ओंदे न। ");
INSERT INTO bht_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","सै नी जाणदे न की कियां शांति ने जि न। ");
INSERT INTO bht_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","उना च परमेश्वर दा डर है ही नी। ");
INSERT INTO bht_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","असां जांणदे न, की व्यवस्था जड़ा कुछ भी बोलदी है सै उना ने ही बोलदी है, जड़े व्यवस्था दे अधीन न, इस तांई की लोकां जो भाना बणाने ला रोकया जाये, कने सारे संसारे दे लोक परमेश्वर दे सामणे हिसाब देणेबाले होई जान। ");
INSERT INTO bht_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","क्योंकि व्यवस्था च दितयो हुकमा जो मनणे ने कोई भी माणु परमेश्वरे सामणे धर्मी नी बणदा, क्योंकि मूसा दी व्यवस्था सांझो दसदी है की असां पापी न। ");
INSERT INTO bht_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","पर हुण बिना मूसा दी व्यवस्था दे हुकमा जो मनयो परमेश्वर दी धार्मिकता प्रकट होई है, ऐ मूसा की व्यवस्था कने परमेश्वरे दे संदेश देणेबालयां दियां कताबां च लिखया है की असां कियां परमेश्वरे दे जरिये धर्मी बणे, ");
INSERT INTO bht_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","मतलव की परमेश्वरे दे सामणे धर्मी तालू बणदे न जालू असां यीशु मसीह पर भरोसा करदे न। क्योंकि हुण यहूदी कने होर जाति च कोई फरक नी है। ");
INSERT INTO bht_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","इस तांई की सारयां पाप कितया है कने परमेश्वरे दी उस महिमा ला दूर न जड़ी परमेश्वर दिंदा है, ");
INSERT INTO bht_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","पर परमेश्वरे दे अनुग्रह ने उनी सांझो यीशु मसीह दे जरिये पाप दी सजा ला अजाद किता जड़ा यीशु मसीह च है, परमेश्वर सांझो बिना कुछ कितयो धर्मी घोषित करी दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","परमेश्वरे यीशु मसीह जो सूली पर चढ़ना दिता ताकि उदा खून लोकां दे पापां जो माफ करणे दा जरिया बणी सके, जड़े उस पर भरोसा करदे न। परमेश्वरे ऐसा ऐ दसणे तांई किता की सै धर्मी है। पूराणे बकते च परमेश्वरे सबर रखीकरी लोकां दे पापां जो अणदिखा किता, पर हुण सै लोकां दे पापां ने निपटदा है, ताकि सै अपणी धार्मिकता दस्सी सके। इयां परमेश्वर साबित करदा है की सै धर्मी है कने यीशु पर भरोसा करणे बालयां जो भी धर्मी बणादा है। ");
INSERT INTO bht_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","तां हुण ऐसा कुछ है जिस पर असां घमंड करन? नी, ऐसा कुछ नी जिदे बारे च असां घमंड करी सकन। कुण दे नियमा दिया बजा ने? क्या साड़े व्यवस्था दे कम्मा जो पूरा करणे ने? नी, पर यीशु मसीह पर भरोसा करणे दी दिया बजा ने। ");
INSERT INTO bht_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","इस तांई असां जाणदे न की परमेश्वरे सांझो यीशु मसीह पर भरोसा करणे ने धर्मी घोषित करी दितया है, ना कि मूसा दी व्यवस्था जो मनणे ने। ");
INSERT INTO bht_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","परमेश्वर सिर्फ यहूदियां दा ही परमेश्वर नी है, पर होर जातियां दा भी परमेश्वर है। ");
INSERT INTO bht_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","क्योंकि इक ही परमेश्वर है, जिनी खतने बालयां जो भरोसे ने कने जिना दा खतना नी होया उना जो भरोसे दे जरिये धर्मी घोषित किता है। ");
INSERT INTO bht_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","तां क्या असां व्यवस्था जो भरोसे दे जरिये बेकार बणादे न? नी बिलकुल भी नी! पर असां तां व्यवस्था जो उसा दा सही महत्व देदे न। ");
INSERT INTO bht_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","तां असां यहूदी होणे दे नाते अपणे पूर्वज अब्राहमे दे बारे च क्या बोलन? की उसयो कुसा बजा ला धर्मी गिणया? ");
INSERT INTO bht_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","क्योंकि अगर अब्राहम भले कम्मा ने धर्मी बणदा, तां सै घमंड करी सकदा था, पर हुण सै परमेश्वरे सामणे अपणे भले कम्मा पर घमंड नी करी सकदा। ");
INSERT INTO bht_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","पबित्र शास्त्र क्या बोलदा है? ऐ की “अब्राहमे परमेश्वरे दे वायदे पर भरोसा किता, कने इसी ने ही परमेश्वरे अब्राहमे जो धर्मी बणाया।” ");
INSERT INTO bht_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","कम्म करणे बाले दी मजदूरी देणा दान नी है, पर ऐ हक समझया जांदा है। ");
INSERT INTO bht_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","कुण परमेश्वर दा अनुग्रह पांणे तांई कम्म नी करदा है, पर जड़ा पापी लोकां जो धर्मी ठहराणे बाले परमेश्वरे पर भरोसा करदा है, उदा भरोसा उदे तांई धार्मिकता गिणया जांदा है। ");
INSERT INTO bht_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","जियां पबित्र शास्त्र च दाऊद उना आशीषां दे बारे च लिखदा है, जड़ियां उना लोकां जो मिलदियां न जिना जो परमेश्वरे धर्मी बणाई दिता, चाहे उना धर्मी बणने तांई कोई कम्म नी किता, दाऊद भी इना जो धन्य बोलदा है; ");
INSERT INTO bht_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“धन्य सै न, जिना दे अधर्म परमेश्वरे माफ किते, कने जिना दे पाप भुलाई दिते। ");
INSERT INTO bht_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","धन्य न सै माणु परमेश्वर जीना दे पापां दा लेखा जोखा नी रखदा।” ");
INSERT INTO bht_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","तां क्या ऐ धन्य बचन खतने बालयां तांई ही है, या जिना दा खतना नी होया है उना तांई भी है? असां ऐ बोला दे न की पबित्र शास्त्र क्या बोलदा है, अब्राहमे परमेश्वरे दे वायदे पर भरोसा किता, कने इसी ने ही परमेश्वरे अब्राहमे जो धर्मी बणाया। ");
INSERT INTO bht_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","तां सै धर्मी कालू बणया? क्या खतना होणे ला पेहले या खतना होणे बाद? अब्राहम खतना होणे ला बाद नी, पर खतना होणे ला पेहले धर्मी बणया। ");
INSERT INTO bht_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","परमेश्वरे उसयो पेहले ही अपनाई लिया था कने उसयो धर्मी घोषित करी दितया था, जबकि उदा हले भी खतना नी होया था, खतने दा निशाण उस अपनाणे दी मोहर है। इस तांई सै उना लोकां दा पूर्वज है जिना बाल भरोसा है पर उना दा खतना नी होया है। इना जो इना दे भरोसे दिया बजा ने धर्मी गिणया जांदा है। ");
INSERT INTO bht_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","कने अब्राहम उना खतना कितयो लोकां दा पूर्वज होया, जड़े ना सिर्फ खतने पर आस रखदे न, पर उना बाल सियुदा ही भरोसा है, जड़ा साड़े पूर्वज अब्राहमे खतना करणे ला पेहले कितया था। ");
INSERT INTO bht_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","परमेश्वरे अब्राहम कने उदे बंशजा ने बायदा किता की सै पुरे संसार दे वारिस होणे न, परमेश्वरे ऐ बायदा इस तांई नी किता की अब्राहमे मूसा दे हुकमा जो मनया, पर अब्राहमे जो भरोसे दिया बजा ने परमेश्वरे धर्मी बणया। ");
INSERT INTO bht_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","क्योंकि अगर परमेश्वरे दा अब्राहम कने उदे बंशजा जो संसार देणे दा वायदा सिर्फ उना ही लोकां तांई है जड़े मूसा दी व्यवस्था दे हुकमा जो मंदे न, तां भरोसा बेकार है कने परमेश्वरे दे बायदे दा भी कोई मतलब नी रिया। ");
INSERT INTO bht_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","परमेश्वर तां उना लोकां जो सजा दिन्दा जड़े व्यवस्था जो पूरी तरा नी मंदे, पर जिथू व्यवस्था है ही नी, ओथु व्यवस्था दा उलंघन भी नी होंदा। ");
INSERT INTO bht_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","इस तांई लोकां जो परमेश्वरे दा बायदा उना दे भरोसे दे जरिये मिल्ला। ऐ इस तांई होया की परमेश्वरे दा वायदा अनुग्रह दे जरिये मिल्ले, तालू अब्राहम दे सारे बंशा बाल ऐ वायदा हो, ऐ सिर्फ उना तांई ही नी है जड़े मूसा दी व्यवस्था पर चलदे न, पर हर इक उस माणु तांई जड़ा अब्राहमे सांई भरोसे सोगी जिन्दगी जिंदा है, जड़ा असां सारयां दा पूर्वज है। ");
INSERT INTO bht_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","जियां पबित्र शास्त्रां च लिखया है, “मैं तिजो मतियां जातियां दा पूर्वज बणाया है” परमेश्वरे दे सामणे अब्राहम साड़ा पिता है। उना उस परमेश्वरे पर भरोसा किता, जड़ा मरयां जो फिरी जिन्दा करदा है कने जड़ियां चीजां मोजूद भी नी न, उना दा ना इयां लेंदा है, की जियां की सै चीजां मोजूद न। ");
INSERT INTO bht_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","19","परमेश्वरे अब्राहम जो बोलया की सै तिजो मते सारे बंशज दिंगा, पर अब्राहमे सोचया की मैं बड़ा बुड्डा होई गिया है, क्योंकि उस बकत सै लगबग सौ सालां दा होई गिया था कने सारा भी बच्चे पैदा नी करी सकदी थी। तां ऐ पक्का ही था की अब्राहम कदी भी मतियां जातियां दा पिता नी बणी सकदा था, पर फिर भी अब्राहम अपणे भरोसे च कमजोर नी होया कने सै लगातार भरोसा रखदा रिया कने उम्मीदा जो टूटणा नी दिता। ");
INSERT INTO bht_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","कने ना ही अविश्वासी होईकरी परमेश्वरे दे बायदे पर शक किता, पर भरोसे च मजबूत होईकरी परमेश्वरे दी महिमा किती, ");
INSERT INTO bht_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","कने पक्का यकीन किता की जिसा गल्ला दा परमेश्वरे वायदा कितया है, सै इस बायदे जो पूरा करणे दे भी काबिल है। ");
INSERT INTO bht_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","उदे भरोसे दिया बजा ने ही परमेश्वरे अब्राहमे जो धर्मी बणाया, ");
INSERT INTO bht_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","कने इस बचन कने भरोसे दिया बजा ने ही परमेश्वरे अब्राहमे जो धर्मी बणाया, “ना सिर्फ उदे तांई लिखया गिया,” ");
INSERT INTO bht_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","बल्कि साड़े तांई भी जिना जो परमेश्वरे धर्मी घोषित करणा, मतलव की अगर असां परमेश्वरे पर भरोसा करगे, जिनी साड़े प्रभु यीशु मसीह जो मरयां चे जिन्दा किता, तां असां भी भरोसे दिया बजा ने धर्मी मन्ने जाणे। ");
INSERT INTO bht_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","यीशु मसीह साड़े पापां तांई मरी गिया, कने परमेश्वरे उसयो दुबारा जिंदा किता ताकि परमेश्वर सांझो धर्मी बणाऐ। ");
INSERT INTO bht_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","इस तांई असां भरोसे ने धर्मी बणे, क्योंकि जड़ा प्रभु यीशु मसीहे साड़े तांई कितया है, उदे जरिये असां परमेश्वरे सोगी शांति ने रेन, ");
INSERT INTO bht_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","क्योंकि साड़े भरोसे दिया बजा ला यीशु मसीह सांझो इस अनुग्रह च लेईकरी आया जिथू असां हुण न, कने असां पूरी हिम्मत कने खुशिया ने परमेश्वरे दी महिमा च हिस्सेदार होणा। ");
INSERT INTO bht_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","सिर्फ ऐ ही नी, बल्कि सांझो दुखां च भी खुश रेणा चाईदा, क्योंकि असां जाणदे न की दुख सेहणे ने असां होर जादा सहनशील बणदे न, ");
INSERT INTO bht_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","परमेश्वरे सांझो अपनाई लिया क्योंकि असां दुखां च सेहणा सीखी लिया है, कने परमेश्वर सांझो अपनांदा है इस तांई सांझो आस है; ");
INSERT INTO bht_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","कने आस ने सांझो शर्मिंदगी नी होंदी, क्योंकि पबित्र आत्मा जड़ी परमेश्वरे सांझो दितियो है उदे जरिये परमेश्वरे साड़े मना जो प्यार ने भरी दितया है। ");
INSERT INTO bht_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","क्योंकि जालू असां कमजोर थे, तालू मसीह परमेश्वरे दे चुणयो बकत पर बुरे लोकां तांई मरया। ");
INSERT INTO bht_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ऐ कुसी तांई कठिन है की कोई धर्मी माणुऐ तांई अपणी जान देई दे, होई भी सकदा है की भले माणुऐ तांई अपणी जान देणे दी इच्छा रखे। ");
INSERT INTO bht_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","पर परमेश्वर सांझो पर अपणे प्यार दी भलाई इस तरीके ने प्रगट करदा है, की जालू असां पापी ही थे तालू मसीह साड़े तांई मरया। ");
INSERT INTO bht_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","जालू असां हुण धर्मी बणे क्योंकि यीशु मसीह साड़े तांई मरया कने साड़े पापां तांई अपणा खून बहाया, तां सांझो यकीन है की मसीहे सांझो परमेश्वरे दे गुस्से ला बचाणा? ");
INSERT INTO bht_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","क्योंकि जालू असां परमेश्वरे दे दुश्मन ही थे तमी उदे पुत्र यीशु दे मरणे ने साड़ा मेल परमेश्वरे सोगी होया, इस तांई सांझो पक्का पता है की हुण साड़ा मेल शान्ति ने परमेश्वरे सोगी है, मसीहे सांझो बचाणा क्योंकि मसीह जिन्दा है। ");
INSERT INTO bht_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","कने सिर्फ ऐ ही नी, पर हुण तां साड़े प्रभु यीशु मसीह दे जरिये परमेश्वरे ने साड़ा मेल होई गिया है, इस तांई असां परमेश्वर च खुश न। ");
INSERT INTO bht_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","इस तांई जालू इक माणुऐ दिया बजा ने पाप संसार च आया, आदम पेहला माणु है जिसयो परमेश्वरे बणाया कने आदमे पाप किता कने मरी गिया, कने जिसदी बजा ने सै सारे लोक जड़े इस संसार च पैदा होए, सै सारे मरे, क्योंकि सब पापी बणी गे। ");
INSERT INTO bht_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","मूसा दी व्यवस्था दिते जाणे ला पेहले ही लोकां पाप किता, पर इसयो पाप नी गिणया क्योंकि तालू कोई व्यवस्था नी थी कने कोई नियम भी नी टुटया था। ");
INSERT INTO bht_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","तमी आदम ला लेईकरी मूसा दीकर सारयां लोकां पाप किता कने सारे मरी गे, जिना आदम सांई कुसी तरा दे हुकम नी मनणे ने पाप नी कितया था। आदम दे पापे इना सारयां लोकां पर प्रभाब पाया, ठीक तियां ही जियां मसीहे किता जड़ा उदे बाद आया। ");
INSERT INTO bht_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","पर आदम दा पाप उस बरदान सांई नी है जड़ा परमेश्वर सांझो अपणे अनुग्रह ला दिन्दा है, क्योंकि इक माणुऐ दा पाप मते लोकां तांई मौत लेईकरी आया। पर परमेश्वरे दा अनुग्रह बड़ा महान है, जड़ा उनी सांझो दितया है, उदी कीमत मतयां लोकां तांई उसला बड़ी जादा है। यीशु मसीहे इक माणुऐ दे रुपे च अपणे अनुग्रह ला जड़ा किता, उनी इसयो संभव किता। ");
INSERT INTO bht_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","जड़ा तोफा परमेश्वर सांझो दिन्दा है सै आदम दे पाप सांई नी है, क्योंकि इक पाप सजा लेईकरी आया, पर चाहे असां मते सारे पाप किते न, परमेश्वरे सांझो सै तोफा दिता जिसने असां धर्मी बणदे न। ");
INSERT INTO bht_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","क्योंकि जालू इक माणुऐ दे पापां दिया बजा ने मौत सारे लोकां पर आई गेई, तां जिना लोकां जो अनुग्रह कने धार्मिकता दा वरदान मता सारा मिलदा है उना जो इक माणुऐ दे, मतलब की यीशु मसीह दे जरिये हमेशा दी जिन्दगी मिलणी कने उना राज्य भी करणा। ");
INSERT INTO bht_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","इस तांई जियां इक पाप सारे माणुआं तांई सजा लेईकरी आया, तियां ही इक धार्मिकता दा कम्म भी सारयां लोकां तांई धर्मी बणने दी बजा बणी जड़ा जिन्दगी दिन्दा है। ");
INSERT INTO bht_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","क्योंकि जियां इक माणुऐ दे हुकम नी मनणे ने मते लोक पापी बणे, तियां ही इक माणुऐ दे हुकम मनणे ने मते लोकां धर्मी बणना है। ");
INSERT INTO bht_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","मूसा दी व्यवस्था दिती गेई ताकि सारे लोक जाणी सकन की सै कितणे पापी न, पर जालू लोकां पाप पर पाप किते, तां परमेश्वरे अपणी दया कने अनुग्रह होर भी जादा दसया, ");
INSERT INTO bht_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","जियां सारयां पाप किता कने सारे मरी गे, तियां ही साड़े प्रभु यीशु मसीह दे जरिये परमेश्वरे दे अनुग्रह ने उना जो धर्मी बणाणा कने उना जो हमेशा दी जिन्दगी देणी। ");
INSERT INTO bht_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","तू सोचदा है, की अगर परमेश्वरे अपणे अनुग्रह ने साड़े पापां जो माफ करी दितया है, पर असां ऐसा ना सोचन, चला असां पाप करदे रेंन ताकि अनुग्रह होर जादा हो। ");
INSERT INTO bht_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","नी बिलकुल भी नी! अगर असां पाप तांई इक बरी मरी गे तां सांझो लगातार पाप नी करणा है। ");
INSERT INTO bht_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","असां जाणदे न की जालू असां यीशु मसीह सोगी इक होंणे तांई बपतिस्मा लिया, तां असां यीशु मसीह सोगी मरी गे। ");
INSERT INTO bht_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","जालू असां बपतिस्मा लिया तां ऐ ऐसा था जियां असां मसीह सोगी मरी गे कने उस सोगी दफनाई दिते, ताकि जियां मसीहा पिता परमेश्वर दिया महिमा दे जरिये मरयां चे जिन्दा किता, तियां ही असां भी नोई जिन्दगिया जो नोऐ तरीके ने जिन। ");
INSERT INTO bht_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","क्योंकि अगर असां बपतिस्मे जरिये यीशु दी मौता च उदे सोगी इक होई गे, तां पक्का है की असां उदे जिन्दे होणे पर उदे सोगी इक होई जाणा। ");
INSERT INTO bht_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","क्योंकि असां जाणदे न की साड़ा पराणा पापी सभाब यीशु मसीह सोगी सूली पर चढ़ाया गिया, ताकि शरीरे दा पापी सभाब खत्म होई जाऐ, कने असां अग्गे जो पाप दे गुलाम नी रेन। ");
INSERT INTO bht_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","क्योंकि जालू असां मसीह सोगी मरी गे तां असां पाप दी शक्ति ला मुक्त होई गे। ");
INSERT INTO bht_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","इस तांई अगर असां मसीह सोगी मरी भी गे, तां साड़ा भरोसा ऐ भी है की उदे सोगी जींणा भी है, ");
INSERT INTO bht_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","क्योंकि असां जाणदे न की, मसीह मरी करी जिन्दा होया कने फिरी कदी नी मरणा है। मौत दा उस पर कोई हक नी है। ");
INSERT INTO bht_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","क्योंकि यीशु मसीहा जड़ा मरी गिया तां पाप तांई इक ही बरी मरी गिया; पर जड़ी जिन्दगी सै जी दा है, सै परमेश्वर दे आदर तांई जिंदा है। ");
INSERT INTO bht_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","इयां ही तुसां भी अपणे आपे जो पापे दी शक्ति तांई मरया होया समझा, पर परमेश्वरे तांई यीशु मसीह जो इज्जत देणे तांई जिया। ");
INSERT INTO bht_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","इस तांई पापी इच्छां जो अपणिया जिन्दगिया पर राज करणा मत दिया, ताकि तुसां अपणियां पापी इच्छा दे अनुसार कम्म ना करन। ");
INSERT INTO bht_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","कने ना अपणे शरीर दे अंगा जो बुरे कम्मा तांई इस्तेमाल करा, पर अपणे आपे जो मरयां चे जिन्दा समझीकरी अपणे आपे जो परमेश्वरे जो दिया, कने अपणे शरीरे दे अंगा जो धार्मिकता दे कम्मा जो पूरा करणे तांई अपणी जिन्दगी परमेश्वरे जो दिया। ");
INSERT INTO bht_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","तां तुसां पर पाप दी शक्तिया राज्य नी करणा, क्योंकि तुसां मूसा दी व्यवस्था दे अधीन नी पर परमेश्वर दे अनुग्रह दे अधीन न। ");
INSERT INTO bht_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","तां क्या होया? अगर हुण असां व्यवस्था दे अधीन नी न पर परमेश्वरे दे अनुग्रह दे अधीन न, तां सांझो पाप नी करणा चाईदा। ");
INSERT INTO bht_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","तुसां ऐ जाणदे न की जालू तुसां अपणे आपे जो कुसी दा गुलाम बणाई दिन्दे न, तां फिरी सै माणु तुहाड़ा मालिक है कने तुसां जो सै करणा चाईदा जड़ा सै बोलदा है: तुसां पाप दे गुलाम बणी सकदे न, जड़ा तुसां जो मौता पासे लेई जांदा है, या तुसां परमेश्वरे दे गुलाम बणी सकदे न, जड़ा तुसां जो धार्मिक जिंदगी जिणे च अगुवाई करदा है। ");
INSERT INTO bht_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","तुसां जड़े पाप दे गुलाम थे, पर हुण तुसां उस शिक्षा जो मंदे न जड़ी तुसां जो मिल्ली है, इदे तांई मैं परमेश्वर दा धन्याबाद करदा है, ");
INSERT INTO bht_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","परमेश्वरे तुसां जो पाप दी शक्ति ला अजाद करी दिता कने तुसां परमेश्वर दे गुलाम बणी गे, की सै करणे तांई जड़ा सही है। ");
INSERT INTO bht_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","मैं गुलामी दा ऐ उदाहरण तुसां जो इस तांई दिता ताकि तुसां असानी ने समझी सकन की मैं क्या सिखा दा है। जियां तुसां अपणे शरीरे दे अंगा जो बुरे कम्म कने अपवित्रता दी गुलामी तांई देई दिता, तियां ही हुण अपणे शरीरे दे अंगा जो भले कम्म कने पबित्रता दे गुलाम होणे तांई देई दिया। ");
INSERT INTO bht_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","जालू तुसां पाप दे गुलाम थे, तां तुसां दी भले कम्मा जो करणे दी कोई इच्छा नी थी। ");
INSERT INTO bht_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","तुसां बुरे कम्म किते, कने तुसां हुण इना कम्मा ला शरमिंदा होंदे न। तां तुसां जो क्या मिल्ला? ऐसे कम्म सिर्फ मौत लेईकरी ओंदे न। ");
INSERT INTO bht_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","पर हुण पाप ला अजाद होईकरी कने परमेश्वरे दे गुलाम बणी करी तुसां दे ऐसे कम्म जिन्दगी च पबित्रता लेईकरी ओंदे न, कने उना दा अंत हमेशा दी जिन्दगी है। ");
INSERT INTO bht_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","क्योंकि पाप दा नतीजा मौत है, पर सै बरदान जड़ा परमेश्वर सांझो दिन्दा है, सै हमेशा दी जिन्दगी है जड़ी साड़े प्रभु यीशु मसीह च है। ");
INSERT INTO bht_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","हे मसीह भाईयो, तुसां जाणदे न (मैं व्यवस्था जो जाणने बालयां जो बोलदा हे) की जालू दीकर माणु जिन्दा रेंदा है, तालू दीकर ही उस व्यवस्था दा अधिकार उस पर है? ");
INSERT INTO bht_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","3","उदाहरण तांई, व्यवस्था दे अनुसार इक माणुऐ दी घरे बाली उदी ही घरे बाली बणी की रे जालू दीकर उसा दा घरेबाला जिन्दा है, पर जालू उसा दा घरेबाला मरी गिया, तां सै कुसी होरसी ने बियाह करणे तांई अजाद है, पर अगर सै अपणे घरे बाले दे होंदे होए कुसी होरसी माणुऐ सोगी चली जाऐ, तां उसयो व्यभिचारणी बोलदे न। ");
INSERT INTO bht_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","तां हे मेरे मसीह भाईयो, जालू तुसां मसीह सोगी मरी गे, तां तुसां व्यवस्था दे अधिकार तांई भी मरी गे। हुण तुसां मसीह दे न जड़ा मरयां चे जिन्दा होई गिया ताकि तुसां परमेश्वरे तांई फलदायक जिन्दगी जी सकन। ");
INSERT INTO bht_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","क्योंकि जालू असां पापी सभाब दे बशे होंदे न, तां पापी इच्छां साड़े अंदर कम्म करदियां न कने व्यवस्था इना पापी इच्छां जो जगाई दिंदिया न कने मौत दा फल पैदा करणे तांई साड़े शरीर च कम्म करदियां न। ");
INSERT INTO bht_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","पर असां व्यवस्था तांई मरी गे जिना सांझो गुलाम बणया था, पर हुण व्यवस्था ला अजाद होई गे न, हुण असां लिखियो व्यवस्था जो परमेश्वरे दी सेबा मन्नी करी नी करदे न, पर आत्मा दियां गल्लां जो मनी करी नोऐ तरीके ने सेबा करी सकदे न। ");
INSERT INTO bht_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","तां असां क्या बोलणा? क्या व्यवस्था पाप है? नी बिलकुल भी नी! पर व्यवस्था ने मिंजो पता चला की पाप क्या है। मिंजो समझ आया की लालच करणा पाप है क्योंकि ऐ व्यवस्था च लिखया है, की लालच मत कर। ");
INSERT INTO bht_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","पर पापे इना हुकमा दा इस्तेमाल करिके मिंजो च हर तरह दा लालच पैदा किता, क्योंकि बिना व्यवस्था दे पाप मुर्दा है। ");
INSERT INTO bht_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","मैं तां व्यवस्था बिना जाणयो जिन्दा था, पर जालू मैं व्यवस्था जो जाणी लिया, तां पाप करणे दी इच्छां मेरे अंदर बदी गियां, कने मैं परमेश्वरे ला लग होई गिया। ");
INSERT INTO bht_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","कने सेई हुकम जिना जो परमेश्वरे मिंजो जिन्दगी देणे तांई दितया था, इना ही मिंजो परमेश्वर ला लग करी दिता। ");
INSERT INTO bht_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","क्योंकि पापे इना हुकमा दा इस्तेमाल करिके मिंजो धोखा देई दिता, कने उनी ही मिंजो परमेश्वरे ला लग करी दिता। ");
INSERT INTO bht_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","इस तांई व्यवस्था पाप नी पर पबित्र है, कने हुकम पबित्र, धर्मी कने सही है। ");
INSERT INTO bht_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","क्या व्यवस्था जड़ी खरी थी, मिंजो परमेश्वरे ला लग होणे दी बजा बणी? सै जड़ी खरी थी, मिंजो परमेश्वरे ला दूर करणे दी बजा बणी? नी बिलकुल भी नी! पर ऐ पाप था जिनी ऐ किता, पापे व्यवस्था जो इस्तेमाल किता जड़ी सही थी, ताकि सै मिंजो परमेश्वरे ला लग करे, इस तरिके ने पापे दस्सी दिता की सै सच्ची च क्या है, कने हुकम दस्सी दिता की पाप बुरा है। ");
INSERT INTO bht_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","क्योंकि असां जाणदे न की व्यवस्था तां आत्मिक है, पर मैं शारीरिक माणु कने पाप दा गुलाम है। ");
INSERT INTO bht_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","कने जड़ा मैं करदा है उसयो नी जाणदा, क्योंकि जड़ा मैं चांदा है सै नी करदा, बल्कि सै ही करदा है, जिसला मैं नफरत करदा है। ");
INSERT INTO bht_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","कने अगर, जड़ा मैं नी चांदा है सेई बुरे कम्म मैं करदा है, तां मैं मनी लेंदा है की व्यवस्था खरी है। ");
INSERT INTO bht_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","तां ऐसी हालत च जड़ा बुरे कम्म करणे बाला है सै मैं नी, पर पाप है जड़ा मिंजो च बसया है। ");
INSERT INTO bht_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","क्योंकि मैं जाणदा है, की मेरे पापी सभाब च कुछ भी खरा नी है, भले कम्म करणे दी इच्छा तां मिंजो च है, पर भले कम्म मिंजो ला होंदे नी। ");
INSERT INTO bht_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","क्योंकि जिस खरे कम्मे दी इच्छा मैं करदा है, सै तां नी करदा, पर जिसा बुराईया दी इच्छा नी करदा, सेई करदा है। ");
INSERT INTO 