﻿USE sofia;
DROP TABLE IF EXISTS sofia.bhl_vpl;
CREATE TABLE bhl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bhl_vpl WRITE;
INSERT INTO bhl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Talfut kese ding dim bakate, Sunbin-Got e abiil so kawin so mesesem alik alik be kilkese kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Kate, kawin so abiil so be mililiw so bonggubi biliwi, Sunbin-Got em kitil e inim finik atew ete kuw fukafuka kebomi, okmun fian tikin dim boktak tiw kalote alenale kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Beli, Sunbin-Got e bokolomele: “Felet mak angoka!”, angei, fein felet fak angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Angei, e atemeko, “Felet be ken kele kai!”, angse kale. Angei, mililiw akal amen kelei, felet akal amen ka da, ka da kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Kelewsomi, felet beem wiin e bokolomele: “Be taw!”, angse kale. Angeko, mililiw beem wiin akal bokolomele: “Be kutiliw!”, angse kale. Angeko, kutiliw teleko, uneko, taw kikis mak matem teleko, emisik ding banimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Keko beli, Sunbin-Got e iti weng mak bokolomele: “Ok katiw da, kalak da, dolon kelew kelew kelina!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Angesomi, ok katiw da, kalak da beem mutuk e dolon mak dukuse kasike, ok katiw so, ok kalak so singam singam keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Keyemsomelei, e dolon beem wiin e “Abiil te!”, angse kale. Angei, kutiliw teleko, uneko, taw kikis mak matem teleko, emteben ding banimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Keko beli, Sunbin-Got e bokolomele: “Ok abiil afak kel be mutuk makmak kuw kelomele kano, aneng kale tiow dim keloka!”, angse kale. Angesomelei, em angse weng be fein kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Keko beli, e aneng tiow beem wiin e “Kawin te!”, angesomi, ok mutuk makmak kele beem wiin e “Okmun alelbin fian te!”, angse kale. Angesomelei, e diw atemeko, “Ken kele kai!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","12","Angesomelei, Sunbin-Got e bokolomele: “Kame, itel so kanemin kanemin ais dem so mesesem mesesem eisneng kawin dim talfut keloka!”, angse kale. Angei, em angse weng be fein kesomelei, ais mesesem mesesem eisneng banso talfut kese kale. Keko beli, Sunbin-Got e mesesem mesesem eisneng be diw atemete: “Ken keli kai!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Angei, kutiliw teleko, uneko, taw kikis mak matem teleko, yemamas ding kel banimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Keko beli, Sunbin-Got e bokolomele: “Abiil dolon dim kel ailbin banban mak fitewina! Ailbin be amen amen keko, taw so mililiw so beem ding ailsomi, ding akal amen amen kuw ke koyemo ya! ");
INSERT INTO bhl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Keko beli, ailbin angom bi abiil kel tebeko, kawin dim kalak elo ailboliwka!”, angse kale. Angei, em angse weng be fein kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kesomelei, Sunbin-Got e ailbin fian alew mak dukuse kale. Ailbin fian mak e, taw ding em kamok kese kale. E ataan te. Ailbin fong mak e kutiliw em kak kese kale. E kayow te. Kelei, fial galgul ban ikal dukuse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Dukusomi, abiil em ailbin angom alik alik bi kawin dim elo “Dan dukuko, felet kelebina!”, angeko, dukuse kale. Dukuko, ataan so kayow so ikal amen amen keyemei, i taw em aluwbamin so, kutiliw em aluwbamin so kesomi, kawin dim elo felet kelewkabiliw te. Kelewiwi, Sunbin-Got e ilo diw yetemete: “Ken keli kai!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Angei, kutiliw teleko, uneko, taw kikis mak matem teleko, ketket teben em ding kel banimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Keko beli, Sunbin-Got e bokolomele: “Okmun alelbin fian beem mutuk kel mesesem mesesem finik so bin talfut kelina! Kelomi, awon so mesesem mesesem bel so ikal fiteweko, kawin abiil dim bile yamkakamina!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Angeko, okmun alelbin fian beem samal inkal fian sel bi so, mali ka bokoliw mesesem mesesem eisneng finik so bi so, awon so, mali bel so mesesem mesesem eisneng bi so, alik alik mesesem mesesem eisneng biilo kilke duku koyemse kale. Koyemsomi, diw yetemete: “Ken keli kai!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Angesomelei, Sunbin-Got e ilo bamki duyemsomi, bokoyemomele: “Aul men kaileko, tulun kuw kesomi, okmun alelbin fian beem dim gekbina! Awon so, bel so mesesem mesesem eisneng biso, ikalti fukulako, al keko, kawin dim elo gekbina!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Angei, kutiliw teleko, uneko, taw kikis mak matem teleko, ketket em ding kel banimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Keko beli, Sunbin-Got e bokolomele: “Kawin be samal mesesem mesesem finik so eisneng talfut kelina! Am samal so, kut samal so, mesesem mesesem finik so yan banim eisneng so, alik alik bi talfut kelina!”, angse kale. Angei, em angse weng be fein kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Feinka! Sunbin-Got e kut samal so, am samal so, mesesem mesesem finik so yan banim eisneng so, alik alik finik so bin bei kilke dukuse kale. Dukusomi, diw atemete: “Ken keli kai!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Angesomi, iti weng mak bokolomele: “Kunum so waneng so mak nukalem atew, nukalem takak emdiw kemuma o! Kunum so waneng so bi okmun beem mesesem bi so, awon bi so, samal bi so, kawin beem finik so mesesem mesesem eisneng bi so, mesesem mesesem finik so keko, yan banim eisneng bi so, alik alik mesesem mesesem eisneng biilo kilele yetewboliwka!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Angsomi, kunum waneng akalem takak emdiw dukuse kale. Feinka! E kunum kelew, waneng keum duku koyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Koyemeko, ilo bamki duyemsomi, bokoyemomele: “Aul banban kailsomi, kawin fe abiil fe alik alik angom be al kelina! Okmun alelbin sel beem mesesem bi so, abiil afak em awon bi so, kawin dim em samal bi so, yu alik alik biim kak kunum waneng keko, ilo kilele yeteboliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Yangeko, weng makso mak bokoyemomele: “Yu kawin dim em itel o, ais dem o, mesesem mesesem dukuyemsi be wanbomi, boliwka! ");
INSERT INTO bhl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Feinka! Ne kawin dim beem samal so, abiil dim em awon so, mesesem mesesem finik so eisneng bi so, alik alik ilo im wanin itel so, ais dem so, amen amen dukuyemii, i wanboliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Yangei, em angse weng be fein kese kale. Kesomelei, Sunbin-Got e mesesem mesesem kilke dukuse eisneng bi diw atemete: “Ken ati kuw keli kai!”, angeko, “Seyo!”, angesomelei, kalfongse kale. Keko beli, kutiliw teleko, uneko, taw kikis mak matem teleko, gung em ding kel banimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","2","Keko beli, Sunbin-Got e gung kel ding aulbabelei, abiil so, kawin so, beem mesesem eisneng fok ke kolewse kale. Fok kolewsomi, ben kel ding kabalak e, e akalem alubamin alik alik be banim keleweko, finengdase kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Finengdase kasike, Sunbin-Got e ben em ding em dim beelo akalem ding kuw dukuko, tokotoko ayem ding kelewse kale. Nimtew angom? Gung kel em ding be, e alik alik mesesem mesesem eisneng bi kilele duku kolewse kasike. ");
INSERT INTO bhl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Sang be Yawe Sunbin-Got em kawin so abiil so talfut dukuse sang bete te. ");
INSERT INTO bhl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Kate itel so, ais mesesem mesesem so, alik alik eisneng bi tebelinba kesiliw ding kabalak e, suuk akal banimei, kawin musun kailomin kunum mak akal banimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Beem ding dim kabalak e, ok e yukam misin atew kawin katiw somelei, kawin elo ok dukalewale kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Keko beli, Yawe Sunbin-Got e tawal dak fakalat kelewko, kawin be amiami kelewsomelei, kunum mak keleweko, em mutum tem kel akalem fukfuka fu kelei, kunum be finik so kese kale. Kunum be Adam te. ");
INSERT INTO bhl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Keko beli, e ataan tele dulum kalote ken musun mak dukusomi, kunum beelo debeleko, elo ka kel kolewse kale. Kolewse musun beem wiin e Iden te. ");
INSERT INTO bhl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Beli, musun dim ka kel e ais banban mak talfut kelewsomi, ais ati so ati so em dim e wanin dem so dem so ken kuw dukuse kale. Dukusomi, musun ka kel beem mutuk kabalak e ais alew mak dukuse kale. Ais alew bi mak e, finik so bin duyembin em ais te. Mak e, wa so ken so elo fitew dalomin em ais te. ");
INSERT INTO bhl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Keko beli, musun Iden ka e, ok malmil miktem telebin ok mak alenale kale. Ok malmil miktem telebe ok be musun em kawin elo ok dulew ke alenale kale. Kebomelei, ok be teing titeleko, ketket teben aneng aneng elo kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Emisik ok em wiin e Bison te. E gol on kisol so eisneng Kawila aneng fian beem dulum elo falalse kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Gol on kisol be ken ati kuw te. On kisol eisneng makso mak alenale te. Mak e, filik falak tum win “Kanilian” e, mak e, kamge so ais gom mak te. ");
INSERT INTO bhl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Beli, mak emteben ok em wiin e Gikon. Gikon ok bang e Kus aneng elo falal kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Yemamas ok beem wiin e Taigilis. Ok be anko, ataan tele beem dulum Asilia aneng fian kalo kese kale. Ok fefe beem wiin e Yufeletis. ");
INSERT INTO bhl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Keko beli, Yawe Sunbin-Got e kunum beelo bokolewomele: “Ku musun Iden elo kilelbi atebolewka!”, dangeko, elo duku kolewsomelei, ");
INSERT INTO bhl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","iti weng makso mak bokolewomele: “Alik alik ais angom beem ais dem be ken kuw kelei, ku fein wanbolewka! ");
INSERT INTO bhl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Kate, ku kanelom ais ken so wa so kal kemin ais beem dem wanokolew te! Wanew tewe, ku fongate akate atin kuw kuanokolew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Dangeko beli, anfel e Yawe Sunbin-Got e bokolomele: “Adam be emikel kuw be kasike, ken bate. Kame, ne elo dokoleweko, eso fangfang dakamin akalem atew mak dulewoki te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Angesomelei, Yawe Sunbin-Got e tawal kuluko, mesesem mesesem samal so, abiil awon so, alik alik eisneng angom be amiami duku koyemsomi, ilo kunum beem mit mewso koyemse kale. Koyemsomelei, kunum be alik alik ilo diw yetebomelei, ikalem wiin amen kuw amen kuw bokoyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Keko beli, kunum be mesesem mesesem kut samal bi so, am samal bi so, abiil em awon bi so, alik alik finik so bin biim wiin amen kuw amen kuw bokoyemse kate, fangfang dakamin akalem atew mak banim kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Beli, Yawe Sunbin-Got e Adam elo kuanin atew kiin ok ilum fian mak dulewsomi, em melen kun makmak takas kuluko, tem be iti talewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Taleweko, melen kun be kuluko, waneng mak kaiko, ulo kunum be so koumse kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Koumeko, kunum be waneng buulo watemeko, bokolomele: “Kae, Yawe nakalem kun, nakalem dim kuluko, waneng bute dukunemse kasike, um wiin e waneng te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Beem mongom ete kame akal, kunum kumel i ikalem aliwol kumel so auk kumel so koyem uneko, ikalem kalel kusel iso teinsomi, i kal anggil makmak kekabiliw te. ");
INSERT INTO bhl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Kunum be so, waneng bu so, yemkal bi anggil fitew kesiliw kate, i finganinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Feinka! Yawe Sunbin-Got e samal alik alik dukuse kate, sokyan em weng e abal nam keko, funum fimdi famde ibolow so kese kale. Kasike, sokyan be waneng buulo bokoumomele: “Sunbin-Got e ‘Alik alik ais dem angom kale wanbokoliw te!’, yangse yako?” wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Wangei, usik yan weng mak bokolewomelu: “Bayo! Sunbin-Got e nulo bokoyemomele: ‘Ais dem alik alik kale wanboliwka!’, yangse te. ");
INSERT INTO bhl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Kate, e nulo kitil kuw bokoyemomele: ‘Musun kaleem mutuk e, ais makmak beem dem ete kuw yu kanelom meleleweko, dakalu wanbokoliw te! Auliw tewe, kuankemin matem daloki te.’, yangeko, alakabe te.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Dangui, sokyan e iti yan weng mak bokoumomele: “Babo! Yu waniw tewe, nam kuaniw te. ");
INSERT INTO bhl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kate Sunbin-Got e kal kebete: Yu ais beem dem waniw tewe, yom kiin so bayemei, yu Sunbin-Got em kal atew kulusomi, kal so kunum waneng kelokoliw te. Keko, yu wa kukuw so ken kukuw so diw atemeko, kilele kal kelokoliw te.”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Wangei, waneng bu ais dem be atemute: Ais dem yom be atite atite weit weit kelei, um ibolow tem e “Wana! Wana!”, wangeko, ibolow kuw keumse kale. Nimtew angom? U fukunute: “Ne kal waneng keloki kai!”, angsu kasike, fein e, u ais dem mak dakuluko, wanesu kale. Wanesomi, iti dem mak dakulu aluwsomi, uneko, ukalem imok elo delew unui, imok akal wanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Wanei, yemkal biim kiin bayemei, i kal keliwete: “Yakai! Nu kal fitew kuw ke alakabuluw kai!”, angesiliw kale. Angsomeliwi, yemkal bi inkal fian kulusomi, ais kon fian kuluko, benesomeliwi, ikalem kal anggil dim kasisiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Beli, aneng kuineko, dim gilil so kebe dim kelei, yemkal bi kililomete: “Yawe Sunbin-Got e guingui tala kai!”, angko, inkal fian kulusomi, musun dim beem ais tem kel wokmosiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Wokmobiliwi, Yawe Sunbin-Got e kunum beelo gaalomele: “Ku nal nal kel kuw belew a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Dangei, kunum be yan weng mak bokolewomele: “‘Ku talbelew!’, angomi, finganin fian mak kuli te. Nimtew angom? Kal fitew kuw bi kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Dangei, Yawe e kunum beelo dakalalomele: “Ku nono keko, kal kelomelew: Ku kal fitew kuw belew a? Ku kate, ais dem ‘Ayem o!’, kangsi ais dem mak wane kembelew sako?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Dangei, kunum be iti yan weng bokolewomele: “Nete bate! Nelo dunemselew waneng kalute ais dem mak nelo dunemui, ne wani te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Dangei, Sunbin-Got e waneng buulo dakalalomele: “Ku nimtew angomete a?”, wangse kale. Wangei, u yan weng bokolewomelu: “Nete bate! Sokyan ete nelo kak kenemei, ne ais dem mak dakaluko, wane kembi te.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Dangui, Yawe Sunbin-Got e weng yakok so weng mak sokyan elo duleweko, bokolewomele: “Ilum atin kuw fian mak kulo dukemika. Kulokolew ilum be mali am samal so, kut samal so, biim ilum emdiw bate. Diwkuw, diwkuw ku teing banim yan banim keko, kukalem kumun kom dim bete kuw kawin dim gilin-gili kakabomelewi, kawin kukun kutew kutew bete kuw wanen kakamokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Keko beli, kom tele, waneng buum tele, maka kelew kelew keem kakamokoliw te. Kate, deiw mak ding mak e, um angin mak teleko, kom kak kawtol kekemoke te. Kawtol kekemei, kusik em yan golgol beelo ning tamolokolew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Dangeko, waneng buulo bokoumomele: “Diwkuw diwkuw, kom aul kumuneko, aul mewso dukulomin kemew ding dim e, ku ilum fian kulusomelewi, betbet fian akal mak kulamokolew te. Kulamokolew kate, diwkuw diwkuw, iti kimok elo ibolow kelokolew te. Kate, kimok em weng ete kuw kili wosu kebomelewi, em afak kuw bolewka!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Wangei, Sunbin-Got e Adam elo weng mak bokolewomele: “Ku kalel um weng wosuko, ais dem ayem be wanew kasike, kawin kale elo yakok keli te. Kom yemen soul kawin dim kulamokolew beem dulum elote ku bukesomi, ilum kakon somi, douw falil somelew ete, wanbom, bokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Feinka! Ku wanin musun beem wanin wanbokolew kate, musun bakati itel ningning so itel tem kuw kemoke te. ");
INSERT INTO bhl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ku dauw falil falil kuw kesomi, alubamokolew te. Bomelewi, deiw mak ding mak fein kuanokolew te. Kuanokolew ding kabalak be, ku iti tawal kelokolew te. Nimtew angom? Ne tawal kulusomelii, kunum kulo tawal so amiami kekemeko, duku kokemsi kasike. Feinka! Kukal kawin tawal keko, iti kawin tawal akate kelokolew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Dangei, Adam e em kalel um wiin e bokoumomele: “Kom wiin e Iw te!”, wangse kale. Nimtew angom? Kunum waneng alik alik biim alkemin auk kesu kasike. ");
INSERT INTO bhl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Beli, Yawe Sunbin-Got e samal kal mak kulusomi, beneko, Adam so em kalel so yemkal ilo minggiyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Minggiyemeko, Yawe Sunbin-Got e bokolomele: “Kame, kunum waneng bi wa so ken so eisneng be kal keliw kasike, i nukalem atew keliw te. Keliw kasike, i iti kanelom diwkuw finik so bin ais dem beem dim akal mewso uneko, beem dem bakal kuluko, wanokoliw te! I waniw tewe, i diwkuw diwkuw bokoliw kasike.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Angesomelei, Yawe Sunbin-Got e kunum waneng bi musun Iden ka kel em bine yenbakalase kale. Feinka! Sua e, e kawin tawal kuluko, kunum amiami kelewse te. Kate kame, kunum be uneko, bakalem kawin dim akate musun wanin kaibomi, alenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Beli, Yawe Sunbin-Got em Adam so em kalel so yemkal biim Iden yenbakalase ding kabalak e, e musun beem ataan telebe dulum kalote, akalem dabalakamin finik kitil nam mak mo koyemse kale. Mo koyemse yemdakamin finik biim wiin e Kelubim te. I biol atul o, tiakim o, ailbin fian atew famdes famdes kelewse so tuk mosiliw kale. Tuk moko, Iden musun ka kel kuw diwkuw diwkuw kutebiliw kasike, kawtiw bi finik so bin duyembe ais ayem beem mit mewso nam uniw te. ");
INSERT INTO bhl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Beli, Adam e kalel Iw ulo aul duumei, u kunum aul mak dukuko, beem wiin e “Ken.”, dangsu kale. Nimtew angom? U bokolomelu: “Yawe e nelo ken kenemei, ne kunum aul mak dukuli te.”, angsu kasike. ");
INSERT INTO bhl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Angeko, iti aul fakileweko, aul mak dukului, i em wiin e “Ebel”, dangsiliw kale. E Ken em awkunum te. Aso i tenbelsomeliwi, Ebel em aluwbamin e siwsiw yetebin kunum kesomelei, Ken em aluwbamin e wanin kaimin kunum kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Keko beli, deiw mak ding mak kelei, Ken e Yawe elo “Weso! Seyo!”, dangeko, emisik em yongiw wanin kuluko, dukalewale kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Beli, Ebel akati Yawe elo “Weso! Seyo!”, dangeko, emisik dukulu siwsiw men ibolow mel ati kuw mak kele be anko, dukalewale kale. Dukalewei, Yawe e Ebel elo kalfong fian kelewale kate, ");
INSERT INTO bhl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","e Ken so, akalem dukulewkabe emisik yongiw wanin beso diw atemeko, beelo kakatinba kelewale kale. Kelewbelei, Ken e atemeko, ibolow wa kelei, em kiinguen kaim alala kaisuw nanew kuw famdes kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Keko beli, Yawe e Ken elo bokolewomele: “Kutaka! Ku nobelew a? Nimtew angom ete kom kiinguen amu kaim alala kaisuw nanew kuw famdes kebelew, a? ");
INSERT INTO bhl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ku kilila! Kute ken kukuw kuw kebelew tewe, ken kuw bokolew te. Kate, ku wa kukuw kemew tewe, wa kukuw be kulo kensomelei, teng so kekemoke te. Kate, kukal kitil keko, beelo de mit da kolewolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Dangei, anfel e, Ken e Ebel awkunum beelo bokolewomele: “Kaso nu kut kakamuma!”, dangse kale. Dangei, aso i uneko, kut dim mit tem unsiliw kale. Uneko, Ken e awkunum beelo alei, e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Keko beli, Yawe e Ken elo dakalalomele: “Kom kawkunum Ebel e, nal kel be?”, dangse kale. Dangei, Ken e yan weng mak bokolewomele: “Ne kal e! Ne elo atebin kunum ba kasike!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Dangei, Yawe e Ken elo bokolewomele: “Kutaka! Nimtew angom ete ku kukuw wa be kelew a? Feinka! Kawkunum beem kaim e buselewi, e kawin tem une te. Ne kaim beem amemin kililika. Kaim be nelo gaaneko, bokonemomele: ‘Kukuw wa beem yan wa dulewa o!’, nange te. ");
INSERT INTO bhl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","12","Kame, ne weng kitil weng mak dukemi te. Nimtew angom? Ku kawkunum alewi, e kuane kasike. Kame, kukati yakok kekemi te. Kawkunum em kaim aleleko, kawin kale du kelew kasike, wanin kailokolew be, nam tebeme te. Ku fukafuka kunum kesomi, kawin abin dak kilele ken nam teinew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Dangei, Ken e yan weng bokolewomele: “Ebe! Kame, ilum fian mak dunemew kae! Kal ilum fian mak keli te. ");
INSERT INTO bhl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","‘Ku wanin nam kaimew te!’, nangew te. ‘Nem mewso nam bew te!’ nangew te. ‘Kawin banim o!’ nangew te. ‘Fukafuka kunum bew te!’, nangew te. Kame ne ‘I nelo neniw kuanoki sako!’, angomi, finganbi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Dangei, Yawe e Ken elo bokolewomele: “Ku finganemokolew te! Ne weng fawtuk ayem weng fian mak kulo dukemi te. Mak kunum mak keniw tewe, ne ilo ilum fian mak duyemsomi, im yan wa kulokoliw yan be kom kulubelew yan wa be ben kel em dim bakilewoke te.”, dangse kale. Dangeko, Yawe e Ken em dim e mak eisneng mak dukulewbelei, kawtiw i beelo atemsomi, elo alinba kemaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Beli, Ken e Yawe em mit elo koleweko, uneko, kawin mak teinse kale. Kawin beem wiin e Not. Kawin be musun Iden em ataan matem talakabe beem dulum mewso kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Beli, Ken e akalem kalel so bomi, ulo aul duumse kale. Duumei, u kunum aul mak dukuko, em wiin e “Enok”, dangsu kale. Keko beli, Ken e abiw mutuk fian mak gesomelei, abiw mutuk fian beem wiin e akalem min em wiin so takayak moleweko, “Enok!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Beli, Ken em min Enok e waneng mak kuluko, aul mak dukuko, em wiin e “Ilat” dangse kale. Ilat em min e Mekuyael te. Mekuyael em min e Metusael te. Metusael em min e Alamek te. ");
INSERT INTO bhl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Alamek be kayot kunum keko, waneng alew mak yemduse kale. Waneng alew mak um wiin e Ada, mak um wiin e Sila te. ");
INSERT INTO bhl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada bu kunum aul mak dukuko, em wiin e “Yabal!”, dangsu kale. Yabal so em muluwel dow so i samal kal benemin am kakabiliw kunum waneng kesomi, bulmakao so siwsiw so yetebin kawtiw im kunum mongom kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Akalem awkunum em wiin e Yubal te. Yubal so em muluwel dow so i fotiaw so, tanam atew eisneng so, beem dim sim bakabiliw kawtiw im kunum mongom kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Keko beli, Alamek em afam waneng Sila ukal aul mali mak dukusu kale. Emisik min em wiin e Tubal-Ken te. Tubal-Ken so em muluwel dow so i biol so sek so kaimin kawtiw im kunum mongom kesiliw kale. Sila bu waneng aul mak ukal dukusomi, um wiin e “Nama!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Keko beli, Alamek e akalem kalel alew ilo bokoyemomele: “Ada! Sila! Nem kalel alew, kuso yu nem weng kale kililina! Kunum tenbel mak neso genei, ne elo anii, e kuanse te. Beemdiw aul mak nelo betbet dunemei, ne elo an fomdosi te. ");
INSERT INTO bhl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Beli kasike kame, kawtiw kanete mali mak i Ken elo aliw tewe, im yan wa e atin kuw ilum fian keko, mali im ilum kulokoliw beelo ben kel em dim bakilewoke te. Kate, mali kawtiw mak nelo ilum mak dunemiw tewe, i kanebiliw beem yan e 77 dim kel kulokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Beli, Adam e kalel Iw ulo iti aul mak duumei, u iti kunum aul mak dukusu kale. Dukuko, aul beem wiin e “Set.”, dangsu kale. Nimtew angom? U bokolomelu: “Feinka! Ken e akalem ning elo alei, e kuanse kate, Yawe e kuanse kunum Ebel em abin kulomin aul mak dunemse te.”, angsu kasike. ");
INSERT INTO bhl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Keko beli, Set akal min mak dukuko, em wiin e “Enos”, dangse kale. Beem ding kabalak e, kunum waneng i Yawe em wiin daolim kukuw matem dasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Sang be, Adam em muluwel im talfut keyemse sang te. Sunbin-Got em Adam beelo talfut kilke dukuse em ding dim e, e elo akalem takak atew kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Keleweko, kunum kelew, waneng keum duku koyemomi, ilo bamki so keyemeko, im wiin e bokoyemomele: “Kawtiw kunum waneng yute te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Beli, Adam em itol e 130 keko, min mak akalem takak emdiw dukuko, em wiin e Set dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Dangeko, em itol e 800 makso keko, iti kunum aul duku, waneng aul duku, kailse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Aul kailsomelei, akalem itol e 930 kelei, fe e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set em itol e 105 keko, Enos dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Keko, em itol e 807 makso keko, iti kunum aul duku, waneng aul duku, kailse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Aul kailsomelei, akalem itol e 912 kelei, fe e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos em itol e 90 keko, Kenan dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan dukuko, em itol e 815 makso keko, iti kunum aul duku, waneng aul duku, kailse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Aul kailsomelei, akalem itol e 905 kelei, fe e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan em itol e 70 keko, Makalalel dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Makalalel dukuko, em itol e 840 makso keko, iti kunum aul duku, waneng aul duku, kailse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Aul kailsomelei, akalem itol e 910 kelei, fe e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Makalalel em itol e 65 keko, Yalet dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yalet dukuko, em itol e 830 makso keko, iti kunum aul duku, waneng aul duku, kailse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Aul kailsomelei, akalem itol e 895 kelei, fe e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yalet em itol e 162 keko, Enok dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enok dukuko, em itol e 800 makso keko, iti kunum aul duku, waneng aul duku, kailse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Aul kailsomelei, akalem itol e 962 kelei, fe e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok em itol e 65 keko, Metusela dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusela dukuko, em itol e 300 makso keko, Sunbin-Got em weng gelewsomi, iti kunum aul duku, waneng aul duku, kailse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Aul kailsomelei, akalem itol e 365 kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","E Sunbin-Got em weng gelewkabe kunum kese kasike, deiw mak ding mak kabalak e, Sunbin-Got e kunum beelo kal so kun so kulei, kawtiw i elo ateminba keko, fen kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela em itol e 187 keko, Alamek dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Alamek dukuko, em itol e 782 makso keko, iti kunum aul duku, waneng aul duku, kailse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Aul kailsomelei, akalem itol e 969 kelei, fe e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Alamek em itol e 182 keko, kunum aul mak dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Keko, min beem wiin e Noa dangse kale. Nimtew angom? E bokolomele: “Yawe e kawin beelo du kese kasike kame, nu aluwbamin fian bukekabuluw te. Kate, kunum aul be nulo dokoyemei, nulo aluwbamin beem finengdakamin ding mak duyemoke te.”, angse kasike. ");
INSERT INTO bhl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noa dukuko, em itol e 595 makso keko, iti kunum aul duku, waneng aul duku, kailse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Aul kailsomelei, akalem itol e 777 kelei, fe e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa em itol e 500 keko, Sem, Kam, Yafet yangmeli biilo kail dukuse kale. ");
INSERT INTO bhl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Beem ding dim kabalak e, kawin dim kaleem kawtiw i banso kesomeliwi, waneng aul duku tem duku tem keyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Keyemsomeliwi, waneng aul biim seiwel kesiliw ding dim e, finik kunum i mali waneng seiwel atite ati biilo yetemeko, ilo ibolow keyemsomi, ikalem ibolow kuw yemdusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","4","Yemdusomeliwi, i aul kailsomeliwi, aul bi tanbeleko, kunum waneng tiaktiak, kitil nam inkal so fasulin kunum waneng ke alenaliw kale. Keko beli, Yawe e bokolomele: “Diwkuw diwkuw, nem finik e nam kunum waneng iso be te. Nimtew angom? Kunum waneng dem so kal so biliw kasike. Ikalem itol e 120 ka kel kuw ayet keyemi te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Beli, Yawe e kawin dim kaleem kunum waneng im ibolow sili sili nam atemeko, “Ikalem ibolow e diwkuw diwkuw sili sili nam kukuw kuw gelewkabiliw kai!”, angeko, ");
INSERT INTO bhl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","sakik fian mak kuluko, bokolomele: “Nimtew angom ete ne kunum waneng bi talfut keyemsi yake?”, angeko, ibolow tiaktiak kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kesomi, bokolomele: “Kilkeyemsi kunum waneng so, samal so, abiil dim boktak kakabiliw awon so, kawin dim em samal so, alik alik finik so biliw biilo kuiaw banim keyemoki te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Angse kate, Sunbin-Got e Noa em ibolow fukunin kiol so, em kukuw ken so be atemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Sang be, Noa em talfut kelewse sang te. Sunbin-Got em kiin dim e, Noa e kunum kiol kuw kunum keko bomelei, e Sunbin-Got em ibolow fukunin kuw gelewemale kunum alenale kale. ");
INSERT INTO bhl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Em muluwel alemsal biim wiin e mak e Sem, Kam e, Yafet e. ");
INSERT INTO bhl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Sunbin-Got e kawtiw biilo yetemeko, “Im ibolow e sili sili nam kuw kai! Kawin dim kale, i sakalaw keko, weng bo bo kuw keko, teifuluko, ganomin ibolow kuw kesomeliwi, alik alik i atin kuw wa wa kukuw kuw kemaliw te. Feinka! Itel mak kunum gel mak kukuw ken so kelomin so kunum banim te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Keko beli, Yawe e Noa elo bokolewomele: “Kawin dim kaleem kunum waneng bi so, im ganbin so, sakalaw keko, weng bo bo kukuw so, be atin kuw fian kebe kasike, ne ilo atin kuw banim keyemoki te. ");
INSERT INTO bhl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kasike kame, Noa, ku ais kok am siw fian mak gelolewka! Gesomi, ais gom atew kawin dim em eisneng mak kulusomi, siw tem beem ais kok kut so am so be be eisneng beso gus kabilewolewka! ");
INSERT INTO bhl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Siw beem fian e kanekote: Mili dulum elote 150 mita, yelem dulum e: 25 mita. Siw em tiakim e 15 mita kaneko te. ");
INSERT INTO bhl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Siw beem gelokolew ding dim e, ku elo kanelom mililbi kelokolew te! Ku kanelom ais kok gaktak so kasilokolew te! Kate, katiw e dolon mak em fian e ben kun em ki atew ke kolewoleka! Kolewko, siw beem tem e am alemsal mak gelolewka! Am mak e dak, am mak e mutuk, am mak e tikin te. Keko beli, siw beem yelem dulum be abisom makmak kalololewka! ");
INSERT INTO bhl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nimtew angom? Ok fian mak dabalalii, e alel toloke kasike. Ne kawin beem mesesem mesesem finik so alakabe be alik alik yenii, i kuanokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kate, ne ku so kitakamin weng mak amkoko, dukoloki te. Fein! Ne kulo nam keni te. Kame, ku kukalem aul waneng biilo kuluko, am siw tem kawtem unolewka! ");
INSERT INTO bhl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Uneko, alik alik samal angom biim yanggus mak kulu, imok mak kulu, siw tem da koyem koyem keyemolewka! Mesik esik ok tom ilo kuiaw keyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Abiil boktak kakabiliw awon so, kawin dim kale kakabiliw samal so, alik alik biim imok so, yanggus so, yemkal yemkal kuw telesomi, kuso siw tem unoliwka! Mesik esik ok tom ilo kuiaw keyemoke kasike! ");
INSERT INTO bhl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Keko beli, ku wanin akal kuluko, siw tem dalolewka! Samal im wanin akal, kawtiw yukalem wanin akal, awon im wanin akal kulolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Dangei, fein, Noa e em dangse weng be kili wosuko, fein kanelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kaneko, iti deiw mak kelei, Yawe e Noa elo weng makso bokolewomele: “Ku nem kiin dim e ken kukuw kuw gelewbelew kunum te. Kasike, ku kukalem aul waneng ilo kuluko, siw tem da koyemolewka! ");
INSERT INTO bhl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Samal mesesem ikal mak kuluko, siw tem dalolewka! Samal mali mak nem kiin dim e tokotoko so kebiliw samal bi imkel kuw amen amen kuluko, imok ben kel so yanggus ben kel so yemkal yemkal ben kel mak siw tem elo da koyemolewka! Kate, mali samal nem kiin dim e ninik so kebiliw samal bikati imikel kuw amen amen kuluko, imok e, yanggus e, yemkal yemkal makmak kuw kulolewka! ");
INSERT INTO bhl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Abiil em awon bakati ben kel imok e, ben kel yanggus e, yemkal yemkal ben kel kulolewka! “Mesik esik kawin dim kaleem samal alik alik biim mongom e atin kuw banimokoliw kai!” angomi, kelolewka! ");
INSERT INTO bhl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Nimtew angom? Ben kel ding banimi, ne suuk fian mak mit dabalaloki kasike. Taw ding akati, mililiw ding akati, akalka fo akalka fo ding tulun kuw kelokobe be, fu alew ding keloke te. Keko beli, kawin dim kaleem mesesem mesesem finik so biliw bi atin atin kuiaw yen banim keyemokite.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Dangeko, Noa e Yawe em dangse weng be kiliko, fein gelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ok dang ok fole fole kelewse beem talse ding e Noa em itol e 600 kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Kelei, Noa so, akalem aul waneng biso, alik alik i siw tem elo unsiliw kasike, ok dang ok fole fole kelewse be ilo yeninba kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Keko beli, awon so, samal mesesem so, mali Sunbin-Got em kiin dim tokotoko so kebiliw samal biso, mali Sunbin-Got em kiin dim ninik so kebiliw samal biso, ");
INSERT INTO bhl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","imok so, yanggus so, alik alik i ba teliwi, Noa e ilo siw tem da koyemse kale. Feinka! Kanelewse alik alik be Sunbin-Got em Noa elo dangse weng beelo ki kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Anfel e, ben kel ding uneko, banimei, ok dang ok fole fole keko, telesomi, kawin dim alik alik kasi kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa em itol e 600 keko, auk teben em kayow e, mali em guel ding kelei, abiil so kawin so kaloko, ok inkalso mak fuktem da telei, abiil dim emikal ");
INSERT INTO bhl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","suuk inkalso mak mitse kale. Suuk kuw man bom mene tak mene tak belei, mililiw banim taw banim, fu alew ding kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Suuk telse ding kabalak be, Noa so, em muluwel alemsal Sem o, Kam o, Yafet biso, ikalem kalel kumel biso, alik alik kunum waneng bi siw tem unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Unsomeliwi, kut samal so, am samal so, samal teing yan banim so, awon so, mesesem mesesem bel aliw so, alik alik samal bi ");
INSERT INTO bhl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Noa eso, siw tem unsiliw kale. Feinka, samal bi yemkal yemkal kuw keko, siw tem unsiliw kale. Feinka! I Sunbin-Got em Noa elo angse kitil weng beelo kilele gelewsiliw kale. Gelewsomeliwi, Sunbin-Got akalem ete siw em am yal aise kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ailei, fu alew ding kesomelei, ok dang ok fole fole fian be fasuko, siw sel elo daolei, e kawin be koleweko, katiw unko, ");
INSERT INTO bhl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ok fole fole fasu kebe okmun beem dim kel danong danong angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Angeko, ok fian be siw beelo alik gulok gulok uneko, amgu fian sel dim alikum atin kuw kasi kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Kolewsomelei, ok be amgu tikin fian tiakim beelo atin kuw kasi kolewsomelei, katiw katiw uneko, ben kel em mita bakilewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Beem ding dim kabalak e, ok fole fole be am samal bi so, kut samal bi so, awon bi so, samal yan banim teing banim so, kawtiw so, alik alik finik so biliw biilo tom kuyaw kuyaw yese kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Feinka! Ok kut bomi, tiow kawin dim alakabiliw finik so bin eisneng alik alik i atin kuw kuansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Beli, Sunbin-Got e kunum waneng so, am samal so, kut samal so, abiil em awon so, samal yan banim teing banim so, alik alik finik so biliw eisneng biim mongom ete ok tomelei, alik alik ilo kuiaw kuiaw yenei, i kuansiliw kale. Kate, Noa so, akalem siw tem talsiliw samal iso, eso biliw kunum waneng biso, ite kuw kuaninba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Keko beli, ok dang ok fole fole be fian kuw keko, fasuko, belei, 150 ding kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Beli, Yawe e siw beem tem biliw Noa so, kut samal so, am samal so, alik alik biim ibolow fukunse kale. Fukuneko, inim fian mak ok tikin dim kel dabalalei, e ok beelo daking dak dak fong so fong so kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Kelewsomelei, ok fuktem da matem talse ok fian beso, suuk ok fian beso, alik alik be kales angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Keko beli, 150 ding kesomelei, ok singelet singelet kelei, ");
INSERT INTO bhl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ben kel kayow mali em guel ding be danese ding kabalak e, Noa em siw Alalat amgu tikin dim ditse kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ok dang fole fole be iti singelet singelet kesomelei, king kel kayow em emisik ding kabalak e, amgu kang akal kaimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kaimei, iti fu alew ding banimei, Noa e solow tem mak busuko, ");
INSERT INTO bhl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","awon guegnok atew mak dabalase kale. Dabalalei, awon be yambisomelei, kawin e tiow kese ding kabalak e, e teineko, iti telinba kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Keko beli, Noa e ibolow tiaktiak keko, bokolomele: “Ok fole fole be singelet ange sako?”, angesomelei, e awon abim atew mak akal dabalase kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Dabalase kate, awon e “Ok e kawin kasise ki kebe kai!”, angomi, em dim teinomin dim fenbiko, dim banim kelei, iti talse kale. Telei, Noa e akalem teing danong kut elo dako, awon beelo aluweko, iti am dase kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Dako, ding fenbelei, iti ben kel ding banime ding dim bakate, e awon abim atew be iti kut elo dabalase kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Dabalalei, kuinbelei, awon be iti Noa em fukun talse kale. Telei, Noa e atemete: Ais oliw em kon feis mak ning tamoko, de talse kale. De telei, Noa e kilele kal kelete: “Ok e fein singelet angeko, banimse kai!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Keko beli, e iti ben kel ding mak fenbomelei, iti awon abim atew be kut elo dabalase kate, awon be iti telinba kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Beli, Noa em itol e 601 kese itol beem emisik kayow em emisik ding kele ding dim bakate, ok fole fole be singelet del kuw kelei, kawin iti tiow kese kale. Beli, Noa e siw beem tikin am kon fat keleweko, kiineng kelomete: “Ataan e, kawin tiow kele kai!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Angei, auk teben kayow em mali em ketket ding dane ding kabalak e, kawin be fein tiow kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kelei, Yawe e Noa elo bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Kame, ku so, kom muluwel so, kom muluwel im kalel kusel so, alik alik yu siw tem be kolewko, kut unina! ");
INSERT INTO bhl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mesesem mesesem samal biso, awon biso, samal teing yan banim so, alik alik ikati kut unina! Uneko, kawin dim dak koyemew kano, i fukalako, men kaileko, al kelina!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Dangei, Noa yelimeli bi siw be kolewko, kawin dim elo talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Teliwi, mesesem mesesem samal biso, awon biso, samal teing yan banim biso, alik alik bikati siw tem koleweko, kawin dim elo talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Keko beli, Noa e aik ayem mak fakalasomi, samal so, awon so, Sunbin-Got em kiin dim e tokotoko kebiliw samal alik alik im mutuk e makmak makmak kuluko, aik ayem beem dim dukusomi, weing dako, ilo kainbelei, Yawe elo “Weso! Seyo!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Dangei, Yawe e aik ayem beem takfol dong dong deik be kimileweko, “Kamge ati te!”, angeko, bokolomele: “Ne iti kawin be makso nam yakok keli te. Feinka! Kawtiw aul dim telbiko, fasel dim akati, diwkuw diwkuw i wa kukuw beem dulum elote kuw fukunkabiliw kai! Fein! Finik so biliw alik alik biilo iti kaneyemsi emdiw nam keyemi te. ");
INSERT INTO bhl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Kawin dim kaleem baniminba keko, boke ding dim kabalak, wanin kaimin ding so, wanin wanbin ding so, aneng gilil ding so, aneng mamin ding so, am ken am ding so, am suuk so ding so, taw so mililiw so ding so, kaneko ding be nam banime te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Angeko, Sunbin-Got e Noa so, em muluwel iso alik ilo bamki so keyemeko, ilo bokoyemomele: “Aul duku dak duku dak, banso keko, kawin dim kale gek gek kelina! ");
INSERT INTO bhl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mesesem kawin dim samal biso, abiil awon biso, okmun bin em samal biso, alik alik samal bi yom angan fingansomeliwi, ne ilo yom teing dim da koyemi te. ");
INSERT INTO bhl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Sua kel e, ne yulo ais so, ais dem so, mesesem esneng beemdiw koyemeko, “Yom wanin te!”, yangsi kate kame, ne yulo mesesem finik so bin alik alik bi duyemeko, yom wanbin angom dukuyemi te. ");
INSERT INTO bhl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Duyemi kate, samal em kaim e yu kanelom wanbokoliw te! Nimtew angom? Samal im finik e kaim dim kel be kasike. ");
INSERT INTO bhl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Fein! Nimin samal so, kawtiw so, i mali kawtiw ite mak yeniwi, i kuaniw tewe, i kilelbiko, boliwka! Yenokoliw kawtiw biim kaim finik so be busel yemiw tewe, ne kanebiliw biilo yan ilum fian mak duyemoki te! ");
INSERT INTO bhl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ne kunum waneng nakalem atew kilel dukusi kasike, nimin kawtiw ite mak kunum waneng ilo atin kuw yeniwi, i kuaniwe tewe, yeniw kawtiw bikati yeniwi, i kuanoliwka! ");
INSERT INTO bhl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kuanokoliw kate, yukalem e aul duku dak duku dak keko, banso banso kesomi, kawin dim kale, gek yak yak keloliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Yangeko, Sunbin-Got e iti Noa yelimel ilo weng mak bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","“Kame kuw, ne yuso, yom muluwel dow iso, kut samal biso, am samal biso, awon biso, samal teing yan banim biso, alik yuso siw tem kolew teliw finik so biliw biso kitakamin weng mak dukuyemi te. ");
INSERT INTO bhl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Dukuyemi kitakamin weng be kanekote: Ok dang fole fole fian beemdiw makso telesomi, kawin kaem mesesem finik so alik alik bi nam iti yene te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Yangeko, iti weng mak bokoyemomele: “Nem yuso, alik finik so biliw biso, alik alik yulo dukuyemsi kitakamin weng be diwkuw diwkuw nam banimoke te. Kasike kame, ne yuso, yom dow mining alik alik iso, alik alik yulo eisneng mak dukuko, yulo kukuyemite: Nakalem weng kitakamin weng be fein diwkuw diwkuw boke te. ");
INSERT INTO bhl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nem tele kawin dim tele beem mutuk be gawal mak falal keli te. Gawal be yukam dim bomelei, yu elo atemeko, kal keliwete: Nakalem kitakamin weng be akokow keko, nam koli te. ");
INSERT INTO bhl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Yu atemokoliw te! Nem yukam dabalaloki ding dim e, gawal mak yukam dim kel falalemoke te. ");
INSERT INTO bhl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Falalemoke ding dim e, nem yuso, samal iso, dukusi kitakamin weng beelo ibolow fukunbomelii, kilele aluwboki te. Feinka! Ok dang fole fole mak beemdiw iti teleko, mesesem mesesm finik so biliw bi nam banim keyeme te. ");
INSERT INTO bhl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Feinka! Gawal fokole ding dim bakate, ne elo atemeko, kawin dim kaleem finik so biliw eisneng alik alik ilo dukuyemsi kitakamin weng beelo ibolow fukunbomelii, kilel aluwboki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Yangesomelei, e Noa elo bokolewomele: “Kawin dim kaleem finik so biliw alik alik i gawal be atemeko, kilele kal keliwete: Nakalem e kitakamin weng beelo nam akokow keko, koli te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Keko beli, Noa em muluwel alemsal im wiin e kanekote: Mak e Sem e, mak e Kam e, mak e Yafet ete te. Bomelei, Kam e Kenan em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Kawin dim kaleem kunum waneng angom alik alik i Noa em muluwel im mining dow kuw te. ");
INSERT INTO bhl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Keko beli, Noa e wanin musun kaimin kunum kese kasike, e ais wain musun bilal kuw kaimale kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Kaimeko, wain ok kelei, e elo wanenale kale. Deiw mak ding mak, Noa e wain ok fian fian kuw wanesomelei, kiin felfel beit nam kelewei, e akalem ilim gulu koleweko, kal fitew kuw kesomi, akalem samal kal benemin am tem akalbomi, buelemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Buelbelei, Kenan em alew, Noae em min Kam e am matem teleko, alew elo atemete: E kal fitew kuw kesomi, buelbelei, atemse kale. Atemse ki, iti kut uneko, akalem awkunum alew ilo kalan bakayem unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Unei, awkunum kusel alew bi em yangse weng be kiliko, ilim kom mak kulusomi, king dim dukuko, ibiksin ibiksin teleko, alew em anggil fitew beelo ateminba tew keko, alew elo kasi kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Keko beli, alew em iti teinse ding ete, em fukunin e iti dolon kesomi, min Kam kanelewse kukuw wa beem sang kilise kasike, ");
INSERT INTO bhl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","gaaneko, yakok fian mak bokolomele: “Yakok fian mak Kam em min Kenan so, em muluwel dow so ilo keyemo yo! I ikalem awkunum kusel im sak weng afak kunum kebokoliw tako!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Angeko, weng makso mak bokolomele: “Ne Yawe em wiin fian daolewkabi te! E Sem em Sunbin-Got ete te. Kate, Kenan be Sem em sak weng afak kunum keboke te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Yangeko, iti weng makso bokolomele: “Sunbin-Got ku Yafet em kawin bamdako, nengso nengso tiak kelewa! Fein! Yafet e akalem awkunum Sem em am dim kel, diwkuw diwkuw kenabin mak kuluko, teinoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Keko beli, ok dang fole fole ok em banimse ding dim bakate, Noa e iti itol 350 makso bise kasike, ");
INSERT INTO bhl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","em bise itol alik alik bongguko, itol 950 kesomelei, fe e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Sang be Noa em muluwel Sem o, Kam o, Yafet o, im sang te. Ok dang fole fole banimse ding kabalak e, Noa em muluwel alemsal bikati muluwel kailsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet em muluwel im wiin e emisik aul e Gomel, em teben e Magok, Madai, Yawan, Tubal, Mesek, fefe ning ful e Tilas te. ");
INSERT INTO bhl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomel em muluwel im wiin e Askenas, Ilifat, Togalma. ");
INSERT INTO bhl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawan em muluwel im wiin e Elisa so, Talsis so. Em min Kit e Kit aneng fian kasel im kunum mongom kelei, em min Dodan e Dodan aneng fian kasel im kunum mongom kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Keko beli, Yafet em muluwel dow i okmun fian beem beleng so, okgung so, aneng aneng beem kasel kesiliw kale. Kesomeliwi, ikalem angin amen, ikalem weng amen, ikalem abiw aneng amen amen keko, kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kam em muluwel im wiin kanekote: Emisik aul e Kus, em teben e Isiw, Ilibia, Kenan te. ");
INSERT INTO bhl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus em muluwel im wiin e Seba, Kabila, Sawta, Alama, Sawteka. Alama min alew dukulomei, im wiin e “Seba so, Dadan so.” yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus e min makso dukuko, em wiin e “Nimolot”, dangse kale. E kawin dim em emisik kak kunum wiin kitil so kamok kesomi, ");
INSERT INTO bhl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yawe em kiin dim kel samal yemin kunum fian kese kale. Kese kasike, kunum waneng i em wiin daolewko, em sang aneng aneng elo bakam unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimolot be Babilonya aneng fian ka kel abiw mutuk fian mak duku tem duku tem gesomi, im wiin e “Babel, Elek, Akat, Kalne.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Keko beli, Nimolot e Babilonya aneng fian koleweko, Asilia aneng fian kalo unesomi, teleko, ka kel e iti abiw mutuk fian mak duku tem duku tem gese kale. Abiw mutuk fian biim wiin e “Ninibe, Elebototil, Kala, ");
INSERT INTO bhl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Elesen.”, yangse kale. Ninibe abiw mutuk fian koleweko, Kala abiw mutuk fian tele tele biim mutuk dim e e Elesen abiw mutuk fian be gese kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Isiw em muluwel im wiin e “Ilidia, Anam, Elekaw, Nawtu, ");
INSERT INTO bhl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Fatulus, Kasulu, Kilit.”, yangse kale. Kilit e Filistia kunum waneng biim kunum mongom kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenan em muluwel i wiin e kanekote: Emisik min em wiin e Saidon te. Emteben min em wiin e Kit te. ");
INSERT INTO bhl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Muluwel makso im wiin e Yebus so, Amol so, Gilgas so, ");
INSERT INTO bhl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Kibi so, Alka so, Sini so, ");
INSERT INTO bhl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Albat so, Semal so, Kamat so kesiliw kale. Yangmeli bi kawtiw banso biim kunum mongom kesomi, aneng aneng bayemeleko, ka tein ka tein kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Keko beli, Kenan em muluwel dow im abiw mutuk fian duku tem duku tem kesiliw kasike, im aneng fian beem awet e kanekote: Saidon abiw mutuk fian koleweko, falal falal uneko, Galal abiw mutuk fian uneko, Gasa abiw mutuk teleko, Sodom so, Gomola so, abiw mutuk fian alew koleweko, iti falal falal uneko, Adama so, Seboim so abiw mutuk fian alew beelo uneko, Elesa abiw mutuk fian teleko, ka kel ayet kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Keko beli, Kam em muluwel dow ikalem angin amen, ikalem weng amen, ikalem abiw aneng amen amen keko, kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Beli, Noa em emisik min Sem akati muluwel dukuse kale. E Ebel em muluwel dow biim kunum mongom kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem em muluwel im wiin e kanekote: Emisik dil e Elam kelei, emteben e Asul so, Alfaksat so, Ilidia so, Alam so kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Alam em muluwel im wiin e kanekote: Us, Kul, Getel, Mas. ");
INSERT INTO bhl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alfaksat e Sela em alew kese kale. Kesomelei, Sela e Ebel dukuse kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebel e min alew mak dukuse kale. Mak em wiin “Felek”, dangeko, mak em wiin e “Yoktan”, dangse kale. Ebel em Felek dukuse ding kabalak e, kawtiw i amen amen kesomi, ka tein ka tein kesiliw kasike, min beem wiin so kanesiliw so wiin takiyak molewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan em muluwel i kanekote: Almodat, Selew, Kasalmabet, Yela, ");
INSERT INTO bhl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Kadolam, Usal, Dikala, ");
INSERT INTO bhl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO bhl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofil, Kabila, Yobaw te. Aul muluwel banban bi Yoktan em muluwel ite. ");
INSERT INTO bhl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ikalem aneng fian e Mesa abiw mutuk fian kalote uneko, Sefal abiw mutuk fian teleko, ataan tele dulum beem amgu mit mewso kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Keko beli, Sem em muluwel dow ikalem angin amen, ikalem weng amen, ikalem abiw aneng amen amen keko, kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Sang be, kunum mongom Noa beem muluwel alemsal biim mining dow im sang te. Im muluwel dow alik alik i ikalem angin amen amen kesomi, ikalem kawin aneng amen amen kuluko, ka tein ka tein kesomeliwi, kawin fe abiil fe alik alik be geksiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sua e, kawin dim kaleem kunum waneng alik alik i bomelei, weng makmak kuw bakamaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Beli, bomeliwi, i ataan tele dulum elote unsomi, Babilonya aneng fian kel bamda dim aneng fian mak elo telesomi, ka kel teinsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Teinsomeliwi, i bokolomeliw: “Kae! Kame, nu kawin mak ais fuko, em kitil e tum emdiw kele ding kabalak e, nu tum be kuluko, tum kun am inkalso, tiaktiak mak geluma!”, angsiliw kale. Angeko, fein, i tum be kuluko, beem dim kawin dim em eisneng ais gom atew dukusomi, am ki dum ki kelewko, tum fatmo fatmo kelew kelew keko, am tiak tiak mak gesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Gemsomeliwi, i bokolomeliw: “Kame, nu nukalem abiw mutuk fian mak geluma! Abiw mutuk fian kaleem am aliam mak tiaktiak kuw geluma! Am beem kak e abiil atin mutuk mutuk daluw kano, kawtiw i atemeko, nulo wiin fian mak duyemokoliw te! Kanelom mesik esik, nu amen amen keko, aneng aneng ka tein ka tein kelokoluw kasike!”, angsiliw kale. Angeko, fein i am aliam tiakim gem kawtem unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Gem kawtem unsomeliwi, Yawe e abiil tikin kolew teleko, kawtiw biim abiw mutuk fian so, im am aliam gesiliw beso, atemeko, ");
INSERT INTO bhl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","bokolomele: “Fein! Kunum waneng bi bongguko, kawtiw angin makmak kuw kesomi, ibolow ki, weng ki makmak kuw kesomeliwi, aluwbamin fian be aluwkabiliw te. Kame, ikalem ibolow kuw kanelew unbiliwi, i ki keko, aluwbamin alik alik fein kelokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kame, nu dak uneko, ikalem weng makmak kebiliw be an wakal amen kuw amen kuw keyemuw kano, i kanelom weng kililew kililew kemokoliw te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Angeko, Yawe e kawtiw ka biliw alik alik biilo an wakal dolo dolo aneng aneng angom kalo kalo ke koyemse kale. Koyemei, i am aliam tiakim be geko, akiminba kesomi, kolew unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Uneko, kunum waneng kawtiw bi abiw mutuk fian beem wiin e “Babel!”, angsiliw kale. Nimtew angom? Ka kel e, Yawe e kawtiw im weng bangbang koyemei, i an wakal keko, kawin dim kaleem aneng aneng angom dolo dolo kalo kalo uneko, amen amen kuw kesiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Kale Sem em muluwel dow im sang te. Ok dang fole fole be banimeko, itol alew ale ding kabalak e, Sem em itol 100 kelei, e Alewsakat dukuse kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Dukusomi, itol 500 alei, iti kunum aul duku, waneng aul duku, kailsomi, fe, kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alewsakat em itol e 35 kelei, e Sela dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Kesomi, itol 403 alei, iti kunum aul duku, waneng aul duku, kailsomi, fe, kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela em itol e 30 kelei, e Ebel dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Kesomi, itol 403 alei, iti kunum aul duku, waneng aul duku, kailsomi, fe, kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebel em itol e 34 kelei, e Felek dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Kesomi, itol 430 alei, iti kunum aul duku, waneng aul duku, kailsomi, fe, kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Felek em itol e 30 kelei, e Eleku dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Kesomi, itol 209 alei, iti kunum aul duku, waneng aul duku, kailsomi, fe, kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Eleku em itol e 32 kelei, Seluk dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Kesomi, itol 207 alei, iti kunum aul duku, waneng aul duku, kailsomi, fe, kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seluk em itol e 30 kelei, Nakol dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Kesomi, itol 200 alei, iti kunum aul duku, waneng aul duku, kailsomi, fe, kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nakol em itol e 29 kelei, Tela dukuko, em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Kesomi, itol 119 alei, iti kunum aul duku, waneng aul duku, kailsomi, fe, kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tela em itol e 70 kelei, Abalam so, Nakol so, Kalan so, dukuko, im alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Sang be Tela em talfut kelewse sang te. Tela e alemsal muluwel dukuko, im wiin e “Abalam, Nakol, Kalan”, yangse kale. Kalan e, Olot em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Keko beli, Tela yelimel im Kaldia aneng fian em abiw mutuk fian Ul ka teinsiliw em ding dim e, Tela em min Kalan be kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Kuaneko beli, Abalam so Nakol so aso i waneng kulusiliw kale. Abalam e Salai kuluei, Nakol e akalem neng Milka kuluse kale. Milka so, Yiska so, uso i Kalan em muluw alew te. ");
INSERT INTO bhl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Kate, Abalam em kalel Salai u kumun du kelomi, aul banimsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Deiw mak ding mak, alew Tela e akalem muluwel Abalam so, kuanse kunum Kalan em min Olot so, Abalam em kalel Salai so, alik alik biilo bonggu koyemsomi, “Kenan aneng fian elo unuma o!”, yangse kale. Yangei, i Kaldia aneng fian em abiw mutuk fian Ul be koleweko, Kenan aneng fian elo unomin unsiliw kate, Kalan abiw mutuk fian ka kel kosiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Keko beli, i Kalan aneng fian kel bomeliwi, Tela em itol e 205 kelewei, fe, e ka kel kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Deiw mak ding mak e, Yawe e Abalam elo bokolewomele: “Ku kukalem kawin so, angin so, kawkunum kusel so, alik alik biilo koyemeko, kukukemoki aneng kikis mak kalo una! ");
INSERT INTO bhl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Kom wiin e fian kekemsomi, kulo bamki so kekemeko, angin banban kekemoki te. Kekemsomelii, ku mali kawtiw im bamki kulamin beem mongom kebokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nimin kawtiw ite mak kulo bamki so kekembiw tewe, nakati ilo bamki so keyemboki te. Kesomelii, nimin kawtiw ite mak kulo yakok kekembiw tewe, nakati ilo yakok keyemboki te. Keko beli, kawin dim kaleem kunum waneng alik alik i nem dukembi bamki beem dulum elote ikati bamki so kelokoliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Dangei, Abalam e Yawe em weng be kiliko, eso, akalem ning em min Olot so, yelimel alik alik bi Kalan aneng mutuk fian koleweko, unsiliw kale. Unsiliw ding kabalak e, Abalam em itol e 75 kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Keko beli, Abalam so, em kalel Salai uso, ning em min Olot eso, yelimel alik alik bi ikalem mesesem mesesem eisneng alik alik be kuluko, Kalan aneng fian ilo wesiliw kunum waneng ilo “Alikum makuw boma!”, yangeko, fein, alikum i Kalan aneng fian be koleweko, Kenan aneng fian elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Uneko, Kenan aneng fian kel kakabomi, Sekem abiw mutuk fian elo talsiliw kale. Abiw mutuk fian beem mit mewso ka kel e Mole em ais ayem ke alenale kale. Aneng kaem biliw kawtiw i Kenan kasel ite te. ");
INSERT INTO bhl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Keko beli, Yawe e teleko, Abalam elo bokolewomele: “Ne aneng fian kale kuso, kom muluwel dow iso atin kuw yulo duyemoki te.”, dangse kale. Dangei, Abalam e tum so tele tele kelewsomi, Yawe elo aik ayem mak gelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Geleweko, Betel abiw mutuk fian em ataan tele dulum beem amgu so aneng elo uneko, Betel so, Ai so, abiw mutuk fian alew biim mutuk e akalem samal kal benemin am mak bamuk keko, dukuse kale. Dukusomeli, e iti aik ayem mak dukuko, Yawe em wiin fian dawsulse kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Dawsulsomelei, yemkal bi iti aneng be koleweko, unbomeliwi, ikalem samal kal benemin am be bamuk keko, dukusomi, iti dakasomeliwi, telbi telbisomi, fe e, Negew aneng fian teleko, ka teinsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Beli, deiw mak ding mak, olfut fian mak kese kasike, Abalam yelimel alik alik uneko, Isiw aneng fian elo kakin unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Unsomeliwi, Isiw aneng beem mewso talsiw ding dim bakate, Abalam e akalem kalel Salai ulo bokoumomele: “Ku waneng minggibi butbi waneng atite ");
INSERT INTO bhl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","kasike, Isiw aneng fian em kunum i kulo katemomeliwi, ibolow kekemsomi, ikalem ete bokolomeliw: ‘U kunum beem kalel ute te!’, ange ange kesomi, nelo neneko, kulo kamdokoliw sako! ");
INSERT INTO bhl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kasike, ‘Ne kunum beem neng nete te!’, yangolewka! Yangew tewe, i nelo ken kukuw kuw kukunemeko, neniwi, ne nam kuani te.”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Wangei, im Isiw aneng fian talsiliw ding dim bakate, Isiw aneng fian em kunum i Abalam em kalel minggi bi butbi waneng atite watemomeliwi, ");
INSERT INTO bhl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ikalem aneng fian em emisik kamok beelo weng kal dulewiwi, e ulo akalem am sel elo wamde talse kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Wamde teleko, “Salai ulo kalfongumo yo!”, angeko, Abalam elo siwsiw so, bulmakao so, donki imok so, weng afak kunum waneng so, donki yanggus so, kamel so, samal banban be Salai um kalik dulewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Dulewse kate, Isiw aneng fian beem emisik kamok em Salai um dulum kaneumse beem mongom ete Yawe e Isiw aneng fian beem emisik kamok so, akalem angin so, alik alik ilo wakamin fian mak duyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Keko beli, emisik kamok be Abalam elo gaaneko, bokolewomele: “Abalam a! Ku tala o!”, dangei, e telei, esik elo bokolewomele: “Nimtew angom ete ku nelo kukuw wa kukunembelew a? Nimtew angom ete ku nelo funum funum kenemeko, ‘Salai u nakalem kalel ute te!’, nanginba kebelew a? ");
INSERT INTO bhl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nimtew angom ete ku ‘U nakalem neng te.’, nanginba keselew kasike, ne ulo wamdubi a? Kame ku kilila! Fongate akate kom kalel buulo kulusomi, aneng fian kale kolew una!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Dangeko, Isiw aneng em emisik kamok be akalem kunum kamok kamok biliw ilo bokoyemomele: “Yu Abalam so, akalem kalel so, ikalem mesesem mesesem eisneng be so, alik alik be bongguko, ‘Eso de unina!’, dangoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Beli, Abalam so, akalem kalel so, ikalem mesesem mesesem eisneng so, Olot so, alik alik i Isiw aneng fian koleweko, iti Negew aneng fian elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Im unsiliw ding bakate, Abalam e wiin so, on kisol fian kunum ke alenale kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Bomelei, e Kenan aneng be iti boku angeko, akalem samal kal benemin am be bamuk keko, dukuko, telbi telbisomi, suaem teinse dim Betel so, Ai so, abiw mutuk fian alew biim mutuk tele tele dim ka kel iti teinse kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Teinsomelei, suaem aik ayem fakalase dim kel iti Yawe em wiin fian dawsulse kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Keko beli, kunum Abalam so kakamele kunum Olot bakati emso kunum kesomi, siwsiw so, bulmakao so, sak weng afak kunum waneng demdem so, yemde unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Yemde unesomelei, aneng be samal so, kawtiw so, geksiliw kale. Nimtew angom? Abalam so, Olot so, aso i wiin so kesomi, mesesem mesesem eisneng banban demdem aluwsiliw kunun alew kesiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kesomeliwi, Abalam em siwsiw yetebin kunum so, Olot em siwsiw yetebin kunum so aneng sukumko, gekomeliwi, i ane ane keko, gansiliw kale. Gansiliw ding kabalak e, Kenan so Feles so aso im muluwel dow i aneng ka kel alenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Keko beli, Abalam e Olot elo bokolewomele: “Kaso nu nukalem kaim anung akate kasike, kaso nukalem yetebin kunum waneng i kanelom kaisuw keko, ane ane kesomi, ganbokoliw te! ");
INSERT INTO bhl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Aneng kale fian sel kasike, kaso nu amen amen keluma! Ku aneng be diw atemeko, awan teing dulum elo kelew tewe, nesik yuk teing dulum elo keloki te. Kate, ku yuk teing dulum elo kelew tewe, nesik awan teng dulum elo keli te.”, dangeko, weng kitokosiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tokosomeliwi, Olot e Yoldan bang beleng beem dulum be Soal abiw mutuk fian beem aneng bit ken dulum beelo atemeko, “Aneng ati te! Okweit so aneng kebe kai!”, angse kale. Nimtew angom? Atemse aneng be Isiw aneng fian emdiw kesomi, Yawe em kaise Iden musun akate tew aneng weit ete kese kasike. Beem ding dim kabalak e, Yawe e Sodom so Gomola so, aneng ka alenaliw abiw mutuk fian alew beelo banim kelinba kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Keko beli, Olot e Yoldan bang beem beleng bit aneng beelo atem ibolow keleweko, “Kalo unoki kai!”, angeko, Abalam elo kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Kolewsomelei, e bit aneng be kakabomelei, Sodom abiw mutuk fian elo unsomi, ka kel akalem samal kal benemin am be geko, teinse kale. Teinse kate, Abalam e Kenan aneng fian kel teineko, kakamale kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Kate, Sodom abiw mutuk fian em kasel i Yawe em kiin dim e ibolow sili sili nam so, ibolow teng so kawtiw kuw kemaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Olot em Abalam elo kolewse ding dim kabalak e, Yawe e Abalam elo bokolewomele: “Kutaka! Ku kanelom ibolow tiaktiak kemokolew te! Aneng ataan tele dim so, aneng ataan tem une dim so, aneng ataan benggew benggew alew so alik alik kalo atema! ");
INSERT INTO bhl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Atebelew aneng alik alik be, ne kuso, kukalem muluwel dow so alik yulo atin kuw duyemoki te. ");
INSERT INTO bhl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ne kukalem muluwel dow ilo bamki so keyemoki kasike, i geksomi, banban kuw kesomi, ok dilin atew kelokoliw te. Feinka! kawtiw i ki keko, kom muluwel dow im fufu e nam teing bokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kame kutaka! Ku moko, aneng alik alik kale kakamolewka! Nimtew angom? Aneng alik alik be kulo dukembi kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Dangei, Abalam e em angse weng be wosuk, unse kale. Unsomelei, anfel e, e Kebolon abiw mutuk fian mit mewso teleko, Mamele em ais tem kel akalem samal kal benemin am be dukuse kale. Dukusomelei, Abalam e Yawe elo iti aik ayem mak fakalase kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Deiw mak ding mak e, ketket teben kel kamokim mak, teingabi kel kamok iso, ganomin kesiliw kale. Kamok biim wiin e kanekote: Mak e Amalafel te. E Babilonya abiw mutuk fian em kamok te. Mak e Aliok te. E Elasal abiw mutuk fian em kamok te. Mak e Kedolamoel te. E Elam abiw mutuk fian em kamok te. Iti mak e Tidal te. E Goim abiw mutuk fian em kamok te. Kamokim bikal bonggusomi, “Ganum!”, angomi, memen kesiliw kale. Biimdiw, Bela, Sodom abiw mutuk fian em kamok so, Bilsa, Gomola abiw mutuk fian em kamok eso, Sinaw, Atma abiw mutuk fian em kamok eso, Semebel, Seboim abiw mutuk fian em kamok eso, Soal, Bela abiw mutuk fian em kamok eso, alik alik kamokim bikati bongguko, mali kamok biso ganomin memen kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Keko beli, Sidim aneng memget ka kel e, ketketeben kamok alik bi bonggusomi, teingabi kel kamok bikati bonggusomi, alik i ow kalat kesomeliwi, ganomin memen kesiliw kale. Beem ding dim e, aneng ka em okmun be yol so ok kelinba ke alenale kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Sua e, kalun kel itol kelei, kamok banban mak Kedolamoel em afak kesomi, on kisol yan dulewsiliw kale. Kate kame, kiin kel em itol kese ding dim bakate, i elo on kisol dulomin yan kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kolewsomeliwi, mutum kel itol be, Kedolamoel so akalem akunum kamok iso teleko, mali kamokim biilo yen kuiaw banim keyemsiliw kale. Kuiaw banim keyemsiliw kawtiw biim wiin e kanekote: Mak e Elefaim angin ite te. I angin biilo Astelot-Kelnaim abiw mutuk kel kuiaw banim keyemsiliw kale. Mak e Sus angin ite te. I angin biilo Kam abiw mutuk kel kuiaw banim kesiliw kale. Iti mak e Emim angin ite te. I angin biilo bit aneng, Kiliataim abiw mewso kel kuiaw banim keyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Mak e, Kol angin ite te. I angin biilo Sial amgu beem dim kel kuiaw banim keyemsomi, ilo yenbakalasomi, uneko, abiw mutuk fian em wiin e Elfalan, kawtiw banim dim mewso kalo keyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Keyemsomi, famdes teleko, Enmisfat (em wiin mak e Kades) abiw mutuk fian elo unesomi, Amalek angin im aneng so, Amol angin Kasason Tamal abiw mutuk fian teinsiliw kawtiw biilo alik alik kuiaw banim keyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Keko beli, teingabi kel abiw mutuk fian Sodom so, Gomola so, Atma so, Seboim so, Bela so (Bela beem kamok em wiin e Saol te), abiw mutuk fian biim kamokim alik alik i teleko, Sidim memget kel ow kalat kesomi, maka iso ganomin memen kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kesiliw kasike, teingabi kel abiw abiw biim kamokim bi, ketket teben abiw biim kamok biso, “Ganum!”, angomi, memen kesiliw kale. Teingabi kel abiw biim kamok biim wiin e kanekote: Mak e Elam aneng em kamok Kedolamoel te. Mak e Goim abiw mutuk fian em kamok Tidal te. Mak e Babilonya abiw mutuk fian em kamok Amalafel te. kelei, fefe e, Elasal abiw mutuk fian em kamok Aliok ete te. ");
INSERT INTO bhl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Keko beli, alik alik bi ganesomeliwi, abiw mutuk fian alew Sodom so Gomola so biim kamok i beit kesomi, im kitil e dang banim kesiliw kale. Kesiliw kasike, i fon unesomeliwi, mali mak i Sidim memget kalo unesomi, aneng ka beem kawin fukilit diwgulot tem tem mit mit unesomi, mali mak Suda aneng fian em amgu mit elo fon unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Keko beli, ketket teben kamok bi Sodom abiw mutuk fian so, Gomola abiw mutuk fian so, kalo unesomi, abiw mutuk fian biim on kisol so, wanin so, alik alik beelo dakulu kuluko, unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Unsomeliwi, i Sodom abiw mutuk fian beem mit mewso alenale kunum Olot beso, akalem mesesem mesesem eisneng so, alik alik kuluko, Sodom abiw mutuk fian kolewko, de unsiliw kale. Olot be Abalam em ning em min ete te. ");
INSERT INTO bhl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Beli, maka am fon unse kunum mak Abalam em fukun uneko, elo gansiliw sang be bokolewse kale. Bokolewse ding dim be, Abalam e Amol angin kunum em wiin e Mamele akalem ais tem kuw ninit angse dim be teinse kale. Mamele e Eskol so Anel so aso im awkunum te. Kunum alemsal bi Abalam em ken kunum alenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Keko beli, Abalam e fon talse kunum beem weng kal kililomete: “Maka i akalem ning em min Olot so, akalem muluwel so, alik alik ilo yemde unbiliw kai!”, dangse weng be kilisomi, akalem 318 anggiw koyemse kunum ilo gaayemse kale. Kunum biim auk alew kusel i Abalam em weng afak kunum waneng kesomi, muluwel biilo kaisiliw kale. Kunum bi kitil kesomi, on balam wonuk so kunum kebomeliwi, maka biilo yenggelew unsomi, Dan abiw mutuk fian elo unsilw kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ka telesomeliwi, mililiw tem kese ding kabalak e, Abalam e akalem wonuk so kunum biso maka biilo ow falal keyemsomi, iso ganeko, maka ilo kuiaw banim keyemsiliw kale. Keyemiwi, ketket teben kamok biim angin bi fon uniwi, i ilo yenggelew yenggelew uneko, Damaskus abiw mutuk fian teleko, abiw beelo bakileweko, Koba abiw mutuk fian mewso kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Uniwi, Abalam e iti teleko, teingabi kel kamok im mesesem mesesem so, aul waneng so, em ning em min Olot so, akalem mesesem mesesem eisneng so, alik alik eisneng be iti yemde talse kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abalam em Kedolamoel so, akalem ken kunum kamok iso, alik alik ilo kuiaw banim keyemeko, iti talse ding kabalak e, Melkisedek Sodom abiw mutuk fian em kamok e Sawe memget elo Abalam em fukun talse kale. Sawe beem wiin mak e “Kamok im Memget” te. ");
INSERT INTO bhl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Beli, Melkisedek be katiw alakabe Sunbin-Got em am yol em kunum ayem kese kale. E belet wanin so, wain ok so, de teleko, Abalam em fukun talse kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Teleko, Abalam elo bamki so weng mak duleweko, bokolewomele: “Katiw alakabe abiil so kawin so talfut kilkese Sunbin-Got be kulo bamki so kekemboke te! ");
INSERT INTO bhl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Feinka! Katiw alakabe Sunbin-Got be kulo dokokemse kasike, ku kukalem maka ilo kuiaw banim keyemselew te. Em wiin fian doluma!”, dangse kale. Dangei, Abalam e akalem mesesem mesesem eisneng alik alik be anung anung keleweko, anung king kel kelewsomi, anung makmak beelo Melkisedek elo sak kuw dulewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Keko beli, Sodom abiw mutuk fian beem kamok e Abalam elo bokolewomele: “Kuluselew mesesem mesesem eisneng alik alik be kukalem kuw kate, yemde telselew kunum waneng biilo koyemew kano, i nakalem mit tololiwka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Dangsomelei, Abalam e Sodom abiw fian em kamok beelo yan weng be bokolewomele: “Katiw alakabe, kawin so abiil so alik alik be dukuse Yawe Sunbin-Got beem kiin dim e ayem fawtuk weng mak fein bokokemite: ");
INSERT INTO bhl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ne kom mesesem mesesem eisneng gel so mak nam kulu kemi te. Mesik esik ku bokonemomelew: ‘Nete kuw Abalam elo on kisol so kunum keli te!’, nangokolew sako! ");
INSERT INTO bhl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Feinka! Mesesem eisneng gel mak atin kuw nam kuli te. Kate, nakalem ganbiliw kunum biim wanin eisneng wansiliw eisneng so, nakalem nakunum alemsal Anel so, Eskol so, Mamele so, alemsal biim yan atew anung beso, bete kuw kulokoluw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Beli, Yawe e Abalam elo kiin dem sin weng mak duleweko, bokolewomele: “Abalam, ku finganemokolew te! Nakalem ete kom askom emdiw kebomi, on kisol so kamok wiin so kekemoki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Dangei, Abalam e yan weng mak bokolewomele: “Yakae! Nem Sunbin-Got Yawe kutaka! Nimtew eisneng mak dunemokolew a? Ne dow so banim keko, kuanoki te. Kuanoki ding dim kabalak e, nem kak aluwbamin kunum Damaskus abiw mutuk fian kunum Eliesel e nem mesesem mesesem eisneng alik alik be kuloke te. ");
INSERT INTO bhl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Feinka! Ku nelo aul mak duneminba keselew kasike, nem aluwbamin kunum kale nem mesesem mesesem eisneng alik alik be kuloke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Dangei, Yawe e Abalam elo iti bokolewomele: “Aluwbamin kunum be kom mesesem alik be nam kule te. Kate, kom kulokolew kunum aul ete kuw kukalem mesesem mesesem eisneng alik alik be fein kuloke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Dangesomi, Abalam elo kut elo debeleko, iti weng mak bokolewomele: “Ku abiil katiw elo atema! Atemeko, fial demdem biliw biilo teing bokola! Kate, ku ki keko, nam teing bokolew te.”, dangesomi, iti bokolewomele: “Kom muluwel dow e banban fial demdem beemdiw keloke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Dangei, Abalam e Yawe em weng be kiliko, “Fein!”, dangse kasike, beem mongom esik bokolomele: “E kiol kuw kunum te!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Angeko, iti weng makso bokolewomele: “Nakalem ete Yawe te. Kom Kaldia aneng fian em abiw mutuk fian Ul ka biselew ding dim kabalak, ne kulo gaakemii, ku aneng ka koleweko, aneng kaleelo talsew kasike, talselew aneng kale kukalem kawin aneng kebokole te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Dangse kate, Abalam e bokolewomele: “Yawe, nem Sunbin-Got kutaka! Nomin eisneng mak ne atemeko, kal kelite: Feinka! Be nem aneng kebe kai?”, angeko, kal keloki a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Dangei, Sunbin-Got e yan weng bokolewomele: “Samal angse angom bi de tala! Samal mak e bulmakao yanggus mak um itol e yemamas kel e, mak e meme yanggus mak, um itol e yemamas kel e, mak e siwsiw imok mak em itol e yemamas kel e, fefe e, awon abim atew alew mak de tala!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Dangei, Abalam e samal samal angom bi kuluko, Yawe em mit de telesomi, samal biilo ki kis kalat ki kis kalat mali mali keyem keyemeko, ilo mali mak da, mali mak da keyemeko, dukuse kale. Kate, awon alew biilo ki kis kalat keyeminba kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kesomelei, awon fian, bukol salman atew teleko, samal wanomin kebiliw kate, Abalam e ilo yenbakalase kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Yenbakalasomelei, ataan tem unomin dim kabalak e, Abalam elo kiin ok ilum kuanin atew mak kelewei, e akalsomelei, finganin fian mak dulewse kutiliw mililbi fian mak elo kasi kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kolewomelei, Sunbin-Got e Abalam elo bokolewomele: “Weng kal fein mak dukemite: Kom muluwel dow i nanew aneng elo uneko, ka kel mali kawtiw im sak weng afak kunum waneng kebomi, ilum fian mak kulokoliw te. Kulubiliwi, ka e itol 400 mak aloke te. ");
INSERT INTO bhl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Aloke kate, nakati ilum duyemokoliw kawtiw biilo yan wa mak duyemi, i kom muluwel dow ilo on kisol so kunum waneng kelokoliw te. Keko beli, i aneng beelo kolewko, iti aneng kale kel tolokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Tolokoliw kate, kukalem ete kale kel faselsomi, itol banso kesomi, ken abin kuw kakabelew ki, fe e, kuanokolew te. Kuasomi, kawalik kumel iso bokolew te. Feinka! Kom muluwel i kulo kamkulokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ku kilele kilila! Kame, Amol kawtiw i aneng kale kel teinbiliw kate, im ibolow sili sili nam kekabiliw kukuw e atin kuw fian kelinba kebe kasike, ne im kanelokoliw ding fenbi te. Fenbomelii, kom muluwel biim ketket teben kel dow keloke ding dim bakate, kom muluwel dow im kal anggil ilum kulukabiliw aneng beelo koleweko, iti aneng kaleelo tolokoliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Dangesomelei, ataan tem uneko, kutiliw kese dim e, Abalam e atemete: Alew eisneng mak akalem samal kilit kalat kelewsomi, dukuse dim beem mutuk uniwi, atemse kale. Mak eisneng be deik minkabe ais kal emdiw eisneng kelei, mak e ais dong so yongom dong atew mak kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Kanese beem ding kabalak e, Yawe e Abalam so kitakamin weng kitil mak dukuko, bokolewomele: “Aneng ka belew em ayet dukukembi be kanekote: Ok bang em wiin e Isiw Bang koleweko, uneko, ok bang fian sel, em wiin e Yufeletis teleko, beem ayet tele tele dim be, kukalem muluwel dow ilo duyemii, i ka kel fukulako, teinokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kate kame, aneng be nanew kawtiw im kawin kese te. Aneng kasel im wiin e kanekote: Kin e, Kenas e, Katmon e, ");
INSERT INTO bhl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Kit e, Feles e, Elefaim e, ");
INSERT INTO bhl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amol e, Kenan e, Gilgas e, Yebus ete te. Alik alik kunum mongom bi aneng angom kaleem aneng kasel ite te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Beli, Abalam e Kenan aneng fian ka belei, king kel itol ase kate, em kalel Salai u kumun du kebomi, aul banim kesu kale. Kesu kasike, Salai u ukalem weng afak waneng Kagal ukalem imok Abalam elo duleweko, bokolewomelu: “Afam waneng kalu kula!”, dangsu kale. Nimtew angom? U Abalam elo bokolewomelu: “Yawe e nelo aul banim fium kenemse kasike, ku nem weng afak waneng kalu kuluko, aul duumew kano, ne beem deiw ete aul mak kuloki te!”, dangsu kasike. Kagal bu Isiw aneng fian beem waneng ke alenalu kale. Keko beli, Abalam e akalem kalel Salai um dangsu weng be kiliko, fein gelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Gelewsomelei, Abalam e Kagal ulo fein aul duumse kale. Duumei, Kagal u Salai um wiin e kalak da koumsu kasike, ");
INSERT INTO bhl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Salai u uneko, imok Abalam elo bokolewomelu: “Kukalem sen ete! Nakalem ete nem weng afak waneng kalu dukemsi kate kame, um aul kumun so kebu ding dim e, u nelo de mit da konembu kasike. Feinka! Yawe e kom tele nem tele num ilum be diw ateyemoke tako!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Dangui, Abalam e ulo yan weng mak bokoumomele: “Kom weng afak waneng nelo dunemselew kate, ku ukalem watebin waneng kebelew kasike, kom ibolow fukunin kuw geleweko, ilo beemdiw keuma!”, wangse kale. Wangei, Salai u em wangse weng be kiliko, Kagal ulo ilum fian mak duumsu kasike, Kagal u bukibuki fon unsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Fon unsomelui, Kagal u Sul aneng unomin deiw gui uneko, aneng ais banim, kawtiw banim dim kel teleko, ka kel ok miktem mak beem mit talsu kale. Talsomelui, Yawe em Dabalakamin Finik e ulo watemeko, ");
INSERT INTO bhl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","bokoumomele: “Salai um weng afak waneng Kagal kutaka! Nal ete teleko, nal unbelew a?”, wangse kale. Wangei, u yan weng mak bokolewomelu: “Nelo netebu waneng Salai ulo koumeko, fon talbi te.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Dangui, Yawe em Dabalakamin Finik be bokoumomele: “Ku iti Salai buum mit mewso uneko, menew kuw falit angeko, ukalem afak kuw bolewka!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Wangeko, Yawe em Dabalakamin Finik be iti weng makso bokoumomele: “Kom muluwel dow banso kelokoliw te. Ku ki keko, im fu e nam teing bokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Sukum ding mak kelei, kunum aul mak dukulokolew te. Aul beem wiin e Ismael dangolewka! Be, nimtew angom? Yawe e kom amemin kiliko, kom ilum be atemeko, e kulo dokokeme kasike. ");
INSERT INTO bhl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Aul be kut samal emdiw kesomi, akalem ibolow kuw gelewko, kakamoke te. Kakabomelei, em muluwel dow ikal amen, mali kawtiw ikal amen kebomeliwi, akalem nenggelel biim muluwel dow bikati maka kelew kelew kemokoliw te.”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Wangei, Kagal u Yawe em wiin e bokolomelu: “Kom wiin e ‘Eloloi’ te. Nimtew angom, nelo neteme Kamok Fian atemsi kasike!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Dangsu beem mongom ete kawtiw i miktem beem wiin e “Belokiloi!”, dangsiliw kale. Ok miktem be Kades abiw mutuk fian tele, Belet abiw mutuk fian tele, abiw mutuk fian alew biim mutuk kel alenale kale. ");
INSERT INTO bhl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Keko beli, afam waneng Kagal um kunum aul dukusu ding kabalak e, Abalam e aul beem wiin e “Ismael!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Be em ding be, Abalam em itol e 86 kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Beli, Abalam em itol e 99 kele ding dim bakate, Yawe e teleko, Abalam elo weng mak bokolewomele: “Nem wiin e Elsadai te! Ku nem weng afak keko, kakabomelewi, nem kiin dim kel kiol kuw kukuw gelewemolewka! ");
INSERT INTO bhl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Gelewsomelewi, kuso kitakamin weng fian mak dukuko, kom muluwel dow ilo banso tulun tulun kuw keyemoki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Dangei, Abalam e katin bukbuk angeko, gatak wakas kese kale. Kelei, Sunbin-Got e iti weng makso bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Kuso dukukabi kitakamin weng be kanekote: Kawtiw banban im kunum mongom kekemi ");
INSERT INTO bhl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","kasike, kom wiin e Abalam be koleweko, wiin kikis Abalakam kangi te. Nimtew angom? Kulo kunum mongom angom banso im alew kekemi kasike. ");
INSERT INTO bhl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ne kulo bamki fian so kekemii, kom muluwel dow i banso tulun tulun kuw keko, fokokoliw te. Fokosomeliwi, im dim e emisik kamok fian mali mak ikal molokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kuso amkoko, duku kemi sunsun kitakamin weng be nam banime te. Kom muluwel dow so, im dukudak dukudak kelokoliw kawtiw biso, kitakamin weng be kait diwkuw diwkuw belei, awet keko, nam banime te. Feinka! Nakalem ete kuso, kom muluwel dow iso, alik alik yom Sunbin-Got nete te. ");
INSERT INTO bhl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kame kilele kilila! Ku kakow kunum keko, Kenan kawtiw im aneng kakabelew kate, aneng kale ku so, kukalem muluwel dow iso, alik alik yulo diwkuw diwkuw fein kuw yukalem duyemoki te. Duyemsomi, alik yom Sunbin-Got kebi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Dangeko, iti weng makso bokolewomele: “Ku so, kom muluwel dow iso, alik alik yom dulum akati kitakamin weng beem anung mak duyembi te. Yu elo wangweng keleweko, kilele gelewemoliwka! ");
INSERT INTO bhl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","11","Yom dulum duyembi kitakamin weng beem anung e kanekote: Yu kunum alik alik im kal e okiloliwka! Okilew kemin beem mongom ete neso yuso alik alik nu kilele kal keluwete: Neso yuso tele tele beem dim e kitakamin weng be kait diwkuw diwkuw boke te. ");
INSERT INTO bhl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Kitil weng be kunum angom alik alik im dulum bakayembi te. Kunum aul dukului, em duan kel ding kele ding dim bakate, yu im kal okiyem kemoliwka! Kom muluwel dow dukudak dukudak kebomi, bokoliw ding dim bakate, alik alik biilo kaneko kukuw kuw keyemboliwka! Yukalem weng afak kunum ikal, weyembiliw kunum ikal, yukalem weng afak waneng im kunum aul ikal, alik alik yom dim biliw kunum angom biim kal bakal okilew keyemboliwka! Kebiliw kawtiw bi fein nem sunsun kuw boke kitakamin weng beem afak kawtiw kebiliw ite te. ");
INSERT INTO bhl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kate, nimin kunum ite mak kal okilinba keliw tewe, kunum bi nem kitakamin weng beelo sakalaw keko, weng bo bo keliw kasike, yu ilo takala deng ibiku koyem kemina! Nimtew angom? I nem kitakamin weng ayem beelo gelewinba kebiliw kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dangeko, Sunbin-Got e Abalakam elo weng makso mak bokolewomele: “Kom kalel um wiin Salai kame koleko, um wiin kikis e Sala wanga! ");
INSERT INTO bhl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nimtew angom? Ne ulo bamki so keumi kasike. Feinka! U kunum aul mak dukului, e kawtiw fian mak em kunum mongom keloke te. Em mulkis mali mak i wiin so emisik kamok fian kelokoliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Dangeko, Abalakam e kawin dim dak katin bukbuk gatak wakas angese kate, abenggise kale. Nimtew angom? E ibolow fukunomele: “Nem itol e 100 kese kasike, aul mak nam kaili te! Sala ukal fasel kesomi, um itol e 90 kese kasike, u ki keko, aul mak nam dukuloku kai!”, angse kasike. ");
INSERT INTO bhl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Angeko, Sunbin-Got elo yan weng bokolewomele: “Kom nangew weng be ken kate, ku Ismael elo kuw ken ati kukuw kelewbolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Dangse kate, Sunbin-Got e yan weng bokolewomele: “Bayo! ‘Sala u kunum aul mak duku kemoku te.’, kangi weng be fein weng te. Kunum aul beem wiin e Aisak dangolewka! Feinka! Eso, akalem muluwel dow iso, kangsi kitakamin weng be dukusomi, diwkuw diwkuw ibolow fukunboki te. ");
INSERT INTO bhl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Kate Ismael beem dulum elote nangew weng bakati kiliko, ibolow fukunbi te. Ne elo bamki kelewii, em muluwel dow banban keyemko, elo kamok kalun kel kunum mongom im kunum mongom kelewoki te. ");
INSERT INTO bhl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kate, nem kitakamin weng be Sala um min Aisak em dim elo kuw dulewoki te. Makmak itol banime ding dim kabalak, u Aisak beelo fein dukuloku te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Dangei, Sunbin-Got e Abalakam elo koleweko, iti katiw elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Katiw unse ding dim e, Abalam e Sunbin-Got em dangse weng be kiliko, geleweko, em min Ismael em kal okilewse kale. Okileweko, akalem weng afak kunum bikal, ilo weyemse kunum bikal, em weng afak waneng im kunum aul bikal, alik alik biim kal bikati okiyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","26","Makmak ding mak, Abalakam em itol e 99 kelei, em min Ismael em itol e kiin kel kele ding kelei, beem ding bakate min yelim bi ikalem kal okilewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Yelim ikalem so, Abalakam em weng afak kunum so, ilo weyemsiliw kunum iso, em weng afak waneng im kunum aul iso, alik alik bikalem kal okiyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Deiw mak ding mak, Abalakam e mak kunum em wiin e Mamele beem ais tem ninit angse dim kel teinse kale. Ais tem beem mit ka kel e, e akalem samal kal benemsiliw am be bamuk keko, dukuse kale. Dukusomelei, ataan mamin kele ding mak e, Abalam e akalem am abisom dim teinbelei, Yawe telei, atemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Beem ding dim bakate, e gatak daok angeko, kunum alemsal mak mobiliwi, yetemse kale. Yetemeko, fongate akate moko, am kolewko, yakoko, kalfong so im mit mewso uneko, gatak wakas angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Angeko, bokoyemomele: “Kamok kunum alemsal yutaka! Yom folok keli kasike, nem am telina! ");
INSERT INTO bhl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Teleko, ais afak kale finengdalina! Nem weng afak kawtiw mak ok de teliw kano, yom yan gingyemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Deiw kitil keyemomin wanin mak memen keyembi te. Nimtew angom? Nem am teliw kasike kame, wanin waneko, fe, iti unokoliw te.”, yangse kale. Yangei, i kiliko, yan weng bokolewomeliw: “Kenka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Dangsomeliwi, Abalakam e fongate akate akalem am uneko, Sala ulo bokoumomele: “Kutaka! Fongate akate falaua atite banso mak kulusomi, nini ami ami kelewsomi, belet wanin mali mak fula.”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Wangeko, iti fongate uneko, akalem bulmakao im biliw dim yako uneko, samal tugul aliw makmak bamduse kale. Bamduko, akalem weng afak kunum mak elo duleweko, bokolewomele: “Fongate akate memen kelewa!”, dangei, e em dangse weng be kiliko, gelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Gelewei, Abalakam e fuse bulmakao beelo kuluko, bulmakao non gom akal, meme non gom akal, alik be kuluko, alemsal kunum biilo deyem talse kale. Deyem teleko, ilo duyemsomi, emikel kuw ais beem mit mewso moko, “Ki wanbiliw yake? Sukum keliw yake?”, angeko, ilo yetebelei, i wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Wanin wanbiliw ding dim be, i Abalakam elo dakalalomeliw: “Kom kalel Sala, ulio?”, dangeko, dakalasiliw kale. Dakalaliwi, e yan weng bokoyemomele: “U samal kal benemin am tem kel bu tako!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yangei, Yawe e bokolewomele: “Makmak itol teleko, iti banime ding dim bakate, ne iti toloki te. Beem ding dim be, kom kalel Sala u kunum aul mak dukuko, foloku te.”, dangse kale. Dangse kate, Sala u am benemin am beem abisom dim kel mobomului, im weng be kiliyemsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Kiliyemsu kate, Abalakam so, Sala so, yemkal bi atin atin fasel kesomeliwi, Sala um aul dukulomin deiw bakati banimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Banimse kasike, Sala u kunum beem weng be kiliko, yol angeko, abenggilin fian mak kesomi, bokolomelu: “Nesik atin fasel kal aut angii, nem imok akati kanele fasel kebe kasike, ne nono keko, aul dukuloki a?”, angsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Angui, Yawe e Abalakam elo bokolewomele: “Nimtew angom ete kom kalel Sala u abenggiko, bokolomelu: ‘Ne fasel kesi o! Nono aul mak dukuloki o?’, angbu ya? ");
INSERT INTO bhl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Mesesem mesesem eisneng angom mak be, Yawe nem dulum elote kuw ki ka! Kasike, fein! Mak itol makmak banime ding dim kabalak e, ne iti telii, Sala u kunum aul mak dukuko, foloku te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Dangei, Sala u finganeko, dasuw weng bokolomelu: “Ne abenginba te!”, dangsu kate, Yawe e bokoumomele: “Babo! Ku abenggilew te!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Keko beli, kunum alemsal biim wanin banim keliw ding kabalak e, i mosomi, Abalakam so Sodom abiw mutuk fian deiwkim kalo gui unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Unsomeliwi, Yawe e ibolow fukunomele: “Nem kaneloki eisneng be Abalakam elo bokolewo yo. ");
INSERT INTO bhl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Nimtew angom? Ne Abalakam em muluwel dow ilo bamki fian so keyemii, i kawtiw kitil so kebomeliwi, aneng aneng angom im kawtiw alik alik i em wiin dim kel bamki so kulokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ne elo nakalem wiin so amkosi kasike kame, e akalem muluwel dow so, akalem angin so, alik alik ilo nem sawa weng be kilele kukuyemoke te. Kukuyeme tewe, i nem sawa weng be kilele geleweko, kiol kuw kukuw kuw kemoliwka! Keko beli, Yawe nem fawtuk ayem ilo bokoyemsi weng be fein dem gilaloke te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Angeko, Abalakam elo bokolewomele: “Ne kililite: Sodom so Gomola so, abiw mutuk fian alew biim kukuw e atin kuw wa wa kesomi, sili sili nam kukuw fian kekabiliw ");
INSERT INTO bhl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","kasike kame, ne dak uneko, kawtiw biim sili sili kekabiliw ibolow beelo atebam uneko, kilele kal kelite: Abiw mutuk fian alew biim kilisi teng so sang be, fein meni ba.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Dangei, mali kunum alew bi deiwkim kuw gui uneko, Sodom abiw fian unsiliw kale. Uniwi, Abalakam e Yawe eso aso imikel kuw alenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Bomeliwi, Abalakam e Yawe em mit mewso uneko, bokolewomele: “Ku kunum waneng tokotoko so, kunum waneng sakok kebiliw iso, alik alik bongguko, banim keyemokolew, a? ");
INSERT INTO bhl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","50 kel kunum waneng kiol kukuw kuw aluwko, gelewbiliw kawtiw mak abiw mutuk fian beem dim biliw tewe, yu tokotoko kukuw so kawtiw ilo ibolow fukuninba kesomi, wa so ken so kawtiw alik alik bongguko, yenokolew sako? ");
INSERT INTO bhl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ku kunum waneng alik alik im diwyemin kunum kasike, ku kiol kuw diwyema! Ku kanelom kunum waneng ibolow sili sili nam so, kunum waneng kiol kukuw ken so, alik alik bongguko, kukuw ki makmak ilo kukuyemeko, ilo makuw yenokolew te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Dangei, Yawe e bokolewomele: “Sodom abiw mutuk fian kel, 50 kel tokotoko kebiliw kunum waneng mak yetemi tewe, fein, ne abiw be banim keyeminba keloki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Dangei, Abalakam e iti weng makso bokolewomele: “Kutaka! Ne kutew kawin tawal atew kebi kate, kalaing kuw keko, Kamok Fian kuso weng bakabi te. ");
INSERT INTO bhl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mesik esik 50 kel kunum waneng sukumeko, 45 kuw biw tewe, ku teingabi kunum waneng sukum biliw biilo ibolow fukuneko, abiw mutuk fian be banim kelewokolew sako?”, dangse kale. Dangei, Yawe e yan weng bokolewomele: “45 kel kunum waneng biw tewe, ne ilo nam yeni te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Dangeko, Abalakam e iti bokolewomele: “Kate, 40 kel kunum waneng tokotoko kiol kukuw so biw tewe, ku nono keyemokolew a?”, dangse kale. Dangei, Sunbin-Got e yan weng bokolewomele: “40 kel kunum waneng tokotoko kiol kukuw so biw tewe, ne ilo nam yeni te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Dangei, Abalakam e iti weng mak bokolewomele: “Kamok Fian kutaka! Ku kanelom nelo gal kenemokolew te! Kate, 30 kel kunum waneng tokotoko kiol kukuw so biw tewe, ku nono keyemokolew a?”, dangse kale. Dangei, iti yan weng mak bokolewomele: “30 kel kunum waneng tokotoko kukuw so biw tewe, ne ilo nam yeni te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Dangei, Abalakam e iti bokolewomele: “Kutaka! Ne kalaing kuw moko, Kamok Fian kulo bakakembi te. Mali em duan kel kunum waneng tokotoko kukuw so kuw biw tewe, ku nono keyemokolew a?”, dangse kale. Dangei, e yan weng bokolewomele: “Ne ilo nam yeni te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Dangei, e iti bokolewomele: “Kamok Fian kutaka! Ku kanelom nelo kaisuw kenemokolew te! Iti weng makso mak bakakembi te. King kel kunum waneng tokotoko kiol kukuw so biw tewe, ku nono keyemokolew a?”, dangei, e iti yan weng mak bokolewomele: “King kel kunum waneng ite kuw tokotoko kiol kukuw so kunum waneng biw tewe, ne ilo nam yeni te!”, dangeko, ");
INSERT INTO bhl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Abalakam eso weng bakalewbe dim be kolewei, Abalakam akati akalem am elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Beli, Abalakam kolewsiliw kunum alew biim Sodom abiw mutuk fian elo talsiliw ding kabalak e, Olot e abiw mutuk fian beem abisom kitil nam em mit teinse kale. Teinbomelei, e kakow kunum alew biim talbiliw be yetemse kale. Yetemsomelei, Olot e fokfok moko, yako uneko, kalfong so im mit mewso gatak wakas angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Angeko, bokoyemomele: “Kaso yutaka! Kaso yom folok keli kasike, nem am telina! Ne ok de teli kano, aso yu ki keko, aso yukalem yan gingokoliw te! Keko beli, akalsomeliw kano, kutim ete unina!”, yangse kale. Yangei, aso i yan weng bokolewomeliw: “Bayo! Nu kut kale kel akalokoluw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Dangiwi, Olot e aso iso donong ange donong ange kesomeliwi, akal kitil kelei, ikal kitil keliwi, kesiliw kale. Anfel e, aso i elo bokolewomeliw: “Kenka! Kute kitil kelew kasike, kom am unuma!”, dangsiliw kale. Dangiwi, Olot e akalem weng afak kunum ilo weng mak bokoyemomele: “Fongate akate, yu aso biim dulum elote falaua kuluko, ami ami kelewko, belet fasulinba wanin mak memen keyemina!”, yangse kale. Yangei, i fein wanin fuyemiwi, aso i wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Keko beli, akalkemin dim uninba kesiliw ding kabalak e, Sodom abiw mutuk fian em kasel i teleko, Olot em am dim falal kolewsiliw kale. Sodom abiw mutuk fian em fasel kunum so, tanbel kunum so, alik alik i bino talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Bino teleko, gaaneko, Olot elo bokolewomeliw: “Kom am teliw kunum alew i nal kel biliw, a? Ilo kut da koyemew kano, nu ilo osow keyemuma!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Dangiwi, Olot emikel kuw kut elo uneko, am yal net kolewsomi, ");
INSERT INTO bhl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ilo yan weng bokoyemomele: “Nakunum kusel yutaka! Yu kanelom wa kukuw be kemokoliw te! Babe! ");
INSERT INTO bhl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kate, yu kililina! Nem mun seiw alew ite kuw kale biliw te. Uso kut da koyemi kano, yu yukalem ibolow fukunin kuw geleweko, uso ilo keyemina! Kate, kunum alew biim dulum elote, yu ilo kanelom wa kukuw mak keyemokoliw te! Nimtew angom? Aso i nem am kon afak teliwi, ne aso ilo mumul da koyembi kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Yangei, i elo yan weng bokolewomeliw: “Ku asina! Kukati kokow kunum keko, sak nuso belew kate kame, ku nukalem kamok yetebin kunum atew kelew sako? Kate kenka! ‘Aso ilo kukuw wa mak keyemuma!’, anguw kate, kukuw beelo bakilewkabe kukuw atin kuw wa mak kulo kekemokoluw kai!”, dangsiliw kale. Dangiwi, i Olot em mit bino teleko, kitil melmel kesomi, am yal so dakal matem tolomin kis kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kesomeliwi, Olot em am kawtem biliw kunum alew i Olot elo teing bing am da kolewsomi, am yal aisiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Aiko, kawtiw kut biliw biim kiin kasiyemiwi, i kiin sukul atew kesiliw kasike, kunum fasel so tanbel so alik alik bi am beem abisom fensomi, ateminba kesomi, fen kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Keko beli, kunum alew bi Olot elo bokolewomeliw: “Abiw mutuk fian kale kom angin mali mak so mak biliw tewe, ku fongate akate ilo kut elo yemde una! Muluw wanggel so, biim imok kusel so, nimin angin angin makso mak so, alik alik bongguko, ilo makuw kut elo yemde una! ");
INSERT INTO bhl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Nimtew angom? Abiw mutuk fian beem kawtiw im gelewkabiliw wa kukuw be beki beki kuw kebelei, Yawe e kili atemeko, aso nulo yamdako, ‘Abiw mutuk fian kale anko, banim kelina!’, yangse kasike. Keko beli, aso nu teleko, Yawe em yangse weng be geleweko, abiw mutuk fian kale atin kuw alomin tuluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Dangiwi, Olot e kut tem elo uneko, akalem muluw seiw alew biim tonol kebiliw kunum alew biilo bokoyemomele: “Yutaka! Fongate akate moko, abiw mutuk fian kale kolewina! Nimtew angom? Yawe e abiw mutuk fian kale an banim kelomin kebe kasike.”, yangse kale. Yangse kate, aso i em yangse weng be kiliko, atemiwete: Em weng be kikinin weng emdiw keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Beli, mililiw banimei, taw danse ding bakate, Sunbin-Got em yemdakamin finik alew bi Olot elo bokolewomeliw: “Fongate, fongate alikum unuma! Kuso, kukalem kalel so, muluw seiw alew biso, yelimel alik alik yu abiw mutuk fian kale kolina! Mesik esik alik yelimel yu abiw mutuk fian kaleso yuso makuw banimokoliw kasike.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Dangiwi, Olot e neknek kesomi, ibolow banban kese kasike, kunum alew bi Olot em yelimel biim teing yauleko, teing fala fala kut kut da koyemsomi, alik makuw abiw mutuk fian ka kolewsiliw kale. Nimtew angom? Yawe e Olot elo kinkin kelewko, em folok kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Keko beli, im abiw mutuk fian koleweko, kut elo talsiliw ding dim bakate, aso i Olot yelimel ilo bokoyemomeliw: “Fongate, fongate Yoldan bang beleng kalo unina! Yu kanelom bit aneng dim ka kel neknek keko, finengdasomi, ibik famdes atemokoliw te! Kaneliw tewe, yu fein kuanokoliw kasike. Kate, fongate akate amgu mit elo unina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Yangse kate, Olot e aso ilo bokoyemomele: “Kamok a! Bate! ");
INSERT INTO bhl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ku nelo netemomi, nem folok kenembelew kasike, ne nam kuani te. Kate, amgu mit uneko, teini tewe, maka mak nelo neniwi, ‘Ne kuanoki kai!’, angomi, finganbi te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Yangeko, iti bokoyemomele: “Abiw mutuk fong gel miyak be kasike, ne kalo uneko, teinoki te. Abiw ka kel atin atin fong gel kuw kasike, ka e ne nam kuani te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Yangei, Yawe em dabalakamin finik be bokolewomele: “Kenka! Abiw mutuk fong gel be nam ali te. ");
INSERT INTO bhl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kate kame, fongate akate moko, yako unina! Nimtew angom? Yu abiw beelo uninba biliw ding dim bakate, ne mesesem mak nam keli te.”, dangse kale. Olot em aso ilo yangse weng beem dulum elote kawtiw i abiw fong gel be em wiin e Soal angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Keko beli, ataan teleko, mutuk doung ange ding dim e, Olot yelimel i Soal abiw elo talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Talsiliw ding kabalak e, fongate akate Yawe e weing dong mak suuk telemin atew Sodom so, Gomola so, abiw mutuk fian alew biim dim kula mit dase kale. Weing dong be, atin mamin nam mian fong atew kesomi, mamin fok fok kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kelewsomelei, abiw mutuk fian alew biso, aneng bamda kese beso, abiw abiw angom banban biso, kawtiw im dim biliw biso, kawin dim angom beem eisneng beso, alik alik eisneng bi kuiawtum banim keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Banim keyemei, Olot yelimel im unsiliw ding dim bakate, em kalel u neknek kesomi, famdes ibiku atemsu kasike, fongate akate ukalem anggil e alwol kelei, u yol kun du kesu kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Beli, aneng kutim danse ding kabalak e, Abalakam e moko, sin em Yawe eso weng bokose abiw kalo unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Unesomi, kiinengeko, kalak atemete: Sodom so, Gomola so, abiw mutuk fian alew biso, bamda aneng beso, aneng alik alik beem dim e deik so weing so kuw kainbelei, atemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Atemse kate, Yawe em abiw abiw mutuk fian biilo banim keyemse ding dim bakate, e Abalakam em ibolow fukuneko, Olot elo alinba kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Keko beli, Olot e fingan fian mak kuluko, Soal abiw iti kolewsomi, eso, akalem muluw seiw alew biso, yelimel i uneko, amgu tikin em tum tem mak uneko, ka alenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ka bomeliwi, deiw mak ding mak kele ding dim bakate, emisik mun u ukalem umteben awkolon ulo weng mak bokoumomelu: “Aatim e kunum fasel kele te. Kelei, nulo yemdusomi, aul duyemomin kunum mak ikal banim ");
INSERT INTO bhl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","kasike, kuso nu aatim elo wain ok banso demenuw kano, e wanesomi, teifulusomi, kuso nulo aul mak duyemei, nu aul so keluma! Nimtew angom? Num aul dow e banim kasike.”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Wangesomelui, mililiw ding kabalak e, uso i alew elo wain ok demeniwi, Olot e waneko, teifulusomelei, akalem emisik mun u alew em mit unui, e ulo woluwei, i akalsiliw kale. Kanesiliw kate, alew e im kanesiliw be ibolow akokow kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Keko beli, kutim danse ding kabalak e, u ukalem neng ulo weng mak bokoumomelu: “Suaem mililiw e, aatim e nelo naulei, akal kembuluw te. Kameem mililiw e, kuso nu elo iti wain ok demenuw kano, em teifululoke ding dim bakate, kusik em mit unewi, e kulo kaulei, akaloliw te. Keko beli, kuso nu aul dow so keloluwka!”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Wangui, beem mililiw ding be, fein, uso i alew elo iti wain ok dulewiwi, e waneko, teifuluse kale. Em teifuluse ding dim bakate, neng bu alew em mit unui, e ulo woluei, i akalsiliw kale. Kanesiliw kate, alew e im kanesiliw be akokow kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Keko beli, Olot e akalem muluw seiw biilo aul kumun keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Keyemei, emisik mun u kunum aul mak dukuko, em wiin e “Moaw!”, dangsu kale. Moaw e Moaw kawtiw im kunum mongom keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Keko beli, neng ukal kunum aul mak dukuko, em wiin e “Ben-Ami!”, dangsu kale. Ben-Ami e Amon kawtiw im kunum mongom keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Beli, Abalakam e Mamele em ais tem ninit mit ka kel teinse abiw be koleweko, Negew aneng elo unesomi, Kades abiw mutuk fian tele Sul abiw mutuk fian tele, biim tele tele abiw mutuk fian Gelal beem mit mewso teinse kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Em kalo unse ding dim bakate, Abalakam e akalem kalel Sala um dulum elote kaem aneng kasel ilo bokoyemomele: “Sala bu nakalem neng te!”, yangse kale. Yangei, Gelal abiw mutuk fian em emisik kamok Abimelek e akalem weng afak kunum ilo bokoyemomele: “Yu uneko, Sala ulo wamde telina!”, yangei, i fein uneko, ulo wamde teliwi, e ulo kuluse kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kulusomelei, mililiw ding kabalak e, Sunbin-Got e kiin dem sin teleko, Abimelek elo bokolewomele: “Kulubelew waneng bu nanew kunum em kalel kebu kasike kame, ne kulo kenii, ku kuanokolew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Dangse kate Abimelek e Sala ulo woluwei, i akalinba kesiliw kasike, Abimelek e Sunbin-Got elo yan weng mak bokolewomele: “Yakai kutaka! Ku kiol kukuw gelewbiliw kunum waneng ilo yenkabelew sako? ");
INSERT INTO bhl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abalakam esik nelo bokonemomele: ‘Waneng bu nakalem neng te!’, nangei, waneng bukati nelo bokonemomelu: ‘Kunum be nem fik te!’, nangui, ne wosuko, ulo kulusi te. Feinka! Nem ibolow fukunin akal, nem kukuw akal, alik alik be kiol kuw kebe te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Dangei, Sunbin-Got e kiin dem sin yan weng mak elo bokolewomele: “Feinka! Kom ibolow fukunin kiol kuw beelo kal kebi kasike, ne ‘Ku kanelom ulo woluwsomi, uso akalokolew te!’, angomi, kilele dokokemsi te. Mesik esik ku wa kukuw keko, nem kiin dim e sili sili kukuw kemokolew kasike. ");
INSERT INTO bhl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kate kame, waneng bu ukalem imok mit elo wamdalolewka! Nimtew angom? Kunum be nem bontem dim bakabe kunum kebe kasike. E neso weng bokoko, nelo dakalalei, ne kulo dokokemii, ku nam kuanew te. Kate, ku waneng buulo wamdalinba kelew tewe, ne kuso kukalem angin alik alik biso fein yenii, alik alik yu kuanokoliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Dangei, kutim danse ding dim bakate, Abimelek e fongate akate akalem weng afak kunum ilo gaayemei, i teliwi, e ilo Sunbin-Got em kiin dem sang be bokoyemse kale. Bokoyemei, i kiliko, alik alik i finganin fian mak kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Keko beli, Abimelek e Abalakam elo gaalewei, e em mit telei, e elo bokolewomele: “Kutaka! Nimtew angom ete ku wa kukuw be neso, nakalem angin biso alik nulo kukuyembelew a? Nomin sili sili kukuw mak ne kulo kekemsi kate? Kom kanebelew beem mongom ete kame neso, nakalem angin so, alik alik nu Sunbin-Got em kiin dim e sen so buluw te. Kawtiw i kanenembelew kukuw beemdiw kanelom kemokoliw te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Dangeko, iti weng makso bokolewomele: “Nimtew eisneng mak kom ibolow tem une kemei, ku kaneko wa kukuw kenembelew a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Dangei, Abalakam e yan weng bokolewomele: “Ne finganeko, ibolow fukunite: ‘Aneng kaleem kawtiw i Sunbin-Got em awan finganinba kebiliw kasike, i nelo nesomeliwi, nem kalel ukal tokolu dakinemokoliw te.’, angebi te. ");
INSERT INTO bhl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Angebi kate, Sala bu fein nakalem neng ute te. Alew num aatim e diw kate, um auk ukal amen, nem yem ukal amen kasike, ne ulo kulusi te. ");
INSERT INTO bhl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Keko beli, deiw mak ding mak kelei, Sunbin-Got e nelo gaanemei, ne nakalem angin so aatim kumel so koyemeko, nem akokow aneng mak elo unsi te. Unsi ding kabalak e, ne nakalem kalel Sala ulo bokoumomeli: ‘Sala, ku nelo fein ibolow mutuk fian kenemew tewe, aneng aneng kakamaluw beem biliw kasel ilo bokoyemomelew: ‘Abalakam e nakalem fik te.’, yangbolewka!’, wangsi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Dangei, Abimelek e Sala ulo Abalakam em fukun wamdeko, siwsiw so, bulmakao so, sak weng afak kawtiw so kuluko, Abalakam elo duleweko, ");
INSERT INTO bhl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","bokolewomele: “Nem aneng be kukalem ete. Kawin beem anung mak ibolow kelew tewe, ka kel sak teina!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Dangeko, Sala ulo bokoumomele: “Kame, kukalem ‘fik’, dangbelew elo on kisol 1'000 dulewbi kasike, on kisol be kom inkal so ilum so kuluselew be atin kuw okilewoka!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Wangeko, iti Abalakam elo bokolewomele: “Abalakam, ku Sunbin-Got eso weng bokoko, nem dulum elo dakalala!”, dangse kale. Nimtew angom? Yawe e Sala ulo ibolow fukunse kasike, e Abimelek em angin im waneng alik alik biilo aul banim fium keyemse kasike. Keko beli, Abalakam em Sunbin-Got eso bokolewse ding kabalak e, Sunbin-Got e em dangse weng be kiliko, Abimelek em kalel so akalem angin im waneng so alik alik ilo dokoyemei, i iti aul kumun so kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Beli, Yawe e Sala ulo watemeko, akalem yangse fawtuk weng ayem elo fukunsomi, Sala ulo dokoumse ");
INSERT INTO bhl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","kasike, fein, u aul kumun kesomi, um kunum fasel kese imok Abalakam elo kunum aul mak dukulewsu kale. Dukulewsu kasike, Sunbin-Got em sua kel yangse weng be fein dem abuse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Keko beli, Abalakam yemkal i kunum aul beem wiin e “Aisak” dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Dangiwi, Aisak em dukusu ding e duan kel ding kese ding dim bakate, Abalakam e Sunbin-Got em kitakamin weng geleweko, akalem min em kal okilewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Sala um Aisak elo dukusu ding dim e, Abalakam em itol e 100 kese ");
INSERT INTO bhl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","kasike, Sala u bokolomelu: “Sunbin-Got e nelo ibolow folok so kenemse te. Kunum waneng alik alik i nelo kanemse sang be kiliko, neso kalfong kesomi, abenggilokoliw te!”, angsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Angeko, iti bokolomelu: “Mali kawitw mak Abalakam elo bokolewomeliw: ‘Kom kalel Sala u aul mak dukuko, non demenoku te!’, danginba kesiliw kate kame, nelo netemina! Nem fasel sel kese imok Abalakam elo aul mak dukulewsi te!”, angsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Beli, kunum aul beem tiak keko, non kolewse ding kabalak e, Abalakam e wanin fian mak fulei, i aul kakat fian mak kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Keko beli, deiw mak ding mak e, Sala u atemute: Abalakam em Isiw aneng fian em afam waneng Kagal um min Ismael e ukalem min Aisak em ibolow daolewei, atemsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Atemsomelui, u Abalakam elo bokolewomelu: “Sak weng afak keko, aluwbamin waneng buso, ukalem min eso, kulu koyemeko, nanew aneng elo yemda una! Nimtew angom? Sak weng afak waneng buum min be kanelom, nakalem min Aisak eso bongguko, nukalem on kisol eisneng mesesem mesesem be nam kule tako! Aisak em ete kuw te.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Dangui, Abalakam e ibolow banban kese kale. Nimtew angom? Ismael bakal akalem min kasike. ");
INSERT INTO bhl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kate, Sunbin-Got e Abalakam elo bokolewomele: “Ku kanelom weng afak waneng Kagal buso, um min beso, yat biim dulum elote ibolow ilum kelokolew te! Sala um min Aisak beem muluwel dow ite kuw kukalem angin kelokoliw kasike kame, kom sun waneng buum kangsu weng beelo gelewa! ");
INSERT INTO bhl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kate ku kilele kilila! Weng afak waneng buum min bakati muluwel dow banso fukalaloke te. Nimtew angom? Akati kukalem min kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Dangei, iti kutim danse ding dim bakate, Abalakam e wanin so, ok sen so, um aul beso kuluko, Kagal ulo king takas keumeko, yat ilo yemdase kale. Yemdalei, afam waneng yat uneko, Belseba aneng kawtiw banim so, ais banim tiow aneng kalo uneko, akokow aneng kalo teifulusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Teifulubomeliwi, im de telsiliw ok be banimse ding dim bakate, u min beelo ais mit koleweko, ");
INSERT INTO bhl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","uneko, gan awet ka kel teineko, ibolow tiaktiak kesomi, bokolomelu: “Min beem kuanoke be ne nam atemi te.”, angeko, ka teinsu kale. Teinsu kate, um min be amemin kuw amebomi, alse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Keko beli, Sunbin-Got e aul beem amemin be kilisomi, akalem dabalakamin finik mak dabalalei, e abiil elote Kagal ulo weng mak bokoumomele: “Kagal kutaka! Ku nimtew angom ete amebelew a? Ku kanelom finganemokolew te! Sunbin-Got e aul beelo atemeko, em amemin be kilile ");
INSERT INTO bhl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","kasike, ku kame kalaing kuw keko, mola! Moko, min elo teing so daok kelewko, mumul dala! Nimtew angom? Em muluwel dow ilo banso banso keyemoki kasike.”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Wangei, Sunbin-Got e Kagal um kiin bamtak keumei, u fein atemute: “Kawin tem ok mak be kai!”, angesomelui, u ok sen kuluko, dulusomi, wenei, u min elo demensu kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Keko beli, Sunbin-Got e aul beelo atemeko, dokolewse kasike, aul be tanbeleko, Balan aneng kel teineko, kakabise kale. Balan aneng be kawtiw banim so, ok banim so, ais banim dim kese kale. Aul be ka teinbomelei, yemin kunum inkal so kese kale. Kelei, deiw mak ding dim kabalak, auk u Isiw aneng fian em waneng mak fen de teleko, elo dulewui, e ulo kuluse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Beli, beem ding dim be, kunum mak em wiin e Bikol bise kale. E Abimelek em wonuk so kunum im kak kunum kese kale. Kunum beso, Abimelek so, aso i teleko, Abalakam elo bokolewomeliw: “Aso nu atemuwete: Nomin eisneng mak ku kelew tewe, Sunbin-Got e kulo dokokemkabe ");
INSERT INTO bhl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","kasike kame, Sunbin-Got em kiin dim e weng fawtuk ayem mak nulo bokoyema! Weng be kanekote: Diwkuw diwkuw, ku nuso, nukalem muluwel dow iso, alik alik nulo nam funum funum keyemew te. Ne kulo ken ati kukuw kuw kukukemsi kasike kame, ku nakalem atew kelomi, aneng kaleem kasel alik alik nukalem akati ken kukuw kuw kukuyemolewka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Dangiwi, Abalakam e aso ilo yan weng bokoyemomele: “Kenka! Fawtuk weng ayem be kaneloki te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Yangeko, iti weng makso Abimelek elo bokolewomele: “Kom weng afak kunum i teleko, nuso gansomi, nakalem ok miktem yakut keko, kulusiliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Dangei, Abimelek e yan weng bokolewomele: “Ne naknok! Kame emisik ding kelei, ne kanese eisneng be kilili te.” dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Dangei, Abalakam e siwsiw so, meme so, bulmakao so, kuluko, Abimelek elo dulewei, aso i kitakamin weng mak dukusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Dukusomeliwi, Abalakam e siwsiw yanggus men ben kel amen amen keko, dukuse kasike, ");
INSERT INTO bhl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek e elo dakalalomele: “Nimtew angom ete ku kanelew a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Dangei, Abalakam e yan weng bokolewomele: “Mali kawtiw i kulo dukembi ben kel siwsiw be atemeko, kilele kal keliwete: Nete kuw kawin tem dikeko, ok miktem be fitew dasi te.”, dangesomi, siwsiw ben kel beelo dulewei, fein, Abimelek e ilo kuluse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kuluse kasike, abiw ka em wiin e “Belseba” dangsiliw kale. Nimtew angom? Aneng ka e, aso i ikalem dukusiliw kitakamin weng beem fawtuw ayem weng bokolew bokolew kesiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Keko beli, Abimelek so, akalem wonuk so kunum im kak kunum Bikol so, aso i iti ikalem Filistia aneng fian elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Uniwi, Abalakam e Belseba abiw kel ais sel mak kaiko, Yawe Elolam em wiin fian dolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Beli, tiak ding kelei, Abalakam e kokow kunum keko, Filistia aneng fian ka kel teinse kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Deiw mak ding mak, Sunbin-Got e Abalakam em fein ibolow beelo atemomin kelewse kasike, e Abalakam elo gaaleweko, bokolewomele: “Abalakam kutaka!”, dangei, e yan weng bokolewomele: “Nesik bi kale eli!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Dangei, Sunbin-Got e bokolewomele: “Kukalem ibolow mutuk fian dulewbelew tenbel min makmak beem dulum elote weng kale kilila! Ku Aisak be so debeleko, Molia aneng kalo unolewka! Ka uneko, amgu tikin dim kel, kukalem min makmak beelo anko, aik ayem weing dong dim kel dako, nelo dunema!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Dangei, kutim danse ding dim e, Abalakam e aik ayem em ais mak donki mak em dim dukuko, akalem weng afak kunum alew so, akalem min Aisak so, alik alik i makuw ba unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Unsomeliwi, deiw am alew akalsomi, iti kutim danse ding em baba teinsiliw ding kabalak e, Abalakam e kiin sonalete: Sunbin-Got elo bokolewse aneng Molia be singam singam miyaka kelei, atemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Atemeko, akalem weng afak kunum alew biilo bokoyemomele: “Kaso yu kale kel donki so bomi, ding fenboliwka! Nulum nu miyak kalo Sunbin-Got em wiin fian daolew kelewomin unuwka. Kanesomeluwi, nulum nu iti tolokoluw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Yangeko, aik ayem em ais dasiliw be kuluko, Aisak em king dim dukulei, min e ais be kingtilei, alew Abalakam e weing atuk so, sakam dang so, kuluko, aluwsomi, yelim ikalem makuw Sunbin-Got em wiin daolewomin em dim kalo unsilw kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Unesomeliwi, Aisak e alew elo dakalalomele: “Aatim kutaka!”, dangse kale. Dangei, alew e bokolewomele: “Nimtew kate?”, dangse kale. Dangei, min e bokolewomele: “Ais atuk so, ais banso kale so, nolom minem a? Yawe em dulum elote alomin siwsiw samal mal nal kel be a?”, dangeko, alew elo dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Dangei, e yan weng bokolewomele: “Sunbin-Got akalem ete kuw siwsiw mak duyemoke te. Nulum nu Sunbin-Got em aik ayem memen keluma!”, dangei, yelim i fein amgu tikin elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Unesomeliwi, im Sunbin-Got em Abalakam elo dangse dim kalo talsiliw ding dim bakate, Abalakam e tum bongguko, tiwtok kolewsomi, aik ayem mak geko, min Aisak elo akal kuluko, teing so yan so sok doung koleweko, aik ayem beem tikin dim dako, dukuse kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Dukusomelei, sakam dang fit matem dako, min elo alomin memen kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Beem ding kabalak e, Yawe em Dabalakamin Finik be abiil tikin elote gaanomele: “Abalakam kutaka! Abalakam kutaka!”, dangeko, gaanei, Abalakam e kiliko, gaanomele: “Ne bi kale tako! Ne bi kale tako!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Dangei, e bokolewomele: “Ku kanelom min beelo alokolew te! Feinka! Kame, ne kom fein ibolow be kilele kal keli te. Ku fein nem weng gelewkabelew kunum kute te. Nimtew angom? Ku kom min makmak beem ibolow fukuninba kesomi, nelo dunemomin kelew kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Dangei, Abalakam e kiinguen fubelet angeko, atemete: Siwsiw imok mak ais teing ningning so dim dineko, belei, atemse kale. Atemeko, Aisak elo fokfok kuluko, elo gese sok be sileko, tein kolewse kale. Tein kolewsomelei, Abalakam e uneko, siwsiw imok ningning dim dinbe be de teleko, aik ayem beem dim ka dukuko, samal be akalem min Aisak em abin dim dukuse kale. Dukusomelei, ais abulsomi, siwsiw beelo anko, weing dako, Sunbin-Got elo “Weso! Seyo!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Dangesomi, aik ayem beem be dim em wiin “Yawe Yile” dangse kale. Beli, kameem ding akati, kawtiw i amgu tikin beem wiin e Yawe Yile angakabiliw te. ");
INSERT INTO bhl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Beli, Yawe em Dabalakamin Finik be abiil tikin elote iti gaaneko, bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Yawe Sunbin-Got e akalem wiin dim fawtuk ayem weng mak bokoko, kom dim dukule te. Angse kitil weng be kanekote: Ku kukalem min makmak angom beem ibolow fukuninba kesomi, nelo dunemomin kelew kasike, ");
INSERT INTO bhl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ne kame kulo bamki fian so kekemi te. Kom muluwel dow ikati bamki fian so keyemii, im fufu banso banso e abiil em fial galgul beemdiw keko, okmun fian em ok dilin banso banso beemdiw keyemoki te. Keyemsomi, kom muluwel dow biim kitil akal fian kuw keyemii, i ikalem maka kuiawtum keyemsomi, biim abiw mutuk fian biilo kulokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Feinka! Ku nakalem weng be kiliko, gelewbelew kasike, ne kulo kawin dim kaleem kunum waneng alik alik im bamki so mongom kayak kunum kekemi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Dangei, Abalakam yelim i iti akalem weng afak kunum alew biim fukun unsiliw kale. Uniwi, alik alik i makuw keko, Belseba abiw elo iti unesomi, ka kel teinsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Deiw mak ding mak, mali kunum mak Abalakam em fukun teleko, bokolewomeliw: “Kom ning Nakol em kalel Milka ukati duan kel aul mak kailsu te. ");
INSERT INTO bhl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Emisik min dil em wiin e Us e, emteben em wiin e Bus e, iti mak em wiin e Kemuel te. (Kemuel e Alam em alew kese te.) ");
INSERT INTO bhl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Milka um muluwel im wiin mali makso kanekote: Mak e Keset e, mak e Kaso e, mak e Filidas e, mak e Yitalaw e, fefe e Betuel te. ");
INSERT INTO bhl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Betuel em mun mak um wiin e Elebeka te.)”, dangsiliw kale. Keko beli, Milka so, Abalakam em ning Nakol so, yemkal bi duan kel kunum aul bi fukosiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Fukosomeliwi, Nakol em afam waneng um wiin e Eleuma ukati mali aul mak fukosu kale. Aul biim wiin kanekote: Mak em wiin e Teba, mak em wiin e Gakam, mak em wiin e Takas, fefe em wiin e Maka te. ");
INSERT INTO bhl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Beli, Kenan aneng fian em abiw mutuk fian Kiliyat Alaba ka kel bisiliw ding dim bakate, Sala um itol e 127 keumei, u ka kel kuansu kale. Abiw mutuk fian beem wiin mak e Kebolon te. Sala um kuansu ding dim bakate, Abalakam e sakik ilum fian mak kuluko, amemin fian fian kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kesomelei, e akalem kalel Sala um fom mit mewso kel moko, Kit angin iso weng mak bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ne kokow telemin kunum mak yom mutuk kale kel alakabi kasike, um womkulomin kawin mak banim te. Kasike kame, kawin anung mak dunemiw kano, ne nakalem kalel um fom be womkulo yo.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Yangei, Kit kawtiw i yan weng bokolewomeliw: ");
INSERT INTO bhl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Kamok a, num weng kale kilila! Ku Sunbin-Got em kunum wiin so auk so kunum kamok kasike, nukalem emisik fomkamin kawin tem mak diw atemsomi, ka kel mak ken kele tewe, kom kalel um fom beelo wamkulolewka! Nu kulo ‘Bayo!’, nam kanguw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Dangiwi, Abalakam e im dangsiliw weng be kiliko, kawin kasel biim kiin dim “Weso! Seyo!”, yangeko, gatak wakas angesomi, iti gatak dok angeko, ");
INSERT INTO bhl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","iti weng mak bokoyemomele: “Yu nem weng kale kilele kililina! Ne Soal em min Efolon beem kawin atuk mak diw atemeko, ibolow kelewsi kasike kame, yu uneko, elo dakalalina! Nimtew angom? Ne nem kalel um fom be ka kel wamkulomin ibolow keli te. ");
INSERT INTO bhl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Makfela kawin atuk beem tum tem be, Efelon em musun sin dim kel te. Kawin atuk beem yan be ne yukalem kiin dim kel kiol kuw wenoki te. Weni kano, kawin atuk be fein nakalem kuw keko, nem fomkamin kawin deng keboka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Yangei, Efolon akalem akal im mutuk moko, Kit kunum waneng alik alik im kiin dim e Abalakam elo yan weng mak bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Kamok kutaka! Ku kawin atuk beem yan e nam dukuko, welew te. Kunum waneng kaliim kiin dim e ne kawin atuk beso, beem tum tem beso, musun beso, alik alik be sak kuw, yan banim misim kuw dukemika. Ku uneko, kom kalel um fom be tum tem ka kel womkulolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Dangei, Abalakam e em dangse weng be kiliko, aneng kasel biim kiin dim e “Weso! Seyo!”, dangeko, gatak wakas angesomi, gatak dok angeko, ");
INSERT INTO bhl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","iti Efolon elo bokolewomele: “Babo! Ku nem weng kale kilila! Ku nelo kawin atuk beem yan e kiol kuw bokolew kano, ne fein wekemoki te. Wekemsomi, nakalem kalel um fom be ka kel fein womkuloki te.”, dangbei, ka biliw kunum waneng alik alik bi kiliko, kal kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Keko beli, Efolon e Abalakam elo yan weng bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Nem kamok kutaka! Ku kilila! Kawin atuk beem yan e fong gel kuw te. Em on kisol e 400 silba tum win kuw te. Kunum kisol so wiin fian so kunum nukalem atew yan be fong gel eisneng kuw te. Keko beli, ku uneko, kom kalel um fom be kawin atuk ka kel womkulolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Dangei, Abalakam e em dangse weng be kiliko, Kit kawtiw biim wemin kukuw gelewko, alik alik kawtiw ka biliw biim kiin dim e, kawin atuk beem yan be kiol kuw dulewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Keko, beli, Makfela aneng be Mamele em ais tem ninit dim em ataan tele dulum dim mewso ke alenale kale. Abalakam e Makfela aneng beso, beem dulum em musun mewso beso, beem tum tem so, beem ais alik so, mesesem mesesem alik alik beso makuw bongguko, beem yan dukusomi, Efolon em teing dim dako, atin kuw welewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Welewei, Kit kawtiw alik alik ikati kilele kal keliwete: “Abalakam e kawin atuk beem yan e on kisol so wene kai!”, angomi, kal kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Keko beli, Abalakam e akalem kalel um fom be Kenan aneng fian em kawin atuk Makfela beem tum tem ka kel womkuse kale. Makfela kawin atuk be Mamele abiw beem mewso dim te. Kelei, Mamele abiw beem wiin mak e Kebolon te. ");
INSERT INTO bhl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Beli, Kit kasel im kawin atuk be so, beem tum tem so, alik alik be Abalakam so, akalem muluwel dow so, alik alik im fom duku kemin kawin atuk keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Beli, Yawe e Abalakam elo mesesem mesesem eisneng bamki fian so kelewse kale. Kelewei, deiw mak ding mak, Abalakam em fasel kelei, em ding awet kese dim kabalak e, ");
INSERT INTO bhl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","e akalem weng afak kawtiw im wiin so kak kunum fasel mak beelo bokolewomele: “Ku tala o! Teleko, kom teing de teleko, nem anggil dim melenema! Melenemsomi, weng fawtuk ayem weng mak bokonema! ");
INSERT INTO bhl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","4","Abiil kawin dukuse Sunbin-Got Yawe em wiin dim e ku kame ayem fawtuk weng mak nelo bokonema! Kitil weng be kanekote: Ku uneko, nem min Aisak em kalel mak fendew una! Unokolew kate, ku kanelom Kenan aneng kaleem wanggel im waneng mak wamde tolokolew te! Kate ku aneng fian kale koleweko, nakalem alenali aneng kalo uneko, nakalem angin im waneng seiw mak wamde tololewka! Wamde telew kano, waneng bu nem min Aisak elo dabuluka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Dangei, em weng afak kunum be yan weng bokolewomele: “Ken kate, ne waneng seiw mak watemeko, “Wamde toloki te!”, angi kate, u ukalem angin so, ukalem aneng so ibolow fukunomi, neso tolomin gal kelu tewe, ne nono keloki a? Ne kom min beete dabeleko, kukalem sua kolew talselew dim kalo iti debele unoki meni, baya?”, dangeko, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Dakalalei, Abalakam e akalem weng afak kunum beelo bokolewomele: “Itel bate! Ku elo kanelom dabeleko, nakalem sua kolew talsi aneng kalo iti debele unokolew te! ");
INSERT INTO bhl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yawe, abiil tikin alakabe Sunbin-Got e nelo aatim kusel im aneng fian so, nakalem angin so, biim dim namdeko, weng fawtuk ayem weng kitil weng mak bokonemomele: ‘Aneng fian kale kom muluwel dow ilo fein duyemoki te.’, nangse te. Nangse kasike kame, Sunbin-Got be akalem dabalakamin finik mak dabalako, emisik kamtolo unbelei, ku beem ibik elote gelew gelew unemolewka! Unesomelewi, kuso, nem min em waneng buso, kuso fein makuw tololiwka! ");
INSERT INTO bhl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tolokoliw kate, waneng seiw bu ukalem angin kuw ibolow fukunomi, tolominba ibolow keko, gal kelu tewe, ku kom bokonembelew fawtuk ayem weng beelo akokow kelewko, kolewolewka! Kolewokolew kate, ku kanelo nem min kale nakalem kolew talsi aneng fian elo iti dabele unokolew te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Dangei, weng afak kunum be akalem teing de teleko, Abalakam em anggil dim melelewko, weng fawtuk ayem weng beelo bokolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Bokolewsomelei, weng afak kunum be, akalem kamok Abalakam em king kel kamel samal mali mak so, on kisol kait ken so, alik eisneng be memen keko, kulusomi, Mesofotemia aneng fian kalo unse kale. Unbisomelei, deiw mak ding kabalak e, e Abalakam em ning Nakol em abiw mutuk fian dim kalo talse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ka teleko, ataan mewso tem unomin dim kese kasike, beem ding dim be, abiw mutuk fian kasel biim waneng seiwel i abiw mutuk fian koleweko, kawin tem ok beelo ok dulam talsiliw kale. Keko beli, Abalakam em weng afak kunum be akalem kamel biilo yemdeko, kawin tem ok beem dim mewso elo koyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Koyemsomi, Sunbin-Got eso weng mak bokolomele: “Abalakam em Sunbin-Got Yawe kutaka! Kame ku nelo dokonemeko, nakalem kamok elo ibolow folok kelewa! ");
INSERT INTO bhl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kameem ding dim e, abiw mutuk fian beem waneng seiwel alik alik i teleko, kawin tem ok kaleelo ok dulam tolokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tolokoliw kasike, ne waneng seiw mak ulo bokoumomeli: ‘Kom kingti telbelew ok sen be de mit dalin tew keko, ok wal dinema!’, wangoki te. Wangii, u nem wangsi weng be kiliko, yan weng mak bokonemomelu: ‘Kenka, ku wana! Wanesomi, ki kelew dim e, kom kamel samal bikati ok duyemoki te.’, nangeko, kanelu tewe, ne kilele kal kelite: Kusik nelo nangoku weng kale buum ibolow tem kel duumselew kasike, waneng bu Aisak em kalel keloku te. Feinka! Ku kanelew tewe, ne atemeko, kal kelite: ‘Ku nakalem kamok Abalakam elo ibolow folok kelewbelew kai!’, kangoki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Dangse dim bakate, Elebeka u abiw mutuk fian be koleweko, ok sen fian mak kingtiko, talsu kale. Elebeka bu Nakol so Milka so yemkal biim min Betuel em mun seiw ute kale. Kate Nakol e Abalakam em ning ete kasike, Abalakam e Elebeka um awalik kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Elebeka bu waneng seiw atin kuw kiin abil butbi watebomin so kesu waneng kale. Keko beli, waneng bu kawin tem dak uneko, ukalem ok sen fian duluko, iti matem talsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Iti matem talsu ding dim bakate, Abalakam em weng afak kunum be fongate akate uneko, um mit teleko, bokoumomele: “Kutaka! Kom kingti telbelew ok sen be de mit dalin tew keko, ok wal dinema!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Wangei, u elo bokolewomelu: “Kenka, kamok! Ku wana!”, dangeko, ok sen be de mit dalin tew keko, ok wal dilewui, e ok wal wanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Waneko, ki kelei, u bokolewomelu: “Kom kamel samal bikati ok duyemii, ikal wanesomi, ki kelokoliw te.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Dangeko, fongate akate uneko, aluwbu ok atuk be samal im ok wanbin dim beelo busel kelewui, ok alelei, samal i wanesomeliwi, u iti kawin tem dak uneko, iti ok makso duluko, diyembului, kamel samal fian sesel alik alik i ki kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ki keliwi, Abalakam em weng afak kunum be um kanebu kukuw be diw atemeko, weng mak bokolinba kesomi, “Yawe akalem kuw ken eisneng kale kanelebe kai!”, angeko, ibolow tem kuw fukunse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Keko beli, kamel biim ok ki wansiliw ding dim bakate, Abalakam em weng afak kunum be mesesem mesesem kait on kisol fian so be de matem dako, mutum dim kelebin kait so, teing tabum kelebin kait alew so, kait alik be seiw buulo duumse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Duumeko, ulo dakalako, bokoumomele: “Ku kanem mun kate a? Kalew em am e abin dolon so meni gek biliw a? Nu ki keko, yelimel yom am kel akalokoluw mani, ba?”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Wangei, u yan weng bokolewomelu: “Ne Betuel em mun neli. E Nakol so Milka so yemkal im min te.”, dangeko, ");
INSERT INTO bhl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","iti bokolewomelu: “Kamel im wanin wanomin so, akalomin abin dolon akal be kasike, ku so, kukalem kamel so, alik alik yu makuw tololiwka!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Dangui, Abalakam em weng afak kunum be kalfong fian mak kulusomi, gatak wakas angeko, katin bukbuk Yawe em mit teineko, ");
INSERT INTO bhl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","em wiin fian daolewsomi, bokolewomele: “Nem kamok Abalakam em Sunbin-Got Yawe em wiin fian daolewbika! Nimtew angom? Akalem kiol kukuw so, em folok ibolow so, be nem kamok Abalakam elo fein kukulewkabe kasike. Yawe Sunbin-Got e nelo nemdeko, nem kamok em angin biim mit elo kenemse kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Dangsomelei, waneng seiw bu fongate akate yakoko, ukalem auk um am biliw kunum waneng ukalem dim kanelu sang be bokoyemomin yako unsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Yako uneko, bokoyemui, Elebeka um fik Alaban e um yangu weng be kiliko, fongate akate kut elo kunum beem fukun uneko, kawin tem ok damin beem dim kalo atebam unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Nimtew angom? E Elebeka um weng sang kiliko, ukalem teing tabum alew so, mutum bok so, kait on kisol fian so be atemse kasike. Keko beli, e fongate akate uneko, kunum kawin tem ok mit mewso mobe kunum mak atemeko, beelo bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“Yawe kulo bamki so kekembe kunum kutaka! Nimtew angom ete ku kut kale kel mobelew a? Ne nakalem weng afak kunum ilo kitil weng bokoyemi kasike, i kukalem abin so, kamel im akalomin dim so, kilelyembiliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Dangei, aso i Alaban yemkal im am dim kalo unsiliw kale. Uneko, teliwi, Alaban e kamel im mesesem mesesem eisneng ilum so be de mit mit dukuko, ilo wanin duyemeko, ilo im akalkemin dim da koyemse kale. Koyemeko, Abalakam em weng afak kunum beelo ok dulu dulewei, e akalem yan gingse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Gingsomelei, mali weng afak kunum mak Abalakam em weng afak kunum beelo wanin delew talsiliw kate, e yelimel ilo bokoyemomele: “Bayo! Wanomin wanin e kanesele kano! Kame, ne yulo weng mak bokoyemomin ibolow keli te.”, yangse kale. Yangei, Alaban e elo bokolewomele: “Kenka. Ku nulo bokoyema!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Dangei, e ilo bokoyemomele: “Nete Abalakam em weng afak kunum nete te. ");
INSERT INTO bhl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawe Sunbin-Got e nem kamok elo bamki fian so kelewbelei, e on kisol banso, wiin so kunum kekabe te. Feinka! Meme so, siwsiw so, bulmakao so, on kisol tum win fian so, weng afak kunum waneng banban so, kamel so, donki so, mesesem mesesem eisneng banban be bamki fian so kelewkabe kasike, e wiin so kunum kamok kekabe te. ");
INSERT INTO bhl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Keko beli, Sunbin-Got e nem kamok beem kalel fasel buulo dokoumei, u kunum aul mak dukusu te. Dukului, Abalakam e aul beelo akalem mesesem mesesem eisneng alik alik be dulewse te. ");
INSERT INTO bhl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Duleweko, weng kitil weng mak nelo bokonemomele: ‘Ku fawtuk ayem weng mak nelo bokonema! Weng be kanekote: Ku kanelom Kenan aneng fian beem waneng mak wamde teleko, Aisak elo dulewokolew te! ");
INSERT INTO bhl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kate, ku uneko, nakalem angin waneng mak fenemsomelewi, nakalem kaim atuk waneng mak kuluko, wamde telesomi, Aisak dulewew kano, e ulo kuloka!’, nangese te. ");
INSERT INTO bhl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nangei, ne yan weng bokolewomeli: ‘Kate, waneng bu ‘Bayo!’, nangu tewe, ne nono keloki a?’, dangesi te. ");
INSERT INTO bhl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Dangii, e nelo bokonemomele: ‘Ne Yawe em weng gelewbi kunum kasike, e akalem dabalakamin finik mak dabalalei, emisik kamtolo unoke kasike, kom kakamokolew deiw beelo ken kekemoke te. Ken kekemoke kasike, ku nakalem kaim atuk seiw mak fendewko, wamde tololewka! ");
INSERT INTO bhl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kate, ku seiw mak watemokolew kate, u ukalem angin ilo koyemomin ibolow kelinba kelu tewe, ku fawtuk ayem weng dunemselew weng be kolewko, Kenan aneng fian em waneng mak dulewolewka!’, nangse te. ");
INSERT INTO bhl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Beli, kame kuinei, ne uneko, kawin tem ok dim kel Sunbin-Got elo weng bokolewi te. Elo bokolewomeli: ‘Yawe kutaka! Ku nem kamok Abalakam em Sunbin-Got kute te! Kame nelo dokonemewi, nem kaleem teli beem mongom ete dem ken so keloka! ");
INSERT INTO bhl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ne kawin tem ok damin dim kale kel mobilii, waneng seiw mak ok dam tulu tewe, ne ulo dakalalomeli: ‘Kom ok sen dem so ok mak dunemew kano, ne wano yo!’, wangoki te. ");
INSERT INTO bhl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Wangii, u yan weng bokonemomelu: ‘Kenka, ok wana! Waneko, kamel imikal ok duyemoki te.’, nangu tewe, ne fein kal kelite: Yawe Sunbin-Got ku waneng buulo nakalem kamok em min em kalel galmoselew kai!’, dangesi te. ");
INSERT INTO bhl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Dangii, Elebeka u abiw mutuk koleweko, ok sen kingtiko, telesu te. Teleko, kawin tem ok kabalak elo ok dam uneko, iti tikin matem tului, ne ulo dakalalalomeli: ‘Ku ok mak dunemew kano, ne wano yo!’, wangesi te. ");
INSERT INTO bhl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Wangii, um kingti telbu ok sen be de mit dalin tew keko, ok wal dinemeko, bokonemomelu: ‘Ok wana! Waneko, kamel bikati ok duyemoki te.’, nangeko, u fein uneko, kamel ilo ok duyemesu te. ");
INSERT INTO bhl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Duyemui, ne ulo dakalalomeli: ‘Ku kanem mun a?’, wangii, usik yan weng bokonemomelu: ‘Ne Nakol so Milka so yemkal biim min Betuel em aul te.’, nangesu te. Nangui, ne teing tabum so, mutum bok so, kisol fian eisneng beso duumeko, ");
INSERT INTO bhl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Yawe Sunbin-Got em mit katin bukbuk angeko, kalfong so gatak wakas angeko, nakalem kamok Abalakam em Sunbin-Got Yawe em wiin fian daolewsi te. Nimtew angom? E nelo nakalem kamok Abalakam em ning em mulkon um dim nemde telese kasike. Kame, ne ulo Abalakam em min Aisak elo kulok angomi, wamde toloki te. Wamde telii, e ulo fein kuloke te. ");
INSERT INTO bhl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Keko beli, kame, yu nelo kilele yan weng mak bokonemoliwka! Yu nakalem kamok Abalakam elo ken kiol kuw kukuw kelomin ibolow kelewboliw beni, ba? Yu akalem ibolow fukuneko, nelo nomin eisneng mak ibolow fukunbiliw be, kilele bokonemoliwka! Bokonemiw tewe, nakal nakalem unomin deiw atemoki te.”, yangeko, dakalako, bokoyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Yangei, Alaban so Betuel so yelim i yan weng bokolewomeliw: “Yawe Sunbin-Got akalem ete kanelewse kasike, nu mesesem eisneng mak nam kesomi, “Babo!”, kanguw te. ");
INSERT INTO bhl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ku Elebeka so, makuw unesomeliwi, u kom kamok beem min kalel keloku te. Nimtew angom? Yawe Sunbin-Got e nulo kilele kukuyemse kasike.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Dangiwi, Abalakam em aluwbamin kunum be ikalem bokolewsiliw weng be kiliko, gatak wakas angeko, Yawe Sunbin-Got em mit elo keko, em wiin fian daolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Daolewsomelei, e kait on kisol fian banban so, ilim on kisol fian so, kuluko, Elebeka ulo duumse kale. Duumeko, mesesem eisneng on kisol fian so mali mak ukalem auk so, fik so, yat ilo amen amen keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Keyemsomelei, anfel e, Abalakam em aluwbamin kunum so akalem angin bi so, i wanin wanbiko, akalsiliw kale. Akaleko, iti kutim daneko, alik im teinsiliw ding dim bakate, aluwbamin kunum be Elebeka yelimel ilo bokoyemomele: “Kame akati, ‘Ken kuw!’, nangiw kano, ne iti uneko, nakalem kamok em mit mewso unoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Yangei, Elebeka um auk so fik so bi elo bokolewomeliw: “Babo! Waneng seiw buso kale kel siliwi, king kel ding fenoliwka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Dangiwi, Abalakam em aluwbamin kunum be yan weng bokoyemomele: “Yu nelo kanelom ‘Bayo!’, nangokoliw te! Yawe Sunbin-Got e nem deiw kiol kuw dem ken so kenemse kasike. Feinka! Ne iti uneko, nakalem kamok em mit mewso unokika!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Yangei, i elo yan weng bokolewomeliw: “Nu Elebeka ulo gaaumuwi, u tulu kano, ulo dakalaluma! Um angoku um ibolow fukunin bete kuw gelewuma!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Dangesomeliwi, i Elebeka ulo bokoumomiliw: “Ku kom ibolow fukunin mak nulo bokoyema! Ku kunum kale so unokolew beni, ba?”, wangiwi, u yan weng bokoyemomelu: “No, ne eso makuw unokika!”, yangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Yangui, Elebeka so, ukalem non wamgibu waneng bu so, Abalakam em aluwbamin kunum eso, akalem angin iso, alik alik im unomin memen kesiliw ding dim bakate, ");
INSERT INTO bhl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","waneng seiw buum angin i Elebeka ulo weng bamki so weng mak bokoumomeliw: “Nukalem nawkolon kutaka! Sunbin-Got e kulo bamki so kekemei, kom aul dukulokolew i banso banso kelokoliw tako! Kaneliwi, aul kailokoliw muluwel biim kitil e fian kuw kesomeliwi, ite keko, maka ilo kalak da koyemokoliw te!”, wangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Wangiwi, Elebeka so, ukalem aluumbamin waneng iso, alik alik i uneko, kamel im dim tein yak yak keliwi, Abalakam em aluwbamin kunum e folei, i elo gelew unsomeliwi, aneng be fein kolew unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","63","Unesomeliwi, ding mak kabalak e, i iti Abalakam em bise aneng kalo talsiliw kale. Beli, Aisak em kawin tem ok em wiin e Belokiloi iti koleweko, akalem kuluse kawin anung Negew kalo uneko, ka kel teinse ding kabalak e, e ka kel kakabomelei, ibolow fukunin fukunin mak kesomi, Sunbin-Got so weng bokose kale. Bokolei, aneng kuinse ding dim kabalak e, e atemete: Kamel samal mali mak singam yak talbiliwi, yetemeko, yol angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Angei, Elebeka ukal Aisak elo singam elote atemeko, fongate akate kamel im teineko, talsu dim koleweko, ");
INSERT INTO bhl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Abalakam em aluwbamin kunum beelo dakalalomelu: “Kunum miyak talbe be kante ya?”, dangui, e yan weng bokoumomele: “Be nem kamok Aisak ete te!”, wangse kale. Wangei, u ilim mak kuluko, ukalem kiingen net kasisu kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kiingen net kasisalui, Aisak e telei, aluwbamin kunum be elo kanese sang alik alik be kilele bokolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Bokolewsomelei, Aisak e Elebeka ulo akalem kuansu auk Sala um samal im kal benemin am elo wamde unse kale. Unesomelei, e Elebeka ulo fein kuluko, ulo ibolow mutuk fian kuw keumsomelei, yemkal i ka kel alenaliw kale. Bomeliw kasike, Aisak e auk um kuansu ilum beem sakik be de mit dase kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Beli, deiw mak ding mak, Abalakam e iti waneng mak kuluse kale. Waneng buum wiin e Ketula. ");
INSERT INTO bhl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kulusomelei, waneng bu gung kel muluwel mak dukusu kale. Muluwel biim wiin e kanekote: Mak e Simalan e, mak e Yoksan e, mak e Medan e, mak e Midian e, mak e Isbak e, fe e, Sua ete te. ");
INSERT INTO bhl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Um min Yoksan e aul alew dukuse kale. Mak em wiin e Seba e, mak em wiin e Dedan ete te. Dedan e Asul angin so, Eletus angin so, Eleum angin so, alik alik biim kunum mongom kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ketula um min Midian e Efa so, Efel so, Kanok so, Abida so, Eleda so, teingabi kel kunum biim alew kese kale. Muluwel alik alik bi, Abalakam em afam waneng Ketula buum aul dukuko, kailsu muluwel kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abalakam em kuaninba keko, bise ding kabalak e, e akalem on kisol mesesem mesesem eisneng alik alik be akalem min Aisak elo kuw dulewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Dulewse kate, akalem afam waneng buum muluwel bikal on kisol mesesem eisneng mak amen amen keyemse kale. Keyemsomi, ilo ataan tele beem dulum kalo yamde uneko, bokoyemomele: “Yu kanelom Aisak em mit mewso tele tele kelokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Keko beli, Abalakam em itol e 175 kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Kesomelei, e kunum fasel sel keko, akalem fukunin beki kuw kesomi, menew ibolow so kesomi, fe, kuanse kale. Kuaneko, imisik kuansiliw awalik kumel im fom finik am biliw dim elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Unei, akalem min alew Aisak so, Ismael so, aso i ikalem alew sel em fom be Makfela tum tem kel dawkusiliw kale. Makfela aneng be Mamele em ais tem ninit dim em ataan tele dulum dim mewso ke alenale kale. Sua kel e, Abalakam e aneng be Kit angin Sokal em min Efelon beem teing dim kel wese kale. Ka kel, e akalem kalel Sala um fom akal wamkuse kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Keko beli, Abalakam em kuanse ding dim bakate, Sunbin-Got e Abalakam em min Aisak beelo bamki so kelewse kale. Kelewei, Aisak e kawin tem ok Belokiloi em mit mewso teinse kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Kale kel Ismael em muluwel dow im sang bete te. Sua e, Abalakam e akalem kalel Sala um weng afak Isiw aneng fian em waneng Kagal ulo kulusomelei, e ulo aul duumei, u Ismael dukusu kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Dukului, Ismael akal muluwel banban kailse kale. Emisik min em wiin e Nebayot te. Em teben em wiin e Kedal, mutuk im wiin e Atbel e, Miwsam e, ");
INSERT INTO bhl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma e, Duma e, Masa e, ");
INSERT INTO bhl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Kadat e, Tema e, Yetul e, Nafis e. Fefe min em wiin e Kedema ete te. ");
INSERT INTO bhl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Be Ismael em muluwel kalun kel im wiin bakate. Kalun kel kunum muluwel biim muluwel dow bi kalun kel kunum mongom kesomi, ikalem abiw abiw wiin amen amen keyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Keyemsomeliwi, Ismael em itol e 137 kesomelei, fe e, kuanse kale. Kuaneko, akati awalik kumel im fom finik am biliw dim elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Unei, Ismael em muluwel bi Kawila aneng fian elo uneko, Sul abiw mutuk fian teleko, aneng beem tele tele mutuk dim ka kel teinsiliw kale. Sul abiw mutuk fian be Asilia kalo unakabiliw beem deiw tokon dim kel, Isiw aneng fian beem ataan tele dulum elo gesiliw kale. Kasike, Ismael em muluwel dow i mali Abalakam em muluwel dow iso mewso kelew kelew kelinba kesomi, imikel kuw amen amen kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Sang be Abalakam em min Aisak em talfut kese em sang te. ");
INSERT INTO bhl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Beli, Aisak em itol e 40 kesomelei, e Alam kunum Betuel em mun Elebeka ulo kuluse kale. Um fik e Alaban kesomelei, Mesofotemia aneng fian em kasel kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Keko beli, Aisak em kalel bu kumun du keko, aul banim kesu kasike, um imok e Yawe eso weng bokolewei, e em bokolewse weng be fein kiliko, Elebeka ulo dokoumse kale. Dokoumei, u aul kumun kesomi, ");
INSERT INTO bhl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","awang men kumun kesu kale. Kesomelui, aul bi kumun iw biliw kayak e, aso i bonge bonge keko, gansiliw kasike, auk Elebeka u gal keko, bokolomelu: “Yakei! Ne ilum fian mak kuli kai!”, angeko, Yawe eso beem dulum weng mak bokolewsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Bokolewui, Yawe e yan weng mak bokoumomele: “Kom kunum tem be kunum mongom alew mak biliw kasike. Aso im dow mongom e amen amen keko, mak e kitil nam kelei, mak e dus nam keloke te. Ning beem kitil e fik beem kitil bakilewoke kasike, fik be akalem ning beem afak keboke te.”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Wangei, fein e, u ding feneko, bomelui, fe e, Elebeka u awang kunum aul alew mak dukusu kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Dukului, emisik aul be kalim kuw sese olol nam samal kalim atew kese kasike, em wiin e Iso dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Beli, em teben kunum aul malak talse be awkunum em golgol beelo teing falala talse kasike, akalem wiin e Sekow dangsiliw kale. Beli, Elebeka um awang men dukusu ding dim be, Aisak em itol e 60 kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Beli, awang kunum biim tanbel kesiliw ding kabalak e, Iso e samal amin kunum sel kebomelei, kut kuw kakamalele kale. Kate, Sekow e am dim kel menew felit angeko, alenale kunum kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Keko beli, Aisak e kut samal wanomin ibolow fian kese kasike, e kut samal amin kunum Iso elo ibolow mutuk fian dulewale kale. Dulewale kate, auk Elebeka u am mewso kakamale kunum Sekow beelo ibolow mutuk fian kelewalu kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Deiw mak ding mak kabalak e, Sekow e kamge eisneng so wanin mak fuse kale. Beem ding ete, Iso e kut ete kiin kaim fingfing teleko, ");
INSERT INTO bhl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ning Sekow elo bokolewomele: “Yemen tew kuanika! Ku fongate akate kamge so wanin kafing be dunema!”, dangse kale. (Dangse weng beem mongom ete kawtiw i akalem wiin mak e Idom dangsiliw kale.) ");
INSERT INTO bhl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Dangei, Sekow e fik elo yan weng mak bokolewomele: “Ken ati. Ku kulew kate, kulew beem yan e kanekote: Ne kom fik atew kesomi, aatim em kuanoke ding dim e, ning nete kom kulokolew fan beelo fein kuloki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Dangei, fik Iso e yan weng mak bokolewomele: “Kenka. Kame kuw, yemen tew kuanomin kis kebi kasike, aatim em fan kuloki be kilele dokoneminba kenembe te. Ku nem fik atew keko, bolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Dangei, Sekow e bokolewomele: “Kame kuw weng fawtuk ayem weng mak bokonema!”, dangse kale. Dangei, Iso e fein weng fawtuk ayem weng mak bokolewei, ning Sekow be akalem fik beem emisk emdiw kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Keko beli, Sekow e Iso elo belet wanin so abal wanin ok fuse be dulewei, Iso e teineko, waneko, kumun gui angeko, fokfok moko, sak unse kale. Beemdiw ete, Iso e fik em bamki kuloke so, on kisol kuloke so, alik alik beelo ibolow banban kelewinba kesomi, sak desi kuw kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Deiw mak ding makak e, olfut fian mak Kenan aneng fian kalo talse kale. Olfut be, suaem Abalakam em bise ding beem olfut fian beemdiw te. Kasike, Aisak e akalem teinse aneng fian beelo koleweko, Filistia kawtiw im emisik kamok fian Abimelek beem alenale abiw mutuk fian Gelal kalo uneko, ka kel teinse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nimtew angom? Yawe e teleko, Aisak elo bokolewomele: “Ku kanelom Isiw aneng fian elo unokolew te! Ku nanew kalekemoki aneng mak elo uneko, ka kel teinolewka! ");
INSERT INTO bhl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Teineko, ka kel kakin kunum atew kebokolew kate, ne kuso bomi, bamki so kekemoki te. Kate kakabelew aneng fian kale, ne kulo, kom muluwel dow biso alik alik yulo fein duyemoki te. Nimtew angom? Weng ayem fawtuk weng mak kalew Abalakam elo dulewsomi, weng be itel nam kolewi kasike. ");
INSERT INTO bhl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ne elo bokolewomeli: ‘Kom muluwel al kelokoliw be, fial galgul atew kesomeliwi, ne ilo aneng fian kale kel fein duyemoki te. Nem bamki so dukembi beem mongom ete kawin dim kunum waneng alik alik ikati bamki so keyemoki te.’, dangsi kasike. ");
INSERT INTO bhl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nimtew angom? Abalakam e nem bokolewsi weng so, nem kukuyemin sawa kukulewsi weng so, alik alik be kilele wosuko, gelewemale kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Dangei, Aisak e Gelal abiw mutuk fian kel teinse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Beli, beem ding dim kabalak e, abiw mutuk fian beem kasel i Elebeka watemeko, buum dulum elote Aisak elo dakalalomeliw: “Waneng bu kante ya?”, dangsiliw kale. Dangiwi, Aisak e yan weng bokoyemomele: “U nakalem waneng aul ute te.”, yangse kale. Nimtew angom? E finganeko, ibolow fukunomele: “Nem kalel Elebeka u waneng atite fitumin bi watebomin so kesu waneng kebu kasike. Mesik esik abiw mutuk fian kasel bi ulo watemsomi, ulo takulu kulomin ibolow kebiliwi, nelo neniwi, ne kuanoki kai!”, angeko, finganse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Keko beli, im tiak ding abiw mutuk fian ka kel alenaliw ding dim e, deiw mak ding mak kabalak e, Filistia kawtiw biim emisik kamok fian Abimelek e akalem am kel teinbomi, am tem elote kut kiin angse kale. Angse ding dim be, e atemete: Aisak e akalem kalel Elebeka ulo falal keumeko, kalfong keumbelei, yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Yetemeko, Abimelek e Aisak elo gaaneko, bokolewomele: “Ebo! Aisak kutaka! Ku fongate akate tala o! Waneng kale kukalem kalel kasike! Nimtew angom ete ku nulo dasuw dasuw keyemsomi, ‘U nakalem waneng aul ute te!’, yangakabelew a?”, dangeko, sakala dangeko, dakalase kale. Dakalalei, Aisak e yang weng mak bokolewomele: “Ne finganeko, ‘Mesik esik mali kawtiw i ulo watemeko, takalunemeko, nelo neniwi, ne kuanoki kai!’, angeko, finganomelii, ne ilo dasuw weng be bokoyemsi kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Dangei, Abimelek e elo bokolewomele: “Nimtew angom ete ku nulo maka emdiw kesomi, wa kukuw be kukuyembelew a? Mak kunum mak waneng buulo watemeko, ibolow keumeko, e kitil keko, uso yemkal atew akale tewe, kom dasuw bokoyemselew beem mongom ete nute sen so kebomi, bokoluw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Dangeko, kitil weng kal mak akalem kawtiw alik alik ilo duyemeko, bokoyemomele: “Nimin kunum waneng ite mak kunum beso, em waneng buso, yemkal biilo wa kukuw keyemiw tewe, ne kaneyemiw kawtiw biilo yenii, i kuanokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Beli, Aisak em Filistia aneng fian kel bise ding dim bakate, Yawe e elo bamki so kelewse kasike, em kaise ais dem beem dem e banso gilako, nengso nengso kelei, yom kuw fok kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Kaneko beli, Aisak e kunum on kisol so, wiin fian so, em so kamok kunum fian kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","E meme so, siwsiw so, bulmakao so, sak weng afak kunum waneng so, mesesem eisneng banso demdem so kese kasike, Filistia aneng fian kasel i elo ibolow mesem so atemeko, ibolow tem kel on kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kelewsomeliwi, i tawal kuluko, Aisak em kawin tem ok miktem wanakabiliw dim alik alik biilo fakuluko, kasi yak yak koyemsiliw kale. Sua kel e, Aisak em alew Abalakam ete kawin tem ok miktem bi dikese kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Keko beli, aneng beem emisik kamok Abimelek e Aisak elo bokolewomele: “Ku kunum kamok kitil nam wiin so kebelew kasike, nu kom awan fingankabuluw te. Kasike kame, ku nukalem aneng kale asina!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Dangei, Aisak e abiw mutuk fian be fein koleweko, Gelal abiw mutuk fian em mewso memget beem mit kalo uneko, ka kel teinse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ka kel teinsomelei, min e alew Abalakam em sua kel dikese kawin tem ok miktem alik alik biilo iti kileleko, ok miktem sua kel em wiin bokoyemse wiin ming bakate iti bokolew bokolew keyemse kale. Nimtew angom? Abalakam e kuanse ding kabalak e, ka kel teinsiliw Filistia kawtiw bi alik alik em kawin tem ok miktem banban biilo iti kasi kolew yak, kolew yak, keyemiwi, ok miktem bi alik alik banimsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Keko beli, Aisak em sak weng afak kunum i uneko, teinsiliw memget kale kel, iti kawin tem ok miktem mak so mak fenem unsiliw kale. Unesomeliwi, i mali kawin tem mak dikesomi, fein, ok miktem mak telei, atemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Atemsomeliwi, Gelal abiw mutuk fian em samal yetebin kawtiw mali mak i teleko, Aisak em samal yetebin kawtiw biilo weng on kuw dulew dulew kesomi, bokoyemomeliw: “Ok miktem kale nukalem te! Yom bate!”, yangeko, bonge bonge kesiliw kale. Kesomeliwi, Aisak e kawin tem ok miktem beem wiin e “Esek” angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Angei, i iti kawin tem ok miktem mak fensomeliwi, dikeko, fein, ok miktem mak telei, atemsiliw kale. Atemsiliw kate, aneng beem kasel i iti weng bonge bonge keyemeko, weng on kuw dulew dulew kesiliw kale. Kesomeliwi, Aisak e kawin tem ok miktem beem wiin e “Sitna”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Angei, i iti nanew dim elo uneko, kawin tem ok miktem mak fensomeliwi, dikeko, fein, iti ok miktem mak telei, atemsiliw kale. Atemsomeliwi, mak be weng bonge bonge kelinba kesiliw kasike, Aisak e kawin tem ok miktem beem wiin e “Elekobot”, angse kale. Nimtew angom? E bokolomele: “Yawe e bamda aneng fian mak yemense kasike kame, nu ki keko, bamki so kesomi, nengso nengso kelokoluw kai!”, angse kasike. ");
INSERT INTO bhl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Angesomelei, teinbomelei, iti aneng kale koleweko, uneko, Belseba abiw kalo unesomi, talse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Telesomelei, kutiliw kabalak beem ding dim bakate, Yawe e Aisak em dim fiteweko, bokolewomele: “Nete kuw kalew Abalakam em Sunbin-Got nete te. Ne diwkuw kuso bi kasike, ku kanelom finganemokolew te! Ne nem weng afak kunum kalew Abalakam em ibolow beelo fukunbi kasike, ne kuso, kom muluwel dow iso, alik alik yulo bamki so keyemeko, yulo banban nengso nengso keyemoki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Dangei, ka kel e, Aisak e Yawe elo aik ayem mak fakalako, Yawe em wiin fian daolewse kale. Daolewsomelei, e akalem samal kal benemin am kanis daung kanel daung gese kale. Keko beli, em sak weng afak kunum i ka kel e iti kawin tem ok miktem mak dikelomin unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Dikesiliw ding kabalak e, emisik kamok fian Abimelek so, akalem akunum Akusat so, akalem emisik wonuk so kunum Bikol so, kunum alemsal bi Gelal abiw mutuk fian koleweko, Aisak em fukun talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Teliwi, Aisak e ilo dakalalomele: “Sua e, yu nelo maka kenemsomi, ‘Ku asina!’, nangsiliw kasike kame, yu nimtew mongom angom nem fukun teliw a?”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Yangei, i yan weng bokolewomeliw: “Nu kilele atemuwete: Yawe fein kuso alakabe kasike, numikel kuw bokolew bokolew keko, ‘Kitakamin weng mak kom tele num tele dukuluma!’, angeko, telesuluw te. ");
INSERT INTO bhl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Kitakamin weng be kanekote: Alik alik nu kanelom mali nulo maka keyemsomi, anane kemokoluw te! Fein! Alik nu nukalem Gelal abiw mutuk fian bisuluw beem kukuw ken kukukemsuluw beem kukuw kuw kukuyemboluwka! Nimtew angom? Kute kuw Yawe em bamki so aluwkabe kunum kebelew kasike.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Dangsiliw ding im bakate, Aisak e wanin fian mak kelewsomelei, i wanin so wain ok so wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Waneko, banimsiliw ding ete, kutim mililiw danei, Aisak so, alemsal kunum biso, alik alik i kitakamin weng be dukusiliw kale. Dukusomeliwi, Aisak e ilo “Nakunum kumel yukal o!”, yangei, i fein elo koleweko, ikalem am dim kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Biim unsiliw ding bete, Aisak em ok miktem dikelomin unsiliw weng afak kunum i fein ok miktem mak telei, atemeko, Aisak elo bokolewomeliw: “Nu iti ok miktem mak telei, atemsuluw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Dangiwi, e kawin tem ok miktem beem wiin e “Siba”, angse kale. Angse kasike, ok miktem beem mit mewso be abiw mutuk fian beem wiin e sua akal, kame akal, “Belseba”, angakabiliw te. ");
INSERT INTO bhl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Beli, Iso em itol e 40 kese ding dim kabalak, e uneko, waneng alew mak yamduse kale. Sun waneng u Beli em mun kesomi, um wiin e Yudit ute te. Afam waneng u Elon em mun kesomi, um wiin e Basemat ute te. Waneng alew bi Kit waneng ite te. ");
INSERT INTO bhl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","I alew Aisak so, auk Elebeka so yemkal biim ibolow ilum fian kuw duyemaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Beli, Aisak em fasel keko, mesesem mesesem eisneng mak kilele ateminba kesomi, mewso atin kuw kiin sukul kunum kese ding kabalak e, e akalem emisik dukuse min Iso beelo gaaleweko, bokolewomele: “Min kutaka! Ku kame kaleelo tala o!”, dangse kale. Dangei, Iso e em weng be kiliko, geleweko, yan weng bokolewomele: “Ne teli kale eli!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Dangei, Aisak e bokolewomele: “Ne kame faselko, ‘Nal em tit ete ne kuanoki yake?’, angbomi, akokow kebi te. ");
INSERT INTO bhl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kasike, ku wonuk so on bot so kuluko, kut uneko, samal mak anko, de tala o! ");
INSERT INTO bhl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","De telew kano, nem ibolow kelewkabi wanin fuko, de telewi, ne wanesomi, fe e, kulo bamki so kekemoki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Dangei, fein, Iso e kut samal mak fenem unse kale. Aisak em min elo bokolewse ding dim bakate, Elebeka u imok em weng ukati kilisu kale. Kilisu kasike, Iso em samal fenem unse ding kabalak e, ");
INSERT INTO bhl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","u um min Sekow elo bokolewomelu: “Kae, min kutaka! Kalew em kawkunum elo weng mak bakalewbelei, ne kilili te. ");
INSERT INTO bhl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","E bokolewomele: Ku wonuk so on bot so kuluko, kut uneko, samal mak anko, de tala o! De telew kano, nem ibolow kelewkabi wanin fuko, de telewi, ne wanesomi, fe e, kulo bamki so kekemoki te.’, dangbelei, ne kilili te. ");
INSERT INTO bhl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kasike kame, nem weng kale kilele kilila! ");
INSERT INTO bhl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ku fongate fongate akate uneko, meme im biliw dim uneko, imok men belibeli tol alew mak yemde tololewka! Yemde telew kano, ne kalew em ibolow kelewko, wanakabe wanin fuloki te. ");
INSERT INTO bhl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Fuku dukemii, ku de uneko, kalew elo dulewi, e wanesomi, kulo bamki so kekemsomelei, e kuanoka.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Dangui, Sekow e auk ulo yan weng mak bokoumomele: “Be ken kate, Iso esik kalim sil kunum kebe beli! ");
INSERT INTO bhl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Wee! Mesik aatim e nem kal melenemeko, ‘Ku dasuw kenembelew kai!’, nangoke kasike. Kanesomelei, e Yawe eso weng bokolewei, e nelo yakok kenemsomi, bamki so mak nam duneme sako!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Wangei, u menew weng mak bokolewomelu: “Min kutaka! Ku kanelom sakik kemokolew te! Kalew em yakok weng kulokolew be nete kuw kom abin kuloki te. Kasike kame, ku fongate akate uneko, meme men alew mak aneko, yemde teleko, dunema.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Dangui, fein, Sekow e uneko, meme imok alew mak aneko, yemde teleko, auk ulo deum talse kale. Deum telei, auk u alew Sekow em ibolow kelew wanin mak fulewsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Fulewsomelui, Elebeka u ukalem emisik dukusu min Iso beem ukalem am dukube ilim ken be kuluko, um emteben dukusu min Sekow elo minggilewsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Minggilewsomelui, u meme im kalim be kuluko, ukalem min beem gatak dim so teing dim so kasi kolewsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Koleweko, wanin abal fumin so belet wanin so kuluko, min Sekow dulewui, e deko, alew em mit mewso unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Uneko, alew em mit teleko, bokolewomele: “Kae, aatim a!”, dangei, alew Aisak e yan weng bokolewomele: “Wee! Ku kante a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Dangei, Sekow e yan weng bokolewomele: “Iso, kom emisik dukuselew min neli! Ne kukalem weng geleweko, wanin mesesem alik alik memen keli kasike, ku kame teineko, samal wanin dekem teli kale, wana! Wanesomelew kano, bamki so kenema!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Dangei, Aisak e iti bokolewomele: “Ku nolom ete ibokow samal an de telew a?”, angeko, elo dakalase kale. Dakalalei, Sekow e yan weng bokolewomele: “Kom Sunbin-Got Yawe e dokonemsomi, nelo duneme te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Dangei, e elo bokolewomele: “Kame, mewso mew ka tala o! Telew kano, ne kom kal melelewsomi, diw katemsomi, kilele kal keko, bokolomeli: ‘Ku fein nakalem emisik dukusi min Iso kute beni, ba!’, angoki te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Dangei, Sekow e alew em mit mewso unei, e em kal dim elo teing kuw teing kuw melelew melelew kesomi, bokolewomele: “Ne kom bokonembelew weng be kililko, ‘Sekow beem weng akate tew kebelew kai!’, angbi kate, kom kal dim kalim sil be Iso akate tew kebelew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Kasike, Sekow em kal dim be Iso em kalim sil emdiw kese beem mongom ete alew Aisak e Sekow elo kilele kal kelinba kesomi, elo bamki so kelewomin memen kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Beem ding dim e, e iti dakalalomele: “Ku nelo fein bokonema! Ku fein nakalem emisik dukusi min Iso kute ye?”, dangei, Sekow e yan weng bokolewomele: “No! Ne fein Iso nakalem nete te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Dangei, Aisak e elo bokolewomele: “Kenka. Kame, samal wanin dunema! Dunemewi, ne nakalem min kom samal wanin be waneko, ki kesomelii, ne bamki so kekemoki te.”, dangse kale. Dangei, Sekow e wanin so, wain ok so kuluko, alew Aisak elo dulewei, e fein wanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Waneko, ki kesomelei, e min beelo bokolewomele: “Kame, nem mit mewso telesomi, nelo falal kenema!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Dangei, Sekow akati fein uneko, alew em mit mewso teleko, falal kelewse kale. Kelewi, e min em ilim kamge kimileweko, ‘Fein! Iso ete kai!’, angeko, bamki so keleweko, bokolewomele: “Feinka! Nem min em kamge e Yawe em bamki so kelewse em kut mutuk em satadel kamge atew te. ");
INSERT INTO bhl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Sunbin-Got e kulo bamki so kekemoka! Kom musun beem dim e diwkuw diwkuw fial ok banso mak ok abakemboka! Komwit dem so, wain ok so, alik be beki kuw dukakemboka! ");
INSERT INTO bhl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nanew aneng aneng angom biim kawtiw alik alik i kom weng afak bin kawtiw keboliwka! Kawkunum kumel so, kauk um muluwel dow iso, alik alik i makuw kom afak kuw boliwka! Nimin kawtiw ite mak kulo yakok kekemiw tewe, Yawe e kawtiw biilo fein yakok keyembomaka! Kate, nimin kawtiw ite mak kulo bamki so kekemiw tewe, Yawe e kunum waneng biilo beemdiw keyemeko, ikati bamki so keyembomaka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Dangei, Sekow e alew elo iti koleweko, akalem am unse kale. Em gui unse ding dim bakate, fik Iso e kut elote samal fenko, de talse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","De teleko, samal wanin fusomi, alew em mit de uneko, bokolewomele: “Aatim kutaka! Ku teineko, kut samal gis wanin dekem teli kale wanesomelew kano, bamki so kenema!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Dangei, Aisak e yol angeko, dakalalomele: “Wee? Ku kante?”, dangei, Iso e yan weng bokolewomele: “Iso kom emisik dukuselew min neli!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Dangei, Aisak e yol yol fian kuw mak walwal kuw kilikili keko, dakalalomele: “Ebo! Ku telinba selewi, kante samal wanin gis mak denem telei, ne wani ye? Ne waneko, emisik tele kunum beelo bamki so kelew kembi kasike, nakati ki keko, nam alwol kelii, esik diwkuw diwkuw bamki so keboke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Dangei, Iso e alew Aisak em weng kilisomi, gaanin fian mak gaaneko, sakik ilum kuluko, amemin fian mak kesomi, alew elo kitil weng mak bokolewomele: “Eke, aatim a! Nelo nakati bamki dunema! Bamki dunema!”, dangeko, geense kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Geenemselei, Aisak e yan weng mak bokolewomele: “Kukalem ning nelo dasuw kenemsomi, kukalem dukemoki bamki be ete kuw kule te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Dangei, e alew elo bokolewomele: “Sekow wiin beem mongom ete ‘Ibolow Kulak Kulak Kunum’ kebe te. Kesomelei, ning be fein akalem wiin beemdiw kele kai! Kame, emteben em ding dim bakate, e nelo fimdi famde funum kukuw kukunemse te. Emisik ding dim bakate, e nelo fimdi famde funum kenemei, ne beem mongom ete weng fawtuk ayem mak bokolewomeli: ‘Aatim em fan amen amen kulokoluw ding dim bakate, ning ku fik nem emsik kuloki eisneng be emisik kulolewka!’, dangsi te. Kame emteben em ding dim bakate, e iti fik nemdiw kesomi, bamki fian akal kule te! Kae, aatim a! Ku bamki makso nakati dunemsomi, bamki so kenema o!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Dangei, Aisak e elo yan weng bokolewomele: “Ibo! Min kutaka! Ne kukalem ning beelo kukalem kamok emdiw mo kolew kembi te. Akalem awkunum kumel alik alik ilo akalem afak dulewsomi, wit dem so, wain ok so, alik alik be beki kuw dulewi te. Nimtew eisneng mak kulo dukemsomi, kulo bamki so kekemboki ya?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Dangei, Iso e kitil keko, alew elo dakalomele: “Aatim kutaka! Bamki gel mak be sako? Be tewe, ku nelo akati dunema o!”, dangeko, amemin fian fian mak amese kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Amemselei, alew Aisak e elo akati bamki so weng mak bokolewomele: “Ku kawin tugul so beem dim kale koleweko, nanew dim kel teinolewka! Kutiliw em fial ok e kom musun aneng elo nam ok abakemboka! ");
INSERT INTO bhl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ku wonuk so kunum kitil nam kebomi, diwkuw diwkuw maka iso ganen kakamolewka! Ku kukalem kawkunum em weng afak kunum kebolewka! Kate, deiw mak ding mak kabalak e, ku kitil kuw kesomi, kawkunum em dukemkabe ilum beelo atin kuw koleweko, em afak bin akal kolewokolew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Beli, Sekow em alew em bamki yakut kelewse beem mongom ete Iso e ning beelo ibolow kaim alel kelewsomi, ibolow fukunomele: “Sukum ding kuw kabalak e, aatim e kuaneko banimoke te. Beem ding dim e, ne Sekow elo alii, e kuanoke te!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Angse kate, Elebeka u Iso em bokose weng be kilisu kasike, u ukalem emteben dukusu min Sekow elo gaalewsomi, elo bokolewomelu: “Kutaka! King Iso ibolow kaim alel kekembomi, kulo kenomin memen kebe kasike, ");
INSERT INTO bhl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ku nem weng kale kilele kilila! Fongate akate ku memen keko, Kalan aneng fian kalo fon uneko, kukalem kokois Alaban em fukun unolewka! ");
INSERT INTO bhl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Kaneko beli, king em ibolow mesem be gilil kele kano, iti tololewka! ");
INSERT INTO bhl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Em ibolow mesem gililko, banim keloke ding dim e, ne mali kawtiw mak yemdalii, i kulo kalan weng dekem tolokoliw te! Ibo! Nakalem muluwel alew yulo kanelom makmak ding kuw makuw banimnemokoliw te!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Dangeko, imok Aisak elo bokolewomelu: “Ne emisik dukusi min Iso beem Kit aneng kaleem waneng alew biilo atin kuw gal keyemi te. Kaneko kasike, emteben min Sekow bakati Kit aneng fian beem waneng mak kule tewe, finik so bomin e nelo gal kenemei, ne kuanomin ibolow keloki te.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Dangui, Aisak e Sekow elo gaaleweko, iti bamki so kelewsomi, bokolewomele: “Min Sekow kutaka! Kame, ku nelo kitil nam weng mak bokonemomelew: ‘Ku kanelom Kenan aneng fian kaleem waneng mak kulokolew te! Itel bate!’, nangolewka! ");
INSERT INTO bhl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kasike kame, ku uneko, Mesofotemia aneng fian elo uneko, kauk um alew Betuel em aneng kalo unokolewka! Ka uneko, teleko, kokois Alaban em mun mak wamdolewka! ");
INSERT INTO bhl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kitil so Auk so Sunbin-Got e kulo bamki so kekemoke kasike, ku muluwel dow banso im kunum mongom kelokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","E Abalakam em dulewse bamki kuso, kukalem muluwel dow iso, alik alik yulo fein duyemoka! Sua e, Sunbin-Got e kame kokow kunum atew kakabelew Kenan aneng fian kaleelo Abalakam elo ‘Kulo dukemoki te!’, dangse kasike, em muluwel dow kuso, kom muluwel dow iso, alik alik yu aneng fian kale fein kuluko, beem dim teinoliwka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Dangeko, Sekow elo dabalalei, e Mesofotemia aneng fian em deiwkim ka uneko, Alam kawtiw im kunum mak em wiin e Betuel em min Alaban em fukun unse kale. Alaban be akalem so, Iso so, awkunum alew biim auk Elebeka buum fik ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Beli, Iso e kililete: “Aisak e Sekow elo iti bamki so kelewsomi, ‘Kenan aneng fian em waneng mak wamduko, de tololewka!’, dangei, Sekow e alew so auk so biim weng kiliko, geleweko, Mesofotemia aneng fian elo waneng mak kulomin unse te.”, angiwi, e kilise kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Kilisomi, ibolow fukunomele: “Aatim e nem Kenan aneng fian beem waneng alew biilo ibolow keyeminba kekabe kai!”, angeko, ibolow fukunse kasike, ");
INSERT INTO bhl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","e okis Ismael beem aneng kalo uneko, beem angin em waneng mak kuluko, afam waneng makso wamduse kale. Afam waneng buum wiin e Makalat. U Ismael, Abalakam em min em mun kelui, Nabayot em neng ute kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Keko beli, Sekow e Belseba abiw be koleweko, Kalan aneng fian elo unomin deiw gui unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Unbomelei, kuinei, e tum mak kuluko, kak kemen keleweko, akalse kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Akalbe ding kabalak e, kiin dem mak atemomete: Bul tiakim mak beem mongom ete kawin kel mosomi, anung e uneko, abiil tikin kel belei, atemse kale. Bul el be, Sunbin-Got em yemdakamin finik i gou tiw malak kebiliwi, yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yetemsomi, atemomete: Yawe em mit mewso teleko, bokolewomele: “Ne Yawe, kaliwol Abalakam so Aisak so im Sunbin-Got nete te. Aneng akalbelew kale, ne kukalem so, kukalem muluwel dow so, alik alik yulo fein duyemoki te. ");
INSERT INTO bhl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Kom muluwel dow i banso banso kesomi, kawin dim kale em yas atew kelokoliw te. Kesomeliwi, neng so, neng so keko, fian kelokoliw te. Yu ataan tele beem dulum elo, ataan tem une beem dulum elo, mali beleng, mali beleng beem dulum elo uneko, aneng aneng angom alik alik ka kel bomi, kakamokoliw te. Kusik nem bamki kulubelew kasike, kawin dim kaleem kawtiw alik alik ikal kom dim kel bamki so keyemoki te. ");
INSERT INTO bhl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nal em aneng mak unew tewe, ne nam kokemi te. Diwkuw diwkuw kamkitil moko, kamde kakamoki kasike, iti kukalem aneng kaleelo kamde toloki te. Feinka! Nem bokokemsi weng be ne itel fein kuw dem so keloki te.”, dangei, kiin dem sin atemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Atemei, Sekow em iti teinse ding kabalak e, e weng mak bokolomele: “Yake! Ne akokow keli kate, Yawe e kale kel alakabe kai!”, angeko, ");
INSERT INTO bhl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","yol angeko, finganin mak kuluko, gaanomele: “Ebo! Ne aneng kale finganbi te! Aneng kale Sunbin-Got em kawin dim kaleem alakabe am ete te. Abiil tikin em abisom dim kale eli!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Angesomelei, aneng daneko, kutim mililiw kele ding dim bakate, Sekow e moko, kak kemen kelewbe tum be kuluko, Sunbin-Got em ibolow fukunin tum atew molewsomelei, oliw dem ok kuluko, tum beem dim buselse kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Busel koleweko, aneng kaem wiin “Ulus” koleweko, wiin kikis mak duleweko, em wiin “Betel”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Dangei, fawtuk ayem weng mak Sunbin-Got elo bokolomele: “Kutaka! Ku nelo dokonemeko, nem singam aneng elo unemoki ding kabalak e, nelo kilele netemsomi, nem wanin so, kal dim em minggimin eisneng fein dunemokolew kasike, ");
INSERT INTO bhl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ne fein aatim em am elo uneko, iti ka kel ibolow menew so bi tewe, ne Yawe kulo nakalem Sunbin-Got kekemboki te! ");
INSERT INTO bhl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ku nelo fein dokonemew tewe, kom ibolow fukun kembomin beem mongom mo koli tum kale, Yawe kom wiin daokem kemin em abin mak keli te. Nem kisol eisneng mesesem mesesem beem king kel anung makmak be ne Yawe kulo fein dukakemboki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Keko beli, Sekow e iti uneko, bomelei, abiw ataan tele beem dulum elo unsomelei, ");
INSERT INTO bhl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","3","fe e, kawin tem ok miktem mak em tikin net kelewsiliw tum sesel mak atemse kale. Atemsomelei, siwsiw so meme so samal mongom alemsal mak tum sesel beem mimyak akalbiliwi, yetemse kale. Nimtew angom? Samal yetebiliw kawtiw alik alik biim ok miktem kalo talsiliw ding dim bakate, i ikalem samal ka biliw biilo “Ok yemenuma!”, angeko, ok miktem beem tikin net kelewbe tum fian beelo gilik kelewsomi, ok yemensiliw kale. Ok yemensomeliwi, i ok miktem beem tikin net kelewbe tum sesel be iti giliko, kawin tem kasi kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Beli, Sekow e yetebin kawtiw biilo dakalalomele: “Yutaka! Yu nalem kawtiw a?”, yangse kale. Yangei, i yan weng bokolewomeliw: “Kalan aneng fian kasel nute te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Dangiwi, Sekow e bokoyemomele: “Yu Nakol em min Alaban elo kal kebiliw beni, ba?”, yangei, i yan weng bokolewomeliw: “No, elo kal kebuluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Dangiwi, e iti dakalalomele: “Alaban e ken alakabe ye?”, yangei, i bokolewomeliw: “No, ken alakabe te. Alaban em mun Elesel u mineng siwsiw so meme so makuw talbu be watema!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Dangiwi, e bokoyemomele: “Ataan taw mutuk ding be akate, yu siwsiw so meme so sam iti yemde teliw kae? Yu ilo ok duyemeko, iti yemde uneko, i ikalem mesesem mesesem wanbiliw eisneng be wanbiliw kano!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Yangei, i bokolewomeliw: “Babo! Siwsiw so meme so samal alik alik biim teleko, makuw wensaniw ding dim bakate, nu kawin tem ok miktem beem tikin net kelewbe tum beelo gilik kelewsomi, ok yemenokoluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Beem ding dim e, Elesel u alew em siwsiw so meme so yetebin waneng kebisu kasike, Sekow em mali yetebiliw kawtiw iso weng bokose ding kabalak be, uso, ukalem alew em yemde talsu samal biso, alik alik ikati kalo talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Teliwi, Sekow e im teliw fein yetemeko, kawin tem ok miktem kalo uneko, kawin tem beem tikin net kelewsiliw tum sesel beelo gilik keleweko, akalem okis Alaban em samal biilo ok yemense kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ok yemeneko, kalfongeko, amemeko, Elesel ulo falal keumse kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Falal keumsomelei, e ulo bokoumomele: “Ne kalew em neng Elebeka um min nete te.”, wangei, u kilisomi, yakoko, alew elo bokolewomin unsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Unui, Alaban e mun um weng be kilisomi, fongate akate yako uneko, akalem talal Sekow em fukun uneko, elo kalfongdewko, falal kelewsomelei, akalem am elo debele unse kale. Debele unei, Sekow e akalem kanelewse sang alik alik be okis elo bokolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Bokolewsomelei, Alaban gaaneko, bokolewomele: “Feinka! Ku nakalem kaim anung kute te!”, dangse kale. Beli, kayow makmak banime ding dim bakate, Sekow e Alaban so bise kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Bomelei, Alaban e Sekow elo bokolewomele: “Ku nakalem mam te. Kasike, ku nam sak kuw aulnembamolewka! Kame nelo bokonema! Aluwbamin beem yan e nimtew ete ibolow kelewbelew a?”, dangeko, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Keko beli, Alaban e mun seiw alew mak dukulei, i ka alenaliw kale. Umisik dukuse mun um wiin e, Elea, umteben dukuse mun um wiin e, Elesel ute kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Elea u kiin butbi waneng kesu kate, Elesel ute minggibi butbi fituminbi kesu waneng atite kuw waneng ute kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Beli, Sekow e ilo kiin so yetemeko, Elesel ulo ibolow mutuk fian keumse kasike, e Alaban elo bokolewomele: “Ben kel itol mak ne kom umteben mun seiw Elesel buum waneng kalik beem angom sak kuw aluwkemoki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Dangei, Alaban e yan weng bokolewomele: “Kenka! Ku nakalem angin kasike, ne ulo kalfongso dukemi te. Nanew telemin kunum mak teleko, waneng seiw bu elo nam duyemi te. Kasike, ku ne so kuw bolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Dangei, fein e, Sekow e ben kel itol sak Alaban em aluwbamin aluwse kale. E Elesel ulo ibolow mutuk fian kuw keumse kasike, ben kel itol be, Sekow em dulum elote sak fong sukum ding kuw emdiw kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ben kel itol biim fefe ding dim kele ding dim bakate, Sekow e Alaban elo bokolewomele: “Tiak ding ben kel itol kame banimse te. Kame, ku kom mun seiw buulo fein dunemolewka! Dunemew kano, ne ulo wamduii, uso neso alew nu dabele dabele keluma!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Dangei, Alaban e wanin fian mak memem kesomi, abiw mutuk fian beem kasel alik alik ilo gaayemei, i fein kalfong wanin fian wanomin talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Teliwi, mililiw mutuk danei, Alaban e Sekow elo funum funum kelewsomi, akalem umisik dukuse mun Elea wamdeko, Sekow em akalkemin dim kel koumei, eso uso i fein yemkal kesomi, kule kule kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Kaneko beli, Alaban em akalem mun seiw Elea ulo Sekow elo dulewse em ding kabalak e, e sak weng afak waneng mak akalem mun uso wamde unse kale. Sak weng afak waneng buum wiin e Silfa ute kale. Keko beli, kutim dane ding dim bakate, Sekow e akalem wamduse waneng kilele watemeko, yol yol fian mak kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kelesomelei, e fongate akate okis Alaban em fukun uneko, bokolewomele: “Wee kutaka! Ku nimtew angom ete nelo dasuw funum funum kenembelew a? Ne Elesel um dulum elote ben kel itol mak aluwbamin fian mak aluwkemsi kate, kame kusik nelo funum funum kenemeko, Elea ulo dunem kembelew kae!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Dangei, okis Alaban e talal beelo yan weng mak bokolewomele: “Nukalem aneng kawitw im kukuw e kanekote: Umisik dukukabiliw aul isik kunum kuliw ete, nenggelel i ibik ete kuw kunum kulukabiliw te. ");
INSERT INTO bhl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Kasike kame, ben kel ding banimoke ding dim bakate, kalfong wanin akal banimei, ne umteben dukusi mun seiw Elesel bukati “Kom afam waneng keuma!”, kangeko, dukemoki te. Fein dukemoki kate, ku buum kulomin dulum elote iti ben kel itol mak auluwnembamolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Dangei, Sekow e “Kenka!”, dangeko, bomelei, ben kel ding banimse ding dim bakate, Alaban e fein akalem umteben dukuse mun seiw Elesel ukal Sekow elo dulewese kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Beem ding kabalak e, Alaban e sak weng afak waneng mak Elesel ukal duumse kale. Sak weng afak waneng buum wiin e Bilka ute kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Keko beli, Sekow so Elesel so ikati yemkal kesomi, kule kule kesiliw kale. Kesiliw kate, Sekow e afam waneng Elesel ulo ibolow mutuk fian keumeko, sun waneng Elea ulo kilele ibolow keuminba kebise kale. Kaneko beli, Sekow e iti ben kel itol mak okis Alaban em aluwbamin aluwdewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Aluwdewbabelei, Yawe e atemomete: Sekow e Elea ulo gal ibolow keumbelei, atemse kasike, e sun waneng Elea ulo dokoumei, u aul kumun kesu kale. Kesu kate, afam waneng Elesel u kumun du keko, aul kumuninba kesu kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Keko beli, Elea u um seiw kunum aul dukuko, em wiin e “Uluben” dangsu kale. Nimtew angom? U bokolomelu: “Yawe e nem kal ilum netemeko, dokonemse te. Kame, nem imok e fein ibolow mutuk so kenemoka!”, angsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Aneko, iti aul kumun so keko, iti kunum aul mak dukuko, bokolomelu: “Yawe e nem kal ilum be atenemeko, kilise te. Nem imok e nelo ibolow mutuk so keneminba kekabe kasike, ne iti aul kunum mak fakilewko, dukusi te.”, angesomi, aul beem wiin e “Simeon” dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Dangeko, iti aul kumum keko, kunum aul makso dukusu kale. Dukuko, bokolomelu: “Anfel e, nem imok e ibolow mutuk fian kenemei, ibolow ki makmak kebokoluw tako! Nimtew angom? Kunum alemsal mak kailsi kasike!”, angesomi, aul beem wiin e “Elibai” dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Fe e, u iti aul kumuneko, iti kunum aul mak dukuko, bokolomelu: “Yawe elo kuw dawsulemo!”, angeko, dukusu aul beem wiin e “Suda”, dangsu kale. Dangeko, iti aul makso dukulinba kesu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Beli, afam waneng Elesel u kumun du kesomi, aul mak dukulinba kesu kasike, u ukalem en sun waneng Elea ulo ibolow mesem keumeko, Sekow elo sakalale dangeko, bokolewomelu: “Aul mak dunema! Duneminba kelew tewe, ne fein kuanoki te.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Dangui, Sekow e kaisuw fian mak keumeko, afam waneng buulo kitil weng mak bokoumomele: “Yawe ete kuw kukalem kumun net kekembe kae! Nete Yawe ba kasike, ne ki keko, kulo aul mak nam dukemi te.”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Wangei, u yan weng mak bokolewomelu: “Ku Bilka, nem sak weng afak waneng buulo wamduko, aul mak duuma! Duumewi, u nem dulum elo aul mali mak kailuka!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Dangeko, fein, ukalem sak weng afak waneng Bilka ukalem imok Sekow elo dulewui, e um weng kili geleweko, Elesel um sak weng afak waneng Bilka buulo fein wamduse kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Wamdusomelei, Bilka u fein aul kumun keumeko, kunum aul mak dukusu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Dukusomelui, Elesel u bokolomelu: “Sunbin-Got e nelo diw netemsomi, nem dakalakamin akal wosuko, kunum aul mak dunemse kae!”, angsu kale. Angesomi, aul beem wiin e “Dan” dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Dangesomelui, Bilka u iti aul kumun keumeko, kunum aul makso dukusu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Dukului, Elesel u bokolomelu: “Nakalem en so bonge bonge kesomi, bakiumomin kitil kebi te.”, angsu kasike, aul beem wiin e Nafatali dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Beli, sun waneng Elea u atemute: Ukalem akati aul makso kailomin em deiw e banimumse kasike, u ukalem sak weng afak waneng Silfa ukati kuluko, imok Sekow em mit elo dulewui, e ulo wamduko, ");
INSERT INTO bhl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","aul duumse kale. Duumei, u fein seiw kunum aul mak dukusu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Dukului, Elea u bokolomelu: “Nete ken kelika!”, angeko, aul beem wiin e “Gat”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Dangui, Silfa iti aul kumun keko, iti kunum aul mak dukusu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Dukului, Elea u bokolomelu: “Yakai! Ne kalfong kalfong fian ati mak kuli te! Waneng angom alik alik i nelo netemeko, ‘Kalfong kalfong so waneng kuta!’, nangbokoliw te!”, angeko, aul beem wiin e “Asel” dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Beli, deiw mak ding mak kabalak e, wit dem em kulomin ding dim kelei, Uluben e uneko, akalem musun beem dim e ais meliw dem ban mak atemeko, kuluko, akalem auk Elea ulo deum talse kale. Deum telei, auk buum neng Elesel u meliw kemin ais dem beelo atemeko, en Elea ulo geenin fian mak geumeko, bokoumomelu: “Meliw dem mak nakal nemena! Nemena!”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Wangui, Elea u neng ulo kaisuw yan weng bokoumomelu: “Wee kutaka! Ku nolomin kebelew a? Emisik ding dim bakate, ku nakalem imok elo kuluselew te. Kameem emteben em ding dim bakate, ku iti beemdiw keko, nem min em meliw dem akati kulomin ibolow kemew kae?”, wangsu kale. Wangbui, Elesel u iti weng mak bokoumomelu: “Ku kilila! Kom min em meliw kemin dem anung mak dunemokolew beem yan e kameem kutiliw kabalak e, imok Sekow e kom am telei, kuso eso yemkal keko, kal bonggu akalokoliw te!”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Wangui, kuinse ding kabalak e, Sekow e akalem musun koleweko, telei, sun waneng Elea u em fukun uneko, bokolewomelu: “Nem min em meliw kemin dem so kuso akalomin em yan wenkembi kasike, ku kame nem am matem tololewka!”, dangsu kale. Dangui, e fein um weng kiliko, gelewsomelei, fein beem kutiliw ding be, yemkal bi kal bonggu akalsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Akalsomeliwi, Sunbin-Got e Elea um gaanin be kiliko, dokoumse kasike, u iti aul kumun kesomelui, fe e, u ketket kel em kunum aul mak dukusu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Dukusomelui, u bokolomelu: “Nem sak weng afak waneng buulo nakalem imok dulewsi te. Dulewii, Sunbin-Got e kanelewsi beem yan kame ken kuw dunemse kae.”, angeko, dukusu aul beem wiin e “Isakal” dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Dangesomelui, Elea u iti aul kumuneko, gung kel em kunum aul mak dukusu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Dukuko, bokolomelu: “Sunbin-Got e nelo ibolow folok kenemeko, on kisol emdiw mak sak dunemse te! Gung kel kunum minggil mak kail koyemsomi, nem imok em dulum elo dukulewsi te. Kame, e nelo wangweng kenemoke te!”, angeko, min beem wiin e “Sebulun”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Keko beli, u iti aul kumuneko, waneng aul mak dukuko, um wiin e “Daina” wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","23","Keko beli, Sunbin-Got e Elesel um kal ilum watemeko, ukalem gaanin kilisomi, ulo dokoumei, fe e, ukati aul kumun keumeko, kunum aul mak dukusu kale. Dukuko, bokolomelu: “Kame, Sunbin-Got e nem kal anggil ilum be banim kenemse te.”, angeko, ");
INSERT INTO bhl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","min em wiin e “Yosew”, dangeko, weng makso bokolomelu: “Yawe e min makso duneme kae!”, angsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Beli, Elesel um Yosew elo dukusu ding kabalak e, Sekow e akalem okis Alaban elo bokolewomele: “Mam kutaka! Ku nem aulkembisi aluwbamin beelo kilele ibolow fukuneko, neso, nakalem aul waneng iso, alik alik nulo ‘Ki ka!’, yangesomelewi, koyemew kano, nu iti nakalem am dim elo unokoluw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","28","Dangei, Alaban e alol elo bokolewomele: “Yemol kutaka! Ne selew selew kunum imdiw kesomi, atemite: Yawe e kulo bamki so kekemkabe kasike, kom neso alakabelew ding dim kabalak, e nakati bamki so kenemei, kilele atemsi te. Kasike kame, ku nam unew te! Kate, ku ‘Kom aluwbamin beem yan kale kulo yo!’, nangew tewe, ne kom weng kiliko, bokonemew yan be fein dukemoki.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Dangei, Sekow e alol elo yan weng bokolewomele: “Kom aluwbamin kilele aluwkembisi kasike, siwsiw so meme so alik alik samal bi bamki so keyemii, bamda nengso nengso kesiliw te. ");
INSERT INTO bhl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nem talsi ding dim kabalak e, i angin fong kuw kebisiliw kate kame, Yawe e nem aluwbamin beelo bamki so kenemei, i demdem kesiliw bakate. Kate, nal em tit ete, ne nakalem aul waneng biim ibolow akati fukunsomi, biim dulum on kisol mak kuluyemoki a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Dangei, Alaban e elo dakalako, bokolewomele: “Kasike, kom aluwkembamin beem dulum elote nimtew ete dukemoki a?”, dangei, Sekow e yan weng bokolewomele: “Mesesem eisneng mak nelo nam dunemew te. Kate, ku nem weng kale kiliko, fukunsomi, ‘Ken kai!’, nangew tewe, ne kom siwsiw so meme so bi iti fein yeteboki te. ");
INSERT INTO bhl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Kame kuw, ne uneko, kom siwsiw so meme so samal angom alik alik biilo diw yetebam uneko, ilo amen amen kada kada keyemoki te. Siwsiw men atin kuw mikil nam kebiliw so, alik alik tikili tukalat aliw so, boketket so, samaliw so, siwsiw so meme so bi ne nakalem aluwbamin beem yan beem dulum kuloki te. ");
INSERT INTO bhl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Nal em tit ete ku nem fukun teleko, nem yan kulukabi siwsiw so meme so alik alik ilo diw yetemewete: Samal tikili tukalat so, boketket aliw so, samaliw so, siwsiw atin kuw mikil nam kelinba samal makmak kuw alik alik biim mutuk belei, atemew tewe, ‘Yakut kese kai!’, nangeko, kal kelolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Dangei, Alaban e bokolewomele: “Kenka! Kom bokonemew weng beelo gelewuma!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Dangeko, beem ding bete, Alaban e uneko, siwsiw so meme so samal tikili tukalat so, boketket so, samaliw so, samal men atin kuw mikil nam so bi alik alik ilo kuluko, akalem muluwel ilo amen amen kuw keyemeko, “Ilo yetebina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yangeko, akalem samal bi so, Sekow em yetemalakabe samal bi so singam ka da ka da keyembelei, yemamas kel ding kese kale. Kelei, Sekow e Alaban em siwsiw so meme so ilo yetemalenale kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yetebomelei, Sekow e ais alemsal biim teing mali mak kuluko, fut bolin atew keleweko, biim kal anung anung bisbos din yak kuw kelewsomi, anung anung yemen din atew yak kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Kelewei, siwsiw so meme so biim teleko, ok waneko, fakalaliw em ding dim e, e ais teing fut bose emdiw be kuluko, biim ok wanenaliw mit kel doung kolew yak yak kelewse kale. Keko beli, samal biim men duku kemiw ding dim bakate, i men tikili tukalat so, boketket so, samaliw so kuw dukusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","41","Keko beli, kitil so yanggus samal biim fakalaliw ding dim bakate, Sekow e imok tikili tukalat so, boketket so, samaliw so, yanggus biim dim kel moko, ais teing fut bose emdiw biim mimyak kel mo koyemei, i kal kel asolsiliw kale. Kanelewsomi, samal biim tikili tukalat so, boketket so, samaliw so, atin kuw mikil nam so men kitil kuw dukuliw biilo takala amen amen kuw keyemsomi, akalem dulum elo kuw dukuse kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Kate, falut kitil banim kebiliw samal yanggus biim asoliw ding dim bakate, Sekow e ais teing fut bomin emdiw be biim mit mewso molinba kese kale. Kanese kasike, akalem siwsiw so meme so bi kitil nam kitil nam kuw kesiliw kate, Alaban em samal i sak falut nam kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Kenese kasike, Sekow e kunum kisol so wiin fian so kunum kamok kesomelei, siwsiw so, meme so, kamel so, donki so, yamgel kesomi, akalem sak weng afak kunum waneng ikati demdem banso kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Beli, deiw mak ding mak, Sekow e Alaban em muluwel biim bakabiliw weng mak kililete: I bokolomeliw: “Sekow e num aatim em mesesem mesesem on kisol alik alik be kulusomi, wiin so kamok kese kate, e beem dulum elote nulo baluw kawtiw keyeme kai!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Angesomeliwi, Sekow e alol Alaban elo atemete: Em kiingen e nanew kuw kesomi, kalfongdewale emdiw kelinba belei, atemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Atemse ding dim kabalak be, Yawe e Sekow elo bokolewomele: “Kukalem kalew kumel im aneng fian so, kukalem angin iso, biim biliw dim kalo iti unolewka! Ku finganemokolew te! Ne kulo nam kokemii, ku so boki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Dangesomelei, Sekow e akalem kalel kumel alew Elea so Elesel so ilo weng kal mak dabalalei, i kili teleko, Sekow em siwsiw so meme so biim yetebe dim kalo im imok elo atebam talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Teliwi, Sekow e uso ilo bokoyemomele: “Nem aatim kumel im Sunbin-Got e nelo bamki so kenemeko, ne so alakabe kate, ne kalew em kiingen be atemite: Suaem kalfongnemsomi, bise emdiw kame kelinba kebelei, atebi te. ");
INSERT INTO bhl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Yukal kilele kal keliwete: Ne kalew em aluwdewbamin banso banso kitil kuw kemali ");
INSERT INTO bhl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","kate, yom kalew e dasuw funum funum kukuw kuw kenemkabe te. King kel ding kelei, e nem aluwdewkabi beem yan e alwol alwol kenembise te. Kate, Sunbin-Got e nelo dokonembelei, kalew e ki keko, nelo wa kukuw mak keneminba kekabe te. ");
INSERT INTO bhl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kasike, e bokonemomele: ‘Kom yan e siwsiw so meme so im men tikili tukalat aliw bite te.’, nangse beem ding dim kabalak e, siwsiw so meme so alik alik i men tikili tukalat kuw dukukabiliw te. Kate e bokonemomele: ‘Kom yan e siwsiw so meme so boketket aliw bite te.”, nangse em ding dim e, samal alik alik bi men boketket kuw dukukemaliw te. ");
INSERT INTO bhl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kano kasike, Sunbin-Got e yom kalew em meme siwsiw yamgel bi nem dim elo kuw dunemse te. ");
INSERT INTO bhl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Samal biim fakala kesiliw ding dim bakate, ne kiin dem sin mak atemite: Samal imok tikili tukalat so, boketket so, samaliw so, alik alik i yanggus biilo asolbiliwi, yetemi te. ");
INSERT INTO bhl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Yetebi dim bakate, Sunbin-Got em dabalakamin finik mak nelo weng mak bokonemomele: ‘Sekow kutaka!’, nangei, ne elo kiin dem sin bokolewomeli: ‘Wee! Nesik bi kaleli!”, dangsi te. ");
INSERT INTO bhl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Dangii, e nelo bokonemomele: ‘Ku gatak dok kiinengeko, atema! Samal imok tikili tukalat so, boketket so, samaliw so, alik alik bite kuw yanggus biilo asolbiliw kasike. Feinka! Ne Alaban em kulo funum funum kukuw kekemkabe be atemsomi, dakakembi te. ");
INSERT INTO bhl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nete kuw Betel abiw kel netemselew Sunbin-Got nete te. Ka kel, ku nem ibolow fukun kemin tum mak mosomi, fawtuk weng ayem mak dunemselew te. Kame akate, ku belew aneng kale kolewomin memen kesomi, kukalem kauk um kamkusu dim elo iti unolewka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Yangei, Elesel so Elea so kalel kusel alew bi Sekow em yangse weng be kiliko, yan weng bokolewomiliw: “Nukalem aatim em kuanoke ding dim e, uso nu mesesem eisneng mak fan atew nam kuluw sako. ");
INSERT INTO bhl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","E nulo nanew aneng im waneng atew keyemeko, num kalik akal kuluko, tutuse te. ");
INSERT INTO bhl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Nukalem aatim em on kisol angom alik alik be Sunbin-Got e kuluko, kom teing dim elo kolewse kasike kame, on kisol angom be nuso nukalem muluwel iso nukalem kuw te. Feinka! Ku Sunbin-Got em kangse weng beelo gelewolewka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Dangiwi, Sekow e akalem aul waneng so mesesem eisneng so kamel im dim dukuko, akalem de unomin mesesem eisneng angom be so, siwsiw so, meme so, akalem Mesofotemia aneng fian ka kuluse em on kisol alik alik angom beso, alew Aisak em alenale Kenan aneng fian elo iti unomin, memen kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kanebelei, Alaban e akalem siwsiw im kalim okiyemomin unse kale. Em unse ding kabalak e, Sekow em afam waneng Elesel u uneko, alew em am duku alakabe auk so takak eisneng beelo yakut kuluomin unsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","21","Keko beli, Sekow e Alam kawtiw im kunum akalem okis Alaban elo weng kal mak kelinba kesomi, okmo yalyal kuw keko, akalem mesesem mesesem eisneng on kisol angom alik alik makuw kubuleko, alol Alaban em aneng be fon uneko, Yufeletis ok bang sel beelo dikeko, malisomelei, e Gileat amgu fole fole kele dim kalo unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Beli, alew ding mak banimeko, yemamas em ding kabalak e, Alaban e kililete: “Sekow e fon unembe te!”, dangiwi, e kilise kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kilisomelei, e akalem kaim anung kuluko, Sekow elo anggelewsiliw kale. Anggelew tem anggelew tem unbiliwi, ben kel ding kabalak e, Gileat amgu fole fole kele dim ka kel e, i Sekow elo deit mosiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Deit mosomeliwi, miliw mutuk akalsiliw ding kabalak e, Sunbin-Got e Alaban elo kiin dem sin kel bokolewomele: “Kutaka! Ku kilelbiko, bolewka! Ku kanelom Sekow elo sikili sakalala dangokolew te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Keko beli, Gileat amgu fole fole dim ka kel e, Sekow e akalem samal kal benemin am kanis daung kanel daung kelewse kale. Kelewsomelei, Alaban so akalem kaim anung iso ikati teleko, Sekow em be dim mewso bakate, ikati ikalem samal kal benemin am mosiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Mosomeliwi, Alaban e Sekow em fukun uneko, elo bokolewomele: “Nimtew angom ete ku nelo dasuw kenemeko, nem mun alew ilo maka on am waneng emdiw yemde fon teleselew a? ");
INSERT INTO bhl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nimtew angom ete ku okmo yalyal kenemsomi, fon telesomi, nelo unomin weng kal keneminba keselew a? Weng kal mak dunemselew tewe, neso, nakalem angin so, alik nu os sansomi, itol sim kalfong keyemsomi, fe e, yulo fein yemdasuluw tew te. ");
INSERT INTO bhl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kate, nimtew angom ete ku okmo yalyal kuw keko, konemsomelewi, ne ki keko, nakalem mulkis so, nakalem muluwel iso, alik ilo falal koyeminba kesomi, ilo “Yukalo!”, yanginba kesi te. Feinka! Ku nelo ibolow teifulumin kukuw kuw kukunemselew te. ");
INSERT INTO bhl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kasike kame, ne kitil keko, ki kesomi, kulo wa kekemomin ibolow keli kate, sinem kutiliw kabalak e, kalew em Sunbin-Got e nelo kiin dem sin mak bokonemomele: ‘Ku kilelbiko, bolewka! Ku kanelom Sekow elo sikili sakalala dangokolew te!’, nangse kasike, kanemok. ");
INSERT INTO bhl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Kate ku kilele yan weng mak bokonema! Ku kalew em am dim aneng kalo unomin kakil kemew tewe, ku nimtew angom ete nem auk so takak eisneng beelo yakut keko, de teleselew a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Dangei, Sekow e yan weng mak bokolewomele: “Ne ibolow fukunite: ‘Mesik ku kukalem mun alew biilo iti tokolokolew kai!’, angomi, okmo yalyal kesomi, weng kal mak kekeminba kesomi, kokem telesi te. ");
INSERT INTO bhl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kate, alik yu nukalem mesesem mesesem eisneng angom alik alik be diw atemina! Nimin kawtiw ite mak kom auk so takak eisneng be biim dim belei, atemiw tewe, ku ilo yeiniwi, i kuanoliwka! Kuniwi, kom yakut kelewsiliw eisneng be kukalem iti kulolewka! Nukalem angin tele biim kiin dim kel, kukalem angin tele biim kiin dim kel, weng fawtuk ayem weng be bokokemsi te.”, dangse kale. Dangse kate, Sekow e Elesel um yakut kesu eisneng beelo akokow kese kasike. ");
INSERT INTO bhl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Keko beli, Alaban e Sekow em samal kal benemin am tem uneko, fensomelei, eisneng be ateminba kese kale. Kesomi, matem teleko, Elea um samal kal benemin am tem so, ukalem weng afak waneng biim samal kal benemin am tem so, kalo akati uneko, alik alik biim eisneng be diw yak yak kesomi, feneko, eisneng be ateminba kese kale. Kesomelei, e Elea um samal kal benemin am tem iti koleweko, Elesel um samal kal benemin am tem kawtem fenomin unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Uneko, bakati alik alik fense kate, fenbe eisneng be atin kuw banim kese kale. Nimtew angom? Elesel u ukalem kamel dim em teinkabu eisneng be kawin dim dukuko, auk so takak eisneng be ukalem kamel dim em teinkabu dim beem afak kabalak kel okiw dako, beem dim teinbisu kasike. ");
INSERT INTO bhl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Kanesomelui, u ukalem alew elo bokolewomelu: “Kamok kutaka! Ku nelo kanelom kaisuw kenemokolew te! Ne molomin ibolow kebi kate, waneng nukalem diw kebi kasike, nam moli te.”, dangsu kale. Dangui, Alaban e “Kenka!”, angesomi, fenem kakabiko, gel so mak ateminba kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kaneko beli, Sekow e kaisuw fian mak kesomi, Alaban elo bokolewomele: “Kutaka! Ne nomin kukuw wa mak, nomin ilum mak kekembi kasike, ku nelo kiin buk moko, nenggelew telew a? ");
INSERT INTO bhl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ku nukalem mesesem mesesem eisneng angom alik alik be diw atemew kate, kukalem eisneng gel so mak atemew e? Atemew tewe, nukalem tele angin so, kukalem tele angin so, alik alik angom biim kiin dim kel kaim matem dala! Matem dasomelewi, i kaso nulo diwyemeko, be ‘Kanem sen ete yake!’, yangokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Mali em duan kel itol kuso bisi ding kabalak e, kom siwsiw imok so, meme imok so bi ne mak an wanekeminba kemali te. Kom siwsiw yanggus so, meme yanggus so bi men ken kuw kailbiliwi, men wa mak dukulinba kemaliw te. ");
INSERT INTO bhl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Taw tele mililiw tele kele ding kabalak e, kut samal mak siwsiw so meme so ilo maka keyemsomi, mak elo an wanse tewe, ne yawal yawal kesomi, beem yan nemikel kuw dukusomi, kanese be kaim dim bokokeminba kemali tew te. ");
INSERT INTO bhl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Nem aluwkembameli be fong ba, fian ete te. Taw ding kel aluwbabelii, ataan tom fom kuw nenei, ne kuanomin kis kemali te. Kutiliw mutuk ding kel asolow fian teinsomelii, aya kuanin kemali kasike, “Akalo yo!”, angbi ding e kiin ok feis kuw kenemale te. ");
INSERT INTO bhl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Nem mali em duan kel itol kuso aluwkembisi ding dim bakate, kom mun alew biim kalik dukulomin beem mongom ete mutum kel itol ase te. Keko beli, samal on kisol kulomin beem mongom ete iti gung kel itol mak so mak aluwkembisi kate, king kel ding kelei, ku nem yan be iti alwol alwol kenemalew te. ");
INSERT INTO bhl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nem awalik Abalakam so, nem aatim Aisak so, yelim biim kitil so auk so Sunbin-Got e nelo dokoneminba kebise tewe, ne kame baluw kunum kelii, ku nelo sak kuw namdakamalew tew te. Kate, Sunbin-Got e nem kal anggil ilum be so, nem aluwkameli em ilum beso, alik alik be kilele diwsomelei, sin em kutiliw mutuk e, kawkew kitil weng fian mak dukemse te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Beli, Alaban e alol Sekow elo yan weng mak bokolewomele: “Kom kalel kumel alew biso, biim dukusiliw muluwel biso, alik alik bi nakalem muluwel dow ite te. Kom siwsiw so, meme so, samal alik alik angom biso, kom mesesem mesesem eisneng kisol so beso, bikati nakalem kuw kebiliw te. Kasike kame, ne nono kesomi, nem muluwel dow biilo dokoyemoki yake? ");
INSERT INTO bhl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ku kilila! Kame neso kuso kitakamin weng mak dukuluma! Dukusomeluw kano, nu beelo kanelom iti akokow kemokoluw te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Dangesomelei, Sekow e kitakamin weng beem ibolow fukunin em tum mak ka kel mo kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Mo kolewsomi, akalem angin ilo bokoyemomele: “Yu uneko, tum mak feneko, de telina!”, yangei, i uneko, fein tum kubulsiliw kale. Kubulsomeliwi, Alaban so, Sekow so, alol yelim ikalem angin iso, i tum kubul dukusiliw beem mit ka kel teinsomi, wanin mak wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Wanin wanesomeliwi, Alaban e tum kubul dukusiliw dim beem wiin e “Yegal Sakaduta”, dangei, Sekow e aneng beem wiin e “Galet”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Nimtew angom? Alaban e bokolomele: “Tum kubul dukusiliw beem mongom e kanekote: Aso nu kanelom kitakamin weng beelo akokow kemokoluw te.”, angse kasike, Sekow e aneng beem wiin e “Galet” dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Dangei, Alaban e Sekow em kitakamin weng beem ibolow fukun kemin mose tum beem wiin e “Misfa” dangse kale. Nimtew angom? E Sekow elo bokolewomele: “Yawe e kom tele nem tele nulum num yetebin kunum kebomi, nulum num singam alakabuluw ding dim e, nulum nukalem ibolow fukunin akal kilele diwyemkabe te!”, dangse kasike. ");
INSERT INTO bhl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Dangeko, iti weng makso alol Sekow elo bokolewomele: “Ku nem mun alew biilo wa kukuw kukuyemsomi, afam waneng makso mak kulew tewe, ne ki keko, kom wa kukuw be nam kal keli te. Kate, Sunbin-Got e kilele kal keloke kasike. ");
INSERT INTO bhl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Feinka! Kubul dukusiliw tum beso, kitakamin weng beem ibolow fukun kemin mo kolewselew tum beso, tum bi awet em dulum dukuluw bakate. Nulum nu kanelom maka kelew kelew kesomi, awet dim kale bakilewokoluw te! ");
INSERT INTO bhl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kom kawalik Abalakam em Sunbin-Got so, nem awalik Nakol em Sunbin-Got so, nulum num Sunbin-Got mak bete kuw num kanekabuluw kukuw be kilele diwyemkabe te.”, dangse kale. Dangei, Sekow e akalem alew Aisak em Sunbin-Got beem wiin fian dim kel fawtuk ayem mak alol elo kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Keko beli, Sekow e samal mak asomi, weing dako, Yawe elo dulewse kale. Dulewsomelei, eso, em alol Alaban so, aso im akunum kusel iso, alik alik i makuw bongguko, belet wanin mak wansiliw kale. Wanesomeliwi, i amgu tikin ka kel akalsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Akalsomeliwi, iti kutim danse ding kabalak e, i teinsomeliwi, Alaban e akalem waneng aul biilo falal keyemsomelei, “Yukal o, nakati nakalem aneng unika o!”, yangeko, ilo koyemsomi, fein, akalem aneng elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Unei, Sekow so akalem angin iso, alik bikati unsiliw kale. Biim unbiliw ding dim bakate, Sunbin-Got em yemdakamin finik mali mak Sekow em fukun teliwi, ");
INSERT INTO bhl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","e ilo yetemeko, bokolomele: “Sunbin-Got em yemdakamin finik im aneng kale eli!”, angeko, aneng ka em wiin e “Makanaim” dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Beli, Sekow e em weng afak kunum mali mak yemdako, “Nakalem fik Iso em fukun unina!”, yangesomi, imisik yemdase kale. Imisik yamdase ding dim e, e ilo Idom kawtiw im aneng fian Seil abiw kalo yamdako, ");
INSERT INTO bhl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","bokoyemomele: “Yu nakalem fik Iso elo weng mak delew unina! Delew uneko, elo bokolewomeliw: ‘Kom weng afak kunum Sekow e weng mak bokokemomele: ‘Ne nukalem mam Alaban em aneng kalo uneko, ka kel kakow kunum atew kebisomi, kakabisi te. Kate kame, ne aneng ka e iti kolew teleko, ");
INSERT INTO bhl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","nakalem bulmakao so, donki so, siwsiw so, meme so, weng afak kunum waneng iso, nakalem angin alik alik biso makuw kubul yemde telbi te. Kame, ne kalan kunum biilo imisik yemdalii, i kom fukun teleko, kulo nem talbi beem weng kal bakakem teliw te.’, kom ning ete kange te.”, dangina!”, yangeko, ilo yemdase kale. Yangei, i fein weng kal be delew unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Delew unesomeliwi, i iti telesomi, Sekow elo weng kal delew teleko, bokolewomeliw: “Nu king Iso elo atemuw te. Kame e, e akalem 400 wonuk so kunum iso foleko, telei, alik i ikalem aneng koleweko, deiw kel tele tele kelokoliw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Dangiwi, Sekow e im dangsiliw weng be kiliko, finganin fian sel mak kesomi, ibolow fukunin tiaktiak kuw kelewse kale. Kelewsomi, akalem kunum waneng so, akalem siwsiw so, meme so, bulmakao so, kamel so, alik alik angom bi, amen kuw keyemeko, mali da mali da alew angin keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Keyemsomi, ibolow fukunomele: “Fik Iso e teleko, angin mali mak biilo ganeko, ilo yene tewe, angin mali mak bi fon unokoliw kate!”, angeko, ibolow kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kanelewsomelei, Sekow e Sunbin-Got elo bokolewomele: “Yawe kutaka! Ku nem awalik Abalakam so, aatim Aisak so, yelim biim Sunbin-Got kute te. Ku nelo bokonemomelew: ‘Ku iti uneko, kukalem angin so, kukalem kawin aneng kalo una o! Unew tewe, ne kulo ken kekemboki te.’, nangselew te. ");
INSERT INTO bhl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ne baluw em banim kunum kate, ku diwkuw diwkuw nelo ibolow folok kukuw so, ibolow mutuk dukanembin kukuw so, kukunemsomi, nelo wiin so kunum kenemselew te. Nem Yoldan bang beelo dikeko, mali elo unsi ding dim kabalak e, ne tokfol kuw auleko, danong unsi kate kame, kunum mongom alew mak kesomi, yemde telbi te. ");
INSERT INTO bhl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kae! Yawe kutaka! Ne fik Iso beem angan elo finganin fian mak keli te. Nimtew angom? Iso e wonuk so kunum iso foleko, nakalem kalel kusel so, muluwel so alik alik nulo yenomin telbe kasike! Ku nem kangbi weng beelo kiliko, dokonema! ");
INSERT INTO bhl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Feinka! Sua kel e, ku nelo bokonemomelew: ‘Ne ken kukuw kuw kekemomi, kom kailokolew muluwel dow biilo kawin yas atew banso banso keyemoki te. Keyemii, mali kawtiw i ki keko, ilo nam teing bokoliw te.’, nangselew kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Dangei, mililiw danei, Sekow e akalem samal biim mit uneko, tugul aliw kakalew bomin so mak kulusomi, “Ilo fik Iso elo sak dulewoki te!”, angeko, ibolow fukunse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Kuluse samal bi kanekote: Siwsiw imok em fufu e mali em duan kel keyemsomi, siwsiw yanggus im fufu 200 kel keyemsomi, meme imok ikati mali em duan kel keyemsomi, meme yanggus ikati 200 kel keyemsomi, ");
INSERT INTO bhl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamel yanggus so ikalem men so, im fufu 30 kel keyemsomi, bulmakao yanggus im fufu e 40 kel keyemsomi, bulmakao imok im fufu e king kel keyemsomi, donki yanggus im fufu e mali em duan kel keyemsomi, donki imok em fufu e king kel keyemsomi, fik elo tokoko, dulewomin memen keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Keyemsomelei, e samal mongom biilo amen amen kuw koyemeko, mali mongom mongom bi akalem weng afak kunum mali mak im teing dim dako, bokoyemomele: “Yu samal mongom amen amen bi kuluko, yomisik uneko, nakalem fik Iso em fukun unoliwka! Unokoliw kate, samal mongom samal mongom dolon amen amen awet so yemde unoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yangei, e emisik fol unakabe weng afak kunum elo bokolewomele: “Nakalem fik Iso elo deiw kel tele tele keko, atemewi, e kulo dakalalomele: ‘Ku nimin kunum kate? Ku nal elo samal ban kaliso unbelew a?’, kange tewe, ");
INSERT INTO bhl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ku elo yan weng bokolewomelew: ‘Nem kamok kutaka! Samal ban kale kom weng afak kunum Sekow em samal te. Ete samal bi sak kom teing dim elo dabalale te. Akalem akati ibik toloke te.’, dangolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Dangeko, emteben em ibik gelewbiliw weng afak kunum alik alik ilo weng ki makmak kuw bokoyemeko, bokoyemomele: “Nakalem fik Iso atemiw tewe, weng ki makmak kuw bokolewoliwka! ");
INSERT INTO bhl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Bokoleweko, iti bokolewomeliw: ‘Kom weng afak kunum Sekow e num ibik mewso tolomin kebe te.’, dangoliwka!”, yangse kale. Nimtew angom? Sekow e ibolow fukunomele: “Ne elo mesesem mesesem eisneng be sak dulewii, e mesesem eisneng be atemeko, akalem kaisuw ibolow be koleweko, nelo menew ibolow so netemeko, ibolow ken kuw kukuw kuw kukunemoka!”, angeko, ibolow fukunse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kanesomelei, mililiw ding kabalak be, e akalem weng afak kunum iso, akalem mesesem alik alik biso, imisik fololu yemde uniwi, e emikel kuw aneng ka kel kose kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Beli, mililiw mutuk kese kabalak be, Sekow e moko, akalem kalel kumel alew so, akalem afam weng afak waneng alew biso, akalem guel kel muluwel biso, alik alik biilo yemdalei, i Yabok bang elo dikeko, mali elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Uniwi, e akalem angin kunum waneng so, akalem mesesem mesesem eisneng beso, alik alik bikati yemdalei, ikati ok be dikeko, mali elo kuw unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Uniwi, Sekow akalem e emikel kuw ka kel kose kale. Ka kosomelei, mililiw ding kabalak be, kunum mak teleko, Sekow elo falal kelewei, aso i gansiliw kale. Ganbomeliwi, aneng kuw danse ding dim bakate, ");
INSERT INTO bhl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","kunum be kal keko, ibolow fukunomele: “Sekow ete kitil kele kai!”, angesomelei, e em kim kun dim kel biti kolewei, em kim kun bing yout kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kim kun yout nam keleweko, bokolewomele: “Kame fongate konema! Iti unomin kemika! Aneng dane kasike.”, dangse kale. Dangei, Sekow e yan weng bokolewomele: “Mesik esik ku nelo bamki so keneminba keko, konemew tewe, ne kulo nam kokemii, ku unew te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Dangei, e elo dakalalomele: “Kom wiin e nelo bokonema!”, dangei, Sekow bokolewomele: “Nem wiin e Sekow nete te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Dangei, kunum be bokolewomele: “Kom wiin kikis e “Isalael” kangi te. Nimtew angom? Ku Sunbin-Got so, kal so kun so kunum awet so ganeko, kom mel ete kuw kelew kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Dangei, Sekow e elo bokolewomele: “Kame ku kom wiin akati nelo bokonema!”, dangse kate, e yan weng bokolewomele: “Ku nimtew angom nem wiin dakalakabelew a?”, dangeko, yan weng bokolewinba kesomi, sak kuw bamki so kelewsomi, unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Keko beli, Sekow e bokolomele: “Ne Sunbin-Got em kiinguen atemi kate, ne kuaninba kesomi, bi te.”, angeko, abiw ka em wiin e “Feniel”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Dangei, ataan telei, Sekow e Feniel abiw ka koleweko, tokfol kuw auleko, yout bolbol kem dili unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Em dim kanelewse beem mongom ete Isalael kawtiw alik alik i sua akal, kame akal, diwkuw diwkuw samal mali im kim kun dim be waninba kekabiliw te. ");
INSERT INTO bhl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","2","Beli, beem ding kabalak e, Sekow e atemete: Em fik Iso so, em 400 kel wonuk so kunum iso, alik alik i ba talbiliwi, yetemse kale. Yetemsomi, akalem muluwel bi akalem ketket teben kel waneng im teing dim elo amen amen keyemse kale. Emisik e, e akalem fefe kuluse weng afak waneng alew so, uso ikalem muluwel iso imisik keyemse kale. Keyemse kate, akalem sun waneng Elea so ukalem muluwel iso, ilo umteben keyemsomi, Elesel so um min Yosew so yat biilo fe dim mineng ka koyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Koyemsomelei, Sekow akalem e emisik foleko, ben kel ding gatak wakas kawin dim dak kiinguen dukuko, akalem fik em mit mewso tele tele kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Kelei, fik Iso yako teleko, ning beelo falal kelewsomi, kakatdew kakatdew kelewsomelei, aso i kalfongso amesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Amesomeliwi, Iso e waneng aul alik alik bikati yetemeko, Sekow elo dakalalomele: “Waneng aul min bi kante a?”, dangei, Sekow e yan weng bokolewomele: “Ne kom sak weng afak kunum kebi kate, Sunbin-Got e nelo bamki so kenemsomi, muluwel banso bi dunemse te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Dangei, Sekow em afam weng afak waneng alew biso, ikalem muluwel iso makuw teleko, ikati gatak wakas, katin bukbuk, kawin dak teinsomi, mewso kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kesomeliwi, sun waneng Elea so, ukalem muluwel iso teleko, ikati gatak wakas, katin bukbuk, kawin dak teinsomi, mewso kesiliw kale. Anfel e, Elesel so Yosew so yat ikati teleko, gatak wakas, katin bukbuk, kawin dak teinsomi, mewso kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Keko beli, Iso e ning Sekow elo bokolewomele: “Nem tele tele keli ding dim bakate, ne samal banban nem talbi dulum elo teliwi, yetemsi te. Ku nimtew ibolow mak fukuneko, nem dulum elo yemdaselew a?”, dangse kale. Dangei, Sekow e yan weng bokolewomele: “Kulo ibolow folok so menew so kekemomin beem mongom ete ilo kom teing dim elo yemdasi te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Dangei, Iso e ning elo yan weng bokolewomele: “Nawkunum kutaka! Ne on kisol fian so, wiin so kunum kebi kasike, ku kukalem mesesem on kisol be iti aulolewka!”, dangse kate, ");
INSERT INTO bhl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Sekow e bokolewomele: “Babo! Ku nelo fein ibolow menew so kenemew tewe, ku on kisol be alik alik fein kulolewka! Feinka! Ne kom kiinguen so, kom ibolow menew beso atemeko, fukunomeli: ‘Ai! Sunbin-Got em kiinguen atemsi emdiw kai!’, angi te. ");
INSERT INTO bhl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kasike kame, ku on kisol so, bamki so eisneng be sak kuw kulolewka! Feinka! Sunbin-Got e nelo bamki banban so kenemse kasike, ne atin kuw ki kebi te.”, dangse kale. Dangeko, Sekow e fik Iso elo kak kelewei, fe e, Iso e on kisol be fein kuluse kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kulusomelei, Iso e ning elo bokolewomele: “Kame nu alik alik makuw unuma o! Ne yuso makuw unoki te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Dangse kate, Sekow e yan weng bokolewomele: “Kamok kutaka! Kukal atebelew: Nem aul beliw i kitil kun so kelinba biliwi, samal ikal men kesomeliwi, mali i auk um non wanbiliw kasike, nu makmak ding kuw kitil kuw kesomi, singam unemuw tewe, mali samal bi fein kuanokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kasike, komisik unolewka! Unbelew kano, kom weng afak kunum nete awkol finengda gili gili ibik ete toloki te. Sowete, ne so, nakalem samal biso, nakalem waneng aul biso, alik alik nu kukalem abiw fian em wiin Seil kalo tolokoluw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Dangei, fik Iso e bokolewomele: “Kenka. Kate, nakalem weng afak kunum mali mak kuso kamde telina!”, dangse kate, Sekow e iti yan weng mak bokolewomele: “Babo! Kamok a! Ku kanelom beemdiw kanelokolew te! Ken kukuw kuw kanenemselew kasike!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Dangei, fein e, Iso e ilo koyemeko, akalem Idom aneng em abiw fian sel Seil kalo unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Unei, Sekow akati uneko, abiw mak teleko, am geko, akalem samal im belbil tem am akati gese kale. Gesomelei, i abiw ka em wiin e “Sukot”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Beli, Sekow e fein Mesofotemia aneng fian elo koleweko, iti Kenan aneng fian kalo uneko, fe e, iti Sekem abiw mutuk fian elo talse kale. Telesomelei, abiw mutuk fian beem ataan talakabe dim beem dim dulum kel akalem samal kal benemin am be kanis daung kanel daung mose kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Akalem am geko, mose kawin beem kayak e kunum mak em wiin “Kamol” kese kale. Kese kasike, Sekow e tum win on kisol 100 kuluko, kawin beem yan wese kale. Kamol e Sekem em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Keko beli, Sekow e aik ayem mak fakalako, beem wiin e “El Eloke Isalael”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","2","Beli, beem ding dim kabalak e, Kibi kawtiw em kunum mongom mak em wiin e Kamol alenale kale. E Sekem abiw mutuk fian beem kak kunum kese kale. Keko beli, deiw mak ding mak, Sekow so Elea so yemkal biim mun Daina uneko, Sekem abiw mutuk fian em waneng seiwel mak ilo yetebam unsu kale. Unui, Kamol em min Sekem e Daina ulo watemeko, takalu kuluse kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Takalu kuluse kate, e Sekow em mun Daina buulo ibolow mutuk fian keumeko, yol abal nam weng atew kuw bokoumse kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Bokoumsomelei, e alew Kamol elo bokolewomele: “Aatim a! Ne waneng seiw kalu ibolow fian keumi kasike, ne ulo wamdulo yo.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Dangse kate, Sekow e kililete: “Sekem e Daina ulo osow keumse kai!”, angiw, e kilise kate, akalem muluwel i kut elo uneko, ikalem samal ilo yetebam unsiliw kasike, e muluwel biim iti tolomin kebiliw em ding fense kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Fenbelei, Sekem em alew Kamol e Sekow eso weng bokolew bokolew kelomin talse em ding dim kabalak e, ");
INSERT INTO bhl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Sekow em muluwel i kut elote talsiliw kale. Teleko, im neng um dulum kaneumse sang be kiliko, yol angeko, ibolow kaisuw fian mak kesomi, ibolow fukunomeliw: “Sekem e Isalael em wiin so, em waneng aul im wiin so, alik alik nukalem wiin akati de mit da koyemse kai!”, angeko, ibolow kaisuw fian kesiliw kale. Nimtew angom? Kanese kukuw be atin kuw ayem tem kasike. ");
INSERT INTO bhl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Keko beli, Kamol e Sekow yelimel biilo weng mak bokoyemomele: “Yutaka! Nakalem min Sekem e Daina buulo ibolow mutuk fian kuw keumbe kasike, yu waneng seiw bu nem min beelo dulewiw kano, e ulo wamdoka! ");
INSERT INTO bhl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Wamdule tewe, nuso yuso alik nu ken abin kuw kuluko, bokoluw te! Yu nukalem waneng seiwel ilo kuliwi, nusik yom waneng seiwel ilo kulamokoluw te. ");
INSERT INTO bhl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Keko beli, yuso nuso makuw bongguko, ibolow ki makmak kesomeluwi, yu yukalem ibolow kuw geleweko, aneng aneng kale kakabomi, kawin so, on kisol mesesem eisneng so, akati kulamokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Yangei, em min Sekem akati alew em mit mewso teleko, Daina um alew so, ukalem kunum aul kusel so, alik alik biilo bokoyemomele: “Yu nem dakalakamin kale kilele kililiko, ‘Kenka!’, nangoliwka! Nomin kulomin kalik mak ibolow kelewbiliw tewe, ne yulo fein duyemoki te. ");
INSERT INTO bhl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Um kalik be atin kuw fian daok keliw tewe, kenka. Ne kalik be fein fokoyemoki te. Kate, waneng seiw bu nelo dunemeko, ne ulo wamdo yo!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yangei, Sekow em muluwel i dasuw funum funum keyemomin ibolow fukunin mak kesomi, Kamol yelim biilo fimdi famde weng mak bokoyemsiliw kale. Nimtew angom? Sekem e ikalem neng ulo tokolu kuluse kasike. ");
INSERT INTO bhl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Keko kasike, i yan weng mak bokoyemomeliw: “Babo! Mali i alik alik kunum nukalem kal okilewsiliw kasike, nu ki keko, num waneng aul biilo kal okilewinba kebiliw kunum mali ilo duyemuwi, i ilo nam yemdu kemiw te. Yemu kemiw tewe, nu nukalem wiin banim kesomi, inkal fian mak kulokoluw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Kate, kunum alik alik yukati yukalem kal okileweko, nukalem atew keliw tewe, nu Daina bu kulo dukemuwi, ku ulo wamduko, unokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kesomelew kano, nuso yuso alik nu ken abin kuw kesomi, angin makmak kuw kebokoluw te. Yu nukalem waneng aul seiwel ilo yemdu kemiwi, nusik yukalem waneng aul seiwel ilo yemdu kemokoluw te. ");
INSERT INTO bhl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kate, yu num weng kale ibolow kilinba kesomi, yom kal okilewinba kemiw tewe, nu nukalem waneng aul Daina buulo iti tokoluko, wamde tolokoluw te. Kaneluwi, aneng kale akati kolewokoluw te.”, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Yangiwi, Kamol yelim i im yangsiliw weng be kiliko, kalfongeko, weng beelo gelewomin unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Uniwi, Sekem e Dian um ibolow kuw fukunsomi, fongate akate im yangsiliw weng beelo gelewko, ki ki kelewomin unse kale. Unse ding dim kabalak e, Sekem akalem alew emdiw kawtiw im kiin dim e wiin fian so kunum kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Keko beli, Kamol yelim bi uneko, abiw mutuk fian beem tum so gesiliw wati kitil nam em abisom mit uneko, abiw mutuk fian beem kalo teleko, wensankabiliw kunum alik alik ilo kitil nam weng mak bokoyemomeliw: ");
INSERT INTO bhl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Kunum bi ibolow menew so num dulum kalo talsiliw kasike, nu kawin anung anung mak im dulum koyemoluwka! Nukalem aneng kale fian bamdase dim kasike, iso nukalemso makuw ki keko, bokoluw te. Ikati aneng kaleem mesesem eisneng on kisol so kulamokoliw te. Biim waneng aul seiwel bi nu yamdusomeluwi, num waneng aul seiwel bi isik yamdulokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kate, i weng makso mak nulo bokoyemomeliw: ‘Kunum angom yukati alik alik nukalem kukuw atew kesomi, yukalem kal okilew kemina!’, yangesiliw angomi, nu im weng kale de teluw te. ");
INSERT INTO bhl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Yu kilele ibolow fukunina! Nu im yangesiliw weng be kiliko, gelewuw tewe, im on kisol mesesem mesesem eisneng so, im samal banban alik alik biso, alik alik angom be makuw nukalem makmak keloke te. Kasike, nu im weng be fein gelewsomi, num kal okiluwma!”, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Yangiwi, abiw mutuk fian beem wensansiliw kunum alik alik bi Kamol yelim biim weng be kilisomi, bokolomeliw: “Feinka! Alik alik kunum angse nu nukalem kal okilew yak yak keluma!”, angeko, fein kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Kaneliwi, yemamas kel dim kabalak e, Sekem abiw mutuk fian beem kunum alik alik bi kanesiliw beem mongom ete betbet fian mak kulusiliw kale. Kulabiliwi, Daina um alew diw auk diw fik kusel alew Simeon so Elibai so, aso i ganbin maka askom kulu uneko, abiw mutuk fian elo unsiliw kale. Unesomi, ka em betbet so atin kuw akokow kesiliw kunum angom alik alik ilo yeniwi, i kuansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Keko beli, aso i Kamol yelim bikati yesomi, ikalem Sekem em am kel alenalu neng Daina iti tokoluko, ikalem am dim elo wamde unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Unsomeliwi, Sekow em mali muluwel alik alik ikati abiw mutuk fian beem matem uneko, kuansiliw kunum biim on kisol mesesem mesesem eisneng angom alik alik beelo yakut dakalas kuluko, ikalem am dim elo deyem unsiliw kale. Nimtew angom? “Sekem e nukalem neng Daina ulo tokoluse kai!”, angsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","29","Keko beli, I kuansiliw kawtiw im siwsiw so, meme so, im bulmakao so, donki so, abiw mutuk fian beem kawtem bise mesesem mesesem eisneng so, abiw mutuk fian beem kut kel bise mesesem mesesem eisneng so, im on kisol mesesem mesesem angom alik alik beso, biim waneng aul so alik alik biilo kubul yemdeko, ikalem am dim elo kuw yemde talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Keko beli, Sekow e akalem min alew Simeon so Elibai so aso ilo kitil weng mak bokoyemomele: “Kaso yutaka! Nelo nen kembiliw kate! Kame kaso yu Kenan kawtiw so, Feles kawtiw so, aneng ka kel em kasel alik alik biim kiin dim e nulo mian wasan teng so kunum waneng atew keyemsiliw te. Nu kunum mongom fong gel kuw kasike, i bonggu teleko, fong kawtiw nulo atin kuw kukun emdiw gilas okda koyemokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Yangei, aso i elo yan weng bokolewomeliw: “Nu nukalem neng ulo deiwkim waneng atew keumse kunum beem yan ete kuw duyemsuluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Beli, Sunbin-Got e Sekow elo bokolewomele: “Kutaka! Kame, ku aneng ka kel iti koleweko, Betel abiw kalo uneko, ka kel kom samal kal benemin am kanis daung kanel daung moko, gelolewka! Geko, ka kel e, nakalem elo aik ayem mak fakalalolewka! Nimtew angom? Ka e, kom fik Iso em angan fon unselew ding dim bakate, ne telii, ku nelo netemselew kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Dangei, Sekow e akalem aul waneng so, mali iso kakabiliw kunum waneng iso, alik alik ilo bongguko, kitil weng mak bokoyemomele: “Yu alik alik yukalem am dim aluwbiliw mali kawtiw im auk so takak biilo takminololiwka! Keko beli, yu Sunbin-Got em kiin dim tokotoko kebomi, ok kuoko, ilim gingeko, kikis kuw minggiloliwka! ");
INSERT INTO bhl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Nimtew angom? Sua e, Sunbin-Got e nem kal anggil ilum kenemse ding atemeko, nem gaanin kiliko, dokonemeko, nem kakabisi em deiw kel neso makuw unse kasike. Kame, nu aneng kale koleweko, Betel abiw elo unuwi, ka kel e, ne Sunbin-Got elo aik ayem mak fakalalewoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Yangei, alik alik i akalem weng be kiliko, geleweko, ikalem auk so takak biso, mali kalun kalamin ketfolong ayem iso, mesesem mesesem alik alik be kubul dukusomeliwi, Sekow e mesesem mesesem eisneng be deko, Sekem abiw mutuk fian beem mewso alakabe ais ayem sel beem mit ka kel kawin tem dako, kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Keko beli, im aneng ka kolewsiliw ding dim bakate, Sunbin-Got e ilo dokoyemeko, aneng kasel alik alik ilo finganin fian mak keyemse kasike, i Sekow em muluwel ilo yenggeleweko, im kanesiliw kukuw beem yan be duyeminba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Keko beli, Sekow so, akalem angin iso alik alik i unesomi, Kenan aneng fian em abiw mak em wiin Ulus kalo talsiliw kale. Ulus e Betel abiw em wiin mak ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ka talsiliw em ding dim bakate, Sekow e Sunbin-Got elo aik ayem mak fakalaleweko, aik ayem em wiin abiw em wiin so takiak molewsomi, “El Betel”, dangse kale. Nimtew angom? “Sua e, fik Iso nelo maka kenemei, ne fik em angan fon unsi ding kabalak e, Sunbin-Got e kale kel teleko, nelo dokonemse te.”, angse kasike. ");
INSERT INTO bhl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Biim ka teliw ding bakate, Elebeka um auk non diumsu waneng Debola u kuansu kale. Kuanui, i ulo Betel abiw em ais sel mak em mit ka kel wamkusiliw kale. Wamkuko, ais sel beem wiin e “Alonbakut”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Beli, Sekow em Mesofotemia aneng koleweko, iti Kenan aneng talse ding bete, Sunbin-Got e auk teben kel ding kel iti Sekow em mit mewso teleko, bamki duleweko, ");
INSERT INTO bhl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","bokolewomele: “Kom wiin e ‘Sekow’ kate kame, wiin be kokemeko, kikis wiin ‘Isalael’ dukemi te. ");
INSERT INTO bhl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nete Sunbin-Got Auk so Sunbin-Got nete te. Ne kukalem muluwel dow ilo banso banso al keyemoki te. I kawtiw banban biim kunum mongom kelokoliw te. Kom muluwel mali ikati aneng aneng im emisik kamok fian kelokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Kawalik Abalakam so, kalew Aisak so, yelim ilo kukuyemeko, duyemsi aneng fian kale, ne kame kuso, kukalem muluwel dow iso, alik yulo duyemo yo.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Dangei, Sunbin-Got e abiw ka iti koleweko, katiw unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Unei, Sekow e eso bokolewse Sunbin-Got em ibolow fukunomin tum tiak mak ka kel mosomelei, wain ok so, oliw ais dem gakas atew so, kuluko, tum beem dim buseleko, tum ayem kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Keko beli, Sekow e bokolomele: “Kale kel, Sunbin-Got e neso weng bokose kai!”, angeko, abiw ka em wiin e “Betel”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Beli, i iti abiw be koleweko, Efalat abiw mutuk fian kalo unomin ibolow kesiliw beem ding kabalak e, Elesel u aul dukulomin kis kesomi, aul wemin fian mak kesu kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Kesomelui, auk um aul dukului, dokoumomin waneng u ulo bokoumomelu: “Ku kanelom finganokolew te! Kunum aul mak dukulew kasike.”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Wangsu kate, Elesel u “Ibo! Kuanomin kis keli kai!”, angeko, dukusu aul beliw beem wiin e “Benomi”, dangeko, kuansu kale. Kuansu kate, alew Sekow e min beem wiin e alwol kelewko, “Benyamin”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Dangei, i Elesel um fom bu ka kel wamkusiliw kale. Wamkusiliw aneng be Efalata abiw mutuk fian beem unbiliw deiw ful dim kel kese kale. Efalata abiw mutuk fian beem wiin mak e Betelekem ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Keko beli, Sekow e Elesel um ibolow fukunin beem dulum elote tum tiakim mak fomkamin dim beem mit kel doung mo kolewse kale. Sua kel mose tum tiakim be kame akal abiw ka kel kait be te. ");
INSERT INTO bhl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Beli, Isalael so, akalem angin alik alik i iti uneko, Migdal Edel abiw mak elo bakileweko, anung fong mak so kakamsomi, ka kel e, ikalem samal kal benemin am kanis daung kanel daung moko, gesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Gesomeliwi, ka kel bisiliw em ding dim bakate, sun waneng Elea um emisik dukusu aul Uluben e unei, akalem alew em afam waneng Bilka uso osow kesiliw kale. Kesiliw kate, alew Isalael e min em kanese beem sang kilise kale. Beli, Sekow e kalun kel muluwel kunum fukose kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Em muluwel biim wiin e kanekote: Sun waneng Elea um gun kel dukusu muluwel i kanekote: Uluben emisik e, Simeon e, Elibai e, Suda e, Iisasal e, Sebulon ete te. ");
INSERT INTO bhl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Emisik afam waneng Elesel um dukusu muluwel alew i kanekote: Yosew so, Benyamin so. Aso ite te. ");
INSERT INTO bhl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Umteben afam waneng Bilka um dukusu muluwel alew i kanekote: Dan so, Nafatali so. Aso ite te. ");
INSERT INTO bhl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Fefe afam waneng Silfa um dukusu muluwel alew i kanekote: Gat so, Asel so. Aso ite te. Muluwel kale Sekow em Mesofotemia aneng fian ka em fukose muluwel ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Anfel e, Sekow e alew Aisak em bise dim elo iti talse kale. Aisak e Mamele em ais tem ninit angse dim ka kel Kiliat Alaba abiw mutuk fian beem mewso dim kel teinse kale. Abiw mutuk fian beem wiin mak e Kebolon ete kale. Sua e, Abalakam so Aisak so yelim i ka kel tiak ding kuw kakow kunum atew kesomi, alenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Keko beli, Aisak e gun kuw felifeli kesomi, faseleko, em itol e 180 kel kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Keko beli, akalem fukunin e ki kuw kesomi, menew ibolow kelei, fe e, e kuaneko, awalik kumel im biliw tem elo unse kale. Unei, akalem muluwel alew Iso so Sekow so, aso i alew sel beem fom be kawin tem dawkusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Kale kel Iso em muluwel dow im sang te. Iso em wiin mak e “Idom” te. ");
INSERT INTO bhl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso e Kenan aneng fian em waneng alew mak kuluse kale. Mak u Ada, mak u Okolibama ite kale. Sun waneng Ada um alew Elon akalem mongom e Kit kawtiw ite te. Afam waneng Okolibama um alew e Ana kesomi, um awalik e Sibeon ete kale. Sibeon yelim bikalem mongom e Kiwit kawtiw ite te. ");
INSERT INTO bhl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Keko beli, e iti afam waneng mak um wiin e Basemat kuluse kale. U Ismael em mun kesomi, Nebayot em neng ute kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Sun waneng Ada um dukusu min beem wiin e Elifas ete kale. Afam waneng Basemat um dukusu min beem wiin e Eluel ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Fefe afam waneng Okolibama um dukusu muluwel im wiin e Yekus so, Yalam so, Kola so, ite kale. Iso em Kenan aneng fian kel bise ding dim bakate, muluwel biilo kailse kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Beli, Iso e akalem kalel kumel so, muluwel iso, akalem angin biso, akalem samal so, akalem Kenan aneng fian kel kubulse mesesem on kisol eisneng so, alik alik angom bi yemde uneko, akalem ning Sekow em bise aneng beelo koleweko, singam aneng fian mak elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nimtew angom? Yelew biim samal i banban tulun kuw kesomeliwi, aso im kakow kunum atew kesomi, kakabiliw aneng be sukumei, i aneng beelo geksiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kanesiliw kasike, fik Iso e Seil amgu aneng elo uneko, ka kel teinse kale. Iso em wiin mak e Idom te. ");
INSERT INTO bhl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Sang be Iso em talfut kese em sang te. Iso e Idom kawtiw im kunum mongom kelei, em muluwel dow i Seil amgu aneng ka kel teinsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso em muluwel im wiin kanekote: Sun waneng Ada um min e Elifas ete kale. Afam waneng Basemat um min e Eluel ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","12","Ada um min Elifas em dukuse muluwel i kanekote: Teman e, Omal e, Sefo e, Gatam e, Kenas ete kale. Elifas e kayot kunum kesomi, afam waneng mak um wiin e Timna kuluse kale. Timna um min makmak em wiin e Amalek ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Afam waneng Basemat um min Eluel em muluwel im wiin e kanekote: Nakat e, Sela e, Sama e, Misa ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Fefe afam waneng Okolibama um muluwel im wiin e kanekote: Yeku e, Yalam e, Kola ete kale. Okolibama um alew e Ana kelei, um awalik e Sibeon kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Kale, Iso em kail koyemse muluwel dow matem matem teleko, emisik kamok fian kesiliw em sang te. Iso em sun waneng Ada um emisik dukusu aul Elifas beem muluwel i kanekote kunum mongom biim kamok kesomi, Idom aneng fian ka kel teinsiliw kale: Teman im kunum mongom e, Omal im kunum mongom e, Sefo im kunum mongom e, Kenas im kunum mongom e, Kola im kunum mongom e, Gatam im kunum mongom e, Amalek im kunum mongom ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Iso em afam waneng Basemat um dukusu min Eluel em muluwel i kanekote kunum mongom biim kamok kesomi, Idom aneng fian ka kel teinsiliw kale. Nakat im kunum mongom e, Sela im kunum mongom e, Sama im kunum momgom e, Misa im kunum mongom ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ana em awalik kesomi, Iso em fefe afam waneng Okolibama um dukusu muluwel bikati kanekote kunum mongom im kamok kesomi, Idom aneng fian ka kel teinsiliw kale: Yekus im kunum mongom e, Yalam im kunum mongom e, Kola im kunum mongom ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Kunum mongom alik alik bi Iso em abal dow ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Kol kawtiw im kunum mak Seil em abal dow im wiin e kanekote: Olotan im kunum mongom e, Sobal im kunum mongom e, Sibon im kunum mongom e, Ana im kunum mongom e, ");
INSERT INTO bhl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison im kunum mongom e, Esel im kunum mongom e, Disan im kunum mongom ete kale. Kunum mongom alik alik bi Idom aneng fian em emisik teinsiliw kasel kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Olotan em muluwel i kanekote: Koli so, Kemam so, ite kale. Olotan em waneng aul u Timna ute kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal em muluwel i kanekote: Alwan e, Manakat e, Ebal e, Sefo e, Onam ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibon em muluwel i kanekote: Aia so, Ana so, ite kale. Sua e, Ana e alew Sibeon em donki yetebin kunum kesomi, aneng kunum banim so, ok banim so dim kel, ok miktem mamin so siksik kebe ok mak atemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana em min makmak e Dison e, em mun u Okolibama kesu kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison em muluwel i kanekote: Kemdan e, Esban e, Italan e, Kelan ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esel em muluwel i kanekote: Bilkan e, Sawan e, Akan ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan em muluwel i kanekote: Us so, Alan so, ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Keko kasike, Kol kawtiw im kamok kesiliw kunum im wiin e kanekote: Mak e Olotan e, mak e Sobal e, mak e Sibeon e, mak e Ana e, mak e Dison e, mak e Esel e, fefe e Disan ete kale. Seil aneng fian teinsiliw Kol kawtiw im kunum mongom i ikalem wiin e biim kamok im wiin imdiw keliwi, im wiin so wiin atem kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Sua e, Isalael kawtiw im imisik kamok fian banim kesiliw ding dim bakate, Idom aneng fian im kasel i imisik kamok fian so ke alenaliw kale. Im Imisik kamok fian biim wiin e kanekote: ");
INSERT INTO bhl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Emisik e Bela, Beol em min ete kale. E Dinkaba abiw mutuk fian teineko, Idom aneng fian em kamok ke alenale kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela em kuanse ding dim bakate, akalem min Yobaw e emisik kamok fian kesomi, Bosala abiw mutuk fian kel alenale kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobaw em kuanse ding dim bakate, Teman aneng fian em kayak Kusam moko, Idom aneng fian em emisik kamok fian kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kusam em kuanse ding dim bakate, Bedat em min Kadat emisik kamok fian kesomi, Awit abiw mutuk fian kel teinse kale. Kadat em bise ding kabalak e, e Moaw aneng fian elo uneko, Midian kawtiw iso maka keyemsomi, ilo kuiaw yese kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kadat em kuanse ding dim bakate, Maseleka abiw mutuk fian em kayak Samala emisik kamok fian kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samala em kuanse ding dim bakate, Yufeletis ok bang em mewso kel gesiliw Elekobot abiw mutuk fian em kayak Saul e emisik kamok fian kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul em kuanse ding dim bakate, Akbol em min Balkanan emisik kamok fian kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akbol em min Balkanan em kuanse ding dim bakate, Kadal emisik kamok fian kesomi, Fau abiw mutuk fian ka kel alenale kale. E Matelet em mun Meketabel kuluse kale. Mesakaw e um awalik keumse kale. ");
INSERT INTO bhl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Iso em muluwel dow im kamok kesomi, ikalem abiw mutuk ikalem wiin so wiin atem kelewsiliw muluwel im wiin e kanekote: Timna e, Alawa e, Yetet e, ");
INSERT INTO bhl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Okolibama e, Ela e, Finon e, ");
INSERT INTO bhl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas e, Teman e, Miwsal e, ");
INSERT INTO bhl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Makdiel e, Ilam ete kale. Bite imisik kamok fian keko, ikalem kunum mongom amen amen kesomi, ikalem teinsiliw abiw mutuk fian akati amen amen kesomi, Idom aneng fian ka kel teinsiliw kale. Kunum mongom alik alik bi Iso em abal dow ite kale. Iso em wiin mak e Idom ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Beli, Sekow em alew Aisak e kuaninba kesomi, bise em ding kabalak e, e kokow kunum atew kesomi, Kenan aneng fian kale kel kakamale kale. Kakambomelei, em min Sekow e iti emdiw kesomi, Kenan aneng fian akati kakamale kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Sang be Sekow em talfut kese em sang te. Beli, Sekow em afam waneng alew Bilka so Silfa so uso biim muluwel i alew em meme so siwsiw so samal biim yetebin kunum kesiliw kale. Kebomeliwi, kunum biim ning Yosew em itol e mali em guel kel itol kese ding kabalak e, e fik kusel ilo dokoyemin unse kate, e yawal yawal keyemeko, em fik kumel im mesesem mak wa kesiliw eisneng be alew elo bokolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Kate, alew Isalael em min fasel men Yosew elo dulewkabe ibolow mutuk fian e atin kuw fian kesomi, akalem mali muluwel ilo duyemkabe ibolow fian beelo kalak da kolewsomi, elo bakilewse kale. Bakilewse kasike, alew e teing tiakim so ken ati kuw asolow ilim mak min beelo dulewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Dulewei, Yosew em fik kumel i alew em ning elo ibolow so kelewse eisneng be atemsomeliwi, i Yosew elo ibolow gal kelewsomi, eso kilele weng mak bakalewinba kelewaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Beli, deiw mak ding mak kabalak e, Yosew e kiin dem sin mak atemeko, sang be fik kumel ilo bokoyemse kale. Bokoyemei, fik kumel i em bokoyemse weng be kiliko, elo atin kuw ibolow wawa gal fian kuw kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Nimtew angom? Yosew e ilo bokoyemomele: “Yutaka! Yu nem kanenemse kiin dem sang kale kililina! ");
INSERT INTO bhl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ne kiin dem atemite: Nungmel nu makuw musun dim kel aluwbabomeluwi, musun beem ais dem kubul dukuko, sok geeko, mo kolew mo kolew kebuluw te. Kesomeluwi, nem sok so ge kolewbi be, emikel kuw doung mobelei, yom sok so geko, mo kolew mo kolew kebiliw be, nakalem beelo falal mutuk dasomi, em mit elo gatak wakas angbiliwi, atemsi te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yangei, fik kumel i em yangse weng be kiliko, bokolewomeliw: “Kate kutaka! Ku kamok kelewi, nu kom afak elo kebokoluw sako?”, dangesomeliwi, i elo em angse weng beem mongom ete iti atin kuw ibolow wa kelewsomi, ibolow kaim alel fian kuw kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kelewsomeliwi, e iti kiin dem sin makso mak kuluko, akalem fik kumel ilo bokoyemeko, bokoyemomele: “Yutaka! Yu nem kiin dem sang kale iti kililina! Ne atemite: Ataan so kayow so, guel kel fial so, alik alik i nem mit mewso teleko, nelo gatak wakas angiwi, ne atemi te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yangei, alew so, fik kumel iso, alik alik i em yangse weng be kiliko, ibolow ki kesomi, kaisuw kelewiwi, alew Sekow e elo sakalala dangeko, bokolewomele: “Wee kutaka! Ku nimtew kiin dem kuw senbelew a? Ku ibolow fukunewete: Nakalem so, kauk so, kawkumel kumel iso, alik alik nu kom afak kuw kesomi, kom mit kel gatak wakas angeko, teinuwi, angbelew a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Keko beli, akalem fik kumel i elo ibolow mesem kuw kelewsiliw kate, alew e min beem kiin dem sang beelo fukunsomi, akokow kelewinba kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Deiw mak ding mak, Yosew em awkunum kumel i uneko, Sekem abiw mutuk fian em mit kel ikalem alew em siwsiw so meme so yetebam unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Uniwi, alew Sekow e Yosew elo bokolewomele: “Ku uneko, Sekem abiw mutuk fian mewso kel samal yetebiliw kawkunum kumel im fukun una!”, dangse kale. Dangei, Yosew e yan weng bokolewomele: “Kenka! Unika.”, dangei, ");
INSERT INTO bhl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Sekow e elo bokolewomele: “‘King kumel so, im yetebiliw samal so, alik alik i ken biliw yake?’, angeko, bi kasike kame, ku fongate im fukun unew kano, iti netebam teleko, nelo weng kal bakanem tololewka!”, dangse kale. Dangei, Yosew e akalem am dim Kebolon abiw mutuk fian beelo koleweko, Sekem abiw mutuk fian elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Uneko, em abiw mutuk fian beem mewso teleko, tefulu kakabise ding kabalak e, mak kunum mak elo atemeko, dakalalomele: “Ku nimtew fen talbelew a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Dangei, Yosew e yan weng bokolewomele: “Nawkunum kumel ilo fenem teli te. I nalem aneng kel ikalem samal yetemeko, someliwi, ne akokow so bi te. Ku ki keko, nelo bokonemew e?”, dangeko, bokolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Bokolewei, e iti yan weng mak bokolewomele: “Ikalem kuw angsiliw weng be kililite: ‘Aneng kale koleweko, Dotan abiw mutuk fian beem mit mewso unuma!’, angiwi, ne kilisi te.”, dangse kale. Dangei, Yosew e beem weng be kiliko, awkunum kumel ilo Dotan aneng kalo fenem unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Unei, singam kel bise ding akate, em awkunum kumel i elo atemeko, elo alomin weng mak bokolew bokolew kesomi, ");
INSERT INTO bhl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","bokolomeliw: “Yake! Ibo! Kiin dem senkabe kunum akal mew talaka o! ");
INSERT INTO bhl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Nu elo aluwi, e kuanoka! Kuanei, em fom e kawin tem mak kabalak daluma! Kanelewsomeluwi, nu bokolomeluw: ‘Kut samal ite mak an wane kembiliw sako?’, angokoluw te! Keko beli, akalem kiin dem sen kembe be, nono kele yake?”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Angsiliw kate, alew em emisik dukuse min Uluben e im bakabiliw weng be kiliko, Yosew elo dokolewomin deiw fensomi, akalem ning kumel ilo bokoyemomele: “Bayo! Nu kanelom elo alokoluw te! ");
INSERT INTO bhl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Nukalem kaim atuk kasike, nu kanelom em kaim buselewuwi, e kuanoke te! Nu elo sak fomdoko, kawitw banim dim kaleem kawin tem mak kabalak elo daluma!”, yangse kale. Nimtew angom? Fik Uluben e ning Yosew elo dokoleweko, iti alew beem mit mewso elo debele unomin deiw fense kasike. ");
INSERT INTO bhl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Keko beli, Yosew em fik kumel im mit mewso talse ding dim bakate, fein, i elo net keleweko, teing tiakim so ken ati asolow ilim be gulok kolewsomi, ");
INSERT INTO bhl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Yosew elo kawin tem ok miktem mak kabalak elo dasiliw kale. Kabalak dasiliw kate, elo dasiliw kawin tem be ok banimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kanelewsomi, im uneko, teinsomi, wanin wansiliw ding kabalak e, mali Ismael kawtiw i kamel dim tein talbiliwi, yetemsiliw kale. Kunum min bi Gileat aneng elo koleweko, Isiw aneng fian elo ikalem kamgu eisneng mesesem mak on kisol so alwol kelomin ibolow kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kesomeliwi, Suda e akalem awkunum kumel ilo bokoyemomele: “Yutaka! Nu nukalem kaim atuk kale anko, em kaim elo okiw da kolewuw tewe, nu beem mongom ete nim gomet ete kelokoluw a? ");
INSERT INTO bhl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kasike, nu elo kaleem talsiliw Ismael kawtiw iso on kisol so alwol kelewuw tewe, i elo Isiw aneng fian elo debele uneko, ka kel wenoliwka! Nimtew angom? E nukalem kaim atuk kasike.”, yangei, alik alik i ibolow ki makmak kesomi, “Kenka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Weng bakabiliw dim bakate, Midian aneng fian koleweko, mesesem mesesem on kisol so wekabiliw kunum biim teleko, Yosew em kawin tem alakabe dim mewso talsiliw ding dim bakate, Yosew em awkunum kumel i elo kut matem dasomi, Ismael kawtiw biso tum win on kisol mali em duan kel fu mak alwol kelewsomi, wesiliw kale. Weliwi, i Yosew elo kuluko, dabeleko, Isisw aneng fian elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Keko beli, anfel e, Uluben e iti Yosew em kabalak dasiliw kawin tem elo uneko, atemomete: Yosew e “Kawin tem banime kai!”, angeko, atemeko, yol fian mak angse kale. Angomi, sakik fian kuluko, akalem ilim finggel dukuko, ");
INSERT INTO bhl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","uneko, akalem ning kumel ilo bokoyemomele: “Ibo! Aul min a! Yosew e banim be kai! Kame ne nono keloki ya?”, yangeko, olse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Olemei, awkunum kumel i Yosew em teing tiakim so ken ati asolow ilim be kuluko, meme imok mak ansomi, em kaim bulok kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kelewsomeliwi, ilim be kunum mak em teing dim dukusomi, ikalem alew beelo delew unesomeliwi, elo dakalalomeliw: “Ilim kale mutuk mak kel kumin belei, atemuw te. Ku kilele diw atema! Asolow ilim kale kukalem min em sako?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Dangsomeliwi, alew e diw atemeko, bokolomele: “Fein! Nakalem min em asolow ilim ete te!”, angomi, gaanin fian keko, bokolomele: “Ibo! Nakalem min em asolow ilim ete kai! Kut samal ite nem min Yosew elo an wane kembiliw sako!”, angeko, olse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Olsomi, sakik fian mak kuluko, akalem ilim finggel dukuko, sakik kemin ilim mak minggisomi, ilum fian mak kuluko, tiak ding mak ibolow tilel kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Kebomelei, akalem muluwel kunum waneng alik alik i teleko, menew ibolow weng bakalewsiliw kate, e im weng be kililinba kesomi, sakik fian so teinsomi, amemsomelei, ilo yan weng bokoyemomele: “Ibolow tilel kenemei, finik am tem unomin ibolow kenembe kai!”, yangeko, amese kale. ");
INSERT INTO bhl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Beli, Isiw aneng fian kel, mak kunum mak em wiin e Fotifal e Yosew be Midian aneng fian kolewsiliw kunum biim teing dim on kisol so welewsomelei, e Yosew elo kuluko, elo sak akalem weng afak kunum kelewse kale. Fotifal e Isiw aneng fian em emisik kamok fian beem wonuk so kunum im kak kunum ke alenale kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Beem ding ka e, Suda e akalem awkunum kumel im alenaliw dim be koleweko, uneko, Adulam abiw mutuk fian em kayak mak em wiin Kila eso, aso alenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Bomeliwi, Suda e Kenan aneng fian kayak Sua em mun seiw ulo watemeko, wamduse kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Wamduko, i bomeliwi, e kalel ulo aul duumei, u kunum aul mak dukusu kale. Dukului, alew Suda e min beem wiin e “El” dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Dangeko, kalel ulo iti aul duumei, u iti kunum aul mak dukuko, em wiin e “Onan” dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Dangui, u iti aul kumun kesu kale. Kesomi, Kesiw abiw mutuk fian kel bisu ding kabalak e, u iti kunum aul mak dukuko, em wiin e “Sela” dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Beli, aul biim tanbelsiliw ding dim kabalak e, alew Suda e akalem emisik dukuse min El beem dulum elote waneng mak fendew unse kale. Femdew uneko, waneng mak um wiin e Tamal watemeko, akalem min elo dulewei, e ulo wamduse kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Wamduse kate, Suda em emisik dukuse min El em kukuw e Yawe em kiin dim e atin kuw wa sel kese kasike, e El elo alei, e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kuanei, Suda e akalem emteben dukuse min Onan elo bokolewomele: “Ku kalun kayak kasike, kame king em kalun ulo wamdulolewka! Um emisik dukuloku aul be king em dulum elote kelewei, king em fan akal kuloke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Dangei, Onan e fukunomele: “Nakalem aul atew ba kai! Fik em aul dukuloku kai!”, angomi, akalem kalel uso kal bongguko, akalsiliw ding kabalak e, e akalem mayow ok be busel kolew kemale kasike, fik em dulum elote aul kailomin em deiw be okilew kemale kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Kanemale kate, Yawe e Onan em kanese kukuw be atemeko, em kiin dim “Kukuw wa sel kekabe kai!”, angesomi, Onan akati alei, e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kuanse kasike, alew Suda e finganeko, ibolow fukunomele: “Mesik ne nem afung aul Sela bakati ulo duumii, e fik kumel imdiw kuanoke kai!”, angeko, min kalel kalun kesu Tamal buulo bokoumomele: “Kom kimok kumel kuansiliw kasike kame, ku uneko, kukalem kalew em am dim elo uneko, eso bomelewi, nem afung aul Sela beem tanbeloke ding kabalak e, ku iti teleko, elo dawdololewka!”, wangse kale. Wangei, u fein kiliko, iti ukalem alew em mit uneko, alenalu kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bomelui, tiak ding mak banimse ding kabalak e, Suda em kalel ukati kuansu kale. (U Kenan aneng fian kayak Sua beem mun alenalu kale.) Kuanui, sakik ibolow ding banimse ding kabalak e, Suda e akalem Adulam abiw fian em akunum Kila eso, aso i Timna abiw kalo uneko, ikalem siwsiw kalim bitam unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Unbomeliwi, Tamal u kililute: “Kimalik e Timna abiw kalo siwsiw kalim bitamomin unbe kai!”, wangiwi, u kilisu kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Kiliko, fongate akate uneko, um kalun keko, sakik ilim be gulu koleweko, ilim ken ati kuw mak minggisomi, ilim gel mak kuluko, ukalem kiinguen kasiko, Timna deiw gengen dim ka uneko, teinsu kale. (Deiw gengen dim beem wiin mak e Enaim.) Nimtew angom? Tamal u atemute: Suda em afung aul Sela e tenbelei, atemsu kate, imalik e kalun kayak weng mak bokouminba kese kasike. ");
INSERT INTO bhl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Beli, Suda e uneko, min em kalun Tamal ulo watemse kate, e ulo abelew keumeko, fukunomele: “Waneng kalu ukalem kiinguen kasiko, teinbu kasike, u deiwkim waneng ute sako!”, angeko, ibolow fukunse kale. Fukuneko, waneng buum mit kue angko, bokoumomele: “Kutaka! Kuso neso kal bonggusomi, akaluma!”, wangse kale. Wangei, u yan weng bokolewomelu: “Ne nim yan kuloki a?”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Dangui, e bokoumomele: “Sow ete, beem yan e meme imok mak dukemoki te.”, wangei, u elo yan weng bokolewomelu: “Kenka. Kate kame, fein nangbelew beem kal kelomin beem mongom ete nim eisneng mak dunemokolew a?”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Dangui, Suda e ulo bokoumomele: “Ku nim eisneng mak ibolow kelewbelew a?”, wangei, u bokolewomelu: “Kukalem wiin beem tikin bosiliw eisneng so, beem gatak dangen kelebelew beem sok so, kom tokfol so, alemsal eisneng bi dunemolewka!”, dangsu kale. Dangui, Suda e alemsal eisneng be ulo fein duumei, alew i kut deiw kukuw kesiliw kale. Kesomeliwi, Tamal u fokfok tein moko, ikalem am uneko, iti um ilim ken so, ilim gel kiinguen kasibu ilim be gulu koleweko, ukalem kalun ilim minggisu kale. Minggisu kate, fein e, imalik em dulum elote u aul kumunsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Keko beli, Suda e meme imok mak kuluko, akalem Adulam abiw mutuk fian akunum beem teing dim dukulei, e elo waneng buulo deum unesomelei, Suda em wiin so eisneng beelo iti de tolomin unse kale. Unse kate, waneng bu iti wateminba kese kasike, ");
INSERT INTO bhl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","e abiw beem kunum waneng ilo dakalalomele: “Enaim deiw gengen teineko, deiwkim kakabu waneng ayem u nal kel bu ye?”, yangse kale. Yangei, i yan weng bokolewomeliw: “Nukalem abiw kale, waneng ayem mak emdiw banim te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Dangiwi, Kila e iti uneko, akunum Suda elo bokolewomele: “Ne waneng buulo wateminba keli kasike, ka em abiw kunum waneng i dakalalii, i yan weng bokonemomeliw: ‘Deiwkim kakabu waneng ayem mak nukalem abiw kale banim kao.’, nangiwi, ne iti sak teli te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Dangei, Suda bokolewomele: “Kanemok a! Waneng bu nem eisneng be sak kuluka! Nu waneng buulo fenem unuw tewe, kawtiw alik alik kaso num dulum elo abenggiyembokoliw sako! Ku kiin so walaselewte: Kom teing dim meme imok mak ulo dabala unsi kate, ku waneng buulo wateminba keselew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Dangei, kayow alemsal mak banimse ding kabalak e, Suda e weng kal kililite: “Kom min kalel Tamal u kut deiw kukuw kesomelui, u aul kumun kebu kai!”, dangiwi, e kilise kale. Kilisomelei, e kitil weng mak bokolomele: “Ulo wamde unesomi, ais dako, weing ulo kainei, u kuanuka!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Angei, i ulo fein wamde unomin kesiliw ding dim bakate, Tamal u Suda em ulo duumse wiin so mesesem eisneng be kuluko, imalik elo dabalaleweko, weng mak bokolewomelu: “Mesesem eisneng beem kasel be nelo aul dunemse te. Ku mesesem eisneng beelo kilele diw atemolewka! Kanem wiin fut bosiliw eisneng so, akalem gatak dangen sok so, tokfol so, ite te?”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Dangui, Suda e kilele diw atemsomi, um dangu weng be kilele kiliko, bokolomele: “Fein! Um kiol kukuw e nem kukuw bakilewkabe te. Ne ulo wa keumsomi, nem afung min Sela ulo duuminba kelii, e kalun kayak kukuw gelewinba keko, ulo wamdolinba kese kasike!”, angse kale. Angse kate, e kuansiliw min im kalun uso iti kal bongguko, akalinba kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Anfel e, Tamal um aul dukusu ding kabalak e, awang men dukulomin kis kesu kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Kesomelui, mak aul em teing esik malak talse ding dim bakate, auk um aul dukului, dokoumomin waneng bu sok olol nam mak kuluko, aul beem teing falal keleweko, bokolomelu: “Emisik aul malak tele bakate!”, angsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Angsu kate, aul be iti teing bing angeko, auk kumun iw elo kese kale. Kanelei, emteben aul esik deiw elo kesomi, emisik malak telei, fe e, u dukusu kale. Dukusomi, bokolomelu: “Yake! Ku nono kelomi, nelo dakal konemw a?”, dangsu kale. Dangsu kasike, i em wiin e “Feles”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Dangiwi, aul beem sok olol nam em teing dim falal kolewsiliw awkunum akati malak talse kale. Telei, aul beem wiin e “Sela” dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Beli, Ismael kawtiw im Yosew elo Isiw aneng fian debele unsiliw ding kabalak e, Fotifal e elo on kisol so wensomelei, e akalem sak weng afak kunum kese kale. Fotifal e Isiw aneng fian em emisik kamok fian beem wonuk so kunum im kak kunum ke alenale kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Keko beli, Yawe e Yosew elo dokolewse kasike, akalem Isiw kunum beem am alenale ding kabalak e, e akalem kamok em aluwbamin mesesem mesesem alik alik be ken ati kuw alulewbamale kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Alulewbelei, em kamok atemete: Sunbin-Got e Yosew so bomi, Yosew em aluwbamin alik alik be bamki so kelewemale kasike, ");
INSERT INTO bhl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","e Yosew elo kalfong fian keleweko, akalem wiin dawsuleko, akalem ibolow fian dulewkabe emisik weng afak kunum kelewse kale. Keleweko, Yosew elo akalem am so, akalem mesesem mesesem eisneng so, akalem weng afak kawtiw iso, alik alik biim yetebin kunum kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kelewse ding dim bakate, Sunbin-Got e Isiw kayak kamok fian beem am so, em mesesem eisneng so, em musun so, alik alik mesesem eisneng beelo Yosew beem dim elote bamki so keyemale kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Keyemei, Yosew e akalem kamok em mesesem mesesem eisneng alik alik be kilele atebelei, Fotifal e em atebe eisneng beem dulum elote sakik banimsomi, sak am kuw bomi, wanin wanbise kale. Kate, Yosew e atebomin kuw kunum weit mak kesomi, kal anggil fulkan danong angse kunum kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kese kasike, akalem kamok Fotifal em kalel u Yosew elo ukati atemeko, ibolow kutilel atin kuw fian fian kelewsu kale. Kelwsomelui, u elo weng mak bokolewomelu: “Kame kuso neso kal bongguko, akalokoluw te!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Dangui, e yan weng bokoumomele: “Itel bayo! Nem kamok e akalem mesesem mesesem eisneng angom alik alik be nakalem teing dim kuw dunemei, e beem dulum elote atin kuw sakik banimkabe te. ");
INSERT INTO bhl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Akalem am kale kel mak kunum mak nemisik bate. Nete kuw akalem emdiw, mesesem mesesem eisneng alik alik be atemkabi te. Kate kukalem nem kamok em kalel kasike, ku akalem ete kuw te. Kuso nu kal bongguko, akaluw tewe, nu atin kuw wa kesomeluwi, ne nakalem Sunbin-Got em kiin dim e sili sili nam kukuw fian mak keloki te.”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Wangei, taw banim kutiliw banim diwkuw diwkuw u iti kak kelew, iti kak kelew kebisu kate, Yosew e um weng wosulinba kesomi, um mit mewso uninba keko, kitil kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Beli, deiw mak ding mak kelei, Yosew e kamok em am kawtem elo aluwomin unse kale. Unse ding dim kabalak e, weng afak kawtiw gel so mak am ka banim kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Keko beli, Fotifal em kalel bu em mit mewso teleko, Yosew elo galolo aluweko, bokolewomelu: “Kame kutaka! Fongate akate kuso nu kal bongguko, akaluma!”, dangsu kale. Dangui, e “Bayo!”, angeko, fon unse kale. Fon unse kate, u gebi aluweko, em ilim ete kuw gulok takas aluweko, atemsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Keko beli, u atemute: Yosew e fon unse kate, em ilim ete kuw um teing dim elo guluk kolewsomi, am kolewi, atemsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Atemsomelui, u ukalem am em weng afak kunum waneng alik alik biilo gaayemeko, bokoyemomelu: “Yu atemina! Nakalem imok em nukalem buluw dim kalo kolew talse Kibulu kawtiw em kunum be nulo kukuw wa keyemomin talakabe te. Kame kuw e nem mit mewso teleko, nauleko, neso kal bongguko, akalomin ibolow kele te. Nem oleko, ");
INSERT INTO bhl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","gaanbi ding dim bakate, e fon kun kang konemeko, ilim ete kuw gulok kolewsomi, am kolew une te.”, yangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Yangui, alik alik i um yangsu weng be kilisiliw kate, u Yosew em gulok kolewse ilim be aluweko, imok em talse ding dim bakate, ");
INSERT INTO bhl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","u elo bokolewomelu: “Imok kutaka! Ku Kibulu kawtiw biim kunum beelo num mit dabele talselew te. Kame kuw, kunum be nelo wa kenemomin teleko, nalue te. ");
INSERT INTO bhl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Naluei, nem oleko, gaani em ding dim bakate, e fon kun kang konemei, ne ilim ete kuw alulewii, e am koleweko, une te.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Dangui, imok Fotifal e kalel um “Kom aluwbamin kunum be wa kukuw kelomin tele kae!”, dangsu weng be kilisomelei, e fein atin atin kaisuw fian mak kesomi, ");
INSERT INTO bhl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","akalem wonuk so kunum ilo gaayemei, i telesomi, Yosew elo kuluko, Isiw aneng fian em emisik kamok fian em sok am tem da kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Kolewsiliw kate, Yawe Sunbin-Got e Yosew elo kolewinba kesomi, ibolow folok kukuw kukulewse kasike, sok am tem em wonuk so kunum im kak kunum e Yosew elo kinkin ibolow kelewsomi, folok kukuw kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kelewsomi, Yosew elo mali sok am biliw kawtiw biim yetebin kunum kelewsomi, ka em aluwbamin alik alik be Yosew em teing dim elo dulewei, e aluwbamin alik alik be fein kuw aluwbamale kale. ");
INSERT INTO bhl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Keko beli, sok am tem beem kak kunum be sak am kuw bomi, em sakik alik banimse kale. Nimtew angom? Yawe Sunbin-Got e Yosew elo bamki so kelewsomi, dokolewse kasike, Yosew em aluwse mesesem eisneng alik alik be kenati kuw keko, kiol kuw kese kasike. ");
INSERT INTO bhl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Beli, deiw mak ding mak kelei, Isiw aneng fian em emisik kamok fian em kak wiin so kunum alew mak i ikalem kamok em kiin dim elo sen so kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Mak wiin so kunum be akalem kamok em wanin ok dalewbin kak kunum kelei, mak e akalem kamok em belet wanin fulewkabe kak kunum kese kale. Aso biim sen beem mongom e emisik kamok fian be aso ilo kaisuw fian mak keyemeko, ");
INSERT INTO bhl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","aso ilo sok so ge koyemeko, akalem wonuk so kunum biim kak kunum em sok am tem kel da koyemse kale. Koyemse sok am ka kel e, sua kel akate Yosew elo da kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Keko beli, sok am tem beem wonuk so kunum im kak kunum be sok am yemde talsiliw kunum alew biilo Yosew em teing dim da koyemse kale. Koyemei, aso i sok am tem kel bomeliwi, ding fensiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Kaneko beli, mililiw mak kabalak e, Isiw aneng fian em emisik kamok fian beem ok dalewbin kak kunum so, beem belet wanin fulewkabe kak kunum so, aso im sok am tem biliw ding dim ka e, mak akal amen kiin dem mak sense, mak akal amen kiin dem mak sense kale. Aso i kiin dem sensiliw kate, aso i ikalem kiin dem beem mongom e kal kelinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kesomeliwi, kutim danse ding kabalak e, kunum alew bi sakik ilum so teinbiliwi, Yosew e aso ilo yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yetemeko, aso ilo dakalalomele: “Wee! Yutaka! Kaso yu nimtew angom ete ilum sakik so teinbiliw a?”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Yangei, aso i yan weng mak bokolewomeliw: “Nu kiin dem mak senomeluwi, atemuw kate, num kale buluw dim bakate, mali kawtiw mak dolon keko, kiin dem sen kembuluw beem mongom e nulo kilele bokoyeminba kebiliw kasike.”, dangsiliw kale. Dangiwi, Yosew e bokoyemomele: “Yom kiin dem sen kembiliw be nelo bokonemina! Nakalem Sunbin-Got ete kuw kiin dem sen beem mongom kayak ke alakabe kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","Yangei, ok dalewbin kak kunum be emisik keko, akalem kiin dem sense sang be Yosew elo bokolewse kale. E bokolewomele: “Ne wain ais sen teing alemsal so mak atem kembi te. Ais sen be kon kalis ange kembe kate, em dim e iti kon so bokbok so dem so tebelei, atem kembi te. Atebi ding dim bakate, dem be guluw keko, yom kelei, atem kembi te. ");
INSERT INTO bhl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Keko beli, Isiw aneng fian beem emisik kamok fian em wain ok sen nem teing dim aluweko, wain ais beem dem kawtol dubelet keyemeko, wain ok sen tem elo kelewsomi, Isiw aneng fian beem emisik kamok fian elo dulewsomi, atem kembi.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Dangei, Yosew e elo kiin dem beem mongom e kaim dim dako, bokolewomele: “Kiin dem beem mongom e kanekote: Wain ais em teing alemsal bi alemsal ding beem kiskiw te. ");
INSERT INTO bhl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Alemsal ding mak banimei, Isiw aneng fian em emisik kamok fian e teleko, kom kak kon bing kekemeko, kulo kamde uneko, kukalem suaem aluwbamelew dim beelo ‘Ku iti aula!’, kangoke te. ");
INSERT INTO bhl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kame, ku kilila! Kom uneko, iti ken abin teinokolew em ding dim e, ku nem ibolow akal fukunemolewka! Fukuneko, Isiw aneng fian beem emisik kamok fian beelo weng kal kelewsomelewi, e nelo kut da konemoka! ");
INSERT INTO bhl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nimtew angom? Ne Kibulu aneng fian em kayak kate, mali kunum mak i nelo yakut kenemsomi, Isiw aneng fian kalo nemde telesomeliwi, kunum mak nelo on kisol so wese te. Kate kame, i nelo sak mongom banim beem dulum elote sok am tem da konemiwi, ne kale bika.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Dangei, belet wanin fukabe kak kunum e kililete: Yosew e akunum beem kiin dem em mongom e kiol kuw sileleko, mongom ken kuw bokolewse kasike, akati Yosew elo bokolewomele: “Nakati kiin dem mak beemdiw sen kembi te. Nemi kanekote; Belet wanin wen gekbiliw men alemsal mak belei, nem kak dim dukuko, de unembi te. ");
INSERT INTO bhl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nem de unembi tikin men dim kawtem e Isiw aneng fian em emisik kamok fian beem ibolow kelewkabe abal wanin be abuliwi, ne de unembi te. Kate, nem unembi ding dim be, awon mali mak teleko, abal wanin beelo yakut binge binge kemiwi, yetem kembi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Dangei, Yosew e elo yan weng bokolewomele: “Kiin dem beem mongom be kanekote: Men alemsal bi yemamas kel ding beem kiskiw te. ");
INSERT INTO bhl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Yemamas kel ding banimei, Isiw aneng fian beem emisik kamok fian beem wonuk so kunum i teleko, kulo kamdeko, nang wanin sok gi kokemokoliw te. Kokemiwi, awon i teleko, kom fom dim teineko, wanokoliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Keko beli, alemsal kel ding dim banimei, Isiw aneng fian beem emisik kamok fian beem auk elo dukusu ding kese kale. Kelei, kawtiw i beem ibolow fukunsomi, wanin fian mak fusomi, emisik kamok fian beem weng afak kunum waneng alik alik i ka tele ka tele kesomi, wanin wansiliw kale. Wansomeliwi, e akalem sok am da koyemse kak kunum alew biim dulum elote “Ilo yemde telina!”, angesomi, ilo wensanbiliw kunum waneng alik alik im kiin dim kel mo koyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Mo koyemsomi, Isiw aneng fian beem emisik kamok fian be akalem wain ok dalewbin kak kunum beem dulum elote “Elo iti kolewina!”, yangei, fein, e iti akalem aulamele beem dim kalo iti aluwbam unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kanese kate, emisik kamok fian be akalem belet wanin fulewkabe kunum beelo wonuk so kunum im teing dim dalei, i elo sok gi kolewsiliw kale. Gi kolewsomeliwi, Yosew em aso ikalem kiin dem sensiliw beem dulum elote “Kaneloke te!”, yangse weng be ki fein kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kese kate, ok dalewbin kak kunum be Yosew em ibolow fukuninba kesomi, elo akokow kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Beli, alew itol banimse ding dim e, Isiw aneng fian em emisik kamok fian be kiin dem mak sense kale. E kiin dem atemete: Em Nail bang mewso mobele ding dim bakate, ");
INSERT INTO bhl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","kal weit so belibeli biliw bulmakao ben kel mak Nail bang ok mutuk elote matem teleko, ok benggew em mit mewso balasal wanen teliwi, yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Em yetebe dim ete, dem banim, melen kun fitew keko, kuka nam bulmakao ben kel mak mali biim ibik elote ikati Nail bang ok mutuk elote matem teliwi, yetemse kale. Em yetebe dim ete, ibik kuka nam talsiliw bulmakao imisk belibeli so balasal wanbiliw bulmakao biim mit mewso teleko, ");
INSERT INTO bhl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ilo yen kuniliwi, yetemse kale. Yetemsomi, yol angeko, baba teinse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Teineko, iti akaleko, iti kiin dem mak sense kale. E atemete: Ok abolin tew kese wit sen makmak em dim ka kel e ben kel uki dem tugul ken so kuw abuko, gilabelei, atemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Em atebe dim ete, dem tugul banim, aom kuw kalulu angse wit uki ben kel mak beem dim akati tebei, atemse kale. Atemse wit uki be, ataan tele dim elote inim mamin fian mak fufu tiow nam kelewei, dem tugul yak elo alik alik kuiaw banim kelewi, atemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Atemse ding ete, aom kuw kalulu balkil uki be dem tugul ken so kuw wit uki beelo kunil kolewei, atemse kale. Atemeko, iti yol yol angeko, baba teineko, bokolomele: “Yakai! Kiin dem kuw senbi!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Angesomelei, iti kutim danse ding dim bakate, e ibolow tiaktiak kuw kesomi, Isiw aneng fian em ok takak selew kunum so, kal fian so kunum so, alik alik biilo gaayemei, i teliwi, e ilo akalem kiin dem alew atemse beem sang be bokoyemei, fe e, ilo bokoyemomele: “Yu kame kiin dem sen kembi beem mongom be nelo bokonemina!”, yangse kate, i ki keko, beem mongom e kiol kuw silel kaim dim bokolinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Keko beli, Isiw aneng fian em emisik kamok fian beem ok dalewin kak kunum be akalem kamok elo weng mak bokolewomele: “Kamoka! Kame kuw nem wa kekemsi beem dulum elote iti fukuni te. ");
INSERT INTO bhl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mali itol banimse ding kabalak e, ku nakalem so, belet wanin fukemkabe kak kunum so, aso nulo kaisuw keyemsomi, aso nulo wonuk so kunum im kak kunum beem sok am tem kabalak elo yamda koyemselew te. ");
INSERT INTO bhl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Aso num ka bomuluwi, mililiw mutuk mak kese ding dim bakate, aso nu kiin dem mongom so mak sensuluw te. Aso nu amen kuw kesomi, akal amen senei, nakal amen seni, kesuluw te. ");
INSERT INTO bhl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Keluwi, Kibulu kunum tanbel mak akati ka kel bise te. Sua e, e wonuk so kunum im kak kunum beem sak weng afak kunum kebise te. E aso num kiin dem sensuluw beem mongom e nulo kilele kiol kuw silel bokoyemse te. ");
INSERT INTO bhl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Bokoyemei, em aso nulo bokoyemse mesesem eisneng be alik alik kiol kuw fein kese te. Nakalem ete iti kom aluwbamin kekabi kate, nakunum em kiin dem sense sang akati fein kelei, ku elo sok gi kolewselew bakate.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Dangei, Isiw aneng fian em emisik kamok fian be kunum beem weng be kiliko, kitil weng mak bokolei, i Yosew elo kalan uneko, debele tolomin unsiliw kale. Uneko, i fongate akate sok am tem elo uneko, Yosew em kak kon okilewsomi, elo ilim kikis ken kuw minggilewsomi, elo kamok fian beem kiin dim mo kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Mo kolewsomeliwi, Isiw aneng fian em emisik kamok fian be Yosew elo bokolewomele: “Nem kiin dem sen kembi beem mongom e kaleem kunum i ki keko, kiol kuw bokoneminba kebiliw te. Kame, ne kililite: Kukalem ete ki keko, kiin dem angom em mongom e kilele kiol kuw kaim dim kuw dakabelewi, kilibi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Dangei, Yosew e elo bokolewomele: “Nakalem ete kuw ki kelinba kebi te. Kate, Sunbin-Got kulo kiin dem beem mongom e fein kaim dim dakamoke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Dangei, Isiw aneng fian beem kamok fian be Yosew elo akalem kiin dem sese sang be bokoleweko, bokolewomele: “Nem kiin dem sen kembi be kanekote: Nem Nail bang mewso mobi ding kabalak e, ");
INSERT INTO bhl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","kal weit so belibeli biliw bulmakao ben kel mak Nail bang ok mutuk elote matem teleko, ok benggew em mit mewso balasal wanen teliwi, yetem kembi te. ");
INSERT INTO bhl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Nem yetebi dim ete, dem banim, melen kun fitew keko, kuka nam bulmakao ben kel mak mali biim ibik elote ikati Nail bang ok mutuk elote matem teliwi, yetem kembi te. Bulmakao ban bi Isiw aneng fian kale kaneko eisneng mak imdiw yeteminba kekabi te. ");
INSERT INTO bhl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ibik kuka nam talsiliw bulmakao bi imisk belibeli so bulmakao ilo yen kuniliwi, yetem kembi te. ");
INSERT INTO bhl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ilo yen kunil koyemiw kate, im melen kun fitew keko, kuka nam dem be kait biliw ki kuw keliwi, yetem kembi te. Yetemsomi, baba tein kembi te. ");
INSERT INTO bhl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Keko beli, iti akaleko, kiin dem makso mak sen kembi te. Sen kembi kiin dem be kanekote: Ok abolin tew kese wit sen makmak beem dim ka kel e dem tugul ken so kuw uki ben kel abuko, gilabelei, atem kembi te. ");
INSERT INTO bhl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Atebi dim ete, dem tugul banim, aom kuw kalulu angse wit uki ben kel mak beem dim akati tebei, atem kembi te. Atemsi wit uki be, ataan tele dim elote inim mamin fian mak fufu tiow nam kelewei, dem tugul yak elo alik alik kuiaw banim kelewi, atem kembi te. ");
INSERT INTO bhl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Atemsi ding ete, aom kuw kalulu balkil uki be dem tugul ken so kuw wit uki beelo kunil kolewei, atem kembi te. Ne sen kembi kiin dem sang bi nakalem oktakak selew kunum alik alik biilo bokoyem kembi kate, i beem mongom ete dolon kelinba kesomi, kiol kuw bokoneminba kembiliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Dangei, Yosew e Isiw aneng fian em emisik kamok fian beelo yan weng bokolewomele: “Kamok kutaka! Kom sen kembelew kiin dem alew biim mongom e makmak kuw te. Sunbin-Got e akalem mesesem mesesem eisneng kaneloke be kulo kiin dem sin kukukem kebe te. ");
INSERT INTO bhl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ben kel bulmakao belibeli weit biso, wit sen makmak em ben kel uki dem tugul so beso, kiskiw alew beem mongom e ki makmak kesomi, kanekote: Ben kel itol keloke ding dim kabalak, musun wanin fokoko, beki kuw yom am keloke te. ");
INSERT INTO bhl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ataan tele dim elote inim mamin fian mak fufu tiow nam kelewei, dem tugul yak elo alik alik kuiaw banim kelewse wit dem ben kel so, ibik talsiliw em ben kel bulmakao biso, kiskiw alew beem mongom e ki makmak kesomi, kanekote: Aneng aneng angom be olfut fian fian mak kelei, ben kel itol mak keloke te. ");
INSERT INTO bhl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Emsik emdiw kame iti kulo bokokemomeli: ‘Kom kiin dem sen kembelew beem dulum elote Sunbin-Got e akalem kaneloke mesesem eisneng be kulo kukukem kembe te.’, kangbi te. ");
INSERT INTO bhl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kutaka! Ben kel itol kelei, Isiw aneng fian kale, musun wanin alik alik fokoko, yom am keloke te. ");
INSERT INTO bhl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kate, ben kel itol be banimoke ding kabalak e, iti ben kel itol mak kelokoliw te. Ibik toloke ben kel itol beem ding dim kabalak, musun wanin mak gilalinba kelei, olfut fian fian mak keloke te. Beem kaneloke ding kabalak e, kawtiw i emisik ben kel itol beem wanin yom am kese ding beelo akokow kesomi, anggil ilum fian makuw kulokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Olfut fian fain mak toloke kasike, Isiw aneng fian kaleem yom am wanin angom alik alik be banimei, kawtiw i beem bamki so sang elo akati atin kuw akokow kelokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Sunbin-Got em kulo kiin dem mongom makmak be alew ding kukukem kembe beem mongom e kanekote: Tiak ding atew ba keko, mewso ding akate, Sunbin-Got em ‘Ne fein kaneloki te!’, angeko, kukukem kembe eisneng be fein kaneloke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Dangeko, Yosew e weng makso bokolewomele: “Kame, kamok kutaka! Ku kal fian so, ibolow fukunin ken so, kunum mak galmoko, Isiw aneng fian kaleem emisik atebin kak kunum kelewolewka! ");
INSERT INTO bhl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kelew kano, wanin yom am kebiliw ben kel itol bakate, ku mali kak kunum ikati galmolewka! Galmosomelewi, kak kunum bi Isiw kawtiw alik alik biim musun angse wanin angom beem anung amen kuw makmak kuluko, anung ketket teben kel be musun kasel bikalem teing dim kel koyem yak yak keyemoliwka! ");
INSERT INTO bhl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Keyemsomi, kawtiw im teing dim kulukabiliw wanin alik alik be kubul deko, abiw mutuk fian biim wanin kubul dukemin am kawtem elo kukalem wiin afak kel da kolewoliwka! ");
INSERT INTO bhl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Kanelew tewe, ben kel itol wanin yom am banimei, olfut fian keloke ding dim kabalak e, Isiw aneng fian biim kunum waneng alik alik angom bi kom kubul dukubelew wanin beelo wanbomi, biliwi, yemen tew so keko, nam kuaniw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Keko beli, Isiw aneng fian em emisik kamok fian beso, akalem kak kunum biso, alik alik i Yosew em weng be kiliko, em bokoyemse weng be ikalem kiin dim ken kuw kiol weng ati kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kelei, Isiw aneng fian em emisik kamok fian be alik ka biliw ilo bokoyemomele: “Nu ki keko, nanew kunum Yosew akate tew mak nam atemuw te. Em dim e Sunbin-Got em finik alakabe kasike.”, yangeko, ");
INSERT INTO bhl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Yosew elo bokolewomele: “Sunbin-Got e nakalem kiin dem sen kembi beem mongom e kiol kuw kukukemse kasike, nanew kunum mak komdiw kal fian so fukunin ken so akati banim te. ");
INSERT INTO bhl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kame ne kulo Isiw aneng fian kaleem kamokim fian mak kekemi te. Kunum waneng angom alik alik bi kom weng afak kuw keko, boliwka! Nakalem ete kuw kom kak kebomi, nemisik keloki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Dangeko, iti bokolewomele: “Kame, ne kulo Isiw aneng fian kaleem emisik yetebin kamok fian kekemeko, galmokemika!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Dangeko, akalem teing dim em wiin so fut bosiliw eisneng be gulok kelewsomi, Yosew em yemamas teing dim kel kilis kelewse kale. Kelewsomi, ilim kais nam kait so atite mak duleweko, on kisol gol so kailsiliw gatak dangen mak em gatak dim kel falal minggilewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Minggileweko, akalem weng afak biliw kawtiw ilo kitil weng mak bokoyemei, i Isiw aneng fian beem emteben wiin so kamok fian beem teinkemin ganbin eisneng beem dim teinsomi yak unakabe beelo memen kesomi, Yosew elo beem dim mo kolewsomi, deiw yak mayak, yak mayak gui unsiliw kale. Im unsiliw ding bakate, kunum mak emisik uneko, gaan gaan keko, bokolomele: “Katin bukbuk angina oo! Katin bukbuk angina oo!”, yangen yangen yak kem diliko, unbelei, i ibik elote gelew gelew unsiliw kale. Kaneko beli, Isiw aneng fian em emisik kamok fian e Yosew ete kuw akalem emteben wiin fian so kamok kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Keleweko, Yosew elo bokolewomele: “Nakalem ete Isiw aneng fian kaleem emisik kamok fian kate, kusik nemteben kamok fian kelew kasike, alik alik i kom weng afak kuw kebomeliwi, ku mali kawtiw mak ilo weng mak bokoyemomelew: ‘Teing daok yan daok kelina!’, yangew tewe, i kom weng fein gelewemoliwka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Dangeko, elo mongom so wiin mak amkoko, bokolewomele: “Safenat Fanea.”, dangesomi, elo akati waneng mak dulewse kale. Waneng buum wiin e Asenat kesu kale. U Keliofolis abiw mutuk fian beem kunum ayem Fotefela beem mun ute kale. Keko beli, Yosew e Isiw aneng fian alik alik beem yetebin kamok fian ke alenale kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Kesomelei, Isiw aneng fian em emisik kamok fian beem Yosew elo aneng fian beem kak kunum fian kelewse ding kabalak e, Yosew em itol e 30 kese kale. Kelei, Yosew e Isiw aneng fian em emisik kamok fian beelo koleweko, uneko, Isiw aneng fian beem abiw abiw angom alik alik ilo diw yetebam unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Keko beli, ben kel itol be, Isiw aneng fian be wanin yom am kuw fok fok angei, ");
INSERT INTO bhl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yosew e kawtiw im musun wanin angom alik alik beem anung makmak kuluko, mewso biliw abiw mutuk fian biim wanin kubul dukukabiliw am ka kel bongguko, dukuse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Dukusomelei, wanin dukukabiliw am alik alik beem wanin e banso banso kesomi, am gekse kale. Wit dem beem fufu e yas kutew ol atew kese kasike, wanin kubul dukukabiliw kunum bi ki keko, elo teing bokolinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Isiw aneng fian em wanin yom am ding kelei, olfut fian telinba kese ding dim kabalak e, Keliofolis abiw mutuk fian em kunum ayem Fotifelas beem mun Asenat u ukalem imok Yosew elo kunum aul alew mak dukulewsu kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Dukulewui, Yosew e akalem seiw men dukusu aul beem wiin e “Manase”, dangse kale. Nimtew angom? E bokolomele: “Sunbin-Got e nelo dokonemse kasike, nem kanenemse anggil ilum so, nakalem angin kaim atuk so, alik alik biilo akokow kebi te.”, angse kasike. ");
INSERT INTO bhl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Angeko, emteben dukusu min beem wiin e “Efalaim”, dangse kale. Nimtew angom? E bokolomele: “Aneng ka kel ne anggil ilum fian kulusi kate, Sunbin-Got e nelo bamki so kenembe.”, angse kasike. ");
INSERT INTO bhl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Beli, Yosew em emisik yangse weng be fein kese kale. Isiw aneng fian beem wanin yom am kesiliw ben kel itol e banimei, aneng aneng angom beem olfut fian keloke ben kel itol kesiliw kale. Olfut fian talse kate, Isiw aneng fian em kunum waneng alik alik im wanin e baniminba kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kate, olfut atin kuw fian kese kasike, Isiw aneng fian em kawtiw ikati wanin sukumsiliw kale. Sukumsiliw ding dim kabalak e, kawtiw i Isiw aneng fian em emisik kamok fian em mit mewso teleko, amemin weng gaaneko, bokolewomeliw: “Kamok kutaka! Wanin fongate akate yemena! Yemena!”, dangiwi, e ilo yan weng bokoyemomele: “Yu Yosew em mit uneko, elo bokolewina! Bokolewko, em yangoke weng beelo gelewina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","57","Keko beli, Yosew e abiw mutuk fian biim wanin kubul dukukabiliw am beem yal busuko, beem wanin be on kisol so wese kale. Wese kate, olfut be fian kuw beki beki kelei, aneng aneng angom alik alik biim biliw kawtiw i alik alik Yosew em be fukun teleko, on kisol so wanin wesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Beli, olfut am kese ding dim kabalak e, Sekow e kililete: “Isiw aneng fian be wanin webiliw tako!”, angbiliwi, e kilisomi, akalem muluwel ilo bokoyemomele: “Yutaka! Yukalem kuw ateme ateme keko, sak kuw bin ba?”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Yangeko, bokoyemomele: “Ne kililite: Isiw aneng fian ka kel wit wanin webiliw kasike, yu uneko, wanin wen telina! Mesik esik nu wanin tew so bomi, kuanokoluw kasike!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yangei, Yosew em king kel awkunum kusel i fein Isiw aneng fian kalo wit wem unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Unsiliw kate, Sekow e akalem afung min Benyamin beem dulum elote finganeko, ibolow fukunomele: “Mesik esik e iso unei, maka i elo alokoliw kai!”, angomi, elo dabalalinba kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Keko beli, Sekow em muluwel biso, mali Kenan aneng fian beem kasel iso, alik alik i bongguko, Isiw aneng fian elo wanin wem unsiliw kale. Nimtew angom? Im alakabiliw Kenan aneng fian kel akati olfut am fian mak kese kasike. ");
INSERT INTO bhl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Keko beli, Yosew e Isiw aneng fian em wanin atebe kak kunum ke alenale kasike, kawtiw angom alik alik i em mit elo teleko, on kisol so em dim wanin wemaliw kale. Webiliwi, Yosew em fik kusel ikati em mit mewso teleko, katin bukbuk angko, gatak wakas kiinguen kawin dim dasomeliwi, Yosew em wiin daolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kanelewsomeliwi, Yosew e akalem fik kusel im kanebiliw be yetemse kate, e ilo akokow kunum emdiw keyemsomi, kitil weng makuw bokoyemeko, ilo dakalalomele: “Yutaka! Yu nal em aneng elote teliw a?”, yangei, i yan weng bokolewomeliw: “Nu Kenan aneng fian em kasel nute te. Nu kaleelo wanin wem talbuluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Dangeko, Yosew elo kal kelinba kesomi, akokow kelewsiliw kate, akalem ete ilo kilele kal keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Fik kusel biim kanelewsiliw ding dim be, e akalem suaem kiin dem seneko, atemse beelo ibolow fukunse kale. Seneko, atemse beem dim be, e akalem awkunum kusel biim akalem mit elo teleko, katin bukbuk kelokoliw kukuw be fein atemse kale. Keko beli, e ilo bokoyemomele: “Maka kiin kiin kunum yutaka! Nem aneng fian kaleelo ‘Nal kel ete kitil kelinba kebiliw yake!’, angomi, maka kiin kiin kem talbiliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Yangei, i yol angeko, yan weng bokolewomeliw: “Itel bayo! Kom weng afak kunum nu wanin ete kuw wem talbuluw te. ");
INSERT INTO bhl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Alik nukalem aatim e makmak kuw te. Nu kiol kuw fein kukuw kekabuluw kunum kasike, nu maka kiin kiin kunum nute bate.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Dangiwi, Yosew e ilo bokoyemomele: “Babo! Yu ‘Nal em dulum elote kitil kelinba kebiliw yake!’, angsomi, maka kiin kiin kem talbiliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Yangei, king kel awkunum i yan weng bokolewomeliw: “Kom weng afak nunggdel nu kalun kel kunum kate, num aatim makmak kuw te. Num ning afung so, aatim so, yelim i makuw nukalem am biliwi, mak e banimse te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Dangiwi, Yosew e iti ilo bokoyemomele: “Feinka! Yu maka kiin kiin kem talbiliw kasike, ");
INSERT INTO bhl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","16","alik alik yulo sok am tem da koyemomin kemi te. Kate, ne yulo kiskis mak keyembi te. Yukalem mak kunum mak uneko, afung ning tanbel beelo debele teleko, nem kiin dim kale kel moloka! Mo kolinba kelew tewe, alik alik yu iti yukalem aneng elo nam uniw te! Kate, kawkunum so, yukalem ning afung so aso i fein kale kel teliw tewe, ne yukalem nangiw weng beelo diweko, “Fein weng te!”, yangoki te. Kate, ne kilele kal kebite: Yu maka teleko, kiin kiin kakabiliw kunum yute te!”, yangeko, Isiw aneng fian em emisik kamok fian em wiin fian beem dim e ayem fawtuk weng kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Keko beli, e mali wonuk so kunum mak gaayemei, i teleko, king kel awkunum kumel biilo yemdeko, sok am tem da koyembiliwi, alemsal kel ding banimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Alemsal kel ding be banimei, Yosew e akalem awkunum kusel ilo bokoyemomele: “Ne Sunbin-Got em weng kiliko, gelewkabi kunum kasike, yu kale teleko, nem weng be kiliko, gelewina! ");
INSERT INTO bhl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Yu fein kukuw kuw gelewkabiliw kunum keliw tewe, yom kawkunum makmak kuw kale kel bomelei, teiw kel awkunum kumel yu uneko, yukalem wanin tew so teinbiliw angin biim dulum elote wit dem on kisol so weneko, de unemoliwka! ");
INSERT INTO bhl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","De unesomi, iti teleko, yukalem afung ning beelo bakati debele telina! Yu elo fein debele teliw tewe, ne kilele diw atemeko, yom nangsiliw weng beelo “Fein kai!”, dangomi, yulo nam yenii, kuaniw te.”, yangse kale. Yangei, i em weng be kiliko, gelewsomeliwi, ");
INSERT INTO bhl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ikalem kuw weng mak bokolomeliw: “Fein! Sua e, nu nawkunum Yosew em gaayemale weng be kililinba kesomi, em finganin fian be atebamuluw kate, nu elo kinkin ibolow dulewinba kesuluw te. Kame, nu kanesuluw beem yan wa kuluko, buluw te!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Angiwi, fik dil Uluben e mali ninggel kumel biilo bokoyemomele: “Sua kel akate, ne yulo bokoyemomeli: ‘Yu kanelom ning beelo wa kukuw mak kelewbokoliw te!’, yangenali kate, yu nem weng kililinba kesiliw kasike kame, nukati emdiw kuanokoluw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Awkunum kumel biim bakabiliw ding dim be, i ikalem weng sin kel bokolew bokolew keliwi, Yosew e im angbiliw weng beelo kililinba tew kese kale. Weng sin femdakamin kunum mak Yosew em weng so, awkunum kumel biim yan weng so, alik alik biim weng femdes keleweko, ilo bokoyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Beli, Yosew e im ikalem weng sin kel bokolew bokolew kesiliw weng be fein wosuse kasike, e ibolow tiaktiak kesomi, yawal tal kel uneko, amemin fian mak kese kale. Amemin goto kolewse ding kabalak e, iti teleko, awkunum kumel iso mali weng mak bokoyemse kale. Bokoyemei, fe e, e akalem wonuk so kunum ilo weng mak bokoyemomelei, i teleko, Simeon elo awkunum kumel biim kiin dim kel sok so nit net kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Kolewsomeliwi, Yosew e akalem weng afak kunum biilo yawal weng mak bokoyemomele: “Kunum kaliim wit wanin so, ikalem de teliw on kisol beso, alik alik be ikalem men tem kel abuyemoliwka! Abuyemeko, ikalem deiw am em wanokoliw wanin akati duyemoliwka!”, yangse kale. Yangei, em weng afak kunum i akalem weng be kiliko, wanin akal, de talsiliw on kisol akal, alik alik be fein awkunum kumel biim men tem kel abuyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Abuyemiwi, awkunum kumel i ikalem men be kuluko, donki em dang dim dukuko, unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Unsomeliwi, deiw am mutuk mak akalomin teinsiliw kale. Teinsomi, awkunum mak “Donki elo wanin yemeno yo!”, angeko, akalem men bontak kelewko, atemomete: Akalem de unese on kisol alik alik be iti akalem men tem abuliwi, atemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Atemko, yol angeko, akalem awkunum kusel ilo bokoyemomele: “Yake yutaka! Nakalem on kisol e iti abunem kembiliw kate!”, yangse kale. Yangei, ikati yol ange ange keko, finganeko, bokolomeliw: “Eke! Sunbin-Got e nulo nono keyeme ye?”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kesomeliwi, i Kenan aneng fian kalo uneko, ikalem alew Sekow em mit teleko, elo ikalem kaneyemse sang be bokolewomeliw: ");
INSERT INTO bhl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Isiw aneng fian em kamok fian e nulo kitil weng mak bokoyemomele: ‘Yu maka kiin kiin kunum kesomi, teliw te!’, yangei, ");
INSERT INTO bhl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","nu elo yan weng bokolewomeliw: ‘Bayo! Nu kiol kukuw so kunum nute te! Nu maka kiin kiin kunum bate! ");
INSERT INTO bhl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nungumel nu kalun kel kunum kate, awkunum mak e banimei, afung ning e aatim so Kenan aneng fian kel alakabe te.’, dangesuluw te. ");
INSERT INTO bhl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Danguwi, Isiw aneng em kamok be iti kitil weng mak nulo bokoyemomele: ‘Yulo kiskis koyemoki weng mak bokoyemsomi, yom kukuw kilele diwyemoki te. Kame, mak kawkunum makmak neso kolew unina! Kolew uniwi, mali yu uneko, yom wanin tew so teinbiliw angin biilo wanin be de unina! ");
INSERT INTO bhl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","De unokoliw kate, yu uneko, yom ning afung beelo nem fukun debele tololiwka! Debele teliwi, ne elo fein atemi tewe, ne ‘Yu maka kiin kiin kunum bate! Kiol kukuw so kunum yute te!’, yangesomi, kolew uniw kawkunum bakati kolewii, eso, yangdel yuso, kawkunum kumel alik alik yu Isiw aneng kale kel yukalem ibolow kuw gelewemokoliw te.’, yangese te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Dangesomi, ikalem wit abuyem kembiliw be kawo matem matem duku duku kesomi, atemiwete: “Nukalem on kisol akati men abuyem kembiliw tako!”, angeko, yol angeko, atemsiliw kale. Atemiwi, alew Sekow akati atemei, ikalem makuw yol angeko, ibolow tiaktiak kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kesomeliwi, alew Sekow e akalem muluwel biilo bokoyemomele: “Yu nakalem aul alik alik ilo banimkabiliw te! Emisik e, Yosew e banimei, kame e, Simeon akati banime te. Banimei, kame nem min afung Benyamin bakati singam aneng elo debele unoliw e? Ebe! Yu kaneliw tewe, nem kulukabi ibolow anggil ilum be nam banime kate!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Yangei, emisik dukuse min Uluben e alew beelo bokolewomele: “Ne uneko, ning Benyamin beelo iti debele telinba keli tewe, ku ning beem yan alwol nakalem kunum aul alew biilo yenolewka! Ku kanelom finganemokolew te! Benyamin elo nem teing dim kel konemewi, ne elo iti kukalem fukun debele teloki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Dangse kate, Sekow e bokolewomele: “Nem afung aul kale kuso nam une te. Nimtew angom? Awkunum yelew ikalem auk diw mak kunum e kuanei, emikel kuw nuso alakabe kasike. Ne fasel kebi kasike, aul be uneko, deiw mutuk kel wale tewe, kom sen em mongom ete ne iti kal ilum fian mak kulusomi, sakik fian so kuaneko, awalik kumel biim finik am biliw dim elo unoki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Beli, beem ding kabalak e, olfut fian fian kuw kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kese kasike, Sekow em angin i sua kel em Isiw aneng fian kel em wesiliw wit wanin alik alik be wanbiliwi, wanin be banimse kale. Banimei, Sekow e akalem muluwel ilo bokoyemomele: “Yu uneko, iti Isiw aneng fian elo wanin wem unoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yangei, Suda e alew elo bokolewomele: “Aatim kutaka! Nu sua kel akal bokokemsuluw te. Isiw aneng fian em kamok fian be nulo kitil weng mak bokoyemomele: ‘Yom ning afung be debele telinba keliw tewe, yu nelo kanelom netemokoliw te!’, yangse te. ");
INSERT INTO bhl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Yangse kasike, ku nukalem ning beem dulum elote ‘E yuso makuw unoka!’, angew tewe, nu fein wanin wem unokoluw te. ");
INSERT INTO bhl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kate, ku nulo ‘Bayo!’, angew tewe, nu nam unuw te. Nimtew angom? Kamok kunum be nulo bokoyemomele: ‘Yom ning afung be debele telinba keliw tewe, yu nelo kanelom netemokoliw te!’, yangse kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Dangei, alew Isalael e akalem muluwel ilo bokoyemomele: “Ibo! Yutaka! Nimtew angom ete yu kamok beelo bokolewomeliw: ‘Ning mak alew eso kolew teluw te.’, dangesiliw, a? Dangsiliw beem mongom ete yu kame nelo ilum fian mak dunemkabiliw kasike!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Yangei, awkunum kumel i alew elo yan weng bokolewomeliw: “Kamok kunum be nulo dakalakamin fian mak dakalakakabe te. E dakalalomele: ‘Yom kalew e kait be yako? Yom kawkunum akati kait be yako?’, yangeko, nulo dakalakamin fian kuw dakalakakabe te. Nukati dakalakamin beem mongom akokow so kesomi, kaim dim kuw yan weng bokolewsuluw te. Bokolewuwi, e nulo bokoyemomele: ‘Yom ning afung be debele tololiwka!’, yangse te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Dangiwi, Suda e alew Isalael elo bokolewomele: “Ku nukalem ning afung Benyamin beelo nem teing dim elo kolewewi, nu unuw tewe, kuso, nuso, alik num aul waneng iso, alik alik nu nu yemen tew kesomi, nam kuanuw te. ");
INSERT INTO bhl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nakalem ete aul beelo fein kuw kilele atemeko, debele unoki te. Ne elo debele teleko, iti kilele kom kiin dim kel mo kolewinba keli tewe, nakalem ete sen beem ilum e diwkuw diwkuw daoko, unbi unbi somelii, kuanoki te. ");
INSERT INTO bhl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ku fein num weng kiliko, nulo fongate akate yamdalew tewe, nu kame alew ding mak unesomi, iti telesuluw te. Kom sen ete te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Dangei, alew Isalael e ibolow tem tem neknek kebisomi, ilo yan weng bokoyemomele: “Kenka. Nu wanin kulomin deiw mak fensuluw kate, nanew deiw banime kasike, yu nakalem afung min beelo Isiw aneng fian beem kamok em mit mewso debele unia! Kate, aneng kaleem on kisol mesesem mesesem eisneng mak akati de uneko, kamok beelo yan banim sak kuw dulewoliwka! Dulewokoliw eisneng be kanekote: Ais gom kamge so, mong tugul abal so, mali ais dem gelgel fif nam so, alik alik be de uneko, kamok fian beelo sak yan banim dulewoliwka! ");
INSERT INTO bhl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Dulewsomi, iti wanin wenomin on kisol so, suaem de unsiliw on kisol ming beso, alew bongguko, de unoliwka! Mesik esik suaem on kisol iti abuyemsiliw kunum i kawkaineko, ibolow teifulusiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kate kame, yu yukalem ning be fongate akate debele uneko, Isiw aneng fian em kak kunum beem mit mewso debele unina! ");
INSERT INTO bhl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nakalem Auk so Sunbin-Got e yulo kinkin ibolow keyemsomi, kak kunum beem ibolow tem alwol kelewoke te. Kelewoke kasike, e yulo ibolow menew kukuw kuw kukuyemsomi, awkunum Simeon so, ning Benyamin so, aso ilo koyemei, alik alik yu bongguko, makuw kesomi, iti kale kel tolokoliw te. Kate, nakalem muluwel alik alik yu banimiw tewe, bakati ken kuw. Ki.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Yangei, muluwel yangmel bi mesesem sak yan banim on kisol kak kunum elo dulewomin ibolow kesiliw eisneng beso, wanin wenomin on kisol so, suaem de unsiliw on kisol ming so, alik alik eisneng be bongguko, memen kesomi, ikalem ning Benyamin akati kulusomeliwi, yangmel alik alik i Isiw aneng fian kalo Yosew em fukun gulili unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Keko beli, yangmel i Isiw aneng fian mindak baku angiwi, Yosew em Benyamin eso akalem awkunum kumel iso teliwi, yetemse ding dim e, e akalem weng afak kak kunum elo bokolewomele: “Kutaka! Ku fongate akate uneko, kunum min biilo nem am kaleelo yemde una! Yemde uneko, samal mak aneko, wanin memen kela! Ne kunum biso makuw bonggu teineko, wanin wanoki kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Dangei, kunum be em dangse weng be kiliko, geleweko, kunum min biilo yemdeko, Yosew em am elo yemde unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Yemde unei, Yosew em awkunum i atemiwete: “E nulo kak kunum beem am elo yemde unomin kebe kai!”, angeko, ibolow tiaktiak kesomi, finganeko, dumdum keko, fukunomeliw: “Yake! Yake! Mesik esik num dil em tuluwi, i on kisol iti num men tem dasiliw beem mongom ete kaneyembiliw sake? Kame, wonuk so kunum i nulo kuiaw tom yebomi, nulo ikalem sak weng afak kunum keyemokoliw te. Keko, num donki bakati deyem unokoliw sako!”, ange ange kesomi, olsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Keko beli, im Yosew em am abisom dim mosiliw em ding dim e, i kalo yemde unse kunum beelo bokolewomeliw: ");
INSERT INTO bhl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Kamok a! Ku nukalem weng kale kilele kilia! Num emisik ding Isiw aneng fian kalote wanin wem talsuluw ding dim kabalak, ");
INSERT INTO bhl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","nu wanin mak weneko, iti unsuluw te. Num uneko, deiw am mak akalsuluw ding dim kabalak e, nu nukalem men tem bamtak silel kesomi, atemuwete: Nukalem wanin wesuluw on kisol so, wanin so, bongguko, men tem kel belei, atemsuluw te. Kasike kame, nu emisik mikmik dim de talsuluw on kisol beelo iti de tuluw te. ");
INSERT INTO bhl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kante kisol be num men tem iti dayemko, abuyemse be nu akokow so te. Kame, nu iti wanin wenomin beem on kisol tikin de tuluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Dangiwi, e yan weng bokoyemomele: “Yu kanelom finganemokoliw te! Yukalem so, kalew so, yelim yom Sunbin-Got e on kisol be iti yom men tem dase te. Yukalem wanin wesiliw yan on kisol be ne fein kuw kulusi te.”, yangse kale. Yangeko, im sok am da kolewsiliw awkunum Simeon akati matem dako, mali awkunum kumel im dim mewso kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Koleweko, ikalem yan gingenomin ok sen duyemeko, ikalem donki akal wanin kaabom duyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kuyemsomelei, awkunum kumel bi Yosew em toloke ding fenbomi, mesesem on kisol elo sak yan banim dulewomin ibolow keseiliw eisneng be memen kesomi, bisiliw kale. Nimtew angom? I kililiwete: “Ataan mutuk doung keloke ding dim bakate, Isiw aneng fian kaleem kak kunum be akalem am kale telei, eso yuso, alik yu makuw wanin wanokoliw te!”, yangiwi, i kilisiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Keko beli, Yosew em akalem aluwbamin dim koleweko, akalem am elo talse ding kabalak e, i elo sak dulewomin on kisol mesesem mesesem eisneng be akalem teing dim daleweko, em mit elo katin bukbuk angeko, gatak wakas angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Angiwi, e ilo bokoyemomele: “Yukati ken kuw biliw yako? Yom nelo bokonemsiliw kalew fasel akati ken kuw be yako? E kuanse sako?”, yangei, ");
INSERT INTO bhl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","i yan weng bokolewomeliw: “No! Kukalem weng afak kunum keko, num aatim bakati ken kuw bomi, kait be te.”, dangeko, iti em mit kel katin bukbuk angeko, gatak wakas angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Angiwi, e akalem auk diw afung ning Benyamin elo atemeko, mali awkunum kumel ilo dakalalomele: “Yom dil teleko, em sang bokonemsiliw ning e kale be ye?”, yangeko, elo bokolewomele: “Aul kutaka! Sunbin-Got e kulo ibolow folok so kukuw kekemoka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Dangse ding dim kabalak e, e akalem ning beelo kilele atemeko, kalfongdeweko, ibolow mutuk fian kuw dulewsomi, amemomin ibolow kelewse kasike, e im ka biliw dim be koleweko, fokong am mak elo kawtem uneko, emikel kuw bomi, amese kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ame koleweko, kiinguen ok so ging kolewsomi, kitil keko, gui ange kolewsomelei, matem teleko, akalem weng afak kunum ilo bokoyemomele: “Yutaka! Kame wanin fongate kuw de telina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yangei, i fein wanin de teleko, Yosew emikel amen, awkunum kumel imikel amen, alik alik biim wanin amen amen yak yak deyem teleko, duyemsiliw kale. Nimtew angom? Isiw kawtiw i Kibulu kawtiw iso diw ke waninba kesomi, “Be inkal so, wa eisneng ete te!”, angakabiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Keko beli, Yosew akalem ete akalem awkunum kumel alik alik biim teinomin dim kukuyemse kale. Kukuyemsomelei, e auk kumel im yangmel biim kail koyemsiliw sang bete kuw gelewse kale. Emisik dukusu min Uluben emisik teinkemin abin kukuleweko, tein fakalam uneko, ning afung Benyamin em fefe teinkemin abin kukulewse kale. Kaneyemse kasike, awkunum kumel i kanelewse eisneng be atemeko, yol ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kesomeliwi, Yosew e akalem weng afak kunum ilo gaayemei, i akalem wanin anung mak kulusomi, awkunum kumel ilo dukuyem yak yak amen amen keyemsiliw kale. Keyemsomi, awkunum kumel alik biilo anung makmak kuw keyemsiliw kate, Yosew em auk diw ning Benyamin elo wanin anung teingabi kel dulewsiliw kale. Keko beli, i wanin so, wain ok so, wanin banban kuw aukfoko wanesomeliwi, kiin felfel kuw kesomeliwi, iso eso kalfong fian kuw kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Beli, wanin wanesomi, banimsiliw ding kabalak e, Yosew e akalem weng afak kak kunum beelo bokolewomele: “Kame wit wanin kuluko, kunum min biim kingti unomin beem kitil emdiw ikalem men tem wenyemomaka! Wenyemeko, im de teliw on kisol tum win bakati ikalem men tem abu yak yak keyemoka! ");
INSERT INTO bhl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kesomi, nakalem on kisol so wain ok sen beelo kuluko, ning afung em wanin abulew em men tem ka kel akati abulewa!”, dangse kale. Dangei, e fein Yosew em dangse weng be gelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kaneko beli, kutim matem danse ding dim bakate, Yosew e akalem awkunum kumel ilo yemdalewi, i fein ikalem donki so unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Uniw, im abiw mutuk fian koleweko, singam kelinba kesiliw ding bakate, Yosew e akalem weng afak kak kunum beelo bokolewomele: “Kame fongate akate kunum min biilo yenggelew una! Uneko, yeit moko, yetemew tewe, ku ilo bokoyemomelew: ‘Nu yulo kukuw ken kuw kukuyemuw kate, yusik nimtew angom ete femdes kesomi, nulo wa kukuw kuw kukuyem teliw a? ");
INSERT INTO bhl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nimtew angom ete yu nakalem kamok em selew selew kesomi, wain ok wanakabe ok sen beelo yakut kelew teliw a? Feinka! Yu atin wa kukuw kuw kukulewiw te!’, yangolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Dangei, kunum be em weng geleweko, awkunum kumel ilo yenggelewsomi, yeit moko, Yosew em bokolewse weng be ilo kalan weng bokoyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bokoyemei, i yan weng bokolewomeliw: “Kamok kutaka! Ku nimtew angom ete kaneko weng wa be nulo bokoyemew a? Nu kiol kuw kukuw gelewbuluw kunum kesomi, yangbelew emdiw nam keluw te. ");
INSERT INTO bhl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Emisik talsuluw ding em wanin wenomin em on kisol nu iti de taluwi, ku kilele atemew te. Kasike kame, nu nimtew angom ete kom kamok em on kisol eisneng beelo yakut keko, de tuluw a? ");
INSERT INTO bhl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kate, nungmel nu kom weng afak kunum kesomeluwi, ku nukalem kamok kasike, ku nukalem men alik alik diw yak yak kelewolewka! Kesomi, kanem men ete kamok em wain ok sen be belei, atemew tewe, ku men beem kayak elo alolewka! Alewi, e kuane kano, mali nu diwkuw diwkuw kom sak weng afak kunum kuw kelokoluw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Dangiwi, e yan weng bokoyemomele: “Kenka! Yom weng bakabiliw bakate gelewbuma! Kanem men tem kel nem kamok em wain ok sen belei, atemi tewe, men beem kayak nakalem sak weng afak kunum keloke te. Kate, mali yu iti sak yukalem am dim elo unina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Yangei, i fongate akate ikalem men dokong mit mit kawin dim dukuko, men bontak bontak kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Keliwi, kunum be fenyem yak yak kese kale. Fik Uluben em men emisik fendeweko, ning afung Benyamin em men be fefe ete fendewse kale. Fendewsomelei, ning afung em men kel be wain ok sen be fein belei, atemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Atemei, yangmel bi yol fian angeko, sakik ilum kulusomi, ikalem ilim dakaleko, ikalem men mesesem mesesem alik alik be iti ikalem donki dim duku duku kelewsomi, alik alik makuw abiw mutuk fian elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Keko beli, Suda so akalem awkunum kumel so, alik alik bi iti Yosew em am elo telesomi, Yosew elo teinbelei atemeko, em mit mewso kawin katin bukbuk angeko, gatak wakas teinsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Teiniwi, Yosew e ilo dakalalomele: “Yu nono kenem teliw a? Yu akokow kebiliw sako? Nakalem ete auk so selew selew kunum kesomi, okmobe eisneng kilele atemkabi kunum nete te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yangei, Suda e yan weng bokolewomele: “Kamok kutaka! Num dulum akati weng banim te. Sen beelo banimomin deiw mak banim te. Sunbin-Got esik nulo diwyemeko, ‘Sen so biliw kai!’, yangse kasike, alik alik nu kame kukalem sak weng afak kunum kebokoluw te! Kunum beem men kom wain ok sen abubelei, ateme kunum bakati, alik alik nukati te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Dangei, Yosew e yan weng bokoyemomele: “Bayo! Alik yu bate! Beem men nakalem wain ok sen abubelei, ateme kunum bete kuw nem sak weng afak kunum keloke te. Mali yu ibolow menew kesomi, iti yukalem kalew em fukun unina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yangei, Suda e Yosew em mit teleko, bokolewomele: “Kamok kutaka! Ku Isiw aneng fian kaleem emisik kamok fian emdiw kesomi, kamokim fian kute te. Ku sak kunum nem weng kale kiliko, kanelom kaisuw kenemokolew te! ");
INSERT INTO bhl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Kamok kutaka! Emisik ding kabalak e, ku nulo dakalalomelew: ‘Yom kalew e kait be ye? Kawkunum kumel makso biliw e?’, yangewi, ");
INSERT INTO bhl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","nu yan weng bokokemomeluw: ‘No. Aatim e be kate, e fasel nam te. Em fasel kese ding kabalak e, akalem ibolow so keuumkabe kalel u aul alew mak dukusu te. Mak e kuanei, mak e num ning afung ful ete te. Aatim e afung aul beelo ibolow mutuk fian kuw kelewkabe te.’, kangsuluw te. ");
INSERT INTO bhl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Kanguwi, ku nulo bokoyemomelew: ‘Yu uneko, sow em iti tolokoliw ding dim kabalak, afung ning ful beso dabele teliwi, ne elo atemoki te!’, yangselew te. ");
INSERT INTO bhl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Yangewi, nu yan weng bokokemomeluw: ‘Afung ning be aatim elo koleweko, kaleelo tele tewe, aatim e beem mongom angom be kuanoke sako.’, kangsuluw te. ");
INSERT INTO bhl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kanguwi, ku nulo yan weng bokoyemomelew: ‘Yukalem afung ning be dabele telinba keliw tewe, yu nem kiin dim kel nam fitewiw te!’, yangselew te. ");
INSERT INTO bhl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Yangewi, nu kom yangselew weng be kiliko, kom weng afak kunum num aatim elo bokolewomin de unsuluw te. ");
INSERT INTO bhl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Anfel e, aatim em ‘Yu iti nukalem wanin wem unina!’, yangse ding kabalak e, ");
INSERT INTO bhl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","nu elo yan weng bokolewomeluw: ‘Nukalem ning afung be nuso makuw debele uninba kelew tewe, nu ki keko, kamok fian beem kiin dim mewso nam unuw kasike, nu Isiw aneng fian elo nam unuw te.’, dangsuluw te. ");
INSERT INTO bhl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Danguwi, e nulo bokoyemomele: ‘Yu kal kebiliwte: Nem ibolow fian keumbi kalel u aul alew kuw dukusu te. ");
INSERT INTO bhl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mak e konemeko, unei, ne elo ateminba bi te. Kut samal ite elo an waniwi, e kuanse sako. ");
INSERT INTO bhl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kame mak bakati singam aneng elo debele uniwi, maka mak elo aliw tewe, yu nelo anggil ilum fian mak dunemokoliw te. Ne sakik fian kuluko, kuaneko, awalik kumel im biliw finik am dim elo unoki te.’, yangse te. ");
INSERT INTO bhl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Yangse kasike kame, kom weng afak kunum nakalem ete iti uneko, num aatim fasel beem kiin dim mewso telii, e ibolow fian kelewkabe afung aul be ateminba kele tewe, nu elo sakik ilum fian kuw dulewuwi, e kuaneko, awalik kumel im biliw finik am dim elo unoke te. ");
INSERT INTO bhl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Kamok kutaka! Ne aatim elo fawtuk ayem weng mak bokolewomeli: ‘Aul kale iti debele telinba keli tewe, ne diwkuw diwkuw kom kiin dim kel sen so kesomelii, sen ilum be nem dim kilis angboke te.’, dangsi kasike kame, ");
INSERT INTO bhl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","nakalem ete afung ning beem abin kulii, ku nelo kom sak weng afak kunum kenemolewka! Kate kunum besik kolewewi, e nakalem awkunum kumel iso iti nukalem am dim elo uneko, aatim em fukun unoka! ");
INSERT INTO bhl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nimtew angom? Ne ki keko, aatim em kuloke sakik anggil ilum fian be nam atemoki kasike. Feinka! Nakalem ete ki keko, aatim em fukun nam uni kasike.”, Suda e Isiw em kamok Yosew elo bokolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Keko beli, Yosew e Suda em elo dangse weng be kiliko, ibolow fukunin tiaktiak kuw kesomi, akalem weng afak kunum alik alik ilo bokoyemomele: “Yu nelo konemeko, alik kut unina!”, yangse kale. Yangei, Yosew so, akalem awkunum kumel so, ikalem ete imikel kuw am fokong kawtem kel bisiliw ding dim e, Yosew e akalem ete kaim dim dako, bokoyemomele: “Nakalem ete yukalem kawkunum Yosew nete te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yangeko, amemin fian mak kese kasike, mali ka biliw kawtiw ikati em amese be kiliko, weng de uneko, Isiw aneng fian em emisik kamok fian beelo weng kal bokolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Keko beli, Yosew e akalem awkunum kumel biilo iti bokoyemomele: “Yosew nete te. Aatim e ken kesomi, kait be ye?”, yangse kate, awkunum kumel i yol angeko, yan weng banim kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kesomeliwi, Yosew e iti bokoyemomele: “Yu nem mit mewso telina!”, yangse kale. Yangei, im em mit mewso talsiliw ding ete, e bokoyemomele: “Sua kel e, yu nelo on kisol so alwol kenemiwi, mali wemin kunum i nelo Isiw aneng fian kaleelo nemde talsiliw te. ");
INSERT INTO bhl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nemde talsiliw kate kame, yu kanelom ibolow fukunin tiaktiak kesomi, sakik ilum kemokoliw te! Babo! Nimtew angom? Sunbin-Got e nelo nemisik aneng fian kaleelo nemdase kasike, alik alik nu wanin tew keko, nam kuanuw kasike. ");
INSERT INTO bhl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Yu kilele kililina! Kame, olfut fian kale itol alew kuw keko, banimse kate, olfut be bomelei, iti teingabi kel itol mak keloke te. Keloke beem ding dim bete, kunum waneng i wanin kailokoliw kate, wanin be yom fok angeko, nam dem gilale te. ");
INSERT INTO bhl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Yulo kilele dokoyemomin beem momgom e Sunbin-Got e nemisik namdase kasike, yuso, yukalem waneng aul iso, alik alik yu wanin tew so teineko, nam kuaniw kate, yukalem wiin so, yukalem angin so, diwkuw diwkuw kawin dim kale kakamokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kasike, yukalem ete nelo kaleelo nemdelinba kesiliw kate, Sunbin-Got akalem ete nelo nemisik namdase te. Namdalei, ne Isiw aneng fian kaleem emisik kamok fian em alew atew kesomi, akalem am so mesesem so, Isiw aneng fian so, alik alik beem kamok fian kebi te. ");
INSERT INTO bhl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Kame, yu fongate akate aatim elo weng kal bokolewomin de unina! Bokolewokoliw weng be kanekote: ‘Kukalem min Yosew ete weng be bokokemomele: ‘Sunbin-Got e nelo Isiw aneng fian kaleem kamok kenemse kasike, ku kanelom neknek kesomi, fongate akate em mit elo tololewka! ");
INSERT INTO bhl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Telesomi, nem alakabi dim mewso ka kel Isiw aneng fian beem anung Gosen kel bolewka! Ku so, kukalem muluwel dow iso, kom samal so, kom mesesem mesesem eisneng beso, alik alik bi yemde teleko, kale kel boliwka! ");
INSERT INTO bhl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ku teleko, Gosen aneng kale kel bew tewe, ne ki keko, kulo kilele dakakemboki te. Nimtew angom? Kanekabe olfut be tiak ding belei, itol teingabi kel kabalak ete kuw banimoke kasike. Mesik esik kuso, kukalem angin so, yukalem on kisol wiin so eisneng beso, alik alik bi banim keloke kasike.’, dangoliwka! ");
INSERT INTO bhl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yukal, nem ning Benyamin akal, alik alik yu kiinso walaliwete: Ne Yosew nete te. Yosew nakalem nete yuso weng bakabi te. ");
INSERT INTO bhl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kate kame, yu fongate akate aatim em mit uneko, elo nem kanenemsiliw em sang bokolewomeliw: ‘Yosew e Isiw aneng fian em kamok wiin so kunum kebe te.’, dangoliwka! Dangiwi, e kiliko, fongate akate kaleelo tolomaka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yangesomelei, e ning Benyamin elo falal kelewei, akalem so, Benyamin so, aso i makuw amesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Amemsomeliwi, Yosew e awkunum kumel alik alik ikati falal koyemeko, amese kale. Amesomelei, fe e, eso awkunum kumel iso, alik alik i weng bokolew bokolew kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Beli, Isiw aneng fian em emisik kamok fian e kililete: “Yosew em awkunum kumel i tabiliw kai!”, angiwi, e kilisomelei, eso, akalem weng afak kunum iso, alik alik i kiliko, kalfong fian kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kesomeliwi, Isiw aneng fian em emisik kamok fian be Yosew elo bokolewomele: “Ku kawkunum kumel ilo bokoyemomelew: ‘Yu nem weng kale kililina! Yu fongate akate yukalem mesesem mesesem eisneng kuluko, donki dim dukusomi, iti Kenan aneng fian elo unoliwka! ");
INSERT INTO bhl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Unesomeliwi, kalew so, yukalem aul waneng so, alik alik yemde tololiwka! Yemde telesomi, Isiw aneng fian beem anung ken mak yulo duyemii, yu ka kel bomeliwi, nakalem Isiw aneng fian kaleem emisik wanin be wanbokoliw te.’, yangolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Dangeko, iti bokolewomele: “Ku teinkemin eisneng beem dim teinsomi, unom eisneng mali mak kulusomi, kawkunum kumel ilo duyemewi, i ikalem mesesem mesesem eisneng so, ikalem kalel kumel so, ikalem muluwel so, kukalem kalew fasel so, alik alik bi kuluko, im dim dukusomi, yemde tololiwka! ");
INSERT INTO bhl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","I mesesem mesesem eisneng mak Kenan aneng fian kel kolew teliw tewe, i kanelom beem ibolow fukuneko, sakik kelokoliw te! Nimtew angom? Aneng kaleem kenati eisneng alik alik be ne yulo duyemoki kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Dangei, Isalael em kalun kel muluwel bi emisik kamok fian em ilo yangse weng be kilisomeliwi, Yosew e teinkemin eisneng beem dim teinsomi, unomin eisneng mali mak so, deiw beem unokoliw wanin so, kuluko, ilo duyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Duyemeko, awkunum kumel ilo ilim kikis mak amen tak tak duyemse kate, e auk diw Benyamin elo teingabi kel ilim kikis so, on kisol tum win 300 so, dulewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Dulewsomi, Isiw aneng fian beem kenati eisneng mak kulusomi, king kel donki imok mak kuluko, biim dim dukusomi, iti king kel donki yanggus mak kuluko, wit wanin so, belet wanin so, akalem alew em tolomin deiw wanin so, alik alik be biim dim akal dukuko, alew elo dabalalewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Dabalaleko, awkunum kumel ilo kawkew weng mak bokoyemomele: “Yom unbiliw ding dim e, yu kanelom yukalem gal kelew kelw kelokoliw te.”, yangeko, yamdalei, i fein unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Unsomeliwi, awkunum kumel i Isiw aneng fian be koleweko, uneko, alew Sekow em be dim Kenan aneng fian kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Uneko, ka telesomi, alew Sekow elo bokolewomeliw: “Kom min Yosew akati kuaninba te! E kait bomi, Isiw aneng fian beem kamok kebe te.”, dangsiliw kale. Dangiwi, e im weng be kilise kate, fein anginba kesomi, ibolow net angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Angeko, im dangiw sang be kilele kilisomi, Yosew em akalem teing dim elo dabalalewse mesesem mesesem eisneng bakati atemomelei, e iti kakat ibolow kesomi, baba yol angesomi, ");
INSERT INTO bhl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","gaanomele: “Fein tako! Nem min Yosew e kait finik so be te! Kasike, nem kuaninba bi kalakate, fongate akate elo atebam unoki te!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Beli, alew Isalael so, akalem muluwel so, alik alik i ikalem mesesem mesesem eisneng be kulusomi, Isiw aneng fian elo unsiliw kale. Uneko, Belseba abiw kalo telesomeliwi, Sekow e ka kel samal mak asomelei, aik ayem dim dako, alew Aisak em Sunbin-Got em wiin fian daolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Daolewsomelei, mililiw mutuk e, Sunbin-Got e teleko, em kiin dem sin Isalael elo bokolewomele: “Kutaka! Sekow kutaka! Sekow! Kutaka!”, dangei, Sekow e yan weng bokolewomele: “Ne bi kale eli!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Dangei, Sunbin-Got e bokolewomele: “Nakalem ete Sunbin-Got nete te. Ne kalew em Sunbin-Got nete te. Ku kanelom Isiw aneng fian elo unomin beem dulum elote finganokolew te! Ne kuso bomelii, dokokemsomi, aneng ka kel kom muluwel dow biilo tulun kuw keyemoki te. ");
INSERT INTO bhl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nakalem ete kuso Isiw aneng fian elo unesomelii, kom muluwel dow ilo sow ete iti yemde toloki te. Kate, kom fasel keko, kuanokolew ding dim e, kukalem min Yosew e kukalem mit mewso boke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Keko beli, Sekow so, akalem muluwel iso, biim kalel mumel iso, alik alik i Isiw aneng fian emisik kamok fian em teinkemin eisneng beem dim teineko, Belseba abiw be koleweko, unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Beli, Sekow e akalem muluwel dow iso akalem bulmakao so, ikalem Kenan aneng fian kulusiliw mesesem mesesem eisneng alik alik beso, ikalem aneng fian be koleweko, Isiw aneng fian elo unsilw kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Alew Isalael em Isiw aneng elo unsiliw muluwel dow biim wiin e kanekote: Sekow em emisik dukuse aul beem wiin e Uluben ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Uluben em muluwel im wiin e Kanok so, Falu so, Kesolon so, Kalmi so, ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon em muluwel i Yemuel so, Yamin so, Okat so, Yakin so, Sokal so, Saul so, ite kale. Saul em auk u Kenan aneng fian em waneng ute kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Elibai em muluwel i Gelson so, Kokat so, Melali so, ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Suda em muluwel i kanekote: El so, Onan so, Sela so, Feles so, Selala so, ite kale. El so, Onan so, Suda em muluwel alew bi aso i yelimel biim Kenan aneng fian bisiliw ding kabalak kel e, kuansiliw kale. Feles em muluwel i Kesolon so, Kamul so, aso ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isasal em muluwel i kanekote: Tola so, Fuwa so, Yow so, Simolon so, ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon em muluwel i kanekote: Selet so, Elon so, Yalel so, ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Muliel bi Sekow em sun waneng Elea um Mesofotemia aneng fian ka kel bomi, dukusu em muluwel ite kale. Elea u iti aul mak dukuko, buum wiin e “Daina” wangsu kale. Kunum yenggdel biim dow e 33 kel kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gat em muluwel i kanekote: Sifion so, Kagi so, Sumi so, Esbon so, Keli so, Alodi so, Aleli so, ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asel em muluwel i kanekote: Imna so, Isfa so, Isfi so, Beli so, ite kale. Sela u yenggdel biim waneng aul ute kale. Beli em muluwel i kanekote: Kebel so, Malkiel so, aso ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Muliel bi Sekow em afam waneng Silfa um muluwel ite kale. Sua e, fik Alaban e weng afak waneng bu akalem neng Elea ulo duumse kale. Muluwel biim dow e mali em kalun kel kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Sekow em kalel Elesel u Benyamin so, Yosew so, aso ilo dukusu kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosew em Isiw aneng fian em kamok keko, bise ding kabalak e, e Isiw aneng fian em abiw mutuk fian Keliofolis em am yol beem kunum ayem Fotifela em mun Asenat ulo wamduse kale. Asenat u kunum aul alew mak dukusu kale. Mak em wiin e Manase e, mak em wiin e Efalaim ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin em muluwel i kanekote: Bela so, Bekel so, Asbel so, Gela so, Naman so, Eki so, Olos so, Mufim so, Kufim so, Alad so, ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Muliel bi Sekow em kalel Elesel um muluwel dow ite kale. Kunum yengdel biim dow e mutum kel kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan em dukuse min makmak em wiin e Kusim ete kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafatali em muluwel i kanekote: Yasel so, Guni so, Sesel so, Silem so, ite kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Muliel bi Sekow em afam waneng Bilka um dukusu aul ite kale. Kunum yengdel biim dow e ben kel kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Sekow em muluwel biim kalel kumel ilo teing bokolinba kesiliw kasike, Sekow yelimel biim Isiw aneng fian elo unsiliw biim fufu e 66 kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kate Isiw aneng kel, Yosew akal kunum aul alew mak dukuse kasike, Sekow em muluwel dow alik alik biim fufu e 70 emdiw kelei, i Isiw aneng fian kel teinsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Beli, Sekow e Suda elo emisik dabalalei, e Yosew em mit kalo unse kale. Unei, Yosew e Isiw aneng fian beem anung Gosen be akalem angin ilo duyemse kale. Duyemei, Suda e akalem angin ilo folsomelei, i Gosen aneng kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Uniwi, Yosew e akalem weng afak kunum ilo bokoyemomele: “Yu nem teinkemin eisneng beem dim teinsomi, yako unomin eisneng mak kuluko, memen kenemoliwka!”, yangeko, fongate akate Gosen aneng elo akalem alew Sekow em fukun unse kale. Unesomelei, alew elo atemeko, kalfong so falal kelewsomi, amese kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Amesomelei, alew Sekow e min elo bokolewomele: “Kame, ne kulo katemite: Ku finik so kait belew te! Kame, ne kuanomin memen kebi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Keko beli, Yosew e akalem awkunum kumel so, ikalem aul waneng iso, alik alik ilo bokoyemomele: “Nemisik uneko, Isiw aneng fian kaleem emisik kamok fian beelo weng mak bokolewomeli: ‘Aatim so, nem angin iso, alik alik i Kenan aneng fian koleweko, nem mit elo tele kembiliw te. ");
INSERT INTO bhl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nakalem angin bi siwsiw so, meme so, bulmakao so, samal yetebin kawtiw kebiliw kasike, i ikalem samal so, ikalem mesesem mesesem eisneng so, alik alik be de tele kembiliw te.’, dangoki te. ");
INSERT INTO bhl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Dangoki kasike, Isiw aneng fian kaleem emisik kamok fian be yulo dakalalomele: ‘Yom aluwbamin e nimtew a?’, yange tewe, ");
INSERT INTO bhl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","yu elo yan weng bokolewomeliw: ‘Kamok kutaka! Num aatim kumel im suaem kanemaliw emdiw, aul gel kebisuluw ding akati, kame akati, nu diwkuw diwkuw siwsiw so, meme so, bulmakao so, samal yetebin kawtiw kuw kekabuluw te.’, dangoliwka! Dangiw tewe, e bokoyemomele: ‘Yu Gosen aneng ka kel teinoliwka!’, yangoke te. Nimtew angom? Isiw kawtiw i samal yetebiliw kawtiw ilo gal keyemkabiliw kasike. Beem mongom ete e yulo akalem be dim be singam elo yamalei, yu ka kel teinokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Keko beli, Yosew e Isiw aneng fian em emisik kamok fian elo bokolewomele: “Nakalem aatim so, nakalem angin iso, alik alik i Kenan aneng fian elo koleweko, ikalem siwsiw so, meme so, bulmakao so, mesesem mesesem eisneng beso, alik alik bi yemdeko, Gosen aneng kaleelo tele kembiliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Dangesomelei, Yosew e akalem awkunum kumel biim teingabi kel kunum biilo gayemei, i teliwi, e ilo Isiw aneng fian beem emisik kamok fian beem kiin dim kel mo koyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ka kel koyemsomelei, Isiw aneng fian beem emisik kamok fian be ilo dakalalomele: “Yom aluwbamin e nimtew a?”, yangse kale. Yangei, isik yan weng bokolewomeliw: “Kamok kutaka! Num aatim kumel im suaem kanemaliw emdiw, aul gel kebisuluw ding akati, kame akati, nu diwkuw diwkuw siwsiw so, meme so, bulmakao so, samal yetebin kawtiw kuw kekabuluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Dangeko, iti weng makso bokolewomeliw: “Nu sukum ding kuw kale kel kokow kawtiw atew kakamokoluw te. Nimtew angom? Kenan aneng fian kel olfut fian inkalso mak kese kasike, nukalem siwsiw so, meme so, samal alik alik biim wanin akal sukum banimse kasike. Kasike, ku nulo bokoyemomelew: ‘Yu aneng Gosen ka kel bina!’, yangolewka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Dangiwi, e Yosew elo bokolewomele: “Kalew so, kawkunum kumel so, alik alik i kom mit elo teleko, biliw kasike, ");
INSERT INTO bhl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","i Isiw aneng fian beem aneng anung mak atemeko, ibolow kelewiw tewe, i ka kel bokoliw te! Kalew so, kawkunum kumel so, i aneng atin kuw atite mak atemiw tewe, i aneng be kuluko, ka kel boliwka! Feinka! I Gosen aneng ka kel boliwka! Kawkunum kumel im dim e samal yetebin kunum kenati kuw mak atemew tewe, ku kunum beelo galmosomelewi, nakalem siwsiw so, meme so, biim kak yetebin kunum kelolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Dangei, Yosew e alew Sekow elo gaalewei, e teleko, Isiw aneng fian beem emisik kamok fian beem mit moko, bamki so weng mak dulewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Dulewei, emisik kamok fian be Sekow elo dakalalomele: “Kom itol e nomin kebelew, a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Dangei, Sekow e yan weng mak bokolewomele: “Nem aatim kumel im itol tiakim emdiw kelewbinba kebi te. Ne kokow kunum kesomi, anggil ilum fian mak kulu atemsomelii, itol 130 kel kuw kawin dim kale kel kakabisi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Dangeko, Isiw aneng fian em emisik kamok fian beelo bamki so weng mak bokoleweko, koleweko, unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Keko beli, Yosew e Isiw aneng fian beem emisik kamok fian beem weng geleweko, akalem alew so, awkunum kumel iso, alik alik biilo Isiw aneng fian beem emisik atite aneng anung Alamses duyemeko, “Yukalem kawin te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Kaneko beli, Yosew e akalem alew so, awkunum kumel iso, ikalem aul waneng iso, alik alik biilo wanin yemgiyemale kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Beli, im Isiw aneng fian ka kel bisiliw ding dim bakate, Isiw aneng fian so, Kenan aneng fian so, aneng fian biim kasel alik alik i olfut fian kuw teineko, aya kuanin kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Keko beli, Yosew e akalem wit dem duku kemeliw am dim kalo uneko, suaem wit dem kubul dukusiliw wanin be kuluko, kunum waneng iso tum win so wemale kale. Wesomelei, Isiw aneng fian so, Kenan aneng fian so aneng alew biim kasel i ikalem tum win alik alik be de teleko, eso wit wanin wemaliw kale. Wesomeliwi, Yosew e biim tum win be kuluko, Isiw aneng fian em emisik kamok fian beem am ka kel duku kemale kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Duku kebomelei, fe e, Isiw aneng fian so, Kenan aneng fian so, aneng alew biim kasel biim tum win be atin kuw banimse kale. Kasike, Isiw kawtiw alik alik i uneko, Yosew elo weng mak bokolewomeliw: “Ku nulo wanin makso yemena! Kate, num tum win alik alik be banime te. Kukalem kiin so yetemewte: Wanin tew so teinsomi, aya aya kuanomin kis keluw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Dangiwi, Yosew e yan weng mak bokoyemomele: “Yukalem tum win be banime tewe, yukalem siwsiw so, meme so, bulmakao so, de teleko, dunemiw kano, beem yan e wanin so alwol kelokoluw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Yangei, iti itol makmak kelei, i ikalem kos so, siwsiw so, bulmakao so, donki so, ikalem samal alik alik be delew teliwi, Yosew eso wanin alwol kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kesomeliwi, itol bakate banimei, Isiw kawtiw i iti Yosew em fukun teleko, bokolewomeliw: “Sakik ilum weng kal mak bakakem tuluw te. Nukalem tum win so, samal so, alik alik angom be kulo dukakembuluwi, banimse te. Nukalem kal so, nukalem kawin so, bete kuw be te. ");
INSERT INTO bhl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kasike kame, ku nukalem kawin so, nukalem so, alik alik bi wesomi, beem yan e nulo wanin dukayembolewka! Mesik esik, alik alik nu wanin tew kesomi, kuanokoluw kasike. Kuanuw tewe, nukalem kawin so, Isiw aneng fian so, aneng alik alik be wa wa keloke kasike. Ku kanelew tewe, alik alik nu Isiw aneng fian kaleem emisik kamok fian beem sak weng afak kunum waneng kebokoluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Dangiwi, olfut fian kuw kese kasike, Isiw kawtiw alik alik i teleko, ikalem kawin angom be Yosew eso alwol kesiliw kale. Kesomeliwi, Isiw aneng fian em kawin alik alik angom be Isiw aneng fian em emisik kamok fian beem kawin kuw kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Beli, Yosew e Isiw aneng fian em kut kut bisiliw kunum waneng alik alik bi Isiw aneng fian beem emisik kamok beem sak weng afak kunum waneng keyemeko, ilo yamdeko, mali abiw mutuk fian elo kuw koyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Koyemse kate, yol am tem beem aluwbabiliw kunum biim kawin anung be Yosew e weninba kese kale. Nimtew angom? Isiw aneng fian beem emisik kamok fian be yol am tem aluwkabiliw kunum biilo tum win mali mak duyemkabe kasike, i wanin wenomin tum win kulabomeliwi, im kawin e Yosew eso alwol kelinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kaneko beli, Yosew e kawtiw biilo bokoyemomele: “Kame, yu kililina! Kawin alik alik angom be nete kuw weni kasike kame, ne wit dem sen mali mak yulo duyemoki te. Duyemii, yu de uneko, musun dim kel kailoliwka! ");
INSERT INTO bhl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kailiwi, musun wanin be tebeko, dem so kesomi, memen keloke ding kabalak e, yu musun dem beem anung teingabi kel kelewsomi, anung makmak be Isiw aneng fian beem emisik kamok fian beelo dukalewboliwka! Kate, ketket teben kel em anung be yu kailomin beem dulum so, yukalem aul waneng iso, yukalem angin iso, yukalem weng afak kunum waneng iso, alik alik biim wanomin beem dulum so, duku kemoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Yangei, kunum waneng alik alik i yan weng bokolewomeliw: “Kenka! Ku nulo ibolow folok kukuyemeko, fein dokoyemew kasike, nu Isiw aneng fian kaleem emisik kamok fian beem sak weng afak kunum waneng kebuluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Keko beli, Yosew e suaem dukuse, kame akal kait alakabe sawa beem mongom kayak kebe te. Musun wanin mak tebeko, dem so gilale tewe, musun kasel i musun dem be anung teingabi kel kelewsomi, ketket teben kel em anung be ikalem kelewsomi, anung makmak e Isiw aneng fian beem emisik kamok fian beelo dukalewkabiliw te. Kate, yol am tem kel aluwkabiliw kawtiw bite kuw Isiw aneng fian em emisik kamok fian beem sak weng afak kunum waneng kelinba ke alakabiliw te. ");
INSERT INTO bhl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Beli, Isalael kawtiw bi Isiw aneng fian em anung Gosen ka kel kawin anung kulusomi, muluwel dow dem dem kailsomi, fian kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Keko beli, Sekow e Isiw aneng fian ka kel belei, itol mali em guel kel banimei, em itol e 147 kese kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kesomelei, e kal kelete: “Ne fasel keko, nakalem kuanomin ding kame mewos kele kai!”, angeko, Yosew elo gaalewsomi, weng tem tem mak bokolewomele: “Kom teing de teleko, nem anggil dim melenemsomi, fawtuk ayem weng mak bokonema! Ku nelo ibolow mutuk fian kukuw kukunemsomi, nem fom e Isiw aneng fian kale kel nam fomkamin dim elo dukulew te! ");
INSERT INTO bhl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nem kuaneko, awalik kumel im finik am biliw dim elo unoki ding dim kabalak e, ku nem fom be Kenan aneng fian elo namdeko, awalik kusel im yemkusiliw dim kalo nakati namkulolewka!”, dangse kale. Dangei, Yosew e bokolewomele: “Kom weng be kiliko, fein gelewoki te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Dangei, Sekow e bokolewomele: “Fein fawtuk ayem weng mak bokonemsomi, ‘Kaneloki te’, nangolewka!”, dangse kale. Dangei, Yosew e fein fawtuk ayem weng kitil fian mak bokolewei, Sekow e kiliko, akalem akal kemin dim kel teineko, gatak wakas kak daking angesomelei, Sunbin-Got elo “Weso!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Beli, mali deiw mak ding mak kabalak e, Yosew e kililete: “Kalew e wakamin so kebe te!”, dangiwi, e kilise kale. Kilisomelei, e akalem muluwel alew Manase so Efalaim so ilo kuluko, yelimel bi makuw akalem alew elo atebam unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Unsomeliwi, mali kunum im Sekow elo bokolewomeliw: “Kukalem min Yosew e kulo katemomin telbe te.”, dangsiliw ding kabalak e, Sekow e kitil kesomi, akalem akalbe dim elote baba teinse kale. ");
INSERT INTO bhl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Teinsomelei, e Yosew elo bokolewomele: “Sua e, nem Kenan aneng fian em Ulus abiw mutuk ka kel alenali ding dim e, Kitil so Auk so Sunbin-Got e nem dim mewso teleko, bamki so weng mak dunemeko, ");
INSERT INTO bhl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","bokonemomele: ‘Kulo bamki so kekemsomi, kom muluwel dow ikal bamdako, nengso nengso keyemoki te. Keyemsomi, aneng fian ka kel kukalem so, kom muluwel dow iso, alik alik yulo diwkuw diwkuw duyemii, yu beelo aluwbokoliw te.’, nangse te. ");
INSERT INTO bhl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Kaneko beli, ku kilele kilila! Nakalem Isiw aneng fian kaleelo telinba kebisi ding dim kabalak e, ku kame yemde telselew muluwel alew biilo dukuselew te. Kate kame, ne muluwel alew biilo nakalem aul imdiw keyemsomi, nakalem dukusi muluwel Uluben so Simeon so aso biimdiw keyemsomelii, i nakalaem fan anung ikati kulokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kom imisik dukuselew muluwel aso biim ibik teleko, dukukemokolew muluwel bite kuw kukalem mongom kemokoliw te. I ikalem fik kumel Efalaim so Manase so, alew biim kawin be fan atew kulokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nem Mesofotemia aneng fian koleweko, Kenan aneng fian elo kakabisi ding dim kabalak e, kauk Elesel u Efalata abiw mutuk fian beem mewso ka kel kuanui, ne sakik ilum fian mak kuluko, ulo Efalata unsuluw deiw mutuk kel wamkusi te. Kame, ne kom dukuselew muluwel Efalaim so Manase so, aso biilo kauk Elesel um iti dukulin muluwel atew keyembi kasike.”, dangse kale. Efalata em wiin mak e Betelekem te. ");
INSERT INTO bhl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Alew Isalael em weng be banim kelewse ding bakate, e Yosew em yemde talse muluwel alew biim dulum elo yetemeko, dakalalomele: “Aul alew kali kante a?”, dangse kale. Nimtew angom? Alew Isalael e fasel kelomi, kiin sukul kese kasike. Keko beli, Yosew e alew elo yan weng bokolewomele: “Aul alew kali, Sunbin-Got em nakalem Isiw aneng fian kale kel bomi, nelo dunemse muluwel alew ite te.”, dangesomelei, alew Isalael e bokolewomele: “Nem mit mewso yemde tala! Yemde telew kano, ne ilo bamki so weng mak duyemoki te.”, dangse kale. Dangei, Yosew e fein, aso ilo awalik em mit yemde telei, awalik sel e biilo falal mumul da koyemeko, ");
INSERT INTO bhl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","min Yosew elo bokolewomele: “Sua e, ne ibolow fukunomete: ‘Ne kulo nam katemi sako!’, angeko, ibolow fukunsi kate kame, Sunbin-Got e ibolow folok kenemei, ne kukalem muluwel iso yelimel makuw yetemika!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Dangei, Yosew e awalik em mumul dim teinbiliw muluwel alew biilo kuluko, kaneng da kaneng da koyemsomi, akalem kiinguen gatak wakas kawin dim elo dasomi, alew elo “Weso! Seyo!” dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Keko beli, Yosew e ning Efalaim elo yuk teing dim elote aluwsomi, fik Manase elo awan teing dim elote aluwsomi, aso ilo yamdeko, awalik Isalael em mit mo koyemse kale. Mo koyemse kasike, e fik Manase be Isalael em yuk teing dulum elote mo kolewsomi, ning Efalaim be awalik em awan teing dulum elote mo kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kaneyemsomi, awalik Isalael e akalem yuk teing de uneko, ning Efalaim em awan dulum mose dim elo dukuko, kolewsomi, akalem awan teing be de uneko, fik Manase em yuk dulum mose dim elo dukuko, kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kolewsomelei, e min Yosew elo bamki so weng mak bokolewomele: “Nakalem aatim kumel Abalakam so Aisak so aso em afak bomi, em weng gelewsomi, nelo diwkuw diwkuw siwsiw yetebin kunum emdiw kenati kuw netemeko, dokonemkakabe Sunbin-Got e kom aul biilo bamki so keyemboke te! ");
INSERT INTO bhl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Feinka! Sunbin-Got em nem anggil ilum so kakabi ding dim kel kilele dakanembise dabalakamin finik be muluwel alew biilo bamki so keyemboke te! Keyemsomi, kawin dim kale, muluwel biim dow e fian kuw kesomi, bamda nengso nengso keyemoke kasike, kunum waneng angom alik alik i nakalem wiin so, nakalem aatim kumel Abalakam so, Aisak so, yelim biim wiin so, alik alik num wiin be nam banime te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Dangei, Yosew e alew Sekow em yuk teing e “Ning Efalaim em kak dim elo dukulewe kai!”, angeko, atemsomi, em kiin dim e “Wa kele kai!”, angeko, alew em yuk teing kuluko, bo keleweko, fik Manase em kak dim elo dukulomin ibolow keko, ");
INSERT INTO bhl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","alew elo bokolewomele: “Aatim kutaka! Bayo! Ku kaneminba te! Kom yuk teing e fik em kak dim kel dukula o!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Dangse kate, alew e yan weng bokolewomele: “Min kutaka! Nakalem kilele kal kebomi, kanebi te. Fik Manase akati kunum mongom fian mak kesomi, aul kaileko, muluwel dow banso banso keloke kate, ning bete kunum mongom atin fian kuw kesomelei, em muluwel dow banban bi kawin dim kaleem aneng aneng angom alik be gek yak yak kelokoliw te.”, dangse kasike, ");
INSERT INTO bhl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","e fein fik Manase elo ning Efalaim em afak kelewse kale. Kelewsomi, bamki so weng makso aso ilo bokoyemomele: “Isalael kawtiw i kaso yom bamki beelo ibolow fukunsomi, yom wiin dim kel bamki so weng mak bokolew bokolew kebomeliwi, ‘Sunbin-Got e yulo Efalaim so, Manase so, aso biimdiw bamki so keyemoke te!’, ange ange kebokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Yangesomi, Yosew elo bokolewomele: “Ku nem weng kale kilele kilila! Nakati kuanomin mewso keli kate, Sunbin-Got e alik alik yulo kilele yetebomi, iti yukalem kawalik kumel nukalem kolew talsuluw aneng fian kalo yemde unoke te. ");
INSERT INTO bhl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Yemde unoke kasike kame, ne kulo kawin ken ati mak dukemi te. Nem Amol kawtiw iso on genesomi, kulusi Sekem anung be kulo fein dukemi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Beli, Sekow e akalem muluwel ilo gaayemeko, bokoyemomele: “Yu nem mit mewso telina! Teliw kano, sow ibik em yom dim kel keloke eisneng mak bokoyemoki te. ");
INSERT INTO bhl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Nem muluwel yutaka! Yu nem mit mewso telesomi, wensaneko, yukalem kalew Isalael nem weng kale kililina! ");
INSERT INTO bhl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Uluben, nem seiw men kutaka! Nakalem kitil so tanbel kebisi ding dim bakate, ne kulo duku kokemsi te. Ku kunum kitil melmel so auk so kunum kelewsomi, kom nenggelel im kamok kelew te. ");
INSERT INTO bhl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Kate, kom kukuw e ok wal mit telebomi, kung kung kebe emdiw kasike, ku fik kumel im kulukabiliw abin be nam kulew te. Nimtew angom? Ku kalew nem afam waneng uso kal bongguko, akalsomi, nelo inkal dunemselew kasike. ");
INSERT INTO bhl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon so Elibai so, yelew yutaka! Kaso yom ibolow e yulo silikmoyemkabe kasike, kaso yu kaisuw so ganbin so kunum alew kebomi, mali kawtiw ilo yenkabiliw te. ");
INSERT INTO bhl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Feinka! Yu kaisuw kesomi, mali kunum waneng ilo sak yesiliw te. Mali em ding dim bakate, kaso yu ibolow kikinin nangnang kuw kesomi, bulmakao im kalgol okiyem kesiliw te. Kasike, kaso yuso neso nu nam tele tele kemuw te! Feinka! Yom ibolow fukunin e ne kilisomi, nam gelewbi te. ");
INSERT INTO bhl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Kaso yukalem kaisuw so, ibolow mamtel nam so, beem kukuw bakate ne kaso yulo weng yakok mak keyemi te. Kaso yu Isalael kawtiw biim mutuk dim e sak kawin banim kunum kebokoliw te! ");
INSERT INTO bhl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Suda kutaka! Kom kawkunum kumel i kukalem wiin daokemeko, kom mit kel katin bukbuk angeko, gatak wakas angokoliw te. Kom teing e maka im gatak el falem mokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ku samal asomi, waneko, kitil kesomi, kilele faku alakabe alaion tanbele atew te. Kesomi, kunum mali mak i kom mit mewso teleko, nam kamkalfoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Suda kutaka! Kute kamok wiin so auk so kunum kelewi, Isalael kawtiw im emisik kamok fian e diwkuw diwkuw kom muluwel dow biim mutuk kel moloke te. Feinka! Deiw mak ding mak kabalak e, emisik kamok fian sel mak yom dim kel telei, kawin dim kaleem kawtiw alik alik i akalem weng kiliko, fein gelewemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ku kunum wiin so kisol so kunum kelew kasike, kom donki men sak wain ais em mit aluwsomelewi, ais dem so ais kon so alik alik be wanoke kate, ku kanelom sakik kelokolew te. Nimtew angom? Kom wain ok e ban ban ok atew kele kasike, ku sak wain ok kulusomi, kukalem ilim be wain ok so gingokolew kasike. ");
INSERT INTO bhl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mesesem eisneng angom mak nam sukum kemew kasike, wain ok wanbelew beem dulum elote kom kiin e kafing olol nam kekemsomelei, non gom wanbelew beem dulum elote kom ning e kais nam kekemkabe te. ");
INSERT INTO bhl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon, ku okmun fian sel em beleng mit mewso teinbomi, Saidon abiw mutuk fian kom bokolew em aneng awet keloke te. Kom ka bokolew beem dulum be siw selel teleko, dit kemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakal, ku donki kitil nam atew kate, ku ibolow aimgeko, gal nam kesomi, kukalem mesesem eisneng beem mutuk dim be sak teineko, buyelemokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ku ibolow tei angeko, kukalem aneng kenati atebokolew kasike, kukalem em dulum elote sakik banim kesomi, bokolew te. Bomelewi, mali kawtiw im sak weng afak kunum kesomi, im ilum e kute kuw daoko, de kakamokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan, ku Isalael kawtiw biim mutuk ka bomi, kukalem kunum waneng ilo kilele diwyembokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ku sokyan kimon atul nam atew kebomelewi, deiw beleng dim ka kel kutebokolew te. Kutebelewi, maka mak kos dim teineko, teliw tewe, ku kos yan elo ning dut kelewbokolew kasike, kos em dim teinbiliw kunum bi kawin dim elo dakalu mit telemokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Yangeko, Yawe elo bokolewomele: “Yawe kutaka! Kukalem dokonem angom ding bete kuw fenbi te!”, dangeko, iti mali muluwel biilo bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gat kutaka! Maka i kom aneng elo kuiaw wanen tolokoliw kate, kukati famdes angeko, ilo yenggelew uneko, ilo kuyaw yenokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asel, kom kawin be tugul kawin kelei, emisik kamok fian im ibolow kelebokoliw em wanin ken ati kuw yom fok fok kemoke te. ");
INSERT INTO bhl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafatali, ku sok tem bin koleweko, ikalem ibolow fukunin ete kuw gelewsomi, fongate kuw yako unakabiliw kut em meme atew kesomi, mesesem eisneng kenati kuw fitew kaim dim dukulokolew te. ");
INSERT INTO bhl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosew, ku ok beleng mewso mosomi, ais dem banban gilakabe ais bamki so atew te. Ais beem teing al keko, akalem ayet dim bakilewko, neng so neng so unokobe te. ");
INSERT INTO bhl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Maka atul nam mak teleko, on balam so kitil kesomi, kulo kenomin ganen tolokoliw kate, ");
INSERT INTO bhl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","kalew Sekow em tum kitil nam emdiw Auk so Kitil so Isalael kawtiw ilo yetemalakabe Sunbin-Got be kulo fein dokokemsomi, kom teing dim kitil dukemoke kasike, kom aluwbokolew wonuk be nam beit nam kebe te. ");
INSERT INTO bhl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Feinka! Kitil dukemsomi, kilele dokokemoke Sunbin-Got be kawalik kaliwol kumel biim Kitil so Auk so Sunbin-Got ete te. Akalem ete kuw kulo katiw em so, kalak em so, alik alik beso makuw bamki so kekemsomi, kom muluwel dow ikal banso banso keyemoke te. ");
INSERT INTO bhl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Kalew nem kame kulo bakakembi bamki so weng kale sunsun alakabe amgu fian so, amgu muk muk unse unse angom beso, alik alik beelo bakilewkabe te. Yosew, ku kawkunum kumel biim kamok keko, belewi, bamki so mesesem eisneng be kom dim elo kuw keloke te! ");
INSERT INTO bhl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin ku kut mian emdiw kesomi, samal kil kuw kebomi, ankabelew te. Kutim ding dim bakate, ku kom maka ilo yeneko, kunil koyemsomelewi, kuinbele ding kabalak e, ku iti teleko, samal beelo boko, amen amen kuw kelewkabelew te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Sekow em Kalun kel muluwel bi Isalael kawtiw im kalun kel kunum mongom bite kale. Alew Sekow e akalem muluwel ilo ikalem amen amen kesomi, bamki so weng mak duyemse kale. ");
INSERT INTO bhl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Belei, Sekow e akalem muluwel ilo bokoyemomele: “Kame nem mewso kele ding kabalak e, nakalem awalik kumel im finik am biliw dim elo unoki te. Unii, yu nem kuanoki fom beelo kuluko, Kenan aneng fian elo nemde unoliwka! Nemde uneko, Mamele abiw em ataan tele dim em mewso dim Makfela ka kel em tum tem kel fom namkuloliwka! Tum tem beso, musun beem mewso be beso, nem awalik Abalakam e Kit kunum Efolon eso on kisol tum win so weneko, nukalem awalik kumel biim fom yemkukemin kawin kelewse te. ");
INSERT INTO bhl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ka kel e, Abalakam so, akalem kalel Sala so, Aisak so, akalem kalel Elebeka so, nem sun waneng Elea so, alik alik biim fomkamin dim ete te. ");
INSERT INTO bhl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Sua e, nem awalik Abalakam e tum tem be so, musun beso, on kisol tum win so Kit angin iso wese te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yangeko, Sekow em akalem muluwel biilo weng kitil weng be bokoyemse ding kabalak e, e akalem akalkemin dim yan danong akalsomelei, kuanesomelei, akalem finik e awalik kumel im finik am biliw dim elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Unei, Yosew e alew em fom falal keleweko, ilum sakik fian mak kulusomi, amese kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ameko, amemsomelei, e akalem kal kunum ilo gaayemeko, “Yu fom beelo kabilew kano, e tiow keko, nam kilone te.”, yangse kale. Yangeko, i em ilo bokoyemse weng be kiliko, gelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Gelewsomeliwi, i ikalem kukuw geleweko, 40 kel ding banimse ding kabalak e, im aluwbamin fian be alik alik banimse kale. Beli, Isiw kawtiw alik alik i fom amkim biliwi, 70 kel ding banimse kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Banimei, Yosew e Isiw aneng fian em emisik kamok fian so, akalem angi iso, alik ilo dakalako, bokoyemomele: “Yu ibolow folok so kenemiw tewe, emisik kamok fian beem mit mewso uneko, nem dulum elote weng mak bokolewomeliw: ");
INSERT INTO bhl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Yosew em alew em mewso kuanomin kese ding dim bakate, e weng temtem mak Yosew elo bokolewomele: ‘Nem kuanoki ding kabalak e, ku nem fom be kuluko, Kenan aneng fian elo namde unesomi, nakalem fomkamin kawin dim ka kel namkulolewka!’, dangse kasike kame, Yosew e fein Kenan aneng fian elo uneko, alew em fom be ka kel dawkukem unomin ibolow kesomi, fongate akate ibiksin kaleelo toloke te.’, dangoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Yangei, i fein uneko, Isiw aneng fian beem emisik kamok fian beelo weng be de uniwi, e kiliko, Yosew elo bokolewomele: “Kenka! Kalew em weng dukukeme be fein gelewa!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","8","Dangei, Yosew e kiliko, akalem so, Isiw aneng fian em kak kunum alik alik iso, kamok biim imteben kunum alik alik iso, Yosew em angin iso, akalem awkunum kumel iso, Sekow em angin alik ali iso, alik alik kunum waneng bi makuw Kenan aneng fian elo unsilw kate, aul gel gel so, siwsiw so, meme so, bulmakao so, alik alik bi Isiw aneng fian em anung Gosen ka kel koyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Biim unsiliw ding dim e, Yosew e kawtiw teinkemin eisneng beem dim teinsomi, fongate akate unbiliw kawtiw banban so, kos im dim teinbiliw kunum banban biso, kawtiw demdem biilo folei, alik alik i makuw unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Unsomeliwi, i Yoldan bang dikeko, Golen-Katat abiw elo uneko, ben kel ding mak ka kel Yosew em alew em ibolow fukuneko, sakik fian kulusomi, amemin fian mak kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kesomeliwi, Kenan aneng fian kasel i biilo yetemeko, “Golen-Katat abiw ka kel e, mali Isiw aneng fian em kunum waneng i sakik fian mak kulusomi, amebiliw kai!”, ange ange keko, yetemsiliw kale. Kanebiliw yetemsiliw kasike, i Yoldan bang beleng beem ataan matem tele dulum beem wiin e “Abel-Misalaima dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Keko beli, Sekow em muluwel i ikalem alew Sekow em ibolow tem tem yangse weng be fein geleweko, ");
INSERT INTO bhl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kenan aneng fian elo uneko, Mamele abiw beem ataan tele dulum dim mewso unsiliw kale. Uneko, tum tem em wiin e Makfela kalo unesomi, alew em fom be ka kel dawkusiliw kale. Sua kel e, Abalakam e Makfela aneng anung be Kit kunum mak em wiin Efolon beem teing dim on kisol tum win so weneko, “Nakalem angin im fom yemkukemin kawin kale kel te!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Keko beli, Yosew so, akalem awkunum kumel so, yangmel bi ikalem alew sel em fom ka kel dawku kolewsomeliwi, ikalem so, iso talsiliw Isiw kawtiw iso, alik alik i makuw ka koleweko, iti Isiw aneng fian elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Alew Sekow em kuanse ding kabalak bete, Yosew em awkunum kumel i sakik weng mak bokolomeliw: “Ebo! Aatim sel kuane kasike kame, ning Yosew e nulo maka keyemeko, nukalem wa kukuw kelewsuluw beem yan wa mak nulo fein duyemoke sako!”, ange ange kesomi, ibolow tiaktiak kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kesomeliwi, i Yosew elo weng mak dabalako, bokolewomeliw: “Kalew em kuaninba kesomi, finik so bise ding kabalak e, e kawkunum kumel nulo weng mak bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Yu Yosew elo bokolewomeliw: ‘Kawkunum kumel biim kulo kekemsiliw kukuw wa be ku sak misim kuw kulu koyema!’, dangoliwka!’, yangse te. Yangse kasike kame, ku kalew em Sunbin-Got em weng afak kunum nukalem kekemsuluw kukuw wa be fein sak misim kuw kulu koyemolewka!”, dangsiliw kale. Dangiwi, Yosew e im dabalasiliw weng be kiliko, amese kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Amesomelei, akalem awkunum kumel i em mit mewso katin bukbuk teinsomeliwi, elo bokolewomeliw: “Nukalem kom sak weng afak kunum nute te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Dangiwi, Yosew e ilo bokoyemomele: “Yu kanelom finganokoliw te! Nakalem ete diyemin Sunbin-Got kate ye? Bayo! ");
INSERT INTO bhl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Feinka! Yu nelo ibolow gal kenemeko, wa kukuw kenemsiliw kate, Sunbin-Got e yukalem wa kenemsiliw kukuw be famdes kelewsomi, kenati kuw kelewse te. Esik nukalem angin fian sel biim ibolow fukuneko, nelo Isiw aneng fian kaleem wiin so kak kunum kenemse kasike, ne ki keko, yulo wanin dukayembilii, alik alik yu wanin tew so keko, kuaninba kesiliw te. ");
INSERT INTO bhl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kasike, yu kanelom finganokoliw te! Nakalem ete yom aul waneng so, yuso, alik alik yulo fein dokoyemoki te. Yukalem ibolow be falit angeko, menew kuw keboliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","23","Beli, Yosew so, alew Sekow em angin so, alik alik i Isiw aneng ka kel teinbisiliw kale. Teinsomeliwi, Yosew e akalem min Efalaim em kailse dukulin muluwel biso, akalem min Manase em min Makil em muluwel biso, alik alik biilo yetemeko, ilo akalem muluwel imdiw ken kukuw kuw kukuyemse kale. Kukuyemsomelei, Yosew em itol e 110 kel kese ding dim kabalak e, ");
INSERT INTO bhl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","e “Nakalem kuanomin ding kame mewso kele kai!”, angeko, akalem awkunum kumel ilo gaayemeko, kawkew weng mak bokoyemomele: “Ne mewso kuanomin kis kebi kate, yu kanelom finganemokoliw te! Sunbin-Got e yulo kilele dokoyemoke kasike, yu Isiw aneng fian kale iti fein kolewokoliw te. Akalem ete awalik Abalakam so, Aisak so, aatim Sekow so, nukalem awalik kumel biilo fawtuk ayem weng mak bokoyemomele: “Aneng fian ka yulo fein duyemoki te!”, yangse kasike, e yulo iti aneng fian kalo fein yamde unoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yangeko, awkunum kumel ilo weng kitil nam weng mak bokoyemomele: “Yu fawtuk ayem weng mak nelo dunemoliwka! Sunbin-Got em yulo aneng kalo iti yemde unoke ding dim kabalak e, yu nem fom kun bakati fokoluko, namde unoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yangei, Yosew em itol e 110 kel ayet kese ding kabalak e, e fein kuanse kale. Kuanei, Isiw aneng em kal kunum i teleko, em fom be kabilewsomi, tiow kelewsomi, elo ais kok tak kalat kabalak dukusomeliwi, Isiw aneng ka kel dukusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","4","Sua sua kel, diwyemin kunum ite Isalael kawtiw ilo yetem alenaliw kale. Beem ding kae, kunum mak alenale kale. Kunum beem wiin e Elimelek ete kale. Em kunum mongom e Suda kesomi, em alenale aneng e Efelata kelei, akalem abiw mutuk fian e Betelekem ete kale. Mak ding mak, Suda aneng fian be, olfut fian mak kese kale. Kelomi, kunum waneng alik alik i wanin tew so teinsiliw kasike, Elimelek yelimel i Suda aneng fian be koleweko, Moaw aneng fian elo uneko, ka kel teinsiliw kale. Teinsiliw kate, Moaw aneng fian be nanew mongom im aneng kale. Beli, Elimelek so, akalem kalel Noomi uso, yemkal biim min alew Kilyon so Malon so aso iso, yelimel alik alik bi Moaw aneng fian ka bisiliw kate, deiw mak ding kabalak e, alew e kuanse kale. Kuanei, auk so min alew so yatel im imikel kuw alenaliw ding dim e, min alew aso ikati tanbeleko, Moaw aneng fian beem waneng seiw alew mak yamdusiliw kale. Waneng alew biim wiin e kanekote: Mak um wiin e Ilut kelui, mak um wiin e Olfa ute kale. Keko beli, yelimel i Moaw aneng kel biliwi, tiak ding mak kesomi, king kel itol emdiw kelei, ");
INSERT INTO bhl_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","min alew bikati kuansiliw kale. Kuaniwi, auk Noomi so, kuansiliw min alew biim kalun kumel so, yatel bi anggil ilum fian so, sakik fian so kuluko, imikel kuw alenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","7","Bomeliwi, deiw mak ding mak kabalak e, imok auk Noomi u kililute: “Suda aneng fian ka kel e, Yawe e iti wanin yom am duyembelei, i ken ding kulubiliw kai!”, wangiwi, u kilisu kale. Kilisu kasike, yatel i “Suda aneng fian kalo unuma o!”, angomi, fein unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Unbiliw ding bakate, Noomi u kalun alew biilo bokoyemomelu: “Kame kuso yukalem angin im biliw dim kalo unina! Yawe e yom neso, yukalem kuansiliw kimok kumel iso, alik nulo kukuyemkabiliw kukuw ken ati be kilele atemeko, kal kebe kasike, em ibolow folok e diwkuw diwkuw yuso boke te! ");
INSERT INTO bhl_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Bomelei, e kuso yulo iti kunum mak duyemei, yu iti ken abin mak kuluko, bokoliw te!”, yangsu kale. Yangsomi, min kalel alew biilo falal koyemsomelui, yatel i fian kuw amesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Amemsomeliwi, kuansiliw min biim kalel kumel alew i makuw kesomi, ulo yan weng bokoumomeliw: “Natel nukalem makuw unuma! Alik nu kukalem abiw kalo unuma!”, wangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","13","Wangiwi, imok auk Noomi u bokoyemomelu: “Kuso yu Moaw aneng fian kaleem waneng alew kasike, kuso yukal yukalem abiw kale kel kauk kaliwol so biliw kano, deiw mak ding mak kabalak e, iti kunum mak kulusomi, aul duku kemina! Kate nakalem e, fasel kesomi, aul dukulominba kebi te. Yu kilele ibolow fukunina! Ne kame kuw, iti kunum mak kulusomelii, e nelo aul mak duneme tewe, aul dukuloki be kuso yom kalun kayak kelei, yu elo kulokoliw e? Kuso yu aul beem tanbeloke ding fenbokoliw e? Kasike, kolina! Yawe e nelo ilum mak kukunembe kasike, kame kuso yu iti yukalem aneng kalo unina!”, yangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Yangui, yatel i iti fian kuw amesomeliwi, Olfa u fein imok auk um weng kiliko, “Yat yukalo!” yangeko, ilo koyemeko, ukalem am dim elo unsu kale. Unui, Ilut umi e imok auk ulo falal keumeko, deit keumsu kasike, ");
INSERT INTO bhl_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","imok auk Noomi u ulo bokoumomelu: “Kawkolon ukal konem unu kasike kame, kukati kukalem am dim elo una! Unesomelewi, iti kukalem angin biim yol ayem afak elo una!”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","17","Wangui, Ilut u ulo yan weng mak bokoumomelu: “Itel bayo! Ku kanelom kitil keko, nelo ‘Konem una!’, nangokolew te! Kom aneng unokolew be nakati nat makuw unokoluw te. Kom aneng bokolew aneng be, nakati nat makuw bokoluw te. Kom angin ikati nem angin kelokoliw te. Kom Sunbin-Got akati nakalem Sunbin-Got keloke te. Kom kuanokolew aneng ka kel e, nakati kuanoki te. Kom kawin tem unokolew be, nakati ka kel kawin tem unoki te. Nat nu kanelom kolew kolew kemokoluw te! Kuan kemin ete kuw nat nulo okiyemoke te!”, angeko, deitsu kale. Deitsomelui, Yawe em wiin dim kel weng fawtuk ayem weng mak bokoumomelu: “Nem weng sakalaw keko, weng bo bo keli tewe, Yawe e ilum fian mak nelo dunemolewka!”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","19","Wangeko, kitil kuw kesomelui, fe e, imok auk u um bokoumsu weng be fein kiliko, “Kenka!”, wangui, yat i Betelekem abiw mutuk fian kalo unsiliw kale. Betelekem abiw mutuk fian teliw eli, kunum waneng i yol angeko, bokolew bokolew kelomeliw: “Waneng kalu Noomi ute ye?”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","21","Kemiwi, Noomi u ilo bokoyemomelu: “Yu kanelom nelo Noomi nangokoliw te! Nem wiin e Mala nangoliwka! Nimtew angom? Auk so Sunbin-Got Yawe e nelo waneng wiin banim so sakik fian so waneng kenemse kasike. Nem aneng kale kolewko, unsi ding dim kabalak e, ne emso waneng kesomi, mesesem eisneng so de unsi kate kame, nem iti teli ding dim kale, ne baluw kesomi, mesesem banim keko, teli te.”, yangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Keko beli, Noomi so, ukalem kuanse min em Moaw waneng Ilut kuluse waneng uso, yat bi Moaw aneng fian kolewko, Betelekem abiw mutuk fian kalo talsiliw em sang bakate. ");
INSERT INTO bhl_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","4","Beli, Bali okilew kekabiliw em ding kesomi, deiw mak ding mak danse ding kabalak e, Moaw waneng Ilut bu imok auk ulo bokoumomelu: “Ne bali wanin deibiliw musun kalo uneko, musun beem kayak be nelo netemeko, ‘Kenka! Ku kanela!’, nange tewe, musun ka kel e bali wanin mak kuloki te.”, wangsu kale. Wangui, imok auk bu bokoumomelu: “Kenka. Ku kanela!”, wangui, Ilut u fein unsu kale. Unui, kunum mali mak bali wanin okilew kebiliwi, waneng mali mak bali beem sen be kubul duku yak yak kebiliwi, yetemsu kale. Yetemeko, kalo unesomi, kubul duku yak yak kebiliw waneng biim dim uneko, kolew kebiliw tabol so sintem so be umikel bongguko, kubul duku kebisu kale. Kubul duku kebu dim bakate, musun beem kayak ete talse kale. Kunum beem wiin e Boas ete kale. E on kisol so kamok kese kate, kokow waneng Ilut bu elo dolon kelinba kesu kale. Dolon kelinba kesu kate, Boas e Noomi um kuanse imok Elimelek em kaim atuk kese kale. Kame, kunum be teleko, akalem musun aluwbabiliw kunum waneng biilo bokoyemomele: “Yu biliw yako! Yawe e yu so kebe te!” yangse kale. Yangei, i elo yan weng bokolewomeliw: “Ao! Yawe e bamki so kekemoka!” dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Dangiwi, e akalem aluwdewbamin beem yetebe kunum beelo dakalalomele: “Kutaka! Waneng seiw kalu kanem mun ute ye?”, dangeko, elo dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Dakalalei, kunum be yan weng bokolewomele: “Waneng kalu Noomi so teleko, bu te. U Moaw waneng kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","U nelo dakalalomelu: ‘Ne ki keko, kom aulkembiliw kunum waneng biim ibik ete wanin tabol kolew kebiliw be kubulko, kuloki ye?’, nangui, ne ‘Kenka!’, wangi te. Wangii, ukalem ete kutim kel akate aluwbabului, fong gel ding makuw finengdasomi, iti aluwbabu bakate!”, dangesomi, Boas elo bokolewse kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","9","Bokolewei, Boas e Ilut um mit mewso uneko, bokoumomele: “Weya kutaka! Nem weng kale kilila! Kom wanin deimokolew ding dim bakate, ku kanelom mali kawtiw im musun elo unemokolew te! Nakalem musun ete kuw aluwbamolewka! Ne nakalem aulnembabiliw kunum ilo bokoyemomeli: ‘Yu kanelom um mit mewso uneko, ulo wa kukuw mak keumbokoliw te!’, yangi kasike, ku kanelom finganemokolew te! Nem musun kale kel wanin kulabomelewi, nem aulnembamin waneng iso bomi, wanin deimolewka! Deibelewi, ku ok tew teinew tewe, ku uneko, biim ok sen duku kebiliw be, sak dulu wanbolewka!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Wangei, u em bokoume weng be kiliko, em mit mewso gatak wakas katin bukbuk teinsomi, elo bokolewomelu: “Ne kokow waneng akate, ku nimtew angom ete nelo kinkin ibolow so kenemeko, nelo ken kukuw kenembelew a?” dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Dangui, Boas e yan weng bokoumomele: “Ne kom kimok auk ulo kukuumselew ken kukuw beem sang alik be kilisi kasike. Ku waneng kukuw ken so kute te. Kimok kuanse em ding dim e, ku kimok auk ulo kilele keumsomi, kukalem aneng so, kauk kaliwol so, alik alik biilo koyem teleko, dolon kelinba kawtiw num dim mewso talselew te. ");
INSERT INTO bhl_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Feinka! Ku Isalael im Sunbin-Got Yawe beem nemel talselew kasike, e awon im ikalem men ilo bel kasi koyemkabiliw emdiw kulo akalem afak kel kasi kokemsomi, kateboke te. Feinka! E kom ken kukuw bakati atin kuw kal kebomi, kulo bamki so kekemsomi, kom kaneselew beem mongom ete yan ken mak dukemoke te.”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Wangei, Ilut u Boas elo bokolewomelu: “Kom bokonemew weng atite be ibolow menew keneme te. Ne kom aulkembabiliw waneng bikatetew bate! Ne sak singam telemin waneng nete kate, ku nelo ibolow folok kukunemew te.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Dangeko, iti bali wanin deim unsu kale. Ibik ete, wanin wanbin beem ding kabalak e, Boas e Ilut ulo gaaumeko, weng mak bokoumomele: “Ku kale kel teleko, belet wanin mak kulusomi, wain ok sen tem dako, wanolewka!”, wangse kale. Wangei, u teleko, Boas em aulewbamin kunum waneng iso makuw teinsu kale. Teinui, Boas e ais dem fu dukubiliw gis ming be kuluko, Ilut ukati duumei, u wansu kale. Waneko, ki kelomi, anung e men abu dukusu kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Dukusomelui, um iti aluwbam unsu ding dim e, Boas e akalem aluwbabiliw kunum biilo weng kitil weng mak bokoyemomele: “Yu Ilut ulo kanelom ‘Ayem!’, wangbokoliw te! Kate u yom bali dem beem kak kubulko, eingge duku kebiliw dim beem mit mewso ka kel akati kulamomuka! Yu ulo kanelom inkal dukaumbokoliw te! ");
INSERT INTO bhl_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Kate, yom bali kak bonggu duku kebiliw dim bakate, yu mali kak mak sak ka kolew kebiliwi, Ilut umikel teleko, kulamu tewe, yu ulo kanelom ‘Ayem te!’, wangbokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Yangei, Ilut u bali okilew kebiliw kak be kubul duku kebomi, aluwbabului, kuinei, fe e, ataan tem unse kale. Ataan tem unse ding dim be, Ilut u bali dem be tum dim teibisomelui, bali dem banso mak, ilim dim abubiko, musun be koleweko, Betelekem abiw mutuk fian elo unesomi, imok auk um am de unsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","19","De unesomelui, u suaem gal kelewko, men abu duku kembu wanin anung beso, ilim dim duku kolew kembu bali sen so, alik alik be ukalem imok auk buulo duumsu kale. Duumui, u min kalel ulo dakalalomelu: “Wee! Kutaka! Ku bali wanin banso kale, nal kel deim unembelew a? Ku kanem musun ete aluwbam unembelew a? Sunbin-Got e ibolow folok kukembe kunum beelo bamki fian so kelewboka!”, wangsu kale. Wangui, Ilut u yan weng bokoumomelu: “Kunum beem wiin e Boas ete te. Akalem musun ete aulbabiko, telika.”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Wangui, Noomi u bokoumomelu: “Kuansiliw kawtiw so, finik so biliw kawtiw so, alik alik ilo kukuw ken kuw kukuyembe Sunbin-Got e dokokemse kunum beelo bamki so kelewboka! Ku kilila! Kunum be nukalem kalun kayak kesomi, nukalem angin kebe kasike.”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Wangui, Ilut u iti weng mak so mak bokoumomelu: “Boas e bokonemomele: ‘Wanin dem kele ding dim e, ku diwkuw diwkuw teleko, akalem aulnembamin waneng iso makuw aluwbamolewka!’, nange kembe te.”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Wangui, u bokoumomelu: “Ken weng kangse te. Ku mali kawtiw im musun aulbam unew tewe, musun beem aulewbamin kunum i kulo wa kukuw kekemokoliw sako! Kasike, ku Boas em aulbamin aluwkabiliw wanggel iso kuw aulbamolewka!”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Kaneko beli, bali dem so wit dem so, wanin dem okilewko, kubul duku kebiliw dim kabalak e, Ilut u Boas em aulewbamin aluwkabiliw waneng iso makuw aluwbabisu kale. Beem ding be banimei, Ilut u imok auk so kuw alenalu kale. ");
INSERT INTO bhl_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Deiw mak ding mak e, Noomi u Ilut ulo bokoumomelu: “Abok kutaka! Ne kulo ken abin mak fenkemoki te. Atemi tewe, ku aneng ka kel ken kuw bomi, nam kakil kemew te.”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Wangesomi, weng mak so bokoumomelu: “Kame nem weng kale kilele kilila! Usinel e, ku Boas em aluwbamin aulewkabiliw kunum waneng iso makuw akalem musun kel aluwbamselew te. Kameem kuinbele kabalak e, nukalem kalun kayak Boas be bali dem beem kal wolu kolew kemin dim unoke te. ");
INSERT INTO bhl_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Unoke kasike, kukalem ete ok kuosomi, ilim kikis minggiko, kamge eisneng mak bolok kelolewka! Kesomelewi, ku okmoko, awkol kuw kesomi, em be dim kalo unolew ka! Mesik esik Boas e kulo katemoke kasike. Keko beli, kunum beem aluwbamin banim keloke ding dim e, e wanin so ok so wanesomi, ");
INSERT INTO bhl_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","akaloke te. Akaloke ding dim be, ku akalem akal kemin dim beem mewso uneko, akalem asolow ilim be fat kelewsomi, em yan dukube dim kun afak ka kel kukati akalolewka! Kanelew kano, akalem kulo bokokemoke weng beelo fein gelewolewka!”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","6","Wangesomelui, Ilut u fein imok auk um weng kiliko, geleweko, Boas em wanin dem em kal wolu kolew kemin dim kalo unsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Keko beli, Boas em wanin so wain ok so wanbiko, em ibolow e ki kesomi, kalfong so kese ding dim bakate, e uneko, fein akalse kale. Akalbelei, Ilut u atemomete: ‘Boas e atin kuw kiin ok ilum so akal kembe kai!’, angui, atemsu kasike, u awkol kuw uneko, em asolow ilim be fat kelewsomi, em kun afak kel ukal akalsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Kaneko beli, mililiw ding dim bakate, Boas e yol angeko, baba teinsomelei, “Yakai! Waneng sel mak nem yan afak akalbu kai!”, angeko, ");
INSERT INTO bhl_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","ulo bokoumomele: “Kutaka! Ku kante ya?”, wangei, u yan weng bokolewomelu: “Ilut neli! Ne wiin banim so waneng kebi kate, ku nakalem kalun kayak kebelew kasike kame, kom yesum so tabil konemeko, dokonema!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Dangui, e bokoumomele: “Weya! Yawe e kulo bamki fian so kekemoke te! Nimtew angom? Kimok auk ulo ibolow mutuk fian duumkabelew kukuw kale suaem kaneumkabelew kukuw beelo bakilewkabe kasike. Ku mali tanbel kunum mak, wiin so kunum ikal, wiin banim so kunum ikal, biilo yetemeko, ilo yenggelinba keselew te. ");
INSERT INTO bhl_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Feinka! Abiw mutuk fian kaleem kasel alik alik i kom ken kukuw be kilele kal kebiliw te. Kasike kame, ku kanelom finganemokolew te! Nelo ‘Kanela!’, nangew eisneng be ne fein kekemoki te. ");
INSERT INTO bhl_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Kame ku kilele kilila! Feinka! Ne kom kalun kayak kebi kate, nanew kunum mak emisik kesomi, kom kalun kayak kebe kasike. ");
INSERT INTO bhl_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Kate, sow kutim danoke ding kabalak e, ne kom emisik kalun kayak beelo atebam uneko, eso weng mak bokoloki te. E kulo fein kamdomin ibolow kele tewe, bakati kenka. Kate, e ibolow kekeminba kele tewe, ne kulo fein kamdoki te. Yawe em wiin ayem so be weng fawtuk ayem weng be kulo bakakembi kasike, ku kanelom finganemokolew te! Kate kameem mililiw kale, ku kale kel akalolewka!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Wangei, u em bokoume weng be kiliko, geleweko, em yan afak kel akalsu kale. Akalbului, aneng felet angomin dim mewso kele ding kabalak e, Boas e ulo wamkalfolei, u iti baba teinsu kale. Nimtew angom? Boas e fukunomele: “Mesik esik mali kawtiw mak ka kel talbu waneng buulo watemeko, kal kelokoliw kai!”, angse kasike. ");
INSERT INTO bhl_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Angesomi, Ilut ulo bokoumomele: “Kame, kom asolow ilim fian be gulu aluw de telsomi, silel kelewa!”, wangse kale. Wangei, Ilut u em bokoume weng be gelewsomelui, Boas e bali wanin dem gung kel sen fian so beem dim kel abu dukusomelei, ilim be Ilut um king kun dim kel dukusomi, wamdase kale. Wamdako, akati abiw mutuk fian kalo unse kale. ");
INSERT INTO bhl_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Unei, Ilut um ukalem imok auk um mit mewso uneko, talsu ding kabalak e, Noomi u ulo dakalalomelu: “Abok kutaka! Kom kanekemse sang be bokonema!”, wangsu kale. Wangui, Ilut u Boas em kaneumse sang alik alik be bokoumsomi, ");
INSERT INTO bhl_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","em fefe bokoumse weng bakati bokoumomelu: “E bokonemomele: ‘Ku kanelom sak kuw iti kimok auk um fukun unokolew te!’, nangeko, bali wanin dem gung kel sen sel be dunemse te.”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Wangeko, imok auk ulo bokoumomelu: “Weso seyo! Kame nu fong ding gel makuw fenokoluw te. Nimtew angom? Kame kuw, kunum be mesesem mesesem be kiol kuw kelewko, kileloke kasike.”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Wangsu ding dim be, Boas e Betelekem abiw mutuk fian kalo unse kale. Ka uneko, telesomelei, e abiw mutuk fian beem wati kitil nam em abisom fian dim ka kel teinse kale. Em teinse ding dim be, Ilut um emisik kalun kayak telesomelei, Boas e elo gaalewsomi, bokolewomele: “Nakunum kutaka! Ku kalak teina o!”, dangse kale. Dangei, e teleko, fein em mit mewso teinse kale. ");
INSERT INTO bhl_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Teinei, Boas e abiw beem kamok kunum king kel mak ikati gaayemsomelei, i wensaniwi, alik alik biim kiin dim kel kalun kayak beelo bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","“Kutaka! Ku kame nem bokokemoki weng kale kilele kilila! Nukalem kaim atuk Elimelek em kalun Noomi u Moaw aneng fian iti kolew teleko, ukalem kawin be mali iso wenomin ibolow kebu te. ");
INSERT INTO bhl_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Kasike kame ku alik alik num kiin dim e kilele yan weng mak bokonema! Ku buum mesesem mesesem alik alik be wenomin ibolow kebelew, meni ba? Ku komisik kesomi, mesesem mesesem beelo wenomin kunum kebelew kate, nesik kom ibik elote wenomin kunum kebi kasike. Ku nukalem am dim kunum waneng kaliso, king kel kamok kaliso, alik alik num kiin dim e fitew kaim dim kuw wenomin weng mak bokoyema!”, dangse kale. Dangei, emisik kalun kayak be yan weng bokolewomele: “Kenka! Ne um kawin be wenoki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Dangeko, Boas e iti weng mak so mak bokolewomele: “Ku Noomi so, Moaw aneng fian elote talsu waneng Ilut so, yat biim kawin be wenew tewe, ku kalun Ilut bukati wamdusomi, um kuanse imok beem dulum elo aul mak dukulokolew kasike, beem wiin e nam banime te! Kasike, yemkal yom aul mak dukulokoliw ding kabalak e, aul be kom kuanse kaim atuk Elimelek beem kawin kuluko, akalem dukulin min atew keloke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Dangei, emisik kalun kayak be yan weng bokolewomele: “Yake! Ibo! Ne ulo wamduko, iti aul kaili tewe, nem kuanoki ding kabalak e, nakalem muluwel i nem fan em kulomin e sukum kelokoliw te. Feinka! Ne kawin be nam weni te. Boas, kukalem ete wena!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","8","Dangse ki akate, akalem yan aom guluko, Boas elo dulewse kale. (Yan aom gulamin be Isalael kawtiw im suaem kukuw ete te. Kanemaliw beem mongom ete kawtiw i kitakamin mak beem weng e ki kelewsiliw kale. Nimin kawtiw ite mak mesesem eisneng mak weneko, beem yan so, ikalem yan aom so, mali ilo duyemiw tewe, biim wesiliw beem dulum elote weng ki kesomi, weng makso mak nam bakamiw te.) ");
INSERT INTO bhl_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","10","Beli, Boas e kunum alik alik ka biliw kunum biilo bokoyemomele: “Yutaka! Kunum waneng kaliim kiin dim so, kamok kaliim kiin dim so, alik alik yom kiin dim e nukalem wenomin weng be kame ki kelewsomi, bokoluw bakate. Yelimel Elimelek so, akalem muluwel alew Kilion so, Malon so, kuansiliw kunum biim mesesem eisneng alik alik be ne kame weneko, Noomi ulo beem yan fein duumoki te. Malon em kalun Moaw waneng Ilut bukati wamdoki kasike, nakalem kaim atuk Elimelek em wiin bakati nam banime te. Kasike, em angin nuso, abiw mutuk fian kaleem kunum waneng yuso, alik alik nu ki keko, kuanse kunum beem wiin nam akokow kemuw te. Kame yu fein kiliko, kiin so atemeko, kal keloliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Yangeko, king kel kamok biso, kunum waneng ka biliw biso, alik alik i makuw bokolewomeliw: “No, feinka! Kame, nu kanelew eisneng be kilele kiin so atemuw te! Yawe e kom am toloku waneng Ilut buulo bamki fian so keumbe te! E Ilut kalu Isalael kawtiw num waneng mongom Elesel so Elea so alew bikatetew keume te! Feinka! Efalata aneng kale so, Betelekem abiw mutuk fian kale so, Yawe e kom wiin e fian kuw kekemoke te! ");
INSERT INTO bhl_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Kekemsomi, kom kalel buulo bamki so keumoke kasike, Ilut u aul banban dukukemui, kom muluwel dow i Suda so, em kuanse min kalel Tamal uso, alew biim aul dukusiliw Feles beem muluwel dow emdiw kelokoliw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kaneko beli, Boas e fein Ilut ulo wamduse kale. Wamdubelei, deiw mak ding mak kabalak e, Yawe e Ilut ulo bamki so keumei, u fein aul kumun kesomelui, fe e, kunum aul mak dukusu kale. ");
INSERT INTO bhl_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Aul dukulu ding be, waneng min mak teleko, awkok Noomi ulo bokoumomeliw: “Yawe em wiin fian daoluma! Nimtew angom? E kalun kayak mak dukemse kasike. Fein! Boas em wiin e Isalael kawtiw num dim kel fian keloke tako! ");
INSERT INTO bhl_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Kame kuw, kom min kalel Ilut u kunum aul mak dukukembu kasike! Kom fasel kelew ding dim e, aul be kulo kilele kekemboke te.”, wangsiliw kale. Wangeko, iti weng mak so mak bokoumomeliw: “Kukalem ete muluwel ben kel mak dukuselew tewe, alik alik bi bongguko, kulo kilele kekemeko, ibolow mutuk fian dukemeko, kom ibolow elo kom min kalel Ilut buumdiw nam kekemiw te.”, wangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Wangiwi, Noomi aul be kuluko, um aul atew keleweko, em atebin waneng kesu kale. ");
INSERT INTO bhl_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Keko beli, i bokoumomeliw: “Noomi kunum aul mak dukulu kai!”, angeko, aul beem wiin e “Obet”, dangsiliw kale. Beli, Ilut so Boas so yemkal bi Obet dukusiliw kale. Dukuliwi, Obet e Yesi em alew kese kale. Yesi e Isalael kawtiw im emisik kamok fian Debit beem alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Kale kel kunum mongom Beles beem dukudak dukudak teleko, Debit em dim talse muluwel dow im sang te: Beles e Keselon em alew te. ");
INSERT INTO bhl_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Keselon e Alam em alew te. Alam e Aminadaw em alew te. ");
INSERT INTO bhl_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadaw e Nakson em alew te. Nakson e Salmon em alew te. ");
INSERT INTO bhl_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon e Boas em alew te. Boas e Obet em alew te. ");
INSERT INTO bhl_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obet e Yesi em alew te. Yesi e Debit em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_1","028_1_1","DAN","1","1","1","Sekoyakim em Suda kawtiw im emisik kamok keko, Selusalem abiw mutuk fian ka belei, beem itol alemsal kele ding dim kabalak e, Babilon abiw mutuk fian em emisik kamok fian Nebukatnesal e akalem abiw mutuk fian koleweko, ganbin kunum iso teleko, Selusalem abiw mutuk fian kalo ganen talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_2","028_1_2","DAN","1","2","2","Ganen telesomeliwi, teliwi, Sunbin-Got e Nebukatnesal so akalem ganbin kunum iso kitil duyemeko, i Sekoyakim aliwi, e im afak kese kale. Kesomelei, i Sunbin-Got em am yol em ok sen ayem so, awamin ayem so be alik alik kuluko, ikalem dasuw-got biim mit elo debeleko, Babilon aneng fian beem am yol kalo de unsilw kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_3","028_1_3","DAN","1","3","3","Beli, Nebukatnesal e akalem emisik weng afak kunum Asfenas elo bokolewomele: “Kame ku uneko, Sekoyakim so, mali Isalael kawtiw im wiin so kunum so, biim kunum tanbel so kuw kulu yemde tololewka! ");
INSERT INTO bhl_vpl VALUES ("DN1_4","028_1_4","DAN","1","4","4","Yemde tolokolew Kunum bi tanbel kiinguen ken ati so, anggil ken so bite kuw diwko, kulu yemde tololewka! Biim fukunin kal ken so keko, fongate akate ibolow tem kilinin so kunum kesomi, emisik kamok fian nakalem kiin dim e i ki kelokoliw kawtiw kelokoliw te! Kesomeliwi, ku ilo yemde telewi, i emisik kamok nakalem am kel aluwbamokoliw te! Keko beli, Asfenas kukalem ete ku Babilon aneng fian kunum waneng num weng sin beso, num fut bosiliw weng tem beso alik alik be ilo kilele kukuyembolewka! ");
INSERT INTO bhl_vpl VALUES ("DN1_5","028_1_5","DAN","1","5","5","Im wanin wanbokoliw akati emisik kamok nakalem wanin wanakabi beemdiw ete kuw ikal wanboliwka! Wanbom, biliwi, itol alemsal keko, banim ding ete, i nemisik kamok fian nakalem weng afak kunum kebokoliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_6","028_1_6","DAN","1","6","6","Dangei, Asfenas e kunum tanbelel mak fein kulu yemde unse kale. Kunum biim tak e, ketket teben kel Suda kunum mak kesiliw kale. Kunum min biim wiin e Daniel e, Kanania e, Misael e, Asalia e, ite kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_7","028_1_7","DAN","1","7","7","Kebomeliwi, Asfenas e ilo wiin kikis nanew mak duyemeko, Daniel elo “Beltesasal”, dangesomelei, Kanania elo e “Satalak”, dangesomelei, Misael elo e “Mesak”, dangesomelei, fefe Asalia elo e “Abetnego”, dangeko, im wiin alwol keyemko, duyemse kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_8","028_1_8","DAN","1","8","8","Kate, Daniel e emisik kamok em wanin wanakabiliw wanin be wanomin ibolow kelinba kese kale. Nimtew angom? E ibolow fukunomele: “Mesik esik ne nakalem ibik biliw kawtiw biim wanin so, ok so, be wani tewe, ne Sunbin-Got em kiin dim e ninik nam keloki kai!”, angeko, Asfenas elo “Nono deiw ete keko, dokonemoke yake!”, dangomi, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_9","028_1_9","DAN","1","9","9","Dakalalei, Sunbin-Got e Asfenas em ibolow mutuk tem ibolow fukunin ken dulewei, e Daniel elo kinkin ibolow mutuk fian keleweko, em dakalamin beem dulum elote “Dokemoki te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_10","028_1_10","DAN","1","10","10","Dangesomi, elo yan weng mak bokolewomele: “Ne emisik kamok em awan akal finganbi te. Nimtew angom? E wanin kaleem dulum elote ‘Alik yu wanbina!’ yangse kasike. Kame, ne wanin ken wanin be kameninba keli tewe, ku kal anggil kolewsomi, kuka nam keko, mali kunum tanbelel biim kal anggil atew kelinba kelew tewe, emisik kamok fian be nelo nenei, ne kuanoki sako!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_11","028_1_11","DAN","1","11","11","Dangesomi, Daniel e Asfenas em weng bokolewse weng be fein kilisomelei, akalem so, akalem akunum kumel Kanania so, Misael so, Asalia so, alik alik i ikalem yetemkabe kunum beem mit mewso uniwi, e beelo dakalako, bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("DN1_12","028_1_12","DAN","1","12","12","“Kame nu king kel ding mak kiskis atemokoluw te! Nu samal angse be tokoyemeko, bokow so, amul so, ok so bete kuw wanbuluw kano, ");
INSERT INTO bhl_vpl VALUES ("DN1_13","028_1_13","DAN","1","13","13","king kel ding banimoke ding dim be, ku mali kunum tanbelel emisik kamok em wanin ken be wanakabiliw kunum biim kal anggil beso, nukalem sak wanin wanakabuluw kunum nukalem kal anggil beso, alik alik num kal anggil be kilele diw atayemolewka! Ateyemsomelewi, nomin eisneng mak nulo ‘Keyemboki te!’, yangew tewe, kukalem ibolow kuw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_14","028_1_14","DAN","1","14","14","Dangei, ikalem yetebin kunum be Daniel em weng bokolewse weng beelo “Ki ka!”, angeko, em weng bokolewe weng be fein gelewse kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_15","028_1_15","DAN","1","15","15","Keko beli, king kel ding be banimei, ikalem yetebin kunum be akunum kumel biim kal anggil be diw yetemsomi, atemete: Teingabi akunum kusel biim kal anggil be atin kuw ken ati so kesomi, mali kunum emisik kamok em wanin wanakabiliw kunum biim kal anggil bakiyemei, yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_16","028_1_16","DAN","1","16","16","Yetemse kasike, ikalem yetebin kunum be Daniel so awkunum kumel iso alik alik ilo emisik kamok fian beem wanin so, wain ok ken so be duyeminba kesomi, sak nanew wanin bete kuw ilo dukayemale kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_17","028_1_17","DAN","1","17","17","Beli, Sunbin-Got e Daniel so, akalem akunum kumel biso, alik alik biilo kal fukunin ken ati so duyemei, i kal fukunin fian so kunum kesomi, mali kawtiw im bosiliw fut alik alik beem mongom e atin kal kesiliw kale. Keliwi, Sunbin-Got e Daniel elo kiin dem so, takak atew mak falak ange so, eisneng beem mongom dak so silel bakayemin kunum kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_18","028_1_18","DAN","1","18","18","Keko beli, emisik kamok fian beem weng Asfenas elo bokolewomele: “Itol alemsal ding mak alei, ku kunum alik alik biilo kilele kukuyema!”, dangse ding be banimei, Asfenas e Suda aneng em tanbelel kunum sua kel diw yetemeko, kuluse kunum biilo Nebukatnesal em fukun elo yemde unse kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_19","028_1_19","DAN","1","19","20","Yemde unei, e iso weng bokoyemsomi, ilo diw yetemeko, atemete: Daniel so, akalem akunum kumel yemamas kel biso, alik alik biim kal fukunin e fian kuw kesomi, nanew tanbelel kunum biim kal fukunin bakiyemeko, Babilon aneng fian ka em oktakak kunum so, selew kunum so, alik alik biim kal akati ite keko, king kel ding atin kuw bakiyemiwi, yetemse kale. Yetemse kasike, e Daniel so, akalem akunum biso alik alik biilo kuluko, akalem am dim kel koyemse kale. ");
INSERT INTO bhl_vpl VALUES ("DN1_21","028_1_21","DAN","1","21","21","Kaneko beli, Daniel e Nebukatnesal em weng afak kunum kebomelei, e em afak kel tiak ding mak aluwse kale. Aluwbabelei, uneko, deiw mak Sailus e aneng beem emisik kamok fian kelei, beem emisik itol ding dim bakate, Daniel em aluwbamin be awet kese kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_1","028_2_1","DAN","2","1","1","Deiw mak ding mak Nebukatnesal e kuaninba belei, em auk teben kel itol emisik kamok fian kelewse ding dim e, e kiin dem mak senomelei, beem dulum elote kal ilum fian mak kuluko, kilele kawin dak akalinba kese kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_2","028_2_2","DAN","2","2","2","Kesomelei, e weng dabalalei, akalem oktakak kunum so, selew kunum iso, kunum ayem iso, fial atemeko, kaneloke eisneng atebiliw kunum iso, alik alik kal so kunum i beem weng be kiliko, gelewko, em fukun talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_3","028_2_3","DAN","2","3","3","Teliwi, e ilo bokoyemomele: “Ne kiin dem mak senomelii, ibolow tiaktiak kenembelei, bi kasike kame, yu nakalem kiin dem sen kembi beem mongom e silel bokonemina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_4","028_2_4","DAN","2","4","4","Yangei, i elo Alam aneng fian beem weng sin dim kel yan weng mak bokolewomeliw: “Nukalem emisik kamokim fian kutaka! Ku sunsun kuw finik so belew te! Ku kom kiin dem sen kembelew be nulo bokoyemew kano, nu kiliko, beem mongom bakati kilele bokokemokoluw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_5","028_2_5","DAN","2","5","5","Dangiwi, e ilo bokoyemomele: “Yu kilele kililina! Yu nakalem kiin dem sen kembi beso, beem mongom so, alew eisneng be kilele silel bokoneminba keliw tewe, ne wonuk so kunum ilo bokoyemii, i teleko, yom kun a teing a alik alik tikis takas keyemiwi, yu fein kuanokoliw te! Kuaniwi, yukalem am akal makuw dakal koyemeko, tabol tabol keyemokoliw te! ");
INSERT INTO bhl_vpl VALUES ("DN2_6","028_2_6","DAN","2","6","6","Kate yu nem kiin dem sen kembi beso, beem mongom so, alew eisneng be kilele silel bokonemiw tewe, ne mesesem on kisol angom banban yulo duyemii, yu wiin so kunum kelokoliw te. Kasike kame, yu bokonemina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_7","028_2_7","DAN","2","7","7","Yangei, i emisik kamok fian elo iti bokolewomeliw: “Kom kiin dem sen kembelew be nulo bokoyemew kano, nu kulo beem mongom e kilele silel bokokemokoluw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_8","028_2_8","DAN","2","8","9","Dangiwi, e yan weng bokoyemomele: “Ne kal kelite: Alik alik yu ibolow fukunin ki makmak keko, nelo dasuw fimdi famde weng bokonemomin kebiliw te. Yom ibolow fukuniw be kanekote: ‘Nem ibolow fukunin be iti alwol keloki te!’, angeko, ding fenbiliw kate, ba! Ne nam ibolow alwol keli te! Yu nakalem kiin dem sen kembi be kilele bokoneminba keliw tewe, ne beem mongom ete kilele kal kelite: Yu kiin dem sen kembi beem mongom bakati kilele dolon keko, kal kelinba kebiliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_10","028_2_10","DAN","2","10","10","Yangei, i yan weng mak bokolewomeliw: “Kamok fian kutaka! Kawin dim kasel nu kom ‘Yu kanelina!’, yangew eisneng be ki keko, nam mongom so bokokemuw te. Sua em ding akal, kame em ding akal, mak kamok fian kitil so auk so kamok fian mak mali kunum mak ilo kom nulo dakalalew beemdiw keko, ‘Yu kanelina!’, yanginba kesiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("DN2_11","028_2_11","DAN","2","11","11","Kamok a! Kom nulo ‘Yu kanelina!’, yangew eisneng be, nu ki keko, nam keluw te. Got ite kuw ki keko, dolon kesomi, bokokemokoliw kate, i kawin dim kale kel alakabuluw awet so kebuluw kawtiw nuso kakaminba kekabiliw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_12","028_2_12","DAN","2","12","12","Dangiwi, emisik kamok fian be im weng bokolewsiliw weng be kiliko, atin kuw kaisuw fian mak keyemsomi, wonuk so kunum ilo gaayemeko, ilo mali Babilon abiw mutuk fian beem kal kunum alik alik ilo yenomin weng mak bokoyemse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_13","028_2_13","DAN","2","13","13","Bokoyemei, i em kitil yangse weng be fein kiliko, gelewsomi, mali ilo yenomin unsiliw kale. Unesomeliwi, mali wonuk so kunum i Daniel so, akalem akunum kusel iso, alik alik biim dulum elote “Ilo fenem uneko, ikati yenuma!”, angomi, unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_14","028_2_14","DAN","2","14","14","Beli, kal kunum ilo yenomin unsiliw wonuk so kunum biim kak kunum mak beem wiin e Aliok ete kale. Daniel e ilo yenomin talse kunum beelo atemeko, weng atite ibolow fukunin ken so weng mak bokolewsomi, ");
INSERT INTO bhl_vpl VALUES ("DN2_15","028_2_15","DAN","2","15","15","elo dakalalomele: “Nimtew angom ete emisik kamok fian be kal kunum nulo alik alik yenomin kebe a?”, dangeko, dakalase kale. Dakalalei, Aliok e beem kanesiliw mongom beelo bokolewse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_16","028_2_16","DAN","2","16","16","Bokolewei, Daniel e uneko, emisik kamok fian beem mit mewso uneko, bokolewomele: “Ku mali ding mak fensomi, ne kulo kiin dem sen kembelew beso, beem mongom so, kilele silel bokokemoki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_17","028_2_17","DAN","2","17","17","Dangei, emisik kamok fian em weng bokolewse weng be kiliko, gelewse kasike, Daniel e iti akalem am uneko, awkunum kusel alemsal Kanania so, Misael so, Asalia so, kunum biilo emisik kamok fian beem “Kaneyemoki te!”, angse weng be deeko, ");
INSERT INTO bhl_vpl VALUES ("DN2_18","028_2_18","DAN","2","18","18","bokoyemomele: “Yutaka! Nu abiil tikin katiw kel alakabe Sunbin-Got beelo dakalaluw kano, e nulo ibolow folok keyemeko, emisik kamok fian beem kiin dem sen kembe beso, beem mongom so kaim dim fitew daloke kasike, nu so, aneng fian kale biliw kal kunum iso, alik alik nu nam kuanuw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_19","028_2_19","DAN","2","19","19","Keko beli, beem kutiliw ding bakate, Sunbin-Got e Daniel elo emisik kamok fian beem kiin dem sense beso, beem mongom so, kukulewei, Daniel e beelo kal keleweko, Sunbin-Got em wiin fian daolewko, ");
INSERT INTO bhl_vpl VALUES ("DN2_20","028_2_20","DAN","2","20","20","bokolewomele: “Sunbin-Got kutaka! Ne diwkuw diwkuw kom wiin fian daokembi te! Kute kuw kitil so kal ken so em mongom kayak kute te! ");
INSERT INTO bhl_vpl VALUES ("DN2_21","028_2_21","DAN","2","21","21","Kute kuw ataan suuk so, mililiw taw so, beem ding duyemkabelew te. Kukalem ete kuw mali kunum mak kamok fian emdiw keyemeko, iti kulu koyemkabelew te. Kute kuw mali kunum waneng mak amkoko, im ibolow fukunin kenso keyemkabelew te. Keko beli, kute kuw mali ibolow dolon so kawtiw biim ibolow dolon fian e duyemkabelew te. ");
INSERT INTO bhl_vpl VALUES ("DN2_22","028_2_22","DAN","2","22","22","Kute kuw kawtiw num okmobin eisneng mesesem alik alik be kilele kal kebelew te. Ailbin e kom dim alakabe kasike, mililiw em bin eisneng bakati ku atin kuw kal kebelew te. ");
INSERT INTO bhl_vpl VALUES ("DN2_23","028_2_23","DAN","2","23","23","Nem awalik abiok kumel im Sunbin-Got kutaka! Kame ne kom wiin fian daoko, kulo weso weng fian mak kangi te. Nimtew angom? Kute kuw kitil so kal so dunemeko, nelo num dakalaluw beem yan be dunemew kasike! Feinka! Ku emisik kamok fian beem kiin dem sense beso, beem mongom so, alew eisneng be nulo kaim fitew dim kukuyemew te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_24","028_2_24","DAN","2","24","24","Beli, emisik kamok fian e Abiok elo kitil weng bokolewomele: “Ku Babilon abiw mutuk fian beem kal kunum alik alik ilo yenomin una!”, dangse kasike kame, Daniel e kunum beelo bokolewomele: “Ku kanelom Babilon abiw mutuk fian beem kal kunum alik alik ilo yenokolew te! Kate ku nemisik emisk kamok fian beem dim nemde unew kano, ne akalem kiin dem sense so, beem mongom so, elo kilele bokolewoki te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_25","028_2_25","DAN","2","25","25","Dangei, Aliok e Daniel elo fein emisik kamok fian em mit mewso debele unesomi, elo bokolewomele: “Ne Suda kunum kale debele teli te. E ki keko, kom kiin dem senselew so, beem mongom so, kilele bokokemoke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_26","028_2_26","DAN","2","26","26","Dangei, emisik kamok fian be Daniel (em wiin nanew e Beltesasal) elo dakalalomele: “Fein a? Ku ki keko, nem kiin dem sensi so, beem mongom so, alew eisneng be kilele silel bokonemokolew a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_27","028_2_27","DAN","2","27","27","Dangei, e yan weng bokolewomele: “Kamokim fian kutaka! Kawin dim kaleem kal fian so kunum so, oktakak kunum so, selew kunum so, kunum ayem so, alik alik nu ki keko, okmobe eisneng be nam kaim dim daluw te. ");
INSERT INTO bhl_vpl VALUES ("DN2_28","028_2_28","DAN","2","28","28","Kate, abiil katiw alakabe Sunbin-Got bete kal fian so, kitil auk so Sunbin-Got keembe kasike, mesesem okmobe eisneng angom be e fein kaim dim da koyemkabe te. E kiin dem senselew beem dulum elote sow em kaneloke eisneng be kalekemse bakate. Kamokim fian Nebukatnesal kutaka! Kame, kom akalselew ding beem kiin dem senselew sang be kilele kilila! ");
INSERT INTO bhl_vpl VALUES ("DN2_29","028_2_29","DAN","2","29","29","Akalselew ding dim bakate, nukalem emisik kamok fian ku ibolow tiaktiak kesomi, ‘Nimtew eisneng mak kaneloke a?’, angeko, ibolow fukunkabelew te. Fukunewi, okmobe eisneng angom elo fitew dim dakabe Sunbin-Got e kulo kaneloke eisneng be kukukemse te. ");
INSERT INTO bhl_vpl VALUES ("DN2_30","028_2_30","DAN","2","30","30","Nem fukunin kal ken be mali kunum im kal bakiyeminba kekabe kate, sow em kaneloke mesesem eisneng be kal kebe Sunbin-Got be ‘Kamok kukalem ‘Nimtew eisneng mak kaneloke?’, angeko, fukunin be atemomelei, kulo fein kal kekemo yo!’, angomi, nelo kaleneme kasike. ");
INSERT INTO bhl_vpl VALUES ("DN2_31","028_2_31","DAN","2","31","31","Kamok kutaka! Kom akaleko, kiin dem senselew be kanekote: Takak so deng deng angse kunum kiskiw fian falieng sel mak aileko, kitil nam sel mak ail belei, ku elo emikel kuw mobelei, atemeko, atin kuw finganin fian mak kuluselew te. ");
INSERT INTO bhl_vpl VALUES ("DN2_32","028_2_32","DAN","2","32","32","Kiskiw beem kak e gol so kesomi, beem gin-gin ololo so, teing alew so, be on kisol silba so kesomi, dem mutuk e ain kitil nam atew balas so kesiliw te. ");
INSERT INTO bhl_vpl VALUES ("DN2_33","028_2_33","DAN","2","33","33","Kesomi, beem kun alew be ain kitil nam so kesomi, kun atuk kabalak e, ain kawin tawal so bongguko, kaisiliw te. ");
INSERT INTO bhl_vpl VALUES ("DN2_34","028_2_34","DAN","2","34","34","Beli, kamok kutaka! Kom kiskiw takak beelo atemeko, belew ding dim bakate, amgu kang kalote tum mak kawtoleko, bulbulun mit teleko, kiskiw beem yan ain kawin tawal so bongguko, kaisiliw yan beelo, kawtol tabol tabol kelewei, ku atemselew te. Kate, tum bulbulun mit tele tum fian be kunum mak kang kelinba kese te. ");
INSERT INTO bhl_vpl VALUES ("DN2_35","028_2_35","DAN","2","35","35","Kanelewse beem atemselew ding dim kabalak e, gol so, silba so, ain atew balas so, ain so, kaisiliw alik alik be makuw akati kawtol tabol tabol kese te. Kelei, ku atemewete: Mew kele eisneng be atin kuw fong gelgel kuw kelei, inim e kukun kukun be aneng aneng kalo kalo fufu de unse te. Unse kate, takak so kiskiw beelo baku kelewse tum be, iti uneko, emikel kuw fasuko, amgu sesel kesomi, kawin kaleem aneng aneng angom be alik alik kasi kolewei, atemselew te. ");
INSERT INTO bhl_vpl VALUES ("DN2_36","028_2_36","DAN","2","36","36","Be kom kiin dem senselew beem sang te. Kame, ne kiin dem beem mongom akati silel bokokemoki te. ");
INSERT INTO bhl_vpl VALUES ("DN2_37","028_2_37","DAN","2","37","37","Nakalem emisik kamok fian kutaka! Ku atin kuw komisik kamokim fian kelewi, mali kamok i kom afak kebiliw te. Nimtew angom? Abiil katiw alakabe Sunbin-Got be kulo emisik kamok auk so kamokim fian emdiw mo kokemeko, wiin fian mak dukemsomi, kunum falim kitil fian so atew kekemkabe te. ");
INSERT INTO bhl_vpl VALUES ("DN2_38","028_2_38","DAN","2","38","38","E kulo aneng aneng angom biim kunum waneng so, samal so, awon so, alik alik biim emisik kak yetebe kunum kekembe kasike, gol so kesiliw kak be kom kiskiw bakate te. ");
INSERT INTO bhl_vpl VALUES ("DN2_39","028_2_39","DAN","2","39","39","Keko beli, kom ibik ete, iti kunum mak kak kunum keloke kate, kak kunum beem kitil e kom afak keboke te. Keko beli, ibik ete, iti kunum mak kamok kelei, beem kitil e balas ain atew keko, kawin kaleem fein aneng aneng angom kale atemoke te. ");
INSERT INTO bhl_vpl VALUES ("DN2_40","028_2_40","DAN","2","40","40","Keko beli, ibik ete, ketket teben em kamok mak moloke te. Kunum beem kitil e ain kitil nam emdiw keko, suaem emisik kamok fian ke alenaliw biilo feiw banim keyemeko, tabol tabol gelgel keyemoke te. ");
INSERT INTO bhl_vpl VALUES ("DN2_41","028_2_41","DAN","2","41","42","Keyemoke kate, fefe kamok beem yeteboke kunum waneng alik alik i amen kuw amen kuw kelokoliw te. Nimtew angom? Ku atemewete: Takak kiskiw beem kun e, ain kitil nam so, kawin tawal beit nam so, bongguko, kailiwi, atemselew kasike. Beemdiw, fefe emisik kamok fian beem aneng mali e kitil keko, mali e beit nam kele angomi, isik amen amen kelokoliw te. ");
INSERT INTO bhl_vpl VALUES ("DN2_43","028_2_43","DAN","2","43","43","Amen amen kelokoliw kasike, mali kunum waneng im muluwel i mali im seiwel ilo ‘Kuluma o!’, angokoliw kate, ain so kawin tawal so bongguko, kilele nam fewtokoliw beemdiw, kamok fian beem yetemoke dim be kitil so beit so bongguko, kilele nam fewtokoko, bongguliw te. ");
INSERT INTO bhl_vpl VALUES ("DN2_44","028_2_44","DAN","2","44","44","Beli, fefe kamokim biim ding dim kabalak e, abiil tikin katiw alakabe Sunbin-Got be iti kamok fian mak em sunsun nam banime aneng fian mak moloke te. Mali kawtiw i teleko, ki keko, aneng fian beem kamok fian beelo nam de mit daliw kate, esik kitil so auk so kesomi, aneng aneng angom alik alik im kamokim biilo akalem afak kuw keyemeko, ilo atin kuw banim keyemoke te. Keyemoke kate, akalem yeteboke aneng be diwkuw sunsun kuw boke te! ");
INSERT INTO bhl_vpl VALUES ("DN2_45","028_2_45","DAN","2","45","45","Kaneloke sang be, kom kiin dem sin em tum fian atemselew beem mongom ete te. Amgu tikin kel goto kelinba kesiliw tum falieng be emikel fokolu teleko, kiskiw ain so, balas ain atew so, silba so, gol so, kiskiw beelo atin kuw kawtol koyemei, ku atemselew bakate. Kamok fian kutaka! Auk so wiin fian so Sunbin-Got be sow em ibik em keloke eisneng bete kulo kalekemse bakate. Feinka! Nem mongom so silel weng bokokembi weng be fein weng keko, fein dem gilaloke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_46","028_2_46","DAN","2","46","46","Beli, emisik kamok fian Nebukatnesal e Daniel em kiin dem mongom so silel bokolewse weng be kilisomi, em mit mewso teleko, katin buk buk angeko, em wiin daolewse kale. Daolewsomelei, e mali kawtiw ilo kitil weng mak bokoyemomele: “Yu uneko, samal ansomi, samal beso, kamge eisneng mak so, aik ayem kale kel dukuko, nukalem got imdiw Daniel elo dulina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_47","028_2_47","DAN","2","47","47","Yangesomelei, e Daniel elo bokolewomele: “Feinka! Kom Sunbin-Got ete fein Sunbin-Got katiw fian keko, mali got ilo afak da koyem ke alakabe Sunbin-Got ete te. E emisik kesomi, mali kamokim so, kunum waneng yetebin kamokim so, alik alik ilo akalem afak da koyem ke alakabe te. Feinka! E ki keko, mesesem okmobe eisneng angom akati kaim dim kuw dakabe kasike, ku nem kiin dem sensi beem mongom bakati kaim fitew dim kuw dalew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_48","028_2_48","DAN","2","48","48","Dangeko, elo Babilon aneng fian beem kunum waneng angom alik alik biim kak yetebe kunum keleweko, on kisol eisneng banban kubulko, elo dulewsomelei, e kal kunum alik alik im kak kunum wiin so kunum kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("DN2_49","028_2_49","DAN","2","49","49","Keleweko, Daniel e emisik kamok fian elo dakalalomele: “Ku nakalem nakunum kumel Mesak o, Abetnego o, Satalak o, alemsal kunum biilo Babilon aneng fian beem aneng aneng angom beem mesesem yetebin kunum keyemolewka!”, dangeko, dakalase kale. Dakalalei, e “Kenka!”, dangeko, em elo dakalase weng be fein gelewse kale. Kate, Daniel e emisik kamok fian beem am fian ka kel alenale kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_1","028_3_1","DAN","3","1","1","Beli, deiw mak ding mak, emisik kamok fian Nebukatnesal e mali kawtiw ilo weng kitil weng mak bokoyemomele: “Yu gol on kisol kuluko, takak so kiskiw fian mak kailina!”, yangse kale. Yangei, i kiliko, em weng bokoyemse weng be geleweko, kiskiw mak em tiakim e yemamas fu king kel (30) mita keko, beem fian e yemamas kel mita kelei, kaisiliw kale. Keko beli, i kiskiw be Babilon abiw mutuk fian beem mit mewso, Dula aneng beem bit mutuk dim kel mo kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_2","028_3_2","DAN","3","2","3","Mo kolewsomeliwi, emisik kamok be aneng aneng angom biim kak yetebiliw kunum iso, kunum biim weng afak kebiliw kunum iso, mali geeyemin kunum iso, kisol aluwko, atebiliw kunum iso, ibolow fukunin duyemkabiliw kunum iso, nanew kamok kebiliw kunum iso, alik alik wiin so kunum biilo gaayemei, i fein teleko, Nebukatnesal em mo kolewse takak so kiskiw beem afak kuw moko, kalfongdewsomeliwi, i bil kelomin kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_4","028_3_4","DAN","3","4","4","Beli, emisik kamok beem bontem dim bakamin kunum mak moko, gaaneko, bokoyemomele: “Aneng aneng angom kawtiw so, weng amen amen angom kawtiw so, kawtiw alik alik yu emisik kamok fian beem kitil weng kale kilele kililina! ");
INSERT INTO bhl_vpl VALUES ("DN3_5","028_3_5","DAN","3","5","5","Emisik kamok fian Nebukatnesal e takak so kiskiw kale mose kasike, nalem ding ete yu fongket em weng fongfong gaane weng be kiliko, fotiaw em weng filifolo gaaniw weng be kililiw tewe, yu fongate akate gol kiskiw beem mit ka kel katin bukbuk angeko, beem wiin e daolew kemoliwka! ");
INSERT INTO bhl_vpl VALUES ("DN3_6","028_3_6","DAN","3","6","6","Nimin ete beem wiin daolewinba keliw tewe, nu kaneliw kawtiw biilo yaluwsomi, galuko, kula ais mamin nam tem kalo da koyem kemokoluw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_7","028_3_7","DAN","3","7","7","Yangei, fongket so fongfong kesomi, folmit akal filifolo kesiliw ding dim kabalak e, aneng aneng angom kawtiw so, weng amen amen angom kawtiw so, kawtiw alik alik bi fongate akate katin bukbuk angeko, Nebukatnesal em gol so kaiko, mo kolewse takak so kiskiw beem wiin daolew kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_8","028_3_8","DAN","3","8","8","Kesiliw kate, beem ding dim be, mali Babilon abiw mutuk fian beem kal kunum mak i emisik kamok kebe beem mit mewso teleko, alemsal Suda kawtiw biim dulum kel elo weng desi weng so kelewsomi, talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_9","028_3_9","DAN","3","9","9","I bokolewomeliw: “Kamokim kutaka! Kukalem ete diwkuw diwkuw ken abin kuw tein bokolew te! ");
INSERT INTO bhl_vpl VALUES ("DN3_10","028_3_10","DAN","3","10","10","Ku weng fawtuk ayem weng mak dukuko, bokolomelew: ‘Nimin kawtiw ite mak fongket em weng fongfong gaane weng be kilisomi, fotiaw em weng filifolo gaaniw weng be kililokoliw kate, i fongate akate kiskiw dukuselew beem mit kel katin bukbuk angeko, beem wiin e daolewinba keliw tewe, ");
INSERT INTO bhl_vpl VALUES ("DN3_11","028_3_11","DAN","3","11","11","wonuk so kunum i kaneliw kawtiw biilo yaluwsomi, galuko, kula ais mamin nam tem kalo da koyemokoliw te.’, yangeko, kitil weng dukuselew te. ");
INSERT INTO bhl_vpl VALUES ("DN3_12","028_3_12","DAN","3","12","12","Dukuselew kate kame, mali Babilon aneng fian beem kak yetebin kunum mo koyemselew Suda kunum mak kom weng kitil nam weng beelo sakalaw keko, weng bo bo keleweko, kom got so, kom gol so kaiselew takak beso, alew biim dim mewso uneko, katin bukbuk angeko, im wiin beelo daolinba kekabiliw te. Kunum alemsal biim wiin e Satalak o, Mesak o, Abetnego o, yemamas kel kunum bite te.”, dangeko, weng desi weng kuw fu kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_13","028_3_13","DAN","3","13","13","Kelewsomeliwi, emisik kamok be im weng bokolewsiliw weng be kiliko, atin kuw kaisuw fian mak kesomi, “Alemsal kunum bi kaleelo yamde telina!”, angse kale. Angsomelei, e yamdalei, i alemsal kunum biilo kulam uneko, kamok em fukun kulu yemde talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_14","028_3_14","DAN","3","14","14","Yemde teliwi, e ilo bokoyemomele: “Alemsal kunum yutaka! Ne kililite: ‘Yu nem got so, nem takak so kiskiw dukubi beso, alew biim mit mewso kel katin bukbuk angeko, im wiin daolinba kebiliw te!’, nangiwi, ne kilibi te. I fein weng bokonemsiliw, meni ba? ");
INSERT INTO bhl_vpl VALUES ("DN3_15","028_3_15","DAN","3","15","15","Kame nem weng kitil nam weng kale iti kilele kililina! Yom fongket em weng fongfong gaanin weng beso, fotiaw em weng filifolo gaaniw weng beso kililokoliw ding dim kabalak e, yu fongate akate nem dukusi kiskiw beem mit mewso uneko, beem mit elo katin bukbuk angeko, beem wiin e daolew keminba keliw tewe, fongate akate wonuk so kunum i teleko, yulo galuko, yemdeko, ais dong fian beem tem kabalak elo da koyemokoliw te. Da koyemiwi, nalem got ete yulo dokoyemeko, yemde toloke a? Feinka! Deiw dokoyemomin deiw mak banim te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_16","028_3_16","DAN","3","16","16","Yangei, i elo yan weng bokolewomeliw: “Be kenka! Ku kukalem ibolow ete kuw gelewa! Nu weng banim te! ");
INSERT INTO bhl_vpl VALUES ("DN3_17","028_3_17","DAN","3","17","17","Nu fein Sunbin-Got em wiin daolewkabuluw kunum kebuluw kasike, ku ‘Ilo ais dong tem fian elo da koyemina!’, angew tewe, num Sunbin-Got be ki keko, nulo fein dokoyemoke te. ");
INSERT INTO bhl_vpl VALUES ("DN3_18","028_3_18","DAN","3","18","18","Kate, e nulo dokoyeminba kele tewe, ku num weng bokokemuw weng kale kilele kal kela! Kom got so, kom gol so kaiselew takak so kiskiw dukuselew be so, alew biim wiin e nu nam daoyem kemuw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_19","028_3_19","DAN","3","19","19","Dangiwi, Nebukatnesal e im bokolewsiliw weng be kiliko, em kiinguen e kaim kuw alala yawal melmel kuw tololo angeko, wonuk so kunum mali ilo gaayemeko, bokoyemomele: “Yu kame ais be fian fian kuw gilili abuliw kano, beem mamin e atin kuw fian keko, sua em mamin e ben kel ding bakilewoka!”, yangeko, ");
INSERT INTO bhl_vpl VALUES ("DN3_20","028_3_20","DAN","3","20","20","akalem kitil nam wonuk so kunum mali mak ilo bokoyemomele: “Yu teleko, alemsal kunum biilo yauleko, sok so teing net yan net keyemeko, ais dong tem elo yemde da koyemina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_21","028_3_21","DAN","3","21","23","Yangei, i emsik kamok fian beem kaisuw fian atelewsomi, fongate akate em bokoyemse weng be geleweko, Satalak o, Abetnego o, Mesak o, alemsal kunum biilo yauleko, sok so nit net keyemeko, yamdeko, ikalem kak balam so, ilim minggikabiliw mesesem so, alik alik be atin kuw kubul de uneko, ais dong fian kainbe tem kalo kuse kabalak da koyemsiliw kale. Kabalak da koyemiwi, ais dong fian be yemde unsiliw wounk so kunum bikalem dim ete kaineko, kiw koyemei, i kuansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_24","028_3_24","DAN","3","24","24","Keko beli, emisik kamok fian em kanele eisneng be atemsomi, yol angeko, moko, akalem ibolow fukunin ken dulewkabiliw kunum biilo gaaneko, dakalalomele: “Ebe! Be nono keliw a? I nomin kawtiw kate a? Alik alik alemsal makuw sok so geko, ais da koyemiw kate, meni ba ya?”, gaaneko, dangei, i yan weng bokolewomeliw: “No, feinka. Kunum alemsal makuw da koyemiw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_25","028_3_25","DAN","3","25","25","Dangiwi, e bokolomele: “Ne sok banim kunum ketket teben kel kunum mak keko, ais dong mutuk ka kel mobiliwi, yetemi te. Ais akal mak im kal dim gel so mak kaininba kele te. Keko beli, ketket teben kunum em kal e got mak em kal atew kebelei, atemi te!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_26","028_3_26","DAN","3","26","26","Angeko, ais dong fian kainkabe dim mewso uneko, moko, gaanomele: “Satalak a! Mesak a! Abetnego a! Sunbin-Got atin kuw katiw alakabe Sunbin-Got em weng afak kunum min yutaka! Fongate akate yu kut matem telina!”, yangei, isik em weng bokoyemse weng be fein kiliko, ais dong tem biliw ka kolewko, matem kut talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_27","028_3_27","DAN","3","27","27","Teliwi, kal kunum wiin so kunum kebiliw alik alik i alemsal awkunum biim biliw mewso falal enke mosomeliwi, im dim diwsomi, atemiwete: Im kak kon o, kal dim o, ilim dim mesesem mak o, deik meneng kiw tong gelgel so mak kelinba kebiliwi, atemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_28","028_3_28","DAN","3","28","28","Atemsomeliwi, Nebukatnesal e weng mak gaaneko, bokolomele: “Ibo yake! Satalak o, Mesak o, Abetnego o, kunum alemsal biim Sunbin-Got em wiin fian daolewuma! Nimtew angom? E akalem dabalakamin finik mak dabalalei, e teleko, alemsal kunum kaliilo dokoyem kembe kasike! I nem weng fawtuk ayem weng kitil nam weng kaleem afak kelinba kesomi, kuanomin em awan elo finganinba keko, nanew kawin dim kaleem got im wiin daolinba kesomeliwi, ikalem Sunbin-Got ete kuw em wiin fian daolewkabiliw kunum kesiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("DN3_29","028_3_29","DAN","3","29","29","Kame alik alik yu nem weng kale kilelbi kililina! Kawtiw aneng aneng unse angom so, weng amen amen so, kal amen amen so, nimin kawtiw ite mak kunum yemamas kel biim Sunbin-Got beelo minin weng mak milewiw tewe, ne ikalem weng minin beem yan e fein duyemoki te. Yu kililina! Kawtiw biim yan so, teing so, tikis takas koyemeko, yenii, i atin kuw kuanokoliw te. Kuaniwi, ikalem am so makuw dakal tabol kuw keemoki te. Nimtew angom? Nanew got i Sunbin-Got beemdiw kesomi, kunum waneng ilo dokoyeminba kekabiliw kasike.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("DN3_30","028_3_30","DAN","3","30","30","Angeko, kunum alemsal biim wiin e daok fian kuw keyemsomelei, i mali aluwbamin kunum biim wiin bakiyemsiliw kale. Bakiyemei, biim aluwbamin akati wiin fian so keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("DN4_1","028_4_1","DAN","4","1","1","Deiw mak ding mak kelei, Nebukatnesal e weng fut mak boko, kunum waneng aneng aneng angom im biliw am dim so, weng amen amen kuw keko, biliw biso, kunum waneng alik alik ilo dabalayemse kale. Em fut weng bose fut be kanekote: “Alik alik yu ibolow menew so biliw yako! ");
INSERT INTO bhl_vpl VALUES ("DN4_2","028_4_2","DAN","4","2","2","Ne kame yulo Sunbin-Got atin kuw katiw alakabe Sunbin-Got em fian auk so kitil so eisneng mak e nem dim dukuko, kukunemse eisneng beem sang be alik alik yulo fut tem boko, dabalayemoki te. ");
INSERT INTO bhl_vpl VALUES ("DN4_3","028_4_3","DAN","4","3","3","Feinka! Sunbin-Got em kitil auk so eisneng kelewkabe eisneng e atin kuw bakilew fian beki beki kuw bakilewkabe te. Akalem angin yeteboke aneng ken dim e, diwkuw diwkuw sunsun boke te. Akalem emisik kamokim ke alakabe ding e nam ayet keosmi, banime te. ");
INSERT INTO bhl_vpl VALUES ("DN4_4","028_4_4","DAN","4","4","4","Kame, yu emisik kamokim Nebukatnesal, nem weng sang kale kililina! Ne ibolow menew so kuluko, nakalem am abin kawin dak teineko, ibolow nanbow ke alakabi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_5","028_4_5","DAN","4","5","5","Kaneli kate, kutiliw ding mak e, ne kiin dem mak seneko, finganin fian mak kulusi te. Feinka! Dak akal kebi dim bete, takak atew mak falak angei, ne finganin fian mak kulusi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_6","028_4_6","DAN","4","6","6","Kulomelii, ne Babilon abiw mutuk fian ka em kal fian so kunum alik alik ilo gaayemii, i teliwi, ne nakalem kiin dem beem mongom so beem dulum elote ‘Yu elo silel bokonemina!’, yangsi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_7","028_4_7","DAN","4","7","7","Yangii, i fein nem weng bokoyemsi weng be kiliko, gelew talsiliw kate, i nem kiin dem beem mongom e kilele mongom so silel dak bokoneminba kesiliw te. ");
INSERT INTO bhl_vpl VALUES ("DN4_8","028_4_8","DAN","4","8","8","Keliwi, fefe ibik ete, Daniel e talse te. (Nete nakalem got Bel em wiin daolewkabi kunum kasike, ne Daniel dangakabiliw beem wiin be alwol keleweko, em wiin so takiak moleko, “Beltesasal”, dangeko, dulewsi te.) Got ayem alik alik i kunum beelo ibolow fian kelewbiliw kasike, i elo kitil kal fian so dulewsiliw te. Daniel be fein nem mit mewso telei, ne elo nem kiin dem sensi sang be bokolomin memen kesomi, ");
INSERT INTO bhl_vpl VALUES ("DN4_9","028_4_9","DAN","4","9","9","bokolewomeli: ‘Beltesasal ku kal kunum kaliim emisik kak kunum kebelew kunum kute te. Nimtew angom? Alik alik got i takak so kunum kekembiliw kasike, mali okmobe eisneng mak kom dim e nam okmole te. Kame ku nem kiin dem sen kembi beem sang be kiliko, beem mongom silel bokonema! ");
INSERT INTO bhl_vpl VALUES ("DN4_10","028_4_10","DAN","4","10","10","Ne kiin dem akalbomelii, ne atemite: Ais tiak tiak mak kawin dim angse angom kale mobelei, atemsi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_11","028_4_11","DAN","4","11","11","Ais tiakim beem fe e unbeko, abiil melelewomin kis keko, belei, aneng aneng angom beem kawtiw alik alik i ais beelo atebiliwi, yetemsi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_12","028_4_12","DAN","4","12","12","Ais beem teing so kon so be ken atite keko, dem gilako, banso banso kebelei, kawtiw so, samal so, awon so, alik alik teleko, ais beem mit menew teinbomeliwi, ‘Ais dem be wanumo!’, angomi, teliwi, yetemsi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_13","028_4_13","DAN","4","13","13","Yetemeko, akalbomelii, ne atemite: Dabalakamin finik ayem mak abiil tikin elote mit telei, atemsi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_14","028_4_14","DAN","4","14","14","Dabalakamin finik be weng kitil weng mak gaanomele: ‘Ais be guliwi, e mit telei, beem ais kon o, teing o, ais dem o, alik alik giti goto kelewsomi, fomdelina! Fomdoliwi, kut samal beem afak biliw beso, awon beem ais teing dim aim gebiliw beso, alik alik i fonsangin unina! ");
INSERT INTO bhl_vpl VALUES ("DN4_15","028_4_15","DAN","4","15","15","Keko beli, ais fian beem kak e kolewsomi, ain sok so, balas sok so, kuluko, eingge koliwi, balasal ete falaloke te. Falalbelei, kutiliw mutuk em fial ok e teleko, ais mongom beelo ok abalewei, e kut samal so, kawin dim beem ais so, bongguko, boke te. ");
INSERT INTO bhl_vpl VALUES ("DN4_16","028_4_16","DAN","4","16","16","Beem boke dim e, fu ben kel itol ding kelei, akalem fukunin e alwol keko, kawtiw im fukunin emdiw kelinba keko, samal im ibolow fukunin imdiw kuw keboke te. ");
INSERT INTO bhl_vpl VALUES ("DN4_17","028_4_17","DAN","4","17","17","Alik alik yu kililina! Sunbin-Got fian abiil tikin katiw be alakabe Sunbin-Got e kitil so auk so keko, akalem ibolow ete kuw geleweko, mali imisik kamok kunum i em afak kuw da koyemkabe te. Akalem ibolow ete kuw e emisik kamok yetebin kunum mo koyemkabe te. Wiin so kunum ite, meni wiin banim so kunum ite. Akalem ibolow fukunin ete kuw gelewkabe te. Ne Sunbin-Got beem dabalakamin finik keko, kom mit mewso teleko, em ‘Kaneloke!’, ange weng kal kale bakakem teli te.’, nangse te. ");
INSERT INTO bhl_vpl VALUES ("DN4_18","028_4_18","DAN","4","18","18","Kame, Beltesasal, mali kal kunum i kiin dem beem mongom e kilele silel bokoneminba keliw kate, nem got ayem i kulo takak so kunum kemkemsiliw kasike kame, ku beem mongom e fein silel bokonema!’, dangsi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_19","028_4_19","DAN","4","19","19","Dangii, mali em wiin e Beltesasal dangbiliw Daniel be nem kiin dem kanele beem sang kiliko, ibolow tiak tiak keko, finganin fian mak kese kasike, emisik kamok fian ne elo bokolewomeli: ‘Ku kanelom kiin dem deiw atemew beem mongom em awan finganokolew te! Kilele mongom so silel bokonema!’, dangsi te. Dangii, e yan weng bokonemomele: ‘Kamok fian kutaka! Kiin dem mongom so be kom dulum elote nam tele te! Kom maka kawtiw im dulum ite kuw toloke te!’, nangse te. ");
INSERT INTO bhl_vpl VALUES ("DN4_20","028_4_20","DAN","4","20","20","Nangesomi, iti weng mak bokonemomele: ‘Kom kiin dem sen kembelew beem mongom e kanekote: Ku ais fian sel mak moko, beem fe e abiil melelewomin kis kebe ais mak atemselew te. Aneng aneng angom beem kawtiw alik alik i ais kitil nam beelo kilele atemeko, biliwi, atemselew te. ");
INSERT INTO bhl_vpl VALUES ("DN4_21","028_4_21","DAN","4","21","21","Ais beem teing o, ais kon o, dem o, banban atite kele kasike, samal awon o, kunum waneng o alik alik i makuw bongguko, beem dem wanakabiliw te. Kut samal ikal teleko, beem mit kel tein finengdako, teinsomeliwi, awon ikati teleko, beem teing dim kel aim geko, kebiliwi, atemselew te. ");
INSERT INTO bhl_vpl VALUES ("DN4_22","028_4_22","DAN","4","22","22","Kamok fian kutaka! Ais beem kiskiw em mongom e kukalem ete te! Kukalem ete aneng aneng angom beem kunum waneng im kiin dim e wiin fian so kak kunum kebomi, kom kitil e fian fian keko, abiil melelewin tew kebelew kasike, kunum waneng alik alik i kom weng afak kuw keko, kakabiliwi, ku ilo kilele yetebelew te. ");
INSERT INTO bhl_vpl VALUES ("DN4_23","028_4_23","DAN","4","23","23","Keko beli, ku dabalakamin finik mak abiil tikin elote mit telei, atemselew te. Dabalakamin finik be weng mak gaaneko, bokolomele: ‘Ais be guliwi, e mit telei, ais fian beem kak ete kuw koleweko, beem kimkim kawin tem dim kolewsomi, ain sok so, balas sok so, kuluko, einggeliwi, e balasal ete kuw falaloke te. Falalbelei, kutiliw mutuk em fial ok e teleko, beelo ok abalewei, e kut samal so, kawin dim beem ais so, bongguko, boke te. Keko belei, itol e ben kel keloke te.’, angei, atemselew te. ");
INSERT INTO bhl_vpl VALUES ("DN4_24","028_4_24","DAN","4","24","24","Angse weng beem mongom e kanekote: Abiil tikin kel alakabe Sunbin-Got e kulo diw katemeko, geekemin weng mak bokokemse te. ");
INSERT INTO bhl_vpl VALUES ("DN4_25","028_4_25","DAN","4","25","25","Kuso alakabiliw kawtiw i kulo kenbakaliwi, ku uneko, kut tem samal iso bokolew te. Bomelewi, im balasal so, ais kon so, wanakabiliw bulmakao iso makuw biimdiw wanbokolew te. Wanbomelewi, fial ok mit teleko, abakemboke kate, ben kel itol banime ding dim e, ku atin kuw kal keko, bokolomelew: ‘Feinka! Abiil tikin alakabe Sunbin-Got ete kuw akalem ibolow fukunin geleweko, kak kamok yetebin kunum alik alik moko, aneng aneng angom beem yetebe kunum keyemkabe kae!’, angokolew te. ");
INSERT INTO bhl_vpl VALUES ("DN4_26","028_4_26","DAN","4","26","26","Beli, dakayemin finik beem angse weng e bokolomele: ‘Ais kak mongom kimkim so yu nam kulu koliw te!’, ange weng beem mongom e kanekote: Kom Sunbin-Got em kitil atemeko, beem afak kelokolew ding dim kabalak e, e kulo iti Babilon aneng fian kaleem emisik kamok yetebin kunum kekemoke te. ");
INSERT INTO bhl_vpl VALUES ("DN4_27","028_4_27","DAN","4","27","27","Kamok fian kutaka! Kame ku Nem kewkew weng bokokemi weng kale kilele kilko, gelewemolewka! Ku kanelom iti sili sili nam kukuw keko, wa kukuw kelokolew te! Kesomi, kunum waneng mesesem mesesem em banim kebiliw kunum waneng ilo ibolow folok so keyemeko, baluw kawtiw kebiliw kawtiw ilo kinkin kukuw keyembolewka! Ku beemdiw kelew tewe, tiak ding kesomelei, ku ken abin kuw teinbokolew te.’, nangse te. ");
INSERT INTO bhl_vpl VALUES ("DN4_28","028_4_28","DAN","4","28","28","Nangei, fein, afam ete, Daniel em bokonemse weng alik alik be fein kamok fian Nebukatnesal nem dulum elote fitewse te. ");
INSERT INTO bhl_vpl VALUES ("DN4_29","028_4_29","DAN","4","29","29","Kalun kel kayow banimse ding dim bakate, deiw mak ding mak kelei, ne Babilon abiw mutuk fian kel nakalem am fian em am yu fian dim kel kakabisi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_30","028_4_30","DAN","4","30","30","Kakabomelii, ne bokolomeli: ‘Feinka! Kunum waneng kale biliw kawtiw alik alik nem wiin daonemoliwka! Nimtew angom? Abiw mutuk fian Babilon kale nakalem ete kuw nakalem kitil so auk so bete kuw gesi kasike!’, angsi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_31","028_4_31","DAN","4","31","31","Angeko, nem weng bakabi dim bakate, abiil tikin dim elote nem weng elo gitin gato kelewe weng mak kililite: ‘Kamok fian Nebukatnesal kutaka! Sunbin-Got em geekemin weng kale kilila! Kom atem alakabelew aneng kale, kame ne kom teing dim akate kulu koloki te! ");
INSERT INTO bhl_vpl VALUES ("DN4_32","028_4_32","DAN","4","32","32","Kuso alakabiliw kunum waneng i kulo kenbakalaliwi, ku uneko, kut tem samal iso bokolew te. Bomelewi, bulmakao im balasal wanbiliw be kukati iso diw wanbelewi, ben kel itol banimoke te. Banimoke ding dim kabalak e, ku atin kuw kal keko, bokolomelew: ‘Feinka! Abiil tikin alakabe Sunbin-Got ete kuw akalem ibolow fukunin geleweko, kak kamok yetebin kunum alik alik ilo moko, aneng aneng angom beem yetebe kunum mo koyemkabe kae!’, angolewka!’, nangei, ne kilisi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_33","028_4_33","DAN","4","33","33","Kilisomelii, beem nangse ding dim bakate, fongate akate dabalakamin finik beem nelo bokonemse weng be fein dem so kese te. Kesomelei, kawtiw neso alakabiliw kunum waneng i nelo nenbakaliwi, ne uneko, kut tem samal im biliw dim kel bomelii, bulmakao im balasal wanbiliw imdiw iso diw wanbomelii, fial ok e abanembelei, nem kak kon e tiak tiak kuw kesomi, bokol kalim atew kenemsomelei, teing bulung akal awon sikal tiak tiak atew kenemse te. ");
INSERT INTO bhl_vpl VALUES ("DN4_34","028_4_34","DAN","4","34","34","Keko beli, ben kel itol banime ding dim e, Nebukatnesal ne abiil tikin katiw elo kiin doung atemsi te. Atemsi ding dim e, nem ibolow fukunin kayak so be iti dolon kenemei, ne Abiil tikin katiw alakabe Sunbin-Got em wiin fian daolewsomi, bokolomeli: ‘Sunbin-Got ne kom wiin fian diwkuw diwkuw daokemika! Nimtew angom? Ku sunsun kuw alakabelew Sunbin-Got kute kuw kasike! Kom kamok fian keko, kunum waneng alik alik yetebelew aneng angom be nam banime te. Kom muluwel angom bi duku dak duku dak kelokoliw te. ");
INSERT INTO bhl_vpl VALUES ("DN4_35","028_4_35","DAN","4","35","35","Ku kukalem ibolow fukunin kuw gelewkabelew Sunbin-Got kebelew kasike, abiil tikin em mesesem so, kawin kaleem mesesem so, alik alik eisneng be kute kuw atem alakabelew te. Kunum waneng kawin kaleem buluw kunum waneng nu auk so banim sak kawtiw kebuluw kasike, nu kulo nam ‘Bayo!’, kangeko, kom mesesem mak ‘Kaneloki te!’, angeko, ibolow fukunbelew eisneng beem dulum elote nu nam ‘Bayo!’, kangeko, beem kanelokolew deiw be nam net kekemuw te!’, angsi te. ");
INSERT INTO bhl_vpl VALUES ("DN4_36","028_4_36","DAN","4","36","36","Angsi ding dim bakate, nem ibolow fukunin akati iti silel ken kuw keneme kasike, ne iti wiin fian kuluko, emisik wiin so aneng Babilon aneng fian kaleem emisik kamok fian kesi te. Keko beli, kal kunum iso, ibolow fukunin ken dunembiliw kunum iso, alik alik i iti nem mit mewso telesiliw kasike, nem iti kulusi wiin fian be nem sua em wiin aluwsi beelo de mit kalak dase te. ");
INSERT INTO bhl_vpl VALUES ("DN4_37","028_4_37","DAN","4","37","37","Kame, emisik kamok fian Nebukatnesal ne abiil tikin alakabe beem emisik kamok fian em wiin fian kuw daolewkabi te! Nimtew angom? Akalem ibolow fukunin e atin kuw kiol kuw kelei, e nomin eisneng mak em dulum elote ‘Ne keloki te!’, ange tewe, angse weng be fein dem gilaleko, atin kuw ken kuw keloke kasike. Yu kilelbi boliwka! Nimin kawtiw ite mak ikalem wiin ete kuw daobiw tewe, esik kanebiliw kawtiw biim wiin be fein mit da koyemkabe kasike.”, angeko, fut tem boko, aneng aneng angom biim kawtiw im teing dim elo dabalayemse kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_1","028_5_1","DAN","5","1","1","Beli, Nebukatnesal e kuanei, em awalik Belsasal e Babilon aneng fian beem emisik kamok fian kese ding kabalak e, deiw mak ding mak kelei, Belsasal e wanin dawol fian mak kese kale. Kebelei, akalem angin wiin so kunum waneng gaayemei, i teleko, eso makuw dawol wanin beso wain ok so wansiliw kale. Kawtiw banso talsiliw kawtiw biim fu fu e tausen makmak (1'000) kawtiw kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_2","028_5_2","DAN","5","2","3","Keko beli, wain ok wanbiliw dim bakate, Belsasal e weng kitil weng mak akalem weng afak kunum ilo bokoyemei, i uneko, Sunbin-Got em am yol em ok sen i gol so, silba so, on kisol beso kaisiliw ok sen ayem be de talsiliw kale. Nimtew angom? E ok sen ayem beso akalem wiin so kunum talsiliw kunum biso, akalem sun waneng uso, akalem afam waneng alik alik iso, wanomin ibolow kese kasike. (Sua e, em awalik Nebukatnesal e Selusalem abiw mutuk fian em Sunbin-Got em am yol fian beem tem uneko, ok sen ayem be kuluko, Babilon abiw mutuk fian kalo de talse kale.) Beli, em weng afak biliw kunum biim Sunbin-Got em am yol beem ok sen ayem be kulu talsiliw ding dim e, emisik kamok so, eso bisiliw wiin so kunum biso, akalem kalel alikum iso, alik alik i ok sen ayem beem dim wain ok duluko, wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_4","028_5_4","DAN","5","4","4","Wanbomeliwi, i ikalem got gol so, silba so, balas so, ain so, ais so, tum so kaisiliw got im wiin daoyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_5","028_5_5","DAN","5","5","5","Kanebiliwi, fongate akate kunum mak em teing kuw mak teleko, am kal dim kel weng mak bose kale. Weng bose dim be, takak banim keko, ailbin fian kese kasike, emisk kamok e teing beem fut bomin be kilele kiol kuw atemse kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_6","028_5_6","DAN","5","6","6","Atemeko, e finganin fian mak kuluko, em kiinguen be kaim kuw alel femdeko, kun walwal kuw kilikili angei, em kitil e banimeko, dangbalat angse kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_7","028_5_7","DAN","5","7","7","Angeko, oktakak kunum so, selew selew kunum so, fial atemeko, kaneloke eisneng atebiliw kunum so, alik alik ilo gaayemei, i em mit mewso teliwi, e bokoyemomele: “Nimin kunum ite mak weng kale teing bokoko, atemsomi, beem mongom e ‘Bete kai!’, nangeko, kilele silel bokonemiw tewe, ne kunum beelo emisik kamok nemdiw ilim olol nam so minggilewsomelii, gol on kisol so kaisiliw kait mak em gatak dim falal kelewoki te. Kelewii, ete wiin fian so kunum kebomi, Babilon aneng fian kaleem yemamas em kamokim fian keloke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_8","028_5_8","DAN","5","8","8","Yangse kate, kal kunum alik alik bi ki kelinba kesomi, teing em am kal dim bose weng be teing bokolinba keko, weng kal beem mongom e kilele kal kelinba kesiliw kasike, ");
INSERT INTO bhl_vpl VALUES ("DN5_9","028_5_9","DAN","5","9","9","kak yetebiliw kunum biim ibolow fukunin e atin kuw kou angsiliw kale. Angesomi, emisik kamok Belsasal e finganin fian fian mak kuluko, em kiinguen kaim alel angse kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_10","028_5_10","DAN","5","10","10","Beli, emisik kamok fian beem auk u kawtiw biim galul weng kiliko, teleko, emisik kamok fian beelo bokolewomelu: “Kamoka kutaka! Ku diwkuw ken kuw bokolew te! Ku kanelom finganeko, kaim alelokolew te! ");
INSERT INTO bhl_vpl VALUES ("DN5_11","028_5_11","DAN","5","11","11","Ku nem weng bokokemoki weng kale kilila! Kukalem atebelew aneng fian kale kel takak so kunum mak kebe te. Got alik alik i kunum beem kal e atin kuw fian kelewsiliw te. Kawalik em emisik kamok fian kese ding dim kabalak e, kunum waneng alik alik nu kunum beem got imdiw kele ibolow fukunin fian be fein atemsuluw kasike, kawalik Nebukatnesal e kunum beelo akalem kal fian so kunum im kak yetebe kunum kelewse te. ");
INSERT INTO bhl_vpl VALUES ("DN5_12","028_5_12","DAN","5","12","12","Beem ding dim kabalak e, kawalik e kunum beem wiin Daniel alwol keleweko, elo Beltesasal dangse kale. Ku kilele ibolow fukunolewka! Beltesasal beem kal e fian keko, mali kunum im kal e atin kuw bakiyemse kasike, e okmobe eisneng mak fitew dim da koleweko, kiin dem mongom so mak kilele silel bokoko, mesesem mesesem eisneng mongom ilum nam so mak kele tewe, e kiol kuw kelomin deiw fein atemeko, kukuyemkabe te. Kasike kame, ku Daniel elo gaalewewi, e tolomaka!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_13","028_5_13","DAN","5","13","13","Dangui, fein, i Daniel elo galewiwi, e emisik kamok fian beem mit telei, e elo bokolewomele: “Kutaka! Kute nakalem awalik Nebukatnesal em Suda aneng kunum tanbelel kunum mak em yemde talse biim kunum mak kute ye? Ku Daniel kute ye? ");
INSERT INTO bhl_vpl VALUES ("DN5_14","028_5_14","DAN","5","14","14","Nimtew angom? Ne kililite: Alik got i kulo ibolow fukunin ken so, kal fian so dukemiwi, ku takak so kunum kebelew kasike. ");
INSERT INTO bhl_vpl VALUES ("DN5_15","028_5_15","DAN","5","15","15","Kame ku kilila! Nem kal fian so kunum so, oktakak kunum so, alik alik i nem mit mewso teliw kate, i teing kuw beem am kal dim kel fut bose fut beem mongom e ki kelinba kesomi, teing bokoko, beem mongom e dolon kelinba kebiliw te. ");
INSERT INTO bhl_vpl VALUES ("DN5_16","028_5_16","DAN","5","16","16","Kate, mali i bokonemomeliw: Daniel, ku ki keko, okmobe eisneng mak fitew dim dasomi, mongom ilum nam so mak kele tewe, ku kiol kuw kelomin em deiw atemeko, kukuyemkabelew kunum kute te. Kasike kame, ku fut bose weng be teing bokoko, beem mongom e nelo kilele silel bokonemew tewe, ne kulo emisik kamok fian nemdiw ilim olol nam so minggiko, kokemii, gol so kaisiliw kait kom gatak dim falal kekemoki kasike, ku on kisol so wiin fian so kunum kesomi, Babilon aneng fian kaleem yemamas kel kamokim fian kelokolew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_17","028_5_17","DAN","5","17","17","Dangei, Daniel e yan weng bokolewomele: “Kamok fian kutaka! Fut bose weng kale ne teing bokoko, beem mongom e ne kilele silel bokokemoki kate, kom yan dunemokolew be ne nam kuli te. Ku kukalem ibolow fukunin kuw geleweko, yan be kukalem kuw aluwbokolew mani, nanew kawtiw mak ilo duyemokolew yake! ");
INSERT INTO bhl_vpl VALUES ("DN5_18","028_5_18","DAN","5","18","18","Kame, nem weng bokokemi weng kale kilila! Atin kuw katiw alakabe Sunbin-Got ete kuw kawalik Nebukatnesal kamokim auk so kitil so kamok fian kelewse kasike, ");
INSERT INTO bhl_vpl VALUES ("DN5_19","028_5_19","DAN","5","19","19","aneng aneng angom beem kunum waneng so, weng sin amen amen bokoliw kunum waneng iso, alik alik i em awan fingansiliw te. E akalem ibolow kuw geleweko, mak kunum mak em dulum elote ‘Ne elo alii, e kuanoka!’, ange tewe, e kunum beelo fein alei, e kuanoke te. Keko beli, e mak kunum mak em dulum elote ‘Ne elo dokolewo yo!’, ange tewe, e kunum beelo fein kuw dokolewoke kasike, e nimin kawtiw biim dulum elote ‘Wiin fian so duyemo yo!’, yangeko, meni nimin kawtiw im dulum elote ‘Biim wiin kame mit da koyemo yo!’, yange tewe, e akalem ibolow kuw geleweko, kanelewse te. ");
INSERT INTO bhl_vpl VALUES ("DN5_20","028_5_20","DAN","5","20","20","Kate, deiw mak ding mak e, auk so kamok fian be akalem wiin kuw daoko, ibolow kau so kunum kese kasike, Sunbin-Got e kamokim fian beem wiin atin kuw kulu kolewei, elo mit da kolewse te. ");
INSERT INTO bhl_vpl VALUES ("DN5_21","028_5_21","DAN","5","21","21","Koleweko, kunum beem ibolow fukunin e dolo keleweko, samal im fukunin emdiw kelewse kasike, kunum waneng i elo kuluko, anbakalaliwi, e uneko, kut samal so bulmakao so, samal iso makuw bomelei, im wanin wanakabiliw wanin bete kuw akati wanbomelei, fial ok e elo abalewbise te. Keko beli, deiw mak ding mak kele ding kabalak e, e atin kuw kal keko, bokolomele: ‘Feinka! Atin kuw katiw alakabe Sunbin-Got bete kuw akalem ibolow fukunin geleweko, kak kamok yetebin kunum alik alik moko, aneng aneng angom beem yetebe kunum keyemkabe te!’, angse te. ");
INSERT INTO bhl_vpl VALUES ("DN5_22","028_5_22","DAN","5","22","22","Kaneko kasike kame, Belsasal kutaka! Ku kamok fian beem awalik kebelew kasike, em dulum kenelewse sang alik alik be kilele kal kebelew kate, ku kom wiin e Sunbin-Got em afak da kolinba kebelew te. ");
INSERT INTO bhl_vpl VALUES ("DN5_23","028_5_23","DAN","5","23","23","Ku abiil tikin em Kamok Fian Sunbin-Got beelo maka keleweko, akalem am yol em ok sen ayem ‘De telina!’, angesomelewi, kuso, kom wiin so kunum kaliiso, kom kalel kumel iso, alik alik yu ok sen ayem be sakok keleweko, wain ok duluko, sak wanakabiliw te. Feinka! Auk so kitil so Sunbin-Got e kulo kilele ketemeko, kom deiw e diw atemkabe kate, ku em wiin daolinba kunum kebelew te. Feinka! Ku mali dasuw-got im wiin daoyemkabelew kunum kebelew kate, got bi mali kawtiw i gol so, silba so, balas so, ain so, ais so, tum so kaisiliw kasike, isik kiin so atemeko, kentem kiliko, ibolow so fukuninba kekabiliw te. ");
INSERT INTO bhl_vpl VALUES ("DN5_24","028_5_24","DAN","5","24","24","Keko beli, Sunbin-Got e teing be dabalalei, e weng be am kal dim kel fut bose te. ");
INSERT INTO bhl_vpl VALUES ("DN5_25","028_5_25","DAN","5","25","25","Kame ku fut bose weng be kilila! Weng be kanekote: ‘Mene Mene Tekel Ufalsin’. ");
INSERT INTO bhl_vpl VALUES ("DN5_26","028_5_26","DAN","5","26","26","Kame, ku weng beem mongom akal kilele kililolewka! ‘Mene’ weng beem mongom e kanekote: Sunbin-Got e kom Babilon aneng fian kaleem emisik kamok fian kebe ding e teing bokoko, beem ding kame awet kele te. ");
INSERT INTO bhl_vpl VALUES ("DN5_27","028_5_27","DAN","5","27","27","‘Tekel’ weng beem mongom e kanekote: Sunbin-Got e kom ibolow tem e diw atemeko, gal kekeme te. ");
INSERT INTO bhl_vpl VALUES ("DN5_28","028_5_28","DAN","5","28","28","‘Ufalsin’ weng beem mongom e kanekote: Babilon aneng fian kale ku kame atebelew kate, Sunbin-Got e kame aneng be kuluko, amen kuw keleweko, mali aneng atuk mak Midia kawtiw im teing dim elo, mali aneng atuk mak Felsia kawtiw im teing dim elo duyemoke te.”, dangeko, emisik kamok Belsasal elo bokolewse kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_29","028_5_29","DAN","5","29","29","Bokolewei, e kitil weng mak akalem aluwbamin kunum ilo bokoyemei, i uneko, Daniel elo emisik kamok fian emdiw ilim olol nam so minggiko, kolewiwi, gol so kaisiliw kait em gatak dim kel falal kelewsiliw kasike, e on kisol so kamok kunum fian kelei, Babilon aneng kaleem yemamas kel kamokim fian kese kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_30","028_5_30","DAN","5","30","30","Keko beli, beem ding beem mililiw mutuk kabalak e, maka i Babilon abiw mutuk fian matem teleko, emisik kamok Belsasal elo aliwi, e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("DN5_31","028_5_31","DAN","5","31","31","Kuanei, Midia kunum Dalius e Babilon aneng fian beem emisik kamok fian kese kale. Beem ding dim e, Dalius em itol e 62 kese kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_1","028_6_1","DAN","6","1","1","Keko belei, emisik kamok fian Dalius e fufu mali em duan kel (120) kamok fian galmoko, Babilon aneng fian beem aneng fong beem abiw mutuk abiw mutuk biim kak yetebiliw kunum keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_2","028_6_2","DAN","6","2","2","Keyemsomi, ‘Mesik esik i nem on kisol be tutumokoliw kai!’, angeko, moliw kamokim biim dulum elote Daniel so, alew kunum mali mak so, alemsal kunum bi mali biim imisik wiin fian so kunum keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_3","028_6_3","DAN","6","3","3","Keyemsomelei, e atemete: Daniel em aluwbamin e ken ati kuw keko, mali biim aluwbamin be bakiyembelei, atelewse kasike, e bokolomele: “Ne Daniel beelo emisik kamok biim emisik kelewii, e biim kak kunum keloke te!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_4","028_6_4","DAN","6","4","4","Angesomelei, Daniel eso fangfangdasiliw kunum bi emisik kamok fian beem ange weng be kiliko, Daniel elo ibolow mesem kelewsomi, elo de mit da kolomin deiw mak “Nale ete, nal ete?”, angeko, fensiliw kale. Fensiliw kate, Daniel em aluwbamin so, bin kukuw so, alik alik be atin kuw gel so sen so banim kelei, e kawtiw ilo dasuw bokoyemeko, yakut keyembin kukuw gel so mak keyeminba kekabe kasike, i ibolow kau angeko, elo gelewomin deiw mak ateminba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_5","028_6_5","DAN","6","5","5","Ateminba kesiliw kasike, i bokolomeliw: “Nu ki keko, elo gelewomin deiw gel mak ateminba kebuluw kate, kunum be diwkuw diwkuw akalem Sunbin-Got em wiin kuw daolewkabe kunum ke alakabe te. Mesik esik nusik em kanakabe kukuw beem deiw beelo gelewomin deiw mak atemokoluw kasike!”, ange ange keko, bokolew bokolew kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_6","028_6_6","DAN","6","6","6","Kesomeliwi, i emisik kamok fian em fukun uneko, elo bokolewomeliw: “Emisik kamok fian Dalius kutaka! Kute kuw diwkuw diwkuw bokolew te! ");
INSERT INTO bhl_vpl VALUES ("DN6_7","028_6_7","DAN","6","7","7","Kom afak keko, buluw kamok kunum alik alik nu ibolow ki keko, kulo weng mak bakakem tuluw te. Kamokim kutaka! Ku kitil weng mak dukuko, fut boko, aneng aneng angom biim kunum waneng alik alik ilo dabalayema! Dabalayemew kano, alemsal king kel (30) ding dim e, kawtiw alik alik i kanelom dakalakamin weng mak mali got so, mali kawtiw kunum waneng iso, alik alik ilo bokolew bokolew kesomi, dakalalokoliw te. Kate i kukalem wiin kuw daoko, kukalem kuw dakalako, kukalem afak kuw boliwka! Nimin kawtiw ite mak kom wiin daolinba keko, nanew kunum waneng so, nanew got so, nanew mak im wiin daoko, kulo sakalaw keko, weng bo bo kekemiw tewe, ku ilo alaion samal im alakabiliw kawin tem kel kabalak da koyem koyem kemolewka! ");
INSERT INTO bhl_vpl VALUES ("DN6_8","028_6_8","DAN","6","8","8","Kasike kame, kamok fian ku mali kunum ilo bokoyemewi, i sawa fut weng be fut dim kel boliw kano, sawa be Media kasel so, Felsia kasel so, alik alik num sawa kitil nam keloke te. Kelei, kunum waneng alik nu sawa weng beelo diwkuw diwkuw gelewbomi, beem afak kakabuluw te. Kakabomeluwi, kunum waneng alik alik i sawa weng ayem be nam alwol keleweko, banim kelokoliw te.”, dangeko, bokolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_9","028_6_9","DAN","6","9","9","Bokolewiwi, emisik kamok Dalius e im weng bokolewsiliw weng be kiliyemeko, “Kenka!”, yangei, i sawa weng be fein fut dim dako, bosiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_10","028_6_10","DAN","6","10","10","Boliwi, Daniel e dukusiliw sawa weng kikis beem weng be kilise kate, e akalem kanekakawkabe kukuw be gelewko, Sunbin-Got eso weng bokolomin yako unse kale. Sunbin-Got eso weng bokokabe kukuw be kanekote: Diwkuw diwkuw makmak ding em alemsal ding dim kabalak, e akalem am el boktak mitem uneko, Selusalem abiw mutuk fian ka em dulum elo kiinguen fubelet dako, atemsomi, Sunbin-Got eso weng bokolewse kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_11","028_6_11","DAN","6","11","11","Kaneko beli, mali kamok kebiliw kunum bi bongguko, Daniel em am mewso uneko, em Sunbin-Got eso bokolewkabe kukuw be kili atemeko, tong mileweko, ");
INSERT INTO bhl_vpl VALUES ("DN6_12","028_6_12","DAN","6","12","12","emisik kamok fian em mit uneko, ibik weng elo bokolewomeliw: “Dalius kamokim fian kutaka! Sin kuw, ku bokolomelew: ‘Alemsal king kel (30) em ding dim e aneng aneng angom biim kawtiw i kanelom dakalakamin weng mak mali got so, kawtiw kunum waneng iso, nam bokolew bokolew keko, dakalakamokoliw te! Kate i nakalem wiin ete kuw daoko, nakalem ete kuw dakalako, nakalem afak kuw boliwka! Nimin kawtiw ite mak nem yangbi weng be sakalaw keko, weng bo bo kelewiw tewe, ne kanekabiliw kawtiw biilo alaion samal im alakabiliw kawin tem kel kabalak da koyem keyemoki te.’, angeko, bokoyemselew meni ba?”, dangeko, dakalasiliw kale. Dakalaliwi, e yan weng bokoyemomele: “No, ne sawa weng ayem be dukuko, fut tem bosi kasike, sawa weng be num Midia kasel so, Felsia kasel so, alik num sawa weng kitil nam kelewse te. Mali kawtiw mak i teleko, sawa be nam iti alwol keko, banim keliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_13","028_6_13","DAN","6","13","13","Yangei, em fukun talsiliw kunum bi bokolewomeliw: “Suda aneng fian elote talse kunum Daniel e kom dukuselew sawa weng be sakalaw keko, weng bo bo kelewsomi, kom afak elo kelinba kekabe te. Kesomelei, diwkuw diwkuw makmak ding em alemsal ding dim kabalak, e akalem Sunbin-Got eso weng bokolewkabe te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_14","028_6_14","DAN","6","14","14","Dangiwi, Dalius e ibolow tem sakalet angeko, sakik fian kuw kelewei, e Daniel elo dokolewomin deiw fensomi, ibolow tiak tiak keko, akal bin kuw kese kale. Kelei, ataan tem dokong banim banim kese kate, e elo dokolewomin deiw mak ateminba kese kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_15","028_6_15","DAN","6","15","15","Keko beli, ataan tem unse ding kabalak e, kamok kunum bi iti emisik kamok fian beem fukun uneko, elo bokolewomeliw: “Kukati kilele kal kelewete: Midia kasel so, Felsia kasel so num boko, fut tem dasuluw sawa weng alik alik be, kawtiw alik alik nu ki keko, kolewko, alwol kelinba kekabuluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_16","028_6_16","DAN","6","16","16","Dangiwi, e wonuk so kunum ilo bokoyemei, i Daniel elo fein kulam unsiliw kale. Unesomeliwi, kulu debele teliwi, emisik kamok fian Dalius e Daniel elo bokolewomele: “Ku kukalem Sunbin-Got em wiin ete kuw daolewko, alakabelew kunum kebelew kasike kame, esik kulo dokokem kemoka!”, dangei, wonuk so kunum i elo kulu debele uneko, alaion im alakabiliw tem kabalak elo kuse mit da kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_17","028_6_17","DAN","6","17","17","Da kolewsomeliwi, i tum sel mak kuluko, tem tikin dim elote net kasi kolewiwi, emisik kamok fian so, akalem wiin so kunum fian so bi tikin be ikalem wiin so takiak amkoko, kolewsiliw kale. Kolewsomeliwi, mali kawtiw i wiin takiak amkoko, kolewsiliw be atemeko, kal keliwete: Tum tikin net kasik kolewsiliw be nam kulu koliw te!”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_18","028_6_18","DAN","6","18","18","Keko beli, emisik kamok be iti akalem am uneko, wanin so ok so tokoko, mali kunum waneng elo kalfongdewin beem mongom ete gaayeminba kesomi, kiin ok kuw falewbelei, akalinba kese kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_19","028_6_19","DAN","6","19","19","Keko beli, aneng danse ding dim keko, kutim mililiw kuw akate, e teineko, am koleweko, alaion im koyem biliw tem mit yako unse kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_20","028_6_20","DAN","6","20","20","Uneko, weng yak bokosomi, ibolow sakalet weng mak keko, gaaneko, bokolomele: “Daniel, finik so Sunbin-Got em weng afak kakabelew kunum kutaka! Ku diwkuw diwkuw kukalem Sunbin-Got em wiin daolewkabelew kunum ke alakabelew te. Kame, esik ki keko, kulo dokokem kembe ya?”, dangeko, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_21","028_6_21","DAN","6","21","21","Dakalalei, Daniel e yan weng bokolewomele: “Kamok fian kutaka! Kute kuw diwkuw diwkuw bokolew te! ");
INSERT INTO bhl_vpl VALUES ("DN6_22","028_6_22","DAN","6","22","22","Ne wa kukuw mak kekeminba kesomi, Sunbin-Got em kiin dim e sen gel so banim kunum kebi kasike, e akalem dabalakamin finik mak dabalalei, e alaion biim bontem kasi koyemei, i nelo neninba kenembiliw te. Feinka! Ne ken kuw bi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_23","028_6_23","DAN","6","23","23","Dangei, emisik kamok fian be kalfong fian mak kuluko, mali wonuk so kunum ilo weng mak bokoyemei, i kiliko, Daniel elo kawin tem elote matem da kolewsiliw kale. Da kolewsomeliwi, i em anggil diw atemiwete: Em anggil kal dim e mesesem mesesem so mak wa kelinba kebelei, atemsiliw kale. Nimtew angom? Daniel e Sunbin-Got elo fein kuw kelewko, gelewkabe kunum kese kasike. ");
INSERT INTO bhl_vpl VALUES ("DN6_24","028_6_24","DAN","6","24","24","Keko beli, emisik kamok fian be wonuk so kunum biilo iti kitil weng mak bokoyemeko, ilo yemdalei, i em bokoyemse weng be geleweko, emisik kamok fian beem mit teleko, Daniel em dulum elote ibik weng bokolewsiliw kunum biso, bikalem aul waneng iso, alik alik biilo makuw bongguko, yemde talsiliw kale. Yemde telesomeliwi, i ilo alaion im koyem biliw tem elo kuse kabalak kabalak da koyemsiliw kale. Koyemsiliwi, tem beem boktak dim mit talbiliw bakate, alaion i ilo ning tamoko, mit mit keyemeko, im kun so, kal so, dem so, alik alik kawtolko, yen wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_25","028_6_25","DAN","6","25","25","Beli, emisik kamok fian Dalius e weng kal kale fut tem boko, aneng aneng angom biim biliw kawtiw so, weng sin amen amen bokokabiliw kawtiw iso, alik alik ilo dabalayemeko, bokoyemomele: “Alik yu ken ati kuw keboliwka! ");
INSERT INTO bhl_vpl VALUES ("DN6_26","028_6_26","DAN","6","26","26","Alik alik yu nem kitil weng kale kiliko, kilele gelewina! Nakalem yetem alakabi aneng fian kaleem kunum waneng alik alik yu Daniel em Sunbin-Got em wiin afak kesomi, em awan finganeko, em wiin daolewboliwka! Nimtew angom? Sunbin-Got bete kuw sunsun bin kuw alakabe kasike. Akalem yetem alakabe dim e nam banimei, mali kawtiw i ki keko, elo nam de mit da kolewiw kasike. ");
INSERT INTO bhl_vpl VALUES ("DN6_27","028_6_27","DAN","6","27","27","E kawtiw nulo dokoyemeko, num kuankemin deiw kakabuluw deiw beelo okilewkabe Sunbin-Got ete te. Em kitil e fian kasike, abiil tikin so, kawin dim kale so, e auk so kitil so eisneng aluweko, alakabe te. Fein! E alaion im kitil ete de mit da koyemei, i Daniel elo an waninba kesiliw te.”, angeko, fut tem boko, aneng aneng angom kalo dabalayemse kale. ");
INSERT INTO bhl_vpl VALUES ("DN6_28","028_6_28","DAN","6","28","28","Keko kasike, Dalius em emisik kamok kese ding so, Felsia kasel Sailus em emisik kamok kese ding so, biim ding dim e Daniel e kamok fian kesomi, ken abin kuluko, teinse kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Kunum mak em wiin e Yona, Amitai em min alenale kale. Belei, deiw mak ding mak kelei, Yawe Sunbin-Got e elo weng mak bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Ne atemite: Abiw mutuk fian Ninibe kawtiw kunum waneng i sili sili kukuw wa kuw kebiliwi, yetebi kasike, ku kame unesomi, abiw kasel biilo kulo sowete bokokemoki weng kitil weng mak bokoko, ilo duyemolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Dangse kate, Yona e Yawe em weng kililinba kesomi, em weng bokolewse weng beelo sakalaw keko, weng bo bo kelewko, elo koleweko, sak fon unomin ibolow kese kale. Kesomelei, “Talsis abiw mutuk fian kalo uno!”, angeko, Yoba abiw mutuk fian kalo fon unesomelei, siw dim unomin deiw fense kale. Deiw fen atemsomelei, kunuw unomin deiw weneko, Talsis abiw mutuk fian kalo fon unse kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Beli, em unbe ding dim e, Yawe e suuk inim kitil nam mak dabalalei, e teleko, kunuw okmun dim unbiliw biilo fimdi famde dakal dukulomin kis so kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Kelewei, kunuw dim beem aluwbamin kunum i finganin fian fian mak kuluko, ikalem amen amen kuw ikalem dasuw-got ilo gaayemeko, bokolomeliw: “Ibo yake! Nulo dokoyemina o!”, ange ange keko, men mesesem angom be daktineko, kuse ok ok dasiliw kale. Dasiliw beem ding dim be, Yona e kunuw beem tem afak kel kiinok ilum sen mak diw diw akalse kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Akalbelei, kunuw beem dekakabe kunum mak teleko, bokolewomele: “Wee kutaka! Ku nolom ete nanbow angeko, akalbelew a? Fongate akate komikal kukalem got elo gaalew kano, e nulo yetemeko, nulo kinkin keyemsomi, dokoyemoke kasike, ok be alik alik nulo kanelom yenei, nu kuanoluw te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Dangei, aso i Yona em be dim be koleweko, mali kawtiw im biliw dim katiw elo unsiliw kale. Uniwi, kunuw dim beem aluwbabiliw kunum i weng tekeko, bokolomeliw: “Kanem sen ete kelei, nu kuanomin kis kebuluw be fenuma!”, angeko, ikalem selew selew kukuw gelewsomi, atemiwete: Yona em wiin ete fitew kelei, atemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Atemsomi, elo dakalalomeliw: “Kutaka! Ku ilum ding tele kaleem mongom e nulo kilele bokoyema! Kom aluwbamin e nimtew a? Ku nal elote telew a? Ku nalem kayak a? Kom kunum mongom e kante a?”, dangeko, Yona elo dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Dakalaliwi, Yona e ilo yan weng bokoyemomele: “Ne Kibulu kunum nete te. Ne Yawe Sunbin-Got em aluwbamin kunum kebomi, akalem wiin daolewkabi kunum nete te. E abiil tikin kayak kebomi, okmun fian kale so, kawin so alik alik dukuse Sunbin-Got ete te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Yangeko, weng makso bokoyemomele: “Ne Sunbin-Got em nelo bokonemse weng be kililinba keko, em weng sakalaw keko, weng bo bo keleweko, fon telesi te.”, yangse kale. Yangei, i em yan weng be kiliko, finganin fian fian mak kesomi, bokolewomeliw: “Ibo! Nimtew angom ete ku kanekembelew a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Dangsiliw ding kabalak e, suuk so inim so be kitil nam kesomelei, ok fasuko, fole fole keko, katiw une kalak une keme kasike, i Yona elo dakalalomeliw: “Kame, nu nono keluw ete, ok fole fole be singdet daking banimoke a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Dangiwi, e yan weng bokoyemomele: “Nem sen beem dulum elote ok inim be nulo yenomin keeme kasike kame, yu nakalem ete galuko, ok da konemina! Konemiw kano, ok fole fole kebe be singdet banimoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Yangei, i em weng bokolewse weng be kilisiliw kate, elo gelewinba kesomi, kun kuluko, melmel sen bingeko, bukeko, benggew dulum elo unomin kesiliw kale. Kate, i ki kelinba kesiliw kale. Nimtew angom? Ok fole fole kebe be abiil abiil unesomelei, itel fian kese kasike. ");
INSERT INTO bhl_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Keko beli, kunuw dim beem aluwbamin kunum i Yawe elo gaaneko, menew falit weng mak bokolewomeliw: “Yawe Sunbin-Got kutaka! Ku kanelom nulo gal keyemomi, nulo yenewi, nu kuanokoluw te! Sunbin-Got kutaka! Nu kom aluwbamin kunum beelo akokow kelewsomi, ‘Kiol kukuw gelewkabe kunum kebe sako?’, angeko, kal kelinba kekabuluw te. Kate ku kukalem ibolow fukunin kuw gelewbelewi, nu kame kilele atemeko, kal kebuluw te. Kasike kame, nu kunum beelo okmun da kolewuw tewe, ku nulo kanelom kawtiw yemin kunum im yan wa duyemokolew te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Dangesomeliwi, i Yona elo galu debele uneko, okmun fole fole kebe beem tem kuse dasiliw kale. Elo dasiliw ding dim kabalak e, sin tew kame tew ok fole fole keembe be tete daking singdet banimse kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Kaneko beli, kunuw beem aluwbabiliw kunum bi kanese be atemeko, Yawe em angan finganin fian fian mak kuluko, Yawe elo “Weso! Seyo!”, dangeko, samal anko, elo dulewsomi, fawtuk ayem weng mali mak Yawe elo bokolewsomi, dulewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Beem ding dim bakate, Yawe e Yona em ibolow beelo fukuneko, elo dokoleweko, dol fian sel mak dabalalei, e teleko, Yona elo kunil kolewse kale. Kolewei, e dol kulin tem kel belei, taw akal kutiliw akal yemamas kel ding kese kale. ");
INSERT INTO bhl_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Beli, Yona em dol em kulin tem kel bise ding dim kabalak e, e Yawe akalem Sunbin-Got elo fililin weng sin mak bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Eke Yawe kutaka! Ne ilum kulusomi, kulo gaakemii, ku nem gaanin be kiliko, dokonemselew te. (Sim Fut 120:1) Sunbin-Got kutaka! Kuansiliw kawtiw im abiw atew kale kel amebomi, ‘Dokonema!’, kangsi kasike, ku nem kangi weng be kiliko, kinkin ibolow kukuw kukunemselew te. ");
INSERT INTO bhl_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Yawe kutaka! Ku nelo kuse okmun fian alelbin diw diw kalak da konemewi, ne ka kel bisi te. Okmun fian diw kel akim bilii, ok be nem dim kel kawtol unse te! (Sim Fut 42:7) ");
INSERT INTO bhl_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Unei, ne kulo bokokemomeli: ‘Ku nelo atin kuw konemew sako!’, kangsi kate, ne kom am yol fian be iti fein atemoki te! (Sim Fut 31:22) ");
INSERT INTO bhl_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Okmun fian be nem tikin dim kel unsomelei, e nelo dukakan kenemei, ‘Nono memfu angoki?’, angsi te. (Sim Fut 69:1) Kanenemei, okmun em alelbin em akikiw e kak so falal kasi konemse te. ");
INSERT INTO bhl_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ne okmun fian beem amgu yaman awet kebe dim beem afak uneko, afak dakaw kalak bomi, fon unomin deiw mak ateminba kesi te. Kate, Yawe nem Sunbin-Got kutaka! Ku nelo kuluselew kasike, ne bisi aneng wa dim be koleweko, matem telii, ku nelo finik so ibolow dunemselew te. ");
INSERT INTO bhl_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Yawe kutaka! Nem kuanomin kis kunum emdiw kesi ding dim kabalak be, (Sim Fut 142:5) ne kom ibolow fukunsomelii, nem ‘Dokonema!’, kangsi weng be kom am yol dim abiil tikin kawtem elo talse te. ");
INSERT INTO bhl_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ikalem dem banim dasuw-got ilo wangweng kukuw kukuyembiliw kawtiw i Sunbin-Got em akalem kunum waneng ilo folok ibolow kukuyemkabe kukuw be dawkatikoko, kolewsiliw te. (Sim Fut 31:6) ");
INSERT INTO bhl_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Kate nakalem ete kulo kuw kutikemeko, kom wiin ete kuw daokemsomi, sim kutikemkabi te. Kutikemsomi, nem fawtuk ayem weng bokokemsi weng bakati fein gelewoki te. Nimtew angom? Yawe kutaka! Kukalem ete kuw kunum waneng im kuankemin deiw bul gewsi goto kelewko, ilo finik so deiw mo koyemkabelew Sunbin-Got kute kasike. (Sim Fut 3:8)”, dangeko, Yawe elo dangse kale. ");
INSERT INTO bhl_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Dangei, Yawe e dol fian sel beelo kitil weng mak bokolewomele: “Ku kame ok dilin benggew dim elo uneko, kom kunil kolewbelew kunum beelo wasan fok kelolewka!”, dangse kale. Dangei, e fein uneko, ok dilin benggew dim kel elo wasan fuko, matem da kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Keko beli, Yawe Sunbin-Got e iti weng ming weng bakate Yona elo bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Ku kame unesomi, Ninibe abiw mutuk fian beem kasel ilo bokokemoki weng mak bakayem tem bakayem tem unolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Dangei, Yona e Yawe em bokolewse weng be fein kili geleweko, Ninibe abiw mutuk fian kalo unse kale. (Ninibe angakabiliw abiw mutuk fian be unbi unbi kiin fe so kese abiw kale. Nimin ete “Mali elo uno!”, ange tewe, deiw am alew keloke te.) ");
INSERT INTO bhl_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Beli, Yona em abiw mutuk fian kalo uneko, ka talse ding kabalak e, e makmak ding mak kawtem uneko, abiw mutuk fian beem kasel ilo weng kal mak bokoyemomele: “40 kel ding dim mak keko, banimei, maka mak teleko, yulo yeneko, kuiaw keyemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Yangei, kunum waneng bi em bokoyemse weng be kiliko, Sunbin-Got elo “Fein!”, dangesomi, wiin so kawtiw so, wiin banim kawtiw so, alik alik i wanin wanbin e tokoko, sakik kuluko, sakik ilim minggisiliw kale. ");
INSERT INTO bhl_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Keko beli, mali kawtiw mak teleko, Ninibe abiw mutuk fian beem emisik kamok kebe kunum beelo Yona em weng bokoyemse weng be bokolewiwi, akati kilise kasike, akalem kamok teinbin ayem beso, akalem ilim ken so, akalem abin so, alik alik be kolewesomi, sakik ilim minggiko, kutew dim teinse kale. ");
INSERT INTO bhl_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Teinsomelei, e kitil weng kal mak Ninibe abiw mutuk fian beem kasel alik alik ilo dabalako, bokoyemomele: “Neso, nem afak keko, yetebiliw kunum iso, alik alik nu Ninibe abiw mutuk fian kaleem biliw kawtiw yulo weng kitil weng kale bokoyemomeluw: ‘Yuso, yukalem am dim samal beso, alik alik yu ‘Wanin soul ayem!’, angesomi, wanin tokoko, keloliwka! ");
INSERT INTO bhl_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Kelewsomi, kawtiw yukalem so, yom am dim samal biso, alik alik yu sakik ilim minggisomeliwi, Sunbin-Got elo weng kitil kuw gaaneko, yukalem mamtel kukuw so, silikmoyem kebe ibolow beso, alik alik kukuw wa be atin kuw kolewoliwka! ");
INSERT INTO bhl_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Kolewsomeliwi, Sunbin-Got e num kame kanebuluw kukuw ken be ateyemeko, em nulo kaisuw keyemeko, ‘Kuiaw keyemoki te!’, angbe ibolow be daking koyemeko, nulo kinkin ibolow so fukuneko, yetemoke sako!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Kaneko beli, Sunbin-Got e im kanekabiliw kukuw be atemeko, “I ikalem sua kel kanesiliw kukuw be koliw kai!”, angeko, em “Kanelo yo!”, angakabe ibolow be dakingeko, ilo kinkin ibolow so fukuneko, yetemsomi, maka im dim dabalalinba kese kale. ");
INSERT INTO bhl_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Keko beli, Yona e digaka kesomi, Sunbin-Got elo kaisuw keleweko, bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","“Yawe kutaka! Nem weng kale kame kilila! Ne kal kelite: Ku ibolow folok kinkin so Sunbin-Got kute te. Ku fongate akate kaisuw kelinba kesomi, kawtiw nulo ibolow mutuk fian duyemkabelew kasike, nulo anggil ilum duyemeko, fongate yeninba kekabelew Sunbin-Got kute te. Sua kel e, nakalem am dim bomi, fon uninba kebisi ding kabalak e, ne kilele kal kesite: “Ku kom ibolow fukunin be iti alwol kelewokolew sako!”, angbomi, bisi te! ");
INSERT INTO bhl_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Yawe kutaka! Nem finik so bomin e gal kenembe kasike, nemisik kuanbili kano!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Dangei, Yawe e yan weng bokolewomele: “Eke, Yona! Kom kaisuw kebelew be kukalem ken kebelew baka bani?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Dangeko beli, Yona e abiw mutuk fian be koleweko, abiw mutuk fian beem ataan talakabe dulum elo uneko, menew am gel mak kanis doung kanel doung gesomi, teinsomelei, abiw mutuk fian beelo kiineng angeko, “Nomin eisneng mak keloke yako!”, angeko, atemse kale. ");
INSERT INTO bhl_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Atemsomelei, Yawe Sunbin-Got e “Ataan mamin abe beem menew dulewkemin beem mongom ete te!”, angomelei, e sok til basi so mak Yona em mit mewso dukulei, e beem afak kel teinsomi, kalfongse kale. ");
INSERT INTO bhl_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Kalfongsomelei, akaleko, iti kutim danei, Sunbin-Got e dak emdiw eisneng mak dabalalei, e uneko, sok til beelo dakilei, e getse kale. ");
INSERT INTO bhl_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Kaneko beli, ataan fian dukule ding dim e, Sunbin-Got e ataan telbe dim elote ataan mamin so inim mak dabalase kale. Dabalalei, Yona em kak dim mamin kuw tingting kelewbelei, e kak olok olok kelei, em kiin felfel so kesomi, fom mitomin kis keko, bokolomele: “Nem finik so bomin e gal kenembe kasike, nemisik kuanbili kano yo!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Angei, Sunbin-Got e Yona elo bokolewomele: “Eke, Yona! ‘Sok dakilei, gete kai!’, angomi, gal kelew sako? Kom kaisuw kebelew be kukalem ken kebelew baka bani?”, dangse kale. Dangei, e yan weng bokolewomele: “No! Ne fein kane bi eli a! Feinka! Kanemsi kuw kae! Kasike, kaisuw fian kuw kebi kae! Mesem kuano ya!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Dangei, Yawe e elo bokolewomele: “Kutaka! Ku kilele ibolow fukunolewka! Taw makmak akaleko, get kembe eisneng gel fong eisneng kaleem dulum elote ku kinkin ibolow kelewbelew kate, kusik beem dulum elote aluwbinba kebelewi, emikel kuw talfut kesomi, emikel kuw iti getse te. ");
INSERT INTO bhl_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Kaneko kasike, nakati Ninibe abiw mutuk fian beem kunum waneng fufu banban 120 tausen (120'000) kel iso, ikalem am dim samal banban biso, alik alik biim dulum elote sakik ibolow folok so keyembi te. Feinka! Kawtiw bi nem kiin dim e, ‘Kukuw ken baka! Kukuw wa baka!’, angeko, teifuluko, kal kelinba ke alakabiliw kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kale, Mesaya Yesus em awalik kumel im wiin te. Yesus e Debit em angin kelei, Debit be Abalakam em min dow ete te. ");
INSERT INTO bhl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Beem sang e kanekote: Abalakam e Aisak em alew kese kale. Aisak e Sekow em alew kese kale. Sekow e Suda so akalem awkunum kumel so im alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Suda e Feles so Sela so im alew kelei, Tamal u aso im auk kesu kale. Feles e Kesolon em alew kese kale. Kesolon e Alam em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alam e Aminadaw em alew kese kale. Aminadaw e Nason em alew kese kale. Nason e Salmon em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon e Boas em alew kelei, Elakaw u em auk kesu kale. Boas e Obet em alew kelei, Ilut u em auk kesu kale. Obet e Sesi em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Sesi e emisik kamok fian Debit em alew kese kale. Kelei, Debit e Solomon em alew kelei, Ulia em kalun waneng u Solomon em auk kesu kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon e Elekoboam em alew kese kale. Elekoboam e Abiya em alew kese kale. Abiya e Asa em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa e Sekosabat em alew kese kale. Sekosabat e Sekolam em alew kese kale. Sekolam e Usia em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia e Sotam em alew kese kale. Sotam e Akas em alew kese kale. Akas e Kesekia em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Kesekia e Manase em alew kese kale. Manase e Emon em alew kese kale. Emon e Sosaya em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sosaya e Sekoyakim so akalem awkunum kumel so im alew kese kale. Biim bisiw ding dim kabalak e, maka i teleko, Suda kawtiw biilo Babilon abiw mutuk fian kalo yemde unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Beli, biim Babilon abiw mutuk fian ka kel bisiliw ding so, aneng beem iti kolewsiliw ding dim bakate, Sekoyakim e Sealtiel em alew kese kale. Sealtiel e Selubabel em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabel e Abiut em alew kese kale. Abiut e Elyakim em alew kese kale. Elyakim e Asol em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asol e Sadok em alew kese kale. Sadok e Akim em alew kese kale. Akim e Eliut em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut e Eleasal em alew kese kale. Eleasal e Matan em alew kese kale. Matan e Sekow em alew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sekow e Yosew em alew kelei, Yosew e Malia um imok kese kale. Keko beli, Malia u Yesus dukului, kunum waneng i aul beem wiin e “Mesaya!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Beli, Abalakam teleko, Debit em dim kabalak e, mutum kel dow kesiliw kale. Kesomeliwi, Debit teleko, Suda kawtiw i Babilon abiw mutuk fian kalo unsiliw ding kabalak e, bakati mutum kel dow kesiliw kale. Keliwi, biim Babilon alenaliw ding teleko, Malia um Mesaya dukusu ding kabalak e, it mutum kel dow kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Malia um Yesus Kulais dukusu sang e kanekote: Kunum mak em wiin e Yosew alenale kale. Kunum be Yesus em auk Malia ulo tonol keumeko, “Kuloki te!”, wangeko, alenale kale. Keko beli, alew bi kule kule kelinba ke alenaliw ding kabalak e, Sunbin-Finik em kitil e waneng buulo aul kumun keumse kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Keumei, Yosew e watemete: “Ai! U aul kumun kelu kai!”, angeko, koumomin ibolow kese kale. Koumomin ibolow kese kate, Yosew e kiol kuw kunum ke alenale kasike, e kawtiw im kiin dim e “Mesik u inkal keloku kai!”, angomelei, yawal keko, koumomin ibolow memen kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Keko beli, Kamok Fian em dabalakamin finik mak fiteweko, kiin dem sin bokolewomele: “Wee! Yosew, kamok fian Debit em angin kutaka! Ku kanelom finganemokolew te! Sunbin-Finik em kitil e Malia buulo aul kumun keumbe kasike, ku waneng buulo kame kulolewka! ");
INSERT INTO bhl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ku kilele kilila! Auk bu kunum aul mak dukuloku te. Dukului, beem wiin e ‘Yesus!’ dangolewka! Nimtew angom? E teleko, akalem angin im ibolow sili sili kukuw beem kuankemin deiw okileweko, finik so deiw mo koyemomin deiw kukuyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Feinka! Sunbin-Got em bontem dim bakamin kunum Aisaya em sua em bokose weng e kame dem gilako, fein ki keloke kasike. E bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Waneng seiw mak kunum so akalinba waneng mak aul kumun kesomi, aul dukuloku te. Dukului, kawtiw i aul beem wiin e ‘Emanuel’ dangokoliw te.’, yangse kale.”, angeko, Yosew elo dangse kale. ‘Emanuel’ beem mongom e kanekote: ‘Sunbin-Got nuso be te!’ ");
INSERT INTO bhl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Keko beli, Yosew e baba teineko, Kamok Fian em dabalakamin finik beem dange weng be fein geleweko, Malia ulo kuluse kale. ");
INSERT INTO bhl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kulusomelei, auk buum kumun kebu ding kabalak e, Yosew e uso kal bonggulinba kese kale. Kesomi, um aul dukusu ding kabalak e, e aul beem wiin e “Yesus” dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Beli, yemkal biim Sudia aneng fian em abiw mutuk fian Betelekem ka biliw ding kabalak e, Malia u Yesus elo dukusu kale. Beem ding dim kabalak e, Kelot e aneng fian beem emisik kamok fian kebele ete kale. Keko beli, ataan telbe dulum elote, kal kunum min mak teleko, Selusalem abiw mutuk fian kalo teleko, kawtiw mali ilo dakalalomeliw: ");
INSERT INTO bhl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Suda kawtiw im aul beliw kamok fian e nal kel be ye? Akalem ailbin ataan talbe dulum kel fitewei, nu atemeko, elo gelew teleko, akalem wiin fian daolew kem talbuluw te.”, angeko, dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Dakalaliwi, emisik kamok fian Kelot so, Selusalem abiw mutuk fian kasel iso, alik alik i biim dakalaliw weng be kiliko, yol yol angeko, ibolow fukunin tiaktiak kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Keliwi, emisik kamok fian be Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum iso, Sunbin-Got em am yol em kunum ayem sel eso, akalem angin iso, alik alik ilo gaayemei, i teliwi, e ilo dakalomele: “Mesaya beelo nal kel duku kembu a?”, yangeko, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dakalalei, isik yan weng bokolewomeliw: “Waneng mak Mesaya beelo Sudia aneng fian em Betelekem abiw mutuk fian ka kel duku kembu te. Nimtew angom? Sunbin-Got em bontem dim bakamin kunum Maika e fut mak boko, bokolomele: ");
INSERT INTO bhl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sudia aneng fian em Betelekem abiw mutuk fian kasel yu ibolow fukuniwete: ‘Ibo! Num abiw mutuk kale sak wiin banim kebe kai!’, angeko, bokoliw te. Kate babo! Yu kilele kililina! Yom abiw mutuk fian kel kunum kamok fian mak fitewsomelei, e Isalael kawtiw nulo fein yeteboke te.’, yangse kale.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dangiwi, emisik kamok Kelot be biim dangsiliw weng be kilisomi, yawal deiw kel kal kunum min biilo awkol kuw gaayemei, i teliwi, e ilo dakalalomele: “Nalem ding ete fial be ailei, yu elo atemsiliw a?”, yangeko, dakalase kale. Dakalalei, i yan weng bokolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bokolewiwi, e kitil weng mak bokoyemomele: “Yu kitil keko, ‘Aul be nal kel be ya?’, yangeko, elo fenoliwka! Fensomi, elo atemiw tewe, yu iti teleko, nelo bokonemoliwka! Bokonemiwi, nakati uneko, em wiin daolewoki te.”, yangeko, ilo Betelekem abiw mutuk fian kalo yemdase kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Yemdalei, i em bokoyemse weng be kiliko, fein unsiliw kale. Im unomin kesiliw ding kabalak e, fial fian be iti ailbelei, i elo atemeko, kalfong fian mak kesomi, fial beelo iti gelewsomi, “Fial be aul beliw beem am be dim moko, am gong dim fung ange be kai!”, angeko, atemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Atemsomi, am tem uneko, aul beliw so, auk Malia uso yat biliwi, yetemsiliw kale. Yetemeko, katin bukbuk angeko, aul beem wiin daolew kesomi, ikalem mesesem de talsiliw men be busuko, gol so, kual so, kamge so ais gom so, alik alik be matem dako, elo dulewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Keko beli, Sunbin-Got e ilo kiin dem dim kel bokoyemomele: “Yutaka! Yu kanelom iti emisik kamok fian Kelot em fukun unokoliw te!”, yangse kasike, i nanew deiw elote feneko, iti ikalem aneng elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Keko beli, Kamok Fian em dabalakamin finik mak fiteweko, Yosew elo kiin dem sin bokolewomele: “Ku aul beliw so auk so bi kuluko, Isiw aneng fian kalo fon unolewka! Ka kel nem ‘Kame yu iti kaleelo telina!’, kangoki weng fenolewka! Nimtew angom? Kelot e aul beliw beem alomin deiw feneme kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dangei, e fein aul beliw yat biilo kuluko, kutiliw kebele akate, fongate akate ilo Isiw aneng fian kalo yemde unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yemde unei, i ka kel Kamok Fian em weng kal ding fensiliw kale. Beem deiw e, i Sunbin-Got em bontem dim bakamin kunum mak em sua kel bokoyemse weng be ki kelewsiliw kale. E fut tem boko, bokolomele: “Nakalem aul elo Isiw aneng fian kalote gaaloki te.”, angse kale. Beli, i Isiw aneng fian ka kel bomeliwi, emisik kamok Kelot em “Kuanok!”, angomi, ding fensiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Beli, emisik kamok fian Kelot beem kuaninba bise ding dim kabalak e, e atemomete: “Kal kunum min bi dasuw kenemeko, telinba keliw kai!”, angomi, kaisuw fian kesomi, wonuk so kunum ilo bokoyemomele: “Yu uneko, Betelekem abiw mutuk fian beem kunum aul beliw so, abiw mutuk fian beem mewso biliw kunum aul beliw biso, aul biim itol e alew mak kelinba biliw kunum aul beliw alik alik ilo yeniwi, i kuanoliwka!”, yangse kale. Nimtew angom? E kal kunum min biim dangsiliw weng be ibolow fukunete: “Kanese ding kabalak e, fial be fitewe kai.”, dangiwi, e kilise kasike. ");
INSERT INTO bhl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kanele beem dulum elote sua kel akate, Sunbin-Got em bontem dim bakamin kunum Selemaya e weng mak bokosomelei, kame em ding dim e em bokose weng be dem gilako, fein ki kelewse kale. E fut tem boko, bokolomele: ");
INSERT INTO bhl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Alama aneng ka kel, kunum waneng i amemin fian mak kilisiliw te. Nimtew angom? Elesel um dow wanggel ikalem aul im delim amebiliwi, im ibolow menew so keyemomin deiw banim kese kasike. Feinka! Ikalem aul isik alik alik yeniwi, kuansiliw kasike.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Keko beli, Yosew em Isiw aneng fian ka kel alenale ding kabalak e, Kelot e kuanse kale. Kuanei, Kamok Fian em dabalakamin finik mak iti fiteweko, Yosew elo kiin dem sin weng mak bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Kame, aul beliw yat yemdeko, Isalael aneng fian kalo unolewka! Aul beem maka kelewbiliw kunum bikati kuansiliw kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dangeko, unei, Yosew e aul beliw yat kuluko, iti Isalael aneng fian kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Uneko, ka teleko, kililiwete: “Alkelaus e akalem alew Kelot em abin kuluko, kame emisik kamok fian keembe te.”, yangsiliw kale. Yangiwi, yelimel bi Sudia aneng fian elo unomin fingansiliw kale. Finganemiwi, Sunbin-Got e akalem dabalakamin finik mak dabalei, e Yosew em dim fiteweko, kiin dem sin “Ku kanelolewka!”, dange weng mak bokolewomele: “Yelimel yu Galili aneng fian kalo uneko, ka biliw etaka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Dangei, yelimel i fein uneko, Galili aneng em abiw mutuk fian Nasalet kalo uneko, ka kel alenaliw kale. Keko kasike, ibik ete, kunum waneng i Yesus elo atemeko, bokolewomeliw: “Ku Nasalet kayak kute te!”, dangenaliw kale. Beem dulum elote Sunbin-Got em bontem dim bakamin kunum im angsiliw weng bakati fein ki kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Beem ding kabalak e, ok da koyemkemin kunum Sion alenale kale. E Sudia aneng fian em kawtiw banim dim ka kel belei, em dim talsiliw kunum waneng ilo Sunbin-Got em kukuyemin weng bakayemkakamale kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","E bokoyemomele: “Yu ibolow sili sili kukuw koleweko, Sunbin-Got em kiin dim kiol kunum waneng kemoliwka! Nimtew angom? Abiil tikin em gawman ding dim e kame mewso kebe kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sion beem dulum elote Sunbin-Got em bontem dim bakamin kunum Aisaya e weng mak fut tem boko, bokose kale. Kame em angse weng be dem gilako, fein ki kese kale. E bokolomele: “Kawtiw banim dim elote kunum mak gaanin fian mak gaanko, bokolomele: ‘Kamok Fian em deiw memen kelewina! Akalem deiwkim aim tem be kilelina!’, yangse kale.”, angeko, fut tem bose kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Keko beli, Sion e kamel samal im kalim benesiliw ilim minggisomelei, samal kal yewet mak kuluko, akalem kakam falal kelewbomelei, sak kuieng so, mong tugul abal so, bete kuw wanenale kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Wanbomelei, Selusalem abiw mutuk fian kasel so, Sudia aneng fian kasel iso, Yoldan bang em mewso biliw kawtiw iso, kawtiw alik alik bi Sion elo atebam talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Telesomeliwi, ikalem ibolow sili sili matem kaim daliwi, Sion e ilo ok da koyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Beli, Falisi kawtiw so, Satyusi kawtiw iso, alik alik ikati “Sion e nulo ok da koyemoka!”, angomi, em fukun talsiliw kale. Teliwi, e ilo bokoyemomele: “Kimon so sokyan muluwel atew yutaka! Sunbin-Got e yulo kaisuw duyemei, yu ilum fian mak kulokoliw te! Kasike kame kante yulo kaneko weng be bokoyemomele: ‘Yom dim tolomin keme kaisuw beelo fon unomin deiw mak be kai!’, yangse a? ");
INSERT INTO bhl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yu yom sili sili kukuw be fein koleweko, ibolow famdeliw tewe, yu yukalem kikis ibolow em kukuw be mali ilo kukulew kukulew kemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kate, yu kanelom bokolomeliw: ‘Abalakam e nukalem awalik kumel im kunum mongom te!’, angbokoliw te! Yu nem weng kale kilele kilina! Sunbin-Got e ki keko, tum kale kulusomi, Abalakam em muluwel dow banban mak duku koyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Feinka! Sek atul nam mak e memen keko, ais mongom mit mobe te. Ais angom be dem gilalinba kele tewe, Sunbin-Got e ais be gu mit mit dako, kubul de uneko, ais daloke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yangesomelei, weng mak so bokoyemomele: “Fein! Yu yukalem ibolow famdeliwi, ne yulo sak ok kuw da koyemoki kate, nemteben mak kunum mak toloke te. Kunum be Kamok Fian kitil so kasike, nete ki keko, elo nam dokoleweko, em yan aum e nam delew uni te. Kamok beem toloke dim e, e yulo Sunbin-Finik so ais kainin atew so, ok atew da koyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Em teing dim e manggal eisneng atew mak aul teleko, wanin kal wolu kolew kemin dim beem wit wanin kubuleko, am dukuloke te. Kate, wit wanin em kal be kubuleko, ais sunsun kuaninbakabe ais kul tem kalo daloke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Keko beli, Yesus e Galili aneng kolewsomi, Yoldan bang kalo Sion elo “Ok da konemoka!”, angomi, elo dakalakam unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Dakalakam unse kate, Sion e elo ok da kolewomin ibolow kelinba kesomi, elo bokolewomele: “Ne kulo nam ok da kokemi te! Kute kuw nelo ok da konemew tewe, be ken te. Kate, Nimtew angom ete ku ‘Nelo ok da konemoka!’, nangom, telew a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dangei, Yesus e elo yan weng mak bokolewomele: “Babo! Ku nakalem kangi weng bete kuw kiliko, ok da konemolewka! Feinka! Nu Sunbin-Got em ‘Kanelina!’, yangbe weng be, kiol kuw gelewemoluwka!”, dangse kale. Dangei, Sion e em bokolewse weng be fein kiliko, elo ok da kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kolewei, Yesus em iti matem telse ding dim kabalak e, abiil tikin be busok angei, e atemete: Sunbin-Got em Sunbin-Finik e awon abim emdiw kawkaw mit elo teleko, Yesus em dim teinse kale. ");
INSERT INTO bhl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Teinei, abiil katiw elote weng mak bokolomele: “Aul be nem ibolow mutuk fian so dulewbi aul ete te! Ne beem dulum elote kalfongbi te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Beli, Sunbin-Finik e “Seten-Ataanim e Yesus elo kak kelewoka!”, angeko, Yesus elo kawtiw banim dim kalo dabele unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Uneko belei, e wanin kulinba kebelei, akalkafo akalkafo 40 kel ding kelei, e yemen tew teinse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Keko beli, Seten-Ataanim e elo kak kelewomin teleko, bokolewomele: “Kute Sunbin-Got em Min kelew tewe, tum kaleelo wanin keleweko, wana!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Dangei, Yesus e yan weng bokolewomele: “Sunbin-Got em fut tem e weng mak bokolomele: ‘Kunum waneng im sunsun finik so biliw ibolow fukunin e wanin kaleemdiw emisik bate! Nimin ete Sunbin-Got em finik so weng bete kuw kiliko, gelewiw tewe, bite kuw diwkuw finik so bókoliw te. ange eli!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dangei, Seten-Ataanim e Yesus elo Sunbin-Got akalem abiw mutuk fian kalo debeleko, Sunbin-Got em am yol am tikin dim mo koleweko, ");
INSERT INTO bhl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","bokolewomele: “Ku Sunbin-Got em Min tewe, kame yol mit una! Nimtew angom? Sunbin-Got em fut tem bokolomele: ‘Sunbin-Got e akalem yemdakamin finik ilo weng kitil mak bokoyemei, i teleko, kauleko, kilele kalgelmo kekemokoliw te. Kekemiwi, ku yol mit telew tewe, tum kang akal nam kene te.’, ange kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Dangei, Yesus e yan weng bokolewomele: “Sunbin-Got em fut tem akal bokolomele: ‘Yu kanelom yukalem Kamok Fian Sunbin-Got beelo sak kak kelewbokoliw te!’, ange eli!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Dangei, Seten-Ataanim e iti Yesus debeleko, amgu tikin tiakim dim mak mo koleweko, alik alik kunum mongom angom im aneng aneng angom beso, im on kisol so eisneng beso, alik alik eisneng be kukulewse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kukuleweko, bokolewomele: “Ku gatak wakas keko, nem wiin daonemew tewe, ne alik alik mesesem eisneng angom be fein kulo dukemoki te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dangei, Yesus e elo yan weng bokolewomele: “Seten-Ataanim ku asina! Sunbin-Got em fut tem e bokolomele: ‘Yu Kamok Fian Sunbin-Got beem wiin ete kuw daolewboliwka! Yu akalem wiin ete kuw dawsulboliwka!’, angse kale.”, angeko, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dangei, Seten-Ataanim e Yesus elo kolew unei, Sunbin-Got em yemdakamin finik i em mit mewso teleko, elo dokolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Beli, deiw mak ding mak, Yesus e kililete: “Wonuk so kunum i Sion elo sok am tem da kolewsiliw kai!”, angiwi, e kilisomi, Galili aneng fian em ");
INSERT INTO bhl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","abiw mutuk fian Nasalet kalo unse kale. Uneko, akalem tanbelse abiw mutuk fian Nasalet be iti kolewsomi, Galili okmun beem mit mewso kele abiw mutuk fian Kafelneam kalo uneko, ka kel alenale kale. Aneng be, Sebulun so Naftali so, kunum mongom alew biim aneng kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kanese beem dulum elote Sunbin-Got em bontem dim kunum Aisaya em sua kel bokose weng be fein dem gilase kale. E bokolomele: ");
INSERT INTO bhl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulun aneng kasel so, Naftali aneng kasel iso, Galili okmun beem dim biliw kawtiw iso, Yoldan bang beleng beem dim biliw kawtiw iso, Isalael kawtiw im ibik biliw Galili aneng kasel iso, alik alik kunum waneng yu kilele kililina! ");
INSERT INTO bhl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kunum waneng kutiliw dim kakabiliw kawtiw i ailbin fian mak atemokoliw te. Feinka! Kuanin atew keko, mililiw dim kakabiliw kawtiw im dim e dong fian mak ailoke te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Beem ding dim kabalak e, Yesus e Sunbin-Got em kukuyemin weng bokolomin kilse kale. E bokolomele: “Yu ibolow sili sili kukuw koleweko, Sunbin-Got em kiin dim kiol kunum waneng keboliwka! Nimtew angom? Abiil tikin em gawman ding dim e kame mewso kele kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yangeko, Yesus em Galili okmun falal kakabe ding dim kabalak e, e awkunum kumel takam takamin kunum alew mak yetemse kale. Kunum mak em wiin e Saimon Fita ete te. Akalem awkunum em wiin e Andulu ete te. I takam wakal men so takam takabiliwi, yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yetemomi, e aso ilo bokoyemomele: “Wee! Kaso yutaka! Kaso yu nelo nenggelew teliw kano, ne yulo kunum waneng kulamin kukuw kukuyemoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yangei, fein, aso i em bokoyemse weng be fein kiliko, fongate akate ikalem wakal men be welel koleweko, Yesus elo gelew unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Keko beli, Yesus so aso iso kakabomeliwi, e iti awkunum kumel alew mak yetemse kale. Aso biim wiin e Sekow so, Sion so te. I Sebidi em muluwel keko, ikalem alew so kunuw dim bomi, takam wakal men benebomi, alenaliw kale. Biliwi, Yesus e aso ilo gaayemei, aso i em bokoyemse weng be kiliko, ");
INSERT INTO bhl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kunuw dim ka biliw elote alew Sebidi so, kunuw so, alik alik be fongate akate koleweko, Yesus elo gelew unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Keko beli, Yesus so, akalem gelewkabiliw kunum iso, Galili aneng fian beem aneng aneng angom ka kakabiliw ding dim be, e Suda kawtiw im wensankabiliw am dim kel kukuyembomi, abiil tikin em gawman Weng Kal Ken Ati be bakayembomi, kal wanin auk so biliw kawtiw alik alik biilo kilelyembom, alenale kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bomelei, kunum waneng i em kanese kukuw be atemeko, Silia aneng fian em kasel ikati kanese sang be kilisiliw kasike, i wakamin kawtiw so, betbet fian kebiliw kawtiw so, aneng matil tom yebe kawtiw so, sak walwal kuw kilikili kebiliw kawtiw so, teing yout yan yout nam kawtiw so, alik alik kawtiw biilo yemde teliwi, Yesus e ilo kilelyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kilelyemei, kunum waneng banso banso Galili aneng fian so, Dekabolis aneng fian so, Selusalem abiw mutuk fian so, Sudia aneng fian so, Yoldan bang em ataan talbe dulum ka biliw kawtiw so, alik alik i ikalem abiw kolewsomi, Yesus elo geleweko, eso makuw unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Beli, Yesus e elo gelew talsiliw kawtiw banso banso bi yetemse ding dim kabalak e, e kawin muk kang dim kel teinse kale. Teinei, akalem gelewkabiliw kunum i em teine dim ka kel mewso teliwi, e ");
INSERT INTO bhl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ilo kukuyemin weng mak bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“‘Nu Sunbin-Got elo kilele kal kelinba kebuluw o!’, angeko, beem dim ibolow sakik so kebiliw kunum waneng yutaka! Yu kalfongeko, kakatemoliwka! Nimtew angom? Abiil tikin em gawman keloke ding dim e, yu ka kel bokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kal anggil ilum kulubiliw kunum waneng yutaka! Yu kalfongeko, kakatemoliwka! Nimtew angom? Sunbin-Got e yom ibolow ilum be atemeko, menew ibolow so keyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ibolow falit kekabiliw kunum waneng yutaka! Yu kalfongeko, kakatemoliwka! Nimtew angom? Sunbin-Got e yulo wiin fian mak duyemeko, yulo kawin kale fan atew duyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mali im sili sili kukuw atemsomeliwi, ‘Sunbin-Got kutaka! Ku sili sili kukuw be kilelyema o!’, dangeko, beem mongom ete ok tew yemen tew emdiw kebiliw kunum waneng yutaka! Yu kalfongeko, kakatemoliwka! Nimtew angom? Sunbin-Got e yom ibolow fukunbiliw be ki kemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mali kawtiw mak ilo kinkin ibolow so keyemeko, biim ibolow fukunkabiliw kunum waneng yutaka! Yu kalfongeko, kakatemoliwka! Nimtew angom? Sunbin-Got e yukati kinkin ibolow so keyemboke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Sunbin-Got em kiin dim e ibolow tokotoko ken so keko, biliw kawtiw yutaka! Yu kalfongeko, kakatemoliwka! Nimtew angom? Yu Sunbin-Got elo fein atemokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kasak sen dukukabiliw kunum waneng yutaka! Yu kalfongeko, kakatemoliwka! Nimtew angom? Sunbin-Got e ‘Yu nakalem muluwel te!’, yangoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Sunbin-Got em ibolow fukunin gelewbomi, beem dim e ilum kulukabiliw kunum waneng yutaka! Yu kalfongeko, kakatemoliwka! Nimtew angom? Abiil tikin em gawman keloke ding dim e, yu ka kel bokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Yu nelo “Fein!”, nangeko, nelo nenggelewiw kasike, beem mongom ete mali kawtiw i yulo desi keyemeko, funum weng bokoyemeko, yulo yeniw tewe, yu kalfongeko, kakatemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nimtew angom? Abiil tikin katiw kel yu yan fian mak kulokoliw kasike. Feinka! Yu kakateko, wimoliwka! Yu ibolow fukunina! Sua kel akate, nukalem awalik kumel i Sunbin-Got em bontem dim bakamin kunum ilo yulo kaneembiliw kukuw bakatetew keyemaliw kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yangeko, Yesus e iti weng mak bokoyemomele: “Yu yol em fakam weng kale kililina! Yu yol emdiw keko, kawin kaleem abal kebiliw kawtiw kebiliw te. Yol e abal nam eisneng kate, beem abal be banime tewe, yu nono keleweko, iti abal nam kelewokoliw a? Deiw mak banim te. Kaneko kasike, yu abal banim yol be kuluko, sak fomdoliwi, kawtiw i yan deit san anung anung kelewokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yu kawin dim kaleem ailbin atew keko, kawtiw im kiin dim kaim kuw biliw te. Beemdiw, amgu tikin kel alakabe abiw mutuk fian mak mali kunum waneng im kiin dim e nam okmole te. ");
INSERT INTO bhl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yu yongom dong mak aileko, mesesem eisneng so kasi kolewbiliw a? Babo! Yu elo abisom dim kel ail kolewbeliw kano, mali kawtiw i yongom dong be atemeko, fein am matem telemokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Be kaneko kasike, yom ailbin be aileko, kawtiw i yom ken kuw tokotoko kebiliw kukuw be atemeko, yom abiil tikin alakabe Kalew em wiin fian daolewokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yangeko, Yesus e weng mak so bokoyemomele: “Yu kanelom fukunomeliw: ‘Ne teleko, Moses em kukuyemse weng so, Sunbin-Got em bontem dim bakamin kunum im weng bakameliw weng so kulu koyemoki te!’, angeko, ibolow fukunokoliw te! Babo! Ne teleko, biim yangenaliw weng beem mongom be kilele ki kelomin teli te. ");
INSERT INTO bhl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Feinka! Deiw mak ding mak abiil kale so kawin kale so alik alik be banimoke kate, Sunbin-Got em weng beem anung fong gel so mak nam banime te. Em kukuyemse weng alik alik be atin kuw fein keloke te. ");
INSERT INTO bhl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kaneko kasike, nimin kunum waneng ite mak kukuyemse weng be atemeko, beem anung fong gel mak kolewsomi, mali kawtiw im kanekabiliw kukuw bakati kukuyemiw tewe, kanekabiliw kunum waneng bi abiil tikin em kaneloke ding dim kabalak e, wiin banim kawtiw kebokoliw te. Kate, nimin kunum waneng ite mak Sunbin-Got em kukuyemse weng be kiol kuw atemeko, gelewbomi, em kukuyemse weng alik alik be mali kawtiw ilo kilele kukuyemiw tewe, i abiil tikin em gawman ding dim kel e, wiin fian so kunum waneng kebokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yu kilele kililina! Yom ibolow be Sunbin-Got em kiin dim e kiol kuw kesomi, Falisi so, akalem kukuyemin weng kalem aulewko, kukuyemkabiliw kunum biso, alik alik biim ibolow fukunbiliw be bakilewinba keliw tewe, yu abiil tikin em gawman ding dim kalo nam uniw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yangeko, Yesus e iti weng mak bokoyemomele: “Yu yukalem kawalik kumel im bokoyemsiliw weng be kilisiliw te. Im weng be kanekote: ‘Yu kanelom mali kawtiw ilo yeniwi, i kuanokoliw te!’, yangeko, iti bokoyemomeliw: ‘Nimin kawtiw ite mak mali ilo yeniwi, i kuaniw tewe, yu yeniw kawtiw biilo geeyembin dim elo mo koyemeko, geeyemboliwka!’, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yangsiliw kate, nakati yulo bokoyemomeli: Nimin kawtiw ite mak ikalem akunum elo ibolow kaisuw kelewiw tewe, mali kawtiw mak teleko, kaneliw kawtiw biilo kawtiw diwyemin kunum em kiin dim kel mo koyemiwi, e ilo geeyemoke te. Keko beli, nimin kawtiw ite mak ikalem akunum elo ‘Ku ibolow goluw kunum kute te!’, dangiw tewe, mali kawtiw mak teleko, dangiw kawtiw biilo Isalael kawtiw num kak yetebiliw diwyemin kunum biim kiin dim mo koyemsomeliwi, i ilo geeyemboliwka! Keko beli, nimin kawtiw ite mak ikalem akunum elo ‘Ku wiin banim, baluw kunum kute te!’, dangiw tewe, kaneko, dangiw kawtiw bikati kilelbi boliwka! Mesik esik Sunbin-Got e kawtiw biilo geeyemeko, kuse weing dong tem da koyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yu mesesem mak de teleko, ‘Sunbin-Got elo dulewoki te!’, angeko, em am yol am abisom teleko, ibolow fukuniwete: ‘Ibo! Nakalem nakunum so ilum so kebi kai!’, angiw tewe, ");
INSERT INTO bhl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yu mesesem de unbiliw be ka kel sak dukusomi, kakunum beso ilum be kilelsomi, ken kuw boliwka! Bomeliwi, iti mesesem be de teleko, Sunbin-Got elo fein dukalewboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mak kunum mak kulo geekemeko, diwyemin kunum em kiin dim kamde une tewe, kaso makuw unbiliw ding dim bakate, ku ilum eisneng be kiol kuw kelewbolewka! Mesik esik ilum so kunum be kulo diwyemin kunum em teing dim da kokemei, e kulo wonuk so kunum im teing dim da kokemei, isik kulo kamdeko, sok am tem da kokemokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yu kililina! Ku sok am tem ka kel bomi, tum win on kisol fian alik alik be ki wenolewka! Atin kuw wenokolew ding dim ete kuw, ku iti sok am tem be kolewko, kut tolokolew kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yangeko, iti weng mak bokoyemomele: “Sua kel akate yu kilisiliw bakate: ‘Wee! Yu kanelom osow kemokoliw te!’, yangsiliw kate, ");
INSERT INTO bhl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","nakati iti yulo bokoyemomeli: Nimin kunum ite mak waneng mak ulo watemeko, ibolow fukunom ete: ‘Ne uso kanenemoka!’, angeko, ibolow kuw fukuniw tewe, im kanebiliw ibolow fukunin be fein osow kekabe te. ");
INSERT INTO bhl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yu kilele ibolow fukunina! Kom kiin mali e kulo kamdeko, ‘Ku kukuw sili sili wa mak kema!’, kangeko, kamde uneme tewe, ku kiin mali be walu fomdo kololewka! Ku kiin mali waluko, kolew tewe, e ki keko, sili sili kukuw beem dulum elo nam kamde unoke kasike, i kom kal alik alik bakal nam weng dong tem da kokemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kom teing yuk e kulo kamdeko, ‘Kukuw sili sili wa kema!’, kangeko, kamde uneme tewe, ku yuk teing be gato fomdo kololewka! Ku yuk teing gato kolew tewe, e ki keko, sili sili kukuw beem dulum elo nam kamde unoke kasike, i kom kal alik alik bakal nam weng dong tem da kokemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Sua kel akate, kawalik kumel i weng bokoyemiwi, yu kilisiliw bakate: ‘Nimin kunum ite mak ikalem kalel kumel ilo koyemomin ibolow keliw tewe, i ilo koyemkemin fut anung mak bosomi, ilo dukayemboliwka!’, yangenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yangenaliw kate, nakati yulo weng mak bokoyemomeli: Nimin kunum ite mak ikalem kukuw kiol so, osow kelinba kalel kumel biilo koyemiw tewe, i sili sili nam kukuw kelokoliw te. Nimtew angom? Ikalem sen beem mongom ete i kalel kumel biilo kulu fakalan waneng keyemiwi, i nanew kunum kumel mak kuliw tewe, i osow nam waneng kelokoliw kasike. Beemdiw, iti kulokoliw kunum bikati osow kunum kelokoliw te. Nimtew angom? Isik akunum kumel biim kalel kulokoliw kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yangeko, weng makso bokoyemomele: “Yom kawalik kumel i weng kitil weng mak dukuko, bokoyemomeliw: ‘Yu kililoliwka! Kamok Fian em kiin dim e fawtuk ayem weng mak bokoliw tewe, yom yangiw fawtuk ayem weng be fein dem gilaloka!’, yangenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yangenaliw kate kame, nakati iti yulo bokoyemomeli: Yu kanelom fawtuk ayem weng mak kemokoliw te! Yu kanelom abiil tikin em akalem wiin so amkose eisneng beem dulum elote ayem fawtuk weng mak kemokoliw te! Nimtew angom? Abiil tikin be Sunbin-Got em teinbin abin dim kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Beemdiw, kawin dim kale Sunbin-Got em yan dukube dim kelei, Selusalem abiw mutuk fian be akalem abiw mutuk fian kebe kasike, yu aneng alew beem akalem wiin so amkose eisneng beem dulum elote kanelom fawtuk ayem weng mak kemokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Beemdiw, yu kanelom yukalem kal anggil dim beem dulum elote fawtuk ayem weng mak kemokoliw te! Nimtew angom? Yom kitil e fong gel kuw kelei, yukalem ete ki keko, kak kon gel makmak nam famdes kelewsomi, ‘Kak kon yemul keloka! Mikil keloka!’, angbiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kate, yu ‘Bayo!’, ‘Fein o!’, bete kuw angboliwka! Weng dawtolo niska nelka kelewbiw tewe, yu Seten-Ataanim em ibolow dasuw fukunin ete kuw gelewbiliw kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yangeko, iti weng makso bokoyemomele: “Yom kawalik kumel i weng kitil weng mak dukuko, bokoyemomeliw: ‘Nimin kunum waneng ite mak mali akunum kumel biim kiin elo bakung kemiw tewe, i biim kiin bikati fakaluyem kemoliwka!’, yangeko, iti bokolomeliw: ‘Nimin kunum waneng ite mak mali akunum kumel biim ning kun elo kang dukong kemiw tewe, i biim ning kun bikati kang dukong kemoliwka!’, yangenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yangenaliw kate, nakati kame yulo bokoyemite: Nimin kunum waneng ite mak yulo wa kukuw keyemiw tewe, yu ibolow falit angeko, menew kukuw kuw kukuyemboliwka! Kukuyembomeliwi, nimin kunum waneng ite mak yulo kuleng mali elo baka yeniw tewe, yu famdes angeko, yukalem kuleng mali bakati fubelet kaleyemboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Keko, mali kawtiw i yulo diwyemin kunum im mit mewso yemdeko, bokoyemomeliw: ‘Asolow ilim guloko, nulo duyemina!’, yangiw tewe, yu ilim be gulok keleweko, ilim makso mak akati dukayemboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Beli, kunum mali mak imel kuw keyemeko, bokoyemomeliw: ‘Yu nukalem men ilum kale kiwyemeko, deiw mutuk mak koyemoliwka!’, yangiw tewe, yu biim yangbiliw weng be bakileweko, ilo singam singam aneng kalo koyem kemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mali kawtiw mak yulo bokoyemomeliw: ‘Yom mesesem mesesem be nulo duyema!’, yangiw tewe, yu mesesem eisneng be kawtiw biilo sak misim kuw dukayemboliwka! Dukayemiwi, mali i yulo dakalalomeliw: ‘Tum win mak duyemina!’, yangiw tewe, yu kalfongeko, ilo sak misim kuw dukayemboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yom kawalik kumel i weng mak dukuko, bokoyemomeliw: ‘Yukalem kawkunum kumel ilo ibolow mutuk fian dukayemboliwka! Dukayemiw kate, yukalem maka keyembiliw kawtiw ilo ibolow kaim alel kuw yetebamoliwka!’, yangenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yangenaliw kate, nakati yulo bokoyemomeli: Yom maka keyembiliw kawtiw bikati ibolow mutuk fian keyemboliwka! Keyemeko, mali kawtiw mak yulo ilum fian mak dukayembiw tewe, yu Sunbin-Got elo dakalalomeliw: ‘Ku ilo kinkin ibolow keyemeko, ken kukuw kuw kukuyema!’, dangboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Dangbiw tewe, yu abiil tikin alakabe Kalew beem fein muluwel kebokoliw te. Nimtew angom? E ataan so suuk so be sili sili nam kawtiw so, kiol kuw kukuw gelewkabiliw kunum waneng iso, alik alik biim biliw dim akati makuw dukayembe kasike. ");
INSERT INTO bhl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yu kililina! On kisol fokoyemeko, deimaliw kunum wa kukuw so kunum bikati mali kawtiw ilo ibolow mutuk fian duyemkabiliw kawtiw biilo ibolow mutuk fian dukayemkabiliw te. Be fian eisneng ba kasike, Sunbin-Got e beem mongom ete yan fian mak akati duyeminba keloke te. ");
INSERT INTO bhl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Beemdiw, Isalael kawtiw im ibik biliw kawtiw bikati ikalem awkunum kumel ilo yetemeko, ‘Nakunum a! Belew yako!’, yangbiliw te. Fein, be fian eisneng bate! ");
INSERT INTO bhl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kate, yukalem ete diwkuw diwkuw abiil tikin alakabe Kalew beem ken atin kiol kuw kukuw emdiw kemoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yangeko, Yesus e iti weng mak bokoyemomele: “Mali yu ibolow fukuniwete: ‘Nu kunum waneng im kiin dim e kukuw ken so kunum waneng kebuluw kasike, i nulo yetemeko, nulo yamsulbomi, num wiin kuw daoyemboliwka!’, angbiliw kate, yu kilelbi boliwka! Yu beemdiw angbiw tewe, yom abiil tikin katem alakabe Kalew be iti yan ken makso mak nam duyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yu ibolow fukuneko, mesesem eisneng sukum kebiliw kawtiw ilo ‘Mesesem mak duyemum o!’, angiw tewe, yu kanelom kawtiw alik alik im kiin dim kel mesesem mak dukayembokoliw te! Kate, yu awkol awkol okiw dako, tal kel dukayemboliwka! Nimtew angom? Fimdi famde kekabiliw kawtiw ite kuw kawtiw im wensankabiliw am dim so, deiwkim mutuk kel so, ka kel mali ilo dukuyemeko, ibolow fukunomeliw: ‘Kame mesesem eisneng mak dukayemuw tewe, alik alik i num kanekabuluw be atemeko, num wiin daoyem kemoliwka!’, angbiliw kawtiw ite te. Kate, yu kililina! Fimdi famde kawtiw bi ikalem yan kulusiliw kasike, Sunbin-Got e ilo yan mak so nam duyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yu ibolow fukuneko, mesesem eisneng mak sukum kebiliw kawtiw ilo yemeniw tewe, yu awkol teing tem okiw dako, ilo dukayemboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dukayemiwi, yom abiil tikin katem alakabe Kalew bete kuw yom ibolow folok kukuw be atemeko, fein kal kebe kasike, e yulo akati ibolow folok keyemeko, yan ken mak duyemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yangeko, Yesus e iti weng mak bokoyemomele: “Yom Sunbin-Got eso weng bakameliw ding dim e, yu kanelom fimdi famde kemin kukuw gelewbokoliw te! Fimdi famde kawtiw i kunum waneng im wensankabiliw am dim so, deiw gen gen dim so, ka kel moko, kunum waneng alik alik im kiin dim e Sunbin-Got eso weng bakabiliw kaiske, kawtiw bi kanekabiliw kawtiw biim wiin daokabiliw kasike. Kate, yu kililina! Fimdi famde kawtiw bi ikalem yan kulusiliw kasike, Sunbin-Got e ilo yan mak so nam duyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kaneko kasike, yu ibolow fukuneko, ‘Sunbin-Got eso weng bokoluma!’, angiw tewe, yu uneko, kawtiw banim dim kel yomikel kuw kesomi, abiil tikin alakabe yukalem kiin so nam atemiw Kalew eso weng bakamoliwka! Kaneliw tewe, okmobe eisneng alik kilele kal kebe Kalew be yom dakalakabiliw beem yan e fein dukayemboke te. ");
INSERT INTO bhl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yukalem Sunbin-Got eso weng bakabiliw ding dim e, yu kanelom sak weng tiaktiak bingbom bakamokoliw te! Nimtew angom? Sunbin-Got elo kal kelinba kawtiw ite kuw weng tiaktiak bakabiliw kasike. I fukunomeliw: ‘Nu weng tiaktiak bingom bakaluw tewe, e nulo kiliyemoke sako!’, angenkabiliw kate, ");
INSERT INTO bhl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","yukati kanelom im kukuw be gelewemokoliw te! Nimtew angom? Yom sukum kebiliw beem dulum elote elo dakalalinba kebiliw ding dim kabalak e, esik yom sukum biliw eisneng be kilele kal kebe kasike. ");
INSERT INTO bhl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Feinka! Yu Sunbin-Got eso weng kaleemdiw bokolewomeliw: ‘Aatim a! Ku abiil tikin katem belew te. Kunum waneng alik alik i kom wiin ete kuw wangweng wiin kelewboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kom gawman ding dim be fongate akate kaim dim fitewoke te! Abiil katiw im alakabiliw imdiw kawin dim kale buluw kawtiw nukati kom afak kel kebomi, kom ibolow fukunin ete kuw gelewbuluwka! ");
INSERT INTO bhl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kaleem ding kale, num ki keyemoke wanin nulo dukayembolewka! ");
INSERT INTO bhl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Num mali kawtiw im nulo sili sili keyemsiliw kukuw be sak misim kuw kulu koyemkabuluw atew kusik num sili sili ibolow akati sak misim kuw kulu koyem kemolewka! ");
INSERT INTO bhl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ku kanelom nulo kak koyemomin em deiw kalo mo koyemokolew te! Kate, Seten-Ataanim em nulo kak keyemoke ding dim kabalak e, ku nulo dokoyem kemolewka!’, dangeko, eso weng bakamoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yu kililina! Yusik mali kawtiw im yulo sili sili kukuw keyemsiliw kukuw be sak misim kuw kulu koyemiw tewe, yom abiil katem alakabe Kalew akati yom sili sili ibolow be sak misim kuw kulu koyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Koyemoke kate, yu mali kawtiw im sili sili kukuyemsiliw kukuw be sak misim kuw kulu koyeminba keliw tewe, yom Kalew akati yom sili sili ibolow be nam sak misim kuw kulu koyemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yangeko, Yesus e iti weng mak bokoyemomele: “Nimin kunum waneng ite mak ibolow fukuneko, ‘Sunbin-Got eso weng bakam unumo!’, angiw tewe, i kanelom fimdi famde kawtiw imdiw kemokoliw te! Nimtew angom? I wanin tokoko, kiinguen amu angeko, bokolomeliw: ‘Kiw tabil mutum fasu keluw tewe, mali kawtiw i nulo yetemeko, kal keliwete: ‘Kiol kunum kai!’, yangboliwka!’, angbomi, kanekabiliw kasike. Kate yu kilele kililina! Fimdi famde kawtiw bi ikalem yan kulusiliw kasike, Sunbin-Got e ilo yan mak so nam duyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kasike, nimin kunum waneng ite mak ibolow fukuneko, ‘Sunbin-Got eso Weng bakamumo!’, angeko, wanin tokoko, koliw tewe, mali kunum waneng bi kiinguen katket filat angeko, kak kon fiteloliwka! ");
INSERT INTO bhl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Keko beli, mali kawtiw i yom wanin tokoko, Sunbin-Got eso weng bokoliw kukuw be kal kelinba kelokoliw te. Kate, yukalem okmobin dim alakabe Kalew be yom okiw dako, kanelokoliw kukuw be kilele kal kebe kasike, e yulo kanelokoliw beem yan ken be fein duyemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yangeko, Yesus e iti bokoyemomele: “Yu kanelom kawin kaleem on kisol eisneng kubul aluw kemokoliw te! Nimtew angom? Yu kaneliw tewe, kawin dim kaleem yakut kunum i yom am dakalko, on kisol ken beem anung mak kuluyemiwi, mali beem anung be musmus kubuli, mali e sisil kow tabilei, alik banimokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kate abiil tikin em ken kuw sunsun boke on kisol be nam kiloneko, sisil kow kubulei, banime kasike, yu abiil tikin beem on kisol be dubuluw memen keko, bonggu duku kemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yu kilele kililina! Yukalem dukubiliw on kisol be katiw kel be tewe, yukalem ibolow fukunin akati katiw elo kuw fewtokoko, boke te. Kate, yukalem on kisol be kawin dim kale kel be tewe, yukalem ibolow fukunin akati kawin dim kale kuw fewtokoko, boke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yangeko, Yesus e bisil ibolow em fakam weng mak bokoyemomele: “Ibolow mutuk em kiin e yongom dong emdiw aileko, be tewe, kal so dem so alik alik bakati ken kuw boke te. ");
INSERT INTO bhl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kate, kiin e ailinba kebomi, wa keko, mililiw kuw ange tewe, kal so dem so bakati mililiw mutuk keko, wa keboke te. Yu kililina! Yom ibolow mutuk beem ailbin e mililiw kuw kele tewe, yom ibolow mutuk beem mililiw be atin kuw mililiw kuw keloke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yangeko, bokoyemomele: “Yu kilele ibolow fukunina! Sak weng afak kunum waneng i kamok alew keko, alew biim sak aulyembamin kunum keyembokoliw a? Babo! Nimtew angom? I kak kunum alew im afak keliw tewe, i mak kamok beelo ibolow kelinba keleweko, em weng sakalaw keko, weng bo bo kelokoliw kate, mali kamok beelo ibolow fian keleweko, akalem weng ete kuw gelewemokoliw kasike. Yu kanelom ki keko, Sunbin-Got so on kisol em mamow so aso makuw biim sak weng afak kunum waneng keyemokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yu kilele kililina! Yu kanelom kal dim em wanbin eisneng so, ilim minggilomin eisneng so, mesesem eisneng beem dulum elote ibolow tiaktiak kemokoliw te! Nimtew angom? Wanbin eisneng so, minggilomin eisneng beso, kal dim em mesesem be finik so bin em afak kuw kebe kasike. ");
INSERT INTO bhl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yu awon im kukuw be diw atemoliwka! I wanin musun kailinba kesomi, wanin kulu duku kemin am bakal gelinba kekabiliw kate, yom abiil tikin alakabe Kalew be bikati wanin yemenkabe te. Yu kilele ibolow fukunemoliwka! Kalew beem kiin dim e kunum waneng yom yan e awon im yan e bakilewkabe kasike. ");
INSERT INTO bhl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Feinka! Yom ibolow fukunin tiaktiak beem mongom ete yu ki keko, yukalem kawin dim kale kakabiliw ding beem dulum elote fong gel ding makso mak nam duliw te. ");
INSERT INTO bhl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nimtew angom ete yu kal dim em minggimin eisneng beelo ibolow fukunin tiaktiak kekabiliw a? Yu kut em ais bokbok weit atite ati atemeko, ibolow fukunemoliwka! I bukeko, sok wilinba kekabiliw kate, ");
INSERT INTO bhl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","yu nem weng kale kiliko, kal keloliwka! Kalew em ais bokbok biilo duyemse kait be emisk kamok fian Solomon em kait atite be atin kuw bakilewkabe te. ");
INSERT INTO bhl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Fein ibolow fong gel so kunum waneng yu sang gel kale diw atebamoliwka! Sunbin-Got e sukum ding kuw alakabe musun beem balasal be kait ken so minggikabe kate, kawtiw i balasal be sak goto kelewko, ais dakabiliw te. Feinka! Sunbin-Got e balasal beelo kilele atebe kasike, e kunum waneng yulo atin kuw fein kuw yetemoke te! ");
INSERT INTO bhl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Keko kasike, yu kanelom bokolomeliw: ‘Ibo! Num wanin e nu nal kel kulamokoluw a? Ok e, nu nal kel kuluko, wanbokoluw a? Kal musun beem ilim e nal kel de telesomi, num kal kasi kolew kemokoluw a?’, angeko, sakik kemokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nimtew angom? Kawin dim kaleem kunum waneng i beem eisneng elo ibolow tiaktiak kekabiliw kate, yom abiil tikin alakabe Kalew be yom sukumeko, kulomin ibolow eisneng beelo kilele kal kekabe kasike. ");
INSERT INTO bhl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yu kitil keko, abiil tikin em gawman ding dim em mesesem eisneng beelo fenbomi, akalem ibolow fukunin kiol kuw bete kuw gelewbiliw tewe, e kawin dim kaleem sukum kebiliw eisneng be yulo akati sak misim kuw dukayemboke te. ");
INSERT INTO bhl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dukayemboke kasike, yu kanelom sow kutim em mesesem eisneng beem ibolow elo ibolow fukunin tiaktiak kemokoliw te! Babo! Kate mak ding mak em sakik ilum be bakalem ding kuw kasike, yu kanelom sow kutim em kulomin em sakik beelo kame ibolow tiaktiak kemokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yangeko, Yesus e iti weng mak bokoyemomele: “Yu kanelom mali kawtiw ilo geeyembokoliw te! Yu ilo geeyembiw tewe, Sunbin-Got e yukati geeyemboke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yu kilele kililina! Sunbin-Got e yulo yukalem mali kawtiw ilo geeyembiliw kukuw beemdiw bakati geeyemboke kasike. Yu nomin sawa weng mak kuluko, kitil kuw kebomi, mali kawtiw ilo geeyemiw tewe, Sunbin-Got akati sawa weng be kuluko, kitil kebomi, yulo bakalem ki akate geeyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yutaka! Kukun atew mak yom kawkunum kusel im kiin be net keyembe tewe, yu kukun be fein atebiliw kate, yukalem kiin dim em am mili sel atew eisneng kiin kasi koyemkabe be yu ibolow fukuninba kebiliw a? ");
INSERT INTO bhl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Fimdi famde kawtiw yutaka! Yu yom kawkunum kumel biilo bokoyemomeliw: ‘Nakunum kumel yutaka! Nu yom kiin net kasiyembe ais kukun be kulu kolewokoluw te!’, yangbiliw kate, am mili eisneng atew yukalem kiin kasi koyembe be yu nam atemiw te! ");
INSERT INTO bhl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Feinka! Emisik e, yu yukalem kiin dim em am mili be kulu kolewsomi, iti kiin ken boliwka! Beemteben e, yu uneko, yom kawkunum kumel biim ais kukun bakati kulu koyemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yu kilelbi boliw te! Mesesem eisneng mak Sunbin-Got e akalem wiin so amkose eisneng mak yu kanelom wiin banim atew keleweko, kut mian atul nam ilo dukalewbokoliw te! Mesik isik i famdes teleko, yulo yen wanokoliw kasike. Beemdiw, yu kanelom bonang on kisol mak kaing biim biliw dim elo duyemoliwka! Kaneliw tewe, i sak deit san san keleweko, kawtol kawtol kelokoliw kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yangeko, Yesus e iti weng mak bokoyemomele: “Yu mesesem mesesem eisneng mak Sunbin-Got elo dakalaliw tewe, e fein kiliko, yulo dukayemboke te. Beemdiw, yu mesesem mesesem eisneng mak fenemiw tewe, yu mesesem be fein atebamokoliw te. Yu abisom dim kel gogo keemiw tewe, Sunbin-Got e am yal be busuyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nimtew angom? Mali kawtiw mak mesesem mesesem eisneng mak Sunbin-Got elo dakalaliw tewe, e ilo fein dukayemboke kasike. Beemdiw, mali kawtiw mak mesesem mak fenemiw tewe, i mesesem be fein atemokoliw te. Iti beemdiw, mali kawtiw mak abisom dim gogo keemiw tewe, Sunbin-Got e am yal be fein busuyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Auk so alew so yutaka! Yom muluwel i yulo bokoyemomeliw: ‘Yemen mak duyemew kano, nu wanuma!’, yangeko, yulo dakalaliw tewe, yu ilo nam tum mak duyemeko, ‘Wanina!’ yangbokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Beemdiw, yom muluwel i yulo bokoyemomeliw: ‘Takam mak duyemew kano, nu wanuma!’, angeko, dakalaliw tewe, yu ilo nam ambew mak duyemeko, ‘Wanina!’, yangbokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Auk kumel aliwol yu sili sili nam kawtiw kate, yu yom muluwel ilo ken eisneng duyemkabiliw kasike, yukal kilele kal kemoliwka! Yom abiil tikin alakabe sen banim so Kalew be kalfongsomi, yulo ken eisneng fein dukayemkabe te. ");
INSERT INTO bhl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yu kililina! Yu ibolow tem kel fukunomeliw: ‘Kawtiw i nulo kukuw ken kuw kukuyemoliwka!’, angbiliw kasike, yukati mali ilo yukalem ibolow fukunin bakatetew keyemboliwka! Kaneliw tewe, yu Moses em kukuyemin weng beem mongom so, Sunbin-Got em bontem dim bakamin kunum biim yangsiliw weng beem mongom so, alik alik be ki kelewokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yangeko, Yesus e iti fakam weng mak bokoyemomele: “Yu abisom fong gel beem kawtem unomin bukeko, gulas matem unoliwka! Kate, kawtiw banso i abisom fian kawtem uneko, weing dong tem unekabiliw deiw fian sel beelo gelewkabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Gelewkabiliw kate, finik so bin deiw so finik so bin em abisom so be atin fong gel kuw kasike, kunum waneng banban i abisom so deiw so be ateminba kekabiliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yangeko, Yesus e iti fakam weng mak bokoyemomele: “Yu dasuw selew selew kunum im funum funum keyembiliw kukuw be kilelbiko, boliwka! I kom mit teleko, kal dim kel ken kuw kelokoliw kate, biim ibolow mutuk kawyak e, i kut mian atul nam atew kesomi, yulo yen wanokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kate yu biim kukuw be kilele diw atebamoliwka! Beem dulum elote, yu fakam weng be ibolow fukunina! Ais daon e nam ki keko, seil gilaloke te. Beemdiw, ais be nam ki keko, sum gilaloke te. ");
INSERT INTO bhl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Yu kililina! Ais ken mak dem ken kuw gilaloke kate, e ki keko, wa dem mak nam gilaloke te. Beemdiw, wa ais mak dem wa kuw gilaloke kate, e ki keko, dem ken kuw nam gilaloke ");
INSERT INTO bhl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","kasike, kawtiw i dem ken gilalinbakabe ais beelo sek so okileweko, ful ais dalokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Feinka! Yu kawtiw im kanekabiliw kukuw beem dem e diw atemeko, kal kesomi, bokolomeliw: ‘Kawtiw biim dem e wa kasike, i dasuw funum kawtiw kuw ite te!’, angokoliw te. Angeko, mali kunum waneng im dem bakati diw atemeko, ‘Ite fein kunum waneng kebiliw te!’, angeko, kal kelokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yu kilelbiko, boliwka! Mali kawtiw i nelo ‘Kamok Fian o! Kamok Fian o!’, nangbiliw kate, i abiil katem alakabe Aatim beem ibolow fukunin gelewinba keliw tewe, i abiil tikin em gawman ding keloke dim em wati tak nam uneko, ka biw te. ");
INSERT INTO bhl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Feinka! Sunbin-Got em kunum waneng alik alik ilo diweko geeyemoke ding dim e, mali kawtiw banban i nelo bokonemomeliw: ‘Kamok Fian a! Kamok Fian a! Kom wiin dim ete nu oktakak kunum keko, aneng matil anbakalako, kitil eisneng fian mak aluwkabuluw kasike, ku nulo kom ken abiw dim beelo yemde unolewka!’, nangokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nangokoliw kate, beem ding dim bakate, ne yan weng mak kaim filel bokoyemomeli: ‘Ne yulo itel gel so mak akokow te. Yu atin kuw ibolow sili sili nam min kasike, fongate akate nem mit kale asinina!’, yangoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yangesomelei, Yesus e iti fakam weng mak bokoyemomele: “Nem weng be kiliko, fein gelewbiliw kawtiw i kaneko kawtiw ite te? I kunum ibolow fukunin ken so kunum bakatetew kebiliw te. Kunum be ilkul mak kuluko, kawin dim moko, am kun kitil nam kawin mutuk diw kabalak elo mose te. ");
INSERT INTO bhl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mose kasike, suuk inim fian so ok so dakiko, toloke kate, am be nam fokfok angoke te. Nimew angom? Kunum be am be am kun kitil nam so kawin diw kabalak elo moko, gese kasike. ");
INSERT INTO bhl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kate, nem bokoyemsi weng be kililiw kate, kilele gelewinba kebiliw kawtiw i ibolow fukunin banim kunum bakatetew kebiliw te. Kunum be ok ais am kun kuw kuluko, kawin tikin kayak kuw moko, am gese te. ");
INSERT INTO bhl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Gese kasike, suuk inim fian tele ding dim e, am be duneng duneng keko, atin kuw fokfok mit daloke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yangei, ka biliw kunum waneng banban bi Yesus em kukuyemse weng be kiliko, yol angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nimtew angom? Em bokoyemse weng be Sunbin-Got em kukuyemin weng kalem aulewko, kukyemkabiliw kunum im weng emdiw ba kate, “Yesus em weng be auk so weng kele kai!”, angsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Beli, Yesus em kawin muk kang tikin be iti malak talse ding kabalak e, kunum waneng banban bi elo gelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Keko beli, bulul abung fian so kunum mak teleko, Yesus em mit mewso katin bukbuk teinsomelei, elo bokolewomele: “Kamok Fian kutaka! Ku auk so kunum kasike, ku kukalem ibolow kuw gelewewko, nelo ken kenemsomi, nelo Sunbin-Got em kiin dim e kais ati kuw kenemolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dangei, Yesus e akalem teing deeko, kunum beem kal dim dukuko, bokolewomele: “Dokokemoki te! Kame kais ati kuw kela!”, dangei, fein, fongate kuw abung bulul fian kunum beem kal dim be atin kuw okmino kolei, banimse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Keko beli, Yesus e beelo kitil weng mak bokolewomele: “Ku kanelom nem kanekemi sang be mali kawtiw ilo bokoyemokolew te! Komikel kuw Sunbin-Got em am yol kunum ayem beem afak kunum biim mit mewso uneko, kom iti kais kese kal be ilo kukuyemolewka! Kukuyemsomelewi, ku Moses em iti kal kais kemin em kukuyemse weng be gelewolewka! Kanelew tewe, i nem kal kais kekemse kitil be kilele atemsomeliwi, nem kitil fian be kilele kal kelokoliw kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dangeko, em Kafelneam abiw mutuk fian kalo unse ding dim kabalak e, Ulom abiw mutuk fian em wonuk so kunum im kak kunum mak Yesus em mit mewso teleko, kitil kesomi, elo bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Kamok Fian kutaka! Nem weng afak kunum mak e wakamin fian so, betbet fian so mak kuluko, yout nam kebomi, am kel kuw akalbe te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Dangei, Yesus e yan weng bokolewomele: “Ne teleko, elo kilelewii, e kenoke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Dangei, e yan weng bokolewomele: “Kunum kamok fian kutaka! Ne kawin kaleem kukuw wa so kunum nete kuw te. Nimtew angom ete ku ‘Kom am toloki te!’, nangbelew a? Kanemok! Ku nem am nam telew te. Ku weng kuw bokolew kano, nem weng afak kunum beem wakamin be sak ken keloke te. ");
INSERT INTO bhl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Feinka! Nem kak kunum mak nelo kitil weng mak bokoneme tewe, ne em nange weng be fein kiliko, gelewoki te. Beemdiw, nem afak biliw wonuk so kunum ikati nem kitil weng kiliko, geleweko, nem afak kuw kekabiliw te. Kasike, ne wonuk so kunum mak ilo bokoyemomeli: ‘Yu yuk teing dulum mani awan teing dulum elo unina!’, yangi tewe, i nem yangbi weng be fein kiliko, kalo unokoliw te. Iti nem weng afak kunum mak elo bokolewomeli: ‘Ku teleko, nem aluwbamin mak aluwa!’, dangi tewe, e nem weng be fein kiliko, aluwboke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Dangei, Yesus e em weng be kiliko, yol angeko, eso kakabiliw kunum waneng banso biilo bokoyemomele: “Feinka! Isalael kawtiw kunum waneng yom mutuk kale, ne nelo ‘Fein!’, nangakabe kunum makmak Ulom kunum beem kanele emdiw mak ateminbakabi te. ");
INSERT INTO bhl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yu kililina! Abiil tikin em gawman ding em kaim dim fitewoke ding dim kabalak e, yom ibik biliw kawtiw i ataan talbe dulum so, ataan unbe dulum so, alik alik aneng aneng angom be kolewko, teleko, yom awalik kumel Abalakam so, Aisak so, Sekow so, iso makuw wanin wanbokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bókoliw kate, mali Isalael kawtiw yu kilelbi boliwka! Nimtew angom? Emisik ding dim bakate, Sunbin-Got e yulo em wiin so amko koyemeko, akalem angin keyemse kate kame, e yulo koyemoke kasike. Koyemei, i yulo yenbakalaliwi, mali biim biliw dim beem kut kel bokoliw te. Ka kel bomeliwi, amebomeliwi, yukalem kal dim teing feiwbomi, teing bulung gilkabomi, bókoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yangei, Yesus e wonuk so kunum im kak kunum beelo bokolewomele: “Kame ku iti am una! Kom nelo ‘Fein!’, nangew ibolow beem fukunin beemdiw nakati kom weng afak kunum beelo kilelewsi kasike.”, dangse kale. Dangei, beem ding dim bakate, weng afak kunum be atin kuw fein ken kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Beli, deiw mak ding mak, Yesus e Fita em am kalo unse kale. Unomete, e Fita em kalel um auk u kal mamin wakamin fian so abin kon tem akalbului, watemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Watemsomi, um teing woluei, wakamin be ulo koumei, u ken kesomi, baba teineko, wanin fulewsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Beli, ataan tem dokong ange dim e, kunum waneng i kawtiw aneng matil im dim biliw kawtiw banban yemde teliwi, e im dim teinbiliw aneng matil biilo “Takala koyemeko, unina!”, yangeko, wakamin kal wanin kawtiw banso akal okmino koyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kanese eisneng beem dulum elote sua kel akate, Sunbin-Got em bontem dim bakamin kunum Aisaya e weng be bokoko, fut bose weng be kame dem gilaleko, fein ki kelewse kasike. E Kulais em dulum elo bokoyemeko, bolomele: “E nukalem wakamin kuluko, nulo iti ken keyemoke te. Ken keyemeko, nukalem kal betbet keyembe be gis keyemeko, banimoke te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Beli, Yesus em elo falal kolewbiliw kunum waneng banban yetemse ding dim kabalak e, e akalem gelewkabiliw kunum ilo bokoyemomele: “Nu okmun be dikeko, ok mail elo unuma!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yangse ding dim bakate, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum mak teleko, bokolewomele: “Kom aneng aneng mak kakamokolew be, neso makuw kakamokoluw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Dangei, Yesus e elo bokolewomele: “Kut mian i am e ais mit kel te. Awon ikati am so kesomi, aim tem akalkabiliw te. Kate, Kawtiw Aul nete kuw akalkemin am mak banim te. Kak dukuko, kilele akalomin dim akal banim te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dangei, iti gelewkabe kunum mak Yesus elo bokolewomele: “Kamok Fian kutaka! Ne uneko, aatim fom dawkusomelii, iti teleko, kulo kenggelewoki te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dangei, Yesus e kunum beelo bokolewomele: “Kanemoka! Ibolow kuansiliw atew kebiliw kawtiw i ikalem akate ikalem ilo fom dukukemoliwka! Kate ku teleko, nelo nenggelemolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dangei, Yesus so, akalem gelewkabiliw kunum iso, i makuw kunuw dim kawtem uneko, ");
INSERT INTO bhl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","okmun beem mutuk dim unsiliw kale. Unbiliw dim bakate, Yesus e akalse kale. Akal unbelei, fongate akate suuk inim inkal so mak teleko, ok fok fok matem alelem teleko, kunuw dim unbiliw dim ka talse kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Keko beli, Yesus em gelewkabiliw kunum i Yesus elo dawkalfoleko, weng fian kuw gaaneko, bokolewomeliw: “Kamok Fian a! Ku dokoyema! Ok tom yenei, alik kuanomin kis kemuwka o!”, gaaneko, olsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Olemiwi, Yesus e ilo dakalalomele: “Yutaka! Nimtew angom ete yu finganbiliw a? Yom nelo “Fein!”, nangbiliw ibolow be sukum gel sako?”, yangse kale. Yangeko, baba teineko, suuk inim fian so okmun so biilo weng sakalal yangei, i sin tew kame tew kanebiliw be gato gato angeko, daking malmal banim kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Keliwi, i fein em kanele kitil be atemeko, yol angeko, ikalem akate bokolew bokolew kesomi, bokolomeliw: “Yakai! Kalakanebe kunum kale nomin kunum kate? Suuk inim so, okmun so, alik bi beem kitil weng be kiliko, fein gelewbiliw kasike!”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Angeko beli, Yesus eso, akalem gelewkabiliw kunum iso, i okmun be fokoko, mali Gadala abiw mutuk beem aneng kalo talsiliw kale. Teliwi, kunum aneng matil im dim teinbiliw kunum alew mak im mit mewso talsiliw kale. Aso i fomkamin dim kuw akal kebomi, alakabiliw kale. Biliwi, kawtiw aneng ka biliw kawtiw alik alik angom bi aso biim kitil so mamtel kebiliw ibolow beelo finganeko, deiw kalo uninba kemaliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Keko beli, kame, aso i teleko, weng kitil weng mak gaanomeliw: “Sunbin-Got em Min kutaka! Ku nulo nono keyemomin talbelew a? Sunbin-Got em sua kel dukuse geeyemomin ding kamelo kebele akate, ku teleko, nulo kal betbet wa mak duyemomin telew a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Aso biim dangbiliw ding dim bakate, mewso ka kel kaing yamgel mak wanbiliwi, alenaliw kasike, kunum alew biim mutuk dim teinbiliw aneng matil bi Yesus elo dakalalomeliw: “Ku ki keko, nulo kaing kulin mutuk tem elo yemdalolewka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dangiwi, Yesus e yan weng bokoyemomele: “Kenka! Kaing mutuk tem unina!”, yangei, i kunum alew biim mutuk teinsiliw dim be koyemeko, fonsangin uneko, kaing kulin tem elo ba unsiliw kale. Uniwi, kaing banban bi sikal fokoko, genem fukuko, gulili yako uneko, fes dok dim mak bulbulun mit uneko, okmun tem keko, ok kunileko, alik alik i kuansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kaneliw ding bakate, kaing biim yetebiliw kawtiw i kanele eisneng be atemeko, yol angeko, fon uneko, abiw mutuk elo kunum aneng matil im dim teinbiliw kunum alew biim kanesiliw sang beso, kanese sang alik alik beso, bakamyem de unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","De uniwi, abiw mutuk kayak i kaing yetebin kawtiw biim weng kal be kiliko, abiw mutuk koleweko, Yesus em fukun unesomi, elo kitil weng mak bokolewomeliw: “Ku num aneng kale koleweko, nanew aneng elo unolewka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Dangiwi, fein, Yesus so akalem gelewkabiliw kunum iso i iti kunuw tem kawtem teineko, okmun be dikesomi, iti akalem am dim Kafelneam abiw mutuk fian kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Beli, mali kawtiw mak i abin kon dim sok so beneko, wakamin kunum mak em teing so yan so yout nam ke alakabe kunum mak beem dim dukuko, Yesus em mit debeleko, talsiliw kale. Telesomeliwi, Yesus e ikalem fein ibolow be ateyemeko, yout kunum beelo bokolewomele: “Kutaka! Ku finganokolew te! Ne kom ibolow sili sili nam be sak misim kuw kuluko, kokemi kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dangei, mali Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum i Yesus beem weng be kiliko, yol angeko, ikalem akate weng bokolew bokolew kelomeliw: “Yakai yutaka! Kunum kale Sunbin-Got em abin kuluko, dasuw weng bokoko, kunum beem sili sili kukuw be ‘Sak misim kuw kulu kokemi!’, ange kasike, e Sunbin-Got em wiin dawkatikabe kai!”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Angiwi, Yesus e biim ibolow fukunin be kal keyemeko, bokoyemomele: “Nimtew angom ete yu ibolow fukunin wa mak ibolow fukunkabiliw a? ");
INSERT INTO bhl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ne bokolomeli: ‘Kom ibolow sili nam be kulu kokemika!’, angi tewe, weng be fian weng keloke kate, ne bokolomeli: ‘Ku teineko, kakama!’, angi tewe, weng be fong weng kuw keloke sako? Babo! ");
INSERT INTO bhl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kate, Sunbin-Got e Kawtiw Aul nelo kitil so auk so dunemse kasike, ne ki keko, kawin dim kaleem kunum waneng im ibolow sili sili nam be sak misim kuw kulu koyembi te.”, yangse kale. Yangeko, yout nam kunum beelo bokolewomele: “Ku teineko, kukalem akalbelew abin beil be kulu auleko, kukalem am elo una!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dangei, e em dangse weng be kiliko, geleweko, baba teineko, akalem am elo fein unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Unesomelei, ka biliw kawtiw alik alik i yol yol angeko, Sunbin-Got em wiin fian daoleweko, bokolomeliw: “Ibo! Sunbin-Got e akalem kitil so auk so be kawtiw nukalem mutuk dim dukuyembe kai.”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Beli, Yesus em kakamele ding bakate, mak kunum mak em wiin e Matyu alenale kale. Kunum be akalem tum win kulamin am tem be teinbelei, Yesus e elo atemeko, elo gaalewomele: “Ku nelo nenggelew tala o!”, dangse kale. Dangei, e em gaalewe weng be kiliko, fongate akate moko, Yesus elo fein gelew unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Keko beli, Yesus e Matyu beem am kel wanin wanomin unse kale. Unesomi, kawtiw im teing dim tum win kulamin kawtiw banso so, mali kawtiw Suda kawtiw im sawa weng afak keko, binba kawtiw iso, alik alik i am ka kel bonggu wensan teineko, Yesus eso em gelewkabiliw kunum biso, wanin fian mak wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wanbomeliwi, Falisi kunum i weng nutnut weng bokolew bokolew keko, Yesus em gelewkabiliw kunum ilo dakalalomeliw: “Nimtew angom ete yom kukuyemin kunum be kunum waneng sili sili nam so, on kisol fokoliwi, deimaliw kunum kukuw wa kekabiliw kunum iso, bongguko, ok wane, wanin wane wanakabe a?”, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yangeko, dakalaliwi, Yesus e im bakabiliw weng be kiliko, ilo fakam yan weng mak bokoyemomele: “Abung geyembin kunum e wakamin banim kawtiw ilo dokoyeminbakabe kate, wakamin so kebiliw kawtiw ite kuw ilo dokoyemkabe te. ");
INSERT INTO bhl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kate yu kilele ibolow fukuneko, kal kesomi, dolon keloliwka! Sunbin-Got em fut tem be be bokolomele: ‘Yu samal asomi, weing dako, nelo ‘Weso! Seyo!’, nangbiliw tewe, ne kaneko kukuw bete atemeko, kalfong kelinba kekabi kate, yu mali kunum waneng ilo kinkin ibolow folok so kukuw kukuyemkabiliw tewe, ne kaneko kukuw bete atemeko, kalfong kekabi te!’, angei, yu teing bakam uneko, ibolow fukuneko, ibolow tem tem keko, uina! Yu kilele kililina! Ne kiol kunum waneng kawtiw ilo gaayemomin telinba kebi kate, sili sili nam so kunum waneng biim gomet teleko, ilo gaayemomin talsi te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Beli, Sion em gelewkabiliw kunum i Yesus em mit teleko, dakalalomeliw: “Deiw mak deiw mak ding dim bakate, nu so, Falisi kunum iso, alik alik nu wanin tokomin kukuw gelewkabiliw kate, nimtew angom ete kom gelewkabiliw kunum bi diwkuw kuw wanin wanenkabiliw a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Dangiwi, Yesus e ilo fakam weng mak bokoyemomele: “Kunum mak em waneng mak wamduko, wanin wanomin wensaniw kawtiw iso alakabe ding dim kabalak e, yu ki keko, teleko, alik alik biilo bokoyemomeliw: ‘Kame sakik ilum ding kasike, yu kanelom wanin wanokoliw te!’, yangokoliw a? Babo! Kate sowem keloke ding kabalak e, kunum waneng wamduse kunum be iso makuw binba kelei, i elo nam atemiw te. Beem ding dim kabalak e, akalem akunum kusel ikati wanin wanomin tokolokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yangesomi, ilo fakam weng makso bokoyemomele: “Kawtiw i ilim anung kikis mak kuluko, ming em dim elo dasomi, nam beneliw te. Nimtew angom? Kaneliw tewe, kilelsiliw ilim beem gingokoliw ding dim e, ilim kikis be fong betel gel kelei, ilim ming beelo fuwfuw keko, iti atin kuw wa wa keloke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Yu kililina! Nem weng kikis e wain ok kikis em kiskiw te. Kawtiw i wain ok kikis mak wain ok sen ming tem elo nam daliw te. Daliw tewe, wain ok kikis be wain ok sen ming tem be kawtol angeko, kawin dim mit kumineko, buseloke te. Kanelei, wain ok sen akati atin kuw wa keloke te. Feinka! Kawtiw i wain ok kikis be wain ok sen kikis tem elo kuw dakamoliwka! Daliw tewe, wain ok so, ok sen so, alew be makuw fein kenboke kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yangbe ding dim be, kak kunum mak teleko, Yesus em mit mewso katin bukbuk teineko, bokolewomele: “Kutaka! Nem mun ukati kame kuw kuanu te. Kasike kame, ku teleko, kom teing e um dim dukulew kano, u iti finik so baba teinuka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dangei, Yesus e kunum beem dangse weng be kilise kasike, Yesus so, akalem gelewkabiliw kunum iso, kunum beso, alik alik i makuw kunum beem am dim kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Unesomeliwi, wakamin so waneng mak Yesus em ibiku unbe dim mewso mewso gelew gelew teleko, akalem ilim tiakim minggiko, unbe dim bete, ilim beem ful be teing meleleweko, unsu kale. Nimtew angom? Kalun kel itol tiak ding dim e, waneng bu diwkuw diwkuw abiw ilum keko, alenalu kasike. ");
INSERT INTO bhl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Beli, waneng bu ukalem ibolow tem kel fukunomelu: “Ne Yesus em ilim dim kel teing kang meleli tewe, ne fein kenoki te!”, angsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kanelui, Yesus e famdes angeko, watemsomelei, bokoumomele: “Aul kutaka! Ku finganemokolew te! Kukalem ‘Fein!’, nangew ibolow bakate, kulo dokokeme kasike.”, wangse kale. Wangse ding dim bakate, waneng bu fein ken kesu kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kenui, Yesus so, akalem gelewkabiliw kunum iso, ilo yemde talse kak kunum beso, alik alik i uneko, kak kunum beem am kalo talsiliw kale. Teliwi, fom am bomi, amebiliw kawtiw demdem mak yetemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yetemiwi, Yesus e kawtiw biilo bokoyemomele: “Yu alik alik kut unina! Aul kalu atin kuw kuaninba te. Akalbu kasike!”, yangse kale. Yangse kate, i elo weng milewsomi, abeng gilewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Abeng gilewiw kate, i kawtiw kunum waneng alik alik biilo yenbakalaliwi, i kut unsiliw kale. Uniwi, Yesus e am kawtem uneko, kuanbu waneng aul buum teing kulu waulei, u iti finik so baba teinsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Teinui, aneng aneng beem biliw kawtiw alik alik i kanele sang be fein kiliko, kal kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Beli, Yesus em aneng ka iti koleweko, unse ding kabalak e, kiin sukul kunum alew mak elo gelew teleko, gaaneko, bokolewomeliw: “Debit mulkis Yesus o! Ku nulo kinkin ibolow keyema o!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dangiwi, Yesus e ilo kililinba tew kesomi, am mak kawtem elo unse kale. Unei, kiin sukul kunum aso i elo anggelew teleko, em fukun talsiliw kasike, e aso ilo dakalako, bokoyemomele: “Kaso yu nelo ‘Fein!’, nangeko, ibolow fukunomeliw: Ne ki keko, kaso yulo ken keyemoki te?”, yangse kale. Yangei, aso i yan weng bokolewomeliw: “Noya! Kamok Fian kutaka! Fein! Kute ki te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dangiwi, e aso im kiin sukul beelo meleyemeko, aso ilo bokoyemomele: “Yukalem fein ibolow beemdiw e yom kiin be goliwka!”, yangse kasike, ");
INSERT INTO bhl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","aso biim kiin sukul so be kiin golyemse kale. Golyemei, Yesus e aso ilo kitil weng mak bokoyemomele: “Wee! Kaso yu kanelom yom dim kaneyeme be mali kawtiw ilo bokoyemokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yangse kate, aso i em yangse weng beelo sakalaw keko, weng bo bo kelewsomi, uneko, im dim kaneyemse sang be aneng ka biliw kawtiw alik alik ilo bokoyem yak bokoyem yak unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aso biim Yesus elo kolew unsiliw ding bakate, mali kawtiw i aneng matil ete bontem dim benelewse kunum mak Yesus em fukun mit mewso debele talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Debele teliwi, Yesus e aneng matil beelo anbakala kolewse kasike, beem ding dim bakate, weng banim kunum be fein weng matem bokose kale. Kanelei, ka biliw kawtiw i kanele eisneng be atemeko, ikalem bokolew bokolew kelomeliw: “Yakai, yutaka! Kaneko eisneng mak Isalael aneng fian kale matem fitew kelinba kabe te!”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Angsiliw kate, Falisi kawtiw i bokolomeliw: “Aneng matil im emisik kak finik e kunum Yesus beem wiin em dim amko kolewbe kasike, e kitil so keko, aneng matil ilo yenbakala kebaka!”, ange ange keko, bokole bokole kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Beli, Yesus e aneng fian beem abiw abiw angom biim Suda kunum waneng im wensankabiliw am am kalo uneko, alik alik ka biliw kawtiw ilo kukuyem diliko, bakayem yak yak uneko, abiil tikin em gawman ding dim em mewso tele Weng Kal Ken Ati be bokoyem yak yak unse kale. Unbomelei, mali kawtiw im kal wanin auk im dim be bakati alik alik kilelyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kilelyembomi, kawtiw banban biilo yetemeko, kinkin ibolow fian keyemse kale. Nimtew angom? I siwsiw yetemeko, alakabiliw kawtiw banim imdiw kesomi, sakik ilum so kesomi, ibolow fukunin net keyemeko, ibolow so kou keyem alakabiliw kawtiw kesiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Beli, e akalem gelewkabiliw kunum biilo bokoyemomele: “Musun em wanin dem banban akal gilako, memen kesomi, yom kele kate, dem beem dakaluko, kulomin kawtiw i fong gel kasike, ");
INSERT INTO bhl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","yu beem musun sen kayak elo bokolewomeliw: ‘Musun wanin dem dakaluko, kulomin kawtiw makso yemdala o!’, dangoliwka!”, bokoyemomi, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Beli, Yesus e akalem kalun kel gelewkabiliw kunum biilo gaayemei, i akalem mit mewso teliwi, e ilo kitil so wiin fian mak duyemse kasike, i ki keko, kal wanin auk so betbet so kebiliw kawtiw ilo dokoyemeko, mali kawtiw im dim teinbiliw aneng matil biilo yenbakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kalun kel kalan kunum biim wiin e kanekote: Mak e Saimon e — Saimon em wiin mak e Fita kale. Mak e Andulu e — Saimon em akunum te. Mak e Sekow so Sion so — Aso i Sebidi em muluw alew ite te. ");
INSERT INTO bhl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Mak e Filiw e mak e Batolomyu e mak e Tomas e mak e Matyu e — Sua e, e kawtiw im teing dim tum win kulamin kunum te. Mak e Sekow e — Alfius em min te. Mak e Tadius e ");
INSERT INTO bhl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","mak e Saimon e — E Ulom abiw mutuk fian em wonuk so kunum im maka keyemkabiliw kunum kale. Mak e Sudas e — E Iskaliot abiw kunum kesomi, Yesus elo maka kawtiw im teing dim dase kunum baka te. ");
INSERT INTO bhl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus em kalun kel kalan kunum biilo yemdalomin kese ding bakate, e ilo bokoyemomele: “Yu kanelom Isalael im ibik biliw kawtiw so, Samalia aneng fian em biliw kawtiw iso, kawtiw biim abiw abiw kalo unokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kate, yu Isalael kasel siwsiw emdiw deiw kolewko, fenbiliw kawtiw biim abiw abiw kalo kuw unoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Uneko, Weng Kal Ken Ati be bokoyemomeliw: ‘Abiil tikin em gawman keloke ding dim e, kame mewso kele te!’, yangeko, bokoyemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bokoyemsomi, kawtiw im wakamin kal wanin be kilelyemeko, kuansiliw kawtiw ilo yemkalfoleko, bulul abung fian so kawtiw ilo iti kal ken kesomi, kilelyemeko, aneng matil mali kawtiw im dim biliw ilo takalako, koyemoliwka! Keko beli, yu kanelom yom aulbamin beem yan em dulum elote tum win mak kulokoliw te! Nimtew angom? Yukati aulbabiliw beem kitil e sak yan banim misim kuw kulukabiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yu kanelom tum win so, ");
INSERT INTO bhl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","men so, afak ilim alew so, yan aom so, tokfol so, mesesem mesesem eisneng beemdiw kubuleko, de unokoliw te! Bayo! Nimtew angom? Kunum mak aluwkabe beem yan e bakalem ki kuw kulabe kasike. Fein! Dokoyemokoliw kawtiw ikal yom sukum keliw eisneng beelo kal kesomi, yulo fein dokoyemokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yu abiw mak uneko, ka kel ibolow ken so kunum waneng mak feneko, yetemiw tewe, yu kunum waneng biim am ka kel iso kuw boliwka! Bomeliwi, yom aluwbamin be banimoke ding dim bakate, iti abiw be kolew unoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kate, yom im am kawtem tolokoliw ding dim e, yu am beem kasel ilo bamki weng mak bokoyemomeliw: “Sunbin-Got em menew ibolow e yuso boke te!’, yangboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yangesomeliwi, am beem kasel i yukalem menew weng bokoyemiw be kiliko, kuliw tewe, bamki so weng be iso fein boke te. Kate, i weng be kiliko, kulinba keliw tewe, bamki so weng be iti yukalem dim elo kuw toloke te. ");
INSERT INTO bhl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Beemdiw, yu abiw mak uniwi, abiw ka im kunum waneng i yulo kalfonginba keyemeko, yom weng e kililinba keliw tewe, yu yom yan dim beem kukun be abiw ka akate kalis koleweko, iti unoliwka! Yom kaneliw beem mongom ete yu kawtiw biilo kukuyemomeliw: ‘Abiw kunum waneng yu Sunbin-Got em angin bate!’, yangboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Feinka! Yulo ibik kuyemokoliw abiw mutuk fian kasel biim kulokoliw ilum e Sodom so Gomola so abiw mutuk fian alew biim kasel im kaneyemse ilum emdiw bate! Sunbin-Got em ilo geeyemoke ding dim e, isik kal ilum fian fian mak kulokoliw kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yangei, Yesus e kewkew weng mak akalem kalan kunum biilo bokoyemomele: “Ne yulo yamdalii, yu siwsiw emdiw keko, kut mian im biliw dim mutuk kalo kulus unokoliw kasike, yom ibolow fukunin e nuk seil wanin emdiw kelokoliw kate, yom ibolow fukunin e kiol kuw sen banim so keko, boliwka! ");
INSERT INTO bhl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Beli, yu kilelbi boliwka! Mali kawtiw mak teleko, yulo yauleko, wa kukuw keyemomi, Isalael kasel num diwyemin kunum im kiin dim mo koyemeko, num wensan kekabiliw am kalo nang debet sok so yen feiw koyemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yu nelo ‘Fein!’, nangbiliw kunum kebiliw kasike, i yulo yemde uneko, yulo aneng aneng im yetebiliw kak kunum so, emisik kamok fian iso, alik alik biim kiin dim mo koyemokoliw te. Koyemiwi, yu ka bomi, yukalem fein ibolow be kak kawtiw biilo kukuyem kemokoliw kasike, Isalael kawtiw num ibik biliw kawtiw ikati nem wiin elo kal kelewokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Keko beli, yu kanelom kaneyembiliw biim angan finganeko, ‘Nono keko, yan weng bokoyemokoluw yake!’, angeko, ibolow fukunin tiaktiak kemokoliw te! Bate! Nimtew angom? Im yulo geeyemokoliw ding bakate, yom Kalew em Sunbin-Finik e yom ilo bokoyemokoliw yan weng be kilele fitew dim kuw dako, kukuyemoke kasike, yu ki keko, kiol kuw dolon keko, weng ken bokoyemokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Beem ding dim bakate, yukalem kaim atuk akate deeko, yulo maka im teing dim da koyemiwi, i yulo yeniwi, yu fein kuanokoliw te. Keko beli, kalew kumel i ikalem muluwel yulo maka im teing dim da koyemiwi, i yulo yenokoliw te. Keko beli, yukalem aul ikal sakalaw keko, weng bo bo kelomi, auk so alew so yulo maka im teing dim da koyemiwi, i yulo yenokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Feinka! Kawtiw alik alik i yulo ibolow kaim alel kuw keyemokoliw te. Nimtew angom? Yu nelo ‘Fein!’, nangbiliw kawtiw kebiliw kasike. Kate yu kililina! Yu kitil keko, biw tewe, fefe ding kabalak e, Sunbin-Got e yulo yemde unei, yu akalem gawman ding dim kel diwkuw diwkuw bokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Keko beli, mali abiw mutuk mak im kasel i yulo ‘Kame, ilo ilum fian mak duyemum o!’, yangbiw tewe, yu fongate akate im biliw dim be koleweko, nanew abiw nanew abiw dim elo fon unoliwka! Fon unokoliw kate yu kililina! Yom Isalael aneng aneng beem mali abiw mak mali abiw mak fon uneko, alik alik im mewso uninba kelokoliw ding kabalak e, Kawtiw Aul nem mali Isalael aneng kasel ilo geeyemin ding fian mak fein toloke te. ");
INSERT INTO bhl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Feinka! Yu ilum fian mak kulokoliw te. Nimtew angom? Nakati ilum fian mak kulusi kasike. Yu ibolow kilele fukunina! Kal kulomin kunum waneng im kal e ikalem kal duyemin kawtiw im afak kebiliw kate, deiw mak ding mak mali im kal e ikalem kukuyemin kunum waneng imdiw keloke te. Beemdiw, weng afak kunum i ikalem kak kunum em afak kakabiliw kasike, weng afak kunum bi ikalem kak kunum im kulukabe ilum bakati kulokoliw te. Yu mali im weng kililiwete: I nem wiin e ‘Belsebul te!’, nangakabiliw kasike, i yom wiin akati de mit da koyembokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yu kanelom mali im angan finganemokoliw te! Wokmobe mesesem mesesem eisneng angom alik alik bi kaim dim kuw fitewokoliw kasike, mali kawtiw alik alik ikati mesesem mesesem eisneng biilo kal keyemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wokmobin dim kel yulo bakayembi weng kale, yu kaim dim kuw alik alik ilo bakayemboliwka! Beemdiw, nem yulo kentem dim kel bakayembi weng kale, yu kaim dim bokoyemiwi, mali kawtiw alik alik ikati kal kelewbokoliw kasike! ");
INSERT INTO bhl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yu kanelom kal dim em yebiliw kawtiw im angan finganemokoliw te! Nimtew angom? I ki keko, yom sunsun bokoliw finik bi nam atin kuw yenokoliw kasike. Kate, yu Sunbin-Got em angan bete kuw finganemoliwka! Nimtew angom? Ete kuw ki keko, yom kal so finik so makuw atin kuw yeneko, munmun weing dong tem da koyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yu bokolomeliw: ‘Awon men gel alew bi wiin banim kai!’, angeko, ilo tum win auk kom gel kuw mak iso wenokoliw kate, yukalem Kalew be ilo kal keyemsomi, ilo kilele yetemkabe te. Im dulum elote ‘Kanelom dakalu mitokoliw te!’, ange tewe, fein, mak be nam dakalu mitoke te. ");
INSERT INTO bhl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yu kililina! Sunbin-Got e yukalem kak kon be makmak makmak be teing bokoko, atemalakabe kasike, e yulo alikum kal keko, kilele yeteboke te. ");
INSERT INTO bhl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Keko kasike, yu kanelom finganemokoliw te! Yom wiin be awon banban im wiin be bakilewkabe kasike. ");
INSERT INTO bhl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yu kililina! Yu mali kawtiw im kiin dim e finganinba keko, nakalem wiin be kaim dim kuw keyembiw tewe, ne nakalem abiil tikin katem alakabe Aatim beem kiin dim e yom wiin akati kaim dim fitew matem keyemboki te. ");
INSERT INTO bhl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kate, yu nem wiin mali im kiin dim okiw danemiw tewe, nakati yukalem wiin bi nakalem abiil tikin katem alakabe Aatim beem kiin dim e okiw da koyemoki te. ");
INSERT INTO bhl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yu ibolow fukunomeliw: ‘Yesus e kawin dim kaleem kunum waneng alik alik nulo menew ibolow bin so kukuw be kukuyemomin talse te.’, angbiw kate, bate! Nem talsi beem mongom ete mali kawtiw i nem weng be kilisomi, yulo maka keyembokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Keyemsomeliwi, yelimel i amen kuw amen kuw kebokoliw te. Min esik alew elo maka kelewbelei, mun usik auk ulo maka keumbului, min kalel usik imok auk ulo maka keumoku te. ");
INSERT INTO bhl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Feinka! Yukalem angin akate, maka fian kelew kelew keemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mali kawtiw mak i ikalem alew o, auk o, aul o, yelimel alik biim ibolow fukuneko, nem yulo duyemsi aluwbamin beem afak elo kelinba keliw tewe, i nem neggelewemin kunum waneng nam keliw te. ");
INSERT INTO bhl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kesomeliwi, mali yom mutuk biliw kunum ite mak memen kelinba kesomi, nem wiin dim kel ilum mak daoko, betbet inkal so kuluko, nem kuanoki beemdiw yukati kuanomin keliw tewe, kaneliw kawtiw yu nem neggelewemin kunum bate. ");
INSERT INTO bhl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mali ikalem ibolow kuw fukunkabiliw kawtiw i atin kuw finik so banimokoliw kate, mali kawtiw ikalem ibolow fukuninba kesomi, nakalem ibolow kuw fukunbiliw kunum waneng i sunsun bin finik kuluko, diwkuw diwkuw bokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yangesomi, Yesus e iti weng mak bokoyemomele: “Nimin kunum waneng ite mak yulo ikalem am elo yemde unesomi, kukuw ken mak keyemiw tewe, im kanebiliw kukuw be nakati kenemsomi, nakalem nemdase Aatim bakati kelewbokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nimin kunum waneng ite mak bokolomeliw: ‘Kunum bi Sunbin-Got em bontem dim bakamin kunum ite te!’, angesomi, yulo ikalem am elo yemde unesomi, kukuw ken keyembiw tewe, Sunbin-Got e kanekabiliw kunum waneng ilo akalem bontem dim bakamin kunum beem yan dulewoke yan ki bakate duyemoke te. Beemdiw, nimin kunum waneng ite mak bokolomeliw: ‘Kunum bi kiol kuw kunum ite te!’, angesomi, yulo ikalem am elo yemde unesomi, kukuw ken keyembiw tewe, Sunbin-Got e kanekabiliw kunum waneng ilo kiol kuw kunum beem yan dulewoke yan ki bakate duyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yu kililina! Nimin kunum waneng ite mak bokolomeliw: ‘Kunum bi Yesus em gelewkabiliw kunum ite te!’, angesomi, sak wiin banim kunum mak ilo ok gilil ok duyemiw tewe, kanekabiliw kunum waneng i kanebiliw beem yan e fein kulokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yangeko, Yesus em akalem kalun kel gelewkabiliw kunum biilo kukuyemeko, iti weng banimse em ding kabalak e, e aneng ka koleweko, Galili aneng fian em aneng aneng ka biliw kawtiw ilo kukuyemeko, Sunbin-Got em weng kal bakayem tem tem unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Beem ding dim be, i ok da koyemkabe kunum Sion elo sok am tem da kolewsiliw kale. Kolewiwi, mali kawtiw mak teleko, elo Mesaya Yesus beem kanekabe weng sang bokolewsiliw kale. Bokolewsomeliwi, e akalem gelewkabiliw kunum mali mak gaayemei, i teliwi, e ilo Yesus elo dakalalomin weng mak ");
INSERT INTO bhl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bokoyemomele: “Yu uneko, elo dakalalomeliw: ‘Ku Sunbin-Got em Isalael kawtiw nulo dakayem toloke angakabiliw kunum kute yako? Bani nanew kunum yako? Nimtew angom? Nu kunum beem tolomin ding fen buluw kasike.’, dangeko, dakalaloliwka!”, yangei, i fein unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Uneko, Yesus em mit talsiliw ding kabalak e, i elo dakalaliwi, e yan weng bokoyemomele: “Yu nem mit teleko, nem kanebi eisneng be atemsomi, nem bakayembi weng be kilisomi, iti weng de uneko, Sion elo bokolewomeliw: ");
INSERT INTO bhl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Kiin sukul so kawtiw i iti kiin gol kebomi, yan yout nam kawtiw i iti yan ken keyemii, i unbomi, bulul abung fian so kawtiw i iti kal ken kuw danong kebomi, kentem kabom nam kawtiw i iti weng wosu kebomi, kuansiliw kawtiw ikati iti baba matem teinbomi, mesesem em banim kawtiw i Sunbin-Got em Weng Kal Ken Ati be wosuko, kal kebiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Feinka! Kunum waneng i nem aluwbabi eisneng kale atemsomi, nelo ‘Fein kai!’, nangesomi, beit kelinba kunum waneng i kalfongeko, kakatemoliwka!’, yu elo dangoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yangei, i em yange weng be kiliko, Sion elo weng kal be bakalew unsiliw kale. Uniwi, Yesus e iti weng mak kunum waneng ka biliw biilo bokoyemomele: “Sua e, yom kawtiw banim dim uneko, Sion beem fukun unemaliw ding dim e, yu nimtew eisneng atebam unsiliw a? Inim teleko, fuu kalakda kolewkabe mot kon mak elo atebam unsiliw sako? ");
INSERT INTO bhl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bani yu uneko, on kisol so, ilim ken so, kunum mak atem unsiliw sako? Babo! On kisol so, ilim ken so kunum i emisik kebiliw kamok fian im am fian sel ka kel kuw alakabiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kasike, yu uneko, nimtew eisneng atebam unemaliw a? Sunbin-Got em bontem dim bakamin kunum mak atebam unakabiliw sako? Feinka! Yu uneko, bontem bakamin kunum fian Sion elo atebam unakabiliw te. E wiin fian so kunum kesomi, mali Sunbin-Got em bontem dim bakamin kunum alik alik ilo bakiyemkabe kunum ete te. ");
INSERT INTO bhl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kunum be so, Mesaya so, aso biim dim e Sunbin-Got em bontem dim bakamin kunum mak Sunbin-Got em weng kale bokoko, fut tem bolomele: ‘Ne dabalakamin kunum mak emisik dabalalii, e uneko, kom ibik tolomin em deiw kileleko, memen kelewboke te.’, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yu alik alik nem weng kale kililina! Ok da koyemin kunum Sion beete wiin fian so kele kasike, e mali kunum alik alik i bakiyemkabe te. Kate, abiil tikin em gawman fitewoke ding dim e, Sion e emisik nam kebe te. Nimtew angom? Kae, kunum wiin banim kebiliw kunum isik Sion elo bakilewokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yu kilelbi boliwka! Sion em ding bakate uneko, kameem buluw ding kale teleko, mali ganbin kunum kitil nam teleko, abiil tikin em gawman ding dim beem angin ilo ankiw da kalak de mit da koyemeko, yebiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moses em kukuyemse weng so, Sunbin-Got em bontem dim bakamin kunum im bakameliw weng beso, alik alik biim angsiliw weng be kame Sion beem dulum elote dem gilase te. ");
INSERT INTO bhl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","15","Ibolow tem fukalel biliw kawtiw yutaka! Yu weng kale kilele kililoliwka! Yu ‘Sunbin-Got em bontem dim bakamin kunum Elaisa e iti toloke te!’, angeko, beem ding fenbiliw kate, Elaisa be Sion ete bakate. ");
INSERT INTO bhl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kunum waneng kanekabiliw biim kiskiw e kan atew a? I kawtiw im wensaniw dim kel teinbiliw aul atew kebiliw te. I kikinbomeliwi, weng tikin weng de une, min weng de une sak weng kuw bokolew bokolew kebomeliw: ");
INSERT INTO bhl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mak ding e, nu kikinbomi, sim bokoluw kate, yu kalfongeko, wilinba keliw te! Mak ding e, nu kikinbomi, sakik so keko, amemuw kate, yukati nuso ameminba keliw te.’, angbiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nimtew angom? Sion e ok so, wanin so, waninba kesomi, wanin tokoko kolew kemele kunum kebe kasike, i bokolomeliw: ‘Sion e aol nam kese kai!’, angbiliw ");
INSERT INTO bhl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","kate, Kawtiw Aul nete ok so, wanin so, wanakabi kasike, i nelo bokonemomeliw: ‘Ku wanin fian so, wain ok so, ilum sen kawtol wanbomi, on kisol fokoliwi, deimeliw kunum iso, kukuw wa so kebiliw kawtiw iso, biim ken kunum kute kai!’, nangbiliw kasike. Kate, yu kilele kililina! Yom kal e fein fian kele tewe, yu kanekabiliw aul biimdiw kelinba kemaliw te. Nimtew angom? Yu fein kal so kunum waneng keliw tewe, yom gelewkabiliw kukuw be yukalem kal keko, gelewkabiliw kukuw bakate fein fitew dim kuw daloke kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Beli, Yesus em mali abiw abiw alenale ding kabalak e, e kitil so auk so mesesem banso aluwbamale kate, abiw kasel bi ibolow famdelinba kesomi, ibolow sili sili kukuw kolinba kesiliw kasike kame, Yesus e kaisuw keyemeko, kawtiw biilo kitil weng mak bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Wee yutaka! Kolasin so Betsaida so, abiw mutuk fian alew kasel yu weng kale kiliko, kilelbi boliwka! Ne aulamin kitil fian mak yom mutuk dim kel kukuyemsi kate, yu ibolow famdelinba kebiliw te. Ne Isalael kawtiw num ibik biliw kawtiw Tail so Saidon so kasel biim abiw mutuk fian alew kakambisomi, biim mutuk dim kel yom dim aluwkabi aluwbamin fian be kukuyemi tewe, i ikalem kanekabiliw kukuw wa be atemeko, fongate akate ibolow mesem keko, tawal aneko, ikalem kakameliw deiwkim wa be koleweko, kikis deiw kuw kakamokoliw te. Kate, ne im mutuk dim ka kel binba kebisi te. ");
INSERT INTO bhl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yu kililina! Sunbin-Got em alik alik ilo geeyemoke ding dim e, yom kulokoliw ilum e Tail so Saidon abiw mutuk fian alew biim kulokoliw ilum be fein bakilewoke te. ");
INSERT INTO bhl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Beedmiw, Kafelneam abiw mutuk fian kasel yutaka! Yu ibolow fukunomeliw: ‘Nu abiil tikin dim katiw elo unokoluw kai!’, angbiliw kate, itel bate! Fein! Yu Seten-Ataanim em abiw wa wa dim kalo unokoliw te! Mak kunum mak Sodom abiw mutuk fian uneko, nem yom mutuk dim kel aluwkabi auk so kitil so eisneng bakatetew biim dim akati aluwbabise tewe, Sunbin-Got e Sodom abiw mutuk fian be banim kelinba kese tew te. ");
INSERT INTO bhl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yu kililina! Sunbin-Got em diwyemoke ding dim e, yom kulokoliw ilum be Sodom abiw mutuk fian kasel biim kulokoliw ilum be fein bakilewoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Yangesomelei, Yesus e Alew elo gaaneko, bokolewomele: “Aatim kutaka! Kom wiin fian e dao kemo! Kute abiil tikin so, kawin dim kale so, alik alik beem kak kunum kute kuw te! Feinka! Aatim ku kukalem ibolow fukunin kuw gelewkabelew kasike, ku nem aluwbamin kitil so, beem mongom so, alew eisneng be okiw da kolewkabelew kasike, alik alik kal kunum so wiin so kunum so, i mesesem beelo ateminba kekabiliw te. Kate, ku mesesem eisneng be aul gel im ibolow so atew aluwkabiliw kawtiw ilo kuw kilele kukuyembelew te. ");
INSERT INTO bhl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aatim kutaka! Ku alik alik mesesem eisneng angom be nem teing dim kel dulewselew te. Kunum waneng i kom Min nelo akokow kenembiliw kate, kute kuw kilele kal kenemkabelew te. Kawtiw i kulo akati akokow kebiliw kate, kom Min nete kuw Aatim kulo kilele kal kebi te. Kebomi, nimin kunum waneng mak biim dulum elote ‘Yu elo akati kal kemoliwka!’, angbi tewe, ne kulo kunum waneng biim kiin dim e fein fitew kuw daloki te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Angeko, akalem gelewkabiliw kunum waneng biilo bokoyemomele: “Wee yutaka! Alik alik yu kilele kililina! Nimin kunum waneng yute mak sawa gelewomin beem dulum elote ilum fian mak kuluko, sawa beem ilum e yulo yemkatikoko, koliw tewe, yu nem mit mewso teliw kano, ne yulo dokoyemeko, ken abin kuw duyemoki te. ");
INSERT INTO bhl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Duyemii, yu nelo kilele netemeko, nem kukuw ibolow dolon kal keko, nem kukuyemin ilum fong gel kuw beem afak kuw bokoliw te. Nimtew angom? Ne ibolow menew falit so kunum kasike, yom ibolow akal menew so keyemeko, ken abin mak duyemoki te. ");
INSERT INTO bhl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yu kililina! Nem yom dim dukuyembi ilum be fong gel kuw, ilum ba kasike, yu ki keko, daolewokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Beem ding dim bakate, finengdakamin ding Sabat ding mak kelei, Yesus so akalem gelewkabiliw kunum iso i wit wanin bilal musun mak em mutuk fok unsiliw kale. Unbomeliwi, akalem gelewkabiliw kunum bi yemen tew kesomi, Suda kawtiw biim kukuw geleweko, wit sen falit de mayak dako, dakaluko, wanen diliko, yak yak unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Wanin diliko, unbiliwi, mali Falisi kunum mak i biim kanebiliw be yetemeko, Yesus elo bokolewomeliw: “Wee kutaka! Kom kenggelewkabiliw kunum kalite finengdakamin ding Sabat kaleem sawa weng be gelewinba kesomi, musun wanin diliko, kakabiliw kai!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dangiwi, Yesus e ilo yan weng mak bokoyemomele: “Yutaka! Yu kilele kililina! Yu nukalem sua alenale emisik kamokim Debit beem kanese sang mak teing bokoko, ateminbakabiliw sako? Deiw mak ding mak eso akalem akunum kumel iso, i yemen tew teinsiliw kasike, ");
INSERT INTO bhl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","i Sunbin-Got em am yol kawtem uneko, beem belet wanin ayem dukukabiliw be sak kuluko, wansiliw kale. Wansiliw kate, wansiliw belet wanin be am yol kunum ayem bikalem wanakabiliw wanin ete kuw kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yu kilele fukuneko, Sunbin-Got em fut tem be teing bokoko, atemeko, kal keloliwka! Fut tem be kukuyemomele: Finengdakamin ding Sabat em ding dim bakate, Sunbin-Got em am yol kunum ayem kunum ikati finengdakamin ding Sabat em kukuw be sakalaw keko, weng bo bo keko, am yol ka kel beem aluwkabiliw kasike! I aulkabiliw kate, ikati sen so banim kunum kekabiliw te. Nimtew angom? Sunbin-Got em am yol em aluwbamin beem sawa weng be finengdakamin ding Sabat beem sawa weng beelo bakilewkabe kasike. ");
INSERT INTO bhl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kate yu kilele kal keloliwka! Kame em kanbe kale Sunbin-Got em am yol beelo iti bakilewkabe te. ");
INSERT INTO bhl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yu Sunbin-Got em fut tem em angse weng be atemeko, kilele teing bokoliw tewe, yu weng kale ken kal kelokoliw te. Fut tem be bokolomele: ‘Yu samal asomi, weing dako, nelo ‘Seyo!’, nangbiliw tewe, ne kaneko kukuw bete atemeko, kalfong kelinba kekabi kate, yu mali kunum waneng ilo kinkin ibolow folok so kukuw kukuyemkabiliw tewe, ne kaneko kukuw be atemeko, kalfong kekabi te!’, angse kale. Yu kilele kililina! Yu weng be dolon kelewiw tewe, yu kanelom mali sen so banim kunum biilo diwyemeko, geeyembokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Feinka! Nakalem ete Kawtiw Aul kebi kasike, finengdakamin ding Sabat beem sawa weng kale, nakati bakileweko, beem kamok kebi te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yangsomi, e aneng ka kolewko, Suda kawtiw im wensankabiliw am mak kawtem elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Beem ding bakate, mak teing kuan fom yout kese kunum mak belei, e atemse kale. Atemsomelei, mali Yesus elo geelewomin deiw fenbiliw kawtiw mak teleko, elo bokolewomeliw: “Finengdakamin ding Sabat beem ding dim bakate, kawtiw i ki keko, mali wakamin so kawtiw ilo kilelyemokoliw, bani?”, dangeko, dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Dakalaliwi, e yan weng bokoyemomele: “Yutaka! Amkim ding Sabat bakate, yom siwsiw mak tenggew elo une tewe, yu fongate akate uneko, elo kuluko, dokolewokoliw, bani? ");
INSERT INTO bhl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Fein, yu elo dokolewokoliw kate, kawtiw i siwsiw ilo atin kuw bakiyemkabiliw kasike, finengdakamin ding Sabat ding bakate, yu kawtiw ilo ken kukuw kukuyemoliwka! Nimtew angom? Kanebe be Sabat ding beem sawa weng elo ki keko, Sunbin-Got em kiin dim e kiol kuw kukuw keloke kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yangeko, kunum teing wa so kunum beelo bokolewomele: “Kom teing be dila!”, dangse kale. Dangei, kunum beem teing wa be dil atemete: Fein, mali em teing emdiw ken ati kuw kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kelei, Falisi kunum i em kanese be atemeko, am yol koleweko, ikalem kuw bokolew bokolew kesomeliw: “Nomin deiw ete kelei, nu kunum Yesus kaleelo aluwi, e kuanoke ya?”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Angbiliw kasike, Yesus e abiw ka koleweko, unbelei, kawtiw banban i elo gelew teliwi, e im wakamin kal wanin kebiliw alik alik be kilelyemse kate, ");
INSERT INTO bhl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","e kitil weng mak bokoyemomele: “Yu kanelom mali kawtiw mak ilo nem kaneyemsi sang kale kaim dim dakamokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yangse kasike, Sunbin-Got em bontem dim bakamin kunum Aisaya em sua kel bokose weng be kame dem gilaleko, fein ki kese kale. E Mesaya beem dulum elote bokoko, fut tem bolomele: ");
INSERT INTO bhl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kunum be nem wiin so amkokolewii, e nem aulnembamin kunum keloke te. Ne elo ibolow mutuk fian dulewsomi, kalfong fian so keleweko, ateboki te. Atebomi, nem Sunbin-Finik beelo dulewoki kasike, e aneng aneng angom kawtiw alik alik im dim uneko, Sunbin-Got em kawtiw ilo diwyemoke ding beem tolomin weng be bakayem tem unoke te. ");
INSERT INTO bhl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Keko beli, e nam weng dubomelei, fian gaanem kakame kasike, deiw kel wensanbiliw kawtiw i beem weng nam kililokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nem aulnembamin kunum be ibolow menew so kunum kasike, e mali mot sen falit angeko, kangomin kis emdiw keliw kawtiw ilo nam atin kuw kang keyemei, i mit tolokoliw te. Beemdiw, e mali yongom dong kuanomin kis emdiw keliw kawtiw ilo nam atin kuw singdet keyemei, i banimokoliw te. Kate deiw mak ding mak, e kitil kuw moko, aneng aneng angom biliw kawtiw ilo kilele kiol kuw diwyemoke kasike, kiol sen so banim kukuw be emel kuw keko, alik alik im kiin dim kel fitewoke te. ");
INSERT INTO bhl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Fitewoke kasike, aneng aneng angom kawtiw alik alik i ibolow fukunomeliw: ‘Kunum bete kuw nulo fein dokoyemoke kai!’, angokoliw te.”, angeko, Aisaya e fut tem boko, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Beem ding dim e, mali kawtiw i mak kunum am auk nam keko, bontem kasi kolewko, kiin sukul kelewse alakabe kunum mak Yesus em mit mewso debele talsiliw kale. Debele teliwi, Yesus e kunum beelo kilelewei, e iti kiin golsomelei, weng akal ki keko, bokose kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Keko beli, kunum waneng banban ka biliw bi beem kanele be atemeko, yol angeko, bokolomeliw: “Kunum kalesik be Debit em mulkis Mesaya ete sako?”, dakalako, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Angiwi, mali Falisi kunum mak im weng bokolew bokolew kesiliw weng be kiliko, yan weng bokolomeliw: “Babo! E aneng matil im kak yetebe finik Belsebul em kitil kuluko, aneng matil takala koyem kebe te!”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Angiwi, Yesus e im ibolow fukuneko, dangiw weng beem mongom ete kal kelomelei, ilo yan weng mak bokoyemomele: “Abiw mutuk fian kasel so, kunum mongom mali mak so, i amen kuw amen kuw kesomi, ganbiw tewe, ikalem kunum mongom wiin be atin kuw banimoke te. Auk diw alew diw yangdel ikalem akate amen kuw amen kuw kesomi, ganbiw tewe, ikalem bonggu biliw wiin be atin kuw gel so banimoke te. ");
INSERT INTO bhl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Beemdiw, Seten-Ataanim em angin ikati mongom amen kuw amen kuw kesomi, ganbiw tewe, im kitil ikati banimoke te. ");
INSERT INTO bhl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nakalem ete Belsebul beem kitil kuluko, kawtiw biilo dokoyemi tewe, yukalem angin isik kanem kitil ete aneng matil bi takalakabiliw a? Yu kilelbiko, yukalem bakabiliw weng beelo ateboliwka! Yom kaneyembiliw angin bikati yulo geeyembokoliw kasike! ");
INSERT INTO bhl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kate, Sunbin-Got e nelo Sunbin-Finik dunemei, ne beem kitil ete aneng matil takalayemkabi tewe, yu kal keko, bokolomeliw: ‘Fein! Abiil tikin em gawman ding dim e, kame bakale kai!’, angboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yu kame kilele kililina! Seten-Ataanim e mak kunum mak on balam so kunum mak atew kebe te. Kate nete, nanew atul nam kunum mak emdiw kesomi, teleko, on balam so kunum beelo dawkatikoko, em on kisol eisneng be, alik alik kulu dakiloki te. ");
INSERT INTO bhl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yu kilele ibolow fukunina! Nimin kawtiw ite mak nem angin kelinba kebiliw tewe, i nem maka kawtiw kebiliw te. Beemdiw, nimin kawtiw ite mak mali kunum waneng ilo nem mit mewso yamde telinba kebiliw tewe, i mali kawtiw ilo yenbakalakabiliw kawtiw ite te. ");
INSERT INTO bhl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yu kilelbi boliwka! Nimin kawtiw ite mak sili sili nam kukuw keko, Sunbin-Got em wiin fian de mit da koleweko, weng mineko, wa dangiw tewe, Sunbin-Got e biim kanebiliw kukuw wa be sak misim kulu koyemoke te. Kate, nimin kawtiw ite mak Sunbin-Finik elo weng milewiw tewe, Sunbin-Got e im weng milewbiliw weng be, nam kulu koyeme te. ");
INSERT INTO bhl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Beemdiw, nimin kawtiw ite mak Kawtiw Aul nem wiin de mit da konemeko, wa nangiw tewe, Sunbin-Got e biim kanebiliw kukuw wa be sak misim kuw kulu koyemoke te. Kate, nimin kawtiw ite mak Sunbin-Finik em wiin de mit da kolewiw tewe, kame biim finik so biliw ding dim akal, sow em toloke ding dim akal, diwkuw diwkuw Sunbin-Got e kanebiliw kawtiw biim kukuw wa be atin kuw gel so mak nam kulu koyeme te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Beem ding dim bakate, Yesus e fakam weng mak bokoyemomele: “Ais ken e dem ken gilalei, ais wa e dem wa gilakabe kasike, kawtiw i ais dem ken mak atemeko, kal keliwete: ‘Dem ken gilale ais be ken sen te!’, angakabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sokyan kimon so muluwel emdiw yutaka! Mesesem eisneng yom ibolow tem kawyak gekbe be bontem dim matem fitewoke kasike, ibolow sili sili nam min yu ki keko, kiol kuw ken eisneng mak nam bakamkakamiw te. ");
INSERT INTO bhl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kunum waneng im ibolow tem e men emdiw te. Kiol kunum waneng im ibolow tem elote kiol kukuw kuw atite kukuw ete kuw fitewkabe te. Kate kiol kuw kelinba kawtiw im ibolow tem elote sili sili nam kukuw kuw fitewkabe te. ");
INSERT INTO bhl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kasike yu nem bakayembi weng kale kilele kililina! Fefe ding dim em geeyemoke ding dim kabalak e, Sunbin-Got e kawtiw alik alik ikalem bontem dim matem dakabiliw beem sak weng gelgel beem dulum elote bokoyemomele: ‘Yu weng beem mongom be fein kaim dim fitew daloliwka!’, yangoke te. ");
INSERT INTO bhl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Beem ding dim bakate, Sunbin-Got e kawtiw biim bokolokoliw yan weng be diw atemeko, mali ilo bokoyemomele: ‘Yu kiol kawtiw sen so banim yute te!’, yangoke te. Kate, e mail mak ilo bokoyemomele: ‘Yu sili sili nam keko, sen so kawtiw yute te!’, yangeko, geeyemok te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yangesomelei, mali Falisi kunum so, mali Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum iso, alik alik i Yesus em mit mewso teleko, bokolewomeliw: “Ku kitil eisneng mak nulo kukuyemew tewe, nu atin kuw kal keluwete: ‘Ku fein, Sunbin-Got em weng afak kunum kute te!’, angeko, kal kelokoluw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Dangiwi, e ilo yan weng bokoyemomele: “Kameem ding alakabiliw osow ibolow atew kesomi, wa teifulu kekabiliw kawtiw yutaka! Yu kitil eisneng atemomin beem dulum elote gaaneko, teliw kate, ne yulo kitil so auk so eisneng mak nam kukuyemi te. Yu Sunbin-Got em sua kel akate akalem bontem dim bakamin kunum Yona elo kukulewse eisneng bakate iti atemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona e takam kulin tem kel belei, taw akal kutiliw akal yemamas kel ding kese kale. Beemdiw, Kawtiw Aul nakati kawin tem kel bilii, taw akal kutiliw akal yemamas kel ding keloki te. ");
INSERT INTO bhl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Beli, Sunbin-Got em kawtiw alik alik ilo diweko, geeyemoke ding dim kabalak e, Ninibe abiw mutuk fian beem kasel i moko, mali ka kel biliw kawtiw yom ibolow sili sili nam be kaim dim dayemokoliw kasike, Sunbin-Got e yulo fein geeyemoke te! Nimtew angom? Ite Sunbin-Got em bontem dim bakamin kunum Yona em bokoyemse weng kal be kilisomi, ‘Fein!’, dangeko, im ibolow famdeko, sili sili kukuw be kolewsiliw kasike. Kolewsiliw kate, nakalem ete Yona elo bakilewkabi kate, yu nelo “Fein!”, nanginba kebiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Beemdiw, Seba aneng em emisik kamok fian kebu waneng u sua kel akate ukalem singam aneng kolew teleko, emisik kamok fian Solomon em kal fian beelo atebam talsu kale. Talsu kasike, Sunbin-Got em kunum waneng alik alik ilo diweko, geeyemoke ding dim kabalak e, waneng bu mali ka kel biliw kawtiw yom ibolow sili sili nam be kaim dim dayemoku kasike, Sunbin-Got e yulo fein geeyemoke te. Nimtew angom? Nakalem ete Solomon elo bakilewkabi kate, yu nelo ‘Fein!’, nanginba kebiliw kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yangeko, iti bokoyemomele: “Yu kililina! Kunum mak em ibolow tem alakabe aneng matil mak kunum beelo kolewe tewe, e finengdalomin tiow dim aneng mak fenem unoke te. Fenem uneko, fenem kakabiko, finengdalomin aneng mak ateminba kele tewe, ");
INSERT INTO bhl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","e bokolomele: ‘Ne iti nakalem kolew talesi am elo uno ya!’, angesomelei, iti teleko, kolew unse am elo fein kawtem unoke te. Unesomi, atemete: ‘Am be kukun kilasomi, kait kelewsiliw kai!’, angeko, atemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Atemsomelei, e iti uneko, aneng matil atin kuw wa wa ben kel mali iso yemde telesomelei, alik alik bi kunum beem ibolow tem kel teinsomi, beem ibolow tem be atin kuw wa wa kuw kelewokoliw te. Wee yutaka! Kunum beem kanelewse beemdiw kameem ding biliw sili sili nam so kawtiw yom dim akati kaneyemoke kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kawtiw banban biilo yangbe ding dim bakate, Yesus em auk so, awkunum kumel iso, alik alik bi “Yesus eso weng bokolomin tuluw kai!”, angeko, elo fenem teleko, kut elote mosiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Moliwi, mak kunum mak Yesus elo bokolewomele: “Kauk so, kom kawkunum kumel iso, alik alik bikati kulo fenem teleko, kut tem ka kel kom ding feneko, biliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Dangei, Yesus e bokoleweko, dakalalomele: “Nem yem so, nawkunum kumel so i kante a?”, dangeko, ");
INSERT INTO bhl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","akalem gelewkabiliw kunum im dulum elo teing bingeko, kawtiw ka biliw ilo bokoyemomele: “Kunum waneng kale biliw ite kuw nem yem so, nawkunum kumel so, ite te. ");
INSERT INTO bhl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nimtew angom? Nem abiil tikin alakabe Aatim beem ibolow fukunin be gelewbiliw kunum waneng bite kuw nakalem nawkunum kumel so, waneng aul kumel so, yem so, kesomi, kebiliw bakate.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Beem ding dim bakate, Yesus e am be koleweko, Galili okmun benggew dim kel teinse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Teinei, kunum waneng banban mak Yesus em fukun talsiliw kasike, e kawtiw biilo benggew dim ka kel koyemeko, kunuw dim mak teineko, ilo kukuyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kukuyemsomi, mesesem mesesem eisneng banso be fakam weng kuw bokoyemse kale. “Mak kunum mak wit dem kuluko, ");
INSERT INTO bhl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","akalem musun fukalale tewe, mali dem be deiwkim dim kuminokoliw kasike, awon i teleko, elo wanokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Keko beli, wit dem mali be kawin fong gel tum dim kuminokoliw kaiske, e fongate akate diwing tebeloke kate, ");
INSERT INTO bhl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","beem kimkim e dabala tum dim kelokoliw kasike, ataan kitil nam tele ding dim e, ais meneng kale fongate akate geetoke te. ");
INSERT INTO bhl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Iti wit dem mali mak wolu dim kuminei, itel ningning so kasi kolewoke kasike, e kot nam keko, tebelinba keloke te. ");
INSERT INTO bhl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kate, wit dem mali mak kawin ken ok so deeng dim mitsomi, tebeko, mali e dem fufu 100 gilaloke te. Gilako, mali em fu akal 60 kel gilalei, iti mali em fu e 30 kel gilaloke te. ");
INSERT INTO bhl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ibolow tem fukalel biliw kawtiw yutaka! Yu weng kale kilele kililoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yangei, akalem gelewkabiliw kunum i Yesus em mit mewso teleko, elo dakalalomeliw: “Nimtew angom ete ku kunum waneng biilo fakam weng kuw bakayemkabelew a?”, dangeko, dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Dakalaliwi, e yan weng bokoyemomele: “Sunbin-Got e yukalem ete akalem gawman ding em ibolow win sang kaleem mongom kaleyemkabe te. Kate, e beem mongom ete mali kawtiw biilo kukuyeminba kekabe kasike, i nam kal keliw te. ");
INSERT INTO bhl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yu weng kale kilele kiliko, aluwboliwka! Mali kawtiw mak i weng kale kilele kiliko, gelewemiw tewe, Sunbin-Got e im fukunin ken ati be makso bamki keyemeko, fasu kemoke te. Kate mali kawtiw mak i weng kale kilele gelewinba keliw tewe, Sunbin-Got e biim fong gel kulusiliw atuk bakati fein kulu koyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kaneloke kasike, mali kawtiw bi nem kiskiw weng alik bete kuw kilikabiliw kasike, ‘I weng be kiliko, kal kelewinba kekabiliw te. I elo kilikabiliw kate, beem mongom ete i kilele dolon kuw kelinba kesomi, akokow kekabiliw te.’ ");
INSERT INTO bhl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aisaya em angse weng kale kame fein dem gilakabe te. E weng be fut tem boko, bokolomele: ‘Yu tiak ding kilikabiliw kate, weng beem mongom e yu kilele dolon kuw kelinba kesomi, akokow kelewkabiliw te. Yu weng be fein atemokoliw kate, beem mongom e yu kal kelinba kekabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nimtew angom? Kawtiw biim ibolow fukunin e atin kuw kou keyembe kasike. I weng be kilele wosulinba kekabiliw kawtiw kesomi, kiin akati gal kuw kesomi, akalbin kawtiw ite te. Mesik esik im kiin be atemsomeliwi, i weng kiliko, ‘Ibolow fukunin ken kuw kulubuluw kai!’, angomi, biim sili sili kukuw be koleweko, nem dim elo teliwi, ne ilo kilelyemoki kasike.’, angeko, Aisaya e angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kate, yukalem ete kalfongeko, kakatemoliwka! Nimtew angom? Yu kiin ken so atemeko, kentem ken so weng kale kilibiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kame nem weng kale kililoliwka! Sua kel akate, Sunbin-Got em bontem dim bakamin kunum banban so, Sunbin-Got em kiin dim kiol kuw kekabiliw kawtiw banban iso, alik alik i yom kame kililko, atemiw eisneng kale akati “Nu kiliko, atemumo!”, angsiliw kate, i kili ateminba kesiliw kale.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yangeko, iti weng mak bokoyemomele: “Yu kame wit dem fukulabe kunum em fakam weng beem mongom e kililina! ");
INSERT INTO bhl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wit dem mali mak deiwkim dim kumin mitkabe ais dem beem mongom e kanekote: Kunum waneng i abiil tikin em gawman ding em sang be kilikabiliw kate, i beem mongom e dolon kelinba kebiliw kasike, Seten-Ataanim e teleko, biim ibolow tem kel dukukabiliw atuk weng bakati kulu kolewsomi, banim kelewoke te. ");
INSERT INTO bhl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wit dem mali mak tum dim mitkabe ais dem beem mongom e kanekote: Kunum waneng i Sunbin-Got em weng kiliko, fongate akate kalfong fian kelewokoliw kate, ");
INSERT INTO bhl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","i weng be bikalem ibolow mutuk tem kel kilele dukulinba kesiliw kasike, i weng beem dulum elote sakik ilum kulusomi, mali kawtiw mak ilo yenomin ibolow keliw tewe, i fongate akate weng be iti kolewokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wit dem mali mak wolu dim aim tem kuminoke ais dem beem mongom e kanekote: Kunum waneng mali mak i Sunbin-Got em weng fongate kuw kiliko, aluwokoliw kate, i on kisol elo ibolow kuw kelewsomi, beem dulum elote ibolow tiaktiak kelewokoliw kasike, i Sunbin-Got em weng be dawkatikoko, kolewsomi, em weng be im dim kel dem mak gilalinba keloke te. ");
INSERT INTO bhl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kate, wit dem mali mak kawin ken ok so deeng dim kumineko, dem ken gilakabe ais dem beem mongom e kanekote: Mali kunum waneng bi Sunbin-Got em weng be kiliko, ken dolon so ibolow aluwokoliw kawtiw ite te. Kawtiw dem so keko, banban gilalokoliw te. Mali im dem e fufu 100 kel kelei, mali im fu e 60 kel kelei, iti mali mak im fu e 30 kel keloke te.”, yangeko, yangse fakam weng beem mongom e akalem gelewkabiliw kunum biim kiin dim kel kaim dase kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Keko beli, Yesus e iti fakam sang mak kawtiw alik alik ilo bokoyemomele: “Yu abiil tikin em gawman ding dim beem sang mak kililina! Kunum mak yongiw musun dim kel wanin dem ken ati kuw fukalako, ");
INSERT INTO bhl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","am unse te. Unei, mililiw dim bakate, akalem maka kunum teleko, wanin dem ken beem mutuk kel ais dem kimon kelewin ais dem akati fukalako, iti unse te. ");
INSERT INTO bhl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kaneko beli, yongiw beem ais dem ken tebeko, dem gilale ding dim kabalak e, ais dem wa bakati fitewse te. ");
INSERT INTO bhl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Fitewei, musun kayak beem weng afak kunum i musun wanin be atemeko, ikalem kamok elo dakalalomeliw: ‘Kamokim kutaka! Ku ais dem ken so wa so fukalaselew sako?’, dangeko, dakalasiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Dakalaliwi, e yan weng bokoyemomele: ‘Babo! Nem maka kunum teleko, ais dem wa be fukulase te.’, yangei, i bokolewomeliw: ‘Nu uneko, elo fitulu fomdolokoluw te.’, dangsiliw kate, ");
INSERT INTO bhl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","e ilo bokoyemomele: ‘Babo! Yu kanelom fitulokoliw te! Nimtew angom? Wa sen be fituliw tewe, wa so ken so sen makuw fitulokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ais ken so wa so be makuw kolewbina! Sow em wanin kulomin ding keloke ding dim e, ne wanin kulomin kunum ilo bokoyemomeli: ‘Kame yu kanelina! Emisik e itel wa besik kuluko, kubuleko, ais daloliwka! Kesomi, wanin ken akal kuluko, kubuleko, nem wanin dukukabiliw am kalo dukulina!’, yangoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yangeko, iti fakam weng mak bokoyemomele: “Abiil tikin em gawman dim em kanekabe sang e ais dem fong gelgel emdiw te. Kunum mak ais dem gelgel be kuluko, akalem yongiw kel kailoke te. ");
INSERT INTO bhl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ais dem be atin kuw fong gel kebe kate, beem tebeko, fian kese ding dim bakate, e sen fian kuw kesomi, mali ka biliw ais alik alik biilo bakiyemei, awon i em teing dim kel teineko, aim gelokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Beemdiw, abiil tikin em gawman dim em kanekabe sang e belet wanin fasu kolew kemin eisneng is emdiw te. Waneng mak fasu kolew kemin eisneng fong gel be kuluko, falaua banban so fangsingelu tewe, alik alik falaua be makuw fasuko, fian sel keloke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Beem ding dim bakate, Yesus e kawtiw ka biliw biilo kiskiw weng kuw bokoyemse kate, kaim dim weng mak ilo bokoyeminba kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kanese beem dulum elote Sunbin-Got em bontem dim bakamin kunum mak em sua kel bokose weng be kame ki kelewse kasike. E bokoyemeko, fut tem bolomele: “Kawin dim kaleem talfut kelewse ding dim elote teleko, kame akal, diwkuw diwkuw okmoko, alenale weng be ne kame fitew dim dali kate, fakam weng kuw bokoyemkabi te.”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Beli, Yesus e kunum waneng banban bi koyemeko, am unse kale. Unei, akalem gelewkabiliw kunum i em mit mewso teleko, bokolewomeliw: “Kamokim kutaka! Ku wa itel wanin musun tebekabe em fakam sang beem mongom be nulo kilele bokoyema!”, dangeko, dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Dakalaliwi, e yan weng bokoyemomele: “Kunum ais dem ken fukalabe kunum be Kawtiw Aul nete te. ");
INSERT INTO bhl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wanin musun be kawin kale te. Ais dem ken be abiil tikin em gawman ding dim kalo unokoliw kunum waneng im kiskiw ete te. Wa itel be Seten-Ataanim em gelewkabiliw kunum waneng im kiskiw ete te. ");
INSERT INTO bhl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nem maka kunum teleko, ais dem wa fukalabe kunum be Seten-Ataanim ete te. Wanin dem beem kulomin ding be fefe ding em kiskiw ete te. Wanin kulomin weng afak kunum bi Sunbin-Got em yemdakamin finik im kiskiw ite te. ");
INSERT INTO bhl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Wanin dem beem kulomin ding em weng afak kunum i itel wa kuluko, kubuleko, ais dalokoliw kiskiw beem mongom e kanekote: Fefe ding em kaneloke eisneng bakate. ");
INSERT INTO bhl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kawtiw Aul ne nakalem yemdakamin finik ilo yemdalii, i nakalem yetebi aneng beem itel wa atew kebiliw kawtiw ilo fitulokoliw te. Wa kawtiw bi mali kunum waneng ilo mit da koyemomin keyemsomi, sakalaw keko, weng bo bo kenemsiliw kawtiw ite te. Yemdakamin finik i kawtiw biilo kubuleko, ");
INSERT INTO bhl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","weing dong tem da koyemokoliw te. Koyemiwi, i ka kel bomi, amebomeliwi, ikalem kal dim teing feiwbomi, teing bulung gilkabomi, bokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bomeliwi, Sunbin-Got em kiin dim kel kiol kekabiliw kawtiw i ataan emdiw ikalem Aatim em gawman dim ka kel ailko, bokoliw te. Ibolow tem fukalel biliw kawtiw yutaka! Yu weng kale kilele kililoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yangeko, Yesus e iti fakam weng mak bokoyemomele: “Abiil tikin em gawman dim e sak fong gel eisneng bate. E on kisol fian mak aneng mak kel okmobe eisneng emdiw te. Deiw mak ding mak kunum mak mali kawtiw im musun kalo uneko, on kisol be atemeko, kalfong fian kulusomi, iti kasi koleweko, am unse te. Unesomelei, akalem alik alik eisneng angom be mali kawtiw iso tum win so alwol keleweko, kuluse tum win be kuluko, on kisol atemse aneng beelo wese te. ");
INSERT INTO bhl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Abiil tikin em gawman dim e tum ati te on kisol fian so tum emdiw te. Deiw mak ding mak on kisol so tum wenkabe kunum mak teleko, ");
INSERT INTO bhl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","tum be atemeko, akalem alik alik eisneng angom be mali kawtiw iso tum win so alwol kelewsomi, kuluse tum win beso tum on kisol so ati te beelo wese te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yangeko, iti bokoyemomele: “Abiil tikin em gawman dim e wakal men emdiw te. Mali kawtiw i wakal men be okmun dim duku kolewko, takam banban kulusiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kulusomeliwi, wakal men be gekei, i elo okmun benggew kel dasomi, ka teineko, takam ken so wa so be diwsomi, ken be alul abuko, wa be kulu kolewsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Beemdiw, fefe ding kabalak e, Sunbin-Got em yemdakamin finik i teleko, kukuw wa kekabiliw kawtiw ikal amen, Sunbin-Got em kiin dim e kiol kuw kekabiliw kawtiw ikal amen, alik alik amen amen kuw keyemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Keyemeko, kukuw wa kekabiliw kawtiw biilo galuko, weing dong tem da koyemokoliw te. Koyemiwi, i ka kel bomi, amebomi, ikalem kal dim teing feiwbomi, teing bulung gilkabomi, bokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yangeko, akalem gelewkabiliw kunum biilo dakalalomele: “Yu nem bakayembi sang be kiliko, kilele dolon kebiliw sako?”, yangse kale. Yangei, i yan weng bokolewomeliw: “No, nu fein kiliko, kilele dolon kebuluw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Dangiwi, e iti weng mak so bokoyemomele: “Yu on kisol so kunum mak em fakam weng kale kililina! E Moses em kukuyemse weng alik alik be kilele kal keko, mali kawtiw ilo beem mongom be kukuyemkabe kunum ete te. Keko beli, e abiil tikin em gawman sang bakati kilele kal kebe kasike, e suaem kukuyemin em on kisol so weng akal, kikis kukuyemin em on kisol so weng bakal alik alik bongguko, mali kunum waneng ilo weng ati ati kuw kukuyemkabe kunum ete te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yangeko, em fakam weng bakayemse ding banimse ding kabalak e, Yesus e aneng ka koleweko, ");
INSERT INTO bhl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","akalem am dim kalo unse kale. Uneko, Suda kawtiw im wensankabiliw am kawtem uneko, kalo teliw kawtiw ilo kukuyem kebomi, alenale kale. Kukuyemsomelei, ka biliw kawtiw i em yangse weng be kiliko, yol angeko, bokolomeliw: “Yakai! Kunum kaleem kal e nono keko, nal kel kulabe ye? Kante kitil fian be dulewbelei, e ki keko, auk so kitil aluwbamin fian be aluwbabe ya? ");
INSERT INTO bhl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Beem alew e am gemin kunum kelei, beem auk u Malia ute te. Em nenggelel im wiin e Sekow o, Yosew o, Saimon o, Suda so ite te. ");
INSERT INTO bhl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Akalem waneng aul min i kale kel nuso biliw kasike, e kal so auk so be nal kel kuluse a?”, ange ange keko, dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kanesomi, desi keleweko, em kukuyemin kilele wosulinba kesomi, im elo “Fein!”, dangomin ibolow e net angsiliw kasike, Yesus e ilo weng mak bokoyemomele: “Feinka! Aneng aneng angom kawtiw alik alik i Sunbin-Got em bontem dim bakamin kunum mak em wiin daolewsiliw kate, akalem am dim kasel i elo nam ‘Fein o!’, dangokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yangeko, kawtiw biim elo “Fein!”, danginba kebiliw ibolow beem sen e ka kel e, auk so kitil so eisneng banso kelinba kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Keko beli, beem ding dim bakate, Antibas Kelot e Galili aneng fian beem emisik kamok e Yesus em kanelewse sang kilisomelei, ");
INSERT INTO bhl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","e akalem weng afak kunum ilo bokoyemomele: “Kunum kale Sion ete te. E iti fomkamin elote teinse kasike kame, e kitil so auk so eisneng kale duku kebe sako!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Yangse kate, Sion em kuaninba keko, bise ding dim kabalak e, Kelot e akalem awkunum Filiw em kalel Kelodias ulo tokoluko, kuluse kasike, Sion esik elo bokolewomele: “Nimtew angom ete ku kiol kuw kukuw kelinba keko, kakunum beem kalel bu kululew a?”, dangeko, wa kukuw be kaim dim dalewse kale. Dalewse kasike, Kelot e Sion elo gal keleweko, sok net kelewsomi, elo sok am tem da kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kolewsomelei, Kelot e “Sion elo alii, kuanoka!”, angse kate, e Isalael kawtiw im awan finganse kasike, kolewse kale. Nimew angom? Isalael kawtiw i ibolow fukunomeliw: “Sion e Sunbin-Got em bontem dim bakamin kunum ete te!”, angsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Keko beli, Kelot em auk dukusu ding be ibolow fukunsiliw ding dim kabalak e, mali kunum kamok min mak telesomeliwi, alik alik i wensaneko, wanin daol mak wansiliw kale. Wanin wanbiliw ding be, Kelodias um mun seiw u kunum alik alik ka biliw im kiin dim e wim dili teleko, Kelot eso, ka biliw kunum iso, alik alik biim ibolow silikmoyemui, i watemeko, “Yakai! Waneng seiw ati te ati!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kesomeliwi, Kelot e weng fawtuk ayem mak kesomi, bokoumomele: “Ku nomin eisneng mak dakalalomelew: ‘Nemena!’, nangew tewe, ne kulo fein kanekemoki te.”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wangei, auk Kelodias u mun buulo ibolow fukunin mak duumui, u uneko, Kelot elo bokolewomelu: “Ku kawtiw ilo ok da koyemkabe kunum Sion beelo asomelew kano, em kak goto wokilewsomi, denem tala o!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Dangui, e ibolow tiaktiak kesomi, Sion elo alomin ibolow kelinba kese kate, akalem eso wanbiliw kunum biim kiin dim e fawtuk ayem weng be bokose kasike, e wonuk so kunum ilo yamdalei, i uneko, ukalem weng bokolewu weng be fein gelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Gelewsomi, sok am tem uneko, Sion em kak goto keleweko, elo aliwi, e kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kuanei, i Sion em goto kelewsiliw kak be awamin dim kel dukuko, waneng seiw buulo deum unsiliw kale. Deum uniwi, usik auk ulo dukaum unsu kasike, auk bu atin kuw kal kelute: “Fein! Kame Sion e banim kembe kai!”, angeko, ibolow ki keumei, Sion em kak sak fomdosu kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Keko beli, Sion em gelewkabiliw kunum i kililiwete: “Sion elo aliwi, e kuan kembe kai!”, angsiliw kasike, i uneko, em fom be kulsomi, fomkamin tem dukusomi, Yesus em fukun uneko, kanese eisneng be elo bokolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kaneko beli, Yesus so, akalem gelewkabiliw kunum biso kunuw tem kawtem teineko, aneng be kolewsomi, kawtiw banim dim mak kalo unsiliw kale. Uniwi, kunum waneng banban bi “Yesus e aneng kale koleweko, kunuw kuluko, kalo une kai!”, angbiliw weng be kilisomi, ikalem abiw mutuk mak abiw mutuk mak kolewsomi, kawin deiw kel kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Uniwi, Yesus em okmun dikese ding bakate, e yetemete: Kawtiw banban teliwi, yetemeko, ilo kinkin ibolow fian keyemsomelei, wakamin kawtiw ilo kilelyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Keko beli, ataan tem dokong unomin ding mewso kese ding kabalak e, Yesus em kalun kel gelewkabiliw kunum i em mit mewso uneko, bokolewomeliw: “Kame ataan tem dokong angomin kis kele kate, aneng kale kel kawtiw banim dim kasike, ku kunum waneng banban biilo bokoyemomelew: ‘Yu abiw mutuk mak abiw mutuk mak kalo wanin fenem unoliwka!’, yangolewka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Dangiwi, e ilo bokoyemomele: “Babo. Nam uniw te. Yukalem ete ilo wanin mak yemenina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yangei, i bokolewomeliw: “Nusik teingabi belet wanin so, takam alew so, be so kuw aluwbuluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Dangiwi, e bokoyemomele: “Nangbiliw wanin be de telina!”, yangeko, ");
INSERT INTO bhl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","kunum waneng ka biliw biilo bokoyemomele: “Yu balasal dim kale kel teinina!”, yangesomelei, belet wanin teingabi kel so takam alew so, be kuluko, kiin e abiil elo doung angesomi, Sunbin-Got elo “Weso! Seyo!”, dangse kale. Dangesomi, belet wanin be fakal fakal kelewsomi, akalem gelewkabiliw kunum biilo yemenei, i kuluko, kunum waneng biilo yemensiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yemeniwi, i kuluko, wanesomi, kumun fasu angsiliw kate, wanin anung e banso banso beki kuw kelei, i kalun kel men fian mak abuko, wen dukusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wanin wansiliw kunum ite kuw banban fufu keko, teingabi kel tausen (5'000) kel kesiliw kate, waneng so, aul so, yatel ilo kunum iso makuw teing bokolinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Keko beli, Yesus e akalem kalun kel gelewkabiliw kunum biilo bokoyemomele: “Yomisik kunuw dim kawtem teineko, okmun dikeko, mali elo keko, unina!”, yangesomi, akalem ete kunum waneng ilo ikalem am dim elo yamdase kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yamdasomelei, ataan tem une dim kabalak e, emikel kuw amgu dim mak unesomi, ka kel Sunbin-Got eso weng bokose kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kaneko beli, Yesus em gelewkabiliw kunum biim kunuw dim kel tein unesomi, okmun mutuk dim kel keliw ding dim bakate, suuk inim fian mak im unbiliw mutum kalote teleko, kunuw beelo fimdi famde kelew talse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Telei, aneng danomin kis kele ding dim bakate, Yesus e okmun dim kel moko, akalem gelewkabiliw kunum im fukun talse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Telei, i elo atemeko, fingansomi, gaanin fian mak bokolomeliw: “Ibo, ibo! Okmun kayak aneng matil mak talbe sako!”, ange ange keko, olsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Olbiliwi, fongate akate Yesus e ilo bokoyemomele: “Yutaka! Yu kanelom finganbomi, walwal kemokoliw te! Nakalem ete telbi kasike, kalaing kuw keloliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yangei, Fita e bokolewomele: “Kamok Fian kutaka! Fein kukalem tewe, nelo bokonemomelew: ‘Kukal okmun dim moko, nem fukun tala!’, nangolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Dangei, Yesus e yan weng bokolewomele: “Kenka. Ku tala!”, dangei, Fita e teinbe kunuw dim be koleweko, okmun dim moko, Yesus em fukun elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Em unbe ding bakate, e atemete: Suuk inim fian mak inkalso kelei, atemse kasike, e finganeko, okmun diw akimomin kis kesomi, gaanin fian mak gaaneko, bokolomele: “Kamok Fian kutaka! Ku dokonema!”, dangeko, gaanse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Gaanei, Yesus e fongate akate em teing aulewsomi, elo matem dasomi, bokolewomele: “Kukalem fein ibolow fong gel beem sen ete te! Nimtew angom ete ku nelo ‘Fein!’, nanginba kebelew a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dangei, aso biim kunuw dim kue yol kawtem uneko, teinsiliw ding dim be, suuk inim akal banimse kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Keko beli, ka biliw kunum alik alik bi kanele eisneng be atemeko, Yesus em wiin daolewsomi, bokolomeliw: “Fein! Ku Sunbin-Got em fein Min te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Beli, Yesus so, akalem gelewkabiliw kunum biso, alik alik biim okmun dikeko, Genesalet aneng kalo talsiliw ding dim bakate, ");
INSERT INTO bhl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ka biliw kunum waneng i Yesus elo atemeko, bokolomeliw: “Kunum be Yesus ete kai!”, ange ange kesomi, aneng mak aneng mak angom kalo weng dabalaliwi, i wakamin kal wanin kawtiw alik alik ilo yemde talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yemde telesomi, Yesus elo dakalalomeliw: “Ku ‘Kenka!’, yangew tewe, wakamin kunum waneng kali kukalem ilim dim teing so meleliwi, i ken kelokoliw te!”, dangsiliw kasike, wakamin so kawtiw bi Yesus elo melelewiw kano, im wakamin kal wanin be banimse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Deiw mak ding mak, Falisi so, Sunbin-Got em kukuyemin weng kalem auleko, kukuyemkabiliw kunum iso, i Selusalem abiw mutuk fian koleweko, Yesus em fukun teleko, dakalakamin mak dakalalomeliw: ");
INSERT INTO bhl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nimtew angom ete kom kenggelewkabiliw kunum bi nukalem awalik kumel im kukuw kukuyemsiliw weng be sakalaw keko, weng bo bo kebomi, teing ginginba keko, wanin wanbiliw a?”, dangeko, dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Dakalaliwi, Yesus e yan weng bokoyemomele: “Be ken kate, yukalem ete, nimtew angom ete yu Sunbin-Got em kukuyemse weng be yom kawalik kumel im sawa weng beem afak kesomi, em weng be dawkatikoko, ankiw da kasi kolewkabiliw a? Ankiw da kasi kolewkabiliw kasike, yu Sunbin-Got em kukuyemse weng be sak fong gel eisneng kelewkabiliw bakate. ");
INSERT INTO bhl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yu kilele kililina! Sunbin-Got e bokolomele: ‘Yukalem kauk kumel so kaliwol kumel so ilo wangweng kukuw keyemboliwka!’, angeko, iti weng makso bokolomele: ‘Nimin kawtiw ite mak ikalem auk kumel so aliwol kumel so ilo weng miyemiw tewe, yu ilo yeniwi, i kuanoliwka!’, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yangse kate yu yukalem aliwol kumel biim kukuw kuw geleweko, bokolomeliw: ‘Nimin kawtiw ite mak bokolomeliw: ‘Nu tum win kale aatim kumel so yem kumel so ilo duyemokoluw kate kame, nu ibolow alwol kesomi, kale be Sunbin-Got elo dukalewokoluw te.’, angbiliw kawtiw bi ");
INSERT INTO bhl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ken kuw kukuw kekabiliw kai.’, yangakabiliw te. Kate, kanekabiliw kawtiw bi aliwol kumel so auk kumel so ilo wangweng keyeminba kekabiliw kasike, yu dasuw weng bokolomeliw: ‘Nu Sunbin-Got em wiin fian daolew kebuluw kawtiw nute te.’, angbiliw te. Nimtew angom? Yu em kukuyemse weng be fong keleweko, kulu kolewko, yukalem kawalik kumel im kukuw bete kuw fian kesomi, fein gelewkabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Fimdi famde kawtiw yutaka! Sua e, Sunbin-Got em bontem dim bakamin kunum Aisaya e yom kukuw wa be ateyemeko, fein weng bokolomele: ");
INSERT INTO bhl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kanekabiliw kawtiw bi nem wiin fian daonem kebiliw kate, i kanebiliw be sak bontem dim kuw kesomi, im ibolow fukunin e dolo dolo singam kel kekabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","I mali kawtiw ilo ikalem ibolow fukunin be Sunbin-Got em kukuyemin weng beemdiw kitil kuw kukuyemkabiliw te. Feinka! Kawtiw bi nem wiin fian be dem banim so, sak kal dim kuw daonemkabiliw te.’, yangse kale.”, yangeko, bokoyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yangeko, Yesus e ka biliw kawtiw banban biilo bokoyemomele: “Yu kale kel teleko, kilele kiliko, ibolow fukunemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mesesem mesesem eisneng bontem dim dako, kunil kebiliw eisneng be kawtiw mak ilo Sunbin-Got em kiin dim e wa keyeminba kekabe te. Babo! Kate mesesem eisneng mak kawtiw im ibolow mutuk tem be bontem fitew dim matem dale eisneng bete kuw Sunbin-Got em kiin dim e fein wa keyemkabe te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yangei, akalem gelewkabiliw kunum i bokolewomeliw: “Yesus kutaka! Kom kane angew weng be Falisi ikati kiliko, ibolow mesem kekemiw kasike!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Dangiwi, e bokoyemomele: “Abiil tikin katem alakabe Aatim be emikel kuw akalem musun dim kel mali ais mak kaise kasike, e mali kawtiw im kaisiliw ais be fein kimkim so fitulu koyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yu kanelom kanebliw kawtiw biim dulum ibolow tiaktiak kemokoliw te! I kiin sukul kebiliw akate, mali kiin sukul kawtiw ilo deiw kaleyembiliw kasike, alik alik i fein dakuluko, tanggew tem mitokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yangei, Fita e Yesus elo dakalako, bokolewomele: “Kom fakam weng bokoyemew weng beem mongom e kame nulo bokoyemew kano, nukal kal keluma!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Dangei, Yesus e akalem gelewkabiliw kunum biilo yan weng bokoyemomele: “Eke! Bani yukati ibolow kau angeko, dolon keko, kal kelinba biliw sako? ");
INSERT INTO bhl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yu kililina! Yom wanin wanakabiliw be bontem dim kel waniwi, e uneko, ol kelei, yu elo olnukabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kate, bontem kaoko, matem daliw weng be kawtiw im ibolow tem elote telei, kawtiw biilo Sunbin-Got em kiin dim e sen so keyemkabe kasike. ");
INSERT INTO bhl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nimtew angom? Kawtiw im ibolow sili sili nam beem mongom ete wa kukuw fitew dim dakabiliw kasike. Im wa dakabiliw kukuw be kanekote: Mak e kawtiw ilo yeniwi, i kuan kebiliw kemin e, mak e kais yemkal im nanew kawtiw iso osow kemin e, mak e kut deiw osow kemin e, mak e yakut kemin e, mak e dasuw weng bokolew bokolew kemin e, mak e nanew kawtiw ilo miyemin weng kemin bete te. ");
INSERT INTO bhl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kaneko eisneng bete kuw kunum waneng bi Sunbin-Got em kiin dim e sen so keyemkabe te. Kate, kawtiw im teing ginginba kesomi, wanin wanakabiliw be Sunbin-Got em kiin dim e sen so keyeminba kekabe te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Beli, Yesus e aneng ka bisomi, aneng be iti koleweko, Suda kawtiw im ibik biliw aneng fian em abiw mutuk fian alew Tail so Saidon so beem aneng aneng kalo unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Em unbe dim bakate, Kenan aneng fian ka alakabu waneng mak teleko, gaanomelu: “Kamok Fian Debit em mulkis kutaka! Ku nelo kinkin kenema! Nimtew angom? Aneng matil mak nem mun ulo tom atin kuw wa wa keumbe kasike!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dangui, Yesus e ulo yan weng mak bokouminba kese kasike, akalem gelewkabiliw kunum i bokolewomeliw: “Wee! Gaanem diliko, nulo yenggelew talbu waneng bu fongate wamdalew kano, u iti unuka.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dangiwi, Yesus e ilo bokoyemomele: “Sunbin-Got e nelo siwsiw emdiw kut kakabiliw Isalael kawtiw ilo dokoyemomin namdalei, ne talsi kate, waneng bu Isalael kawtiw num ibik biliw kawtiw biim waneng ute kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yangse kate, waneng bu Yesus em mit mewso telesomi, katin bukbuk angeko, gatak wakas angesomi, gaanomelu: “Kunum Fian kutaka! Nelo dokonema!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Dangui, Yesus e yan weng mak bokoumomele: “Kawtiw i aul im wanin besik kuse fomdoko, mian men ilo duyemiw tewe, be mesem te!”, wangese kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wangei, usik yan weng bokolewomelu: “Ku fein weng bokolew kate, mian kakabiliw kawtiw i wanin dem ken wanbiliwi, mali wanin sak abin dim kumine tewe, ikalem mian i teleko, kubul wanakabiliw te.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dangui, Yesus e waneng buum dangu weng be kiliko, bokoumomele: “Waneng kutaka! Kukalem fein ibolow e fian kebe kasike, kukalem nomin ibolow mak ‘Keloka!’, angew ibolow bakate fein dem keloke te!”, wangse kale. Em wange dim bakate, um aul bu ken kesu kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Keko beli, Yesus e aneng be koleweko, Galili aneng em okmun benggew dim elo unesomi, amgu tikin dim mak teinse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Teinbelei, kunum waneng banban i em mit teleko, wakamin kawtiw kun yout nam o, kiin sukul o, kun fuw nam o, bontem benese o, mesesem mesesem wa so kekabiliw kawtiw o, alik alik bi em yan mit mewso yemde teliwi, e kilelyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kilelyemei, kawtiw ka biliw kawtiw alik i yetemiwete: Bontem benesiliw kawtiw ikal weng bokoliwi, kun yout so kawtiw ikal yan mo kilele moko, uniwi, kiin sukul kawtiw ikal kiin golko, mesesem kilele atemiwi, yetemsiliw kale. Yetemomi, yol angesomi, Isalael im Sunbin-Got em wiin fian daolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Beli, Yesus e akalem gelewkabiliw kunum ilo gaayemei, i teliwi, e bokoyemomele: “Ne kunum waneng kalilo kinkin keyemi te. Nimtew angom? Tiak alemsal ding bakate, i nuso bomi, yemen tew tein fakalaliw kasike. Nu ilo sak yemdaluw tewe, i deiw kel yemen tew teinsomi, kiin felfel beit keko, fom mit tolokoliw sako!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yangei, akalem gelewkabiliw kunum i bokolewomeliw: “Kawtiw banim wanin banim dim kalesik e, nu nono kesom ete, wanin wensomi, wanin yemenokoluw a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Dangiwi, Yesus e bokoyemomele: “Yom belet wanin e nolin kuw be ya?”, yangei, i yan weng bokolewomeliw: “Ben kel belet wanin so takam fong gelgel so kuw bete.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dangiwi, Yesus e kunum waneng ka biliw biilo bokoyemomele: “Alik yu kawin dim ka kel tein fakalalina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yangesomi, Yesus e ben kel belet wanin beso takam beso kulusomi, Sunbin-Got elo “Weso! Seyo!”, dangeko, fakal fakal keleweko, akalem gelewkabiliw kunum biilo duyemei, isik kunum waneng biilo amen amen keko, yemensiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yemeniwi, i wanesomi, alik alik ki ksomeliwi, wanin e beki kuw kelei, i wanin atuk kolewsomi, abuko, ben kel men fian wen dukusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kawtiw biim wanin wansiliw i kunum imikel e fufu ketket teben tausen (4'000) kese kate, aul so waneng so yatel iso teing bokolinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Keko beli, em ilo yemdalei, i unsiliw ding dim kabalak e, e kunuw dim kawtem teineko, Magadan aneng kalo unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Beli, Falisi kunum so Satyusi kunum iso i teleko, Yesus elo kiskis weng mak bokolewomeliw: “Kame ku kitil so auk so eisneng mak aulew kano, nu atemeko, atin kuw kal keluwete: ‘Feinka! Ku Sunbin-Got em aluwbamin kunum kute te!’, kangeko, kal kemoluwka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Dangiwi, Yesus e yan weng bokoyemomele: “Yu ataan tele dulum elo atemeko, ‘Abiil okmun alele kasike, suuk tolomin keme kai!’, angenkabiliw te. Angeko, yom angiw ding be fein suuk talakabe te. ");
INSERT INTO bhl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Talakabe kate, yu atemeko, ‘Mililiw mutuk e fial moko, gilil so inim so abiil kul so kele kasike, am ken am keloke kai.’, angenkabiliw te. Angeko, yom angiw dim be fein am ken am kekabe te. Feinka! Yu abiil angom beem kanekabe eisneng be atemeko, beem mongom kal kekabiliw kate, kame kanele ding beem mongom e yu akokow kebiliw sako? ");
INSERT INTO bhl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kameem ding biliw kawtiw yu sili sili nam te. Yu gaaneko, ‘Kitil so auk so eisneng mak kukuyemolewka!’, nangeko, teliw kate, ne yulo kitil so auk so eisneng mak nam kukuyemi te. Kitil so auk so eisneng makmak bete kuw Sunbin-Got e sua kel akalem bontem dim bakamin kunum Yona elo kukulewse bakate, yukati iti atemokoliw te.”, yangeko, ilo koyemeko, unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Keko beli, Yesus so akalem gelewkabiliw kunum iso uneko, okmun be dikeko, mali elo unsiliw kale. Unsiliw kate, akalem gelewkabiliw kunum bi akokow kesomi, belet wanin mak de telinba kesomi, unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Unbomeliwi, Yesus e weng mak bokoyemomele: “Wee yutaka! Yu Satyusi kunum so, Falisi kunum iso, alik alik biim belet wanin fasu kolewkabiliw is eisneng beem dulum elote kilelbiko, bokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yangei, akalem gelewkabiliw kunum i em yange weng be kilisomi, ikalem bokolew bokolew kesomi, bokolomeliw: “Num belet wanin mak de telinba keluw beem mongom ete e weng be yangbe sako!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Angbiwi, Yesus e im angbiliw weng be kal keko, bokoyemomele: “Yom fein ibolow be fong gel kebe sako? Nimtew angom ete yu bokolomeliw: ‘Nu belet wanin banim te!’, angbiliw a? ");
INSERT INTO bhl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yu akokow keliw sako? Nem teingabi belet wanin kuluko, teingabi kel tausen (5'000) kel kawtiw biilo wanin yemensi beem kanesi eisneng be yu kame akokow kebiliw sako? Kawtiw alik alik biim wane ki kesiliw ding bakate, yu nolin men ete geko, abu dukusiliw a? ");
INSERT INTO bhl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Usinel akate, ne ben kel belet wanin kuluko, ketket teben kel tausen (4'000) kel kunum biilo yemenii, i waneko, gal kesomi, yu nolin men bete abu dukusiliw a? ");
INSERT INTO bhl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Keko kasike, yu nimtew angom ete dolon kelinba kesomi, nem yangbi weng beem dulum elote ‘Be belet weng bate!’, angeko, kal kelinba biliw a? Yu kilele ibolow fukunina! Ne Falisi so Satyusi so biim kukuw em dulum elote ‘Yu kilelbiko, bokoliw te!’, yangbi te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yangei, i kiliko, ibolow fukunomeliw: “E belet wanin beem dulum elote yanginba kebe te! E nulo Falisi so Satyusi so biim fasu kolewko, kukuyemin bete kuw ‘Yu kilelbi boliwka!’, yangbe kai!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Beli, deiw mak ding mak, Yesus so, akalem gelewkabiliw kunum iso, i Sisalia Filibai abiw mutuk fian beem mewso kalo unsiliw kale. Beem ding dim bakate, Yesus e ilo dakalalomele: “Kunum waneng i nelo netemeko, Kawtiw Aul nelo kante nangeko, ibolow fukunkabiliw a?”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yangei, i yan weng mak bokolewomeliw: “Mali kawtiw i bokolomeliw: ‘Ku Sion ok da koyemkemin kunum ku ete sako!’, angbiliw te. Mali isik bokolomeliw: ‘Ku Elaisa kute sako!’, angbiliw te. Mali kawtiw isik bokolomeliw: ‘Sunbin-Got em bontem dim bakamin kunum Selemaya meni nanew Sunbin-Got em bontem dim bakamin kunum kuanse kunum mak kame iti teinbomi, kanebelew kunum kute sako!’, angbiliw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dangiwi, e ilo dakalalomele: “Kate yukalem ete, yu nelo kante nangeko, ibolow fukunbiliw a?”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Yangei, Fita esik yan weng bokolewomele: “Ku finik so bin Sunbin-Got em Min Mesaya kute te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dangei, Yesus e bokolewomele: “Yona em min Saimon kutaka! Kawin dim kasel ite mak eisneng kale kulo kukukeminba keliw te. Nakalem abiil katem alakabe Aatim ete kuw kulo kukukeme kasike, ku kakateko, kalfongolewka! ");
INSERT INTO bhl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ku kilele kilila! Kom weng bokonemew weng kale tum kitil emdiw kele kasike, kom wiin akal Fita te. Nem sios e tum beem tikin dim kel gelii, kuan kemin em kitil e sios biilo nam de mit da koyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Feinka! Ne abiil tikin em am yal buskemin be dukemoki kasike, ku kawin dim kale kel mali kunum waneng im kukuyemin be diweko, im kukuyemin beelo bususomi, ‘Fein kukuyemin bete te!’, angesomi, mali im kukuyemin be diweko, ailsomi, ‘Kukuyem be wa te!’, angeko, yangbew tewe, abiil katem alakabe Sunbin-Got akati kom diweko, yangbelew weng be fein kili atemeko, dokokemoke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dangeko, kewkew weng mak akalem gelewkabiliw kunum biilo bokoyemomele: “Yu kanelom mali kawtiw ilo ‘Yesus be Mesaya te!’, yangeko, bokoyemokoliw te!”, yangeko, weng ayemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Beem ding dim kabalak e, Yesus e akalem gelewkabiliw kunum biilo iti bokoyem iti bokoyemeko, bokolomele: “Ne Sunbin-Got em ibolow fukunin geleweko, Selusalem abiw mutuk fian kawtem uni kasike. Unsomelii, Isalael kawtiw num kak kunum so, Sunbin-Got em am yol em kunum ayem sel eso, em angin iso, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum iso, alik alik bi nelo gal kenemeko, ilum fian so betbet fian so mak dunemeko, neniwi, ne kuanoki te. Kuanii, yemamas em ding dim e, ne iti baba teinoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yangei, Fita e em yangse weng be kiliko, Yesus elo dolon dim takas debeleko, unesomi, digaka keleweko, bokolewomele: “Babo! Kamok a! Kaneko eisneng be kanelom kom dim elo tele te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Dangei, Yesus e famdes angeko, Fita elo atemsomi, bokolewomele: “Seten-Ataanim kutaka! Nem ibik katem elo una! Ku nimtew angom ete nem deiw okinemeko, ‘Ku deiw nanew elo una!’, nangbelew a? Ku Sunbin-Got em ibolow fukunin bete gelewinba kesomi, kal so kun so kawtiw im ibolow fukunin ete kuw gelewbelew kasike!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dangeko, akalem gelewkabiliw kunum alik alik ilo bokoyemomele: “Nimin kunum waneng ite mak nelo nenggelewiw tewe, i ikalem ibolow fukunin e kolewsomi, Sunbin-Got em ibolow fukunin bete kuw gelewemoliwka! Gelewbiliw kasike, kawtiw mali mak yulo nem dulum em mongom ete yenewi, yu inkal kulamiw tewe, yu ‘Ken kuw ka!’, angeko, nelo diwkuw nenggelewmoliwkam ");
INSERT INTO bhl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yu kililina! Nimin kawtiw ite mak ikalem ibolow kuw fukunemiw tewe, ikalem finik so bin fein banimokoliw te. Kate, nimin kunum waneng ite mak nelo nenggelewsomi, ikalem ibolow beelo fukuninba keliw tewe, kunum waneng bi sunsun finik so bin fein kuluko, bókoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Beemdiw, mali kawtiw mak kawin dim kaleem on kisol mesesem beem ibolow kuw keko, kulamokoliw kate, ikalem finik e Seten-Ataanim em abiw wa wa une tewe, kawtiw bi ken kelokoliw sako? Bayo! Wa wa kebokoliw te. Kebomeliwi, i nono keko, finik so sunsun bin iti kuluko, bókoliw a? Im kulokoliw deiw be banim kasike! ");
INSERT INTO bhl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yu kilelbi boliwka! Deiw mak ding mak kabalak e, Kawtiw Aul ne Aatim em auk so kitil so be kuluko, Sunbin-Got em yemdakamin finik iso telesomi, alik alik kawtiw im aluwbabiliw kukuw beem yan be fein duyemoki te. ");
INSERT INTO bhl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ne yulo fein weng kale bokoyemite: Mali kale kel biliw kawtiw mak kuaninba siliw akate, Kawtiw Aul ne kamok fian keko, telii, i nelo netemokiliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iti gung kel ding mak banimei, Yesus e Fita so, Sekow so, em awkunum Sion so, alik biilo yemde unei, i makuw uneko, amgu tikin fian kawtem elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Uniwi, Yesus em kal e biim kiin dim kel famdes angei, i atemiwete: Em kiinguen dim e ataan dong atew ailbiko, em ilim be kais abiil kul emdiw kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kesomelei, sua kel alenaliw kunum Moses so Elaisa so aso i Yesus eso mewso mosomi, weng bokolew bokolew kebiliwi, i yetemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yetemomeliwi, Fita e Yesus elo bokolewomele: “Kamok fian kutaka! Ken ati! Nu buluw kasike. Kukalem ete ‘Kenka!’, yangew tewe, kame kalakate, ne kanis doung kanel doung tem am alemsal mak geloki te! Am mak e kom, mak e Moses em, mak e Elaisa em geloki te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Em dangse ding dim bakate, yukam kais nam ailbin fian so mak teleko, Yesus so, kunum alew biso, alik ilo net kasi koyemsomi, beem tem kalote weng mak bokolomele: “Kunum be nakalem min te. Ne sun kuw ibolow mutuk fian dulewbomi, elo kalfong kelewbi kasike, yukati em weng kuw gelewemoliwka!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Angei, Yesus em gelewkabiliw kunum bi weng be kiliko, i finganin fian mak finganeko, katin bukbuk angeko, kiinguen kawin dim kau angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Angiwi, Yesus e im mit mewso telesomelei, meleyemeko, weng bokoyemomele: “Yu baba teineko, finganemokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yangei, i baba teineko, atemiwete: Yesus emikel kuw belei, atemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Keko beli, alik alik biim amgu tikin ete mit tasiliw ding bakate, Yesus e weng kitil weng mak bokoyemomele: “Yu kanelom kanese eisneng be mali kawtiw ilo bakayem bokoliw te! Kate, Kawtiw Aul nem kuaneko, iti baba teinoki ding dim kabalak e, yu mali kawtiw ilo kanese eisneng be fein bakayem boliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yangei, akalem gelewkabiliw kunum i elo dakalalomeliw: “Nimtew angom ete Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum i bokolomeliw: ‘Mesaya em toloke ding dim e, Sunbin-Got em bontem dim bakamin sua alenale kunum Elaisa esik iti toloke te!’, yangekabiliw a?’, dangeko, dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Dakalaliwi, e yan weng mak bokoyemomele: “Fein! Elaisa e esik teleko, mesesem wa kebe eisneng beelo iti kileleko, kiol kuw keloke ");
INSERT INTO bhl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","kate, yu kililina! Elaisa esik fein talse te. E talse kate, kawtiw i elo akokow kelewko, ikalem ibolow kuw geleweko, kukuw wa kuw kelewsiliw te. Beemdiw kunum waneng i Kawtiw Aul nakati wa kukuw kenemeko, ilum fian mak dunemokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yangei, Yesus em gelewkabiliw kunum bi em yangse weng be kiliko, dolon keliwete: Elaisa em dulum bokoyemse weng be kawtiw mali ilo ok da koyemok angom Sion kunum beem dulum bete bokoyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Beli, Yesus em akalem gelewkabiliw kunum biso amgu tikin koleweko, bit talsiliw ding dim bakate, i kunum waneng banban mak yetemsiliw kale. Yetemiwi, mak kunum mak Yesus em mit mewso teleko, katin bukbuk angesomi, bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Kamok Fian kutaka! Nem aul beelo kinkin ibolow kelewolewka! E wakamin fian kebomi, golu ais da, golu ok dakabe angomi, ilum fian ke alakabe kasike! ");
INSERT INTO bhl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ne elo kom kenggelewkabiliw kunum biim mit mewso debele teli kate, i ki keko, elo kilelew okminolinba keliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dangei, Yesus e weng mak gaaneko, bokolomele: “Ibo! Yu kunum waneng ibolow alew so, kukuw alew so kawtiw yutaka! Yu fein nanginba kebiliw kawtiw kasike, ne yulo gal keyemi te! Nomin ding ete ne yuso bomelii, yu nelo ilum mak so dukanembokoliw a?”, yangesomelei, alew elo bokolewomele: “Kate kom min be debele tala!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dangei, e min beelo Yesus em mit debele telei, Yesus e Seten-Ataanim em finik wa beelo weng kitil weng mak bokolewei, e aul beem dim teinbe be kolewse kasike, aul em wakamin fian be fein ken kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Anfel ete, akalem gelewkabiliw kunum imikel teleko, Yesus elo dakalalomeliw: “Nimtew angom ete aneng matil be num weng kiliko, kut uninba kebe ya?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Dangiwi, e yan weng bokoyemomele: “Yom fein ibolow be bolbol nam kasike. Yu kililina! Yom fein ibolow e ais dem gelgel mak emdiw kele tewe, yu ki keko, amgu kaleelo bokolewomeliw: ‘Ku fokminko, kom aneng koleweko, aneng mali kalo una o!’, dangiwi, e yom weng be fein kiliko, unoke te. Feinka! Yu nem weng kale kililina! Alik alik mesesem mesesem eisneng mak yu ki keko, fein dim duku keliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Beli, Yesus so akalem gelewkabiliw kunum iso alik biim Galili aneng ka makuw kakabisiliw ding kabalak e, Yesus e bokoyemomele: “I Kawtiw Aul nelo maka im teing dim da konemiwi, ");
INSERT INTO bhl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","i nelo neniwi, ne kuanoki te. Keko beli, yemamas kel ding kelei, ne iti baba teinoki te.”, yangse kale. Yangei, i kiliko, ibolow banban kesomi, ibolow ilum fian kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Beli, Yesus so akalem gelewkabiliw kunum iso i Kafelneam abiw mutuk fian kalo unsiliw kale. Uniwi, Sunbin-Got em am yol em tum win deyemin kawtiw teleko, Fita elo dakalalomeliw: “Yukalem kukuyemin kunum akal on kisol dukukabe ye?”, dangeko, dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Dakalaliwi, Fita e bokoyemomele: “No.”, yangse kale. Yangeko, im am kawtem unsiliw ding dim bakate, Yesus e elo dakalalomele: “Saimon, ku nimtew ibolow fukunewete: Kawin dim kaleem kamok fian im on kisol deibiliw ding dim bakate, i ikalem angin im on kisol kulayembiliw sako? Meni nanew kawtiw im on kisol kulayembiliw a?”, dangeko, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Dakalalei, Fita e yan weng bokolewomele: “I nanew kawtiw im on kisol kuluyemkabiliw te!”, dangei, e bokolewomele: “Fein weng nangew te. Kamok fian biim angin i on kisol dukayeminba kebiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kate mesik esik i nulo diwyetemeko, geeyemin weng mak bokoyemiw tewe, ku kame okmun kalo uneko, emisik kulew takam beem bontem bontak kelewolewka! Kelewsomi, beem bontem dim kel on kisol tum win mak atemokolew te. Atemeko, tum win be kuluko, kaso num yan be makuw bongguko, dulewolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Beem ding dim bakate, Yesus em gelewkabiliw kunum i em mit mewso teleko, dakalalomeliw: “Nimin kunum mak emisik keko, abiil tikin em gawman ding dim kel num kak kunum keloke a?”, dangomi, bonge bonge keko, dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dakalaliwi, Yesus e aul gel mak debele teleko, akalem mit mewso mo kolewsomi, bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Yusik kilele kililina! Mesik yom ibolow fukunin e aul gel beem ibolow fukunin emdiw keliw tewe, yu abiil tikin em gawman ding dim kalo nam uniw te. ");
INSERT INTO bhl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Feinka! Aul gel wiin banim atew keliw kunum waneng ite kuw abiil tikin em gawman ding dim kel wiin fian so kunum waneng kebokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nimin kunum waneng ite mak nakalem ibolow fukunsomi, kawtiw aul gel keleemdiw em banim kebiliw kawtiw ilo kuluko, dokoyemiw tewe, im kaneyemsiliw bakate nakalem elo akal kenemsiliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yangeko, weng makso bokoyemomele: “Nimin kawtiw ite mak ibolow fein nangbiliw kunum waneng gel mak ilo wa eisneng mak im mutuk tem daliwi, i beem mongom ete kukuw wa keliw tewe, kaneliw kawtiw biim kal ilum e fian fian kuw keloke te. Mali kawtiw mak teleko, tum fian sel kuluko, kanesiliw kawtiw biim gatak dokong keyemeko, ilo kuse okmun diw sel da koyemiwi, i kuaniw tewe, i ilum fian mak kulokoliw kate, im kanesiliw beem kulokoliw yan beem ilum be atin kuw ilum fian keko, elo bakilewoke te. ");
INSERT INTO bhl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kameem kawin dim alakabiliw ding dim kalakate, nem angin im fein ibolow de mit da koyem kemin eisneng fein toloke te. Kate, nimin kawtiw biim sen ete mali kunum waneng biim fein ibolow be de mit da koyemiwi, i sili sili kukuw keliw tewe, i ilum fian mak kulokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yu kililina! Yom yan o, teing o, be wa kukuw kemomin kuw keyembe tewe, yu kanele yan o, teing o, beelo goto kolew kemoliwka! Keko beli, yu teing makmak yan makmak kuw kesomi, finik so sunbin abiw kalo fein unokoliw kasike! Mesik esik yan alew teing alew biliwi, Sunbin-Got e yulo yemdeko, ais dong dim kalo da koyem keyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Beemdiw yom kiin e wa kukuw kemomin kuw keyembe tewe, yu kanele kiin be wolok kolewko, kuse fomdololiwka! Keko beli, yu kiin makmak kuw kesomi, finik so sunbin abiw kalo unokoliw kasike! Mesik esik kiin alew so biliwi, Sunbin-Got e yulo yemdeko, ais dong dim da kalo koyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Yukati kilelbi boliwka! Sunbin-Got em yemdakamin finik i aul gelgel biilo kilele yetebiliw kasike, yu kanelom aul gelgel biim wiin mit da koyem keyemokoliw te! Nimtew angom? Im dabalakamin finik bi diwkuw diwkuw Aatim em kiin dim mobiliw kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yangeko, kiskiw weng mak bokoyemomele: “Yu nimtew fukunbiliw a? Kunum mak siwsiw 100 kel kesomi, belei, deiw mak ding mak siwsiw makmak telinba kele tewe, siwsiw atebe kunum be nono keloke a? Feinka! E akalem wanin wanbiliw siwsiw 99 kel bi ka kel koyemsomi, telinba kele siwsiw makmak ‘Elo fenem uno!’, angeko, fein fenem unoke te. ");
INSERT INTO bhl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Fenem unesomi, elo atemoke ding kabalak e, kalfong fian mak keloke te. Feinka! Siwsiw makmak beem dulum keloke kalfong be mali siwsiw banban biim dulum kele kalfong be bakilewoke te. ");
INSERT INTO bhl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yu nem fein weng kale kililina! Siwsiw yetebe kunum beemdiw, nem abiil tikin kawtem alakabe Aatim e ‘Nem muluwel im mak be nam banime te!’, angakabe te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yangeko, iti bokoyemomele: “Kawkunum mak kulo kukuw wa mak kekeme tewe, kaso yukalem makuw uniwi, ku akalem ibolow sili sili nam be kilelewolewka! E kom weng be kiliko, falit ange tewe, ku kom kawkunum be iti kuluko, kaso ibolow makmak keko, bokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kate, kawkunum be kom bakalewbelew weng be kililinba kele tewe, ku makmak kunum akal ken, alew kunum akal ken, ilo kulu yemde tololewka! Kulu yemde teleko, alik alik yu kanese kawkunum beem mit mewso unoliwka! Nimtew angom? Sunbin-Got em fut tem e bokolomele: Alew kawtiw akal, alemsal kawtiw akal, i bongguko, bokolomeliw: ‘Nu kiinwala suluw te!’, angiw tewe, ilum diwatebabiliw kunum ikati ‘Fein kai!’, yangoliwka!’, angse kasike. ");
INSERT INTO bhl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Keko beli, kawkunum be yom bakalewbiliw weng be kililinba kele tewe, ku elo debele uneko, sios kunum waneng im kiin dim kel mo kolewoliwka! Kolewiwi, e alik alik im weng bakati kililinba kele tewe, yu elo Sunbin-Got em angin im ibik biliw kawtiw so, kawtiw im teing dim tum win kulamin kunum wa kukuw so kawtiw iso, alik alik biimdiw atemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yu kilele kililina! Yu kawin dim kale kel mali kawtiw im kukuw diwyemeko, im kukuw beelo ‘Ken te!’, angeko, mali im kukuw e ‘Wa te!’, angeko, dangiw tewe, abiil katem alakabe Sunbin-Got be yom bakayembiliw weng be fein kili atemeko, akati gelewoke te. ");
INSERT INTO bhl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kunum alew mak kawin dim ka kel bomeliwi, ibolow ki makmak keko, Sunbin-Got elo dakalomeliw: ‘Mesesem mak duyema!’, dangiw tewe, fein, nem Aatim e im gaanin be kiliko, fein duyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Feinka! Kunum waneng alew akal, kunum waneng yemamas kel akal, i nem wiin dim kel wensanbiw tewe, nakati im kanebiliw mutuk ka kel iso makuw boki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yangei, Fita e teleko, Yesus elo dakalalomele: “Kamok Fian kutaka! Nawkunum mak nelo kukuw wa mak keneme tewe, ne nomin kel ding ete em kukuw wa be kuluko, sak misim kuw kolewoki a? Ben kel ding ete ki keloke, bani?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Dangei, Yesus e yan weng bokolewomele: “Ben kel ding ba kate, ku em kukuw wa be ben kel ding em 70 dim ete sak misim kuw kolewolewka! ");
INSERT INTO bhl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Alik yu fakam weng kale kilele kililina! Abiil tikin em gawman ding dim em kanekabe kukuw e kanekote kamok mak em kukuw emdiw te. Kamok be akalem weng afak kunum iso tum win yan kilelomin talse te. ");
INSERT INTO bhl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Keko beli, on kisol iti fu iti fu banban kuw yan kunum mak debele talsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Debele talsiliw kate, e ki keko, em on kisol yan kese be atin kuw atin kuw nam yan dukuse kasike, kamokim be mali ilo bokoyemomele: ‘Yu kunum beso, akalem aul waneng iso, mesesem eisneng so, alik alik bi nanew kawtiw iso wensomi, em yan be dukulina!’, yangse te. ");
INSERT INTO bhl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yangei, yan kayak be em yange weng be kilisomi, kamok beem mit mewso katin bukbuk angeko, bokolewomele: ‘Kamok kutaka! Ku nelo kinkin kenemeko, ding fenselew kano, ne kom on kisol yan kesi be fen kemeko, kulo yan alik alik be dukukemoki te.’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dangei, kamokim be akalem weng afak kunum beelo kinkin kelewsomi, yan be sak misim keko, kolewse te. ");
INSERT INTO bhl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Keko beli, weng afak kunum be kut unesomi, akalem awkunum teingabi kel tum win yan kuluse kunum mak elo atemeko, elo gololo kelewsomi, guel takmel keleweko, bokolewomele: ‘Ku nem mesesem eisneng yan kenemselew eisneng beem yan fongate akate dukula!’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dangei, awkunum be yan weng bokolewomele: ‘Ku nelo kinkin kenemeko, ding fenselew kano, ne kom on kisol yan kesi be iti fen kemeko, kulo yan dukukemoki te.’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Dangse kate, kunum be ‘Bayo!’, dangeko, kitil keko, elo sok am tem ka kel da koleweko, ‘Ku ka kel bomelewi, fe e, nem yan be dukunemokolewka!’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Dangei, mali awkunum i weng afak kunum beem kukuw wa be atemeko, ibolow banban kesomi, ikalem kamok elo kanese sang be bakalew unsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Bakalew uniwi, kamok be weng afak kunum beelo iti gaalewei, e telei, e elo bokolewomele: ‘Weng afak kunum wa sel kutaka! Kusik nelo katin bukbuk angeko, amemewi, ne kinkin kekemsomi, kom yan e sak misim kokemsi te. ");
INSERT INTO bhl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ne kinkin kekemsi kate, ku nimtew angom ete kawkunum beelo kinkin kelinba kelewbelew a?’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dangeko, kaisuw fian kesomi, elo yen feiw koyemeko, betbet fian duyemkabiliw kunum im teing dim da koleweko, ‘Iti yan alik alik be dukulolewka!’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yu kilele kililina! Kanelew emdiw, nem Aatim akati ikalem awkunum kumel im kukuw wa sak misim kulu koyeminba keliw kawtiw ilo kaneyemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yangesomelei, i Galili aneng iti kolewsomi, Yoldan bang dikeko, ok mali Sudia aneng fian kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Unbiliwi, kunum waneng banban i yenggelew teliwi, e wakamin kal wanin kawtiw banso banso kilelyemeko, wokminoyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Wokminyembelei, mali Falisi kunum mak telesomi, Yesus elo kiskis weng mak bokoko, dakalalomeliw: ‘Kunum mak ki keko, akalem ibolow kuw gelewsomi, akalem kalel buulo sak koumoke ye?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Dangiwi, e yan weng bokoyemomele: “Yu Sunbin-Got em fut tem beem weng teing bokoko, ateminba kekabiliw sako? Sua kel mesesem kilkese ding kabalak e, Sunbin-Got e kunum kelew, waneng keum duku koyemko, ");
INSERT INTO bhl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","bokolomele: ‘Kunum kumel i ikalem auk kumel so aliwol kumel so koyem uneko, ikalem kalel kumel so teinsomeliwi, i kal anggil makmak kekabiliw te.’, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Angse kasike, kunum so waneng so i debele debele keliw tewe, kais yemkal bi kal anggil makmak kuw kekabiliw te. Sunbin-Got e kanelewse kasike, kawtiw yu kanelom alwol keleweko, yemkal biilo iti okiyem kemokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yangei, isik bokolewomeliw: “Kate Moses e bokoyemomele: ‘Nimin kunum ite mak ikalem kalel kumel ilo koyemomin ibolow keliw tewe, i koyemkemin fut anung mak bosomi, ilo dukayemboliwka! Duyemsomi, fein, ilo koyem keyemoliwka!’, angse kale.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Dangiwi, Yesus e yan weng bokoyemomele: “Kilkese ding kabalak e, Sunbin-Got e ‘Kanelina!’ anginba kese kate, yukalem ibolow fukunin kau beem dulum elote esik weng be Moses elo dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yangse kate ne yulo fein weng mak bokoyemite: Mak kunum mak em osow kelinba kebu waneng buulo kulu koumsomi, nanew waneng mak kule tewe, kanekabe kunum be osow kukuw kebe kasike, e sen so te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yangei, Yesus em gelewkabiliw kunum i akalem yange weng be kilisomi, bokolewomeliw: “Yakai! Keko kasike, kunum nu fon kunum kesomi, waneng mak nam kulamuw tewe, nu ken kuw bokoluw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Dangsiliw kate, Yesus e yan weng bokoyemomele: “Feinka! Sunbin-Got e angin fong gel kuw kitil duyemei, i nem kukuyemin weng kaleem mongom be kal kelokoliw te. Yu kilele kililina! ");
INSERT INTO bhl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mali kunum im auk dukulu ding dim bakate, i wakamin so kesiliw kasike, im tanbel keliw ding dim kabalak e, i ki keko, debele debele kemin ibolow e banim kekabiliw te. Keko beli, kawtiw i mali kunum mak im awkolow wolyemiwi, ikati waneng kulomin ibolow banim kekabiliw te. Kate mali kunum i abiil tikin em gawman ding dim beem dulum ibolow fukunin fian kuw kelewsiliw kasike, ikati waneng mak kulinba kekabiliw te. Ibolow tem fukalel biliw kawtiw yutaka! Yu weng kale kilele kililoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yangeko beli, mali kawtiw mak ikalem aul biilo Yesus em mit mewso yemde teleko, bokolewomeliw: “Ku Sunbin-Got eso weng bokoko, kom teing e num aul kaliim dim dukuko, bamki duyema!” dangsiliw kale. Dangiwi, Yesus em gelewkabiliw kunum i biim kaneliw be ibolow keyeminba kesomi, “Be ayem te! Kika!”, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yangiwi, Yesus e ilo bokoyemomele: “Yu kanelom kanemokoliw te! Aul bi nem mit mewso yemde teloliwka! Nimtew angom? Mali aul gel ikatetew keliw kawtiw ite kuw abiil tikin em gawman ding dim kalo fein unokoliw kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yangeko, em teing im dim dukuko, bamki duyemse kale. Duyemeko, aneng ka iti kolewko, unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Beli, mak kunum mak Yesus em mit mewso teleko, elo dakalalomele: “Kukuyemin kunum kutaka! Ne nono ken kukuw mak kesom ete, sunsun kuw bin finik be kuloki a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Dangei, Yesus e yan weng bokolewomele: “Ku nimtew angom ete nelo ken kukuw beem mongom dakalakabelew a? Sunbin-Got ete kuw kukuw ken so beem mongom kayak ete te! Ku Sunbin-Got em Moses elo dulewse kukuyemin weng bete kuw gelewew tewe, finik so sunsun bin kulukolew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dangei, kunum be iti dakalalomele: “Nono em kukuyemin weng ete nangew a?”, dangei, Yesus e bokolewomele: “Yu kanelom kawtiw ilo sak yemokoliw te! Yu kanelom osow kemokoliw te! Yu kanelom yakut kemokoliw te! Mali kawtiw mak yulo dakalaliw tewe, yu kanelom dasuw weng bakayem bokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kauk kumel so kaliwol kumel so biim afak kel bomi, wangweng keyemboliwka! Yukalem ibolow fian kelewkabiliw bakate iti yom mewso biliw kawtiw mali ilo akati ibolow fian dukayemboliwka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Dangei, e yan weng bokolewomele: “Diwkuw diwkuw ne kukuyemin weng be alik gelewkabi kate, nalem sawa weng ete ne sukum kebi yake?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dangei, Yesus e weng be kiliko, kunum beelo yan weng bokolewomele: “Kukalem ete ‘Ne fein ati kiol kuw kunum kelo yo!’, angew tewe, kame kom mesesem on kisol alik be wensomi, alik alik be em banim kawtiw ilo amen amen keyemolewka! Keyemew tewe, sow e, yu abiil tikin em on kisol fein kulokolew te. Kaneleweko, ku nelo nenggelolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dangei, em so kunum be Yesus em dange weng be kiliko, akalem on kisol banban beelo fukuneko, ibolow tiaktiak kesomi, ilum fian keko, unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Unei, Yesus e akalem gelewkabiliw kunum biilo bokoyemomele: “Yu kilele kililoliwka! Tum win on kisol so kunum i ‘Nu abiil tikin em gawman ding dim kalo uneyemoka!’, angiw tewe, i unomin bukeloliwka! ");
INSERT INTO bhl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Feinka! Kamel samal fian sel e ilim benemin sil tem be unomin bukekabe kate, on kisol so kunum mak e abiil tikin em gawman dim elo unomin e kakunin fian kesomi, bukelomeka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yangei, akalem gelewkabiliw kunum bi em yange weng be kiliko, yol angeko, dakalalomeliw: “Ibo! Kate kante sunsun finik be kuluko, diwkuw diwkuw boke a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dangiwi, e ilo kiin doung yetemsomelei, ilo yan weng bokoyemomele: “Kunum waneng im kitil e fong gel kasike, imikel ki keko, nam keliw te. Kate, Sunbin-Got em kitil e fian kebe kasike, alik alik eisneng mak e ki ke kemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yangei, Fita e elo bokolewomele: “Kamok kutaka! Nu nukalem mesesem eisneng alik alik be koleweko, kulo kenggelewkabuluw kasike, nu nono yan ete kulokoluw a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Dangei, Yesus e akalem gelewkabiliw kunum biilo yan weng bokoyemomele: “Ne fein weng yulo bokoyemi te! Sow em toloke ding dim kabalak e, Sunbin-Got e kawin dim kale so, kaleem alik alik eisneng beso, makuw kikis keloke te. Beem ding dim bakate, Kawtiw Aul ne wiin fian kulusomi, kamok keko, auk so kitil so teinkemin ayem dim kel teinoki te. Teinii, yukati kalun kel teinkemin abin ayem beem dim teinsomi, Isalael kunum waneng im kalun kel kunum mongom im kak kunum kesomi, ilo diweko, yan duyemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Duyemiwi, nimin kunum waneng ite mak nem ibolow fukunin gelewko, akalem am o, awkunum o, waneng aul o, alew o, auk o, muluwel o, musun o, alik alik bi koyemiw tewe, i atin kuw fian fian mak so kulusomi, sunsun bin finik so kuluko, diwkuw diwkuw bokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yu kilelbi boliwka! Mali kame wiin so keliw kawtiw i sow em toloke ding dim e, wiin banim baluw kawtiw kelokoliw kate, kame em ding dim kale, mali wiin banim baluw kebiliw kawtiw i sow em ding dim e, wiin fian so kawtiw kelokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yu kililina! Abiil tikin em gawman ding dim em kaneloke kukuw e kunum mak kaleemdiw te. Kunum be on kisol so, wain musun fian so kunum kese kale. Kesomelei, kutim danei, e uneko, ‘Musun kaleem aluwbamin kunum mali ilo fenem uno!’, angeko, unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Uneko, ‘Aluwbam unuma!’, angbiliw kawtiw mali mak yetemeko, im dim unei, eso iso weng ki dukusomi, bokolomeliw: ‘Makmak ding em aulamin beem yan bakate te.’, angsiliw kasike, i kalfongeko, akalem musun aluwbam unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Keko beli, sow ete, musun kayak be iti uneko, kawtiw im wensankabiliw dim ka kel sak mobiliw kunum mali mak yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yetemeko, bokoyemomele: ‘Yukati kame uneko, nem wain musun elo aluwiw kano, ne yulo yan kiol kuw duyemoki te.’, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yangei, i kiliko, fein kalo aluwbam unsiliw kale. Beli, ataan mutuk doung ange ding akal, ataan fuwkel ange ding dim akal, e iti uneko, iti aluwbamin kunum mali mak yemde talse kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Fefe e, kuinkuin kele ding kabalak e, e iti kawtiw im wensankabiliw dim uneko, iti sak mobiliw kunum mali mak yetemse kale. Yetemeko, biilo dakalalomele: ‘Wee yutaka! Nimtew angom ete yu sak kale kel mobiliw a?’, yangei, ");
INSERT INTO bhl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","i yan weng bokolewomeliw: ‘Mak kunum mak nulo aluwbamin mak duyeminba kele kasike, kale kel sak mobuluw te.’, dangsiliw kale. Dangiwi, e bokoyemomele: ‘Kame yukati nem musun kalo aluwbam unina!’, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Keko beli, ataan tem dokong angomin kis kele ding kabalak e, musun beem kayak be akalem aluwbamin kunum im yetebin kunum elo bokolewomele: ‘Kame ku aluwbabiliw kunum alik alik ilo gaayemewi, i teliw kano, ikalem yan duyemolewka! Ibik teleko, aluwsiliw kunum bite emisik yan dukayemsomi, emisik teleko, aluwsiliw kunum ilo ibik elote yan duyemolewka!’, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dangei, e ibik ete talsiliw kawtiw ilo gaayemei, i teleko, makmak ding em aulsiliw beem yan atin alik alik be kulusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kulusomeliwi, emisik telesomi, aluwsiliw kunum i ibolow fukunomeliw: ‘Num kulokoluw yan e mali biim yan bakileweko, fian keloke sako!’, ange ange kesiliw kale. Kate, im yan kulusiliw yan be emisik yan kulusiliw yan beem ki ki kuw kesomi, makmak ding em aulsiliw beem yan atin alik alik bakatetew kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kesomelei, i weng nutnut weng bokolew bokolew kesomi, musun kayak beelo kaisuw keleweko, bokolewomeliw: ");
INSERT INTO bhl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Mali kunum kali ibik teleko, sukum ding gel kuw aluwsiliw kate, biim yan e nukalem yan makuw ki kuw duyemew te! Kate nusik ataan atul so aluwbamin fian kuw bukekabuluw te!’, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dangiwi, e emisik teleko, aluwse kunum mak elo yan weng bokolewomele: ‘Wee nakunum kutaka! Emisik kabalak e, kaso nukalem weng ki kesomi, bokolomeluw: ‘Aluwbamin beem yan e ki kuw bakate te.’, angsuluw kasike, ne kame yan kiol kuw dukemi te. ");
INSERT INTO bhl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Ku kom yan dukemi be kuluko, de una! Ne nakalem on kisol beem dulum elote ‘Nomin eisneng makuw kelo yo!’, angi tewe, nakalem ibolow ete kuw kelewboki kasike. Nesik mali aluwbiliw kunum biilo kukuw ken kuw keyemi tewe, kusik beem mongom ete mesem ibolow kenembelew a?’, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yu kilelbi kililina! Kameem ding dim kale, mali kawtiw wiin fian so kawtiw kebiliw kate, sow e, isik wiin banim keko, baluw kawtiw kelokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Beli, Yesus so, akalem gelewkabiliw kunum iso alik alik biim Selusalem abiw mutuk fian kawtem unomin unbiliw ding kabalak e, Yesus e akalem kalun kel gelewkabiliw kunum bite kuw bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kame, nu Selusalem abiw mutuk fian kawtem unbuluw te. Ka unuwi, maka kawtiw i Kawtiw Aul nelo nemdeko, Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum iso, alik alik biim teing dim da konemsomeliwi, i nelo geenemeko, ‘Kanemele beem yan be dukemuw kano, kuanolewka!’, nangokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nangiwi, i nelo Isalael kawtiw im ibik biliw kawtiw im teing dim da konemiwi, i weng minembomi, nang debet sok so nen feiw konemeko, ais dim sil biki neniwi, ne kuanoki te. Kuanii, yemamas kel ding kabalak e, Sunbin-Got e nelo iti namkalfoloke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Beem ding dim bakate, Sebidi em kalel so, Sebidi em muluwel alew biso, yatel i Yesus em mit mewso teliwi, auk u katin bukbuk angeko, bokolewomelu: “Num mesesem mak kulo dakalakam talbuluw be ku nulo duyemolewka!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Dangui, Yesus e bokoumomele: “Nimtew em dulum elote nangbelew a?”, wangei, u yan weng bokolewomelu: “Kom gawman ding dim kabalak e, ku nem muluwel kali mak e kom yuk teing kalo, mak e kom awan teing kalo ‘Yu kale teinina!’, yangeko, wiin fian mak duyemolewka!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dangui, e um wange weng be kiliko, yan weng yatel ilo bokoyemomele: “Yukalem dabalakamin beem mongom ete yu akokow kebomi, dakalakabiliw te! Yu ki keko, nem kuanomin, betbet ilum kulomin kemi kale neso yuso makuw kuluko, daolokoluw sako?”, yangei, yangdel i yan weng bokolewomeliw: “No, aso nu ki keko, daolokoluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Dangiwi, e aso ilo bokoyemomele: “Fein! Kaso yukati kuanomin, betbet ilum fian mak kulokoliw kate, ne ki keko, kunum waneng mak ilo ‘Ku nem yuk teing dim kalo, mali elo ku nem awan teing dim kalo teinoliwka!’, yangeko, bokoyeminba keloki te. Nelo namdase Aatim ete kuw kitil so auk so keko, akalem beem dulum elote memen keyemkabe kunum waneng mali biim abin be duyemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yangei, mali king kel gelewkabiliw kunum bi yatel biim dakalakemin weng be kiliko, aso ilo digaka keyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Keyemiwi, Yesus e akalem gelewkabiliw kunum alik alik biilo gaayemei, i teliwi, e ilo bokoyemomele: “Yu kal keliwete: Kawin kaleem emisik kamok so, kak kunum so, i kawin kaleem kukuw geleweko, atul nam kesomi, mali kawtiw biim afak kuw koyemkabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Koyemkabiliw kate, yukalem ete kanelom biim kanekabiliw kukuw bakati gelewokoliw te! Yu kililina! Nimin kunum waneng ite mak ‘Wiin fian so kamok keluma o!’, angiw tewe, i mali kawtiw im sak weng afak kunum waneng keboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Feinka! Nimin kunum waneng ite mak ‘Nute emisik kamok fian keko, buma!’, angiw tewe, i alik alik im sak weng afak kunum waneng keboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yu nem kukuyemkabi kukuw be atemeko, yukati gelewemoliwka! Kawtiw Aul ne teleko, ‘Mali kawtiw i nelo dokonemoliwka!’, angomi, telinba kesi kate, ne teleko, kawtiw banban ilo dokoyemsomi, biim abin kuluko, kuanyemoki kasike, isik sunsun bin finik so bin kuluko, diwkuw diwkuw bokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yangeko, unsomeliwi, Yesus so akalem gelewkabiliw kunum iso biim Seliko abiw mutuk fian iti kolewsiliw ding bakate, kunum waneng banban mak Yesus elo anggelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Anggelewiwi, kiin sukul kunum alew mak deiw benggew dim ka kel teinbomi, kawtiw im “Yesus e deiw kale unbe kai!”, ange ange kesiliw weng be kilisiliw kale. Kilisomi, gaanin fian kuw mak gaanomeliw: “Kamok Fian Debit mulkis kutaka! Ku aso nulo kinkin ibolow keyema o!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dangiwi, unbiliw kawtiw bi im gaanin be kiliko, kunum biilo sakalala yangeko, bokoyemomeliw: “Bontem net kelina!”, yangsiliw kate, aso i iti weng fian kuw gaanomeliw: “Kamok Fian Debit mulkis kutaka! Ku aso nulo kinkin ibolow keyema o!”, dangeko, gaanbiliw ki kuw kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Keliwi, Yesus e moko, aso ilo gaayemei, i teliwi, e aso ilo dakalako, bokoyemomele: “Kaso yu ne nono ‘Keyemoka!’, nangomi, gaanbiliw a?”, yangeko, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dakalalei, i yan weng bokolewomeliw: “Kamok Fian a! Num kiin kale gol koyema!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dangiwi, e aso ilo kinkin keyemsomi, akalem teing deeko, im kiin dim dukulei, sin tew kame tew im kiin be bamtak angeko, kiin gol koyemei, aso i Yesus elo gelew unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Beli, fe e, Yesus so, akalem gelewkabiliw kunum iso, i Selusalem abiw mutuk fian em mewso alenale abiw gel Betfage kalo talsiliw kale. Abiw be Oliw amgu em mit mewso kese kale. Ka kel somi, Yesus e akalem gelewkabiliw kunum alew mak ilo yemdeko, ");
INSERT INTO bhl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","bokoyemomele: “Kaso yu uneko, abiw kiin fen unbomeliwi, atemiwete: Donki samal men so auk so nang so gibiliw mak beliwi, yetemokoliw te. Yetemeko, nang bamok sileleko, samal bi nelo denem tololiwka! ");
INSERT INTO bhl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mak kunum mak weng mak bokoyeme tewe, kaso yu yan weng kale bokolewomeliw: ‘Nukalem Kamok Fian e nulo bokoyemolele: ‘Kaso yu uneko, samal biilo kulu yemde telina!’, yangse kasike, nu ilo deim tuluw te.’, dangoliwka! Dangiwi, e yom bokolewiw weng be kiliko, ibolow ki keyemeko, samal biilo yemdaloke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sua kel Sunbin-Got em bontem dim bakamin kunum mak weng kale bokose kasike, kame weng bokose weng be fein ki kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","E bokolomele: “Yu Saion abiw mutuk fian kasel ilo weng kal ken mak bokoyemomeliw: ‘Yukalem Kamok Fian be yukalem dim elo toloke te! E kunum wiin banim kunum atew keko, donki men manmon dim kel teineko, telei, yu elo atemoliwka!’, yangina!”, angeko, fut tem bose kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Keko beli, gelewkabiliw kunum aso bi uneko, Yesus em yangse weng be fein gelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gelewsomi, aso im donki men so auk so bi kuluko, yemde tasliliw ding kabalak e, gelewkabiliw kunum bi ikalem ilim tiaktiak be gulusomeliwi, donki alew biim mulkun dim tikoko, falulu keliwi, Yesus e men beem mulkun dim teineko, unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Unbelei, mali kawtiw banban mak ikati ikalem ilim tiaktiak guluko, deiwkim dim kel dukusomeliwi, mali kawtiw mak i ais teing balbil so fakulu dukusomeliwi, abin kon tiko koliwi, ");
INSERT INTO bhl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yesus e beem tikin dim mo moko, unse kale. Unbelei, emisik unbiliw kawtiw so, ibik talbiliw kawtiw iso, alik alik i bonggusomi, kalfongeko, gaanomeliw: “Osana! Kamok Debit em mulkis fian beem wiin daoluma! Sunbin-Got e akalem wiin dim talbe emisik kamok fian beelo bamki fian dulewoka! Alik nu abiil tikin katem alakabe Sunbin-Got beem wiin fian daoluma!”, ange ange keko, gaansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Keko beli, Yesus e uneko, Selusalem abiw mutuk fian kawtem telei, abiw mutuk fian kasel bi elo atemeko, ikalem kuw dakale dakale kesomi, bokolomeliw: “Yake ibo! Kunum kale kante a?”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kesomeliwi, eso talsiliw kunum waeng bi yan weng bokoyemomeliw: “Be Yesus, Sunbin-Got em bontem dim bakamin kunum ete te. E Galili aneng fian em abiw mutuk Nasalet em kayak ete te.”, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Keko beli, Yesus e uneko, Sunbin-Got em am yol aneng ka kel atemete: Mali kawtiw mak mesesem eisneng mak webomeliwi, iti mali kawtiw mak i nanew aneng im tum win kisol alwol kelew kelew kebomeliwi, alik alik i kanebiliw, yetemse kale. Yetemomelei, e kaisuw fian keko, tum win alwol kelew kelew kebiliw kawtiw biso, awon webiliw kawtiw biso, kawtiw alik alik biim mesesem mesesem dukukebiliw eisneng be dolo dolo walel koyemeko, kawtiw ka biliw kawtiw alik alik ilo yenbakalei, i kut fon unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Fon uniwi, e ilo weng mak bokoyemomele: “Sunbin-Got em fut tem kel weng be bokolomele: ‘Nem am kale Sunbin-Got neso weng bakamin am ete te.’, angse kate, yu ‘Am kale yakut kawtiw im yakut am atew kelewbiliw te!’, angse eli!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesus e am yol ka bomi, yangse ding bakate, kiin sukul nam kawtiw so, yan yout nam kawtiw so, alik alik i em mit mewso teliwi, e alik alik ilo kilelyemei, i kensiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kensiliw kate, Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum iso, alik alik i elo digaka kelewsiliw kale. Nimtew angom? I atemeko, kililiwete: Yesus em kitil so auk so eisneng be kaim dim kuw dayemse ding kabalak e, am yol aneng beem dim e aul gelgel alik alik i gaanin fian kuw bokolomeliw: “Debit em mulkis fian beem wiin daoluma o! Daoluma!”, ange ange kesomi, gaansiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kaneko beli, i Yesus elo dakalomeliw: “Yesus kutaka! Ku im gaanbiliw weng kale kililinba kebelw sako? Ku ilo ‘Kimi angina!’, yangoleka!”, dangsiliw kale. Dangiwi, Yesus e im weng be kiliko, bokoyemomele: “No, ne im gaanin kilibi kate, yu Sunbin-Got em fut tem bosiliw weng kale teing bokoko, ateminba kebiliw sako? Aul gelgel biim dulum elote bokoyemse weng be kame ki kebe kasike. Fut tem be bokolomele: ‘Aul gelgel so, aul beliw so, isik kom wiin daokembokoliw te.’, angse kasike!”, yangeko, yan weng dukuyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Dukuyemeko, Yesus e abiw mutuk fian be iti koleweko, mililiw bakate Betani abiw fong gel kalo uneko, ka kel akalse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Beli, iti aneng danei, kutim mililiw kuw akate, Yesus em iti Selusalem abiw mutuk fian kalo unse ding bakate, e yemen tew fian mak teinse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yemen tew teinomi, atemete: Fik ais sen mak deiw benggew dim ka kel belei, e atemsomi, beem mit mewso uneko, atemete: “Ebe! Atin kuw dem banim te! Kon men sel kuw kebe kai!”, angeko, elo yakok weng mak bokolewomele: “Ku kanelom iti dem mak gilalokolew te!”, dangse kale. Dangei, fein, sin tew kame tew kelei, ais be galgel kesomi, tiow kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kesomelei, Yesus em gelewkabiliw kunum bi kanebe eisneng be atemeko, yol baba angeko, bokolomeliw: “Ebe! E nono kelei, ais be fongate akate gete ya?”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Angiwi, Yesus e yan weng bokoyemomele: “Yu nem weng kale kilele kililina! Yu ibolow fukunin alew kelinba kesomi, fein ibolow kuw keliw tewe, yukati nem kanele eisneng bakatetew kemokoliw te! Yu ki keko, amgu kaleelo bokolewomeliw: ‘Kame, ku kang angeko, okmun fian elo kasilolewka!’, dangiwi, e yom dangbiliw weng be kiliko, fein gelewoke te. ");
INSERT INTO bhl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Feinka! Yukalem Sunbin-Got eso weng bokoliw ding dim e, yu fein ibolow kuw kesomi, dakalaliw tewe, e yom dakalabiliw weng be kiliko, mesesem be yulo fein duyemoke te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yangeko beli, Yesus so, akalem gelewkabiliw kunum iso, i iti Sunbin-Got em am yol aneng kawtem unsiliw kale. Uniwi, Yesus e kunum waneng kale biliw biilo kukuyemse kale. Kukuyembomelei, Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, Suda kawtiw im kak yetebiliw kunum iso, alik alik bi em mit mewso teleko, elo dakalalomeliw: “Wee kutaka! Ku kanem wiin so kanebelew a? Kante kitil dukembe a? Kante ‘Ku aluwa!’, kangei, ku aluwbabelew a?”, dakaleko, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Dangiwi, Yesus e yan weng bokoyemomele: “Nakati yulo dakalalika! Yu nem dakalaloki weng be yan weng bokonemiw tewe, nakati yom dakalaliw weng beem yan weng kiol kuw bokoyemoki te. ");
INSERT INTO bhl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yu nem dakalakemin be kililina! Kawtiw ilo ok da koyemkebe kunum Sion be Sunbin-Got em ibolow fukunin geleweko, kaneyemse sako? Bani, e kawtiw im ibolow fukunin kuw gelewko, kaneyemse sako? Yu yan weng be nangoliwka!”, yangse kale. Yangei, i ibolow tiaktiak fukuneko, ikalem mutuk kel bokolomeliw: “Nu bokolomeluw: ‘Sion e Sunbin-Got em ibolow gelewse kai!’, danguw tewe, e nulo dakalalomele: ‘Kate, nimtew angom ete yu akalem weng bokoyemse weng beelo ‘Fein!’, danginba kebiliw a?’, yangoke te. ");
INSERT INTO bhl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kate, nu elo bokolewomeluw: ‘E kawtiw im ibolow kuw geyemse kai!’, danguw tewe, nu kunum waneng im awan finganokoluw te. Nimtew angom? Kawtiw alik alik i ibolow fukunomeliw: ‘Sion e Sunbin-Got em bontem dim bakamin kunum bise te!’, angakabiliw kasike!”, ange ange kesomi, ");
INSERT INTO bhl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yesus elo yan weng bokolewomeliw: “Nu dolon kelinba keko, akokow so te!”, dangsiliw kale. Dangiwi, e bokoyemomele: “Kasike nakati yulo ‘Kanem wiin dim telii, kante nelo wiin so kunum kenemse!’ weng be nam yangi te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yangeko, iti kukuyemin weng mak bokoyemomele: “Yu nem fakam weng kale kiliko, yom ibolow fukunin be bokonemina! Mak kunum mak muluwel alew so alenale kale. Keko beli, e emisik min elo bokolewomele: ‘Ku kame wain musun elo uneko, aluwbam una!’, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Dangei, min be gal keko, yan weng bokolewomele: ‘Bayo! Ne nam uni o!’, dangse kate, ibik ete, e iti ibolow tem tem alwol kesomi, musun kalo fein aluwbam unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Keko beli, alew e emteben aul beelo beem fik elo dangse weng ki akate bokolewse kale. Bokolewei, ning be kiliko, ‘No, kenka. Unoki te.’, dangse kate, e gal keko, aluwbam uninba kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kaneko beli, nimin aul ete alew em yangse weng be fein wosuko, gelewse a?”, yangeko, dakalase kale. Dakalalei, i Yesus elo yan weng bokolewomeliw: “Emisik min ete te!”, dangsiliw kale. Dangiwi, e bokoyemomele: “Kame yu nem bokoyemi weng kale kilele kililina! Kawtiw im tum win kulamin kunum kukuw wa so kawtiw so, deiwkim weneng iso, alik alik bi yomisik keko, abiil tikin em gawman dim kalo fein unokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nimtew angom? Sion esik teleko, yulo kiol kuw kukuw kukuyemse kate, yukalem ete ‘Fein!’, danginba kelewsiliw te. Kate, kawtiw im tum win kulabiliw kukuw wa so kunum biso, deiwkim waneng biso, ite kuw Sion em kukuyemin weng be kiliko, elo ‘Fein!’, dangsiliw te. Dangiwi, yu mali biim kiol kuw kukuw atemiw kate, yukati yom ibolow sili sili nam beem kukuw wa be kolinba kesomi, ‘Fein!’, danginba kekabiliw kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yangeko, iti weng mak bokoyemomele: “Alik yu nem fakam weng kale kilele kililina! Musun sen kayak kunum mak wain musun bilal mak kaise te. Kaisomi, e wati mak fokosomi, musun be falal amol ke kolewsomi, wain dem kuluko, ok dubelet keleweko, dem emikel ok emikel amen amen kolewkabe kawin tem mak dikeko, fe e, mali musun atemin kunum mak im am tiak mak keko, gese te. Gesomi, musun be elo atebin kunum mali mak im teing dim da koyemsomi, aneng be koleweko, singam aneng mak elo unse te. ");
INSERT INTO bhl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Keko beli, wain musun beem dem gilase ding kabalak e, e akalem weng afak biliw kunum mali mak akalem musun dim elo yemdalei, i uneko, atebin kunum biilo bokoyemomeliw: ‘Musun beem sen kayak e nulo yemdalei, nu wain dem on kisol beem anung be deim talbuluw te.’, yangsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Yangiwi, atebin kunum bi kalan kunum biilo kuluko, mak elo an feiw kolewsomi, mak elo aliwi, e kuanei, fefe kunum beelo tum so mutum fakaleko, aliwi, esik akati kuanse te. ");
INSERT INTO bhl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Keko beli, musun sen kayak be akalem weng afak biliw kunum biim kaneyemsiliw sang be kiliko, iti mali weng afak kunum makso makso yemdalei, i unsiliw kate, musun atebiliw kunum bi weng afak kunum biim imisik teliw kunum biimdiw keyemeko, alik alik ikati yensiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Keko beli, musun sen kayak kunum be ibolow fukunomele: ‘Nakalem kunum aul akate dabalalii, e unei, i elo atebomi, em afak elo angeko, em weng gelewokoliw te!’, angse kasike, e min beelo dabalalei, e fein unse te. ");
INSERT INTO bhl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Unei, musun atebin kunum bi min beem tele be atemsomi, i weng bokolew bokolew kelomeliw: ‘Fein! Kame talaka! Tele kunum beem alew be kuanei, min besik em abin kuloke te. Kasike, nu elo asomi, nusik wain musun kale atin kuw kululokoluw te!’, ange ange kesiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kesomi, min beelo debeleko, musun sin dim elo koleweko, elo aliwi, e kuanse te. ");
INSERT INTO bhl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kame, alik yu nimtew ibolow fukuniwete: Wain musun sen kayak beem musun dim kalo toloke ding kbalak e, e nono keyemoke a?”, yangeko, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dakalalei, i yan weng bokolewomeliw: “Musun sen kayak be teleko, wa kunum biilo betbet fian kuw duyemeko, ilo yenei, i kuanokoliw te. Kuaniwi, wain musun kale, nanew atebin kunum ilo duyemoke te. Keko beli, atebin kunum bi kamok beem wain dem on kisol anung fein duyemokoliw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Dangiwi, Yesus e bokoyemomele: “Nimtew angom ete Sunbin-Got em fut tem bokolomele: ‘Mali kawtiw mak am gebomeliwi, am kun mak diw atemiw ete, ‘Kale beit nam te!’, angeko, kolewsiliw kate, am em kamok keko, am kayak kunum e am kun be atemete: ‘Am kun ilkul kun kitil te!’, angeko, elo kaiw kun mutuk mo kolewse kale. Besike, Kamok Fian ete kelewsomelei, kunum waneng nukal atemeko, ‘Yakai! Kitil eisneng kai o!’, angbuluw kasike.’, fut be angse kate, yu fut tem be teing bokolinba kebiliw sako? ");
INSERT INTO bhl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kate kame, yu kilele kililina! Sunbin-Got e ibolow fukunomele: ‘Isalael kawtiw alik alik i nem gawman ding dim kalo teleko, neso bokoliw te!’, angse kate, kame e, e ibolow alwol keko, nanew kawtiw akalem weng fein gelewkabiliw kawtiw ilo ‘Yukati teleko, diwkuw diwkuw neso bokoliw te!’, yangakabe te. ");
INSERT INTO bhl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yu kilele kililina! Am kun ilkul kitil be tum fian sel emdiw kelei, mali kawtiw i ‘Am kun be beit nam te!’, angeko, kolewsiliw kawtiw bi ok sen dem so mak emdiw em dim kel kumin miteko, tum fian beem dim kawtol angokoliw te. Feinka! Tum fian sel be mitsomelei, ilo atin kuw kawtol tabol tabol keyemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yangei, Sunbin-Got em am yol em kunum ayem sel so, em angin iso, Falisi kunum iso, alik alik i Yesus em kukuyemse fakam weng alemsal be kiliko, ‘Em weng be e num dim dalaka!’, angeko, ");
INSERT INTO bhl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yesus elo alomin deiw feinsiliw kate, i ka biliw kawtiw im awan fingansiliw kale. Nimtew angom? Kawtiw bi bokolomeliw: “Yesus e Sunbin-Got em bontem dim kunum ete te!”, angsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Beli, Yesus e iti fakam weng makso bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Abiil tikin em gawman keloke ding dim e fakam weng kaleem bakatetew keloke te.”, yangse kale. “Emisik kamok fian mak em min e ‘Waneng mak kulo yo!’, angse kasike, waneng kulomin ding em mewso kese ding kabalak e, alew e wanin dawol fian mak memen kese te. ");
INSERT INTO bhl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Sua kel akate, alew be mali kunum waneng ilo bokoyemomele: ‘Min em waneng kulomin ding kame mewso tele kasike, yu memen keko, wanin dawol fian wanomin tololiwka!’, yangse te. Yangei, kame beem ding mewso kese ding kabalak e, e akalem weng afak kebiliw kunum ilo yemdalei, i uneko, mali kunum waneng biilo bokoyemomeliw: ‘Kame yu wanin dawol fian be wanen telina!’, yangsiliw kate, mali kunum waneng bi yangbiliw weng be kiliko, ‘Bayo! Kame nam tuluw o!’, yangsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yangiwi, weng afak biliw kunum bi iti am uneko, ikalem kamok elo kawtiw biim yan weng bokoyemsiliw weng be dangsiliw te. Dangiwi, e weng afak kunum makso makso yemdalei, i fein uneko, iti kawtiw biilo bokoyemomeliw: ‘Wee! Yu telina! Nukalem kamok em bulmakao tugul fian so banban asomeliwi, wanin dawol fian mak memen keliw kasike, yu fongate akate kame telina!’, yangsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yangsiliw kate, i im yangsiliw weng be gelewinba kesiliw te. Mali kawtiw i ikalem musun elo aluwbam unsomeliwi, mali kawtiw i abiw mutuk fian elo tum win kulamin em deiw elo aluwbamsomeliwi, ");
INSERT INTO bhl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","iti mali kawtiw mak i sak kaisuw kesomi, weng afak kunum biilo yeluwsomi, yeniwi, i kuansiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Keko beli, kamok fian be kaneliw eisneng be kiliko, kaisuw fian mak kesomi, akalem wonuk so kunum ilo yemdalei, i uneko, akalem weng afak biliw kunum ilo yensiliw kawtiw biilo alik alik yeneko, ikalem abiw mutuk angom alik alik bi weing so kainsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kainiwi, kamok fian be akalem weng afak kunum ilo bokoyemomele: ‘Wanin dawol fian be memen keli kate, beem dulum elote memen keyembi kawtiw bi wa kukuw kuw kebiliw kasike, itel fein kalo nam teliw te! ");
INSERT INTO bhl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kame yu uneko, deiw beleng beleng angom ka uneko, ka biliw kawtiw alik alik ilo gaayemoliwka!’, yangse te. ");
INSERT INTO bhl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yangei, i akalem weng be geleweko, deiwkim deiwkim angom be ken kebiliw kawtiw so, wa kebiliw kawtiw so, alik alik ilo gaayem unesomeliwi, kunum waneng banban kamok fian beem am beelo uneko, am be gekiwi, abin banim kese te. ");
INSERT INTO bhl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Keko beli, kamok fian beem teleko, ‘Ne kunum waneng ka kel wensanbiliw biilo yetemo yo!’, angse ding dim bakate, e atemete: Ilim ken minggilinba kunum mak atemeko, elo bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Wee kutaka! Ku ilim ken mak minggilinba kebelew kasike, ku nono kesomi, am matem kale telew a?’, dangse te. Dangei, e weng banim kuw kese te. ");
INSERT INTO bhl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Keko beli, kamok fian be akalem weng afak biliw kunum mali ilo bokoyemomele: ‘Yu kame ilim ken minggilinba kele kunum mew beem teing so yan so sok nit net keleweko, elo kut kalo kuse fomdo kolina! Koleweko, ka kel bomi, amebomi, akalem kal dim teing feiwbomi, teing bulung gilkabomi, boke te.’, yangse te. ");
INSERT INTO bhl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yu kilelbi boliwka! Sunbin-Got e kunum waneng banso banso gaayembe kate, kawtiw makmak makmak bite kuw akalem wiin so galmose kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Beem ding dim bakate, Falisi kunum i wensaneko, ikalem dim bokolew bokolew kesomi, bokolomeliw: “Nu nono keko, Yesus em nulo bokoyemoke yan weng beem dulum elote nu elo geelewokoluw a!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kesomi, i ikalem yenggelewkabiliw kunum mali so, emisik kamokim Kelot em ken kunum mali iso, alik alik biilo yemdaliwi, i Yesus em mit mewso unsiliw kale. Uneko, elo bokolewomeliw: “Kukuyemin kunum kutaka! Nu kal keluwete: Ku kunum waneng ilo fein weng kuw kukuyemsomi, bakayembelew kunum kute te! Ku kawtiw wiin banim ikal, wiin so kawtiw ikal, alik alik ilo diwkuw diwkuw fein weng kuw bakayembomi, Sunbin-Got em fein deiw kukuyemkabelew kunum kute te. ");
INSERT INTO bhl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kasike kame, ku kom ibolow fukunin be nulo bokoyema! Nu Ulom em emisik kamok fian em sawa weng geleweko, elo kisol anung mak dukalewbokoluw, beni ba?’, kangeko, dakalaluw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dangiwi, Yesus e ikalem ibolow fukunin wa wa be atemeko, kal kelete: ‘I funum funum kenembiliw kai!’, angse kasike, e ilo bokoyemomele: “Fimdi famde kunum yutaka! Nimtew angom ete yu nelo dasuw kenemeko, kiskis konem kebiliw a? ");
INSERT INTO bhl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yu uneko, tum win on kisol mak de teleko, kalenemina!”, yangse kale. Yangei, i uneko, fein, tum win mak de talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","De teliwi, Yesus e ilo dakalalomele: “Yu tum win dim beem dukusiliw kiskiw be atemeko, kanem kiskiw so, wiin so be nangeko, bokonemina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yangei, i yan weng bokolewomeliw: “Ulom em emisik kamok fian eteka!”, dangsiliw kale. Dangiwi, e ilo bokoyemomele: “Kasike, yu Ulom em emisik kamok fian kebe beem eisneng dukalewbokoliw kate, Sunbin-Got ete kuw akalem eisneng beelo dukalewboliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yangei, i em yan weng beem dulum elote yol yol angesomeliwi, sak kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Beem ding dim bakate, mali Satyusi kawtiw mak teleko, Yesus elo funum weng mak bokolewsiliw kale. Satyusi kawtiw biim ibolow fukunin e kanekote: Mali kuansiliw kawtiw i finik so keko, nam iti baba teinokoliw te!’, angakabiliw kawtiw ite te. ");
INSERT INTO bhl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kame, i elo funum dakalamin mak bokolewomeliw: “Kukuyemin kunum kutaka! Moses e nulo kukuyemin weng mak dukuko, bokoyemomele: ‘Kunum mak aul banim keko, kuanei, kuanse kunum beem awkunum be awkunum beem kalun kayak kasike, e kalun waneng buulo kuluumoka! Kuluumei, yemkal i aul mak dukuliw tewe, aul be kuanse awkunum beem aul keloke te.’, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kame, ku num mutuk dim kanese sang be kilila! Kunum ben kel yangmel i bisiliw te. Emisik e waneng mak kuluse kate, aul banim keko, kuanse te. Kuanei, auk teben awkunum be kalun bu kuluko, ");
INSERT INTO bhl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","aul banim keko, akati kuanse te. Kuanei, yemamas kel awkunum akati kalun buulo kuluumeko, aul banim keko, kuanse te. Alik alik ben kel awkunum bi waneng buulo kulusiliw kate, aul mak dukulinba kesomi, dow so banim keko, kuansiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kuaniwi, fe e, waneng kalun bukati kuansu te. ");
INSERT INTO bhl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kame, kuankemin kawtiw im iti yemkalfolokoliw ding dim kabalak e, waneng bu kanem kalel keloku ye? Nimtew angom? Kunum yangmel ben kel alik alik bi ulo kulusiliw kasike.”, dangeko, funum weng be Yesus elo dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Dangiwi, Yesus e ilo yan weng bokoyemomele: “Ibolow so benesiliw kunum yutaka! Yu Sunbin-Got em fut tem kayak bose weng so, Sunbin-Got em kitil so, alik alik be atin kuw akokow kebiliw te! ");
INSERT INTO bhl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sunbin-Got em kawtiw ilo yemkalfoloke ding dim e, kawtiw i nam kunum waneng kulew kulew kemokoliw te. Nimtew angom? I Sunbin-Got akalem yemdakamin finik imdiw kelokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kate, yu kilele ibolow fukunina! Yu Sunbin-Got em bokoyemeko, akalem fut tem bose weng be teing bokolinba kebiliw a? E yukalem sua sua kel alenaliw aliwol kumel im dulum elote bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ne Abalakam so, Aisak so, Sekow so, yelimel biim Sunbin-Got nete te!’, dangse kale. Dangse kate, Sunbin-Got e kuansiliw kawtiw im Sunbin-Got bate! E finik so biliw kunum waneng im Sunbin-Got ete te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yangei, kawtiw ka biliw kawtiw alik alik i em kukuyemse weng be kiliko, yol yol angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Beli, Yesus e Satyusi kunum biilo yan weng ken ati kuw bokoyemei, i weng banim keko, bontem net keyemsiliw kasike, mali ka biliw Falisi kunum i bongguko, Yesus em mit mewso talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Telesomeliwi, im mutuk ka be Sunbin-Got em kukuyemin sawa weng em kak kunum mak moko, Yesus elo kiskis weng mak dakalako, bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kukuyemin kunum kutaka! Nalem Sunbin-Got em sawa weng e mali ilo bakileweko, emisik sawa be ya?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Dangei, Yesus e yan weng bokolewomele: “Ku kukalem Sunbin-Got Kamok Fian elo ibolow mutuk fian dulewolewka! Kukalem finik so, ibolow so, fukunin so, alik alik be bongguko, Sunbin-Got em dim kuw fewtoko, kolew bolewka! ");
INSERT INTO bhl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Be emisik fian sawa angse weng bete te. ");
INSERT INTO bhl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kate, mali sawa mak beemdiw atin kuw fian ete te. Kukalem ibolow mutuk fian e kukalem dim bikembe beemdiw, yom mewso biliw kawtiw mali ilo ikati ibolow mutuk fian kukuyem kemolewka! ");
INSERT INTO bhl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sawa weng alew kale kilele aluwbew tewe, sawa weng biso, Sunbin-Got em bontem dim bakamin kunum im bakabiliw sawa weng biso, alik alik sawa bi bongguko, bikati aluweko, fein gelewbelew te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Falisi kunum biim bonggusiliw ding bakate, Yesus e ilo dakalalomele: ");
INSERT INTO bhl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yu nimtew ibolow fukuniwete: ‘Sunbin-Got em Mesaya e kante a? E kanem mulkis ete?’, angeko, ibolow fukunbiliw a?”, yangeko dakalase kale. Dakalalei, i yan weng bokolewomeliw: “Emisik kamok fian Debit e Mesaya em kunum mongom keloke te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dangiwi, e bokoyemomele: “Kate, nimtew angom ete emisik kamok Debit be Sunbin-Finik so gekeko, Mesaya beelo bokolewomele: ‘Nem kamok fian kutaka!’, dangse a? Nimtew angom ete e Mesaya beem dulum elote bokolomele: ");
INSERT INTO bhl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Sunbin-Got Kamok Fian e nem Kamok Fian elo bokolewomele: ‘Ku nem yuk teing kitil so dim kel teineko, ding fensomelewi, ne kom maka ilo yemdalii, i teleko, atin kuw kom kitil afak kel teinokoliw te.’, dangse te.’, Yu ibolow fukuniwete: Nimtew angom ete e angse weng be bokose ya? ");
INSERT INTO bhl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yu kilele ibolow fukunina! Sim Fut kale kel, Debit e Mesaya elo ‘Nem Kamok Fian’, dangse kasike, Mesaya esik nimtew angom ete ‘Debit em mulkis te!’, dangbiliw a?”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yangei, i ki keko, weng yan weng mak bokolinba kesiliw kale. Beem ding dim uneko, belei, mali kunum mak i finganeko, elo iti dakalakamin weng mak dakalalinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Beli, Yesus e akalem gelewkabiliw kunum so, kawtiw ka biliw kawtiw iso, alik alik ilo bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum so, Falisi iso, kunum bite Moses em kukuyemin weng bakayemeko, kukuyemkabiliw te! ");
INSERT INTO bhl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kasike, yu biim yange weng be kiliko, fein gelewemoliwka! Kate, kunum biim kukuw wa be yu kanelom gelewemokoliw te! Nimtew angom? Im weng e ken kate, im kukuw be im yangbiliw weng beelo gelewinba kelei, i wa sel kekabiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","I Sunbin-Got em sawa weng kale kulukabiliw kunum waneng yulo ‘Yu gelewina!’, yangeko, yulo kal ilum banban dukayemkabiliw kate, ikalem ete teing ketket kang gel fong gel makmak net keko, aluwinba kekabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Feinka! Kunum bi ibolow fukunomeliw: ‘Mali kawtiw i nulo yetemeko, wiin fian dukayemboliwka!’, angbiliw kasike, i Sunbin-Got em weng fut anung mak boko, yebal dim dukusomi, ilim dim siwsow kalikali dukusomeliwi, mali kawtiw i im kanebiliw be yetemeko, ilo yemsulbiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yemsulbomeliwi, dawol keliw ding dim kabalak e, i num wensankabuluw am dim kel diwkuw diwkuw imisk wiin so abin kulukabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kuluko, i kawtiw banban im wensanbiliw dim elo unbiliw kasike, mali kawtiw i ilo yetemeko, wiin fian duyemeko, bokoyemomeliw: ‘Kukuyemin kunum yutaka! Biliw yako!’, yangbiliwi, i kiliko, kalfong so keyembiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kate yu kanelom yom wiin e ‘Kukuyemin kunum!’, yangbokoliw te! Nimtew angom? Nete kuw yom kukuyemin kunum bi kate, alik alik yu kikisel min kuw kebiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Beemdiw, yu kanelom kawin dim kale kel kal so kun so kunum mak elo ‘Num aatim kute te!’, dangeko, elo dawsulemokoliw te! Yu yom abiil tikin alakabe Aatim bete kuw dawsulemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Feinka! Yu kanelom yukalem wiin e ‘Kamok kunum!’, yangbokoliw te! Nimtew angom? Mesaya ete yom kamok kunum bete kuw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nimin kunum waneng ite mak ‘Nu wiin fian mak kuluma o!’, angiw tewe, i alik alik ikalem sak weng afak kunum kemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nimtew angom? Nimin kunum waneng ite mak ikalem wiin daobiliw tewe, i inkal fian keko, wiin banim kunum kelokoliw kasike. Kate, nimin kunum waneng ite mak ikalem wiin de mit dabiw tewe, i wiin fian so kunum waneng kelokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum so, Falisi so, yu fimdi famde kunum kebiliw kasike, yu kilelbiko, boliwka! Nimtew angom? Mali kawtiw i bokolomeliw: ‘Nu abiil tikin em gawman ding dim kalo unomin ibolow keluw te!’, angebiliw kate, yu biim deiw be okiyemkabiliw kasike. Fein! Yukalem e kalo unomin gal kebiliw kate, mali kawtiw ‘Kalo unomin obolow keluw te!’, angbiliw kawtiw biilo yukati ‘Ayem o!’, yangankabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum so, Falisi iso, alik alik yu fimdi famde kunum kebiliw kasike, yu kilelbiko, boliwka! Yu kitil keko, abiil fe kawin fe aneng aneng angom kalo uneko, kawtiw ka biliw biilo Moses em kukuyemin weng bakayem tem bakayem tem unakabiliw te. Keko beli, nimin kawtiw bite mak yom bakayembiliw weng be kiliko, ‘Fein!’, dangiw tewe, yu ilo yukalem yenggelewkabe kawtiw keyemkabiliw te. Keyemeko, kawtiw biim kukuw be iti teng teng keyembiliw ki, biim wa kukuw be yukalem wa kukuw be bakiyemoke kasike, Sunbin-Got e kawtiw biilo fein ais dong tem da koyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kiin sukul nam atew kebomi, mali kawtiw ilo deiw kukuyemkabiliw kunum yutaka! Yu kilelbiko, boliwka! Nimtew angom? Yu bokolomeliw: ‘Nimin kawtiw ite mak Sunbin-Got em am yol beem dulum elote fawtuk ayem weng mak bokoliw tewe, im weng be sak weng kuw dem banim kelokole te. Kate, nimin kawtiw ite mak Sunbin-Got em am yol em on kisol beem dulum elote fawtuk ayem weng mak bokoliw tewe, i kanelom im angbiliw weng be sakok kelokoliw te.’, yangakabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kiin kasiko, ibolow kau nam kebiliw kunum yutaka! Sunbin-Got em kiin dim e nimtew ete emisik kele a? On kisol bete ye? Bani Sunbin-Got em am yol bete ye? Feinka! Sunbin-Got em am yol ete emisik kebe te! On kisol be Sunbin-Got em am yol tem dukukabiliw kasike, beem mongom ete kuw on kisol kale Sunbin-Got em kiin dim bakati wiin so kelewbe te. ");
INSERT INTO bhl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Beemdiw yu bokolomeliw: ‘Nimin kawtiw ite mak Sunbin-Got em am yol aik ayem beem dulum elote fawtuk ayem weng mak bokoliw tewe, im angbiliw weng be sak weng dem banim kuw keloke te. Kate, nimin kawtiw ite mak samal mak asomi, Sunbin-Got em am yol beem aik ayem dim dukuko, beem dulum elote fawtuk ayem weng mak bokoliw tewe, i kanelom im angbiliw weng beelo sakok kemokoliw te!’, yangakabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kiin kasiko, ibolow kau nam kebiliw kunum yutaka! Sunbin-Got em kiin dim e nimtew ete emisik kele ye? Aik ayem ete ye? Bani, samal asomi, aik ayem dim ka dukalewbiliw ete ye? Feinka! Aik ayem be emisik kebe te! Samal asomi, aik ayem dim ka kel dukukabiliw kasike, beem mongom ete kuw samal be Sunbin-Got em kiin dim akati wiin so kelewbe te. ");
INSERT INTO bhl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yu kilele kililina! Nimin kawtiw ite mak Sunbin-Got em am yol em aik ayem beem dulum elote fawtuk ayem weng mak keliw tewe, ikalem weng be aik ayem so, mesesem em dim ka dukukabiliw eisneng beso, alik alik beem dulum elote dawkitil mo kebiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Beemdiw, nimin kawtiw ite mak Sunbin-Got em am yol em dulum elote fawtuk ayem weng mak bokoliw tewe, i am yol so, am yol beem sen kayak beem wiin dim so, fawtuk ayem weng be bokokabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kaneko beli, nimin kawtiw ite mak abiil tikin beem dulum elote fawtuk ayem weng mak bokoliw tewe, i ikalem weng be Sunbin-Got em abin ayem dim so, beem dim ka teinbe Sunbin-Got beso, beem dulum elote fawtuk ayem weng be dawkitil mo kolewkabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum so, Falisi so, fimdi famde kunum yu kilelbiko, boliwka! Yu kimit so, bokow so, wanin eisneng wiin banim kebe eisneng beso, alik alik be kuluko, king kel anung dukuko, anung makmak iti kuluko, Sunbin-Got elo dulewkabiliw te. Be ken kate, yu Sunbin-Got em emisik kukuyemin sawa weng be gelewinba kebomi, mali kawtiw ilo kinkin folok ibolow so, kiol fein kukuw so, kukuyeminba kekabiliw te. Yu Sunbin-Got elo mesesem mesesem eisneng em king kel em anung makmak dulewomin kukuw gelewboliwka! Kate, kawtiw ilo kinkin folok ibolow so, kiol fein kukuw so, bakati gelewemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kiin sukul nam atew kebomi, mali kunum ilo deiw kukuyemkabiliw kunum yutaka! Yu kilele ibolow fukunina! Ok wanomin ding dim e, yu ok sen mak kuluko, beem dim e gimgim gel mak atemeko, ‘Yake! Ibo!’, oleko, kolewkabiliw kate, yu iti ok sen mak kuluko, kamel samal fian mak beem dim kabalak elo ateminba keko, sak wanakabiliw te. Beemdiw, yu kukuyemin sawa weng beem teing fe yan fe bete kuw gelewkabiliw kate, beem dem mutuk fian be dawkatiko, kolewkakabiliw te! ");
INSERT INTO bhl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum so, Falisi so, fimdi famde kunum yu kilelbiko, boliwka! Yom ibolow mutuk tem e yakut kukuw so, sili sili nam kukuw so wenkabiliw kasike, kal tikin kais ati kebe kate, mutuk kawyak e ninik nam keko, mian wanin atew kekabe ok sen mak e yukalem kiskiw ete te. ");
INSERT INTO bhl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yu kilele ibolow fukunina! Yu ok sen tem kawyak beem kukun be kais ati kuw kelewko, kilelewiw tewe, ok sen tikin akati kais ati kebomi, ken keboke te. ");
INSERT INTO bhl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum so, Falisi so, fimdi famde kunum yu kilelbiko, boliwka! Yu fomkamin emdiw kekabiliw te. Nimtew angom? Kawtiw i fomkamin dim em kal dim e kait kait gus tololewkabiliw kate, mutuk kabalak e kun gilol so, mesesem mesesem Sunbin-Got em kiin dim ninik so eisneng weneko, gek kabe kasike. ");
INSERT INTO bhl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Feinka! Kawtiw i yom kal dim ete kuw atemiwete: Kais nam fulkan kuw donong keko biliwi, yetemeko, ‘Kiol kunum ite te!’, yangbiliw kate, yom ibolow tem e sili sili nam so, fimdi famde kukuw so, weneko, gek kabe te. ");
INSERT INTO bhl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum so, Falisi so, fimdi famde kunum yu kilelbiko, boliwka! Yu Sunbin-Got em bontem dim bakamin kuansiliw kunum so, kiol kunum so, alik alik biim fomkamin be kais ati kuw kait kait kelewbomi, bokolomeliw: ");
INSERT INTO bhl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‘Nukalem ete nukalem abiok kumel fasel im ding dim buw tewe, nu abiok kumel biim weng gelewinba kesuluw te. Feinka! Nu Sunbin-Got em bontem dim bakamin kunum biilo yeninba keluwi, i kuaninba kesuluw te.’, ange ange keko, angakabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Angbiliw kasike, yukalem angbiliw weng bakate, yu bokolomeliw: ‘Sunbin-Got em bontem dim bakamin kunum ilo yensiliw kunum biim mulkis kumel nute te!’, angakabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Feinka! Yom abiok kumel i ibolow sili sili nam kukuw banban kebomeliwi, im kukuw wa be ok emdiw aneng aneng angom be weneko, fokose kate, kame, yu biimdiw kesomi, im aneng mali mak kolewsiliw aneng bakati yom kukuw wa so atin kuw wenkabiliw te! ");
INSERT INTO bhl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sokyan kimon so em muluwel yutaka! Yu ki keko, nam fon uniw kate, Sunbin-Got e yulo geeyemeko, kaisuw fian duyemeko, yulo ais dong tem da koyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yu kililina! Ne mali Sunbin-Got em bontem dim bakamin kunum so, mali kal kunum so, mali kukuyemin kunum so, kunum banban yom dim elo dabalaloki te. Dabalaloki kate, yu mali ilo yeniwi, i kuanokoliw te. Iti mali mak yu ais dim sil biki yeniwi, i kuanokoliw te. Iti mali mak yu yen feiw koyemiwi, i finganeko, fon unomi, aneng aneng angom elo fonsangineko, waleleko, ilum fian mak kulokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kaneko kasike, Ebel em asiliw dim kalote teleko, Belekia em min Sekalaya em dim kel telei, i Sunbin-Got em kiol kawtiw alik alik biilo yeniwi, i kuankabiliw te. Yukal kal keliwete: I Sekalaya elo Sunbin-Got em am yol mutuk em aik ayem mewso dim ka kel asiliw te. Yu kilele kililina! Yesiliw kawtiw biim sen em yan be yukati tuluyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Feinka! Yan wa be kameem alakabiliw kawtiw yom dulum elote fein tuluyemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yangeko, sakik weng mak bokolomele: “Wee! Selusalem kasel yutaka! Sunbin-Got e akalem bontem dim bakamin kunum banban yom dim kalo yemdalei, i fein talsiliw kate, yu ilo tum so mutum fakal yeniwi, i kuankakawkabiliw te. Nem yom dim kalo teleko, ‘Nem yesum afak tebil koyemo yo!’, angi ding dim kabalak e, yu diwkuw diwkuw ‘Bayo!’, nangeko, sakalaw keko, weng bo bo kenemkabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kasike, yu kililina! Yom abiw mutuk fian kalakati wako, wiin banim so keloke te. ");
INSERT INTO bhl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Keko kasike kame, yu nelo kilele kal kelinba kebiliw kate, nem iti toloki ding dim kabalak e, yu kalfongeko, bokolomeliw: ‘Sunbin-Got em wiin dim talbe wiin so kamok be talbe kai!’, angeko, nelo fein kal kelokoliw te.” yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Beli, Yesus em Sunbin-Got em am yol aneng be kolewsomi, kut matem talse ding bakate, akalem gelewkabiliw kunum i am yol atite beelo kalelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kalelewiwi, Yesus e weng mak bokoyemomele: “Yu kililina! Deiw mak ding mak kabalak e, maka mak telesomeliwi, atite eisneng be tum ati so mak em tikin dim, mak em tikin dim banimeko, alik alik dakalko, mit da koyemokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yangeko, unsomelei, im Oliw amgu tikin ka kel teinsiliw ding be, akalem gelewkabiliw kunum imikel kuw teleko, Yesus elo dakalalomeliw: “Kukuyemin kunum kutaka! Nalem ding ete, ilum toloke ding be keloke ye? Nu nomin eisneng mak atemsomi, kal keluwete: ‘Kom kawin dim kaleelo telewi, kawin kale banimoke ding be, ka kel kai!’, angokoluw a? Kame ku nulo bokoyema!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Dangiwi, e yan weng bokoyemomele: “Wee! Yukal kilelbi boliwka! Mali dasuw kunum banso ikal teleko, ");
INSERT INTO bhl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","nem wiin dim yulo dasuw weng bokoyemomeliw: ‘Nu Mesaya nute te!’, yangsomeliwi, kunum waneng banban i biim dasuw bokoyemiw weng be kiliko, ilo fein yenggelewokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Keko beli, yu kenen weng kililiwete: ‘Aneng fian mali iso aneng fian mali iso ganen ganen kakabiliw kai!’, ange ange keko, yulo bokoyemiwi, yu kililokoliw kate, yu kanelom finganemokoliw te! Nimtew angom? Kanele eisneng be emisik toloke kate, fefe ding be ibik ete keko, toloke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Feinka! Aneng mali kasel isik uneko, aneng mali kasel iso ganen unokoliw te. Uneko, mali kasel im kamok isik uneko, mali im kamok iso ganen unokoliw te. Keko beli, aneng aneng mali mak olfut fian kemei, kawin kale akati bim fian kuw fi atuk atuk keloke te. ");
INSERT INTO bhl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Alik alik ilum eisneng be deiw busule kasike, kal ilum fian fian makso ibik ete toloke kasike. ");
INSERT INTO bhl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yu nem angin kebiliw kasike, beem ding dim be, kawtiw alik alik i yulo ibolow kaisuw fian kaim alel yetemeko, yulo betbet duyemeko, yulo yeniwi, yu kuanokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Beem ding dim be, ‘Fein!’, nangebiliw kunum waneng demdem ikati nelo konemsomi, ikalem akate maka kelew kelew kebomi, mali ilo akati yemdeneng maka im teing dim da koyemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Keko beli, dasuw selew selew kunum ikal teleko, kunum waneng dasuw fian fian mak bakayembiwi, kunum waneng demdem mak i biim weng bokoyemiw weng be kiliko, gelewokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gelewiwi, i Sunbin-Got em kukuyemse weng be kolewsomi, ikalem mali ilo ibolow mutuk fian kelew kelew kukuw akal kolewiwi, e banimoke te. ");
INSERT INTO bhl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kate yu kililina! Nimin kunum waneng ite mak nelo fein nangebiliw ibolow kolewinba kesomi, fe em toloke ding dim kel kitil keko, mobiliw kunum waneng keliw tewe, i sunsun kuw finik so bin kuluko, bokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Feinka! Kunum waneng im abiil tikin em gawman ding dim em Weng Kal Ken Ati be deeko, kawin fe abiil fe aneng aneng angom biliw kawtiw alik alik ilo bakayem tem bakayem tem unokoliw ding dim kabalak e, fefe ding dim be fein keloke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yangeko, iti weng mak so bokoyemomele: “Yu weng kale kilele kiliko, kilele kal keloliwka! Deiw mak ding mak, Sunbin-Got em bontem dim bakamin kunum Daniel em weng bokose weng be fein dem gilalei, yu atemiwete: Mali kawtiw mak teleko, Sunbin-Got em am yol elo sakok keleweko, ka kel e kaing wasan mian wasan teng so eisneng inkal so mak akatetew dukulokoliw te. (Fut kale teing bokoko, atebiliw kawtiw yu kanelom ibolow kau angbokoliw te!) Beem ding dim bakate, ");
INSERT INTO bhl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Sudia aneng kasel yu fongate akate fon uneko, amgu tikin elo fon unoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mali kawtiw am yu dim teinbiliw kawtiw yukati kanelom uneko, am mesesem mak kawtem be be kulam unokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Beemdiw, mali kawtiw wanin musun dim aluwbabiliw kawtiw yukati kanelom iti am uneko, asolow ilim mak kulam unokoliw te! Bayo! Alik alik yu fongate akate fon unoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Beem ding dim bakate, kawtiw aneng kale biliw kawtiw i ilum fian mak kulokoliw kasike. Waneng aul kumun biliw so, aul beliw ilo non yemgibiliw waneng iso, waneng bi fongate nam fon uniw kasike, ikati kal ilum fian fian mak kulokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kasike, Sunbin-Got eso weng bokolomeliw: ‘Finengdakamin ding Sabat ding ete yako, suuk so aneng wa dim ete yako, kaneloke eisneng beem ding dim be kanelom num dim tolome yo!’, dangeko, kitil bakalewboliwka! ");
INSERT INTO bhl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kal ilum fian fian toloke ding dim be, ‘Sua fasel sang so mak kaneloke te!’, anginba kesiliw eisneng mak matem toloke te. Keko, ibik elote akal iti beem eisneng be nam kaneloke te. ");
INSERT INTO bhl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Feinka! Sunbin-Got e akalem angin im ibolow fukuneko, bokolomele: ‘Tiak ding kele tewe, kawtiw alik alik bi sak banimokoliw sako!’, angoke kasike, e kal ilum keyemoke ding be sukum goto kelewoke te. ");
INSERT INTO bhl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Beem ding dim bakate, mali kawtiw mak yulo bokoyemomeliw: ‘Mesaya e mew baka te! E miyak baka te!’, yangokoliw kate, yu kanelom im weng be kiliko, gelewbokoliw te! Itel bate! ");
INSERT INTO bhl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nimtew angom? Mali dasuw selew selew kawtiw mak kaneko dasuw weng be yulo bokoyemsomeliwi, iti mali mak i yulo bokoyemomeliw: ‘Nakalem ete Mesaya nete te!’, yangbokoliw kasike. Yangesomeliwi, i kitil so auk so eisneng banban mak kukuyemsomi, Sunbin-Got em fein angbiliw kawtiw biim dulum elote ‘Nu kitil keko, im fein ibolow be de mit da koyemuma!’, angsomi, ma ke ma ke keyemokoliw kate, i ki keko, Yesus elo ‘Fein!’, dangbiliw kunum waneng biim ibolow beelo teifululinba keyemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kanemin eisneng be fein toloke kasike, yu nem yangbi weng kale kiliko, kilelbi boliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yangeko, iti weng mak bokoyemomele: “Beem ding dim bakate, mali kawtiw i yulo bokoyemomeliw: ‘Mesaya e kawtiw banim dim miyak bakate!’, yangiw tewe, yu im yangbiliw weng be kiliko, kanelom kalo unokoliw te! Beemdiw, mali kawtiw i yulo bokoyemomeliw: ‘Mesaya e am katem kel be te!’, yangiw tewe, yu im yangiw weng be kiliko, kanelom ‘Feinka!’, yangbokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nimtew angom? Kawtiw Aul nem toloki ding dim be, bamneng ailbin em falak angakabe emdiw keloke kasike. Bamneng e ataan tele dulum elote falak angei, uneko, ataan unebe dulum elo unakabe te. Beemdiw kunum waneng alik alik angom yu yukalem kiin so fein netemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Fakam weng kale kilele kililina! Kawtiw kuaneko, fom akal fakalibiliw dim kel, awon guegnok i teleko, boktak bile kakakabiliw te. Kakabomeliwi, kawtiw i ilo yetemsomi, fom biliw aneng be fein kal kelokoliw te. Beemdiw, kunum waneng alik alik i nem toloke ding dim bakati fein kal kelokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yangeko, iti weng mak bokoyemomele: “Kal anggil betbet fian kesomi, banimoke ding dim bakate, fongate akate ‘ataan takak ail be be daking kuanoke te. Kayow akati ailinba kelei, fial akal abiil tikin katem koleweko, fitulu atin mit mit kemei, abiil katem em kitil keko, aulbe eisneng be beit keko, fi atuk atuk keloke te.’ ");
INSERT INTO bhl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Keloke ding dim be, Kawtiw Aul nem kiskiw kitil nam be abiil kawtem kel kanelei, kawtiw alik alik i elo atemeko, finganin fian mak kesomi, walwal kebomi, netemiwete: Kawtiw Aul ne kamok fian keko, yukam dim moko, abiil kawtem elote nakalem kitil so auk so telii, netemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Beem ding dim be, Kawtiw Aul ne Sunbin-Got em yemdakamin finik ilo abiil fe kawin fe kalo yemdalii, i uneko, fongket fian sel kuw fongfong gaaneko, nakalem galmosi kunum waneng alik alik ilo bongguko, mutuk makmak koyemokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yangeko, Yesus e fakam weng mak bokoyemomele: “Seil gilalomin ding dim e, awon bolokbolok gaanokoliw kasike, yu kal keliwete: ‘Kame seil gilalomin ding keme kai!’, angenkakabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Beemdiw, kaneloke finganin fian eisneng be kele tewe, yukal kal keliwete: ‘Nem toloki ding dim e, mewso deiw elo mole kai!’, angoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Feinka! Kaneloke ding dim beem biliw kawtiw i kuaninba kun so kal so biliw akate, kaneloke eisneng be fein keloke te. ");
INSERT INTO bhl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yu kililina! Abiil so kawin so banimoke kate, nem weng bokoyemsi weng kale, nam banime te. Fein sunsun kuw boke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yangeko, iti weng mak bokoyemomele: “Kunum waneng i nem toloki ding dim em ding e ki keko, ‘Beem kayow ding ete te.’, beni ‘Beem itol ding ete te.’, nam angiw te. Sunbin-Got em abiil tikin biliw yemdakamin finik so, Min nakalem so, alik alik nu beem ding akati akokow kebuluw te. Nem Aatim akalem ete kuw nem toloki ding be kilele kal kebe kasike. ");
INSERT INTO bhl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Yu ibolow fukunina! Noa em alenale ding dim kabalak e, kawtiw i wanin so ok so wanbomeliwi, kunum waneng kule kule kebomeliwi, waneng kunum dule dule kebomeliwi, beem ibolow kuw kebomi, alenaliw kale. Kebomeliwi, deiw mak ding kabalak e, Noa yelimel i siw tem kawtem uniwi, okmun dang fole fole be teleko, mali kut biliw kawtiw alik alik biilo yen kasi koyemse kale. Yu kilelbi kililina! Kawtiw Aul em toloke ding dim e, Noa em kanese ding emdiw keloke te. Beem kaneloke ding dim be, kawtiw i akokow kesomi, mali kawtiw im okmun dang fole fole ding kesiliw atew kesomi, yol angeko, walwal kelokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yu kilele kililina! Beem ding dim be, alew kunum mak imikel kuw musun kel aluwokoliw kate, Sunbin-Got e mak elo kulusomi, mak elo kolewoke te. ");
INSERT INTO bhl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Iti mali waneng alew mak men faalokoliw kate, Sunbin-Got e mak ulo kulusomi, mak ulo koumoke te. ");
INSERT INTO bhl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Keko kasike, yukal kilelsiko, kiin kiin dako, kuteboliwka! Nimtew angom? Yukalem kamok nem tolomin ding e yu akokow kebiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yu fakam weng be ibolow fukunina! Kunum am kayak mak yakut kunum mak em toloke ding be kal keko, memen kesomi, kutele tewe, yakut kunum be am matem nam teleko, em on kisol mesesem mesesem eisneng be nam yakut kule te. ");
INSERT INTO bhl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yukati kunum am kayak beemdiw kilelsiko, kuteboliwka! Yom nanbow angeko, ‘Nam tele sako!’, angbiw ding dim kabalak e, Kawtiw Aul ne fein toloki kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yangeko, iti fakam weng mak bokoyemomele: “Nimin kunum waneng ite mak ibolow fukunin ken so keko, akalem kamok em fein weng afak kunum waneng kelokoliw a? Nimin kunum waneng mak kaneliw tewe, ikalem kamok be ilo mali weng afak kunum waneng biim kak atew keyemoke kasike, wanin wanokoliw ding keloke ding dim be, i mali kunum waneng biilo wanin yemgiyemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Keko beli, kamok be aneng koleweko, iti teleko, kak atew moyemse kunum waneng biim ken kukuw keyembiliw be ateme tewe, e kak atew moyemse kunum waneng biilo ken kukuw kuw keyemeko, kakateko, kalfong fian keyemoke te! ");
INSERT INTO bhl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nimtew angom? Ikalem kamok be alik alik mesesem mesesem angom be kak atew moyemse kunum waneng biim teing dim elo kuw da koyemei, ite kuw kilele atebiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kate, kak atew moyemse kunum waneng bi ibolow fukuneko, bokolomeliw: ‘Nukalem kamok be kalakanem nam tele sako!’, angsomi, ");
INSERT INTO bhl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mali weng afak kawtiw biilo sak yen feiwsomeliwi, i ikalem akunum kumel kunum waneng iso wanin so wain ok banban wansomi, ibolow mesem kuw keko, mamtel fian keliw tewe, ");
INSERT INTO bhl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kak atew moyemse kunum waneng biim akokow kelokoliw ding dim kabalak e, ikalem kamok kunum be fein toloke kasike, i yol fian mak angokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Keko beli, kamok be kak atew moyemse weng afak kunum waneng biilo geeyemeko, yen feiw koyemsomi, ilo yenbakalako, yemdeko, dasuw fimdi famde kawtiw im mutuk elo da koyemoke te. Koyemei, i ka kel amebomeliwi, ikalem kal wakal dukusomi, teing feiwbomi, teing bulung gilkabomi, bokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yangeko, iti weng mak bokoyemomele: “Abiil tikin em gawman ding dim em toloke ding e fakam weng kaleemdiw keloke te. Waneng mak um tonol keko, kunum kulomin ding dim bakate, king kel waneng seiwel mak i ikalem ilam yongom dong kuluko, ‘Deiw kel awkolon um imok fukun unuma o!’, angeko, unsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Teingabi kel waneng seiwel bi fukunin ken ati so kebiliw kate, mali wanggel seiwel teingabi kel bi ibolow benemin nam kebiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ibolow benebiliw bi ilam de tolokoliw kate, i kelosin elo akokow kesomi, de telinba kesiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kate mali fukunin ken so biliw waneng seiwel i ilam so, kelosin so, de talsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Keko beli, waneng kulomin kunum be fongate telinba kese kasike, seiwel i kiinok ilum sen mak akalsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Akalbiliwi, kutil mutuk fian demdem kele ding dim bakate, waneng kulomin kunum be telei, mali eso talsiliw kawtiw i gaanomeliw: ‘Waneng kulomin kunum akal talaka o! Fongate akate teineko, em fukun telina o!’, angbiwi, i kilisiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kilisomi, waneng seiwel bi baba teineko, ikalem ilam kuluko, ailbin memen kesiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kemiwi, ibolow benebiliw wangel i fukunin ken so wanggel biilo dakalako, bokoyemomeliw: ‘Kae, nawkolon kumel yutaka! Yom kelosin atuk mak nulo yemenina! Num ilam be kelosin banim kelomi, kuanomin keme kasike!’, yangsiliw kate, ");
INSERT INTO bhl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","teingabi fukunin ken so wanggel i yan weng bokoyemomeliw: ‘Babo! Kelosin fong gel kuw aluwbuluw kasike, yukati wemin am elo uneko, wen unina! Kale nukalem ki kuw kasike.’, yangsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yangiwi, ibolow benebiliw wanggel i wemin am elo kelosin wem unsiliw te. Im unbiliw ding dim bakate, waneng kulomin kunum be fein teleko, kilele memen kesiliw teingabi kel seiwel waneng biilo am kawtem elo yemde unesomelei, i ka kel kalfong fian mak kesomi, wanin dawol fian fian mak wansiliw te. Keko beli, weng afak kunum i am yal kitil kuw net ailsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Keko beli, ibik ete mali ibolow benebiliw teingabi kel seiwel ikati teleko, gaanomeliw: ‘Wee! Kamok a! Kamok kutaka! Nulo akal am yal busuyema!’, dangeko, gaansiliw kate, ");
INSERT INTO bhl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","e yan weng bokoyemomele: ‘Ne yulo atin kuw gel so akokow te!’, yangse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kame yu kilelbi boliwka! Yu kilelsi kuteko, ding fen boliwka! Nem toloki ding so, beem kaneloke ding em ataan kak em ding so, yu akokow kasike!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yangeko, iti weng mak bokoyemomele: “Abiil tikin em gawman ding dim em kaneloke fakam weng mali mak kanekote: Kunum kamok wiin so kunum mak singam aneng unomin memen kesomi, akalem weng afak kunum ilo gaayemei, i teliwi, e akalem mesesem angom alik alik be biim teing dim dako, ‘Yu kilele atenembina!’, yangse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wiin so kamok be akalem weng afak biliw kunum biim kitil e kilele kal kese kasike, e mak kunum beem dulum elote ‘Kunum be teingabi kel tausen (5'000) kulomin kunum ete kai!’, angeko, elo beemdiw dulewse te. Dulewsomi, mali kunum beelo ‘Kunum be auk teben kel tausen (2'000) kulomin kunum ete kai!’, angesomi, elo auk teben kel tausen (2'000) dulewse te. Duleweko, iti mali kunum beelo ‘Kunum be auk makmak tausen (1'000) kulomin kunum ete kai!’, angeko, elo auk makmak tausen dulewse te. Duleweko, alik alik ilo duyemsomi, fe e, unse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Keko beli, teingabi kel tausen (5'000) kuluse kunum be kitil keko, aluweko, tum win on kisol teingabi kel tausen (5'000) makso mak kuluse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Beemdiw, auk teben kel tausen (2'000) kuluse kunum bakati kitil keko, aluwbabomi, iti auk teben kel tausen (2'000) makso mak kuluse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kate, auk makmak tausen (1'000) kuluse kunum be akalem kamokim em dulewse on kisol be kuluko, kawin dikeko, sak kawin tem okiw da kolewse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Keko beli, tiak ding banimse ding dim kabalak e, wiin so kunum kamok be iti teleko, tum win on kisol duyemse kunum biilo yan kiol kelomin weng talse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Telei, teingabi kel tausen (5'000) kuluse kunum emisik teleko, akalem kamok elo bokolewomele: ‘Kamok kutaka! Ne kom teingabi kel tausen (5'000) dunemselew on kisol be kuluko, kitil keko, aluwsomi, iti teingabi kel tausen (5'000) makso mak kulusi te.’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Dangei, e bokolewomele: ‘Ku kunum ken ati te! Fong gel eisneng beso kitil keko, dawtoloko, fian kelewselew kasike, ku kame fian eisneng akati kute kuw atebokolew te! Kame ku neso teleko, bomi, kalfongolewka!’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Dangei, auk teben kel tausen (2'000) kuluse kunum bakati teleko, akalem kamok elo bokolewomele: ‘Kamok a! Kom auk teben kel tausen (2'000) dunemselew bakati, ne beem mutum dawtoloko, auk teben kel tausen (2'000) makso mak kulusi te.’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Dangei, kamok be bokolewomele: ‘Ku kunum ken ati te! Fong gel eisneng be kitil keko, dawtolo fian kelewselew kasike, ku kame fian eisneng akati kute kuw atebolewka! Kame ku neso teleko, bomi, kalfongolewka!’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Anfel e, auk makmak tausen (1'000) kuluse kunum bakati teleko, akalem kamok beelo bokolewomele: ‘Kamok kutaka! Ne kulo kilele kal kelite: Ku kunum atul nam kebelew kasike, ne kom angan finganbi te. Ku mali kawtiw im eisneng dukubiliwi, iti kulukabelew kunum kute te. Mali kawtiw mak i wanin musun mak kaibiliwi, ku musun be uneko, ‘Kulusiliw tum win em yan e kame dunemina!’, yangakabelew kunum kute te. ");
INSERT INTO bhl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kasike, ne finganbomi, kawin dikeko, kom nelo dunemselew on kisol be kawin tem kel dasi te. Kame, kom dunemselew on kisol bakalaka!’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dangei, akalem kamok be elo yan weng bokolewomele: ‘Weng afak kunum wa sel kute te! Ku kal kelewete: Ne mali kawtiw ilo duyemsi eisneng beem iti kulukabi kunum nete te. Ne mali wanin musun kaibiliw kawtiw mak im musun kalo uneko, ‘Nem yulo duyemsi tum win beem yan e kame iti dunemina!’, angbomi, yan beem dulum elote wanin be kulukabi kunum nete te. ");
INSERT INTO bhl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kasike, nimtew angom ete, ku nem dukemsi tum win be mali kawtiw im on kisol yetebiliw kunum im teing dim dalinba keselew a? Daselew tewe, tum win be iti fufu fian kese tew te. Kelei, nem iti talsi ding dim kabalak e, ne tum win fian alik alik be iti kuli tew te.’, dangse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dangeko, e kawtiw ka biliw biilo bokoyemomele: ‘Yu fongate akate weng afak kunum wa kaleem on kisol be kuluko, mali on kisol dawtoloko, tum win fufu beem anung be iti teingabi kel tausen (5'000) kuluse weng afak kunum beem teing dim elo dulewina! ");
INSERT INTO bhl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nimtew angom? Ne mali em so kebiliw kawtiw ilo iti makso duyemii, i banban kelokoliw kate, ne mali em banim kebiliw kawtiw im fong gel eisneng bakati alik alik kulu koyemoki kasike.’, yangse te. ");
INSERT INTO bhl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yangeko, iti bokoyemomele: ‘Kame soson nam kunum beelo fongate akate anbakalalina! Keliw kano, sun kuw betbet deimin abiw ka kel bomi, amebomi, akalem kal wakal dukuko, teing feiwbomi, teing bulung gilkabomi, boke te.’, yangse te. Kasike, yu kilelbiko, fakam weng beelo kilele ibolow fukunemoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yangeko, iti weng mak bokoyemomele: “Kawtiw Aul nem wiin fian so toloki ding dim kabalak e, ne kamok keko, auk so kitil so kesomi, Sunbin-Got em yemdakamin finik iso, toloki te. Beem ding dim bakate, Kawtiw Aul ne emisik kamok fian em teinkemin abin ayem wiin so dim ka kel teinoki te. ");
INSERT INTO bhl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Beem ding dim bakate, kunum waneng alik alik angom bi nem kiin dim wensanokoliw te. Wensaniwi, ne ilo yetemeko, siwsiw yetebin kunum im siwsiw teing bokoko, mali da mali da koyemkabiliw atew keyemeko, ikati kunum mongom alew mak keyemoki te. ");
INSERT INTO bhl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Keyemeko, siwsiw atew kebiliw kunum waneng ilo yuk teing dulum elo keyemsomi, meme atew kebiliw kawtiw ilo awan dulum elo keyemoki te. ");
INSERT INTO bhl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Keyemeko, kamok fian nem yuk teing dim kel biliw kunum waneng ilo bokoyemomeli: ‘Yu kame telina! Nem Aatim em bamki kuliw kasike! Sua sua kel akate, kawin so abiil so be kailinba bise ding dim kabalak e, nem Aatim e akalem gawman ding dim be yom dulum elo memen keyemse kasike kame, yu ding dim be fan atew kulina! ");
INSERT INTO bhl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nimtew angom? Sua kel akate, nem yemen tew so bisi ding kabalak e, yu nelo wanin nemgiyemaliw te. Kesomi, nem ok tew so kebisi ding dim e, yu nelo ok nemgiyemaliw te. Nem kokow kunum atew telebisi ding dim e, yu nelo yukalem am elo nemde unemaliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nem kal musun bisi ding dim kabalak e, yu nelo ilim dunemiwi, ne kal kasi kemali te. Nem wakamin fian kebisi ding dim bakate, yu nelo kilele kenemaliw te. Nem sok am tem bisi ding dim bakate, yu nelo netebamaliw te.’, yangoki te. ");
INSERT INTO bhl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yangii, kiol kuw kukuw kemaliw kunum waneng i nem yangbi weng be kiliko, dakalalomeliw: ‘Kamok kutaka! Ku nal kel yemen tew so kebelewi, nu wanin kamensuluw a? Nalem tit ete ku ok tew so kebelewi, nu ok kamensuluw a? ");
INSERT INTO bhl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nalem ding ete ku kokow kunum atew kelewi, nu kulo nukalem am elo kamde unesuluw a? Nalem ding ete ku kal musun kelewi, nu kal kasi kokemsuluw a? ");
INSERT INTO bhl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nalem ding ete, ku wakamin so kebelewi, nu kilele kekemsuluw a? Nalem tit ete ku sok am tem belewi, nu katebam telesuluw a?’, nangeko, dakalalokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dakalaliwi, kamok fian ne ilo yan weng be bokoyemomeli: ‘Nimin kunum waneng ite mak nem angin wiin banim mak ilo kaneyemaliw tewe, nelo makuw kenemaliw bakate.’, yangoki te. ");
INSERT INTO bhl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Yangesomi, ne famdes angeko, teing awan dulum ka biliw kawtiw biilo bokoyemomeli: ‘Sunbin-Got e yulo yamkatiko, koyemkabe kawtiw yutaka! Fongate akate yu nem mit biliw kale koleweko, sunsun be ais dong tem kalo unina! Ais dong tem be Seten-Ataanim so, akalem finik wa so, alik alik biim dulum memen keyemsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nimtew angom? Nem wanin tew so kebisi ding kabalak e, yu nelo nemgiyeminba kemaliw te. Nem ok tew so kebisi ding dim e, yu nelo ok nemeninba kemaliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nem kokow kunum kebisi ding dim e, yu nelo yukalem am elo nemde uninba kemaliw te. Nem kal musun kebisi ding dim kabalak e, yu nelo kal kasi koneminba kemaliw te. Nem wakamin fian mak kebisi ding so, nem sok am tem bisi ding so, diwkuw yu nelo kilele neteminba kemaliw te.’, yangoki te. ");
INSERT INTO bhl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yangii, ikati nelo dakalalomeliw: ‘Kamok kutaka! Ku nal em tit kete yemen tew so, ok tew so kebelewi, nu kulo ok so wanin so kameninba kesuluw a? Nalem ding ete, ku kokow kunum atew talbelewi, nu kulo nukalem am elo kamde uninba kesuluw a? Nalem ding ete ku kal musun kebelewi, nu kal kasi kokeminba kesuluw a? Nalem ding ete, ku wakamin so kesomi, sok am tem belewi, nu dokokeminba kesuluw a?’, nangokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nangiwi, ne ilo ikati yan weng bokoyemomeli: ‘Nimin kunum waneng ite mak nem angin wiin banim mak ilo mesesem mak kaneyeminba kemaliw tewe, i nelo makuw akati keneminba kenemaliw bakate.’, yangoki te. ");
INSERT INTO bhl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yangii, kanesiliw kawtiw bi ikalem kanesiliw beem dulum elote betbet fian kulukabiliw abiw kalo uneko, ka kel diwkuw diwkuw bokoliw kate, kiol kuw kukuw kemaliw kawtiw i finik so sunbin bin kulukabiliw abiw kalo uneko, sunsun finik so bokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yangeko, em kukuyemse weng be alik alik banim kelewse ding bakate, Yesus e akalem gelewkabiliw kunum biilo bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Alew ding banimei, Abanggayemse Ding keloke te. Beem ding dim kabalak e, i Kawtiw Aul nelo maka im teing dim da konemsomi, ais dim da konemeko, neniwi, ne kuanoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Beem ding dim bakate, Sunbin-Got em am yol em kunum ayem sel so, em angin bi iso, Isalael kawtiw im kak yetebiliw kunum iso, alik alik i Sunbin-Got em am yol em kunum ayem sel Kaiafas beem am fian ka kel bongguko, ");
INSERT INTO bhl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesus elo alomin yawal deiw fensiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nimtew angom? I bokolomeliw: “Nu elo Abanggayemse Ding bakate aluw tewe, kunum waneng nulo yetemsomeliwi, nu im ibolow silikmoyemuwi, i weng ane ane keko, ganokoliw sako!”, angsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Beli, Yesus e Betani abiw fong gel ka uneko, Saimon em am ka kel bise kale. Sua e, Saimon be bulul abung fian so kesomi, alenale kunum ete kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Beem wanin wansiliw ding dim bakate, waneng mak Yesus em mit mewso teleko, on kisol so tum kaisiliw ok sen mak de teleko, Yesus em kak dim ka kel kamge eisneng mak busel kolewsu kale. Sua e, waneng bu tum win fian fian mak kuluko, kamge so eisneng be wesu kate kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Keko beli, akalem gelewkabiliw kunum bi um kanebu eisneng be atemsomi, digaka keumeko, bokoumomeliw: “Ibo yake! Nimtew angom ete ku kaneko eisneng kale tutubelew a? ");
INSERT INTO bhl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nu kamge eisneng kale kuluko, dabalasomeluwi, on kisol so alwol keko, wensiliw tewe, nu tum win fian fian mak kuluko, ki kesomi, em banim kawtiw ilo duyemeko, ilo dokoyemokoluw tew te!”, wangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Wangbiwi, Yesus e im kaneliw be kal kesomi, bokoyemomele: “Yu nimtew angom ete waneng kaluulo ilum dukaumbiliw a? Usik nelo ken ati eisneng mak kenembu kasike. ");
INSERT INTO bhl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Em banim kawtiw i diwkuw diwkuw yuso biliw kate, ne nam diwkuw diwkuw yuso boki te. ");
INSERT INTO bhl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Waneng kalu fom kal dim em kabiyemkabiliw kukuw geleweko, kamge eisneng beso nelo kame kuw memen kenembu kasike, sow em kuanoki ding dim kabalak e, i ki keko, nelo sak fomkamin dim ka kel da konemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yu kililina! Kunum waneng uneko, Sunbin-Got em Weng Kal Ken Ati kale bakayem tem bakayem tem unokoliw aneng aneng angom alik alik biim kasel i waneng kaluum kanesu sang bakati kiliko, ibolow fukunokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Beli, Yesus em kalun kel gelewkabiliw kunum biim kunum mak em wiin e Sudas ete kale. E Iskaliot abiw kunum ete kale. Beem ding dim bakate, e Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, alik alik biim mit mewso uneko, ");
INSERT INTO bhl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ilo dakalalomele: “Ne Yesus be yom teing dim da koyemi tewe, yu nimtew eisneng mak nelo nemenokoliw a?”, yangei, i weng teko, tum win on kisol 30 kel dulewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Dulewiwi, e Yesus elo im teing dim dalomin deiw fense kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Beli, Belet Wanin Fasulinba Wanakabiliw em Ding dim mewso kese kale. Ding beem emisik ding dim bakate, Yesus em gelewkabiliw kunum i elo bokolewomeliw: “Kamok kutaka! Ku bokoyema! Nu nal kel ete uneko, Abanggayemse Ding wanin wanomin memen kelokoluw a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Dangiwi, e yan weng bokoyemomele: “Yu abiw mutuk fian kalo uneko, kaneko kunum em mit mewso uneko, elo bokolewomeliw: ‘Nukalem kukuyemin kunum e bokokemomele: ‘Sunbin-Got em ding dukunemse ding e kame mewso kele kasike, neso, nakalem nenggelewkabiliw kunum biso, alik nu teleko, kom am kel Abanggayemse Ding wanin wanokoluw te.’, kange te.’, dangoliwka!’, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yangei, i uneko, Yesus em yangse weng geleweko, Abanggayemse Ding wanin wanomin memen kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kesomeliwi, ataan tem dokong ange ding dim bakate, Yesus so, akalem kalun kel gelewkabiliw kunum iso, i am ka kel abin dim dak teinsomi, wanin wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wansomeliwi, Yesus e bokoyemomele: “Yu kililina! Mak nukalem mutuk be kunum mak nelo maka im teing dim da konemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yangei, i ibolow tiaktiak kesomi, ikalem dakalale dakalale kesomi, bokolewomeliw: “Kamok a! Nem dulum elo nangbelew bani?”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kemiwi, Yesus e yan weng bokoyemomele: “Neso makuw teing deeko, wanin kuluw kunum bete nelo maka im teing dim da konemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sunbin-Got akalem fut tem kel ‘Be kaneloka!’, angse kasike, kawtiw i beem angse emdiw keko, Kawtiw Aul nelo kanenemokoliw kate, nelo maka im teing dim daloke kunum be kal ilum fian inkalso mak kuloke te. Kuloke kasike, e bokolomele: ‘Ibo ibo! Nimtew angom ete yem u nelo namkusu yake!’, yangeko, oloke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yangei, Yesus elo maka im teing dim da kolewoke kunum Sudas akati dakalalomele: “Kukuyemin kunum kutaka! Ku nem dulum elote nangbelew sako?”, dangeko, dakalase kale. Dakalalei, Yesus e yan weng bokolewomele: “No! Kukalem ete angew baka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Keko beli, im wanin wanbiliw ding dim bakate, Yesus e belet wanin mak kuluko, Sunbin-Got elo “Weso! Seyo!”, dangeko, fakal fakal keleweko, akalem gelewkabiliw kunum ilo duyemsomi, bokoyemomele: “Kale nakalem kal anggil em kiskiw ete te. Yu kuluko, wanina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yangeko, e wain ok sen akati kuluko, Sunbin-Got elo “Weso! Seyo!”, dangesomi, mali ilo duyemsomi, bokoyemomele: “Alik yu wanina! ");
INSERT INTO bhl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Wain ok kale nem kitakamin em kiskiw ete te. Kiskiw beem mongom e kanekote: Ne yom abin kuluko, nem kaim buselsomi, kuanoki kasike, yom sili sili nam ibolow be sak misim kuw kulu koyemoki te. ");
INSERT INTO bhl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yu kilele kililina! Ne wain ok makso nam wanoki kate, deiw mak ding mak, Aatim em gawman ding dim kabalak e, yuso neso alik nu makuw wain ok kikis mak kuluko, makuw wanokoluw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yangesomelei, i Sunbin-Got elo sim kutilewsomeliwi, abiw mutuk ka koleweko, Oliw amgu tikin kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Keko beli, Yesus e akalem gelewkabiliw kunum biilo bokoyemomele: “Mililiw mutuk kabalak e, yu nelo fein konemokoliw te. Nimtew angom? Sunbin-Got em fut tem bokolomele: ‘Ne siwsiw yetebin kunum alii, siwsiw angom bi bayemeleko, alik alik i fonsangin unokoliw te.’, angse kasike. ");
INSERT INTO bhl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yu kililina! Nem kuaneko, iti baba teinoki ding dim bakate, nemisik Galili aneng kalo unii, yu nem ibik elote tololiwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yangei, Fita e yan weng bokolewomele: “Kamok kutaka! Alik alik i kom kanelokolew eisneng be atemeko, finganeko, kokemokoliw kate, nakalem ete nam kokemi te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Dangei, Yesus e yan weng bokolewomele: “Ku kilele kilila! Kutiliw kabalak e, ku alemsal ding keko, bokolomelew: ‘Ne Yesus elo akokow te!’, angokolew te. Angeko, belew ding dim bakate, kakaluk mak gaanoke te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dangei, Fita e kitil weng mak bokolewomele: “Babo! Nete kuw kuso kuanoki kate, kom wiin e nam wokiw da kokemi te.”, dangse kale. Dangei, Yesus em gelewkabiliw kunum mali alik alik bikati em ange weng ki weng kuw bokolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Keko beli, Yesus so, akalem gelewkabiliw kunum iso, i Getsemani Oliw bol dim elo unesomeliwi, e ilo bokoyemomele: “Yu kale kel teinbiliw kano, ne neng kalo uneko, Sunbin-Got eso weng bokoloki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yangesomi, Fita so, Sebidi em muluwel alew iso, ite kuw kuluko, unse kale. Unesomeliwi, e ibolow ilum fian mak kulusomi, ibolow fukunin tiaktiak keko, ");
INSERT INTO bhl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","kunum alemsal biilo bokoyemomele: “Nakati anggil ilum fian mak kulusomi, kuanomin kis keli te. Yu kale kel teineko, kuteboliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yangesomi, ilo koyemeko, iti bakalem neng kalo uneko, ka kel katin bukbuk kiinguen kau kawin dim dak mitsomi, Sunbin-Got elo bokolewomele: “Aatim kutaka! Ku nem kuanomin betbet ilum kulomin kemi kale kuluko, konemolewka! Kate, ku kanelom nem ibolow fukunin bete gelewokolew te! Kukalem ibolow ete kuw gelewolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dangesomelei, e akalem gelewkabiliw kunum im mit mewso uneko, yetemete: I kiin ok ilum fian fian kesomi, akalbiliwi, e yetemse kale. Yetemeko, Fita elo bokolewomele: “Wee kutaka! Nimtew angom ete ku kitil kelinba keko, ki keko, sukum ding kuw mak kutelinba kebelew a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Dangeko, kaem gelewkabiliw kunum biilo bokoyemomele: “Yu fongate akate teineko, Sunbin-Got eso weng bokoko, dakalaloliwka! Mesik esik yulo ibolow ki keyemin wa eisneng mak yom ibolow tem matem telesomi, yulo de mit da koyemoke kasike! Nimtew angom? Kawtiw im ibolow tem e ‘Mesesem kaneluma!’, angbiliw kate, im kal e beit nam keko, nam kaneliw kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yangeko, iti uneko, Sunbin-Got eso weng bokolewomele: “Aatim kutaka! Ku nem kuanomin betbet ilum kulomin kemi kale kulinba kelew tewe, bakal ken kuw te. Ne kukalem ibolow ete kuw gelewo yo!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Dangesomi, iti akalem gelewkabiliw kunum biim biliw dim kalo uneko, yetemomete: I kiin ok ilum fian fian kesomi, akalbiliwi, e yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yetemeko, ilo sak koyemsomi, yemamas kel ding Sunbin-Got eso weng bakam unse kale. Uneko, akalem sun bokolewkabe weng bete kuw iti bokolewse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bokolewsomi, iti akalem gelewkabiliw kunum im mit mewso uneko, yetemete: I kait akalbin kuw kebiliwi, e yetemeko, bokoyemomele: “Wee! Yu akalbin kuw kebiliw e? Yu kililina! Kawtiw Aul nelo kawtiw ibolow sili sili nam im teing dim da konemomin ding akati mewso kele te. ");
INSERT INTO bhl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kasike kame, yu teiniw kano, nu unuma! Nimtew angom? Nem maka im teing dim da konemomin kunum akati mewso mew talaka kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yangbe ding dim bakate, i fein yetemiwete: Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, Isalael kawtiw im kak yetebiliw kunum iso, alik alik bi kawtiw mali mak yemdaliwi, i sakam dang atul nam so koung so fole fole kesomeliwi, i Yesus em gelewkabe kunum Sudas eso teliwi, i yetemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Sua e, Sudas e kawtiw mali biilo bokoyemomele: “Nimin kunum ete ne beem mit meso uneko, falal kelewi tewe, yu kunum beelo auleweko, sok so nit net kelewoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yangse kasike kame, e fongate akate Yesus em mit mewso uneko, falal keleweko, bokolewomele: “Kukuyemin kunum kutaka! Belew yako!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Dangei, Yesus e elo bokolewomele: “Nakunum kutaka! Kukalem ibolow fukun telew be kame ki kelolewka!”, dangse kale. Dangei, “Elo aluma o!”, angeko, teliw kawtiw bi Yesus em mit teleko, elo aluweko, sok so teing net kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Keko beli, Yesus em gelewkabe kunum mak sakam dang atul nam tiaktiak kuluko, Sunbin-Got em am yol em kunum ayem sel em weng afak kunum mak beem kalun kak takas kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kelewei, Yesus bokolomele: “Kom sakam dang be iti akalem dukukabelew dim elo dukula! Nimtew angom? Nimin ete akalem on sen bole tewe, akalem sen beem yan kuanoke te. ");
INSERT INTO bhl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kate ku akokow sako? Ne ki keko, nem Aatim elo bokolewomeli: ‘Ku yemdakamin finik kitil nam banso banso yemdalei, i teleko, nelo dokonemoliwka!’, dangi tewe, e fein kiliko, nelo dokonemoke te. ");
INSERT INTO bhl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kate, ne kaneli tewe, Sunbin-Got em fut ayem em ‘Kaneloke te!’, angse weng be nam ki keli te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Keko beli, Yesus e maka biilo bokoyemomele: “Ne yakut ganbin kunum kebi angomi, yu on balam so teleko, nelo ‘Naluuma!’, nangeko, teliw sako? Feinka! Diwkuw diwkuw ne Sunbin-Got em am yol aneng kalo uneko, kawtiw ilo kukuyemkabi kate, nimtew angom ete yu beem ding bakate teleko, nelo ‘Naluuma!’, nanginba kekabiliw a? ");
INSERT INTO bhl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kate yom kaneliw eisneng be suaem Sunbin-Got em bontem dim bakameliw kunum im weng be ki kelewbe te.”, yangse kale. Yangei, akalem gelewkabiliw kunum alik alik i aneng be koleweko, fonsangin unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Keko beli, i Yesus elo debeleko, Sunbin-Got em am yol em kunum ayem sel Kaiafas em am dim kalo debele unsiliw kale. Em am kae, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum so, Isalael kawtiw im kak yetebiliw kunum iso, Kaiafas eso, alik alik i ka kel wensaneko, biliw ete kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Keko beli, Fita akati emikel kuw ibik elote singam tew wokmo wokmo kemdiliko, yenggelew uneko, Kaiafas beem am wati fokoko, uneko, am kayak beem weng afak kunum iso teinbomi, Yesus em kanelokoliw beem dulum elote “I nono kelewokoliw yake!”, angeko, yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Keko beli, Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, Isalael im kak yetebiliw kunum iso, alik alik kunum bi mali Yesus em kanese beem dulum elote dasuw weng bokoko, kiinwalalin tew kebiliw kawtiw mak fensomi, “Nulo yangbiliw weng beem mongom ete nu elo geelewsomi, aluwi, e kuanoka!”, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yangiwi, kawtiw demdem mak dasuw weng de teleko, bokosiliw kate, elo alomin em mongom mak banimse kale. Keko beli, ibik ete, alew kunum mak teleko, ");
INSERT INTO bhl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","weng bokolomeliw: “Kunum be weng mak bokolomele: ‘Mali yu Sunbin-Got em am yol kale dakal dukuliwi, yemamas kel ding kabalak e, ne am yol beelo iti moko, geloki te.’, yangbelei, nu kilisuluw te!”, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yangiwi, kunum ayem sel be moko, Yesus elo dakalalomele: “Ku im weng bakabiliw weng beem dulum elote yan weng mak bokoyeminba kebelew sako?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Dangei, Yesus e elo yan weng mak bokolewinba kese kasike, kunum ayem sel be iti weng kitil weng mak bokolewomele: “Ku Sunbin-Got finik so bin Sunbin-Got em wiin dim e kitil kuw fawtuk ayem weng mak bokonemolewka! Kukalem ete Sunbin-Got em Min Mesaya kute sako?”, dangeko, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Dakalalei, Yesus e yan weng bokolewomele: “Kukalem ete bokolew bakate! Kate alik alik yu kililina! Kawtiw Aul nem toloki ding dim e, yu nelo netemiwete: Ne kitil so auk so Sunbin-Got em yuk teing dim teinsomi, abiil kawtem elote yukam dim kel telii, yu nelo netemokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yangei, kunum ayem sel be kaisuw fian keko, akalem ilim be finggel dukusomi, bokolomele: “Ai yutaka! Kunum be Sunbin-Got elo weng milewbe kasike, nu mali kiinwalasiliw kawtiw makso nam gaayemuw te. Kame akate, alik nu kililuwete: Kunum kale Sunbin-Got elo weng milewbe kasike! ");
INSERT INTO bhl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kame yu nomin ibolow keko, fukunkabiliw a?”, yangse kale. Yangei, i yan weng bokolewomeliw: “Sunbin-Got elo weng milewbe kasike, nu elo aluwi, e kuanoka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dangesomi, Yesus em kiinguen elo kasuk filat dalewsomi, an feiw kolewsomi, teing biki baka keleweko, ");
INSERT INTO bhl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","dakalalomeliw: “Ku Mesaya tewe, kulo ken feiwbe kunum beelo fitew kaim dim dalolewka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Beem ding dim bakate, Fita e Kaiafas em am wati fokoko, ka kel am kayak em weng afak kunum iso bele ete kale. Ka kel iso belei, weng afak waneng mak Fita em mit mewso teleko, bokolewomelu: “Ku Galili aneng fian kunum Yesus beso kakawkabelew kunum kute te!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Dangui, e alik ka biliw kunum waneng biim kiin dim e dasuw bokolomele: “Wee! Ku nimtew nangbelew a? Kom nangbelew weng be ne akokow te!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wangesomi, Fita em uneko, wati ges abisom dim ka kel mose ding dim bakate, iti weng afak waneng mak mali kawtiw ka biliw biilo bokoyemomelu: “Kunum bakati Nasalet abiw mutuk fian em Yesus eso kakawkabe kunum bete te.”, yangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yangui, e kililomi, yan weng bokoumomele: “Sunbin-Got em kiin dim kel fein weng bokokembi te! Ne kunum beelo atin kuw akokow kebi te!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wangesomi, duk tew kele dim ete, Fita em mit mewso mobiliw mali kawtiw ikati bokolewomeliw: “Itel fein te! Ku Yesus beem angin kunum kute te! Nimtew angom? Kukalem weng bokolew weng bakate Galili aneng fian im weng bakamin emdiw kele kasike!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dangiwi, Fita e atin kuw kitil weng fian kuw bokoyemomele: “Itel fein te! Ne fein weng bokolinba keli tewe, Sunbin-Got e nelo atin kuw nenoke tako! Kasike yu kililina! Ne kunum beelo akokow te!”, yangse kale. Em yangbe ding dim bakate, awon kakaluk mak gaanse kale. ");
INSERT INTO bhl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Beem gaane ding dim bakate, Fita e Yesus em elo dangse weng be ibolow fukunse kale. Sua kel e, Yesus e bokolewomele: “Awon kakaluk e gaaninba selei, ku nem wiin alemsal ding kel wokiw danemokolew te!”, dangei, e ibolow fukuneko, yol angesomi, sakik inkal fian kuluko, kut elo fon unesomi, amemin fian makuw amese kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Beli, kutim dane dim e, Sunbin-Got em am yol em kunum ayem sel so, em angin iso, Isalael kawtiw im kak yetebiliw kunum iso, alik alik i weng memen kesomi, Yesus elo “Aluwi, e kuanoka!”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Angesomeliwi, i elo sok nit net kelewsomi, debeleko, aneng beem kamok keko, yetebe kunum Failat em teing dim elo da kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Beem ding dim bakate, Yesus elo maka im teing dim da kolewse kunum Sudas be Yesus em geelewbiliw be atemsomi, e ibolow tiaktiak keko, fukunete: “Ne sen so banim kunum beelo maka im teing dim da kolewi kai!”, angomi, dulewsiliw tum win on kisol 30 kel be kuluko, Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, Isalael im kak yetebiliw kunum iso, alik alik biim teing dim iti duyemeko, ");
INSERT INTO bhl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","bokoyemomele: “Ne sili sili kukuw kesomi, sak sen so banim kunum mak debeleko, maka yom teing dim da koyem kembi kasike.”, yangse kale. Yangei, i yan weng bokolewomeliw: “Numie sen so banim te. Be kukalem sakik ete te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dangiwi, Sudas e tum win on kisol be Sunbin-Got em am yol elo kuse kawtem dasomi, akalem akate uneko, nang wanse kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Beli, am yol em kunum ayem sel so, em angin iso, i tum win on kisol be kuluko, “Kawtiw aliw em yan kasike, am yol em on kisol so nam bongguluw te.”, angeko, ");
INSERT INTO bhl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","weng mak memen kesomi, bokolomeliw: “Nu tum win on kisol be de uneko, kawin ok sen kaibe kunum beem kawin beelo wenuma! Wenuw kano, kawin atuk be Isalael kawtiw num ibik biliw kawiw im fomkamin keboka!”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kanesiliw kasike kame, kawin atuk beem wiin e “Kaim Yan Wesiliw Kawin” keko, alakabe te. ");
INSERT INTO bhl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Keko beli, Sunbin-Got em bontem dim bakamin kunum Selemaya em sua kel fut tem bose weng be dem gilase te. E bokolomele: “Isalael kawtiw i kunum beem yan e tum win kisol 30 kel dukulokoliw te. Dukulomeliwi, i tum win kisol be kulusomi, ");
INSERT INTO bhl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kamok Fian em bokonemse weng kitil nam geleweko, kawin ok sen kaibe kunum mak em kawin yan beelo welokoliw te.”, angeko, fut tem bose te. ");
INSERT INTO bhl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Beli, i Yesus elo debeleko, aneng beem kamok Failat em kiin dim mo kolewsiliw kale. Mo kolewsomeliwi, e elo dakalalomele: “Kute fein Suda kawtiw im emisik kamok fian kebelew kunum kute ye?”, dangei, Yesus e yan weng bokolewomele: “Kukalem ete kuw bokolew bakate”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dangsomelei, Sunbin-Got em am yol em kunum ayem sel so, em angin iso, Isalael kawtiw im kak yetebiliw kunum iso, alik alik bi elo geelewomin weng bokolewsiliw kate, Yesus e ilo yan weng mak bokoyeminba kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kesomelei, Failat e dakalalomele: “Wee kutaka! Ku im geekemiw weng be kililinba kebelew sako? Ku yan weng akal banim sako?”, dangeko, dakalase kate, ");
INSERT INTO bhl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesus e itel yan weng gel makso bokoyeminba kese kale. Kele angomi, aneng beem kamok e yol angeko, ibolow tem tem kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Keko beli, aneng beem kamok kunum be akalem kukuw geleweko, Abanggayemse Ding kele ding dim bakate, kawtiw ka biliw im ibolow geleweko, sok am tem da kolewse kunum mak elo sak kut da kolewomin kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Beem ding dim bakate, kunum mak em wiin Balabas sok am tem alenale kale. Kawtiw alik alik i kukuw wa so kunum beelo kal kelewsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Keko beli, Failat e kal kelete: Kawtiw i Yesus elo ibolow on kelewsomi, gal kelewbiliw angomi, elo maka im teing dim dasiliw kasike, e ka kel wensanbiliw kawtiw biilo dakalalomele: “Ne nimin ete kuluko, kut daloki a? Balabas ete yako? Beni, Mesaya Yesus ete yako?”, yangeko, ilo dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Failat em Yesus elo diw atemeko, geelewomin kele ding dim bakate, akalem kalel u weng kal mak de telesomi, bokolewomelu: “Sin em kutiliw e, ne kiin dem mak seneko, atemite: ‘Kunum kale sen so banim kunum te!’, atemomi, ibolow ilum fian mak kulusi kasike, ku kame kunum beelo kolewewi, e sak unomeka!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Dangsu kate, Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, Isalael kawtiw im kak yetebiliw kunum iso, alik alik i kawtiw ka biliw biilo bokoyemomeliw: “Yu ‘Balabas ete kuw kut da koleweko, Yesus elo alewi, e kuanoka! Kuanoka!’, dangoliwka!”, ange ange keyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Keyemsiliw kasike, Failat em ilo dakalasomi, “Kan ete kut daloki o?”, yangse ding dim kabalak e, i yan weng bokolewomeliw: “Balabas ete kut dala! Elo kuw kut dala!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dangiwi, e dakalalomele: “Mesayas Yesus em dulum elote ne nono keloki a?”, yangei, i bokolewomeliw: “Yesus bete sil bikiko, ais dim alina! Alina!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Dangiwi, e bokoyemomele: “Kate nimtew angom ete ye? E nimtew mamtel kese ya?”, yangse kate, i sakalaw fian keko, fian kuw gaanomeliw: “Babo! Yesus ete kuw ais dim sil bikisomi, alina! Alina!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Keko beli, Failat e yetemete: I ibolow kaisuw kesomi, ibolow alwol kelinba keko, ganomin ibolow kuw kebiliw kasike, e ilo bokoyemomele: “Yu sen so banim kunum kale aliwi, e kuanoke kate, be nem sen bate! Yukalem ete sen so keliw te.”, yangesomi, kiskiw kukuw mak keko, ok sen mak kuluko, kawtiw ka biliw im kiin dim e, akalem teing dim gingko, “Ne sen so banim te!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Keko beli, kawtiw ka biliw kawtiw alik alik i bokolewomeliw: “Fein tako! Kunum aluw beem yan e nuso, num muluwel iso, alik alik nu diwkuw diwkuw kuluboluwka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dangiwi, Failat e kawtiw im gaaneko, bokoliw weng be kiliko, fein geleweko, Balabas beelo sak kut da kolewse kate, e Yesus elo wonuk so kunum im teing dim da koleweko, bokoyemomele: “Yu elo sok mak bitit butut keleweko, an feiweko, ais dim sil biki kolewina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yangei, aneng yetebe kunum beem wonuk so kunum i Yesus elo debeleko, ikalem kak kunum em wonuk so kunum im am ka kel kolewsiliw kale. Kolewsomeliwi, wonuk so kunum alik alik i ka kel wensansomi, ");
INSERT INTO bhl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yesus em ilim gululewsomi, elo desi kelewko, kak kunum atew kelewko, ilim olol nam mak minggilewsomi, weng milewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Weng milewsomeliwi, ningning so sok mak em kak dim falal falal kolewsomi, emisik kamok kunum em tokfol ayem emdiw mak kuluko, em teing yuk dulum elo dulewsomi, weng minin fian mak mileweko, bokolewomeliw: “Suda kawtiw im emisik kamok fian kutaka! Got alik i kulo bamki so kekemoliwka!”, dangsomi, em mit mewso kawin dim katin bukbuk angeko, gatak wakas kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kelewsomi, kasuk filat daleweko, tokfol ayem be Yesus em teing dim aluwbe be iti kuluko, koung beso em kak dim bitibiliw ki kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kelewsomi, ilim olol nam be iti gululeweko, akalem ilim minggilewsomi, ais dim sil biki kolomin debele unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Im debele unbiliw ding dim bakate, wonuk so kunum bi Sailini abiw mutuk fian em kunum mak atemsiliw kale. Kunum beem wiin e Saimon ete kale. I Saimon elo kitil weng bokolewomeliw: “Ku Yesus beem ais kale daok keleweko, de una!”, angeko, kitil kelewsiliw kasike, e Yesus em ais be daoko, kingtei unse kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Keko beli, i uneko, aneng mak em wiin e Golgota kalo unsiliw kale. Wiin beem mongom ete “Kuansiliw Kunum em Kak Kun”. ");
INSERT INTO bhl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kalo unesomi, Yesus elo wain ok kuen atul ok so demeniwi, e wanin tew keko, kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kolewei, i elo fein ais dim sil biki asiliw kale. Asomi, Yesus em ilim be fan bonge bonge kesomi, tum takak so kikinin mak kikinsomi, “Nimin kunum ete kitil kele tewe, e ilim be kuloka!”, angesomi, Yesus em ilim be amen amen kuw kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","37","Keko beli, i ais kok mak Yesus em kak ful dim be kulfilisiliw kale. Ais kok beem dim fut bolomeliw: “Yesus be Suda kasel im emisik kamok kunum ete te!”, angsiliw kale. Angiwi, fut be dukusomeliwi, wonuk so kunum mali mak ka kel teineko, Yesus elo kuteko, atemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kanesiliw ding dim bakate, kunum mamtel kunum alew mak ikati ais dim sil biki yesiliw kale. I mak elo Yesus em yuk teing dulum elo kelewsomi, mak elo Yesus em awan teing dulum elo keleweko, koyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Koyemsomeliwi, mali kawtiw i teleko, Yesus atemeko, kak so bulu bulu angeko, tong milewsomi, ");
INSERT INTO bhl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","bokolewomeliw: “Wee kutaka! Ku Sunbin-Got em Min tewe, kukalem dokokemoka! Sua e, kukalem ete bokolomelew: ‘Ne Sunbin-Got em am yol dakal dukusomelii, alemsal ding keko, iti geko, mo kolewoki te!’, yangselew kasike kame, ku ais el kolewko, kawin dim malak mit tala o!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Dangiwi, Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum iso, Isalael kawtiw im kak yetebiliw kunum iso, alik alik bikati weng milewsomi, ");
INSERT INTO bhl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","bokolewomeliw: “Kutaka! Ku mali kawtiw mak ilo dokoyemkabelew kate kame, kukalem akal dokokemoka! Ku Isalael kawtiw num emisik kamok fian kute sako? Kame fongate akate ais el koleweko, kawin dim malak mit tala! Mit telew kano, nu katemeko, ‘Fein!’, kangokoluw te! ");
INSERT INTO bhl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ku Sunbin-Got elo ‘Fein!’, dangbiliw kunum kute kasike, Sunbin-Got e kom ibolow fukune tewe, e kame kulo dokokemoka! Nimtew angom? ‘Ne Sunbin-Got em Min nete te!’, yangbelew kasike!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Dangiwi, Yesus em yuk dulum bise kunum be so, em awan dulum bise kunum be so, mamtel kunum alew bikati weng milewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Keko beli, ataan mutuk doung ange ding dim bakate, aneng be mililiw mutuk fian mak kesomi, belei, ataan fuwkel ange ding dim e, iti felet angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Beem ding dim bakate, Yesus e weng kitil weng mak gaaneko, bokolomele: “Eli, Eli, alama sabaktani?”, angse kale. Weng beem mongom e kanekote: “Nem Sunbin-Got kutaka! Nimtew angom ete ku nelo ibik da konembelew a?”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Angei, mali kawtiw ka moko, atebiliw kawtiw i em weng gaanse weng be kiliko, bokolomeliw: “E Sunbin-Got em bontem dim bakamin kunum Elia elo gaalewbe sako!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Keliwi, mak e fongate akate uneko, yesum atew eiseng mak wain ok sen tem kabalak bubulow keleweko, ais kang dim wakalako, Yesus elo wain ok atul nam be demense kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Demenei, mali kunum mak bokolewomeliw: “Kolewolewka! Nu Elaisa em toloke ding fenbuluw kasike! E teleko, dokolewoke yako, mani ba yake!”, dangeko, bokolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Dangbiliw ding dim bakate, Yesus e gaanin fian kuw mak kebe ki, atin kuw kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Em kuanse ding dim bakate, Sunbin-Got em am yol em ilim ayem fian be kalat katiw une, kalak une dakaleko, amen amen kuw kese kale. Kelei, bim fian mak kawin filomelei, tum fian banban dakal dukuse kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Dukusomelei, fomkamin banban bikati busuliwi, Sunbin-Got em angin kesiliw kawtiw banban i fom kawin be koleweko, uneko, ka kel anung anung kesiliw kale. Kesomeliwi, Yesus em iti teineko, mose ding dim kabalak e, i Sunbin-Got akalem wiin so galmose abiw mutuk fian Selusalem kawtem unesomi, kawtiw banban im kiin dim kel fitewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kaneko beli, wonuk so kunum im kak kunum so, eso biliw ais dim ka kel kuanse Yesus elo kutesiliw wonuk so kunum iso, alik alik bi bim be so, kanese eisneng alik alik be so, kili atemsomi, finganin fian mak keko, gaanomeliw: “Ibo! Kunum be fein Sunbin-Got em Min ete te!”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kanese ding dim bakate, waneng banban mak singam tew moko, kanese eisneng alik alik be atemsiliw kale. Sua kel, i Yesus elo gelewsomi, Galili aneng fian koleweko, elo dakalewaliw wanggel kealenaliw ite kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Waneng min bi kanekote: Mak u Malia, Makdala abiw mutuk fian em alenalu waneng ute kale. Mak u Sekow so Yosew so, aso im auk Malia ute kale. Mak u Sebidi em muluwel alew im auk ute kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kaem ding dim bakate, emso kunum mak em wiin e Yosew alenale kale. E Alimatea abiw beem kunum keko, Yesus elo gelewkabe kunum te kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yesus em kuanse ding dim bakate, e Failat em mit mewso uneko, dakalako, bokolewomele: “Ne ki keko, Yesus em fom be kuloki ye?”, dangse kale. Dangesomi, e wonuk so kunum ilo bokoyemei, i fein, Yesus em fom be kuluko, dulewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dulewiwi, e ilim fian kais nam mak kuluko, Yesus em fom be falal kelewsomi, ");
INSERT INTO bhl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","fomkamin dim mak debeleko, tum tem kikis ka kel dukusomi, abisom dim elote tum sel mak bulbulun uneko, em abisom dim ka net kelewsomi, unse kale. Sua kel akate, Yosew e mali kawtiw mak bokoyemei, i uneko, akalem fom dukulokoliw tum tem be kilelsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Yesus em fom dukusiliw ding dim bakate, Malia Makdala abiw mutuk em waneng so, nanew Malia uso, alew i ka mewso teinbomeliwi, kanese eisneng be kilele atemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Beli, finengdakamin ding Sabat em memen kemin ding dim banimei, Sabat ding dim bakate, Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, mali Falisi kunum iso, alik alik bi Failat elo atebam unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Unesomi, elo bokolewomeliw: “Kamok kutaka! Kame kuw nu dasuw kunum beem sua bokose weng mak ibolow fukunuw te. E bokolomele: ‘Alemsal ding dim banimei, ne iti fomkamin dim elote teinoki te!’, yangse kasike kame, ");
INSERT INTO bhl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ku kitil weng mak bokolew kano, alemsal ding banime ding dim bakate, fomkamin dim beem kutelokoliw kunum mali mak yemdalalolewka! Nimtew angom? Mesik esik akalem gelewkabiliw kunum i akalem fom be yakut keko, debele unesomi, bokolomeliw: ‘Yesus akati teinko, unembe te!’, angesomi, im dasuw weng be Yesus em emisik weng dasuw bokose weng beelo bakilewoke kasike.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dangiwi, Failat e bokoyemomele: “Kenka! Yu wonuk so kunum mali mak kuluko, fomkamin beem kutebin kunum emdiw mololiwka! Mosomeliwi, yukalem ete yukalem kukuw geleweko, fomkamin beem abisom be atin kuw kilele net net kelewbina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yangei, i uneko, bat eisneng emdiw mak tum tikin beem dim dukusiliw kasike, mali kawtiw i beelo atemeko, “Kanelom kalo unemokoluw te!”, angeko, kilele kal kelokoliw te. Keko beli, wonuk so kunum bi ka kel kutebomeliwi, alenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Beli, Suda kawtiw im finengdakamin ding Sabat banimei, iti aneng daneko, ataan mewso ailomin kele ding dim bakate, waneng alew mak Yesus em fomkamin dim elo atebam unsiliw kale. Waneng mak u Makdala abiw mutuk beem waneng Malia ute kale. Mak u buum wiin taman Malia ute kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Waneng uso biim uneko, kalo telinba kesiliw ding dim bakate, bim fian sel mak teleko, keskes kese kale. Nimtew angom? Kamok Fian em dabalakamin finik mak abiil tikin elote talse kasike. E teleko, Yesus em fomkamin dim beem tikin tum ilum nam be kuluko, benggew kel dukuko, beem tikin kel teinse kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Dabalakamin finik beem kal anggil be bamneng filik falak atew kesomi, em ilim e kais nam ati kese kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Keko beli, wonuk so kunum Yesus em fomkamin kutebiliw kunum i elo atemeko, finganin fian mak kesomi, walwal keko, fom mitsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Beli, waneng alew biim teleko, kanele eisneng be atemsiliw ding bakate, i fingansiliw kate, Sunbin-Got em dabalakamin finik be bokoyemomele: “Yu kanelom finganokoliw te! Ne kal kelite: Kuso yu ais dim sil bikiko, asiliw kunum Yesus beelo fenem talbiliw kate, ");
INSERT INTO bhl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","e kale kel binba be te. Akalem sua kel bokoyemse weng kame fein kelei, e iti finik so baba teinkembe kasike. Kuso yu kaleelo fom atebam teliw kate, abin iti kuw atemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Atemsomi, fongate akate uneko, akalem gelewkabiliw kunum biilo weng kal kale duyemeko, bokoyemomeliw: ‘Yesus em sua kel bokoyemse weng be kame dem gilase te. E finik so baba teinkembe! Kame emisik Galili aneng kalo uneko, yom tolokoliw ding fenbe kaiske!’, yangoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yangei, uso i finganin so, kalfong fian so makuw kesomi, fomkamin dim ka kolewsomi, fongate akate Yesus em gelewkabiliw kunum ilo kalan weng bakayem de unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Uso im de unsiliw ding dim bakate, Yesus akalem ete uso iso mit tele tele kesomi, e uso ilo bokoyemomele: “Kutim o!”, yangei, uso i em mit mewso uneko, katin bukbuk angeko, em yan falal keleweko, em wiin fian daolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Daolew kemiwi, Yesus e uso biilo bokoyemomele: “Kuso yu kanelom finganemokoliw te! Kuso yu uneko, nakalem nakunum kumel ilo nem kaneko weng be bokoyemoliwka! ‘Yukati Galili aneng fian kalo unesomi, ka kel nelo netemina!’, yangoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Yangei, waneng alew biim unsiliw ding dim bakate, fomkamin dim kutebiliw wonuk so kunum mali mak Selusalem abiw mutuk fian kawtem uneko, Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, alik alik biilo im dim kanese eisneng alik alik be bokoyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bokoyemsomeliwi, i kunum biim yangsiliw weng be kiliko, yol yol angeko, Isalael kawtiw im kak yetebiliw kunum iso, bongguko, kitil weng mak kitokosomi, wonuk so kunum biilo tum win on kisol fian mak duyemeko, ");
INSERT INTO bhl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","kitil weng mak bokoyemomeliw: “Yu uneko, kawtiw ilo bokoyemomeliw: ‘Num kutiliw mutuk ding kabalak kel akalbuluw ding dim bakate, akalem gelewkabiliw kunum i teleko, kunum beem fom be yakut keleweko, debele unembiliw te.’, yangoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yangiwi, yukalem kamok Failat e yom yangbiliw weng be kiliko, kaisuw keyeme tewe, nu uneko, eso weng kilelelokoluw te. Kasike, yu yukalem dasuw yangbiliw weng beem mongom ete nam ilum fian mak kuliw te!”, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yangesomeliwi, wonuk so kunum bi tum win on kisol fian be kuluko, kaneko weng be bakayem tem bakayem tem unsiliw kale. Keko beli, wonuk so kunum biim yangankakawkabiliw sang be, kawtiw banban kiliko, ikati bakayem tem bakayem tem unsiliw kale. Uniwi, telbiko, kameem ding akati Suda kawtiw banso im yangenkakawkabiliw sang beelo “Fein!”, dangbiliw bakate. ");
INSERT INTO bhl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Beli, Yesus em guel kel gelewkabiliw kunum bi Galili aneng fian kalo uneko, amgu tikin mak katem unsiliw kale. Nimtew angom? Yesus e bokoyemomele: “Yu amgu tikin kalo unoliwka!”, yangse kasike. ");
INSERT INTO bhl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Keko beli, i kalo uneko, ka kel Yesus atemeko, em wiin fian daolewsiliw kate, i bangbang ibolow alew kesomi, alenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kebiliwi, Yesus e im mit mewso teleko, bokoyemomele: “Sunbin-Got e nelo kitil so auk so wiin fian mak dunemse kasike, abiil tikin kel akal, kawin dim kale kel akal, alik alik angom be nem afak kuw be te. ");
INSERT INTO bhl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kame yu kililina! Yu abiil fe kawin fe alik alik aneng aneng angom em biliw kawtiw im dim uneko, ilo nakalem nenggelewbin kunum waneng keyemoliwka! Keyemsomi, ilo Sunbin-Aatim so, Sunbin-Min neso, Sunbin-Finik eso, alemsal num wiin dim kel ok da koyem kemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Keyemsomi, ilo nem yulo kukuyemsi weng alik alik bakati ‘Yu kanelina!’, yangeko, kukuyemoliwka! Yu kilele kililina! Kawin kale banimoke kate, ne sunsun yuso boki te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kale kel, Sunbin-Got em min Yesus Kulais em Weng Kal Ken Ati em talfut kese sang te. ");
INSERT INTO bhl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sua e, Sunbin-Got em bontem dim bakamin kunum Aisaya e Sunbin-Got em Mesaya em dulum elote bokolewse weng fitew dim bokoko, fut tem bolomele: “Ku kilila! Ne nem dabalakamin kunum komisik dabalalii, e nem weng deeko, kom ibik tolomin em deiw kileleko, memen kelewboke te. ");
INSERT INTO bhl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kunum waneng banim dim elote, gaanin fian mak gaanomele: ‘Kamok Fian em deiw memen kelina! Akalem deiwkim aim tem kebe be kilelina!’, gaanin mak angoke te!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Beli, ok da koyemin kunum Sion e kunum waneng banim dim kel teleko, bomelei, kunum waneng em dim talsiliw kunum waneng ilo Sunbin-Got em kukuyemin weng yangeko, bokoyemomele: “Sili sili nam ibiku kolewko, ibolow famdeko, Sunbin-Got em ibolow gelewemoliwka! Gelewiwi, e yom sili sili kukuw beem yan bakate kulu koyemi, ne yulo ok da koyemoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yangei, Sudia aneng fian em kasel so, Selusalem abiw mutuk fian em kasel iso, kawtiw banban bi Sion em mit mewso teleko, fein ikalem sili sili nam kukuw kaim fileliwi, Sion e ilo Yoldan bang ka kel ok da koyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Sion e kamel samal im kalim fasiliw ilim minggibomi, samal kal yewet mak kuluko, akalem kakam falal kelewbomelei, sak kuieng a, mong tugul abal a, bete kuw wanenale kunum ete kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Beli, Sion e kunum waneng alik alik ilo bokoyemomele: “Yu kililina! Nemteben mak kunum mak toloke ye, e Kamok Fian kitil so kasike, nete ki keko, em yan mit mewso uneko, elo dokoleweko, em yan aum sok e ne nam silelewi te. ");
INSERT INTO bhl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne yulo sak ok kuw ok da koyembi kate, Kamokim be yulo fein Sunbin-Finik so ok da koyemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Beem ding dim bakate, Yesus e Galili aneng fian em abiw mutuk fian Nasalet be koleweko, Sion em bise aneng kalo em fukun talse kale. Telei, e elo Yoldan bang ka kel ok da kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ok da kolewei, em kut matem tele ding dim bakate, Sunbin-Got em kitil e abiil elo amen amen keko, busok angei, Sunbin-Finik e abim atew awon kawkaw mit elo keemeko, em dim telei, e atemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Atemeko, abiil kawtem ete weng mak bokolomele: “Kute nem ibolow mutuk fian so dukembi min kute te. Ne kalfong so katebi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Beli, Sunbin-Finik e Yesus em ibolow tem elo sililmolewse kasike, e kawtiw banim dim mak elo uneko, ");
INSERT INTO bhl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ka kel e, 40 ding kelei, Seten-Ataanim e elo kak kelewse kale. Kak kelewse ding dim bakate, Yesus e kut samal im biliw dim bomelei, Sunbin-Got em yemdakamin finik i teleko, Yesus em anggil elo dawkitil mosiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Beli, deiw mak ding mak kelei, emisik kamok fian Antibas Kelot e ok da koyemkabe kunum Sion elo sok am tem da kolewse kale. Kolewse ding bakate, Yesus e Galili aneng fian ka kel Sunbin-Got em Weng Kal Ken Ati be bokoyemomin talse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Teleko, kunum waneng ilo bokoyemomele: “Yu kilele kililina! Sunbin-Got em sua ‘Toloke!’, angse ding dim e, kameem ding bakalete. Feinka! Sunbin-Got em gawman ding dim e kame mewso kebe kasike, yu sili sili nam ibiku kolewko, ibolow famdeko, Sunbin-Got em Weng Kal Ken Ati beelo ‘Fein!’, dangoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Beem ding dim e, Yesus e Galili okmun gu dim unbomi, awkunum kumel takam takamin kunum alew mak yetemse kale. Kunum mak em wiin e Saimon ete kale. Akalem awkunum em wiin e Andulu ete kale. Yesus aso ilo yetemete: I takam wakal men so takam takabiliwi, e yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yetemomi, aso ilo bokoyemomele: “Wee! Kaso yutaka! Kaso yu nelo nenggelew teliw kano, ne yulo kunum waneng kulamin kunum keyemoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yangei, fein, aso i em yangse weng be fein kiliko, fongate akate ikalem wakal men be welel koleweko, Yesus elo gelew unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Keko beli, e iti nengka uneko, iti alew kunum mak yetemse kale. Mak em wiin e Sekow e, mak em wiin e Sion e, aso ite kale. I Sebidi em muluwel keko, kunuw dim bomi, takam wakal men kileleko, benebomi, alenaliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Biliwi, Yesus e ilo gaayemei, aso i em yangse weng be kiliko, alew Sebidi so, akalem aluwbamin kunum iso, kunuw dim ka kel fongate akate koyemeko, aso Yesus elo gelew unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kaneko beli, Yesus so, akalem gelewkabiliw kunum iso, alik alik bi uneko, Kabelneam abiw mutuk fian elo uneko, ka kel alenaliw kale. Ka kel bomeliwi, Sabat finengdakamin ding kele ding dim kabalak e, e diwkuw Suda kawtiw im wensankabiliw am kawtem uneko, kunum waneng ka biliw biilo kukuyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kukuyemei, kunum waneng i Yesus em kukuyemse weng be kililomi, yol angsiliw kale. Nimtew angom? “Em nulo bokoyemkabe weng be Sunbin-Got em kukuyemin weng kalem aulewko, kukyemkabiliw kunum im weng emdiw bate. Yesus em weng be auk so kitil so weng kele kai!”, angsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Im wensankabiliw am ka kel biliw ding mak e, aneng matil em dim be kunum mak belei, i atemsiliw kale. Atemiwi, aneng matil be gaaneko, ");
INSERT INTO bhl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Yesus elo bokolewomele: “Nasalet kunum Yesus kutaka! Ku noyemomin talbelew a? Ku nulo yeneko, banimomin telew sako? Feinka! Ne kal kelite: Ku Sunbin-Got akalem wiin so amkose kiol kuw kunum kute te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dangei, Yesus e weng kitil weng mak bokolewomele: “Fongate akate kimi angeko, kunum be koleweko, unolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dangei, aneng matil be kunum beelo yan teing so biting biteng keleweko, gaanin fian kuw gaaneko, fe e, kunum beelo kalis kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kolewei, kunum waneng ka biliw kawtiw alik alik i yol angeko, weng bokolew bokolew kelomeliw: “Be nomin eisneng ete? E auk so kitil so kukuyemin kikis mak kukuyemkabe te! E aneng matil biilo kitil so auk so weng mak bokoyemei, i fongate akate em yangbe weng be kiliko, gelewkabiliw kasike!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kesomeliwi, Yesus em kanese sang be fongate akate Galili aneng fian em aneng aneng bokoyem yak bokoyem yak keem unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Beli, beem ding dim bakate, Yesus so, akalem ketket teben gelewkabiliw kunum Saimon e, Andulu e, Sekow e, Sion e, alik alik bi Suda im wensan kekabiliw am dim be koleweko, Saimon so Andulu so, awkunum kumel biim am kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Unom ete, Saimon em kalel um auk u kal mamin wakamin so abin kon tem akalbu kasike, i Yesus elo fongate akate um kanebu sang be bokolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bokolewiwi, e kiliko, um akal kebu dim elo uneko, um teing kitil woluko, ulo tein koumei, wakamin be fein koumse kale. Koumei, u moko, wanin fuyemsu kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Keko beli, ataan tem dokong ange dim keko, Sabat finengdakamin ding banim kele ding bakate, kunum waneng i wakamin kal wanin kawtiw so, aneng matil im dim biliw kawtiw so, kawtiw banban bi Yesus em mit yemde talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Telesomeliwi, Kabelneam abiw mutuk fian kaem kasel banban i teleko, Yesus em be am beem abisom mewso mosiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Keko beli, e wakamin kal wanin kawtiw banban bi okmino koyemsomi, aneng matil mali kawtiw im dim biliw aneng matil banban akati takala koyemse kale. Takala koyemei, aneng matil im kaim weng bokoliw weng beelo “Ayem! Yu kimi angoliwka!”, yangse kale. Nimtew angom? Aneng matil bi kal keliwete: “Yesus be Sunbin-Got em Min ete kai!”, angeko, kal kebiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Beli, kutiliw fian kelei, ataan telinba sele ding dim bakate, Yesus e teineko, aneng be koleweko, kawtiw banim dim mak elo Sunbin-Got eso weng bokolomin unse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Weng bokose ding dim bakate, Saimon so, akalem akunum so, ikati teineko, Yesus elo fenem unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Fenem uneko, elo atemeko, bokolewomeliw: “Kutaka! Kunum waneng banso mak kulo fenem kakabiliw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Dangiwi, e yan weng mak bokoyemomele: “Kunum waneng ilo Sunbin-Got em weng kukuyemomin beem mongom talsi kasike, ne abiw mak abiw mak unesomelii, ilo kukuyemkabi te. Kasike kame, nu abiw kale koleweko, iti abiw nengso nengso unuma o!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yangei, fein, i aneng ka be koleweko, Galili aneng fian em abiw abiw alik alik kakabomeliwi, Yesus e Suda kawtiw im wensankabiliw am dim kel kukuyemkabomelei, aneng matil kawtiw im dim biliw aneng matil takala koyemkakamele kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Deiw mak ding mak, kunum bulul abung fian so kelebe kunum mak Yesus em mit mewso teleko, katin bukbuk teinsomi, elo kitil weng kuw bokolewomele: “Ku auk so kunum kasike, kukalem ibolow kuw gelewsomi, nelo iti mali im kiin dim e kais ati kuw kenemolewka o!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dangei, Yesus e ibolow kinkin keleweko, akalem teing deeko, beem kal dim dukuko, bokolewomele: “No dokokemo yo! Kame kais ati kuw kela!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dangeko, fongate kuw em kal dim em bulul abung fian be atin kuw wokminolei, kunum beem kal anggil be iti Sunbin-Got em kiin dim e kais ati kuw kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kelewei, Yesus e elo dabalaleko, weng kitil weng mak bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ku kanelom mali kawtiw mak ilo ikati bokoyemokolew te! Kukalem kuw Selusalem abiw mutuk fian katiw elo uneko, Sunbin-Got em am yol kunum ayem beem afak kunum biim mit mewso unesomi, kom iti kais kelew kal be ilo kukuyemolewka! Kukuyemsomi, Moses em sua kel iti kal kais kemin em kukuyemin beem dulum elote “Yu kanelina!”, angse weng be gelewolewka! Keko beli, mali im kulo katemiw ding dim bakate, i nem kanekembi be atemsomi, nem kitil fian be fein kal kelokoliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Dangse kate, kunum be Yesus em be dim koleweko, em dangse weng be sakalaw keko, weng bo bo kelewko, akalem kal dim em kanelewse em sang be bokoyem tem bokoyem tem keem unse kale. Kaneko beli, Yesus e ki keko, kawtiw im kiin dim kaim dim kel mali abiw mutuk fian kawtem uninba kese kasike, e kawtiw banim dim kuw ke alenale kale. Bomelei, kawtiw banban i ikalem abiw abiw be koleweko, em fukun unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mali ding mak banime ding dim e, Yesus e iti Kabelneam abiw mutuk fian elo unse kale. Unesomelei, abiw kasel bi em teleko, am mak unse sang kilisiliw kasike, ");
INSERT INTO bhl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","kunum waneng banban mak teleko, em be am be gek geko, abin dolon gel so banim kesiliw kale. Beli, Yesus e talsiliw kunum waneng biilo Sunbin-Got em weng kukuyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Keko beli, ketket teben kel kunum mak i yan yout nam kunum mak debele talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Teleko, “Yesus em mit mewso debele unuma o!”, angsiliw kate, “Am be gekbiliw!”, angomi, i yout kunum beelo am gong elo debele uneko, Yesus em mobe dim em mewso dim kel am kon fat kelewsomi, yout nam kunum so, akalem akalkemin dim beso, alik alik be ma kuw sok giko, malak da kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kolewiwi, Yesus e ikalem fein ibolow be ateyemeko, yout kunum beelo bokolewomele: “Aul kutaka! Kom ibolow sili sili nam akal ne kuluko, kokemika!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dangei, ka biliw Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum i Yesus em dangse weng be kiliko, yol angeko, ikalem ibolow tem kel bokolew bokolew kelomeliw: ");
INSERT INTO bhl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Yakai! Nimtew angom ete kunum be weng be bokolewbe ye? E Sunbin-Got em abin kuluko, em wiin dawkatikabe te! Fein! Sunbin-Got ete kuw ki keko, mak kunum mak em ibolow sili sili nam kulu koloke te.”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Angiwi, angbiliw beem ding dim bakate, Yesus e akalem ibolow tem kel biim ibolow tem bokolew bokolew keliw weng be kal keko, ilo yan weng mak bokoyemomele: “Yu nimtew angom ete weng banso banso kebomi, ibolow tem tem kebiliw a? ");
INSERT INTO bhl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ne yout nam kunum beelo bokolewomeli: ‘Kom ibolow sili nam be kulu kokemika!’, angi tewe, weng be fian weng kele sako? Angeko, elo bokolewomeli: ‘Ku teineko, kukalem akalkemin dim be kingtiko, kakama!’, angi tewe, dangoki weng be fong gel weng kele sako? Babo! ");
INSERT INTO bhl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kate, yom kilele kal keko, ‘Sunbin-Got e Kawtiw Aul nem dim elo kitil auk so be dunembe kasike, ne ki keko, kawin dim kaleem kunum waneng im ibolow sili sili nam sak misim kuw kulu koyemkabi te.’, nangbiliw beem mongom ete yu kame kilele kiliko, atemina!”, yangse kale. Yangeko, kunum yout nam kunum beelo bokolewomele: ");
INSERT INTO bhl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kame kutaka! Ku teineko, kukalem abin kon be kulu auleko, kukalem am elo una!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dangei, yout nam kunum be fongate akate baba teineko, akalem akalkemin abin kon be kulu auleko, kut unei, i atemsiliw kale. Keko beli, ka biliw kawtiw i kanele eisneng be atemeko, yol angeko, Sunbin-Got em wiin fian daoleweko, bokolomeliw: “Feinka! Sua e, kalakaneko eisneng mak nu ateminba kekabuluw te!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Beli, Yesus e iti am be koleweko, Galili okmun benggew kalo unomin kese kale. Kelei, kunum waneng alik alik bi eso makuw bonggusomeliwi, e ilo kukuyemkem diliko, unse kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Unbe ding dim be, e mak kunum mak atemse kale. Kunum be Alfius em min Elibai ete kale. Kunum be akalem kawtiw ilo maka keyemkabe Ulom abiw mutuk fian beem aluwkabe kunum kese kale. Kesomi, akalem tum win kulamin am tem teinse ding dim bakate, Yesus e elo atemeko, elo gaalewomele: “Ku nelo nenggelew tala o!”, dangse kale. Dangei, e em gaalewe weng be kiliko, moko, Yesus elo fein gelew unse kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Gelew unesomelei, Yesus e Elibai beem am kel wanin wanomin unse kale. Unse kate, on kisol fokoliwi, deimaliw kawtiw banban so, mali kawtiw Suda kawtiw im sawa weng afak keko, binba sakok kebiliw kawtiw iso, kawtiw banban bi Yesus elo gelewkakabiliw kasike, alik alik kawtiw bikati Elibai beem am kuw bonggusomi, wensan teineko, Yesus eso em gelewkabiliw kunum iso, wanin fian mak wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wanbomeliwi, mali Falisi kunum im Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum i Yesus em kanebe be atemeko, “Ebe! On kisol fokoliwi, deimaliw kawtiw so, sawa weng afak keko, binba sakok kebiliw kawtiw iso wanin wanbe kae!”, angomi, atemeko, weng nutnut weng bokolew bokolew kesomi, Yesus em gelewkabiliw kunum biilo dakalalomeliw: “Nimtew angom ete kunum be kunum waneng sili sili nam so, kisol fokoliwi, deimeliw kunum kukuw wa kekabiliw kunum iso, bongguko, ok wane, wanin wane wanakabe a?”, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yangeko, dakalakamiwi, Yesus e im weng bakabiliw weng be kiliko, ilo yan weng mak bokoyemomele: “Abung geyembin kunum e wakamin banim kawtiw ilo dokoyeminbakabe kate, wakamin so kebiliw kawtiw ilo kuw dokoyemkabe te. Feinka! Ne kiol kunum waneng kawtiw im dulum telinba te. Sili sili kunum waneng ilo gaayemomin beem mongom ete talsi te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Beli, kawtiw ok da koyemin kunum Sion em gelewkabiliw kunum so, Falisi kunum im gelewkabiliw kunum iso, alik alik bi wanin tokomin kukuw gelewkabiliw kasike, mali kawtiw mak teleko, Yesus elo dakalalomeliw: “Sion so, Falisi kunum so biim gelewkabiliw kunum i deiw mak deiw mak ding e wanin tokokabiliw kate, nimtew angom ete kom gelewkabiliw kunum i wanin wanenkakabiliw a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Dangiwi, Yesus e ilo kal kikis kemin dawol em fakam weng mak bokoyemomele: “Kunum mak em waneng kulei, kikis yemkal biim wanin wanbomi, wensanbiliw kawtiw iso biliw ding dim bakate, mali yu ki keko, bokoyemomeliw: ‘Kame yu wanin wanomin be tokolina!’, angokoliw sako? Babo! Waneng kuluse kunum beem yuso be ding dim e, yu kanelom wanin tokolokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kate deiw mak ding mak em keloke ding dim kabalak e, waneng kuluse kunum be iso binba keloke kasike, i elo nam atemiw te. Beem ding dim kabalak be, akalem akunum kusel ikati fein wanin tokolokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yangesomi, iti fakam weng mak bokoyemomele: “Mali kawtiw mak i ilim anung kikis mak kuluko, ming em dim elo nam beneliw te. Nimtew angom? Kaneliw tewe, ilim beem gingiw ding dim e, ilim kikis be fong betel kebomi, kilelsiliw ilim be fufuw keko, iti atin kuw wa wa kelewoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yu kililina! Nem weng kikis e wain ok kikis em kiskiw atew te. Mali kawtiw mak i wain ok kikis be wain ok sen ming tem elo nam daliw te. Daliw tewe, wain ok kikis be wain ok sen ming tem daliw be dakaleko, wain ok beem kitil e ok sen be bikineko, kawtoloke te. Kawtolei, wain ok akal, ok sen akal atin kuw wa keloke kasike. Feinka! Wain ok kikis be wain ok sen kikis tem elo akalem tem dakamoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Beli, deiw mak ding mak, iti finengdakamin ding Sabat kele ding dim e, Yesus so, akalem gelewkabiliw kunum iso, i wit wanin bilal musun mak em mutuk fok unsiliw kale. Unbomeliwi, akalem gelewkabiliw kunum bi wit sen falit de mayak dako, dakaluko, wanen diliko, yak yak unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kem diliko, unbiliwi, mali Falisi kunum mak im kanesiliw be yetemeko, Yesus elo bokolewomeliw: “Wee kutaka! Nimtew angom ete kunum bi finengdakamin ding Sabat kaleem kukuw gelewinba kesomi, sak sakok kuw gelewkabiliw a?”, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yangiwi, Yesus e ilo yan weng mak bokoyemomele: “Yu kililina! Yu sua kel emisik kamok fian ke alenale Debit em kanese sang mak teing bokoko, ateminba kebiliw sako? Deiw mak ding mak, em emisik kamok fian kelinba kese ding kabalak e, eso akalem awkunum kusel iso, i wanin sukum kesomi, yemen tew teinsiliw kasike, ");
INSERT INTO bhl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","i Sunbin-Got em yol am kawtem unsiliw kale. Beem ding dim bakate, Abiatal e kunum ayem sel kebise kale. Kebomelei, Debit e am yol beem dukusiliw belet wanin ayem be kuluko, waneko, akalem iso biliw kunum bikati yemense kale. Kate, Sunbin-Got em belet wanin ayem be Sunbin-Got em am yol em kunum ayem kunum bikalem kuw wanakabiliw wanin kate kale.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yangeko, iti weng makso ilo bokoyemomele: “Yu kilele ibolow fukunina! Sunbin-Got e finengdakamin ding Sabat dukuko, kawtiw biim dulum keyemale kale. Feinka! E kawtiw dukuko, finengdakamin ding Sabat beem dulum kelinba kese te. ");
INSERT INTO bhl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kate yu kililina! Nakalem ete Kawtiw Aul keko, Kamok Fian kebi kasike, ne finengdakamin ding Sabat beem sawa kale bakilewkabika.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yangsomi, Suda kawtiw im wensankabiliw am kawtem unse kale. Beem ding dim bakate, teing kuan fom yout kese kunum mak belei, e atemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Keko beli, mali ka biliw kunum mak Yesus elo kiin kiin kelewko, “Finengdakamin ding Sabat kabalak be, teing kuan fom yout ke alakabe kunum beelo okmino kolewei, ken keloke yake?”, ange ange keko, atemsiliw kale. Nimtew angom? I elo geelewomin em mongom deiw fenbomi, atemsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Atemiwi, e teing wa so kunum beelo bokolewomele: “Kutaka! Kawtiw biim kiin dim kaleelo tala!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dangeko, kawtiw ka biliw kawtiw biilo bokoyemomele: “Kame ne yulo dakalakamin mak dakalalo yo! Yu kililina! Mali kawtiw mak mali ilo ken kukuw so, im finik so dokoyemkemin kukuw so, keyemiw tewe, kanekabiliw be finengdakamin ding Sabat beem sawa ki keko, Sunbin-Got em kiin dim e kiol kuw keloke sako? Beni, mali kawtiw mak mali isik wa kukuw so, yenomin kukuw so, keyemiw tewe, be Sabat beem sawa ki keko, Sunbin-Got em kiin dim e kiol kuw keloke sako?”, yangeko, dakalase kale. Dakalalei, i kimi tete angeko, yan weng mak banim kelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kebomeliwi, Yesus e kunum waneng ka biliw kawtiw biilo ibolow kaisuw so kale yetem kale yetem kebomi, im ibolow kau angebiliw beem mongom ete ibolow sakik fian kuluko, kunum teing wa so kunum beelo bokolewomele: “Kom teing e kileleko, dila!”, dangse kale. Dangei, fein, kunum beem teing e ken ati kese kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kelei, Falisi kunum bi em kanele be atemeko, fongate akate am be koleweko, emisik kamok fian Antibas Kelot em mali kunum mak iso weng bokolew bokolew kesomeliwi, bokoyemomeliw: “Nu nono deiw ete Yesus kalete aluwi, e kuanoke ya?”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Beli, Yesus so akalem gelewkabiliw kunum iso, i Kabelneam abiw mutuk fian be iti koleweko, Galili okmun benggew kalo unsiliw kale. Beem ding dim bakate, Galili aneng fian kasel o, Sudia aneng fian kasel o, Selusalem abiw mutuk fian kasel o, Idumia aneng kasel o, Yoldan bang em mali aneng biliw kasel o, Tail so Saidon abiw mutuk fian alew biim kasel o, kawtiw banban bi elo gelew talsiliw kale. Nimtew angom? I Yesus em auk so kitil so eisneng kelewse em sang kiliko, em fukun talsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Talsiliw ding dim bakate, Yesus e wakamin kawtiw banban kilelyemse kate, wakamin kawtiw banso banso em mit mewso teleko, “Elo melelew unuw kano, ken keluma o!”, ange ange kesomi, aneng be gek gek kesiliw kale. Gek kesiliw kasike, e akalem gelewkabiliw kunum biilo bokoyemomele: “Kunuw mak de teleko, num unomin deiw memen kelina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kanebe ding bakate, aneng matil im dim biliw kawtiw mali mak i Yesus elo atemeko, em mit mewso kel katin bukbuk angeko, gaaneko, bokolomeliw: “Ku Sunbin-Got em Min kute te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Dangiwi, e kitil nam weng mak bokoyemomele: “Yu kanelom mali kawtiw mak ilo weng kale kaim dim dakamokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Beli, Yesus e amgu tikin dim mak uneko, akalem ibolow fukunin kuw geleweko, kalun kel kunum mak gaayemei, i fein em mit mewso tasliliw kale. Teliwi, e ilo akalem wiin so amkoko, akalem so bomi, kakabiliw kunum koyemeko, “Nem kalan kunum yute te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yangeko, auk so kitil so mak duyemse kasike, i ki keko, aneng matil ilo takala koyemiwi, i biim yangsiliw weng be kiliko, fein gelewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kalun kel kunum biim wiin e kanekote: Saimon e — Saimon em wiin mak e Fita kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sekow so Sion so — Aso i Sebedi em muluwel alew ite te. I ibolow sakalala kunum kesiliw kasike, Yesus e aso ilo wiin makso duyemeko, “Boanelges”, yangse kale. Wiin beem mongom ete “Ibolow Kiman Kunum” te. ");
INSERT INTO bhl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andulu e, Filiw e, Batolomyu e, Matyu e, Tomas e, Sekow e — Alefius em min kale. Tadius e, Saimon e — E Ulom abiw mutuk fian em wonuk so kunum iso maka keyemale kunum kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Sudas e — E Iskaliot abiw kunum kesomi, Yesus elo maka kawtiw im teing dim dase kunum ete kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Beli, Yesus e iti akalem am unse kale. Unei, kunum waneng banban mak talsiliw kasike, Yesus so akalem angin iso im wanin wanomin ding banim kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Beem ding dim bakate, akalem kaim atuk i em kanelewse sang be kiliko, teleko, beem dulum bokolomeliw: “Yakai! Kunum kale ibolow teifulubin kunum kebe te!”, angeko, elo aluwomin unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Unsiliw kate, mali Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum i Selusalem abiw mutuk fian kolew teleko, bokolomeliw: “Babo! Belsebul e akalem dim be kae! Kunum be aneng matil im kak yetebe finik beem kitil ete kuw aneng matil takala koyem kebe te!”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Angiwi, Yesus e kawtiw ka biliw biilo gaayemei, i fein em mit mewso teliwi, e weng mak bokoyemomele: “Yu nimtew ibolow fukunbiliw a? Seten-Ataanim e ki keko, akalem ete takala kolewoke sako? A babo! Yu fakam weng kale kilele kililina! ");
INSERT INTO bhl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kunum mongom mak i amen kuw amen kuw kesomi, gaanbiw tewe, fein, kunum mongom beem kitil e banimsomi, kuminoke te. ");
INSERT INTO bhl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Auk diw alew diw yangdel ikalem akate amen kuw amen kuw kesomi, ganbiw tewe, fein, ikalem bonggu beliw wiin be banimsomi, kuminoke te. ");
INSERT INTO bhl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Beemdiw, Seten-Ataanim em angin i amen kuw amen kuw kesomi, ganbiw tewe, em kitil e banimsomi, kuminei, e atin kuw sakoke te. ");
INSERT INTO bhl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yu kame kilele kililina! Seten-Ataanim e mak kunum mak on balam so kunum mak atew kebe te. Kate nakalem ete, nanew kunum atul nam kunum mak emdiw kesomi, teleko, on balam so kunum beelo dawkatikoko, sok so net kelewsomi, em on kisol eisneng be, alik alik kulu dakiloki kunum nete te. ");
INSERT INTO bhl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Yu kilelbi boliwka! Yu nem kanekabi be atemeko, nelo bokonemomeliw: ‘Aneng matil mak em dim be kai!’, nangbiliw kate, yu nem weng kale kame kilele kililina! Nimin kawtiw ite mak sili sili kukuw keko, bomi, mali biliw im wiin dawkatiko, wa keliw tewe, Sunbin-Got e biim kanebiliw kukuw wa be sak misim kulu koyemoke te. Kate, nimin kawtiw ite mak Sunbin-Finik elo weng milewiw tewe, Sunbin-Got e biim milewbiliw weng be, itel nam kulu koyeme te. Kanebiliw kawtiw biim dulum elote sili sili nam beem sen e diwkuw diwkuw boke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Beli, Yesus em auk so, akalem awkunum kumel so alik alik bi em fukun teleko, akalem be am be kut kawtem kel moko, bomi, weng mak dabalalomeliw: “Ku num fukun tala o!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dangbiliw ding dim bakate, kawtiw banban mak Yesus elo falal koleweko, ka teinsiliw kale. Keko beli, i elo bokolewomeliw: “Kauk o, kom kawkunum kumel o, ikati kulo fenem teleko, kut tem ka kel kom ding feneko, biliw kae.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Dangiwi, e bokoyemeko, dakalalomele: “Nem yem o, nawkunum kumel o i kanete a?”, yangeko, ");
INSERT INTO bhl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","kawtiw ka teinbiliw kawtiw im dulum elote kiinguen fubelet mali fen mali fen kesomi, bokoyemomele: “Kawtiw kali kuw yu nem yem o nawkunum kumel o yute te. ");
INSERT INTO bhl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nimtew angom? Sunbin-Got em ibolow fukunin elo gelewbiliw kawtiw bite kuw, nawkunum kumel o, waneng aul kumel o, yem o, keko, biliw bakate.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Beli, deiw mak ding mak e, Yesus e iti am be koleweko, Galili okmun benggew dim ka kel kalo teliw kunum waneng ilo kukuyemse kale. Kukuyemei, kunum waneng banban mak Yesus em fukun talsiliw kasike, e kawtiw bi benggew dim ka kel koyemeko, kunuw dim kawtem teineko, ilo weng bokoyemsomi, ");
INSERT INTO bhl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","kukuyemin banso mak fakam weng dim elote keko, ilo bokoyemse kale. E bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","4","“Yu nem weng kale kilele kililina! Mak kunum mak wit dem kuluko, akalem musun fukalale tewe, mali dem mak deiwkim dim kuminei, fongate akate awon i teleko, wanekabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wit dem mali mak kawin fong gel tum dim kuminko, fongate akate diwing keloke kate, ");
INSERT INTO bhl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kimkim dabala tum dim kelei, ataan kitil nam tele ding dim bakate, ais meneng kale fongate akate geetkabe te. ");
INSERT INTO bhl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wit dem mali mak wolu dim kuminei, itel ningning so kasi kolewei, kot nam keko, tebelinba kekabe kasike, dem mak gilalinba kekabe te. ");
INSERT INTO bhl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kate, wit dem mali mak kawin ken deeng dim mitomelei, tebeleko, fian keko, bamki so kesomi, dem fufu mak e 100 kelei, mak e 60 kel kelei, mak e 30 kel kelei, dem gilakabe te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yangesomi, weng makso bokoyemomele: “Ibolow tem fukalel biliw kawtiw yutaka! Yu weng kale kilele kililoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yangei, kawtiw banban biim Yesus iti kolewsiliw ding bakate, Yesus em kalun kel kalan kunum iso, mali eso kakabiliw kunum waneng iso, i bongguko, dakalalomeliw: “Fakam weng beem mongom e nimtew a?”, dangeko, elo dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dakalaliwi, e yan weng bokoyemomele: “Sunbin-Got esik yulo akalem gawman ding dim em ibolow win sang kale kaleyemkabe te. Kate, mali kawtiw nem angin keko, binba kebiliw kawtiw i sak nem fakam weng alik bete kuw kilikabiliw kasike, ");
INSERT INTO bhl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘i weng be fein atemeko, kal kelewinba kekabiliw te. I kilikabiliw kate, weng beem mongom e i kilele dolon kuw kelewinba keko, akokow kekabiliw te. Mesik esik i ikalem sili sili nam ibiku kolewko, ibolow famdeko, Sunbin-Got em ibolow gelewokoliw kasike!’”, angeko, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yangeko, e ilo dakalalomele: “Fakam weng beem mongom e yu akokow kebiliw sako? Akokow kebiliw tewe, yu nono keko, mali fakam weng kiliko, dolon kelokoliw a? Kate yu beem mongom kame kililina! ");
INSERT INTO bhl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kunum wit ais dem fukulakabe kunum be Sunbin-Got em weng bete fukulakabe te. ");
INSERT INTO bhl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mali deiwkim dim kumin mitkabe wit ais dem beem mongom e kanekote: Sunbin-Got em weng be kilibomi, elo “Fein!”, dangbiliw kate, Seten-Ataanim e fongate akate teleko, im ibolow tem beem kulubiliw weng be iti kulu koyemkabe kawtiw biim kiskiw ite te. ");
INSERT INTO bhl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tum dim mitkabe mali ais dem beem mongom e kanekote: Sunbin-Got em weng kiliko, fongate akate kalfong fian kelewbiliw kate, ");
INSERT INTO bhl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","i weng be im ibolow mutuk tem kel kilele men diw kel dukulinba kekabiliw kawtiw im kiskiw ite te. Deiw mak ding mak weng beem dulum elote sakik ilum mak kawtiw biim dim telei, mali kawtiw mak i ilo weng beem dulum elote yenomin ibolow keyemiw tewe, kawtiw bi fongate akate weng be iti kolewkabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wolu dim aim tem kuminkabe ais dem beem mongom e kanekote: Sunbin-Got em weng fongate kuw kiliko, unekabiliw kate, ");
INSERT INTO bhl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","i on kisol so, kawin dim em eisneng so, beem ibolow kuw kelewkabiliw kawtiw im kiskiw ite te. I on kisol beem ibolow kuw tiaktiak kelewkabiliw kasike, i Sunbin-Got em weng elo dawkatiko, kelewbomeliwi, em weng be im dim kel dem gilalinba kekabe baka te. ");
INSERT INTO bhl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kate, kawin ken deeng dim kumineko, dem ken gilakabe ais dem beem mongom e kanekote: Sunbin-Got em weng kiliko, ken dolon ibolow aluwbiliw kunum waneng im kiskiw ite te. Kunum waneng bi ais dem emdiw banban gilalokoliw te. Mali im dem e fufu 100 kel kelei, mali im dem e 60 kel kelei, iti mali im dem e 30 kel keloke te.”, yangeko, akalem gelewkabiliw kunum biilo fakam weng beem mongom e kaim dolon dim kuw dase kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Beli, e ka biliw kwatiw ilo iti weng mak bokoyemomele: “Yu yongom dong mak aileko, mesesem eisneng so kasi kolewbiliw sako? Bayo! Abisom dim kel ail kolewbeliw kano, mali kawtiw i yongom dong atemomi, fein am matem telemoliwka! ");
INSERT INTO bhl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yu kililina! Bi e, mesesem eisneng mak kame okmobe be, fein fitewoke te. Beemdiw, yawal kebe eisneng mak be, bi e, fein kaimei, kawtiw kal kelewokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yangesomi, weng makso bokoyemomele: “Ibolow tem fukalel biliw kawtiw yutaka! Yu weng kale kilele kililoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yangeko, iti bokoyemomele: “Yukal nem kukuyemin weng kale kilele kiliko, aluwboliwka! Yu kun kuluko, nem kukuyemin weng kale kilele kiliko, kuliw tewe, Sunbin-Got e yom ibolow be dolon kuw keyemeko, iti kal fian makso makso dukayemboke te. ");
INSERT INTO bhl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Feinka! Mali kawtiw mak i weng kale kilele kiliko, gelewemiw tewe, Sunbin-Got e im fukunin ken ati be makso bamki keyemboke te. Kate mali kawtiw mak i weng kale kilele gelewinba keliw tewe, Sunbin-Got e im atuk fong gel kulusiliw atuk bakati fein kulu koyem keemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yangeko, iti fakam weng mak bokoyemomele: “Sunbin-Got em gawman ding dim e ais dem kailei, emikel kuw dem gilakabe ais dem emdiw te. Kunum mak uneko, akalem deeng dim ais dem mak fukulale tewe, ");
INSERT INTO bhl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","taw banim mililiw banim e, e sak ding fenbomelei, ais dem be emikel kuw tebeko, fian keloke kate, kunum be beem tebekemin em mongom e akokow so keloke te. ");
INSERT INTO bhl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Feinka! Kawin akalem ete ais dem beelo kitil dulewei, e emikel kuw dem gilaloke te. Emisik e sen tebei, emteben e bokbok kesomelei, fe e, fein dem gilalaloke te. ");
INSERT INTO bhl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dem gilako, yom keloke ding dim kabalak e, musun kayak be sakam dang atul nam mak kuluko, uneko, giti goto giti goto keleweko, wanin dem be kuluko, am de unoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Beli, Yesus e iti weng mak bokoyemomele: “Sunbin-Got em gawman ding dim em sang e nono eisneng atew a? E nomin fakam weng atew a? ");
INSERT INTO bhl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Em gawman ding dim e ais dem fong gel atew te. Mak kunum mak ais dem atin kuw fong gel mak be kuluko, ");
INSERT INTO bhl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","akalem musun dim kailoke te. Kailei, ais dem be tebeko, fian keloke ding dim bakate, e sen fian kuw kesomi, nanew musun ais bakilewei, ais teing tiaktiak kelei, awon i em teing takam dim kel teineko, ais beem takak dim be ikalem aim gelokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yangse ding dim bakate, Yesus e kawtiw ka biliw kawtiw biilo diwkuw diwkuw fakam weng kuw bakayemkamale kale. E weng ati so kuw bokoyemkabe kasike, em weng kilibisiliw kawtiw bi em yangse weng beelo gal kelinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Fein. E kawtiw alik alik biilo fakam weng kuw bakayemamele kate, fakam weng beem mongom ete e ibik ete akalem gelewkabiliw kunum waneng ite kuw kilele kaim dim dase kasike, i fakam weng be kiliko, kilele mongom so kal kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Beem ding dim em ataan tem unomin kis kele ding bakate, Yesus e akalem gelewkabiliw kunum biilo bokoyemomele: “Okmun mali elo unuma!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yangei, i em yangse weng be kiliko, ka biliw kawtiw banban biilo koyemeko, ikati em teinbe kunuw dim kawtem unesomeliwi, eso iso makuw okmun mali elo unsiliw kale. Unsiliw ding dim kabalak e, mali kunuw makso mak iso unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Im unbiliw ding dim bakate, suuk inim inkal so mak teleko, ok fok fok matem alelem teleko, kunuw dim unbiliw dim matem talse kasike, kunuw be wenomin kis kese kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kanese ding dim bakate, Yesus e kunuw beem ful dim ka kel e kak kemin dim kak dukuko, akal kimi angse kale. Angei, akalem gelewkabiliw kunum i em mit mewso teleko, dawkalfoleko, gaanin fian mak bokolewomeliw: “Num kukuyemin kunum kutaka! Ok tom yenei, nu makuw kuanokoluw kate, ku nukalem tokso kebelew yako?”, dangeko, olsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Olemiwi, e baba teineko, inim fian so okmun so biilo kitil weng mak gaaneko, bokoyemomele: “Kimi o! Gato angina o!”, yangei, fein, inim be sin tew kame tew kanebe be gato gato angeko, daking malmal banim kese kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kelei, e akalem gelewkabiliw kunum biilo dakalalomele: “Yutaka! Nimtew angom ete yu finganbiliw a? Kate yom fein ibolow gel e kame akal banim sako?”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yangei, i finganin fian mak keko, ikalem dakale dakale kelomeliw: “Yakai! Kalakanebe kunum kale nomin kunum kate? Suuk inim so, okmun so, beem weng kitil weng kiliko, fein gelewbiliw kasike!”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Angiwi, i okmun be kunuw so fokoko, Gelasa kawtiw im aneng dulum elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Uneko, im mayak teliw ding dim bakate, fongate akate aneng matil em dim teinbe kunum mak ka em fomkamin dim koleweko, yako teleko, Yesus em mit mewso talse kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kunum be fomkamin dim ka kel akal tem akal tem kemale kunum ete kale. Kebelei, kawtiw i sok so, ain sok so, kuluko, “Nit net sok be so ge kolewuma!”, angbisiliw kate, i ki keko, elo sok so ge kolewinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nimtew angom? Aneng matil bi diwkuw kunum beem kitil ete ankiw dalewiwi, e kawtiw alik ilo kuiaw keyemse kasike. Im mel ete kuw e kawtiw im sok kitil nam so nit net sok ge koliw sok be giti goto ke kolew ke kolew kemale kasike, i em dim mewso dalinba kesomi, elo tong milinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kesomeliwi, kunum be taw banim kutiliw banim diwkuw diwkuw fomkamin dim so, muk tikin kel so, moko, bomelei, gaaneko, tum kuluko, akalem kal feiwko, okilew kemale kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Keko beli, kunum be Yesus elo singam kel talbelei, atemomi, em mit mewso yako teleko, katin bukbuk angeko, gatak wakas keleweko, em wiin daolewse kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Daolewsomelei, Yesus e aneng matil beelo kitil weng mak bokolewomele: “Kunum be takala kolew una o!”, dangse kasike, aneng matil be gaanin fian mak keko, bokolewomele: “Yesus, ku Sunbin-Got abiil tikin kayak em min kutaka! Ku nelo nono kenemomin talbelew a? Ku kanelom kal betbet wa dunemokolew te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dangei, Yesus e elo dakalalomele: “Kom wiin e nimtew a?”, dangei, e yan weng bokolewomele: “Nesik kutew ol tem atew te. Kusik nelo bokonemomin kis e. Wonuk so kunum banso banso imdiw buluw kasike!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dangei, kunum be aneng matil biim bontem dim bokoko, Yesus elo kitil weng mak bokolewomele: “Ku kanelom aneng matil biilo ‘Yu takala kolewko, aneng fian kale kolina!’, yangokolew te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Em dangse ding dim bakate, aneng ka kel kaing yamgel mak dok dim kel bisiliw kasike, ");
INSERT INTO bhl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","aneng matil bi Yesus elo dakalalomeliw: “Ku ki keko, nulo kaing kulin mutuk tem elo yemdala o!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dangiwi, e bokoyemomele: “No, kanelina!”, yangse kale. Yangei, i kiliko, fein, kunum be koleweko, fonsangineko, kaing tausen alew (2'000) im kulin tem elo ba unsiliw kale. Uniwi, kaing banban bi gulili yako uneko, fes mak dakalu mit mit uneko, okmun tem okmun tem keko, ok kunil yak yak keko, kuansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kuaniwi, kaing biim yetebiliw kawtiw i fon uneko, abiw mutuk abiw mutuk elo weng de unsiliw kale. De uniwi, abiw kasel i kanele eisneng be atebam teleko, ");
INSERT INTO bhl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesus em mit mewso teleko, atemiwete: Aneng matil banban em dim takala kolewsiliw kunum be kame ilim so minggiko, kilele ibolow ken keko, teinbelei, i atemsiliw kale. Atemsomeliwi, kawtiw bi finganin fian mak fingansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Beli, kanele eisneng be atemiw kawtiw i mali kawtiw ilo aneng matil kunum beelo takala kolewsiliw em sang so, kaing dim im kanele em sang so, kilele bokoyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bokoyemiwi, i Yesus elo kitil weng mak bokolewomeliw: “Num aneng kale koleweko, nanew dim aneng elo unolewka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dangiwi, fein e, Yesus so akalem gelewkabiliw kunum iso, i kunuw dim uneko, iti unsiliw kale. Im unomin memen kesiliw ding bakate, kilelewse kunum be Yesus elo deitse kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kate Yesus e elo iti dabalako, bokolewomele: “Babo! Kukalem am dim uneko, Kamok Fian em kulo kinkin kekemeko, dokokemse em sang ken be abiw mutuk kasel ilo bakayem yak bakayem yak unolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dangei, kunum be em dangse weng be fein kiliko, em kanelewse sang fian be Dekabolis aneng fian beem biliw kunum waneng alik alik ilo bakayem yak bakayem yak unse kale. Keko beli, kunum waneng alik alik i em yangse sang be kiliko, yol angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus so, akalem gelewkabiliw kunum iso, im iti kunuw dim teinsomi, okmun be digeko, mali elo teleko, ka em benggew dim kel mosiliw ding dim bakate, kawtiw banban mak em mit mewso teleko, wensansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Keko beli, mak kunum mak em wiin e Yailus alenale kale. Kunum be Suda im wensan kekabiliw am em atebin kak kunum ke alenale kale. Keko beli, e Yesus em mit mewso teleko, gatak wakas katin bukbuk angeko, ");
INSERT INTO bhl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kitil kuw gaanomele: “Kutaka! Nem mun gel kame kuw kuanomin kis kebu te. Kasike kame, ku teleko, kom teing e um dim dukulew kano, u iti ken kesomi, kanelom kuanomu yo!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dangei, aso i fein makuw unsiliw kale. Beem ding dim bakate, kawtiw banban kouw kuw keko, ilo yenggelew talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yenggelew talbomeliwi, mak waneng mak talsu kale. Kalun kel itol ding dim kabalak e, diwkuw diwkuw abiw ilum e gato anginba waneng mak alenalu kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","U mali abung geeyemin kunum banban ilo bokoyemomelu: “Yu nelo kilelnemina o!”, yangomi, abung gemin kunum biilo weyemeko, ukalem on kisol alik alik be sak tutumelu kale. Nimtew angom? Um wakamin e ken kelinba kese kate, atin kuw ilum fian kese kasike. ");
INSERT INTO bhl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kame, waneng bu Yesus em auk so kitil so kaneyembe sang kilisu kasike, u Yesus em ibiku unbe dim mewso mewso gelew gelew teleko, em ilim minggiko, em unbe dim teing meleleweko, unsu kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nimtew angom? U ukalem kuw bokolomelu: “Ne Yesus em ilim dim kel teing melelewi tewe, ne fein kenoki kai!”, angsu kasike. ");
INSERT INTO bhl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Angeko, melelewsomelui, fongate akate um abiw ilum wakamin be wokminomei, u fein ken kesu kale. Keko, u kilele kal kelute: “Nem anggil so takak folot kele kai!”, angsu kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Angei, fongate akate Yesus e “Yakai! Nem kitil anung mak kanelo kilelomin koneme ye?”, angeko, ibolow tem kel angesomelei, kawtiw dem dem biliw biim mutuk kel famdes angeko, bokoyemomele: “Kante nem ilim be teing meleneme a?”, yangeko, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dakalalei, akalem gelewkabiliw kunum i elo yan weng bokolewomeliw: “Ae! Kunum waneng banban kom mit falal kekemeko, kouw kuw kekemsomi, dukakan so kebiliw kasike, nimtew angom ete ku bokolomelew: ‘Kante meleneme?”, angbelew a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Dangsiliw kate, e kiinguen fubelet mali fen mali fen kese kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kelei, waneng bu kal kelute: “Nem abiw ilum be goto goto kele kai!”, angesomelui, inkal kal kuluko, walwal kuw kilikili keko, Yesus em mit mewso katin bukbuk angeko, gatak wakas angeko, elo ukalem kanelu sang alik alik be fein kilele bokolewsu kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bokolewui, e bokoumomele: “Aul kutaka! Kom fein ibolow kenemew bete kulo dokokeme kasike kame, ku ibolow menew ati so keko, una! Kom abiw ilum wakamin be atin kuw goto ange kasike!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ulo wangse ding dim bakate, iti mali kunum mak teleko, Suda kawtiw im wensan kekabiliw am em atebe kak kunum beem mit mewso teleko, bokolewomeliw: “Kom mun bu atin kuw kuan kembu kasike, ku kanelom kukuyemin kunum beelo ilum makso dulewokolew te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dangsiliw kate, Yesus e im dangsiliw weng be wosulinba tew keko, kak kunum beelo bokolewomele: “Ku kanelom ilum sakik keko, finganemokolew te! Kate, nelo ‘Fein!’, nangolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Dangeko, ka biliw kawtiw banban biilo “Ayem o! Yu nuso makuw nam teliw te!”, yangesomi, eso, Fita so, Sekow so, Sekow em awkunum Sion so, alemsal kunum biso, ite kuw ");
INSERT INTO bhl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","kak kunum beem am kalo unsiliw kale. Kalo uneko, ka kel mali fom am bomi, amemin fian mak kebiliw kawtiw demdem mak yetemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yetemeko, am kawtem unesomeliwi, e kawtiw ka biliw biilo bokoyemomele: “Nimtew angom ete yu sakik fian kuluko, amebiliw a? Aul kalusik kuaninba kale eli! Akalbu kasike!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yangei, i elo weng milewsomi, abeng ati gilewsiliw kate, e ilo kut da koyemsomi, aul buum auk so alew so biso, eso unsiliw alemsal kunum biso, alik bite kuw yemde unesomelei, i aul buum akalkabu am dim kawtem elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Uniwi, Yesus e waneng aul buum teing gololo wouleko, bokoumomele: “Talita kum!”, wangse kale. (Weng beem mongom e kanekote: Waneng aul gel kutaka! Ku baba teineko, mola!) ");
INSERT INTO bhl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aul buum itol e kalun kel itol kesu kale. Keko beli, fongate akate aul gel bu baba teineko, mosomi, umikel kuw ka kel uneko, anung anung kesu kale. Kelui, kunum waneng ka biliw kawtiw bi yol fian fian mak angeko, “Yakai!”, angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Angiwi, Yesus e kitil weng mak bokoyemomele: “Yu kanelom mali kawtiw mak ilo um kanesu sang kale bokoyem tem bokoyem tem de unokoliw te!”, yangse kale. Yangeko, “Aul buulo wanin mak duumina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Beli, Yesus e aneng be iti koleweko, eso, akalem gelewkabiliw kunum iso, alik alik bi makuw akalem am dim elo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Uniwi, finengdakamin ding Sabat kele ding bakate, e memen keko, Suda kawtiw im wensankabiliw am dim kel kunum waneng ilo kukuyemse kale. Kukuyemei, kawtiw banban beem kukuyemin weng be kiliko, yol fian mak angeko, bokolew bokolew kelomeliw: “Nalete kunum kale akalem kukuyembe weng kale kulabe ye? Kunum kaleem kal e nal kel nono kulabe ye? Kante kitil fian be dulewbelei, e ki keko, auk so kitil aluwbamin fian be aluwbabe ya? ");
INSERT INTO bhl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Feinka! E am gemin kunum kelei, beem auk u Malia ute te. Em nenggelel im wiin e Sekow o, Yosetos o, Saimon o, Suda o, ite kuw te. Akalem waneng aul min i kale kel nuso biliw kale eli!”, ange ange kesiliw kale. Keko beli, i desi weng keleweko, em kukuyemin kilele wosulinba kesomi, im elo “Fein!”, dangbin ibolow be net angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Angei, Yesus e bokoyemomele: “Feinka! Aneng aneng angom kawtiw i Sunbin-Got em bontem dim bakamin kunum mak em wiin daolewkabiliw kate, akalem awkunum kusel o, akalem am dim kasel o, ite elo ‘Fein o!’, danginba kekabiliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yangesomi, ka kel e, e ki keko, auk so kitil so eisneng banso mak kelinba kese kate, e mali wakabiliw kawtiw angin fong gel mak im dim e teing dukuyemeko, ilo okmino koyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Koyemsomi, ikalem fein danginba ibolow beem dulum elote “Ibo! Net fian keliw kai!”, angeko, yol fian keyemse kale. Keko beli, e Nasalet abiw mutuk fian beem abiw mak abiw mak falal falal uneko, kawtiw ka kel biliw kawtiw alik ilo kukuyem kem unse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Beli, Yesus e akalem kalun kel gelewkabiliw kunum biilo gaayemei, i akalem mit teliwi, e ilo wiin fian mak duyemei, “Yu aneng matil im kitil e mit da keyemoliwka!” yangeko, amen amen keyemeko, alew alew yemdase kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yemdako, weng mak so bokoyemomele: “Yu tokfol so uneko, kanelom wanin o, men o, tum win men o, beem ibolow fukuneko, aluwko, kakamokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Beemdiw, yu yan aom mak minggilokoliw kate, yu kanelom afak ilim alew mak minggilokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yu abiw mak uneko, am mak uniw tewe, am ka kel kuw bomeliwi, kanelom am gol keemokoliw te! ");
INSERT INTO bhl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kate, yom abiw kawtem unokoliw ding dim bakate, abiw ka im kunum waneng i yulo kalfonginba keyemeko, yom weng e kililinba keliw tewe, yom iti abiw kolew ding kabalak e, yu yom yan dim be kukun beelo abiw ka akate kalis koleweko, unemoliwka! Yom kaneliw beem mongom ete yu kawtiw biilo kukuyemomeliw: Abiw kunum waneng yu Sunbin-Got em angin bate!’, yangboliwka!”, e ilo yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yangei, i aneng ka kolewko, ibolow famdelin angom weng be boko yak boko yak unsomi, ");
INSERT INTO bhl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","aneng matil kawtiw im dim biliw aneng matil banban takala koyemeko, kal wakamin kawtiw banban oliw ais dem beem gom so bulok keyemiwi, im wakamin be banimyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Beli, beem ding dim bakate, emisik kamok fian Kelot e Yesus em wiin so auk so kitil so eisneng fian aluwkabe eisneng beem sang kilise kale. Nimtew angom? Mali kawtiw i Yesus em dulum elo bokolomeliw: “Kawtiw ok da koyemin kunum Sion ete iti fomkamin elote teinsomi, kitil auk so eisneng kale duku kebe sako?”, ange ange kesiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kemiwi, mali kawtiw i bokolomeliw: “Kunum be Sunbin-Got em bontem dim bakamin sua kel alenale kunum Elaisa ete sako?”, angbiwi, iti mali kawtiw mak ikati bokolomeliw: “E nanew sua em bontem dim bakamin kunum kuaneko, iti fomkamin elote teinse kunum ete sako?”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kesomeliwi, Kelot e im angbiliw weng be kiliko, bokolomele: “Feinka! Kak goto kolewsi kunum Sion bete iti fomkamin dim elote baba teinse kai!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Deiw mak ding mak, aneng kaleem emisik kamok Antibas Kelot e akalem fik Filiw em kalel Kelodias ulo tokoluko, kuluse kasike, ok da koyemin kunum Sion e kamok Kelot beelo bokolewomele: “Nimtew angom ete ku kukuw kiol kukuw kelinba keko, kakunum em kalel Kelodias bu kululew a?”, dangeko, kukuw wa be fein kaim dim dalewse kasike, Kelot e Sion elo gal keleweko, sok net keleweko, elo sok am tem da kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Kolewei, Kelodias bu Sion beelo ibolow wa kelewsomi, alomin ibolow kesu kate, Kelot e Sion em dulum elote finganomi, elo kilele atemse kasike, u ki keko, elo alinba kesu kale. Fein! E kal kelete: Sunbin-Got e kunum beelo akalem wiin so amkoko, kolewsomelei, e akalem kiin dim e kiol kuw kunum kese kasike. Keko beli, e kunum beem weng bokolewkabe weng be kiliko, ibolow so kelewkabe kate, diking dakoung teifululin ibolow kuw kese kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Keko beli, deiw mak ding mak Kelodias u Sion elo alomin deiw mak atemsu kale. Beem ding dim bakate, Kelot e akalem auk um dukusu ding ibolow fukunsomi, akalem gawman ding dim em aluwbamin kunum so, akalem wonuk so kunum im kak kunum iso, Galili aneng fian em kamokim iso, kunum alik alik biilo gaayemei, i teliwi, eso iso makuw wanin fian mak wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Wansiliw ding dim bakate, Kelot em mun seiw Kelodias bu kunum biim teinbiliw dim matem teleko, ka biliw kunum banban biim kiin dim e wisu kale. Wibului, Kelot so, eso biliw kunum alik alik biim ibolow daokeyembului, “Yakai! Waneng seiw ati te!”, ange ange kesiliw kale. Kesiliw kasike, emisik kamok fian be ulo bokoumomele: “Nimtew eisneng mak ku ‘Dunema!’, nangew tewe, ne kulo fein dukemoki te!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wangesomi, weng fawtuk ayem weng mak bokoumomele: “Ku nomin eisneng mak bokonemomelew: ‘Nemena!’, nangew tewe, ne kulo fein kemenoki te. Feinka! Ku nelo bokonemomelew: ‘Kom aneng atebelew aneng beem mali kalat mak dunema!’, nangew tewe, ne fein kulo dukemoki te!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wangei, u kut uneko, ukalem auk Kelodias ulo dakalalomelu: “Ne nimtew eisneng mak elo ‘Ku nelo dunema!’, dangeko, dakalaloki ya?”. wangui, usik bokoumomelu; “‘Ku Sion kawtiw ilo ok da koyemkabe kunum beelo asomelew kano, kak goto wokilewsomi, em kak be denem tala o!’, dangolewka!”, wangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wangui, u fongate akate iti Kelot em mit mewso yako uneko, bokolewomelu: “Kame kalakate, ku Sion kawtiw ilo ok da koyemkabe kunum beelo asomelew kano, kak goto wokilewsomi, em kak be denem tala o!”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Dangui, e ibolow ilum fian fian mak kesomi, Sion elo alominba ibolow kese kate, akalem kunum bongguko, “Wanin wanbiliw kunum biim kiin dim e, ne fawtuk ayem weng mak keyemi kai!”, angomi, wangse fawtuk ayem weng be aluweko, fein gelewse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Fein gelewse kasike, e mali wonuk so kunum mak elo dabalalei, “Kunum beem kak de tela!”, dangei, e fein sok am tem ka uneko, Sion em kak goto keleweko, ");
INSERT INTO bhl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","awamin dim dukuko, delew teleko, waneng seiw buulo fein duumse kale. Duumei, u kak be kuluko, auk ulo deum unsu kasike, auk bu atemeko, atin kuw kal kelute: “Fein! Kame Sion e banime kai!”, angeko, ibolow ki keumei, Sion em kak sak fomdosu kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Keko beli, Sion em gelewkabiliw kunum i kililiwete: “Sion elo aliwi, e kuan kembe kai!”, angomeliwi, i uneko, em fom kulusomi, debeleko, fomkamin tem dukusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Beli, Yesus em kalan kunum bi iti em fukun teleko, ikalem aluwbameliw sang so, mali kawtiw ilo kukuyemsiliw sang so, beem sang alik alik beelo bokolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Keko beli, kawtiw banban i Yesus em mit mewso une tele kebiliw kasike, eso, akalem kalan kunum iso, i “Wanin wanomin ding banime te!”, angomi, e ilo bokoyemomele: “Yukalem kuw kawtiw banim dim mak elo uneko, ka kel finengdaloliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yangei, i em yangse weng be kilisomeliwi, e iso kunuw mak em dim teineko, ikalem kuw kawtiw banim dim mak kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Im unsiliw ding bakate, mali ka biliw kawtiw bi im unbiliw be yetemeko, “Yesus akalem angin so unbiliw kai!”, ange ange keko, fongate akate ikalem biliw abiw mutuk abiw mutuk bikati koleweko, imisik kawin deiw yako uneko, biliwi, i ibik ete keko, talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Teleko, Yesus em okmun dikeko, mali elote talse ding dim bakate, e ilo yetemete: Kawtiw banban teleko, biliwi, e yetemeko, ilo kinkin ibolow fian keyemse kale. Nimtew angom? Siwsiw yetebin kunum banim imdiw kesiliw kasike. Kesiliw angomi, e ilo kukuyemin weng banban mak bokoyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bokoyemsomelei, ataan tem dokong unomin ding mewso kele ding dim bakate, akalem gelewkabiliw kunum i Yesus em mit mewso teleko, bokolewomeliw: “Kale kel kawtiw banim dim kesomelei, aneng akal kuine kasike. ");
INSERT INTO bhl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kame ku kawtiw ka biliw biilo bokoyemomelew: ‘Yu abiw mutuk mutuk aneng aneng kalo wanin fenem unina!’, yangolewka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dangiwi, e yan weng bokoyemomele: “Yukalem ete ilo wanin mak yemenina!”, yangse kale. Yangei, i yan weng bokolewomeliw: “Nu on kisol fian banso banso kulusomi, belet wanin mak wenokoluw sako?”, dangeko, elo dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Dangiwi, e yan weng bokoyemomele: “Yu nomin belet wanin mak aluwbiliw a? Yu uneko, atemina!”, yangse kale. Yangei, i fein uneko, atemsomi, iti teleko, bokolewomeliw: “Teingabi kel belet wanin so, takam alew so, kuw be te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dangiwi, e kawtiw ka biliw biilo bokoyemomele: “Kame yu bongguko, amen amen kuw keko, balasal atite dim ka kel teinina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yangeko, i em yangse weng be fein kiliko, kawtiw 100 emdiw kesomi, kawtiw 50 emdiw kesomi, keko, ka kel teinsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Teinsomeliwi, Yesus e teingabi kel belet wanin be so, takam alew be so, mesesem mesesem be kulu aluwsomi, abiil elo atemeko, Sunbin-Got elo “Weso! Seyo!”, dangse kale. Dangesomi, belet wanin be fakal fakal kelewsomi, akalem kalun kel gelewkabiliw kunum biilo duyemei, i kunum waneng biilo yemensiliw kale. Yemensomeliwi, e takam alew akati kuluko, amen amen kuw yemense kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yemenei, i kuluko, wanesomi, kumun so fasu angsiliw kate, ");
INSERT INTO bhl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","wanin anung e banso banso beki kuw kelei, i kalun kel men fian mak abuko, belet atuk so, takam atuk so wen dukusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Beli, wanin wansiliw kunum ite kuw banban fufu keko, teingabi kel tausen (5'000) kel kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Beli, Yesus e akalem kalun kel gelewkabiliw kunum biilo bokoyemomele: “Yomisik kunuw dim teineko, okmun dikeko, Betsaida abiw elo unina!”, yangeko, kunum waneng ikati ikalem am dim elo yamdase kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yamdasomi, amgu tikin dim mak elo uneko, ka kel Sunbin-Got eso weng bokose kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Keko beli, ataan tem une ding dim bakate, e emikel kuw ok beleng dim kel belei, akalem gelewkabiliw kunum i kunuw dim kel ok mutuk dim unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Im unbiliw ding dim bakate, e ilo yetemete: Inim fian mak kunuw beem mutum kalote telei, i bukesomi, kunuw be de anung anung kebiliwi, e yetemse kale. Keko beli, aneng danomin kis kese ding dim bakate, Yesus e okmun dim kel moko, akalem gelewkabiliw kunum biim mit mewso teleko, ilo bakiyemomin ibolow keko, unse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Unbelei, gelewkabiliw kunum alik alik bi atemiwete: E okmun dim moko, unbelei, i atemeko, ibolow fukunomeliw: “Okmun kayak aneng matil mak talbe sako!”, angeko, fingansomi, gaanin fian mak olsiliw kale. Olbiliwi, fongate akate Yesus e bokoyemomele: “Yutaka! Yu kanelom finganbomi, walwal kemokoliw te! Nakalem ete talbi te. Yu kalaing kuw keboliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yangesomi, em kue yol tem kunuw dim teine ding dim bakate, suuk inim akal goto banimse kasike, i yol yol angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nimtew angom? I Yesus em belet wanin yemense eisneng be atemsiliw kate, im ibolow fukunin e kou angse kasike, i kilele dolon kelinba kesiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Beli, Yesus so, akalem gelewkabiliw kunum iso, alik alik biim okmun dikeko, ok mali Genesalet aneng kalo unsiliw ding dim bakate, i ikalem talsiliw kunuw be sok so net keleweko, ge kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Im kunuw koliw ding dim bakate, ka biliw kunum waneng i Yesus elo atemeko, bokolomeliw: “Kunum be Yesus ete kai!”, angomi, ");
INSERT INTO bhl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","aneng aneng angom kalo weng dabalaliwi, i wakamin kal wanin kebiliw kawtiw alik alik biilo kaung dim duku diwiko, Yesus em kakabe dim elo yemde unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yemde unsiliw kasike, abiw fian o, abiw fong o, naleem aneng angom be Yesus e une tewe, i wakamin so kawtiw alik alik biilo abiw beem wensankabiliw dim elo yemde unemaliw kale. Yemde unesomi, i Yesus elo kitil kuw bokolewomeliw: “Wakamin kunum waneng kali ki keko, kom ilim dim kuw teing melelewoliwka!”, dangsiliw kale. Dangiwi, fein, Yesus elo melelewsiliw kawtiw biim wakamin kal wanin be alik alik ken keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Beli, mali Falisi kunum so, mali Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum iso, alik alik bi Selusalem abiw mutuk fian koleweko, Yesus em fukun talsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Telesomi, i yetemiwete: Mali Yesus em gelewkabiliw kunum bi teing ok ginginba kesomi, Sunbin-Got em kiin dim e “I teing ninik so wanin wanbiliw kai!”, angeko, yetemeko, yol angsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nimtew angom? Falisi kunum so, Suda kawtiw iso, alik alik i diwkuw diwkuw awalik kumel im kukuyemsiliw weng be geleweko, im Sunbin-Got em kiin dim e ninik so teing be atin kuw kilele ok gingsomi, wanin wanenaliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Beemdiw, i wanin wenkabiliw dim elote teliw tewe, i diwkuw diwkuw kilele teing gingsomi, wanin wanakabiliw kasike. Keko beli, i ok wanbin sen o, wanin awamin o, ok sen fumin o, alik alik mesesem mesesem eisneng beelo kilele gingemaliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Keko beli, Falisi kunum biso, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum biso, alik alik kunum bi Yesus elo dakalalomeliw: “Nimtew angom ete kom kenggelewkabiliw kunum bi nukalem awalik kumel im kukuw beelo gelewinba kebomi, teing ginginba keko, Sunbin-Got em kiin dim e teing ninik so wanin wanbiliw a?”, dangeko, dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Dakalaliwi, e yan weng bokoyemomele: “Fimdi famde dasuw kawtiw yutaka! Sua e, Sunbin-Got em sua kel alenale bontem dim bakamin kunum Aisaya e yom kukuw wa be ateyemeko, fein weng bokolomele: ‘Kanekabiliw kawtiw bi nem wiin daonembiliw angbiliw kate, i sak bontem dim kuw kesomi, im ibolow fukunin e dolo dolo singam kel kebe te. ");
INSERT INTO bhl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kawtiw bi dem banim so, sak kal dim kuw nem wiin daonemkabiliw kate, i mali kawtiw ilo ikalem ibolow fukunin kuw Sunbin-Got em kukuyemin emdiw kitil ete kukuyemkabiliw te.’, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Fein, yu Sunbin-Got em kukuyemse weng beem afak emdiw kakabiliw kate, yu weng beelo koleweko, sak kawin dim kaleem kunum im weng ete kitil kuw aluwkabiliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yangeko, Yesus e iti weng mak bokoyemomele: “Yu yom kawalik kumel im yangsiliw weng bete kilele gelewkabiliw kate, yu Sunbin-Got em yulo kukuyemkabe weng beelo atin kuw dawkatikoko, de mit dakabiliw te. Feinka! Yom kanebiliw kukuw wa be ne kilele atebi te! ");
INSERT INTO bhl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yu kilele kililina! Moses e Sunbin-Got em bontem dim kuluko, bokolomele: ‘Yu kauk kumel so kalew kusel so ilo wangweng kukuw keyemboliwka!’, angeko, iti weng makso bokolomele: ‘Mali kawtiw mak ikalem auk o alew o ilo weng miyemiw tewe, yu ilo yeniwi, i kuanoliwka!’, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yangse kate, Falisi kunum yu so, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum yu so, alik alik yu on kisol ‘Kolban!’, dangenaliw em on kisol em dulum elote bokolomeliw: ‘Nimin kawtiw ite mak bokolomeliw: ‘Nu on kisol kale aatim o yem o ilo duyemokoluw kate kame, nu ibolow alwol kesomi, ‘Kolban!’ dangeko, fein Sunbin-Got elo dulewokoluw te.’ angbiliw kawtiw bi ");
INSERT INTO bhl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ken kuw kukuw kekabiliw kai.’, yangakabiliw te. Yangbiliwi, yu ilo iti bokoyemomeliw: ‘Kame on kisol be yu kanelom yukalem kauk so kalew so ilo duyemokoliw te!’, yangakabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kaneko kasike, yu dasuw weng bokolomeliw: ‘Sunbin-Got em wiin daolewkabuluw kunum nute te.’, angesomi, em weng fong eisneng emdiw keleweko, kulu kolewkabiliw te. Kate, yu yukalem kawalik kumel im kukuw bete kuw fein gelewsomi, diwkuw kukulew yak yak kekabiliw te. Kebomi, diwkuw diwkuw beem kukuw bete gelewko, kalelew tiak tiak de unakabiliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yangeko, kawtiw ka biliw kawtiw biilo gaaneko, bokoyemomele; “Yu nem yangoki weng kale kilele kiliko, dolon keloliwka! ");
INSERT INTO bhl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Kut em mesesem mesesem eisneng yu bontem dim dako, kunil waniw tewe, kaneliw eisneng be kawtiw yulo Sunbin-Got em kiin dim e wa keyeminba kekabe te. Babo! Kate kawtiw yom ibolow mutuk tem beelote fitew dim matem dale eisneng bete kuw Sunbin-Got em kiin dim e fein wa keyemkabe te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yangesomelei, e ka biliw kawtiw biilo koyemeko, am elo unse kale. Em unse ding dim bakate, akalem gelewkabiliw kunum i em yangse fakam weng beem mongom dolon kelinba kesomi, elo dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Dakalaliwi, e yan weng mak bokoyemomele: “Eke! Bani yukati ibolow kau angeko, dolon keko, kal kelinba biliw sako? Kut em mesesem mesesem eisneng yu bontem dim dako, kunil waniw tewe, e ki keko, wanbiliw kawtiw yulo Sunbin-Got em kiin dim ninik so keyeminba kekabe te. ");
INSERT INTO bhl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nimtew angom? Wanin be kawtiw im ibolow tem uneko, ilo wa keyeminba kekabe kate, emikel kuw kumun tem uneko, ol kelei, i olnuliwi, olikam tem unakabe kasike. Feinka! Wanin wanbiliw eisneng alik alik be Sunbin-Got em kiin dim e ken ati kuw te. ");
INSERT INTO bhl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kate, yu kilele ibolow fukunina! Kawtiw im ibolow tem elote fitew dim kaim matem daliw em mesesem mesesem eisneng bete kuw Sunbin-Got em kiin dim e wa keyemkabe te. ");
INSERT INTO bhl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Feinka! Kawtiw im ibolow sili sili nam beem sen em fitew dim dakabiliw kukuw wa be kanekote: Kut deiw osow kemin e, yakut kemin e, kawtiw yeniwi, kuan kemin e, ");
INSERT INTO bhl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kais yemkal im nanew kawtiw so osow kemin e, bisil keko, mian wanin kemin e, mamtel nam kemin e, dasuw yakut kemin e, ibolow tem moyemkemin e, kiin yakut kemin e, kawtiw nanew ilo weng miyemin weng kemin e, ikalem wiin daokemin e, ibolow teifulu kemin bete te. ");
INSERT INTO bhl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kaneko eisneng be kawtiw im ibolow tem elote matem teleko, kawtiw ilo Sunbin-Got em kiin dim e fein ninik so wa keyemkabe bakate.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Beli, Yesus e aneng ka koleweko, Suda kawtiw im ibik biliw kawtiw im aneng fian unesomi, Tail so Saidon so abiw mutuk fian alew biim aneng ka kel kakamale kale. Kakabomi, e yawal keko, am mak kawtem unse kate, kawtiw i “Yesus e ka be kai!”, angeko, kal kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Beem ding dim bakate, waneng mak alenalu kale. Waneng buum mun um dim e aneng matil mak wauluko, alenale kale. Keko kasike, waneng bu kawtiw im “Yesus e ka be kai!”, angsiliw weng be kiliko, fongate akate teleko, Yesus em mit mewso katin bukbuk angeko, teinsomi, ");
INSERT INTO bhl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","bokolewomelu: “Ku nelo dokonemeko, nem mun um dim alakabe aneng matil be takala kulu kouma!”, dangsu kale. Waneng bu Isalael kawtiw im deng ka biliw kawtiw Silia aneng fian em Fenisia aneng beem waneng ute kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Keko beli, Yesus e waneng buulo yan weng bokoumomele: “Emisik ding dim kabalak e, aul muluwel ikalem ete wanoliwka! Wanesomi, ibik ete mian ilo duyemoliwka! Nimtew angom? Aul im wanin be sak mian ilo dukayemiw tewe, be wa kukuw kasike!”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wangei, usik yan weng bokolewomelu: “Ku fein weng bokolew kate, kawtiw im aul i wanin dem ken wanbiliwi, mali wanin tabol e sak abin dim kumine tewe, ikalem mian i teleko, kubul wanakabiliw te.”, dangsu kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dangui, Yesus e bokoumomele: “Kom nangew weng be ken kasike kame, ku iti kukalem am elo una! Kom mun um dim alakabe aneng matil be takala koumeko, une kasike.”, wangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wangei, waneng bu am uneko, ukalem mun ulo watemute: Um dim bise aneng matil be takala koumeko, unei, u akalbului, watemsu kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Beli, Yesus e Tail abiw mutuk fian beem aneng iti koleweko, Saidon abiw mutuk fian am dim ka deiw uneko, Galili okmun kaem deiw bakileweko, Dekabolis aneng fian katiw elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ka kel unbelei, mali kawtiw i kunum kentem kabom nam keko, kilele ki keko, weng bokolinba kese kunum mak Yesus em mit mewso debele teleko, elo kitil weng kuw bokolewomeliw: “Kom teing e kunum beem dim dukuko, elo kilelewa!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dangiwi, e kunum be debeleko, aso imikel kuw mutuk mak kel mosiliw kale. Mosomeliwi, Yesus em teing kang deeko, kunum beem kentem dim dukulewko, kasuk tuw akalem teing kang dim dukuko, kunum beem foong dim dukulewse kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dukulewsomi, Yesus e gatak daok keko, abiil katem elo atemeko, ibolow sakalet angeko, kunum beelo bokolewomele: “Efata!”, dangse kale. (“Efata” weng beem mongom e kanekote: “Busok anga!”) ");
INSERT INTO bhl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dangei, fein, kunum beem kentem busok angei, em weng ditditkabe foong akal weng ken kuw folot angesomelei, e kilele weng bokose kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kele angomi, Yesus e kawtiw biilo iti kitil kuw bokoyemomele: “Yu itel kanelom atemiw eisneng kale kaim dim boko yak yak unokoliw te!”, yangeko, weng ayemse kate, i em yange weng be gelewinba kesomi, sakalaw keko, weng bo bo keko, sang be boko yak yak de unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Keko beli, sang beem kilisiliw kawtiw alik alik i atin kuw yol yol angeko, bokolomeliw: “Ibo! Kunum beem kanebe eisneng alik alik be itel fein kiol kuw kekabe te. Kentem kabom ikal weng kililiwi, bontem kasise ikati fein weng bokokabiliw kasike!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Beem ding dim bakate, kunum waneng banban mak teleko, Yesus em be dim ka kel wensansiliw kale. Wensaniw ding dim bakate, Yesus e yetemete: “Kunum waneng bi wanin tewso kebiliw kai!”, angomi, akalem gelewkabiliw kunum ilo gaayemeko, bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ne kunum waneng kalilo kinkin keyemi te. Nimtew angom? I nuso tiak ding biliwi, alemsal ding kelei, i yemen tew tein fakalaliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nu ilo sak yamdaluw tewe, i deiw kel yemen tew teinsomi, kiin felfel beit keko, fom mit tolokoliw te. Fein! Mali kawtiw bi singam kawtiw kasike!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yangei, akalem gelewkabiliw kunum i bokolewomeliw: “Kawtiw banim wanin banim dim kalesik e, nu nono kesom ete, wanin yemenokoluw a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dangiwi, Yesus e ilo bokoyemomele: “Yom belet wanin e nolin kuw be ya?”, yangei, i yan weng bokolewomeliw: “Ben kel belet wanin kuw bete.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dangiwi, Yesus e ka biliw kunum waneng biilo bokoyemomele: “Alik yu kawin dim ka kel tein fakalalina!”, yangse kale. Yangesomi, Yesus e ben kel belet wanin be kulusomi, Sunbin-Got elo “Weso! Seyo!”, dangeko, fakal fakal keleweko, akalem gelewkabiliw kunum biilo duyemei, i kunum waneng biilo amen amen keyemsomi, yemensiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yemensomeliwi, Yesus e im abubiliw takam gelgel mak akati kuluko, Sunbin-Got elo “Weso! Seyo!”, dangeko, akalem gelewkabiliw kunum biilo bokoyemomele: “Yu takam be kawtiw biilo amen amen keyemenina!”, yangei, i fein ilo yemensiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yemensomeliwi, i wanesomi, alik alik i ki kesomeliwi, wanin e beki kuw kelei, i wanin atuk kolewsomi, abuko, ben kel men fian weneko, dukusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kawtiw im teing bokoko, fufu e ketket teben tausen (4'000) kel emdiw kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Keko beli, e kawtiw biilo yamdasomelei, eso, akalem gelewkabiliw kunum iso, i kunuw dim mak teinsomeliwi, Dalmanuta aneng kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Beli, Falisi kunum mali mak i teleko, Yesus elo dumin weng mak bokoleweko, kiskis weng bokolewomeliw: “Kame ku kitil so auk so eisneng mak dukulew kano, nukal atemeko, atin kuw kal keluwete: ‘Fein! Ku Sunbin-Got em aluwbamin kunum kute kai!’, kangokoluw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dangiwi, em ibolow mutuk tem ilum fian mak kesomelei, e ilo bokoyemomele: “Eke! Kameem ibolow benebiliw kawtiw yu kitil so auk so eisneng ‘Nulo kukuyema!’, angeko, gaanem teliw kate, ne yulo kitil eisneng mak nam kukuyemii, yu nam atemiw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yangesomi, im biliw dim ka koleweko, kunuw dim teinsomi, iti ok dikeko, okmun mali elo unse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Im unsiliw ding dim bakate, Yesus em gelewkabiliw kunum i belet wanin akokow keko, fong gel makmak kuw kunuw dim abuko, de unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Unbomeliwi, Yesus e weng temtem mak bokoyemomele: “Wee yutaka! Yukati Falisi kunum so, emisik kamok fian Antibas Kelot iso, alik alik biim belet wanin fasu kolewkabiliw eisneng is beem dulum elo kilelbiko, boliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yangei, akalem gelewkabiliw kunum i kilisomi, bokolomeliw: “Kate nu belet wanin mak de telinba keluw kasike, kane weng yangbe sako!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Angbiwi, Yesus e im angbiliw weng be kal keko, bokoyemomele: “Nimtew angom ete yu bokolomeliw: ‘Nu belet wanin banim te!’, angbiliw a? Yu nem yangbi weng beem mongom e kal kelinba keko, akokow kebiliw sako? Yu ibolow kau angbiliw sako? ");
INSERT INTO bhl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yukal kiin so kate, ateminba kebiliw sako? Yukal kentem so kate, weng kilele kililinba kebiliw sako? Yu fein atin kuw ibolow akokow kebiliw sako? ");
INSERT INTO bhl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nem teingabi kel belet wanin mak kuluko, teingabi kel tausen (5'000) kawtiw biilo wanin yemensi ding dim kabalak e, yu nomin kolewsiliw wanin atuk ete men abu dukusiliw a?”, yangeko, dakalase kale. Dakalalei, i yan weng bokolewomeliw: “Kalun kel men abu dukusuluw te!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Dangiwi, e dakalalomele: “Usinel e, ne ben kel belet wanin kuluko, ketket teben kel tausen (4'000) kunum biilo yemenii, i waneko, gal kesomi, yu nolin men bete abu dukusiliw a?”, yangei, i yan weng bokolewomeliw: “Ben kel.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dangiwi, e bokoyemomele: “Yukal kame akal kilele dolon kelinba biliw bani?”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Beli, Yesus so, akalem gelewkabiliw kunum iso, i uneko, Betsaida abiw kalo unsiliw kale. Uniwi, abiw beem kasel i wakamin kiin sukul kunum mak debele teleko, Yesus elo kitil kuw bokolewomeliw: “Ku kunum beelo teing aluwko, kilelewa!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dangiwi, e kiin sukul kunum beem teing aluweko, debeleko, abiw fe dim elo uneko, kasuk tuw em kiin dim dalewsomi, akalem teing deeko, em kiin dim dukulewsomi, iti koleweko, dakalalomele: “Ku mesesem eisneng mak atemew e?”, dangeko, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dakalalei, kunum be kiin doungeko, yan weng bokolewomele: “Ne atemite: Kawtiw kali ais atew keko, talbiliwi, ne yetemi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dangesomelei, e iti teing deeko, em kiin dim elo dukulei, kunum beem kiin e fein ken kesomelei, e alik alik eisneng be kilele kiin doung angeko, yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kiin kilele dolon keko, yetemei, Yesus e elo iti akalem am dim elo dabalako, bokolewomele: “Ku kanelom abiw kalo unokolew te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Beli, Yesus so, akalem gelewkabiliw kunum iso, im Sisalia Filibai abiw mutuk fian beem abiw biliw kalo unsiliw ding dim bakate, e ilo dakalalomele: “Kunum waneng i nelo netemeko, nelo kante nangeko, ibolow fukunkabiliw a?”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yangei, i yan weng mak bokolewomeliw: “Mali kawtiw mak i bokolomeliw: ‘Ku Sion ok da koyem kemin kunum kute sako!’, angbiliw te. Mali isik bokolomeliw: ‘Sua sua kel alenale Sunbin-Got em bontem dim bakamin kunum Elaisa kute sako!’, angbiliw te. Iti mali kawtiw mak i bokolomeliw: ‘Sua sua kel em mali Sunbin-Got em bontem dim bakamin kunum kuanse kunum kame iti teinbomi, kanebe kunum kute sako!’, angbiliw te.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dangiwi, e ilo dakalalomele: “Kate yutaka! Yukalem ete nelo kante nangeko, ibolow fukunbiliw a?”, yangei, Fita e yan weng bokolewomele: “Ku Sunbin-Got em Mesaya kute te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dangei, Yesus e kitil weng mak bokoyemomele: “Yu kanelom mali kawtiw ilo ‘Yesus be Mesaya ete te!’, yangeko, bokoyemokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yangesomi, weng kal mak bokoyemomele: “Isalael kawtiw im kak kunum kebiliw kunum so, Sunbin-Got em am yol em kunum ayem sel iso, em angin iso, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum iso, alik alik bi Kawtiw Aul nelo gal kenemeko, ilum fian so betbet fian so dunemeko, neniwi, ne kuaneko, yemamas kel ding keko, iti baba teinoki te. Nimtew angom? Sunbin-Got e kaneloke beem dulum elote ‘Kaneloka!’, angse kasike.” yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yangei, Fita e Yesus em kaim dim kuw bokose weng be kilele kiliko, Yesus elo dolon dim takas debeleko, unesomi, digaka kelewse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kelei, Yesus e famdes angeko, akalem gelewkabiliw kunum ilo yetemsomi, Fita elo bokolewomele: “Seten-Ataanim kutaka! Nem ibik katem elo una! Ku Sunbin-Got em ibolow ete gelewinba somi, kawtiw im ibolow fukunin ete kuw gelewbelew kasike!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dangeko, Yesus e ka biliw kawtiw so, akalem gelewkabiliw kunum biso, alik alik biilo gaayemeko, bokoyemomele: “Yu kale kel teleko, kilele kililina! Nimin kunum waneng ite mak nelo nenggelewiw tewe, i ikalem ibolow fukunin be kolewsomi, Sunbin-Got em ibolow fukunin bete kuw gelewemoliwka! Gelewbiliw kasike, mali kawtiw mak i biilo nem dulum elote yenewi, i inkal kulamiw tewe, i ‘Ken kuw ka!’, angeko, nelo diwkuw nenggelewboliwq ");
INSERT INTO bhl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yu kililina! Mali ikalem finik so bomin kuw fukunkabiliw kawtiw i ikalem finik so fein banimokoliw te. Banimokoliw kate, nimin kawtiw ite mak nelo nenggelewko, Sunbin-Got em Weng Kal Ken Ati be kitil kuw aluwsomi, ikalem finik so bomin beem dulum fukuninba keliw tewe, kawtiw bi sunsun finik so bin kuluko, bókoliw te. ");
INSERT INTO bhl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Beemdiw, mali kawtiw mak kawin dim kaleem on kisol mesesem beem ibolow kuw keko, kulamokoliw kate, ikalem finik e Seten-Ataanim em abiw wa wa une tewe, kawtiw bi ken kelokoliw sako? Bayo! Wa wa kebokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kebomeliwi, i nono keko, finik so sunsun bin iti kuluko, bókoliw a? Alwol keko, iti kulewomin em deiw ma banim kasike! ");
INSERT INTO bhl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yu kilelbi boliwka! Nimin kunum waneng ite mak kawin kaleem sili sili nam kekabiliw kawtiw so, mali dasuw-got daoyemkabiliw kawtiw iso, alik alik biim mutuk bomi, finganeko, nem weng so nakalem so ibik kunemiw tewe, Kawtiw Aul nem Aatim em auk so kitil so be kuluko, akalem wiin so amko koyemse yemdakamin finik iso toloki ding dim kabalak e, yukati ibik kuyemoki te. ");
INSERT INTO bhl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yu nem yangbi weng kale kilele kililina! Kame mali kawtiw mak biliw kali kuaninba siliw akate, Sunbin-Got em gawman em kitil so toloke ding be ikati atemokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yangei, iti gung kel ding mak banimei, Yesus e Fita o, Sekow o, Sion o, iso yemdeko, imikel kuw amgu tikin fian mak unsiliw kale. Unesomeliwi, Yesus akalem kal e im kiin dim kel famdes angei, i atemiwete: ");
INSERT INTO bhl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Em ilim e yukam kais emdiw kese kate, kaneko kais be kawin dim kaleem kais eisneng alik alik beelo bakilewkabe te. ");
INSERT INTO bhl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kesomelei, Elaisa so Moses so aso i Yesus eso bonggu mobomeliwi, weng bokolew bokolew kebiliwi, i yetemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yetemsomeliwi, Fita e Yesus elo bokolewomele: “Num kukuyemin kunum kutaka! Buluw dim kale ken ati. Kasike, kukalem ete nulo ‘Kenka!’, yangew tewe, kame kalakate, nu kanis doung kanel doung tem am alemsal mak geluma! Am mak e kom, mak e Moses em, mak e Elaisa em gelokoluw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Dangse kate, i finganin fian mak kesomeliwi, Fita e “Nimtew weng mak bokolewoki yake?”, angeko, ibolow kau kese kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Beem ding dim bakate, yukam mak teleko, ilo kasi koyemsomi, beem tem kalote weng mak bokolomele: “Kunum be nakalem min ete te. Ne sun kuw ibolow mutuk fian dulewkabi kasike, yu em weng kuw gelewemoliwka!”, angse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Angei, i kiin babeleng atew kanis kiineng kanel kiineng angsiliw kate, kawtiw mak yeteminba kesiliw kale. Yesus emikel kuw mobelei, i atemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kanesomi, im amgu tikin dok dim ka talsiliw ding dim bakate, Yesus e kitil weng mak bokoyemomele: “Yu kanelom mali kawtiw ilo kanele eisneng be bokoyemokoliw te! Kate, Kawtiw Aul nem kuaneko, iti baba teinoki ding dim kabalak e, yu mali kawtiw ilo kanele be fein bakayemboliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yangei, i em yange weng be kiliko, gelewsiliw kate, ikalem kuw dakalale dakalale kelomeliw: “Em ‘Kuaneko, iti baba teinoki’ weng bokoyembe weng kale nono keloke ya?”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Keko beli, akalem gelewkabiliw kunum i elo dakalalomeliw: “Nimtew angom ete Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum i bokolomeliw: ‘Mesaya em toloke ding dim e, Sunbin-Got em bontem dim bakamin sua kel alenale kunum Elaisa esik toloke te!’, yangekabiliw a?’, dangeko, dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Dakalaliwi, e yan weng bokoyemomele: “Fein te. Elaisa e esik teleko, mesesem wa kebe eisneng beelo iti kileleko, kiol kuw keloke kate, yu ibolow fukunina! Elaisa e alik eisneng kilele kiol kuw kele tewe, nimtew angom ete Sunbin-Got em fut tem e Kawtiw Aul nem dulum elote fut tem boko, bokolomele: ‘Ne betbet fian mak kulabelei, i nelo desi kenemokoliw te.’, angse ya? ");
INSERT INTO bhl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kate, yu kililina! Elaisa e fein talse te. E talse kate, kawtiw i Sunbin-Got em fut em Elaisa em dulum angse weng be ki kelewsomi, ikalem ibolow kuw geleweko, elo kukuw wa kuw kelewsiliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Beli, Yesus so, akalem gelewkabiliw kunum alemsal biso, akalem mali gelewkabiliw kunum biim dim kalo uneko, talsiliw ding dim bakate, kawtiw demdem mak teleko, mali gelewkabiliw kunum biilo falal koyemiwi, i mali Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum iso weng dumiwi, i yetemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Im yetemeko, talsiliw ding dim bakate, ka biliw kawtiw bi Yesus elo atemeko, yol fian angeko, em fukun kalo yakoko, “Talbelew yako!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Dangiwi, e akalem gelewkabiliw kunum biilo dakalalomele: “Yu nimtew weng sel iso tekbiliw a?”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yangei, ka biliw kawtiw biim mutuk kunum mak yan weng mak bokolewomele: “Kukuyemin kunum kutaka! Nem min kale kom mit de telika! Nimtew angom? Aneng matil mak em bontem dim ka kel kasi kolewbe kasike. ");
INSERT INTO bhl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aneng matil beem aul beelo ‘Aluwo!’, ange ding kabalak e, e elo kawin dim botut kabalak elo kelewei, e bontem kasuk mok matem dasomi, akalem ning weng so nangyot nangyot kesomi, akalem kal e dingding fian kelewkabe te. Kaneko beli, ne kom kenggelewkabiliw kunum biilo ‘Yu aneng matil beelo takala kolewko, anbakalalina!’, yangi kate, im kitil e sukum gel kele te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dangei, e ilo bokoyemomele: “Fein ibolow banim kawtiw yutaka! Ne yulo gal keyemi te! Nomin ding ete ne yuso bomelii, yu nelo ilum mak so dunemkabiliw a?”, yangesomi, alew elo bokolewomele: “Kate kom min be debele tala!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dangei, min be Yesus em mit telei, aneng matil beelo atemse ding dim bakate, aneng matil be aul beelo walwal kuw kili kili kelewse kale. Kelewei, aul be kawin dim botut kabalak elo kelewei, e bontem kasuk mok matem dasomi, kawin dim fimdis famdes kese kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kelei, Yesus e alew elo dakalalomele: “Em kanekabe kale nolin ding kelewkabe ya?”, dangei, e yan weng bokolewomele: “Em auk um aul gel dim dukusu ding bakate te. ");
INSERT INTO bhl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aneng matil be elo alomin beem mongom ete diwkuw diwkuw ais kul tem kulus ok tem kulus kelewkabe te. Kanekabe kasike, kom kitil e ki keko, tewe, ku nulo kinkin keyemsomi, nulo dong dokoyema!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Dangei, Yesus e bokolewomele: “Kom nelo bokonembelew weng ‘Ku ki keko, tewe’, nangbelew weng beem mongom e nimtew a? Ku kilele kilila! Nimin kunum waneng ite mak ‘Feinka!’, nangiw tewe, alik alik eisneng angom keliw eisneng be im dim e fong gel kuw kelewboke kasike.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dangei, alew be fongate akate gaaneko, bokolewomele: “Ne kulo ‘Fein!’, kangbi kate, ku nem fein ibolow sukum beelo atemeko, dokonema!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dangei, Yesus e atemete: “Mali kawtiw banban makso mak yako teliw kai!”, angesomi, kitil weng mak aneng matil beelo bokolewomele: “Bontem so kentem so kasi kolewbelew aneng matil ku fongate akate aul be koleweko, kut elo unesomi, atin kuw fon unolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dangei, fein, aneng matil be gaanin fian mak gaaneko, aul beelo bitit butut kelewsomi, kut uneko, aul be fom kuankemin emdiw kolewse kale. Kolewei, ka biliw kawtiw i bokolomeliw: “Ibo! Kame atin kuw kuane kai!”, ange ange kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kesomeliwi, Yesus e aul beem teing bing kelewei, e tein baba angeko, mose kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Anfel ibik ete, akalem gelewkabiliw kunum imikel teleko, Yesus em be am kawtem uneko, elo dakalalomeliw: “Nimtew angom ete aneng matil be num weng kiliko, kut uninba kembe ya?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Dangiwi, e yan weng bokoyemomele: “Yu ki keko, Sunbin-Got eso weng bakamin beem deiw ete kuw aneng matil beemdiw takala kolew kemokoliw te,” yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yangeko, beem ding dim bakate, Yesus so, akalem gelewkabiliw kunum iso, alik alik i biim biliw aneng be iti koleweko, “Mali kawtiw i nem kakabi dim be kanelom kal kesomi, nem fukun tolokoliw te!”, angesomi, yawal keko, Galili aneng fian kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Im unsiliw ding dim bakate, e akalem gelewkabiliw kunum imikel kuw kukuyemeko, bokoyemomele: “Mali kawtiw i Kawtiw Aul nelo kawtiw im teing dim da konemiwi, i nelo neniwi, ne kuanoki te. Keko beli, yemamas kel ding kabalak e, ne iti teinoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yangse kate, i em yange weng beem mongom e akokow kesiliw kate, i elo dakalalomin fingansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Keko beli, Yesus so, akalem gelewkabiliw kunum iso, alik alik biim Galili aneng fian be kakabisomi, Kabelneam abiw mutuk fian kalo talsiliw ding dim bakate, i am mak kawtem uniwi, e ilo dakalalomele: “Num deiw tuluw ding dim be, yu nimtew weng kuw tekbiliw a?”, yangei, ");
INSERT INTO bhl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","i yan weng banim kelewsiliw kale. Nimtew angom? Ikalem kakamiw ding dim kabalak e, i weng bonge bonge keko, “Kante emisik keko, mali biim kak kunum keloke a?”, ange ange kesiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Keko beli, Yesus e akalem kalun kel kunum gaayemei, i mewso teliwi, e ilo bokoyemomele: “Nimin kunum waneng ite mak ‘Nu numisik kak kunum kebin keluma!’, angiw tewe, i wiin banim kunum keko, mali kawtiw im weng afak kuw kakamin kunum waneng keboliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yangeko, aul gel mak debele teleko, akalem mit ka mo koleweko, falal kelewsomi, bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yu kilele kililina! Nimin kawtiw ite mak nem ibolow fukunsomi, aul gel kalakalin mak dokolewiw tewe, i nakati dokonemeko, bakilewsomi, nem namdale Aatim bakati dokolew kebiliw bakate.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yangse ding bakate, Sion e Yesus elo weng mak bokolewomele: “Kukuyemin kunum kutaka! Nu atemuwete: Mak kunum mak kom wiin dim kel kawtiw im dim biliw aneng matil takala koyembelei, nu atemsuluw te. Atemsuluw kate, e nuso bongguko, kulo kenggelewinba kebe kasike, nu elo kitil weng bokolewomeluw: ‘Ku kanelom makso kanemokolew te!’, dangbuluw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dangse kate, Yesus e ilo bokoyemomele: “Yu kanemokoliw te! Nimtew angom? Nimin kawtiw ite mak nem wiin dim auk so kitil so eisneng mak keliw tewe, i fongate akate nelo nam weng minemiw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yu kilele kililina! Nulo maka keyeminba kebe kunum mak e nukalem angin kebe kasike! ");
INSERT INTO bhl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Feinka! Nimin kawtiw ite mak bokolomeliw: ‘Kulais em wiin dim teliw kunum ite te!’, angesomi, yulo sak ok yemeniw tewe, Sunbin-Got akati im yan ken nam koyeme te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yangeko, weng makso bokoyemomele: “Nimin kawtiw iti mak ibolow fein nangeko, finik so kulomin deiw kakabiliw aul gel mak ilo wa eisneng mak im ibolow mutuk tem daliw kasike, aul bi ikalem kakabiliw deiw kel kuminiw tewe, kanebiliw kawtiw biim kal ilum e fian fian kuw keloke te. Kanebiliw kawtiw biim kulokoliw ilum be tum fian sel biim gatak dokong keyemeko, ilo kuse ok da koyemokoliw beem ilum be atin kuw bakilewoke te. ");
INSERT INTO bhl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Yu kililina! Yom teing be wa kukuw kemomin kuw keyembe tewe, yu elo goto kololiwka! Keko beli, yu teing makmak kuw kesomi, finik so sunbin abiw kalo unokoliw kasike! Mesik esik teing alew so biliwi, Sunbin-Got e yulo yemdeko, ais dong nam banime dim kalo da koyem keyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Beemdiw, yom yan be wa kukuw kemomin kuw keyembe tewe, yu elo goto kololiwka! Keko beli, yu yan yout kesomi, finik so sunbin abiw kalo unokoliw kasike! Mesik esik yan alew so biliwi, Sunbin-Got e yulo yemdeko, ais dong kalo da koyem keyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Beemdiw, yom kiin mali be wa kukuw kemomin kuw keyembe tewe, yu kaneyembe kiin be walu kololiwka! Keko beli, yu kiin makmak kuw kesomi, Sunbin-Got em gawman dim kalo unokoliw kasike! Mesik esik kiin alew so biliwi, Sunbin-Got e yulo yemdeko, ais dong dim kalo da koyem keyemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Beem bókoliw dim kabalak be, ‘im kal anggil nam banime geten e belei, ais dong akal nam banimeko, diwkuw diwkuw boke te.’ ");
INSERT INTO bhl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yu kilelbi boliwka! Ais dong be kawtiw alik alik ilo yol so keyemoke te. ");
INSERT INTO bhl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yol e abal nam eisneng kate, em abal e banime tewe, yu nono keleweko, elo iti abal nam kelewokoliw a? Beem kanelomin deiw ete banim te. Nakunum kumel kunum yutaka! Yom ibolow mutuk e yol so emdiw kesomi, mali kakunum kusel ilo ibolow menew kukuw kuw kukulew kukulew kemoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yangesomelei, i Galili aneng fian iti kolewsomi, Sudia aneng fian elo uneko, Yoldan bang dikeko, ok em mali aneng kalo unsiliw kale. Unbiliwi, iti kunum waneng banban i em mit mewso telesomi, wensaniwi, e akalem kanekabe kukuw geleweko, ilo kukuyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Keko beli, mali Falisi kunum mak teleko, Yesus elo kiskis weng mak bokoko, dakalalomeliw: “Kunum mak ki keko, akalem ibolow kuw geleweko, akalem kalel ulo koumoke ye?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Dangiwi, e yan weng bokoyemomele: “Moses em sawa weng yulo duyemse weng e nimtew angakabe ye?”, yangei, ");
INSERT INTO bhl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","i bokolewomeliw: “Moses e bokolomele: ‘Nimin kunum ite mak ikalem kalel kumel ilo koyemomin ibolow keliw tewe, i koyemkemin fut anung mak bosomi, ilo dukayemboliwka! Duyemsomi, fein, ilo koyem keyemoliwka!’, yangse kai.”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dangiwi, Yesus e yan weng bokoyemomele: “Sunbin-Got e ‘Yu kanemina!’ anginba kese kate, yukalem kau angbiliw ibolow beem dulum elote esik weng be Moses elo dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dangse kate, em kilkese ding kabalak e, e kanebe sawa weng be dukulinba kese kale. Yu kilele teing bakamoliwka! “Sunbin-Got e kunum kelew, waneng keum duku koyemse kale.”, angeko, iti weng makso bokolomele: ");
INSERT INTO bhl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Kasike kame, kunum kumel i aliwol kumel so auk kumel so bi koyem uneko, ikalem kalel kumel iso teinsomi, ");
INSERT INTO bhl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","i kal anggil makmak kekabiliw te.”, angse kale. Kasike kame, yemkal bi kal anggil alew kelinba kebiliw kate, i kal anggil makmak kuw kesomi, biliw te. ");
INSERT INTO bhl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bomeliwi, Sunbin-Got e yemkal bi bonggu makmak keyemse kasike, sak kawtiw yu ilo kanelom iti takala koyemokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yangei, im am kawtem unsiliw ding dim bakate, akalem gelewkabiliw kunum i elo beem yange weng be iti dakalasiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Dakalaliwi, e yan weng bokoyemomele: “Nimin kunum ite mak ikalem kalel kumel biilo sak kulu koyemeko, nanew waneng kuliw tewe, kunum bi osow kukuw kebiliw kasike, im kalel kumel im kiin dim e sen so kebokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Beemdiw, nimin waneng ite mak ikalem imok kumel biilo sak walel koyemsomi, nanew kunum kuliw tewe, waneng bi osow kukuw kebiliw kasike, ikal sen so te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Beli, mali kawtiw mak ikalem aul ilo Yesus em mit mewso yemde telesomi, elo bokolewomeliw: “Kom teing deeko, num aul gelgel kaliim dim dukulew kano, ilo bamki so keyema!” dangsiliw kale. Dangiwi, Yesus em gelewkabiliw kunum bi kawtiw biim kanebiliw be ibolow keyeminba kesomi, ‘Ayem! Yu kanemokoliw te!’, yangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yangiwi, Yesus e im kanebiliw be atemeko, digaka keyemeko, ilo bokoyemomele: “Yu kanelom kanemokoliw te! Aul bi yemdeko, nem mit mewso yemde telina! Nimtew angom? Aul ikatetew kunum waneng itekuw Sunbin-Got em gawman dim kalo fein unokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yu kilelbi kililina! Mali kunum waneng yu aul gelgel biimdiw kesomi, “Sunbin-Got e ‘Feinka! E nulo fein yetemkabe kae!”, anginba keliw tewe, em gawman ding dim kabalak e, yu elo atemeko, kalo nam uniw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yangesomi, fein, aul gelgel biilo mumul da koyemsomi, em teing im dim dukuko, bamki so keyemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Beli, Yesus em iti ka kel kakamele ding dim bakate, mak kunum mak em mit mewso teleko, katin bukbuk angeko, dakalalomele: “Kukuyemin ken kiol kunum kutaka! Ne nono kesomete, sun kuw bin finik be kuloki a?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Dangei, Yesus e elo yan weng bokolewomele: “Ku nimtew angom ete nelo ‘Ken kiol kunum’ nangew a? Sunbin-Got ete kuw kukuw ken so kasike! ");
INSERT INTO bhl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ku Moses em bokoyemse kukuyemin weng be kal kebelewte: ‘Yu kanelom kawtiw ilo yemokoliw te! Yu kanelom osow kemokoliw te! Yu kanelom yakut kemokoliw te! Mali kawtiw mak yulo dakalaliw tewe, yu kanelom dasuw weng bokoyemokoliw te! Yu kanelom mali ilo funum funum keyemeko, im mesesem yakut keyembokoliw te! Yu kauk so kalew so im afak bomi, wangweng keyemeko, im wiin daoyem kemoliwka!’, ange kai.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dangei, kunum be bokolewomele: “Kukuyemin kunum kutaka! Nem aul gel kebi ding dim akate, kameem ding dim kale akati, ne sawa weng kale diwkuw diwkuw gelewkabi te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dangei, Yesus e weng be kiliko, kunum beelo atemeko, ibolow fian dulewsomi, bokolewomele: “Ku ken kukuw kebelew kate, makmak eisneng mak beem dulum elote sukum belewte: Kame, kom mesesem on kisol alik alik be wensomelewi, em banim kawtiw ilo amen kuw keyemolewka! Keyemew tewe, sow ete, ku abiil tikin em on kisol bakati fein kulokolew te. Kaneko kasike, ku nelo nenggelolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dangei, kunum be weng be kiliko, akalem on kisol banban beelo fukuneko, yol angeko, ibolow tiaktiak kesomi, anggil dang so balat angeko, unse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Unei, Yesus akalem gelewkabiliw kunum im dulum elo yetemeko, bokoyemomele: “Em so kawtiw i Sunbin-Got em gawman dim elo unomin bukesomi, mewso uninba kebiliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yangei, i em yange weng be kiliko, yol angsiliw kasike, e ilo bokoyemomele: “Aul min yutaka! Feinka! Kunum waneng i Sunbin-Got em gawman dim elo unomin bukesomi, mewso uninba kebiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel samal fian sel e ilim benemin sil tem be unomin bukekabe kate, on kisol so kunum mak i Sunbin-Got em gawman dim elo unomin kakunin keko, bukesomi, nam uniw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yangei, i em yange weng be kiliko, yol angeko, dakalalomeliw: “Ibo! Kate kante sunsun finik so bin be kuluko, boke a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dangiwi, e kiin doung yetemsomelei, ilo yan weng bokoyemomele: “Kunum waneng im kitil e fong gel kasike, i nam keliw te. Kate, Sunbin-Got em kitil e fian kebe kasike, e alik alik eisneng mak ki kemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yangei, Fita e elo bokolewomele: “Kamok a! Nu nukalem mesesem eisneng alik alik koleweko, kulo kenggelewkabuluw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Dangei, Yesus e alik alik ilo bokoyemomele: “Ne yulo fein weng mak bokoyemite: Yu nem dulum so, Sunbin-Got em Weng Kal Ken Ati beem dulum so, alew beem ibolow fukunsomi, yukalem am o, kunum aul o, waneng aul o, kauk kumel o, kalew kumel o, aul o, musun o, alik alik biilo koyemeko, nelo nenggelewiw tewe, ");
INSERT INTO bhl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Sunbin-Got e yulo yom kawin dim kale biliw dim kale akati, iti am o, kunum aul o, waneng aul o, kauk kumel o, aul o, musun o, alik alik bi makso makso dukuyemei, i koyemsiliw biim abin kulukoliw te. Kate, mali kawtiw mak i yulo ilum duyemeko, fein yenokoliw te. Kanebiliw tewe, yu sow akati sunsun finik so bin kulokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yu kilelbi boliwka! Mali kame wiin so kebiliw kawtiw i sow em toloke ding dim kabalak e, wiin banim baluw kawtiw kelokoliw kate, kame em ding dim kale, mali wiin banim baluw kebiliw kawtiw i sow ete wiin fian so kawtiw kelokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Beli, Yesus so, akalem gelewkabiliw kunum iso, alik alik bi Selusalem abiw mutuk fian em deiw mitem unbomeliwi, Yesus e emikel kuw emisik unse kale. Unse ding dim bakate, ibik gelew talsiliw kunum waneng i yol angeko, “Kame nomin eisneng mak kaneloke ya?”, angeko, finganin fian kesiliw kate, e akalem kalun kel gelewkabiliw kunum ilo gaayemei, i em mit teliwi, e ilo kuw akalem dim elo kaneloke em sang bokoyemomele: ");
INSERT INTO bhl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Kame, nu Selusalem abiw mutuk fian mitem kalo unuw te. Kalo unesomeluwi, kawtiw i Kawtiw Aul nelo nemdeko, Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum iso, alik alik biim teing dim da konemsomeliwi, i nelo genemsomi, ‘Kanese beem yan be kuanolewka!’, nangokoliw te. Nangiwi, i nelo Isalael kawtiw im ibik ka biliw kawtiw im teing dim da konemiwi, ");
INSERT INTO bhl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","i weng minembomi, kasuk dil dakanembomi, nang debet sok so nen feiw konemeko, neniwi, ne kuanoki te. Kuanii, yemamas kel ding kabalak e, ne iti finik so baba teinoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Beli, Sebidi em muluwel Sekow so, Sion so, aso i Yesus em mit mewso teleko, bokolewomeliw: “Kukuyemin kunum kutaka! Num mesesem mak kulo dakalakam talbuw be ku nulo fein duyema o!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Dangiwi, e aso ilo bokoyemomele: “Nimtew eisneng ete duyemoki a?”, yangei, ");
INSERT INTO bhl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","i yan weng bokolewomeliw: “Kom wiin fian kuluko, abiil tikin bokolew ding dim kabalak e, ku aso nulo akati wiin fian mak dukusomi, kitil duyemeko, mak kom yuk teing dim elo, mak e kom awan teing dim elo ‘Yu teinina!’, yangolewka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Dangiwi, e aso biim yangiw weng be kiliko, yan weng bokoyemomele: “Yukalem dakalakabiliw beem mongom ete yu akokow kebomi, dakalakabiliw te! Kaso yu ki keko, nem kuanomin, betbet ilum kulomin kemi kale neso yuso makuw kuluko, daolokoluw a? Yu kililina! Kaso yu ki keko, im nelo ok da konemok atew kenemeko, betbet fian dunemokoliw be yukati kuluko, daolokoliw a?”, yangeko, dakalase kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Dakalalei, aso bi elo yan weng bokolewomeliw: “No, nu ki keko, daolokoluw te.”, dangiwi, e aso ilo bokoyemomele: “Fein! Kaso yukati kuaneko, betbet ilum kulusomi, nem ok da konemomin atew keko, betbet fian mak kulokoliw kate, ");
INSERT INTO bhl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","nimin kunum waneng ite mak mali kunum waneng ilo bakiyemoke wiin fian mak kuluko, nem yuk teing dim so, awan teing dim so, dim alew kalote teiniw tewe, nakalem ete nam bokoyemi te. Nelo namdase Sunbin-Got ete kuw kitil keko, mali beem dulum elote memen keyembe kunum waneng biilo abin be duyemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yangei, mali king kel gelewkabiliw kunum bi Sekow so, Sion so, aso biim kanesiliw be kili atemeko, aso ilo digaka keyemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Keyemiwi, Yesus e akalem gelewkabiliw kunum biilo gaayemei, i bonggusomeliwi, e ilo bokoyemomele: “Yu kal keliwete: Kawin kaleem emisik kamok so, kak kunum so, alik alik i kawin dim kaleem kukuw geleweko, atul nam kesomi, mali kawtiw im afak kuw ke koyemkabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ke koyemkabiliw kate, yukalem ete kanelom kukuw be gelewokoliw te! Yu kililina! Nimin kunum waneng ite mak ‘Wiin fian so kamok kelum o!’, angiw tewe, i mali kawtiw im sak weng afak kunum waneng keboliwka! ");
INSERT INTO bhl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Feinka! Nimin kunum waneng ite mak ‘Numisik keko, buma!’, angiw tewe, i alik alik im sak weng afak kunum waneng keboliwka! ");
INSERT INTO bhl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nimtew angom? Kawtiw Aul nakati teleko, ‘Mali kawtiw i nelo dokonemina!’, angomi, telinba kesi kasike. Kate, nakalem ete teleko, ‘Kawtiw banban ilo dokoyemeko, biim abin kuluko, kuano! Kuanii, i sunsun finik so bin kuluko, diwkuw diwkuw bokoliw te.’, angomi, telsi te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Beli, Yesus e Seliko abiw mutuk fian elo unse kale. Unesomi, ka belei, em abiw mutuk fian be iti kolewse ding dim bakate, akalem gelewkabiliw kunum so, kawtiw banban iso, alik alik i elo gelewsiliw kale. Im gelewsiliw ding dim bakate, Timeus em min Baltimeus e deiw beleng ka kel teineko, alenale kale. Kunum be kiin sukul so bomelei, e kawtiw ilo tum wiin geeyemale kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Geeyemale ding dim bakate, e mali im weng kililete: “Nasalet abiw kunum Yesus e deiw kalo talbe kai.” angiwi, e kilisomi, gaanin fian kuw mak gaanomele: “Kamok Fian Debit mulkis kutaka! Ku nelo kinkin ibolow kenema o!”, dangeko, gaanse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gaanei, deiw ka unbiliw kawtiw bi em gaanin be kiliko, elo sakalala dangeko, bokolewomeliw: “Bontem net kela!”, dangsiliw kate, e iti weng fian kuw gaanomele: “Kamok Fian Debit em mulkis kutaka! Ku nelo kinkin ibolow kenema o!”, dangeko, gaanin fian beki kuw kese kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kelei, Yesus e moko, “Elo gaaliw kano, e toloka!”, yangei, i em weng kiliko, kiin sukul so kunum beelo bokolewomeliw: “Gatak daok angeko, mola! E kulo gaakembe kasike!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dangiwi, fongate akate kunum be akalem asolow ilim tebil be sak koleweko, fongate akate moko, Yesus em mit mewso yako unse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yako unei, Yesus e elo dakalalomele: “Ku nono ‘Kenemoka!’, angomi, gaanbelew a?”, dangeko, dakalase kale. Dakalalei, e bokolewomele: “Kukuyemin kunum kutaka! Nem kiin kale ken kenemew kano, golo yo!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dangei, Yesus e elo bokolewomele: “Kame kenew kasike, ku una! Kukalem ‘Fein!’, nangbelew ibolow bete kilel kekeme kasike.”, dangse kale. Dangei, fein, fongate akate em kiin e bamtak angeko, kiin golei, e Yesus elo gelewse kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Beli, Yesus so, akalem gelewkabiliw kunum iso, i uneko, Selusalem abiw mutuk fian elo unomin kesomi, Betfage so Betani abiw gel alew kalo talsiliw kale. Aneng be Oliw amgu em mit mewso keko, Selusalem abiw mutuk fian beem mit ka kel kale. Im ka kel bisiliw ding dim bakate, Yesus e akalem gelewkabiliw kunum alew mak ilo yamdeko, ");
INSERT INTO bhl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","bokoyemomele: “Kaso yu abiw fong kalo unoliwka! Uneko, kaso yom abiw kawtem unbiliw ding dim kabalak e, fongate akate, donki samal men mak ka belei, kaso yu atemokoliw te. Donki samal men beem dim e kunum makmak ka teininba kekakawkabe te. Keko beli, kaso yu donki beem sok silelko, elo kuluko, kaleelo debele teloliwka! ");
INSERT INTO bhl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kaso yom elo debele teliw ding dim kabalak e, mak kunum mak kaso yulo dakalaleko, bokoyemomele: ‘kaso yu nono kelewomin kebiliw a?’, yange tewe, kaso yu elo yan weng bokolewomeliw: ‘Aso num Kamok Fian e ‘Elo kulu de telina!’, yangse te. Yangeko, bokolomele: ‘Donki de telesomeleliwi, ne donki beelo fongate akate iti kom teing dim elo dabalaloki te.’, yange kembe kasike, nu kame elo deim tuluw te.’, dangoliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yangei, aso i unesomi, donki be fein atemsiliw kale. I elo am abisom mak em dim mewso deiwkim kel sok gi kolewbiliwi, e belei, aso i elo atemsiliw kale. Atemeko, aso biim sok silelsiliw ding dim bakate, ");
INSERT INTO bhl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mali ka biliw kawtiw mak i aso ilo bokoyemomeliw: “Kaso yu nonoko, donki beelo sok silelewbiliw a?’, yangiwi, ");
INSERT INTO bhl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","aso i Yesus em sua bokoyem kembe weng be ilo duyemsiliw kasike, i “Kenka!”, yangsiliw kale. Yangiwi, fein, aso i donki beelo de unsomi, ");
INSERT INTO bhl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yesus em mit de teleko, ikalem ilim tiaktiak donki beem dim tikolewiwi, Yesus e beem dim ka teinse kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Teineko, unbelei, mali kawtiw banban mak ikati ikalem ilim tiaktiak guluko, deiw duku kemiwi, mali kawtiw mak i ais teing balbil so fakulu dukusomi, abin kon tiko koliwi, ");
INSERT INTO bhl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","donki em dim teinse Yesus beem tikin dim unse kale. Unbelei, emisik unbiliw kawtiw so, ibik talbiliw kawtiw iso, alik alik i makuw kalfongeko, gaanomeliw: “Osana! Weso! Seyo! Sunbin-Got e emisik kamok fian em wiin dim talbe kamok fian beelo bamki fian dulewe tako! ");
INSERT INTO bhl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Sunbin-Got e nukalem awalik kamok fian Debit em kame talbe gawman beelo bamki fian dulewe tako! Osana! Abiil katiw alakabe Sunbin-Got elo “Weso Seyo!”, danguma!”, ange ange kesomi, gaansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Gaansomeliwi, Yesus e Selusalem abiw mutuk fian kawtem uneko, Sunbin-Got em am yol aneng elo uneko, ka kel beem mesesem mesesem eisneng atebam unse kale. Atebam unse ding dim bakate, aneng kuinse kasike, eso, akalem kalun kel gelewkabiliw kunum iso, alik alik i abiw mutuk fian be iti koleweko, Betani abiw kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Beli, aneng daneko, iti kutim kele ding dim bakate, Yesus so, akalem gelewkabiliw kunum iso, alik alik biim iti Betani abiw koleweko, Selusalem abiw mutuk fian kalo unsiliw ding dim bakate, Yesus e yemen tew teinse kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Teinomelei, e atemete: Fik ais sen ais kon banban so mak singam tew kel ka belei, e atemse kale. Atemsomi, “Wanin dem mak be yako?”, angeko, beem mewso uneko, atemete: “Ebe! Atin kuw dem banim! Kon men sel kuw kebe kai!”, angeko, atemse kale. Nimtew angom? Fik ais em dem gilalinba kebe ding kese kasike. ");
INSERT INTO bhl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Keko beli, Yesus e ais beelo yakok weng mak bokolewomele: “Mali kawtiw mak kom dem nam iti wanbiw te!”, dangse kale. Dangei, akalem gelewkabiliw kunum i em dangse weng be fein wosusiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Keko beli, im uneko, Selusalem abiw mutuk fian kawtem talsiliw ding dim bakate, i Sunbin-Got em am yol em aneng ka kel atemiwete: Kunum waneng mak mesesem eisneng mak webiliwi, mali mak i nanew aneng kawtiw im tum win on kisol alwol kelew kelew kebiliwi, i ilo yetemsiliw kale. Yetemsomeliwi, Yesus e kaisuw fian keko, tum win alwol kelew kelew kebiliw kawtiw so, awon webiliw kawtiw iso, alik alik biim duku kebiliw mesesem mesesem eisneng be walelko, dolo dolo koyemeko, kawtiw ka biliw kawtiw alik alik ilo yenbakalei, i kut unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kaneko beli, e mesesem mesesem eisneng de unem tele kebiliw kawtiw ilo bokoyemomele: “Ayem! Yu kanelom kanemokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yangeko, weng mak bokoyemomele: “Sunbin-Got em fut tem kel bokolomele: ‘Nem am kale aneng aneng angom beem biliw kawtiw alikum im Sunbin-Got neso weng bakamin am ete te.’, angse kate, yu ‘am kale yakut kemin kawtiw im yakut am kelewbiliw te!’, angse te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Keko beli, Sunbin-Got em am yol em kunum ayem sel so, em angin bi so, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum bi so, alik alik kunum bi Yesus em awan fingansomi, elo alomin deiw fensiliw kale. Nimtew angom? Kunum waneng banban mak Yesus em kitil so auk so kukuyemkabe weng be kilisomi, em yangbe weng beem dulum elote yol angsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Beli, iti ataan tem unomin kele ding dim bakate, Yesus so, akalem gelewkabiliw kunum iso, alik alik bi abiw mutuk fian be kolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Iti aneng daneko, kutim kese ding dim bakate, alik alik i iti Selusalem abiw mutuk fian elo unsiliw kale. Biim unsiliw ding dim bakate, i Yesus em yakok kelewse fik ais be atemiwete: E atin kuw dem so, ais kon so, teing so, alik alik beso get belei, i atemsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Atemiwi, Fita e Yesus elo bokolewomele: “Kamok Fian a! Atema! Kom yakok kelewselew ais kale kame atin kuw getse kai!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Dangei, Yesus e alik ilo bokoyemomele: “Feinka! Yu Sunbin-Got elo “Fein!”, dangoliwka! ");
INSERT INTO bhl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Dangiw tewe, yu amgu kaleelo bokolewomeliw: ‘Ku kang angeko, okmun fian tem elo mita!’, dangeko, ibolow tulun tulun keminba kesomi, fein ibolow so dangiw tewe, e yom dangbiliw weng be kiliko, fein kaneloke te. ");
INSERT INTO bhl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yu kilele kililina! Yukalem Sunbin-Got eso weng bokoliw ding dim kabalak e, yu fein ibolow keko, dakalaliw tewe, e yom dangiw weng be kiliko, mesesem be fein duyemoke te! ");
INSERT INTO bhl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Kate yu kilelbi boliwka! Yom Sunbin-Got eso weng bakabiliw ding dim bakate, yu mali kawtiw im yulo mesem keyembiliw eisneng beelo ibolow fukuniw tewe, yu im kaneliw eisneng be sak misim kuw kulu koyemoliwka! Koyemiwi, abiil tikin alakabe Kalew bakati yom sili sili kukuw sak misim kuw kulu koyemoke kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Im Selusalem abiw mutuk fian kawtem talsiliw ding dim bakate, Yesus e Sunbin-Got em am yol aneng kel kakabise kale. Kakabomelei, Sunbin-Got em am yol em kunum ayem sel so, em angin bi so, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum bi so, Suda kawtiw im kak kunum iso, alik alik bi teleko, ");
INSERT INTO bhl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","elo bokolewomeliw: “Wee kutaka! Ku kanem wiin dim kanebelew a? Kante kitil dukembe a? Kante ‘Ku aluwa!’, kangei, ku aluwbabelew a?”, dakaleko, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Dangiwi, Yesus e yan weng mak bokoyemomele: “Nakati yulo dakalalika! Yu nem dakalaloki be yan weng bokonemiw tewe, nakati yulo yan weng bokoyemeko, “Kanem wiin dim mesesem be aluwkabi kai!”, yangoki te. ");
INSERT INTO bhl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kame yu kililina! Kawtiw ilo ok da koyemkebe kunum Sion be Sunbin-Got em ibolow fukunin geleweko, kaneyembe sako? Bani, e kawtiw im ibolow fukunin kuw gelewko, kaneyemse sako? Yu nelo yan weng nangina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yangei, i ibolow tiaktiak fukuneko, ikalem mutuk kel bokolomeliw: “Nu elo yan weng keleweko, bokolewomeluw: ‘Sion e Sunbin-Got em ibolow gelewse kai!’, danguw tewe, e nulo dakalalomele: ‘Kate, nimtew angom ete yu Sion em weng bokoyemse weng elo ‘Fein!’, danginba kebiliw a?’, yangoke te. ");
INSERT INTO bhl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kate nu elo bokolewomeluw: ‘E kawtiw im ibolow kuw gelewse kai!’, danguw tewe, nu kunum waneng im awan finganokoluw te. Nimtew angom? Kunum waneng alik alik i ibolow fukunomeliw: ‘Sion e Sunbin-Got em bontem dim bakamin kunum kebise te!’, angakabiliw kasike!”, ange ange kesomi, ");
INSERT INTO bhl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yesus elo dasuw yan weng bokolewomeliw: “Nu dolon kelinba keko, akokow so keluw te!”, dangsiliw kale. Dangiwi, e bokoyemomele: “Kasike nakati yulo kanem wiin dim telii, kante nelo wiin so kunum kenemse weng be nam yangi te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yangesomelei, im am yol ka biliw ding dim bakate, Yesus e alik alik ka biliw kawtiw ilo akalem dulum elote fakam weng mak bokoyemomele: “Musun sen kayak kunum mak e wain musun bilal mak kaise te. Kaisomelei, e wati mak fokosomi, musun be falal amol ke kolewsomi, wain dem kuluko, ok dubelet keleweko, dem emikel ok emikel amen kelewbe kawin mak dikeko, fe e, mali musun atemin kunum mak im am tiak mak gese te. Gesomelei, musun be kunum mali mak elo atebin kunum im teing dim elo koyemsomi, aneng be koleweko, singam aneng mak elo unse te. ");
INSERT INTO bhl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Keko beli, wain em dem gilase ding dim kabalak e, e akalem weng afak kunum mak akalem musun dim elo dabalalei, e teleko, atebin kunum biilo bokoyemomele: ‘Musun beem sen kayak e nelo namdalei, ne wain dem on kisol anung deim telbi te.’, yangse te. ");
INSERT INTO bhl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yangei, atebin kunum i elo kuluko, an feiw kolewsomi, ‘Sak kuw una o!’, dangsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dangiwi, musun sen kayak be akalem weng afak kunum beem kanese sang be kiliko, iti weng afak kunum mak dabalalei, e fein unse te. Unei, i elo kuluko, kak dim an feiw kolewsomi, weng mileweko, wa kuw kelewsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kelewsomeliwi, musun kayak be iti kunum mak dabalalei, e unei, i elo asiliw te. Asomeliwi, Kamok be mali weng afak kunum banban mak yamdalei, i fein unsiliw kate, musun yetebiliw kunum bi mali ilo sak yen feiw koyemsomi, mali ilo yeniwi, i kuansiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Keko beli, musun kayak be akalem weng afak kunum alik alik ilo yemdalei, i unsiliw kate, makmak kunum mak ete kuw eso bise te. Kunum be akalem ibolow fian dulewkabe min bete te. E ibolow fukunomele: “Nakalem kunum aul bakate dabalalii, e unei, i elo atebomi, em afak elo angeko, em weng gelewokoliw te!’, angse kasike, e elo dabalalei, min be fein unse te. ");
INSERT INTO bhl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Unei, musun atebin kunum bi ikalem weng bokolew bokolew kelomeliw: ‘Fein! Kame talaka! Talbe kunum beem alew e kuanei, min besik em abin kuloke te. Kasike, nu elo aluw tewe, nusik wain musun kale atin kuw kululokoluw te!’, ange ange kesiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kesomi, i fein min beelo aliwi, e kuanei, i elo kuluko, musun em sin elo kolewsiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kame, alik alik yu nimtew ibolow fukuniwete: Wain musun sen kayak be nono keyemoke a? Feinka! E teleko, alik alik biilo yenei, i kuanokoliw te. Kuaniwi, wain musun kale, nanew atebin kunum ilo duyemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yangeko, iti akalem dulum elote fakam weng mak bokoyemomele: “Nimtew angom ete Sunbin-Got em fut tem kale bokolomele: ‘Mali kawtiw mak i am gebomeliwi, am kun mak diw atemiwete: ‘Kale beit nam te!’, angeko, kolewsiliw kate, am beem kamok keko, am kayak kunum be am kun be atemete: ‘Am kun ilkul kun kitil te!’, angeko, elo kaiw kun mutuk mo kolewse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Besike, Kamok Fian ete kelewsomelei, kunum waneng nukal atemeko, ‘Yakai! Kitil eisneng kai o!’, angbuluw kasike.’, angse kate, yu fut tem be teing bokolinba kebiliw sako?”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yangei, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum so, Sunbin-Got em am yol em kunum ayem sel so, beem angin iso, alik alik i Yesus em kiskiw weng be kiliko, “Em yangse weng be num dulum em sen ete yange kae!”, angeko, Yesus elo alomin deiw feinsiliw kate, i kunum waneng im awan fingansiliw kale. Fingansiliw kasike, i elo sak koleweko, unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kaneko beli, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum so, Sunbin-Got em am yol em kunum ayem sel so, beem angin iso, kak kunum alik alik bi mali Falisi kunum so, mali emisik kamok fian Kelot em angin iso, mali kunum biilo yemdeko, weng mak bokoyemeliw: “Yu uneko, Yesus elo abil tem dalomin weng mak bokolewoliwka! Kaneliw tewe, nu elo akalem yan weng beem dulum elote gelewemokoluw te!”, yangsiliw kale. Yangiwi, i fein Yesus em mit mewso uneko, ");
INSERT INTO bhl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","elo dakalalomeliw: “Kukuyemin kunum kutaka! Nu kal keluwete: Ku kunum waneng ilo fein weng kuw kukuyemsomi, bakayembelew kunum kute te! Ku kawtiw wiin banim akal, wiin so kunum waneng akal, alik alik kawtiw ilo diwkuw diwkuw fein weng kuw bakayembomelewi, Sunbin-Got em fein deiw kukuyemkakawkabelew kunum kute te. Kasike kame, ku kom ibolow fukunin be nulo bokoyema! Nu Ulom em emisik kamok fian em sawa weng geleweko, elo on kisol anung mak dukalewuw tewe, nu ken kukuw kelokoliw sako? Beni ba? ");
INSERT INTO bhl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ku nulo kilele bokoyema! Nu kisol be ki ke wenokoluw sako? Bani ba?’, kangeko, dakalaluw te.”, dangsiliw kale. Dangiwi, Yesus e ikalem dasuw ibolow fukunin be atemeko, kal kelete: ‘I funum funum kenembiliw kai!’, angse kasike, e ilo bokoyemomele: “Fimdi famde kunum yutaka! Nimtew angom ete yu nelo dasuw kenemeko, kiskis konem kebiliw a? Yu uneko, tum win on kisol mak de teleko, kalenemina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yangei, i uneko, tum win mak de talsiliw kale. De teliwi, Yesus e ilo dakalalomele: “Yu tum win beem kiskiw dukusiliw be atemeko, kanem kiskiw so, wiin so be fut tem boliwi, yu nelo bokonemina!”, yangse kale. Yangei, i yan weng bokolewomeliw: “Ulom em emisik kamok fian etaka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dangiwi, e ilo bokoyemomele: “Kasike, Ulom em emisik kamok fian kebe kamok beelo akalem eisneng be dukalewboliwka! Kate, Sunbin-Got elo akalem eisneng bakati dukalewboliwka!”, yangse kale. Yangei, i em yange weng be kiliko, anggil yol fian kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Beli, ‘Kuansiliw kawtiw i finik so keko, nam teiniw te!’, angbiliw mali Satyusi kawtiw i teleko, Yesus elo funum weng mak bokolewomeliw: ");
INSERT INTO bhl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kukuyemin kunum kutaka! Moses e nulo kukuyemin weng mak bokoyemomele: ‘Kunum mak e aul banim keko, kuanei, kuanse kunum beem awkunum e kalun buum kalun kayak kebe kasike, e ulo kuloka! Kulei, yemkal i aul mak dukuliw tewe, aul be kuanse kunum beem aul keloke te.’, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kame, ku sang mak kilila! Kunum ben kel yangmel mak alenaliw kale. Emisik e waneng mak kuluse kate, aul banim keko, kuanse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kuanei, auk teben e kalun buulo kuluse kate, akati aul banim keko, kuanse kale. Kuanei, yemamas akati iti beemdiw kese kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kelei, ben kel kunum bi alik alik i kalun bu kulusiliw kate, i aul banim keko, kuaniwi, dow so banim kesomi, kuansiliw kale. Fe e, waneng bukati kuansu kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kame, kuankemin kunum waneng im iti yemkalfolokoliw ding dim kabalak e, waneng bu kanem kalel keloku ye? Nimtew angom? Kunum ben kel yangmel alik alik bi ulo kulusiliw kasike.”, dangeko, funum weng dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Dangiwi, Yesus e ilo bokoyemomele: “Ibolow so benesiliw kunum yutaka! Feinka! Yu Sunbin-Got em fut weng bokose kayak e, Sunbin-Got em kitil e, yu atin kuw akokow kebiliw te! ");
INSERT INTO bhl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sunbin-Got em kawtiw ilo yemkalfoloke ding dim kabalak e, kawtiw i nam kunum waneng kule kule keliw te. Nimtew angom? I Sunbin-Got akalem yemdakamin finik atew kelokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yu kilele ibolow fukunina! Yu Sunbin-Got em fut ayem tem be teing bokoko, kilele atemoliwka! Moses esik nulo kukuyemomele: Kunum waneng i kuankabiliw kate, i iti fomkamin dim kel baba teinokoliw te. Nimtew angom? Ais teinbin mak beem weing kainse kate, banim kelinba kele ding dim kabalak e, Sunbin-Got e Moses elo bokolewomele: ‘Ne Abalakam so, Aisak so, Sekow so, yelimel biim Sunbin-Got nete te!’, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yu atin kuw ibolow kau angakabiliw kawtiw yute te! Yu kilele ibolow fukunina! Sunbin-Got e kuansiliw kawtiw im Sunbin-Got bate! Kate, e finik so biliw kunum waneng im Sunbin-Got ete te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yangei, beem ding dim bakate, Sunbin-Got em kukuyemin weng aulewko, kukuyemkabe kunum mak e Satyusi so, Yesus so, biim tekemin weng bokolew bokolew kesiliw be kili yetemeko, “Yesus e ken kiol kuw yan weng bokoyeme kai!”, angse kasike, e elo dakalalomele: “Kukuyemin kunum kutaka! Nalem Sunbin-Got em sawa mak e mali ilo bakileweko, emisik sawa kebe ya?”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Dangei, Yesus e yan weng bokolewomele: “Emisik sawa weng be kanekote: ‘Isalael kunum waneng yu kililina! Sunbin-Got ete Kamokim Fian ete te. Num Kamokim be makmak ete kuw te. ");
INSERT INTO bhl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kukalem Sunbin-Got Kamok Fian elo ibolow mutuk fian dulewboliwka! Kukalem finik e, ibolow e, fukunin e, kitil e alik alik be bongguko, Sunbin-Got em dim kuw fewtoko, kolew bolewka!’ ");
INSERT INTO bhl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Sawa mak e kaleem atin kuw fian beemdiw te. ‘Kukalem ibolow mutuk fian e kukalem dim bikembe beemdiw, yom mewso biliw kawtiw mali ikati ibolow mutuk fian kukuyem kemolewka!’ Feinka! Alew sawa beemdiw makso mak banim te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dangei, Sunbin-Got em kukuyemin weng aulewko, kukuyemkabe kunum be yan weng bokolewomele: “Kukuyemin kunum kutaka! Ku ken weng kuw bokolew te! Feinka! Makmak Sunbin-Got ete kuw te. Nanew Sunbin-Got akal banim te. ");
INSERT INTO bhl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Keko beli, nu Sunbin-Got beelo ibolow mutuk fian dulewboluwka! Nukalem finik e, ibolow fukunin e, kitil e alik alik be bongguko, Sunbin-Got em dim kuw fewtokoko, kolewboluwka! Bomeluwi, nu mali kawtiw ilo akal ibolow mutuk fian kukuyem kemoluwka! Kanebe kukuw be, Sunbin-Got em am yol dim mesesem eisneng aik ayem dim dukuko, elo dulewko, ‘Weso! Seyo!’, angakabuluw kukuw be atin kuw bakilewkabe te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Dangei, Yesus e em dangse weng be kiliko, “Ibolow tem kal so weng mak dukunembe kai!”, angeko, bokolewomele: “Mewso kuw ku Sunbin-Got em gawman dim be atemeko, kalo fein unokolew te!”, dangse kale. Dangei, mali kawtiw alik alik bi fingansomi, elo dakalamin makso mak dakalalinba kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Beli, Yesus e Sunbin-Got em am yol em aneng kawtem ka biliw kunum waneng ilo kukuyemeko, bokoyemomele: “Nimtew angom ete Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum i bokolomeliw: ‘Mesaya e sua kel alenale emisik kamok fian Debit em mulkis ete te!’, angbiliw a? ");
INSERT INTO bhl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Debit akalem ete Sunbin-Finik so gekeko, bokolomele: ‘Sunbin-Got Kamok Fian e nem Kamok Fian elo bokolewomele: ‘Ku nem yuk teing kitil so dim kel teineko, ding fensomelewi, ne kom maka ilo yemdalii, i teleko, atin kuw kom kitil afak kel teinokoliw te.’, nangse kai!’, angse kale. Kame, yu ibolow fukuniwete: Nimtew angom ete e angse weng be bokose ya? ");
INSERT INTO bhl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Feinka! Sim Fut tem kale kel, kunum mongom Debit e Mesaya elo ‘Nem Kamok Fian’, dangse kasike, Mesaya esik nimtew angom ete ‘Debit em mulkis te!’, dangbiliw a?”, yangse kale. Yangei, ka biliw kawtiw banban i Yesus em kukuyemse weng be kiliko, wosulomin kuw kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Beli, Yesus e ka biliw kawtiw ilo bokoyemomele: “Yu kilelbi boliwka! Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum i ilim ken ati kuw minggiko, kawtiw im wensankabiliw dim elo uneko, mali im kiin dim kakabomeliw kasike, i ilo yetemeko, ‘Yu biliw yako!’, yangbomeliwi, i beem mongom ete ikalem ibolow kuw kekabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Keko beli, i nukalem wensankabuluw am kawtem uneko, emisik tein kekabiliw abin kuluomin ibolow kekabiliw te. Beemdiw, wanin dawol ding dim e, i teleko, emisik kunum em tein kemin dim kel teinkabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","I mali kalun waneng biim dulum elo ‘Im mesesem mesesem eisneng be kuluyemumo!’, angeko, dasuw keyemsomi, ilo kal ilum fian sel duyemkabiliw te. Feinka! I kal dim ete kuw Sunbin-Got eso diwkuw diwkuw bokolewkabiliw te. Yu kililina! Sunbin-Got em diwyemoke ding dim e, kukuw wa wa so kunum bi kal ilum fian mak kulokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yangeko, beem ding dim bakate, Yesus e Sunbin-Got em am yol em tum win on kisol dukukabiliw dim beem dim mewso teineko, ka biliw kawtiw im on kisol dulewbabiliw be kiin doung keyemse kale. Kiin doung keyemsomelei, em so kawtiw banban i on kisol banso dukukebiliwi, e yetemse kale. ");
INSERT INTO bhl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Yetemeko, beem ding dim bakate, em banim waneng kalun mak tum win fong gel alew kuw de teleko, dukukebiliw tem ka kel dukusu kale. Tum win fong gel em fufu e feni kom alew emdiw ete te. ");
INSERT INTO bhl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dukului, Yesus e akalem gelewkabiliw kunum biilo gaayemei, i teliwi, e ilo bokoyemomele: “Feinka! Em banim waneng kalun bu tum win gelgel kuw dukulu kate, u on kisol so kawtiw im tum win fian kuw dukuliw kawtiw biilo atin kuw bakiyemkabu te. ");
INSERT INTO bhl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nimtew angom? Em so kawtiw bi on kisol banso aluwbiliw kate, anung gel makuw kuse kabalak da kembiliw te. Kate, em banim waneng kalun bu mesesem banim kesomi, ukalem tum win fong gel be alikum kuse kabalak dalu kasike.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Beli, Yesus em Sunbin-Got em am yol aneng be iti koleweko, unse ding dim bakate, akalem gelewkabiliw kunum mak e Yesus elo bokolewomele: “Kukuyemin kunum kutaka! Ku am yol gesiliw kunum im tum fian sesel kulusiliw tum so, tum am gesiliw fian sesel so, alik alik be kilele atemolewka!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Dangei, e bokolewomele: “Ku kilila! Deiw mak ding mak telei, maka mak teleko, atite eisneng be tum ati so mak em tikin dim, mak em tikin dim banimeko, alik alik dakaleko, mit da kolewokoliw te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Dangei, eso, akalem gelewkabiliw kunum iso, i abiw mutuk fian be iti koleweko, Oliw amgu tikin kalo uneko, ka kel teinsomeliwi, am yol aneng be miyak ka belei, i atemsiliw kale. Kaneko beli, Fita so, Sekow so, Sion so, Andulu so, ketket teben kel kunum ite kuw Yesus em mit mewso uneko, elo dakalalomeliw: ");
INSERT INTO bhl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kukuyemin kunum kutaka! Nalem ding ete, yangew ilum beem toloke ding dim be kaneloke ye? Nomin eisneng ete kuw nu atemsomi, kal keluwete: ‘Maka im teleko, abiw mutuk fian kale so, am yol be so, alik alik beem banimoke ding dim be, bakale kai!’, angokoluw a? Kame nulo bokoyemolewka!”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dangiwi, e yan weng bokoyemomele: “Wee! Yukal kilelbi boliwka! Mali dasuw kunum banso ikal teleko, ");
INSERT INTO bhl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","nem wiin dim yulo dasuw weng bakayem tolokoliw te. I bokoyemomeliw: ‘Nete yom ding fenbiliw kunum nete te!’, yangomeliwi, kunum waneng banban i biim dasuw yangokoliw weng be kiliko, ilo fein yenggelewokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Beli, yu kenen weng kililiwete: ‘Aneng fian mali iso aneng fian mali iso ganen ganenkakabiliw kai!’, ange ange keko, yulo bokoyemiwi, yu kililokoliw kate, yu kanelom ganbin beem dulum be finganemokoliw te! Nimtew angom? Kanele ilum eisneng be emisik toloke kate, fefe ding be ibik ete kuw keko, toloke kasike. ");
INSERT INTO bhl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Feinka! Mali aneng kasel isik uneko, nanew kasel iso ganen unokoliw te. Uneko, mali kasel im kamok isik uneko, mali im kamok iso ganen unokoliw te. Uneko, kawin kale akati bim fian kuw fi atuk atuk kemei, aneng aneng mali mak olfut fian keloke te. Alik alik ilum eisneng be deiw busule kasike, kal ilum fian fian makso ibik ete toloke te. ");
INSERT INTO bhl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Keko beli, yu kilelbi boliwka! Mali kawtiw mak teleko, yulo yauleko, wa kukuw keyemomi, Isalael kasel num diwyemin kunum im kiin dim mo koyemeko, num wensan kekabiliw am kalo nang debet sok so yen feiw koyemokoliw te. Yu nelo ‘Fein!’, nangbiliw kawtiw kebiliw kasike, i yulo yemde uneko, yulo aneng aneng im atebiliw kak kunum so, emisik kamok fian so, alik alik biim kiin dim mo koyemokoliw te. Koyemiwi, yu ka bomi, yukalem fein ibolow akal ilo kukuyem kelokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yu nem weng kale kilele kililina! Mali yu aneng aneng angom biliw Isalael kawtiw num deng ka biliw kawtiw alik alik im mit mewso uneko, Sunbin-Got em Weng Kal Ken Ati be ilo bakayem tem bakayem tem keboliwka! ");
INSERT INTO bhl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Keko beli, yu kanelom im yulo geeyemokoliw beem angan finganeko, ‘Nono keko, yan weng bokoyemokoluw yake!’, angeko, ibolow fukunin tiaktiak kemokoliw te! Bate! Nimtew angom? Yulo geeyemiw ding dim bakate, yukati ki keko, kilele yan weng mak bokoyemokoliw kasike. Nimtew angom? Sunbin-Finik e yom ilo yan weng bokoyemokoliw weng be kilele fitew dim kuw dako, kukuyemei, yu weng be kiol kuw bokoyemokoliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Beem ding dim kabalak e, yukalem kaim atuk akate yulo yemdeko, yulo maka im teing dim da koyemiwi, i yulo yeniwi, yu fein kuanokoliw te. Keko beli, kalew kumel i ikalem muluwel yulo maka im teing dim da koyemiwi, i yulo yenokoliw te. Beemdiw, yukalem muluwel ikal sakalaw keko, weng bo bo kebomi, alew kumel yulo maka im teing dim da koyemiwi, i yulo yenokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yu nem angin kebiliw kasike, beem ding dim kabalak e, kawtiw alik alik i yulo ibolow kaisuw fian kaim alel yetemokoliw te. Kate yu kililina! Nimin kunum waneng ite mak fein nangebiliw ibolow kolinba kesomi, fefe ding keloke ding kabalak e, kitil keko, moliw tewe, kanekabiliw kunum waneng bite sun kuw sun kuw bin finik so kuluko, bokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yangeko, iti weng mak so bokoyemomele: “Yu nem yangbi weng kale kilele kiliko, kal keloliwka! Mali kawtiw mak teleko, Sunbin-Got em akalem wiin so amkose dim beelo sakok keko, ka kel kaing wasan mian wasan teng so eisneng inkal so mak akatetew dukuliwi, yu atemokoliw te. (Fut kale teing bokoko, atebiliw kawtiw yu kanelom ibolow kau angbokoliw te!) Beem ding dim bakate, Sudia aneng kasel biliw kawtiw yu fongate akate fon uneko, amgu tikin elo fon unoliwka! ");
INSERT INTO bhl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Beemdiw, mali am yu dim teinbiliw kunum waneng ikati kanelom am kawtem uneko, am kawtem beem mesesem mak kulam unokoliw te! Bayo! ");
INSERT INTO bhl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Beemdiw, mali wanin musun dim aluwbabiliw kunum waneng ikati kanelom iti am uneko, asolow ilim mak kulokoliw te! Babo! Alik alik yu fongate akte kuw fon unoliwka! ");
INSERT INTO bhl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Beem ding dim kabalak e, Isalael aneng kale biliw kasel yu ilum fian mak kulokoliw kasike, waneng aul kumun biliw so, aul beliw non yemgibiliw waneng iso, alik alik waneng bi kilelbi boliwka! I ki keko, nam fongate akate fon unokoliw kasike, i kal ilum fian fian mak kulokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Beem mongom ete yu Sunbin-Got elo bokolewomeliw: ‘Suuk so aneng wa dim ete kaneko eisneng be kanelom tolome yo!’, dangeko, kitil kuw bakalewboliwka! ");
INSERT INTO bhl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sunbin-Got em kawin dim kale kilke dukuse ding kabalak koleweko, ilum fian beem kaneloke ding dim elo uneko, diwkuw diwkuw kaneloke ilum fian fian mak beemdiw kanelinba keloke te. Kelei, ibik elote akati mesesem ilum beemdiw nam iti kaneloke te. ");
INSERT INTO bhl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Keko beli, Sunbin-Got e akalem wiin so amkoko, koyembe angin im ibolow elo fukunomele: ‘Ilum fian beem ding e tiak kele tewe, kunum waneng alik alik bi sak banimokoliw kai!’, angbe kasike, e kal ilum keyemoke ding beelo sukum goto kelewoke te. ");
INSERT INTO bhl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Beem ding dim bakate, mali kawtiw mak yulo bokoyemomeliw: ‘Mesaya e bakalete! Bakalete!’, yangokoliw kate, yu kanelom im weng be kiliko, gelewbokoliw te! Itel bate! ");
INSERT INTO bhl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nimtew angom? Mali dasuw selew selew kawtiw mak kanelokoliw kasike. I yulo dasuw weng bokoyemomeliw: ‘Ne Mesaya nete te!’, yangbomi, kitil so auk so eisneng banban mak kelokoliw te. Kesomi, fein ibolow so kunum waneng im dulum elote ‘Nu kitil keko, im fein ibolow be de mit da koyemuma!’, angomi, kitil keko, ma ke ma ke keyemokoliw kate, Sunbin-Got e akalem wiin so galmose kunum waneng im ibolow fukunbe kasike, i ki keko, ilo ibolow teifululinba kebokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yu kuteko, boliwka! Fein kaneloke eisneng be ne yulo kame kuw bokoyemsi te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yangsomi, iti weng mak bokoyemomele: “Beem kal anggil ilum fian teleko, iti unoke ding dim kabalak e, fongate akate ‘ataan takak em ailbe be daking kuanoke te. Kayow akati ailinba kelei, ");
INSERT INTO bhl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","fial akal abiil tikin katem koleweko, fitulu atin mit mit kemei, abiil katem em kitil keko, aulbe eisneng be beit keko, fi atuk atuk keloke te.’ ");
INSERT INTO bhl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Keloke ding dim bakate, Kawtiw Aul ne kitil so auk so Kamok Fian kesomi, yukam dim moko, abiil tikin elote telii, yu nelo netemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Beem ding dim bakate, Kawtiw Aul ne Sunbin-Got em yemdakamin finik ilo abiil fe kawin fe kalo yamdalii, i uneko, nimin kunum waneng ite mak nakalem wiin so galmoko, koyembi kunum waneng alik alik biilo bongguko, alul mutuk makmak da koyembokoliw te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yangeko, Yesus e fakam weng mak bokoyemomele: “Seil gilalomin ding dim e, awon bolokbolok e gaaneme tewe, yu kal keliwete: Kame seil gilalomin ding keme kai!’, angakabiliw te. ");
INSERT INTO bhl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kaneko beli, beemdiw, kaneloke finganin fian eisneng be kanele tewe, yukal kal keliwete: ‘Nem toloki ding dim e, kame mewso kele te! E abisom dim kel mole kai!’, angboliwka! ");
INSERT INTO bhl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Feinka! Mali beem kaneloke ding dim daso biliw kawtiw mak kuaninba kun so kal so biliw akate, ‘Kaneloke!’, yangbi eisneng alik alik be fein keloke te. ");
INSERT INTO bhl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Feinka! Abiil so kawin so banimoke kate, nem weng bokoyemsi weng kale nam banimoke kate, fein sunsun kuw boke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yangeko, iti weng makso bokoyemomele: “Nem toloki ding dim e, mali kawtiw mak ‘Beem kayow ding ete te.’, ‘Beem itol ding ete te.’, nam angiw te. Abiil tikin kel alakabiliw Sunbin-Got em yemdakamin finik so, Min nakalem so, alik nukati akokow so kebuluw te. Nem Aatim akalem ete kuw nem toloki ding e kilele kal kebe te. ");
INSERT INTO bhl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yu kilelbiko bomeliwi, ding fen boliwka! Nem toloki ding dim akal, ataan kak ding akal, alik alik be yu akokow so kebiliw kasike! ");
INSERT INTO bhl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yu nem fakam weng kale kililna! Kamok kunum mak singam aneng mak elo unomin memen kese kale. Kesomi, akalem weng afak kunum ilo gaayemei, i teliwi, e akalem mesesem mesesem eisneng alik alik be im teing dim elo dukuko, ‘Yu atenembina!, yangomi, duyemse kale. Duyemeko, am abisom beem atebe kunum elo ‘Kilele atebolewka!’, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Beemdiw, yukal kilelsiko, kiin kiin dako, ateboliwka! Nimtew angom? Yukalem kamok em tolomin ding e yu akokow so kebiliw kasike. Mesik e kuinbele yako, kutiliw mutuk yako, kelfakabe yako, ataan silili ange ding yako, ");
INSERT INTO bhl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","fongate akate teleko, yu akalbiliwi, e yulo yetemoke kasike. ");
INSERT INTO bhl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yu kilelbi boliwka! Weng kale ne yulo bokoyemi kate, kunum waneng alik alik im gomet elo angbi kasike. Alik yu kilele kuteboliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Beem ding dim bakate, Isalael kawtiw im belet wanin fasulinba wanakabiliw em kukuw gelewkabiliw ding so, Abanggayemse Ding em fukunkabiliw ding so, alew ding beem mewso kele ding kese kale. Beem ding dim bakate, Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, Sunbin-Got em kukuyemin weng kalem aulewko, kukuyemkabiliw kunum iso, i “Yesus elo aluma!”, angeko, elo aluweko, net kelomin yawal deiw fensiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nimtew angom? I bokolomeliw: “Nu elo Abanggayemse Ding bakate kaim dim kel aluw tewe, kunum waneng i nulo yetemsomeliwi, nu im ibolow yemkalfolyemuwi, i weng ane ane kebomi, ganokoliw te!”, angsiliw kasike. ");
INSERT INTO bhl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Beli, Yesus e Betani abiw fong gel ka uneko, Saimon em am ka bise kale. Sua e, Saimon be bulul abung fian so keko, alenale kunum ete kale. Wanin wansiliw ding dim mak kabalak e, waneng mak Yesus em mit mewso teleko, on kisol so tum kaisiliw ok sen kamge unbe eisneng so mak de teleko, ok sen be kang kelewko, Yesus em kak dim ka buseleko, abolewsu kale. Sua e, waneng bu tum win fian fian mak kuluko, kamge so eisneng be wesu kate kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kaneko beli, mali ka biliw kunum waneng bi gal keumeko, digaka keumsomi, bokolomeliw: “Nimtew angom ete waneng kalu on kisol kulomin eisneng be tutu kelebu ya? ");
INSERT INTO bhl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kamge eisneng kale dabalasomi, wensomeluwi, tum win fian fian mak kuluko, em banim kawtiw ilo duyemeko, ilo dokoyemomin kis kate!”, ange ange kesomi, waneng buulo sakalala wangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Keko beli, Yesus e ilo bokoyemomele: “Yu ulo koumina! Nimtew angom ete yu waneng kaluulo ilum dukaumbiliw a? Usik nelo ken ati eisneng mak kenembu kale eli! ");
INSERT INTO bhl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Em banim kawtiw i diwkuw diwkuw yuso bomeliwi, yu yom ibolow geleweko, ilo ken kukuw kukuyem kemokoliw kate, ne nam diwkuw diwkuw yuso bi te. ");
INSERT INTO bhl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Waneng kalu fom kal dim kel kamge eisneng so kabiyemkabiliw kukuw geleweko, kamge eisneng be kuluko, nelo memen kenembu kasike, nem kuanoki ding dim kabalak e, i ki keko, nelo sak fomkamin dim elo da konemokoliw te. ");
INSERT INTO bhl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yu kililina! Kunum waneng i uneko, Sunbin-Got em Weng Kal Ken Ati kale bakayem tem bakayem tem unokoliw aneng aneng angom alik alik ka e, kawtiw alik alik i um kanenemsu kukuw kale kiliko, ibolow fukunokoliw te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Beli, Yesus em kalun kel gelewkabiliw kunum biim mutuk e kunum mak em wiin e Sudas ete kale. E Iskaliot abiw kunum ke alenale kale. Beem ding dim bakate, Sudas e Sunbin-Got em am yol em kunum ayem sel so, akalem angin iso, alik alik biim mit mewso uneko, “Yesus elo yom teing dim daloki te!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yangeko, i em yangse weng beem dulum kalfongsomi, “Tum win mali mak kulo dukemokoluw te!”, dangsiliw kasike, e Yesus deeko, im teing dim dalomin deiw fense kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Beli, Belet wanin fasulinba wanakabiliw Ding em emisik ding dim bakate, Isalael kawtiw i ikalem kukuw geleweko, Abanggayemse Ding em siwsiw men asiliw kale. Beem ding bakate, Yesus em gelewkabiliw kunum i elo bokolewomeliw: “Kamok kutaka! Ku nulo bokoyema! Nu nalo uneko, Abanggayemse Ding wanin wanomin memen kelokoluw a?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dangiwi, e akalem gelewkabiliw kunum alew mak ilo bokoyemomele: “Kaso yu uneko, Selusalem abiw mutuk fian kawtem unoliwka! Kawtem uneko, ok sen king ti unbe kunum mak atemokoliw te. Atemeko, elo anggeleweko, em am unbe kalo yukati eso makuw unoliwka! ");
INSERT INTO bhl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Unesomi, am kayak beelo bokolewomeliw: ‘Num kukuyemin kunum e kulo dakalalomele: ‘Nakalem angin iso wanin wanoki em abin mak e nal kel a?’, kange kai!’, dangoliwka! ");
INSERT INTO bhl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dangiwi, e kaso yulo tikin so min so am beem memen kelewse tikin abin fian be kukuyemoke te. Kukuyemei, kaso yu ka kel wanin wanomin em mesesem mesesem eisneng be memen keloliwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yangei, aso i abiw mutuk fian kalo uniwi, Yesus em yange weng be dem gilase kasike, i wanomin em mesesem mesesem eisneng alik alik be memen kesiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kesomeliwi, ataan tem dokong ange ding dim bakate, Yesus so, akalem kalun kel gelewkabiliw kunum iso, alik alik i am ka kel abin dim dak teinsomi, wanin wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wansomeliwi, e bokoyemomele: “Yu kililina! Nukalem wanin wanbuluw mutuk kale kate, mak kunum mak nelo maka im teing dim da konemoke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yangei, i ibolow tiaktiak kesomi, ikalem dakalale dakalale kebomi, elo dakalako, bokolewomeliw: “Nem dulum elo nangbelew sako?”, dangsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Dangiwi, Yesus e yan weng bokoyemomele: “Kalun kel kunum yom mutuk dim neso teing deeko, aso nu makuw belet wanin kuluw kunum bete nelo maka im teing dim da konemoke te. ");
INSERT INTO bhl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sunbin-Got e akalem fut ayem tem kel ‘Kaneloke te!’, angse kasike, kawtiw i beem angse emdiw keko, Kawtiw Aul nelo kenemokoliw kate, nelo namdeko, maka im teing dim daloke kunum beem dulum elote kal ilum fian inkalso mak fitewoke te. Fitewoke kasike, e bokolomele: ‘Ibo ibo! Nimtew angom ete yem u nelo namkusu yake!’, angeko, oloke te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yangei, wanin wansiliw ding dim bakate, Yesus e belet wanin kuluko, Sunbin-Got elo “Weso! Seyo!”, dangesomi, fakal fakal kelewko, akalem gelewkabiliw kunum ilo duyemsomi, bokoyemomele: “Kale nakalem kal em kiskiw te. Yu kuluko, wanina!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yangeko, e wain ok sen akati kuluko, Sunbin-Got elo “Weso! Seyo!”, dangesomi, ilo duyemei, alik alik i fein wansiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Waniwi, e bokoyemomele: “Wain ok kale ‘Kawtiw banban yom dulum elo nakalem kaim buseleko, kuanoki te!’, angbi kitakamin weng beem kiskiw ete te. ");
INSERT INTO bhl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yu nem weng kale kililina! Ne wain ok makso waninba keloki kate, deiw mak ding mak, Sunbin-Got em gawman ding dim kabalak e, ne iti wain ok wanboki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yangesomelei, alik alik i Sunbin-Got elo sim kutilewsomi, abiw mutuk fian ka koleweko, Oliw amgu tikin kalo unsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Unsomi, Yesus e akalem gelewkabiliw kunum biilo bokoyemomele: “Kanesom e, alik yu nem dulum elote ibolow bangbang kenemeko, nelo fein konemokoliw te. Nimtew angom? Sunbin-Got em fut ayem tem bokolomele: ‘Ne siwsiw yetebin kunum alii, siwsiw angom alik alik i bayemeleko, alik alik i fon unokoliw te.’, angse kasike. ");
INSERT INTO bhl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nem kuaneko, iti baba teinoki ding dim kabalak e, nemisik Galili aneng kalo unii, yu nem ibik elote tololiwka!”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yangei, Fita e yan weng mak bokolewomele: “Kamok kutaka! Alik alik i finganeko, kokemokoliw kate, nakalem ete kuw nam kokemi te!”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dangei, Yesus e yan weng bokolewomele: “Ku kilele kilila! Mesik kutiliw kabalak em kakaluk awon mak alew ding gaainba selei, ku alemsal ding keko, bokolomelew: ‘Ne Yesus elo akokow kebi te!’, angokolew te.”, dangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Dangei, Fita e kitil weng mak bokolewomele: “Babo! Nete kuw kuso fang kelokoluw kate, kom wiin e nam wokiw da kokemi te.”, dangse kale. Dangei, Yesus em gelewkabiliw kunum alik alik bikati dangse weng bete ki weng kuw bokolewsiliw kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Beli, Yesus so, akalem gelewkabiliw kunum iso, alik alik i makuw Getsemani Oliw bol elo unesomeliwi, e ilo bokoyemomele: “Yu kale kel teinoliwka! Nakalem ete uneko, Sunbin-Got eso weng bakam unoki te.”, yangse kale. ");
INSERT INTO bhl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yangesom