﻿USE sofia;
DROP TABLE IF EXISTS sofia.bhi_vpl;
CREATE TABLE bhi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bhi_vpl WRITE;
INSERT INTO bhi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","अब्‌राहमेन अवल्‌यात दावुदेन अवल्‌यात, ने ईसु मसीन खानदानी असी छे। ");
INSERT INTO bhi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्‌राहम सी इसाक पयदा हयु, इसाक सी याकुप पयदा हयु, याकुप सी यहुदा ने तेरा भायस पयदा हया। ");
INSERT INTO bhi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","अळतेन यहुदा ने तामार सी फीरीस ने जेरह पयदा हया, फीरीस सी हेसर्‌यान पयदा हयु, ने हेसर्‌यान सी एराम, ");
INSERT INTO bhi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","अळतेन एराम सी अम्‌मीनादाब पयदा हयु, अम्‌मीनादाब सी नहसोन, ने नहसोन सी सलमन पयदा हयु। ");
INSERT INTO bhi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सलमन ने राहाब सी बोआज पयदा हयु। बोआज ने रुत सी ओबेद पयदा हयु, ने ओबेद सी यीसे पयदा हयु। ");
INSERT INTO bhi_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ने यीसे सी दावुद राजु पयदा हयु। दावुद सी सुलेमान पयदा हयु जी पेहेल उरीय्‌याहन घरवाळी हतली। ");
INSERT INTO bhi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सुलेमान सी रहबाम पयदा हयु, ने रहबाम सी अबीय्‌याह पयदा हयु ने अळतेन अबीय्‌याह सी आसा पयदा हयु। ");
INSERT INTO bhi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","आसा सी यहोसाफात पयदा हयु, यहोसाफात सी योराम पयदा हयु, ने योराम सी उज्‌जीयाह पयदा हयु। ");
INSERT INTO bhi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्‌जीयाह सी योताम पयदा हयु, योताम सी आहाज पयदा हयु, आहाज सी हीजकीय्‌याह पयदा हयु। ");
INSERT INTO bhi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हीजकीय्‌याह सी मनस्‌‌सीह पयदा हयु, मनस्‌‌सीह सी आमन पयदा हयु, ने आमन सी योसीय्‌याह पयदा हयु, ");
INSERT INTO bhi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ने ईस्‌रायली जातीन माणसे काजे धरीन बेबीलोन ईलाका मां जाणेन टेमे, योसीय्‌याह सी यकुन्‌याह ने तेरु सगु भायस पयदा हया। ");
INSERT INTO bhi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ने ईस्‌रायली जातीन माणसे काजे धरीन बेबीलोन जाणेन पछेन यकुन्‌याह सी सालतीयेल पयदा हयु, ने सालतीयेल सी जरुबाबील पयदा हयु, ");
INSERT INTO bhi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","जरुबाबील सी अबीहुद पयदा हयु, अबीहुद सी ईल्‌याकीम पयदा हयु, ने ईल्‌याकीम सी अजोर पयदा हयु, ");
INSERT INTO bhi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अजोर सी सदोक पयदा हयु, सदोक सी अखीम पयदा हयु, ने अखीम सी ईलीहुद पयदा हयु, ");
INSERT INTO bhi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ईलीहुद सी ईलीयाजर पयदा हयु, ईलीयाजर सी मतान पयदा हयु, ने मतान सी याकुप पयदा हयु, ");
INSERT INTO bhi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","याकुप सी युसुफ पयदा हयु, चु मरीयमेन अदमी हतलु, ने मरीयम सी ईसु पयदा हयु चु मसी कहवाये। ");
INSERT INTO bhi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","एरेन तसी अब्‌राहम सी दावुद लग चवदा पीड़ी हवी, ने दावुद सी बेबीलोन ईलाका मां धराय जाणेन टेमे लग चवदा पीड़ी हवी, ने बेबीलोन ईलाका मां धरायन ली जाती रया तत्‌यार तीनी टेम सी लीन मसी लग चोवदा पीड़ी हवी। ");
INSERT INTO bhi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ईसु मसी असु पयदा हयु की तत्‌यार तेरी माय मरीयमेन मांगणी युसुफ साते हय गुयली, ने तींद्‌रे भेळा हवणेन सी पेहलुत चुखली-आत्‌मा सी भारीस हतली। ");
INSERT INTO bhi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","तत्‌यार तेरु अदमी युसुफ चु धरमी हतलु, ने तीनी काजे नाव-बद्‌दी करने नी चाहतेलु, तीनीक कळेत छुड़नेन वीच्‌यार करने बाजी गुयलु। ");
INSERT INTO bhi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","जत्‌यार चु हीनी वातेन वीच्‌यार मां पड़ रवलु ती मालीक भगवानेन सरग वाळु काहवाळ्‌यु तीना काजे सपनाम देखायन कह्‌वणे लाग्‌यु, “ए युसुफ! दावुदेन अवल्‌यात, तु बायर मरीयम काजे तारेन चां लावणे सी मां बीहे, काहाकी ज तेरा पेट मां छे, च चुखली-आत्‌मान भीणी सी छे। ");
INSERT INTO bhi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","तेरु एक पुर्‌यु हवसे ने तु हेरो नाव ईसु पाड़जी, काहाकी हयु आखा माणसेन तींद्‌रा पाप सी छुटकारु आपसे।” ");
INSERT INTO bhi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ज आखो असो करीन हयो की ज बुल मालीक भगवानेन अघी सी आवणे वाळी वात देखान्‌यान साहरे कह्‌लो, च पुरो हवे, ");
INSERT INTO bhi_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“देखु, एक कुवारली पुरे भारीस हवसे, ने तेरु एक पुर्‌यु पयदा हवसे, ने हेरो नाव ईम्‌मानुएल पाड़जी,” तेरो मतलब छे “भगवानुत हामरे पुठ्‌ये छे।” ");
INSERT INTO bhi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","तत्‌यार युसुफ नीद मां सी जागीन मालीक सरग वाळा काहवाळ्‌यान हुकुम सामळीन तेरी बायर काजे ली आयु, ");
INSERT INTO bhi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ने जत्‌यार लग पुर्‌यु पयदा नी हयु तत्‌यार लग युसुफ तेरे धड़े नी गुयु, ने चु तेरो नाव ईसु पाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","जत्‌यार हेरोदेसेन राजान राज चाल रह्‌लो, तीनुत दाहड़ा मां यहुदीया जीलान बेतलहम गांव मां ईसु पयदा हयु, ती उगेवणा सी तारा देखीन रासी देखण्‌या यरुसलेम सहर मां आया। ");
INSERT INTO bhi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ने पुछ्‌या की, “यहुदी माणसेन पुर्‌यु राजु पयदा हयु, चु कां छे? काहाकी हामु उपर उगवणु सी तारु उंगलु देख्‌या तेरेमां हामु पुछ रया ने तीना काजे हामु पांये पड़ीन आंधणे आवला छे।” ");
INSERT INTO bhi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","जत्‌यार हेरोदेस राजु जी वात सामळीन घाबराय गुयु, ने तेरे पुठ्‌ये यरुसलेम सहर मां रहणे वाळा बी आखा घाबराय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","तेरेमां हेरोदेस राजु आखा मुख्‌या पुजारा ने यहुदी नीयम सीकाड़न्‌‌या मास्‌तर्‌याक भेळा करीन तीनुक पुछ्‌यु, “की मसी कां पयदा हवसे?” ");
INSERT INTO bhi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","चे कह्‌या की “यहुदीया जीलान बेतलहम सहर मां हवसे, काहाकी भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या माणसेन साहरे असो लिखलो छे। ");
INSERT INTO bhi_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ए बेतलहम सहर, तु यहुदीया देस वाळा, काहना बी मटला सहर नानु नी हय, काहाकी तारे सीत एक असलु राज करन्‌यु पयदा हवसे, चु मारा ईस्‌रायेली जातीन माणसेन गुवाळी करसे।” ");
INSERT INTO bhi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","तत्‌यार हेरोदेस राजु तारा देखीन रासी देखण्‌याक कळेन बुलायन तीनुक पुछ्‌यु की तारु तुहुंक काहनी टेमे देखाव पड़लु, ");
INSERT INTO bhi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","अळतेन चु असो कय्‌न तीनुक बेतलहम सहर मां मकल्‌यु, “जावु, तीना पुर्‌यान बारामां पतु करु, ने जत्‌यार जड़ जाय तत्‌यार मेसे खबर करु काहाकी मे बी आवीन तेरा पाये पड़ीस।” ");
INSERT INTO bhi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ने चे राजान वात काजे मानीन चाल पड़्‌या, ने तीना तारा काजे चे उंगतेलु देखला चु तारु बी तींद्‌रे अगळ-अगळ चाल पड़्‌यु, ने चां पुर्‌यु हतलु, तीनी जागा पर जाय्‌न चु तारु उबु रय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ने तीना तारा काजे देखीन चे बेसका खुस हय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","चे तीना घर मां जाय्‌न तीना पुर्‌या काजे हेरी माय मरीयम साते देख्‌या, ने उबडा पड़ीन पुर्‌या काजे आंध्‌या, ने आपणा-आपणा थयलाम सी तीना काजे सनो, लुभान, ने मंहगलो ईत्‌तर भेट चड़ाया। ");
INSERT INTO bhi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","बाकुन भगवान सी सपना मां असी खबर जड़ी की, हेरोदेस धड़े पछा घुण जावु, तत्‌यार चे दीसरे वाट्‌ये सी आपसान देस मां पछा जाती रया। ");
INSERT INTO bhi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","अळतेन चे तारा देखीन रासी देखण्‌या चां सी जाती रया ने पछेन मालीक भगवानेन सरग वाळु काहवाळ्‌यु सपना मां ईसुन बास युसुफ काजे देखायन कह्‌यु, “उठ, ईना पुर्‌या काजे ने हेरी माय काजे लीन मीसर देस मां जाती रव; ने जत्‌यार लग मे तुसे नी कहं, तत्‌यार लग चांहान रवजी; काहाकी हेरोदेस ईना पुर्‌या काजे माराड़ने करीन हेरसे।” ");
INSERT INTO bhi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","तत्‌यार युसुफ उठीन पुर्‌याक ने हेरी माय काजे रातेत लीन मीसर देस मां जाणे करीन चाल पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ने हेरोदेस मरने लग चांहान रयु। काहाकी ज बुल मालीक भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या माणसेन साहरे कह्‌लो छे, चो पुरो हवे की, “मे मारा पुर्‌या काजे मीसर देस सी बाहर बुलायु।” ");
INSERT INTO bhi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","जत्‌यार हेरोदेस राजा काजे असु पतु चाल्‌यु की, तारा देखीन रासी देखण्‌या मारे सी धुकु कर्‌या, तत्‌यार चु रीस सी भराय गुयु, ने आपसा माणसे काजे मकल्‌यु जसा रासी देखाड़न्‌या जी टेम देखाड़ला तीनी टेमेन अनसारे बेतलहम ने तेरे आड़े-धड़े वाळा आखा जे दुय सालेन ने तींद्‌रे सी नानला पुर्‌या हतला तीनु काजे माराड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","तत्‌यार ज बुल मालीक भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या माणसेन यीर्‌मयाहन साहरे कह्‌लो हतलो, चो पुरो हय गुयो। ");
INSERT INTO bhi_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामा सहर मां सी एक दया आवे तसी अवाज सामळाय, ने रड़नेन ने बेसका कलपणेन बी अवाज सामळाय; राहेल तेरा पुर्‌या वाटे रड़तेली, ने हुगी राखे तेबी हुगी नी रवतेली, काहाकी तेरा आखा पुर्‌या मर गुयला।” ");
INSERT INTO bhi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ने जत्‌यार हेरोदेस राजु मर गुयु, तत्‌यार मालीकेन सरग वाळु काहवाळ्‌यु मीसर देस मां युसुफ काजे सपना मां देखायन कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“उठ, पुर्‌याक ने तेरी माय काजे लीन ईस्‌रायेल देस मां पछु जाती रव, काहाकी चे ईना पुर्‌या काजे मारने हींडी रवला, चे मर गुया।” ");
INSERT INTO bhi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","तत्‌यार युसुफ सुयन उठ्‌यु, ने पुर्‌याक ने तेरी माय काजे लीन ईस्‌रायेल देस मां पछु जाणे करीन चाल पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","बाकुन युसुफ असु सामळ्‌यु की अखीलु तेरा बास हेरोदेस राजान आवजी पर यहुदीया पर राज कर र्‌यु, तेरेमां चां जाणे सी बीही गुयु। ने तत्‌यारुत सपना मां भगवानेन हुकुम सामळीन गलील जीला मां जाती र्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ने नासरत नावेन सहर मां जाय्‌न वसी ज्‌य, काहाकी च बुल पुरो हवे, ज भगवानेन बुल मालीक भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या माणसेन साहरे कह्‌लो हतलो की: “ईसु नासरी कह्‌वाय्‌से।” ");
INSERT INTO bhi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","तीनु दाहड़ा मां युहन्‌ना बपतीस्‌मा आपणे वाळु आवीन यहुदीयान बयड़ा मां असु परचार करने बाजी गुयु, ");
INSERT INTO bhi_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“पाप भीणी सी मन फीराय्‌न भगवान भीणी वळु, काहाकी सरगेन राज धड़ेत आय लागलो छे!” ");
INSERT INTO bhi_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","जु युहन्‌‌‌नु हयुत छे तेरे बारामां भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या माणुस यसायु माणुस कहलु की, “बयड़ा मां एक आयड़ने वाळान आवाज सामळाय रय, की मालीकेन वाट काजे तीयार करु, ने तेर वाटे सयड़क काजे सुदी करु।” ");
INSERT INTO bhi_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","चु युहन्‌‌‌नु उटड़ान कान्‌‌यान पुथल्‌यो पेहरी रवलु, ने चामड़ान पट्‌टु कमर मां बांदी रवलु। तेरो खाणो टिड्‌डा ने बयड़ा मायन मुहाळ हतलो। ");
INSERT INTO bhi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","तत्‌यार यरुसलेम सहर वाळा ने आखा यहुदीया जीला, ने यरदन नदीन आड़े-धड़ेन वाळा बेसका माणसे तेरे धड़े आया। ");
INSERT INTO bhi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","चे आपणा-आपणा पाप काजे मानीन भगवान भीणी वळता जाय्‌न यरदन नदी मां युहन्‌ना सी बपतीस्‌मा लेदा। ");
INSERT INTO bhi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","जत्‌यार युहन्‌ना बेसका फरीसी माणसे ने सदुकी माणसे काजे बपतीस्‌मा लेणे करीन तेरे धड़े आवतेला देख्‌यु, ती तीनुक कह्‌यु, “ए घड़सान पीला, तुहुंक कुण बताड़ देदो की आवणे वाळी रीस सी ढासु? ");
INSERT INTO bhi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ने कदी तुहुं पाप भीणी सी मन फेरवु ती तसा वारु फळ बी लावसु, ");
INSERT INTO bhi_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ने आपणा-आपणा मन मां असा वीच्‌यार बी मां करु की हामु हामरा आड़ा-बुड़ान डाहलु बास अब्‌राहमेन अवल्‌यात छे; मे तुंद्‌रे सी कहं की, भगवान हीनु दगड़ा सी बी अब्‌राहम वाटे अवल्‌यात पयदा कराड़ सके। ");
INSERT INTO bhi_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ने झाड़कान मुळ्‌या पर कुरहाड़ मेकली छे, काहाकी जो झाड़को वारलु फळ नी लावे, तीना काजे काटीन आकठा मां नाख देसे। ");
INSERT INTO bhi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","मे ते पाणी सी तुहुं काजे मन फेरवणेन बपतीस्‌मा देदलु छे, बाकुन जु मारे पछळ आवणे वाळु छे, चु मारे सी बी मटु छे, मे तेरा खासड़ा हाकलने लायक बी नी हय, चु तुहुंक चुखली-आत्‌मा ने आकठा सी बपतीस्‌मा देसे। ");
INSERT INTO bhi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","तेरो सुपड़ो तेरा हात मां छे, ने ईसु तेरा खळा मायन कचराळा दाणा काजे वारु वाहळा मां उडाड़ीन चुखाळसे, ने तेरा गहुं काजे ते कणगी मां भेळु करसे, बाकुन चारा काजे जलम नी उल्‌हायें तीना आकठा मां नाख देसे।” ");
INSERT INTO bhi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","तीनी टेमे ईसु गलील जीलाम सी चालीन यरदन नदी मां युहन्‌ना धड़े बपतीस्‌मा लेणे आयु, ");
INSERT INTO bhi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","बाकुन युहन्‌‌‌नु असु कय्‌न ईसु काजे रुकणे बाजी गुयु, “मेसेक ते तारा हात सी बपतीस्‌मा लेणेन जरुवत छे, ने तु मारे धड़े काहा आयु र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","बाकुन ईसु तीना काजे असु जपाप आप्‌यु, “हय ते असोत हवणी दे, काहाकी हामु ईनीत रीते आखा वारलु काम माणसे काजे पुरो करनु जी भगवानेन मरजी छे।” तत्‌यार चु तेरी वात काजे मान लेदु। ");
INSERT INTO bhi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ने तत्‌यार ईसु बपतीस्‌मा ली लेदु। ने जसु पाणीम सी बाहर नीकळ्‌यु, तत्‌यार सरग खुल गुयो। ने हयु भगवानेन आत्‌मा काजे पेरवान तसु उतरतेलु ने तेरे उपर आवतेलु देख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ने तत्‌यारुत, उपर सरग सी असी अवाज आवी की, “जु मारु लाटेक्‌लु पुर्‌यु छे। हेरेसी मे बेसकु खुस छे।” ");
INSERT INTO bhi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","तत्‌यार ईसु बपतीस्‌मा ली लेदु, ने अळतेन भगवानेन आत्‌मा ईसु काजे बयड़ा मां लीन गुय काहाकी भुतड़ा सी हेरी पारख हय सके। ");
INSERT INTO bhi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ईसु चालीस दाहड़ा, ने चालीस रात, लग उपास रयु, तत्‌यार तीना काजे भुक लागी। ");
INSERT INTO bhi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","तत्‌यार पारखणे वाळु भुतड़ु तेरे धड़े आवीन तीना काजे असु कह्‌यु, “कदी तु भगवानेन पुर्‌यु हय, ती कय दे, की जे दगड़ा रुटा बण जाय।” ");
INSERT INTO bhi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","बाकुन ईसु भुतड़ाक जपाप आप्‌यु की, “खरला सास्‌तुर मां लिखलो छे, माणुस नीस्‌तु रुटा खाय्‌न नी जीवे, बाकुन हरेक तीना बुल सी जीवे जो भगवानेन मुंहडाम सी नीकळे।” ");
INSERT INTO bhi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","तत्‌यार भुतड़ु तीनाक यरुसलेम सहर मां लीन गुयु, चो सहर चुखलो कह्‌वाये, ने चां मंदीरेन मुंडेरी पर उबु कर्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ने भुतड़ु ईसु काजे असु कह्‌यु, कदी तु भगवानेन पुर्‌यु हय, ती हया सी नेचु कुद जां; काहाकी खरला सास्‌तुर मां लिखलो छे की, भगवान मालीक आपसा सरग वाळा काहवाळ्‌या काजे हुकुम, आपसे ने चे तुसेक उपरुत झेल लेसे, “काहाकी तारे पाये दगड़ान ठेसु लग नी लागणे देय।” ");
INSERT INTO bhi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ईसु तीना काजे कह्‌यु, “सास्‌तुर मां असो बी लिखलो छे की, ‘तु आपसा मालीक भगवान काजे घुण पारखे।’” ");
INSERT INTO bhi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","पछेन भुतड़ु ईसु काजे एक मटला बयड़ा पर ली गुयु, ने तीनाक कळीन आखा राजे ने तेरो सींगार देखाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ने ईसु काजे असु कह्‌यु, “कदी तु मेसेक पाये पड़ीन आंधसी, ती जो काय तु हय देख्‌यु चो आखो मे तुसेक आप दीस।” ");
INSERT INTO bhi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","तत्‌यार ईसु भुतड़ा काजे कह्‌यु, “ए भुतड़ा, छेटे हय जां, काहाकी खरला सास्‌तुर मां लिखलो छे, ‘तु आपसा मालीक भगवानेन पाये पड़ीन आंध्‌या कर, ने तेरीत सेवा चाकरी कर।’” ");
INSERT INTO bhi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","अळतेन भुतड़ु ईसु काजे छुड़ीन जाती रयु, ने भगवानेन सरग वाळा काहवाळ्‌या आवीन तेरी सेवा चाकरी करता रया। ");
INSERT INTO bhi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","जत्‌यार ईसु ज सामळ्‌यु की युहन्‌ना काजे जेल मां कुंड देदा, ती चु गलील जीला मां जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ने चु नासरत सहर मां नी रयु, ने नासरत सहर छुड़ीन कफरनहुम सहर मां रहणे बाजी गुयु, जबुलुन ने नप्‌ताली देस मां छे, चां जाय्‌न रहणे बाजी गुयु; ");
INSERT INTO bhi_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","असो तेरेमां हयो की भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या माणुस यसायान साहरे लिखलो हतलो, चो पुरो हयो। ");
INSERT INTO bhi_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“जबुलुन ने नप्‌तालीन देस दरीयान वाटे पर, ने यरदन नदीन बुडेवणा मां, ने नी-यहुदी माणसे गलील। ");
INSERT INTO bhi_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ने जे माणसे आंदारला मां जीवतेला, चे माणसे मटला वीजाळाक देख्‌या; ने जे मोतेन साहळान देस मां जीवतेला तींद्‌रे पर बेसको मटो वीजाळो पड़्‌यो।” ");
INSERT INTO bhi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","तीनी टेमे सी ईसु असु परचार करने बाजी गुयु की, “पाप भीणी सी मन फेरवु, काहाकी भगवानेन राज तुंद्‌रे धड़े आय लागलो छे।” ");
INSERT INTO bhi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","जत्‌यार ईसु गलील दरीया धड़े मायन जाणे बाजी रवलु, तत्‌यार ईसु तीनु दुय संगा भायस काजे देख्‌यु, सीमोन काजे चु पतरस बी कहवाये, ने अळी तेरु भायस अन्‌दीरीयास काजे दरीया मां जाळ नाखतेला देख्‌यु; काहाकी चे काहर्‌या हतला। ");
INSERT INTO bhi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ईसु तीनुक कह्‌यु, “मारा चेला बणीन मार पछळ आवु, ने जसा तुहुं माछा धरीन भेळा करु तसात तुहुंक मे माणसेक भेळा करने ने तीनुक मारा चेला बणावणे सीकाड़ीस।” ");
INSERT INTO bhi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ने चे तत्‌यारुत जाळ काजे चांहान रहणीदीन ईसुन चेला बणीन ईसु पछळ चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","चां सी अगु जाय्‌न, ईसु अळी दीसरा दुय भायस काजे देख्‌यु, जब्‌दीन पुर्‌यु याकुप काजे ने अळी याकुपेन संगा भायस युहन्‌ना काजे। चे तींद्‌रा बास जब्‌दी पुठ्‌ये ढंड्‌या मां जाळ काजे सुदारतेला। ईसु तीनुक बुलायु। ");
INSERT INTO bhi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","चे तत्‌यारुत ढंड्‌याक ने तेरा बास काजे चांहान रहणीदीन ईसुन चेला बणीन ईसु पछळ चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ईसु आखा गलील जीला मां हींडतु-फीरतु यहुदी माणसेन भक्‌तीन घर-घरमां सीकाड़तु रयु, ने अळी भगवानेन राजेन खुस-खबर परचार करतु रयु। ने माणसे काजे आखी भाती-भातीन मांदवाड़ ने लुल्‌गाय सी वारु करतु रयु। ");
INSERT INTO bhi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ने ईसुन आखा सीरीया देस मां खबर फेल गुय; तेरेमां चे माणसे जी भाती-भातीन मांदवाड़ ने दुख मां पड़ला हतला, ने तीनु माणसे मां भुतड़ान आत्‌मा लागली हतली, ने अळी फेफराळा ने लखवु लागला माणसे काजे ईसु धड़े लावतेला ने ईसु तीनु काजे वारु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","तेरेमां गलील जीलाम सी, दस सहरेन परदेस दीकापुलीस, यरुसलेम, आखा यहुदीया जीला सी ने यरदन नदीन पार वाळा बेसका माणसेन टुळा की टुळा ईसु पछळ-पछळ आवतेला। ");
INSERT INTO bhi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ईसु बेसका माणसेन टुळा काजे आवतेला देखीन बयड़ा पर चहड़ी गुयु, ने जत्‌यार ईसु चां बठी गुयु ती तेरा चेला बी तेरे धड़े आय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","तत्‌यार ईसु तीनु माणसे काजे सीकाड़तु जाय्‌न कह्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“जे आपसा जीव-आत्‌मा मां गरीब छे चे बरकतवाळा छे।” काहाकी सरगेन राज तींद्‌रोत छे! ");
INSERT INTO bhi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“जे दुखी हय्‌न कलपे, चे बरकतवाळा छे; काहाकी तीनुक सांती जड़से।” ");
INSERT INTO bhi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“जे भुळा-भाळा छे; चे बरकतवाळा छे; काहाकी चे धरतीन हकदार बणसे।” ");
INSERT INTO bhi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“वारला काम वाटे जे भुकला ने तीसला छे चे बरकतवाळा छे; काहाकी भगवान तीनुक खावड़ाय्‌न नीरसा कर देसे।” ");
INSERT INTO bhi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“जे दयाळा छे, चे बरकतवाळा छे; काहाकी भगवान तींद्‌रे पर दया करसे।” ");
INSERT INTO bhi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“जे मन मां चुखला छे, चे बरकतवाळा छे; काहाकी चे भगवान काजे देखसे।” ");
INSERT INTO bhi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“जे मेळ कराड़ने वाळा छे, चे बरकतवाळा छे! काहाकी चे भगवानेन पुर्‌या-पारी कह्‌वाय्‌से।” ");
INSERT INTO bhi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","जे वारलु काम करने सी दुख झेले, चे बरकतवाळा छे; काहाकी चे सरग वाळा भगवान पुठ्‌ये राज करसे! ");
INSERT INTO bhi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","तुहुं बरकतवाळा छे, जत्‌यार माणसे मार पछळ चालने सी तुंद्‌री नाव-बद्‌दी करे, ने अळी एला पाड़े ने लुच्‌चाय मेली-मेलीन तुंद्‌रा बारामां गलत वात करे। ");
INSERT INTO bhi_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","तत्‌यार तुहुं खुस रवजु, काहाकी तुंद्‌रे वाटे सरगे मां बेसको मटो ईनाम जड़से। जी वात तसीत छे जसी की तुंद्‌रे सी पेहलेन भगवानेन अघली वात बताड़न्‌या काजे बी चे माणसे लग एला पाड़तेला। ");
INSERT INTO bhi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","तुहुं धरतीन माणसेन नण छे; बाकुन कदी नणुत मुळो हय जाय, ती पछेन तीनाक काय सी खारो करसु? ने चो काहना बी काम मां नी रहे, बाकुन तेरो अतरोत काम मां आवे की बाहर उराट देसे। ने माणसेन पाय तळे रंदळाये। ");
INSERT INTO bhi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","तुहुं कळीन माणसे वाटे वीजाळान तसा छे, ने चो साताय नी सके। जसों काहनोक सहर उचा बयड़ा पर वसलो रहे, तसात तुहुं बी रवजु। ");
INSERT INTO bhi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","माणसे दिवु धपाड़ीन चवकी तळे नी मेके, बाकुन दीवाळ्‌या पर मेके, चां सी चु दिवु, तीना आखा घरन्‌याक वीजाळो आपे। ");
INSERT INTO bhi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","तेरेन तसोत तुंद्‌रो वीजाळो माणसे पर चमके, काहाकी चे तुंद्‌रा वारलु कामेक देखे, ने जु तुंद्‌रु भगवान बास सरगे मां छे, चे बी तीना बासेन बड़ाय करसे। ");
INSERT INTO bhi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","तुहुं असा मां समजु की, हयु ईसु भगवानेन नेम कायदाक ने भगवानेन अघली वात बताड़न्‌यान किताप काजे रद करने आयु, मे रद करने नी आयु, बाकुन पुरो करने आवलु छे। ");
INSERT INTO bhi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","मे तुहुंक छाचलीन कह्‌वो की सरग ने धरती टळी जासे, बाकुन मुसान लिखलु कायदान एक नानुस आकड़ु ने एकेक टीपको बी पुरो हवे पाखुर नी टळे। ");
INSERT INTO bhi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","तेरेमां जे काय ईनी नानली सी नानली हुकुम मां सी कह्‌ली एक काजे बी तुड़से, ने तसुत माणसे काजे बी सीकाड़े, ने आखा सी नानलु कह्‌वाय्‌से; बाकुन जे काहनाक ईनी वातेक मानीन चालसे ने दीसराक बी तीनु वात पर चालने करीन सीकाड़से, ती हयु सरगेन राज मां मट्‌लु कह्‌वाय्‌से। ");
INSERT INTO bhi_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","मे तुंद्‌रे सी छाचलीन कह्‌वो की कदी तुंद्‌रो वारलु काम यहुदी नीयम सीकाड़न्‌या मास्‌तर्‌या ने फरीसी माणसेन धरमेन काम सी बड़ीन नी रवे, ती तुहुं सरगेन राज मां कदी नी भराय सकु। ");
INSERT INTO bhi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","तुहुं ते सामळी रया, की पेहला माणसे सी कह्‌ली वात हतली की, खुन घुण करु ने जु काहनुक खुन करसे चु जेल मां डंड भुकत्‌से। ");
INSERT INTO bhi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","बाकुन मे तुहुंक असु कहं की, जे काहनाक आपसा भायस पर रीस करसे, चे जेल मां डंड भुकत्‌से, ने जे काहनाक आपसा भायस काजे नाव-बद्‌दी करे, चु मटला पंचु अगळ डंड भुकत्‌से, ने जे काहनाक आपसा भायस काजे असा कहें की ए डेड़-अकल्‌या ती चु नरकेन आकठा मां डंड भुकत्‌से। ");
INSERT INTO bhi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","हेरेसी कदी तु वेदी पर आपसी बादा चड़ावणे लाय रयु हय, ने चां सी तुसेक जी हेर आवे, की, मारु भायस, मार पर नराज हय रयु, ");
INSERT INTO bhi_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ती तु आपसी बादा काजे वेदी अगळुत रहणीदीन, पेहेल तारा भायस सी मेळ कर ले, ने अळतेन आय्‌न तारी बादा चड़ावजी। ");
INSERT INTO bhi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","तारु वेरी तुसे कुरुट-कचेवरी मां ली जाणे बाजी रवे, ने चु तत्‌यार वाटेत मां रवे, ती तु छाटुस जाय्‌न तेरे सी वात सार लेजी, नीते असो नी हय जाय की चु तुसे नीयाव करन्‌या सीपायड़ान हातेम सुप देय, ने सीपायड़ा तुसेक जेल मां कुंड देय। ");
INSERT INTO bhi_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","मे तुसेक छाचलीन कह्‌वो, की जत्‌यार लग एकेक टकु भरी नी देय, तत्‌यार लग तुसेक जेल मां सी नी नीकळाये। ");
INSERT INTO bhi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“तुहुं ज बी सामळी रया, की छीनाळो घुण करु।” ");
INSERT INTO bhi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","बाकुन मे तुंद्‌रे सी असु कहं की, जु काहनुक काहनीक बायरी पर छीनाळो करनेन गलत नींगा नाखे, चु आपसा मन मां छीनाळो कर लेदुलु छे। ");
INSERT INTO bhi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","कदी तारु जेवड़्‌यु डुळु उत्‌तर बणीन तुसेक पाप कराड़े, ती तीनाक नीकाळीन नाख दे; काहाकी तारे वाटे ज वारु छे की, तारा डील मां सी एक अंग नास हय जाय ने तारु आखु डील नरक आकठाम सी बचणु तार वाटे वारु छे। ");
INSERT INTO bhi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ने कदी तारु जेवड़्‌यु हात तुसेक पाप कराड़े, ती तीनाक काटीन उराट दे; काहाकी तारे वाटे ज्‌य वारु छे की तारा डील मां सी एक अंग नास हय जाय ने तारु आखु डील नरक आकठाम सी बचणु तार वाटे वारु छे। ");
INSERT INTO bhi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“असो बी कह्‌लो हतलो, जु काहनुक आपसी लाडी काजे छुड़ने हींडे, ती तीनीक छुड़नेन चिट्‌ठी लिखीन आप देणु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","बाकुन मे तुहुंक असु कहं की, जु काहनुक आपसी लाडीक छीनाळान वात छुड़ीन दीसरी वजे सी छुड़ देय, ती चु तीनीक छीनाळो कराड़े ने जु कुय तीनी छांडायली बायर काजे बणावे, चु बी छीनाळो करे। ");
INSERT INTO bhi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“अळी तुहुं पेहला माणसेक कहली वातेक सामेळला हतला, की झुटी सगुन घुण खाजु, बाकुन भगवान मालीक अगळ खादली सगुन काजे पुरी करजु।” ");
INSERT INTO bhi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","बाकुन मे तुहुंक कह्‌वो की, तुहुं कदी सगुन खावु घुण; काहाकी सरग, भगवानेन राजगादी छे; ");
INSERT INTO bhi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ने नी धरतीन, काहाकी ची तेरा पायेन चवकी छे; नीते यरुसलेम, तीना भगवानेन सहर छे, चु राजान राजु छे। ");
INSERT INTO bhi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ने आपणा मुणकान एक बी सगुन घुण खावु; काहाकी तु एक कान्‌याक बी नी धवळा ने नी काळ्‌ळा कर सके। ");
INSERT INTO bhi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ने तुंद्‌री वात “हव” हय ती “हव” कवजु ने “नी” हय ती “नी” कवजु, काहाकी ज काय एरे सी अदुस कहें, चो कुहर्‌या भुतड़ाम सी उब्‌जे। ");
INSERT INTO bhi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“तुहुं पेहला माणसेक कहली वातेक सामळ्‌ळा हतला की, ‘डुळान बदले डुळु, ने दातेन बदले दात।’” ");
INSERT INTO bhi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","बाकुन मे तुहुंक असु कहं की कुहराय करन्‌या माणसे सी बदलु घुण लेवु; बाकुन जु काहनाक तारे जेवड़े गाल पर थापड़ देय, तेरे भीणी दीसरु गाल बी फेरवी देजु। ");
INSERT INTO bhi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","कदी काहनुक तारे पर कुरुट मां तारीक लड़ीन तारो कुरतो मांगणे हींडे, ती तीनाक तु चादरु बी आप देजी। ");
INSERT INTO bhi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","जु काहनाक तुसेक एक कुस असलुत चालाड़ीन ली जाय, ती तींद्‌रे साते दुय कुस चालीन जात रव। ");
INSERT INTO bhi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","जु काहनुक तुंद्‌रे धड़े मांगे, ती तीनाक तुहुं आप देजु; ने जु काहनुक तार सी उधार मांगे, ती तीनाक नी आपतु करीन मां कहुं। ");
INSERT INTO bhi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“तुहुं पेहला माणसेन कहली वातेक सामळ्‌ळा हतला, की ‘आपणे धड़े वाळा सी परम करजु, ने आपणा वेरी सी कुहराय राख्‌जु।’” ");
INSERT INTO bhi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","बाकुन मे तुहुंक असु कहं की आपणा वेरी सी परम करु। ने जु काहनुक एला पाड़े तींद्‌रे वाटे दुवा करु, ");
INSERT INTO bhi_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ती तुहुं सरग मां रहणे वाळा बासेन पुर्‌या-पारी बणसु, काहाकी चु कुहराय ने भलाय करन्‌या दुयु भातीन माणसे पर दाहड़ु उंगाड़े, ने पापी ने धरमी दुयु भातीन माणसे पर पाणी पाड़े। ");
INSERT INTO bhi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","कदी तुहुं आपणा परम राखणेवाळा सी परम करु, ती तुहुंक काय फळ नी जड़े, काहाकी असा ते फाळु लेणे वाळा सरकारी आफसर बी करतेला। ");
INSERT INTO bhi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“कदी तुहुं आपणा भायस काजे अतरात वारलु छे की करीन पुछ रया, ती तुहुं काहनो असो मटो काम कर रया? असा ते नी-यहुदी माणसे बी करे जे भगवान काजे नी माने।” ");
INSERT INTO bhi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","तेरेमां तुहुं पुरा-पुरा पाक्‌का बणु, जसु तुंद्‌रु सरग वाळु भगवान बास पुरु-पुरु पाक्‌कु छे। ");
INSERT INTO bhi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“चेतीन रहु! तुहुं माणसे काजे देखाड़ने वाटे आपणा वारु काम मां करु, नी ते आपणा सरग वाळा बास सी काय बी फळ नी जड़से।” ");
INSERT INTO bhi_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","तेरेमां जत्‌यार तु दान करे, ती आपणे अगळ फेप्‌यो मां वाजाड़े, काहाकी भक्‌तीन घर मां ढंगड़ा असात करे, चे ते गळ्‌ये ने दीसरा माणसे सी बड़ाय चाहे। मे तुहुंक छाचलीन कहं, तीनुक हींद्‌री बड़ायन फळ पेहलुत जड़ गुयो। ");
INSERT INTO bhi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","बाकुन जत्‌यार तु दान करु, ती जु तारु जेवड़्‌यु हात अगु करे, तीना काजे तारु डाखर्‌यु हात नी जाणनु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","तुंद्‌रो धरम करलो काम सातायलो रवसे ती, तुंद्‌रा सातायला धरमेन कामेक देखण्‌यु भगवान बास तुहुंक ईनाम आपसे। ");
INSERT INTO bhi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","जत्‌यार तु दुवा करे, ती ढंगड़ा करन्‌या माणसेन तसा घुण करु, काहाकी माणसे काजे देखाड़ने वाटे भक्‌तीन घर मां ने सयड़केन मुड़ मां उबा रय्‌न दुवा करनु, तीनु काजे वारु लागे। मे तुंद्‌रे सी छाचलीन कहं की चे हींद्‌रा कामेन फळ ली लेदा। ");
INSERT INTO bhi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","बाकुन जत्‌यार तुहुं दुवा करु, ती आपणा घरेन कपरा मां जाय्‌न; बारनो दीन आपणा भगवान बास सी दुवा करजु। ती सातायली वात देखण्‌यु तुंद्‌रु भगवान बास तुहुंक ईनाम आपसे। ");
INSERT INTO bhi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","दुवा करनी वेळाय नी-यहुदी माणसेन तसा बक-बक घुण करु, काहाकी चे समजे की हींद्‌रे अदुस बुलने सी हींद्‌री सामळी लेसे। ");
INSERT INTO bhi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","तेरेमां तुहुं हींद्‌रेन तसा मां बणु, काहाकी तुंद्‌रु बास तुंद्‌रे मांगणे सी पेहलुत जाणे की तुहुंक काहनी चीजेन जरुवत छे। ");
INSERT INTO bhi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","तेरेमां तुहुं असा दुवा कर्‌या करु की: ए हामरा सरग वाळा भगवान बास, तु जु सरगे मां छे: तारो नाव चुखलो मानायणु चाहजे; ");
INSERT INTO bhi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","तारो राज आवे तारी मरजी जसी सरग मां पुरी हवे, तसीत ईनी धरती पर बी पुरी हवे। ");
INSERT INTO bhi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","दाहड़ीन हामुक चाहजे ततरोत खाणो आप्‌या कर। ");
INSERT INTO bhi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ने जसा हामु हामरा गुना वाळा काजे माफ कर्‌या, तसुत तु बी हामरा गुना काजे माफ कर। ");
INSERT INTO bhi_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ने हामुक पारख मां घुण पाड़े, बाकुन कुहराय सी बचाड़; काहाकी राज ने ताकत ने सेक-सींगार जलम तारीत छे। आमीन। ");
INSERT INTO bhi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","तेरेमां कदी तुहुं माणसेन गुना माफ करसु, ती तुंद्‌रु सरग वाळु भगवान बास बी तुहुंक माफ करसे। ");
INSERT INTO bhi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ने कदी तुहुं माणसेन गुना माफ नी करु, ती तुंद्‌रु सरग वाळु बास बी तुहुंक माफ नी करे। ");
INSERT INTO bhi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","जत्‌यार तुहुं उपास करु, ती ढंगड़ा करन्‌या माणसेन तसा तुंद्‌रा मुंहडा पर नुरपाणी नी उतार्‌नु चाहजे, ने चे हींद्‌रा मुंहडा लागाड़ रवे, काहाकी माणसे तीनुक उपास छे करीन जाणे। मे तुहुंक छाचलीन कहं की चे हींद्‌रो फळ ली लेदला छे। ");
INSERT INTO bhi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","बाकुन जत्‌यार तुहुं उपास करु ती, आपणा मुणका पर तेल लागाड़ीन मुंहडो धुवजु, ");
INSERT INTO bhi_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","असा उपास करु ती, माणसेक मालुम नी पड़े, बाकुन भगवान बास काजे मालुम पड़से जी सातायली वात जाणे चु तुहुंक ईनाम आपसे। ");
INSERT INTO bhi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","आपणे वाटे धरती पर धन भेळो मां करु, जाहां वेधु खाय जाय ने कीटी लाग जाय, ने चां चुट्‌टा धाड़ु पाड़ीन ली जाती रवे। ");
INSERT INTO bhi_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","बाकुन आपणे वाटे सरग मां धन भेळो करु, चां नीते वेधु खासे, ने नी कीटी लागे ने नी चुट्‌टा धाड़ु पाड़ीन चुरी करे। ");
INSERT INTO bhi_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","काहाकी चां तुंद्‌रो धन छे, चां तुंद्‌रो मन बी रवसे। ");
INSERT INTO bhi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","डीलेन दिवु डुळु छे। तेरेमां कदी तारु डुळु वारु छे, ती तारो आखो डील बी वीजाळा मां रवसे! ");
INSERT INTO bhi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","बाकुन कदी तारु डुळु भुंडु छे, ती तारो आखो डील बी आंदारला मां रवसे; तेरे वजे सी चो वीजाळो तारे मां छे, कदी आंदारलो छे, ती चो आंदारलो कतरो मटो हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","कुय माणसे दुय मालीकेन चाकरी नी कराये, काहाकी चु एक मालीक सी कुहराय ने दीसरा सी परम सी रवे, नीते एक मालीक साते हेळी-मेळीन रवसे ने दीसरा मालीक काजे भुंडोत जाणसे। तुहुंक भगवानेन ने धन-दोवलतेन दुयुन चाकरी नी कराये। ");
INSERT INTO bhi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","तेरेमां मे तुंद्‌रे सी कहं, की आपणा जीवेन वाटे जी फीकुर मां करु की हामु काय खासुन ने काय पीसुन; ने आपणा डीले पर काय पेहरसुन। ने काय जीव खाणा ने डील ने पुथल्‌या सी महंगो नी हय? ");
INSERT INTO bhi_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","सरग वाळा चिरला काजे देखु! चे नीते वेरे, नीते काटे, ने नी खळा मां भेळो करे; तेबी तुंद्‌रु सरगेन बास तीनुक खावाड़े। काय तुहुं चिरला सी बेसका महंगा नी हय? ");
INSERT INTO bhi_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","तुंद्‌रे मां असु कुण छे, चु फीकुर करीन आपणी उमर काजे बड़ाय सके? कुय नी। ");
INSERT INTO bhi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ती हामरे धड़े पुथल्‌या नी हय करीन फीकुर काहा कर रया? तुहुं खेतेन फुलेक देखीन वीच्‌यार ते करु, चे कसाक अदे! ने चे तींद्‌रे वाटे मेहनत बी नी करे, ने तींद्‌रे वाटे दुरा काटीन पुथल्‌या बी नी बणावे। ");
INSERT INTO bhi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","तेबी मे तुंद्‌रे सी कहं की सुलेमान राजु बी, बेसकु ठट-बट मां रवतेलु, बाकुन तेबी तीना काजे तीनु फुले मायन एकान तसों बी पुथल्‌या पेहरीन वारु नी बणायो। ");
INSERT INTO bhi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","तेरेमां तत्‌यार भगवानेन खळा मायन चारा काजे, चो आज छे ने वाहणे चुल्‌हा आकठा मां धपाड़से, असला पुथल्‌या पेहरावे, ती ए कम भुरसु करन्‌या, तुहुं जाराक वीच्‌यार करु भगवान तुहुं नी पेहरावे काय। ");
INSERT INTO bhi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","तेरेमां तुहुं फीकुर करीन घुण कहुं की, हामु काय खासुन, ने काय पीसुन ने काय पेहरसुन। ");
INSERT INTO bhi_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","काहाकी नी-यहुदी तीनी आखी चीज काजे हेरता रहे, बाकुन तुंद्‌रु सरगेन बास जाणे की, तुहुंक तीनी आखी चीजेन जरुवत छे। ");
INSERT INTO bhi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","तेरेमां पेहल तुहुं भगवानेन राजेन ने तेरे धरमेन हेरेमां रहु, ती जी आखी चीज तुहुंक जड़ जासे। ");
INSERT INTO bhi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","अळतेन वाहणेन फीकुर मां करु, काहाकी वाहणेन दाहड़ु, आपणी फीकुर आपसो कर लेसे; आजुन वाटे आजुत दुख बेसको छे। ");
INSERT INTO bhi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","कुय पर बी असलात नीयाव मां करु, असलुत भगवान बी तुंद्‌रु नीयाव नी करसे। ");
INSERT INTO bhi_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","काहाकी जसा तुहुं असलात गुनु लागाड़ु, तसात तुंद्‌रे पर बी असलात गुनु लागाड़से; ने तीना नाप सी तुहुं नापसु, तीनात नाप सी तुंद्‌रे वाटे बी नापायसे। ");
INSERT INTO bhi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","तु काहा आपणा भायसेन डुळा मां कचरा काजे देखे, तारा डुळा मां भरायलु कचरु काहा नी देख रया? ");
INSERT INTO bhi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","जत्‌यार तारात डुळा मां डेंगु छे, ती तु आपणा भायस सी कसु कय सक्‌तेलु, की लाव मे तारा डुळाम सी कचरु नीकाळ दम? ");
INSERT INTO bhi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ए ढंगड़ा करन्‌या, पेहल आपणात डुळा मां सी कचरु नीकाळ ले, तत्‌यार तु आपणा भायसेन डुळा मां सी कचरा काजे वारु देखीन नीकाळ सक्‌सी। ");
INSERT INTO bhi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","चुखली चीज कुतरा काजे मां आपु, ने मोती काजे सुहर्‌या अगळ मां नाखु; असो नी हवणु चाहजे की चे तीनी चीज काजे पाये तळे कुचरी देय ने पछा फीरीन तुहुंत काजे फाड़ देय। ");
INSERT INTO bhi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","मांगसु, ती तुहुंक आपसे; ने हेरसु ती तुहुं काजे जड़ी जासे; बारनो ठुकसु ती तुंद्‌रे वाटे उघड़ी जासे। ");
INSERT INTO bhi_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","काहाकी जु कुय मागंसे, तीनु काजे आपसे; ने जे कुय हेरसे तीनु काजे जड़ी जासे; ने जु कुय बारनो ठुकसे, हींद्‌रे वाटे उघड़ी जासे। ");
INSERT INTO bhi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","तुंद्‌रे मां असु काहनु माणुस छे, की कदी तेरु पुर्‌यु तेरे सी रुटु मांगे, ती तीना काजे दगड़ु आपे? ");
INSERT INTO bhi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","नीते माछा मांगे, ती काय तुहुं तीनाक घड़सु आपसु? ");
INSERT INTO bhi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","अळतेन जत्‌यार तुहुं भुंडात हय्‌न, आपणा पुर्‌या काजे वारलु चीज आपणे जाणु, ती तुंद्‌रु सरगेन बास आपणा मांगणे वाळा काजे वारलु चीज काहा नी आपे। ");
INSERT INTO bhi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","हेरे वजे सी जो काय तुहुं चाहु की माणसे तुंद्‌रे साते करे, तसात तुहुं बी हींद्‌रे साते करु; काहाकी चुखला सास्‌तुर मां ने भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळान बी सीकाड़नु असोत छे। ");
INSERT INTO bhi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","साकेड़ले वाट्‌ये मायन जावु, काहाकी चवड़ु छे चु वाट ने चु वाट नास हवे तीने वाट्‌ये ली जाय; ने बेसका छे जे तीने वाट्‌ये मायन जाय। ");
INSERT INTO bhi_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","काहाकी साकेड़ली ने काठली वाट जी छे, ची वाट जीवन भीणी लीन जाय; थुड़ाक छे चे, तीनु काजे जड़ी जाय। ");
INSERT INTO bhi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","हामु लुच्‌चा भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌या माणसे सी चेतीन रवु, चे गाडरान तसा सुदला बणीन तुंद्‌रेन्‌चां आवे। बाकुन चे लेंड्‌यान तसा आकेरला छे। ");
INSERT INTO bhi_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","हींद्‌रा काम सी तुहुं तीनुक उळखी लेसु की। काय माणसे झाड़का सी अंगुर, नीते गखर्‌या-काटा सी अंजीरेन फळ तुड़े काय? ");
INSERT INTO bhi_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","तेरे बदले हरेक एक वारलु झाड़का वारलु फळ लावे ने भुंडात झाड़का भुंडात फळ लावे। ");
INSERT INTO bhi_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","वारलु झाड़का भुंडात फळ नी लाय सके, ने भुंडोत झाड़को वारलु फळ नी लाय सके। ");
INSERT INTO bhi_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","जे-जे झाड़का वारलु फळ नी लावे, तीना काजे काटीन आकठा मां धपाड़ देसे। ");
INSERT INTO bhi_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","हेरे वजे सी हींद्‌रा काम तुहुं उळखी लेसु। ");
INSERT INTO bhi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","जे माणसे मेसेक, ए मालीक, ए मालीक कय्‌न आयड़से, हींद्‌रे मां सी आखा सरगेन राज मां नी भराय सके, बाकुन जे मारा सरग वाळा बासेन मरजी पर चाले चेत सरगेन राज मां भरायसे। ");
INSERT INTO bhi_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","तीने दाहड़े बेसका माणसे मेसेक असा कह्‌से, ए मालीक, ए मालीक, काय हामु तारे नाव सी भगवानेन अघी सी आवणे वाळी वात नी देखाड़्‌या, ने तारा नावे सी भुतड़ान आत्‌मा काजे नी नीकाळ्‌या, ने तारा नाव सी बेसको ताकुतेन काम नी कर्‌या काय! ");
INSERT INTO bhi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तत्‌यार मे तींद्‌रे सी चुखोझण कय दीस, मे तुहुं काजे नी जाणो। ए पाप करने वाळा, मार धड़े सी छेटा हय जावु। ");
INSERT INTO bhi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","तेरेमां ज काहनुक मारी जी वात सामळीन माने, हयु तीना अक्‌कल वाळा माणसेन तसु छे, जु तेरा घर काजे चापर्‌या पर नेहु खुदीन बणायु। ");
INSERT INTO bhi_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ने पाणी पड़्‌यु, ने नदी आवी, आंधी आवी, ने तीना घर सी ठुकाय, तेबी च नी उदर्‌यो, काहाकी हेरु नेहु चापर्‌या पर खुदीन बणावलु हतलु। ");
INSERT INTO bhi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“बाकुन जे काहनाक मारी जी वात सामळे ने तेरे पर नी चाले, चु तीना डेड़-अकल्‌या माणसेन तसु छे, चु तेरा घर काजे रेतळा पर नेहु खुदीन बणायु। ");
INSERT INTO bhi_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ने पाणी पड़्‌यु, ने नदी आवी ने आंधी आवी, ने तीना घर सी ठुकाय ने च आखो उदरी गुयो ने खत्‌तम हय गुयो!” ");
INSERT INTO bhi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","जत्‌यार ईसु जी आखी वात कय देदु, ती माणसे तेरी वात सामळीन चकराय गुया, ");
INSERT INTO bhi_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","काहाकी चु यहुदी नीयम सीकाड़न्‌यान मास्‌तर्‌यान तसु नी बाकुन हकदारेन तसु तीनुक सीकाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","जत्‌यार ईसु तीना बयड़ा सी नेचु उतर्‌यु, ती एक माणसेन मट्‌लु टुळु तेरे पछळ आयु। ");
INSERT INTO bhi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ने देखु, एक कुड़ायलो तेरे धड़े आवीन ईसुक आंध्‌यु ने कह्‌यु, “ए मालीक, कदी तु चाहे, ती मेसेक वारु कर दे।” ");
INSERT INTO bhi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ईसु तीनाक छीमीन असु कह्‌यु, “मारी मरजी बी असीत छे, तु चुखु हय जां!” ने हयु तत्‌यारुत कुड़ सी चुखा हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ईसु तीना काजे कह्‌यु, “देख, जी वात कुय काजे घुण कहें, बाकुन जाय्‌न पुजाराक बताड़जी ने मुसान कायदान अनसारे भेट चड़ावजी, ती आखा माणसे जाण जासे ने गवा बण जासे की तु वारु हय गुयु।” ");
INSERT INTO bhi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","जत्‌यार ईसु कफरनहुम सहर मां पुग्‌यु ती एक सुबेदार तेरे धड़े आवीन तेरे सी लीलघाय्‌न कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ए मालीक, मारा पावर्‌यान लखवु हय गुयु, ने घर मां पड़ीन एला कर रयु।” ");
INSERT INTO bhi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ईसु तीना काजे कह्‌यु, “मे आवीन तीना काजे वारु कर दीस।” ");
INSERT INTO bhi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","सुबेदार जपाप आप्‌यु, “ए मालीक मे अतरु वारु नी हय की तु मारा घरेन साहळे आवे, बाकुन तु जात रय्‌न एक बुल कय दे, ती मारु पावर्‌यु वारु हय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","काहाकी मे बी दीसरान हक मां रवण्‌यु एक नानुस हकदार्‌यु छे, ने सीपायड़ा मारे हक मां रहे जत्‌यार मे एक सी कहं ‘जां!’ ती चु जाय; ने दीसरा सी कह्‌, ‘आव!’ ती चु आवे; ने जत्‌यार मारा पावर्‌यु सी कह्‌, ‘ज कर!’ तीना काम काजे करे।” ");
INSERT INTO bhi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ज सामळीन ईसु चक्‌कर मां पड़ गुयु, ने जे तेरे पछळ आवतेला तीनुक कह्‌यु, “मे तुंद्‌रे सी छाचलीन कहं की मे ईस्‌रायेली माणसे मां बी मेसेक अतरु पाक्‌कु भुरसु देखणे नी जड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","मे तुंद्‌रे सी कहं की उगेवणा ने बुडवणा सी बेसका माणसे आवीन अब्‌राहम ने इसाक ने याकुप साते सरग वाळा भगवानेन राज मां बठीन खाणो खासे। ");
INSERT INTO bhi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","बाकुन जे भगवानेन सरग राजेन हकदार्‌या माणसे छे, बाकुन चे भुरसु नी करे, तीनु काजे सरग राजेम सी बाहार आंदारला मां नाख देसे। चां कलपी-कलपीन रड़सु ने दात काजे ककड़ावता रवसु।” ");
INSERT INTO bhi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","तत्‌यार ईसु तीना सुबेदार काजे असु कह्‌यु, “जां, जसु तारु भुरसु छे, तसुत तारे वाटे बी हय जाय।” ने तेरु पावर्‌यु तत्‌यारुत वारु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ईसु जत्‌यार पतरसेन घर मां आयु, ती पतरसेन सासुसेन सेरी आय रवलो देख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ईसु तीनी पर हात मेक्‌यु ने तेरो सेरी तत्‌यारुत उतरी ज्‌य, ने ची उठीन ईसुन चाकरी करने बाजी गुय। ");
INSERT INTO bhi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","जत्‌यार सांती वेळाय चे ईसु धड़े बेसका माणसे काजे लाया तींद्‌रे मां भुतड़ान आत्‌मा हतली ने ईसु तीनु आत्‌मा काजे तेरा बुल सी नीकाळ देदु; ने आखा मांदला काजे वारु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","काहाकी ज बुल यसायाह भगवानेन अघी सी आवणे वाळी वात देखान्‌यान साहरे कह्‌लो हतलो च पुरो हवे, “चु आपसु हामरी आखी लुल्‌गाय काजे झेल लेदु ने हामरी मांदवाड़ काजे छेटु कर देदु।” ");
INSERT INTO bhi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","जत्‌यार ईसु तेरे चारे मेर एक मटला टुळा काजे देख्‌यु, ती डाबरान पली धड़े जाय्‌न हुकुम आप्‌यु की, तुहुं मेसेक ढंड्‌या मां बठाड़ीन दरीयान पली धड़ ली जाती रवु। ");
INSERT INTO bhi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","तत्‌यार एक यहुदी नीयमेन मास्‌तर्‌या ईसु धड़े आवीन कह्‌या, “ए मास्‌तर, जांहा बी तु जासी, मे तारे पुठ्‌ये आवीस।” ");
INSERT INTO bhi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ईसु तीनुक कह्‌यु, “फुंदाळी खुखड़ीन दर रवे ने सरगे चिरलान बसणेन पुत्‌रु रवे; बाकुन माणसेन पुर्‌या वाटे ते मुणको ढाकणेन लग जागु नी हय।” ");
INSERT INTO bhi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","एक दीसरु चेलु ईसु काजे कह्‌यु, “ए मालीक मे तारे पुठ्‌ये आवीस बाकुन मेसेक मारा बासेन घर जाणी दे, की जत्‌यार चु मर जासे ती तीनाक गाड़ दीन मे तारे पुठ्‌ये आवीस।” ");
INSERT INTO bhi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ईसु तीनाक कह्‌यु, “मरला काजे गाड़ने काम मरलात काजे करने दे; तु ते मारे पुठ्‌ये चाल।” ");
INSERT INTO bhi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","जत्‌यार ईसु ढंड्‌या मां बठ्‌यु ती तेरा चेला बी तेरे पुठ्‌ये बठ गुया। ");
INSERT INTO bhi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ने, तीनी टेम दरीया मां उचकान बेसकी मटी आंधी आवी, ने दरीयान झलक ढंड्‌ये आपठायन बाकुन ईसु ते, सुवणे बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","तत्‌यार चेला ईसु धड़े आवीन उठाड़्‌या ने कह्‌या, “ए मालीक हामुक!” बचाड़ नी ते “हामु आखा डुबीन मरने बाजी रया!” ");
INSERT INTO bhi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ईसु तीनुक कह्‌यु, “ए! कम भुरसा वाळा, तुहुं काहा बीही रया!” तत्‌यार चु उठीन आंधी ने पाणी काजे लड़्‌यु, ने आखो सेळो पड़ गुयो। ");
INSERT INTO bhi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ने चे चकराय गुया ने कह्‌णे लाग्‌या, “गुयु कसलु माणुस छे की आहळी ने पाणी बी हेरी वात काजे माने।” ");
INSERT INTO bhi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","जत्‌यार चु पली धड़े गदरेन्‌यान ईलाका मां पुग्‌यु, ती दुय माणसे तींद्‌रे मां भुतड़ान आत्‌मा हतली ची मसाण मां सी नीकळ्‌या ने ईसुक भेळा हवणे आया। चे अतरा ताकतवाळा हतला की कुय बी तीनी वाट सी जाय नी सकतेला। ");
INSERT INTO bhi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","चे आयड़ीन असा कह्‌या, “ए भगवानेन पुर्‌या, हामरे साते तारो काय काम छे? काय तु हामुक एला पाड़ने आय र्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","हींद्‌रे सी ईतरेक छेटेस बेसकु मटु सुहर्‌यान टुळु चरने बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","भुतड़ान आत्‌मा ईसुक असी कवीन लीलघायणे लागी की, “कदी तु हामु काजे अदमी मां सी नीकाळे, ती पला सुहर्‌यान टुळा मां मकली दे।” ");
INSERT INTO bhi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ईसु तीनुक कह्‌यु, “जावु!” ने चे अदमी मां सी नीकळीन सुहर्‌यान टुळा मां भराय गुया, ने आखा टुळा आड़खा पर सी झपटीन पाणी मां डुबीन मर गुया। ");
INSERT INTO bhi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ने सुहर्‌या काजे चारन्‌या गुवाळ्‌या ढास्‌या, ने सहर मां जाय्‌न हयो, च आखो कय देदा ने भुतड़ा लागला माणसेन काय हयो च बी कय देदा। ");
INSERT INTO bhi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","तत्‌यार आखा सहरेन माणसे ईसु सी मेळने करीन आयु, ने ईसुक देखीन लीलघाय्‌न कह्‌णे लाग्‌या की हामरी मुलकेम सी बाहर जाती रव। ");
INSERT INTO bhi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","अळतेन चु ढंड्‌या पर चड़ीन पली धड़े पुग्‌यु, ने आपसा गांव कपरनुह मां आयु। ");
INSERT INTO bhi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","तीनी टेमे थुड़ाक माणसे लखवान एक मांदवाड़ वाळा माणसे काजे खाट्‌ली पर मेकीन तेरे धड़े लाया। ईसु हींद्‌रु भुरसु देखीन, लखवान मांदला सी कह्‌यु, “ए पुर्‌या, तुसेक तारा पापेन माफी जड़ गुयली छे।” ");
INSERT INTO bhi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","तेरे वजे सी बेसका यहुदी नीयमेन मास्‌तर्‌या वीच्‌यार्‌या, “जु ते भगवानेन नाव-बद्‌दी करे।” ");
INSERT INTO bhi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ईसु तींद्‌रा मनेन वात जाणीन कह्‌यु, “तुहुं तुंद्‌रा मन मां भुंडोत वीच्‌यार काहा कर रया? ");
INSERT INTO bhi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","एक जसों काय छे? ज्‌य कह्‌णु की, तारा पापेन माफी तुसेक जड़ गुय, नीते ज्‌य कह्‌णु, ‘की उठ ने चाल ने फीर।’ ");
INSERT INTO bhi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","बाकुन तेरेमां तुहुं जाण लेवु की माणसेन पुर्‌या काजे कळी पर पाप माफ करनेन बी हक छे।” तत्‌यार हयु लखवान मांदला सी कह्‌यु, “उठ, तारी खाट्‌ली हाकलीन, तार घर जाती रव।” ");
INSERT INTO bhi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","चु उठीन तेरे घर जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","माणसे ज देखीन बीही गुया, ने भगवानेन बड़ाय करने लाग्‌या जु माणसे काजे बी असु हक आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ईसु चां सी अगु गुयु ने चु, मत्‌‌ती नावेन एक माणुस काजे फाळु उकाळनेन नाका पर बठलु देख्‌यु, ने तीना काजे कह्‌यु, “मारे पुठ्‌ये चाल।” चु उठीन ईसु पुठ्‌ये चाल पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","एक दाहड़ु ईसु हेरा चेला पुठ्‌ये मत्‌‌तीन घर खाणो खाणे करीन बठ्‌यु, ती बेसका फाळु लेणे वाळा पापी माणसे आवीन, ईसु ने हेरा चेला साते खाणो खाणे बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","असो देखीन फरीसी माणसे ईसुन चेला काजे असा कह्‌या, “तुंद्‌रु मास्‌तर फाळु लेणे वाळा ने पापी साते काहा खाय रयु?” ");
INSERT INTO bhi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ज सामळीन ईसु तींद्‌रे सी कह्‌यु, “दवा वारलु काजे नी चाहजे, बाकुन मांदला काजे चाहजे। ");
INSERT INTO bhi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","तेरेमां तुहुं जाय्‌न चुखला सास्‌तुर मां लिखली वात सीक लेवु: ‘मे जनवार्‌यान बादा नी चाहो बाकुन दया चाहो।’ काहाकी मे धरमी माणसे काजे नी, बाकुन पापी काजे बुलावणे आवलु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","तत्‌यार युहन्‌नान चेला ईसु धड़े आवीन असा कह्‌या की, “हामु ने फरीसी माणसे उपास करजे, बाकुन तारा चेला उपास काहा नी पाळे?” ");
INSERT INTO bhi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ईसु तीनुक कह्‌यु, “जत्‌यार लग दुल्‌लु तींद्‌रे पुठ्‌ये छे, ती काय अरात्‌या, दुखी हवसे काय? बाकुन चे दाहड़ा आवसे जत्‌यार दुल्‌लु तींद्‌रे सी अलग हय जासे, तत्‌यार चे उपास पाळसे। ");
INSERT INTO bhi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“नवला पुथल्‌यान थीग्‌ळो जुन्‌ला पुथल्‌या पर कुय नी लागाड़े, काहाकी चो थीग्‌ळो तीना पुथल्‌या सी थुड़ोक अळी खेच लेय, ने चो अदुस फाट जाय। ");
INSERT INTO bhi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ने माणसे नवलु अंगुरेन रस जुन्‌ली चामड़ान थयलि मां नी भरे, काहाकी असा करने सी थयलि फाटी जाय, ने पीयालु बगळी जाय ने थयलि रद हय जासे; बाकुन नवलु पीयालु नवली थयलि मां भरे ने चे दुयु बच जासे।” ");
INSERT INTO bhi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ईसु तीनुक जी वात कवणे बाजी रवलु, एक हकदार आवीन तीना काजे आंध्‌यो ने कह्‌यु, “मारी बेटी हयुसुत मर गुयली छे, बाकुन तु आवीन तेरे पर हात मेक, ती ची जीवती हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ईसु उठीन तेरे पुठ्‌ये चाल पड़्‌यु ने तेरा चेला बी तेरे पुठ्‌ये चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","तीनी टेमे एक बायर हतली, तेरे पोगराळो दुख लागलो बारे साल हय रवला, ने ची ईसु पछळ आय्‌न ईसुन पुथल्‌या काजे छीम लेदी। ");
INSERT INTO bhi_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","काहाकी ची तेरा मन मां कवतेली, “कदी मे तेरा पुथल्‌यान छेवड़ाक छीमी लीस, ती मे वारु हय जायस।” ");
INSERT INTO bhi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ईसु पछु फीरीन तीनीक देख्‌यु ने कह्‌यु “बेटी हिम्‌मत राख; तारु भुरसु तुसे काजे छुटकारु आप्‌यु।” अळतेन ची बायरी तत्‌यारुत वारु हय गुय। ");
INSERT INTO bhi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","जत्‌यार ईसु तीना हकदारेन घर मां पुग्‌यु ती पावळी आजाड़ने वाळाक ने माणसेन टुळाक रड़तेला देख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","तत्‌यार ईसु कह्‌यु, “छेटा हय जावु, पुरे मरी नी, बाकुन सुय रय!” असु कह्‌यु अतरुत ने ईसुन हासी उड़ावणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","बाकुन जत्‌यार माणसेन टुळा काजे नीकाळ देदा, ती ईसु घर मां जाय्‌न पुरेन हात धर्‌यु, ने ची जीवती हय्‌न बठी हय गुय। ");
INSERT INTO bhi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ने हीनी वातेन खबर तीना आखा देस मां चारे मेर मालुम हय गुयो। ");
INSERT INTO bhi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","जत्‌यार ईसु चां सी अगु जाणे बाजी गुयु, ने दुय आंदळा तेरे पछळ असा कय्‌न आवणे बाजी गुया, “ए दावुदेन अवल्‌यात, हामरे पर दया कर!” ");
INSERT INTO bhi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","जत्‌यार ईसु घर मां पुग्‌यु, ती चे दुय आंदळा तेरे धड़े आया, ने ईसु तींद्‌रे सी कह्‌यु, “काय तुहुंक भुरसु छे की मे ज्‌य कर सको?” चे ईसुक कह्‌या, “हव, मालीक।” ");
INSERT INTO bhi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तत्‌यार ईसु तींद्‌रा डुळा छीमीन कह्‌यु, “तुंद्‌रु भुरसु छे, तसोत तुंद्‌रे वाटे हय जाय।” ");
INSERT INTO bhi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ने चे देखणे बाजी गुया। ती ईसु तीनुक वारु समजाड़ीन कह्‌यु, “चेतीन, रवजु, जी वात कुय काजे घुण कवु।” ");
INSERT INTO bhi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","बाकुन चे घर मां सी जाती रया, ने अळतेन जी वात तीना देस मां आखे कय देदा। ");
INSERT INTO bhi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ईसु खयड़े नीकळीन जाणे बाजी रवलु, ती माणसे एक गुंगा काजे तेरे मां भुतड़ान आत्‌मा चस्‌टी रवली, तीनाक बुलायतेलो नी ईसु धड़े लाया। ");
INSERT INTO bhi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ने जत्‌यार ईसु भुतड़ा काजे नीकाळ देदु, ती गुंगो बुलने बाजी गुयो। तेरे वजे सी माणसेन टुळु चकराय गुयु ने असा कह्‌या, “ईस्‌रायेल देस मां असो वारु काम कदी नी देख्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","बाकुन फरीसी माणसे कह्‌या, “जु ईसु ते भुतड़ान आत्‌मान मुखीन जुर सी भुतड़ान आत्‌मा काजे नीकाळे।” ");
INSERT INTO bhi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ईसु आखा सहर मां ने गांव मां फीरतु रयु, ने भगवानेन भक्‌तीन घर मां माणसेक सीकाड़तु रयु, ने भगवानेन राजेन खुस-खबरेन बारामां परचार करतु रयु, ने आखी भाती-भातीन मांदवाड़ ने लुल्‌गाय काजे वारु करतु रयु। ");
INSERT INTO bhi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","जत्‌यार चु माणसेन टुळा काजे देख्‌यु, ती ईसु काजे माणसे पर दया आय, काहाकी चे तीनु गाडरान तसा हींद्‌रु कुय राखवाळ्‌यु नी हतलु, चे दुख मां ने भटकला हतला। ");
INSERT INTO bhi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","तत्‌यार ईसु तेरा चेला काजे कह्‌यु, “मेर ते बेसकी छे, बाकुन मेर काटण्‌या दाहड़क्‌या थुड़ाक छे। ");
INSERT INTO bhi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","तेरेमां खेतेन मालीक सी लीलघाय्‌न कह्‌यु, की चु आपणा खेत मां मेर काटणे करीन दाहड़क्‌या मकली देय।” ");
INSERT INTO bhi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ईसु आपसा बारे चेला काजे धड़े बुलायु ने तीनुक, भुतड़ा नीकाळनेन हक आप्‌यु, ने आखी भातीन मांदवाड़ ने आखी भातीन लुल्‌गाय काजे वारु करनेन हक आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","तीनु बारे नेवताळान नाव जो छे: पेहलु सीमोन, जु पतरस कह्‌वाये, ने तेरु भायस अन्‌दीरीयास; जब्‌दीन पुर्‌यु याकुप, ने तेरु भायस युहन्‌‌‌नु; ");
INSERT INTO bhi_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ने फीलीप्‌पुस, ने बरतुल्‌मे, ने थोमा, ने फाळु लेणे वाळु मत्‌‌ती, ने हलफाईन पुर्‌यु याकुप, ने तद्‌दे, ");
INSERT INTO bhi_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","सीमोन, कनानी ने यहुदा ईस्‌करीयोती ने हयु ईसुक धुकु दीन धराड़ी बी देदु। ");
INSERT INTO bhi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","हीनु बारे चेला काजे ईसु ज हुकुम आपीन मकल्‌यु: नी-यहुदी माणसे भीणी घुण जावु, ने सामर्‌यान काहना बी सहर मां घुण जावु। ");
INSERT INTO bhi_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","बाकुन ईस्‌रायेली जातीन माणसे मां जाजु, चे भगवान काजे ईसरीन खुवायला गाडरान तसा हय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ने वाट्‌ये चालता-चालता असो परचार करु, की सरगेन राज धड़ेत आय गुयलो छे! ");
INSERT INTO bhi_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","मांदला काजे वारु करु, मरला काजे जीन्‌दा करु, कुड़ायला काजे चुखा करु, भुतड़ान आत्‌मा काजे नीकाळु। तुहुंक फुकट मां जड़लो छे, तुहुं बी फुकट मां आपु। ");
INSERT INTO bhi_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","परचार करने जावु तत्‌यार, तुंद्‌री थयलि मां सनो, चांदी, नी ते पयस्‌या घुण ली जावु; ");
INSERT INTO bhi_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","तुहुं वाट्‌ये वापरने करीन कांखुर जावु ती चां नीते झुळु राख्‌जु, नी दुय कुरता, नी खासड़ा, नी लाकड़ी लेजु, काहाकी दाहड़क्‌या काजे दाहड़की जड़नु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“काहना बी सहर मां नीते गांव मां जावु, ती चां पुगीन एक अदमीन पतु लागाड़ लेजु, ने चां सी तेरेन चां रवजु।” ");
INSERT INTO bhi_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","तुहुं घर मां भरायु ती तीनुक संयबरकत आपजु। ");
INSERT INTO bhi_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","कदी तीना घर मां माणसे भुरसु करन्‌यु रवसे, तीते तुंद्‌रो सांतीन संयबरकत हींद्‌रे पर हय जासे, बाकुन कदी चे भुरसु करन्‌या नी रहे, ती तुंद्‌रो संयबरकत तुंद्‌रे भेळु पछो आवसे। ");
INSERT INTO bhi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","जे कुय बी तुंद्‌रो आव-भाव नी करे, ने तुंद्‌री वात नी सामळे, ती तीना घर, ने तीना सहर सी नीकळता जाय्‌न आपणे पायेन धुळा काजे बी झाटकी देजु। ");
INSERT INTO bhi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","मे तुहुंक छाचलीन कहं की नीयावेन दाहड़े तीना सहरेन दुख सदोम ने अमोरा देसेन माणसेक अदुस डंड जड़से। ");
INSERT INTO bhi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","देखु, मे तुहुंक लेंड्‌यान तसा माणसेन ईचमां गाडरान तसु मकलो, तेरेसी घड़सान तसा कदर्‌या ने पेरवान तसा सुदा बणु। ");
INSERT INTO bhi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","बाकुन वेरी माणसे सी चेतीन रवु, चे तुहुंक धरीन पंचुन हात मां सुप देसे, ने तींद्‌रा भक्‌तीन घर मां ली जाय्‌न सपाटा देसे। ");
INSERT INTO bhi_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","तुहुं मेसेक मानी रया करीन हकदार्‌या ने राजा अगळ ली जासे, काहाकी तुहुं मारा गवा छे। असा करीन तुहुं नी-यहुदी अगळ मारा गवा बणसु। ");
INSERT INTO bhi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","जत्‌यार चे तुहुंक धराड़ीन सीपायड़ान हात मां आप देसे, ती असी फीकुर घुण करु की हामु कसा ने काहली रीती सी कवसुन काहाकी ज काय तुहुंक कह्‌णु छे, च तीनीत टेमे बताड़ देसे। ");
INSERT INTO bhi_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","काहाकी कह्‌णे वाळा तुहुं नी हय, बाकुन तुंद्‌रा भगवान बासेन जीव-आत्‌मा तुंद्‌रेम हय्‌न बुलसे। ");
INSERT INTO bhi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","भाय, भायस काजे अळी बास पुर्‌या काजे, मारने करीन धराड़से अळी पुर्‌या आयस बासेन वेला नी हवे ने तींद्‌रे भीणी उठीन तीनुक माराड़से। ");
INSERT INTO bhi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","मारा नाव पर भुरसु कर रया करीन आखा माणसे तुंद्‌रे सी भुंडा रवसे, बाकुन काहनु बी मरता लग गम खासे, चेत छुटकारु हात करसे। ");
INSERT INTO bhi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","जत्‌यार चे तुहुंक एक सहर मां एला पाड़े ती दीसरा सहर मां ढासी जाजु। मे तुहुं काजे छाचलीन कहं, की माणसेन पुर्‌या काजे पछु आवणे लग तुहुं ईस्‌रायेली देसेन आखा सहरेम फीरता-फीरता परचार करनेन काम पुरो नी कराये। ");
INSERT INTO bhi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","चेलु आपणा मास्‌तर सी मटु नी हय सके; ने पावर्‌यु आपणा मालीक सी मटु नी हय। ");
INSERT INTO bhi_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","चेला काजे मास्‌तर, ने पावर्‌या काजे मालीक बराबर रहणुत वारु छे। कदी माणसे घरेन मालीक काजे भुतड़ु कह्‌यु, ती तेरा घरन्‌या काजे काय नी कह्‌या? ");
INSERT INTO bhi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","तेरेमां माणसे सी घुण बीहु; असो काय ढाकायलो नी हय, च उघाड़े असो नी हय; ने असो काय बी सातायलो नी हय, च मालुम नी हवे। ");
INSERT INTO bhi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ज मे तुहुं काजे आंदारला मां कय रयु, तीना काजे तुहुं वीजाळो हवे तत्‌यार दीसरा काजे सामळाव जु; ज मे काय तुहुं काजे मन मां कह्‌लु च तुहुं, घरेन छत पर चहड़ीन परचार करजु। ");
INSERT INTO bhi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ज डील काजे खत्‌तम करे, बाकुन आत्‌मा काजे खत्‌तम नी कर सके, तींद्‌रे सी मां बीहु; बाकुन तेरेत सी बीहु चु आत्‌मा अळी डील दुयु काजे नरक मां खत्‌तम कर सके। ");
INSERT INTO bhi_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","काय एक पयस्‌या मां दुय घीनचीड़ा नी वेचाये? तेबी तुंद्‌रा सरग वाळा बासेन मरजी पाखुर तेरे मां सी एक बी मरीन भुयमां नी पड़े। ");
INSERT INTO bhi_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","तुंद्‌रा मुणकान कान्‌या बी आखा गीणायला छे। ");
INSERT INTO bhi_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","तेरेमां तुहुं बीहयु मां; काहाकी तुहुं तीनु घीनचीड़ा सी बड़ीन छे। ");
INSERT INTO bhi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","जु कुय बी माणसे अगळ मेसेक मान लेसे, तीना काजे मे बी आपणा सरग वाळा बास अगळ मान लीस। ");
INSERT INTO bhi_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","बाकुन जु कुय बी माणसे अगळ मेसेक नी माने, ती मे बी आपणा सरग वाळा बास अगळ तीना काजे नीकारु कर दीस। ");
INSERT INTO bhi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","तुहुं मार बारामां असा समजी रया की मे कळी मां सुक-सांती लीन आवलु छे; मे सांती आपणे नी, बाकुन तलवार लीन आवलु छे। ");
INSERT INTO bhi_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","मार पर भुरसु कर रया करीन, पुर्‌यु बासेन वीरुद करसे, ने पुरे मायन वीरुद करसे, ने उहड़ीस सासुसेन वीरुद करसे। ");
INSERT INTO bhi_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","असा करीन मारा चेलान घरन्‌यात तेरा वेरी बण जासे। ");
INSERT INTO bhi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“जे माय नीते बास काजे मारे सी अदुस परम करसे, चु मार पर भुरसु करन्‌यु नी हय; ने जे पुर्‌या नीते पुरे काजे मारे सी अदुस परम करसे, चु मार पर भुरसु करन्‌यु नी हय; ");
INSERT INTO bhi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ने जे आपणु कुरुस लीन मारे पछळ नी चाले चु मारु भुरसु करन्‌यु नी हय।” ");
INSERT INTO bhi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","जु आपणा जीव काजे बचाड़से, चु खुवसे; ने जु मारे वजे सी आपणी जान खुवसे, तीना काजे जीवन जड़ जासे। ");
INSERT INTO bhi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ज्‌य तुंद्‌रो आव-भाव करसे, चु मारो आव-भाव करे; ने ज मारो आव-भाव करे, चु मारा मकलने वाळा भगवानेन आव-भाव करे। ");
INSERT INTO bhi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जु भगवानेन अघी सी आवणे वाळी वात देखाड़ने वाळा काजे भगवानेन अघी सी आवणे वाळी वात देखाड़ने वाळु छे करीन तेरो आव-भाव करे, तीना काजे भगवानेन अघी सी आवणे वाळी वात देखाड़ने वाळाक संयबरकत जड़से; ने जे वारलु माणुस काजे वारलु जाणीन आव-भाव करसे, तीना काजे वारलु माणुस काजे संयबरकत जड़से। ");
INSERT INTO bhi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","जु कुय ईनु नानला मां सी एक काजे मारु चेलु छे, करीन एक कळस्‌यु सेळो पाणी पावसे, मे तुंद्‌रे सी छाचलीन कह्‌वो की, चु कसु बी करीन आपणो फळ नी खुवे। ");
INSERT INTO bhi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","जत्‌यार ईसु तेरा बारे चेला काजे हुकुम आप देदु, ती चु तींद्‌रा सहर मां सीकाड़तु ने परचार करने करीन चां सी जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","बपतीस्‌मा आपण्‌या युहन्‌नान चेला, ईसुन बारामां सामळ्‌या, ती चे जेलेम जाय्‌न युहन्‌ना काजे खबर कर्‌या। तत्‌यार युहन्‌‌‌नु तीनु चेला काजे मालीक ईसुन्‌चां जो पुछणे मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“काय आवणे वाळु मसी तु छे काय? की हामु काहनाक दीसरान वाट देखजे?” ");
INSERT INTO bhi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ईसु जपाप आप्‌यु, “जो काय तुहुं देख्‌या ने सामळ्‌या, चो आखो युहन्‌ना काजे जाय्‌न कय देजु, ");
INSERT INTO bhi_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","की आंदळा देखणे बाजी रया, लंगड़ा चालने फीरने बाजी रया कुड़ायला वारु हयन चुखा हवणे बाजी रया, ने बेहरा सामळने बाजी रया, ने मरला जीवता हय रया, ने गरीब काजे खुस-खबरेन वात सामळावे। ");
INSERT INTO bhi_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ने बेसकु वारु छे, जे मार वजे सी वीरखाय रया, बाकुन जे वीरखाये बीगुर, मार पर भुरसु नी करे।” ");
INSERT INTO bhi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","जत्‌यार चेला चां सी चाल देदा, ती ईसु युहन्‌नान बारामां माणसे सी कह्‌वणे बाजी गुयु, “तुहुं बयड़ा मां काय देखणे गुयला? काय वाहळा मां हालतेला सुट्‌या काजे देखणे गुयला काय? ");
INSERT INTO bhi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","कहुं ते खरा ती तुहुं काय देखणे गुयला? काय वारलु पुथल्‌या पेहेरला माणुस काजे? देखु, जे वारलु पुथल्‌या पेहरे, चे राजान हवेली मां रवे। ");
INSERT INTO bhi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ती तुहुं काय देखणे गुयला? भगवानेन अघली वात बताड़न्‌या काजे देखणे गुयला? तीनु आक सी युहन्‌‌‌नु मटु माणुस छे तीनाक तुहुं देखणे गुयला। ");
INSERT INTO bhi_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","जु हयुत युहन्‌‌‌नु छे तेरे बारामां असो लिखलो छे: ‘देख, मे मारा काहवाळ्‌या काजे तारे अगळ मकलो, जु तारे अगळ तारी वाट तीयार करसे।’ ");
INSERT INTO bhi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","मे तुहुंक छाचलीन कह्‌वो, की जे बायरा सी पयदा हवला छे, चे युहन्‌ना बपतीस्‌मा देणेवाळा सी मटा नी हय; बाकुन जे सरगेन राज मां आखा सी नानला छे, चे तेरेसी मटु छे। ");
INSERT INTO bhi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","युहन्‌ना बपतीस्‌मा देणेवाळान दाहड़ा मां सी हय लग सरगेन राजेन वाटे बेसका मेहेनत कर रया, ने भगवानेन राज मां भरायणे करीन खुस-खबरेन नेवतो आखा काजे जड़ रयो राजेन हक काजे हात मां कर लेय। ");
INSERT INTO bhi_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","युहन्‌ना लग आखा भगवानेन अघी सी आवणे वाळी वात देखान्‌यान ने मुसान साहरे लिखलो सास्‌तुर भगवानेन अघी सी वात कवता रया। ");
INSERT INTO bhi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ने जी वात मान्‌नु हय ती मानी लेवु की युहन्‌ना हयुत एलीयु जु आवणे वाळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","जतरा बी सामळी रया, चे वारु सामळीन समजणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“मे हीनी पीड़ीन माणसेन बराबरी कुणी सी करो? जे तीनु पुर्‌यान तसा छे, जे हाटे मां बस रहण्‌या पुर्‌या सांय छे, जे आंबा-सांबा आयड़ीन असा कह्‌वे, ");
INSERT INTO bhi_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","हामु तुंद्‌रे वाटे नाचणे पावळी आजाड़्‌या, ने तुहुं नी नाच्‌या; ने हामु तुंद्‌रे वाटे रड़ने करीन गीत गाया, बाकुन तुहुं नी रड़्‌या, ");
INSERT INTO bhi_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","काहाकी युहन्‌‌‌नु ते, रुटु नी खादु ने नीते अंगुरेन रस नी पीदु, ने चे कह्‌वे, ‘तेरे मां भुतड़ान आत्‌मा छे।’ ");
INSERT INTO bhi_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","माणसेन पुर्‌यु खातु-पीतु आयु, ने चे कहें ‘देखु, हीजेरलु ने दारुड़्‌यु छे, ने माणसे सी फाळु लेणे वाळा ने पापीन दुस्‌तीदार छे!’ बाकुन अक्‌कल आपणेन काम सी छाचलु रवसे।” ");
INSERT INTO bhi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","तत्‌यार ईसु तीनु सहर वाळा माणसे काजे कीचवाय्‌न लड़ने बाजी गुयु, तींद्‌रे मां ईसु बेसका ताकुतेन काम करलु, काहाकी चे हींद्‌रो मन नी फेरव्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ए खुराजीन! सहर तुंद्‌रे वाटे बेसकी दुखेन वात छे, ए बेतसेदा सहर! तुंद्‌रे वाटे बेसकी दुखेन वात छे देख ताकुतेन काम तुंद्‌रे मां करला छे, कदी जे सुर सहर ने सीदोन सहर मां करलु रवतु, ती चे गंटाट्‌या पांगरीन, ने हींद्‌रा डील पर रखड़ु चुपड़ीन आपसा-आपसान मन पाप भीणी सी फेरवीन भगवान भीणी अळ जाता। ");
INSERT INTO bhi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","बाकुन मे तुहुंक कहं की, नीयावेन दाहड़े सुर ने सीदोन सहरेन माणसे काजे ज डंड जड़से, तेरे सी बी जादा डंड तुहुं काजे जड़से। ");
INSERT INTO bhi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ए कफरनहुम! काय तु सरगे लग उचु हय जासी काय? नी तु ते पाताळेन बुन्‌दे लग पड़ीन जाती रवसी काहाकी जे ताकुतेन कामे तारे मां करला छे कदी जे काम सदोम सहर मां करतु ती चे आज लग नी सरतो। ");
INSERT INTO bhi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","अतरा मां मे तुहुंक कहं, नीयावेन दाहड़े, सदोम देसेन कुहर्‌या माणसे काजे ज डंड जड़से, तेरेसी बी अदुस डंड तुहुंक जड़से।” ");
INSERT INTO bhi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","तीनी टेमे ईसु कह्‌यु, “ए भगवान, सरगे ने कळीन मालीक, मे तारो तु बेसकु वारु कह्‌वो की तु हीनु वात काजे अक्‌कल वाळा ने समज वाळा सी साताड़ीन मेक्‌यु, ने नानला पुर्‌यु काजे देखाड़ीन आप देदु। ");
INSERT INTO bhi_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हव, ए बास, काहाकी तुसे जन वारु लागे। ");
INSERT INTO bhi_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“मारु भगवान बास मेसे आखो काय आप देदलु छे; ने पुर्‌या काजे छुड़ीन कुय बी बास काजे नी जाणे, हीनीत रीती सी बास काजे छुड़ीन कुय बी पुर्‌या काजे; नी जाणे ने चे तत्‌यारुत बास काजे जाणे तींद्‌रे पर पुर्‌यु बास काजे उजेंतु करे। ");
INSERT INTO bhi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ए आखा हारला ने भार दबायला माणसे, मारे धड़े आवु; मे तुहुंक आराम आपीस। ");
INSERT INTO bhi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","मारो जुड़ो आपणे उपर हाकली लेवु, ने मारे सी सीकु; काहाकी मे नीचळु ने मन मां सुदु छे; ने तुहुं तुंद्‌रा मन मां आराम जड़से। ");
INSERT INTO bhi_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","काहाकी मारो जुड़ो हलको छे ने मारु भार फवरु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","आरामेन दाहड़े ईसु ने हेरा चेला गहुंन खेते मायन जाणे बाजी रवला, ने तेरा चेला काजे भुक लागी तत्‌यार चे गहुंन उम्‌बी तुड़ीन चुळी-चुळीन खाणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","फरीसी माणसे ज्‌य देखीन ईसुक कह्‌या, “देख, तारा चेला ज काम कर रया, चो नीयम कायदा मां लिखलो छे, की आरामेन दाहड़े करनु वारु नी हय।” ");
INSERT INTO bhi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ईसु तीनुक कह्‌यु, “काय तुहुं नी भण्‌या, की खरला सास्‌तुर मां लिखलो छे की दावुद राजा काजे ने, तेरा साते वाळाक भुक लागी तत्‌यार चु काय कर्‌यु? ");
INSERT INTO bhi_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","चु कसु भगवानेन घर मां गुयु, ने चड़ावला रुटा खादु, तीना खाणा काजे नीते खाणु नीते तेरा साते वाळा खाणु, बाकुन मंदीरेन पुजारा वाटे अतरोत खाणेन वारु हतलो? ");
INSERT INTO bhi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ज मुसान साहरे लिखला सास्‌तुर मां नी भण्‌या की मंदीरेन पुजारा आरामेन दाहड़े मंदीर मां आरामेन दाहड़ेन रीती काजे तुड़ देय ती बी चे गुनाळा नी रवे काय? ");
INSERT INTO bhi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","बाकुन मे तुहुं काजे कह्‌व, की भगवानेन सेवान-काम कर रयु चु मंदीर सी बी बेसकु मटु छे। ");
INSERT INTO bhi_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","कदी तुहुं सास्‌तुर मां लिखली वात समजी जाता की, मे दया सी खुस हवो, बाकुन जनवार्‌यान बादा नी चाहजे, ती तुहुं नी-गुनाळा काजे गुनाळु नी ठेह्‌रावता। ");
INSERT INTO bhi_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","माणसेन पुर्‌यु आरामेन दाहड़ान मालीक छे।” ");
INSERT INTO bhi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","चां सी चालीन ईसु तींद्‌रा भक्‌तीन घर मां गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","चां एक माणुस हतलु, तेरु हात पांगळु हतलु चे ईसु पर गुनु लागाड़ने करीन तीनाक असा पुछ्‌या की, “काय आरामेन दाहड़े वारु करनु वारु छे?” ");
INSERT INTO bhi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ईसु तीनु काजे कह्‌यु, “तुंद्‌रे मां असो कुण छे, तेरो एकुत गाडरो छे, ने तेरो गाडरो आरामेन दाहड़े गड्‌डा मां हीटी पड़े, ती चु तीना काजे धरीन बाहार नी नीकाळे काय? ");
INSERT INTO bhi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","माणुस ते गाडरा सी बेसको महंगो छे! तेरेमां आरामेन दाहड़े भलो करनु कायदान अनसारे वारु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","तत्‌यार ईसु तीना माणुस सी कह्‌यु, “तारु हात लांबु कर।” ने चु लांबु कर्‌यु, ने तेरु हात दीसरा हातेन तसु वारु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","तत्‌यार फरीसी माणसे बाहर जाय्‌न ईसुन वीरुद मां असा वीच्‌यार कर्‌या, की हामु ईसुक कसा करीन मारजे। ");
INSERT INTO bhi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ज्‌य जाणीन ईसु चां सी जाती रयु। ने बेसका माणसे तेरे पछळ पड़्‌या। ने ईसु आखा काजे वारु करतेलु। ");
INSERT INTO bhi_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","बाकुन चु असु कय्‌न तीनुक चेतायु, “तुहुं दीसरा माणसे अगळ मारी बड़ाय करीन मेसेक उजेंतु घुण करजु। ");
INSERT INTO bhi_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","काहाकी भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या यसायान बुल पुरो करने करीन चु असु करतेलु; जसों लिखलो छे: ");
INSERT INTO bhi_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“देखु, ज्‌य मारु पावर्‌यु छे, हीनाक मे नेवाड़्‌लु छे, जु मारु लाटेक्‌लु पुर्‌यु छे, हेरेसी मारो मन खुस छे। मे मारी आत्‌मा हेर पर दीस, ने चु नी-यहुदी माणसे काजे नीयावेन खबर आपसे। ");
INSERT INTO bhi_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","चु काहना साते लड़ाय नी करे, नी आयड़े, नी कुय हाटे मां तेरी अवाज सामळसे। ");
INSERT INTO bhi_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","चु कुचळायला बुरे काजे नी तुड़े, ने कुळु आपतेला बामळा काजे नी उलवायणे देय, जत्‌यार लग चु नीयाव काजे आपते लग काम करसे।” ");
INSERT INTO bhi_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","तत्‌यार चे आखा नी-यहुदी माणसे, मारा चेलान आस बण जासे। ");
INSERT INTO bhi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","तत्‌यार माणसे काहनेक दाहड़े आंदळा माणसेक ईसुन्‌चां लाया चु गुंगु बी हतलु, ने तीना माणसेम भुतड़ान आत्‌मा चस्‌टी रवली, ईसु तीना काजे वारु कर्‌यु, ने चु बुलने ने देखणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","तेरेमां आखा माणसे असा कदी नी देख्‌या करीन ईसुन बारामां कहणे बाजी गुया, “हयु दावुदेन अवल्‌यात हसे?” ");
INSERT INTO bhi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","बाकुन फरीसी माणसे असा सामळीन कह्‌या, “ज ते भुतड़ान मुखी बालजबुलेन जुर सी माणसेम डीलेम सी भुतड़ा छेटे करे।” ");
INSERT INTO bhi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ईसु तींद्‌रा मनेन वीच्‌यार जाणीन तीनुक कह्‌यु, “तीना काहना राज मां बेरजु पड़ जाय, च उजड़ी जाय, अळी काहनाक सहर नीते घरन्‌या तेरेमां बेरजु पड़ जाय, ती चे उजड़ी जासे।” ");
INSERT INTO bhi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ने कदी भुतड़ु माणसेन डीलेम सी भुतड़ा काजे नीकाळे, ती हयु आपसान वीरुद करने बाजी जाय, ती हेरो राज कसों बणीन रवसे? ");
INSERT INTO bhi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","कदी मे भुतड़ान मुखीन मदत सी भुतड़ान आत्‌मा काजे नीकाळो ती तुंद्‌रा चेला कुणीन मदत सी भुतड़ा नीकाळे? तेरेमां चेत तुंद्‌रु हीसाब लीन तुंद्‌रु नीयाव करसे। ");
INSERT INTO bhi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","बाकुन कदी मे भगवानेन आत्‌मान मदत सी भुतड़ान आत्‌मा काजे नीकाळो, ती भगवानेन राज तुंद्‌रे ईचमां आय गुयलो छे। ");
INSERT INTO bhi_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","नीते कसों कुय माणुस काहनाक ताकतवाळान घर मां भरायन तेरो धन हापकी सके चां लग की चु तीना ताकतवाळा काजे बांदी नी लेय? ती चु तेरा घरेन माल धन काजे हापकीन ली जाय सके। ");
INSERT INTO bhi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","जे मारे पुठ्‌ये नी हय चे मारे वीरुद मां छे, अळी जु मारे साते भेळो नी करे चु तीनुक खळवणेन काम कर रयु। ");
INSERT INTO bhi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","तेरेमां मे तुहुं काजे कह्‌वो, की माणसेन आखी भातीन पाप अळी खुड़ नीकाळनु माफ हय जासे, बाकुन चुखली-आत्‌मान वाक नीकाळसे तीनुक माफी नी जड़से। ");
INSERT INTO bhi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","जु कुय बी माणसेन पुर्‌यान वीरुद मां काय कह्‌वसे, तीनाक माफी जड़ जासे, बाकुन जु कुय बी चुखली-आत्‌मान वीरुद मां काय बी कह्‌वसे, तेरु पाप नी ते हीनी कळी ने अळी आवणे वाळी कळी मां बी माफी हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“कदी झाड़का काजे वारलु कह्‌वु, ती तेरा फळ काजे बी वारलु कह्‌वु, नीते झाड़का काजे भुंडोत कह्‌वु, ती तेरा फळ काजे बी भुंडोत कह्‌वु, काहाकी झाड़कान उळखान तेरा फळ सी हवे। ");
INSERT INTO bhi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ए, घड़सान पीला, तुहुं भुंडात हयन कसा वारलु वात कय सकु? काहाकी जो मन मां भरायलु छे, चत तुंद्‌रा मुंहडाम सी बाहार आवे। ");
INSERT INTO bhi_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","भलास्‌या माणुस आपणा वारलु कुठा मां सी वारु चीज नीकाळे, ने भुंडात माणुस भुंडा कुठा मां सी भुंडीत चीज नीकाळे। ");
INSERT INTO bhi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“अतरामा मे तुहुं काजे कहं, नीयावेन दाहड़े चे एक-एक फालतु वातेन लेखु आपणु पड़से। ");
INSERT INTO bhi_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","काहाकी तु तुंद्‌री वातेन वजे सी नी-गुनाळु, गीणायसु नीते गुनाळा गीणायसु।” ");
INSERT INTO bhi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","तीनी थुड़ाक यहुदी नीयमेन मास्‌तर्‌या ने फरीसी माणसे ईसुक पारखणे करीन असा कह्‌या, “ए मास्‌तर, हामुक वारलु कामेन सहलाणी देखाड़।” ");
INSERT INTO bhi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","“ईसु तीनुक जपाप आप्‌यु हीनी पीड़ीन कुहर्‌या ने छीनाळ्‌या माणसे एक सहलाणी देखणे हींडे!” बाकुन भगवानेन अघी सी आवणे वाळी वात देखान्‌या योनान सहलाणी अतरीत देखणे जड़से। ");
INSERT INTO bhi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","जसु योना तीन रात ने तीन दाहड़ा माछान पेट मां रवलु तसुत माणसेन पुर्‌यु बी तीन दाहड़ा ने तीन रात धरतीम माहीं रवसे। ");
INSERT INTO bhi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","नीनवे सहरेन माणसे नीयावेन दाहड़े हीनी पीड़ीन माणसे साते उठीन हीनुक डंड जड़े असा ठेरावसे, काहाकी चे योनान परचार सामळीन भीणी सी मन फेरव्‌या; ने देखु, जां चे छे जु योना, सी बी बेसकु मटु छे, भगवानेन वात सामळावण्‌यु उबु हय रयु। ");
INSERT INTO bhi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","दखवरा देसेन राणी नीयावेन दाहड़े हीनी पीड़ीन माणसे साते उठीन तीनुक डंड जड़े असा ठेरावसे, काहाकी ची राणी सुलेमानेन अक्‌कल सामळने करीन धरतीन खुणाम सी आवली, बाकुन देखु, जां छे चु सुलेमान सी बी अदु अकलवाळु उबु हय रयु। ");
INSERT INTO bhi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","जत्‌यार भुतड़ान आत्‌मा काहनाक माणुस काजे छुड़ीन जाती रवे, ती ची आराम करने करीन, उजाड़ी मां जागु हेरतु हींडे, ने जत्‌यार आराम करने करीन जागु नी जड़े। ");
INSERT INTO bhi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","तत्‌यार ची कह्‌वे, मे आपणा तीनात घर मां पछु जाती रय्‌स चां सी मे नीकळीन आवलु छे। ने पछी जाय्‌न तीना घर काजे सुंडलो, बाहरु-सुहरु करीन साप करलो ने जग-जग सींगारलो नर सुंडलो देखाय पड़े। ");
INSERT INTO bhi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","तत्‌यार ची जाय्‌न तेरे सी बी कुहेरला भुतड़ान आत्‌मा काजे भेळा करीन पुठ्‌ये ली आवसे, ने ची तीना माणसेम आवीन वसी जाय, ने च माणुस पेहले सी बी अदु गांडवाय जाय, हीनी कळीन भुंडला माणसेन एला बी असीत हय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","जत्‌यार ईसु माणसेक सीकाड़नेत बाजी रवलु, तत्‌यार हेरी माय ने भायस बाहर उबा हय रवला ने ईसु काजे भेळा हवणे हींडी रवला। ");
INSERT INTO bhi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","काहनुस आवीन ईसु काजे कह्‌यु, “देख, तारी माय ने तारु भायस बाहार हुबा हय रया, चे तुसे काजे भेळा हवणे हींडे।” ");
INSERT INTO bhi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ज्‌य सामळीन ईसु तीनाक कह्‌यु, “कुण छे मारी माय? ने कुण छे मारु भायस?” ");
INSERT INTO bhi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ने हेरा चेला भीणी हेरु हात अगु करीन कह्‌यु, “देखु, मारी माय ने मारु भायस जेत छे। ");
INSERT INTO bhi_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","काहाकी ज्‌य कुय मारा सरगेन बासेन मरजी पर चाले, हीयेत मारु भायस, ने मारी बहणीस, ने मारी माय छे।” ");
INSERT INTO bhi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","तीनेत दाहड़े ईसु घर मां सी नीकळीन दरीयान कीनारे धड़े जाय्‌न बठ गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ने दरीया धड़े ईसुन्‌चां बेसका माणसे आय लाग्‌या, ने चु ढंड्‌या पर चहड़ी गुयु, ने आखा माणसे दरीया धड़े उबा हय रवला। ");
INSERT INTO bhi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ने ईसु तीनुक दाखलु मां बेसकी वात सीकाड़ने बाजी रवलु। एक बीज एरने वाळु किरसाण हेरा खेत मां बीज एरने गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","एरता-एरता थुड़ाक बीज वाट धड़े पड़्‌या ने चिरला आवीन तीनुक ईछीन खाय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","थुड़ाक बीज दगड़ाट्‌या जागा पर पड़्‌या, तीनुक बेसकु धुळु नी जड़्‌यु ने उंडु धुळु नी जड़नेन वजे सी चे छाटा उंगी गुया। ");
INSERT INTO bhi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","बाकुन दाहड़ु उंगीन तप्‌यु ती चे चीमाय गुया, ने मुळ उंडे नी गुया तेरेमां च धान चीमायन सुक गुयो। ");
INSERT INTO bhi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","थुड़ाक बीज झाड़का मां पड़्‌या ने काटाळस्‌या झाड़का मां मटा हय्‌न तीनुक चीबदी लेदा; ने मेर नी पाकी। ");
INSERT INTO bhi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","बाकुन थुड़ाक बीज वारलु जागा पर पड़्‌या, ने काहनाक सोव गुणा ने काहनाक सांठ गुणा काहनाक तीस गुणा पाक्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","जतरा बी सामळी रया, “चे वारु सामळीन समजणु चाहजे!” ");
INSERT INTO bhi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ईसुन चेला धड़े आवीन तीनाक असा पुछ्‌या, “तु माणसे काजे दाखला मां काहा सीकाड़े?” ");
INSERT INTO bhi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ईसु हेरा चेला काजे असु जपाप आप्‌यु, तुहुं काजे सरगेन राजेन बारामां सातायली वात समजणेन वाटु जड़लु छे, बाकुन हाल दीसरा माणसेक नी जड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","काहाकी तेरे धड़े छे, तीना काजे आपसे ने तेरे धड़े बेसका हय जासे बाकुन तेरे धड़े काय बी नी हय तीना काजे ज्‌य काय बी तेरे धड़े छे चो बी मांग लीस। ");
INSERT INTO bhi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","मे हीनु काजे दाखला मां सीकाड़ो; की चे देखता जाय्‌न बी नी देखे ने सामळता जाय्‌न बी नी सामळे, ने नी समजे। ");
INSERT INTO bhi_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","हींद्‌रे बारामां यसायाह ज्‌य भगवानेन अघी सी वात देखाड़ने वाळान पुरी हवे: तुहुं कान्‌टा सी ते सामळसु, बाकुन समजसु नी; ने डुळा सी देखसु, बाकुन तुहुंक नी पल्‌ले पड़े। ");
INSERT INTO bhi_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","काहाकी हीनु माणसेन मन मटो हय गुयो, ने चे कान्‌टा सी जुर सी सामळे, ने चे तींद्‌रा डुळा काजे मीच लेदला छे; काय असो नी हवे की चे डुळा सी देखे, ने कान्‌टा सी सामळे, ने मन सी समजे, ने पछा फीर जाय, मे तीनुक वारु करीस। ");
INSERT INTO bhi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","बाकुन बरकतवाळा छे तुंद्‌रा डुळा, की चे हय वारु देखे; ने बरकतवाळा छे तुंद्‌रा कान्‌टा हय चे वारु सामळे। ");
INSERT INTO bhi_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","काहाकी मे तुंद्‌रे सी छाचलीन कह्‌वो की बेसका भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌यान अळी धरमी ने चाह्‌या की जी वाते तुहुं देखु, ची देखे, बाकुन नी देख्‌या; ने ज्‌य वात तुहुं सामळु, ची सामळे, बाकुन नी सामळ्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“हय तुहुं बीज एरने वाळान दाखलान मतलब सामळु। ");
INSERT INTO bhi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ज्‌य कुय राजेन बुल सामळीन नी समजे, तेरा मन मां ज्‌य काय बीज एरलो हतलो, तीना काजे च भुतड़ो आवीन भगवानेन बुल हापकीन लीन जाती रवे। जु हयुत छे, ज वाटे धड़े बीज एरलो हतलो। ");
INSERT INTO bhi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","चापर्‌या वाळी जागा मां पड़ला बीज तीनु माणसेन सहलाणी छे चे भगवानेन बुल सामळतात खुस हय्‌न मान लेय। ");
INSERT INTO bhi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","बाकुन मुळे उंडा नी हवणेन वजे सी चे थुड़ाक दाहड़ा जीवे, ने जत्‌यार बुलेन वजे सी दुख नीते वेला हवे ती तत्‌यारुत भुरसु करनु छुड़ देय। ");
INSERT INTO bhi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","जे बीज काटाळस्‌या मां पड़्‌या, चे बीज माणसेन सहलाणी छे जे भगवानेन बुल काजे सामळे ते खरा, बाकुन अळी चे जीवणेन फीकुर करीन ने मातला बन्‌ने हेर करीन भगवानेन बुल काजे दड़पी देय, ने चे फळ नी लावे। ");
INSERT INTO bhi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ज्‌य वारलु जागा मां बीज एरलो छे, ज्‌य हयुत छे, भगवानेन बुल काजे सामळीन समजे, ने फळ लावे; कुय सोव गुणा, कुय सांठ गुणा, ने कुय तीस गुणा।” ");
INSERT INTO bhi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ईसु तीनुक एक अळी दाखलु कह्‌यु: “सरगेन राज तीना माणसेन तसों छे, चु तेरा खेत मां वारलु बीज एरलु छे। ");
INSERT INTO bhi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","बाकुन जत्‌यार माणसे सुवणे बाजी रवला, ती तेरु वेरी आवीन गहुं मां जळ-गहुं एरीन जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","जत्‌यार डीरा नीकळे ने पान्‌टा लाग्‌या ती जळ-गहुंन बीज देखाव पड़े। ");
INSERT INTO bhi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","अतरामा पावर्‌या मालीकेन घर आवीन मालीक काजे कह्‌या, ए मालीक, तु ते तारा खेत मां वारलु गहुंन बीज नी एरलु? ती जळ-गहुंन कसा उंग्‌या? ");
INSERT INTO bhi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ईसु तीनुक कह्‌यु, ज काहना वेरीन काम छे। ती पावर्‌या तीनाक पुछ्‌या ‘काय तारी मरजी हय?’ ती हामु जाय्‌न तीनु जळ-गहुं काजे उखाळ देजे। ");
INSERT INTO bhi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","मालीक कह्‌यु, ‘नी, असा मां करु नीते कांखुर मायन जळ-गहुं भेळा वारलु गहुं बी उखळी जासे। ");
INSERT INTO bhi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","काटणे लग दुयु काजे एक साते मटा हवणे देवु ने काटणेन टेम मां काटणे वाळा सी कवीस की पेहल जळ-गहुं भेळा करीन धपाड़ने करीन हींद्‌रा गाठड़ा बांद लेवु, ने गहुं काजे मारा खळा मां भेळा करु।’” ");
INSERT INTO bhi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ईसु तीना काजे एक अळी दाखलु कह्‌यु: “सरगेन राज रायन दाणान तसों छे, तीना काजे कुय एक माणुस लीन आपणा खेत मां चुप देदु। ");
INSERT INTO bhi_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","च ते दीसरा आखा बीज सी नानो ते देखाये बाकुन जत्‌यार मटो हय जाय तत्‌यार आखा झाड़का सी डाळ बण जाय ती सरगेन चिरला आवीन पुत्‌रा बांदी लेय।” ");
INSERT INTO bhi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ईसु तीनुक अळी एक दाखलु: “सामळायु सरगेन राज तीना खाण्‌या-सुडान तसों छे, तीना काजे एक काहनीक बायरी लीन तीन चोवकी पीठा मां भेसकी, ने आखा पीठान खटासो हय ज्‌य।” ");
INSERT INTO bhi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ईसु जी आखी वात दाखलु दीन माणसे काजे सीकाड़तेलु, ने तीनुक दाखला पाखुर ईसु तीनुक काय बी नी सीकाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","की ज बुल भगवानेन अघी सी आवणे वाळी वात देखाड़ने वाळान साहरे असु कह्‌लु, “मे दाखलु कह्‌वणे करीन मारो मुंहडो खुलीस; मे तीनी वात काजे जी कळी घड़लु ती सी ढाकायली वात उजेंतु कयस।” ");
INSERT INTO bhi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","तत्‌यार चु टुळा काजे छुड़ दीन घर मां आयु, ने तेरा चेला तेरे धड़े आवीन कह्‌या, “खेतेन जळ-गहुंन दाखलान मतलब काय हवे चो हामुक समजाड़ी दे।” ");
INSERT INTO bhi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ईसु तीनुक जपाप आप्‌यु, “वारलु बीज एरने वाळु किरसाण, माणसेन पुर्‌यु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ने खेत जी कळी छे, वारलु बीज भगवानेन राजेन माणसे छे, ने जळ-गहुंन बीज कुहर्‌या वेरीन माणसे छे। ");
INSERT INTO bhi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","चु वेरी जळ-गहुं एर्‌यु चु भुतड़ु छे; काटणी कळी मां खत्‌तम हवणी छे, ने काटण्‌यु सरग वाळा काहवाळ्‌या छे। ");
INSERT INTO bhi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","जसा माणसे जळ-गहुं भेळा करीन धपाड़ी देय, तसीत जी कळी खत्‌तम मां हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","माणसेन पुर्‌यु तेरा सरग वाळा काहवाळ्‌या काजे मकलसे, ने चे तींद्‌रा राज मां सी आखा पाप करने वाळा काजे भगवानेन राजेम सी अलग करीन तीनुक भेळा करसे। ");
INSERT INTO bhi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ने तीनुक आकठान डहरा धकली देसे, चे माणसे आकठी मां बेसका रड़से ने दात ककड़ावता रवसे। ");
INSERT INTO bhi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","तीनी टेमे वारलु माणसे आपणा बासेन राज मां दाहड़ान तसा चमकसे। जतरा बी सामळी रया, चे वारु सामळीन समजणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“सरग वाळा भगवानेन राज खेत मां सातायला धनेन तसों छे, तीनाक काहनाक माणुस काजे जड़्‌यो ने साताड़ी देदु, ने धव हयु ने जाय्‌न तेरो आखो काय हतलो चो वेची देदु ने तीना खेत काजे मुल ली लेय। ");
INSERT INTO bhi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“अळी सरगेन राज एक धंदु करने वाळान तसों छे, चु वारलु मोतीन हेर मां हतलु। ");
INSERT INTO bhi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","जत्‌यार तीना काजे एक बेसका महंगलो मोती जड़ी गुयो, ती हयु जाय्‌न आखो काय हतलो चो वेची देदु, ने तीनी मोती काजे मुल ली लेदु। ");
INSERT INTO bhi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“सरगेन राज तीना मटला जाळेन तसों छे, ज दरीया मां नाख्‌यु, ने आखी भातीन माछा काजे सेमटी लावे। ");
INSERT INTO bhi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ने जत्‌यार आखी जाळ माछा भराय जाय, ती माछा धरने वाळा तीना काजे भेळा करे, ने बठीन वारलु-वारलु माछी काजे ते ठाहरा मां भेळा कर्‌या, ने रद्‌दी-रद्‌दी काजे नाख देदा। ");
INSERT INTO bhi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","कळी खत्‌तम हवणेन टेमे बी असोत हवसे। सरग वाळु काहवाळ्‌यु धरती पर आखी दुर जासे, वारलु माणसेन ईचमां सी पापी काजे अलग करसे, ");
INSERT INTO bhi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","अळी तीनु काजे आकठान डहरा मां नाख देसे। चां चे माणसे तीना आकठान डहरा मां बेसका रड़से ने दात ककड़ावता रवसे। ");
INSERT INTO bhi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“ईसु तेरा चेला काजे कह्‌यु तुहुं जी आखी वात काजे समजी गुया काय?” चे ईसुक कह्‌या “हव।” ");
INSERT INTO bhi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ईसु तीनुक कह्‌यु, “तेरेमां एक-एक यहुदी धरमेन कायदु सीकाड़ने वाळु मास्‌तर्‌यु जु सरगेन राजेन चेलु बण्‌यु, तीना घरेन मालीकेन तसु छे, चु आपणा कुठाम सी नवली ने जुन्‌डली चीज नीकाळे।” ");
INSERT INTO bhi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","जत्‌यार ईसु जु आखु दाखलु कय देदु, ती चां सी जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ने नासरत सहर मां आय्‌न तींद्‌रा भक्‌तीन घर मां तीनुक असु सीकाड़ने बाजी गुयु, ती चे चकराय गुया ने कह्‌णे बाजी गुया, “हीना काजे अतरी अक्‌कल ने ताकुतेन काम करनेन जुर कां सी जड़्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","काय जु सुतारेन पुर्‌यु नी हय? ने काय हेरी आयसेन नाव मरीयम, ने तेरा भायसेन नावे याकुप, युसुफ, सीमोन ने यहुदा हेरात भायस छे। ");
INSERT INTO bhi_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ने हेरी आखी बहणीस हामरे ईचमां ते रवे? ती हीनाक जी अक्‌कल ने जुर कां सी जड़्‌यु? ");
INSERT INTO bhi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","चे नासरत सहर वाळा, ईसु पर भुरसु नी कर्‌या, तेरेमां ईसु तीनुक कह्‌यु, “भगवानेन अघी सी आवणे वाळी वात देखाड़ने वाळाक आपणा सहर ने आपणात घर मां ईज्‌जत नी जड़े।” ");
INSERT INTO bhi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","माणसेन नी भुरसा देखीन, ईसु चां बेसका ताकुतेन काम नी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","तीनी टेमे गलील जीलान राज करन्‌यु हेरोदेस राजु ईसुन बारामां सामळ्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ने हेरा पावर्‌या काजे कह्‌यु, “गुयु युहन्‌ना बपतीस्‌मा आपणे वाळु छे! चु मर्‌या-सर्‌याम सी जीवतु हय ज्‌य, तेरेमां बेसका मटा ताकुतेन काम देखाड़ने बाजी रयु।” ");
INSERT INTO bhi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","काहाकी हेरोदेस राजु हेरा भायस फीलीप्‌युसेन बायरी हेरोदीयासेन वजे, सी युहन्‌ना काजे धरीन बांदीन जेल मां नाख देदा। ");
INSERT INTO bhi_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","काहाकी युहन्‌ना तीना काजे कह्‌लु की भायसेन बायरी काजे राखणु तारे वाटे वारु नी हय। ");
INSERT INTO bhi_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","तेरेमां चु युहन्‌ना काजे माराने हींडी रवलु, बाकुन गड़दी वाळा माणसे सी बीहतेलु काहाकी चे युहन्‌ना काजे भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌यु मानतेला। ");
INSERT INTO bhi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","बाकुन जत्‌यार हेरोदेस राजु पयदा हवलु चु दाहड़ु आयु, ती हेरोदीयासेन पुरे हेरोदेस राजु तेरा मेजवान्‌यान ईचमां नाचीन देखाड़ी ने हेरोदेस राजु देखीन खुस हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","तेरेसी ज देखीन हेरोदेस राजु सगुन खाय्‌न वायदु कर्‌यु, “जो काय तु मांगसी, च मे तुसेक आप दीस।” ");
INSERT INTO bhi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","हेरी माय हीनीक पेहलुत सीकाड़ देदली, “बपतीस्‌मा आपण्‌या युहन्‌नान मुणको तळी मां हींताळुत मांगाड़ीन आप दे।” ");
INSERT INTO bhi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","हेरोदेस राजु दुखी हयु, बाकुन हेरी सगुन, ने मेजवान्‌यान वजे सी, तीनी पुरेन वात नी काट्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","हेरोदेस राजु जेल मां युहन्‌नान मुणको काटीन लावु करीन माणसे काजे मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ने युहन्‌नान मुणको तळी मां लाया, ने तीनी पुरे काजे आप देदा, मुणको ची पुरे हेरी माय काजे आप देदी। ");
INSERT INTO bhi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","तत्‌यार युहन्‌नान चेला आया, जी वात सामळीन जेल मां गुया ने तेरा डील काजे ली जाय्‌न गाड़ देदा, ने अळतेन जाय्‌न ईसु काजे खबर कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","जत्‌यार ईसु युहन्‌नान मरनेन खबर सामळ्‌यु, ती ईसु ढंड्‌या पर चहड़ीन चां सी काहनीक सुनसान जागा मां, एखलुत जाती रयु। माणसे ज सामळीन सहर-सहर सी नीकळीन ईसु पछळ चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ईसु ढंड्‌याम सी उतर्‌यु ती एक बेसकु मटु माणसेन टुळु देख्‌यु, ने तीनाक तीनु माणसे पर दया आय, ने तींद्‌रा मांदला काजे वारु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","जत्‌यार सांती वेळाय तेरा चेला ईसु धड़े आवीन कह्‌या, “जी सुन्‌ली जागा छे, ने दाहड़ु ढळ गुयु; तेरेमां हय हीनु माणसे काजे जाणी दे, की जे गांव मां जाय्‌न आपणे-आपणे वाटे रुटा मुल ली लेय।” ");
INSERT INTO bhi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ईसु चेला काजे कह्‌यु, “हीनुक मकलनु जरुड़ी नी हय! तुहुंत हीनु काजे काहीस खाणे आपु।” ");
INSERT INTO bhi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","चेला ईसुक कह्‌या, “जां हामरे धड़े पांच रुटा ने दुय माछा छे अळी दीसरो काय बी नी हय।” ");
INSERT INTO bhi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ईसु कह्‌यु, “चे रुटा ने माछा काजे मारे धड़े लावु।” ");
INSERT INTO bhi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","तत्‌यार ईसु माणसे काजे चारा पर बठणे करीन कह्‌यु, ने तीनु पांच रुटा ने दुय माछा काजे लेदु; ने सरगे भीणी भाळीन भगवान काजे कह्‌यु तु बेसकु वारु छे करीन कह्‌यु, माछा ने पांच रुटा तुड़ी-तुड़ीन चेला काजे आप्‌यु, ने चेला माणसे काजे आप्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","जत्‌यार आखा माणसे खाय्‌न आफरी गुया, ती चेला बचला रुटान टुकड़ा सी बारे चार्‌या भराय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ने खाणे वाळा बायरा ने पुर्‌या काजे छुड़ीन, पांचेक हजार अदमीत हतला। ");
INSERT INTO bhi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","तत्‌यार हयु तत्‌काल हेरा चेला काजे ढंड्‌या पर चहड़ने करीन कह्‌यु, मे माणसे काजे मकलो चां लग पली धड़े जाती रवु। ");
INSERT INTO bhi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","चु माणसे काजे मकलीन, दुवा करने करीन बयड़ा पर जाती र्‌यु; ने सांतु लग ईसु चां एखलुत हतलु। ");
INSERT INTO bhi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","तीनी टेमे ढंड्‌यो दरीयान ईचमां सहर सी बेसके छेटे हतलो ने लहर सी अथोन-अथो हालतेलो, काहाकी आहळो सांबो सी आवतेलो। ");
INSERT INTO bhi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ने ईसु कुकड़ा वासणीक पाणी पर चालीन तींद्‌रे भीणी आयु। ");
INSERT INTO bhi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","चेला ईसु काजे पाणी पर चालीन आवतेलु देखीन घाबराय गुया। ने आयड़ीन कह्‌या, “जु ते भुतड़ु छे करीन!” ने बीही गुया जुर सी आयड़ने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","तत्‌यार ईसु तीनुक कह्‌यु, “हिम्‌मत राखु! मेत छे, बीहु मां।” ");
INSERT INTO bhi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पतरस ईसु काजे कह्‌यु, “ए मालीक, कदी तुत छे, ती मेसे तारे धड़े पाणी पर चालीन आवणेन हुकुम आप।” ");
INSERT INTO bhi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ईसु हुकुम कह्‌यु, “आव!” तत्‌यार पतरस ढंड्‌या पर सी उतरीन ईसु भीणी पाणी पर चालीन जाणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","बाकुन आहळी काजे देखीन बीही गुयु, ने जत्‌यार डुबणे बाजी गुयु ती आयड़ीन कह्‌यु, “ए मालीक मेसे बचाड़!” ");
INSERT INTO bhi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ईसु तत्‌यारुत हात अगु करीन तीना काजे धर लेदु, “ने कह्‌यु, ए कम भुरसु करन्‌या, तु काहा संक्‌या कर्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","जत्‌यार ईसु पतरस भेळु ढंड्‌या मां चड़ गुयु, ती आहळी हुगी रय गुय। ");
INSERT INTO bhi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","तेरेमां जे ढंड्‌या बठी रवला चेला ईसुन पाये पड़ीन आंध्‌या ने कह्‌या, “छाचलीन, तु भगवानेन पुर्‌यु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","अळतेन चे पली धड़ गन्‌नेसरत सहर मां आया। ");
INSERT INTO bhi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ती चां वाळा माणसे ईसु काजे उळखी लेदु ने आड़े-धड़ेन आखा देस मां खबर मकल्‌या ने आखा मांदला काजे ईसु धड़े लाया, ");
INSERT INTO bhi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ने ईसु सी लीलघाय्‌न कह्‌णे लाग्‌या, की चु तीनुक तारा पुथल्‌यान कुर अतरुत छीमणी दे; ने जतरा तीना काजे धर्‌या ने चे वारु हय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","तत्‌यार यरुसलेम सी थुड़ाक फरीसी माणसे ने यहुदी नीयमेन मास्‌तर्‌या ईसु धड़े आवीन असा पुछ्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“तारा चेला डाहा-बुड़ा रीती-भाती काजे काहा नी पाळता? ने हीया मुयळा हय बी हात नी धुवे ने रुटा खाय?” ");
INSERT INTO bhi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ईसु तीनुक कह्‌यु, “तुहुं तुंद्‌रा डाहा-बुड़ान रीती नेम पाळने करीन भगवानेन हुकुम काहा तुड़ रया?” ");
INSERT INTO bhi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","काहाकी भगवानेन कवलु, तारा आयस-बासेन अबरु राख्‌जी, ने जे कुय बास नीते माय काजे भुंडात करीन कहें, तीनाक मार नाखु। ");
INSERT INTO bhi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","बाकुन तुहुं कह्‌वु की कदी कुय आपणा आयस-बास सी असु कय देय, गुयो काय बी मे तुहुंक आप सकतेलु, चो मे भगवान काजे भेट चड़ाय देदु। ");
INSERT INTO bhi_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","असो नी हय की आपणा आयस-बासेन अबरु नी करे, तेरेन तसा तुहुं बी तुंद्‌रा डाहा-बुड़ान रीती सीकाड़ीन भगवानेन बुल काजे टाळ देवु। ");
INSERT INTO bhi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ए ढंगड़ा करन्‌या! यसायाह तुंद्‌रे बारामां जी भगवानेन अघी सी आवणे वाळी वात देखाड़्‌यु वारु कवली छे, ");
INSERT INTO bhi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","जे माणसे मुंहडा पर ते मारी ईज्‌जत करे, बाकुन हींद्‌रो मन मारे सी छेटे रवे। ");
INSERT INTO bhi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ने जे असलात मारी भक्‌ती करता रवे, काहाकी माणसेन रीत काजे भगवानेन कायदु छे, करीन सीकाड़े। ");
INSERT INTO bhi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","तत्‌यार ईसु माणसे काजे तेरे धड़े बुलायन तीनुक कह्‌यु, तुहुं आखा मारी “सामळु, ने समजु। ");
INSERT INTO bhi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ज्‌य मुंहडा मां जाय, च माणसे काजे नी वीटाळे, बाकुन गुयो मुंहडा सी नीकळे, चत माणसे काजे वीटाळे।” ");
INSERT INTO bhi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","तत्‌यार चेला आवीन ईसु काजे कह्‌या, “काय तु जाणे की फरीसी माणसे काजे ज्‌य बुल सामळीन तीनुक वारु नी लाग्‌यो?” ");
INSERT INTO bhi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ईसु जपाप आप्‌यु, “ज रुपो मारु सरगेन बास नी चुप्‌यु, तीनाक उखाळी नाख देसे। ");
INSERT INTO bhi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","हीनु काजे रहणी देवु; जे आंदळा छे, ने आंदळा कदी आंदळा काजे वाट देखाड़े ती दुयु डहरा मां कुद पड़से।” ");
INSERT INTO bhi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","जी वात सामळीन पतरस ईसु काजे कह्‌यु, माणसेन मुंहडाम कथो नीकळे च माणुस काजे वीटाळ देय च काय छे, “जु दाखलु हामु काजे समजाड़ दे।” ");
INSERT INTO bhi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ईसु कह्‌यु, “काय तुहुं बी हय लग नी पल्‌ले नी पड़्‌यो काय? ");
INSERT INTO bhi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","काय तुहुं नी जाणु की ज्‌य काय मुंहडा मां जाय च पेट मां पड़े ने बाहरा बठणे जाय ती नीकळी जाय? ");
INSERT INTO bhi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","बाकुन ज्‌य काय मुंहडाम सी नीकळे, ची वात माणसेन मन सी नीकळे, ने जीत वात माणसे काजे वीटाळ देय। ");
INSERT INTO bhi_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","काहाकी भुंडला वीच्‌यार माणसेम सी हव तींद्‌रा मनेम सी नीकळे, हत्‌या, बायरी साते भुंडोत काम छीनाळो, झुटी गवाय ने वाक नीकाळनु मन मां सी नीकळे। ");
INSERT INTO bhi_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","आखी भुंडीत वात माणसेन मन मां सी नीकळे, बाकुन हात नी धुवे ने रुटा खाय ती माणुस काजे नी वीटाळे।” ");
INSERT INTO bhi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ईसु चां सी नीकळीन, सुर ने सेदा ईलाका भीणी जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","तीना परदेस सी एक कनानी जातीन बायरी नीकळीन आवी, ने आयड़ीन-आयड़ीन कवती रय, “ए मालीक! दावुदेन अवल्‌यात, मार पर दया कर! मारी पुरेन भुतड़ु चस्‌टी रयु, ने ची बेसकी एला कर रय।” ");
INSERT INTO bhi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","बाकुन ईसु तीनी काजे काय बी जपाप आप्‌यु। तत्‌यार ईसुन चेला ईसुन्‌चां आवीन ईसु सी लीलघाय्‌न कह्‌या की “हीनीक मकली, काहाकी हयी हामरे पछळ आयेड़ती-आयेड़ती आय रय।” ");
INSERT INTO bhi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ईसु जपाप आप्‌यु, “भगवान मेसेक ईस्‌रायेली जातीन माणसेन्‌चां अतरुत मकली रयु, जे खुवायला गाडरान तसा छे, ने भगवान सी छेटे हय रया।” ");
INSERT INTO bhi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","बाकुन ची बायरी आयन, ने ईसु काजे आंधीन कह्‌णे बाजी गुय, “ए मालीक मारी मदत कर।” ");
INSERT INTO bhi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","बाकुन ईसु दाखलान साहरे तेरु भुरसु देखीन जपाप आप्‌यु, “पुर्‌या धड़े सी रुटु लीन कुतरा अगळ नाखणु वारु नी हय।” ");
INSERT INTO bhi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ची बायरी बी तीनाक दाखला मां एक कड़ी जुड़ीन जपाप आपी, “छाचलीन वात छे मालीक! तेबी कुतरा मालीकेन ईस्‌टाळा रुटान बटका ते खाय लेय।” ");
INSERT INTO bhi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","तेरी वात सामळीन ईसु तीनी काजे जपाप आप्‌यु, “ए बायरी, तारु भुरसु बेसकु मटु छे। तारी मरजी पुरी हवे।” ने तत्‌यारुत तेरी पुरे वारु हय गुय। ");
INSERT INTO bhi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ईसु चां सी जात रयु, ने गलील दरीया धड़े पुगीन, एक बयड़ा पर चहड़ीन बठ गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","तत्‌यार बेसका माणसेन टुळा की टुळा ईसु धड़े आया। चे आपणे साते लंगड़ा, आंदळा, गुंगा, ठटळ्‌या ने दीसरा मांदला काजे ईसु धड़े लाया, ने तीनुक ईसुन पाये पर नाख देदा, ने ईसु तीनुक वारु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","जत्‌यार माणसे देख्‌या की गुंगा बुलने बाजी गुया, ने ठटळ्‌या वारु हय जाय, ने भागड़ा चाले, ने आंदळा देखे ती ज्‌य देखीन चकराय गुया ने ईस्‌रायेली जातीन भगवानेन बड़ाय कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","तत्‌यार ईसु तेरा चेला काजे साते बुलायु ने कह्‌यु, “मेसेक ईनु माणसे टुळा पर दया आवे, काहाकी जे तीन दाहड़ा लग मार साते छे, ने हींद्‌रे धड़े खाणे काय बी नी हय। मे तीनुक भुकला पछा मकलने नी चाहतु, काय असो नी हय जाय की वाटेत झामा खाय्‌न हीट पड़से।” ");
INSERT INTO bhi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","तेरा चेला ईसु काजे कह्‌या, “हामु काजे हीना उजाड़्‌या बयड़ा मां ईनु माणसेक खावाड़ने करीन अतरा रुटा कां सी लावजे?” ");
INSERT INTO bhi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ईसु तीनु काजे पुछ्‌यु, “तुंद्‌रे धड़े कतरा रुटा छे।” चे कह्‌या, “सात रुटा, ने थुड़ाक नानला माछा छे।” ");
INSERT INTO bhi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","तत्‌यार ईसु माणसे काजे भुयमां बठणेन हुकुम आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ने तीनु सात रुटा ने माछा काजे हात लेदु। ने तु बेसकु वारु छे करीन भगवान काजे कह्‌यु, ने भांजी-भाजीन हेरा चेला काजे आपतु गुयु ने चेला माणसे काजे वाटता गुया। ");
INSERT INTO bhi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","आखा खाय्‌न आफरी गुया ने चेला बचला टुकड़ा सी सात चार्‌या भर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","खाणे वाळा बायरा ने पुर्‌या काजे छुड़ीन चार हजार अदमी हतला। ");
INSERT INTO bhi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","तत्‌यार ईसु माणसेन टुळा काजे मकलीन ढंड्‌या मां बठीन, ने मगदन मुलके मां जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","फरीसी माणसे ने सदुकी माणसे ईसु धड़े आया, ईसु काजे पारखणे करीन असा पुछ्‌या, “हामुक सरगेन काहींग सहलाणी देखाड़ तत्‌यार हामु तार पर भुरसु करजे की तु भगवानेन अगु सी आवलु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ईसु तीनुक कह्‌यु, “सांती वेळाय तुहुंक कहं, ‘मुसुम वारु रवसे, काहाकी सरग रातलो छे।’ ");
INSERT INTO bhi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ने संदारे एगात कह्‌वे, ‘आज आंधी आवसे, काहाकी सरगे रातलो आदळो छावाय रयो।’ तुहुं सरग भीणी देखीन जाण लेवु, बाकुन तुहुं हीनी टेमेन सहलाणीन बारामां राज काजे देखीन नी जाणाये। ");
INSERT INTO bhi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","हीनी पीड़ीन भुंडा ने छीनाळ्‌या माणसे सहलाणी हेरे, बाकुन योनान सहलाणी काजे छुड़ीन तुहुंक अळी काय बी सहलाणी नी जड़े।” जी वात कय्‌न ईसु तीनुक छुड़ीन हेरा चेला पुठ्‌ये दीसरे जागे जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","चेला दरीयान पली धड़े गुया, बाकुन चे रुटा ली जाणु वीसरी गुयला। ");
INSERT INTO bhi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ईसु तीनुक कह्‌यु, “देखु, फरीसी माणसे ने सदुकी पंथवाळा खाण्‌या-सुडा सी चेतीन रवजु।” ");
INSERT INTO bhi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","चे आपसा-आपसा कह्‌णे बाजी गुया, “आपणु रुटा नी लाया तेरेमां ईसु असु कय रयु।” ");
INSERT INTO bhi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ईसु तींद्‌रा वीच्‌यार काजे जाणीन कह्‌यु, “कम भुरसु करने वाळा, तुहुं तुंद्‌रा मन मां असा काहा वीच्‌यार करु की रुटा नी लाया करीन ईसु असु कर रयु? ");
INSERT INTO bhi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","काय तुहुं हाल लग नी समज्‌या? काय तुहुं काजे तीनु पांच हजारेन पांच रुटा हेर नी आवता, तीने टेमे तुहुं कतरा मटला चार्‌या भरला? ");
INSERT INTO bhi_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","मे तीनु चार हजार माणसे काजे सात रुटा, आफरीन खावाड़लु तीने टेमे तुहुं कतरा चार्‌या भरला? ");
INSERT INTO bhi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","तुहुं काहा नी समजता की, मे तुहुंक रुटान बारामां जो नी कह्‌यु, बाकुन मे ते फरीसी माणसे ने सदुकी माणसेन खाण्‌या-सुडा सी चेतीन रवजु करीन कह्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","तत्‌यार चे समजी गुया की ईसु, रुटान पीठाम भेसकण्‌या खाण्‌या-सुडान बारामां सी नी, बाकुन, फरीसी माणसे ने सदुकी सीकापण सी चेतीन रवजु करीन कवलु। ");
INSERT INTO bhi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ईसु केसर्‌या फीलीप्‌या परदेस मां आयु, ने हेरा चेला सी पुछणे आपसान बारामां असु पुछ्‌यु, “माणसे माणसेन पुर्‌या काजे काय कय रया?” ");
INSERT INTO bhi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","चे कह्‌या, “काहनाक ते युहन्‌ना बपतीस्‌मा आपणे वाळु कह्‌वे, ने काहनाक एलीयाह, ने काहनाक यीर्‌मयाह नीते भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌या मां सी काहनुक एक हसे करीन कहें।” ");
INSERT INTO bhi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ज सामळीन ईसु तीनुक कह्‌यु, “बाकुन तुहुं मेसे काजे काय कह्‌वु?” ");
INSERT INTO bhi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","सीमोन पतरस कह्‌यु, “तु जीवता भगवानेन पुर्‌यु मसी छे।” ");
INSERT INTO bhi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ईसु तीना पतरस काजे कह्‌यु, “ए सीमोन, योनान पुर्‌या, तु वारु छे; काहाकी सीकार ने लुही नी, बाकुन मारु बास सरगे मां छे, चु जी वात तुसे बताड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ने मे तुसेक कहं की तु पतरस छे, ने मे हीना दगड़ा पर आपणी मंडळी बणावीस, ने पाताळेन जुर तीना पर जुर नी कर सके। ");
INSERT INTO bhi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","मे तुसे काजे सरगेन राजेन कुची आपीस, ने ज काय तु कळी पर बांदीस, च सरगे मां बांदायसे, ने ज काय तु धरती पर छुड़सी, च सरग मां उघड़से।” ");
INSERT INTO bhi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तत्‌यार ईसु आखा चेला काजे चेताय्‌न कह्‌यु, की कुयक बी घुण कहुं की मे मसी छे। ");
INSERT INTO bhi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","तीनी टेमे सी ईसु आपणा चेला काजे समजाड़ने बाजी गुयु, “जरुरी छे की, मे यरुसलेम मां जाम ने डाहा-बुड़ा माणसे, ने मुख्‌या पुजारान, ने यहुदी नीयमेन मास्‌तर्‌या मेसे काजे एला पाड़से, ने मार नाखसे; ने तीसरे दाहड़े मे मर्‌या-सर्‌याम सी जीवतु हय जायस।” ");
INSERT INTO bhi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","पतरस ईसु काजे अगु ली जाय्‌न असु कय्‌न लड़्‌यु, “भगवान असु नी करे! मालीक तारे साते असो कदी नी हवे।” ");
INSERT INTO bhi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ईसु पछु फीरीन पतरस काजे कह्‌यु, “ए भुतड़ा, मारे धड़े सी छेटु जाती रव! तु मारे वाटे अड़चन बण रयु, काहाकी तु ते भगवानेन वात पर नी, बाकुन माणसेन वात पर मन लागाड़ीन कहणे बाजी रयु।” ");
INSERT INTO bhi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","तत्‌यार ईसु हेरा चेला काजे असु कह्‌यु, “कदी कुय मारु चेलु बणीन मारे पछळ आवणे हींडे, ती आपणे आप काजे भुल जाय ने आपसान कुरुस हाकलीन, मारा कह्‌याम चालनु पड़से। ");
INSERT INTO bhi_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","काहाकी जु कुय बी आपणा जीव काजे बचाड़ने चाहसे, चु तेरा जीव काजे खुय देसे, ने जु कुय बी मारे वाटे जीव खुवसे, चु तीना जीव काजे हेर लेसे। ");
INSERT INTO bhi_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","कदी माणुस आखी कळीन चीज काजे हेर लेय, ने आपसान जीव काजे खुय देय, ती तीना काजे काय फायदु जड़से? नीते माणुस आपणा जीवनेन आवजी मां काय आपसे। ");
INSERT INTO bhi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","माणसेन पुर्‌यु आपणा सरग काहवाळ्‌या साते आपणा बासेन सेक-सींगार मां आवसे, ने तीनी टेमे हीयु आखा काजे हींद्‌रा काम काजे देखीन ईनाम आपसे ने ते तीनु माणसेक डंड जड़से। ");
INSERT INTO bhi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","मे तुंद्‌रे सी छाचलीन कहं, की जे जां उबा हय रया, माणसे मां सी काहनाक असा छे, की जां लग माणसेन पुर्‌या काजे तेरा राज मां आवतेलु नी देखी नी लेय, तत्‌यार लग नी मरे।” ");
INSERT INTO bhi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","छव दाहड़ा हय गुया ने अळतेन ईसु पतरस ने याकुप ने तेरा भायस युहन्‌ना काजे पुठ्‌ये ली लेदु, ने तीनुक अगु एक मटला बयड़ा पर ली गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","तींद्‌रे अगळ ईसुन सीकु बदली गुयु, ने तेरो मुंहडो दाहड़ान तसों चमकणे बाजी गुयो, ने तेरा पुथल्‌या वीजाळान तसा चमकणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ने तीनु चेला काजे मुसु ने एलीयु ईसु साते वात करतेला देखाव पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","तेरेसी पतरस ईसु काजे कह्‌यु, “ए मालीक, आपणो जां रहणु वारु छे! कदी तारी मरजी हय ती मे जां तीन खपड़ी बणाय दम; एक तारे वाटे, ने एक मुसा वाटे, ने एक एलीया वाटे।” ");
INSERT INTO bhi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","चु ज कवणेत बाजी रवलु ने एक वीजाळो आदळो तीनुक ढाक लेदो, ने तीना आदळा मां सी ज सामळ्‌या, “जु मारु लाटेक्‌लु पुर्‌यु छे, हेरेसी मे बेसकु खुस छे: हेरीत वात सामळीन मानु!” ");
INSERT INTO bhi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","चेला असा सामळीन मुंहडान भुरसे पड़्‌या, ने बेसका बीही गुया। ");
INSERT INTO bhi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","तत्‌यार ईसु धड़े आवीन तीनुक कह्‌यु, “उठु, बीहु मां।” ");
INSERT INTO bhi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","तत्‌यार चे उचा भाळ्‌या, ती चां ईसु अतरुत देखाव पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","जत्‌यार ईसु तीने बयड़े सी उतरने बाजी रवलु ती तीनु चेलाक हुकुम आपीन असु कह्‌यु, “जत्‌यार लग माणसेन पुर्‌यु मर्‌या-सर्‌याम सी जीवतु नी हवे, तत्‌यार लग ज काय बी तुहुं देखला छे च कुय काजे घुण कह्‌वु।” ");
INSERT INTO bhi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","मरनेन वात काटणे करीन चेला ईसुक असा पुछ्‌या, “ती यहुदी नीयमेन मास्‌तर्‌या काहा कह्‌वे की एलीयान पेहेल आवणु टाकलो छे?” ");
INSERT INTO bhi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ईसु तीनुक जपाप आप्‌यु, “हव, असो लिखलो छे की एलीयु छाचलीन आवसे, ने आखो काय सुदारसे। ");
INSERT INTO bhi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","बाकुन मे तुंद्‌रे सी कह्‌वो, की एलीयु आय गुयु, ने माणसे तीना काजे नी उळख्‌या; बाकुन जसों चाह्‌या असोत तेरे साते कर्‌या। हीनी रीत सी माणसेन पुर्‌यु बी हींद्‌रे हात सी दुख हाकलसे।” ");
INSERT INTO bhi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","तत्‌यार चेला ज समजी गुया की ईसु आपणु काजे युहन्‌ना बपतीस्‌मा आपणे वाळान बारामां कवणे बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ने जत्‌यार ईसु ने तीन चेला बयड़े सी उतरीन माणसेन टुळु वाट देख रवलु ती, ती एक माणुस ईसु धड़े आयो, ने मांडा टेकीन कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ए मालीक, मारा पुर्‌यु पर दया कर! काहाकी तीना काजे मीरगीन मांदवाड़ छे, ने चु बेसकु एला करे; ने पछुत-पछु आकठा मां ने पाणी मां पड़ जाय। ");
INSERT INTO bhi_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","मे हीना काजे तारा चेला धड़े लावलु, बाकुन चे वारु कर नी सक्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","तीनाक असु कवतेला सामळीन ईसु चां भेळा हय रवला आखा माणसेक कह्‌यु, “ए भुरसु नी करने वाळा, मे कत्‌यार लग तुंद्‌रे साते रवीस? कत्‌यार लग तुहुंक सेण करतु रवीस? हीना पुर्‌या काजे मारे धड़े लावु।” ");
INSERT INTO bhi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","तत्‌यार ईसु तीना भुतड़ान आत्‌मा काजे लड़्‌यु, ने ची तीना पुर्‌या मां सी नीकळी गुय; ने चो पुर्‌यो तत्‌यारुत वारु हय गुयो। ");
INSERT INTO bhi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","अळतेन ईसु एखलुत हतलु तत्‌यार हेरा चेला आवीन तीनाक पुछ्‌या, “हामु हीना भुतड़ा काजे काहा नी नीकाळ सक्‌या?” ");
INSERT INTO bhi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ईसु तीनुक कह्‌यु, “तुंद्‌रा भुरसु नी हवणेन वजे सी, काहाकी मे तुंद्‌रे सी छाचलीन कह्‌वो, कदी तुंद्‌रु भुरसु रायन दाणान बराबर बी रवसे, ती हीना बयड़ा सी कवसु, जां सी सरकीन वां जाती रव, जां सी सरकीन छेटु हय जासे; ने काय बी वात तुंद्‌रे वाटे नी हवे असी नी रवे। ");
INSERT INTO bhi_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","बाकुन जी भुतड़ान जातीन दुवा ने उपास पाखुर नी नीकळे।” ");
INSERT INTO bhi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","जत्‌यार चे भेळा हय्‌न गलील जीला मां आया, ती ईसु हींद्‌रे सी कह्‌यु, “माणसेन पुर्‌यु माणसेन हात मां धराय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ने माणसे तीनाक मार नाखसे, ने चु तीन दाहड़ा मां मर्‌या-सर्‌याम सी जीवतु हय जासे।” ज सामळीन चेला काजे बेसको दुख लाग्‌यो। ");
INSERT INTO bhi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","तत्‌यार चे कफरनहुम सहर मां गुया ती मंदीरेन फाळु मांगणे वाळा पतरस धड़े आवीन पुछ्‌या, “तुंद्‌रु मास्‌तर मंदीरेन फाळु नी आप्‌तु काय?” ");
INSERT INTO bhi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","पतरस कह्‌यु, “हव, आपे।” जत्‌यार चु घर मां आयु, ती ईसु पतरस काजे पुछणे सी पेहलुत ईसु तीना काजे पुछ्‌यु, “ए सीमोन तु काय वीच्‌यार रयु? हीनी कळीन राजा फाळु काहना माणसे सी लेय आपसान पुर्‌या सी की दीसरा माणसे सी फाळु लेय?” ");
INSERT INTO bhi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पतरस ईसु काजे कह्‌यु, “दीसरा माणसे सी।” ईसु पतरस काजे कह्‌यु, “ती पुर्‌या काजे फाळु नी आपणु पड़े। ");
INSERT INTO bhi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","बाकुन तेबी आपणु हीनु माणसे काजे नराज नी करता, तु दरीया धड़े जाय्‌न गळी नाख, ने जी माछी पेहेल नीकळे, हीनीक लीन; तेरो मुंहडो उघाड़ने सी तुसे काजे एक सीक्‌कु जड़से, तीना सीक्‌का काजे लीन मारे ने तारे वाटेन करीन आप देजी।” ");
INSERT INTO bhi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","तीनी टेमे चेला ईसु धड़े आवीन पुछ्‌या, “सरग वाळा भगवानेन राज मां आखा सी मटु कुण छे?” ");
INSERT INTO bhi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","तत्‌यार ईसु एक नानला पुर्‌या काजे धड़े बुलायन हींद्‌रे ईचमां उबु कर्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ने कह्‌यु, “मे तुंद्‌रे सी छाचलीन कहं की जत्‌यार लग तुहुं पाप भीणी सी मन नी फेरवु चां लग तुहुं हीना नानला पुर्‌यान तसा नी बणु, तत्‌यार लग तुहुं सरगेन राज मां नी जाय सकु।” ");
INSERT INTO bhi_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","जु कुय बी आपसा काजे हीना नानला पुर्‌यान तसु नानलु बणसे, चु सरग वाळा भगवानेन राज मां आखा सी मटु बण जासे। ");
INSERT INTO bhi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ने जु कुय बी मारा नाव सी एक असला नानला पुर्‌यान आव-भाव करसे, चु मारु आव-भाव करे। ");
INSERT INTO bhi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“बाकुन जु कुय बी हीनु नानला मां सी जे मारे पर भुरसु करे ने एक काजे ठुकर खावाड़ेन वजे बणे, तेरे वाटे ते ज वारु छे की मट्‌ली घट्‌टीन पुड़ तेरे गळा मां बांदीन, नेचु उंडला समुदर मां डुब जाय। ");
INSERT INTO bhi_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ठुकरेन वजे हीनी कळी पर बेसकी दुखेन वात छे! पापेन वजे ते बन्‌नु छे, बाकुन बेसकी दुखेन वात छे तीना माणुस वाटे तेरे साहरे पापेन उत्‌तर बणे। ");
INSERT INTO bhi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“कदी तारु हात नीते तारु पाय तुसेक ठुकर खावाड़से, ती तीना काजे काटीन नाख दे, चो तारे वाटे वारु छे, ने लुला नीते भागड़ा हय्‌न जीवनेन राज मां भरायणु तारे वाटे वारु छे, नीते दुय हात ने दुय पाय रवे तेबी तु अमरेन नरकेन आकठा मां नाखाय जाय। ");
INSERT INTO bhi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","कदी तारा डुळा तुसेक ठुकर खावाड़से, ती तीना काजे नीकाळीन नाख दे, ने काणु हय्‌न जीवनेन राज मां भरायणु तारे वाटे वारु छे, नीते दुय डुळा रवे ने तु नरकेन आकठा मां नाखाय जाय। ");
INSERT INTO bhi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“देखु, तुहुं हीनु नानला मां सी काहनाक काजे नानु घुण समजे, काहाकी मे तुंद्‌रे सी कह्‌वो की सरग मां हींद्‌रा सरग वाळा काहवाळ्‌या मारा सरगेन बासेन मुंहडो जलम देखे। ");
INSERT INTO bhi_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","काहाकी माणसेन पुर्‌यु तीनु काजे हेरने करीन आवलु छे, चे भगवान सी छेटे हय्‌न खुवाय गुयला छे। ");
INSERT INTO bhi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“तुंद्‌रु काय वीच्‌यार छे? कदी काहनाक माणसेन सोव गाडरा रवे; ने तींद्‌रे मां सी एक खुवाय जाय, ती काय चु एक कम सोव गाडरा काजे रहणीदीन, बयड़ा पर जाय्‌न तीनु खुवायला काजे नी हेरे? ");
INSERT INTO bhi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ने कदी असो हवे की चु तीना काजे जड़ जाय, ती मे तुहुंक छाचलीन कह्‌वो की हयु तीनु एक सोव गाडरा सी अतरु खुस नी हवे, जतरु एक गाडरा सी खुस हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","असुत तुंद्‌रा सरग वाळा बासेन मरजी जीत छे, असी मरजी नी हय की हीनु नानला मां सी एक बी खत्‌तम हय जाय। ");
INSERT INTO bhi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“कदी तारु भाय तारे वीरुद मां गुनु करे, ती जां अलग ली जाय्‌न वात करीन तीनाक समजाड़; कदी चु तारी सामळे ती, तु तारा भायस काजे हेर लेदु। ");
INSERT INTO bhi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","कदी चु नी सामळे, ती अळी एक नीते दुय जणा काजे साते लीन जां, की ‘एक-एक गुनु दुय नीते तीन जणान गवा छाचली हय जाय असो चुखली-सास्‌तुर मां लिखलो छे।’ ");
INSERT INTO bhi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","कदी चु तींद्‌री बी नी माने, ती मंडळी मां कय दे, बाकुन कदी हयु वां बी नी माने ती तु तीना काजे नी-यहुदी ने फाळु लेणे वाळान तसु जाण। ");
INSERT INTO bhi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“मे तुहुंक छाचलीन कह्‌वो, ज काय तुहुं कळी पर बांदसु, च सरग मां बांदायसे, ने ज काय तुहुं कळी पर उघाड़सु, च सरग मां उघड़से। ");
INSERT INTO bhi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“अळी मे तुंद्‌रे छाचलीन सी कहं, कदी तुंद्‌रे मां सी दुय जणा धरती पर काहनीक वात वाटे एक मन्‌या हय्‌न मांगसे, ती च मारा बास भीणी सी जु सरग मां छे, हींद्‌रे वाटे हय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","काहाकी जां दुय नीते तीन मारा नाव सी भेळा हवसे, ती मे तींद्‌रे ईचमां रव।” ");
INSERT INTO bhi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","तत्‌यार पतरस धड़े आवीन ईसु सी कह्‌यु, “ए मालीक, कदी मारु भाय गुनु करतुत रवे, ती मे कतरा कावा तीना काजे माफ करीस? काय सात कावा लग?” ");
INSERT INTO bhi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ईसु पतरस काजे कह्‌यु, “मे तारे सी ज नी कव की सात कावा लग, बाकुन सात कावा नी बाकुन सत्‌तर गुणा लग माफ करजी। ");
INSERT INTO bhi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“तेरेमां सरगेन राज, तीना राजान तसों छे, चु आपणा पावर्‌या सी लेखु लेणे चाहे। ");
INSERT INTO bhi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","जत्‌यार चु लेखु लेणे बाजी गुयु, ती तेरे अगळ एक जणाक लाया, तेरे पर राजान कुरुड़ु रुप्‌यान करजु हतलु। ");
INSERT INTO bhi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","बाकुन करजु छुटणे तेरे धड़े काय नी हतलो, ती मालीक कह्‌यु, गुयु हेरी बायर, ने पुर्‌या-पारी अळी ज काय तारो छे, आखो वेच दम, ने करजु देवाय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","तत्‌यार चु पावर्‌यु पाय मां पड़ीन मालीक काजे आंध्‌यु ने कह्‌यु, ‘ए मालीक दम धर, मे आखो काय छे चो आप दीस।’ ");
INSERT INTO bhi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","तत्‌यार तीना पावर्‌यान मालीक दया करीन तेरा करजा काजे माफ कर देदु, ने तीना काजे छुड़ देदु ने। ");
INSERT INTO bhi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“बाकुन जत्‌यार चु पावर्‌यु बाहार नीकळ्‌यु, ती तेरु साते वाळु पावर्‌या मां सी एक जणु तीना काजे भेळु हयु, चु तेरा सोव चांदीन रुप्‌यान करजा वाळु हतलु; चु तीना काजे धर्‌यु ने तेरो गळु चीपदीन कह्‌यु, ‘ज्‌य काय बी तारे पर करजु छे चु आप देजी।’ ");
INSERT INTO bhi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","तेरेसी तेरु साते वाळु पावर्‌यु भुयमां पड़ीन लीलघाय्‌न कह्‌यु, ‘दम धर, मे मारु आखु करजु आप दीस।’ ");
INSERT INTO bhi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","चु नी मान्‌यु, बाकुन जाय्‌न तीना काजे जेल मां नाख देदु की जत्‌यार लग चु करजु नी आप देय तत्‌यार जात रवसे। ");
INSERT INTO bhi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","तेरे साते वाळा दीसरा पावर्‌या ज्‌य हयो च देखीन दुखी हया, ने जाय्‌न तींद्‌रा मालीक काजे आखी वात कय देदा। ");
INSERT INTO bhi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तत्‌यार तेरु मालीक तीना पावर्‌या काजे बुलायु ने कह्‌यु, ‘ए भुतड़ा पावर्‌या, तु जु मारे सी लीलघाय्‌न कह्‌यु, ने मे तारु आखु करजु माफ कर देदु। ");
INSERT INTO bhi_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ती जसु मे तार पर दया कर्‌यु, असुत काय तु बी तारा साते वाळा पावर्‌या पर दया नी करनु चाहजे।’ ");
INSERT INTO bhi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ने तेरु मालीक रीसवाय गुयु ने तीना काजे डंड देणेवाळान हात मां आप देदु, की जत्‌यार लग चु आखु करजु नी आप देय, तत्‌यार लग हींद्‌रा हात मां रवे। ");
INSERT INTO bhi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“हीनीत रीते कदी तुंद्‌रे मां सी कुय आपणा भाय काजे मन सी माफ नी करे, ती मारु बास सरगे मां छे, तुहुंक बी माफ नी करे।” ");
INSERT INTO bhi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","जत्‌यार ईसु जी वात कय देदलु, ती गलील जीला मां जाती रयु; ने यरदन नदीन पली धड़े यहुदीया जीला मां गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","तत्‌यार माणसेन मट्‌लु टुळु ईसु पछळ चाली पड़्‌यु, ने ईसु चां मांदला माणसे काजे वारु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","तत्‌यार फरीसी माणसे ईसुन पारख करने ईसु धड़े आवीन पारखणे करीन असा पुछ्‌या, “काय काहना बी उत्‌तर सी आपणी बायर काजे छुड़नु वारु छे?” ");
INSERT INTO bhi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ईसु कह्‌यु, “काय तुहुं चुखली सास्‌तुर मां नी भण्‌या की, जु तीनुक बणायु चु सुरु सी अदमी ने बायरी काजे बणायु। ");
INSERT INTO bhi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ईनी वजे सी माणुस आपणा आयस-बास सी अलग हयन, आपसी बायरी साते रवसे ने चे दुयु जणा एक डील बणीन रवसे। ");
INSERT INTO bhi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","अळतेन चे हय सी दुय नी, बाकुन एक डील छे। तेरेमां तीनाक भगवान जुड़लु छे, तीना काजे माणुस अलग नी करे।” ");
INSERT INTO bhi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","चे ईसु काजे पुछ्‌या, “ती मुसु ज्‌य काहा हुकुम आप्‌यु की छुड़णेन चिट्‌ठी आपीन घरवाळीक छुड़नु?” ");
INSERT INTO bhi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ईसु तीनुक कह्‌यु, “मुसु तुंद्‌रे मनेन कयड़ाळा वजे सी तुहुंक आपणी-आपणी बायर काजे छुड़ देणेन हुकुम आप्‌यु, बाकुन सुरु सी असो नी हय। ");
INSERT INTO bhi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ने मे तुंद्‌रे सी कह्‌व की, जे दीसरान उतरेन वजे सी आपणी बायर काजे छुड़ीन दीसरी सी ईयाव करे चु छीनाळो करे ने जे हीनी छुल्‌ली सी ईयाव करसे चु बी छीनाळो करे।” ");
INSERT INTO bhi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","चेला ईसुक कह्‌या, “कदी अदमीन बायर साते असु वेहवार छे, ती ईयाव करनु वारु नी हय।” ");
INSERT INTO bhi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ईसु तीनुक कह्‌यु, “आखा जणा जी सीकापण हुकारी नी सके तीनु काजे अतरुत ज्‌य वाटु आपलु छे। ");
INSERT INTO bhi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","काहाकी काहनाक हीजड़ा असा छे, जे मायन पेट मां सी असा पयदा हवला छे; ने काहानाक हीजड़ा असा छे, तीनुक माणसे हीजड़ु बणाया; ने काहानाक हीजड़ा असा छे, चे सरगेन राज वाटे आपसा काजे हीजड़ा बणावला छे। जे तीना काजे हुकार सके चे हुकार लेय।” ");
INSERT INTO bhi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","तीनी टेमे थुड़ाक माणसे नानला पुर्‌या काजे ईसु धड़े लाया; की चु हींद्‌रे पर हात मेले ने दुवा करे, ईसुन चेला तीनु माणसेक लड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ईसु कह्‌यु, “पुर्‌या काजे मारे धड़े आवणे देवु, ने हीनुक मां रुकु, काहाकी सरग वाळा भगवानेन राज असलात छे।” ");
INSERT INTO bhi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ने चु पुर्‌या पर हात मेलीन संयबरकत आपीन चां सी जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","एक माणुस ईसु धड़े आवीन पुछ्‌यु, “ए मास्‌तर, मे काहनो भलो काम करो की जलमेन जीवाय जड़े?” ");
INSERT INTO bhi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ईसु तीना काजे कह्‌यु, “तु मारे सी भलायन बारामां काहा पुछे? वारु ते एकुत छे, कदी तु जीवन मां जाणे चाहे ती भला काम करने वाळा भगवानेन हुकुम काजे मान्‌या कर।” ");
INSERT INTO bhi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","चु ईसुक कह्‌यु, काहनी हुकुम ईसु कह्‌यु, “खुन घुण करे।” छीनाळो घुण करे, झुट घुण देय; ");
INSERT INTO bhi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","आपणा बास ने आपणी मायन वात माननु, ने आपणे चांदे वाळा सी परम करजी। ");
INSERT INTO bhi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","चु जुवान ईसु काजे कह्‌यु, “जी आखी हुकुम काजे ते मे मानो; हय मारेमां काहानी वातेन कसर छे।” ");
INSERT INTO bhi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ईसु तीना काजे कह्‌यु, “कदी तु पाक्‌कु बन्‌ने चाहे ती जां तारा धन काजे वेचीन गरीब काजे आप दे, ने तुसे सरगे मां धन जड़से; ने तु मारु चेलु बणीन मारे पुठ्‌ये चाल।” ");
INSERT INTO bhi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","बाकुन चु जुवान ईसुन वात सामळीन नराज हय्‌न जाती रयु, काहाकी चु बेसकु धन वाळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","तत्‌यार ईसु तेरा चेला काजे कह्‌यु, “मे तुंद्‌रे सी छाचलीन कह्‌व की धन वाळा माणसे काजे सरग वाळा भगवानेन राज मां जाणु काठो छे। ");
INSERT INTO bhi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","तुंद्‌रे सी अळी कह्‌व की, भगवानेन राज मां धन वाळा काजे भरायणु उटड़ान सुईन नाचका मां भरायणु जादा सरल छे।” ");
INSERT INTO bhi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ज्‌य सामळीन चेला बेसका घाबराय्‌न, “कवणे लाग्‌या पछे कुणीन छुटकारु हवसे?” ");
INSERT INTO bhi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ईसु तींद्‌रे भीणी एक हेट्‌यु भाळीन कह्‌यु, “माणसे सी ज नी बणे, बाकुन भगवान सी आखो काय कर सके।” ");
INSERT INTO bhi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ती पतरस ईसु काजे कह्‌यु, “देख, हामु ते आखो काय छुड़ीन तारा चेला बण गुयला छे। ती हामुक काय जड़से?” ");
INSERT INTO bhi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ईसु तीनुक कह्‌यु, मे तुंद्‌रे सी छाचलीन कह्‌वो, की नवली कळी मां जत्‌यार माणसेन पुर्‌यु आपणी सेक-सींगारेन राजगादी पर बठसे, ती तुहुं बी जे मारे पछळ आवला छे, बारे राज गादी पर भरायन ईस्‌रायेलेन बारे खानदानी पर नीयाव करसु। ");
INSERT INTO bhi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ने जु कुय बी घर, नीते भायसेक, नीते बहणीस, नीते बास, नीते माय, नीते नानला पुर्‌या नीते खेते काजे मारा नाव वाटे छुड़ देदला छे, तीना काजे सोव गुणा फळ जड़से, ने चे जलम जीवनेन हकदार्‌या बी हय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","बाकुन बेसका माणसे हय अगळ छे, चे पछळ हय जासे, ने जे हय पछळ छे, चे अगळ हय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","सरग वाळा भगवानेन राज तीना किरसाणेन तसों छे, चु तेरी अंगुरेन वाड़ी मां दाहड़क्‌या लागाड़ने करीन संदारे एगुत घर सी नीकळ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","चु दाहड़क्‌या काजे चांदीन एक रुप्‌या मां दाहड़की राखलु, ने तीनुक तेरी अंगुरेन वाड़ी मां मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","अळतेन चु नव बजेन नीकळीन दीसरा माणसे काजे हाटे मां रीकामा उबा हय रवला देखीन। ");
INSERT INTO bhi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","तीनुक कह्‌यु, तुहुं बी मारी अंगुरेन वाड़ी मां जावु, मे तुहुंक वारु दाहड़की आपीस। ");
INSERT INTO bhi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ने चे बी वाड़ी मां काम करने करीन जाती रया, अळतेन चु बारे बजे ने तीनेक बजे खयड़े नीकळीन असुत दाहड़क्‌या हेरने करीन गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","अळतेन चु पांचेक बजे अळी खयड़े नीकळ्‌यु चां दीसराक अळी उबा हय रवला देखीन तीनुक कह्‌यु, “तुहुं काहा जां दाहड़ु भरीन रीकामा उबा हय रया।” ");
INSERT INTO bhi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","चे तीना काजे कह्‌या, हामुक काहनु बी दाहड़की नी लागाड़्‌यु करीन हामु जां उबा हय रया। चु तीनु काजे कह्‌यु, तुहुं बी मारी अंगुरेन वाड़ी मां काम करने जावु। ");
INSERT INTO bhi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","सांती वेळाय अंगुरेन वाड़ीन मालीक, आपसा मुनीम सी कह्‌यु, दाहड़क्‌या काजे बुलायन लाव पछेन आवणे वाळा सी लागाड़ीन पेहल आवणेवाळा लग, आखाक दाहड़की आप दे। ");
INSERT INTO bhi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","जत्‌यार चे आया, ती चे पांच बजे कामे लागला, ती चु मुनीम तीनुक काजे चांदीन एकेक रुप्‌यु आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","जत्‌यार चे पेहल दाहाड़क्‌या आवला, चे असा समजी गुया की हामुक अदुस आपसे, बाकुन चु तीनुक बी चांदीन एकेक रुप्‌युत आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","जत्‌यार पयस्‌या लीन चे खेतेन मालीक पर कुर-कुर करने बाजी गुया, ");
INSERT INTO bhi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","चे कह्‌या जे पछला ते एकतु घंटु काम कर्‌या, ने तेबी तु तीनुक हामरे बराबर दाहड़की आप्‌यु, ने चे दाहड़ु भरीन भार हाकल्‌या ने तप काजे झेल्‌या? ");
INSERT INTO bhi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","तींद्‌रे मायन एक असु जपाप आप्‌यु, ए दुस्‌त, मे तारे सी काय बी बयमानी नी करो, मे तुसेक दाहड़ान दाहड़की चांदीन एक रुप्‌यु आपीस करीन तीयार नी हयु? ");
INSERT INTO bhi_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ज्‌य तारो छे, चो हाकलीन जाती रव; मारी मरजी असी छे, की जतरो तुसे आखो आप्‌यु ततरोत हीना पछळ आवला काजे बी आपो। ");
INSERT INTO bhi_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","काय ज्‌य सय नी हय काय मे मारा पयस्‌या सी ज्‌य चाहो चो करो? तु मारी भलाय देखीन मार पर काहा कुहराय रयु? ");
INSERT INTO bhi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","हीनी रीती सी जे हय अगळ छे, चे पछळ हय जासे; ने जे पछळ छे, “चे अगळ हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ईसु यरुसलेम सहरेन वाट्‌ये अगु जाणे बाजी रवलु। ती चु बारे चेला काजे अथु ली जाय्‌न तीनुक कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“देखु, हामु यरुसलेम सहर मां जाणे बाजी रया; ने माणसेन पुर्‌यु मुख्‌या पुजारान ने यहुदी नीयमेन मास्‌तर्‌या हात मां धराय जासे, ने चे तीना काजे मारनेन डंड सामळावसे। ");
INSERT INTO bhi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ने चे तीना काजे नी-यहुदी माणसेन हात मां आपसे, की चे तीना काजे हासी मां उडाड़से ने सपाटा देसे ने कुरुस पर चड़ावसे, ने चु तीन दाहड़ाम मर्‌या-सर्‌याम सी जीवतु हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","तत्‌यार जब्‌दीन पुर्‌यान माय, आपणा पुर्‌या काजे साते लीन ईसु धड़े आवीन आंधी, ने तेरे सी थुड़ोक मांगणे बाजी गुय। ");
INSERT INTO bhi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ईसु तीनीक पुछ्‌यु, “तुसेक काय चाहजे।” ची कय, “जे मारा दुय पुर्‌या छे। तु तारा राज मां ईनु मायन एक तारे जेवड़्‌या हात भीणी ने एक तारे डाखर्‌या हात भीणी बसणेन हक आपजी।” ");
INSERT INTO bhi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ईसु जपाप आप्‌यु, “तु नी जाणु की काय मांग रय। जु मे दुखेन पीयालु मे पीणेवाळु छे, तुहुं तीना दुखेन पीयाला काजे पी लेसु काय?” चे तीना काजे कह्‌या तु कह्‌यु तसोत हामु करसु। ");
INSERT INTO bhi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","तत्‌यार ईसु तीनुक कह्‌यु, “तुहुं मारु कटवरु ते पीसु, बाकुन मारे जेवड़्‌ये ने डाखर्‌ये हात मां काहानाक बी बठाड़नु मारो काम नी हय, बाकुन हींद्‌रे वाटे मारा बास भीणी सी तीयार करलो छे।” ");
INSERT INTO bhi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ज्‌य सामळीन दस चेला तीनु दुय संगा भायस पर रीसाय पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ईसु आपसा चेला काजे धड़े बुलायन कह्‌यु, “तुहुं जाणु की नी-यहुदी राजा हींद्‌रे पर राज करे; ने जे मटला छे, चे हींद्‌रे पर हक जमाड़े। ");
INSERT INTO bhi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","बाकुन तुंद्‌रे मां असला हकेन कायदु नी रहणु चाहजे; बाकुन जु कुय तुंद्‌रे मां मटा हवणे हींडे चु तुंद्‌रे मां पावर्‌यु बणसे। ");
INSERT INTO bhi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ने चु तुंद्‌रे मां मुख्‌यु बणने हींडे, चु तुंद्‌रु आखान पावर्‌यु बणसे। ");
INSERT INTO bhi_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","काहाकी माणसेन पुर्‌यु; ईनी कळी मां आपसी चाकरी कराड़ने नी, बाकुन आपसुत चाकरी करने, ने बेसका जणान जीव काजे छुड़ावने करीन आवलु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","जत्‌यार चे यरीहो सहरेम सी नीकळीन जाणे बाजी रवला, ती माणसेन एक मट्‌लु टुळु ईसु पछळ चाल पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ने चां सयड़क धड़े दुय आंदळा, जे बठला हतला, जत्‌यार चे जो सामळ्‌या की ईसु जाणे बाजी रवलु, ती चे आयड़ी-आयड़ीन कह्‌वणे बाजी गुया “ए मालीक, दावुदेन अवल्‌यात, हामरे पर दया कर।” ");
INSERT INTO bhi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","माणसे तीनु आंदळा काजे हुगा हय रवु; करीन तीनुक लड़्‌या, बाकुन अळी बी आयड़ीन कह्‌या, “ए मालीक दावुदेन अवल्‌यात, हामरे पर दया कर।” ");
INSERT INTO bhi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ईसु हुबु हयन तीनुक बुलायु ने कह्‌यु, “तुहुंक काय चाहजे?” मे तुंद्‌रे वाटे करो। ");
INSERT INTO bhi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","चे कह्‌या “ए मालीक, हामरा डुळा उघड़ी जाणु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ईसु काजे तींद्‌रे पर दया आय तींद्‌रा डुळा धर्‌यु ने चे तत्‌यारुत देखणे बाजी गुया; ने ईसु पछळ चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","जत्‌यार चे यरुसलेम धड़े गुया, ने जेतुन बयड़ा पर बेतफगे गांव धड़े आया, ती ईसु आपसा दुय चेला काजे ज्‌य कय्‌न मकल्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“तुहुं पलो सांबो देखाये, तीना फळ्‌याम जावु। ने चां पुगतेत तुहुंक एक गदड़ी बांदली देखाव पड़से, ने तेरे पुठ्‌ये पीलो बी तुहुंक देखाव पड़से। तीना गदड़ाक छुड़ीन मार धड़े ली आवु। ");
INSERT INTO bhi_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","कदी तुहुंक कुय काय कह्‌वे, ती तीनाक तुहुं असा कह्‌जु, मालीक काजे जो गदड़ो चाहजे ती कवजु की मालीक काजे हेरो काम छे, तत्‌यार चु तत्‌काल तीनुक मकली देसे।” ");
INSERT INTO bhi_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ज्‌य तेरेमां हयो की, ज्‌य बुल भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌या माणसेन साहरे कह्‌लो चो पुरो हय जाय: ");
INSERT INTO bhi_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सीयोनेन सहरे मां रहण्‌या माणसेक कह्‌वु, देख, तुंद्‌रु राजु तुंद्‌रे धड़े आवणे बाजी रयु। चु भुळु छे, चु गदड़ी पर बस रयु, बाकुन पीला पर सवारी कर रयु।” ");
INSERT INTO bhi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","चेला चाल पड़्‌या, ने चे ईसु कह्‌यु तसोत चे कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ने गदड़ीक ने पीला गदड़ाक ली आया, तेरे पर आपसा साल्‌या तीनु गदड़ाक पांगराय देदा, ने ईसु पीला गदड़ा पर सवारी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","तत्‌यार बेसका माणसे आपसा साल वाट मां आथर्‌या, ने थुड़ाक माणसे झाड़कान डाळ्‌या काटीन वाट मां आथरीन तेरो आव-भाव कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ईसुन अगळ-अगळ जाता जाय्‌न ने पछळ-पछळ चालीन आवता जाय्‌न, जुर सी आयड़ी-आयड़ीन कवतेला, “दावुद राजान अवल्‌यात काजे होसान्‌ना कवतेला, जु भगवान मालीकेन नाव सी आवे, चु बरकतवाळु छे, आखाम सरगे मां रहण्‌या भगवानेक बी होसान्‌ना कवतेला।” ");
INSERT INTO bhi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","जत्‌यार ईसु यरुसलेम मां पुग्‌यु, ती आखा सहरेन माणसे कलो-कलो करता, जाय्‌न पुछणे बाजी गुया, ज्‌य कुण छे? ");
INSERT INTO bhi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","तत्‌यार ईसु पुठ्‌ये आवला माणसे कह्‌या, “भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌यु ईसु छे, जु गलील जीलान नासरत सहर वाळु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ईसु भगवानेन मंदीर मां जाय्‌न तीनु आखा काजे, जे मंदीर मां लेणु देणु करतेला, तीनुक बाहर नीकाळ देदु, चु पयस्‌या आटे-साटे करन्‌यान टेबल्‌या ने पेरवा वेचण्‌यान चारला अंधला देदु। ");
INSERT INTO bhi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ने तीनुक असु कह्‌यु, “चुखला सास्‌तुर मां लिखलो छे, की ‘मारो घर दुवान घर कह्‌वायसे।’ बाकुन तुहुं ते हीना काजे धाड़ु पाड़न्‌या ने चुट्‌टान खंगरु बणाय देदा!” ");
INSERT INTO bhi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","मंदीर मां आंदळा ने भागड़ा, ईसु धड़े आया, ने चु तीनुक वारु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","बाकुन जत्‌यार मुख्‌या पुजाराक ने यहुदी धरम सीकाड़न्‌‌या मास्‌तर्‌या ईसुन मटला काम काजे, ने ज्‌य ईसु कर्‌यु, ने पुर्‌या काजे मंदीर मां दावुदेन अवल्‌यात काजे होसान्‌ना करीन आयड़तेला देख्‌या, ती चे बेसका रीसवाय गुया, ");
INSERT INTO bhi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ने चे ईसु काजे कह्‌या, “जे काय कवणे बाजी रया चो तु सामळे काय?” ईसु तीनुक कह्‌यु, “हव सामळी रयु; तुहुं ज्‌य चुखली सास्‌तुर मां नी भण्‌या काय? पुर्‌या ने दुत पीण्‌या नानला पुर्‌यान मुंहडा सी तु आपसुत गुण गावाड़लु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","अतरामा कय दीन ईसु तीनुक छुड़ीन सहर मां बाहार नीकळीन बेतन्‌या गांव मां जाती रयु ने चांहान आखी रात रयु। ");
INSERT INTO bhi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","दीसरे दाहड़े ईसु अगुत सहर भीणी जाणे बाजी रवलु, ती ईसु काजे भुक लागी। ");
INSERT INTO bhi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","सयड़केन धड़े अंजीरेन एक झाड़को देखीन चु तेरे धड़े गुयु, ने पान्‌टा काजे छुड़ीन चां काय नी जड़्‌यो तीना अंजीरेन झाड़काक कह्‌यु, “हय सी तारे मां जलम नी फळ लागणु चाहजे।” ने अंजीरेन झाड़को तत्‌यारुत सुक गुयो। ");
INSERT INTO bhi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ज्‌य देखीन चेला घाबराय गुया ने चेला कह्‌या, “ज्‌य अंजीरेन झाड़को तत्‌काल कसों सुक गुयो।” ");
INSERT INTO bhi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ईसु तीनुक कह्‌यु, “मे तुंद्‌रे सी छाचलीन कह्‌वो, कदी तुहुं भुरसु करु ने मन मां संक्‌या नी करु, ती जसु मे अंजीरेन झाड़काक कह्‌यु तसत हय गुयो तसात तुहुं बी कवसु तेबी हय जासे, बाकुन कदी तुहुं हीना बयड़ा सी बी कवसु की, उखळीन जां, ने समुदर मां जाय्‌न पड़ जां, ती तसों हय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ने ज्‌य काय तुहुं दुवा मां भुरसु करीन मागंसु ती चो भगवान तुहुंक आप देसे।” ");
INSERT INTO bhi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ईसु मंदीर मां जाय्‌न सीकाड़ने बाजी रवलु, ती मुख्‌या पुजारा ने डाहा-बुड़ा माणसे ईसु धड़े आवीन पुछ्‌या, “तु ज्‌य आखो काम कुणीन हक सी करे? ने ज्‌य हक तुसे कुण आप्‌यो?” ");
INSERT INTO bhi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ईसु तीनुक कह्‌यु, “मे बी तुंद्‌रे सी एक वात पुछो; कदी ची वात मेसे बताड़सु, ती मे बी बताड़ीस की ज्‌य काम कुणीन हक सी करो। ");
INSERT INTO bhi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","युहन्‌ना बपतीस्‌मा आपण्‌या काजे, बपतीस्‌मा काहा सी जड़लो? सरगेन भीणी सी की माणसे भीणी सी जड़लो?” जी वात सामळीन चे असा वीच्‌यार करने बाजी गुया, “कदी हामु कवजे सरगे सी भगवान आपलु, ती हयु कवसे, ‘ती तुहुं तेरे पर भुरसु काहानी कर्‌या?’ ");
INSERT INTO bhi_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ने कदी कवसुन ‘माणसे भीणी सी’ ती हामुक हीनु माणसेन टुळा सी धाक छे, काहाकी जे आखा युहन्‌ना काजे भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌यु माने।” ");
INSERT INTO bhi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","अळतेन चे ईसु काजे असा जपाप आप्‌या, “हामु नी जाणजे।” ती ईसु बी तींद्‌रे सी कह्‌यु, “ती मे बी तुहुंक।” नी बताड़तु की ज्‌य काम कुणीन हक सी करने बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ईसु यहुदीन मुख्‌या माणसे काजे कवतु गुयु, “तुहुं काय वीच्‌यारु? एक माणसेन दुय पुर्‌या हतला; चु पेहला धड़े जाय्‌न कह्‌यु, ‘ए पुर्‌या, आज अंगुरेन वाड़ी मां काम कर।’ ");
INSERT INTO bhi_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","बाकुन चु पेहलु पुर्‌यु असु जपाप आप्‌यु, मे नी जाम, बाकुन थुड़ीक वार मां तेरा मन अंगुरेन वाड़ीम काम करने जाणेन वीच्‌यार आय गुयु ने चु काम करने गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","अळतेन चु बास दीसरा पुर्‌या धड़े जाय्‌न असुत कह्‌यु, चु जपाप आप्‌यु, ‘हव मे जायस करीन कह्‌यु’ बाकुन चु नी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","हीनु दुय पुर्‌या मां सी काहनु बासेन मरजी पुरी कर्‌यु?” चे कह्‌या, “पेहलु पुर्‌यु।” ईसु हींद्‌रे सी कह्‌यु, “मे तुंद्‌रे सी छाचलीन कव की फाळु लेणे वाळा आफसर ने रंड्‌या तुंद्‌रे सी पेहले भगवानेन राज मां भरायसे। ");
INSERT INTO bhi_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","काहाकी युहन्‌ना बपतीस्‌मा आपण्‌यु धरमेन जीवनेन वाट देखाड़तु जाय्‌न तुंद्‌रे धड़े आयु, ने तुहुं तेरे पर भुरसु नी कर्‌या; बाकुन फाळु लेणे वाळा ने आफसरेन ने रंड्‌या तेरी वात पर भुरसु कर्‌या। ने तुहुं ज्‌य देखीन पछेन बी मन नी बदले ने तेर पर भुरसु कर लेय। ");
INSERT INTO bhi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“एक अळी दाखलु सामळु,” एक किरसाण हतलु, “अंगुरेन वाड़ी लागाड़्‌यु, तेरे चारे मेर वाड़ बांदयु, ने तीनी वाड़ी मां एक अंगुरेन रस नीकाळने करीन एक हळाव बणायु ने एक पाक्‌कु माळु बणायु, ने किरसाण काजे साजा मां आपदीन दीसरा देस मां जाती रयु।” ");
INSERT INTO bhi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","जत्‌यार अंगुर फळ आवरेन दाहड़ा आया, ती चु किरसाण हेरा गुलाम पावर्‌या काजे साजेल्‌या किरसाण भीणी अंगुरेन फळेन हीस्‌सु लेणे करीन मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","बाकुन चे साजेल्‌या किरसाण चां तेरा पावर्‌या काजे धरीन, हींद्‌रेन मां सी काहानाक काजे ठुक्‌या, ने काहानाक काजे दगड़ाट्‌या, ने काहनाक काजे मारीत नाख्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","अळतेन चु एक कावा अळी पेहला सी अदुस पावर्‌याक मकल्‌यु, ने चे किरसाण हींद्‌रे साते बी असात कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","चे मारा पुर्‌यान ईज्‌जत राख्‌से करीन आकरी कावा हेरा पुर्‌या काजे भेळु हयु। ");
INSERT INTO bhi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","बाकुन किरसाण पुर्‌या काजे देख्‌या ती एक दीसरा काजे कह्‌या, जु ते वारीसदार छे, आवु, हीनाक बी मार नाखता ने हेरा धन पर कब्‌जु कर लेता। ");
INSERT INTO bhi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","अळतेन चे तीना काजे धर लेदा ने अंगुरेन वाड़ी सी बाहार नीकाळीन मार नाख्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","अळतेन ईसु हेरा सामळन्‌या माणसेक पुछ्‌यु, “जत्‌यार अंगुरेन वाड़ीन मालीक पछु आवसे, ती चु तीनु किरसाण सी काय करसे?” ");
INSERT INTO bhi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","चे ईसु काजे कह्‌या, “चु तीनु कुहर्‌या माणसे काजे मारीन सार नाखसे; ने हेरी अंगुरेन वाड़ी दीसरा किरसाण काजे साजा मां आप देसे, जे टेम-टेम पर अंगुरेन मेरेन हीस्‌सु आप्‌या करसे।” ");
INSERT INTO bhi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ईसु तीनु काजे कह्‌यु, “तुहुं चुखला सास्‌तुर मां ज्‌य कदी नी भण्‌या?” तीना दगड़ा काजे मीस्‌तर्‌या फालतु समजीन बाहार उराट देदा चु दगड़ुत घरेन पायेन खुणे वाळु दगड़ु बण ज्‌य? ज्‌य मालीक भीणी सी हयो ज्‌य; ने हामरी नींगा मां बेसकी वारु वात छे! ");
INSERT INTO bhi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“तेरेमां मे तुंद्‌रे सी कह्‌वो की भगवानेन सरगेन राज तुंद्‌रे हात मां सी हापकी लेसे ने असी नी-यहुदी माणसेक आप देसे जे हेरो फळ लावसे, आप देसे। ");
INSERT INTO bhi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","जु हीना दगड़ा पर हीट पड़से, तेरो छेदर्‌या-छेदर्‌या हय जासे; ने तीना पर ज्‌य दगड़ु पड़से, तीना काजे दळ देसे।” ");
INSERT INTO bhi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","मुख्‌या पुजारा ने फरीसी माणसे ईसुन दाखलु काजे सामळीन समजी गुया की ईसु आपणेत बारामां कवणे बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ने चे ईसु काजे धरने चाहतेला, बाकुन चे माणसेक देखीन बीही गुया काहाकी चे ईसु काजे भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌यु मान तेला। ");
INSERT INTO bhi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ईसु अळी तीनुक दाखला सामळावणे बाजी गुयु, ");
INSERT INTO bhi_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“सरगेन राज तीना राजान तसों छे, जु हेरा एक पुर्‌यान ईयाव पंगत देदु।” ");
INSERT INTO bhi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ने चु हेरा पावर्‌या काजे मकल्‌यु, की नेवता नाखला माणसे काजे ईयाव मां खाणो-खाणे बुलावु; बाकुन चे आवणे नी हींडतेला। ");
INSERT INTO bhi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","अळतेन चु अळी पावर्‌या काजे असु कय्‌न मकल्‌यु, नेवता देदला माणसे सी कह्‌वु देखु, मे खाणो तीयार कर देदु, मारा बेल ने पाळ्‌ळा जनवार्‌या मार देदु, आखो तीयार छे; ने ईयावेन खाणा मां आवु। ");
INSERT INTO bhi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","बाकुन चे हीनी वात पर धीयान नी देदा: कुय आपणे खेते भीणी, कुय आपणा काम-धंदु करने जाती रया। ");
INSERT INTO bhi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ने काहनास माणसे ते राजान पावर्‌या साते वारु वेहवार नी कर्‌या ने तीनुक मार नाख्‌‌या। ");
INSERT INTO bhi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","जी खबर सामळीन राजा काजे बेसकी रीस लागी, ने चु हेरा सीपायड़ा काजे मकल्‌यु, ने चे जाय्‌न तीनु खुणी माणसे काजे मार नाख्‌या, ने तींद्‌रा सहर काजे धपाड़ देदा। ");
INSERT INTO bhi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","तत्‌यार राजु हेरा पावर्‌या सी कह्‌यु, ईयावेन खाणो ते तीयार छे, बाकुन नेवता देदला माणसे खाणे नी आया, ने चे हीना ईयाव मां आवे असा नी बण्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","तेरेमां चोवराया पर जावु ने जतरा माणुस तुहुंक जड़े, आखा काजे ईयावेन पंगत मां बुलाय लावु। ");
INSERT INTO bhi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","तेरेसी चे पावर्‌या रुहे पड़ गुया, ने काय भुंडात काय वारलु, जतरा जड़्‌या, आखा काजे भेळा करीन ली आया; ने ईयाव घर मेजवान्‌या सी भराय गुयो। ");
INSERT INTO bhi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“जत्‌यार राजु मेजवान्‌या काजे देखणे आयु, ती हयु चां एक माणुस काजे देख्‌यु, चु ईयावेन पुथल्‌या नी पेहरी रवलु।” ");
INSERT INTO bhi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","राजु तीना काजे पुछ्‌यु, “ए भायस, तु ईयावेन पुथल्‌या नी पेहर्‌यु जां काहा आयु?” चु माणुस हुगुत हय रयु। ");
INSERT INTO bhi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","तत्‌यार राजु पावर्‌या काजे हुकुम आपीन कह्‌यु, हेरा हात-पाय बांदीन हीना काजे बाहर आंदारला मां नाख देवु, चां रड़नु ने दात ककड़ावणु रवसे। ");
INSERT INTO bhi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","भगवानेन पंगत बुलावला ते बेसका छे, बाकुन नेवाड़ला थुड़ाक छे। ");
INSERT INTO bhi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","तत्‌यार फरीसी माणसे भेळा हयन वीच्‌यार कर्‌या, की ईसु काजे काहनी वात मां फसाड़जे। ");
INSERT INTO bhi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","तेरेमां चे आपणा चेला काजे हेरोदीयान माणसे साते ईसु भीणी ज कवणे मकल्‌या, “ए मास्‌तर,” हामु जाणजे की तु छाचलु छे, ने भगवानेन वाट संय-संय सीकाड़े, काहाकी जीवन मां फीकुर नी करे, काहाकी तु माणसेन मुंहडा देखीन वात नी करे। ");
INSERT INTO bhi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","तेरेमां हामुक बताड़ तु काय वीच्‌यारे? काय राजा केसर काजे फाळु देणु वारु छे की नी हय? ");
INSERT INTO bhi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ईसु तींद्‌रा भुंडात मन काजे जाणीन कह्‌यु, “ए ढंगड़ा करन्‌या, मेसेक काहा पारखणे बाजी रया? ");
INSERT INTO bhi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","फाळान सीक्‌कु मेसेक देखाड़ु, ती मे तुहुंक चु रुप्‌यु देखीन बताड़ीस!” “तत्‌यार चे तेरे धड़े एक रुप्‌यु लावीन ईसुक आप्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ती ईसु तीनुक रुप्‌यु देखाड़ीन पुछ्‌यु, “जु छाप ने नाव कुणीन छापलो छे?” ");
INSERT INTO bhi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“चे तीना काजे कह्‌या,” राजा केसरेन छे। तत्‌यार ईसु तीनुक कह्‌यु, “ज राजा केसरेन छे, च राजा केसर आपीन तेरो हक पुरो करु, ने ज भगवानेन छे, च भगवानेन काजे आपीन तेरो हक पुरो करु।” ");
INSERT INTO bhi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","असा सामळीन चे बीही गुया, ने ईसुक छुड़ीन जाती रया। ");
INSERT INTO bhi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","तीनेत दाहड़े सदुकी माणसे ईसुन्‌चां आया तींद्‌रु वीच्‌यार छे की मर्‌या-सर्‌याम पछु जीवतु नी हवे, चे आवीन ईसु काजे पुछ्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ए मास्‌तर, मुसा कवलु की कदी काहनाक अदमीन पुर्‌या नी हया ने मर जाय, ती तेरु भाय तीनी बायर सी ईयाव करीन आपणा भायस वाटे अवल्‌यात पयदा करनु चाहे। ");
INSERT INTO bhi_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","एक कावा असो हवलो सात भायस हतला, पेहलु ईयाव करीन मर गुयु ने अवल्‌यात नी हवी ती तेरु भाय तीनी रांडायली काजे बणाय लेदु। ");
INSERT INTO bhi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","असा करीन चे सातु भाय तीनी बायर काजे बणाया ने एकेक करीन बीना अवल्‌यातेन मर गुया। ");
INSERT INTO bhi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","आकरी मां ची रांडायली बायर बी मर गुय। ");
INSERT INTO bhi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","तेरेमां ची मर्‌या-सर्‌या मां सी पछी जीवती हवसे ती ची सातु भायसे मां सी कुणीन बायरी रवसे? काहाकी ची आखान बायरी बण गुयली। ");
INSERT INTO bhi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ईसु तीनुक कह्‌यु, “चुखला सास्‌तुर ने भगवानेन ताकत नी जाणु, तेरेमां तुहुं भुले पड़ रया। ");
INSERT INTO bhi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","काहाकी चे मर्‌या-सर्‌या मां सी जीवता हय्‌न चे नी ईयाव करसे, ने नी ते चे ईयाव वाळा मां देवायसे, बाकुन सरग मां भगवानेन सरग वाळा काहवाळ्‌यान तसा रवसे। ");
INSERT INTO bhi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","बाकुन मरला मर्‌या-सर्‌याम सी पछा जीवता हवणेन बारामां काय तुहुं असो बुल नी भण्‌या ज भगवान तुहुंक कवलु। ");
INSERT INTO bhi_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","मे अब्‌राहमेन भगवानेन, ने इसाकेन भगवानेन, ने याकुपेन भगवानेन छे? हयु मरलान नी बाकुन जीवतेलान भगवान छे।” ");
INSERT INTO bhi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ईसुन वात सामळीन माणसे घाबराय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","जत्‌यार फरीसी माणसे ज सामळ्‌या की ईसु सदुकीन जातीन माणसेन मुंहडा बंद कर देदलु, ती चे भेळा हय्‌न वीच्‌यार कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ने तींद्‌रे मायन एक यहुदी नीयमेन मास्‌तर ईसु काजे पारखणे करीन असु पुछ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ए मास्‌तर, मुसान साहरे लिखला सास्‌तुर मां आखा सी मट्‌ली हुकुम काहनी छे? ");
INSERT INTO bhi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ईसु तीनाक कह्‌यु, “तु भगवान काजे आपणा मालीक सी आपणा आखा मन ने आपणा आखा जीव ने आपणी आखी अक्‌कल सी परम राख्‌जी। ");
INSERT INTO bhi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","आखा सी मट्‌ली ने खास हुकुम छे। ");
INSERT INTO bhi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ने दीसरु हुकुम बी हेरेन तसु छे, आपणा चांदेवाळा माणसे सी आपणेन तसुत परम राख्‌जी। ");
INSERT INTO bhi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","जीत दुय हुकुम आखी मुसान साहरे लिखला सास्‌तुर ने भगवानेन अघी सी आवणे वाळी वात देखाड़ने वाळान नेवु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","जत्‌यार फरीसी माणसे भेळा हतला, ती ईसु तीनुक पुछ्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“मसीन बारामां तुंद्‌रु काय वीच्‌यार छे? चु कुणीन अवल्‌यात छे?” चे ईसुक कह्‌या, “दावुदेन अवल्‌यात।” ");
INSERT INTO bhi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","अतरामा ईसु तीनुक पुछ्‌यु, ती दावुद भगवानेन जीव-आत्‌मा मां रय्‌न तीना काजे मालीक काहा कह्‌वे? ");
INSERT INTO bhi_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","भगवान मालीक, मारा मालीक सी कह्‌यु, मारे जेवड़े आंगे बठ, जत्‌यार लग की, मे तारा वेरी काजे पाय मेलनेन पयड़ी नी बणाय दम। ");
INSERT INTO bhi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","कदी दावुद तीना काजे मालीक कहें, ती चु तेरु पुर्‌यु कसु हय सके? ");
INSERT INTO bhi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ने ईसुन जपाप सामळीन तींद्‌री बुलती बंद हय गुय? तीने दाहड़े सी काहना बी अळी ईसु काजे अळी काहनी बी वात पुछणेन हिम्‌मत नी आवी। ");
INSERT INTO bhi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","अळतेन ईसु माणसे टुळा काजे ने आपसान चेला काजे कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“यहुदी नीयम सीकाड़न्‌या मास्‌तर्‌या ने फरीसी माणसे मुसान गादी पर बस रया; ");
INSERT INTO bhi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","तेरेमां चे तुहुं काजे ज्‌य काय बी कहें चो ते करजु ने मांजु, काहाकी चे कह्‌वे ते खरा बाकुन चे करे नी। ");
INSERT INTO bhi_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","चे बेसकु भारी बुज बांदीन माणसेन खांदा पर मेल देय; बाकुन आपसा आपणी आंगळी लग बी नी टेकवणे हींडे। ");
INSERT INTO bhi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","चे आखा काम माणसे काजे देखाड़ने करीन करे, चे आपणी तावीज काजे चवड़ी करीन बांदे ने आपणात पुथल्‌यान झालर काजे नांबा कर देय! ");
INSERT INTO bhi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","चे खाणो खाणे बठे चां मुख्‌या-मुख्‌या जागा ने भगवानेन भक्‌तीन घरेन पेहलु जागु गमे। ");
INSERT INTO bhi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","हाटे मां वारलु छे की करीन आव-भाव करनु ती माणसे अगळ तीनुक मास्‌तर कह्‌वायणु तीनुक बेसको वारु गमे। ");
INSERT INTO bhi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","बाकुन तुहुं गुरु कह्‌वायणे करीन मां हुकारु काहाकी तुंद्‌रु एकुत मास्‌तर छे ने तुहुं आखात आखा भायस छे। ");
INSERT INTO bhi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","धरती पर काहनाक बी आपणु बास करीन घुण कह्‌वु, काहाकी तुंद्‌रु एकुत बास छे, चु सरगे मां छे। ");
INSERT INTO bhi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","माणसे अगळ मास्‌तर बी घुण कह्‌वायु, काहाकी तुंद्‌रु एकुत मास्‌तर छे, चु मसी छे। ");
INSERT INTO bhi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","जु तुंद्‌रे मां मटु छे, चु तुंद्‌रु चाकरी करन्‌यु बणे। ");
INSERT INTO bhi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","जु कुय आपसा काजे मटु मानसे, तीना काजे भगवान नानलु कर देसे, ने जु आपसा काजे नानलु मानसे, तीना काजे भगवानुत मटु कर देसे। ");
INSERT INTO bhi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ए ढंगड़ा करन्‌या यहुदी नीयमेन मास्‌तर्‌या ने फरीसी माणसे तुंद्‌रे वाटे बेसकी दुखेन वात छे! तुहुं ते माणसे काजे सरगेन राज मां भरायणे सी रुकी रया, नी ते तुहुं आपसा बी सरगेन राजेम नी भरायु ने दीसरा काजे बी सरगेन राज मां नी भरायणे देवु। ");
INSERT INTO bhi_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ए ढंगड़ा करन्‌या यहुदी नीयमेन मास्‌तर्‌या ने फरीसी माणसे तुहुं वाटे बेसकी दुखेन वात छे! तुहुं रांडायला बायरान घर मां भरायन तीनुक ठग लेवु, ने माणसे काजे देखाड़ने करीन बेसकी वार लग दुवा करु, तेरेमां तुहुं काजे अदुस डंड जड़से! ");
INSERT INTO bhi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ए ढंगड़ा करन्‌या यहुदी धरम सीकाड़न्‌‌या मास्‌तर्‌या ने फरीसी माणसे, तुंद्‌रे वाटे बेसकी दुखेन वात छे! काहाकी तुहुं एक जणा काजे आपणा पंथ मां लावणे करीन समुदर एणकीन धरती मां फीरु, ने जत्‌यार तुंद्‌रा पंथ मां आवीन चेलु बण जाय ती तीना काजे आपणा सी बी दुय गुणा जादा गुनाळु बणाय देवु की चु नरकेन आकठी मां जाणेन लायक बण जाय। ");
INSERT INTO bhi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ए आंदळा अगळवाण्‌या तुंद्‌रे वाटे बेसकी दुखेन वात छे! काहाकी तुहुं कह्‌वु कदी कुय माणुस मंदीरेन सगुन खाय ती तेरो काय बी नी हवे, बाकुन कदी कुय माणुस मंदीरेन सनान सगुन खाय ती तेरी वात खरली उतरी जाय। ");
INSERT INTO bhi_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ए डेड़-अकल्‌या ने आंदळा कुण मटो छे; सनो मटलो छे नीते मंदीर मटु छे? जेरेसी मंदीर मट्‌लु छे तेरेसी चो सनो चुखलो हवे? ");
INSERT INTO bhi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","तुहुं ज्‌य बी कह्‌व कुय माणुस वेदीन सगुन खाय ती तेरा काय बी खरलो नी हय बाकुन कुय माणुस ज्‌य वेदी पर मेकली, भेटेन सगुन खाय ती तेरी वात खरी उतरी जाय। ");
INSERT INTO bhi_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ए आंदळा, कुण मटो छे; भेट मटी छे की वेदी मटी छे तेरे सी भेट चुखलो हय जाय? ");
INSERT INTO bhi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","तेरेमां खास वात जी छे की जु वेदीन सगुन खाय च तीनी वेदी पर मेकायलो छे, चीजेन बी सगुन खाय। ");
INSERT INTO bhi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","जु मंदीरेन सगुन खाय, चु हेरी ने हेरेमां रवणेवाळान बी सगुन खाय। ");
INSERT INTO bhi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","जु सरगेन सगुन खाय, चु भगवानेन राज गादीन ने तीनी राजगादी पर बसण्‌यान बी सगुन खाय। ");
INSERT INTO bhi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ए ढंगड़ा करन्‌या यहुदी धरम सीकाड़न्‌‌या मास्‌तर्‌या ने फरीसी माणसे, तुंद्‌रे वाटे बेसकी दुखेन वात छे! तुहुं पुदीनान, ने सुपेन ने जीरान दसवु वाटु ते भगवान काजे आपु बाकुन मुसान साहरे लिखला सास्‌तुरेन खास वात काजे छुड़ देदा ने नीयाव, ने दया, ने भुरसा काजे टाळ देदा; तुहुं दसवु वाटु आप्‌या करजु बाकुन नीयाव ने दया ने भुरसान खास वात पाळता रहणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ए आंदळा अगळवाण्‌या, तुहुं मीचर्‌या काजे ते झार देवु, बाकुन उटड़ा काजे गीळ जावु। ");
INSERT INTO bhi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ए ढंगड़ा करन्‌या यहुदी धरम सीकाड़न्‌‌या मास्‌तर्‌या ने फरीसी माणसे, तुंद्‌रे वाटे बेसकी दुखेन वात छे! काहाकी जसा तुहुं कटवराक ने तळी काजे उपर-उपर ते वारु उजाळु बाकुन चे माहें आंदारला ने आपसान ने भलो करनेन वीच्‌यार सी भरायला छे। ");
INSERT INTO bhi_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ए आंदळा फरीसी माणसे, पेहले कटवराक ने तळी काजे माहें सी मांज लेवु ती उपर सी बी वारु मांजाय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ए ढंगड़ा करन्‌या यहुदी धरम सीकाड़न्‌‌या मास्‌तर्‌या ने फरीसी माणसे तुंद्‌रे वाटे बेसकी दुखेन वात छे! तुहुं तीना चुनु फीरला मसाणेन तसा छे ज्‌य उपर सी ते वारुत देखाये बाकुन माहें ते मरला माणसेन हाटका ने आखी भातीन भुंडला चीज भरायली छे। ");
INSERT INTO bhi_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","हीनी रीत सी तुहुं बी उपर सी माणसे काजे धरमी देखाय पड़ु बाकुन तुंद्‌रा मन मां ढंगड़ा ने पाप मां भरायला छे। ");
INSERT INTO bhi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ए ढंगड़ा करन्‌या यहुदी धरम सीकाड़न्‌‌या मास्‌तर्‌या ने फरीसी माणसे, तुंद्‌रे वाटे बेसकी दुखेन वात छे! तुहुं भगवानेन अघी सी आवणे वाळी वात देखान्‌यान मसाण सवारु ने धरमी माणसेन मसाण बणावु। ");
INSERT INTO bhi_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","तुहुं असा कह्‌वु ते खरा, ‘कदी हामु हामरा डाहा बुड़ान टेम मां रवता, ती भगवानेन अघी सी आवणे वाळी वात देखान्‌यान खुन करने मां हामरा डाहा बुड़ान सात नी देदा।’ ");
INSERT INTO bhi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","तेरेमां तुहुं आपणे आप सी गवाय देवु की जे भगवानेन अघी सी आवणे वाळी वात देखान्‌यान हत्‌या कर्‌या तींद्‌रा अवल्‌यात छे। ");
INSERT INTO bhi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","तेरेमां तुहुं आपणा डाह बुड़ान पापेन घड़ु पुरी रीत सी भर देवु। ");
INSERT INTO bhi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ए घड़सा, ने फेणवाळा घड़सान पीला, तुहुं नरकेन डंड सी कसा बचसु? ");
INSERT INTO bhi_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","तेरेमां देखु, मे तुंद्‌रे धड़े भगवानेन अघी सी आवणे वाळी वात देखान्‌या ने अकलवाळा ने यहुदी धरम सीकाड़न्‌‌या मास्‌तर्‌या काजे मकलो; तुहुं हींद्‌रे मां सी थुड़ाक काजे मार नाखसु ने कुरुस पर चड़ावसु, ने थुड़ाक काजे आपणा भगवानेन भक्‌तीन घर मां सपाटा मेकसु ने एक सहर सी दीसरा सहर मां मारता फीरसु। ");
INSERT INTO bhi_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","तेरेमां धरमी हाबील सी लीन बीरीक्‌याहन पुर्‌यान जकर्‌या लग, तीनुक तुहुं मंदीरेन वेदीन ईचमां मार नाखला, जतरो धरमीन लुही धरती पर बगळाय गुयलो छे चो आखो तुंद्‌रे मुणका पर पड़से। ");
INSERT INTO bhi_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","मे तुंद्‌रे सी छाचलीन कह्‌वो की जी आखी वात हीनीत टेमे माणसे पर आय पड़से। ");
INSERT INTO bhi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ए यरुसलेम, ए यरुसलेम! तु भगवानेन अघी सी आवणे वाळी वात देखान्‌या काजे मार नाखे, ने जे तारे धड़े मकली रया, तीनु काजे बी तु दगड़ा दीन मार नाखे। मे काय कावा चाह्‌यु की जसी कुकड़ी आपणा पीच्‌या काजे तेरा पाखड़ा तळे भेळी कर लेय असुत मे बी तारा पुर्‌या काजे भेळु कर लीस, बाकुन तुहुं नी चाह्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","देखु, तुंद्‌रु मंदीर तुंद्‌रे वाटे उजाड़्‌या छुड़ी जासे। ");
INSERT INTO bhi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","काहाकी मे तुंद्‌रे सी कहं की हय सी जत्‌यार लग तुहुं नी कह्‌वु, ‘तु वारु छे, जु मालीकेन नाव सी आवे’ जत्‌यार लग तुहुं मेसे अळी कदी नी देखसु।” ");
INSERT INTO bhi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","जत्‌यार ईसु मंदीरेन्‌चां सी नीकळीन जाणे बाजी रवलु, ती तेरा चेला तीना काजे मंदीर देखाड़ने करीन तेरे धड़े आया, की मंदीर कसों छे। ");
INSERT INTO bhi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ईसु तीनुक कह्‌यु, “तुहुं आखो ज देख रया नी। बाकुन मे तुहुंक छाचलीन कहो, जां दगड़ा पर दगड़ु बी नी रवे एक-एक दगड़ु उदारी नाखसे।” ");
INSERT INTO bhi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","जत्‌यार हयु जेतुनेन बयड़ा पर बसी रवलु, ती चेला एखलात ईसु धड़े आवीन कह्‌या, “हामुक बताड़ की जी वात कत्‌यार हवसे? तारो आवणेन ने कळीन खत्‌तम हवणेन काय सहलाणी रवसे।” ");
INSERT INTO bhi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ईसु तीनुक जपाप आप्‌यु, चेतीन रवु! तुहुंक कुय बी भटकाड़नु नी चाहजे। ");
INSERT INTO bhi_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","काहाकी बेसका माणसे असा रवसे चे मार नाव सी आवीन कह्‌वसे, मे मसी छे! ने बेसका काजे भटकाड़ी देसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","तुहुं लड़ाय पर लड़ायन वात सामळसु, ती घाबरायु घुण, काहाकी असो ते हवण्‌यत छे, बाकुन तीनी टेमे कळजुग सरनु नी हय। ");
INSERT INTO bhi_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","काहाकी जाती पर जाती, ने राजे पर राजेन माणसे भेळा हयन लड़ाय करसे, ने जागे-जागे काळ पड़से, ने धरती धदड़ीन फाट जासे। ");
INSERT INTO bhi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","जी आखी वात हीड़ा-पीड़ान सुरुवात हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","तत्‌यार चे एला पाड़ने करीन तुहुं काजे धराय देसे, ने तुहुंक मार नाखसे, ने तुहुं मारी वात सामळसु ने मार नावेन वजे सी आखी जातीन माणसे तुंद्‌रा वेरी रवसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","तत्‌यार बेसका माणसे मारे पर सी भुरसु करनु छुड़ देसे, ने एक दीसरा काजे धराड़से, ने एक दीसरा सी वेरी रवसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","बेसका लुच्‌चा भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌या उठीन हुबा हवसे, ने बेसका माणसे काजे भटकाड़से। ");
INSERT INTO bhi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","पाप अदणे सी बेसका माणसेन परम छे चु सेळाय जासे, ");
INSERT INTO bhi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","बाकुन जु मरता लग गम खासे, तेरुत छुटकारु हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","भगवानेन राजेन ज्‌य खुस-खबर आखी कळी मां माणसे परचार करसे, ने सामळावसे, काहाकी चे आखी जाती मां गवा बण जाय, तत्‌यार कळजुग सरनेन टेम आय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","तेरेमां जत्‌यार तुहुं तीनु उजाड़ने वाळी वात ने भुंडीत चीज काजे तेरी वात दानीयल भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌यान साहरे हवली, चु चुखली जागा मां उबु हय रवलु देख्‌यु, जे भणे, चे समजे। ");
INSERT INTO bhi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","तत्‌यार चे यहुदीया जीला मां रवे चे बयड़ा मां ढास जाय। ");
INSERT INTO bhi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","जे घरेन बमड़ा पर रवे, चे आपणा घर मां समान लेणे घुण उतरु; ");
INSERT INTO bhi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ने जे कदी खेत मां हय, चे आपणा पुथल्‌या लेणे पछा घुण आवु। ");
INSERT INTO bhi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","तीनु दाहड़ा मां जी भारीस ने दुत धावाड़ती हसे, तींद्‌रे वाटे बेसकी, दुखेन वात छे। ");
INSERT INTO bhi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","दुवा करता रहु काहाकी सीयाळान दाहड़ा मां, ने आरामेन दाहड़े ढासणु नी पड़े। ");
INSERT INTO bhi_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","काहाकी तीनी टेमे मां असी भारी एला हवसे, जसों हीनी कळीन सुरु सी हय लग नी हयो ने कदी तसों हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","कदी दाहड़ा नी कम करता ती, काहनु बी जीव नी बचे, बाकुन नेवाड़ला माणसेन वजे सी चे दाहड़ा कम हय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","तीनी टेमे मां कदी कुय बी तुंद्‌रे सी कह्‌वे, की देखु, मसी जां छे! नीते वां छे! ती भुरसु घुण करु। ");
INSERT INTO bhi_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","काहाकी लुच्‌चा मसी ने लुच्‌चा भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌या उठीन उबा हय जासे, ने मट्‌ली सहलाणी, ने बेसका मटा-मटा काम देखाड़से कदी हय सके ते नेवाड़ला काजे बी भटकाड़ देसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","देखु, मे पेहलुत तुंद्‌रे सी जी आखी वात कय देदु। ");
INSERT INTO bhi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","तेरेमां कदी चे तुंद्‌रे सी कह्‌वे, देखु, हयु ते बयड़ा मां छे! ती बाहार घुण नीकळी जावु, नीते देखु, हयु ते खुणा कपरा मां छे, ती तुहुं भुरसु घुण करु। ");
INSERT INTO bhi_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","काहाकी जसी वीजळी उगवणी सी नीकळे ने बुडवणी लग वीजळे, तसोत माणसेन पुर्‌यान बी आवणु हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","जां लास रवे, चांहान मटला घुवड़ा बी भेळा हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","तीनु दाहड़ा मां गरा आवणेन तत्‌यारुत पछेन दाहड़ु उलवाय जासे ने चांदेन वीजाळो खत्‌तम हय जासे, ने तारा छे चे सरग सी भुयमां हीट पड़से ने सरगेन आखो ताकुतेन काम सी हाल जासे। ");
INSERT INTO bhi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","तत्‌यार माणसेन पुर्‌यान सहलाणी सरग मां देखाय जासे ने तत्‌यार कळीन आखी जातीन माणसे छाती ठुकीन रड़से; ने माणसेन पुर्‌या काजे मट्‌ली ताकत ने सेक-सींगार साते वादळा मां आवतेलु देखसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","चु फेप्‌यान मट्‌ली आवाज भेळु आपणा सरग वाळा काहवाळ्‌या काजे मकलसे, ने चे कळीन उपर एक खुणा सी दीसरा खुणा लग, चारे-मेर सी तेरा नेवाड़ला काजे भेळा करसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“अंजीरेन झाड़का सी गुयु दाखलु सीकु। जत्‌यार तीनी डाळ मां कवळा डीरा फुटणे लग जाय ने नवला पान्‌टा नीकळने बाजी जाय, ती तुहुं जाण जावु की हय उंडाळु आवणे वाळु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","एरेत तसोत जत्‌यार तुहुं हीनु आखी वाते काजे देखु, ती जाण लेजु की तेरो आवणेन टेम धड़ेत छे, बाकुन बारना मां आय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ने तुहुंक छाचलीन कहो की जी आखी वात ईनी पीड़ीन माणसेन मरनेन पेहलुत हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","सरग ने धरती टळ जासे, बाकुन मारी वाते कदी नी टळे। ");
INSERT INTO bhi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","हयु दाहड़ु ने तीनी टेमेन बारामां कुय बी नी जाणे, नी ते सरग वाळु काहवाळ्‌यु, नी ने पुर्‌यु नी, बाकुन बास अतरुत जाणे। ");
INSERT INTO bhi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","जसों नुहुन दाहड़ा मां हवलो, असोत माणसेन पुर्‌यान आवणु बी हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","काहाकी जसों पाणी मां डुबणे सी पेहला दाहड़ा मां, जां लग की नुह ढंड्‌या पर नी चहड़्‌यु, तीनु दाहड़ा लग माणसे खात्‌ला ने पीदला, ने तींद्‌रे मां ईयाव हवतेला। ");
INSERT INTO bhi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ने जत्‌यार लग मुसळ धार्‌यु पाणी आय्‌न तीनु आखा काजे उह्‌वाड़ीन नी ली गुयो, तत्‌यार लग तीनुक काय बी पतु नी चाल्‌यु, तसोत माणसेन पुर्‌यान आवणु बी हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","तीनी टेमे दुय जणा खेत मां हसे, ने एक काजे लीन जाती रवसे ने दीसरा काजे चांहान रहणी देसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","दुय बायर घट्‌टी दळती रवसे ने एक काजे लीन जाती रवसे ने दीसरी काजे चांहान रहणी देसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","तेरेमां जागला रवु, काहाकी तुहुं नी जाणु की तुंद्‌रु मालीक काहने दाहड़े आवसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","बाकुन ज्‌य वारु रीती सी जाण लेवु, की कदी घरेन मालीक जाणतु की चुट्‌टु कतरी टेमे आवसे ती चु जागतु रवतु ने आपणा घर मां सी काय बी चुरी नी हवणी देतु। ");
INSERT INTO bhi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","तेरेमां तुहुं बी तीयार रवु, काहाकी तीनी टेमे तुहुं वीच्‌यार बी नी करसु ने, तीनी टेमे मां माणसेन पुर्‌यु आय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","तेरेमां भुरसु करन्‌यु ने अक्‌कल वाळु पावर्‌यु कुण छे? तीनाक मालीक आपणा नकर्‌या-चाकर्‌या काजे सामाळन्‌यु राख्‌‌यु काहाकी चु टेमे-टेमे पर तीनुक खाणो आप सके? ");
INSERT INTO bhi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","वारु छे, हयु पावर्‌यु, तीनाक तेरु मालीक चोन काम करतु देखे। ");
INSERT INTO bhi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","मे तुंद्‌रे सी छाचलीन कह्‌व, मालीक तीना पावर्‌या काजे आपसान आखा माल-धन पर हकदार्‌यु बणावसे। ");
INSERT INTO bhi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","बाकुन कदी हयु बयमान पावर्‌यु वीच्‌यारने लागे की मारा मालीकेन आवणे मां वार छे, ");
INSERT INTO bhi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ने हयु असु वीच्‌यारीन दीसरा साती गुलाम पावर्‌या काजे ठुकणे, बाजी गुयु ने दारुड़्‌या भेळु खाय ने दारुड़्‌यु बण जाय। ");
INSERT INTO bhi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ती तीना पावर्‌यान मालीक असला दाहड़ा आवसे, जत्‌यार हयु तेरी वाट बी नी देखे, ने असी टेम मां तीना काजे पतु नी रवे। ");
INSERT INTO bhi_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","तत्‌यार चु मालीक तीना काजे भारी मटु डंड आपसे, ने ढंगड़ा करन्‌या साते भेसकी देसे। ने चां रड़से ने दात ककड़ावता रवसे। ");
INSERT INTO bhi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","सरगेन राज तीनु दस कुवारली पुरेन तसों छे जी आपणु-आपणु दिवु लीन लाडा सी मेळने करीन गुय। ");
INSERT INTO bhi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","हींद्‌रे मां पांच डेड़ अकली ने पांच अक्‌कल वाळी हतली ");
INSERT INTO bhi_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","डेड़ अकली पुरे आपसु दिवा ते लेदी, बाकुन आपणे साते तेल नी लेदी; ");
INSERT INTO bhi_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","बाकुन अक्‌कल वाळी आपणा दिवा साते आपणा कुड़्‌या मां तेल बी भर लेदी। ");
INSERT INTO bhi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","जत्‌यार लाडान आवणे मां वार हय गुय ती ची आखी बकास्‌या लेणे लागी ने सुय गुय। ");
INSERT INTO bhi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","आधी राते चां कचाटु हय गुयु, देखु, लाडु आय रयु! तेरे सी मेळने चालु। ");
INSERT INTO bhi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","तत्‌यार ची आखी कुवारली उठीन आपणा-आपणा दिवा काजे वारु करने लागी। ");
INSERT INTO bhi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ने डेड़ अकली ने अक्‌कल वाळी सी कह्‌वी आपणा तेल मां सी थुड़ोक तेल हामुक बी आपु काहाकी हामरा दिवा उलवायणी बाजी रया। ");
INSERT INTO bhi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","बाकुन अक्‌कल वाळी जपाप आपी, कदी ज्‌य हामरे ने तुंद्‌रे वाटे पुरो नी हवे; वारु ते ज्‌य छे की तुहुं वेचणे वाळा धड़े जाय्‌न आपणे वाटे मुल ली लेवु। ");
INSERT INTO bhi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","जत्‌यार ची मुल लेणे जाणे बाजी रवली ती लाडु आय ज्‌य, ने जी तीयार हतली, ची लाडा साते ईयावेन घर मां जाती रय ने बारनो बुजाय ज्‌य। ");
INSERT INTO bhi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","हेरे पछेन ची दीसरी रवली कुवारली बी आवीन कह्‌वणे लागी, ए मालीक, ए मालीक, हामरे वाटे बारनो उघाड़ दे। ");
INSERT INTO bhi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","चु मालीक जपाप आप्‌यु, मे तुंद्‌रे सी छाचलीन कह्‌वो, मे तुहुंक नी उळखो। ");
INSERT INTO bhi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","तेरेमां जागता रवु, काहाकी तुहुं नीते तीना दाहड़ा काजे उळखु नीते तीनी टेम काजे जाणु। ");
INSERT INTO bhi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","काहाकी जी तीना माणसेन तसों छे जु पारका देस मां जाणेन टेमे आपणा पावर्‌या काजे बुलायन आपणो धन पावर्‌या काजे आप देदु। ");
INSERT INTO bhi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","चु एक जणा काजे सनान पांच सीक्‌का आप्‌यु, दीसरा काजे दुय आप्‌या, ने तीसरा काजे एक आप्‌यु; अळतेन एक-एक काजे तींद्‌री ताकत देखीन आप्‌यु, ने तत्‌यार पारका देस मां जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","तत्‌यार, तीनाक चांदीन पांच सीका जड़ला, चु तत्‌यारुत जाय्‌न हींद्‌रे सी लेणु-देणु कर्‌यु ने पांच सीका अळी कमाय लेदु। ");
INSERT INTO bhi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","हीनी रीत सी तीनाक चांदीन दुय सीका जड़ला, चु बी दुय सीका अळी कमाय लेदु। ");
INSERT INTO bhi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","बाकुन तीनाक एक चांदीन सीकु जड़ला चु जाय्‌न जागा काजे खुदीन ने आपणा मालीकेन रुप्‌या काजे साताड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“बेसका दाहड़ाम पछे तीनु पावर्‌यान मालीक आयु ने हींद्‌रे सी लेखु लेणे लाग्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","तीनाक चांदीन पांच सीका जड़ला, चु पांच सीका अळी लावीन कह्‌यु, ‘ए मालीक तु मेसेक पांच सीका आपलु, देख, मे पांच सीका अळी कमाय लेदलु छे।’ ");
INSERT INTO bhi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","तेरु मालीक तीना काजे कह्‌यु, बेसकु वारु छे ने भुरसा लायक पावर्‌यु तु थुड़ाक मां ईमानदार रयु मे तुसे बेसका चीजे पर हकदार बणावीस। आपणा मालीकेन खुसी मां साजीदार बण। ");
INSERT INTO bhi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ने तीनाक चांदीन दुय सीका जड़ला, चु बी आवीन कह्‌यु, ‘ए मालीक, तु मेसे दुय सीका आपलु, देख, मे दुय सीका अळी कमाय लेदु।’ ");
INSERT INTO bhi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","तेरु मालीक तीनाक कह्‌यु, ‘तु वारु छे ने भुरसा लायक पावर्‌यु, तु थुड़ाक मां ईमानदार रयु; मे तुसे बेसका चीजेन हकदार बणावीस। आपणा मालीकेन खुसी मां साजीदार हय जां।’ ");
INSERT INTO bhi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","तत्‌यार तीनाक चांदीन एक सीकु जड़लु, चु आवीन कह्‌यु, ए मालीक, मे तुसे जाणतेलु की तु बेसकु डाहवाळु माणुस छे, ‘तु जां काय बी नी वेरे चानती काटे, ने जां नी खवळे चानती भेळा करे। ");
INSERT INTO bhi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","तेरेमां मे बीही गुयलु ने जाय्‌न तारा एक सीका काजे जागा मां साताड़ देदु। देख, ज्‌य तारो, छे चो ज्‌य छे।’ ");
INSERT INTO bhi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","तेरु मालीक तीना काजे जपाप आप्‌यु, ‘ए वेरी ने उजेगलु पावर्‌या, जत्‌यार तु ज्‌य जाणतेलु की जां मे नी एरो वां सी काटो, ने जां मे नी खवळ्‌यु चांहान सी भेळु करो? ");
INSERT INTO bhi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ती तुसेक मारा धन काजे सवकार्‌या काजे लीन आप देतु, तत्‌यार मे आवीन आपणा धन काजे ईयाज समोत ली लेतु। ");
INSERT INTO bhi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","तेरेमां चु सीकु हेरसी ली लेवु, ने तेरे धड़े दस हजार रुप्‌या छे, तीना काजे आप देवु। ");
INSERT INTO bhi_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","काहाकी तीना धड़े छे, तीना काजे अळी आप देसे; ने तेरे धड़े बेसका हय जासे; बाकुन तेरे धड़े नी हय, तीना सी ज्‌य बी तेरे धड़े छे, तेरे धड़े सी हापकी लेसे। ");
INSERT INTO bhi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ने हीना पापी पावर्‌या काजे बाहार आंदारला मां नाख देवु, चां रड़नु ने दात ककड़ावणु रवसे।’ ");
INSERT INTO bhi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“जत्‌यार माणसेन पुर्‌यु राजु बणीन आवसे ने तेरा आखा सरग वाळा काहवाळ्‌या पुठ्‌ये आवसे, तत्‌यार चु आपसान राजगादी पर बठसे। ");
INSERT INTO bhi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ने आखा जातीन माणसे तेरे अगळ भेळा करसे; ने जसु गुवाळ्‌यु गाडरा काजे बुकड़ा सी अलग कर देय, असुत चु तीनुक एक दीसरा सी अलग करसे। ");
INSERT INTO bhi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","चु गाडरा काजे आपणे जेवड़े आंग्‌ये उबा राख्‌से ने बुकड़ा काजे आपणे डाखर्‌ये आंग्‌ये उबा करसे। ");
INSERT INTO bhi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","तत्‌यार राजु आपणा जेवड़े आंग्‌ये वाळा सी कह्‌वसे, ए मारा बास सी बरकत जड़ला माणसे आवु, तीना राजेन हकदार बण जावु, ज्‌य कळीन सुरु सी तुंद्‌रे वाटे तीयार कर मेकलो छे। ");
INSERT INTO bhi_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","काहाकी मे भुकलु हतलु, ने तुहुं मेसे खाणे करीन आप्‌या; मे पीसलु हतलु, ने तुहुं मेसे पाणी पीयाड़्‌या; मे पारका देसेन हतलु ने तुहुं मेसे तारा घर मां ठेराया; ");
INSERT INTO bhi_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","मारे धड़े पेहरनेन पुथल्‌या नी हतला, ती तुहुं मेसे पुथल्‌या पेहराया; मे मांदलु हतलु, ने तुहुं मारी खबर लेदला मे जेल मां हतलु ने तुहुं मेसेक भेळा हवणे आया। ");
INSERT INTO bhi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","तत्‌यार धरमी तीना काजे जपाप आपसे, ए मालीक, हामु कत्‌यार तुसे काजे भुकलु देख्‌या ने खावड़्‌या? नीते पीसलु देख्‌या ने पाणी पीयाड़्‌या?” ");
INSERT INTO bhi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","हामु कत्‌यार तुसे पारका देस वाळु देख्‌या ने आपणा घर मां बठाड़्‌या? नीते नांगेरलु देख्‌या ने पुथल्‌या पेहराया? ");
INSERT INTO bhi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","हामु कत्‌यार तुसे मांदलु नीते जेल मां देख्‌या ने तुसे भेळा हवणे आया? ");
INSERT INTO bhi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","तत्‌यार राजु तीनुक जपाप आपसे, मे तुंद्‌रे सी छाचलीन कह्‌वो की तुहुं जे मारा हीनु नानला सी नानला भायसे मां सी काहनाक बी एक साते कर्‌या, च मारेत साते कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","तत्‌यार चु डाखर्‌या आंगे वाळा सी कवसे, ए सराप वाळा माणसे, मारे अगळ सी तीना जलमेन आकठा मां जाती रयु, ज्‌य भुतड़ा ने तेरा सरग वाळा काहवाळ्‌या वाटे तीयार कर मेकलो। ");
INSERT INTO bhi_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","काहाकी मे भुकलु हतलु, ने तुहुं मेसे खाणे करीन नी आप्‌या; मे पीसलु हतलु, ने तुहुं मेसे पाणी नी पीयाड़्‌या; ");
INSERT INTO bhi_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","मे पारका देसेन हतलु, ने तुहुं मेसे आपणा घर मां नी बठाड़्‌या; मारा डील पर पुथल्‌यो नी हतलो, ने तुहुं मेसे पुथल्‌या नी पेहराया; मे मांदलु ने जेल मां हतलु, ने तुहुं मारी खबर नी लेदा। ");
INSERT INTO bhi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“तत्‌यार चे जपाप आपसे, ‘ए मालीक, हामु तुसे कत्‌यार भुकलु, ने पीसलु, ने दीसरा देसेन, ने डील पर पुथल्‌यो नी, ने मांदलु, जेल मां देख्‌या, ने तारी चाकरी नी कर्‌यु?’ ");
INSERT INTO bhi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","तत्‌यार चु तीनुक जपाप आपसे, ‘मे तुंद्‌रे सी छाचलीन कह्‌वो, की तुहुं जे हीनु नानला मां सी नानला मां काहनाक बी एक जणा साते नी कर्‌या, च मारे साते बी नी कर्‌या।’ ");
INSERT INTO bhi_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ने जे जलमेन डंड भुकेतसे बाकुन धरमी जलमेन जीवन मां भराय जासे।” ");
INSERT INTO bhi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","जत्‌यार ईसु ज्‌य आखी वात कय देदु ती आपणा चेला सी कह्‌वणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“तुहुं जाणु की दुय दाहड़ान पछे फसहन तीहवार छे, ने माणसेन पुर्‌या काजे कुरुस पर चड़ावणे वाटे धराय जासे।” ");
INSERT INTO bhi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","तत्‌यार मुख्‌या पुजारा ने भगवानेन माणसेन डाहा-बुड़ा काइफा नावेन मटला पुजारान आंगणा मां भेळा हया। ");
INSERT INTO bhi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ने चे एक दीसरा सी वीच्‌यार कर्‌या, की ईसु काजे धुका सी धरीन मार नाखजे। ");
INSERT INTO bhi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","बाकुन चे कवतेला की “तीहवारेन टेम नी हय, काय असो नी हवे की माणसे मां लड़ाय झगड़ा हय जाय।” ");
INSERT INTO bhi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","जत्‌यार ईसु बेतन्‌या गांव मां सीमोन कुड़ायलान घर मां हतलु। ");
INSERT INTO bhi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ती एक बायरी दगड़ा काजे वार सीस्‌यान तसों बणायन तेरे मां बेसको महंगलो ईत्‌तर लीन ईसु धड़े आवी, ने जत्‌यार ईसु रुटा खाणे बठ रवलु ती ईसुन मुणका पर लावीन नाख देदी। ");
INSERT INTO bhi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ज्‌य देखीन तेरा चेला रीसाय गुया ने कह्‌वणे लाग्‌या, “हीना ईत्‌तर काजे काहा फालतु मां रद कर देदी? ");
INSERT INTO bhi_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","हीना ईत्‌तर काजे ते जादा पयस्‌या मां वेचीन गरीब काजे वाट देदी।” ");
INSERT INTO bhi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","जी वात जाणीन ईसु हींद्‌रे सी कह्‌यु, “बायरी काजे काहा एला पाड़ु? जी बायरी मार साते वारु करली छे। ");
INSERT INTO bhi_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","गरीब ते तुंद्‌रे साते जलम रवसे, बाकुन मे तुंद्‌रे साते जलम नी रवु। ");
INSERT INTO bhi_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","जी बायरी मारे डील पर ज्‌य ईत्‌तर रेचवली छे, चो मारा डील काजे गाड़ने वाटे तीयार करली छे। ");
INSERT INTO bhi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","मे तुंद्‌रे सी छाचलीन कह्‌वो, की आखी कळी मां जां काहा बी ज्‌य खुस-खबरेन परचार करसे हीनी बायरीन कामेन वात वीच्‌यार ने हेर करसे।” ");
INSERT INTO bhi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","तत्‌यार यहुदा ईस्‌करीयोती, ज्‌य बारे चेला मां सी एक हतलु, मुख्‌या पुजारा धड़े जाय्‌न कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“कदी मे ईसुक तुंद्‌रे हात मां धराड़ दम ती मेसे काजे काय आपसु?” चे तीना काजे तीस चांदीन सीक्‌‌का गीणीन आप देदा। ");
INSERT INTO bhi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ने चु यहुदा तीनी टेमे सी ईसुक धराड़ने करीन मुखु हेरतु रयु। ");
INSERT INTO bhi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","अखमीरी रुटान तीहवारेन पेहले दाहड़े, चेला ईसु धड़े आवीन पुछणे लाग्‌या, “तु काहा चाहे की हामु तारे वाटे फसह तीहवारेन तीयारी करजे?” ");
INSERT INTO bhi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ईसु कह्‌यु, “सहर मां हीना माणुस धड़े जाय्‌न तीना काजे कह्‌वु, मास्‌तर कह्‌वे की मारी टेम साते आय गुयली छे। मे आपणा चेला साते तारेन चां फसहन तीहवार मनावीस।” ");
INSERT INTO bhi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ने ईसुन चेला जसु ईसु कह्‌यु तसात कर्‌या ने फसहन तीहवारेन खाणेन तीयारी कर लेदा। ");
INSERT INTO bhi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","जत्‌यार सांती वेळाय हय गुय ती चु बारे चेला साते रुटा खाणे करीन बठ ज्‌य। ");
INSERT INTO bhi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","जत्‌यार चे खाय रवला ती ईसु कह्‌यु, “मे तुंद्‌रे सी छाचलीन कह्‌वो की तुंद्‌रे मां सी एक जणु मेसेक धरावसे।” ");
INSERT INTO bhi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","जी वात सामळ्‌या चे बेसका फीकुर मां पड़ गुया ने हींद्‌रे मां सी आखा जणा पुछणे लाग्‌या, “ए मास्‌तर, काय चु मे छे?” ");
INSERT INTO bhi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ईसु जपाप आप्‌यु, “जु मारे साते तळी मां हात नाखलु छे, हयुत मेसे धराड़से। ");
INSERT INTO bhi_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","माणसेन पुर्‌या काजे ते मरनु छे, जसों तेरा बारामां लिखलो छे; बाकुन तीनु माणुस वाटे बेसकी दुखेन वात छे, तेरे साहरे माणसेन पुर्‌या काजे धराड़से! कदी चु माणुस पयदा नी हवतु ती तेरे वाटे वारु रवतो।” ");
INSERT INTO bhi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","तत्‌यार तीना धराड़ने वाळु यहुदा कह्‌यु, “ए मास्‌तर, काय चु मे छे?” ईसु कह्‌यु, “तु आपसुत कय देदु।” ");
INSERT INTO bhi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","जत्‌यार चे खाय रवला ती ईसु रुटु लेदु, ने बरकत मांगीन तुड़्‌यु, ने चेला काजे आपीन कह्‌यु, “लेवु जु रुटु खावु; ज्‌य मारो डील छे।” ");
INSERT INTO bhi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","अळतेन ईसु कटवरु लीन तु बेसकु वारु छे करीन कह्‌यु, ने तीनुक आपीन कह्‌यु, “तुहुं आखा तेरे मां सी पीयु, ");
INSERT INTO bhi_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","काहाकी ज्‌य पीयालु वायदान चो मारो लुही छे, ज्‌य बेसका माणसे वाटे पापेन माफी वाटे उहणे वाळो छे। ");
INSERT INTO bhi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","मे तुंद्‌रे सी कह्‌वो की अंगुरेन रस काजे हीना दाहड़ा लग घुण पीयो जत्‌यार लग तुंद्‌रे साते आपणा बासेन राज मां नवलु नी पीयो।” ");
INSERT INTO bhi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","अळतेन चे गीत गायन जेतुनेन बयड़ा पर जाणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","तत्‌यार ईसु तींद्‌रे सी कह्‌यु, “तुहुं आखा आजुत राते मार बारामां वीख्‌राय जासु, काहाकी चुखली-सास्‌तुर मां गुयो लिखलो छे, ‘मे गुवाळ्‌या काजे मारीस, ने गाडरान टुळा रावण्‌या-तीवण्‌या हय जासे।’ ");
INSERT INTO bhi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","बाकुन मे मरलाम सी जीवतु हवणेन पछे तुंद्‌रे सी पेहेल गलील जीला मां जायस।” ");
INSERT INTO bhi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","तेरेसी पतरस तीना काजे कह्‌यु, “कदी आखा तारा बारामां ठुकर खाय्‌न छुड़ देसे बाकुन मे कदी बी नी तुसेक छुड़ो!” ");
INSERT INTO bhi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ईसु पतरस सी कह्‌यु, “मे तुसेक छाचलीन कह्‌वो की आजुत राते कुकड़ा वासणीक पेहेल, तु तीन कावा तु मेसेक नी जाणो करीन कवसी।” ");
INSERT INTO bhi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","पतरस ईसु काजे कह्‌यु, “कदी मेसेक तारे साते मरनु बी पड़े, तेबी मे तुसेक नी जाणो करीन कदी नी कह्‌वो!” ने असात करीन आखा चेला बी कह्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","तत्‌यार ईसु आपणा चेला साते गतसमनी नावेन एक जागा मां आयु ने आपणा चेला सी कह्‌वणे लाग्‌यु, “जान बठ रवजु, जत्‌यार लग मे वां जाय्‌न दुवा करो जां लग तुहुं जान रवजु।” ");
INSERT INTO bhi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ईसु पतरस ने जब्‌दीन दुयु पुर्‌या काजे साते लीन गुयु ने ईसु फीकुर मां पड़ीन कांदरायणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","तत्‌यार ईसु तीनुक कह्‌यु, “मारु जीव बेसकु दुखी छे, जां लग की मारु जीव नीकळनेत हींडे। तुहुं जां हुबा रवु ने मारे साते जागला रवु।” ");
INSERT INTO bhi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","अळतेन चु थुड़ुक अळी अगुस जाय्‌न मुंहडान भुरसे पड़्‌यु, ने असी दुवा कर्‌यु, “ए मारा बास, कदी हय सके ती ज्‌य दुखेन पीयालु मारे पर सी टळ जाय, ती बी जसु मे चाहो असु नी बाकुन जसु तु चाहे तसोत हवणे दे।” ");
INSERT INTO bhi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","अळतेन ईसु चेला धड़े आवीन तीनुक सुवतेला देख्‌यु ने पतरस सी कह्‌यु, “काय तुहुं मारे साते एक घंटु बी नी जागी सकु काय? ");
INSERT INTO bhi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","जागता रवु, ने दुवा करता रवु की तुहुं पारख मां नी पाड़े, आत्‌मा ते तीयार छे, बाकुन डील लुलो छे।” ");
INSERT INTO bhi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","अळतेन चु दीसरी कावा जाय्‌न जीत दुवा कर्‌यु, “ए मारा बास, कदी ज्‌य मारे पीये बीगुर नी टळ सके ती तारीत मरजी पुरी हवे।” ");
INSERT INTO bhi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","तत्‌यार ईसु आवीन तीनुक अळी सुवतेला देख्‌यु, काहाकी हींद्‌रा डुळा नीद सी भरला हतला। ");
INSERT INTO bhi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","तीनुक छुड़ीन चु जाती रयु, ने तीनुत बुले सी अळी तीसरी कावा दुवा कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","तत्‌यार ईसु चेला धड़े आवीन तीनुक कह्‌यु, हय सुवता रवु, “ने आराम करु? देखु ची टेम आय गुयली छे, ने माणसेन पुर्‌यु पापीन हात मां धराय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उठु, चालु; देखु, धुकु दीन धराड़ने वाळु साते आय रयु।” ");
INSERT INTO bhi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ईसु असु कयत रवलु की यहुदा जु बारामां सी एक हतलु आयु, ने तेरे साते मुख्‌या पुजारा ने माणसेन डाहा बुड़ा भीणी सी माणसेन मट्‌लु टुळु तलवार्‌या ने डेंगा लीन आया। ");
INSERT INTO bhi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ईसुक धराड़ने वाळु यहुदा तीनुक असु ईसारु कर्‌यु: “तीनाक मे जाय्‌न गुळु दीस हयुत छे; तीना काजे जाय्‌न धर लेजु!” ");
INSERT INTO bhi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ने तत्‌यार ईसु धड़े आवीन कह्‌यु, “ए मास्‌तर, वारलु छे की!” ने चु ईसु काजे बेसकु गुळु देदु। ");
INSERT INTO bhi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ईसु यहुदा काजे कह्‌यु, “ए दुस्‌तीदार, तीना काम वाटे तु आवलु छे, तीना काम काजे कर ले।” तत्‌यार चे धड़े आवीन ईसुक धर लेदा। ");
INSERT INTO bhi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ईसुन साती मां सी एक जणु हात अगु करीन आपणा मीयान मां सी तलवार काजे नीकाळ लेदु ने मुख्‌या पुजारान पावर्‌यान दीन तीना पावर्‌यान कान्‌‌टा काजे काट नाख्‌‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","तत्‌यार ईसु तीना काजे कह्‌यु, आपणी तलवार काजे मीयान मां मेकले “काहाकी जे तलवार सी मारसे चे आखा तलवार सी माराय जासे। ");
INSERT INTO bhi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","काय तु नी जाणे की आपणा बास सी मे लीलघाय्‌न कह्‌व, ने चु सरग वाळा काहवाळ्‌यान बारे टुळा सी बी जादा टुळु मारे धड़े हींताळ मकली देसे? ");
INSERT INTO bhi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","बाकुन चुखला सास्‌तुर मां जी वाते असोत हवणेन जरुरी छे, कसी पुरी हवसे?” ");
INSERT INTO bhi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","तीनी टेमे ईसु माणसेन टुळा सी कह्‌यु, “काय तुहुं तलवार्‌या ने डेंगा लीन मेसेक डाकु समजीन धरने आय रया काय? मे दाहड़ीन मंदीर मां भरायन सीकाड़्‌या करतेलु ने तुहुं मेसे नी धर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","बाकुन जे आखा तेरेमां हयो की भगवानेन अघी सी आवणे वाळी वात देखान्‌यान बुल पुरो हवे।” तत्‌यार आखा चेला ईसुक छुड़ीन ढास गुया। ");
INSERT INTO bhi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","तत्‌यार ईसुक धरने वाळा तीना काजे काइफा नावेन मुख्‌या पुजारा धड़े लीन गुया, चां यहुदी नीयम सीकाड़न्‌‌या मास्‌तर्‌या ने आड़ा-बुड़ा भेळा हय रवला। ");
INSERT INTO bhi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","पतरस छेटे-छेटे ईसु पछळ-पछळ मुख्‌या पुजारान आंगणाम लग गुयु, ने घर मां जाय्‌न ईसु साते काय करे ने काय हवे चो देखणे करीन राखवाळ्‌या पावर्‌या भेळु जाय्‌न बठ गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","मुख्‌या पुजारु ने आखा माणसे भेळा हयन ईसु काजे मार नाखणे वाटे ईसुन वीरुद मां झुटी गवा हेर रवला। ");
INSERT INTO bhi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","बाकुन बेसका झुटी गवाय देण्‌या आवणे पर बी वाक नी नीकाळ्‌या। आकरी मां दुय जणा आया, ");
INSERT INTO bhi_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","असा कह्‌या, “गुयु अदमी असु कवलु, की भगवानेन मंदीर काजे उदार सको ने हीनाक तीन दाहड़ाम अळी बणाय सको।” ");
INSERT INTO bhi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","तत्‌यार मुखी पुजारु हुबु हयन ईसु सी कह्‌यु, “काय तु काय बी जपाप नी देतु? जे माणसे तारा वीरुद मां काय गवाय देय?” ");
INSERT INTO bhi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","बाकुन ईसु हुगुत हय रयु। तत्‌यार मुखी पुजारु ईसुक कह्‌यु, “मे तुसे जीवतेला भगवानेन सगुन आपो की कदी तु भगवानेन पुर्‌यु मसी छे, ती हामरे सी कय दे।” ");
INSERT INTO bhi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ईसु तीना काजे कह्‌यु, “तु आपसुत कय देदु; नीते मे तुंद्‌रे सी ज्‌य बी कवतु की हय सी तुहुं माणसेन पुर्‌या काजे आखा सी ताकत वाळा भगवानेन जेवड़े आंगे बठलु, ने सरगेन आदळा पर आवतेलु देखसु।” ");
INSERT INTO bhi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","हेरसी मुखी पुजारु हेरा पुथल्‌या फाड़्‌यु ने कह्‌यु, जु भगवानेन वाक नीकाळ्‌ळु छे हय हामुक गवान जरुवत नी हय? देखु तुहुं बी ज्‌य वाक सामळावला छे। ");
INSERT INTO bhi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","तुंद्‌रा आखान काय वीच्‌यार छे? चे जपाप आप्‌या जु गुना वाळु छे, हीनाक मुतेन डंड जड़नु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","तत्‌यार चे ईसुन मुंहडा पर थुप्‌या ने तीना काजे धुमाट्‌या ने दीसरा थापड़ाया ने असा कह्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ए मसी हामरे सी भगवानेन अघी सी आवणे वाळी वात देखाड़ने वाळु करीन कह्‌वी की तुसे कुण ठुक्‌यो? ");
INSERT INTO bhi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","पतरस बाहर आंगणा मां बठलु हतलु, की एक पावरनी पतरस धड़े आय ने कय, “तु बी ते ईसु गलील जीला वाळा साते हतलु।” ");
INSERT INTO bhi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","पतरस आखा माणसे अगळ असो कवीन ईसु काजे नीकारु देदु, “मे नी जाणतु तु काय कय रय।” ");
INSERT INTO bhi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","जत्‌यार पतरस बाहर बारना धड़े गुयु ती दीसरी पावरनी पतरस काजे देखी ने जे वां हुबा हय रवला माणसे काजे कय, “जु बी ते ईसु नासरी साते हतलु।” ");
INSERT INTO bhi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","पतरस सगुन खाय्‌न अळी ईसु काजे नीकारु देदु, “मे तीना माणुस काजे नी जाणो!” ");
INSERT INTO bhi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","थुड़ीक वार मां माणसे चां हुबा हय रवला, चे पतरस धड़े आवीन तीना काजे कह्‌या, “छाचलीन तु बी हींद्‌रे मां सी एक छे, काहाकी तारी बुली तुसे उजेंती कर देदी की तु चांहान वालु छे।” ");
INSERT INTO bhi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","तत्‌यार पतरस झीचकारने ने सगुन खाणे लाग्‌यु! “मे तीना माणुस काजे नी जाणतु।” ने तत्‌काल कुकड़ु आस देदु। ");
INSERT INTO bhi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","तत्‌यार पतरस काजे ईसु कवलु ची वात हेर आय गुय, “ईसु कवलु कुकड़ा आसणेन पेहल तु तीन कावा मारो नीकारु कर देसी।” ने पतरस बाहार जाय्‌न उसकी-उसकीन रड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","जत्‌यार एगात आखा मुख्‌या पुजारा ने माणसेन डाहा बुड़ा ईसु काजे मार नाखणे करीन मुजगी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","चे ईसुक बांद्‌या ने ली जाय्‌न पीलातुस सरकारेन हात मां आप देदा। ");
INSERT INTO bhi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","जत्‌यार तेरु धराड़ने वाळु यहुदा देख्‌यु की तेरे उपर गुनु लाग गुयु ती हयु पसतायु ने हयु तीस चांदीन सीक्‌‌का काजे मुख्‌या पुजारा ने डाहा बुड़ा नेता भीणी पछु देणे लीन आयु ");
INSERT INTO bhi_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ने कह्‌यु, “मे नी-गुना वाळा खुन करीन धराड़ीन पाप कर्‌यु!” चे कह्‌या, “हामुक काय करनु? तुत जाण।” ");
INSERT INTO bhi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","तत्‌यार हयु तीनु सीक्‌‌का काजे मंदीर मां नाखीन जाती रयु, ने जाय्‌न आपसुत टांगायन मर गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","मुख्‌या पुजारा तीनु सीक्‌‌का काजे लीन कह्‌यु, “तीनुक, दान पेटी मां मेकणु वारु नी हय, काहाकी जे खुनेन कीमत वाळा छे।” ");
INSERT INTO bhi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","तेरेमां चे मुजगी करीन तीनु सीक्‌‌का सी पारका देसेन माणसे काजे गाड़ने वाटे कुमाहरेन खेत मुल ली लेदा। ");
INSERT INTO bhi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ईनी वजे सी च खेत आज लग लुहीन खेत कह्‌वाये। ");
INSERT INTO bhi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","तत्‌यार ज बुल यीर्‌मयाह भगवानेन अघी सी आवणे वाळी वात देखान्‌यान साहरे कह्‌वलो हतलो च पुरो हयो: “चे तीनु तीस सीक्‌‌का मतलब तीनु ठहरावली कीमत काजे तीनाक ईस्‌रायेली माणसेन अवल्‌यात मायन जतरा ठहरावलो हतलो ली लेदा, ");
INSERT INTO bhi_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ने जसों मालीक मेसेक हुकुम देदु तसोत कुमाहरेन खेतेन कीमतेन हीसाब मां दी देदु।” ");
INSERT INTO bhi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","जत्‌यार ईसु रोमी सरकार पीलातुस अगळ उबु हतलु, ती सरकार वाळु, तीना काजे पुछ्‌या, “तु यहुदीन राजु छे?” ईसु तीना काजे कह्‌यु, “तु आपसुत कय रयु।” ");
INSERT INTO bhi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","जत्‌यार मुख्‌या पुजारा ने आड़ा-बुड़ा नेता तीना उपर गुनु लागाड़ रवला, ती हयु काय बी जपाप नी देदु। ");
INSERT INTO bhi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","अतरा पर पीलातुस सरकार वाळु तीना काजे कह्‌यु, “काय तु नी सामळतु, की जे तुसे धराड़ने करीन कतरी गवाय दी रया।” ");
INSERT INTO bhi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","बाकुन हयु तीना काजे एक वातेन बी जपाप नी देदु, ने जां लग बी की सरकार वाळा बी घाबराय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","सरकारेन असी रीत हतली की तीना तीहवार मां एक केदी काजे जेल मां सी छुड़तेलु, ने माणसे तीना काजे बी कह्‌वतेला तीनाक छुड़ दे तीना काजे छुड़ देदलु। ");
INSERT INTO bhi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","तीनी टेमे तींद्‌रेन्‌चां एक बरअब्‌बा नावेन एक अंजाण्‌यु माणुस जेल मां हतलु। ");
INSERT INTO bhi_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ने जत्‌यार चे भेळा हया, ती पीलातुस तीनुक पुछ्‌यु, “तुहुं कुणीन चाहु की मे तुंद्‌रे वाटे छुड़ दम? बरअब्‌बा काजे, की ईसुक चु मसी कह्‌वाये?” ");
INSERT INTO bhi_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","काहाकी हयु जाणतेलु की हया तीना काजे कुहराये धराड़ला छे। ");
INSERT INTO bhi_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","जत्‌यार हयु नीयावेन गादी पर बठी रवलु ती हेरी घरवाळी कय मकली, “तु तीना वारलु माणसेन लफड़ा मां हात घुण नाखे, मे आज सपना मां तेरे वजे सी बेसकी मटी दुख हाकेलु।” ");
INSERT INTO bhi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","मुख्‌या पुजारा ने डाहा बुड़ा नेता माणसे काजे समजाड़्‌या की चे बरअब्‌बा काजे छुड़नेन मांग करे, ने ईसु काजे खत्‌तम कराड़ देय। ");
INSERT INTO bhi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","सरकारी पीलातुस तीनुक पुछ्‌यु, “हीनु दुय मायन कुणीक तुहुं चाहु, की मे तुंद्‌रे वाटे छुड़ दम?” चे कह्‌या, “बरअब्‌बा काजे।” ");
INSERT INTO bhi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","पीलातुस तीनुक पुछ्‌यु, “ती मे ईसुक काय करो, जु मसी कह्‌वाये?” आखा तीना काजे कह्‌या, “तीना काजे कुरुस पर चड़ावु।” ");
INSERT INTO bhi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","सरकार कह्‌यु, “काहा, हयु काय गलत कर्‌यु?” बाकुन चे अळी बी आयड़ी-आयड़ीन कह्‌वणे लाग्‌या, “तीना काजे कुरुस पर चड़ावु।” ");
INSERT INTO bhi_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","जत्‌यार पीलातुस देख्‌यु की जे मारी नी सामळता ने उल्‌टा हुड़ी रया ने वात अघी बड़े ती हयु पाणी लीन आखा माणसेन टुळु अगळ हात धुयु ने कह्‌यु, “मे हीना धरमी माणसेन खुन नी करतु ने काय बी खामी नी हय ईनी वात काजे तुहुं जाणु।” ");
INSERT INTO bhi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","आखा माणसे जपाप देदा, “हेरो खुन हामरे उपर ने हामरी अवल्‌यात पर हवणी दे!” ");
INSERT INTO bhi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","हीनी वात पर हयु बरअब्‌बा काजे हींद्‌रे वाटे छुड़ देदु, ने ईसु काजे सुटाटीन सीपायड़ान हात मां आप देदु, काहाकी तीना काजे कुरुस पर चड़ावे। ");
INSERT INTO bhi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","तत्‌यार रोमी सरकारेन पीलातुसेन सीपायड़ा ईसु काजे कीला मां ली जाय्‌न, चां आखा सीपायड़ान टुळा काजे भेळा कर लेदा, ");
INSERT INTO bhi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ने तेरा पेहला पुथल्‌या नीकाळीन तीना काजे रातला रंगेन लांबला पुथल्‌या पेहराया। ");
INSERT INTO bhi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ने काटाळ्‌यु मुकुट गुथीन तेरा मुणका उपर मेल्‌या, ने तेरा जेवड़े हात मां बुरीन सुटी धराय देदा, ने चे तेरे अगळ मांडा टेकीन तीना काजे हासी कर्‌या, ने कह्‌या, ए यहुदीयान राजा, वारु छे की? ");
INSERT INTO bhi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ने तेरे उपर थुप्‌या, ने तीनीत बुरीन सुटीक हापकीन तेरे मुणके देदा। ");
INSERT INTO bhi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","अळतेन चे हासी-उडाड़ीन चे ईसुन रातलो झगल्‌यो नीकाळ देदा, ने तेरा पेहला पुथल्‌या पेहराया, ने कुरुस पर चहड़ावणे ली गुया। ");
INSERT INTO bhi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","जत्‌यार चे सहरेम सी नीकळीन जाणे बाजी रवला, ती तीनुक सीमोनेन नावेन एक कुरेन गांव मां रवण्‌यु सीमोन नावेन एक अदमी भेळु हयु, ने चे तीना काजे बीहाड़ीन ईसुन कुरुस काजे हाकलाड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","चे तीनी जागा पर पुग्‌या, गुलगुता मतलब, माणसेन टुबरान जागु कह्‌वाये चां ली गुया, ");
INSERT INTO bhi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","चे ईसुक कड़वो चीज भेसकेलु अंगुरेन रस पीणे आप्‌या, बाकुन ईसु चाख्‌यु बाकुन पीदु नी। ");
INSERT INTO bhi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","तत्‌यार चे तीना काजे कुरुस पर चड़ाया, ने तेरा पुथल्‌या कुणी-कुणीक जड़से करीन चिट्‌ठी नाखीन तेरा पुथल्‌या वाट लेदा। ");
INSERT INTO bhi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ने चां बठीन ईसुन देख-भाळ करने लाग्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ने चे ईसुक मुणका सी उपर कुरुस पर एक लाकड़ान पट्‌टी खीळा ठुकीन टांग देदा, तीनी पट्‌टी पर ईसुन जु गुनु लिखलु हतलु, “जु यहुदीयान राजु ईसु छे” ");
INSERT INTO bhi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","तत्‌यार तेरे भेळा दुय डाकु हतला एक जेवड़्‌ये आंग्‌ये ने दीसरु डाखर्‌ये आंग्‌ये कुरुस पर चड़ाय देदा। ");
INSERT INTO bhi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ने चां आवणे-जाणे वाळा माणसे मुणका डुलावता-डुलावता जाय्‌न हासी उड़ाया ने तेरी जबरान वाक नीकाळ्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ने असा कवतेला, “ए मंदीर काजे उदारने वाळा ने तीन दाहड़ा मां पछु बणावणे वाळा, तु आपसाक ते बचाड़! कदी तु भगवानेन बेटु हय ती कुरुस सी उतरी आव।” ");
INSERT INTO bhi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","हीनीत रीत सी मुख्‌या पुजारा, यहुदी नीयम सीकाड़न्‌या मास्‌तर्‌या ने डाहा बुड़ा हेरी हासी उड़ाया। ");
INSERT INTO bhi_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","हयु दीसरा काजे वाचाड़्‌यु, ने आपणे आप काजे नी बचाड़ सके। हयु ते ईस्‌रायेलेन राजु छे कदी हय कुरुस पर सी उतरी आवे ती हामु हीना पर भुरसु करसुन। ");
INSERT INTO bhi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","हयु भगवान पर भुरसु राख्‌‌यु; कदी चु चाहतु, ती हींताळ तीना काजे बचाड़ लेय काहाकी हयु कवलु मे भगवानेन पुर्‌यु छे! ");
INSERT INTO bhi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","हेरेन तसु डाकु बी जे तेरे साते कुरुस पर चड़ावला हतला चे हेरी नाव-बद्‌दी करतेला। ");
INSERT INTO bhi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","मांजणीक टेमे बारे बजे सी तीन बजे लग आखा देस मां आंदारलो छावाय रयो। ");
INSERT INTO bhi_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","तीनेक बजे ईसु मटी अवाज मां आयड़ीन कह्‌यु, “एली, एली, लमा सबक्‌तानी?” हेरो मतलब “ए मारा भगवान, ए मारा भगवान, तु मेसे काहा छुड़ देदु?” ");
INSERT INTO bhi_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","जे चां उबा हतला हींद्‌रेम सी बेसका माणसे ज सामळीन कह्‌या, “हयु ते एलीय्‌याह काजे आयड़ी रयु!” ");
INSERT INTO bhi_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","हींद्‌रे मां सी एक जणु छाटु दवड़्‌यु ने पुतो लीन अंगुरेन रस मां डुबाड़्‌यु ने सुटी पर मेळीन ईसुक चुसाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","दीसरा कह्‌या, “रहणी देवु, देखजे एलीय्‌याह तीना काजे बचाड़ने आवे की नी।” ");
INSERT INTO bhi_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","तत्‌यार ईसु अळी मटला अवाज मां आयड़ीन जीव छुड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ने देखु, मंदीरेन पड़दु उपर सी नेचु लग फाटीन दुय भाग मां हय ज्‌य, ने धरती हाल गुय ने चापर्‌या फाटणे लाग गुयु, ");
INSERT INTO bhi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ने मसाण्‌या उघड़ी गुया ने भगवानेन बेसका मरला चुखला माणसेन डील जीवता हय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ने चे मसाण्‌या मां सी जीवता हय्‌न नीकळीन चुखला सहर मां गुया ने बेसका माणसे काजे देखाया। ");
INSERT INTO bhi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","तत्‌यार सुबेदार ने जे तेरे साते ईसुन राखवाळी करतेला, चे आखो ज काय हय च देखीन बेसका बीही गुया, ने कह्‌या, “छाचलीन हयु भगवानेन पुर्‌यु हतलु!” ");
INSERT INTO bhi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","चां बेसका बायरा गलील जीला मां सी ईसुन चाकरी करती-करती तेरे साते आवली ची ज काय हयो च देखी रवली। ");
INSERT INTO bhi_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","हींद्‌रे मां मरीयम मगदलनी, ने याकुप ने योसेपेन माय मरीयम, ने जब्‌दीन पुर्‌यान माय हतली। ");
INSERT INTO bhi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","जत्‌यार सांती हयो ती युसुफ नावेन अरीमतीया गांवेन एक पयस्‌या वाळु एक माणुस, ज्‌य आपसुत ईसुन चेलु बणलु हतलु, चु आयु। ");
INSERT INTO bhi_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","हयु पीलातुस धड़े जाय्‌न ईसुन धड़ मांग्‌यु। ईनी वात पर पीलातुस तीना काजे हुकुम आप्‌यु, की डील ली जावु। ");
INSERT INTO bhi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","युसुफ धड़ ली लेदु, ने एक वारला चादरा मां वेलटी लेदु। ");
INSERT INTO bhi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ने तीना काजे तेरा नवला मसाण मां मेक देदु, ची मसाण हयु चापर्‌या मां खुदाड़ रवलु, ने मसाणेन बारना पर मट्‌लु दगड़ु गबड़ायन जाती र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","मरीयम मगदलनी ने दीसरी मरीयम चां मसाण अगळ बठी रवली। ");
INSERT INTO bhi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","दीसरे दाहड़े ज्‌य तीहवारेन दाहड़ान पछेन दाहड़ु हतलु, मुख्‌या पुजारा ने फरीसी माणसे पीलातुस धड़े भेळा हयन कह्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ए माहाराज, हामुक हेर छे की हयु धुकु देणेवाळु जत्‌यार जीवतेलु हतलु, ती कवतेलु की मे तीन दाहड़ाम पछु मर्‌या-सर्‌या सी जीवतु हय जायस।” ");
INSERT INTO bhi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","तेरेमां हुकुम दे की तीन दाहड़ा लग मसाणेन राखवाळी करजे, असो नी हय जाय की तेरा चेला आवीन तीना काजे चुरी करीन ली जाती रवे, ने माणसे सी कह्‌वणे बाजी जाय की, हयु मरलाम सी जीवतु हय गुयु। तत्‌यार जु पछलु धुकु पेहले सी बी जादा हवसे। ");
INSERT INTO bhi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पीलातुस तीनुक कह्‌यु, “तुंद्‌रे धड़े राखवाळ्‌या हय ते। जावु, ने वारु समज सी राखवाळी करु।” ");
INSERT INTO bhi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","तेरेमां चे राखवाळ्‌या काजे पुठ्‌ये लीन गुया, ने दगड़ा पर छाप लागाड़ीन मसाणेन राखवाळी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","आरामेन दाहड़ान पछे ने हाप्‌तान पेहले दाहड़े संदारे एगात वीजाळो हवतेत मरीयम मगदलनी ने दीसरी मरीयम मसाण्‌या मां देखणे आय। ");
INSERT INTO bhi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","चे देख्‌या, एक मटु भुकम आयु काहाकी मालीकेन एक सरग वाळु काहवाळ्‌यु सरगे सी उतर्‌यु ने धड़े आवीन सरग वाळु काहवाळ्‌यु चापर्‌या काजे उन्‌‌धु कर देदु, ने तीना चापर्‌या पर बठ गुयु। ");
INSERT INTO bhi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","तेरु सीकु वीजळीन तसों हतलो ने तेरो पुथल्‌यो बरफेन तसों उजल्‌ळो हतलो। ");
INSERT INTO bhi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","पेहरु देण्‌या बीहीयन सीयारी ली लेदा, ने मरलान तसा हय गुया। ");
INSERT INTO bhi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","सरग वाळु काहवाळ्‌यु तीनु बायरा काजे कह्‌यु, “मां बीहु, मे जाणो की तुहुं ईसु काजे गुयु कुरुस पर चड़ावला तीना काजे हेरने बाजी रय। ");
INSERT INTO bhi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","चु जां नी हय बाकुन आपणा बुल मां कवलु तसुत मरलाम सी जीवतु हय गुयु। आवु, चु जागु देख लेवु, जां मालीक काजे मेल्‌ला, ");
INSERT INTO bhi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ने हींताळ छाटा जाय्‌न तेरा चेला काजे कह्‌वु की चु मरलाम सी जीवतु हय गुयु ने तुंद्‌रे सी पेहल गलील जीला मां जासे चां तुहुं तीना काजे देखसु देखु मे तुहुंक कय देदु।” ");
INSERT INTO bhi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","चे बायरा बीहीन ने बेसकी खुस हय्‌न मसाण मां सी पछा आवीन ईसुन चेला काजे कवणे वाटे दवड़ीन आवी। ");
INSERT INTO bhi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","तत्‌यार ईसु तीनु बायरा काजे भेळु हयु। ने कह्‌यु, “वारु छे की करीन कह्‌यु।” ची बायरी धड़े आवीन ने ईसुन पाय धरीन तीना काजे आंध्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","तत्‌यार ईसु तीनुक कह्‌यु, “बीहु मां; मारा भायसेक जाय्‌न कह्‌वु की गलील जीला मां जाती रवु, चां मेसे देखसु।” ");
INSERT INTO bhi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","चे बायरा जाणी बाजी रवला ने पेहरु देण्‌या मां सी थुड़ाक जणा सहर मां आया ने मसाण मां ज्‌य काय हयो चो मुख्‌या पुजाराक कवीन सामळाय देदा। ");
INSERT INTO bhi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","तत्‌यार चे डाहा-बुड़ा माणसे साते भेळा हयन मुजगी कर्‌या ने सीपायड़ा काजे बेसका पयस्‌या आपीन कह्‌या, ");
INSERT INTO bhi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“असा कवजु की राते जत्‌यार हामु सुय रवला ती तेरा चेला आवीन ईसुन धड़ काजे चुरी करीन लीन जाती रया। ");
INSERT INTO bhi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ने कह्‌या कदी जी वात रोमी सरकारेन कान्‌टा मां लग जाती रवसे ती हामु तीना काजे समजाड़ीन तुहुंक डंड सी बचाड़ लेसुन।” ");
INSERT INTO bhi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","अळतेन चे पेहरु देण्‌या पयस्‌या ली लेदा ने जसा तीनुक सीकाड़ला हतला तसात चे कह्‌या जी वात आज लग यहुदी माणसे मां चाल रय। ");
INSERT INTO bhi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ग्‌यारे चेला गलील जीलान तीना बयड़ा पर गुयला, चां ईसु तीनुक बताड़लु। ");
INSERT INTO bhi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","चे ईसु काजे देखीन तीना काजे आंध्‌या बाकुन काहनाक-काहनाक काजे भुरसु नी हयु। ");
INSERT INTO bhi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ईसु हींद्‌रे धड़े आवीन कह्‌यु, “सरगेन ने धरतीन आखु हक मेसे जड़लु छे। ");
INSERT INTO bhi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","तेरेमां तुहुं जावु, ने आखी जातीन माणसे काजे चेला बणावु; ने तीनुक बास, ने पुर्‌यु, ने चुखली-आत्‌मान नाव सी बपतीस्‌मा देवु, ");
INSERT INTO bhi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ने तीनुक आखी वात जी मे तुहुंक हुकुम आपो, मान्‌ने सीकाड़। ने देखु, मे कळीन खत्‌तम हवणे लग जलम मे तुंद्‌रे साते रवीस।”");
INSERT INTO bhi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","भगवानेन पुर्‌यु ईसु मसीन खुस-खबरेन बारामां असी सुरुवात हय। ");
INSERT INTO bhi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","जसु मालीक भगवानेन अघली वात बताड़ने वाळु यसायाह नावेन माणसेन किताप मां लिखलो हतलो: “चां कह्‌लु की, मे मारी वात बताड़ने वाळाक मे तुंद्‌रे अगळ मकलीस, ने चु तुंद्‌रे वाटे वाट सुदारसे। ");
INSERT INTO bhi_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","उजाड़्‌या बयड़ा मां एक आयड़ने वाळान वात सामळाय रय, की मालीक भगवानेन वाट तीयार करु, ने तेरे वाटे सयड़क सुदी करु।” ");
INSERT INTO bhi_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","तेरेमां बपतीस्‌मा आपणे वाळु युहन्‌‌‌नु आयु, ने उजाड़्‌या बयड़ा मां रहणे वाळा माणसेक परचार कर्‌यु की, “बपतीस्‌मा लेवु।” ने तीनुक कह्‌यु की, पाप करनु छुड़ देवु, “तत्‌यार तुंद्‌रा पाप काजे भगवान माफ करसे।” ");
INSERT INTO bhi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ने यहुदीया ईलाका मायन ने यरुसलेम सहर मायन बेसका माणसे नीकळीन तेरे धड़े गुया; ने आपणा-आपणा पाप काजे मानीन यरदन नदी मां युहन्‌ना सी बपतीस्‌मा लेदा। ");
INSERT INTO bhi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","युहन्‌‌‌नु उटड़ान कान्‌‌‌यान पुथल्‌या पेहरी रवलु, ने कमर मां चामड़ान पट्‌टु बांदी रवलु, ने चु टिड्‌डा ने अळी बयड़ा मां मुहाळेन मखड़ा खाया करतेलु। ");
INSERT INTO bhi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ने युहन्‌ना ज परचार करतेलु की मारे पछळ आवणे वाळु छे, चु मारे सी ताकतवाळु छे, “मे तेरे लायक बी नी हय की ढंगु अळीन खासड़ान बंद खुली सको। ");
INSERT INTO bhi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","मे ते तुहुं काजे पाणी सी बपतीस्‌मा देदु, बाकुन चु तुहुं काजे चुखली-आत्‌मा सी बपतीस्‌मा देसे।” ");
INSERT INTO bhi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","तीनु दाहड़ा मां ईसु गलील जीलान नासरत सहर सी आवीन युहन्‌ना सी यरदन नदी मां बपतीस्‌मा लेदु। ");
INSERT INTO bhi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","जसुत ईसु पाणी मां सी डुबीन बाहर नीकळयु, चां तत्‌यारुत च सरग खुल ज्‌य, ने चुखली-आत्‌मा पेरवान तसों भगवानेन आत्‌मा काजे उतरतेलु देख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ने सरग मां सी असो सामळायो की, जु मारु लाटेक्‌लु पुर्‌यु छे, “ने मे हेरे सी बेसका खुस छे।” ");
INSERT INTO bhi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","तत्‌यारुत भगवानेन आत्‌मा ईसु काजे उजाड़्‌या बयड़ा भीणी ली गुयु, ");
INSERT INTO bhi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","बयड़ा मां ईसु चाळीस दाहड़ा लग भुतड़ु पाप कराड़्‌ने पारखतेलु, ने ईसु जंगली जनवार्‌यान ईचमां रयु, ने सरग वाळा काहवाळ्‌या चां आवीन तेरी सेवा चाकरी करतेला। ");
INSERT INTO bhi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","युहन्‌‌‌नु जेल मां धराय गुयु, ने पछेन ईसु गलील जीला मां आवीन भगवानेन खुस-खबरेन बारामां परचार कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ने कह्‌यु “की टेम पुरो हय गुयो,” ने भगवानेन राज तुंद्‌रे धड़े आय लागलो छे, “ने तुहुं पाप सी पछा मन फेरवीन भगवान भीणी आवु ने खुस-खबर पर भुरसु करु!” ");
INSERT INTO bhi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ने ईसु गलील दरीया धड़े-धड़े जातलु चां माछा धरन्‌याक दुय भाय काजे देख्‌यु, सीमोन ने अन्‌दीरीयास काजे पाणी मां जाळ नाखतेला देख्‌यु काहाकी चे काहर्‌या हतला। ");
INSERT INTO bhi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ईसु तीनुक कह्‌यु “मारे पछळ आवु; ती मे तुहुंक माछा धरनेन जागा पर माणसे काजे भगवानेन राज मां लावणे वाळा बणावीस।” ");
INSERT INTO bhi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","चे तत्‌यारुत जाळ काजे छुड़ीन ईसु पुठ्‌ये चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ईसु अघु जाय्‌न जब्‌दीन पुर्‌या याकुप ने तेरु भाय युहन्‌ना काजे ढंड्‌या मां जाळ सुदारतेला देख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ने ईसु तीनु काजे तेरा चेला बणावणे करीन तत्‌यारुत बुलायु ने चे आपसान बास जब्‌दी काजे दाहड़क्‌या पुठ्‌ये ढंड्‌या मां छुड़दीन ईसु पछळ चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","तत्‌यार चु कफरनहुम मां आयु ने चु तत्‌यारुत यहुदीन आरामेन दाहड़े ईसु तींद्‌रा भक्‌तीन घर मां गुयु ने सीकाड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ने माणसे ईसुन खबर सामळीन देखतात रय गुया, काहाकी हयु तीनुक नीयमेन मास्‌तर्‌यान तसु नी सीकाड़तेलु, बाकुन एक मटला हकवाळान तसु तीनुक सीकाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","तीनीत टेमे तींद्‌रा यहुदीन भक्‌तीन घर मां एक माणुस आयु, तेरे भुतड़ु लागी रवलु। ");
INSERT INTO bhi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","चु भुतड़ु आयड़ीन कह्‌यु की “ए ईसु नासरी, हामुक तार सी काय काम? काय तु हामुक नास करने आयु? मे तुसेक जाणो, की तु कुण छे? तु चुखला भगवानेन वात बताड़न्‌यु छे!” ");
INSERT INTO bhi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ईसु तीना काजे लड़ीन कह्‌यु, “हुगु रव; ने कह्‌यु हेरेम सी नीकळी जां।” ");
INSERT INTO bhi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","तत्‌यार भुतड़ु तीना माणुस मां सी जुर सी आयड़ीन नीकळी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ने आखा माणसे ज देखीन देखतात रय गुया ने आंबा-सांबा वीच्‌यार करने बाजी गुया की, जी काय वात छे, ज ते पेहली कावा देख्‌या ने नवली वात छे? ईसु पुरा हक सी भुतड़ा काजे कहें, ने चे हेरी कह्‌ली वात काजे माने। ");
INSERT INTO bhi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ने ईसुन नाव तत्‌यारुत गलीलेन आखा ईलाका मां फेल गुयो। ");
INSERT INTO bhi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ईसु तत्‌यारुत यहुदीन भक्‌तीन घर मां सी नीकळीन याकुप ने युहन्‌ना काजे एखला छुड़ीन ने चे सीमोन ने अन्‌दीरीयासेन घर मां आया। ");
INSERT INTO bhi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","सीमोनेन सासुस मांदवाड़ेन वजे सी खाट्ला मां सुय रवली, तेरेमां हेरी सासुसेन बारामां बताड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","तत्‌यार ईसु धड़े जाय्‌न तेरु हात धरीन बठी कर्‌यु; ने तेरो सेरी उतरी गुयो, ने ची तेरी सेवा चाकरी करने बाजी गुय। ");
INSERT INTO bhi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","सांती वेळाय दाहड़ु डुब्‌यु तत्‌यार आखा मांदला माणसे ने भुतड़ा लागला माणसे ईसु धड़े लाया। ");
INSERT INTO bhi_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ने आखा गांवेन माणसे तीना घरेन अगळ भेळा हय गुया। ");
INSERT INTO bhi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","बेसका माणसे चां भाती-भातीन मांदवाड़ सी मांदला हतला, तीनु काजे ईसु वारु कर्‌यु, ने तींद्‌रे मां सी बेसका भुतड़ा बी नीकाळ्‌यु काहाकी भुतड़ा ईसु काजे उळखतेला असु करीन ईसु तीनु काजे बुलने बी नी देदु। ");
INSERT INTO bhi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","वीजाळो हवणे सी पेहेल ईसु उठ्‌यु ने घरेक छुड़ीन दुवा करने वाटे उजाड़्‌या जागा मां जाती र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","तत्‌यार सीमोन ने तेरा दुस्‌तीदार ईसु काजे हेरने लाग्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","जत्‌यार ईसु तीनु काजे जड़ी गुयु; ती चे तीनाक असा कह्‌या, की “आखा माणसे तुसेक हेरने बाजी रया।” ");
INSERT INTO bhi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ईसु तीनुक कह्‌यु, “चालु आपणु आड़े-धड़ेन गांव मां जाता ने चां बी आपणुक खुस-खबरेन परचार करनु छे, काहाकी मे जत काम करने वाटे दुनीया मां आयु छे।” ");
INSERT INTO bhi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","तेरेमां ईसु गलीलेन आखा जीला मां तींद्‌रा यहुदीन भक्‌तीन घर-घर मां जाय जाय्‌न परचार करतु रयु, ने भुतड़ा काजे नीकाळतु रयु। ");
INSERT INTO bhi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","एक कुड़ायलु माणुस ईसु धड़े आयु, “ने तेरे अगळ मांडा टेकीन लीलघाय्‌न कह्‌यु, कदी तु चाहे ती मेसेक वारु कर दे।” ");
INSERT INTO bhi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ईसु काजे तेरे पर बेसकी तरस आय, की चु तीना काजे छीमीन कह्‌यु, “मे चाहो की तु चुखु हय जां।” ");
INSERT INTO bhi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ने तत्‌यारुत तेरु कुड़ वारु हय गुयु ने चु चुखु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","तत्‌यार चु तीनाक तत्‌यारुत चेतायु ने जां करीन कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ने तीनाक कह्‌यु, “सामळ जी वात कुय काजे घुण कहें, बाकुन जाय्‌न आपसा काजे पुजाराक देखाड़ ने आपसा चुखु हवणेन बारामां ज काय मुसु ठहरावलु छे तीनाक बादा चड़ाव की तींद्‌रा गवा बण जाय।” ");
INSERT INTO bhi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","बाकुन हयु जाय्‌न आखा काजे परचार करने लाग्‌यु, ने अतरे दुर लग की फेल गुयो, ईसु पछेन खुल्‌लाम-खुल्‌ला फीरी नी सक्‌यु, बाकुन बाहर जाय्‌न बयड़ा मां रयु, ने चारे मेरेन माणसे तेरे धड़े आवणे लाग्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","थुड़ाक दाहड़ा मां ईसु पछु कफरनहुम गांव मां आयु, ने चां आखी दुर मालुम हय गुयो; की ईसु जां रहतेलु चो घर छे। ");
INSERT INTO bhi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","बेसका माणसे ईसुन चां आया ने आखो घर भराय गुया ने बारना मायन बी जागा नी रय। ने ईसु तीनु काजे खुस-खबरेन परचार करने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ने एक लखवान मांदवाड़ मां पड़ रवला एक माणुस काजे चार जणा हाकलीन ईसु धड़े लाया। ");
INSERT INTO bhi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","बाकुन जत्‌यार माणसेक चां नी जावायो काहाकी चां गड़दी बेसकी हतली; ती चे घर पर चहड़्‌या ने बमड़े सी कवलु हेड़ देदा ने मांदला काजे ईसु अगळ खाट्‌ली भेळात उतार देदा। ");
INSERT INTO bhi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ईसु तींद्‌रु भुरसु देखीन तीना लखवा मां पड़ला माणुस काजे कह्‌यु, “ए पुर्‌या तारा पापेन माफी जड़ गुयली छे।” ");
INSERT INTO bhi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","तत्‌यार थुड़ाक नीयमेन मास्‌तर्‌या बी चां हतला, चे तींद्‌रा मन मां वीच्‌यार करने बाजी गुया, ");
INSERT INTO bhi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“जु माणुस काहा असु कवतु हसे? जु ते भगवानेन नाव-बद्‌दी करे! बाकुन भगवान काजे छुड़ीन कुय बी पाप माफ नी कर सके।” ");
INSERT INTO bhi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","तत्‌यारुत ईसु तींद्‌रा आत्‌मान मन मायन वात काजे जाण लेदु ने कह्‌यु “तुहुं मन मां असा वीच्‌यार काहा कर रया? ");
INSERT INTO bhi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","हेरेम वारु काय छे? काय लखवान मांदवाड़ वाळाक ज कह्‌णु की तारा पापेन माफी तुसेक जड़ गुय, कह्‌णु की उठ, तारी खाट्‌ली हाकलीन चाल पड़? ");
INSERT INTO bhi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","बाकुन हेरेसी तुहुं जान लेवु, की माणसेन पुर्‌या काजे धरती पर पाप माफ करनेन बी हक छे।” ईसु तीना लखवान मांदला माणुस काजे कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“मे तार सी कहं की, उठ, तारी खाट्‌ली हाकलीन तार घर जाती रव।” ");
INSERT INTO bhi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","चु तत्‌यारुत उठ्‌यु ने वारु हय गुयु ने खाट्‌ली हाकलीन आखा अगळ सी नीकळीन जात रयु, ईना कामेक देखतात रय गुया ने, भगवानेन बड़ाय करने लाग गुया, ने कह्‌णे लाग्‌या की, “हामु असो कदी नी देख्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ईसु नीकळीन अळी गलील दरीयान धड़के गुयु, ने चां मट्‌ली गड़दी आय ने ईसु तीनु काजे सीकाड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","जसु ईसु जातलु तत्‌यार हलफाईन पुर्‌यु फाळु मांगण्‌या काजे जागा पर बठ रवलु देख्‌यु; ईसु तीनाक कह्‌यु, “मारे पछळ चाल।” ने चु उठीन हेर पछळ चाली पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","जत्‌यार ईसु तेरे घर रुटा खाणे बठ्‌यु, तत्‌यार बेसका फाळु लेणे वाळा ने पापी माणसे, ईसु ने आपसान चेला पुठ्‌ये रुटा खाणे बठ्‌या; ने चे ईसु पछळ आवला हतला। ");
INSERT INTO bhi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","फरीसी माणसे ने थुड़ाक नीयमेन मास्‌तर्‌या, तींद्‌रे भेळु खात्‌लु देखीन, चे चेला काजे असा पुछ्‌या, की हयु पापी माणसे ने फाळु लेणे वाळा भेळु खाणो काहा खाय रयु? ");
INSERT INTO bhi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ईसु जी वात सामळीन तीनुक कह्‌यु “डाक्‌टर वारलु काजे नी, बाकुन मांदला काजे चाहजे। तसु मे धरमी काजे नी बाकुन पापी माणसे काजे बुलावणे आवलु छे।” ");
INSERT INTO bhi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","युहन्‌नान चेला ने फरीसी माणसेन चेला उपास करे; तेरेमां चे आवीन ईसु काजे पुछ्‌या, “युहन्‌नान चेला ने फरीसी माणसेन चेला उपास करे, बाकुन तारा चेला उपास काहा नी करे?” ");
INSERT INTO bhi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ईसु तीनुक कह्‌यु, जत्‌यार लग दुल्‌लु अरात्‌या पुठ्‌ये रवे, ती अरात्‌या उपास पाळे काय कदी नी करे। जत्‌यार लग मे तींद्‌रे पुठ्‌ये छे, चां लग चे उपास नी पाळे। ");
INSERT INTO bhi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","बाकुन चु दाहड़ु आवसे, तत्‌यार दुल्‌लु तींद्‌रे सी अलग हय जासे, ती तीना टेमे उपास पाळसे। ");
INSERT INTO bhi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“कुय बी जुन्‌ला पुथल्‌या मां नवला पुथल्‌या सी थीग्‌ळो नी लागाड़े; नीते च थीग्‌ळो हेरेम सी खेची लावसे, नीते नवलो, जुन्‌ला सी बी जादा फाट जासे। ");
INSERT INTO bhi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","नवलु अंगुरेन रस काजे जुन्‌ली चामड़ान बन्‌‌‌ली थयलि मां कुय नी भरे, नेते अंगुरेन रस तीनी थयलि काजे फाड़ देसे, ने अंगुरेन रस ने चामड़ान थयलि दुयु नास हय जासे; बाकुन नवला अंगुरेन रस नवली चामड़ान बन्‌ली थयलि मां भरे।” ");
INSERT INTO bhi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","असो हयो की चु यहुदी आरामेन दाहड़े ईसु ने तेरा चेला खेते मायन जाणे बाजी रवला। तत्‌यार गहुंन उम्‌बी तुड़ीन ने चुळी-चुळीन खाता-खाता जातला। ");
INSERT INTO bhi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","तत्‌यार फरीसी माणसे ईसुक कह्‌या, “देखु; जे आरामेन दाहड़े काहा असो काम करे, ज काम हामरे नीयमेन अनसारे वारु नी हय!” ");
INSERT INTO bhi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ईसु तीनुक कह्‌यु, “काय तुहुं ज कदी नी भण्‌या की जत्‌यार दावुद काजे जरुड़ी हतली, ने जत्‌यार चु ने तेरा साती भुकला हतला, तत्‌यार चु काय करलु? ");
INSERT INTO bhi_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","हयु कसु अबीयातार मटला पुजारान दाहड़ान टेमे, भगवानेन मंदीर मां जाय्‌न चड़ावला रुटा काजे खादु, बाकुन तीना खाणा काजे नीयमेन अनसारे पुजाराक छुड़ीन अळी कुय बी तीनाक खाणेन हक नी हतलो, बाकुन दावुद खादु बी ने हेरा साती काजे बी देदु।” ");
INSERT INTO bhi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","तत्‌यार ईसु तीनुक कह्‌यु, “आरामेन दाहड़ु माणसे वाटे बणावलु छे, बाकुन असो नी हय, की माणसे आरामेन दाहड़े वाटे बणावला छे। ");
INSERT INTO bhi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","तेरेमां माणसेन पुर्‌यु आरामेन दाहड़ान बी मालीक छे।” ");
INSERT INTO bhi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ईसु पछु तींद्‌रा यहुदीन भक्‌तीन घर मां गुयु; चां एक माणुस हतलु, तेरु हात सुकी गुयलु, ");
INSERT INTO bhi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","थुड़ाक फरीसी माणसे ईसु पर झुटु ईल्‌जाम लागाड़नेन तकाय रवला, ने चु आरामेन दाहड़ान नीयम तुड़ीन, जु मांदला काजे वारु करे, की नी करे असा करीन चे भाळी रवला। ");
INSERT INTO bhi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ईसु सुकला हात वाळा माणुस सी कह्‌यु, “माणसेन ईचमां उबु हय जां।” ");
INSERT INTO bhi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ने ईसु माणसे काजे पुछ्‌यु, “काय आरामेन दाहड़े नीयमेन अनसारे वारु करनु की बुरो करनु वारु छे, जीवेक बचाड़नु की मारनु वारु छे?” बाकुन चे माणसे हुगात हय रवला। ");
INSERT INTO bhi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","चे मन मां बेसका उदास हतला, करीन ईसु बेसकु दुखी हय गुयु, ने चे रीसवायन चारेमेर तीनु काजे देख्‌यु। ने ईसु तीना काजे कह्‌यु “तारु हात लांबु कर।” ने चु हात लांबु कर्‌यु, ने तेरु हात वारु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","तत्‌यार फरीसी माणसे बाहार जाय्‌न तत्‌यारुत हेरोदेस राजान माणसे बेसका असा वीच्‌यार करने बाजी गुया, की हामु ईसुक कसा करीन मारजे। ");
INSERT INTO bhi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ईसु तेरा चेला पुठ्‌ये गलील दरीया भीणी गुयु, ने तत्‌यार गलील ईलाका वाळा मट्‌लु टुळु ईसु पछळ-पछळ आवतेला। ");
INSERT INTO bhi_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ने ईसुन मटला काम सामळीन यहुदीया, ने यरुसलेम, ने इदुमीया, यरदन नदीन पली धड़ वाळा ने सुर ने सेदा ईलाका वाळा माणसे वारु काम करे करीन माणसेन मटु टुळु तेरे धड़े आयु। ");
INSERT INTO bhi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ईसु तेरा चेला काजे कह्‌यु “माणसेन टुळु बेसकु छे करीन मारे वाटे एक ढंड्‌यो तीयार करु काहाकी मे दड़पाय नी सको।” ");
INSERT INTO bhi_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","काहाकी ईसु बेसका माणसेक वारु करलु, तेरेमां दीसरा बी मांदला माणसे वारु हवणे करीन ईसु काजे छीमणे धकलाय्‌तात जातला। ");
INSERT INTO bhi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","भुतड़ा लागला माणसे ईसु काजे देखता वार मां तेरे अगळ पड़ जातला, ने आयड़ीन कवतेला की, “तु भगवानेन पुर्‌यु छे।” ");
INSERT INTO bhi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ने ईसु तीनुक चेतायु की, मेसेक उजन्‌तु घुण करु करीन कह्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","पछेन ईसु एक बयड़ा पर जाती रयु, ने गमे तीनाक तेरे धड़े बुलायु; ने चे तेरे धड़े आया। ");
INSERT INTO bhi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","तत्‌यार ईसु बारे जणा मारे पुठ्‌ये रहु, करीन नेवाड़ लेदु ने तीनुक नेवताळा छे करीन नाव देदु, ने चे परचार करने गुया, ");
INSERT INTO bhi_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ने माणसे मां सी भुतड़ा नीकाळनेन हक आपीन मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","चे जे छे: सीमोन तेरो नाव चु पतरस राख्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ने जब्‌दीन पुर्‌या याकुप ने याकुपेन भाय युहन्‌‌‌नु, तींद्‌रा नाव हयु, बुअनरगीस मतलब गाजणे वाळान पुर्‌यु राख्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ने अन्‌दीरीयास ने फीलीप्‌पुस, ने बरतुल्‌मे, ने मत्‌‌ती ने थोमा, ने हलफाईन पुर्‌यु याकुप, ने तद्‌दे ने अळी सीमोन कनानी चु देसेन सेवा करने वाळु हतलु, ");
INSERT INTO bhi_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ने यहुदा ईस्‌करीयोती चु ईसु काजे धुकु दीन धराड़ देदलु। ");
INSERT INTO bhi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","तत्‌यार बयड़ा मां सी ईसु घर आयु। ने चां बी माणसे बेसका भेळा हय गुया; ईसु ने तेरा चेला काजे रुटा खाणेन बी टेम नी जड़ी। ");
INSERT INTO bhi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","जत्‌यार हेरा कुटुम वाळा ईसुन बारामां माणसे असा कवतेला की “ईसु संक्‌यु हय गुयु।” असा करीन ईसुन घरना ईसु काजे घर बुलावणे करीन चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","यरुसलेम सी आवला थुड़ाक नीयमेन मास्‌तर्‌या बी कह्‌तेला की, “हेरे मां ते भुतड़ा छे,” ने “जु ईसु भुतड़ा काजे ढासाड़ने करीन डाहला भुतड़ान साहरु लीन भुतड़ा काजे माणसेम सी नीकाळे।” ");
INSERT INTO bhi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","तेरेमां ईसु तीनु काजे धड़े बुलायन दाखलु दीन तीनुक कह्‌यु, “भुतड़ु कसु भुतड़ा काजे नीकाळी सके? ");
INSERT INTO bhi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","कदी काहनाक देस टुट जाय ने लड़ाय हवे, ती च राज कसों संय रय सके? ");
INSERT INTO bhi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ने कदी काहनाक घरेन माणसे मां लड़ाय हवे, ती चो घर कसों संय रय सके? ");
INSERT INTO bhi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","तेरेमां कदी भुतड़ान राज टुट जाय, ती तेरो राज्‌य कसों बणीन रवसे? तीनाक ते मरनु पड़से। ");
INSERT INTO bhi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“बाकुन काहनु बी माणुस काहनाक ताकतवाळान घर मां भरायन तेरो समान कसु लुटसे, तत्‌यार लग की चु पेहेल तीना ताकतवाळा काजे बांदी नी लेय; तीत तेरा घर काजे लुट सके। ");
INSERT INTO bhi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“मे तुंद्‌रे सी छाचलीन कहं, की माणसेन आखा पाप ने नाव-बद्‌दी करे, तेरी माफी जड़ जासे, ");
INSERT INTO bhi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","बाकुन जु काहनुक चुखली-आत्‌मान नाव-बद्‌दी करसे, तीनुक कदी पापेन माफी नी जड़े, बाकुन चु जलम पापेन गुनेगार रवसे।” ");
INSERT INTO bhi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“काहाकी चे असा कह्‌तेला की ईसु मां भुतड़ान आत्‌मा भराय रय।” ");
INSERT INTO bhi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","तत्‌यार ईसुन माय ने भायस आया, ने बाहरुत उबा रय्‌न ईसु काजे बुलावणे करीन घर मां दीसरा काजे मकल्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","माणसे तेरे आड़े-धड़े बसी रवला, चे कह्‌या “देख तारी माय ने तारा भायस ने बहणस्‌या तुसेक बाहार हेरी रया।” ");
INSERT INTO bhi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ईसु जपाप आप्‌यु, “मारी माय ने मारु भायस कुण छे?” ");
INSERT INTO bhi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ने ईसु चां आड़े-धड़े बसी रवला, तींद्‌रे चारे मेर भाळीन कह्‌यु “सामळु, जे अतरात मारी माय ने मारु भायस छे। ");
INSERT INTO bhi_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","जे कुय भगवानेन मरजी पर चाले, चु मारु भायस ने मारी बहणीस ने माय छे।” ");
INSERT INTO bhi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ईसु पछु दरीया धड़े माणसेक सीकाड़ने बाजी गुयु। अळी बेसका माणसे ईसु धड़े भेळा हया, की ईसु दरीया मां एक ढंड्‌याम जाय्‌न बठी गुयु ने आखा माणसे एक धड़े जागा पर दर्‌यान धड़के उबा रय गुया। ");
INSERT INTO bhi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ने ईसु दाखलु दीन तीनु काजे बेसकी वात सीकाड़्‌यु ने सीकाड़तु जाय्‌न कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“सामळु! एक जणु बीज एरने गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","एरनेन टेम मां थुड़ाक बीज वाटे धड़े पड़्‌या ने चिरला आवीन ईछीन खाय गुया। ");
INSERT INTO bhi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","थुड़ाक बीज चापर्‌या मां पड़्‌या चां अदु धुळु नी जड़्‌यु, ने जादा धुळु नी जड़नेन वजे सी छाटा उन्‌‌‌गी गुया, ");
INSERT INTO bhi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ने जत्‌यार दाहड़ु उन्‌‌‌गीन तप लाग्‌यु तत्‌यार च धान उन्‌‌‌गीन चीमाय गुयो ने जड़ नी धरनेन वजे सी सुक गुयो। ");
INSERT INTO bhi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","थुड़ाक बीज काटाळस्‌या झाड़का मां पड़्‌या ने चां मटा हय्‌न दड़पाय गुया ने चे फळ नी लाया। ");
INSERT INTO bhi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","बाकुन थुड़ाक बीज वारलु जागा मां पड़्‌या ने चे उंग्‌या ने काहनाक मटा हय्‌न तीस गुणा ने काहनाक सांठ गुणा ने काहनाक सोव गुणा दाणा पाक्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","तत्‌यार ईसु कह्‌यु, “कुणी धड़े कान्‌टा छे, चे सामळी लेय!” ");
INSERT INTO bhi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","जत्‌यार माणसे जाती रया ने ईसु एखलुत रय गुयु, ती तेरा बारे ईसुन चेला ने थुड़ाक दीसरा बी ईसु धड़े आवीन चे दाखलान मतलब पुछ्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ईसु तीनुक कह्‌यु, तुहुं काजे भगवानेन राजेन वात समजणेन अक्‌कल छे, बाकुन बाहार वाळा वाटे, आखी वात दाखला मां सामळावसे, ");
INSERT INTO bhi_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","तेरेमां की, चे देखे बाकुन देखता जाय्‌न, बी नी उळख्‌या; ने चे सामळे ने, सामळता जाय्‌न बी नी समजी गुया। कदी चे सामळता ती समजीन भगवान भीणी अळ जाता, ती तींद्‌रा पाप माफ कर देतु। ");
INSERT INTO bhi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ईसु तीनुक कह्‌यु, “काय तुहुं काजे जु दाखलु नी समज मां नी पड़तु, ती रवला दाखला काजे कसा समज्‌सु? ");
INSERT INTO bhi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","एरने वाळु बुले एरे। ");
INSERT INTO bhi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","जे वाटे धड़े छे बुले एराये, चे जे छे की जत्‌यार चे सामळ्‌या, ती भुतड़ु तत्‌यारुत आय्‌न बुले काजे ज तेरेमां एराय्‌लो छे, चु तीनाक ईछी ली जाय। ");
INSERT INTO bhi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","काहनाक माणसे ते चापर्‌या वाळा जागान तसा छे; चे भगवानेन बुल सामळीन खुसी-खुसी सी आवरी देय। ");
INSERT INTO bhi_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","बाकुन आपसान माहीं बुलेन वारु जड़ नी धरनेन वजे सी थुड़ाक दाहड़ा वाटे लग रवे; ने पछेन बुले माने ती तींद्‌रे पर मुसकील ने नाव-बद्‌दी आवे ती चे तत्‌यारुत भुरसु खुय देय। ");
INSERT INTO bhi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ने काहनाक माणसे असा छे की काटाळस्‌या झाड़ी मां एरला बीज छे, चे माणसे बुले काजे सामळ्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ने चे जीवेन फीकुर करीन ने मात-भर बणनेन लालुच ने आखी भातीन चीजेन फीकुर मां भगवानेन बुले काजे दड़पी देय, ने चे दाणा नी पाके। ");
INSERT INTO bhi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ने काहनाक माणसे चे वारलु जागान तसा छे चां दाणान तसों भगवानेन बुल समाय जाय; जे भगवानेन बुल सामळे ने मानीन पाळे। ने चे दाणा पाके काहनाक तीस गुणा ने काहनाक सांठ गुणा, ने काहनाक सोव गुणा।” ");
INSERT INTO bhi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ईसु तीनु काजे कह्‌यु, “काय हामु दिवा काजे असा करीन लावजे की ठाहरा तळे नीते खाट्‌ली तळे मेक्‌जे? काय असा करीन नी लावे की, दीवाळ्‌या पर मेके।” ");
INSERT INTO bhi_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ने काय बी चीज सातायलो नी हय, ची देखाय जासे। ने जी चीज ढाकायली छे, जी उघड़ी जासे। ");
INSERT INTO bhi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","कदी काहनाक ने सामळनेन कान्‌टा हय, चे वारु सामळी लेय। ");
INSERT INTO bhi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","पछेन अळी ईसु तीनुक कह्‌यु, “ज काय तुहुं सामळु तीनी वात पर मन लागाड़ीन वीच्‌यार करु। तीना नाप सी तुहुं नापसु तीनी नाप सी तुंद्‌रे वाटे बी नापायसे, तेरसी बी जादा तुंद्‌रे साते हवसे। ");
INSERT INTO bhi_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","काहाकी तेर धड़े ज काय छे, तीनाक अदुस आपसे; ने तींद्‌रे धड़े काय नी हय, तेरे धड़े सी ज काय ईतरोक रय र्‌यो, च बी मांग लेसे।” ");
INSERT INTO bhi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ईसु अळी एक दाखलु कह्‌यु, “भगवानेन राज असो छे, जसों की एक माणुस खेत मां बीज एरे। ");
INSERT INTO bhi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ने राते सुय गुयु, ने एगुत जागे, ने चे बीज कसा उंगीन मटा हया करीन पतु नी चाल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","धरती मां मेर आपसीत मटी हय्‌न पाकी जाय। पेहेल डीरी फुटे अळतेन उम्‌बी नीकळे ने उम्‌बी मां दाणा भराये। ");
INSERT INTO bhi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","बाकुन जत्‌यार दाणा पाकी जाय तत्‌यार चु तत्‌यारुत दातळा सी काटणेन तीयारी कर लेय, काहाकी काटणेन टेम आय गुय।” ");
INSERT INTO bhi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ईसु तीनुक कह्‌यु, “आपणु काहना हीसाब सी उळख्‌सुन की, भगवानेन राज कसों छे? ने काहना दाखला सी समज्‌सु? ");
INSERT INTO bhi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","भगवानेन राज रायन दाणान तसों छे; जत्‌यार खेत मां एरे ती; चां दीसरा आखा बीजे सी नानला देखाये। ");
INSERT INTO bhi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","बाकुन जत्‌यार चुपी देय, ती अदी जाय ने आखी मेर सी मटो हय जाय, ने तेरा डाळखा बेसका मटा हय जाय ने चां सरगेन चिरला बी पुत्‌रु बणायन आराम करे।” ");
INSERT INTO bhi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ईसु अळी बेसका दाखला दीन माणसेक बुले सामळाया करतेलु, जतरा सामळनेन मन हय, तत्‌रोत सामळावतेलु, ");
INSERT INTO bhi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ने दाखला पाखुर ईसु तीनु काजे काय बी नी सीकाड़तेलु बाकुन एखला मां तेरा चेला काजे दाखलान मतलब सीकाड़तेलु। ");
INSERT INTO bhi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","तीनेत दाहड़े सांती वेळाय, ईसु चेला काजे कह्‌यु, “आवु, आपणु दरीयान पली धड़ जाता।” ");
INSERT INTO bhi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ने ईसुन चेला तीनी गड़दी सी अलग हय्‌न, चेला तीना ढंड्‌या मां चहड़ी गुया, जां ईसु ढंड्‌या मां पेहलुत सी बसी रवलु, ने चां तींद्‌रे पुठ्‌ये दीसरा ढंड्‌या बी हतला चे बी जाणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","तत्‌यारुत दरीया मां मट्‌ली आंधी-हवा आवी ने झलक ढंड्‌ये बेसकी ठुकाय ने ढंड्‌या मां पाणी भरायतेलो। ");
INSERT INTO bhi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","बाकुन ईसु ढंड्‌यान पछला खुणा मां ईसु ईसों मेलीन सुय रवलु। तत्‌यार चेला ईसु काजे उठाड़्‌या ने तीनाक कह्‌या “ए मास्‌तर, हामु ते मरने बाजी रया, तुसेक फीकुर नी हय काय?” ");
INSERT INTO bhi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","तत्‌यार ईसु उठ्‌यु ने आंधी-हवा ने झलक काजे लड़ीन कह्‌यु, “हुगी रय जां।” ने आंधी-हवा ने झलक धीरी पड़ीन आखी हुगी रय गुय; ");
INSERT INTO bhi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ने ईसु चेलाक कह्‌यु, “तुहुं काहा बीही रया? तुहुं काजे हाल बी भुरसु नी हय काय?” ");
INSERT INTO bhi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","चेला बेसका बीही गुया ने आंबा-सांबा कह्‌णे बाजी गुया, “जु कुण छे? की आंधी-हवा ने पाणीन झलक लग हेरी वात!” ");
INSERT INTO bhi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ईसु ने तेरा चेला दरीयान पली धड़ गीरासेन्‌यान ईलाका मां गुया, ");
INSERT INTO bhi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","जत्‌यार ईसु ढंड्‌या मां सी उतर्‌यु; तत्‌यारुत भुतड़ा लागलो एक माणुस मसाण मां सी नीकळीन आयु। ");
INSERT INTO bhi_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","चु माणुस मसाण मां रवतेलु। ने माणसे तीनाक साकळ सी बांदणेन कुसीस कर्‌या बाकुन, चु कुय सी नी बांदाय तेलु, ");
INSERT INTO bhi_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","काहनाक तीनाक काय कतराक कावा हात मां साकळ ने पाय मां बी साकळ बांदी देदला, तेबी चु तुड़ी देदलु, ने चु साकळ काजे बटका-बटका कर देदलु, ने तीनाक कुय बी बदाड़ी नी सकतेला, काहाकी चु ताकत वाळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","चु रात-दाहड़ु मसाण ने बयड़ा मां आयड़तु फीरतेलु ने तेरेत दगड़ा दी दीन बेहुस हय जातलु। ");
INSERT INTO bhi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","चु माणुस ईसु काजे छेटे सी आवतेलु देखीन दवड़ीन ईसु अगळ ढंगु अळीन मांडान भुरसे आंध्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ने जुर सी आयड़ीन कह्‌यु “ए ईसु, आखा मां सी मुख्‌या भगवानेन पुर्‌या, मारे साते तारो काय काम छे? मेसे भगवानेन सगुन छे, की मेसेक डंड मां आपे।” ");
INSERT INTO bhi_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","काहाकी ईसु तीनाक कह्‌तेलु की, “ए भुतड़ा ईना माणुस मां सी नीकळी जां।” ");
INSERT INTO bhi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ईसु तीना माणुस काजे पुछ्‌यु “तारो नाव काय छे?” ने चु कह्‌यु, “मारो नाव ‘सेना’ छे; काहाकी हामु बेसका छे।” ");
INSERT INTO bhi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ने भुतड़ा ईसु सी वीन्‌ती कर्‌या, “हामु काजे ईना ईलाका मां सी बाहार मां मकले।” ");
INSERT INTO bhi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","चां एक बयड़ान कड़खे सुहर्‌यान एक मटु टुळु चरने बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","भुतड़ा अळी लीलघाय्‌न कह्‌यु, “हामु काजे पला सुहर्‌या मां मकली दे, तींद्‌रेम हामु रवसुन।” ");
INSERT INTO bhi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ईसु भुतड़ा काजे हुकुम आप्‌यु; ने चे भुतड़ा तेरे मां सी नीकळीन सुहर्‌या मां जाय्‌न भराय गुया ने चे सुहर्‌या दुयेक हजार हतला, चे आखा सुहर्‌या दवड़ीन दरीया मां कुद पड़्‌या ने पाणी मां डुबीन मर गुया। ");
INSERT INTO bhi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ज देखीन गुवाळ्‌या दवड़ीन फळ्‌या ने गांव मां जाय्‌न ज काय हयो, तेरी खबर कर देदा, ने आखा माणसे ज काय हयो च देखणे आया। ");
INSERT INTO bhi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ने जत्‌यार दीसरा माणसे ईसु धड़े आया चां तीना माणुस काजे देख्‌या, तेरे पेहेल भुतड़ा लागी रवला। बाकुन चु वारु हय्‌न पुथल्‌या पेरीन बठी रवलु, तत्‌यार चे माणसे बीही गुया। ");
INSERT INTO bhi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","भुतड़ा लागला माणसेन ने अळी सुहर्‌यान काय हयो करीन, चे देख्‌णे वाळा पुछ्‌या, ने सुहर्‌यान बारामां जाय्‌न दीसराक कय देदा। ");
INSERT INTO bhi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","तत्‌यार माणसे आवीन ईसु काजे लीलघाय्‌न कह्‌या की, हामरा ईलाकाम सी जाती रव। ");
INSERT INTO bhi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","तत्‌यार ईसु पछु जाणे करीन ढंड्‌या मां बसणे बाजी गुयु; तीनाक पेहेल भुतड़ा लागी रवला, चु माणुस ईसु काजे लीलघाय्‌न कह्‌यु, “मेसेक तारे पुठ्‌ये आवणी दे।” ");
INSERT INTO bhi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","बाकुन ईसु तीनाक कह्‌यु, “नी मारे पुठ्‌ये मां आवे, घर पछु जां ने मालीक तारे पर दया करीन तारे वाटे कतरु वारु काम कर्‌यु, च तारा घर वाळाक बताड़।” ");
INSERT INTO bhi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","चु चां सी तेरा दीकापुलीस जीलाम आखे जागे जाय्‌न परचार करने बाजी गुयु की ईसु मारे वाटे बेसको वारु काम कर्‌यु, ने माणसे तेरी वात काजे सामळीन देखतात रय गुया। ");
INSERT INTO bhi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","गीरासेनीया ईलाका मां सी ईसु पछु ढंड्‌या मां बठीन दरीयान पली धड़ गुयु। ती चां धड़के माणसेन गड़दी चारे मेर लाग गुय। ");
INSERT INTO bhi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","याईर नावेन एक माणुस हतलु, चु तींद्‌रा भक्‌तीन घरेन मुख्‌या मायन एक हतलु, चु ईसुक देखीन पाये पड़्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ने चु ईसु सी लीलघाय्‌न कह्‌यु, “मारी नानली पुरे मरनेत पर छे। तु दया करीन मारे पुठ्‌ये चाल, ने तेरे पर हात मेल, ने ची वारु हय्‌न जीवतेली रवे!” ");
INSERT INTO bhi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","तत्‌यार ईसु तेरे पुठ्‌ये चाली पड़्‌यु। ने मट्‌ली गड़दी बी पुठ्‌येत गुय। ने तेरे पुठ्‌ये चालन्‌या माणसे चीपदाय्‌न ने धकलाय्‌न ईसु पर पड़तेला। ");
INSERT INTO bhi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","एक बायर हतली, तेरे बारे साल सी पोगराळान दुख लागलो हतलो। ");
INSERT INTO bhi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ची बेसकी परेसान हतली ने डाक्‌टर्‌या मां ईलाज कराड़ी-कराड़ीन आखा पयस्‌या सर गुयला, तेबी वारु नी हय। बाकुन जादास मांदी हय गुय। ");
INSERT INTO bhi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ची ईसुन बारामां ज सामळीन गड़दी मां तेरे पछळ सी आय, ने ईसुन पुथल्‌या काजे छीमी लेदी। ");
INSERT INTO bhi_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","काहाकी ची सुचतेली की, “कदी मे ईसुन पुथल्‌याक छीमी लीस, ती मे वारु हय जायस।” ");
INSERT INTO bhi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","असी करीन ची माणसेन टुळा मां धकलाय्‌न ईसुन पुथल्‌या काजे छीमी लेदी ने तत्‌यारुत तेरे लुही नीकळनु बंद हय गुयो, ने तेरा डील मां मालुम पड़ गुयो, की मे हीड़ा-पीड़ा मां सी छुटीन वारु हय गुय। ");
INSERT INTO bhi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ने तत्‌यारुत ईसुन डील मां मालुम पड़ गुयो, की मारे मां सी छुटकारु आपणेन ताकत नीकळी छे, ने ईसु पछु फीरीन गड़दी मायन माणसेक पुछ्‌यु, “मारो झगल्‌यो कुण छीम्‌यो?” ");
INSERT INTO bhi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","तेरा चेला तीनाक कह्‌या, “जे माणसे ते चीपदाय्‌न ने धकलाय्‌न तारे पर पड़ रया ने तु काहा पुछी र्‌यु की; मेसेक कुण छीम्‌यो?” ");
INSERT INTO bhi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","तत्‌यार बी ईसु मेसेक कुण छीम्‌यो करीन देखणे चारे मेर भाळने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","तत्‌यार ची बायर मारो बेसको भलो हवलो छे असी जाणीन ची बीहती ने कापती जाय्‌न ईसु धड़े आवी, ने ईसुन पाये पड़ी ने ज काय हयो च छाचलीन बताड़ देदी। ");
INSERT INTO bhi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ईसु तीनीक कह्‌यु, “मारी बेटी तु ते मारे पर भुरसु करी, तेरेमां तु हीड़ा-पीड़ा मां सी छुटीन वारु हय गुय। तु सुकेन जीवे जीवती रव।” ");
INSERT INTO bhi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ईसु तीनीक कवणे बाजी रवलु, ती चां तीना याईरेनेन घर मां सी काहनाक आवीन मुख्‌या काजे कह्‌या, “तारी पुरे नी बची, ने मास्‌तर काजे काहा दमे।” ");
INSERT INTO bhi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ईसु तींद्‌री वात काजे सामळ्‌यु बाकुन धीयान नी देदु ने मुख्‌या काजे कह्‌यु, “मां बीहे, बाकुन मारे पर भुरसु अतरुत राख।” ");
INSERT INTO bhi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ने ईसु दीसरा काजे चाहात रहणीदीन पतरस ने याकुप ने अळी याकुपेन भायस युहन्‌ना काजे अतरुत तेरे पुठ्‌ये आवणे देदु। ");
INSERT INTO bhi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ने ईसु तींद्‌रे पुठ्‌ये मुख्‌यान घर पुग्‌या; तत्‌यार घर मां बेसका माणसेक देख्‌यु ने रड़तेला ने आयड़ता सामळ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","तत्‌यार ईसु घर मां जाय्‌न तीनुक कह्‌यु, “तुहुं काहा रड़ीन ने कलपी र्‌या? पुरे मरी नी बाकुन, सुवणे बाजी रय।” ");
INSERT INTO bhi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","चे माणसे ईसुन वात सामळीन हीनाक हासणे बाजी गुया, बाकुन ईसु तीनु आखा काजे घर मां सी बाहर नीकाळ देदु ने पुरेन आयस-बास ने अळी तेरा तीन चेला काजे लीन पुरे हतली, चां गुया ने पुरे मरीन पड़ी रवली। ");
INSERT INTO bhi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ने ईसु पुरेन हात धरीन तीनीक कह्‌यु, “तलीता, कुमी!” तेरो मतलब छे, “पुरे मे तुसेक कहं की उठ!” ");
INSERT INTO bhi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ने ची नानली पुरे तत्‌यारुत जीवती हय्‌न उठ गुय ने चालने फीरने लागी; ची पुरे बारे सालेन हतली। ने चे ज देखीन देखतात रय गुया। ");
INSERT INTO bhi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","पछेन ईसु तीनुक हुकुम आपीन कह्‌यु, जी वात कुय काजे घुण कहें, “ने अळी असु बी कह्‌यु, की पुरे काजे काहींग खाणे आपु।” ");
INSERT INTO bhi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","चां सी ईसु तेरा गांव नासरत भीणी चाली पड़्‌यु, ने तेरे पुठ्‌ये तेरा चेला बी आया। ");
INSERT INTO bhi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ने चु यहुदीन आरामेन दाहड़े, भक्‌तीन घर मां जाय्‌न सीकाड़ने बाजी गुयु ने आखा तेरी वात सामळीन देखतात रय गुया। ने आंबा-सांबा पुछणे बाजी गुया “की असी अक्‌कल हीनाक कां सी जड़ी ने बेसको मटो काम करनेन ताकत कुण देदो?” ");
INSERT INTO bhi_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","काय जु सुतारेन पुर्‌यु नी हय? चु मरीयमेन पुर्‌यु ने याकुप ने योसेस ने यहुदा ने सीमोनेन भाय छे? ने काय हेरा बहणस्‌या हामरा ईचमां नी रवे? तेरेमां चे हीनाक मान्‌या नी। ");
INSERT INTO bhi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ईसु तीनुक कह्‌यु, “भगवानेन अघी सी वात बताड़ने वाळा ने आपसान गांव वाळा ने तेरा रीस्‌ता वाळा ने आपसान घरवाळाक छुड़ीन कुय बी ईज्‌जत नी करे।” ");
INSERT INTO bhi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","चां ईसु गांव मां बेसकु मटो काम नी कर्‌यु; बाकुन थुड़ाक मांदला माणसे पर हात मेलीन तीनुक वारु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ने ईसुक तींद्‌रु भुरसु नी करने सी मन मां असु कह्‌यु, की जे कसला माणसे छे, बाकुन चारे मेर गांव मां फीरतु रयु ने सीकाड़तु गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ईसु आपसान बारे चेला काजे बुलायु ने तीनुक भुतड़ा नीकाळनेन हक आप्‌यु; ने दुय-दुय जणा काजे मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","चु तीनुक असु कह्‌यु, “कदी बाहार कांखुर जावु ती लाकड़ीक छुड़ीन दीसरो काय बी साते घुण ली जावु, नी ते रुटा, नी ते झुळु, नी ते बटवा मां पयस्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","बाकुन तुहुं चाट्‌या पेहेरजु ने पेहेरलो झगल्‌योत पेहरीन जाजु, ने दीसरो काय घुण ली जावु।” ");
INSERT INTO bhi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ने ईसु तीनुक कह्‌यु, “काहनाक घरवाळा आव करीन नेवता आपे, ती चांहान रवजु जां लग चु जागु छुड़े नी। ");
INSERT INTO bhi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","काहना बी जागे माणसे तुंद्‌रो आव-भाव नी करे ने तुंद्‌री वात नी सामळे ती चां सी आवणेन पेहेल पायेन धुळु चांहान झाटकी देजु काहाकी चे आवणे वाळा डंडेन बारामां बीहीन रवसे।” ");
INSERT INTO bhi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","तत्‌यार चे चां सी जाती रया, ने जाय्‌न असा परचार कर्‌या, की पाप करनु छुड़ीन मन फीरावु। ");
INSERT INTO bhi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ने चे बेसका माणसे मां सी भुतड़ा नीकाळ्‌या ने मांदला काजे जेतुनेन तेल लागाड़ीन वारु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","असो करीन ईसुन नाव आखे दुर मालुम हय गुयो ने अतरो बी की हेरोदेस राजाक बी, ईसुन बारामां सामळ्‌यु ने कह्‌यु, “बपतीस्‌मा आपण्‌यु युहन्‌‌‌नु पछु जीव उठलु छे; तेरेमां हेरा बेसका मटा ताकुतेन काम हया।” ");
INSERT INTO bhi_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","दीसरा माणसे कह्‌या, “जु एलीयु छे।” ने दीसरा माणसे कह्‌या, “नी, हयु अघी सी आवणे वाळी वात बताड़ने वाळा मायन एक छे।” ");
INSERT INTO bhi_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","बाकुन जत्‌यार हेरोदेस जी वात सामळायु ती कह्‌यु, “तीना युहन्‌नान मुणको काटाड़ देदलु छे, ने जु पछु कसु जीव उठ्‌यु!” ");
INSERT INTO bhi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","हेरोदेस युहन्‌ना काजे धरीन ने हातकड़ी लागाड़ीन जेल मां बुजाड़ी देदलु। असो हयु हेरोदीयासेन वजे सी कर्‌यु, काहाकी हेरोदेस तेरा भायस फीलीप्‌पुसेन लाडी हेरोदीयास हतली, हयु हेरे साते ईयाव कर लेदलु, ");
INSERT INTO bhi_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","काहाकी युहन्‌‌‌नु हेरोदेस राजा सी कहतेलु, “आपसा भायस फीलीप्‌पुसेन लाडी साते ईयाव करनु, तारे वाटे वारु नी हय।” ");
INSERT INTO bhi_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","तेरेमां हेरोदीयास ईनी वात मां युहन्‌ना सी रीस करतेली, ने ची तीनाक माराड़ने हींडी रवली, बाकुन हयी हेरोदेसेन वजे असो नी हय सक्‌यो, ");
INSERT INTO bhi_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","काहाकी हेरोदेस राजु युहन्‌ना काजे धरमी ने चुखलु माणुस करीन बीहतेलु, ने तेरी राखवाळी कराड़तेलु। हेरोदेस तेरी वात सामळीन बेसकु घाबराय तेलु; बाकुन खुस हय्‌न तेरी वात सामळतेलु। ");
INSERT INTO bhi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","बाकुन एक दाहड़े वारु टेम आय, जत्‌यार राजु हेरोदेस आपसा पयदावारीन तीहवारेन दाहड़े तीनी हेरोदीयास काजे वारु मुखु जड़ी गुयु। तीने दाहड़े राजु हेरोदेस तेरा गलील सरकारेन डाहला ने अळी सीपायड़ान डाहला ने अळी गांवेन काम करने वाळा मायन डाहला काजे पंगत मां खाणे बुलायु। ");
INSERT INTO bhi_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ती चां हेरोदेसेन पुरे आय ने नाची ने हेरोदेस काजे खुस करी ने तेरा मेजवान्‌या काजे बी। तेरेमां राजु तीनी पुरेक कह्‌यु, “तुसे काय बी चाहजे च मांग, मे तुसे आपी दीस।” ");
INSERT INTO bhi_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ने चु सगुन खाय्‌न कह्‌यु, “ज काय तु मांगी च आप दीस, भले तु आधो राज मांगसी चो लग आपी दीस।” ");
INSERT INTO bhi_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","तत्‌यार ची पुरे बाहर जाय्‌न तेरी माय हेरोदीयास काजे पुछी, “मे काय मांग?” ची कय “बपतीस्‌मा आपणे वाळु युहन्‌नान मुणको मांग ले।” ");
INSERT INTO bhi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","पुरे तत्‌यारुत पछी राजा धड़े दवड़ीन गुय, ने तीनाक कही, “मे चाह की तु बपतीस्‌मा आपणे वाळा युहन्‌नान मुणको तळी मां मांगाड़ ले।” ");
INSERT INTO bhi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","पुरेन वात सामळीन राजु बेसकु दुखी हयु, बाकुन चु मान्‌तान वजे सी माणसे अगळ सगुन खाय्‌न कह्‌लु, तेरेमां तीनी पुरेन वात काजे नी टाळ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ने राजु तत्‌यारुत एक सीपायड़ा काजे कह्‌यु, की युहन्‌नान मुणको काटीन लाव ने चु जेल मां गुयु ने तेरो मुणको काट्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ने युहन्‌नान मुणको काटीन तळी मां भरीन लायु, ने तीनी पुरे काजे आपी देदु ने ची पुरे तेरी माय काजे आप देदी। ");
INSERT INTO bhi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","जत्‌यार युहन्‌नान चेला जी खबर सामळीन आया, ने तेरा धड़ काजे ली गुया ने मसाण मां वारु गाड़ देदा। ");
INSERT INTO bhi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ने ईसुन नेवताळा सेवा करने गुयला, चे ईसु धड़े पछा आवीन भेळा हय्‌न ज काय चे कर्‌या ने सीकाड़्‌या च आखो कय देदा। ");
INSERT INTO bhi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","पछेन ईसु तीनुक कह्‌यु, “जां ते बेसका माणसे आवता जाता रवे ने तुहुं काजे रुटा खाणेन लग टेम नी जड़े। अतरा मां ईसु तीनुक कह्‌यु चालु आपणु बयड़ा मां एक सुनसान जागा मां जाता चां जाय्‌न तुहुं थुड़ीक वार आराम कर सकु।” ");
INSERT INTO bhi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","तेरेमां चे ढंड्‌या मां बठीन एक सुनसान जागा मां जाती रया। ");
INSERT INTO bhi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","बेसका माणसे ईसुक जातला देखीन उळखी लेदा, ने आखा गांवे-गांवेन माणसे भेळा हय्‌न चां दवड़ी पड़्‌या ने ईसु ने तेरा चेला सी पेहेल पुगी गुया। ");
INSERT INTO bhi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ईसु ढंड्‌या मां सी उतर्‌यु, चां बेसकु मटु माणसेक टुळा काजे देख्‌यु, ने तींद्‌रे पर दया आय, काहाकी चे तींद्‌रा गुवाळ्‌या पाखुर खुवायला गाडरान तसा हतला। ने ईसु बेसकी वात तीनु काजे सीकाड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","जत्‌यार दाहड़ु ढळ गुयु, ने टेम हय गुय, ती ईसुन चेला धड़े आवीन कह्‌या, “जु सुनसान जागु छे, ने दाहड़ु बेसकु ढळ गुयलु छे। ");
INSERT INTO bhi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","माणसे काजे आड़े-धड़ेन खेत ने गांव मां जाणी देवु काहाकी चे आपसा वाटे खाणे करीन काहींग मुल ली लेसे।” ");
INSERT INTO bhi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ईसु तीनुक कह्‌यु, तुहुंत ईनु काजे खाणेन आपु। चे तीनाक कह्‌या, “हीनुक आखा काजे खावाड़ने करीन जाजे ने आंठ महनान दाहड़ान दाहड़कीन पयस्‌या खरचु करीन रुटा मुल लावाय्‌से काय? असु तु काय कय रयु?” ");
INSERT INTO bhi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","तत्‌यार ईसु तीनुक कह्‌यु, “जाय्‌न देखु तुंद्‌रे धड़े कतरा रुटा छे।” चे जाय्‌न देख्‌या ने कह्‌या, “हामरे धड़े पांच रुटा ने दुय माछी छे।” ");
INSERT INTO bhi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","तत्‌यार ईसु चेला काजे हुकुम आपीन कह्‌यु आखा काजे नीळ्‌ळा चारा मां पंगत बठाड़ देवु। ");
INSERT INTO bhi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","चे आखा माणसे सोव-सोव ने पचास-पचास माणसेन पंगत बठी गुया। ");
INSERT INTO bhi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ईसु चे पांच रुटा ने दुय माछी मांगीन हात मां लेदु, ने सरग भीणी उपर भाळीन भगवान काजे कह्‌यु तु बेसकु वारु छे। ने ईसु रुटा काजे भांजीन चेला काजे आप्‌यु ने चे चेला माणसे काजे वाटता गुया। ने माछी बी असुत करीन आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ने आखा जणा खायलीन आफरी गुया। ");
INSERT INTO bhi_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ने चेला बचला रुटान कट्‌का, ने माछान खणका ईछीन भेळा कर्‌या, ती चे बारे चार्‌या भर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","चे खाणे वाळा अदमीत पांच हजार हतला, ने बायरा ने पुर्‌या अलग। ");
INSERT INTO bhi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","तत्‌यार ईसु तत्‌यारुत हेरा चेला काजे ढंड्‌या मां बठु करीन कह्‌यु, चे आपसा सी पेहेल बेतसेदा ईलाका मां ने च दरीयान पली धड़ जाती रवे, जत्‌यार लग की मे माणसे काजे मकली नी दम। ");
INSERT INTO bhi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ने आखा माणसे काजे मकली दीन ईसु बयड़ा पर भगवान सी दुवा करने गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","जत्‌यार सांती वेळाय हय तत्‌यार ढंड्‌यो दरीयान ईचमां हतलो, ने ईसु खळदाण पर एखलुत हतलु। ");
INSERT INTO bhi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","तत्‌यार ईसु चां रय्‌न चेलाक देख्‌यु की चे ढंड्‌या काजे चालाड़न्‌या घाबराय गुया, काहाकी आहळो तींद्‌रे सांबो आवणे बाजी रवलो। तत्‌यार ईसु कुकड़ा वासणीक पाणी पर चालतु जाय्‌न तींद्‌रे भीणी आयु ने तींद्‌रे धड़े मायन अघु जाणे हींडी रवलु। ");
INSERT INTO bhi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","बाकुन चे ईसु काजे पाणी पर चालतेलु देखीन असा समज्‌या गुया की हामु काजे भुतड़ुत देखाये ने चे आयड़ु कुद्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","काहाकी चे आखा तीनाक देखीन घाबराय गुयला। बाकुन तत्‌यारुत ईसु तीनुक कह्‌यु “हिम्‌मत राखु, मेत छे, बीहु मां।” ");
INSERT INTO bhi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","तत्‌यार ईसु तींद्‌रे ढंड्‌या मां चहड़ी गुयु ने आहळी धीरी पड़ गुय ने चे बेसका देखतात रय गुया। ");
INSERT INTO bhi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","चे पांच हजार माणसे काजे खावाड़ने वाळान मटो काम समजी नी सक्‌या काहाकी तींद्‌रो मन काठो हय गुयलो। ");
INSERT INTO bhi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ईसु ने तेरा चेला उतरीन गन्‌नेसरत ईलाका मां आया, ने ढंड्‌या काजे घाट पर लागाड़ देदा। ");
INSERT INTO bhi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","जत्‌यार चे ढंड्‌या मां सी उतर्‌या, तत्‌यार माणसे ईसु काजे तत्‌यारुत उळखी लेदा। ");
INSERT INTO bhi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","आड़े-धड़े आखा ईलाका मां सी दवड़ी-दवड़ीन मांदला काजे खाट्‌ली मां हाकलीन लाया ने जांहनड्‌ला बी माणसे सामळ्‌या, चांहान बी मांदला काजे ईसु धड़े लाया। ");
INSERT INTO bhi_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ने काहना बी गांव, सहर, नीते फळ्‌या मां जातलु, चां माणसे मांदला काजे हाटेम मेलदीन लीलघाय्‌न कवतेला की तारा पुथल्‌यान छेवड़ु अतरुत छीमणी दे। ने जतरा बी तीनाक छीम्‌या, चे आखा वारु हय जातला। ");
INSERT INTO bhi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","तत्‌यार थुड़ाक फरीसी माणसे ने मुसान नीयमेन मास्‌तर्‌या यरुसलेम सी आवीन ईसु धड़े भेळा हया, ");
INSERT INTO bhi_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","चे ईसुन थुड़ाक चेला काजे हात धुया पाखुर रुटा खात्‌ला देख्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","काहाकी फरीसी माणसे ने आखा यहुदी डाहला डाहलान रीतीन अनसारे चे जां लग हात नी धुवे चां लग खाय बी नी; ");
INSERT INTO bhi_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ने हाटेम सी आवीन जां लग उंघळी नी लेय चां लग खाणो नी खाय ने अळी बी बेसकी असी वात छे ची वात मान्‌ने करीन आवली जसों की, कटवरु, कळस्‌यु ने तांबान ठाहरा काजे मांजणु ने धुवणु। ");
INSERT INTO bhi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","तेरेमां चे फरीसी माणसे ने नीयमेन मास्‌तर्‌या ईसु काजे पुछ्‌या, “तारा चेला डाहला-डाहलान रीत पर काहा नी वेहवार करे जसा की हात धुया पाखुर रुटा खाय?” ");
INSERT INTO bhi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ईसु तीनुक कह्‌यु, यसायु माणुस तुंद्‌रेन तसा ढंगड़ा करन्‌यान बारामां भगवान पेहलुत सी वात कह्‌लु हतलु, जसों लिखलो छे जे माणसे मुंहडा सी ते मारी ईज्‌जत करे बाकुन हींद्‌रो मन मारे सी बेसको छेटे रवे। ");
INSERT INTO bhi_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","जे ते फालतु मारी भक्‌ती करे काहाकी माणसेन वात काजे नीयम करीन सीकाड़े ने असा समजे की जु हामरु नीयम हतलु। ");
INSERT INTO bhi_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“काहाकी तुहुं ते भगवानेन हुकुम काजे टाळीन माणसेन कह्‌लो मानी र्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ने ईसु तीनुक कह्‌यु, “तुहुं आपसान रीत काजे मान्‌ने करीन चतुर बणीन भगवानेन हुकुम कसा तुहुं टाळ देवु। ");
INSERT INTO bhi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","काहाकी मुसु हुकुम देदलु की, ‘आपसान बास ने आपसान मायन ईज्‌जत कर’ ने ‘जु काहनुक बास ने माय काजे बुली दी देय, तीनाक मार देणु चाहे।’ ");
INSERT INTO bhi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","बाकुन तुहुं कहुं की कदी काहनुक माणुस आपसान बास ने माय सी कहें ‘की मारी जीनी चीज सी तुहुंक फायदु हवणु हतलो च मे भगवान काजे आप देदु, ने हय तुंद्‌री सेवा नी करो।’ ");
INSERT INTO bhi_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","तत्‌यार तुहुं तीनाक तेरा बास ने तेरी मायन काय बी चाकरी नी करने देवु। ");
INSERT INTO bhi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","असा करीन तुहुं तुंद्‌री नेम काजे पाळे ने भगवानेन बुले टाळ देवु ने अळी असात बेसका काम करने बाजी र्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","तत्‌यार ईसु अळी माणसे काजे धड़े बुलायन तीनुक कह्‌यु, “तुहुं आखा मारी वात सामळु ने समजु। ");
INSERT INTO bhi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","असो काय बी नी हय, ची माणसे मां भरायन तीनुक वीटाळ देतु हय; बाकुन जो माणसेम सी नीकळे चोन तीनुक वीटाळ देय। ");
INSERT INTO bhi_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","कदी तेरा सामळनेन कान्‌‌‌टा हय, चु सामळी लेय।” ");
INSERT INTO bhi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","जत्‌यार ईसु गड़दी मां सी नीकळीन घर आयु, ती चां तेरा चेला तीना दाखलान बारामां बताड़ करीन पुछ्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ईसु तीनुक कह्‌यु, काय तुहुं बी डेड़-अकल्‌या छे काय? काय तुहुं नी समजु, की जी चीज बाहर सी माणसेन माहें जाय ची तीनाक वीटाळ नी सके, ");
INSERT INTO bhi_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","काहाकी च तींद्‌रा मन मां नी बाकुन पेट मां जाय ने बाहरी बठणे जाय, ती नीकळी जाय। असु कहींन हयु आखा खाणेन चीज काजे चुखलो ठहरायु। ");
INSERT INTO bhi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","पछेन ईसु कह्‌यु, ज काय माणुस मां सी नीकळे चत, माणुस काजे वीटाळ देय। ");
INSERT INTO bhi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","काहाकी माणसेन माहीं सी गलत वीच्‌यार, छीनाळो, चुरी, हत्‌या, खुदेन बायर छुड़ीन दीसरी बायर भीणी जाणेन मन। ");
INSERT INTO bhi_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","भुंडोत काम, लालुच करन्‌यु, कुहराय करन्‌यु, दीसरा काजे ठगण्‌यु, दीसरान नाव-बद्‌दी करन्‌यु जी वात बाहर आवे। ");
INSERT INTO bhi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","जी आखी भुंडीत वात माणसेन माहीं सी नीकळे ने माणुस काजे वीटाळ देय। ");
INSERT INTO bhi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","पछेन ईसु चां सी उठीन सुर ने सेदा ईलाका मां आयु; ने चां एक घर मां गुयु ने चु चाहतेलु की मेसेक दीसरा कुय बी उळख्‌णु नी चाहजे। बाकुन चु उळखाय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ने तत्‌यारुत चां एक बायर ईसु आय रयु करीन सामळीन आय ने तेरी नानली पुरेन भुतड़ु लागी रवलु, ने ची ईसुन पाये पड़ी। ");
INSERT INTO bhi_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ची बायर सीरीया देसेन सुरुफोनेसीया मां रहतेली ने ची नी-यहुदी वाळी हतली। ने ची ईसु सी जी लीलघाय्‌न कही की, भुतड़ा काजे मारी पुरे मां सी नीकाळ दे। ");
INSERT INTO bhi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ईसु दाखलु दीन तीनीक कह्‌यु, “पेहेल पुर्‌या काजे खाय्‌न आफरनी दे काहाकी पुर्‌या भीणीन रुटा हापकीन कुतरा अगळ नाखणु वारु नी हय।” ");
INSERT INTO bhi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ची बायर दाखला मां सी एक कड़ी जुड़ीन जपाप आपी, खरली वात छे, मालीक बाकुन तेबी कुतरा पुर्‌यान ईस्‌टाळा रुटान भुकरा काजे खाय लेय। ");
INSERT INTO bhi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ईसु तीनीक कह्‌यु, “जी वात कही, तेरेमां तु आराम सी जाती रव, भुतड़ु तारी पुरे मां सी नीकळी गुयलु छे।” ");
INSERT INTO bhi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ची चां सी तेरे घर जाय्‌न देखी, तत्‌यार तीनीक मालुम पड़्‌यो की भुतड़ु पुरे मां सी नीकळी गुयु ने तेरी पुरे वारु हय्‌न खाट्‌ली पर सुय रवली। ");
INSERT INTO bhi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","पछेन ईसु चां सी उठीन सुर ईलाका मां सी नीकळीन सेदा ने दीकापुलीस ईलाका मायन जातात गलील दरीया धड़े पुग्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","चां एक माणुस बेहरु ने चु बुबड़ु बी हतलु, तत्‌यार माणसे ईसु धड़े आवीन ईसु सी लीलघाय्‌न कह्‌या, की तारु हात हीना पर मेक। ");
INSERT INTO bhi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","तत्‌यार ईसु तीना काजे गड़दी मां सी अलग ली गुयु, ने आपसान आंगळी बेहरान कान्‌‌‌टा मां भर्‌यु ने तीनीत आंगळी पर थुपीन तीनी आंगळी सी जीप छीम्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ने सरग भीणी भाळीन मटीस दम लीन कह्‌यु, “ईप्‌फत्‌तह!” मतलब “उघड़ी जां।” ");
INSERT INTO bhi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ने तत्‌यारुत तेरा कान्‌‌‌टा उघड़ी गुया ने तेरी जीपेन गाठ बी छुट गुय ने चु चुखु झण बुलने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","तत्‌यार ईसु माणसेक हुकुम आपीन कह्‌यु, जी वात कुय काजे घुण कहुं, बाकुन जतरु तीनुक जुर दीन हुकुम आपीन कह्‌यु ततरा अदुस चे वातेन परचार करने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","चे बेसका खुस हय गुया ने अळी-अळीन कह्‌णे बाजी गुया, “हयु ज बी कर्‌यु, आखो वारलु कर्‌यु; हयु बेहरा काजे सामळनेन, ने बुबड़ा काजे बुलनेन ताकत आपे।” ");
INSERT INTO bhi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","तीनु दाहड़ा मां अळी एक माणसेन मट्‌लु टुळु ईसु धड़े भेळु हयु। ने तीनु माणसे धड़े खाणेन काय नी हतलो। तत्‌यार ईसु तेरा चेला काजे धड़े बुलायन कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“मेसेक हीनु माणसेन टुळा पर तरस आवे, काहाकी जे तीन दाहड़ा सी मारे पुठ्‌ये छे ने हींद्‌रे धड़े खाणेन काय बी नी हय। ");
INSERT INTO bhi_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","हींद्‌रे मां सी काहनाक बेसके लांबे सी आवला छे। कदी हीनुक मे भुकलात घर मकलीस तत्‌यार वाटे झामा खाय्‌न पड़ जासे।” ");
INSERT INTO bhi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ईसुन चेला जपाप आप्‌या, “जां बयड़ा मां ईनु माणसेक आफरीन खावाड़ने करीन अतरा रुटा कां सी लावसुन?” ");
INSERT INTO bhi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ईसु चेला काजे पुछ्‌यु, तुंद्‌रे धड़े कतरा रुटा छे, “चे कह्‌या” सात रुटा। ");
INSERT INTO bhi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","तत्‌यार ईसु माणसे काजे भुयमां बसी जावु करीन हुकुम आप्‌यु, ने चु सात रुटा हात मां लीन रुटा वाटे भगवान काजे कह्‌यु, तु बेसकु वारु छे, ने चु माणसे काजे वाट देवु, करीन रुटा भांजीन तेरा चेला काजे आपतु गुयु ने चेला माणसेक वाटता गुया। ");
INSERT INTO bhi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","हींद्‌रे धड़े थुड़ाक नानला माछा बी हतला, माछा वाटे बी ईसु, भगवान तु बेसकु वारु छे करीन कह्‌यु। ने चे माछा बी माणसेक वाट देवु, करीन चु तेरा चेला काजे हुकुम आपी देदु। ");
INSERT INTO bhi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","चे आखा माणसे खायलीन आफरी गुया, ने चेला, बचला रुटान कट्‌का भेळा कर्‌या, तत्‌यार सात चार्‌या भराय गुया। ");
INSERT INTO bhi_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ने चां माणसे चार हजार हतला, ने तत्‌यार ईसु तीनु माणसे काजे अळाय देदु। ");
INSERT INTO bhi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ने चु मामार तेरा चेला पुठ्‌ये ढंड्‌या मां बठीन दलमनुता ईलाका मां जाती र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","पछेन थुड़ाक फरीसी माणसे ईसु साते लड़ाय झगड़ु करने बाजी गुया। ने तीनाक पारखणे करीन कह्‌या की “ईसु हामुक एक असी वारु कामेन सहलाणी देखाड़।” ");
INSERT INTO bhi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ईसु तींद्‌रा ढंगड़ा देखीन हेरा जीव-आत्‌मा मां मटीत दम लीन कह्‌यु, “तुहुं ईनी पीड़ीन माणसे हय बी वारु कामेन सहलाणी काहा हेर र्‌या? बाकुन मे तुहुंक छाचलीन कहं की, तुहुंक काय बी सहलाणी नी जड़े।” ");
INSERT INTO bhi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ने ईसु फरीसी माणसे काजे छुड़ीन अळी पछु ढंड्‌या मां बठी गुयु, ने दरीयान पली धड़ जाणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ईसु ने तेरा चेला ढंड्‌या मां जाणे बाजी रवला ने चे चेला रुटा लावणे वीसरी गुयला, ने ढंड्‌या मां तींद्‌रे धड़े एकुत रुटु हतलु। ");
INSERT INTO bhi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ने ईसु तेरा चेला काजे दाखलु दीन असु कय्‌न संभ्‌ळीन रवजु कह्‌यु की, “फरीसी माणसेन खमीर ने राजा हेरोदेसेन खमीर सी संभ्‌ळीन रवु।” ");
INSERT INTO bhi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","चेला आंबा-सांबा वीच्‌यार करीन कह्‌या, “आपणु रुटा नी लाया तेरेमां ईसु असो कय र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ने ईसु तींद्‌री जी वात जाणीन कह्‌यु तुहुं आंबा-सांबा हामरे धड़े रुटा नी हय करीन काहा वीच्‌यार करने बाजी र्‌या, हय बी तुंद्‌रो मन डेड़-अकल्‌या छे काय? तुहुंक हय बी जी वात समज मां नी आवती? ");
INSERT INTO bhi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","तुंद्‌रा डुळा छे, तेबी देखायतो नी? ने कान्‌‌‌टा हय्‌न, बी सामळायतो नी? ने तुहुंक जी हवली वात हेर नी हय? ");
INSERT INTO bhi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","जत्‌यार मे पांच हजार माणसेक पांच रुटा भांजीन आपलु, चां तुहुं रुटान कट्‌का ईछीन बेसका चार्‌या भरला? चे कह्‌या, “बारे चार्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ने जत्‌यार चार हजार माणसे वाटे सात रुटा भांजीन आपलु चां तुहुं भांजला रुटान कट्‌का, कतरा चार्‌या भरला?” चे ईसु काजे कह्‌या, “सात चार्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","अळी ईसु तीनुक कह्‌यु, “खाण्‌या-सुडान मतलब हय लग नी समज्‌या काय?” ");
INSERT INTO bhi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ने अळतेन ईसु ने तेरा चेला बेतसेदा गांव मां गुया; ने माणसे एक आंदळा काजे ईसु धड़े लाया ने ईसु सी लीलघाय्‌न कह्‌या की “आंदळा काजे छीमीन वारु कर दे।” ");
INSERT INTO bhi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ने ईसु आंदळान हात धरीन तीना काजे गांव मां सी बाहार लीज्‌‌यु ने तेरा डुळा मां थुपीन ने आपसान हात तेरा डुळा पर मेक्‌यु, ने तीनाक पुछ्‌यु “तुसेक काहींग देखाये काय?” ");
INSERT INTO bhi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","चु उपर भाळीन कह्‌यु, “माणसे काजे देख र्‌यु, बाकुन चे मेसेक असा देखाये की झाड़का चालने बाजी र्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","तत्‌यार ईसु अळी तेरा डुळा पर हात मेक्‌यु ने चु आंधळु तेरा डुळा उघाड़ीन देखणे बाजी गुयु। चु पछु आखो चुखो झण देखणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ईसु तीनाक असु कहींन घर मकल्‌यु, “ईना गांव मां पाय बी घुण मेले।” ");
INSERT INTO bhi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ईसु ने तेरा चेला केसर्‌या फीलीप गांव मां जाती र्‌या; ने वाटे ईसु चेला काजे पुछ्‌यु की, “माणसे मेसे काय कहें?” ");
INSERT INTO bhi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","चे कह्‌या “काहनाक कहें, हयु ते बपतीस्‌मा आपण्‌यु युहन्‌‌‌नु छे, बाकुन काहनाक कह्‌वे एलीया छे, काहनाक भगवानेन अघली वात बताड़ने वाळा माणसे मायन काहनुक एक छे कहें।” ");
INSERT INTO bhi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ईसु तीनुक पुछ्‌यु, “बाकुन तुहुं मेसेक काय कहुं, की मे कुण छे?” पतरस कह्‌यु, “छाचलीन तु भगवानेन मकेल्‌लु बचाड़ने वाळु मसी छे।” ");
INSERT INTO bhi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","तत्‌यार ईसु तीनुक चेताड़ीन असु कह्‌यु, “मारे बारामां जी वात कुय काजे घुण कहुं।” ");
INSERT INTO bhi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","तत्‌यार चु चेलाक सीकाड़्‌यु की, मे माणसेन पुर्‌यु छे, ने मेसे काजे ठहरावलो छे, की चु बेसकु दुख हाकलसे ने मुख्‌या ने, डाहला पुजारा, ने यहुदी नीयमेन मास्‌तर्‌या तीनाक फालतु समजीन मार देसे, ने चु तीन दाहड़ाम पछु जीवतु हय जासे। ");
INSERT INTO bhi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","चु जी वात संय-संय तेरा चेला काजे कय देदु। जी सहलाणी पतरस ईसु काजे अलग ली जाय्‌न लड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","बाकुन ईसु पछु अळीन दीसरा चेला भीणी भाळ्‌यु ने तींद्‌रे अगळ पतरस काजे लड़ीन कह्‌यु, “ए भुतड़ा मारे सी छेटु जाती रव; काहाकी तु भगवानेन वात पर नी, बाकुन माणसेन वात पर मन लागाड़ीन कह्‌णे बाजी र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ने ईसु माणसेन टुळाक ने चेला काजे धड़े बुलायन कह्‌यु, “जे कुय मारु चेलु बणीन मारे पुठ्‌ये आवणे हींडे, चु आपसान मरजी नी बाकुन मारी मरजी पुरी करनु चाहजे, ने आपसान कुरुस हाकलीन मारे पछळ चाले। ");
INSERT INTO bhi_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","काहाकी जु कुय आपसान जीव काजे बचाड़ने चाहे, चु तेरा जीव काजे खुवसे बाकुन जु कुय मारे वाटे ने खुस-खबर वाटे तेरु जीव खुवसे हयुत आपसान जीव काजे बचाड़ लेसे। ");
INSERT INTO bhi_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","कदी माणसे आखी कळी काजे हात करलेय, ने तेरा जीव खुय देय, ती तीनाक काय फायदु छे? ");
INSERT INTO bhi_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ने चु तेरा जीव पछु हेरने करीन तेरा जीवनेन आवजी मां काय आपसे? ");
INSERT INTO bhi_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","जु कुय ईनी छीनाळा ने पापी दाहड़ा मां, माणसेन ईचमां मारे सी ने मारी वात सीकाड़ने सी लाजवाय्‌से, ती माणसेन पुर्‌यु बी, जत्‌यार चुखला सरग वाळा काहवाळ्‌या भेळु तेरा बासेन सेक-सींगार साते आवसे, तत्‌यार तीने दाहड़े तीना काजे लाजवाय्‌से।” ");
INSERT INTO bhi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ईसु, चेला ने माणसेन अगळ ज कह्‌यु, “मे तुहुंक छाचलीन कहं की, जे जां उबा हय र्‌या, तींद्‌रेम सी काहना काहनाक असा बी छे, की जत्‌यार लग भगवानेन राज काजे ताकत भेळु आवतेला देख नी लेय, तत्‌यार लग चे नी मरे ने नी माने।” ");
INSERT INTO bhi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","छव दाहड़ा हय गुया ने पछेन ईसु, पतरस ने याकुप ने युहन्‌ना काजे पुठ्‌ये लीन एक मटला बयड़ा पर गुयु। चां चे एखलात हतला; ने चां चेलान अगळ ईसुन सीकु बदली गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ने तेरा पुथल्‌या उजाळा हय्‌न जग-जग पप्‌लने बाजी गुया ने अतरा बेसका उजाळा हय गुया की धरती पर काहनु बी धुबी अतरा नवा नी कर सके। ");
INSERT INTO bhi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ने तीनु चेला, एलीयु ने अळी मुसु देखाव पड़्‌या; ने चे ईसु साते वात करने बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","पतरस ईसु काजे वात करतु जाय्‌न कह्‌यु, “ए मास्‌तर, जां रहणु हामरे वाटे बेसको वारु छे: तेरेमां हामु जां तीन खपड़ी बणावजे। एक तारे वाटे ने एक मुसा वाटे ने एक एलीया वाटे।” ");
INSERT INTO bhi_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","काहाकी पतरस नी जाणतेलु की काय जपाप आपो, काहाकी हयु बेसकु बीही गुयलु। ");
INSERT INTO bhi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","तत्‌यार एक आदळो आवीन तीनुक टुप लेदो, ने तीना आदळा मां सी जी अवाज सामळाय “जु मारु लाटेक्‌लु पुर्‌यु छे; हेरी वात सामळु!” ");
INSERT INTO bhi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","तत्‌यार चां चेला तत्‌यारुत चारे मेर भाळ्‌या, बाकुन चां ईसु काजे छुड़ीन कुय नी, देखाव पड़्‌यो। ");
INSERT INTO bhi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","बयड़ा पर सी उतरतु जाय्‌न ईसु तीना चेला काजे ज हुकुम आप्‌यु जत्‌यार लग माणसेन पुर्‌यु मरला मां सी पछु जीवतु हय्‌न बठु नी हवे, तत्‌यार लग ज काय तुहुं देखला छे, च कुय काजे घुण कहुं। ");
INSERT INTO bhi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","चेला ईसुन वात मानीन जी वात तींद्‌रा मन मां राख्‌या; ने चे आंबा-सांबा वीच्‌यार कर्‌या की, “मरला मां सी जीवतु हय्‌न बठु हवणेन मतलब काय छे?” ");
INSERT INTO bhi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ने चेला ईसु काजे पुछ्‌या, “असो हय ती, यहुदी नीयमेन मास्‌तर्‌या काहा कहें की पेहेल एलीयान आवणु टाकायलो छे?” ");
INSERT INTO bhi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ईसु तीनुक कह्‌यु “हव छाचलीन, असोत लिखलो छे की एलीयु पेहेल आवीन आखो कय्‌न सुदारीन तीयार करसे, बाकुन माणसेन पुर्‌यान बारामां असो काहा लिखायलो छे, की तीनाक बेसकु दुख झेलनु पड़से, ने माणसे तीनाक नानु समजीन तेरो नाव-बद्‌दी करसे। ");
INSERT INTO bhi_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","बाकुन मे तुहुंक कहं, एलीयु ते आय गुयलु छे, ने जत्‌यार चु आयु तत्‌यार माणसे जसों बी मन मां आयो तसों तेरे साते वेहवार कर्‌या। ने तेरा बारामां लिखलो छे।” ");
INSERT INTO bhi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ईसु तीनु तीन चेलाक लीन दीसरा चेलान चां पछु गुयु ती, चां चे देख्‌या की दीसरा चेलान चारे मेर बेसकु माणसेन टुळु भेळु हय र्‌यु, ने थुड़ाक यहुदी नीयमेन मास्‌तर्‌या तींद्‌रे साते वात मां जखड़ी पड़ी र्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ने उचकान ईसु काजे देख्‌या तत्‌यार आखा माणसे देखतात रय गुया। ने तेरो आव-भाव करने करीन दवड़ीन आया। ");
INSERT INTO bhi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ने ईसु तीनुक पुछ्‌यु, “तुहुं तींद्‌रे साते काहनी वात मां जखड़ी र्‌या?” ");
INSERT INTO bhi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","टुळा मां सी एक जणु जपाप आप्‌यु, “ए मास्‌तर, मे मारा पुर्‌या काजे तारे धड़े लावणे करीन लावलु, हेरे मां भुतड़ु भराय र्‌यु, चु बुबड़ु छे। ");
INSERT INTO bhi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ने काहनी बी जागा पर भुतड़ु चस्‌टी जाय चांहान पाड़ देय, ने हीना पुर्‌यान मुंहडा मां फेसकड़ु आवे ने करकेड़ु हय जाय, ने दात बी ककड़ावे ने आकड़ाय जाय तेरे सी मे तारा चेला काजे कह्‌यु की, हेरे मां सी भुतड़ु नीकाळ दे करीन कह्‌यु बाकुन तीनाक चे नीकाळ्‌यु नी सक्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ने असो सामळीन ईसु तीनुक कह्‌यु, “ए नी भुरसु करने वाळा माणसे, मे कत्‌यार लग तुंद्‌रे पुठ्‌ये रवीस ने तुहुंक सेण करीस? हीना पुर्‌या काजे मारे धड़े लावु।” ");
INSERT INTO bhi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","तत्‌यार चे तीना पुर्‌याक ईसु धड़े लाया। ने जत्‌यार ईसु तीनाक देख्‌यु ती चु भुतड़ु तीना पुर्‌या काजे मुयड़ी देदु, ने चु पुर्‌यु भुयमां पड़ी गुयु। ने मुंहडा मां सी फेसकड़ु नीकाळतु जाय्‌न वारु हवणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","तत्‌यार ईसु तीना पुर्‌यान बास काजे पुछ्‌यु, “जु असु हवलु कतरा दाहड़ा हय गुयु।” ने चु कह्‌यु “नानलु हतलु ती सी छे। ");
INSERT INTO bhi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","भुतड़ु हीना काजे मारने करीन कांखुर आकठा मां ने कांखुर पाणी मां नाख देय; बाकुन कदी तुसेक बणे, तत्‌यार हामरे पर दया करीन हामरो भलो कर!” ");
INSERT INTO bhi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ने ईसु तीनाक कह्‌यु, “कदी तुसेक बणे जाय ती! असु मेसेक काय लेणे कहें? भुरसु करने वाळा वाटे आखो हय सके।” ");
INSERT INTO bhi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","तत्‌यारुत तीना पुर्‌यान बास कलेप्‌तु जाय्‌न कह्‌यु, “मे भुरसु करो ने अळी बी मदत करीन मारा भुरसाक बड़ाव!” ");
INSERT INTO bhi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","तत्‌यार माणसे दवड़ीन आवीन भेळा हवणे बाजी गुया। ती ईसु तीना भुतड़ाक असु कय्‌न लड़्‌यु, ए बेहरा ने बुबड़ा भुतड़ा, मे तुसेक हुकुम आपो की हीना पुर्‌या मां सी नीकळी जां, ने पछु आवीन हेरे मां घुण भराये। ");
INSERT INTO bhi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","तत्‌यार भुतड़ु आयड़ीन, तीना पुर्‌या काजे बेसकु मुयड़तुत नीकळी गुयु। ने पुर्‌यो मरलोत हय गुयो ने आखा माणसे कह्‌णे बाजी गुया की, ज पुर्‌यु मर गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","बाकुन ईसु पुर्‌यान हात धरीन उठाड़्‌यु ने पुर्‌यु उबु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","जत्‌यार ईसु घर आयु, ती ईसु एखलुत हतलु चां तेरा चेला तीनाक पुछ्‌या, “हामरे सी भुतड़ु काहा नी नीकळयु?” ");
INSERT INTO bhi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","चु चेलाक कह्‌यु, “असा भुतड़ान जात भगवान सी दुवा करे, पाखुर नी नीकळे।” ");
INSERT INTO bhi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","पछेन ईसु ने चेला चां सी गलील ईलाका मायन जाणे बाजी रवला। ने चु नी चाहतेलु की काहनाक मेसेक उळखी लेय, ");
INSERT INTO bhi_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","काहाकी चु आपसा चेला काजे सीकाड़ने बाजी रवलु ने तीनुक कवतेलु, “माणसेन पुर्‌यु माणसेन हाते धराय जासे, ने चे तीनाक मार देसे; ने चु मरनेन तीन दाहड़ा मां पछु जीवतु हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","बाकुन चेला ची वात नी समज्‌या नी, ने चे ईसु काजे जी वात पुछने बीहतेला। ");
INSERT INTO bhi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","पछेन चे कफरनहुम मां आया; ने ईसु घर मां आय्‌न तीनुक पुछ्‌यु, “वाट्‌ये तुहुं काहनी वात मां जखड़ी र्‌या?” ");
INSERT INTO bhi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","बाकुन आखा हुगात हय रवला, काहाकी वाटे चे ईनी वात मां जखड़ी पड़ी रवला की आपणे मां सी मटु कुण छे। ");
INSERT INTO bhi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","तत्‌यार ईसु बठी गुयु ने बारे चेला काजे बुलायु ने तीनुक कह्‌यु, “कदी काहनुक मटु बन्‌नु हय ती तीना काजे आखा सी नानु ने आखान पावर्‌यु बन्‌नु पड़से।” ");
INSERT INTO bhi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ने चु एक नानला पुर्‌या काजे बुलायन तींद्‌रे ईचमां उबु कर्‌यु, ने तीना काजे खुळा मां लीन तीनुक कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ज कुय मारा नाव सी असा नानला पुर्‌या मायन काहनाक एकेन बी आव-भाव करे; चु मारी आव-भाव करे ने जे कुय मारी आव-भाव करे चु मारी अतरी नी बाकुन मेसेक मकलने वाळान बी आव-भाव करे।” ");
INSERT INTO bhi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","युहन्‌‌‌नु ईसु काजे कह्‌यु, “ए मास्‌तर, हामु एक माणुस काजे तार नाव सी भुतड़ाक नीकाळ तेलान देख्‌या ने हामु तीनाक कह्‌या, तु हामरे पुठ्‌ये चाल बाकुन चु हामरे पुठ्‌ये आवणे नी हींडी रवलु, अतरा मां हामु तीनाक कह्‌या ईसुन नाव सी भुतड़ा मां नीकाळे।” ");
INSERT INTO bhi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","बाकुन ईसु कह्‌यु तीनाक मारे नाव सी भुतड़ा काजे मां नीकाळे करीन घुण कहुं, काहाकी असो कुय नी हय जु काहनुक मारा नावेन ताकुतेन काम करीन थुड़ीक वार मां मारु वाक नीकाळतु हय। ");
INSERT INTO bhi_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","काहाकी जु कुय आपणी वीरुद मां नी हय, चु आपणे वळु छे। ");
INSERT INTO bhi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","मे तुहुं काजे ईसु मसीन चेला छे करीन, असु कहं की ज कुय एक कळस्‌यु पाणी पावे ती मे छाचलीन कहं, “चु तेरा कामेन फळ कदी नी खुवे।” ");
INSERT INTO bhi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“जे कुय ईनु नानला मां सी मार पर भुरसु करे ने काहनाक काजे पाप मां पाड़े ने तीनुक पाप कराड़े, ती तेरे वाटे ज वारु छे की तेरा गळा मां घट्‌टीन पुड़ बांदीन तीना काजे समुदरेन पाणी मां नाख देणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","कदी तारु हात पापेन उत्‌तर बणीन तुसेक पाप कराड़े, तीना हात काजे काटीन नाख दे; काहाकी दुय हात रवतात बी तु असी नरक आकठाम जाती रवसी, बाकुन ठटळ्‌यु हय्‌न अमर-जीवन हात करने सरगेम जासी। ");
INSERT INTO bhi_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","काहाकी नरकेन आकठी मायन कीड़ा कदी नी मरे ने चां वाळो आकठो कदी नी उल्‌हायें। ");
INSERT INTO bhi_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","कदी तारु पाय तुसे पाप कराड़े, तत्‌यार तीना पाय काजे तुड़ीन नाख देजी, काहाकी दुय पाय रवतात बी नरक-आकठी मां जाती रवसी, बाकुन लंगड़ु हय्‌न बी अमरेन जीवन हात करीन सरग मां जाणु वारु छे। ");
INSERT INTO bhi_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","काहाकी नरक-आकठी मायन कीड़ा कदी नी मरे ने चां वाळो आकठो कदी नी उल्‌हायें। ");
INSERT INTO bhi_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","कदी तारु डुळु उत्‌तर बणीन तुसेक पाप कराड़े, तत्‌यार तीना डुळा काजे नीकाळीन नाख दे। काहाकी दुय डुळा रवतात बी नरकेन आकठी मां नाखायसी, बाकुन काणु बणीन भगवानेन राज मां जाणु वारु छे। ");
INSERT INTO bhi_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","काहाकी नरकेन-आकठी मायन कीड़ा कदी नी मरे ने चां वाळो आकठो कदी नी उल्‌हायें।” ");
INSERT INTO bhi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","काहाकी हर एक माणुस आकठा सी पारखायसे। जसों चड़ावु नण सी पारखाये। ");
INSERT INTO bhi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","नण ते वारलु चीज छे, बाकुन कदी नणुत मुळो हय जाय ने सवाद खुय देय, तत्‌यार च पछो काय सी ने कसों खारो करसु? “तेरेसी तुहुं आंबा-सांबा हेळी-मेळीन रय्‌न आपसान नणेन सवाद समाळीन राख्‌जु।” ");
INSERT INTO bhi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","पछेन ईसु तीना जागाक छुड़ीन यहुदीया ईलाका मां जाणे करीन यरदन नदीन पली धड़े गुयु, ने माणसेन गड़दी अळी तेरे धड़े भेळु हय गुयु; ने जसु हयु पेहेल सीकाड़तेलु तसुत तीनुक सीकाड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","तत्‌यार फरीसी माणसे हेरे धड़े आवीन पारखणे करीन पुछ्‌या अदमी आपसान बायर काजे छुड़नु वारु छे काय? ");
INSERT INTO bhi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ईसु तीनुक जपाप आप्‌यु, “मुसु तुहुंक काय हुकुम आपलु छे?” ");
INSERT INTO bhi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","फरीसी माणसे कह्‌या, “मुसु कह्‌लु की काहनुक चाहे ती चिट्‌ठी लिखीन झगड़ु भांजीन लाडी काजे छुड़ देणेन हुकुम आपलु छे।” ");
INSERT INTO bhi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ईसु तीनुक कह्‌यु, “मुसु ते तुंद्‌रे वाटे जी हुकुम तेरेमां लिखलु की, तुहुं काजे काय बी समज मां नी आवतेली। ");
INSERT INTO bhi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","बाकुन भगवान कळी घड़्‌यु तेरसी पेहलुत जी हुकुम नी आप्‌यु बाकुन भगवान ते सुरु मां अदमी ने बायर करीन घड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","हेरे वजे सी अदमी तेरा आयस-बास सी अलग हय्‌न तेरी बायर साते भेळु रवसे। ");
INSERT INTO bhi_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ने चे दुय जणा एक डील बण जासे। तेरेमां हय सी चे दुय डील नी बाकुन एकुत डील छे। ");
INSERT INTO bhi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","तेरेमां तीनुक भगवान जुड़्‌लु छे, तीनुक कुय बी माणुस अलग नी करनु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ने जत्‌यार चे घर गुया, तत्‌यार चेला एरे बारामां अळी ईसु काजे पुछ्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ईसु तीनुक कह्‌यु, “जु काहनुक माणुस पेहली लाडी काजे छुड़ीन दीसरी लाडी बणावे, चु पेहली लाडीन वीरुद मां छीनाळो करे। ");
INSERT INTO bhi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ने कदी लाडी आपसान घरवाळाक छुड़ीन दीसरु घरवाळु करे चां ची बी छीनाळो करे।” ");
INSERT INTO bhi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","पछेन आस्‌या-बास्‌या तींद्‌रा पुर्‌या-पुरेक ईसु धड़े लावणे लाग्‌या; काहाकी ईसुन हात हीनु पर मेकाड़ीन संयबरकत मांगणे हींडी रवला बाकुन चेला तीनुक लड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ईसु चेला काजे लड़तेला देखीन रीसवायन ने तीनुक हुकुम आपीन कह्‌यु, “हीनुक मां रुकु पुर्‌या-पुरे काजे मारे धड़े लावणे देवु; काहाकी भगवानेन राज हींद्‌रेत तसलान छे।” ");
INSERT INTO bhi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","मे तुहुं काजे छाचलीन कहं “जे काय भगवानेन राजेन हक मां नानला पुर्‌या-पुरेन तसु भुरसु करीन नी रवे ती तीनुक तीना भगवानेन राज मां कदी नी जावाये।” ");
INSERT INTO bhi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ने ईसु पुर्‌या काजे खुळा मां लेदु ने तींद्‌रे पर तेरु हात मेलीन संयबरकत आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","तत्‌यार ईसु यरुसलेम भीणी जाणे करीन वाटे लाग्‌यु, चां एक माणुस तेरे धड़े दवड़ीन आयु, ने तेरा पाये पड़ीन तीनाक पुछ्‌यु “ए वारलु मास्‌तर जलम जीवन हात करने करीन मे काय करो?” ");
INSERT INTO bhi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ने ईसु तीनाक कह्‌यु, “तु मेसेक वारलु काहा कहें?” भगवान काजे छुड़ीन कुय बी वारलु नी हय बाकुन भगवान अतरुत वारलु छे। ");
INSERT INTO bhi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","तु हुकुम काजे जाणे की, “खुन घुण करे, छीनाळो घुण करे, चुरी घुण करे, झुटी गवाय घुण देय, कुय काजे ठगे घुण ने तारा आस्‌या-बासेन ईज्‌जत करजी।” ");
INSERT INTO bhi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ने चु ईसुक कह्‌यु, “ए मास्‌तर जे आखा हुकुम ते मे नानलु हतलु तीन सी मान्‌तु आय रयु।” ");
INSERT INTO bhi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ने ईसु तेरे भीणी बेसकु परम भाव सी भाळ्‌यु ने तीनाक कह्‌यु, “तारे मां एक वातेन कसर छे जां जतरो बी तारो छे तीनाक वेचीन गरीब काजे आखो आप दे ने अळतेन मारे पुठ्‌ये आवजी। असु करसी तत्‌यार तुसेक सरग मां धन जड़से।” ");
INSERT INTO bhi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","काहाकी चु माणुस बेसकु लकपती हतलु। तेरे मां चु ईसुन वात सामळीन चु बेसकु फीकुर मां पड़ गुयु ने दुखी हय्‌न पछु जात रयु। ");
INSERT INTO bhi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ईसु चारे मेर भाळीन तेरा चेला काजे समजाड़तु जाय्‌न कह्‌यु, “जादा पयस्‌या वाळाक भगवानेन राज मां भरायणु बेसको काठो छे।” ");
INSERT INTO bhi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ईसुन वात सामळीन चेला देखतात रय गुया। बाकुन ईसु अळी तीनुक कह्‌यु “मारा पुर्‌या! काहनुक धन पर भुरसु राखे तींद्‌रे वाटे भगवानेन राज मां जाणु बेसको काठो छे। ");
INSERT INTO bhi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","उटड़ान सुईन नाचका मायन नीकळी जाणु सरल छे, बाकुन लकपती माणसे काजे भगवानेन राज मां जाणु बेसको काठो छे।” ");
INSERT INTO bhi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","चेला बेसका देखतात रय गुया, ने आपसात कह्‌णे लाग गुया, “ती कुणीन छुटकारु हय सक्‌से?” ");
INSERT INTO bhi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ईसु चेला भीणी भाळीन कह्‌यु, “माणसे सी ते ज नी हय सके, बाकुन भगवान सी हय सके, काहाकी भगवान आखो काय कर सके।” ");
INSERT INTO bhi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पतरस ईसु काजे कह्‌णे बाजी गुयु, “देख, हामु ते आखो काय छुड़ीन तारे पछळ आय र्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ईसु कह्‌यु, “मे तुंद्‌रे सी छाचलीन कहं, असा कुय नी हय जु मारे वजे सी ने खुस-खबरेन परचार करने करीन घर, खेत, भायस, बहणस्‌या, आयस-बास ने पुर्‌या-पारी काजे छुड़ देदु हय, ");
INSERT INTO bhi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ने तुहुंक छाचलीन कहं की ईना जीवन मां घर ने भायस ने बहणस्‌या ने आस्‌या ने पुर्‌या ने खेत सी, सोव गुणा फायदु नी जड़से, ने गरात आवती रवसे बाकुन तीनाक आवणे वाळा दाहड़ा मां जलम जीवन जड़से। ");
INSERT INTO bhi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","बाकुन बेसका माणसे छे चे अगळ छे, बाकुन पछळ हवसे ने जे पछळ छे चे अगळ हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ईसु ने चेला यरुसलेमेन वाटे जातला ने वाटेत हतला, ने ईसु तींद्‌रे अगळ-अगळ जातलु, तेरा चेला ने पछळ-पछळ चालन्‌या दीसरा माणसे बी बीही रवला। अतरा मां ईसु बारे चेला काजे अळी अघु ली जाय्‌न तीनुक तेरे पर ज हवणे वाळो हतलो, च कह्‌णे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“सामळु आपणु यरुसलेम जाणे बाजी र्‌या, चां माणसेन पुर्‌यु डाहला पुजारा ने यहुदी नीयमेन मास्‌तर्‌यान हातेम धराय जायस, ने चे तीनाक गुनाळु ठहराय्‌न मरनेन डंड आपीन, नी-यहुदी वाळा आड़जातीन सुपरुत कर देसे। ");
INSERT INTO bhi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","चे तेरी हासी उड़ाव्‌से ने तेर पर थुप्‌से ने सड़काय देसे, ने मार देसे, बाकुन पछु चु तीन दाहड़ाम मरला मां सी पछु जीवतु हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","तत्‌यार जब्‌दीन पुर्‌यु याकुप ने युहन्‌‌‌नु ईसु धड़े आवीन कह्‌या, “ए मास्‌तर, हामरी आस जी छे, की ज बी हामु तार सी मांगसुन, च हामरे वाटे कर।” ");
INSERT INTO bhi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","चु तीनुक कह्‌यु, “तुंद्‌री काय आस छे, चो तुंद्‌रे वाटे करो।” ");
INSERT INTO bhi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","चे कह्‌या, “जत्‌यार तु तारी सेक-सींगार भेळु राज करने करीन, राजगादी पर बठ्‌सी, ती हामरे मायन एक काजे तारे जेवड़्‌ये आंगे ने एक काजे तारे डाखर्‌ये आंगे बसणेन हक आप्‌जी।” ");
INSERT INTO bhi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ईसु तीनुक कह्‌यु, “तुहुं ज मांगणे बाजी र्‌या, तीनी वातेन मतलब तुहुंक मालुम बी नी हय। ज दुखेन पीयालु मे पीणेवाळु छे, चु पीयालु तुहुं पी सक्‌सु काय? ने ज दुखेन बपतीस्‌मा मे लेणे वाळु छे, चो बपतीस्‌मा तुहुं ली सक्‌सु काय?” ");
INSERT INTO bhi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","चे तीनाक कह्‌या, “तु कह्‌सी तसों हामु करसुन।” ने ईसु तीनुक कह्‌यु, “ज दुखेन पीयालु मे पीणेवाळु छे, चु पीयालु तुहुंक बी पीणु पड़से, ज दुखेन बपतीस्‌मा मे लेणे वाळु छे, च बपतीस्‌मा तुहुंक बी लेणु पड़से। ");
INSERT INTO bhi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","बाकुन मारा जेवड़्‌ये आंगे ने डाखर्‌ये आंगे कुणीक बठाड़नु छे, जी वात मारा हक मां नी हय। बाकुन जु जागु तीनुत काजे देसे, तींद्‌रे वाटे भगवान तीयार करलु छे।” ");
INSERT INTO bhi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","बाकुन जी वात सामळीन याकुपेन ने युहन्‌ना पर, दीसरा दस चेला रीसाय पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ईसु तीनु आखा काजे धड़े बुलायन कह्‌यु, “तुहुं जाणु की, नी-यहुदी मां हकवाळा माणसे; तेरा जागा पर हक जमाड़ीन राज करे, ने तीना हक जमाड़न्‌या पर अळी दीसरा मटला माणसे हक जमाड़े। ");
INSERT INTO bhi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","बाकुन तुंद्‌रे मां असो नी हय। ज तुंद्‌रे मां मटु हवणे हींडे, चु तुंद्‌रु पावर्‌यु बन्‌नु चाहे। ");
INSERT INTO bhi_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ने कदी तुंद्‌रे मायन आखान डाहलु बन्‌ने हींडे, चु आखान हक मां रय्‌न पावर्‌यु बन्‌नु चाहे। ");
INSERT INTO bhi_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","काहाकी मे माणसेन पुर्‌यु मारी सेवा चाकरी कराड़्‌ने नी आयु, बाकुन सेवा करने आयु, ने बेसका जणान जीव बचाड़ने करीन ने आपसा जीव हामरे वाटे देणे आवलु छे।” ");
INSERT INTO bhi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ईसु ने तेरा चेला यरीहो गांव मां आयु, ने जत्‌यार ईसु ने तेरा चेला चां सी माणसेन एक मट्‌लु टुळु बी तींद्‌रे पुठ्‌ये यरुसलेम जाणे करीन चाली पड़्‌यु। चां एक आंधळु भीकारी सयड़क पर बठी रवलु। चु भीकारी तीमायुन पुर्‌यु बरतीमाय हतलु। ");
INSERT INTO bhi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","चु ज सामळ्‌यु की नासरत वाळु ईसु आवणे बाजी रयु, तत्‌यार चु आंधळु आयड़ी-आयड़ीन कह्‌यु “ए दावुदेन अवल्‌यात! ईसु मार पर दया कर।” ");
INSERT INTO bhi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","बेसका माणसे तीना काजे, हुगु रव करीन लड़ने बाजी गुया, चु अळी आयड़ीन कह्‌णे बाजी गुयु, “ए दावुदेन पुर्‌या, मार पर दया कर।” ");
INSERT INTO bhi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","तत्‌यार ईसु उबु रय्‌न हुकुम आपीन कह्‌यु, “हीनाक जां बुलावु।” ने माणसे तीनाक बुलायन कह्‌या, “हिम्‌मत राख!” ने उठ, “तुसे ईसु बुलावे।” ");
INSERT INTO bhi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","चु तेरु पुथल्‌या नाखी दीन, उछळीन ईसु धड़े आयु। ");
INSERT INTO bhi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ईसु तीनाक कह्‌यु, “तु काय चाहे की मे तारे वाटे करो।” चु तीनाक कह्‌यु “ए मास्‌तर, मे पछु देखणे हींडी रयु।” ");
INSERT INTO bhi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ईसु तीनाक कह्‌यु “जां, तारु भुरसु तुसेक वारु कर देदु।” ने चु तत्‌यारुत देख्‌णे बाजी गुयु ने हयु ईसु पछळ चाली पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","तसात ईसु ने चेला, ने पुठ्‌ये चालन्‌या माणसे यरुसलेम गांव धड़े जेतुन झाड़कान बयड़ा पर बेतफगे ने बेतन्‌या गांव धड़े आया, चां ईसु तेरा चेला मां सी दुय काजे मकल्‌यु, ");
INSERT INTO bhi_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“तुहुं काजे पल्‌लो गांव देखाये चां जावु, ने चां जातान तुहुं काजे गदड़ीन पीलो बांदलो देखायसे; तेरे पर, हाल लग कुय नी बठ्‌यो, तीना काजे छुड़ीन ली आवु। ");
INSERT INTO bhi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","कदी तुहुंक काहनाक पुछे की हीना काजे काय करने छुड़ी रया? ती तुहुं कवजु, मालीक काजे ज गदड़ो चाहजे ने मालीक हीना गदड़ा काजे छाटुस पछु दी मकलसे।” ");
INSERT INTO bhi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ने चे जाय्‌न च गदड़ीन पीलो वाटे धड़े आंगणा मां बांदायलो देखीन छुड़ने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ने चां उबा हय रवला, चे काहनाक कह्‌णे बाजी गुया, “गदड़ीन पीला काजे छुड़ीन काय करने हींडी र्‌या?” ");
INSERT INTO bhi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","जसु ईसु तीनुक कह्‌लु तसात चे तीनुक कय देदा; तत्‌यार चे गदड़ीन पीला काजे लीन जाणी देदा। ");
INSERT INTO bhi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ने चे गदड़ीन पीला काजे ईसु धड़े लाया ने चे तींद्‌रा पुथल्‌या गदड़ान पीला पर नाख देदा। ने ईसु तीना गदड़ीन पीला पर बठ गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","तत्‌यार बेसका माणसे तींद्‌रा पुथल्‌या ईसु अगळ-अगळ वाटे पर आथरी देदा ने दीसरा माणसे खेतेन सेडे सी पान्‌टा वाळा डाळखा काटी काटीन लाय्‌न आथरी देदा। ");
INSERT INTO bhi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","चे बी ईसुन अगळ-अगळ ने पछळ-पछळ जातला चे आयड़ी-आयड़ीन कवतेला, “होसान्‌ना मतलब ए मालीक हामुक वाचाड़! बरकतवाळु छे चे, जे मालीकेन नावे सी आवे! ");
INSERT INTO bhi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","आपणा बास दावुदेन राज चो आव्‌णे बाजी र्‌यो; बरकतवाळु छे! उंचा सरग मां भगवानेन बड़ाय हवे होसान्‌ना।” ");
INSERT INTO bhi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ने ईसु यरुसलेम मां पुगीन मंदीर मां गुयु, ने चारे मेर वाळी आखी चीज काजे देख्‌यु, काहाकी दाहड़ु डुबणे वाळु हतलु, तत्‌यार ईसु चेला पुठ्‌ये बेतन्‌या गांव मां गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","दीसरे दाहड़े ईसु ने चेला बेतन्‌या सी नीकळीन गुया, ती ईसु काजे भुक लागी। ");
INSERT INTO bhi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ने चे छेटे रय्‌न एक अंजीरेन नीळ्‌ळा झाड़का काजे देखीन धड़े गुयु की काहींग चां खाणेन जड़ जाय, बाकुन पान्‌टाक छुड़ीन काय बी नी हतलो काहाकी फळ लागणेन टेम नी आय रवली। ");
INSERT INTO bhi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ईनी वात पर ईसु झाड़काक कह्‌यु, “हय सी तारा फळ कदी नी लागे ने कुय काजे बी खाणेन नी जड़े!” ने चे सराप देतलान चेला सामळी रवला। ");
INSERT INTO bhi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","पछेन ईसु ने चेला यरुसलेम मां आया, ने ईसु मंदीर मां गुयु, ने चे लेण-देण कर तेला तीनु काजे बाहर नीकाळने लाग्‌यु, ने पयस्‌या अदलु-बदलु करन्‌याक ने पेरवा वेचणे वाळान चारला उथलाय दीन बाहार नीकाळ देदु। ");
INSERT INTO bhi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ने ईसु मंदीर मां आखा काजे ठाहरा लीन आवणु जाणु बंद कर देदु। ");
INSERT INTO bhi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ने सीकाड़तु जाय्‌न कह्‌यु, काय असो नी लिखलो हय की, मारो घर आखा देसेन माणसेन भक्‌तीन घर कवाय्‌से बाकुन तुहुं ते ईना घर काजे चुट्‌टान घर बणाय देदा! ");
INSERT INTO bhi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ज सामळीन यरुसलेम मंदीरेन डाहलु पुजारु ने यहुदी नीयमेन मास्‌तर्‌या हतला। अतरा मां चे ईसु काजे मारनेन मुखु हेरने लाग्‌या। काहाकी आखा माणसे ईसुन सीकाड़नेन वात सी देखतात रय जातला ने ईसु सी बीहतेला। ");
INSERT INTO bhi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ने सांती वेळाय ईसु ने तेरा चेला गांव छुड़ीन जात र्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","पछेन संदारे तीनीत वाटे सी जाणे बाजी रवला, चां चे अंजीरेन झाड़का काजे मुळे लग सुकलो देख्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पतरस काजे ईसुन कह्‌ली वात हेर आवी, ने चु तीनाक कह्‌यु, “ए मास्‌तर देख। ज अंजीरेन झाड़को तीनाक तु सराप देदलु च सुकी गुयो।” ");
INSERT INTO bhi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ईसु तीनु काजे कह्‌यु, भगवान पर भुरसु राखु। ");
INSERT INTO bhi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","मे तुंद्‌रे सी छाचलीन कहं, जु काहनुक ईना बयड़ा सी कहें की, तु उखळीन समुदर मां नाखाय जां, ने आपसान मन मां संका नी करु ने भुरसु राखे की, ज तु कहें च हय जासे ने तेरे वाटे चत हवसे। ");
INSERT INTO bhi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","तेरेमां मे तुंद्‌रे सी कहं, “की ज काय तुहुं दुवा करीन मांगु ने भुरसु कर लेवु की हामुक जड़ गुयो ने तुंद्‌रे वाटे जड़ जासे। ");
INSERT INTO bhi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ने जत्‌यार बी तुहुं दुवा करने करीन उबा हवु, तत्‌यार कुय पर बी तुंद्‌रा मन मां रीस हय ती तीनाक माफ कर देवु; काहाकी तुंद्‌रु सरग वाळु बास जु सरग मां रवे, हयु बी तुंद्‌रु पापेन माफी आपसे। ");
INSERT INTO bhi_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ने कदी तुहुं दीसरान गुनु माफ नी करु, ती तुंद्‌रु बास सरग मां छे चु, तुंद्‌रा गुना काजे बी माफ नी करसे।” ");
INSERT INTO bhi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","पछेन चे यरुसलेम मां आया, ने तत्‌यार ईसु मंदीर मां फीरतेलु चां मंदीरेन डाहला पुजारा ने नीयमेन मास्‌तर्‌या ने डाहला तेरे धड़े आया। ");
INSERT INTO bhi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ने चे तीनाक पुछ्‌या, जे काम तु काहना हक सी करे? जे काम करनेन हक तुसेक कुण आप्‌यो? ");
INSERT INTO bhi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ईसु तीनुक कह्‌यु, “मे बी तुंद्‌रे सी एक वात पुछो; मेसेक तुहुं जपाप आपु ती, मे बी तुहुं काजे बताड़ीस की मे जे काम कुणीन हक सी करो। ");
INSERT INTO bhi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","युहन्‌ना काजे बपतीस्‌मा आपणेन हक भगवान भीणी सी जड़लो की माणसे भीणी सी? मेसेक बताड़ु।” ");
INSERT INTO bhi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ने चे ईनी वात पर वीच्‌यार करने बाजी गुया; कदी आपणु कवसुन भगवान आपलु, ती चु कवसे, तत्‌यार तुहुं युहन्‌ना पर भुरसु काहा नी कर्‌या? ");
INSERT INTO bhi_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ने कदी आपणु कवसुन, माणसे हीनाक हक आपला छे, ती चां चे भेळा हय रवला माणसे सी बीहणु हतलो; काहाकी आखा माणसे युहन्‌ना काजे छाचलीन भगवानेन अघली वात बताड़ने वाळु मानतेला। ");
INSERT INTO bhi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","तेरेमां चे ईसु काजे असा कह्‌या, “हामुक मालुम नी हय।” ती ईसु तीनुक कह्‌यु, “मे बी तुहुंक नी बताड़तु की, ज काम कुणीन हक सी करो।” ");
INSERT INTO bhi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","पछेन ईसु दाखला मां तींद्‌रे सी वात करने लाग्‌यु, “एक माणुस खेत मां अंगुरेन वाड़ी लागाड़्‌यु ने खेतेन चारे मेर वाड़ी कर्‌यु ने अंगुरेन रस नीकाळने करीन एक हळाव बणायु, ने अंगुरेन खेत मां एक माळु बणायु ने काहनाक किरसाण काजे तेरी वाड़ी साजा मां आपीन, नांबे वाळा देस मां जाती रयु।” ");
INSERT INTO bhi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","पछेन अंगुरेन लागणेन दाहड़ा आया, तीना खेतेन मालीक तेरा एक पावर्‌या काजे साजेल्‌यान चां अंगुरेन वाड़ी मां फळेन वाटु मांगणे मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","बाकुन चे पावर्‌या काजे धरीन ठुक्‌या ने तीनाक ठारलु पछु मकली देदा। ");
INSERT INTO bhi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ने चु खेतेन मालीक अळी दीसरा पावर्‌या काजे मकल्‌यु, ने चे तीना पावर्‌यान मुणको फुड़ देदा, ने तेरो नाव-बद्‌दी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","पछेन अळी दीसरा काजे मकल्‌यु, ने तीनाक चे मार नाख्‌या, तत्‌यार चु अळी बेसका पावर्‌याक मकल्‌यु ने तींद्‌रे मां सी काहनाक काजे ठुक्‌या ने काहनाक काजे मार नाख्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","अळतेन एकुत रय रवलु ने चु तेरु लाटेक्‌लु पुर्‌यु हतलु; अतरा मां तीनाक बी तींद्‌रे धड़े ज सुचीन मकल्‌यु की मारा पुर्‌यान आव-भाव करसे करीन। ");
INSERT INTO bhi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","बाकुन चे साजेल्‌या आपसात वात कर्‌या, जु ते तीना खेतेन हकदार छे, चालु हीना काजे बी मार नाख्‌ता तत्‌यार जी धन दवलत आपणी हय जासे ");
INSERT INTO bhi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ने चे तीनाक धरीन मार नाख्‌या ने अंगुरेन वाड़ी मां सी बाहार नाख देदा। ");
INSERT INTO bhi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“तेरेमां अंगुरेन वाड़ीन मालीक काय करसे?” चु आवीन तीनु साजेल्‌या काजे मार नाखसे ने अंगुरेन वाड़ी दीसरा काजे आप देसे। ");
INSERT INTO bhi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","काय तुहुं हाल लगुन चुखला सास्‌तुर मां नी भण्‌या काय? तीना दगड़ा काजे खास मीस्‌तर्‌या फालतु समजीन बाहार नीकाळ देदा, बाकुन हयुत दगड़ु खास दगड़ु बण गुयु; ");
INSERT INTO bhi_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ज ते मालीक भणी सी हयो; ने ज ते हामरी नींगा मां बेसकु वारु छे! ");
INSERT INTO bhi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","तत्‌यार चे ईसुक धराड़ने हींडी रवला; काहाकी चे समजी गुयला की जु हामरी नाव-बद्‌दी मां जु दाखलु कह्‌लु छे। बाकुन चे माणसे सी बीहेतेला ने ईसु काजे छुड़ीन जाती र्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","तत्‌यार यरुसलेम वाळा डाहला पुजारा ने यहुदी नीयमेन मास्‌तर्‌या ने डाहला, थुड़ाक फरीसी माणसे ने हेरोदेन पाल्‌टी मायन थुड़ाक काजे ईसु धड़े मकल्‌यु, काहाकी तीनाक सवाल पुछीन तीनाक वात मां रुक देय। ");
INSERT INTO bhi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","चे आवीन ईसुक कह्‌या, “ए मास्‌तर हामु जाणजे की तु छाचलु छे, ने कुयन फीकुर नी करे, काहाकी तु माणसेन मुंहडा देखीन वात नी करे, बाकुन भगवानेन वाट संय देखाड़े। ती बताड़ रोमी राजा काजे फाळु आपणु वारु छे की नी छे? हामु फाळु आपजे की नी आपजे?” ");
INSERT INTO bhi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","तींद्‌रा ढंगड़ा जाणीन ईसु तीनुक कह्‌यु, “मेसेक काहा पारखणे बाजी र्‌या? एक चांदीन सीक्‌कु मारे धड़े लावु, ने मे तीना रुप्‌याक देखीस ने तुहुंक बताड़ीस।” ");
INSERT INTO bhi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ने चे एक रुप्‌यु लावीन ईसुक आप्‌या, “ने ईसु तीनुक सीक्‌कु देखाड़ीन कह्‌यु, “सीक्‌का पर कुणीन नाव ने छाप छे?” चे कह्‌या रोमी राजान। ");
INSERT INTO bhi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ईसु तीनुक कह्‌यु, “ज केसर राजान छे, च केसर राजा काजे आपु ज भगवानेन छे, च हक भगवान काजे आपु।” ने चे तेरी वात सामळीन बेसका देखतात रय गुया। ");
INSERT INTO bhi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","पछेन थुड़ाक सदुकी, कहें की माणसे मरलाम सी पछा जीवता नी हवे, चे ईसु धड़े आवीन पुछ्‌या, ");
INSERT INTO bhi_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ए मास्‌तर, मुसु हामरे वाटे असु नीयम लिखलु छे की, कदी काहनाक ने भायन अवल्‌यात नी हवी ने मर जाय, ने चां तेरु भायस रांडायली बायर साते ईयाव करीन आपसान भायस वाटे अवल्‌यात पयदा करनु चाहे। ");
INSERT INTO bhi_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","एक कावा असो हयो; सात भायस हतला, मट्‌लु भायस ईयाव करीन अवल्‌यात पाखुर मर गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","तत्‌यार दीसरु भायस तीनी रांडायली बायर साते ईयाव कर लेदु ने चु बी अवल्‌यात पाखुर मर गुयु। ने असुत तीसरु भायस बी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","असा करीन सातु भायस असात तेरे साते ईयाव कर्‌या, ने अवल्‌यात पाखुर मर गुया। पछेन आकरी कावा ची रांडायली बायर बी मर गुय। ");
INSERT INTO bhi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","अळतेन चे आखा मरीन पछा जीवता हवसे तत्‌यार ची कुणीन बायर कवाय्‌से? काहाकी ची ते सातु भायसेन लाडी बन्‌ली हतली।” ");
INSERT INTO bhi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ईसु तीनुक जपाप देदु, “काय तुहुं असा करीन भुल मां पड़ र्‌या की तुहुं नीते भगवानेन लिखली चुखला सास्‌तुर काजे जाणु नीते भगवानेन ताकत काजे नी उळखु। ");
INSERT INTO bhi_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","काहाकी जत्‌यार मरला माणसे पछा जीवता हवसे, तत्‌यार तींद्‌रेम ईयाव नी हवे, सरग मां सरग वाळान काहवाळ्‌या तसा रवसे। ");
INSERT INTO bhi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","मरलान पछा जीव उठणेन बारामां काय तुहुं मुसान किताप मां काटाळा झाड़कान बारामां लिखलो हतलो च नी भण्‌या काय, चां भगवान मुसा काजे कह्‌लु की, मे अब्‌राहमेन भगवान ने इसाकेन भगवान ने याकुपेन भगवान छे? ");
INSERT INTO bhi_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","भगवान मरलान नी, जीवतान भगवान छे; तुहुं ते मट्‌ली भुल मां पड़ी र्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","यहुदी नीयमेन मास्‌तर्‌या मां सी एक आयु ने तीनु काजे वीच्‌यार करतेलान सामळ्‌यु ने असु देख्‌यु की, ईसु सदुकी काजे वारु ढंग सी जपाप देदु, तत्‌यार नीयमेन मास्‌तर्‌यु ईसु धड़े आय्‌न पुछ्‌यु की, “आखा मां सी मट्‌ली हुकुम काहनी छे?” ");
INSERT INTO bhi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ईसु तीनाक कह्‌यु, आखा हुकुम मां सी ज हुकुम मटलो छे, ए ईस्‌रायल, सामळु! आपणु मालीक भगवान एकुत मालीक छे। ");
INSERT INTO bhi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ने तु आपसा मालीक भगवान सी तारा आखा मन सी, ने तारा जीव सी ने तारी आखी अक्‌कल सी, ने तारी आखी ताकत सी परम कर। ");
INSERT INTO bhi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ने दीसरु हुकुम असु छे, की तुहुं तुंद्‌रे आड़े-धड़े रहणे वाळा सी तारेन तसु परम कर। दीसरा हुकुम अळी ईनु दुय हुकुम सी मटी नी हय। ");
INSERT INTO bhi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","चे यहुदी नीयमेन मास्‌तर्‌या ईसु काजे कह्‌या, “ए मास्‌तर! जे आखो हुकुम संय छे। तु छाचलीन कह्‌यु, की मालीक अतरुत भगवान छे, ने तीनाक छुड़ीन कुय भगवान नी हय। ");
INSERT INTO bhi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ने तीनाक आखा मन सी ने आखी अक्‌कल सी, ने आखा जीव, ने आखी ताकुतेन साते आपसान भगवान सी परम राख्‌जी, जे हुकुम, आखा काय बी जनवार्‌या काजे भगवान अगळ चड़ावणे सी ने अळी काहींग बादा चड़ावणे सी जादा वारु छे।” ");
INSERT INTO bhi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","जत्‌यार ईसु देख्‌यु की चु समजीन जपाप देदु, ती ईसु तीनाक कह्‌यु, “तु भगवानेन राज सी छेटे नी हय।” ने अळतेन ईसु काजे पारखणे करीन कुयन बी पुछणेन हिम्‌मत नी आय। ");
INSERT INTO bhi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","पछेन ईसु मंदीर मां सीकाड़तु जाय्‌न असु पुछ्‌यु, यहुदी नीयमेन मास्‌तर्‌या काहा कहें की मसी दावुदेन अवल्‌यात छे? ");
INSERT INTO bhi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","दावुद आपसुत चुखली-आत्‌मा सी भरायन कह्‌लु, की मालीक, मारा मालीक मसी सी कह्‌यु, तु मारे जेवड़्‌ये आंगे बठ, जत्‌यार लग की मे तारा वेरी काजे, तारा पाय तळे नी कर दम। ");
INSERT INTO bhi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","दावुद ते आपसुत मसी काजे मालीक कहें पछेन मसी दावुदेन अवल्‌यात कसु हय सक्‌से? ने ईसुन जी वात, माणसेन मट्‌लु टुळु खुस हय्‌न सामळी रवला। ");
INSERT INTO bhi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","चु सीकाड़तु जाय्‌न कह्‌यु, “यहुदी नीयमेन मास्‌तर्‌या सी चेतीन रवु, चे ते पाय मां सी नांबला पुथल्‌या पेरीन फीरे, ने हाट मां, वारु छे की, पुछीन तींद्‌री आव-भाव करनु पटे। ");
INSERT INTO bhi_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ने तींद्‌रा भक्‌तीन घर मां खास जागा पर बसणु ने तीहवार मां पाहनत्‌यान तसा खास जागा मां बठणु वारु गमे। ");
INSERT INTO bhi_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","चे रांडायला बायरान घर धुकु दीन तींद्‌रा धन काजे ठगीन हापकी लेय, ने दीसरा काजे देखाड़ने करीन बेसकी वार दुवा करता रवे। बाकुन तीनु माणसे काजे डंड जादा जड़से।” ");
INSERT INTO bhi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ईसु मंदीरेन दान पेटीन सांबु बठीन देखी रवलु, की दान पेटी मां कसा पयस्‌या भर र्‌या, ने बेसका लकपती पेटी मां बेसका पयस्‌या नाख्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","अतरा मां एक गरीब रांडायली बायर दुय टका दान करी, तेरी कीमत बेसकी कम हतली। ");
INSERT INTO bhi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","तत्‌यार ईसु तेरा चेला काजे धड़े बुलायन तींद्‌रे सी कह्‌यु, “मे छाचलीन कहं की, मंदीरेन पेटी मां दान करने वाळा सी, जी गरीब रांडायली बायर आखा सी जादा दान करली छे। ");
INSERT INTO bhi_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","काहाकी आखा तींद्‌रा माल धन मां सी दान कर्‌या, बाकुन जी रांडायली बायर गरीब हय्‌न बी आपसीन आखो कमायलो धन ने जीवन दान कर देदी।” ");
INSERT INTO bhi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","जत्‌यार ईसु मंदीर मां सी नीकळ्‌यु ती चां एक चेलु कह्‌यु, “ए मास्‌तर, देख, कतरा वारु दगड़ा छे, ने कतरा वारु बंगला छे!” ");
INSERT INTO bhi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ईसु तीनाक कह्‌यु, “तु ते ईना मटला बंगला काजे देख र्‌यु ने घाबराय गुयु। बाकुन जे आखा दगड़ा उदार नाखसे; जां लग की ईना जागा पर दगड़ा पर दगड़ु बी नी बचे, ज की हेटु नी उराटी देय।” ");
INSERT INTO bhi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","जत्‌यार ईसु जेतुन झाड़कान बयड़ा पर मंदीरेन अगळ बठी रवलु, ती पतरस ने याकुप ने युहन्‌‌‌नु ने अळी अन्‌दीरीयास छेटास जाय्‌न पुछ्‌या ");
INSERT INTO bhi_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“हामुक बताड़ की जी वात की हवसे? ने जत्‌यार जी आखी वात पुरी हवणे पर रवसे, ने तीना दाहड़ान सहलाणी काय रवसे।” ");
INSERT INTO bhi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ईसु तीनुक कह्‌णे बाजी गुयु, चेतीन रवु की; काहनुक तुहुंक भटकाड़ी नी देय। ");
INSERT INTO bhi_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","बेसका मारो नाव लीन कवसे, मे मसी छे, ने चे बेसका माणसे काजे भटकाड़ी देसे। ");
INSERT INTO bhi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","जत्‌यार तुहुं लड़ायन ने झगड़ान हुकवाय सामळु ती घाबरायु घुण, काहाकी असो ते हवण्‌यो छे, बाकुन हेरो मतलब ज हय की हय आकरी आय गुय। ");
INSERT INTO bhi_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","काहाकी एक देसेन माणसे दीसरा देसेन माणसे पर, ने एक राज्‌येन माणसे दीसरा राज्‌येन माणसे भीणी लड़ायसे ने चड़ाव करसे। जां-चां काळ पड़से। ने जां-चां धरती हालसे ने फाट जासे। जी दुखेन आवणे ने हवणेन सुरुवातुत रवसे। ");
INSERT INTO bhi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","बाकुन तुहुं आपसान बारामां चेतीन रवु; काहाकी माणसे तुहुं काजे धरसे ने मटला पंचुन अगळ ली जासे; ने तींद्‌रा भक्‌तीन घर मां तुहुं काजे ली जाय्‌न ठुकसे; ने मारा नाव सी राजा ने राज करन्‌या अगळ उबा करसे। काहाकी तुहुं मारा गवा बण जाय ने तींद्‌रे अगळ मारी वारलु खबर सामळावणेन मुखु रवसे। ");
INSERT INTO bhi_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ने आकरी हवणे सी पेहेल, खुस-खबरेन परचार आखा माणसे मां हवसे ने हवसे। ");
INSERT INTO bhi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","जत्‌यार चे तुहुंक पंचु अगळ ली जासे, चां पेहेल सी जी फीकुर घुण करु, की हामु काय कवसुन, बाकुन ज काय तुहुंक कह्‌णु छे तीनी टेम बताड़ी देसे चत कह्‌जु; काहाकी बुलने वाळा तुहुं नी हय, बाकुन चुखली-आत्‌मा रवसे। ");
INSERT INTO bhi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","तीनु दाहड़ा मां भायस तेरा भाय काजे, ने बास तेरा पुर्‌या-पारी काजे मारने करीन धराय देसे, ने पुर्‌या पुरे हेरा आयस बासेन वेला नी हवे ने तीनुक माराड़ देसे। ");
INSERT INTO bhi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ने तुहुं मारा नाव पर भुरसु करी र्‌या करीन आखा माणसे तुंद्‌रे सी नाव-बद्‌दी करसे। बाकुन ज कुय मरता लग मार पर भुरसु करसे, तीनुक छुटकारु जड़से। ");
INSERT INTO bhi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","जत्‌यार तुहुं तीनी उजाड़ने वाळी नी गमे तसली चीज ने काम काजे देखीन जाहां च हवणु नी चाहजे ने चां तुहुं देख्‌सु भन्‌ने वाळा समज लेवु तत्‌यार जे यहुदीया मां छे चे बयड़ा मां ढास जाय। ");
INSERT INTO bhi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ज घरेन छत पर हय ती, चु फालतु टेम काजे मां खुवे ने तेरा घर मां सी काय बी समान ली जाणे करीन नेचु घुण उतरे। ");
INSERT INTO bhi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ने जे खेतेम हय, चु तेरा पुथल्‌या लेणे करीन पछु नी आवणु चाहे। ");
INSERT INTO bhi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","तीनु दाहड़ा मां बायरा भारास हसे, ने काहनीक धड़े नानला पुर्‌या हसे, ती तींद्‌रे वाटे ढास्‌णु बेसको काठो रवसे। ");
INSERT INTO bhi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ने भगवान सी दुवा करता रहु, की असो सींगेन दाहड़ा मां नी हवणु चाहे। ");
INSERT INTO bhi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","काहाकी तीनु दाहड़ा मां असो दुख हवसे की च धरती बन्‌ली ती सी ने ज काय भगवान बणायु ती सी हय लग नी हयो ने च कदी नी हवसे। ");
INSERT INTO bhi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","कदी मालीक तीनु दाहड़ा काजे नी घटाड़तु ती कुय बी नी बचतो बाकुन मालीक पर भुरसु करने वाळा नेवाड़्‌ला माणसेन वजे सी तीनु दाहड़ा काजे घटायु। ");
INSERT INTO bhi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","तीनु दाहड़ा मां कदी काहनुक तुंद्‌रे सी कवे देखु मसी जां छे, नीते, देखु वां छे कवे ती तींद्‌रे पर भुरसु घुण करु; ");
INSERT INTO bhi_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","काहाकी लुच्‌चा मसी ने लुच्‌चा अघली वात बताड़न्‌या आवसे ने चे कवसे मे मसी छे ने चे सहलाणी ने कदी देख्‌या नी च काम देखाड़से ने कदी हय सके ती भुरसु करने वाळा नेवाड़्‌ला माणसे काजे बी भटकाड़नेन कुसीत करसे। ");
INSERT INTO bhi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","बाकुन तुहुं चेतीन रहु! मे तुहुं काजे आखी वात पेहेल सी बताड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“तीनु दाहड़ा मां तीना दुखेन पछे दाहड़ु डुब जासे ने आंदारो हय जासे, ने चांद वीजाळो नी देय, ");
INSERT INTO bhi_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ने सरग मां सी तारा पड़ने बाजी जासे ने सरगेन आखी ताकत हालने बाजी जासे। ");
INSERT INTO bhi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","तत्‌यार माणसे माणसेन पुर्‌या काजे मट्‌ली ताकत ने सेक-सींगार साते आदळा मां आवतेला देखसे। ");
INSERT INTO bhi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","तीना टेम मां चु तेरा सरग वाळा काहवाळ्‌या काजे मकलीन धरतीन चार खुणा मां सी आपसा नेवाड़्‌ला माणसे काजे भेळा करसे।” ");
INSERT INTO bhi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“अंजीरेन झाड़का सी जु दाखलु सीकु: जत्‌यार तेरी डाळ मां सी नवली नीळ्‌ळी डाळी ने पान्‌टा नीकळने बाजी जाय, ती तुहुं जाणी जावु की उन्‌ढाळान दाहड़ा आवणे वाळा छे। ");
INSERT INTO bhi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","असात जत्‌यार तुहुं ईनी वात काजे हवतेलान देखसु, ती जाण लेसु की आवणे वाळी टेम धड़ेत छे, मतलब बारना मात छे। ");
INSERT INTO bhi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","मे तुंद्‌रे सी छाचलीन कहं की जत्‌यार लग जी आखी वात पुरी नी हवे चां लग ईनी पीड़ीन माणसे मरे नी। ");
INSERT INTO bhi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","सरग ने धरती टळ हय जासे, बाकुन मारे बुले कदी नी टळे। ");
INSERT INTO bhi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“दाहड़ा नीते टेम कत्‌यार आवसे तेरे बारामां कुय काजे मालुम, नी हय, नीते सरग वाळा काहवाळ्‌या काजे नीते; पुर्‌या काजे, बाकुन भगवान बास अतरुत जाणे। ");
INSERT INTO bhi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","देखु जागता रहु ने तीयार रहु काहाकी तुहुं नी जाणु की ची टेम कत्‌यार आवसे। ");
INSERT INTO bhi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ज तीना माणसेन तसों छे, चु दीसरा तेरा घरेन काम छुड़ीन नाबे फीरने जाय, ने आपसान पावर्‌या काजे जपापदारी आपे, ने आखा काजे काम बताड़ीन जाय, ने झपलान राखवाळ्‌या काजे जागली करजी करीन कहें। ");
INSERT INTO bhi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","तेरेमां तुहुं बी जागता रहु, काहाकी तुहुं नी जाणु की घरेन मालीक कत्‌यार आवसे सांतु की, आदी राते, की कुकड़ा वासणीक की, दाहड़ु उंगे तत्‌यार। ");
INSERT INTO bhi_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","असो नी हय जाय की चु उचकान आय लागे ने तुहुं सुवतेला तीनाक देखाव पड़ु। ");
INSERT INTO bhi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ने ज मे तुंद्‌रे सी कय र्‌यु चीत वात आखा सी कहं की: जागता रहु।” ");
INSERT INTO bhi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","दुय दाहड़ा मां फसहन तीहवार ने खमीरी पाखुर रुटान तीहवार आवणे वाळु हतलु। मंदीरेन डाहला पुजारा ने यहुदी नीयमेन मास्‌तर्‌या ईसु काजे ठगीन धरनु ने मारनेन वीच्‌यार करने करीन भेळा हया। ");
INSERT INTO bhi_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","बाकुन चे कह्‌तेला की, तीहवारेन दाहड़े असा नी करजे, “नीते असो नी हय जाय की माणसे मां दंगु हय जाय।” ");
INSERT INTO bhi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","जत्‌यार ईसु बेतन्‌या मां हतलु तत्‌यार चां एक माणुस सीमोन नावेन हतलु ने चु कुड़ायलु हतलु, तेरे घर मां ईसु रुटा खाणे बठी रवलु, तत्‌यार एक बायर वारलु गुळवळा दगड़ा मां महंगलो पीवर गंदायण्‌यो तेल लीन आय्‌न सीसीन ढाकणो उघाड़ीन ईसुन मुणका पर रेचवी देदी। ");
INSERT INTO bhi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","बाकुन थुड़ाक माणसे रीसवायन एक दीसरा काजे कह्‌णे बाजी गुया, जी ईना ईत्‌तर तेल काजे काहा रद कर देदी? ");
INSERT INTO bhi_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","काहाकी ईत्‌तर तेल एक सालेन दाहड़कीन पयस्‌या सी बी महंगो वेचाय जातो, ने चे तेरु वाक नीकाळीन लड़ने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","बाकुन ईसु कह्‌यु, “हीनीक काहा वेला पाड़ी र्‌या; रहणी देवु? हय ते मारे वाटे वारलाम-वारलु काम करली छे। ");
INSERT INTO bhi_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","काहाकी गरीब माणसे ते तुंद्‌रे पुठ्‌ये जलम रवसे, ने तुहुं जत्‌यार चाहु, तत्‌यार तींद्‌री भलाय कर सक्‌सु; बाकुन मे तुंद्‌रे पुठ्‌ये जलम नी रव। ");
INSERT INTO bhi_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","हयी ते ज करनु हतलो चत करी, ची मारा डील पर मेसे मारनेन पेहेल सी तेल रेचवीन मेसेक अघे करनेन तीयारी करली छे। ");
INSERT INTO bhi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","मे तुंद्‌रे सी छाचलीन कहं की आखी कळी मां जां-जां खुस-खबरेन परचार हवसे चां-चां माणसे हेरा ईना कामेन बी हेर करने करीन बताड़से।” ");
INSERT INTO bhi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","तत्‌यार यहुदा ईस्‌करीयोती ईसुन बारे चेला मायन एक हतलु, जु चेलु मंदीरेन डाहला पुजारान चां जाय्‌न कह्‌यु, काहाकी ईसु काजे तींद्‌रे हाते धराड़ी दम। ");
INSERT INTO bhi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","चे तेरी वात सामळीन बेसका खुस हय गुया, ने चे तेरे बदले पयस्‌या आपणेन वायदु कर लेदा। ने चे ईसु काजे धराड़नेन मुखु हेरने बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","खमीरी पाखुर रुटा बणावणेन तीहवारेन पेहेले दाहड़े तीना तीहवारेन गाडरो मारीन बादा चड़ावतेला, चां ईसुन चेला ईसु सी पुछ्‌या, “तु काहना जागा पर फसहन खाणो खाणे करीन कय रयु? चां हामु जाय्‌न फसहन खाणो तीयारी करसुन?” ");
INSERT INTO bhi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","तत्‌यार ईसु तेरा चेला मायन दुय जणा काजे असु कय्‌न मकल्‌यु की, “सहर मां जावु, ने एक माणुस ठाहरा मां पाणी भरीन जासे चु तुहुं काजे भेळु हवसे, तत्‌यार तेरे पुठ्‌ये जाजु। ");
INSERT INTO bhi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ने चु तीना घर मां जाय, तीना घरेन मालीक काजे कह्‌जु, ‘मास्‌तर असु कय रयु, की खाणो खाणेन मारु कमरु कां छे, चां मे मारा चेला पुठ्‌ये फसहन खाणो खाय सके?’ ");
INSERT INTO bhi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","तत्‌यार चु तुहुंक घरेन उपर्‌नी मंजीलेन कमरा पर वारु जमाड़ीन ने आथरीन तीयार करलो, एक मट्‌लु कमरु देखाड़से। चां तुहुं आपणे वाटे खाणो तीयार करजु।” ");
INSERT INTO bhi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ने चे दुय चेला सहर मां गुया, ने जसु चु तीनुक कह्‌लु हतलु, तीनुक तसत जड़्‌यो, ने चे फसहन खाणो तीयारी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","जत्‌यार सांतो हयो, ती ईसु तेरा बारे चेला पुठ्‌ये आयु। ");
INSERT INTO bhi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","जत्‌यार चे खाणे बठी रवला, ती ईसु कह्‌यु, “मे तुंद्‌रे सी छाचलीन कहं, तुंद्‌रे मायन एक जणु छे, चु मार साते खाणे बठी रयु, चु मेसेक धराय देसे।” ");
INSERT INTO bhi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","चे दुखी हय गुया ने तीनाक पुछ्‌णे बाजी गुया, ने अळतेन चे चेत पुछ्‌णे लाग्‌या की, “काय चु मेते नी छे?” ");
INSERT INTO bhi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ईसु तीनुक जपाप आप्‌यु, “बारे मायन एक जणु छे, चु मारे साते एकुत तळी मां खाणे बाजी र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","काहाकी माणसेन पुर्‌यु ते तसुत मरसे, जसों तेरा बारामां लिखलो छे, बाकुन तीना माणुस पर मोटु दुख काहाकी तेरे वजे सी माणसेन पुर्‌यु धराय जाय। कदी चु माणुस पयदा नी हवतु, ती तेरे वाटे भलो रहतो।” ");
INSERT INTO bhi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","जत्‌यार चे खाणे बाजी रवला, ईसु हात मां रुटु लेदु ने रुटु वाटे भगवान सी कह्‌यु की, तु बेसकु वारु छे, ने रुटु भांजीन तेरा चेला काजे आपतु जाय्‌न कह्‌यु, “लेवु, जु रुटु मारु डील छे।” ");
INSERT INTO bhi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","पछेन पीयालु लेदु ने तेरे वाटे भगवान सी कह्‌यु, तु बेसकु वारु छे, कय्‌न चेला काजे आप्‌यु, ने चे आखा तीना मां सी पीदा। ");
INSERT INTO bhi_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ने ईसु तीनुक कह्‌यु, जु पीयालु, मारा लुही मां बुली करला नवला कायदान सहलाणी छे, ज लुही तुंद्‌रे आखा वाटे उंह्‌लो छे। ");
INSERT INTO bhi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","मे तुंद्‌रे सी छाचलीन कहं, की मे जु रस तीनु दाहड़ा लग कदी नी पीयो जत्‌यार लग भगवानेन राज मां नवला अंगुरेन रस नी पीलम। ");
INSERT INTO bhi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","तत्‌यार चे भगवानेन भजन गाया ने जेतुन झाड़कान बयड़ा पर गुया। ");
INSERT INTO bhi_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","तत्‌यार वाटे ईसु तीनुक कह्‌यु, तुहुं आखा मेसेक छुड़ी देसु, काहाकी लिखलो छे; मे गुवाळ्‌या काजे मार नाखीस, “ने गाडरा खळन्‌या-वळन्‌या हय जासे। ");
INSERT INTO bhi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","बाकुन मे पछु जीव उठीन तुंद्‌रे सी पेहेल गलील मां पुगी जायस।” ");
INSERT INTO bhi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","पतरस ईसुक कह्‌यु, “कदी आखा तुसे छुड़े ते छुड़े, बाकुन मे तुसेक कदी नी छुड़ो।” ");
INSERT INTO bhi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ईसु पतरस काजे कह्‌यु, “मे तुसेक छाचलीन कहं, की तु आज रातेत दुय कावा कुकड़ा वासणेन पेहेल, तीन कावा मेसेक नीकारु करसी।” ");
INSERT INTO bhi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","बाकुन पतरस अळी हिम्‌मत करीन कह्‌यु, “कदी मेसेक तारे पुठ्‌ये मरनु बी पड़े, तेबी मे तारु नीकारु नी करो!” ने दीसरा चेला बी असात कह्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","पछेन ईसु गतसमनी नावेन एक वाड़ी मां आयु ने चु तेरा चेला सी कह्‌यु, “मे दुवा करीन आवो, तत्‌यार लग तुहुं जांत बठजु।” ");
INSERT INTO bhi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ने चु पतरस ने याकुप ने अळी युहन्‌ना काजे तेरे पुठ्‌ये ली गुयु; ने चां चु बेसकु दुखी हय्‌न लतपत हय रवलु। ");
INSERT INTO bhi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ने तीनुक कह्‌यु, “मारो मन बेसको दुखी छे; ने अतरो बी की मारु जीव नीकळने वाळु छे, तेरेसी तुहुं जांहात रवु, ने चेतीन रहु।” ");
INSERT INTO bhi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","पछेन चु ईतरुक अघु गुयु, ने धरती भीणी अळीन दुवा करने लाग्‌यु की कदी हय सके ती जी दुख मार पर सी टळ जाय। ");
INSERT INTO bhi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ने दुवा कर्‌यु की, “तु मारु बास छे, तु आखो काय कर सक्‌सी; तेरेमां ईना दुखेन पीयाला काजे मार धड़े सी छेटु कर ले; तेबी मे चाहो तसों नी बाकुन तु चाहे तसों हवणी दे।” ");
INSERT INTO bhi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","तत्‌यार ईसु तीनु चेला धड़े पछु आयु, ने तीनुक सुवतेला देखीन पतरस सी कह्‌यु, “ए सीमोन, तु सुवणे बाजी रयु? काय तु जाराक वार लग जागी नी सक्‌तु?” ");
INSERT INTO bhi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“जागता, ने दुवा करता रहु की तुहुं पारख मां नी पड़ु। आत्‌मा ते तीयार छे, बाकुन डील कमजुर छे।” ");
INSERT INTO bhi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","चु अळी पछु जाती र्‌यु ने अळी तसुत दुवा कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ने अळी पछु आय्‌न तीनु तीन जणा काजे सुवतेला देख्‌यु, काहाकी चे बेसका नीदरायला हतला; ने चे ईसु काजे काय कह्‌णु ने काय नी? ची वात तीनु काजे समज मां नी आय। ");
INSERT INTO bhi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","पछेन तीसरी कावा बी ईसु पछु तींद्‌रे धड़े आयु, “चां ईसु तीनुक कह्‌यु काय तुहुं हय लग सुवता ने आराम करता रवसु, बस अतरोत! टेम आय्‌जो, देखु माणसेन पुर्‌यु पापी माणसेन हातेम धराय्‌णे बाजी र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","उठु, आपणु जाता, ने देखु, जां एक मेसेक धराड़ने वाळु माणुस धड़ेत छे!” ");
INSERT INTO bhi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ईसु आपसाक धराड़ने वाळान बारामां असु कहणेत बाजी रवलु ने तीनीत टेमे यहुदा ईस्‌करीयोती चु बारे चेला मायन एक हतलु। तेरे भेळा बेसका माणसे आया चे तलवार्‌या ने डेंगा ली रवला, तीनु काजे मंदीरेन डाहला पुजारा ने यहुदी नीयमेन मास्‌तर्‌या ने मुख्‌या बी हतला चे मकल्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ईसु काजे धराड़ने वाळु यहुदा तीनुक जी सहलाणी आपलु की, “मे तेरे गुळु दीस हयुत ईसु रवसे, ने तीनाक धरीन सीपायड़ान सात मां समाळीन लीजाजु।” ");
INSERT INTO bhi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","यहुदा जसुत ईसु धड़े आवीन कह्‌यु, “ए मास्‌तर!” ने तेरे गुळु देदु। ");
INSERT INTO bhi_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ने तत्‌यारुत चे ईसु काजे धर्‌या ने बांद लेदा। ");
INSERT INTO bhi_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","बाकुन ईसुन एक चेलु चां उबु हय रवलु चु मीयान मां सी तलवार नीकाळीन आखान डाहला पुजारान पावर्‌यान कान्‌टु तुड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ईसु तीनुक कह्‌यु, “काय तुहुं डाकु ने चुट्‌टु समजीन मारे भीणी तलवार्‌या ने डेंगा लीन मेसेक धरने आय र्‌या? ");
INSERT INTO bhi_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","मे दाहड़ीन मंदीर मां तुंद्‌रे साते रय्‌न सीकाड़्‌या करतेलु, ने तत्‌यार तुहुं मेसेक नी धर्‌या। बाकुन चुखला सास्‌तुर मां लिखली छे, ची वात पुरी हवे।” ");
INSERT INTO bhi_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ने अळतेन आखा चेला ईसु काजे छुड़ीन ढासी पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ने चां एक जुवान्‌यु तेरा डील पर लायलुनेन साल पांगरीन ईसु पछळ-पछळ जातलु। ने ईसु काजे लीजाण्‌या माणसे तीनाक बी धरनेन कुसीस कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","बाकुन चु साल तींद्‌रे हात मां रहणे दीन नांगरलुत ढास पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","तत्‌यार चे ईसुक डाहला पुजारान मुखीन चां ली गुया। ने दीसरा डाहला पुजारा, ने मुख्‌या, ने यहुदी नीयमेन मास्‌तर्‌या बी चां भेळा हय गुया। ");
INSERT INTO bhi_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पतरस छेटु रय्‌न तेरे पछळ-पछळ आखान डाहला पुजारान आंगणा मां गुयु, ने सीपायड़ा साते बठीन आकठा मां तापणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","डाहला पुजारा ने यहुदीन आखा बसक वाळा पंचु, ईसु काजे मारने करीन गवा पुरावु हेरने बाजी रवला, बाकुन तीनुक गवा पुरावु नी जड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","काहाकी बेसका माणसे ईसु वेला नी हया, ने झुटी गवाय देदा, बाकुन तींद्‌री गवाय एक जसी नी हतली। ");
INSERT INTO bhi_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","तत्‌यार ईतराक माणसे उठीन ईसु वेला नी हया ने झुटी गवाय देदा, ");
INSERT INTO bhi_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“हामु ईना ईसु काजे कवतेलान सामेळला छे की, माणसेन हातेन बणावला मंदीर काजे उदार दीस, ने तीन दाहड़ा मां दीसरु मंदीर बणाय दीस चु माणसेन हाते नी बन्‌लु हय।” ");
INSERT INTO bhi_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","बाकुन चां बी तींद्‌री गवाय एक बी मेळ नी खादी। ");
INSERT INTO bhi_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","तत्‌यार आखान डाहलु पुजारु ईचमां उबु रय्‌न ईसु काजे पुछ्‌यु “जे माणसे तारे वीरुद मां काहनी बी गवाय दी र्‌या, तेरु जपाप तु काहनी आपतु?” ");
INSERT INTO bhi_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","बाकुन तेबी ईसु हुगुत हय रयु, ने काय बी जपाप नी आप्‌यु, डाहलु पुजारु अळी दीसरी कावा अळी तीनाक पुछ्‌यु, “काय तु परमवाळान वारलु पुर्‌यु मसी छे?” ");
INSERT INTO bhi_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“ईसु कह्‌यु,” हव मे छे, “ने तुहुं माणसेन पुर्‌या काजे आखा सी मटा ताकतवाळान जेवड़्‌ये आंगे बठलु ने सरगेन आदळा पुठ्‌ये आवतेलान देखसु!” ");
INSERT INTO bhi_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","तत्‌यार आखान डाहलु पुजारु आपसान पेहेरला पुथल्‌या फाड़ीन कह्‌यु, “हय हामु काजे अळी गवा पुरावु नी चाहजे। ");
INSERT INTO bhi_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","तुहुं नाव-बद्‌दी करता सामळी लेदला छे, हय तुंद्‌रु वीच्‌यार काय छे?” चे आखा हेरे वीरुद मां कह्‌या की, हयु गुनाळु छे ने हीना काजे मरनेन डंड आपणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","तत्‌यार तींद्‌रे मायन थुड़ाक तेरे पर थुप्‌णे लाग्‌या, ने तेरो मुंहडो टुपे ने काहनाक मार्‌या ने काहनाक पुछ्‌या की, भगवानेन अघी सी आवणे वाळी वात देखाड़, ने सीपायड़ा तीनाक ली जाय्‌न थापड़ाया। ");
INSERT INTO bhi_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","जत्‌यार पतरस नेचु आंगणा मां हतलु, चां आखान डाहला पुजारान एक पावरनी तेर धड़े आय। ");
INSERT INTO bhi_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ने पतरस काजे आकठा धड़े तापतेला देखीन, ची सुदीत भाळीन कय, “तु बी तीना ईसु नासरी पुठ्‌ये हतलु।” ");
INSERT INTO bhi_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","बाकुन पतरस नीकारु कर्‌यु, “काय जाणु तु काय कय रय, च मेसेक समज मां नी आवतो।” ज कय्‌न चु अळी बारनान फटक्‌या पर गुयु ने; कुकड़ु वास देदु। ");
INSERT INTO bhi_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ची पावरनी पतरस काजे अळी देखीन, चां उबा हय रवला माणसेक कय, “जु माणुस बी तींद्‌रे मायन एक जणु छे।” ");
INSERT INTO bhi_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","बाकुन पतरस अळी दीसरी कावा नीकारु करे। थुड़ीक वार मां अळी चां उबा हय रवला माणसे पतरस काजे कह्‌या, “तु नीकारु नी कर सके, छाचलीन तु तींद्‌रे मायन एक छे, काहाकी तु, गलील वाळु छे।” ");
INSERT INTO bhi_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","तत्‌यार पतरस सगुन खाय्‌न सय कय र्‌यु, “मे तीना माणुस काजे नी जाणो ने जसा तुहुं तेरे बारामां पुछी र्‌या, कदी मे लुच्‌चाय मेल रयु हय ती भगवान मेसे डंड देय।” ");
INSERT INTO bhi_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","तत्‌यार तत्‌यारुत दीसरी कावा कुकड़ु वास देदु। पतरस काजे ईसु कवलु ची हेर आय गुय, “की दुय कावा कुकड़ु वासणे सी पेहेल तु मारो तीन कावा नीकारु करसी।” ने चु हीनी वात काजे हेर करीन रड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","संदारे एगात मंदीरेन डाहला पुजारा ने मुख्‌या ने यहुदी नीयमेन मास्‌तर्‌या ने यहुदीन आखी पंचुन बसक हय ने चे मेळीन वीच्‌यार कर्‌या की ईसु काजे बांदीन पीलातुसेन हात मां सुप देदा। ");
INSERT INTO bhi_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पीलातुस ईसु काजे पुछ्‌यु, “काय तु यहुदी माणसेन राजा छे?” ईसु जपाप आप्‌यु, “असु तुत कय रयु।” ");
INSERT INTO bhi_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","डाहला पुजारा ईसु पर बेसकी वात कय्‌न गुनु लागाड़ी रवला ");
INSERT INTO bhi_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पीलातुस तीनाक अळी पुछ्‌यु, “जे आखा तुसे बेसकी वात कय्‌न गुनु लागाड़ी र्‌या; काय तुसेक जपाप नी आपणु हय!” ");
INSERT INTO bhi_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ईसु अळी बी काय जपाप नी आप्‌यु, अतरामा पीलातुस देखतुत रय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","पीलातुस नावेन एक राज करने वाळु यहुदी गांव मां एक तीहवारेन दाहड़े काहनाक एक केदड़ाक छुड़तेलु, तीनाक हयु चाहे तीना काजे। ");
INSERT INTO bhi_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","एक माणसेन नाव बरअब्‌बा हतलु, ने एक जेल मां बंद हतलु, चु तीनु माणसे पुठ्‌ये हतलु, जे सरकारेन वीरुद मां दंगा करला, ने चे हत्‌या करला। ");
INSERT INTO bhi_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","जत्‌यार माणसेन गड़दी पीलातुसेन चां भेळा हया ने लीलघाय्‌न कह्‌णे लाग्‌या की जसु तु आपणी रीती-रीवाज मां जसु हामरे वाटे करतु आयु तसुत हय बी कर, ");
INSERT INTO bhi_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पीलातुस जपाप आप्‌यु, “काय तुहुं चाहु की मे तुंद्‌रे वाटे यहुदीयान राजा काजे छुड़ दम?” ");
INSERT INTO bhi_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","काहाकी हीनाक पाक्‌को मालुम हतलो की मंदीरेन डाहला पुजारा ईसु काजे कुहराये धराड़ला। ");
INSERT INTO bhi_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","बाकुन डाहला पुजारा माणसे काजे उकसाय्‌न पुछ्‌या, “तुहुं पीलातुस काजे असा कहुं, की तु हामरे वाटे ईसुक नी, बाकुन बरअब्‌बा काजे छुड़ दे।” ");
INSERT INTO bhi_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","पीलातुस तीनु गड़दी काजे अळी पुछ्‌यु, “तीनाक तुहुं यहुदीन राजा कहुं, तेरे साते तुहुं काय चाही र्‌या की मे हेरे साते करो, तुहुं बताड़ु?” ");
INSERT INTO bhi_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","चे पछात आयड़्‌या, “हीनाक कुरुस पर चड़ावु!” ");
INSERT INTO bhi_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पीलातुस तीनुक कह्‌यु, “काहा, हयु काय गुनु करलु छे।” बाकुन चे अळी जुर सी आयड़ीन कह्‌या “हीनाक कुरुस पर चड़ावु!” ");
INSERT INTO bhi_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","तत्‌यार पीलातुस माणसेन गड़दी काजे खुस करने करीन बरअब्‌बा काजे तींद्‌रे वाटे छुड़ देदु, ने ईसु काजे सपाटा देवाड़ीन तीनाक कुरुस पर चड़ावणे करीन तींद्‌रा हात मां सुप देदु। ");
INSERT INTO bhi_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ने सीपायड़ा ईसु काजे तीनी सरकारेन मटला कीलान आंगणा मां ली गुया; ने चे बचला सीपायड़ा काजे बी बुलाय लेदा। ");
INSERT INTO bhi_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","चे ईसु काजे जामण्‌या पुथल्‌या पेराया ने काटान मुड़ गुथीन तेरा मुणका पर मेल देदा। ");
INSERT INTO bhi_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","तत्‌यार चे ईसुन हासी उडाड़्‌या, ने कह्‌या की “ए यहुदीयान राजा तु बेसका दाहड़ा लग जीवे!” ");
INSERT INTO bhi_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ने चे तेरा मुणका पर बुरीन सुटी मेळ्‌या, ने तेरे पर थुपतेला ने चे ढंगा अळीन ईसु काजे आंधणेन ढंगड़ा कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","असा करीन चे ईसुन हासी उड़ावता जाय्‌न वार मुजु ली लेदा; ने पछेन जामण्‌या पुथल्‌या नीकाळ देदा; ने तेरात पुथल्‌या पेरायन, तीनाक कुरुस पर चड़ावणे बाहर ली गुया। ");
INSERT INTO bhi_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","वाटे एक माणुस भेळु हयु तेरो नाव सीमोन हतलु चु सहर सी आवणे बाजी रवलु ने चु चां मायन नीकळ्‌यु ने हीना काजे सीपायड़ा जबरान मां धर्‌या काहाकी ईसुन कुरुस हाकली लेय। चु सीमोन कुरेन गांव वाळु हतलु ने सीकन्‌दर ने रुफुसेन बास हतलु। ");
INSERT INTO bhi_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ने सीपायड़ा ईसु काजे गुलगुता नावेन जागा मां ली जां, तेरो मतलब छे, “माणसेन मुणकान जागु।” ");
INSERT INTO bhi_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","चां चे तीनाक बीगेड़लु अंगुरेन रस पाव्‌णे लाग्‌या बाकुन चु पीणे नी चाहतेलु। ");
INSERT INTO bhi_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","तत्‌यार चे ईसु काजे कुरुस पर चड़ाया ने तेरा पुथल्‌या कुणीक-कुणीक जड़नु चाहे करीन चे चिट्‌ठी नाखीन देख्‌या की कुणीक काय जड़से, ने असा करीन तेरा पुथल्‌या वाट लेदा। ");
INSERT INTO bhi_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ने चे ईसु काजे संदारे नव बजे कुरुस पर चड़ाया। ");
INSERT INTO bhi_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ने तेरे पर जु झुटु गुनान बारामां पट्‌टी पर लिखीन तेरा मुणकान सी उपरुस कुरुस पर ठुक देदा तीनी पट्‌टी पर लिखलो हतलो, “जु यहुदी माणसेन राजु छे।” ");
INSERT INTO bhi_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ने चे ईसुन साते दुय चुट्‌टा काजे बी अलग-अलग कुरुस पर चड़ाया, एक तेरे जेवड़्‌ये आंगे ने एक तेरे डाखर्‌ये आंगे। ");
INSERT INTO bhi_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","असो करीन जी वात खरला सास्‌तुर मां लिखलो हतलो च पुरो हयो की चु पापीन गिन्‌ती मां आवसे। ");
INSERT INTO bhi_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ईसु कुरुस हाकलीन लीजातलु तत्‌यार वाटेन आड़े-धड़ेन माणसे जाणे वाळा मुणको डुलाव्‌ता जाय्‌न ने ईसुन वाक नीकाळता जाय्‌न कह्‌या “हयु! मंदीर काजे उदार्‌ने वाळु ने तीन दाहड़ा मां बणावणे वाळु! ");
INSERT INTO bhi_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","कुरुस पर सी नेचु उतरी आव ने आपसा काजे बचाड़ ले।” ");
INSERT INTO bhi_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","असुत कय्‌न डाहला पुजारा ने यहुदी नीयमेन मास्‌तर्‌या ईसुन हासी उड़ावता जाय्‌न एक दीसरा काजे कह्‌या, “हयु ते दीसरा काजे बचाड़्‌यु ने आपसाक नी बचाड़ सक्‌तु काय? ");
INSERT INTO bhi_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","हयु ईस्‌रायलेन राजु मसी हय ती, कुरुस पर सी उतरीन आवे ती हामु हीनाक देखीन हेरे पर भुरसु करजे!” ने ईसु साते दीसरा आड़े-धड़े दुय काजे कुरुस पर चड़ावला हतला, चे बी तेरी हासी उड़ाव्‌तेला। ");
INSERT INTO bhi_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","खयारली टेमे ईलाका मां आखे दुर आंदारलो छावायलो रयो ने च तीन बजे लग रयो। ");
INSERT INTO bhi_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","दीसु तीन बजे ईसु तत्‌यार मटीत अवाज मां आयड़ीन कह्‌यु, “ईलोई, ईलोई, लमा सबक्‌तनी?” हेरो मलतब छे, “ए मारा भगवान, ए मारा भगवान, तु मेसेक काहा छुड़ देदु?” ");
INSERT INTO bhi_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","जे धड़े उबा हय रवला, तींद्‌रे मायन थुड़ाक ज सामळीन कह्‌या, “सामळु, जु ते एलीयु काजे बुलाय र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ने एक जणु दवड़ीन जाय्‌न पुता काजे बीगड़ला अंगुरेन रस मां बुचळ्‌यु ने पुतो बुरीन सुटीन छेंड्‌ये पर झेलाड़ीन ईसुक चुसाड़्‌यु ने कह्‌यु “हींगा! देखु एलीयु हीनाक उतारने आवे की नी आवे!” ");
INSERT INTO bhi_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","तत्‌यार ईसु जुर सी आयड़ीन तेरु जीव छांड गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ने मंदीरेन पड़दु उपर सी नेचु लग फाटीन अलग-अलग हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","सीपायड़ान एक डाहलु ईसुन कुरुस अगळ उबु हय रवलु, तत्‌यार चु ईसु काजे असु आयड़ीन मरतेला देख्‌यु ती कह्‌यु, “छाचलीन जु माणुस भगवानेन!” पुर्‌यु हतलु। ");
INSERT INTO bhi_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","थुड़ाक बायरा बी छेटे सी देखी रवला, तींद्‌रे मायन मरीयम मगदलनी, जुवान याकुप ने योसेसन माय मरीयम, ने सलोमी हतली। ");
INSERT INTO bhi_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","जत्‌यार ईसु गलील मां हतलु ती जे बायरा तेरी मदत कर तेला। ने चां दीसरा बेसका बायरा बी हतला चे ईसु साते गलील ईलाका सी यरुसलेम मां आवला हतला। ");
INSERT INTO bhi_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","जु दाहड़ु आरामेन दाहड़े सी पेहेल वाळु दाहड़ु हतलु, जु दाहड़ु तीयारीन दाहड़ु रवे, ने सांतो हय गुयलो। ");
INSERT INTO bhi_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","अरीमतीया गांवेन रहणे वाळु युसुफ नावेन एक माणुस आयु, जु यहुदी पंचुन मेहमर हतलु, ने जु भगवानेन राजेन वाट देखी रवलु; जु युसुफ हिम्‌मत करीन पीलातुस धड़े गुयु ने ईसुन धड़ मांग्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","जी वात सामळीन पीलातुस देखतुत रय गुयु, की ईसु अतरु छाटु कसु मर गुयु, ने चु सीपायड़ान डाहला काजे बुलावीन पुछ्‌यु, काय ईसु मरलु बेसकी टेम हय गुय। ");
INSERT INTO bhi_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","तत्‌यार पीलातुस सीपायड़ान डाहलान साहरे ईसुन बारामां आखी वात मालुम कर लेदु, तत्‌यार हेरो धड़ युसुफ काजे आपाड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","तत्‌यार युसुफ लेफड़्‌ला सणेन पुथल्‌या मुल लेदु, ने धड़ काजे उतारीन तीना पुथल्‌या मां बांद लेदु, ने तीनाक मसाण मे गाड़ देदा चां चापर्‌या मां वारु घड़ली मसाण हतली ने चां मट्‌लु दगड़ु लागाड़ीन बुजी देदा। ");
INSERT INTO bhi_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ने मरीयम मगदलनी ने योसेसन माय मरीयम ईसुन धड़ काजे मेक तेला देखी रवली। ");
INSERT INTO bhi_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","जत्‌यार आरामेन दाहड़ु खत्‌तम हय गुयु, ती मरीयम मगदलनी, ने याकुपेन माय मरीयम ने सलोमी, गंदायण्‌यु मसालु ईसुन धड़ पर तेल लागाड़ने करीन मुल लेदी। ");
INSERT INTO bhi_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","हाप्‌तान पेहेले दाहड़े संदारे एगात जत्‌यार दाहड़ु उंग्‌यु, जे बायरा मसाण धड़े गुया ");
INSERT INTO bhi_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ने ची आपसी-आपसी एक दीसरी सी कह्‌तेली की हामरे वाटे दगड़ा काजे मसाणेन बारनाम सी कुण छेटु करसे। ");
INSERT INTO bhi_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","जत्‌यार चे देख्‌या की दगड़ु गबड़ी रवलु चु दगड़ु मट्‌लु हतलु। ");
INSERT INTO bhi_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","मसाणेन मांहे गुय ती चे एक नांबला धवळा पुथल्‌या पेहरला जुवान माणुस काजे जेवड़े आंगे बठी रवलु देख्‌या। ने चे बायरा घाबरायन बीही गुया। ");
INSERT INTO bhi_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","चु तीनुक कह्‌यु, “बीहु मां तुहुं ते ईसु नासरी काजे, तीनाक कुरुस पर चड़ावला चु छे। चु जीव उठ्‌यु। चु जां नी हय जाहां चे मेल्‌ला। ");
INSERT INTO bhi_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","बाकुन हय तुहुं जावु, ने तेरा चेला ने पतरस सी कवजु की चु तुंद्‌रे सी पेहेल गलील जासे। जसु तुहुंक पेहेल कह्‌लु की ईसु गलील ईलाकाम भेळु हवसे।” ");
INSERT INTO bhi_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ज आखो सामळीन चे बायरा बेसका कापता ने घाबरायता जाय्‌न मसाण मां सी ढास पड़्‌या, ने चे कुय सी ईसुन बारामां नी कह्‌या, काहाकी चे बीही गुयला। ");
INSERT INTO bhi_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","हाप्‌तान पेहेले दाहड़े संदारे एगुत ईसु जीवतु हय्‌न पेहेल मरीयम मगदलनी काजे देखाव पड़्‌यु काहाकी हेरेम सी चु सात भुतड़ा नीकाळ्‌ळु। ");
INSERT INTO bhi_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","मरीयम मगदलनी जाय्‌न ईसुन साती दुखी हतला ने रड़ने बाजी रवला। तीनु काजे जाय्‌न कय की ईसु जीवतु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","चे ज सामळ्‌या की ईसु जीवतु हय गुयु ने मरीयम तीनाक देखली छे, तेबी चे भुरसु नी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","अळतेन तीनु चेला मायन दुय जणा गांव भीणी जाणे बाजी रवला जत्‌यार ईसु दुसरुत भातु तीनुक देखाव पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","चे दुय जणा बी दीसरा चेला काजे हीनी वातेन खबर कर्‌या, बाकुन चे तींद्‌रे पर बी भुरसु नी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","पछेन चे ग्‌यारे चेला रुटा खाणे बठी रवला, ती ईसु तीनुक बी देखाव पड़्‌यु, ईसु तींद्‌रु नी भुरसु करनेन ने भुरसु नी करनेन काठो मन हय गुयलो जाणीन ने तीनुक लड़तु जाय्‌न कह्‌यु, “जे मेसेक जीव उठीन बठु हवला देखला, तुहुं तींद्‌री वात पर भुरसु काहा नी कर्‌या।” ");
INSERT INTO bhi_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ने ईसु तीनुक कह्‌यु, “तुहुं आखी कळी मां जावु ने आखा माणसे काजे खुस-खबरेन परचार करु। ");
INSERT INTO bhi_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","जे भुरसु करसे ने बपतीस्‌मा लेसे तींद्‌रुत छुटकारु हवसे, बाकुन जे भुरसु नी करसे तीनाक भगवानेन गुनाळु ठहरावसे। ");
INSERT INTO bhi_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","भुरसु करने वाळान जी सहलाणी रवसे की, चे मारे नाव सी भुतड़ान आत्‌मा काजे नीकाळसे ने नवली-नवली बुली बुलसे। ");
INSERT INTO bhi_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","कदी चे घड़सा धर लेसे ने दवा बी पी लेसे तेबी तीनुक काय बी नुकसाण नी हवे ने चे मांदला पर हात मेकसे ने चे वारु हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","पछेन मालीक ईसु तींद्‌रे साते वात करीन पछेन सरग मां हाकलायन गुयु ने भगवानेन जेवड़्‌ये आंगे बठ गुयु। ");
INSERT INTO bhi_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ने ईसुन चेला जागे-जागे जाय्‌न परचार कर्‌या ने मालीक तींद्‌रे साते काम करतु रयु ने मटा काम सी।");
INSERT INTO bhi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","बेसका माणसे: ईनी वीतली वात काजे लिखीन भेळा करनेन काम कर्‌या ची वात हामरे ईचमां वीतली हतली। ");
INSERT INTO bhi_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","जे सबुत हामुक तींद्‌रे सी जड़लो छे जे सुरु सी ईनी वातेक देखणेवाळा ने जे भगवानेन पावर्‌या हतला। ");
INSERT INTO bhi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","हेरेसी, ए अंजाण्‌या थीयुफीलुस मे तार वाटे तीनी आखी वीतली वातेन बारामां एक चोव सी उजेंतु चतराये लिखणे बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","तु ज पाक्‌को जाण लेय की, जी सीकापण तुसेक जड़ली छे, ची खरली छे। ");
INSERT INTO bhi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","हेरोदेस यहुदीया जीलान राजु हतलु, तीनी टेमे अबीय्‌याह दळ मां जकर्‌या नावेन एक याजक हतलु, ने तेरी बायरी हारुनेन पुजारान जातेन हतली, तेरो नाव एलीसीबा हतलो। ");
INSERT INTO bhi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ने चे दुय जणा भगवानेन नींगा मां धरमी हतला, ने चे मालीक भगवानेन आखा हुकुम ने नेम पाळने मां नी चुकतेला। ");
INSERT INTO bhi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","एलीसीबा आंझी हतली, ने दुयु जणा डाहला हय गुयला, तेरेमां तींद्‌री एक बी अवल्‌यात नी हयी। ");
INSERT INTO bhi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","एक कावा जकर्‌यु पुजारु टाकला दाहड़ान अनसारे आपसा टुळा भेळु भगवान अगळ पुजारान काम करने बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ती एक दाहड़ु पुजारान रीतीन अनसारे मालीक-भगवानेन मंदीर मां भरायन धुणी दीन भगवानेन पुजा-पाट करने करीन जकर्‌यान नावेन चिट्‌ठी नीकळी। ");
INSERT INTO bhi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ने जकर्‌यु धुणी देणे बाजी रवलु, तीनी टेमे मां आखा माणसेन टुळु बाहर उबु रय्‌न भगवान धड़े दुवा करने बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","तीनी टेमे जकर्‌यु वेदी पर धुणी देणे बाजी रवलु, ने मालीक भगवानेन एक सरग वाळु काहवाळ्‌यु तीनाक वेदीन जेवड़्‌ये आंग्‌ये देखाव पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ने तीना भगवानेन सरग वाळा काहवाळ्‌या काजे देखीन जकर्‌यु बेसकु बीहीन सीयारी ली लेदु; ");
INSERT INTO bhi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","बाकुन सरग वाळु काहवाळ्‌यु जकर्‌या काजे कह्‌यु, “ए जकर्‌या बीहे मां, तारी दुवा भगवान सामळी लेदु, ने तारी घरवाळी एलीसीबान एक पुर्‌यु हवसे, तु तेरो नाव युहन्‌ना पाड़जी। ");
INSERT INTO bhi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","तु खुस हवसी ने पुर्‌यु हयु करीन बेसका माणसे खुसी हवसे। ");
INSERT INTO bhi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","चु युहन्‌‌‌नु, मालीक-भगवानेन नींगा मां बेसकु मटु कहवायसे, ने अंगुरेन दारु ने काहनी बी नस्‌यान चीज नी पीये; ने चु आपसी मायन कुखेम सीत चुखली-आत्‌मा सी भरायलु रवसे। ");
INSERT INTO bhi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ने ईस्‌रायेली जातीन बेसका माणसेन मन मालीक-भगवान भीणी पछु आळसे। ");
INSERT INTO bhi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","मालीक भगवान वाटे एक भुरसु करे असा असामी तीयार करने करीन चु युहन्‌‌‌नु मालीक-भगवान अगळ-अगळ चालसे। ने एलीया धड़े जु भगवानेन चुखली-आत्‌मा ने जुर हतलु, तेरेत साहरे युहन्‌‌‌नु ज काम करसे बासे-बासेन मन आपसा पुर्‌या-पारी भीणी आळसे; ने हुकुम नी माने तीनु काजे खरला धरम पर चालाड़नेन समज आपसे।” ");
INSERT INTO bhi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","जी वात सामळीन जकर्‌यु सरग वाळा काहवाळ्‌या काजे पुछ्‌यु, “मे जो कसु जाणो की असो हवणे वाळो छे? काहाकी मे ते डाहलु हय गुयु; ने मारी घरवाळी बी डाहली हय गुय।” ");
INSERT INTO bhi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","सरग वाळु काहवाळ्‌यु तीनाक जपाप आप्‌यु, “मे जीब्‌रायल छे, मे भगवान अगळ हजुर रवु। ने भगवान मेसेक तार पुठ्‌ये वात करने, ने तुसेक जी खुस-खबर सामळावणे मकेल्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ने देख, तु मारी कह्‌ली तीनी वात पर भुरसु नी कर्‌यु, जी वात टेम आवसे ती पुरी हवसे। ने तीने दाहड़े लग जी वात पुरी नी हवे, तीने दाहड़े लग, तु गुंगु रवसी, ने बुली नी सके।” ");
INSERT INTO bhi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","असामी ते बाहर रय्‌न जकर्‌यान वाट देख रवला, बाकुन चु हय मंदीर मां अतरी वार काहा लागाड़ र्‌यु करीन चे सुच मां पड़ गुया। ");
INSERT INTO bhi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","जत्‌यार जकर्‌यु बाहर आयु, ती चु तींद्‌रे अगळ बुली नी सक्‌यु, हेरेसी चे जाण गुया की, हीना जकर्‌याक भगवानेन मंदीर मां काय ने काय भगवान भीणी सी देखाव पड़लो छे, ने चु गुंगुत रयु, ने तीनुक ईसारु करतुत रयु। ");
INSERT INTO bhi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","आपसा भगवानेन चाकरीन दाहड़ा पुरा हय गुया, ती चु जकर्‌यु आपसान घर जात रयु। ");
INSERT INTO bhi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","जी वात वीत गुय ने थुड़ाक दाहड़ाम पछेन जकर्‌यान घरवाळी एलीसीबा भारीस हय गुय; करीन ची पांच महना लग आपसा मन मां ज कह्‌ती जाय्‌न घर मां साताय रय। ");
INSERT INTO bhi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","की “माणसे मारी हासी उडाड़तेला, बाकुन हय मालीक भगवान मार पर दया करलु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","एलीसीबा भारीस हवली तेरो छटवो महनो चाल रह्‌लो, ती भगवान, सरग वाळा काहवाळ्‌या जीब्‌रायल काजे गलील जीलान नासरत नावेन एक सहर मां एक कुवारली पुरे भीणी मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","तीनी कुवारली पुरेन नाव मरीयम हतलो, ने तेरी मांगणी युसुफ नावेन एक जुवान पुर्‌या साते हय रवली। चु युसुफ राजा दावुदेन अवल्‌यात मायन हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","सरग वाळु काहवाळ्‌यु मरीयम धड़े आवीन कह्‌यु, “तु खुस हय जां, भगवानेन गीण-दया तार पर छे, ने मालीक-भगवान तार पुठ्‌ये छे।” ");
INSERT INTO bhi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","सरग वाळा काहवाळ्‌यान साहरे जी सामळीन मरीयम बेसकी बीही गुय, ने असी वीच्‌यार करने बाजी गुय, की ईना बुलेन मतलब काय हसे ने काय नी। ");
INSERT INTO bhi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ती सरग वाळु काहवाळ्‌यु तीनीक कह्‌यु, “मरीयम, बीहे मां, काहाकी भगवानेन गीण-दया तारे पर छे। ");
INSERT INTO bhi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","देख, तु भारीस हवसी ने तारु एक पुर्‌यु हवसे ने तु तेरो नाव ईसु पाड़जी। ");
INSERT INTO bhi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","चु बेसकु मटु कहवायसे, ने चु आखान डाहला भगवानेन पुर्‌यु कह्‌वायसे। मालीक भगवान तीनाक आड़ा-बुड़ा राजा दावुदेन राजगादी आपसे। ");
INSERT INTO bhi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ने चु याकुपेन आखी अवल्‌यात पर जलम लग राज करसे, ने तेरो राज कदी नी सरे।” ");
INSERT INTO bhi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरीयम सरग वाळा काहवाळ्‌या काजे कह्‌यी, “मारो ते अदमी साते सोवसार नी हयो, ती तार साहरे कह्‌ली वात कसी पुरी हवसे?” ");
INSERT INTO bhi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","सरग वाळु काहवाळ्‌यु जपाप आप्‌यु, “तारे पर चुखली-आत्‌मा उतरसे, ने तार पर आखा सी डाहला भगवानेन जुरभर्‌यु साहळु पड़से। तेरेमां चु पयदा हवणे वाळु चुखलु पुर्‌यु, भगवानेन पुर्‌यु कह्‌वायसे। ");
INSERT INTO bhi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","तारीत भाय-बेटी एलीसीबान बारामां सामळ, ची आंझी हतली, ने हय डाहवाराम भारीस हवसे, ने तेरो छटवो महनो चाल रयो। ने तेरो पुर्‌यो हवणे वाळो छे। ");
INSERT INTO bhi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","काहाकी भगवानेक नी बणे, असो काय बी, नी हय।” ");
INSERT INTO bhi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरीयम कह्‌यी, “सामळ! मे मालीक-भगवानेन चाकरी करने वाळी छे। तु हय कह्‌यु, तसोत मार साते हवणे दे।” ने तत्‌यार सरग वाळु काहवाळ्‌यु तेरेन्‌चां सी जात र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","तीनु दाहड़ाम मरीयम तीयार हय्‌न यहुदीया जीलान बयड़ाम वसण्‌या, एक सहर भीणी मामार गुय, ");
INSERT INTO bhi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ने ची जकर्‌यान घर मां जाय्‌न एलीसीबा काजे “वारु छे की?” कह्‌यी। ");
INSERT INTO bhi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ने ज सामळतेत एलीसीबान पेट मायन पुर्‌यो खुस हय्‌न उछळी पड़्‌यो, ने एलीसीबान चुखला-आत्‌मा सी भरायली हतली। ");
INSERT INTO bhi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ने एलीसीबा मरीयम काजे जुर सी आयड़ीन कह्‌यी, “तु आखा बायराम सी बेसकी वारु छे ने तारा पेटे मायन फळ बी बरकतवाळो छे। ");
INSERT INTO bhi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","हय तु मारा मालीकेन माय बण गुय, ने भगवान, तुसे काजे मारेन्‌चां लावीन, मार पर अतरी दया काहा कर्‌यु हसे? ");
INSERT INTO bhi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","सामळ! जत्‌यार तु ‘वारु छे की?’ असी करीन पुछी अतरीत, ने मारा पेटे मायन पुर्‌यो खुस हय्‌न उछळी पड़्‌यो। ");
INSERT INTO bhi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","तु वारु छे, काहाकी तु जु भुरसु करी की मालीक भगवान जसों कह्‌लु, तसोत आखो हवसे!” ");
INSERT INTO bhi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","तत्‌यार मरीयम कह्‌यी, “मारु जीव, मालीक-भगवानेन गुण गावे, ");
INSERT INTO bhi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ने मारी चुखली-आत्‌मा, मेसेक बचाड़न्‌या भगवान मां खुस हवे; ");
INSERT INTO bhi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","काहाकी चु आपसी नीचळी गुलाम पावरनी पर दया कर्‌यु; हेरेसी सामळु! हय सी आखी पीड़ीन माणसे मेसेक बरकतवाळी कह्‌से; ");
INSERT INTO bhi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","काहाकी आखाम ताकतवाळु भगवान मार वाटे बेसको मटो-मटो काम कर्‌यु, ने तेरो नाव ‘चुखलो’ छे; ");
INSERT INTO bhi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","जे भगवानेन बीहाणो मानीन जीवे, तींद्‌रे पर तेरी दया बन्‌ली रवे; हय तेरी दया, तींद्‌री पीड़ीडीट, तींद्‌रे पर बणी रवे। ");
INSERT INTO bhi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","चु आपसा हातेन जुर देखाड़लु छे; चु मटाय करन्‌या काजे रावण्‌या-तीवण्‌या कर देदलु। ");
INSERT INTO bhi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","चु ताकतवाळा राजा काजे तींद्‌री राजगादी पर सी हीट पाड़्‌यु; बाकुन नीचळा माणसेक उचा बणावलु छे। ");
INSERT INTO bhi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","चु भुकला माणसेक खाणु आपीन आफराड़ देदु, ने लकपती काजे ठारलात वळाय देदु। ");
INSERT INTO bhi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","चु तेरा पावर्‌या ईस्‌रायेली जातीन माणसेक मदत कर्‌यु, तीनुक हेर करीन दया कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","चु हामरा आड़ा-बुड़ा साते वायदु करलु, तेरेत अनसारे तेरी दया, अब्‌राहम ने तेरी अवल्‌यात पर जलम बन्‌ली रवसे।” ");
INSERT INTO bhi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरीयम तीनेक महना लग एलीसीबा पुठ्‌ये रवी, ने अळी आपसे घर जात गुय। ");
INSERT INTO bhi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ने एलीसीबान फवरी हवणेन टेम आवी, ने तेरु पुर्‌यु पयदा हयु। ");
INSERT INTO bhi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","तेरे आड़े-धड़े रहण्‌या, ने सगासाइ वाळा सामळ्‌या की मालीक भगवान एलीसीबा पर बेसकु दया करलु छे, ने चे तेरे पुठ्‌ये भेसकायन खुस हया। ");
INSERT INTO bhi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ने पुर्‌यो हवलो सात दाहड़ा पुरा हय गुया। ने अळी आठवे दाहड़े मुसान साहरे ईस्‌रायेली जातीन माणसेक आपला भगवानेन कायदान अनसारे पुर्‌याक चुखो करने आया तीनी टेमे, चे आखा तीना पुर्‌यान नाव जकर्‌यु पाड़ने बाजी गुया, चो नाव तीना पुर्‌यान बासेक मालुम हतलो। ");
INSERT INTO bhi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","बाकुन पुर्‌यान माय एलीसीबा कह्‌यी जकर्‌यु नाव मां पाड़ु, बाकुन युहन्‌‌‌नु नाव पाड़ु। ");
INSERT INTO bhi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","तत्‌यार चां आवला आखा माणसे तीनीक कह्‌या, “तारा सगासाइ मां बी, ज नाव काहनान नी हय।” ");
INSERT INTO bhi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","तत्‌यार आकरी मां चे आखा तीना पुर्‌यान बास जकर्‌यात काजे ईसारु करीन पुछ्‌या “तु तारा पुर्‌यान, काय नाव पाड़ने हींड र्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","चु लिखणेन पट्‌टी ने सीलुक मांगाड़ीन लिख्‌यु, “हेरो नाव युहन्‌ना छे।” ने ज देखीन चां भेळा हवला आखा माणसे वीच्‌यार मां पड़ गुया। ");
INSERT INTO bhi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","तत्‌यारुत जकर्‌यान मुंहडो ने जीप खुल गुय, ने चु बुलने बाजी गुयु, ने भगवानेन गुण गावणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","आड़े-धड़े रवण्‌या आखा माणसे चकराय्‌न बीही गुया ने यहुदीया जीलान बयड़ाम ने आखा कामेन, बी जी वात चारेमेर जाती रय। ");
INSERT INTO bhi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ने आखा सामळन्‌या, पुर्‌यान बारामां आपसा-आपसा मनोम वीच्‌यारीन कह्‌या, “ज पुर्‌यो कसों हसे?” काहाकी मालीक-भगवान हेरे पुठ्‌ये हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","तेरु बास जकर्‌यु चुखली-आत्‌मा सी भराय गुयु, ने चु ज कह्‌तु जाय्‌न भगवानेन अघी सी आवणे वाळी वात कह्‌णे बाजी गुयु: ");
INSERT INTO bhi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ईस्‌रायेली जातीन मालीक भगवानेन बड़ाय हवती रहणु चाहजे, काहाकी चु आपसा माणसे पर दया करीन तीनुक हेर कर्‌यु ने तीनुक छुटकारु आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","चु आपसा पावर्‌या दावुदेन अवल्‌यात मां सी, आपणे धड़े एक ताकतवाळु बचाड़ने वाळाक मकेल्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ईनी वातेन बारामां भगवान आपसा वाटे चुखला माणसेन साहरे तेरे बारामां ज कह्‌तु आय रवलु, ");
INSERT INTO bhi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","की हामरा वेरीन हातेम सी ने हामुक भुंडा कह्‌णे वाळान हातेम सी हामरु छुटकारु हय जाणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","चु हामरा आड़ा-बुड़ा पर दया करीस करीन कह्‌लु, ने आपसु चुखला वायदान हेर करीस करीन कह्‌लु, ");
INSERT INTO bhi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","जी सगुन चु हामरा बास अब्‌राहम अगळ खादलु ची जी छे, ");
INSERT INTO bhi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","आपणु आपणा वेरीन हातेम सी हामरु छुटकारु करजे, ने हामु हिम्‌मत करीन भगवान मालीकेन सेवा करता रवसु। ");
INSERT INTO bhi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","जीवे ती लग तेरी नींगाम चुखला रय्‌न, ने तेरा धरम पर चालीन तेरी सेवा करता रवजे। ");
INSERT INTO bhi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ने ए मारा पुर्‌या! तु आखान डाहला भगवानेन अघी सी आवणे वाळी वात देखाड़ने वाळु कवायसी; काहाकी तु मालीक-भगवान वाटे वाट तीयार करसी, ने तेरे अगळ-अगळ चाल्‌या करसी। ");
INSERT INTO bhi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","तु भगवानेन माणसेक ज कवजी, की तुहुं भगवान धड़े पापेन माफी हात करीन कसा छुटकारु हात करसु। ");
INSERT INTO bhi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","जसु तु कवसी तसुत भगवान पाप माफ करसे काहाकी चु बेसकु दयाळु छे। जसु दाहड़ु उगतेत नवलु दाहड़ु सुरु हये, तसुत भगवानेन्‌चां सी बचाड़न्‌यु हामरेन्‌चां आवसे। ");
INSERT INTO bhi_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","तत्‌यार चु पापेन आंदारला मां ने जलेमकी मोतन साहळा मां बस रया, तींद्‌रे उपर वीजाळो बी हवसे, ने तीनुक एक सांतीन जीवाय्‌न वाटे चालने करीन अगळ-अगळ चालीन अगवाय करसे। ");
INSERT INTO bhi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ने चो पुर्‌यो मटो हवतो गुयो ने जीव-आत्‌मा मां ताकतवाळु हवतु गुयु, ने ईस्‌रायेली जातीन माणसे अगळ उजेंतो हवणे लग बयड़ा मां रयो। ");
INSERT INTO bhi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","तीनु दाहड़ाम रोमी राजा ओगस्‌तुस केसर एक असु राज हुकुम नीकाळ्‌यु, की ए मारा राजेन आखा कळीन माणसे! तुहुं मारा सरकारी किताप मां आपणो नाव लिखाड़ने करीन आपणा-आपणा सहर मां जावु। ");
INSERT INTO bhi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","जी पेहली कावा माणसेन गिन्‌ती हतली, तीनी टेमे क्‌वीरीन्‌युस सीरीया देस मां राजा हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","आखा माणसे नाव लिखाड़ने करीन आपणा-आपणा सहर मां गुया। ");
INSERT INTO bhi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","बेतलहम सहरेन राजा दावुदेन खानदानीन हतलु। ने युसुफ, जु राजा दावुदेन अवल्‌यात मायन हतलु, चु हय नासरत सहरेम रहतेलु। ने युसुफ गलील जीलान नासरत सहरेम सी यहुदा जीलान बेतलहम सहर मां नाव लिखाड़ने करीन गुया। ");
INSERT INTO bhi_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ने मरीयम बी तेरे पुठ्‌ये चां नाव लिखाड़ने गुय ने तेरी मांगणी ईना युसुफ साते हय रवली, ने ईनी मरीयमेन पुर्‌यो हवणे वाळो हतलो। ");
INSERT INTO bhi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","जत्‌यार युसुफ ने मरीयम बेतलहम सहर मां हतला, ती मरीयमेन फवरी हयणेन टेम आय लागी। ");
INSERT INTO bhi_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","चां धरम साळाम मां बी तींद्‌रे वाटे जागा नी जड़ी। ने ची एक ढुरेन वाड़ा मां जाती रय। मरीयम चां पेहेल मेहेल फवरी हवी, ने तेरु एक पुर्‌यु हयु, ने ची तीना पुर्‌या काजे पुथल्‌या मां वेलटीन ढुरेक चारु नाखण्‌या एक गवाण मां सुवाड़ देदी। ");
INSERT INTO bhi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","तीना ईलाकाम राते थुड़ाक गाडरा-गुवाळ्‌या बयड़े आपसा गाडरान राखवाळी करने बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","भगवानेन्‌चां सी एक सरग वाळु काहवाळ्‌यु तींद्‌रेन्‌चां आवीन उबु हय गुयु, ने भगवानेन सेक-सींगार, तींद्‌रे चारेमेर बी धपणे बाजी गुयो, ने चे बीहीन सीयारी ली लेदा। ");
INSERT INTO bhi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","बाकुन सरग वाळु काहवाळ्‌यु तीनुक कह्‌यु, “बीहु मां; सामळु, मे तुहुं काजे बेसकी खुसीन एक खुस-खबर सामळावो, जी आखा माणसे वाटे रवसे। ");
INSERT INTO bhi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","काहाकी आज तुंद्‌रु छुड़ावणे वाळु दावुदेन सहर बेतलहम मां, पयदा हवलु छे, हयुत मालीक ने मसी छे। ");
INSERT INTO bhi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","तीना पुर्‌याक उळख्‌णेन सहलाणी जी छे, की तुहुं तीनाक पुथल्‌या मां वेटळायलु ने ढुरेक चारु नाखण्‌या गवाण मां पड़ रवलु देख्‌सु।” ");
INSERT INTO bhi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ने उचकाणुत तीना सरग वाळा काहवाळ्‌या पुठ्‌ये सरग वाळा काहवाळ्‌यान टुळु असा कह्‌ता जाय्‌न भगवानेन गुण गावतेलु देखाय देदु: ");
INSERT INTO bhi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“आखाम उचा सरगे मां भगवानेन सेक-सींगार हवे, ने धरती पर रवण्‌या तीनु माणसेक सांती जड़से, तींद्‌रे सी भगवान खुस छे।” ");
INSERT INTO bhi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","जत्‌यार सरग वाळा काहवाळ्‌या पछा सरगे जात रया, ती गुवाळ्‌या आंबा-सांबा कह्‌या, “चालु आपणु बेतलहम सहर जाजे, ने मालीक जी वात आपणुक कह्‌लु छे, चां देख्‌सु।” ");
INSERT INTO bhi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ने चे मामार बेतलहम सहर भीणी चाल पड़्‌या, ने चां ढुरेन वाड़ा मां जाय्‌न मरीयम ने युसुफ काजे देख्‌या, ने पुर्‌याक गवाण मां सुवाड़ रवला देख्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","जत्‌यार गाडरान गुवाळ्‌या ईसुक देख्‌या, तत्‌यार चे गुवाळ्‌या मरीयम ने युसुफ काजे, पुर्‌यान बारामां ज सरग वाळा काहवाळ्‌या कह्‌ला च कय देदा। ");
INSERT INTO bhi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","गुवाळ्‌या तीनुक पुर्‌यान बारामां जी खबर पुगाड़्‌या ची खबर सामळीन दीसरा आखा माणसे चकराय गुया। ");
INSERT INTO bhi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","बाकुन मरीयम जी आखी वात हेर करीन ईनी वातेन बारामां वीच्‌यार करतीत रय। ");
INSERT INTO bhi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","गुवाळ्‌या काजे सरग वाळा काहवाळ्‌या जसों कह्‌ला, तसोन तसों देखीन ने सामळीन चे बयड़ा मां गाडरान्‌चां पछा भगवानेन गुणे गावता जाय्‌न जात र्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","सात दाहड़ा हय गुया, ने आठवे दाहड़े पुर्‌याक चुखो करनेन टेम आयो। ईसु मरीयमेन कुख मां नी आयु ने पेहलेत सरग वाळु काहवाळ्‌यु मरीयम काजे ज कह्‌लु, तेरो नाव ईसु पाड़जी। ने चे आवीन रीत भात कर्‌या, ने पुर्‌यान नाव ईसु पाड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","तेरेत अनसारे पुर्‌याक चुखो करनेन दाहड़ा पुरा हय गुया, ती युसुफ ने मरीयम, पुर्‌या ईसु काजे यरुसलेम सहरेन मंदीर मां, मालीक भगवान काजे आपणे करीन तेरे अगळ ली गुया। ");
INSERT INTO bhi_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","मुसान साहरे ईस्‌रायेली जातीन माणसेक आपला मालीक-भगवानेन कायदा मां असो बी लिखलो छे: “माणसे ने जनवार्‌या डीट, पेहल पयदा हवला अदमी, मालीक भगवान वाटे चुखलो मानायसे।” ");
INSERT INTO bhi_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","मालीक भगवानेन कायदा मां असो बी लिखलो छे, “पेरवान एक जुड़ो, नी ते पेरवान दुय पीला मारीन बादा चड़ावणु चाहजे।” ने चे बादा चड़ावणे करीन तीयारी बी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","तीनी टेमे सीमोन नावेन एक धरमी ने भक्‌ती करन्‌यु अदमी, यरुसलेम मां रवतेलु। ने चु ईस्‌रायेली माणसेन सांतीन वाट देख रवलु। ने तेरे पर चुखली-आत्‌मा छावाय रवतेलु, ");
INSERT INTO bhi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ने चुखली-आत्‌मा तेरे अगळ जी वात उजेंती करलु “मालीक भगवान अघु सी आवणेवाळा मसी काजे देखे नी चां लग तु नी मरे।” ");
INSERT INTO bhi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ईसुन आसी बास्‌या पुर्‌या ईसु धड़े भगवानेन कायदान रीती पुरी करने-करीन, मंदीर मां लाया। तत्‌यार सीमोन तीनात चुखली-आत्‌मान वाटे मंदीर मां आयु। ");
INSERT INTO bhi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ती सीमोन ईसु काजे आपसा हातेम धर लेदु, ने भगवानेन गुण गावतु जाय्‌न कह्‌यु: ");
INSERT INTO bhi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ए मालीक हय जु तारु चाकर्‌यु छे; सुक-सांती भेळ ईनी कळीम सी अळाय दे। ");
INSERT INTO bhi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","“मालीक भगवान! मारा डुळा तारा छुटकारा काजे देख लेदला छे, ");
INSERT INTO bhi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ईनाक तु आखा देसेन माणसे अगळ तीयार करलु छे। ");
INSERT INTO bhi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","जु नी-यहुदी माणसे वाटे, छाचाय काजे उजेंतो करन्‌यो वीजाळो छे, ने जु तारा असामी ईस्‌रायेली माणसे वाटे सेक-सींगार छे।” ");
INSERT INTO bhi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","पुर्‌यान बारामां जी कह्‌वली वात सामळीन ईसुन आसी बास्‌या चकराय्‌न वीच्‌यार मां पड़ गुया। ");
INSERT INTO bhi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","सीमोन, ईसुन माय बास बरकत आप्‌यु, ने चु ईसुन माय मरीयम काजे ज कह्‌यु, “देख ईना पुर्‌याक, ईस्‌रायेली जाती मां बेसका माणसे भगवान अगा वळ जासे, ने बेसका माणसे भगवान काजे छुड़ देसे। ने जु एक असी सहलाणी छे तेरी माणसे वीरुद करसे। ");
INSERT INTO bhi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","असा करीन बेसका माणसेन हीया मनेम भुंड्‌ला वीच्‌यारे उजेंता हय जासे, ने तुसे काजे असो लागसे की, तारा जीवेम लग तलवार भराय गुय।” ");
INSERT INTO bhi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ने चां मंदीर मां हन्‌ना नावेन एक, भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळी हतली। ची आसेर कुळीन हतली, ने तेरा बासेन नाव फनुयेल हतलो। ची बेसकी डाहवी हय गुयली। ने ईयाव करीन सात साल लग हेरा घरवाळा पुठ्‌ये रवली। ");
INSERT INTO bhi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ने तत्‌यार लग ची रांडायलीत रय। ने हय तेरी उमर आस्‌सी ने चार साल हय गुयली, ची मंदीर मात रहतेली। ने उपास ने दुवा करती जाय्‌न रात दाहड़ु भगवानेन सेवा भक्‌ती कर्‌या करतेली। ");
INSERT INTO bhi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","जत्‌यार मरीयम ने युसुफ मंदीर मां हतला, तत्‌यार हन्‌ना चां आवीन भगवानेन गुण गावणे बाजी गुय। ने जे माणसे यरुसलेम सहरेन छुटकारान वाट देख रवला, तीनु आखा काजे तीना पुर्‌यान बारामां कह्‌णे बाजी गुय। ");
INSERT INTO bhi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","मालीक भगवानेन नेम-कायदान अनसारे युसुफ ने मरीयम, आखी रीती-भाती कर लेदा, ने अळी गलील जीलान आपसा नासरत सहर मां पछा जात र्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","पुर्‌यु मटु हवतु गुयो, ने ताकतवाळु हवतु गुयु ने अक्‌कल मां मटु हवतु गुयु; ने भगवानेन गीण-दया तीना पुर्‌या पर हतलो। ");
INSERT INTO bhi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ईसुन माय बास हर साल फसह तीहवार वाळने यरुसलेम जाया करतेला। ");
INSERT INTO bhi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","जत्‌यार ईसु बारे सालेन हयु, ती चु बी तींद्‌रे पुठ्‌ये तीहवार वाळनेन रीतीन अनसारे यरुसलेम सहर मां गुया। ");
INSERT INTO bhi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","तीहवार वाळनेन दाहड़ा पुरा हय गुया, ने अळी ईसुन आसी बास्‌या पछा घर जाणे करीन यरुसलेम सी चाल पड़्‌या। ती चु पुर्‌यु ईसु यरुसलेम सहर मां रय गुयु; ने ज तेरा बास काजे ने माय काजे मालुम नी हतलो। ");
INSERT INTO bhi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","चे ज समजीन वीच्‌यार कर्‌या की ईसु तीना माणसेन टुळा मां भेळु हसे, जे पछा घर आवणे बाजी रवला; चे पुरा एक दाहड़ान चाल, चाल लेदा, तत्‌यार चे ईसु काजे आपसा सगासाइ वाळा मां, ने दुस्‌तीदार्‌यान ईचमां हेरने बाजी गुया; ");
INSERT INTO bhi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","बाकुन ईसु तीनुक नी जड़्‌यु; ती चे तीनाक हेरने करीन पछा यरुसलेम मां आया। ");
INSERT INTO bhi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ने तीन दाहड़ा हय गुया, ने अळी ईसु मंदीर मां जड़ गुयु; ईसु यहुदी-नीयम सीकाड़न्‌या पुठ्‌ये बस रवलु, ने तींद्‌री वात सामळने बाजी रवलु, ने तीनुक सवाल पुछणे बाजी रवलु देखाय देदु। ");
INSERT INTO bhi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","तेरी अक्‌कल भरी वात सामळीन, चे आखा सामळन्‌या माणसे फीकुर मां पड़ गुया। ");
INSERT INTO bhi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ईसुन माय बास बी तीनाक चां देखीन चकराय गुया; तेरी माय तीनाक कह्‌यी, “ए बेटा! तारु बास ने मे, तार वाटे बेसका फीकुरेम पड़ गुयला; हामु तुसेक आखे जागे हेर्‌या! तु हामरे साते असु वेहवार काहा कर्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","बाकुन ईसु तीनुक जपाप आप्‌यु, “तुहुं मेसेक काहा हेरतेला? तुहुंक मालुम नी हतलो काय? की मेसेक मारा बासेन घर मां रहणु जरुरी छे।” ");
INSERT INTO bhi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","बाकुन ईसुन माय-बासेक ईसुन कह्‌वली वातेक नी समज्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","तत्‌यार ईसु आपसा माय बास पुठ्‌ये आपसा नासरत सहर मां पछु आवती र्‌यु, ने चु आखी वातेम आसी-बासेन हुकुम मान्‌तु रयु; ने तींद्‌रा हक मां रयु; ने तेरी माय मरीयम ईनी आखी वात काजे हेर राखी, ने तेरे बारामां आपसा मनोम सुचती वीच्‌यारती रय। ");
INSERT INTO bhi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ने जसा साल वीत गुया, ईसु अक्‌कल मां, ने डीलो मां मटु हवतु गुयु, ने भगवान ने माणसे तीनाक बेसका परम करता रया। ");
INSERT INTO bhi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","अळी रोमी राजान राज तीबीरीयास राज करलु पंद्‌रेक साल हय गुया, तीने टेमे पुंतीयुस पीलातुस यहुदीया जीलाम राजपाटन भार सामाळतेलु; ने हेरोदेस गलील जीलाम राज करतेलु, ने तेरु भायस फीलीप्‌यु इतुर्‌या ने तोरकानीतीस जीला मां राज करतेलु ने लीसानीयुस, अबीलेने जीला मां राज करतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ने हन्‌ना ने काइफा यरुसलेमेन मंदीर मां भगवानेन मुखी पुजारा हतला, तीनु दाहड़ाम भगवान जकर्‌यान पुर्‌यु युहन्‌ना काजे खुस-खबर सामळायु। तीने टेमे युहन्‌ना उजाड़्‌या बयड़ाम रवतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ने युहन्‌ना यरदन नदीन आड़े-धड़े आखा ईलाका मां हींडी फीरीन असु परचार करने बाजी गुयु ने “पापेन माफी वाटे, पाप भीणी सी मन फेरवीन भगवान भीणी मन फेरव्‌यु ने बपतीस्‌मा लेवु।” ");
INSERT INTO bhi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","जसों भगवान अघी सी आवणे वाळी वात देखाड़न्‌या वाटे यसायान किताप मां लिखलो छे: उजाड़्‌या बयड़ा मां काहनुक असु आयड़ी र्‌यु, मालीक-भगवान वाटे सयड़क तीयार करु। ने तेरे वाटे वाट सुदी करु। ");
INSERT INTO bhi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","आखी घाटी भर देसे, ने आखा बयड़ा ने बयड़ी सवताळ कर देसे, ने जी वाट वाकी छे, तीनी वाट काजे सुदी कर देसे, ने कड़खा-कड़खाम वाट सवताळ करीन चुपड़ी कर देसे। ");
INSERT INTO bhi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ने आखा माणसे भगवानेन छुटकारा काजे देख्‌से! ");
INSERT INTO bhi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","जे माणसे युहन्‌नान हाते बपतीस्‌मा लेणे आवला, तीनुक असु कह्‌यु, “ए घड़सान पीला! भगवान भीणी सी आवणेवाळी रीस सी ढासु करीन कुण तुहुं काजे कह्‌यो? ");
INSERT INTO bhi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","तुहुं पाप भीणी सी मन फेरवीन भगवान भीणी वळ गुया हय, ती ईनी वातेन गवाय तुंद्‌री जीवाय वाटे देखाड़, हामरा आड़ा-बुड़ान डाहलु बास अब्‌राहम छे, असु वीच्‌यार आपसा मनेम मां करु; मे तुहुंक कहं, हेर राखु, भगवान ईनु दगड़ाम सी बी अब्‌राहम धड़े अवल्‌यात पयदा कर सके। ");
INSERT INTO bhi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ने हय झाड़कान जड़ मां कुरहाड़ मेकली छे। काहाकी जो झाड़को वारलु फळ नी लावे तीना झाड़का काजे काट देसे ने तीनाक आकठा मां धपणे करीन नाख देसे।” ");
INSERT INTO bhi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ने माणसे तीनाक असा पुछतेला, “ती हामु हय काय करजे?” ");
INSERT INTO bhi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","चु तीनुक कह्‌यु, “तीना धड़े दुय कुट हय, ती चु एक कुट तीनाक आप देणु चाहजे, तेरे धड़े नी हय, ने तीना धड़े खाणु हय, चु बी तेरे धड़े नी हय तीनाक आप देणु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","थुड़ाक फाळु उकाळने वाळा बी बपतीस्‌मान रीत लेणे आया, ने तीनाक असा पुछ्‌या, “ए मास्‌तर हामुक काय करनु चाहजे?” ");
INSERT INTO bhi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","चु युहन्‌‌‌नु तीनुक कह्‌यु, “जतरो लेणे करीन वात ठेहरावलो छे, ततरोत मांगु, हेरे सी जादा घुण मांगु।” ");
INSERT INTO bhi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ने सीपायड़ा बी तीनाक पुछ्‌या, “हामुक काय करनु चाहजे?” चु तीनाक कह्‌यु, “काहना बी धड़े जुर करीन पयस्‌या मां मांगु ने काहनाक पर झुटु गुनु मां लागाड़ु ने आपसी कमाय मां नीसरा रहु।” ");
INSERT INTO bhi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","माणसे वाट देखीन हेर कर रवला, ने युहन्‌नान बारामां आपसा मनेम वीच्‌यार करने बाजी गुया की कांखुर मायन हयुत मसी ते नी हय। ");
INSERT INTO bhi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ती बपतीस्‌मा आपण्‌यु युहन्‌‌‌नु ने आखा काजे कह्‌यु, मे ते तुहुं काजे पाणी सी बपतीस्‌मा आपो; बाकुन एक मार पछळ आवणे वाळु छे, चु मारे सी ताकतवाळु छे। मे तेरा खासड़ान बंद छुड़े असु नी हय; बाकुन चु तुहुं काजे चुखली-आत्‌मा मां ने आकठा मां बपतीस्‌मा आपसे। ");
INSERT INTO bhi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","तेरो सुपड़ो तेरा हात मां छे, ने चु आपसा खळा मां गहुं काजे चुखाळसे ने कणगी मां भरसे, बाकुन गहुंन चारा काजे उलाह्‌ये नी असली आकठी मां नाखीन धपाड़ देसे। ");
INSERT INTO bhi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","असी बेसकी वात सीकाड़तु जाय्‌न युहन्‌‌‌नु माणसे काजे समजाड़तेलु ने खुस-खबर सामळावतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","राजा हेरोदेस आपसा भाय फीलीप्‌पुसेन घरवाळी हेरोदेस काजे राख लेदलु, ने बेसका भुंड्‌ला कामे करलु, तेरेमां युहन्‌‌‌नु तीनाक लड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ती हेरोदेस राजा बपतीस्‌मा आपण्‌या युहन्‌ना काजे जेल मां कुंडीन दीसरा भुंड्‌ला कामे सी बी जादा भुंडो काम कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","बेसका साल वीत गुया ने अळी ईसु यरदन नद्‌ये गुयु चां बपतीस्‌मा आपण्‌यु युहन्‌‌‌नु बेसका माणसेक पाणी मां डुबाड़ीन बपतीस्‌मा आपतेलु। दीसरा माणसे बपतीस्‌मा ली लेदा, ने अळी, बपतीस्‌मा आपण्‌यु युहन्‌‌‌नु ईसु काजे बी बपतीस्‌मा आप्‌यु। जसु ईसु बपतीस्‌मा लेदु ती, चु दुवा कर्‌यु; जत्‌यार चु दुवा करने बाजी रवलु तत्‌यार सरग उघड़ी गुयो। ");
INSERT INTO bhi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ने भगवानेन चुखलु आत्‌मा एक पेरवान तसों ईसु पर उतर्‌यो ने तत्‌यारुत भगवान बास सरगेम रय्‌न ईसुक कह्‌यु, “तु मारु लाटेकलु पुर्‌यु छे, मे तार पर बेसकु खुस छे।” ");
INSERT INTO bhi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","तीनी टेमे ईसुन उमर तीसेक सालेन हतली। तीनी टेमे चु आपसुत वात सीकाड़ने बाजी गुयु, माणसे ईसुक, युसुफेन पुर्‌यु समजतेला ने युसुफ, एलीन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ने एली, मत्‌तातेन पुर्‌यु हतलु, ने जु मत्‌तात, लेवीन पुर्‌यु हतलु, ने जु लेवी मलकीन पुर्‌यु हतलु, ने जु मलाक्‌यु योन्‌नान पुर्‌यु हतलु, ने जु योन्‌ना, युसुफेन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ने जु युसुफ, मत्‌‌तीत्‌यान पुर्‌यु, ने जु मत्‌‌तीत्‌यु आमोसेन पुर्‌यु हतलु, ने जु आमोस, नहुमेन पुर्‌यु हतलु, ने जु नहुम, असल्‌यान पुर्‌यु हतलु, ने जु ओसल्‌यु, नगाहान पुर्‌यु हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ने जु नगुहु, मातान पुर्‌यु हतलु, ने जु मातु, मत्‌‌तीत्‌यान पुर्‌यु हतलु, ने जु मत्‌तीत्‌यु, सीमीन पुर्‌यु हतलु, ने जु सीमी योसेखेन पुर्‌यु हतलु, ने जु योसेख योदान पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ने जु योदाहा, युहन्‌नान पुर्‌यु हतलु, ने योन्‌नु रेसान पुर्‌यु हतलु ने जु रेसु जरुबाबीलोनेन पुर्‌यु हतलु, ने जु जरुबाबील, सालतीयेलन पुर्‌यु हतलु ने जु सालतीयेल, नेरीन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ने जु, मलकीन पुर्‌यु हतलु, ने जु मलकी, अद्‌दीन पुर्‌यु हतलु, ने जु अद्‌दी कोसामेन पुर्‌यु हतलु, ने जु कोसाम, इलमोदामोन पुर्‌यु हतलु, ने जु इलमोदाम, एरोन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ने जु एर, जोसुवान पुर्‌यु हतलु, ने जु जोसुवा, एलीआजारेन पुर्‌यु हतलु, ने जु एलीआजार यरीमोन पुर्‌यु हतलु, ने जु योरीम, मत्‌तातेन पुर्‌यु हतलु, ने जु मत्‌तात लेवीन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ने जु लेवी, सीमोन पुर्‌यु हतलु ने जु सीमोन्‌यु यहुदीयान पुर्‌यु हतलु ने जु यहुदा, युसुफेन, पुर्‌यु हतलु, ने जु युसुफ, योनामेन पुर्‌यु हतलु ने जु योनाम, इल्‌याकीमेन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ने इल्‌याकीम, मेल्‌यान पुर्‌यु हतलु, ने जु मेल्‌यु, मीन्‌नान पुर्‌यु हतलु, ने मीन्‌नु मत्‌तान पुर्‌यु हतलु, ने जु मत्‌ता, नातानोन पुर्‌यु हतलु, ने जु नातान, दावुदेन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ने दावुद, यीसेन पुर्‌यु हतलु, ने जु यीसे ओबेदेन पुर्‌यु हतलु, ने जु ओबेद, बोआजेन पुर्‌यु हतलु, ने जु बोआज, सलमन पुर्‌यु हतलु ने जु सलमन, नहसोन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ने जु नहसोन, अम्‌मीनादाबेन पुर्‌यु हतलु, ने जु अम्‌मीनादाब, अदमीन पुर्‌यु हतलु ने जु अदमीन, अरनीन पुर्‌यु हतलु ने अरनीन, हेसर्‌यान पुर्‌यु हतलु, ने जु हेसर्‌यान, फीरीसेन पुर्‌यु हतलु, ने जु फीरीस यहुदीयान पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ने जु यहुदा, याकुपेन पुर्‌यु हतलु, ने याकुप इसाकेन पुर्‌यु हतलु, ने जु इसाक, अब्‌राहमेन पुर्‌यु हतलु, ने जु अब्‌राहम, तीरहनेन पुर्‌यु हतलु, ने जु तीरह, नाहोरेन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ने जु नाहर, सेरुगेन पुर्‌यु हतलु ने जु सेरुगेन रेवुन पुर्‌यु हतलु ने जु रेवु फीलीगेन पुर्‌यु हतलु ने जु फीलीग, एबीरेन पुर्‌यु हतलु, ने जु एबीर, सीलहेन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ने जु सीलह, केनानेन पुर्‌यु हतलु, ने जु केनान, अरफक्‌सदेन पुर्‌यु हतलु, ने जु अरफक्‌सद, सेमनेन पुर्‌यु हतलु ने जु सेम, नुहान पुर्‌यु हतलु, ने जु नुह, लीमीकेन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ने चु लीमीक, मथुसीलहेन पुर्‌यु हतलु, ने जु मथुसीलह, हनोकेन पुर्‌यु हतलु ने जु हनोक, यीरीदेन पुर्‌यु हतलु, ने जु यीरीद, महलेलन पुर्‌यु हतलु, ने जु महलेल, केनानेन पुर्‌यु हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ने जु केनान, एनोसन पुर्‌यु हतलु, ने जु एनोस, सेतन पुर्‌यु हतलु, ने जु सेत, आदमेन पुर्‌यु हतलु, ने जु आदम, भगवानेन पुर्‌यु हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ईसु यरदन नदी मां बपतीस्‌मा ली लेदु, ने चु भगवानेन चुखली-आत्‌मान साते हय्‌न, चां सी चुखली-आत्‌मान अगवाय मांत उजाड़्‌या बयड़ाम गुयु; ");
INSERT INTO bhi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ने भुतड़ु आवीन चाळीस दाहड़ा लग पारख करतु रयु; ने तीनु दाहड़ाम ईसु काय नी खादु, ने जत्‌यार पारखणेन दाहड़ा पुरा हय गुया, ती तीनाक भुक लागी। ");
INSERT INTO bhi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","तत्‌यारुत भुतड़ु आवीन ईसु काजे असु कह्‌यु, “कदी तु भगवानेन पुर्‌यु हय, ती ईना दगड़ाक कय दे की रुटु बण जाय।” ");
INSERT INTO bhi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","बाकुन ईसु भुतड़ा काजे कह्‌यु, “चुखला सास्‌तुर मां लिखलो छे, ‘माणुस रुटा खायलीन जीवतु नी रवे।’” ");
INSERT INTO bhi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","तत्‌यार भुतड़ु ईसु काजे ली गुयु; ने पापण्‌या पाड़तात वार मां कळीन आखा देस ने राज देखाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ने भुतड़ु ईसु काजे कह्‌यु, “मे तुसेक कळीन ईनु आखा देस पर, ने तींद्‌रा धन पर हक आपीस, ने राज करने दीस। काहाकी ज मेसेक आपलो छे, ने ज मे चाहो तीनात काजे आप दम। ");
INSERT INTO bhi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","हेरेसी कदी तु मारा पाये पड़ीन मेसेक आंधसी, ती मे ज आखो, तुसेक आप दीस।” ");
INSERT INTO bhi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","बाकुन ईसु भुतड़ा काजे कह्‌यु, “चुखला सास्‌तुर मां लिखलो छे, ‘तु आपसा मालीक भगवान काजे आंद; ने तेरीत सेवा भक्‌ती कर!’” ");
INSERT INTO bhi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","तत्‌यार भुतड़ु ईसु काजे यरुसलेम सहरेन मंदीरेन मुंडेरी पर उबु कर देदु, ने असु कह्‌यु, “कदी तु भगवानेन पुर्‌यु हय ती जां सी आपसुत कुद पड़। ");
INSERT INTO bhi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","काहाकी चुखला सास्‌तुर मां ज बी लिखलो छे ‘भगवान तारी राखवाळी कराड़ने करीन, आपसा सरग वाळा काहवाळ्‌या काजे हुकुम आपसे। ");
INSERT INTO bhi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ने चे तुसेक उपरुत झेल लेसे, ने तारे पाये दगड़ान ठेसु लग नी लागणे देय।’” ");
INSERT INTO bhi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ईसु भुतड़ाक असु कह्‌यु, “ज बी लिखलो छे तु आपणा मालीक भगवानेन पारख मां करे।” ");
INSERT INTO bhi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","जत्‌यार भुतड़ु आखे भात्‌ये ईसुक पारखी लेदु, ने मुखु जड़से ती ईसु भीणी पछु आवीस, करीन चां सी जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","चुखली-आत्‌मा सी भरायन ईसु गलील जीला मां पछु आयु, ने तेरो नाव चारेमेर आखा कामेन हुकवाय उड गुय। ");
INSERT INTO bhi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ने चु तींद्‌रा भक्‌तीन घर-घरमां जाय्‌न तीनुक वात सीकाड़तु रयु, ने आखा तेरो नावलीन तेरी बड़ाय करतेला। ");
INSERT INTO bhi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ईसु नासरत सहरेम आयु, चां तीनाक तेरा माय बास पाळी पुसीन मटु करला। ने जां चु आपसी टेमेन अनसारे यहुदी माणसेन आरामेन दाहड़े, भगवानेन भक्‌तीन घर मां जाय्‌न, चुखलु सास्‌तुर भन्‌ने करीन उबु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ने तीनाक भगवान वाटे यसायान किताप भन्‌ने करीन आप्‌या। किताप उगाड़ीन ईसु, चु जागा हेर्‌यु, चां ज लिखलो हतलो, ");
INSERT INTO bhi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“मालीक भगवानेन चुखली-आत्‌मा मारे पर छे, काहाकी चु मेसेक नेवाड़्‌लु छे; ने मेसेक गरीबेक खुस-खबर सामळावणे, ने गुलामी करन्‌या माणसेक छुड़ावणे ने आंदळान डुळा उगाड़ने करीन मकेल्‌लु छे। ने वेला पाड़ायलाक छुड़ावणे मकेल्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ने मालीक भगवानेन खुसीन लांबला टेमेन, जुर-जुर सी परचार करने मेसेक मकेल्‌लु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","तत्‌यार ईसु, किताप बंद कर देदु, ने मंदीरेन पावर्‌या काजे आप दीन बसी गुयु; ने भगवानेन भक्‌तीन घरेन आखा माणसे तेरे भीणी देखी रवला। ");
INSERT INTO bhi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","तत्‌यार चु तीनाक असु कह्‌णे बाजी गुयु, “चुखली-सास्‌तुरेम जी लिखली वात आज तुहुंक सामळतेत पुरी हय गुयली छे।” ");
INSERT INTO bhi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ने आखा तीनाक बेसका वारु कह्‌णे बाजी गुया, ने जु गीण-दयान वात चु हीनुक कवलु, तीनी वातेन साहरे, चे चकराय गुया; ने असा कह्‌णे बाजी गुया “जु युसुफ्‌यान पुर्‌यु नी हय काय?” ");
INSERT INTO bhi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ईसु तीनुक कह्‌यु, “तुहुं मेसेक जु कवाड़ु कवसुन कवसु की ‘ए डाक्‌टर! आपसात काजे वारु कर।’ ने तुहुं ज बी कह्‌सु की हामु सामळी रया की ‘तु कफरनहुम सहर मां काय करलु छे।’ च जां आपणा सहरेम बी कर।” ");
INSERT INTO bhi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","अळी ईसु कह्‌यु, “मे तुहुंक छाचलीन ज कहं, काहना बी भगवानेन अघी सी आवणे वाळी वात देखाड़ने वाळु माणुस, आपसात सहरेम ईज्‌जत नी जड़े; बाकुन दीसरी जागे ईज्‌जत जड़े।” ");
INSERT INTO bhi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“ने मे तुहुंक छाचलीन कह्‌वो, एलीयान दाहड़ा मां तीन साल ने छव महना लग पाणी नी पड़्‌यु, ने आखा देसेम बेसकु काळ पड़लु, ती तीनी टेमे ईस्‌रायेल देस मां बेसका रांडायला बायरा हतला। ");
INSERT INTO bhi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","बाकुन तेबी भगवान, एलीया काजे तीनु मायन काहनान्‌चां नी मकल्‌यु, बाकुन दीसरा देसेन सेदा सहरेन धड़े वाळा सारफत सहरे मां एक रांडायली भीणी अतरुत मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ने भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌या एलीसा जीवतेलु हतलु, तीनी टेमे ईस्‌रायेल देस मां बेसका कुड़ायला हतला। तेबी चु सीरीया देस मां रहणे वाळा नामान काजे छुड़ीन काहना काजे वारु नी कर्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","जी वात सामळीन जतरा बी भगवानेन भक्‌तीन घर मां बसी रवला, चे आखा माणसे बेसका रीसाय गुया। ");
INSERT INTO bhi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","चे उठ पड़्‌या ने ईसु काजे सहरेन बाहर नीकाळ देदा। तीना बयड़ा पर तींद्‌रो सहर वसलो हतलो तीना बयड़ान चटी पर तीनाक धकलीन पाड़ने करीन ली गुया। ");
INSERT INTO bhi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","तेबी चु तींद्‌रे ईचमां सी नीकळीन जात र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ईसु गलील जीला मां सी दीसरा सहर कफरनहुम मां आयु, ने तींद्‌रे आरामेन दाहड़े भगवानेन भक्‌तीन घर मां, माणसेक वात सीकाड़ने बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ने माणसे ईसुन वात सामळीन चकराय गुया, काहाकी तेरा बुले जुर भर्‌या हतला। ");
INSERT INTO bhi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","तीना भगवानेन भक्‌तीन घर मां एक माणुस हतलु, तेरेमां भुतड़ान आत्‌मा भराय रवली। चु माणुस जुर सी आयड़ीन कय पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ए नासरत मां रहण्‌या ईसु! हामरे साते तारो काय काम छे? तु हामुक सारने करने आवलु छे काय? मेसेक मालुम छे की तु कुण छे? तु ते भगवान सी मकेल्‌लु चुखलु माणुस छे।” ");
INSERT INTO bhi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ने ईसु तीनाक लड़ीन कह्‌यु, “हुगु रव ने ईना माणुस मां सी नीकळी जां।” ने भुतड़ु तीना माणुस काजे भुयमां आसटीन नुकसाण करे, पाखुर तेरेमां सी नीकळी गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","आखा माणसे बीही गुया ने आपसा-आपसात वात करीन कह्‌या, “जी कसला बुल छे! हयु हक ने जुर भेळ भुतड़ान जमेक हुकुम आपे ने चे नीकळी जाय।” ");
INSERT INTO bhi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","हेरेसी ईसुन वात चारे मेर तीना आखा ईलाका मां खुणे-कुपरे फीर गुय। ");
INSERT INTO bhi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","चु भगवानेन भक्‌तीन घर मां सी नीकळीन सीमोनेन घर गुयु। सीमोनेन सासुसेन बेसको जुरे सेरी आय रह्‌लो, ने माणसे ईनीक वारु कर दे, करीन ईसुक लीलघाय्‌न कह्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ईसु तेरे धड़े जाय्‌न सेरीक लड़्‌यु, ने लड़तात वार मां सेरी उतरी गुयो। ने ची तत्‌यारुत उठीन तींद्‌री खातरी करीन तींद्‌री चाकरी करने बाजी गुय। ");
INSERT INTO bhi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","तीने दाहड़े, दाहड़ु डुब गुयु ने अळी आखा माणसे भाती-भातीन मांदवाड़ मां पड़ला माणसे काजे ईसु भीणी लाया। ईसु एक-एक जणा पर हात मेकीन तीनुक वारु करतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","“तु भगवानेन पुर्‌यु छे” असा आयड़ता जाय्‌न भुतड़ान आत्‌मा बेसका माणसे मां सी नीकळतेला। बाकुन चु तीनुक लड़तेलु, ने बुलने नी देदलु, काहाकी भुतड़ान आत्‌मा जाणतेली की जु मसी छे। ");
INSERT INTO bhi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","दीसरे दाहड़े एगुत ईसु घर सी नीकळीन एक उजाड़ी जागाम जात र्‌यु। ने माणसे तीनाक हेरता-हेरता तेरे भीणी गुयु, ने तीनाक असा कह्‌या, हामरेन्‌चां सी मां जाय। ");
INSERT INTO bhi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","बाकुन चु तीनुक असु कह्‌यु, “मेसेक दीसरा सहरेम बी भगवानेन राजेन खुस-खबरेन वात सामळावणु छे-काहाकी भगवान मेसेक ज सामळावणे करीन मकेल्‌लु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ने चु यहुदा जीलान तींद्‌रा भक्‌तीन घर-घरमां खुस-खबर सामळावतु रयु। ");
INSERT INTO bhi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","एक दाहड़ु ईसु गन्‌नेसरत दरीया धड़े उबु हय रवलु, ने माणसे भगवानेन वात सामळने करीन हुड़ु-हुड़ु आवतेला, ने धकलाय्‌न तेरे पर पड़े असा हय जातला। ");
INSERT INTO bhi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","तीनी टेमे चु दरीया धड़े दुय ढंड्‌या उबा कर रवला देख्‌यु, ने काहर्‌या ढंड्‌याम सी उतरीन जाळ धुवणे बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","तीनु ढंड्‌या मायन एक ढंड्‌यो सीमोनेन हतलो, तीना ढंड्‌या मां भरायन ईसु असु कह्‌यु, ईना ढंड्‌याक धड़े सी थुड़ाक उंडा पाणी मां ली जावु। तत्‌यार चु तीना नानला ढंड्‌याम बसीन माणसेक सीकाड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","जत्‌यार ईसु सीकाड़ी दीन नवराय गुयु, ती ईसु सीमोन काजे असु कह्‌यु, “ढंड्‌यो अळी उंडास पाणी मां ली जावु, ने माछा मारने करीन आपणी-आपणी जाळ नाखु।” ");
INSERT INTO bhi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ती सीमोन्‌यु असु कह्‌यु, “ए मालीक! हामु आखी रात माछा मारने करीन मेहनत कर्‌या, बाकुन ईतराक माछा बी नी धराया; तेबी तु कह्‌वे, ती मे माछा धरने करीन पाणीम जाळ नाखीस।” ");
INSERT INTO bhi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","जत्‌यार सीमोन्‌यु ने तेरा साते वाळा काजे ईसु कह्‌यु तसा कर्‌या ती तीनुक बेसका माछा धराय गुया, ने माछान भारे तींद्‌री जाळ फाटणे बाजी गुय। ");
INSERT INTO bhi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","तत्‌यार चे तींद्‌रा साते वाळा काजे जे दीसरा ढंड्‌या मां हतला, तीनु काजे हात पालवीन मदत करने बुलाया, ने चे साते वाळा आवीन दुय ढंड्‌याम माछा ढीक लागाड़ीन भर लेदा, ने चे ढंड्‌या डुबे-डुबे तसा हय गुया। ");
INSERT INTO bhi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ज देखीन सीमोन्‌यु पतरस ईसुन पाये मां हीट पड़्‌यु, ने असु कह्‌यु, “ए मालीक मे ते पापी माणुस छे, अळी तु मार सी छेटे रव।” ");
INSERT INTO bhi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","जाळेम बेसका माछा पड़ गुया, करीन चु ने तेरा साती चकराय गुया। ");
INSERT INTO bhi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","अळी तसात जब्‌दीन पुर्‌या याकुप ने युहन्‌‌‌नु बी चकराय गुयु चे सीमोनेन साती हतला। ने तत्‌यारुत ईसु सीमोन काजे असु कह्‌यु, “बीहे मां, हय सी तु माछा काजे नी धरे, बाकुन माणसे काजे मारा चेला बणावणे करीन भेळा कर्‌या करसी।” ");
INSERT INTO bhi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","चे ढंड्‌या काजे दरीया धड़े ली आया, ने माछा धरनेन धंदा सुदे, आखो छुड़ दीन ईसु पछळ चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","जत्‌यार ईसु एक दाहड़ु एक सहर मां हतलु, ती ईसुन्‌चां एक माणुस आयु, तेरो आखो डील कुड़ मांदवाड़ मां भरायलो हतलो। चु ईसु काजे देखीन मुंहडान भुरसे हीट पड़्‌यु, ने लीलघायतु जाय्‌न असु कह्‌यु, “ए ईसु मालीक! कदी तु चाहे, ती मेसेक वारु कर दे।” ");
INSERT INTO bhi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ईसु हात लांबु करीन ज कह्‌तु जाय्‌न तीनाक छीमीन कह्‌यु, “तु चुखु हय जां, जीत मारी मरजी छे।” ने तत्‌यारुत तेरो कुड़ जाती र्‌यो। ");
INSERT INTO bhi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","तत्‌यार ईसु तीनाक असु कह्‌यु, “जां, वारु हय गुयु करीन आपसा काजे भगवानेन पुजाराक देखाड़जी ने मुसान साहरे टाकली बादा चहड़ावजी ने तु वारु हय्‌न चुखु हय गुयु करीन आखा माणसे तारा गवा बण जासे। बाकुन जी वात काहना काजे बी घुण कह्‌वे।” ");
INSERT INTO bhi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","तेबी ईसु आखे दुर नावसाद्‌यु हय गुयु, ने हुड़-हुड़ु, माणसे तेरी वात सामळने, ने वारु हवणे करीन तेरेन्‌चां आवतेला। ");
INSERT INTO bhi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","बाकुन ईसु तींद्‌रे धड़े सी अलग हय्‌न चां आखी सुन्‌ली जागा हय, चां-चां जाय्‌न दुवा कर्‌या करतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ईसु काहनेस दाहड़े वात सीकाड़ने बाजी रवलु। फरीसी माणसे ने भगवानेन नीयम सीकाड़न्‌या मास्‌तर्‌या चां बस रवला। चे गलील जीलाम सी, ने यहुदीया जीलान गांवेडीट सी, ने यरुसलेम सहर सी आय रवला; ने मालीक-भगवानेन आरगाय आपणेन ताकत ईसु पुठ्‌ये हतली। ");
INSERT INTO bhi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ने देखु! तीनी टेम मां थुड़ाक माणसे लखवान मांदवाड़ वाळा माणसेक खाट्‌ली पर हाकलीन लाया ने चे जां ईसु हतलु, तीना घर मां ली जाय्‌न ईसु अगळ मेलने हींडतेला। ");
INSERT INTO bhi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","चां हुड़ु-हुड़ु माणसे हतला ने तीना लखवान मांदवाड़ वाळाक चां नी ली जाय सक्‌या, ने चे घर पर चहड़ी गुया, ने छतेन नळ्‌या हेड़ देदा। ने तीना लखवान मांदवाड़ वाळा माणुस काजे खाट्‌ली भेळुत ईसु अगळ उपर सी उतार देदा। ");
INSERT INTO bhi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ने तीना लखवा वाळा माणसे काजे लावण्‌यान भुरसु देखीन ईसु तीना लखवान मांदवाड़ वाळाक कह्‌यु, “ए माणुस! तु पाप ते करलु, बाकुन तुसेक तारा पापेन माफी जड़ गुयली छे।” ");
INSERT INTO bhi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","जी वात सामळीन यहुदी नीयमेन मास्‌तर्‌या ने फरीसी माणसे आपसा मनेम वीच्‌यार करीन कह्‌या, “जु कुण छे, गुयु भगवानेन नाव-बद्‌दी कर र्‌यु? भगवानेक छुड़ीन असु कुण छे, तीना पापी माणसे काजे माफी आपणेन हक छे?” ");
INSERT INTO bhi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","तींद्‌रा मनेम वीच्‌यार काजे जाणीन ईसु तीनाक कह्‌यु, “तुहुं आपसा मनेम असा वीच्‌यार करीन काहा वातेम लड़ाय रया? ");
INSERT INTO bhi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","काय कह्‌णु वारु छे? ‘तुसेक तारा पापेन माफी जड़ गुय’ कह्‌णु वारु छे की ‘उठ ने चाल फीर’ कह्‌णु वारु छे? ");
INSERT INTO bhi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","बाकुन माणसेन पुर्‌या काजे धरती पर पापीक माफी आपणेन हक छे, ज तुहुं जाण लेवु एरेन, मे असु कह्‌यु।” अळी ज कयदीन ईसु लखवान मांदवाड़ वाळाक कह्‌यु, उठ, “ने तारी खाट्‌ली हाकलीन तार घर जाती रव।” ");
INSERT INTO bhi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ने चु तत्‌यारुत आखा अगळ सी उठीन उबु हय गुयु, ने तारी खाट्‌ली हाकलीन भगवानेन बड़ाय करतु जाय्‌न हेरे घर जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ने चे आखान आखा चकराय्‌न भगवानेन गुण गावता र्‌या। तींद्‌रेम डर भराय गुयो, ने चे कह्‌तेला, “आज हामु भाती-भातीन काम देखला छे।” ");
INSERT INTO bhi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ने अळी ईसु बाहर नीकळ्‌यु। ती चु फाळु लेण्‌यान डाहला काजे फाळु लेणेन नाका पर बसीन फाळु उकाळतेलान देख्‌यु। तेरु नाव लेवी हतलु। ने ईसु तीनाक असु कह्‌यु, “मारु चेलु बणीन मार पछळ चाल पड़। ");
INSERT INTO bhi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ती चु फाळु लेण्‌यु आखो काम छुड़ देदु, ने उठीन ईसु पछळ चाली पड़्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","चु लेवी, ईसु काजे आपसे घर मां ली जाय्‌न बेसकी मटी पंगत कर्‌यु; ने फाळु लेण्‌या ने बेसका मेजवान्‌या ईसु भेळा रुटा खाणे बठ्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ने फरीसी माणसे ने यहुदी नीयम सीकाड़न्‌या कळे-कळे वात करीन ईसुन चेलान वात नीकाळीन तीनुक कह्‌या, “तुहुं फाळु उकाळन्‌या ने पापी माणसे साते बसीन काहा खावु-पीयु?” ");
INSERT INTO bhi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ज जाणीन ईसु तीनुक कह्‌यु, “वारलु काजे डाक्‌टर नी चाहजे, बाकुन मांदला काजे डाक्‌टर चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","मे धरमी माणसे नी, बाकुन पापी माणसेक पाप भीणी सी भगवान भीणी मन फेरवणे करीन, बुलावणे आवलु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","थुड़ाक माणसे ईसुक कह्‌या, “युहन्‌नान चेला ते अळी-अळीन उपास करे ने भगवान वाटे दुवा कर्‌या करे, ने असात फरीसी माणसेन चेला बी उपास करे बाकुन तारा चेला ते उपास करे पाखुर खाय ने पीये करे!” ");
INSERT INTO bhi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ईसु तीनुक कह्‌यु, “जत्‌यार लगुन अरात्‌या दुल्‌ला पुठ्‌ये रवे, तत्‌यार लगुन चे उपास करे काय? ");
INSERT INTO bhi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","बाकुन जे दाहड़ा बी आवसे, जत्‌यार दुल्‌लु तींद्‌रे सी अलग हय जासे, तत्‌यार चे तीनी टेम मां उपास पाळसे।” ");
INSERT INTO bhi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ईसु तीनुक एक दाखलु बी सामळायु, “कुय बी नवला पुथल्‌याम सी फाड़ीन, जुन्‌ला पुथल्‌या मां थीग्‌ळो नी लागाड़े। ने कदी लागाड़से, ती च नवलो पुथल्‌यो ते फाटीन बीगड़ी जासे, ने च नवला पुथल्‌यान थीग्‌ळो जुन्‌ला पुथल्‌या पुठ्‌ये मेळ बी नी खाय ");
INSERT INTO bhi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ने असात काहनाक जुन्‌ला चामड़ान थयला मां, नवला अंगुरेन रस नी भरे। असो भरसे, ती नवलु अंगुरेन रस, चामड़ान थयला काजे फाड़ देसे, ने असो करीन चामड़ान थयलु बी फाट जासे, ने नवलु अंगुरेन रस बी नाखायन उही जासे, ने रद हय जासे। ");
INSERT INTO bhi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","बाकुन अंगुरेन नवलु रस चामड़ान नवला थयला मां भरनु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","काहनुक माणुस बी जुन्‌लु अंगुरेन रस पीन, नवलु अंगुरेन रस पीणेन हेर नी करे, काहाकी जुन्‌लु अंगुरेन रस पीन कह्‌वे, की जुन्‌लु अंगुरेन रसुत वारु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ईसु ने तेरा चेला आरामेन दाहड़े गहुंन खेत मायन नीकळीन जाणे बाजी रवला। ने तेरा चेला गहुंन उम्‌ब्‌या तुड़ीन हाते सी चुळी-चुळीन खाता जातला। ");
INSERT INTO bhi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","तत्‌यार थुड़ाक फरीसी माणसे असा कह्‌णे बाजी गुया की, “ज काम आरामेन दाहड़े नी करनु चाहजे, बाकुन च काम तुहुं काहा करने बाजी र्‌या?” ");
INSERT INTO bhi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ईसु तीनुक कह्‌यु, “जत्‌यार दावुद ने तेरा साती भुकला हतला, ती दावुद काय कर्‌यु?” तुहुं ज नी भण्‌या काय? ");
INSERT INTO bhi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","चु भगवानेन मंदीर मां जाय्‌न भेटन रुटा ईछीन आपसु बी खादु, ने तेरा साते वाळा काजे बी खाणे करीन आप्‌यु। चे रुटा ते भगवानेन पुजाराक अतरात खाणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ने ईसु तीनुक अळी कह्‌यु, “माणसेन पुर्‌यु आरामेन दाहड़ान बी मालीक छे। माणसे काजे आरामेन दाहड़े काय करनु चाहजे, ने काय नी करनु चाहजे, तेरु फेसलु करनु मारा हक मां छे।” ");
INSERT INTO bhi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ईसु काहनेस दीसरे आरामेन दाहड़े भगवानेन भक्‌तीन घर मां जाय्‌न वात सामळावणे बाजी रवलु। ने चां एक माणुस हतलु, तेरु जेवड़्‌यु हात सुकी रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","यहुदी नीयम सीकाड़न्‌या ने फरीसी माणसे ईसुन गलती नीकाळने तकाय रवला, की ईसु आरामेन दाहड़े सुकला हात वाळाक वारु करे की नी करे ");
INSERT INTO bhi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","बाकुन ईसु तींद्‌रा वीच्‌यार जाणीन सुकला हात वाळाक कह्‌यु, “उठ ने ईचमां उबु हय गुया।” चु उठीन ईचमां उबु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ईसु तीनु माणसे काजे कह्‌यु, मे तुहुंक पुछो-आरामेन दाहड़े काय करनु वारु छे, भलाय करनु वारु छे की कुहराय करनु वारु छे, “ने जीव बचाड़नु वारु छे की मारनु वारु छे?” ");
INSERT INTO bhi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ती ईसु तीनु आखा माणसे पर नींगा नाखीन ईसु तीना माणुस काजे कह्‌यु, “तारु हात लांबु कर।” चु हात लांबु कर्‌यु ने तेरु हात वारु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","बाकुन भगवानेन धरमेन वात सीकाड़न्‌या ने फरीसी माणसे बेसका रीसाय पड़्‌या, ने आपसा-आपसात वीच्‌यार करीन असा कह्‌या, आपणु ईसुन वीरुद मां काय करजे? ");
INSERT INTO bhi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","तीनु दाहड़ा मायन एक दाहड़ु ईसु दुवा करने करीन बयड़ा पर गुयु, ने चां आखी रात भगवान सी दुवा करतु रयु। ");
INSERT INTO bhi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","जत्‌यार दाहड़ु उंग्‌यु, तत्‌यार ईसु हेरा चेला काजे साते बुलायु, तींद्‌रेम सी देखीन बारे जणा काजे नेवाड़ीन तीनुक, खुस-खबरेन नेवताळा बणायु। ");
INSERT INTO bhi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","सीमोन काजे; हेरो नाव ईसु पतरस बी पाड़्‌यु; तेरा भायस अन्‌दीरीयास; काजे; ने याकुप ने युहन्‌ना काजे; ने फीलीप्‌पुस काजे; ने बरतुल्‌मे काजे; ");
INSERT INTO bhi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ने मत्‌‌ती काजे; ने थोमा काजे; ने हलफाईन पुर्‌यु याकुप काजे; ने सीमोन काजे, जु भगत कह्‌वायतेलु, ");
INSERT INTO bhi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ने याकुपेन पुर्‌यु यहुदा काजे, ने यहुदा ईस्‌करीयोत काजे; जु ईसु काजे धरावण्‌यु बण गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ईसु तींद्‌रे पुठ्‌ये बयड़े सी उतरीन एक सोवताळ जागा मां उबु हय गुयु। चां तेरा दीसरा चेला बी हतला। अतरात नी, बाकुन चां माणसेन एक बेसकु मट्‌लु टुळु बी हतलु तीना टुळाम आखा यहुदीयान ने यरुसलेमेन ने दरीयान धड़े वाळा सुर ने सेदा सहरेन माणसे बी हतला। ");
INSERT INTO bhi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","चे ईसुन वारलु वात सामळीन ने आपसी मांदवाड़ सी वारु हवणे करीन आय रवला, ईसु धड़े आवीन तीनुक वारु कर्‌यु। भुतड़ान आत्‌मा सी वेला पाड़ायलाक बी ईसु, तीनु आत्‌मान हाते मां सी छुड़ावीन वारु करतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","आखा माणसे ईसु काजे छीमणे हींडतेला, काहाकी ईसु मां सी ताकत नीकळीन आखा काजे वारु करतेली। ");
INSERT INTO bhi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ईसु आपसा चेला भीणी देखीन कह्‌यु, बरकतवाळा छे तुहुं, जे हय गरीब छे! काहाकी भगवानेन राज तींद्‌रोत छे। ");
INSERT INTO bhi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","बरकतवाळा छे तुहुं, जे हय भुकला छे! तुहुं आफरी जासु। बरकतवाळा छे तुहुं, जे हींताळ रड़ र्‌या! तुहुं अळी खुस हय्‌न हास्‌सु। ");
INSERT INTO bhi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","बरकतवाळा छे तुहुं, जत्‌यार माणसे तुंद्‌री नाव-बद्‌दी करे, ने तुंद्‌री वात काट देसे, ने तुहुंक नेवाड़ देसे; ने तुहुंक वीटेळ्‌ळा कय्‌न, तुहुंक जात सी बाहर कर देसे। काहाकी तुहुं माणसेन पुर्‌याक ईसुक मानु! ");
INSERT INTO bhi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","जत्‌यार असो हय ती, तुहुं खुस हय्‌न नाच्‌जु, काहाकी सरग मां तुहुंक बेसकु मटु ईनाम जड़से, तुहुंक वेला पाड़न्‌यान आड़ा-बुड़ा बी भगवानेन अघली वात बताड़न्‌या माणसे काजे असात वेला पाड़्‌या करतेला। ");
INSERT INTO bhi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","बाकुन गरा तुंद्‌रे पर; जे हय लकपती छे; काहाकी तुहुं पेहेल सी मजा ली लेदा। ने तुंद्‌रे वाटे काय बी सुक नी बच्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","गरा तुंद्‌रे पर; जे हींताळ आफरला छे, तुहुं अळी भुकला रवसु। गरा तुंद्‌रे पर; जे हींताळ हासी र्‌या! काहाकी तुहुं अळी कलपसु ने कलपी-कलपीन रड़सु। ");
INSERT INTO bhi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","गरा तुंद्‌रे पर; जत्‌यार आखा माणसे तुंद्‌री वात काटे बीगुर, जलम तुहुंक वारु कह्‌वे, काहाकी हींद्‌रा आड़ा-बुड़ा बी भगवानेन नाव लीन लुच्‌चाय मेकण्‌या माणसे काजे, तुहुं बेसका वारु कय्‌न असुत वेहवार करला। ");
INSERT INTO bhi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“बाकुन मे मारी वात सामळने वाळा काजे कह्‌वो: आपणा दुस्‌मन सी वारु रहु; जे तुंद्‌री कुहराय करे, तींद्‌रो भलो करु।” ");
INSERT INTO bhi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","जे तुहुंक सराप आपे, तीनुक तुहुं बरकत आपु। जे तुंद्‌री वात कहीन तुंद्‌रु अपमान करे तींद्‌रे वाटे दुवा करु। ");
INSERT INTO bhi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","जो तुंद्‌रा एक गाल पर थापड़ देय, तेरे भीणी दीसरु गाल बी फेरवी देजु। जु तुंद्‌रु कुट बी हापके हीनाक आपणु कुरतु बी लेणी देवु। ");
INSERT INTO bhi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","जु तुंद्‌रे धड़े मांगे, ती तीनाक तुहुं आप देजु, ने जु तुंद्‌रे धड़े तारी चीज हापकी लेय, तेरे धड़े पछु मांगणेन हेर मां करु। ");
INSERT INTO bhi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ने तीना वेहवार काय दीसरा धड़े तुहुं चाहु की चु वेहवार तुहुं दीसरा साते बी कर्‌या करु। ");
INSERT INTO bhi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","कदी तुहुं आपणा परम राखणेवाळा सी परम करु, चे तुहुंक परम करे, ती तुहुंक बरकत जड़से काय? काहाकी पापी माणसे बी तीनु काजे परम करे, जे तीनुक परम कर्‌या करे। ");
INSERT INTO bhi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","कदी तुहुं तींद्‌री भलाय करु, जे तुंद्‌री भलाय करे, ती तुहुंक बरकत जड़से काय? काहाकी पापी माणसे बी, जे तींद्‌री भलाय करे, तींद्‌रोत भलो करे। ");
INSERT INTO bhi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","कदी तुहुं तीनु काजे उधार आपु, जे उधार लेदलो तुहुंक पछो आपी देय, ती हेरेम तुहुंक काय बरकत जड़से? काहाकी पापी बी उधार आप्‌लो चो पछो आप देसे करीन उधार आपे। ");
INSERT INTO bhi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","बाकुन आपणा वेरी सी परम करु, ने तींद्‌री भलाय करु, ने मे काहलाक काजे उधार आपीस, ती चु उधार आप्‌लो चो पछो नी आपे, असी आस करीन उधार आपु। ने तीत तुहुं काजे बेसकु मटु ईनाम जड़से; ने तुहुं आखान डाहला भगवानेन पुर्‌या-पारी बण जासु, काहाकी भगवान तींद्‌रे पर बी दया करे, जे भगवान धड़े सी हात करीन बी भगवान काजे बेसकु वारु छे नी कह्‌वे, ने तींद्‌रे पर बी दया करे, जे कुहराय कर्‌या करे। ");
INSERT INTO bhi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","जसु तुंद्‌रु सरग वाळु भगवान बास दयाळु छे, तसात तुहुं बी दयाळा बणु। ");
INSERT INTO bhi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ने काहनाक बी नीयाव मां करु, ती तुंद्‌रु नीयाव नी हवे; तुहुं कुय पर गुनु मां लागाड़ु, ती तुंद्‌रे पर बी गुनु नी लागाड़े। दीसराक माफी आपु ती तुहुंक बी माफी जड़ जासे। ");
INSERT INTO bhi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","आपु ती तुहुंक बी भगवान आपसे, दड़पी-दड़पीन ने हालाड़ी-हालाड़ीन भरीन तुंद्‌रा खुळाम पड़से; काहाकी तीना नाप सी तुहुं नापसु तीनीत नापे तुंद्‌रे वाटे बी नापायसे। ");
INSERT INTO bhi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ईसु तीनुक एक अळी दाखलु दीन सामळायु आंधळु आंदळा काजे वाट देखाड़ सके काय? नी देखाड़ सके। कदी देखाड़से, ती दुय जणा गड्‌डा मां हीट पड़से। ");
INSERT INTO bhi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","चेलु मास्‌तर सी मटु नी हय, बाकुन पुरी-पुरी वात सामळीन चालसे ती चु आपसा मास्‌तरेन तसु बण जासे। ");
INSERT INTO bhi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","जत्‌यार तुहुंक आपसा डुळा अगळ देवायलु डेंगु नी देखायतु, ती तुहुं आपसा भायसेन डुळाम भरायलु कचरु काहा देख र्‌या? ");
INSERT INTO bhi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","जत्‌यार तुहुंक आपसात डुळा अगळ देवायलु डेंगु नी देखायतु ती आपसा भायस काजे कसा कह्‌सु की, भायस! मेसेक तारा डुळाम भरायलु कचरु नीकाळने दे? ए ढंगड़ा करन्‌या! पेहले आपसात डुळा अगळ देवायलु डेंगु छेटे कर ले। तीत तुसेक आपसा भायसेन डुळाम भरायलु कचरु नीकाळने टेमे वारु देखायसे। ");
INSERT INTO bhi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","असो काहनो बी वारलु झाड़को नी हय, तेरेमां रीकामो फळ लागतो हय, ने असो काहनु बी रीकामु झाड़कु नी हय, जो वारलु फळ लावतो हय। ");
INSERT INTO bhi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","आखा झाड़कान उळखाण तींद्‌रा फळ सी हये। काहाकी माणसे काटाळ्‌या झाड़काम सी, अंजीरेन फळ नी तुड़े; ने काटाळ्‌ळा झाड़काम सी अंगुरेन फळ नी तुड़े। ");
INSERT INTO bhi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","भलु माणुस आपसा मन सी भलाय वात नीकाळे; ने भुंडुत माणुस आपसा मन सी कुहरायन वात नीकाळे; काहाकी जो मनेम भरायलो रहे, चीत वात तेरा मुंहडाम सी नीकाळे। ");
INSERT INTO bhi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“मे जो कह्‌वो च ते तुहुं मान्‌ता नी, ती तुहुं मेसेक ए मालीक, ए मालीक! काहा कय र्‌या? ");
INSERT INTO bhi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","जु मारे साते आवीन मारी वात सामळे ने तीनी वातेक मानीन जीवे, तेरे बारामां मे कह्‌वो की चु कुणीन तसु छे? ");
INSERT INTO bhi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","चु तीना माणसेन तसु छे, जु घर बणावणी टेमे उंडुत पायु खुद्‌यु ने तीना घरेन पायु ढाटा पर सी उठाड़ीन घर बांदीन बणायु। अळी जत्‌यार नदी आवी, ने पाणीन झलक तीना घरेन आफटायु, बाकुन ची झलक तीना घर काजे उदारी नी, काहाकी च घर बेसको पक्‌को बन्‌लो हतलो। ");
INSERT INTO bhi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","बाकुन जु मारी वात सामळे, ने तीनी वात काजे मानीन नी जीवे, चु तीना माणुस जसु छे, चु धुळाम पायु खुदीन पायु बांदे पाखुर, घर बांदीन बणायु, ने पाणीन झलक तीना घरेन आफटायु, ती चो घर तत्‌यारुत उदरी गुयो, ने खत्‌तम हय गुयो।” ");
INSERT INTO bhi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","जत्‌यार ईसु माणसेक आखी वात सामळाय देदु, ने अळी कफरनहुम सहर मां पछु गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","चां एक सुबेदार हतलु, तेरु एक पावर्‌यु हतलु, तीना पावर्‌या काजे, चु सुबेदार बेसकु परम करतेलु। चु पावर्‌यु बेसकु जबर मांदु पड़ रवलु, ने चु मरने वाळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","चु सुबेदार ईसुन बारामां सामळ्‌यु, ने अतराम चु यहुदी माणसेन थुड़ाक डाहलास अदमी वाटे ईसु धड़े असी वीन्‌ती कय मकल्‌यु, तु आय्‌न मारा पावर्‌या काजे वारु करीन बचाड़ ले। ");
INSERT INTO bhi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","चे ईसु धड़े आवीन असी वीन्‌ती कर्‌या, जु सुबेदार बेसकु वारु माणुस छे, अतरे तु तेरी मदत कर। ");
INSERT INTO bhi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","काहाकी हयु हामरा माणसे सी परम करे, ने हामरे वाटे भगवानेन भक्‌तीन घर बणाय मांग्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ईसु तींद्‌रे पुठ्‌ये चाल पड़्‌यु, ने ईसु तेरे घर धड़े पुगणे वाळु हतलु। ती सुबेदार आपसा दुस्‌तीदार्‌यान साहरे ईसु भीणी असो कय मकल्‌यु, “ए मालीक!” तु वेला करीन अगु मां आवे काहाकी मे अतरु मटु नी हय की तु मारा घरेन साहळे आवे। ");
INSERT INTO bhi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","मे असु लग नी समजी गुयु ने तुसेक भेळु हवणे लग नी आयु, बाकुन जात रय्‌न तु एकुत बुल कय दे, ती मारु पावर्‌यु वारु हय जासे। ");
INSERT INTO bhi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","मे बी दीसरान हक मां रवण्‌यु एक नानुस हकदार्‌यु छे। मारा हक मां सीपायड़ा रवे। जत्‌यार मे एक जणा काजे जां कह्‌वो, ती चु जाय ने दीसरा काजे आव कह्‌वो ती चु आवे ने मारा काहनाक पावर्‌या काजे ज कर कहं; ती चु तीना काम काजे करे। ");
INSERT INTO bhi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","जी वात सामळीन ईसु चकराय गुयु ने, चु आपसे पछळ आवतेला माणसे भीणी देखीन असु कह्‌यु, “मे तुहुंक ज कहं की ईस्‌रायेली माणसे मां बी मेसेक अतरु पाक्‌कु भुरसु देखणे नी जड़्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ने तीनु माणसे काजे सुबेदार मकेल्‌लु, चे माणसे पछा घर जाय्‌न तीना मांदला पावर्‌या काजे वारलु देख्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","दीसरे दाहड़े, ईसु नाईन नावेन सहर मां गुयु। ईसुन चेला ने माणसेन एक मट्‌लु टुळु बी ईसु साते हतली। ");
INSERT INTO bhi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","जसा चे सहरेन बारना धड़े पुग्‌या, तीनुक थुड़ाक माणसे सोवताळ जागा मां आवतेला भेळा हया। चे एक मरला माणसे काजे गाड़ने ली जाणे बाजी रवला। मरलु माणुस एक रांडायली बायरीन एकुत पुर्‌यु हतलु। माणसेन एक मट्‌लु टुळु रांडायली साते हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","तीनीक देखीन मालीक ईसु काजे बेसकी दया आवी। ने ईसु तीनीक असु कह्‌यु, “रड़े मां।” ");
INSERT INTO bhi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","तत्‌यार चु सीवड़ी धड़े गुयु ने सीवड़ी काजे धर्‌यु। सीवड़ी हाकलने वाळा उबा रय गुया। तत्‌यार ईसु मरला काजे कह्‌यु, “ए जुवान उठ!” ");
INSERT INTO bhi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","मरलु तत्‌यारुत उठीन बसी गुयु, ने वात करने बाजी गुयु! ईसु तीनाक तेरी मायन सुपरुत कर देदु। ");
INSERT INTO bhi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","आखा माणसे बेसका जबर बीही गुया, चे भगवानेन बड़ाय करता जाय्‌न असा कह्‌या, “भगवान आपसे वाटे माणुस काजे हामरे मां सी उबु करलु छे। छाचलीन भगवान आपसुत, आपसा माणसेक बचाड़ने आवलु छे!” ");
INSERT INTO bhi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ईसुन ईना वारु कामेन खबर आखा यहुदा जीला मां, ने आड़े-धड़ेन आखा जागा मां जाती रया। ");
INSERT INTO bhi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","युहन्‌नान चेला युहन्‌ना काजे ईनी आखी वातेन खबर आप्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","तत्‌यार युहन्‌‌‌नु आपसा चेला मायन दुय चेला काजे बुलायन मालीक ईसु धड़े ज पुछणे मकल्‌यु, “आवणे वाळु मसी तुत छे काय, की हामु काहनाक दीसरान वाट देखजे काय?” ");
INSERT INTO bhi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ने जे दुय चेला ईसु धड़े आय्‌न कह्‌या, “बपतीस्‌मा आपण्‌यु युहन्‌‌‌नु हामुक तारे धड़े ज पुछणे मकेल्‌लु छे, की आवणे वाळु मसी तुत छे काय, की हामु काहनाक दीसरान वाट देखजे काय?” ");
INSERT INTO bhi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","तीनी टेमे ईसु बेसका मांदला माणसेक, मांदवाड़ मां सी, ने हीड़ा-पीड़ाम सी, ने भुतड़ान आत्‌मान कब्‌जाम सी छुड़ायु; ने बेसका आंदळान डुळा उगाड़ देदु, ने चे देखणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ने ईसु युहन्‌नान चेला काजे कह्‌यु, “ज काय तुहुं देख्‌या ने सामळ्‌या, च युहन्‌ना काजे जाय्‌न कय देवु, की आंदळा देखणे बाजी गुया ने, लंगड़ा चालने फीरने बाजी गुया, कुड़ायला वारु हय्‌न चुखा हय गुया; ने मरला जीवता हय गुया, ने गरीब काजे खुस-खबरेन वात सामळावे। ");
INSERT INTO bhi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ने वारु छे चु, जु मार पर पाक्‌कु भुरसु करे!” ");
INSERT INTO bhi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","बपतीस्‌मा आपण्‌या युहन्‌नान साहरे मकेल्‌ला पछा जात रया, तत्‌यार ईसु बपतीस्‌मा आपण्‌या युहन्‌नान बारामां कह्‌णे बाजी गुयु, तुहुं उजाड़्‌या बयड़ा मां काय देखणे गुयला? वाहळा मां हालतेला सुट्‌या देखणे गुयला काय? ");
INSERT INTO bhi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","कहुं ते खरा! तुहुं काय देखणे गुयला? चमकण्‌या पुथल्‌या पेहरला माणसेक देखणे गुयला काय? देखु, जे चमकण्‌या पुथल्‌या पेहरे ने मुजा मस्‌ती मां रवे, चे माणसे ते मट्‌ली हवेली मां रहे। ");
INSERT INTO bhi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","असो नी हय ती तुहुं काय देखणे गुयला? काहनाक भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळा काजे देखणे गुयला काय? छाचलीन! मे तुहुंक कहं, जतरा बी माणसे भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या हतला, तीनु आखा सी युहन्‌‌‌नु मटु माणुस छे, तीनाक तुहुं देखणे गुयला। ");
INSERT INTO bhi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ने हयुत युहन्‌‌‌नु छे, तेरा बारामां लिखलो छे, की सामळ! मे मारु काहवाळ्‌यु तारे सी पेहेल मकलीस। चु तारे अगळ तारे वाटे वाट सुदारसे। ");
INSERT INTO bhi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","मे तुहुंक कह्‌वो, माणसे मां बपतीस्‌मा आपण्‌या युहन्‌ना सी मटु कुय नी हय। तेबी, मे कह्‌वो की भगवानेन राज मां, जु आखाम सी नानु छे, चु बपतीस्‌मा आपण्‌या युहन्‌ना सी बी मटु छे। ");
INSERT INTO bhi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ने आखा माणसे ने फाळु लेण्‌या बी बपतीस्‌मा आपण्‌या युहन्‌नान सामळीन, बपतीस्‌मा आपण्‌या युहन्‌ना धड़े बपतीस्‌मा लेदा ने भगवानेन मरजी पुरी कर्‌या ने भगवान काजे छाचु मान लेदा। ");
INSERT INTO bhi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","बाकुन फरीसी माणसे ने कायदु सीकाड़न्‌या मास्‌तर्‌या, बपतीस्‌मा नी लेदा ने आपसा बारामां भगवानेन मरजी टाळ देदा। ");
INSERT INTO bhi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","बाकुन मे ईनी पीड़ीन माणसे काजे कसु उळखो? ने कुणीन तसा छे करीन कह्‌वो? ");
INSERT INTO bhi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","हीया हाटे मां बठी रवण्‌या पुर्‌यान तसा छे, जे आंबा-सांबा आयड़ीन कहें; की हामु तुंद्‌रे वाटे नाचाड़ने करीन पावळी आजाड़्‌या, ने तुहुं नी नाच्‌या, हामु तुंद्‌रे वाटे रड़ने कलपणेन गीत गाया बाकुन तुहुं नी रड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","काहाकी बपतीस्‌मा आपण्‌यु युहन्‌‌‌नु रुटु बी नी खादु ने अंगुरेन रस बी नी पीदु, ने तुहुं मेसेक कय रया की हेरे भुतड़ु लाग र्‌यु करीन। ");
INSERT INTO bhi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","अळतेन माणसेन पुर्‌यु बणीन आयु, ने खातु-पीतु आय र्‌यु; ने तुहुं कहुं, देख हयु माणुस; हीजेरलु ने पीण्‌यु छे, ने फाळु लेण्‌यान ने पापी माणसेन दुस्‌तीदार छे। ");
INSERT INTO bhi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","बाकुन भगवानेन अकल, भगवानेन आखा पुर्‌या-पारी वाटे, पुरावा भेळे उजेंती हवणे बाजी रय। ");
INSERT INTO bhi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","काहनुस फरीसी माणसे ईसु काजे आपसे घर खाणेन वीन्‌ती कर्‌यु; ती ईसु तीना फरीसी माणसेन घर आवीन रुटा खाणे बठ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ने सामळु, तीना सहरेन एक पापी बायर काजे ज मालुम हय गुयो की ईसु फरीसी माणसेन घर मां रुटा खाणे बाजी र्‌यु। ची चां संगमरमर नावेन दगड़ान ठाहरु मां बेसकी महंग्‌लो ईत्‌तर लीन आवी। ");
INSERT INTO bhi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ने ची पापी बायर रड़ती जाय्‌न, ईसुन पाय धड़े उभी रय गुय, ने तेरा आसा ईसुन पाये पर चुह्‌वाड़ीन ईसुन पाय काजे भीग्‌वणे बाजी गुय, ने ईसुन पाय काजे आपसा कान्‌या सी नुछी, ने पाये गुळु दीन पाये पर ईत्‌तर लागाड़ी। ");
INSERT INTO bhi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ज आखो देखीन, फरीसी माणुस, जु ईसु काजे खाणे करीन वीन्‌ती करलु, चु आपसा मन मां कह्‌यु, “कदी जु भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळु माणुस रवतु, ती जु छाचलीन जाणी जातु की, जी बायर हीनाक छीमणे बाजी रय, ची कुण छे, ने कसली छे, हयी ते पापी बायर छे।” ");
INSERT INTO bhi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","तेरा मनेम वात जाणीन ईसु तीना फरीसी माणसे काजे कह्‌यु, “सीमोन, मे तुसे काहींग कह्‌णे हींडो।” चु सीमोन ईसु काजे जपाप आप्‌यु, “ए मास्‌तर, कव।” ");
INSERT INTO bhi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ईसु कह्‌यु की “काहनाक सवकारेन दुय करजा वाळा हतला, एक जणु पांच सोव रुप्‌यान करजा वाळु हतलु, ने दीसरु पचास रुप्‌यान करजा वाळु हतलु ");
INSERT INTO bhi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","बाकुन तींद्‌रे धड़े मालीक काजे करजु देणे काय नी हतलो, अतराम सवकार दुय जणाक माफी आप देदु। हय मे कहं, तीनु मायन कुण तीना सवकारेक परम करसे?” ");
INSERT INTO bhi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","सीमोन कह्‌यु, “मारी नींगा मां, चु जादात परम करसे जेरु जादा करजु माफ हयु।” ईसु तीनाक कह्‌यु, “तु सय वीच्‌यारीन कह्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ने ईसु तीनी बायरी भीणी देखीन, सीमोन काजे कह्‌यु, “ईनी बायरीन बारामां वीच्‌यार ते कर? मे तारे घर आयु, ने तु मेसेक पाय धुवणे, पाणी लग नी आप्‌यु, बाकुन जी मारा पाय आसा सी धुवी ने कान्‌या सी नुछी।” ");
INSERT INTO bhi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ने तु मेसेक गुळु नी देदु, बाकुन जत्‌यार सी मे ईना घर मां आयु, तत्‌यार सी हय लग, जी मारे पाये गुळा दी रय। ");
INSERT INTO bhi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ने तु मार मुणका पर जेतुनेन झाड़कान तेल नी चुपड़्‌यु, बाकुन जी मारा पाये पर ईत्‌तर चुपड़्‌ली छे। ");
INSERT INTO bhi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","तेरेसी मे तुसेक कहं, “हेरा बेसका जादा पाप हतला, बाकुन ईनीक माफी जड़ गुय। काहाकी जी बेसकी परम करे। बाकुन तीनाक जाराक माफी जड़ी, चु जाराक परम करे।” ");
INSERT INTO bhi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ने अळी ज कयदीन ईसु तीनी बायरीक कह्‌यु, “तारा पापेन माफी तुसेक जड़ गुय।” ");
INSERT INTO bhi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ने तीनी टेम मां जे माणसे ईसु पुठ्‌ये रुटा खाणे बसला, चे आपसा मनेम असा वीच्‌यार करने बाजी गुया की हयु कुण छे, जु पापेन माफी बी आपे? ");
INSERT INTO bhi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","बाकुन ईसु तीनी बायरी काजे कह्‌यु, “तारु भुरसु तुसेक बचाड़ लेदलु छे। ने तु सांती सी जाती रव।” ");
INSERT INTO bhi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","पछेन असो हयो की ईसु भगवानेन राजेन खुस-खबर माणसे काजे सामळावतु जाय्‌न सहर-सहर ने गांव-गांव फीरने लाग्‌यु, ने बारे चेला तेरे पुठ्‌ये हतला। ");
INSERT INTO bhi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ने थुड़ाक ईसु पर भुरसु करन्‌या बायरा बी हतला, तीनुक ईसु भुतड़ान आत्‌मान कब्‌जाम ने मादवाड़ कब्‌जाम सी छुड़ावीन, ने चां तींद्‌रे मायन, मरीयम, तेरो नाव मगदलनी हतलो, ने तेरेमां सी ईसु सात भुतड़ान आत्‌मा नीकाळलु। ");
INSERT INTO bhi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ने राजा हेरोदेसेन मंत्‌री खुजान घरवाळी योअन्‌ना ने सुसन्‌ना, बेसका दीसरा बायरा आपसा पयस्‌या आपीन ईसुन ने तेरा चेलान चाकरी करतेला। ");
INSERT INTO bhi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","जत्‌यार बेसकु मटु माणसेन टुळु, भेळु हवणे बाजी रवलु, ने सहर-सहर मां सी माणसे ईसु धड़े आवणे बाजी रवला तीनी टेम मां ईसु ज दाखलु सामळायु: ");
INSERT INTO bhi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","काहनुक किरसाण माणुस बीज एरने गुयु, ने एरता एरतान थुड़ाक बीज वाट पर पड़्‌या। चे बीज माणसेन पाय तळे कुचाय गुया ने सरगेन चिरला आवीन तीनु बीज काजे ईछीन खाय गुया। ");
INSERT INTO bhi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ने थुड़ाक बीज चापर्‌या वाळी जागाम पड़्‌या। ने पाणी नी जड़्‌यो, अतराम चे उंगी गुया ने चीमायन सुकी गुया। ");
INSERT INTO bhi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ने थुड़ाक बीज काटासळ्‌या झाड़का मां पड़्‌या, ने काटासळ्‌या झाड़का मटा हय्‌न तीनु उंगला बीजेक दड़पी देदा; ने मेर नी पाकी। ");
INSERT INTO bhi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ने थुड़ाक बीज वारलु जागाम पड़्‌या, “ने चे उंग्‌या ने सोव गुणा फळ लाया।” अतरो कय दीन अळी ईसु जुर सी आयड़ीन कह्‌यु, “जतरा बी सामळी र्‌या, चे वारु सामळीन समजणु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ईसुन चेला ईसु सी असा पुछ्‌या, “ईना दाखलान मतलब काय छे?” ");
INSERT INTO bhi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ने ईसु तीनुक कह्‌यु, तुहुं काजे भगवानेन राजेन सातायली वात जाणनेन समज भगवान आपलु छे, पर तुहुंक छुड़ीन दीसरा काजे दाखलान साहरे भगवानेन वात सामळावो, हेरेसी की तीनुक देखीन बी वारु नी देखाये तसों, ने सामळीन बी, नी समजे। ");
INSERT INTO bhi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","दाखलान मतलब ज छे; बीज भगवानेन बुल छे। ");
INSERT INTO bhi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ने वाटे पर पड़ला बीज तीनु माणसेन सहलाणी छे; जे भगवानेन बुल सामळे ते खरा, बाकुन भुतड़ु आवीन तींद्‌रा मनेम सी भगवानेन बुल ईछी ली जाय, कांखुर मायन असो नी हय जाय की चे भुरसु करीन छुटकारु हात कर लेय। ");
INSERT INTO bhi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","चापर्‌या वाळी जागा पर पड़ला बीज, तीनु माणसेन सहलाणी छे, जे भगवानेन बुल सामळतात खुस हय्‌न मानी लेय, बाकुन तींद्‌रा जड़े उंडा नी धरने सी चे थुड़ाक दाहड़ा लग भुरसु करे, ने पारखणेन टेम आवे, ती भुरसु छुड़ देय। ");
INSERT INTO bhi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","जे बीज काटाळ्‌या झाड़काम पड़्‌या, चे बीज तीनु माणसेन सहलाणी छे, जे भगवानेन बुल सामळे ते खरा, बाकुन अगा जाय्‌न चे ईनी जीवनेन फीकुर मां, ने माल धन कमायणे मां, ने ईनी जीवनेन मुजा मस्‌ती मां भेसकायन ने भगवान आपलु तीनी जीवनेन पुरो फळ नी लावे। ");
INSERT INTO bhi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ने वारलु जागाम पड़ला बीज, तीनु माणसेन सहलाणी छे, जे भगवानेन बुल सामळीन भुळा ने वारु मन मां जापताये मेले, ने भगवान काजे गमे तसों काम करता जाय्‌न दम धरीन भगवान वाटे जलम पुरो फळ लावे। ");
INSERT INTO bhi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","कुय बी दिवु धपाड़ीन ठाहरा तळे नी मेके, ने नी खाट्‌ली तळे मेके, बाकुन चु तीनाक दीवाळ्‌या मां मेके, तेरे वाटे माहें आवणे वाळा माणसे काजे वीजाळा मां वारु देखाये। ");
INSERT INTO bhi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","असो काय बी सातायलो नी हय, च उजेंतो नी हवे, ने असो काय बी ढाकायलो नी हय, च उजन्‌तो नी हवे। ");
INSERT INTO bhi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“तेरेमां तुहुं हेरा बारामां चेतीन रहु की तुहुं कसा सामळु? काहाकी जेरे धड़े काहींग छे, तीना काजे अळी बी आप देसे; ने जेरे धड़े काय नी हय, तेरे धड़े जो बी हसे चो बी पछु ली लेसे, तीनाक चु आपणोत समजे।” ");
INSERT INTO bhi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ईसुन माय ने भाय तीनाक भेळा हवणे आया, बाकुन बेसकी गड़दी हतली, चे तीनाक भेळा नी हय सक्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ने माणसे ईसुक असा कह्‌या, “तारी माय ने तारा भायस बाहर उबा हय रया, चे तुसेक बाहर भेळा हवणे हींडे।” ");
INSERT INTO bhi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ईसु तीनु माणसे काजे असु कह्‌यु, “मारी माय ने मारा भायस जेत छे, जे भगवानेन बुल सामळे, ने माने।” ");
INSERT INTO bhi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","एक दाहड़ु ईसु आपसा चेला काजे असु कह्‌यु, “चालु आपणु दरीयान पली धड़े जाजे।” ने चे ढंड्‌या मां बस गुया, ने पली धड़े जाणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ढंड्‌यो पाणी मां जाणे बाजी रवलो, ने ईसु सुय गुयु; तीनी टेमे दरीया मां आंधी आवी, ने ढंड्‌या मां पाणी भरायणे बाजी गुयो, ने चे आफत मां पड़ गुया। ");
INSERT INTO bhi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","तत्‌यार चेला ईसु धड़े आवीन तीनाक जागाड़्‌या ने कह्‌या, “ए मालीक! ए मालीक! हामु डुबणे बाजी र्‌या।” तत्‌यारुत ईसु जाग गुयु, ने चु आंधी काजे ने दरीयान झलक काजे झीचकार्‌यु, ने आंधी ने दरीयान झलक सेळी पड़ गुय। ");
INSERT INTO bhi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ने ईसु आपसा चेलाक असु कह्‌यु, तुंद्‌रु भुरसु कां छे? बाकुन चे बीही गुया, ने चे चकराय गुया, ने चे-चेत असा कह्‌या, “जु असु काहनु माणुस छे? चु आंधी ने पाणी काजे लग हुकुम आपे, ने चे हेरी वात माने।” ");
INSERT INTO bhi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","अळी चे ढंड्‌याम सी उतरीन गीरासेन्‌यान ईलाका मां पुग्‌या, ज गलीलेन दरीयान पली धड़े हतलो। ");
INSERT INTO bhi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ईसु जसु ढंड्‌याम सी उतर्‌यु, तत्‌यार तीना सहर वाळु एक माणुस ईसु धड़े आयु। तेरे बेसका भुतड़ा लागी रवला। ने चु बेसका दाहड़ा सी पुथल्‌या नी पेहरतेलु, ने घर मां नी रवतेलु, बाकुन मसाण्‌या मां रया करतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","भुतड़ान आत्‌मा लागली माणुस ईसु काजे देखीन आयड़ी पड़्‌यु, ने पाये पड़ीन जुर सी असु कह्‌यु, “ए आखान डाहला जुर भर्‌या भगवानेन पुर्‌या ईसु! मार साते तारो काय काम छे? मे तारे धड़े लीलघायो की, मेसेक वेला मां पाड़े।” ");
INSERT INTO bhi_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","भुतड़ान आत्‌मा तेरे अळी-अळीन चस्‌टी जातला, ने तीना माणसे काजे आपसा कब्‌जा मां कर लेदला; अतरोत नी बाकुन, माणसे तीना माणसे काजे साकळ्‌या ने कड़ा, सी बांदीन कब्‌जाम करतेला, तेबी चु, चे साकळ्‌या ने कड़ा तुड़ देदलु, ने ची आत्‌मा तीना माणसे काजे उजाड़्‌या बयड़ा मां, जां-चां लीन फीरतेला। ईसु भुतड़ान आत्‌मा काजे तीना माणुस मां सी नीकळनेन हुकुम आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ईसु तीना माणसे काजे पुछ्‌यु, “तारो नाव काय छे, चु कह्‌यु ‘सेना’ काहाकी तीना माणुस मां बेसका भुतड़ा भराय रवला।” ");
INSERT INTO bhi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ने तीना माणसेम भरायला भुतड़ान आत्‌मा, ईसु काजे अळी-अळीन असी वीन्‌ती कर्‌या: हामुक मापाये नी तसला उंडला डहराम जाणेन हुकुम मां आपे। ");
INSERT INTO bhi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","चां बयड़ा पर सुहर्‌यान एक बेसकु मटु टुळु चरने बाजी रवलु। अतरे तीना माणसेम भरायली आत्‌मा ईसु धड़े असी वीन्‌ती कर्‌या, “हामुक सुहर्‌या मां भरायणेन हुकुम आप दे। अतरे ईसु तीनु भुतड़ान आत्‌मा काजे हुकुम आप देदु।” ");
INSERT INTO bhi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","तत्‌यार भुतड़ान आत्‌मा तीना माणुस मां सी नीकळीन सुहर्‌या मां भराय गुया, ने चु सुहर्‌यान टुळु जुर सी ढासीन कड़खाम सी दरीया मां कुद पड़्‌यु ने पाणी मां डुबीन मर गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ज देखीन सुहर्‌या काजे चारने वाळा ढास गुया, ने चे सहरेम ने गांव मां जाय्‌न ज बी हयो तेरे बारामां कय देदा। ");
INSERT INTO bhi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ने ज हयो च देखणे करीन सहर वाळा माणसे सहरेम सी नीकळीन आया, ने चे ईसु साते आवीन तीना माणसे काजे देख्‌या, तीनाम सी ईसु भुतड़ान आत्‌मा नीका‌ळु हतलु, चु माणुस पुथल्‌या पेहरीन हुगु हय्‌न, ईसुन पाय धड़े बस रवलु। ने चे तीनाक देखीन बीही गुया। ");
INSERT INTO bhi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","चे ज आखो तींद्‌रे डुळे सी देख्‌णे वाळा, चे माणसे काजे आखी वात कह्‌या, की काहनी भाते भुतड़ान आत्‌मा सी भरायलु माणुस वारु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","तत्‌यार गीरासेन्‌यान ईलाका वाळा माणसे ने आड़े-धड़ेन आखा माणसे ईसु धड़े असी वीन्‌ती कर्‌या, तु हामरे धड़े सी जात रव, काहाकी चे बेसका बीही गुयला। ने ईसु ढंड्‌याम बसीन जाणे हींडतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","बाकुन तीनी टेमे चु वारु हवलु माणुस असी वीन्‌ती कर्‌यु की “मेसेक बी तारे पुठ्‌ये आवणे दे।” बाकुन ईसु तीना माणसे काजे वळावतु जाय्‌न कह्‌यु, “तु तारे घर पछु जात रव, ने भगवान तारे वाटे काय-काय करलु छे च आखो माणसे काजे देखाड़ दे।” ");
INSERT INTO bhi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ने अळी चु माणुस तेरे घर पछु जात र्‌यु। ने ईसु मार वाटे असो-असो काम करलो छे। करीन आखा सहर मां तत्‌यारुत जाय्‌न परचार करने लाग्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","जत्‌यार ईसु पछु गलील जीलाम आयु, ती माणसे खुस हय्‌न तेरो आव-भाव कर्‌या, काहाकी आखान-आखा तेरी वाट देखी रवला। ");
INSERT INTO bhi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","तीनी टेमे याईर नावेन एक माणुस हतलु, चु भगवानेन भक्‌तीन घरेन मुख्‌यु हतलु, चु ईसु धड़े आवीन ईसुन पाये पर हीट पड़्‌यु ने असी वीन्‌ती कर्‌यु, मारे घर चाल, ");
INSERT INTO bhi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","काहाकी बारेक सालेन तेरी एकुत पुरे हतली, ने ची मरने वाळी हतली। ने ईसु तेरे पुठ्‌ये चाल पड़्‌यु, ने जत्‌यार ईसु जाणे बाजी रवलु, तत्‌यार माणसे तेरे चारे मेर बेसकी गड़दी कर रवला। ने धकलाय्‌न तेरे पर पड़े-पड़े असा हय जातला। ");
INSERT INTO bhi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ने तीनी टेमे एक बायर बारे साल सी पोगराळा दुख मां वेला कर रवली। ने ची वारु हवणे करीन आखो कमायलो डाक्‌टर्‌या काजे आपीन खरचु कर देदली बाकुन तेबी ची काहना बी डाक्‌टर्‌या सी वारु नी हवी। ");
INSERT INTO bhi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ची ईसु पछळ आवीन ईसुन पुथल्‌यान कुर छीम लेदी, ने तत्‌यारुत ची पोगराळा दुख, सी वारु हय गुय। ");
INSERT INTO bhi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ने तत्‌यार ईसु कह्‌यु, “मेसेक कुण छीम्‌यो?” जत्‌यार आखा मे नी छीम्‌यु, मे नी छीम्‌यु, कहीन मना करने बाजी गुय, ती पतरस ने तेरा साती कह्‌या, “ए मालीक! तुसेक मालुम नी हय काय? की चारे मेर सी माणसे तुसेक घेरवी रया, ने तारे पर धकलाय्‌न पड़े-पड़े तसा हय र्‌या।” ");
INSERT INTO bhi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","“बाकुन ईसु तीनुक कह्‌यु, काहनुक ने काहनुक मेसेक छीमलु छे, काहाकी मेसेक मालुम पड़ गुयो की मारेम सी ताकत नीकळ्‌ळी छे।” ");
INSERT INTO bhi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","जत्‌यार बायरी काजे मालुम पड़ गुयो की, मेसेक सातणे नी बणे, ती ची काप‌ती जाय्‌न ईसु धड़े आवीन तेरा पायेम हीट पड़ी ने आखा माणसे अगळ आखी वात कय देदी की ईसुक काहा छीमली, ने हय मे छीमीन तत्‌यारुत वारु बी हय गुय। ");
INSERT INTO bhi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ईसु तीनीक कह्‌यु, “पुरे, तु भुरसु करी, काहाकी तु वारु हवली छे, ने हय सांती सी जात रव।” ");
INSERT INTO bhi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ईसु ज कहणे बाजी रवलु तत्‌यारुत काहनुस भगवानेन भक्‌ती करन्‌या घरेन मुख्‌या धड़े आवीन असो कह्‌यु तारी पुरे ते मर गुय। हय तु मास्‌तर काजे परेसान मां करे। ");
INSERT INTO bhi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","बाकुन ईसु ज सामळीन तीना भगवानेन भक्‌ती करन्‌या मुख्‌या काजे कह्‌यु, “बीहे मां, बाकुन भुरसु कर, ने तारी पुरे बची जासे।” ");
INSERT INTO bhi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","चु घर पुगीन पतरस, युहन्‌ना ने याकुप ने तीनी मरली पुरेन आस्‌या-बास्‌या काजे छुड़ीन कुय काजे बी तेरे पुठ्‌ये घर मां नी आवणे देदु। ");
INSERT INTO bhi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ने तीनी मरली पुरे धड़े आखा रड़ने बाजी रवला, ने तीनी पुरेन करता, आखा माणसे रड़ी-कलपी रवला, तीनुक ईसु कह्‌यु, “रड़ु मां! जी नी मरी, बाकुन सुवणे बाजी रय।” ");
INSERT INTO bhi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","चे माणसे जी वात जाणीन ईसुक हासणे बाजी गुया, काहाकी चे वारु रीती सी जाणतेला, की ची पुरे मर गुयली छे। ");
INSERT INTO bhi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","बाकुन ईसु पुरेन हात धरीन, तीनी पुरे काजे कह्‌यु, “ओ पुरे! उठ!” ");
INSERT INTO bhi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ने तत्‌यारुत टेम तेरु जीव पछु आय गुयु, ने ची जीवती हय गुय ने तत्‌यारुत ची उठीन उबी हय गुय। ने ईसु तीनी पुरेन माय-बास काजे कह्‌यु, “हीनीक मामार रुटा खावाड़ु।” ");
INSERT INTO bhi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","तेरा माय-बास चकराय गुया, बाकुन ईसु तीनुक कह्‌यु “जां आखो काय हयो च कुय काजे घुण कहुं।” ");
INSERT INTO bhi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ईसु तीनु बारे चेला काजे बुलायु, ने तीनु आखाक, भुतड़ा काजे ढासाड़ने ने आखा मांदला काजे वारु करनेन ताकत ने हक आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ने अळी ईसु चेला काजे भगवानेन राजेन परचार करने, ने मांदलाक वारु करने, करीन मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","चु तीनुक कह्‌यु, “जत्‌यार तुहुं जावु ती वाट्‌ये वापरने करीन काय बी घुण ली जावु, नी ते डेंगु, नी झुळु, नी रुटा, नी पयस्‌या ने दुय पुथल्‌या घुण ली जावु। ");
INSERT INTO bhi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","तीना बी घर मां जावु, चांहान रवजु; ने मकलने लग चांहान रवजु। ");
INSERT INTO bhi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","कदी माणसे तुंद्‌रो आव-भाव नी करे, ती तींद्‌रा सहरेम सी नीकळनेन टेमे, आपणा पायेन धुळु बी झाटकी देजु।” ");
INSERT INTO bhi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","अतराम चे ईसु धड़े सी जात र्‌या, ने आखी दुर खुस-खबर सामळावता रया, ने माणसे काजे वारु करता जाय्‌न गांव-गांव हींडता र्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","गलील जीलान राजा हेरोदेस तीनी आखी वातेन बारामां सामळीन घाबराय गुयु, काहाकी थुड़ाक माणसे कह्‌तेला की बपतीस्‌मा आपण्‌यु युहन्‌ना मर्‌या-सर्‌याम सी पछु जीवतु हय गुयलु छे। ");
INSERT INTO bhi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ने थुड़ाक माणसे असा कह्‌तेला, एलीयु, देखाय देदलु छे, ने थुड़ाक माणसे असा कह्‌तेला की जु बास दादान टेमे भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या मायन काहनुक जीवतु हय गुयलु छे। ");
INSERT INTO bhi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","बाकुन हेरोदेस असु कह्‌यु, “युहन्‌नान ते मे मुणको काटाड़ देदलु, ने हय ज कुण छे, तेरा बारामां मे असी वात सामळो?” अतरे हेरोदेस ईसु काजे देखणे हेर करतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ईसुन नेवताळा पछा आवीन ज काय कर्‌या च आखो कय देदा, ने अळी ईसु आपसा चेलाक कळ्‌येत अलग करीन बेतसेदा नावेन सहर ली जाती र्‌यु, ");
INSERT INTO bhi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","बाकुन बेसका माणसेन टुळा काजे पतु हय गुयु, ने चे ईसु पछळ चाल पड़्‌या। ईसु खुस हय्‌न तीनुक आव-भाव करीन भेळु हयु, ने भगवानेन राजेन बारामां तींद्‌रे साते वात करने बाजी गुयु, ने जे मांदला काजे ने जे वारु हवणे हींडतेला, तीनु मांदलाक वारु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","दाहड़ु ढळे ने ईसुन बारे नेवताळा ईसु धड़े आवीन तीनाक असा कह्‌या, “जां ते आपणु उजाड़्‌या जागाम छे, ने तीनु माणसेक अळाय दे, ने हया आड़े-धड़ेन गांव मां ने वस्‌तीया जाय्‌न आपसा धड़े रह्‌वणेन ने खाणेन तज्‌बु लागाड़से।” ");
INSERT INTO bhi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ईसु तेरा चेला काजे कह्‌यु, “तुहुंत माणसे काजे खाणो आपु।” चे असा कह्‌या, “हामरे धड़े ते पांच रुटा ने दुय माछा अतरात छे।” तींद्‌रे वाटे हाटेम जाय्‌न खाणो मुल लावणु पड़से काय? ");
INSERT INTO bhi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","चां पांचेक हजार अदमी हतला। ईसु आपसा चेला काजे असु कह्‌यु, “अलग पचास-पचास माणसेन पंगत बठाड़ देवु।” ");
INSERT INTO bhi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ने ईसु कह्‌यु तसात चे, तीनु आखा काजे बठाड़ देदा। ");
INSERT INTO bhi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ने अळी ईसु चे पांच रुटा ने दुय माछा हातेम धर्‌यु, ने सरगे भीणी भाळीन तीनु रुटा वाटे ने माछा वाटे भगवान काजे तु बेसकु वारु कह्‌यु, ने माछा ने रुटा भांजी-भांजीन आपसा चेलाक पंगत मां वाटणे करीन आपतु गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ने आखा माणसे खायलीन आफरी गुया। ने रुटान बचला टुकड़ान बारे चार्‌या भराय गुया। ");
INSERT INTO bhi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","जत्‌यार ईसु एक दाहड़े एक सुन्‌ली जागा मां दुवा करने बाजी रवलु, ने तेरा चेला हेरे पुठ्‌ये हतला। ईसु तीनुक असु पुछ्‌यु, मे कुण छे, “मारा बारामां माणसे काय कहें?” ");
INSERT INTO bhi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","हेरा चेला कह्‌या, “काहना कवे, बपतीस्‌मा आपण्‌यु युहन्‌ना छे; ने काहना-काहना कहें, एलीयु छे; ने काहनाक माणुस असा कहें की जु ते बास दादान टेमेन एक भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळु जीवतु हय र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ईसु तीनुक अळी पुछ्‌यु, “तुहुं मेसेक काय कह्‌वु की मे कुण छे?” पतरस कह्‌यु, “तु भगवान मसी छे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","तत्‌यार ईसु आपसा चेलाक चेताड़ीन असु कह्‌यु, “तुहुं जी वात काहनाक घुण कह्‌वु।” ");
INSERT INTO bhi_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ईसु आपसा चेला काजे असु कह्‌यु, “मे माणसेन पुर्‌यु बणीन आय र्‌यु, ने मेसेक दुख झेलनु छे; डाहला ने भगवानेन डाहला पुजारा ने यहुदी-सास्‌तुर सीकाड़न्‌या माणसेन पुर्‌या काजे हेटु समजीन मार नाख्‌से, बाकुन तीनाक तीन दाहड़ा मां जीवतु हय्‌न बठु हवणु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ईसु हेरे पछळ आवणे वाळा आखा काजे असु कह्‌यु, “कदी काहनुक मारे पछळ आवणे हींडे, ती आपणु नीकारु करनु पड़से। ने दाहड़ीन आपसु कुरुस हाकलीन मार पछळ आवणु पड़से। ");
INSERT INTO bhi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","काहाकी जु आपसु जीव बचाड़ने हींडे, चु तीनाक खुय देसे ने जु मारे वाटे आपसु जीव खुय देय, चु तीना जीव काजे बचाड़ लेसे। ");
INSERT INTO bhi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","कदी माणुस आखी कळीक हात कर लेय, ने आपसु जीव खुय देसे, नी ते आपसा जीवन नुकसाण हय, ती काय नफु जड़से? ");
INSERT INTO bhi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","कदी काहनुक मेसेक ने मारी वात काजे हव करीन मान्‌ने मां लाजवाय्‌से; ती माणसेन पुर्‌यु आवण्‌यु बी तीनाक, तीने दाहड़े तीनाक लाजवाड़से, जत्‌यार चु आपसान, ने आपसा बासेन चुखला सरग वाळा काहवाळ्‌यान सेक-सींगार भेळु आवसे। ");
INSERT INTO bhi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","मे तुहुंक छाचलीन कहो की जां उबा हय र्‌या, तीनु माणसे मायन थुड़ाक असा माणसे छे, जे भगवानेन राज काजे देखे नी चां लग नी मरे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ईसु ज कय देदु ने अळी, आठेक दाहड़ाम, पतरस, युहन्‌ना ने याकुप काजे पुठ्‌ये लीन एक बयड़ा पर दुवा करने करीन चहड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ने जत्‌यार ईसु दुवा करने बाजी रवलु, तत्‌यार ईसुन मुंहडान सीकु बदली गुयु, ने तेरा पुथल्‌या धवळा हयन, चमकणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","चे दुय अदमी मुसु ने एलीयु हतला, ने ईसु साते वात करने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ने उचकाणुन, दुय अदमी सेक-सींगार भेळा देखाय देदा, ने भगवानेन मरजीन अनसारे यरुसलेम मां हवणे वाळी ईसुन मरनेन बारामां वात वीच्‌यार करने बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","बाकुन पतरस ने पतरसेन साती जे घुर्‌राटीन सुवणी बाजी रवला, चे हय पुरा जाग गुया, ती चे ईसुन सेक-सींगार काजे ने तीनु दुय अदमी काजे देख्‌या, जे ईसु पुठ्‌ये उबा हय रवला। ");
INSERT INTO bhi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ने जत्‌यार मुसु ने एलीयु ईसु धड़े सी जाणे बाजी गुया, ती पतरस मन मां वीच्‌यार करे पाखुर उचकाणुन ईसु काजे असु कय देदु, “मालीक! जां रवणु हामरे वाटे कतरो वारु छे! हामु तीन तम्‌बु ताणीन उबा कर देजे एक तारे वाटे, एक मुसा वाटे ने एक एलीया वाटे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","चु पतरस ज कह्‌णे बाजी रवलु, ती आदळो आय्‌न तींद्‌रे पर छावाय गुयो, ने चे आदळाम घेराय गुया करीन बीही गुया। ");
INSERT INTO bhi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ने चे तीना आदळाम सी जे बुल सामळ्‌या, “हयुत मारु लाटेक्‌लु पुर्‌यु छे, ने हयुत मारु नेवाड़लु पुर्‌यु छे, तुहुं हेरी सामळीन मानु।” ");
INSERT INTO bhi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","जे बुल सामळायणु बंद हय गुयो ने अळी चां ईसु एखलु रय गुयु; ने चेला ज देखीन चेला हुगात रय गुया, ने चे ज काय बी देखला, तेरे बारामां, चे तीनु दाहड़ाम काहनाक बी नी कया। ");
INSERT INTO bhi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","दीसरे दाहड़े जत्‌यार चे बयड़े सी उतर्‌या, ती एक बेसकु मटु माणसेन टुळु ईसुक भेळु हवणे आयु। ");
INSERT INTO bhi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ने देखु, एक माणुस तीना टुळाम सी आयड़ीन कह्‌यु, “मास्‌तर! मे तारे धड़े असी वीन्‌ती करो, मारा पुर्‌या पर दया करीन मदत कर, हयु मारु एकुत पुर्‌यु छे। ");
INSERT INTO bhi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","उचकाणुन, हेरे भुतड़ान आत्‌मा चस्‌टी जाय, ने हयु उचकाणुन आयड़ी पड़े; ने भुतड़ान आत्‌मा हीनाक पीळ्‌ळीन नस्‌टा खाची देय, ने ईना पुर्‌यान मुंहडाम सी फेसकड़ु आय जाय; ने हीनाक रंदळी रंदळीन एला पाड़े! ");
INSERT INTO bhi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ने मे तारा चेला धड़े असी वीन्‌ती करलु, मारा पुर्‌याम सी भुतड़ु नीकाळ दे; बाकुन तीनुक भुतड़ु नीकाळते नी आयो।” ");
INSERT INTO bhi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ईसु जपाप आपीन असु कह्‌यु, “ए नी भुरसु करने वाळा ने नी मानने वाळा माणसे मे कां लग तुंद्‌रे पुठ्‌ये रवीस ने तुंद्‌री वेठतु रवीस? तारा पुर्‌याक जां ली आव।” ");
INSERT INTO bhi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","पुर्‌यु ईसु धड़े आवणे बाजी रवलु, ने भुतड़ान आत्‌मा तीनाक भुयमां आसटी देदु, ने मुयड़ीन नस्‌टा खेच देदु, बाकुन ईसु भुतड़ान आत्‌मा काजे झीचकार्‌यु, ने ईसु तीना पुर्‌याक वारु करीन आपसा बासेन हातेम पछु आप देदु। ");
INSERT INTO bhi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ने भगवानेन जुरभरी ताकत देखीन आखा माणसे चकराय गुया। तत्‌यार आखा माणसे ईसुन छेल भात्‌या काम काजे देखीन चकरायणे बाजी रवला; तत्‌यार ईसु आपसा चेलाक कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“मे ज कहो च वारु हेर राख्‌जु, काहाकी माणसेन पुर्‌यु माणसेन हाते हय्‌न धरायणे वाळु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","बाकुन जी वात चेला काजे समज मां नी आय। जी वात तींद्‌रे सी सातायली रय, ने ज तीनुक समजाय तेलो नी। ने हेरा बारामां ईसु काजे पुछणे सी चे बीहतेला। ");
INSERT INTO bhi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","बाकुन आखा चेला असा पुछीन वातेम जखड़ी पड़णी बाजी गुया, “आपणे मां आखाम मटु कुण छे?” ");
INSERT INTO bhi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ने ईसु तींद्‌रा मनेम वीच्‌यार काजे जाण लेदु, ने एक पुर्‌या काजे साते बुलायु, ने तींद्‌रे अगळ उबु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ने तीनु चेलाक असु कह्‌यु, “ज कुय मार नाव सी ईना पुर्‌यान आव-भाव करे, च मारो आव-भाव करे, ने ज मारो आव-भाव करे, च तेरो आव-भाव करे, जु मेसेक मकेल्‌लु छे काहाकी ज तुंद्‌रे मां आखाम नानलु छे, चु आखाम सी मटु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","युहन्‌ना कह्‌यु, “ए मालीक! हामु एक माणसेक तारे नाव सी भुतड़ाक नीकाळतेला देखला ने हामु तीनाक कह्‌या, तु हामरे पुठ्‌ये चाल, बाकुन चु हामरे पुठ्‌ये आवणे नी हींडतेलु, ने हामु तीनाक कह्‌या, ईसुन नाव सी भुतड़ाक मां नीकळे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ईसु युहन्‌नाक ने दीसरा चेलाक असु कह्‌यु, “तीनाक घुण रुकु काहाकी, ज तुंद्‌री वीरुद नी करे, च तुंद्‌रे अळु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","जत्‌यार ईसुन सरगे जाणेन टेम आय गुया, ती ईसु यरुसलेम सहर जाणेन पाक्‌कु वीच्‌यार करीन जाणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ने चु काहवाळ्‌यु तेरे अगळ मकल्‌यु; ने चे ईसुन रवणेन तज्‌बु करने, करीन सामरीया माणसेन एक गांव मां भराया। ");
INSERT INTO bhi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","बाकुन सामरीया जीलान तीना गांव वाळा माणसे ईसुन आव-भाव नी कर्‌या, काहाकी ईसु चां मायन यरुसलेम सहर मां भगवानेन भक्‌ती करने जाणे बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ने हेरा चेला याकुप ने युहन्‌‌‌नु ज देखीन असा कह्‌या, “ए मालीक! तु कहें ती हामु ज कय देजे की सरगे सी आकठी पड़ जां, ने हीनुक खत्‌तम कर दे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","बाकुन ईसु पछु फीरीन तीनुक लड़्‌यु, ने असु कह्‌यु, तुहुं काहनी आत्‌मान साहरे असो कह्‌णे बाजी र्‌या, जो तुहुंक मालुम नी हय काय? माणसेन पुर्‌यु ते माणसेक मारने नी बाकुन बचाड़ने आवलु छे। ");
INSERT INTO bhi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ने अळी चे आखा, दीसरा गांव मां जात र्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","जत्‌यार ईसु ने तेरा चेला वाट्‌ये-वाट्‌ये जाणे बाजी रवला, तत्‌यार काहनुस ईसु धड़े आवीन ईसुक असु कह्‌यु, “तु जां जासी चां, मे बी तारे पुठ्‌ये-पुठ्‌ये आवीस।” ");
INSERT INTO bhi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ईसु कह्‌यु, “फुंदाळी खुखड़ी रहणे वाटे तींद्‌रा दर छे, ने सरगेन चिरला वाटे रह्‌वणे करीन तींद्‌रा पुत्‌रा छे, बाकुन माणसेन पुर्‌या वाटे मुणको मेल्‌ने लग जागा नी हय।” ");
INSERT INTO bhi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","काहनाक दीसरा काजे ईसु कह्‌यु, “मारे पछळ आव।” बाकुन चु कह्‌यु, “ए मालीक! मेसेक पेहेल मारा बासेक गाड़ी आवणे दे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ईसु तीनाक कह्‌यु, “तु जाय्‌न भगवानेन राजेन खुस-खबर सामळाव। मरला काजे आपणा मरला काजे गाड़नी दे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","एक अळी दीसरु आवीन ईसुक कह्‌यु, “ए मालीक! मे तारे अनसारे चालीस, बाकुन मेसेक पेहले मारा घरन्‌या माणसेक अळाय आवणे दे।” ");
INSERT INTO bhi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ईसु तीनाक कह्‌यु, “जु कुय हळ जुपणे करीन हळ धर लेय ने अळी पछु फीरीन देखे, चु भगवानेन राजेम भराये असो नी हय सके।” ");
INSERT INTO bhi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","हेरे पछळ मालीक सत्‌तर चेला काजे नेवाड़्‌यु, जीनु-जीनु सहरेम ने गांव मां चु आपसु जाणे वाळु हतलु, चां दुय-दुय जणा काजे आपसा अगळ मकली देदु। ");
INSERT INTO bhi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ने चु तीनुक कह्‌यु, “मेर ते बेसकी छे, बाकुन दाहड़क्‌या थुड़ाक छे; अळी खेतेन मालीक भगवान धड़े असी वीन्‌ती कर्‌यु, तु आपसी मेर काटणे करीन दाहड़क्‌या काजे मकली दे।” ");
INSERT INTO bhi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","मे तुहुंक लेंड्‌यान ईचमां गाडरान तसु मकलो। ");
INSERT INTO bhi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","अळी तुंद्‌रे मायन कुय बी बटवु, ने थयलि, ने खासड़ा घुण ली जावु ने वाटे मां कुयबी वारु छे की करीन घुण कह्‌वु। ");
INSERT INTO bhi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","तीना बी घर मां भरायसु, ती आखान पेहले ज कह्‌जु, ईना घर मां सुक-सांती आवणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","कदी चां कुय काजे सुक-सांती चाहती हय, ती तीना पर तुंद्‌री सुक सांती रवसे, नी ते ची सुक-सांती तुंद्‌रे धड़े पछी आवती रवसे। ");
INSERT INTO bhi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","तीनात घर मां बठी रवजु ने तेरे धड़े जो हय, चो खाजु-पीजु; काहाकी दाहड़क्‌या काजे दाहड़कीन हक छे। ईने घर ने पले घर घुण जावु। ");
INSERT INTO bhi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","तीना सहरेम जासु ने जे माणसे तुंद्‌रो आव-भाव करसे ने जो काय तुहुंक खाणे आपसे, चो खाय लेजु। ");
INSERT INTO bhi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","चां वाळा मांदला माणसेक वारु करजु, ने तीनुक कवजु, भगवानेन राज तुंद्‌रे धड़े आय लागलो छे। ");
INSERT INTO bhi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","बाकुन कदी तुहुं काहना सहरेम जावु ने माणसे तुंद्‌रो आव-भाव नी करे, ती तींद्‌रा हाटेम जाय्‌न असा कह्‌जु, ");
INSERT INTO bhi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","हामरा पायेम लागलु तुंद्‌रा सहरेन धुळु लग हामु तुंद्‌रे अगळ झाटकी देजे। तेबी तुहुं ज जाण लेजु की भगवानेन राज तुंद्‌रे धड़े आय लागलो छे। ");
INSERT INTO bhi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","मे तुहुंक ज कहो, नीयावेन दाहड़े सदोम सहरेन माणसे सी तीना सहरेन माणसेक जादा डंड जड़से। ");
INSERT INTO bhi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ए खुराजीन सहरेन माणसे! तुंद्‌रे पर सराप पड़े! ए बेतसेदा सहरेन माणसे! तुंद्‌रे पर सराप पड़े! जे चकराये असा बेसका वारु काम तुंद्‌रेम हवलो छे, कदी च काम सुर सहरेम ने सेदा सहरेम रवण्‌या माणसेन ईचमां हवतो, ती चे काय कत्‌यारुन गंटाट्‌या पांगरीन ने आपसा डीले पर रखड़ु चुपड़ीन आपसा पाप भीणी सी मन फेरवीन भगवान भीणी हय जाता। ");
INSERT INTO bhi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","बाकुन नीयावेन दाहड़े सुर सहरेन ने सेदा सहरेन कुहर्‌या माणसे सी तुहुंक अदुस डंड जड़से। ");
INSERT INTO bhi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ने ए कफरनहुम सहरेन माणसे! सरगे लग उचा हाकलाय जासु काय? नी, बाकुन तुहुं पाताळेम लग नेचा धकलाय जासु? ");
INSERT INTO bhi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“जे तुंद्‌री सामळीन माने, चे मारी सामळीन माने, ने जे तुंद्‌रु नीकारु करीन तुहुंक नेचा समजे, चे मारु नीकारु करीन मेसेक नेचा समजे। ने जे मारु नीकारु करीन मेसेक नेचा समजे, चे तीना सरग वाळा बास भगवानेन नीकारु करीन तीनाक नेचु समजे, जु मेसेक मकेलु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","सत्‌तर ने दुय चेला खुस हय्‌न पछा आया ने असा कह्‌या, “ए मालीक! तार नाव सी भुतड़ान आत्‌मा लग हामरा हुकुम काजे मानीन हामरा हक मां हय जाय।” ");
INSERT INTO bhi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ईसु तीनुक असु कह्‌यु, मे, भुतड़ा काजे वीजळीन तसु सरगे सी नेचु पड़तेलु देख रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","सामळु! मे तुहुंक घड़सा काजे ने ईछा काजे पाये तळे कुचरनेन हक आपलु छे, ने मे तुहुंक वेरी भुतड़ान आखा जुर पर बी हक आपलु छे। ने काहने बी भात्‌ये तुंद्‌रो नुकसाण नी हवे। ");
INSERT INTO bhi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","बाकुन तेबी भुतड़ान आत्‌मा तुंद्‌रु हुकुम मानीन तुंद्‌रा हक मां छे, करीन तुहुं खुस घुण हवजु, बाकुन भगवान तुंद्‌रु नाव सरगेम लिख र्‌यु, करीन खुस हवजु। ");
INSERT INTO bhi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","तीनेत टेमे चुखली-आत्‌मान साहरे ईसु बेसकु खुस हय गुयु, ने कह्‌यु, “ए बास! सरग ने धरतीन मालीक! मे तारा नावेन गुण गावो, काहाकी तु ईनी आखी वात काजे अक्‌कल वाळान ने हुनर वाळा सी सातीन मेल रयु, ने डेड़-अकल्‌या पुर्‌या अगळ उजेंती कर्‌यु। हव, ए बास! तुसेक ज वारु लागे। ");
INSERT INTO bhi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“मारु भगवान बास मेसे आखो काय आप देदलु छे। बाकुन भगवान बासेक छुड़ीन ज कुय बी नी जाणे की पुर्‌यु कुण छे, ने पुर्‌या काजे छुड़ीन कुय बी नी जाणे की भगवान बास कुण छे। बाकुन चे माणसे अतरात जाणसे तीनुक पुर्‌यु जी वात उजेंतु कर देसे।” ");
INSERT INTO bhi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","तत्‌यार ईसु चेला भीणी पछु फीरीन कळ्‌येन तीनुक कह्‌यु, की तुंद्‌रेन तसा ईनी वात काजे देखणेवाळा बरकतवाळा छे। ");
INSERT INTO bhi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","काहाकी मे तुहुं काजे कहो की, जी वात तुहुं देख्‌या ने सामळ्‌या चे बेसका खरा भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळा ने राजा देखणे ने सामळने हींडतेला बाकुन चे नी देख्‌या ने नी सामळ्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ने एक दाहड़ु यहुदी सास्‌तुर सीकाड़न्‌यु ईसु धड़े आयु, ने ईसुक पारखणे करीन चु ज पुछ्‌यु, “ए मास्‌तर! अमर जीवाय हात करने करीन मे काय करो?” ");
INSERT INTO bhi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ईसु तीनाक जपाप आप्‌यु, मुसान चुखला सास्‌तुर मां काय लिखलो छे, तु काय भन्‌यु ने समजु। ");
INSERT INTO bhi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","यहुदी-सास्‌तुर सीकाड़न्‌यु जपाप आप्‌यु, “की तु आपणा मालीक भगवान काजे आपणो आखो लागाड़ीन, ने आपणो आखो जीव, लागाड़ीन, ने आपसु आखु जुर लागाड़ीन, ने आपसी आखी अक्‌कल लागाड़ीन परम कर। ने तार साते वाळा सी आपणेन तसु परम कर।” ");
INSERT INTO bhi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ईसु तीनाक असु कह्‌यु, “तु वारु जपाप आप्‌यु, चत कर, ती तुसेक अमर जीवाय जड़से।” ");
INSERT INTO bhi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","बाकुन चु यहुदी-सास्‌तुर सीकाड़ने वाळु आपसाक धरमी कह्‌वाड़नेन हेर करीन ईसुक दीसरु सवाल पुछ्‌यु, “मार धड़े वाळु कुण छे?” ");
INSERT INTO bhi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ईसु तेरा सवालेन जपाप मां तीनाक जी काहनी सामळायु, “एक दाहड़ु एक माणुस यरुसलेम सी यरीहो सहर भीणी जाणे बाजी रवलु। वाट्‌ये डाकु तेरे धड़े सी पेहरला पुथल्‌या हापकी लेदा ने तीनाक बेसका ठुक्‌या, ने अदमरतु नाखदीन जात र्‌या।” ");
INSERT INTO bhi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ने अळी एक पुजारु तीने वाट्‌ये नीकळ्‌यु ने चु तीना माणुस काजे देख्‌यु ती चु टळीन अगु जात र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","अळतेन एक लेवी बी तीने वाट्‌ये मायन नीकळ्‌यु। जत्‌यार चु तीना माणुस काजे देख्‌यु, ती धड़े आयु, ने तेरे भीणी मामार देख्‌यु। ने चु बी आडु देखीन अगुत जात र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","हय एक तीसरु माणुस चां आयु, चु आपणा माणसे मायन बी नी हतलु। बाकुन चु सामरी जीलान एक अंजाण्‌यु माणुस हतलु। जत्‌यार चु लुटायला माणसेक देख्‌यु तत्‌यार चु तेरे पर दया कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","चु तेरे धड़े आयु, तेरा घाव पर अंगुरेन रस लागाड़्‌यु ने तेल चुपड़ीन पट्‌टी बांद्‌यु। ने अळी चु तीना माणुस काजे आपसा गदड़ा पर बठाड़ीन एक धरम साळा मां ली गुयु, चां चु अळी तेरी सेवा-चाकरी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","दीसरे दाहड़े चु धरम-साळान मालीक काजे दुय रुप्‌या आपीन कह्‌यु, “ईना माणसेन वारु चाकरी करजी ने कदी जादा रुप्‌या लागे ती मे पछु आवणेन टेमे तुसेक आप दीस।” ");
INSERT INTO bhi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ईसु जी काहनी पुरी कय्‌न तीना यहुदी-सास्‌तुर सीकाड़ने वाळा काजे पुछ्‌यु, तीनु तीन माणसे मायन कुण तीना डाकुन साहरे ठुकायला माणसेक खरलु परम देखाड़ीन धड़े वाळु बण्‌यु, “तीनाक चुट्‌टा लुट लेदला?” ");
INSERT INTO bhi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","यहुदी सास्‌तुर सीकाड़न्‌यु, जपाप आप्‌यु, “जु तेरे पर दया कर्‌यु, चु तीना डाकुन साहरे ठुकायला माणसेक खरलु परम देखाड़्‌यु।” ईसु तीनाक कह्‌यु, “जां ने तु बी तेरेन तसुत कर।” ");
INSERT INTO bhi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ईसु वाट्‌ये चालतु-चालतु एक गांव मां गुयु, ने मारथा नावेन एक बायर ईसु काजे आपसे घर ली जाय्‌न आव-भाव करी। ");
INSERT INTO bhi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ने मारथान एक बहणीस हतली तेरो नाव मरीयम हतलो, ची मालीक ईसुन पाय मां बसीन तेरी वात सामळतेली। ");
INSERT INTO bhi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","बाकुन मारथा काम करी-करीन घाबराय रवली। ती ची ईसु धड़े आवीन असी कही, “ए मालीक! तुसे मारी ईतरीक बी फीकुर नी हय काय, मार बहणीस आखो काम करने वाटे मेसे एखलीत छुड़ देदी। तीनीक कय दे की, मारी मदत करे।” ");
INSERT INTO bhi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","मालीक ईसु तीनीक जपाप आप्‌यु, “ए मारथा! ए मारथा! तु बेसकी वातेन बारामां फीकुर ने हरबड़ करने बाजी रय। ");
INSERT INTO bhi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","बाकुन तारेम एक वातेन कसर छे, ने मरीयम तीनी एक वारलु वातेक नेवाड़ लेदली छे, जी वात तेरे धड़े सी कुय नी हापके।” ");
INSERT INTO bhi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","एक कावा ईसु दुवा करने एक जागा पर दुवा करने बाजी रवलु। ने जत्‌यार चु दुवा कर लेदलु, ती तेरा चेला मायन एक चेलु तीनाक असु कह्‌यु, “ए मालीक ईसु! जसु बपतीस्‌मा आपण्‌यु युहन्‌‌‌नु आपसा चेलाक दुवा करने सीकाड़्‌यु। तसुत तु बी हामुक दुवा करने सीकाड़।” ");
INSERT INTO bhi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ईसु तीनु चेलाक कह्‌यु, जत्‌यार तुहुं दुवा करु, ती तीनी टेमे असा दुवा करजु: ए भगवान बास: तारो नाव चुखलो मानायणु चाहजे; आखा माणसेम तारो राज आवणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","दाहड़ीन, हामुक चाहजे ततरोत खाणो हामु काजे आप्‌या कर। ");
INSERT INTO bhi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ने हामरा पाप काजे माफ कर, काहाकी हामु बी हामरा गुनेगार काजे माफ कर्‌या। अळी हामुक पारख मां घुण पाड़े। ");
INSERT INTO bhi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ईसु तीनुक अगु कह्‌तु गुयु, “मान लेवु की, कदी तुंद्‌रे मायन कुयन एक दुस्‌तीदार साते हय, ने तु तेरे भीणी आधली राते तेरे धड़े जाय्‌न कह्‌वे, ए दुस्‌तीदार, मेसे तीन रुटा उधार लाय्‌न दे।” ");
INSERT INTO bhi_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","काहाकी मारु एक दुस्‌तीदार बेसके नांबे सी मेजवान्‌यु आवलु छे, तीनाक ते खावाड़ने वाटे मारे धड़े काय बी रुटा नी हय। ");
INSERT INTO bhi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ने चु घरमां सी जपाप आप्‌यु की, मेसे दुख मां देय, हय ते बारनो बंद छे, ने पुर्‌यु बी मारे भेळु सुवणे बाजी र्‌यु। तेरेसी मे उठीन तुसे काय बी नी आप सको। ");
INSERT INTO bhi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","मे तुंद्‌रे सी कहो की, चु तेरु दुस्‌तीदार हवणे पर बी तीनाक उठीन नी आपे। ती बी सरम छुड़ीन मांगणेन वजे सी तीनाक जतरा रुटान जरुवत छे, ततरा रुटा उठीन आपसे। ");
INSERT INTO bhi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","मे तुहुंक कहो की, मांगसु ती तुहुंक आपसे। ने हेरसु ती तुहुंक जड़ी जासे। ने बारनो ठुकसु ती तुंद्‌रे वाटे उघड़ी जासे। ");
INSERT INTO bhi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","काहाकी जत्‌यार जु कुय मागंसे, ती तीनाक आपसे। जे कुय हेरसे ती तीनाक जड़ी जासे। ने जु कुय बारनो ठुकसे, तेरे वाटे खुली जासे। ");
INSERT INTO bhi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“मान लेवु, तुहुं एक बास छे ने तुंद्‌रु पुर्‌यु तुंद्‌रे धड़े माछा मांगे, ती काय तुहुं तीनाक घड़सु आपसु? ");
INSERT INTO bhi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","कदी चु तुंद्‌रे धड़े आंडा मांगे, ती काय तुहुं तीनाक ईछु आपसु। ");
INSERT INTO bhi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","कदी तुहुं भुंडा हय्‌न बी तुंद्‌रा पुर्‌याक वारलु चीज आपणे जाणु, ती सरगेन बास आपणा मांगणे वाळाक चुखली-आत्‌मा काहा नी आपे? चु मांगणे वाळाक आपसे।” ");
INSERT INTO bhi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ईसु एक गुंगा करने वाळी भुतड़ान आत्‌मा काजे नीकाळने बाजी रवलु। भुतड़ान आत्‌मा नीकळी गुय ती गुंगड़ु बुलने बाजी गुयु। तीनाक देखीन माणसे चकराय गुया। ");
INSERT INTO bhi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","बाकुन तुंद्‌रे मायन थुड़ाक माणसे कह्‌या, की जुते भुतड़ान मुख्‌या बालजबुलेन मदत सी भुतड़ान आत्‌मा काजे नीकाळे। ");
INSERT INTO bhi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","थुड़ाक माणसे ईसु काजे पारखणे वाटे तेरे सी सरगेन एक सहलाणी मांग्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ईसु तींद्‌रा मनेन वीच्‌यार जाणीन तीनुक कह्‌यु, तीना देस मां बेरजु पड़ जाय, ती च देस टीक नी सके ने, उजड़ी जाय, ने तीना घर मां झगड़ु हय जाय, ती च घर खत्‌तम हय जाय। ");
INSERT INTO bhi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","कदी भुतड़ु आपसान वीरुद करने बाजी जाय ती, भुतड़ान राज कसु चालसे? थुड़ाक सुचु ते खरा, काहाकी तुहुं मार बारामां ज कय र्‌या की तु भुतड़ान मदत सी भुतड़ान आत्‌मा काजे नीकाळ र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","कदी मे भुतड़ान मदत सी भुतड़ान आत्‌मा काजे नीकाळो, ती तुंद्‌रा पुर्‌या कुणीन मदत सी भुतड़ान आत्‌मा काजे नीकाळे? हेरेसी चेत तुंद्‌रु हीसाब लीन तुंद्‌रु नीयाव करसे। ");
INSERT INTO bhi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","बाकुन कदी मे भगवानेन ताकत सी भुतड़ान आत्‌मा काजे नीकाळो, ती तुहुं हय ज जाण लेवु की भगवानेन राज तुंद्‌रे ईचमां आय गुयलो छे। ");
INSERT INTO bhi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“जत्‌यार एक ताकतवाळु माणुस हत्‌यार हातेम लीन तेरा घरेन राखवाळी करे, ती तेरो माल-धनेक चुट्‌टा नी ली जाय, ने तेरो आखो माल-धन बच रवे।” ");
INSERT INTO bhi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","बाकुन कदी कुय तेरे सी जादा ताकतवाळु माणुस दवड़ीन तेरे धड़े आवीन तेरे साते लड़ाय करीन तीनाक जीत लेय, ने तीना ताकतवाळा माणुस धड़े सी, च आखो हत्‌यार हापकी लेय, तीनु हत्‌यार पर चु भुरसु करतेलु, ने तेरो माल-धन लुटीन दीसरा माणसे वाटी देय। ");
INSERT INTO bhi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“जु मारे पुठ्‌ये नी हय, चु मारु वीरुद मां छे, ने जु मारे साते भेळो नी करे, चु खुय देय।” ");
INSERT INTO bhi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","जत्‌यार भुंड्‌ली भुतड़ान आत्‌मा काहनाक माणुस मां सी नीकळीन जाय, ती चु आराम करने करीन, सुकला जागाम, जागा हेरती हींडे, ने जत्‌यार आराम करनेन जागा नी जड़े ती ची कह्‌वे की मे मारा तीना घर मां पछी जाती रय्‌स, चां सी नीकळीन आवली छे। ");
INSERT INTO bhi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ने चु भुतड़ु पछु आवीन देखे ती तीनाक च घर झाटकीन बाहरलो ने सींगारलो देखे। ");
INSERT INTO bhi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ती ची भुंड्‌ला भुतड़ान आत्‌मा पछी जाती रवे ने जाय्‌न तेरे पुठ्‌ये सात कुहर्‌या भुतड़ा काजे भेळा करीन ली आवे। ने तीनु माणसेम आवीन भराय जाय ने चु माणुस पेहले सी बी जादा बीगड़ी जाय, ");
INSERT INTO bhi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ईसु जी वात कह्‌वणे बाजी रवलु, तत्‌यार गड़दी मां सी काहनीक बायर ईसु धड़े आवीन जुर सी आयड़ीन, कय की तुसे पयदा करीन मटु करने वाळी, “बरकतवाळी छे ने चे धाया जे तु धायु।” ");
INSERT INTO bhi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","बाकुन ईसु तीनी बायरीक कह्‌यु, “हव, तु वारलु वात कय; बाकुन चे जादा बरकतवाळा छे, चे भगवानेन वात सामळीन तेरी माने।” ");
INSERT INTO bhi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","जत्‌यार तेरे चारेमेर बेसका माणसे भेळा हय गुया, तत्‌यार ईसु कह्‌णे बाजी गुयु, ईनी पीड़ीन माणसे पापी छे! जे सहलाणी हेर र्‌या, योनान सहलाणीक छुड़ीन ईनुक काहनी बी सहलाणी नी जड़े। ");
INSERT INTO bhi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","जसु योना नीनवे सहर मां रवण्‌या माणसे धड़े एक सहलाणी बण गुयलु। तसुत माणसेन पुर्‌यु बी ईनी पीड़ीन माणसे धड़े एक सहलाणी बण जासे। ");
INSERT INTO bhi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","नीयावेन दाहड़े दखणाव सी राणी ईनी पीड़ीन माणसे भेळी उठसे ने हीनुक गुनेगार ठेहरावसे, काहाकी ची सुलेमानेन अक्‌कल भरी वात सामळने करीन धरतीन काकड़ेन छेव सी आवली, ने सामळु! जां ते सुलेमान सी बी वदु अक्‌कल वाळु उबु हय रयु। ");
INSERT INTO bhi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","नीयावेन दाहड़े नीनवे सहरेन माणसे ईनी पीड़ीन माणसे भेळा उठसे ने ईनुक गुनेगार ठेहरावसे, काहाकी चे योनान मुंहडे जुर सी कह्‌वली भगवानेन वात सामळीन, पाप भीणी सी मन फेरव्‌या, ने देखु! जां ते योना सी बी बेसकु मटु भगवानेन वात सामळावण्‌यु छे। ");
INSERT INTO bhi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","कुय बी दिवु धपाड़ीन तळ घरेन सातायली जागा मां नी मेले, ने कांगणी तळे नी मेळे बाकुन दिवा काजे दीवाळ्‌या पर मेले, हेरेसी की घर मां आवणे जाणे वाळा काजे वीजाळो जड़े ने वारु देखाये। ");
INSERT INTO bhi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","तुंद्‌रा आखान डीलेन दिवु तुंद्‌रा डुळा छे, हेरेसी तुंद्‌रा डुळा वारु देखे ती तुंद्‌रो आखो डील बी चुखो देखाये बाकुन जत्‌यार तुंद्‌रा डुळा वारु नी देखे ती तुंद्‌रो डील बी आंदारला मां छे। ");
INSERT INTO bhi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","हेरेसी मे तुहुंक कह्‌वो चेतीन रवु-कांखुर मायन जो वीजाळो तुंद्‌रेम छे, चां आंदारो ते नी हय जाय। ");
INSERT INTO bhi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","कदी तुंद्‌रो आखो डील वीजाळाम रवे ने तेरु काहनु बी भाग आंदारला मां नी रवे, ती चो आखो डील वीजाळाम भराय रवसे, “जसु काहनु बी दिवु धपीन आपसा वीजाळा काजे छुड़ीन आखे दुर वीजाळो कर देय।” ");
INSERT INTO bhi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","जत्‌यार ईसु वात बताड़्‌यु ती काहनुक फरीसी माणुस लीलघाय्‌न कह्‌यु “मारेन्‌चां रुटा खाणे चाल” ने ईसु तेरेन्‌चां जाय्‌न रुटा खाणे बठ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","बाकुन ईसु हात धुयन खाणे नी बठ्‌यु, करीन चु फरीसी माणसे चकराय गुया ने तीनाक वारु नी लाग्‌यो। ");
INSERT INTO bhi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","मालीक ईसु तीना फरीसी माणसेन वीच्‌यार जाणीन तीनाक कह्‌यु, “तुहुं ते कटवरा ने तळी काजे उपर सी वारु मांजु, बाकुन तुंद्‌रा हीया-मन मां लुच्‌चाय ने भुतड़ान आत्‌मा भरायली छे।” ");
INSERT INTO bhi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ए डेड़-अकल्‌या माणसे! जु भगवान बाहर वाळु अंग बणायु, चु माहें वाळो अंग नी बणायु काय? ");
INSERT INTO bhi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","बाकुन ती ज माहें छे च भुकला काजे दान कर देवु, ती तुंद्‌रे वाट्‌ये आखो चुखो हय जासे। ");
INSERT INTO bhi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","बाकुन फरीसी माणसे! तुंद्‌रे पर गरा आय पड़े! काहाकी तुहुं पुदीनान ने सुदाब नावेन जड़ा बुटीन दसवु हीस्‌सु, ने भाती-भातीन भाजी-पालान दसवु हीस्‌सु बी आपे ते खरा, बाकुन भगवानेन नीयाव ने परम काजे टाळ देवु; तुहुंक ते जे दुय काम करता रवणु हतलो ने काहनी बी वात नी टाळनु हतलो। ");
INSERT INTO bhi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ए फरीसी माणसे! तुंद्‌रे पर गरा आय पड़नु चाहजे! काहाकी तुहुंक भगवानेन भक्‌तीन घर मां बसणे करीन खास गादी चाहजे ने हाटेम वारु छे की? करीन पुछण्‌या चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","तुंद्‌रे पर गरा आय पड़नो चाहजे! काहाकी तुहुं तीनु मसाणेन तसा छे, जे देखाव नी पड़े, “ने तीनु मसाण पर माणसे हींडे-फीरे बाकुन तीनुक पतु नी चाले की जां मसाण छे।” ");
INSERT INTO bhi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ज सामळीन एक यहुदी धरमेन कायदा सीकाड़न्‌यु, ईसु काजे कह्‌यु, “ए मास्‌तर! असी वात कय्‌न हामरी नाव-बद्‌दी कर र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ईसु कह्‌यु, ए यहुदी धरमेन कायदान मास्‌तर्‌या! तुंद्‌रे पर गरा आय पड़नु चाहजे! काहाकी तुहुं माणसे पर नेम-कायदा पाळनेन बुज नाख देवु ने तीनुक भारलो हाकलाड़े बाकुन हाकलने करीन आपसान आंगळी ईतरीक बी नी लागाड़ु। ");
INSERT INTO bhi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","तुंद्‌रे पर गरा आय पड़नु चाहजे! काहाकी तीनु, भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळा माणसे काजे तुंद्‌रा डाहा-डाहा मार देदला। तुहुं ते तींद्‌रा मसाण बांदीन गातु बणावु। ");
INSERT INTO bhi_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","अतरे तुहुं ईनी वातेन गवाय देवु, ने आपसा डाहा-डाहा असला काम सी राजी छे; काहाकी चे तीनाक मार नाख्‌या ने तुहुं तींद्‌रा मसाण बणायन बांदु, ने तींद्‌रु गातु बणावु। ");
INSERT INTO bhi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","हेरेसी भगवानेन अक्‌कल बी कह्‌, मे हींद्‌रे भीणी भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळा माणसे काजे ने मारा नेवताळा काजे मकलीस; ने चे तीनु मायन बेसका काजे मार देसे, ने बेसका काजे वेला पाड़से। ");
INSERT INTO bhi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","जी धरती बणने सी पेहलुत, सी भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळान लुही उहवाड़्‌यु। तींद्‌रे आखा सी लेखु ईनी पीड़ीन माणसे सी लेसे। ");
INSERT INTO bhi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","धरमी हाबील सी लीन जकर्‌यान लग लुही चुह्‌वाड़्‌या, तीना जकर्‌या काजे वेदीन मंदीरेन ईचमां मार देदला, तुहुंक छाचलीन कहो की तींद्‌रु लेखु ईनी पीड़ीन माणसे सी लेसे। ");
INSERT INTO bhi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“यहुदी धरमेन कायदान मास्‌तर्‌या! तुंद्‌रे पर गरा आय जाणु चाहजे! काहाकी तुहुं भगवानेन अकलेन कुची ते ली र्‌या, बाकुन तुहुं खुद ते नी भराया ने दीसराक बी नी भरायणे देदा।” ");
INSERT INTO bhi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","जत्‌यार ईसु तीना घर मां सी नीकळ्‌यु जे यहुदी-सास्‌तुर सीकाड़न्‌या ने फरीसी माणसे कीचवाय्‌न ईसु पछळ पड़ गुया ने बेसकी वात पुछीन वेला पाड़न्‌या झुम गुया। ");
INSERT INTO bhi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","काहाकी चे ईसुन मुंहडा सी नीकळने वाळी वात धरीन, फसाड़नेन तीयारी मां हतला। ");
INSERT INTO bhi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","तीनी टेमे हुड़ु-हुड़ु माणसे भेळा हय गुया, ने माणसे, माणसे पर हीटी पड़े असा हय जातला। तत्‌यार ईसु आखान पेहेल आपसा चेलाक कह्‌वणे बाजी गुयु, फरीसी माणसेन ढंगड़ा सी चेतीन रवजु। ");
INSERT INTO bhi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","असो काय बी सातायलो नी हय, ज्‌य उघड़ीन उजेंतो नी हवे, असो काय बी ढाकायलो नी हय ज कुय काजे मालुम नी पड़े। ");
INSERT INTO bhi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","हेरेसी जी वात तुहुं आंदारला मां कह्‌वला छे, ची वात वीजाळा मां सामळायसे ने जी वात तुहुं घरेन कपरा मां कुर-कुर कान्‌टा मां सामळ्‌या हय ची वात घर पर उपर चहड़ीन परचार कह्‌वसे। ");
INSERT INTO bhi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","मे तुहुं मारा दुस्‌तीदार्‌या काजे कहो-जे माणसे तुंद्‌रा डील अतरात नुकसाण करे ती तींद्‌रे सी मां बीहु। बाकुन चे ते अळी अगा काय बी नी बीगाड़ सके। ");
INSERT INTO bhi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","मे तुहुंक देखाड़ो की कुणी सी बीहणु चाहजे। भगवान सी बीहु, तेरे धड़े मारीन ने नरक मां नाखणेन बी हक छे। हव, मे तुहुंक अळी-अळीन कहो की-तीना सी अतरात बीहु! ");
INSERT INTO bhi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“दुय पयस्‌या मां पांच घीनचीड़ा नी वेचाये काय?” तेबी भगवान तींद्‌रे मांयन एक काजे बी नी ईसरे। ");
INSERT INTO bhi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","हव, तुंद्‌रा मुणकान आखा कान्‌या बी गीणायला छे, तेरेसी मां बीहु काहाकी तुंद्‌रु भाव ईनु घीनचीड़ा सी अदु छे! ");
INSERT INTO bhi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","मे तुहुंक कहो काहनु बी माणुस मेसेक दीसरा माणसे अगळ मेसेक मान लेसे। तीनाक माणसेन पुर्‌यु बी भगवानेन सरग वाळा काहवाळ्‌या अगळ मेसेक मान लेसे। ");
INSERT INTO bhi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","बाकुन जु माणुस मेसेक दीसरा माणसे अगळ नीकारु करसे, तीनाक मे बी भगवानेन सरग वाळा काहवाळ्‌या अगळ नीकारु कर दीस। ");
INSERT INTO bhi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“जु माणसेन पुर्‌यान वीरुद मां कायबी कवसे, तीनाक माफी जड़ जासे, बाकुन चुखली, आत्‌मान नाव-बद्‌दी करने वाळा माणुस काजे कदी माफी नी जड़े। ");
INSERT INTO bhi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“जत्‌यार माणसे तुहुंक भगवानेन भक्‌तीन घर मां, ने नीयाव करन्‌या ने राज करन्‌या अगळ घीसीन ली जासे, ती ईनी वातेन फीकुर घुण करु की हामुक कसा आपसा काजे बचाड़ने करीन अगा हय्‌न काय कवसुन; ");
INSERT INTO bhi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","काहाकी तीनीत टेमे चुखली-आत्‌मा तुहुंक सीकाड़से की तुहुंक काय-काय कह्‌वणु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","एक दाहड़ु माणसे ईसुन वात सामळने बाजी रवला। तत्‌यार टुळा मां सी एक अदमी ईसुक कह्‌यु, “ए मास्‌तर! मारा भाय काजे कय दे की चु मेसेक तीना माल-धन मायन मारु वाटु आप देय, तीना माल-धन काजे हामरु बास मरनेन टेमे हामरे धड़े रहणीदीन जाती रवलु।” ");
INSERT INTO bhi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ईसु तीनाक कह्‌यु, “ए माणुस! मारे धड़े तारु नीयाव करनेन ने वाटु पाड़नेन हक नी हय, काहाकी मेसेक कुय नी कह्‌यो की मे तुंद्‌रे दुय जणान ईचमां रय्‌न हींद्‌री चीजेन वाटा पाड़ दे।” ");
INSERT INTO bhi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","तत्‌यार ईसु तीना माणसे काजे कह्‌यु, चेतीन रवु ने हायाळ्‌ळा मां बणु! कुय अदमी कतरु बी लकपती हय, “तेरो मतलब ज नी हय की तेरी उमर वदी जासे।” ");
INSERT INTO bhi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","तत्‌यार ईसु तीनुक एक अमीर अदमीन दाखलु सामळायु: “एक मालदार अदमी धड़े एक खेत हतलो; तेरे मां बेसकी मेर पाकी।” ");
INSERT INTO bhi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","चु अमीर माणुस आपसा मन मां असु वीच्‌यार कर्‌यु, मारी आखी मेर मेकणे वाटे मारे धड़े कणगी नी हय। ");
INSERT INTO bhi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ती चु कह्‌यु, मेसेक मालुम छे की मे काय कर सको मे जुन्‌ला कणग्‌या काजे वेखड़ी दीस, ने तींद्‌रे सी मटा कणग्‌या बणायस। तत्‌यार मे मेर ने रवली आखी चीज तींद्‌रे मां मेकीस। ");
INSERT INTO bhi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ने मे मारा जीव काजे कवीस तारे धड़े बेसका साल लग, बेसको धन भेळो करलो छे, हेरेसी आराम कर, खा-पी ने मुजा कर! ");
INSERT INTO bhi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","बाकुन भगवान तीना अदमी काजे कह्‌यु, ए डेड़-अकल्‌या! ईनीत राते तारु जीव तारे धड़े सी मांग लीस ने तु मर जासी ने तु जो आपसा वाटे भेळो करलु छे, च आखो हय कुणीन रवसे? ने हय कुण ईनी चीजेन मुजा लेसे? ");
INSERT INTO bhi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","जु दाखलु कयदीन ईसु अगु कह्‌यु, “जु आपसा वाटे धन भेळो करे, चु माणुस बी हेरे डेड़-अकल्‌यान तसु मरीन सर जासे; बाकुन भगवानेन नींगा मां चु अमीर नी हय।” ");
INSERT INTO bhi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","चु हेरा चेला काजे कह्‌यु, हेरेसी मे तुहुं काजे कहो, काय खाय्‌न जीवसु, ने डील पर काय पेहरसुन करीन फीकुर घुण करु। ");
INSERT INTO bhi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","काहाकी जीव खाणा सी वदु मंहगलो छे ने डील पुथल्‌या सी महंगो छे। ");
INSERT INTO bhi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कागळान बारामां वीच्‌यार करु; चु नी ते वेरे, नीते काटे, ने नी ते तींद्‌रे धड़े दाणा मेकणे कणग्‌या हय; तेबी भगवान तीनुक पेट भरीन खावाड़े। तुहुं चिरला सी बेसका महंगा छे। ");
INSERT INTO bhi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","तुंद्‌रे मायन असु कुण छे, जु फीकुर करीन आपसी जीवाय्‌न ईतरीक बी उमर बड़ाय सके? ");
INSERT INTO bhi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","कदी तुहुंक अतरो नानो काम बी करता नी आवड़े, ती अळी दीसरी वातेन फीकुर काहा करु? ");
INSERT INTO bhi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","बयड़ा मायन फुलेक देखीन वीच्‌यार करु; हये कसाक अदे! ने हये नी मेहनत करे, ने नी दुरा काटे, तेबी मे तुहुंक कह्‌वो की सुलेमान राजाक बी आपसा पुरा ठट मां ईनु फुलेन तसा पुथल्‌या पेहरीन वारु नी। ");
INSERT INTO bhi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","तेरेमां कदी भगवान खळदाण मायन चारा काजे, जो आज छे ने वाहणे सुकीन चुल्‌हा मां धपणे वाटे हय जासे। तेबी असा पुथल्‌या पेहरावे ती ए कम भुरसा करने वाळा, ती चु तुहुंक काहा नी वारलु पुथल्‌या पेहरावसे? ");
INSERT INTO bhi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","अळी काय खासुन ने काय पीसुन करीन खाणे-पीणेन हेर मां करु ने काहनी बी वातेन फीकुर मां करु। ");
INSERT INTO bhi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ईनी कळीन माणसे ईनी आखी चीजेन फीकुर मां पड़ता रवे। बाकुन तुंद्‌रु सरगे मां रहण्‌यु बास जाणे की तुहुंक काय-काय चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","बाकुन तुहुं भगवानेन राजेन हेर करु, ती तुहुंक जी चीज बी जड़ जासे। ");
INSERT INTO bhi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ए नानला टुळा! बीहु मां, काहाकी तुंद्‌रु बास तुहुंक राज आपणे करीन खुस छे। ");
INSERT INTO bhi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","आपणो धन वेच देवु, ने दीसरा गरीब माणसे काजे दान कर देवु। आपणे वाटे असा बटवा तीयार करु, जे कदी जुना हय्‌न फाटे नी। सरगे मां आखो धन भेळो करु, जो कमी नी हवे, ने तेरे धड़े चुरी करने चुट्‌टु नी जाय सके। ने तीना धनेक थयलि काटण्‌यु कीड़ु नी खाय। ");
INSERT INTO bhi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","काहाकी चां तुंद्‌रो धन छे, चां तुंद्‌रो मन बी रवसे। ");
INSERT INTO bhi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“तुंद्‌री कमर वारु कसीन बांदली रवणु चाहजे, ने तुंद्‌रा दिवा धपला रवणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","तुहुं तीनु माणसेन तसा बणी जावु, जे हामरु मालीक ईयाव मां सी पछु कत्‌यार आवसे करीन वाट देख र्‌या, ने जत्‌यार तींद्‌रु मालीक ईयाव करीन पछु आवीन बारनो ठुके ती चु उतवाळुस तेरे वाटे बारनो उगाड़ देय। ");
INSERT INTO bhi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","वारलु छे चे चाकरी करन्‌या, तीनुक मालीक आवे, तत्‌यार जागला देख्‌यु! मे तुहुंक छाचलीन कहो चु मालीक आपसु कमर बांदीन वारती बणी जासे ने तीनुक खाणे बठाड़से ने एक-एक जणा काजे खाणु वाटीन खावाड़से। ");
INSERT INTO bhi_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ने बेसका वारु छे चे चाकरी करन्‌या, जत्‌यार मालीक आधी राते ने कुकड़ा वासणीक आवे, तत्‌यार तीनुक असात जागला देखे! ");
INSERT INTO bhi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","तुहुं ज ते वारु रीते जाणु-की कदी घर धेणी काजे मालुम रवे की चुट्‌टु काहने टेमे आवसे, ती चु आपसा घर मां चुरी नी हवणे देय। ");
INSERT INTO bhi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","तुहुं बी तीयार रवु, काहाकी तीने टेमे तुहुं तेरा आवणेन बारामां वीच्‌यारु बी नी, तीनेत टेमे माणसेन पुर्‌यु बी आवसे।” ");
INSERT INTO bhi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","तत्‌यार पतरस तीनाक कह्‌यु, “ए मालीक! तु, जु दाखलु हामरे वाटे कय र्‌यु, की आखा वाटे कय र्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","मालीक कह्‌यु, “असु कुण ईमानदार ने अक्‌कल वाळा जुगाड़-करन्‌यु माणुस छे, तीनाक तेरु मालीक आपसा पावर्‌यान मुख्‌यु बणावे ने कहें की तु मारा पावर्‌याक खाणे-पीणेन चीज टेमे-टेमे आप्‌या करजी?” ");
INSERT INTO bhi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","वारलु छे चु चाकरी करन्‌यु, तेरु मालीक आवे, तत्‌यार चु तीनाक सुपरुत करलो काम करतेलु देख्‌यु, ");
INSERT INTO bhi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","मे तुहुंक छाचीन कह्‌वो-चु मालीक तीनाक, आपसा आखा माल धन पर मुख्‌यु बणावीन ठेहरावसे। ");
INSERT INTO bhi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","बाकुन कदी चु चाकरी करन्‌यु आपसा मन मां वीच्‌यार करने बाजी जाय, मारु मालीक आवणे मां वार लागाड़ र्‌यु, करीन चु दीसरी पावरनी काजे ने पावर्‌या काजे ठुकणे, ने खाणे-पीणे ने दारु पीन छाकणे बाजी जाय। ");
INSERT INTO bhi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ती तीना चाकरी करन्‌यान मालीक असलेस दाहड़े आवसे जत्‌यार चु तेरी वाट नी देख र्‌यु हय ने असलेत टेम मां आवसे ची टेम तीनाक समज मां नी आवे। मालीक तीनाक बेसकी मटी डंड आपसे ने नी भुरसा करे असला भेळु भेसकी देसे। ");
INSERT INTO bhi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“आपणा मालीकेन मरजी जाणीन बी चु चाकरी करन्‌यु, मालीकेन मरजीन अनसारे काम नी कर्‌यु, अळी चु बेसकु कायनी मार खासे।” ");
INSERT INTO bhi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","बाकुन जु मालीकेन मरजी जाणे पाखुर गलत काम कर्‌यु, चु तेरे सी थुड़ुक मार खासे। ने तीनाक बेसको आपलो छे, तेरे धड़े बेसको मांग्‌से, ने तीनाक बेसको आपलो छे तेरे धड़े तीनाक आपला सी वदु मांगसे। ");
INSERT INTO bhi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","मे धरती पर आकठी लीन धपाड़ने आवलु छे, ने मारी हेर जी छे की जी आकठी हय माणसेन जीवाय मां धपी जाय ती बेसको वारु हय जाय। ");
INSERT INTO bhi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","मेसेक ते एक अळी बपतीस्‌मा लेणु छे, ने चो बपतीस्‌मा नी लेवाये, ती लग मे कांदरायलु रवीस। ");
INSERT INTO bhi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","मे धरती पर सांती लीन आवलु छे, तुहुं असो समजी र्‌या काय? मे तुहुं माणसेक अलग-अलग करने आवलु छे। ");
INSERT INTO bhi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","काहाकी हय सी कदी, एक घर मां पांच जणा हसे, ती तींद्‌रे मायन तीन जणा दुय जणान वीरुद करसे, ने चे दुय जणा तीनु तीन जणान वीरुद करसे। ");
INSERT INTO bhi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","बास आपसा पुर्‌यान वीरुद करसे, ने पुर्‌यु आपसा बासेन वीरुद करसे, माय आपसी पुरेन वीरुद करसे, ने पुरे आपसी मायन वीरुद करसे। सासुस आपसी उहड़ीसेन वीरुद करसे, “ने उहड़ीस आपसी सासुसेन वीरुद करसे।” ");
INSERT INTO bhi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ईसु तेरे पछळ आवणे वाळा बेसका माणसे काजे कह्‌यु, “कदी तुहुं बुडवणा सुदा सी आदळा नीकळते देखु, ती तत्‌यार कहुं, ‘की पाणी आवसे’ ने असोत हवे बी।” ");
INSERT INTO bhi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","जत्‌यार दाखणाव सुदे सी वाहळो आवे, ती कहुं की, आंधी आवसे ने असोत हवे। ");
INSERT INTO bhi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ए ढंगड़ा करन्‌या ढंगी! तुहुं सरगेम हवणेवाळी ने, धरती पर हवणेवाळी वात बेसका वारु आकणी लेवु, ती ईनु दाहड़ाम काय हय र्‌यो च काहा नी आकणता? ");
INSERT INTO bhi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","तुहुं आपसा जीव सी काहा नी वीच्‌यारतु की सय काय छे? ");
INSERT INTO bhi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","जत्‌यार तुहुं आपसा दुसमन पुठ्‌ये जेल मां जाणे बाजी र्‌या हय, ती वाटे तेरे साते वीच्‌यारीन झगड़ु भांग लेवु। कांखुर मायन असो नी हय जाय की चु तुहुंक नीयाव करने वाळान भीणी ली जाय, ने नीयाव करन्‌यु तुहुंक, सीपायड़ान हात मां कर देय, ने सीपायड़ा तुहुंक जेल मां कुंड देय। ");
INSERT INTO bhi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","मे तुहुंक कहुं, “जत्‌यार लग तुहुं एकेक पांचपाय नी आप देवु तत्‌यार लग चां सी नी नीकळाये।” ");
INSERT INTO bhi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","तीनी टेम मां थुड़ाक माणसे ईसु काजे तीनु गलील ईलाकान माणसेन बारामां कह्‌वणे आय गुया, चे यरुसलेमेन मंदीर मां जनवार्‌या मारीन बादा चड़ावणे आवला, पीलातुस तीनु सीपायड़ान साहरे माराय्‌न तींद्‌रो लुही तींद्‌रा बादा चड़ावला जनवार्‌यान लुही मां भेसकी देदलु। ");
INSERT INTO bhi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ईसु तींद्‌री खबर सामळीन तीनुक कह्‌यु, “गलील ईलाका मां रवण्‌या दीसरा आखा माणसे सी ज माणसे जादा पापी हतला, ने एरेन करीन हींद्‌रे पर गरा आय पड़ी, असा तुहुं समजी र्‌या काय। ");
INSERT INTO bhi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","मे तुहुंक कहो, असो हय; बाकुन कदी तुहुं पापेम सी मन फेरवीन भगवान सुदा नी अळु, ती आखा हींद्‌रेन तसात मरीन सर जासु।” ");
INSERT INTO bhi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","चे दुय कम वीस माणसे पर सीलोम नावेन मुंडेरी पड़ी ने दड़पाय्‌न मर गुया, चे यरुसलेम सहर मां रवण्‌या दीसरा माणसे सी जादा गुनाळा हतला, असा तुहुं समजी र्‌या काय? ");
INSERT INTO bhi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","मे तुहुंक कहो असो नी हय; बाकुन कदी तुहुं पापेम सी मन फेरवीन भगवान सुदा नी अळु, ती आखा हींद्‌रेन तसात मरीन सर जासु। ");
INSERT INTO bhi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ती ईसु ज दाखलु सामळायु, “काहनाक माणसेन अंगुरेन वाड़ी हतली, तीनी अंगुरेन वाड़ी मां एक अंजीरेन झाड़को हतलो। चु तीना अंजीरेन झाड़का पर फळ हेरने करीन आयु, बाकुन तीनाक एक बी फळ नी जड़्‌यो। ");
INSERT INTO bhi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ती चु अंगुरेन वाड़ी मां काम करन्‌या माणसे काजे कह्‌यु, देख, मे तीन साल लग ईना अंजीरेन झाड़कान फळ हेरने आय र्‌यु, बाकुन मेसेक एक बी फळ नी जड़्‌यो। ईनाक काट नाख काहाकी ज झाड़को ईना जागाक फालतु रुक र्‌यो? ");
INSERT INTO bhi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","बाकुन वाड़ी मां काम करन्‌यु माणुस कह्‌यु, ‘मालीक! ईने साल बी ईनाक रहणे दे। मे एरे चारेमेर खुदीन खद भरीस। ");
INSERT INTO bhi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","कदी ज आवणे वाळा साल फळे ती, वारु छे, नी ते ईनाक काटाड़ नाख्‌जी।’” ");
INSERT INTO bhi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ईसु एक भगवानेन भक्‌तीन घर मां आरामेन दाहड़े माणसे काजे वात सामळावणे बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","चां बेसका यहुदी-माणसे भेळा हय रवला। चां एक बायर बी हतली, तीनी बायरीन मांदी पाड़नी भुतड़ान आत्‌मा चस्‌टी रवली। ची तीनी बायर काजे ढंगी आळ देदली, ने ची काहली बी रीत सी सुदी उबी नी हवतेली। ने ची बायर दुय कम बीस साल लग ढंगी-ढंगी चालतेली। ");
INSERT INTO bhi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ईसु तीनीक देखीन धड़े बुलायु, ने तीनीक जुर सी कह्‌यु, “वो बायर, तु हय मांदवाड़ मां सी छुटीन, वारलु हय गुय!” ");
INSERT INTO bhi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ईसु तेरे पर हात मेक्‌यु, ने तत्‌यारुत ची सुदी हय गुय, ने भगवानेन बड़ाय करने बाजी गुय। ");
INSERT INTO bhi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","तीना भगवानेन भक्‌ती करन्‌या घरेन मुख्‌यु रीसाय गुयु, काहाकी ईसु तीनी बायरी काजे आराम करनेन दाहड़े वारु करलु। यहुदी-माणसे आराम करनेन दाहड़े काहनो बी काम करनु गलत समजतेला। हेरेसी चु मुख्‌यु, माणसेक कह्‌णे बाजी गुयु, “हाप्‌ता मां काम करने वाटे छव दाहड़ा छे, तीनु छव दाहड़ा मां काम करनु चाहजे। अतरा ईनु छव दाहड़ा मायन काहने बी दाहड़े आवीन वारु हवु, बाकुन आरामेन दाहड़े वारु हवणे करीन घुण आवु।” ");
INSERT INTO bhi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","जी वात सामळीन मालीक ईसु जपाप आप्‌यु; ए ढंगड़ा करन्‌या कदी तुंद्‌रु बेल नी ते गदड़ो पीसलो हय, ती तुहुं तीनाक आरामेन दाहड़े बी पाणी पीवाड़ने खुटे सी नी ली जावु काय? ");
INSERT INTO bhi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","जी बायर ते आपणा माणसे मायन छे। जी बायर बी अब्‌राहमेन पुरे छे, हीनीक मांदी पाड़नी भुतड़ान आत्‌मा दुय कम बीस साल लग चस्‌टीन आपसा कब्‌जाम कर रवली। आराम करनेन दाहड़े हेरेमां सी मांदु करन्‌यु भुतड़ु छेटु करनु, वारु नी हय काय? ");
INSERT INTO bhi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ईसुन जी वात सामळीन ईसुन वीरुद करन्‌या आखा माणसे लाजवाय गुया, बाकुन दीसरा आखा माणसे, ईसु बेसकु वारु काम कर्‌यु, करीन बेसका खुस हय गुया। ");
INSERT INTO bhi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ईसु कह्‌यु, “भगवानेन राज कुणीन तसों छे? मे ईना राज काजे काहने चीजे करीन तुलो? ");
INSERT INTO bhi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","च रायन एक बीजेन तसों छे, तीनाक काहनुस माणुस ली जाय्‌न आपसा खेतेम एर देय। ने च वदतो-वदतो झाड़को बण गुयो। ने सरगेन चिरला तेरा डाळ्‌या मां आवीन पुत्‌रा बणावीन रवणे बाजी गुया।” ");
INSERT INTO bhi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ईसु अळी कह्‌यु, “मे भगवानेन राज काजे काहने चीजे सी तुलो? ");
INSERT INTO bhi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","भगवानेन राज तीना खाण्‌या-सुडान तसु छे, तीनाक लीन काहनीक बायर तीन चोवकी पीठा मां भेसकी, ने आखु पीठान जेवणु आय गुयु।” ");
INSERT INTO bhi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ईसु सहरे-सहरेम, ने गांव-गांव वात सीकाड़तु जाय्‌न यरुसलेम भीणी जाणे बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","काहनुक माणुस हीनाक पुछ्‌यु, “ए मालीक! छुटकारु हात करन्‌या थुड़ाक माणसे छे काय?” ने ईसु तीनुक कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","साकेड़ले बारने मायन भगवानेन राजेम भरायणेन पुरी-पुरी कुसीत करु, काहाकी मे तुहुंक कहो बेसका छे माणसे भगवानेन राजेम भरायणे करसे, बाकुन भराय नी सके। ");
INSERT INTO bhi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","जत्‌यार घरेन मालीक उठीन बारनो बन्‌द कर देदु हय, ने तुहुं बाहर उबा रवीन बारनो ठुकीन कह्‌वणे बाजी जासु, मालीक! हामरे वाटे बारनो उघाड़ दे। ती चु तुहुंक कह्‌वसे, तुहुं कुण छे मेसेक नी मालुम हय। ");
INSERT INTO bhi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ती तुहुं कह्‌वणे बाजी जासु, हामु तारे अगळ खादा पीदा ने तु हामरा हाटेम वात सीकाड़तेलु! ");
INSERT INTO bhi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","बाकुन चु तुहुंक कह्‌वसे, तुहुं कुण छे च मेसेक नी मालुम हय, ए आखी भातीन पाप करन्‌या! तुहुं आखा मारेन्‌चां सी छेटे हय जावु! ");
INSERT INTO bhi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","जत्‌यार तुहुं अब्‌राहम, ने इसाक, ने याकुप ने भगवानेन अघी सी आवणे वाळी वात आखा माणसे काजे भगवानेन राज मां देखसु, बाकुन आपसे काजे बाहार नीकाळता देखसु, ती तुहुं कलपी-कलपीन रड़सु ने दात काजे ककड़ावता रवसु। ");
INSERT INTO bhi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","उगेवणा ने बुडवणा सी, धुराव ने दखणाव सी माणसे आवसे ने भगवानेन राजेन पंगत मां भेसकायसे। ");
INSERT INTO bhi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ने देखु, जे पछळ छे, “चे अगळ हय जासे ने थुड़ाक जे अगळ छे, चे पछळ हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","तीनी टेमे थुड़ाक फरीसी माणसे आवीन ईसुक कह्‌या, “जां सी नीकळीन जाती रव, काहाकी हेरोदेस राजु तुसेक मारने कर रयु।” ");
INSERT INTO bhi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ईसु तीनुक कह्‌यु, “जाय्‌न तीनी फुंदाळी खुखड़ीक कय देवु: मे आज ने वाहणे माणसे मां भरायला भुतड़ान आत्‌मा काजे छेटु करीस ने मांदलाक वारु करीस ने तीसरे दाहड़े काम पुरो कर दीस।” ");
INSERT INTO bhi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","तेबी मेसेक आज, ने वाहणे ने परुनदाहड़े काम करतुत रवणु छे, काहाकी असो हय नी हय सके की काहनु बी भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळा काजे यरुसलेम सहर छुड़ीन दीसरे जागे मारे। ");
INSERT INTO bhi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ए यरुसलेम! ए यरुसलेम! तु भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळा काजे मार नाखे ने भगवान तीनु माणसे काजे तारे धड़े मकेल्‌लु तीनु माणसे काजे बी तु दगड़ाटीन मार नाखे। जसी कुकड़ी आपसा पीच्‌या काजे आपसा पाखड़ा तळे भेळा कर लेय, तसुत मे बेसका कावा तारी अवल्‌यात काजे मारा पाखड़ा तळे भेळा कर लेय, बाकुन तुहुं मारु नीकारु कर देदा। ");
INSERT INTO bhi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","देखु, तुंद्‌रो घर उजड़लो छुट जासे। ने मे तुहुंक कहो, तुहुं मेसेक तत्‌यार लग नी देखु, जत्‌यार लग तुहुं ज नी कहुं, बरकतवाळु छे चु, जु मालीक भगवानेन नाव सी आवे! ");
INSERT INTO bhi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","यहुदी माणसेन आरामेन दाहड़े ईसु फरीसी माणसेन एक मुख्‌यान घर रुटा खाणे गुयु; ने चे माणसे ईसु काजे मारनेन तीयारी मां हतला। ");
INSERT INTO bhi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ने देखु, एक माणुस ईसु अगळ हतलु, तीना काजे पाण झेलु रुग हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ने ईसु यहुदी धरमेन मास्‌तर्‌या ने फरीसी माणसेक कह्‌यु, “आरामेन दाहड़े मांदला माणसेक वारु करनु सय छे, की नी हय?” ");
INSERT INTO bhi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","बाकुन चे हुगात रय र्‌या। अतरा मां ईसु तीना मांदला माणसेक वारु कर देदु, ने तीनाक वळायन छेटे मकली देदु। ");
INSERT INTO bhi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ने ईसु तीनु काजे कह्‌यु, “तुंद्‌रे मायन असु कुण छे, तेरु पुर्‌यु नी ते बेल आरामेन दाहड़े कुवा मां हीट पड़े, ने चु तीनाक आरामेन दाहड़ेत तत्‌यारुत बाहर नीकाळीन नी लावे?” ");
INSERT INTO bhi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ने जी वात सामळीन चे ईसु काजे काय बी जपाप नी आप सक्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","मेजवान्‌या काजे मामार-मामार बसणेन वारु जागा नेवाड़तेला देखीन ईसु तीनुक एक दाखलु सामळायु, ");
INSERT INTO bhi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","जत्‌यार बी कुय तुसेक ईयाव मां नेवतो आपीन बुलावे, ती तु आखाम पेहली जागाम घुण बठे। कांखुर मायन असो ते नी हय जाय की नेवता आपण्‌यु तारे सी बी जादा अंजाण्‌याक नेवता आपीन मेजवान्‌यु बुलायु हय। ");
INSERT INTO bhi_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","चु बी आय जाय ती तुहुं दुयु जणा काजे नेवता आपीन बुलावणे वाळु आवीन तुसेक कह्‌वे, ईनाक हेरी जागा आपु ने तुसेक लाजवाय्‌न आखाम पछळ जाय्‌न बसणु पड़े। ");
INSERT INTO bhi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","बाकुन जत्‌यार तुसेक नेवता आपीन बुलावे, ती तु जाय्‌न आखाम पछला जागा पर बस जां। तेरे सी नेवता आपीन मेजवान्‌यु बुलावणे वाळु आवीन तुसेक ज कह्‌वे, ए दुस्‌तीदार! अगु आवीन बस जां। ईने रीते आखा मेजवान्‌यान अगळ तुसेक ईज्‌जत जड़से ने तारी बड़ाय करसे। ");
INSERT INTO bhi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","काहाकी जु आपसा काजे मटु समजे, तीनाक नानु बणाय देसे, ने जु कुय बी आपसा काजे नानु समजे, तीनाक आखा सी मटु बणाय देसे। ");
INSERT INTO bhi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","जु ईसुक नेवतो आपीन खाणे बुलावलु तीनाक बी ईसु कह्‌यु, “जत्‌यार तु दीसु नी ते राती खातरी करीन माणसेक पंगत बठाड़े ती आपसा दुस्‌तीदार काजे, आपसा भायस काजे, ने आपसा भाय-बेटा काजे, ने आड़े-धड़े वाळा मालदार काजे घुण बुलावे, काहाकी कांखुर मायन असो नी हय जाय की चे बी तुसेक नेवतो आपीन बुलाय लेय ने पछी खातरी करीन बदलु चुकाड़ देय। ");
INSERT INTO bhi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","बाकुन जत्‌यार तु पंगत देय, ती गरीब, लुल्‌ला, लंगड़ा ने आंदळा काजे बुलावजी। ");
INSERT INTO bhi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ने तु बेसकु वारु कह्‌वायसी काहाकी तींद्‌रे धड़े पछो आपणेन काय नी हय, बाकुन जत्‌यार धरमी माणसे पछा मर्‌या-सर्‌याम सी जीवता हवसे ने दाहड़े पछा वाळ देसे।” ");
INSERT INTO bhi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ईसु पुठ्‌ये रुटा खाण्‌या मायन काहनुस ईसुन वात सामळीन ईसु काजे कह्‌यु, “चे बेसका वारु छे, जत्‌यार भगवानेन राजेन वेस मां आवसे तीने टेमे भगवान साते बसीन रुटा खासे।” ");
INSERT INTO bhi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","तीना माणसेन वात सामळीन ईसु तीनुक जी काहनी सामळायु! काहनेस दाहड़े एक बेसकी मटी पंगत देदु, ने चु बेसका माणसेक नेवता आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","जत्‌यार खाणो बण गुयो, ती पंगतेन टेम मां चु आपसा एक पावर्‌या काजे नेवता आपलु तींद्‌रे सी ज कय मकल्‌यु खाणो-खाणे चालु, हय आखो खाणो तीयार छे। ");
INSERT INTO bhi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","बाकुन चे नी आया ने आखान-आखा हामुक नी आवाये करीन माफी मांगणे बाजी गुया; पेहलु कह्‌यु, मे हय एक खेत मुल लेदलु छे, ने च खेत देखणे करीन जाणु छे; अतराम मे तारे सी वीन्‌ती करो की मेसेक नी आवाये, मेसेक माफ कर दे। ");
INSERT INTO bhi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","दीसरु कह्‌यु, मे पांच जुड़ी बेल मुल लेदलु छे, ने तीनुक जुपीन देखणु छे। अतराम मे वीन्‌ती करो की मेसेक नी आवाये, मेसेक माफ कर दे। ");
INSERT INTO bhi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ने तीसरु कह्‌यु, “हय मारु ईयाव हवलु छे, अतराम मेसेक नी आवाये मेसेक माफ कर दे।” ");
INSERT INTO bhi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","पावर्‌यु पछु आयु ने चु आपसा मालीक काजे जी वात बताड़ देदु। जी वात सामळीन मालीक बेसकु रीसवाय गुयु, “तत्‌यार चु आपसा पावर्‌याक हुकुम आप्‌यु ‘सहर मां गळ्‌ये-गळ्‌ये उतवाळुस जाय्‌न गरीब, लुला, आंदळा ने पांगळा काजे बुलाय लाव।’ पावर्‌यु मालीकेन हुकुम मानीन बुलावणे जाती र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ने चु पावर्‌यु पछु आवीन मालीक काजे कह्‌यु, ए मालीक! ‘जसु तु कह्‌यु, तसुत मे माणसेक बुलाय लायु। तेबी माणसेक बसणे वाटे जागा बच रय।’ ");
INSERT INTO bhi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","तत्‌यार मालीक आपसा पावर्‌याक कह्‌यु, सयड़के ने खेतन वाड़ी मां जां, ने चां वाळा माणसेक बी पंगत मां बुलाय लाव। मारो घर माणसे सी भराय जाणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","मे हेरेन करीन कहो की तीनु माणसेक मे पेहल बुलावलु, तींद्‌रे मायन कुय बी मारी पंगतेन खाणो लग नी चाखणु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ईसु पुठ्‌ये-पुठ्‌ये एक बेसकु माणसेन टुळु जाणे बाजी रवलु। ती ईसु पछु फीरीन माणसेक कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","कदी कुय मारे साते आवे, ने आपसा माय-बास, घरवाळीक, ने आपसान पुर्‌या ने भाय-बहणस्‌याक ने आपसा जीवेक मारे सी जादा परम करे, ती चु मारु चेलु नी बण सके। ");
INSERT INTO bhi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","जु कुय आपसान कुरुस नी हाकले; ने मारे पछळ नी आवे; चु बी मारु चेलु नी बण सके। ");
INSERT INTO bhi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","तुंद्‌रेम असु कुण छे, जु मटलो घर बणावणे हींडे, बाकुन पेहले बसीन खरचान हीसाब नी जुड़े की घर बणावणे वाटे मारे धड़े खरचु हय की नी हय? ");
INSERT INTO bhi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","कांखुर मायन असो नी हय जाय की नेहु खुदीन दगड़ान नेहु उठाड़ लेय बाकुन पुरो नी हवे ती आखा देखणे वाळा ज कह्‌ता जाय्‌न तेरी हासी-उड़ावसे, ");
INSERT INTO bhi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","की जु माणुस बणावणे ते बाजी गुयु बाकुन पुरो घर नी बणाय सके, ने बणावते-बणावते पुरो घर नी बण्‌यो। ");
INSERT INTO bhi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ने असु काहनु राजा हसे, चु दीसरा राजा साते लड़ायणे जातु हय, ने पेहले बसीन जु वीच्‌यार नी करे की जु वीस-हजारेन टुळु लीन मारे भीणी आवणे बाजी र्‌यु, तेरे साते मेसेक दस हजार टुळु लीन लड़ाय मां जीत जड़ जासे काय? ");
INSERT INTO bhi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","कदी तीनाक लड़ाय मां जीत जड़ जासे असु भुरसु नी हय ती चु छेटेत रय्‌न तेरे भीणी ज कय मकेलसे की आपणु लड़ाय नी करता बाकुन मेळ कर लेजे। ");
INSERT INTO bhi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“ईनीत रीती सी तुंद्‌रे मांयन जु आपसो आखो काय मारे वाटे छुड़ी नी देय, ती लग चु मारु चेलु नी हय सके।” ");
INSERT INTO bhi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","नण वारु चीज छे, बाकुन कदी च आपसोत मुळो हय जाय, ती च काहने चीजे पछो खारो हवसे? ");
INSERT INTO bhi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","च नण नी ते खेतेम काम आवे, ने नी चो खुदेन काम आवे; तीना नण काजे माणसे बाहर धुळाम ली जाय्‌न नाखसे। तेरे धड़े सामळन्‌या कान्‌टा हय, ती चे सामळी लेय। ");
INSERT INTO bhi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","एक दाहड़ु ईसु माणसेक सीकाड़ने बाजी रवलु, सामळन्‌या मां बेसका फाळु उकाळन्‌या हकदार्‌या ने पापी माणसे बी हतला, चे यहुदी धरमेन कायदाक नी पाळतेला। ");
INSERT INTO bhi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ने यहुदी धरमेन फरीसी माणसे ने यहुदी-सास्‌तुर सीकाड़न्‌या वात करता जाय्‌न कह्‌वणे बाजी गुया, “जु माणुस ते पापी साते बसीन मजा करे ने तींद्‌रे साते रुटा बी खाय।” ");
INSERT INTO bhi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","तत्‌यार ईसु तीनुक एक दाखलु कय्‌न सामळायु, ");
INSERT INTO bhi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","मान लेवु तुंद्‌रे मायन कुय धड़े सोव गाडरा हय, ने तीनु मायन एक खुवाय जाय। ती चु काय करसे? चु दीसरा एक कम सोव गाडराक बयड़ा मां रहणी देसे, ने तीना खुवायला गाडरा काजे तत्‌यार लग हेरसे, जत्‌यार लग च जड़ी नी जाय। ");
INSERT INTO bhi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ने जत्‌यार च जड़ जाय, ती चु तीनाक खांदा पर बठाड़ीन घर ली आवसे। ");
INSERT INTO bhi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ने घर आवीन आपसा दुस्‌तीदार्‌या ने पुठ्‌ये वाळा काजे पंगत मां बुलावसे ने खावाड़से ने चु तीनाक कवसे, मेसेक खुवायलो गाडरो जड़ गुयो। अतराम मारे साते भेसकायन खुस हय जावु। ");
INSERT INTO bhi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","मे तुहुंक कहो की, “ईनी रीते भगवान तीना पापीन करता बेसकु खुस हवसे, जु पाप करनु छुड़ देय ने भगवानेन मरजीन अनसारे काम करने बाजी जाय। बाकुन तीनु एक कम सोव धरमी माणसेन करता अतरो जबर खुस नी हवे, चे ज वीच्‌यारे की हामु धरमी छे, ने हामुक पापेम सी मन फेरवीन भगवान भीणी वळनु जरुड़ी नी हय।” ");
INSERT INTO bhi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ईसु एक दीसरु दाखलु सामळायु, मान लेवु काहनी बायर धड़े चांदीन दस सीक्‌का हय ने तींद्‌रे मायन एक खुवाय जाय ती। ची काय करसे? ची दिवु धपाड़से ने खुवायला सीक्‌का काजे हेरने करीन आखो घर बाहरसे। ची आखे जागे धीरी रवीन हेरसे। जत्‌यार लग चु सीक्‌कु नी जड़े तत्‌यार लग हेरसे। ");
INSERT INTO bhi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","जड़ जासे ती ची आपसा दुस्‌तीदार्‌याक ने घर धड़े वाळाक बुलावसे ने तीनुक कवसे, मे बेसकी खुस छे, काहाकी मेसेक खुवायलु रुप्‌यु जड़ गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","मे तुहुंक कहो ईनी रीते जत्‌यार एक पापी पाप करनु छुड़ देय, ने भगवानेन मरजीन अनसारे काम करने बाजी जाय ती भगवान आपसा सरग वाळा काहवाळ्‌या भेळ खुस हये। ");
INSERT INTO bhi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","अळी ईसु एक दीसरु दाखलु सामळायु, काहनाक एक माणसेन दुय पुर्‌या हतला। ");
INSERT INTO bhi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","एक दाहड़ु नानलु पुर्‌यु हेरा बास सी आवीन कह्‌यु, ए बास! माल धनेन जु मारु वाटु छे, चु मेसेक आप दे। अतराम तेरु बास दुय पुर्‌याम तींद्‌रु वाटु पाड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","थुड़ाक दाहड़ा हय गुया ने अळी नानलु पुर्‌यु आपसा आखा धनेन हीस्‌सु वेच देदु, ने पयस्‌या भेळा करीन काहनाक दीसरा देसेम लांबेत जाती र्‌यु, ने चां चु आपसा आखा पयस्‌या गलत काम मां उजाड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","जत्‌यार चु आखो काय उजाड़ देदु, ती तीना देसेम बेसकु काळ पड़्‌यु, ने चु भुकलु घाबराय गुयु; काहाकी तेरे धड़े पयस्‌या नी हतला। ");
INSERT INTO bhi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","हेरे सी चु तीना देसेम एक अमीर माणसेन चां काम करने गुयु। चु तीनाक आपसा खेते मां सुहर्‌या चारने करीन मकली देदु। ");
INSERT INTO bhi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","चु अतरु भुकलु घाबराय गुयु, की ज खळ सुहर्‌या खात्‌ला, च खळ खाणे हींडतेलु, बाकुन चु खळ बी तीनाक खाणे करीन नी आपतेला। ");
INSERT INTO bhi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","आकरी मां, चु वीच्‌यार कर्‌यु की मे कतरु गांडु छे। चु आपसाक कह्‌यु, मारा बासेन घर मां आखा दाहड़क्‌या काजे पेट भरीन रुटा जड़े, ने मे जां भुकलु मर र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","मे मारा बासेन्‌चां पछु जायस ने तीनाक कवीस, “बास मे तारा वीरुद मां ने भगवानेन वीरुद मां पाप करलु छे। ");
INSERT INTO bhi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","मे तारु पुर्‌यु कवायणेन हकदार्‌यु, नी हय। बाकुन मेसेक तारा एक दाहड़क्‌यान तसु मेसेक राख ले।” ");
INSERT INTO bhi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ती चु असु वीच्‌यार करीन आपसा बासेन घर भीणी चाल पड़्‌यु। हय चु आपसा बासेन घर सी छेटेस हतलु, की तेरु बास तीनाक देख लेदु, ने चु गीण-दया सी भराय गुयु। ने आपसा पुर्‌या काजे भेळु हवणे करीन चु दवड़ीन गुयु ने तीनाक गळे लागाड़्‌यु, ने तीनाक बेसकु गुळा देदु। ");
INSERT INTO bhi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ती पुर्‌यु तीनाक कह्‌यु, बास! मे सरग वाळा भगवानेन वीरुद मां ने तारे वीरुद मां पाप करलु छे। मे तारु पुर्‌यु कवायणेन हकदार्‌यु नी हय। ");
INSERT INTO bhi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","बाकुन बास आपसा पावर्‌याक बुलायु, ने तीनुक कह्‌यु, उतवाळास जाय्‌न आखाम सी वारु पुथल्‌या लाय्‌न ईना मारा पुर्‌याक पेहरावु, एक मुंदी हातेन आंगळी मां पेहरावु ने पाये मां खासड़ा पेहरावु। ");
INSERT INTO bhi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ने अळी आपणु आखाम वारलु केवड़ु लाय्‌न मारु। ने एक मट्‌ली पंगत देसु, ने खुसी मनावसु। ");
INSERT INTO bhi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","काहाकी मारु जु पुर्‌यु मर गुयलु, बाकुन हय जीवतु हय गुयु। चु खुवाय गुयलु, बाकुन हय जड़ गुयु। ती अळी खुसीन पाल्‌टी सुरु हय गुय। ");
INSERT INTO bhi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","तीनी टेमे तेरु मट्‌लु पुर्‌यु खेतेम हतलु। ने जत्‌यार चु मट्‌लु भायस खेतेम सी घर आवीन घर धड़े आयु, ती चु वाजा-गाजा सामळीन ने माणसे काजे नाचतेला देखीन चकराय गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ने चु एक पावर्‌याक बुलायु, ने तीनाक पुछ्‌यु की ज काय हय र्‌यो। ");
INSERT INTO bhi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","चु पावर्‌यु जपाप आप्‌यु, तारु नानलु भायस वारु पछु घर आवती र्‌यु, करीन तारु बास हामुक आखाम मट्‌लु केवड़ु मांगाड़ीन माराल्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","जी वात सामळीन चु मट्‌लु भायस बेसकु रीसवाय गुयु, ने घर मां लग नी गुयु; बाकुन तेरु बास बाहर आयु ने तीनाक घर मां ली जाणे करीन आयु ने मनावणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","बाकुन चु आपसा बासेक कह्‌यु, देख, मे अतरा साल लग तारी सेवा करतु आय र्‌यु, ने कदी तारी वात नी टाळ्‌यु। बाकुन तु मेसेक मारा दुस्‌तीदार्‌या पुठ्‌ये मारीन खाणे ने खुसी मनावणे करीन तु मेसेक एक बुकड़ो लग नी आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","बाकुन तारु जु नानलु पुर्‌यु घर छुड़ीन जाती रवलु, ने तारा आखा पयस्‌या रंडीन्‌चां जाय्‌न उजाड़ देदु, ने हय चु पछु घर आयु, ती तु तेरे धड़े आखाम मट्‌लु केवड़ु मांगाड़ीन मार्‌यु! ");
INSERT INTO bhi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","मटला पुर्‌यान वात सामळीन तेरु बास तीनाक कह्‌यु, मारा बेटा, तु जां जलम सी मारे पुठ्‌ये रवे। ने मारो आखो तत्‌रो तारोत छे। ");
INSERT INTO bhi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","बाकुन हय खुस हवणु चाहजे, ने पंगत मां बसीन खाणान मजा लेणु चाहजे काहाकी तारु भायस मर गुयलु, “बाकुन हय जीवतु हय गुयु। चु खुवाय गुयलु बाकुन हय जड़ गुयु।” ");
INSERT INTO bhi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ईसु हेरा चेला सी बी कह्‌यु, “काहनाक अमीर अदमीन एक पयस्‌यान हीसाब राखण्‌यु पावर्‌यु हतलु। माणसे तीना अमीर माणसेन्‌चां जाय्‌न तीना पयस्‌यान हीसाब राखण्‌या पावर्‌या पर जु गुनु लागाड़्‌या की जु पावर तारो धन उजाड़ने बाजी र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","अतराम चु अमीर माणुस तीना पयस्‌यान हीसाब राखण्‌या पावर्‌या काजे बुलायन कह्‌यु, ज मे तारा बारामां काय सामळने बाजी रयु। तारा पयस्‌यान हीसाब-किताप देखाड़, काहाकी तु हय सी पयस्‌यान हीसाब करनेन पावराय सी छेटे हय जां। ");
INSERT INTO bhi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ती चु पयस्‌यान हीसाब-किताप करन्‌यु मने-मन ज वीच्‌यारतु जाय्‌न कह्‌यु, मे हय काय करो? मारु मालीक मेसेक ईनी पावराय सी छेटु करने बाजी रयु। ती हय काय करो, काहाकी धुळु खुदणेन ताकत ते मारेम नी हय; ने माणसे धड़े पयस्‌या ने दाणा मांगणे मां मेसेक सरम आवे। ");
INSERT INTO bhi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","जत्‌यार मे पयस्‌यान हीसाबेन पावराय सी छेटे हय जायस, ती माणसे मेसेक आपसे घर मारु आव-भाव करीन आसरु देणु चाहजे। करीन मेसेक काय करनु चाहजे, हव हय, मेसेक समज मां आयो की मेसेक काय करनु चाहजे, ");
INSERT INTO bhi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","असु वीच्‌यार करीन चु आपसा मालीकेन करजा वाळा माणसेक एक-एक करीन बुलायु। ने पेहला माणसे काजे पुछ्‌यु, तारे पर मारा मालीकेन कतरु करजु छे। ");
INSERT INTO bhi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","चु करजा वाळु माणुस कह्‌यु, सोव मण तेल। तत्‌यार पयस्‌यान हीसाब करन्‌यु पावर्‌यु कह्‌यु, तारा खातान चापड़ु हातेम ले, ने बसीन उतवाळुस पचास मण लिख दे। ");
INSERT INTO bhi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","अळी चु दीसराक पुछ्‌यु, तारे पर मारा मालीकेन कतरु करजु छे? चु करजा वाळु माणुस कह्‌यु, सोव कुंटल गहुं। तत्‌यार पयस्‌यान हीसाब करन्‌यु पावर्‌यु कह्‌यु, तारा खातान चापड़ु हातेम लीन, ने बसीन उतवाळुस आस्‌सी कुंटल लिख दे। ");
INSERT INTO bhi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","मालीक तीना पापी पयस्‌यान हीसाब करन्‌या पावर्‌या काजे बेसकु वारु कह्‌यु काहाकी चु बेसकु चतराये काम कर्‌यु; काहाकी ईनी कळीन माणसेन अवल्‌यात आपसा लेण-देण मां वीजाळान अवल्‌यात सी वदु हुस्‌यार छे। ");
INSERT INTO bhi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","तेरेमां मे तुहुंक कह्‌वो ईनी कळीन धन साहरे आपसा वाटे दुस्‌तीदार्‌या बणाय लेवु, तेरेसी पापेन धन सर जासे, ती चे आवणेवाळी जलमेन रहणेन जागे तुंद्‌रो आव-भाव करसे। ");
INSERT INTO bhi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“जु नानली सी बी नानली वातेम ईमान राखे, चु मट्‌ली वातेम बी ईमानदार छे, ने जु नानली सी बी नानली वातेम लुच्‌चु छे, चु मट्‌ली वातेम बी लुच्‌चु छे। ");
INSERT INTO bhi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","कदी तुहुं ईनी कळीन धन मां बी भुरसा लायक नी बण्‌या, ती तुंद्‌रे पर भुरसु करीन, तुहुंक छाचलो धन कुण आपसे? ");
INSERT INTO bhi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ने कदी तुहुं पराया धन-दोवलत मां ईमान नी राख्‌या, ती तुहुंक, तुंद्‌रोत धन दोवलत कुण आपसे? ");
INSERT INTO bhi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“कुय बी पावर्‌या दुय मालीकेन चाकरी नी कराये; काहाकी चु एक मालीक सी कुहराय ने दीसरा मालीक सी परम सी रवे। नीते एक मालीक साते हेळी-मेळीन रवसे ने दीसरा मालीक काजे भुंडोत जाणसे। तुहुंक भगवानेन ने धन-दोवलतेन दुयुन चाकरी नी कराये।” ");
INSERT INTO bhi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","फरीसी माणसे, पयस्‌यान हायाळ्‌ळा हतला, अळी चे जी वात सामळीन माणसे अगळ ईसुन हासी उडाड़तेला। ");
INSERT INTO bhi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ईसु तीनु फरीसी माणसे काजे कह्‌यु, “तुहुं माणसे अगळ ते धरमी हवणेन ढंग करु बाकुन भगवान ते तुंद्‌रा हीया मन काजे जाणे।” काहाकी जी वात माणसेन नींगा मां बेसकी वारु छे, ची वात भगवानेन नींगा मां भुंडीत आवे असी छे। ");
INSERT INTO bhi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“भगवानेन कायदान सास्‌तुर ने भगवानेन अघली वात बताड़ने वाळा युहन्‌नान टेम लग हतला, पेहले सीत भगवानेन राज मां भरायणे करीन खुस-खबरेन नेवतो आखाक बेसको जड़ रह्‌यो। ने माणसे ईना राजेन बेसका उतवाळास भरायणे बाजी रया।” ");
INSERT INTO bhi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“सरग ने धरती टळनु ते नक्‌खी छे, बाकुन नेम कायदान एक बी आकड़ान नानोस टीपको पुरो हये पाखुर नी टळे।” ");
INSERT INTO bhi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ईसु अगु कवतु गुयु, “जु कुय आपसी घरवाळीक छुड़ीन, काहनीक दीसरी बायरी साते ईयाव करे, चु छीनाळो करे; ने जु कुय तीनी छुल्‌ली बायरी साते ईयाव करे, चु बी छीनाळो करे।” ");
INSERT INTO bhi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ईसु एक दाखलु अळी कह्‌यु “एक बेसकु लकपती माणुस हतलु, चु बेसका महंगा जामण्‌या पुथल्‌या ने चमकण्‌या पुथल्‌या पेहरतेलु, ने दाहड़ीन वारु सुक मां रवीन मजा करतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","तीना लकपतीन बारना पर लाजर नावेन एक गरीब माणुस पड़ रवलु, तेरे आखे डील मां फुड़ा नीकळी रवला। तीनाक चे काहनाक चां नाख दीन जात रह्‌लो ");
INSERT INTO bhi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ने चु गरीब माणुस, आपसो पेट भरने करीन, लकपती माणसेन इस्‌टाळो खाणेन हेर करतेलु; बाकुन च बी तीनाक नी जड़तेलो, ने कुतरा लग आवीन तेरा डील पर फुड़ा काजे चाटतेला। ");
INSERT INTO bhi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ने अळी एक दाहड़ु चु गरीब लाजर मर गुयु, ने सरग वाळा काहवाळ्‌या तीना लाजरेन जीव काजे सरगेम लीजाय्‌न अब्‌राहमेन खुळाम बठाड़ देदा। ने अळी एक दाहड़ु चु अमीर माणुस बी मर गुयु, ने तीनाक गाड़ी देदा। ");
INSERT INTO bhi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ने चु नरक मां बेसकु वेला करतु जाय्‌न उपर देख्‌यु, बेसके लांबे रय्‌न अब्‌राहमेन खुळा मां लाजर काजे देख्‌यु ");
INSERT INTO bhi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","चु अमीर माणुस आयड़ीन कह्‌यु, ‘बास अब्‌राहम! मारे पर दया कर, ने लाजर काजे मारेन्‌चां मकली दे, हेरेन करीन चु आपसी आंगळीन छेंडु पाणी मां भीजवीन मारी जीप काजे सेळवी देय, काहाकी मे ईनी आंच मां बेसकु वेला कर र्‌यु!’ ");
INSERT INTO bhi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","अब्‌राहम तीना लकपती माणुस काजे कह्‌यु, बेटा, तु धरती पर वारु जीवन काजे हेर कर की तुसेक धरती पर वारु जीवाय मां सुकुन-सुक जड़लु, ने लाजर काजे दुखुत-दुख जड़लो; हय हीनाक जां सुक ने सांती जड़ रय, ने तीनेत हीसाबे तुसेक वेला करनु पड़ रयो। ");
INSERT INTO bhi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ने ईनी वातेक छुड़ीन जी वात बी छे की हामरे ने तारे ईचमां एक बेसकी मटी खुय छे; अतराम कदी कुय तारेन चां जाणे बी हींडे, तेबी चु नी जाय सके; ने कदी कुय हया सी ईनी धड़े आवणे बी हींडे, तेबी हया सी तीनाक ईनी धड़े नी आवाये। ");
INSERT INTO bhi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","चु लकपती माणुस अब्‌राहम काजे कह्‌यु, ए अब्‌राहम बास! मे तारे धड़े वीन्‌ती करो की तु लाजर काजे मारा बासेन घर मकली दे। ");
INSERT INTO bhi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","काहाकी मारा पांच भायस छे, ने लाजर मार घर जाय्‌न जां आखो जो हयो तीनी वातेन गवा देसे, ने तीनुक जी वाते कहीन चेताय देसे। नी ते कांखुर मायन तींद्‌रे धड़े बी असोत असो ने चे बी ईना वेळान जागा मां आवती रवे। ");
INSERT INTO bhi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","अब्‌राहम तीना लकपती माणुस काजे कह्‌यु, मुसान ने भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळान किताप तींद्‌रे धड़े छे, तीनुक तींद्‌री सामळनु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","चु लकपती माणुस अब्‌राहम काजे कह्‌यु, ‘ए बास अब्‌राहम; चे तींद्‌री वात काजे सामळे; बाकुन कदी मरला माणसे मायन कुय तींद्‌रेन्‌चां जाय, ती चे पापे भीणी सी मन फेरवीन भगवान भीणी आवसे।’ ");
INSERT INTO bhi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","बाकुन अब्‌राहम तीना लकपती माणसेक कह्‌यु, जत्‌यार चे मुसान ने भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळान लिखली वात नी सामळता, ती कदी मरला मायन कुय बी जीवतु हय्‌न तींद्‌रेन चां जाय्‌न कवसे तेबी चे तेरी नी माने।” ");
INSERT INTO bhi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","एक दाहड़ु ईसु आपसा चेलाक कह्‌यु, “पाप कराड़नेन पारख ते जलम आवती रवसे, बाकुन तीना माणसे पर गरा आय पड़े, तेरे साहरे पाप करनेन पारख आवे! ");
INSERT INTO bhi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","जु कुय ईनु नानला मायन एक काजे बी पटाड़ीन पाप करनेन पारख मां पड़े तेरे वाटे ते ज्‌य वारु छे की तेरा गळा मां घट्‌टीन पुड़ गळा मां बांदीन तीनाक दर्‌या मां नाख देणु चाहे। ");
INSERT INTO bhi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ईनी वातेम तुहुं चेतीन रवु, “कदी तुंद्‌रु भाय काहनु बी गुनु करे, ती तीनाक असु गुनु नी करनु करीन समजाड़ देवु, ने कदी चु गुना सी भगवान भीणी वळे, ती तीनाक माफी आप देवु। ");
INSERT INTO bhi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","कदी चु एक दाहड़ाम सात कावा तुंद्‌रे वीरुद गुनु करे, ने चु सात कावा आवीन तुसेक कवे भाय मे तारे वीरुद मां गुनु करलु छे मेसेक माफ कर दे, ती तुहुं माफ करता रवजु।” ");
INSERT INTO bhi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ने ईसुन नेवताळा मालीक ईसुक कह्‌या, “तु हामरा भुरसा काजे बड़ाव।” ");
INSERT INTO bhi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","मालीक ईसु तीनुक कह्‌यु, “कदी तुंद्‌रु भुरसु रायन दाणा बराबर बी हवतु, तत्‌यार तुहुं ईना सहतुतेन झाड़काक कवता, की ‘उखळीन दर्‌या मां चुपाय जां रव!’ ती चो तुंद्‌री वात मान लेतु। ");
INSERT INTO bhi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“तुंद्‌रे मायन असु कुण छे, तेरु पावर्‌यु हळ जुपतु हय, नीते गाडरा चारतु हय, ने जत्‌यार खेतेम सी पछु आवे, ती चु तीनाक कवे की आव, उतवाळुस खाणो-खाणे बस जां? ");
INSERT INTO bhi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ने तीनाक ज कवणे रहणीदीन ज कवे, ‘मारे वाटे खाणो रांद; ने जत्‌यार लग मे खाय नी लम तत्‌यार लग कमर बांदीन मेसेक खाणो आपतु रव। अळी तेरे पछेन तु बी खाय पीय लेजी।’ ");
INSERT INTO bhi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","जाराक वीच्‌यार करु! मारु पावर्‌यु मारु हुकुम मानीन मारी बेसकी चाकरी कर्‌यु करीन मालीक तीनाक ‘तु बेसकु वारु कर्‌यु’ कवसे काय? नी कवे। ");
INSERT INTO bhi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","तुहुं बी ईना पावर्‌यान तसात छे, अतरे आखा हुकुम पाळीन अळी तुहुंक कवणु चाहे, ‘हामु पावर्‌या अतरात छे; ज काम कर्‌या भाग हतलो, च काम अतरोत हामु करला छे।’” ");
INSERT INTO bhi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ने एक कावा जत्‌यार ईसु यरुसलेम जाणे बाजी रवलु ती चु गलील सामर्‌या जीलान काकड़ पर मायन गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","काहनाक एक गांव मां भरायु ती तीनाक दस कुड़ायला माणसे भेळा हया। ");
INSERT INTO bhi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ने चे कुड़ायला छेटेस उबा रय्‌न जुर सी आयड़ीन कह्‌या, “ए मालीक! ईसु! हामरे पर दया कर।” ");
INSERT INTO bhi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ने ईसु तीनुक देखीन कह्‌यु, “जावु ने आपसा काजे भगवानेन पुजारा धड़े वारु देखाड़ लेवु, ने चे कुड़ायला माणसे पुजारा धड़े जाणे बाजी रवला।” ने जातेत-जाते वाटे वारु हय्‌न चुखा हय गुया। ");
INSERT INTO bhi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","तत्‌यार तींद्‌रेम सी एक अदमी देख्‌यु की मे वारु हय गुयु, ती चु तत्‌यार भगवानेन बेसकु वारु बड़ाय करतु जाय्‌न ईसु भीणी पछु आयु। ");
INSERT INTO bhi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ने चु मांड्‌या वळीन ईसुन पायेम हीट पड़्‌यु ने भगवान काजे बेसकु वारु कवणे बाजी गुयु। चु माणुस यहुदी जातीन नी हतलु, बाकुन सामरी जीलान एक नी-यहुदी माणुस हतलु। बाकुन दीसरा नव जणा ईसु भीणी नी आया। ");
INSERT INTO bhi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ती ईसु तीना माणसेक कह्‌यु, “दस माणसे वारु हवला छे! ती दीसरा नव कां छे? ");
INSERT INTO bhi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ईना दीसरे देस वाळा काजे छुड़ीन दीसरा भगवानेन बड़ाय करने ने भगवान काजे ‘बेसकु वारु’ कवणे दीसरा काहा नी आया?” ");
INSERT INTO bhi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","अळतेन ईसु तीना अदमीक कह्‌यु, “उठ ने तारे घर जाती रव। तु मार पर भुरसु कर्‌यु करीन भगवान तुसेक वारु करलु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","जत्‌यार फरीसी माणसे ईसुक पुछ्‌या की भगवानेन राज की आवसे, तत्‌यार ईसु तीनुक कह्‌यु, “भगवानेन राज उजेंतो नी आवे। ");
INSERT INTO bhi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","अळी माणसे ज नी कवे, ‘देखु, जां छे’ नी ते, ‘पलो वां छे!’ भगवानेन राज ते तुंद्‌रे ईचमां छे।” ");
INSERT INTO bhi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ईसु आपसा चेला काजे कह्‌यु, “असी टेम बी आवसे, जत्‌यार तुहुं माणसेन पुर्‌यान दाहड़ा मायन एक दाहड़ा काजे देखणेन हेर करसु, बाकुन चु दाहड़ु तुहुंक नी देखणे जड़े।” ");
INSERT INTO bhi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","माणसे तुहुंक कवसे, देखु चु जां छे! नी ते, देख, चु वां छे! ती तुहुं तींखुर जाती घुण रवु ने नी तींद्‌रे पछळ जाजु। ");
INSERT INTO bhi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","काहाकी जसी वीजळी सरगेन एक धड़े सी दीसरे धड़े लग बी भबळीन देखाय देय, तसुत माणसेन पुर्‌यु आवसे तीने दाहड़े देखाय देसे। ");
INSERT INTO bhi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","बाकुन हय पेहले तीनाक बेसकु दुख हाकलनु पड़से ने ईनी पीड़ीन माणसे तेरु नीकारु करसे। ");
INSERT INTO bhi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“जसों नुहुन दाहड़ाम हवलो, तसोत माणसेन पुर्‌यान दाहड़ा मां बी हवसे। ");
INSERT INTO bhi_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","तीने दाहड़े लग नुह मटला ढंड्‌या मां नी भरायु, ती लग माणसे खाता-पीता रया, ने ईयाव करता रया। ने उचकाणुन ढंड्‌यो-पाणीम आयु ने चु आखाक डुबाड़ीन मार नाख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","असो लुतेन दाहड़ा मां बी हवलो। माणसे खाता-पीता रया, लेणु-देणु करता रया, झाड़का चुपता रया, ने घर बणावता रया; ");
INSERT INTO bhi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","बाकुन तीने दाहड़े लुत सदोम सहरेम सी नीकळी गुयु, तीनेत दाहड़े भगवान सरगे सी आकठो ने गंधक पाणीन तसों सरगे सी पड़्‌यो, ने आखा मरीन सर गुया। ");
INSERT INTO bhi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","जत्‌यार माणसेन पुर्‌यान आवणु रवसे तीने दाहड़े बी असोत हवसे। ");
INSERT INTO bhi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“तीने दाहड़े जु घर पर हय, चु समान लेणे करीन नेचु उतरीन घरमां घुण भराये ने जु खेतेम हय, चु बी पछु घर नी आवणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","तुहुं लुतेन घरवाळीक हेर करु की तेरे साते काय हयो। ");
INSERT INTO bhi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","जु आपसान जीवन बचाड़ने हींड्‌से चु तीनी जीवाय काजे खुय देसे, ने जु कुय आपसान जीवाय काजे खुय देसे, चु तीनी जीवाय काजे बचाड़ लेसे। ");
INSERT INTO bhi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","मे तुहुं काजे ज कह्‌वो, तीनी राते दुय जणा, एक खाट्‌ली पर सुय रया हसे, एक काजे ईछलीन जाती रवसे, ने दीसराक छुड़ देसे। ");
INSERT INTO bhi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","दुय बायरा एक साते घट्‌टी बसीन दळती हय ती तीनु मायन एक काजे ईछलीन ली जाती रवसे, ने दीसरीक छुड़दीन जाती रवसे।” ");
INSERT INTO bhi_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","दुय माणसे खेते मां हसे, “एक काजे ईछलीन जाती रवसे; ने दीसराक छुड़दीन जाती रवसे।” ");
INSERT INTO bhi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","जी आखी वात सामळीन ईसुन चेला ईसुक पुछ्‌या, “मालीक! ज कां हवसे?” ईसु तीनुक कह्‌यु, “जां धड़ रवे, चांहान मटला घुवड़ा बी भेळा हवसे।” ");
INSERT INTO bhi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","दाहड़ीन अळी-अळीन दुवा करनु चाहजे, ने हिम्‌मत नी छुड़नु चाहजे, ज सीकाड़ने करीन, ईसु हेरा चेलाक एक दाखलु सामळायु। ");
INSERT INTO bhi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“काहनाक सहर मां एक नीयाव करन्‌यु हतलु, चु, नी ते भगवान सी बीहतेलु, ने नी ते कुय माणसेन परवाय करतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","तीनात सहर मां एक रांडायली बायर बी हतली। ची तीना नीयाव करने वाळान चां आवीन असी कह्‌या करतेली, ‘नीयाव करीन मेसेक गुनु लागाड़न्‌या सी बचाड़ ने मेसेक नीयाव आपाड़!’ ");
INSERT INTO bhi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","चु बेसका दाहड़ा लग नीकारु करतु रयु, अळतेन चु आपसा मनेम कह्‌यु, मे नी ते भगवानेक बीहयो ने नी काहनाकेन परवाय करो, ");
INSERT INTO bhi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","बाकुन जी रांडायली बायर अळी-अळीन आवे, ने मेसेक परेसान करे, हेरेसी मे हेरु नीयाव करीस, तत्‌यार हयी, पछी अळी-अळीन नी आवे!” ");
INSERT INTO bhi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","मालीक ईसु अळी असु कह्‌यु, “सामळ्‌या की जु नी-धरमी नीयाव करन्‌यु काय कह्‌यु? ");
INSERT INTO bhi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","तेरेमां भगवान आपसा नेवाड़ला माणसे धड़े नीयाव करने मां वार लागाड़से काय? जे रात दाहड़ु आयड़ी-आयड़ीन तेरे धड़े दुवा कर्‌या करे? ");
INSERT INTO bhi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","मे तुहुंक कह्‌वो; चु उतवाळुस तींद्‌रे वाटे नीयाव करसे। तेबी जत्‌यार माणसेन पुर्‌यु आवसे, ती चु धरती पर माणसे मां भुरसु कर रवलु देखसे काय?” ");
INSERT INTO bhi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ने ईसु तीनुक बी कह्‌यु, जे माणसे आपसा पर भुरसु करतेला की हामु बेसका धरमी छे, ने हय हामरेन तसा कुय धरमी माणसे नी हय। करीन चे दीसराक काय नी समजतेला। तीनु माणसेक ईसु जु दाखलु सामळायु। ");
INSERT INTO bhi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","दुय माणसे वीन्‌ती करने करीन यरुसलेम मंदीर मां गुया। तींद्‌रे मायन एक जणु फरीसी माणुस हतलु, ने दीसरु फाळु उकाळन्‌यु हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","जु फरीसी माणुस एक धड़े उबु हय्‌न आपसा मन मां असी दुवा करने बाजी गुयु, ए भगवान, मे तुसेक बेसकु वारु कह्‌वो, काहाकी मे दीसरान तसु दीसरा धड़े हापकीन खाण्‌यु, ने लुच्‌चु ने दीसरान बायर साते छीनाळो करन्‌यु नी हय। दीसरा माणसे असा छे; बाकुन मे नी हय। ने ईना फाळु लेणे वाळान तसु बी नी हय। ");
INSERT INTO bhi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","मे हाप्‌ता मां दुय कावा उपास करो, ने ज काय बी मे कमायो, तेरु दसवु वाटु तुसेक आपु। ");
INSERT INTO bhi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","बाकुन फाळु लेणे वाळु छेटेत उबु हय रयु, ने सरगे भीणी देख्‌यु लग नी, बाकुन चु दुख मां आपसी छाती ठुकी-ठुकीन कह्‌यु, “ए भगवान, मे पापी छे। तु मार पर दया कर।” ");
INSERT INTO bhi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ईसु असु कय्‌न दाखलु सार देदु, “मे तुहुंक जो कह्‌वो, की भगवान फरीसी माणसेन दुवा सामळी लेदु, ने तेरे पर गीण-दया करीन धरमी बणायु। ने चु हीनी रीते आपसान घर पछु गुयु जु कुय खुद काजे मटु समजे, भगवान तीनाक नानु कर देसे। बाकुन जु कुय खुद काजे नानु समजे तीनाक मटु कर देसे।” ");
INSERT INTO bhi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","एक दाहड़ु माणसे नानला पुर्‌या पर ईसुन हात मेकाड़ने करीन ईसुन्‌चां लाया। चेला ज आखो देखीन माणसेक झीचकार्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","बाकुन ईसु पुर्‌या काजे आपसे धड़े बुलायु ने चेला काजे कह्‌यु, “ईनु नानला पुर्‌या काजे मारेन्‌चां आवणे देवु, हीनुक मां रुकु; काहाकी भगवानेन राज हीनु पुर्‌यान तसलु छे। ");
INSERT INTO bhi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","मे तुहुंक छाचलीन कव की जु कुय ईनु नानला-पुर्‌यान तसा भगवानेन राज नी हुकारे, चु भगवानेन राज मां कदी नी भराय सके।” ");
INSERT INTO bhi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ने यहुदी माणसेन एक मुख्‌यु ईसु काजे ज पुछ्‌यु, “ए वारला मास्‌तर! अमर जीवन हात करने करीन मेसेक काय करनु पड़से?” ");
INSERT INTO bhi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ईसु तीना मुख्‌या काजे कह्‌यु, “तु मेसेक वारलु काहा कवे?” कुय वारलु नी हय। बाकुन भगवान अतरुत वारलु छे। ");
INSERT INTO bhi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","तु कायदान हुकुम काजे ते जाणतु हसे, की छीनाळु नी करनु, खुन नी करनु, चुरी नी करनु, झुटी गवाय नी देणु, आपणा माय-बासेन ईज्‌जत करनु। ");
INSERT INTO bhi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","चु यहुदी मुख्‌यु जपाप आप्‌यु, “ईनु आखा नेमेन पाळण ते मे बी पुर्‌या बुदीम सीत करतु आय रयु।” ");
INSERT INTO bhi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","जो सामळीन ईसु तीनाक कह्‌यु की, “हय तारेम एक वातेन कसर छे। आपणो जो काय छे च आखो वेचीन गरीब माणसे काजे वाट दे, ने तुसेक सरगे मां धन जड़से। ने तु आवीन मारे पुठ्‌ये चाल पड़।” ");
INSERT INTO bhi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","चु मुख्‌यु ज सामळीन बेसकु नराज हय गुयु, काहाकी चु बेसकु लकपती हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ईसु ज देखीन मुख्‌या काजे कह्‌यु, लकपती माणसे काजे भगवानेन राज मां भरायणु बेसको काठो छे। ");
INSERT INTO bhi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","सुईन नाचका मायन उटड़ाक नीकाळनु सरल छे, बाकुन लकपती माणसेक भगवानेन राज मां भरायणु बेसको काठो छे। ");
INSERT INTO bhi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","बाकुन अतरा मां सामळने वाळा दीसरा माणसे कह्‌या, “असी वात छे, ती कुणीन छुटकारु हवसे?” ");
INSERT INTO bhi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ती ईसु कह्‌यु, “हय माणसे सी नी हय सके च भगवान सी हय सके।” ");
INSERT INTO bhi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ती पतरस ईसु काजे कह्‌यु, “देख, हामु हामरा आखा घर बार काजे बी छुड़ीन तार पछळ चालने बाजी गुयला छे।” ");
INSERT INTO bhi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ईसु तीनुक कह्‌यु, “मे तुहुंक छाचलीन कव की असु कुय बी नी हय, चु भगवानेन राज वाटे घर-बार ने आपसी घरवाळी, भाय-बहणस्‌या, आयस-बास ने पुर्‌या काजे छुड़ देदु हय।” ");
INSERT INTO bhi_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ने तीनाक जां ईनी टेम मां काय नी जड़यो हय; तीनाक जां बी बेसको जड़से ने सरगे मां बी तीनाक अमर जीवाय जड़से। ");
INSERT INTO bhi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","एक दाहड़ु ईसु बाहरा काजे दीसरा सी छेटेस ली गुयु ने तीनुक कह्‌यु, “सामळु, आपणु यरुसलेम जाणे बाजी रया। यरुसलेम एक असी जागा छे। आखा मारा बारामां, हय माणसेन पुर्‌यान बारामां भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळा माणसेन साहरे लिखली आखी वात पुरी हवसे। ");
INSERT INTO bhi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","मे यहुदी जातीन माणुस बणीन आयु, बाकुन मे तीनु माणसेन हातेम आपाय जायस, जे यहुदी नी हय। चे मारी हासी उड़ावसे, मेसेक वेला पाड़ीन मारी नाव-बद्‌दी करसे, ने तेरे पर थुप्‌से। ");
INSERT INTO bhi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ने चे तीनुक सपाटा दीन ठुकसे, ने तीनुक घायल करीन मार नाख्‌से। बाकुन चु तीसरे दाहड़े पछु जीवतु हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","बाकुन ईसुन चेला ईनी वात काजे काय बी नी समज्‌या। ईनु बुलेन मतलब तींद्‌रे वाटे ढाकायलो रयो। तीनुक नी समज मां आयो की ईसु तीनुक काय कवणे बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","जत्‌यार ईसु यरीहो सहर धड़े आवणे बाजी रवलु, ती एक आंधळु सयड़क धड़े बसीन चां मायन आवणे-जाणे वाळा धड़े भीक मांगणे बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","माणसेन टुळा काजे जातला ने पायेन चाल सामळीन चु आंधळु माणसेक पुछणे बाजी गुयु, च आखो काय हवणे बाजी रयो। ");
INSERT INTO bhi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","माणसे तीना आंदळा काजे बताड़ देदा की, “ईसु नासरी जां मायन जाणे बाजी रयु।” ");
INSERT INTO bhi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","तत्‌यार आंधळु जु कवतु जाय्‌न जुर सी आयड़्‌यु, “ए ईसु! दावुदेन अवल्‌यात! मारे पर दया कर।” ");
INSERT INTO bhi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","चे तीना आंदळा अगळ-अगळ जाणे बाजी रवला, चे तीना आंदळा काजे हुगु रय जां करीन झीचकारतेला, बाकुन चु आंधळु अळी बी जुर सी असु आयड़तेलु, “ए दावुदेन अवल्‌यात मारे पर दया कर।” ");
INSERT INTO bhi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","तत्‌यार ईसु उबु रय्‌न माणसेक हुकुम आप्‌यु की हीनाक मारे धड़े ली आवु ने जत्‌यार चु धड़े आयु ती ईसु तीनाक पुछ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“तुसेक काय चाहजे? की मे तारे वाटे करो?” चु आंधळु कह्‌यु, “ए मालीक मे अळी देखणे हींडो।” ");
INSERT INTO bhi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ईसु तीनाक कह्‌यु, “ती तु देखणे लाग, ने जां, तारु भुरसु वारु कर देदलु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","तत्‌यारुत चु देखणे लाग गुय। ने चु भगवानेन गुण गावतु जाय्‌न ईसु पछळ चाल देदु। ने ज देखीन आखा माणसे भगवानेन गुण गाया। ");
INSERT INTO bhi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","एक दाहड़ु ईसु यरीहो सहर मायन जाणे बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","देखु चां जक्‌कय नावेन एक लकपती माणुस तीना सहर मां रवतेलु। चु फाळु उकाळन्‌यान मुख्‌यु हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","चु सामळ्‌यु की ईसु चां मायन जाणे बाजी रयु। ईसु कुण छे, चो मालुम करने करीन, जक्‌कय ईसुक देखणे हींडतेलु। बाकुन जक्‌कय नानलु हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","तत्‌यार चु गड़दी मां अघु दवड़ीन गुयु ने ईसुक देखणे करीन एक गुलरेन झाड़का पर चहड़ी गुयु। काहाकी ईसु तीनीत वाटे सी जाणे वाळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","जत्‌यार ईसु तीना झाड़का तळे आयु, ती चु उपर देख्‌यु, ने तीना जक्‌कय काजे कह्‌यु, “ए जक्‌कय मामार उतरी आव! काहाकी आज मेसेक तारे घर रवणु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","तत्‌यार चु जक्‌कय मामार उतर्‌यु ने खुस हय्‌न ईसुन आव-भाव कर्‌यु, ने हेरे घर ली गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ज देखीन आखा यहुदी-माणसे ईसुन वात करीन एक दीसराक कुड़-कुड़ करीन कवणे बाजी गुया, “ईसु ते एक पापीन घर मां मेजवान्‌यु बणीन आय रयु।” ");
INSERT INTO bhi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","बाकुन जक्‌कय उबु हय्‌न ईसुक कह्‌यु, “मालीक मे मारी आखी चीजेन आदु वाटु ईना गांवेन गरीब काजे आप दीस। कदी मे कुय सी धुकु दीन तेरे धड़े धन लेदु हय, ती मे तीनाक तेरो च्‌यार गुणा पछु वाळ दीस।” ");
INSERT INTO bhi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","तत्‌यार ईसु तीनाक कह्‌यु, “आज ईना घर मां छुटकारु आवलु छे, काहाकी जु बी अब्‌राहमेन एक अवल्‌यात मायन छे। ");
INSERT INTO bhi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","काहाकी माणसेन पुर्‌यु खुवायलाक हेरने, ने तीनुक बचावणे करीन आवलु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","जत्‌यार माणसे जी वात सामळने बाजी रवला, ती ईसु एक अळी दाखलु सामळायु; काहाकी ईसु यरुसलेमेन गांव धड़े आय रवलु, ने माणसे ज देखीन समजी रवला की भगवानेन राज हय देखाय देणेवाळो छे। ");
INSERT INTO bhi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","तेरेमां ईसु कह्‌यु, एक लकपती माणुस राजु बणीन पछु आवणे करीन बेसके लांबे वाळा देसेम जाणेन तीयारी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ने चु लकपती माणुस आपसा दस गुलाम पावर्‌या काजे बुलायु ने तीनुक एक-एक जणाक कळदार रुप्‌या आपीन कह्‌यु, मेसेक पछु आवणे लग तुहुं वेपार करीन लेणु देणु करता रवु। ");
INSERT INTO bhi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","बाकुन तेरा गांव मां रवण्‌या तीनाक भुंडात समजाड़तेला, ने चे तेरे पछळ एक काहवाळ्‌यान साहरे तीना काजे कय मकल्‌या की हीयु हामरे पर राज नी करनु चाहे। ");
INSERT INTO bhi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","तत्‌यार लकपती माणुस लांबे वाळा देसेम सी राजु बणीन पछु आयु ने चु बुलावणे मकल्‌यु ने चु गुलाम पावर्‌या काजे धन आप्‌लु ने ज जाणने हींडतेलु, की एक-एक जणु लेणु-देणु करीन कतरु कमायु ने वेपार कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","पेहलु पावर्‌यु आवीन कह्‌यु, मालीक! तु मेसेक दस कळदार रुप्‌या आपलु, तीनु दस रुप्‌यान मे अळी दस कळदार रुप्‌या कमायलु छे। ");
INSERT INTO bhi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","मालीक तीनाक कह्‌यु, ए वारलु पावर्‌यु तु बेसकु वारु कर्‌यु! तु नानली सी नानली वातेम बी ईमानदार नीकळ्‌यु, हय तुसेक दस सहर पर हक आपो। ");
INSERT INTO bhi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","दीसरु पावर्‌यु आवीन कह्‌यु, मालीक! तारा पांच कळदार रुप्‌यान साहरे मे पांच कळदार रुप्‌या अळी कमायलु छे। ");
INSERT INTO bhi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ने मालीक तीनाक बी कह्‌यु, तुसेक बी पांच सहर पर हक आपो। ");
INSERT INTO bhi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","हय तीसरु पावर्‌यु आवीन कह्‌यु, मालीक! देख, जु छे तारु कळदार रुप्‌यु, तीनाक मे एक पुथल्‌याम बांदीन मेक देदलु। ");
INSERT INTO bhi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","काहाकी मे तुसेक देखीन बीहतेलु, काहाकी तु बेसकु आकरु छे; तु जां नी मेले तीनाक ईछी ली जाय, ने जां तु नी एर्‌यु, तीनाक तु काट लेय। ");
INSERT INTO bhi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","चु मालीक तीनाक कह्‌यु, ए वेरी पावर्‌या! मे तुसेक तारात मुंहडा सी तारु नीयाव करीस। तु जाणतेलु की मे आकरु छे। ने जां नी मेलो चो ईछ ली जाम, ने जां नी एरु चो काट लम। ");
INSERT INTO bhi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ती तु मारो धन सवकारेन्‌चां काहा नी मेल्‌यु? ने तत्‌यार मे पछु आवीन तीनु पयस्‌या काजे ईयाज समेत सवकार धड़े सी ली लेतु ");
INSERT INTO bhi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ने मालीक साते उबा हय रवला आखा माणसेक कह्‌यु, ईना पावर्‌या धड़े सी चु कळदार रुप्‌यु, हापकी लेवु, ने जेरे धड़े दस कळदार रुप्‌या छे, तीनात काजे जु कळदार रुप्‌यु बी आप देवु। ");
INSERT INTO bhi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","चे उबा हय रवला आखा माणसे मालीक काजे कह्‌या, मालीक! हेरे धड़े ते दस कळदार रुप्‌या छे। ");
INSERT INTO bhi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","मालीक जपाप आप्‌यु, तेरे धड़े छे, तीना काजे अळी बी आपसे; बाकुन तेरे धड़े काय नी हय, तेरे धड़े सी, च बी मांग लेसे, ज तेरे धड़े छे। ");
INSERT INTO bhi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","बाकुन तीनु मारा वेरी काजे, तीनुक ज्‌य नी चाहतेला की मे तींद्‌रे पर राज करो तीनुक जां मारे अगळ मार नाखु। ");
INSERT INTO bhi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","जी वात कयदीन ईसु यरुसलेमेन गांव भीणी तेरा चेला अगळ-अगळ जाणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ने ईसु चालतु-चालतु बेतफगे ने बेतन्‌या गांव धड़े वाळा जेतुन नावेन बयड़ा पर पुग्‌यु। तत्‌यार ईसु आपसा दुय चेलाक धड़े बुलायु ने तीनुक ज कय मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“अगळ पला गांव मां जावु। ने जसा तुहुं गांव मां भरायसु, ती तुहुंक एक गदड़ान पीलो बांद रवलो देखसु। तेरे पर कुय बी माणुस कदी नी बठ्‌या। तीनाक छुड़ीन जां ली आवु। ");
INSERT INTO bhi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","कदी तुहुंक कुय पुछे की ईनाक काहा छुड़ रया? ती तीनाक कवजु” मालीक काजे ज गदड़ान पीलो चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","चे दुय चेला तसात कर्‌या जसु तीनुक कवला। जसु ईसु कय देदलु, तसात तीनुक एक गदड़ान पीलो बांद रवलो जड़्‌यो। ");
INSERT INTO bhi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","जत्‌यार चे तीनाक छुड़ने बाजी रवला, ती हेरा मालीक तीनुक देख्‌यु ने पुछ्‌यु “तुहुं हामरा पीला काजे काहा छुड़ रया?” ");
INSERT INTO bhi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","चे कह्‌या “मालीक काजे ज गदड़ो चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","तत्‌यार चे पीलाक ईसु धड़े लाया ने चे पीलान पर पुथल्‌या पांगराय देदा ने तीना पीला पर ईसुक बठाड़ देदा। ");
INSERT INTO bhi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ईसु पीलाक चालाड़ीन सहर भीणी ली गुया, ने माणसे आपसा पुथल्‌या ने चादरा तेरे अगळ वाट पर आथरीन तेरो आव-भाव कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ईसु जेतुन झाड़कान बयड़ान कड़खे यरुसलेम धड़े पुग्‌यु, ती ईसुक मान्‌ने वाळा बेसका माणसे, ईसु आयु करीन खुस हय गुया, ने वारु काम काजे देखीन भगवान काजे बेसकु वारु कह्‌वीन खुस हय्‌न तेरी बड़ाय करने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“बरकतवाळु छे चु राजु, जु भगवान मालीकेन नावे आवे। सरगे मां सांती छावाय रयो आखाम उचा रहण्‌या भगवानेन बड़ाय हय रय।” ");
INSERT INTO bhi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ज सामळीन टुळा मां सी थुड़ाक फरीसी माणसे ईसु काजे कह्‌या, “ए मास्‌तर! तु तारा चेलाक झीचकारीन हुगु राख।” ");
INSERT INTO bhi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","बाकुन ईसु तीनु फरीसी माणसे काजे कह्‌यु, “मे तुहुंक कहुं कदी जे हुगा रय जासे ती, जे दगड़ा आपसात आयड़से।” ");
INSERT INTO bhi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","जत्‌यार ईसु यरुसलेम सहर धड़े आयु, ने चु सहरेक देखीन रड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ने असु कह्‌यु, ए यरुसलेम सहर मां रहण्‌या माणसे कदी तुहुं बी हीने दाहड़े आपसी सुक-सांतीन वाट जाण लेता, ती भलो हवतो, बाकुन हय लग ची सातायली छे, ने तुहुंक नी देखायी। ");
INSERT INTO bhi_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","काहाकी तारे पर चे दाहड़ा आवसे जत्‌यार तारा वेरी तारे चारेमेर आवीन तुसेक घेरी लेसे ने चारेमेर सी तुसेक दड़पसे। ");
INSERT INTO bhi_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ने ईनु भीतड़ान ईचमां तुसेक ने तारा पुर्‌याक धुळा मां मीलाड़ देसे ने गांवेन भीतड़ा उदरी जासे, ने दगड़ा पर दगड़ु बी नी रवणे देसे, काहाकी तुहुं भगवान भीणी सी मकेल्‌ला मसी काजे नी उळख्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ईसु मंदीरेन आंगणा मां भरायन लेणु-देणु करन्‌या वेपारीक बाहर नीकाळने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ने तीनुक कह्‌यु, “खरला सास्‌तुर मां ज लिखलो छे, मारो घर दुवान घर कह्‌वायसे, बाकुन तुहुं ईना घरेक, डाकुन घर बणाय देदा।” ");
INSERT INTO bhi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","चु ईसु दाहड़ीन मंदीर मां माणसे काजे वात सामळावणे बाजी रवलु। ने ईसु काजे भगवानेन डाहला पुजारा ने यहुदी-सास्‌तुर सीकाड़न्‌या ने मालदार माणसे वीरुद करने बाजी गुया ने तीनाक मार नाखणेन मुखु हेर रवला। ");
INSERT INTO bhi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","बाकुन तीनुक काय बी नी बण्‌यु, ने तीनुक समज नी आयु की ज कसों करजे, काहाकी आखा माणसे बेसका तेरी वात सामळने चाहतेला। ");
INSERT INTO bhi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","एक दाहड़ु ईसु मंदीर मां माणसे काजे वात सीकाड़तु जाय्‌न खुस-खबर सामळावणे बाजी रवलु, भगवानेन डाहला पुजारा ने यहुदी-सास्‌तुर सीकाड़न्‌या डाहला-डाहला भेळा ईसु धड़े आवीन उबा हय रवला। ");
INSERT INTO bhi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ने ईसु काजे कवणे बाजी गुया, “हामुक बताड़ की तु काहना हक सी ज आखो करने बाजी रयु? ने तुसेक जु हक कुण आप्‌यो?” ");
INSERT INTO bhi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ईसु तीनुक जपाप आप्‌यु, “मे तुहुंक एक सवाल पुछो, तेरु जपाप मेसेक आपु।” ");
INSERT INTO bhi_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","बपतीस्‌मा आपण्‌या युहन्‌ना काजे बपतीस्‌मान रीत आपणेन हक, सरग वाळु भगवान आपलु की माणसे आपला? ");
INSERT INTO bhi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","जी वात सामळीन चे ज कवता जाय्‌न आपसात वीच्‌यार कर्‌या, हामु काय कवजे? भगवान आपलु कवसुन, ती कवसे, तुहुं बपतीस्‌मा आपण्‌या युहन्‌नान वात काहा नी मान्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ने कदी माणुस आपलु करीन कवसु, ती ज माणसेन टुळु आपणुक दगड़ाय्‌न मार नाखसे, काहाकी आखा बपतीस्‌मा आपण्‌या युहन्‌ना काजे भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळु माने। ");
INSERT INTO bhi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","अतराम चे जपाप आप्‌या, “काय जाणु हामुक मालुम नी हय, की ज हक युहन्‌ना काजे कुण आप्‌यो।” ");
INSERT INTO bhi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ईसु तीनुक कह्‌यु, “मे बी नी देखाड़तु की मे ज आखो कुणीन हक सी करने बाजी रयु।” ");
INSERT INTO bhi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ती चु माणसे काजे जु, दाखलु सामळावणे बाजी गुयु, एक कावा एक किरसाण अंगुरेन वाड़ी लागाड़्‌यु। ने ची वाड़ी दीसरा किरसाण काजे साजा मां आपीन, बेसका दाहड़ा लग दीसरा देसेम जात रयु। ");
INSERT INTO bhi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","जत्‌यार अंगुर काजे भेळा करनेन टेम आय, ती चु आपसा एक पावर्‌याक मेरेन वाटु लेणे करीन मकल्‌यु। बाकुन साजल्‌या किरसाण तीना पावर्‌याक ठुकीन ठारलुत पछु मकली देदा। ");
INSERT INTO bhi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ने अळी चु दीसरा पावर्‌याक मकल्‌यु। बाकुन साजल्‌या किरसाण तीनाक बी ठुक्‌या, ने नाव-बद्‌दी करीन ठारलुत मकली देदु। ");
INSERT INTO bhi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","बाकुन अळी चु तीसरा पावर्‌याक मकल्‌यु बाकुन साजेल्‌या तीनाक बी ठुकीन, अंगुरेन वाड़ी मां सी घायल करीन नीकाळ देदा। ");
INSERT INTO bhi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ती चु अंगुरेन वाड़ीन मालीक आपसा मन मां कह्‌यु, “हय मे काय करो? मे मारा लाटेक्‌ला पुर्‌याक मकलीस।” कांखुर मायन चे तेरी ईज्‌जत करीन तेरु आव-भाव करसे ");
INSERT INTO bhi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","बाकुन साजेल्‌या किरसाण तीनाक आवतेलु देखीन आपसा-आपसात मन मां कह्‌या, “जु ते अंगुरेन वाड़ीन मालीकेन पुर्‌यु छे, हीनाक आपणु मार नाखजे, ती जी आखी जागा आपणी हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ने चे साजेल्‌या किरसाण्‌या तीनाक अंगुरेन वाड़ी मां सी बाहर नीकाळ देदा। ने ठुकी-ठुकीन मार नाख्‌या। अळी देखु वाड़ीन मालीक तीनु साजेल्‌या किरसाण्‌यान काय करसे? ");
INSERT INTO bhi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","चु आयन तीनु, साजेल्‌या किरसाण्‌याक मार नाख्‌से ने अंगुरेन वाड़ी मां दीसरा साजेल्‌या किरसाण्‌क आप देसे। चे ज सामळीन ईसुक कह्‌या, भगवान असु नी करे, ती बेसको वारु हय जाय। ");
INSERT INTO bhi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","बाकुन ईसु तींद्‌रे भीणी देखीन कह्‌यु, ती धरम सास्‌तुर मां असो लिखलो छे? घर बांदण्‌या मीस्‌तर्‌या तीना दगड़ा काजे रीकामो समजीन बाहर उराटी देदा चु दगड़ुत खुणान दगड़ु बण गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","जु कुय बी ईना दगड़ा पर पड़से, चु छेदर्‌या-छेदर्‌या हय जासे। ने कदी चु दगड़ु कुय पर पड़से ती तीनाक घेद्‌या-घेद्‌या कर देसे। ");
INSERT INTO bhi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","यहुदी-सास्‌तुर सीकाड़न्‌या ने भगवानेन डाहला पुजारा ईसुक तत्‌यारुत धरने हींडतेला, बाकुन चे माणसे काजे देखीन बीहतेला। चे वारु समजी गुयला, की ईसु जु दाखलु आपणेत बारामां कय र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ने चे ईसु काजे फसाड़नेन नींगा नाख रवला, ने ईसुन चुकसी लेणे करीन माणसेक मकल्‌या। तीनु काजे धरमी हवणे ढंगड़ा कराड़ीन ईसु काजे तेरी वातेम चुकाड़ने करीन मकल्‌या। ने ईसु चुक जाय ती रोमी नीयाव करन्‌यान हातेम ने हक मां सुपणे करीन मकल्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","चे आवीन ईसु काजे पुछ्‌या, “ए मास्‌तर हामुक मालुम छे की, तु जो कवे चो छाचलीत कवे ने वारु सीकाड़े बी। ने हामु जाणजे बी की तु मुंहडा देखीन वात नी करे; बाकुन माणुस काजे भगवानेन छाचलीन मरजीन वात सीकाड़े। ");
INSERT INTO bhi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","हामुक जपाप आप, मुसान कायदान अनसारे रोमी राजान राजा केसर्‌या काजे फाळु आपणे हामरे वाटे वारु हय की नी हय?” ");
INSERT INTO bhi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ईसु तींद्‌री कदर जाणीन तीनुक कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“मेसेक चांदीन एक रुप्‌यु बताड़ु जां कुणीन सीकु ने कुणीन नाव छापलो छे?” ती चे कह्‌या केसर राजान। ");
INSERT INTO bhi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ईसु तीनुक कह्‌यु, “ती जो राजान राजा केसर्‌यान छे, चो राजान राजा केसर्‌या आपु, ने जो भगवानेन छे चो भगवानेक आपु।” ");
INSERT INTO bhi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","चे तेरु जपाप सामळीन चकराय्‌न हुगा रय गुया, ने माणसे अगळ ईसु जे बी बुल कह्‌यु, तीनु बुलेम ईसुन काय बी असी वात नी नीकळ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","बाकुन थुड़ाक सदुकी ईसु भीणी आया। तींद्‌रु असु वीच्‌यार‌ छे की, मरलाम सी पछु जीव उठणु हय नी। चे ईसु अगळ असु सवाल पुछ्‌या, ");
INSERT INTO bhi_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ए मास्‌तर! मुसु हामरे वाटे जो हुकुम लिखलो छे, कदी कुय भायस आपसी घरवाळी हय ने अवल्‌यात पाखुर मर जाय, ती तेरु भायस आपसा भायसेन रांडायलीक बणाय लेणु चाहजे ने आपसा भायस वाटे अवल्‌यात पयदा करनु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","सात भायस हतला, पेहलु भायस ईयाव कर्‌यु ने अवल्‌यात पाखुर मर गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","अळी दीसरु भायस तीनी रांडायली बायरी काजे बणायु। ");
INSERT INTO bhi_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ने तीसरु भायस बी तीनी रांडायली साते ईयाव कर्‌यु, ने चु बी मर गुयु असा करीन एक-एक करीन सात भायस रांडायली काजे बणाया ने अवल्‌यात पाखुर मर गुया। ");
INSERT INTO bhi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ने आकरी मां ची बायर बी मर गुय। ");
INSERT INTO bhi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ती अळी चे पछा जीवता हवसे, ती ची बायर कुणीन घरवाळी कवायसे? काहाकी ची सातु जणान घरवाळी बन्‌ली।” ");
INSERT INTO bhi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","तत्‌यार ईसु तीनुक कह्‌यु, ईनी कळी मां माणसेन मांगणी ईयाव हवतु रवसे। ");
INSERT INTO bhi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","बाकुन जे माणसे जीवता हय्‌न नवली कळीन हकदार्‌या बणसे, तीनु माणसे मां मांगणी ईयाव नी हवे। ");
INSERT INTO bhi_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","चे जी उठीन कदी नी मरे काहाकी चे सरग वाळा काहवाळ्‌यान तसा अमर रवसे। ने पछा जीवता हय्‌न जी उठणेन अवल्‌यात बणीन नवली जीवाय्‌न हकदार्‌या बी हय्‌न भगवानेन अवल्‌यात बी बण जासे। ");
INSERT INTO bhi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","बाकुन मर्‌या-सर्‌या माणसेक पछा जीवता हवणुत छे। मुसु बी जी उठणेन वात काजे धपतेला झाड़का मां उजेंती कर्‌यु। असो मालीक काजे अब्‌राहमेन भगवान, इसाकेन भगवान, याकुपेन भगवान कह्‌वाये। ");
INSERT INTO bhi_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","भगवान मरला माणसेन भगवान नी हय, बाकुन जीवतेला माणसेन भगवान छे काहाकी तेरे अगळ आखा जीवतेला छे। ");
INSERT INTO bhi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","जी वात सामळीन तींद्‌रे मायन थुड़ाक यहुदी-सास्‌तुर सीकाड़न्‌या तीनाक कह्‌या, “ए मास्‌तर! तु बेसका वारु कह्‌यु!” ");
INSERT INTO bhi_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","अळी तीनु काजे ईसु धड़े अळी काहनी बी वात पुछणेन हिम्‌मत नी हय। ");
INSERT INTO bhi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ईसु तीनु काजे पुछ्‌यु, “मसी काजे, दावुदेन अवल्‌यात काहा कवे?” ");
INSERT INTO bhi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","काहाकी दावुद राजा ते भजनेन किताप मां आपसा जीव सी कवे, मालीक भगवान मारा मालीक भगवान काजे कह्‌यु: “तु मारे जेवड़े आंगे बस। ");
INSERT INTO bhi_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","जत्‌यार लग मे तारा वेरीक तारा पाय मेलनेन पयड़ी नी बणाय दम।” ");
INSERT INTO bhi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","दावुद राजा आपसी जीवाय मां तीनाक मालीक कह्‌यु, “ती चु तेरु पुर्‌यु कसु कवायसे?” ");
INSERT INTO bhi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","चां बस रवला आखा माणसे ईसुन वात सामळने बाजी रवला, तत्‌यार ईसु आपसा चेला भीणी देखीन तीनु काजे कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“यहुदी-सास्‌तुर सीकाड़न्‌या सी चेतीन रवु। काहाकी तीनुक गळा सी पायेम लग लांबला पुथल्‌या पेहरनु वारु लागे, ने हाटे मां दीसरा माणसेन मुंहडा वारु की? पुछे ती तीनुक वारु लागे। ने भगवानेन भक्‌तीन घर मां पेहली कुड़ची पर बसणु, ने पंगत मां पेहली जागा हेरनु, तीनुक बेसको वारु लागे। ");
INSERT INTO bhi_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","चे रांडायला बायरान घर मां भरायन तीनुक धुकु दीन ठगी लेय, ने तींद्‌रा घर बारेक उजाड़ देय, ने दीसरा माणसेक देखाड़ने करीन लांबी-लांबी बेसकी वार लग दुवा करे। हीनुक भगवानेन घर सी नीयावेन डंड जादात जड़से।” ");
INSERT INTO bhi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ईसु मंदीर मां हतलु, ती उचु देखीन लकपती माणसे काजे दान-पेटी मां आपणा-आपणा दान नाखतेला देख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","तीनी टेमे मंदीर मां ईसु एक गरीब रांडायली बायरीक, दुय तांबान रुप्‌या धरम करतेली देख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ने तत्‌यार ईसु कह्‌यु, “मे तुहुंक छाचलीन कव की जी गरीब रांडायली बायर हीनु आखा माणसे सी आखाम अदु दान आपली छे। ");
INSERT INTO bhi_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","काहाकी दीसरा, माणसे आपसा बेसका कमायला धनेम सी ईतरोक आपला छे, बाकुन जी गरीब हय्‌न बी जीवणे वाटे तेरे धड़े जो कमायलो हतलो, च आखो आप देदी।” ");
INSERT INTO bhi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","जत्‌यार ईसु काजे थुड़ाक चेला मंदीरेन बारामां असी वात कवणे बाजी गुया, “जु मंदीर कतरु वारु छे, वारलु दगड़ा सी ने छेल भात्‌या चीजे सी बेस सींगारलु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","जी वात सामळीन ईसु तीनु काजे कह्‌यु, “असा दाहड़ा बी आवसे ईना मंदीरेन आखा तत्‌रा जो तुहुं हय देखी र्‌या च आखो उदरीन सर जासे ने दगड़ा पर दगड़ु बी जमलु नी रहणे देय।” ");
INSERT INTO bhi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","चे ईसु काजे पुछ्‌या, “ए मास्‌तर! ज आखो कत्‌यार हवसे ने जत्‌यार ज आखो पुरो हवसे तीनी टेमे काहनी सहलाणी देखाव पड़से?” ");
INSERT INTO bhi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ईसु तीनु काजे कह्‌यु, चेतीन रवु, तुहुंक कुय मनवीन ठगी नी लेय, काहाकी बेसका माणसे मार नावेन आवसे ने कवसे, चु मसी मेत छे ने ची टेम बी आय गुयली छे। तुहुं तींद्‌रे पर भुरसु करीन तींद्‌री वात मानीन तींद्‌रे पछळ-पछळ घुण जावु। ");
INSERT INTO bhi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","जत्‌यार तुहुं लड़ाय झगड़ान ने खुन-खराबान वात सामळसु, ती तुहुं घुण घाबरायु काहाकी असो ते हवसे ने हवसे। बाकुन तीने टेमे तत्‌यारुत कळ नी सरे। ");
INSERT INTO bhi_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ती ईसु तीनुक अळी कह्‌यु, एक जातीन माणसे दीसरी जातीन माणसे साते लड़ाय-झगड़ु करसे, ने एक राजेन माणसे दीसरा राजेन माणसे साते लड़ाय झगड़ु करसे। ");
INSERT INTO bhi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ने बेसकी जागाम बेसकी धरती धदड़ीन फाट जासे, जां चां काळ पड़से ने माणसेन रुग लाग जासे ने सरगे मां बी आज लग देख्‌या नी असली बीहाड़नेन सहलाणी सरगे मां बी देखाव पड़से। ");
INSERT INTO bhi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“बाकुन ज आखो हवणेन पेहले बेसका माणसे मारा नावेन करता तुहुं काजे धरीन तुहुंक बेसका वेला पाड़से, ने यहुदी पंचुन हातेम आप देसे राजा ने रोमी नीयाव करन्‌या अगळ घीसीन लावसे ने चे तुहुंक जेलेम कुंड देसे।” ");
INSERT INTO bhi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","बाकुन ची टेम तुंद्‌रे वाटे मारा बारामां मां गवा देणेन वारलु मुखु बण जासे। ");
INSERT INTO bhi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","तेरेसी आपणा मन मां ठाणी लेवु की हामु पेहले सी बचणे करीन काय-काय कवसुन करीन फीकुर मां करजु। ");
INSERT INTO bhi_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","काहाकी मे तुहुंक असु बुल ने अक्‌कल आपीस, की तुंद्‌री वीरुद करन्‌याक वातेम तुंद्‌रे साते लड़ाय नी पड़े ने तुंद्‌री वातेक काटी नी सके। ");
INSERT INTO bhi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","तुंद्‌रा माय-बास ने भाय ने धड़े वाळा ने तुंद्‌रा दुस्‌तीदार्‌या तुहुंक धराय देसे। ने तुंद्‌रे मायन बेसका जणाक माराय बी नाखसे। ");
INSERT INTO bhi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ने तुहुं मार पर भुरसु कर र्‌या करीन मार नावेन आखा माणसे तुंद्‌रे साते बेसका रीस करसे। ");
INSERT INTO bhi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","बाकुन तेबी तुंद्‌री मुणकीन एक बी कान्‌या लग नुकसाण नी हवे। ");
INSERT INTO bhi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","तुहुं ईनी आखी वात मां गम खासु ती तुहुं तुंद्‌रा जीव काजे बचाड़ लेसु। ");
INSERT INTO bhi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","तत्‌यार तुहुं यरुसलेम गांव काजे चारेमेर सीपायड़ा सी घेरायलो देखसु, ती तुहुं समजी जाजु की हय गांव उजड़नेन टेम धड़ेस आय गुयलो छे। ");
INSERT INTO bhi_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","तत्‌यार जे माणसे यहुदीया जीला मां हय चे बयड़ा मां ढास जाजु, ने जे यरुसलेम सहर मां हय चे माणसे बाहर नी नीकळनु चाहजे ने गांव मां हय चे पछा सहर भीणी घुण जावु; ");
INSERT INTO bhi_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","काहाकी तीनु दाहड़ाम भगवान नीयाव करसे ने डंड आपणेन दाहड़ा हसे, ज काय भगवानेन सास्‌तुर मां लिखला बुल छे चे पुरा हवसे। ");
INSERT INTO bhi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","असली टेम मां जे भारीस ने पुर्‌या काजे दुत पावनी बायरीन कतरु मटु दुख छे! काहाकी जागे-जाग मां मटा दुखेन ने हीड़ा-पीड़ान दाहड़ा आवसे। ");
INSERT INTO bhi_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","तीनु दाहड़ाम माणसे तलवारेन धारे सी काटायसे। तीनुक धरी-धरीन ने बांदीन आखा देसेम वाटी ली जासे; ने यरुसलेम सहर काजे नी-यहुदी माणसे तत्‌यार लग रंदळसे जत्‌यार लग तीनु नी-यहुदी माणसेन टेम पुरी नी हवे। ");
INSERT INTO bhi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“दाहड़े, ने चांद, ने तारा मां, सहलाणी देखाव पड़से, ने धरतीन आखा देस-देसेन माणसेन जीवाय पर गरा ने हीड़ा-पीड़ा आवसे। ने चे दर्‌यान सुसवारु ने झलक देखीन घाबराय जासे। ");
INSERT INTO bhi_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ने माणसे बीहीन ने कळ पर आवणेवाळी आखी आफतेन वाट देखी-देखीन जीव मां जीव नी रवे, काहाकी सरगेन आखी ताकत हाल जासे। ");
INSERT INTO bhi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ने तत्‌यार आखा माणसे-माणसेन पुर्‌या काजे ताकत भेळु ने सेक-सींगार भेळ आदळा पर बसीन आवतेलु देखसे। ");
INSERT INTO bhi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","जत्‌यार जी आखी वात हवणे बाजी जाय, ती तुहुं उठीन उबा हय जावु, ने उचा भाळीन देख्‌जु, काहाकी तुंद्‌रु छुटकारु धड़ेस रवसे।” ");
INSERT INTO bhi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ईसु तीनुक एक दाखलु सामळायु, “अंजीरेन झाड़काक ने आखा दीसरा झाड़काक बी देखु।” ");
INSERT INTO bhi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","जत्‌यार तीनु झाड़कान डीरा फुटणे बाजी जाय, ने नवला पान्‌टा नीकळने बाजी जाय, ती तुहुं छाचलीन समजी जावु की हय उंडाळु आवणे बाजी र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ईनी रीती सी जत्‌यार तुहुं ईनी वातेक हवतेली देख्‌सु, ती तुहुं जाण जाजु की भगवानेन राज धड़ेत आय गुयलो छे। ");
INSERT INTO bhi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","मे तुहुंक छाचलीन कह्‌वो, की जी कवली वात जत्‌यार लग आखी पुरी नी हय जाय, तत्‌यार लग ईनी पीड़ीन माणसे कदी नी मरे। ");
INSERT INTO bhi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","सरग ने धरती टळ जासे, बाकुन जे मारा कवला बुल छे चे कदी नी टळे। ");
INSERT INTO bhi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","तेरेसी चेतीन रवु, की कांखुर मायन असु नी हवे, की नाचणे कुदणेन मन मां, ने नस्‌या मां ने ईनी कळीन जीवाय्‌न फीकुर मां तुहुं नीसरा हय जावु ने चे गरान दाहड़ा तुंद्‌रे पर उचकाणुन आय पड़े। ");
INSERT INTO bhi_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","काहाकी चे गरान दाहड़ा आखी धरती पर रवणेवाळा आखा माणसे पर ईनी फांदेन तसा आय जासे। ");
INSERT INTO bhi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","तेरेसी जागता रवु ने आखी टेम मां दुवा करता रवु, काहाकी तुहुं ईनी आवणे वाळी आखी गरा सी बची सकु ने भुरसा भेळा माणसेन पुर्‌या अगळ उबा रय सकु असा बण जावु। ");
INSERT INTO bhi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ईसु दीसु-दीसु दाहड़ीन मंदीर मां वात सीकाड़तेलु ने राते-राते बाहर जेतुन नावेन बयड़ा पर र्‌या करतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ने माणसे संदारे ईसुन वात सामळने करीन मंदीर मां भेळा हय जातला। ");
INSERT INTO bhi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","नी खमीरी रुटा बणावणेन तीहवार जु पासका नावेन तीहवार बी कवायतेलु, धड़ेस आय रवलो। ");
INSERT INTO bhi_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ने तीने टेमे ईसु काजे मारनेन वीच्‌यार करने करीन, भगवानेन डाहला पुजारा ने यहुदी-सास्‌तुर सीकाड़न्‌यान भेळा हया, बाकुन चे चां आवला माणसेक देखीन बीहतेला। ");
INSERT INTO bhi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","तीने टेमे यहुदा मां भुतड़ु भराय गुयु, जु ईस्‌करीयोत बी कवायतेलु, ने जु बारे चेला मायन एक हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","चु ईसुक धराड़ने करीन भगवानेन डाहला पुजारा ने पेहरु देण्‌या सीपायड़ान डाहला सीपायड़ा काजे भेळु हय्‌न तींद्‌रे धड़े असु वात कर्‌यु की चु काहनी रीते सी, ईसु काजे तुंद्‌रा हातेम धराड़ दीस। ");
INSERT INTO bhi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ने तीनाक भेळा हय्‌न बेसका खुस हय गुया ने चे तीना यहुदा इस्‌करीयोती काजे ईनी वातेन बदलाम पयस्‌या आपणेन वायदु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","यहुदा राजी हय गुयु ने चु हुगुत माणसेन नजर सी छेटे हय्‌न ईसु काजे धराड़ने करीन मुखु हेरतु रयु। ");
INSERT INTO bhi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","थुड़ाक दाहड़ा मां अखमीरी पाखुर रुटा बणावणेन तीहवार आयु, तीनाक पासकु तीहवार बी कवे। ईना तीहवारेन तीयारी करनेन टेम आवी। तीना तीहवारेन दाहड़े गाडरान एक पीलो मारनुत पड़तेलो। ");
INSERT INTO bhi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","अतरा मां ईसु हेरा चेला पतरस ने युहन्‌ना काजे धड़े बुलायु ने ज कय मकल्‌यु, “जावु ने आपणे वाटे पासका तीहवारेन खास खाणो तीयार करु।” ");
INSERT INTO bhi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","चे ईसुक पुछ्‌या, “तु काहा चाहे की हामु ईना खाणा काजे तीयार करजे?” ");
INSERT INTO bhi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ने ईसु चेलाक जपाप आप्‌यु, “देखु यरुसलेम सहर मां तुहुं भरायसु, ती तुहुंक एक अदमी ठाहरा मां पाणी भरीन लावतेलु भेळु हवसे, ने तुहुं तेरे पछळ-पछळ जाजु ने चु तीना घर मां भरायसे तीनात घर मां तुहुं बी भराय जाजु। ");
INSERT INTO bhi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ने तुहुं तीना घरेन मालीक काजे कवजु, मास्‌तर हामु काजे तुसेक ज कवणे करीन मकल्‌यु की, चो मेजवान्‌यान कमरु कां छे, चां मे मारा चेला भेळु पासका तीहवारेन खाणो खाम? ");
INSERT INTO bhi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ने तुहुं काजे तीना घरेन मालीक माळा पर एक सींगारलु मट्‌लु कमरु देखाड़ देसे तुहुं चांहान पासका तीहवारेन खाणु तीयारी करजु।” ");
INSERT INTO bhi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","पतरस ने युहन्‌‌‌नु गांव मां गुया ने तसात देख्‌या, जसु ईसु कवलु, ने चे फसह तीहवारेन खाणो तीयारी करने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","जत्‌यार सांतो हयो ती ईसु ने तेरा नेवताळान घर मां गुया, ने रुटा खाणे बठ्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ने जत्‌यार चे आखा पासका तीहवारेन रुटा खाणे बाजी रवला ती ईसु आपसा चेलाक कह्‌यु, “मे दुख झेलनेन पेहले ज खाणो तुंद्‌रे साते खाणेन हेर कर रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","काहाकी मे तुहुंक कह्‌वो की, जत्‌यार लग भगवानेन राज पासका तीहवारेन खाणो खाणेन रीती पुरो नी हवे, तत्‌यार लग मे पासका तीहवारेन खाणो अळी नी खाम।” ");
INSERT INTO bhi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ने अळी ईसु कटवरा काजे हातेम लेदु, ने भगवान काजे बेसकु वारु कह्‌यु, ने आपसा चेला काजे चो हाते वाळो पीयालो आपतु जाय्‌न कह्‌यु, “ईना पीयाला काजे लेवु, ने वाटी-वाटीन पी लेवु। ");
INSERT INTO bhi_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","काहाकी मे तुहुंक कह्‌वो की, जत्‌यार लग भगवानेन राज ईनी धरती पर नी आवे, तत्‌यार लग हय मे जु अंगुरेन रस कदी नी पीयो।” ");
INSERT INTO bhi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","अळी ईसु हातेम रुटा लेदु, ने रुटा वाटे भगवान बेसकु वारु कहीन रुटु भांजीन आपसा चेलाक आपतु जाय्‌न कह्‌यु, “जु रुटु मारो डील छे। जो तुंद्‌रे वाटे आप र्‌यु। मेसेक हेर करने करीन असात रुटा वाटे भगवान काजे ‘बेसकु वारु छे’ कह्‌वीन रुटु भांजीन वाटी-वाटीन खाया करजु।” ");
INSERT INTO bhi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","तीनी रीती सी रुटु खायलीन पछे अळी ईसु पीयालो हातेम धर्‌यु ने कह्‌यु, “ज पीयालो मारा लुही मां बणावला नवला वायदान सहलाणी छे, जो तुंद्‌रे वाटे उहवाड़ने वाळो छे।” ");
INSERT INTO bhi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","बाकुन जु मेसेक धुकु दीन धराड़से, चु मार साते पंगत मां बसीन खाणे बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","काहाकी माणसेन पुर्‌या पर ते, जसों लिखलो छे तसों तेरे साते हवणे वाळो छे; बाकुन तीना माणुस पर गरा आय पड़े, जु धुकु दीन मेसेक धराड़से। ");
INSERT INTO bhi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","चेला एक दीसराक आंबा-सांबा पुछणे बाजी गुया, की हामरे मां असु कुण छे, जु तुसेक धराड़नेन काम करने वाळु छे। ");
INSERT INTO bhi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","चेला आंबा-सांबा असा पुछीन जखड़ी पड़े की, हामरे मां आखाम मटु कुणीक समजणु चाहजे? ");
INSERT INTO bhi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ईसु तीनुक कह्‌यु, “नी-यहुदी राजा तींद्‌रे पर हक जमाड़ीन राज करे; ने जे तींद्‌रे पर हक जमाड़ीन चे ज कवणे हींडे की हामु मदत करन्‌या छे कह्‌वे। ");
INSERT INTO bhi_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","बाकुन तुहुं असा घुण बणु काहाकी जु कुय तुंद्‌रेम मटु हवणे हींडे, चु आखाम नानु बणनु चाहजे। ने जु कुय हकदार्‌यु हय, चु आखान पावर्‌यु बणनु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","मटु कुण छे, पंगत मां बसीन खाणु खाण्‌यु मटु छे की खाणो वाटण्‌यु वारती मटु छे? जु पंगतेम बसीन खाणो खाण्‌यु मटु नी हय काय? बाकुन मे तुंद्‌रेम खाणो वाटण्‌या वारतीन तसु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","बाकुन तुहुं मारी आखी पारख ने आफत मां मारे पुठ्‌ये रया। ");
INSERT INTO bhi_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","जसु मारु बास मेसेक राजु बणायन राज-पाट आपलु, तसात मे बी तुहुंक राजा बणायन राज-पाट आपो। ");
INSERT INTO bhi_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","तेरेसी की तुहुं मारा राज-पाट मां मारी पंगत मां मारे पुठ्‌ये बसीन खादा-पीदा ने राजगाद्‌या पर बसीन ईस्‌रायेलेन बारे कुळीन माणसेन नीयाव करे। ");
INSERT INTO bhi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ईसु पतरस काजे कह्‌यु, “ए सीमोन! ए सीमोन! सामळ भुतड़ु तुहुं आखा काजे गहुंन तसु चुळने करीन भगवान धड़े मांग लेदु। ");
INSERT INTO bhi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","बाकुन मे तारे वाटे भगवान सी लीलघाय कह्‌यु की। काहाकी तारु भुरसु भगवान पर सी छेटे नी हवणु चाहजे। ने जत्‌यार तु पछु भुरसु करसी ती आपसा भायसेक बी भुरसा मां लावीन काठा करजी।” ");
INSERT INTO bhi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","सीमोन पतरस ईसु काजे कह्‌यु, “मालीक मे तारे पुठ्‌ये जेल मां जाणे, ने मरने लग तीयार छे।” ");
INSERT INTO bhi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","बाकुन ईसु पतरस काजे कह्‌यु, “ए पतरस मे तुसेक कह्‌वो की तु आज, कुकड़ु वासणेन पेहले, तु तीन कावा ईसुक नी जाणो करीन कवसी।” ");
INSERT INTO bhi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ने ईसु आपसा चेलाक कह्‌यु, “जत्‌यार मे तुहुंक बटवु, झुळु ने खासड़ा पाखुर मकेल्‌लु, ती तुहुंक काहनी बी वातेन कसर हवली काय?” “चे कह्‌या काहनी बी वातेन कसर नी हवी।” ");
INSERT INTO bhi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","अळी ईसु तीनु चेलाक कह्‌यु, “बाकुन हय तेरे धड़े बटवु हय, चु बटवु धरी लेवु, ने तेरे धड़े झुळु हय, चु झुळु ली लेवु, ने तेरे धड़े तलवार नी हय, चु आपसा पुथल्‌या वेचीन तलवार मुल ली लेवु। ");
INSERT INTO bhi_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","काहाकी मे तुहुंक कह्‌वो की चुखला सास्‌तुर मां लिखलो छे की तेरी गिन्‌ती गुनेगार्‌याम हवसे। चो आखो मारे बारामां पुरो हवणेत वाळो छे काहाकी मारे बारामां जो काय लिखलो छे चो आखो पुरो हवणे वाळो छे।” ");
INSERT INTO bhi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","तत्‌यार चेला कह्‌या, “ए मालीक! देख जां हामरे धड़े दुय तलवार छे!” “बाकुन ईसु तीनुक कह्‌यु, बस अतरात रेट छे।” ");
INSERT INTO bhi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","तत्‌यार ईसु बाहर नीकळीन जेतुन नावेन बयड़ा भीणी चाल देदु, चु पेहले बी असुत चां जाया करतेलु। ने तेरा चेला बी तेरे पुठ्‌ये-पुठ्‌ये चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ईसु चां बयड़े जाय्‌न तीनु चेला काजे कह्‌यु, “पारख मां नी पड़नु चाहजे करीन दुवा कर्‌या करु।” ");
INSERT INTO bhi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ने ईसु दगड़ु उराटीन नाखे अतरे लांबे हींद्‌रे सी छेटुस जात रयु, ने मांडा टेकीन कवतु जाय्‌न भगवान बास सी दुवा कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ए बास! कदी तु चाहे, ती जु दुखेन पीयालो मारे धड़े सी टाळ दे, बाकुन तेबी मारी मरजी नी, बाकुन तारीत मरजी पुरी हवणे दे।” ");
INSERT INTO bhi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","तत्‌यारुत तीनाक एक सरग वाळु काहवाळ्‌यु देखाय देदु, जु मालीक ईसु काजे ताकत आप्‌या करतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ने ईसु आपसी जीवाय मां बेसकु कलेप्‌तु जाय्‌न अळी बी पुरो मन लागाड़ीन दुवा करने बाजी गुयु, ने तेरु पसीनो, मटला-मटला लुहीन टीपकान तसु धरती पर पड़ने बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","तत्‌यार चु दुवा करीन उठीन आयु, ने आपसा चेला भीणी गुयु, ने तीनुक सुवतेला देख्‌यु। काहाकी चे बेसका दुखी हतला। ");
INSERT INTO bhi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","चु तीनुक कह्‌यु, “तुहुं काहा सुवणे बाजी र्‌या? उठु ने तुहुं पारख मां नी पड़ु करीन दुवा करता रवु।” ");
INSERT INTO bhi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ईसु चेला काजे ज कवणे बाजी रवलु, ने बेसका माणसेन टुळु ईसुन्‌चां आय गुयु; ने ईसुन बारे चेला मायन एक यहुदा इस्‌करीयोती नावेन एक चेलु बी तीना टुळा अगळ-अगळ आय रवलु, चु बी ईसु धड़े आयन ईसुन गुळु देदु। ");
INSERT INTO bhi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ईसु तीनाक कह्‌यु, “ए यहुदा तु गुळु दीन माणसेन पुर्‌या काजे धुकु दीन धराड़ने बाजी रयु काय?” ");
INSERT INTO bhi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ईसुन दीसरा चेला देख्‌या की धुकु हवणे वाळु छे करीन ईसुक कह्‌या, “ए मालीक हामु ईनुक तलवार सी झाटकाय देजे काय?” ");
INSERT INTO bhi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ने तीनु चेला मायन एक चेलु, भगवानेन डाहला पुजारान मुख्‌यान पावर्‌या पर तलवारेन झाटकु देदु, ने तेरो जेवड़्‌यु कान्‌टु काट देदु। ");
INSERT INTO bhi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","बाकुन ईसु कह्‌यु, “हय रहणी देवु, बेसको हय गुयो, ने ईसु तेरु कांटु!” छीमीन तीनाक वारु कर देदु। ");
INSERT INTO bhi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ने तत्‌यार ईसु भगवानेन डाहला पुजाराक; ने तेरे मंदीरेन राखवाळी करन्‌या सीपायड़ान डाहला सीपायड़ाक ने डाहा-डाहा काजे, जे तेरे भीणी जुर करीन आवला तीनुक कह्‌यु, “तुहुं मेसेक धाड़ु पाड़न्‌यु समजीन तलवार ने डेंगा लीन मेसेक धरने आय रया काय? ");
INSERT INTO bhi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","मे दाहड़ीत मंदीर मां तुंद्‌रे पुठ्‌ये हतलु, तेबी तुहुं मेसेक नी धर्‌या। बाकुन हय जी टेम तुंद्‌री छे? काहाकी हय आंदारलान हक छे।” ");
INSERT INTO bhi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","अळी चे ईसु काजे धरीन बांद लेदा ने तीनाक चां सी भगवानेन डाहला पुजारान मुख्‌यान घर ली जाणे करीन चाल पड़्‌या। पतरस ईतरुक छेटुस तेरे पछळ-पछळ जातलु। ");
INSERT INTO bhi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","डाहला पुजारान घर जाय्‌न ने माणसेन आंगणा मां आकठो धपाड़ीन आकठान चारेमेर बस गुया। पतरस बी तींद्‌रे पुठ्‌ये बस गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ने एक पावरनी पुरे पतरस काजे आकठान वीजाळे बस रवलु देखी, ने तेरे पर नींगा नाखीन कह्‌वी, “जु माणुस बी ते हेरेत पुठ्‌ये हतलु।” ");
INSERT INTO bhi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","बाकुन पतरस नीकारु करतु जाय्‌न तीनी पुरे काजे कह्‌यु, “ओ बहणीस! मे हीनाक जाणो लग नी।” ");
INSERT INTO bhi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ईतरीक वार मां अळी काहनुक पतरस काजे देखीन कह्‌यु, “तु बी ते हीनु माणसे मायन छे। पतरस तीना माणसे काजे कह्‌यु, नी भाय! मे तीनु माणसे मायन नी हय।” ");
INSERT INTO bhi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","एक घंटुक हय गुयु ने अळी काहनुक दीसरु जुर करीन कह्‌यु, “खरान, जु बी ते तेरेत पुठ्‌ये हतलु। काहाकी जु ते गलील जीला मां रवण्‌यु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","पतरस तीनाक कह्‌यु, “ए भायस मे नी जाणु की तु काय कह्‌णे बाजी रयु!” पतरस कह्‌णे बाजी रवलु, ने तत्‌यारुत कुकड़ु वास देदु। ");
INSERT INTO bhi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","तत्‌यार मालीक ईसु पछु फीरीन पतरस भीणी देख्‌यु ने तत्‌यारुत पतरस काजे ईसुन जी वात हेर आवी, जी वात मालीक ईसु तीनाक कवलु, की “आज कुकड़ु वासणेन पेहल, तु मेसेक तीन कावा मारु नीकारु करीन कवसी की मे ईसुक जाणो लग नी।” ");
INSERT INTO bhi_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ने तत्‌यारुत पतरस बाहर नीकळीन उसकी-उसकीन बेसकु रड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","जे राखवाळी करने वाळा सीपायड़ा ईसुक धरीन लावला, चे तेरी हासी उडाड़ीन, ने तीनाक वेला पाड़ता जाय्‌न ठुकतेला। ");
INSERT INTO bhi_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ने चे सीपायड़ा ईसुन डुळे पाटु बांदीन तीनाक असा पुछता रया, कदी तु भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळु हय, ती हामुक देखाड़, हामरे मायन तुसेक कुण देदो। ");
INSERT INTO bhi_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ने चे बेसकी वात नीकाळीन तेरी नाव-बद्‌दी करीन तेरे वीरुद मां वात कह्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","दीसरे दाहड़े एगात यहुदी पंचुन आखा डाहला ने भगवानेन मंदीरेन पुजारा ने यहुदी नीयम सीकाड़ने वाळा आखा भेळा हय गुया, ने चे ईसु काजे नीयावेन मट्‌ली बसक मां बुलायन काय-काय पुछ्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","कदी तु खरान मसी हय ती हामु काजे कय दे! “ईसु तीनुक कह्‌यु,” कदी मे तुहुंक कह्‌वीस, ती तुहुं भुरसु नी करु। ");
INSERT INTO bhi_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ने कदी मे तुहुंक काय पुछीस ती तुहुंक जपाप नी आपाये। ");
INSERT INTO bhi_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","बाकुन हय सी माणसेन पुर्‌यु आखा ताकत वाळा भगवानेन जेवड़्‌ये आंग्‌ये जाय्‌न बस रवसे। ");
INSERT INTO bhi_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","जी वात सामळीन आखान-आखा बस रवला चे कय पड़्‌या, “ती तु भगवानेन पुर्‌यु छे काय?” ईसु तीनुक जपाप आप्‌यु, “तुहुं कय रया, काहाकी मे भगवानेन पुर्‌यु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ईसुन मुंहडान वात सामळीन चे कह्‌या, “हय हामुक गवा-पुरावा देण्‌या नी चाहजे! काहाकी हामु आपसात हेरे मुंहडा सी आखी वात सामळी लेदला छे!” ");
INSERT INTO bhi_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","तत्‌यार आखी बसकेन माणसे उठीन उबा हय गुया; ने चे ईसु काजे राजा पीलातुस भीणी ली गुया। ");
INSERT INTO bhi_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","चे पीलातुस राजा अगळ ईसुन वात पर गुनु लागाड़ीन कवणे बाजी गुया: “चु हामरा माणसेक सरकारेन वीरुद मां भड़कावतेलु, ने तुहुं रोमी राजाक फाळु मां आपु कवतेलु सामळ्‌ळा छे, ने आपसा काजे मे मसी राजु छे, कवतेलु सामेळला छे।” ");
INSERT INTO bhi_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","पीलातुस ईसुक पुछ्‌यु, “तु यहुदी माणसेन राजा छे काय?” ईसु जपाप आप्‌यु, “हव, जसु तु कय र्‌यु मे तसुत छे।” ");
INSERT INTO bhi_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","तत्‌यार पीलातुस भगवानेन डाहला पुजाराक ने भेळा हवला माणसेक कह्‌यु, “मारी नींगा मां, जु माणुस रोमी सरकारेन कायदान वीरुद मां काय बी गुनु नी कर्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","बाकुन चे जुर दीन अळी-अळीन कह्‌या की, “जु माणुस यहुदा जीला मां आखे दुर ‘सरकारेन वीरुद मां लड़ाय करजु’ करीन माणसेक सीकाड़तु आय र्‌यु। असो करनु ज्‌य गलील जीला मां सुरु कर देदलु। ने हय चु यहुदा जीला मां ईनात काम वाटे आवलु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ज सामळीन पीलातुस पुछ्‌यु, “जु माणुस गलील जीला मां रवण्‌यु छे काय?” ");
INSERT INTO bhi_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","जत्‌यार तीनाक मालुम पड़्‌यो की ईसु गलील वाळु छे, ती पीलातुस ईसुक हेरोदेस भीणी मकली देदु, जु तीनी टेमे मां यरुसलेम मां हतलु, ");
INSERT INTO bhi_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हेरोदेस ईसुक देखीन बेसकु खुस हय गुयु। चु ईसुन बारामां बेसकी वात सामळी रवलु, ने बेसका कावा तीनाक देखणे बी हींडतेलु। चु ईसुन बारामां वारु-कामेन सहलाणी देखणेन हेर करतेलु। ");
INSERT INTO bhi_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","अतराम हेरोदेस ईसु काजे बेसका सवाल पुछतु रयु, बाकुन ईसु तीनाक काय जपाप नी आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","भगवानेन डाहला पुजारा ने यहुदी-सास्‌तुर सीकाड़ने वाळा हतला। ने चे पुरो मन ने जुर लागाड़ीन ईसु पर गुनु लागाड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","तत्‌यार हेरोदेस ने तेरा सीपायड़ा ईसुन हासी उड़ाया ने तेरी नाव-बद्‌दी कर्‌या, ने ईसुक चमकण्‌या ने जामण्‌या पुथल्‌या पेहराया ने पछा पीलातुस धड़े मकली देदा। ");
INSERT INTO bhi_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","तीनी टेमे सी हेरोदेस ने पीलातुस साथी बण गुया। ने हेरे सी पेहेल चे दुय एक दीसरान वेरी हतला। ");
INSERT INTO bhi_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","हय पीलातुसेन चां भगवानेन मंदीरेन डाहला पुजाराक ने हक करन्‌याक ने दीसरा माणसेक बुलायु; ने तीनुक कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","तुहुं ईना माणुस काजे माणसेन वीरुद मां माणसे काजे भड़कावणे वाळु समजीन मारे भीणी लावला छे, ने देखु, हय मे तुंद्‌रे अगळ ईनाक पारखी लेदु, ने मे जाण लेदु की, तुंद्‌रु हेरे पर गुनु लागाड़नु सय नी हय। ");
INSERT INTO bhi_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ने राजा हेरोदेस काजे बी मालुम पड़ गुयो की ईसु गुनाळा नी हय। अतरा मां चु पछु मकली देदु। जु माणुस काय बी गलत काम नी कर्‌यु ने मरनेन डंड आपे असु नी हय। ");
INSERT INTO bhi_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","तेरेमां मे हीनाक मार खावाड़ीन छुड़ाय दीस। ");
INSERT INTO bhi_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","जी वात पीलातुस राजा एरेन करीन कह्‌यु, काहाकी पीलातुस सालो डीट पासका तीहवारेन दाहड़े, यहुदी माणसेक खुस करने करीन एक केदीक जेल मां सी छुड़ देदलु। ");
INSERT INTO bhi_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","पीलातुस राजा ईसुक मरनेन डंड नी आप रयु ज देखीन गड़दी मायन आखा माणसे आयड़ी देदा ने कह्‌या, “ईनाक मार नाखु ने बरअब्‌बा काजे छुड़ देवु।” ");
INSERT INTO bhi_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ईना बरअब्‌बा काजे जेल मां कुंड देदला, काहाकी जु यरुसलेम मां सरकारेन वीरुद मां दीसरा माणसे साते आपसा साती भेळ लड़ाय करलु। चु थुड़ाक माणसेक मारी बी नाखलु। ");
INSERT INTO bhi_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पीलातुस राजा ईसु काजे छुड़ने हींडतेलु, अतरा मां एक कावा अळी तीनी गड़दी मायन माणसे काजे समजाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","बाकुन गड़दी मायन माणसे पछा आयड़ीन कह्‌या, “ईनाक कुरुस पर चड़ावु! ईनाक कुरुस पर चड़ावु!” ");
INSERT INTO bhi_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","पीलातुस तीसरी कावा तीनु गड़दी मायन माणसेक कह्‌यु, “काहा? जु माणुस काय गुनु करलु छे? मेसेक हेरे मां मरनेन डंड आपे असु काय बी गुनु नी देखायतु। मे ईनाक सपाटा देवाड़ीन छुड़ाय दीस।” ");
INSERT INTO bhi_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","बाकुन चे आयड़ी-आयड़ीन ईसु पछळ पड़ गुया की ईसुक कुरुस पर चड़ावु। ने तींद्‌रो आयड़नेन काम पुरो हयो। ");
INSERT INTO bhi_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","अळतेन पीलातुस राजा, बरअब्‌बा काजे छुड़नेन ने ईसुक मरनेन डंड आपणे करीन तीयार हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","पीलातुस राजा तीना माणुस काजे, जु दीसरा माणसे पुठ्‌ये लड़ाय करतेलु, ने माणसेन खुन करतेलु। करीन जेल मां कुंडाड़ देदलु। चु तीनाक छुड़ देदु ने तीनाक कह्‌यु, “तुहुंक जसा करने लागे तसा करु, ज कय्‌न ईसुक गड़दीन ने सीपायड़ान हातेम आप देदु।” ");
INSERT INTO bhi_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","जत्‌यार चे सीपायड़ा ईसुक कुरुस पर मारने करीन गांव सी ठुक्‌ता लाया। तत्‌यार तीनुक वाटे कुरेन देस मां रवण्‌यु सीमोन नावेन एक माणुस भेळु हयु। चु तीने टेमे गांव मां सी सहरेम आवणे बाजी रवलु। चे सीपायड़ा तीनाक जबरान धर पाड़्‌या ने तीनाक कुरुस हाकलाड़ीन ईसु पछळ-पछळ चालाड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","चां माणसेन बेसकु मटु टुळु ईसु पछळ चालने बाजी रवलु। तेरे मां थुड़ाक बायरा बी हतला जे छाती ठुकी-ठुकीन ईसु वाटे कलपी रवली। ");
INSERT INTO bhi_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ईसु तींद्‌रे भीणी देख्‌यु ने तीनुक कह्‌यु, “यरुसलेम मां रवण्‌या पुर्‌या मारे वाटे मां रड़ु। बाकुन आपणे वाटे ने आपणा पुर्‌या-पारी वाटे रड़ु।” ");
INSERT INTO bhi_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","काहाकी चे दाहड़ा आवणे बाजी र्‌या जत्‌यार माणसे कवसे वारु छे चे बायरा, जे आंझ्‌या छे; ने तींद्‌रा पुर्‌या नी हया, ने जे रातेड़ला पुर्‌याक पाळ्‌या पुस्‌या नी। ");
INSERT INTO bhi_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","तीनी टेमे माणसे बयड़ाक कवसे, हामरे पर हीट पड़। ने बयड़ायाक कवसे हामुक ढाक लेवु। ");
INSERT INTO bhi_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","काहाकी जु काय बी गुनु नी कर्‌यु, तेरे साते माणसे असु एहवार कर रया, ती छाचली तींद्‌रे साते आवणे वाळा दाहड़ाम, तेरे सी बी जादा भुंडु एहवार हवसे, जे छाचलीन गुनु करला छे। ");
INSERT INTO bhi_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","चे सीपायड़ा ईसु भेळा दीसरा दुय गुनेगार्‌याक बी कुरुस पर मार नाखणे करीन पठ्‌ये-पठ्‌ये ली गुया। ");
INSERT INTO bhi_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","तीना जागाक मुणकान टुबरो कवे, तीनी जागाम चे आया, चे ईसु काजे चां कुरुस पर चड़ावीन हाते पायेम खीळा ठुक्‌या। चे दुय गुनेगार्‌याक बी कुरुस पर चड़ावीन हाते पायेम खीळा सी ठुक्‌या। एक काजे ईसुन डाखर्‌ये आंग्‌ये ने दीसराक जेवड़्‌ये आंग्‌ये। ");
INSERT INTO bhi_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","तत्‌यार ईसु बास भगवान सी लीलघाय्‌न कह्‌यु, “ए बास ईनुक माफी आप दे! काहाकी जे नी जाणता, की जे काय कर र्‌या।” ने अळतेन चे सीपायड़ा चिट्‌ठी नाखीन ईसुन पुथल्‌या वाट लेदा। ");
INSERT INTO bhi_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","चां बेसका माणसे उबा रय्‌न देखणे बाजी रवला, ती यहुदी मुख्‌या ईसुन हासी उडाड़ता जाय्‌न कह्‌या, “हयु दीसराक बेसकु बचाड़्‌यु। कदी जु छाचलीन भगवानेन साहरे नेवाड़लु मसी हय ती आपसा काजे बचाड़ लेणु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","सीपायड़ा बी तेरी हासी उड़ाया। चे ईसु भीणी आया ने तीनाक अंगुरेन कड़वलु रस आप्‌या, ");
INSERT INTO bhi_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ने कह्‌या कदी तु छाचलीन यहुदीन राजु हय, ती आपसा काजे बचाड़ ले।” ");
INSERT INTO bhi_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ईसुन मुणका सी उपर कुरुस पर गुनान एक लाकड़ान पट्‌टी ठुकीन टांगली हतली, “तेरेमां असो लिखलो हतलो जु ते यहुदी माणसेन राजु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ईसु साते कुरुस पर टांगायला गुनेगार्‌या मायन एक ईसुन नाव-बद्‌दी करतु जाय्‌न पुछ्‌यु “तु भगवानेन नेवाड़लु छुड़ावणे वाळु नी हय काय? हय ती आपसाक ने हामुक बचाड़ ले।” ");
INSERT INTO bhi_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","बाकुन दीसरु गुनेगार्‌यु झीचकारीन कह्‌यु, तुसेक भगवान सी ईतरोक बी बीहाणो नी लागतो काय? तु बी ते हयुत नीयावेन डंड भुकतणे बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","तु ने मे ते डंड आपे असात छे, जो आपणु कर्‌या तेरो फळ आपणुक जड़ रयो; बाकुन जु माणुस काय बी गुनु नी कर्‌यु, “ने गुना पाखुर नीयावेन डंड झेल र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","अळी चु ईसुक कह्‌यु, ए मालीक ईसु! जत्‌यार तु राजु बणीन राज करे, “ती मारी हेर राख्‌जी।” ");
INSERT INTO bhi_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ईसु तीनाक पछु कह्‌यु, “मे तुसेक छाचलीन कवो की, तु आजुत मारे पुठ्‌ये सरगे मां रवसी।” ");
INSERT INTO bhi_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","तीनी टेमे दाहड़ान बारे बज रवली हसे, ने तत्‌यारुत तीन बजे लग आखी ईलाका मां आंदारो खुय हय रह्‌लो। ");
INSERT INTO bhi_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ने दाहड़ान वीजाळो बी जाती रवलो, तत्‌यार भगवानेन मंदीर मां चु पड़दु फाटीन दुय टुकड़ा हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","तत्‌यार ईसु जुर सी आयड़ीन कह्‌यु, “ए बास! हय मे मारु जीव तारा हातेम आप दम।” ज कय्‌न ईसुन जीव नीकळ्‌यु गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","रोमी सरकारेन सीपायड़ान एक डाहलु ज हयो च आखो देखीन भगवानेन बड़ाय करतु जाय्‌न कह्‌यु, “खरान, जु ते एक धरमी हतलु।” ");
INSERT INTO bhi_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","जत्‌यार चां उबा हय रवला माणसे ज हयो च देख्‌या, ती चे फीकुर मां पड़ीन लाजवाय गुया, ने आपसी छाती ठुक्‌ता-ठुक्‌ता पछा सहरेम जाती र्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","गलील जीलाम रवण्‌या ईसुन बेसका दुस्‌तीदार्‌या, तींद्‌रा बायरा बी हतला, ईसु पछळ-पछळ गलील सी आवला, चे बी छेटे उबा रय्‌न ज हयो च आखो देख रवला। ");
INSERT INTO bhi_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ने देखु युसुफ नावेन एक माणुस हतलु। चु एक वारलु माणुस हतलु, ने यहुदी धरमेन कायदाक पाळने मां ईमानदार हतलु, चु यहुदी धरमेन खास पंचुन मेहमर हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ने तेबी चु ईसुक डंड आप्‌या करीन राजी नी हतलु, चु यहुदा जीलान अरीमतीया सहर वाळु हतलु, चु बी तीना दाहड़ान वाट देख रवलु, चु तीनु दाहड़ाम भगवान राजु बणीन राज करसे। ");
INSERT INTO bhi_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","चु राजा पीलातुस धड़े गुयु ने ईसुन लास मांग्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ती अळी चु कुरुस पर सी ईसुन लास उतार्‌यु, ने तीनी लासेक एक चमकण्‌या चादरा सी एळटी देदु, ने एक मसाण मां मेल देदु। चु मसाण वारलु चापर्‌या मां खुदीन बणावलो हतलो। तेरे पेहल तीनी मसाण मां कुय काजे बी नी गाड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","चु तीयारीन दाहड़ु हतलु, ने यहुदीन आरामेन दाहड़ु सुरु हवणे वाळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ईसु पुठ्‌ये गलील सहर मां सी आवला बायरा युसुफ पुठ्‌ये-पुठ्‌ये मसाण भीणी गुया ने देख्‌या। ने चे ज देख्‌या की ईसुन धड़ कसो करीन मसाण मां मेक रया। ");
INSERT INTO bhi_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","अळी चे घर गुया ने लास पर लागाड़ने करीन मसालु ने वारु ईत्‌तर तीयार कर्‌या। बाकुन आरामेन दाहड़े, जसों धरमेन कायदान अनसारे तीनुक आराम करनु हतलो, करीन चे आराम कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","गलील सहर मां सी ईसु पुठ्‌ये आवला बायरा, हाप्‌तान पेहले दाहड़े एगात मसाण पर आया। चे, चु गंदायण्‌यु मसालु ली गुया, चु ईसुन लास पर लागाड़ने करीन बणावला। ");
INSERT INTO bhi_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","चे देख्‌या की बीड़ा वाळा चापर्‌यान दर पर देदलु दगड़ु, धकलीन एक धड़े हय रवलु। ");
INSERT INTO bhi_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ने चे बायरा चापर्‌यान दरेन बारना मायन मसाण पर गुया, बाकुन मालीक ईसुन धड़ चां नी जड़ी। ");
INSERT INTO bhi_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ज देखीन चे बायरा वीच्‌यार मां पड़ गुया। ती उचकाणुन दुय माणसे देखाय देदा, ने तींद्‌रे साते उबा हय गुया। तींद्‌रा पुथल्‌या बरफन तसा बी धपी रवला। ");
INSERT INTO bhi_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","चे बायरा बीही गुया ने आपसो मुणको नेचो करीन भुयमात देख रवला। तत्‌यार चे माणसे तीनु बायरा काजे कह्‌या, “जु जीवतेलु छे, तीना काजे मरला माणसेन मसाण मां काहा हेर रया? ");
INSERT INTO bhi_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","चु जां नी हय, काहाकी चु पछु जीवतु हय गुयु। जत्‌यार चु गलील सहर मां हतलु, ती चु तुहुंक काय कवलु? ची वात हेर करु! ");
INSERT INTO bhi_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","चु कवलु, जु माणुस बणीन आयु, तीनाक पापी माणसे कुरुस पर चड़ावसे। बाकुन चु तीन दाहड़ाम पछु जीवतु हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","तत्‌यार बायरा ईसु कवलु ची वात हेर कर्‌या, ");
INSERT INTO bhi_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ने मसाण पर सी पछा जाती र्‌या। ने ईसुन ग्‌यारे चेलाक ने दीसरा आखा जो देखला ने सामळ्‌या चो आखा काजे कय देदा। ");
INSERT INTO bhi_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","नेवताळा काजे बताड़न्‌या बायरा मगदलनी सहरेन मरीयम, योअन्‌ना, याकुपेन माय मरीयम ने थुड़ाक दीसरा बी हतला। ");
INSERT INTO bhi_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","बाकुन ईसुन चेला वीच्‌यार्‌या की बायरा जी वात कय रया ची असलीत वात हसे। ने चे तींद्‌री वात पर भुरसु नी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","तेबी तींद्‌रे मायन पतरस नावेन एक चेलु मसाण भीणी दवड़ीन गुयु। जत्‌यार चु चां जाती रयु, ती चु ढंगु वळीन मसाण मां माहें भाळ्‌यु, ने चमकण्‌या पुथल्‌या अतरात पड़ रवला देख्‌यु, तेर मां काय नी देख्‌यु बाकुन चु घाबरायलुत पछु आवती रयु, ");
INSERT INTO bhi_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","तीने दाहड़े दुय चेला ईनी आखी वातेन बारामां वात करता जाय्‌न इम्‌मावुस नावेन गांव भीणी जाणे बाजी रवला। चो यरुसलेम सहर सी च्‌यारेक कुस छेटस हतलो। ");
INSERT INTO bhi_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","चे दुय जणा जी कवली तीनी वातेन बारामां आंबा-सांबा वात ने वीच्‌यार करने बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","जत्‌यार चे वात-वीच्‌यार करने बाजी रवला, तीनी टेमे ईसु आपसुत आवीन, तींद्‌रे पुठ्‌ये-पुठ्‌ये चाल पड़्‌यु, ");
INSERT INTO bhi_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","चेला पुठ्‌ये-ईसु हतलु, बाकुन चे तीनाक नी उळख्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ईसु तीनु चेला काजे कह्‌यु, “तुहुं वाटे चालता-चालता काहनी वातेन बारामां वात ने वीच्‌यार कर रया, चे उबा रय गुया। तींद्‌रु नुरपाणी उतरी रवलु।” ");
INSERT INTO bhi_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","तींद्‌रे मायन एक जणु क्‌लयोपास नावेन हतलु, चु जपाप आप्‌यु, यरुसलेम सहर मां आवणे जाणे वाळा मायन तुत असु अनजाण्‌यु छे काय, जो नी जाणे की ईनु दाहड़ाम काय-काय हवलो छे। ");
INSERT INTO bhi_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ईसु तीनुक कह्‌यु, “चां काय हवलो छे, चे कह्‌या जी वात नासरत वाळा ईसुन छे! चु माणुस भगवानेन ने आखा माणसेन नींगाम, काम ने वातेम, भगवान वाटे जुर भर्‌यु माणुस हतलु।” ");
INSERT INTO bhi_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ने भगवानेन डाहला पुजारा ने हामरे पर हक जमाड़न्‌या पुडारी तीनाक धराय देदा, ने मरनेन डंड आपाड़्‌या ने कुरुस पर खीळा ठुकीन रोमी सीपायड़ा धड़े चड़ाय मांग्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","हामु ते बेसकी मटी असी आस कर रवला, की जु ते ईसु, ईस्‌रायल देसेन छुटकारु करने वाळु छे, जी आज सी तीन दाहड़ा पेहलेन वात छे। ");
INSERT INTO bhi_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","हामरे मायन ईतराक बायरा हामुक बेसका बीहाड़ देदा; चे संदारे एगात मसाण पर गुयला। ");
INSERT INTO bhi_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","तीनुक ईसुन धड़ नी जड़ी। चे चां सी पछा आवीन हामुक कह्‌या की हामु काजे सरग वाळा काहवाळ्‌या देखाय देदा, चे जो कह्‌या की “ईसु जीवतेलु छे।” ");
INSERT INTO bhi_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","जी वात सामळीन हामरे मायन थुड़ाक साती मसाण पर गुया, ने जसा बायरा तीनुक कवला, तसात आखो देखी पाड़्‌या, “बाकुन चे ईसु काजे नी देख्‌या।” ");
INSERT INTO bhi_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ती ईसु तीनुक कह्‌यु, ए डेड़-अकल्‌या! तुहुं भगवानेन अघी सी वात बताड़न्‌या माणसेन वात पर, भुरसु करने मां अतरा कम अकल्‌या काहा बण गुया! ");
INSERT INTO bhi_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","मसी ईसु काजे दुख झेलीन, तेरी सेक-सींगार मां पछो भरायणु वारु नी हय काय? ");
INSERT INTO bhi_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ने ईसु मुसान लिखली सास्‌तुर मां सी ने भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळा माणसेन सास्‌तुर मां सी चोवे-चोव दीसरा आखा खरला सास्‌तुरेम सी आपसान बारामां जो काय लिखलो छे, चो आखो तीनुक समजाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","असा करीन चाल्‌ता-चाल्‌ता, तीना गांव मां जाती र्‌या, जां चे जाणे बाजी रवलु। मालीक ईसु काजे देखीन असो लागतेलो, की ईसु अळी अगुस जाणेन वीच्‌यार मां हतलु। ");
INSERT INTO bhi_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","चे चेला ईसु काजे पाये पड़ीन कह्‌या, “तु हामरे पुठ्‌ये रय जां। काहाकी हय सांतो हय गुयो, ने दाहड़ु बी डुबीत गुयु।” ने ईसु तींद्‌रे पुठ्‌ये रहणे करीन घर मां गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","तत्‌यार ईसु तींद्‌रे पुठ्‌ये रुटा खाणे करीन बठ्‌यु, ती चु रुटु हातेम धर्‌यु, ने भगवान काजे बेसकु वारु कय्‌न संयबरकत मांग्‌यु; ने चेलाक भांजी-भांजीन आप देदु। ");
INSERT INTO bhi_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","तीने टेमे चेलान डुळा उघड़ी गुया। ने चे ईसु काजे उळखी लेदा, बाकुन ईसु तींद्‌रा डुळा अगळ सी अंछाप हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ती चेला आंबा-सांबा जो कह्‌या, “जत्‌यार चु वाट्‌ये चालतु जाय्‌न हामरे साते वात करतेलु ने खरला सास्‌तुरेन वात देखाड़तेलु, ती आपणु जीव भळ नी कर्‌यु काय?” ");
INSERT INTO bhi_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","चे चेला तत्‌यारुत चां सी उठीन यरुसलेम सहर भीणी पछा गुया, जाय्‌न चे ग्‌यारे चेला काजे ने तींद्‌रा दीसरा साती काजे भेळा हय रवला देख्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","चे ज कवणे बाजी रवला, “मालीक ईसु छाचलीन जीवतु हय गुयलु छे, ने चु सीमोन पतरस काजे देखाय देदु!” ");
INSERT INTO bhi_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","तत्‌यार चे वाट्‌ये काय-काय हयो चो आखो कय देदा ने ज बी कय देदा की ईसु रुटु भांजीन आप्‌यु, ती हामु तीनाक उळखी लेदा। ");
INSERT INTO bhi_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","मालीक ईसु जीवतु हय गुयलु छे, करीन चेला वात करने बाजी रवला, तत्‌यार ईसु आपसुत तींद्‌रे भीणी आवीन ईचमां उबु हय गुयु। ने तीनुक आखाक कह्‌यु, “तुहुंक सांती जड़े!” ");
INSERT INTO bhi_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","बाकुन चे बेसका बीही गुया, ने समज्‌या की हामु काहनाक खतर्‌या भुतड़ा काजे देख र्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","तत्‌यार ईसु तीनुक अळी कह्‌यु, “तुहुं काहा घाबराय रया?” ने तुहुं मनेन संक्‌या काहा कर रया? ");
INSERT INTO bhi_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","मारा हात ने पाय देखु, ने जाण लेवु की मे छाचलीन हयुत ईसु छे। मेसेक छीमु ने देखु, काहाकी आत्‌मान मास ने हाटका नी रवे। बाकुन तुहुंक डुळा अगळ देखाय र्‌यो। की मारे मां मास ने हाटका छे। ");
INSERT INTO bhi_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","तत्‌यार ईसु जी वात कवतु जाय्‌न तीनुक आपसा हातेन घाव ने पायेन घाव देखाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","चे अतरा खुस हय गुया की चे सुच मां पड़ गुया ने भुरसु नी कर सक्‌या। काहाकी ज आखो तींद्‌री समज मां नी आयो। ईसु चेला काजे कह्‌यु, “जां तुंद्‌रे धड़े खाणेन काहींग छे काय?” ");
INSERT INTO bhi_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ने ईसु काजे भुंजला माछान एक टुकड़ु आप्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ने चु तीना माछान टुकड़ा काजे धर लेदु ने तींद्‌रा डुळा अगळ खाय गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ईसु तीनुक अळी कह्‌यु, “मारी जी वात, ची वात छे, जी मे तुहुंक सुरु सी कवतु आय रयु, की मुसान साहरे लिखली सास्‌तुर वाळी वात ने भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळा माणसेन वात, ने भजन मां लिखली वात पुरी हवणेन हतली, जी मारा बारामां लिखली छे।” ");
INSERT INTO bhi_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","अळी ईसु खरला सास्‌तुर समजाड़ने करीन तींद्‌रा मनेन ढाकणा उगाड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ने तीनुक कह्‌यु, असोत लिखलो छे, की मसी दुख भुगतसे ने तीसरे दाहड़े मर्‌या-सर्‌याम सी पछु जीवतु हय जासे। ");
INSERT INTO bhi_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","जी खुस-खबर पेहले जां यरुसलेम मां माणसेक सामळावसे ने अळी आखा देसेन माणसे काजे सामळावसे। ने पाप भीणी सी मन फेरवीन भगवान भीणी वळनेन परचार तेरेत नावेन हवसे। ");
INSERT INTO bhi_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ने तुहुं आखा ईनी वातेन गवा छे। ");
INSERT INTO bhi_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ने देखु तीना चुखली-आत्‌मान बारामां मारु बास तुहुंक आपणेन वायदु करलु छे। तीना काजे मे तुंद्‌रे उपर सरगे सी उतारीस ने जत्‌यार लग तुहुं सरगे सी ताकत हात नी करु ती लग तुहुं ईनात यरुसलेम सहर मां रवजु। ");
INSERT INTO bhi_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","तत्‌यार ईसु आपसा चेलाक सहर सी बाहर बेतन्‌या सहर धड़े ली गुयु। जत्‌यार चे चां पुग्‌या, ईसु आपसा हात उचा करीन संयबरकत आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","जत्‌यार चु तीनुक संयबरकत आपणे बाजी रवलु, ती चु ईसु तीनुक छुड़ीन सरगे हाकलाय गुयु। ");
INSERT INTO bhi_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ने चेला मांडा टेकीन ईसुक आंध्‌या ने अळी चे खुस हय्‌न यरुसलेम सहर मां पछा जाती र्‌या। ");
INSERT INTO bhi_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","चां चे भगवानेन भक्‌तीन घर मां भेळा हय्‌न आखी टेमे भगवानेन बड़ाय करता र्‌या।");
INSERT INTO bhi_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","कळी घड़ायणे सी पेहलुत बुल हतलो, ने बुल भगवान पुठ्‌ये हतलो, ने बुल भगवानुत हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","च बुल कळी सी पेहेल भगवान साते हतलो। ");
INSERT INTO bhi_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","कळी मां ज आखो काय तेरे सीत बण्‌यो, ने ज काय बण्‌यो तेरेमां सी काय बी चीज तेरे पाखुर नी बण्‌यो। ");
INSERT INTO bhi_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","हेरेम जीव हतलु, ने हयु जीव दुनीया मायन माणसे वाटे वीजाळो हतलो। ");
INSERT INTO bhi_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","वीजाळो आंदारला मां चमक्‌यो ने आंदारलो तीनाक कदी नी उळखी सक्‌यो। ");
INSERT INTO bhi_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","भगवान भीणी सी मकेल्‌लु एक अदमी ईनी कळी मां आयु, तेरो नाव युहन्‌ना हतलो। ");
INSERT INTO bhi_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ने चु युहन्‌‌‌नु तीना वीजाळान बारामां माणसेक गवा देणे आयु, काहाकी आखा माणसे तीनी गवायन साहरे तीना वीजाळा पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","चु युहन्‌‌‌नु, आपसुत च वीजाळो नी हतलु; बाकुन तीना वीजाळान बारामां गवाय देणे आवलु। ");
INSERT INTO bhi_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ज खरलो वीजाळो हतलो, चु कळी मां हय उजेंतु हवणेवाळु हतलु, ने चु आखा माणसे काजे आपसा वीजाळान साहरे भगवानेन छाचाय देखाड़न्‌यु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","कळीन आखा घड़न्‌या, तेरेत साहरे घड़ाया, ने चु कळी मां आयन देखाव पड़्‌यु, तेबी कळीन माणसे तीना काजे नी उळख्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","चु आपसा यहुदी-माणसेन ईचमां आयन रयु, बाकुन तेरात माणसे तीनाक नी आवर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","बाकुन जतरा बी माणसे तीनाक आपसा जीवेम आवरीन, तेरा नाव पर भुरसु करे, चु तीनु आखा काजे भगवानेन अवल्‌यात बणनेन हक आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","चे नी ते खुन सी, ने नी ते डीलेन मरजी सी, नी आयस बासेन मरजी सी, बाकुन भगवानेन मरजी सी पयदा हया। ");
INSERT INTO bhi_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","तेरेमां चु बुल कहंवायतेलु; ने चु माणुस बणीन धरती पर आयु, ने आपणे ईचमां रयु। ने हामु तेरी सेक-सींगार देख्‌या, जसा की भगवान बासेन एकुत लाटेक्‌ला पुर्‌यान गीण-दया ने छाचाय बी हतली। ");
INSERT INTO bhi_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","युहन्‌ना तेरा बारामां असी गवाय देदु, ने आयड़ीन कह्‌यु, “जु हयुत छे, तेरे बारामां मे असु कह्‌लु, एक जणु आवणे वाळु छे, चु मार पछळ आय र्‌यु, चु मार सी मटु छे, काहाकी चु मार सी पेहेल हतलु।” ");
INSERT INTO bhi_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","काहाकी हेरेत उगळता खजाना मां सी हामुक आखो जड़्‌यो, मतलब तीना खजाना मां सी आपणु काजे बेसकी गीण-दया हवली छे। ");
INSERT INTO bhi_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","तेरेमां नेम कायदु ते मुसु देदलु, बाकुन गीण-दया ने छाचाय ईसु मसीन साहरे आपणेन्‌चां पुगली। ");
INSERT INTO bhi_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","भगवान काजे कुय बी माणुस आज लग नी देख्‌या, बाकुन तेरु एखलु पुर्‌यु ईसु चु आपसुत भगवान छे, ने जलम भगवान पुठ्‌ये रवे, हयुत भगवान काजे आपसी जीवान साहरे देखाड़ीन पुरु उजेंतु करलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","एक दाहड़े यरुसलेम सहर सी यहुदी माणसेन डाहला, चे भगवानेन मंदीरेन पुजारा काजे ने पुजारान मदत करन्‌या लेवी कुळीन माणसे काजे, युहन्‌ना भीणी असा पुछणे मकल्‌या की तु कुण छे? ");
INSERT INTO bhi_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","तत्‌यार युहन्‌‌‌नु ज मान लेदु बाकुन मना नी कर्‌यु, “मे मसी नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","तत्‌यार चे तीनाक पुछ्‌या, “की तु कुण छे?” काय तु एलीयु छे? युहन्‌‌‌नु जपाप आप्‌यु। “मे नी हय ती काय?” तु चु भगवानेन अघली वात बताड़न्‌यु माणुस छे। “चु जपाप आप्‌यु,” मे नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","तत्‌यार चे तीनाक कह्‌या, “ती तु कुण छे? जे हामुक मकल्‌या तीनुक हामु काय जपाप आपजे? तु तार बारामां काय कह्‌वे?” ");
INSERT INTO bhi_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","चु युहन्‌‌‌नु कह्‌यु, जसों भगवानेन अघली वात बताड़न्‌यु यसायु कहंलु की: “मे बयड़ा मां आयड़ीन बुल सामळावण्‌यु छे: की तुहुं मालीकेन वाट सुदी करु!” ");
INSERT INTO bhi_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","युहन्‌नान झड़ती करने करीन यरुसलेम सी मकेल्‌ला फरीसी माणसे बी हतला। ");
INSERT INTO bhi_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","चे माणसे युहन्‌ना काजे अळी पुछ्‌या कदी तु मसी बी नी हय, “ने एलीयु बी नी हय, ने भगवानेन अघली वात बताड़न्‌यु माणुस बी नी हय, ती तु बपतीस्‌मा काहा आपे?” ");
INSERT INTO bhi_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","युहन्‌ना तीनुक जपाप आप्‌यु, “मे ते तुहुं काजे पाणी सी बपतीस्‌मा आपो, बाकुन तुंद्‌रे ईचमां एक माणुस छे तीनाक तुहुं नी उळ्‌खु। ");
INSERT INTO bhi_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","अळतेन मारे पछेन आवणे वाळु छे, मे तेरा खासड़ान बंद छुड़ने लायक बी नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","जी वात यरदन नदीन पार बेतन्‌या गांव मां हवली, चां युहन्‌‌‌नु बपतीस्‌मा आपतेलु। ");
INSERT INTO bhi_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","दीसरे दाहड़े युहन्‌ना ईसु काजे तेरे भीणी आवतेलु देखीन कह्‌यु, “देखु जु भगवानेन साहरे मकेल्‌लु गाडरु छे, चु कळीन माणसेन पाप हाकलीन ली जासे। ");
INSERT INTO bhi_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","जु चु छे तेरा बारामां मे कह्‌लु, की एक माणुस मारे पछळ आवणे वाळु छे, जु मारे सी बेसकु मटु छे मार सी अगळ छे, काहाकी चु मार सी पेहलुत हतलु ");
INSERT INTO bhi_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","मेसेक बी जी वात पेहेल मालुम नी हतली, हयुत मसी छे, बाकुन भगवानेन मरजी जी हतली की ईस्‌रायली जातीन माणसे समजणु चाहजे की, मसी कुण छे, हेरेसी भगवान मेसेक पाणीम बपतीस्‌मा आपणेन सेवा आप्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ने युहन्‌‌‌नु जी गवाय आप्‌यु, मे आत्‌मा काजे पेरवान तसों सरगे सी उतरतेला देख्‌यु, ने चु तेरे पर बठ गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","मे ते तीनाक उळखो नी बाकुन जु मेसेक पाणी सी बपतीस्‌मा आपणे वाळु मकेल्‌लु हयुत मेसेक कह्‌यु, “तेरे पर तु आत्‌मा उतरतेला ने बठतेला देख्‌यु, हयुत चुखली-आत्‌मा सी बपतीस्‌मा आपणे वाळु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ने मे देख्‌यु, ने गवाय देदु, “की हयुत भगवानेन नेवाड़लु पुर्‌यु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","दीसरे दाहड़े युहन्‌‌‌नु ने तेरा दुय चेला चां आय रवला। ");
INSERT INTO bhi_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","युहन्‌ना ईसु काजे चां मायन जातलु देख्‌यु ने तेरा चेला काजे कह्‌यु, “देखु हीयुत भगवानेन गाडरु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","तत्‌यार चे दुयु चेला युहन्‌नान जी वात सामळीन ईसुन चेला बणने करीन, ईसु पछळ चाली पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","जत्‌यार ईसु पछु फीरीन तीनुक आवतेला देखीन तीनुक कह्‌यु, “तुहुं काय हेर रया?” चे ईसुक कह्‌या, “ए मास्‌तर तारु रवणेन जागु कां छे।” ");
INSERT INTO bhi_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ईसु तीनुक जपाप आप्‌यु, “आवीन देख लेवु।” तत्‌यार चे जाय्‌न ईसुन रहणेन जागु देख्‌या, ने तीने दाहड़े ईसु पुठ्‌ये रया ने तीनी टेमे सांती वेळाय चार बज रवली। ");
INSERT INTO bhi_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","तीनु दुय जणा मां सी जे युहन्‌नान वात सामळीन चे ईसु पछळ चाली पड़्‌या, एक सीमोन पतरसेन भाय अन्‌दीरीयास हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","अदरीयास ईसुन्‌चां सी पछु गुयु ती, चु सुदु सट पेहल आपसा संगा भाय सीमोनेन्‌चां गुयु, तत्‌यार कह्‌यु, “हामुक छुड़ावन्‌यु मसी जड़ गुयु, तीनाक आपणु खीरीस्‌त कहजे।” ");
INSERT INTO bhi_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","पछेन अन्‌दीरीयास तीना सीमोन काजे ईसुन्‌चां लायु। ईसु सीमोन भीणी भाळीन कह्‌यु, “तु युहन्‌नान पुर्‌यु सीमोन छे, तु केफा कहंवाय्‌सी।” हीना केफा काजे युनानी बुली मां पतरस कह्‌वे। ");
INSERT INTO bhi_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","दीसरे दाहड़े ईसु गलील जीला भीणी जाणेन हींडी रवलु। तीनी टेमे चु फीलीप्‌पुस काजे भेळु हयु ने कह्‌यु, “तु मारु चेलु बणीन मारे पछळ चाल पड़।” ");
INSERT INTO bhi_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ने जु फीलीप्‌पुस बी, अन्‌दीरीयास ने पतरस रवतेलु तीनात बेतसेदा सहर वाळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ने जु फीलीप्‌पुस, नतनएल नावेन आपसा दुस्‌तीदार काजे भेळु हवणे गुयु, ने तीनाक भेळु हय्‌न कह्‌यु तीना मसीन बारामां मुसु नीयम मां लिखलु छे ने भगवानेन अघली वात बताड़ने वाळा बी करला, च हामुक जड़ गुयो, चु नासरत सहरेम रहणे वाळु युसुफ्‌यान पुर्‌यु ईसु छे। ");
INSERT INTO bhi_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नतनएल फीलीप्‌पुस काजे कह्‌यु, “ए नासरत सहर मां सी नीकळी काहनी बी वारलु बरकत उबजी सके काय?” फीलीप्‌पुस नतनएल काजे कह्‌यु, “आवीन देख ले।” ");
INSERT INTO bhi_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ईसु नतनएल काजे हेरे भीणी आवतेलु देखीन कह्‌यु, “ने तेरा बारामां कह्‌यु, देखु जु ईस्‌रायली जातीन खरलु माणुस छे। हेरेमां काय बी खुट नी हय!” ");
INSERT INTO bhi_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नतनएल ईसु काजे कह्‌यु, “तु मेसेक कसु उळखे?” ईसु तीनाक जपाप आप्‌यु, “हेरेसी पेहेल की फीलीप्‌पुस तुसेक बुलायु जत्‌यार तु अंजीर नावेन झाड़का तळे हतलु तत्‌यार मे तुसेक देखलु।” ");
INSERT INTO bhi_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","नतनएल ईसुक कह्‌यु, “ए मास्‌तर” तु भगवानेन पुर्‌यु छे, “तु ईस्‌रायली माणसेन राजु छे!” ");
INSERT INTO bhi_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ईसु नतनएल काजे कह्‌यु, “मे तुसेक वारु कहलु, की तु अंजीर नावेन झाड़का तळे देखलु काय, तु तेरेमां मार पर भुरसु कर रयु? तु हेरेसी बी मटा-मटा काम देखसी!” ");
INSERT INTO bhi_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ईसु तीनाक ने दीसरा चेलाक असु कह्‌यु, “मे तुहुंक छाचलीन कहो की तुहुं सरग काजे उघड़लो, ने भगवानेन सरग वाळा काहवाळ्‌या काजे माणसेन पुर्‌यान्‌चां उतरतेला ने चां सी उपर चहड़तेला देखसु।” ");
INSERT INTO bhi_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","पछेन तीसरे दाहड़े गलील जीलान काना सहर मां ईयाव हतलु। ने ईसुन माय बी चां हतली ");
INSERT INTO bhi_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","चां ईयाव मां ईसु ने तेरा चेला काजे बी नेवता आपीन बुलाय रवला। ");
INSERT INTO bhi_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","जत्‌यार चां अंगुरेन रस सर गुयु, ती ईसुन माय ईसुक कय, “हींद्‌रे धड़े ते अंगुरेन रस सर गुयु।” ");
INSERT INTO bhi_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ईसु हेरी माय काजे कह्‌यु, “तु मेसे असी काहा कय रय? मारे साते तारो काय काम छे? हय मारी टेम नी आय रय।” ");
INSERT INTO bhi_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ईसुन माय पावर्‌या काजे कय, “हीयु तुहुंक जु काय कहं चत करजु।” ");
INSERT INTO bhi_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","चां दगड़ान छव बेसका-मटा गुळा मेल्‌ला हतला, हीनु गुळाम सी पाणी हेड़ीन यहुदी माणसे चुखा हवणे करीन हात-पाय धुवतेला। हीनु गुळाम सोवेक लीटर पाणी समायतेलो। ");
INSERT INTO bhi_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ईसु चां वाळा पावर्‌याक कह्‌यु, “गुळा मां पाणी भर देवु” ने चे पावर्‌या ईसुन वात मानीन उगेळतो पाणी भर देदा। ");
INSERT INTO bhi_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","तत्‌यार ईसु तीनुक कह्‌यु, “हय ईतरोक पाणी नीकाळीन वारत्‌यान धड़े ली जावु।” चे पावर्‌या च पाणी नीकाळीन वारत्‌यान्‌चां ली गुया। ");
INSERT INTO bhi_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","तत्‌यार वारती च पाणी चाख्‌यु अंगुरेन रस बण गुयो ने तीनाक नी मालुम हतलो की अंगुरेन रस कां सी लावला। बाकुन तीनु पावर्‌याक मालुम हतलो की कां सी लावला ती आरत्‌यु दुल्‌लाक बुलायन तीनाक कह्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“कुय बी माणुस पेहली बार वारलु अंगुरेन रस आपे ने तत्‌यार माणसे पीन आफरी जाय तत्‌यार हळकु अंगुरेन रस आपे; बाकुन तु ते वारलु अंगुरेन रस हय लग मेल रवलु।” ");
INSERT INTO bhi_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ईसु गलीलेन काना सहर मां पेहली कावा वारु कामेन सहलाणी देखाड़ीन आपसुत सेक-सींगार देखाड़्‌यु। ने ज देखीन ईसुन चेला ईसु पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","हेरे पछेन ईसु ने हेरी माय ने हेरु भाय ने हेरा चेला कफरनहुम सहर मां गुया ने चां थुड़ाक दाहड़ा रया। ");
INSERT INTO bhi_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहुदी माणसेन फसह तीहवार सातेत आय रवलु। तेरेमां ईसु यरुसलेम सहर मां जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","चां ईसु मंदीर मां देख्‌यु की माणसे बेल गाडरा ने पेरवा वेचतेला देख्‌यु ने चां लेण देण वाळा वेपारी आटे-साटे करन्‌या बठ रवला देख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","तेरेमां ईसु रासेन सपाटु बणायन आखा गाडरा ने बेल काजे मंदीर मां सी नीकाळ देदु ने लेण-देण करने वाळान पयस्‌या खडळी देदु ने ठेला गाडी काजे उन्‌धलाय देदु। ");
INSERT INTO bhi_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","पेरवा वेचण्‌या काजे कह्‌यु, “ज आखो जां सी छेटा ली जावु। मारा बासेन घर काजे वेपारीन घर मां बणावु।” ");
INSERT INTO bhi_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ईसुन वात सामळीन ईसुन चेला काजे खरला-सास्‌तुर मां लिखली वात हेर आय गुय, “तारा घरेन धुन मां मेसेक आकठान तसी धपाड़ देसे।” ");
INSERT INTO bhi_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ईसुन वात सामळीन यहुदी माणसे ईसु काजे कह्‌या, “तु जो काय करने बाजी रयु? कदी भगवान तुसेक जो करनेन हक आपलु हय ती, ईनी वातेन पुरावु देणे करीन, हामुक चकराड़े असी एक वारु-कामेन सहलाणी देखाड़।” ");
INSERT INTO bhi_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ईसु तीनुक जपाप आप्‌यु, “कदी तुहुं भगवानेन हीना मंदीर काजे उदार नाखसु, ती मे हीनाक अळी तीन दाहड़ाम पछु बणाय दीस।” ");
INSERT INTO bhi_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","जो सामळीन यहुदी माणसे ईसु काजे कह्‌या, “भगवान हीना मंदीर काजे बणावणे मां चालीस ने छव साल लागला, ती हय तु हीनाक तीन दाहड़ा मां बणाय देसी काय!” ");
INSERT INTO bhi_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","बाकुन ईसु आपसा डीलेन मंदीरेन बारामां बताड़लु। ");
INSERT INTO bhi_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","जत्‌यार ईसु जत्‌यार मर्‌या-सर्‌याम सी जी उठ्‌यु, ती ईसुन चेला काजे ईसुन साहरे मंदीरेक उदारनेन ने पछु उबु करनेन बारामां कह्‌ली वात हेर आय, ने चेला खरला-सास्‌तुरेन वात पर ने ईसुन कवली वात पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","पासका तीहवारेन दाहड़ा, मां, ईसु यरुसलेम सहर मां हतलु। तत्‌यार बेसका माणसे तेरा करला वारु कामेन सहलाणी देखीन ईसु पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","बाकुन ईसु हीनु काजे तींद्‌रा भुरसा पर नी छुड़्‌यु, काहाकी हयु आखा माणसे काजे जाणतेलु। ");
INSERT INTO bhi_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ने हीनाक जरुवत नी हतली, की माणसेन बारामां काहींग गवा पुरावु देय, काहाकी हयु आपसुत जाणतेलु की माणसेन मन मां काय छे? ");
INSERT INTO bhi_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","यरुसलेम सहर मां नीकुदेमुस नावेन एक माणुस हतलु। चु यहुदी माणसेन एक पंचुन मुख्‌यु हतलु। चु फरीसी माणसे मायन हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","चु राते नीकुदेमुस ईसु धड़े आयु ने ईसु काजे कह्‌यु, “ए मास्‌तर, हामु जाणजे की तु भगवानेन्‌चां सी सीकाड़न्‌यु बणीन आवलु छे, काहाकी जत्‌यार लग भगवान पुठ्‌ये नी हय ती माणुस कुय बी असो वारलु कामेन सहलाणी नी देखाड़ सके, जसु तु वारलु कामेन सहलाणी देखाड़े।” ");
INSERT INTO bhi_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ईसु नीकुदेमुस काजे कह्‌यु, “मे तुसेक छाची-छाची कह्‌वो की जत्‌यार लग कुय अळी पछु पयदा नी हवे तत्‌यार लग चु भगवानेन राज नी देख सके।” ");
INSERT INTO bhi_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","नीकुदेमुस ईसुक पुछ्‌यु, “काहनु बी माणुस डाहलु हय्‌न अळी पछु कसु पयदा हय सके? छाचलीन चु आपसी आयसीन कुख मां अळी पछु जाय्‌न, दीसरी कावा ते, नी पयदा हय सके।” ");
INSERT INTO bhi_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ईसु नीकुदेमुस काजे कह्‌यु, “मे तुसेक छाचली-छाचली कहं, जत्‌यार लग काहनुक बी माणुस भगवानेन जीव-आत्‌मा अनसारे आपसा जीव-आत्‌मा मां पयदा नी हवे, तत्‌यार लग चु भगवानेन राज मां भराय नी सके। ");
INSERT INTO bhi_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","काहाकी जु कुय डील सी पयदा हयु च डील छे; ने जु कुय भगवानेन आत्‌मा सी पयदा हयु चु आत्‌मात छे। ");
INSERT INTO bhi_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","मे तुसेक जी वात कहं तुहुं आखा जीव-आत्‌मा मां पछा पयदा हवण्‌या छे, हीनी वातेक सामळीन तु घाबरायु मां। ");
INSERT INTO bhi_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","आहळी तींखुर जाणे लागे तींखुर जाय ने तु तेरी अवाज काजे सामळे ते खरु, बाकुन ची कां सी आवे, ने कां जाय, च तुसेक मालुम नी पड़े। जु-जु भगवानेन जीव-आत्‌माम सी पयदा हवलु छे, चु हीनी आहळीन तसुत छे।” ");
INSERT INTO bhi_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","जी वात सामळीन नीकुदेमुस ईसु काजे कह्‌यु, “ज असो कसों हय सके।” ");
INSERT INTO bhi_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ईसु, नीकुदेमुस काजे कह्‌यु, “तु ईस्‌रायली माणसेन मास्‌तर छे, तेबी तुसेक जी वात पल्‌ले नी पड़ती काय? ");
INSERT INTO bhi_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","मे तुसेक छाचली-छाचलीन कह्‌वो हामु जे सरग वाळा छे, हामु ज जाणजे चत कहंजे ने हामु तीनाक देखला छे, तेरीत गवाय देजे, ने तुहुं माणसे हामरी गवाय काजे मान्‌ता काहनी। ");
INSERT INTO bhi_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","मे तुहुंक धरती पर हये ची वात देखाड़्‌यु, तेबी तुहुं तीनी वात पर भुरसु नी कर्‌या, ने कदी मे तुहुंक सरगेम हये ची वात देखाड़ीस ती तुहुं कसा भुरसु करसु? ");
INSERT INTO bhi_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","सरग मां उपर कुय बी नी गुयो, हयु अतरुत गुयु, जु सरग सी आयु तेरो मतलब माणसेन पुर्‌यु जु सरग मां छे।” ");
INSERT INTO bhi_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","जसु मुसु माणसे काजे भगवानेन डंडेम सी बचाड़णे करीन उजाड़्‌या बयड़ा मां घड़सान मुरती बणायन खाम्‌बा पर टांगलु तसात माणसेन पुर्‌या काजे बी उपर चहड़ाय टांगसे ने असो हवणु जरुड़ी छे। ");
INSERT INTO bhi_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","जु काहनुक माणसेन पुर्‌या पर भुरसु करे, चु तेरेत साहरे अमर जीवाय हात करसे ");
INSERT INTO bhi_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","काहाकी भगवान ईनी कळीन पापी माणसे काजे अतरु परम कर्‌यु, की तेरु एकुत लाटेक्‌लु पुर्‌यु मरने करीन आप देदु, ने जु कुय तेरे पर भुरसु करे, चु खत्‌तम नी हवे बाकुन अमर जीवन हात करसे। ");
INSERT INTO bhi_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","भगवान आपसा पुर्‌या काजे ईनी कळी मां माणसेन नीयाव करीन डंड आप्‌णेन हुकुम आपजी करीन नी मकल्‌यु, बाकुन तेरेमां मकल्‌यु की कळी मायन माणसे हेरे साहरे छुटकारु हात करसे। ");
INSERT INTO bhi_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ने जु काहनुक भगवानेन पुर्‌या ईसु पर भुरसु करे, तीनाक डंडेन हुकुम नी आपे; बाकुन जु कुय ईसु पर भुरसु नी करे, चु गुनावाळु गीणाय गुयलु छे, काहाकी चु भगवानेन एखला पुर्‌यान नाव पर भुरसु नी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","भगवान नीयावेन दाहड़े माणसे काजे डंडेन फेसलु जु सामळावसे की ईसु वीजाळो हय्‌न कळी मां आवलु, बाकुन माणसे काजे वीजाळो नी बाकुन आंदारला सी अदु परम राख्‌या, काहाकी तींद्‌रा काम भुंडात हतला। ");
INSERT INTO bhi_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","काहाकी जु कुय कुहराय करे, तीनाक वीजाळो गमे नी, ने तेरा कुहराय्‌न काम उजन्‌ता हय जासे करीन चु वीजाळा धड़े नी आवे। ");
INSERT INTO bhi_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","बाकुन जु कुय छाचली वातेन अनसारे चाल्‌या करे, चु जी हिम्‌मत करीन वीजाळा धड़े आवे, ने जे वारलु काम भगवानेन मदत सी करलु छे, चे काम, ने जी वात दीसरा अगळ उजन्‌ती हय जाणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","थुड़ाक दाहड़ा हय गुया ने अळी ईसु, आपसा चेला भेळतुत यरुसलेम सहर छुड़दीन यहुदीया जीलान दीसरा जागाम जाती रयु। ने चां चु तींद्‌रे पुठ्‌ये रय्‌न बपतीस्‌मा आपणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","तीनी टेमे चु युहन्‌‌‌नु बी सालेम सहर धड़े एनोन गांव मां पाणीन बपतीस्‌मा आपतेलु, काहाकी चां बेसको पाणी हतलो, ने माणसे आवीन बपतीस्‌मा लेदला। ");
INSERT INTO bhi_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","बपतीस्‌मा आपण्‌या युहन्‌ना काजे राजु हेरोदेस तीनी टेम लग जेल मां नी कुंडाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","चां युहन्‌नान चेला एक यहुदी माणसे साते चुखो करनेन रीतीन बारामां जखड़ी पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ने चे युहन्‌नान चेला युहन्‌ना धड़े आवीन कह्‌या, “ए मास्‌तर, जु माणुस यरदन नदीन पली धड़े तारे पुठ्‌ये हतलु, ने तेरी तु गवाय देदलु, ने चु बपतीस्‌मा आपणे बाजी रयु, ने आखा माणसे तेरे धड़े जाय।” ");
INSERT INTO bhi_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","युहन्‌‌‌नु जपाप आप्‌यु, “काहना बी माणसेक सरग वाळु भगवान वाटु आपसे तीत असला सेवान काम जड़से। ");
INSERT INTO bhi_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","मे तुहुंक ज कय देदलु की, ‘मे मसी नी हय, बाकुन मसीन काम सुरु हवणेन पेहेल भगवान मेसेक मकेल्‌लु छे।’ ने तुहुं मारी हीनी वातेन गवा छे। ");
INSERT INTO bhi_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","नवली लाडी नवला लाडा धड़े रवे, बाकुन नवला लाडान खास दुस्‌तीदार, चु नवला लाडा धड़े हुबु रय्‌न तेरी सामळे चु तेरी वात सामळीन बेसकु खुस हय जाय। तसीत हय मारी खुसी पुरी हय गुय। ");
INSERT INTO bhi_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ज जरुड़ी छे, की चु बड़तु जाय ने मे कम हवतु जाम। ");
INSERT INTO bhi_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“जु उपर सी आवे, चु आखा सी मट्‌लु छे। ईसु अतरुत सरग वाळा भगवानेन्‌चां सी आयु, हेरेसी चु आखाम सी मट्‌लु छे, धरती सी छे, बाकुन चु धरती पर रवण्‌यु छे, चु धरतीन छे, ने धरती पर वाळान तसात वात करे ");
INSERT INTO bhi_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ईसु ज काय चु देख्‌यु ने सामळ्‌यु, तेरीत गवाय देय; ने कुय तेरी गवाय नी माने। ");
INSERT INTO bhi_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","जु कुय ईसुन गवाय मान लेदु, चु ईनी वात पर छाप लागाड़ देदु की, भगवान छाचलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","काहाकी तीनाक भगवान मकेल्‌लु छे, चु भगवानेन वात कहें, काहाकी भगवान आत्‌मा अमर जीवाय आपलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","भगवान बास पुर्‌या सी परम करे, ने चु आखी चीज तेरा हात मां सुप देदु। ");
INSERT INTO bhi_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","जु भगवानेन पुर्‌या ईसु पर भुरसु करे, अमर जीवन तेरीत छे, बाकुन जु ईसुक नी माने, चु अमर जीवन काजे नी देखे, बाकुन भगवानेन रीस तेरे पर रहे ने तीनाक डंड जड़से ने जड़से।” ");
INSERT INTO bhi_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","फरीसी माणसे ईसुन बारामां ज सामळ्‌या की, ईसु बपतीस्‌मा आपण्‌या युहन्‌नान चेला सी अदुस चेला बणावे, ने तीनु चेलाक बपतीस्‌मा आपे ");
INSERT INTO bhi_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","अदुस ईसु आपसुत बपतीस्‌मा नी आपतेलु बाकुन ईसुन खास चेला, दीसरा नवला चेला बणावणे करीन बपतीस्‌मा आपतेला। ");
INSERT INTO bhi_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ती ईसु यहुदीया जीला काजे छुड़ीन अळी पछु गलील जीला भीणी जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","हीनी कावा ईसु, आपसा चेला पुठ्‌ये सामरीया जीला मायन गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","जाते-जाते चे, सामरीया जीलान सुखार नावेन एक सहर धड़े पुग्‌या। चां एक खेत हतलो, च खेत अगला वाराम याकुप आपसान पुर्‌या युसुफ काजे आपलु। ");
INSERT INTO bhi_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","चां याकुप्‌यान साहरे खुदाड़लु कुवु बी हतलु, तत्‌यार ईसुक चु कुवु देखायु, ईसु ते, चाली चालीन हारी पड़लु। अळतेन चु तीना कुवा धड़े चां बठ गुयलु। हय खयार दाहड़ु हय रवलु। ");
INSERT INTO bhi_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","तीनी टेमे तीना कुवा पर एक सामरी बायर पाणी भरने आवी। तत्‌यार ईसु तीनीक कह्‌यु, “मेसेक पाणी पीयाड़ दे।” ");
INSERT INTO bhi_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","काहाकी तेरा चेला खाणो मुल लेणे करीन सहर मां जाय रवला। ");
INSERT INTO bhi_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","तीनु दाहड़ाम यहुदी माणसे सामरी माणसे साते छीट राखतेला, अळी ची सामरी बायर ईसु काजे कय, “तु यहुदी जातीन हय्‌न बी मारे धड़े पाणी पीणे करीन काहा मांगे? मे ते एक सामरी जातीन बायर छे।” ");
INSERT INTO bhi_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ईसु तीनीक जपाप आप्‌यु, “कदी तु ज नी जाण लेती की, भगवान तुसेक काहनु वाटु आपणे हींडे, ने जु तारे धड़े पीणे करीन पाणी मांग र्‌यु, चु कुण छे। कदी तु जाण लेती ती मारे धड़े पाणी मांगती, ने मे तुसेक अमर जीवेन पाणी आपतु।” ");
INSERT INTO bhi_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","सामरी बायर ईसुक कय, “ए मालीक तारे धड़े ते कुवाम सी पाणी लाटणे करीन ठाहरु बी नी हय, ने कुवु उंडु छे; ती च अमर जीवन आपण्‌यो पाणी तु कां सी लावसी? ");
INSERT INTO bhi_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","तु हामरा बास याकुप सी बी मटु छे काय? जु हामु काजे गुयु कुवु आपलु; चु बी हीना कुवाम सीत पाणी पीदलु, ने तेरा पुर्‌या ने तेरा पाळ्‌ळा जनवार्‌या लग हीना कुवाम सी पाणी पीदा।” ");
INSERT INTO bhi_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ईसु सामरी बायर काजे कह्‌यु, “ज कुय पाणी पीये तीनाक अळी पीस लागसे, ");
INSERT INTO bhi_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","बाकुन मे आपीस च पाणी, जु बी पीसे तीनाक कदी पीस नी लागे। अतरोत नी बाकुन च पाणी तेरी जीवाय मां पाणीन झीर बण जासे। ने तेरी अमर जीवाय वाटे खळो-खळो उंहतो रवसे।” ");
INSERT INTO bhi_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","तत्‌यार सामरी बायर ईसुक कय, “ए मालीक मेसेक च पाणी आप ती मेसेक अळी-अळी पीस नी लागे, ने मेसेक चां पछो पाणी भरने आवणु नी पड़े।” ");
INSERT INTO bhi_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ईसु तीनीक कह्‌यु, “जाय्‌न तारा घरवाळा काजे बुलाय लाव।” ");
INSERT INTO bhi_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ची बायर जपाप आपी, “मारु घरवाळु नी हय।” ईसु तीनीक कह्‌यु, “तु संय कय की मारु घरवाळु नी हाय।” ");
INSERT INTO bhi_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","हव तु पांच लाडा कर लेदली, ने हय तु तेरे भेळे रय चु बी तारु घरवाळु नी हय, तु जी वात छाचलीन कय रय। ");
INSERT INTO bhi_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","जी वात सामळीन बायर ईसुक कही, ए मालीक असो लागे की, तु भगवानेन अघली वात बताड़न्‌यु माणुस छे। ");
INSERT INTO bhi_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","हामरा डाहा-डाहा हीना बयड़ा पर पुजा-पाट कर्‌या, ने तुहुं यहुदी माणसे कह्‌वु की पुजा-पाट करनेन जागु यरुसलेम सहर मां छे। ");
INSERT INTO bhi_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ईसु तीनीक कह्‌यु, “ओ बायर, मारी ईनी वात पर भुरसु कर, काहाकी असी टेम आवणे बाजी रय, की तीने टेमे तुहुं नी ते हीना बयड़ा पर ने नीते यरुसलेम मां भगवानेन पुजा-पाट करसु। ");
INSERT INTO bhi_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","तीनाक तुहुं नी जाणु तेरी पुजा-पाट करु ने हामु तीनाक जाणजे तेरी पुजा-पाट करजे, काहाकी छुटकारु यहुदी जातीवाळा मसी मां सीत जड़से। ");
INSERT INTO bhi_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","बाकुन हय ची टेम आवणे बाजी रय, ने हींताळ आय गुय, तीने टेमे छाचलीन भगवानेन पुजा-पाट करन्‌या, तेरा चुखली-आत्‌मा मां बणीन तेरी छाचली वातेन अनसारे भगवान बासेन भक्‌ती करसे। काहाकी भगवान बास आपसा वाटे असली भक्‌ती करन्‌यात काजे हेर र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","भगवान जीव-आत्‌मा छे, ने तेरे मां छाचलीन भगवानेन भक्‌ती करन्‌या काजे तेरा जीव-आत्‌मा मां रय्‌न ने छाचे मन तेरी भक्‌ती करनु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","सामरी बायर ईसुक कय, “मेसेक मालुम छे, की छुड़ावन्‌यु मसी जु खीरीस्‌त कह्‌वाये, चु आवणे वाळु छे; जत्‌यार चु आवसे, तत्‌यार हामु काजे आखी वात कय देसे।” ");
INSERT INTO bhi_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ईसु तीनीक कह्‌यु, “मेत मसी छे, जु तारे साते वात करने बाजी र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","तीनी टेमे ईसुन चेला आय गुया, ने ईसु काजे एक बायर साते वात करतेलु देखीन वीच्‌यार मां पड़ गुया; तेबी कुय बी ज नी कह्‌यो की तु हेरे धड़े सी काय मांग रयु? “नीते तु हीनी साते काहा वात कर रयु?” ");
INSERT INTO bhi_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तत्‌यार ची बायर आपसीत वटळु चांहान रहणीदीन तेरा सहर मां जाय्‌न माणसेक ज कहंणे बाजी गुय। ");
INSERT INTO bhi_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“चालु, एक माणुस काजे देख लेवु! चु माणुस, मे ज करली च आखो कय देदु; कांखुर मायन हयुत मसी हसे?” ");
INSERT INTO bhi_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","तीनी बायरीन वात सामळीन तीना सहर वाळा माणसे सहरेम सी नीकळीन ईसु काजे भेळा हवणे हुड़ु-हुड़ु आवतेला। ");
INSERT INTO bhi_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","तीने टेमे ईसुन चेला ईसु सी लीलघाय्‌न कह्‌या, “ए मास्‌तर थुड़ोक खाय ले।” ");
INSERT INTO bhi_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","बाकुन ईसु तीनुक कह्‌यु, “मारे धड़े खाणे वाटे असो खाणो छे, तीना खाणान बारामां तुहुंक मालुम नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","अतरात मां ईसुन चेला आपसा-आपसात कह्‌या, “कुय हेरे वाटे खाणो लायु हसे काय? करीन चु असु कय र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","जी वात समजीन ईसु तीनुक कह्‌यु, “मारो खाणो ज छे, की मारा मकलने वाळान मरजीन अनसारे चालो ने तेरो काम पुरो करो। ");
INSERT INTO bhi_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","तुहुं ते असा कवता आय रया, मेर पाकणेन हय चार महना बच रया। बाकुन मे तुहुंक दाखलान साहरे कह्‌वो, आपसा पापण्‌या उपर करीन ईनु खेत भीणी देखु, ईनु खेतेन मेर पाकीन धवळी फक हय गुय काटणे वाटे तीयार हय गुय। ");
INSERT INTO bhi_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","काटणे वाळाक दाहड़की जड़े ने अमर जीवाय वाटे फळ भेळा करे, काहाकी एरने वाळु ने काटणे वाळु दुयु खुस हवे। ");
INSERT INTO bhi_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","काहाकी जु दाखलु संय छे, ‘एरने वाळु काहनुक दीसरु छे, ने काटणे वाळु काहनु दीसरु छे।’ ");
INSERT INTO bhi_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","मे तुहुंक पलो खेत काटणे वाटे मकल्‌यु जाहां तुहुं मेहनत नी कर्‌या, ने दीसरा मेहनत कर्‌या ने तुहुं तींद्‌रा मेहनतेन फळ मां भेसकाय गुया।” ");
INSERT INTO bhi_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","चां सामरी बायर ईसुन बारामां असी गवा देदली की, “चु माणुस, मे ज करली च आखो कय देदु। अळतेन तीना सामरीया जीलान बेसका माणसे सामरी बायरीन मुंहडे ईसुन बारामां जी गवा सामळीन ईसु पर भुरसु करने बाजी गुया।” ");
INSERT INTO bhi_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","तेरेमां तत्‌यार ची सामरी बायर ईसु धड़े आय ती ईसु सी लीलघाय्‌न कह्‌णे बाजी गुय की हामरेन्‌चां रव। अळतेन ईसु चां दुय तीन दाहड़ा लग रयु। ");
INSERT INTO bhi_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ने ईसुन वात सामळी बेसका दीसरा माणसे बी ईसु पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ने अळी तीनी सामरी बायर काजे कह्‌या, “हय हामु तारी सामळीन ईसु पर भुरसु करने बाजी गुया; काहाकी हामु ईसुन वात सामळी लेदा, की छाचलीन हयु की हयु ईनी कळीन माणसेक पाप सी छुड़ावणे वाळु छे, करीन तेरे पर भुरसु कर रया।” ");
INSERT INTO bhi_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","अळतेन दुय दाहड़ा वीती गुया, ने ईसु आपसा चेला भेळु सामरीया जीलाम सी नीकळीन गलील जीलाम जात रयु। ");
INSERT INTO bhi_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ईसु ते आपसुत असी गवा देदलु की, “भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌यु, तीना काजे आपसान देस मां ईज्‌जत नी जड़े।” ");
INSERT INTO bhi_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","जत्‌यार ईसु गलील जीलाम पुग्‌यु, ती गलील वाळा माणसे ईसु तेरेत अनसारे ईसु साते वेहवार कर्‌या। चे बी तीहवारेन टेमे यरुसलेम सहर गुयला, ने तीहवारेन दाहड़ाम ईसु यरुसलेम मां जतरा बी वारलु काम करलु, चे आखा काम देखला हतला करीन ईसुन आव-भाव कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","तत्‌यार ईसु एक कावा अळी गलील जीलान काना सहर मां आयु, चां चु पाणी काजे अंगुरेन रस बणाय देदलु। ने हीना काना सहर साते वाळा कफरनहुम सहर राजान एक खास पावर हतलु, तेरु पुर्‌यु मांदलु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","चु ज सामळ्‌यु की यहुदीया सी ईसु आपसान गांव मां सी गलील जीलाम आय गुयलु छे, ती चु काना सहर मां ईसु धड़े गुयु, ने ईसु सी लीलघाय्‌न कह्‌यु की चाल मारा पुर्‌या काजे वारु कर दे। काहाकी तेरु पुर्‌यु मरने वाळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ईसु गलील वाळा माणसेन कम भुरसु देखीन कह्‌यु, “जत्‌यार लग तुहुं मटा कामेन सहलाणी नी देखु, तत्‌यार लग तुहुं मार पर भुरसु नी करसु।” ");
INSERT INTO bhi_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","चु राजान खास पावर्‌यु ईसुक कह्‌यु, “ए मालीक मामार चाल नेते मारु पुर्‌यु मर जासे।” ");
INSERT INTO bhi_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ईसु तीना राजान खास पावर्‌याक कह्‌यु, “जां तारु पुर्‌यु नी मरे, चु जीवतेलु रवसे।” चु राजान पावर्‌यु ईसुन ईनी वात पर भुरसु करीन जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","चु राजान खास पावर्‌यु वाटेत हतलु, ती तीना पावर्‌यान, पावर्‌या आय्‌न तीनाक भेळा हया ने कह्‌या, “तारु पुर्‌यु वारु हय गुयु ने जीवतु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","चु तीनुक पुछ्‌यु, “काहने टेमे मारु पुर्‌यु वारु हवणे बाजी गुयलु, चे कह्‌या काल दीसु एक बजे तेरो सेरी उतरी गुयलो।” ");
INSERT INTO bhi_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","तत्‌यार तीना मांदला पुर्‌यान बासेक जी वात हेर आवी की ईसु हीनीत टेमे ज कहंलु, “जां तारु पुर्‌यु जीवतु छे।” ने असु करीन चु राजान पावर्‌यु ने तेरा घरना आखा माणसे ईसु पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ज पेहला मायन दीसरा मटा कामेन सहलाणी हतली, जु ईसु यहुदीया सी गलील जीलाम पछु आय्‌न देखाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","अळतेन यहुदी माणसेन एक तीहवार आयु, ने ईसु यरुसलेम सहर अळी गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरुसलेम सहरेम गाडरान फाटक धड़े एक कुंडान तसों हतलो, तीनाक ईब्‌रानी माणसेन बुली मां बेतसेदा कह्‌वे; ने हीना कुंडान चारे मेर पांच मांडवा हतला। ");
INSERT INTO bhi_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","चां बेसका मांदवाड़ वाळा, आंदळा, लंगड़ा, ने पांगळा पाणी झलकायणेन वाट देखीन पड़ी रवतेला, ");
INSERT INTO bhi_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","काहाकी ठहरावली टेम पर भगवानेन सरग वाळु काहवाळ्‌यु कुंडा मां उतरीन पाणीक गचळावतेला। पाणी हवतेत जु काहनुक पेहेल उतरे चे मांदवाड़ वाळा वारु हय जाय, चाहे तेरी काहनी बी मांदवाड़ हय। ");
INSERT INTO bhi_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","तीना हळावेन चां एक माणुस हतलो, च दुय कम चालीस साल लग, चां मांदलु पड़ी रवलु। ");
INSERT INTO bhi_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ईसु तीनाक चां पड़ी रवलो देख्‌यु ने ज जाणीन की चु बेसका दाहड़ा सी असुत पड़ रवलु तेरेमां तीना मांदला काजे कह्‌यु, “तु वारु हवणे हींडे काय?” ");
INSERT INTO bhi_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","च मांदलो ईसु काजे जपाप आप्‌यु, “ए मालीक, पाणी झलकाय्‌तात मेसेक हळाव मां उतारे असो कुय माणुस मारे पुठ्‌ये नी हय। ने मेसेक पुगणेन पेहलुत हळाव मां दीसरु मांदलो माणुस उतरी पड़े।” ");
INSERT INTO bhi_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ईसु तीनाक कह्‌यु, “उबु हय जां। ने तारी गुदड़ी हाकलीन चाल।” ");
INSERT INTO bhi_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","च माणुस तत्‌यारुत वारु हय गुयो, ने तेरी गुदड़ी हाकलीन हींडणे बाजी गुयो चु दाहड़ु आरामेन दाहड़ु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","तेरेमां यहुदी माणसेन मुख्‌या तीना वारु हवला माणसेक कहंणे बाजी गुया, “आज आरामेन दाहड़ु छे। आज कायदान अनसारे तारे धड़े गुदड़ी हाकलनु वारु नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","चु वारु हवलु माणुस तीनुक कह्‌यु, जु मेसेक वारु करलु छे, चु मेसेक कहंलु छे, “उबु हय जां। ने तारी गुदड़ी हाकलीन जाती रव।” ");
INSERT INTO bhi_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","चे तीनाक पुछ्‌या, चु कुण छे, चु तुसेक कह्‌यु की, “उबु हय जां ने तारी गुदड़ी हाकलीन जाती रव?” ");
INSERT INTO bhi_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","बाकुन चु वारु हवलु, चु माणुस नी जाणतेलु की चु कुण छे, काहाकी चां जागा पर माणसेन गड़दी हवणे सी ईसु चां सी जाती रवलु। ");
INSERT INTO bhi_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","अळतेन ईसु तीना वारु हवला माणुस काजे ईसु मंदीर मां भेळु हयु, ती ईसु तीनाक कह्‌यु, “देख तु वारु हय गुयलु छे, अळी पाप घुण करे। नीते कांखुर मायन तार पर एर सी बी अळी जादा गरा आय पड़से।” ");
INSERT INTO bhi_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","चु माणुस जाय्‌न यहुदी माणसेक कह्‌यु की चु मेसेक वारु करलु चु ईसु छे। ");
INSERT INTO bhi_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ईसु आरामेन दाहड़े असो काम कर्‌यु, करीन यहुदी माणसे ईसु काजे दमणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ईसु तीनु दमण्‌याक ज कह्‌यु, “मारु बास हय लगुन काम करने बाजी रयु ने मे बी काम करने बाजी रयु।” ");
INSERT INTO bhi_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ईनी वजे सी यहुदी ने अदुस तीनाक मार नाखणेन कुसीत करने लाग्‌या, काहाकी हयु आरामेन दाहड़े वाळा रीतीक अतरुत नी तुड़े, बाकुन भगवान काजे मारु बास कहीन आपसा काजे भगवान बराबर बी ठहरावतेलु। ");
INSERT INTO bhi_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ईसु तीनुक कह्‌यु, मे तुहुंक छाचलीन कहं भगवानेन पुर्‌यु आपसान मन सी काय बी नी कर सके, बाकुन चु आपसान भगवान बासेक करतेलु देखे; काहाकी ज-ज काम भगवान बास करे चत काम तेरु पुर्‌यु बी करे। ");
INSERT INTO bhi_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","काहाकी भगवान बास ते पुर्‌या सी परम राखे ने ज-ज काम चु करे चो आखो तीनाक देखाड़े; ने चु हेरेसी बी मटा काम तीनाक देखाड़से ने चे काम देखीन तुहुं घाबराय जासु। ");
INSERT INTO bhi_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","तुहुंक मालुम छे की भगवान मर्‌या सर्‌याक जीवता करीन बठा करे। तसुत पुर्‌या धड़े बी जीनुक गमे तीनुक नवलो जीवन आपणेन ने जीवता करीन बठा करनेन हक छे। ");
INSERT INTO bhi_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","भगवान बास ते कुयन बी नीयाव नी करे, बाकुन माणसेन नीयाव करनेन आखो हक तेरा पुर्‌या काजे आप देदलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","काहाकी आखा माणसे भगवान बासेन ईज्‌जत करे; तसान तसा आखा माणसे तेरा पुर्‌यान बी ईज्‌जत करनु चाहे। चु पुर्‌यान ईज्‌जत नी करे चु पुर्‌या काजे मकलन्‌या भगवान बासेन बी ईज्‌जत नी करे। ");
INSERT INTO bhi_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","मे तुहुंक छाचलीन कहं, जु मारा बुले सामळीन मेसेक मकलन्‌या भगवान बास पर भुरसु करे तीनाक अमर जीवन जड़से ने नीयावेन दाहड़े तीनाक डंडेन हुकुम नी जड़े बाकुन चु मुत काजे छेकीन अमर जीवन हात कर लेदलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","मे तुंद्‌रे सी छाचलीन कहं च टेम आवसे ने मरला माणसे भगवानेन पुर्‌यान बुल सामळसे ने जे सामळसे चे मर्‌या-सर्‌याम सी जीवता हय जासे। ");
INSERT INTO bhi_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","काहाकी भगवान बास जीवनेन झीर छे, तसुत चु हेरा पुर्‌या काजे बी ज हक आपलु छे की तु बी जीवनेन झीर छे; ");
INSERT INTO bhi_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","अतरोत नी बाकुन भगवानेन पुर्‌यु माणसेन पुर्‌यु बणीन आवलु छे, तेरेमां तीनाक माणसेन नीयाव करनेन बी हक आपलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","मर्‌या-सर्‌याम सी जीवता हवणेन बारामां घुण घाबरायु काहाकी ची टेम आवणे बाजी रय, तीने टेमे जतरा बी मड़ायट्‌या मां गाड़ला छे चे आखा भगवानेन पुर्‌यान बुल सामळीन जीन्‌दा हय जासे ने मड़ायट्‌या मां सी नीकळीन आवसे। ");
INSERT INTO bhi_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","जे भगवानेन नींगाम भलाय करला छे अमर जीवन वाटे मरलाम सी जीवता हय्‌न बठा हवसे, ने जे भगवानेन नींगा मां कुहराय करला छे, चे नीयावेन दाहड़े डंड भुकत्‌णे करीन मरलाम सी जीवता हय्‌न मड़ायट्‌याम सी नीकळसे। ");
INSERT INTO bhi_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","मे मारी मरजी सी काय बी नी कर सको। तेरेत अनसारे नीयाव करो; ने मारु नीयाव छाचु छे काहाकी मे मारी मरजी सी नी बाकुन मे मकलने वाळा भगवानेन मरजी पुरी करो। ");
INSERT INTO bhi_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","कदी मे मारा बारामां मे अतरुत गवा दम ती मारी गवाय छाचली नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","एक अळी छे चु मारी गवाय देय ने मे जाणो की चु मारी गवाय देय ने तेरी गवाय छाचली छे। ");
INSERT INTO bhi_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","तुहुं बपतीस्‌मान रीत आपण्‌या युहन्‌ना धड़े पुछणे करीन माणसे काजे मकल्‌या, ने तत्‌यार चु मारा बारामां छाचली गवाय देदु। ");
INSERT INTO bhi_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","बाकुन मे मारा बारामां माणसेन गवाय नी चाहतु; जी वात तेरेमां कव की तुहुं पाप सी छुटकारु जड़े। ");
INSERT INTO bhi_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","युहन्‌‌‌नु ते एक धपतेला दिवान तसलु हतलु, ने तुहुंक ईतरीक वार लग तीना दिवान वीजाळा मां खुस रहणु वारु लाग्‌यो। ");
INSERT INTO bhi_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","बाकुन युहन्‌‌‌नु मारे बारामां जी गवा देदलु, तीनी गवाय सी मटी गवा मारे धड़े छे, काहाकी ज काम करने भगवान बास मेसेक मकेल्‌लु छे, चेत काम मे करने बाजी रयु ने चेत काम मारे बारामां जी गवा दी रया की मारु भगवान बास मेसेक मकेल्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ने भगवान बास जु मेसेक मकेल्‌लु छे, चु मारी गवा देदलु छे। तुहुं कदी बी तेरो वचन नी सामळ्‌या ने तेरु सीकु नी देख्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ने हेरा बुल काजे मन मां बठाड़ीन नी राखे, काहाकी तीनाक हयु मकल्‌यु तेरे पर तुहुं भुरसु नी करु। ");
INSERT INTO bhi_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","तुहुं चुखली-सास्‌तुर मां चाळवीन भन्‌ने हामु काजे अमर जीवन जड़से, असु वीच्‌यार करीन तुहुं चुखली-सास्‌तुर काजे चाळवीन भण्‌या बाकुन जीत चुखली-सास्‌तुर मारा बारामां असी गवा देदी आय रय की जु आवणेवाळु छे, हयुत अमर जीवन आपण्‌यु छे! ");
INSERT INTO bhi_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","तेबी तुहुं जीवन हात करने करीन मारे धड़े आवणे नी हींडता। ");
INSERT INTO bhi_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","मेसेक माणसे धड़े सी ईज्‌जत नी चाहती। मेसेक ईज्‌जत आपण्‌यु ते मारुत भगवान बास छे। ");
INSERT INTO bhi_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","बाकुन मेसेक मालम छे की तुंद्‌रे माहें भगवानेन परम नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","मे मारा भगवानेन नाव सी आवलु छे, तेबी तुहुं मेसेक मानीन मार पर भुरसु नी करता; कदी काहनुक दीसरु आपसान नावे आवे ती तुहुं तीनाक मानीन तेर पर भुरसु कर लेसु। ");
INSERT INTO bhi_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","तुहुं ते आंबा-सांबा ईज्‌जत ने आव-भाव हात करने हींड रया, बाकुन तुहुंक एकुत भगवान सी ईज्‌जत ने आव-भाव जड़से ने तुहुं नी चाहता, ती तुहुं मारे पर कसा काय भुरसु करसु? ");
INSERT INTO bhi_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","असा घुण समजु की मे भगवान अगळ तुहुं काजे गुनाळा ठहरावीस, तुंद्‌रे पर गुनु लागाड़ने वाळु ते मुसा छे, तेरे पर तुहुं भुरसु राख र्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","काहाकी कदी तुहुं मुसा पर भुरसु करता ती मारु बी भुरसु करता काहाकी चु मारा बारामां लिखलु। ");
INSERT INTO bhi_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","बाकुन कदी तुहुं मुसान लिखली वात पर लग भुरसु नी करु, ती मारी वात पर कसा भुरसु करसु? ");
INSERT INTO bhi_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","थुड़ाक दाहड़ा हय गुया ने अळतेन, गलील सी ईसु आपसा चेला भेळुत गलील डाबरान पली धड़ जाती र्‌यु। ईना गलील डाबरा काजे तीबीरीयासेन मटलो डाबरो बी कहें। ");
INSERT INTO bhi_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ईसु, बेसका मांदला माणसेक वारु करतेलु। ईसुन ईनु मटा कामेन सहलाणी देखीन माणसेन एक मटुत टुळु ईसु पछळ चाल पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","तत्‌यार ईसु बयड़ा पर चहड़ीन हेरा चेला पुठ्‌ये चां बठ गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","यहुदी माणसेन फसहन तीहवार सातेत आय रवलु। ");
INSERT INTO bhi_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","जत्‌यार ईसु बेसकु मटु माणसेन टुळा काजे हेरे भीणी आवतेला देख्‌यु, ती फीलीप्‌पुस सी कह्‌यु, “हीनु आखा माणसे काजे रुटा खावाड़ने वाटे कां सी मुल लावसुन?” ");
INSERT INTO bhi_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ईसु जी वात फीलीप्‌पुस काजे पंतारने करीन कहंलु, काहाकी ईसु काजे जी वात मालुम हतली की चु काय करने वाळु छे। ");
INSERT INTO bhi_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फीलीप्‌पुस ईसु काजे कह्‌यु, “दुय सोव दाहड़ान दाहड़कीन रुप्‌यान रुटा लावसु ने, ईतराक-ईतराक वाटसु तेबी हींद्‌रे वाटे पुरती नी हवे।” ");
INSERT INTO bhi_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ईसुन चेला मायन सीमोन पतरसेन सगु भायस अन्‌दीरीयास ईसु काजे कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“जां एक नानलु पुर्‌यु छे तेरे धड़े जळ-गहुंन पांच रुटा ने दुय माछा छे, बाकुन अतरा माणसे मां काय हवसे।” ");
INSERT INTO bhi_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ईसु जपाप आप्‌यु, “माणसेक पंगते बठाड़ देवु।” तीना जागा पर बेसकु वारु चारु हतलु; चां माणसे बठी गुया। ने चां अदमी पांचेक हजार हतला। ");
INSERT INTO bhi_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तत्‌यार ईसु रुटा हातेम लेदु, ने रुटा लीन भगवान काजे कह्‌यु, तु बेसकु वारु, ने चु बठी रवला माणसेम चे रुटा वाटाड़ देदु। ने माछा बी तसुत वाटाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","जत्‌यार माणसे खायलीन आफरी गुया, ती ईसु हेरा चेला सी कह्‌यु, “बचला रुटान कुटका भेळा कर लेवु, थुड़ाक बी रद नी हवणु चाहे।” ");
INSERT INTO bhi_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","अळतेन चेला खायलीन रवला जळ-गहुंन रुटान कुटका काजे भेळा कर्‌या ती बारे चार्‌या भराय गुया। ");
INSERT INTO bhi_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","माणसे ईसुन मटला कामेन सहलाणी देखीन कय पड़्‌या, “छाचली, चु भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या माणुस ईनी कळी मां आवणे वाळु हतलु।” ");
INSERT INTO bhi_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ईसु ज जाण लेदु की माणसे आवीन मेसेक जबरान मां राजु बणावणे हींडे तेरेमां पछेन बयड़ा पर एखेलुत जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","जत्‌यार सांती वेळाय हय ती ईसुन चेला गलील दरीया धड़े गुया। ");
INSERT INTO bhi_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","चे ढंड्‌या मां बठीन दरीयान पली धड़ कफरनहुम सहर भीणी जाणे बाजी गुया। आंदारो बेसको हय गुयलो ने ईसु चां लग तींद्‌रे धड़े पछु नी आयु। ");
INSERT INTO bhi_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","आहळीन वजे सी दरीया मां झलक बी आवणे बाजी गुय। ");
INSERT INTO bhi_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","जत्‌यार चे पांच छव कीलुमीटर अगा जाती रवला, ती चे ईसु काजे दरीया पर ढंड्‌या भीणी चालीन आवतेलु देख्‌या ने चे बीही गुया। ");
INSERT INTO bhi_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","बाकुन ईसु हेरा चेलाक कह्‌यु, “मेत छे, बीहु मां।” ");
INSERT INTO bhi_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","अळतेन चे ईसुक ढंड्‌या मां बठाड़्‌या ने तत्‌यारुत च ढंड्‌यो तीना जागा पर गुयो, जां चे जाणे बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","दीसरे दाहड़े चु टुळु ने, एक दरीयान पली धड़ उबु हय रवलु, चे असा देख्‌या की जां एक काजे छुड़ीन अळी दीसरो ढंड्‌यो नी हतलो, ने ईसु आपसा चेला साते तीना ढंड्‌या पर चहड़ी नी रवलु बाकुन तेरा चेला अतरात गुयला। ");
INSERT INTO bhi_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","तत्‌यार नानला दीसरा ढंड्‌या तीबीरीयास सी तीना जागा धड़े आया चे चां मालीक काजे तु बेसकु वारु छे, कय्‌न रुटा खादा। ");
INSERT INTO bhi_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","हेरेसी जत्‌यार टुळु देख्‌यु की जां नीते ईसु हय ने नी हेरा चेला छे, ती चे ढंड्‌या पर चहड़ीन ईसु काजे हेरता जाय्‌न कफरनहुम जात रया। ");
INSERT INTO bhi_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","दरीयान पली धड़े जत्‌यार चे ईसु काजे भेळा हया ती कह्‌या, “ए मास्‌तर तु जां कत्‌यार आयु?” ");
INSERT INTO bhi_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ईसु तीनुक जपाप आप्‌यु, “मे तुहुंक छाचलीन कहं, तुहुं मारे सी करला मटा कामेन सहलाणी देखीन तेरो मतलब समजी गुया करीन मेसेक नी हेर्‌या, बाकुन तुहुं रुटा खाय्‌न आफरी गुयला छे, करीन मेसेक हेर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","रद हवण्‌या खाणा वाटे मेहनत मां करु, बाकुन तीना खाणा वाटे मेहनत करु ज रद नी हवे, ने च खाणो अमर जीवन वाटे जलम टेकलो रहे, ने असो खाणो तुहुंक माणसेन पुर्‌यु आपसे, अटकळ राखु, भगवान बास माणसेन पुर्‌या पर छाप लागाड़ीन ज देखाड़लु छे की माणसेन पुर्‌यु अतरु माणसेक अमर जीवन आपणेन हकदार छे।” ");
INSERT INTO bhi_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","माणसे ईसु सी पुछ्‌या, “तीना काम काजे भगवान चाहे तीना काम काजे करने वाटे हामु काय करजे?” ");
INSERT INTO bhi_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ईसु तीनु माणसेक जपाप आप्‌यु, “भगवानेन काम ज छे, की भगवान तीना काजे मकेल्‌लु छे, तीना पर तुहुं भुरसु करु।” ");
INSERT INTO bhi_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","तत्‌यार चे माणसे ईसुक कह्‌या, “तु काहनी सहलाणी देखाड़े की हामु तीनाक देखीन तार पर भुरसु करजे? तु काहनो काम देखाड़े? ");
INSERT INTO bhi_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","हामरा डाहा बुड़ा ते बयड़ा मां बेसका दाहड़ा लग मुसा वाटे आपलो मन्‌ना नावेन खाणो खादला ने तेरे बारामां चुखला सास्‌तुर मां लिखलो बी छे; चु तीनु काजे खाणे करीन सरग सी रुटा आप्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ईसु तीनुक कह्‌यु, “मे तुंद्‌रे सी छाचलीन कहं की मुसु तुहुंक चे रुटा सरग सी नी देदु बाकुन मारु बास तुहुंक खरला रुटा सरग सी आपे।” ");
INSERT INTO bhi_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","काहाकी भगवानेन रुटु हयुत छे जु सरग सी उतरीन कळी माणसे काजे अमर जीवन आपे। ");
INSERT INTO bhi_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","तत्‌यार चे माणसे ईसु सी कह्‌या, “ए मालीक चे रुटा हामु काजे जलम आप्‌या कर।” ");
INSERT INTO bhi_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ईसु तीनुक कह्‌यु, “अमर जीवनेन रुटु मेत छे; जु मारे धड़े आवसे ने मारे पर भुरसु करसे तीनाक कदी भुक नी लागे। ");
INSERT INTO bhi_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","बाकुन मे तुहुंक कह्‌लु पेहेल बी कय देदलु की मेसेक देख बी लेदला छे, तेबी भुरसु नी करता। आखा चे माणसे भगवान बास मेसेक सुपलु चे आखा मारे धड़े आवसे। ");
INSERT INTO bhi_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","तेबी मे हिम्‌मत नी हारो, भगवान बास तीनुक बी नेवाड़ीन मारा हातेम आप देय, चे आखा मारेन्‌चां आवसे ने मे तीनुक मारेन्‌चां सी कदी नी ढासाड़ो। ");
INSERT INTO bhi_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","काहाकी मे मारी मरजी पुरी करने नी बाकुन मेसेक मकलन्‌यान भगवानेन मरजी पुरी करने करीन सरग सी धरती पर उतरीन आवलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ने मारा मकलने वाळान मरजी जी छे, ज काय हयु मेसेक आप्‌यु तेरे मां सी मे काय बी नी खुवो बाकुन तीनुक आकरी दाहड़े मर्‌या-सर्‌याम सी जीन्‌दा कर दीस। ");
INSERT INTO bhi_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","काहाकी मारा बासेन मरजी जी छे की जु कुय मारा पुर्‌या काजे देखे ने तीना पर भुरसु करे। तीनाक अमर जीवन जड़से ने मे तीनाक आकरी दाहड़े मर्‌या-सर्‌याम सी पछु जीन्‌दा कर दीस।” ");
INSERT INTO bhi_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","तेरेमां यहुदी माणसे तीना पर वाक नीकाळीन कुर-कुर करने बाजी गुया काहाकी ईसु कह्‌लु, “जु रुटु सरग सी उतर्‌यु चु मेत छे।” ");
INSERT INTO bhi_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ने चे कह्‌या, “काय जु युसुफेन पुर्‌यु ईसु नी हय काय, तेरा आयस बास काजे हामु उळख्‌जे? ती चु कसु कहें की मे सरग सी उतर्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ईसु तीनुक जपाप आप्‌यु, तुहुं तुहुंत कुर-कुर मां करु। ");
INSERT INTO bhi_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","बाकुन जी वात समज लेवु, जत्‌यार लग मेसेक मकलन्‌यु भगवान बास तीनाक बी मनवीन मारे धड़े नी लावे तत्‌यार लग तीनुक मारे धड़े नी आवाये, असला माणसे काजे मे आकरी दाहड़े, मतलब नीयावेन दाहड़े मर्‌या-सर्‌याम सी पछु जीवतु करीन बठु कर दीस। ");
INSERT INTO bhi_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळा माणसे आपसा किताप मां लिखलो छे, “चे आखा भगवानेन भीणी सी सीकाड़ला रवसे।” जे काहनाक मारा बास सी सामळ्‌या ने सीक्‌या, चे मारे धड़े आवे। ");
INSERT INTO bhi_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ज घुण समज्‌ता की काहनुक भगवान बास काजे देखलु छे, बाकुन जु भगवान बासेन आवजी पर तेरेन्‌चां सी आवलु छे, हय अतरुत भगवान बास काजे देखलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“मे तुंद्‌रे सी छाचलीन कहं, की जु काहनुक भुरसु करे, अमर जीवन तेरोत छे। ");
INSERT INTO bhi_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","अमर जीवनेन रुटु मेत छे। ");
INSERT INTO bhi_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","तुंद्‌रा आड़ा-बुड़ा बयड़ा मां मन्‌ना नावेन खाणो खादा, तेबी चे मर गुया। ");
INSERT INTO bhi_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","बाकुन जु पल्‌लु रुटु छे, जु सरग सी उतरे, काहाकी काहनुक माणुस हेरेम सी खाय, ने मरे नी। ");
INSERT INTO bhi_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","सरग सी उतर्‌लु अमर जीवन आपण्‌यु रुटु मेत छे, कदी काहनुक जु रुटु खासे चु जलम जीवतेलु रवसे ने जु रुटु मे ईनी कळीन माणसेन जीवन वाटे आपीस, चु रुटु मारो मास छे।” ");
INSERT INTO bhi_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","अतरा मां चे यहुदी माणसे असा कह्‌ता जाय्‌न वातेम लड़ायणे बाजी गुया की, “जु माणुस आपसो मास खाणे करीन कसु दी सक्‌से।” ");
INSERT INTO bhi_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ईसु तीनुक कह्‌यु, “मे तुंद्‌रे सी छाचलीन कहं की, जत्‌यार लग तुहुं माणसेन पुर्‌यान मास नी खावु ने तेरो लुही नी पीयु चां लग तुहुंक जीवन नी जड़े। ");
INSERT INTO bhi_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","जु मारो मास खाय ने मारो लुही पीये, अमर जीवन तेरोत छे; ने मे आकरी दाहड़े तीनाक मर्‌या-सर्‌याम सी पछा जीन्‌दा कर दीस। ");
INSERT INTO bhi_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","काहाकी मारो मास छाचलीन खाणेन चीज छे, ने मारो लुही छाचलीन पीणेन चीज छे। ");
INSERT INTO bhi_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","जु मारो मास खाया करसे ने मारो लुही पीया करसे चु मारेम वारु बणीन रवसे ने मे तेरेमां रवीस। ");
INSERT INTO bhi_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","जसु जलम जीवण्‌यु बास मेसेक मकल्‌यु ने मे मारा बासेन वजे सी जीवलु रवीस, तसा की तसा जु मेसेक खासे चु मारे वजे सी जीवलु रवसे। ");
INSERT INTO bhi_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","सरग सी उतेरलु रुटु मेत छे। जु रुटु तीना रुटान तसु नी हय, तीनाक आड़ा-बुड़ा खादा ने मर गुया; बाकुन काहनुक जु हीना रुटु काजे खासे चु जलम जीवलु रवसे।” ");
INSERT INTO bhi_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","कफरनहुम सहर वाळा तींद्‌रा भक्‌तीन घर मां रय्‌न सीकाड़तु जाय्‌न ईसु जी आखी वात कह्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ईसुन चेला मां सी बेसका जणा ज सामळीन कह्‌णे बाजी गुया, “जी ते काठी वात छे हीनीक कुण सामळाय सक्‌से?” ");
INSERT INTO bhi_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ईसु हेरा मन मां जी वात जाण लेदु की मारा चेला ईनी वातेन बारामां कुर-कुर कर रया। ईसु पुछ्‌यु, “काय ईनी वात सी तुहुंक ठुकर लाग रय काय। ");
INSERT INTO bhi_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","कदी तुहुं माणसेन पुर्‌या काजे जां हयु पेहेल हतलु, चां उपर जातलु देखसु ती काय हवसे? ");
INSERT INTO bhi_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","भगवानेन चुखली-आत्‌मा जीवन आपे। डील सी काय फायदु नी हय जी वात मे तुंद्‌रे सी कहंलु चे आत्‌मा छे ने जीवन बी छे। ");
INSERT INTO bhi_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","बाकुन तुंद्‌रे मायन काहनाक असा छे, चे भुरसु नी करे।” काहाकी ईसु पेहलुत सी जाणतेलु की जे भुरसु नी करे चे कुण छे; ने कुण छे चे मेसेक धुकु देसे। ");
INSERT INTO bhi_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ईसु कह्‌यु, “ने मे तुहुं काजे ज कह्‌लु की काहना बी माणसेक भगवान बासेन मदत लेय पाखुर मारे धड़े नी आवाये।” ");
INSERT INTO bhi_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ज सामळीन ईसुन बेसका चेला ईसुन चां सी जाती रया, ने ईसुन सात छुड़ देदा। ");
INSERT INTO bhi_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","तत्‌यार ईसु तीनु बारे चेला काजे कह्‌यु, “काय तुहुं बी जाणे हींडी रया?” ");
INSERT INTO bhi_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","सीमोन पतरस ईसु काजे जपाप आप्‌यु, “ए मालीक हामु कुणी धड़े जाजे? अमर जीवन आपण्‌या बुले ते तारेत धड़े छे। ");
INSERT INTO bhi_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ने हामु जाण गुया ने भुरसु कर लेदा की, भगवानेन चुखलु माणुस तुत मसी छे।” ");
INSERT INTO bhi_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ईसु तीनुक जपाप आप्‌यु, “काय मे तुहुं बारे जणा काजे नी नेवाड़्‌यु? तेबी तुंद्‌रे मायन एक माणुस भुतड़ु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ईसु जी वात सीमोन ईस्‌करीयोतीन पुर्‌या यहुदीयान बारामां कह्‌लु, काहाकी ईसुन बारे चेला मायन एक हतलु, चु ईसु काजे धुकु देणेवाळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","यहुदा जीला वाळा यहुदी मुख्‌या ईसुक मार नाखणेन वीच्‌यार कर रवला, तेरेमां चु यहुदा जीला मां जाणे नी हींडतेलु ने ईसु आपसा चेला भेळुत गलील जीलात मां सेवा करतु जाय्‌न हींडतु रयु। ");
INSERT INTO bhi_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","बाकुन हीयु यहुदी माणसेन आसरान तीहवार सातेत आय रवलु। ");
INSERT INTO bhi_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","तेरेमां ईसुन भायस ईसुक कह्‌यु, “जां सी यहुदी जीलाम जां काहाकी ज काय काम तु करे तीनु कामेक तारा आखा चेला बी देखे। ");
INSERT INTO bhi_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","काहाकी असु काहनु नी हसे चु नाव कमाय्‌णे चाहे ने डुकायन काम करे। कदी तु ज काम करे ती खुद काजे कळी पर उजेंतु कर।” ");
INSERT INTO bhi_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","काहाकी ईसुन भाय ईसु पर भुरसु नी करतेलु करीन चु असी वात कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तत्‌यार ईसु तीनुक कह्‌यु, “मारे वाटे हाल लगुन वारु टेम नी आवी बाकुन तुंद्‌रे वाटे आखी टेम वारलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ईनी कळीन माणसे मे तुंद्‌रे सी कुहराय नी राखो, बाकुन जे मारे सी कुहराय राखे काहाकी मे तेरा वीरुद मां जी गवाय दम की तेरा काम भुंडात छे। ");
INSERT INTO bhi_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","तुहुं तीहवार मां जावु, मे हय ईना तीहवार मां नी जातु, काहाकी हय लग मारी टेम पुरी नी हय रय।” ");
INSERT INTO bhi_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","जी वात कय्‌न ईसु गलील जीलात मां रय गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","जत्‌यार ईसुन भायस तीहवार वाळने जाती रया, ती ईसु बी गुयु, बाकुन उजेंतु नी हयु, चु हुगलुत चां गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","खपड़ीन तीहवार मां यहुदी माणसे ईसु काजे हेरता जाय्‌न असा पुछतेला, “चु माणुस कां छे।” ");
INSERT INTO bhi_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","खपड़ीन तीहवार मां माणसे ईसुन बारामां कळेन कळे बेसकी वात करतेला, “हयु भलु माणुस छे।” ने थुड़ाक कहंतेला, “नी हयु भलु नी हय बाकुन माणसे काजे भटकाड़ र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","कुय बी तेरे बारामां जुर सी वात नी करतेला, काहाकी चे यहुदी नेता सी बीहतेला। ");
INSERT INTO bhi_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","तीहवारेन आदा दाहड़ा जाती रया, ने ती ईसु मंदीरेन आंगणा मां जाय्‌न सीकाड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ईसुन वात सामळीन यहुदी माणसे घाबराय्‌न ईसुन बारामां असा कह्‌या, “काहना बी गुरुन साहरे सीके बीगुर ईना माणसेम असी अक्‌कल कां सी आय गुय।” ");
INSERT INTO bhi_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","असा कहण्‌याक ईसु कह्‌यु, “मारु भगवान बास मेसेक मकलने वाळु छे। वात सीकाड़ने वाळी मारी मनेन वात नी हय बाकुन मेसेक मकलने वाळान छे। ");
INSERT INTO bhi_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","कदी काहनुक तेरी मरजी पर चालने हींडे, ती हयु ईनी भणावली वातेन बारामां जाण जासे की, ज भगवान भीणी सी छे, की मे मार भीणी सी कहंणे बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","जु काहनुक आपसुत खुद काय कह्‌वे, चु आपसान बड़ाय करनु चाहे, बाकुन जु आपणा मकलने वाळान बड़ाय करनु चाहे हयुत छाचलीन छे, ने हेरेम काय बी पाप नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","काय मुसु तुहुंक नेम कायदु नी देदु काय? तेबी तुंद्‌रे मां सी काहनुक मुसान साहरे लिखला नेम कायदा पर नी चाले। तुहुं काहा मेसेक मारेन हींडी रया?” ");
INSERT INTO bhi_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","माणसेन टुळाम सी काहनाक जपाप आप्‌या, “असो लागे तारे मां भुतड़ो भराय रयो। कुण तुसेक मारने हींडे?” ");
INSERT INTO bhi_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ईसु तीनुक जपाप आप्‌यु, “मे आरामेन दाहड़े एक मांदलाक वारु करलु करीन, ने तुहुं आखा देखीन चकराय रया। ");
INSERT INTO bhi_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","हेरे वजे सी मुसु तुहुंक फतरी काटणेन रीती पाळनेन नीयम आप्‌यु, ज नी की मुसा भीणी सी बाकुन डाहा बुड़ा सी चालती आय रय ने तुहुं आरामेन दाहड़े माणसेन फतरी काट्‌या करु। ");
INSERT INTO bhi_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","जत्‌यार आरामेन दाहड़े माणसेन फतरी काटाड़े, काहाकी मुसान नीयम नी टुटे, ती तुहुं मारे पर काहा रीस करु की मे आरामेन दाहड़े एक माणसे काजे वारु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","मुंहडा देखीन दसा तसा नीयाव मां करु, वारु वीच्‌यार करीन खरु नीयाव करु।” ");
INSERT INTO bhi_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तीनी टेमे यरुसलेम सहर वाळा थुड़ाक यहुदी माणसे कहंणे बाजी गुया, “काय जु हयुत माणुस छे ने हय तीनाक हामरा पुडार्‌या मार नाखणेन वीच्‌यार कर रया। ");
INSERT INTO bhi_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ने देखु जु ते उजेंतु वात करने बाजी रयु, ने कुय हीनाक काय नी कह्‌ता। काय यहुदी नेता छाचलीन जाण लेदा काय हयुत मसी छे? ");
INSERT INTO bhi_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","बाकुन हीनाक ते हामु जाणजे की, जु कां सी आवलु छे; बाकुन मसी जत्‌यार आवसे ती कुय नी जाणे की चु कां सी आयु।” ");
INSERT INTO bhi_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","तत्‌यार ईसु मंदीर आंगणा मां सीकाड़तु जाय्‌न आयड़ीन कह्‌यु, “तुहुंक असो लागे की हीनाक उळखी रया, ने ज बी जाणु की मे कान छे। मेते मारी मरजी सी नी आयु, बाकुन मेसेक मकलने वाळु खरलु छे, तीनाक तुहुं नी जाणु। ");
INSERT INTO bhi_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","मे तीनाक जाणो काहाकी मे तेरे भीणी सी आयु ने हयुत मेसेक मकेल्‌लु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","थुड़ाक माणसे ईसुक धरीन ली जाणे हींडी रवला, बाकुन आज लग ईसुन मरने टेम नी आय, जी टेम भगवान नक्‌खी करलु। ");
INSERT INTO bhi_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","तेबी माणसेन टुळा मां सी बेसका माणसे ईसु पर भुरसु कर्‌या, ने कहणे बाजी गुया, “अतरा चकराड़न्‌या वारु कामेन सहलाणी दीसरु काहनु बी, नी देखाड़ सके।” ");
INSERT INTO bhi_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","फरीसी माणसे ज सामळ्‌या की, माणसे ईसुन बारामां कळे-कळे वात करने बाजी र्‌या; ती चे मंदीरेन डाहला पुजारा साते वात करीन ईसुक धरीन लावणे करीन मंदीरेन राखवाळ्‌या सीपायड़ा काजे मकल्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","पछेन ईसु कह्‌यु, “हय मे ईतरीक वार तुंद्‌रे पुठ्‌ये रय्‌स। ने अळतेन मेसेक जु मकेल्‌लु छे, तेरेन्‌चां पछु जाती रय्‌स। ");
INSERT INTO bhi_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","तुहुं मेसेक हेर्‌या करसु बाकुन मे तुहुंक नी जड़ो। ने मे जां जाणे हींडी र्‌यु चां तुहुंक नी आवाये।” ");
INSERT INTO bhi_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","जी वात सामळीन यहुदी-मुख्‌या आपसा-आपसात कह्‌या, “जु काहा जासे की हयु हामुक नी जड़े, काय हयु पला धड़े जासे जे युनानी मां रावण्‌या-तीवण्‌या हय्‌न रवे ने युनानी काजे वारलु वात सीकाड़ देसे? ");
INSERT INTO bhi_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","जां काय वात छे, ची जु कह्‌लु, की तुहुं मेसेक हेरसु बाकुन मे नी जड़ो; ने चां मे छे चां तुहुं नी आय सकु?” ");
INSERT INTO bhi_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","खपड़ीन तीहवारेन खास दाहड़े जु पेहलु दाहड़ु छे, ईसु उबु हयु ने आयड़ीन कह्‌यु, “कदी कुय पीसलो हय ती मारे धड़े आवे ने पाणी पीणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","जु मार पर भुरसु करसे जसों चुखला सास्‌तुर मां अनसारे आवलो छे, तेरा डील मां सी जीवनेन पाणीन नदी उहवसे।” ");
INSERT INTO bhi_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ईसु ज बुल चुखली आत्‌मान बारामां कह्‌यु, ज कुय हेरे पर भुरसु करने वाळा हेरेत पर हतला; काहाकी आत्‌मा हय लग नी उतरी काहाकी ईसु हय लग तेरी सेक-सींगार लग नी पुग्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ईसुन जी वात सामळीन माणसेन टुळा मां सी काहना-काहनाक जी वात कह्‌या, “छाचलीन हयु भगवानेन अघली वात बताड़ने वाळु माणुस छे।” ");
INSERT INTO bhi_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","थुड़ाक माणसे कवतेला की, “जु मसी छे, बाकुन काहनाक कह्‌या, काहाकी मसी गलील जीलाम वाळु नी हय सके? ");
INSERT INTO bhi_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","काय चुखली-सास्‌तुर मां ज नी लिखलो आयो काय मसी दावुदेन कळी मां पयदा हवसे ने बेतलहम गांव सी आवसे जां दावुद रहतेलु।” ");
INSERT INTO bhi_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","असो करीन ईसुन बारामां माणसे मां बेरजु पड़ गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","तींद्‌रे मायन थुड़ाक माणसे ईसु काजे धरीन ली जाणे हींडी रवला बाकुन तीनाक धरीन ली जाणे करीन कुयन हिम्‌मत नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","तत्‌यार ईसुक धरने करीन गुयला मंदीरेन राखवाळ्‌या-सीपायड़ा मंदीरेन डाहला पुजारान्‌चां ने फरीसी माणसेन्‌चां पछा जाती रया। ती चे डाहला पुजारा ने फरीसी माणसे तीनुक कह्‌या, “तुहुं तीना ईसुक काहानी लाया?” ");
INSERT INTO bhi_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","मंदीरेन राखवाळ्‌या सीपायड़ा जपाप आप्‌या, “चु माणुस जसी वात करे तसी वात आज लग कुय नी कर्‌यो।” ");
INSERT INTO bhi_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","जी वात सामळीन फरीसी माणसे तीनुक जपाप आप्‌या, “काय चु तुहुंक बी भुले पाड़ देदु काय।” ");
INSERT INTO bhi_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","कुय बी यहुदी नेता ने फरीसी माणसे मायन कुय बी ईना ईसु पर भुरसु नी कर्‌या? ");
INSERT INTO bhi_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","बाकुन ईनु टुळाम माणसे काजे मुसा सी लिखली सास्‌तुर मालम नी हय, करीन जे ईसुन सामळीन भुले पड़ गुया। ने हींद्‌रे पर ते भगवानेन गरा छे। ");
INSERT INTO bhi_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","नीकुदेमुस चु पेहेल ईसु काजे भेळु हवणे गुयलु, चु तीनु फरीसी माणसे मायन एक हतलु। चु तीनु काजे कह्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","काहना बी माणुस काजे पुछीन तेरा गुनान पतु लागाड़े बीगुर जसों तसों तेरु नीयाव करीन तीनाक तु गुनाळु छे, कहीन डंड आपणु आपसा नीयम अनसारे संय छे काय? ");
INSERT INTO bhi_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","चे तीना नीकुदेमुस काजे जपाप आप्‌या, “तु बी गलील जीला वाळा पुठ्‌ये भेसकायलु छे? सास्‌तुर मां हेर ने भणीन देख तत्‌यार तुसेक मालुम पड़से की गलील जीलाम सी भगवानेन अघली वात बताड़न्‌यु माणुस उजेंतु हय्‌न आवण्‌यु नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ने तत्‌यार चे आखा आपणे-आपणे घर जाती र्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ने ईसु जेतुनेन बयड़ा पर जाती र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ने चु संदारे एगुत मंदीर मां गुयु। ने आखा माणसे ईसु धड़े आया; ने चु बठीन तीनुक सीकाड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","तीनी टेमे यहुदी-सास्‌तुर सीकाड़न्‌या ने फरीसी माणसे एक बायर काजे ईसु धड़े धरीन लाया, ची बायर काहनाक साते छीनाळो करतेली ने धर लेदला ने तीनी काजे माणसेन ईचमां उभी करीन ईसु काजे कह्‌या ");
INSERT INTO bhi_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","चे यहुदी सास्‌तुर सीकाड़न्‌या ने फरीसी माणसे ईसु सी कह्‌या, “ए मास्‌तर जी बायर छीनाळो करतेली धराय गुय। ");
INSERT INTO bhi_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","मुसु आपसा लिखला कायदान सास्‌तुर मां हामुक हुकुम आप्‌लु छे, की असली छीनाळी बायर काजे दगड़ा दीन मार नाखणु चाहजे। तेरेसी ईनी बायरीन बारामां तारो काय कहंणु पड़े?” ");
INSERT INTO bhi_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","चे ईसु काजे पारखणे करीन जी वात कह्‌या, तेरेसी तीनुक ईसु पर गुनु लागाड़नेन काहनुस पुरावु जड़ जाय करीन बाकुन ईसु ढंगु अळीन आंगळे करीन धुळा मां लिखतु रयु। ");
INSERT INTO bhi_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","जत्‌यार चे ईसुक पुछता रया ती ईसु उबु हय्‌न तीनुक कह्‌यु, “तुंद्‌रे मां जु कुय काय बी पाप नी कर्‌यु हय चु ईनी बायरीन आखाम सी पेहेल दगड़ु देणु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ने ईसु अळी ढंगु अळीन धरती पर लिखणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","बाकुन ज सामळीन डाहा-बुड़ा सी नानला लग आखान-आखा एकेक करीन जाती रया। ने चां ईसु ने ची बायरी रय गुया। ");
INSERT INTO bhi_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ईसु अळी उबु हय्‌न तीनी बायर काजे कह्‌यु, “ओ बायरी चे माणसे काहा जाती रया? तुसे कुय गुनाळी ठेहरावीन डंड नी आप्‌यो काय?” ");
INSERT INTO bhi_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ची बायर कय, “ए मालीक कुय बी मेसेक डंड नी आप्‌यो।” ईसु कह्‌यु, “जां मे बी तुसेक डंड नी आपतु जां ने हय सी अळी पाप घुण करजी।” ");
INSERT INTO bhi_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ने अळतेन मंदीर मां माणसे ईसु धड़े अळी भेळा हया, तत्‌यार ईसु तीनाक कह्‌यु, “मे कळीन माणसे वाटे वीजाळो मे छे। ज कुय मारु चेलु बणने करीन मारे पुठ्‌ये आवे चु अमर जीवन मां ली जाण्‌यो वीजाळो हात करसे अतरामा तीनाक पापेन आंदारला मां झटवायतु फीरनु नी पड़े।” ");
INSERT INTO bhi_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","फरीसी माणसे ईसुक कह्‌या, “तु आपसात बारामां आपसुत गवा दी र्‌यु। हेरेसी तारी गवाय खरली नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ईसु तीनुक जपाप आप्‌यु, “मेसेक मालुम छे, की मे कां सी आवलु छे ने कां जाणे बाजी र्‌यु। बाकुन तुहुं नी जाणता की मे कां सी आवलु छे ने कां जाणे बाजी र्‌यु। अतरामा कदी मे आपसुत मारा बारामां गवा दम; तेबी मारी गवाय खरली छे। ");
INSERT INTO bhi_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","तुहुं ईनी कळीन माणसेन डीलेन अनसारे नीयाव कर र्‌या, बाकुन मे कुय बी असु नीवाय नी करो; ");
INSERT INTO bhi_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ने कदी मे नीयाव करो बी, ते मारु नीयाव छाचलु छे, काहाकी मे एखलु नी हय बास बी छे, चु मेसेक मकेल्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","तुंद्‌रा कायदान सास्‌तुर मां बी लिखलो छे, की दुय जणान गवाय छाचली रवे। ");
INSERT INTO bhi_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","एक ते मे मारा बारामां गवाय दम ने मारु बास बी मारा बारामां गवाय देय चु मेसेक मकेल्‌लु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ज सामळीन चे ईसु काजे कह्‌या, “तारु बास कां छे।” ईसु जपाप आप्‌यु, “तुहुं मेसेक जाणु नी मारा बास काजे कदी मेसेक जाणु ती मारा बास काजे बी जाणु।” ");
INSERT INTO bhi_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ईसु मंदीर मां दान पेटी धड़े सीकाड़तु जाय्‌न जी आखी वात कह्‌यु, तेबी कुय बी ईसुक नी धर्‌या, काहाकी हय लग ईसुन मरने टेम नी आय, जी टेम भगवान नक्‌खी करलु। ");
INSERT INTO bhi_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ईसु अळी एक कावा माणसे काजे कह्‌यु, “मे जात रय्‌स, ने तुहुं मेसेक हेर्‌या करसु, बाकुन तुहुं तुंद्‌रा पापेन माफी हात कर्‌या बीगुर तुंद्‌रा पाप मां मर जासु। ने चां जात रय्‌स चां तुहुंक कदी नी आवाये।” ");
INSERT INTO bhi_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","जी वात सामळीन यहुदी माणसे कह्‌या, “जु असु काहा कय रयु, जां मे जात रय्‌स चां तुहुंक कदी नी आवाये हेरो ज कहंणेन मतलब काय छे? कांखुर मायन जु जाणी बुजीन मरने ते नी हींडी र्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ईसु तीनु काजे कह्‌यु, “तुहुं सरगे सी नेचा ईनी धरती वाळा छे; तुहुं कळीन छे, ने मे ईनी कळीम वाळु नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","तेरेमां मे तुहुंक कह्‌यु, की तुहुं तुंद्‌रा पाप मां मरसु काहाकी कदी तुहुं भुरसु नी करु की मे हयुत छे ती तुंद्‌रा पाप मां मरसु।” ");
INSERT INTO bhi_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ज सामळीन चे माणसे ईसुक कह्‌या, “तु कुण छे?” ईसु तीनुक कह्‌यु, “हयुत छे सुरु सी तुंद्‌रे सी कह्‌तु आय र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","तुंद्‌रा बारामां मेसेक बेसको काय नीयाव करनु छे। बाकुन मारु मकेलने वाळु छाचलु छे, ने ज मे तेरे सी सामळळु छे, चोन ईनी कळीन माणसे काजे सामळावो।” ");
INSERT INTO bhi_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ईसु ते तीनु काजे भगवान बासेन बारामां कहंणे बाजी रवलु, बाकुन ची वात तीनुक पल्‌ले नी पड़े। ");
INSERT INTO bhi_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","तत्‌यार ईसु कह्‌यु, “जत्‌यार तुहुं माणसेन पुर्‌या काजे ती जाणसु की मे हयुत छे; मे मारी मरजी सी काय बी नी कहो बाकुन जसु मारु बास मेसेक सीकाड़लु तसुत जी वात कहो। ");
INSERT INTO bhi_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","मेसेक मकेलने वाळु मारे पुठ्‌ये; चु मेसेक एखलु नी मकल्‌यु काहाकी मे जलम चत काम करो तीनाक गमे च।” ");
INSERT INTO bhi_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ईसु जी वात कहंणे बाजी रवलु, ती बेसका माणसे तेरे पर भुरसु करने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","जे यहुदी माणसे ईसु पर भुरसु कर्‌या, तीनुक कह्‌यु, “कदी तुहुं मारा बुल मांनीन रवसु, ती छाचलीन मारा चेला बण जासु। ");
INSERT INTO bhi_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","तुहुं छाचाय काजे जाण लेसु, ने छाचाय तुहुंक गुलामी मां सी छुड़ाय देसे।” ");
INSERT INTO bhi_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","चे ईसु काजे कह्‌या, “हामु ते अब्‌राहमेन अवल्‌यात छे, ने हामु कदी काहनान बी गुमाली नी कर्‌या। ती तु असु कसु कह्‌वे की छाचाय तुहुंक गुलामी मां सी छुड़ाय देसे।” ");
INSERT INTO bhi_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ईसु तीनु काजे कह्‌यु, “मे तुहुंक छाचलीन कहं, जु पाप करे चु पापेन गुलाम छे। ");
INSERT INTO bhi_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","एक घरेन पावर्‌यान बारामां वीच्‌यार करु। मालीकेन पावर्‌यु नी बाकुन मालीकेन खरलु बेटुस घरेन हकदार्‌यु छे, ने चु अतरुत घर मां जलम रय सके, ");
INSERT INTO bhi_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","हेरेसी कदी पुर्‌यु तुहुं काजे पापेम सी छुड़ावसे ती तुहुं छाचलीन पापेन गुलामी मां सी छुट जासु। ");
INSERT INTO bhi_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","मे जाणो की तुहुं अब्‌राहमेन अवल्‌यात छे; तेबी मारो बुल तुंद्‌रा डील मां जागु नी हेरे, तेरेमां तुहुं मेसेक मारने हींडी रया। ");
INSERT INTO bhi_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","तुहुं चत कय रया च मेसेक मारु बास देखलु, ने तुहुं च करु च तुंद्‌रा बास सी तुहुं सामळ्‌या।” ");
INSERT INTO bhi_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","चे ईसु काजे जपाप आप्‌या, “हामरु बास ते अब्‌राहम छे।” ईसु तीनुक कह्‌यु, “कदी तुहुं अब्‌राहमेन अवल्‌यात रवता ती चत काम करता च अब्‌राहम करलु। ");
INSERT INTO bhi_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","बाकुन हय तुहुं मारेन तसला माणसे काजे मारने हींडी रया, चु तुहुंक च खरलो बुल बताड़लु चु भगवान सी सामळ्‌या असो ते अब्‌राहम नी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","तुहुं ते खरला बासेन तसु नी, बाकुन तुंद्‌रा दीसरा बासेन तसु वेहवार कर रया।” चे ईसु काजे कह्‌या, “हामु छीनाळा सी पयदा नी हया; हामरु एकुत बास छे, ने चु भगवान छे।” ");
INSERT INTO bhi_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ईसु तीनु यहुदी माणसेक कह्‌यु, “भगवान तुंद्‌रु बास नी हय। कदी भगवान तुंद्‌रु बास रवतु, ती तुहुं मेसेक उळखीन परम करता काहाकी मे मारी मरजी सी नी आयु। बाकुन भगवान मेसेक मकेल्‌लु छे। करीन मे भगवान बासेम सी नीकाळीन आवलु छे, ने मे हय जां हजुर छे। ");
INSERT INTO bhi_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","तुहुं मारी वात काहा नी समजु? तेरेमां की तुहुं मारो बुल सामळी नी सकु। ");
INSERT INTO bhi_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","तुहुं आपसा बास भुतड़ा सी छे, ने आपसा बासेन मरजी काजे पुरी करने हींडी र्‌या। हयु ते पेहलुत सी हत्‌यारु छे, ने छाचलु बणीन नी रयु, काहाकी छाचाय तेरेमां हय नी। जत्‌यार हयु झुट बुले, ती आपसा हीयान मनेम सी बुले, काहाकी हयु झुटु अतरुत नी हय, बाकुन आखी भातीन झुटेन बास झुटु छे, ");
INSERT INTO bhi_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","बाकुन मे ज छाचलीन कह्‌वो, तुहुं माणसे मारे पर भुरसु नी करु। ");
INSERT INTO bhi_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","तुंद्‌रे मायन कुण मेसेक पापी कहें? काय कदी मे छाचलीन कहं, ती तुहुं मारु भुरसु काहा नी करु? ");
INSERT INTO bhi_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","जु भगवान भीणी सी छे, ने भगवानेन वात काजे सामळे। तेरेमां तुहुं मारी वात काजे नी मानु, तुहुं भगवान भीणी सी नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ईसुन वात सामळीन यहुदी माणसे रीसवायन ईसु काजे कह्‌या, “हामु ते छाचलीन कय र्‌या की, तु सामरी जातीन छे, ने तारे भुतड़ु चस्‌टी र्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ईसु तीनुक जपाप आप्‌यु, “मारे भुतड़ु नी चस्‌टी र्‌यु। बाकुन मे मारा बासेन अबरु राख र्‌यु ने तुहुं मारु अबरु ली रया। ");
INSERT INTO bhi_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","मेसेक मारी ईज्‌जत नी चाहजे, बाकुन एक जणु छे, चु मारु अबरु राखणेन हेर कर रयु, ने हयुत छाचलु नीयाव करन्‌यु छे। ");
INSERT INTO bhi_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","मे तुंद्‌रे सी छाचलीन कहं, ज कुय माणुस मारा बुल काजे मानीन चालसे चु कदी नी मरे।” ");
INSERT INTO bhi_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","जी वात सामळीन यहुदी माणसे ईसु काजे कह्‌या, “हय हामुक पक्‌को मालम पड़ गुयो की, तारे भुतड़ु चस्‌टी रयु। अब्‌राहम मर गुयु ने भगवानेन अघली वात बताड़न्‌यु मर गुयु, ने तु ज कय रयु की जु कुय मारा बुल काजे मानीन चालसे चु कदी नी मरे। ");
INSERT INTO bhi_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","हामरा डाहा बुड़ान बास अब्‌राहम ते मर गुयु, ने भगवानेन अघली वात बताड़न्‌या बी मर गुया, तु अब्‌राहम सी मटु छे काय? तु आपसा काजे काय समजी रयु? तु कुण छे?” ");
INSERT INTO bhi_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ईसु जपाप आप्‌यु, “कदी मे मारीत ईज्‌जत करो ती तीनी ईज्‌जतेन काय बी दाम नी रवे। बाकुन मारी ईज्‌जत करन्‌यु मारु बास छे तीनाक तुहुं कहुं की चु तुंद्‌रु भगवान छे। ");
INSERT INTO bhi_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","तुहुं ते तीनाक कदी नी उळख्‌या; ने कदी मे कहं की मे तीनाक कदी नी उळखो, ती ते मे तुंद्‌रेन तसु लुच्‌चु कहं; बाकुन मे तीनाक उळखो ने तेरा बुल पर चालो। ");
INSERT INTO bhi_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","तुंद्‌रु बास अब्‌राहम मेसेक देखणे करीन मारे आवणेन दाहड़ाम वाट देखीन खुस हय गुयलु; ने चु मेसेक देखी बी लेदु ने खुस हय गुयु।” ");
INSERT INTO bhi_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","जी वात सामळीन यहुदी माणसे ईसुक कह्‌या, “हय लगुन तारी उमर पचास साल बी नी हय ने तु असु कसु कय रयु की मे अब्‌राहम काजे देखलु छे?” ");
INSERT INTO bhi_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ईसु तीनुक कह्‌यु, “मे तुहुं काजे छाचलीन कहं अब्‌राहम पयदा नी हयु तेरे सी बी पेहलुन मेत छे।” ");
INSERT INTO bhi_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ज सामळीन यहुदी माणसे ईसुक मारने करीन दगड़ा ईछी लेदा बाकुन ईसु मंदीर मां सी कळेन जाती र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ईसु हेरा चेला भेळुत वाटे जाणे बाजी रवलु ती चु एक माणुस काजे देख्‌यु चु पयदा हयु ती सीत आंधळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ती ईसुन चेला ईसु काजे पुछ्‌या, “ए मास्‌तर कुण पाप कर्‌यु हसे ने जु आंधळु पयदा हयु। जु माणुस पाप कर्‌यु हसे की हेरा आयस-बास पाप कर्‌या हसे?” ");
INSERT INTO bhi_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ईसु जपाप आप्‌यु, “नी ते जु माणुस पाप कर्‌यु ने नी ते हेरा आयस-बास पाप कर्‌या बाकुन जु हेरेन करीन आंधळु पयदा हयु की ईनाक वारु करनेन सी हेरी जीवन मां भगवानेन ताकत देखाव पड़ जाय। ");
INSERT INTO bhi_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ने भगवान जु मेसेक मकेल्‌लु छे, आपणुक तेरो काम दीसुत पुरो कर लेणु वारु रवसे। बाकुन ची रात आवणे वाळी छे, तेरेमां कुयक काम नी कराये। ");
INSERT INTO bhi_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","जत्‌यार लग मे कळी मां छे तत्‌यार लग कळीन वीजाळो छे।” ");
INSERT INTO bhi_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ज कयदीन ईसु भुयमां थुप्‌यु ने हाते करीन धुळु कालवीन आंदळान डुळा पर चुपड़ी देदु। ");
INSERT INTO bhi_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ने तीना आंदळा काजे कह्‌यु, “जां सीलोम नावेन हळाव मां तारा डुळा धुय ले।” सीलोम नावेन मतलब छे मकेल्‌लु। अतरा मां चु आंधळु माणुस जाय्‌न तीना हळाव मां डुळा धुय लेदु ने जत्‌यार चु पछु आयु तत्‌यार देखणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ईना आंदळान आड़े-धड़े वाळा ने उळखायता माणसे चे पेहल ईनाक भीक मांगतेला देखला चे ईनाक हय देखीन कह्‌या, “काय जु चु नी हय जां बठीन पेहेल भीक मांगतेलु?” ");
INSERT INTO bhi_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","थुड़ाक माणसे कह्‌या, “जु हयुत छे। थुड़ाक माणसे कह्‌या जु चु आंधळु माणुस नी हय बाकुन तेरेन तसु देखाये।” बाकुन चु आंधळु माणुस कह्‌यु, “मे हयुत छे।” ");
INSERT INTO bhi_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ज सामळीन चे तीनाक पुछणे बाजी गुया, “ती तु कसु काय देखणे बाजी गुयु।” ");
INSERT INTO bhi_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","चु माणुस जपाप आप्‌यु, “ईसु नावेन माणुस थुपे करीन धुळु मारा डुळा पर चुपड़ी देदु। ने मेसेक कह्‌यु, सीलोम नावेन हळाव मां तारा डुळा धुय ले। ने मे जाय्‌न डुळा धुय लेदु ने मे देखणे बाजी गुयु।” ");
INSERT INTO bhi_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ज सामळीन चे तीनाक पुछ्‌या, “चु कां छे।” ने चु कह्‌यु, “काय जाणु।” ");
INSERT INTO bhi_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","वारु हय गुयला आंदळा माणुस काजे चां भेळा हवला माणसे फरीसी माणसे ने यहुदी माणसे धड़े लाया। ");
INSERT INTO bhi_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","तीने दाहड़े ईसु धुळु कालवीन तीना आंदळान डुळा वारु करलु चु दाहड़ु आरामेन दाहड़ु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","अतरामा फरीसी माणसे बी तीना माणसेक पुछणे बाजी गुया, “तु कसु काय देखणे बाजी गुयु।” चु तीनुक कह्‌यु, “ईसु नावेन माणुस धुळु कालवीन मारा डुळा पर चुपड़ी देदु। ने मे धुय लेदु ती पछेन देखणे बाजी गुयु।” ");
INSERT INTO bhi_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","जी वात सामळीन थुड़ाक फरीसी माणसे कह्‌या, “हीयु ईसु आरामेन दाहड़ु नी पाळतु। तेरेमां हीयु भगवानेन्‌चां सी नी आवलु हय।” ने जी वात सामळीन थुड़ाक फरीसी माणसे कह्‌या, “पापी माणुस असा वारु कामेन सहलाणी कसु देखाड़ सके?” अतरा मां ईसुन बारामां तींद्‌रे-तींद्‌रे मां वीरुद हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","एक कावा अळी तीना आंदळा काजे पुछ्‌या, “जु माणुस तारा डुळा वारु करलु छे, तेरा बारामां तु काय कहें?” ने चु माणुस कह्‌यु, “चु एक भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळु माणुस छे।” ");
INSERT INTO bhi_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","जु माणुस पेहेल आंधळु हतलु, चु माणुस हय देखणे बाजी गुयु ईनी वातेम तीनु यहुदी मुख्‌या काजे भुरसु नी आयु ने चे तीना माणसेन आस्‌या-बास्‌या काजे बुलाया। ");
INSERT INTO bhi_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ने तीनुक पुछ्‌या, “जु तुंद्‌रु पुर्‌यु छे काय? जु पयदा हयु तीन आंधळु हतलु काय? ‘आंधळु हतलु’ कहुं ती हय जु कसु देखणे बाजी गुयु?” ");
INSERT INTO bhi_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","चे आस्‌या-बास्‌या जपाप आप्‌या, “हामु जाणजे की हामरु पुर्‌यु छे, ने जु पयदा हयु तीन आंधळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","बाकुन हय जु कसु देखणे बाजी गुयु जी वात हामुक मालम नी हय। हामुक ज बी नी मालम हय की हेरा डुळा कुण वारु कर्‌यो ईनात काजे पुछ लेवु। जु नानलु नी हय आपसान बारामां खुद बताड़ देसे।” ");
INSERT INTO bhi_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","यहुदी डाहला भेळा हय्‌न जी वात नक्‌खी कर लेदला की कुय बी ईसु काजे मसी करीन मान लेसे ती आपणा भक्‌तीन घर मां सी बाहर नीकाळीन बाहरु कर देसुन। ने तीनाक वारु हय गुयला आंदळान आस्‌या-बास्‌या मन मां यहुदी मुख्‌यान धाक भराय गुयली। ");
INSERT INTO bhi_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","तेरेमां तेरा आस्‌या-बास्‌या कहला की, “जु मटु हय गुयु ईनात काजे पुछ लेवु।” ");
INSERT INTO bhi_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","चे यहुदी मुख्‌यान तीना वारु हय गुयला आंदळाक अळी बुलाया ने तीनाक कह्‌या, “भगवानेन आण घालीन कहं की मे तीना भगवानेन बड़ाय करीस। हामु जाणजे की चु माणुस पापी छे।” ");
INSERT INTO bhi_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","चु जपाप आप्‌यु, “चु माणुस पापी हय की नी हय जी वात मेसेक मालम नी हय बाकुन मे अतरोत जाणो की मे आंधळु हतलु ने हय मे देखो।” ");
INSERT INTO bhi_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ने चे तीनाक अळी पुछ्‌या चु तारे काय कर्‌यु? “चु तारा डुळाक कसु वारु कर्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","चु कह्‌यु, “मे तुहुं काजे पेहलुत कय देदु तेबी तुहुंक भुरसु नी आवतु, ती हय अळी काहा सामळने हींडी र्‌या? तुहुं बी तेरा चेला बणने हींड र्‌या काय?” ");
INSERT INTO bhi_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","चे तीनाक बेसका लड़ीन कह्‌या, “तुत छे तेरु चेलु बाकुन हामु ते मुसान चेला छे। ");
INSERT INTO bhi_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","हामु जाणजे की भगवान मुसा साते वात करलु बाकुन तीना ईसुन बारामां हामु जाणजे लग नी, की चु कां सी आवलु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","चु वारु हय गुयलु माणुस तीनाक कह्‌यु, “जो! तुहुंक पल्‌ले नी पड़तो काय चु आंदळान डुळाक वारु कर देदु तेबी तुहुंक मालम नी हय की चु कां सी आवलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","आपणु जाणजे की भगवान पापी माणसेन दुवा नी सामळे बाकुन तीना माणसेन दुवा सामळे जु भगवानेन भक्‌ती करतु हय ने भगवानेन मरजी पर जीवन जीवे। ");
INSERT INTO bhi_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","कळी घड़ाय तीसी आज लग ज सामळने मां नी आयो की काहनु बी आंधळु पयदा वारी माणसेन डुळा उघाड़ीन वारु कर्‌यु हय। ");
INSERT INTO bhi_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","कदी भगवान ईना माणसेक नी मकेलतु ती चु कसु मारा आंदळा डुळा उघाड़तु।” ");
INSERT INTO bhi_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","चे यहुदी मुख्‌या वारु हय गुयला आंदळाक कह्‌या तुते पाप मां पयदा हयु ने पापेत मां पुसायु, “ने बेसकु! तु हामुक सीकाड़ने बाजी र्‌यु!” ने असु कहीन चे तीनाक तींद्‌रा घर मां सी खयड़े नीकाळ दीन बाहर कर देदा। ");
INSERT INTO bhi_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","अळतेन ईसु सामळ्‌यु की फरीसी माणसे यहुदी मुख्‌या तीनाक चां बाहर कर देदला छे, ने अळतेन ईसु तीनाक भेळु हयु ती तीनाक कह्‌यु, “तु माणसेन पुर्‌या पर भुरसु करे काय?” ");
INSERT INTO bhi_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","चु वारु हय गुयलु आंधळु माणुस कह्‌यु, “ए मालीक! मेसेक देखाड़ दे की माणसेन पुर्‌यु कुण छे, ने मे तेरे पर भुरसु करीस।” ");
INSERT INTO bhi_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ईसु तीना माणसेक कह्‌यु तु तीनाक देखलु छे, “ने चु तार साते वात करने बाजी र्‌यु ने हयुत माणसेन पुर्‌यु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","चु वारु हय गुयलु आंधळु ईसु काजे कह्‌यु ए मालीक! मे भुरसु कर्‌यु ने चु ईसुन पाये पड़ीन आंध्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ने ईसु कह्‌यु, “मे ईनी कळी मां नीयाव करने वाळु छे की जे आंदळा छे चे देखणे बाजी जाय बाकुन जे देखणे बाजी र्‌या चे आंदळा हय जाय।” ");
INSERT INTO bhi_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","फरीसी माणसे मुख्‌या मायन थुड़ाक चां ईसु साते हतला ने चे ज सामळीन ईसु काजे कह्‌या, “छाचलीन हामु आंदळा नी हय। हामु बी आंदळा छे करीन तु कय र्‌यु काय?” ");
INSERT INTO bhi_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ईसु तीनु काजे कह्‌यु, “कदी तुहुं छाचलीन आंदळा रवता ती पापी नी गीणायता बाकुन हय ते तुहुं कय र्‌या की हामु देखजे ने तुहुं पापीत गीणाय र्‌या।” ");
INSERT INTO bhi_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ईसु कह्‌यु, “मे तुहुं काजे छाची-छाची कहं, की जु काहनुक गाडरान ईना वाड़ान झपला मायन गाडरान वाड़ा मां नी भराये, बाकुन गाडरान वाड़ो चहड़ीन एक धड़े मायन भराये, चु चुट्‌टु ने डाकु छे। ");
INSERT INTO bhi_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","बाकुन जु गाडरान वाड़ान झपले मायन भराये, चु गाडरा गुवाळ्‌यु छे। ");
INSERT INTO bhi_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ने तेरे भीणी गाडरान वाड़ान झपले राखवाळी करन्‌यु झपलु उघाड़ देय। ने गाडरा तीना गाडरा गुवाळ्‌यान बुली सामळी लेय, ने चु आपसा एक-एक गाडरान नाव धरीन बुलावे, ने आपसा गाडराक खयड़े चारने ली जाती रहे। ");
INSERT INTO bhi_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ने जत्‌यार चु आपसा आखा गाडरा काजे खयड़े ली जाय, ती चु तींद्‌रे अगळ-अगळ चाले, ने चे गाडरा आपसा मालीकेन बुली समजी जाय, ने तेरे पछळ-पछळ आवे। ");
INSERT INTO bhi_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","बाकुन कदी अंजाण्‌यु माणुस आयड़े ती चे गाडरा राखवाळ्‌यान अंजाणी बुली काजे नी उळखे, ने तेरे पछळ-पछळ नी जाय बाकुन तीनाक देखीन छेटा डास जासे।” ");
INSERT INTO bhi_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ईसु तीनुक जी वात दाखलु दीन कह्‌यु, बाकुन तीनुक तीना दाखलान मतलब समजायो नी। ");
INSERT INTO bhi_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","तत्‌यार ईसु तीनुक अळी कह्‌यु, मे तुहुंक छाची-छाची कह्‌वो, गाडरान झपलु मेत छे। ");
INSERT INTO bhi_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","जतरा मारे सी पेहेल आया चे आखा चुट्‌टा ने डाकु छे, बाकुन गाडरा तेरी नी सामळ्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","झपलु मे छे, कदी काहनुक मारे मायन माहीं आवे, ती मे राखवाळी करीस, ने बाहर आवता जाता रवसे ने चारु जड़से। ");
INSERT INTO bhi_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","चुट्‌टु काहनुक दीसरा काम आटे नी आवे, बाकुन चुरी करने अतरुत आवे, ने मारने ने खत्‌तम करने आवे, बाकुन मे असु करीन आयु की हीनुक नवलो जीवन जड़े ने पुरो की पुरो जड़े। ");
INSERT INTO bhi_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","वारलु गुवाळ्‌यु मे छे! वारलु गुवाळ्‌यु गाडरा आटे आपसान जीव दी देय। ");
INSERT INTO bhi_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","बाकुन दाहड़क्‌यु नीते गुवाळ्‌यु हय, ती गाडरान मालीक छे, लेंड्‌या काजे आवता देखीन गाडरा काजे छुड़दीन ढासी जाय, ने लेंड्‌या तीनुक धरे ने रावण्‌या-तीवण्‌या कर देय। ");
INSERT INTO bhi_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","दाहड़क्‌यु असु करीन ढासी जाय की चु पावर्‌यु छे, ने तेरी गाडरान फीकुर नी करे। ");
INSERT INTO bhi_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","वारलु गुवाळ्‌यु मे छे, मे मारा गाडरा काजे उळखो ने मारा गाडरा मेसेक उळखे। ");
INSERT INTO bhi_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","जसु बास मेसेक उळखे ने मे बासेक उळखो ने मे गाडरा आटे मारु जीव दी दम। ");
INSERT INTO bhi_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","मारा अळी बी गाडरा छे, चे ईना गाडरान वाड़ा मां नी हय। मेसे तीनुक बी लावणुत छे, चे मारी बुली सामळसे, तत्‌यार एकुत टुळु ने एकुत गुवाळ्‌यु रवसे। ");
INSERT INTO bhi_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","बास असु करीन मारे सी परम राखे की मे मारु जीव दी दम, काहाकी तीना जीवेक पछु मांगणेन बी हक छे। ");
INSERT INTO bhi_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","बाकुन मे मारी मरजी सी दम, ने मेसे तीनाक देणेन बी हक छे, ने तीनाक अळी पछु लेणेन बी हक छे, जी हुकुम मारा बास सी मेसेक जड़ी। ");
INSERT INTO bhi_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ईसुन जी वात सामळीन, यहुदी माणसेम अळी लड़ाय हय गुय। ");
INSERT INTO bhi_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","तींद्‌रे मायन बेसका माणसे कवतेला, “हेरे भुतड़ा लागला छे, तुहुं हेरी काहा सामळु।” ");
INSERT INTO bhi_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","बाकुन दीसरा माणसे कहतेला, “जी वात भुतड़ा लागला माणसेन नी हय, काहाकी भुत आंदळान डुळाक वारु कर सके काय?” ");
INSERT INTO bhi_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","यरुसलेम मंदीर काजे भगवानेन हातेम सुपणेन तीहवार आयु। तीनु दाहड़ाम सींव पड़ रवली। ");
INSERT INTO bhi_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ईसु मंदीर मां सुलेमान नावेन आंगणा मां हींडतेलु। ");
INSERT INTO bhi_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","तत्‌यार यहुदी नेता ईसुक घेर लेदा, ने कह्‌या, “तु हामरा मन काजे कां लगुन भुले पाड़तु रवसी? कदी तु मसी हय ती हामुक तसु छाची बताड़ दे?” ");
INSERT INTO bhi_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ईसु तीनुक जपाप आप्‌यु, “मे तुहुंक छाचलीन कय देदु की, मे कुण छे। बाकुन तुहुं भुरसु नी करता, ज काम मे मारा बासेन नाव सी करो, मारी गवा पुरावु देय की मे छाचलीन कुण छे? ");
INSERT INTO bhi_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","तेबी तुहुं भुरसु नी करता, काहाकी तुहुं मारा गाडरा नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","मारा गाडरा मतलब मारा चेला, मारी बुली काजे जाणी लेय, ने मे तीनुक जाणो, ने मारे पछळ-पछळ आवे। ");
INSERT INTO bhi_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ने मे तीनुक अमर जीवन आपो, ने हयु जीव कदी नी मरसे। ने कुय बी तीनाक मार हातेम सी नी हापके। ");
INSERT INTO bhi_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","मारु बास, चु तीनुक मेसेक आप्‌यु, आखा सी मटु छे, ने कुय बी तीनुक बासेन हातेम सी हापकी नी सके। ");
INSERT INTO bhi_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","मे ने मारु भगवान बास एक छे।” ");
INSERT INTO bhi_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ईसुन जी वात सामळीन, यहुदी माणसे ईसु काजे मारने करीन अळी दगड़ा ईछ्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ती ईसु तीनु काजे जपाप आप्‌यु, “मे मारा भगवान बासेन कह्‌याम तुहुंक बेसका मटा वारलु काम करीन देखाड़्‌यु। तीनु मायन काहना कामेन करीन मेसेक दगड़ाटीन मारने हींडी र्‌या?” ");
INSERT INTO bhi_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","तत्‌यार यहुदी माणसे जपाप आप्‌या, “काहना बी वारलु कामेन करीन नी, बाकुन तु भगवानेन नाव-बद्‌दी कर र्‌यु करीन हामु तुसेक दगड़ाटीन मारने हींडी र्‌या, तु ते माणुस हय्‌न बी खुद काजे ‘मे भगवान छे’ करीन कय र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ईसु तीनुक जपाप आप्‌यु, “तीना चुखला सास्‌तुर काजे तुहुं मानु, तेरेमां असो लिखलो छे भगवान कह्‌यु, तुहुं देवता छे” तुहुंक जी वात मालम नी हय काय। ");
INSERT INTO bhi_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","पेहला वाराम तीनु माणसेन्‌चां आपसु बुल पुगाड़लु, तीनु काजे भगवान देवता करीन बुलाड़्‌यु। ने खरली सास्‌तुर मां लिखली वात कदी नी टळे। ");
INSERT INTO bhi_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","बाकुन मेसेक ते चुखलु भगवान बास हक आपीन ईनी कळी मां मकेल्‌लु छे, ने मे भगवानेन पुर्‌यु छे करीन मे मारा बारामां कह्‌यु, ती तुहुं रीसवायन मेसेक तु भगवानेन नाव-बद्‌दी कर र्‌यु, करीन काहा कय र्‌या? ");
INSERT INTO bhi_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","कदी मे मारा बासेन काम नी करो ती मारे पर भुरसु घुण करु। ");
INSERT INTO bhi_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","बाकुन कदी मे भुरसु करो, ती भले मारे पर भुरसु मां करु, बाकुन तीनु कामे पर ते भुरसु करु, काहाकी तुहुं जाणु ने समजु की बास मारेम छे, ने मे बासेम छे। ");
INSERT INTO bhi_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","जी वात सामळीन, यहुदी माणसे, अळी ईसु काजे धरने हींडी रवला, बाकुन चु तींद्‌रा हातेम सी नीस्‌टीन जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ईसु आपसा चेला पुठ्‌ये अळी यरदन नदीन पली धड़े जागा पर जाती र्‌यु, चां युहन्‌‌‌नु पेहेल बपतीस्‌मा आप्‌या करतेलु, ने चाहात रहणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","बेसका माणसे ईसु धड़े आवीन कहतेला, “युहन्‌‌‌नु ते असो काहना बी मटा कामेन सहलाणी नी देखाड़्‌यु, बाकुन युहन्‌‌‌नु ईसुन बारामां ज काय हवलो, चो आखो छाचलीन हतलो।” ");
INSERT INTO bhi_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ने चां बेसका माणसे ईसु पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","बेतन्‌या गांव मां तीन भाय बहणस्‌या रहतेला, लाजर ने तेरे दुय बहणीस मारथा ने मरीयम, एक दाहड़े हेरु भाय लाजर मांदु पड़ गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","जी चीत मरीयम हतली, ची मालीक ईसुन पाये पर ईत्‌तर रेचवीन आपसे कान्‌या सी तेरा पाये नुछली हेरुत भाय लाजर मांदलु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","तेरेमां मरीयम ने मार्‌था लाजरेन बहणीस ईसु धड़े असी कय मकली की, “ए मालीक, देख, तीनाक तु वारु परम राखे चु मांदलु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ईसु जी वात सामळीन कह्‌यु, “जी मांदवाड़ मर जाणु करीन नी आय, बाकुन भगवानेन बड़ाय हवणे करीन, ने ईनी मांदवाड़ेन साहरे भगवानेन पुर्‌यान बी बड़ाय हवे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ईसु लाजर काजे, ने तेरी बहणीस मारथा ने मरीयम काजे परम करतेलु। ");
INSERT INTO bhi_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","तेबी जत्‌यार ईसु सामळ्‌यु, की लाजर मांदलु छे, ती जां लाजर रहतेलु चां जाणी बुजीन दुय दाहड़ा अळी रय गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","जी दुय दाहड़ा बीती गुया, ने पछेन ईसु चेला काजे कह्‌यु, “चालु आपणु अळी पछा यहुदी जीलाम जाजे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","बाकुन चेला ईसु काजे कह्‌या, “ए मास्‌तर! ईतराक दाहड़ा पेहलुस ते यहुदी डाहला नेता तुसेक दगड़ाटीन मारने हींडी रवला, ने तु पछु अळी चांहान जाणे हींडी र्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ईसु जपाप आप्‌यु, “काय दाहड़ान बारे घंटा नी रवे? कदी काहनुक माणुस दीसु चाले ती झट नी लागे काहाकी तीनाक ईनी कळीन वीजाळो देखाये। ");
INSERT INTO bhi_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","बाकुन कदी काहनुक राते चाले ती झटवायसे, काहाकी चां वीजाळो नी रहे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ईसु जी वात कह्‌यु, ने पछेन कहणे बाजी गुयु, “आपणु दुस्‌तीदार लाजर सुय गुयु, बाकुन मे हीनाक जागाड़ने जाम।” ");
INSERT INTO bhi_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","चेला कह्‌या, “ए मालीक। कदी चु सुय रयु हसे, ती वारु हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ईसुन चेला ज्‌य समज्‌या की लाजर छाचलीन सुवणे बाजी रयु हसे, बाकुन ईसु ते दाखलान साहरे ईसारु करीन कहणे बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तत्‌यार ईसु तीनुक सय-सय कय देदु, “की लाजर मर गुयु।” ");
INSERT INTO bhi_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","मे लाजरेन मरने टेमे चां नी हतलु, तेबी मे तुहुं छे करीन मे खुस छे, “काहाकी हय तुहुं मारे पर पाक्‌कु भुरसु करने मुखु जड़ जासे। ती चालु, आपणु लाजर धड़े जाजे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तत्‌यार थोमु चु दीद्‌मुस बी कह्‌वाये, हेरे साते चेला सी कह्‌यु, “चालु, आपणु बी हेरे साते जाजे भले आपणुक बी हेरे पुठ्‌ये मरनु पड़े।” ");
INSERT INTO bhi_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","जत्‌यार ईसु बेतन्‌या गांव मां पुग्‌यु, ती चु सामळ्‌यु की लाजर काजे मसाण मां मेकला चार दाहड़ा हय गुया। ");
INSERT INTO bhi_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बेतन्‌या गांव यरुसलेम सहर सी एक कुस लांबो हतलो। ");
INSERT INTO bhi_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ने बेसका यहुदी माणसे बी लाजरेन मरनेन खबर सामळीन हेरी बहणीस मारथा ने मरीयम काजे हुगा राखणे, ने तुहुं काठु जीव राख्‌जु करीन हेरा भायसेन बारामां कहंणे चां आय रवला। ");
INSERT INTO bhi_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","जत्‌यार मारथा सामळी, की ईसु आवणे बाजी र्‌यु, तीनाक भेळी हवणे करीन अघीस गुय बाकुन मरीयम घरुत मां बस रय। ");
INSERT INTO bhi_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ईसु धड़े पुगीन मारथा ईसु काजे कय, “ए मालीक! कदी तु जां रहतु ती मारु भाय नी मरतु। ");
INSERT INTO bhi_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ने मेसेक मालम छे, की तु हय बी भगवान भीणी सी ज काय मांगीस, चोन भगवान तुसेक आपसे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ईसु मारथा काजे कह्‌यु, “तारु भाय पछु जीवतु हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ज सामळीन मारथा ईसु काजे कय, “मेसेक मालुम छे, की तीने दाहड़े आखा मरला माणसे मर्‌या-सर्‌याम सी पछा जीवता हय्‌न बठा हवसे, तीने दाहड़े मारु भाय बी तींद्‌रे भेलुत पछु जीवतु हय्‌न बठु हय जासे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ईसु मारथा काजे कह्‌यु, “मर्‌या-सर्‌याम सी पछा जीवता करीन बठा करन्‌यु, ने तीनुक अमर जीवाय आपण्‌यु मेत छे, जु बी मार पर भुरसु करे, चु मर बी जासे तेबी जीवतेलु रवसे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ने जु मार पर भुरसु करतु जाय्‌न जीवतेलु रवसे, तीनाक जलमकी मुतेन डंड नी जड़े तु ईनी वात पर भुरसु करे काय? ");
INSERT INTO bhi_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ती मारथा कय, “हव, मालीक! पाक्‌कु भुरसु करो की ईनी कळी मां आवणे वाळु भगवानेन पुर्‌यु तीनाक मसी कहवे चु तुत छे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ची असी कयदीन जाती रय ने आपसी बहणीस मरीयम काजे बुलावीन कळ्‌येन तीनीक कय, “मास्‌तर आय रयु, चु तुसेक बुलावे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ज सामळीन मरीयम छाटीत उठीन ईसु काजे भेळी हवणे चाल पड़ी। ");
INSERT INTO bhi_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ईसु हाल लगुन तीना गांव मां नी आयु, हय बी चु तीना जागा पर हतलु जां मारथा ईसुक भेळी हवली। ");
INSERT INTO bhi_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","तत्‌यार ईतराक यहुदी माणसे हेरे साते घर मां हतला ने तीनाक हुगी रव ने काठु जीव राख, करीन कह्‌णे बाजी रवला, चे माणसे ज देख्‌या की ची उचकाणुन मरीयम उठीन खयड़े चाल पड़ी ती चे असा वीच्‌यार कर्‌या की जी मसाण पर रहणे जाणे बाजी रय, ने चे बी तेरे पछळ चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","जत्‌यार मरीयम ती जागे पुगी जां ईसु हतलु, ती तीनाक देखतात ची तेरा पायेम हीट पड़ी ने कय ए मालीक! “कदी तु जां रवतु ती मारु भायस नी मरतु।” ");
INSERT INTO bhi_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ने ईसु मरीयम काजे ने तेरे पुठ्‌ये आवला यहुदी माणसेक रड़तेला देख्‌यु, ती ईसुन जीव भळ कर्‌यु, ने चु बेसकु दुखी हय गुई। ");
INSERT INTO bhi_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ने चु कह्‌यु, “तीनाक काहना जागा पर मेकला छे?” चे ईसुक कह्‌या, ए मालीक! चाल आवीन देख ले। ");
INSERT INTO bhi_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ने ईसु तत्‌यार कलपी-कलपीन रड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ईसु काजे रड़तेलु देखीन चां भेळा हवला माणसेम सी बेसका यहुदी माणसे कह्‌या, “देखु! जु ते लाजर काजे बेसकु परम करतेलु।” ");
INSERT INTO bhi_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","बाकुन थुड़ाक माणसे कह्‌या, “जु ते आंदळान डुळा उघाड़ीन तीनाक देखता कर्‌यु ती जु लाजर काजे काहानी बचाड़्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ज सामळीन ईसुन जीव अळी भळ लेवायु, ने चु लाजरेन मसाण धड़े गुयु, ची मसाण बयड़ान खंगरा मां दर खुदीन बणावलो हतलो, ने तेरे पर एक चापरु दगड़ु मेल्‌लु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ईसु माणसेक कह्‌यु, “चापरु दगड़ु हेड़ देवु।” मरला लाजरेन बहणीस मारथा कही, “बाकुन ए मालीक लाजर मरलु चार दाहड़ा हय गुया हय ते तेरो धड़ गंदायतो हसे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ईसु मारथाक कह्‌यु, “कदी तु भुरसु करसी, ती भगवानेन सेक-सींगार देखसी, असु मे तुसेक हय पेहलुस कह्‌लु बी।” ");
INSERT INTO bhi_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तत्‌यार चे माणसे चापरु दगड़ु हेड़ देदा ने ईसु सरग भीणी भाळीन कह्‌यु, ए भगवान बास! मे तुसेक बेसकु वारु कह्‌वो तु मारी दुवा सामळी लेदु। ");
INSERT INTO bhi_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","तु ते मारी दुवा सामळ्‌या करे जी वात मेसेक पाक्‌को मालुम छे बाकुन मे जी वात आड़े-धड़े उबा हय रवला माणसे वाटे कय र्‌यु, “काहाकी चे ज देखीन भुरसु करे ने असा जाणे की ईना ईसुक भगवानुत हक आपीन मकेल्‌लु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","असु कयदीन ईसु जुर सी आयड़ीन कह्‌यु, “लाजर! बाहर नीकळ। ");
INSERT INTO bhi_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","चु मरलु लाजर जीवतु हय्‌न बाहर नीकळी आयु, तेरे मुंहडे ने हाते पाये पुथल्‌यान पाटा बांदला हतला, ईसु माणसेक असु कह्‌यु, हेरा पाटा छुड़ीन हीनाक जाणी देवु।” ");
INSERT INTO bhi_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","जे यहुदी माणसे, मरीयम काजे भेळा हवणे आवला हतला, चे ईसुन बेसका मटा काम देख्‌या, ने तीनु मायन बेसका माणसे ईसु पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","बाकुन तीनु यहुदी माणसे मायन थुड़ाक जणा जाय्‌न फरीसी माणसे काजे ईसुन ईना मटला कामेन बारामां कय देदा। ");
INSERT INTO bhi_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ने मंदीरेन डाहला पुजारा ने फरीसी माणसे पंचु बठ्‌या ने कह्‌या, “आपणु काय करजे? हयु माणुस ते मटा कामेन सहलाणी देखाड़ने बाजी र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","कदी आपणु हीनाक असुत करने देसुन ती हेरे पर आखा यहुदी माणसे भुरसु करने बाजी जासे, ने ईना काजे राजा बणाय देसे, तत्‌यार रोमी सीपायड़ा आवीन आपणु मंदीर ने आपणी आखी जाती काजे सार देसे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","तींद्‌रे मायन एक जणु तेरो नाव काइफा हतलो, ने चु तीने साल मंदीरेन डाहला पुजारान मुख्‌यु हतलु चु पंचुन वात सामळीन तीनु काजे कह्‌यु, “तुहुंक ईतरोक बी मालुम नी हय काय? ");
INSERT INTO bhi_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","जाराक वीच्‌यार ते करु आपणा माणसे वाटे एकुत माणुस मरसे ती आपणी आखी जाती बच जासे, आपणे वाटे च वारलु रवसे।” ");
INSERT INTO bhi_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","चु जी वात आपसुत नी कह्‌यु, बाकुन चु तीने साल मंदीरेन डाहला पुजारान मुखी हवणेन नाते पेहेल सी हवणे वाळी वात कह्‌यु की ईसु भगवान आखा माणसे वाटे मरसे। ");
INSERT INTO bhi_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","हेरो मतलब ज छे की ईसु यहुदी जाती वाटे अतरुत नी बाकुन, रावण्‌या-तीवण्‌या हवला भगवानेन आखा पुर्‌या-पारी तीनुक भेळा करने करीन मरसे। ");
INSERT INTO bhi_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","तीनेत दाहड़े सी यहुदी पंचु वाळा मुख्‌या ईसु काजे मारने करीन पाक्‌कु वीच्‌यार कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ज जाणीन ईसु तीने दाहड़े सी यहुदीया जीलान माणसे मां उजेंतु नी हवणे चाहतेलु, बाकुन यहुदीया जीलान यरुसलेम सहर छुड़ीन उजाड़्‌या बयड़ा धड़े वाळा येफरेन नावेन सहरेम जाय्‌न चेला पुठ्‌ये रहणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","यहुदी जातीन फसह तीहवार धड़ेत आय रवलु, ने तीना तीहवारेन पेहलुत आपसा काजे चुखा करने करीन बेसका माणसे गांव खेड़ाम सी यरुसलेम सहर मां आय रवला। ");
INSERT INTO bhi_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ने चे ईसु काजे हेरता-हेरता यरुसलेम मंदीरेन्‌चां उबा रय गुया, ने ईसु नी जड़्‌यु, ती चे एक दीसराक कहणे बाजी गुया, “तुंद्‌रु काय वीच्‌यार छे, चु तीहवार मां नी आवे काय?” ");
INSERT INTO bhi_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","मंदीरेन डाहला पुजारा ने फरीसी माणसे काजे पेहलुत हुकुम आपीन ज कह्‌या, की तुंद्‌रे मायन कुय बी ईसुन बारामां मालुम हवे, की ईसु जां छे, ती आवीन कय देजु ने हामु तीनाक धराय देसु। ");
INSERT INTO bhi_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ईसु तीहवारेन छव दाहड़ा पेहेल यरुसलेम सहर धड़े, बेतन्‌या गांव मां गुयु, चां लाजर रहतेलु, तीनाक ईसु मर्‌या-सर्‌याम सी जीवतु करलु। ");
INSERT INTO bhi_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ने तींद्‌रे मायन एक घर मां ईसुन मेजवानी कर्‌या ने लाजर बी चां खाणे बठी रवलु, ने मारथा चां वारती बणीन खावड़ातेली। ");
INSERT INTO bhi_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","तत्‌यार मरीयम आदु लीटर बेसको महंगलो ईत्‌तर लावीन ईसुन पाये पर रेचवी ने आपसे कान्‌या सी तेरा पाये नुछी, ने ईत्‌तरेन गंदे आखो घर गंदणु ईस्‌ट्‌यो च ईत्‌तर एक खास झाड़कान मुळेम सी नीकाळीन बणावलो पीवर ईत्‌तर हतलो। ");
INSERT INTO bhi_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ज देखीन ईसुन एक चेलु, यहुदा ईस्‌करीयोती चु ईसुक धराड़ने वाळु हतलु, चु कह्‌णे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“च ईत्‌तर वेचती ती तीन सोव दाहड़ान दाहड़कीन पयस्‌या जड़ जाता, ने चे पयस्‌या बेसका गरीबेक आपीन मदत कर देणु हतलो।” ");
INSERT INTO bhi_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","तीनाक गरीबेन फीकुर हतली, चु जी वात नी कह्‌यु, बाकुन चु चुट्‌टु हतलु। चु ते तींद्‌री पयस्‌यान थयलिन राखवाळी करन्‌यु हतलु, तेबी चु तीनी थयलिम सी ईत्‌तराक पयस्‌या चुरी कर लेदलु। ");
INSERT INTO bhi_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ईसु तीनाक कह्‌यु, “हीनीक रहणी देवु! काय मां कहुं हयी ते मारे डागेन तीयारी पेहेलुत सी करने बाजी रय। ");
INSERT INTO bhi_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","काहाकी गरीब ते तुंद्‌रे पुठ्‌ये जलम लग रवसे बाकुन मे तुंद्‌रे पुठ्‌ये जलम लग नी रहो।” ");
INSERT INTO bhi_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","जत्‌यार यहुदी बेसका माणसे काजे मालुम हय गुयो की ईसु बेतन्‌या मां आयु, ती चे ईसु छे करीन अतरात नी आया बाकुन बेसकास ते लाजर काजे देखणे आया, तीनाक ईसु मरलाम सी पछु जीवतु करलु। ");
INSERT INTO bhi_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","तत्‌यार डाहला पुजारा लाजर काजे बी मारनेन मुजगी कर लेदला। ");
INSERT INTO bhi_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","काहाकी ईसु ईना कामे सी बेसका यहुदी माणसे तीनु यहुदी डाहला पुजाराक छुड़ देदला ने ईसु पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","दीसरे दाहड़े तीहवार वाळने आवला माणसेन मट्‌लु टुळु, असा सामळ्‌या की ईसु यरुसलेम मां आवणे बाजी र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ने चे माणसे खजुरेन डाळ्‌या लीन तीनाक भेळा हवणे गुया, ने आयड़ी-आयड़ीन कह्‌या, होसान्‌ना! बेसकु वारु छे, ईस्‌रायलेन राजु, जे मालीक भगवानेन नाव सी आवे! ");
INSERT INTO bhi_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","बाकुन ईसु काजे गदड़ीन एक पीलो जड़्‌यो, ती चु तेरे पर बठी गुयु, जसों की खरला सास्‌तुर मां लिखलो छे, ");
INSERT INTO bhi_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“सीयोन सहर मां रहण्‌या माणसेन टुळा” बीहे मां! देख, तारु राजा तुंद्‌रेन्‌चां आवणे बाजी र्‌यु, चु ते गदड़ीन पीला पर बठीन आवणे बाजी र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ईसुन चेलाक पेहेल मेहेल ते जी वात पल्‌ले नी पड़ी, बाकुन जत्‌यार ईसु मर्‌या-सर्‌याम सी जीवतु हय्‌न पछु सरगेन आपसा सेक-सींगार मां जाती र्‌यु, ती तीनुक पल्‌ले पड़ी की ईसुन बारामां असोत लिखलो हतलो ने तसा की तसा माणसे तीने दाहड़े तेरे साते वेहवार करला। ");
INSERT INTO bhi_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","तत्‌यार टुळा मायन चे माणसे गवा देदा, चे तीने टेमे हेरे साते हतला, जत्‌यार हयु लाजर काजे मसाण मां सी बुलायन मर्‌या-सर्‌याम सी पछु जीवतु करलु। ");
INSERT INTO bhi_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","तेरेमां माणसे हीनाक मेळने करीन आवला, काहाकी चे सामळ्‌या की हयु असु मटा कामेन सहलाणी देखाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ने च आखो देखीन फरीसी माणसे आपसा-आपसा कह्‌णे बाजी गुया, “देखु ते खरा, आखी कळीन माणसे ईसु पछळ चाल पड़्‌या, ने आपणु हीनुक बेसका रुकणे कर्‌या, तेबी हया नी रुकायता।” ");
INSERT INTO bhi_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","चे माणसे तीहवारेन मुखा पर भगवानेन भक्‌ती करने यरुसलेमेन मंदीर मां आवला, तींद्‌रे मां ईतराक युनानी माणसे हतला। ");
INSERT INTO bhi_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","चे गलील जीलान बेतसेदा गांव मां रहण्‌या फीलीप्‌पुस धड़े आवीन तेरे धड़े लीलघाय्‌न असा कह्‌या, “ए मालीक! हामु ईसु काजे भेळा हवणे हींडी र्‌या।” ");
INSERT INTO bhi_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","फीलीप्‌पुस जाय्‌न अन्‌दीरीयास काजे खबर कर्‌यु ने, अंदीर्‌यास फीलीप्‌पुस भेळुत जाय्‌न ईसु काजे खबर कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ईसु तीनु काजे आपसा मरनेन बारामां दाखला सी कह्‌यु, माणसेन पुर्‌यु दुख झेलीन सरग वाळा सेक-सींगार मां पछु जाणेन घड़ी आय लागली छे। ");
INSERT INTO bhi_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","मे तुहुंक छाची-छाचीन कह्‌वो जत्‌यार लग गहुंन दाणु धुळा मां पड़ीन मरे नी, तत्‌यार लग चु एखलुत रहे, बाकुन कदी चु मर जाय, ती बेसका दाणा लावे। ");
INSERT INTO bhi_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","जु काहनुक ईनी कळीन जीवाय मां आपसा जीव काजे जादा परम करे, चु आपसा जीवेक खुवसे, बाकुन जु काहनुक ईनी कळीन जीवाय मां आपसान जीव आपणे लग तीयार छे, ती चु आपसा जीव काजे अमर जीवन हेर लेसे। ");
INSERT INTO bhi_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","कदी काहनुक माणुस मारी सेवा चाकरी करने हींडे ती तीनाक मारु चेलु बणीन मारा कह्‌याम चालनु चाहजे, जसु मे मुतेन वाटे हय चालने बाजी र्‌यु, तसात मारा चाकर्‌या चेलाक बी तीनेत वाटे चालनु पड़से, ने कदी काहनुक ईनी रीते मारी सेवा चाकरी करसे, ती मारु भगवान बास तेरी ईज्‌जत करसे। ");
INSERT INTO bhi_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ईसु अगु कह्‌तु गुयु, “हय मारु जीव कलपी र्‌यु।” मे ज कहं काय? ए भगवान बास! मेसेक हीना दुखेन घड़ीम सी वाचाड़ नी, मे असु नी कहं, काहाकी मे ईना दुखेन घड़ी काजे एठणे करीन ईनी कळी मां आवलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ए भगवान बास! “तारा नावेन सेक-सींगार उजेंतु देखाड़।” तीनीत टेमे सरगेम सी जु बुल सामळायु, मे सेक-सींगार उजेंतु देखाड़लु छे, “ने अळी उजेंतु देखाड़ीस।” ");
INSERT INTO bhi_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","आड़े-धड़े उबा हय रवला माणसे ज सामळीन कह्‌या, “वादळो गुयो।” दीसरा माणसे कह्‌या, “सरग वाळु काहवाळ्‌यु हीनाक काय कह्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ईसु जपाप आप्‌यु, “ईना बुलेन अवाज मारे वाटे नी आवी, बाकुन तुंद्‌रे वाटे सरगे सी आवी। ");
INSERT INTO bhi_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","हय भगवानेन वीरुद करन्‌या, ईनी कळीन नीयाव हवण्‌यो छे। हय, भगवान ईनी कळीन मुखी भुतड़ा काजे वार मां बाहर नीकाळ देसे। ");
INSERT INTO bhi_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","जत्‌यार माणसे मेसेक धरती पर लाकड़ान कुरुस पर चहड़ावीन मारसे, ती मे आखी जातीन माणसे काजे मारे भीणी मनवी लीस।” ");
INSERT INTO bhi_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","असु कय्‌न ईसु आपसा बारामां ज देखाड़ने हींडी रवलु, की मारी मोत असी हवणे वाळी छे। ");
INSERT INTO bhi_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ईसुन वात सामळीन माणसे ईसुक कह्‌या, खरला सास्‌तुर मां सी हामुक ज सीकणु जड़लो छे की, “आवणे वाळु छुड़ावन्‌यु मसी जलम जीवतेलु रवसे। ती तु असु काहा कय र्‌यु की माणसेन पुर्‌या काजे ईनी धरती पर लाकड़ान कुरुस पर चड़ावीन मारसे? जु काहना भातीन वाचाड़न्‌यु माणसेन पुर्‌यु छे, चु मरनेन हेर कर र्‌यु? जी वात हामुक समज मां नी आवती।” ");
INSERT INTO bhi_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","तींद्‌री वात सामळीन ईसु तीनुक आपसा बारामां दाखलु दीन कह्‌यु, “तुंद्‌रे ईचमां वीजाळो हय छे, च ईतरीक वार भबळसे, जत्‌यार लग ज वीजाळो तुंद्‌रे ईचमां रवसे, ईना वीजाळा सी अगा चालता रहु। काहाकी आंदारलो तुहुं काजे टुपी नी लेय। काहाकी जु कुय आंदारला मां चाले ती ज नी जाणे की कां जाणे बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","जत्‌यार लग च वीजाळो तुंद्‌रे ईचमां छे, चां लग ईना वीजाळा पर भुरसु करु असा करसु ती तुहुं वीजाळान अवल्‌यात बण जासु।” ईसु ज कय्‌न जाती र्‌यु, ने तींद्‌रे देखतात जातु-जातु अंछाप हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ईसु ते माणसे अगळ चकराड़े तसा बेसका मटा कामेन सहलाणी देखाड़्‌यु, तेबी चे तेर पर भुरसु नी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","काहाकी भगवानेन अघली वात बताड़न्‌यु माणुस यसायु जी वात पेहलुत कह्‌लु ची वात पुरी हवे: “ए मालीक! कुण हामरी खबर पर भुरसु करलु छे? कुणी पर मालीकेन जुर देखाव पड़लु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","असा करीन चे भुरसु नी कर्‌या, काहाकी यसायु अळी बी ज कह्‌लु, ");
INSERT INTO bhi_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“भगवान तींद्‌रा डुळा काजे आंदळा कर देदु, ने तींद्‌री मन काजे काठो कर देदलु छे, की कांखुर मायन असो नी हय जाय की चे देख लेय ने समजी लेय, ने मारे भीणी पछा आय लागे, ने मे हीनुक वारु कर दम।” ");
INSERT INTO bhi_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यसायु ते एक जागता सपना मां सेक-सींगार देख्‌लु, चु ते ईसुन बारामां पेहेल सी लिखी रवलु। ");
INSERT INTO bhi_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","तेबी यहुदी मुख्‌या मायन थुड़ाक तेरे पर भुरसु कर्‌या ने दीसरा बेसका यहुदी माणसे बी ईसु पर भुरसु कर्‌या बाकुन फरीसी माणसेन धाके चे मुख्‌या उजेंता ईसु काजे नी मानतेला। तींद्‌रो ज बी बीहाणो हतलो की फरीसी माणसेन मुख्‌या हामुक आपणा भक्‌तीन घर मां सी नीकाळ देसे। ");
INSERT INTO bhi_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","काहाकी माणसे सी जादा ईज्‌जत मांगणे हेर करतेला, बाकुन भगवान सी ईज्‌जत मांगणे वारु नी लाग्‌यो। ");
INSERT INTO bhi_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ईसु जुर सी आयड़ीन कह्‌यु, “जु मारे पर भुरसु करे, चु छाचलीन तेरे पर बी भुरसु कर र्‌यु, जु मेसेक मकेल्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ने जु मेसेक देखे, चु तीनाक देखे जु मेसेक मकेल्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","मे वीजाळो बणीन कळी मां आवलु छे, तेरेमां चे आखा माणसे मारे पर भुरसु करे, चु आंदारला मां नी रहे। ");
INSERT INTO bhi_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","कदी काहनुक मारी वात सामळीन बी जी वात तीनीक मानीन नी जीवे, ती हय मे तेरु नीयाव करीन तीना गुनावाळु नी ठहरावो, काहाकी मे ईनी कळीन मनख्‌यान नीयाव करीन गुनावाळु ठहरावणे नी आयु, बाकुन तीनुक छुटकारु आपणे करीन आवलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","जु मेसेक नानु समजीन मारी सीकाड़ली वात काजे नी माने, तीनाक गुनावाळु ठहरावणे वाळु ते एक छे, ज मे सीकाड़लु छे की चे बुले तीनाक आवणे वाळा दाहड़ाम मतलब नीयावेन दाहड़े गुनावाळु ठहराय देसे। ");
INSERT INTO bhi_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","मे मारी मरजी सी काय बी नी कह्‌यु, बाकुन माणसेक काय-काय कहणु चाहजे ने काय सीकाड़नु चाहजे भगवान बास, जु मेसेक मकेल्‌लु छे, चु की चु मेसेक हुकुम आपीन देखाड़लु छे। ");
INSERT INTO bhi_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","मे जाणो की जे बुले कहणे करीन भगवान बास मेसेक हुकुम आप्‌लु छे, तींद्‌रेम अमर जीवेनेन ताकत छे, ने जसु भगवान बास मेसेक कहलु छे, तसु ने तसु मे सीकाड़ो।” ");
INSERT INTO bhi_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","फसह तीहवारेन दाहड़ु आय लाग्‌यु, ने खाणो तीयार हय रह्‌लो। ईसु काजे मालुम हतलो, की जी कळ छुड़ीन भगवान बासेन्‌चां जाणेन मारी घड़ी आय गुयली छे। ईसु आपसा चेला काजे, जे ईनी कळी मां हतला, तीनुक पेहेल सीत परम करतु आय रवलु ने आकरी टेम लग तीनु काजे तसुत परम करतु रयु। ");
INSERT INTO bhi_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","सांतो हय रह्‌लो तत्‌यार ईसु ने तेरा चेला तीहवारेन खाणो खाणे करीन बठी गुया, तीने टेमे लग भुतड़ु सीमोन ईस्‌करीयोतीन पुर्‌या यहुदीयान मन मां ईसु काजे धुकु दीन धरावणेन वीच्‌यार नाख देदलु। ");
INSERT INTO bhi_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ईसु जाणतेलु की मे भगवान बासेन्‌चां सी आवलु छे ने भगवान बास मारा हाते मां आखो काय आप देदलु छे ने मे तेरेन्‌चां पछु जाणे वाळु छे। ");
INSERT INTO bhi_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ने चु खाणो खाणे रहणीदीन उबु हय गुयु ने आपसो उपरनो झगल्‌यो नीकाळ लेदु ने कमर मां टुवाल बांद लेदु। ");
INSERT INTO bhi_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ती चु टगार्‌याम पाणी हेड़ लेदु, ने आपसा एक-एक चेलान पाय धुवतु गुयु, ने कमर मां बांदी रवलु, तीना टुवाल सी तींद्‌रा पाय नुछतु गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","जत्‌यार ईसु सीमोन पतरसेन्‌चां पाय धुवणे करीन आयु, ती पतरस ईसु काजे कह्‌यु, “ए मालीक! तु मारा पाय धुवणे हय र्‌यु काय?” ");
INSERT INTO bhi_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ईसु पतरस काजे जपाप आप्‌यु, “मे ज करने बाजी र्‌यु, च तु हींताळ नी समजतु बाकुन तु अळतेन समजी जासी।” ");
INSERT INTO bhi_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पतरस ईसुक कह्‌यु, “मे तुसेक मारा पाय कदी नी धुवणी दम।” ईसु पतरस काजे कह्‌यु, “कदी मे तुसेक नी धुवों, ती मार साते रवणे मां हक नी जड़े।” ");
INSERT INTO bhi_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ज सामळीन सीमोन पतरस ईसुक कह्‌यु, “ए मालीक! असो हय ती तु मारा पाय अतरा नी बाकुन मारा हात ने मुणको लग धुय दे।” ");
INSERT INTO bhi_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ती ईसु पतरस काजे अळी कह्‌यु, “जु उंघळी लेदलु छे, तीनाक आपसा पाय अतरा धुवणु छे, तेरो आखो डील ते चुखलो छे। तुहुं ते चुखला छे, बाकुन आखा ने आखा चुखला नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ईसु काजे मालम हतलो की मेसेक कुण धरावसे, चु कह्‌यु, “तुहुं आखा ने आखा चुखला नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","जत्‌यार ईसु तींद्‌रा पाय धुय देदु, ती आपसो झगल्‌यो पछु पेहरीन अळी पछु बठ गुयु, ने तीनुक कह्‌यु, “मे तुंद्‌रे साते ज वेहवार कर्‌यु, तीना वेहवारेन मतलब तुहुं समजी गुया काय? ");
INSERT INTO bhi_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","तुहुं मेसेक मास्‌तर ने मालीकेन नाते बुलाड़ी र्‌या ने तुहुं सय कय र्‌या, काहाकी मे छाचलीन चु ने चु छे। ");
INSERT INTO bhi_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","कदी मे तुंद्‌रु मालीक ने मास्‌तर हय्‌न बी तुंद्‌रा पाय धुयु ती तुहुं बी एक दीसरान पाय धुवणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","मे ते तुंद्‌रा पाय धुवीन तुंद्‌रे वाटे दाखलु देखाड़लु छे, ने जसु मे ने तुंद्‌रे साते वेहवार करलु छे, तसु तुंद्‌रे वेहवार तुहुं बी दीसरा साते वेहवार करु। ");
INSERT INTO bhi_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","मे तुहुं काजे छाची छाचीन ज कहं, काय हक मां रहणे वाळु पावर्‌यु आपसान मालीक सी मटु नी हय ने मकलन्‌या सी मटु नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","कदी तुहुं जी वात समजीन एरे अनसारे जीवु ती तुहुं बरकतवाळा रवसु।” ");
INSERT INTO bhi_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“मे तुहुं आखा काजे बरकतवाळा नी कह्‌तु काहाकी मे तीनु आखाक जाणो जीनुक मे नेवाड़लु छे बाकुन तींद्‌रे मायन एक जम छे, तेरे बारामां असो लिखलो छे जु मारु रुटु खादु, चु मेसेक लातावणे बाजी गुयु, ची वात पुरी हवसे करीन मे तीनाक बी नेवाड़लु छे। ");
INSERT INTO bhi_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","हय मे तुहुंक पेहलुत ज कयदम, तेरेसी मारो कहंलो पुरो हय जाय, ती तुहुं भुरसु करसु, की मे चु ने चु छे। ");
INSERT INTO bhi_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","मे तुहुंक छाची छाचीन ज कहं, जु काहनु मारे सी मकेल्‌ला माणसे काजे मानीन तेरो आव-भाव करे, चु मेसेक मानीन मारुत आव-भाव करे, चु मेसेक मकेलन्‌याक मानीन तेरुत आव-भाव करे।” ");
INSERT INTO bhi_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","जी वात कयदीन ईसु जीवेम बेसकु कलपी गुयु, ने जी गवाय देदु काय वात नी सात्‌यु ने कह्‌यु, “मे तुहुंक छाची-छाची कहं तुंद्‌रे मायन एक जणु मेसेक धराय देसे।” ");
INSERT INTO bhi_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","चेलाक ज नी समज पड़्‌यो की ईसु कुणीन बारामां कहंणे बाजी र्‌यु, ने चेला चकरायन एक दीसरा भीणी भाळने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","तीनु बारे चेला मायन एक जणु, “ईसुन लाटेक्‌लु चेलु।” कहंवायतेलु। चु ईसुन छाती भीणी एक कड़्‌यु वळीन बठी रवलु। ");
INSERT INTO bhi_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","सीमोन पतरस तीनाक ईसारु करीन जां कह्‌यु, “ईसुक पुछ, चु चेलु कुण छे।” ");
INSERT INTO bhi_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","तत्‌यार चु असु की असु ईसुन छाती भीणी अळीन बठी रवलुत ईसुक कळेन पुछ्‌यु, “ए मालीक! जु कुण छे?” ");
INSERT INTO bhi_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ईसु तीनाक कळेन जपाप आप्‌यु, “मे तीनाक रुटान कवळ उलन मां चुपड़ीन आपीस, चु की चु मेसेक धरावण्‌यु छे।” ने चु रुटान कवळ चुपड़ीन सीमोन ईस्‌करीयोतीन पुर्‌या यहुदा काजे आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ने रुटान कवळ धरीन मुंहडाम नाख्‌तुत यहुदान डीलेम भुतड़ु भरायन तीनाक कब्‌जाम कर लेदु। तत्‌यार ईसु तीना यहुदाक कह्‌यु, “ज काम तु करने हींड र्‌यु च छाटुस कर।” ");
INSERT INTO bhi_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","बाकुन चां खाणो खाणे बठी रवला चेला मायन कुयक बी जी वात समज नी पड़ी की ईसु तीनाक जी वात काहा कह्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","यहुदा धड़े थयलि हतली, ने काहनाक-काहनाक ज समज्‌या की ईसु तीनाक ज कह्‌यु हसे की, आपणु तीहवार वाटे ज काय चाहजे च मुल ली लेजे, नी ते गरीबेक आप दे। ");
INSERT INTO bhi_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","अळतेन रुटान कवळ खायलीन यहुदा तत्‌यारुत खयड़े जाती र्‌यु। तीने टेमे रात हय वागली। ");
INSERT INTO bhi_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","यहुदाक खयड़े जाणी दीन ईसु कह्‌यु, “हय माणसेन पुर्‌या काजे भगवान पेहलुत सी ईज्‌जत जड़ली छे, ने माणसे अगळ भगवान काजे बी माणसेन पुर्‌यान कामे सी ईज्‌जत जड़ने वाळी छे। ");
INSERT INTO bhi_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ने माणसे अगळ माणसेन पुर्‌यान कामे सी भगवान काजे ईज्‌जत जड़से ती भगवान बी माणसेन पुर्‌या काजे सरग वाळु सेक-सींगार पछु आपीन ईज्‌जत करसे ने छाटुस ईज्‌जत करसे। ");
INSERT INTO bhi_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ए मारा लाटेक्‌ला पुर्‌या-पारी! मे अळी ईतरीक वार लग तुंद्‌रे पुठ्‌ये छे, अळतेन तुहुं मेसेक हेरसु ने जसु मे यहुदी मुख्‌याक कहलु, तसु हय मे बी तुहुंक कहो, जां मे जाणे हींड र्‌यु चां तुहुंक नी आवाये। ");
INSERT INTO bhi_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","मे तुहुंक एक नवलु हुकुम आपो, तुहुं एक दीसरा पर परम राखु जसु मे तुंद्‌रे पर परम राख्‌यु तसा तुहुं बी एक दीसरा पर परम राखु। ");
INSERT INTO bhi_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","कदी तुहुं एक दीसरा पर परम राखसु ती च देखीन आखा माणसे जाण लेसे की तुहुं मारा चेला छे।” ");
INSERT INTO bhi_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","सीमोन पतरस ईसु सी पुछ्‌यु, “ए मालीक।” “तु कां जाणे हींड र्‌यु?” ईसु पतरस काजे कह्‌यु, “मे जां जाणे हींड र्‌यु चां तुसेक हींताळ नी आवाये बाकुन अळतेन तु चां आवसी।” ");
INSERT INTO bhi_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पतरस तीनाक कह्‌यु, ए मालीक! मेसेक हींताळ तु जाय चां काहा नी आवाये? “मे तार वाटे मारु जीव बी आप दीस।” ");
INSERT INTO bhi_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ईसु पतरस काजे जपाप आप्‌यु, “तु मारे वाटे आपसु जीव आप देसी काय? मे तुसेक छाची छाचीन ज कहं कुकड़ा वासणेन पेहलुत तु तीन कावा दीसरा अगळ असुत कह्‌सी की मे ईसुक जाणो लग नी।” ");
INSERT INTO bhi_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“तुंद्‌रु जीव घाबरायणु नी चाहजे। भगवान पर भुरसु करु, ने मारे पर बी भुरसु करु।” ");
INSERT INTO bhi_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","मारा भगवान बासेन घर मां रहणे करीन बेसकु जागु छे, कदी नी रहतु ती तुहुंक पेहलुत कय देतु। मे तुंद्‌रे वाटे घरेन तज्‌बु करने करीन जाणे हींड र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ने मे जाय्‌न तुंद्‌रे वाटे आखो तीयार कर दीस ती तुहुंक लेणे करीन अळी पछु आवीस। ने तुहुंक मारेन्‌चां असु करीन ली जायस की जां मे रहो चां तुहुं बी रहु। ");
INSERT INTO bhi_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","मे जां जाणे हींड र्‌यु, चां जाणेन वाट तुहुंक मालुम छे। ");
INSERT INTO bhi_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमा ईसुक कह्‌यु, “ए मालीक! हामुक ज बी मालुम नी हय की तु कां जाणे हींड र्‌यु ती हामुक चां जाणेन वाट कसा काय जाणसुन?” ");
INSERT INTO bhi_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ईसु थोमा काजे कह्‌यु, “वाट, छाचली ने जीवात मेत छे। मारेन्‌चां नी आवे ती तीनाक भगवान बासेन्‌चां नी जावाये।” ");
INSERT INTO bhi_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","कदी तुहुं मेसेक उळखी लेता, ती मारा बासेक बी उळखी लेता, “बाकुन ज छाचलीन छे, की तीनाक तुहुं देखला छे, ने हाय सी मारा भगवान बासेक उळखी बी लेसु।” ");
INSERT INTO bhi_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फीलीप्‌पुस ईसुक कह्‌यु, “ए मालीक! हामु काजे तारु बास देखाड़ दे, हामरे वाटे अतरोत घणो।” ");
INSERT INTO bhi_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ईसु फीलीप्‌पुस काजे कह्‌यु, “ए फीलीप्‌पुस! मे अतरा दाहड़ा लग तुंद्‌रे पुठ्‌ये र्‌यु, ने तेबी तुहुं मेसेक नी उळखु? जु मेसेक देखलु छे। चु भगवान बास काजे बी देखलु छे। तु असु काहा कह्‌यु की हामु काजे बास देखाड़ दे। ");
INSERT INTO bhi_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","तुसेक भुरसु नी आवतु काय की भगवान बास मारे मां छे, ने मे भगवानेन बास मां छे, मे जे बुले तुहुंक कह्‌वो चे बुले मारा नी हय बाकुन बास मारेम रवीन बुले ने मारे सी तेरा मटा काम करे। ");
INSERT INTO bhi_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","मारी ईनी वात पर भुरसु करु की मे भगवान बास मां छे, ने भगवान बास मारेम छे, कदी मारी ईनी वात पर तुहुंक भुरसु नी आवतु ती कम सी कम ईना मटा कामे मारे सी हवे। तीनु कामेक देखीन ईनी वात पर भुरसु करु।” ");
INSERT INTO bhi_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","मे तुहुं काजे छाचलीन ज कहं, जु मारे पर भुरसु करे, ने च बी मे करो चे काम करसे। मेते भगवान बासेन्‌चां जाणे बाजी र्‌यु। ने मार पर भुरसु करन्‌या ईनु कामे सी बी मटा काम करसे। ");
INSERT INTO bhi_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ने तुहुं ज काय मारे नावे भगवान बास सी दुवा करीन मांग्‌सु, च काम मे करीस तेरेसी पुर्‌यान सी मतलब मारे सी भगवान बासेन ईज्‌जत जड़े। ");
INSERT INTO bhi_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","तुहुं ज बी मारे धड़े मार नाव सी दुवा करीन मांग्‌सु च मे काम करीस। ");
INSERT INTO bhi_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","कदी तुहुं मारे सी परम करसु ती मारा हुकुम काजे बी पाळसु। ");
INSERT INTO bhi_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ने मे बास सी दुवा करीस ने चु तुंद्‌रेन्‌चां मारी आवजी पर एक दीसरु सात देण्‌यु मकलसे चु जलम तुंद्‌रे पुठ्‌ये रवसे। ");
INSERT INTO bhi_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","मतलब छाचली जीव-आत्‌मा काजे मकलसे। तुहुं ते तीनाक जाणु, काहाकी चु तुंद्‌रे साते रहे बाकुन आवणे वाळा दाहड़ाम चु तुंद्‌रेत मां रवसे। बाकुन भगवानेन काम रुकण्‌या कळीन माणसे छाचली जीव-आत्‌मा काजे आपसा जीव वाटे जागु नी आपे काहाकी चे तीनाक देख्‌या बी नी ने उळखे बी नी। ");
INSERT INTO bhi_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“मे मरीस बाकुन तुहुं काजे एखला नाखीन नी जाम मे तुंद्‌रेन्‌चां अळी आवीस। ");
INSERT INTO bhi_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ईतरीक वार अळतेन ईनी कळीन माणसे जे मारे पर भुरसु नी करे चे मेसेक अळी नी देखे बाकुन तुहुं मेसेक अळी देखसु मे अळी जीवतु हय जायस ने जीवतेलु रवीस ने तुहुं बी जीवतेला रवसु। ");
INSERT INTO bhi_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","मे पछु जीवतु हय जायस तीने दाहड़े तुहुं समजी जासु की मे मारा बासेम छे, ने तुहुं मारेम छे, ने मे तुंद्‌रेम छे। ");
INSERT INTO bhi_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“तींद्‌रे भीणी मारी हुकुम छे, चु मारी हुकुम जाणे ने तीनुक पाळे, ने चु मारसी परम राखे, तीनाक मारु बास बी परम राख्‌से ने तीनाक मे बी परम करीस ने मे आपसा काजे तेरे अगळ उजेंतु करीस।” ");
INSERT INTO bhi_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","तत्‌यार ईस्‌करीयोती यहुदा नी बाकुन एक दीसरु यहुदा, ईसु काजे पुछ्‌यु “ए मालीक तु हामरे अगळ आपसाक उजेंतु करीस ने ईनी कळीन मनख्‌या पर उजेंतु नी करे?” ");
INSERT INTO bhi_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ईसु तीना यहुदा काजे कह्‌यु, “कदी काहनुक मारे सी परम राख्‌से ती चु मारी सीकाड़ली वात काजे मानीन जीवसे ने मारु भगवान बास तेरे सी परम राख्‌से ने हामु तेरेन्‌चां आवसुन ने तीनाम रवसुन। ");
INSERT INTO bhi_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","जी सीकाड़ली वात तुहुंक आप्‌यी र्‌यु ची आखी वात सीकाड़ली वात मारे वात मारे वावड़ते नी हय बाकुन मेसेक मकलन्‌या भगवान बास सी छे। चु मारे सी परम राखे चु मारी सीकाड़ली वात काजे मानीन नी जीवे ने मे आपसा काजे तेरे अगळ उजेंतु नी करो।” ");
INSERT INTO bhi_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“मे जी आखी वात तुंद्‌रे पुठ्‌ये रय्‌न तुहुंक कह्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","बाकुन चु सात देण्‌यु चुखली-आत्‌मा तीनाक भगवान बास मार नाव सी मकेलसे चु तुहुंक आखी वात सीकाड़से ने ज काय बी मे तुहुंक कह्‌लु छे, च आखो हेर कराड़से।” ");
INSERT INTO bhi_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","मे तुहुंक जीवेन सांती आपीन जाम मारी सांती तुहुंक आपी जाम, जसा ईनी कळीन माणसे सांती आपे, तसली सांती तुहुंक नी आप्‌तु; ने तुहुं तुंद्‌रा जीवेन घुण घाबरायजु ने घुण बीहजु। ");
INSERT INTO bhi_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","मे जाणे बाजी र्‌यु, मे भगवान बासेन्‌चां जाणे बाजी र्‌यु, चु भगवान बास मारे सी मटु छे, कदी तुहुं मार सी परम राखु ती जी सामळीन खुस हवजु। ");
INSERT INTO bhi_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","मे ज आखो हवणेन पेहलुत तुहुंक कय देदलु छे। मे असु करीन कय देदु की, ज मे कहलु च हय जाय, तत्‌यार तुहुं मारी वात पर भुरसु करु। ");
INSERT INTO bhi_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","हय ईनी कळीन मुख्‌यु भुतड़ु मेसेक मारने करीन आवणे बाजी र्‌यु, ने तुंद्‌रे साते जादा वार लग वात नी करो ने चु मेसेक कब्‌जाम नी कर सके। ");
INSERT INTO bhi_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","तेबी मे तेरा कब्‌जाम हय्‌न मर जाम काहाकी मारा भगवान बासेन जीत मरजी छे; असु करीन की ईनी कळीन माणसे ज जाण लेय की मे बास सी परम राखो ने बास मेसेक ज काय हुकुम आप्‌लु, मे तसु की तसु करो। उठ! हय आपणु जां सी जाजे। ");
INSERT INTO bhi_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ईसु कह्‌यु, “अंगुरेन खरलु वेलु मेत छे। ने ईना अंगुरेन वेलान राखवाळ्‌यु किरसाण मारु भगवान बास छे।” ");
INSERT INTO bhi_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","मारा डाळ्‌या मायन जे डाळ्‌या नी फळे, तीनुक मारु भगवान बास काट नाखे। ने जे डाळ्‌या फळे, चे डाळ्‌या अळी बी अदु फळनु चाहजे करीन तीनुक छाटे। ");
INSERT INTO bhi_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","तुहुं काजे जी वात सीकाड़लु छे, तीनी वात सी तुहुं चुखा हय गुयला। ");
INSERT INTO bhi_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","अळी अळीन फळ लावणे करीन मे तुहुंक चुखा करलु छे, जीनु डाळ्‌या काजे अंगुरेन वेला मां सी काट नाख्‌या, चे डाळ्‌या मारेम जुड़ायला नी हय, ने चे आपसात नी फळे। तीने रीते मारेम जुड़ायला नी रहे ती फळ बी नी लावे, ने तुहुं मारेम जुड़ायला रहु ने मे तुंद्‌रेम जुड़ायलु रवीस। ");
INSERT INTO bhi_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“चु अंगुरेन वेलु छे, ने तुहुं मारा डाळ्‌या छे, मार सी छेटे रय्‌न तुहुं काय बी नी कराये। ने जु मारेम जुड़ायलु रहे ने मे तेरेमां जुड़ायलु रवसे, चु बेसकु फळसे।” ");
INSERT INTO bhi_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","जे मारेम जुड़ायला नी रहे चे तीनु डाळ्‌यान तसा छे, तीनुक किरसाण काटीन नाख देय ने चे सुक जाय ने किरसाण ईछीन आकठा मां नाख देय ने चे धप जाय। ");
INSERT INTO bhi_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","कदी तुहुं मारेम जुड़ायला रवसु ने मारी सीकाड़ली वात काजे मान्‌ता रवसु, ती च बी चाहजे च दुवा करीन मांगजु ने मे तुहुंक आपी दीस। ");
INSERT INTO bhi_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","असा करीन तुहुं बेसका फळ लावसु, ती मारा भगवान बासेन बड़ाय हवसे ने तत्‌यार तुहुं मारा पक्‌का चेला बण जासु। ");
INSERT INTO bhi_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","जसु भगवान बास मारे सी परम राखलु छे तसुत मे बी तुंद्‌रे सी परम राखलु छे। तुहुं मारा ईना परम मां बणीन रवजु। ");
INSERT INTO bhi_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","मे मारा भगवान बासेन हुकुम पाळतु जाय्‌न तेरा परम मां बणीन रवु, तसात तुहुं बी मारा हुकुम पाळसु ती मालम पड़से की तुहुं मारा परम मां बन्‌ला छे। ");
INSERT INTO bhi_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","मे तुहुं काजे ज असु करीन कह्‌यु की, तुहुं काजे मारु हुकुम पाळनेन खुसी जड़ती रवे ने ची खुसी पुरी की पुरी जड़ जाय। ");
INSERT INTO bhi_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","मारु हुकुम जु छे की जसु मे तुंद्‌रे सी परम करलु, तसा तुहुं बी एक दीसरा सी परम करता रवजु। ");
INSERT INTO bhi_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","आपसा दुस्‌तीदार सी परम करीन तींद्‌रे वाटे मरनु आखा सी मटु परम छे। असलु परम सी मटु काहनु बी परम नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","कदी तुहुं मारा हुकुम पाळसु ती तुहुं मारा खरला दुस्‌तीदार कहंवायसु। ");
INSERT INTO bhi_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","पावर्‌या काजे मालम नी पड़े की तेरा मालीकेन मरजी काय छे, ने चु काय करने वाळु छे। बाकुन मे मारा बास सी सामळ्‌ळु च आखो तुहुंक कय देदलु छे, ने हय सी मे तुहुंक पावर्‌या नी कहं बाकुन दुस्‌तीदार कहीन। ");
INSERT INTO bhi_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“तुहुं मेसेक नी नेवाड़्‌या, बाकुन मे तुहुंक नेवाड़ीन तुहुंक मारे कामे लागाड़लु छे, की तुहुं मारो नाव लीन भगवान बास सी ज काय दुवा करीन मांगसु च भगवान तुहुंक आप देसे ");
INSERT INTO bhi_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","मे तुहुं काजे जे हुकुम असु करीन आप र्‌यु की, तुहुं एक दीसरा पर परम राखता रहु।” ");
INSERT INTO bhi_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“कदी ईनी कळीन माणसे तुंद्‌रे पर भुंडा सुचे, ती तुहुं ज हेर राख्‌जु की तुंद्‌रे सी पेहेल चे मारे पर भुंडा सुचे।” ");
INSERT INTO bhi_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","कदी तु ईनी कळीन माणसे रहता तत्‌यार चे तुहुंक आपणा समजीन परम राखता बाकुन मे तुहुं काजे ईनी कळीन माणसेम सी नेवाड़ लेदलु छे, करीन चे तुंद्‌रे बारामां भुंडा सुचसे। ");
INSERT INTO bhi_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","मे तुहुंक जी वात कह्‌यु तीनीक हेर राख्‌जु की, पावर्‌यु आपसा मालीक सी मटु नी हय। मे तुंद्‌रु मालीक छे, तेबी माणसे मेसेक वेला पाड़्‌या असला माणसे तुहुंक बी वेला पाड़से ईनी कळीम वाळा माणसे मारी सीकाड़ली वात काजे नी मान्‌या ती तुंद्‌री सीकाड़ली वात बी नी माने। ");
INSERT INTO bhi_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","असला माणसे, मेसेक मकेलन्‌या भगवान काजे नी उळख्‌या, ने मारी वीरुद कर्‌या, तुहुं ते मारो नाव ली र्‌या ने चे तुहुं काजे भुंडात करीन तुहुंक वेला पाड़से। ");
INSERT INTO bhi_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","कदी मे नी आवतु ने हीनुक पापेन बारामां भगवानेन छाचली वात नी सीकाड़तु, ती हीनुक पाप नी लागतु बाकुन हय ते हींद्‌रे धड़े आपसा पापेन बारामां ढंगड़ा करनेन मुखु नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","जु मेसेक भुंडु समजे, चु मारा भगवान बास काजे भुंडु समजे। ");
INSERT INTO bhi_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","कदी मे तींद्‌रे अगळ चे मटा कामे नी करतु, चे कामे कुय बी दीसरु कदी नी कर्‌यु, ती तीनुक पाप नी लाग्‌तु बाकुन हय ते चे असा काम देखीन बी मेसेक नी मान्‌या ने सांबा मार भीणी ने मारा भगवान बास काजे भुंडा करला छे। ");
INSERT INTO bhi_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ज असो काहा हयो काहाकी खरला सास्‌तुर मां लिखलो हतलो च पुरो हवे चां असो लिखलो छे, की चे माणसे फालतु मां मारा वेरी बण गुयला छे। ");
INSERT INTO bhi_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","मे तुंद्‌रेन्‌चां सात देण्‌या काजे मतलब छाचली जीव-आत्‌मा काजे भगवान बासेन चां सी मकलीस, जत्‌यार चु छाचली जीव-आत्‌मा भगवान बासेम सी आवसे ती चु मारे बारामां गवा देसे। ");
INSERT INTO bhi_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ने तेरे पुठ्‌ये तुहुं बी मारी गवाय देसु काहाकी तुहुं सुरु सीत मारे पुठ्‌ये रवला छे। ");
INSERT INTO bhi_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“मे तुहुं काजे जी आखी वात असु करीन कह्‌लु, छे की जत्‌यार माणसे तुहुंक वेला पाड़से, तत्‌यार तुहुं मार पर भुरसु छुड़ीन भटकाड़्‌यु घुण। ");
INSERT INTO bhi_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","माणसे तुहुं काजे तुंद्‌रा भक्‌तीन घर मां सी नीकाळीन बाहर कर देसे, ने छाचलीन जी टेम आवणे बाजी रय की, माणसे ज समजीन तुहुंक मारसे की हामु ईनुक मारीन भगवानेन सेवा चाकरी कर र्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","छाचलीन चे भगवान बासेक बी नी उळखे, ने मेसेक बी नी उळखे, ने चे तुंद्‌रे साते असा वेहवार करसे। ");
INSERT INTO bhi_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","मे तुहुंक जी आखी वात असु करीन कह्‌लु छे, की जत्‌यार चे तुहुंक वेला पाड़से, ती तुहुं काजे आखी वात हेर आवणु चाहजे की, मे तुहुंक जी वात पेहलुत कयदीन काठु करलु छे।” अतरा दाहड़ा मे तुंद्‌रे पुठ्‌ये हतलु करीन मे जी आखी वात सुरु मां नी कह्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","बाकुन हाय मे तेरेन्‌चां जाणे हींडी र्‌यु, जु मेसेक मकेल्‌लु छे, ने तुंद्‌रे मायन काहनुक मेसेक बी छाचे मने ज नी पुछतु की तु कां जाणे हींड र्‌यु? ");
INSERT INTO bhi_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","मे तुहुंक जी आखी वात कय देदु, करीन तुंद्‌रो मन सुच मां पड़ गुयो, ने तुहुं मेसेक नी पुछता। ");
INSERT INTO bhi_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","बाकुन मे तुहुंक छाचलीन कह्‌वो की, मे जाती रय्‌स ती तुंद्‌रे वाटे वारु रवसे काहाकी मे नी जाम ती तुहुंक सात देण्‌यु तुंद्‌रेन्‌चां नी आवे बाकुन मे जायस ती तीना सात देण्‌या काजे तुंद्‌रेन्‌चां मकली दीस। ");
INSERT INTO bhi_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","जत्‌यार चु सात देण्‌यु चुखली-आत्‌मा आवसे ती ची ईनी कळीन माणसेक तींद्‌रा पापेन बारामां ने तींद्‌रा धरमेन बारामां ने तींद्‌रा नीयावेन बारामां पुरावु भेळु गुनु देखाड़ीन समजाड़से। ");
INSERT INTO bhi_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","कळीन माणसे मारे पर भुरसु नी करता, करीन चुखली-आत्‌मा तींद्‌रा पापेन बारामां तीनुक पुरावा भेळु गुनु समजाड़से। ");
INSERT INTO bhi_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","मेते भगवान बासेन्‌चां जाणे हींड र्‌यु, ने जत्‌यार मे जाती रय्‌स ती तुहुं मेसेक नी देखु मारी आवजी पर चुखली-आत्‌मा तुंद्‌रे पुठ्‌ये रय्‌न कळीन माणसेक तींद्‌रा झुटा धरमेन बारामां पुरावा भेळु गुनु देखाड़ीन समजाड़से। ");
INSERT INTO bhi_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ईनी कळीन मुख्‌यु भुतड़ान नीयाव हय गुयला छे ने तेरा पापेन डंड तीनाक छाटुस भुकेतणु पड़से ने चुखली-आत्‌मा कळीन माणसेक बी तींद्‌रा झुटा नीयावेन बारामां पुरावु भेळ गुनु देखाड़ीन समजाड़से। ");
INSERT INTO bhi_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","तुहुंक कहंणे करीन अळी बेसकी वात मारा मन मां आय रय बाकुन हींताळ कयस ती तुहुंक वेठाये नी। ");
INSERT INTO bhi_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","जत्‌यार चु छाचलीन जीव-आत्‌मा आवसे, ती चु तुहुंक भगवानेन आखी छाचली वाटे ली जाणे अगवाय करसे काहाकी चु आपसे आवड़ते काय बी नी कह्‌वे, बाकुन चु ज काय मारे सी सामळसे चत कवसे ने आवणे वाळी वातेन बारामां बी तुहुंक देखाड़से। ");
INSERT INTO bhi_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","चु मारी सेक-सींगार करसे, काहाकी ज काय मारो छे च बताड़से, ने आखी चीज जी बासेन छे ची मारी छे। ");
INSERT INTO bhi_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","तेरेमां मे कह्‌यु की ज काय भगवान बासेन छे, च आखो मारो छे चु तीनाक लेसे ने तुहुंक बताड़से। ");
INSERT INTO bhi_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ईसु आपसा चेलाक पेहलुत सी कह्‌तु गुयु, ईतरीक वार मां तुहुं मेसेक नी देखु ने अळी ईतरीक वार मां मेसेक देख्‌सु।” ");
INSERT INTO bhi_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ने ईसुन चेला मायन ईतराक चेला आपसा आपसात कह्‌या, “हयु आपणुक काय कय र्‌यु, च आपणुक समज मां नी आवतो हयु कह्‌यु की ईतरीक वार मां तुहुं मेसेक नी देखु ने अळतेन अळी ईतरीक वार मां तुहुं मेसेक देखसु चु ईतरीक वार पेहेले असु बी कह्‌लु, काहाकी मे भगवान बासेन चां जाणे हींडी र्‌यु।” ईनी दुय वातेन मतलब काय छे। ");
INSERT INTO bhi_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","चे कह्‌या हयु ईतरीक वार मां कहें च काय कहंवाये हामुक समज मां नी आवतो की हयु हामुक काय कय र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ईसु ज जाण लेदु की हया मेसेक मारी ईनीक वातेक लीन सवाल पुछणे हींडे की ईतरीक वार मां तुहुं मेसेक नी देखु, ने अळी ईतरीक वार मां तुहुं मेसेक देख्‌सु करीन ईसु तीनुक कह्‌यु, “तुहुं आपसा-आपसा मारी ईनी वातेन बारामां वीच्‌यार काहा कर र्‌या? ");
INSERT INTO bhi_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","मे तुहुंक छाची छाचीन ज कहं, ईतरीक वार मां तुहुं रड़सु ने कलेपसु बाकुन ईनी कळीन माणसे खुस हवसे, ने हय तुहुं दुखी हवसु ते खरा बाकुन अळतेन तुहुं दुखी हवणु रहणीदीन खुस हय जासु।” ");
INSERT INTO bhi_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“भारीस बायर फवरी हवणे वेळाय बेसकी वेला करीन कलपे, बाकुन जत्‌यार ची फवरी हय जाय ती, बेसकी खुस हवे। हय ईनी कळी मां एक पुर्‌यु पयदा हवलु, करीन ची एक वेलान वात काजे ईसरी जाय।” ");
INSERT INTO bhi_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","असात हय ते तुहुं बी दुखी छे, बाकुन मे अळी तुहुंक भेळु हय्‌स तत्‌यार तुंद्‌रा मन मां खुसी आय जासे, ने तुंद्‌री खुसी तुंद्‌रे सी कुय सी नी हापकाये। ");
INSERT INTO bhi_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","तीने दाहड़े तुहुं मारे सी काय बी नी पुछु मे तुहुं काजे छाची-छाची कह्‌वो, कदी तुहुं भगवान बास सी मारे नावे दुवा करीन काय बी मांगसु, ती चु तुहुं काजे आपसे। ");
INSERT INTO bhi_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","आज लग तुहुं मारे नावे दुवा करीन काय बी नी मांग्‌या। मांगसु, ती भगवान तुहुंक आपसे, असु करीन की तुंद्‌री खुसी पुरी हय जाय। ");
INSERT INTO bhi_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“मे तुहुं काजे जी आखी वात दाखलु दीन कह्‌लु छे। असी टेम आवणे बाजी रय की मे तुहुं काजे अळी दाखलु दीन वात नी बताड़ो, बाकुन भगवान बासेन बारामां वात खुलीन बताड़ीस। ");
INSERT INTO bhi_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","तीने दाहड़े तुहुं मारे नाव सी मांगसु ने मे तुंद्‌रे सी ज नी कवतु की मे तुंद्‌रे वाटे भगवान बास सी दुवा कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","बाकुन भगवान बास आपसुत तुंद्‌रे सी परम करे, काहाकी तुहुं मारे सी परम राखु ज भुरसु कर लेदला छे की मे भगवान बासेम सी आयु। ");
INSERT INTO bhi_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","मे भगवान बास सी नीकळीन कळी मां आय गुयु, ने अळी पछु कळी काजे छुड़ीन भगवान बास भीणी जाणे बाजी र्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ईसुन चेला ईसु काजे कह्‌या, “देख, तु हय दाखलु दीन नी कवतु बाकुन चुखो झण कह्‌णे बाजी र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","हय हामु समजी गुयला छे की, तु आखो काय जाणे। हामु तुसेक ज पुछणे हींड र्‌या तीनी वातेक बी तु पेहल सीत जाणी लेय ने तु जी हेर नी करतु की कुय तुसेक पुछणु चाहजे, तारेम काय बी कसर नी हय ने हामु भुरसु करजे की तु भगवान बास सी आवलु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ईसु तीनु काजे कह्‌यु, “काय तुहुं हय भुरसु करु? ");
INSERT INTO bhi_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","बाकुन देखु! असी टेम आवणे बाजी रय ने आय गुयली छे, जत्‌यार तुहुं आखा की आखा रावण्‌या-तीवण्‌या हय जासु ने मेसेक एखलुत छुड़ीन जाती रवसु। तेबी मे एखलु नी हय काहाकी भगवान बास मार पुठ्‌ये छे।” ");
INSERT INTO bhi_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“हय, ईनी कळी मां तुहुंक वेला करनु पड़से तेबी काठु जीव करजु, मे ईनी कळीक जीत लेदलु छे। मे तुहुं काजे जी आखी वात असु करीन कह्‌लु छे की, आवणे वाळा दाहड़ाम दुख झेलता जाय्‌न बी तुहुं मारेम छे ची सांती हात कर लेय।” ");
INSERT INTO bhi_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","जी वात कयदीन ईसु सरग भीणी भाळीन कह्‌यु, “ए मारा भगवान बास! तारा पुर्‌यान मरनेन घड़ी आय गुयली छे। ने तारा पुर्‌यान सेक-सींगार उजेंतु कर तेरे सी तारु पुर्‌यु बी तारु सेक-सींगार उजेंतु कर देय। ");
INSERT INTO bhi_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","तु ते तारा पुर्‌या काजे आखा माणसे पर हक आपलु छे, की तीना हक सी चु आखा माणसेन ईचमां तारु सेक-सींगार उजेंतु करे ने तींद्‌रेम सी जत्‌यार बी माणसे तु तेरा हाते सुपलु छे, तीनु आखा काजे चु अमर जीवाय आप देय। ");
INSERT INTO bhi_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","एकुत छाचलु भगवान तुत छे, ने मे ईसु तारे सी मकेल्‌लु छुड़ावन्‌यु मसी छे, तुसेक ने मेसेक जाणीन मान्‌ने सीत माणसेक अमर जीवाय जड़से। ");
INSERT INTO bhi_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ज काम तु मेसेक करने करीन आपलु हतलु, च काम करीन धरती पर तारो सेक-सींगार काजे उजेंतु करलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ए भगवान! कळी नी घड़ाय ने पेहलुन, मे तारे पुठ्‌ये हतलु, ने मे नी तारेन तसु सेक-सींगार मां हतलु हय मेसेक तीना सेक-सींगार मां पछु भेसकी ले।” ");
INSERT INTO bhi_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","तीनु माणसे काजे तु ईनी कळीम सी नेवाड़ीन मेसेक सुपलु चे तींद्‌रे अगळ मे तारो नाव उजेंतु कर देदलु छे, छाचलीन चे माणसे तारात हतला, ने तु तीनु काजे मार हातेम सुप देदु, ने चे तारा बुल काजे मानीन पाळ र्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","हय चे जाण गुया की ज काय तु मेसेक देदलु छे, च आखो तारो छे। ");
INSERT INTO bhi_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","काहाकी ज बुले तु मेसेक देदलु, ने चे बुले तीनुक बी सामळाय देदु, ने चे मान लेदा ने छाची-छाची जाण लेदा की मे तारे सी आय र्‌यु ने भुरसु कर लेदा की तुत मेसे काजे मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","हींद्‌रे वाटे मे जी दुवा करो ची दुवा तु सामळी ले, मे कळीन माणसे वाटे दुवा नी करतु, बाकुन तींद्‌रे वाटे करो जीनुक तु मारे हातेम सुपलु छे काहाकी चे तारात छे। ");
INSERT INTO bhi_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","छाचलीन ज काय मारो छे च तारो छे, ने ज तारो छे च मारो छे। ने हींद्‌रे सी मारु सेक-सींगार उजेंतु हवलु छे। ");
INSERT INTO bhi_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“मे ईनी कळीक छुड़ीन तारेन चां आवणे हींड रयु, बाकुन हय जे चेला कळीत मां रवसे।” ए चुखला भगवान बास! तु ज नाव मेसेक आपलु छे तीने नावे हींद्‌री राखवाळी करो, तेरेसी चे आपणेन तसा एक हय जाय। ");
INSERT INTO bhi_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","जत्‌यार लग मे हींद्‌रे साते हतलु, तत्‌यार लग तारा नाव सी हींद्‌री पुरी राखवाळी करतु रयु। तींद्‌रे मायन कुय बी ठायकुत नी सर्‌यु बाकुन एकुत जणु ठायकुत सर गुयु, जु सरने वाळु हतलु। खरला-सास्‌तुर मां लिखली वात पुरी हवणु चाहजे करीन असो हयो। ");
INSERT INTO bhi_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","हय मे तारेन चां आवणे हींडी र्‌यु ने मे जी दुवा ईनी कळीम रय्‌न करने बाजी र्‌यु, तेरसी जी खुसी मारेम छे, ची खुसी जे चेला पुरी की पुरी हात करे। ");
INSERT INTO bhi_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","मे तारी बुल हीनुक कय देदलु छे ने भगवानेन काम रुकण्‌या काजे ईनी कळीन माणसे हीनु काजे भुंडा कर्‌या काहाकी जसु मे ईनी कळीन माणसे साते संगात नी करो, तसात चे चेला बी ईनी कळीन माणसे साते सात संगात नी करे। ");
INSERT INTO bhi_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","मे जी दुवा नी करतु की तु हीनु काजे कळी मां सी ली जाती रहे, बाकुन ज कहो की हीनु काजे भुंडात कामे सी बचाड़ीन राख। ");
INSERT INTO bhi_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","जसु मे ईनी कळीन नी हय तसात चे बी ईनी कळीन नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ए भगवान बास तारा बुल चुखला छे ईना छाचला बुल सी ईनुक तारी सेवा वाटे चुखा करीन तीयार कर। ");
INSERT INTO bhi_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","जसु तु मेसेक ईनी कळीन चाकरीन हक आपीन मकेल्‌लु छे, तसुत मे बी ईनुक ईनी कळीन चाकरीन हक आपीन मकेल्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ने हींद्‌रा फायदा वाटे मे मारु जीव आपीन आपसाक नेवाड़ीन चुखु करो, काहाकी चे बी तारा छाचला बुले सी तारी सेवा वाटे नेवाड़ीन चुखा हय्‌न तीयार हय जाय। ");
INSERT INTO bhi_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“मे हींद्‌रे वाटे अतरुत दुवा नी करतु, बाकुन तींद्‌रे वाटे बी दुवा कर र्‌यु, जे आवणे वाळा दाहड़ाम हींद्‌री वात सामळीन मार पर भुरसु करसे। ");
INSERT INTO bhi_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","मे तींद्‌रे वाटे असी दुवा करो की चे आखा एक मन हय्‌न एक सारका हय जाय करीन। ए भगवान बास! जसु तु मारेम छे, ने मे तारेम छे, तसात चे बी आपणेम भेसकायन एक सारका हय जाय काहाकी ईनी कळीन माणसे तीनुक देखीन असु भुरसु कर लेय की ईसुत भगवानेन मकेलन्‌यु छुड़ावन्‌यु मसी छे। ");
INSERT INTO bhi_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ने जु सेक-सींगार तु मेसेक आप्‌यु, चु सेक-सींगार मे तीनुक आप देदलु छे, काहाकी चे आखा एक मन हय्‌न एक सारका हय जाय जसा आपणु एक सारका छे। ");
INSERT INTO bhi_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","मे तींद्‌रेम रवु, ने तु मारेम रहे ने चे आखा ने आखा एक सारका हय जाय ने ईनी कळीन माणसे ज जाण लेय की ईसु भगवानेन मकेल्‌लु मसी छे, ने जसु तु मार सी परम कर्‌यु तसु तु बी तीनुक परम करे।” ");
INSERT INTO bhi_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ए भगवान बास! जी कळी नी घड़ाय ने पेहलुत मारे सी परम राखलु छे, ने सेक-सींगार आपलु छे। जे माणसे तु मेसेक आपलु छे, चे बी मे जां रहो चां रहणु चाहजे काहाकी चे बी मारु सेक-सींगार देखे। ");
INSERT INTO bhi_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ए धरमी भगवान बास! ईनी कळीन माणसे तुसे नी जाणता बाकुन मे तुसेक जाणो ने मारा चेला जाण लेदला छे, ईसु भगवानेन मकेल्‌लु मसी छे। ");
INSERT INTO bhi_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","मे तारो नाव ईनुक बताड़ देदु ने बताड़तु रय्‌स, काहाकी जसु तु मेसेक मारे सी परम करलु, चु परम हींद्‌रेम रव ने मे हींद्‌रेम रहो।” ");
INSERT INTO bhi_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ईसु आपसा भगवान बास धड़े दुवा करीन नवराय गुयु, ने तेरा चेला पुठ्‌ये एक खुदराक एणकीन एक वाड़ी मां गुयु। तीना खुदरान नाव कीदरोन हतलो। ");
INSERT INTO bhi_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ईसु आपसा चेला पुठ्‌ये ईनी वाड़ी मां एकदम जाया करतेलु। ने ईसुक धुकुदीन धराड़ने वाळु चेलु यहुदा, बी ईनी वाड़ीक देख रवलु। ");
INSERT INTO bhi_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","अळतेन यहुदा, रोमी सीपायड़ान टुळा काजे लीन, ने मंदीरेन डाहला पुजारा ने फरीसी माणसेन साहरे मकेल्‌ला मंदीरेन राखवाळ्‌या सीपायड़ा काजे लीन तीनी वाड़ी मां आय गुयु। चे कंदल्‌या, बेर्‌या ने हत्‌यार लीन आवला। ");
INSERT INTO bhi_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","मारे पर काय-काय वीतसे च आखो जाणीन ईसु अघु गुयु। ने तीनु काजे कह्‌यु, “तुहुं कुणीक हेर र्‌या?” ");
INSERT INTO bhi_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","चे तीनाक जपाप आप्‌या “ईसु नासरी काजे, ईसु तीनुक कह्‌यु मे छे।” तीनाक धराड़ने वाळु यहुदा बी तींद्‌रे धड़े उबु हय रवलु। ");
INSERT INTO bhi_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","जत्‌यार ईसु कह्‌यु की, “मेत छे” ती चे पछास हय्‌न धरती पर हीट पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ईसु तीनुक अळी पुछ्‌यु, “तुहुं कुणीक हेर र्‌या?” चे कह्‌या, “नासरत सहर वाळा ईसु नासरी काजे हेर र्‌या।” ");
INSERT INTO bhi_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ईसु जपाप आप्‌यु मे तुहुं काजे पेहलुत कय देदु की चु मे हयुत छे, “कदी तुहुं मेसेक हेर र्‌या ती तुहुं मारा ईनु चेला काजे जाणी देवु।” ");
INSERT INTO bhi_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ज असो काहा हयो की ज चु कह्‌यु पुरो हवणु चाहजे, “तीनुक चु मारे सुपरुत करलु छे, मे तीनु मायन एक काजे बी खुवायणी नी दम।” ");
INSERT INTO bhi_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","तत्‌यार सीमोन पतरस आपसी तलवार मीयान मां सी नीकाळीन मंदीरेन डाहला पुजारा मुख्‌यान पावर्‌यान देदु। ने तेरो जेवड़्‌यु कान्‌टु काट नाख्‌यु तीना पावर्‌यान नाव मलखुस हतलो। ");
INSERT INTO bhi_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ने ईसु पतरस काजे कह्‌यु, “तलवार मीयान मां पछी भर ले। ज दुखेन पीयालु भगवान बास मेसेक पीणे करीन आप्‌लु छे च दुखेन पीयालु मां पीये करीन तु अड़चन काहा नाख र्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","अळतेन रोमी सीपायड़ान टुळु, ने तींद्‌रु सुबेदार, ने यहुदी डाहला सी मकेल्‌लु मंदीरेन राखवाळ्‌या सीपायड़ा ईसु काजे धरीन बांद लेदा। ");
INSERT INTO bhi_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ने ईसु काजे धरीन पेहेल मेहेल ते हन्‌ना धड़े लीजा, जु मंदीरेन डाहला पुजारान मुख्‌यी पुजारु हतलु, काहाकी चु हन्‌ना, काइफान सेसरुस हतलु, चु काइफा तीने साल मंदीरेन डाहला पुजारान मुखी हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","जु हयुत काइफा हतलु, चु यहुदी मुख्‌याक असु कय्‌न अगवाय करलु की आपणा माणसे भीणी एक माणुस मरनु वारु छे। ");
INSERT INTO bhi_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","सीमोन पतरस ने एक अळी दीसरु चेलु ईसुन पछळ-पछळ चाल पड़्‌यु, चु दीसरु चेलु डाहला पुजारान मुख्‌यु हन्‌नान उळखायतु हतलु, ने चु चेलु ईसु पुठ्‌ये मंदीरेन डाहला पुजारान मुखीन घरेन आंगणाम लग गुयु, हीनाक कुय बी नी रुक्‌यो। ");
INSERT INTO bhi_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","बाकुन पतरस झपले उबु रय गुयु, ने डाहला पुजारान उळखायतु, चु दीसरु चेलु तीने आंगणे सी पछु खयड़े जाय्‌न झपलान राखवाळ्‌या काजे पुछीन पतरस काजे माहें आंगणाम ली आयु। ");
INSERT INTO bhi_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ची झपलान राखवाळी पावरनी पतरस काजे कह्‌यी, “तु बी तीनु ईसुन चेला मायन नी हय काय?” पतरस कह्‌यु, “नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","सींगेन दाहड़ा हतला, ने घरेन पावर्‌या ने मंदीरेन राखवाळ्‌या सीपायड़ा आकठे तापणे बाजी रवला ने पतरस बी तींद्‌रे पुठ्‌ये तापतेलु। ");
INSERT INTO bhi_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","अळतेन मंदीरेन डाहला पुजारान मुखी हन्‌ना ईसु काजे चेलान बारामां ने तेरी सीकाड़ली वातेन बारामां पुछ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ईसु जपाप आप्‌यु, “मे मनेन काय बी, नी सीकाड़्‌यु, मे माणसे अगळ उजेंतु कळी मां सीकाड़लु छे; ने मे जलम तुंद्‌रा भक्‌तीन घर मां ने मंदीर मां जां आखा यहुदी भेळा हया करे चां सीकाड़तु रयु। ");
INSERT INTO bhi_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ती तु मेसेक काहा पुछ र्‌यु? सामळन्‌याक असु पुछु की, हयु तुहुंक काय सीकाड़लु छे मे तीनुक काय कहंलु तीनुक मालुम छे।” ");
INSERT INTO bhi_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","जत्‌यार ईसु जी वात कह्‌यु ती चां उबा हय रवला मंदीरेन राखवाळ्‌या सीपायड़ा मायन एक जणु ईसुन एक थापड़ देदु। ने कह्‌यु, “तु ते मंदीरेन मुखी पुजारा काजे असु जपाप काहा दी र्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ईसु तीनाक जपाप आप्‌यु, “कदी मे काय गलत वात कह्‌यु हय, ती पुरावु दीन देखाड़; बाकुन छाचली वात कह्‌यु हय ती मारे काहा देय?” ");
INSERT INTO bhi_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","अळतेन हन्‌ना ईसु काजे असुत बांदायलुत मंदीरेन डाहला पुजारान मुखी काइफान्‌चां मकली देदु। ");
INSERT INTO bhi_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","तीने टेमे सीमोन पतरस, आकठा धड़े उबु-उबु तापणे बाजी रवलु। तत्‌यार थुड़ाक माणसे पतरस काजे कह्‌या, “तु बी तेरा चेला मायन एक छे काय?” पतरस ईसुन नीकारु करतु जाय्‌न कह्‌यु मे नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","मंदीरेन मुखी पुजारान एक पावर्‌यु, चु तीना पावर्‌यान दुस्‌ती बी हतली, तेरु कान्‌टु पतरस काट नाखलु, “चु पतरस काजे कह्‌यु मे तुसेक तीना ईसु पुठ्‌ये वाड़ी मां देखलु?” ");
INSERT INTO bhi_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पतरस ईसुन अळी नीकारु करतु जाय्‌न कह्‌यु, “मे नी हय” ने तत्‌यारुत कुकड़ु वास देदु। ");
INSERT INTO bhi_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","अळतेन यहुदी मुख्‌या ने डाहला पुजारा ईसु काजे काइफान घर मां सी रोमी सरकारेन यरुसलेम राजवाड़ान हवेली वाळा कीलान आंगणाम ली गुया, ने तीने टेमे काय संदारो हय वाग्‌लो ईना रोमी राजवाड़ान राज करन्‌यु पीलातुस नी भुरसु वाळा यहुदी आड़जात्‌या बी हतला, ने यहुदी मुख्‌या ने पुजारा वीच्‌यार कर्‌या की हामु ईना आड़जात्‌या पीलातुसेन हवेली मां भरायसु ती हामु वीटळी जासुन। ने हामुक हामरा फसह तीहवारेन खाणो नी खावाये करीन चे यहुदी मुख्‌या ने पुजारा तीनी हवेली मां नी भराय। ");
INSERT INTO bhi_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ने राज करन्‌यु पीलातुस हवेलीम सी बाहर नीकळीन तींद्‌रे अगळ आयु ने कह्‌यु, “तुहुं ईना माणुस पर काहनु गुनु लागाड़ र्‌या?” ");
INSERT INTO bhi_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","चे जपाप आप्‌या, “कदी जु गुनाळु नी रहतु, ती हामु हीनाक तारेन चां नी लावता।” ");
INSERT INTO bhi_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पीलातुस तीनुक कह्‌यु, “तुहुंत ईनाक ली जावु, ने तुंद्‌रा कायदान अनसारे हेरु नीयाव करजु।” यहुदी मुख्‌या कह्‌या “हामुक हक नी हय की काहनाकेन जीव लेणु।” ");
INSERT INTO bhi_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","मारी मोत कसी हवसे करीन ईसु पेहलुत तेरा चेला काजे कहंलु। ने ईसुन कहला बुलेन अनसारे आखो हयो ने तेरेत अनसारे हय बी यहुदी मुख्‌या तीनाक मुतेन डंड आपाड़ने करीन पीलातुस साते वात कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","अळतेन पीलातुस अळी पछु हवेली मां जात र्‌यु, ने ईसु काजे बुलायु ने तीनाक पुछ्‌यु, “तु यहुदी माणसेन राजु छे काय?” ");
INSERT INTO bhi_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ईसु पीलातुस काजे जपाप आप्‌यु, “जी वात तु आपसे आवड़तेत कय र्‌यु की मार बारामां काहना दीसरा तुसेक कहंला छे?” ");
INSERT INTO bhi_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पीलातुस ईसुक जपाप आप्‌यु, “मे यहुदी छे काय? तारीत जातीन माणसे, मंदीरेन डाहला पुजारा भेळा भेसकायन तुसेक धराय्‌न मारे सुपरुत करला छे। तु काहनु गुनु करलु छे?” ");
INSERT INTO bhi_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ईसु कह्‌यु, “मारो राज ईनी कळीन राजान तसों नी हय। कदी मारो राज, ईनी कळीन राजा तसों रहतो, ती मारा राखवाळ्‌या सीपायड़ा मारे वाटे लड़ाय करता, ने मे यहुदी माणसेन हातेम नी धरायतु। बाकुन मारो राज ईनी कळीन राजान तसों नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","च सामळीन पीलातुस ईसुक कह्‌यु, “ती, तु छाचलीन राजा छे काय?” ईसु पीलातुस काजे जपाप आप्‌यु, “तु वारुत कय र्‌यु काहाकी मे राजा छे ने मे छाचली वात ने गवा पुरावा आपणे करीन ईनी कळी मां पयदा हय्‌न आवलु छे ने जीत छाचली छे चु मारी वात सामळीन पाळे।” ");
INSERT INTO bhi_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“पीलातुस ईसु काजे पुछ्‌यु छाचली काय छे?” ज पुछीन पीलातुस अळी हवेलीम सी बाहर नीकळीन यहुदी मुख्‌या अगळ आवीन कह्‌यु, मेसेक ते हीना माणुस मां काय बी गुनु नी देखायतु। ");
INSERT INTO bhi_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","बाकुन तुंद्‌री रीतीन अनसारे मे तुंद्‌रे वाटे फसह तीहवारेन टेमे एक केदड़ा काजे जेल मां सी छुड़तेलु, “ने तुंद्‌री मरजी हय ती तुंद्‌रे वाटे यहुदीन राजाक छुड़ दम?” ");
INSERT INTO bhi_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ज सामळीन चे एक कावा अळी आयड़ीन कह्‌या, “हीनाक मां छुड़े, बाकुन बरअब्‌बा काजे छुड़ दे।” ने चु बरअब्‌बा एक डाकु हतलु। ");
INSERT INTO bhi_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","अळतेन पीलातुस ईसु काजे लीजाय्‌न सुटा देवाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ने सीपायड़ा काटाळ्‌या वेळान मुळ्‌यो गुथीन ईसुन मुणका पर मेक देदा ने जामण्‌यो झगल्‌यो पेहराया। ");
INSERT INTO bhi_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ने ईसु धड़े आवीन ईसुक हास्‌ता जाय्‌न कह्‌णे बाजी गुया, “ए यहुदी माणसेन राजा, वारु छे की!” ने चे तीनाक थापड़ाया। ");
INSERT INTO bhi_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","पीलातुस अळी बाहर जाय्‌न माणसेक कह्‌यु, “देखु, मारी नींगा मां हेरेम काय बी खुड़ नी देखाव पड़तु, ज तुहुं बी जान्‌नु चाहजे, करीन मे तीनाक अळी बाहर लावलु।” ");
INSERT INTO bhi_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","तीने टेमे ईसुन मुणका पर काटाळ्‌या वेळान मुळ्‌यो मेकलोत हतलो, ने तीनाक जामण्‌यो झगल्‌यो पेहरावलोन हतलो, तसुत चु बाहर आयु ने पीलातुस माणसेक कह्‌यु देख, “हयुत छे चु माणुस!” ");
INSERT INTO bhi_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","मंदीरेन डाहला पुजारा ने मंदीरेन राखवाळ्‌या सीपायड़ा ईसु काजे देखीन, पीलातुस अगळ असा आयड़ी पड़्‌या की, “हीनाक कुरुस पर टांगीन खीळा ठुकीन मार देवु!” हीनाक कुरुस पर टांगीन खीळा ठुकीन मार देवु! पीलातुस तीनुक कह्‌यु, “मारी नींगा मां हेरेम काय बी खुड़ नी देखाव पड़तु ने ईनाक तुहुंत ली जावु ने तुहुंत ईनाक कुरुस पर टांगीन खीळा ठुकीन मार देवु!” ");
INSERT INTO bhi_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहुदी मुख्‌या कह्‌या, “हामरे धड़े मुसान लिखला नीयम छे, तेरे अनसारे ईनाक मुतेन डंड जड़नु चाहजे, काहाकी आपसुत भगवानेन पुर्‌यु हवणेन दावु करलु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","पीलातुस तींद्‌री जी वात सामळीन अळी बी बीही गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","चु अळी हवेलीन आंगणाम ली जाय्‌न तीनाक पुछ्‌यु, “तु कां सी आवलु छे?” बाकुन ईसु तीनाक काय जपाप नी आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ने पीलातुस ईसुक कह्‌यु, “तु मेसेक जपाप काहनी आपतु तुसेक नी मालम हय काय, की मारे भीणी तुसेक छुड़नेन हक छे नीते, ईना कुरुस पर टांगीन खीळा ठुकीन मार देवु, असु हुकुम आपणेन बी हक छे।” ");
INSERT INTO bhi_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ईसु पीलातुस काजे जपाप आप्‌यु, “कदी तुसेक उपर सरगे सी हक नी जड़तु ती तारु मारे पर काहनु बी हक नी रवतु ने चु मेसेक धराड़ीन तारे सुपरुत करलु छे, माणुस बेसकु पापी छे।” ");
INSERT INTO bhi_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ईसुन जी वात सामळीन पीलातुस, “ईसु काजे छुड़नेन वीच्‌यार कर्‌यु, बाकुन यहुदी मुख्‌या आयड़ी आयड़ीन कह्‌या, जु आपसा काजे राजा कह्‌वे चु आपणा रोमी राजान वीरुद करे। ने तीनाक डंड जड़नु चाहजे कदी तु ईनाक छुड़ देसी ती तु आपणा रोमी राजान दुस्‌तीदार नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","जी वात सामळीन पीलातुस ईसु काजे बाहर गब्‌बता नावेन जागा पर बुलायन ईब्‌रानी बुली ईना नावेन मतलब, “दगड़ान पयड़ी” हतलो ने पीलातुस तीना जागा पर आपसी नीयावेन गादी पर बस गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","जु दाहड़ु, फसह तीहवारेन हाप्‌ताम वाळा आरामेन दाहड़ान तीयारीन दाहड़ु हतलु। ने मांजणीक टेम हय रवली, तत्‌यार पीलातुस यहुदी माणसेक कह्‌यु, “देखु, हयुत छे तुंद्‌रु राजा!” ");
INSERT INTO bhi_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ती यहुदी मुख्‌या अळी आयड़ीन कह्‌या ईनाक जां सी लीजा! ईनाक जां सी लीजा! “ने ईना कुरुस पर टांगीन खीळा ठुकीन मार देवु!” पीलातुस तीनु काजे पुछ्‌यु, “मे तुंद्‌रा राजा काजे कुरुस पर टांगीन खीळा ठुकाड़ो काय?” मंदीरेन डाहला पुजारा कह्‌या, “रोमी राजा काजे छुड़ीन हामरु काहनु राजा नी हय।” ");
INSERT INTO bhi_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","पीलातुस ईसु काजे तींद्‌रे हातेम आप देदु, हेरेन करीन की, चे तीनाक कुरुस पर मार देय। ");
INSERT INTO bhi_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ने ईसु सीपायड़ान कह्‌णेन अनसारे कुरुस हाकलीन चालतु-चालतु ईब्‌रानी गुलगुता नावेन जागा पर गुयु। यहुदी माणसेन बुली मां ईना नावेन मतलब मुणको हतलो। ");
INSERT INTO bhi_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","तीना जागा पर ईसु काजे ने तेरे भेळा दुय गुना वाळा माणसे काजे कुरुस पर टांगीन खीळा ठुक्‌या। ईचमां ईसु काजे ने एक काजे ईसुन डाखर्‌ये आंग्‌ये ने एक काजे जेवड़्‌ये आंग्‌ये कुरुस पर टांगीन खीळा ठुक्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पीलातुस एक लाकड़ान पट्‌टी पर ईसुन बारामां लिखाड़ीन तेरा मुणका सी उपर कुरुस पर ठुकाड़ देदु। तीनी पट्‌टी पर असो लिखलो हतलो, “ईसु नासरी यहुदी माणसेन राजा।” ");
INSERT INTO bhi_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ने जी वात ईब्‌रानी बुली मां, ने लातीनी बुली मां, ने युनानी बुली मां लिखली हतली। चां ईसु काजे कुरुस पर टांगीन खीळा ठुकला हतला, चु जागु सहरे धड़े हतलु ने बेसका यहुदी माणसे जी वात लिखली भण्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","यहुदी मुख्‌या मायन डाहला पुजारा काजे जी लिखली वात नी जमी ने चे पीलातुस काजे कह्‌या, “यहुदी माणसेन राजा असा मां लिखु बाकुन असो लिखु की हयु कह्‌यु की मे यहुदी माणसेन राजा छे।” ");
INSERT INTO bhi_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पीलातुस तीनुक जपाप आप्‌यु, “मे ज लिखाड़ देदु चत रवसे।” ");
INSERT INTO bhi_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","अळतेन सीपायड़ा ईसु काजे कुरुस पर टांगीन खीळा ठुकीन नवराय गुया, तत्‌यार चे ईसुन पुथल्‌यान चार वाटा पाड़्‌या एक-एक सीपायड़ा वाटे एकेक वाटु पाड़्‌या बाकुन ईसुन झगल्‌यो सीवीन बणावलो नी हतलो, बाकुन आखो की आखो गुथीन बणावलो हतलो। ");
INSERT INTO bhi_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ने चे वीच्‌यार करीन कह्‌या, आपणु हीना पुथल्‌याक नी फाड़ता, बाकुन चिट्‌ठी नाखीन देख लेता की ज कुणीक जड़से ज असो काहा कर्‌या की खरला सास्‌तुर मां लिखली वात ची पुरी हवे: “चे वेरी माणसे मारा पुथल्‌याक वाट लेदा, ने चे मारा पुथल्‌या वाटे चिट्‌ठी बी नाख्‌या।” ने छाचलीन सीपायड़ा असा की असा कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ईसुन कुरुस धड़े ईसुन माय ने ईसुन मायन बहणीस ने काइफान घरवाळी मरीयम मगदलनी मरीयम उभी हय रवली। ");
INSERT INTO bhi_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","जत्‌यार ईसु चां आपसी माय काजे देख्‌यु ने तीना चेलाक बी देख्‌यु, जु ईसुन लाटेक्‌लु चेलु कहवायतेलु, ती चु आपसी माय काजे कह्‌यु, “ओ माय! देख, हयु तारु बेटु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","अळतेन तीना चेलाक कह्‌यु, हयी तारी माय छे ने तीने टेम सी चु चेलु ईसुन माय काजे आपसी माय मान लेदु। ने आपसे घर ली जाय्‌न तेरी सेवा चाकरी करने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","अळतेन ईसु ज जाण गुयु की, हय आखो काय पुरो हय गुयलो छे ने खरला सास्‌तुर मां पेहलुत सी लिखलो हतलो, च पुरो करने करीन कह्‌यु, “मे तीसलु छे।” ");
INSERT INTO bhi_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","चां एक ठाहरु हतलु तीना ठाहरा मां अंगुरेन कड़वलु रस भर रवला ने चे सीपायड़ा कड़वला रस मां एक पुतो डुबाड़ीन तीना पुताक जुफा नावेन झाड़कान एक सुट्‌ये झेलाड़ीन ईसुन मुंहडे टेकी देदा। ");
INSERT INTO bhi_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","तत्‌यार ईसु अंगुरेन कड़वलु रस चाख्‌यु ती कह्‌यु, “पुरो हय गुयो।” ने आपसो मुणको हेटु वाळ लेदु ने आपसु जीव-आत्‌मा भगवान काजे आप देदु। ");
INSERT INTO bhi_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","चु दाहड़ु फसह तीहवारेन हाप्‌तान वाळान खास आरामेन दाहड़ान तीयारीन दाहड़ु हतलु। आरामेन दाहड़े ईसुन ने दीसरा गुना वाळा धड़े कुरुस पर टांगलो नी रहणु चाहजे करीन यहुदी माणसे पीलातुस सी आवीन वीन्‌ती कर्‌या की कुरुस पर टांगीन खीळा ठुकला माणसेन पायेन हाटका तुड़ाय दे। ने तींद्‌रो धड़ कुरुस पर सी उतार मांग। ");
INSERT INTO bhi_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","सीपायड़ा आवीन ईसुन आड़े-धड़े कुरुस पर टांगीन खीळा ठुकला माणसेन पायेन हाटका टुकड़ा-टुकड़ा कर देदा। ");
INSERT INTO bhi_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","बाकुन अळतेन चे ईसु धड़े आवीन देख्‌या ती तीनुक मालम पड़्‌यो की चु मर गुयु ने चे तेरा पाय नी तुड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","बाकुन तीना सीपायड़ा मायन एक सीपायड़ु ईसुन काखे भालु घुदल्‌यु ने कुखेम सी तत्‌यारुत लुही ने पाणी नीकळ्‌यो। ");
INSERT INTO bhi_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","जतरा बी ज देख्‌या, चे गवाय देदा, ने तींद्‌री गवाय संय छे ने चु जाणे की चे संय कवे की तुहुं बी भुरसु करु। ");
INSERT INTO bhi_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","जी वात तेरेमां हय की चुखला सास्‌तुर मां ज कहलो छे, च पुरो हवसे, “तेरा कुय हाटका बी नी तुड़े।” ");
INSERT INTO bhi_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","पछेन एक अळी जागा पर ज लिखलो छे, “तीनाक चे गुपला छे, तीना पर चे नींगा करसे।” ");
INSERT INTO bhi_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ज आखो हय गुयो ने अळतेन अरीमतीया सहर वाळु युसुफ चु ईसुन चेलु हतलु, बाकुन यहुदी माणसेन धाके काहनाक बी नी कह्‌तेलु की मे ईसुन चेलु छे, बाकुन हय चु चेलु पीलातुस वीन्‌ती कर्‌यु की मेसेक ईसुन धड़ काजे गाड़ने ली जान दे, ने पीलातुस तेरी सामळी लेदु। ने चु युसुफ आवीन ईसुन धड़ ली जात र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","नीकुदेमुस चु एक दाहड़ु राती वेळाय, ईसु काजे भेळु हवणे आवलु, चु बी चां एक सोव ने पंद्‌रे कीलु ईत्‌तर ने एलवो लीन आयु। ");
INSERT INTO bhi_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ने यहुदी माणसे जसा मरला माणसेन धड़ काजे गाड़ने ली गुया तसात चे ईसुन धड़ काजे वारु गंदायण्‌यु मसालु चुपड़्‌या ने धवळा पुथल्‌या मां गुचवी देदा। ");
INSERT INTO bhi_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","तीना जागा मां ईसु काजे कुरुस पर टांगीन खीळा ठुकला तीनात जागा धड़े वाड़ी हतली, ने तीनी वाड़ीन खंगराम एक नवलो बीड़ो खुदलो हतलो, तीना बीड़ा मां हय लग कुय काजे गाड़्‌या नी। ");
INSERT INTO bhi_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","हय यहुदी माणसेन आरामेन तीयारीन दाहड़ु खत्‌तम हवणे वाळु हतलु, ने आरामेन दाहड़ु सुरु हवणे वाळु हतलु। ने जो मसाण्‌या धड़ेत हतलो, करीन नीकुदेमुस ने युसुफ ईसुन धड़ काजे तीनात मसाण्‌या मां मेल देदा। ");
INSERT INTO bhi_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","हाप्‌तान पेहले दाहड़े संदारे एगीत, मरीयम मगदलनी मसाण धड़े आवी, ने ची मसाण पर सी चापर्‌यु दगड़ु छेटे करलो देखी। ");
INSERT INTO bhi_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ची सीमोन ने पतरसेन्‌चां ने दीसरा चेलान चां दवड़ीन आवी, चु ईसुन लाटेक्‌लु चेलु कहंवायतेलु। ने ची तीनुक कही काहनाक माणसे मालीक ईसुन धड़ काजे मसाण सी नीकाळीन ली जात र्‌या। ने हामुक मालम नी हय की चे तीना धड़ काजे कां मेक र्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","तत्‌यार पतरस ने ईसुन दीसरु चेलु मसाण भीणी दवड़ी पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","चे दुय भेळा दवड़्‌या बाकुन दीसरु चेलु पतरस काजे पछळ नाख दीन पेहलुत मसाण धड़े पुग गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","चु ढंगु अळीन लेफड़्‌या पुथल्‌यान देख्‌यु बाकुन मसाणेन खंगरा मां माहें नी भरायु। ");
INSERT INTO bhi_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","सीमोन पतरस तेरे पछळ-पछळ आयु, ने अळतेन मसाण धड़े गुयु मसाण खंगरा मां माहें गुयु, ने चु लेफड़्‌या पुथल्‌यान पड़ रवलु देख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ईसुन मुंहडा पर फेटको बांदलो हतलो च फेटको लेफड़्‌या पुथल्‌यान भेळतो हतलो, बाकुन दीसरे जागे दुर करीन मेल्‌लो देखाव पड़्‌यो। ");
INSERT INTO bhi_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ती चु दीसरु चेलु जु मसाण धड़े पेहलुत पुगी गुयलु, चु बी मसाणेन खंगरा मां माहें गुयु ने पुथल्‌यो देख्‌यु ने चु चेलु असु भुरसु कर्‌यु की ईसु पछु जीवतु हय्‌न बठु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ज हवणेन पेहेल तीनुक जी वात समज मां नी आवी की, खरला-सास्‌तुरेन अनसारे ईसुन मर्‌या-सर्‌याम सी जीवतु हय्‌न बठु हवसे। ");
INSERT INTO bhi_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ने चे दुय चेला आपसा-आपसा जागा पर जात र्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","मरीयम मगदलनी मसाण धड़े खयड़े रड़तेली, ने ची रड़ती-रड़ती ढंगी अळीन मसाण मां माहें नींगा करी। ");
INSERT INTO bhi_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ने तीना जागा पर ईसुन धड़ मेलायलो हतलो, चां ची उजळा पुथल्‌या पेहर रवला दुय सरग वाळा चाकर्‌या काजे देखी एक काय मुणका भीणी ने एक पायाता भीणी बस रवला देखी। ");
INSERT INTO bhi_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","चे दुय सरग वाळा खबर लावण्‌या तीनी काजे कह्‌या, “ओ बायर जात! तु काहा रड़ रय?” ची कय “चे मारा मालीक काजे हाकली ली गुयला छे ने मेसेक नी मालम हय की चे तीनाक कां मेल र्‌या!” ");
INSERT INTO bhi_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ज कयदीन ची पछी फीरीन भाळी ने ची ईसु काजे उबु हय रवलु देखीम, बाकुन तीनीक जु ईसु छे करीन उळखायो नी। ");
INSERT INTO bhi_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ईसु तीनी काजे कह्‌यु, “ओ बायर जात तु काहा रड़ रय कुणीक हेर रय?” ची मरीयम तीनाक वाड़ीम काम करन्‌यु पावर समजीन तीनाक कय, “ए दादा! कदी तु तीना काजे ली गुयु हय ती मेसेक कय दे की तु तीनाक कां मेल र्‌यु ने तीनाक ली आवीस।” ");
INSERT INTO bhi_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ज सामळीन ईसु तीनीक कह्‌यु, “ओ मरीयम!” ची पछी फीरीन ईसुक उळखीन तीनाक ईब्‌रानी मां कय, “रबी।” यहुदी माणसेन बुली मां ईना बुलेन मतलब ए गुरु हतलो। ");
INSERT INTO bhi_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ईसु तीनी काजे कह्‌यु, “मे हय लग भगवान बासेन चां उपर सरग मां नी गुयु। ने मेसेक छीमीन मां रुके, बाकुन मारा भायसेन चां जाय्‌न तीनु काजे ज कय दे, की ईसु कय र्‌यु की, मे मारा भगवान बासेन्‌चां जाणे हींड र्‌यु, हयु हय सी तुंद्‌रु बी भगवान बास छे।” ");
INSERT INTO bhi_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरीयम मगदलनी जाय्‌न जी वात चेला काजे कय की “मे मालीक काजे देखली छे, ने चु मेसेक बी वात कय मकल्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","तीने दाहड़े, हाप्‌तान पेहले दाहड़े सांती वेळाय ईसुन चेला यहुदी माणसेन धाके आपसात बारनो दीलीन घरमां कुंडाय रवला। ने ईसु तींद्‌रे ईचमां आय्‌न उबु हय गुयु, ने चेला काजे कह्‌यु “तुहुंक सांती जड़े!” ");
INSERT INTO bhi_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ज कयदीन ईसु आपसा हातेन घाव, ने आपसी कुखेम घाव देखाड़्‌यु, ती तेरा चेला मालीक ईसु काजे देखीन खुस हय गुया। ");
INSERT INTO bhi_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ने ईसु तीनुक अळी कह्‌यु, “तुहुंक सांती जड़े! असु भगवान बास मेसेक मकेल्‌लु छे तसुत मे बी तुहुंक मकलो।” ");
INSERT INTO bhi_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ज कयदीन ईसु तीनु पर फुक्‌यु ने तीनुक कह्‌यु, “लेवु, जी चुखली-आत्‌मा, तुंद्‌रा जीवन मां ली लेवु। ");
INSERT INTO bhi_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","तुहुं जीनु माणसेक पापेन माफी आपसु, तीनु माणसेक पापेन माफी जड़ जासे, ने तीनुक माणसेक तुहुं पापेन माफी नी आपु तीनु माणसेक पापेन माफी नी जड़े।” ");
INSERT INTO bhi_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","जत्‌यार ईसु चेला धड़े आयु ती थोमा तींद्‌रे भेळु नी हतलु चु बी बारे चेला मायन एक हतलु, चु दीद्‌मुस कहवाये। ");
INSERT INTO bhi_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","दीसरा चेला तीनाक कह्‌या, “हामु मालीक ईसु काजे देखला छे।” ती चु कह्‌यु, “जत्‌यार लग मे तेरा हातेम खीळान घाव नी देख लम ने खीळा सी पड़लो घावेम मारी आंगळी नी नाख दम ने तेरा कुखेम पड़ला घाव मां मारु हात नी नाख दम तत्‌यार लग मे भुरसु नी करो।” ");
INSERT INTO bhi_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","आंठ दाहड़ा हय गुया, ने अळतेन ईसुन चेलान अळी घरमां हतला, ने थोमु बी तींद्‌रे भेळु हतलु तीने टेमे घरेन बारनो देदलो हतलो, तेबी ईसु तींद्‌रे ईचमां आवीन उबु रय गुयु ने कह्‌यु, “तुहुंक सांती जड़े!” ");
INSERT INTO bhi_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ती ईसु थोमा काजे हेरा हात देखाड़ीन कह्‌यु, “तारी आंगळी ईनु हातेन घाव मां नाख ने आपसु हात उरु कर ने मारा कुखेम वाळा घाव मां तारु हात नाख। ने तु नी भुरसु वाळु मां बणे बाकुन मारे पर भुरसु कर।” ");
INSERT INTO bhi_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","थोमा ईसु काजे जपाप आप्‌यु, “ए मारा मालीक! ए मारा भगवान!” ");
INSERT INTO bhi_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ती ईसु थोमा काजे कह्‌यु तु ते मेसेक देखीन मारे पर भुरसु करलु छे। बरकतवाळ चे छे, जे मेसेक नी देख्‌या बाकुन मार पर भुरसु करे। ");
INSERT INTO bhi_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ईसु आपसा चेला अगळ अळी बेसका मटा कामेन सहलाणी देखाड़्‌यु बाकुन तीनु मटा कामेन सहलाणीन बारामां ईनी किताप मां लिखलो नी हय। ");
INSERT INTO bhi_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","बाकुन जी वात जां असो करीन लिखली छे की तुहुं जु भुरसु करु की ईसुत भगवानेन पुर्‌यु मसी छे, ने तेरे पर भुरसु करीन तेरे नावे सी अमर जीवन हात कर लेय। ");
INSERT INTO bhi_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","तीबीरीयास दरीया धड़े ईसु अळी आपसा चेला काजे ईनी रीती अळी उजेंतु देखाव पड़्‌यु, ");
INSERT INTO bhi_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","एक दाहड़े, सीमोन पतरस, ने थोमा, चु दीद्‌मुस कह्‌वाये नतनएल चु गलील जीलान काना सहर वाळु हतलु ने जब्‌दीन दुय पुर्‌या ने ईसुन दुय दीसरा चेला, जे आखा भेळात हतला। ");
INSERT INTO bhi_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","सीमोन पतरस तीनु काजे कह्‌यु, “मे ते माछा मारने जाम। ने चे दीसरा चेला काजे कह्‌या।” “हामु बी तारे पुठ्‌ये आवजे।” ने चे तेरे पुठ्‌ये चाल पड़्‌या, ने ढंड्‌या मां चहड़ीन बठ गुया, बाकुन तीने राते एक बी माछी हात नी लागी। ");
INSERT INTO bhi_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","संदारे हवतात ईसु दरीया धड़े आय्‌न उबु रय गुयु, बाकुन चेला काजे ईसु नी उळख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","तत्‌यार ईसु तीना चेला काजे कह्‌यु, “ए पुर्‌या! तुहुं काजे खाणे करीन एक बी माछी नी धराय काय?” चे चेला जपाप आप्‌या, “एक बी नी धराय!” ");
INSERT INTO bhi_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","तत्‌यार ईसु तीनु काजे कह्‌यु, “ढंड्‌यान जेवड़्‌ये आंग्‌ये जाळ नाखु ने तुहुंक माछा हात लागसे।” चे जाळ नाख्‌या ने अतरा माछा जाळेम आया की तीनुक जाळ नी हाकलाय। ");
INSERT INTO bhi_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","तत्‌यार चु चेलु, जु ईसुन लाटेकलु चेलु, “कह्‌वायतेलु, पतरस काजे कह्‌यु, जु ते आपणु मालीक ईसुत छे।” जत्‌यार सीमोन पतरस सामळ्‌यु की जु आपणु मालीक ईसुत छे ती चु नांगरलु हतलु करीन आपसो झगल्‌यो पेहरी लेदु ने ईसुक भेळु हवणे करीन दरीया मां मामार कुद पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","बाकुन दीसरा चेला, माछा भरायली जाळ काजे हाकलता जाय्‌न ढंड्‌या काजे दरीया धड़े लाया। काहाकी चे दरीया धड़े सी जादा छेटा नी हतला। चे दरीया धड़े सी दुयेक सोव हात छेटा हतला। ");
INSERT INTO bhi_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","जत्‌यार चे ढंड्‌याम सी उतरीन धड़े भुयमां आया, ती तीनुक चां रुटा ने धपतेला कुयलान ईंगाळा पर माछा मेकला देखाव पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ईसु तीनु काजे कह्‌यु, “तुहुं हींताळ जे माछा धरला छे, तीनु मायन थुड़ाक ली आवु।” ");
INSERT INTO bhi_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","सीमोन पतरस पछु ढंड्‌या मां गुयु, ने जाळ धड़े हाकली लायु। तीनु जाळेम डेड़ सोव ने तीन मटला माछा पड़ला हतला, ने अतरा माछा जाळेम पड़्‌या तेबी जाळ नी फाटी। ");
INSERT INTO bhi_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ईसु तीनु काजे कह्‌यु, “आवु, ईतरोक खाय लेवु।” चेला जाण लेदा की जु मालीक ईसुत छे। ने “तु कुण छे।” करीन ईसु काजे पुछणे, तीनु मायन कुय काजे बी हिम्‌मत नी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ईसु धड़े आयु, ने खाणे करीन चु रुटु हातेम लीन तीनुक आप्‌यु, ने ईनी रीते माछा आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","असु करीन मर्‌या-सर्‌याम सी जीवतु हय्‌न ईसु तीसरी कावा आपसा खास चेला अगळ उजेंतु देखाव पड़लु। ");
INSERT INTO bhi_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","खायलीन नवराय्‌न ईसु, सीमोन पतरस काजे पुछ्‌यु, “ए सीमोन, युहन्‌नान पुर्‌या! तु छाचलीन, हींद्‌रे सी जादा मेसेक परम करे काय?” पतरस ईसुक कह्‌यु, हव, “मालीक! तु जाणे की मे तारे सी परम करो।” ईसु सीमोन पतरस काजे कह्‌यु, “मारा गाडरा चार।” ");
INSERT INTO bhi_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ईसु दीसरी कावा अळी सीमोन पतरस काजे कह्‌यु, “ए सीमोन, युहन्‌नान पुर्‌या! तु छाचलीन मारे सी परम करे काय?” पतरस ईसु काजे जपाप आप्‌यु, “हव, मालीक! तु जाणे की मे तारे सी परम करो।” ईसु पतरस काजे कह्‌यु, “मारा गाडरान गुवाळी कर।” ");
INSERT INTO bhi_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ईसु अळी तीसरी कावा, पतरस काजे कह्‌यु, “ए सीमोन, युहन्‌नान पुर्‌या! तु छाचलीन मेसेक परम करे काय?” ईसु पतरस काजे तीसरी कावा ज पुछ्‌यु की तु छाचलीन मारे सी परम करे काय? करीन तीनाक बेसको दुख लाग्‌यो। ने पतरस ईसु काजे कह्‌यु, “मालीक! तुसेक आखी वात मालम छे, तु जाणे की मे तारे सी छाचलीन परम करो।” ईसु पतरस काजे कह्‌यु, “मारा गाडरा काजे चार।” ");
INSERT INTO bhi_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","मे तुसेक छाचलीन कहो की जत्‌यार तु जुवान हतलु, ती आपसान कमर बांदीन जाहां बी चाहतेलु चां फीरतेलु, बाकुन जत्‌यार डुकरु हवसी ती आपसा हात फेलावसी ने दीसरा तारी कमर बांदीन जाहां तु नी चाहसी चां तुसे ली जासे। ");
INSERT INTO bhi_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","हयु ईनी वात सी सहलाणी देदु, की पतरस कसु मरनेन सी भगवानेन सेक-सींगार करसे। ने तत्‌यार हयु तीनाक कह्‌यु, “मार कह्‌याम चाल।” ");
INSERT INTO bhi_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पतरस पछु फीरीन ईसुन तीना दीसरा चेला काजे पछळ-पछळ आवतेलु देख्‌यु, चु ईसुन लाटेकलु चेलु कहंवायतेलु। हयु चु की चु हतलु, जु तीहवारेन दाहड़े सांती वेळाय खाणेन टेमे ईसुन छाती भीणी वळीन, “ए मालीक! तुसेक धरावण्‌यु कुण छे?” करीन पुछलु। ");
INSERT INTO bhi_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","अळतेन पतरस तीना चेलाक देखीन ईसु काजे पुछ्‌यु, “मालीक! एरे पर काय वीतणे वाळो छे?” ");
INSERT INTO bhi_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ईसु कह्‌यु, “कदी मेसेक पछु आवता लग हयु जीवतेलु रय जाय, ती ईनी वात सी तारो काय लेण देणु छे? तु ते मरता लग मारा कह्‌याम चालतु रव।” ");
INSERT INTO bhi_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ने ईसु पर भुरसु करन्‌या भायसे मां जी हुकवाय फीर गुय की हयु चेलु नी मरे, “बाकुन ईसु असु नी कह्‌यु की हयु नी मरे बाकुन ज कहंलु की कदी मेसेक पछु आवता लग हयु जीवतेलु रय जाय ती, ईनी वात तारो काय लेण देन छे?” ");
INSERT INTO bhi_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","हयु चु की चु चेलु छे, जु ईनी वातेन गवा देणे करीन जी किताप लिखलु छे। हामु जाणजे की हेरी गवाय छाचली छे। ");
INSERT INTO bhi_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ईसु अळी बी बेसका काम कर्‌यु, कदी एकेक करीन तीनु कामेन बारामां लिखता ती, ती मे समजो की जे किताप लिखायता, चे किताप अतरा जादा हय जाता की ईनी कळी मां बी नी समाय्‌ता।");
INSERT INTO bhi_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","थीयुफीलुस मारु लाटेक्‌लु! मे मारी पेहली कितापेन तीनुक आखा कामेन बारामां लिखलु छे, च ईसु सुरु कर्‌यु ने आयन सीकाड़तु रयु। ");
INSERT INTO bhi_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ने जीने दाहड़े लग सरग मां नी हाकलायु तेर सी पेहले दाहड़े लग ईसु चुखली-आत्‌मा सी आपसान नेवाड़ला नेवताळा काजे जी वात सीकाड़तु रयु। ");
INSERT INTO bhi_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ने ईसु कुरुस पर दुख हाकलीन मर गुयु ने मर्‌या-सर्‌याम सी पछु जीवतु हय्‌न आपसा नेवताळाक बेसका पुरावा सी देखाव पड़्‌यु की चु जीवतेलु छे। असुत चु चाळीस दाहड़ा लग तीनुक देखाव पड़तु रयु, ने तींद्‌रे पुठ्‌ये भगवानेन राजेन बारामां वात करतु रयु। ");
INSERT INTO bhi_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ने चु तीनुक भेळु हय्‌न तीनुक हुकुम आप्‌यु की, “बास जु वायदु करलु छे चु वायदु पुरु हवणे लग तुहुं यरुसलेम सहर सी घुण जावु, ने तुहुं चु वायदु पुरु हवणे लग वाट देखता रवजु। मे तुहुं काजे तीना वायदान बारामां देखाड़ देदलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","काहाकी युहन्‌‌‌नु ते पाणी सी बपतीस्‌मा देदु, बाकुन थुड़ाक दाहड़ान पछेन तुहुं चुखली-आत्‌मा मां बपतीस्‌मा लेसु।” ");
INSERT INTO bhi_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","चे नेवताळा बयड़े भेळा हय्‌न ईसु सी पुछ्‌या, “ए मालीक, काय तु ईनेत टेमे ईस्‌रायल देसेन राज काजे बदली देसी काय?” ");
INSERT INTO bhi_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ईसु तीनुक कह्‌यु, “तीनी टेम काजे जाणनेन तुंद्‌रो काम नी हय तीनाक भगवान खुद आपसा हक सी ठहरावलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","बाकुन जत्‌यार चुखली-आत्‌मा तुंद्‌रे पर उतरसे, ती तुहुं ताकत हात करसु; ने तुहुं यरुसलेम सहर ने आखा यहुदीया जीलाम, ने सामर्‌या सहरेम ने धरतीन ईनी धड़े सी पली धड़े लग मारा गवा बणसु।” ");
INSERT INTO bhi_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ज कय देदु ने अळी ईसु तींद्‌रे देखते-देखते उपर सरगे मां हाकलाय गुयु, ने वादळो तीनाक ढाक लेदो। ");
INSERT INTO bhi_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ईसुक जातलु देखीन चेला सरगे भीणी एक हेट्‌या देख रवला, तत्‌यार धवळा पुथल्‌या पेहरला दुय अदमी तींद्‌रे धड़े आवीन उबा हय गुया, ");
INSERT INTO bhi_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ने तीनुक कह्‌या, “ए गलील मां रहण्‌या माणसे, तुहुं काहा उबा हय्‌न सरगे भीणी देख रया? हीयुत ईसु, जु तुंद्‌रे ईचमां सी सरगे मां हाकलाय गुयलु छे, ईनेत रीते अळी पछु आवसे, जसा तुहुं हीनाक जातलु देखला छे।” ");
INSERT INTO bhi_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","तत्‌यार चेला जेतुन नावेन बयड़े सी यरुसलेम पछा आया, चु बयड़ु यरुसलेम सहर सी धड़ेत एक कीलुमीटर लांबे हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","जत्‌यार चे पुगीन घरेन उपरी कमरा पर गुया, जाहां चे थुबी रवला, चे पतरस ने, युहन्‌‌‌नु ने, याकुप ने, अन्‌दीरीयास ने, फीलीप्‌पुस ने, थोमास ने, बरतुल्‌मे ने, मत्‌‌ती ने हलफाईन पुर्‌यु याकुप ने सीमोन ने, याकुपेन पुर्‌यु यहुदा चां हतला। ");
INSERT INTO bhi_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","हींद्‌रे पुठ्‌ये थुड़ाक बायरा ने ईसुन माय मरीयम ने, ईसुन भाय बी हतलु। चे आखा एक मन हय्‌न दुवा करने बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","थुड़ाक दाहड़ा पछेन पतरस ने भुरसु करने वाळा भायसेन मतलब एक सोव वीसेक जणान टुळा मां पतरस उबु हय्‌न कवणे लाग्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ए भायस्‌यो,” चुखला सास्‌तुर मां चुखली-आत्‌मा दावुदेन मुंहडा सी ज काय यहुदान बारामां पेहेल सीत कवलु हतलु, ची वात पुरी हवणुत हतलो। चु यहुदा, ईसुक धरन्‌यान अगवाय करन्‌यु हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","काहाकी यहुदा ते आपणात टुळा मायन हतलु ने हेरु आपणी सेवान काम मां हीस्‌सु बन्‌लु। ");
INSERT INTO bhi_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","चु पापेन कमाय सी एक खेत मुल लेदु, ने चु तीना खेतेन झाड़के जाय्‌न टांगाय गुयु, ने मुंहडान भुरसे पड़्‌यु, तेरो पेट फाट गुयो, ने तेरा आखा आतड़ा बाहर नीकळी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","जी वात यरुसलेम सहर मां आखा रवण्‌या काजे पतु हय गुयु, तीना खेतेन नाव हकळदमा मतलब लुहीन खेत पड़ गुयो। ");
INSERT INTO bhi_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","भजनेन किताप मां बी लिखलो छे की, तेरो घर उजड़ी जाणु चाहे ने; तेरेमां रहण्‌या एक बी नी बचणु चाहजे। ने तीना माणसेन, सेवा कामेन आवजी काहनु दीसरु ली लेय। ");
INSERT INTO bhi_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","तेरेमां ज जरुड़ी छे की जत्‌यार मालीक ईसु हामरे ईचमां हतलु तत्‌यार जे माणसे जलम हामरा हतला, तींद्‌रेम सी काहनाक एक काजे नेवाड़े। मतलब तीनी टेम सी लागाड़ीन जत्‌यार सी युहन्‌‌‌नु माणसे काजे बपतीस्‌मा देणु चालु करलु ने जत्‌यार लग ईसु काजे हामरे ईचमां मां सी हाकलाय गुयलु। ईनु माणसे मां सी काहनाक एक काजे तीनाक मर्‌या-सर्‌याम सी जीवतु हवणेन हामरे साते गवा बणनु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","तेरेसी चे दुय अदमी काजे सांबा लाया युसुफ काजे, जु बरसब्‌बास कवायतेलु ने तेरो नावठ्‌यो नाव युस्‌तुस हतलो, दीसरु मत्‌‌तीयास काजे, ");
INSERT INTO bhi_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ने जे भगवान धड़े असी दुवा कर्‌या, “ए मालीक! तु आखान मन काजे जाणे। हामुक ज देखाड़, की तु ईनु दुय मायन कुणी काजे नेवाड़्‌लु छे, ");
INSERT INTO bhi_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ने चु एक ईसुन नेवताळान रुप मां यहुदान आवजी पर ईनी सेवा-चाकरीन जागु हात करे तसा। तीना जागा काजे छुड़ीन यहुदा आपसे जागे जाती रयु।” ");
INSERT INTO bhi_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","तत्‌यार चे तेरा बारामां चिट्‌ठी नाख्‌या ने चिट्‌ठी ईछा ती ची चिट्‌ठी मत्‌‌तीयासेन नावेन नीकळी। अळतेन चु मत्‌‌तीयास ईसुन ग्‌यारे नेवताळा मां भेसकाय गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","जत्‌यार पेन्‌तेकुस्‌तेन दाहड़ु आयु, ती ईसुन आखा नेवताळा एक जागे भेळा हय रवला। ");
INSERT INTO bhi_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ती उचकाणुन आधीन तसलु घुळ्‌ळु सरगे सी आयु, ने तीना घर मां चे बसी रवला च आखो घर तीना घुळ्‌ळा सी भराय गुयो। ");
INSERT INTO bhi_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ने आकठान खळायती लपटेन तसी जीप्‌या चां अगळ देखायणे लागी। चे आकठा सी जीपे मां तींद्‌रेम सी हरेक पर आय्‌न उभी रय गुय। ");
INSERT INTO bhi_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","चे आखा चुखली-आत्‌मा मां भराय गुया, ने भगवानेन चुखली-आत्‌मा तीनु काजे बुलनेन ताकत आपी, ने चे भाती-भातीन बुली बुलने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","सरगेन नेचा ने यरुसलेम मां आखा देसेन आवला यहुदी नीयम काजे मानने वाळा माणसे रय रवला। ");
INSERT INTO bhi_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ने चे ईसुन नेवताळा काजे जत्‌यार चे अवाज सामळ्‌या तत्‌यार माणसेन एक मट्‌लु टुळु भेळु हय गुयु, जे माणसे ज सामळीन घाबरायणे लाग्‌या काहाकी चे भुरसु करने वाळा माणसे काजे आपणी खुदेन बुली मां बुलतेला सामळ्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","चे आखान-आखा बेसका वीच्‌यारेम पड़ गुया, ने चकरायन कह्‌णे बाजी गुया, “सामळु जे बुलने वाळा आखान-आखा गलील देस मां रहण्‌या नी हय काय! ");
INSERT INTO bhi_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ती पछेन काहा आपणे मायेन हर एक जणु ईनु काजे आपणी-आपणी देसेन बुली बुलतेला कसा सामळने बाजी रया? ");
INSERT INTO bhi_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","हामु ते पारथी ने मेदी ने एलामी ने, मेसोपोटामीया, मां रवण्‌या छे, ने यहुदीया ने कप्‌पुदुक्‌या, पुन्‌तुस ने आसीया, ");
INSERT INTO bhi_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फुर्‌गीया ने, पंफुलीया, मीसर ने लीबीया देस जो कुरेने आड़े-धड़े, ईनु आखा देसेम रवण्‌या, रोम मां रवण्‌या माणसे छे, ");
INSERT INTO bhi_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","यहुदी धरम मानने वाळा माणसे, ने काहना यहुदी धरम धरीन नवला चेला बणन्‌या छे ने केरती मां रवण्‌या, ने अरब देस वाळा बी छे। हामु आखा आपणी-आपणी बुली मां हींद्‌रे सी भगवानेन मटला-मटला कामेन वात सामळने बाजी रवला।” ");
INSERT INTO bhi_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ने चे आखा घाबराय गुया, ने घाबराय्‌न एक दीसराक कवणे बाजी गुया, “ज असो काय हय रयो?” ");
INSERT INTO bhi_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","बाकुन थुड़ाक दीसरा माणसे हास्‌ता जाय्‌न कह्‌या, “जे ते दारु पीन छाकी र्‌या।” ");
INSERT INTO bhi_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","तत्‌यार पतरस ग्‌यारे नेवताळान ईचमां उबु हय गुयु ने अतरी जुर सी कह्‌यु की चे आखा सामळी लेय ने कह्‌यु, ए यहुदी माणसे ने यरुसलेम सहर मां रवण्‌या, तुहुं मारी वात कान्‌टा उघाड़ीन सामळु ने ज जाण लेवु। ");
INSERT INTO bhi_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","जसा तुहुं समजी रया तसों नी हय ने जे माणसे छाकला नी हय, काहाकी हींताळ ते संदारेन नवुत बज रय। ");
INSERT INTO bhi_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ने सामळु जी वात बी छे, की ईनी वातेन बारामां भगवान योएल सी कह्‌लु जु भगवानेन अघली वात बताड़ने वाळु हतलु: ");
INSERT INTO bhi_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","आकरी दाहड़ा मां काय हवसे तेरे बारामां भगवान कवे, की मे मारी चुखली-आत्‌मा आखा माणसेन डीलेम मकलीस ने तुंद्‌रा पुर्‌या ने पुरे भगवानेन अघली वात बताड़ने वाळा बणसे ने तुंद्‌रा जुवान माणसेक अघो काय करनु च जड़से ने तुंद्‌रा डाहला माणसे सपनाम वात करसे। ");
INSERT INTO bhi_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","अतरात नी बाकुन अळी बी छे जे मारी सेवा करन्‌या ने सेवा करने वाळी पर बी तींद्‌रे मां बी मे मारी चुखली-आत्‌मा मकलीस, ने चे बी हवणे वाळी अघली वात बताड़से। ");
INSERT INTO bhi_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ने मे उपर सरगे मां बेसको वारु काम देखाड़ीस, ने नेचु धरती पर सहलाणी देखाड़ीस, मतलब लुही, आकठी, ने उड़तेला कुळान वादळो देखाड़ीस। ");
INSERT INTO bhi_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","मालीकेन मटा-भारी ने सेक-सींगार भर्‌या दाहड़ा आवणेन पेहले दाहड़ु आंदारो हवणे बाजी जासे, ने चांद लुहीन तसु हय जासे। ");
INSERT INTO bhi_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ने तीनु दाहड़ाम जु मालीकेन नाव लीन दुवा करसे, तेरुत छुटकारु हवसे। ");
INSERT INTO bhi_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ए ईस्‌रायली जातीन मारा भायस्‌यो! मारी वात मन लागाड़ीन सामळु! तुहुं आपसात जाणु की भगवान ईसु नासरीन साहरे तुंद्‌रे अगळ ताकुतेन वारु कामेन सहलाणी देखाड़लु छे! तेरे सी पुरावा भेळ ज मालुम पड़ गुयलो की ईसु भगवान वगे सी मकेल्‌लु हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","चु ईसु भगवानेन ठेहरावली युजनान अनुसार धरायलु ने तुहुं कायदाक तुड़न्‌यान हाते तीनाक कुरुस पर चड़ाया ने माराड़ देदा। ");
INSERT INTO bhi_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","बाकुन भगवान मरनेन बंद छुड़ीन ईसु काजे मर्‌या-सर्‌याम सी पछु जीवाड़्‌यु। काहाकी ईसु माणसेन तसु मरनेन बंद मां रवे असु नी हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","काहाकी ईसुन बारामां दावुद ज कवे, “मे जलम लग मालीक भगवान भीणी देख रवीस; चु मारे जेवड़्‌ये आन्‌गे रवे; तेरेसी मे कसला बी दुखेम कदी लथड़ीन नी पड़ो। ");
INSERT INTO bhi_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","तेरेसी मारो हीयो मन बी बेसको खुस छे, ने आस छे, मारी चुखली-आत्‌मा बी बेसकी खुस छे; ने मारा डीलेन नुकसाण बी नी हये। ");
INSERT INTO bhi_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","काहाकी तु मार जीव काजे मोतेन कळ मां नी नाखे। ने नी ते तु तारा चुखला भगत काजे सड़ने देय। ");
INSERT INTO bhi_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","तु मेसेक जीवाय्‌न छाचली वाट देखाड़्‌यु; तारी हजरी मां रवणे सी मेसेक वारु खुसी जड़े।” ");
INSERT INTO bhi_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ए मारा भायसे, मे कुळधेणी राजु दावुदेन बारामां तुंद्‌रु धाक राखे बीगुर ज कय सको की चु मर गुयु ने तीनाक गाड़ बी देदा। ने तेरो मसाण आज लग हामरे ईचमां छे। ");
INSERT INTO bhi_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","दावुद भगवानेन अघली वात बताड़ने वाळु माणुस हतलु, तेरेसी चु जी वात जाण तेलु, की भगवान सगुन खाय्‌न मेसेक ज कह्‌यु की मे तारीत कुळी मां सी एक जणा काजे तारी राजगादी पर बठाड़ीस। ");
INSERT INTO bhi_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","तेरेसी जो काय अघो हवणे वाळो हतलो च देखीन दावुद ज कवलु; ने मारा डीलेन बी नुकसाण नी हये। काहाकी तु मारा जीव काजे मोतेन कळ मां नी नाखे। ने नी ते तु तारा छाचला पावर्‌या काजे सड़ने देय। जी वात दावुद, ईसु मसीन बारामां कवलु की चु मर्‌या-सर्‌याम सी पछु जीवतु हय्‌न बठु हवसे। ");
INSERT INTO bhi_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ईनात ईसु काजे भगवान मर्‌या-सर्‌याम सी पछु जीवतु करीन बठु कर देदलु छे ने हामु ईनी वातेन गवा छे। ");
INSERT INTO bhi_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ने ईना ईसु काजे भगवान आखी कळजुगेन हकदार्‌यु बणावीन आपसे जेवड़्‌ये आन्‌गे बठाड़ देदु, ने जु ईसु वायदु करला चुखली-आत्‌मा काजे भगवान सी आपलु छे, तीना काजे तुहुं देख रया, ने सामळी रया। ");
INSERT INTO bhi_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","दावुद आपसु डील भेळु सरगे मां नी गुयु, बाकुन चु आपसुत कहें, मालीक भगवान मारा मालीक भगवान काजे कह्‌यु, “तु मारे जेवड़्‌ये आन्‌गे बठ, ");
INSERT INTO bhi_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","जत्‌यार लग मे मारा वेरीक, तारा पाय तळेन जागु नी बणाय दम। ");
INSERT INTO bhi_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ईस्‌रायली जातीन आखी कुळीन ज जाण लेणु चाहे की भगवान ईसु काजे मालीक बी, ने मसी बी ठेहराय देदलु छे तीना काजे तुहुं कुरुस पर चड़ाय देदला।” ");
INSERT INTO bhi_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ज सामळीन चे आपसान गलती काजे समजणे बाजी गुया ने चे पतरस काजे ने ईसुन दीसरा नेवताळाक पुछणे बाजी गुया, “ए भायस्‌यो! हामुक काय करनु चाहजे?” ");
INSERT INTO bhi_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पतरस तीनुक कह्‌यु, “तुहुं पाप भीणी सी मन फेरवीन भगवान भीणी वळु, ने तुंद्‌रे मायन एकेक जणु आपणा-आपणा पापेन माफी वाटे ईसु मसीन नावेन बपतीस्‌मा लेवु। ती तुहुं भगवानेन चुखली-आत्‌मान वाटु हात करसु, ");
INSERT INTO bhi_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","काहाकी भगवानेन चुखली-आत्‌मान वाटु आपणेन वायदु तुंद्‌रे वाटे, ने तुंद्‌री अवल्‌यात वाटे छे, ने तीनु आखा वाटे छे, जे हींताळ छेटा छे ने तीनुक हामरु मालीक भगवान बुलावणे वाळु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पतरस अळी बेसका वातेन साहरे गवाय देदु, ने ज कवतु जाय्‌न तींद्‌रे धड़े रवणे करीन कह्‌यु, “तुहुं आपसा काजे ईनी पीड़ीन एक हेट्‌या माणसे सी बचाड़ु।” ");
INSERT INTO bhi_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","जे पतरसेन वात पर भुरसु कर्‌या, चे बपतीस्‌मा ली लेदा; ने तीनेत दाहड़े तीनेक हजार माणसे ईसुन नेवताळा पुठ्‌ये भेसकाय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ने चे ईसुन नेवताळा धड़े सीकणे मां सात-संगात मां, ने ईसुन खातरीन पंगतेम खाणे मां ने ईसु धड़े दुवा करने मां साते रया। ");
INSERT INTO bhi_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ईसुन नेवताळान साहरे बेसको वारु कामेन सहलाणी हवतेली ती आखा माणसे बीहीन सीयारी ली लेदा। ");
INSERT INTO bhi_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ने आखा ईसु पर भुरसु करन्‌या भेळात रवतेला, ने तींद्‌रे धड़े जो काय बी हतलो तेरेमां आखान साजु हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","चे आपणो-आपणो माल-धन ने खेत एच देद्‌ला, जे पयस्‌या-टका आवे, चे पयस्‌या-टका तीनाक चाहजे, तीनाक आप देदला। ");
INSERT INTO bhi_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","चे आखा एक मन्‌या हय्‌न दाहड़ीन मंदीर मां भेळा हवतेला, ने आखान घर-घर जाय्‌न मालीकेन खातरीन पंगत मां भेसकायतेला ने सुदले मने भेळा हय्‌न खाणो खात्‌ला। ");
INSERT INTO bhi_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ने चे भगवानेन गुण गाया करतेला, ने आखा माणसे तींद्‌रे सी खुस हतला। ने जे-जे पाप सी छुटकारु हात करतेला, तीनुक मालीक ईसु दाहड़ीन तींद्‌रे पुठ्‌ये भेसकी देदलु। ");
INSERT INTO bhi_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","पतरस ने युहन्‌‌‌नु मांजणीक वेळाय, दुवा करने मंदीर मां जाणे बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ने तीनी टेमे माणसे एक माणुस काजे ली जाणे बाजी रवला, चु जलम सीत लंगड़ु हतलु। चे तीनाक दाहड़ीन लावीन मंदीरेन घाटाळ्‌ळा नावेन झपलान्‌चां बठाड़ देदला। ने चु मंदीर मां आवण्‌या-जाण्‌या धड़े भीक मांग्‌या करतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","जत्‌यार चु पतरस ने युहन्‌ना काजे मंदीर मां भरायतेला देख्‌यु, ती तींद्‌रे धड़े जाय्‌न भीक मांग्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","पतरस ने युहन्‌ना तीना भीणी एक-हेट्‌या देख्‌या, ने पतरस कह्‌यु, “हामरे भीणी देख।” ");
INSERT INTO bhi_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ने चु काय जड़से करीन तींद्‌रे भीणी एक हेट्‌यु देख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","बाकुन पतरस तीनाक कह्‌यु, “मार धड़े चांदी ने, नीते सनो हय बाकुन मार धड़े ज छे, च तुसेक आपो ईसु मसी नासरीन नाव सी चाल ने हींड-फीर।” ");
INSERT INTO bhi_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ने पतरस तेरु जेवड़्‌यु हात धरीन तीनाक उठाड़्‌यु, ने तत्‌यारुत लंगड़ान पायेम ने मांडाम ताकत आय गुय। ");
INSERT INTO bhi_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ने चु उछळीन मामार उबु हय गुयु, ने हींडणे-फीरने बाजी गुयु; ने भगवानेन गुण गावतु जाय्‌न, उच्‌चु कुद्‌तु-कुद्‌तु, पतरस ने युहन्‌ना पुठ्‌ये मंदीर मां जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","आखा माणसे तीनाक हींडतेलु-फीरतेलु ने भगवानेन गुण गावतेलु देख्‌या, ");
INSERT INTO bhi_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","माणसे तीनाक उळखीन कह्‌या, जु ते हयुत छे, जु मंदीरेन घाटाळ्‌ळा नावेन झपला पर भीक मांग्‌या करतेलु। तीना लंगड़ा साते ज काय बी हवलो, तीनाक देखीन चे चकराय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","जत्‌यार चु माणुस पतरस ने युहन्‌नान हात धरीन पुठ्‌ये जाणे बाजी रवलु। तत्‌यार आखा माणसे चकरायन सुलेमानेन खपड़ा मां तींद्‌रेन्‌चां दवड़ता आया। ");
INSERT INTO bhi_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","पतरस तीनुक आवतेला देखीन कह्‌यु, ए ईस्‌रायली माणसे! तुहुं ईना माणसेक देखीन काहा चकराय रया, ने हामरे भीणी एक-हेट्‌या काहा देख रया। तुहुंक असो लाग रयो की हामुक हामरे जुरे ने हामरी भक्‌तीन जुरे ईनाक हींडतु-फीरतु करला छे, बाकुन असो नी हय। ");
INSERT INTO bhi_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्‌राहमेन, इसाकेन ने याकुपेन भगवान, हामरा डाहा भगवान आपसा चाकर्‌या ईसु काजे सेक-सींगार भरलु छे। तुहुं ईना ईसु काजे सीपायड़ान हातेम धराय्‌न पीलातुसेन हात लगु कर देदा ने जत्‌यार पीलातुस तेरु नीयाव करीन छुड़नेन वीच्‌यार कर्‌यु, ती तुहुं हीनाक मां छुड़े करीन नीकारु कर देदा। ");
INSERT INTO bhi_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","तुहुं चुखला ने वारलु माणसेक मां छुड़े करीन तेरु नीकारु कर देदा, ने आपसान करता हत्‌याराक छुड़ दे करीन कह्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ने असु करीन तुहुं जीवाय आपण्‌या काजे माराय नाख्‌या, बाकुन भगवान तीनाक मर्‌या-सर्‌याम सी जीवतु करीन बठु कर देदु; ने हामु ईनी वातेन गवा छे। ");
INSERT INTO bhi_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","काहाकी हामु ईसु नाव पर भुरसु कर्‌या, ने ईनात नावेन जुरे ईना माणुस काजे, तीनाक तुहुं देखु, ने जाणु की जुर जड़लु छे। छाचलीन हयुत भुरसु जु ईसुन साहरे छे, ईनाक तुहुं आखा अगळ वारु करलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ने हय ए भायस्‌यो! मे जाणो की तुहुं ने तुंद्‌रा मुखी अनजाण्‌या हतला, एरेन करीन चे ईसु काजे कुरुस पर चड़ावीन माराड़ नाख्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","बाकुन भगवान आपसा अघी सी आवणे वाळी वात देखाड़न्‌या माणसेन साहरे पेहले सीत कय देदलु की आवणे बाजी रयु तीना मसी काजे दुख झेलनु पड़से। असु करीन भगवान आपसान कवलो पुरो कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","तेरेसी तुहुं पाप भीणी सी मन फेरवीन भगवान भीणी वळु; ती तुहुं काजे भगवान माफ करसे। ");
INSERT INTO bhi_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","तुहुं मालीकेन हजरी मां वारु जीव जीवणेन टेम जड़से। तत्‌यार भगवान तुंद्‌रे वाटे पेहले सी ठेहरावला ईसु मसी काजे तुंद्‌रेन्‌चां मकलसे। ");
INSERT INTO bhi_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","जु मसी तीने टेमे लग सरगे मां रवसे, जत्‌यार लग चु आखी चीज काजे पेहल हतली तसीत नी बणावे; ईनी टेमेन ने वातेन बारामां, भगवानेन चुखलु अघी सी हवणे वाळी वात देखाड़न्‌या माणसेन कळी घड़ायी ती सीत कवता आय र्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","जसु मुसु कह्‌लु, मालीक-भगवान तुंद्‌रे वाटे तुंद्‌रा भाय-बेटाम सी एक भगवानेन चुखला अघी सी आवणे वाळी वात देखाड़न्‌या काजे उबजाड़से, ने चु चुखलु अघी सी आवणे वाळी वात देखाड़न्‌यान ज काय तुहुं काजे कहें, चत सामळीन तुहुं तेरी वात मांजु। ");
INSERT INTO bhi_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","बाकुन काहनु बी तीना चुखला अघी सी आवणे वाळी वात देखान्‌यान वात सामळीन नी माने, चु तीना काजे चु आपसा असामी मां सी अलग करीन मार देसे। ");
INSERT INTO bhi_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ने समुएल ने तेरे सी अळी आवला आखा भगवानेन अघी सी आवणे वाळी वात बताड़ने वाळा मसीन आवणेन बारामां ईनु दाहड़ान बारामां पेहले सीत कवला हतला। ");
INSERT INTO bhi_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","तुहुं ते भगवानेन अघी सी आवणे वाळी वात देखान्‌यान अवल्‌यात छे, ने तीना वायदान साजेल्‌या छे, तीना वायदाक भगवान तुंद्‌रा डाहा-डाहा वाटे तीनी टेमे ठेहरायु, जत्‌यार चु अब्‌राहम काजे कह्‌यु, तारी अवल्‌यातेन साहरे धरती पर रवण्‌या आखी कळीन माणसे संयबरकत हात करसे। ");
INSERT INTO bhi_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","भगवान तुंद्‌रे मायन एकेक जणा काजे कुहराय सी छुड़ावीन संयबरकत आपणे करीन, आपसा पावर्‌या काजे पेहले तुंद्‌रेन्‌चां मकेल्‌लु छे। ");
INSERT INTO bhi_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","पतरस ने युहन्‌‌‌नु माणसेक कवणे बाजी रवला, ती पुजारु, मंदीर मां राखवाळी करन्‌या सीपायड़ान मुखी, ने सदुकी पंथवाळा माणसे तींद्‌रेन्‌चां जुर करीन आय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","पतरस ने युहन्‌‌‌नु ईसु मर्‌या-सर्‌याम सी जीवतु हय गुयु करीन मर्‌या-सर्‌याम सी जीवतु हय्‌न बठु हवणेन बारामां ईसुन दाखलु देखाड़ीन परचार करीन सीकाड़तेला। तेरेसी चे बेसका रीसाय रवला। ");
INSERT INTO bhi_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","अळी चे तीनु काजे धरीन दीसरे दाहड़े लग जेलेम कुंड देदा, काहाकी सांतो हय गुयलो। ");
INSERT INTO bhi_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","बाकुन जे तींद्‌री वात सामळी रवला, तीनु मायन बेसका जणा ईसु पर भुरसु कर्‌या, ने ईसु पर भुरसु करन्‌या बायराक-पुर्‌याक छुड़ीन अदमी-अदमी पांचेक हजार हय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","दीसरे दाहड़े यरुसलेम सहर मां भगवानेन मंदीरेन मुखीन, ने पुडारीन, ने नीयम सीकाड़न्‌या मास्‌तर्‌यान बठक हय। ");
INSERT INTO bhi_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ने चां भगवानेन डाहलु पुजारु हन्‌ना, ने काइफा, ने युहन्‌‌‌नु, ने सीकन्‌दर ने मुखी पुजारान घरन्‌या बी भेळा हतला। ");
INSERT INTO bhi_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","चे पतरस ने युहन्‌ना काजे ईचमां उबा करदीन ज पुछणे बाजी गुया, “तुहुं कुणीन ताकत ने नावे ज काम करला छे?” ");
INSERT INTO bhi_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","तत्‌यार चुखली-आत्‌मा पतरस मां पुरु भरायन कब्‌जा मां कर लेदु, ने ती पतरस तीनुक कह्‌यु, ए माणसेन मुखी ने पुडारी! ");
INSERT INTO bhi_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","एक लंगड़ा माणसेन भलो हवलो छे, एरे बारामां आज हामु काजे तुहुं पुछणे बाजी रया की जु कसु वारु हवलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ती तुहुं आखा काजे ने ईस्‌रायली जातीन माणसे काजे मालुम हय जाणु चाहजे, की जु लंगड़ु माणुस ईसु मसी नासरीन नाव सी वारु हय्‌न, तुंद्‌रे अगळ उबु हय रयु। तुहुं तीना ईसु मसी काजे कुरुस पर चड़ाया, बाकुन भगवान तीना ईसु मसी काजे मर्‌या-सर्‌याम सी पछु जीवाड़ीन बठु कर देदलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","जु ईसु हयुत छे, तीना दगड़ाक “मीस्‌तर्‌या” बेकार समजीन बाहर नाख देदा, चु दगड़ुत घरेन नेहान, खुणे वाळु दगड़ु बण गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","तेरेसी ईसुक छुड़ीन काहना बी दीसरा माणसेन साहरे पाप सी छुटकारु नी जड़े, काहाकी सरगेन नेचो ईनी आखी कळी मां ईसु नाव छुड़ीन दीसरो नाव नी हय, तीने नावे आपणुक पापेम सी छुटकारु जड़तु हय। ");
INSERT INTO bhi_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","जत्‌यार यहुदी मुखी पतरस ने युहन्‌नान हिम्‌मत देखीन चकराय गुया काहाकी जे ते अनपड़ ने सुदला माणसे छे; बाकुन अळतेन मालुम पड़्‌यो की जे ते ईसु पुठ्‌ये रवला हतला; ");
INSERT INTO bhi_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","बाकुन वारु हवला माणसे काजे तींद्‌रे भेळतु उबु हय रवलु देखीन, तीनुक जपाप मां काय नी कह्‌वायो। ");
INSERT INTO bhi_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","बाकुन चे पतरस ने युहन्‌ना काजे बठक सी बाहर मकली देदा ने आपसा-आपसा जु वीच्‌यार कर्‌या, ");
INSERT INTO bhi_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“हामु हीनुक काय करजे ने काय नी? काहाकी यरुसलेम मां रवण्‌या आखा माणसे काजे जु पतु हय गुयलु छे, की जु एक बेसका वारु कामेन सहलाणी देखाड़ला छे; ने आपणुक हीना कामेन नीकारु करता नी बणे। ");
INSERT INTO bhi_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","बाकुन तेबी ईनी वातेन वदु परचार माणसे मां नी हवणु चाहजे, करीन आपणु ईनुक धमकी देदा, की तुहुं ईना ईसुन नाव लीन कुय साते अगा वात मां करु।” ");
INSERT INTO bhi_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","अळी चे पतरस ने युहन्‌ना काजे अळी बुलावणे मकल्‌या ने तीनुक हुकुम आपीन कह्‌या, की तुहुं ईसुन नाव लीन कुय साते वात बी घुण करु, ने कुय काजे सीकाड़ु बी घुण। ");
INSERT INTO bhi_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","बाकुन पतरस ने युहन्‌ना तीनु काजे ज जपाप आप्‌या, “तुहुंत नीयाव करीन कहं; हामु काजे भगवानेन नींगा मां, भगवानेन सामळने छुड़दीन तुंद्‌री सामळनु वारु रवसे काय? ");
INSERT INTO bhi_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","काहाकी हामु ज देखला ने सामेळला छे, तेरा बारामां नी कवे, ने हुगात हय र्‌या ती हामुक नी जमे।” ");
INSERT INTO bhi_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","तत्‌यार चे पतरस ने युहन्‌ना काजे अळी बेसका चेतावीन छुड़ देदा, काहाकी तीनुक डंड आपणेन तीनुक काय बी बाहनो नी जड़्‌यो, काहाकी ज वारु काम हयो हतलो तीना कामेन साहरे आखा माणसे भगवानेन बड़ाय करने बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","काहाकी तीना वारु कामेन सहलाणीन साहरे च माणुस वारु, तेरी उमर चाळीस साल सी वदु हतली। ");
INSERT INTO bhi_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","जत्‌यार चे पतरस ने युहन्‌ना काजे छुड़ देदा, ती पतरस ने युहन्‌‌‌नु आपसा सातीन्‌चां आया, ने ज काय पुडारी ने भगवानेन मुख्‌या पुजारा कवला, च आखो तीनुक कय देदा। ");
INSERT INTO bhi_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ज सामळीन पतरस ने युहन्‌‌‌नु तींद्‌रा साती आखा मेळीन भगवान सी एक जसी वीन्‌ती कर्‌या, ए मालीक, तुत सरगे ने धरतीक, ने समुदर ने समुदर मां ज काय छे, च आखो बणावलु‌ छे। ");
INSERT INTO bhi_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","तु चुखली-आत्‌मान साहरे आपसा पावर्‌या दावुदेन मुंहडे ज कवलु हतलु, नी-यहुदी माणसे असलात काहा आयड़े? आखा देसेन माणसे फालतु वीच्‌यार काहा कर रया? ");
INSERT INTO bhi_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","धरतीन राजा, ने देस देसेन राज करन्‌या आखा भेळा हवे; चे मालीक भगवान भीणी ने तेरा नेवाड़ला राजा भीणी जुर करे। ");
INSERT INTO bhi_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","काहाकी चे छाचलीन, चुखलु चाकर्‌या ईसुन वीरुद मां हय्‌न जाळसांदी बणाय रया, तीना काजे तु नेवाड़लु छे, हेरोदेस ने पुंतीयुस पीलातुस, ने नी-यहुदी ईस्‌रायली जातीन माणसे सहर मां भेळा हय रया। ");
INSERT INTO bhi_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","हव, चे एरेन करीन भेळा हय रया की ज काय तारी ताकत ने मरजी सी पेहले सीत ठहरावलो छे, ज पुरो हय सके। ");
INSERT INTO bhi_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ए मालीक! हय, हींद्‌री धमकी काजे देख, की तारा पावर्‌या काजे जु वाटु आप की चे तारा बुल काजे बीहे बीगुर पुरी हिम्‌मत सी सामळावे। ");
INSERT INTO bhi_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ने तु माणसेक वारु करने करीन आपसुत हात अगु कर; ने तारा चुखला चाकर्‌या ईसुन नावे, सहलाणी ने भाती-भातीन वारु काम देखाड़? ");
INSERT INTO bhi_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","जत्‌यार चे भगवान धड़े दुवा करीन नवराय गुया, ती चु जागु, जां चे भेळा हय रवला, हाल पड़्‌यु, ने चुखली-आत्‌मा तींद्‌रेम पुरु-पुरु भरायन तीनुक कब्‌जाम कर लेदु, ने चे हिम्‌मत सी भगवानेन बुल माणसे काजे सामळावणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ईसु पर भुरसु करन्‌या माणसेन एक टुळु ने एक मन्‌या ने एक जसा हय्‌न रवतेला। कुय बी आपसा धन काजे आपसो नी समजतेला। ज काय तींद्‌रे धड़े रवतेलो, तेरेमां आखान साजु हतलो। ");
INSERT INTO bhi_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ईसुन नेवताळा पर जुर लागाड़ीन मालीक ईसुन मर्‌या-सर्‌याम सी जीवतु हय्‌न बठु हवणेन गवा देदला, ने तीनु आखा पर भगवानेन मट्‌ली गीण-दया हतली। ");
INSERT INTO bhi_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ने तींद्‌रेम कुय बी गरीब नी हतलो, काहाकी तींद्‌रे धड़े खेती नीते घर हतलो, तीनुक चे एच देद्‌ला, ");
INSERT INTO bhi_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ने तींद्‌रु दाम लावीन ईसुन नेवताळान पायेन्‌चां लायन मेल देदला; ने तीनुक ज चाहतेलो च तीनुक वाट देदला। ");
INSERT INTO bhi_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","युसुफ नावेन एक सायपर्‌सेन लेवी कुळी मायन हतलु, जु कुपरुस मां पयदा हवलु हतलु, तेरो नाव ईसुन नेवताळा बरनाबास पाड़ला हतलो। बरनाबास मतलब दीलासु आपण्‌यान पुर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","तेरु एक जागु हतलु, तीना जागा काजे चु वेचलु हतलु, ने चु जागान रुप्‌या लावीन ईसुन नेवताळान पाय मां मेल देदु। ");
INSERT INTO bhi_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हनन्‌या नावेन एक अदमी ने आपसी घरवाळी सफीरा खेत वेचणेन बारामां वीच्‌यार कर्‌या अळतेन एक खेत वेच देदु। ");
INSERT INTO bhi_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","चु खेतेन दामेन एक वाटु आपसु राख लेदु जी वात तेरी घरवाळीक बी मालुम हतली, ने चु दीसरु हीस्‌सु लावीन नेवताळान पाय मां मेक देदु। ");
INSERT INTO bhi_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","अतरा मां पतरस कह्‌यु, “हनन्‌या! तु भुतड़ा काजे तारा मन पर काहा राज करने देदु, ने भुतड़ान जी वात काहा मान लेदु की तु चुखली-आत्‌मा काजे लुच्‌चाय मेल ने खेत वेचलु तीना दामेन सी ईतराक रुप्‌या बचाड़ीन मेल ले? ");
INSERT INTO bhi_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","वेचायणेन पेहले च खेत तारो नी हतलो काय? ने तीना वेचायला खेतेन दाम पर तारु हक नी हतलु काय? तु आपसा मन मां असलु वीच्‌यार काहा आवणे देदु? तु माणसेक नी, बाकुन भगवानेक झुट मेक्‌लु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","हनन्‌या ची वात सामळ्‌युत ने हीट पड़्‌यु ने तेरु जीव नीकळी गुयु। ने जे बी एरे बारामां सामळ्‌या, चे बेसका बीही गुया। ");
INSERT INTO bhi_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","अळतेन थुड़ाक जुवान्‌या उठीन हनन्‌या धड़ेक हाकलीन सीवड़ीन पुथल्‌या मां वेलट्‌या, ने बाहर ली जाय्‌न वोगे कर देदा। ");
INSERT INTO bhi_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ज हयो, तीनी वातेन बारामां हनन्‌यान घरवाळी काजे मालुम नी हतलो, तीनेक घंटा हय गुया ने अळतेन ची पतरस हतलु तीना घरमां आवी। ");
INSERT INTO bhi_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","तत्‌यार पतरस तीनीक जु सवाल पुछ्‌यु, “मेसेक बताड़, तुहुं च खेत अतरात पयस्‌या मां वेचला काय?” ची जपाप आपी, “हव, अतरात पयस्‌या मां वेचला।” ");
INSERT INTO bhi_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","तेरु जपाप सामळीन पतरस तीनी काजे कह्‌यु, “तुहुं दुय जणा मालीक भगवानेन चुखली-आत्‌मा काजे पारखणे करीन एक मन्‌या हय्‌न काहा राजी हय गुया सामळु! जे माणसे तारा धेणी काजे अळावीन वगे करने गुयला, चे पछा आवीन झपले उबा हय रया, ने हय चे तुसेक बी वगे करने बाहर ली जासे।” ");
INSERT INTO bhi_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","जी वात सामळतेत ची पतरसेन पायेम हीट पड़ी, ने मर गुय, ने चे जुवान्‌या घरमां आवीन तीनीक मरली देख्‌या, ने चे तीनीक बी ईछीन बाहर ली जाय्‌न तेरा धेणीन मसाण धड़ेत अळावीन वगे कर देदा। ");
INSERT INTO bhi_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","तेरेसी आखी मंडळीन माणसे ने जी वात सामळीन बीही गुया। ");
INSERT INTO bhi_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ईसुन नेवताळान साहरे बेसका वारु कामेन सहलाणी ने मटा-मटा काम माणसे मां देखाव पाड़्‌यु, ने आखा ईसुन नेवताळा एक मन्‌या हय्‌न सुलेमानेन खपड़ी मां भेळा हवतेला। ");
INSERT INTO bhi_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","बाकुन दीसरा माणसे काजे ईसुन नेवताळा पुठ्‌ये भेसकायणे वारु नी लागतेलो बाकुन चे ईसुन नेवताळा काजे चे बेसका वारु छे करीन कवतेला। ");
INSERT INTO bhi_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","बाकुन ईसु पर भुरसु करन्‌या बेसका अदमी ने बायरा आवीन मालीक ईसुन मां जादास-जादा अदु हवता गुया। ");
INSERT INTO bhi_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","जत्‌यार पतरस जां मायन नीकळीन गुयु ती मांदला माणसे पर पतरसेन साहळु काहना ने काहनाक पर पड़से ने पड़से करीन माणसे, मांदला काजे सयड़क धड़े लावीन खाट्‌ली पर ने झुळना मां टुपाड़ीन मेल देदला ");
INSERT INTO bhi_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ने यरुसलेम सहरेन आड़े-धड़ेन सहर वाळा बी मांदला काजे भुतड़ा आत्‌मा लागला माणसे काजे लावतेला ने चे आखा वारु हय जातला। ");
INSERT INTO bhi_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ज आखो देखीन भगवानेन डाहलु पुजारु, ने सदुकी पंथवाळा तेरा आखा सात-संगात वाळा बेसका कुहरायणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ने चे ईसुन नेवताळा काजे धरीन जेल मां कुंडी देदा। ");
INSERT INTO bhi_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","बाकुन मालीक भगवानेन एक सरग वाळु भगवानेन अघली वात बताड़ने वाळु, जेलेन झपलु उगाड़ देदु, ने चु तीनाक बाहर ली जाय्‌न कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“जावु, ने मंदीरेम उबा हय्‌न ईनी नवली जीवाय्‌न बारामां आखी वात माणसेक सामळावु।” ");
INSERT INTO bhi_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ने ईसुन नेवताळा सरग वाळा भगवानेन अघली वात बताड़ने वाळान वात सामळीन संदारो हवतात मंदीर मां जाय्‌न नवली जीवाय्‌न वात सामळावणे बाजी-गुया। तत्‌यार भगवानेन डाहलु पुजारु, ने सदुकी पंथवाळा तेरा आखा सात-संगात वाळा आवीन यहुदी माणसेन बसक ने ईस्‌रायली जातीन आखा पुडारी काजे भेळा कर्‌या, ने सीपायड़ाक कय मकल्‌या की तुहुं जेल सी ईसुन नेवताळा काजे ली आवु। ");
INSERT INTO bhi_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","बाकुन जत्‌यार सीपायड़ा चां पुग्‌या, ती चे ईसुन नेवताळा तीनुक जेल मां नी जड़्‌या। ती चे सीपायड़ा पछा आवीन भगवानेन डाहला पुजारा ने सदुकी पंथवाळा ज कह्‌या, ");
INSERT INTO bhi_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“हामु जाय्‌न देख्‌या ती जेलेम वारु छत करीन बंद कर मेकलो हतलो, ने झपले पहरु देण्‌या झपले पहरु देदा जाय्‌न उबा हय रवला; बाकुन जत्‌यार हामु मांही गुया, ती चां सारा काहना नी हतलो।” ");
INSERT INTO bhi_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ची वात सामळीन मंदीरेन राखवाळ्‌या डखी ने भगवानेन डाहला पुजारी फीकुर मां पड़ गुया, ने ची वीच्‌यार करने बाजी गुया, “हय आपणु काय करजे।” ");
INSERT INTO bhi_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","तीनेत टेमे काहनुक आवीन तीनुक जी खबर आप्‌यु, “देख, तीनु माणसे काजे तुहुं जेल मां कुंडी देदला, चेत माणसे मंदीर मां उबा हय्‌न माणसेक नवली जीवाय्‌न बारामां सीकाड़ने बाजी रया।” ");
INSERT INTO bhi_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","तत्‌यार मंदीरेन राखवाळ्‌या सीपायड़ान डखी, आपसा सीपायड़ा काजे लीन गुयु ने ईसुन नेवताळा काजे धर लायु। बाकुन माणसे हामुक दगड़ाट देसे, करीन तीनुक जबरान धरीन नी लायु, काहाकी चे माणसेक देखीन बीहतेला। ");
INSERT INTO bhi_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","चे ईसुन नेवताळा काजे लावीन मट्‌ली बठक अगळ उबा कर देदा; ने भगवानेन डाहलु पुजारु ईसुन नेवताळा सी सवाल पुछ्‌यु, ");
INSERT INTO bhi_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“हामु तुहुं काजे बेसका कयड़ा चेताड़ीन हुकुम आप्‌ला की ‘तुहुं ईसुन नाव लीन माणसेक घुण सीकाड़जु?’ तेबी तुहुं आखा यरुसलेम सहर मां ईसुन नाव लीन सीकाड़ने बाजी गुया, ने ईसुन लुहीन गुनु हामरे मुणका पर पाड़ने हींड रया।” ");
INSERT INTO bhi_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","पतरस ने ईसुन नेवताळान चु जपाप आप्‌या, “माणसेन हुकुम सी भगवानेन हुकुम पाळनु बेसको वारु छे। ");
INSERT INTO bhi_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","तीना ईसु काजे तुहुं कुरुस पर चड़ावीन खीळा ठुकीन मार नाख्‌ला, तीना ईसु काजे आपणा डाहा-डाहान भगवान मर्‌या-सर्‌याम सी जीवाड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ईनात ईसु काजे भगवान मालीक ने पापेम सी छुड़ावणे वाळु ठेहरावीन, आपसे जेवड़्‌ये आन्‌गे बठाड़ीन मट्‌लु हक आप देदु, ने चु ईस्‌रायली जातीन माणसे काजे पापे भीणी सी मन फेरवीन, भगवान भीणी वळनेन ताकत ने पापेन माफी आपे। ");
INSERT INTO bhi_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ईनी आखी वातेन गवा हामु छे, ने चुखली-आत्‌मा बी छे, ने चु चुखली-आत्‌मा, भगवान तीनु माणसेक आपलु छे, जे भगवानेन हुकुम काजे पाळे।” ");
INSERT INTO bhi_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","जी वात सामळीन चे बेसका रीसाय गुया, ने ईसुन नेवताळा काजे मार नाखणेन वीच्‌यार कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","यहुदी माणसेन मट्‌ली बसक मां गमलीयेल नावेन एक फरीसी माणुस हतलु, चु मुसान साहरे लिखली सास्‌तुरेन कायदा सीकाड़न्‌यु मास्‌तर हतलु, ने तेरी ईज्‌जत आखा करतेला। चु यहुदी माणसेन बसक उबु हय्‌न हुकुम आप्‌यु की “ईनु ईसुन नेवताळाक ईतरीक वार लग बाहर ली जावु।” ");
INSERT INTO bhi_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ने अळी चु बसक मायन ईस्‌रायली माणसेक कह्‌यु, “ए ईस्‌रायली जातीन माणसे, तुहुं ईनु माणसे साते ज काय करने हींड रया, च वारु वीच्‌यार करीन करजु। ");
INSERT INTO bhi_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","काहाकी ईनु दाहड़ा सी पेहले थीयुदास नावेन एक माणुस ज कवतु जाय्‌न उबु हयु, ‘मे काही छे’ ने च्‌यारेक सोव माणसे तेरे पर भुरसु करीन तेरे पुठ्‌ये चाल पड़्‌या, बाकुन तीनाक काहनुक मार नाख्‌यु; ने दत्‌रा बी माणसे तेरे पुठ्‌ये हतला, चे आखा रावण्‌या-तीवण्‌या हय्‌न सर गुया। ");
INSERT INTO bhi_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","अळतेन माणसेन गिन्‌तीन टेम आवी, तीने टेमे गलील जीला मां रवण्‌यु यहुदा उजेंतु हयु। चु ईतराक माणसे काजे तेरे भीणी कर लेदु। बाकुन तीनाक बी काहनुक मार नाख्‌यु। ने तेरे पर भुरसु करन्‌या बी रावण्‌या-तीवण्‌या हय गुया ");
INSERT INTO bhi_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","तेरेसी मे तुहुं काजे कहं की तुहुं ईनु ईसुन नेवताळा सी छेटा रवणु, ने हींद्‌रा काम मां आड़ा मां देवायु, काहाकी हींद्‌री युजना ने काम माणसे वगे सी हसे ती ची आपसीत सर जासे। ");
INSERT INTO bhi_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","बाकुन कदी जी युजना भगवान सुदी सी हसे, ती तुहुं हीनुक कदी सारी नी सकु; ने तुहुं भगवानेन वीरुद हय्‌न तेरे साते लड़ायण्‌या बी गीणायसु।” तत्‌यार चे बसक मायन ईस्‌रायली माणसे गमलीयेलन वात मान लेदा। ");
INSERT INTO bhi_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ने चे, ईसुन नेवताळा काजे बुलावणे मकल्‌या ने जत्‌यार तीनुक ली आया ती तीनुक ठुक्‌या; ने तीनुक जु हुकुम आपीन कह्‌या, “ईसुन नाव लीन कुय साते वात घुण करु।” ने अळतेन तीनुक छुड़ देदा। ");
INSERT INTO bhi_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ने ईसुन नेवताळा जी वात सामळीन ज कवता जाय्‌न खुस हय्‌न मट्‌ली सभा मां सी जाती रया, “कम सी कम हामरी ईसुन नावे नाव-बद्‌दी ते हयी।” ");
INSERT INTO bhi_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","चे दाहड़ीत मंदीर मां, ने घर-घर जाय्‌न ईसुन वात सामळावता रया, ने ईसुन ची खुस-खबर सामळावता गुया की “ईसुत मसी छे।” ");
INSERT INTO bhi_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","तीनु दाहड़ाम जत्‌यार माणसे जादात ईसुन चेला बणीन ईसु मां भेसकाया। ती युनानी बुली बुलन्‌या, ज कहीन कुर-कुर करने बाजी गुया, “दाहड़ीन खाणाम ने समान वाटे, ती हामरा रांडायला बायरा काजे टाळ देय ने तीनुक काय नी आपे।” ");
INSERT INTO bhi_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","तत्‌यार ईसुन बारे नेवताळा, चेलान बसक बुलावीन कह्‌या, ज वारु नी हय की हामु खाणु वाटणेन करता वारती बणीन भगवानेन बुल छुड़ देजे। ");
INSERT INTO bhi_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","तेरेसी ए भायस्‌यो, तुहुं आपसा मां सी वारलु गुण वाळा अदमी काजे नेवाड़ लेवु, तींद्‌रेम चुखली-आत्‌मा पुरु-पुरु भरायलु छे, ने चे अक्‌कल वाळा ने ईमानदार छे, ने हामु तीनुक खाणु ने समान वाटणेन हक आप देसु। ");
INSERT INTO bhi_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","बाकुन हामु भगवान धड़े दुवा करता रवसु ने भगवानेन बुलेक वाटणेन चाकरी करता रवसु। ");
INSERT INTO bhi_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","जी वात सामळीन आखा माणसे खुस हय गुया। ने चे स्‌तीफनुस काजे नेवाड़ लेदा तेरेमां चुखली-आत्‌मा पुरु-पुरु भरायलु हतलु, ने चु ईसु पर पाक्‌कु भुरसु करन्‌यु हतलु। ने चे फीलीप्‌पुस काजे, ने पुरखुरुस काजे, ने नीकानोर काजे, ने तीमोन काजे, ने परमीनास काजे, ने अन्‌ताकीया वाळा नीकुलावुस काजे जु यहुदी धरम काजे मान्‌ने बाजी गुयलु हतलु, नेवाड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ने चे तीनुक ईसुन नेवताळा अगळ उबा कर देदा ने ईसुन नेवताळा तीनु नेवाड़ला वाटे भगवान धड़े दुवा कर्‌या ने अळी तींद्‌रे पर आपसा हात मेल्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","भगवानेन वात फेलायती गुय, ने यरुसलेम मां बेसका ईसु पर भुरसु करीन चेला बण गुया; ने भगवानेन डाहला पुजारान मट्‌लु टुळु ईना ईसुन भुरसा काजे मान लेदा। ");
INSERT INTO bhi_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्‌तीफनुस भगवानेन गीण-दया ने भगवानेन जुरे सी भरायन माणसे मां सहलाणीन वारु काम देखाड़तेलु। ");
INSERT INTO bhi_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","तीनी टेमे छुट्‌ला-माणसे नावेन यहुदी माणसेन भक्‌तीन घरे मायन हतला, कुरेनी ने सीकेन्‌दर्‌या ने कीलक्‌या ने आसीयान माणसे मां सी एक-एक जणु उठीन बेसका जणा स्‌तीफनुस साते वातेम जखड़ी पड़ने बाजी गुयला ");
INSERT INTO bhi_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","बाकुन स्‌तीफनुस भगवानेन चुखली-आत्‌मान अगवाय मां ने भगवानेन अकलेन अगवाय मां बुलतेलु तेरेसी तीनुक स्‌तीफनुसेन वात काटायी नी सकी। ");
INSERT INTO bhi_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","तेरेसी चे पयस्‌या आपीन थुड़ाक अदमीक जी झुटी गवा देवाड़्‌या, “हामु ईना स्‌तीफनुस काजे मुसान ने भगवानेन नाव-बद्‌दी करतेलु सामेळला छे।” ");
INSERT INTO bhi_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","असा करीन चे माणसे काजे, ने पुडारी काजे ने यहुदी-धरम सीकाड़न्‌या मास्‌तर्‌या काजे भड़कावीन उचकाणुन स्‌तीफनुसन्‌चां आय लाग्‌या ने तीनाक धरीन मट्‌ली बसक अगळ ली गुया। ");
INSERT INTO bhi_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ने चां चे झुटा गवा उबा कर्‌या, ने चे झुटा गवा देण्‌या कह्‌या “जु अदमी दाहड़ीत ईना चुखला मंदीरेन ने मुसान साहरे लिखली सास्‌तुरेन नाव-बद्‌दी करे।” ");
INSERT INTO bhi_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","काहाकी हामु ईनाक ज कवतेलु सामेळला छे, “ईसु नासरी ईना मंदीर काजे उदार देसे, ने मुसान साहरे आपली रीती-भातीक बद्‌ली देसे।” ");
INSERT INTO bhi_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","मट्‌ली बसक मां बसला आखा माणसे स्‌तीफनुस भीणी एक हेट्‌या देख रवला, ती तीनुक, स्‌तीफनुसन मुंहडान सीकु सरग काहवाळ्‌यान तसु देखाय देदु। ");
INSERT INTO bhi_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","भगवानेन डाहलु पुजारु पुछ्‌यु, “जे माणसे तारे पर जु गुनु लागड़ रया, चु गुनु सय छे काय?” ");
INSERT INTO bhi_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","तत्‌यार स्‌तीफनुस कह्‌यु, ए डाहा-डाहा ने भायस्‌यो! मारी वात सामळु। जत्‌यार हामरु बास अब्‌राहम, हारान मां बसणेन पेहले मेसोपोटामीया मां रवतेलु, ती तीनी टेमे सेक-सींगार भर्‌यु भगवान तीनाक देखाव पड़्‌यु, ");
INSERT INTO bhi_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ने कह्‌यु, आपसो देस ने आपसा घर काजे छुड़ दे, ने तीने देस जां, ज देस मे तुसेक देखाड़ीस। ");
INSERT INTO bhi_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","तत्‌यार अब्‌राहम कसद्‌यान देस हारान सहर मां बस गुयु। तेरु बास मर गुयु ने अळी भगवान तीनाक चां सी ईना देस मां लायु, जां तुहुं हींताळ रय र्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ईना देसेम भगवान तीनाक जागरी रीते काहनी जागा नी आप्‌यु, चां लग की पाय मेकणे करीन बी जागा नी आप्‌यु। बाकुन चु वायदु कर्‌यु की मे ज देस तुसेक ने अळी तारी अवल्‌यात काजे आपीस तीनी टेमे अब्‌राहमेन एक बी पुर्‌यु नी हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","भगवान अब्‌राहम काजे ज बी कह्‌यु, तारी अवल्‌यातेन अवल्‌यात दीसरा देस मां परदेसीन तसा रवसे। ने चां आखा माणसे तीनुक गुलाम बणायन जुर जबरान काठो काम करावीन चार सोव साल लग वेला पाड़से। ");
INSERT INTO bhi_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","अळी भगवान कह्‌यु, जुर जबरान काठो काम करावीन वेला पाड़न्‌या नी-यहुदी माणसे काजे, मे नीयाव करीन डंड आपीस, ने अळी काठो काम करन्‌या तीना देसेम सी नीकाळ लावीस ने ईनीत जागे मारी सेवा करसे। ");
INSERT INTO bhi_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ने भगवान ईब्‌राहीम वाटे फतरी काटणेन बुली कर्‌यु; ने असु करीन चु इसाकेन बास बण्‌यु ने आठवे दाहड़े तेरी फतरी काटायी। इसाक, याकुपेन बास बण्‌यु, ने याकुप बारे कुळेन डाहलु बास बण्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","कुळ धेण्‌या, युसुफ पर कुहरायतेला, तेरेसी चे युसुफ काजे मीसरे देस जाण्‌या वेपारी काजे वेच देदा; बाकुन भगवान युसुफ पुठ्‌ये हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","चु आखी गरा सी युसुफ काजे बचाड़्‌यु। भगवान युसुफ काजे मीसरेन राजा फीरोन अगळ गीण-दया ने अक्‌कल आप्‌यु; ने चु राजा युसुफ काजे आपसा घरबारेन हकदार्‌यु बणाय देदु। ");
INSERT INTO bhi_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","तीनी टेमे आखा मीसर देसेम ने कनान देसेम काळ पड़्‌यु; ने भारी गरा आवी, ने आपणा आड़ा-बुड़ा काजे खाणे करीन काय नी जड़्‌यो। ");
INSERT INTO bhi_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","जत्‌यार याकुप ज सामळ्‌यु की मीसर देस मां अन जड़े, ती चु हामरा आड़ा-बुड़ा काजे चां पेहली कावा मकल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ने चे दीसरी कावा चां मीसर मां गुया, ती युसुफ आपसा भायस्‌यो काजे आपसी उळखाण कराड़्‌यु, ने फीरोन राजा काजे युसुफेन घरन्‌यान पतु चाल्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","तत्‌यार युसुफ आपसा याकुप ने तेरा आखा घरबार्‌या काजे बुलाय मांग्‌यु। चे आखा मेळीन पांच कम च्‌यार वीसु माणसे हतला। ");
INSERT INTO bhi_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","याकुप मीसर देस गुयु। ने आपणा आड़ा-बुड़ा बी मरीन सर गुया। ");
INSERT INTO bhi_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","अळी तींद्‌रा धड़ेक सकेम मां लाया, ने तीना मसाण्‌या मां अगे कर्‌या, जां अब्‌राहम सकेम मां हामरेन पुर्‌या धड़े चांदी आपीन मुल लेदलु। ");
INSERT INTO bhi_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","बाकुन जत्‌यार भगवान अब्‌राहम साते जु वायदु कर्‌यु, चु वायदु पुरु हवणेन टेम धड़े आय रवली, ती आपणा माणसे मीसर देस मां बेसका हय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","तत्‌यार मीसर मां एक नवलु राजा पयदा हयु, जु युसुफेन बारामां काय बी नी जाणतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","चु आपणा जातीन माणसे साते काट राखीन वेला पाड़्‌यु। तेरेसी आपणा आड़ा-बुड़ा काजे आपसा पुर्‌या काजे मरने करीन बाहर नाखणु पड़्‌यो। ");
INSERT INTO bhi_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","तीनी टेमे मुसु पयदा हयु। भगवानेन नींगा मां चु बेसकु वारु हतलु, ने तीन महना लग आपसा बासेन घर मां पुसायु। ");
INSERT INTO bhi_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ने जत्‌यार पुर्‌या काजे बाहर नदी मां नाख देदा, ती फीरोन राजान पुरे तीना पुर्‌या काजे ईछ लेदी, ने तीनाक आपसा पुर्‌यान तसी पाळी-पुसी। ");
INSERT INTO bhi_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ने मुसा काजे मीसर देसेन आखी वीद्‌या भणाया। ने मुसु वातेम ने काम मां जुर भर्‌यु बण गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","जत्‌यार मुसु चाळीस सालेन हय गुयु, ती तेरा मन मां वीच्‌यार आयु की मे मारा ईस्‌रायेली भाय-बेटाक भेळु हव। ");
INSERT INTO bhi_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","तींद्‌रे मायन एक जणा काजे वेला पाड़तेला देखीन मुसु तेरे वळ्‌यु नी हयु, ने मीसर देस वाळा काजे मारीन वेला पाड़नेन बद्‌लु लेदु। ");
INSERT INTO bhi_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","मुसान वीच्‌यार जु हतलु की मारा भायस समजी जासे की भगवान एरे साहरे हामुक छुटकारु आपसे बाकुन चे तसा नी समज्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","दीसरे दाहड़े मुसु दुय ईस्‌रायेली भाय-बेटा काजे लड़ायतेला देख्‌यु, ती चु तींद्‌रेन्‌चां आवीन तीनुक मेळ करावणे करीन तीनुक कह्‌यु, ए भायस्‌यो, तुहुं काहा आंबा-सांबा लड़ायन एक दीसरान नुकसाण कर रया? ");
INSERT INTO bhi_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","बाकुन जु अदमी आपसा भाय-बेटा साते लड़ायन तेरो नुकसाण करी रवलु चु, मुसा काजे धकली देदु, ने कह्‌यु, कुण तुसे काजे हामरु मुखी ने नीयाव करन्‌यु बणावलु छे? ");
INSERT INTO bhi_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","काल ते, तु तीना मीसर देस वाळा काजे मार नाख्‌यु। तसुत मेसे काजे बी मारने हींड रयु काय? ");
INSERT INTO bhi_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","जी वात सामळीन मुसु चां सी ढास गुयु ने मीद्‌यान देस मां परदेसी बणीन रवणे बाजी गुयु। ने तीना मीद्‌यान देसेम तेरा दुय पुर्‌या हया। ");
INSERT INTO bhi_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","जत्‌यार चां रवते-रवते चाळीस साल हय गुया, ती एक भगवानेन सरग वाळु काहवाळ्‌यु, सीनाय बयड़ा पर एक धपतेला काटाळ्‌ळा झाड़का मां देखाव पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ज देखीन मुसु चकराय गुयु, ने धपतेला झाड़का काजे देखणे करीन धड़ेस गुयु, ती चु मालीक भगवान काजे ज कवतेलु सामळ्‌यु, ");
INSERT INTO bhi_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","मे तारा आड़ा-बुड़ान भगवान छे, अब्‌राहमेन, ने इसाकेन, ने याकुपेन भगवान छे। ज सामळीन मुसु थर-थर कापणे बाजी गुयु ने तीनाक धपतेलो झाड़को अळी देखणे हिम्‌मत नी चाली। ");
INSERT INTO bhi_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","तत्‌यार मालीक मुसा काजे ज कह्‌यु, तु तारा पायेम पेहरला चीपल्‌या नीकाळ दे, काहाकी तु जां उबु हय रयु, ची जागा चुखली छे। ");
INSERT INTO bhi_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मे मीसर देस मां रवण्‌या मारा माणसेन वेला काजे देखलु छे; ने तींद्‌रो कासणु ने रड़नु सामेळ्‌लु छे; तेरेसी मे तीनुक छुड़ावणे करीन आवलु छे। हय तीयार हय जां। मे तुसेक मीसर देस मां मकलीस। ");
INSERT INTO bhi_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","तीना मुसा काजे ज कवता जाय्‌न तेरु नीकारु करला, कुण तुसे काजे हामरु मुखी ने नीयाव करन्‌यु बणावीन तीना सरग वाळा भगवानेन काहवाळ्‌यान साहरे तींद्‌रेन्‌चां मकल्‌यु, जु तीनाक धपतेला काटाळ्‌ळा झाड़का मां देखाव पड़लु। ");
INSERT INTO bhi_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","हयुत मुसु तीनुक मीसर देस मां ने रातला समुदर मां ने जंगल मां चाळीस साल लग मटो-मटो वारु काम ने सहलाणी देखाड़ीन तीनुक नीकाळ लायु। ");
INSERT INTO bhi_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","जु हयुत मुसु छे, जु ईस्‌रायेली माणसे काजे ज कह्‌लु, भगवान तुंद्‌रात भायस्‌यो मां सी तुंद्‌रे वाटे मारेन तसु एक धरमी भगवानेन अघली वात बताड़ने वाळु उबु करसे। ");
INSERT INTO bhi_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","मुसु जंगल मां आपणा माणसे मां उबु हय्‌न आपणा आड़ा-बुड़ा ने तीना सरगदुतेन ईचमां भान्‌गड़्‌यु बण्‌यु, जु सीनाय बयड़ा पर तेरे साते वाते लाग्‌यु। तीनाक जीवतेला भगवानेन बुली जड़ी, तेरेसी चु जी भगवानेन बुली आपणुक सामळावे। ");
INSERT INTO bhi_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","बाकुन आपणा आड़ा-बुड़ा तेरी वात मान्‌ने नी हींड्‌या; बाकुन चे मुसान वात काजे टाळ देदा। ने मीसर देस भीणी आपसो मन लागाड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ने चे हारुन काजे कह्‌या, हामरे वाटे असु देवता बणाव, जु हामरे अगळ-अगळ चाल तसु; काहाकी जु मुसु हामु काजे मीसर देस सी लावलु, तेरो काय हयो ने काय नी जाणे हामुक मालुम नी हय। ");
INSERT INTO bhi_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","तीनु दाहड़ाम चे केवड़ान मुरती बणायन तेरे अगळ जनवार्‌या मारीन चड़ाया; ने तेरी पुजा-पाट कर्‌या; ने चे हाते बणावली मुरतीन तीहवार वाळीन खुस हय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","तेरेसी भगवान तींद्‌रे सी आडु देख लेदु, ने चु तीनु काजे सरगेन तारान पुजा करने करीन रवणे देदु; जसु भगवानेन अघली वात बताड़ने वाळा माणसेन किताप मां बी लिखलो छे: ए ईस्‌रायेली माणसेन घरना, तुहुं चाळीस साल लग जंगल मां, मारी पुजा-पाट करने करीन जनवार्‌याक मारीन बली चड़ावला ने रुटा करीन चड़ाया करतेला काय। ");
INSERT INTO bhi_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","तुहुं मेलेक देवतान तम्‌बु काजे, ने रेफान देवतान तारा काजे आपसा खांदा पर हाकलीन ली गुयला, ने तुहुं तीनु मुरत्‌या काजे बी पुठ्‌ये ली गुयला तीनु काजे पुजणे ने आंधणे करीन बणावला हतला। तेरेसी मे तुहुं काजे बेबीलोन ईलाका सी बी लांबे मकली दीस। ");
INSERT INTO bhi_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","जंगल मां हामरा आड़ा-बुड़ा धड़े गवान तम्‌बु हतलु। भगवान मुसा काजे ईना तम्‌बुन बारामां ज हुकुम आप्‌यु हतलु, मे तीना तम्‌बुन सहलाणी तुसे काजे देखाड़लु छे, तीनी सहलाणीन अनुसार तम्‌बु बणावजी। ");
INSERT INTO bhi_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","पछेन चु तम्‌बु अगली पीड़ीन आपणा आड़ा-बुड़ा यहोसुन अगवाय मां जां ली आया; तीने टेमे चे नी-यहुदी धड़े जी धरती हापकी लेदला, काहाकी भगवान नी-यहुदी काजे आपणा आड़ा-बुड़ा अगळ सी नीकाळ देदलु; ने असु करीन चु तम्‌बु दावुदेन टेम लग आपणा आड़ा-बुड़ान हातेम रयु। ");
INSERT INTO bhi_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ईना दावुद पर भगवान गीण-दया कर्‌यु, ने दावुद जी हेर कर्‌यु की मे याकुपेन भगवान वाटे एक मंदीर बणावीस। ");
INSERT INTO bhi_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","बाकुन सुलेमान याकुपेन भगवान वाटे मंदीर बणायु। ");
INSERT INTO bhi_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","तेबी आखाम उचु रवण्‌यु भगवान माणसेन साहरे बणावला घर मां नी रयु, जसु भगवानेन अघली वात बताड़ने वाळु माणुस कवे, ");
INSERT INTO bhi_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","सरग मारी राजगादी छे, ने धरती मारी पायेन पयड़ी छे, तुहुं मार वाटे काहनु मंदीर बणावसु? मालीक पुछे, मार वाटे आराम करनेन असु काहनु जागु छे, जां मे आराम करो? ");
INSERT INTO bhi_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","काय ज आखो मार हात सी बणावलो नी हय काय? ");
INSERT INTO bhi_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ए काठला, ने मन ने कान्‌टान नी फतरी काटाड़ला माणसे! तुहुं जलम चुखली-आत्‌मान वीरुद कर्‌या करे। तुहुं तुंद्‌रा आड़ा-बुड़ान तसा छे। ");
INSERT INTO bhi_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","तुंद्‌रा आड़ा-बुड़ा काहना भगवानेन अघली वात बताड़ने वाळु माणुस काजे वेला नी पाड़्‌या? चेते तीनु भगवानेन अघली वात बताड़ने वाळु माणुस काजे मार नाख्‌या, जे पेहले सी तीना वारलु माणसेन बारामां कवला, जु आवणे वाळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","तुहुं काजे सरग वाळा भगवानेन अघली वात बताड़ने वाळान साहरे कायदु ते जड़्‌यु, बाकुन तीना कायदा काजे तुहुं पाळ्‌या नी। ");
INSERT INTO bhi_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","जे स्‌तीफनुसेन वात सामळीन बेसका जबर रीसाय गुया, ने तेरे पर दात ककड़ावणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","बाकुन चुखली-आत्‌मा स्‌तीफनुस मां पुरु-पुरु भरायन कब्‌जा मां कर लेदु ने चु सरगे भीणी एक हेट्‌यु देख्‌यु, ने भगवानेन सेक-सींगार काजे ने ईसु मसी काजे भगवानेन जेवड़्‌ये आन्‌गे उबु हय रवलु देख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ने चु कय पड़्‌यु, “सामळु! मे सरगे काजे उघड़लो, ने माणसेन पुर्‌या काजे भगवानेन जेवड़्‌ये आन्‌गे बसी रवलु देख रयु।” ");
INSERT INTO bhi_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","तेरी वात सामळीन चे आपसा कान्‌टा बुज लेदा, ने आखा एक वळा हय्‌न तेरे भीणी हुड़दीन आया। ");
INSERT INTO bhi_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ने तीनाक सहरे सी घीसड़ीन बाहर ली गुया, ने गवा देण्‌या माणसे आपसा पुथल्‌या नीकाळीन सावुल नावेन एक जुवान माणुस अगळ मेल देदा। ");
INSERT INTO bhi_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ने चे माणसे स्‌तीफनुस काजे दगड़ाटतात रया, ने चु असु वीन्‌ती कर्‌यु, “मालीक ईसु! मारा जीव काजे आवरी ले।” ");
INSERT INTO bhi_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ती चु मुंहडान भुरसे हीट पड़्‌यु ने जुर सी आयड़ीन कह्‌यु, “मालीक! ईना पाप-गुनान डंड ईनुक घुण आपे।” ने ज कयदीन चु मर गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","सावुल स्‌तीफनुसेन हत्‌याम राजी हतलु। तीने दाहड़े सी माणसे यरुसलेमेन मंडळी काजे बेसका वेला पाड़नु सुरु कर देदा, ने ईसुन नेवताळा काजे छुड़ीन आखान-आखा यहुदीया जीला मां ने सामर्‌या जीला मां रावण्‌या-तीवण्‌या हय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ईसुन भगत माणसे स्‌तीफनुसेन लास काजे बेसका रड़ता जाय्‌न वगे कर देदा। ");
INSERT INTO bhi_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","सावुल तीनी टेमे ईसुन मंडळी काजे वेला पाड़ी रवला; ने चु ईसुन आखा माणसेन घर-घर जाय्‌न अदमीक ने बायराक घीसड़ी-घीसड़ीन लाय्‌न जेल मां नाखतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","जे माणसे अथा-अथान रावण्‌या-तीवण्‌या हय गुयला चे हींडी-हींडीन ईसुन खुस-खबर सामळावणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ने फीलीप्‌पुस, सामर्‌या जीलान एक सहर मां जाय्‌न चां ईसु मसीन बमदीन परचार करने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","जत्‌यार माणसे फीलीप्‌पुसेन वात सामळीन ने तेरे हाते हवतेली वारु कामेन सहलाणी देखीन, एक मन्‌या हय्‌न बेसका मन लागाड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","काहाकी बेसका जणाम सी वीटेळ्‌ळा भुतड़ा आयड़ीन नीकळी गुयला, ने बेसका लखवान मांदवाड़ वाळा ने लंगड़ा वारका हय गुयला। ");
INSERT INTO bhi_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","अळी तीना सहर मां खुसी आय गुई। ");
INSERT INTO bhi_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","सीमोन नावेन एक अदमी फीलीप सी पेहलेत ईना सहरेम आय रवलु। चु जादुन खेल देखाड़ीन सामर्‌या सहर वाळाक चकराड़ रवलु, ने आपसा काजे मे बेसकु-भारी माणुस छे, करीन आपसा काजे बेसकु मटु समजतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","नानला सी मटला लग आखा माणसे तेरी वात मान्‌ता हतला, ने कवतेला, “जु माणुस भगवानेन ची ताकत छे, जी बेसकी-भारी कवाये।” ");
INSERT INTO bhi_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","चु बेसका दाहड़ा सी जादुन खेल-खेलीन आखाक चकराड़ रयु, आखा माणसे तीनाक बेसका मानतेला। ");
INSERT INTO bhi_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","बाकुन जत्‌यार चे माणसे फीलीप्‌पुसेन साहरे भगवानेन राजेन खुस-खबर ने ईसु मसीन नाव सामळ्‌या, ईसु पर भुरसु कर्‌या ने बायरा ने अदमी बपतीस्‌मा लेणे बाजी-गुया। ");
INSERT INTO bhi_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ने सीमोन बी ईसु पर भुरसु कर्‌यु ने बपतीस्‌मा ली लेदु ने अळी फीलीप्‌पुस पुठ्‌ये रवणे बाजी गुया। ने फीलीपन साहरे वारु कामेन सहलाणी ने मटा-मटा बेसका वारु कामे देख्‌यु, ती चकराय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","जत्‌यार यरुसलेम मां रवण्‌या ईसुन नेवताळा ज सामळ्‌या की सामर्‌या वाळा भगवानेन बुल काजे मान लेदा, ती चे पतरस ने युहन्‌ना काजे तींद्‌रेन्‌चां मकल्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","चे जाय्‌न सामर्‌यान भुरसु करने वाळा वाटे भगवान धड़े दुवा कर्‌या की ईनुक चुखली-आत्‌मा जड़नु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","काहाकी हय लग तीनु काजे चुखली-आत्‌मा नी जड़्‌यु, तीनुक मालीक ईसुन नावे बपतीस्‌मा अतरोत आप्‌ला हतला। ");
INSERT INTO bhi_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","अतरे पतरस ने युहन्‌‌‌नु तींद्‌रे पर हात मेक्‌या ने तीनुक चुखली-आत्‌मा जड़ गुय। ");
INSERT INTO bhi_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","सीमोन ज देख्‌यु की ईसुन नेवताळा माणसे पर हात मेके अतरात ने तीनुक चुखली-आत्‌मा जड़ जाय। तेरेसी चु तींद्‌रेन्‌चां रुप्‌या लावीन कह्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“मे तेरे पर बी हात मेको तीनाक चुखली-आत्‌मा जड़ जाणु चाहजे, असु हक मेसेक बी आपु।” ");
INSERT INTO bhi_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","बाकुन पतरस तीनाक जपाप आप्‌यु, “तारे पुठ्‌ये तारा रुप्‌या बी सर जाणु चाहे, काहाकी तु भगवानेन वाटा काजे रुप्‌या आपीन हात करनेन हेर कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ईनी वातेम तारु हीस्‌सु बी नी हय, ने हक बी नी हय। काहाकी भगवान अगळ तारो मन सुदो नी हय। ");
INSERT INTO bhi_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","हेरे सी तु तारा ईना भुंडा मन सी फीरीन भगवान सुदु वळ ने मालीक ईसु सी वीन्‌ती कर। कांखुर मायन भगवान तारा मनेन वीच्‌यारेन माफी आप देय ते आप देय। ");
INSERT INTO bhi_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","काहाकी मेसेक चुखोझण देखाव पड़ रयो की तु आखी भातीन पाप मां फांदायलु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","जी वात सामळीन सीमोन जपाप देदु, “तु जी बी वात कवलु छे, तसों मार धड़े नी हवणु चाहे, करीन तुहुं मालीक भगवान धड़े मारे वाटे वीन्‌ती करु!” ");
INSERT INTO bhi_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","अळतेन चे ईसुन नेवताळा, मालीक ईसुन गवाय दीन ने भगवानेन बुल सामळावीन यरुसलेम पछा जात रया, ने वाट्‌ये-वाट्‌ये बेसका सामर्‌या जीलान गांव मां ईसुन खुस-खबर सामळावता गुया। ");
INSERT INTO bhi_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","अळतेन मालीक भगवानेन एक सरग वाळु काहवाळ्‌यु फीलीप्‌पुस काजे कह्‌यु, “उठ यरुसलेम सी गाजा सहर भीणी जाणे वाळी वाट पर दाखणाव जां।” जी वाट उजाड़ी बयड़ा मां छे। ");
INSERT INTO bhi_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","सरग वाळा भगवानेन अघली वात बताड़ने वाळान वात सामळीन फीलीप्‌पुस उठीन चाल पड़्‌यु। चां वाट्‌येत कुस देसेन एक माणुस जाणे बाजी रवलु, चु गतराड़ु हतलु ने कुस देसेन कंदाके राणीन एक मंत्‌री ने पयस्‌या टकान हीसाब राखण्‌यु हतलु, ने चु भगवानेन पुजा-पाट करने करीन यरुसलेम आवलु हतलु, ने पुजा-पाट करीन पछु जाणे बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","चु आपसी घुड़ागाडी पर बस रवलु, ने भगवानेन अघली वात बताड़ने वाळु यसायान किताप भन्‌ने बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","भगवानेन चुखली-आत्‌मा फीलीप्‌पुस काजे कह्‌यु, “अगु जां, ने घुड़ागाडी पुठ्‌ये चाल पड़।” ");
INSERT INTO bhi_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फीलीप्‌पुस दवड़ीन तेरेन्‌चां गुयु ने चु तीनाक भगवानेन अघली वात बताड़ने वाळु यसायान किताप भणतेलु सामळ्‌यु, ने तीनाक पुछ्‌यु, “तु जी वात भन्‌ने बाजी रयु, जी वात समजी रयु काय?” ");
INSERT INTO bhi_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","चु अधीकारी जपाप आप्‌यु, “जत्‌यार लग कुय मेसेक नी समाजड़े, ती लग मे कसु समजो?” ज कयदीन चु फीलीप्‌पुस काजे आपसी घुड़ागाडी पर चड़ावीन बठाड़ लेदु। ");
INSERT INTO bhi_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","खरला सास्‌तुरेन ज पाठ चु भन्‌ने बाजी रवलु, च पाठ ज हतलो तीना काजे गाडरान तसा मारने करीन ली गुया, ने जसों गाडरो तेरा कान्‌या काटणेन टेमे हुगो हय रवे, तसुत चु हुगु हय रयु, ने आपसो मुंहडो लग नी उगाड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","चु भुळु बणीन रयु, बाकुन ईने टेमे तेरु नीयाव नी हयु, ने तीनी टेमेन माणसेन बारामां कुण कवसे, काहाकी धरती पर सी तेरी जीवाय हाकलाय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ईनी टेमे गतराड़ु फीलीप्‌पुस काजे पुछ्‌यु, “तु मेसेक दया करीन देखाड़ की भगवानेन अघली वात बताड़ने वाळु माणुस जी वात कुणीन बारामां कय रयु, आपसा बारामां कय रयु की काहना दीसरान बारामां कय रयु?” ");
INSERT INTO bhi_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ती फीलीप्‌पुस ईनी खरली सास्‌तुरेम सी सुरु करीन ईसुन खुस-खबर सामळायु। ");
INSERT INTO bhi_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","वाटे चालता-चालता चे पाणी हतलो चां आखा पुग गुया। पाणीक देखीन गतराड़ु कह्‌यु, “देख, पलो हयो पाणी। हय मेसेक बपतीस्‌मा लेणेम काय रुक छे?” ");
INSERT INTO bhi_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फीलीप्‌पुस कह्‌यु, कदी तु पुरो-पुरो मन लागाड़ीन भुरसु करे, ती ली सके। चु जपाप आप्‌यु, “हव, मे भुरसु करो की ईसु मसी भगवानेन पुर्‌यु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","तत्‌यार गतराड़ु घुड़ागाडी चालाड़न्‌याक घुड़ागाडीक उबराक दे कह्‌यु, ने फीलीप्‌पुस ने गतराड़ु दुय जणा पाणी मां भराया ने फीलीप्‌पुस तीनाक पाणी मां बपतीस्‌मा आप्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","जत्‌यार चे पाणीम सी बाहर आया, ती मालीक चुखली-आत्‌मा फीलीप्‌पुस काजे ईछ ली गुय। गतराड़ु, तीना फीलीप्‌पुस काजे अळी नी देख्‌यु; ने चु गतराड़ु खुस हय्‌न आपसे वाटे-वाटे अगु चाल पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ने फीलीप्‌पुस असदोद मां देखाव पड़्‌यु, ने चु जत्‌यार लग केसर्‌या नी पुग्‌यु, ती लग सहरे सहरेम ईसुन खुस-खबर सामळावतु गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","सावुल, भगवानेन डाहला पुजारान्‌चां गुयु, सावुल हय बी मालीक ईसुन चेला काजे धमकी दीन तीनुक माराड़ने हींडी रवला। ");
INSERT INTO bhi_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ने चु भगवानेन वाट देखान्‌या अगवाय करन्‌यान चां जाय्‌न, दमीस्‌क सहरेन यहुदी माणसेन भक्‌तीन घरेन नावे ईसुक मान्‌या अदमीक ने बायराक बांदीन यरुसलेम लावणेन हक मांग लायु। ");
INSERT INTO bhi_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","बाकुन चालते-चालते सावुल दमीस्‌क सहर धड़े पुग्‌यु, ती उचकाणुन सरगे सी तेरे चारेमेर वीजाळो हय गुयो। ");
INSERT INTO bhi_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","चु सावुल भुयमां हीट पड़्‌यु, ने तीनुक असु कवतेलु एक बुल सामळायु, “सावुल! ए सावुल! तु मेसेक काहा वेला पाड़े?” ");
INSERT INTO bhi_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","सावुल कह्‌यु, “मालीक! तु कुण छे?” सावुल काजे पछु सामळायु। “मे ईसु छे, तीनाक तु वेला पाड़ रयु। ");
INSERT INTO bhi_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","बाकुन हय तु उठीन सहरेम जां, ने तुसेक ज करनु चाहे च, मे तुसेक देखाड़ दीस।” ");
INSERT INTO bhi_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","जे माणसे सावुल भेळा हतला, चे तसात उबा हय्‌न देखतात रया; काहाकी चे बुल ते सामळतेला बाकुन तीनुक कुय बी देखाव नी पड़्‌यो। ");
INSERT INTO bhi_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","अळी सावुल भुयमां सी उठ्‌यु, ने डुळा उगाड़्‌यु बाकुन तीनाक ईतरोक बी नी देखायो। अळी तेरा साती तेरु हात धरीन तीनाक दमीस्‌क सहर ली गुया। ");
INSERT INTO bhi_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ने तीनाक तीन दाहड़ा लग काय बी नी देखायो, ने तीने टेमे चु खाणो बी नी खादु ने पाणी बी नी पीदु। ");
INSERT INTO bhi_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमीस्‌क सहर मां हनन्‌या नावेन एक भुरसु करने वाळु चेलु रवतेलु। मालीक ईसु तीनाक देखीन कह्‌यु, “ए हनन्‌या!” चु हनन्‌यु कह्‌यु, “हव, मालीक मे सामळी रयु।” ");
INSERT INTO bhi_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ती मालीक तीना हनन्‌या काजे कह्‌यु, “उठीन, ‘सुदी’ नावेन गळी मां जां, ने यहुदान घर मां जाय्‌न तरसुस मां रवण्‌या सावुलेन बारामां पतु लागाड़ ले; काहाकी चु भगवान धड़े वीन्‌ती करने बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ने चु दाखलु छे की ‘जु अळी पछु देखणे बाजी जाणु चाहे’ करीन हनन्‌या नावेन एक अदमी माहीं आवीन मार मुणका पर हात मेल रयु।” ");
INSERT INTO bhi_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हनन्‌या वात टाळतु जाय्‌न जपाप आप्‌यु, “ए मालीक! मे जाहान माणसे धड़े सी एरे बारामां सामळी रयु की चु अदमी यरुसलेम मां तारा चुखला माणसे काजे बेसकु वेला पाड़ीन नुकसाण करलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ने ‘जे माणसे तार नाव पर भुरसु करे, तीनु आखा काजे बांदीन ली आवणु चाहे।’ करीन हीनाक भगवानेन डाहला पुजारा धड़े सी हक जड़लु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","बाकुन मालीक ईसु, हनन्‌या काजे कह्‌यु, तु जात रव! काहाकी मे हीना काजे आखा नी-यहुदी माणसे अगळ, ने राजा अगळ, ने ईस्‌रायली जातीन माणसेन अगळ मारो नाव उजेंतो करने करीन नेवाड़लु छे। ");
INSERT INTO bhi_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ने मार नावे हीनाक कसा दुख झेलनु पड़से, ची वात मे देखाड़ीस। ");
INSERT INTO bhi_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ती हनन्‌या चां सी उठीन सावुल हतलु, चां गुयु, ने घर मां जाय्‌न सावुल पर हात मेकीन कह्‌यु, “ए भाय सावुल, तु पछु देखणे बाजी जाणु चाहे करीन ने चुखली-आत्‌मा तारे मां पुरी भराय जाणु चाहे करीन, मालीक मतलब ईसु, मेसे काजे तारेन चां मकेल्‌लु छे, जु तुसे काजे वाटे देखाव पड़लु।” ");
INSERT INTO bhi_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ने तत्‌यारुत सावुलेन डुळा मां सी छलटान तसा काहींग पड़्‌यो, ने चु पछु देखणे बाजी गुयु ने उठीन पाणीम बपतीस्‌मा लेदु; ");
INSERT INTO bhi_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","अळी खाणु खाय्‌न टणकु हय गुयु। ने चु सावुल दमीस्‌क मां रवण्‌या ईसुन चेला पुठ्‌ये थुड़ाक दाहड़ा रयु। ");
INSERT INTO bhi_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ने अळी चु मामार यहुदी माणसेन भक्‌तीन घर मां जाय्‌न जुर सी ईसुन परचार ज कय्‌न करने बाजी गुयु की “ईसुत भगवानेन पुर्‌यु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ने आखा सामळन्‌या चकराय्‌न कवणे बाजी गुया, “जु चु माणुस नी हय काय, जु यरुसलेम मां ईसुन नाव लीन वीन्‌ती करन्‌या काजे जनम सीत सारनेन कुसीत करतेलु? ने हयु जां बी एरेन करीन आवलु हतलु, की तीनुक धरीन भगवानेन पुजारान्‌चां ली जाय।” ");
INSERT INTO bhi_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","बाकुन सावुलेन जुर अळी बी वदतु गुयु, ने चु पुरावु दी-दीन ज कवतेलु की “ईसुत मसी छे।” असु करीन चु दमीस्‌क मां रवण्‌या यहुदी माणसेन बुलती बंद करतु रयु। ");
INSERT INTO bhi_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","जत्‌यार बेसका दाहड़ा हय गुया, ती यहुदी माणसे तीनुक मुजगी करीन मार नाखणेन जाळसांदी बणाया। ");
INSERT INTO bhi_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","बाकुन सावुल काजे तींद्‌री जाळसांदीन बारामां पतु चाल गुयु। चे ते सावुल काजे रात दाहड़ु मारने करीन सहरेन झपला पर डेंगु लीन काठु पहरु दी रवला। ");
INSERT INTO bhi_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","बाकुन राते सावुलेन चेला सावुलेक ली जाय्‌न चार्‌या मां बठाड़्‌या, ने सहरेन चारेमेर भीतड़ा पर सी चार्‌यो टांगीन नेचा उतारीन ढासाड़ देदा। ");
INSERT INTO bhi_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","जत्‌यार सावुल यरुसलेम पुग्‌यु, ती चु ईसुन चेलान टुळा मां भेसकायणे कर्‌यु, बाकुन चे आखा तीनाक देखीन बीहतेला, काहाकी तीनुक भुरसु नी हयु की जु बी छाचलीन चेलु बण गुयलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","बाकुन बरनाबास, सावुल काजे ईसुन नेवताळान्‌चां ली जाय्‌न तीनुक कह्‌यु की “सावुल काजे मालीक वाटे देखाव पड़्‌यु ने तेरे साते वार करलु छे, ने जु सावुल दमीस्‌क सहरेम बीहे बीगुर ईसुन नावेन परचार करलु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","अळी सावुल यरुसलेम मां चेलान्‌चां आवतु-जातु रयु। ने चु बीहे बीगुर मालीकेन नावेन परचार करतु रयु। ");
INSERT INTO bhi_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ने चु युनानी बुली बुलन्‌या यहुदी साते वातेम जखड़ी रयु; बाकुन चे तीनाक मार नाखणेन कुसीत कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","जत्‌यार सावुलेन भाय बंद्‌या काजे पतु चाल्‌यु ती चे तीनाक केसर्‌या सहर मां ली जात रया ने अळी तीनाक तरसुस मकली देदा। ");
INSERT INTO bhi_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","तीनी टेमे आखा यहुदीया जीला मां, ने गलील जीला मां, ने सामर्‌या जीला मां ईसुन मंडळी काजे सुक-सांती जड़ी, ने ईसुन मां नवला माणसे जुड़ायता गुया; ने तीनी काजे मालीक ईसुन डर सी ने दीलासु आपण्‌या चुखला चुखली-आत्‌मा मां वदती जातली। ");
INSERT INTO bhi_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","पतरस तीना आखा परगाणाम फीरी-फीरीन, लीद्‌दा मां ईसुन चुखला माणसेक भेळु हवणे गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","चां तीनाक एनीयास नावेन एक माणुस भेळु हयु, चु आठ साल लग गुदड़ा मां पड़ी रवलु। काहाकी तेरे लखवु दुख हात लाग रवलो। ");
INSERT INTO bhi_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पतरस तीना काजे कह्‌यु, “ए एनीयास! ईसु मसी तुसेक वारु करे। उठ ने तारो गुदड़ो सय करीन मेल।” ने चु तत्‌यारुत उठीन उबु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","तत्‌यार लीद्‌दा ने सारोन मां रवण्‌या माणसे तीना वारु हवला माणसेक देख्‌या ने चे मालीक ईसु पर भुरसु करीन मान लेदा। ");
INSERT INTO bhi_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","याफा मां तबीता मतलब दोरकास नावेन ईसुन एक चेली रवतेली। ची बेसकी दीसरान भलाय करतेली ने गरीबेक दान आप्‌या करतेली। ");
INSERT INTO bhi_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","तीनु दाहड़ाम ची मांदी पड़ी ने मर गुय; ने माणसे तेरी लास काजे उंघळावीन घरेन उपरी कमरा मां ली जाय्‌न मेल देदा। ");
INSERT INTO bhi_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लीद्‌दा याफा सहर सी लांबे नी हतली, ने चेला ज सामळ्‌या की पतरस लीद्‌दा मां छे ती दुय अदमी काजे मकलीन तीनाक जी वीन्‌ती कर्‌या, की “तु मामार हामरेन्‌चां आव, ने वार मां लागाड़े।” ");
INSERT INTO bhi_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","पतरस तत्‌यारुत तींद्‌रे पुठ्‌ये चाल पड़्‌यु ने जत्‌यार चु याफा मां पुग्‌यु, ती माणसे तीनाक उपरी पर ली गुया; ने आखा रांडायला बायरा रड़ता जाय्‌न आवीन तेरे चारेमेर उबा हय गुया; ने कुरतो ने पुथल्‌या दोरकास तींद्‌रे पुठ्‌ये रय्‌न बणावली हतली, चे कुरता ने पुथल्‌या देखाड़ने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ती पतरस आखाक बाहर मकली देदु, ने मांडा टेकीन भगवान धड़े दुवा कर्‌यु; ने लास भीणी देखीन कह्‌यु, “ए तबीता! उठ।” तत्‌यार ची आपसा डुळा उगाड़ देदी, ने पतरस काजे देखीन उठीन बठ गुय। ");
INSERT INTO bhi_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","पतरस तीनीक हात धरीन उठाड़्‌यु, ने चुखला माणसेक ने रांडायला बायरा काजे बुलावीन तीनीक जीवती-जागती तींद्‌रे अगळ उबी कर देदु। ");
INSERT INTO bhi_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","जी वात आखा याफा सहर मां फेलाय गुय, ने बेसका माणसे मालीक ईसु पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ने पतरस थुड़ाक दाहड़ा लग याफा सहर मां सीमोन नावेन एक चमारटान्‌चां रयु। ");
INSERT INTO bhi_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","केसर्‌या सहर मां कुरनेलीयुस नावेन एक माणुस रहतेलु, चु ईताल्‌या नावेन सीपायड़ान टुळान सुबेदार हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","चु सुबेदार भगवानेन भक्‌ती करने वाळु हतलु, ने आपसा घराणा भेळ भगवानेक बीहीन जीवतेलु, ने यहुदी गरीब माणसेक बेसकु दान आपतेलु, ने दाहड़ीन भगवान सी दुवा कर्‌या करतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","चु काहनेस दाहड़े मांजणीक वेळाय भगवानेन सरगे काहवाळ्‌या काजे असु कवतेलु सामळ्‌यु, “ए कुरनेलीयुस।” ");
INSERT INTO bhi_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","चु कुरनेलीयुस सरग वाळा काहवाळ्‌या भीणी देखीन कह्‌यु, “ए मालीक काय वात छे?” ने सरगेन भगवानेन अघली वात बताड़ने वाळु कह्‌यु, “भगवान सी तु जी दुवा करे ची दुवा ने तु गरीबेक ज दान आपे, च दान तुसेक हेर करावणे करीन भगवानेन चां पुग गुयलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ने हय तु अदमी काजे याफा सहर मां मकलीन सीमोन काजे जां बुलाय ले, जु पतरस कहवाये। ");
INSERT INTO bhi_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","चु सीमोन नावेन एक चामड़ान धंदु करने वाळान्‌चां मेजवान्‌यु जाय रयु। तीना सीमोन चमारटान घर समुदर धड़े छे।” ");
INSERT INTO bhi_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ने चु भगवानेन सरग वाळु काहवाळ्‌यु चां सी जाती रयु, ती कुरनेलीयुस आपसा दुय पावर्‌या काजे जे तेरे पुठ्‌येत रहतेला, ने एक भगत सीपायड़ा काजे बुलायु, ");
INSERT INTO bhi_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ने तीनुक आखी वात समजाड़ीन याफा सहर मां मकली देदु। ");
INSERT INTO bhi_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","दीसरे दाहड़े वाटे चालता-चालता सहर धड़े आवणे बाजी रवला, ती पतरस मांजणीक वेळाय घरेन छत पर चहड़्‌यु ने भगवान सी दुवा करने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ने तत्‌यार तीनाक भुक लागी, ने चु थुड़ोक खाणेन वीच्‌यार कर रयु बाकुन दीसरा खाणो रांदणे बाजी रवला ती पतरस चुखला चुखली-आत्‌मान कब्‌जा मां हय गुयु ने तीनाक मालुम नी रह्‌यो; ");
INSERT INTO bhi_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ने चु देख्‌यु, की सरग उघड़ी गुयो; ने लांबा-चोवड़ा चादरान तसी काहनीस चीज काजे सरगे सी आथराय्‌न, उतरने बाजी रय ने तेरा च्‌यारु खुणा धरती पर मेकाय रया। ");
INSERT INTO bhi_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ईनी धरती पर आखी भातीन च्‌यारपाया जनवार्‌या ने घीसाय्‌न चालन्‌या जनवार्‌या ने सरगेन चिरला हतला। ");
INSERT INTO bhi_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","पछेन अळी एक वात सामळाय की, “ए पतरस उठ, ने ईनुक मारीन खा।” ");
INSERT INTO bhi_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","बाकुन पतरस कह्‌यु, “ए मालीक, मे ईनुक कदी मारीन नी खाम, काहाकी मे मुयळ्‌ळी ने वीटेळ्‌ळी चीज आज लग नी खादु।” ");
INSERT INTO bhi_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","पछेन दीसरी कावा अळी चीत वात सामळाय, “ज काय भगवान तीनी चीजेक चुखली कवलु छे, तीनी चीजेक तु वीटेळ्‌ळी घुण कवे।” ");
INSERT INTO bhi_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","असो तीन कावा हयो; ने तत्‌यारुत चो चादरा साय चीज सरगे मां पछी हाकलाय गुय। ");
INSERT INTO bhi_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ने पतरस जो देखलु, तेरे बाराम संका वीच्‌यार करने बाजी रवलु, ती कुरनेलीयुस दुय पावर्‌या ने सीपायड़ु चमारटा सीमोनेन घर आय लाग्‌या ने सीमोनेन घर कां छे? करीन पुछणे बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ने चे घर वाळा माणसेक बाहर रय्‌न आयड़ीन पुछ्‌या, “सीमोन, जु पतरस कह्‌वाये, जांत मेजवान्‌यु आय रयु, काय?” ");
INSERT INTO bhi_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पतरस च देखलु तेरे बारामां सुची रवलु, की आत्‌मा काय कवली, “देख, तीन माणसे तुसेक हेरता-हेरता आय रया। ");
INSERT INTO bhi_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","तेरेसी उठीन नेचु जां, ने धाक राखे पाखुर तींद्‌रे पुठ्‌ये जात रव; काहाकी हीनुक मेत मकेल्‌लु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","तत्‌यार पतरस नेचु उतरीन तीनु माणसेक कह्‌यु, “देखु, तीनाक तुहुं हेरता-हेरता आय रया, चु मेत छे। तुहुं काय कामे आय रया?” ");
INSERT INTO bhi_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","चे माणसे कह्‌या, “टुळान सुबेदार कुरनेलीयुस धरमी ने भगवानेक बीहीन जीवण्‌यु छे आखा यहुदी जाती मां वारलु आव-भाव वाळु माणुस छे, चुखलु सरग वाळु भगवानेन अघली वात बताड़ने वाळु कवलु छे की तु पतरस काजे तारे घर बुलाय लाव ने जो काय चु कवसे तेरी वात सामळजी।” ");
INSERT INTO bhi_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","तत्‌यार पतरस तीनुक घर मां माहें बुलायु ने आव-भाव करीन तींद्‌री मेजवानी कर्‌यु, ने चे चांहान रात रया। ने दीसरे दाहड़े पतरस तींद्‌रे पुठ्‌ये तीयार हय्‌न जाती रयु, ने तीना याफा सहर मां रवण्‌या ईसुक मान्‌या भाय-बेटा बी तेरे साते गुया। ");
INSERT INTO bhi_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","दीसरे दाहड़े चे केसर्‌या पुग्‌या, ने कुरनेलीयुस तेरा भाय-बेटा काजे ने अळी थुड़ाक साथी काजे भेळा करीन तींद्‌री वाट देख तेलु। ");
INSERT INTO bhi_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","जत्‌यार पतरस कुरनेलीयुसेन घर आयु ने तेरा घर मां भरायणे बाजी रवलु, ती चु कुरनेलीयुस काजे भेळु हयु, ने कुरनेलीयुस पतरसेन पाये पड़ीन पतरस काजे वारु छे की करीन कह्‌यु; ");
INSERT INTO bhi_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","बाकुन पतरस तीनाक उठाड़ीन कह्‌यु, “उबु हय जां, मे बी सीरप एक माणुस छे।” ");
INSERT INTO bhi_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ने पतरस कुरनेलीयुस साते वात करतु-करतु घर मां भरायु, ने चां बेसका माणसे काजे भेळा हय रवला काजे देख्‌यु ");
INSERT INTO bhi_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","चु तीनाक ज कह्‌यु, “तुहुं काजे जी वात मालुम छे की यहुदी माणसे वाटे, नी-यहुदी घर आवणु-जाणु ने तींद्‌रे पुठ्‌ये उठणु-बसणु कायदान वीरुद छे। बाकुन भगवान मेसेक कवलु छे की ‘तु काहना बी माणुस काजे मुयळ्‌ळु ने वीटेळ्‌ळु मां कवे।’ ");
INSERT INTO bhi_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","तेरेसी मेसेक बुलावणे आया, ती मे काय बी पुछे बीगुर जां आय गुयु; हय मे तुसेक पुछो की तु मेसेक काय कामे बुलाय रयु?” ");
INSERT INTO bhi_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","कुरनेलीयुस कह्‌यु, “ईनेत टेमे, आज सी च्‌यार दाहड़ा पेहेल मे मारा घर मां मांजणीक दाहड़े भगवान धड़े दुवा करने बाजी रवलु, ती एक अदमी झळो-झळो करता पुथल्‌या पेहरीन मार अगळ उचकाणुन आवीन उबु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ने कवणे बाजी गुयु, ए कुरनेलीयुस, जी दुवा तु भगवान सी करे ची दुवा, ने जे तु गरीबेक दान करे चे हेर कराड़ने करीन भगवानेन्‌चां पुग गुयलो छे। ");
INSERT INTO bhi_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","तेरेसी हय तु अदमी काजे याफा मां मकलीन सीमोन काजे जां बुलाय ले, जु पतरस कवाये। चु सीमोन नावेन एक चमारटान घर मेजवान्‌यु जाय रयु। तीना सीमोन चमारटान घर समुदर धड़े छे; ");
INSERT INTO bhi_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ने तेरी वात सामळीन तत्‌यारुत माणसेक तारेन चां मकली देदु, ने तु जां आवीन वारु करलु छे। हय ज काय मालीक भगवान तुसेक कवणे करीन हुकुम आप्‌लु छे, च सामळने करीन हामु जां आखा भगवान अगळ हजुर छे।” ");
INSERT INTO bhi_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ज आखो सामळीन पतरस कह्‌यु, “हय मे छाचलीन समजी गुयु, की भगवान काहनान मुंहडा देखीन छीट नी राखे। ");
INSERT INTO bhi_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","बाकुन जु काहनुक तीनाक बीहीन जीवे ने धरमेन काम करे, चु माणुस भगवान काजे गमे, भले चु काहनी बी जातीन माणुस कांखुर नी हय। ");
INSERT INTO bhi_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ने जीत सुक-सांती आपणी खुस-खबर छे, तीनी काजे भगवान ईसु मसीन साहरे ईस्‌रायेली जातीन माणसे काजे सामळावलु हतलु। ने हीयुत ईसु मसी आखान मालीक छे। ");
INSERT INTO bhi_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","तुहुंक ते, तीनी मट्‌ली वीत्‌ली वातेन बारामां मालुम छे, जी गलील जीला मां सुरु कर्‌यु, ने युहन्‌‌‌नु बपतीस्‌मा आप्‌यु ने अळी तेरे बारामां खुस-खबरेन परचार हयो। ने ची वात आखा यहुदीया जीला मां पुग गुय। ");
INSERT INTO bhi_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","तुहुं नासरेत वाळा ईसुन बारामां जाणु की भगवान तीनाक आपसी ताकत ने चुखली-आत्‌मा आपीन नेवाड़ लेदु, ने चु ईसु वारलु कामे करतु जाय्‌न भलाय कर्‌यु, ने जतरा बी भुतड़ान कब्‌जा मां हतला, तीनुक चु छुड़ावतु रयु; काहाकी भगवान तेरे पुठ्‌ये हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ने जु ईसु, यहुदीया जीला मां, ने यरुसलेम मां जे बी काम कर्‌यु, तीना आखा कामेन हामु गवा छे। बाकुन तीना ईसुक माणसे कुरुस पर मार नाख्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","बाकुन भगवान तीनाक तीसरे दाहड़े मर्‌या-सर्‌याम सी जीवाड़्‌यु ने तीनाक उजेंतु देखाव पड़ने देदु। ");
INSERT INTO bhi_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","आखा माणसे अगळ देखाव नी, पड़ने देदु, बाकुन तीना गवा देण्‌या अगळ उजेंतु कर्‌यु। तीनुक चु भगवान नेवाड़ लेदलु, मतलब हामरे अगळ उजेंतु कर्‌यु। चु मर्‌या-सर्‌याम सी जीवतु हय गुयु ने अळी हामु तेरे पुठ्‌ये खादा-पीदा ");
INSERT INTO bhi_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ने चु भगवान हामुक हुकुम आप्‌लु छे, की ‘तुहुं माणसे मां ईना ईसुन परचार करु; ने गवा देवु, की जु ईसु हयुत छे; तीना काजे भगवान जीवतेलान ने मरलान नीयाव करन्‌यु नक्‌खी करलु छे।’ ");
INSERT INTO bhi_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ईना ईसुन बारामां आखा भगवानेन अघली वात बताड़ने वाळा माणसे असी गवा देदला, की जु कुय ईसु पर भुरसु करसे, तीनात काजे ईसुन नावे पापेन माफी जड़से।” ");
INSERT INTO bhi_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पतरस जी वात कवणे बाजी रवलु, ने चुखली-आत्‌मा तीनु भगवानेन बुल सामळन्‌या पर सरगे सी उतरीन आय लाग्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","नी-यहुदी माणसे काजे बी चुखली-आत्‌मान वाटु जड़ गुयु करीन पतरस पुठ्‌ये याफा सी आवला फतरी काटला यहुदी माणसे चकराय गुया, ने यहुदी माणसे बी ईसु पर भुरसु कर लेदला। ");
INSERT INTO bhi_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ने जे यहुदी माणसे नी-यहुदी माणसे काजे भात-भातीन बुली बुलतेला ने भगवानेन बड़ाय करतेला सामळी रवला। ती पतरस कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ईनु माणसे काजे हामुक जड़लु चु, चुखली-आत्‌मा जड़ गुयलु छे, ती हय ईनु काजे पाणी मां बपतीस्‌मा लेणे सी कुण रुक सके?” ");
INSERT INTO bhi_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ने पतरस जु हुकुम आप्‌यु की, “ईनुक बी ईसु मसीन नावे पाणीम बपतीस्‌मा आप देवु।” तत्‌यार चे बपतीस्‌मा लेण्‌या पतरस सी वीन्‌ती कर्‌या की “ईतराक दाहड़ा तु हामरेन्‌चां रव।” ने पतरस तींद्‌री वात मान लेदु। ");
INSERT INTO bhi_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ईसुन नेवताळा ने आखा यहुदीया जीला मां रहण्‌या ईसु पर भुरसु करन्‌या भाय-बेटा असा सामळ्‌या, की नी-यहुदी माणसे बी भगवानेन बुल मान लेदा। ");
INSERT INTO bhi_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","जत्‌यार पतरस यरुसलेम मां आयु, ती फतरी काटणेन बारामां माणसे पतरसेन वात काटीन वाते-वातेम लड़ाय पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ने कह्‌या, “तु नी-यहुदी माणसेन घर मां भरायु, ने तींद्‌रे भेळतु खाणु खादलु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ती पतरस, जो काय हयो चो आखो सुरु सी आकरी लग एकेक करीन समजाड़तु जाय्‌न कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","मे याफा सहर मां भगवान धड़े दुवा करने बाजी रवलु, ती मे चुखली जीव-आत्‌माम हय गुयु ने मारी चेत नी रयु ने मे जागतो-सपनो देख्‌यु, ने तत्‌यारुत सरग उघड़ी गुयो, ने चादरान तसों लांबो-चवड़ो काहनीक चीज काजे सरगे सी आथराय्‌न उतरीन मार भीणी आयो, ने तेरा च्‌यारु खुणा धरती पर मेकाय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","मे तीनी चीजेक धीयान सी देख्‌यु। धरतीम आखी भातीन च्‌यारपाया जनवार्‌या, जंगली जनवार्‌या, ने घीसाय्‌न चालन्‌या जनवार्‌या ने सरगेन चिरला हतला। ");
INSERT INTO bhi_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ने मेसेक एक बुली सामळाय की ए पतरस! उठ, ने ईनुक मारीन खा। ");
INSERT INTO bhi_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","बाकुन मे कह्‌यु, ए मालीक! मे ईनुक कदी मारीन नी खाम। काहाकी मे, मुयळ्‌ळी वीटेळ्‌ळी चीज आज लग नी खादु। ");
INSERT INTO bhi_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","तेबी ची बुली दीसरी कावा अळी सरगे सी मेसेक सामळायी, भगवान तीनी चीजेक चुखली कवलु छे, तीनी चीजेक तु वीटेळ्‌ळी घुण कवे। ");
INSERT INTO bhi_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","असो तीन कावा हयो; ने अळी चो चादरा साय चीज सरगे मां पछी हाकलाय गुयो। ");
INSERT INTO bhi_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ने अळी तीनु तीन अदमी काजे केसर्‌या सहरेम सी मारेन्‌चां मकल्‌यु, चे अदमी तीना घर मां हामु हतला, चां आय लाग्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","तत्‌यार आत्‌मा मेसेक हुकुम आप्‌यु की तु हींद्‌रे पुठ्‌ये बे फीकर्‌यु हय्‌न जां। ने जे छव भायस बी मारे पुठ्‌ये चाल पड़्‌या; ने हामु तींद्‌रे पुठ्‌ये केसर्‌या सहरेम तीना कुरनेलीयुसेन घर गुया। ");
INSERT INTO bhi_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ने चु हामुक देखाड़्‌यु की मेसेक सरग वाळु भगवानेन अघली वात बताड़ने वाळु मार घरमां उबु हय रवलु देखाव पड़्‌यु, चु मेसेक कह्‌यु, तु याफा सहर मां तारा माणसेक मकलीन सीमोन काजे बुलाय ले, जु पतरस कवाये। ");
INSERT INTO bhi_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","चु असी वात कवसे, तेरे साहरे तु ने तारो घराणो छुटकारु हात करसे। ");
INSERT INTO bhi_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ने जत्‌यार मे चां जाय्‌न तीनुक वात देखाड़ने बाजी गुयु, ती चुखली-आत्‌मा तींद्‌रे पर उतर्‌यु, जसु आपणे पर सुरु मां उतरलु। ");
INSERT INTO bhi_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तीनी टेमे मेसेक मालीकेन जु बुल हेर आयो, युहन्‌‌‌नु ते पाणी मां बपतीस्‌मा आपतेलु, बाकुन थुड़ाक दाहड़ा वीत जासे, ने अळी तुहुं काजे चुखली-आत्‌मान बपतीस्‌मा आपसे। ");
INSERT INTO bhi_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","जत्‌यार भगवान तीनु नी-यहुदी काजे बी हयुत वाटु आप्‌यु जु आपणुक मालीक ईसु मसी पर भुरसु कर्‌या करीन आप्‌यु; ती हामु कुण कहवायजे, जे भगवानेन काम काजे रुक्‌जे? ");
INSERT INTO bhi_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","जी वात सामळीन चे खुड़ काडण्‌या माणसे धीरा पड़ गुया, ने चे भगवानेन बड़ाय करने बाजी गुया, “ती ते भगवान नी-यहुदी काजे बी अमर जीवाय आपणे करीन तीनुक पाप भीणी सी मन फेरवीन भगवान भीणी वळनेन वाटु आप्‌लु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","स्‌तीफनुसेन बाहने माणसे यरुसलेम मां जबरान ईसुन माणसेक वेला पाड़नु सुरु कर देदा। ने ईसुन माणसे रावण्‌या-तीवण्‌या हय्‌न एराय गुया, फीरता-फीरता चे फीनीके ने कुपरुस ने अन्‌ताकीया, सहर मां पुग्‌या; बाकुन चे ईसुन माणसे ईसुन खुस-खबर यहुदी माणसेक अतरात सामळावतेला। ");
INSERT INTO bhi_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","बाकुन तीनु ईसुन चेला मायन थुड़ाक कुपरुस मां रवण्‌या, ने कुरेन मां रवण्‌या हतला, जे अन्‌ताकीया आवीन नी-यहुदी माणसे काजे बी मालीक ईसुन खुस-खबर सामळावणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ने मालीक ईसुन ताकत तींद्‌रे पुठ्‌ये हतली, ने बेसका माणसे मालीक ईसु पर भुरसु करीन मालीक ईसु भीणी वळ गुया। ");
INSERT INTO bhi_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","यरुसलेम मां रवण्‌या ईसुन मंडळी मां बी जी वात पुग गुय, ने चे बरनाबास काजे अन्‌ताकीया सहर मां तींद्‌रेन्‌चां मकली देदा। ");
INSERT INTO bhi_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ने बरनाबास चां जाय्‌न भगवानेन गीण-दया देखीन बेसकु खुस हयु; ने आखाक सीकाड़्‌यु, की तुहुं डील ने मन लागाड़ीन मालीक ईसु पर भुरसु करता रवु। ");
INSERT INTO bhi_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","काहाकी बरनाबास एक वारलु माणुस हतलु; ने चुखली-आत्‌मा तेरेमां उगेळ्‌तु भरायलु हतलु ने ईसु पर तेरु भुरसु बी पक्‌कु हतलु। ने असा बेसका माणसे मालीकेन चेला बणीन तींद्‌रे पुठ्‌ये भेसकाय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","तत्‌यार बरनाबास सावुल काजे हेरने करीन तरसुस सहर जात रयु। ");
INSERT INTO bhi_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ने चु तीना सावुल काजे हेरीन अन्‌ताकीया सहर मां ली आयु, ने चे एक साल लग ईसुन मंडळी काजे भेळा हवता रया, ने बेसका माणसेक सीकाड़ता रया, ने अन्‌ताकीया मां माणसे आखान पेहले ईसुन चेला काजे मसी कवणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","तीनु दाहड़ाम भगवानेन अघली वात बताड़ने वाळा माणसे यरुसलेम सी अन्‌ताकीया सहर मां आया। ");
INSERT INTO bhi_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","तींद्‌रेम अगबुस नावेन एक जणु उबु हय्‌न भगवानेन चुखली-आत्‌मान अगवाय मां कह्‌यु, आखी कळी मां काळ पड़ने वाळु छे। जु काळ राजान राज क्‌लोदीयुसेन टेमे पड़लु। ");
INSERT INTO bhi_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","तत्‌यार ईसुन चेला जु वीच्‌यार कर्‌या की एकेक जणु आपसा-आपसा रुप्‌या-टकान अनुसार यहुदीया जीलाम रवणेवाळा आपणा भाय-बेटान सेवा चाकरी वाटे ईतराक रुप्‌या-टका दी मकेलसु। ");
INSERT INTO bhi_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ने चे तसा वीच्‌यार्‌या तसात कर्‌या; ने चे पुडार्‌यान्‌चां, बरनाबास ने सावुल काजे रुप्‌या-टका दी मकल्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","तीनी टेमे हेरोदेस राजा मंडळीन थुड़ाक माणसे काजे जबरान वेला पाड़नु सुरु कर देदु। ");
INSERT INTO bhi_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","जु हेरोदेस राजु युहन्‌नान भायस याकुप काजे तलवार सी झाटकायन माराड़ नाख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ने जत्‌यार चु देख्‌यु की असो करने सी यहुदी माणसे खुस हया, ती चु पतरस काजे धरीन लावणे करीन सीपायड़ा काजे मकल्‌यु। चे दाहड़ा अखमीरेन रुटान तीहवार हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","चु पतरस काजे धरीन जेल मां बंद कर देदु, ने तेरी राखवाळी करने करीन च्‌यार-च्‌यार सीपायड़ा काजे च्‌यार पहरा बणावीन मेल देदु। हेरोदेस राजान वीच्‌यार हतलु की मे ईनु काजे फसह तीहवारेन दाहड़े माणसे अगळ लावीस। ");
INSERT INTO bhi_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","एरेन करीन चु जेल मां पतरसेन राखवाळी करने करीन पहरु दी रवला; बाकुन ईसुन मंडळीन माणसे अदुस पतरस वाटे भगवान सी असी दुवा करने बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ने हेरोदेस राजा पतरस काजे दीसरे दाहड़े माणसे अगळ लावणे हींडतेलु, तीना दाहड़ान पेहले रात पतरस दुय हातकड़्‌या मां बांदायलु, दुय सीपायड़ान ईचमां सुवणे बाजी रवलु, ने झपला अगळ बी पहरु देण्‌या सीपायड़ा पहरु दी रवला। ");
INSERT INTO bhi_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","एक कपरा मां उचकाणुन मालीकेन सरग वाळु भगवानेन अघली वात बताड़ने वाळु आवीन उबु हय गुयु। ने जेलेम वीजाळो हय गुयो; ने भगवानेन अघली वात बताड़ने वाळु पतरसेन कुख्‌ये टुचलीन तीनाक जागाड़्‌यु, ने कह्‌यु, “मामार उठ।” अतरा मां हातकड़्‌या आपसात छुटीन हीट पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","तत्‌यार सरगेन भगवानेन अघली वात बताड़ने वाळु हुकुम आपीन कह्‌यु, कमर बांद ले ने चीपल्‌या पेहेर ले। तत्‌यार तेरी वात सामळीन तसुत कर्‌यु। ने सरग वाळु भगवानेन अघली वात बताड़ने वाळु पतरस काजे अळी कह्‌यु, “पुथल्‌यो पेहेर ले ने मार पछळ आव।” ");
INSERT INTO bhi_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","पतरस जेलेम सी नीकळीन सरग वाळा भगवानेन अघली वात बताड़ने वाळु पछळ चाल पड़्‌यु। बाकुन जु सरगेन भगवानेन अघली वात बताड़ने वाळु कर रवलु चो तीनाक पल्‌ले नी पड़्‌यो, खरलो छे की झुट्‌लो। बाकुन चु ज समजी गुयु की मे सपनो देखणे बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ती चे पेहलु ने दीसरु पहरु छेकीन तीना लुहड़ान झपले लग आया, जो सहरे भीणी उघेड़तेलो। चु झपलु तींद्‌रे वाटे आपसुत उघड़ी गुयु, ने चे बाहर नीकळी गुया। ने चे गळी मायन आया अतरात ने सरग वाळु काहवाळ्‌यु उचकाणुन पतरस काजे चां रहणीदीन जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","जत्‌यार पतरस काजे समज आय, गुय चु कह्‌यु “हय मेसेक छाचलीन पल्‌ले पड़ गुयो की ज हयो च खरलो छे। मालीक आपसा सरग वाळा भगवानेन अघली वात बताड़ने वाळा काजे मारेन्‌चां मकलीन मेसेक हेरोदेस राजान कब्‌जाम जेलेम सी छुड़ाय लेदलु छे। ने यहुदी माणसेन आस पर पाणी फेरवी देदलु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","जत्‌यार पतरस काजे जी वात समज मां आय गुय, ती चु युहन्‌नान माय मरीयमेन घर जात रयु। ईना युहन्‌ना काजे मरकुस बी कवे। चां बेसका जणा भेळा हय्‌न भगवान धड़े दुवा करने बाजी रवला। ");
INSERT INTO bhi_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","पतरस बाहर झपला काजे ठुक्‌यु, ने कुण छे करीन तीनाक देखणे, रुदे नावेन एक पावरनी तीने झपले लग आवी। ");
INSERT INTO bhi_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ची पावरनी पतरसेन बुली उळखी लेदी, ने झपलु उगाड़ने रहणीदीन पछी दवड़ीन गुय ने चां भेळा हवला काजे कह्‌यी, पतरस झपले उबु हय रयु। ");
INSERT INTO bhi_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","चे तीनीक कह्‌या, “तु गांडी ते नी हय।” बाकुन ची पाक्‌कु भुरसु करीन कवतीत रय की मे जो कय रय, ची खरली वात छे। तत्‌यार चे कह्‌या, “चु पतरसेन राखवाळी करन्‌यु सरग वाळु काहवाळ्‌यु हसे।” ");
INSERT INTO bhi_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","अतरी वार लग पतरस झपलु ठुकतुत रयु। जत्‌यार चे झपलु उगाड़्‌या ने पतरस काजे देख्‌या, ती चे बेसका चकराय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ने पतरस हात पालवीन हुगा राखणेन ईसारु कर्‌यु, ने काहनी रीती सी मालीक मेसेक जेल सी बाहर नीकाळ लायु चो तीनुक कय देदु; ने अळी चु कह्‌यु “याकुप ने दीसरा भायस्‌यो काजे ईनी वातेन खबर कर देजु।” ने कयदीन चु तीना घर मां सी नीकळीन चां सी दीसरी जागे जात रयु। ");
INSERT INTO bhi_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","पतरस कां जात रयु करीन संदारे एगात सीपायड़ा कांदराय गुया; काहाकी तीनुक ज नी मालुम हतलो की तेरो काय हयो। ");
INSERT INTO bhi_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","जत्‌यार हेरोदेस राजु दीसरा सीपायड़ा काजे पतरसेक हेरने करीन आखे दुर मकली देदु, ने तेबी तीनुक पतरस नी जड़्‌यु ती चु पहरु देण्‌या काजे पुछ्‌यु, बाकुन चे काय जपाप नी आप्‌या तत्‌यार हेरोदेस राजु दीसरा सीपायड़ा काजे हुकुम आप्‌यु की तुहुं ईनु पेहरु देण्‌या सीपायड़ा काजे मार नाखु, ने हेरोदेस राजु यहुदीया जीलान यरुसलेम सहर छुड़ीन केसर्‌या सहर मां जात रयु। ");
INSERT INTO bhi_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हेरोदेस राजु सुर ने सेदा सहरेन माणसे पर कीचवाय रवलु; हेरेसी सुर ने सेदा सहरेम रवण्‌या माणसे एक मन्‌या हय्‌न मुजगी करीन आया, ने हेरोदेस राजान पावर्‌या बलास्‌तुस काजे मानाड़ीन तेरी अगवाय मां तेरे साहरे हेरोदेस राजा धड़े वीन्‌ती कर्‌या की तु हामरे पर रीस मां करे बाकुन सुकुन जीवे रवणे दे। काहाकी तीनु काजे हेरोदेस राजान देस सीत खाणेनन चीजे जड़तेला। ");
INSERT INTO bhi_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","एक दाहड़ु टाकले दाहड़े हेरोदेस राजु राजान पुथल्‌या पेहरीन ठट हय्‌न आपसी नीयावेन गादी पर बठ्‌यु, ने माणसेक सीकाड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","माणसे आयड़ीन कह्‌या, “जे माणसेन बुले नी हय, बाकुन भगवानेन बुल छे।” ");
INSERT INTO bhi_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","तीनीत टेमे मालीक भगवानेन एक सरग वाळु काहवाळ्‌यु हेरोदेस पर आय्‌न घाव कर्‌यु, ने तेरा डीलेम कीड़ा पड़्‌या ने मर गुयु, काहाकी चु भगवानेन सेक-सींगारेन बड़ाय नी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","भगवानेन बुल बड़तो ने आखीदुर पुग्‌तो गुयो। ");
INSERT INTO bhi_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","जत्‌यार बरनाबास ने सावुल यरुसलेम मां आपसो सेवा-चाकरीन काम पुरो कर लेदा, ती चे यरुसलेम सी मरकुस काजे लीन पछा अन्‌ताकीया सहर आवती रया। जु मरकुस युहन्‌‌‌नु कवायतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अन्‌ताकीया सहरेन मंडळी मां थुड़ाक, भगवानेन अघली वात बताड़ने वाळा माणसे, ने भगवानेन वात सीकाड़न्‌या हतला-जसा, बरनाबास, ने सीमोन जु काळु कहवायतेलु, ने कुरेन सहर मां रवण्‌यु लुकीयुस, ने गलील जीलाम राज करन्‌या हेरोदेस राजा पुसेन भाय मनाहेम ने सावुल। ");
INSERT INTO bhi_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","जत्‌यार चे काहनेस दाहड़े उपास करीन मालीक भगवानेन भक्‌ती करने बाजी रवला, तत्‌यार भगवानेन चुखली-आत्‌मा तीनुक कह्‌यु, “मे तीना सेवान-काम वाटे बरनाबास ने सावुल काजे बुलावलु छे, तीना सेवान काम वाटे मकलने करीन, बरनाबास ने सावुल काजे अलग कर लेवु।” ");
INSERT INTO bhi_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","जत्‌यार भगवानेन वात सीकाड़न्‌या ने भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या माणसे उपास ने दुवा करीन नवराय गुया ने अळी चे बरनाबास ने सावुल पर हात मेकीन तींद्‌रे वाटे दुवा कर्‌या तीनुक तीना सेवान-काम सुप देदा ने तीनुक वळायन मकली देदा। ");
INSERT INTO bhi_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","अळी चे बरनाबास ने सावुल चुखली-आत्‌मान अगवाय मां भगवानेन सेवान काम वाटे सीलुकीया गुया, ने चां सी मटला ढंड्‌या मां बसीन कुपरुस नावेन काळापाणी मां जाती रया। ");
INSERT INTO bhi_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ने सलमीस सहर पुगीन, चे यहुदी माणसेन भक्‌तीन घर मां भगवानेन खुस-खबर सामळाया। मरकुस कहवायण्‌यु युहन्‌‌‌नु बी तींद्‌रे पुठ्‌ये रय्‌न तींद्‌री सेवान काम करतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ने चे तीना काळापाणी मां आखी दुर फीरता-फीरता, पाफुस सहर मां पुग्‌या, चां तीनुक बार-ईसु नावेन एक यहुदी जातीन जादु देखाड़न्‌यु भेळु हयु। जु, मे भगवानेन अघली वात बताड़न्‌यु माणुस छे करीन ढंगड़ा करन्‌यु हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","चु जादु करने वाळु बेसकु अकलवाळु हतलु, ने चु सीरग्‌युस-पोलुस पुठ्‌ये-पुठ्‌ये रवतेलु। जु सीरग्‌युस-पोलुस, बरनाबास ने सावुल काजे बुलावीन भगवानेन बुल सामळने हींडतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","बाकुन जु बार-ईसु तेरो दीसरो नाव ईलीमास-मतलब जादु-देखाड़न्‌यु हतलु। जु बरनाबास ने सावुल भीणी जुर कर्‌यु। ने चु सहरेन हकदार्‌या सीरग्‌युसेन भुरसा काजे बीगाड़णेन कुसीत कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","बाकुन सावुल, जु पोलुस बी कवायतेलु। चुखली-आत्‌मान कब्‌जाम हय्‌न तीना ईलीमास भीणी एक हेट्‌यु देखीन कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","तु भुतड़ान पुर्‌यु छे, तारेम दीसराक धुकु देणेन वात ने दीसराक ठगणीन वात ठेसी-ठेसीन भरली छे। ने तु आखी भातीन वारुन वेरी छे। तु मालीकेन सुदी वाट काजे वाकी करने सी नी टळे काय? ");
INSERT INTO bhi_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","हय देख, मालीक तुसेक डंड आपणे बाजी रयु, तत्‌यारुत ईलीमास आंधळु हय्‌न थुड़ाक दाहड़ा लग दीसुन वीजाळो नी देखे। तत्‌यारुत तेरे पर आंदारो छावाय गुयो, ने चु लथेड़तु जाय्‌न कुय मारु हात धरीन ली जासे करीन जां चां सुलेकणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","जो हयो चो आखो देखीन सहरेन हकदार्‌यु, ईसु पर भुरसु कर लेदु; ने चु मालीक ईसुन बारामां सामळीन चकराय गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पोलुस ने तेरा साती मटला ढंड्‌या मां बसीन पाफुस सी पंफुलीया सी पीरगा सहर मां आया; ने चां युहन्‌‌‌नु तीनुक चां मेलदीन यरुसलेम पछु जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","पोलुस ने बरनाबास पीरगा सी अगा जाय्‌न पीसद्‌यान अन्‌ताकीया मां पुग्‌या; ने चे आरामेन दाहड़े यहुदी माणसेन भक्‌तीन घर मां जाय्‌न बस गुया। ");
INSERT INTO bhi_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","मुसान साहरे लिखलु सास्‌तुर ने भगवानेन अघली वात बताड़ने वाळा माणसेन किताप भणी भणीन अळी यहुदी माणसेन भक्‌तीन घरेन पुडारी, बरनाबासेन्‌चां ने पोलुसेन्‌चां जी वात कय मकल्‌या, “ए भायस्‌यो! कदी माणसेन सांती आपणे वाटे तुंद्‌रे धड़े काय बी वात हय ती कवु।” ");
INSERT INTO bhi_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","तत्‌यार पोलुस उबु हय गुयु, ने हात पालवीन असु कवणे बाजी गुयु: ए ईस्‌रायली माणसे ने भगवानेक बीहीन जीवणे वाळा नी-यहुदी माणसे सामळु! ");
INSERT INTO bhi_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","आपणु ईस्‌रायली माणसेन भगवान आपणा डाहा-बुड़ा काजे नेवाड़ लेदलु, ने जत्‌यार चे मीसर देस मां परदेसी बणीन रहतेला, ती तीनुक अगु बड़ावीन ने मटा बणायु, ने चु आपसा हातेन ताकत साहरे तीनुक चां सी नीकाळ लायु। ");
INSERT INTO bhi_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","चु चाळीस साल लग उजाड़्‌या बयड़ाम तींद्‌री राखवाळी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ने हीयुत भगवान कनान देस मां सात जाती काजे सार देदु, ने चो देस आपणा डाहा-डाहान हक मां कर देदु। ");
INSERT INTO bhi_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","हव असु करीन आपणा डाहा-डाहान डाहाला बास मीसरे देस मां पारका बणीन रय गुयला ती सी तींद्‌री अवल्‌यात साड़े चार सोव साल मां कनान देस मां अवल्‌यात। पछी आय गुय ने अळी जु भगवानेन अघली वात बताड़ने वाळु समुएल टेम लग नीयाव करन्‌या पुडारीक एकेक करीन उबु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","अळी आपणा डाहा-डाहा आपसा वाटे भगवान धड़े एक राजान मांग कर्‌या, ती भगवान तींद्‌रे धड़े बीन्‌यामीन कुळीम सी कीसन पुर्‌यु सावुल काजे राजा बणाय देदु, ने चु राजु चाळीस साल लग राज कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ने अळी भगवान सावुल काजे राज गादी पर सी छेटु करीन दावुद काजे तींद्‌रु राजा बणायु; ईना दावुदेन बारामां भगवान जी गवा देदु की “मेसेक एक माणुस मारा मनेन अनसारे जड़ गुयलु छे, जु यीसेन पुर्‌यु दावुद छे। चु दावुद मारी आखी मरजी पुरी करसे।” ");
INSERT INTO bhi_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ईना दावुदेन अवल्‌यात मां सी भगवान आपसा वायदान अनसारे ईस्‌रायेली माणसेन चां एक छुड़ावणे वाळा मसी काजे मकल्‌यु। तेरो नाव ईसु हतलो। ");
INSERT INTO bhi_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ईसुन आवणेन पेहले, युहन्‌‌‌नु आखा ईस्‌रायेली माणसे काजे, पापे भीणी सी मन फेरवीन भगवान भीणी वळनेन बपतीस्‌मान परचार करलु। ");
INSERT INTO bhi_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ने युहन्‌‌‌नु भगवानेन काम पुरो करनेत वाळु हतलु, ती चु कवलु, तुहुं मेसेक जु छुड़ावणे वाळु मसी समजी रया हसे, चु आवणेवाळु हतलु, बाकुन मे, चु नी हय। बाकुन चु ते हय आवणेवाळु छे। ने मे ते, तेरा चीपल्‌यान बंद छुड़ने लायक बी नी हय। ");
INSERT INTO bhi_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ए मारा ईस्‌रायेली भायस्‌यो, अब्‌राहमेन अवल्‌यात! आखा भगवानेन भक्‌ती करने वाळा नी-यहुदी माणसे छुटकारान खुस-खबर आपणु आखा काजे आपली छे। ");
INSERT INTO bhi_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","यरुसलेम मां रवणेवाळा ने चां नीयाव करन्‌या मुखी ईसु काजे नी उळख्‌या, ने चे भगवानेन अघली वात बताड़ने वाळा माणसेन किताप मां लिखली वात काजे नी समज्‌या; जे आरामेन दाहड़ा डीट भणतेला। जाणी बुजीन तीनाक गुनाळु ठेहरावीन लिखली वातेक पुरी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","भले तेरेमां डंड आपे असु गुनु, तीनुक देखाव नी पड़्‌यु तेबी चे, पीलातुस सी लीलघाय्‌न कह्‌या की हीनाक माराड़ नाख। ");
INSERT INTO bhi_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ने ईसुन बारामां जो काय लिखलो हतलो, चो आखो पुरो कर लेदा, ती चे ईसुन धड़ कुरुस पर सी उतार लेदा, ने एक मसाण मां वगे कर देदा। ");
INSERT INTO bhi_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","बाकुन भगवान तीना ईसुक मर्‌या-सर्‌याम सी पछु जीवतु करीन बठु कर देदु। ");
INSERT INTO bhi_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ने चु बेसका दाहड़ा लग तीनु माणसे काजे देखाव पड़तु रयु, जे तेरे पुठ्‌ये गलील जीलाम सी यरुसलेम मां आवला। हय चेत माणसे, दीसरा माणसे अगळ ईसुन गवा छे। ");
INSERT INTO bhi_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ने हामु तुहुं काजे तीना वायदान खुस-खबर सामळावजे, जु वायदु भगवान आपणा डाहा-बुड़ा साते करलु। ");
INSERT INTO bhi_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","भगवान ईसु मसी काजे मर्‌या-सर्‌याम सी जीवतु करीन चु वायदु तींद्‌री अवल्‌यात वाटे मतलब आपणु आखा वाटे पुरु करलु छे, जसों भजनेन किताप दुय मां बी लिखलो छे, तु मारु पुर्‌यु छे; ने मे आज सी तारु बास बण गुयलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","भगवान आपणे वाटे, ईसुक मर्‌या-सर्‌याम सी पछु जीवाड़नेन बारामां कह्‌यु, चु ईसु कदी नी सड़े। काहाकी भगवान तीनाक कवतेलु, मे तुसेक ची चुखली ने जलेमकी संयबरकत आपीस, जी संयबरकत मे दावुद काजे आपणेन बुली करलु हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","हेरेसी चु एक अळी दीसरा भजन मां कवलु; तु तारा चुखला भगत काजे सड़ने नी देय। ");
INSERT INTO bhi_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","पछेन दावुद तेरे टेम मां भगवानेन मरजी अनसारे तेरो सेवान काम पुरो करीन मर गुयु ने तीनाक तेरा डाहा-डाहा साते गाड़ देदा ने हेरो डील मसाण मां सड़ गुयो। ");
INSERT INTO bhi_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","बाकुन भगवान तीनाक मर्‌या-सर्‌याम सी जीवाड़ीन पछु बठु कर्‌यु, तेरो डील नी सड़्‌यो। ");
INSERT INTO bhi_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","ती तुहुं आखा ईस्‌राईली भायस्‌यो तुहुं काजे जाण लेणु चाहजे की ईसुन साहरे पापेन माफीन खबर तुहुंक आप देदला छे ने हेरेत साहरे जु कुय आखा जणा जे भुरसु करन्‌या छे हीनु पाप सी छुटकारु जड़ सक्‌से। तेरे सी तुहुंक मुसान लिखलु कायदु छुटकारु नी आपड़ सके। ");
INSERT INTO bhi_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","हेरेसी चेतीन रवु, कांखुर मायन भगवानेन अघली वात बताड़ने वाळा माणसेन किताप मां पुरी नी हय जाय: ");
INSERT INTO bhi_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ए वात काड़ण्‌या, चकराय्‌न छेटे हय जावु! काहाकी मे तुंद्‌रा जमाना मां एक वारु काम करने वाळु छे, एक असो काम, कदी तुंद्‌रे मायन कुय बी एरे बारामां वात बी करसे, तेबी कुय काजे ईनी वात पर भुरसु नी आवे! ");
INSERT INTO bhi_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","जत्‌यार पोलुस ने बरनाबास यहुदी माणसेन भक्‌तीन घर मां सी नीकळीन जाणे बाजी रवला ती माणसे तींद्‌रे धड़े वीन्‌ती कर्‌या, तुहुं आवते आरामेन दाहड़े ईनी वातेन बारामां कवजु। ");
INSERT INTO bhi_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ने जत्‌यार तींद्‌री भक्‌तीन बसक हय गुय, ती यहुदी माणसे ने नी-यहुदी धरम मान्‌या नवला चेला, पोलुस ने बरनाबासेन वात मान्‌ने बाजी गुया। पोलुस ने बरनाबास तीनुक समजाड़ीन कह्‌या, भगवानेन गीण-दया मां बन्‌ला रवु। ");
INSERT INTO bhi_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","आवते आरामेन दाहड़े सहरेन आखा माणसे मालीक भगवानेन बुल सामळने करीन भेळा हय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","बाकुन बेसका माणसे आवतेला देखीन यहुदी माणसे पोलुसेन नाव-बद्‌दी करने बाजी गुया, ने वीरुद करीन वात काटणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","पोलुस ने बरनाबास बीहे बीगुर कह्‌या, जरुड़ी हतलो की पेहले तुहुं काजे भगवानेन बुल सामळावणु हतलो, बाकुन तुहुं भगवानेन बुल नीकारु करीन सामळने नी हींडतेला, ने तुहुं आपसा काजे अमरकायान जलमेन जीवाय्‌न लायेक नी समज्‌ता; हेरेसी हामु हय नी-यहुदी माणसेन चां भगवानेन बुल ली जाजे। ");
INSERT INTO bhi_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","काहाकी मालीक भगवान हामुक ज हुकुम आप्‌लु छे, मे तुहुंक नी-यहुदी माणसे वाटे वीजाळो बणावलु छे, एरेन करीन की तारे साहरे धरतीन खुणे-कुपरे लग माणसे छुटकारु हात करसे। ");
INSERT INTO bhi_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ने नी-यहुदी माणसे पोलुसेन ने बरनाबासेन वात सामळीन बेसका खुस हया ने चे मालीक भगवानेन बुलेन ईज्‌जत कर्‌या। जतरा माणसे अमरकायान जीवाय वाटे नेवाड़ला हतला, चे ईसु पर भुरसु कर लेदा। ");
INSERT INTO bhi_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ने तत्‌यार आखा सहर मां मालीकेन बुल फेल गुयो। ");
INSERT INTO bhi_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","बाकुन यहुदी माणसे, मट्‌ली कुळीन भक्‌त माणसेन ने सहरेन बायरान जुर चड़ाय देदा, ने पोलुस ने बरनाबासेन वीरुद करावणे हुड़दीन आय लाग्‌या, ने तीनुक आपसान सहर मां सी नीकाळ देदा। ");
INSERT INTO bhi_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ने अळी पोलुस ने बरनाबास तींद्‌रे वीरुद मां आपसा पायेन धुळु झाटकीन ईकुनीयुम सहरे मां जात रया। ");
INSERT INTO bhi_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","अन्‌तकीया सहर वाळा भुरसु करने वाळा चेला बेसका खुस हया ने पुरा-पुरा चुखला जीव-आत्‌मा सी भराय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","असी वीतली वात ईकुनीयुम सहरेन यहुदी माणसेन भक्‌तीन घर मां पोलुस ने बरनाबास भेळात गुया, ने चे तीनुक समज आवी असो ईसुन बारामां देखाड़्‌या। ने तींद्‌री वात सामळीन यहुदी माणसे मायन ने युनानी माणसे मायन बेसका जणा ईसु पर भुरसु कर लेदा। ");
INSERT INTO bhi_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","बाकुन ईसु पर भुरसु नी करन्‌या यहुदी माणसे, नी-यहुदी माणसेक वीखराड़ी देदा, ने भायस्‌योन वीरुद मां तींद्‌रा जीवेम काट करनेन वीच्‌यार नाख देदा। ");
INSERT INTO bhi_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","पोलुस ने बरनाबास बेसका दाहड़ा चां रया, ने मालीक पर भुरसु करीन बीहे बीगुर ईसु भगवानेन बारामां वात करता रया, ने मालीक ईसु तींद्‌रे साहरे वारु काम ने सहलाणी देखाड़ीन आपसी गीण-दयान बुलेन गवा देदलु। ");
INSERT INTO bhi_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","बाकुन तीना सहरेन माणसे मां लड़ाय हय गुय ने अलग-अलग हय गुया; ने असु करीन थुड़ाक यहुदी माणसे भीणी ने थुड़ाक ईसुन नेवताळा भीणी जाणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","बाकुन जत्‌यार यहुदी माणसे ने नी-यहुदी माणसे आपसा मुखी साते भेसकायन पोलुस ने बरनाबास साते खुटु वेहवार करने करीन तीनुक दगड़ाटणे करीन वीच्‌यार कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ती पोलुस ने बरनाबास तींद्‌री मुजगी जाण गुया, ने चे लुकावन्‌या जीलान लुसत्‌रा सहर मां, ने दीरबे सहर मां ढास पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ने चे चां जाय्‌न बी खुस-खबर सामळावणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुसत्‌रा मां एक माणुस बस रवलु, तेरा पाय लुल्‌ला हतला चु पयदा हवलु ती सीत लंगड़ु हतलु, ने चु आज लग चाल्‌यु नी। ");
INSERT INTO bhi_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","चु पोलुस काजे वात करतेलु सामळी रवलु, ने चु पोलुस भीणी एक हेट्‌यु देख रवलु, ने तीना लंगड़ा मां वारु हवणेन भुरसु हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","अळी पोलुस जुर सी आयड़ीन कह्‌यु, “आपसा पायेन भुरसे उबु हय जां!” ने चु पोलुसेन वात सामळीन उबु हय गुयु ने चालने-फीरने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","पोलुसेन साहरे हवला वारु कामेक देखीन माणसे लुकावन्‌या बुली मां जुर सी आयड़ीन कह्‌या, “माणसेन रुप लीन देवता हामरे ईचमां उतरीन आवला छे।” ");
INSERT INTO bhi_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ने चे बरनाबास काजे गुयुस देवता ने पोलुस काजे हीरमेस देवता कवणे बाजी गुया, काहाकी पोलुस वात करने मां पुडारी हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ने गुयुस देवतान मंदीर सहरेन झपला अगळ हतलु। ने तीना मंदीर वाळु पुजारी बेल ने फुलेन माळा लीन चां आय लाग्‌यु। चु माणसे भेळु पोलुस ने बरनाबास वाटे बेल मारीन बादा चड़ावणे हींडतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","बाकुन जत्‌यार नेवताळा बरनाबास ने पोलुस, चे ज सामळ्‌या, ती चे हींद्‌रा पुथल्‌या फाड़ देदा ने जुर सी आयड़ीन ज कवता जाय्‌न माणसेन टुळा मां भराय गुया, ");
INSERT INTO bhi_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ए माणसे! हामु बी ते असात माणसे, छे जसा तुहुं छे जां हामु तुहुं काजे खुस-खबर सामळावणे आवला छे, काहाकी तुहुं हीनी फालतु वात काजे पछा फीरीन हीना जीवतेला भगवान भीणी आवती रहु जु सरग, धरती, समुदर ने तींद्‌रेम ज काय बी छे तीनाक बणायु। ");
INSERT INTO bhi_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","वीत्‌या जमाना मां भगवान आखी जातीन माणसे काजे आपणे-आपणे दथा-तथा देवतान पुजा-पाट करीन जीवणे देदु, काहाकी चे तीनाक नी उळख्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","बाकुन तेरा भला कामेन, सरगे सी पाणी पाड़तु रयु, ने टेम-टेम पर मेर पाकाड़तु रयु खाणेन सादन आपतु रयु, ने तींद्‌रा मनेक खुस करतु रयु।” ");
INSERT INTO bhi_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","असो कयदीन पोलुस कायस करीन तीनु माणसेक तुहुं बेल काजे मारीन बादा चड़ावीन मारी पुजा-पाट मां करु करीन रुक्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","बाकुन ईतराक यहुदी माणसे अन्‌ताकीया सहरेम सी ने ईकुनीयुम सी आवीन माणसे काजे आपसा सुदा कर लेदा ने पोलुस काजे दगड़ाट्‌या, ने मर गुयु समजीन तीनाक घीसीन सहर सी बाहर ली गुया; ने चांहान नाखीन जात रया। ");
INSERT INTO bhi_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","बाकुन जत्‌यार चेला पोलुसेन चारेमेर आवीन भेळा हय गुया, ती चु उठीन उबु हय गुयु, ती चु उठीन सहरेम गुयु ने दीसरे दाहड़े बरनाबास पुठ्‌ये दीरबे सहरेम जात रयु। ");
INSERT INTO bhi_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","पोलुस ने बरनाबास दीरबे सहरेन माणसे काजे खुस-खबर सामळाया, ने बेसका चेला बणाया, ने लुसत्‌रा ने ईकुनीयुम ने अन्‌ताकीया पछा जात रया। ");
INSERT INTO bhi_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ने चे, चेला काजे हिम्‌मत देवड़ावता जाय्‌न तीनुक भुरसा मां काठा रवणे करीन जी वात सीकाड़ता रया, “आपणु काजे बेसका वेला करीन भगवानेन राजेम भरायणु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ने चे मंडळीन पुडारी बणावणे करीन माणसेक नेवाड़्‌या ने तीनुक पुडारी‌ ठेराया, ने उपास भेळा भगवान धड़े वीन्‌ती करीन, तीनुक मालीकेन हातेम आप देदा; तीना मालीक ईसु पर चे भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","तत्‌यार पोलुस ने बरनाबास पीसद्‌या जीलाक वेणकीन, दखणाव पंफुलीया जीला मां पुग्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ने पीरगा सहरेम भगवानेन खुस-खबर सामळावीन अताल्‌या सहरेम आया। ");
INSERT INTO bhi_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","अळी चां सी चे भगवानेन गीण-दयान अनसारे सुपलो काम पुरो करीन मटला ढंड्‌याम बसीन अन्‌ताकीया सहरेम चाहात रया, जां सी चे काम सुरु करला। ");
INSERT INTO bhi_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","जत्‌यार चे अन्‌ताकीया मां पुगीन, चे मंडळीन भुरसु करन्‌या माणसे काजे भेळा कर्‌या, ने ज काय हयो तत्‌यार भगवान तींद्‌रे पुठ्‌ये हतलु ने कसु नी-यहुदी वाळा माणसे वाटे बारनो उघाड़ देदु ");
INSERT INTO bhi_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","चे बेसका दाहड़ा लग चां आखा चेला पुठ्‌ये रया। ");
INSERT INTO bhi_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","थुड़ाक ईसु पर भुरसु करन्‌या यहुदी जातीन माणसे यहुदीया जीला सी अन्‌ताकीया आया, ने भायस्‌यो काजे ज सीकाड़ने बाजी गुया की “कदी तुहुं मुसान लिखला कायदान अनसारे फतरी नी काटाड़ु, ती तुहुंक पापेम सी छुटकारु नी जड़े।” ");
INSERT INTO bhi_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","पोलुस ने बरनाबास तींद्‌री वात सी राजी नी हतला, हींद्‌रे मां लड़ाय हय गुय, तत्‌यार पोलुस ने बरनाबास हींद्‌रा थुड़ाक दुस्‌तीदार काजे ईनी परेसानी मां सी छेटे करने वाटे नेवताळा ने मुख्‌या धड़े यरुसलेम मां मकलनेन वीच्‌यार कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","तेरेसी मंडळीन साहरे तीना काजे ईतराक अगास मेकणे गुया; ने फीनीके ने सामर्‌या मायन गुया ने चां वाळा आखा ईसु पर भुरसु करन्‌या ज कवता गुया की नी-यहुदी माणसे बी खुस-खबर पर भुरसु करीन भगवान भीणी हींद्‌रो मन फेरवी लेदा। ने आखा भाय जी वात सामळीन बेसका खुस हय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ने जत्‌यार चे यरुसलेम पुग्‌या, ती ईसुन, ने ईसुन मंडळी ने नेवताळा ने पुडारी तीनुक खुस हय्‌न भेळा हया, ने जे गुयला चे तीनुक कह्‌या की भगवान तींद्‌रे पुठ्‌ये रय्‌न कसा-कसा वारु काम कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","बाकुन फरीसी माणसेन टुळा मां जे ईसु पर भुरसु करला, तींद्‌रे मायन ईतराक उबा हय्‌न कह्‌या, “हीनु नी-यहुदी काजे फतरी काटणेन ने मुसान कायदा पाळनेन हुकुम आपणु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","तत्‌यार ईसुन नेवताळा ने पुडारी फतरी काटणेन ने मुसान कायदा पाळनेन वात पर वीच्‌यार करने करीन भेळा हया। ");
INSERT INTO bhi_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","जत्‌यार बेसकी वार लग ईनी वात पर माथा-पच्‌ची हय गुय ने अळी पतरस उबु हय्‌न कह्‌यु, “ए भाय बेटा! तुहुं काजे मालुम छे की नी-यहुदी माणसे मां ईसुन खुस-खबर सामळावणे ने तीनुक ईसुन भुरसा मां लावणे करीन बेसका दाहड़ा पेहले भगवान मेसे काजे तुंद्‌रे मां सी नेवाड़ लेदु। ");
INSERT INTO bhi_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ने मन काजे पारखणे वाळु भगवान तीनु काजे बी चुखली-आत्‌मा आप्‌यु, जसु आपणु काजे चुखली-आत्‌मा आपलु। ने ईनी वातेन गवा देदु की भगवान हीनुक बी पापेम सी छुटकारु हात करनेन भुरसु आपलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ने ईसु पर भुरसान साहरे तींद्‌रो मन चुखो कर देदु ने हय तींद्‌रेम ने आपणेम काय बी छीट नी रय। ");
INSERT INTO bhi_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ती हय तुहुं भगवान काजे काहा पारखी रया? ने चेलान बुचाटा मां मुसान कायदान जुड़ो मेलीन काहा बुझु बणाय रया, तीना जुड़ा काजे आपणा डाहा-डाहा लग नी हाकल्‌या? ");
INSERT INTO bhi_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","हव, हामु काजे पाक्‌कु भुरसु छे की तीने रीते चे मालीक ईसुन गीण-दयान साहरे पापेम सी छुटकारु हात करसे; तीनेत रीते आपणु बी मालीक ईसुन गीण-दयान साहरे पापेम सी छुटकारु हात करसु।” ");
INSERT INTO bhi_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","चे आखा हुगा हय्‌न बरनाबास ने पोलुसेन वात सामळने बाजी रवला। ने चे तीनु सहलाणीन ने वारु कामेन बारामां वारु कह्‌णे बाजी रवला, जे सहलाणी वारु काम भगवान तींद्‌रे साहरे नी-यहुदी अगळ देखाड़लु हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","सावुल ने पोलुस कय देदा ने अळी याकुप कवणे बाजी गुयु, ए भायस्‌यो, हय मारी वात सामळु। ");
INSERT INTO bhi_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","सीमोन हामुक देखाड़्‌यु की भगवान नी-यहुदी माणसे पर गीण करीन आपसा नाव वाटे नेवाड़ लेदु। ");
INSERT INTO bhi_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ने जी वात भगवानेन अघली वात बताड़ने वाळा माणसेन वात सी मेळ बी खाय, जसों भगवानेन अघली वात बताड़ने वाळान किताप मां बी लिखलो छे, ");
INSERT INTO bhi_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","हेरे पछेन मे आवीन, दावुदेन उदेरला तम्‌बु काजे पछु बणावीस, ने तेरा जुन्‌ला सुनसान घरेक, अळी पछु काठो बणायन उबा करीस। ");
INSERT INTO bhi_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","तेरे सी आखा बचला नी-यहुदी माणसे मालीक काजे हेरे तसा, जे मारा नावेन कहवाये। ");
INSERT INTO bhi_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","जी वात चु मालीक कह्‌वे, जु कळी घड़ायी ती सीत पीड़ीडीट काजे खबर करतु आय रयु। ");
INSERT INTO bhi_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","हेरेसी मारु जु वीच्‌यार छे, की जे नी-यहुदी माणसे मां ईसु पर भुरसु करीन भगवान भीणी वळ गुयला तीनु काजे जाणी बुजीन वेला नी करनु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","बाकुन आपणु तींद्‌रेन्‌चां जी चिट्‌ठी लिखीन दी मकेल्‌ला की “तुहुं मुरती पर चड़ावलो खाणो घुण खावु। ने गळु दड़पीन मारला काहना बी जनवार्‌यान सीकार घुण खावु, ने काहना बी जनवार्‌यान खुन घुण पीयु। ने छीनाळो घुण करु। ");
INSERT INTO bhi_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","काहाकी पुराणा टेम सी मुसान नीयम कायदान परचार करन्‌या आखा सहर मां जड़े। ने चे आरामेन दाहड़े तींद्‌रा आखा यहुदी माणसेन भक्‌तीन घर मां मुसान कायदान किताप भणीन सामळावे।” ");
INSERT INTO bhi_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","जी वात सामळीन आखी मंडळीन माणसेक, ईसुन नेवताळाक ने पुडारी काजे वारु लाग्‌यो, ने चे वीच्‌यार कर्‌या की आपणे मां सी थुड़ाक माणसे नेवाड़जे। ने चे यहुदा काजे नेवाड़्‌या, जु बरसब्‌बास कवाये। ने सीलास काजे नेवाड़्‌या, जु तीनु भायस्‌यो मां मुख्‌यु हतलु; ने तीनुक पोलुस ने बरनाबास पुठ्‌ये अन्‌ताकीया सहर मां मकली देदा। ");
INSERT INTO bhi_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ने तींद्‌रे हाते जी चिट्‌ठी मकल्‌या, तेरेमां लिखलो हतलो: “ए अन्‌ताकीया मां, ने सीरीया मां, ने कीलक्‌या मां रवण्‌या नी-यहुदी भायस्‌यो, तुहुं काजे ईसुन नेवताळा भीणी सी ने पुडारी भीणी सी आवीस ने आवजी कवजे! ");
INSERT INTO bhi_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","हामु सामेळला छे की हामरेन्‌चां सी थुड़ाक माणसे तुंद्‌रेन्‌चां आवीन दत-तथी वात कय्‌न भटकाड़ देदला छे; ने तुंद्‌रा जीवक घाबराड़ देदला छे। बाकुन हामु तीनु काजे असली वात करनेन हुकुम नी आप्‌या ");
INSERT INTO bhi_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","हेरे सी हामु आखान-आखा एक मन्‌या हय्‌न वीच्‌यार करला छे की हामु हामरेम सी तीनु माणसे काजे नेवाड़ला छे, तीनु माणसे काजे हामरा लाटेक्‌ला बरनाबास ने पोलुस भेळा तुंद्‌रेन्‌चां मकलजे। ");
INSERT INTO bhi_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","जे चेत माणसे छे, जे मालीक ईसु मसीन नावे तींद्‌रु जीव आपणे लग तीयार हय गुयला। ");
INSERT INTO bhi_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ने हामु हींद्‌रे पुठ्‌ये यहुदा ने सीलास काजे मकेल्‌ला छे, जे तुहुं काजे आपणा मुंहडा सी जी आखी वात कय देसे। ");
INSERT INTO bhi_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","चुखली-आत्‌मा काजे ने हामु काजे मालुम पड़्‌यो की ईनी कामकी वातेक छुड़ीन तुंद्‌रे पर काहनु अळी भार नी मेलनु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","तुहुं मुरती पर चड़ावलो खाणो घुण खावु। ने गळु दड़पीन मारला काहना बी जनवार्‌यान सीकार घुण खावु, ने काहना बी जनवार्‌या घुण खावु। ने छीनाळो घुण करु। असु करीन तुहुं ईनी आखी वात सी छेटे रवजु ती तुंद्‌रो भलो हवसे। वारु रवजु।” ");
INSERT INTO bhi_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","असा करीन चे तीनुक मकली देदा ने चिट्‌ठी लीन अन्‌ताकीया सहर मां गुया, ने चां जाय्‌न चे आखा भुरसु करन्‌या माणसे काजे भेळा करीन ची चिट्‌ठी तीनुक आप देदा। ");
INSERT INTO bhi_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ने चे तीनी चिट्‌ठी मां लिखली वात भणीन बेसका खुस हय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहुदा ने सीलास जे भगवानेन अघली वात बताड़ने वाळा माणसे हतला, चे बी बेसकी वात कय्‌न तीनु भायस्‌यो काजे सांती आप्‌या। ने तींद्‌रा भुरसाक काठा कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ने चे थुड़ाक दाहड़ा चां रया, ने अळी चे तीनु भायस काजे आवसु ने आवजु कय्‌न, जे तीनुक मकेल्‌ला चां पछा जाती रया। ");
INSERT INTO bhi_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","बाकुन सीलास काजे चांहान रहणु वारु लाग्‌यो, ");
INSERT INTO bhi_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ने पोलुस ने बरनाबास अन्‌ताकीया मां ईतराक दाहड़ा रया, ने बेसका दीसरा माणसे पुठ्‌ये रय्‌न चे माणसे काजे सीकाड़ता जाय्‌न मालीक ईसुन खुस-खबर सामळाया। ");
INSERT INTO bhi_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ईतराक दाहड़ा हय गुया ने अळतेन पोलुस बरनाबास काजे कह्‌यु “चाल, तीना-तीना सहर मां आपणु खुस-खबर सामळावला, तीना-तीना सहर मां जाय्‌न मालीक पर भुरसु करन्‌या भायस काजे देखता की चे काय करने बाजी रया।” ");
INSERT INTO bhi_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","तत्‌यार बरनाबासेन हेर जी हतली, की आपणु युहन्‌ना काजे बी पुठ्‌ये ली जाता। जु मरकुस बी कवायतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","बाकुन पोलुस तीनाक पुठ्‌ये ली जाणु ताले नी समज्‌यु, काहाकी चु पेहले पंफुलीया मां संगात छुड़ देदलु ने मालीक भगवानेन काम मां सात नी देदु। ");
INSERT INTO bhi_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ने तींद्‌रे मां माथा-पच्‌ची हय गुय: ने बरनाबास, मरकुस काजे लीन मटला ढंड्‌याम बठीन कुपरुस सहर जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","बाकुन पोलुस, सीलास काजे नेवाड़्‌यु, ने भायस तीना वाटे भगवान धड़े गीण-दया मांगीन तीनाक मालीकेन हातेम सुप देदा। ");
INSERT INTO bhi_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ने चु फीरतु-फीरतु कीलक्‌या जीलाम ने सीरीया देसेन ईसुन मंडळी मां जाय्‌न तीनुक ईसुन भुरसा मां काठा करतु गुयु ने अघु-अघु जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","अळतेन पोलुस दीरबे ने लुसत्‌रा मां बी गुयु चां तीमुथीयुस नावेन एक चेलु हतलु जु ईसु पर भुरसु करनी एक यहुदी जातीन बायरीन पुर्‌यु हतलु बाकुन तेरु बास युनानी हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","चु तीमुथीयुस लुसत्‌रा ने ईकुनीयुम वाळा भाय-बंद मां बी वारलु बुल-चाल हतली। ");
INSERT INTO bhi_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पोलुसेन मरजी हतली की तीमुथीयुस हेरे साते जाय; ने जे यहुदी माणसे हींद्‌रे वजे सी हयु तीमुथीयुस फतरी काट्‌यु काहाकी चे आखा जाणतेला की तेरु बास युनानी हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ने चे सहरे-सहरे मां गुया ती तीनुक कायदा काजे पाळने करीन कवता गुया। चे कायदा यरुसलेम वाळा ईसुन नेवताळा ने पुडारी देखाड़ला। ");
INSERT INTO bhi_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","हेरेसी ईसुन मंडळी भुरसा मां काठी हवती गुया ने गिन्‌ती मां दाहड़ीन अदु हवता गुया। ");
INSERT INTO bhi_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","चे पोलुस ने तेरु साती फुर्‌गीया ने गलातीया परदेस मां सी हय्‌न गुया काहाकी चुखली-आत्‌मा हीनु आसीया मां बुल सामळावणे नी कय देदु। ");
INSERT INTO bhi_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","अळतेन चे मुस्‌या काकड़ पर पुगीन बीतुनीयाम ईलाका जाणे कर्‌या बाकुन ईसुन आत्‌मा तीनु काजे बीतुनीया जाणे नी देदी। ");
INSERT INTO bhi_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","तेरेसी चे मुस्‌या नीकळीन तरोआस मां आया। ");
INSERT INTO bhi_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ने चां पोलुस राते एक जागतो सपनो देख्‌यु की एक मकीदुनीया वाळु माणुस उबु हय र्‌यु, “ने पोलुस काजे लीलघाय्‌न ज कय र्‌यु की समुदर एणकीन मकीदुनीया जीला मां आवीन हामरी मदत कर।” ");
INSERT INTO bhi_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","पोलुस ज जागतो सपनो देख लेदु ने अळतेन हामु मकीदुनीया मां ज समजीन जाणे हींडतेला की भगवान हामु काजे खुस-खबर सामळावणे करीन मकेलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","तरोआस सी हामु मटला ढंड्‌या मां बठीन सुदा सुमात्‌रावे आया चांहा सी दीसरे दाहड़े नीयापुलीस मां आया ");
INSERT INTO bhi_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ने हामु नीयापुलीस सहर सी, चालीन फीलीपी सहरेम पुग्‌या, जो मकीदुनीया जीलान खास सहर छे, चां रोमी राजवाड़ान खास माणसे रवे, ने हामु ईतराक दाहड़ा चां रया। ");
INSERT INTO bhi_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","यहुदी माणसेन आरामेन दाहड़े हामु ज समजीन सहरेम बारनो एणकीन सहर सी बाहरा नदी धड़े आया की चांहा यहुदी माणसे वाटे काहनो दुवा करनेन घर हसे ने चां पुगीन हामु चां भेळा हय रवला ईतराक बायरा धड़े वात करने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","तीनु बायरा भेळी लुदीया नावेन एक थुवातीरा सहरेन एक बायर हतली ची जामण्‌या पुथल्‌या वेचणी हतली ने भगवानेन भक्‌ती करनी हतली पोलुसेन वात मन लागाड़ीन सामळने बाजी रवली ने मालीक ईसु तेरो मन उघाड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ने ची ईसु पर भुरसु करीन आपसा घर बार्‌या भेळी पाणी मां बपतीस्‌मा लेदी ने हामु काजे लीलघाय्‌न कय की कदी तुहुं मेसे काजे मालीक भगवानेन भक्‌ती करन्‌या समजी र्‌या हय ती मारे घर चालु ने मारे घर रवजु ने ची हामु काजे मानाड़ीन ली गुय। ");
INSERT INTO bhi_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","जत्‌यार हामु एक दाहड़े दुवा करने घर मां जाणे बाजी रवला ती हामु काजे एक जुवान गुलाम पावरनी भेळी हयी तीनी मां हवणे वाळी वात कहण्‌यु भुतड़ु भराय रवलु ने ची तीना भुतड़ान साहरे माणसे काजे हवणे वाळी वात देखाड़ तेली ने तेरा मालक्‌या वाटे बेसका पयस्‌या कमाय लेतली। ");
INSERT INTO bhi_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ची पोलुस ने हामरे पछळ-पछळ आवीन आयड़ती जाय्‌न कह्‌वी जे माणसे आखा मां रवण्‌या भगवानेन चाकर्‌या छे ने तुहुं काजे छुटकारान खबर सामळावे। ");
INSERT INTO bhi_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ची बेसका दाहड़ा लग असीत करती रवी बाकुन पोलुस दुखी हय्‌न पछु फीरीन तीना भुतड़ा काजे कह्‌यु मे तुसेक ईसु मसीन नाव सी हुकुम आपो की हेरे मां सी नीकळी जां ने ची तीने टेमे नीकळी गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","तत्‌यार तेरा मालक्‌या देख्‌या की हामरी कमायन आस जात रय ती चे पोलुस ने सीलास काजे धरीन हाटेन चवराया पर मुख्‌यान चां घीसड़ीन ली गुया। ");
INSERT INTO bhi_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","अळी पोलुस ने सीलास काजे नीयाव करन्‌या मुख्‌यान चां लीन गुया ने तीना काजे कह्‌या ज देख जे अदमी यहुदी छे ने हामरा सहरेम माणसे मां गरबड़ी कर र्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ने चे असली रीती भातीन बारामां कय र्‌या जीनी रीती काजे माननु ने पाळनु आपणे वाटे वारु नी हय काहाकी आपणु रोमी माणसे छे। ");
INSERT INTO bhi_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","तत्‌यार तींद्‌रे सांबा चां वाळा माणसे हुड़दीन आय गुया। ने नीयाव करन्‌या तींद्‌रा पुथल्‌या फाड़ीन डील पर सी छेटा कर देदा ने तीनु काजे ठुकणेन हुकुम आप्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ने चे पोलुस ने सीलास काजे बेसका ठुक्‌या ने तीनु काजे जेल मां बुजी देदा ने जेल राखवाळ्‌या काजे कह्‌या ईनु काजे वारु चतराये देखजु। ");
INSERT INTO bhi_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","हुकुम सामळीन जेल राखवाळु तीनु काजे लीन माहें वाळी जेल मां बुज देदु ने तींद्‌रा पाये काजे लाकड़ा मां मेकीन ठुक देदा। ");
INSERT INTO bhi_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","आधलीक रातेन हेर फेर मां पोलुस ने सीलास भगवान साते दुवा करीन भगवानेन गुणे गावणे बाजी रवला ने दीसरा केदी बी तींद्‌री दुवा ने भगवानेन गुण गावतेला सामळी रवला। ");
INSERT INTO bhi_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ने तत्‌यारुत चां उचकाणुन बेसकी जुरे धरती हाली ने जेलेन पाया हाल पड़्‌या ने तत्‌यारुत जेलेन बारना उघड़ी गुया ने आखा केदीन हात कड़्‌या ने पाय कड़्‌या उघड़ी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","जेलेन राखवाळ्‌यु जागी गुयु ने जेलेन बारना उगड़ला देखीन ज्‌य समजी गुयु की केदी ठासी गुया तेरेमां चु मीयान मां सी तलवार नीकाळीन आपसा काजे तलवार दीन मारने हींडतेला। ");
INSERT INTO bhi_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","बाकुन पोलुस जुर सी आयड़ीन तीना काजे कह्‌यु तु आपसा काजे मारीन आपसान ने नुकसाण मां करे काहाकी हामु जात छे। ");
INSERT INTO bhi_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","तत्‌यार चु जेलेन राखवाळ्‌यु दिवु मांगाड़ीन माहें दवड़ीन गुयु ने कापतु जाय्‌न पोलुस ने सीलासेन पाये मां हीट पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ने चु तीनु काजे बाहार लावीन कह्‌यु ए मालक्‌या छुटकारु हात करने करीन मेसेक काय करनु पड़से। ");
INSERT INTO bhi_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","चे कह्‌या तु, “मालीक ईसु मसी पर भुरसु कर ती तुसे काजे ने तारा घरन्‌या काजे छुटकारु जड़से।” ");
INSERT INTO bhi_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ने पोलुस ने सीलास तीना जेलेन राखवाळ्‌या ने तेरा आखा घरन्‌यान माणसे काजे मालीक ईसुन बुल सामळ्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ने चु जेलेन राखवाळ्‌यु तीनीत राती तीनु काजे ली जाय्‌न तींद्‌रा घाव धुयु ने चु तत्‌यारुत आपसा घरन्‌या भेळु पाणी मां बपतीस्‌मा लेदु। ");
INSERT INTO bhi_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","तत्‌यार चु पोलुस ने सीलास काजे आपसान घर लीन गुयु ने तीनु काजे खाणो खावाड़्‌यु ने आपसा आखा घरबार्‌या पुठ्‌ये खुसी कर्‌यु काहाकी चे भगवान पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","संदारे हवतात नीयाव करन्‌या मुख्‌या हेरा सीपायड़ा काजे असी कय्‌न मकल्‌या की तीनु माणसे काजे छुड़ देवु। ");
INSERT INTO bhi_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","जेलेन राखवाळ्‌यु पोलुस काजे जी खबर सामळायु की, नीयाव करने वाळु तुहुं काजे छुड़नेन हुकुम कय मकेल्‌लु छे, तेरेसी हय तुहुं सुकुन सी बाहार नीकळीन जाती रवु। ");
INSERT INTO bhi_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","बाकुन पोलुस सीपायड़ा काजे कह्‌यु हामु रोमी सहर मां रवणेवाळा छे, तेबी हामरे पर लागाड़ला गुना जड़ने पाकुर चे हामु काजे आखा अगळ ठुकला ने जेल मां बुजी देदा ने हय हामु काजे काहा मकली र्‌या? असा हामु ती जाजे बाकुन चेत आवीन हामु काजे बाहार ली जाणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","सीपायड़ा आय्‌न नीयाव करन्‌या काजे जी वात सामळ्‌या ने पोलुस ने सीलास रोमी सहर मां रवणेवाळा छे, करीन बेसका बीही गुया, ");
INSERT INTO bhi_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ने चे नीयाव करन्‌या आवीन माफी मांग्‌या ने तीनु काजे जेल मां सी बाहर लीन गुया ने हीना सहर काजे छुड़ीन जाती रवु करीन वीन्‌ती कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","पोलुस ने सीलास जेल मां सी नीकळीन लुदीया बायरीन घर गुया, ने ईसु पर भुरसु करन्‌या भाय-बंद काजे भेळा हवीन तीनु काजे हिम्‌मत आप्‌या ने चां सी चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","पोलुस ने सीलास अमफीपुलीस ने अपुलन्‌या सहर मायन थीसलुनीकी सहर आया चां एक यहुदी माणसेन भक्‌तीन घर हतलो। ");
INSERT INTO bhi_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","चां पोलुस आपसी टेमेन अनसारे तीनु काजे मेळने गुयु ने तीना आरामेन दाहड़े लग तींद्‌रे साते चुखला सास्‌तुरेम सी वात देखाड़ीन दाखलु दी-दीन वात मां माथा-पच्‌ची हय गुय। ");
INSERT INTO bhi_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ने दाखला भेळु सास्‌तुरेन वाते काजे समजाड़्‌यु की ईसु मसी काजे दुख झेलने ने मर्‌या-सर्‌या मां सी जीवतो हवणु जरुड़ी छे, “ने चु ईसुत मसी छे तेरे बारामां परचार करे।” ");
INSERT INTO bhi_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","तींद्‌रे मां सी थुड़ाक माणसे ईसु पर भुरसु कर्‌या ने भगवानेन भक्‌ती करन्‌या युनानी माणसे मां सी बेसका जणा ईसु पर भुरसु कर्‌या ने बेसकी उची कुळीन बायरा बी ईसु पर भुरसु कर्‌या ने पोलुस ने सीलास पुठ्‌ये भेसकाय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","बाकुन यहुदी माणसे कुहरायणे बाजी गुया, ने चे थुड़ाक हाटे मायन गुंडा माणसे काजे भेळा कर्‌या ने टुळु बणीन दंगु कराड़ देदा। ने चे दवड़ीन आया ने यासोनेन घर अगळ भेळा हय गुया। ने चे असा कुसीत करने लाग्‌या कसा बी करीन पोलुस ने सीलास काजे सहरेन माणसे अगळ ली आवजे। ");
INSERT INTO bhi_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","बाकुन जत्‌यार पोलुस ने सीलास यासोनेन घर मां नी जड़्‌या ती चे यासोन ने चां वाळा दीसरा भायस काजे घसड़ीन सहरेन नीयाव करन्‌या चां ली गुया ने आयड़ीन कह्‌या जे माणसे आखी कळी मां परेसान कर देदला छे ने हय चां बी आय गुयला छे। ");
INSERT INTO bhi_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ने यासोन तीनु काजे हेरा घर मां थुबाड़ रयु, चे आखा मटला राजान हुकुमेन वीरुद करे ने कह्‌वे की एक राजु अळी छे तेरो नाव ईसु छे। ");
INSERT INTO bhi_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","जत्‌यार समजीन सहरेन माणसे टुळु ने सहरेन हकदार्‌या घाबराय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","छुड़ावणे वाटे हकदार्‌यान लागणे वाळा पयस्‌या यासोन ने दीसरा माणसे सी लेदा ने तीनुक छुड़ी देदा। ");
INSERT INTO bhi_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ईसु पर भुरसु करन्‌या भायस तीनेत राते पोलुस ने सीलास काजे बीरीया सहरे मां मकली देदा ने चे बीरीया सहरे मां पुगीन यहुदी माणसेन भक्‌तीन घर मां गुया। ");
INSERT INTO bhi_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","चे बीरीया सहर वाळा थीसलुनीकी सहर वाळा माणसे सी वदु वारु हतला ने चे बेसका मन लागाड़ीन भगवानेन बुल सामळ्‌या ने पोलुस कह्‌यु ची वात सय हय की नी हय करीन खरला सास्‌तुर मां हेरीन दाहड़ीन पारखतेला। ");
INSERT INTO bhi_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","तींद्‌रे मां बेसका माणसे ईसु पर भुरसु कर्‌या ने भगवानेन भक्‌ती करन्‌या युनानी मां उची कुळीन बायरा बी ईसु पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","बाकुन थीसलुनीकी मां रहणे वाळा यहुदी माणसे काजे मालुम पड़ गुयो की पोलुस बीरीया मां भगवानेन बुलेन परचार करने बाजी गुयु ती चे चां बी दवड़ीन आय गुया ने माणसे काजे भड़काया ने तींद्‌रे पर जुर करने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","तेरेसी ईसु पर भुरसु करन्‌या भायस पोलुस काजे तत्‌यारुत तु समुदर धड़े जात रव करीन कह्‌या बाकुन सीलास ने तीमुथीयुस चांहान रय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पोलुस काजे मेकणे जाण्‌या सीलास ने तीमुथीयुस काजे कह्‌या की तुहुं छाटास आवजु ने चे पोलुस काजे मेकणे करीन तेरे पुठ्‌ये चाल पड़्‌या ने चे पोलुस काजे मेकणे करीन एथेंस लग गुया। ");
INSERT INTO bhi_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","जत्‌यार पोलुस एथेंस सहर मां तीमुथीयुस ने सीलासेन वाट देख रवला ती तीना एथेंस सहर मां बेसका देवतान मुरत्‌या देखीन पोलुस काजे आपसा जीवे मां बेसको दुख लाग्‌यो। ");
INSERT INTO bhi_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","तेरेमां चे दाहड़ीन यहुदी माणसेन भक्‌तीन घर मां यहुदी ने भगवान काजे बीहणे वाळा युनानी सी वात-वात मां माथा-पच्‌ची करतेलु अतरोत नी बाकुन दाहड़ीन हाटे मां काहना बी रवतेला तींद्‌रे सी वात मां माथा-पच्‌ची करतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","चां ईपीकुरी ने स्‌तोईकी मास्‌तर्‌या हतला “चे पोलुस साते वात मां माथा-पच्‌ची करतेला ने तींद्‌रे मां थुड़ाक कह्‌या जु बक-बक करन्‌यु हामु काजे काय कह्‌णे हींड रयु ने?” दीसरा कह्‌या जु दीसरा देवतान परचार करन्‌याक मालुम पड़े, काहाकी पोलुस ईसुन बारामां जी सीकाड़नेन वात आपतेला की ईसु मर्‌या-सर्‌या सी जीवतु हय्‌न बठु हय गुयलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","तेरेसी चे तीना काजे धरीन अरीयुपगुस नावेन एक बयड़ी पर अकलेन बठक मां ली गुया, ने पुछ्‌या, तु जी नवली सीकाड़नेन वात माणसे काजे आपणे बाजी र्‌यु, तीनी सीकाड़नेन वात काजे हामु जाणने हींड रया। ");
INSERT INTO bhi_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","काहाकी हामु काजे बेसकी घाबराड़ देय असी वात सामळावे तेरेसी हामु जाणने हींड रया की तेरो मतलब काय छे? ");
INSERT INTO bhi_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","चां रहण्‌या आखा एथेंस सहर मां रहण्‌या आखा माणसे ने दीसरा देसेन माणसे नवली-नवली वात कह्‌वणे ने सामळने मां टेम लागाड़तेला ने तीनुक ईनी वाते मां मजा आवतेली। ");
INSERT INTO bhi_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","तत्‌यार पोलुस अरीयुपगुस नावेन बठक मां उबु हय्‌न कह्‌यु, ए एथेंस वाळा माणसे मे देखणे बाजी रयु, की तुहुं देवता पर बेसका भुरसु करीन तींद्‌री पुजा-पाट करु। ");
INSERT INTO bhi_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","मे जां फीरतु जाय्‌न तुंद्‌री पुजणेन चीज काजे देखणे बाजी रवलु, ती मेसे काजे एक असी बयड़ी देखाव पड़ी तीनी बयड़ी पर ज्‌य लिखलो हतलो, अन्‌जाण्‌या भगवान वाटे तेरेसी तुहुं तीना काजे जाणे पाकुर पुजा-पाट कर रया तेरे बारामां मे तुहुं काजे सामळावो। ");
INSERT INTO bhi_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","जु भगवान कळी काजे ने तेरेमां जो काय छे, चो आखो बणावलु छे, ने सरग ने धरतीन मालीक छे ने माणसेन हात सी बणावला मंदीर मां नी रवे। ");
INSERT INTO bhi_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","तीना काजे काहनी बी चीजेन फीकुर नी हय, तेरेसी तीना काजे काहनी बी चीज नी चाहती काहाकी चु आखा माणसे काजे जीवन ने जीवणेन दम आपे ने जो चाहजे आप्‌या करे। ");
INSERT INTO bhi_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","चु ते एकुत माणुस मां सी आखी जातीन धरती पर रवण्‌या माणसे काजे बणायु, ने तींद्‌री रवणेन जागान काकड़ बांद देदु। ");
INSERT INTO bhi_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ज आखो असो करनेन पछळ भगवानेन मरजी जी हतली, की आखी जातीन माणसे भगवान काजे हेरनु चाहजे कांखुर मायन चे हेरता-हेरता तीना भगवान काजे हेर लेय तेबी चु भगवान आपणे मां सी काहाना बी सी छेटु नी हय। ");
INSERT INTO bhi_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","काहाकी आपणु तेरेत मां जीवता रवजे, ने तेरेत मां हींडजे-फीरजे ने तेरेत मां टीकला रवजे। जसा तुंद्‌रे मायन थुड़ाक लिखण्‌या बी कह्‌ला छे, की हामु तेरात पुर्‌या-पारी छे। ");
INSERT INTO bhi_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","काहाकी हामु भगवानेन पुर्‌या-पारी हय्‌न आपणु काजे ज नी समजणु चाहजे की भगवान माणसेन वीच्‌यार सी सनान रुप्‌यान नीते दगड़ान बणावली मुरतीन तसु छे। ");
INSERT INTO bhi_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","वीतला जमाना मां माणसे ज जाणतेला की हामरे वाटे भगवानेन मरजी काय छे, तेरेसी चु तीनुक उचकाणुन डंड आप्‌यु बाकुन हय भगवान जु हुकुम आपलु छे, की आखे जागे माणसे पाप भीणी सी मन फेरवीन भगवान भीणी वळनु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","काहाकी भगवान एक दाहड़ु टाकलु छे, तेरेमां चु एक माणसेन साहरे आखी कळीन माणसेन धरमेन ताकड़ी लीन नीयाव करसे ने चु तीना नीयाव करन्‌या माणुस काजे मर्‌या-सर्‌या माणसे मां सी जीवतु करीन बठु कर देदलु छे ने आखा काजे आपसान ठेहरावली वातेक उजेंतु करीन सबुत आप देदु। ");
INSERT INTO bhi_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","तत्‌यार मर्‌या-सर्‌यान सी पछु जीवतु हवणेन वात सामळीन थुड़ाक माणसे हासी उड़ावणे बाजी गुया, ने थुड़ाक कह्‌या मर्‌या-सर्‌याम सी अळी जीवणेन बारामां हामु कदी नी सामळजे। ");
INSERT INTO bhi_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","तत्‌यार पोलुस तीनु काजे छुड़दीन जाती र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","बाकुन तेबी थुड़ाक माणसे पोलुसेन वात पर भुरसु कर्‌या ने तेरे पुठ्‌ये चाल पड़्‌या तींद्‌रे मां दीयेनीसीयुस हतलु जु अरीयेपागुस बठकेन एक मेहमर हतलु, ने दमरीस नावेन एक बायरी हतली, ने तींद्‌रे पुठ्‌ये अळी थुड़ाक माणसे हतला। ");
INSERT INTO bhi_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","अळतेन पोलुस एथेंस सहर छुड़दीन कुरींथीस मां गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","चां तीना काजे अक्‌वीला नावेन एक यहुदी माणुस भेळु हयु, ने चु पुन्‌तुस मां पयदा हवलु हतलु चु हेरी बायरी परीस्‌कीला पुठ्‌ये ईटली सी पेहलुस आवलु हतलु काहाकी क्‌लोदीयुस राजु आखा यहुदी माणसे काजे रोम सहर मां सी नीकळी जावु करीन हुकुम नीकाळ्‌यु। तेरेमां पोलुस तीनु माणसे काजे भेळु हवणे गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","काहाकी पोलुसेन ने तींद्‌रु एकुत धंदु हतलु तेरेसी पोलुस तींद्‌रेत पुठ्‌ये रवीन काम करने बाजी गुयु, ने तींद्‌रो काम धंदु तम्‌बु बणावणेन हतलो, काहाकी चे तम्‌बु बणावण्‌या हतला। ");
INSERT INTO bhi_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","पोलुस आरामेन दाहड़े यहुदी माणसेन भक्‌तीन घर मां जाय्‌न वाते मां माथा-पच्‌ची करतेलु ने यहुदी ने युनानी माणसे काजे समजाड़नेन कुसीत करतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","जत्‌यार सीलास ने तीमुथीयुस मकीदुनीया सी आया, ती पोलुस भगवानेन बुलेन परचार करने मां आपसो पुरो मन लागाड़ रवलु, ने चु यहुदी माणसे अगळ गवाय देतु, रयु की ईसुत मसी छे। ");
INSERT INTO bhi_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","बाकुन जत्‌यार चे माणसे पोलुसेन वीरुद करीन नाव-बद्‌दी करतेला ती पोलुस आपसान झगल्‌यो फाड़ीन तीनु काजे कह्‌यु, “तुंद्‌रु खुन तुंद्‌रा मुणका पर रहे! मे गुनाळु नी हय। मे हय सी नी-यहुदी मां ईसुन परचार करने जायस।” ");
INSERT INTO bhi_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","असु कय्‌न पोलुस तीनु काजे छुड़दीन जात रयु, ने तीतुस युस्‌तुस नावेन एक माणसेन घर गुयु, जु भगवानेन भक्‌ती करन्‌यु हतलु ने तेरो घर यहुदी माणसेन भक्‌तीन घर साते चस्‌टायन बांदलो हतलो। ");
INSERT INTO bhi_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","यहुदी माणसेन भक्‌तीन घरेन मुख्‌यु कीर्‌स्‌पुस आपसा आखान घरन्‌या भेळु मालीक ईसु पर भुरसु कर्‌यु, ने बेसका कुरींथी सहर वाळा माणसे बी पोलुसेन साहरे ईसुन बारामां वात सामळीन ईसु पर भुरसु करीन बपतीस्‌मा लेदा। ");
INSERT INTO bhi_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","मालीक ईसु तीनीत राते सपना मां पोलुस काजे कह्‌यु, बीहे मां बाकुन भगवानेन वात कवतु रव ने हुगु मां रवे। ");
INSERT INTO bhi_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","काहाकी मे तारे पुठ्‌ये छे, ने कुय बी तारो नुकसाण नी करे काहाकी हीना सहर मां मारा माणसे बेसका छे। ");
INSERT INTO bhi_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","तेरेसी पोलुस माणसे काजे भगवानेन वात सीकाड़तु जाय्‌न चां डेड़ साल लग रयु। ");
INSERT INTO bhi_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","जत्‌यार गल्‌लीयो अखाया देसेन राज-करन्‌यु हतलु, ती यहुदी माणसे मुजगी करीन पोलुस भीणी जुर करीन आया, तीना काजे कुरुट-कचेरी अगळ उबु करीन कह्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ने कह्‌या, जु अदमी भगवानेन भक्‌ती करनेन असु नीयम-कायदु सीकाड़े, जु मुसान साहरे लिखला नीयम-कायदा सी अलग छे। ");
INSERT INTO bhi_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","पोलुस आपसुत कह्‌णे हींडतेलु ने तीनेत टेमे गल्‌लीयो यहुदी माणसे काजे कह्‌यु, “ए यहुदी माणसे कदी जु नीयावेन वीरुद मां काय बी गुनु करलु हसे, नीते मटु गुनु कर्‌यु हय, ती मे तुंद्‌री वात सामळीन तीयार रवतु। ");
INSERT INTO bhi_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","बाकुन जे हीनी वात-वातेम लड़ायतेला, ती बेसका नावेन बारामां ने मुसान साहरे लिखला कायदान बारामां छे, तेरेसी ईनी वाते मां मे तुंद्‌रेम नीयाव करन्‌यु नी बणो, तुहुंत ईनी वातेन बारामां जाणु।” ");
INSERT INTO bhi_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ने चु गल्‌लीयो पोलुस काजे नीयाव करे तीनी कुरुट-कचेरी मां सी बाहर नीकाळ देदु। ");
INSERT INTO bhi_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ती आखा यहुदी माणसेन भक्‌तीन घरेन मुख्‌या सोस्‌थीनेस काजे नीयाव हवे तीनी कुरुट-कचेरी अगळुत धर पाड़्‌या ने बेसका ठुक्‌या, बाकुन गल्‌लीयो तीनी वात काजे देखी भाळीन काय बी नी कह्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पोलुस बेसका दाहड़ा लग कुरींथी सहर मां रयु, ने हेरे पछळ चु भायसे काजे आवजु कय्‌न परीस्‌कीला ने अक्‌वीला पुठ्‌ये ढंड्‌या मां बसीन सीरीया भीणी चाल पड़्‌यु, ने चु बादा लेदु करीन कींख्‌राया मां आपसान मुणका काजे बुड़ायु। ");
INSERT INTO bhi_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","अळतेन चे ईफीसुस पुग्‌या, ती पोलुस परीस्‌कीला ने अक्‌वीला काजे चांहान रहणीदीन यहुदी माणसेन भक्‌तीन घर मां जाय्‌न भगवानेन वातेन बारामां माथा-पच्‌ची करने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","चां वाळा माणसे लीलघाय्‌न कह्‌या थुड़ाक दाहड़ा अळी जां रय जां बाकुन पोलुस कह्‌यु मे नी रवतु कय देदु। ");
INSERT INTO bhi_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ने तीनु काजे छुड़ दीन जाणेन टेमे कह्‌यु भगवानेन मरजी रवसे तीते मे अळी तुंद्‌रेन्‌चां पछु आवीस, अळतेन पोलुस ईफीसुस सी ढंड्‌या मां बठीन चाल देदु। ");
INSERT INTO bhi_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ने अळतेन चु केसर्‌या सहर पुग्‌यु ने चां सी यरुसलेम सहर गुयु, ने चां वाळी ईसुन मंडळी काजे भेळु हय्‌न वारु छे की करीन कह्‌यु, अळतेन चु चांहा सी अन्‌ताकीया सहर मां जात र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","पोलुस थुड़ाक दाहड़ा अन्‌ताकीया सहर मां रयु, ने चु गलातीया ने फुर्‌गीया फीरतु जाय्‌न आखा ईसु पर भुरसु करने वाळान भुरसा काजे काठु करतु रयु। ");
INSERT INTO bhi_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","तीनी टेमे चां यहुदी माणुस हतलु, तेरो नाव अपुल्‌लोस हतलो, चु सीकेन्‌दर्‌या मां पयदा हवलु, चु अक्‌कल वाळु माणुस हतलु, खरला सास्‌तुर काजे वारु रीते जाण तेलु, चु ईफीसुस मां आयु। ");
INSERT INTO bhi_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","तीना काजे मालीक ईसुन सीकाड़ने वाळी वात जड़ली हतली, ने मन लागाड़ीन ईसुन बारामां सय-सय सीकाड़तेलु बाकुन तीना काजे युहन्‌नान बपतीस्‌मान बारामां अतरोत मालुम हतलो। ");
INSERT INTO bhi_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","चु भक्‌तीन घर मां बीहे बीगुर भगवानेन वात कवणे बाजी गुयु, परीस्‌कीला ने अक्‌वीला तेरी वात सामळीन तीना काजे चे तींद्‌रेन्‌चां लीन गुया, ने तीना काजे वारु रीते भगवानेन वात समजाड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","जत्‌यार अपुल्‌लोस समुदर वेणकीन अखाया जाणे करीन पाक्‌कु वीच्‌यार कर्‌यु, ती दीसरा ईसु पर भुरसु करन्‌या भायस, तीना काजे हिम्‌मत देदा ने अखाया वाळा काजे ज लिख्‌या की तुहुं पोलुसेन आव-भाव करजु जत्‌यार पोलुस अखाया पुग्‌यु ती चां वाळा माणसे तेरी बेसकी मदत कर्‌या जे भगवानेन गीण-दया सी ईसु पर भुरसु करला। ");
INSERT INTO bhi_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","काहाकी चु खरला सास्‌तुर मां सी समजाड़तु जाय्‌न कवतेलु, की ईसुत मसी छे, ने यहुदी माणसे अगळ खरला सास्‌तुर मां सी बेसका वात कय्‌न तींद्‌री बुलती बंद कर देदलु। ");
INSERT INTO bhi_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","तीने टेमे असो हयो की जत्‌यार अपुल्‌लोस कुरींथीस सहर मां हतलु, तीने टेमे पोलुस ने चां आखा परदेस मायन फीरतु-फीरतु ईफीसुस मां आयु, चां तीनुक थुड़ाक चेला भेळा हया। ");
INSERT INTO bhi_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","तीनु चेला काजे पोलुस पुछ्‌यु “जत्‌यार तुहुं ईसु पर भुरसु करला ती चुखली-आत्‌मा हात करला काय चे चेला कह्‌या?” हामु ते चुखली-आत्‌मान बारामां सामळ्‌या लग नी। ");
INSERT INTO bhi_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","अतरे पोलुस तीनु काजे पुछ्‌यु ती तुहुं कुणीन बपतीस्‌मा लेदला छे? चे जपाप आप्‌या युहन्‌नान बपतीस्‌मा लेदला छे। ");
INSERT INTO bhi_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","पोलुस कह्‌यु युहन्‌‌‌नु ज्‌य कय्‌न मन फीरावणेन बपतीस्‌मा आपलु की जु मारे पछळ आवणे वाळु छे हेरे पर मतलब ईसु पर भुरसु करजु। ");
INSERT INTO bhi_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ज्‌य सामळीन चे मालीक ईसुन नाव सी बपतीस्‌मा लेदा। ");
INSERT INTO bhi_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","जत्‌यार पोलुस तींद्‌रे पर हात मेकीन तींद्‌रे वाटे भगवान सी दुवा कर्‌यु ती चुखली-आत्‌मा तींद्‌रे पर उतरीन तींद्‌रे मां भराय गुय ने चे भाती-भातीन बुली बुलने बाजी गुया ने भगवानेन अघे सी वात कह्‌वणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","चे आखा मेळीन बारे जणा हतला। ");
INSERT INTO bhi_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","अळी पोलुस तीन महना लग यहुदी माणसेन भक्‌तीन घर मां जाय्‌न बीहे पाखुर भगवानेन राजेन बारामां यहुदी माणसे साते वाते मां माथा-पच्‌ची करतेलु ने समजाड़्‌या करतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","बाकुन तींद्‌रे मां सी थुड़ाक माणसे पीटा हतला, ने पोलुसेन वात सामळीन ईसु पर भुरसु नी कर्‌या ने दीसरा अगळ ईना ईसुन टुळान बारामां वाक नीकाळनी बाजी गुया, अतरे पोलुस तींद्‌रे सी अलग हय गुयु, ने आपसान चेला काजे लीन चां सी जात रयु, ने चु दाहड़ीत तुरनुसेन भणावण्‌या घर मां भगवानेन वाटेन बारामां वात कय्‌न तींद्‌रे साते माथा-पच्‌ची करतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","दुय साल लग चु असुत भगवानेन राजेन बारामां कवतु जाय्‌न समजाड़तु रयु, ने तेरी वात सामळीन आसीया मां रहण्‌या यहुदी माणसेक ने नी-यहुदी माणसेक मालीक ईसुन बारामां बुले सामळीन ईसु पर भुरसु कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","भगवान पोलुसेन साहरे बेसका भारी काम देखाड़तु रयु। ");
INSERT INTO bhi_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","जत्‌यार माणसे पोलुसेन डीले लागाड़ीन रुमाल ने फेटको मांदला साते ली जातला ती चे मांदला वारु हय जातला ने भुतड़ान आत्‌मा तींद्‌रे मां सी नीकळी जातला। ");
INSERT INTO bhi_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","थुड़ाक यहुदी माणसे जागे-जागे बड़वाय करता फीरतेला, ज्‌य करने लाग्‌यु की तींद्‌रे मां भुतड़ान आत्‌मा रवे तींद्‌रे पर मालीक ईसु नाव ज्‌य कय्‌न फुक्‌या तीना ईसुन परचार पोलुस करे मे तुहुंक हेरीत सगुन आपो। ");
INSERT INTO bhi_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ने सक्‌कीवा नावेन एक यहुदी मुख्‌या पुजारान सात पुर्‌या हतला, चे बी असात बड़वाय करीन भुतड़ा नीकाळतेला। ");
INSERT INTO bhi_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","बाकुन भुतड़ान आत्‌मा तीनु काजे जपाप आप्‌यु, मे ईसु काजे जाणो ने पोलुस काजे बी जाणो बाकुन तुहुं कुण छे? ");
INSERT INTO bhi_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","अळतेन तीना माणसे मां भुतड़ान आत्‌मा हतली, चु माणुस झड़ दीन तींद्‌रे पर आय गुयु ने तीनुक हाराड़ देदु, तेरेमां चे नांगेरलात घायल हय्‌न तीना घर सी नीकळीन ढासी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ज्‌य हयो तेरी खबर ईफीसुस सहर मां रवण्‌या यहुदी माणसे मां ने नी-यहुदी माणसे मां जात रया ने चे आखा माणसे बीहीन बेसका घाबराय गुया ने हीने रीते मालीक ईसुन नावेन ईज्‌जत अळी जादा हवणे बाजी गुय। ");
INSERT INTO bhi_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","तींद्‌रे मां सी बेसका जणा भुरसु करला, ने गलत काम करला आखा माणसे अगळ मान लेदा ने चां आया। ");
INSERT INTO bhi_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ने चे बड़वाय करन्‌या आपसा आपसान बड़वाय करनेन किताप तींद्‌रे चां लावीन भेळा कर देदा ने आखा अगळ तीनु कितापेन दाम चांदीन पचास हजार टका बराबर हतला। ");
INSERT INTO bhi_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","असो करीन मालीक ईसुन वात माणसे काजे जादा समज मां आवती गुय ने बेसका माणसे ईसु पर भुरसु करता गुया। ");
INSERT INTO bhi_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","जत्‌यार जी वात हय गुय, ती पोलुस आपसान जीवे मां असु वीच्‌यार कर्‌यु, की मे मकीदुनीया ने अखाया मायन यरुसलेम जायस चां जाय्‌न अळतेन रोम मां बी देखणे जायस। ");
INSERT INTO bhi_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","तेरेमां पोलुस आपसा साती तीमुथीयुस काजे, ने ईरास्‌तुस काजे सेवा करने करीन मकीदुनीया मकली देदु, ने आपसुत आसीया मां थुड़ीक टेम अळी रयु। ");
INSERT INTO bhi_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","तीने टेमे मालीकेन वाटेन वजे सी माणसेन टुळु वीरुद करीन बेसका माणसे दवड़ीन आया। ");
INSERT INTO bhi_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","चां देमेतीरीयुस नावेन एक सनार्‌यु हतलु, ने तेर पुठ्‌ये मुरती बणावण्‌यु बी हतलु। चु तींद्‌रे सी, अरतीमीस नावेन एक देवीन मंदीरेन मुरत्‌या चांदीन बणाय मांगतेलु। ने असु करीन चु ने तेरा मुरती बणावण्‌या बेसका कमायतेला। ");
INSERT INTO bhi_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","चु ईनु काम-धंदु करन्‌या दीसराक बी भेळा करीन कह्‌यु, ए माणसे तुहुं काजे ते मालुम छे, की ईना काम-धंदा मां आपणी बेसकी कमाय हवे। ");
INSERT INTO bhi_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","बाकुन तुहुं देखु ने सामळु की चु पोलुस ईफीसुस ने आखा आसीया मां माणसे काजे ज्‌य कय्‌न समजाड़े ने मुरती लेणे वीचकाड़े की हाते सी बणावला मुरत्‌या देवता नी हय। ");
INSERT INTO bhi_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","पोलुस असुत माणसे काजे समजाड़्‌या करसे ती जी डर छे की आपणु मुरती बणावीन वेचणेन काम धंदु बंद हय जासे ने मट्‌ली देवी अरतीमीसेन मंदीरेन ईज्‌जत बी जात रवसे करीन डर छे ने तीनी देवीन पुजा-पाट आखे आसीया ने आखी कळ करे। ");
INSERT INTO bhi_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","जी वात सामळीन चे रीसवाय पड़्‌या ने आयड़ी-आयड़ीन कह्‌या, ईफीसुस्‌या सहर मां रवण्‌या अरतीमीस देवी बेसकी मटी छे। ");
INSERT INTO bhi_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","सहरेन दीसरा माणसे बी तींद्‌रे मां भेसकाय गुया ने मकीदुनीया वाळा गयुस ने अरीस्‌तारकुस काजे धर लेदा जे पोलुस पुठ्‌ये हींडतेला ने आखान आखा एक मन्‌या हय्‌न उफरीवाळा मकेळा घर मां दवड़ी पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","जत्‌यार पोलुस तीनु माणसेन टुळान ईचमां जाणे हींड रवलु, बाकुन चेला तीना काजे चां जाणे नी देदा। ");
INSERT INTO bhi_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","आसीया जीलान थुड़ाक हकदार्‌या पोलुसेन दुस्‌तीदार हतला चे हकदार्‌या जी खबर दी मकल्‌या ने लीलघाय सी कहें की तु उफरीवाळा मकेळा घर मां आवीन दुख मां घुण पड़े। ");
INSERT INTO bhi_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","तीने टेमे गड़दी मां सी काहनास कांखुरुत आयड़ी रवला, ने काहना काहनाक कांखुरुत आयड़ी रवला, काहाकी बेसका माणसे काजे ज्‌य मालुम नी हतलो की काहा भेळा हवला छे। ");
INSERT INTO bhi_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","तीनी गड़दी मां सी सीकेन्‌दर्‌या नावेन एक माणुस हतलु तीना काजे यहुदी माणसे तींद्‌रे मां सी नेवाड़ला हतला चे तीनाक समजाड़ीन गड़दी अगळ उबा कर देदा सीकेन्‌दर्‌यु हात पालवीन ईसारु करीन आपसा काजे बचाड़ने हींड रवलु। ");
INSERT INTO bhi_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","बाकुन जत्‌यार तीनु काजे पतु चाल्‌यु की चु एक यहुदी माणुस छे ती चे आखान आखा एक जसा दुय घंटा लग आयड़ी-आयड़ीन कह्‌या ईफीसुस्‌यान सहरे मां रवण्‌या देवी अरतीमीस बेसकी मटी छे। ");
INSERT INTO bhi_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","तत्‌यार सहरेन मंत्‌री गड़दी काजे हुगु राखीन कह्‌यु, ए ईफीसुस्‌यान सहरे मां रवण्‌या माणसे ईफीसुस सहर मां रवण्‌या माणसे मट्‌ली देवी अरतीमीस देवीन मंदीरेन ने सरग भीणी सी पल्‌ली मुरतीन राखवाळ्‌या चे ईनी वाते काजे आखी कळीन माणसे जाणे। ");
INSERT INTO bhi_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","अतरे ईनी वाते काजे कुय नी काटी नी सके अतरे ज्‌य वारु छे की तुहुं हुगा रहु ने वीच्‌यार नीकाळे पाखुर काय मां करु। ");
INSERT INTO bhi_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","काहाकी तुहुं तीनु माणसे काजे लावला छे चे नीते मंदीर मां धड़ु पाड़्‌या ने नीते आपणी देवीन वाक नीकाळ्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","कदी देमेतीरीयुस काजे ने तेरे साते काम-धंदु करन्‌यान काहानी वाते मां वाक हय ती नीयाव वाटे कुरुट-कचेरी चालु छे ने चां नीयाव करन्‌या धेणी बी छे चां जाय्‌न एक दीसरान वाक नीकाळ्‌या करु। ");
INSERT INTO bhi_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","बाकुन तुहुं काहींग पुछणे हींडे ती ईनी वातेन बारामां जाणने करीन सहरेन नेमेन बसक हय चां आवजु चां ईनी वातेन वीच्‌यार नीकाळु। ");
INSERT INTO bhi_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","काहाकी आज जी बी दंगाय हवली छे, ची हामरे माथे पड़से तेरेसी जां हेरे बारामां वीच्‌यार नीकाळनु वारु नी हय काहाकी ईने टेमे ईनी गड़दी मां वाळा माणसे काजे हामरे सी काय बी जपाप नी आपाये। ");
INSERT INTO bhi_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ज्‌य कयदीन चु सहरेन पंचु काजे वळाय देदु। ");
INSERT INTO bhi_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","माणसे दवड़ीन आया ने अळतेन चे सींग पड़ने बाजी गुयो, ती पोलुस ईसुन चेला काजे बुलावीन समजाड़्‌यु, ने तीनु काजे आवजु कयदीन चां सी मकीदुनीया भीणी चाल पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ने चु तीना परदेस मां सी हय्‌न ने माणसे काजे बेसकु सांती आप्‌यु चां सी युनान जीला मां जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ने पोलुस चां तीनेक महना रयु काहाकी यहुदी माणसे तीना काजे मारने करीन जाळसांदी नाख रवला, ने अळतेन वीच्‌यार नीकाळ्‌यु की मे ढंड्‌या मां बसीन सीरीया जात रवीस, बाकुन अळतेन चु अळी वीच्‌यार कर्‌यु की मे मकीदुनीया पछु जात रवीस ने चाल पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","बीरीया सहर वाळु पुर्‌रुसेन पुर्‌यु सोपतुरुस ने थीसलुनीकीया मां रहणे वाळा अरीस्‌तारकुस ने सीकुन्‌दुस ने आसीया वाळा तुखीकुस ने तरुफीमुस ने दीरबे वाळु गयुस ने तीमुथीयुस तेरे पुठ्‌ये आसीया लग आया। ");
INSERT INTO bhi_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","चे माणसे पेहलुत तरोआस मां जाय्‌न हामरी वाट देख रवला। ");
INSERT INTO bhi_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","अखमीरी रुटान तीहवार हय गुयु, ने अळी हामु फीलीपी सहर सी मटला ढंड्‌याम बसीन तरोआस भीणी चाल पड़्‌या। ने पांच दाहड़ाम हामु तरोआस पुग्‌या। ने चां हामु सात दाहड़ा रया। ");
INSERT INTO bhi_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","हाप्‌तान पेहले दाहड़े हामु रुटु तुड़ने वाटे भेळा हया, ती पोलुस माणसे सी वात कर्‌यु, ने चु दीसरे दाहड़े जाणे वाळु हतलु, ने तींद्‌रे सी वात कर्‌यु, ने आधली रात लग वाते करतुत रयु। ");
INSERT INTO bhi_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","हामु तीना घरेन उपरी खुली मां भेळा हय रवला, चांहा बेसका दिवा धपाड़ीन मेल रवला। ");
INSERT INTO bhi_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ने युतुखुस नावेन एक जुवान पुर्‌यु खीड़की पर बठ रवलु, ने बेसकी नीद आय रवली जत्‌यार पोलुस बेसकी वार लग वाते करतु रयु, ती चु नीदेन झपकी मां तीसरी मंजील पर सी हीटी पड़्‌यु, ने जत्‌यार हाकलीन लाया ती चु मरी गुयलु। ");
INSERT INTO bhi_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","बाकुन पोलुस नेचु उतरीन हेरेसी चस्‌टाय गुयु, ने गळे लागाड़ीन कह्‌यु “घाबरायु मां हयु जीवलुत छे।” ");
INSERT INTO bhi_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","बाकुन चु उपर गुयु, ने रुटा काजे तुड़ीन वाट्‌यु ने खादु। ने हयु तींद्‌रे साते बेसकी वार ने तींद्‌रे सी दाहड़ु उंगते लग वात करतु रयु, ने पोलुस तीनुक छुड़ीन जाती रयु। ");
INSERT INTO bhi_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ने चे तीना जुवान पुर्‌या काजे चे जीवतेलु घर ली आया, ने बेसका सांती ने खुसी मां हय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","हामु पेहलुत ढंड्‌या मां बसीन अस्‌सुस भीणी गुया, की चां सी हामु पोलुस काजे चड़ाय लेसुन, काहाकी हयु ज्‌य हेरेसी ठेरावलु हतलु की आपसु चालीन जाणे वाळु हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","जत्‌यार पोलुस अस्‌सुस मां हामु काजे भेळु हयु, ती हामु तीना काजे ढंड्‌या पर चहड़ाया ने हामु मीलेतुस भीणी चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","चां सी ढंड्‌या काजे छुड़ीन हामु दीसरे दाहड़े खीयुस गुया ने दीसरे दाहड़े सामुस मां जाय पड़्‌या अळतेन दीसरे दाहड़े मीलेतुस मां आया। ");
INSERT INTO bhi_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","काहाकी पोलुस जाहां लग हय सके पेन्‌तेकुस्‌तेन दाहड़े लग यरुसलेम मां मामार जाणेन कुसीत कर रवलु, तेरेमां हयु नक्‌खी कर्‌यु की हयु ईफीसुस मां हुबु नी रवे ने अघुत जाती रवसे, काहाकी तीनाक आसीया मां रहणु नी पड़े। ");
INSERT INTO bhi_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","हयु मीलेतुस सी ईफीसुस मां कय मकल्‌यु ने मंडळीन डाहा-बुड़ा माणसे काजे आपसा धड़े बुलायु। ");
INSERT INTO bhi_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","जत्‌यार चे हेरे धड़े आया ती तींद्‌रे सी कह्‌यु तुहुं जाणु की पेहलेत दाहड़े सी जत्‌यार मे आसीया मां पुग्‌यु मे आखी टेमे तुंद्‌रे साते काहाली रीत सी रयु। ");
INSERT INTO bhi_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","मतलब वारु भाव सी ने आसळा पाड़ी-पाड़ीन ने ईनु पारख मां ज्‌य यहुदीयान माणसेन कुहरायन वजे सी मार पर आय पड़ी मे मालीकेन चाकरी करतुत रयु। ");
INSERT INTO bhi_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ने जी-जी वाते तुंद्‌रे फायदान हतली तीनुक बताड़ने ने माणसे अगळ ने घर-घर सीकाड़ने सी कदी नी पछु हयु। ");
INSERT INTO bhi_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","यहुदी ने नी-यहुदी माणसे काजे मे बराबर भाव सी मन फेरवणेन भगवान भीणी फीरु करीन कय रयु ने, आपणा मालीक ईसु मसी मां भुरसु करु करीन तीनुक कवतु रयु। ");
INSERT INTO bhi_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ने हय देखु मे चुखली-आत्‌मान अगवाय मां बांदायन मे यरुसलेम जाय रयु। मे नी जाणु की चां मार साते काय हवसे। ");
INSERT INTO bhi_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","अळतेन ज्‌य की चुखली-आत्‌मा आखा सहर मां गवाय दी-दीन मार सी कह्‌वे की बांदायणु ने दुख तारी वाट देख रय। ");
INSERT INTO bhi_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","बाकुन मारे वाटे आपणा जीवेन काय बी कीमत नी हय। मे ते बस दवड़नु ने तीनी सेवा काजे पुरो करने चाही र्‌यु तीनाक मालीक ईसु सी जड़लो छे चो गुयो छे भगवानेन गीण-दयान गवाय देणु। ");
INSERT INTO bhi_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","हय देखु मे जाणो की तुहुं, आखा तींद्‌रे मां भगवानेन राजेन परचार करतु रयु, ने मेसे अळी कदी नी देखसु। ");
INSERT INTO bhi_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","तेरेमां आज मे तुंद्‌रे अगळ गवाय दीन कह्‌वो की मे तुंद्‌रे मां सी काहनान बी लुहीन गुनाळु नी हय। ");
INSERT INTO bhi_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","काहाकी मे भगवानेन आखी मरजी काजे तुंद्‌रे अगळ पुरी रीत सी बताड़ने मां कदी बी पछु नी पड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","हेरेसी आपणी ने आखा टुळान देख-भाळ करु तेरेमां चुखली-आत्‌मा तुहुं काजे मुख्‌या ठेरावलु छे की तुहुं भगवानेन मंडळीन राखवाळी करु तीना काजे हयु आपणा लुही सी मुल ली लेदलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","मेसेक मालुम छे, की मारे जाणेन पछे तुंद्‌रे ईचमां धरन्‌या लेंड्‌या आवसे ने चे भुळा-भाळा टुळा काजे नी छुड़े। ");
INSERT INTO bhi_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ने अतरो बी की तुंद्‌रे आपणे ईचमां सीत असा माणसे बी उबा हवसे, जे चेला काजे आपसे पछळ चालाड़ने वाटे वात काजे गलत सलत वात सीकाड़से। ");
INSERT INTO bhi_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","हेरेसी जागता रवु ने हेर करु की मे तीन साल लग रात ने दाहड़ु रड़ीन-रड़ीन एकेक काजे चेतावणी देणे नी छुड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ने हय मे तुहुंक भगवान काजे ने हेरी बेसकी वारु दयान बुल काजे सुपी दम काहाकी तुहुं बड़ता जावु ने आखा चुखा हवला माणसे मां गवाय देणेन हक आप देसे। ");
INSERT INTO bhi_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","मे काहनाक ने चांदीन, सनान नीते पुथल्‌यान हर कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","तुहुं आपसात जाणु की जेत हाते ने मारी ने मारा साते वाळान ज्‌य-ज्‌य चीज चाहजे चो पुरो कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","मे तुहुं काजे आखो काय करीन देखाड़्‌यु की हीनी रीत सी मेहनत करता जाय्‌न लुला काजे समाळजु ने मालीक ईसुन बुल हेर राखणु जरुरी छे। ");
INSERT INTO bhi_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","असो कहणेन पछे हयु मांडा टेक्‌यु ने तींद्‌रे आखा साते दुवा कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तत्‌यार चे आखा रड़्‌या ने पोलुसेन गळे लागीन गुळा देणे लाग्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","चे खास करीन हीनी वातेन दुखी हतला चो हयु कहलु की तुहुं मारो मुंहडो अळी नी देखसु तत्‌यार चे हीनाक ढंड्‌यान्‌चां पुगाड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","जत्‌यार हामु तींद्‌रे सी अलग हय्‌न समुदर मां हामरो ढंड्‌यो छुड़ लेदा, ने सुदी सट वाटे कुस मां आया ने दीसरे दाहड़े रुदुस मां ने चां सी पतरा मां आया। ");
INSERT INTO bhi_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ने पतरा सी हामु एक ढंड्‌याम बसीन चाल पड़्‌या, चु फीनीके जाणे बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","जत्‌यार सायपर्‌स देखायु ती हामु हीनुक डाखर्‌ये हात भीणी छुड़्‌या ने सीरीया भीणी जाय्‌न सुर मां उतर्‌या काहाकी चां ढंड्‌याम सी माल उतारनु हतलो। ");
INSERT INTO bhi_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ईसु पर भुरसु करन्‌या भेळा हय गुया, ती हामु चां सात दाहड़ा लग रया चे आत्‌मान सीकाड़ला हतला पोलुस सी कह्‌या की यरुसलेम मां पाय घुण मेले। ");
INSERT INTO bhi_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","बाकुन चे दाहड़ा पुरा हय गुया, ती हामु चां सी चाल देदा ने आखा बायरा ने पुर्‌या भेळा हामुक सहरेन बाहार लग पुगाड़्‌या ने हामु दर्‌या धड़े मांडा टेकीन दुवा कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","तत्‌यार एक दीसरा सी आवजु ने आवसुन कय्‌न हामु ते ढंड्‌या पर चहड़्‌या ने चे आपसे-आपसे घर जात र्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","तत्‌यार हामु सुर सी पाणी मां हामरी चाल पुरी करीन पतुलीम्‌या मां पुग्‌या ने भायसे काजे आवजु ने आवसुन कय्‌न तींद्‌रे साते एक दाहड़ु रया। ");
INSERT INTO bhi_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","दीसरे दाहड़े हामु चां सी चालीन केसर्‌या मां आया ने फीलीप्‌पुस खुस-खबरेन परचार करन्‌यान घर मां जु सात मां सी एक हतलु जाय्‌न हेरेन चां रया। ");
INSERT INTO bhi_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","हेरी चार कुवारी पुरे हतली जी भगवानेन अघे सी वात देखाड़नेन वाटु जड़लु हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","जत्‌यार हामु चां बेसका दाहड़ा रय लेदा ती अगबुस नावेन एक भगवानेन अघी सी आवणे वाळी वात बताड़न्‌या माणुस यहुदीया सी आयु। ");
INSERT INTO bhi_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","हामरे धड़े आवीन पोलुसेन फेटको लेदु ने हेरा हात पाय बांदीन कह्‌यु चुखली-आत्‌मा ज्‌य कह्‌वे की तीना माणसेन ज्‌य फेटको छे तीना काजे यरुसलेम मां यहुदी माणसे हीनीत रीत सी बांदसे ने नी-यहुदी हात मां आप देसे। ");
INSERT INTO bhi_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","जत्‌यार हामु जी वात सामळ्‌या ती हामु ने चांहान माणसे हेरेसी दुवा कर्‌या की पोलुस यरुसलेम मां नी जाणु चाहजे। ");
INSERT INTO bhi_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","बाकुन पोलुस जपाप आप्‌यु तुहुं काय कय र्‌या की रड़ी रड़ीन मारा मन काजे मां तुड़ु मेसे मालीक ईसुन नाव वाटे यरुसलेम मां नी बाकुन बांदाय जाणे वाटे बाकुन मरने वाटे बी तीयार छे। ");
INSERT INTO bhi_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","जत्‌यार चु नी मान्‌यु ती हामु ज्‌य कय्‌न हुगा हय गुया की मालीकेन मरजी पुरी हवे। ");
INSERT INTO bhi_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","तीनु दाहड़ान पछे हामु तीयारी कर्‌या ने यरुसलेम भीणी चाल देदा। ");
INSERT INTO bhi_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","केसर्‌या सी बी थुड़ाक चेला हामरे साते आय गुया। ने हामु काजे मनासोन नावेन सायपर्‌स मां एक पेहला चेलान चां ली आया की हामु हेरेन चां रय रवजे। ");
INSERT INTO bhi_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","जत्‌यार हामु यरुसलेम मां पुग्‌या ती ईसु पर भुरसु करन्‌या भायस खुस हय्‌न हामु काजे भेळा हया ने आव-भाव कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","दीसरे दाहड़े पोलुस हामरे पुठ्‌ये याकुप काजे भेळु हवणे गुया, चां आखा डाहा-बुड़ा भेळा हय रवला। ");
INSERT INTO bhi_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","तत्‌यार चु पोलुस हीनु काजे आवजु ने आवीस कय्‌न जे काम भगवान हेरी चाकरीन साहरे नी-यहुदी मां करलु एक-एक करीन आखी वात बताड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","चे ज्‌य सामळीन भगवानेन बड़ाय कर्‌या अळतेन हीनाक कह्‌या ए भाय पोलुस देखे की यहुदी मां सी काय हजार माणसे भुरसु कर्‌या ने आखा मुसान साहरे लिखला कायदाक वाचाड़न्‌या बी छे। ");
INSERT INTO bhi_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ईसुक तारे बारामां सीकाड़ गुयलो छे की तु नी-यहुदी मां रवण्‌या यहुदी माणसे काजे मुसा सी छेटा हय जावु करीन सीकाड़े ने कह्‌वे की नी आपणा पुर्‌यान चामड़ी काटाड़ु ने नी रीती रीवाज पर चालु। ");
INSERT INTO bhi_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ती हय काय करनु चाहजे? माणसे जरुर सामळसे की तु आवलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","हेरेसी ज्‌य हामु तारे सी कवजे चो कर हामरेन चां जां चार माणसे छे चे मान्‌ता लेदला छे। ");
INSERT INTO bhi_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","हीनुक लीन तींद्‌रे साते आपसा काजे चुखु कर ने तींद्‌रे वाटे खरचु आप की चे मुणका काजे बुड़ावे तत्‌यार आखा जाणी लेसे की जी वाते हीनुक तारे बारामां देखाड़ली छे तींद्‌रे मां सी थुड़ीक छाचाय नी हय बाकुन तु आपसु बी मुसान साहरे लिखला कायदा काजे मानीन हेरे अनसारे चाले। ");
INSERT INTO bhi_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","बाकुन हीयु नी-यहुदीन बारामां चे भुरसु करला छे हामु असा वीच्‌यार करीन चिट्‌ठी मकेला छे की चे तुहुं मुरती पर चड़ावला सीकार सी ने लुही सी ने गळु दड़पीन मारला सीकार सी ने छीनाळा सी बचीन रहु। ");
INSERT INTO bhi_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","तत्‌यार पोलुस तीनु माणसे काजे लीन ने दीसरे दाहड़े तींद्‌रे साते चुखु हय्‌न मंदीर मां गुयु ने चां बताड़ देदु की चुखु हवणेन दाहड़े मतलब तींद्‌रे मां सी एक-एक जणा वाटे चड़ावु चड़ावे जांहा लग की दाहड़ा पुरा नी हवसे। ");
INSERT INTO bhi_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","जत्‌यार चे सात दाहड़ा पुरा हवणे वाळा हतला ती आसीयान यहुदीया पोलुस काजे मंदीर मां आखा माणसे कीचवाड़्‌या ने असा आयड़ी-आयड़ीन हीनाक धर लेदा। ");
INSERT INTO bhi_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ए ईस्‌रायली मदत करु जु हयुत माणुस छे जु माणसे ने मुसान साहरे लिखला कायदा ने हीना जागान वीरुद मां एक-एक जागा आखा माणसे काजे सीकाड़े जां लग की नी-यहुदी काजे बी मंदीर मां लावीन जु हीना चुखला जागा काजे वीटाळ देदु। ");
INSERT INTO bhi_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","चे तेरसी पेहल ईफीसुस वाळा तरुफीमुस काजे हेरे साते सहर मां देखलु ने समजाड़ला की पोलुस हीनाक मंदीर मां ली आवे। ");
INSERT INTO bhi_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","तत्‌यार आखा सहर मां माणसे हाय-हाय कर्‌या ने माणसे दवड़ीन भेळा हया ने पोलुस काजे धरीन मंदीरेन बाहार घीसड़ीन लाया ने तत्‌यारुत बारनो बंद कर देदा। ");
INSERT INTO bhi_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","चे पोलुस काजे मार नाखणे हींडी रवला। तीनेत टेमे सीपायड़ान मुख्‌यु सुबेदार काजे काहनुस जी खबर पुग्‌याड़्‌यु की, की आखा यरुसलेमेन सहरेन माणसे पोलुस भीणी जाय रया। ");
INSERT INTO bhi_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","चु सुबेदार तत्‌यारुत सीपायड़ा ने सीपायड़ान दीसरा मुख्‌या काजे तेरे पुठ्‌ये लीन पोलुस काजे मारने हींडतेला तीनु यहुदी माणसे भीणी गुया। चे यहुदी सीपायड़ान मुख्‌या सुबेदार काजे ने सीपायड़ान दीसरा मुख्‌या काजे देख्‌या ती चे पोलुस काजे ठुकणे बंद कर देदा। ");
INSERT INTO bhi_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","तत्‌यार सीपायड़ान मुख्‌या सुबेदार आवीन पोलुस काजे धर लेदु ने दीसरा सीपायड़ान मुख्‌या काजे कह्‌यु की “हेरे हातकड़्‌या लागाड़ देदु।” अळतेन चु सीपायड़ान मुख्‌या सुबेदार गड़दीम वाळा माणसेक पुछ्‌यु, “जु कुण छे ने जु काय गुनु करलु छे?” ");
INSERT INTO bhi_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","गड़दीम वाळा माणसे मां काहनुस काहींग कय रवलु ने काहनुस काहींग कय रवलु। काहाकी तीना सुबेदार काजे ज मालुम नी पड़्‌यो की संय वात काय छे। तेरेमां चु सुबेदार दीसरा सीपायड़ान मुखी काजे हुकुम आप्‌यु की “हीना काजे कीला मां ली जावु।” ");
INSERT INTO bhi_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","माणसेन गड़दी बेसकी हतली ने गड़दीम वाळा माणसे धकलावतेला तेरेमां कीलान फटक्‌यान चां जातात पोलुस काजे हाकलीन ली जाणु पड़्‌यो। ");
INSERT INTO bhi_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","काहाकी माणसेन गड़दी ज आयड़तात हेरे पछळ पड़ी रवला की, “हीनाक मार नाखु!” ");
INSERT INTO bhi_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","जत्‌यार सीपायड़ा पोलुस काजे कीला मां ली जाणे वाळा हतला, ती पोलुस सुबेदार काजे कह्‌यु, “काय मेसेक हुकुम छे काय मे तुसेक काय कहं?” सुबेदार पोलुस काजे जपाप आप्‌यु, “तुसे युनानी बुली आवड़े काय? ");
INSERT INTO bhi_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","काय तु चु मीसरी ते नी हय, चु थुड़ाक दाहड़ा पेहल लड़ाय करलु, ने चु च्‌यार हजार माणसे काजे बयड़ा मां ली गुयलु?” ");
INSERT INTO bhi_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पोलुस कह्‌यु, मे ते कीलक्‌यान तरसुस सहर मां रहण्‌यु यहुदी माणुस छे। चु तेरे सी लीलघाय्‌न कह्‌यु, “तु मेसेक हीनु गड़दीन माणसे साते वात करने दे।” ");
INSERT INTO bhi_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","जत्‌यार चु हुकुम आप्‌यु, “पोलुस फटक्‌या पर उबु रय्‌न हाते सी ईसारु कर्‌यु। जत्‌यार आखा माणसे हुगा रय गुया। ती चु ईब्‌रानी बुली मां ज कहणे बाजी गुयु: ");
INSERT INTO bhi_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ए भायस्‌यो ने आखा डाहला बास, मेसेक वाचाड़ने करीन मे जो काय तुंद्‌रे अगळ कय रयु च सामळु।” ");
INSERT INTO bhi_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","जत्‌यार माणसे पोलुस काजे ईब्‌रानी बुली मां बुलतेलु सामळीन अळी हुगा रय गुया। ती पोलुस तीनुक कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","मे ते एक यहुदी माणुस छे, ने मे कीलक्‌या तरसुस सहरेम पयदा हवलु। ने मे तरसुस मां मारा आसी-बास्‌या मेसेक पाळ्‌या-पुस्‌या ने मटु कर्‌या। ने तरसुस मांत गमलीयेल मास्‌तर मेसे काजे आपणा आड़ा-बुड़ान कायदा पुरान-पुरा सीकाड़्‌यु; ने मे भगवानेन कायदा पाळने मां तुंद्‌रेन तसुत हवस्‌यु ने उतवाळ्‌यु हतलु। जसा आज तुहुं आखा हवस्‌या ने उतवाळ्‌या छे। ");
INSERT INTO bhi_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","चे माणसे हीनी वाटेन अनसारे चाल रवला मे अदमीक ने बायरा काजे धरी-धरीन बांदीन जेल मां नाखी देदलु। ने बेसकु वेला पाड़्‌यु ने माराड़ी बी नाख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","मे ज बी कर्‌यु तीनी वातेन गवा आखा मंदीरेन डाहला पुजारा छे। पुजारा ने आखी बसकेन माणसे मारी ईनी वातेन गवा छे। मे माणसे काजे जेल बुजीन वेला पाड़ने, करीन मे भायस्‌योन नावे तींद्‌रे धड़े वेला पाड़नेन चिट्‌ठी लिखाड़ीन दमीस्‌क जाणे बाजी रवलु, की जे वां छे तीनुक बी सजा आपाड़ने करीन बांदीन यरुसलेम लावु। ");
INSERT INTO bhi_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","जत्‌यार मे चालतु-चालतु दमीस्‌क धड़े पुग्‌यु, ती असो हयो की मांजणीक दाहड़े सरगे सी उचकाणुन वीजाळो मारे चारेमेर चमक्‌यो। ");
INSERT INTO bhi_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ने मे भुयमां हीट पड़्‌यु, ने मेसेक एक बुल सामळायु, ए सावुल, ए सावुल, तु मेसेक काहा वेला पाड़े? ");
INSERT INTO bhi_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","मे जपाप आप्‌यु, “ए मालीक! तु कुण छे?” चु मेसेक कह्‌यु, “मे ईसु नासरी छे। तीनाक तु वेला पाड़े।” ");
INSERT INTO bhi_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","मारा साती वीजाळाक ते देख्‌या ने वात करन्‌यान बुल घुगवान तसा सामळ्‌या तेबी चे सामेळ्‌ळा ने तेबी चे बुल नी समज्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","तत्‌यार मे कह्‌यु, ए मालीक! मे काय करो? मालीक मेसेक कह्‌यु, उठीन दमीस्‌क जाती रव; ने ज काय तारे करने वाटे ठेहरावलो छे च आखो चां देखाड़ दीस। ");
INSERT INTO bhi_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","जत्‌यार च वीजाळो तेज हतलो ती मेसेक काय बी देखाय नी देदो, ती मारा सातीन हात धरीन दमीस्‌क मां आयु। ");
INSERT INTO bhi_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ने चां भगवानेन कायदाक पाळन्‌यु ईसुन एक भगत हतलु। तेरो नाव हनन्‌या हतलो। चु चां रहणे वाळा आखा यहुदी माणसे मां आव-भाव वाळु हतलु। हीयुत हनन्‌या नावेन मारेन्‌चां आवलु ");
INSERT INTO bhi_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ने चु मारे धड़े आयु ने मारे साते उबु हय्‌न कह्‌यु, “ए भाय सावुल! अळी पछु देखणे बाजी जां।” ने मे तत्‌यारुत देखणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","तत्‌यार चु कह्‌यु, हामरा डाह-डाहान भगवान तुसेक ठेहरावला छे की तु तेरी मरजी काजे जाणे, ने तीना धरमी काजे देखीन तेरी उजेंती वात सामळावे। ");
INSERT INTO bhi_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","काहाकी तु ज देखलु छे ने सामळ्‌ळु छे तीनी वातेन गवा रवसी। ");
INSERT INTO bhi_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","हय तु काहा वार लागाड़े, उठ ने बपतीस्‌मा ले ने तेरो नाव लीन तारा पाप काजे धुय दे। ");
INSERT INTO bhi_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","जत्‌यार मे पछु यरुसलेम मां आयु ने मंदीर मां भगवान सी दुवा करने बाजी रवलु, ती चुखला जीव-आत्‌मान कब्‌जा मां हय गुयु ने मेसेक काय बी मालुम नी रह्‌यो। ");
INSERT INTO bhi_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ने मे मालीक काजे देख्‌यु ने चु मेसेक ज कवणे बाजी रवलु, उतवाळ करीन यरुसलेम सी मामार बाहर नीकळी जां, काहाकी चे मारा बारामां तारी गवाय नी माने। ");
INSERT INTO bhi_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","मे मालीक काजे कह्‌यु, ए मालीक! कांखुर मायन हया सामळीन मान लेसे, काहाकी हीनुत ते मालुम छे की पेहेल मे तारे भुरसु करन्‌याक धरीन जेल मां कुंडतेला, ने जागे-जागे यहुदी माणसेन साहरे बणावला भक्‌तीन घर डीट तीनुक ठुकाड़तेलु। ");
INSERT INTO bhi_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ने जत्‌यार तारी गवाय देण्‌या स्‌तीफनुसेन लुही उहवतेलो ती तत्‌यार मे बी तीनी वातेम राजी हतलु ने चां लागु उबु हय रवलु। ने जे माणसे स्‌तीफनुस काजे मारने बाजी रवला तींद्‌रा पुथल्‌यान राखवाळी करने बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ने चु मेसेक कह्‌यु, तु जात रव, काहाकी मे तुसेक नी-यहुदी मां मारी गवा देणे करीन नांबे-नांबे मकलीस। ");
INSERT INTO bhi_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","माणसे पोलुसेन जी वात जां लग ते सामळता रया; तत्‌यार जुर सी आयड़्‌या, “हीनाक मार नाखु। हीना काजे धरती पर जादा दाहड़ा जीवतेलु रहणु वारु नी हय।” ");
INSERT INTO bhi_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","जत्‌यार चे आयड़ता जाय्‌न आपसा पुथल्‌या नीकाळीन उराटतेला, ने वाहळा मां धुळु उडाड़ तेला, ");
INSERT INTO bhi_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ती सीपायड़ान मेळान सुबेदार हुकुम आप्‌यु, “हीनाक कीला मां ली जावु, ने सपाटा दीन पारखु, तेरे सी जो मालम पड़से की माणसे हेरी वीरुद मां असा काहा आयड़ी रया।” ");
INSERT INTO bhi_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","बाकुन जत्‌यार चे चापकाटणे करीन तीनाक चामड़ान पट्‌टा सी बांदी रवला, ती पोलुस तेरे साते उबु हय रवला सुबेदार काजे पुछ्‌यु, “काय ज सय छे की तुहुं एक रोमी माणुस काजे, ने चु बीना गुना वाळा काजे सपाटा दी रया?” ");
INSERT INTO bhi_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ती सुबेदार ज सामळीन सीपायड़ान डाहला मुखी सुबेदार काजे धड़े जाय्‌न कह्‌यु, “तु असो काहा करने बाजी रयु? तुसेक मालुम नी हय काय की जु ते रोमी माणुस छे।” ");
INSERT INTO bhi_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ज सामळीन सीपायड़ान डाहलु मुखी सुबेदार पोलुस धड़े आवीन पुछ्‌यु, “मेसेक देखाड़, काय तु रोमी माणुस छे काय?” पोलुस कह्‌यु, “हव!” ");
INSERT INTO bhi_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ज सामळीन डाहलु मुखी सुबेदार कह्‌यु, “रोमी राजेम रहणेन हक हात करने करीन मेसेक बेसका पयस्‌या आपणु पड़्‌यो।” पोलुस कह्‌यु, “मे ते पयदा हयु ती सीत रोमी राजेम छे।” ");
INSERT INTO bhi_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ज सामळीन चे माणसे पोलुस काजे सपाटा दीन पारखणे हींडी रवला, चे तत्‌यारुत पोलुस धड़े सी पछा हय गुया; ने सीपायड़ान डाहलु मुखी सुबेदार बी असु जाण लेदु की जु रोमी माणुस छे ने हयु पोलुस काजे धरीन बांदाड़लु छे, करीन बीही गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","दीसरे दाहड़े सीपायड़ान डाहलु मुखी सुबेदार पोलुसेन हातकड़ी छुड़ देदु ने मंदीरेन डाहला पुजाराक ने आखी मट्‌ली बसक काजे भेळा करु करीन सीपायड़ाक हुकुम आप्‌यु। ने आखा भेळा हय गुया ने अळतेन चु पोलुस काजे तींद्‌रे धड़े नेचु ली जाय्‌न तींद्‌रे अगळ उबु कर देदु। काहाकी यहुदी माणसे हेरु वाक काहा नीकाळ रया जी वात चु मालम करने हींडी रवलु। ");
INSERT INTO bhi_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पोलुस यहुदी माणसेन मट्‌ली बसक भीणी एक हेट्‌यु भाळीन कह्‌यु, “ए मारा भायस्‌यो! मे आज लग भगवान अगळ वारलु मने जीवाय जीवलु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","पोलुसेन वात सामळीन हनान्‌यु मंदीरेन डाहला पुजारु हतलु तेर साते उबा हय रवला माणसे काजे हुकुम आपीन कह्‌यु, “पोलुसेन गाले थापड़ दे।” ");
INSERT INTO bhi_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","तत्‌यार पोलुस तीनाक कह्‌यु, “ए चुने करीन पुताय करला भीतड़ा! तु मुसान कायदान अनसारे मारु कसु नीयाव करने बस रयु, बाकुन मुसान कायदा तुड़े घुण ‘पोलुस काजे थापड़ दे’ करीन दीसराक कय रयु। तुसेक ते भगवान देसे।” ");
INSERT INTO bhi_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","जे साते उबा हय रवला माणसे पोलुस काजे कह्‌या, “तु भगवानेन मंदीरेन डाहला पुजारान असु वाक नीकाळीन जपाप काहा आप्‌यु?” ");
INSERT INTO bhi_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पोलुस कह्‌यु, “ए भायस्‌यो! मेसेक नी मालम हतलो, की जु भगवानेन मंदीरेन डाहलु पुजारु छे; काहाकी लिखलो छे की ‘जे माणसे पर राज करे, तीनुक खुटु बुल घुण कवता।’” ");
INSERT INTO bhi_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","अळतेन जत्‌यार पोलुस काजे मालुम पड़्‌यो की आदा माणसे सदुकी माणसे छे ने आदा माणसे फरीसी माणसे छे। ती चु मट्‌ली बसक अगळ आयड़ीन कह्‌यु, “ए मारा ईस्‌रायेली भायस्‌यो! मे फरीसी वाळु छे ने फरीसी माणसेन पुर्‌यु छे। असी आस करो की मर्‌या-सर्‌याम सी पछु जीवतु हवणेन बारामां मारु नीयाव हवणे बाजी रयु।” ");
INSERT INTO bhi_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","पोलुसेन जी वात सामळीन फरीसी माणसे ने सदुकी माणसेन वातेम लड़ाय हवणे लागी। ने बसक मां बीरजु पड़ गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","काहाकी सदुकी माणसेन असो कवणु छे की मर्‌या-सर्‌याम सी पछा जीवतु हवण्‌यु नी हय, ने सरग वाळा भगवानेन अघली वात बताड़ने वाळु बी नी हय। ने काहना बी चुखली-आत्‌मा नी हय। बाकुन फरीसी कवणु छे की मर्‌या-सर्‌याम सी जीवतु हवण्‌यु छे, ने सरग वाळु भगवानेन अघली वात बताड़ने वाळु बी छे ने चुखली-आत्‌मा बी छे। ");
INSERT INTO bhi_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","तत्‌यार चां बेसकु कचाटु हय रवलु। थुड़ाक यहुदी-धरम सीकाड़न्‌या मास्‌तर्‌या ने फरीसी माणसे उबा हय्‌न ज कवता जाय्‌न लड़ाय पड़्‌या, हामुक हीना माणुस मां काहनु बी खुट नी देखायतु। ने कदी कुय आत्‌मा नीते काहनु सरग वाळु काहवाळ्‌यु तीनाक कह्‌यु ती अळी काय? ");
INSERT INTO bhi_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","जत्‌यार बेसकी लड़ाय हय, ती सीपायड़ान मुखी सुबेदार बीही गुयु काहाकी तीनाक असो लाग्‌यो कांखुर मायन माणसे मारीन पोलुस काजे टुकड़ा-टुकड़ा नी कर देय। अळतेन चु सीपायड़ान टुळाक हुकुम आपीन कह्‌यु, उतारीन हीनाक जबरान हीनाक तींद्‌रे ईचमां सी नीकाळ लावु, ने कीला मां ली जाती रहु। ");
INSERT INTO bhi_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","तीनी राती मालीक पोलुस धड़े उबु हय्‌न कह्‌यु, “ए पोलुस, हिम्‌मत राख; काहाकी जसु तु यरुसलेम मां गवा देदलु छे, तसुत तुसेक रोम सहर मां जाय्‌न गवा देणु पड़से।” ");
INSERT INTO bhi_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","जत्‌यार दाहड़ु नीकळतात यहुदी माणसे पोलुस काजे मारने करीन जाळसांदी बणाया। चे जी सगुन खादा की “जत्‌यार लगुन हामु पोलुस काजे मारीन नाखजे नी चां लग हामु खाणो बी नी खाजे, ने पाणी बी नी पीजे।” ");
INSERT INTO bhi_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ईनी जाळसांदी मां चाळीस सी बी अदु अदमी हतला। ");
INSERT INTO bhi_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","चे मंदीरेन पुजारा ने पुडारी धड़े जाय्‌न तीनुक कह्‌या, “जत्‌यार लग हामु पोलुस काजे मारीन नाखजे नी चां लग हामु खाणो बी नी खाजे, ने पाणी बी नी पीजे। ");
INSERT INTO bhi_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","तेरेमां हय तुहुं जाय्‌न सीपायड़ान मुखी सुबेदार काजे समजाड़ु की चु तुंद्‌रे धड़े ली आवे, काहाकी मे हेरा बारामां वारु पारखणे हींड रयु। ने हामु तीना पोलुस काजे पुगणेन पेहलुत मारने करीन तीयार रवसुन।” ");
INSERT INTO bhi_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","बाकुन पोलुसेन बहणीसेन पुर्‌या काजे हीनी जाळसांदीन बारामां सामळ्‌यु, ती चु कीला मां जाय्‌न पोलुस काजे आखी वात देखाड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","पोलुस सीपायड़ान मुखी सुबेदार मायन एक सुबेदार काजे बुलावीन तीनाक कह्‌यु “हीना पुर्‌या काजे डाहला सुबेदार धड़े ली जावु; जु डाहला सुबेदारेक काहींग कवणे हींडे।” ");
INSERT INTO bhi_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","तेरेमां चु सुबेदार तीना पुर्‌या काजे डाहला सुबेदार धड़े ली जाय्‌न तीना डाहला सुबेदारेक कह्‌यु, “हातकड़ी लागाड़ी मेल्‌लु चु पोलुस मेसेक बुलावीन वीन्‌ती कर्‌यु की जु पुर्‌यु डाहला सुबेदार काजे काहींग कवणे हींडे; हीना काजे तेरे धड़े ली जां।” ");
INSERT INTO bhi_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","डाहलु सुबेदार तीना पुर्‌यान हात धरीन तीनाक अलग ली जाय्‌न पुछ्‌यु, “तु मेसेक काय कवणे हींडे?” ");
INSERT INTO bhi_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","चु पुर्‌यु कह्‌यु, “यहुदी माणसे एक्‌कु करीन जी जाळसांदी बणाय रया की आपणु डाहला सुबेदार काजे जाय्‌न असा वीन्‌ती करसुन की ‘तुहुं पोलुस काजे हामरे धड़े ली आव, काहाकी मे हीनाक वारु पारखणे हींडी रयु।’ ");
INSERT INTO bhi_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","बाकुन तु तींद्‌री वात घुण माने, काहाकी तींद्‌रेम चाळीस सी बी जादा अदमी पोलुस काजे मारने करीन तकाय रया। ने चे सगुन खादला छे की ‘जत्‌यार लगुन हामु पोलुस काजे मारी नी नाखजे नी चां लग हामु खाणो बी नी खाजे, ने पाणी बी नी पीजे।’ ने चे हींताळ तीयार छे, ने तारा वायदान वाट देख रया।” ");
INSERT INTO bhi_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","तत्‌यार तीना पुर्‌यान वात सामळीन डाहलु सुबेदार तीना पुर्‌या काजे हुकुम आपीन मकल्‌यु “तु जी वात कुय काजे घुण कवे की तु जी वात मेसेक कह्‌लु छे।” ");
INSERT INTO bhi_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","तत्‌यार सोव सीपायड़ान डाहलु सीपायड़ु तेरा दुय सीपायड़ाक बुलायन कह्‌यु, “केसर्‌या सहर मां जाणे करीन दुय सोव सीपायड़ा, ने सत्‌तर सीपायड़ा घुल्‌ला पर बसीन जाण्‌या, ने दुय सोव भाला वाळा सीपायड़ा तीयार हय जावु। ने रातेन नव बजे लग केसर्‌या जाणे करीन तीयार रवजु। ");
INSERT INTO bhi_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ने पोलुस काजे नीयाव करन्‌या फेलीक्‌स घुल्‌ला पर बठाड़ीन अलग ली जाणे करीन तेरे वाटे बी घुल्‌लु तीयार राख्‌जु।” ");
INSERT INTO bhi_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","सुबेदारेन डाहलु सुबेदार चिट्‌ठी मां ज्‌य बी लिखीन दी मकल्‌यु: ");
INSERT INTO bhi_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ए नीयाव करन्‌या फेलीक्‌स! वारलु छे की? मे कलद्‌यु लुस्‌यु छे। ");
INSERT INTO bhi_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","हीना अदमी काजे यहुदी माणसे धर लेदला ने हीनाक मारने हींडी रवला; बाकुन जत्‌यार मेसेक मालुम पड़्‌यो की जु रोमी छे, मे सीपायड़ा भेळु जाय्‌न हीना काजे छुड़ाय लायु। ");
INSERT INTO bhi_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","मे जाणतेलु की चे हेरे पर काहनु गुनु लागाड़ीन वाक नीकाळ रया; तेरेमां मे हीनाक तींद्‌री मट्‌ली बसक मां ली गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","तत्‌यार मे जाण लेदु की जे तींद्‌रा कायदान सास्‌तुरेन बारामां लिखली वात काजे लीन वातेम जखड़ी पड़ रवला ने तेरे पर गुनु लागाड़ीन वाक नीकाळ रवला, बाकुन हेरेम असु गुनु नी हय, तेरेसी हीनाक जेल मां बुजणु नी पड़े ने नी मारनु पड़े। ");
INSERT INTO bhi_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","जत्‌यार मेसेक बताड़्‌या की चे हीना माणुस काजे मारने हींडे ती मे तत्‌यारुत मे हीना काजे तारे धड़े मकली देदु। ने हेरे पर गुनु लागाड़न्‌या काजे हुकुम आप्‌यु की तुहुं जु बी गुनु हेरे पर नाख रया।” ");
INSERT INTO bhi_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","अतरामा सीपायड़ा जसों कह्‌या तसोत कर्‌या, ने चे रातेम रात पोलुस काजे अन्‌तीपातरीस पुगाड़ देदा। ");
INSERT INTO bhi_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","दीसरे दाहड़े चालीन जाण्‌या सीपायड़ा पछा यरुसलेम कीला मां आवती रया। ");
INSERT INTO bhi_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","चे केसर्‌या पुगीन ची चिट्‌ठी नीयाव करन्‌या काजे आप देदा, ने पोलुस तेरे अगळ उबा कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","चु नीयाव करन्‌यु चिट्‌ठी भणीन पोलुस काजे पुछ्‌यु, “तु काहना देस वाळु छे?” ने चु सीपायड़ु कह्‌यु, कीलक्‌या जीला वाळु छे, ");
INSERT INTO bhi_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ने चु जाण लेदु की जु कीलक्‌या वाळु छे ती चु कह्‌यु, “जत्‌यार तारे पर गुनु लागाड़न्‌या बी आवसे ती मे तारु नीयाव करीस।” ने चु सीपायड़ा काजे हुकुम आपीन कह्‌यु, “हीना काजे हेरोदेसेन कीला मां ली जाय्‌न पेहरु देवु।” ");
INSERT INTO bhi_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पांच दाहड़ा हय गुया ने पछेन मंदीरेन डाहलु पुजारु हनान्‌यु थुड़ाक पुडारी ने तेरतुल्‌लुस काजे पुठ्‌ये लीन केसर्‌या आयु। जु तेरतुल्‌लुस एक वकील हतलु। चे आखा नीयाव करन्‌या अगळ पोलुस पर गुनु लागाड़ीन तेरु वाक नीकाळ्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","जत्‌यार तीनाक बुलाया ती तेरतुल्‌लुस तेरे पर गुनु लागाड़ीन कवणे लाग्‌यु, “ए मटला फेलीक्‌स मालीक! हामु ते तु छे करीन वारु सुकना जीवणे बाजी रया, तु नांबे सी देखीन चाले तेरेमां आपणो आखो देस वारु सुदरी गुयलो छे ");
INSERT INTO bhi_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ए आखा सी वारु फेलीक्‌स! हामु तारे साहरे सुदारली वातेक हामु मांजे ने तुसेक वारु कह्‌जे। ");
INSERT INTO bhi_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","बाकुन तेरेमां की तुसेक अळी दुख नी देणे चाहतु चु तीनाक लीलघाय्‌न कह्‌यु, दया करीन तु हामरी दुय वात सामळी ले। ");
INSERT INTO bhi_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","काहाकी हामु हीना माणुस काजे भड़कावण्‌यु छे। जु आखी कळीन यहुदी माणसे मां लड़ाय कराड़न्‌यु छे, ने आपसा काजे नासरी टुळान मुख्‌यु कह्‌वे। ");
INSERT INTO bhi_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","जु यरुसलेम मंदीर काजे बी वीटाळनेन कुसीत करलु पर हामु हीना काजे धर पाड़्‌या। हामु मुसान कायदान अनसारे हेरु नीयाव करने हींडतेला। ");
INSERT INTO bhi_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","बाकुन डाहलु सुबेदार लुस्‌यु आवीन हीनाक जबरान हामरा हातेम सी हापकी लेदु। ");
INSERT INTO bhi_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ने असु करीन गुनु लागाड़न्‌या काजे बी चु हुकुम आपीन कह्‌यु की तुहुं हीनी आखी वातेन बारामां जु गुनु हामु हेरे पर लागाड़ रया। तीनी वातेक तु आपसुत पारखी लेसी।” ");
INSERT INTO bhi_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","जी वात सामळीन यहुदी माणसे बी हीनी वातेक हुकारीन कह्‌या, “हव, जी वात खरली छे।” ");
INSERT INTO bhi_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","जत्‌यार नीयाव करन्‌यु पोलुस काजे बुलनेन ईसारु कर्‌यु ती पोलुस असु जपाप आप्‌यु, मे जाणो की तु बेसका साल सी हीनी जातीन माणसेन नीयाव कर रयु, तेरेमां मे खुस हय्‌न तारी वातेन जपाप आपो। ");
INSERT INTO bhi_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","तुसेक ते ज मालुमुत छे की जत्‌यार मे यरुसलेम मां भगवानेन भक्‌ती-भजन करने आवलु, ती सीत हय लग बारे दाहड़ा बी नी हया। ");
INSERT INTO bhi_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ने चां कुय बी मेसेक मंदीर मां ने यहुदी माणसेन भक्‌तीन घर, मां ने सहर मां वातेम नाव-बद्‌दी ने माणसेक भेळा करीन भड़कावतेलु देख्‌या, ");
INSERT INTO bhi_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ने नीते जे तीनी वाते मां मारु वाक नीकाळीन गुनु लागाड़ रया, तीनी वातेक हय बी जे खरली ठेहराय नी सके। ");
INSERT INTO bhi_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","बाकुन मे तारे अगळ जी वात मान लम की दीना पंथ काजे जे रद्‌दी-पंथ कह्‌वे। तीना पंथन साहरे मे तीना भगवानेन सेवा-भक्‌ती करो तीना भगवानेन वाट काजे आपणा डाहा-बुड़ा मान्‌ता आय रया, ने तेरी सेवा-भक्‌ती करता आय रया। ने जी वात मुसान साहरे लिखला सास्‌तुर मां ने भगवानेन अघली वात बताड़ने वाळा माणसेन किताप मां बी लिखली छे, तीनी आखी वात पर मे भुरसु करो। ");
INSERT INTO bhi_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ने जसा चे भगवान मां करे तसुत मे बी भगवान मां आसा करो की भगवान धरमी माणसे काजे ने पापी माणसे काजे मर्‌या-सर्‌याम सी जीवतु करीन बठु करसे। ");
INSERT INTO bhi_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","तेरेमां मे बी भगवान ने माणसे अगळ मारा चुखला मन सी ज छाचली छे, चत करनेन कुसीस करो। ");
INSERT INTO bhi_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","बेसका सालेन पछे मे मारा माणसे काजे दान आपणे, ने भेट चड़ावने आवलु। ");
INSERT INTO bhi_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ने चे मेसेक मंदीर मां जनवार्‌या मारीन बादा चड़ावतेलु ने भेट आपतेलु देख लेदला। मे जो काम चुखले मने दीसरा माणसेक बुलावीन गड़दी करे बीगुर करने बाजी रवलु। तीने टेमे मारे पुठ्‌ये आसीया वाळा बेसका यहुदी बी हतला; ने तीनुक जो काम वारु; लाग्‌यो। ");
INSERT INTO bhi_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","दंगु कराड़न्‌या ते चे, आसीया जीला वाळा यहुदी माणसे हतला। कदी तीनुक मारा वीरुद मां काय कवणु हतलो, ती जे यहुदी जां अगळ आवीन मारे पर गुनु लागाड़ता। तेबी चे जां नी आया। ");
INSERT INTO bhi_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","नीते जे माणसे जां छे हीनुत काजे कवणे दे की जत्‌यार मे मट्‌ली बसक मां हतलु, ती जे मारे मां काय गुनु देखला? ");
INSERT INTO bhi_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","हीनी वात काजे छुड़ मे तींद्‌रे ईचमां उबु रवीन आयड़ीन कवलु की मर्‌या-सर्‌याम सी पछा जीवता हवणेन बारामां तारे अगळ आज मारु नीयाव हवणे बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","फेलीक्‌स तीनी वाटेन बारामां वारु वात जाणतेलु, चु ज कह्‌वीन तींद्‌री सुणवाय टाळ देदु, “जत्‌यार डाहलु सुबेदार लुस्‌यु आवसे, ती तुंद्‌री वात सामळीस ने तुंद्‌रु फेसलु करीस।” ");
INSERT INTO bhi_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ने सुबेदार काजे हुकुम आप्‌यु की तु पोलुसेन जेलेन वारु राखवाळी करजी, ने तेरा दुस्‌तीदार आवे ती तेरी सेवा-चाकरी करने घुण रुके। ");
INSERT INTO bhi_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","थुड़ाक दाहड़ा मां अळतेन फेलीक्‌स हेरी घरवाळी द्‌रुसीला पुठ्‌ये चां आयु। फेलीक्‌सेन घरवाळी यहुदी जातीन हतली। फेलीक्‌सी पोलुस काजे बुलावीन तीना भुरसान बारामां ज मसी ईसु पर छे, तेरेसी सामळ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","बाकुन जत्‌यार पोलुस नीयावेन बारामां, ने हेरा जीवेक मानाड़नेन बारामां, ने आवणे वाळा नीयावेन बारामां वात करतेला। ती फेलीक्‌स सामळीन बेसकु बीही गुयु ने पोलुस काजे कह्‌यु “हय तु जात रव, टेम जड़से ती तारी वात सामळने तुसेक अळी बुलावीस।” ");
INSERT INTO bhi_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","हीनीत टेमे फेलीक्‌स जी आस कर रवलु की पोलुस मेसेक रुप्‌या आपसे। करीन चु पोलुस काजे अळी-अळीन तेरी वात सामळावणे करीन बुलाया करतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","बाकुन जत्‌यार दुय साल हय गुया ती पुरकीयुस फेस्‌तुस, फेलीक्‌सेन जागा पर आयु; ने फेलीक्‌स यहुदी माणसे पर दया करनेन मरजी सी पोलुस काजे जेल मात रहणी देदु। ");
INSERT INTO bhi_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","फेस्‌तुस चु तीन दाहड़ा हय गुया ने अळतेन केसर्‌या सी यरुसलेम मां पुग्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","तत्‌यार मंदीरेन डाहला पुजारी ने यहुदी माणसेन नेता आवीन पोलुस पर गुनु लागाड़ीन तेरु वाक नीकाळ्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ने चे माणसे फेस्‌तुस काजे दया मां हयन कह्‌या की तु पोलुस काजे यरुसलेम बुलाय ले। काहाकी चे वाट्‌येत पोलुस काजे मारनेन जाळसांदी बणाय रवला। ");
INSERT INTO bhi_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","फेस्‌तुस जपाप आप्‌यु, “पोलुस केसर्‌या सहरेन जेलेम छे। ने सीपायड़ा तेरु पेहरु दीन राखवाळी कर रया। ने मे छाटुस पछु जायस। ");
INSERT INTO bhi_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","पछेन कह्‌यु, तुहुं तुंद्‌रा मुख्‌या काजे मारे पुठ्‌ये केसर्‌या मकली देवु ने कदी चु माणुस काहींग गुनु कर्‌यु हसे, ती चे चां तेर पर गुनु लागाड़ीन वाक नीकाळे।” ");
INSERT INTO bhi_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","फेस्‌तुस अळी तींद्‌रे ईचमां आठ-दस दाहड़ा रहणीदीन पछु केसर्‌या गुयु। ने तेरे पुठ्‌ये सात यहुदी हकदार्‌या बी गुया। दीसरे दाहड़े फेस्‌तुस नीयावेन गादी पर बसीन सीपायड़ाक हुकुम आप्‌यु की, “पोलुस काजे बुलाय लावु।” ");
INSERT INTO bhi_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","जत्‌यार पोलुस आयु, ती यरुसलेम सी आवला यहुदी हकदार्‌या, तेरे चारेमेर उबा हय्‌न तेरे पर बेसका गुनु लागाड़ीन वाक नीकाळ्‌या। ने तीना गुनान पुरावु चे दी नी सक्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","बाकुन पोलुस जपाप आप्‌यु, “मे यहुदी कायदान बी वाक नी नीकाळ्‌यु, ने मंदीरेन बी वाक नी नीकाळ्‌यु, ने मटला राजान बी वाक नी नीकाळ्‌यु। असु करीन मे काय बी गुनु नी कर्‌यु।” ");
INSERT INTO bhi_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","बाकुन फेस्‌तुस यहुदी माणसे पर गीण-दया करने करीन पोलुस काजे कह्‌यु, “तु यरुसलेम जाणे तीयार छे काय, ने चां मारे अगळ ईनी वातेन बारामां तारो नीयाव करो?” ");
INSERT INTO bhi_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","पोलुस कह्‌यु, मे केसरेन नीयावेन गादी अगळ उबु हय रयु, मारु नीयाव जात हवणु चाहजे। जसों तुसेक बी वारु रीती सी मालुम छे की मे यहुदी माणसेन वाक नी नीकाळ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","कदी मे गुनाळु हय, ने मरनेन डंड जड़े असु गुनु कर्‌यु हय, ती मे मरने तीयार छे; बाकुन कदी तीनी वातेम जे मारे पर गुनु लागाड़ रया, ची वात खरली नी हय ती, कुय बी मेसेक तींद्‌रे सुपरुत नी कर सके। मे मटला राजा अगळ नीयाव धड़े उबु हवणेन वीन्‌ती करो। ");
INSERT INTO bhi_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","तत्‌यार फेस्‌तुस बसकेन मंत्‌री धड़े वीच्‌यार नीकाळीन जपाप आप्‌यु, “तु मटला राजा अगळ नीयाव धड़े उबु हवणेन वीन्‌ती करलु छे, तु केसर धड़े जासी।” ");
INSERT INTO bhi_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","थुड़ाक दाहड़ा हय गुया ने अळतेन धड़ेवाळा ईलाकान राजा अग्‌रीपा, तेरी बहणीस बेरनीस पुठ्‌ये यहुदा जीलान नवला राजा फेस्‌तुसेक वारु छे की? पुछणे ने आव-भाव करने करीन केसर्‌या आया। ");
INSERT INTO bhi_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","चे बेसका दाहड़ा रय लेदा ने अळतेन फेस्‌तुस पोलुसेन बारामां राजा काजे ज कह्‌यु “एक माणुस छे, तीनाक फेलीक्‌स जेल मां छुड़ गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","जत्‌यार मे यरुसलेम मां हतलु, ती मंदीरेन पुजारी ने यहुदी माणसेन पुडारी तेरे पर गुनु लागाड़्‌या; ने कह्‌या की हीनाक डंड आप। ");
INSERT INTO bhi_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","बाकुन मे तीनुक जपाप आप्‌यु, रोमी माणसेन जी रीती नी हय की गुनु लागाड़न्‌याक ने गुनु करन्‌याक आंबा-सांबा उबा करीन तींद्‌री आंबी-सांबी सुणवाय करे बीगुर गुनु करन्‌या काजे डंड आप देय। ");
INSERT INTO bhi_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","जत्‌यार चे जां भेळा हया, ती जादा वार नी लागाड़्‌यु, बाकुन दीसरे दाहड़े नीयावेन गादी पर बस गुयु, ने सीपायड़ाक कह्‌यु, ‘तीना माणसेक लावणेन हुकुम आप्‌यु।’ ");
INSERT INTO bhi_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","जत्‌यार गुनु लागाड़न्‌या उबा हय्‌न तेरे पर गुनु लागाड़्‌या, ती चे, मे समजी रवलु असु काहनु बी गुनु तेरे पर नी लागाड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","बाकुन चे तींद्‌रा भुरसान धरमेन बारामां ने ईसु नावेन माणसेन बारामां चु मर गुयलु ने पोलुस तीना काजे जीवतु छे करीन बताड़लु, ने वातेन जखड़ी मां पड़ रवला। ");
INSERT INTO bhi_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","मे चक्‌कर मां पड़ रवलु की ईनी वातेन पतु कसु लागड़ो? तेरेमां मे तीनाक पुछ्‌यु, काय तु यरुसलेम जासी काय, ईनी वातेन तारु नीयाव हवसे? ");
INSERT INTO bhi_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","बाकुन पोलुस कह्‌यु, की ‘मे मटला राजा अगळ नीयाव उबु हवणेन वीन्‌ती करो।’ ती मे सीपायड़ाक हुकुम आप्‌यु की जत्‌यार लग मे ईनाक केसर धड़े नी मकलो, ती लग तुहुं जलम हेरी राखवाळी करु।” ");
INSERT INTO bhi_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","तत्‌यार अग्‌रीपा, फेस्‌तुस काजे कह्‌यु, “मे बी तीना माणसेन वात सामळने हींडो।” ती फेस्‌तुस कह्‌यु, “तु काल हेरी वात सामळी लेजी।” ");
INSERT INTO bhi_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","दीसरे दाहड़े राजु अग्‌रीपा ने तेरी बहणीस बेरनीस सी धुम-धाम सी हेरा सीपायड़ा सुबेदार्‌या भेळा ने सहरेन मटला माणसे बसक भेळे चां आय लाग्‌यु। तीने टेमे फेस्‌तुस सीपायड़ाक हुकुम आप्‌यु, “पोलुस काजे जां ली आवु।” ");
INSERT INTO bhi_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","फेस्‌तुस कह्‌यु, “ए राजा अग्‌रीपा, ने आखा माणसे, जे जां आय र्‌या चे। तुहुं ईना माणसेक देख रया, तेरे बारामां आखा यहुदी माणसे यरुसलेम सहर मां ने जां बी आयड़ी-आयड़ीन मारे धड़े लीलघाय्‌न कह्‌या, ‘ईनाक मार नाखु। ईना काजे धरती पर जादा दाहड़ा जीवतेलु रहणु वारु नी हय।’ ");
INSERT INTO bhi_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","बाकुन मे पारखी लेदु की चु मरनेन डंड जड़े असु काहनु बी गुनु नी कर्‌यु; तेबी चु आपसुत असु वीन्‌ती कर्‌यु की ‘मे मटला राजा अगळ नीयाव वाटे उबु हवणु छे।’ ती मे ईनाक मटला राजा धड़े मकलेन तज्‌बु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","बाकुन मे हेरे बारामां लिखीन दी मकेलने मारे धड़े काय बी पुरावु नी जड़्‌यु। अतरामा मे तीना काजे तारे अगळ ने खास करीन ए राजा अग्‌रीपा तारे अगळ लावलु छे। हेरेन करीन की लिखणे करीन काय ने काय पुरावु जड़े। ");
INSERT INTO bhi_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","मारु वीच्‌यार छे की तीनाक माणसे गुनाळु समजीन धरीन हात कड़ी लागाड़ला छे, तेरे बारामां जु छाचलीन गुनाळु छे, असु करीन चिट्‌ठी लिखे बीगुर मटला राजा धड़े मकेलनु वारु नी हय।” ");
INSERT INTO bhi_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","अग्‌रीपा राजु पोलुस काजे कह्‌यु, “तुसेक खुद तारे बारामां कह्‌णेन हक छे।” तत्‌यार पोलुस आपसुत बचणे करीन आपसे भीणी असु कह्‌णे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ए राजा अग्‌रीपा, जतरी वातेन यहुदी माणसे मारे पर गुनु लागाड़े। तीनी वातेन आज तार अगळ जपाप आपणे मां मे वारु समजो। ");
INSERT INTO bhi_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","खास करीन जी वात अतरी खरली छे, काहाकी तु यहुदी माणसेन आखी रीती-भाती ने तींद्‌री वात काजे जाणो। अतरामा चु लीलघाय्‌न कह्‌यु की तु गम खाय्‌न मारी वात सामळ। ");
INSERT INTO bhi_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","मे नानलु हतलु ती सीत मारा भाय-बेटा मां ने यरुसलेम मां कसु जीव्‌यु, ची वात देस वाळा ने यरुसलेम वाळा आखा यहुदी जाणे। ");
INSERT INTO bhi_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","कदी चे ईनी वातेन गवाय देणे हींडे ती गवाय दी सके, काहाकी मे हामरा धरमेन अनसारे एक हामरा काठला फरीसी माणसेन अनसारे जीवाय जीवलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","भगवान हामरा डाहा-डाहा साते मर्‌या-सर्‌याम सी पछा जीवता करनेन जु वायदु करलु छे, ने चु वायदु भगवान पुरु करसे असु मे आस करो ने तीनात वायदान वाटे मारु नीयाव हवणे बाजी रयु। ");
INSERT INTO bhi_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","हामरी बारे कळीन माणसे मर्‌या-सर्‌याम सी पछा जीन्‌दा हवणे जी आस कर रया, तीनीत आसे वाटे भगवानेन रात दाहड़ु सेवा-भक्‌ती कर रया। ए राजा। हीनुक मर्‌या-सर्‌याम सी पछा जीन्‌दा हवणेन आसेन बारामां यहुदी माणसे मारे पर गुनु लागाड़ रया। ");
INSERT INTO bhi_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","जत्‌यार की भगवान मर्‌या-सर्‌या माणसे काजे जीन्‌दा करे। असी वात मे कहं ती तुहुं काजे ईनी वात पर भुरसु काहा नी आवतु? ");
INSERT INTO bhi_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","मे बी समजतेलु की ईसु नासरी नावेन वीरुद मां मेसेक बेसको काय करनु चाहो। ");
INSERT INTO bhi_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ने मे यरुसलेम मां बी ईसुन माणसेन वीरुद कर्‌यु; ने मंदीरेन डाहला पुजारा जाय्‌न ईसुन माणसेक वेला पाड़नेन हक मांग लेदु ने बेसका ईसुन चुखला माणसेक जेल मां कुंड देदु। तत्‌यार दीसरा तींद्‌री वीरुद करीन तीनुक मारतेला ती मे बी तींद्‌री वातेक हुकारतेलु। ");
INSERT INTO bhi_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ने मे तीनु आखा काजे तींद्‌रा यहुदी माणसेन भक्‌तीन घर मां वेला पाड़तेलु ने तीनुक जुर करीन कह्‌वतेलु की तुहुं ईसुन वाक नीकाळु, नीते मार नाखीस। ने मे तींद्‌रे पर अतरु रीसवाय गुयु की दीसरा सहरेम रहण्‌या ईसुन माणसे काजे बी वेला पाड़ने बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ईसु पर भुरसु करन्‌या माणसेक मारनेन धुन मां मे मंदीरेन डाहला पुजारा धड़े हकेन चिट्‌ठी लीन मे दमीस्‌क जाणे बाजी रवलु। ");
INSERT INTO bhi_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ए राजा, मे दीसु माथेक दाहड़े, दाहड़ा सी बी जादा जुरे वीजाळो बी धपीन सरगे सी आवतेलो देख्‌यु, जो मेसेक ने मारा साती काजे घेर लेदलो। ");
INSERT INTO bhi_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","हामु आखा भुयमां हीट पड़्‌या ती मेसेक ईब्‌रानी बुली मां एक बुल सामळायु, “ए सावुल ए सावुल तु मेसेक काहा वेला पाड़े? तारे वाटे कुरहाड़ पर लात देणु काठो छे।” ");
INSERT INTO bhi_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ने मे कह्‌यु, “मालीक! तु कुण छे?” मालीक कह्‌यु, “मे ईसु छे, तीनाक तु वेला पाड़े। ");
INSERT INTO bhi_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","बाकुन हय तु उबु उठ जां; तारा पाय पर उबु हव; काहाकी मे तुसेक जसु देखलु च आखो माणसेक कवणे करीन मारु पावर्‌यु ने गवा बणावीन ठेहरावलु छे, ने अळी आवणे वाळी वात देखाड़ने करीन तुसेक देखाड़ीस। ");
INSERT INTO bhi_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","मे तुसेक तारा माणसे सी ने नी-यहुदी माणसे सी बचाड़ीन राखीस, तींद्‌रे धड़े मे तुसेक तेरेमां मकलो। ");
INSERT INTO bhi_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","तु हींद्‌रा जीवेन डुळा उघाड़जी। ने तीनुक जीवेन आंदारला मां सी जीवेन वीजाळा भीणी वाळजी। ने भुतड़ान हक मां सी छुड़ावीन भगवानेन हक मां लावजी; ने असा करीन चे पापेन माफी हात करीन ईसु पर भुरसु करन्‌या चुखला माणसे मां भेसकाय जासे।” ");
INSERT INTO bhi_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“ए राजा अग्‌रीपा! ती सी आज लग मे तीनी सरगेम सी आवली वातेक कदी नी टाळ्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","बाकुन मे पेहले दमीस्‌कुसेन, यरुसलेमेन, ने तत्‌यार यहुदी आखा देसेन रहणे वाळा ने नी-यहुदी माणसेक ज समजाड़तु रयु, की तुहुं पाप भीणी सी मन फेरवीन भगवान भीणी वळु ने भगवान काजे गमे तसों काम करु।” ");
INSERT INTO bhi_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ईनी वातेन वाटे यहुदी माणसे मेसे काजे मंदीर मां धर लेदा, ने मारीन नाख देणेन कुसीत कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","बाकुन भगवानेन मदत सी आज लग मर्‌यु नी ने नानला मटला आखा अगळ गवा दम। ने तीनीत वातेक कहतु रयु जी वात भगवानेन अघली वात बताड़ने वाळा माणुस ने मुसु कहलु की हवणे वाळी छे। ");
INSERT INTO bhi_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","की ईसु मसी काजे दुख झेलनु पड़से ने चु आखा मरला मां सी पेहेल जीवतु हय्‌न आपणा माणसेक ने नी-यहुदी माणसेक जीवनेन वीजाळान खुस-खबर सामळावसे। ");
INSERT INTO bhi_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","जत्‌यार पोलुस हीनी रीती सी जपाप दी रवलु, ती फेस्‌तुस जुर सी आयड़ीन कह्‌यु, “पोलुस, तु संकाय गुयलु छे! ने तु जादा भणीन गांडु हय गुयु।” ");
INSERT INTO bhi_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","बाकुन पोलुस कह्‌यु, “ए ओबरादार फेस्‌तुस! गांडु नी हय, बाकुन सय ने अक्‌कल वाळी वात कहं। ");
INSERT INTO bhi_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ने तीनी वातेक मे बीहे बीगुर राजा अगळ कहणे बाजी रयु, तीनी वातेक राजु जाणे। ने मेसेक भुरसु छे हीनी वात मां सी कुय वात सातायली नी हय, काहाकी ईसु साते जो काय हयो च कांखुर धरतीन खुणे-कुपरे नी हयो। ");
INSERT INTO bhi_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ए राजा अग्‌रीपा, तु भगवानेन अघली वात बताड़ने वाळा माणसेन कहली वात पर भुरसु करे काय? हव, मेसेक मालुम छे की तु भुरसु करे!” ");
INSERT INTO bhi_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","हेरेसी अग्‌रीपा पोलुस काजे कह्‌यु, “तु कम समजणे सी मेसेक मसी बणावणे हींडे।” ");
INSERT INTO bhi_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पोलुस कह्‌यु, “मे भगवान सी दुवा करो की भले ईतरीक वात सामळावीन ने भले जादा वात सामळावीन, तु अतरुत नी बाकुन जतरा बी मारी वात सामळी रया, चे आखा मारेन तसा ईसु पर भुरसु करन्‌या बण जाणो चाहे। बस, तीनुक मारेन तसा हात कड़्‌या अतरा नी लागणु चाहजे।” ");
INSERT INTO bhi_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","तत्‌यार राजा अग्‌रीपा ने राजा अग्‌रीपान बहणीस बेरनीस ने तेरे धड़े बस रवला आखा उबा हय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ने अलग जाय्‌न आपसात कहणे लाग्‌या, जु माणुस जेलेम जाय असु ने मरनेन डंड जड़े असु काहनु बी गुनु नी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","अग्‌रीपा फेस्‌तुस काजे कह्‌यु, “कदी तु असु नी कवतु की ‘केसर राजा अगळ मारु नीयाव हवणु चाहजे’ ती जे तुसेक जेल मां सी बरी कर देदा।” ");
INSERT INTO bhi_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","जत्‌यार ज पक्‌को हय गुयो की हामु ढंड्‌याम बसीन ईटली देसेम जाजे। ती चु ने पोलुस ने ईतराक दीसरा केदी काजे तीना सीपायड़ान टुळान हातेम कर देदु, तीना टुळान डाहलु सुबेदार जुलीयुस नावेन हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","अतरामा हामु काजे आसीया ईलाकान दर्‌या धड़े जाणे वाळा एक, ढंड्‌याम बसीन हामु चाल पड़्‌या। ने मकीदुनीया ईलाकान थीसलुनीकीया सहर वाळु अरीस्‌तारकुस बी हामरे पुठ्‌ये हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","दीसरे दाहड़े हामु सीदोन सहर मां पुग्‌या ने चां ढंड्‌यान ठेसण पर मटलो ढंड्‌यो हुबो राक देदा। सुबेदार जुलीयुस पोलुस पर दया कर्‌यु ने पोलुस काजे तेरा दुस्‌तीदारेन्‌चां भेळु हवणे करीन जाणे देदु। ने तेरा दुस्‌तीदारेक बी पोलुसेन सेवा-चाकरी करनेन छुट आप देदा। ");
INSERT INTO bhi_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","चां सी आहळी हामरे सांबी आवतेली; करीन कुपरुस नावेन काळापाणी धड़े-धड़े तेरु आड़ लीन ढंड्‌यो चालाड़ीन ली जातला; ");
INSERT INTO bhi_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ने कीलक्‌या ने पंफुलीया ईलाका धड़े समुदर मायन जातला ने लुस्‌या ईलाकान मुरा नावेन सहर मां उतर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","चां एक सुबेदार काजे एक दीसरो मटलो ढंड्‌यो देखाव पड़्‌यो। च सीकेन्‌दर्‌या सहर सी आवीन ईटली ईलाका मां जाणे वाळो हतलो। हेरेसी चु हामुक तीना ढंड्‌या मां बठाड़ देदु। ");
INSERT INTO bhi_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","जत्‌यार हामु बेसका दाहड़ा लग धीरा-धीरा चालीन वेला करता जाय्‌न कनीदुस सहर धड़े अगा पुग्‌या। काहाकी हवा हामु काजे अघो जाणे नी देदो; अतरामा हामु केरती नावेन काळापाणीन आड़ लीन सलमोन सहर धड़े पुग्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ने चां मायन बेसका एला करता जाय्‌न एक सहरेम पुग्‌या, तीना सहरेन नाव हतलो ढंड्‌या उबा करनेन वारु ठेसण। चां सी लसया सहर धड़ेत हतलो। ");
INSERT INTO bhi_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","टेम बेसकी हय गुयली ने तीना ढंड्‌या काजे बी अगा ली जाणु बी परेसानी हतलो काहाकी तत्‌यार लग उपासेन दाहड़ा बी हय गुयला। तेरेसी पोलुस तीनु माणसे काजे ज कह्‌तु जाय्‌न चेताड़्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“ए अबरेदार माणसे! मेसेक असो लागे की जां सी आपणु जासु, ती आपणे पर आफत आय पड़से ने बेसको नुकसाण झेलनु पड़से। ने मटलो ढंड्‌यो चालाड़न्‌या पर ने मटलो ढंड्‌यो बी टुट जासे। ने कांखुर मायन आपणुक मरनु बी पड़से।” ");
INSERT INTO bhi_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","बाकुन सुबेदार पोलुसेन वातेक छुड़ीन मटलो ढंड्‌यो चालाड़न्‌या पर ने मटला ढंड्‌यान मालीकेन वात काजे बड़ीन मान्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","चां सींगेन दाहड़ा काटणे वाटे वारु नी हतलो तेरेमां बेसका माणसे वीच्‌यार करीन कह्‌या, “आपणुक जां सी जतरा छाटा जावाये ततरा छाटा जां सी जाती रवसुन, ने ईना देसेन काहनी बी रीती सी फीनीक्‌स सहर मां पुगीन चां सींग काटसुन ती बेसको वारु रवसे।” ज एक केरते टापुन एक ठेसण छे जो ढंड्‌यान ठेसणे भीणी जो दखण-बुडण ने धुराव-बुडण भीणी उगाड़ो छे। ");
INSERT INTO bhi_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","जत्‌यार ईतरी-ईतरीक दखण सी आहळी आवणे बाजी गुय, ती चे ज समज्‌या, की जसा चे चाही रवला, तसों तीनुक जड़ गुयो, ती चे ढंड्‌यान-मांजरी पाणीम सी नीकाळ लेदा ने केरतीन काळापाणी भीणी चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","बाकुन थुड़ीक वार मां काळापाणी भीणी सी एक मट्‌ली आंधी आवी, ची धुराव उगण कह्‌वाये। ");
INSERT INTO bhi_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जत्‌यार आंधी ढंड्‌ये आपटाय, ती ढंड्‌या काजे आंधी भीणी सांबो नी जावायो, ती हामु ढंड्‌या काजे आंधी तींखुर जाय, तींखुर जाणे देदा। ");
INSERT INTO bhi_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","तत्‌यार हामु कोदा नावेन काळापाणीन आड़ मां धीरा-धीरा ढंड्‌या काजे उहवणी देदा, ने काठी मेहनत करीन दीसरा नानला ढंड्‌या काजे हात करीन तीनुक कब्‌जा मां करीन धीरा पाड़्‌या ने मटला ढंड्‌या मां मेल लेदा। ");
INSERT INTO bhi_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ढंड्‌या काजे नाड़े करीन बांद देदा, ने बीहाणे सी कहें की कांखुर मायन सुरतीसेन काळापाणी धड़े उतेळ्‌ळा पाणीन कादवड़ा मां मटलो ढंड्‌यो गाड़ाय जासे करीन मटला ढंड्‌यान पाल छुड़ देदा, ने मटला ढंड्‌या काजे उहवणी देदा। ");
INSERT INTO bhi_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","जत्‌यार हामु आंधी ने झलक मटले ढंड्‌ये बेसकी आपटाय। ती दीसरे दाहड़े चे ढंड्‌याम सी समान नाखणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ने तीसरे दाहड़े चे तींद्‌रे हाते सी ढंड्‌या मायन समान नाखी देदा। ");
INSERT INTO bhi_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","जत्‌यार बेसका दाहड़ा लग, नीते दाहड़ु देखाव पड़्‌यु, ने नीते तारा देखाव पड़्‌या, ने बेसकी आंधी चालतीत रय, ने असी हालत हय गुय की हामु बचणेन आसुत छुड़ देदा। ");
INSERT INTO bhi_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","जत्‌यार चे बेसका दाहड़ा लग काय नी खादा, तत्‌यार पोलुस तींद्‌रे ईचमां उबु हय्‌न कह्‌यु, ए माणसे, तुहुं काजे मारी वात मानीन केरती नावेन काळापाणी सी आवता ती नीते तुंद्‌री जी परेसानी आवती ने नी जी नुकसाण आवती। ");
INSERT INTO bhi_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","बाकुन हय मे तुहुं काजे समजाड़ो की हिम्‌मत राखु, काहाकी तुंद्‌रे मायन कुय नी मरे, बाकुन ढंड्‌यान अतरोत खत्‌तम हवसे। ");
INSERT INTO bhi_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","काहाकी तीना भगवान पुठ्‌ये मे जुड़ायलु छे, ने तेरी मे सेवा-चाकरी करो, तेरु एक सरग वाळु काहवाळ्‌यु आज राते मारे धड़े आवीन कह्‌यु, ");
INSERT INTO bhi_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ए पोलुस, बीहे मां! तुसेक केसर राजा अगळ उभो हवणु ने हवणु छे। ने देख, जे तारे पुठ्‌ये ढंड्‌या मां छे, तीनु आखा काजे भगवान तारा हातेम आप देदलु छे। ");
INSERT INTO bhi_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","तेरेमां, ए माणसे, हिम्‌मत राखु; काहाकी मे भगवान पर जु भुरसु करो, जसों मार सी कह्‌यु, तसोन तसों हवसे। ");
INSERT INTO bhi_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","बाकुन आपणु ढंड्‌यो काहनास काळापाणी धड़े कादवड़ा मां उतेळ्‌ळा जागा मां जाय्‌न गाड़ाय जासे। ");
INSERT INTO bhi_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","जत्‌यार चोवदहवी रात हय, ती हामु अंदर्‌या नावेन समुदर मां भटकायता फीर रवला। ती आधीक रातेन धड़े-वड़े ढंड्‌यो चालाड़न्‌या काजे मालुम पड़्‌यो की हामु काहनास जागा धड़ेत जाय वागला छे। ");
INSERT INTO bhi_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ने चे दुयड़ो नाखीन समुदर मां उंडो देख्‌या ती मालुम पड़्‌यो की समुदरेन उंडाण वीस पुरसाव छे। ने अळी थुड़ाक धड़े गुया ती मालुम पड़्‌यो की समुदरेन उंडाण पंद्‌रे पुरसाव छे। ");
INSERT INTO bhi_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","जत्‌यार दगड़ा वाळी जागा मां हामरो मटलो ढंड्‌यो अटकी जासे करीन चे बीही गुया ने चे मटला ढंड्‌यान पछला हीस्‌सा भीणी सी ढंड्‌यो उभो राखणे करीन च्‌यार मांजरी नाख्‌या, ने वीजाळो हवणेन वाट देख तेला। ");
INSERT INTO bhi_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","बाकुन जत्‌यार ढंड्‌यो चालाड़न्‌या ढंड्‌याम सी ढासणे हींडी रवला, ती चे ढंड्‌यान अगला हीस्‌सा भीणी बी ढंड्‌यो उभो राखणे करीन मांजरी नाखणे हींडी रया असो बाहनो बणावीन दर्‌या मां बचणे करीन नानला ढंड्‌या बी समुदर मां उतार देदा। ");
INSERT INTO bhi_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ती पोलुस सुबेदार ने सीपायड़ा काजे कह्‌यु, “कदी जे मटलो ढंड्‌यो चालाड़न्‌या मटला ढंड्‌या मां नी रहे ती तुहुं बी नी बचु।” ");
INSERT INTO bhi_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ती सीपायड़ा दुयड़ा काटीन नानला ढंड्‌या काजे बचणे करीन मटला ढंड्‌याम सी समुदर मां उतार देदा। ");
INSERT INTO bhi_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","जत्‌यार वीजाळो हवणे वाळो हतलो, तत्‌यार पोलुस आखा काजे जो कहीन समजाड़्‌यु की “बचणेन आस करीन वाट देखता-देखता चोवदे दाहड़ा हय गुया ने तुहुं भुकलात रया, ने ईतरोक बी खाणो नी खादा; ");
INSERT INTO bhi_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","तेरेमां मे तुहुं काजे समजाड़ो की थुड़ोक खाय लेवु, तेरेसी तुहुं बची रवसु; काहाकी तुंद्‌रे मां सी कुयन बी मुणकान कान्‌यो बी नी उखळे।” ");
INSERT INTO bhi_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ने जो कयदीन पोलुस रुटु हातेम लेदु, ने आखा अगळ रुटा वाटे भगवान काजे तु बेसकु वारु छे कह्‌यु; ने रुटु भांजीन खाणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ती दीसरा आखा बी हिम्‌मत राखीन खाणो खाणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","हामु आखा मेळीन ढंड्‌या मां दुय सोव ने तीन वीसु ने सुवळे जणा हतला। ");
INSERT INTO bhi_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","जत्‌यार चे खायलीन आफरी गुया ती ढंड्‌या काजे फवरो करने करीन ढंड्‌याम सी गहुं काजे समुदर मां नाखणे बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","जत्‌यार दाहड़ु उंग्‌यु ती चे तीनी जागा काजे उळख्‌या नी, बाकुन एक खयड़ु देख्‌या, ने चे वीच्‌यार कर्‌या की हय सके ती जात ढंड्‌या काजे उभो राख देजे। ");
INSERT INTO bhi_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","तत्‌यार चे ढंड्‌यो उभो करने करीन ढंड्‌यान मांजरी काजे समुदर मां नाख देदा, ने डांडे बांद्‌ला नाड़ा काजे छुड़ देदा, ने वाहळो तींखुर सी आवतेलो तींखुर वाळी बरसादी ताणीन समुदर धड़े चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","चे दुय समुदर भेसकायणेन जागा पर मटलो ढंड्‌यो उभो राख देदा, ने ढंड्‌यान अगलु हीस्‌सु उतेळ्‌ळा जागान कादवड़ा मां गाड़ाय गुयु, ने ढंड्‌यान पछलु हीस्‌सु समुदरेन झलके आफटाय-आफटाय्‌न भागणे बाजी गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","तत्‌यार सीपायड़ा वीच्‌यार कर्‌या, की गुलाम माणसे काजे मार नाखता; कांखुर मायन असो नी हय जाय की जे तीरीन नीकळी जाय। ");
INSERT INTO bhi_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","बाकुन सुबेदार पोलुस काजे बचाड़नेन करीन तींद्‌रा वीच्‌यार काजे पुरो करने सी रुक्‌यु, ने कह्‌यु की तीनाक तीरता आवड़ी जाय, चे पेहेल कुदीन धड़े जाती रवे। ");
INSERT INTO bhi_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ने तीनुक तीरता नी आवड़े चे ढंड्‌यान पाट्‌या पर बसीन जाती रहु। ने असा करीन आखा कुय धरती पर नीकळीन जाती रवे। ");
INSERT INTO bhi_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","जत्‌यार हामु बचीन नीकळी जां, ती पतु चाल्‌यु की ईना काळापाणीक माल्‌टा कहवे। ");
INSERT INTO bhi_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","चां वाळा माणसे हामरे पर गीण कर्‌या; काहाकी पाणी पड़नेन वजे सी सेळो लागतेलो; तेरेमां चे आकठो धपाड़ीन हामुक तापाड़्‌या, ने रहणेन आसरु आप्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","जत्‌यार पोलुस लाकड़ा भेळा करीन आकठा मां मेल्‌यु, ती आकठान आच लागणे सी एक जहर वाळु घड़सु नीकळ्‌यु, ने पोलुसेन हातेम गुचवाय गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","जत्‌यार चां वाळा माणसे घड़सा काजे पोलुसेन हात मां गुचवायलु देख्‌या, ती आपसा-आपसात कह्‌या, “छाचलीन जु माणुस हत्‌यारु छे, भले जु दरीया सी बच गुयु, तेबी नीयाव ईना काजे जीवणे नी देदु।” ");
INSERT INTO bhi_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","तत्‌यार पोलुस आपसु हात झेंजड़ीन घड़सा काजे आकठा मां हेड़ पाड़्‌यु, ने पोलुसेन काय बी नुकसाण नी हयो। ");
INSERT INTO bhi_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","बाकुन चे वाट देखता रया की पोलुसेन हात सुज जासे, नीते हयु हीट पड़से ने मर जासे, बाकुन जत्‌यार चे बेसकी वार लग देखता रया, हेरो काय बी नुकसाण नी हयो, ती चे तींद्‌रा मन मां दीसरुत वीच्‌यार आयु ने चे कह्‌या, “जु ते देवता छे।” ");
INSERT INTO bhi_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","तीना जागान आड़े-धड़े एक टापु पुजारान पुबलीयुसेन खेते हतला, चु पुबलीयुस तीना माल्‌टा काळापाणीन नावेन खास हतलु; चु हामु काजे हेरे घर ली जाय्‌न तीन दाहड़ा लग मेजवानी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","तीना पुबलीयुसेन बासेन सेरी आय रवलो, ने चु गुदड़ा मां पड़ी रवलु। अळतेन पोलुस घर मां तेरेन्‌चां जाय्‌न तेरे वाटे मालीक भगवान सी दुवा कर्‌यु, ने तेरे पर हात मेक्‌यु ने चु वारु हय गुयु। ");
INSERT INTO bhi_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","जत्‌यार असो हयो ती तीना काळापाणीम रहण्‌या दीसरा मांदला माणसे बी आया; ने चां आवीन वारु हय गुया। ");
INSERT INTO bhi_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ने चे हामरी बेसकी आव-भाव कर्‌या, ने जत्‌यार हामु सीकेन्‌दर्‌या जाणे वाळाक ढंड्‌या मां बसीन जाणे हींडी रवला ती चे ज बी हामुक चाहतेलो, च ढंड्‌या मां मेल देदा। ");
INSERT INTO bhi_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","तीन महना पछेन हामु सीकेन्‌दर्‌या वाळा ढंड्‌याम बसीन चाल पड़्‌या। जो ढंड्‌यो ईनात काळापाणीम हतलो ने तेरी सहलाणी टाक मेल्‌ली हतली। ");
INSERT INTO bhi_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","हामु सुरकुसा नावेन काळापाणी मां गुया, ने चां तीन दाहड़ा रया। ");
INSERT INTO bhi_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","चां सी हामु रेगीयुम मां गुया, ने दीसरे दाहड़े दखण सी वाहळी चाली, तत्‌यार दीसरे दाहड़े पुतीयुली मां गुया। ");
INSERT INTO bhi_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","चां हामु काजे थुड़ाक ईसु पर भुरसु करन्‌या भायस भेळा हया, ने चे बेसका वीन्‌ती कर्‌या करीन, हामु तींद्‌रेन्‌चां सात दाहड़ा लग रया; ने असा करीन चां सी रोम सहर भीणी चाल पड़्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","अळतेन चां वाळा ईसु पर भुरसु करन्‌या भायस काजे मालुम पड़्‌यो की हामु आवणे बाजी रया, ती चे हामुक भेळा हवणे करीन अप्‌पीयुस हाटेम लग ने तीन धरम साळान्‌चां लग आया, तीनु ईसु पर भुरसु करन्‌या भायस काजे देखीन पोलुस भगवान काजे तु बेसकु वारु छे कह्‌यु ने हिम्‌मत राख्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","जत्‌यार हामु रोम सहरेम पुग्‌या ती पोलुस काजे एक सीपायड़ा साते जु तेरी राखवाळी करतेलु, एखेलुत रहणेन हुकुम जड़ गुय। ");
INSERT INTO bhi_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","तीन दाहड़ा पछेन पोलुस चां वाळा यहुदी माणसेन डाहला काजे बुलायु, ने जत्‌यार चे भेळा हय गुया ती चु तीनुक कह्‌यु, “ए भायस्‌यो, मे आपणा माणसेन ने आपणा डाह-डाहान वीरुद मां काय बी कह्‌यु, तेबी मेसेक यरुसलेम सी धराड़ीन रोमी सीपायड़ान हात मां आप देदा। ");
INSERT INTO bhi_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","चे पुछी-पाछीन मेसेक छुड़ने हींडी रवला, काहाकी मे मरनेन डंड जड़े असु काहनु बी गुनु नी कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","बाकुन जत्‌यार यहुदी माणसे मारे वीरुद कहणे बाजी गुया, ती मेसेक केसर काजे वीन्‌ती करनु पड़्‌यो, जत नी मेसेक मारा माणसे पर गुनु लागाड़नु हतलु। ");
INSERT INTO bhi_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","तेरेमां मे तुहुं काजे बुलायु की तुहुंक भेळु हवो ने वात करो; काहाकी ईस्‌रायेली माणसेन आस वाटे सीपायड़ा मेसेक धरीन मारे हाते ने पाये साकळ लागाड़ देदला छे।” ");
INSERT INTO bhi_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","चे तीनाक कह्‌या, “नी हामु तारे बारामां यहुदी माणसे सी चिट्‌ठी हात कर्‌या, ने नी ते यहुदी भायस मायन कुय आवीन तारा बारामां कह्‌यु, ने नी ते गलत कह्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","बाकुन तारु काय वीच्‌यार छे, चत हामु सामळने हींडी रया, काहाकी हामुक मालुम छे की आखे दुर ईना पंथन वीरुद मां माणसे कहणे बाजी रया।” ");
INSERT INTO bhi_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","तत्‌यार चे एक दाहड़ु पाक्‌कु कर्‌या, ने अळतेन चु दाहड़ु आयु ती बेसका माणसे पोलुसेन्‌चां भेळा हया, ने पोलुस तीनु काजे ईसुन बारामां मुसान साहरे लिखला सास्‌तुरेम सी ने भगवानेन अघली वात बताड़ने वाळा सास्‌तुरेम सी संदारे सी सांतु लग समजाड़तु रयु, ए भगवानेन राजेन बारामां गवा देतु रयु। ");
INSERT INTO bhi_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ज सामळीन कुय तेरी वात मानीन ईसु पर भुरसु कर्‌या, बाकुन कुय तेरी वातेक मानीन ईसु पर भुरसु नी कर्‌या। ");
INSERT INTO bhi_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","जत्‌यार चे एक मन्‌या हय्‌न तेरी वातेक नी मान्‌या, ती पोलुस तीनुक कह्‌यु, चुखली-आत्‌मा भगवानेन अघली वात बताड़ने वाळा यसायाह साहरे तुंद्‌रा डाहा-डाहाक ज कहलु हतलु, जाय्‌न ईनु माणसेक कय दे, ");
INSERT INTO bhi_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","तुहुं सामळसु, ने सामळ्‌यात करसु, बाकुन तुहुंक ईतरोक बी नी समजाये; ने तुहुं देखसु, बाकुन तुहुंक पल्‌ले नी पड़े। ");
INSERT INTO bhi_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","काहाकी जे तींद्‌रो मन काठो कर लेदला छे। ने तींद्‌रा कान्‌टा बेहरा हय गुयला छे। जे तींद्‌रा डुळा मीच लेदला छे। जे हेरेन करीन असा कर्‌या काहाकी हीनुक काय बी नी देखायणु चाहजे, ने हीनुक काय बी सामळायणु नी चाहजे, ने तींद्‌रा मनेम काय बी पल्‌ले नी पड़नु चाहजे, ने कदी मारे भीणी नी वळ्‌नु चाहजे, काहाकी मे तीनुक वारु कर दीस। ");
INSERT INTO bhi_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","हेरेसी तुहुं ज जाण लेवु की भगवानेन जी छुटकारान खुस-खबर नी-यहुदी मां सामळावणे करीन मकली रयु, “चे धी‌यान सी ईनी खुस-खबर काजे सामळसे।” ");
INSERT INTO bhi_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","पोलुस जी वात कय देदु, ने अळतेन यहुदी माणसे वातेम लड़ाय पड़्‌या ने चां सी जाती रया। ");
INSERT INTO bhi_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ने पोलुस रोम मां पुरा दुय साल लग भाड़ेन घर मां रयु। ");
INSERT INTO bhi_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ने जे तेरेन्‌चां आवतेला तीनु आखा काजे चु भेट्‌तु रयु ने वीनधाके ने वीन रुक-टुक मां भगवानेन राजेन परचार करतेलु ने अळी मालीक ईसु मसीन वात सीकाड़तु रयु।");
INSERT INTO bhi_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","पोलुस भीणी सी जु ईसु मसीन पावर्‌यु छे, ने नेवताळु हवणे करीन बुलावलु छे, ने भगवान तीना खुस-खबर वाटे नेवाड़लु छे। ");
INSERT INTO bhi_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","तेरी चु पेहलुत सी आपणी भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌यान साहरे चुखला सास्‌तुर मां, वायदु करलु हतलु। ");
INSERT INTO bhi_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","गुयु हेरु पुर्‌या काजे आपणा मालीक ईसु मसीन बारामां आस लागाड़्‌यु; चु डीलेन भाव सी ते दावुदेन खानदानी सी पयदा हयु ");
INSERT INTO bhi_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ने चुखली-आत्‌मान भाव सी ईसु मरलाम सी जीवतु हवणेन वजे सी ताकुतेन साते भगवानेन पुर्‌यु ठेहरलु छे। ");
INSERT INTO bhi_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","हेरे साहरे आपणु काजे बेसकी वारु दया ने नेवताळा बननेन मुखु जड़्‌यु हेरा नावेन वजे सी आखा नी-यहुदी माणसे भुरसु करीन हेरी माने, ");
INSERT INTO bhi_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","तेरेमां तुहुं बी ईसु मसीन हवणे वाटे बुलावला छे। ");
INSERT INTO bhi_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","तीनु आखान नाव जे रोम मां भगवानेन लाटेक्‌ला छे ने चुखला हवणे वाटे बुलावला छे: आपणु बास भगवान ने मालीक ईसु मसी भीणी सी तुहुं काजे गीण-दया ने सांती जड़ती रवे। ");
INSERT INTO bhi_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","पेहेल मे तुहुं आखा वाटे ईसु मसीन साहरे आपणा भगवान काजे तु बेसकु वारु छे करीन कहुं, काहाकी तुंद्‌रा भुरसान वात आखा कळी मां हय रय ");
INSERT INTO bhi_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","भगवान तेरी चाकरी मे आपणी आत्‌मा सी हेरा पुर्‌यान खुस-खबरेन बारामां करो, हयुत मारु गवा छे की मे तुहुं काजे काहनी रीत सी लगातार हेर करतु रव, ");
INSERT INTO bhi_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ने जलम असु वीन्‌ती करो की भगवानेन मरजी सी काहली-ने-काहली रीत सी मेसे आकरी मां तुंद्‌रे धड़े आवणे वारु मुखु जड़े। ");
INSERT INTO bhi_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","काहाकी मे तुंद्‌रे सी भेळु हवणेन लालुच करो की मे तुहुं काजे कुय जीव-आत्‌मान वाटु आपो तेरे सी तुहुं काठा हय जावु; ");
INSERT INTO bhi_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","अळतेन ज की जत्‌यार मे तुंद्‌रे ईचमां रवो, ती हामु तीना भुरसान साहरे ज हामरे मां, ने तुंद्‌रे मां छे एक दीसरा सी वात वीच्‌यार जड़े। ");
INSERT INTO bhi_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ए भायसे, मे नी चाहतु की तुहुं हेरे सी अणजाण्‌या रवु की मे काय कावा तुंद्‌रे धड़े आवणे चाह, की जसा मेसे नी-यहुदी नी जाणे तीनी जाती मां फळ जड़्‌यो, असात तुंद्‌रे मां बी जड़से, बाकुन हय लग रुकायलो छे। ");
INSERT INTO bhi_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","मारे पर युनानी माणसेन ने नी-यहुदी, ने अक्‌कल वाळा ने डेड़-अकल्‌या माणसेन करजु छे। ");
INSERT INTO bhi_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","अळतेन मे तुहुंक बी जे रोम मां रवु, खुस-खबर सामळवणे करीन काहाली बी टेम मां तीयार छे। ");
INSERT INTO bhi_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","काहाकी मे खुस-खबर सी नी सरमांयो, हेरे सी की चु आखा जणा जे भुरसु करने वाळा वाटे, पेहेल ते यहुदी अळतेन नी-यहुदी वाटे, छुटकारान करीन भगवानेन ताकत छे। ");
INSERT INTO bhi_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","काहाकी हेरे मां भगवानेन वारलु भुरसा सी ने भुरसा वाटे देखाये; जसों लिखलो छे, “भुरसा सी वारलु माणसे जीवता रवसे।” ");
INSERT INTO bhi_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","भगवानेन रीस ते तीनु माणसे आखी नी भक्‌ती ने पाप पर चाले सरगे सी पड़से ज छाचाय्‌न वात काजे पाप करीन चीपदीन राखे। ");
INSERT INTO bhi_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","हेरेसी की भगवानेन बारामां अक्‌कल हींद्‌रे मने मां देखायसे, काहाकी भगवान हींद्‌रे बारामां बताड़लु छे। ");
INSERT INTO bhi_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","जत्‌यार सी कळी बणी हेरी नी-देखाय असली खास जलमेन ताकत ने भगवानेन गुण साप देखाये काहाकी हीनु चीजे सी पुरी रीती सी जाणी जाय सके जी भगवान बणावलु छे हेरेसी माणसे भीणी काय बाहनो नी हय। ");
INSERT INTO bhi_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","हेरे वजे सी चे भगवान काजे जाणे तेबी चे भगवानेन जसी बड़ाय करनु चाहजे बाकुन तसी बड़ाय नी कर्‌या ने जसा भगवान काजे तु बेसकु वारु छे करीन कहंणु चाहजे तसा नी कह्‌या, बाकुन असलात वीच्‌यार करने बाजी गुया, जां लग की तींद्‌रा डेड़-अकल्‌या मन आंदारलो हय गुयो। ");
INSERT INTO bhi_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","चे आपसा काजे अक्‌कल वाळा समजीन डेड़-अकल्‌या बण गुया, ");
INSERT INTO bhi_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ने जलम लग भगवानेन सेक-सींगार काजे माणसेन सीकु, ने चिरलान सीकु, ने चार पाया जनवार्‌यान सीकु, ने घीसड़ायन्‌या जनवार्‌यान सीकु समजीन तींद्‌री पुजा-पाट करने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","हेरे वजे सी भगवान बी तीनुक हींद्‌रे मनेन हरेन अनसारे वीटळने करीन छुड़ देदु की चे एक दीसरान डीलेन अबरु नी करे। ");
INSERT INTO bhi_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","काहाकी चे भगवानेन छाचाय काजे झुट साते भेसकी देदा, ने कळीन उपास ने चाकरी, ने पुजा-पाट सुरु कर देदा बाकुन कळ काजे घड़न्‌या भगवानेन भक्‌ती ने पुजा-पाट नी कर्‌या। भगवान जलम बेसका वारु छे! असोत हवतो रवे। ");
INSERT INTO bhi_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","हेरेसी भगवान बी तीनु काजे गांडा हरेन हक मां रवणी देदु; जां लग की बायरा साते सवसार करने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ने अदमी बायरा साते सवसार करने रहणीदीन ने अदमी-अदमी साते सवसार करने ने कराड़ने ने चे चंगलाय ने सवसार करने हायाळ्‌ळा बण गुया। तीनुक बे सरम्‌या पापेन डंड, आपसा डील मां जीवतेला काजे भुकेतणु पड़्‌यो। ");
INSERT INTO bhi_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","जत्‌यार चे भगवान काजे उळखणे नी हींडतेला, भगवान बी तीनु काजे हींद्‌रे भुंडले मनेन वजे सी रवणी देदु की चे जे कामे चे नी करनु चाहजे असला काम करने बाजी गुया। ");
INSERT INTO bhi_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","चे आखी तरान वारलु काम नी करन्‌या ने पाप ने हाय-हाय ने कुहरायन वीच्‌यार सी भराय गुया, ने मनेन काट खुन ने झगड़ा, ने ठगणे वाळा भुंड्‌ला वीच्‌यार सी भराय गुया ने एक दीसरान चुगली करने बाजी गुया ने चे जलम दीसरान नुकसाण हवणु चाहजे करीन असात वीच्‌यार कर्‌या करे, ");
INSERT INTO bhi_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ने चे दीसरान असलात नाव-बद्‌दी करन्‌या, ने भगवान सी रीस करने वाळा, दीसरान अबरु लेण्‌या, ने मटाय कर्‌या, मट्‌ली-मट्‌ली आपरन्‌या, ने कुहरायन वात करने वाळा, आस्‌या-बास्‌यान हुकुम नी मान्‌या, ");
INSERT INTO bhi_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","डेड़-अकल्‌या, धुकु देण्‌या, दया नी करन्‌या ने दया करने मां लुला बण गुया। ");
INSERT INTO bhi_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","चे ते भगवानेन जी रीती जाणे की असला काम करने वाळा काजे मुतेन डंड जड़से, ने आपसात असलो काम करे ने ज असला कामे करे तीनु काजे तु बेसकु वारु करीन बी कह्‌या। ");
INSERT INTO bhi_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","हेरेसी ए दीसरान वाक नीकाळन्‌या, तु काहनु बी हय, तुसेक जपाप नी देवाये; काहाकी तु तीनी वात मां दीसरान वाक नीकाळे तीनीत वात मां तारु बी वाक छे, तेरेमां की तु तीनीत वात मां वाक नीकाळे चेत गलत काम करे। ");
INSERT INTO bhi_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","काहाकी आपणु काजे मालम छे की छाचला-छाचला गलत काम करने वाळा पर भगवान भीणी सी छाचला-छाचला टेम मां डंडेन हुकुम जड़से। ");
INSERT INTO bhi_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ए माणुस, तु ज असला-असला गलत कामे करने वाळान वाक नीकाळे ने आपसुत असला गलत काम करे; ती तु ज समजी र्‌यु काय की मे भगवानेन नीयावेन डंड सी बची जायस? ");
INSERT INTO bhi_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","काय तु भगवानेन भलाय, ने तेरो सहणु, तेरी सेण काजे असलुत समजी र्‌यु काय? ने तुसेक जी वात नी समज मां आवती काय की तेरी मट्‌ली दया पाप भीणी सी मन फीरावणे करीन सीकाड़े? ");
INSERT INTO bhi_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","बाकुन तु आपणा काठला ने कदी नी पसतावु करने वाळा मनेन वजे सी हेरे रीसेन दाहड़ा वाटे, तेरेमां भगवानेन छाचला नीयाव आवसे, तारे वाटे रीस कमाय र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","चु एक-एक काजे तींद्‌रा कामेन अनसारे बदलु आपसे। ");
INSERT INTO bhi_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","जे भगवान काजे वारु गमे असो काम काठु रवीन सेक-सींगार, ने आव-भाव, ने अमरेन जीवन काजे हेरसे, तीनु काजे चु जलमेन जीवन आपसे; ");
INSERT INTO bhi_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","बाकुन जे झगड़ा वाळा छे ने छाचाय काजे नी माने बाकुन पाप जाणे हींद्‌रे पर रीस लागसे। ");
INSERT INTO bhi_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","दुख ने गरा एकेक माणसेन जीव पर चे भुंडात काम करे तींद्‌रे पर आवसे, पेहेल यहुदी पर अळतेन नी-यहुदी पर; ");
INSERT INTO bhi_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","बाकुन सेक-सींगार ने आव-भाव ने वारलु सांती एकेक काजे जड़से, जे वारु करसे, पेहेल यहुदी काजे अळतेन नी-यहुदी काजे। ");
INSERT INTO bhi_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","काहाकी भगवान काहनान बी छीट राखीन कुयन नीयाव नी करे। ");
INSERT INTO bhi_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","हेरेसी जीनु काजे मुसान साहरे लिखलु कायदु नी जड़्‌यु, पाप कर्‌या चे मुसान साहरे लिखला कायदा पाखुर सरी जासे; ने जीनु काजे मुसान कायदु जड़्‌यु ने पाप कर्‌या, तीनु काजे कायदान अनसारे डंड जड़से; ");
INSERT INTO bhi_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","काहाकी भगवानेन चां मुसान साहरे लिखला कायदा काजे सामळने वाळा वारलु नी, बाकुन मुसान साहरे लिखला कायदा पर चालने वाळा वारलु ठेहरायसे। ");
INSERT INTO bhi_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","अळतेन जत्‌यार नी-यहुदी तींद्‌रे धड़े मुसान साहरे लिखली सास्‌तुर नी हय, तेबी वारु मन सी मुसान साहरे लिखला सास्‌तुरेन वात पर चाले, ती कायदु हींद्‌रे धड़े नी रवे तेबी चे तींद्‌रे वाटे आपसान कायदु छे। ");
INSERT INTO bhi_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","चे कामेन साहरे ने चां कायदा लिखला देखाड़े ने तींद्‌रो हीयो मन गवा देय, ने हींद्‌रा वीच्‌यार एक दीसरा पर गुनु लागाड़े, नीते हीनुक नी-गुनावाळा ठेहरावे; ");
INSERT INTO bhi_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","जी खुस-खबर मे सामळावो तीनी खुस-खबरेन अनसारे ईसु मसीन साहरे भगवान तीने दाहड़े माणसेन सातायला वातेन नीयाव करसे। ");
INSERT INTO bhi_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","कदी तु आपसा काजे यहुदी कहें, ने कायदा मां भुरसु करे, ने तु तारा भगवानेन बारामां मटाय करे, ");
INSERT INTO bhi_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ने भगवानेन मरजी काजे जाणे ने कायदान सीकाड़नेन वात काजे वारु-वारु वात काजे पाळे; ");
INSERT INTO bhi_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ने आपसा पर भुरसु करे की मे आंदळा काजे वाट देखाड़्‌यु, ने आंदारला मां भटकी रवला माणसे काजे वीजाळो आपलु छे, ");
INSERT INTO bhi_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ने डेड़-अकल्‌या काजे सीकाड़ने वाळु, ने पुर्‌या-पारी काजे सीकाड़न्‌यु छे; ने अकल, ने छाचाय सीकाड़नेन वात, जी कायदा मां छे, ची मेसे काजे जड़ली छे। ");
INSERT INTO bhi_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","हेरेसी वीच्‌यार कर तु दीसरा काजे सीकाड़े, ती आपसा काजे नी सीकाड़े काय? तु जु चुरी नी करनु करीन परचार करु, ने आपसात चुरी करे? ");
INSERT INTO bhi_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","तु ज कहें, “छीनाळो नी करनु” काय आपसु छीनाळो नी करतु काय? तु जु मुरत्‌या सी रीस करे, काय आपसुत मंदीरेन धन काजे नी लुटे काय? ");
INSERT INTO bhi_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","तु जु मुसान कायदान बारामां मटाय ते करे, कायदा काजे तुड़ीन भगवानेन बदनामी काहा करे? ");
INSERT INTO bhi_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“काहाकी तुंद्‌रे वजे सी नी-यहुदी मां भगवानेन नावेन वाक वाळा हय रया।” जसों लिखलो बी छे। ");
INSERT INTO bhi_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","कदी तु मुसान साहरे लिखला कायदा पर चाले ती ते फतरी काटाड़ने सी नफु हवसे, बाकुन कदी तु मुसान साहरे लिखला कायदा पर नी चाले, ती फतरी काटाणे सी काय बी नफु नी हवे। ");
INSERT INTO bhi_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","हेरेसी कदी फतरी काटे पाखुर माणसे मुसान साहरे लिखला कायदान रीती काजे पाळे ती भले चु फतरी काटाड़्‌यु तेबी चु फतरी काटाड़न्‌या मां नी गीणाये काय? ");
INSERT INTO bhi_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ने चु माणुस डील मां फतरी नी काटाड़्‌यु ने मुसान साहरे लिखला कायदु पाळी र्‌यु, चु तुसे काजे गुनाळु ठेहरावसे भले तारे वाटे मुसान साहरे लिखला कायदा छे, काहाकी तु मुसान साहरे लिखला कायदा पर नी चालतु? ");
INSERT INTO bhi_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","जे बाहार सी यहुदी छे, चे छाचलीन यहुदी नी हय ने डीलेन फतरी काटाड़े छाचलीन फतरी काटाड़न्‌यु नी हय। ");
INSERT INTO bhi_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","बाकुन खास यहुदी हयुत छे जु मन मां यहुदी छे, ने फतरी काटाड़्‌लु हयुत छे जु मन मां ने जीव-आत्‌मा मां छे ने चु लिखली वातेन अनसारे फतरी काजे काटाड़लु बी नी हय, बाकुन असली ईज्‌जत माणसे काजे माणुस भीणी सी ईज्‌जत नी जड़े बाकुन भगवान भीणी सी ईज्‌जत जड़े। ");
INSERT INTO bhi_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","अळतेन यहुदी बन्‌ने सी काय फायदु ने नीते फतरी काटणे सी काय नफु? ");
INSERT INTO bhi_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","आखे आन्‌गे सी बेसकु फायदु पेहेल ते ज की भगवानेन बुल तीनु काजे सुपलु हतलु। ");
INSERT INTO bhi_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","कदी हींद्‌रे मां भुरसु नी करे असला बी नीकळी जाय ती काय हय गुयो? काय हींद्‌रे भुरसा मां धुकु देणे सी भगवानेन छाचाय फालतु हय जासे काय? ");
INSERT INTO bhi_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","कदी नी बाकुन भगवान छाचलु रवसे ने आखा माणसे लुच्‌चा रवसे, जसों लिखलो छे, “तेरी तु आपणी वात मां वारलु छे ने नीयाव करनेन टेम मां तु छाचलु छे।” ");
INSERT INTO bhi_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","हेरेसी कदी आपणु जे भुंडो काम करजे चे भगवानेन धरम काजे पाक्‌को करे, ती आपणु काय कहंजे? काय ज की भगवान जु रीस करे नीयाव नी करन्‌यु छे काय? ज ते माणसेन रीत पर कय र्‌यु। ");
INSERT INTO bhi_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","कदी नी नीते भगवान कसु कळीन नीयाव करसे? ");
INSERT INTO bhi_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","कदी मारा झुटेन वजे सी भगवानेन छाचाय हेरे सेक-सींगार वाटे, जादा करीन उजेंतु हवे ती पेहेल काहा तु पापी छे करीन मारु नीयाव हवे? ");
INSERT INTO bhi_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","“हामु काहा नाव-बद्‌दी नी करजे की भलाय नीकळे?” जसों हामरे पर जु वाक नीकाळी बी र्‌या, ने काहानाक कहें की हींद्‌रो जत कहंणु छे। बाकुन असलात गुनु लागाड़नु वारु छे? ");
INSERT INTO bhi_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ती पछेन काय हयो? काय आपणु हींद्‌रे सी वारलु छे? कदी नी; काहाकी आपणु यहुदी ने नी-यहुदी दुयु पर गुयु गुनु लागाड़ी देदला छे की चे आखा ने आखा पापेन हक मां छे। ");
INSERT INTO bhi_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","जसों लिखलो छे: “कुय बी वारलु नी हय, एक बी नी हय। ");
INSERT INTO bhi_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","कुय बी समजदार नी हय; कुय बी भगवान काजे हेरने वाळु नी हय। ");
INSERT INTO bhi_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","आखा भटकी गुयला छे, आखान आखा बीगड़ी गुयला छे; कुय बी भलाय करने वाळु नी हय, एक बी नी हय। ");
INSERT INTO bhi_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","तींद्‌रु गळु मसाणेन तसु छे, चे आपणा जीप्‌या सी झगड़ा करे, हींद्‌रा हुटड़ा मां घड़सान जहर भरलु छे। ");
INSERT INTO bhi_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","हींद्‌रो मुंहडो रीस ने कड़वान सी भरायलो छे। ");
INSERT INTO bhi_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","हींद्‌रा पाय माणसे काजे मारीन खुन करने उतवाळा रवे, ");
INSERT INTO bhi_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","हींद्‌रे वाट मां नुकसाण ने दुख छे, ");
INSERT INTO bhi_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","चे सांतीन वाट नी जाणे। ");
INSERT INTO bhi_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","हींद्‌रा डुळा अगळ भगवान काजे देखीन बी नी बीहे।” ");
INSERT INTO bhi_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","हामुक मालम छे की मुसान कायदु जु काय कहें तींद्‌रे सी कहें, जे मुसान कायदान हक मां छे; हेरेसी एकेक जणान मुंहडो बन्‌द हय जाणु चाहजे ने आखी कळी भगवानेन डंडेन वाटे रवे; ");
INSERT INTO bhi_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","काहाकी मुसान कायदान काम सी कुय जीव बी हेरे अगळ वारलु नी गीणाये, हेरेसी की मुसान कायदान साहरे पापेन उळखान हवे। ");
INSERT INTO bhi_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","बाकुन हय मुसान कायदा सी अलग भगवानेन चु वारलु उजेंतु हयु, की तेरी गवाय मुसान कायदु ने भगवानेन अघी सी आवणे वाळी वात देखाड़न्‌यान देय, ");
INSERT INTO bhi_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ने भगवानेन चु धरम ज्‌य ईसु मसी पर भुरसु करने सी आखा भुरसु करने वाळा वाटे छे। काहाकी काय बी छीट नी हय; ");
INSERT INTO bhi_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","हेरेसी की आखान ने आखा पाप कर्‌या ने भगवानेन सेक-सींगार सी छेटे हय गुया, ");
INSERT INTO bhi_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","बाकुन भगवानेन गीण-दया सी तीना छुटकारान साहरे ज ईसु मसी मां छे, फेरी मां वारलु ठेहरावलु छे। ");
INSERT INTO bhi_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ईसु मसी काजे भगवान लुही सी पापेन डंड भरन्‌यु बणाय देदु, ने ईसु पर भुरसु करने सीत आपणु काजे छुटकारु जड़े, जे माणसे पाप पेहेल करला ने भगवान तींद्‌रा पाप काजे सेण करतु र्‌यु ने तींद्‌रा चु ईसुन साहरे आपसान धरम उजेंतु कर्‌यु। ");
INSERT INTO bhi_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","बाकुन ईनेत टेमे तेरु धरम उजेंतु हवे तेरेसी चु आपसुत वारलु गीणायसे, ने जे ईसु पर भुरसु करे तीनु काजे बी वारलु बणावसे। ");
INSERT INTO bhi_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ती मटाय करनु काहा र्‌यो? हेरी ते जागा नी हय। काहानी मुसान कायदान वजे सी? काय वारलु करने मुसान कायदा सी? नी बाकुन भुरसान कायदान वजे सी। ");
INSERT INTO bhi_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","हेरेसी कुय माणुस मुसान कायदान कामेन अनसारे चालीन नी, बाकुन भुरसान साहरे धरमी बण सके। ");
INSERT INTO bhi_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","काय भगवान यहुदीयान अतरुत छे काय? काय नी-यहुदीन नी हय? हव नी-यहुदीन बी छे। ");
INSERT INTO bhi_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","काहाकी एकुत भगवान छे, जु फतरी काटाण्‌या काजे भुरसा सी ने नी फतरी काटण्‌या काजे बी भुरसान साहरे वारलु ठेहरावे। ");
INSERT INTO bhi_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ती काय आपणु मुसान साहरे लिखला कायदा काजे भुरसान साहरे फालतु ठेहरावजे? कदी नी बाकुन मुसान साहरे लिखला कायदा काजे जादा ताकतवाळु बणावे। ");
INSERT INTO bhi_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","तेरेमां हामु अब्‌राहमेन बारामां काय कहंजे जु डीलेन अनसारे हामरु डाहालु हतलु तीनाक काय जड़्‌यो? ");
INSERT INTO bhi_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","काहाकी कदी अब्‌राहमेन काम सी धरमी गीणायतु, ती तीनाक मटाय करनेन जागु रवतु, बाकुन भगवान अगळ तीनाक मटाय करनेन गाळु नी हय। ");
INSERT INTO bhi_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","चुखलो सास्‌तुर काय कहें? ज्‌य की, “अब्‌राहम भगवान पर भुरसु कर्‌यु, ने जु भुरसु तेरे वाटे वारलु गीणायु।” ");
INSERT INTO bhi_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","काम करने वाळान दाहड़की आपणु दान नी, बाकुन हक गीणाये। ");
INSERT INTO bhi_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","बाकुन जु काम करनु रवणी दीन तीना भगवान पर भुरसु करे, चु पापी काजे वारलु गीणे, ती तेरु भुरसुत तेरे वाटे वारलु गीणायसे। ");
INSERT INTO bhi_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ईनी भाती दावुद हीना माणुस काजे वारु कह्‌वे, तीनाक भगवान काम करे पाखुर वारलु बणावे: ");
INSERT INTO bhi_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“वारु छे चु, तेरु पाप माफ हय गुयु, ने तेरा पाप ढाकाय गुया। ");
INSERT INTO bhi_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","वारु छे चु माणुस तीनाक भगवान पापी नी कहें!” ");
INSERT INTO bhi_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ती ज्‌य वारु बुल, काय फतरी काटाड़न्‌या नीते फतरी नी काटाड़्‌या हींद्‌रे वाटे बी? हामु ज्‌य कहंजे, “अब्‌राहम हेरा भुरसान साहरे खरलु धरमी गीणायु।” ");
INSERT INTO bhi_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ती चु वारलु कसु गीणायु? फतरी काटाड़लु ती, की फतरी नी काटाड़्‌यु ती वारलु गीणायु; बाकुन चु ते फतरी काटे पाखुर वारलु गीणायलु। ");
INSERT INTO bhi_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ने अळतेन चु भुरसान साहरे धरमी गीणायलु छे ज्‌य देखणे करीन सहलाणी वाटे फतरी काटाड़्‌यु, पेहल चु फतरी काटे पाखुर भगवान पर भुरसु करलु हतलु। ने असु करीन चु अब्‌राहम तीनु आखान बास गीणाये; ");
INSERT INTO bhi_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ने असु करीन चु फतरी नी काटाड़े तींद्‌रु बास गीणायु, जे अब्‌राहमेन तसा भगवान पर भुरसु करीन जीवे, तसु अब्‌राहम बी फतरी काटाड़े पाखुर पेहेल भगवान पर भुरसु करतेलु। ");
INSERT INTO bhi_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","काहाकी भगवान अब्‌राहम ने अब्‌राहमेन अवल्‌यात काजे वायदु करलु की चे कळीन हकदार्‌या बणसे। अब्‌राहम कायदाक मान्‌यु करीन भगवान असु वायदु नी कर्‌यु, बाकुन चु भुरसु कर्‌यु करीन भगवान हीनाक धरमी गीणायु। ");
INSERT INTO bhi_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","काहाकी कदी मुसान कायदा पाळन्‌यात वायदान जागु हात मां करसे, ती ते भुरसु करने सी काय फायदु नी हय ने भगवानेन वायदु करली वात बी फालतु हय गुय। ");
INSERT INTO bhi_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","मुसान कायदु ते भगवानेन रीस काजे उबजाड़े ने चां कायदु नी हय, चां कायदु तुड़नेन वात नी आवे। ");
INSERT INTO bhi_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","भगवानेन वायदु भुरसान फळ छे ने ज असोत जड़े। तीने रीते तेरा बुले अब्‌राहमेन आखा वाटे ते चेत, ने जे नीयम काजे माने तींद्‌रे वाटे नी बाकुन तीनु आखा वाटे बी जे अब्‌राहमेन तसा भुरसु राखजे। चु हामरु आखान भगवान बास छे। तेरेमां ज पाक्‌को छे ");
INSERT INTO bhi_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","जसों की लिखलो छे, “मे तुसे काजे बेसका माणसेन बास ठेरावलु छे।” भगवानेन नींगा मां अब्‌राहम हामरु बास छे। अब्‌राहम भगवान पर भुरसु कर्‌यु, जु भगवान मरला काजे जीवाड़े ने जे हय नी तीनु काजे बी घड़ीन उबजाड़े। ");
INSERT INTO bhi_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","अब्‌राहम नीरासेन दाहड़ाम बी आस राखीन भुरसु कर्‌यु ने चु बेसकी जातीन माणसेन बास बण गुयु, जसों तीनाक कहंलो हतलो की तारा गीणाये नी अतरा माणसेन बास हवसी। ");
INSERT INTO bhi_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","अब्‌राहम भुरसा मां पाक्‌कु बणीन रयु ने असु जाणतेलु तेबी की हेरो डील सोव सालेन हय गुयली छे ने सारान पुर्‌या नी हवतेला। ");
INSERT INTO bhi_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","भगवानेन वायदा पर भुरसु बणायन राख्‌यु अतरुत नी भुरसा काजे काठु करतु जाय्‌न भगवाने