﻿USE sofia;
DROP TABLE IF EXISTS sofia.bhg_vpl;
CREATE TABLE bhg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bhg_vpl WRITE;
INSERT INTO bhg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ove eiwa Iesu Keriso da ewowo gawowo udugedo gaiari. Daotari David awa ainda ewowo edo daedo Abraham awa ainda ewowo: ");
INSERT INTO bhg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham awa Isaac da mamo, Isaac awa Jacob da mamo, edo Jacob awa Judah ae ainda nanonameji deda mamo. ");
INSERT INTO bhg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah awa Perez ae Zerah deda mamo, (Awamaneda ai awa Tamar.), Perez awa Hezron da mamo, Hezron awa Ram da mamo, ");
INSERT INTO bhg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram awa Amminadab da mamo, Amminadab awa Nashon da mamo, Nashon awa Salmon da mamo, ");
INSERT INTO bhg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon awa Boaz da mamo, (Boaz da ai awa Rahab.), Boaz awa Obed da mamo, (Obed da ai awa Ruth.), Obed awa Jesse da mamo, ");
INSERT INTO bhg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","edo Jesse awa Daotari David da mamo. Daotari David awa Solomon da mamo, (Solomon da ai awa gisi Uriah da aro.), ");
INSERT INTO bhg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon awa Rehoboam da mamo, Rehoboam awa Abijah da mamo, Abijah awa Asa da mamo, ");
INSERT INTO bhg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa awa Jehoshaphat da mamo, Jehoshaphat awa Joram da mamo, Joram awa Uzziah da mamo, ");
INSERT INTO bhg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah awa Jotham da mamo, Jotham awa Ahaz da mamo, Ahaz awa Hezekiah da mamo, ");
INSERT INTO bhg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah awa Manasseh da mamo, Manasseh awa Amon da mamo, Amon awa Josiah da mamo, ");
INSERT INTO bhg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah awa Jeconiah ae ainda nanonameji deda mamo. Iji ainde awamane isiretera, Babylon itoro embobomi awamane bundedo kundo Babylon maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babylon kundo maunsitera ainda amboda awa: Jeconiah awa Shealtiel da mamo, Shealtiel awa Zerubbabel da mamo, ");
INSERT INTO bhg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel awa Abiud da mamo, Abiud awa Eliakim da mamo, Eliakim awa Azor da mamo, ");
INSERT INTO bhg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor awa Zadok da mamo, Zadok awa Achim da mamo, Achim awa Eliud da mamo, ");
INSERT INTO bhg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud awa Eleazar da mamo, Eleazar awa Matthan da mamo, Matthan awa Jacob da mamo, ");
INSERT INTO bhg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","edo Jacob awa Joseph da mamo. Joseph awa Mary da iu, edo Mary mi Iesu engisina. Edo embomaimi imo Keriso dao tedo era. ");
INSERT INTO bhg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Awatedo ainda ewowo gawowo Abraham da yai edo aundo David da yai awa ajigari berari 14, edo David da yai aundo iji ainde awamane gitopo embobomi bundedo kundo Babylon maunsitera awa ewowo gawowo ajigari berari 14, edo awamane bundedo kundo Babylon maunsitera edo aundo iji ainde Keriso engisina awa ewowo gawowo ajigari berari 14. ");
INSERT INTO bhg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Edo Iesu Keriso nongo edo engisini awa engo: Ainda ai Mary awa Joseph mi jimbarate geritera. Ata awamane jimbae gisida, Asisi Kotopu da gorobami esiri watou jijirisina. ");
INSERT INTO bhg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Edo Joseph, Mary da gerari iu, awa wasiri dambu darari embo. Edo iji angode Mary watou jiriri gido imo eutu awa dowain kotembesisina. Ata eutu awa imo mengari awa jipapa ae esisina, awatedo embomaida jisida dowainyae esisina. ");
INSERT INTO bhg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ata giwo, imo eiwa kotembeteiri Badari da anela aturoda idegedo ainde sisina, “Joseph, David da mai, Asisi Kotopu da gorobami esiri mai awa sinenembatara, awatedo adu eote. Mary buyo ito aro are. ");
INSERT INTO bhg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Edo eutu ami mai engaina, edo mai ami ainda embomai jimbo bebegaeda bundari awa toregaina, awatedo ine ainda dao Iesu tata.” ");
INSERT INTO bhg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aindabé Badari mi peroveta da yai rorae eiwa idegaina sisina, awatedo ro berari idegarate sisina awa gundo bé esisina. Edo sisina awa engo: ");
INSERT INTO bhg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Giwo, gagara kombo ae awa watou jirido mai engaina, edo ainda dao Immanuel tedo ara.” (Immanuel da moka awa “God kaenamonde daedo”.) ");
INSERT INTO bhg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ango edo Joseph jitao awari dodo erido Badari da anelami ro arate sisina awa esisina. Edo imo Mary kumbiri ainda aro esisina. ");
INSERT INTO bhg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ata embo ami ainde kombo ae aundo eutu ainda mai buwo engae gisida. Edo ainda amboda engesiri Joseph mi ainda dao Iesu sisina. ");
INSERT INTO bhg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iji ainde Herod daotari isiri nasi Beteliem doda, yai Judea ainda, Iesu awa engisina. Edo giwo, ainda amboda dubogari embobo iji vitari kena edo Jerusalem guputera. ");
INSERT INTO bhg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Edo awamanemi sitera, “Jew embomaida daotari arate mai engisina awa nondari? Nakare maida dabori iji vitarida isite gido mai awa tumondebain ain gumbera.” ");
INSERT INTO bhg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ango edo Daotari Herod ge eiwa ingido do buriya esisina, edo Jerusalem embomai berari daedo ango esitera. ");
INSERT INTO bhg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Edo embo ami Jew embomaida pirisi babain ae Aodarida atopapasigari de berari dao tesiri gundo doregetero awamanede tedogosisina, “God da Ove Gaiarida gemi Keriso yai nonda engaina sisini?” ");
INSERT INTO bhg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ango tesiri awamanemi mina sitera, “Beteliem doda yai Judea ainda, perovetami engo gagurisina: ");
INSERT INTO bhg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ata imo Beteliem nasi, Judah butu doda iteta, ito yai edo Gisijiaribé idegaina, edo embo ami dave edo nato Israel embomai gisijiaina. Awatedo imo awa Judah da nasi sakabé ae.’” ");
INSERT INTO bhg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ango edo Herod dubogari embobo onjigarida dao tesiri gumbero awamanede tedogosisina, iji bé nonde dabori idegesisini awa. ");
INSERT INTO bhg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Edo embo ami awamane Beteliem nasida piedo sisina, “Maundo dave edo mai saka awa kakowa ewo. Edo tamundo gido, overegedo gundo na ge tawo gido na daedo maundo mai awa tumondebain ane.” ");
INSERT INTO bhg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Edo daotari ge tesiri ingido awamane maunsitera. Edo giwoǃ Dabori iji vitarida isite gositera, ami gisi edo aundo yai mai saka isira ainda ikaneda peposisina. ");
INSERT INTO bhg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ango edo awamane dabori awa gido do yawa bajinabé esitera. ");
INSERT INTO bhg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Edo awamane gundo mandoda torido mai saka ae ainda ai Mary de gido, awamane baongo dadari edo mai awa tumondebain esitera. Ango edo awamane kaita pirigedo kando kundo maide pipisitera: gold de frankincense de myrrh de. ");
INSERT INTO bhg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Edo God mi awamanede aturoda tesiri gositera, tekago Herod da yai mamborekae. Awatedo awamane dodo begata nei budo awamaneda yaida maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ango edo awamane idegedo mambero, giwo, Badari da anelami Joseph de aturoda idegedo sisina, “Herod mai saka awa dari betarate kakowa aina. Awatedo eri! Mai saka ae ai de budo yai Egypt boraebé mambate. Edo ainda isiato nane tano gido tekago egenembata.” ");
INSERT INTO bhg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Edo Joseph erido mai saka awa ae ai de budo muyaede yai Egypt ainda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Edo awamane yai ainda itero Herod besisina. Aindabé Badari mi perovetade matu sisina, “Nane nato mai awa Egypt dodo idegarate dao sitena,” ge awa bé esisina. ");
INSERT INTO bhg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Edo iji ainde Herod mi dubogari embobomi imo udumbetera ango gido, imo sinigambari bajinabé esisina. Aindabé dubogari embobomi iji nonde mai awa engesiri awa Herod de matu tetero gosisina, awatedo imo ge katedo mai jijianda berari duberi tote (2) edo tuda Beteliem nasi doda edo nasi babaingae demonda awa daedo daro betorote ge okain sisina. ");
INSERT INTO bhg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ango edo ge peroveta Jeremiah mi sisina awa bé esisina: ");
INSERT INTO bhg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Edo ge yavi awa Ramah nasida ingera. Do ari ya ae ji de aoro ikanade Rachel mi ainda mamai awaembo tedo esira. Aindabé ainda mamai berari bebetegetera, eutu awa embo neneimi kondade ari jipapa ae edo esira.” ");
INSERT INTO bhg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ango edo, amboda Herod betesiri, giwo, Joseph yai Egypt ainda isiri Badari da anela aturoda idegedo ");
INSERT INTO bhg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ainde sisina, “Ouwamane ainkain mai saka daro betarate esitera awa besitara. Awatedo eriyoǃ Mai saka ae ainda ai de budo Israel butuda aimbate.” ");
INSERT INTO bhg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ango tesiri Joseph erido mai saka ae ainda ai de budo Israel butuda totorisina. ");
INSERT INTO bhg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ata iji ainde Joseph mi ge eiwa ingisina, “Archelaus mi ainda mamo Herod da dero budo yai Judea gisijido eira.” Awatedo ge awa ingido embo awa yai ainda aundo itari adu esisina. Edo aturoda God mi dedegari ge Joseph de tesiri gido yai Judea daginegedo yai Galili ainda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Edo awamane nasi dao Nasaret ainda gundo anumbesitera. Awatedo ge ro peroveta manemi sitera awa bé esisina, “Imo awa Nasaret Embo tara.” ");
INSERT INTO bhg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Edo iji angode John Bapataito Ari Embo emi yai Judea da abu damodamoda gundo dengoro baiari piedo esisina. ");
INSERT INTO bhg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Edo sisina, “Utuda gisijiari aikae gumbira, awatedo itomane jimbo bebegae dodo God da yai wareregewo!” ");
INSERT INTO bhg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Edo embo ami ge eiwa peroveta Isaiah mi iji matuda sisina awa esiri bé esisina: “Embo abu damodamoda aorogateira, ‘Badari da begata dave ewo! Ainda begata dambu darewo pepeta are.’” ");
INSERT INTO bhg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Edo John akuta awa ombarijiari wo kamelo tumi ari awa omundo, bupuri wo aintomi ari awa ainda ipuda jido esisina. Edo ainda indari awa wajina ae abu pika de. ");
INSERT INTO bhg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iji ainde embomai Jerusalem da, Judea yai berarida, edo un Jodani da demodamo berarida, ami idegedo ainda yai maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Edo gundo awamaneda jimbo bebegae karigoro embo ami un Jodani ainda awamane bapataito edo esisina. ");
INSERT INTO bhg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ata iji ainde embo ami Parasi mane ae Sadusi mane de jiwae ainda bapataito ari yaida gupero gido ami sisina, “Imomane awa jimbago jitoma ingege! God mi rirowa piain siya eira awa, nane imomane bapataito ano awa daginegawa ango kotembetewa? ");
INSERT INTO bhg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Imomane bapataito anate jipapa edo gido, itomane ni be dave awa piewo gane. Edo itomane do wareregetewa ango gido awa, imomane bapataito ane. ");
INSERT INTO bhg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nane imondemane tena, God mi ganuma itera eiwa inono tari wasiri budo Abraham da mamai teka ara. Awatedo imomane akuta kotembedo ge mina tara engo eove, ‘Abraham awa mamo natokare, awaembo God natokare yai rirowa piainyae.’ ");
INSERT INTO bhg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Edo iji borokobé emi, God embomai ainkain jimbo bebegaeda dodo wareregae era, awamaneda rirowa piaina. Awa engo embo otomi ni tutuda kapain siya eira. Awatedo ni berari nomi be dave ekae era awa, imo tutuda tai kapari durudo mumuya aro kundo niyaoda augaina. ");
INSERT INTO bhg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Awa gebé, itomane jimbo bebegae dodo God da yai wareregetewa, awatedo imomane un mi bapataito ena. Ata embo nei dá nato amboda gumaina awa na ango ae. Embo awa bajina edo na dave ae. Nane ainda tai woru inono kundo mambari tao ae. Embo ami imomane Asisi Kotopu mi bapataito aina, ");
INSERT INTO bhg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","edo ainda dagi bajina ainda ipami jido kundo gumaina. Ami ainda vedari wheat vero buya edo wotari berari jimundo kundo rorae itari oroda piaina. Ata oen berari jimundo augari niyao matawa aveite isira ainda awaina.” ");
INSERT INTO bhg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ango edo Iesu John mi bapataito arate tedo yai Galili da edo un Jodani da gupusina. ");
INSERT INTO bhg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ata John mi awa gido imo engiregain sisina, “Ro awaembo imo nane bapataito anate gupesi? Nato jipapa awa inemi na bapataito ata.” ");
INSERT INTO bhg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ata Iesu ainde mina sisina, “Boroko ingenane God da jipapa berari awa kera ano bé aina. Awatedo doyo gumbare.” Ango tesiri John awara tedo Iesu bapataito esisina. ");
INSERT INTO bhg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Edo iji ainde John mi Iesu bapataito esiri, imo boraebé unda eriri, edo giwo, utu imonde pirigesiri ine God da Asisi Kotopu ni ribo ango wotedo ainda yai anumbesiri gosisina. ");
INSERT INTO bhg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Edo burigibé ge yavi utuda edo gundo sisina, “Eiwa nato dubobari Mai. Nato dubodave aribé ainda yai.” ");
INSERT INTO bhg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ango edo Asisi Kotopu mi Iesu gisijido visido abu damodamo ainda totorisina, Binei mi imo bawarate. ");
INSERT INTO bhg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Edo Iesu indari indae iji 40 muyae 40 kakara eite sima esisina. Edo ainda amboda imo beji mina burisina. ");
INSERT INTO bhg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ango edo bawari embomi gundo embo ainde sisina, “Imo awa God da Mai gido, ge okain teyo ganuma itera eiwa bread are.” ");
INSERT INTO bhg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ata Iesu mi mina sisina, “God da geda gaiari isira awa, ‘Embo enembomi bread akuta injido wasiribé bari tao ae. Ata ge berari God da beda edo gundo eira awa kera edo, wasiribé budo ara.’” ");
INSERT INTO bhg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ango edo Binei mi Iesu kundo maundo nasi kotopu Jerusalem da esisina, edo Jew embomaida oro kotopu bajina ainda eno ikanebé ikaneda esiri peposisina. ");
INSERT INTO bhg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Edo Binei mi ainde sisina, “Imo awa God da Mai gido, imo akuta kekapunya edo wote. God da geda gaiari isira awa: ‘God mi ge okain tari ainda anelamanemi imo dedegara, edo awamanemi imo ipada jiaro erato ito tai ganumada dainyae.’” ");
INSERT INTO bhg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Edo Iesu mi embo ainde sisina, “God da geda gaiari daedo isira awa, ‘Imo Badari ito God bawote.’” ");
INSERT INTO bhg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Edo tekago Binei mi embo awa kundo peji ikanebé ainda vivisisina. Edo yai berari embomaimi gisijido era awa ae awamaneda taogari de awa Iesu da yai piesiri gosisina. ");
INSERT INTO bhg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Edo ami ainde sisina, “Nane roviravi berari eiwa imonde piana, imo nato yai baongo dadari edo na tumondebain ata gido awa.” ");
INSERT INTO bhg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Edo Iesu mi ainde sisina, “God da geda gaiari isira awa, ‘Imo Badari ito God awa tumondebain edo eyo, edo embo awa akuta kera edo eyo.’ Imo dodo nato gunda mambu, Satan!” ");
INSERT INTO bhg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Edo Binei embo awa dodo mambiri, edo giwo, anelamane gundo Iesu kondade esitera. ");
INSERT INTO bhg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Edo John Bapataito Ari Embo da gitopo embo mi embo awa kundo bundari oroda pipisitera. Edo iji ainde Iesu mi bino awa ingido imo tekago yai Galili ainda egenembesisina. ");
INSERT INTO bhg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ango edo Iesu mi Nasaret nasida gisi maunsisina, edo ainda amboda Kapenium nasida gundo isima edo esisina. Edo Kapenium nasi awa Galili ubutu demonda. Edo yai ainda awa Jew ewowo Zebulun ae Naphtali deda topo. ");
INSERT INTO bhg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Edo Iesu mi yai ainda maundo isima esisina, ge peroveta Isaiah mi matu sisina awa ari bé arate tedo: ");
INSERT INTO bhg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Yai Zebulun ae Naphtali de awa ubutu demonda ae un Jodani da kupo neideda. Yai awa yai Galili doda isira, edo yai ainda Gentile embomai jiwaemi isima edo era. ");
INSERT INTO bhg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Edo embomaida yai ainda muyae doda isima edo era awa, parara bajina gumbiri gera. Edo ainkain betari yai ae ainda duga deda isima edo era, awamaneda yai parara atesira.” ");
INSERT INTO bhg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Edo iji ainde Iesu tuturo edo embomaida yai ge karigeteite tevina, “Utuda gisijiari itomane yai aikae gumbira. Awatedo itomane jimbo bebegae dodo God da yai wareregewo.” ");
INSERT INTO bhg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ango edo Iesu ainto edo Galili ubutu bengida maunteite ami nanonameji tote (2), Simon (Ainda dao nei awa Peter.) ae ainda nameji Andrew de gosisina. Awamane awa wo iro ari embobo, awatedo iji angode awamanemi wo bain monga ubutuda augetero gosisina. ");
INSERT INTO bhg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Edo ami awamanede sisina, “Nato amboda puwo! Nane imomane atopatano gido embomai bave.” ");
INSERT INTO bhg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Edo burigibé awamaneda monga dodo embo awa ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ango edo Iesu yai awa dodo ainto edo maunteite ami nanonameji nei tote (2) gosisina. Awamane awa Zebedee da mamai, James ae John de. Edo awamaneda mamo Zebedee de un ma doda isite awamaneda monga kakapegari awa sirigetero Iesu mi awamane dao sisina. ");
INSERT INTO bhg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Edo boraebé un ma ae awamaneda mamo de dodo embo awa ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ango edo Iesu yai Galili da umbugo berarida maundo gundo eite Jew embomaida benunu oro jiwaeda torido embomai atopaposite gisijiarida bino dave awa karigedo esisina. Edo embo ami embomaida burau ari berari ae karu amburo neide kainde berari de awa gao euri kaviegotora. ");
INSERT INTO bhg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Edo ainda buro babainda bino awa yai Siria berarida arapu esiri, embomaimi awamaneda embo karu ari berari, karu evekara ae memesi de, edo bineimaneda bubundegari ae tamo jipari de, ipatai ambari de, awamane ainda yai kundo gumbero Iesu mi awamane gao esiri kaviegesitera. ");
INSERT INTO bhg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Awatedo embomai jisi babain yai Galili da edo, Nasi Babain Ajigari 10 da, Jerusalem da, yai Judea da edo un Jodani kupo neida, awamanemi Iesu ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Edo Iesu mi embomai jisijisi awa goteite pejida visido anumbesiri ainda ambodani ainda yai guputera. ");
INSERT INTO bhg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Edo imo tuturo edo awamane atopapoteite sisina: ");
INSERT INTO bhg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Embomai ainkainmi awamaneda asisida burau ari God kena awa gido era, God da dubodave awamaneda yai isira. Utuda gisijiari awa awamane topo. ");
INSERT INTO bhg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Embomai ainkainmi dubo vevera edo era awa, God da dubodave awamaneda yai isira. God mi awamaneda yai atutumbedo kondade ari piaina. ");
INSERT INTO bhg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Embomai ainkainmi do netegeteite God da jisida isima edo era awa, God da dubodave awamaneda yai isira. God mi butu berari awamanede piain tarigari sisina. ");
INSERT INTO bhg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Embomai ainkainmi dá embo enembomi indari ae un de udo edo era ango God da wasiri dambu darari awa udo edo era, God da dubodave awamaneda yai isira. God mi ainda wasiri dambu darari awamaneda yai piari beda ara. ");
INSERT INTO bhg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Embomai ainkainmi embo neneida yai do ari piedo era, God da dubodave awamaneda yai isira. God mi awamaneda yai do ari piaina. ");
INSERT INTO bhg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Embomai ainkainmi awamaneda doda kotembari beyae engiregedo era awa, God da dubodave awamaneda yai isira. Awamanemi God gara. ");
INSERT INTO bhg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Embomai ainkainmi béga awaembo buro edo era awa, God da dubodave awamaneda yai isira. God mi awamane awa ainda mamai ae maigagara de taina. ");
INSERT INTO bhg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Iji nonde embo neneimi memesi neide kainde embomaida yai pisido era aindabé awamane awa wasiri dambu darari, God da dubodave awamaneda yai isira. Utuda gisijiari awa awamane topo. ");
INSERT INTO bhg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Aindabé imomane awa nato ambodani, God da dubodave itomane yai isira iji angode embomaimi imomane piari wotari ge tedo, memesi neide kainde itomane yai pisido, ge bebegae jiwae pitawami imondemane tara. ");
INSERT INTO bhg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","God mi itomane tau bajinabé utuda siya esira isira. Awatedo yawa bajinabé tega itae ewo. Imomane gumbae gisida embomaimi memesi neide kainde dá ango peroveta maneda yai piedo esitera, edo imomane peroveta maneda tai dero awa ambo ambo edo ewa. ");
INSERT INTO bhg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Imomane awa kato ango embo enemboda yai. Ata embomaimi katoda gavi awa itae ari gido awa nongo edo aro tekago gavi gumaini? Awa itae. Awatedo kato awa kundo arapada augaro embomi pepeta eite taimi pasido ara. ");
INSERT INTO bhg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Imomane awa ango butu dededa parara. Edo imomane awa nasi bajina peji enoda jiari ango embomaimi onjigari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Dá ango embomaimi keimo ijimbedo ou kuwoda piainyae, ata keimo awa yai ikaneda ekegaro ainda pararami embo berari mando doda awa datemaina. ");
INSERT INTO bhg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Awatedo itomane parara dá ango embomaida yai datembewo, awamanemi itomane buro davegave gido itomane Mamo utuda awa dasiga ore. ");
INSERT INTO bhg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Aodarida o Peroveta maneda Ove Gaiari awa dano sitarate na gumena ango kotembeove. Na ango ain gumbae, ata nane ano bé arate gumena. ");
INSERT INTO bhg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Edo eiwa gebé imondemane tena, utu de butu de awa itae mandae gisida, Aodarida ge saka bé da (1) awa mana itae aina, isiari God mi ainda geda buro berari petugaina. ");
INSERT INTO bhg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Awatedo berari ainmi God da ge okain einda ge saka da (1) dari erigaina, edo embo nenei atopatari wasiri dá ango orote aina gido, God mi imo awa embo sakabé taina utuda gisijiari yaida. Ata berari ainmi God da ge okain awa kera eite embo nenei wasiri dá ango atopataina gido, God mi imo awa embo bajina taina utuda gisijiari yaida. ");
INSERT INTO bhg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aindabé nane imondemane tena, edo itomane wasiri dambu darari awa Aodarida atopapasigari ae Parasi mane deda wasiri dambu darari awa daginegae aina gido, imomane utuda gisijiari yaida mana torawa. ");
INSERT INTO bhg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Imomane awa gari, iji matuda Aodarida atopapasigarimi kaenato apipiye de ewowo de ge eiwa atopapositera, ‘Dato beteure, edo embo da ainmi embo dari betaina gido awa, imo God mi katain eira.’ ");
INSERT INTO bhg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ata nane imondemane tena, berari ainmi ainda namejide sinigambari tepotapo aina gido awa, God mi katain eira. Edo embo da ainmi ainda namejide ‘Imo jiro itae!’ taina awa, Sanhedrin embobomi imo awa katain era. Ata embo da ainmi ainda namejide ‘Dauwa bé!’ taina awa, God mi imo yai niyao matawa aveite isira ainda piain eira. ");
INSERT INTO bhg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Awatedo, ito kando kundo God da rorou piari tenembada piain gupeite awa, ito namejimi imonde sinigambari eira isira awa kotembedo gido, ");
INSERT INTO bhg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ito kando rorou piari tenemba doda dodo ito namejida yai gisi mambuyo. Ango edo ito namejide, ‘Aiya do’ site béga budo tekago egenembedo gundo ito kando God da yai piate. ");
INSERT INTO bhg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Edo ito gitopo embomi buriya nonda tamonda imo katarida piain tari gido, aedade begatada maunsite burigibé embo ainde ge sirigeyo dave are. Ango ae gido, ito gitopo embomi imo katari emboda ipada piari katari embomi imo katedo bundari embode piari imo kundo aundo bundari oroda augari torata. ");
INSERT INTO bhg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eiwa gebé imonde tena, imo bundari oro doda isite ito mina ro inge piatate tesira awa itae piedo imo udegari bata. ");
INSERT INTO bhg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Imomane awa gari, iji matuda Aodarida atopapasigarimi kaenato apipiye de ewowo de ge eiwa atopapositera, ‘Ipuda eote.’ ");
INSERT INTO bhg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ata nane imondemane tena, embo berari ainmi eutu gido ainda tamo bain jipapa edo esira awa, God mi embo awa jimbo beyae matu ainda domi esira awa gira. ");
INSERT INTO bhg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Awatedo ito jisi ipa beda ami rorae ro gido imo jimbo beyae edo eta ango gido awa, jisi awa gurugedo kundo augeyo aimbare. Davebé awa tamo itoda tatari da (1) awa kundo augata, gaegae edo imo jimbo beyae ato God mi ito tamo berari kundo yai niyao matawa aveira ainda augaina. ");
INSERT INTO bhg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Edo ito ipa beda ami rorae ro budo imo jimbo beyae edo eta ango gido awa, kautugedo augeyo aimbare. Davebé awa tamo itoda tatari da (1) awa kundo augata, gaegae edo imo jimbo beyae ato God mi ito tamo berari kundo yai niyao matawa aveira ainda augaina. ");
INSERT INTO bhg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Edo Aodarida atopapasigarimi ge eiwa atopapositera, ‘Embo da ainmi ainda aro dowain edo gido awa, eutu awa dodo mambae gisida ine ainda arode jimbari itae arida ove gaiedo piarate sisina.’ ");
INSERT INTO bhg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ata nane imondemane tena, embo da ainmi ainda aro dosira, ata eutu awa jimbae gisida kombo ari itae ami ainda embo nei jimaina awa, embo ami esiri eutu jimbo ipuda esira. Edo embo da ainmi eutu iu dowari ango awa jimaina, embo awa jimbo ipuda esira. ");
INSERT INTO bhg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tekago, imomane awa gari iji matuda Aodarida atopapasigarimi kaenato apipiye de ewowo de ge eiwa atopapositera, ‘Tarigari pitawami teote, ata ito tarigari Badari da yaida tedo gido kera edo eyo.’ ");
INSERT INTO bhg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ata nanemi imondemane tena, tarigari berari awa tepotapo teove. Aindabé utu awa God da daotari anumba, awatedo tarigari ainda daoda teove. ");
INSERT INTO bhg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Edo butu dede awa God da taida oena apari yai, awatedo tarigari ainda daoda teove. Edo Jerusalem awa God Daotari Bajinada nasi bajina, awatedo tarigari ainda daoda teove. ");
INSERT INTO bhg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Edo ito kopuru tu da (1)da ove ainya ari o ove ingatapari awa wareregari tao ae, awatedo tarigari ito kopuruda daoda teote. ");
INSERT INTO bhg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Iji nonde imomane ge nenei tedo ewa, awa ge embo beyae da yaida edo gundo eira. Awatedo tepo ‘Na ana’ tewo, ko ‘Na ainyae’ tewo. ");
INSERT INTO bhg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Imomane awa gari, Aodarida atopapasigarimi ge eiwa atopapositera, ‘Edo embo da ainmi ito jisi dari beyae aina gido awa, katari embomi ainda jisi dari beyae aina. Daedo embo da ainmi ito ji dari erigaina gido awa, katari embomi ainda ji dari erigaina.’ ");
INSERT INTO bhg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ata nane imondemane tena, embo da ainmi itomane yai buro beyae aina gido, ainda yai mina beyae ainyae. Awarata, embo da ainmi ipa do bereya edo ito opo ipa beda dari gido awa, ito opo ipa andada awa doyo daedo dare. ");
INSERT INTO bhg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Embo da ainmi imo katain jipapa eite ito ombari awa bari gido, ito dademo ombari awa daedo kokumbeyo bare. ");
INSERT INTO bhg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Edo embomi ainda rorae amboka edo ainde daedo kilometre da (1) ainto atate imo jijine tari gido, ine embo awa kondade edo ainda rorae amboka edo ainde daedo kilometre tote (2) ainto eyo. ");
INSERT INTO bhg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Embo ainmi ito yai rorae atega eira, awa pieyo bare. Daedo embo ainmi ito rorae jigamo ain jipapa eira awa, engiregainyae. ");
INSERT INTO bhg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Imomane awa gari, Aodarida atopapasigarimi ge eiwa atopapositera, ‘Nembu ito dubobudo eyo, edo gitopo embo itode sinigambari edo eyo.’ ");
INSERT INTO bhg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ata nanemi imondemane tena, itomane gitopo embobo dubobudo ewo. Embo ainkainmi itomane yaida begá pisido era, God de awamane embo tedogido ewo, ami awamaneda yai ainda ao ari piare. Edo embo ainkainmi imondemane sinigambari edo era, awamane embo jimbo dave edo ewo. Edo embo ainkainmi imondemane ge tepotapo site memesi neide kainde itomane yai pisido era, awamane embo benunu tedo ewo. ");
INSERT INTO bhg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ango edo imomane itomane Mamo utuda da mamai awa. Aindabé ami euri ainda iji embo beyaeda yai ae embo daveda yai de datembedo eira. Edo ami wa piedo eira embo wasiri dambu darari ae embo wasiri dambu darae deda yai. ");
INSERT INTO bhg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Edo inemane embomaimi imomane dubobudo era awa dubobudo ewa, ro awaembo God mi tau dave imondemane piaini? Buro dá ango tax kumbari embobo mi edo era. ");
INSERT INTO bhg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Edo itomane otatawo akuta ategedo awa, imomane embo neneida buro daginegedo ae. Tax kumbari embobomi buro dá ango edo era. ");
INSERT INTO bhg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Itomane Mamo utuda awa wasiri dambu darari berari, awatedo dá ango imomane wasiri dambu darari berari eite isiwo. ");
INSERT INTO bhg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Edo bé gidogogo ewo. Itomane kando embomai rorae isisigaede arapada embomi gorote ango piainyae. Edo ango awa itomane Mamo utuda awa tau itomane mana piaina. ");
INSERT INTO bhg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Awatedo iji ainde imo awamanede kando piato bara awa, arapada karigato giwore. To putedo eote dá embobo iwawa tote (2)demi benunu oroda edo nasi doda eiworo embomaimi dasiga orote jipapa edo era ango. Eiwa gebé imondemane tena, awamaneda tau awa matu bera awara. ");
INSERT INTO bhg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ata imo embomai rorae isisigaededa kando piain jipapa eite gido awa dowato embo da ain buro ro esi awa giure. ");
INSERT INTO bhg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Awaembo ito piari awa onjigedo pieyo. Ango edo ito Mamo imo onjigarida gido eira, ami akuta ito tau awa arapada piari bata. ");
INSERT INTO bhg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Edo imo benunu site gido embobo iwawa tote (2)demi tarago eote. Awamaneda jipapa bajina awa embomaimi awamaneda wasiri dave gorote, awatedo awamane benunu oro doda edo nasi begata umbugoda petedo benunu tedo era. Eiwa gebé imondemane tena, awamaneda tau awa matu bera awara. ");
INSERT INTO bhg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ata imo benunu tain edo gido awa, aundo ito mando jiumbarida torido manguro jido doda, ito Mamo imo jisimi gae, ainda yai benunu teyo. Edo ito Mamo imo onjigarida gido eira, ami ito tau awa arapada piari bata. ");
INSERT INTO bhg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Edo iji nonde imomane benunu site, ge dá awa tekago tekago teove dá embomai God gae ango edo era. Awamanemi kotembedo era awa, ‘Edo nakare benunu tari ge jiwaebé tedo era, God mi natokare benunu tari awa ingido aina.’ ");
INSERT INTO bhg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aindabé itomane Mamo awa gari itomane jipapa rori awa tedogae gisida, imomane awamane ango eove. ");
INSERT INTO bhg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Awatedo benunu engo tewo: ‘Mamo natokare utuda isima edo eta awa, dao ito kotopu tou ore. ");
INSERT INTO bhg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gisijiari ito doyo gumbare. Nakare jipapa ito butu einda ore, dá ouwamanemi utuda edo era ango. ");
INSERT INTO bhg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Namondekare deguta da (1) dowae, indari jipapa edo era awa; iji einde piewasi. ");
INSERT INTO bhg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Edo jimbo bebegae natokare kotembedo dowasi, dá ango nanekare embo neneimi jimbo bebegae ro namondekare edo era awa, kotembedo dodo era. ");
INSERT INTO bhg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Edo bawarida nakare kundo aimbote, ata embo beyae da yai nakare toregewasi. Imo awa natokare Daotari, Goroba Berarida Goroba, awatedo imo iji natopo itari dasiga ore. Awara.’ ");
INSERT INTO bhg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Edo embo neneimi itomane yai jimbo bebegae aro gido kotembedo dowawa awa, Mamo itomane utudami itomane jimbo daedo kotembedo dowaina. ");
INSERT INTO bhg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ata imomane embo neneida jimbo bebegae kotembedo dowae awa gido, Mamo itomanemi jimbo bebegae itomane daedo kotembedo dowainyae. ");
INSERT INTO bhg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ango edo imomane God da yai indari dodo kakara eite gido dombu itomane dá embobo iwawa tote (2)demi awamaneda dombu dubo vevera edo era ango eove. Awamanemi dombu aewa gutedo era awa, embomaimi gido kakara era torote. Eiwa gebé imondemane tena, awamaneda tau awa matu bera awara. ");
INSERT INTO bhg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ata iji nonde imo indari dodo kakara eite gido ito dombu teiedo kopuru tu duwari eyo. ");
INSERT INTO bhg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Edo ango eta ami awa indari dodo kakara ari embomaida yai ae, ata ito Mamo imo jisimi gaeda yai. Edo ito Mamo imo onjigarida gido eira, ami ito tau piari bata. ");
INSERT INTO bhg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","21","“Yai nonda itomane gaiapa isira awa, do itomane awa yai ainda daedo itaina. Awatedo gaiapa imomane embo awa butuda einda dada eove. Butuda dada awa gido, kandoromi kapara, damana gamaina, edo beono embomi bededo torido bara. Ata gaiapa imomane embo awa utuda ounda dada ewo. Utuda dada awa gido, kandoromi kapari tao ae, damana gambari tao ae, edo beono embomi bededo torido bari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Embo enemboda jisi mi kondade euri inono yai berari gido era. Awatedo ito jisi awa ango ito tamoda keimo. Edo ito jisi karu itae gido, rorae berari dave gata. ");
INSERT INTO bhg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ata ito jisi karude gido, rorae berari dave gari tao ae. Awa muyaeda itari ango. Awatedo, edo parara do itoda awa muyae ango gido, imo awa jimbo beyae bajinade! ");
INSERT INTO bhg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Embo da (1)mi badarari tote (2) sima ari tao ae. Embo awa badarari da (1)de sinigambari eite nei dubobudo aina, ko ami badarari da (1) tou eite nei jipapa ae edo aina. Inemane God ae butu gaiapa de sima ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Awatedo imondemane tena, wasiri itomane awaembo kotembari jiwae edo dubo vevera eove, indari edo un ro budo indavi, o ombarijiari ro budo tamoda piavi. Wasiri itomane awa bajinabé God da jisida, indari ango ae; edo tamopisi itomane awa bajinabé God da jisida, ombarijiari ango ae. ");
INSERT INTO bhg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Imomane nimane ikane ima puma edo era awa gidogogo ewo! Awamanemi rorae ve uraede o buroda rorae be kumbaede o rorae dada edo itari oroda piaede. Awarata itomane Mamo utuda ami awamane undedo eira. Itomane tega awa bajinabé God da jisida, tega nimane dá ango ae. ");
INSERT INTO bhg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Embo da ainmi itomane doda ainda wasiri butuda ribori itarate kotembari jiwae edo dubo vevera arimi riboribé ainita? Ango ari tao ae! ");
INSERT INTO bhg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Edo ro awaembo itomane ombarijiari ro budo tamoda piari kotembari jiwaemi dubo vevera edo evi? Kotembedogogo edo giwo arapa are, abuda kokomane nongo nongo edo erido eri awa. Awamane akuta buro okain aede edo ombarijiari gaiaede. ");
INSERT INTO bhg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Awarata imondemane tena, Daotari Solomon da ombarijiari berari ainda jitari dave awa, abu koko dabé ainda jitari davebé dave awa daginegari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Giwo! Edo God mi kiyan butuda erari kokomi giro ari, ata sipo neide awa vededo dungara, God mi imondemane ombarijiari inonobé piaina. Itomane gebé ari awa saka! ");
INSERT INTO bhg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Awatedo kotembari jiwaemi dubo vevera edo teove, ‘Kaena un ro indari?’ o ‘Kaena rorae ro indari?’ o ‘Kaena ombarijiari ro budo tamoda piari?’ ");
INSERT INTO bhg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gentile embomai, God gae, awamanemi rorae berari eiwawa bain edo era, edo Mamo itomane utuda ami matu giuri rorae berari eiwawa jipapa edo ewa. ");
INSERT INTO bhg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ata God da gisijiari ae ainda wasiri dambu darari de awa gisi gain edo ewo! Edo ango eiawo God mi rorae berari eiwawa daedo itomane yai piedo aina. ");
INSERT INTO bhg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Deguta da da ainda bouga isira, awatedo sipo neida bouga gumbari gido kotembari jiwaemi dubo vevera eove. Bouga ro audo gumbari gido awa, imomane iji ainde inono sirigawa. ");
INSERT INTO bhg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Embo nei katove dowo, edo God mi imomane katae doware. ");
INSERT INTO bhg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Edo imomane embo nei katewa gido God mi imomane kataina. Edo imomane tega ro embo neide jigamo edo katewa awa, God tega dá awa jigamo edo imomane kataina. ");
INSERT INTO bhg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Edo ro awaembo imo onyenye saka ito namejida jisida isira awa gido tesi, ata ikuta bajina jisi ikaitoda isira awa gae esi? ");
INSERT INTO bhg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","O nongo edo ine ito namejide engo teta, ‘Do, onyenye saka ito jisida awa pusigane,’ edo ito jisida ikuta bajina isiri? ");
INSERT INTO bhg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Imo embo iwawa tote (2)de! Gisibé awa ito jisi akutada ikuta bajina isira awa teugeyo. Ango edo imo yai dave gosite ito namejida jisida onyenye saka awa pusigate. ");
INSERT INTO bhg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Rorae kotopu awa sinomanede piove. Aindabé ango awo awamanemi wareregedo imomane gamundo usibesi ara. Edo gaegae edo itomane kau awa pumaneda doda augove. Ango awo awamaneda taimi pataro beyae aina. ");
INSERT INTO bhg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Edo jipapa itomane atega ewo, imondemane piari bawa. Itomane jipapa awa gain ewo, edo tambawa. Edo manguroda tatain jivewo, itomane yai manguro pirigaina. ");
INSERT INTO bhg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aindabé berari ainmi God de atega edo eira awa, ainde pieuri budo eira. Edo ainmi ainda jipapa ro God da yai gain edo eira awa, tamundo eira. Edo ainmi God da manguroda tatain jivedo eira awa, God mi embo ainde manguro pirigaina. ");
INSERT INTO bhg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Edo imomane embobo itewa doregari einda doda, mai da (1)mi ainda mamode bread atega ari, ganuma piainita? ");
INSERT INTO bhg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O unwo atega ari awa, piae dodo ainde jimbago piainita? ");
INSERT INTO bhg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Awa dave ae. Imomane awa embo bebegae, ata imomane gari bureite kando dave mamai itomanede pisido ewa. Itomane Mamo utuda ami embo beraride dave edo eira, awatedo embo ainkainmi Mamo de atega edo era awa, awamanede rorae davegave jiwaebé piari bara! ");
INSERT INTO bhg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Awatedo buro ro embo neimi imomane embo orote jipapa ewa awa, inemane awamane embo ewo. Eiwa Aodarida edo Peroveta maneda Ove Gaiari da atopatarida moka. ");
INSERT INTO bhg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Wasiri natopo itarida torari be awa kisisimbari edo ainda begata awa okain, awatedo embo indewae wasiri awa tamundo era. Embo jiwae torari be bebegada torido begata bereyada usibesi ain auntera. Awatedo torari be kisisimbarida toriwo. ");
INSERT INTO bhg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Peroveta mane pitawami dá wo sipu beyae itaede ango itomane yaida gumbara. Awatedo gidogogobé ewo! Awamaneda do awa abu sino gorobade wo nenei tepotapo injido era ango. ");
INSERT INTO bhg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Awamaneda wasiri edo era ami awamaneda do dave ko beyae awa arapa ari gawa. Embomi pasiporo be awa benomada budo erita ko dunga be awa wodei beoda budo eri? Embomi rorae ango awa bainyae. ");
INSERT INTO bhg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Dá ango ni da da berari dave ami be dave ekedo eira, ata ni beyae ami be beyae ekedo eira. ");
INSERT INTO bhg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ni dave ami be beyae ekari tao ae. Daedo ni beyae ami be dave ekari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Edo ni da da berari nomi be dave ekae edo eira gido awa, kapedo niyaoda augedo era. ");
INSERT INTO bhg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Awatedo emboda wasiri edo era ami awamaneda do dave ko beyae awa arapa ari gawa. ");
INSERT INTO bhg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Embo berari ainmi namonde, ‘Badari, Badari’ site isimango utuda gisijiari yai torari tao ae. Ata ainmi nato Mamo utuda ainda jipapa edo eira, ami akuta torari tao. ");
INSERT INTO bhg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Iji ainde embo jiwaemi namonde tara, ‘Badari, Badari, nakare ito daoda ge karigesitera, edo ito daoda asisi bebegae ondetero idegesitera, edo ito daoda wasiri babain jiwae esitera.’ ");
INSERT INTO bhg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Edo iji angode nanemi awamanede ge arapabéda tano gara, ‘Na imomane bé gae. Imomane ge nato kera ae ari embobo, nato yaida dodo eve mambuwo!’ ");
INSERT INTO bhg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Awatedo embo berari ainmi ge nato ingido kera edo eira awa embo dubogari demi ainda mando butu okainda gapusina ango. ");
INSERT INTO bhg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Edo wa wotedo un visido bisi gundo mando ainda ikanade dorisina. Ata mando awa butu okain duredo ainda dasivi piedo gapusina, awatedo durae. ");
INSERT INTO bhg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ata embo berari ainmi nato ge ingido kera ae edo eira awa embo kotembari itaedemi ainda mando popoda gapusina ango. ");
INSERT INTO bhg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Edo wa wotedo un visido bisi gundo mando ainda ikanade desiri durudo usibesibé esisina.” ");
INSERT INTO bhg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Edo Iesu mi ge awara taride embomai atopasido esisina, Aodarida atopapasigari dá ango ae. Awatedo iji ainde Iesu mi ge awa tedo petugesisina, awamanemi ainda atopatari gido korebé edo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Edo iji ainde Iesu awa peji demonda edo wotedo gumbiri embomai jisijisi ami embo awa ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Edo giwo, embo da (1) ginimi tutupegari ami gundo embo ainda doda baongo dadari edo sisina, “Badari, imo jipapa edo gido, na eyo nato dono itae are.” ");
INSERT INTO bhg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ango edo Iesu mi ainda ipa ududugedo embo awa tujido sisina, “Een, na jipapa ena. Dono itae e!” Edo boitebé embo ainda tamoda gini tutupegari itae esisina. ");
INSERT INTO bhg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ainda edo Iesu embo ainde sisina, “Giyo! Na imo eteno kaviegeteta awa, embo neneide teote. Ata mambuyo, imo akuta udugato pirisimi gare. ‘Imo kaviegeteta!’ awa tari embomai goteiaro kando ro Moses mi ge okain sisina awa piate.” ");
INSERT INTO bhg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Edo iji ainde Iesu Kapenium nasida toriri itoroda gisijiari ainda yai gundo kondade arate atega esisina. ");
INSERT INTO bhg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Badari,” embo ami sisina, “Nato buro embo awa mandoda durari isira. Karu ipatai ambari ami kumbari wasiri ae memesi beyaebé bureite durari isima eira.” ");
INSERT INTO bhg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Edo Iesu mi embo ainde sisina, “Na gundo embo awa gao ano kaviegaina.” ");
INSERT INTO bhg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Edo itoroda gisijiarimi mina sisina, “Ango ainyae Badari. Na davera mi imo nato mandoda gumbesiko. Ata tepo gemi teyo, edo nato buro embo kaviegaina. ");
INSERT INTO bhg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Edo daedo na badari natomi gisijido eira, edo ainda ge teuri kera edo ena. Edo dá ango itoro embobo nato tuda itera. Awatedo nane embo eiwa, ‘Mambu,’ tano mamaina. Edo embo neide, ‘Gumbu,’ tano gumaina. Edo nato buro embode, ‘Buro eiwa e,’ tano buro awa aina.” ");
INSERT INTO bhg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Edo iji ainde Iesu ge awa ingido, imo korebé edo embomai imo ambo ambo era awamanede sisina, “Eiwa awa gebé imondemane tena, na Israel embomai berarida yai gebé ari bajina ango awa kakowa edo etena, ata tambae! ");
INSERT INTO bhg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Edo nane imondemane tena, Gentile embomai jiwae iji vitarida edo iji wotarida edo gundo utuda gisijiari yai ainda Abraham ae, Isaac de, Jacob de daedo anumbedo bondoda indari indara. ");
INSERT INTO bhg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ata Jew embomai jiwae awamane embo God mi gisijiari yai siya esisina ainda, awamane mambari tao ae, ata awamane yai muyae arapada ainda augaina. Edo awamanemi ji site ji gambaro kitoru katoru taina.” ");
INSERT INTO bhg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ango edo Iesu mi itoroda gisijiaride sisina, “Imo mambuyo! Dá ango imo gebé eteta awa ito yaida idegaina.” Edo itoroda gisijiarida buro embo awa iji dá ainde kaviegesisina. ");
INSERT INTO bhg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Edo iji ainde Iesu gundo Peter da mandoda torido Peter da imbosi awa karu tamo vevera ari bureite besida durudo isiri gosisina. ");
INSERT INTO bhg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Edo Iesu mi eutu ainda ipa tujijisina. Edo eutu ainda karu tamo vevera ari awa itae esisina. Ango edo eutu awa erido petedo tuturo edo embo awa sima esisina. ");
INSERT INTO bhg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ango edo iji wotesiri ainda turode, awamanemi embomai jiwae bibineida bundari awa Iesu da yai kundo guputera. Edo Iesu mi ge okain mi asisi bebegae awa ondeuri idegedo esitera, edo embomai avekave karu ari awa gao euri kaviegedo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ango edo ge eiwa peroveta Isaiah mi amboda gumaina sisina, awa gundo bé esira: “Embo ami akuta kaenato buburau awa dodo kumbira, edo kaenato karu amburo gao esiri kaviegetera.” ");
INSERT INTO bhg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Edo embomai jisijisi bajina ami doregedo Iesu jinenembetero gido embo ami ainda ambodanide ubutu kupo neida temain ge okain sisina. ");
INSERT INTO bhg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Edo Aodarida atopatari da (1)mi Iesu da yai gundo embo ainde sisina, “Atopatari, imo yai berari nonda mamain esi ainda, na imo ambo ambo ana.” ");
INSERT INTO bhg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Edo Iesu mi embo ainde mina sisina, “Abu sino, awamaneda awari banga to isira, edo ni waside baba edo era, awamaneda awari ma isira, ata Embo da Mai, ainda awari mando topobé itae.” ");
INSERT INTO bhg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Edo ainda ambodani nei ainde sisina, “Badari, gisibé awa na doyo maundo nato mamo goiane.” ");
INSERT INTO bhg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ata Iesu mi embo ainde sisina, “Na ambo ambo e! Doyo betari embomaimi akuta awamaneda betari goiore.” ");
INSERT INTO bhg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ango edo embo awa aundo un ma doda wotesiri ainda ambodani imo ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Edo burigibé bisi bitara goroba ubutuda gupeiri yawata bajina erorisina. Edo ma awa yawatami tuturo edo apuregain esisina. Ata Iesu awa jitao ausina. ");
INSERT INTO bhg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Edo ainda ambodani gundo audedo sitera, “Badari, nakare torege! Kaen betain era!” ");
INSERT INTO bhg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ata embo ami awamanede sisina, “Ro awaembo imomane adu evi? Itomane gebé ari awa saka.” Ango edo embo awa erido petedo bisi ae yawata de ge okain tesiri ubutu damodamobé esisina. ");
INSERT INTO bhg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Edo embobo korebé edo tedo sitera, “Embo eiwa kariwa nongo nongori? Giwo, bisi ae ubutu de ainda ge kera era!” ");
INSERT INTO bhg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Edo Iesu awa ubutu temundo kupo neida gundo Geregesene embomaida yai idegesisina. Edo bibineimi embo tote (2) gisijido ero bebetegari goiari yaida edo idegedo embo awa taputera. Awamane sinigambari bajinabé eite itera, edo embo da ainmi pepeta edo awamane daginegari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Edo awamanemi boitebé aorogasitera, “Imo namondekare ro ain jipapa esi Iesu, God da Mai? Imo gundo nakare memesi okain piain esita katari iji gumbae gisida?” ");
INSERT INTO bhg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Edo yai aikamanago pumane jisi da (1) rorae indeite isiretera. ");
INSERT INTO bhg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Awatedo bibineimi Iesu de atega esitera, “Edo imo nakare ondato idegara awa, nakare awara ato pumaneda yaida aundo torarita?” ");
INSERT INTO bhg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Edo Iesu mi awamanede sisina, “Mambuú!” Edo awamane idegedo maundo pumane jisi da (1) awamaneda doda totoritera. Edo boraebé pumane jisi da (1) berari adujinanga edo tumundo ubutu bengi goninida wotedo unda bebetegesitera. ");
INSERT INTO bhg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Edo embobo ainkainmi pumane sima edo esitera, awamane adu tumundo maundo nasi bajinada torido wasiri ro berari idegesiri awa sitera. Edo daedo embo tote (2) bibineimi kundo gisijioro ima edo esitera, awamaneda yai ro idegesiri awa tetero ingitera. ");
INSERT INTO bhg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ango edo boraebé embomai berari nasi bajinada idegedo Iesu tamain guputera. Edo iji ainde embo awa tamundo gido awamanemi imo awamaneda yai awa dodo aimbarate atega esitera. ");
INSERT INTO bhg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Edo Iesu mada wotedo ubutu be neida temundo ainda nasida gupusina. ");
INSERT INTO bhg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Edo giwo! Embo neneimi embo ipatai ambari topida durari isiri ainda yai budo guputera. Ango edo awamaneda gebé ari gido Iesu mi embo ipatai ambari ainde sisina, “Mai nato, do ito jiyo! Jimbo ito awa kotembedo dotena.” ");
INSERT INTO bhg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aindabé ami ango tesiri, burigibé Aodarida atopapasigari nenei akuta tedo mina gara esitera, “Embo eiwa God da yai ge bebegae sira!” ");
INSERT INTO bhg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Edo Iesu mi awamaneda kotembari gido awa sisina, “Ro awaembo imomane do itomanemi kotembari bebegae kotembetevi? ");
INSERT INTO bhg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tari indawa awa gadaeri, ‘Jimbo ito awa kotembedo dotena,’ ko ‘Erido ainto e’ tari ri? ");
INSERT INTO bhg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ata nane itomane yai ano arapa ari gain ewa, Embo da Mai da awara tari butu einda awa jimboda kotembedo dowari isira.” Ango site embo ipatai ambaride sisina, “Nane imonde tena, Eri! Topi ito ji erari kundo mando itoda mambate.” ");
INSERT INTO bhg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Edo embo awa erido ainda mandoda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aindabé God mi awara tari dá ango embo enemboda yai pipisisina, embo jisijisimi eiwa gido korebé edo God dasiga esitera. ");
INSERT INTO bhg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Edo Iesu yai awa dodo aunteite embo dao Matthew awa tax kumbari oroda anumbedo isiri gosisina. Edo embo ami ainde sisina, “Na ambo ambo e!” Edo Matthew erido embo awa ambo ambo esisina. ");
INSERT INTO bhg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ango edo Iesu, Matthew da mandoda anumbedo, turo rorae indeiri tax kumbari embobo de jimbo beyae ari embobo de jiwae gundo imo ae ainda ambodani deda dada edo rorae injitera. ");
INSERT INTO bhg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Edo Parasi mane eiwa gido awamanemi ainda ambodanide tedogositera, “Ro awaembo itomane atopatarimi ae tax kumbari embobo de jimbo beyae ari embobo de daedo rorae indeiri?” ");
INSERT INTO bhg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Edo ge awa ingido Iesu mi sisina, “Embo karu itaemi siwo ari embo jipapa ae edo era, ata karu embomi siwo ari embo jipapa edo era. ");
INSERT INTO bhg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ata aundo geda moka einda gidogogo ewo: ‘Na do ari udo ena, edo rorou piari ae.’ Na awa embo wasiri dambu darari dao tain gumbae, ata embo bebegae dao tano awamaneda jimbo beyae dodo God da yai wareregorote guputena.” ");
INSERT INTO bhg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ango edo John da ambodani gundo tedogari ainda yai pipisitera, “Ro awaembo nakare iji jiwae veta edo era, edo daedo Parasi mane ango edo era, ata ito ambodani veta ae edo eri?” ");
INSERT INTO bhg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Edo Iesu mi awamanede mina sisina, “Iji ainde jimbari tutu isiari ainda embo topomi mamato arita? Ata deguta awa gumbari jimbari tutu awamaneda yai kundo mamaina, edo ainda amboda awamane veta ara. ");
INSERT INTO bhg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Embo da ain gongo tekada jibigi kundo gongo matu kerari ainda gaiae edo eira. Ango aina awa jibigi tekami gongo matu awa dumbari keredo beyaebé aina. ");
INSERT INTO bhg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dá ango embomi waini teka awa sigi aintomi ari mamatuda gerigae edo era. Ango ara awa waini tekami sigi mamatuda ainto awa mitari sigi kekerigedo usibesi ara, edo waini idegedo butuda wotaina. Ata embomi waini teka awa sigi aintomi ari tetekada gerigaro rorae tote (2) matawa dave itara.” ");
INSERT INTO bhg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Edo iji dá ainde Iesu ge eiwa site isiri benunu oroda badarari gundo ainda yai baongo dadari edo sisina, “Nato gagara iji boroko betesira. Ata gumbu! Ito ipa tamonda piato tekago erare.” ");
INSERT INTO bhg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Edo Iesu erido embo aindeda maunsisina, edo ainda ambodani de daedo. ");
INSERT INTO bhg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Edo burigibé eutu da (1) karu ororo bari duberi 12 awa, ami ainda gunda gundo Iesu da ombari riborida begisi awa tujijisina. ");
INSERT INTO bhg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Eutu ami akuta sisina awa, “Nane dabé embo ainda ombari ribori awa tujiana awa na kaviegana.” ");
INSERT INTO bhg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ango edo Iesu wareregedo eutu awa gido sisina, “Do jiyo, gagara nato. God mi ito gebé ari nato yai pieteta ami imo esiri kaviegeteta.” Edo eutu awa iji dá ainde kaviegesisina. ");
INSERT INTO bhg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Edo Iesu badararida mandoda totoreite embo viriko yavi tari awa putero embo jiwae ji tedo ge sirero gosisina. ");
INSERT INTO bhg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Edo embo ami awamanede sisina, “Imomane dodo mambuwo! Gagara awa betae, ata jitao aveira.” Edo awamanemi embo awa tedojijiritera. ");
INSERT INTO bhg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ata ine embo jiwae awa arapada piesiri idegetero torido aundo gagara awa ipada budo jiri erorisina. ");
INSERT INTO bhg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Edo bino eiwa yai berari ainda arapu esiri embomai ingitera. ");
INSERT INTO bhg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Edo Iesu yai awa dodo aunteiri embo tote (2) jisi akikeimbari embo ainda amboda aunsite aorogatedo sitera, “Nakare do ewasi, David da Mai!” ");
INSERT INTO bhg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ango edo embo awa mando doda toriri embo jisi akikeimbari awa ainda yai guputera. Edo embo ami awamanede sisina, “Imomane buro eiwa nane ari tao awa gebé evita?” Edo awamanemi mina ainde sitera, “Ge bé, Badari.” ");
INSERT INTO bhg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ango tetero gido embo ami awamaneda jisi awa tujido sisina, “Aindabé imomane buro eiwa nane ari tao gebé ewa, imomane gao ari bawa,” sisina. ");
INSERT INTO bhg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Edo awamaneda jisi awa dave esisina. Edo Iesu awamanede ge okain sisina, “Giwoǃ Inemane embo da (1) ande buro eiwa teove.” ");
INSERT INTO bhg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ata awamanemi idegedo embo awa buro ro esiri ainda bino awa yai berari ainda kundo maundo gundo embomaide tetero gositera. ");
INSERT INTO bhg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ango edo iji ainde embo tote (2) Iesu mi gao esira ami idegetero, giwo, embomai neneimi embo da (1) bineimi bundari ge tari tao ae awa kundo Iesu da yai guputera. ");
INSERT INTO bhg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Edo binei ondesiri idegesiri embo ge tari tao ae awa ge sisina. Edo embomai jisijisi awa korebé edo sitera, “Iwata ari engo awa Israel doda kaena gisi gae!” ");
INSERT INTO bhg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ata Parasi mane mi sitera, “Bibineida gisijiarimi Iesu da yai goroba pieuri bibinei ondeuri idegedo era.” ");
INSERT INTO bhg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Edo Iesu nasi berari babain edo babaingaeda torido idegedo maundo benunu oroda torido atopasido esisina. Edo embo ami gisijiarida bino dave awa karigeteite embomaida burau ari edo karu amburo neide kainde bari berari awa gao eiuri kaviegedo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ata iji ainde imo embo jisijisida do buriya ari edo kondade ari itae awa gosisina, awamane awa wo sipumane sima ari embo itae ango. Awatedo embo ami awamane gido do memesi burisina. ");
INSERT INTO bhg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Edo embo ami ainda ambodanide sisina, “Buroda rorae jiwaebé awa tari esira. Ata tokari embomai awa indewae. ");
INSERT INTO bhg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Awatedo rorae tari arida Badari da yai benunu tewo, tokari embomai piari maundo ainda buroda torore.” ");
INSERT INTO bhg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Edo Iesu mi dao tesiri ambodani 12 ainda yai gumbero awara tari pipisisina, awamanemi asisi bebegae ondaro idegorote edo embomai burau ari edo karu amburo neide kainde bari berari awa gao aro kaviegorote. ");
INSERT INTO bhg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Edo aposil mane 12da dao awa eiwa: gisi awa Simon (Ainda dao Peter tedo esitera.) edo ainda nameji Andrew; James, Zebedee da mai, edo ainda nameji John; ");
INSERT INTO bhg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip edo Bartholomew; Thomas edo Matthew, tax kumbari embo; James, Alphaeus da mai, edo Lebbaeus (Ainda dao nei awa Thaddaeus.); ");
INSERT INTO bhg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon awa Keina Embo, edo Judas Iscariot. Judas dá ami Iesu budo ainda gitopo emboboda ipada pipisisina. ");
INSERT INTO bhg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Eiwamane 12 awa Iesu mi piesiri idegetero buro nongo nongo arida ge awamanede sisina: “Gentile embomaida yaida mambove, edo Samaria embomaida nasi babain awa torove. ");
INSERT INTO bhg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ata Israel embomaida yai mambuwo. Awamane awa kariwa dá wo sipumane dadoegari ango. ");
INSERT INTO bhg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Edo imomane maundo ge karigeteite, ‘Utuda gisijiari aikae esira,’ awa tewo gore. ");
INSERT INTO bhg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Edo karu embomai gao ewo kaviegore, edo embo ginimi tutupegari awamane gao ewo dono itae are, edo betari awa jiwo erore, edo bibinei ondewo idegore. Ango edo gao arida mina piari ganu awa benunu teove. God mi imomane tepo kondade esisina, awatedo embomai tepo kondade ewo. ");
INSERT INTO bhg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Embo avekave inemane kondade awa, awamanemi imomane mina kondade orote tena, awatedo gold ta silver ta copper ri itomane bupuri ipuda ainda jido kundo aimbove. Iji ainde imomane pepeta erido kaita da (1) jiove. Edo ombari tote (2), ta tai woru nenei, ta ketu nei ri awa jiove. ");
INSERT INTO bhg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Edo imomane maundo nasi bajina ko nasi saka nonda torido gido, ainda embo dave awa kakowa edo tamundo yai ainda matawa isimango buro itae edo idegewo. ");
INSERT INTO bhg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Edo iji nonde imomane mando da (1) totoreite gido awamaneda yai ategari davemi piewo. ");
INSERT INTO bhg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Edo mando ainda embomaimi imomane ategesite dave baro gido, inemane benunu tewo God mi ainda béga awamaneda yai piarate tena. Ata ango ainyae gido, God mi ainda béga awamaneda yai piainyae, ata itomane yai piaina. ");
INSERT INTO bhg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Edo yai ainda embo ainkain imomane ategesite bae aina gido, ko itomane ge ingae aina gido, mando ko nasi bajina awa dodo maunteite konipo tai itomaneda awa denden ewo. ");
INSERT INTO bhg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Eiwa gebé imondemane tena, iji ainde God embomai berari kataina, rirowa awa emi nasi bajina embomai ainkain itomane ge ajiregetera da yai piaina awa, Sodom ae Gomora nasi embomai deda rirowa awa daginegaina. ");
INSERT INTO bhg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Giwo! Nane imomane pieteno wo sipumane ango idegedo abu sino goroba deda toropuda auntewa. Awatedo dá jimangomi gidogogo edo ima era, ango ewo. Edo dá ni ribo beyae itaede ango ewo. ");
INSERT INTO bhg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ata embomai dave edo goteite iwo! Awamanemi imomane kundo katari emboboda ipada piara, edo imomane awamaneda benunu oro doda vedara. ");
INSERT INTO bhg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aindabé itomane gebé ari nato yai pipisitewa, awamanemi imomane katain kundo gavana mane ae daotegeregari deda dombuda mambara. Ango edo imomane nato bino dave awamane ae Gentile embomai deda yai karigawo gara. ");
INSERT INTO bhg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ata iji nonde imomane awamaneda ipada piaro, God mi imondemane ge ro tavi awa piari tawa. Awatedo ge ro tavi ko nongo tavi, ainda kotembari jiwaemi do buriya eure. ");
INSERT INTO bhg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ge awa inemane akuta tae, ata Mamo itomaneda Asisi mi imomane gisijijieiari ge tawa. ");
INSERT INTO bhg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Edo nanonamejimi awamaneda nanonameji awa katari emboboda yai piaro betarida piara, edo daedo mamonomi awamaneda mamai awa betarida piara. Edo mamaimi awamaneda aimamo ajiregedo awamaneda gitopo emboda ipada piaro daro betara. ");
INSERT INTO bhg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Aindabé itomane gebé ari nato yai isira, embo berarimi imondemane sinigambari ara. Ata embo da ainmi ainda gebé ari nato yaida piedogogo aina, edo imo iji beao arida matawa ango mamaina awa, God mi toregaina. ");
INSERT INTO bhg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Edo iji nonde embomai nasi bajina da (1) ainda ami memesi neide kainde itomane yaida piaro gido, erido dodo nasi bajina neida burigibé mambuwo. Eiwa gebé imondemane tena, Embo da Mai gumbae gisida awa imomane Israel da nasi babain awa torido idegedo itae ae isiawo gumaina. ");
INSERT INTO bhg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ambodanida dero awa ainda atopatarida dero tuda, edo buro emboda dero awa ainda badarida dero tuda. ");
INSERT INTO bhg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Edo embomaimi ambodani sima edo era dá ango ainda atopatari sima edo era gido, ambodani awa dubodave arate, ko embomaimi buro embo sima edo era dá ango ainda badari sima edo era gido, buro embo awa dubodave arate. Edo awamanemi mandoda mamo awa dao Beelzebul tetera gido, awamanemi ainda orobeda embomaide ge bebegae jiwae daginegedo tara! ");
INSERT INTO bhg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Rorae berari apuregari isira awa God mi ari arapa aina, edo rorae berari onjigarida awa arapada piari gara, awatedo embomai adu eove. ");
INSERT INTO bhg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Edo ge ro berari imondemane muyaeda tedo ena awa inemane ijida pararada tewo. Edo daedo ge ro berari imondemane pisipasi teono ingido ewa awa, nasi arapada petedo karigewo. ");
INSERT INTO bhg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Embomaimi tamo daro betaina, ata asisi daro betari tao ae, awatedo awamane adu eove. Awarata God mi asisi ae tamo de awa yai beyae niyao matawa itari aveira ainda usibesi ari tao. Awatedo God adu ewo. ");
INSERT INTO bhg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Inemanemi ni suriri tote (2) awa ganu saka mi oriedo ewa. Edo ni suriri dabé awa butuda durudo betari tao ae, ata Mamo itomane awa gari. ");
INSERT INTO bhg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ata itomane kopuru tu berari awa God da ajijigarida isira. ");
INSERT INTO bhg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Awatedo adu eove. Itomane tega God da jisida awa ni suriri jiwae daginegari. ");
INSERT INTO bhg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Awatedo embo ainmi emboda doda petedo imo awa nato ambodani taina gido awa, nane Mamo nato utuda doda petedo, embo awa nato ambodani tana. ");
INSERT INTO bhg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ata embo ainmi emboda doda petedo, imo awa nato ambodani ae taina gido awa, nane Mamo nato utuda doda petedo, embo awa nato ambodani ae tana. ");
INSERT INTO bhg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Edo nane béga kundo gumain butuda guputena kotembeove. Na béga kundo gumain gumbae ata kasiwo. ");
INSERT INTO bhg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na guputena awa embomai kundo evekara ain, awatedo “‘embo ae ainda mamo de mina mina ara, edo gagara ae ainda ai de mina mina ara, edo mai aro ae ainda imbosi de mina mina ara. ");
INSERT INTO bhg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Edo emboda gitopo embo awa ainda orobeda edo idegara.’ ");
INSERT INTO bhg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Embo ainmi mamo ko ai na daginegedo dubobudo eira awa inono ae nato yai, edo nato ambodani ari tao ae. Edo embo ainmi mai ko gagara na daginegedo dubobudo eira awa inono ae nato yai, edo nato ambodani ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Edo embo ainmi ainda orega kundo na ambo ambo ae awa inono ae nato yai, edo nato ambodani ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Embo ainmi ainda wasiri butuda tamaina awa, dadoegaina. Edo embo ainmi ainda wasiri butuda na awaembo dadoegaina awa, wasiri natopo itari tamaina. ");
INSERT INTO bhg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Embo ainmi imomane ategeteite budo eira awa na budo eira. Edo embo ainmi na ategeteite budo eira awa, embo na piesiri guputena awa budo eira. ");
INSERT INTO bhg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Embo ainmi peroveta ategeteite budo eira aindabé embo awa peroveta awa, perovetada tau awa baina. Edo embo ainmi embo wasiri dambu darari ategeteite budo eira aindabé embo awa wasiri dambu darari awa, embo wasiri dambu dararida tau awa baina. ");
INSERT INTO bhg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Edo embo ainmi eiwamane babaingae einda da (1)de un damodamo akou da (1) piaina aindabé embo awa nato ambodani, eiwa gebé imondemane tena, God mi tau embo ainde piaina.” ");
INSERT INTO bhg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ango edo Iesu ainda ambodani 12 ainde ao darari ge tedo itae edo, imo yai ainda dodo awamaneda nasi babainda aundo embomai atopatain edo God da ge karigain maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Edo John Bapataito Ari Embo awa bundari oro doda isite Keriso da buroda bino awa ingido ainda ambodani tote (2) ainda yai piesiri maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ango piesiri awamane maundo embo ainde sitera, “Imo awa embo God mi piari gumaina sisina ami gumbesita, ko nakare embo nei gain eite sima ari?” ");
INSERT INTO bhg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Edo Iesu mi awamanede mina sisina, “Maundo John de tewo gare ro inemanemi ingewa edo gotewa awa: ");
INSERT INTO bhg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Embomai jisiguba ari awa boroko yai parara gotera, edo baoro bundari awa erido boroko ainto era, embo ginimi tutupegari awa kaviegetera, edo dengoro dundari ge yavi ingera, embo betarida awa tenda erido wasiri bera, edo mapa embomai God da bino dave awa ingera awa. ");
INSERT INTO bhg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Edo God da dubodave emboda yai itaina, ainmi ainda gebé ari nato yaida dowae aina.” ");
INSERT INTO bhg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Iji ainde John da ambodani dodo mauntero, Iesu mi embomai jisijisi bajina ainde tuturo edo John da ge sisina. “Imomane idegedo abu damodamoda maundo rorae ro gain esitevi? Embo do buraude ango opema igi bisimi doreiuri gundo maundo eira awa gain esitevita? Ango ainyae. ");
INSERT INTO bhg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ata ro gain idegedo maunsitevi? Embo ombarijiari virarae tamonda piari awa gain ta? Ango ainyae. Giwo, embomai ombarijiari viraraede daotegeregarida oromandoda isima edo era. ");
INSERT INTO bhg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ata ro gain idegedo maunsitevi? Peroveta rita? Awa gebé nane imondemane tena. Edo embo awa peroveta tepo ae. ");
INSERT INTO bhg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","John eiwa gumaina awa, matu perovetami gagurisina engo: “‘Giwo, na bino piari embo nato piano gisi maundo, ito begata gatedo dave aina.’ ");
INSERT INTO bhg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Eiwa gebé imondemane tena: Embomai nenei berari eutumi engitera ainda doda, embo dabé itae John Bapataito Ari Embo awa daginegari tao. Awarata, embo saka ave utuda gisijiari yai isira awa, imo John daginegari isira God da jisida. ");
INSERT INTO bhg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Edo John Bapataito Ari Embo da ijide edo gundo boroko, God mi embomai gisijijieite matawa gorobade gisi maunteira, edo do jinenegari embomaimi ainda gisijiari awa dubodavede budo era. ");
INSERT INTO bhg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Edo John Bapataito Ari Embo da gumbae gisida, Peroveta mane berari ae Aodari demi God mi embomai gisijiain gumaina awa karigesitera. ");
INSERT INTO bhg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Edo gido imomane na gebé awa, John awa Elijah. Edo peroveta manemi matu ainda gumbari karigesitera. ");
INSERT INTO bhg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Edo imomane dengorode ingari tao gido, ingiwo! Ge ro tena awa, bé gain edo gawa! ");
INSERT INTO bhg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ata embomai iji einda itewa, awamane kariwa nongo tani? Awamaneda iwata kawata awa ango mai babaingaemi nasida oriari yaida anumbedo isite aorogatedo, ");
INSERT INTO bhg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","mina tara edo era engo: “‘Nakare imomane embo viriko putetera, ata imomane ya urae; nakare imomane embo do ari ya tetera, ata imomane ji tae.’ ");
INSERT INTO bhg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Edo begata dá ango John Bapataito Ari Embo gundo embomaide ge karigesisina. Edo embo awa rorae indae edo waini indae gupusina, edo awamanemi imo ajiregedo ge tedo era, ‘Embo eiwa binei ainda doda isira.’ ");
INSERT INTO bhg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Edo Embo da Mai indari ae waini de indeite gumbiri awamanemi tedo era, ‘Giu, embo ouwa rorae indari pu inge edo waini jiwae injido dutari. Tax kumbari embobo ae embo bebegaede otawo edo eira!’ Awarata, edo God da mamaimi ainda dubogari ambo ambo ara, embomaimi God da dubogari awa wasiri dambu darari awa gara.” ");
INSERT INTO bhg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Edo Iesu mi buro babain nasi babainda yai edo esisina, ata awamaneda jimbo bebegae dodo God da yai wareregae. Awatedo imo awamaneda jimbo arapada tuturo edo karigesisina. ");
INSERT INTO bhg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Do ari imomane Koraizin nasida itewa! Do ari imomane Besaida nasida itewa! Edo na nasi Taia ae Saidoni de ounda buro babain ae esitena dá ango itomane yai esitena, awamanemi dubo vevera eite boraebé gongo urigade omundo aewa kopuruda piedo awamaneda jimbo bebegae dodo God da yai wareregae esitera. ");
INSERT INTO bhg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ata nane imondemane tena, katari ijide, God mi rirowa Taia ae Saidoni de piari bara dá ango imondemane daginegedo piaina. ");
INSERT INTO bhg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Edo imomane Kapenium nasida isima edo ewa ami nasi itomaneda dao ikanebé jiowo visido esira. Ata God mi imomane kundo piari wotawa yai Heidis ainda. Edo na nasi Sodom ounda buro babain ae esitena dá ango itomane yai esitena, awamaneda jimbo bebegae awa dodo God da yai wareregae esitera, edo gundo iji einde daedo itae etera. ");
INSERT INTO bhg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Edo nane imondemane tena, katari ijide God mi rirowa saka Sodom embomaida yai piari bara, ata rirowa bajinabé itomane yai piaina.” ");
INSERT INTO bhg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Edo iji ainde Iesu mi engo sisina, “Mamo, utu ae butu deda Badari, roviravi eiwa inemi embomai dubogari de jirogari deda yai arapa ae onjigesiteta awa, mai babaingaeda yai arapa eteto gera. Awatedo imo dasiga ena. ");
INSERT INTO bhg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Gebé, Mamo, roviravi dave engo idegarate jipapa esiteta awa, dá ango eteto idegesira.” ");
INSERT INTO bhg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ainda amboda Iesu God da yai ge eiwa tedo, imo tuturo edo embomaide ge sisina, “Roviravi berari awa Mamo natomi namonde pipisisina. Na awa Mamo da Mai, edo embo da ainmi Mai awa embo bé averi awa gae, da (1)bé Mamo mi akuta goteira. Edo embo da ainmi Mamo awa embo bé averi awa gae, da (1)bé, Mai mi akuta goteira. Edo Mai mi jipapa edo gido, embo neneida yai ari arapa ari Mamo awa embo bé averi awa gara. ");
INSERT INTO bhg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nato yai gumbuwo imomane berari ainkainmi buro okain eite bouga bajina budo ewa, edo nanemi oena apari piano bave. ");
INSERT INTO bhg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na awa do netegari ae tataimbari de, awatedo gumbuwo, nato amboka mendo kundo mambave. Edo nane imomane atopatano itomane asisida oena apari tambave. ");
INSERT INTO bhg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Aindabé nato amboka mendo awa bari tao, edo nato bouga awa edopa, ge awa tetena.” ");
INSERT INTO bhg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ango edo Oena Apari Degutade Iesu ae ainda ambodani de wheat tutu begata barida maunsitera. Edo ainda ambodani beji esiri awamanemi tuturo edo wheat oen totokumbedo budo injitera. ");
INSERT INTO bhg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Edo Parasi manemi awa gido Iesu de sitera, “Giyo! Ambodani itomi ge okain awa Oena Apari Degutade detero erigeteira.” ");
INSERT INTO bhg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ata embo ami awamanede mina sisina, “Imomane David mi nongo esisina awa bé ajigedo gaeta iji angode imo beji mina budo ae ainda embobo de? ");
INSERT INTO bhg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Imo God da oroda torido bread God da jisida piari awa injisina, edo ainda embobo daedo. Ata ge okainda isira awa pirisi manemi akuta indorote tari, awa detero erigesisina. ");
INSERT INTO bhg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Edo daedo imomane Aodarida bé ajigedo gaeta nongo edo Oena Apari Degutade pirisi mane Jew embomaida oro kotopu bajinada doda buro eite Oena Apari Degutada ge okain deoro erigedo eira, ata awamane God mi bekumba ainyae? ");
INSERT INTO bhg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Awarata, nane imondemane tena awa, embo da (1) einda isira awa oro kotopu bajina awa daginegari. ");
INSERT INTO bhg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Imomane God da Ge engo, ‘Na do ari udo ena, edo rorou piari ae,’ kotembewavi. Edo geda moka einda itomane yai arapa aina gido, imomane embo jimbo itae awa bekumba ainyae. ");
INSERT INTO bhg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aindabé Embo da Mai awa Oena Apari Degutada Badari.” ");
INSERT INTO bhg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ango edo Iesu wheat buroda awa dodo maundo benunu oro yai ainda totorisina. ");
INSERT INTO bhg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Edo giwo! Imo embo ipa da (1) ambari awa ainda gosisina. Edo yai dá ainda embo nenei itera ami Iesu bekumba ain ainde tedogositera, “Awara ari Oena Apari Degutade embo gao ari awa isirita?” ");
INSERT INTO bhg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Edo Iesu mi awamanede sisina, “Edo embo da (1) itomane doda ainda wo sipu da (1) Oena Apari Degutade uro ugonubé ainda duraina awa gido, ami jido dumbari vitainita? ");
INSERT INTO bhg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Giwo! Embo enemboda wasiri awa rorae bajinabé, wo sipu dá ango ae. Awatedo awara ari isira. Oena Apari Degutade kaenanemi embo neneide buro dave ara.” ");
INSERT INTO bhg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Edo Iesu mi embo ipa da (1) ambari ainde sisina, “Ipa ito ududuge!” Edo embo ainda ipa da (1) ududugesiri ipa davebé esisina, ipa nei dá ango. ");
INSERT INTO bhg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ata Parasi mane dodo idegedo maundo ge jijiritera, Iesu daro betarate. ");
INSERT INTO bhg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ata Iesu awamaneda ge jirari awa gido imo yai awa dodo maunsisina. Edo embo jisijisi imo ambo ambo esitera ae karu embomai de, edo ami karu embomai berari gao esisina. ");
INSERT INTO bhg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Awarata, ine awamanede sisina, “Na embo averi awa embo neneide teove.” ");
INSERT INTO bhg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Imo ango sisina, ge ro peroveta Isaiah mi sisini, eiwa gundo bé arate. ");
INSERT INTO bhg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Giwo! Eiwa nato buro embo nanemi avigesitena. Nato dubobari edo nato dubodave aribé ainda yai isira. Nanemi ainda yai Asisi nato piana, edo ami Gentile embomaida yai nato katari dave awa karigaina. ");
INSERT INTO bhg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ami ge babaiya edo ae aina ko aorogatedo ae aina, edo nasi arapada ainda ge ikanade tae embomi ingae. ");
INSERT INTO bhg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Embo ami embo burau eira awa sima dave edo aina, edo embo ainmi ainda yai kondade ari bain jipapa eira awa do edo aina, ango edo embo ami nato katari dave yai berarida piari maundo arapu aina. ");
INSERT INTO bhg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Edo Gentile embomaimi awamaneda tumonda ari ainda daoda piara.” ");
INSERT INTO bhg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ango edo embo neneimi embo da (1) bineimi bundari, jisi guba ari edo ge tari tao ae awa, Iesu da yai kundo guputera. Edo ami embo awa gao esiri kaviegesisina. Awatedo imo ge site yai goteite esisina. ");
INSERT INTO bhg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Edo embo jisijisi berarimi wasiri awa gido bé korebakore eite sitera, “Embo eiwa David da Mai rita?” ");
INSERT INTO bhg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ata Parasi manemi ge awa ingido sitera, “Embo awa Beelzebul da buro embo. Edo Beelzebul awa bibineida gisijiari. Awatedo embo eiwa ainda gorobami akuta bibinei awa ondeiuri idegedo era.” ");
INSERT INTO bhg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ata Iesu awamaneda kotembari goteite awamanede sisina, “Edo gisijiarida yai da (1) nomi akuta ainda embomai kupo avigari kupo avigari edo mina dara ara awa, boraebé gisijiarida yaida embo itae ara. Edo nasi bajina o orobe da (1)mi akuta kupo avigari kupo avigari mina dara ara, awamane petari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Edo Satan mi ainda buro embobo ondeuri dodo idegedo era awa, awamane akuta evekara etera itera. Awatedo nongo edo Satan da gisijiari yai petaini? ");
INSERT INTO bhg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ambodani itomane daedo bibinei ondoro idegedo era. Awa Beelzebul da gorobami buro ango edo erita? Ango ae! Awatedo awamanemi ge ro inemane namonde tewa awa ge pitawa ango taro gawa. ");
INSERT INTO bhg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ata God da Asisi mi nato yai goroba pieuri bibinei onono idegedo era. Awatedo God da gisijiari buro itomane yai matu tuturo esira. ");
INSERT INTO bhg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Edo embo da ainmi goroba emboda mandoda tepo torido ainda roviravi bari tao ae, ata gisibé goroba embo awa asimi bundedo awa, ainda roviravi beono aina. ");
INSERT INTO bhg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Embo da ainmi namonde daedo itae awa nato gitopo embo. Edo embo da ainmi namonde daedo embomai kundo doregae edo eira, ami eiuri awamane evekara edo era. ");
INSERT INTO bhg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Awatedo nane imondemane tena, embomaida jimbo berari edo ge bebegae tari berari God da yai awa God mi kotembedo dowaina. Ata embomaimi Asisi Kotopu de ge bebegae tara awa God mi kotembedo dowae. ");
INSERT INTO bhg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Embo da ainmi ge beyae Embo da Mai de taina gido, God mi embo awa kotembedo dowaina. Ata embo da ainmi Asisi Kotopu de ge beyae taina gido, God mi kotembedo dowae, iji boroko edo matawa itaina. ");
INSERT INTO bhg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Edo giwo! Ni isira awa, ainda be ami ainda kariwa piari gawa. Awatedo ni davemi ainda be dave piedo eira, edo ni beyaemi ainda be beyae piedo eira. ");
INSERT INTO bhg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Imomane jitomada mamai! Imomane awa bebegae! Emboda doda ro berari isira awa, ainda be toda edo idegedo eira. Awatedo ge dave tari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Embo davemi awa ainda doda rorae davegave sirigedo dada ari isira. Awatedo rorae davegave awa ainda edo kundo gumaina. Edo embo beyaemi awa ainda doda rorae bebegae sirigedo dada ari isira. Awatedo rorae bebegae awa kundo gumaina. ");
INSERT INTO bhg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ata nane imondemane tena, katari ijide embo berari God da jisida petara. Edo ge berari tepo tedo etera, ro awaembo ge ango tedo eteri awa, iji ainde God de tara. ");
INSERT INTO bhg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Edo imo ge ro tedo eteta ami wareregedo imo kataina. Ango ari God mi imo embo dambu darari taina o imo rirowa bata taina.” ");
INSERT INTO bhg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ango edo Aodarida atopapasigari neneide Parasi mane neneidemi Iesu de sitera, “Atopatari, nakare kariwa da (1) ine piato gain jipapa era.” ");
INSERT INTO bhg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ata Iesu mi awamanede mina sisina, “Wasiri bebegae edo God dubobae ari embomai iji einda itera ami kariwa gain tera. Awamanede kariwa piainyae, ata kariwa dabé peroveta Jonah da awa piano gara. ");
INSERT INTO bhg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonah mi ewa wo bajinada osi doda sima esisina, deguta tamonde (3) edo muyae tamonde (3). Awatedo dá ango Embo da Mai deguta tamonde (3) edo muyae tamonde (3) butu tuda sima aina. ");
INSERT INTO bhg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Iji ainde Jonah mi God da ge karigesiri ingido Nineve embomai awamaneda wasiri bebegae dodo God da yai wareregesitera. Awatedo katari ijide nasi Nineve embomaimi erido petedo embomai iji einda itera awamanede bekumba ge tara. Edo giwo! Embo da (1) einda isira awa bajinabé Jonah daginegari. ");
INSERT INTO bhg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Yai Siba da Daotari Eutu ami Daotari Solomon da dubo ge tedo eira awa ingain ainda yaida edo aikamanabé gupusina. Awatedo katari ijide Daotari Eutu ami erido petedo embomai iji einda itera awamanede bekumba ge taina. Edo giwo! Embo da (1) einda isira awa bajinabé Solomon daginegari. ");
INSERT INTO bhg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Edo iji nonde asisi beyae emboda doda idegedo aina awa, ami maundo yai paimbarida pepeta eite oena apari yai kakowa edo tambae aina. ");
INSERT INTO bhg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ango edo ami taina, ‘Na overegedo nato mando matu dotena ainda mamana.’ Edo imo overegedo gundo ainda mando matuda torido yai wadedo gindedo dave ari gaina. ");
INSERT INTO bhg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ango edo asisi beyaemi asisi nenei bebegaebé, berari 7, awa kundo gundo emboda doda torido itara. Edo embo ainda itari beyaebé gisi gae awa gaina. Awatedo eiwa daedo awa ro embomai bebegae iji einda itera awamaneda yai idegaina.” ");
INSERT INTO bhg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Edo iji ainde Iesu embomai jisijiside ge site isiri, ainda ai ae nanonamejide gundo arapada petedo embo ainde ge tain jipapa esitera. ");
INSERT INTO bhg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Edo embo da (1)mi Iesu de sisina, “Giyo! Ito ai ae nanonameji de arapada petetera isite imonde ge tain jipapa era.” ");
INSERT INTO bhg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ata Iesu mi embo ainde mina sisina, “Ai nato awa averi edo nanonameji nato awa averi?” ");
INSERT INTO bhg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ango tedo imo ipa ujiji ainda ambodanida yai edo sisina, “Giwo! Eiwamane awa nato ai edo nato nanonameji! ");
INSERT INTO bhg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aindabé embo ainmi Mamo nato utuda ainda jipapa edo eira awa nato nameji, ru edo ai, ge awa tetena.” ");
INSERT INTO bhg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Deguta dá ainde Iesu mando dodo idegedo maundo ubutu demonda anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Edo embomai jisijisi bajina doregedo imo jinenembesitera. Awatedo imo un mada visido ainda anumbesiri embomai jisida awamane berari doregedo un bengida pepositera. ");
INSERT INTO bhg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ango edo imo rorae jiwae awa eniya gemi awamane atopaposisina. Edo atopaposite tedo sisina, “Giwo, buro embo da (1)mi rorae vero purara piain kundo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Edo imo vero purara pipisiri vero nenei begata beda duduritera. Awa nimi gundo injitera. ");
INSERT INTO bhg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Edo nenei ganuma gajida duduritera edo ainda butu puruta ae, awatedo boraebé eroritera. ");
INSERT INTO bhg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ata iji visido veverami gaiesiri ambuye esitera. Edo awamaneda besinya butu tuda wotae, awatedo mumuya esitera. ");
INSERT INTO bhg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Edo vero nenei awa kurere teoroda duduritera, edo kurere erido ami ipuda engoegetero ginene esitera. ");
INSERT INTO bhg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ata vero nenei butu daveda duduritera awa davebé erido be ekitera, nenei jiwaebé (100), nenei jiwae (60), nenei (30). ");
INSERT INTO bhg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Edo imomane dengorode ingari tao gido, ingiwo! Ge ro tena awa bé gain edo awa gawa!” ");
INSERT INTO bhg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ango edo ambodani Iesu da yai gundo imonde sitera, “Ro awaembo imo embomaida yai eniya gemi tedo esi?” ");
INSERT INTO bhg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Edo ami ge mina awamanede sisina, “Aindabé utuda gisijiarida gebé onjigari awa ano arapa ari gawa, ata awamaneda yai ano arapa ae. ");
INSERT INTO bhg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aindabé embo ainmi rorae ro isira awa, jiwae piaina, edo daginegedo bajinabé baina. Ata embo ainmi rorae ro itae awa, saka ro ainda yai isira awa dodo baina. ");
INSERT INTO bhg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aindabé awamane jisimi nato buro gido era ata ainda mokabé gae, edo awamane nato ge ingido era ata ingae, edo ainda atopatari gae arapa ae, awatedo nane awamanede eniya gemi tedo ena. ");
INSERT INTO bhg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Edo ge awa peroveta Isaiah mi matu awamaneda daoda sisina awa bé eira. Edo ainda ge awa engo: ‘Imomane nato ge awa ingawa, ata ingeite mana arapa ari gawa. Edo nato buro awa gawa, ata goteiawo, ainda mokabé mana gawa. ");
INSERT INTO bhg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Aindabé embomai einda do awa okain edo engiregesitera, edo awamaneda dengoro dunjitera, edo awamanemi awamaneda jisi akeimbesitera, awatedo ge awa tetena. Awarata, edo awamane ango ainyae, awamaneda jisimi nato buro awa arapa ari gara, edo awamaneda dengoromi nato ge arapa ari ingara, edo awamaneda do pirigedo geda mokabé gara, edo awamaneda jimbo dodo nato yai wareregaro, edo nanemi awamane gao ano kaviegara.’ ");
INSERT INTO bhg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ata imomane jisimi buro awa gotewa edo itomane dengoromi ge awa ingewa, awatedo God da dubodave itomane yai isira. ");
INSERT INTO bhg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aindabé eiwa gebé imondemane tena, iji matuda peroveta mane jiwae edo embomai wasiri dambu darari, awamane jisimi ro inemane gido ewa awa gain jipapa esitera ata gae, edo dengoromi ro inemane ingido ewa awa ingain jipapa esitera ata ingae. ");
INSERT INTO bhg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Awatedo ingiwo! Eniya ge vero purara piari embo ainda moka awa engo: ");
INSERT INTO bhg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Embo ainmi gisijiarida ge awa ingido arapa ae edo eira awa ango butu begata beda vero duduritera ainda. Ge awa emboda doda durudo eira, ata embo beyaemi gupeite ainda doda burigi kundo maundo eira. ");
INSERT INTO bhg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Edo embo nei awa ango butu ganuma gajida vero duduritera ainda. Embo emi ge awa ingeite boraebé yawade budo eira. ");
INSERT INTO bhg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ata ge awa ainda doda dave edo wotae, awatedo iji tupo akuta imo ge awa kera edo eira. Edo iji nonde ge awa kera eiuri buriya gumburi o ainda yai memesi neide kainde embomi pioro burigibé durudo eira. ");
INSERT INTO bhg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Embo nei awa ango butu vero kurere teoroda duduritera ainda. Embo emi ge awa ingido eira. Ata butu roraeda kotembari jiwaemi ainda do buriya edo eira, edo ganu jiwae dada arida kotembarimi imo udumbedo eira. Awatedo kotembari angogomi erido ge awa engoegetero ginene eiworo imo be ekae edo eira. ");
INSERT INTO bhg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ata embo nei awa ango butu dave vero duduritera ainda. Embo emi ge ingido ainda moka arapa euri gido eira. Edo imo be dave edo ekesite piedo eira, nenei jiwaebé (100), nenei jiwae (60), edo nenei (30).” ");
INSERT INTO bhg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Edo Iesu mi awamaneda yai eniya ge nei sisina: “Utuda gisijiari awa engo. Embo da (1)mi rorae vero dave kundo ainda indari buroda purara pipisisina. ");
INSERT INTO bhg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ata muyaede embomai berari jitao aveite itero buro tutuda gitopo embo gupusina, edo ami vive beyae awa wheat teoroda purara piedo dodo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Edo amboda wheat vero awa erido bajina edo be tuturo edo ekero, vive beyae awa daedo erido arapa esitera. ");
INSERT INTO bhg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ango edo buro embobo gundo buro tutude sitera, ‘Badari, imo vero dave akuta buro itoda purara pipitata. Nongo edo vive beyae buro ainda iteri?’ ");
INSERT INTO bhg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Edo embo ami awamanede mina sisina, ‘Gitopo embomi buro eiwa eutara.’ “Edo buro embobomi ainde tedogositera, ‘Imo nanekare maundo vive awa utorote jipapa esita?’ ");
INSERT INTO bhg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ata ami ge mina sisina, ‘Ango ainyae. Gaegae edo inemane vive beyae awa usite wheat daedo utawa. ");
INSERT INTO bhg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Dowo, tote (2) matawa inonoda badore. Edo maundo tokari iji ainde nanemi tokari embobode tano gara, “Vive bebegae awa gisi utedo sindari berari ewo, edo niyaoda dungave. Ata wheat awa dada ewo, nato rorae itari oroda kundo gumbave.” ’” ");
INSERT INTO bhg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ango edo Iesu mi awamanede eniya ge nei sisina: “Utuda gisijiari awa masitet vero engo. Vero awa embo da (1)mi kundo maundo ainda buroda urisina. ");
INSERT INTO bhg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Masitet vero awa nya vero nenei ango ae. Awa saka maibé. Ata iji nonde ami erido bajina aina awa, buroda nya nenei awa daginegedo ni ipu piedo papatu gataina. Awatedo ni waside ami baba edo gundo ainda papatuda ma piara.” ");
INSERT INTO bhg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Edo Iesu mi daedo eniya ge nei awamaneda yai sisina: “Utuda gisijiari awa bread badari siwo engo. Eutu da (1)mi ou bajina palawami beda arida bread badari siwo saka awa baige esisina. Edo siwomi esiri palawa berari bajido duga esisina.” ");
INSERT INTO bhg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Rorae eiwa berari Iesu mi eniya gemi embo jisijiside sisina. Imo ge da (1) nondawa tepo tae, ata berari eniya gemi awamanede tedo esisina. ");
INSERT INTO bhg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ango edo ge eiwa perovetami amboda gumaina sisina, awa gundo bé esira: “Nane eniya ge jigamo ana, Nane ge ro onjigesitena butu gambae gisida awa karigano gawa.” ");
INSERT INTO bhg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Edo Iesu embo jisijisi awa piesiri dodo mambero mando doda totorisina. Edo ainda ambodani gundo ainde sitera, “Vive beyae ami buroda eroritera, ainda eniya geda mokabé awa namondekare tewasi arapa ari gore.” ");
INSERT INTO bhg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Edo Iesu mi awamanede ge mina sisina, “Embo vero dave purara piedo eira awa Embo da Mai. ");
INSERT INTO bhg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Edo indari buro awa butu berari. Vero dave awa embomai God mi gisijido eira. Ata vive beyae awa embomai embo beyaemi gisijido eira. ");
INSERT INTO bhg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Edo gitopo embo vive beyae purara pipisisina awa Binei. Edo tokari iji awa iji beao arida, edo tokari embobo awa anelamane. ");
INSERT INTO bhg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Awatedo dá tokari embobomi vive bebegae dada edo niyaoda dungedo era ango, anelamanemi iji einda beao arida iwata ango ara. ");
INSERT INTO bhg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Embo da Mai mi ainda anelamane piari idegedo maundo awamanemi rorae bebegae berari ainda gisijiari yaida itera, edo embomai ainkainmi wasiri bebegae edo era ainde awa dada ara. ");
INSERT INTO bhg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ango edo anelamanemi awamane augaro yai beyae niyao matawa aveite isira ainda mambara. Edo yai ainda ji site ji vegeiaro kitoru katoru taina. ");
INSERT INTO bhg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Edo embomai wasiri dambu darari awa ijimi parara datembedo eira ango, awamanemi parara datembara awamaneda Mamo da gisijiari yaida. Edo imomane dengorode ingari tao gido, ingiwo! Ge ro tena awa bé gain edo awa gawa! ");
INSERT INTO bhg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Edo daedo, utuda gisijiari awa engo gaiapa onjigari buroda doda isinesina. Iji da (1)de embo da (1)mi gaiapa awa tapusina, edo ami tekago onjigesisina. Ango edo imo yawa eite maundo ainda rorae berari piesiri embo neimi oriedo ganu pietero kundo maundo buro awa ine oriesisina. ");
INSERT INTO bhg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Edo daedo, utuda gisijiari awa engo origarori ari embo da (1)mi kau darigabé kakowa edo esisina. ");
INSERT INTO bhg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Edo iji ainde imo kau da (1) tega ikanebé tamundo, ami maundo ainda rorae berari piesiri embo neimi oriedo ganu pietero kundo maundo kau awa ine oriesisina. ");
INSERT INTO bhg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Edo daedo, utuda gisijiari awa ango wo bararida monga. Iji da (1)de wo iro ari embo neneimi awamaneda monga ubutuda augetero un wo neide kainde monga doda ekitera. ");
INSERT INTO bhg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Edo monga awa womi beda esiri, wo iro ari embobomi dumbero gundo korada esisina. Ango edo awamane anumbedo wo davegave awa doregedo kambia bajina neneida sisiritera, ata bebegae awa augesitera. ");
INSERT INTO bhg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Awatedo iji beao arida, iwata ari engo idegaina. Anelamanemi gundo wasiri bebegae ari embomai avekave embomai wasiri dambu dararida teoroda itera awa kundo evekara ara. ");
INSERT INTO bhg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ango edo augaro yai beyae niyao matawa aveite isira ainda doda mambara. Edo yai ainda ji site ji vegeiaro kitoru katoru taina.” ");
INSERT INTO bhg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Edo Iesu mi ainda ambodanide tedogosisina, “Imomane rorae berari eiwa gewo arapa esirita?” Awamanemi embo ainde mina sitera, “Een Badari, nakare arapa esira.” ");
INSERT INTO bhg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Edo ami awamanede ge sisina, “Awa dave, awatedo Aodarida atopapasigari berari da da utuda gisijiarida atopatari bira, awa ango embo mando tutumi ainda roviravi itari yaida gaiapa teteka ae mamatu de kundo idegedo eira.” ");
INSERT INTO bhg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Edo iji ainde Iesu eniya ge eiwa piedo itae edo yai ainda awa dodo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ango edo imo ainda nasi topobéda gundo, tuturo edo awamaneda benunu oroda embomai awa atopaposisina. Edo awamane korebé edo sitera, “Embo emi dubogari eiwa ae buro babain ari eiwa de yai nonda biri? ");
INSERT INTO bhg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Eiwa oromando ari emboda mai rita? Awa gebé. Edo ainda aida dao Mary tedo era awa rita? Gebé. Edo ainda nanonameji awa James, Joses, Simon ae Judas de rita? Gebé. ");
INSERT INTO bhg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Edo ainda ruaimono berari awa kaenamonde einda iterita? Een, gebé. Embo emi rorae berari eiwa yai nonda biri?” ");
INSERT INTO bhg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Awaembo awamanemi imo jipapa ae esitera. Ata Iesu mi awamanede sisina, “Peroveta awa yai neneida tou edo era. Ata ainda nasi topobé doda edo ainda orobe doda awamanemi imo tou ae edo era.” ");
INSERT INTO bhg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Edo awamaneda gebé ari ainda yai piae, awatedo ami yai ainda buro babain jiwae ae. ");
INSERT INTO bhg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Edo iji ainde, yai Galili da daotari Herod mi Iesu da buroda bino awa ingisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Edo ainda buro embobode sisina, “Eiwa John Bapataito Ari Embo. Imo bebetegarida yai edo tekago erira, awatedo buro babain arida goroba ainda yai buro edo eira.” ");
INSERT INTO bhg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Iji gisi Herod mi ainda nameji Philip da aro, Herodias awa, ipuda jipusina. Edo John mi Herod de sisina, “God da ge okain tari isira awa, ‘Imo namejida aro jimainyae.’” Awatedo Herod mi embo awa jido bundedo kundo bundari oroda pipisisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Edo Herod da jipapa awa John dari betaina. Awarata embomai jiwaemi John awa peroveta gebé edo era, awatedo awamane adu esisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ata Herod da engari ijida bondo ainde Herodias da gagarami awamaneda doda ya uriri Herod dubodavebé dave esisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Awatedo imo tarigari okain gagara ainde sisina, “Imo rorae ro bé jipapa esi awa tato gido imonde piana.” ");
INSERT INTO bhg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ango tesiri ainda aida jipapa isira awa goteite ami sisina, “John Bapataito Ari Emboda kopuru teoda namonde pie einda.” ");
INSERT INTO bhg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Edo daotari awa dubo vevera esisina, awarata, ainda engari ijide bondoda embomai anumbesitera ainda jisida edo tarigari okain sisina, awatedo John da kopuru awa gagarada yai piarate ge okain sisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ango tesiri ainda embo maundo bundari oroda John da dubo kapisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Edo John da kopuru teoda piedo kundo gundo torido gagarade piesiri budo ainda aida yai kundo gupusina. ");
INSERT INTO bhg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ango etero John da ambodani gundo ainda tamo kundo maundo goitera, edo awamane maundo Iesu tetero gosisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Edo iji ainde Iesu ge awa ingido yai awa dodo un made yai embo itae ainda imo akuta maunsisina. Ango esiri embo jisijisi nasi babainda ge awa ingido taimi omboda imo ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Edo un ma denembetero Iesu dodo wotedo papoda petedo embo jisi bajina awa gido imo awamaneda yai do memesi burisina. Edo awamaneda karu embomai gao esiri kaviegesitera. ");
INSERT INTO bhg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Edo iji wotesiri ainda turode, ainda ambodani gundo embo ainde sitera, “Yai eiwa abubé. Iji itae esira. Awatedo embo jisijisi pieyo maundo nasi babaingaeda torido awamane akutada indari rorae gido oriore.” ");
INSERT INTO bhg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ata Iesu mi awamanede sisina, “Awamane yai eve mambari jipapa ae ena. Inemane indari piewavi indore.” ");
INSERT INTO bhg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ango tesiri awamanemi embo ainde sitera, “Natokare yai bread ipa da (5) ae un wo tote (2) de akuta awa itera.” ");
INSERT INTO bhg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Edo ami sisina, “Awara, awawa nato yai kundo gumbuwo einda.” ");
INSERT INTO bhg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ango edo imo embo jisijiside ge tesiri kinyada anunumbetero, bread ipa da (5) ae un wo tote (2) de awa kundo jisi ikane utuda edo ategari God da yai pisina. Edo bread engegegedo ambodanide pieuri awamanemi embo jisijiside kando edo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ango etero awamane berari injido inonobé esitera. Edo awamane erido indari itoto doturitera awa sirigedo kanjia berari 12 sirero beda esisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Edo embobo indari injitera awa ajijigari berari 5,000 ango. Awamane demonda, eutumai de mai babaingae de awa ajijigae, ata awamane daedo indari awa injitera. ");
INSERT INTO bhg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Edo boraebé Iesu mi ge tedo, ainda ambodani un mada sirido imo dodo gisi ubutu kupo neida maunteiaro, imo embo jisijisi awa ategari mamborote sisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ango edo imo embo jisijisi ategesiri maunsitera. Edo ainda amboda, imo akuta pejida visido benunu tain maunsisina. Edo imo akuta ainda isiri turo jiriri muyae gupusina. ");
INSERT INTO bhg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ata iji angode ma ubutu toropuda matu mambiri bisi okain mi ma awa pepeda doreite mina mina esiri ubutu yawata eroreiri ma begino jigino esisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ango edo sipo muyaede Iesu wotedo awamaneda yai ubutu tamonda ainto edo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Edo imo ubutu tamonda ainto edo maunteiri ambodanimi gido awamane dobibi ero sitera, “Ouwa etemi!” Ango tedo adu eite aorogasitera. ");
INSERT INTO bhg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ata Iesu mi burigibé awamanede sisina, “Na awara. Adu eove! Goroba buwo!” ");
INSERT INTO bhg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Edo Peter mi mina sisina, “Badari, imo bé gido awa, tewasi na un tamonda ainto edo ito yai gumane.” ");
INSERT INTO bhg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ango tesiri, Iesu mi sisina, “Gumbu.” Edo Peter un ma doda edo dodo wotedo un tamonda ainto edo Iesu da yai mamain esisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ata iji ainde bisida goroba okain awa goteiri adu edo tuturo edo unda wowoteite aorogasisina, “Badari, na torege!” ");
INSERT INTO bhg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Edo burigibé Iesu ainda ipa ududugedo piedo Peter budo ainde sisina, “Ito gebé ari nato yai awa saka! Ro embo itadaita etesi?” ");
INSERT INTO bhg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Edo awamane un ma doda vitero awa, bisi itae esisina. ");
INSERT INTO bhg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ango esiri ambodani un ma doda awa gundo imo tumondebain eite sitera, “Gebé, imo awa God da Mai.” ");
INSERT INTO bhg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ango edo awamane ubutu temundo kupo neida yai Genesaret da denembesitera. ");
INSERT INTO bhg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Edo embo yai ainda ami Iesu kariwa gido awamanemi ge pietero yai berari ainda demonda embomai itera awa. Edo awamanemi ingido awamaneda karu egeregari berari kundo ainda yai guputera. ");
INSERT INTO bhg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Edo Iesu de atega esitera awara ari gido karu embomaimi ainda ombari ribori begisi awa tujiorote. Edo berari ainkain mi tujijitera awa kaviegari buritera. ");
INSERT INTO bhg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Edo Aodarida atopapasigari ae Parasi mane demi Jerusalem edo Iesu da yai gundo tedogari pipisitera, ");
INSERT INTO bhg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ro awaembo ambodani itomi atopatari kaenato ewowo gawowoda awa deoro erigedo eiri? Awamane rorae indae gisida awamaneda ipa teiae rorae injido era.” ");
INSERT INTO bhg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Edo Iesu mi awamanede mina sisina, “Ro awaembo imomane daedo itomane ewowo gawowoda atopatari awa ambo ambo eite God da ge okain awa deowo erigedo eiri? ");
INSERT INTO bhg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God mi ge okain sisina awa, ‘Ito mamo ae ai de tou edo eyo,’ edo ‘Embo ainmi mamo o ai begá aina, embo awa daro betaina.’ ");
INSERT INTO bhg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ata inemane tedo ewa awa, embo da ainmi ainda mamode o aide taina, ‘Na kando imonde piain kotembetena, ata rorae awawa God da yai piain matu tarigari tetena,’ ");
INSERT INTO bhg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","embo awa ainda mamo o ainda ai inono tou ainyae. Awatedo inemane atopatari ewowo gawowo itomaneda ami God da ge okain siredo etewa. ");
INSERT INTO bhg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Imomane awa embobo iwawa tote (2)de! Edo Isaiah mi itomane iwata kawata gido gebé itomane daoda sisina, ");
INSERT INTO bhg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Embomai eiwa awamaneda bemi na dasiga edo era, edo awamaneda gemi na tou eite tedo era, ata awamaneda do nato yai awa aikamanabé. ");
INSERT INTO bhg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Awamane nato ge okain dodo embo enemboda piari awa atopasido era, Awatedo awamaneda tumondebain ari nato yai awa pitawa.’” ");
INSERT INTO bhg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Edo Iesu embo jisi da (1) awa dao tesiri ainda yai gumbero awamanede sisina, “Imomane ge eiwa tana awa ingiwo edo gari buwo. ");
INSERT INTO bhg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Rorae ro emboda beda torido eira, ami mana ari embo awa dono aina God da jisida. Ata ro emboda beda edo idegedo eira, ami euri embo awa dono edo eira.” ");
INSERT INTO bhg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Edo ainda ambodani gundo Iesu de sitera, “Imo goteta awa Parasi mane ge eiwa ingido sinigambari eterita?” ");
INSERT INTO bhg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ata imo ge mina sisina, “Rorae berari awa nato Mamo utuda ami urae gido awa da da ae besinya deda utugaina. ");
INSERT INTO bhg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Parasi mane awa dowo. Awamane awa jisiguba ari, awatedo awamanemi jisiguba ari embo nenei gisijido era. Edo jisiguba ari da (1)mi jisiguba ari nei gisijiaina gido awa, aedade tote (2) matawa maundo uroda durara.” ");
INSERT INTO bhg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Edo Peter mi embo ainde mina sisina, “Eniya ge einda moka awa natokare yai tewasi arapa are.” ");
INSERT INTO bhg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ango tesiri Iesu mi awamanede tedogosisina, “Ae! Imomane daedo matawa ge eiwa gari tao ae ta? ");
INSERT INTO bhg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Imomane matawa gain darevita? Rorae da da berari beda torido obogeda maundo eira awa, dé eoro idegedo eira. ");
INSERT INTO bhg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ata rorae ro beda edo idegedo era awa, emboda dobéda edo gundo era. Edo rorae ami eoro embo awa dono edo eira God da jisida. ");
INSERT INTO bhg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Rorae ro dobéda edo idegedo era awa kotembari bebegae, dari betari, ipuda ari, jimbae gisida kombo ari, beono ari, bekumba pitawa tari edo ge bebegaemi embo nenei dari, awatedo na ge awa tetena. ");
INSERT INTO bhg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Rorae emi eoro embo dono edo eira God da jisida. Ata ipa teiae rorae injido eira ami mana ari embo awa dono aina.” ");
INSERT INTO bhg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ango edo Iesu yai awa dodo idegedo nasi babain, Taia ae Saidoni de, ainda yai maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Edo giwo, Keinan eutu da (1) yai ainda edo gundo aorogatedo ainde sisina, “O Badari, David da Mai, na do ewasi! Nato gagara bineimi beyaebé bundesiri isira.” ");
INSERT INTO bhg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Edo imo ainda ge ingisina, ata eutu ainde ge da (1) ro tae isiri ainda ambodani gundo imonde atega edo esitera, “Eutu ami aorogasite kaena ambo ambo eira, awatedo eutu awa pieyo mambare.” ");
INSERT INTO bhg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ata Iesu mi mina sisina, “Na awa Israel da mandoda sipumane dadoegari akuta awamane embo God mi piesiri guputena.” ");
INSERT INTO bhg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Edo eutu awa gundo ainda doda baongo dadari edo sisina, “Badari, na kondade ewasiǃ” ");
INSERT INTO bhg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ata Iesu mi ge mina sisina, “Mamaida bread kundo sino mamaida yai augana awa dave ae.” ");
INSERT INTO bhg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ata eutu mi sisina, “Gebé, Badari, awarata sino mamaimi onyenye dowari wotari awamaneda badarida tenemba dutuda injido era.” ");
INSERT INTO bhg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Edo Iesu mi ainde mina sisina, “O eutu, ito gebé ari awa bajina. Udo ito awa God mi piari bata.” Edo ainda gagara awa iji dá ainde burigibé kaviegesisina. ");
INSERT INTO bhg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ango edo Iesu yai awa dodo Galili ubutu bengida pepeta edo maunsisina. Edo pejida visido yai ainda anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Edo embo jisijisi bajina ainda yai gundo baoro bundari, jisiguba ari, ge darari, embo kambode, edo nenei jiwae awa, awamanemi kundo gupeite Iesu da taida pietero ami gao esiri kaviegesitera. ");
INSERT INTO bhg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Edo iji ainde embomai ami embo ge darari awa ge tera, embo kambode awa kaviegari bera, baoro bundari awa erido ainto era, edo jisiguba ari awa jisi gundedo yai gotera awa gido, awamane korebé esitera. Edo awamane Israel da God awa dasiga esitera. ");
INSERT INTO bhg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Edo Iesu ainda ambodani dao tesiri gumbero awamanede sisina, “Embomai jiwae eiwa gundo namonde daedo eite deguta tamonde (3) etera, edo awamane rorae ro indara awa itae. Awatedo na awamane embo do memesi burena. Edo nane awamane bejide piano mambara awa, maunteite beji jisivi ari durara. Awatedo na ango ari jipapa ae ena.” ");
INSERT INTO bhg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Edo ainda ambodanimi ainde mina sitera, “Yai nonda kaenane indari inono budo embo jiwaebé eiwa undari? Yai eiwa abubé.” ");
INSERT INTO bhg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ango tetero Iesu mi mina sisina, “Itomane yai bread nandogo isiri?” Edo awamanemi mina sitera, “Natokare yai bread 7 ae un wo babaingae indewae de itera.” ");
INSERT INTO bhg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Awatedo Iesu mi tesiri embo jisijisi awa butuda anunumbesitera. ");
INSERT INTO bhg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Edo imo bread 7 ae un wo de kupeite ategari God da yai piedo rorae awa budo engegegedo ainda ambodanide pieuri ambodanimi embomaide kando kando edo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ango etero awamane berari injido inonobé esitera. Edo awamanemi itoto doturitera awa sirigedo kambia babain berari 7 sirero beda esisina. ");
INSERT INTO bhg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Edo embo ajijigari nandogo indari injiteri awa berari 4,000. Edo eutumai ae mai babaingae de awa ajijigae. Ata awamane daedo indari awa injitera. ");
INSERT INTO bhg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Edo ainda amboda, Iesu embo jisijisi ategedo piesiri mambero imo un mada visido yai Magadala da maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ango edo Parasi mane de Sadusi mane demi Iesu da yai gundo bavedo gain tedo utuda kariwa da (1) awamaneda yai inemi piarate tedogositera. ");
INSERT INTO bhg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ata Iesu mi awamanede mina sisina, “Iji da da turo jiruri inemane tedo ewa, ‘Turo gora jiveira, awatedo sipo dave ataina.’ ");
INSERT INTO bhg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Edo sipo neneide inemane tedo ewa, ‘Utu awa ororode edo poraga jiwae ingatapera, awatedo iji boroko wa ae bisi okain de gumaina.’ Imomane embobo iwawa tote (2)de! Imomane poraga utuda moka awa inono gido ewa, ata kariwa boroko itomane yai idegedo era awa, ainda moka awa gari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wasiri bebegae edo God dubobae ari embomai iji einda itera ami kariwa da (1) gain tedo era. Ata awamanede kariwa piainyae, tepo peroveta Jonah da kariwa dabé awa piano gara.” Ango tedo imo awamane dodo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Edo iji angode Iesu da ambodani ubutu kupo neida un made teputera, awamane bread kundo gumbae ruvegesitera. ");
INSERT INTO bhg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Edo Iesu mi awamanede sisina, “Parasi mane de Sadusi mane deda bread badari siwo awa imomane akuta dedegewo edo goteite iwo.” ");
INSERT INTO bhg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Edo awamane tuturo edo akuta ge mina tara eite sitera, “Kaena bread kundo gumbae, awatedo ami ge ango sira.” ");
INSERT INTO bhg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Edo Iesu awamane ge ro teri awa gido awamanede sisina, “Ro awaembo imomane akuta bread kundo gumbae ango mina tara evi? Imomane awa gebé ari sakade. ");
INSERT INTO bhg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Imomane matawa gae arapa ae evita? Imomane awa bread ipa da (5)mi embo ajijigari 5,000 unjitara, edo kanjia berari nandogo sirewo beda esiri burawa kotembae evita? ");
INSERT INTO bhg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ko imomane awa bread 7 ami embo ajijigari 4,000 unjitara, edo kambia babain berari nandogo sirewo beda esiri burawa kotembae evita? ");
INSERT INTO bhg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nongo edo imomane gae arapa ae evi? Na imondemane bread da ge tae, ata Parasi mane de Sadusi mane deda bread badari siwo awa goteite iyawate tena.” ");
INSERT INTO bhg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ango tesiri awamane gero arapa esisina, imo bread badari siwo awa goteite iyorote tae, ata Parasi mane de Sadusi mane deda atopatari pitawa awaembo sisina. ");
INSERT INTO bhg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Edo iji nonde Iesu gundo yai Seseria Pilipai ainda torido, ami ainda ambodanide tedogosisina, “Tewo gane, embomaimi na, Embo da Mai, awa ave tedo eri?” ");
INSERT INTO bhg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ango tesiri awamanemi mina sitera, “Neneimi awa John Bapataito Ari Embo tedo era, neneimi Elijah tedo era, edo neneimi awa Jeremiah o peroveta mamatu awamaneda da (1) tedo era.” ");
INSERT INTO bhg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Edo Iesu mi awamanede sisina, “Ata imomane, na awa ave tedo evi?” ");
INSERT INTO bhg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Edo Simon Peter mi mina sisina, “Imo awa Keriso, God wasiride ainda Mai.” ");
INSERT INTO bhg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Edo Iesu mi mina sisina, “God da dubodave ito yai isira Simon Jonah da mai, aindabé kotembari eiwa embo enembomi piae, ata Mamo nato utuda ami na averi awa ito yai esiri geta. ");
INSERT INTO bhg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Edo daedo nane imonde tena, imo awa Peter, edo banga einda tamonda nato embomai doregana, edo Heidis da guwa be berarimi nato embomai mana daginegaina. ");
INSERT INTO bhg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nanemi utu gisijiarida pirigari ambao jiwae imonde piana. Edo rorae ro inemi butu einda bundata dá ango God matu sisina awa, God mi bundesira. Edo rorae ro inemi butu einda udegata dá ango God matu sisina awa, God mi udegesira.” ");
INSERT INTO bhg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ango edo ami ainda ambodanide, imo awa Iesu, God da Avigari Embo awa, embo neneide taro giworekae ge okain sisina. ");
INSERT INTO bhg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Iji ainda edo awa Iesu tuturo edo ainda ambodanide tesiri arapa esiri gositera awa, imo Jerusalem maundo gisijijiegari de pirisi babain de Aodarida atopapasigari demi memesi bouga jiwae ainda yai piaro barate. Edo imo daro betari, edo deguta tamonde (3) ainde, God mi imo jiari erarate. ");
INSERT INTO bhg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Edo Peter mi embo awa kundo demonda iunte tuturo edo ge ikanade ainde sisina, “Badari, ge ango teote! Wasiri engo awa ito yai mana idegaina.” ");
INSERT INTO bhg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ata Iesu wareregedo Peter de sisina, “Imo dodo nato gunda mambu, Satan! Imo begata nato engiregeteta. Kotembari ito awa God da yai edo gumbae, ata embo enemboda edo gumbari.” ");
INSERT INTO bhg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ango edo Iesu mi ainda ambodanide sisina, “Imomane embo da ainmi nato amboda purain jipapa eite gido, imo akuta ruvegedo, ito orega budo na ambo ambo edo eyo. ");
INSERT INTO bhg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Imo ainmi wasiri ikaito awa toregain jipapa eta awa, dadoegata. Ata imo ainmi wasiri ito na embo dadoegata awa, imo wasiri tambata. ");
INSERT INTO bhg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Embo da (1)mi butuda gunaguguye berari bari ainda arate, eite ainda wasiri dadoegaina, awa dave ae! Embo butuda gunaguguye berari ami, God da yai ainda wasirida mina inono piya edo bari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Embo da Mai emi ainda Mamo da taogarida pararade ainda anelamane de gumaina. Edo iji ainde ami embo da da, ainda buro berari gido tau embo da da ainda yai piaina. ");
INSERT INTO bhg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Eiwa gebé imondemane tena, embo nenei einda petetera itera awa, awamane betae gisida isiaro jirari Embo da Mai awa embomai berari gisijiain gupeiari gara.” ");
INSERT INTO bhg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ango edo deguta 6 itae esiri, Iesu mi Peter de nanonameji tote (2) James ae John de, kundo awamane akuta ami gisijido peji ikane ainda vivisisina. ");
INSERT INTO bhg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Edo ainda itero awamanemi Iesu da tamo wareregedo kariwa eve esiri gositera. Edo ainda dombu awa iji inge jisisina. Edo ainda ombarijiari awa ainya esisina parara ango. ");
INSERT INTO bhg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Edo giwo, Moses ae Elijah de idegedo Iesu de ge tero gositera. ");
INSERT INTO bhg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Edo Peter mi Iesu de sisina, “Badari, dave awa kaena einda itera. Imo jipapa ata gido, nanekare bowa tamonde (3) ara: imo da (1), Moses da (1), edo Elijah da (1).” ");
INSERT INTO bhg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Edo giwo! Peter ge site isiri poraga da (1) jitaride ami gundo awamane apuregesisina. Edo burigibé ge yavi poragada edo gupusina ami sisina, “Eiwa nato dubobari Mai. Nato dubodave aribé ainda yai isira. Ainda ge ingiwo!” ");
INSERT INTO bhg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iji ainde ambodani ge yavi awa ingido, adu edo awamaneda tamo augedo dombu butu kenada duduritera. ");
INSERT INTO bhg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ata Iesu mi gundo awamane tujido sisina, “Eriwo, adu eove.” ");
INSERT INTO bhg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Edo awamane pangedo embo nei itae, tepo Iesu akuta gositera. ");
INSERT INTO bhg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Edo awamane pejida edo wowoteite Iesu mi ge okain awamanede sisina, “Wasiri ro gewa awa embo nei tainyae isirawo jirari God mi Embo da Mai betarida awa jiari erari, ainda amboda tawo gore.” ");
INSERT INTO bhg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Edo ainda ambodanimi ainde tedogositera, “Ro awaembo Aodarida atopapasigarimi Elijah awa gisi gumbarate tedo eri?” ");
INSERT INTO bhg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Edo Iesu mi awamanede mina sisina, “Awa gebé, Elijah gisi gundo ami God da Avigari Embo da gumbari awaembo, embomaida do berari sirigedo dave aina. ");
INSERT INTO bhg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ata nane imondemane tena, Elijah awa matu gupusina, edo awamanemi embo awa gae arapa ae. Awatedo ro ain jipapa era awa ainde eutara. Edo daedo iji atutumbeteira ainde awamanemi Embo da Mai de memesi piaro baina.” ");
INSERT INTO bhg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ango tesiri ambodanida yai arapa esisina, Iesu ge awa John Bapataito Ari Embo de tesira. ");
INSERT INTO bhg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Edo awamane gundo embomai jisi da (1) itera ainda etero, embo da (1) gundo Iesu da doda baongo dadari esisina. Ango edo embo ami sisina, ");
INSERT INTO bhg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Badari, nato mai do ewasi. Mai eiwa karu tamo jiparide edo memesi bajinabé budo eira. Edo iji jiwae imo niyaoda durudo eira, edo iji jiwae unda durudo eira. ");
INSERT INTO bhg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Awatedo nane ito ambodanida yai kundo gumena aro kaviegarate. Ata awamane gao ari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Edo Iesu mi ge mina sisina, “O imomane gebé ari isisigaede bebegae embomai! Na iji matawa imondemane isite gundo iji boroko einde daedo. Awarata inemane iji matawa itomane gebé ari nato yai piaera! Mai awa nato yai kundo gumbuwo.” ");
INSERT INTO bhg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Edo mai awa kundo gumbero Iesu mi binei doda ainde ge okain tesiri binei awa dodo idegesiri iji dá ainde mai awa kaviegesisina. ");
INSERT INTO bhg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ainda amboda, ambodanimi gae onjigarida gundo Iesu da yai tedogositera, “Ro awaembo nanekare binei ondetero idegae esiri?” ");
INSERT INTO bhg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Edo Iesu awamanede sisina, “Aindabé itomane gebé ari God da yai awa inono ae. Eiwa gebé imondemane tena, edo itomane gebé ari tega awa saka, masitet vero ango awa, inemane peji einde tawo, ‘Imo einda gigitembedo ounda pete!’ edo peji awa gigitemaina. Edo itomane yai buro berari awa ari tao. ");
INSERT INTO bhg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Binei engo awa mana tepo tawo idegaina. Awarata, edo imomane benunu site indari dodo veta eiawo, God mi imomane kondade aina.” ");
INSERT INTO bhg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Edo iji ainde awamane yai Galili ainda itero Iesu mi awamanede sisina, “Embo da Mai awa kundo gitopo emboda ipada piain bara. ");
INSERT INTO bhg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Edo awamanemi embo awa daro betaina, edo deguta tamonde (3) ainde God mi betarida awa imo jiari eraina.” Edo awamane ge awa ingido dubo vevera bajinabé esitera. ");
INSERT INTO bhg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ango edo Iesu ae ainda ambodani de Kapenium nasida guputera. Edo ainda amboda, Jew embomai da oro kotopu bajinada tax kumbari embobo gundo Peter de tedogositera, “Atopatari itomane oro kotopu bajinada tax piedo eirita?” ");
INSERT INTO bhg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Edo Peter mi mina sisina, “Een, imo ango edo eira.” Edo iji ainde Peter mandoda torido gumbiri, gisibé awa Iesu mi embo ainde ge sisina, “Simon, imo nongo kotembetesi? Daotari manemi embo anda yai tax budo eri? Awamaneda mamai nasi tutuda yai budo erita ko embo neneida yai budo eri?” ");
INSERT INTO bhg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter mi ainde mina sisina, “Embo neneida yai budo era.” Edo Iesu ainde sisina, “Awatedo daotari maneda mamai nasi tutuda, ami tax piaede. ");
INSERT INTO bhg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Awarata, kaenane ge ango taro embobo awa do buriya aina. Awatedo mambuyo ubutuda gori augedo gate. Edo wo tuturobéda imo jimundo ainda beto pirigedo ganu da (1) tambata. Awa kundo maundo awamanede tax nato de ito de awaembo pieyo.” ");
INSERT INTO bhg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Edo iji ainde ambodanimi Iesu da yai gundo ainde sitera, “Embo ave awa bajinabé bajina utuda gisijiari yai ri?” ");
INSERT INTO bhg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ango tetero Iesu mai saka dao tesiri ainda yai gumbiri awamaneda toropuda pipisisina. ");
INSERT INTO bhg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Edo embo ami sisina, “Eiwa gebé imondemane tena, imomane do itomane awa kundo wareregedo dá mai babaingae ango awa, utuda gisijiari yai torawa. Ata edo ango ainyae gido awa, mana torawa. ");
INSERT INTO bhg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Awatedo embo ain tataimbedo mai saka engo aina awa, imo awa embo bajinabé bajina utuda gisijiari yai. ");
INSERT INTO bhg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Edo embo dá ainmi mai saka da (1) engo awa dao natoda ategeteite bureira awa, ami na ategeteite bureira. ");
INSERT INTO bhg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Embo ainmi ari eiwamane babaingae engo da (1) gebé ari nato yai awa dowaina gido, dave awa ainda duboda ganuma bajina kaingedo ewa ugonuda augaro un injido betaina. ");
INSERT INTO bhg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Do ari tena embo berari butuda awa, aindabé rorae neide kaindemi ari embo jimboda durudo ara awaembo! Bawari angogoda edo gumbara, ata do ari embo ainmi embo nei bawari jimboda duraina! ");
INSERT INTO bhg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Edo ito ipa o taimi jigamo edo imo jimbo beyae ata ango gido awa, kautugedo awa augeyo. Davebé awa ine wasiri natopo itarida tai da (1) itae o ipa da (1) itae torata, gaegae edo imo jimbo beyae ipa tote (2)de tai tote (2)demi ata awa, imo niyao natopo itarida ainda augara. ");
INSERT INTO bhg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Edo ito jisimi rorae ro gido imo jimbo beyae ata ango gido, jisi awa gurugedo awa augeyo. Awa beyae ae imo inono jisi da (1)de wasiri natopo itarida torata, gaegae edo jisi tote (2)mi gido jimbo beyae ata awa, imo kundo yai beyae niyao matawa aveira ainda augara. ");
INSERT INTO bhg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Aindabé Embo da Mai embomai dadoegari awa toregaintedo guputena, eiwa dave edo giwo! Nane imondemane tena, eiwamane babaingaeda anelamane utuda awa iji berari Mamo nato utuda dombuda isite awamane embo God da yai benunu tain era. Awatedo eiwamane babaingae jisi tuda edo giwove! ");
INSERT INTO bhg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Edo imomane nongo kotembetevi? Embo da (1)mi ainda wo sipumane ajigari 100 sima edo esira, edo ainda sipu da (1)mi idegedo dadoegesira. Embo awa ainda sipumane 99 awa peji pamoda dodo aundo sipu da (1) dadoegesira awa kakowa ainita? Gebé, ainda sipu da (1) kakowa aina. ");
INSERT INTO bhg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Edo embo ami tamaina, eiwa gebé imondemane tena, embo ainda yawa ari wo sipu dadoegesiri tambirada yai amimi ainda yawa ari wo sipumane 99 dadoegaeda yai awa daginegaina. ");
INSERT INTO bhg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Edo dá ango Mamo itomane utuda, ainda jipapa awa eiwamane babaingaeda da (1) dadoegeure. ");
INSERT INTO bhg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Edo ito namejimi ito yaida jimbo ari gido, aundo embo ainde akuta dada edo ine ainda jimbo beyae awa teyo gare. Edo embo ami ito ge awa ingaina awa, imo ito nameji awa tekago bata. ");
INSERT INTO bhg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ata ge awa tato ingae aina gido awa, embo da (1) ta tote (2) budo ainda yai maundo God da Ge gaiarida engo tari awa ambo ambo eyo, ‘embo tote (2) ta tamonde (3)mi itomane mina tara arida ge udugedo gorote, jimbo beyae emboda katae gisida.’ ");
INSERT INTO bhg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Edo embo awa awamaneda ge ingainyae ari gido awa, nato embomaida doregaride teyo gore. Ata edo embo awa daedo nato embomaida doregarida ge ingainyae ari gido awa, embo awa etene embo ango edo tax kumbari embo ango arate ito yai. ");
INSERT INTO bhg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Eiwa gebé imondemane tena, rorae ro inemane butu einda bundawa dá ango God matu sisina awa, God mi bundesira. Edo rorae ro inemane butu einda udegawa dá ango God matu sisina awa, God mi udegesira. ");
INSERT INTO bhg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Edo daedo, eiwa gebé imondemane tena, edo imomane tote (2) butu einda ami awara edo kondade ari ro jipapa edo benunu tawa awa, Mamo nato utuda ami imomane embo aina. ");
INSERT INTO bhg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Aindabé, edo tote (2) ta tamonde (3)mi nato daoda dada etera awa, na awamaneda toropuda daedo itena.” ");
INSERT INTO bhg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ango edo Peter gundo ainda yai edo sisina, “Badari, nato nameji iji nandogo nato yai jimbo ari na kotembedo dowani? Visido iji 7 anita?” ");
INSERT INTO bhg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Edo Iesu mi embo ainde sisina, “Na imonde visido iji 7 tae, ata iji 70 x 7, ango tena. ");
INSERT INTO bhg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Awatedo utuda gisijiari awa ango daotari da (1)mi ainda buro emboboda yai ainda kondade ari ganu gisi piesiri buritera awa, tekago ainda yai kundo gumbaro sirigain sisina. ");
INSERT INTO bhg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Edo embo ami ganu awa tuturo edo sirigedo awamanemi buro embo da (1) kundo ainda yai guputera. Edo buro embo awa ganu 10,000,000 kina ango awa matu burisina. Awatedo ainda badarimi ganu awa ainda yai tekago piarate sisina. ");
INSERT INTO bhg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ata buro embomi ganu awa piari tao ae awa gido badarimi ge okain sisina, embo awa ae ainda aro de ainda mamai de ainda roviravi berari de awa kundo oriaro ainda ganu inono baina sisina. ");
INSERT INTO bhg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Awatedo buro embo awa ainda doda durudo baongo dadari edo sisina, ‘Tataimbeyo, badari, ganu berari awa ito yai piane!’ ");
INSERT INTO bhg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ango edo buro emboda badari awa do memesi budo embo awa udegesisina, edo ainda ganu nandogo jigamo esisini awa kotembedo doturisina. ");
INSERT INTO bhg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ata buro embo awa idegedo aundo ainda buro otawo nei awa tapusina. Edo ine ainda buro otawode kondade ari ganu 100 silver ango matu piesiri burisina. Awatedo embo awa tamundo ainda duboda kundo sisina, ‘Ganu nato imonde matu pieteno buriteta awa, tekago nato yai pie!’ ");
INSERT INTO bhg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Edo ainda buro otawo ainda taida durudo gegata esisina, ‘Tataimbeyo, ganu awa ito yai piane.’ ");
INSERT INTO bhg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ata ainda buro otawoda ge jindedo embo awa kundo bundari oroda augesiri totorisina, isiari jirari ganu inono embo ainde piari ainda udegari awara aina. ");
INSERT INTO bhg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Edo ainda buro otatawo neneimi ro idegesiri awa gido dubo vevera bajinabé esitera. Awatedo awamaneda badarida yai maundo ro berari idegesiri awa tetero gosisina. ");
INSERT INTO bhg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Edo ainda badarimi embo awa dao tesiri gumbiri ainde sisina, ‘Imo buro embo beyaebé! Ine nato yai gegata eteta, awatedo imo ganu berari tekago namonde piae awa kotembedo dotena. ");
INSERT INTO bhg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Imo ito buro otawo do ae eteta dá nane imo do etena ango, ata ango ae.’ ");
INSERT INTO bhg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Edo ainda badari sinigambari edo buro embo awa memesi piari emboboda ipada pipisisina, isimango mina inono berari ainda badarida yai piari ainda udegari awara aina.” ");
INSERT INTO bhg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Edo Iesu mi ge ao gogumbesite sisina, “Edo imomane dara dara ito namejida jimbo bebegae awa bé kotembedo dowainyae, Mamo nato utuda isira ami dá ango itomane yai aina.” ");
INSERT INTO bhg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ango edo Iesu ge eiwa tedo itae edo Galili dodo aundo un Jodani temundo yai Judea kena maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Edo embo jisijisi bajina ami embo awa ambo ambo esitera, edo embo ami awamane awa ainda gao esisina. ");
INSERT INTO bhg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Edo Parasi mane daedo ainda yai gundo embo awa baveite sitera, “Awa awara edo embomi aro jimundo amboda buro beyae da (1) ro ari ainda aro dodo evekara ainita?” ");
INSERT INTO bhg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Edo embo ami awamanede mina sisina, “Imomane God da Ove Gaiari bé ajigedo gae ta? Iji tuturoda God mi embo enembo esisina, ami ‘embo de eutu de esisina.’ ");
INSERT INTO bhg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Edo God mi sisina, ‘Awatedo embo ainda mamo ae ai de dodo ainda arode dada aina. Ango era ami, awamane tote (2) awa tamo da (1) ara.’ ");
INSERT INTO bhg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ango edo awamane tote (2) evekara itari tao ae, ata awamane awa tamo da (1) God da jisida. Awatedo embo de eutu de God mi piesiri dada etera awa, embo enembomi piaro evekara eorekae.” ");
INSERT INTO bhg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Edo awamanemi embo ainde sitera, “Ro awaembo Moses mi ge okain tedo, embo aro dowain edo gido arode jimbari itae arida ove gaiedo pisido eutu awa piari eve mambarate sisini?” ");
INSERT INTO bhg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Embo ami awamanede sisina, “Aindabé itomane do awa okain, Moses mi awara edo itomane aro dowae etewa sisina. Ata tuturoda awa ango ae. ");
INSERT INTO bhg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Edo nane imondemane tena, embo da ain ainda aro dosira, ata eutu awa jimbae gisida kombo ari itae, ami ainda aro dodo eutu nei jimaina, awa jimbo ipuda ari ainda aro matuda yai. Edo embo da ainmi eutu iu dowari awa jimaina, embo awa jimbo ipuda ari ainda iu matuda yai eira.” ");
INSERT INTO bhg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Edo ainda ambodanimi embo ainde sitera, “Edo embo ae aro deda ge awa ango, dave awa embomaimi iu aro jimainyae.” ");
INSERT INTO bhg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ata embo ami awamanede sisina, “Embo berarimi ge eiwa bari tao ae, ata avekave akuta God mi ari tao ari matu pisina. ");
INSERT INTO bhg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Embobo nenei awa ero engari, edo nenei awa debure kaparide, edo nenei awa utuda gisijiari buro ain eite aro jimbari jipapa aede. Awatedo embo da ain ge eiwa bari tao aina awa, dowo bare.” ");
INSERT INTO bhg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ango edo embomai awamaneda mai babaingae budo Iesu da yai guputera, ami ainda ipa awamane tamonda piedo awamane embo benunu tarate. Ata ainda ambodani awa gido awamane isimbesitera. ");
INSERT INTO bhg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ata Iesu mi sisina, “Mai babaingae awa dowo nato yai gumbore. Embo God tumonda edo era dá mai babaingae engogo awa, utuda gisijiari yai itera, awatedo gumborekae teove.” ");
INSERT INTO bhg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Edo embo ainda ipa awamaneda tamonda piedo yai awa dodo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Edo giwo, embo da (1) Iesu da yai gundo tedogosisina, “Atopatari, imo awa embo dave. Na buro dave ro edo awa wasiri natopo itari bani?” ");
INSERT INTO bhg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Edo Iesu mi embo ainde sisina, “Ro awaembo na dave tesi? Embo berari awa dave da (1) itae, ata God akuta. Ata imo wasiri natopo itarida torain edo gido awa, God da ge okain kera eyo.” ");
INSERT INTO bhg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Edo embo ami ainde sisina, “Ge okain indawa kandawa ri?” Edo Iesu mi sisina, “‘Imo embo nei dato beteure, ipuda eote, beono eote, ge pitawa katari ijide teote, ");
INSERT INTO bhg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ito mamo ae ai de tou edo eyo,’ edo ‘nembu ito dubobudo eyo dá imo akuta dubobudo eta ango.’” ");
INSERT INTO bhg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Edo embo teka ami embo ainde sisina, “Na tuturoda mai tekade God da ge okain sisina berari teteta awa kera eite gundo boroko matawa eite itena. Edo na buro nei da (1) ro ani?” ");
INSERT INTO bhg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu mi embo ainde sisina, “Edo imo dave berarida dave ain jipapa edo gido, aundo ito roviravi awa pieyo, embo neimi oriaro ganu awa kundo maundo embomai rorae isisigaede piate, edo gaiapabé utuda bata. Ango edo gumbu, na ambo ambo ate.” ");
INSERT INTO bhg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ata embo teka awa gunaguguye jiwaede, awatedo iji ainde ge awa ingido imo dubo vevera eite dodo aunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ango edo Iesu mi ainda ambodanide sisina, “Eiwa gebé imondemane tena, embo gaiapade ami utuda gisijiari yaida torari okainbé tamaina. ");
INSERT INTO bhg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Edo tekago imondemane tena awa, wo bajina kamelo mi ninou to sakada torari awa gadae ango, ata embo gaiapade ami God da gisijiari yaida torari awa okainbé.” ");
INSERT INTO bhg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Edo ainda ambodani ge awa ingido awamane kore bajinabé eite sitera, “Awatedo embo ainmi God da toregari inono baini?” ");
INSERT INTO bhg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ata Iesu awamane jisini edo sisina, “Embo enembomi awamaneda wasiri topo toregari tao ae, ata God buro berari ari tao.” ");
INSERT INTO bhg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Edo Peter mi embo ainde mina sisina, “Giyo! Nakare rorae berari dodo imo ambo ambo edo etera. Awatedo nakare rorae ro bari?” ");
INSERT INTO bhg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Edo Iesu mi awamanede sisina, “Eiwa gebé imondemane tena, iji ainde God mi roviravi berari awa tekago ari teteka aina awa, Embo da Mai mi ainda daotari anumbada taogaride anumaina. Edo imomane na ambo ambo edo etewa awa, imomane daedo daotegeregarida anumba berari 12 ainda anumbedo Israel embomaida ewowo 12 awa gisijido awa. ");
INSERT INTO bhg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Edo embo berari ainkainmi mando dodo, nanonameji, ruaimono, mamo, ai, aro, mamai ritako butu dodo na awaembo etera awa, God mi kando bé jiwaebé (100) ango daginegari awamaneda yai piari bara, edo wasiri natopo itari bara. ");
INSERT INTO bhg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ata embo jiwae gisibéda awa ambobéda ara, edo embo ambobéda awa gisibéda ara. ");
INSERT INTO bhg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Utuda gisijiari awa engo: Iji da (1)de utu tutu da (1)mi sipobéde idegedo buro embobo ainda gurepida buroda buro orote kakowa edo bain esisina. ");
INSERT INTO bhg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Edo imo buro embobo tamundo awamanede sisina awa, deguta da (1) ainda buro tau piaina. Ango tesiri awara etero ami awamane piesiri ainda gurepi buroda maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Edo ora 9:00 ango eiri sipode, imo aundo origarori ari yaida embo nenei tepo petedo itero gosisina. ");
INSERT INTO bhg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Edo embo ami awamanede sisina, ‘Imomane daedo gurepi buroda mambuwo buro ave. Edo mina tega ro inge awa inono piano bawa.’ Ango tesiri awamane buroda maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Edo imo tekago ora 12:00 ijide edo ora 3:00 turode ango idegedo aundo buro dá ango esisina. ");
INSERT INTO bhg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Edo ora 5:00 ango eiri turode, imo idegedo embo nenei tepo pepetegedo itero tamundo ami awamanede sisina, ‘Ro awaembo imomane einda tepo sipode pepetegedo itewo gundo turo jiriri?’ ");
INSERT INTO bhg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Edo awamanemi ainde mina sitera, ‘Aindabé embo da ain nakare buro orote bae.’ “Embo ami awamanede mina sisina, ‘Imomane daedo gurepi buroda mambuwo buro ave. Edo mina tega ro inge awa inono piano bawa.’ ");
INSERT INTO bhg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ango edo turobé gumbiri, gurepi buro tutumi ainda buro emboboda gisijiaride sisina, ‘Buro embobo dao teyo gumbaro awamaneda tau piate. Gisibé embobo buro ambobéda tuturo etera edo maundo embobo sipobéde buro tuturo etera, awamaneda mina pieyo bore.’ ");
INSERT INTO bhg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Edo buro embobo ami ora 5:00 ango eiri turode buro tuturo esitera awa, gumbero awamaneda buro tau da da piesiri buritera. ");
INSERT INTO bhg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ango edo buro embobo sipobéde buro tuturo esitera awa gundo tau daginegedo bara kotembesitera, ata awamane daedo buro tau tega dá ango da da buritera. ");
INSERT INTO bhg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Edo iji ainde awamane tau budo, awamanemi tuturo edo buro tutu ainde ge guguma gaguma tedo sitera, ");
INSERT INTO bhg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Embobo eiwa ambobéda gundo ora da (1) akuta buro etera, edo ine awamaneda ganu tega dá namondekare ango pieteto bera. Ata nakare sipobéde tuturo edo iji veverami aveiri buro okain ero turo jirira.’ ");
INSERT INTO bhg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ata buro tutumi awamaneda da (1)de mina sisina, ‘Otawo, na imonde buro beyae ae ena. Ingena gisi ge teteno imo buro tau awa bain awara eteta. ");
INSERT INTO bhg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ito tau pietena awa kundo mambuyo. Na embo eiwa buro ambobéda esira awa tau imonde pietena dá ango ainde piain jipapa ena. ");
INSERT INTO bhg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Eiwa ganu nato topo, awatedo nane ganu emi ro ain jipapa edo awa ana. Ko aindabé na awa embo dave edo wasiri dave eteno gido jitesita?’” ");
INSERT INTO bhg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Edo Iesu ge gogumbarida awamanede sisina, “Dá ango embo ambobéda awa gisibéda ara, edo embo gisibéda awa ambobéda ara. Embo jiwae awa God mi dao sisina, ata indewae awa ami gerisina, awatedo na ge awa tetena.” ");
INSERT INTO bhg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Edo iji ainde Iesu Jerusalem vivisite, imo ambodani 12 akuta awa kundo begata demonda doregedo awamanede sisina, ");
INSERT INTO bhg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ingiwo! Kaena Jerusalem kena vivitera. Edo Embo da Mai awa, pirisi babain ae Aodarida atopapasigari deda ipada piari mamaina. Edo awamanemi imo kundo betarate katara. ");
INSERT INTO bhg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Edo Gentile embomaida yai piaro awamanemi imo tedojirido asimi vededo oregada daro betaina. Ata deguta tamonde (3) ainde awa embo awa tekago eraina.” ");
INSERT INTO bhg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ango edo Zebedee da mamaida aimi Iesu da yai gupusina ae ainda mamai de daedo, edo baongo dadari edo ainda yai atega esisina. ");
INSERT INTO bhg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Edo embo ami eutu ainde sisina, “Imo ro jipapa esi?” Eutu ami embo ainde sisina, “Ito gisijiari iji ainde imo ito anumbada anumbata, mamai nato tote (2) eiwamane, nei ito ipa beda, nei ito ipa andada anumborote tedogotena.” ");
INSERT INTO bhg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ata Iesu mi mina tedo sisina, “Imomane ro atega evi awa gae. Imomane inono memesida akou dá ango nane inain ena awa indavita? Edo imomane inono betarida bapataito ari dá ango nane bain ena awa bavita?” Edo awamanemi ainde sitera, “Nakare tote (2) inono era.” ");
INSERT INTO bhg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Edo embo ami awamanede sisina, “Imomane gebé memesida akou dá ango nane inana awa indawa, edo imomane betarida bapataito dá ango nane bana awa bawa. Ata nato awara ari embo avigarida itae ainmi nato ipa beda edo nato ipa andada anumaini awa. Ata Mamo natomi embomai awa matu avigedo, edo awamaneda dero siya esisina.” ");
INSERT INTO bhg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Edo iji ainde ambodani ajigari 10mi ge awa ingido awamane sinigambari esitera nameji tote (2)da yai. ");
INSERT INTO bhg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ata Iesu mi awamane dao tesiri gumbero awamanede sisina, “Imomane awa gari, Gentile embomaida gisijijiegarimi ge okain awamaneda embomaide tedo era, edo embo babainmi awamaneda awara tarimi embomai gisijido era. ");
INSERT INTO bhg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Awarata, itomane awara tari arapa ainyae. Ata embo ain itomane toropuda God da jisida embo bajina ain eira gido, itomane kondade ari embo aina. ");
INSERT INTO bhg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Edo embo ain itomane toropuda badarida dero bain jipapa eira gido awa, itomane buro embo arate. ");
INSERT INTO bhg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Embo da Mai awa kariwa dá ango. Embo ami embo neneimi imo kondade orote gumbae. Ata ine embo nenei kondade ain, edo embomaida jimbo bebegaeda rirowa mina awaembo ainda wasiri piari embo jiwae udegari borote gupusina.” ");
INSERT INTO bhg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Edo iji ainde awamane Jeriko dodo auntero, embomai jisi bajina Iesu ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Edo eiwa giwo! Embo tote (2) jisi guba ari begata demonda anumbedo isite, Iesu gundo daginegeteiri ge awa ingido, awamanemi aorogatedo sitera, “Nakare do e, O Badari, David da Mai!” ");
INSERT INTO bhg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ango edo embomai jisi da (1) ami awamane awa isimbedo ge doworote sitera. Ata awamane aoro ikanade gatedo sitera, “Nakare do e, O Badari, David da Mai!” ");
INSERT INTO bhg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Edo Iesu petedo dapedo isite awamane dao tedo sisina, “Nane imondemane ro anate jipapa evi?” ");
INSERT INTO bhg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Edo awamanemi embo ainde sitera, “Badari, natokare jisi awa pirigato gain jipapa era.” ");
INSERT INTO bhg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Edo Iesu do memesi awamane embo budo awamaneda jisi awa tujijisina. Edo burigibé awamaneda jisi pirigesiri embo awa ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ango edo Iesu ae ainda ambodani de Jerusalem atutumbedo, Besipeij nasida Olive de Peji ainda guputera. Edo Iesu ambodani tote (2) piesiri mauntero, ");
INSERT INTO bhg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","awamanede sisina, “Imomane maundo nasi ounda toriwo. Edo boraebé wo donki ai buri edo kanjigari ae donki vete de ainda tambawa. Awamane udegedo nato yaida kundo gumbuwo. ");
INSERT INTO bhg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ango eiawo embo da ainmi, ‘Nongo ain evi?’ tari gido, ainde tewo, ‘Badari mi jipapa eira.’ Ango tawo boraebé piari kundo gumbave.” ");
INSERT INTO bhg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aindabé perovetami rorae eiwa idegaina sisina, awatedo ro berari idegarate sisina awa gundo bé esisina. Edo sisina awa engo: ");
INSERT INTO bhg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Nasi Zion embomaide tewo, ‘Giwo, itomane Daotari gupeira itomane yai. Imo do netegaride wo donki tamonda anumbedo gupeira, edo donki vete tamonda, awa donki da mai.’” ");
INSERT INTO bhg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Awatedo ambodani maundo Iesu mi nongo orote tesira awa esitera. ");
INSERT INTO bhg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Edo awamane wo donki ai ae donki vete de awa kundo gundo awamaneda dademo ombarimi womaneda gunda besi jirero Iesu visido anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Edo embomai jisi bajinabé awamaneda dademo ombari begatada jijiritera, awamaneda tou ari arapa aintedo. Edo embo nenei ni papatu kapedo begatada jirido esitera. ");
INSERT INTO bhg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ango edo embo jisijisi gisi esitera, edo nenei Iesu da amboda orovigesitera, awamanemi tenda tenda aorogatedo sitera, “Hosanna David da Mai! ‘God da ao ari embo einda yai itare! Embo eiwa Badari da daoda gupeira!’ Hosanna! Kaen God ikanebé ikane awa dasiga era!” ");
INSERT INTO bhg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Edo iji ainde Iesu gundo Jerusalem toriri nasi bajina ainda embo berari erero yavi bajina esiri awamanemi tedo esitera, “Eiwa embo averi?” ");
INSERT INTO bhg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Edo embo jisijisimi tedo esitera, “Eiwa peroveta Iesu. Awa Nasaret nasi embo yai Galili da.” ");
INSERT INTO bhg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ango edo Iesu maundo God da oro kotopu bajinada torido embomai berari oro kotopu doda origarori ero ondesiri idedegesitera. Edo imo ganu sirigari emboboda tenemba awa jiuri doveregedo esitera, edo ni ribo ango oriari emboboda anumba jiuri doveregedo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Edo Iesu mi awamanede sisina, “Ove Gaiarida God mi sisina, ‘Awamanemi tara, nato oro kotopu awa embomaida benunu oro,’ ata inemane etewo ‘beono emboboda onjigari banga to’ esira.” ");
INSERT INTO bhg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Edo embomai jisi guba ari de baoro bundari demi Iesu da yai oro kotopu bajina doda gumbero ami gao esiri kaviegesitera. ");
INSERT INTO bhg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ata iji ainde pirisi babain de Aodarida atopapasigari demi Iesu da wasiri babain esiri gido, edo mamaimi oro kotopu bajina do arapada aorogatedo “Hosanna David da Mai!” tero ingido awamane sinigambari esitera. ");
INSERT INTO bhg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Edo awamanemi embo ainde sitera, “Imo mamai emi ge ro teri awa gotesita?” Edo Iesu mi awamanede mina sisina, “Een. Imomane God da Ove Gaiarida ro tari isira awa ajigedo gaeta? ‘Inemi mai babaingae edo ami beda, awamane atopapositeta imo dasiga orote.’” ");
INSERT INTO bhg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Edo imo awamane dodo nasi bajinada idegedo Betani nasida maundo muyae da (1) ainda ausina. ");
INSERT INTO bhg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Edo sipo atesiri imo overegedo nasi bajinada maunsite beji mina burisina. ");
INSERT INTO bhg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Edo jisi piedo ni dunga begata demonda gido imo ainda yaida gupusina. Ata be da ji itae, igi akuta gosisina. Edo Iesu mi ni ainde sisina, “Ine be da ji mana tenda ekata!” Ge ango tesiri boraebé ni dunga awa mumuya esisina. ");
INSERT INTO bhg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Edo iji ainde ambodani eiwa gido korebé eite sitera, “Ni dunga awa nongo edo boraebé mumuya esiri?” ");
INSERT INTO bhg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Edo Iesu mi awamanede mina sisina, “Eiwa awa gebé imondemane tena, itomane gebé ari God da yai piedo itadaita itae awa gido, inemane buro ro nane ni dungade eteno gewa ango akuta ainyae, ata daedo inemane peji einde tawa, ‘Imo akuta gigitembedo ewada dagumbeyo,’ edo ango aina. ");
INSERT INTO bhg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Edo rorae ro benunuda tedogawa, edo itomane gebé ari God da yai pipiteiawo ami piari bawa.” ");
INSERT INTO bhg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ango edo Iesu gundo oro kotopu bajinada torido embomai atopaposite isiri pirisi babain de Jew gisijijiegari demi ainda yai atutumbedo sitera, “Imo awara tari nomi buro engogo edo esi? Edo imonde awara tari eiwa ainmi piesiri?” ");
INSERT INTO bhg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ata Iesu mi awamanede ge mina sisina, “Nane daedo imondemane tedogari da (1) piana. Edo inemane ainda mina tawo gido awa, nane dá ango awara tari nomi buro engogo edo eni awa, tano gawa. ");
INSERT INTO bhg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tewo gane. John da bapataito arida buroda awara tari yai nonda edo gupusini? Utu mi pipisinita ko embo enembomi pipisiteri?” Edo awamane akuta mina tara eite sitera, “Edo kaenane ‘Utu mi awara tari pipisisina’ tara awa, ami taina, ‘Awatedo ro embo imomane John gebé ae esitevi?’ ");
INSERT INTO bhg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Awarata edo kaenane, ‘Embo enembomi pipisitera,’ tara awa, kaena embo jisi da (1) ouwa adu era, aindabé ouwamane berarimi John awa peroveta site gebé edo era. Awatedo ouwamanemi kaenamonde sinigambari ara.” ");
INSERT INTO bhg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ango edo awamanemi Iesu de ge mina sitera, “John da bapataito arida buroda awara tari yai nonda edo gupusini awa, nakare gae.” Edo Iesu mi awamanede sisina, “Ango tewa, awatedo awara tari nomi buro eiwa edo eni awa, nane imondemane tainyae. ");
INSERT INTO bhg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ata imomane ro kotembetevi? Iji da (1)de embo da (1) isima edo esisina, edo ainda mamai tote (2) daedo isima edo esitera. Edo ami maundo mai buwode sisina, ‘Imo sipo boroko nato gurepi buroda maundo buro eyo.’ ");
INSERT INTO bhg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Edo mai buwomi mina sisina, ‘Na jipapa ae ena.’ Ata amboda ainda kotembari wareregedo buroda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Edo mamo maundo mai neide ge dá mai buwode sisina ango sisina. Edo mai neimi mina sisina, ‘Awara badari, nane mamana.’ Ata imo mambae. ");
INSERT INTO bhg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","“Awatedo mamai tote (2) einda da (1) ainmi ainda mamoda jipapa awa esisini?” Awamanemi Iesu de mina sitera, “Mai buwomi esisina.” Edo Iesu mi awamanede sisina, “John Bapataito Ari Embo mi gundo itomane yai wasiri dambu dararida begata awa esiri gositewa, edo imomane ainda ge awa gebé ae. Ata tax kumbari embobo de ipuda ari eutumai demi ainda ge gebé esitera. Edo imomane wasiri awa gositewa, ata itomane kotembari wareregedo ainda ge gebé ae. Awatedo eiwa awa gebé imondemane tena, tax kumbari embobo de ipuda ari eutumai demi imomane daginegesite gisi God da gisijiari yai torido era. ");
INSERT INTO bhg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Edo eniya ge nei ingiwo: Buro tutu da (1)mi dongo gurepi jiwae buroda uredo puwa jido jinenembesisina. Edo gurepida gama bari yai duredo simagari beuri esisina. Edo ami gurepi buro sima ari embobo avigedo awamanemi dongo gurepi be tari ari tokedo ainda yai piorote sisina. Edo imo yai aikeda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ango edo dongo gurepi be tari edo ainda tokari yoa gumbiri buro tutumi ainda buro embobo piesiri gurepi buro sima ari emboboda yai maunsitera, gurepi be piaro kumain. ");
INSERT INTO bhg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ata gurepi sima ari embobomi ainda buro embobo awa kundo da (1) vejitera, nei da (1) detero besisina, edo nei awa ganumami doritera. ");
INSERT INTO bhg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ango etero gido buro embobo ine gisi pipitara da ajigari awa daginegedo tenda nenei piesiri maunsitera, edo gurepi sima ari embobomi iwata dá ango awamanede esitera. ");
INSERT INTO bhg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Edo ambobéda awa, buro tutumi ainda mai pipisisina. Edo imo akuta sisina, ‘Awamanemi nato mai tou ara.’ ");
INSERT INTO bhg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ata gurepi sima ari embobomi mai awa gumbiri gido awamanemi akuta sitera, ‘Edo gurepi buro tutu betaina, butu einda maida topo aina. Puwo, kaende mai ouwa daro betari ainda butu kaenane kumbore.’ ");
INSERT INTO bhg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ango tedo mai gumbiri budo puwa ponda augetero idegesiri detero besisina. ");
INSERT INTO bhg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Awatedo gurepi buro tutu gumaina awa, ami gurepi sima ari embobode nongo aini?” ");
INSERT INTO bhg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“Edo awamanemi ainde mina sitera, “Embo ami embo bebegae awa usibesibé dedo ainda gurepi buro awa budo gurepi sima ari embo neneide piari sima ara. Edo beda tokari yoa gumbari gido awamanemi gurepi be ainda yai piaro baina.” ");
INSERT INTO bhg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu mi awamanede sisina, “Imomane God da Ove Gaiarida ro tari isira awa bé ajigedo gaeta? ‘Ganuma oromando ari embomi ajiregesitera awa, God mi esiri tutuvida ganuma davebé dave esira, edo ami awa jigamo esiri oro okain esira. Eiwawa Badari da wasiri, edo kaena jisimi gido korebé eite dubodave era.’ ");
INSERT INTO bhg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Awatedo nane imondemane tena, God da gisijiari itomane yaida awa dodo kumaina, edo embomai ainkainmi God da jipapa awa ara awamanede piaina. ");
INSERT INTO bhg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Daedo embo da ainmi ganuma einda tamonda durudo bedaina. Ata edo ganuma eiwa embo tamonda duraina, emi embo dedo mundari popo aina.” ");
INSERT INTO bhg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Edo pirisi babain de Parasi mane demi Iesu da eniya ge tote (2) ingitera, edo kariwa awamaneda bureite sira gositera. ");
INSERT INTO bhg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ango edo awamanemi embo awa jido bunain esitera. Ata embo jisijisimi Iesu awa peroveta gebé era, awaembo adu edo imo doturitera. ");
INSERT INTO bhg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ango edo Iesu mi tekago eniya ge nenei jigamo eite awamanede sisina: ");
INSERT INTO bhg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Utuda gisijiari awa engo. Daotari da (1)mi ainda maida jimbari bondo siya esisina. ");
INSERT INTO bhg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Edo daotari ainda buro embobo piesiri idegesitera, embomai bondoda jipara awa taro gumborote, ata awamane gumbari jipapa ae esitera. ");
INSERT INTO bhg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Edo tekago imo buro embo nenei piesiri idegetero sisina, ‘Avekave bondoda jipana awa tewo gore, “Giwo! Nato bondo siya etena, edo nato wo kao jijianda ae kao mane gavi de awa dedo odedo taietena, edo rorae berari siya etena. Jimbari bondoda gumbuwo.” ’ ");
INSERT INTO bhg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ata embomai bondoda jipara awa ge gainyae edo awamaneda jipapada maunsitera. Embo da (1) awa ainda ve urari buroda maunsisina, edo nei ainda ganu bari buroda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Edo embomai bondoda jipara neneimi awa ainda buro embobode memesi neide kainde pisido detero besitera. ");
INSERT INTO bhg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ata iji ainde daotarimi ge awa ingido imo sinigambari bajinabé esisina. Edo ainda itoro embobo piesiri idegedo maundo dari betari embobo awa dedo usibesi edo awamaneda nasi bajina dungitera. ");
INSERT INTO bhg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ango edo imo ainda buro embobo dao tesiri gumbero awamanede sisina, ‘Jimbari bondo awa siya etena, ata embobo jipana, awamaneda tou ari nato yai itae. Awaembo na awamane jipapa ae. ");
INSERT INTO bhg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Awatedo imomane maundo begata bajinada umbugoda pepeta eite embomai berari tamundo awamane jimbuwo bondoda gumbore.’ ");
INSERT INTO bhg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ango tesiri buro embobo idegedo maundo begata bajinada pepeta eite embo dave de beyae de berari awa tamundo doregesitera. Edo awamane gisijido kundo gundo jimbari bondoda jiumbari yaida torero embomaimi inono esiri yai awa tonga itae esisina. ");
INSERT INTO bhg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ata iji ainde daotarimi embo bondoda gumbera awa etega aintedo torido, imo embo da (1) jimbari ombarijiari piae awa gosisina. ");
INSERT INTO bhg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Awatedo ami embo ainde sisina, ‘Otawo, nongo edo jimbari ombarijiari piaede einda toresi?’ Ata embo ami ge da (1) tae esisina. ");
INSERT INTO bhg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Edo daotarimi buro embobode sisina, ‘Embo eiwa ipa de tai de bundedo kundo arapada augewo muyaeda idegare, yai embomai ji site edo ji vegeite isima edo ara ainda.’” ");
INSERT INTO bhg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Edo Iesu mi ainda ge gogumbarida sisina, “Embo jiwae awa God mi dao sisina, ata indewae awa ami gerisina.” ");
INSERT INTO bhg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Edo Parasi mane idegedo ge jijiritera awa, imo ge tae dumbae ari gido ainde bekumba ge tain. ");
INSERT INTO bhg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ango edo awamanemi Iesu da yai awamaneda ambodani ae Herod da buro otatawo de pietero maunsitera. Edo awamanemi sitera, “Atopatari, nakare gotera imo awa gebé embo, edo imo gebémi embomai nongo itorote God mi jipapa eira awa atopasido eta. Aindabé imo embo anumba ikane o tuda itera awa kotembae, awatedo rorae ro awamanemi kotembae eteri imo dubo vevera ainyae. ");
INSERT INTO bhg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Awatedo nakare te gore. Ito kotembari rori? Nakare tax ganu Caesar de piedo era awa awarita ko awara aeri?” ");
INSERT INTO bhg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ata Iesu awamaneda sirigari bebegae awa gido sisina, “Imomane embobo iwawa tote (2)de, ro awaembo imomane na bavedo gotevi? ");
INSERT INTO bhg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Awara, itomane tax ganu awa eu gane.” Ango tesiri awamane ganu da (1) ainda yai kundo guputera. ");
INSERT INTO bhg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Edo Iesu mi awamanede sisina, “Dombu de dao de eiwa andari?” ");
INSERT INTO bhg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Edo awamanemi ainde sitera, “Caesar da.” Edo Iesu mi awamanede sisina, “Awatedo Caesar da roviravi awa Caesar de piewo, edo God da roviravi awa God de piewo.” ");
INSERT INTO bhg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Edo awamanemi Iesu da ge awa ingido kore edo imo dodo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Iji dá ainde Sadusi mane Iesu da yai guputera. Awamane gebé edo era awa, embo betedo erari itae. Awatedo awamanemi ainde tedogositera, ");
INSERT INTO bhg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Atopatari, Moses mi sisina awa, embo aro jimundo mamai piae eimango betaina, ainda namejimi ainda namejida aro rori awa jimundo mamai piari namejida orobe itarate. ");
INSERT INTO bhg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Awara, iji da (1)de nanonameji berari 7 awa namondekare isiretera. Edo nameji buwomi aro jimundo mamai piae betesiri buwoda gaganimi ainda aro rori jipusina. ");
INSERT INTO bhg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Edo dá ango buwoda gagani daedo mamai piae besisina. Ango eimene gundo tamonde (3)da edo maundo berari 7 awa bebetegesitera. ");
INSERT INTO bhg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Edo ambobéda, eutu awa daedo besisina. ");
INSERT INTO bhg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ango edo iu ibono berari 7mi eutu eiwa jipusina. Awatedo, iji amboda embomai betarida erara awa, arobé anda aini?” ");
INSERT INTO bhg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Edo Iesu mi awamanede ge mina sisina, “Imomane God da Ove Gaiarida ro tari isira awa gae, edo daedo God da goroba awa gae. Awatedo ge tae dumbae etewa. ");
INSERT INTO bhg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bebetegarida tekago erari iji ainde awa, embo de eutu de, iu aro ari tao ae, edo jimbari mina piara ari itae, ata God da anelamane utuda ango ara, awatedo na ge awa tetena. ");
INSERT INTO bhg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ata bebetegarida tekago erarida ge ro God mi imondemane sisina awa ajigedo gaeta? Awa engo, ");
INSERT INTO bhg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Na awa Abraham da God, Isaac da God, edo Jacob da God.’ Awatedo God ami sisina, imo awa bebetegarida God ae, ata embomai wasirideda God.” ");
INSERT INTO bhg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Edo embo jisijisi yai ainda usitera ami Iesu da atopatari ge eiwa ingido korebé esitera. ");
INSERT INTO bhg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ata iji ainde Iesu mi ge mina dave awa Sadusi manede tesiri gido awamanemi tedogari da (1) nei ainda yai piari tao ae dapitera. Edo bino awa Parasi manemi ingido gundo doregesitera. ");
INSERT INTO bhg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ango edo awamaneda doregarida edo Aodarida jirogari embo da (1)mi Iesu da yai gundo bavedo gain sisina, ");
INSERT INTO bhg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Atopatari, God da Aodari da ge okain nondawa bajinabé bajinari?” ");
INSERT INTO bhg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Edo Iesu mi embo ainde sisina, “‘Badari ito God awa dubobudo eyo do ito berarimi, asisi ito berarimi, kotembari ito berarimi.’ ");
INSERT INTO bhg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Eiwawa God da ge okain gisibé edo bajinabé bajina. ");
INSERT INTO bhg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Edo ainda gagani awa dá ango: ‘Nembu ito dubobudo eyo dá imo akuta dubobudo eta ango.’ ");
INSERT INTO bhg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ge okain tote (2) eiwa Aodarida edo Peroveta maneda Ove Gaiari berarida tutuvi emi jiuri isima edo eira.” ");
INSERT INTO bhg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ango edo Iesu mi Parasi mane ainmi yai ainda matu doregedo itero awamanede tedogosisina, ");
INSERT INTO bhg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Keriso awa imomane ro kotembetevi? Embo awa anda mairi?” Awamanemi ainde mina sitera, “David da mai.” ");
INSERT INTO bhg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ango tetero Iesu mi awamanede sisina, “Edo awa gebé, ro awaembo Asisi Kotopu mi David gisijiri imo awa ‘Badari’ sisini? Aindabé David mi sisina, ");
INSERT INTO bhg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Badari mi nato Badari de sisina, “Ipa be natoda anumbedo namonde daedo embomai berari gisijiyo! Ango eiato nane ito gitopo embo ito tai tuda piana.” ’ ");
INSERT INTO bhg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Edo David mi embo awa ‘nato Badari’ sisina, nongo edo embo awa ainda mairi?” ");
INSERT INTO bhg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Edo embo da ainmi Iesu da ge inono mina tae. Edo iji ainde edo matawa mambira awa, embo berari adu edo bavedo gain tedogari nei da ji piae. ");
INSERT INTO bhg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Edo Iesu mi embo jisijisi ae ainda ambodani de ge sisina, ");
INSERT INTO bhg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Aodarida atopapasigari ae Parasi mane demi Moses da anumbada dero budo Aodari sima edo era. ");
INSERT INTO bhg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Awatedo rorae berari imomane kera awate tedo era awa kera edo ewo. Ata ge ro awamanemi tedo era awamanemi ainyae edo era, awatedo awamaneda wasiri ambo ambo ainyae. ");
INSERT INTO bhg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Edo awamanemi aodari okain jiwae embomaimi kera ari tao ae awa awamaneda yai piedo era, ata awamane akuta embomai kondade edo aodari dabé ango teugainyae edo era. ");
INSERT INTO bhg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ata awamaneda buro berari edo era awa embomi gorote edo era. Edo awamaneda mauwa saka awa eoro bajina euri God da ge ikotada gaiedo ainda doda piedo beoda ko ipada kaingedo era. Edo awamaneda ombari riborida begisida orere tupo awa eoro ribori edo eira. ");
INSERT INTO bhg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Edo Aodarida atopapasigari ae Parasi mane demi ondo bondoda maundo besi davebé daveda anumain, edo benunu oroda maundo anumba davebé dave awa bain jipapa edo era. ");
INSERT INTO bhg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Edo awamanemi origarori ari yai berari ainda aimbaro embomaimi ategabutega edo dave borote edo dao ‘Atopatari, Atopatari,’ awamanede torote jipapa edo era.” ");
INSERT INTO bhg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Edo Iesu ango tedo sisina, “Ata embo da (1) akuta awa itomane Atopatari, edo embo awa Keriso, edo imomane berari awa nanonameji. Awatedo imomane jipapa ae ewo embo neneimi imondemane dao ‘Atopatari’ tari awa. ");
INSERT INTO bhg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Edo itomane Mamo dabé utuda awa isira, awatedo inemane embo da ji butuda einda awa dao itomane ‘Mamo’ tainyae. ");
INSERT INTO bhg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Edo itomane Atopatari dabé awa Keriso, awatedo imomane mana awara awo dao itomane awa ‘atopapasigari’ tara. ");
INSERT INTO bhg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ata embo ainmi itomane toropuda embo bajina ain jipapa eira awa, itomane buro embo aina. ");
INSERT INTO bhg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Edo embo ainmi ainda dao akuta jiari vitaina awa, God mi piari wotaina. Edo embo ainmi ainda dao akuta jiari wotaina awa, God mi jiari vitaina. ");
INSERT INTO bhg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ata Aodarida atopapasigari ae Parasi mane de, imomane awa embobo iwawa tote (2)de, awatedo imomane do ari! Imomane utuda gisijiari yaida manguro embomaida yai engiregedo ewa, edo imomane akuta doda torae, edo embomaimi torain eiworo engiropangiro edo ewa. ");
INSERT INTO bhg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Aodarida atopapasigari ae Parasi mane de, imomane awa embobo iwawa tote (2)de, awatedo imomane do ari! Imomane eutu rori udumbedo awamaneda gaiapa budo ewa, edo itomane iwata ari dave awa embomaimi gorote tedo benunu riribo tedo ewa. Katari ijide God mi itomane yai rirowa bajinabé embo nenei daginegedo piaina. ");
INSERT INTO bhg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Aodarida atopapasigari ae Parasi mane de, imomane awa embobo iwawa tote (2)de, awatedo imomane do ari! Imomane maundo butu de ewa de temundo embo da (1) itomane ambodani arate kakowa edo ewa. Edo embo awa ainda do itomane yai wareregeuri imomane embo awa atopatowo Binei da mai edo eira, edo itomane bebegaeda tega awa bé daginegedo eira. ");
INSERT INTO bhg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Imomane gisijijiegari jisiguba aride, imomane do ari! Inemanemi tedo ewa, ‘Embo da ainmi Jew embomaida oro kotopu bajinada daoda tarigari tedo eira awa, ainda moka itae; ata embo da ainmi oro kotopu bajinada gold da daoda tarigari tedo eira awa, ainda tarigari kera arate.’ ");
INSERT INTO bhg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Imomane awa kotembari itae edo jisiguba ari! Rorae indawa bajinabé bajinari: gold rita ko oro kotopu bajina ami euri gold kotopu edo eiri? ");
INSERT INTO bhg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Edo inemanemi tedo ewa, ‘Embo da ainmi rorou piari tenembada daoda tarigari tedo eira awa, ainda moka itae; ata embo da ainmi kando rorou piari tenembada tamondada daoda tarigari tedo eira awa, ainda tarigari kera arate.’ ");
INSERT INTO bhg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Imomane dutari edo jisiguba ari! Rorae indawa bajinabé bajinari: kando rita ko rorou piari tenemba ami euri kando kotopu edo eiri? ");
INSERT INTO bhg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Awatedo embo ainmi rorou piari tenembada daoda tarigari tedo eira, imo tenembada daoda edo rorae berari tenemba tamonda isira ainde daedo tarigari tedo eira. ");
INSERT INTO bhg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Edo embo ainmi oro kotopu bajinada daoda tarigari tedo eira, imo oro kotopu bajinada daoda edo God ainmi oro kotopu bajina doda isima edo esisina ainda daoda tarigari tedo eira. ");
INSERT INTO bhg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Edo embo ainmi utuda daoda tarigari tedo eira, imo God da daotari anumbada daoda edo God ainmi daotari anumbada anumbedo isira ainde daedo tarigari tedo eira. ");
INSERT INTO bhg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Aodarida atopapasigari ae Parasi mane de, imomane awa embobo iwawa tote (2)de, awatedo imomane do ari! Itomane buroda sagaro 10 de, roriwa 10 de siloti 10 de kundo pamo evekara tamonde (3) siya edo ewa. Edo pamo da (1) ainda sagaro da (1), pamo nei ainda roriwa da (1) edo pamo nei ainda siloti da (1) awa avigedo God de piedo ewa. Ata God da Aodarida atopatari bajinabé bajina: embomai nenei sima dave awate, edo embomai do awate, edo itomane gebé ari God da yai piawate awa, inemane ae edo ewa. Dave awa itomane buro rorae 10da da (1) awa God de matawa piedo ewa. Ata dá ango embomai nenei sima dave eite, edo embomai do eite, edo itomane gebé ari God da yai piedo ewo. ");
INSERT INTO bhg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Imomane gisijijiegari jisiguba aride, itomane un indari yeyega mana toraina kotembeteite usisi akouda tamonda piedo un vekogedo ewa. Ata wo bajina kamelo awa nutugedo ewa! ");
INSERT INTO bhg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Aodarida atopapasigari ae Parasi mane de, imomane awa embobo iwawa tote (2)de, awatedo imomane do ari! Imomane aia akou ae teo de awa tamo teiedo ewa, ata itomane motou ari de edo wasiri dambu darae demi do itomane awa ato ae ari. ");
INSERT INTO bhg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Imo Parasi jisiguba ari! Gisibé akou ae teo deda do awa teieyo, dono arapa tamonda awa daedo itae are. ");
INSERT INTO bhg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Aodarida atopapasigari ae Parasi mane de, imomane awa embobo iwawa tote (2)de, awatedo imomane do ari! Imomane awa ganuma ango goiari udeda embomaimi ove ainyami gutedo era. Ainda arapada awa duroka dave, ata ainda doda embo betarida vetu ae rorae neide kainde depeka ari demi ato ae ari. ");
INSERT INTO bhg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Edo dá ango itomane kariwa embo enemboda jisida awa wasiri dambu darari, ata iwawa tote (2)deda umbugo de jimbo bebegae demi itomane do beda ari. ");
INSERT INTO bhg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Aodarida atopapasigari ae Parasi mane de, imomane awa embobo iwawa tote (2)de, awatedo imomane do ari! Inemane peroveta mamatuda goiari ude davebé gamundo ewa, edo embomai wasiri dambu dararida kotembu kotembu ari ude giropagiro edo ewa. ");
INSERT INTO bhg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Edo inemane tedo ewa, ‘Edo kaenato apiye ewowoda ijide kaena daedo itae etena gido awa, kaenane awamanede dada edo peroveta mane mana dano betae etera.’ ");
INSERT INTO bhg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Awatedo imomane akuta gebé arapada tedo ewa awa, imomane awa embobomi peroveta mane deoro betedo esitera da mamai. ");
INSERT INTO bhg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Edo itomane apiye ewowomi jimbo beyae tega ro inge tuturo esitera awa inemane itae bé ewoǃ ");
INSERT INTO bhg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Jimango! Imomane awa jitomada mamai! Edo God mi imomane katedo yai niyao matawa aveira ainda piari mambawa awa, nongo edo idegavi? ");
INSERT INTO bhg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Awatedo giwo! Nanemi itomane yaida peroveta mane de, dubogari embobo de Aodarida atopapasigari de piano mambara. Edo inemane nenei awa dawo betara, edo oregada dawa, edo nenei itomane benunu oro doda awa vedawa, edo nasi bajina neida edo maundo neida memesi neide kainde awamaneda yai piedo awa. ");
INSERT INTO bhg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Awatedo God mi dari betari embo berari ainkainmi embomai wasiri dambu darari deoro betedo esitera awamaneda rirowa itomane yaida piaina. Ango edo embo ainmi wasiri dambu darari embo Abel desiri besisina edo gundo imomane ainmi Zechariah, Berechiah da mai, oro kotopu bajina edo rorou piari tenembada toropuda ainda detewo besisina, edo dari betari embo berari ainkainmi wasiri dambu darari embomai nenei Abel de Zechariah deda iji toropuda detero besitera awa, awamaneda rirowa awa God mi itomane yaida piaina. ");
INSERT INTO bhg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Eiwa awa gebé imondemane tena, dari bebetegari berari einda rirowa God mi embomai iji einda iterada yai piaina. ");
INSERT INTO bhg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem embomai, Jerusalem embomai, imomane peroveta mane deowo betedo era, edo embobo God mi pieuri gundo era awa ganumami augedo deowo betedo era. Na iji jiwae imomane God da rirowada toregain jipapa edo etena, teta ni kokora aimi wasimi ainda mamai topo doregidaregi edo eira. Ata imomane na jipapa ae edo na ajiregedo etewa. ");
INSERT INTO bhg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Giwo! God mi itomane oroda embo da ji awa dowainyae. ");
INSERT INTO bhg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Edo nane imondemane tena, imomane na mana tekago gawa, isima ango na gumano gosite tawa, ‘God da ao ari embo einda yai itare! Embo eiwa Badari da daoda gupeira.’” ");
INSERT INTO bhg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ango edo Iesu Jew embomaida oro kotopu bajinada edo idegedo maunteiri ainda ambodani gundo ami oro kotopu ainda oro kariwa neide kainde garate sitera. ");
INSERT INTO bhg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ata Iesu mi awamanede sisina, “Imomane rorae berari eiwa gotevi? Eiwa awa gebé imondemane tena, oro kotopuda oro neide kaindeda ganuma berari einda dedo sitedo agaugaro wotara.” ");
INSERT INTO bhg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Edo Iesu Olive de Pejida anumbedo isiri, ambodani akuta ainda yai gundo sitera, “Nakare teyo gore! Oro kotopu bajina sitedo durari teteta awa, ijibé nonde idegaini? Edo ito gumbari ae iji beao ari deda kariwa ro idegaini?” ");
INSERT INTO bhg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Edo Iesu mi awamanede mina sisina, “Embo jiwae nato daoda gundo site ‘Na awa Keriso,’ edo embomai jiwae udumbara, awatedo imomane akuta goteite iwo. Embo neimi imomane udumainyae. ");
INSERT INTO bhg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Edo imomane itoro jiwae idegedo era ainda bino edo itoro nenei idegae etera ainda bino awa ingawa, ata ge awa ingido do buriya eove. Roviravi berari eiwa idegaina, ata iji beao ari awa gumbae isira. ");
INSERT INTO bhg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ewowo yai neneidami erido ewowo yai neneida ainde duduno ara, edo daotari neneida embobomi erido daotari neneida embobode itoro ara. Edo embo jiwaebé indari itae ari beji bebetegara, edo embo jiwaebé karu amburo bebegaebé bara, edo butu dededa, yai evekarada jijira tawaina. ");
INSERT INTO bhg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Roviravi berari eiwa dá tuturoda eutumi mai engarida memesi babaingae budo eira ango. ");
INSERT INTO bhg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Edo iji ainde, itomane gitopo embobomi imomane kundo piaro memesi neide kainde bawa, edo daro betawa. Imomane awa nato ambodani, awatedo orobe babain beraridami imomane jipapa ae ara. ");
INSERT INTO bhg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ango edo embo jiwae awamaneda gebé ari nato yai awa dowara. Edo awamane akuta awamaneda gitopo emboda ipada mina piya ara, edo jipapa ae mina ara ara. ");
INSERT INTO bhg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Edo peroveta pitawa jiwae idegedo embomai jiwae udumbara. ");
INSERT INTO bhg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aindabé embomaida wasiri bebegae ari awa bajido arapu aina, embomai jiwaeda dubo mina bara ari awa damodamo aina. ");
INSERT INTO bhg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ata embo ainmi ainda tumonda ari nato yai dowae matawa piaina awa, edo imo iji beao arida ango mamaina awa, God mi toregaina. ");
INSERT INTO bhg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Edo God da gisijiarida bino dave eiwa butu dededa karigaro orobe babain yai berarida ami ge eiwa ingara. Ango edo iji beao ari gumaina. ");
INSERT INTO bhg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Awatedo, iji ainde ‘rorae beyaebé’ yai kotopuda kundo maundo doda piaro petedo isite, ami mengari bajinabé God da embomaida yai piari gawa. Iji matuda peroveta Daniel mi ge ango sisina.” (Imo ainmi ge eiwa ajijigeteite gido, bé kotembeyo!) ");
INSERT INTO bhg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Iji ainde rorae awa idegari embomai yai Judea da itera awa burigibé tumundo peji pamoda visido kaviegari borote. ");
INSERT INTO bhg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iji angode embo da ain ainda mando tada isira awa, dowari wotedo ainda mando doda rorae nei ro bainyae. ");
INSERT INTO bhg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Daedo, embo da ain buroda eimango tekago egenembedo aundo ainda ombarijiari bainyae. ");
INSERT INTO bhg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","21","Edo memesi bouga bajina embomaida yai idegaina, dá tuturoda butu esisina ainda edo gundo boroko einda ango awa gisi idegae, edo tekago mana idegaina. Awatedo deguta angogode, do ari awa eutumai watoude ae aimono mamai ami beda itera ainde! Ata God da yai benunu tewo, ‘Nakare dowato bisibubura yoade ko Oena Apari Degutade adu tumundo peji pamoda vitóre.’ ");
INSERT INTO bhg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Edo God mi deguta angogo awa kapae dowari idegaina awa, embo da ain kaviegari mana baina. Ata ainda gerari embomai awaembo deguta angogo awa kapari tupo aina. ");
INSERT INTO bhg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","Edo keriso mane pitawa ae peroveta mane pitawa de idegedo embomai udumain tedo kariwa babain de wasiri babain de awa piara. Edo daedo God da gerari embomai udumain ara. Awatedo, edo embo da ainmi imondemane taina, ‘Giwo, Keriso eire!’ o, ‘Awa oure!’ awamane gebé ainyae. ");
INSERT INTO bhg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Giwo! Nane roviravi awa idegae gisida awa garedo ge eiwa imondemane tetena. ");
INSERT INTO bhg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","28","“Aindabé dá piripirida parara iji vitarida datembedo maundo iji wotarida euri embomai berari gido era ango, daedo embo berarimi Embo da Mai da gumbari awa gara. Edo yai nonda betari tamo isiuri ni barupimane gundo dada utedo era dá ango, embo berarimi ainda gumbari gara. Awatedo iji ainde awamanemi imondemane tara, ‘Oure giwo! Embo awa abu damodamoda ounda isira,’ ango taro idegedo mambove; ko ‘Eire giwo! Embo awa mando do jiumbarida einda isira,’ ango taro gebé eove. ");
INSERT INTO bhg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Edo deguta angogoda memesi bouga bajina amboda, burigibé ijida parara kumboro aina, edo karigada parara datembari dowaina; dabori utuda tokedo durara, edo God mi utuda rorae berari awa jipaina. ");
INSERT INTO bhg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Edo iji ainde, Embo da Mai da kariwa awa utuda idegaina, edo ewowo berari butu dededa ami mamato ara. Edo awamanemi Embo da Mai utuda poraga tamonda gorobade taogari bajinade gupeiari gara. ");
INSERT INTO bhg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Edo ine to yavi bajina ami ainda anelamane piari maundo ainda gerari embomai butu de utu deda umbugo berarida sirigedo kundo gundo dada ara. ");
INSERT INTO bhg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Edo eniya ge ni dungada atopatari awa kotembewo! Iji ainde ainda yanda teteka dadain jivedo eira, imomane gari budo ewa, tuvira iji awa aikae. ");
INSERT INTO bhg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Imomane daedo iji ainde rorae berari eiwa idegari gawa awa giwo! Ainda gumbari iji awa aikae, manguro beda. ");
INSERT INTO bhg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eiwa awa gebé imondemane tena, embomai iji einda itera awa betae gisida isiaro jirari, rorae eiwa berari idegaina. ");
INSERT INTO bhg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Rorae berari utuda edo butuda awa mandedo itae aina. Ata ge nato awa mana mandedo itae aina. ");
INSERT INTO bhg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ata embo da ainmi ainda gumbari deguta edo ora awa gae. Edo daedo anelamane utuda awa gae. Ata nato Mamo akuta awa gari. ");
INSERT INTO bhg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ata dá Noah da ijide wasiri ro embomi edo esitera ango, awamanemi daedo ango eiaro iji ainde Embo da Mai gumaina. ");
INSERT INTO bhg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Aindabé deguta angogode un dauma gumbae gisida, embomai dá ango indari indeite, un indeite, iu aro jipero, edo deguta awa gumbiri Noah un ma akida totorisina. ");
INSERT INTO bhg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Edo awamane ro idegaini awa gae itero un dauma gundo awamane berari pasiri un injido bebetegesitera. Daedo ango eiaro iji ainde Embo da Mai gumaina. ");
INSERT INTO bhg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Edo embo tote (2) indari buroda eiaro God mi embo da (1) budo nei dowaina. ");
INSERT INTO bhg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Edo eutu tote (2) wheat ganumami mundeiaro God mi eutu da (1) budo nei dowaina. ");
INSERT INTO bhg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Aindabé ora nonde itomane Badari gumaini awa imomane gae, simageteite isiwo. ");
INSERT INTO bhg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ata eiwa giwo. Edo mando tutumi beono embo ora nonde gumaini awa gisi gari, ainda mandoda simagari dowainyae, edo beono embomi bededo torari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Edo Embo da Mai da gumbari awa dá ango, aindabé ora nonde imomane kotembae eiawo embo awa gumain eira. Awatedo imomane daedo siya ewo.” ");
INSERT INTO bhg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Edo Iesu mi sisina, “Buro embo ain gebémi edo dubogarimi buro dave edo eiri? Embo awa ainda badarimi gisijiarida dero avigaina. Ango ari buro embo ami badarida mando sima eite buro embo neneida indari iji tegabéda awamaneda yai piedo aina. ");
INSERT INTO bhg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Edo dubodave awa buro embo ainmi buro ango eiari ainda badari tekago overegedo gundo gaina. ");
INSERT INTO bhg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Eiwa awa gebé imondemane tena, badarimi buro embo awa avigari ainda gunaguguye berari awa sima aina. ");
INSERT INTO bhg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Awarata, edo buro embo awa beyae, ami imo akuta taina, ‘Nato badari iji ribori ounda isite boraebé tekago gumainyae. Awatedo na buro ro ana embo awa gari tao ae.’ ");
INSERT INTO bhg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ango tedo imo tuturo edo ainda buro otatawo dedo gaiedo aina. Edo imo un okain jiwae injido dutari embobode daedo indari de un de injido kundo aina. ");
INSERT INTO bhg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Edo ango eiari, ainda badari tekago overegedo gumaina deguta imo gae ko ora ainde awa imo kotembae. ");
INSERT INTO bhg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ango edo badarimi embo awa dedo kupo tote (2)de butedo piari maundo embomai iwawa tote (2)de daedo yai beyae ainda ji site edo ji vegeite itara. ");
INSERT INTO bhg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Edo utuda gisijiari awa engo aina. Iji da (1)de eutu teteka 10mi awamaneda keimo da da kundo idegedo jimbari tutu awa tamain maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Edo awamane ipa da (5) awa dubogari, edo ipa da (5) awa kotembari itae. ");
INSERT INTO bhg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Edo kotembari itae ami awamaneda keimo kundo maunsitera, ta gama deposi sigida awa kundo mambae. ");
INSERT INTO bhg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ata dubogari ami awamaneda keimo ae gama deposi sigida gerigari de kundo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ata jimbari tutu gumbae iji borerebé esiri awamane jitao dein edo jitao autera. ");
INSERT INTO bhg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Edo muyae toropuda ainda gumbari awa aorogatedo sisina, ‘Eire giwo! Jimbari tutu gupeira. Eriwo idegedo embo awa tambave!’ ");
INSERT INTO bhg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ango edo eutu teteka berari erido awamaneda keimo siya esitera. ");
INSERT INTO bhg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Edo awamane kotembari itae ami awamane dubogari ainde sitera, ‘Natokare keimo aikae akeimbara. Awatedo itomane gama sakami nakare kondade edo piewo bore.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ata dubogari ami ge mina sitera, ‘Ango ae. Gama eiwa ingenamonde inono ari tao ae. Awarata gama oriari emboda yai mambuwo itomane topo oriave.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ata awamane gama teka ori aintedo mauntero jimbari tutu awa gupusina. Edo eutu teteka matu siya ari, awamane awa ae embo ainde jimbari bondoda totoritera. Ango edo manguro jijitera. ");
INSERT INTO bhg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Edo ainda amboda, eutu teteka neneimi daedo gundo sitera, ‘O badari, badari, natokare yaida manguro pirige!’ ");
INSERT INTO bhg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ata ami ge mina sisina, ‘Eiwa awa gebé imondemane tena, na imomane gae.’ ” ");
INSERT INTO bhg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Edo Iesu sisina, “Deguta rori ko ora rori Embo da Mai gumaina awa imomane gae. Awatedo simageteite isiwo! ");
INSERT INTO bhg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Edo tekago utuda gisijiari awa engo aina. Iji da (1)de embo da (1)mi yai aikeda pepeta edo mamain ari, ami ainda buro embobo dao tesiri gumbero awamanede ainda ganu awa sima orote pipisisina. ");
INSERT INTO bhg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Edo embo da (1) buro ari ganu bajinabé bajina sima arate ainde awa, 5,000 kina pipisisina. Edo embo nei buro ari ganu bajinabé sima arate ainde awa, 2,000 kina pipisisina. Edo embo nei da (1) buro ari ganu bajina sima arate ainde awa 1,000 kina pipisisina. Edo dá awamaneda inono arida tega gosite ango pipisisina. Ango edo burigibé dodo imo pepetada maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ango edo embo 5,000 kina burisina, ami kundo maundo buro edo 5,000 kina nei awa burisina. ");
INSERT INTO bhg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Edo dá ango, embo 2,000 kina burisina, ami kundo maundo buro edo 2,000 kina nei awa burisina. ");
INSERT INTO bhg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ata embo 1,000 kina burisina, ami maundo uro butuda duredo ainda badarida ganu awa goiedo onjigesisina. ");
INSERT INTO bhg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Edo iji riboribé itae esiri amboda buro emboboda badari awa egenembedo gundo sisina, ganu awa ine gisi pipisisina edo ganu nenei awamane buritera awa berari kundo gundo dada aro udugedo garate. ");
INSERT INTO bhg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Edo embo 5,000 kina burisina awa 5,000 kina nei kundo gundo sisina, ‘Badari, imo 5,000 kina namonde pipisiteta. Giyoǃ Na buro edo 5,000 kina nei daedo kundo gumena.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Edo ainda badarimi embo ainde sisina, ‘Buro dave eteta. Imo awa buro embo dave edo gebé ari. Ine rorae indewae awa gebémi sima dave edo esiteta. Awatedo nane imo avigedo roviravi jiwaeda gisijiari piana. Puyo! Ito badaride daedo yawa ate.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Edo embo 2,000 kina burisina awa daedo gundo sisina, ‘Badari, imo namonde 2,000 kina pipisiteta. Giyo! Na buro edo 2,000 kina nei daedo kundo gumena.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Edo ainda badarimi embo ainde sisina, ‘Buro dave eteta. Imo awa buro embo dave edo gebé ari. Ine rorae indewae awa gebémi sima dave edo esiteta. Awatedo nane imo avigedo roviravi jiwaeda gisijiari piana. Puyo! Ito badaride daedo yawa ate.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ango edo embo 1,000 kina burisina ami gundo sisina, ‘Badari, na gositena, imo awa embo okain. Rorae ine urae awa tokedo eta. Edo rorae ve ine purara piae awa ainda be kundo dada edo eta. ");
INSERT INTO bhg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Awatedo na adu edo idegedo ito ganu awa butuda goiedo onjigesitena. Giyo! Ganu ito awa eire.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ata ainda badari mi embo ainde mina sisina, ‘Imo awa buro embo jimbo beyae ari edo beowo ari! Ine teteta imo gositeta, rorae nane urae awa tokedo ena, edo rorae ve nane purara piae awa ainda be kundo dada edo ena. ");
INSERT INTO bhg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Awatedo ito dave awa inemi nato ganu awa ganu sima ari emboda yai piato isite badari, na tenda egenembedo, ganu nenei nato ganu tamonda piaro awa daedo bane. Ata ango ae esiteta.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Edo badarimi buro embo neneide sisina, ‘1,000 kina embo einda ipada awa dodo kundo buro embo ami 10,000 kina bira, ainde piewo bare. ");
INSERT INTO bhg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aindabé embo berari ainkainmi rorae God mi piesiri jigamo dave edo era awa, awamanede rorae jiwae nenei piari bara. Ata embo ainkainmi rorae God mi piesiri jigamo ae dumbae edo era awa, awamaneda yai ro matu pipisisina awa dodo baina. ");
INSERT INTO bhg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Edo buro embo beyae awa arapada augewo muyaeda idegare yai embomai ji site edo ji vegeite isima edo ara ainda.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Edo iji nonde Embo da Mai, ainda taogari ae ainda anela kokotopu beraride gumaina, angode awa ainda daotari anumba taogarideda anumaina. ");
INSERT INTO bhg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Edo orobe babain berari butu dededa awa ainda dombuda dada aro kataina. Edo dá wo sima ari embomi wo sipumane edo goutu mane awa avigekavige edo eira ango, imo awamane avigekavige aina. ");
INSERT INTO bhg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ango edo ine wo sipumane awa kundo ainda ipa beda piaina, ata wo goutu mane awa kundo ipa andada piaina. ");
INSERT INTO bhg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","“Edo Daotarimi embomai ipa beda awamanede taina, ‘Mamo natoda dubodave itomane yai isira. Iji angode na bejide iteno imomane na indari rorae pipisitewa, edo na un udo tameno imomane na un pietewo injitena. Edo na awa itomane embo topo ae edo na itomane mandoda kundo ategedo buritewa. Edo na ombarijiari inono ae iteno imomane pietewo oputena. Edo na karu edo iteno, imomane na sima dave esitewa, edo na bundari oroda iteno imomane gundo na etega esitewa. Awatedo puwo, gisijiari yai awa butu gambae gisida God mi imomane embo siya esisina kumbave.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ango edo embo wasiri dambu dararide ami ge mina ainde tara, ‘Badari, iji nonde nakare imo bejide iteto gido indari imonde pipisiteri, ko un udo tapeto gido un pietero injitesi? ");
INSERT INTO bhg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Edo iji nonde nakare imo embo topo ae ango gido edo imo natokare mandoda kundo ategedo buriteri, ko ombarijiari inono ae iteto gido ombarijiari pietero oputesi? ");
INSERT INTO bhg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Edo iji nonde nakare imo karu edo iteto gido guputeri, ko bundari oroda iteto gido gundo imo etega esiteri?’ ");
INSERT INTO bhg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Edo Daotarimi awamanede ge mina taina, ‘Eiwa awa gebé imondemane tena, buro ro inemane nato nanonameji eiwamaneda embo dao sakabé sakada yai esitewa awa, nato yai esitewa.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","43","“Edo ami daedo embomai ipa andada awamanede ge taina, ‘God da begá itomane yai isira. Iji angode na bejide iteno imomane na indari rorae piae, edo na un udo tameno imomane na un piae. Edo na itomane embo topo ae awa imomane na itomane mandoda budo ategae. Edo na ombarijiari inono ae iteno, imomane na ombarijiari piae. Edo na karu edo bundari oroda iteno imomane gundo na etega ae. Awatedo nato yai dodo niyao natopo itari aveira ainda mambuwo. Rirowa awa God mi Binei ae ainda anelamane de piain matu siya esisina.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ango edo awamanemi daedo ge mina tara, ‘Badari, iji nonde nakare imo bejide iteto gido, o un udo tapeto gido, o embo topo ae ango gido, o ombarijiari inono ae iteto gido, o imo karude o bundari oroda iteto gido gundo imo kondade ae esiteri?’ ");
INSERT INTO bhg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Edo ami awamanede mina taina, ‘Eiwa awa gebé imondemane tena, buro ro inemane eiwamaneda embo dao sakabé sakada yai ae esitewa awa, nato yai ae esitewa.’ ");
INSERT INTO bhg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Edo awamane awa dodo rirowa natopo itari yaida mambara, ata wasiri dambu darari embomai awa wasiri natopo itari yaida mambara.” ");
INSERT INTO bhg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ango edo Iesu ge berari eiwa tedo itae edo, ainda amboda ambodanide sisina, ");
INSERT INTO bhg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Imomane gari deguta tote (2) itae ari awa God da Darutegari Bondo tuturo ara. Edo iji ainde Embo da Mai awa gitopo embomaida ipada piari oregada daro betaina.” ");
INSERT INTO bhg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Edo pirisi babain de Aodarida atopapasigari de Jew gisijijiegari de gundo pirisi maneda gisijiari bajina Caiaphas da mando bajinada doregesitera. ");
INSERT INTO bhg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Edo awamane begata nonda ge pitawa tedo Iesu udumbedo kundo daro betaini awa jijiritera. ");
INSERT INTO bhg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ata awamanemi sitera, “Embomaimi gido sinigambari ge bajinabé tedo gundo doregedo iwata tepotapo ara, awatedo kaena wasiri eiwa bondo ijide ainyae.” ");
INSERT INTO bhg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Edo iji ainde Iesu awa Betani nasida Simon da mandoda. Edo Simon awa embo ginimi tutupegari. ");
INSERT INTO bhg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ango edo Iesu anumbedo indari indeite isiri, eutu da (1)mi sigi alebasita ainda un muno davede kundo gupusina. Edo awa mina bajinabé piedo bari rorae. Edo eutu ami un awa Iesu da kopuruda dodegesisina. ");
INSERT INTO bhg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ata iji angode ainda ambodanimi wasiri awa gido awamane sinigambari edo sitera, “Ro awaembo rorae eiwa usibesi eiri? ");
INSERT INTO bhg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Un muno davede eiwa inono piari embo neimi ganu jiwae piedo bari tao. Ango edo ganu awa embomai rorae isisigaede piae esira.” ");
INSERT INTO bhg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","12","Ata Iesu mi awamaneda kotembari awa gido sisina, “Ro awaembo eutu ainde mengari ge tevi? Eutu ami nato tamoda un muno davede dodegesira awa, nato goiari awaembo siya esira. Iji berari embomai rorae isisigae awa imondemane isima edo era, ata na imondemane einda matawa itari tao ae. Awatedo eutu awa buro beyamanabé namonde esira. ");
INSERT INTO bhg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Eiwa awa gebé imondemane tena, butu arapuda embomi bino dave eiwa karigeteite, wasiri ro eutu emi namonde esira awa daedo taro embomaimi gido kotembu kotembu edo ara.” ");
INSERT INTO bhg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ango edo Iesu da embobo 12 ainda da (1), dao Judas Iscariot awa, pirisi babainda yai maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Edo ami sisina, “Embo awa kundo itomane ipada piano namonde rorae ro piavi?” Ango tesiri gido awamanemi ganu silver 30 awa ajigedo ainde pipisitera. ");
INSERT INTO bhg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ango etero iji ainde Judas tuturo edo iji bé nonde Iesu kundo awamaneda ipada piain awa gain edo esisina. ");
INSERT INTO bhg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ango edo Bread Badari Siwo Piaeda Bondo deguta tuturoda ainde, ambodani gundo Iesu de tedogositera, “Imo yai nonda nanekare God da Darutegari Bondo imo embo siya orote jipapa esi?” ");
INSERT INTO bhg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Edo ami sisina, “Nasi bajinada torido embo da (1) ainda yai maundo ainde tewo, ‘Atopatarimi sira, “Nato iji awa atutumbesira. Awatedo na ae nato ambodani de God da Darutegari Bondo awa ito mandoda indara.” ’” ");
INSERT INTO bhg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ango tesiri ambodani Iesu mi ro orote sisina awa, kera edo Darutegari Bondo mando ainda siya esitera. ");
INSERT INTO bhg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Edo iji wotesiri turo damodamo eiri Iesu ae ainda embobo 12de indari inain anumbesitera. ");
INSERT INTO bhg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Edo iji angode awamane indari indero ami sisina, “Eiwa awa gebé imondemane tena, imomane da (1)mi na kundo gitopo emboda ipada piata.” ");
INSERT INTO bhg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Edo ge ango tesiri ambodani dubo vevera bajinabé esitera. Edo iji ainde awamane berari ainda da dami tuturo edo ainde sitera, “Badari, amo na rita?” ");
INSERT INTO bhg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Edo Iesu mi mina sisina, “Embo ainmi namonde daedo ainda bread jido teoda tu doda pasira, ami na kundo gitopo emboda ipada piaina. ");
INSERT INTO bhg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gebé, Embo da Mai betaina, matu God da Ove Gaiari dá gaguritera ango. Ata do ari embo ainde tena, ainmi Embo da Mai awa kundo gitopo emboda ipada piaina. Davebé awa ainda aimi embo awa dowae engisina.” ");
INSERT INTO bhg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Edo Judas, embo dá ain Iesu kundo gitopo emboda ipada piain eira, ami mina sisina, “Atopatari, amo na rita?” Ango tesiri Iesu mi ainde sisina, “Inemi teteta awara.” ");
INSERT INTO bhg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Edo awamane indari indero Iesu mi bread kundo God ategedo engegegedo ambodanide piedo sisina, “Kundo injiwo. Eiwa nato tamo.” ");
INSERT INTO bhg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ango edo ami akou kundo God da yai ategari pisido awamanede pipisite sisina, “Imomane berari eiwa budo injiwo. ");
INSERT INTO bhg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Waini eiwa awa nato ororo. Iji ainde na betana, ororo nato yaida edo wotari gido, God mi embomai jiwaeda jimbo bebegae awa kotembedo dowaina. Edo God mi nato ororomi ainda awara edo tari petari teka ainda embomai awaembo sirigaina. ");
INSERT INTO bhg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Edo nane imondemane tena, na iji nei gurepida gama engo inainyae isiano jirari imondemane daedo teka awa inana, Mamo natoda gisijiari yai.” ");
INSERT INTO bhg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ango edo awamane yami God dasiga edo idegedo Olive de Pejida maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ango edo Iesu mi awamanede sisina, “Muyae boroko einde imomane berari itomane gebé ari nato yai awa dowawo wotaina, aindabé God da Ove Gaiarida tari isira eiwa: ‘Nanemi Wo Sima Ari Embo dari betaina, edo wo sipumane dada ari awa evekara ara.’ ");
INSERT INTO bhg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ata amboda God mi na jiari erana, edo imomane mambae gisida, na yai Galili ainda mamana.” ");
INSERT INTO bhg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Edo Peter mi Iesu de mina sisina, “Embo berarimi wasiri ro ito yaida idegari gido awamaneda gebé ari ito yai dowaro wotaina, awarata nanemi nato gebé ari ito yai mana dowano wotaina.” ");
INSERT INTO bhg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Edo Iesu mi ainde sisina, “Eiwa awa gebé imonde tena, muyae boroko kokora jianda aoro tae gisida, iji tamonde (3) imo akuta toreite tata, ‘Embo awa na gae.’” ");
INSERT INTO bhg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ata Peter mi ainde sisina, “Edo na imonde daedo daro betanate tara, na mana akuta toreite imo gae tana.” Edo ambodani nenei berarimi ge dá ango sitera. ");
INSERT INTO bhg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ango edo Iesu ae ainda ambodani de yai Gesemani ainda maunsitera. Edo ami awamanede sisina, “Imomane einda anumbedo isiwo. Na imango ounda benunu tane.” ");
INSERT INTO bhg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Edo Iesu Peter de Zebedee da mamai tote (2)de budo awamanede daedo maundo, edo imo tuturo edo dubo vevera edo do buriya esisina. ");
INSERT INTO bhg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Edo Iesu mi awamanede sisina, “Na dubo vevera bajinabé burena, na betena ango. Einda namonde daedo isite simagewo.” ");
INSERT INTO bhg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Edo imo saka iaragedo ainda tamo butuda augedo durudo dombu butu kenada benunu sisina, “O Mamo nato, edo imo ari tao ari gido, memesida akou eiwa nato yai dodo kumbuyo. Awarata nane jipapa ena ango ainyae, ata ine jipapa eta.” ");
INSERT INTO bhg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Edo imo gundo ainda ambodani tamonde (3) awa jitao avero gosisina, edo Peter de sisina, “Imomane namonde daedo ora da (1)bé awa simagari tao ae! ");
INSERT INTO bhg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Simageteite benunu tewo. Imomane bawarida durove. Asisi itomane bawari daginegari jipapa eira, ata itomane tamopisi awa burau eira.” ");
INSERT INTO bhg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ango tedo imo tenda overegedo maundo benunu sisina, “O Mamo nato, edo memesida akou eiwa, inanate siteta awa, imo nato yai dodo kumbari tao ae, ito jipapa awa eyo.” ");
INSERT INTO bhg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Edo Iesu tenda overegedo gundo ainda ambodani jisi gundedo itari tao ae jitao avero gosisina. ");
INSERT INTO bhg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Edo imo awamane tuturoda iji tote (2) dodo maundo benunu sisina ango, tenda maundo benunu dá awa sisina. ");
INSERT INTO bhg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ango edo Iesu overegedo ainda ambodanida yai gundo awamanede sisina, “Imomane matawa jitao aveite edo oena apevita? Giwo! Iji aikae esira, edo Embo da Mai awa kundo embo bebegaeda ipada piain eira. ");
INSERT INTO bhg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Eriwo, kaena mambore! Giwo, embo na gitopo emboda ipada piaina awa, matu gumbira eire!” ");
INSERT INTO bhg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Edo Iesu matawa ge site isiri, boraebé Judas, Iesu da embo 12 ainda da (1), ami embobo jisi bajina awamaneda kasiwo de tasinya de kumbero daedo gupusina. Awamane awa pirisi babain de Jew gisijijiegari demi pipisitera. ");
INSERT INTO bhg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Edo embo Iesu kundo ainda gitopoda ipada piaina, ami kariwa matu siya edo awamanede tesiri gositera, “Embo nane ategedo opoda munegana, embo awawa kumbuwo!” ");
INSERT INTO bhg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Edo boraebé Judas gundo Iesu de sisina, “Oro, Oro, Atopatari!” edo opoda munegesisina. ");
INSERT INTO bhg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ata Iesu mi embo ainde sisina, “Otawo, imo ro ain gumbesi?” Ango tesiri awamane gundo Iesu jido buritera. ");
INSERT INTO bhg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Edo ango ero boraebé Iesu da ambodani da (1)mi ipa piedo ainda kasiwo worugedo budo pirisi maneda gisijiari bajinada buro emboda dengoro da (1) awa dedo kautugesisina. ");
INSERT INTO bhg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ango esiri Iesu mi embo ainde sisina, “Kasiwo ito ainda yaida tenda pie. Embo berari ainmi kasiwo kumbara awa kasiwomi daro betara. ");
INSERT INTO bhg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Imo gaeta? Na inono Mamo natode tedogano ami namonde burigibé itoro ari anelamane jisi 12 daginegari awa piari gumbara. ");
INSERT INTO bhg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ata edo nane ango ana awa, God da Ove Gaiarida ge isira awa nongo edo idegedo bé aini?” ");
INSERT INTO bhg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Edo iji ainde Iesu mi embo jisijisi ainmi imo jido buritera awamanede sisina, “Imomane na beono embo beyaebé ango baintedo kasiwo de tasinya de gumbarago etewa. Ro embo imomane oro kotopu bajinada na kumbae doturavi? Audo erido na yai ainda anumbedo embomai atopasido eono gido etewa. ");
INSERT INTO bhg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ata wasiri berari eiwa idegesira awa, peroveta manemi God da Ove Gaiarida gaguritera awa bé arate.” Edo ambodani berari imo dodo adu tuputera. ");
INSERT INTO bhg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ango edo embobo Iesu buritera, ami imo gisijido kundo pirisi maneda gisijiari bajina Caiaphas, ainda mandoda maunsitera. Edo yai ainda awa Aodarida atopapasigari de gisijijiegari de awa matu doregesitera. ");
INSERT INTO bhg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Edo Peter aikeda imo ambo ambo edo pirisi maneda gisijiari bajinada mando guwada gupusina. Edo Peter guwa doda torido sima ari embobode anumbedo isite Iesu de ro ain eri awa gain esisina. ");
INSERT INTO bhg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Edo pirisi babain de gisijijiegari de, Sanhedrin berari ami embo ainkainmi Iesu de bekumba ge pitawami karigaro gido imo daro betarate awa kakowa ero jijirisina. ");
INSERT INTO bhg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ata da ji tambae. Edo ge pitawa karigari embo jiwaemi gundo ge tetero gositera, awaratako da ji tambae. Ata ambobéda, bekumba ge pitawa karigari embo tote (2) gundo ");
INSERT INTO bhg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","sitera, “Embo emi sisina, ‘Nanemi God da oro kotopu bajina awa dedo sitedo tekago jiano erari tao, deguta tamonde (3)da doda.’” ");
INSERT INTO bhg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ango tetero pirisi maneda gisijiari bajinami erido Iesu de sisina, “Imo ge mina tainyae esita? Nongo edo embobo emi bekumba ge ito yaida karigeteri?” ");
INSERT INTO bhg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ata Iesu ge da ji tae. Awatedo pirisi maneda gisijiari bajinami ainde mina sisina, “God wasirideda daoda imonde ge okain eiwa tena: Nakare teyo gore. Imo awa Keriso, God da Mai rita?” ");
INSERT INTO bhg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ango tesiri Iesu mi mina ainde sisina, “Imo ro teta awa awara. Awarata nane imondemane tena, iji amboda, Embo da Mai awa God gorobadeda ipa beda anumbedo isimango utu porogada gupeiari gawa.” ");
INSERT INTO bhg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ango edo pirisi maneda gisijiari bajinami ge awa ingido ainda ombarijiari topo jiri keretero sisina, “Embo emi God da daoda ge bebegae tesira! Ro awaembo kaenanemi karigari embo nenei kakowa ain eri? Giwo! Imomane boroko embo emi ge bebegae God da daoda tesiri ingewa. ");
INSERT INTO bhg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Imomane ro kotembetevi?” Edo awamanemi mina sitera, “Imo buriya bajinabé esira, awatedo daro betarate.” ");
INSERT INTO bhg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ango edo awamanemi ainda dombuda kosiwa edo ipa umbutu edo imo doritera. Edo neneimi ipa do bereya edo embo awa dedo ");
INSERT INTO bhg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sitera, “Imo Keriso ango kotembeteta, awatedo teyo gore, imo ainmi desiri?” ");
INSERT INTO bhg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Edo iji ainde Peter awa mando arapada anumbedo isiri, buro gagara da (1) gundo ainde sisina, “Imo awa daedo Iesu Galili Embo ainde ima edo eteta.” ");
INSERT INTO bhg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ata Peter imo akuta toreite embo berarida dombuda sisina, “Na imo ge ro tesi awa gain darena.” ");
INSERT INTO bhg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Edo amboda Peter idegedo mando guwada torari beda isiri, buro gagara neimi imo gido embomai itera awamanede sisina, “Embo eiwa ae Iesu Nasaret Embo ainde ima edo esira.” ");
INSERT INTO bhg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ata tekago Peter mi imo akuta toreite sisina, “God da jisida gebé tena, na embo awa gae!” ");
INSERT INTO bhg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Edo borere aebé amboda, embobo demonda pepetegari itera ami Peter da yai gundo sitera, “Gebé, nakare gotera, imo daedo awa ouwamaneda da (1). Ito ge yavi ami karigeteira awa imo Galili embo.” ");
INSERT INTO bhg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ango edo Peter tuturo edo ge ikanade sisina, “Na ge pitawa tana awa God mi na begá aina. God da jisida gebé tena, na embo awa gae!” Edo burigibé kokora jianda aoro sisina. ");
INSERT INTO bhg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Edo Peter Iesu mi ainde ge sisina awa kotembesisina, “Kokora aoro tae gisida, iji tamonde (3) imo akuta toreite tata, ‘Embo awa na gae.’” Ango edo Peter dodo guwa beda idegedo dokotembarida memesi bajinabé bureite ji sisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ango edo sipo atesiri, pirisi babain berari de Jew gisijijiegari de awa doregedo nongo edo Iesu daro betaini awa ge jijiritera. ");
INSERT INTO bhg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Edo awamanemi Iesu asimi bundedo gisijido kundo maundo gavana Pontius Pilate da ipada pipisitera. ");
INSERT INTO bhg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Edo iji ainde Judas mi Iesu Jew embomaida babadegarida ipada pipisisina, awamane awa Iesu daro betarate katetera awa gido, imo dubo vevera esisina. Ango edo ganu silver 30 awa tenda kundo pirisi babain ae gisijijiegari deda yai piain gupusina. ");
INSERT INTO bhg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Edo sisina, “Na jimbo beyae etena. Nanemi embo beyae nei ro itae awa emboboda ipada daro betarate pietena.” Edo awamanemi mina sitera, “Nanekare nongo ari? Awa ito buriya.” ");
INSERT INTO bhg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ango tetero Judas ganu silver awa oro kotopu bajina doda augedo idegedo maundo kive edo jimundo besisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Edo pirisi babainmi silver awa kundo sitera, “Ganu eiwa dari betarida mina piari, edo kaenato aodarida tari isira awa, ganu ango oro kotopu bajinada ganude daedo mana piorote.” ");
INSERT INTO bhg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Edo awamane ge jirido kotembari da (1) budo yai ou ari embomi jigamo eora awa oriesitera, embomai yai neneida betari goiari awaembo. ");
INSERT INTO bhg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aindabé ganu awa emboda dari betari oriesisina, awatedo butuda dao tuturoda awa Ororoda Butu. Edo matawa gundo iji boroko einde daedo dao dá ango tedo era. ");
INSERT INTO bhg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Edo ge ro peroveta Jeremiah mi sisina awa bé esisina: “Awamanemi ganu silver 30 awa buritera. Ganu awa embo ainda minada tega awamane awara esitera, edo Israel embomaimi embo ainda minada tega awara esitera. ");
INSERT INTO bhg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Edo awamanemi ganu ami yai ou ari embomi jigamo eora awa oriesitera, dá Badari mi ge okain namonde sisina ango.” ");
INSERT INTO bhg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Edo Iesu gavana Pilate da dombuda pietero peposisina. Edo gavana mi ainde tedogari pipisisina, “Imo Jew embomaida Daotari rita?” Edo Iesu mi mina ainde sisina, “Imo ro teta awa awara.” ");
INSERT INTO bhg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Edo iji angode pirisi babain de gisijijiegari demi Iesu de bekumba ge tedo esitera, ata imo ge mina da ji tae. ");
INSERT INTO bhg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ango edo Pilate mi embo ainde sisina, “Awamanemi bekumba ge jiwae imonde tedo era imo gaeta?” ");
INSERT INTO bhg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ata Iesu ge mina da ji tae esiri Pilate awa kore bajinabé esisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Edo God da Darutegari Bondo iji ainde, duberi da da, Rome da gavana mi embomai jisi da (1)da jipapa awa ambo ambo edo bundari oroda embo da (1) awa udegedo esisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Edo iji dá ainde, embo dao Barabbas awa jivere embo beyae da (1), edo embomai berari imo gari. Edo embo awa bundari oroda isima edo esisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Awatedo embomai doregetero Pilate mi awamanede sisina, “Embo indawa nanemi imomane embo udeganate jipapa evi? Barabbas rita, ko Iesu, dao Keriso tedo era awa ri?” ");
INSERT INTO bhg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Pilate matu gosisina, embomai jiwaebé Iesu ambo ambo edo era, edo Jew embomaida babadegarimi Iesu de do beyae eite jitedo era. Awatedo awamanemi Iesu ainda yai pipisitera.) ");
INSERT INTO bhg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Edo iji angode Pilate awa katari anumbada anumbedo isiri, ainda aromi ge ainda yai piesiri maunsisina: “Deguta boroko na aturo etena, edo aturo doda na embo awa gido do buriya bajinabé esira. Awatedo wasiri dambu darari embo awa udegeyo, ainda yai buro nei ro ainyae.” ");
INSERT INTO bhg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ata pirisi babain de gisijijiegari demi embo jisijisi doregesitera awamaneda do da (1) edo Barabbas awa tedogaro udegarate edo Iesu awa daro betarate sitera. ");
INSERT INTO bhg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Edo gavana Pilate mi awamanede mina sisina, “Embo tote (2) einda doda, indawa nane imondemane udeganate jipapa evi?” Edo awamanemi mina sitera, “Barabbas!” ");
INSERT INTO bhg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate mi awamanede sisina, “Edo ango ana, embo Iesu, dao Keriso tedo era awa, nanemi ainde nongo anate jipapa evi?” Ango tesiri awamane berarimi ainde sitera, “Awa oregada de!” ");
INSERT INTO bhg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Edo gavana Pilate mi sisina, “Ro awaembo? Embo ami buriya bajina ro esiri?” Ata awamanemi aoro ikanade gatedo tedo esitera, “Awa oregada de!” ");
INSERT INTO bhg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Edo iji ainde Pilate gosisina, awamaneda do wareregari tao ae, atako awamane sinigambari ge bajinabé tedo gundo doregedo iwata tepotapo tuturo era. Awatedo imo teo bajina un nukari isira awa budo embo berarida jisida ainda ipa teiedo sisina, “Iwata emi arapa esira, iji ainde wasiri dambu darari embo eiwa daro betaina awa, ainda betarida ororo nato yai itae. Awa itomane buriya!” ");
INSERT INTO bhg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Edo embomai berarimi mina sitera, “Embo ainda betarida ororo natokare yai edo natokare mamaida yai itaina!” ");
INSERT INTO bhg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Edo Pilate mi awamaneda yai Barabbas udegesisina, ata ami tesiri ainda itoro embobomi Iesu vejitera. Edo ainda amboda, Pilate mi embo awa awamaneda yai pipisisina oregada daro betarate. ");
INSERT INTO bhg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ango edo Pilate da itoro embobomi Iesu gisijido kundo maundo Paraetorium da torido itoro embobo jisi da (1) awa berari tetero gundo imo jinenembesitera. ");
INSERT INTO bhg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Edo awamanemi ainda ombarijiari jido teugedo ombari ribori ororo awa ainda tamonda pipisitera. ");
INSERT INTO bhg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Edo awamanemi daotarida gobe dongo bebedemi ari engoegedo ainda kopuruda pipisitera. Edo inguta da (1) awa Iesu da ipa beda pietero jiri ainda doda baongo dadari edo tedojijireite sitera engo, “Oro! Oro! Jew embomaida Daotari!” ");
INSERT INTO bhg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Edo awamanemi Iesu da yai kosiwa edo inguta ainda ipada awa kundo ainda kopuruda ami dedo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Edo iji ainde awamane Iesu tedojirido itae edo, ombari ribori jido teugedo ainda ombari topo awa ainda tamoda piedo imo gisijido oregada dain maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ango edo awamane idegeteite embo dao Simon taputera. Embo awa nasi bajina Sairin edo gumbari. Edo awamanemi embo awa Iesu kondade edo ainda orega amboka arate jijine sitera. ");
INSERT INTO bhg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Edo awamane maundo yai dao Gologata ainda esitera. Ainda moka awa, ‘Kopuru Akouda Yai’. ");
INSERT INTO bhg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Edo yai ainda awamanemi Iesu mi waini jigagani ae siwo dokaka de daedo baige ari awa indarate pipisitera. Ata un awa injido gido, ainda amboda indari jipapa ae esisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Edo itoro embobo imo oregada dedo jiero erido peposisina. Edo Iesu da ombarijiari da da avigedo baintedo, ganuma babaingae ove gaiaride awa augedo ango tetenya esitera. ");
INSERT INTO bhg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ango edo awamane yai ainda anumbedo imo matawa sima ero jijirisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Edo ainda kopuru enoda awa bekumba ge gaiedo detero takimbesisina: EIWA IESU, JEW EMBOMAIDA DAOTARI. ");
INSERT INTO bhg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Edo iji ainde awamanemi beono embo tote (2) awa ae Iesu de daedo oregada doritera, da (1) ainda ipa beda edo nei ainda ipa andada. ");
INSERT INTO bhg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Edo embomai gundo daginegeteite embo ainde ge bebegae tedo esitera. Edo awamane kopuru govegove eite ");
INSERT INTO bhg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","sitera, “Inemi oro kotopu bajina awa dedo sitedo tekago deguta tamonde (3)da doda jiato erari tao siteta. Awatedo imo akuta toregeyo! Edo imo awa God da Mai gido, oregada dodo wote, nakare gore!” ");
INSERT INTO bhg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Edo dá ango pirisi babain ae Aodarida atopapasigari de gisijijiegari de Parasi mane de awamanemi tedojijireite sitera, ");
INSERT INTO bhg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Imo embo nenei toregedo esira, ata ainda wasiri akuta toregari tao ae! Edo imo awa Israel embomaida Daotari gido awa, boroko orega dodo wotari kaenato gebé ari ainda yai piara. ");
INSERT INTO bhg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ainda tumonda ari God da yai isira. Edo inemi tesira, ‘Na awa God da Mai.’ Awatedo God mi jipapa edo gido, imo boroko toregaina.” ");
INSERT INTO bhg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Edo daedo beono embo tote (2) Iesu de oregada doritera ami bekumba ge dá ango ainde tedo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Edo iji ainde awa iji toropu eiri muyae wotedo butu berari awa apuregesisina. Awa matawa maundo iji wareregedo turo 3:00 gupusina. ");
INSERT INTO bhg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Edo ora 3:00 ango turode Iesu aoro ikanade gatedo sisina, “Eli, Eli, lama sabachthani?” (Ainda moka awa, “God nato, God nato, ro embo na dodo taigetesi?”) ");
INSERT INTO bhg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Edo embo nenei yai ainda petari itera, ami ge awa ingido sitera, “Embo eiwa Elijah dao sira.” ");
INSERT INTO bhg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Edo burigibé awamaneda itoro embo da (1) tumundo maundo, pepeu kundo waini jigaganide ainda pasido ingutada kanjigedo Iesu mi indarate pipisisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ata embo nenei yai ainda ami tedo esitera, “Embo awa doyo isiari Elijah gundo imo toregainita awa kaende gore.” ");
INSERT INTO bhg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Edo Iesu aoro ikanade tekago gatedo ainda asisi doturisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Edo giwo! Iji ainde, gongo puruta bajina oro kotopu bajina doda awa isinesina. Edo gongo awawa toropuda keredo, ikane edo wotedo tuda kupo eve kupo eve esisina. Edo daedo butu jipesiri banga bebedegetero ");
INSERT INTO bhg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","goiari ude jiwae awa God mi pirigesisina. Edo embo kotopu jiwae bebetegari awa God mi jiri erido wasiri buritera. ");
INSERT INTO bhg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Edo amboda God mi Iesu betarida jiri erorisina, awamaneda goiari yaida awa dodo nasi bajina kotopu da torido embo jiwaeda yai idegedo esitera. ");
INSERT INTO bhg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Edo itoroda gisijiari ae embo nenei de Iesu sima ero jijirisina. Edo iji angode awamanemi butu jipesira edo wasiri ro berari idegesira awa gido, adu bajinabé edo sitera, “Gebé, embo eiwa God da Maiǃ” ");
INSERT INTO bhg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Edo eutumai jiwae Iesu kondade eimene yai Galili edo ambo ambo edo guputera. Edo awamanemi yai aikeda petedo Iesu goteite itero jijirisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Edo awamaneda doda awa Mary nasi Magadala eutu de, Mary nei James ae Joses deda ai de, edo Zebedee da mamaida ai de. ");
INSERT INTO bhg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ango edo turo jiriri embo gaiapade da (1) nasi Eremateia edo gupusina. Ainda dao awa Joseph, edo imo daedo awa Iesu da ambodani nei. ");
INSERT INTO bhg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Edo embo emi maundo Pilate da yai edo Iesu da tamo bainita awa tedogosisina. Edo Pilate mi Iesu da tamo awa Joseph da yai piorote sisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ango edo Joseph mi tamo kundo gongo virarae dono itae ami doisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Edo embo ami tamo awa kundo maundo ainda banga to teka duredo siya ari ainda piedo, ganuma bajina apepegesiri maundo to be engiregesiri imo dodo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Edo Mary nasi Magadala eutu de, Mary neide awa yai banga to edo kupo neida anumbedo itero jijirisina. ");
INSERT INTO bhg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Edo amboda Siya baiya Ari Deguta itae esiri, audo pirisi babain de Parasi mane de Pilate da yai maundo doregedo ");
INSERT INTO bhg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","sitera, “Embo bajina, nakare kotembetera awa ge pitawa embo ami wasiride isite sisina, ‘Deguta tamonde (3) itae ari amboda, na jiari erana.’ ");
INSERT INTO bhg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Awatedo imo tedogotera, ine ge okain tato itoro embobomi banga to ouwa sima dave eiaro maundo deguta tamonde (3) itae arate. Gae gae edo ainda ambodanimi muyaede gundo tamo awa beono budo embomaide tara, ‘Embo awa betarida jiri erira.’ Edo ango tara, ge pitawa amboda ami awa udumbari ge gisi awa daginegaina.” ");
INSERT INTO bhg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Edo Pilate mi awamanede mina sisina, “Awara, nato itoro embobo awa kundo mambuwo banga to awa simageteite itore. Nongo ain evi awa, itomane garimi ango ewo.” ");
INSERT INTO bhg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Awatedo awamane maundo banga to beda ganuma ainda dedegari kariwa pipisitera. Edo awamanemi itoro embobo yai ainda pietero banga to simagesitera. ");
INSERT INTO bhg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Edo Oena Apari Deguta itae esiri amboda, deguta pura tuturoda sipo teka ateiri, Mary nasi Magadala eutu de Mary neide banga to gaintedo guputera. ");
INSERT INTO bhg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Edo giwo! Badari da anela utuda edo wotesiri jijira bajinami butu jipisina. Edo imo gundo banga to beda ganuma apepegesiri demonda mambiri ainda tamonda anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Edo ainda tamo awa dá parara awa piripiri ari ango, edo ainda ombarijiari awa ainyabé. ");
INSERT INTO bhg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Edo itoro embobo awa imo gido adu edo ipatai jipetero durudo dá embo betari ango esitera. ");
INSERT INTO bhg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ata anelami eutu tote (2)de sisina, “Adu eove. Na gotena, imomane Iesu awamanemi oregada dorara awa gain ewa. ");
INSERT INTO bhg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Embo awa God mi jiri erira dá siutara ango. Awatedo einda itae. Gumbuwo, yai ainda Badari awa durari isiri jirira awa gave. ");
INSERT INTO bhg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Edo burigibé maundo ainda ambodanide tewo gore: ‘God mi imo jiri betarida awa erira. Edo giwo, imomane mambae gisida, embo ami yai Galili da maunteira. Edo yai ainda embo awa gawa.’ Ge ro imomane tote (2)de tetena awa, giwo.” ");
INSERT INTO bhg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ango edo eutumai burigibé banga to idegedo adu de yawa bajina de ainda ambodanida yai bino piain tuputera. ");
INSERT INTO bhg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Edo awamane ainda ambodanide ge taro gorote mauntero, giwo, Iesu awamane tamundo sisina, “Oro! Oro!” Edo awamane atutumbedo baongo dadari edo ainda tai jido imo tumondebain esitera. ");
INSERT INTO bhg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Edo Iesu mi awamanede sisina, “Adu eove. Nato nanonameji da yai mambuwo, tawo gore, awamane yai Galili da mamborote, edo yai ainda na gara.” ");
INSERT INTO bhg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ango edo eutumai mauntero ainda awa, giwo, itoro embobo nenei nasi bajinada torido ro berari idegesira awa pirisi babainde tetero gositera. ");
INSERT INTO bhg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Awatedo pirisi babain ae gisijijiegari demi dada edo ge jirido pietero petesiri itoro embobode ganu silver jiwae pipisite ");
INSERT INTO bhg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","sitera, “Imomane ge embomaide engo tewo, ‘Nakare muyaede jitao avero ainda ambodanimi gundo ainda tamo beono edo kundo eve mambera.’ ");
INSERT INTO bhg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Edo ge eiwa gavana mi ingaina gido, nanekare kondade edo dedegari gemi taro imo dubodave aina edo imomane buriya bainyae.” ");
INSERT INTO bhg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Edo itoro embobo ganu silver awa kundo dá nongo orote sitera ango esitera. Edo ge eiwa Jew embomaida yai arapu esisina edo kundo gundo deguta einda tedo era. ");
INSERT INTO bhg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Edo ambodani 11 awa yai Galili doda peji nonda mamborote Iesu mi sisina, ainda maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Edo iji ainde embo awa gido, awamanemi imo tumondebain esitera; ata nenei itadaita esitera. ");
INSERT INTO bhg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Edo Iesu awamaneda yai atutumbedo sisina, “Awara tari berari utuda edo butuda awa nato yai piesira. ");
INSERT INTO bhg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Awatedo maundo orobe babain yai berarida kondade ewo nato ambodani ore, edo awamane bapataito ewo, Mamo de Mai de Asisi Kotopu deda daoda, ");
INSERT INTO bhg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","edo ge okain berari nane imomane atopasido etena awa, awamane atopasiwo kera ore. Edo kotembewo, na imondemane daedo deguta berari itana, edo maundo iji beao petugarida. Awara.” ");
INSERT INTO bhg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Eiwa God da Mai, Yesu Keriso, da bino dave tuturo béda. ");
INSERT INTO bhg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Peroveta manemi ge eiwa God mi ainda Mai de sisina awa gaguritera: “Na bino piari embo piano gisi maundo, ito begata gatedo dave aina.” ");
INSERT INTO bhg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Embo abu damodamoda aorogateira, ‘BADARI da begata dave ari pepeta arate!’” ");
INSERT INTO bhg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ango edo John gupusina abu damodamoda. Bapataito eite dengoro baiari pipiteite embode tedo esisina, “Itomane jimbo bebegae dodo God da yai wareregedo gumbuwo, bapataito ane. Ango awo God mi itomane jimbo bebegae kotembedo doware!” ");
INSERT INTO bhg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yai Judea da embomai edo Jerusalem nasi ainda embomai idegedo maunsitera John ge sira awa ingain. Edo awamaneda jimbo bebegae karigedo gumboro Jodani unda bapataito edo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John da gongo wo kamelo tumi ari awa ombudo, ainto ami bupuri jiari edo ainda indari awa wajina ae pika de. ");
INSERT INTO bhg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ami aorogatedo tedo esisina, “Embo amboda gumaina awa na ango ae. Embo awa bajina edo na dave ae. Nane atembedo ainda tai woru teugari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na imomane un mi bapataito ena. Ata embo ami awa, imomane Asisi Kotopu mi bapataito aina.” ");
INSERT INTO bhg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Edo iji ribori dowae Yesu yai Galili doda nasi Nasaret edo gupusina. Edo gumbiri John mi embo awa Jodani unda bapataito esisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu unda erido vitain eiri utu yaungesiri Asisi Kotopu ni ribo ango ainda yai wowoteiri gosisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Edo ge yavi utuda engo gupusina, “Imo awa nato dubobari Mai. Nato dubodave ari bé ito yai.” ");
INSERT INTO bhg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ango esiri God da Asisi mi gisijido kundo abu damodamoda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Edo deguta 40 isiri Satan mi bavedo esisina. Womane abuda awa ainde daedo itero, edo anelamanemi gundo kondade esitera. ");
INSERT INTO bhg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ango edo Daotari Herod mi sinigambari edo John Bapataito Ari Embo awa kundo bundari oroda pipisisina. Ainda amboda, Yesu yai Galili maundo God da gisijiari bino dave awa, emboda yai dengoro baiari pipiteite tedo esisina, ");
INSERT INTO bhg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Ijibé awa gumbira eire. Embomai berari God da gisijiari gara! Itomane jimbo bebegae awa dodo God da yai wareregedo bino dave eiwa ingido gebé ewo!” ");
INSERT INTO bhg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ango edo Yesu Galili ubutu bengida ainto eite, wo iro ari embo tote (2) Simon ae ainda nameji Andrew de mongami wo barero gosisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu mi awamanede sisina, “Nato yaida puwo! Nane imomane atopatano gido embo bave.” ");
INSERT INTO bhg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Edo boraebé awamaneda monga dodo Yesu ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ango edo ainto edo saka iaragedo tenda embo nei tote (2) gosisina. James ae John de awa Zebedee da mamai. Awamane awa ma doda monga kakapegari awa sirigetera. ");
INSERT INTO bhg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu awamane goteite borae sisina, “Na ambo ambo ewo!” Edo awamaneda mamo ae ainda buro embobo de ma doda dodo Yesu ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu ae ainda ambodani de Kapenium nasida guputera, Oena Apari Degutade. Yesu Judah embomainda benunu oroda maundo torido embo atopatari tuturo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aindabé, imo awa Aodarida atopapasigari ango ae, ata ainda atopatari awa God da awara taride, embomai jiwae Yesu da atopatari awa gido korebé esitera. ");
INSERT INTO bhg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ango edo awamaneda benunu oroda embo asisi beyae doda itari awa isite aorogasisina, ");
INSERT INTO bhg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Imo natokare yai ro ain jipapa esi Yesu Nasaret Embo? Imo nakare dedo sitain gumbesita? Na gotena. Imo awa God da Mai Kotopu!” ");
INSERT INTO bhg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu mi asisi beyaede mina sisina, “Ge teote ta embo awa dodo idegedo gumbu.” ");
INSERT INTO bhg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Edo asisi beyaemi embo awa jipeite, aorogateite emboda doda awa idegedo gupusina. ");
INSERT INTO bhg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Embomi wasiri awa gido kore bajina edo mina tara esitera, “Wasiri eiwa rori? Eiwa atopatari teka. Embo eiwa badari bajina, awatedo asisi bebegae siri ainda ge kera era.” ");
INSERT INTO bhg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ango edo Yesu da ge awa boraebé Galili gano nondari awa arapu esisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu ae ambodani neneinde, James ae John de daedo, Judah embomainda benunu oro dodo Simon ae Andrew deda mandoda maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Edo Simon da imbosi awa karu dademo budo besida isiri guputera. Edo Yesu awa tetero gosisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu eutu ainda karuda ge awa gido maundo ipada jido kondade esiri erorisina. Edo ainda karu itae esiri awamane sima dave edo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ainda amboda, iji wotesiri ainda turode, embomi Yesu da yai karu embomai de bineimaneda bundari de awa daedo kundo guputera. ");
INSERT INTO bhg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Embomai berari nasi bajinada awa mando manguro beda dada esitera. ");
INSERT INTO bhg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Edo Yesu mi karu neindekainde awa gao euri kaviyegedo esitera. Edo bineimane embomainda doda awa ondeuri idegedo esitera. Edo awamane gari, Yesu awa God da Mai, awatedo, ine dowae bineimane ge tae. ");
INSERT INTO bhg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Deguta neinde Yesu sipo ataede mandoda edo idegedo yai damodamoda maundo benunu tari tuturo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Edo Simon ae ainda otatawo de Yesu kakowa eite idegedo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Edo kakowa eiunte tamundo awamanemi sitera, “Embo berari awa imo kakowa era.” ");
INSERT INTO bhg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu awamanede mina sisina, “Kaende nasi nenei demonda itera ainda mambore. Na buro awa embo guputena, awatedo, yai ainda dengoro baiari piana.” ");
INSERT INTO bhg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ango edo imo maundo Judah embomainda benunu oro yai Galili umbugo berarida dengoro baiari pipiteite, bineimane ondeuri idegedo esitera. ");
INSERT INTO bhg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Embo da (1), ginimi tutupegari awa Yesu da yai gundo, baongo dadari edo ami kondade arate sisina, “Imo jipapa edo gido na eyo kaviyegane!” ");
INSERT INTO bhg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu embo awa gido do edo ipa ududugedo tujijieite sisina, “Een, na jipapa ena. Kaviyege!” ");
INSERT INTO bhg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yesu mi ango tesiri emboda gini borae bé itae esiri kaviyegesisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yesu embo ainde ge okain bé sisina, “Na imo eteno kaviyegeteta awa, embo neneinde teote! Ata, dambu darido mambuyo. Pirisimi imo udugedo gare, ‘Imo kaviyegeteta!’ awa tari embo berari goteiaro ategari rorou Moses mi sisina awa pieyo.” Ango tedo piesiri maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ata embo awa maundo bino awa tesiri yai berari arapu esisina. Awatedo, Yesu nasi arapada isite emboda jisida iari tao ae. Ata imo tepo yai damodamoda isiuri embo yai berarida ami ainda yai gundo esitera. ");
INSERT INTO bhg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesu deguta indewae itae esiri amboda egenembedo Kapenium nasida maunsisina. Edo embo awa mandoda isiri ainda bino yai berarida arapu esisina. ");
INSERT INTO bhg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ango edo embomai jiwaebé gundo doregetero yai ato ae esisina, manguro be awa daedo. Edo Yesu mi God da ge awamanede piedo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Edo embo ipa ao pasido (4) ami embo ipatai ambari awa bundedo Yesu da yai kundo guputera. ");
INSERT INTO bhg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Embomai doregesitera, awatedo, embo awa kundo ainda yai piari tao ae esitera. Ango esiri gido awamane mando tada visido sitoro kapedo yai Yesu isira ainda toto esitera. Ango edo embo kakateda awa dotero wowosisina. ");
INSERT INTO bhg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Edo Yesu awamaneda gebé ari awa goteite ami embo ipatai ambaride sisina, “Mai nato, jimbo ito kotembedo doteno itae esira.” ");
INSERT INTO bhg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Aodarida atopapasigari nenei, ainda anumbari ami akuta kotembesitera, ");
INSERT INTO bhg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Embo eiwa nongo arimi ge engo siri? God da dao tedojijireira. God, imo akuta awa emboda jimbo kotembedo dowari itae aride!” ");
INSERT INTO bhg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu boraebé mina burisina, awamane nongo kotembeteri awa. Awatedo, Yesu mi awamanede sisina, “Nongaintedo imomane kotembari ango evi? ");
INSERT INTO bhg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Embo ipatai ambari einde, ‘Jimbo ito kotembedo doteno itae esira!’ tari awa gadaerita, ko ‘Erido topi ito kundo ainto e!’ tari ri? ");
INSERT INTO bhg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nane itomane yai ano arapa ari gawa. Na awa Embo da Mai. Nato awara tari butu einda isira. Emboda jimbo kotembedo dowano itae aina.” Ango site Yesu mi embo ipatai ambaride sisina, ");
INSERT INTO bhg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nane imonde tena. Eri! Topi ito kundo mando itoda mambuyo!” ");
INSERT INTO bhg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Edo awamane berari jijimbetero embo awa boraebé erido ainda topi jiri eriri kundo maunsisina. Awamane berari bé korebakore esitera. Edo God dasiga eite sitera, “Nakare wasiri engo awa gisi gae!” ");
INSERT INTO bhg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu tenda egenembedo Galili ubutu bengida maunsisina. Edo embomai jiwae gumbero atopatari tuturo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ango edo imo ainto eite tax kumbari embo gosisina. Levi, Alphaeus da mai awa, ainda buro oroda anumbedo isiri Yesu mi ainde sisina, “Na ambo ambo e!” Levi erido awa ambo ambo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ainda amboda Levi mi Yesu ae ainda ambodani de kundo ainda mandoda gupusina. Bondo ain tesiri tax kumbari embobo ae embo bebegae de Yesu daedo ambo ambo esitera. Awamane berari doregedo anumbedo bondo injitera. ");
INSERT INTO bhg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aodarida atopapasigari ae Parasi mane demi Yesu gositera awa, imo tax kumbari embobo ae embo bebegae de rorae indeira. Awa gido ainda ambodanide sitera, “Embo owa jimbo bebegae embobode rorae indari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu mi awamaneda ge ingido mina sisina, “Embo karu itaemi siwo piari embo jipapa ae edo era, ata embo karude ami akuta. Na awa embo wasiri dambu darari dao tain gumbae ata embo bebegae dao tano awamaneda beyae dodo God da yai wareregorote.” ");
INSERT INTO bhg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Iji angode John Bapataito Ari Emboda ambodani ae Parasi maneda ambodani de veta ero embo neneimi Yesu da yai gundo tedogositera, “Ro awa embo John Bapataito Ari Emboda ambodani ae Parasi maneda ambodani de benunu tain veta edo era ango, ito ae edo eri?” ");
INSERT INTO bhg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu tedogari mina sisina. “Jimbari tutuda embo topomi ainda jimbari bondo inono indae dowarita? Na imondemane eniya ge eiwa tano giwo! Jimbari tutu daedo itera ainde awamane veta ainyae. ");
INSERT INTO bhg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ata iji gumbari awa jimbari tutu kundo mamaina, ango ari iji angode awa mamato eite veta ara.” ");
INSERT INTO bhg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesu gosisina awa awamaneda atopatari matu ainde edo Yesu da atopatari teka ainde awa tegatega ari tao ae. Awatedo, Yesu mi eniya ge nei tekago sisina. “Embo da aimi gongo teka kundo ombari matu kerari awa gaiari tao ae. Ango aina awa, gongo tekami ombari matu awa dumbari keredo beyae aina. ");
INSERT INTO bhg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Embo da aimi waini teka awa ainda ainto matuda gerigari tao ae. Ango aina awa, waini tekami ainda ainto matu awa dumbari kerigaina. Ata waini teka awa ainda ainto tekada gerigara.” ");
INSERT INTO bhg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesu ae ainda ambodani de Oena Apari Deguta ainde wheat tutu begata barida maunsitera. Edo ainda ambodanimi wheat oen awa totokumbedo buritera. ");
INSERT INTO bhg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Awa gido Parasi manemi Yesu de sitera, “Ambodani itomi ge okain awa Oena Apari Degutade detero erigeteira.” ");
INSERT INTO bhg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu awamanede mina sisina, “Imomane David mi nongo esisini awa ajijigedo gaeta, beji mina budo awa ae ainda embobo de ro esiteri? ");
INSERT INTO bhg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ami God da oroda torido bread matu God da jisida awa piesiri injitera. Iji angode Abiathar awa pirisida gisijiari bajina isiri, ge okainda tari isira awa, embo angogomi akuta indorote.” ");
INSERT INTO bhg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu mi awamanede sisina, “Oena Apari Deguta awa emboda dave awa embo ari, ata embomi Oena Apari Deguta awa embo ae. ");
INSERT INTO bhg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Awatedo, na, Embo da Mai awa daedo Oena Apari Deguta ainda Badari.” ");
INSERT INTO bhg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Edo Yesu tenda egenembedo maundo Judah embomainda benunu oroda totorisina. Edo embo ipa ambari awa ainda isinesina. ");
INSERT INTO bhg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Embo nenei ainda itera ami imo jijimbesitera, Oena Apari Deguta ainde embo awa ari kaviyegainita awa gain. Ango ari gido imo bekumba ain. ");
INSERT INTO bhg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu mi embo ipa ambari ainde sisina, “Visido arapada engo gumbu!” ");
INSERT INTO bhg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Edo embomai ainde sisina, “Oena Apari Deguta de awara ari buro ro orote tari isiri, dave aririta, beyae ari ri? Emboda wasiri toregarita, dari betari ri?” Ata awamane ge tae esitera. ");
INSERT INTO bhg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu sinigambaride awamane jisini esisina. Ata aindabé do okain ari awamaneda yai isira awa gido awamane embo do ari burisina. Edo embo ipa ambari ainde sisina, “Ito ipa ududuge!” Embo awa ipa ududugesiri dave esisina, ainda ipa nei dave isira angó. ");
INSERT INTO bhg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Angode Parasi mane boraebé idegedo maunsitera, Herod da buro otatawo gido, awamanededa ge jirido Yesu daro betarate. ");
INSERT INTO bhg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ata Yesu ae ainda ambodani de dodo egenembedo Galili ubutuda maunsitera. Edo embomai jiwaebé Galili yaida, Judea yaida, ");
INSERT INTO bhg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem nasida, Idumia yaida, un Jodani ainda abagada, Taia nasida, Saidoni nasida amimi ambo ambo edo guputera. “Yesu mi buro nandogo edo eira,” awa ingido ainda yai guputera. ");
INSERT INTO bhg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yesu embomai jiwae euri kaviyegedo esitera. Awatedo, nenei jiwae gundo embo awa tujiain mitedo esitera. Edo Yesu mi ambodanide sisina, “Un ma itomane namonde sindewo wotare. Embomai jiwaebé na mitera. Awatedo, na visido mada anumane. ");
INSERT INTO bhg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Edo embomai asisi bebegaemi bundari awa, yai nonda imo gotera awa, doda durudo aorogatedo tedo esitera, “Imo God da Mai bé ra!” ");
INSERT INTO bhg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ata Yesu mi asisi bebegaede ge okain tedo esisina, “Dao nato emboda dombuda karigeove!” ");
INSERT INTO bhg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Edo imo pejida visido ami akuta embo imo jipapa eira awa dao tesiri ainda yai guputera. ");
INSERT INTO bhg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ango edo ami embobo 12 awa avigesisina. Awamane imonde daedo isiaro atopasido piari idegorote, God da ge dave awa baiari piara, ");
INSERT INTO bhg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","edo awamane ainda goroba budo karu ari awa gao aro kaviyegara, edo bineimane ondaro idegara: ");
INSERT INTO bhg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Simon da dao awa Peter pipisisina; ");
INSERT INTO bhg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James ae nameji John de awa Zebedee da mamai, awa dao “Dunana da Mamai” pipisisina, aindabé, awamane sinigambarimi yavi jiwae edo esitera awatedo; ");
INSERT INTO bhg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew de Philip de Bartholomew de Matthew de Thomas de Alphaeus da mai James de Thaddaeus de Simon (embo Kanan edo gumbari) de; ");
INSERT INTO bhg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","edo Judas Iscariot ami amboda Yesu betarida piaina. ");
INSERT INTO bhg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Awamane maundo mandoda totoritera. Edo embomai jiwae tenda gundo doregesitera. Awatedo, Yesu ae ainda ambodani demi indari injido tao ae edo oena apari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Edo embo neneimi tedo esitera, “Embo awa kotembari dadoegari!” Awatedo, ainda teotopo ge awa ingido idegedo maunsitera, embo awa jiaro petarate. ");
INSERT INTO bhg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Edo Aodarida atopapasigari Jerusalem edo wotedo gundo tedo esitera, “Beelzebul, Yesu da doda isira! Awatedo, bineimaneda gisijiarimi Yesu da yai goroba pisido eira. Awatedo, bineimane gisijijieite ondeuri idegedo era.” ");
INSERT INTO bhg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu awamane dao tesiri ainda yai guputera. Edo eniya ge sisina. “Satan mi ainda asisi bebegae nongo ondari idegari? Satan mi ango ari jipapa ainyae. ");
INSERT INTO bhg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Edo nasi bajina da (1)mi akuta avigedo kupo petari kupo petari mina dara ara, awa petari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Edo orobe da (1)mi akuta avigedo kupo petari kupo petari mina dara ara, awa petari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Awatedo, dá ango Satan da buro embobo akuta erido kupo avigari kupo avigari edo mina dara ara, Satan da gisijiari awa petari tao ae, ata itae aina. ");
INSERT INTO bhg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Atako embo da aimi goroba emboda mandoda tepo torido ainda rorae bari tao ae, ata gisibé goroba embo awa asimi bundedo awa, ainda rorae beono aina.” Yesu mi ge eiwa, kariwa imo akuta ainda bureite sisina. ");
INSERT INTO bhg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Awara! Ge ro boroko imondemane tena, eiwa giwo! Embomai aimi God da yai wareregedo ainda jimbo bebegae karigara awa God mi emboda jimbo kotembedo dowaina, bebegae ro ara edo ge butari ro tara awa. ");
INSERT INTO bhg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ata embo aimi Asisi Kotopu de ge bebegae taina awa, imo kotembedo mana dowaina, ata rirowa natopo itari baina.” ");
INSERT INTO bhg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Awamanemi “Embo awa asisi beyaede!” tedo esitera, awatedo, Yesu mi ge ango sisina. ");
INSERT INTO bhg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Edo Yesu da nanonameji ae ai de gundo arapada petedo imo dao sitera. ");
INSERT INTO bhg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Edo embomai jiwaebé anumbedo jinenembesitera. Ami ainde sitera, “Giyo! Ito ai ae nanonameji de arapada imo gain jipapa era.” ");
INSERT INTO bhg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ata Yesu mi awamanede mina sisina, “Ave awa ko nato ai ae nato nanonameji de ri?” ");
INSERT INTO bhg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Imo embomai anumbedo jinenembesitera awa, jisini esisina. Edo sisina, “Eiwamane awa nato ai edo nato nanonameji! ");
INSERT INTO bhg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aimi God da jipapa edo eira awa nato nameji, nato ru edo ai.” ");
INSERT INTO bhg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Edo Yesu tenda atopatari tuturo esisina, Galili ubutu demonda. Edo embomai jisi da imo jinenembesitera. Awa jiwaebé etero gido imo ma doda wotedo anumbesisina. Edo ma awa unda isiri embomai berari un bengida pepositera. ");
INSERT INTO bhg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ango edo imo eniya ge jiwaemi awamane atopaposisina. Edo awamane atopapoteite tedo esisina, ");
INSERT INTO bhg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ingiwo! Embo da (1) awa rorae vero purara piain kundo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Edo vero nenei begata beda pipisisina awa nimi wotedo injitera. ");
INSERT INTO bhg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Edo nenei ganuma gajida pipisisina. Edo butu puruta ae, awatedo, boraebé eroritera. ");
INSERT INTO bhg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ata iji visido gaiesiri besinya tamonda rare mumuya esitera. ");
INSERT INTO bhg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Edo vero nenei kurereda duduritera edo kurere erido ami ipuda engesiri ginene esitera be ekae. ");
INSERT INTO bhg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Edo vero nenei butu daveda pipisisina. Awa dave erido be ekitera, nenei jiwaego (30), nenei jiwae (60), nenei jiwaebé (100).” ");
INSERT INTO bhg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Edo Yesu awamanede sisina, “Ingiwo! Imomane ge ro tena awa bé gain edo gawa!” ");
INSERT INTO bhg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ata ainda amboda, Yesu imo akutabé isiri avekave ge ingitera, awamane ae ainda embobo 12 de ainda yai guputera, eniya geda mokabé awa tari ingain. ");
INSERT INTO bhg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Edo Yesu mi awamanede sisina, “Imomane God da gisijiarida gebé onjigari awa ano arapa ari gawa. Ata nenei arapada, owamanede rorae berari eniya gemi tana. ");
INSERT INTO bhg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Awatedo, ‘Nato buro gido ara, ata ainda mokabé mana gara. Nato ge ingido ara, ata ainda atopatari mana arapa ari gara. Ango ara awa jimbo bebegae dodo God da yai wareregaro edo God mi awamaneda jimbo kotembedo dowae esira.’” ");
INSERT INTO bhg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“Imomane eniya ge eiwa gae ewa?” Yesu mi awamanede sisina, “Nongo edo awa imomane eniya ge berari eiwa itomane yai arapa aini? ");
INSERT INTO bhg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Vero piari embo awa embo God da ge sira ara. ");
INSERT INTO bhg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Embomai God da ge ingido doda pisido era awa ango vero begata beda pipisisina. Boraebé Satan gundo God da ge awa kundo maunteiuri awamane God da ge ruvegedo era. ");
INSERT INTO bhg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Embomai nenei awa butu ganuma gajida ango. Awamane God da ge ingido do yawade boraebé budo era. ");
INSERT INTO bhg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Aindabé God da ge awamaneda dobéda wotedo petae, awamane God da ge iji tupo gebé edo era. Awamane awa dá nya ango ainda besinya tuda tembae. Awatedo iji angode God da ge ambo ambo eiworo buriya neindekainde ko memesi neindekainde euri boraebé durudo era. ");
INSERT INTO bhg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Embo nenei awa butu vero kurere tutuda duduritera ango. Awamane God da ge ingido era. ");
INSERT INTO bhg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ata butu roraeda kotembari jiwaemi awamaneda do buriya edo eira. Edo butuda gaiapami awamane udumbedo eira. Awamane tamopisida rorae awa jipapa edo era. Awatedo, awamane God da ge ruvegedo ainda buro dave ae edo era. ");
INSERT INTO bhg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Embomai nenei awa ango vero butu daveda pipisisina awa, God da ge ingido awamaneda doda piedo era. Awatedo, awamane God da be jiwaego (30), nenei jiwae (60), nenei jiwaebé (100) ango ekegedo era.” ");
INSERT INTO bhg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu mi tedo esisina, “Embo da aimi keimo ijimbedo teo kuwoda piarita? Paro dutuda piaini? Awa keimo piari petari yai ae. ");
INSERT INTO bhg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Rorae ro onjigarida isira awa kundo arapada piaina. Edo rorae ro apuregari isira awa pirigaina. ");
INSERT INTO bhg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Imomane ge tena eiwa gain edo, awa gawa.” ");
INSERT INTO bhg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu mi daedo awamanede sisina, “Davebé edo ro berari awa ingiwo! Imo God da ge kundo tegatega eta dá ango God mi imo tega aina. Ango edo ito yaida saka ingeta awa God mi ari bajina aina. ");
INSERT INTO bhg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ata avekave rorae ro isira awa jiwae piaina. Edo avekave rorae ro itae awa saka ro awamaneda yai isira awa dodo baina.” ");
INSERT INTO bhg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu mi tedo sisina, “God da gisijiari awa kariwa dá engo. Embo da (1) ami rorae vero kundo maundo puwa doda purara pipisisina. ");
INSERT INTO bhg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Edo dodo maundo isiri vero awa korukaru edo eroritera. Ata embo ami akuta vero awa nongo edo korukaru edo eroreri awa gae. ");
INSERT INTO bhg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Butumi akuta euri vero awa erido be ekedo esitera. Gisi goru arapa edo awa uji edo eira, isite awa be arapa edo esitera. ");
INSERT INTO bhg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ango edo be awa isite bajido tari esitera. Edo indari iji tega biri gido awa boraebé kapedo esisina.” ");
INSERT INTO bhg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“God da gisijiari awa kariwa nongo tani?” Yesu mi tedogosisina, “Awa eniya geda kariwa nongo bani? ");
INSERT INTO bhg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Awa kariwa engo, embo da (1) ami maine vero burisina. Awa saka mainbé butuda uraina. ");
INSERT INTO bhg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ata erido bajido patu gataina. Edo ni wasidemi gundo ainda dugada ma piara.” ");
INSERT INTO bhg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu embode dengoro baiari piedo esisina. Jiwaebé awa eniya geda ami tari awamaneda yai arapa ari gorote. ");
INSERT INTO bhg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Imo ge tepo tae, ata berari eniyada tedo esisina. Ata imo akuta eite awa ainda ambodanide eniya geda mokabé awa berari teuri gido esitera. ");
INSERT INTO bhg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Deguta dá ainda turode, Yesu mi ainda ambodanide sisina, “Puwo! Kaende temundo ubutu kupo ounda mamboré.” ");
INSERT INTO bhg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ango edo embomai jiwaebé awa ainda dodo Yesu mada anumbesiri, ambodanimi kundo ubutu kupo neinda temain tuturo esitera, ma babaingae neneinde daedo. ");
INSERT INTO bhg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Edo ango ero boraebé bisi gupeiri edo un torupeka eiri ma utoro vivisisina, aikae kununumbari tao. ");
INSERT INTO bhg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu awa ma aoda kopuru guto piedo jitao aveiri ambodanimi imo audedo sitera, “Atopatari, imo nakare betain era amo gotesi?” ");
INSERT INTO bhg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu erido petedo biside ge okain sisina, “Yavi do!” Edo ubutude sisina, “Damodamo e!” Bisi itae eiri ubutu damodamo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Edo Yesu mi ainda ambodanide sisina, “Nongo edo imomane adu evi? Itomane gebé ari nato yai itae ra?” ");
INSERT INTO bhg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Awamane kore bajinabé edo mina tara esitera, “Embo eiwa averi? Giwo, bisi ae ubutu de ainda ge ingido kera era!” ");
INSERT INTO bhg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu ae ainda ambodani de Galili ubutu kupo neinda guputera, yai Gadareni do ainda. ");
INSERT INTO bhg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Edo iji angode Yesu ma doda edo idegeteiri, embo da (1) awa goiari yai dá ango edo idegedo gundo Yesu tapusina. Edo embo awa asisi beyae doda itari. ");
INSERT INTO bhg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Banga toda yai embomaimi awamaneda bebetegari piedo era ainda isima edo esisina awa, embo da aimi asi okain aurimi ari ami bundedo jiari itari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aindabé, iji jiwae asi aurimi ari ami ainda ipatai bundedo jiaro itarate edo esitera. Ata asi okain jiuri kapedo esisina. Embo awa goroba jiwae, embo da aimi ao darari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ijide muyaende, embo awa goiari yaida gundo maundo eite pejida aorogateite ganumami akuta tamo kapedo einesina. ");
INSERT INTO bhg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Edo embo ami Yesu aikamana gido tumundo gundo ainda doda baongo dadari esisina. ");
INSERT INTO bhg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ango edo Yesu mi asisi beyaede sisina, “Embo awa dodo idege!” Awatedo, aorogatedo sisina, “Yesu, God Ikane Itarida Mai, imo namonde ro ain jipapa esi? God da daoda tena, na dedo sitote.” ");
INSERT INTO bhg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Edo Yesu tedogosisina, “Dao ito averi?” Edo embo ami mina sisina, “Dao nato Jisi Da, aindabé nakare jiwaebé awatedo.” ");
INSERT INTO bhg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Edo embo ami Yesu benunu tedo dowae edo esisina, “Yai neinda mamborekae!” ");
INSERT INTO bhg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Yai ainda pumane jisi da undedo era, peji demonda. ");
INSERT INTO bhg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ango edo bineimanemi Yesu de benunu tedo dowae esitera, “Nakare pie maundo pumaneda yai tororé.” ");
INSERT INTO bhg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Edo Yesu mi asisi bebegae doda itaride sisina, “Awara, mambú!” Ango tesiri awamane idegedo maundo puda doda totoritera. Edo pu jisijisi ajijigari 2,000 awa peji dedewada tumundo matawa wotedo un ubutuda injido bebetegesitera. ");
INSERT INTO bhg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Embobo avekave pu sima ero jijirisina awa adu maundo bino awa tetero gositera, nasi bajinada edo indari kumbari urari nasida ainda. Embomai idegedo maunsitera, wasiri nongo nongo esiri awa gain. ");
INSERT INTO bhg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Edo awamane Yesu da yai gundo, embo bineimane jisi dami bundari awa ainda anumbedo isiri gositera, ombarijiari ari, kotembari dave gumbarate eiri, gido adu esitera. ");
INSERT INTO bhg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Edo awamanemi nongo edo Yesu mi embo ainda bineimanemi bundari isinesina awa bineimane ondesiri idegedo pumaneda yai maunsitera awa, embo neneinde tetero gositera. ");
INSERT INTO bhg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Awatedo, embobo yai ainda ami tuturo edo Yesu engega sitera, “Natokare yai dodo mambuyo!” ");
INSERT INTO bhg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ango etero Yesu tuturo edo ma doda totoreiri embo bineimanemi bundari awa gao esiri kaviyegesisina ami Yesu de tedo dowae esisina, “Na do! Imonde mamane.” ");
INSERT INTO bhg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Awarata, Yesu embo awa dowae ainde mambae, ata sisina, “Dodo egenembedo nasida mambuyo, ito orobeda, edo teyo goré, ‘Badari da do ari bajina nato yai edo na esiri kaviyegetena!’” ");
INSERT INTO bhg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Awatedo, embo awa dodo maunsisina, Nasi Babain Ajigari 10 ainda eite, Yesu mi imo gao esiri kaviyegesira awa teuri embomi gido korebé edo esitera. ");
INSERT INTO bhg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu tenda egenembedo ubutu kupo neinda made tepusina. Embomai jisi da ubutu demonda jinenembesitera. ");
INSERT INTO bhg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jairus awa Judah embomainda benunu oro sima ari. Ami Yesu da yai gundo baongo dadari ");
INSERT INTO bhg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","edo benunu sisina, “Nato gagara duberi 12 ango awa karu beyaebé edo betari aikae esira. Gumbu! Ipa tamonda piato kaviyegedo itare.” ");
INSERT INTO bhg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Awatedo, Yesu aedade mauntero embomai jiwaebé awamane doiedo daedo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ango edo eutu da (1) awa karu ororo bureite duberi 12 doturisina. ");
INSERT INTO bhg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Edo iji jiwae siwo gao ari emboda yai aro kaviyegain ganu kundo maundo esisina. Ata karu kaviyegae ainda ganu itae esisina. Ainda karu bajina esisina. ");
INSERT INTO bhg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ango edo eutu ami Yesu da gumbari ge ingido embomi Yesu doiedo mauntero ainda gunda maundo Yesu da ombari ribori tujijisina. ");
INSERT INTO bhg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Eutumi kotembesisina, “Tepo da (1) na embo ainda ombari ribori tujido awa kaviyegana.” ");
INSERT INTO bhg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tujijieira angode, Yesu da gorobami eutu awa esiri ororo jingesiri kaviyegesisina. Edo tamo mina dave burisina. ");
INSERT INTO bhg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu boraebé gosisina, ainda goroba awa idegeteira. Edo wareregedo embomainde sisina, “Ombari nato aimi tujiri?” ");
INSERT INTO bhg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yesu da ambodanimi sitera, “Embo jiwaebé imo doiera gotesi? Ro awa embo imo, ‘Aimi tujiri’ tesi?” ");
INSERT INTO bhg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Edo Yesu eutu aimi ainda ombari ribori tujiri awa gain kakowa esisina. ");
INSERT INTO bhg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Eutu kaviyegesisinami adu eite do periperi eite Yesu da yai gundo baongo dadari edo sisina, “Na awa ororo bureite duberi 12 dotena, edo gundo ito ombari ribori tujido kaviyegetena. Awa ge bémi tena.” ");
INSERT INTO bhg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Edo Yesu mi eutu ainde sisina, “Gagara nato, bégade mambuyo! God mi ito gebé ari nato yai pieteta ami imo esiri kaviyegeteta.” ");
INSERT INTO bhg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu ge eiwa siri Jairus da mandoda edo embo nenei guputera. Edo sitera, “Ito gagara itae esira. Atopatari dowato mando itoda gumbure.” ");
INSERT INTO bhg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu ge tera awa ingido Jairus de sisina, “Itadaita eote! Na tumonda ewasi!” ");
INSERT INTO bhg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ango edo embomai nenei tesiri dotero edo Peter de James ae nameji John de kundo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Awamane gundo Jairus da mandoda, Yesu yavi bajinabé eite ji tero gosisina. ");
INSERT INTO bhg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Edo Yesu mandoda torido embomainde sisina, “Yavi eite einda ji tewa aindabé rori? Gagara saka eiwa betae, ata jitao aveira.” ");
INSERT INTO bhg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ango tesiri gido awa embomai mandoda ami Yesu tedojijiritera. Ata Yesu awamanede sisina, “Imomane eve iwo!” Ango edo imo gagarada aimamo de ambodani tamonde (3) de awa budo gagara betari isira do ainda totorisina. ");
INSERT INTO bhg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Edo Yesu gagara saka awa ipada jijieite Judah embomainda gemi sisina, “Talitha cumi!” (ainda moka awa “Gagara saka eri!”). ");
INSERT INTO bhg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Boraebé gagara saka awa erido ainto esisina. Ainda aimamomi gido, “Aiiya! Wasiri eiwa tena!” ango mina tara esitera. ");
INSERT INTO bhg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu awamanede sisina, “Embo neinde teove, gagara eteno kaviyegesira eiwa!” Edo amboda sisina, “Gagara eiwa indari piewo indare.” ");
INSERT INTO bhg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu yai awa dodo ainda ambodanide daedo egenembedo ainda nasi topobé Nasaret, ainda maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Edo Oena Apari Deguta gumbiri Yesu Judah embomainda benunu oroda torido embomai atopatari tuturo esisina. Edo embo jiwae ainda ge ingido korebé esitera. Awamanemi sitera, “Embo eiwa kotembari yai nonda budo atopatari engo pipiteiri? Ainda dubogari de jirogari de eiwa nonda biri? Ainda awara tari de goroba de ain piesiri? Buro babain emomo eiri? ");
INSERT INTO bhg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Eiwa oromando ari embo ra? Edo Mary da mai, edo James da nameji, Joses, Judas, edo Simon da? Ainda ruaimono einda isima erita?” Ango tedo awa imo ajiregesitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Edo Yesu mi awamanede dubogari gemi sisina, “Peroveta awa nasi neneinda tou edo era. Ata ainda nasi topobé ainde teotopo de orobe demi tou ae edo era.” ");
INSERT INTO bhg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Edo imo buro babain awa ari tao ae esisina. Ata karu embomai indewae awa ipa tamonda piedo gao esiri kaviyegesitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Edo awamanemi imo gebé ae esitera, awa embo, Yesu kotembari jiwaebé esisina. Ango edo Yesu nasi da da torido idegedo embo atopaposisina. ");
INSERT INTO bhg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Edo ainda embobo 12 dao tesiri guputera, tote (2) tote (2) piari idegorote, edo awamaneda yai goroba ari piari asisi bebegae ondaro idegorote. ");
INSERT INTO bhg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Edo Yesu mi sisina, “Itomane pepetada rorae nei ro bainyae, ata ketu akuta. Asi bainyae, indari bainyae, gaiapa kapida bainyae! ");
INSERT INTO bhg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Itomane tai woru piawa, ata dademo ombari deposi bove! ");
INSERT INTO bhg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Imomane yai nonda idegawo, embo ainkaimi awamaneda mandoda imomane baro gido, ainda isite buro ewo! ");
INSERT INTO bhg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Edo embo ainkaimi imomane ategedo bae aro gido ko itomane ge ingae aro gido, konipo tai itomaneda awa denden edo dodo mambuwo. Ango ewa ainda kariwa awa God mi awamaneda yai rirowa piaina. Awara! Edo ge ro boroko imondemane tena, eiwa giwo! Katari degutade Sodom ae Gomora de niyaomi ausina ango, nasi awa daginegedo awaina.” ");
INSERT INTO bhg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ango edo ambodani Yesu dodo idegesitera. God da ge atopapoteite embode tedo esitera, “Itomane jimbo bebegae dodo God da yai wareregewo!” ");
INSERT INTO bhg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Edo awamane bineimane ondoro idegedo esitera. Edo karu embomai jiwaebé awa, ni ‘olive’ beda gamami awamaneda yai pisido datoro kaviyegedo esitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Embo jiwaebémi Yesu da buro babain edo eira awa gido mina tara eiworo Daotari Herod mi ge awa ingido esisina. Edo ami sisina, “John Bapataito Ari Embo betari awa tenda erira, awatedo, buro babain owa edo eira.” ");
INSERT INTO bhg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Neneimi tedo esitera, “Owa peroveta Elijah.” Edo neneimi tedo esitera, “Owa Peroveta, o peroveta nenei mamatu dá ango.” ");
INSERT INTO bhg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ata Herod mi ge awa ingido tedo esisina, “John Bapataito Ari Embo nane teteno dubo kapitara, ami tenda erira.” ");
INSERT INTO bhg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Iji gisi Herod mi ainda nameji Philip da aro, Herodias, ipuda jipusina. Edo John mi Herod de sisina, “God da ge okain tari isira awa, ‘Imo namejida aro jimainyae.’” Edo Herodias John mi ge engo tesiri ingisina. Awatedo, sinigambari bajinabé edo John dari betarate kotembesisina. Ata Herod mi John da wasiri awa dambu darari edo nei ro itae gido embo awa tou edo esisina. Awatedo, Herod mi embo awa matawa dave itarate dedegedo bundari oroda piesiri isiuri Herodias mi John dari betari tao ae. Edo Herod mi John da ge ingido dubodavede ingeite buro jiwaebé edo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ango edo Herod mi deguta da (1)de ainda engari degutada bondo siya esisina. Edo babadegari, gisijijiegari, yai Galili da daotari embobo awa jipusina. Edo deguta ainde awa Herodias da deguta dave, John dari betarate kotembesisina. ");
INSERT INTO bhg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Edo embo bondoda anumbesitera ami Herodias da gagara ya ureiri gido awamane ae Herod de dubodavebé esitera. Edo Daotari Herod mi gagara ainde sisina, “Imo kando ro jipapa esi? Tato gido piana.” ");
INSERT INTO bhg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Edo embo ami gagara ya ureira ainde daedo sisina, “God da daoda tena. Imo rorae ro bé jipapa esi awa tato gido piana. Nato gaiapa kupo jipapa ata, awa piana.” ");
INSERT INTO bhg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Edo gagara awa idegedo maundo aide sisina, “Na Daotari Herod mi rorae ro jipapa edo tano piain tesira awa, ge nongo tani?” Ai mi sisina awa, “‘John Bapataito Ari Emboda kopuru jipapa ena,’ teyo!” ");
INSERT INTO bhg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Edo boraebé gagara awa maundo daotarida yai ge mina sisina, “John Bapataito Ari Emboda kopuru jipapa ena. Borokobé, teoda pie bane!” ");
INSERT INTO bhg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Edo John dari betari awa jipapa ae, awatedo, daotari awa dubovevera bajinabé esisina. Awarata, ainda engari bondoda embobo anumbesitera ainda jisida edo God da daoda tarigari sisina, awatedo, ari bé aina. ");
INSERT INTO bhg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Edo boraebé daotarimi itoro embo piesiri maunsisina, ainda bundari oroda, John da dubo kapedo ainda yai kundo gumain. Edo itoro embo John da dubo kapisina. ");
INSERT INTO bhg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ainda kopuru teoda piedo kundo gundo Herodias da gagarade pipisisina. Edo gagarami kundo ainda aida yai maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ango edo John da ambodanimi embo ainda betari ge ingido Daotari Herod da yai guputera. Edo sitera, “Nakare John da tamo piato kundo maundo goiain gumbera.” Edo John da tamo piesiri kundo maundo awamaneda betari piedo era, banga to ainda pipisitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Edo Yesu da piari aimbari embobo, ami tote (2) tote (2) piesiri idegesitera awa tenda overegedo ainda yai guputera. Edo ro berari atopapositera edo ro esitera awa, tetero gosisina. ");
INSERT INTO bhg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Edo awamanede sisina, “Embomai jiwaebé kaenato yai gundo maundo ero kaena rorae indae ena. Awatedo, puwo! Kaende yai damodamoda mamano oena apave.” ");
INSERT INTO bhg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ango tesiri awamane ma sindetero wotesiri awamane akuta yai damodamoda maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ata awamane mauntero embomai jiwaebé kariwa gositera. Edo embomai nasi babain neneinda awa omboda gisi taimi maundo papoda itero Yesu ae embobo de maundo denembesitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu ma dodo wotedo papoda petedo embo jisi da gosisina. Aindabé awamane awa bé wo sipumane ango sima ari embo itae, awamane gido do ari bajinabé burisina. Awatedo, imo God da ge jiwae awamanede atopatari tuturo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Iji maundo wowoteiri Yesu da ambodani gundo ainde sitera, “Yai eiwa abubé. Rorae budo indari begata itae. Iji itae esira. ");
INSERT INTO bhg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Embomai ta pieyo maundo yai demonda nasi babaingae itera, ainda rorae oriedo indoré.” ");
INSERT INTO bhg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ata Yesu mi sisina, “Inemane indari piewavi indoré.” Edo ambodanimi mina sitera, “Edo nonda budo? Embomai eiwa jiwaebé. Nanekare ganu jiwaemi awa bread oriedo embo jisi da eiwa undarita?” ");
INSERT INTO bhg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ata Yesu mi ambodanide tenda sisina, “Awara, bread itomane yai ro inge isiri? Mambuwo gave!” Edo ambodani maundo rorae tamundo overegedo Yesu de sitera, “Nakare bread ipa da (5) edo un wo tote (2) tambera.” ");
INSERT INTO bhg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Edo Yesu mi ambodanide sisina, “Awara, tewo, embomai kiyan teka eroreira angoda anunumboré.” ");
INSERT INTO bhg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Edo ambodanimi tetero anunumbesitera. Gisi tedo gisi tedo nenei 50, nenei 100 ango anunumbesitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ango etero Yesu mi bread ipa da (5) ae un wo tote (2) de awa kundo jisi ikane utuda edo God dasiga esisina. Edo bread engegedo, wo eririgedo ambodanide piesiri kundo maundo embomai anunumbesitera ainde kandokando esitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Embomai berari anunumbesitera awa rorae injido inonobé esitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Edo bread ae wo de injido itoto doturitera awa ambodanimi sirigedo kanjia berari 12 sirero visido beda esisina. ");
INSERT INTO bhg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Edo embobo ajijigari 5,000 ango indari awa injitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Rorae injido ainda amboda, Yesu mi ainda ambodanide boraebé sisina, “Imomane gisi made Besaida nasida tembuwo! Na embomai eiwa ategano mamborote ena.” ");
INSERT INTO bhg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesu embomai ategesiri mauntero imo pejida visido yai damodamoda isite God de daedo ge sisina. ");
INSERT INTO bhg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Muyae gupeiri ambodani ubutu toropuda mada itero edo Yesu akuta pejida isira. ");
INSERT INTO bhg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ango edo sipo muyaende Yesu jisi tuda edo ambodani ubutu toropuda gosisina. Aindabé bisimi ma pepeda doreira awa, awamane ma dawarida buro okain ero gosisina. Edo Yesu wotedo un tamonda ainto edo awamane kena maunsisina. Ata imo maundo daginegain arago esisina. ");
INSERT INTO bhg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ambodanimi imo un tamonda ainto edo awamane kena gupeiri gido etemi kotembedo aorogatedo adu esitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Awamane imo gido adu beyaebé esitera. Ata Yesu mi borae sisina, “Adu eove! Goroba buwo! Na etemi ae! Na awara!” ");
INSERT INTO bhg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesu ge ango tedo ma doda viviteiri bisi itae esisina. Edo ambodanimi wasiri awa gido kore beyaebé esitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Aindabé, awamaneda do okain ari isira, Yesu mi embomai jisi bajinabé undesira awa kotembae, edo awamanemi Yesu da goroba tega rori awa gari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Edo awamane temundo kupo neinda Genesaret ainda ma kaingesitera. ");
INSERT INTO bhg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Edo ainda amboda Yesu ae ambodani de ma dodo idegetero embomai ainda ami boraebé Yesu kariwa gositera. ");
INSERT INTO bhg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Awatedo tumundo yai demonda embomai berari bino pietero gositera. Edo awamanemi Yesu da yai karu egeregari besida kundo guputera. ");
INSERT INTO bhg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Edo Yesu yai nonda torido idegedo euri, nasi babainda, nasi babaingaeda edo buroda, awamaneda karu embomai kundo gundo arapada pipiteiworo karu embomaimi awa gido ari kaviyegain benunu tedo esitera, “Badari, na do ewasi! Na tamo ito ko ombari ribori jibigi akuta tujido kaviyeganita?” Edo avekavemi awa tujido esitera awa, berari kaviyegari buritera. ");
INSERT INTO bhg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parasi mane ae Aodarida atopapasigari neneinde Jerusalem edo gundo Yesu jinenembesitera. ");
INSERT INTO bhg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Awamane gositera awa, Yesu da ambodani ipa teiae rorae indera. Awatedo, Parasi manemi akuta kotembesitera awa, “Yesu da ambodani ipa donode God da jisida indari indera.” ");
INSERT INTO bhg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Judah embomai berari edo Parasi mane daedo, awamanemi atopatari awamaneda ewowo gawowoda yai buritera awa, indari indae gisida ipa teiari begata isira ango teiedo ara. ");
INSERT INTO bhg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Neinda awa indari rorae mina piedo kundo gundo ara awa tamo teiedogogo edo awa taiedo injido ara. Edo awamaneda ge okain nenei jiwaebé awa jido ambo ambo edo era. Ainda kariwa awa engo, aia akou de outeo de anumba anumbedo rorae indari de teiedo era.) Embomai awa ango kotembeteite Yesu da yai guputera. ");
INSERT INTO bhg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Awa embo, Parasi mane ae Aodarida atopapasigari demi Yesu de tedogositera, “Ro awa embo ambodani ito atopatari kaenato ewowo gawowoda awa ambo ambo ainyae eite indari ipa teiae inderi?” ");
INSERT INTO bhg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu mi awamanede mina sisina. “Imomane awa aodari pisido ambo ambo ae embobo. O ge bé, iji matu peroveta Isaiah mi itomane iwata kawata gido karigedo ge ango gagurisina: ‘God mi sira awa, “Embomai eiwa tepo gemi na tou ari tera, ata awamaneda do nato yai awa aikamanabé. ");
INSERT INTO bhg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Awamane ge okain nenei emboda piari awa atopasido era, awatedo, awamaneda tumondebain ari nato yai awa pitawa.” ’ ");
INSERT INTO bhg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Imomane dá ango, God da ge okain berari sisina awa demonda dodo, sigi de akou de rorae nenei jiwae awa teieite itomane ewowoda atopatari awa ambo ambo edo ewa.” ");
INSERT INTO bhg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Edo Yesu mi tekago sisina, “Imomane kotembetewa awa imomane gari, awatedo, God da ge okain sisina awa kera ainyae ajiregedo, itomane ewowoda atopatari awa jiain ewa. ");
INSERT INTO bhg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses mi sisina awa, ‘Ito aimamo tou edo eyo,’ edo ‘Embo aimi ge beyae ainda aimamode tari gido betarida piara.’ ");
INSERT INTO bhg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Atako inemanemi itomane awara ari pisido ewa edo embo da (1)mi ainda aimamode engo taina, ‘Na kando imondemane piain kotembetena, ata rorae awa God da avigari. ");
INSERT INTO bhg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Awatedo, imondemane piari tao ae. Doiyobé tena.’ ");
INSERT INTO bhg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Edo begata engo ami inemane atopatari ewowoda ami God da ge siredo ewa. Ango eite inemane God da yai rorae piae dumbae edo ewa, rorae nenei jiwaebé ango.” ");
INSERT INTO bhg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ango edo Yesu embomai berari dao tesiri gumbero awamanede sisina, “Eniya ge eiwa imondemane tana. Imomane berari ge nato ingiwo edo kotembewo! ");
INSERT INTO bhg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Rorae ro arapada ami emboda doda torari mana dono aina God da jisida; Ata rorae emboda doda ami idegedo euri embo dono edo eira. ");
INSERT INTO bhg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ingiwo! Imomane ge ro tena awa bé gain edo gawa!” ");
INSERT INTO bhg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Edo Yesu embomai dodo mandoda maunsisina. Edo imo mando doda isiri ainda ambodani gundo sitera, “Nakare eniya ge teteta ainda ge moka tato gain gumbera.” ");
INSERT INTO bhg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesu mi awamanede sisina, “Imomane daedo ge eiwa gari tao ae? Imomane eniya ge tetena awa gain darewa? Emboda dobé ainda indari mambae, ata obogeda toruri ami indari berarida rorae beyae pieuri idegedo eira. Awatedo, obogemi indari berari sirigedo dave edo eira God da jisida.” ");
INSERT INTO bhg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Edo ami sisina, “Rorae ro emboda dobéda idegedo eira ami euri embo dono edo eira, God da jisida. ");
INSERT INTO bhg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Aindabé rorae embomainda dobé idegedo era awa, kotembari bebegae, ipuda ari, viro ari, dari betari, ");
INSERT INTO bhg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","rorae beono ari, embo neinda rorae jipapa ari, embo neneinde memesi piari, embo gisijiae dumbae ari, jitabaita ari, embo neinde jisi okain ari, gemi embo dari, dariga ari, edo dutari tepotapo. ");
INSERT INTO bhg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Awatedo, rorae bebegae berari eiwa emboda doda idegedo euri embo dono edo eira.” ");
INSERT INTO bhg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ango edo Yesu yai awa dodo erido yai neinda, nasi Taia edo nasi Saidoni kena maunsisina. Edo mandoda maundo totorisina, embomi imo ainda isira awa giworekae. Ata onjigedo itari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Edo eutu da (1)mi Yesu da gumbari bino ingido ainda yai maunsisina. Eutu awa Judah eutu ae, ata Siria-Poenisia eutu. Ami Yesu da yai gundo taida durudo benunu tedo dowae esisina, “Binei nato gagarada doda isira awa ondae etesita?” ");
INSERT INTO bhg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ata Yesu ainde sisina, “Edo na maiunjida bread sino mamainda yai augana, awa dave ae. Awatedo, doyo, maiunji gisibé awa unano inono ore.” ");
INSERT INTO bhg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Edo eutumi mina sisina, “Ge bé Badari, ata maiunjida itoto dowari boriri dutuda sino mamaimi tepo injido era. Awatedo, na gebé ena, imo daedo na kondade ata.” ");
INSERT INTO bhg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Edo Yesu mi ainde sisina, “Aindabé ito gebé ari nato yai pisido ge mina dave teteta. Mambuyo gate! Binei ito gagarada doda awa idegedo mambira.” ");
INSERT INTO bhg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eutu awa mandoda maundo torido, binei matu idegedo mambiri ainda gagara besida durudo oena apeite isiri gosisina. ");
INSERT INTO bhg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu tekago overegedo nasi Taia edo Saidoni awa dodo Nasi Babain Ajigari 10 da yai temundo gupusina, Galili ubutu kena. ");
INSERT INTO bhg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ango edo embo neneimi awamaneda otawo dauwa ge tari tao ae awa Yesu da yai kundo guputera. Edo awamanemi Yesu de ipa tamonda piari kaviyegarate benunu sitera. ");
INSERT INTO bhg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu embo jisi da itera awa dodo embo dauwa ge tari tao ae awa akuta kundo demonda maunsisina. Ango edo ainda ipa toro dengoroda piedo edo ipa toro nei beporo edo embo ainda iwawa tujijisina. ");
INSERT INTO bhg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesu jisi utuda edo God da yai benunu site keen bajina esisina. Edo embo ainde sisina, “Ephphatha” (ainda moka awa “Pirige”). ");
INSERT INTO bhg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yesu ge ango siri, burigibé embo ainda dengoro engiregari awa pirigesiri edo iwawa udegesiri ge dambu darari sisina, nei ro itae. ");
INSERT INTO bhg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ango edo Yesu mi ge okain sisina, “Buro bajina eiwa embo neneinde onjiga teove!” Embo ami ge ango tedo esisina, ata ainda ge jindedo onjiga teoro yai berarida arapu edo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Edo embo usitera ami wasiri awa gido bé kore bajinabé esitera. Edo sitera, “Imo buro berari awa dave edo esira. Embo dengoro dundari awa euri ge ingido era. Embo ge itae awa euri ge tedo era.” ");
INSERT INTO bhg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Edo iji ainde embomai jiwaebé doregesitera awa indari itae esisina. Yesu ainda ambodani dao tesiri gumbero awamanede sisina, ");
INSERT INTO bhg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Embomai jiwae namonde daedo eite deguta tamonde (3) eutara, edo awamane indari itae esira. Awatedo, nato do ari awa awamaneda yai. ");
INSERT INTO bhg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nane awamane piano nasi ikade ikadeda mambara, ata embomai nenei aikeda begata borerebé edo gupara. Awatedo, maunteite beji jisivi ari durara.” ");
INSERT INTO bhg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ango tesiri ainda ambodanimi mina sitera, “Yai eiwa abu toropubé. Edo kaenane embomai eiwa indari inono tamundo piaro indari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu mi tedogosisina, “Itomane yai bread nandogo isiri?” Ambodani mina sitera, “Natokare yai bread 7 itera.” ");
INSERT INTO bhg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Edo Yesu mi embomai doregesitera awa tesiri anunumbesitera. Ango etero Yesu mi bread 7 awa kundo God da yai ategari pipisisina. Edo bread engegegedo ambodanide piesiri kundo embomai anunumbetera ainde kandokando esitera. ");
INSERT INTO bhg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Edo daedo awamaneda yai un wo babaingae indewae itero gido Yesu de pietero God da yai ategari pipisisina. Ainda amboda ambodanide piedo sisina, “Wo eiwa dá etewa ango kandokando ewo indoré.” ");
INSERT INTO bhg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Edo embomai rorae awa injido inono esitera, awamane berari 4,000. Edo bread ae wo de injido itoto doturitera awa ambodanimi sirigedo kanjia babain berari 7 sirero visido beda esisina. Ango edo Yesu embomai piesiri awamaneda nasida maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Edo Yesu boraebé ae ainda ambodani de mada visido Galili ubutu temundo yai Dalamatua da guputera. ");
INSERT INTO bhg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Edo Parasi mane idegedo gundo Yesu da awara tari yai nonda edo gumbiri awa bavedogain kotembesitera. Ango edo awamanemi Yesu de ge okain sitera, God da kariwa teka piari gain. ");
INSERT INTO bhg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu embomai awa udugedo gido do memesi bajinabé budo sisina, “Nongaintedo embomai iji einda itera ami kariwa teka ano gain teri? Awara, ge ro imondemane tena, eiwa giwo! Kariwa teka embomai iji einda iterada yai mana piana!” ");
INSERT INTO bhg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Edo Yesu ae ainda ambodani de embomai awa dodo tekago ubutu kupo neinda temain tedo mada sisiritera. ");
INSERT INTO bhg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Edo iji ainde ambodani bread bae ruvegesitera. Ata awamane tepeite ma doda bread da (1) isiri taputera. ");
INSERT INTO bhg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Edo Yesu mi awamanede dedegari ge okain sisina, “Parasi mane ae Herod deda bread badari siwo awa gidogogo ewo!” ");
INSERT INTO bhg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yesu mi ge ango tesiri ambodanimi tuturo edo akuta ge mina tara edo ingitera, “Kaena bread itae, awa embo, Yesu mi Parasi mane ae Herod deda ge bread badari siwoda sira.” ");
INSERT INTO bhg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu matu awamaneda ge ro teri awa gosisina. Awatedo, embo ami ambodanide sisina, “Ro awa embo imomane bread itae mina tara akuta evi? Imomane gaegae ewa? Itomane do okain matawa isira? ");
INSERT INTO bhg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Imomane jisi de dengoro de isira amo nongo edo gaegae evi, edo ingido kotembae evi? ");
INSERT INTO bhg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Imomane kotembetevi iji nonde na bread ipa da (5) engegegatana? Embobo 5,000 ainda awa itoto sirigedo kanjia nandogo sirewo beda eutari?” Ambodanimi sitera, “Ajigari berari 12.” ");
INSERT INTO bhg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Edo Yesu mi tedogosisina, “Daedo iji ainde na embomai 4,000 awa embo bread 7 engegetena awa, kanjia babain nandogo itoto sirigedo sirewo beda esiri?” Ambodanimi mina sitera, “Ajigari berari 7.” ");
INSERT INTO bhg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Edo Yesu mi sisina, “Ro embo imomane gain darevi?” ");
INSERT INTO bhg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Edo Yesu ae ainda ambodani de Besaida nasida guputera edo embo jisiguba ari awa embo neneimi ainda yai kundo guputera. Edo Yesu mi embo awa tujiari kaviyegarate tedo dowae esitera. ");
INSERT INTO bhg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ango edo Yesu mi embo jisiguba ari ipada jido kundo nasi dodo idegedo maunsisina. Yesu embo ainda jisida kosiwa edo ipa ainda yai piedo sisina, “Imo rorae ro gotesi?” ");
INSERT INTO bhg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Embo ami pangedo Yesu de mina sisina, “Na embomai gotena. Awamaneda kariwa awa ni petari ango ata awamane ainto era.” ");
INSERT INTO bhg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu tenda embo ainda jisida ipa piedo tesiri pangisina. Ango edo embo jisiguba ari awa jisi pirigesiri yai berari arapa gosisina. ");
INSERT INTO bhg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ango edo embo awa kaviyegesiri gido Yesu mi sisina, “Ito mandoda mambuyo! Edo nasi doda mambote, edo imo eteno kaviyegeteta awa embo nasida tato giwóre!” ");
INSERT INTO bhg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ae ainda ambodani de idegedo maundo nasi da da totoritera yai Seseria Pilipai ainda doda. Edo begata toropuda ambodanide tedogosisina, “Teu gane! Embomi na awa embo ave tedo eri?” ");
INSERT INTO bhg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ambodanimi mina sitera, “Embomaimi tedo era, imo awa John Bapataito Ari Embo tenda ereta, neneimi tedo era awa imo Elijah tekago utuda edo gumbeta, edo neneimi tedo era awa imo peroveta mamatu ainda da (1), ami tenda ereta.” ");
INSERT INTO bhg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Edo imomane nongo kotembedo evi?” Yesu mi ambodanide tedogosisina, “Na averi?” Edo Peter mi ainde mina sisina, “Imo awa Keriso.” ");
INSERT INTO bhg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ango edo imo awamanede ge okain sisina, “Na Keriso ami gumena awa tawo embo nenei giwóre!” ");
INSERT INTO bhg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Edo Yesu ainda ambodani atopatari tuturo eite sisina, “Na awa Embo da Mai, ata orobeda kopuru mamai de pirisi babain de Aodarida atopapasigari demi ajiregara, edo memesi bajinabé bana. Edo daro betana, ata deguta tamonde (3) ainde tekago erana.” ");
INSERT INTO bhg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu ge arapada bededo ambodanide sisina. Edo Peter mi embo awa kundo demonda eiunte ge okain ainde sisina, “Nongain ge ango tesi?” ");
INSERT INTO bhg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ata Yesu wareregedo ainda ambodani goteite awa Peter isimbedo sisina, “Eve mambu! Ge awa Satan mi siri teta. Kotembari awa God da yai edo gumbaera giyo, ata butu emboda kotembari!” ");
INSERT INTO bhg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ango edo Yesu embomai doregesitera awa ae ainda ambodani de dao tesiri, ainda yai gumbero sisina, “Imo aimi nato amboda purain edo gido imo akuta ruvegata, edo ito orega awa budo na ambo ambo eyo! ");
INSERT INTO bhg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Imo wasiri ikaito awa gisi piain ata gido awa dadoegata, ata imo wasiri ito na embo edo God da bino dave awa embo dadoegata gido awa, imo wasiri natopo itari bata. ");
INSERT INTO bhg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Embo butuda gunaguguye berari bari ainda arate eite ainda wasiri natopo itari niyaoda piaina ango awa dave ae! ");
INSERT INTO bhg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Embo butuda gunaguguye berari ami God da yai wasiri natopo itari awa mina piya edo bari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Embo aimi dao nato ae ge nato de tari awa mengaina gido, iji boroko embomai God ajiregedo wasiri bebegae edo era einde, na, Embo da Mai emi, iji angode nato Mamo da taogarida parara de anela kokotopumi daedo doiaro gundo, embo awa gido mengana.” ");
INSERT INTO bhg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ango edo awamanede sisina, “Awara! Ge ro boroko imondemane tena, eiwa giwo! Embo nenei einda itera awa betainyae isiaro jirari God da gisijiari gorobade matu gumbira awa gara.” ");
INSERT INTO bhg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Deguta 6 itae esiri Yesu mi Peter ae James de John de kundo peji ikane vivisisina, awamane akuta. Edo gosite itero Yesu da tamo wareregedo kariwa eve esisina. ");
INSERT INTO bhg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Edo ainda ombarijiari parara esiri yai berari datembesisina. Pararada tega awa ainyabé ainya dá ango. Butu embo da aimi roviravi dá teiari tega dave ango ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iji dá ainde, Elijah ae Moses de idegedo Yesu de ge tero ambodani tamonde (3) gositera. ");
INSERT INTO bhg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Aindabé awamane boroboro edo Peter ge nongo taini awa adumi darisina. Edo Peter mi Yesu de sisina, “Atopatari, dave awa nakare einda itera. Awatedo, bowa tamonde (3) ae etera, imo da (1), Moses da (1) edo Elijah da (1).” ");
INSERT INTO bhg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Edo gotero poraga gundo apuregedo awamane duga esiri ge yavi engo poragada edo gupusina, “Eiwa nato dubobari Mai. Ainda ge ingiwo!” ");
INSERT INTO bhg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Edo ge yavi itae esiri burigibé ambodanimi ge aimi siri awa gain kakowa esitera. Ata ge tari embo itae, daedo Moses ae Elijah de itae. Tepo Yesu akuta gositera. ");
INSERT INTO bhg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ango edo awamane pejida edo wowosite Yesu mi sisina, “Nato tamo wareregedo kariwa eve esiri gewa awa embo neinde teove dowo! Itomane doda isiari na Embo da Mai awa betedo erano ainda amboda karigawo embomi goré!” ");
INSERT INTO bhg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ambodani ge sisina awawa embo neneinde onjiga tae. Ata awamane akuta ge mina tara edo ingitera, “Betedo erari tesira, ainda mokabé awa rori?” ");
INSERT INTO bhg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Edo awamane Yesu de tedogositera, “Ro awa embo Aodarida atopapasigari mi Elijah gisi God da Avigari Embo awa gumaina tedo eri?” ");
INSERT INTO bhg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Edo ami awamanede mina sisina, “Aodarida atopapasigari gebé tedo era. Elijah gisibé nato gumbari awa, ami gundo embomainda do berari sirigedo dave aina. Ata God da ove gaiari matu isira awa gotevita? Embomaimi memesi jiwae edo tedojirari ge, na Embo da Mai einde, tepotapo piara. ");
INSERT INTO bhg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ata nane imondemane tena, embo dá kariwa Elijah ango gupusina. Edo embomaimi awamaneda jipapa ari bebegae ainda yai eutara, God da ove matu gaiedo tari isira ango.” ");
INSERT INTO bhg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Edo iji ainde Yesu ae ambodani tamonde (3) de gundo ambodani nenei taputera. Edo embomai jisi bajinabé ambodani nenei jinenembedo itero Aodarida atopapasigarimi ambodani neneinde ge baieite be duduno ero Yesu gundo gosisina. ");
INSERT INTO bhg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Edo embomai berarimi Yesu gido kore bajinabé edo borae tumundo gundo imo ategesite “Oro! Oro!” sitera. ");
INSERT INTO bhg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Edo Yesu mi Aodarida atopapasigaride tedogosisina, “Imomane nongo edo ambodani natode ge baieite itevi?” ");
INSERT INTO bhg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Edo embomai doregesitera ainda doda embo da (1)mi erido Yesu de mina sisina, “Atopatari, na mai nato asisimi iwawa bundari ge tari tao ae, awa embo ito yai kundo gumena. ");
INSERT INTO bhg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Edo iji nenei awa asisimi engiregedo dedo augeuri butuda durudo porokutu eite tamo boroboro euri ji vegedo eira. Awatedo, ito ambodanida yai kundo gumena, asisi beyae ondaro idegarate. Ata awamane ari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu mi embo ainde mina sisina, “Embo boroko itewa awa gebé ari itae! Na imondemane iji ribori itainyae. Na imondemane buro engo awa tenda ainyaera—Giwo! Awara, mai awa nato yai kundo gumbú!” ");
INSERT INTO bhg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ango edo awamane mai awa kundo Yesu da yai guputera. Edo iji ainde asisimi Yesu gido boraebé mai awa jipesiri butuda durudo doverodovero eite porokutu esisina. ");
INSERT INTO bhg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Awatedo, Yesu mi mainda mamode tedogosisina, “Iji ro mai ito asisi beyaemi dari tuturo esisini?” Ainda mamo mina sisina, “Mai saka babodeiri asisimi dari tuturo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Edo iji jiwae asisi beyaemi mai eiwa niyaoda edo unda ango augaina, dari betarate edo eira. Awatedo, imo ari taorita, nakare do edo ato kaviyegarate benunu tera.” ");
INSERT INTO bhg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu embo ainde mina sisina, “Edo imo God gebé ata awa, God mi buro berari imo ro kotembeteta awa aina.” ");
INSERT INTO bhg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Edo boraebé mainda mamomi jijiude aorogasisina, “Badari, na gebé ena. Nato gebé ari saka awa eyo bajina are!” ");
INSERT INTO bhg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iji angode, embomai jiwae Yesu da yai tumundo guputera. Yesu imo doiain gumbero gido boraebé asisi beyaede ge okain sisina, “Dauwa ge itaeda asisi, nane imonde tena, mai awa dodo idege! Tekago torote!” ");
INSERT INTO bhg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Edo asisimi aorogatedo mai awa beyaebé jipedo butuda augesiri duriri dodo idegesisina. Aindabé mainda tamo awa dá betari ango esiri embomai jiwae ge ango sitera, “Aiya, mai awa betesira.” ");
INSERT INTO bhg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ata Yesu atembedo mai awa ipada jiri tou edo erorisina. ");
INSERT INTO bhg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ango edo Yesu mandoda maundo toriri ainda ambodanimi ainde onjigarida tedogositera, “Ro awa embo nakare asisi beyae ondetero idegae esiri?” ");
INSERT INTO bhg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ango tetero awamanede mina sisina, “Asisi beyae engo awa mana tepo tawo idegaina, ata benunu site indari dodo veta eiawo God mi imomane kondade aina.” ");
INSERT INTO bhg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Yesu ae ainda ambodani de yai ainda awa dodo yai Galili torido maunsitera. Aindabé, imo ainda ambodani akuta atopatain, Yesu yai ainda isira awa embo da aimi gari awa jipapa ae esisina. Ango edo Yesu mi awamane atopaposite sisina, “Na, Embo da Mai awa, gitopo emboda ipada piari daro betana. Ata ainda amboda na betedo, deguta tamonde (3) ainde tekago erana.” ");
INSERT INTO bhg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ata awamaneda yai atopatari awa arapa ae, edo awamane Yesu de ge tedogari awa adu esitera. ");
INSERT INTO bhg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Edo Yesu ae ainda ambodani de Kapenium nasida gundo mandoda totoritera. Edo ainda ambodanide tedogosisina, “Imomane begata toropuda akuta ge baietewa aindabé rori?” ");
INSERT INTO bhg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ata awamane ge mina tae damodamo esitera, aindabé, awamane akuta begata toropuda ge baitera, “Embo aimi kaenato toropu einda kaena berari daginegaini?” ");
INSERT INTO bhg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Edo Yesu anumbedo ainda embobo 12 tesiri gumbero sisina, “Edo imo badarida dero bain jipapa eta gido awa, imo akuta piato wotari embo berarida buro embo ata. Edo buro ango ata ami derobé God da jisida bata.” ");
INSERT INTO bhg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ango edo Yesu mi mai da (1) kundo gundo ambodanida toropuda pipisisina. Ainda amboda mai awa osinembedo awamanede sisina, ");
INSERT INTO bhg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Embo aimi mai engo ategeteite bureira na embo awa, na bureira. Edo embo aimi na ategesite bureira awa, na akuta bae, ata God na piesiri guputena awa bureira.” ");
INSERT INTO bhg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Edo John mi Yesu de mina sisina, “Atopatari, nakare embo nei gotara. Awa kaena ambo ambo ae, ata dao itoda bineimane ondeiri idegatara. Aindabé embo awa kaenamonde iae, nanekaremi embo awa engiregatara buro ango awa eurekae siutara.” ");
INSERT INTO bhg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ata Yesu mi sisina, “Embo awa engiregeove! Aindabé, embo aimi buro babain nato daoda aina, ami boraebé nato yaida ge beyae mana taina. ");
INSERT INTO bhg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Edo embo aimi imondemane gitopo ae awa itomane topo. ");
INSERT INTO bhg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Edo daedo ge ro boroko imondemane tena eiwa giwo! Embo aimi un akou da (1) imondemane piaina, aindabé imomane na, Keriso, ambo ambo edo ewa, God mi tau dave embo ainde piaina. ");
INSERT INTO bhg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Edo dave da (1) awa embo ainda duboda ganuma bajina kaingedo ewada augaro injido betaina, gaegae edo embo ami ari mai sakada gebé ari nato yai awa dowaina. ");
INSERT INTO bhg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Awatedo, ito ipami rorae ro budo imo jimbo beyae ata ango gido awa, kautugedo ipa da (1) akuta doyo. Awa beyae ae imo inono ipa da (1)de wasiri natopo itari kumbata, gaegae edo ari beyae ipa tote (2)mi ata awa, yai beyae niyao matawa itari aveira ainda torata. ");
INSERT INTO bhg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Yai awa ‘Ango embomainda tamopisi depeka edo eira, ainda yaeni betae matawa isima eira. Edo dá ango, embomai ainda mauntera awa, memesi bajinabé matawa budo era, niyao matawa aveite isira ainda.’ ");
INSERT INTO bhg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Edo ito taimi ainto edo maundo jimbo beyae ata ango gido, tai awa kautugeyo. Awa beyae ae imo ango ata edo tai kaparide wasiri natopo itari kumbata, gaegae edo tai tote (2)mi darido maundo jimbo beyae ata awa, God mi imo kundo yai beyae niyao matawa itari aveira ainda augaina. ");
INSERT INTO bhg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Yai awa ‘Ango embomainda tamopisi depeka edo eira, ainda yaeni betae matawa isima eira. Edo dá ango, embomai ainda mauntera awa, memesi bajinabé matawa budo era, niyao matawa aveite isira ainda.’ ");
INSERT INTO bhg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Edo ito jisimi rorae ro gido imo jimbo beyae ata ango gido, jisi awa gurugedo jisi da (1) doyo. Awa beyae ae imo inono jisi da (1)de wasiri natopo itari yaida torata, gaegae edo jisi tote (2)mi gido jimbo beyae ata awa, God mi imo kundo yai beyae niyao matawa aveira ainda augaina. ");
INSERT INTO bhg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yai awa ‘Ango embomainda tamopisi depeka edo eira, ainda yaeni betae matawa isima eira. Edo dá ango, embomai ainda mauntera awa, memesi bajinabé matawa budo era, niyao matawa aveite isira ainda.’ ");
INSERT INTO bhg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Aindabé, katari iji ainde God mi embo berarida wasiri awa kataina, dá niyaomi rorae beyae dungedo rorae dave dungae dowaina ango. Edo embo aimi ainda do God da yai wareregaina awa, God mi embo ainda jimbo beyae kotembedo dowari itae aina, edo ainda gebé ari kondade ari badaina, awa dá katomi pisida depeka ari engiregedo indarida mina bari dave piedo eira ango. ");
INSERT INTO bhg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Atako, iji angode katoda gavi mina bari awa sisigesira, ami indarida mina bari dave piari tao ae, edo ainda gavi mina bari tenda gumbari tao ae. Awa imomane dá ango God da gisijiarida embo bajina ain ge baieite ima ewa. Imomane awa dá kato ango ewo! Edo dariga awa dodo bégada isite buro ewo!” ");
INSERT INTO bhg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Edo Yesu yai awa dodo erido un Jodani kupo neinda temundo wotedo yai Judea kena maunsisina. Ango esiri embo jisijisi tenda gundo jinenembesitera. Edo imo dá edo eira ango ami awamane tenda atopaposisina. ");
INSERT INTO bhg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Edo Parasi mane gundo Yesu bavedogain, tedogari pipisitera, “Nakare te goré! Awa awarita, embo aro jimundo amboda dodo evekara ari?” ");
INSERT INTO bhg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Edo Yesu tedogari mina sisina, “Moses mi ge okain ro imondemane gagurisini?” ");
INSERT INTO bhg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Awamanemi sitera, “Moses mi gagurisina awa, embo aro dowain edo gido, ‘Jimbari itae ena,’ ango ove gaiedo eutu awa piari mambarate sisina.” ");
INSERT INTO bhg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu awamanede mina sisina, “Aindabé itomane do okain edo imomane God da jipapa ambo ambo ari tao ae, Moses ge eiwa gagurisina. ");
INSERT INTO bhg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ata tuturoda God mi utu ae butu de esisina ainda awa, ‘embo de eutu de esisina.’ ");
INSERT INTO bhg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Aindabé awa, embo ainda aimamo dodo arode dada aina. ");
INSERT INTO bhg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ango era ami, awamane tote (2) awa gundo tamo da (1) ara.’ Ango edo awamane tote (2) evekara itari tao ae, ata tamo da (1). ");
INSERT INTO bhg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Awatedo, embo ae eutu de God mi piesiri dada etera awa, embo enembomi mana piaro evekara ara.” ");
INSERT INTO bhg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Daedo, Yesu maundo mandoda torido isiri ge awa ambodanimi tenda tedogositera. ");
INSERT INTO bhg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Edo awamanede sisina, “Embo aimi ‘Jimbari itae ena,’ ove ango gaiedo ainda aro dowari mambari, eutu nei jimaina, awa jimbo ipuda ari ainda aro matuda yai. ");
INSERT INTO bhg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Edo eutu ainda iu dodo embo nei jimaina, awa jimbo ipuda ari ainda iu matuda yai.” ");
INSERT INTO bhg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Edo embo neneimi mamai Yesu da yai kundo guputera, God da ao ari awa embo ipa tamonda piarate. Atako, ambodanimi awamanede ge okain sitera, “Imomane dodo mamai kundo mambú!” ");
INSERT INTO bhg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ata, iji angode Yesu mi wasiri awa gido bé dubodave ae edo ambodanide sisina, “Ango teove! Mamai dowo! Nato yai gumboré! Aindabé, embo God tumonda edo era dá mamai engogo awa, God da gisijiarida itera. ");
INSERT INTO bhg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Awara! Edo ge ro boroko imondemane tena, eiwa giwo! Embo da aimi God mi gisijiarate jipapa eira awa, ainda gumbari ategedo kumaina, dá mamai ango. Edo ango aina awa, God mi embo awa gisijiaina. ");
INSERT INTO bhg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Edo Yesu mi mamai ipada jiuri gumboro osinembedo ipa tamonda piedo, God da ao ari awawane embo benunu tedo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Edo Yesu ae ambodani de yai ainda edo idegedo begatada ainto edo mauntero, embo da (1) tumundo gundo Yesu da doda baongo dadari edo kondade arate tedogosisina, “Atopatari, imo awa embo dave. Te gane! Na buro ro edo wasiri natopo itari kumani?” ");
INSERT INTO bhg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Awatedo, Yesu mi embo ainde sisina, “Ro awa embo na dave tesi? Imo na dave teta aindabé awa gotesi? Embo enembo awa dave da (1) itae, ata God akuta. ");
INSERT INTO bhg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Imo God da ge okain berari sisina awa gari. Ainda tari awa, ‘Ipuda eote, dato beteure, beono eote, ge pitawa teote, embo neinda rorae gae jigamo eote, ito aimamo tou edo eyo.’” ");
INSERT INTO bhg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Edo embo ami Yesu de mina sisina, “Atopatari, na tuturoda mai tekade God da ge okain sisina berari teteta awa ambo ambo eite gundo boroko matawa eite itena.” ");
INSERT INTO bhg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ango tesiri Yesu embo awa jisini eite dubobari gemi sisina, “Imo buro nei da (1) bé awa ata. Imo maundo ito rorae berari pieyo embo neimi oriaro ito ganu awa embomai rorae isisigaede piate, edo gaiapabé utuda bata. Edo gumbuyo! Orega awa kundo na ambo ambo ate.” ");
INSERT INTO bhg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesu mi ge ango tesiri gosisina, ata, embo awa gunaguguye jiwae edo ainda gaiapa mana dowaina ango kotembesisina. Awatedo, embo awa dombubé wa boruda darago esiri mamato eite taigedo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ango esiri Yesu ambodani jisimi udugedo gido awamanede sisina, “Embomai gaiapade awa God da gisijiarida torari awa okain bé tambara!” ");
INSERT INTO bhg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Edo ambodanimi ge awa siri gido kore bajina esitera. Atako Yesu awamanede tenda sisina, “Maiunji, embomaimi awamaneda gaiapa tumonda eite torari okain bé God da gisijiarida tamundo era! ");
INSERT INTO bhg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Embo gaiapademi God da gisijiarida torari awa okain dá wo bajina kamelo mi ninou to sakada ango mana toraina.” ");
INSERT INTO bhg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Edo awamane kore bajinabé eite mina tara esitera, “Embo bé aimi God da tonembari baini?” ");
INSERT INTO bhg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ata Yesu awamane jisini eite sisina, “Gebé, embo enembomi awamaneda wasiri topo tonembari tao ae; ata God buro berari ari tao. Awatedo, God mi awamane tonemaina.” ");
INSERT INTO bhg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ango edo Peter mi Yesu de ge tuturo edo sisina, “Giyo! Nakare rorae berari dodo guputera, imo ambo ambo edo era.” ");
INSERT INTO bhg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Edo Yesu mi mina tedo sisina, “Awara! Edo ge ro boroko imondemane tena, eiwa giwo! Embo da aimi ainda mando dodo, nanonameji, ruaimono, aimamo, aro ae maiunji de ritako butu dodo na awa embo edo God da bino dave awa embo mambira awa, ");
INSERT INTO bhg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","rorae bé jiwaebé boroko iji einde baina. Awatedo, God mi kando bé jiwaebé (100) ango oromando, nanonameji, ruaimono, aimono, maiunji edo butu, emboda yai piari baina. Edo daedo embo aimi na ambo ambo edo eira awa, embo neneimi memesi neindekainde ainda yaida piara. Edo iji amboda gumaina ainde, embo awa wasiri natopo itari baina. ");
INSERT INTO bhg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ata gisijiari jiwae boroko iji einde itera awa dero bé tuda amboda wotedo bara. Edo buro embo jiwae boroko iji einde itera awa dero bé ikaneda amboda visido bara.” ");
INSERT INTO bhg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Edo iji ainde Yesu ae ainda ambodani de begatada Jerusalem kena vitain maunsitera. Edo Yesu awa begata kopuru eiri awamane gido kore bajina esitera. Ango edo awamanemi Yesu ambo ambo eite adu esitera. Edo Yesu ainda embobo 12 awa tekago demonda doregedo ami tuturo edo buro ro ainda yai idegaini awa awamanede tesiri gositera. ");
INSERT INTO bhg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ingiwo! Kaena Jerusalem kena vivitera. Edo na, Embo da Mai awa, pirisi babain ae Aodarida atopapasigari deda yai piari mamana. Awamanemi na kundo katara. Edo Judah embobo aeda yai piaro mamana nato betari awa embo. ");
INSERT INTO bhg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Edo awamanemi na awa tedojirido, asi bebedemi vededo, na kosiwa edo daro betana. Ata deguta tamonde (3) ainde awa, na awa tekago erana.” ");
INSERT INTO bhg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ango edo James ae John de, Zebedee da mamai, Yesu da yai guputera. “Atopatari,” awamanemi sitera, “Nakare ro jipapa era awa inemi ae etesita?” ");
INSERT INTO bhg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Itomane jipapa awa rori?” Yesu mi awamanede sisina. ");
INSERT INTO bhg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Awamanemi mina sitera, “Iji nonde imo ito anumba ainda taogaride gisijijieite gido awa, nakare jipapa era awa, embo nei ito ipabeda edo embo nei ito ipa andada anumain.” ");
INSERT INTO bhg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ata Yesu mi awamanede sisina, “Imomane ro atega evi awa gae. Imomane inono memesida akou nane inana ango awa indavi? Edo imomane inono betarida bapataito nane bana ango awa bavita?” ");
INSERT INTO bhg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Nakare inono ango ara,” awamane mina sitera. Awatedo, Yesu mi awamanede sisina, “Imomane gebé, memesida akou nane inana angó awa indawa, edo imomane betarida bapataito nane bana angó awa bawa. ");
INSERT INTO bhg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ata na awara ari embo katambarida itae, aimi anumaini nato ipabeda edo nato ipa andada. Eiwa ta, God mi matu katambedo siya esisina; awatedo, God mi tari ainkaimi namonde daedo anumbedo gisijiara.” ");
INSERT INTO bhg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Edo iji angode ambodani ajigari 10 mi James ae John deda ge awa ingido dubodave ae bé esitera. ");
INSERT INTO bhg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ata Yesu mi ambodani berari dao tesiri gumbero awamanede sisina, “Imomane gotewa awa, gisijijiegari butuda einda ami ge okain awamaneda embomainde tedo era, edo awamaneda awara tarimi embomai gisijido era. ");
INSERT INTO bhg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Awarata, itomane badari tega arapa ainyae. Ata embo aimi God da gisijiarida embo bajina ain eira gido embo nei kondade aina. ");
INSERT INTO bhg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Edo embo aimi badararida dero bain jipapa eira gido awa, embo berarida buro embo aina. ");
INSERT INTO bhg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aindabé na, Embo da Mai awa, embo bajina ano embo neneimi na tou orote gumbae, ata nane embo kondade edo nato wasiri dadoegedo ami emboda jimbo bebegaeda mina piano embo jiwae udegari budo God da gisijiarida tororote.” ");
INSERT INTO bhg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ango edo Yesu ae ainda ambodani de Jeriko nasida guputera. Ainda amboda awamane ae embo jiwaebé de daedo nasi awa dodo idegedo maunsitera. Edo embo jisiguba ari dao Bartimaeus, awa Timaeus da mai, ami begata demonda anumbedo isite embode ganu benunu tedo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Edo Bartimaeus mi Yesu Nasaret Embo awa gupeira ainda bino ingisina. Edo tuturo edo aorogatedo sisina, “Yesu, David da Mai, na do ewasi!” ");
INSERT INTO bhg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Iji angode embo jiwaebé ge okain embo ainde tedo esitera, “Imo ge do!” Ata embo ami aorogatedo dowae esisina. “David da Mai, na do ewasi!” ");
INSERT INTO bhg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ango edo Yesu petedo dapisina, edo ge okain sisina, “Embo owa dao teú nato yai gumbare!” Awamanemi embo jisiguba ari ainde sitera, “Yesu imo dao sira. Eri! Adu eote! Erido gumbuyo!” ");
INSERT INTO bhg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Edo ge ango tetero embo ainda dademo ombari kokumbedo augeteite tou edo erido Yesu da yai gupusina. ");
INSERT INTO bhg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Awatedo Yesu mi sisina, “Nane imonde ro anate jipapa esi?” Ango tesiri embo jisiguba ari ami sisina, “Atopatari Bajina, nato jisi ato dave ari yai gain tena.” ");
INSERT INTO bhg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ango edo Yesu mi Bartimaeus de sisina, “Mambuyo! God mi ito gebé ari nato yai pieteta ami imo esiri kaviyegeteta.” Edo boraebé embo ainda jisi pirigesiri rorae berari arapa gosisina. Ango edo Yesu begatada ambo ambo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Edo iji ainde Yesu ae ainda ambodani de Jerusalem torain aikae gundo nasi Bethphage ae Bethany deda demonda esitera, Ni Olive de Peji ainda. Edo ainda ambodani tote (2) gisi nasi mamain era ainda piesiri maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Edo awamanede sisina, “Nasi kupo neinda maundo totoreite ainda wo donki mai buri edo kanjigari tambawa, embo da aimi ainda tamonda gisi anumbae. Awa udegedo kundo einda gumbuwo! ");
INSERT INTO bhg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Edo embo da aimi imondemane, ‘Nongo ain wo mai awa udegetevi?’ tari gido tewo! ‘Badari mi jipapa eira.’ Ango tawo boraebé piari budo egenembedo gumbave.” ");
INSERT INTO bhg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ango tesiri aedade yai awa dodo maundo nasida torido wo donki mai mando be demonda kanjigari arapada isiri gositera. Edo udegesitera. ");
INSERT INTO bhg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Edo embo nenei mando demonda petari isite ambodani tote (2) gido sitera, “Nongaintedo donki mai amo udegetevi?” ");
INSERT INTO bhg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Edo Yesu da ambodanimi embo petari ainde ge mina sitera, “Badari mi jipapa eira.” Edo dotero ambodani tote (2) donki mai awa kundo egenembedo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ango edo awamane donki mai awa Yesu da yai kundo guputera. Edo awamaneda dademo ombari wo tamonda besi jirero Yesu visido anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Edo embo jiwaebémi awamaneda tou ari arapa ain jipapa esitera. Awatedo, awamaneda dademo ombari begatada besi jijiritera, edo embo nenei ni igi papatude kapedo begatada giro esitera. ");
INSERT INTO bhg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ango edo avekave gisi esitera ainde nenei Yesu da amboda orovigesitera ainde mi aorogatedo sitera, “Oro! Oro! ‘God da ao ari embo einda yai itare! Embo eiwa BADARI da daoda gupeira!’ ");
INSERT INTO bhg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","God da ao ari mamo kaenato David da gisijiarida yai itare! Awa Badari da daoda gupeira! Oro! Oro! God utu ikanebéda isira awa dasiga era!” ");
INSERT INTO bhg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Edo Yesu Jerusalem torido matawa maundo Judah embomainda oro kotopu bajinada totorisina. Edo rorae berari jisimi udugedo goteiri iji itae eiri turo damodamo esisina. Ango esiri gido imo ae ainda embobo 12 de Jerusalem dodo idegedo Bethany nasida maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ango edo awamane Bethany nasida aveunte sipode idegedo maunteite Yesu beji mina burisina. ");
INSERT INTO bhg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Edo embo ami jisi piedo da aikeda ni dunga igi botu eiri gido, “Be isirita?” tedogain maunsisina. Ata dungada yoa ae, awatedo, ainda be da ji itae rata igi akuta. ");
INSERT INTO bhg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ango esiri gido mina Yesu mi begá ge sisina, “Ine mana be tenda ato embomi indara!” Ge ango siri ainda ambodani ingitera. ");
INSERT INTO bhg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ango edo awamane Jerusalem gundo, Yesu Judah embomainda oro kotopu bajinada totorisina. Edo embomaimi womane origarori ero gido tuturo edo awamane onjisina. Embo yai neneinda gano sirigari tenemba ro awa jiuri doveregedo gano yoyowa edo esitera. Edo daedo ni ribo ango oriari emboboda anumba jiuri doveregedo esitera. ");
INSERT INTO bhg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aindabé, embomaimi roviravi nenei kundo gundo maundo Judah embomainda oro kotopu bajina demonda eorekae, Yesu mi awamane engiregesisina. ");
INSERT INTO bhg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ango edo Yesu mi embomainde atopatari gemi sisina, “Matu peroveta Isaiah mi God da geda gagurisina awa davebé edo gaeta? Awa engo, “‘Nato oro awa embomai butu berarida benunu oro.’ Ata inemanemi etewo ‘beono emboda onjigari banga to’ ango esira.” ");
INSERT INTO bhg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Edo embomai jiwaebé Yesu da atopatari dave awa gido korebé eite ambo ambo edo era, ge awa ingido pirisi babain ae Aodarida atopapasigari demi adu esitera. Awamaneda badarida dero awa kumburekae, awatedo, begata jiwae kakowa esitera, Yesu daro betarate. ");
INSERT INTO bhg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ainda edo turo jijiriri imo Jerusalem nasi dodo idegesisina. ");
INSERT INTO bhg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Edo aveunte sipode awamane Jerusalem egenembeteite begata demonda jisi piedo ni dungada igi awa mumuya ari gositera, besinyada edo maundo gombuda. ");
INSERT INTO bhg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Edo Peter jiro buro edo Yesu de sisina, “Atopatari, oure gi! Ni inemi begá eteta awa mumuya esira.” ");
INSERT INTO bhg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ango tesiri Yesu awamanede sisina, “Itomane gebé ari God da yai piewo! ");
INSERT INTO bhg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Awara! Edo ge ro boroko imondemane tena, eiwa giwo! Edo embo dami peji einde taina, ‘Imo gigitembedo ewada dagumbeyo!’ Peji awa gigitembedo ewada dagumaina. Aindabé, embo ainda gebé ari God da yai pipiteira edo itadaita itae awa, God mi embo ainda benunu sira awa ari bé aina. ");
INSERT INTO bhg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Awatedo, nanemi imondemane tena, iji angode imomane rorae ro jipapa edo benunuda tedogido ewa awa, God mi matu piesiri kumbewa, ango gebé ewo, edo ami piari bave. ");
INSERT INTO bhg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Edo iji nonde imomane benunu tain eite gido nembu neimi imondemane beyae ro etera gido awa kotembedo dowo! Ango awo Mamo kaenato utuda ami itomane bebegae kotembedo dowari itae are. ");
INSERT INTO bhg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ata, imomane nembu neinda bebegae imondemane etera awa kotembedo dowae awa gido Mamo kaenato utuda ami itomane bebegae mana kotembedo dowari itae aina.” ");
INSERT INTO bhg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ango edo awamane tekago Jerusalem guputera. Edo Yesu Judah embomainda oro kotopu bajinada torido pepeta eiri pirisi babain de Aodarida atopapasigari de orobeda kopuru mamai demi gundo Yesu da yai esitera. ");
INSERT INTO bhg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Edo awamanemi Yesu de sitera, “Awara tari ito nonda budo imo buro engogo esi? Edo embo aimi imonde awara tari piesiri buro engogo esi?” ");
INSERT INTO bhg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ata Yesu mi awamanede mina sisina, “Na daedo imondemane tedogari da (1) piano ainda mina tawo gido awa nato awara tari aimi piesiri buro engogo eni awa tano gawa. ");
INSERT INTO bhg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tewo gane! John bapataito edo esisina awa, ainda awara tari yai nonda edo gupusini? God mi awara tari piesiri edo esisinita ko embo enembomi pietero edo esisini?” ");
INSERT INTO bhg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Edo awamane akuta ge mina tara esitera, “Kaenane, ‘God da yai edo gumbari,’ tara awa, embo omi taina, ‘Ro awa embo imomane John gebé ae esitevi?’ ");
INSERT INTO bhg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ata kaenane, ‘Embo enemboda yai edo gumbari,’ ango tara awa adu era. Embomai jiwaebé John Bapataito Ari Embo awa peroveta bajina dá ango tedo era, awatedo, owamanemi kaenamonde sinigambari ara.” ");
INSERT INTO bhg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ango edo awamanemi Yesu de mina sitera, “Nakare John da awara tari aimi piesiri bapataito edo esisini awa gae.” Edo Yesu mi mina awamanede sisina, “Ango tewa, awatedo, nato awara tari aimi piesiri buro engogo eni awa imondemane tainyae!” ");
INSERT INTO bhg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ango edo Yesu mi awamanede eniya ge tari tuturo esisina. “Embo da (1) ami gurepi buroda uredo puwa jido gurepi gama bari yai banga tamonda duredo edo simagari beuri esisina. Edo sima ari embobo katambesisina, awamanemi gurepi be arida yoa gumbari gido mina ainda yai piaro baintedo. Edo imo yai aikeda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Edo gurepi tari ari yoa gumbiri ainda buro embo piesiri gurepi sima ari emboboda yai maunsisina, embo ainda gurepi tokedo piaro kundo gumbarate. ");
INSERT INTO bhg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ata sima ari embobo erido gurepi tutuda buro embo awa kundo beyaebé dedo pietero ipa tepobé overegesisina. ");
INSERT INTO bhg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ango etero imo gumbiri gurepi tutumi buro embo nei tenda piesiri gurepi sima ari emboboda yai maunsisina. Edo awamanemi ganumami kopuruda detero ororo gutesiri awa usibesi edo pietero mede egenembesisina. ");
INSERT INTO bhg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Edo tenda buro embo nei piesiri mambiri awa bé detero besisina; buro embo nenei jiwaebé awa daedo mambero usibesibé dedo, nenei awa detero bebetegesitera. ");
INSERT INTO bhg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ango matawa etero gido gurepi tutu ami ambobé awa ainda mai ao da (1)bé, ami dubobudo eira, awa daedo piesiri maunsisina. Edo engo kotembesisina, ‘Awamanemi nato mai awa tou ara.’ ");
INSERT INTO bhg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ata sima ari embobomi tedo sitera, ‘Gurepi tutu betari butu mainda topo aina! Kaende mai dano betari butu kaenato topo are.’ ");
INSERT INTO bhg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ango tedo mai awa gumbiri kundo detero betesiri ainda tamo budo puwa demonda augetero idegesisina. ");
INSERT INTO bhg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Awatedo, gurepi tutu ami buro ro aini? Nane imondemane tano gawa. Embo ami gundo sima ari embobo awa dedo usibesi edo gurepi buro kundo embo neneinde piaina. ");
INSERT INTO bhg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Imomane God da ge gaiari eiwa ajijigedo gido evita? Awa engo: ‘Dasivi awa imomane oromando ari embomi ajiregesitewa, God mi esiri dasivi davebé dave esira. ");
INSERT INTO bhg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Eiwawa BADARI da wasiri, edo beyamanabé jisi kaenato berarida.’” ");
INSERT INTO bhg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Edo Judah embomainda babadegarimi engo kotembesitera, Yesu mi eniya geda kariwa awamaneda yai budo sira. Awatedo, awamane sinigambari bajinabé edo embo awa budo dain esitera. Ata embomai jiwaebé Yesu da ge dave awa ingido imo ambo ambo edo era. Awa gido adu edo Yesu dodo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Edo Parasi mane ae Herod da buro otatawo de pietero Yesu da yai maunsitera, embo ainda ge sira awa simagain. ");
INSERT INTO bhg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Edo iji angode awamane gundo Yesu de sitera, “Atopatari, nakare gotera, imo gebé berari tedo eta. Imo embobo anumba ikane edo tuda itera awa kotembae. Edo embo neneinda kotembarimi imo gisijiari tao ae, ata imo God da begata dave gebémi atopasido eta. Awatedo, natokare tax ganu Caesar da yai pisido era awa daveta beyaeri? ");
INSERT INTO bhg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ito kotembari awa te goré! Nakare mina piarita ko piainyaeri?” Edo Yesu embomai ami udumbetera ango goteite awamanede sisina, “Nongo ain tedo imomane na bavedogain tevi? Ganu itomane kundo gumbú gane!” ");
INSERT INTO bhg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Edo ganu awa kundo gumbero gido sisina, “Dombubé de dao de eiwa andari?” Awamanemi mina sitera, “Caesar da.” ");
INSERT INTO bhg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Edo Yesu mi ge mina awamanede sisina, “Awatedo, rorae Caesar da topo gido, Caesar de piewo, rorae God da topo gido, God de piewo!” Edo Yesu mi awamaneda bavedogari ge tetera awa dodo ge davemi tesira, awatedo, embomai ami Yesu da ge mina dave sisina awa ingido korebé esitera. ");
INSERT INTO bhg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ango edo Sadusi manemi gebé edo esitera awa, embo betedo tenda erari itae, ango tedo Yesu da yai gundo embo awa bavedogain tedogari pipisitera. ");
INSERT INTO bhg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Atopatari, Moses mi iji matude apiyemane natokarede sisina awa, embo aro jimundo maiunji piae eimango betaina, edo ainda aro rori awa namejimi jimundo mamai piari namejida orobe itarate sisina. ");
INSERT INTO bhg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Edo iji da (1)de awa nanonameji berari ajigari 7 isiretera awa, nameji buwo aro jimundo mamai piae besisina. ");
INSERT INTO bhg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ango esiri buwoda gaganimi nameji buwoda aro rori awa jipusina, ata dá ango mamai piae besisina. Edo tamonde (3) awa dá ango esisina. ");
INSERT INTO bhg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ango edo nanonameji berari ajigari 7, awamane aro da (1) awa jimundo mamai piae bebetegesitera. Ambobéda eutu awa daedo besisina. ");
INSERT INTO bhg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Awara, eutu eiwa iu ibono berari ajigari 7 jipusina. Awatedo, iji amboda embomai betarida erara awa, arobé anda aini?” ");
INSERT INTO bhg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu mi awamanede mina sisina, “Imomane God da ge gaiari edo God da goroba tega gae. Awatedo, ge tae dumbae ewa. ");
INSERT INTO bhg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Eutu awa ibonomai berari ainda aro ainyae, aindabé, betarida tekago erari iji ainde, embo de eutu de iu aro ari tao ae, ata awamane anela dá kariwa ango ara. ");
INSERT INTO bhg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ata nanemi embomai betarida tekago erari ge tano arapa arate ena awa eire. Matu Moses mi ove gagurisina awa ajijigedo gido evita? Ainda ge jirari engo isira. Iji angode Abraham de Isaac de Jacob de bebetegesitera, edo duberi jiwaebé dodo ainda amboda, Moses da ijide abuda ni danegayani ango awa niyao aveiri ainda God mi Moses de ge sisina, ‘Na awa Abraham da God, Isaac da God, edo Jacob da God.’ ");
INSERT INTO bhg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Edo God mi sisina imo awa bebetegarida God, aindabé, awamaneda asisi awa God da yai itera, edo awamaneda tamo tekago erara. Awatedo, imomane ge tae dumbaebé etewa awa, embo betarida tekago erari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Edo Aodarida atopapasigarida embo da (1)mi gundo isite awamane ge baiero simagesisina. Edo embo ami Yesu da mina tari dave awa ingido Yesu de tedogosisina, “God da ge okain berari sisina ainda doda nondawa bajinabé bajinari?” ");
INSERT INTO bhg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu mi embo ainde mina sisina, “God da ge okain bajinabé bajina sisina awa evire: ‘O Israel embomai ingiwo! BADARI kaenato God awa akuta awa BADARI. ");
INSERT INTO bhg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Edo BADARI ito God awa dubobudo eyo do ito berarimi, wasiri ito berarimi, kotembari ito berarimi edo goroba ito berarimi.’ Eiwawa God da ge okain gisibé sisina. ");
INSERT INTO bhg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Edo God da ge okain ango nei awa evire: ‘Nembu ito awa dubobudo eyo dá imo akuta dubobudo eta ango.’ Edo ge okain babain engogo nenei itae.” ");
INSERT INTO bhg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Edo Aodarida atopatarimi Yesu de sisina, “Atopatari, imo gebé berari teteta. Aindabé God awa dakaima. Edo nei demonda itae, ata awa akuta. ");
INSERT INTO bhg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Edo imo daedo gebé berari teteta, imo God dubobudo ata do berarimi, kotembari berarimi, wasiri berarimi, edo goroba berarimi, edo daedo nembu ito dubobudo ata dá imo akuta dubobudo eta ango. God da ge okain tote (2) eiwa babainbé, emi awa ategari rorou dungain, edo kando nenei berari kundo maundo piedo era awa daginegari.” ");
INSERT INTO bhg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iji angode embo ainda dubo ge tesiri ingido Yesu mi ainde sisina “Kotembari ito dave! Awatedo, God gebé eyo! God mi wasiri ito gisijiare.” Ainda amboda embo da aimi bavedogari ge ango awa tae. ");
INSERT INTO bhg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Edo daedo Yesu mi Judah embomainda oro kotopu bajinada God da ge atopapoteite awamanede sisina, “Aodarida atopapasigari mi atopasido era awa ‘Keriso awa David da Mai.’ Edo ro awa embo ge ango tedo eri? ");
INSERT INTO bhg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aindabé, Asisi Kotopu mi David gisijiri ami akuta karigesisina: ‘BADARI mi nato Badari de sisina, “Ipabe natoda anumbedo namonde daedo embomai berari gisijiyo! Ango eiato nane ito gitopo embo ito tai tuda piano imo tou ore.” ’ ");
INSERT INTO bhg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David akuta ami imo awa ainda ‘Badari’ sisina. Awatedo, nongo edo gido imo awa David da Mai ri?” Embo jisi bajina da doregesitera ami ge awa ingido dubodave esitera. ");
INSERT INTO bhg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Edo Yesu embomai atopapoteite sisina, “Aodarida atopapasigarimi imomane udumbara, awatedo, goteite iwo! Awamanemi ombari riribo omundo edo nasi arapada pepeta eiaro embomaimi ategabutega eite tou orote jipapa edo era. ");
INSERT INTO bhg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Edo awamane Judah embomainda benunu oroda torido anumba davebé dave awa jipapa edo era. Daedo embo bondo eiworo maundo besi davebé daveda anumain jipapa edo era. ");
INSERT INTO bhg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Edo awamanemi benunu riribo pitawa tedo era, edo daedo eutu rori udumbedo awamaneda gaiapa bain edo era. Ata katari ijide God mi awamane daginegedo bajinabé kataina.” ");
INSERT INTO bhg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ango edo Yesu Judah embomainda oro kotopu bajinada edo kupo neinda anumbedo isite goteiri, embomaimi God da yai ategari ganu mauwa doda pipisitera. Gaiapade embomai awa ganu tega babain pipisitera. ");
INSERT INTO bhg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Awarata, mapa eutu rori da (1) awa gundo ganu babaingae tote (2) pipisisina. ");
INSERT INTO bhg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Awa gido Yesu mi ambodani dao tesiri ainda yai gumbero sisina, “Embomai nenei owa awamaneda yai nandogo isira awa pipiteite nenei dotera, ata mapa eutu rori owa ainda yai sakabé awa berari itae piesira. Nomi imo rorae budo inaini awa itae. Awara! Edo ge ro boroko imondemane tena, eiwa giwo! Mapa eutu rori emi embomai berari ganu pietera awa daginegesira.” ");
INSERT INTO bhg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iji angode Yesu Judah embomainda oro kotopu bajinada edo idegeteiri ainda ambodani da (1) gundo embo ainde sisina, “Atopatari, gi! Ganuma babainbémi oro dadarigabé eiwa nongo nongo esiteri?” ");
INSERT INTO bhg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Edo Yesu mi ainde mina sisina, “Imo oro dadarigabé eiwa kore eite tesita? Awa gebé teta! Ata oro dadarigabé goteta, ainda ganuma babain berari awa dedo sitedo agaugaro wotara, giyo.” ");
INSERT INTO bhg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ango edo Yesu temundo visido Ni Olive de Peji ainda anumbesisina, Judah embomainda oro kotopu bajina edo ainda kupo neinda. Edo Peter de John de James de edo Andrew de, awamane akuta maundo embo ainde tedogositera, ");
INSERT INTO bhg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nakare te goré! Oro kotopu bajina sitedo durari teteta awa ijibé nonderi? Edo ainda kariwa gisibé ro piari nakare goteiaro buro ango awa idegaini?” ");
INSERT INTO bhg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Edo Yesu mi awamanede tuturo edo ge mina sisina, “Embo neneimi udumbari ge tara, awatedo, imomane akuta goteite iwo! ");
INSERT INTO bhg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aindabé, embo jiwae dao natoda gumbara, edo ge pitawami ‘Na, God da Avigari Embo mi gumena,’ ango tedo embomai jiwae udumbara. ");
INSERT INTO bhg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Awarata, imomane embo duduno eite tera awa ingido itomane do itadaita ainyae. Awa tepo kariwa. Ata iji beao aribé awa gumbae. ");
INSERT INTO bhg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aindabé, nasi neimi erido nasi neinde duduno aina. Edo daotari neimi erido daotari neinde itoro aina. Edo yai neneinda jijira tawaina. Daedo iji angode bejida yoa gumaina, edo buriya bouga neindekainde idegaina. Eiwa tuturo kariwa eutumi mai engari dá memesi budo era ango. ");
INSERT INTO bhg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Awarata, imomane akuta goteite iwo! Aindabé, na gebé edo ewa, awatedo, sinigambari embomi imomane nasida ge babain katari emboboda ipada piara, edo Judah embomainda benunu oro doda imomane vedara. Edo awamanemi imomane kundo maundo gisijijiegari ae daotegeregari deda yai piara. Edo nato bino dave awamanede karigawate jijine tara. ");
INSERT INTO bhg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Edo iji beao aribé gumbae gisida nato bino dave awa yai berarida karigaro embomi ingara. ");
INSERT INTO bhg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Awarata, iji angode itomane gitopo embomi imomane kundo maundo katari emboda yai piaro, jiro buro ainyae, o kotembari jiwae eove ge ro embo ainde tavi! Ata, iji ainde Asisi Kotopu mi itomane yai ge tari gawa. Awatedo, ge awa tewo! Aindabé, inemane akuta ge awa tae, ata Asisi Kotopu mi imomane gisijijieite ge taina. ");
INSERT INTO bhg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Edo namejimi ainda nameji betarida piaina, edo mamomi ainda mai betarida piaina. Daedo mamaimi ge jirido awamaneda aimamo awa gitopo emboda ipada piaro betara. ");
INSERT INTO bhg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Aindabé imomane na gebé edo ewa, embo berarimi imondemane sinigambari ara. Ata embo aimi iji beao aribé ainde tataimbarimi na gebé eite ambo ambo edo eira, God mi embo awa tonemaina.” ");
INSERT INTO bhg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Awarata, iji angode ‘rorae bebegae’ Judah embomainda oro kotopu bajinada torari tao ae awa kundo torido piaro petari embomi rorae awa goteiaro mengari piari gawa. Matu peroveta Daniel mi sisina ango” (Edo imo ge eiwa ajijigeteite, bé kotembeyo!). “Edo awa gido, embomai yai Judea da itera awa matu tumundo pejida visido kaviyegari boré! ");
INSERT INTO bhg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Edo embo aimi ainda garauda anumbedo isite kariwa awa gido, mandoda mana toraina edo ainda roviravi mandoda awa kumainyae. Ainda gitopo embomi daro beteurekae! ");
INSERT INTO bhg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Edo embo aimi ainda buro doda eite kariwa awa gido, buro beda egenembedo dademo ombari mana kumaina. ");
INSERT INTO bhg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ata deguta angogode eutumai watoude ae aimono mamai ami beda itera ainde, awamanemi adu tumundo kaviyegari bari awa okain bé tambara. Awatedo, do ari tena! ");
INSERT INTO bhg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Aindabé, tuturoda God mi utu ae butu de esisina ainda edo gundo iji boroko einde memesi bouga bajinabé ango deguta angogode awa embomai tambae, edo amboda tekago mana tambara, awatedo, God da yai benunu tewo! ‘Nakare dowato wa ijide adu tumundo pejida vitóre.’ ");
INSERT INTO bhg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Edo iji ainde Badari deguta angogo awa kapae dowari idegaina awa, embo da ji aimi tonembari bainyae. Ata ainda embomai ami gerisina awa tonemain awamane embo deguta angogo kapaina. ");
INSERT INTO bhg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Edo iji angode embo da aimi imondemane taina, ‘Evire gi! Ovire gi! Keriso gumbira,’ angogo taro awa gebé eove! ");
INSERT INTO bhg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aindabé, keriso pitawa ae peroveta pitawa kakato de gundo kariwa de wasiri babain neneinde God da piari ango awa piara embomai udumain. Edo embomai God mi gerisina awa daedo udumain ara. ");
INSERT INTO bhg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Awatedo, imomane akuta goteite iwo! Matu nanemi imondemane rorae ro berari idegaina tetena awa, daedo goteite awa udumbari embobo daginegawa. ");
INSERT INTO bhg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ata amboda memesi bouga bajinabéda iji gumaina, deguta angogode, “‘Ijida parara kumboro aina, edo karigada parara datembari dowaina; ");
INSERT INTO bhg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","dabori utuda tokedo durara, edo God mi utuda rorae berari awa jipaina.’ ");
INSERT INTO bhg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ango eiaro, embo butu berarida ami na, Embo da Mai awa, nato goroba de parara de poragada gupeiano gara. ");
INSERT INTO bhg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ango edo nato anelamane piano butu de utu deda umbugo berarida maundo nato gerari embomai sirigedo kundo gundo dada ara. ");
INSERT INTO bhg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Edo eniya ge ni dungada kariwa awa gain edo giwo! Iji angode igi geo edo tokedo eira awa yanda aikae edo eira. ");
INSERT INTO bhg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Imomane daedo iji ainde rorae engogo idegari goteite awa matu nanemi imondemane ge ro teteno gewa awa kotembewo! Nato gumbari iji awa aikaebé esira. ");
INSERT INTO bhg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Awara! Edo ge ro nane imondemane tena, awa giwo! Embomai iji einda itera awa betainyae isiaro, rorae engogo berari awa idegaina. ");
INSERT INTO bhg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Rorae berari utuda edo butuda awa mandedo itae aina. Ata ge nato eiwa mana mandedo itae aina. ");
INSERT INTO bhg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ata embo da aimi nato gumbari deguta nonderi o ora nonderi awa gae. Edo daedo anelamane utuda awa gae. Na, God da Mai, awa gae. Ata God Mamo akuta goteira. ");
INSERT INTO bhg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Aindabé, imomane da aimi iji nonde na egenembedo gumani awa gae, awatedo, imomane akuta jijimbeteite iwo! Edo jitao awainyae! God da yai benunu tewo! ");
INSERT INTO bhg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nato gumbarida kariwa awa engo embo da (1)mi ainda mando dodo yai aikeda mamain eite ainda awara tari ainda buro embobode pipisisina. Edo ainda buro embobode buro avigekavige esisina. Edo ainda manguro sima ari embode sisina, ‘Na tekago gumana. Awa embo, simageteite isiyo!’ ");
INSERT INTO bhg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Aindabé, mandoda badari gumaina iji imomane gae, awatedo, imomane simageteite isiwo! Embo awa turode gumainita, muyae toropudari ta, sipo kokora aorodari ta, ko sipo atedo iji viviteiari gumaini? ");
INSERT INTO bhg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Embo awa burigibé egenembedo gundo imomane jitao aveiawo tambari awa jipapa ae. ");
INSERT INTO bhg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Edo ro nane imondemane tena awa, embomai beraride tena: ‘Simageteite isiwo!’” ");
INSERT INTO bhg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Deguta tote (2) itae ari ainda amboda, God da Darutegari ae Bread Badari Siwo Piaeda Bondo de awa tuturo ara. Edo iji angode pirisi babain ae Aodarida atopapasigari demi nongo edo Yesu udumbedo kundo katari emboda yai piaro daro betaini awa begata kakowa esitera. ");
INSERT INTO bhg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Atako awamanemi akuta sitera, “Embomi wasiri awa gido sinigambari ge bajinabé tedo duduno ara, awatedo, kaende bondo ari ijide ainyae.” ");
INSERT INTO bhg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Edo Yesu Bethany nasida totorisina. Edo imo embo ginimi tutupegari dao Simon da mandoda indari indeite isiri, eutu da (1)mi sigi alebasita ganumami ari ainda un muno davede mina bajinabé piedo bari awa kundo gupusina. Ango edo eutu ami sigi awa dedo pirigedo ainda un berari Yesu da kopuruda dodegesisina. ");
INSERT INTO bhg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Edo eutumi wasiri ango esiri gido embo nenei ainda itera, awamanemi akuta dubodave ae edo ge mina tara esitera, “Ro awa embo eutu omi un muno davede awa jigamo ae dumbae eiri? ");
INSERT INTO bhg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Rorae ane piari embo neimi ganu jiwaebé piedo bari tao. Ango edo ganu awa embomai rorae isisigaede piae esira.” Edo eutu ainde sinigambari ge okain bé sitera. ");
INSERT INTO bhg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ata Yesu mi sisina, “Eutu awa gido teove! Dowo! Ro embo eutu ainde sinigambari ge okain tevi? Eutu awa buro beyamanabé namonde esira. ");
INSERT INTO bhg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aindabé, iji berari embomai rorae isisigae awa imondemane isima edo era. Edo iji nonde imomane awamane kondade ain jipapa edo ango awa. Ata na mana imondemane einda matawa isirano tou awa. ");
INSERT INTO bhg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Eutu eiwa buro ro ami ari tao awa esira. Ami nato tamo un muno davede dodegesira awa nato goiari siya gisi esira. ");
INSERT INTO bhg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Awara! Edo ge ro boroko imondemane tena, eiwa giwo! Butu arapuda embomi bino dave nato awa dengoro baiari pipiteite, eutumi wasiri beyamanabé namonde esira awa, daedo taro embomaimi ainda wasiri awa gido kotembu kotembu ara.” ");
INSERT INTO bhg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ango edo Judas Iscariot, awa Yesu da embobo 12 ainda da (1), ami pirisi babainda yai maundo awamane kondade edo Yesu kundo awamaneda ipada piari borote esisina. ");
INSERT INTO bhg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ango tesiri pirisi babain dubodave edo awamanemi Judas de gano piara ango tarigari sitera. Awatedo, embo ami Yesu kundo awamaneda ipada piain begata kakowa esisina. ");
INSERT INTO bhg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ango edo deguta tuturoda Bread Badari Siwo Piaeda Bondo gupusina. Iji angode daedo Judah embomaimi God da Darutegari Bondoda sipu mai dedo esitera. Awatedo, iji dá ainde Yesu da ambodanimi tedogositera, “Imo yai nonda nanekare maundo imo embo God da Darutegari Bondo siya edo kaen indorote jipapa esi?” ");
INSERT INTO bhg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ango tetero awa Yesu mi ambodani tote (2) pipiteite sisina, “Imomane maundo Jerusalem nasida torawo embo da (1) un sigi gapoda piari ami imomane tamaina. Awa ambo ambo ewo! ");
INSERT INTO bhg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Edo daedo maundo yai nonda toraini awa gido mando tutude tewo! ‘Natokare atopatarimi tesira, “Indari yai nondari tato gido na ae ambodani nato de God da Darutegari Bondo indoré?” ’ ");
INSERT INTO bhg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ango tawo embo ami imomane kundo visido yai bajina engiregari matu sirigari isira awa piari gawa. Yai ainda kaenato indari siya ewo!” ");
INSERT INTO bhg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Awatedo, Yesu da ambodani tote (2) gisi maundo Jerusalem nasida torido ge ro berari sisina ango awa taputera. Edo yai ainda God da Darutegari Bondo siya esitera. ");
INSERT INTO bhg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ango edo iji wotesiri turo damodamo eiri Yesu ae ainda embobo 12 de mandoda guputera. ");
INSERT INTO bhg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Iji ainde awamane berari indari indero Yesu mi sisina, “Awara! Ge ro boroko imondemane tena, eiwa giwo! Imomane da (1) namonde daedo indari indeta, ami na kundo gitopo emboda ipada piata.” ");
INSERT INTO bhg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Edo ge ango tesiri ambodani dubovevera esitera edo awamanemi Yesu da yai tedogari nei tedo douri, nei tedo douri edo esitera, “Amo nari ta?” ");
INSERT INTO bhg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Edo Yesu mi awamanede mina sisina, “Imomane embo 12, ainda da (1) namonde daedo rorae teoda indeira, ami na kundo gitopo emboda ipada piaina. ");
INSERT INTO bhg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gebé, na Embo da Mai awa betana, matu God da ge dá gaguritera ango. Ata do ari embo ainde tena, aimi na Embo da Mai awa kundo gitopo emboda ipada piaina. Awatedo, davebé awa ainda ai mi embo awa dowae engisina.” ");
INSERT INTO bhg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Edo awamane indari indero Yesu mi bread kundo jisi utuda edo God ategedo engegegedo ambodanide pipiteite sisina, “Kundo injiwo. Eiwa nato tamo.” ");
INSERT INTO bhg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ango edo Yesu mi akou awa kundo God da yai ategari pisido ainda ambodanide piesiri awamane berari akou dá ainda embo nei injido pieuri, embo nei injido, ango jiroro esitera. ");
INSERT INTO bhg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Edo Yesu mi ambodanide sisina, “Eiwa nato ororo, ami God da piari tembari okain teka ainda embomainde sirigeteira edo embomai jiwae awa embo rorou piaina. ");
INSERT INTO bhg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Awara! Edo ge ro boroko imondemane tena, eiwa giwo! Na iji nei gurepida gama inainyae isimango, amboda gurepida gama awa inana, God da gisijiari yaida.” ");
INSERT INTO bhg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ango edo awamanemi yami God dasiga edo Jerusalem nasi dodo idegedo Ni Olive de Pejida maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ango edo Yesu mi ambodanide sisina, “God da geda gaiari isira eiwa: ‘Nanemi Wo Sima Ari Embo dano awa, edo ainda wo sipumane evekara ara.’ Awatedo, muyae boroko einde, imomane berari itomane gebé ari nato yai awa dowawo wotaina. ");
INSERT INTO bhg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ata amboda God mi na jiari tekago erido, imomane yai Galili da mambae gisida, na mamana.” ");
INSERT INTO bhg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Edo Peter mi Yesu de sisina, “Edo embo berari awamaneda gebé ari ito yai awa dowaro wotaina, na dá ango ainyae!” ");
INSERT INTO bhg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ango tesiri Yesu mi embo ainde sisina, “Awarata! Ge ro boroko imonde tena, eiwa giyo! Muyae boroko kokora aoro tote (2) tae gisida, iji tamonde (3) imo akuta toreite, ‘Embo awa na gae,’ tata.” ");
INSERT INTO bhg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ata Peter mi ge okain bé tedo dowae esisina, “Na imonde daedo betana. Na mana akuta toreite imo gae tana.” Edo ambodani nenei berarimi ge dá ango sitera. ");
INSERT INTO bhg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Edo Yesu ae ainda ambodani de yai Gesemani ainda maunsitera. Edo embo ami ambodanide sisina, “Imomane einda anumbedo isiwo! Na imango benunu tain ena.” ");
INSERT INTO bhg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ango tedo Yesu, Peter de James de John de awamane budo daedo maunsisina, edo embo ainda do tuturo edo buriya eiri dubo memesi bajinabé ainda yai gupusina. ");
INSERT INTO bhg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Edo Yesu mi awamanede sisina, “Nato dubo memesi bajinabé gupeira ami ubowa nato dari teugari na betanate arago eira. Einda isite simagewo!” ");
INSERT INTO bhg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ango tedo imo saka iaragedo baongo dadari edo kopuru butuda gaiedo God da yaida benunu sisina, “Mamo, imo edo gido memesi iji bajina nato yai gumain eira, eiwa dowato daginegae esirita!” ");
INSERT INTO bhg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Edo imo benunu sisina, “Abba, Mamo, rorae berari imo kena awa ari tao. Memesida akou eiwa dodo kundo eve piae etesita! Awarata, nato jipapa awa ainyae, ata ito jipapa awa ewasi.” ");
INSERT INTO bhg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ango edo imo tekago overegedo gundo ambodani tamonde (3) jitao avero gosisina. Edo awamane audesiri erero Simon Peter de sisina, “Simon, imo jitao aveta? Na kore ena! Imo iji tupo simageteite itari tao ae eta!” ");
INSERT INTO bhg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Edo Yesu mi awamanede sisina, “Simageteite benunu tewo! God mi imomane dowari bawarida durove. Do itomane awa dave, ata tamopisi awa burau eira.” ");
INSERT INTO bhg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ango tedo imo tenda overegedo maundo benunu dá sisina ango tekago sisina. ");
INSERT INTO bhg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Edo Yesu tekago overegedo gundo ambodani tamonde (3) jitao avero tapusina. Awamane jitaomi jisi bouga esisina, awatedo, udedopangedo ae. Edo awamane audesiri eroritera, ata awamane kotembari dave bae esitera, awatedo, Yesu de ge mina tae. ");
INSERT INTO bhg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ango edo Yesu tekago iji tamonde (3) ango maundo benunu siri jiriri overegedo gundo ambodani tamonde (3) jitao avero tapusina. Edo awamanede sisina, “Na kore ena! Imomane matawa jitao aveite itewa. Iji itae esira giwo! Borokobé embaomi na, Embo da Mai awa, gitopo emboda ipada piari mamana. ");
INSERT INTO bhg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Awara, eriwo! Embo na kundo gitopo emboda ipada piaina awa gumbira eire. Kaende imango tamboré!” ");
INSERT INTO bhg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Edo Yesu awamanede ge siri boraebé ae ge ainde Judas, Yesu da embo 12 ainda da (1), ami embobo jisi da awamaneda kasiwo de ami de kumbero awamanededa gupusina. Awamane awa pirisi babain de Aodarida atopapasigari de orobeda kopuru mamai demi Yesu kundo mamborote pietero guputera. ");
INSERT INTO bhg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ango edo embo Yesu kundo betarida piaina, ami awamanede matu tesiri gositera, “Embo nane ategedo opoda munegana, awawa kundo sima dave eite mambuwo!” ");
INSERT INTO bhg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Awarata, iji ainde Judas ae embobo jisi dade yai Gesemani da totorero, Yesu ae ambodani de maundo awamane taputera. Edo Judas boraebé gundo Yesu de sisina, “Atopatari! Atopatari!” ango site opoda munegesisina. ");
INSERT INTO bhg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Edo ango eiri embobo jisi da guputera ainda neneimi Yesu jido dumbero piri buritera. ");
INSERT INTO bhg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ata iji ainde Yesu da ambodani da (1)mi demonda isiri jiriri ainda kasiwo worugedo budo pirisida gisijiari bajinada buro emboda dengoro nei kautugesisina. ");
INSERT INTO bhg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ango edo Yesu mi embobo jisi da guputera ainde sisina, “Imomane na beono embo beyaebé ango baintedo kasiwo de ami de kundo gumbarago etewa. ");
INSERT INTO bhg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ro embo imomane Judah embomainda oro kotopu bajinada na kumbae doturavi? Audo erido na yai ainda embomai atopasido eono gido etewa. Ata wasiri engo nato yai idegaina ango matu God da geda gaguritera awa etewo bé eira.” ");
INSERT INTO bhg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iji ainde ainda ambodani berari Yesu dodo evekara edo adu tuputera. ");
INSERT INTO bhg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ango ero maisinga da (1) gongo virarae awari ami Yesu ambo ambo esisina. Edo iji ainde singabanga nenei embobo jisi da ainda doda ami bain esitera. ");
INSERT INTO bhg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ata maisinga awa ainda gongo virarae awamaneda ipada dodo adu tupusina, tamo tepo. ");
INSERT INTO bhg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ango edo embobo jisi dami Yesu kundo pirisida gisijiari bajinada mandoda maunsitera. Edo awamane maundo torido pirisida gisijiari bajina de pirisi babain berari de orobeda kopuru mamai de Aodarida atopapasigari de doregesitera. ");
INSERT INTO bhg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Edo Peter aikeda Yesu ambo ambo edo maundo pirisida gisijiari bajinada mando arapada totorisina. Ango edo Peter ae yai awa sima ari embobo de anumbedo ni aveite isiri jijirisina. ");
INSERT INTO bhg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Edo mando doda pirisi babain de Sanhedrin berari de, awamane dada edo Yesu mi buriya bajina ro esiri awa gido betarida piain kakowa esitera. Ata ainda beyae da ji tambae. ");
INSERT INTO bhg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Edo embo jiwaebémi Yesu bekumba pitawa esitera, ata awamaneda ge evekara buritera awa ainde inono ae. ");
INSERT INTO bhg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Edo daedo embo nenei gundo Yesu da doda petedo Judah embomainda gisijijiegaride ge pitawa engo sitera, ");
INSERT INTO bhg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nakare embo ami tesiri ingitera awa, ‘Na Judah embomainda oro kotopu bajina emboda ipami ari eiwa dedo sitana. Edo deguta tamonde (3)da doda, na oro kotopu nei, emboda ipami ari tao ae awa, jiano eraina.’” ");
INSERT INTO bhg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ango tedo, awarata daedo, awamaneda ge evekara buritera awa ainde inono ae. ");
INSERT INTO bhg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Iji angode pirisida gisijiari bajinami erido doregarida doda Yesu de tedogosisina, “Embobo imonde bekumba ge tetera awa gotesi? Awamanede ge mina ro tasi?” ");
INSERT INTO bhg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ata Yesu ge mina da ji tae. Tepo dapisina. Ango esiri pirisida gisijiari bajinami embo ainde tekago tedogosisina, “Imo Keriso ri ta, God nanekaremi dasiga edo era ainda Mai ri ta?” ");
INSERT INTO bhg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ango tesiri Yesu mi ge mina sisina, “Na embo teta awara. Edo imomane na, Embo da Mai eiwa, God da ipabeda anumbedo isimango ainda goroba de taogari demi doiaro ikane utuda ango poragade siro edo gupeiano gawa.” ");
INSERT INTO bhg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Edo pirisida gisijiari bajinami Yesu da ge tesiri ingido boraebé sinigambaride ainda ombari tamoda jiri keretero embobo doregari ainde sisina, “Na kaena embo einda jimbo katain ge nenei kakowa ainyae! ");
INSERT INTO bhg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Imomane embo emi God tedojijireira awa gotewa. Imomane ro kotembetevi, buriya esirita ko buriya ae ri?” Edo awamane berarimi sitera, “Embo awa buriya bajinabé esira, awatedo, betarida piara!” ");
INSERT INTO bhg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Edo embo neneimi tuturo edo Yesu kosiwa edo gongomi dombu doiedo ipa umbutu edo doreite tedogositera, “Embo aimi imo doreiri? Imo awa God da peroveta, awatedo nakare teyo goré!” Edo yai awa sima ari embobo daedo ipa do bereya edo Yesu dedo esitera. ");
INSERT INTO bhg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Edo iji ainde Peter matawa kambeda mando arapada isiri pirisida gisijiari bajina ainda buro gagara da (1) gundo daginegain esisina. ");
INSERT INTO bhg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Edo buro gagara ami Peter anumbedo ni aveite isiri gido jisini eite sisina, “Imo awa daedo Yesu, Nasaret embo, ainda otawo.” ");
INSERT INTO bhg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ata Peter imo akuta toreite sisina, “Na embo awa gae! Imo ge ro tesi awa na gain darena.” Ango tedo imo dodo torari beda mambiri, kokora aoro sisina. ");
INSERT INTO bhg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Edo buro gagarami tenda gundo Peter gido, tuturo edo embobo demonda pepetegari itera awamanede sisina, “Embo eiwa embo ounda otawo da (1)!” ");
INSERT INTO bhg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ata Peter mi imo akuta tekago torisina. Ainda amboda borere ae bé embobo demonda pepetegari itera ami Peter de sitera, “Nanekare gebé tera awa, imo awa embo ounda otawo da (1), aindabé imo awa daedo Galili embo. Ito ge bepu awa Galili embo dá ango teta.” ");
INSERT INTO bhg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ata Peter mi tuturo edo sinigambari ge okain sisina, “Na ge pitawa tana awa God mi begá aina. Embo tewa awa na da ji gae!” ");
INSERT INTO bhg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Edo kokora tekago aoro tesiri gido Peter mi Yesu da ge awa kotembesisina, “Kokora aoro tote (2) tae gisida, iji tamonde (3) imo akuta toreite, ‘Embo awa na gae,’ tata.” Edo iji angode Peter ge awa kotembedo, imo dotedo wowoteite ji sisina. ");
INSERT INTO bhg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Edo sipo atesiri boraebé pirisi babain ae orobeda kopuru mamai de edo Aodarida atopapasigari de Sanhedrin berari demi nongo edo Yesu de bekumba ge bajinabé tari awa sirigesitera. Ango edo awamanemi buro embobode tetero Yesu awa asimi ipada bundedo kundo maundo Pilate da yai pipisitera. ");
INSERT INTO bhg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Awatedo, Pilate mi Yesu de tedogari pipisisina, “Imo Judah embomainda Daotari ri ta?” Edo Yesu mi mina sisina, “Imo ro teta awara.” ");
INSERT INTO bhg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ango tesiri pirisi babain mi Yesu de bekumba ge jiwae pitawami sitera Pilate da yai, ata Yesu ge mina da ji tae. ");
INSERT INTO bhg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Edo Pilate tekago sisina, “Imo embobomi ito buriya babain karigetera awa goteta. Imo akuta toreite ge mina teyo!” ");
INSERT INTO bhg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ata tekago Yesu ge mina tae. Tepo dapisina. Awa gido Pilate korebé esisina. ");
INSERT INTO bhg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Edo God da Darutegari Bondo iji ainde, duberi da da Pilate mi Judah embomainda jipapa ambo ambo edo buriya ari embo da (1) awa bundari oroda udegeuri idegedo maundo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iji angode, embo dao Barabbas awa bundari oroda embo neneinde daedo pipisitera, aindabé, awamanemi Rome da gisijiari ajiregedo duduno eite embo nenei deoro bebetegedo esitera, awatedo. ");
INSERT INTO bhg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Edo embo jisi dami aorogatedo tuturo edo benunu sitera, “Gisijiari, nakare bundari oro dá edo eta ango embo da (1) udegato idegedo mambarate jipapa era!” ");
INSERT INTO bhg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Ata, Pilate goteira awa, pirisi babain mi Yesu da buro dave awa gido embo jiwaebé awa ambo ambo edo era, awatedo, jisi okain eite Pilate da yai Yesu pipisitera. Awatedo, awamane ge tae gisida, Pilate mi embomai doregesitera ainde tedogosisina, “Imomane Judah embomainda Daotari awa udegano mambarate jipapa evita?” ");
INSERT INTO bhg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ata pirisi babain mi embomai doregesitera awamane ao gaietero Pilate de sitera, “Ango ae! Nakare inemi Barabbas udegato idegedo mambarate jipapa era. Ata embo Yesu teta awa jipapa ae!” ");
INSERT INTO bhg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ango edo Pilate mi awamanede tekago sisina, “Edo nanemi Barabbas udegano mambari awa Judah embomainda Daotari tedo ewa, ainde nongo anate jipapa evi?” ");
INSERT INTO bhg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ango tesiri awamanemi tekago aorogatedo sitera, “Awa oregada de!” ");
INSERT INTO bhg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Edo ango tetero Pilate mi awamanede sisina, “Ro awa embo? Embo ami buriya bajina da (1) ro esiri?” Ata awamanemi aoro ikanade bé gatetero yai gagapu eiri sitera, “Awa oregada de!” ");
INSERT INTO bhg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Edo Pilate mi embomai doregesitera awamane dubodave orote Barabbas bundari oroda awa awamanede udegesiri idegedo maunsisina. Edo Pilate mi tesiri ainda itoro embobomi Yesu budo vedetero kundo piesiri awamanemi oregada daro betarate kundo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ango edo Pilate da itoro embobomi Yesu kundo maundo Rome da gisijiarida mando bajina (ainda dao nei awa Paraetorium) ainda totoritera. Edo awamaneda itoro embobo nenei (ajijigari 600 ango) awa berari tetero gundo doregesitera. ");
INSERT INTO bhg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Edo awamanemi Yesu tedojirain ombari ribori tokona awa ainda tamoda pipisitera, edo daedo dongo bebedemi engoegedo ainda kopuruda pipisitera. ");
INSERT INTO bhg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ango edo awamanemi tuturo edo Yesu de iwata pitawa edo tedojijireite sitera, “Oro! Oro! Imo awa Judah embomainda Daotari!” ");
INSERT INTO bhg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Edo awamanemi siri budo Yesu kopuruda dedo tamoda kosiwa edo, embo ainda doda baongo dadari edo tumondebain eite iwata pitawa ango tekago tekago edo esitera. ");
INSERT INTO bhg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ango edo Yesu tedojirido itae edo ombari tokona ribori ainde pietero opusina awa jido teugedo embo ainda ombari topobé awa pietero opusina. Edo awamanemi embo awa gisijido oregada dain kundo idegedo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ango edo awamane idegedo mauntero embo dao Simon awa Jerusalem torain tedo begatada ango gundo daginegain esisina. Edo itoro embobomi Yesu da orega amboka arate embo awa jijine sitera. Simon da nasi topo awa Sairin. Edo embo awa Alexander ae Rufus deda mamo. ");
INSERT INTO bhg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Edo itoro embobo Yesu kundo visido Gologata pamoda maunsitera. Gologata da moka awa ‘Kopuru Akou da Yai.’ ");
INSERT INTO bhg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ainda amboda awamanemi waini ae siwo dao myrrh de baige ari Yesu de pipisitera, ata inainyae doturisina. ");
INSERT INTO bhg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ango edo itoro embobomi Yesu oregada dedo jiero erido petesiri ainda ombarijiari awa embo aimi baini ango tetenya esitera. ");
INSERT INTO bhg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sipo tega 9:00 ango eiri awamanemi Yesu oregada doritera. ");
INSERT INTO bhg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Edo bekumba ge kariwa engo gaiedo Yesu da kopuru enoda detero takimbesisina: ");
INSERT INTO bhg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Iji dá ainde Yesu oregada doritera, ae beono embo tote (2)de, embo da (1) awa Yesu da ipabeda edo nei awa ainda ipa andada. ");
INSERT INTO bhg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ango esiri God da geda gaiari awa bé esisina, “Edo jivere embobode daedo embo awa ajigetera.” ");
INSERT INTO bhg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Edo embomaimi begatada gundo daginegeteite pangedo Yesu gido kopuru govegove edo ge beyae embo ainde tedo esitera, “Aan aan! Inemi Judah embomainda oro kotopu bajina dedo sitedo tekago deguta tamonde (3)da doda ain teteta. ");
INSERT INTO bhg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Imo goroba gido oregada edo ito wasiri akuta toregedo dodo wotedo gumbu, nakare goré!” ");
INSERT INTO bhg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Edo dá ango pirisi babain ae Aodarida atopapasigari demi doregedo awamane akuta tedojirari ge mina tara esitera, “Imo embo nenei toregedo esira, ata ainda wasiri akuta toregari tao ae! ");
INSERT INTO bhg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Edo embo awa bé Keriso, Israel embomainda Daotari, gido awa borokobé orega dodo wotedo gumbari kaen jisimi gido embo awa gebé oré.” Edo beono embo tote (2) oregadami bekumba ge dá ango ainde sitera. ");
INSERT INTO bhg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Edo iji visido toropu eiri butu berari awa muyae wotedo apuregesisina. Ango edo isiri gundo iji wareregedo 3:00 turo bureiri parara tenda datembesisina. ");
INSERT INTO bhg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Edo iji tega 3:00 eiri Yesu aoro ikanade bé gatedo sisina, “Eloi, Eloi, lama sabachthani?” (ainda moka awa, “God nato, God nato, ro embo na dodo taigetesi?”). ");
INSERT INTO bhg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Edo embomai nenei demonda petedo itero jijirisina ami Yesu da ge yavi ingitera ata nongo siri awa gain daritera. Edo awamanemi sitera, “Ei giu! Embo owa peroveta Elijah mi gundo kondade arate dao sira.” ");
INSERT INTO bhg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ango edo embo da (1) tumundo maundo waini jigaganide awa gongo jibigi keredo ami tatapu edo unguta riborida kanjigesisina. Edo kundo maundo Yesu mi indarate ainda beda pipiteite sisina, “Dowo! Kaen isite gane! Elijah gundo embo awa oregada kundo piari wotainita.” ");
INSERT INTO bhg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Edo Yesu aoro ikanade gatedo ainda amboda imo besisina. ");
INSERT INTO bhg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Edo iji angode, gongo puruta bajina, bereya edo ribori, Judah embomainda oro kotopu bajina doda awa, toropubéda keredo kupo eve kupo eve esisina, ikane edo wotedo tuda. ");
INSERT INTO bhg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Edo itoroda gisijiari orega do kena petedo isiri Yesu aoro engo gatedo besisina awa gido sisina, “Gebé berari! Embo eiwa God da Mai bé!” ");
INSERT INTO bhg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Edo yai ainda awa eutumai daedo yai aikeda petedo jijimbeteite itera. Awamaneda doda awa Mary, nasi Magadala eutu ae Mary nei, embo saka James ae Joses deda ai de edo Salome de. ");
INSERT INTO bhg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Eutumai eiwamanemi Yesu sima edo esitera, yai Galili ainda. Edo eutumai nenei jiwae yai ainda, awamane daedo Yesu de gundo Jerusalem nasida vivisitera. ");
INSERT INTO bhg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Aindabé, awamaneda Oena Apari Deguta turo 6:00 awa tuturo aina, iji awa Judah embomainda Siya baiya Ari Deguta. Edo turo jijireiri yai damodamo esiri, ");
INSERT INTO bhg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph awa nasi Eremateia embo, Sanhedrin da badari nei, itadaita itae do goroba edo Pilate da yai maundo Yesu da tamo kundo goiain tedogosisina. Edo Joseph daedo imo akuta iji nonde God da gisijiari butuda gumaini awa gain sima edo esisina. ");
INSERT INTO bhg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Iji ainde Pilate mi Yesu da betari bino ingisina awa, imo korebé esisina. Edo Pilate mi itoroda gisijiari dao tesiri gumbiri tedogosisina, “Embo awa bé betesirita?” awa tari gain. ");
INSERT INTO bhg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ango edo itoroda gisijiarimi Pilate de sisina, “Een, gebé! Embo awa bé betesira!” Ango tesiri gido Pilate mi Joseph da yai awara ari pipisisina, Yesu da tamo kundo goiarate. ");
INSERT INTO bhg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Awatedo, Joseph mi gongo virarae davebé awa oriedo Yesu da tamo oregada awa teugedo piesiri wotesiri doisina. Ango edo ainda tamo awa kundo maundo banga to matu siya ari ainda doda torido pipisisina. Edo banga bajina da (1) arapada awa apepegesiri maundo to be awa apuregesisina. ");
INSERT INTO bhg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Edo Mary, nasi Magadala eutu, ae Mary, Joses da ai, demi yai nonda Yesu da tamo piain kundo maunteiri awa jijimbesitera. ");
INSERT INTO bhg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ango edo Oena Apari Deguta itae esiri ainda turobé de Mary, nasi Magadala eutu de Mary nei, James da ai de edo Salome de maundo ni igi muno davede oriesitera, kundo maundo Yesu da tamoda gutain. ");
INSERT INTO bhg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Edo sipo ataebé de Deguta Bajina pura tuturoda awamane banga to beda mauntero iji vivisisina. ");
INSERT INTO bhg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Awamane maunteite begata toropuda ge akuta mina tara esitera, “Embo aimi kaena kondade edo banga apepegaro demonda mambari to be arapa aini?” ");
INSERT INTO bhg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aindabé, banga awa duga badaribé, awatedo, ge ango sitera. Ata awamane maundo jisi piedo banga awa matu apepegari demonda isiri gositera. ");
INSERT INTO bhg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ango edo awamane maundo banga toda totoreite maisinga da (1) gositera. Embo awa ombari ribori pararade umbugo ipabeda anumbedo isiri gido itadaita esitera. ");
INSERT INTO bhg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ata maisinga ami awamanede sisina, “Itadaita eove! Na gotena, imomane Yesu Nasaret Embo oregada dorara awa gain kakowa ewa. Embo awa matu God mi jiri erira. Einda itae! Ainda tamo yai einda pipitara. Giu! ");
INSERT INTO bhg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Awarata, overegedo mambuwo! Ainda ambodani ae Peter de bino awa tawo goré, ‘Yesu yai Galili ainda gisi maunteira. Awatedo, maundo embo awa ainda tambave, ango imondemane matu tesiri gotawa.’” ");
INSERT INTO bhg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Edo ge ango tesiri ingido eutumai awa banga to dodo idegedo tuputera, wasiri nongo nongo esiri gain dareite, do periperi eiri. Edo awamane adu esitera, awatedo, embo neneinde ge ro maisingami tesiri gositera awa da ji tae. ");
INSERT INTO bhg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ango edo Yesu betedo tekago erorisina, ainda amboda, Deguta Bajina pura tuturoda sipode, imo Mary, nasi Magadala eutuda yaida gisi idegesisina. Eutu awa iji gisi Yesu mi bineimane ajigari 7 ainda yai ondesiri idegesitera. ");
INSERT INTO bhg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ami Yesu gido maundo ainda ambodani ae embo eutu neneinde ainda betari awa embo mamato eite ji site itero bino awa karigesisina. ");
INSERT INTO bhg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Edo iji ainde eutu ami Yesu wasiride jisimi gira ango sisina. Ata awamane gebé ae esitera. ");
INSERT INTO bhg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Edo amboda Yesu ainda ambodani tote (2)da yai idegesisina, awa kariwa eve. Embo tote (2) awa nasi bajinada edo idegedo maunteite begata toropuda Yesu taputera. ");
INSERT INTO bhg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ango edo embo tote (2) tekago egenembedo nasi bajinada maunsitera. Edo Yesu da ambodani de embo eutu neneinde ge awa tetero gositera, ata awamane daedo gebé ae esitera. ");
INSERT INTO bhg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Edo amboda, ambodani 11 akuta doregedo indari indero Yesu awamaneda yai idegedo ge okain sisina, “Embo neneimi na gido imondemane tetero gewa awa, God mi na betarida jiri erena. Ata itomane gebé ari nato yai piae edo imomane do okainde! Awatedo, awamane gebé ae etewa.” ");
INSERT INTO bhg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ango edo awamanede sisina, “Mambuwo! Maundo butu arapuda nasida torido idegedo eite nato bino dave awa karigawo embo berari goré. ");
INSERT INTO bhg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Edo embo aimi ainda gebé ari nato yai piedo bapataito ari baina, embo awa God mi toregedo ainda jimbo beyaeda rirowa piari awa dowaina. Ata embo aimi ainda gebé ari nato yai piae aina, embo ainda jimbo beyaeda rirowa awa God mi embo ainde piaina. ");
INSERT INTO bhg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Edo kariwa engogo awa embo na gebé edo era awamaneda yai God mi piaina: bineimane nato daoda ondaro idegara; ge teka yai neneinda ami tara; ");
INSERT INTO bhg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Awamanemi jimbago kaede kumbara edo daedo un kaede indara, ata da ji nei ro ainyae; edo karu embomai ipa tamonda piaro kaviyegara.” ");
INSERT INTO bhg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Awatedo, Badari mi ainda ambodanide ge tedo itae edo, ainda amboda, God mi imo jiri utuda visido maundo God da ipabeda anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Edo awamane idegedo maundo butu umbugo berarida embomainde bino awa karigedo esitera. Edo Badari mi kondade euri kariwa awamaneda yai idegeuri jisimi gido awa God da ge gebé edo esitera. Awara. ");
INSERT INTO bhg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Arie Theophilus, embo jiwaebé awa edo gido wasiri ro matu natokare yaida idegesisina awa ge jirari sirigesitera. ");
INSERT INTO bhg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Awamane wasiri awa gaguritera dá ango embomai tuturoda awa jisimi gido edo namondekare gemi karigetero gositera. ");
INSERT INTO bhg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Awatedo, na kotembetena, dave awa nanemi wasiri ro berarida tuturoda udugedo gositena awa daedo sirigedo ito yai gaiano gatate, dariga nato. ");
INSERT INTO bhg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Edo ove gagurena emi imo kondade ari ro berari matu imo atopapositera awa gebé rita, pitawari awa gata. ");
INSERT INTO bhg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Edo iji angode Herod awa yai Judea da daotari, embo Zacharias awa pirisi maneda sirigari Abijah da embobo doda. Edo Zacharias da aro, dao Elizabeth, awa Aaron da orobeda edo gumbari. ");
INSERT INTO bhg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Edo awamane tote (2) awa wasiri dambu darari God da jisida. Edo Badari da aodari babain de babaingae de berari ambo ambo edo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ata Elizabeth awa eutu ero edo daedo eutu de embo de begogo berari mai bari tao ae, awatedo, awamane mamai itae. ");
INSERT INTO bhg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Edo iji angode pirisi maneda sirigari Abijah da embobo God da yai rorou piari iji gumbiri, Zacharias daedo Judah embomainda oro kotopu bajinada kondade ain maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ango edo awamanemi pirisi mane ewowoda ganuma jipedo dodegedo garida tari isira awa ambo ambo esitera. Edo iji ainde Zacharias avigesitera. Awatedo, embo ami dungari rorae muno davede kundo maundo Badari da oro kotopu bajinada piaintedo totorisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Edo iji angode embomai jiwaebé arapada doregedo benunu tero rorae muno davede ainda dungari ora gupusina. ");
INSERT INTO bhg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ango edo Badari da anela ainda yai gundo tenemba kotopu ipabeda rorae muno davede dungesiri aveira ainda peposisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Edo Zacharias anela gido do buriya eiri ainda yai adu ari gupusina. ");
INSERT INTO bhg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ata anelami ainde sisina, “Zacharias, adu eote! God benunu ito awa matu ingira. Awatedo, aro ito Elizabeth mai jianda baina, edo ainda dao John tata. ");
INSERT INTO bhg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Mai awawa embo bajina aina, Badari da jisida. Awatedo, mai ami ito yai yawa ari edo dubodave ari piaina. Daedo, iji angode mai awa engari gido, embo jiwaebé yawa ara. Edo mai awa waini inainyae, un okain nenei inainyae. Edo daedo, mai awa aida sinida edo idegeteira iji ainde awa, imo Asisi Kotopu mi gisijiaina. ");
INSERT INTO bhg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Edo mai ami Israel mamai jiwae awa tari awamaneda God, Badari da yai overegedo tekago kera ara. ");
INSERT INTO bhg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Edo mai awa Badari gumbae gisida peroveta Elijah da wasiri de goroba deda kariwa dá ango gumaina. Edo ami mamono ae mamain de tari dada doregara. Edo ge jindari embobo tari wareregedo dubo kotembari embo wasiri dambu darari dá ango ara. Edo mai ami Badari da gumbari awa embo, embomai sirigedo dave aina.” ");
INSERT INTO bhg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Edo Zacharias mi anela de ge sisina, “Edo ango gumaina awa nongo edo gani? Na awa embo begogo edo aro natoda duberi daedo awa jiwaebé.” ");
INSERT INTO bhg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ango tesiri anelami ge mina sisina, “Na awa Gabriel. Na God da dombuda petedo isima ena. Ami na ito yai piesiri bino dave eiwa kundo gumena tano gatate. ");
INSERT INTO bhg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Awarata giyo! Nato tarigari pietena awa bé aina, iji dave ainde. Ata imo ge nato awa gebé ae eteta. Awa embo, ito be engiregetena. Ge tainyae, isirato mai bari iji gumbari tekago ge tata.” ");
INSERT INTO bhg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Iji angode embomai iji borerebé sima eite kotembari jiwaebé esitera, “Ro awa embo Zacharias oro kotopu bajina yai kotopu doda iji riboribé isiri?” ");
INSERT INTO bhg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Edo imo idegesisina, iji ainde, awamanede ge tari tao ae. Edo tepo ipami iwata kawata esisina. Ango esiri awamanemi, “Embo awa jisi viviro yai kotopu doda gido ge tae eira,” ango kotembesitera. ");
INSERT INTO bhg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ango edo Zacharias da rorou piari buro beao edo imo Jerusalem dodo ainda mandoda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ainda amboda, ainda aro Elizabeth tuturo edo watou jijirisina. Ango edo ainda mando doda kariga ipa da (5) sima esisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ango edo isite ge sisina, “Boroko Badari mi na do edo kondade esiri nato mengari emboda jisida awa itae esira.” ");
INSERT INTO bhg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Edo Elizabeth da watou awa kariga 6 ainda doda God mi anela Gabriel piesiri gupusina, nasi Nasaret yai Galili doda. ");
INSERT INTO bhg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Edo Gabriel bino kundo gagara dao Mary da yai gupusina. Gagara awa Joseph mi jimbarate geritera. Edo Joseph awa Daotari David da orobe. ");
INSERT INTO bhg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ango edo anela awa Mary da yai gundo sisina, “Ategetena, Badari imo gido dubodave eira! Ami imonde daedo isira, edo ainda ao ari bajinabé eutumai berari daginegedo ito yai piesira.” ");
INSERT INTO bhg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Edo ainda bino kundo gundo tesiri ingido do buriya esiri jiro buro jiwae esisina, “Nongo nongo edo ategari engo namonde pipiteiri?” ");
INSERT INTO bhg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ata anelami sisina, “Mary, God ito yai dubodave eira, awatedo, adu eote. ");
INSERT INTO bhg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Edo imo watou jirido mai engata. Ainda dao Yesu teyo! ");
INSERT INTO bhg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Edo mai eiwawa embo bajina aina. Edo God Ikanebé Ikane ainda Mai tara. Badari God mi ainda apiye David da daotari anumba ainde piaina, ");
INSERT INTO bhg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","edo ami Jacob da orobe natopo gisijiaina. Ainda gisijiarida beao ari itae!” ");
INSERT INTO bhg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ango tesiri Mary mi ge mina anela de sisina, “Amo nongo nongo anate tesi? Na gagara tepo, iu itae.” ");
INSERT INTO bhg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Edo anelami ainde sisina, “Asisi Kotopu ito yai gumaina, edo God Ikanebé Ikaneda gorobami imo datembedo apuregaina. Awa embo, daedo, mai bata awa kotopu, edo God da Mai tara. ");
INSERT INTO bhg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Edo giyo! Ito mato Elizabeth begogo, mai bari tao. Eutu awa ero teora, ata boroko ainda watou awa kariga 6 jirira. ");
INSERT INTO bhg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God da yai buro berari awa ari tao, awatedo, ge berari awa bé aina.” ");
INSERT INTO bhg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Edo Mary mi ainde sisina, “Awara, na Badari da buro ain jipapa ena. Awatedo, ge ro teteta awa doyo nato yai gumbare.” Ango tesiri anela dodo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Iji angode Mary siya edo burigibé yai Judea da nasi peji tetembada jiari ainda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Edo eutu awa maundo Zacharias da mandoda torido Elizabeth ategesisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Iji ainde Elizabeth Mary da ategari ingiri mai saka ainda osi doda yawa eite gubigabi esisina. Edo Asisi Kotopu mi Elizabeth sirido gisijijisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ango esiri imo aoro ikanabé gatedo sisina, “God da ao ari bajinabé eutumai berari daginegedo ito yai piesira. Edo mai engata ainda yai daedo ao ari bajinabé piaina. ");
INSERT INTO bhg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","44","Edo iji boroko einde na ito ategari dengoromi ingeno mai saka nato osi doda yawa eite gubigabi esira. Ata na eutu dave arago ro ain imo Badari natoda ai ami nato yai gumbesi? ");
INSERT INTO bhg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Imo gebé eutata bino ro Badari mi imonde siutara awa bé aina, awatedo, Badari da ao ari ito yai isira.” ");
INSERT INTO bhg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","Edo Mary mi ge engo sisina: “Na awa God da tataimbari buro gagara, edo embo awa na ruvegae. Awatedo, do nato berarimi Badari dasiga ena, edo asisi nato awa yawa bé eira God nato Tonembari Embo da yai. Aindabé, God awa goroba, ami wasiri babain​ ​nato yai esira, edo ainda dao awa kotopu. Awatedo, embomai berari boroko edo amboda gumbara, ami nato yai dubodave ari ge tara. ");
INSERT INTO bhg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Embo ami embo avekave imo tou edo era, iji boroko edo amboda gumbara, awamaneda yai ainda do ari piedo eira. ");
INSERT INTO bhg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Embo ami buro babainbé ainda gorobami edo eira. Edo dariga akuta kotembari embobo awa siteuri atoto edo era. ");
INSERT INTO bhg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Embo ami babadegari babain awamaneda anumbada awa dodo pieuri wotedo era, edo mapa tataimbari embomai awa jiuri erido era. ");
INSERT INTO bhg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Embo ami beji ambubugari embomainde indari davemi undeuri osi edo era, edo rorae embomai awa pieuri ipa tepo maundo era. ");
INSERT INTO bhg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Embo ami ainda tarigari ro kaenato ewowo gawowode sisina awa bé esira, edo ainda buro embobo Israel da orobeda kondade esira. Embo ainda do ari kotembesira, Abraham ae ainda mamai berari deda yai. Edo do ari awa natopo itaina.” ");
INSERT INTO bhg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ango edo Mary kariga tamonde (3) ae Elizabeth de sima edo tekago overegedo ainda nasida maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Awara, Elizabeth da mai bari iji gumbiri imo mai jianda engisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ango esiri ainda nasi aikae embotopo de matomono demi Badari da do ari bajinabé eutu ainda yai piesira awa ingido ae Elizabeth de daedo yawa edo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Edo deguta 8 biri ainda, embomai jiwae guputera, mai saka ainda tamo jiugari awa embo. Edo iji dá ainde mai awa ainda mamo Zacharias awa nombo tain sitera. ");
INSERT INTO bhg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Atako ainda ai mi awamanede sisina, “Ango ainyae! Mai einda dao awa John tara.” ");
INSERT INTO bhg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ango tesiri awamanemi mina sitera, “Orobe itoda dao John awa itae.” ");
INSERT INTO bhg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Edo ainda mamode ipami iwata kawata eite sitera, imo ainda mainda dao ro piain jipapa eiri, awa tarate. ");
INSERT INTO bhg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ango edo Zacharias ove gaiari rorae jipapa esiri pietero, “Mai ainda dao John,” gagurisina. Ango esiri gido embomai berari korebé esitera. ");
INSERT INTO bhg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Edo iji dá ainde God mi Zacharias da be pirigedo iwawa udegesiri ge site God dasiga esisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ango esiri gido embomai demonda berari adu edo do buriya esitera, edo bino awa yai Judea da nasi peji tetembada jiari berari ainda tedo tedo etero arapu esisina. ");
INSERT INTO bhg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Edo embomai berarimi bino awa ingido domi kotembesitera, “Mai eiwa bajido buro ro aini?” Edo Badari da goroba awa ainda yai. ");
INSERT INTO bhg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Edo ainda mamo Zacharias awa Asisi Kotopu mi sirido gisijiri God da ge karigedo sisina: ");
INSERT INTO bhg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Puwavi! Kaende Israel embomainda Badari God dasiga oré. Ami gundo ainda embomainda yai udegari piesira. ");
INSERT INTO bhg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Edo ami Tonembari Embo goroba kaena embo jiri erira, ainda buro embo David da orobeda. ");
INSERT INTO bhg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ami ainda peroveta kokotopude matu tarigari​ ​ango sisina awa. ");
INSERT INTO bhg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","God ainda Tonembari Embo piari gundo kaena gitopo emboda yai awa tonemaina, edo daedo sinigambari emboboda ipada awa​ ​dodo kumaina. ");
INSERT INTO bhg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ami sisina awa, ainda do ari kaenato ewowo gawowoda yai arapa aina, edo ainda piari tembari kotopu isira awa ruvegainyae. ");
INSERT INTO bhg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ami tarigari okain ewowo kaenato Abraham de sisina awa, imo gundo kaena awa gitopo embobo kaenatoda ipada awa dodo kumaina, edo kaena adu itae imo tumondebain ara. ");
INSERT INTO bhg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Awatedo, kaena ainda jisida, kotopu edo wasiri dambu darari ango itara iji berarida. ");
INSERT INTO bhg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Imo gisi maundo Badari da begata dave ato pepeta aina. Imo maundo ainda embomai tato gara awa, God mi ainda kotembedo dowari itae ari awamaneda jimbo bebegaeda yai ami, tonembari awamaneda yai inono piaina. Awatedo mai, imo awa God Ikanebé Ikane ainda peroveta tedo ara. ");
INSERT INTO bhg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God kaenato awa, ainda do ari ami utuda edo Tonembari Embo kaenato yai piari gumaina,​ ​dá iji vitari ango. ");
INSERT INTO bhg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","God mi ari parara awa datemaina,​ ​embomai avekave muyaenda edo betari dugada isima edo era awamaneda yai. Daedo God mi kaena gisijiari bégada begatada pepeta ara.” ");
INSERT INTO bhg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ango edo mai awa babodeite, edo ainda asisi goroba burisina. Edo imo abu damodamoda sima esisina, edo iji gumbiri idegedo Israel embomainda yai buro tuturo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Edo iji ango de, Caesar Augustus mi ge okain sisina, “Rome butu gano nondari ainda embo berari awa ajijigewo! Awamane tax pioré.” ");
INSERT INTO bhg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Gisijiari Quirinius mi yai Siria awa sima eiri, ajijigari eiwa tuturoda idegesisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Edo embo berari dao piaintedo awamaneda nasi ikade ikadeda maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Edo Joseph awa David da orobeda edo gumbari. Edo David da engari nasi awa Beteliem, yai Judea da. Awatedo, imo daedo nasi Nasaret, yai Galili da edo Beteliem da visido maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aindabé Mary awa ami jimbarate gerari, embo awa Mary de daedo dao piain maunsitera. Edo eutu awa watoude mai engari tao. ");
INSERT INTO bhg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ango edo Joseph ae Mary de maundo Beteliem nasida torido itero eutu ainda mai bari iji gupusina. ");
INSERT INTO bhg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Edo dederi oro berari awa ato ae, awatedo, eutu ainda mai buwo engedo gongomi doiedo wo undari betaiya doda pipisisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Edo iji angode wo sima ari embobo nasi ainda demonda awamaneda wo sipumane muyaende simageteite itero jijirisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Edo Badari da anela awamaneda yai idegesiri, Badari da parara yai ainda datembesisina. Ango esiri gido awamane adu bajinabé esitera. ");
INSERT INTO bhg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Edo anelami awamanede sisina, “Adu eove! Na imondemane bino dave kundo gupena, ami embo berarida yai yawa ari bajinabé piaina, giwo! ");
INSERT INTO bhg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Iji boroko einde David da nasida, Tonembari Embo itomane eutumi engesira. Amo Keriso, awa Badari. ");
INSERT INTO bhg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Edo kariwa engo gido nato bino gebé awa: Imomane maundo mai saka gongomi doiari wo undari betaiya doda durari isira awa tambawa.” ");
INSERT INTO bhg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Edo boraebé anelamane jisi bajina da utuda edo anela neinda yai idegedo God dasiga eite sitera, ");
INSERT INTO bhg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God utu ikanebé ikaneda isima eira awa taogoré, edo embomai butuda aimi God da kando ategedo budo era béga awamaneda yai itare!” ");
INSERT INTO bhg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ango edo anelamane dodo egenembedo utuda mambero wo sima ari embobomi akuta mina tara esitera, “Ei pu! Kaende Beteliem da maundo buro eiwa ro idegesiri Badari mi tesiri awa jisimi goré!” ");
INSERT INTO bhg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ango tedo, awamane burigibé tumundo nasida torido Mary ae Joseph de kakowa ero jiriri taputera. Edo mai saka awa wo undari betaiya doda durari isiri gositera. ");
INSERT INTO bhg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Edo mai awa gido awamanemi bino ro anelami awamanede tesiri gera awa kundo idegedo karigetero yai berarida arapu esisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Edo berari aimi bino awa wo sima ari embobomi karigetero ingido korebé esitera. ");
INSERT INTO bhg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ata Mary mi wasiri ro berari idegesira awa ruvegae ainda domi tema edo sirigeteite sima esisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aindabé, bino ro berari anelami awamanede tesira, awa ingera edo jisimi gera, awatedo, wo sima ari embobo overegedo taogari awa tedo dareite God dasiga eite awamaneda yai maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ango edo deguta 8 biri ainda tamo jiugari iji gupusina. Edo ainda dao Yesu sitera. Iji ainde ainda ai Mary watou jirae isiri dao awa matu anelami pipisisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ango edo awamaneda dono teiarida iji Moses da Aodarida tari isira awa gumbiri Joseph ae Mary de Yesu kundo Badari da yai piain Jerusalem maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Edo Badari da Aodarida gaiari ango isira awa, “Mai jianda buwo da da berari awa BADARI da yai piawo ainda buro ara.”) ");
INSERT INTO bhg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Edo daedo awamane Badari da Aodarida tari isira awa ambo ambo edo “Ni ribo tote (2) o ni gumbara mamai tote (2)” kundo rorou piaintedo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ango edo embo dao Simeon awa Jerusalem ainda isinesina. Embo awa wasiri dambu darari edo God tou edo esisina. Ami Israel embomainda Kondade Ari Embo sima esisina. Edo Asisi Kotopu awa ainde daedo isite ");
INSERT INTO bhg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ami ainda yai karigesisina, “Imo betae gisida Badari da Keriso awa jisimi gata.” ");
INSERT INTO bhg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Edo Asisi Kotopu mi Simeon gisijido kundo Judah embomainda oro kotopu bajina doda totorisina. Edo aimamo mai Yesu awa kundo torido guputera, ainde buro ro orote Aodari da tari isira awa ain. ");
INSERT INTO bhg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ango etero Simeon mi mai awa gido tesiri, ai mi piesiri kundo osinembedo God ategedo sisina: ");
INSERT INTO bhg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Badari, ito tarigari siteta awa bé esira. Awatedo, iji boroko ito buro embo awa doyo​ ​bégade mambare. ");
INSERT INTO bhg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nato jisimi tonembari ito gena, ");
INSERT INTO bhg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","awa inemi sirigedo pieteta embomai berarida jisida. ");
INSERT INTO bhg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Embo inemi pieteto gumbira, ami Judah embomai ae, awamaneda yai gundo, atopatari ito gebé awa gara. Aindabé, God da Avigari Embo awa​ ​Israel orobeda edo gumbira, awatedo, embomaimi Judah embomainda dao awa daedo dasiga ara.” ");
INSERT INTO bhg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Edo Joseph ae mainda ai de mi ge ro berari Simeon mi mai ainda daoda tesiri ingido korebé esitera. ");
INSERT INTO bhg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ango edo Simeon awamane embo God ategedo ainda ai, Mary de, sisina, “Imo giyo! Mai eiwa God mi matu siya esisina. Israel embomai jiwae tonemaina, edo nenei jiwae awa dedo sitaina. Edo mai eiwa God da kariwa. Embo jiwaebémi sinigambari edo awa ajiregara. ");
INSERT INTO bhg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Awatedo, awamaneda kotembari onjigarida awa mai ami arapada piari idegaina. Edo daedo do itoda memesi awa kasiwo be tote (2) vegarimi imo gomoda gaiari ango aina. ");
INSERT INTO bhg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Edo iji angode, peroveta eutu dao Anna awa Phanuel da gagara edo ewowo Asher da orobe. Eutu awa begogobé. Imo gagara teka iu jimundo duberi 7 itae esiri ainda iu betesiri rori isite duberi 84 doturisina. Edo eutu emi Judah embomainda oro kotopu bajina dowae sipode turode veta eite benunu site God tumondebain edo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Edo iji dá ainde, eutu awa gundo torido Badari da yai ategari pisido, edo embomai avekave berari Jerusalem da tonembari gain sima eite isiretera awa itero mai ainda ge awa karigesisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ango edo Mary ae Joseph de buro ro berari Badari da Aodarida orote tari isira awa itae edo, tekago egenembedo awamaneda nasi topo Nasaret yai Galili doda maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Edo mai awa bajido tamo de asisi de goroba burisina, edo dubogarimi beda esisina. Daedo God da ao ari awa mai ainda yai. ");
INSERT INTO bhg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Edo duberi berari Yesu da aimamo Jerusalem maundo esitera, God da Darutegari Bondo da. ");
INSERT INTO bhg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Edo iji angode Yesu duberi 12 esiri, awamane Jerusalem visido maunsitera, Judah embomainda bondo orote matu tari isira angoda. ");
INSERT INTO bhg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Edo bondo itae esiri awamane nasida egenembetero mai Yesu awa Jerusalem isiri doturitera. Ata Joseph ae ainda ai demi mai nongo eiri awa gae maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ata awamanemi “Yesu awa embomai neneinde siro edo mambari” ango kotembesitera. Iji dá ainde mauntero turo jiriri mai awa kakowa esitera awamaneda matomono de otatawo deda yai. ");
INSERT INTO bhg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Edo awamane mai tambae, awatedo, overegedo kakowa eite Jerusalem da tekago maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ango edo iji tamonde (3) itae esiri awamane Judah embomainda oro kotopu bajinada torido do arapada mai awa taputera. Atopapasigarida doregari doda anumbedo isite ge teoro mina tedo eite isiri jisimi gositera. ");
INSERT INTO bhg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Edo embomai avekave berari ainda itera ami Yesu da jirogari edo mina tari dave awa gido korebakore esitera. ");
INSERT INTO bhg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ango edo, aimamo mai awa gido korebé esitera. Edo ai mi sisina, “Mai nato, wasiri engo awa nongaintedo natokare yai etesi? Giyo! Na ae mamo de do memeside imo kakowa ero jirira.” ");
INSERT INTO bhg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Edo Yesu mi awamanede ge mina sisina, “Ro awa embo na kakowa ewo jiriri? Na Mamo natoda oro doda itena awa imomane gaera?” ");
INSERT INTO bhg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ata mai ami ge ro siri awa awamaneda yai bé arapa ae esisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ango edo imo ae aimamo deda wotedo Nasaret maunsitera, ainda aimamo kera edo esisina. Awarata, ainda ai wasiri ro berari idegesira awa ruvegae ainda doda piedo sima esisina. ");
INSERT INTO bhg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Edo Yesu dubogari de tamo de inono babojisina, edo ainda dave ari God ae embomai deda yai daedo. ");
INSERT INTO bhg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Awara, iji angode Tiberius Caesar mi Rome da embomai gisijijieite duberi 15 daginegesiri, Gisijiari Pontius Pilate awa yai Judea sima edo esisina, edo Herod awa yai Galili da daotari. Edo iji dá angode ainda nameji Philip awa yai Ituria de Tarakonaisis deda daotari, edo Lysanias awa yai Abilene da daotari. ");
INSERT INTO bhg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Edo Annas ae Caiaphas de awa pirisida gisijiari bajinada dero sima edo esitera. Iji angode, God da ge Zacharias da mai John da yai gupusina abu damodamoda. ");
INSERT INTO bhg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ango edo, embo awa idegedo nasi berari un Jodani bengida jiari ainda jiruru eite dengoro baiari pipiteite embomainde tedo esisina, “Itomane jimbo bebegae dodo God da yai wareregedo gumbuwo, bapataito ane! Ango awo God mi itomane jimbo bebegae kotembedo doware!” ");
INSERT INTO bhg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Awa engo matu peroveta Isaiah mi gagurisina: “Embo abu damodamoda aorogateira, ‘BADARI da begata dave ewo pepeta are. ");
INSERT INTO bhg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","God mi yai agata igata berari butu piari visido inono aina, edo peji pamopimo berari kapari wotedo bereya aina. God mi begata ogegembari awa kapari dambu daraina, edo kokoturo awa daedo butu piari visido ududugaina. ");
INSERT INTO bhg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Edo embomai yai berarida ami God da tonembari jisimi gara.’” ");
INSERT INTO bhg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ango edo embomai jisijisi, John mi bapataito arate idegedo ainda yai gupero, awamanede sisina, “Embo imomane garibé awa tena, jitoma ingege! God mi rirowa piain siya eira awa, nane imomane bapataito ano awa daginegawa ango kotembetewa? ");
INSERT INTO bhg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Imomane bapataito anate jipapa edo gido, itomane be dave awa piewo gane. Edo ami awa imomane do wareregetewa ango goteiano gumbave. Edo imomane akuta ge mina tara engo eove, ‘Abraham awa mamo natokare, awatedo, God natokare yai rirowa piainyae.’ Nane imondemane tena awa, God mi ganuma itera eiwa inono tari wasiri budo Abraham da maiunji teteka ara. ");
INSERT INTO bhg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Edo iji borokobé emi, God embomai ainkain jimbo bebegaeda dodo wareregae era awamaneda yai rirowa piaina. Awa engo, embo otomi ni be dave ekae era berari awa tutuda tai kapari durudo mumuya aro kundo niyaoda augaina.” ");
INSERT INTO bhg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Edo ango tesiri embomai ami John de tedogositera, “Awatedo, nakare nongo ari?” ");
INSERT INTO bhg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Edo awamanede mina sisina, “Imo aimi ombari tote (2) isira gido awa, embo nei ombari itae ainde da (1) pieyo! Edo imo aimi indari isira gido awa, dá ango embo nei indari itaede pieyo!” ");
INSERT INTO bhg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Iji angode tax kumbari embobo, awamane daedo John mi bapataito arate guputera, ami tedogositera, “Atopatari, nakare nongo ari?” ");
INSERT INTO bhg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Edo John mi awamanede sisina, “Imomane tega nonda bawate aodarida tari isira, ainda akuta buwo, ata daginegeove!” ");
INSERT INTO bhg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Edo daedo itoro embobomi John de tedogositera, “Edo nanekaremi awa nongo ari?” Embo ami awamanede sisina, “Embomainda ganu bain engega eove ko bekumba ge pitawa embomainde teove! Edo itomane buro edo ewa ainda tau awa dubodavede buwo!” ");
INSERT INTO bhg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Iji angode embomai awa bé gain eite edo awamane berari do mi, “John awa Keriso rita?” ango kotembesitera. ");
INSERT INTO bhg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Awa embo, John mi embomai berari ainde sisina, “Na imomane un mi bapataito ena. Ata embo nato amboda gumaina awa na ango ae. Embo awa bajina edo na dave ae. Nane ainda tai woru teugari tao ae. Ami imomane Asisi Kotopu ae niyao demi bapataito aina. ");
INSERT INTO bhg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Embo awa dagi bajina ainda ipami jido kundo gumaina. Ami vedari wheat be buya edo wotari jimundo kundo ainda beurida piaina, ata oen berari jimundo augari niyao matawa aveite isira ainda awaina. ");
INSERT INTO bhg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Edo John mi begata jiwaebéda gemi embomai kondade eite God da bino dave awamaneda yai dengoro baiari piedo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ata ainda amboda John mi Daotari Herod de ge okain sisina, aindabé, embo awa ainda namejida aro ipuda jipusina edo wasiri bebegae nenei esisina. ");
INSERT INTO bhg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Edo daedo Herod wasiri beyaebé awa ami tesiri John bundari oroda pipisitera. ");
INSERT INTO bhg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ango edo John embo berari bapataito eiri, Yesu daedo gumbiri bapataito esisina. Edo Yesu God de ge siri utu pirigesisina. ");
INSERT INTO bhg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Edo Asisi Kotopu kariwa ni ribo ango ainda yai wotesiri ge yavi utuda edo gundo sisina, “Imo awa nato dubobari Mai. Nato dubodave ari bé ito yai.” ");
INSERT INTO bhg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ango edo Yesu imo akuta awa duberi 30 ango esiri, ainda buro tuturo esisina. Edo embo awa Joseph da mai, embomi ango kotembesitera. Edo Joseph awa Heli da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","edo Heli awa Matthat da mai, edo Matthat awa Levi da mai, edo Levi awa Melchi da mai, edo Melchi awa Janna da mai, edo Janna awa Joseph da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","edo Joseph awa Mattathiah da mai, edo Mattathiah awa Amos da mai, edo Amos awa Nahum da mai, edo Nahum awa Esli da mai, edo Esli awa Naggai da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","edo Naggai awa Maath da mai, edo Maath awa Mattathiah da mai, edo Mattathiah awa Semei da mai, edo Semei awa Joseph da mai, edo Joseph awa Judah da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","edo Judah awa Joannas da mai, edo Joannas awa Rhesa da mai, edo Rhesa awa Zerubbabel da mai, edo Zerubbabel awa Shealtiel da mai, edo Shealtiel awa Neri da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","edo Neri awa Melchi da mai, edo Melchi awa Addi da mai, edo Addi awa Cosam da mai, edo Cosam awa Elmodam da mai, edo Elmodam awa Er da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","edo Er awa Jose da mai, edo Jose awa Eliezer da mai, edo Eliezer awa Jorim da mai, edo Jorim awa Matthat da mai, edo Matthat awa Levi da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","edo Levi awa Simeon da mai, edo Simeon awa Judah da mai, edo Judah awa Joseph da mai, edo Joseph awa Jonan da mai, edo Jonan awa Eliakim da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","edo Eliakim awa Melea da mai, edo Melea awa Menan da mai, edo Menan awa Mattathah da mai, edo Mattathah awa Nathan da mai, edo Nathan awa David da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","edo David awa Jesse da mai, edo Jesse awa Obed da mai, edo Obed awa Boaz da mai, edo Boaz awa Salmon da mai, edo Salmon awa Nahshon da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","edo Nahshon awa Amminadab da mai, edo Amminadab awa Ram da mai, edo Ram awa Joram da mai, edo Joram awa Hezron da mai, edo Hezron awa Perez da mai, edo Perez awa Judah da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","edo Judah awa Jacob da mai, edo Jacob awa Isaac da mai, edo Isaac awa Abraham da mai, edo Abraham awa Terah da mai, edo Terah awa Nahor da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","edo Nahor awa Serug da mai, edo Serug awa Reu da mai, edo Reu awa Peleg da mai, edo Peleg awa Eber da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","edo Eber awa Shelah da mai, edo Shelah awa Cainan da mai, edo Cainan awa Arphaxad da mai, edo Arphaxad awa Shem da mai, edo Shem awa Noah da mai, edo Noah awa Lamech da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","edo Lamech awa Methuselah da mai, edo Methuselah awa Enoch da mai, edo Enoch awa Jared da mai, edo Jared awa Mahalalel da mai, edo Mahalalel awa Cainan da mai, ");
INSERT INTO bhg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","edo Cainan awa Enosh da mai, edo Enosh awa Seth da mai, edo Seth awa Adam da mai, edo Adam awa God da mai. ");
INSERT INTO bhg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ango edo Yesu, Asisi Kotopu mi sirido beda esisina. Edo Yesu Jodani unda awa egenembedo bengida visiri, Asisi mi gisijido kundo maundo abu damodamoda totorisina. ");
INSERT INTO bhg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Edo ainda deguta 40 isiri Binei mi Yesu bavedo esisina. Iji angode awa imo indari indae, iji awa itae esiri, ainda amboda imo beji mina burisina. ");
INSERT INTO bhg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ango esiri Binei mi embo ainde sisina, “Imo God da Mai rita? Ge tewasi ganuma eiwa bread ari indate!” ");
INSERT INTO bhg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ata Yesu mi ainde sisina, “God da geda gaiari isira awa, ‘Embo enembomi bread akuta injido wasiribé bari tao ae, ata God da ge tari da da berari isira, ami wasiribé piedo eira.’” ");
INSERT INTO bhg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ango edo Binei mi embo awa gisi edo kundo visido peji ikaneda esisina. Edo yai berari embobomi gisijido era awa piesiri gosisina, awa jisi papariko arago. ");
INSERT INTO bhg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Edo Binei mi Yesu de sisina, “God mi yai berari ainda awara tari de taogari de awa namonde pipisisina, awatedo, imonde piana. Edo nanemi embo da ave jipapa edo avigetena, ainde piana. ");
INSERT INTO bhg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Awa embo, imo baongo dadari edo na tumondebain ata gido, berari eiwa imo topo aina.” ");
INSERT INTO bhg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ango tesiri Yesu mi ge mina sisina, “Nato gunda mambu, Satan! God da geda gaiari isira awa, ‘Imo BADARI ito God awa tumondebain edo eyo, edo embo awa akuta kera edo eyo!’” ");
INSERT INTO bhg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ango edo Binei mi Yesu gisijido kundo maundo Jerusalem da esisina. Ainda Judah embomainda oro kotopu bajinada eno ikanebé ikaneda piedo sisina, “Imo God da Mai rita? Einda kekapunya edo wote! ");
INSERT INTO bhg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Aindabé, God da geda gaiari isira awa: ‘God mi ge okain tari anelamanemi imo dedegara, nei ro ainyae. ");
INSERT INTO bhg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Edo awamanemi imo ipada jiaro vitata, ganumada ito tai dainyae.’” ");
INSERT INTO bhg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ango tesiri Yesu mi sisina, “God da geda gaiari isira awa, ‘Imo BADARI ito God bawote dowasi!’” ");
INSERT INTO bhg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Edo Binei bawari berari awa itae edo, ainda amboda, imo iji dave nei gido tekago gumaina ango kotembedo, Yesu dodo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ango edo Yesu tenda egenembedo yai Galili da, Asisi da gorobade maunsisina. Edo ainda bino yai ainda edo nasi demonda jiari awa berari arapu esisina. ");
INSERT INTO bhg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Edo imo Judah embomainda benunu oroda atopapoteiuri embo jiwaebé gido awa dasiga edo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Edo Yesu, Nasaret nasi imo isite babojisina, ainda gupusina. Edo wasiri matawa edo eira ango, Judah embomainda benunu oro ainda Oena Apari Degutade maundo totorisina, edo imo ove ajigaintedo erorisina. ");
INSERT INTO bhg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Edo peroveta Isaiah da ove gaiari awa embomi ainde pietero kupusina. Edo awa paraugedo ge gaiari eiwa tapusina: ");
INSERT INTO bhg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“BADARI na avigesira, mapa embomai rorae isisigaede, God da bino dave karigano gorote, awatedo, ainda Asisi nato yai isira. Ami na piesiri gumena, embomai avekave do buriya esiri itera, awamane gao ano dubodave borote, edo embomai bundarida awa ge karigano gido udegari borote, edo jisiguba ari awamane ano yai berari gorote, edo embo nenei gisijijiegarimi memesi bajinabé​ ​pisido era awa, nanemi ano udegari borote; ");
INSERT INTO bhg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","edo nanemi BADARI da tonembari duberi borokobé gumbira awa, karigano gorote.” ");
INSERT INTO bhg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ango edo ove gaiari awa ruvedo tekago buro embode piedo imo dodo anumbesisina. Edo embomai berari benunu oro doda ami ge tari gain jisini esitera. ");
INSERT INTO bhg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Edo Yesu awamanede ge tari tuturo esisina, “Iji boroko bé emi God da ge gaiari ajigeteno ingewa, awa bé eira.” ");
INSERT INTO bhg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Edo awamane berari Yesu da ge gavi ainda beda idegeteira awa gido mina tara eite korebé esitera. Edo awamanemi sitera, “Eiwa tepo Joseph da mai, ata nongo edo ge engo siri?” ");
INSERT INTO bhg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ango tetero gido Yesu mi sisina, “Na gotena, inemane eniya ge eiwa namonde tawa, ‘Siwo Gao Ari Embo, imo akuta gao ewasi! Buro babain ro Kapenium nasida eteto bino ingera dá ango ito nasi topobé einda daedo ewasi gore!’” ");
INSERT INTO bhg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Edo ami tedo sisina, “Awara! Ge ro boroko imondemane tena, eiwa giwo! Peroveta awa ainda nasi topobéda embomi imo tou ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ata ge arapada imondemane tena, eiwa giwo! Eutu rori jiwae Israel doda isiretera peroveta Elijah da ijide. Iji angode God mi utu engiregesiri, duberi tamonde (3) edo kariga 6 wa wotae, beji iji bajinabé Israel yai berarida arapu esisina. ");
INSERT INTO bhg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Awarata, iji angode God mi Elijah awa embo berarida yai piae, ata eutu rorida nasi saka Zerepasi da isima eira ainda yai pipisisina. Zerepasi awa Saidoni nasi aikae edo daedo eutu awa Judah eutu ae. ");
INSERT INTO bhg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Edo embo jiwae ginimi tutupegari Israel doda isiretera, peroveta Elisha da ijide. Awarata, Elisha awamane berari gao ae. Ata da bé Siria embo Naaman, awa akuta gao esiri kaviyegesisina. Daedo embo awa Judah embo ae.” ");
INSERT INTO bhg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ango tesiri gido embomai berari benunu oroda sinigambaribé Yesu da yai esitera. ");
INSERT INTO bhg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Edo awamane erido Yesu dumundo kundo nasi arapada idegesitera. Ainda edo awamanemi embo awa gisijido nasi pamoda jiari isira ainda visido daninida maunsitera, augaro dedewada wotarate. ");
INSERT INTO bhg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ata embo awa doiedo kundo mauntero awamaneda toropuda dodo taigedo eve maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ango edo Yesu Kapenium nasi bajinada wotedo maunsisina, yai Galili doda. Edo Oena Apari Degutade awamane atopaposisina. ");
INSERT INTO bhg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Embo ainda geda awara tari isira, awatedo, embomaimi ainda atopatari gido korebé esitera. ");
INSERT INTO bhg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Iji angode awa benunu oro doda embo da (1), asisi beyae doda itari, ami aoro ikanade gatedo sisina, ");
INSERT INTO bhg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Eei! Imo namondekare ro ain esi, Yesu Nasaret Embo? Imo nakare dedo sitain gumbesita? Na gotena, imo awa God da Embo Kotopu!” ");
INSERT INTO bhg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ata Yesu mi ge okain ainde sisina, “Ge do! Idegedo mambu!” Edo bineimi embo awa embomainda doda augesiri duriri dodo idegesisina, ainde kambo piae. ");
INSERT INTO bhg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Idegesiri gido awamane berarimi kore bajina edo mina tara eite sitera, “Ge eiwa tena! Embo emi ainda awara tari de goroba demi ge okain asisi bebegaede siri kera edo idegedo mauntera!” ");
INSERT INTO bhg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Edo embomaimi Yesu buro ro esira ainda bino awa kundo maundo nasi nenei demonda itera berari ainda karigetero arapu esisina. ");
INSERT INTO bhg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ango edo imo erido benunu oroda awa idegedo maundo Simon da mandoda totorisina. Edo Simon da imbosi karu dademo bajinabé bureite isiri awamanemi Yesu mi eutu awa kondade arate tetero gosisina. ");
INSERT INTO bhg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Awatedo, imo maundo ainda besi demonda petedo karu dademode ge okain tesiri karu itae esiri eutu awa boraebé erido awamane sima esisina. ");
INSERT INTO bhg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Edo iji wowoteiri turo ainde embomai berari aimi awamaneda otatawo karu neindekainde bari awa Yesu da yai kundo guputera. Etero gido karu embomai da da berari awa ami ipa tamonda pipiteite gao euri kaviyegedo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Edo daedo Yesu mi binei embomai jiwaeda doda itera, awamanede ge okain teuri dodo idegeteite aorogatedo tedo esitera, “Imo awa Keriso, God da Mai bé!” Edo awamane matu gositera imo awa Keriso, awatedo Yesu mi dowae binei embo ainde ge tae. ");
INSERT INTO bhg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ango edo sipo taragae isiri imo erido idegedo yai damodamoda maunsisina. Esiri gido embomai jiwaebémi imo kakowa ero jiriri taputera. Edo awamanemi imo yai neinda mamburekae engiregari ge tedo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ata Yesu mi awamanede sisina, “Na bino dave awa embomai nasi neneinda daedo karigano gara awa, God mi gundo embomai berari butuda gisijiaina. Aindabé, God mi na buro awa anate piesiri gumena awatedo.” ");
INSERT INTO bhg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Edo imo Judah embomainda benunu oro neneinda maundo dengoro baiari piedo esisina, yai Galili doda. ");
INSERT INTO bhg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ango edo iji da (1) Yesu Genesaret Ubutu bengida petedo isiri embo jisi da God da ge tari ingain mina mita eite gundo imo doitera. ");
INSERT INTO bhg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ango etero gido Yesu jisi piedo ma tote (2) papoda itero gosisina, ata wo iro ari embobo awa ma dodo awamaneda monga teieite itera. ");
INSERT INTO bhg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Edo Yesu Simon da mada visido, embo ami ainda ma gaigari sakabé kena idegarate tedogosisina. Ango esiri imo anumbedo embo jisijisi awa atopaposisina. ");
INSERT INTO bhg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Edo imo ge tedo itae edo awa Simon de sisina, “Ma daveyo un ugonubéda idegari monga itomane nenei dowawo wotari wo barave.” ");
INSERT INTO bhg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ango tesiri Simon mi mina sisina, “Badarari, nakare buro okain muyae borerebé ero jirira, ainda wo da ji bae. Atako, inemi ge ango teta, awatedo, na monga da (1) dowano wotaina.” ");
INSERT INTO bhg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ango tedo monga dotero wotedo wo jiwaebé ekesiri, awamaneda monga tuturo edo denjisina. ");
INSERT INTO bhg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ango esiri gido buro otatawo ma neinda awa gundo kondade orote, ipami wagaiya doritera. Ango edo gundo kondade edo ma tote (2)da wo sirero beda edo, aikae kununumbari tao esisina. ");
INSERT INTO bhg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Edo Simon Peter wasiri awa gido Yesu da doda baongo dadari edo sisina, “Badari, eve mambu! Na jimbo beyae embo.” ");
INSERT INTO bhg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ango sisina aindabé, embo awa ae embo nenei berari aindeda wo buritera awa gido korebakore esitera. ");
INSERT INTO bhg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Edo James ae John de, Zebedee da mamai, mina bari dá ango buritera. Awamane awa Simon da buro otatawo. Edo Yesu mi Simon de sisina, “Adu eote! Imo boroko tuturo edo embomai budo ata.” ");
INSERT INTO bhg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ango tesiri awamane ma tote (2) papoda dumbero visiri, rorae berari ainda dodo imo ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ango edo iji da (1) Yesu maundo nasi bajina da (1) ainda isiri embo ginimi tutupegari ami gido gundo doda durudo kondade arate tedogosisina, “Badari, imo jipapa edo gido, na eyo kaviyegane!” ");
INSERT INTO bhg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ango tesiri Yesu ipa ududugedo embo awa tujijieite sisina, “Een, na jipapa ena. Kaviyege!” Boraebé, embo ainda gini itae esiri kaviyegesisina. ");
INSERT INTO bhg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Edo Yesu mi embo ainde ge okain bé sisina, “Embo neneinde imo eteno kaviyegeteta awa teote! Ata, pirisida yai mambuyo, imo udugedo gare. Edo kaviyegeteta ango tari gido, embo berari goteiaro, ategari rorou piate, da Moses mi Aodarida sisina ango.” ");
INSERT INTO bhg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Awarata, Yesu mi karu embo esiri kaviyegesira ainda bino awa yairi toiri esiri gido embo jisijisi gundo dada esitera, ainda ge ingain edo awamane karude awa ami gao ari kaviyegain. ");
INSERT INTO bhg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ata imo akuta iji jiwae idegedo yai damodamoda maundo God da yai benunu tedo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ango edo deguta da (1)de Yesu mi embomai atopapoteiri Parasi mane ae Aodarida atopapasigari de yai ainda daedo anumbesitera. Edo awamane Galili da edo Judea da ainda nasi berarida, edo Jerusalem daedo, idegedo guputera. Edo Badari mi Yesu da yai ainda goroba matu pipisisina, awatedo, iji ainde karu embomai awa gao ari tao. ");
INSERT INTO bhg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Awara giyo, embomai neneimi embo ipatai ambari besida durari awa bundedo Yesu da yai kundo torain begata kakowa esitera. ");
INSERT INTO bhg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Edo embomai jiwaebé doregesitera, edo embo awa kundo torari tao ae. Awatedo, embo awa kundo mando tada visido sitoro awa teugedo besida durari isiri dambu darari toropuda pietero wowosisina, Yesu da doda. ");
INSERT INTO bhg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Edo awamaneda gebé ari goteite Yesu mi ainde sisina, “Otawo, jimbo ito kotembedo doteno itae esira.” ");
INSERT INTO bhg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Edo Aodarida atopapasigari ae Parasi mane demi awamane akuta tedogari mina tara esitera, “Embo eiwa aimi ge engo siri? God da dao tedojijireira. God imo akuta awa emboda jimbo kotembedo dowari itae aride!” ");
INSERT INTO bhg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ata Yesu embomai ainda kotembari gido awamanede sisina, “Nongaintedo do itomaneda kotembari ango evi? ");
INSERT INTO bhg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Embo einde, ‘Jimbo ito kotembedo doteno itae esira!’ tari awa gadaerita, ko ‘Erido ainto e!’ tari ri? ");
INSERT INTO bhg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nane itomane yai ano arapa ari gain eiwa, Embo da Mai da awara tari butu einda isira, embomainda jimbo kotembedo dowari itae aina.” Ango site embo ipatai ambaride sisina, “Nane imonde tena, Eri! Besi ito ji erari kundo mando itoda mambate.” ");
INSERT INTO bhg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Edo embo awa burigibé embomainda doda erido besi imo durari isira awa, akuta jiri eriri kundo dodo ainda mandoda God dasiga eite maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ango esiri awamane berari korebakore edo God dasiga esitera. Edo do adu ari bajinabé gumbiri awamane akuta mina tara esitera, “Wasiri babain engo awa boroko idegesiri kaende gotera!” ");
INSERT INTO bhg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Edo ainda amboda, Yesu idegedo maundo tax kumbari embo dao Levi, ainda buro oro doda anumbedo isiri gosisina. Edo ainde sisina, “Na ambo ambo e!” ");
INSERT INTO bhg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Edo Levi rorae berari dodo erido Yesu ambo ambo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ango edo Levi mi bondo bajina ainda mandoda Yesu awa embo siya esisina. Edo tax kumbari embobo jiwaebé edo embo neneinde daedo bondo inain anumbesitera. ");
INSERT INTO bhg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Judah emboda Aodarida atopapasigari ae Parasi mane demi ge guguma gaguma Yesu da ambodanide sitera, “Ro awa embo imomane tax kumbari embobode embo bebegaede daedo rorae indeite kupeite evi?” ");
INSERT INTO bhg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu mi awamanede mina sisina, “Embo karu itaemi siwo piari embo jipapa ae edo era, ata embo karude ami akuta. ");
INSERT INTO bhg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na embo wasiri dambu darari awa dao tain gumbae, ata embo bebegae dao tano awamaneda jimbo beyae dodo God da yai wareregorote.” ");
INSERT INTO bhg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ango edo embomaimi gundo Yesu de tedogositera, “Ro awa embo John da ambodani iji jiwae veta edo benunu tedo era, edo daedo Parasi mane ango edo era, ata ito ambodani rorae injido kundo eri?” ");
INSERT INTO bhg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ango tetero Yesu mi mina sisina, “Inemane ango awo jimbari tutu isiari ainda embotopo indari indae tepo mambarita? ");
INSERT INTO bhg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ata deguta ainde jimbari tutu awamaneda yai awa kundo mamaina; deguta angode awamane veta ara.” ");
INSERT INTO bhg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu mi daedo awamanede eniya ge eiwa sisina, “Embo da aimi gongo tekada jibigi kundo gongo matu kerari awa gaiari tao ae. Ango aina awa jibigi tekami gongo matu awa dumbari keraina, edo gongo jibigi teka awa ae matu de mi tega tega ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Edo embo da aimi dongo gama teka awa sigi aintomi ari ainda ainto mamatuda gerigari tao ae. Ango aina awa dongo gama tekami ainto mamatu awa dumbari kekerigedo beyae aro gama butuda dodegaina. ");
INSERT INTO bhg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ata dongo gama teka awa sigi aintomi ari tetekada gerigaro, rorae tote (2) matawa dave itara. ");
INSERT INTO bhg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Edo embo da aimi dongo gama matu awa injido dongo gama teka awa boraebé udo ari tao ae; aindabé embomi sira awa, ‘Gama matu awa davebé dave.’” ");
INSERT INTO bhg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ango edo duberi teka tuturoda pura da (1) itae esiri pura neinda Oena Apari Degutade Yesu ae ainda ambodani de wheat buro begata barida maunsitera. Edo ainda ambodanimi wheat oen awa totokumbedo ipami dateite injido esitera. ");
INSERT INTO bhg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Awa gido Parasi maneda neneimi awamanede sitera, “Ro awa embo imomane ge okain awa Oena Apari Deguta de detewo erigeteiri?” ");
INSERT INTO bhg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ata Yesu mi awamanede mina sisina, “Imomane David mi nongo esisina awa, bé ajigedo gaeta iji angode imo beji mina budo ae ainda embobo de? ");
INSERT INTO bhg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ami God da oroda torido bread God da jisida piari awa kundo injisina. Edo daedo nenei ainda embobode pipisisina. Ata ge okainda tari isira awa pirisi manemi akuta indorote.” ");
INSERT INTO bhg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu mi awamanede sisina, “Na, Embo da Mai, awa daedo Oena Apari Deguta ainda Badari. Nanemi buro ro embomi Oena Apari Deguta de era awa, awara tana.” ");
INSERT INTO bhg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ango edo Yesu Oena Apari Deguta neinde Judah embomainda benunu oroda maundo torido atopaposisina. Edo embo da (1) ainda isira, ainda ipa be awa ambari. ");
INSERT INTO bhg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Edo Aodarida atopapasigari ae Parasi mane demi imo jijimbesitera, Oena Apari Degutade embo ari kaviyegainita awa gain. Ango ari gido Yesu de bekumba ge jirain. ");
INSERT INTO bhg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ata Yesu awamaneda kotembari awa goteite, embo ipa ambari ainde sisina, “Eriyo visido petate!” Ango tesiri embo awa erido visido toropuda peposisina. ");
INSERT INTO bhg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ango edo Yesu mi awamanede sisina, “Na tedogari da (1) imondemane piana. “Oena Apari Degutade awara ari buro ro orote tari isiri, dave aririta, beyae ari ri? Emboda wasiri toregarita, dari betari ri?” ");
INSERT INTO bhg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Edo imo embo berari awa jisimi udugedo gido embo ipa ambari ainde sisina, “Ipa ito ududuge!” Ango tesiri ami kera edo ainda ipa ududugesiri dave esisina, ipa nei ango. ");
INSERT INTO bhg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ata awamane sinigambarimi do ato ae esiri Yesu de nongo ari awa akuta mina tara esitera. ");
INSERT INTO bhg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Iji angode Yesu idegedo pejida benunu tain maunsisina. Edo muyae ainde awa God de benunu siri jijirisina. ");
INSERT INTO bhg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Edo sipo atesiri imo ainda ambodani dao tesiri ainda yai guputera. Ainda edo ami awamaneda doda embobo 12 geredo nombo ‘piari aimbari embobo’ pipisisina: ");
INSERT INTO bhg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (ainda dao Peter pipisisina) ae ainda nameji Andrew de; James ae John de; Philip ae Bartholomew de; ");
INSERT INTO bhg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew ae Thomas de; Alphaeus da mai James ae Simon (ainda dao nei Zelot tedo esitera) ainde; ");
INSERT INTO bhg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas awa James neinda mai ae Judas Iscariot de, embo emi awa amboda otawo betarate ge jiraina. ");
INSERT INTO bhg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ango edo imo ae awamane de daedo wotedo yai ududugarida imo peposisina. Edo ainda ambodani jisi da awa ae embomai jisi bajina de doregesitera. Awamane yai berari Judea doda, edo Jerusalem da, edo nasi ewa doda, Taia ae Saidoni de, ami Yesu da ge ingido karu neindekainde edo itari awa kaviyegain guputera. ");
INSERT INTO bhg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Edo daedo avekave asisi bebegaemi bundari awa gundo udegari budo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Edo embo berari doregesitera ami imo tujiain edo esitera, aindabé, embo ainda goroba idegeteira ami embo berari kaviyegetera awatedo. ");
INSERT INTO bhg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ango edo Yesu jisi ambodani kena edo sisina: “Aindabé imomane rorae isisigae itewa, God da gisijiari awa imomane topo. Awatedo, dubodave awa itomane. ");
INSERT INTO bhg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Aindabé imomane boroko beji itewa, God mi imondemane rorae piari injido inono awa. Awatedo, dubodave awa itomane. Aindabé imomane boroko mamato eite ji tewa, imomane amboda iro jirawa. Awatedo, dubodave awa itomane. ");
INSERT INTO bhg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Aindabé, imomane na, Embo da Mai awa, ambo ambo edo ewa, dubodave awa itomane, iji angode, embomi imondemane sinigambari ara, edo imomane jipapa ae ara, edo imondemane ge butara, edo imomane ajiregedo​ ​dao itomaneda ge bebegae tara. ");
INSERT INTO bhg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Iji ainde, yawa eite kekapunya ewo, aindabé, God mi itomane tau bajinabé utuda​ ​siya esira isira, edo aindabé awamaneda apipiyemi wasiri dá ango peroveta maneda yai edo esitera, awatedo. ");
INSERT INTO bhg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ata imomane gaiapa jiwaede itewa, itomane rorae davegave matu bewa. Awatedo, do ari itomane yai. ");
INSERT INTO bhg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Imomane rorae injido inono etewa,​ ​amboda beji mina bawa. Awatedo, do ari itomane yai. Imomane iro ge boroko site itewa,​ ​amboda mamato eite ji tawa. Awatedo, do ari itomane yai. ");
INSERT INTO bhg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Edo iji ainde embomai berarimi imomane dasiga edo era, do ari itomane yai, aindabé, awamaneda apipiyemi peroveta mane pitawa​ ​ango dasiga edo esitera, awatedo. ");
INSERT INTO bhg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ata nane imomane aimi ge goteite itewa ainde tena: Itomane gitopo embobo dubobudo ewo. Edo aimi imondemane sinigambari edo era, ainde wasiri davemi edo ewo. ");
INSERT INTO bhg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Embomai aimi imondemane begá piedo era, God de tedogiwo, awamane ao ari piedo are. Edo aimi imondemane ge tepotapo tedo era, awamane embo benunu tedo ewo. ");
INSERT INTO bhg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Imo embo aimi opoda dari gido, wareregeyo, opo neinda daedo dare. Edo embo aimi ito dademo ombari jiari gido, ito ombaribé awa daedo kokumbeyo bare. ");
INSERT INTO bhg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Edo embo aimi ito yai rorae ro atega edo eira awa, pieyo budo are. Edo embo neimi rorae ito awa ainda topo kumbari gido awa, tekago piarate tedo eote. ");
INSERT INTO bhg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Edo wasiri ro imomane jipapa edo ewa ango embomi imondemane edo ara, kariwa ango awa inemane awamanede edo ewo. ");
INSERT INTO bhg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Awarata, embomai aimi imomane dubobudo era awa akuta dubobudo ewa, ro awa embo imomane dasiga ari? Aindabé, wasiri bebegae ari embobomi embo nenei dá ango dubobudo era. ");
INSERT INTO bhg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Edo daedo, embomai aimi imondemane wasiri dave edo era, awamanede akuta wasiri dave edo ewa, ro awa embo imomane dasiga ari? Aindabé, wasiri bebegae ari embobomi embo neneinde dá ango wasiri dave edo era. ");
INSERT INTO bhg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Edo imomane ganu embo neneinde akuta piawo jigamo edo mina piorote kotembedo ewa, ro awa embo imomane dasiga ari? Aindabé, wasiri bebegae ari embobomi embo bebegae neneinde ganu pisido era, awamanemi tega inonoda piaro bara ango kotembedo era. ");
INSERT INTO bhg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Awarata, gitopo embo itomane dubobudo ewo, edo awamanede wasiri dave edo ewo. Edo awamanede ganu piedo tekago piaro bain kotembeove. Ango edo itomane tau dugabé bawa, edo God Ikanebé Ikane ainda mamai awa. Aindabé, embo ainda dave ari embo do okain de jivere embobo deda yai piedo eira. ");
INSERT INTO bhg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Awatedo, embo berari do ewo dá ango Mamo itomane embo berari do edo eira. ");
INSERT INTO bhg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Embo nei katove dowo, edo God mi imomane katae doware. Embo nei bekumba eove, edo God mi imomane bekumba ae doware. Embo nei kotembedo dowo, edo God mi imomane kotembedo doware. ");
INSERT INTO bhg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Imomane embo neinde kando piedo ewo, imondemane pisido ara, awatedo. Embomaimi imondemane kando mina piain era, kariwa awa tega davebé siraro beda ari dodedo wotaina. Aindabé, tega ro inemane embo neneinde jigamo edo ewa, dá ango God mi imondemane jigamo edo aina.” ");
INSERT INTO bhg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Edo Yesu mi awamanede eniya ge sisina: “Embo jisiguba arimi jisiguba ari nei gisijiaini ta? Ango aina awa, awamane tote (2) matawa maundo koturoda durara. ");
INSERT INTO bhg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Daedo, ambodanimi awamaneda atopatari daginegari tao ae. Ata, awamane berari giu atopasidogogo ara, ami awa awamaneda atopataride daedo tega inono ara. ");
INSERT INTO bhg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Edo ro awa embo imo onyeye saka ito namejida jisida isira awa gido tesi, ata ikuta bajina jisi ikaitoda isira awa gae esi? ");
INSERT INTO bhg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Edo nongo edo ine nameji itode tesi, ‘Nameji, do! Onyeye saka jisi itoda awa pusigane,’ edo iji dá ainde, imo akuta ikuta bajina jisi itoda awa gari tao ae? Imo aodari pisido ambo ambo ae embo! Gisibé, ikuta bajina jisi itoda kundo augeyo. Ango eteta ami, imo yai dave goteite ito namejida jisida onyeye saka awa pusigata. ");
INSERT INTO bhg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Edo daedo, ni davemi be beyae ekari tao ae, edo ni beyaemi be dave ekari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Edo ni berarida be ekedo era ami awamaneda kariwa emboda yai arapa edo eira. Embomi ni dunga be awa danegayanida bari tao ae, ko dongo pasiporo be awa benomada bari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Embo davemi ainda doda rorae dave woru ari isira awa pieuri idegedo eira. Edo embo beyaemi ainda doda rorae beyae woru ari isira awa pieuri idegedo eira. Aindabé, emboda doda rorae ro beda ari isira awa ainda bemi tedo eira. ");
INSERT INTO bhg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ro awa embo inemane namonde, ‘Badari, Badari,’ tewa, ata nane ro awate tena, awa ae evi? ");
INSERT INTO bhg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Embo aimi nato yaida gundo, nato ge ingido kera edo eira awa, ainda kariwa piano gawa. ");
INSERT INTO bhg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Awa kariwa engo, embo da (1)mi mando ain eite dasivi uro ugonubé banga tamonda duredo dadorisina. Edo wa desiri un duga uwasi gogorade gundo mandoda dorisina. Ata mandoda dasivi banga tamonda matu dadorisina, awatedo, mando jipae. ");
INSERT INTO bhg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ata embo aimi nato ge ingido kera ae edo eira, awa engo embo da (1)mi mando butu popoda esisina, ainda dasivi okain ae. Awatedo, un duga uwasi gogorade gundo mando awa desiri boraebé dudurisina. Edo un mi desiri sitedo usibesibé esisina.” ");
INSERT INTO bhg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iji angode Yesu mi embomainde ge berari karigesiri ingitera, ainda amboda, imo overegedo maundo Kapenium nasida totorisina. ");
INSERT INTO bhg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Edo itoroda gisijiari yai ainda isima edo esisina. Edo ainda buro embo ami buro dave euri dapadedo esisina awa, karu esisina, betari aikae. ");
INSERT INTO bhg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ango esiri gisijiarimi Yesu da gumbari bino ingido Judah embomainda orobeda kopuru mamai ainda yai piesiri maunsitera, ainde tedogaro gundo embo awa ari kaviyegarate. ");
INSERT INTO bhg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Edo awamane gundo Yesu da yai ategabé domi eite sitera, “Gisijiari eiwa dave mai! Nakare embo awa kondade atate jipapa era. ");
INSERT INTO bhg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Embo awa kaenato embomai dubobudo eira, edo ami akuta nakare kondade esiri benunu oro gaputera.” ");
INSERT INTO bhg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ango tetero gido Yesu awamanede daedo maunsisina. Edo imo matu maundo mando atutumbeteiri itoroda gisijiarimi otatawo piedo ge engo torote sisina, “Badari, kotembari jiwae eote, aindabé, na davera mi imo nato mandoda gumbesiko. ");
INSERT INTO bhg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Edo na awa embo dave ae kotembetena. Awatedo, inemi gemi tato buro embo nato kaviyegare. ");
INSERT INTO bhg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aindabé, na badari natomi gisijido eira, edo ainda ge teuri kera edo ena. Edo daedo, itoro embobo nato tuda itera. Awatedo, nane embo da (1)de, ‘Mambu,’ tano mamaina. Edo embo neinde ‘Gumbu,’ tano gumaina. Edo nato buro embode ‘Buro eiwa e,’ tano buro awa aina. Na gotena, imo awa daedo badari. Awatedo, tepo ge teyo nato buro embo kaviyegare,” ango sisina. ");
INSERT INTO bhg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iji ainde Yesu ge awa ingido korebé edo, wareregedo embo jisi da imo ambo ambo era awamande sisina, “Nane imondemane tena, Israel embomai berarida yai, gebé ari bajina engo nato yaida da ji itae!” ");
INSERT INTO bhg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Edo embobo gisijiarimi piesiri maunsitera, awamane overegedo mandoda gundo buro embo karu ari awa matu kaviyegedo isiri taputera. ");
INSERT INTO bhg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ango edo sipo neinde Yesu nasi Nain ainda maunsisina, edo ainda ambodani jiwaede, embo jisi bajina awamanededa. ");
INSERT INTO bhg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Edo imo maundo nasi guwa gaiari ainda manguro be atutumbesiri embomai idegeteite betari tamo bundedo kundo guputera, goiari yaida mamaintedo. Edo embo betari awa eutu rori da (1) ainda mai dakaimabé. Awatedo, nasi embomai jisi da eutu ainde daedo idegesitera. ");
INSERT INTO bhg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ango ero gido Badari mi eutu rori awa gido do esisina. Edo ainde sisina, “Ji teote.” ");
INSERT INTO bhg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesu mi ango site imo aikae gundo kakate tujijisina. Ango esiri embobo kakate amboka ari ainto era, awamane dapitera. Edo ami sisina, “Singa nato, nane imonde tena, eriyo!” ");
INSERT INTO bhg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ango tesiri embo betari awa erido anumbedo tuturo edo ge sisina. Edo Yesu mi mai awa ainda aide tekago pipisisina. ");
INSERT INTO bhg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Edo do adu ari bajinabé embomai berarida yai gumbiri God dasiga eite sitera, “Peroveta duga kaenato doda yerigesira,” edo “God ainda embomai etega edo kondade esira.” ");
INSERT INTO bhg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Edo Yesu buro ro esira, ainda bino awa yai Judea doda edo nasi demonda jiari berari ainda arapu esisina. ");
INSERT INTO bhg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ainda edo John da ambodanimi Yesu buro ro berari edo eira awa ainde tetero gosisina. ");
INSERT INTO bhg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Awatedo, John ambodani tote (2) dao tesiri gumbero awamane Yesu da yai piedo, ge engo tewo sisina, “Imo awa Embo God mi piari gumaina sisina, ami gumbesita? Ko nakare embo nei gain eite sima ari?” ");
INSERT INTO bhg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ango tesiri awamane maundo embo ainda yai ge engo sitera, “John Bapataito Ari Embo mi nakare ito yaida piesiri gumbera. Ami imonde ge engo torote tesira, ‘Imo awa Embo God mi piari gumaina sisina, ami gumbesita? Ko nakare embo nei gain eite sima ari?’” ");
INSERT INTO bhg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Iji dá ainde Yesu embomai jiwae karu amburo ari edo memeside gao esiri kaviyegesitera. Daedo ami asisi bebegae embomainda doda awa ondesiri idegesitera, edo embo jiwae jisiguba ari esiri dave esitera. ");
INSERT INTO bhg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Awatedo, Yesu mi awamanede mina sisina, “Maundo John de tewo gare ro inemanemi jisimi gido, edo dengoromi ingewa. Embomai jisiguba ari awa yai gotera, baoro bundari erido ainto era, ginimi tutupegari kaviyegetera, dengoro dundari ge yavi ingera, betari awa erido wasiri burera, edo mapa embomai, awamane God da bino dave ingera. ");
INSERT INTO bhg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","God mi embo awa ao aina, aimi ainda gebé ari nato yaida dowae.” ");
INSERT INTO bhg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ainda amboda, John da bino piari embo dodo mambero Yesu mi embomai jisijisi doregesitera ainde tuturo edo John da ge sisina: “Imomane abu damodamoda maunsitewa awa; rorae ro gain esitevi? Embo do buraude ango opema bisimi doreiri maundo gundo eira awa gain esitevita? Ango ae! ");
INSERT INTO bhg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ata rorae ro gain idegedo maundo esitevi? Embo ombarijiari virarae tamoda piari awa gain ta? Ango ae! Embomai giropagiro ari edo itari kumbari davebé dave ango awa daotegeregarida oromandoda isima edo era. ");
INSERT INTO bhg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ata rorae ro gain idegedo maundo esitevi? Peroveta rita? Gebé, nane imondemane tena. Edo embo awa peroveta tepo ae. ");
INSERT INTO bhg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Edo John eiwa gumaina, matu perovetami gagurisina awa engo: ‘Giyo, na bino piari embo piano gisi maundo, ito begata gatedo dave aina.’ ");
INSERT INTO bhg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nane imondemane tena, peroveta nenei berari eutumi engitera ainda doda, peroveta John Bapataito Ari Embo ango da ji itae. Awarata, emboda jisida embo awa dao itae ami God da gisijiari awa domi bureira gido John da derobé awa ami daginegari isira.” ");
INSERT INTO bhg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Aindabé awamaneda jimbo bebegae dodo God da yai wareregedo John da bapataito ari matu buritera, iji ainde embomai berari Yesu da ge awa ingitera, tax kumbari embobo daedo, awamanemi sitera, “God da begata awa dambu darari.” ");
INSERT INTO bhg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ata, Parasi mane ae Aodarida jirogari embobo demi God da jipapa ajiregesitera, awatedo, John da bapataito ari bae doturitera.) ");
INSERT INTO bhg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ango edo Yesu mi sisina, “Imomane embomai iji einda itewa, itomane kariwa nongo tani? ");
INSERT INTO bhg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Imomane awa kariwa engo mamai babaingaemi nasi arapada anumbedo isite dao mina tara edo era engo: “‘Nakare itomane sino jivetera, ata imomane ya urae; Nakare imondemane do ari ya tetera, ata imomane ji tae.’ ");
INSERT INTO bhg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Imomane awa kariwa dá ango, aindabé, John Bapataito Ari Embo, ami bread ae waini de indae gupusina, edo inemane tewa, ‘Embo awa bineinde isira.’ ");
INSERT INTO bhg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Edo Embo da Mai indari ae unde indeite gumbiri inemane tewa, ‘Giu, embo owa rorae indari pu inge edo waini jiwae injido dutari, tax kumbari embobo ae embo bebegae awamanede otawo edo eira!’ ");
INSERT INTO bhg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Awarata, God da dubogari awa ainda maiunjibéda yai arapa aina, edo awamanemi gara awa wasiri dambu darari.” ");
INSERT INTO bhg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Edo Parasi embo dao Simon mi Yesu ainde daedo turo indari indarate jipusina. Awatedo, imo maundo Simon da mandoda torido indari inaintedo anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Iji ainde nasi ainda eutu da (1), jimbo beyaede isinesina ami, Yesu awa Parasi da mandoda anumbedo indari inaina, ainda bino ingisina. Awatedo, imo sigi alebasita un muno davebé davede kundo gupusina. ");
INSERT INTO bhg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Edo eutu ami maundo atutumbedo Yesu da gunda pepoteite ji sisina. Ango eiri tuturo edo ainda jijiu kepukapu wotedo Yesu da tai tatapu esisina. Edo eutu awa baongo dadari edo ainda kopuru tumi Yesu da tai gaigesisina. Edo imo ainda tai munegeteite un muno davebé davedemi ainda taida dodegeteiri bimbegesisina. ");
INSERT INTO bhg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ata iji angode Parasi mi Yesu gumbarate matu jipusina ami iwata ango awa gido, imo akuta sisina, “Embo eiwa peroveta bé gido, eutu owa nomi ainda tai tujijieiri awa gaina, edo nongo isima eiri awa gae esira. Eutu awa jimbo beyae eutu da (1).” ");
INSERT INTO bhg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu, embo ainda kotembari matu gido ainde sisina, “Simon, na ge da (1) imonde tain jipapa ena.” Ango tesiri Simon mi sisina, “Atopatari, tewasi gane!” ");
INSERT INTO bhg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ango edo Yesu mi ainde sisina, “Embo tote (2)mi embo gaiapadeda yai kondade ari ganu tedogositera. Ango tetero embo neinde ganu 500 piedo, neinde ganu 50 pipisisina. ");
INSERT INTO bhg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ainda amboda, embo tote (2) ganu jigamo esitera awa, ainda mina ganu tutude piari tao ae esitera. Edo ganu tutumi awamande sisina, ‘Dubovevera eove! Imomane nanemi kotembedo doturena!’ Awatedo, Simon te gane. Embo tote (2) einda da (1) nondawa embo ganu tutude dubobari bajinabé bajina piaini?” ");
INSERT INTO bhg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Edo Simon mi mina sisina, “Na kotembetena awa embo ave ganu 500 jigamo esiri ganu tutumi kotembedo doturisina awa.” Edo Yesu mi sisina, “Awa gebé berari kotembeteta.” ");
INSERT INTO bhg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu ge ango tedo wareregedo eutu awa goteite Simon de sisina, “Imo eutu einda wasiri gesi? Iji ainde na ito mandoda torena, imo kaenato ewowo gawowoda wasiri ambo ambo edo nato tai teiari un piae doteta. Ata eutu emi ainda jijiumi nato tai teiedo ainda kopuru tumi gaigesira. ");
INSERT INTO bhg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Imo na ‘Oro!’ site tanjido munegae. Ata eutu emi na gundo torena, edo gundo iji einde, tai nato awa matawa munegeteiri jirira. ");
INSERT INTO bhg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Imo nato kopuruda ni ‘olive’ gama dodae, ata eutu emi un muno davebé davedemi tai natoda dodegeteiri bimbegesira. ");
INSERT INTO bhg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Awatedo, nane imonde tena, eutu einda dubobari bajinabé iwata esira emi karigesira, ainda jimbo bebegae jiwaebé awa matu kotembedo dosiri itae esira. Ata embo anda jimbo saka God mi kotembedo dosira, awa God da yai dubobari saka piaina.” ");
INSERT INTO bhg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Edo Yesu mi eutu ainde ge engo sisina, “Ito jimbo bebegae kotembedo doteno itae esira.” ");
INSERT INTO bhg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ango tesiri embomai nenei ainde daedo indari indero jiriri, tuturo edo akuta mina tara esitera, “Embo eiwa averi? Imo embo neinda jimbo daedo kotembedo dowari taorita?” ");
INSERT INTO bhg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ata Yesu mi eutu ainde ge engo sisina, “Ito gebé ari nato yai pieteta ami, God mi jimbo bebegae itoda imo tonembesira. Awara, God da bégada mambuyo!” ");
INSERT INTO bhg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ango edo ainda amboda, Yesu maundo nasi babainde babaingaede da da torido idegedo eite dengoro baiari pipiteite God da gisijiarida bino dave karigeteite pepeta esisina, ae ainda embobo 12 ainde daedo. ");
INSERT INTO bhg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Edo eutumai nenei ae Yesu de daedo maunsitera. Iji gisi awa ami awamane da da asisi bebegaemi bundari awa ge tesiri udegari buritera, edo nenei karu neindekainde gao esiri kaviyegesitera. Eutu nei awa Mary, nasi Magadala da eutu. Awa Yesu mi binei 7 ainda doda itari awa ondesiri idegesitera. ");
INSERT INTO bhg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Edo eutu nei awa Joanna, Chuza da aro. Ainda iu awa Daotari Herod da oromandoda gisijiari. Edo eutu nei awa Susanna. Eiwamane ae eutumai nenei jiwaedemi Yesu ae ainda embobode, awamaneda gaiapami kondade edo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ango edo embomai jisi bajina doregesitera. Edo iji ainde awamane nasi evekara jiwae da da ami Yesu da yai gumbero, ami eniya ge eiwa awamanede sisina: ");
INSERT INTO bhg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Embo da (1) mi ainda rorae vero purara piain kundo maunsisina. Edo purara pipiteiri vero nenei begata beda duduritera. Awa embomi gundo maundo eite taimi patero beyae esiri nimi wotedo injitera. ");
INSERT INTO bhg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Edo nenei banga tamonda duduritera. Edo yai ainda butu tatapu itae, awatedo, erido mumuya esitera. ");
INSERT INTO bhg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Vero nenei kurere teoroda duduritera, edo kurerede daedo erido ami ipuda engetero ginene esitera. ");
INSERT INTO bhg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Edo vero nenei butu daveda duduritera. Awa erido be jiwaebé, 100 ango, esitera.” Yesu eniya ge awa tedo, amboda ge ikanade tedo sisina, “Ingiwo! Imomane ge ro tena awa bé gain edo gawa!” ");
INSERT INTO bhg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ainda amboda, ambodanimi ainde tedogositera, “Eniya ge teteta ainda mokabé rori?” ");
INSERT INTO bhg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ango tetero Yesu mi sisina, “Imomane God da gisijiarida gebé onjigari awa ano arapa ari gawa. Ata nanemi owamaneda yai eniya gemi akuta tana. Awatedo, ‘Nato buro gara, ata ainda mokabé mana gara; Nato ge ingara, ata ainda atopatari mana arapa ari gara.’ ");
INSERT INTO bhg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Awara, eniya geda mokabé awa evire: Vero awa God da ge ango. ");
INSERT INTO bhg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Edo vero begata beda duduritera awa engo embomai ge awa ingido doda pisido era. Ata awamaneda gebé ari God da yai piaro ami awamane toregeurekae, Binei gupeite ge awamaneda doda awa beono edo kundo maundo eira. ");
INSERT INTO bhg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Edo vero banga tamonda duduritera awa engo embomai ge awa ingido do yawade budo era. Ata ge awamaneda doda besinya piae, awamane iji tupo God gebé edo era. Ata iji angode bawari gumburi awamaneda gebé ari dodo taigedo era. ");
INSERT INTO bhg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Edo vero kurere teoroda duduritera awa engo embomai ge awa ingido ainto eiworo kotembari jiwaemi do buriya ari, gaiapade ain, edo tamopisida jipapa ain arimi pasiuri awamane be dave ekae edo era. ");
INSERT INTO bhg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ata vero butu daveda piesiri duduritera awa engo embomai ge awa ingido do davebé davede ge awa jido takimbedo era, awa tataimbarimi be dave ekedo era. ");
INSERT INTO bhg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Edo daedo embo aimi keimo ijimbedo ou kuwoda piari tao ae o awari tenemba dutuda piari tao ae. Ata ainda petari yaida pieuri ami parara pisido eira, edo embo gundo mandoda totoreite parara awa gorote. ");
INSERT INTO bhg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aindabé, rorae ro onjigarida itari awa kundo arapada piaina. Edo rorae ro apuregari itari awa pirigari arapa aina. ");
INSERT INTO bhg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Awatedo, ge nato ro ingevi awa jidogogo ewo! Aindabé, embo aimi ge awa do davebé davede jido takimaina awa God mi kondade edo gari teka piaina. Ata embo aimi ‘Ge awa bainyae. Na matu gari!’ ango kotembeteira, awa saka ro ainda yai isira awa dodo baina.” ");
INSERT INTO bhg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iji angode, Yesu da ai ae nanonameji de embo awa gaintedo guputera. Ata embo jisi da itera, awatedo, torido tambari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ango etero gido embo neneimi ainde sitera, “Ito ai ae nanonameji de awa arapada petetera isite imo gain jipapa era.” ");
INSERT INTO bhg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ata ango tetero Yesu mi mina sisina, “Nato ai ae nanonameji de awa eiwamane ainkaimi God da ge ingido kera edo era.” ");
INSERT INTO bhg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ango edo deguta da (1)de Yesu ae ainda ambodani de un ma doda visido ami awamanede sisina, “Puwo! Kaende ubutu kupo neinda tembore. Ango tesiri awamane ma gaigedo tembari tuturo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ata iji ainde awamane tepero embo awa durudo jitao ausina. Edo burigibé bisibubura bajina wotedo ubutu desiri ma utoro vivisiri awamane bouga bajinabé buritera. ");
INSERT INTO bhg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Edo awamane gundo imo audedo sitera, “Badarari, Badarari, kaen betain era!” Ango tetero Yesu erido petedo ge okain bisi ae kakawa de tesiri, awamaneda wasiri dandedo damodamo etero ubutu binono dorisina. ");
INSERT INTO bhg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ata ami awamanede sisina, “Itomane gebé ari embo anda yai pipitevi?” Edo awamane adu edo korebé edo akuta ge mina tara esitera, “Embo eiwa averi? Ine ge okain bisi ae kakawa de siri ainda ge kera era!” ");
INSERT INTO bhg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ainda amboda awamane temundo yai Gadareni ainda maunsitera Galili ubutu kupo neinda. ");
INSERT INTO bhg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iji angode Yesu ma dodo tai butuda piesiri, embo da (1) nasi bajinada edo gupusina ami Yesu tapusina. Iji riboribé embo ainda doda binei isima edo esitera. Edo embo awa gongosini itae, ko ainda mandoda itae, ata goiari yaida isima edo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Iji ainde embo awa Yesu gido aorogatedo ainda taida dudurisina. Edo Yesu mi asisi beyae ainda doda awa idegarate tesiri ami aoro ikanade gatedo sisina, “Yesu, God Ikane bé Ikaneda Mai, imo namonde ro ain jipapa esi? Imo benunu tena, na dedo sitote!” (Iji jiwae bineimi embo awa dedo dumundo esisina. Awatedo, embobomi asi okain aurimi ari ami ainda ipatai bundedo sima edo esitera. Ata embo awa asi okain aurimi ari jiuri kapeuri bineimi gisijido abu taoteda kundo maundo esisina.) ");
INSERT INTO bhg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Edo Yesu mi tedogosisina, “Dao ito averi?” Edo ami mina sisina, “Jisi Da”, aindabé, binei jiwaebé embo ainda doda torari itera, awatedo. ");
INSERT INTO bhg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ango edo bineimi Yesu de benunu tedo dowae esitera, ami ge okain tari awamane God da rirowa bari yai ugonuda mamborekae. ");
INSERT INTO bhg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Edo iji dá ainde pumane jisi da peji tembada rorae indeite isiretera. Awatedo, bineimi Yesu de benunu tedo dowae esitera, “Nakare awara ato maundo pumaneda doda torore.” Edo ami awara sisina. ");
INSERT INTO bhg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ango tesiri binei emboda doda awa dodo idedegedo maundo pumaneda doda totoritera. Edo pumane jisi da adujinanga edo tumundo maundo dedewada wotedo un ubutuda dadagumbedo un injido bebetegesitera. ");
INSERT INTO bhg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Iji angode pu sima ari embobomi wasiri ro idegesira awa gido adu tumundo maunsitera. Edo bino awa nasi bajinada edo indari kumbari urari nasida karigetero gositera. ");
INSERT INTO bhg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ango etero embomai idegedo wasiri nongo esiri teri awa jisimi gain maunsitera. Edo awamane Yesu da yai gundo embo binei matu dodo idegetera awa taputera. Embo awa ombarijiari ari Yesu da taida anumbedo kotembari dave bureite isiri gido adu esitera. ");
INSERT INTO bhg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Edo embobo avekave wasiri awa gositera ami daedo Yesu mi nongo esiri embo bineimi bundari awa kaviyegesiri awa embo teteka gumbera awamanede tetero gositera. ");
INSERT INTO bhg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ango edo embomai berari yai Gadareni doda adu ari bajinabé buritera. Awatedo, awamanemi Yesu yai neinda mambarate sitera. Ango tetero gido imo ma doda visido overegedo mamain esisina. ");
INSERT INTO bhg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Edo embo binei doda idegesitera, ami Yesu de benunu tedo dowae esisina, “Imonde daedo mamanita?” Ata Yesu mi embo awa pipiteite sisina, ");
INSERT INTO bhg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Dodo egenembedo orobe itoda mambuyo! Edo awamane teyo goré, God mi wasiri babain ro imo embo esira awa!” Edo embo awa dodo maundo nasi bajinada doda embomai berari ainda itera awamanede Yesu mi wasiri babain ro imo embo esiri awa karigesimene maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Awatedo, iji angode Yesu overegedo tembiri embo jisi da berari imo gain sima ero jijirisina, ami dubodavede oro site buritera. ");
INSERT INTO bhg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ango ero embo da (1) gupusina, ainda dao awa Jairus. Awa Judah embomainda benunu oroda badarari. Aindabé, ainda gagara dakaima, duberi 12 ango, awa betain eiri, ami gundo Yesu da taida durudo ainda mandoda gumbarate benunu tedo dowae esisina. Ango edo Yesu ainto eiri embomai jisijisimi doiedo daedo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Edo eutu da (1) awa karu ororo bureite duberi 12 doturisina. Ami iji matawa siwo gao ari emboda yai, aro kaviyegain ganu kundo gundo maundo esisina. Ata karu kaviyegae, ainda ganu itae pipisisina. ");
INSERT INTO bhg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Eutu awa Yesu da gunda maundo ainda ombari riborida begisi tujijisina. Ango esiri boraebé ainda ororo jingesisina. ");
INSERT INTO bhg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Edo Yesu mi sisina, “Aimi na tujiri?” Awamane berarimi, “Na gae gi!” sitera. Edo Peter ae embobo neneindemi sitera, “Badarari, embomai jisijisi tapitapi era ami imo papotera. Ango ero imo ‘Aimi na tujiri?’ teta!” ");
INSERT INTO bhg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ata Yesu mi sisina, “Nato goroba idegeteiri mina bena, awatedo, embo da (1)mi na tujira.” ");
INSERT INTO bhg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ango tesiri eutu awa onjigari tao ae awa gido, do periperi eite gundo ainda doda durudo ainde karigesisina, embomai berarida jisida ro embo imo Yesu tujiri edo nongo edo kaviyegari boraebé biri. ");
INSERT INTO bhg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Edo Yesu mi eutu ainde sisina, “Gagara nato, adu eote ta goroba buyo! Gebé ari itomi eteno kaviyegeteta. Awara, bégade mambuyo!” ");
INSERT INTO bhg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Edo imo matawa ge site isiri embo da (1) awa badarari Jairus da mandoda edo gundo ainde sisina, “Ito gagara itae esira. Awatedo, Atopatari dowato mando itoda gumbure.” ");
INSERT INTO bhg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ata Yesu ge awa ingido Jairus de sisina, “Adu eote! Tepo da (1), na gebé eyo! Gagara ito kaviyegare.” ");
INSERT INTO bhg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ango edo Yesu Jairus da mandoda gundo embo nenei tororekae sisina. Ata Peter ae John de James de edo gagarada aimamo de akuta kundo totorisina. ");
INSERT INTO bhg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Edo embomai berari gagara awa embo jinda buira eite ji sitera. Ango ero Yesu mi sisina, “Ji teove! Gagara awa betae, ata tepo jitao aveira.” ");
INSERT INTO bhg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Edo awamanemi gagara matu betesira awa gositera, awatedo, Yesu tedojijiritera. ");
INSERT INTO bhg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ata embo ami tesiri awamane berari arapada idegetero gagara ainda ipada jido sisina, “Gagara naka, eriyo!” ");
INSERT INTO bhg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Edo ainda asisi tekago gumbiri gagara awa burigibé erorisina. Ango esiri Yesu mi sisina, “Gagara eiwa rorae piewo indare!” ");
INSERT INTO bhg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Edo ainda aimamo bé korebakore esitera, ata awamanede sisina, “Wasiri ro eteno gewa, eiwa embo neneinde teove!” ");
INSERT INTO bhg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ainda amboda, Yesu ainda embobo 12 de dao tesiri gundo doregetero awamaneda yai goroba ari de awara tari de pipisisina, binei ondaro idegorote edo karu neindekainde gao aro kaviyegorote. ");
INSERT INTO bhg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ango edo awamane piesiri maunsitera, God da gisijiarida bino embomainde karigorote, edo karu egeregari aro kaviyegorote. ");
INSERT INTO bhg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Edo awamanede sisina, “Itomane pepetada ipa tepo mambuwo! Ketu bainyae, pepeta kaita bainyae, indari bainyae, edo ganu bainyae! Edo daedo ombari tote (2) tote (2) omainyae! ");
INSERT INTO bhg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Edo imomane maundo nasi nonda torawo embo aimi mando da da imomane baro gido ainda isite buro itae edo idegewo. ");
INSERT INTO bhg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Edo embomai ainkaimi imomane ategedo bae aro gido, nasi awa dodo idegeteite itomane taida konipo awa ainda denden ewo wotare. Ango awo God mi awamaneda yai rirowa piaina ainda kariwa awa arapa gore.” ");
INSERT INTO bhg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ango tesiri awamane taigedo maunsitera. Edo nasi tegerida awamanemi bino dave karigeteite yai berari etega eite karu embomai gao eiworo kaviyegedo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Ango edo yai Galili da daotari, Herod mi, buro ro berari Yesu mi edo eira awa ingisina. Edo embo neneimi, “John Bapataito Ari Embo betarida edo erira,” ango tera, edo neneimi, “Elijah tenda idegesira,” tero, neneimi awa, “Peroveta mamatu ainda da (1)mi tekago erira,” ango sitera. Awatedo, imo anana edo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ango tero gido Herod mi sisina, “Nane teteno John da dubo matu kapitara. Ata, embo awa aimi buro ango eiri teri?” Ango tedo embo awa edo gido jisimi gain edo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Edo Yesu da piari aimbari embobo tenda egenembedo gundo buro ro berari awamanemi esitera awa, Yesu de tetero gosisina. Ango etero ami awamane akuta kundo idegedo yai damodamoda, nasi dao Besaida kena, maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ata iji ainde embomai jisijisi ainda mambari bino ingido imo ambo ambo esitera. Awatedo, imo awamane ategedo budo, God da gisijiarida ge site, embomai karu mina burera awa gao edo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Edo iji tuturo edo wowoteiri ainda embobo 12 mi ainda yai gundo sitera, “Yai kaena itera eiwa abubé. Awatedo, embomai ta pieyo maundo nasi babaingae edo buro bowada indari kakowa edo awari yai tamundo aworé.” ");
INSERT INTO bhg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ata Yesu mi awamanede sisina, “Inemane indari piewavi indore!” Edo awamanemi mina sitera, “Nakare indari jiwae itae, ata bread ipa da (5) edo un wo tote (2) awa akuta. Embomai berari einda indari awa nanekaremi maundo oriorote jipapa esita?” ");
INSERT INTO bhg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Embobo ajijigari 5,000 ango yai ainda doregesitera.) Edo Yesu mi ainda ambodanide sisina, “Embomai awa tewo doregedo 50 ango jisi tedo jisi tedo anunumbore.” ");
INSERT INTO bhg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Edo ambodanimi tetero dá sisina ango, embomai berari anunumbesitera. ");
INSERT INTO bhg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ango etero Yesu mi bread ipa da (5) ae un wo tote (2) de awa kundo, jisi ikane utuda edo God da yai ategari piedo, engegegedo ambodanide pipiteiuri embo jisi dade piedo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Edo awamane berari rorae injido inonobé esitera. Edo indari itoto doturitera awa ambodanimi sirigedo kanjia berari 12 sirido buritera. ");
INSERT INTO bhg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Edo iji da (1)de Yesu imo akuta isite God de benunu siri ambodani gundo ainde daedo dada esitera. Edo ami awamanede tedogosisina, “Teu gane! Embo jisijisimi na awa embo ave teri?” ");
INSERT INTO bhg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Edo awamanemi mina sitera, “Imo awa John Bapataito Ari Embo, ata neneimi awa Elijah, edo neneimi tera awa, peroveta mamatu ainda da (1)mi tenda erira.” ");
INSERT INTO bhg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Edo Yesu mi awamanede sisina, “Ata inemanemi na awa ave tevi?” Peter mi mina sisina, “Imo awa Keriso, God da Avigari Embo.” ");
INSERT INTO bhg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ango tesiri, Yesu awamanede aodari ge okain sisina, bino awa embo neneinde taro giworekae. ");
INSERT INTO bhg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Edo daedo awamanede sisina, “Embo da Mai awa orobeda kopuru mamai ae pirisi babain de Aodarida atopapasigari demi memesi bouga jiwae ainda yai piara. Edo awamanemi embo awa ajiregedo daro betaina. Ata deguta tamonde (3) ainde awa God mi imo jiari eraina.” ");
INSERT INTO bhg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ango edo awamane beraride tedo sisina, “Imo aimi nato amboda purain edo gido imo akuta ruvegata, edo ito orega awa budo na ambo ambo eyo! ");
INSERT INTO bhg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Imo aimi wasiri ikaito awa gisi piain ata gido awa dadoegata, ata imo wasiri ito na embo dadoegata gido awa, imo wasiri natopo itari bata. ");
INSERT INTO bhg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Edo imo butuda gunaguguye berari bato ito arate eteta gido awa, imo akuta wasiri ito usibesi ata o ito wasiri natopo itari dadoegata, ango awa dave ae! ");
INSERT INTO bhg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Imo embo aimi na ae, nato ge de awa embo mengata awa, na, Embo da Mai emi, dá ango imo embo mengana, iji nonde nato taogari akuta de gumana, ae nato Mamo de anela kokotopu de awamaneda goroba de parara de daedo. ");
INSERT INTO bhg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ata ge arapada imondemane tena, eiwa giwo! Embo nenei einda petetera itera awa, betainyae isiaro jirari God da gisijiari awa gara.” ");
INSERT INTO bhg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ainda amboda ge awa tesiri gero, deguta 8 ango itae esiri, Yesu Peter ae John de James de kundo peji ikaneda benunu tain vivisisina. ");
INSERT INTO bhg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Edo visido Yesu benunu siri ainda dombu kariwa eve esiri, ombarijiari parara eiri pipiriko arago esisina. ");
INSERT INTO bhg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ango eiri boraebé embo tote (2), Moses ae Elijah demi, awamaneda gorobade pararade idegedo Yesu de ge mina tara esitera. Awamane ge jijiritera awa, Yesu mi maundo Jerusalem ainda God da jipapa awa petugedo, butu eiwa dodo mamaina. ");
INSERT INTO bhg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Edo Peter ae otatawo de jitao bougabé autera. Ata awamane bé jitao awae ango erido jisi gundedo Yesu da parara awa goteite embo tote (2) ainde daedo petedo itero gositera. ");
INSERT INTO bhg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Edo embo tote (2) Yesu dodo taigetero Peter mi ainde sisina, “Badarari, dave awa nakare einda itera. Awatedo, bowa tamonde (3) ae etera, ito da (1), Mosesda da (1), edo Elijahda da (1),” (Ata embo ami ge nongo siri awa bé gae). ");
INSERT INTO bhg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peter ge awa site isiri poraga gundo apuregeteite awamane duga esisina. Edo awamane adu ero, iji dá ainde awamane poragada totoritera. ");
INSERT INTO bhg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Edo ge yavi poragada engo gupusina, “Eiwa nato dubobari Mai. Ainda ge ingiwo!” ");
INSERT INTO bhg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Edo ge yavi itae esiri awamane jisi piedo Yesu awa akuta gositera. Edo iji angode ro berari awamanemi gositera awa, embo neinde tae, ata awamaneda doda akuta doturitera. ");
INSERT INTO bhg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ango edo deguta neinde awamane pejida edo wotetero embo jisi bajina Yesu taputera. ");
INSERT INTO bhg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Edo burigibé embo da (1) doregari ainda dodami aorogatedo sisina, “Atopatari, aiya dotena! Nato mai dakaimabé awa evire. Awa do ewasi! ");
INSERT INTO bhg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Giyo! Mai awa asisimi tanjiuri aoro beyae gatedo eira, edo imo jipeiuri be poro tugedo eira. Asisimi mai awa borae dodo taigaede, edo daedo dedo usibesi edo eira. ");
INSERT INTO bhg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Awatedo, na gundo ito ambodanida yai benunu tetena, asisi awa ondaro idegarate, ata awamane ari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ango tesiri, Yesu mi mina sisina, “O imomane gebé ari isisigaede bebegae! Na iji matu imondemane isite edo gundo iji boroko einde daedo, awarata inemane iji matawa na gebé aera! Awara, ito mai einda kundo gumbu!” ");
INSERT INTO bhg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Edo mai awa ainda yai gupeiri bineimi kundo augesiri butuda duriri jipusina. Ata Yesu mi ge okain tesiri asisi beyae mai awa dodo idegesisina. Ango edo Yesu mai awa gao esiri kaviyegesiri ainda mamode tenda pipisisina. ");
INSERT INTO bhg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Edo awamane berari God da goroba bajina awa gido korebé esitera. Awarata, iji dá ainde embomai berarimi Yesu buro berari esira awa gido kore eite tedo darero, imo ainda ambodanide sisina, ");
INSERT INTO bhg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ge eiwa bé ingido doda piedo kotembeteite isiwo! Embo da Mai awa gitopo emboda ipada piain bara.” ");
INSERT INTO bhg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ata imo ge ro tesira awa, awamaneda yai arapa ae, bé onjigesisina. Awatedo, awamane dave edo gae, edo daedo adu eite embo ainde tedogari piae doturitera. ");
INSERT INTO bhg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Edo ambodani akuta ge baitera, embo aimi embo bajinada dero baini. ");
INSERT INTO bhg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu, awamaneda kotembari doda awa goteite, mai saka gegenimbesiri piri ainda demonda piesiri peposisina. ");
INSERT INTO bhg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ango edo ami awamanede sisina, “Embo da aimi mai saka engo awa, dao natoda ategeteite bureira awa, imo na bureira. Edo embo da aimi na ategeteite bureira awa, embo na piesiri guputena, awa bureira. Embo aimi itomane doregari doda saka eira awa, God da jisida bajina aina.” ");
INSERT INTO bhg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Edo ango tesiri John mi mina sisina, “Badarari, nakare embo neimi dao itoda bineimane ondeuri idegedo ero gotara. Aindabé embo awa kaenamonde iae, nanekaremi embo awa buro ango eurekae siutara.” ");
INSERT INTO bhg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ata Yesu mi ainde sisina, “Embo aimi kaenamonde gitopo ae awa kaenato embotopo. Awatedo, embo awa engiregeove!” ");
INSERT INTO bhg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ango edo, God mi Yesu kundo utuda mamaina, ainda iji atutumbesiri gido, imo Jerusalem pepeta mamain bé kotembesisina. ");
INSERT INTO bhg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Edo imo bino piari embo piesiri gisi maunsitera. Iji dá ainde awamane mauntero jiriri Samaria embomainda nasida totoritera, Yesu da gumbari awa, siya baiya ain. ");
INSERT INTO bhg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ata, aindabé ainda kotembari bé awa, imo Jerusalem pepeta edo mamaina, awatedo, awamanemi embo awa ategedo bae esitera. ");
INSERT INTO bhg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Edo ainda ambodani, James ae John de, wasiri awa gido awamanemi sitera, “Badari, nanekare niyao dao taro utuda edo wotedo awamane aware dá Elijah mi esisina ango?” ");
INSERT INTO bhg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ata ango tetero, Yesu wareregedo awamane isimbedo ge okain sisina, “Itomane kotembari, ainda mina piari egenembari awa imomane gae. ");
INSERT INTO bhg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Embo da Mai awa, embo enemboda wasiri usibesi ain gumbae, ata awamane tonemain gupusina.” Ango tedo awamane dodo nasi neinda maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iji dá angode awamane begatada ainto edo maunteite embo da (1)mi Yesu de sisina, “Badari, imo yai indago mambata berari awa, na ambo ambo ana.” ");
INSERT INTO bhg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Edo Yesu mi ainde ge mina sisina, “Abu sino, awamaneda awari banga to isira, edo ni waside, awamaneda awari ma isira, ata Embo da Mai, ainda awari mando topobé itae.” ");
INSERT INTO bhg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Edo embo neinde sisina, “Na ambo ambo eyo!” Ata embo ami mina sisina, “Badari, gisibé awa na dowasi maundo nato mamo goiane.” ");
INSERT INTO bhg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu mi embo ainde mina sisina, “Doyo, betarimi awamaneda betari akuta goioré. Ata imo maundo God da gisijiari awa, yai berarida karigeyo!” ");
INSERT INTO bhg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Edo embo neimi daedo sisina, “Badari, na imo ambo ambo ana. Ata gisi, na doyo, egenembedo maundo nato orobe ategane.” ");
INSERT INTO bhg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ata Yesu mi embo ainde sisina, “Embo da aimi ma daveite dodo wareregedo jisi gunda piaina awa, ma dambu darari mamainyae. Dá ango, embo aimi God da gisijiarida buro ain eite, dodo wareregedo jisi gunda piaina awa, ami buro awa ari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Edo ainda amboda, Badari mi embo nenei, ajigari berari 70, daedo avigedo tote tote piesiri maunsitera, nasi babain edo babaingae berari imo mamain eira, ainda. ");
INSERT INTO bhg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ango edo ami awamanede sisina, “Indari rorae jiwae buroda awa matu tari esira, ata rorae kumbari embomai indewae. Awatedo, Buro Tutu da yai benunu tewo, rorae kumbari embomai piari ainda buroda mambore. ");
INSERT INTO bhg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Imomane idegedo mambuwo! Ata giwo! Na imomane wo sipuda mamai ango, abu sino gorobade itera ainda, pieteno mauntewa. ");
INSERT INTO bhg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pepeta kaita, ganu kapi, edo tai woru ango kundo mamainyae. Edo imomane embo begatada tuvedo daedo ge jirove! ");
INSERT INTO bhg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Edo imomane mando nonda torido gido, gisibé, ‘God da béga mando einda itare,’ ango tewo. ");
INSERT INTO bhg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Edo mando ainda embo bégade isira gido, ategari awa baina. Ata itae gido, bégada ategari awa itomane yai tenda overegaina. ");
INSERT INTO bhg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aindabé buro embo awa ainda buro tau baina, mando dá ainda isite indari ae un de awamanemi piaro injiwo. Edo gundo maundo mando tegeri eove. ");
INSERT INTO bhg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Daedo, imomane nasi nonda totoreiawo ategedo baro gido, indari awamanemi siya edo piara awa injiwo. ");
INSERT INTO bhg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Edo karu egeregari nasi ainda itera awa gao ewo. Edo awamanede engo tewo, ‘God da gisijiari itomane yai aikae gumbira.’ ");
INSERT INTO bhg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ata nasi nonda totoreiawo awamanemi imomane ategedo bae aro gido, idegedo maundo nasi doda petedo tewo gore, ");
INSERT INTO bhg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Imomane bino natokare ajiregetewa, awatedo, nanekaremi nasi itomaneda konipo tai natokareda tatakimbari awa itomane yai doratugedo dodo mambara. Awarata, kotembewo, God da gisijiari itomane yai aikae gumbira!’ ");
INSERT INTO bhg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na imondemane tena, iji ainde God embomai berari kataina, rirowa awa emi nasi embomai ainkaimi ainda bino ajiregeterada yai piaina, awa Sodom nasida embo bebegaeda rirowa awa daginegaina. ");
INSERT INTO bhg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Do ari imomane Koraizin nasida itewa! Do ari imomane Besaida nasida itewa! Edo na nasi Taia ae Saidoni de ounda buro babain ae esitena, dá ango itomane yai esitena, awamanemi iji matubé dubovevera eite gongo sitoto ari omundo aewa kopuruda piedo awamaneda jimbo bebegae dodo God da yai wareregae esitera. ");
INSERT INTO bhg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Awarata, katari ijide, God mi rirowa Taia ae Saidoni de piari bara, dá ango imondemane daginegedo piaina. ");
INSERT INTO bhg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Edo imomane Kapenium nasida isima ewa ami nasi itomaneda dao ikanebé jiewo viviteira. Ata, God mi imomane kundo piari wotawa bebetegarida sima ari yai ainda.” ");
INSERT INTO bhg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ango tedo Yesu mi ainda ambodanide sisina, “Embo da aimi ge itomane ingido kera eira awa, na kera eira. Embo da aimi imomane ajiregeteira awa, na ajiregeteira. Edo embo aimi na ajiregeteira awa, God mi na piesiri guputena, awa ajiregeteira.” ");
INSERT INTO bhg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ainda amboda, embobo 70 piesiri maunsitera awa, tekago overegedo yawa eite gundo sitera, “Badari, nanekaremi dao itoda ge okain bineinde siworo awamanemi kera edo etera!” ");
INSERT INTO bhg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ango tetero ine ambodanide mina sisina, “Na Satan durudo piripiri ari ango utuda edo wotesiri gena. ");
INSERT INTO bhg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ge eiwa tano giwo! Na awara tari imondemane pipitena. Imomane jimbago ae mai vekemba deda tamonda taimi pasido datedo mambawa. Edo gitopo emboda goroba berari awa inemane daginegawa. Edo rorae da nomi imomane kambo piainyae. ");
INSERT INTO bhg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Awarata, asisi bebegae ge itomane kera edo etera, awa gido yawa eove! Ata, God mi dao itomane utuda gaiesira, awa embo yawa ewo!” ");
INSERT INTO bhg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Iji dá angode Yesu awa Asisi Kotopu da yawa ari ami sirido beda esiri engo sisina, “Mamo, utu ae butu deda Badari, imo dasiga ena, aindabé, gebé eiwa inemi embobo dubogaride edo jirogarideda yai arapa ae bui eteta awa, maiunjida yai arapa eteto gera awatedo. Gebé, Mamo, jipapa ito dave engo idegarate siteta awa dá ango eteta.” ");
INSERT INTO bhg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Edo ami ambodanida yai wareregedo sisina, “Roviravi berari awa nato Mamo mi namonde pipisisina. Na awa Mamo da Mai, ata embo da aimi Mai awa embo averi awa bé gae. Da (1) bé Mamo mi akuta goteira. Edo embo da aimi Mamo awa embo averi awa bé gae. Da (1) bé nane, Mai mi akuta gotena. Edo nane, Mai mi awa, jipapa edo gido, embo neneinda yai ano arapa ari Mamo awa embo averi awa bé gara.” ");
INSERT INTO bhg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ainda amboda, imo wareregedo ainda ambodanide akuta sisina, “God da ao ari itomane yai isira, imomane ainkaimi buro babain ro awa jisimi gido etewa awa gewa. ");
INSERT INTO bhg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na ge eiwa imondemane tano giwo! Iji matuda peroveta mane ae daotari jiwae demi rorae ro inemanemi gotewa awa, gain jipapa edo esitera, ata gae. Edo daedo, ge ro inemanemi ingewa awa, ingain jipapa edo esitera, ata ingae.” ");
INSERT INTO bhg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Edo iji neinde Aodarida jirogari embo da ami gundo Yesu bavedogain jipapa edo tedogosisina, “Atopatari, na buro ro edo wasiri natopo itari bani?” ");
INSERT INTO bhg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ango tesiri Yesu mi ainde sisina, “Aodarida gaguritera ainda, ro tari isiri? Imo ajigedo nongo kotembedo esi?” ");
INSERT INTO bhg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ango tesiri embo ami mina sisina, “BADARI, ito God awa, dubobudo eyo do ito berarimi, wasiri ito berarimi, goroba ito berarimi edo kotembari ito berarimi.’ Edo ‘nembu ito awa dubobudo eyo dá imo akuta dubobudo eta ango.’” ");
INSERT INTO bhg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Edo Yesu mi ainde sisina, “Imo gebé berari teteta. Awatedo, buro ango edo awa, imo wasiri natopo itari bata.” ");
INSERT INTO bhg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ata Aodarida jirogari embo ainda dao torain jipapa eite gido, Yesu de sisina, “Awara, ata nembu nato awa embo averi?” ");
INSERT INTO bhg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Edo Yesu mi eniya ge budo embo ainde sisina, “Embo da (1)mi Jerusalem edo Jeriko nasida wotedo maunteiri jivere embobomi boraebé idegedo begata engiregedo ainda roviravi itae buritera. Edo embo awa usibesibé detero durudo betain eiri dodo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Iji angode pirisi da (1) begata awa udugedo wotedo gupeite embo awa gido jimbebedo kupo neinda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ainda amboda, Levi embo daedo begatada ainda wotedo gundo embo awa gido jimbebedo kupo neinda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ata Samaria embo da (1) begatada ainda pepeta edo gupeiri jiriri gundo, embo durari isira, ainda idegedo, embo awa gido do esisina. ");
INSERT INTO bhg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ango edo imo maundo embo ainda kamboda ni ‘olive’ gama ae waini demi siwo edo gongomi bunjisina. Edo embo awa jiri eriri osinembedo ainda wo topobéda piedo kundo maundo dederi oroda torido, embo awa ainda piedo sima esisina. ");
INSERT INTO bhg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Edo sipo neinde imo dodo mamain eite ganu inono kundo maundo dederi oroda mamode piedo sisina, ‘Embo eiwa sima dave eyo. Edo iji nonde na tekago egenembedo, ganu nandogo inemi embo ainda yai jigamo ain eta, ainda mina imonde piana.’” ");
INSERT INTO bhg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu eniya ge jirari itae edo embo ainde sisina, “Awatedo, imo kotembeteta awa rori? Embo tamonde (3) einda doda, embo beono embobomi doritera, ainda nembubé awa averi?” ");
INSERT INTO bhg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Edo Aodarida jirogari embomi sisina, “Embo da aimi embo nei kondade esisina awa.” Ango tesiri Yesu mi ainde mina sisina, “Awara mambuyo! Imo dá ango ate.” ");
INSERT INTO bhg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ango edo awamane pepeta eite mauntero Yesu nasi da (1) ainda toriri eutu dao Martha mi imo ategedo ainda mandoda burisina. ");
INSERT INTO bhg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Edo Martha da dao, Mary awa, daedo gundo Yesu da taida anumbedo ainda ge ingisina. ");
INSERT INTO bhg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ata Martha mi indari siya baiya buro bajinabé esisina, ami do buriya esiri imo punte Yesu de sisina, “Badari, dao natomi na kondade ae dosiri buro bajinabé na akuta ena. Awa gotesi? Awatedo, ine tewasi pumango na kondade are!” ");
INSERT INTO bhg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesu mi ainde sisina, “Martha, Martha, ito buro jiwae eiri, daro daro eite do buriya eiri teta. ");
INSERT INTO bhg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ata rorae da (1) bé da (1) awa inono; awawa ge nato ingari. Mary mi rorae davebé awa avigedo bureira, awa embomi teugari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ango edo iji da (1)de Yesu God de benunu tedo itae eiri ainda ambodani da (1)mi yai ainda gundo sisina, “Badari, nakare benunu nongo nongo tari awa atopasiyo gore, dá John mi ainda ambodani atopaposisina ango.” ");
INSERT INTO bhg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ango tesiri ami awamanede sisina, “Iji nonde imomane benunu tain eite gido engo tewo: Mamo natokare, utuda isima edo eta awa, dao ito kotopu tou ore. Gisijiari ito doyo gumbare. Nakare jipapa ito butuda einda ore, dá utuda edo era ango. ");
INSERT INTO bhg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Edo namondekare deguta da (1) dowae; indari jipapa edo era, awa piewasi. ");
INSERT INTO bhg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Edo jimbo bebegae natokare kotembedo dowasi, aindabé, nakare dá ango embo neneimi jimbo beyae ro namondekare edo era, awa kotembedo dodo era, awatedo. Edo bawarida nakare kundo aimbote, ata embo beyaeda yai nakare toregewasi.” ");
INSERT INTO bhg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ango tedo Yesu mi awamanede sisina, “Edo imo embo da (1)mi muyae toropuda maundo ito otawoda mandoda edo audedo engo tae eteta, ‘Aiyaee otawo, na kondade edo ambe gigiwa tamonde (3) piae etesita? Mina amboda piana. ");
INSERT INTO bhg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Aindabé, embotopo nato da (1) boroko pepeta edo gundo mando natoda torira, ata na indari itae, awatedo ito yai atega ena.’ ");
INSERT INTO bhg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Ango tato embo mando doda ami mina taina, ‘Doiyo tena! Manguro matu engiregetena, edo na ae mamai natode besida durera. Nane erido imonde indari piari tao ae.’ ");
INSERT INTO bhg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Giwo, nane imondemane tena! Embo awa imo kondade ari jipapa ae, ata ami erido rorae imo jipapa eta, awa piaina. Aindabé imo awa ainda otawo, embo awa erido imonde rorae piainyae. Ata, imo do jinenegedo atega borere eteta, awatedo, ro berari imo jipapa eta awa piari bata. ");
INSERT INTO bhg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Awatedo, nanemi imondemane tena, jipapa itomane atega ewo, imondemane piari bave. Itomane jipapa awa gain ewo, edo tambave. Edo manguroda tatain jivewo, itomane yai manguro pirigare. ");
INSERT INTO bhg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aindabé, embo aimi God de atega edo eira awa, ainde pieuri budo eira. Edo embo aimi ainda jipapa ro God da yai gain edo, awa tamundo eira. Edo embo aimi God da manguroda tatain jivedo eira awa, God mi embo ainde manguro pirigaina. ");
INSERT INTO bhg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Edo imomane mamono itewa doregari einda doda, mai da (1)mi ainda mamode bread atega ari, ganuma piainita? O un wo atega ari, awa piae dodo ainde jimbago piainita? ");
INSERT INTO bhg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O kokora mundu atega ari, awa piae dodo ainde mai vekemba piainita? ");
INSERT INTO bhg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Awa dave ae. Imomane awa embo bebegae, ata imomane awa gari. Awatedo, kando dave mamai itomanede pisido ewa. Aindabé, itomane Mamo utuda ami embo beraride dave edo eira, awatedo, embo ainkaimi ainde atega edo era awa, awamanede Asisi Kotopu piari bara!” ");
INSERT INTO bhg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Edo iji ainde embo da (1) bineimi bundari ge tae isinesina. Edo Yesu gundo binei awa ondesiri idegedo mambiri embo awa tuturo edo ge sisina. Ango esiri gido embomai jisijisi korebé esitera. ");
INSERT INTO bhg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ata embo doregesitera ainda doda neneimi sitera, “Embo awa Beelzebul da buro embo. Edo Beelzebul awa bineimaneda gisijiari. Awatedo, ainda gorobami bineimane awa ondeiuri idegedo era.” ");
INSERT INTO bhg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Edo embo neneimi God da awara tari Yesu da yai isirita awa gain jipapa esitera. Awatedo, awamanemi imo bavedogain tedo esitera, “Nakare kariwa utuda edo pieyo gore!” ");
INSERT INTO bhg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ata imo awamaneda kotembari goteira, awatedo sisina, “Edo nasi babain da (1) nomi akuta ainda embomai kupo avigari kupo avigari edo mina dara ara awa, boraebé nasi awa embo itae aina. Edo orobe da (1)mi akuta kupo avigari kupo avigari mina dara edo bebetegaro ainda orobeda dao itae aina. ");
INSERT INTO bhg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Edo inemanemi nane Beelzebul da gorobami binei ondeiwono idegedo era, ango tewa. Awarata, Satan da buro embobomi akuta kupo avigari kupo avigari edo mina dara ara awa, nongo edo Satan da gisijiari petaini? ");
INSERT INTO bhg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ambodani itomane daedo binei ondoro idegedo era. Awa Beelzebul da gorobami buro ango edo erita? Ango ae! Awatedo, awamanemi ge ro inemane namonde tewa, awa ge pitawa ango taro gawa. ");
INSERT INTO bhg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ata, God da gorobami nane binei onono idegedo era. Awatedo, God da gisijiari itomane yai matu gumbira. ");
INSERT INTO bhg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Satan awa goroba embo ango. Ami ainda mando dariga awa gi ae bere de budo sima edo eira. Awatedo, ainda roviravi berari dave isima edo eira. ");
INSERT INTO bhg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ata, na awa embo nei goroba bajinade ango. Awatedo, iji nonde embo goroba bajinade ami gundo embo awa dedo ainda gi ae bere de, imo tumonda edo eira awa budo, roviravi berari ainde daedo embo neneinde kando aina. ");
INSERT INTO bhg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Edo imo embo aimi namonde daedo itae awa nato gitopo embo. Edo imo embo aimi namonde daedo embomai kundo doregae edo eira, ami eiuri awamane evekara edo era. ");
INSERT INTO bhg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Iji nonde asisi beyae emboda doda dodo idegedo eira, ami maundo yai paingarida tepeima oena apari yai kakowa edo aina. Edo yai ango tambae, awa engo taina, ‘Na overegedo nato mando matu dotena ainda mamana.’ ");
INSERT INTO bhg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ango edo imo overegedo gundo ainda mando matuda torido yai teka wadedo gindedo dave ari gaina. ");
INSERT INTO bhg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ainda amboda, asisi beyaemi asisi nenei bebegaebé, berari 7, awa kundo gundo emboda doda torido itara. Awatedo, embo ami itari beyaebé matu gae awa gaina.” ");
INSERT INTO bhg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iji ainde Yesu ge angogo tedo itae eiri eutu da (1)mi doregari ainda doda ge yavi ikanade sisina, “Dubodave awa eutu aimi imo engedo gaiesiri babojiteta ainda yai!” ");
INSERT INTO bhg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ango tesiri Yesu mi sisina, “Awarata, dubodave bajinabé awa, embomai ainkaimi God da ge ingido kera edo era, awamaneda yai!” ");
INSERT INTO bhg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Edo iji ainde embo jisijisi doregedo Yesu jinenembetero imo tuturo edo ge sisina, “Embomai iji einda itera, awamane awa bebegae. Awamanemi kariwa piari gain jipapa era, ata nei piainyae, da (1) bé awa peroveta Jonah da kariwa. ");
INSERT INTO bhg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Aindabé, Jonah awa kariwa God mi Nineve embomainda yai pipisisina, awatedo, dá ango Embo da Mai awa kariwa God mi embomai iji einda iterada yai piari gara. ");
INSERT INTO bhg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Edo iji amboda God mi embo kataina ainde, yai Siba da daotari eutu ami erido petedo embomai iji einda iterada jimbo karigaina. Aindabé, eutu awa ainda yaida edo aikamanabé gupusina, Daotari Solomon da dubo ge atopapoteira awa ingain. Edo giwo! Embo da (1) einda isira awa bajinabé Solomon daginegari. ");
INSERT INTO bhg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Edo iji amboda, God mi embo kataina awa, Nineve embomaimi erido petedo embomai iji einda iterada jimbo karigara. Aindabé, Jonah mi God da ge karigesiri ingido awamane jimbo bebegae dodo God da yai wareregesitera. Edo giwo! Embo da (1) einda isira awa bajinabé Jonah daginegari.” ");
INSERT INTO bhg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesu mi tedo sisina, “Embo da aimi keimo ijimbedo yai onjigarida o ou kuwoda piaede, ata ainda petari yaida pisido eira. Awatedo, embomai gundo mando ainda totoreite parara gara. Edo daedo nane God da gebé awa onjigae, ata ainda moka itomane yai teteno gewa. ");
INSERT INTO bhg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ito jisi awa ango tamo itoda keimo, aindabé ami imo kondade eiuri inono yai berari gido eta. Edo ito jisi karu itae gido, rorae berari dave gata. Ata ito jisi karude gido, rorae berari dave gari tao ae. Awa muyaenda itari ango. ");
INSERT INTO bhg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Awatedo, nato atopatarida ro berari teteno geta awa dave edo kotembeyo. Awa parara ango. Ata embo neneinda atopatari pitawa awa muyae ango. Ami imo udumbaro muyaende daedo matawa itote. ");
INSERT INTO bhg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Edo gido imo tamo ito berarimi parara bureta, edo ainda kupo muyae da ji itae, awa dá ango imo mando doda iteto keimoda pararami yai berari datembeteira. Ami ari inono rorae berari arapa gata.” ");
INSERT INTO bhg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Edo iji ainde Yesu ge tedo itae eiri Parasi embo da (1)mi aindeda maundo indari indarate jipapa esisina. Awatedo imo maundo torido indari besida anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Edo Parasi embo awa korebé esisina aindabé, Yesu Judah embomainda ewowoda atopatari ambo ambo ae edo ipa teiae indari injisina, awatedo. ");
INSERT INTO bhg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ango edo Badari mi ainde sisina, “Awa gebé, imomane Parasi manemi, aia akou ae teo de tamo teiedo ewa. Ata, itomane do awa garogaro aride jimbo beyae ato ae ari. ");
INSERT INTO bhg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Imomane awa kotembari isisigae! God mi itomane tamo ae do de esisina. ");
INSERT INTO bhg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Awatedo, itomane do wareregedo embomai rorae isisigae awamane dubobureite kando piewo bore. Ango awo itomane rorae berarida dono itae are, God da jisida. ");
INSERT INTO bhg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ata Parasi mane, imomane do ari! Itomane buroda nya de, roriwa ae siloti de berari kundo 10 ango doregedo, ainda kupo da (1) awa avigedo ainda da (1) God de piedo ewa. Ata, embomai sima dave ae edo God dubobae edo ewa. Dave awa itomane buroda nya kupo da (1) awa God de matawa piedo ewa. Ata dá ango embomai sima dave eite God dubobudo ave. ");
INSERT INTO bhg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Edo Parasi mane, imomane benunu oroda anumba davebé dave awa garogaro edo bain jipapa edo ewa. Edo embomaimi origarori ari yaida tou eite ategabutega edo dave borote jipapa edo ewa. Awatedo, imomane do ari! ");
INSERT INTO bhg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Imomane Aodarida atopapasigari ae Parasi mane de, imomane aodari pisido ambo ambo ae embobo! Imomane awa goiari ude ango onjigari gae isiuri embomai ainda tamonda pepeta edo era, ata rorae depeka ari tuda awa jisimi gae. Awatedo, imomane do ari!” ");
INSERT INTO bhg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ango tesiri, Aodarida jirogari emboboda da (1)mi ainde sisina, “Atopatari, ine ge angogo site daedo nakare tedojijireta.” ");
INSERT INTO bhg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Edo Yesu mi mina sisina, “Imomane Aodarida jirogari embobo, aodari okain jiwae embomaimi kera orote tedo ewa, ata inemane akuta awamaneda bouga kondade da ji aede. Awatedo, daedo imomane do ari! ");
INSERT INTO bhg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Edo inemane peroveta maneda goiari ude giropagiro edo ewa, edo itomane ewowomi awamane detero besitera, awatedo, imomane do ari! ");
INSERT INTO bhg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Awa gebé, ewowo itomanemi peroveta mane deoro betedo esitera, edo inemane awamaneda goiari ude giropagiro edo ewa. Awatedo, imomane awa gari ewowo itomanemi jimbo eiwa esitera, edo awamaneda jimbo awa dave tedo ewa. ");
INSERT INTO bhg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Awatedo, God mi daedo dubo ge engo sisina, ‘Na awamaneda yai peroveta mane ae piari aimbari embobo de piano mambara. Edo awamanemi nenei daro betara, edo neneinda yai memesi neindekainde piara.’ ");
INSERT INTO bhg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","God ge ango sisina awa, tuturoda imo utude butude esisina edo ainda amboda, peroveta mane berari awa embomi deoro awamaneda ororo butuda wotedo esisina, ainda rirowa awa, ine embomai iji einda iterada yai piaina. ");
INSERT INTO bhg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Iji tuturoda Abel da ororo wowosisina edo gundo awamanemi Zechariah rorou dungari tenembada edo Judah embomainda oro kotopu bajina ainda toropuda detero ainda ororo wowosisina. Awatedo, imomane giwo! God mi ainda rirowa embomai iji einda iterada yai piaina. ");
INSERT INTO bhg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Imomane Aodarida jirogari embobomi God da gari awa embomainda yai engiregetewa, awatedo, imomane do ari! Awa ango inemane mando pirigari ambao embomainda yai awa dodo kumbewa. Imomane torawa, ata torae dodo embomai nenei torain jipapa ero engiregetewa.” ");
INSERT INTO bhg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iji ainde Yesu awamanede ge eiwa siri Aodarida atopapasigari ae Parasi mane demi tuturo edo sinigambaribé eite tedogari neindekainde ainde pipisitera. ");
INSERT INTO bhg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Edo awamane simagesitera, ami ge beyae ro tari gido bekumba ge ainde tain. ");
INSERT INTO bhg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Iji ainde embomai jiwae ajigari tao ae ami gundo doregedo taimi mina pata ero Yesu gisi tuturo edo ainda ambodanide ge sisina, “Imomane bé goteite iwo! Parasi maneda aodari pisido ambo ambo ae ari awa bread badarida siwo ango. ");
INSERT INTO bhg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Edo rorae ro berari apuregari isira awa, God mi ari arapa aina. Edo rorae ro berari onjigarida isira awa, ami kundo arapada piari gara. ");
INSERT INTO bhg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Awatedo, ge ro berari muyaende tetewa awa, ijide arapada gara. Edo daedo ge ro berari pisipasi mando doda isite tetewa awa, embomi nasi arapada petedo karigaina. ");
INSERT INTO bhg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Edo nato otatawo, imondemane tena, adu eove, owamane aimi itomane tamo daro betaina edo ainda amboda nei ro ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ata, inemane bé gawate jipapa ena awa, God adu ewo! Ainda awara tari isira ami embo enembo dari betari kundo yai beyae niyao matawa itari aveira ainda inono augari tao. Giwo, imondemane tena, embo awa adu ewo! ");
INSERT INTO bhg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Edo inemanemi ni suriri ango ipa da (5) awa ganu sakami ori edo ewa, edo God mi ni babaingae ango da (1) awa mana ruvegaina. ");
INSERT INTO bhg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ata itomane kopuru tu berari awa God mi matu ajijigesisina. Awatedo, adu eove! Itomane tega God da jisida awa suriri jiwaeda daginegari. ");
INSERT INTO bhg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Edo daedo imondemane tena, embo da aimi emboda doda petedo, imo awa nato ambodani taina gido, na, Embo da Mai mi God ae ainda anelamane deda doda petedo embo awa nato ambodani tana. ");
INSERT INTO bhg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ata embo aimi emboda doda petedo, imo awa nato ambodani ae taina gido, na, Embo da Mai mi God ae ainda anelamane deda doda petedo, embo awa nato ambodani ae tana. ");
INSERT INTO bhg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Edo embo da aimi ge beyae Embo da Mai da yai tesira gido, God mi embo awa kotembedo dowaina. Ata embo da aimi Asisi Kotopu da yai ge bebegae tesira gido, God mi embo awa kotembedo dowainyae. ");
INSERT INTO bhg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","“Imomane awa nato ambodani, awatedo, awamanemi kundo maundo Judah embomainda benunu oroda torido gisijijiegari ae babadegari deda doda katain piaro petawa. Iji dá ainde ango aro Asisi Kotopu mi imomane atopatari ge nongo tavi awa arapa aina. Awatedo, imomane akuta toreite ge mina nongo tavi awa kotembari jiwaemi do buriya eove!” ");
INSERT INTO bhg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Edo embomai doregesitera ainda doda embo da (1)mi sisina, “Atopatari, nameji nato awa te, mamo natokareda gaiapa doturisina awa katambedo na kupo piare.” ");
INSERT INTO bhg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ata Yesu mi embo ainde sisina, “Embo, namonde awara tari aimi piesira re itomane gaiapa katamanate tesi?” ");
INSERT INTO bhg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Edo Yesu mi embo beraride sisina, “Imomane bé gidogogo ewo, edo akuta simageteite iwo! Embo neneinda rorae jipapa eove! Aindabé, gaiapa jiwaemi embode wasiri piari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Edo ami eniya ge awamanede sisina, “Iji da (1)de embo gaiapade da (1)mi rorae ve ainda butuda uresiri erido be jiwaebé ekisina. ");
INSERT INTO bhg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Edo imo akuta engo kotembesisina, ‘Na buro ro ani? Nato rorae be jiwaebé ekesira, ata rorae itari oro do eiwa ato ae.’ ");
INSERT INTO bhg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Awatedo, embo ami sisina, ‘Na buro engo ana. Nato rorae itari oro babaingae eiwa sitedo oro babaingo gamana. Edo ainda, nato rorae be berari ae nato dave rorae neneinde dada ana. ");
INSERT INTO bhg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Edo na akuta tana, “Eiwa dave nato. Na boroko awa, rorae dave berari inono duberi jiwae amboda awa embo siya etena. Awatedo, oena apeite injido kundo eite akuta dubodave ana.” ’ ");
INSERT INTO bhg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ata God mi embo ainde sisina, ‘Imo awa kotembari itae! Muyae boroko imo betata, edo roviravi berari siya eteta awa, aimi baini?’” ");
INSERT INTO bhg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Edo Yesu mi ge beao eite engo sisina, “Eiwa ango embo aimi ainda gaiapa awa imo akuta awa embo dada edo eira, edo ainda buro dave God da jisida itae.” ");
INSERT INTO bhg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Edo Yesu mi ainda ambodanide sisina, “Awatedo imondemane tena, wasiri itomane awa embo kotembari jiwaemi do buriya eove, indari ro budo indavi, edo ombarijiari ro budo tamoda piavi. ");
INSERT INTO bhg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Wasiri itomane awa bajinabé God da jisida, indari ango ae; edo tamopisi itomane awa bajinabé God da jisida, ombarijiari ango ae. ");
INSERT INTO bhg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Imomane davebé edo kotembewo! Ni owa awamanemi rorae ve uraede o buroda rorae be kumbaede, edo awamane rorae piari itari oro itae; ata God mi awamane sima eite undedo eira. Giwo! Itomane tega awa God da jisida, nimaneda daginegari. ");
INSERT INTO bhg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Edo embo da aimi itomane doda ainda wasiri butuda einda ribori itarate kotembari jiwaemi do buriya arimi riboribé aini? ");
INSERT INTO bhg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Awatedo, imomane buro sakabé ango ari tao ae gido, ro awa embo rorae nenei einda kotembari jiwaemi do buriya edo evi? ");
INSERT INTO bhg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Imomane davebé edo kotembewo, abuda koko mane nongo nongo edo erido eri awa. Awamane akuta buro okain aede edo ombarijiari gaiaede. Awarata, imondemane tena, Daotari Solomon da ombarijiari berari ainda jitari dave awa, abu koko da (1) bé ainda jitari davebé dave awa daginegari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Giwo! Edo God mi kiyan butuda erari kokomi giro ari, ata sipo neinde awa vededo dungara, God mi imondemane ombarijiari inonobé piaina. Awatedo, God imomane sima dave edo eira ango gebé ewo! ");
INSERT INTO bhg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Edo imomane rorae ro o un ro budo injido gain, ango kotembeteite dubovevera eove! ");
INSERT INTO bhg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Embomai yai berarida God gae awamanemi rorae berari eiwawa gain edo era, ata Mamo itomane matu giuri rorae eiwawa jipapa edo ewa. ");
INSERT INTO bhg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ata God da gisijiari awa gain edo ewo! Ango eiawo God mi rorae berari eiwawa daedo itomane yai piedo are. ");
INSERT INTO bhg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Imomane doregari saka awa nato sipumane. Adu eove. Itomane Mamo da jipapa dave awa gisijiari imondemane piaina. ");
INSERT INTO bhg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","34","Aindabé yai nonda itomane gaiapa isira awa, ainda itomane do daedo itaina, awatedo, rorae itomane oriewo. Edo embo neimi oriaro ganu kundo kando embomai rorae isisigaede piewo bore. Imomane akuta awa embo ganu itari woru beyae ari tao ae awa utuda siya ewo. Yai ainda itomane gaiapa awa jivere embomi beono ainyae edo itomane rorae kandoromi kapainyae. ");
INSERT INTO bhg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Imomane akuta iji berari nato gumbari awa embo siya eite simagedo ewo, embomaimi buro aintedo ombarijiari pisido bupuri jido, keimo ijimbedo muyaende petedo sima edo era ango! Awa kariwa buro embobomi awamaneda badarari jimbari bondoda mambira, awa egenembarate sima edo era ango. Iji nonde imo gundo tatain jiwari gido awamanemi boraebé manguro pirigara. ");
INSERT INTO bhg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dubodave awa owamane buro embobo avekavemi jitao awae simageteite isiaro awamaneda badarari egenembedo gaina. Awara, ge ro imondemane tena, eiwa giwo! Embo awa dademo ombari teugedo awamane tari anumbaro indari piari indara. ");
INSERT INTO bhg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Edo imo muyae toropuda o sipo ataede gundo ainda buro embobo imo simageteite itera ango tamaina, awa dubodave awamaneda. ");
INSERT INTO bhg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Awarata, eiwa giwo! Mando tutu gisi gaina iji bé nonde beono embo gumaini, awatedo, ainda mando simageteite itaina, edo mana dowari beono embomi ainda mando bededo toraina. ");
INSERT INTO bhg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Embo da Mai tekago gumaina, awatedo, imomane daedo siya ewo! Iji nonde Embo awa gumainyae kotembetewa, angode gumaina.” ");
INSERT INTO bhg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ango tesiri Peter mi sisina, “Badari, eniya ge eiwa namondekare tesita, ko embomai beraride daedo tesi?” ");
INSERT INTO bhg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Edo Badari mi sisina, “Embo ain gebémi edo jirogarimi buro dave edo eira, embo awa ainda badararimi gisijiari piaina. Ango ari, ainda badararida mando buro dedegeteite buro embobo neneinda indari katambedo piedo aina, iji tegabéda. ");
INSERT INTO bhg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Awatedo, dubodave awa buro embo ainda, imo badararimi buro ro arate tesira awa eiari, iji ainde badarari tekago overegedo gumaina. ");
INSERT INTO bhg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ge arapada imondemane tena, eiwa giwo! Badararimi embo awa gisijiari avigari ainda oromando ae gunaguguye berari de sima aina. ");
INSERT INTO bhg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ata buro embomi akuta engo kotembae esira, ‘Nato badarari mauntara awa gumbae iji borerebé eira. Awatedo, na buro ro ana embo awa gari tao ae.’ Ango tedo imo erido tuturo edo buro embobo nenei embo ae eutu de dedo gaiedo aina. Edo imo indari injido kundo, dedo amundo ae esira. ");
INSERT INTO bhg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Edo ango eiari ainda badarari tekago overegedo gumaina iji awa imo gae, edo ora ainde gumaina awa kotembae. Ango edo badararimi gisijiari awa dedo kupo tote (2)de butedo, gebé ari isisigae nenei itera, ainda augari idegaina. ");
INSERT INTO bhg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Edo buro embo aimi ainda badararida jipapa ro edo eira awa gari, ata imo akuta siya edo buro awa ae, awatedo, imo vedari bajina baina. ");
INSERT INTO bhg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ata buro embo aimi ainda badararida jipapa ro edo eira awa gae, edo imo buro awa ae dumbae ari gido, imo vedari saka baina. God ainda embomai tega dá ainda sima aina, aindabé, ainda aodari awa embo ande roviravi jiwae piesiri bira awa, ami rorae jiwae tekago God da yai piarate. Edo daedo embo enembomi embo roviravi jiwaebé ande pietera awa, ami rorae jiwaebé awa tekago awamanede piarate. ");
INSERT INTO bhg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Na evekara ari embomainde piain gumena. Awa kariwa niyao awari ango. Edo na jipapa bajinabé ena awa, niyao eiwa matu tuturo edo aveite isira. ");
INSERT INTO bhg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ata na memesi bana dá bapataito arimi yai berari apuregedo aina ango. Edo do nato bougabé eira awa matawa bureite maundo nato buro itae ana. ");
INSERT INTO bhg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Imomane kotembetewa awa, na butuda béga piain gumenita? Ango ae! Imondemane tena, béga ae ata evekara ari piain gumena. Embo nenei ge nato gebé ara, edo nenei gebé ainyae. ");
INSERT INTO bhg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Awatedo, iji boroko edo mamaina ainda awa, orobe da (1) ainda embo ajigari ipa da (5) awamane evekara ara. Embo tamonde (3) awa embo tote (2)de mina mina ara, edo tote (2) awa tamonde (3)de mina mina ara. ");
INSERT INTO bhg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Edo Mamo ae mai de mina mina ara. Ai ae gagara de mina mina ara. Dá ango imbosi ae mai aro de mina mina ara.” ");
INSERT INTO bhg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Edo Yesu mi daedo embomai doregesitera awamanede sisina, “Iji nonde imomane poraga iji wotari kena (west) ingatapari gido boraebé tawa, ‘Boroko wa aina,’ edo awa ango aina. ");
INSERT INTO bhg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Edo bisi yai south kena oregedo tupeite itomane tamoda dari mina budo tawa, ‘Boroko iji vevera aina,’ awa dá ango aina. ");
INSERT INTO bhg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Imomane aodari pisido ambo ambo ae embobo! Butu ae utu deda kariwa jiwaebé gido ewa, ata iji boroko einde God buro nongo nongo eiri, awa imomane gari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Awara, ro awa embo imomane akuta God da gebé awa gido ewa, ata ainda mokabé gaegae o kera ae edo evi? ");
INSERT INTO bhg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Edo boroko imomane God da ge kera ae dowawa awa, ami imomane vedaina. Ainda kariwa awa engo: Embo da (1)mi rorae nonda tamonda imo kundo buriya katari yaida mambari gido, ainda torae gisida begata toropuda embo ainde ge sirigeyo dave are. Ango ae gido, embo ami imo katari emboda yai kundo mamaina, edo katari embomi imonde bekumba ge taina, edo imo kundo bundari embode piaina, edo ami imo kundo bundari oroda augari torata. ");
INSERT INTO bhg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Edo nane imo tena, imo bundari oroda isite ito mina ro inge piatate tesira awa itae piedo imo udegari bata.” ");
INSERT INTO bhg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Edo iji dá ainde embo nenei Yesu da ge ingite awamanemi gundo ainde sitera, “Iji angode Galili embomaimi awamaneda rorou God da yai pipitero, Gisjiari Pilate mi ge okain tesiri ainda itoro embobomi Judah embomainda oro kotopu bajina ainda, maundo awamane detero besitara.” ");
INSERT INTO bhg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Edo Yesu mi awamanede mina sisina, “Aindabé awamane ango besitara awa, imomane kotembetewa awamaneda jimbo bebegae Galili embomai nenei berarida jimbo bebegae daginegatarita? ");
INSERT INTO bhg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ango kotemainyae! Na imondemane tena, itomane jimbo bebegae dodo God da yai wareregae gido, imomane berari God da rirowa natopo itari awa kumbawa. ");
INSERT INTO bhg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Edo imomane bino nei awa yai Silom, Jerusalem doda edo gumbiri awa gotawa. Oro ribori ikanebé yai ainda ami durudo embobo 18 pasiri bebetegatara. Imomane kotembetewa, awamaneda jimbo bebegae Jerusalem embomai nenei berarida jimbo awa daginegatarita? ");
INSERT INTO bhg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ango kotemainyae! Nane imondemane tena, itomane jimbo bebegae dodo God da yai wareregae gido, imomane berari God da rirowa natopo itari awa kumbawa.” ");
INSERT INTO bhg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu mi daedo eniya ge ni dunga ainda bureite sisina: “Butu tutu da (1)mi ni dunga ainda buroda urisina. Edo duberi berari ‘Be eirita?’ tedo gaji gundo esisina. Ata ainda be da ji tambae. ");
INSERT INTO bhg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Awatedo, embo ami gundo ainda buro embode sisina, ‘Giyo! Na duberi tamonde (3) einda doda gaji gundo maundo etena, ainda doda ni dunga eiwa be da ji ae. Ro embo butu gavi eiwa rorae ve neimi bae esira awa doteto, ami tepo bureiri? Kapedo auge!’ ");
INSERT INTO bhg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ata ainda buro embomi ainde mina sisina, ‘Badari, doyo! Duberi da (1) bé eiwa tepo sima eiari, na edo gido butu demonda duredo depure awa ainda tutuda piedo gane. ");
INSERT INTO bhg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Edo ni eiwa duberi neinde be aina gido, awa dave, inge dowana. Ata be ae aina gido awa, kapedo augana.’” ");
INSERT INTO bhg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Awara, Oena Apari Deguta da (1)de Yesu mi Judah embomainda benunu oroda ainda, embomai atopaposisina. ");
INSERT INTO bhg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Edo eutu da (1) ainda awa, asisi beyaemi ari gun ogegembari isite duberi 18 ango doturisina. Ainda gun vetu awa bé dambu darae edo ami matawa dambu darido petari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ata iji angode, Yesu mi eutu awa gido gumbarate tedo ainde sisina, “Eutu, imo ito bundarida awa udegetena. Ito karu itae esira.” ");
INSERT INTO bhg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ango tedo ami eutu ainda tamonda ipa pipiteiri burigibé eutu awa dambu darido erido peposite God dasiga esisina. ");
INSERT INTO bhg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ata, aindabé Yesu mi eutu awa Oena Apari Deguta ainde gao esisina, awatedo, Judah embomainda benunu oroda badararimi sinigambari edo embomainde sisina, “Deguta 6 awa emboda buro ari iji. Awa embo, iji angode imomane gumbuwo gao ari bave. Ata Oena Apari Degutade gao ari einda bainyae!” ");
INSERT INTO bhg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Edo Badari mi embo ainde mina sisina, “Imo ae ito buro otatawo de awa aodari pisido ambo ambo ae embobo! Imomane da dami Oena Apari Degutade itomane wo kao o wo donki ainda sima ari yaida awa udegedo gisijido kundo un piawo indorote edo ewa. ");
INSERT INTO bhg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Eutu eiwa womane berari daginegari God da jisida. Eutu eiwa Abraham da orobeda gagara. Satan mi eutu eiwa bunjisina borerebé duberi 18 ainda doda. Awatedo, eutu eiwa ainda bundarida udegari awa Oena Apari Deguta einde bureira awa dave ae rita?” ");
INSERT INTO bhg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Edo iji angode ami ge eiwa siri, ainda gitopo embobo berari awa mengido amengitumengi esitera. Ata embomai berarimi buro davegave embo ami eira awa goteite yawa esitera. ");
INSERT INTO bhg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Edo Yesu mi tedo sisina, “God da gisijiari awa nongo arapa ani? Edo kariwa ro bani? ");
INSERT INTO bhg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","God da gisijiari kariwa da (1) awa engo: Embo da (1)mi maine vero kundo ainda buroda urisina. Vero awa erido bajido ni bajina esisina. Edo ainda papatuda ni wasidemi baba edo gundo awamaneda ma gaputera.” ");
INSERT INTO bhg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Edo tekago ami tedo sisina, “God da gisijiari kariwa nongo tani? ");
INSERT INTO bhg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ainda kariwa nei awa engo: Eutu da (1)mi ou bajina palawami beda arida bread badari siwo saka awa palawade baige esisina. Ango edo siwomi esiri palawa berari babojisina,” ango sisina. ");
INSERT INTO bhg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ainda amboda, Yesu pepeta edo nasi babainde babaingaede ainda torido idegedo eite embomai atopaposite Jerusalem kena maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Edo pepeta maunsiri embo da (1)mi gundo ainde tedogosisina, “Badari, embomai indewae tonembari barita?” Edo Yesu awamanede sisina, ");
INSERT INTO bhg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Imomane edo gido engo ewo! Kotembari da (1) bé eite do jinenegewo God da gisijiari yaida torari to saka ainda torave. Aindabé, embomai jiwae awa torain buro okain bé edo ara, ata torari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Iji da (1)de Mando Tutumi erido manguro be jiaina. Iji ainde imomane arapada petedo tatain jiveite dao tedo awa, ‘Badari, Badari, nakare embo manguro pirige!’ “Ata ami mina taina, ‘Na imomane gae! Yai nonda edo gumbevi?’ ");
INSERT INTO bhg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ango tari tuturo edo ge mina tawa, ‘Nakare imonde daedo besida indari injido kundo esitera. Edo inemi natokare nasida embomai atopapositeta.’ ");
INSERT INTO bhg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ata embo ami mina taina, ‘Na imomane gae! Yai nonda edo gumbevi? Dodo eve mambú! Imomane berari awa jimbo bebegae ari embomai!’ ");
INSERT INTO bhg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Edo iji ainde inemane Abraham de Isaac de Jacob de awamane ae peroveta mamatu berari de awa God da gisijiari yaida gido, edo imomane akuta awa ajiregari puwa ponda itawa, imomane ji site ji gambawo kitorukatoru taina. ");
INSERT INTO bhg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Embomai yai berari: iji vitarida, wotarida, edo idarida edo tawari kena, awamane gumbara. Edo God da gisijiari yai ainda anumbedo indari indara. ");
INSERT INTO bhg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ge bé, iji angode God mi tataimbari embo nenei jiari vitara dero ikaneda, edo dariga embo nenei piari wotara dero tuda.” ");
INSERT INTO bhg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Deguta dá ainde, Parasi mane nenei Yesu da yai gundo ainde sitera, “Daotari Herod mi imo dari betatate ge jijireira. Awatedo, yai eiwa dodo idegedo mambuyo!” ");
INSERT INTO bhg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","“Na embo awa adu ae!” ami mina sisina. “Imomane maundo embo abu sino inge ainde tewo gare, ‘Deguta boroko einde na emboda doda bineimane itari awa onena, edo karu egeregari gao eno kaviyegetera. Deguta boroko edo audo na buro ana. Edo deguta tamonde (3) ami, nato buro God mi avigesisina awa, itae ana.’ ");
INSERT INTO bhg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Awarata, aindabé awamanemi peroveta mane yai nenei ainda dae betae, ata Jerusalem nasida akuta, awatedo, na deguta boroko, edo audo, edo deguta amboda, matawa pepeta edo Jerusalem nasida daedo mamana. ");
INSERT INTO bhg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem embomai, Jerusalem embomai, imomane peroveta mane God mi pieuri gundo eora awa ganumami augedo deowo betora. Na iji jiwae imomane God da rirowada tonemain jipapa edo etena, teta ni kokora ai mi ainda wasimi mamai doregidaregi edo eira ango. Ata imomane na jipapa ae edo na ajiregetewa. ");
INSERT INTO bhg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Giwo! God mi imomane ajiregedo dowari nasi itomane usibesi ara. Edo nane imondemane ge eiwa tena, imomane na tekago mana gawa, nato iji gumbari tekago gumano gosite tawa, ‘God da ao ari embo einda yai itare! Embo eiwa BADARI da daoda gupeira!’” ");
INSERT INTO bhg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Edo Oena Apari Degutade, Yesu mi Parasi maneda badarari da (1), ainda mandoda indari inaintedo maunsisina. Edo toriri, awamane ainda yai jisi tatakitaki esitera, buriya ro ari ainde bekumba ge piaintedo. ");
INSERT INTO bhg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ango edo embo ipatai sirari awa Yesu da yai gupusina. ");
INSERT INTO bhg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Edo Yesu mi Aodarida jirogari embobo ae Parasi mane de ge site tedogosisina, “Moses da ge okain Oena Apari Degutade ainda awa nongo tariri, embo gao aro kaviyegorote tari isirita?” ");
INSERT INTO bhg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ata awamanemi ainde ge mina tae, damodamo esitera. Awatedo, Yesu mi embo ainda tamonda ipa pisido gao esiri kaviyegedo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ango edo ami awamanede tedogosisina, “Edo embo da (1) itomane doda ainda mai ko wo kao Oena Apari Degutade uro ugonubé barida duraina awa gido, ami boraebé maundo ainda topo uroda awa dumbari vitainita?” ");
INSERT INTO bhg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Edo awamanemi ainda ge mina tari tao ae esitera. ");
INSERT INTO bhg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Edo Yesu mi embomai nenei gundo awamane akuta embo babainda dero dave indari besida avigekavige edo budo anumbetero gosisina. Awatedo, ami awamanede eniya ge eiwa sisina: ");
INSERT INTO bhg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Iji nonde embo da (1)mi jimbari bondo siya edo imo dao tari maundo gido embo babainda dero dave indari besida anumain eote! Aindabé, bondo tutumi embo bajina imo daginegari dao tari gumbae esira, awatedo. ");
INSERT INTO bhg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Edo bondo tutumi imo aedade dao tesira ami gundo imonde taina, ‘Embo einde yai eiwa pie!’ Ango tari imo tuturo edo mengoteite wotedo dero tubéda anumbata. ");
INSERT INTO bhg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ata iji angode imo bondo jimbari maundo gido, dero tubéda anumbeyo! Ango ato bondo tutumi gundo imonde ge engo taina, ‘Otawo, dero awa dodo yai dave ikane einda visiyo!’ Ango siari embomai berari imonde bondoda itera ami gara, imo tou eira awa. ");
INSERT INTO bhg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Daedo eiwa giwo! Embo aimi ainda dao akuta jiari vitaina awa, God mi piari wotaina. Edo embo aimi ainda dao akuta piari wotaina awa, God mi jiari vitaina.” ");
INSERT INTO bhg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ango edo imo wareregedo mando tutu ainde sisina, “Iji nonde imo sipo rorae o turo rorae siya eite ito otatawo, nanonameji, simbo matomono, ritako nembu nenei gaiapa jiwaede jimbote! Ango ata awa, iji amboda, awamanemi imo mina jimbaro maundo indari dave indata. ");
INSERT INTO bhg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ata iji nonde imo bondo siya eite gido embomai mapa rorae isisigae, daguna ari, tai ambari, edo jisiguba ari awa jimbuyo gumbore. ");
INSERT INTO bhg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aindabé, awamane imonde mina ari tao ae, awatedo, God mi imo ao aina. Edo God mi embomai wasiri dambu darari jiari erara iji ainde, ito mina piari bata. ");
INSERT INTO bhg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Edo embo da (1) ainda ae Yesu de daedo besida anumbesisina ami ge awa ingido ainde sisina, “Dubodave awa embo aimi God da gisijiari yaida anumbedo turo rorae inaina.” ");
INSERT INTO bhg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Edo Yesu mi ainde ge mina sisina: “Embo da (1)mi bondo bajina siya eite embobo jiwae gumborote dao sisina. ");
INSERT INTO bhg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Edo bondo ari iji gumbiri, ainda buro embo piedo sisina, ‘Maundo embomai matu gumborote dao siutana, awamanede teyo, “Indari kumbari neindekainde berari matu siya etena, awatedo, gumbuwo indave!” ’ ");
INSERT INTO bhg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ata awamane berari kotembari evekara bureite tuturo edo daginegari ge sitera. Embo tuturoda buro embomi maundo gosisina, ami ainde sisina, ‘Na butu kupo da (1) orietena awa, maundo udugedo gain ena. Awatedo, doiyobé tena. Badarari tato gae esirita?’ ");
INSERT INTO bhg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Edo embo neimi sisina, ‘Na buro ari wo kao 10 teka orietena awa, kundo maundo bavedogain ena. Awatedo, doiyobé tena. Badarari tato gae esirita?’ ");
INSERT INTO bhg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Edo daedo neimi sisina, ‘Na aro borokobé jimena. Awatedo, na gumbari tao ae.’ ");
INSERT INTO bhg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ango tetero gido buro embo dodo egenembedo gundo ge ro berari sitera awa ainda badararide sisina. Edo badarari sinigambiri ainda buro embode sisina, ‘Burigibé mambuyo! Ango maundo nasi bajinada begata babainde babaingaededa embomai mapa rorae isisigae, daguna ari, tai ambari, edo jisiguba ari, awamane kundo gumbato einda torore.’ ");
INSERT INTO bhg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ainda amboda, buro embo maundo buro ro arate sisina awa itae edo egenembedo gundo sisina, ‘Badarari, buro ro anate ge okain teteta, awa kera edo itae etena. Awarata, tonga inono embo nenei torara awa isira.’ ");
INSERT INTO bhg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Edo badararimi buro embode sisina, ‘Nasi arapada idegedo mambuyo! Begata bajinada edo tonga erari begata beda embomai kakowa edo tamundo ge davemi engega ato eraro kundo gumbato torore! Ango ato embomi mando nato siraro beda are. ");
INSERT INTO bhg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nane imondemane tena, embomai berari tuturoda dao siutana awa, mana bondo nato indara.’” ");
INSERT INTO bhg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Edo iji angode, embomai jisijisi Yesu de daedo pepeta edo mauntero imo wareregedo awamanede sisina: ");
INSERT INTO bhg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Edo embo aimi nato yai gumain eira awa, nato ambodani ari tao ae, ata edo gido imo na dubobé daginegedo baina awa ainda aimamo, aro ae mamai de, nanonameji, ru aimono, edo daedo ainda wasiri akuta dubobureira ango. ");
INSERT INTO bhg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Edo embo da aimi ainda memesida orega bouga kumbae dodo na ambo ambo aina awa nato ambodani ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Imomane embo da aimi ainda oro ribori ikanebé gamain jipapa aina awa, gisibé anumbedo inguta manguta inono rita awa udugedo gaina. Edo awa inono gido ami buro itae aina. ");
INSERT INTO bhg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Edo imo dasivi darido buro itae ae dowato itaina awa, embo berarimi gido imo tuturo edo tedojijireite tara, ");
INSERT INTO bhg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Embo eiwa ainda oro ribori gamain tuturo esira, ata buro awa itae ari tao ae.’ ");
INSERT INTO bhg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Edo daedo, daotari da (1)mi ainda itoro embo ajijigari 20,000 aundo daotari nei ainda itoro embo ajijigari tepo 10,000 ainde duduno ain gumaina, gisibé daotari neimi anumbedo isite ainda embobode ge kataina, edo imo inono ainda embo ajijigari 10,000 ami ainda gitopoda embo ajijigari 20,000 ainde duduno edo daginegainita? ");
INSERT INTO bhg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Imo ango ari tao ae gido, ami burigibé ainda béga bari embomai piari maundo begata toropuda daotari nei tamundo béga bari ge tedogara. ");
INSERT INTO bhg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Awatedo, dá ango imomane berari, embo da aimi ainda topobé awa berari gun jindedo dowae eira gido, awa nato ambodani ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ambodanibé awa kato ango embomaimi indarida pisido ainda gavida mina dave budo era. Awarata, katoda gavi sisigaina awa, ainda gavida mina bari tekago piari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Edo dá ango ainda butu gavi piari awa dave ae. Awatedo, embomaimi rorae awa tepo nasi arapada augara. “Ingiwo! Imomane ge ro tena awa bé gain edo awa gawa!” ");
INSERT INTO bhg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Edo iji angode, tax kumbari embo jiwaebé ae embo bebegae de guputera Yesu ge sira awa ingain. ");
INSERT INTO bhg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Edo Parasi mane ae Aodarida atopapasigari demi ge guguma gaguma sitera, “Embo eiwa embo bebegae oro site budo awamanede indari injido kundo eira.” ");
INSERT INTO bhg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ango tero gido Yesu mi awamanede eniya ge eiwa sisina: ");
INSERT INTO bhg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Awaratako imomane embo da (1)mi, ainda wo sipumane ajigari 100 awa, da (1) dadoegari, imo nongo aini? Ane boraebé nenei ajigari 99 awa kiyan indorote dodo, imo maundo da (1) dadoegesira awa kakowa eimango tamaina. ");
INSERT INTO bhg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Edo iji nonde tambira awa, yawa eite ainda gapoda piari durari kundo ");
INSERT INTO bhg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","overegedo nasida gumaina. Edo otatawo ainda ae nembu ainde dao tari gundo doregaro awamanede taina, ‘Nato wo sipu da (1) dadoegatara awa tamena. Na yawa ena. Kaende nya taiore!’ ");
INSERT INTO bhg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nane imondemane tena, dá ango yawa ari bajinabé owamane utuda ara, edo embo da (1) bé ainda jimbo dodo God da yai wareregaina, gaegae edo embo wasiri dambu darari ajigari 99, awamaneda jimbo itae, edo God da begatada dodo yai neinda aimbae. ");
INSERT INTO bhg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Edo daedo, eutu da ami ainda ganu silver babaingae 10 ainda da (1) dadoegaina, awa nongo aini? Eutu awa keimo ijimbedo ainda mando do wadedo, wotedo dutu wadedo gain kakowa eimango tamaina. ");
INSERT INTO bhg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Edo iji nonde tambira awa, ainda otatawo ae ainda nembu de dao tari gundo doregaro awamanede taina, ‘Nato ganu saka da (1) dadoegatana awa tamena. Na yawa ena. Kaende nya taiore!’ ");
INSERT INTO bhg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nane imondemane tena, dá ango awa, God da anelamaneda doda yawa ari idegaina, iji nonde embo da (1) bé aimi jimbo beyae dodo God da yai wareregaina awa.” ");
INSERT INTO bhg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Edo Yesu mi tedo sisina: “Embo da (1) awa ae ainda mamai tote (2) de isiretera. ");
INSERT INTO bhg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Deguta da (1)de mai sakami ainda mamode sisina, ‘Mamo, imo betae gisida nato gaiapa ine na embo siya esiteta awa piato banita.’ Ango tesiri, embo awa erido ainda gaiapa mamai tote (2)de avigekavige esisina. ");
INSERT INTO bhg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ango esiri ainda amboda iji indewae itae esiri, mai saka awa ainda rorae berari dada edo budo idegedo yai aikeda maunsisina. Edo imo maundo ainda ganu tepotapo jigamo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Edo ganu berari jigamo esiri itae bé itae esiri, ainda amboda, potari iji visiri yai ainda beji bajinabé gupusina. Edo embo ainda yai nei ro itae doturisina. ");
INSERT INTO bhg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Awatedo, imo nasi tutu embo da (1) ainda yai maunsisina, ainda buro embo ain. Edo nasi tutu embomi mai awa ainda pumane sima arate piesiri ainda bowada maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Edo imo beji betain edo pu undeite pita pusi inaina ango kotembesisina, ata embo da aimi ainde indari piae. ");
INSERT INTO bhg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ainda amboda, mai awa isite kotembari dave budo, ami sisina, ‘Mamo natoda buro emboboda tau piedo eira, awamane indari kumbari jiwaebéde, ata na einda beji betain eite itena! ");
INSERT INTO bhg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Na boroko erido maundo mamo natode tana, “Mamo, na God da yai edo ito yai jimbo beyae esitena. ");
INSERT INTO bhg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na dave ae. Awatedo, ine namonde ‘Mai nato’ teote. Tepo ito buro embo ango buwasi.” ’ ");
INSERT INTO bhg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ango tedo imo erido tuturo edo overegedo maunsisina ainda mamoda yai. “Edo mai awa maundo mandoda atutumbae saka aikeda eiri ainda mamo jisi piedo gosisina. Edo imo do ari bajina bureite tumundo mai awa boraebé tanjido munegesisina. ");
INSERT INTO bhg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ango esiri maimi ainde sisina, ‘Mamo, na God da yai edo ito yai jimbo beyae esitena. Na dave ae. Awatedo, ine namonde “Mai nato” teote.’ ");
INSERT INTO bhg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ata mamomi ainda buro embobo dao tesiri gumbero awamanede sisina, ‘Mambuwo, ombari ribori davebé dave kundo gundo mai einde piawo ombare. Edo ipa bubuko ainda ipa toroda piedo tai woru ainda taida piave. ");
INSERT INTO bhg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ango edo maundo wo kao vete gavide awa budo kundo gundo dewo betari, nya taiawo embo einde indeite kaende dubodave ore. ");
INSERT INTO bhg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Aindabé, mai nato eiwa betari ango sitena awa tekago wasiride gumbira; edo dadoegesisina awa tamena awatedo.’ Ango edo dubodave eite bondo tuturo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Edo iji angode mai bajina awa rorae ve urari buroda maundo eiri jiriri overegedo gundo mando aikae eite embomai ya urari ae sino de to deda yavi ingisina. ");
INSERT INTO bhg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Awatedo, imo buro embo da (1) dao tesiri gumbiri ainde tedogosisina, ‘Yavi owa nongo eri?’ ");
INSERT INTO bhg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Edo buro embomi sisina, ‘Ito nameji saka awa overegedo nasida gumbira. Edo aindabé ito mamomi embo awa beyae nei ro tambae tekago kumbira, awatedo, mamo itomi wo kao vete gavide awa desiri indari bajinabé era.’ ");
INSERT INTO bhg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ango tesiri nameji bajina sinigambari edo imo mandoda torari jipapa ae esisina. Awatedo ainda mamo idegedo gundo mai maundo torarate engega esisina. ");
INSERT INTO bhg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ata mai bajinami ainda mamode engo sisina, ‘Giyo! Na duberi berari eiwa tau itae, buro embo ango, ito ge ro berari tedo eta awa, kera eite gundo borokoda. Ango iretena awa, imo namonde wo gouti vete da (1) piae dedo, nya taiedo ae, otatawo nato de injido dubodave ae. ");
INSERT INTO bhg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ata iji einde imo mai emi ito ganu tepotapo viro eutude jigamo edo itae esiri overegedo gumbiri, wo kao awa vete gavide awa embo dedo nya taieta.’ ");
INSERT INTO bhg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Edo mamomi ainde sisina, ‘Mai nato, imo awa iji berari namonde isima edo eta. Awatedo, rorae berari nato yai isira awa ito. ");
INSERT INTO bhg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ata, aindabé nameji ito eiwa betari sitena awa wasiride gumbira, edo dadoegesisina awa boroko tamena, awatedo, dave awa kaende jivedo putedo injido kundo eite dubodave ore.’” ");
INSERT INTO bhg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ango edo Yesu ainda ambodanide eniya ge nei engo sisina: “Iji da (1)de rorae embo da (1) ami gisijiari avigesisina, ainda gaiapa sima arate. Edo ainda amboda embo neneimi gundo rorae embode, ‘Embo awa ito gaiapa sima ae dumbae eira,’ ango tedo bekumba esitera. ");
INSERT INTO bhg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Awatedo, rorae embomi ainda buro embo dao tesiri gumbiri ainde sisina, ‘Imo buro nongo nongo eto embo neimi imo bekumba ero ge ingeni? Buro nongo esi awa ove gaiedo pieyo gane! Imo gisijiarida buro dodo idege!’ ");
INSERT INTO bhg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ango tesiri buro embomi akuta tedo sisina, ‘Na buro ro ani? Badarari natomi buro natoda teugaina awa. Na goroba itae. Nanemi butu durari tao ae. Edo na embo neinde ganu piorote atega ana, awa mengari nato. ");
INSERT INTO bhg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Awara, na kotembari dave bena. Edo gido engo ana, iji nonde nato badararimi na buro natoda teugari idegano, embomai neneimi na “Oro” tedo bara awamaneda mandoda.’ ");
INSERT INTO bhg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Edo imo embo ainkaimi ainda badararida roviravi tepo kundo jigamo esitera, awamane berari dao tesiri guputera. Edo embo gisi gupusina ainde tedo gosisina. ‘Imo badarari natoda rorae mina piae nandogo tepo budo jigamo eutasi?’ ");
INSERT INTO bhg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Edo embo gisi gupusina ami mina sisina, ‘Na ni olive beda gama sigi babaingo 100 awa gerigari beda ari burana.’ “Awatedo, gaiapa sima ari embomi ainde sisina, ‘Awara, ingota ito eire kundo anumbedo 50 gaieyo.’ ");
INSERT INTO bhg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ango edo embo nei gumbiri ainde sisina, ‘Imo badarari natoda rorae nandogo tepo budo jigamo eutasi?’ “‘Na wheat kanjia babain 1,000 burana,’ embo neimi ango sisina. “Edo gaiapa sima ari embomi sisina, ‘Awara, ingota ito eire kundo anumbedo 800 gaieyo.’ ");
INSERT INTO bhg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Edo badararimi wasiri awa gido gaiapa sima ari embo dambu darae awa dasiga esisina, aindabé, ami ainda jirogari jigamo edo buro esisina. Ge engo tena, aindabé, iji einde butu embomaimi awamaneda jirogari jigamo jiwae eite buro edo era, ata God da embomaimi tepo awamaneda jirogari jigamo saka eite buro edo era. ");
INSERT INTO bhg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Edo nanemi imondemane tena, itomane butu gaiapami, otawo teteka bawate, ango buro ewo. Edo ango awa, iji nonde imomane betedo utuda mambawo awamanemi imomane ategesite bara, natopo itari nasi ainda. ");
INSERT INTO bhg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Edo embo aimi rorae sakabé awa gebémi jigamo aina gido, embo awa rorae bajina awa inono jigamo aina. Edo aimi rorae sakabé awa jigamo ae dumbae aina gido, embo awa rorae bajina awa inono gebémi jigamo ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Awatedo, gaiapa butu einda jigamo ae dumbae edo ewa gido, God da gaiapabé natopo itari utuda awa mana imondemane piaina. ");
INSERT INTO bhg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Edo imomane embo neinda rorae jigamo ae dumbae edo ewa, embo aimi rorae itomane topobé imondemane piaini? ");
INSERT INTO bhg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Buro embo da (1)mi badarari tote (2)da buro iji dá ainde ari tao ae. Embo awa ainda badarari nei jipapa ae eite neinda dubobudo aina, ko ami ainda badarari nei tou eite neinde sinigambari edo aina. Inemane God ae butu gaiapa de tumondebain ari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Edo iji ainde Parasi mane ganu dubobudo esitera, awamane yai ainda isite Yesu ge berari sira awa gido imo tedo jijiritera. ");
INSERT INTO bhg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ata embo ami awamanede sisina, “Imomane emboda jisida wasiri dambu darari ango edo ewa. Ata God mi do itomane gido eira. Awatedo, imomane ajiregaina. Dave rorae ango embomi kotembedo era awa beyaebé God da jisida. ");
INSERT INTO bhg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Edo Aodarida ae Peroveta maneda Ove Gaiari de awa matawa isiri John Bapataito Ari Embo gupusina. Ainda edo, God da gisijiarida bino dave awa karigedo era. Edo embo jiwaebé awa ingido God da gisijiarida torain mina mita edo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Awarata giwo! Utu de butu de awa manaina, ata God da Aodarida ge saka da (1) bé awa mana siraina. ");
INSERT INTO bhg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Edo embo da aimi ainda arode ove engo ‘Jimbari itae ena’ gaiedo ainda aro dowari mambari eutu nei jimaina, embo awa jimbo ipuda ari ainda aro matuda yai esira. Edo embo da aimi eutu nei iu dowari jimaina, embo awa jimbo ipuda ari ainda iu matuda yai esira. ");
INSERT INTO bhg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Awara, gaiapa embo da (1) isinesina. Ami ombari jiari tokona virarae mina babain piedo bari awa omundo iji berari injido kundo eite dubodave edo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Edo daedo, iji angode awa, mapa embo da (1) isinesina. Ainda dao awa Lazarus, edo embo awa ginimi tutupegari. Iji berari ainda otatawomi kundo maundo embo gaiapade ainda manguro beda kondade ari atega ain pioro isima edo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Edo imo gaiapa emboda tenemba indari itoto durari awa, inain jipapa edo esisina. Ango isiuri sinomanemi gundo ainda gini mamatu taribo eora. ");
INSERT INTO bhg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ango edo, mapa embo awa betesiri God da anelamanemi kundo maundo Abraham da demonda pipisitera. Edo gaiapa embo daedo betesiri goitera. ");
INSERT INTO bhg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Embo awa goietero imo bebetegarida sima ari yai, niyao matawa aveira, ainda maunsisina. Edo imo yai ainda isite memesi bajinabé bureite jisi piedo da aikeda Abraham gosisina. Edo daedo Lazarus aikae Abraham da demonda isiri gosisina. ");
INSERT INTO bhg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Awatedo, embo ami Abraham dao tedo sisina, ‘Mamo Abraham, niyao emi na aveira, edo memesi beyaebé burena. Na do ewasi! Lazarus pie, ainda ipa toromi un saka jimundo kundo gundo iwawa natoda piari damodamo are.’ ");
INSERT INTO bhg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ata Abraham mi mina sisina, ‘Mai nato, kotembeyo, iji angode imo butuda isima esiteta awa, rorae davegave budo esiteta. Ango eiwoto Lazarus awa rorae bebegae budo esisina. Ata embo awa boroko kondade ari dave bureira, edo imo memesi beyaebé bureta. ");
INSERT INTO bhg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Awarata, nei da (1), aindabé, God mi yai tonga kapari ugonubé pipisisina toropu nakare itera einda edo imomane ainda, na imo kondade ari tao ae ena. Awatedo, embo da aimi nakare itera einda isite imomane ainda maundo tembari tao ae, edo embo da aimi imomane itewa ainda isite nakare einda gundo tembari tao ae.’ ");
INSERT INTO bhg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Edo gaiapa embomi sisina, ‘Aiyaee! Mamo Abraham, ango teta awatedo, Lazarus piewasi mamo natoda mandoda mambare. ");
INSERT INTO bhg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Aindabé, nato nanonameji ipa da (5) ounda itera, awamane ge tari gore. Buro beyae nane eona, edo memesi beyaebé bari yaida gumena itena, engo eóre!’ ");
INSERT INTO bhg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ango tesiri Abraham mi ge mina sisina, ‘Awamane itera ainda Moses da Gaiari ae Peroveta mane deda Ove Gaiari, embomi ajigedo tera, ami awamane inono atopatari gara.’ ");
INSERT INTO bhg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ami sisina, ‘Ango ae Mamo Abraham! Ata, edo embo da (1)mi bebetegarida edo maundo awamanede ge taina, awamaneda beyae dodo God da yai wareregara.’ ");
INSERT INTO bhg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ata Abraham mi gaiapa embode sisina, ‘Edo awamanemi Moses ae Peroveta mane deda Gaiari, embomi ajigedo tera, awa ingainyae, edo bebetegarida embo da (1)mi erido maundo awamanede ge taina, awamane daedo gebé ainyae.’” ");
INSERT INTO bhg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ango edo Yesu mi ainda ambodanide sisina, “Rorae neindekaindemi euri embo jimboda durudo era. Ata, embo do ari aimi embo nei bawari jimboda duraina. ");
INSERT INTO bhg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dave da (1) awa embo ainda duboda ganuma bouga bajinade kaingedo ewada augaro injido betaina, gaegae edo embo ami ari mamai babaingae einda da (1) gebé ari nato yai awa dowaina, God da rirowa natopo itari baina. ");
INSERT INTO bhg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Awatedo, imomane akuta dave edo goteite iwo! “Ito nameji jimbo ari gido, ainde kondade ari ge okain teyo. Edo ainda do wareregari gido, awa kotembedo doyo. ");
INSERT INTO bhg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Edo ami deguta dá ainde imonde jimbo beyae ajigari 7 aina, edo ami ito yai, ajigari 7 deguta dá ainde gundo taina, ‘Doyo tena, na imonde wasiri beyae engo etena. Imo tedogotena, na kotembedo dowasi?’ Ango tari gido, embo awa kotembedo doyo.” ");
INSERT INTO bhg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Edo piari aimbari embobomi Badari de sitera, “Nakare kondade ewasi natokare gebé ari awa badare!” ");
INSERT INTO bhg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ango tetero Badari mi mina sisina, “Edo itomane gebé ari tegada maine vero saka ango gido, awa inono ni bajina eiwa tawo ge itomane kera edo akuta tutude utugedo wotedo ewada petaina.” ");
INSERT INTO bhg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu mi daedo sisina, “Imomane da aimi buro embo ainda, awa indari buroda buro eima ta wo sipumane sima eima, iji nonde mandoda gumbari ainde tainyae, ‘Einda anumbedo indari ito injiyo!’ ");
INSERT INTO bhg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ango ae. Ata ami buro embode taina, ‘Turo indari nato taieyo! Ango edo ombari teka omundo na kera eiato indari injido kundo ane! Ainda amboda, imo daedo indari ito indate.’ ");
INSERT INTO bhg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aindabé buro embo awa buro ro arate ge okain tesira awa ambo ambo eira, badararimi ainda buro embo ategae. ");
INSERT INTO bhg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Edo dá ango, iji nonde imomane God da ge kera edo ro berari awate tesiri etewa awa, inemane tewo, ‘Nakare awa tepo buro embo. Nakare tepo buro ro orote God mi tesira, awa etera.’” ");
INSERT INTO bhg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ango edo Yesu ae ambodani de pepeta eite yai Samaria edo yai Galili da toropuda pepeta edo maundo Jerusalem kena maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Awamane nasi neinda totorero, embo ajigari 10 ginimi tutupegari gundo begata demonda pepositera. Awarata, aindabé Judah embomainda aodari awa embo karu engogodemi embomai karu itaededa yai aikae mamborekae, awamane saka aikeda pepositera. ");
INSERT INTO bhg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Edo dao ikanadebé tedo sitera, “Yesu, Badarari, nakare do edo e kaviyegore!” ");
INSERT INTO bhg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Edo iji ainde Yesu awamane gido ami sisina, “Mambuwo pirisi maneda yai. Ango awo imomane gore. Edo awamane gara awa imomane kaviyegari bewa.” Ango tesiri awamane ainda maunsite, kaviyegari buritera. ");
INSERT INTO bhg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ango edo embo ajigari 10 ainda doda embo da (1)mi ainda tamoda gini mamatu itae awa gosisina. Edo imo kaviyegari bira ango gido, egenembedo God ikanadebé dasiga esisina. ");
INSERT INTO bhg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Edo imo atoto edo Yesu da taida dudureite imo ategesisina. Edo eiwa Samaria embo. ");
INSERT INTO bhg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu mi embo nenei demonda itera ainde sisina, “Embo ajigari 10 awa eteno kaviyegetera. Embo nenei ajigari 9 awa nondari? ");
INSERT INTO bhg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Judah embo ae, emi akuta tenda overegedo God dasiga ain gumbirita?” ");
INSERT INTO bhg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Edo Yesu mi ainde sisina, “Erido pepeta edo mambuyo! God mi ito gebé ari nato yai pieteta ami imo esiri kaviyegeteta.” ");
INSERT INTO bhg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ango edo iji da (1)de Parasi manemi Yesu de tedogari pipisitera, “Ijibé nonde God da gisijiari tuturo aini awa?” Ami awamanede mina sisina, “God da gisijiari iji nonde tuturo aini awa imomane jisimi dave edo gari tao ae, ");
INSERT INTO bhg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","aindabé giu! God da gisijiari itomane toropuda isira. Awatedo, embomaimi ge tari tao ae, ‘Giwo! God da gisijiari eire!’ o ‘Giwo! Awa oure!’” ");
INSERT INTO bhg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Edo Yesu mi ainda ambodanide sisina, “Iji amboda gumaina awa okain. Deguta angode inemane na, Embo da Mai, tekago gundo embo berari gisijiana, awa gain jipapa awa, ata, imomane na gari tao ae. ");
INSERT INTO bhg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Edo embo neneimi imondemane tara, ‘Giwo! Embo awa eire!’ o ‘Giwo! Awa oure!’ Ango taro gido gebé edo awamane ambo ambo eove. ");
INSERT INTO bhg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Edo na ge ango tena aindabé, dá piripiri ari ango burigibé maundo parara piari utude butude berari ainda datemaina, deguta ainde na, Embo da Mai, gumano embo berarimi na gara. ");
INSERT INTO bhg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ata iwata ango gumbae gisida awa, na memesi neindekainde jiwae bana. Edo embomai iji einda itera ami na ajiregara. ");
INSERT INTO bhg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Edo Noah da degutade, wasiri ro embomi edo esitera, dá ango awamanemi eiaro deguta ainde na, Embo da Mai, gumana. ");
INSERT INTO bhg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Iji matubé ainda embomaimi indari injido kundo eite, aro jipeiri, iu jipeiri, ango ero, deguta gumbiri Noah un ma bajina, dao aki tedo esitera, ainda totorisina. Edo un dauma gundo embo berari mada torae, awa usibesi esisina. ");
INSERT INTO bhg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Awa dá ango Lot da degutade. Embomaimi indari injido kundo eite, roviravi mina piya edo ori eite, indari ve uredo eite, oromando gamundo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ata deguta ainde Lot ae ainda orobe de nasi Sodom awa dodo idegetero, God mi esiri niyao ae ganuma beriberi eiri ainde utuda edo wotedo, embo berari nasi ainda Lot mi doturisina awa usibesi esisina. ");
INSERT INTO bhg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Dá ango rorae berari awa matu dá isima edo esisina ango, embo awamaneda udojipapa eiaro deguta nonde na, Embo da Mai, tekago butuda gumana. ");
INSERT INTO bhg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Aindabé, iji inono itae deguta ainde, embo da ave ainda garauda isira, ami tumundo torido ainda gaiapa mando doda awa bari tao ae. Dá ango, embo ave ainda indari buroda eira, ami tenda egenembedo maundo ainda mandoda rorae da ro bainyae. ");
INSERT INTO bhg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot da aro buro ro esisini awa kotembewo! Imo God kera ae wareregedo Sodom nasi awa jisimi gosisina. Awatedo imo boite besisina. ");
INSERT INTO bhg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Embo da aimi ainda wasiri toregain jipapa aina, awa dadoegaina. Edo embo da aimi ainda wasiri dadoegaina, awa toregedo dedegaina. ");
INSERT INTO bhg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na imondemane tena, muyaende awa arode iude besida dada aviaro, God mi da (1) budo nei dowaina. ");
INSERT INTO bhg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Edo eutumai tote (2) awa aedade indari siya eiaro, God mi eutu da (1) budo nei dowaina. ");
INSERT INTO bhg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Edo embo tote (2) awa aedade indari buroda eiaro God mi embo da (1) budo nei dowaina.” ");
INSERT INTO bhg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ango tesiri ambodanimi tedogositera, “Badari, yai nonda idegaini?” Edo ami awamanede sisina, “Yai nonda betari tamo isira. Ni barupimane yai ainda dada aro gawa.” ");
INSERT INTO bhg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ango edo Yesu mi eniya ge da (1) sisina ainda ambodanide, ami atopatari awamane iji berari benunu torote edo do durainyae. ");
INSERT INTO bhg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ami sisina: “Nasi da (1) ainda buriya katari embo isima edo esisina. Embo awa God tou ari itae edo daedo emboda buro ro jipapa era awa kondade ae edo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Edo daedo nasi ainda eutu rori isima edo esisina. Edo ainda gitopo embomi ainde jimbo beyae esisina. Awatedo, eutu ami buriya katari emboda yai gundo tedo esisina, ‘Bouga nato eiwa inemi ato dambu dararate jipapa ena, nato gitopo emboda yai.’ ");
INSERT INTO bhg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Edo iji nenei ango awa, imo buro ari jipapa ae esisina. Ata ainda amboda, imo akuta kotembesisina, ‘Na God tou ae, emboda jipapa kera ae edo ena. ");
INSERT INTO bhg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Awarata, aindabé, eutu rori owa iji matawa nato yai gundo ge teuri dengoro memesi edo eira, awatedo, kondade ano ainda jipapa dambu daraina!’” ");
INSERT INTO bhg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Edo Badari mi sisina, “Davebé edo ingiwo buriya katari embo beyae omi ro sisini. ");
INSERT INTO bhg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Edo God mi ainda gerari mamaimi katari ro, sipode turode dambu dararate benunu tedo era awa ae, dowainita? ");
INSERT INTO bhg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nane imondemane tena, God mi awamane katari ro dambu dararate tedo era awa burigibé aina. Ata na, Embo da Mai, tekago overegedo butuda gumana amo, embomi na bé tumonda eite itera ango tamanita?” ");
INSERT INTO bhg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Edo daedo, Yesu mi eniya ge nei eiwa sisina, embomai aimi awamane akuta wasiri dambu darari God da jisida edo era site, embo nenei jisi tuda edo gido era ainde. ");
INSERT INTO bhg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ango tedo sisina: “Embo tote (2) Judah embomainda oro kotopu bajinada visido maunsitera, God da yai benunu tain. Embo da (1) awa Parasi edo nei awa tax kumbari embo. ");
INSERT INTO bhg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Edo Parasi petedo imo akuta benunu engo sisina, ‘God na imo ategetena awa, na embo nenei ango ae. Na motou aede, na buro bebegae aede, edo na ipuda aede. Na imo ategetena awa, na embo oure, ganu kumbari embo ango ae. ");
INSERT INTO bhg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na pura da (1) ainda doda, iji tote (2) awa indari indae veta edo ena. Edo rorae berari na budo ena, ainda ajigari 10, awa avigedo da (1) imonde piedo ena.’ ");
INSERT INTO bhg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ata tax kumbari embo awa aikamanabé peposisina. Ami inonobé ae iji tupobé pangedo jisi utuda piari. Ata ainda ipa umbutu edo opopoda doreite sisina, ‘God, na, jimbo beyae embo, do ewasi!’” ");
INSERT INTO bhg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Edo Yesu mi sisina, “Nane imondemane tena, benunu tedo itae edo mandoda maunsitera ainda amboda, tax kumbari embo awa wasiri dambu darari God da jisida. God mi embo ainda jimbo beyae kotembedo dosiri itae esisina. Ata Parasi ae. Awatedo, embo aimi ainda dao akuta jiari vitaina awa, God mi piari wotaina. Edo embo aimi ainda dao akuta piari wotaina awa, God mi jiari vitaina.” ");
INSERT INTO bhg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Edo daedo embomaimi Yesu da yai mamai amibeda awa kundo guputera ami ipa tamonda piedo benunu tarate, God da ao ari awa embo. Ango ero ambodanimi awa gido ango eorekae aimamo isimbesitera. ");
INSERT INTO bhg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ata Yesu mi mai babaingae dao tedo ainda yai gumborote tedo sisina, “Mai babaingae engiregeove! Dowo, nato yai gumbore. Aindabé, embo God tumonda edo era dá mai babaingae engogo awa God da gisijiarida itera. ");
INSERT INTO bhg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Awara! Ge ro boroko imondemane tena, eiwa giwo! Embo da aimi God mi gisijiarate jipapa eira awa, ainda gumbari ategedo kumaina, dá mai saka ango. Edo ango ainyae gido awa, God da gisijiarida mana toraina.” ");
INSERT INTO bhg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Edo Judah embomainda gisijiari da (1)mi tedogosisina, “Atopatari, imo awa embo dave. Na buro nongo edo awa wasiri natopo itari bani?” ");
INSERT INTO bhg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Edo Yesu mi embo ainde sisina, “Ro awa embo na dave tesi? Embo berari awa dave da (1) itae, ata God akuta. ");
INSERT INTO bhg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Imo God da ge okain berari sisina awa gari: ‘Ipuda eote, dato beteure, beono eote, ge pitawa teote, ito aimamo tou edo eyo.’” ");
INSERT INTO bhg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ango tesiri embo ami mina sisina, “Na tuturoda mai sakade ge okain berari teteta awa kera eite gundo boroko matawa eite itena.” ");
INSERT INTO bhg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iji ainde Yesu ge awa ingido ami embo ainde mina sisina, “Imo buro da (1) bé isira awa ata. Ito rorae berari awa pieyo embo neimi oriaro ganu awa kundo maundo embomai rorae isisigaede avigekavige edo piate, edo gaiapabé utuda bata. Ango edo gumbuyo, na ambo ambo ate.” ");
INSERT INTO bhg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ata embo awa gaiapa jiwaede, awatedo, iji ainde ge awa ingido imo duboveverabé esisina. ");
INSERT INTO bhg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ango edo Yesu embo awa duboveverabé eiri gido sisina, “Embomai gaiapa jiwaedemi God da gisijiarida torari awa okain bé tambara! ");
INSERT INTO bhg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Edo wo bajina kamelo mi gongo gaiari ninou toda torari okain tamaina gido, gaiapa embomi God da gisijiarida torari bé okain bé tamaina.” ");
INSERT INTO bhg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Edo embomaimi ge awa ingido tedogositera, “Embo bé aimi God da tonembari baini?” ");
INSERT INTO bhg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ango tetero Yesu mi sisina, “Buro ro embo enembomi ari tao ae awa, God mi ari tao.” ");
INSERT INTO bhg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Edo Peter mi sisina, “Giyo! Nakare rorae berari dodo guputera, imo ambo ambo edo era.” ");
INSERT INTO bhg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ango tesiri Yesu mi awamanede sisina, “Awara! Edo ge ro boroko imondemane tena, eiwa giwo! Embo da aimi ainda mando, aimamo ae nanonameji de, ritako aro ae mamai de dodo God da gisijiari awa embo maunsira awa, ");
INSERT INTO bhg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","embo ami iji borokoda rorae jiwaebé jiwae baina. Edo iji amboda gumaina ainde, ami wasiri natopo itari baina.” ");
INSERT INTO bhg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ango edo Yesu ainda embobo 12 awa kundo demonda doregedo sisina, “Giwo! Kaena awa Jerusalem vivitera. Edo ro berari Embo da Mai da yai peroveta manemi gaguritera awa gundo bé aina. ");
INSERT INTO bhg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Edo na kundo yai nei embomainda ipada piaro namonde tedojirari ge tara. Edo awamanemi ge butari tedo na kosiwa ara. ");
INSERT INTO bhg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Edo na vededo daro betana. Ango aro deguta tamonde (3) ainda awa, na tekago erana.” ");
INSERT INTO bhg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ata ambodani, ge ro berari sira awa awamaneda yai arapa ae. Ge sira, ainda mokabé onjigesisina, awatedo, gain daritera. ");
INSERT INTO bhg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ango edo Yesu ae embobode gundo Jeriko nasi aikae ero, embo jisiguba ari da (1) awa begata demonda anumbedo ganu benunu site isiri guputera. ");
INSERT INTO bhg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Iji ainde embo jiwaebé gundo imo daginegedo maunsite ge tera awa ingido ami tedogosisina, “Eiwa buro rori? Tewavi gane.” ");
INSERT INTO bhg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ango tesiri awamanemi ainde sitera, “Yesu Nasaret Embo ami gundo imo daginegesite maunsira.” ");
INSERT INTO bhg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Edo embo ami dao sisina, “Yesu, David da Mai, na do ewasi!” ");
INSERT INTO bhg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Edo avekave gisi mauntera ami, embo awa isimbedo ge dowarate sitera. Ata embo ami ikanadebé dao tedo esisina, “David da Mai, na do ewasi!” ");
INSERT INTO bhg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Awatedo, Yesu petedo dapisina, edo ge okain sisina, embo jisiguba ari awa ainda yai kundo gumborote. Iji nonde embo awa kundo gundo aikae atutumbetero, Yesu mi embo ainde tedogosisina, ");
INSERT INTO bhg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nane imonde buro ro anate jipapa esi?” Edo ami sisina, “Badari, na ine ato jisi dave ari yai gain tena.” ");
INSERT INTO bhg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Edo, Yesu mi ainde sisina, “Awara, jisi gundedo yai gi! God mi ito gebé ari nato yai pieteta ami imo esiri kaviyegeteta.” ");
INSERT INTO bhg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Edo burigibé ainda jisi dave esiri Yesu da amboda maunteite God dasiga esisina. Edo iji nonde embomai berari buro awa gido, awamane daedo God dasiga esitera. ");
INSERT INTO bhg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ango edo Yesu Jeriko nasida torido matawa pepeta eite maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nasi ainda embo da (1) isinesina. Ainda dao Zacchaeus. Embo awa tax kumbari emboboda gisijiari. Edo embo awa gaiapa jiwaebéde. ");
INSERT INTO bhg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Embo ami Yesu averi awa gain jipapabé esisina, ata imo tupo sakabé edo embomai jisi bajinabé doregesitera. Awatedo, embo awa Yesu gari tao ae esisina. ");
INSERT INTO bhg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ata, imo goteira, Yesu begata awa budo maunsira, awatedo, Yesu gumbae gisida imo tumundo maundo ni dugada ainyedo vivisisina, ainda isite Yesu gumbari gain. ");
INSERT INTO bhg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Edo Yesu gundo yai nonda Zacchaeus isiri ainda edo imo pangedo embo awa gido sisina, “Zacchaeus, woteyo burigibé. Na tumba boroko awa ito mandoda awana.” ");
INSERT INTO bhg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ango tesiri Zacchaeus dubodavemi do ato ae esiri burigibé wotedo Yesu ainda mandoda jipusina. ");
INSERT INTO bhg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ango edo embomai berari doregesitera ami buro awa gido guguma gaguma sitera, “Embo beyaeda mandoda Yesu itain mambira.” ");
INSERT INTO bhg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ata, Yesu ainda mandoda gumbiri, Zacchaeus erido petedo Badari de sisina, “Ingiyo Badari! Na imonde tarigari tena. Nato gaiapa kupo awa embomai rorae isisigaede piana. Edo embomai udumbedo ro budo esitena, awamaneda gaiapa mina tega inono ipa ao pasido (4) piano bara.” ");
INSERT INTO bhg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Edo Yesu mi embo ainde sisina, “Aindabé, ito tumonda ari God da yai pieteta dá Abraham mi God tumonda esisina ango, God da tonembari boroko gumbira imo ae embomai mando einda itera aindeda yai. ");
INSERT INTO bhg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aindabé, na, Embo da Mai guputena awa, embomai avekave dadoegari awa kakowa edo awamane tonemain.” ");
INSERT INTO bhg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Edo iji angode embomai avekavemi Yesu de daedo mauntero ami ge eiwa siri ingitera. Edo aindabé Yesu Jerusalem atutumbeteite awamanemi kotembesitera awa imo nasi ainda awamaneda daotari boraebé aina. Awatedo, eniya ge nei awamanede sisina. ");
INSERT INTO bhg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ango edo ami sisina: “Yaida davemainda orobeda maimi yai aikebéda maunsisina, gisijiari bajinami ainda daotarida dero avigarate. Ainda amboda imo tekago overegedo gumaina, ainda nasi embomai gisijiarate. ");
INSERT INTO bhg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Awatedo, imo ainda buro embobo ajigari 10 awa dao tesiri ainda yai guputera. Edo ami ganu gold ajigari 10 avigekavige edo awamanede ganu gold da (1), da da piesiri buritera. Ango edo, ami sisina, ‘Ganu eiwa jigamo edo ganu nenei jiwaebé na embo ewo. Edo ango eite isiawo na egenemana.’ ");
INSERT INTO bhg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ata ainda nasi embomai bé ami embo ainde sinigambari edo esitera. Awatedo, awamaneda ge tari embobo nenei pietero gisijiari bajinada yai maunsitera. Awamane bino eiwa kundo guputera, ‘Embo emi natokare daotari ari awa jipapa ae era!’ ");
INSERT INTO bhg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ata imo daotarida dero budo egenembesisina, ainda nasida. Ango edo imo buro embobo ajigari 10 awa tesiri ainda yai guputera, ganu tega bé ro inge awamanemi jigamo edo buriteri awa gain. ");
INSERT INTO bhg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Buro embo tuturoda ami gundo sisina, ‘Badarari, ganu gold ito awa jigamo edo ganu nei ajigari 10 etena.’ ");
INSERT INTO bhg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ango tesiri badararimi ainde sisina, ‘Buro davebé eteta! Imo buro embo dave. Aindabé imo na tou eite buro dave ganu tega sakabé ami eteta, awatedo, nane boroko imonde awara tari pipitena, embomai nasi babain ajigari 10 ainda itera awa gisijiata.’ ");
INSERT INTO bhg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Edo buro embo nei da (1) ami gundo sisina, ‘Badarari, ganu gold ito awa jigamo edo ganu nei ipa da (5) etena!’ ");
INSERT INTO bhg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Edo badararimi embo ainde ge dá ango sisina, ‘Imo daedo buro davebé eteta! Awatedo, imo embomai nasi babain ipa da (5) ainda itera awa gisi jiata.’ ");
INSERT INTO bhg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ango edo buro embo nei da (1) ami gundo sisina, ‘Badarari, ganu gold da (1) ito awa evire. Nane gongo gisimi doiedo onjigedo sima edo esitena. ");
INSERT INTO bhg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Na gido ena, imo awa embo okain. Imo embo neinda rorae budo eta. Edo rorae ito urari ae awa budo eta. Awatedo, imo adu esitena.’ ");
INSERT INTO bhg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Edo badararimi ainde sisina, ‘Be itoda ge idegeteira ami sira awa, imo awa embo beyae. Imo arapabé gido eta, na awa embo okain. Embo neinda rorae budo ena. Edo rorae nato urari ae awa budo ena. ");
INSERT INTO bhg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Edo ro awa embo imo nato ganu awa ganu ari yai piato ganu nenei are tae esitesi? Ango ato na egenembedo gundo ainda ganu nenei daedo bane tae.’ ");
INSERT INTO bhg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ango edo daotarimi embomai nenei demonda pepetegedo itera ainde sisina, ‘Embo einda yai ganu gold da (1) awa dodo kundo buro embo ami ganu gold ajigari 10 bira, ainde piewo.’ ");
INSERT INTO bhg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ata awamanemi sitera, ‘Badarari, embo awa matu ganu gold ajigari 10 bira.’ ");
INSERT INTO bhg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ango tetero ami mina sisina, ‘Nane imondemane tena, embomai aimi nane rorae pieteno jigamo dave edo era awa, awamanede jiwaebé piana. Ata awamane aimi nane rorae pieteno jigamo ae dumbae edo era awa, awamaneda yai ro matu pipisitena awa dodo bana. ");
INSERT INTO bhg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Awarata, nato gitopo embomai na daotari eonekae, jipapa ae esitera, awamane kundo einda gumbuwo, edo dewo betore jisi natoda.’” ");
INSERT INTO bhg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu ge ango tedo ainda amboda imo matawa pepeta edo Jerusalem kena visido maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Edo iji angode Yesu ae ainda ambodani de gundo nasi Bethphage ae Bethany de, Ni Olive de Peji demonda edo ainda ambodani tote (2) gisi piesiri maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Edo awamanede sisina, “Mambuwo, maundo nasida ounda isira ainda torave. Imomane totoreite ainda wo donki mai buri edo kanjigari tambawa. Embo da aimi ainda tamonda gisi anumbae. Awa udegedo kundo einda gumbuwo! ");
INSERT INTO bhg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Edo embo da aimi imondemane tedogaina, ‘Nongo ain wo mai awa udegetevi?’ embo ainde tewo, ‘Badari mi jipapa eira.’” ");
INSERT INTO bhg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ango tesiri embo tote (2) awa maundo nasi ainda edo ro berari ami awamande sisina awa, dá ango taputera. ");
INSERT INTO bhg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ata awamane wo donki mai awa udegetero, wo tutu itero jiriri awamanede sitera, “Imomane nongaintedo donki mai awa udegetevi?” ");
INSERT INTO bhg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ango tetero awamanemi ge mina sitera, “Badari mi jipapa eira.” ");
INSERT INTO bhg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Edo awamane donki mai kundo gisijido Yesu da yai guputera. Edo awamaneda dademo ombari donki mai ainda gunda augetero visiri besi jijiritera. Edo awamanemi Yesu kondade ero visido anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ango edo Yesu Jerusalem kena maunsiri, embomai jiwaebémi awamaneda dademo ombari teugedo begatada besi jijiritera. ");
INSERT INTO bhg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Edo Yesu gundo Ni Olive de Peji da eno wotari begata ainda atutumbesisina. Ango eiri, ainda ambodani jisi bajina berarimi tuturo edo do yawa eite God dasiga esitera, ge yavi inakademi, aindabé, ami buro babain berari eiri gositera awatedo. ");
INSERT INTO bhg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Edo awamanemi sitera: “God da ao ari Daotarida yai itare! Embo eiwa BADARI da daoda gupeira!” “Emi God ae ainda embomai de awa embo béga utuda bira! Kaen God ikanebé ikane ainde taogari piore!” ");
INSERT INTO bhg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ango edo Parasi mane doregari doda iterami Yesu de sitera, “Atopatari, ito ambodani te ge dowore!” ");
INSERT INTO bhg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ata embo ami awamanede sisina, “Nane imondemane tena awa, eiwamane na dasiga era eiwa dowara gido awa, ganumami boitebé aorogatedo na dasiga ara.” ");
INSERT INTO bhg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iji ainde Yesu Jerusalem atutumbeteite nasi awa jisimi gido do memesi budo ji sisina. ");
INSERT INTO bhg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“God da béga nongo edo bari taori awa, imo gae. Edo gido ito deguta eiwa gari awa budo God gebé ata, ami ito rirowa piainyae. Ata boroko imo na ajiregeteta, awatedo, God mi gari awa ito yai arapa ae onjigesira. ");
INSERT INTO bhg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Gebé, aindabé God akuta ami imo tonemain gumbira awa gae arapa ae, buro engogo awa ito yaida idegaina. Ito gitopo embomi puwa dode ponde jido imo jinenembara edo imo engiregara. Awamanemi imo usibesi ara edo ito mamai avekave doda itera awa daro bebetegara, edo ito oromando berari dedo sitara.” ");
INSERT INTO bhg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Edo Yesu gundo Judah embomainda oro kotopu bajinada gano ari arapada totorisina. Ami embobo roviravi ori mina ara ero gido tuturo edo awamanede ge okain tedo dain ondesiri dodo idedegesitera. ");
INSERT INTO bhg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ango edo awamanede sisina, “God da geda gaiari isira awa, ‘Nato oro kotopu awa embomainda benunu oro,’ ata inemane etewo ‘beono emboboda onjigari yai’ ango esira.” ");
INSERT INTO bhg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu iji berari embomai atopasido esisina, Judah embomainda oro kotopu bajina ainda. Ata pirisi babain ae Aodarida atopapasigari de Judah embomainda embo babain nenei demi nongo edo begata kakowa edo imo daro betaini, ango edo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Awarata, aindabé embomai berari ainda ge sira awa ingain atoto gigito eite gundo jiroro esitera, awamanemi begata onjigari nonda ango ari awa tambae esitera. ");
INSERT INTO bhg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ango edo, deguta da (1)de Yesu Judah embomainda oro kotopu doda embomai atopaposite, God da bino dave awamaneda yai dengoro baiari pipiteite isiri, pirisi babain ae Aodarida atopapasigari de orobeda kopuru mamai demi imo atutumbesitera. ");
INSERT INTO bhg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Edo embo ainde sitera, “Nakare te gore. Imo awara tari nomi buro eiwa esi? Imonde awara tari eiwa aimi piesiri?” ");
INSERT INTO bhg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ango tetero ami awamanede mina sisina, “Edo na daedo imondemane tedogari da (1) piana. Tewo gane. ");
INSERT INTO bhg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","John bapataito arate awara tari aimi pipisisini? God mi pipisisinita ko embo enembomi pipisiteri?” ");
INSERT INTO bhg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Edo awamane akuta mina tara esitera, “Kaende nongo tari? Kaenanemi awara tari God mi pipisisina tara awa, embo emi taina, ‘Ro awa embo imomane John gebé ae esitevi?’ ");
INSERT INTO bhg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Edo kaenanemi tara awa, ‘Embo enemboda piari,’ ainda edo embomai berari omi John awa peroveta site gebé esitera, owamanemi sinigambari edo kaena ganumami augedo dara.” ");
INSERT INTO bhg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ango edo awamanemi mina sitera, “Nakare gae ainda awara tari yai nonda burisini.” ");
INSERT INTO bhg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Edo Yesu mi awamanede sisina, “Awatedo, awara tari nomi buro eiwa eni awa, nane imondemane tainyae.” ");
INSERT INTO bhg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ango edo Yesu embomainde eniya ge eiwa sisina, “Embo da (1)mi dongo gurepi ainda buroda urisina. Edo ami dongo sima ari embobode buro awa pipisisina, awamanemi gurepi be tari ari tokedo mina inono ainda yai piorote. Edo imo yai aikeda maundo iji ribori doturisina. ");
INSERT INTO bhg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Edo gurepi be tari esiri ainda tokari iji gupusina. Awatedo, dongoda mamo ainda buro embo piesiri dongo sima ari emboboda yai maunsisina, gurepi be awa tokedo, nenei ainde piaro kundo gumbarate. Ata sima ari embobo erido buro embo awa gumbiri vededo pietero ipa tepo overegesisina. ");
INSERT INTO bhg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Edo tekago dongoda mamomi buro embo nei piesiri maunsisina. Awa daedo vededo tedojijireite pietero ipa tepo overegesisina. ");
INSERT INTO bhg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Edo tekago ami buro embo nei piesiri maunsisina. Edo imo daedo detero kambo esiri augetero arapada idegesisina. ");
INSERT INTO bhg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ango edo dongoda mamomi sisina, ‘Na buro nongo ani? Awara, nato dubobari mai awa piano mamaina. Na kotembetena, awa gido tou ara.’ ");
INSERT INTO bhg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ata iji ainde sima ari embobomi awa gido mina tara esitera, ‘Dongoda mamoda mai gumbira. Puwo! Mai evire ainda mamoda gaiapa berari amboda barate. Kaende eiwa dano betari ainda gaiapa berari kaenato topo are.’ ");
INSERT INTO bhg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ango tedo mai awa dumundo kundo idegedo buro ponda detero besisina. “Awatedo, dongoda mamomi sima ari embobode nongo aini?” Yesu mi tedogosisina. ");
INSERT INTO bhg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Embo awa gundo sima ari embobo dari bebetegaro, sima ari embobo teteka kundo ainda dongo gurepi buro sima orote, piaina.” Edo embomai ainda itera ami ge awa ingido sitera, “Aia! Buro ango ane ari tao aebé!” ");
INSERT INTO bhg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Edo Yesu awamane jisimi udugedo goteite tedogosisina, “God da Ove Gaiari, ge einda mokabé rori: ‘Dasivi awa imomane oromando ari embomi ajiregesitewa, God mi esiri dasivi davebé dave esira’? ");
INSERT INTO bhg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Embo berari ainkaimi imo ajiregetera, awa ango ou butumi ari ganuma ainda tamonda durudo bebedegara. Ata edo ganuma ami embo tamonda duraina awa gido, embo awa dedo mundari popo aina, dá ou butumi ari ango.” ");
INSERT INTO bhg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aindabé, Aodarida atopapasigari de pirisi babain demi gositera awa, Yesu mi eniya ge eiwa awamaneda yai budo sisina, iji dá ainde awamanemi embo awa ge siri ipami bain esitera. Ata, awamanemi embomai adu esitera. ");
INSERT INTO bhg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Awatedo, awamanemi Yesu simagedo baijiari embobo avigedo pietero maunsitera ami wasiri dambu darari embo dá ango eite ainda ge simagorote. Edo imo ge tae dumbae ari gido awa kundo Rome da gisijiarida awara tari edo goroba ari ainda piain esitera. ");
INSERT INTO bhg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ango edo awamanemi ainde sitera, “Atopatari, nakare gotera imo gebé berari tedo eta. Imo embomai anumba ikane edo tuda itera awa kotembae. Ata God da jipapa ro natokare wasirida eiri, awa dambu darari atopasido eta. ");
INSERT INTO bhg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Awarata, nakare te gore. Kaena Caesar de tax piedo era awa daveta beyaeri?” ");
INSERT INTO bhg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ata Yesu embobo ami udumbari ge tera awa matu gosisina. Awatedo, ami sisina, “Ro awa embo imomane na bavedogain tevi? ");
INSERT INTO bhg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Awara, ganu da (1) kundo gumbuwo gane. Ganu einda dombu ae dao de awa andari?” Edo awamane mina sitera, “Caesar da.” ");
INSERT INTO bhg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Edo ami awamanede sisina, “Rorae ro Caesar da topo gido, Caesar de piewo. Edo rorae ro God da topo gido, God de piewo.” ");
INSERT INTO bhg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yesu ge dambu darido embomainda dombuda tedo esisina. Awatedo, ainda gemi awamanemi imo embomainda doda udumbari tao ae. Edo ainda mina tari dave awa ingido korebé edo ge tukutaku esitera. ");
INSERT INTO bhg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ango edo Sadusi mane neneimi Yesu da yai tedogari piaintedo guputera. Awamaneda gebé ari awa embo betedo tekago erari tao ae. Awatedo, ainde sitera, ");
INSERT INTO bhg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Atopatari, Moses mi kaena embo ge engo gagurisina, embo aro jimundo maiunji piae eimango betaina awa, ainda namejimi rori awa jimundo mamai piari ainda namejida dao itarate tari. ");
INSERT INTO bhg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Awara, iji da (1) de nanonameji berari ajigari 7 isiretera. Edo nameji buwo aro jimundo maiunji piae, besisina. ");
INSERT INTO bhg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ango esiri buwoda gaganimi eutu awa jimundo imo besisina, maiunji piae. ");
INSERT INTO bhg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Edo neinda gagani awa daedo eutu rori jipusina. Dá ango nanonameji berari ajigari 7, awamane aro dá awa jimundo maiunji piae, bebetegesitera. ");
INSERT INTO bhg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ambobéda, eutu awa daedo besisina. ");
INSERT INTO bhg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Awara, eutu eiwa iu ibono berari ajigari 7 jipusina. Awatedo, iji amboda embomai betarida erara awa, arobé anda aini?” ");
INSERT INTO bhg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu mi awamanede mina sisina, “Iji borokoda embo de eutu de jimundo iu aro edo era, awa gotewa. ");
INSERT INTO bhg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ata iji beaoda embomai wasiri dambu darari God da jisida itara awa God mi awara aina, awamane bebetegarida tekago erido wasiri natopo itari yaida mambara. Edo yai ainda iu aro ari itae. ");
INSERT INTO bhg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aindabé, anelamane ango, awamane mana betara. Edo ainda edo awamane awa bebetegari edo erarida mamai, edo God da mamai. ");
INSERT INTO bhg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ata Moses mi daedo arapabé gosisina awa, embo bebetegari awa tekago erara. Ainda ove gaiari matuda isira, abuda ni danegayani ango awa niyaomi aveiri ainda Badari mi sisina, ‘Na awa Abraham da God, Isaac da God, edo Jacob da God.’ ");
INSERT INTO bhg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","God awa embo bebetegarida God ae, ata embo wasirideda God. Awarata, Abraham ae Isaac de Jacob de iji matuda besitera, edo duberi jiwaebé ainda amboda, God mi sisina, awamaneda God awa imo. Awatedo, kaena gotera, awamaneda asisi wasiride God da yai itera, edo gebé ari embo berari bebetegesitera awamane daedo.” ");
INSERT INTO bhg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Edo Aodarida atopapasigari neneimi sitera, “Atopatari, ito mina tari dave!” ");
INSERT INTO bhg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ata ainda amboda awamaneda do jinenegari itae esiri embo ainde tedogari nei ro piae. ");
INSERT INTO bhg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Edo Yesu mi embomai ainde tedogosisina, “Ro awa embo Keriso awa David da Mai tedo eri? ");
INSERT INTO bhg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Aindabé, David imo akuta ami Ove Psalm doda gagurisina tari engo: ‘BADARI mi nato Badari de sisina, “Ipabe natoda anumbedo namonde daedo embomai berari gisijiyo! ");
INSERT INTO bhg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ango eiato nane ito gitopo embo ito tai tuda piano imo tou ore.” ’ ");
INSERT INTO bhg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David mi imo awa ainda Badari sisina. Awatedo, nongo edo gido imo awa David da Maini?” ");
INSERT INTO bhg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Edo embomai berari doregesitera ami Yesu ge sira awa goteite itero imo ainda ambodanide sisina, ");
INSERT INTO bhg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Imomane goteite iwo! Aodarida atopapasigarimi imomane udumbara. Awamane ombari riribo omundo nasi arapada eiworo embomaimi ategabutega eite tou orote, dubobudo era. Edo Judah embomainda benunu oroda maundo anumba davebé dave bain, edo bondoda maundo besi davebé daveda anumain jipapa edo era. ");
INSERT INTO bhg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Edo eutu rori udumbedo awamaneda gaiapa budo era, edo awamaneda dave ari embomaimi gorote tedo benunu riribo tedo era. Ata katari ijide God mi awamaneda rirowa bajinabé embo nenei daginegedo piaina.” ");
INSERT INTO bhg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ango edo Yesu mi oro kotopu bajinada isite jisi piedo goteiri gaiapade embomaimi awamaneda kando mauwa matu siya arida pipisitera. ");
INSERT INTO bhg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Imo daedo goteiri mapa eutu rori da (1) ami ganu babaingae tote (2) mauwada pipisisina. ");
INSERT INTO bhg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Edo ami sisina, “Ge arapada imondemane tena, eiwa giwo! Mapa eutu rori emi embo nenei berari daginegedo bajinabé piesira. ");
INSERT INTO bhg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ge engo tena aindabé, embomai berari eiwa awamaneda gunaguguyeda siya ari awa budo God de kando pietera. Ata, mapa eutu eiwa, ainda yai saka ro isira, ami ainda itarida jigamo ae esira awa, berari piesira.” ");
INSERT INTO bhg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Edo embo neneimi oro kotopu bajinada ganuma ove davegave ari, ae kando God de pipisitera aindemi giro ari awa gido mina tara esitera. Ango tero Yesu mi sisina, ");
INSERT INTO bhg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Iji amboda, ro inemane einda gotewa awa, gitopo embobomi ainda ganuma berari awa daro duraina edo oro kotopu bajina eiwa dedo sitedo usibesibé ara.” ");
INSERT INTO bhg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ango tesiri awamanemi ainde tedogositera, “Atopatari, iji bé nonde buro angogo awa gumaini? Edo kariwa ro gari, buro ango idegain eira iji ainde?” ");
INSERT INTO bhg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Edo ami sisina, “Bé gidogogo ewo! Embomi imomane atopatari ge pitawami udumbeorekae! Aindabé, embo jiwaemi dao natoda gundo ge pitawami ‘Na awa God da Avigari Embo,’ edo ‘Nato iji atutumbeteira.’ Ango taro, imomane awamane ambo ambo eove. ");
INSERT INTO bhg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Iji nonde embo neneimi duduno era, edo yai neneinda ge jindarida iwata kawatada bino ango ingido, adu eove. Wasiri angogo awa gisi idegaina, ata iji beao aribé awa aikae atutumbae.” ");
INSERT INTO bhg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Edo Yesu mi awamanede sisina, “Embomai yai neindami erido embomai yai neinda ainde mina dara ara. Edo daotarida embobo neimi erido daotarida embobo neinde duduno ara. ");
INSERT INTO bhg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yai neindekaindeda jijirami butu ikanade jipaina. Edo embo jiwaebé indari rorae itae ari beji bebetegara, edo embo jiwaebé nenei karu amburo bebegaebé bara. Edo embomaimi wasiri babain idegari gido adu ara, edo daedo utuda kariwa babain gisi gae awa idegari gara. ");
INSERT INTO bhg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ata buro engogo idegae gisida awa, aindabé imomane awa nato ambodani, embomi imomane jido memesi neindekainde imondemane pipisite kundo maundo Judah embomainda benunu oroda katedo bundari oroda piara. Edo imomane nenei awa daotari ae gisijiari mane deda jisida katain kundo gundo piaro petawa. ");
INSERT INTO bhg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Emi awa imomane begata piari awamanede nato bino dave awa karigawa. ");
INSERT INTO bhg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Aindabé, nanemi imondemane dubogari ge piano tawo itomane gitopo embomai berari ami ge awa gido mina tari tao ae o ajiregari tao ae ara, awatedo, boroko kotembarida memesi bove ge ro iji ainde awamanemi imomane bekumba aro mina tawa. ");
INSERT INTO bhg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Edo bé itomane aimamo ae nanonameji de, edo orobe ae otatawo demi imomane awa, kundo itomane gitopo embomainda ipada piara. Edo awamane imomane nenei awa daro betawa. ");
INSERT INTO bhg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Aindabé imomane na gebé edo ewa, embo berarimi imondemane sinigambari ara. ");
INSERT INTO bhg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Ata imomane tataimbarimi God gebé edo ewo. Ango awo embomaimi imomane usibesi ari tao ae edo God mi itomane wasiri tonemaina.” ");
INSERT INTO bhg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Edo Yesu mi sisina, “Iji nonde imomane gitopo embobomi Jerusalem nasi jiroro eiaro gido awa, dave edo giwo, awamane burigibé nasi awa dedo sitara. ");
INSERT INTO bhg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iji ainde imomane avekave yai Judea doda itewa awa, adu tumundo pejida visiwo. Imomane avekavemi Jerusalem doda itewa gido, nasi awa dodo idegewo. Edo avekave nasi ainda demonda isima ewa awa, ainda torainyae. ");
INSERT INTO bhg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nane ge eiwa tena aindabé, iji ainde awa God mi Israel embomainde rirowa piaina. Peroveta manemi ro berari idegaina gaguritera awa bé aina. ");
INSERT INTO bhg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Awarata, iji ainde eutumai watoude ae aimono mamai ami beda itera ainde, awamanemi adu tumundo dedegari bari awa okain bé tambara. Awatedo, awamane do ari! God Judah embomainde sinigambaribé aina. Memesi bougabé awamane itari yaida gumaina. ");
INSERT INTO bhg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Gitopo embobomi Judah embo jiwaebé awa dudunoda daro bebetegara. Edo awamanemi Judah embo nenei jiwaebé bundedo yai berarida kundo mambara. Butuda gisijijiegari, Judah embo ae, ami Jerusalem nasi embomai nenei bundedo nasida ainda gisijijieiaro memesi bougabé budo ara. Ango edo awamanemi Judah embomai gisijijieite isiaro, iji awa God mi Judah embo aeda yai gisijiorote pipisisina bureite beao aina.” ");
INSERT INTO bhg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Edo daedo Yesu mi sisina, “Kariwa embomi gisi gae awa iji ae kariga de edo dabori mane deda yai idegaina. Ewa yawatada yavi ingido embomai butu umbugo neneinda kotembarida memesi bara, edo buro ro ari awa gain darara. ");
INSERT INTO bhg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Aindabé God mi utuda rorae ango dabori mane ae doga mane de awa jipari gido, embomai nenei adu edo jisivi betara, wasiri ro butuda idegaini awa kotembeteite. ");
INSERT INTO bhg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ango eiaro, embo butu berarida ami na, Embo da Mai awa, goroba de taogari bajina de poragada gupeiano gara. ");
INSERT INTO bhg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Iji ainde imomane wasiri engo tuturo edo idegeteiari gido, ainda moka awa God mi itomane yai, iji tupobé, udegari piaina. Awatedo, pangedo jisi utuda piewo. ");
INSERT INTO bhg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Edo ami eniya ge eiwa awamanede sisina, “Imomane gari, ni dunga ami ro edo eira awa, edo ni nenei berari daedo. ");
INSERT INTO bhg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Iji nonde tuturo edo ni tuno pipiteira awa, imomane akuta gotewa, ni awa burigibé uji edo be ekaina. ");
INSERT INTO bhg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Edo imomane daedo, iji ainde rorae angogo idegari goteite awa kotembewo, God mi embo berari gisijiaina, ainda iji awa burigibé gumaina. ");
INSERT INTO bhg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Awara! Edo ge ro nane imondemane tena awa giwo! Embomai iji einda itera awa betainyae isiaro, rorae awa berari idegaina. ");
INSERT INTO bhg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Rorae berari utuda edo butuda awa mandedo itae aina. Ata ge nato eiwa mana mandedo itae aina. ");
INSERT INTO bhg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Bé gidogogo ewo! Do awo butuda wasirimi itomane jiro kotembari God da yai awa usibesi eure. Un okain jiwae injido wasiri bebegae eove. Edo butu wasirida kotembari jiwaemi do buriya ari bainyae. Imomane ango eiawo deguta awa burigibé gumbari boroboro awa. ");
INSERT INTO bhg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nane engo tena, aindabé, nato gumbari awa embomai yai berarida isima edo era awa, waomi wo darago aina. ");
INSERT INTO bhg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Awatedo, imomane akuta goteite iwo! Edo iji berari benunu tewo, God mi itomane wasiri dambu darari gido ainda awara ari piari rorae engogo gumbari awa daginegave, edo iji nonde na, Embo da Mai, katari ijide gumano, imomane mengainyae nato dombuda petave.” ");
INSERT INTO bhg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Edo iji berari Yesu oro kotopu bajinada do arapada torido embomai atopasido esisina. Edo muyae berari imo idegedo nasi Jerusalem dodo Ni Olive de Peji da maundo ainda isima edo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Edo iji berari sipo ataede embomaimi Yesu da atopatari ingaintedo erido oro kotopu bajinada do arapada torido ainda yai gundo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ango edo Bread Badari Siwo Piaeda Bondo iji aikae atutumbesisina, awa daedo tedo era God da Darutegari Bondo. ");
INSERT INTO bhg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Iji angode pirisi babain ae Aodarida atopapasigari demi Yesu daro betarate kotembesitera. Ata, aindabé embomaimi gido sinigambari ara, arapada ango ari awa adu esitera. Awatedo, gae onjigarida daro betarate begata kakowa esitera. ");
INSERT INTO bhg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Edo Satan mi Judas (ainda orobeda dao awa Iscariot) da doda torido tuturo edo imo gisijijisina. Edo imo awa Yesu da embobo 12 ainda da (1). ");
INSERT INTO bhg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Awatedo, Judas idegedo pirisi babain ae oro kotopuda sima ari emboboda gisijijiegari deda yai maundo, ami nongo edo Yesu kundo awamaneda ipada piaini awa ge jijirisina. ");
INSERT INTO bhg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Edo awamane dubodavede awara edo embo ainde mina ganu piain sitera; ango aro Yesu kundo awamanede piarate. ");
INSERT INTO bhg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Edo imo awamanede tarigari sisina. Edo begata dave nonda embomai nenei gae onjigarida Yesu kundo awamanede piaini, awa kakowa esisina. ");
INSERT INTO bhg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ango edo Bread Badari Siwo Piaeda Bondo deguta gupusina. Edo deguta ainde awamane Darutegari Bondoda wo sipu mai dorote. ");
INSERT INTO bhg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Edo Yesu, Peter ae John de pipiteite sisina, “Imomane gisi maundo kaenato Darutegari Bondo siya ewo, kaende indore.” ");
INSERT INTO bhg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Edo awamanemi tedogositera, “Imo yai nonda indari awa siya orote jipapa esi?” ");
INSERT INTO bhg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu mi awamanede mina sisina, “Dave edo giwo! Imomane nasida torido maunteiawo, embo da (1) un sigi amboka ari ami imomane tamaina. Awara, embo awa ambo ambo edo maundo mando nonda toraini ainda toriwo. ");
INSERT INTO bhg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Edo mando tutude tewo, ‘Atopatarimi imonde engo tesira, “Mando tonga nonda na ae ambodani nato de Darutegari Bondo indari?” ’ ");
INSERT INTO bhg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ango tawo embo ami imomane kundo visido yai tonga bajina matu sirigari isira awa piari gawa. Yai ainda indari siya ewo!” ");
INSERT INTO bhg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Edo embo tote (2) erido maundo Yesu mi ro berari awamanede sisina, dá ango awa taputera. Edo yai ainda awamane Darutegari Bondo siya esitera. ");
INSERT INTO bhg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Iji nonde bondo iji awa gumbiri, Yesu anumbesisina ae ainda piari aimbari embobo 12 de indari inain. ");
INSERT INTO bhg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Edo ami awamanede sisina, “Do nato berarimi Darutegari Bondo eiwa imondemane inain jipapa etena, na memesi bae gisida. ");
INSERT INTO bhg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nane imondemane tena awa, na indari engo tekago inainyae isiano jirari God da gisijiari yaida Bondoda mokabé awa arapa aina.” ");
INSERT INTO bhg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ango tedo, ami akou kundo, God da yai ategari pisido, awamanede pipiteite sisina, “Yá, akou eiwa kundo, injido piari, embo nei injido ango ewo, imomane berari. ");
INSERT INTO bhg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nane imondemane tena, na gurepida gama inainyae isiano jirari God da gisijiari gumaina.” ");
INSERT INTO bhg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ango tedo imo bread kundo engegegedo awamanede pipiteite sisina, “Eiwa nato tamo. Awa imomane embo pipitena. Injiwo. Edo engo matawa eite na kotembedo ewo.” ");
INSERT INTO bhg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Edo dá ango, ainda amboda awamane indari indero itae esiri, imo akou kundo sisina, “Akou eiwa ororo natoda imomane embo dodegain ena. Akou emi God da piari tembari okain teka imomane embo sirigeteira awa arapa eira. ");
INSERT INTO bhg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ata giwo! Embo na budo gitopo emboboda ipada piain eira awa, namonde daedo indari indeite tenembada isira. ");
INSERT INTO bhg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Gebé, na, Embo da Mai awa betanate matu God mi sirigesisina. Ata embo na kundo gitopo emboboda ipada piain eira, imo do ari!” ");
INSERT INTO bhg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ango tesiri awamanemi akuta mina tara esitera, “Embo bé aimi buro ango ain eiri?” ");
INSERT INTO bhg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Edo daedo awamanemi akuta be duduno esitera, awamaneda doda embo bajinabé bajina awa averi. ");
INSERT INTO bhg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Edo Yesu mi awamanede sisina, “Embo yai neneinda daotari egeregari awamaneda awara tarimi embomai gisijido era. Edo awamaneda jipapa awa embomaimi awamane dao ‘Embomainda Kondade Egeregari’ tedo era. ");
INSERT INTO bhg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Awarata, imomane iwata ango ainyae. Ata embo da aimi itomane toropuda einda embo bajinabé bajina ain eira awa, tataimbarimi nameji sakada iwata ango aina. Edo gisijiarimi ainda embomai kondade eite buro emboda iwata dá ango aina. ");
INSERT INTO bhg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Edo bajinango awa averi? Da (1) aimi anumbedo isite indari injido eira, awarita ko, embo da (1) indari siya edo eira awari? Embo anumbedo eira, awara. Awa gebé. Ata na akuta awa itomane toropuda buro embo ango ena. ");
INSERT INTO bhg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Edo imomane awa namonde daedo petetewo na memesi bougade iji veteite gundo tega einda etena. ");
INSERT INTO bhg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Edo Mamo natomi ainda awara tari namonde pipisisina, rorae berari gisijido anate, dá ango nanemi awara tari imondemane pipitena. ");
INSERT INTO bhg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Awatedo, iji angode nato daotari dero bano imomane daedo nato tenembada indari injido kundo awa. Edo daedo imomane daotegeregarida anumbada anumbedo isite Israel embomainda ewowo gawowo 12 gisijido awa. ");
INSERT INTO bhg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Edo Badari mi sisina, “Simon! Simon! Giyo! God mi Satan de awara tesira, imomane bawarate, dá ango embomi wheat sirigedo bureite onyeye dodo eira. ");
INSERT INTO bhg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ata Simon, na imo embo benunu tetena, ito gebé ari woteure. Edo iji nonde imo nato yai tenda wareregeteta angode awa, nanonameji ito kondade eyo awamaneda gebé ari okain are.” ");
INSERT INTO bhg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ata Peter mi ainde sisina, “Badari, nato tumonda ari ito yai awa mana wotaina. Na imonde daedo bundari oroda edo betarida mamana.” ");
INSERT INTO bhg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Edo ami mina sisina, “Peter, nane imonde tena awa, deguta einde, kokora aoro tae gisida, imo akuta toreite iji tamonde (3), ‘Embo awa na gae,’ tata.” ");
INSERT INTO bhg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ango edo ami awamanede tedogosisina, “Iji nonde imomane pieteno idegedo eutawa awa, ganu kapi, pepeta kaita, o tai woru ango itae iji angode, imomane rorae nei ro itae awa jipapa edo eutavi?” Edo awamanemi sitera, “Nakare ango ae.” ");
INSERT INTO bhg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Edo ami awamanede sisina, “Ata boroko, edo imo ganu kapi isira gido, kumbuyo! Edo pepeta kaita daedo. Edo imo kasiwo itae gido, ombari ito pieyo embo neimi bureite ganu piari ami da (1) oriate. ");
INSERT INTO bhg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nane imondemane tena, peroveta Isaiah mi nato yai ro idegaina ango matu oveda gagurisina awa, ‘Edo jivere embobode daedo embo awa ajigetera,’ awa boroko gundo bé aina.” ");
INSERT INTO bhg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Edo awamanemi sitera, “Badari, eire gi, nakare kasiwo tote (2) isira.” Ango tetero, Yesu mi sisina, “Awara, awa inono.” ");
INSERT INTO bhg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ango edo, Yesu mi dá edo eira ango idegedo Olive de Peji da maunteiri ainda ambodani daedo imo ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Imo maundo yai ainda edo awamanede sisina, “Benunu tewo imomane bawarida durove.” ");
INSERT INTO bhg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Edo imo awamane dodo yai saka aike kena iaragedo, baongo dadari edo God da yai benunu engo sisina, ");
INSERT INTO bhg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mamo, edo imo engo ain eta gido, memesida akou eiwa dodo kumbuyo nato yai gumbure. Awarata, nato jipapa awa ainyae, ata ito jipapa awa ewasi.” ");
INSERT INTO bhg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Edo God da anela utuda edo gundo imo kondade eiri goroba burisina. ");
INSERT INTO bhg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Edo memesi bougami gundo imo pasiri gido benunu okain bé siri, ainda iwori ororo ango kepukapu butuda durudo esisina. ");
INSERT INTO bhg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Imo benunu tari dero ainda edo erido ambodanida yai overegedo gundo awamane mamatomi pasiri jitao bouga avero tapusina. ");
INSERT INTO bhg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Awatedo, Yesu mi awamane audedo sisina, “Ro awa embo imomane jitao avevi? Erido benunu tewo, God mi imomane dowari bawarida durove.” ");
INSERT INTO bhg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Imo matawa ge site isiri embo jisi bajina gundo idegesitera. Ango edo embo dao Judas, Yesu da embobo 12 ainda da (1), ami embo jisi bajina awa gisijijieite gundo Yesu da yai edo, imo aikae iunte embo awa munegain esisina. ");
INSERT INTO bhg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ata Yesu mi sisina, “Judas, ro embo imo munegarimi Embo da Mai ainda gitopo emboboda ipada pipitesi?” ");
INSERT INTO bhg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Edo Yesu da ambodani ainda demonda ami wasiri ro idegaina, awa matu gositera. Awatedo, ainde sitera, “Badari, natokare kasiwomi awamanede duduno arita?” ");
INSERT INTO bhg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ango site, boraebé ambodani da (1)mi kasiwo budo pirisida gisijiari bajinada buro embo, ainda dengoro ipa beda awa kautugesisina. ");
INSERT INTO bhg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ata Yesu mi sisina, “Ango do, duduno eove!” Ango tedo embo ainda dengoro tujido gao esisina. ");
INSERT INTO bhg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Edo Yesu mi pirisi babain ae oro kotopuda sima ari emboboda gisijijiegari de orobeda kopuru mamai de idegedo guputera, awamanede sisina, “Ro embo imomane na beono embo ango baintedo kasiwo de ami de kundo gumbevi? ");
INSERT INTO bhg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na awa iji berari imondemane oro kotopu ainda isima edo etena, edo na bundae etewa. Awarata, iji eiwa God mi imondemane dosiri iwata engo nato yai ewa. Edo daedo, iji eiwa God mi muyaenda gisijiarida yai dosiri ami buro eira.” ");
INSERT INTO bhg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ango edo embo jisi da (1)mi Yesu ipami jido kundo maundo pirisida gisijiari bajinada mandoda totoritera. Ata Peter aikeda awamane ambo ambo eite gupusina. ");
INSERT INTO bhg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Edo mando arapada niyao etero aveiri awamane anumbedo itero Peter gundo awamaneda teoroda anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Edo iji ainde buro gagara da (1)mi Peter niyao demonda anumbedo isiri gido jisini edo sisina, “Embo eiwa ae embo ounde gundo maundo esira.” ");
INSERT INTO bhg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ata Peter imo akuta toreite sisina, “Eutu, na embo awa gae.” ");
INSERT INTO bhg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Edo saka sima eite embo nei da (1)mi Peter da kariwa gido ainde sisina, “Imo awa Yesu da ambodani da (1). Na gotena.” Ata Peter mi sisina, “O gesi! Na embo awa ae!” ");
INSERT INTO bhg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Edo itero jiriri ora da (1) ango itae esiri embo nei da (1)mi ge okain bé site sisina, “Een! Gebé, embo eiwa ae Yesu de daedo gundo maundo esira, aindabé, embo eiwa yai Galili embo.” ");
INSERT INTO bhg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ata Peter mi sisina, “Ei imo, ge ro boroko teta awa, na bé gae!” Edo iji dá ainde Peter ge siri, boraebé kokora aoro sisina. ");
INSERT INTO bhg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Edo Badari wareregedo dambu darari Peter gosisina. Ainda edo Peter, Badari mi ge ro ainde sisina, awa kotembesisina, “Kokora aoro tae gisida, iji tamonde (3) imo akuta toreite ‘Na embo awa gae,’ tata.” ");
INSERT INTO bhg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Awatedo, Peter mamato eite dodo idegedo maundo ji bajinabé sisina. ");
INSERT INTO bhg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Edo embobo Yesu sima era, ami imo vedeite tedojirido esitera. ");
INSERT INTO bhg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Edo awamanemi ainda jisi gongo jibigimi doiedo ainda dombuda doreite tedogido esitera, “Imo perovetara, nakare te gore, imo aimi desiri?” ");
INSERT INTO bhg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Edo awamanemi Yesu de ge bebegae nenei jiwae tedo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Edo sipo atesiri Judah embomainda orobeda kopuru mamai doregesitera. Awamaneda doda awa pirisi babain ae Aodarida atopapasigari de. Edo awamanemi Yesu gisijido kundo awamaneda Sanhedrin da yaida torido guputera. ");
INSERT INTO bhg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Edo ainde sitera, “Imo Keriso rita gido awa, teyo nakare gore.” Ata Yesu mi awamanede sisina, “Nane imondemane na Keriso tana awa, imomane na gebé ainyae. ");
INSERT INTO bhg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Edo nane imondemane tedogari, ‘Keriso awa embo averi?’ ango tana awa, mina tari nato tainyae o mana na dowawo mamana. ");
INSERT INTO bhg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ata iji einda amboda, na, Embo da Mai awa, God goroba berarida goroba ainda ipa beda anumbedo gisijijieite itana.” ");
INSERT INTO bhg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Edo awamane berarimi sitera, “Awatedo, imo awa God da Mai tesita?” Edo Yesu mi awamanede mina sisina, “Inemane gebé tewa, na awa.” ");
INSERT INTO bhg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ango tesiri gido awamanemi sitera, “Ro awa embo kaenanemi karigari embo nei gain kakowa ain eri? Ine ainda bemi akuta tesiri kaena berari gera.” ");
INSERT INTO bhg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ango edo babadegari berari erido Yesu kundo Pilate da yai maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Edo awamane tuturo edo embo ainde bekumba ge engo sitera, “Embo emi natokare embomai awa dubo butari beyae borote eira awa ingera. Edo Caesar da yai tax piorekae sira, edo daedo, imo akuta awa Keriso, Daotari, sira!” ");
INSERT INTO bhg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Awatedo, Pilate mi Yesu de tedogosisina, “Imo awa Judah embomainda Daotari rita?” Edo Yesu mi sisina, “Inemi teta, awara.” ");
INSERT INTO bhg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ango edo Pilate mi pirisi babain ae embomai de sisina, “Na embo emi Rome da aodari da (1) ro desiri erigesiri awa gae ena.” ");
INSERT INTO bhg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ata awamanemi ge okain tedo sitera, “Ami ainda atopatarimi natokare embomai ao gaieuri Rome da awara tari ajiregorote edo eira Judea da yai berarida. Edo yai Galili da tuturo edo matawa gundo einda eira.” ");
INSERT INTO bhg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Iji ainde awamanemi Yesu yai Galili buro tuturo edo gumbari ango tetero, Pilate ingido ami awamanede tedogosisina, “Embo awa yai Galili embo rita?” ");
INSERT INTO bhg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ango tetero imo gosisina, Yesu awa yai Daotari Herod mi gisijido eira ainda edo gumbari. Iji ainde awa Herod daedo Jerusalem isiri gido Pilate mi Yesu ainda yai piesiri maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Edo Herod mi Yesu da buro jiwae edo eira ainda bino ingido esisina. Awatedo, imo Yesu gido dubodave bé esisina. Iji ribori Herod embo awa gain edo esisina. Edo Herod da jipapa awa embo ami kariwa bajina da (1) ari jisimi gain. ");
INSERT INTO bhg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Edo ami Yesu de tedogari jiwaebé pisido esisina, ata Yesu ainde ge mina tae. ");
INSERT INTO bhg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Edo pirisi babain ae Aodarida atopapasigari de ainda pepetegedo itera ami Yesu de bekumba ge okain bé tero jijirisina. ");
INSERT INTO bhg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ango edo Herod ae ainda itoro embobo demi Yesu de mengari iwata eite imo tedojijiritera. Edo awamanemi Yesu tedojirain ombari ribori duroka dave awa ainda tamoda pipisitera, edo Herod mi imo piesiri kundo Pilate da yai egenembedo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herod ae Pilate de awamane iji gisida awa gitopo mina ara eite itari, ata deguta dá ainde awamane otawo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Iji ainde, Pilate mi pirisi babain de, gisijijiegari ae embomai de gundo ainde daedo doregorote bino piesiri, ");
INSERT INTO bhg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","gumbero ami awamanede sisina, “Imomane embo eiwa kundo nato yai gundo tetewa awa embomai Rome da gisijiari ambo ambo eorekae sira. Nane ainde tedogari inono pietena itomane jisida awa gotewa. Embo emi buro beyae ro esiri awa tambae etena. Ata inemane bekumba ge ainde tewa. ");
INSERT INTO bhg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Edo nane imomane ae Yesu de Herod da yai pieteno mambewa, ata Herod daedo embo einda beyae da ro tambae. Ro awatedo embo eiwa betarida piani? ");
INSERT INTO bhg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Awatedo, nane tano nato itoro embobomi embo awa vededo ainda amboda imo bundarida awa udegaro idegaina” ");
INSERT INTO bhg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Duberi berarida God da Darutegari Bondoda iji ainde, Pilate da ambo ambo ari isira awa inemi jivere embo da (1) bundari oroda edo Judah embomainda yai udegedo esisina). ");
INSERT INTO bhg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ata embomai berari doregesitera ami inonoda aorogatedo sitera, “Embo eiwa kundo maundo deyo betare! Edo Barabbas awa nakare embo doyo idegare!” ");
INSERT INTO bhg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabbas Rome da aodari ajiregedo embo nenei gisijiri awamanemi wasiri bebegae nasi doda esitera. Edo daedo imo embo nei desiri besisina awatedo, bundari oroda pitero totorisina.) ");
INSERT INTO bhg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate Yesu udegain jipapa esisina, awatedo, embomainde tekago sisina, “Embo emi buro beyae da ro ae.” ");
INSERT INTO bhg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ata awamanemi aorogatedo esitera, “Embo awa oregada de! Embo awa oregada de!” ");
INSERT INTO bhg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Edo Pilate mi ge dá awa iji tamonde (3) sisina, “Ro awa embo nane embo eiwa oregada dani? Embo einda beyae itae. Beyae nomi eiri embo eiwa betarida piani? Awatedo, nane tano nato itoro embobomi embo eiwa vededo dowaro mamaina.” ");
INSERT INTO bhg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ata awamane Pilate de aoro ikanadebé gateite tekago tekago tedo esitera, Yesu awa oregada daro betarate. Edo beaoda embomai eiwamane ae pirisi babain deda yavi bajinami Pilate da ge paposisina, jipapa awamaneda awa arate. ");
INSERT INTO bhg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Awatedo, imo awara esisina buro ro Yesu de arate sitera awa. ");
INSERT INTO bhg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilate mi embo jipapa esitera awa, Barabbas, udegesiri idegesisina. Embo awa Rome da aodari ajiregedo embo nenei gisijiri wasiri bebegae esitera, edo embo nei desiri besisina, awatedo, imo bundari oroda matu pipisitera. Edo Pilate mi Yesu itoro emboboda ipada pipisisina, embomainda jipapa awa orote. ");
INSERT INTO bhg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ango edo itoro embobomi Yesu gisijido kundo idegedo maunsitera. Edo embo dao Simon, awa nasi Sairin embo, imo awa arapada edo gundo Jerusalem atutumbesisina. Edo awamanemi embo awa ipami jido dumbero gumbiri jijine sitera, Yesu da orega amboka edo ainda gunda ainto arate. ");
INSERT INTO bhg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Embomai jisi bajinabé Yesu da amboda maunsitera. Edo eutumai daedo ji ikanade site awamaneda ipatai butuda dedo depeka eite maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ata Yesu mi wareregedo awamane ango ero gido sisina, “Jerusalem eutumai, na embo ji teove, ata, imomane akuta awa embo, edo itomane mamai awa embo ji tewo. ");
INSERT INTO bhg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nane imondemane engo tena, aindabé, wasiri beyae bajina itomane yai idegaina, edo iji ainde embomi tara, ‘Dubodave awa eutumai owamane ainkaimi ero itera, mamai engae itera, edo mamai ami gaiae itera awamaneda yai!’ awatedo. ");
INSERT INTO bhg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Iji ainde, aindabé embomi memesi adu edo betain jipapa eite “‘ami tuturo edo peji dao tedo tara, “Bededo nakare pasiwo!” edo awamanemi pamode tara, “Durudo nakare apuregewo!” ’ ");
INSERT INTO bhg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nane ango tena aindabé, na awa ni yanda ango. Awatedo, mina beyae ro awamanemi nato yaida pipitera awa giu! Atako, Jerusalem da embomai awa ni mumuya ango. Awatedo, mina beyaebé ro awamaneda yaida piari?” ");
INSERT INTO bhg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Edo jivere embo nei tote (2) awa ae Yesu de daedo gisijido kundo idegedo maunsitera, daro betorote. ");
INSERT INTO bhg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Iji nonde awamane gundo yai dao Kopuru Akou tedo era, ainda edo awamanemi Yesu ae jivere embo tote (2) de awa daedo oregada doritera. Embo da (1) awa Yesu da ipa beda, edo embo nei awa ainda ipa andada. ");
INSERT INTO bhg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Edo Yesu mi sisina, “Mamo, awamane wasiri ro eri awa gae arapa ae, awatedo, awamaneda beyae kotembedo doyo.” Edo itoro embobomi Yesu da ombarijiari avigedo baintedo ganuma babaingae ove gaiaride awa augedo tetenya esitera. ");
INSERT INTO bhg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Iji angode embomai ainda pepetegedo goteite itero jijirisina. Ata, Judah embomainda gisijijiegari awamanede daedo itera ami Yesu de mendode kikino eite sitera, “Ami embo nenei tonembedo esisina. Edo gido embo awawa Keriso, God da Avigari Embo, ami akuta ainda wasiri toregarate!” ");
INSERT INTO bhg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Edo daedo itoro embobomi Yesu tedojijiritera. Awamanemi aikae gundo imo waini jigagani awa indarate pipisite ");
INSERT INTO bhg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","sitera, “Imo Judah embomainda Daotari gido, imo akuta toregeyo!” ");
INSERT INTO bhg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Awamanemi daedo ove gaiaride oregada pipisitera, Yesu da kopuru ikaneda, edo Guriki da, Rome da, edo Hiburu da gemi engo gaiedo: ");
INSERT INTO bhg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ango edo jivere embo da (1) Yesu da demonda ekegesitera ami ge bebegae ainde site sisina, “Imo God da Avigari Embo gido awa, imo akuta tonembeyo ae namondekare daedo.” ");
INSERT INTO bhg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ata jivere embo nei da (1)mi ge mina okain bé embo ainde sisina, “Imo God adu ae rita? Iji einde imo betata dá embo ango awa! ");
INSERT INTO bhg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Awarata, wasiri bebegae ingenato esitera, ainda rirowa burera. Ata embo emi beyae da ro ae.” ");
INSERT INTO bhg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Edo ami Yesu de sisina, “Badari, na kotembeyo iji nonde imo ito gisijiari yaida torata.” ");
INSERT INTO bhg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Edo Yesu mi embo ainde sisina, “Nane imonde tarigari eiwa tena, imo iji einde namonde daedo maundo yai Paradais ainda itata.” ");
INSERT INTO bhg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Iji ainde awa iji toropu eiri ijida parara kumboro esiri muyae gundo butu dede awa apuregesisina. Awa matawa maundo iji wareregedo turo 3:00 esisina. Edo Judah embomainda oro kotopu bajina doda gongo puruta awa toropubéda keredo kupo eve kupo eve esisina. ");
INSERT INTO bhg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ango edo Yesu mi aoro ikanadebé gatedo sisina, “Mamo, imo tumonda eite nato asisi ito ipada pipitena.” Engo tedo imo besisina. ");
INSERT INTO bhg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Edo itoroda gisijiarimi wasiri ro idegesiri awa gido God dasiga eite sisina, “Gebé berari, embo eiwa wasiri dambu darari embo.” ");
INSERT INTO bhg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Embomai berari yai ainda doregesitera ami wasiri ro idegesiri awa gido ipatai butuda dedo depeka eite dodo egenembesitera. ");
INSERT INTO bhg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ata Yesu da otatawo berari ae eutumai avekave yai Galili da edo imo ambo ambo edo guputera awamane demi aikeda petedo isite buro idegesisina awa jijimbesitera. ");
INSERT INTO bhg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ango edo embo dao Joseph awa Judah embomainda nasi Eremateia ainda edo gumbari. Imo awa embo dave edo wasiri dambu darari. Edo ami daedo God da gisijiari iji nonde gumaini awa sima eite isinesina. Imo awa Sanhedrin embobo ainda da (1), ata Yesu betarate ge jijiritera awa, ainda awara ari piae. ");
INSERT INTO bhg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Edo embo emi Pilate da yai maundo Yesu da tamo bain tesiri imo awara sisina. ");
INSERT INTO bhg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Awatedo, Joseph maundo Yesu da tamo oregada awa kundo piesiri wowosisina. Edo tamo awa gongo viraraemi doiedo kundo maundo banga to matu siya ari ainda pipisisina. Yai awa embo neimi gisi jigamo ae. ");
INSERT INTO bhg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Edo deguta awawa Siya baiya Ari Deguta, edo turo jijireiri awamaneda Oena Apari Deguta atutumbesisina. ");
INSERT INTO bhg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Edo eutumai ainkain Yesu de daedo yai Galili edo guputera, ami Joseph da amboda maundo banga to gido, Yesu da tamo nongo nongo pipisisini awa gositera. ");
INSERT INTO bhg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ango edo awamane egenembedo nasida maundo ni igi muno davede edo un muno davebé davede siya esitera. Edo Moses da aodarida tari isira, awatedo, Oena Apari Degutade awamane oena apitera. ");
INSERT INTO bhg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ango edo Deguta Bajina pura tuturoda sipo ataebéde, eutumai eiwamane ae eutu nenei demi ni igi muno davede siya esitera awa kundo guputera banga toda. ");
INSERT INTO bhg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Edo awamane gundo, ganuma to be engiregari awa apepegari demonda maundo isiri gositera. ");
INSERT INTO bhg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Awatedo, awamane maundo torido Badari Yesu da tamo ainda tambae esitera. ");
INSERT INTO bhg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Edo awamane buro nongo esiri awa kotemain dareite itero, boraebé embo tote (2) demonda petetero awamaneda ombarimi parara bajinabé esisina. ");
INSERT INTO bhg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ango esiri eutumai awa adu edo dombumi butuda atembesitera, ango ero embo tote (2)mi sitera, “Nongaintedo inemane embo wasiride isira, awa bebetegarida toropuda gain kakowa evi? ");
INSERT INTO bhg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Embo gain ewa awa einda itae, ata matu erira. Edo ami imondemane daedo eite yai Galili ainda ge nongo siutari awa kotembewo! ");
INSERT INTO bhg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Awa engo, ‘Embo da Mai awa kundo embo bebegaeda ipada piara, edo oregada daro betaina, edo deguta tamonde (3) ainda awa tekago eraina.’” ");
INSERT INTO bhg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Edo iji angode ge awa ingido, awamane kotembesitera awa gebé, Yesu mi ge ango sisina. ");
INSERT INTO bhg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ango tetero gido eutumai banga toda edo overegedo gundo buro berari eiwa ainda embobo 11 ae ainda ambodani nenei berari de sitera. ");
INSERT INTO bhg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Edo eutumai eiwa Mary (nasi Magadala eutu), Joanna, edo James da ai (ainda dao awa daedo Mary), edo eutumai neneinde daedo awamanemi Yesu da piari aimbari emboboda yai ge dá awa tedo esitera. ");
INSERT INTO bhg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ata awamanemi kotembesitera awa, eutumaimi ge tera ainda moka itae, edo awamane gebé ae esitera. ");
INSERT INTO bhg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Awarata, Peter erido bé jisimi gain to beda tumundo maunsisina, edo atembedo gongo virarae awa akuta isiri gosisina. Awatedo, Peter mi buro ro idegesira awa gido imo akuta korebé eite overegedo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ango edo deguta dá ainde, Yesu da ambodani nei tote (2), awamane nasi dao Imeasi tedo era, ainda mauntera. Nasi ainda edo Jerusalem da begata tonga awa ribori 11 km ango. ");
INSERT INTO bhg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Awamane wasiri ro berari idegesiri awa ge mina tara edo goteite maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Edo awamane tote (2) ge mina tara edo goteite mauntero Yesu imo akuta gundo atutumbedo awamanede daedo pepeta esisina. ");
INSERT INTO bhg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ata God mi awamaneda jisi engiregesiri Yesu gaegae esitera. ");
INSERT INTO bhg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Edo Yesu mi awamanede sisina, “Imomane ge awa ro sireite duboveverade ainto evi?” ");
INSERT INTO bhg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Embo tote (2) ainda da (1), dao Cleopas mi Yesu de sisina, “Imo etega embo dabé akuta ami Jerusalem ainda sima eto buro ro iji einde idegatari awa gae ta rora!” ");
INSERT INTO bhg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ango tetero, Yesu mi tedogosisina, “Buro ro idegatari?” Edo awamanemi sitera, “Buro awa Yesu Nasaret Embo da yai idegatara. Imo awa peroveta, edo ami ge gorobade tedo esisina, buro babain edo esisina, God da jisida edo embomai berarida jisida. ");
INSERT INTO bhg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Awa pirisi babain ae kaenato babadegari demi kundo, Rome da gisijiarida ipada imo katedo dari betarate pietero, ainda itoro embobomi oregada detero besitara. ");
INSERT INTO bhg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ata nakare tumonda edo eutara awa, embo dabé ami Israel embomai bundarida itera awa udegaina. Ainda edo buro engo eutara awa gundo boroko deguta tamonde (3) eira. ");
INSERT INTO bhg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Awarata, deguta einde, eutumai nenei natokare doregarida ami gundo nakare tetero gido kore beyaebé etera. Awa eire: sipo ataebéde awamane erido banga toda mambera, ");
INSERT INTO bhg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ata Yesu da tamo awa ainda tambae etera. Edo awamanemi overegedo gundo namondekare tetera awa, ‘Nakare jisi viviroda anelamane gera edo awamanemi tetera awa imo wasiride isira.’ ");
INSERT INTO bhg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Edo natokare doregarida embo nenei banga toda mambera. Edo yai awa tepo, ge ro eutumaimi tetera angó, ata embo awa gae etera.” ");
INSERT INTO bhg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ango tetero Yesu mi awamanede sisina, “Itomane kotembari jigamo ae edo burigi gebé ari tao ae, God da peroveta manemi ge berari sitera ango aina awa. ");
INSERT INTO bhg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ata God da udojipapa awa Keriso, imo memesi engo budo utuda ikaito taogarida torarate.” ");
INSERT INTO bhg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Edo Yesu mi awamanede udugedo tesiri gositera, ro berari ainda yai Matu Oveda gaguritera, tuturo Moses mi gagurisina ainda edo matawa peroveta mane berarimi gaiedo esitera awa. ");
INSERT INTO bhg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Awamane tamonde (3) mauntero jiriri nasi aikae edo torain esitera. Edo Yesu mi tepo daginegedo mamain arago esisina. ");
INSERT INTO bhg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ata awamanemi imo torarate atega esitera, “Iji itae esiri turo jijireira. Awatedo, namondekare daedo sima ate.” Edo imo awamanede itain maundo totorisina. ");
INSERT INTO bhg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ango edo imo maundo anumbedo, awamanede daedo tenembada indari inain eite ami bread kundo God ategedo, engegedo awamanede pipisisina. ");
INSERT INTO bhg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Edo awamaneda jisi pirigesiri imo kariwa gositera, ata awamaneda toropuda nonda mambarago esisina. ");
INSERT INTO bhg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Edo awamane akuta mina tara esitera, “Embo ingenamonde begatada gupeite ge site, Ove Gaiari Matu da udugesira iji ainde, ingenato do yawa bajinabé esira, imo gesi?” ");
INSERT INTO bhg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Edo awamane indari tenembada tou edo erido egenembedo Jerusalem maunsitera. Awamane maundo Yesu da embobo 11 ae ambodani neneinde daedo dada doregedo itero taputera. ");
INSERT INTO bhg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Edo awamanemi embo tote (2)de sitera, “Badari erira awa gebé! Simon da yai idegesiri ainda jisimi gira!” ");
INSERT INTO bhg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Edo embo tote (2)mi Imeasi begatada buro ro idegesira awa tedo, daedo awamanemi Yesu bread engegeteiri kariwa nongo geri, awa tetero gositera. ");
INSERT INTO bhg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ango edo awamane ge matawa site itero, boraebé Yesu awamaneda toropuda idegedo petedo sisina, “Béga itomane yai itare!” ");
INSERT INTO bhg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ata awamane etemi gotera angó kotembedo, boroboro edo adu esitera. ");
INSERT INTO bhg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Awatedo, Yesu mi sisina, “Ro awa embo itomane do buriya eiri edo imomane gain darevi? ");
INSERT INTO bhg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nato ipa de tai de eiwa giu! Ane na bé awara. Etemi awa tamopisi de vetu de itae, ata na awa pisi de vetu de gotewa. Eire, tujido giwo!” ");
INSERT INTO bhg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ango tedo, ami ainda ipa de tai de esiri gositera. ");
INSERT INTO bhg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Awamanemi Yesu erira awa gido yawa eite korebé esitera, awarata, awamane bé gebé ari tao ae esitera. Awatedo, ine awamanede sisina, “Itomane indari rorae einda isiri? Isira gido awa na piewo inane.” ");
INSERT INTO bhg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ango tesiri awamanemi ainde un wo jiwari ae pika gama de pipisitera. ");
INSERT INTO bhg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Edo pietero kundo awamaneda doda injisina. ");
INSERT INTO bhg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Edo Yesu mi awamanede sisina, “Na imondemane daedo matawa isite, nane imondemane tedo eutana, ro nato yai idegaina awa, Moses da Aodarida, edo Peroveta maneda Ove Gaiarida, edo daedo Psalm neneinda gaguritera isira berari awa bé arate.” ");
INSERT INTO bhg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Edo ami kondade esiri awamaneda kotembari pirigesisina, Ove Gaiari Matuda tari isira awa, awamaneda yai arapa arate. ");
INSERT INTO bhg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Edo awamanede sisina, “Ge ango gaguritera edo God da sirigari matu awa dá ango: Keriso awa memesi budo betaina. Edo amboda, deguta tamonde (3) ainde tekago eraina. ");
INSERT INTO bhg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Edo ainda amboda, ainda embomaimi tuturo Jerusalem doda edo maundo embomai butu arapuda, awamaneda yai Keriso da bino dave awa karigara. Edo ainkaimi awamaneda jimbo bebegae dodo God da yai wareregaro, ami awamaneda jimbo kotembedo dowaina. ");
INSERT INTO bhg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Imomane namonde daedo itewo buro berari nanemi eono gido etewa. Edo imomane jisimi gewa, na betedo tekago erena. Awatedo, embo neneinde bino berari awa karigewo gore. ");
INSERT INTO bhg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Edo giwo! Nanemi ro Mamo natomi tarigari sisina awa piana. Awarata, Jerusalem nasida isiwo, isirawo jirari God mi itomane yai goroba piari bave. ");
INSERT INTO bhg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ango edo Yesu awamane gisijido, Jerusalem dodo idegedo pepeta edo Bethany nasida maunsisina. Edo ami ipa jiri eriri awamane ao esisina. ");
INSERT INTO bhg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Imo ango eite, awamane dodo taigesiri God mi jiri utuda vivisisina. ");
INSERT INTO bhg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Awamanemi wasiri awa gido imo tumondebain esitera. Edo yawa bajinabé eite overegedo Jerusalem maunsitera. ");
INSERT INTO bhg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Edo awamane iji berari Judah embomainda oro kotopu bajina doda God ategabutega eite imo dasiga edo esitera. Awara. ");
INSERT INTO bhg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tuturobéda awa Ge isinesina, edo Ge ae God de daedo isinesina, edo Ge awa God. ");
INSERT INTO bhg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Imo awa tuturobéda God de daedo isinesina. ");
INSERT INTO bhg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Edo Ge einda toda God mi rorae berari esisina. Edo rorae berari God mi esisina isira awa, ainda toda akuta ami esisina. ");
INSERT INTO bhg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Edo Ge awa wasiri tutu, edo wasiri awa embomai berarida parara. ");
INSERT INTO bhg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Edo parara muyaeda doda datembedo eira, edo muyaemi ari awa akeimbari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Embo da (1) isinesina, edo ainda dao awa John. Embo awa God mi piesiri gupusina. ");
INSERT INTO bhg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Imo gupusina awa, embomai berarida yai Parara karigain. Ango ari embomai berari Pararada bino ingido gebé orote. ");
INSERT INTO bhg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Edo John imo akuta awa Parara ae, ata imo gupusina awa Parara awa embomaida yai arapa tari gorote. ");
INSERT INTO bhg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Awawa Pararabé ami butuda gupeite embomai berarida yai parara piedo eira. ");
INSERT INTO bhg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Imo awa butuda isima edo esisina, edo God mi ainda toda butu awa esisina, awarata embomai butuda ami imo gae arapa ae. ");
INSERT INTO bhg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Edo imo awa ainda butu topoda gupusina ata ainda embomaibé ami imo ajiregesitera. ");
INSERT INTO bhg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ata berari ainmi imo bera edo awamaneda gebé ari ainda daoda pietera, inemi awara tari awamanede piesira awa, awamane God da mamai ara. ");
INSERT INTO bhg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Edo God da mamai awa ewowoda edo gumbari ae, ko tamopisida engari ae, ko iuda jipapa ango ae, ata God mi akuta awamane ainda mamai esira. ");
INSERT INTO bhg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ge awa embo tamopiside esisina, edo natokare toropuda daedo isima edo esisina. Nanekaremi embo awa matawa jisimi gositera. Edo ine ainda dave ari iji berari natokare yai arapa edo esisina edo iji berari God da gebé namondekare tedo esisina. Awa ainda taogari. Aindabé imo awa God da Mai dakaima, taogari awa ainda Mamo da yai edo natokare yai gupusina. ");
INSERT INTO bhg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Edo John mi embo ainda daoda ge karigesite aorogatedo sisina, “Embo evire, na ainda daoda ge eiwa tedo etena, ‘Embo ainmi nato amboda gupeira awa na daginegari, aindabé na engae gisida imo isinesina.’” ");
INSERT INTO bhg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Edo ainda dave ari bajinabé bajinada edo ami kaena beraride kando pieuri budo etera, nei budo douri nei da (1) budo era. ");
INSERT INTO bhg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gebé, God mi Moses da toda Aodari pipisisina, ata Iesu Keriso da toda awa ainda dave ari ae gebé de kaenato yai piesiri gupusina. ");
INSERT INTO bhg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Iji tuturobéda edo gundo iji boroko einde embo da ain jisimi God gae. Mai dakaimami akuta, imo Mamo da demonda isima edo eira, ami Mamo averi awa kaenamonde tesiri gositera. ");
INSERT INTO bhg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Edo ge amboda gumaina eiwa awa John da ge Iesu da daoda ami karigesisina, iji ainde Jew embomai Jerusalem ainda ami, “Imo averi?” awa tedogorote pirisi mane ae Levi da ewowo mane de pietero John da yai maunsitera. ");
INSERT INTO bhg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Edo John ge arapada karigesisina, edo ge onjigae, ata arapada karigesisina, “Na awa Keriso ae.” ");
INSERT INTO bhg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ango tesiri gido awamanemi tedogositera, “Awatedo imo averi? Imo Elijah ra?” John mi sisina, “Na awa ae.” Awamanemi tekago sitera, “Imo Peroveta ra?” Ami mina sisina, “Ae.” ");
INSERT INTO bhg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Edo awamanemi ainde sitera, “Imo averi? Nakare teyo gido overegedo maundo embo nakare pietero gumbera awamane taro gore. Imo akuta awa nongo tain esi?” ");
INSERT INTO bhg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Edo John mina sisina: “Dá ango peroveta Isaiah mi sisina, na awa ‘embo abu damodamo da aorogateira: “Badari da begata sirigewo dambu darare.” ’  ” ");
INSERT INTO bhg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Edo Parasi mane mi embobo awa John da yai pietero maunsitera. ");
INSERT INTO bhg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Edo embobo ami embo ainde tedogositera, “Edo imo Keriso ae, ko Elijah ae, ko Peroveta ae, ro awaembo imo embomai bapataito edo esi?” ");
INSERT INTO bhg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Edo John mi awamanede mina sisina, “Na un mi embomai bapataito edo ena, ata itomane toropuda embo da (1) petari isira imomane gae. ");
INSERT INTO bhg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Embo ami nato amboda gupeira awa na bé daginegari. Nane inono atembedo ainda tai woru teugari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Buro berari eiwa Betabara nasida un Jodani kupo neida idegesisina. John yai ainda isite embomai bapataito edo esisina. ");
INSERT INTO bhg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Edo deguta neide, John mi Iesu imo kena gupeiri gido sisina, “Ovire giwo, God da Wo Sipu Mai! Omi embomai butu berarida jimbo bebegae awa kotembedo dodo itae ain gupeira! ");
INSERT INTO bhg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Embo evire, nane ainda daoda ge eiwa tedo etena, ‘Embo ainmi nato amboda gupeira awa na daginegari, aindabé na engae gisida imo isinesina.’ ");
INSERT INTO bhg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Edo imo embo averi na gae. Ata na un mi bapataito eite gumena, Israel embomaida yai embo awa arapa ari gorote.” ");
INSERT INTO bhg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Edo John mi ge eiwa karigedo sisina, “Na Asisi ni ribo ango utuda edo wowosiri gena, edo embo da (1) tamonda wotedo isira. ");
INSERT INTO bhg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na imo embo averi awa gae, ata God mi na piesiri guputena un mi Bapataito anate ami sisina awa, ‘Embo ainda yai Asisi wowosite ainda tamonda isiari gata, eiwa awa embore ami Asisi Kotopu mi embomai bapataito edo aina.’ ");
INSERT INTO bhg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Edo na awa jisimi gari edo karigetena, eiwawa God da Mai.” ");
INSERT INTO bhg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Edo tekago deguta neide, John ae ainda ambodani tote (2)de yai ainda petedo itero, ");
INSERT INTO bhg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iesu ainto edo daginegeteiri John mi embo awa gido sisina, “Ovire giwo, God da Wo Sipu Mai!” ");
INSERT INTO bhg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Edo ambodani tote (2) ainda ge ingido Iesu ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Edo Iesu wareregedo awamane gido imo ambo ambo edo gupero sisina, “Imomane ro gain evi?” Awamanemi ainde sitera, “Rabbi” (Ainda moka awa ‘Atopatari’.), “imo nonda isima edo esi?” ");
INSERT INTO bhg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Embo ami awamanede sisina, “Puwo gave.” Ango tesiri awamane gundo imo isima edo eira yai awa gositera, edo awa ora 10 ango eiri deguta ainde imonde daedo itero jijirisina. ");
INSERT INTO bhg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Embo tote (2) John ge siri ingido Iesu ambo ambo esitera, awamaneda da (1) awa Andrew. Edo imo awa Simon Peter da nameji. ");
INSERT INTO bhg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrew mi gisibé ainda nameji Simon tamundo ainde sisina, “Nakare Messiah tambera” (awa Keriso). ");
INSERT INTO bhg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Edo Andrew embo awa kundo Iesu da yai maunsisina. Edo iji ainde Iesu embo awa gido ami sisina, “Imo awa Simon, Jonah da mai. Ito dao Cephas tedo ara.” (Ainda moka awa Ganuma.) ");
INSERT INTO bhg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ango edo deguta neide Iesu yai Galili mamain jipapa esisina. Edo Philip tamundo embo ainde sisina, “Na ambo ambo eyo.” ");
INSERT INTO bhg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Edo Philip awa nasi bajina Besaida embo. Edo nasi dá awa Andrew ae Peter deda nasi. ");
INSERT INTO bhg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip mi Nathanael tamundo embo ainde sisina, “Nakare embo eiwa Moses mi Aodarida gagurisina edo daedo peroveta manemi gaguritera awa tambera—Iesu Nasaret Embo, Joseph da mai.” ");
INSERT INTO bhg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Edo Nathanael mi ainde sisina, “Nasaret! Rorae dave da (1) nasi ainda edo gumbari tao rita?” Philip mi embo ainde sisina, “Puyo gate.” ");
INSERT INTO bhg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iesu mi Nathanael imo kena gupeiri gido ainda daoda sisina, “Giwo, Israel embobé awa evire. Ainda yai ge pitawa tari itaeǃ” ");
INSERT INTO bhg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael mi ainde sisina, “Imo na nongo edo bé gotesi?” Iesu mi embo ainde mina sisina, “Philip imo dao tae gisida, ni dunga tutuda iteto na imo gena.” ");
INSERT INTO bhg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael mi ainde mina sisina, “Atopatari, imo awa God da Maiǃ Imo awa Israel embomaida Daotariǃ” ");
INSERT INTO bhg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu mi embo ainde mina sisina, “Aindabé nane imonde tetena, ‘Imo ni dunga tutuda iteto gena,’ awatedo imo gebé esita? Imo wasiri babain eiwa daginegari awa gata.” ");
INSERT INTO bhg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Edo Iesu mi embo ainde sisina, “Eiwa awa gebé bajina imondemane tena. Iji boroko einde edo amboda, utu pirigari God da anelamane visido wotedo Embo da Mai tamonda eiaro gawa.” ");
INSERT INTO bhg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ango edo deguta tote (2) itae esiri embomai Keina nasida yai Galili doda ami jimbari bondo siya esitera. Edo Iesu da ai awa ainda isiri, ");
INSERT INTO bhg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","edo Iesu ae ainda ambodani de, awamane daedo bondo ainda jiputera. ");
INSERT INTO bhg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Edo iji ainde waini inono ae esiri Iesu da aimi embo ainde sisina, “Awamaneda waini itae esira.” ");
INSERT INTO bhg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Edo Iesu mi mina sisina, “Eutu, ro embo inemi namonde ge eiwa tesi? Nato iji gumaina, ata boroko awa gumbae.” ");
INSERT INTO bhg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Edo Iesu da aimi buro embobode sisina, “Embo emi buro ro awate tari gido, ango ewo.” ");
INSERT INTO bhg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Edo iji angode un sigi babain ganumami ari berari 6 mando doda itera. Edo Jew embomaida piari petari awa sigi angogo awa gerigedo ainda un jigamo edo roviravi teiaro ainda dono itae arate God da jisida. Sigi da da awa un 100 litres ango bari tao. ");
INSERT INTO bhg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu mi buro embobode sisina, “Un sigi awa berari un gerigewo.” Edo awamanemi gerigetero gundo beda esisina. ");
INSERT INTO bhg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Edo ami awamanede sisina, “Awara, nenei jimundo kundo mambuwo bondo badarida yai.” Awatedo ango esitera. ");
INSERT INTO bhg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Edo iji angode bondo badarimi un injido gosisina. Ata un awa matu wareregedo waini esisina. Edo bondo badari waini nonda edo gumbiri awa imo gae, awarata buro embobo un jimundo pipisitera ami gositera. Awatedo bondo badarimi, imo jimbari tutu dao tesiri gupusina. ");
INSERT INTO bhg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Edo bondo badarimi embo ainde sisina, “Embo berarimi waini dave embomaide gisi pioro injido inono eoro gido, waini tega tuda pioro injido eora. Ata ine waini dave jieto gundo iji boroko einda esira!” ");
INSERT INTO bhg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Eiwa awa kariwa tuturobéda Iesu mi esisina. Edo imo Keina nasida yai Galili doda awa esisina. Ango edo ainda taogari arapa esisina, edo ainda ambodanimi awamaneda gebé ari ainda yai pipisitera. ");
INSERT INTO bhg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Einda amboda imo wotedo Kapenium nasida maunsisina ae ainda aide, ainda nanonamejide, ainda ambodanide. Edo awamane deguta indewae awa ainda sima esitera. ");
INSERT INTO bhg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Edo Jew embomaida Darutegari Bondo ari iji atutumbesiri Iesu maundo Jerusalem vivisisina. ");
INSERT INTO bhg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Edo imo Jew embomaida oro kotopu bajina da yai torido embomaimi wo kao mane ae sipumane de ni ribo angogo de awa origarori ero gosisina. Edo daedo embo nenei tenembada anumbesitera, awamanemi ganu evekara awa teteugedo mina piya mana piya eite itero gosisina. ");
INSERT INTO bhg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ango edo Iesu vedari asi tendedo kundo awamane berari ondesiri oro kotopu dodo idedegesitera, wo sipumane ae kao mane de daedo. Edo imo ganu teugari emboboda tenemba berari jiri gomenigedo ganu yoyowa esitera. ");
INSERT INTO bhg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Edo ine embobo ni ribo angogo piedo ganu bureite itera, awamanede sisina, “Roviravi eiwa kundo idegeuǃ Mamo natoda oro awa awo origarori ari yai eureǃ” ");
INSERT INTO bhg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Edo ainda ambodanimi ro God da Oveda gaiari awa kotembesitera, “Nato tou ari ito oro kotopu awaembo awa niyao vevera ango ami na avedo usibesi aina.” ");
INSERT INTO bhg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Awatedo Jew embomai mi embo ainde tedogositera, “Kariwa ro piato gido God mi ainda awara tari imonde piesiri buro engogo eta awa gari?” ");
INSERT INTO bhg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Edo Iesu mi awamanede mina sisina, “Oro kotopu eiwa dedo sitewo, edo deguta tamonde (3)da doda nanemi jiano eraina.” ");
INSERT INTO bhg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ango tesiri Jew embomaimi sitera, “Oro kotopu einda buro awa duberi 46 ainda doda ero jiriri petugesitera, edo imo inono deguta tamonde (3)da doda jiato erainita?” ");
INSERT INTO bhg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ata ge ‘oro kotopu’ Iesu mi bureite sisina awa ainda tamo. ");
INSERT INTO bhg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Awatedo iji ainde Iesu betarida awa God mi jiri eriri ainda ambodanimi ge eiwa sisina awa kotembesitera. Edo awamanemi God da Ove Gaiarida tari de, edo ge Iesu mi sisina ainde awa gebé esitera. ");
INSERT INTO bhg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Edo Darutegari Bondo iji ainde Iesu Jerusalem ainda isite kariwa jiwae euri embomai gido esitera. Edo embomai jiwae awamaneda gebé ari ainda daoda pipisitera. ");
INSERT INTO bhg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ata Iesu embomai berari awa gari, awatedo ainda tumonda ari awamaneda yai piae. ");
INSERT INTO bhg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aindabé Iesu ami akuta rorae ro embo enemboda dobéda isiuri gido esisina, awatedo embo neneida karigari ge embo enemboda daoda imo jipapa ae. ");
INSERT INTO bhg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Edo iji ainde, Parasi maneda embo da (1) isima edo esisina, edo ainda dao awa Nicodemus. Imo awa Jew embomaida gisijiari da (1). ");
INSERT INTO bhg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Embo emi muyaede Iesu da yai gundo ainde sisina, “Atopatari, embo da ainmi kariwa engogo ine edo eta awa ari tao ae atako God embo ainde isira. Awatedo nakare awa gari, imo awa atopatari God mi piesiri guputeta.” ");
INSERT INTO bhg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu mi embo ainde mina sisina, “Eiwa awa gebé bajina imonde tena. Embo da ainmi God da gisijiari gari tao ae, atako embo awa tekago engari baina.” ");
INSERT INTO bhg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus mi Iesu de sisina, “Embo duga awa nongo edo tekago ainda aimi engaini? Imo ainda aida urida torari tenda engari tao aeǃ” ");
INSERT INTO bhg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu mi mina sisina, “Eiwa awa gebé bajina imonde tena. Embo da ainmi un ae God da Asisi deda engari awa bae gido, imo God da gisijiari yai torari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Embomai tamopiside awa tamopisi engedo era, edo God da Asisi awa asisi engedo eira. ");
INSERT INTO bhg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ge eiwa nanemi imonde tetena gido kore ainyae, ‘Imomane tekago engari buwo.’ ");
INSERT INTO bhg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bisimi enade bunade ainda jipapada tumundo eira. Edo imo ainda yavi ingido eta, ata nonda edo gundo eiri nonda maundo eiri awa gari tao ae. God da Asisi da wasiri awa dá ango embomai berarida yai ainkain ainda engari bari.” ");
INSERT INTO bhg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Edo Nicodemus mi ainde mina sisina, “Wasiri eiwa nongo nongo edo eiri?” ");
INSERT INTO bhg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu mi embo ainde mina sisina, “Imo awa Israel embomaida atopapasigarida bajina da (1), edo imo roviravi eiwa gae ta? ");
INSERT INTO bhg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Eiwa awa gebé bajina imonde tena. Nakare rorae matu gari awa tedo era, edo ro jisimi gari awa karigedo era, ata natokare karigari awa imomane bae. ");
INSERT INTO bhg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nane imondemane rorae butuda ro idegedo eira ainda ge tedo etena, ata imomane na gebé ae etewa. Awatedo nongo edo rorae utuda ge tano imomane gebé avi? ");
INSERT INTO bhg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Embo da ainmi utuda visido mambae ata Embo da Mai akuta. Edo daedo Embo da Mai utuda edo gupusina, edo imo utuda isima edo eira. ");
INSERT INTO bhg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Edo Moses mi jimbagoda kariwa abu damodamoda jiri vivisisina ango, Embo da Mai awa daedo jiaro vitaina awa, ");
INSERT INTO bhg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","berari ainmi gebé ari ainda yai pipiteira awa betainyae, ata wasiri natopo itari barate. ");
INSERT INTO bhg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“God mi embomai butu dededa dubobé burisina, awatedo ami ainda Mai dakaima awa pipisisina, berari ainmi gebé ari ainda yai pipiteira awa betainyae, ata wasiri natopo itari barate. ");
INSERT INTO bhg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Edo God mi ainda Mai butuda piesiri gupusina awa embomai butuda bekumba ainyae, ata ainda toda embomai butuda toregari borote. ");
INSERT INTO bhg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Embo da ainmi ainda gebé ari God da Mai da yai piedo eira awa, God mi imo bekumba ainyae, ata embo ainmi gebé ari ainda yai piae edo eira awa, aindabé ainda gebé ari God da Mai dakaimada yai piae, God mi matu bekumba esira. ");
INSERT INTO bhg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Edo God mi ango matu katesira, aindabé parara matu butuda gupusina, ata embomai buro bebegae edo esitera. Awatedo parara dubobae dodo muyae duboburitera. ");
INSERT INTO bhg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Berari ainmi bebegae edo eira, pararada gumbari gido ainda buro bebegae awa arapa aina, awatedo pararade sinigambari eite, edo pararada gumainyae edo eira. ");
INSERT INTO bhg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ata embo ainmi God da gebé kera edo eira awa, pararada gundo eira. Ango ari embomai berarimi ainda buro awa God da gorobami edo esira awa arapa gara.” ");
INSERT INTO bhg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ainda amboda, Iesu ae ainda ambodani de idegedo yai Judea da maunsitera. Edo imo awamanede daedo yai ainda isite embomai bapataito edo esisina. ");
INSERT INTO bhg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Edo iji ainde John awa daedo yai Aenon ainda isite embomai bapataito edo esisina. Yai Aenon awa Salim nasi aikae. Aindabé un jiwae yai ainda isima edo esisina, awatedo embomai gumboro bapataito edo esisina. ");
INSERT INTO bhg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(John awa Herod mi bundari oroda piae gisida, wasiri eiwa idegesisina.) ");
INSERT INTO bhg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ango edo John da ambodani ae Jew embo da (1)demi tamo teiarida ge baitera. ");
INSERT INTO bhg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Edo awamane John da yai gundo sitera, “Atopatari, embo Jodani un kupo neida imonde daedo isiri, imo averi awa karigatata, giyoǃ Embo ami embomai bapataito eira. Edo embomai berari awa ainda yai mauntera!” ");
INSERT INTO bhg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Edo John mi mina sisina, “Embo da ainmi ainda jipapa akutami da rorae bari tao ae, atako God da awara tarimi piari baina. ");
INSERT INTO bhg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Imomane akuta na ge ro arapada siutani awa gotewa, ‘Na awa Keriso ae, ata ainda gumbae gisida God mi na piesiri guputena.’ ");
INSERT INTO bhg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Embo da ainmi eutu jimaina awa jimbari tutu, edo eutu awa ainda aro. Edo ainda otawo demonda petedo isite ainda ge yavi ingeite do yawabé aina. Dá ango, nato do yawa ari iji einde gundo beda esira. ");
INSERT INTO bhg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Embo ainda dao ikane vitarate, edo dao nato awa wotarate sisina. ");
INSERT INTO bhg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Embo ikaneda edo gumbari, imo awa embo berari daginegari ikanebé. Embo butuda edo gumbari awa butu embo edo butu roraeda ge tedo eira. Embo utuda edo gumbari, imo awa embo berari daginegari ikanebé. ");
INSERT INTO bhg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Edo ami ro gosisina edo ingisina awa karigedo eira, ata da ainmi ainda ge awa bae edo eira. ");
INSERT INTO bhg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Aindabé embo awa God mi piesiri gupusina, ami God da ge tedo eira, edo God mi ainde Asisi tega itaebé pisido eira. Awatedo embo da ainmi ainda ge ingido gebé esira, ami arapa esira, God awa gebé. ");
INSERT INTO bhg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mamo mi ainda Mai dubobudo eira, edo rorae berari ainda ipada pipisisina. ");
INSERT INTO bhg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Embo ainmi ainda gebé ari Mai da yai pisido eira, wasiri natopo itari budo eira. Ata embo ainmi Mai kera ae edo eira, wasiri natopo itari bainyae, atako God da sinigambari ainda yai isima edo eira.” ");
INSERT INTO bhg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Edo Parasi manemi ge ingitera awa Iesu embomai jiwae bapataito edo eira, edo ainda ambodanida ajigari John da awa daginegesira. (Awarata, Iesu imo akuta awa bapataito ae, ata ainda ambodanimi edo esitera.) Ango edo, iji ainde Badari mi awa gido, yai Judea dodo tenda Galili da maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ata imo yai Samaria ainda temundo mambarate sisina. ");
INSERT INTO bhg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Awatedo imo yai Samaria da nasi bajina dao Saika ainda gupusina. Edo nasi ainda demonda awa butu tonga Jacob mi ainda mai Joseph de pipisisina. ");
INSERT INTO bhg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Edo Jacob da un mambari awa yai ainda. Edo Iesu pepeta riboribé esisina ami ipatai rejiwa esiri imo un mambari demonda anumbesisina. Edo awa ora 6 ango. ");
INSERT INTO bhg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Edo iji ainde ainda ambodani imo dodo indari oriain maundo nasida totoritera. Edo Samaria eutu awa un jimain gumbiri Iesu mi ainde sisina, “Na un pieyo inane.” ");
INSERT INTO bhg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Edo Samaria eutu ami ainde sisina, “Imo awa Jew embo edo na Samaria eutu. Ro embo ine namonde un atega esi?” (Jew ae Samaria embomai de dada edo umojiaede.) ");
INSERT INTO bhg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Edo Iesu mi mina eutude sisina, “Edo imo God da kando awa gari gido, edo embo ainmi imonde ge, ‘Na un pieyo inane,’ sira awa, ine ainde tedogato un wasiride awa piari bae eteta.” ");
INSERT INTO bhg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Edo eutu ami ainde sisina, “Embo bajina, un mambari awa ugonubé, edo imo un jimbari rorae itae. Yai nonda un wasiride awa basi? ");
INSERT INTO bhg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Natokare ewowo Jacob mi un mambari awa namondekare pipisisina, edo imo akuta ae ainda mamai de ainda womane demi un awa injitera. Imo embo awa daginegarita?” ");
INSERT INTO bhg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Edo Iesu mi eutu ainde mina sisina, “Berari ainmi un eiwa injido eira awa un udo tenda tenda aina. ");
INSERT INTO bhg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ata berari ainmi un nane piano inaina awa, mana un nei udo aina. Ata embo ande un awa piana, ami ainda doda un uriri ango sirido gubina eite ainda yai wasiri natopo itari piaina.” ");
INSERT INTO bhg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Edo eutumi ainde sisina, “Embo bajina, un eiwa namonde pieyo, na un udo tenda tenda ainyae edo un mambari einda un jimain gumainyae.” ");
INSERT INTO bhg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iesu mi eutu ainde sisina, “Maundo iu ito dao tedo einda kundo gumbuyo.” ");
INSERT INTO bhg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Eutu ami mina sisina, “Na iu itae.” Iesu mi eutu ainde sisina, “‘Na iu itae,’ teteta awa gebé. ");
INSERT INTO bhg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Imo ibonomai ipa da (5) jimundo dodo esiteta. Edo boroko embo imonde daedo isira awa ito iubé ae. Awatedo imo gebé namonde teteta.” ");
INSERT INTO bhg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Edo eutumi ainde sisina, “Embo bajina, na gotena, imo awa peroveta. ");
INSERT INTO bhg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Natokare ewowomi peji einda God tumondebain edo esitera, ata imomane Jew embomaimi Jerusalem ainda God tumondebain orote tedo ewa.” ");
INSERT INTO bhg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Edo Iesu mi ainde sisina, “Eutu, na gebé eyo, iji da (1) gupeira ainde imomane peji einda ko Jerusalem ainda Mamo tumondebain ainyae. ");
INSERT INTO bhg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","God awa inemane tumondebain edo ewa, imomane dave edo gae. Ata Jew embomaida yai edo God da toregari gumaina, awatedo God awa nanekare gari edo tumondebain edo era. ");
INSERT INTO bhg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mamo mi tumondebain aribé embomai ainkain imo tumondebain ara gain jipapa edo eira. Awarata iji gupeira edo matu gumbira einde tumondebain aribé embomaimi Mamo asisimi edo gebémi tumondebain ara. ");
INSERT INTO bhg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God awa Asisi, edo awamane ainmi imo tumondebain edo era awa, asisimi edo gebémi tumondebain edo orote sisina.” ");
INSERT INTO bhg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Edo eutumi ainde sisina, “Na gari, Messiah gupeira. (Ainda dao nei awa Keriso.) Iji ainde embo awa gumaina, ami rorae berari ari natokare yai arapa aina.” ");
INSERT INTO bhg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iesu mi eutu ainde sisina, “Na embo ami imonde ge tena.” ");
INSERT INTO bhg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Edo iji dá ainde ainda ambodani gundo Iesu eutu ainde ge siri gido korebé esitera. Ata da ainmi, “Imo ro jipapa esi?” o “Ro awaembo imo ae eutu ainde ge tesi?” awa tedogae. ");
INSERT INTO bhg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ango edo eutu awa ainda un sigi dodo maundo nasi bajinada torido embomaide sisina, ");
INSERT INTO bhg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Gumbuwo embo ouwa gave. Amimi ro berari nato wasirida esitena awa namonde tesira. Embo eiwa Keriso ta?” ");
INSERT INTO bhg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ango tesiri embomai nasi bajinada awa idegedo Iesu da yai tuturo edo guputera. ");
INSERT INTO bhg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Edo iji dá ainde ainda ambodanimi imonde atega edo esitera, “Atopatari, indari injiyo.” ");
INSERT INTO bhg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ata Iesu mi awamanede sisina, “Indari rorae nato isira imomane gae.” ");
INSERT INTO bhg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ango tesiri, ambodanimi akuta mina tara edo esitera, “Embo neneimi matu ainde indari kundo gumberita?” ");
INSERT INTO bhg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Edo Iesu mi awamanede sisina, “Nato indari rorae awa embo ainmi na piesiri guputena ainda jipapa awa kera ana, edo ainda buro awa petugana. ");
INSERT INTO bhg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Inemane tedo ewa awa kariga ipa ao pasido (4) awa itae ari tokari iji gumaina. Giwo, nane imondemane tena, itomane jisi piedo buro do jiwae ounda udugedo giwo. Indari matu tari edo ijijimbesira tokarida tegada isira. ");
INSERT INTO bhg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Edo indari tokari embo, ami ainda tau budo eira, edo imo rorae wasiri natopo itarate awa dada edo eira. Awatedo vero purara piari embo ae indari tokari embo demi doregedo yawa ara. ");
INSERT INTO bhg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kaenane ge eiwa tedo era, ‘Embo da (1)mi indari vero purara piedo eira, edo amboda embo neimi indari tokedo eira.’ Awa gebé. ");
INSERT INTO bhg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nane imomane indari tokawate pipitana yai ainda imomane gisi maundo buro ae. Embo neneimi awa yai ainda matu buro esitera, edo imomane awamaneda buro doda petugain totorawa.” ");
INSERT INTO bhg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aindabé eutu ami ge karigesisina, “Embo amimi ro berari nato wasirida esitena awa namonde tesira,” awatedo yai Samaria embomai jiwae nasi bajina ainda awamaneda gebé ari ainda yai pipisitera. ");
INSERT INTO bhg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ango edo yai Samaria embomai Iesu da yai gundo, imo awamanede daedo itarate atega esitera. Edo imo deguta tote (2) yai ainda isiri jijirisina. ");
INSERT INTO bhg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ango edo embomai nenei jiwae Iesu da ge ingido awamaneda gebé ari ainda yai pipisitera. ");
INSERT INTO bhg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Edo awamanemi eutu ainde sitera, “Nakare boroko gebé era, aindabé inemi teteta awa ae, ata nakare akuta ainda ge ingera, edo nakare gotera awa gebé. Embo eiwa Keriso, embomai butu berarida Toregari Embo.” ");
INSERT INTO bhg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Edo deguta tote (2) amboda, Iesu yai awa dodo yai Galili da maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Edo Iesu mi matu imo akuta ge karigesisina awa, iji angode peroveta ainda nasi topoda maundo isiari awamanemi imo tou ainyae.) ");
INSERT INTO bhg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Edo yai Galili embomaimi God da Darutegari Bondo Jerusalem da maundo isite, buro berari Iesu mi bondoda esiri daedo gositera. Awatedo iji angode imo yai Galili ainda gumbiri awamanemi imo ategedo buritera. ");
INSERT INTO bhg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Edo Iesu tekago nasi Keina da gupusina yai Galili doda, nasi ainda ami un esiri wareregedo waini esisina. Edo daotarida buro embo da (1)da mai awa karu eite Kapenium nasida isira. ");
INSERT INTO bhg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Edo iji ainde ainda mai betari aikae eiri embo emi Iesu yai Judea da edo idegedo Galili da torira awa ingisina. Awatedo imo Iesu da yai maundo ainde atega edo esisina, wotedo Kapenium da gundo mai awa ari kaviegarate. ");
INSERT INTO bhg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Edo Iesu mi embo ainde sisina, “Edo kariwa jiwae ae wasiri babain de awa inemane gisi gae isite awa, imomane mana gebé awa.” ");
INSERT INTO bhg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Edo daotarida buro embomi sisina, “Embo bajina, wotedo gumbuwasiǃ Imo gumbae gido mai nato awa betaina.” ");
INSERT INTO bhg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ango tesiri Iesu mi ainde sisina, “Awara, mambuyo! Mai ito kaviegesira.” Edo embo ami ge ro Iesu mi tesira awa gebé edo imo dodo tuturo edo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Edo imo matawa wotedo maunteiri ainda buro embobomi imo begatada tamundo ainde karigesitera, “Mai ito kaviegesiraǃ” ");
INSERT INTO bhg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ango tetero, ami awamanede tedogosisina, “Ora ro eiri mai nato dave esiri?” Edo awamanemi ainde sitera, “Avera angode ora 7 eiri ainda tamo vevera itae esira.” ");
INSERT INTO bhg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Awatedo mamomi gosisina ora dá ainde awa Iesu mi ainda yai sisina, “Mai ito kaviegesira.” Edo imo akuta awa ae ainda orobe berari de gebé esitera. ");
INSERT INTO bhg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Eiwa awa kariwa tote (2) Iesu mi esisina iji ainde ami Judea dodo yai Galili tekago totorisina. ");
INSERT INTO bhg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ainda amboda, Jew embomaida bondo ari iji gumbiri Iesu maundo Jerusalem vivisisina. ");
INSERT INTO bhg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Edo Jerusalem nasi matu jijitera ainda awa guwa gaiari. Edo guwa gaiari ainda be da (1)da dao awa Wo Sipumaneda Manguro Be, edo ainda demonda un tarari isinesina. Un tararida dao Hiburu gemi awa Betesida, edo un tarari arapada dasivi babain darari ainda ta piari berari ipa da (5) isima edo esisina. ");
INSERT INTO bhg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Duga einda awa karu egeregari jiwaebé durari isima edo esitera. Embomai jisiguba ari ae baoro bundari de ipatai ambari demi un wasiri ari gain sima edo esitera. ");
INSERT INTO bhg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Edo iji da (1)de anela wotedo un tarari awa davedo esisina. Edo un davedo itae euri ainda amboda, berari ainmi gisi unda wotedo esisina awa, karu ro berari ainde awa imo kaviegari budo esisina. ");
INSERT INTO bhg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Embo da (1) karu budo isite duberi 38 itae esisina, ami yai ainda durari isinesina. ");
INSERT INTO bhg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Edo iji angode Iesu mi embo durari isiri awa gido, ami gosisina, embo awa matu iji riboribé ango isima edo esisina. Edo ine embo ainde sisina, “Imo kaviegari udo esita?” ");
INSERT INTO bhg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Edo karu embo mi ainde mina sisina, “Embo bajina, un dawari iji ainde na embo ainmi un tararida piari wotani awa itae. Ata na gupeiwono embo nei da (1) na dodo gisi gundo unda wotedo eira.” ");
INSERT INTO bhg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ango tesiri Iesu mi ainde sisina, “Erido, topi ito kundo ainto eyo!” ");
INSERT INTO bhg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Edo burigibé embo awa esiri dave edo ainda topi kundo tuturo edo ainto esisina. Edo deguta awawa Oena Apari Degutade. ");
INSERT INTO bhg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Awatedo Jew embomai mi embo kaviegesira ainde sitera, “Boroko awa Oena Apari Deguta. Aodarida tari isira awa, imo topi amboka edo iainyae.” ");
INSERT INTO bhg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Edo ine awamanede mina sisina, “Embo na esiri dave etena, ami namonde tesira, ‘Erido, topi ito kundo ainto eyo!’” ");
INSERT INTO bhg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ango tesiri awamanemi imo tedogositera, “Embo awa ainmi imonde, ‘Erido, topi ito kundo ainto eyo,’ tesiri?” ");
INSERT INTO bhg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ata embomaida doregari yai ainda imo taigedo maunsisina. Awatedo embo gao ari bira ami embo averi awa gae. ");
INSERT INTO bhg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ainda amboda Iesu embo awa oro kotopu bajina arapada tamundo ainde sisina, “Giyo, imo eteno kaviegeteta. Jimbo beyae ainyae. Ango ata gido imo memesi bajinabé buriteta awa daginegari bata.” ");
INSERT INTO bhg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ango edo embo awa dodo maundo Jew embomaide tesiri gositera awa, Iesu mi imo esiri dave esira. ");
INSERT INTO bhg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Aindabé Iesu Oena Apari Degutade engo edo esisina, Jew embomaimi memesi neide kainde ainda yai piari tuturo esitera edo imo daro betarate begata kakowa edo esitera. ");
INSERT INTO bhg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ata ango eoro gido Iesu mi awamanede sisina, “Nato Mamo awa iji berari buro edo eira, edo gundo iji boroko einde buro eira. Edo na buro edo ena.” ");
INSERT INTO bhg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Gebé, Iesu mi awamaneda Oena Apari Degutada aodari awa deuri erigedo esisina. Ata awa akuta ae. Daedo imo tedo esisina awa, God awa ainda Mamo. Ango site imo akuta ae God de daedo inono esisina. Awatedo Jew embomaimi imo daro betarate jipapa bajinabé bajina edo esitera. ");
INSERT INTO bhg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Edo Iesu mi awa gido awamanede sisina, “Eiwa awa gebé bajina imondemane tena. Buro ro Mamo mi edo eira awa, daedo Mai mi dá awa edo eira. Awatedo Mai mi imo akuta buro dabé ari tao ae, ata Mamo mi ro edo eiri awa gido ami edo eira. ");
INSERT INTO bhg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Awa gebé, Mamo mi Mai dubobudo eira, edo ro berari Mamo mi akuta edo eira awa, euri Mai gido eira. Edo Mamo mi buro babain nenei eiwa daginegari awa Mai da yai ari gaina, imomane gido korebé awa. ");
INSERT INTO bhg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aindabé dá ango Mamo mi bebetegari jiuri eroreiworo awamanede wasiri piedo eira, dá ango Mai mi ande wasiri piari jipapa edo eira, ainde piedo eira. ");
INSERT INTO bhg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Edo daedo Mamo mi embo da ji katae edo eira, ata katari berari Mai da ipada pipisisina awa, ");
INSERT INTO bhg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","embomai berarimi Mai tou orote dá ango awamanemi Mamo tou edo era. Edo embo ainmi Mai tou ae edo eira awa, imo Mamo ain Mai piesiri gupusina awa tou ae edo eira. ");
INSERT INTO bhg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Eiwa awa gebé bajina imondemane tena. Imo ainmi ge nato ingeite, edo ainda gebé ari embo na piesiri guputena da yai pipiteite, wasiri natopo itari budo eira, edo imo jimbo beyaeda katari awa bainyae, ata betari awa matu dodo wasirida tembira. ");
INSERT INTO bhg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Eiwa awa gebé bajina imondemane tena. Iji gupeira edo boroko gumbira eire, embo bebetegarimi God da Mai da ge yavi ingara. Edo awamane ainmi ainda ge ingera awa, wasiri bara. ");
INSERT INTO bhg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Aindabé dá ango Mamo akuta awa wasiri tutu, ami awara tari Mai da yai pipisisina awa, dá ango Mai akuta wasiri tutu itarate. ");
INSERT INTO bhg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aindabé imo awa Embo da Mai, daedo Mamo mi ainda yai awara tari pipisisina awa, embomai katarate. ");
INSERT INTO bhg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","“Iji gupeira ainde ouwamane berari goiari yaida itera awa Embo da Mai da ge yavi ingido idegara. Edo ouwamane ainkain dave edo etera awa erido wasiri bara, edo ouwamane ainkain beyae edo etera awa erido katari bara. Awatedo ge eiwa ingido kore ainyae. ");
INSERT INTO bhg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nanemi akuta buro dabé ari tao ae. Dá Mamo natomi teuri ingido ena ango, na katedo ena. Nato jipapa bainyae edo ena, ata Mamo na piesiri guputena, ainda jipapa. Awatedo nato katari awa dambu darari. ");
INSERT INTO bhg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Edo nanemi na averi embomaide karigana, ro awaembo na gebé ari awa itae. ");
INSERT INTO bhg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ata embo nei mi embomaide nato daoda ge karigedo eira. Edo na gari, ainda ge nato daoda ami karigedo eira awa gebé. ");
INSERT INTO bhg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Inemane embobo John da yai pietewo maunsitera, edo ge awa ami imondemane karigesisina awa gebé. ");
INSERT INTO bhg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Edo embo enemboda karigari ge nato daoda tera awa rorae bajina ae. Ata ge eiwa tedo ena, imomane toregari bawate. ");
INSERT INTO bhg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John awa keimo benimbeteite parara piedo esisina ango. Edo iji tupo imomane ainda pararada yawa ain jipapa esitewa. ");
INSERT INTO bhg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ata rorae nei John da karigari daginegari awa nane burena. Buro babain awa Mamo mi nato yai petuganate pipisisina edo buro babain eiwa nane edo ena, eiwamanemi nato daoda karigedo era awa Mamo mi na piesiri guputena. ");
INSERT INTO bhg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Edo Mamo ami na piesiri guputena, imo akuta nato daoda ge karigesisina. Edo imomane da ji ainda ge yavi ingae, edo ainda dombu gae. ");
INSERT INTO bhg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Edo inemane embo awa Mamo mi piesiri gupusina awa gebé ae edo ewa, awatedo ainda ge itomane doda isima ae edo eira. ");
INSERT INTO bhg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Imomane kotembedo ewa awa wasiri natopo itarida begata awa God da Ove Gaiari doda isira. Awatedo imomane ainda ge ajijigedo gidogogo edo ewa. Edo Ove Gaiari emi na averi awa karigedo eira. ");
INSERT INTO bhg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ata imomane nato yai gundo wasiri bain jipapa ae edo ewa. ");
INSERT INTO bhg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Embo enemboda dasiga ari nato yai awa rorae bajina ae. ");
INSERT INTO bhg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ata na imomane gari. Itomane dubobari God da yai itae. ");
INSERT INTO bhg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na awa Mamo natoda daoda guputena, edo imomane na ategedo bae. Ata embo ainmi ainda dao akutada gumaina awa, imomane embo awa ategedo bawa. ");
INSERT INTO bhg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Imomane dasiga ari mina piya ari jipapa edo ewa, ata inemane buro dave awo God akutami imomane dasiga aina awa jipapa ae. Awatedo nongo edo imomane na gebé avi? ");
INSERT INTO bhg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ata nane imomane Mamo natoda dombuda bekumba ge tana awa kotemainyae. Embo da (1) imondemane bekumba tedo eira awa Moses, embo ainda yai itomane tumonda ari pipisitewa. ");
INSERT INTO bhg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Aindabé Moses mi nato daoda ove gagurisina, edo imomane embo awa gebé edo etewa gido, imomane na gebé ae etewa. ");
INSERT INTO bhg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ata imomane ainda ove gaiari gebé ae edo ewa, awatedo ro nane tena awa imomane gebé ari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ango edo ainda amboda, Iesu temundo Galili ubutu kupo neida maunsisina. (Ubutu ainda dao nei awa Taiberiasi.) ");
INSERT INTO bhg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Edo ine kariwa karu embomaida yai euri embo jiwae gido esitera. Awatedo embo jisi duga tuturo edo imo ambo ambo edo esitera. ");
INSERT INTO bhg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Edo Iesu visido maundo peji demonda edo, ae ainda ambodani de daedo anumbesitera. ");
INSERT INTO bhg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Edo iji ainde Jew embomaida Darutegari Bondo atutumbesisina. ");
INSERT INTO bhg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Edo Iesu jisi piedo embomai jisi duga imo kena gupero gido Philip de sisina, “Kaende bread yai nonda oriaro embomai eiwa indari?” ");
INSERT INTO bhg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iesu matu buro ro aina awa gosisina. Ata ge awa Philip bavedo gain site sisina. ");
INSERT INTO bhg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip mi mina ainde sisina, “Ganu 200mi bread inono mana oriaro awamane da da mi saka saka indara.” ");
INSERT INTO bhg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Edo Iesu da ambodani nei, Andrew (Simon Peter da nameji) mi Iesu de sisina, ");
INSERT INTO bhg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mai einda isira, edo ainda yai bread barley mi ari ipa da (5) ae un wo saka tote (2) de isira. Ata nongo edo rorae emi embomai jiwaebé eiwa kondade aini?” ");
INSERT INTO bhg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Edo Iesu mi sisina, “Tewo embomai anunumbore!” Edo yai ainda kinya jiwae erari isira. Awatedo embo jijianda berari 5,000 ango awa anunumbesitera. ");
INSERT INTO bhg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Edo Iesu bread kundo ategari God da yai pisido, ambodanide piesiri awamanemi embomai anunumbesitera awamanede kando kando esitera. Edo dá ango un wo de esisina. Edo indari nandogo embomai jipapa ero awamanemi pipisitera. ");
INSERT INTO bhg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Edo amboda awamane injido inono etero ami ainda ambodanide sisina, “Awara, ji itoto dotera awa dada ewo, da ji dowainyae.” ");
INSERT INTO bhg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Awatedo awamanemi bread ipa da (5) ainda ji itoto embomaimi injido doturitera awa, dada edo kanjia berari 12 awa sirero beda esisina. ");
INSERT INTO bhg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Edo iji amboda Iesu mi kariwa awa esiri gido embomaimi akuta tuturo edo mina tara esitera, “Gebé, Peroveta awa God mi butuda piari gumaina sisina awa eire.” ");
INSERT INTO bhg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Edo Iesu gira awa, awamanemi gundo imo ipami budo awamaneda daotari arate jipapa era, awatedo imo akuta tekago taigedo pejida maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ango edo, turo jirido gumbiri ainda ambodani wotedo ubutuda maunsitera. ");
INSERT INTO bhg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Edo muyae matu jiriri awamane mada visido gaigedo Kapenium nasi kena tepeite maunsitera. Edo Iesu awamaneda yai gumbae. ");
INSERT INTO bhg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Edo bisi ikanade tupeiri ubutuda kakawa erari tuturo esisina. ");
INSERT INTO bhg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ango esiri awamane ma davedo maundo kilometre 5 o 6 ango edo awamane Iesu un tamonda ainto edo ma kena gupeiri jisi piedo gido adu esitera. ");
INSERT INTO bhg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ata inemi awamanede sisina, “Na awara; adu eoveǃ” ");
INSERT INTO bhg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Edo awamanemi dubodavede imo ma doda buritera, edo ma awa burigibé yai awamane mauntera, ainda papoda denembesisina. ");
INSERT INTO bhg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Edo embomai ubutu kupo neida isite sipo neide erido gositera awa, muyae gisi awa ma da (1) akuta isiri Iesu da ambodanimi ma ainda vitera, edo Iesu ae ainda ambodani de daedo ma ainda vitae, ata ainda ambodanimi akuta ma ainde dodo mambera. ");
INSERT INTO bhg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Edo ainda amboda ma nenei Taiberiasi edo gundo yai Badari mi ategari pisido bread kando esiri embomaimi injitera, ainda demonda denembesitera. ");
INSERT INTO bhg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Edo iji ainde embomaimi Iesu ae ainda ambodani de yai ainda itae gositera, awatedo awamane daedo mada visido Iesu kakowa eite Kapenium temundo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ango edo awamane maundo ubutu kupo neida imo taputera. Edo awamanemi embo ainde tedogositera, “Atopatari, imo iji nonde einda gumbesi?” ");
INSERT INTO bhg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Edo Iesu mi awamanede mina sisina, “Eiwa awa gebé bajina imondemane tena. Aindabé inemane kariwa jiwae nane eteno gewa, edo na averi gewa, na kakowa ae. Ata imomane bread injido inono etewa, awatedo na kakowa ewa. ");
INSERT INTO bhg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tamopisida indari awa itae eira. Awatedo tamopisida indari akuta awaembo buro eove. Ata indari imondemane wasiri natopo itari piaina awaembo buro ewo. Indari awa Embo da Mai mi imondemane piaina. God Mamo mi ainda awara tari Mai da yai pipisisina buro awa arate.” ");
INSERT INTO bhg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Edo awamanemi ainde sitera, “Nakare buro ro aro God dubodave aini?” ");
INSERT INTO bhg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu mi awamanede mina sisina, “God da buro awa eire: embo ave ami piesiri gupusina, ainda yai itomane gebé ari piawate.” ");
INSERT INTO bhg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Awatedo awamanemi ainde sitera, “Kariwa ro ato idegari nakare jisimi gido imo gebé ari? Inemi buro ro asi? ");
INSERT INTO bhg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Natokare apiye ewowomi abu damodamoda rorae dao ‘manna’ injitera. God da Ove Gaiarida tari isira awa: ‘Imo utuda edo awamaneda yai indari bread pipisisina.’ ” ");
INSERT INTO bhg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Edo Iesu mi awamanede sisina, “Eiwa awa gebé bajina imondemane tena, Moses mi utuda edo imondemane bread piae. Ata Mamo natomi utuda edo imondemane bread bé pipisira. ");
INSERT INTO bhg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","God da bread awa embo ave utuda edo gupeite embomai butu berarida yai wasiri pipisira.” ");
INSERT INTO bhg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Edo awamanemi ainde sitera, “Embo bajina, namondekare bread eiwa iji matawa piewasi.” ");
INSERT INTO bhg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Edo Iesu mi awamanede sisina, “Na awa wasiri piarida bread. Embo ainmi nato yai gupeite awa, mana beji aina, edo embo ainmi ainda gebé ari nato yai pipisite awa, mana un udo tamaina. ");
INSERT INTO bhg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ata nane imondemane gisi tetena, imomane na daedo gewa, awarata imomane gebé ae. ");
INSERT INTO bhg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Edo embo avekave Mamo mi namonde piedo eira awa, berari nato yai gumbara. Edo berari ainmi nato yai gupeiari awa, nanemi mana onano mamaina. ");
INSERT INTO bhg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na utuda edo wotedo guputena awa, nato jipapa ain gumbae, ata embo ainmi na piesiri guputena ainda jipapa awa anate. ");
INSERT INTO bhg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Edo Mamo na piesiri guputena, ainda jipapa awa evire, embo berari namonde pipisisina ainda da (1) nane dadoegainyae, ata deguta beao arida awamane berari jiano eraina. ");
INSERT INTO bhg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Edo imo na piesiri guputena, ainda jipapa awa evire, berari ainmi Mai gosite, edo gebé ari ainda yai pipisite awa, wasiri natopo itari baina, edo nanemi deguta beao arida jiano eraina.” ");
INSERT INTO bhg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ango edo Jew embomaimi tuturo edo ge guguma gaguma ainda daoda sitera, aindabé ine sisina, “Na awa bread utuda edo wotedo guputena.” ");
INSERT INTO bhg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Edo awamanemi tedo esitera, “Aee, eiwa Iesu, Joseph da mai. Ainda mamo ae ai de kaena gari. Nongo edo ine, ‘Na awa utuda edo guputena,’ ango siri?” ");
INSERT INTO bhg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Awatedo Iesu mi awamanede mina sisina, “Imomane akuta ge guguma gaguma teove dowo. ");
INSERT INTO bhg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Embo da ji ainda jipapami nato yai gumbari tao ae. Atako Mamo na piesiri guputena ami awa emboda do dumbari nato yai gumbarate. Edo nanemi deguta beao arida jiano eraina. ");
INSERT INTO bhg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ge Peroveta maneda Ove Gaiarida isira awa, ‘Awamane berari God mi atopataina.’ Awatedo berari da da ain Mamo da ge ingite, edo ainda atopatari budo, nato yai gundo eira. ");
INSERT INTO bhg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Edo embo da ain Mamo jisimi gae, ata imo ain God da yai edo gupusina, ami akuta Mamo gosisina. ");
INSERT INTO bhg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Eiwa awa gebé bajina imondemane tena. Embo da ainmi ainda gebé ari nato yaida pipisite awa, wasiri natopo itari budo eira. ");
INSERT INTO bhg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na awa wasiri piarida bread. ");
INSERT INTO bhg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Itomane apiye ewowomi abu damodamoda manna injitera, awarata, awamane bebetegesitera. ");
INSERT INTO bhg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ata bread eiwa, utuda edo wotedo gundo eiri awa, embo ainmi awa injido betainyae. ");
INSERT INTO bhg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na awa bread wasiride, utuda edo wotedo guputena. Embo ainmi bread eiwa inaina, imo wasiride natopo itaina. Edo bread nane piana awa nato pisi. Awa nane embomai butu berarida ainda wasiri awaembo piana.” ");
INSERT INTO bhg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ango tesiri Jew embomai awamane akuta tuturo edo sinigambari edo ge baieite sitera, “Embo eiwa ainda pisi nongo edo kaenato yai piari indari?” ");
INSERT INTO bhg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Edo Iesu mi awamanede sisina, “Eiwa awa gebé bajina imondemane tena. Imomane Embo da Mai da pisi awa indae edo ainda ororo indae gido, imomane wasiri bari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Embo da ainmi nato pisi indeite edo nato ororo indeite awa, wasiri natopo itari budo eira, edo deguta beao arida nane imo jiano eraina. ");
INSERT INTO bhg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Gebé, nato pisi awa indaribé edo nato ororo awa indaribé. ");
INSERT INTO bhg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Embo da ain nato pisi indeite edo nato ororo injido eira awa, imo nato doda isima edo eira, edo na ainda doda isima edo ena. ");
INSERT INTO bhg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wasiri piarida Mamo mi na piesiri guputena, edo inemi eiuri na wasiri budo ena. Dá ango embo da ain na injido eira, nane ano embo awa wasiri baina. ");
INSERT INTO bhg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bread eiwa utuda edo wotedo gupusina. Itomane apiye ewowomi manna injitera, awarata, awamane bebetegesitera. Ata embo da ainmi bread eiwa injido eira awa wasiride natopo itaina.” ");
INSERT INTO bhg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu mi ge eiwa benunu oro doda atopaposite sisina, Kapenium nasida. ");
INSERT INTO bhg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Awatedo ainda ambodani jiwaemi ge eiwa ingido sitera, “Eiwa awa atopatari okain edo embo da ainmi bari tao ae!” ");
INSERT INTO bhg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Edo Iesu, imo akuta awa gari ainda ambodani ge eiwa ingido guguma gaguma tera. Awatedo awamanede sisina, “Ge emi eiri itomane gebé ari nato yaida dowain jipapa evita? ");
INSERT INTO bhg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Edo imomane Embo da Mai tekago overegedo ainda yai utuda viviteiari gido, nongo avi? ");
INSERT INTO bhg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Asisi Kotopu mi embomaide wasiri piedo eira. Tamopisimi piari tao ae. Edo ge nane tena ami itomane asisi kondade aina edo wasiri piaina. ");
INSERT INTO bhg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ata itomane doda embo nenei awa gebé ae era.” (Iesu mi tuturoda edo gosisina awa, awamane ainkain awa gebé ae ari, edo embo ainmi imo gitopo emboda ipada piaina, awatedo Iesu awa sisina.) ");
INSERT INTO bhg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Edo ami tedo sisina, “Aindabé eiwa nane imondemane tetena awa, embo da ji nato yai gumbari tao ae, atako embo da ave Mamo natomi ainda yai udo ari do pipisisina.” ");
INSERT INTO bhg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ainda amboda, ainda ambodani jiwae ainde daedo tenda pepeta ae doturitera. ");
INSERT INTO bhg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Edo Iesu mi ambodani 12de sisina, “Imomane daedo na dodo mamain jipapa evita?” ");
INSERT INTO bhg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Edo Simon Peter mi ainde mina sisina, “Badari, nakare anda yai mambari? Wasiri natopo itarida ge ito yai isira. ");
INSERT INTO bhg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Edo nakare gebé esitera edo gositera awa, imo awa Keriso, God wasirideda Mai.” ");
INSERT INTO bhg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Edo Iesu mi awamanede mina sisina, “Nane imomane 12 geritena, ata itomane doregari doda embo da (1) awa Binei mi gisijido eira!” ");
INSERT INTO bhg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesu mi Judas da ge einda sisina, edo Judas awa Simon Iscariot da mai. Imo awa ambodani 12 ainda da (1), awarata amboda ami Iesu gitopoda ipada piaina. ");
INSERT INTO bhg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Edo einda amboda Iesu yai Galili ainda pepeta edo esisina. Aindabé Jew embobo mi imo daro betarate siya edo era awa gido gido, imo yai Judea doda pepeta edo mambari jipapa ae edo esisina. ");
INSERT INTO bhg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Edo Jew embomaida Dogara Arida Bondo iji atutumbesisina. ");
INSERT INTO bhg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ango edo Iesu da nanonamejimi ainde sitera, “Imo einda edo dodo Judea mambuyo, ito ambodanimi buro babain edo eta awa daedo gore. ");
INSERT INTO bhg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Embo da ainmi ainda buro dave embo berarida yai arapa ain jipapa edo eira gido, ainda buro onjigainyae. Edo imo buro eiwa edo eta gido, imo akuta embomai berarida jisida eyo gore.” ");
INSERT INTO bhg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ainda nanonamejibémi awamaneda gebé ari ainda yai piae edo esitera, awatedo ge ango sitera. ");
INSERT INTO bhg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ango edo Iesu mi awamanede sisina, “Iji nato awa boroko gumbae. Ata itomane yai iji berari awa dave. ");
INSERT INTO bhg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Butu embomai awa sinigambari imondemane ari tao ae. Ata nane awamaneda jimbo bebegae karigedo ena, awatedo awamane namonde sinigambari edo era. ");
INSERT INTO bhg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Imomane awa bondo einda visido mambuwo. Iji nato awa bé gumbae, awatedo na awa bondo einda boroko visido mamainyae.” ");
INSERT INTO bhg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Edo amboda Iesu ge eiwa awamanede sisina, imo yai Galili ainda iji tupo isiri jijirisina. ");
INSERT INTO bhg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Edo amboda, ainda nanonameji dodo bondoda visido maunsitera, imo daedo bondoda maunsisina. Awarata, imo awa arapada mambae, ata onjigedo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Edo bondo einda Jew embobomi imo awa gain kakowa eite tedogido esitera, “Embo eiwa nonda isiri?” ");
INSERT INTO bhg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Edo embo jisijisi awamaneda doda ami Iesu da daoda ge pisipasi jiwae tedo esitera. Neneimi tedo esitera, “Embo awa dave.” Edo embo neneimi mina awamanede tedo esitera, “Ango ae, embo ami embomai dubo butedo eira.” ");
INSERT INTO bhg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Awarata awamane Jew embobo awa adu esitera, awatedo embo da ainmi ainda daoda ge arapada tae. ");
INSERT INTO bhg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Edo iji ainde bondoda pura kupo da (1) awa itae eiri Iesu maundo visido oro kotopu bajinada yai torido embomai tuturo edo atopaposisina. ");
INSERT INTO bhg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Edo Jew embomaimi korebé eite sitera, “Embo eiwa God da Ove Gaiarida gari eiwa nongo edo burisini? Imo atopatari bae!” ");
INSERT INTO bhg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Awatedo Iesu mi awamanede mina sisina, “Atopatari nato awa nato topo ae, ata awa imo ainmi na pipisisina, ainda edo gundo eira. ");
INSERT INTO bhg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Edo embo da ainmi God da jipapa ain jipapa aina gido, atopatari nato awa God da yai edo gundo eirita o awara tari nato akutada awa ge tedo enita awa gaina. ");
INSERT INTO bhg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Embo ainmi awara tari ainda akutada ge site awa, tou ari ainda akuta bain jipapa edo eira. Ata embo ainmi embomi imo piesiri gupusina tou ain jipapa edo eira, imo awa gebé, edo ainda yai jimbo beyae itae. ");
INSERT INTO bhg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses imondemane aodari awa pipisisinita? Awara, ata imomane da ainmi kera ae. Imomane ro awaembo na dawo betanate jipapa evi?” ");
INSERT INTO bhg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Edo embomaimi mina sitera, “Imo awa bineimi gisijido eira. Embo ainmi imo dari betatate jipapa eiri?” ");
INSERT INTO bhg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu mi awamanede mina sisina, “Nane buro bajina da (1) eteno imomane berari korebé ewa. ");
INSERT INTO bhg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Imomane tamo jiugari da ge okain Moses mi pipisisina awa kera edo ewa. (Awarata Moses mi awa tuturoda piae, ata apiye ewowomi tuturoda pipisitera.) Edo iji nenei Oena Apari Degutade mai jianda tamo jiugedo ewa. ");
INSERT INTO bhg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Edo mai jianda Oena Apari Degutade tamo jiugedo ewa, Moses da aodari dawo erigainyae awate, edo Oena Apari Degutade nane embo gao eteno ainda tamoda kaviegari berari burara amo, ro awaembo imomane namonde sinigambari evi? ");
INSERT INTO bhg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Imomane na jisimi gari akuta awa goteite katainyae, ata katari wasiri dambu dararimi na goteite katewo.” ");
INSERT INTO bhg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Edo Jerusalem embomai neneimi tuturo edo tedogositera, “Embo daro betarate darera awa evirita? ");
INSERT INTO bhg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ata giwo! Embo awa eire ge arapada sira, edo awamanemi ainde ge da ro tae. Gisijijiegarimi garibé bera awa, embo eiwa Keriso bé tarora? ");
INSERT INTO bhg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Awarata kaen awa gari embo eiwa yai nonda edo gupusini awa. Ata iji nonde Keriso gumaina awa, da ainmi embo awa yai nonda edo gumaini awa gae.” ");
INSERT INTO bhg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ango edo Iesu oro kotopu bajina arapada atopaposiri jiriri aorogatedo sisina, “Imomane na awa gari edo daedo na nonda edo gumbari awa gari. Awarata na awara tari nato akutada einda gumbae, ata embo ami na piesiri guputena awa gebé, edo inemane embo awa gae. ");
INSERT INTO bhg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ata na embo ainda yai edo gumbari, edo embo ami na piesiri guputena, awatedo na embo awa gari.” ");
INSERT INTO bhg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Edo ainda iji awa gumbae isira, awatedo awamanemi Iesu kumain esitera, ata embo da ainmi ainda tamoda ipa piae. ");
INSERT INTO bhg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Edo embomai jiwae embo jisi da (1) doda awamaneda gebé ari ainda yai pipisitera, edo awamanemi tedo esitera, “Iji nonde Keriso gumaina awa inemi kariwa jiwae embo emi edo eutara amo daginegainita?” ");
INSERT INTO bhg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Edo Parasi manemi embomai jisi da (1) doda ami Iesu da daoda ge awawa pisipasi tero ingitera. Ango edo Parasi mane ae pirisi babain demi oro kotopu bajinada sima ari embobo pietero imo jido kumain maunsitera. ");
INSERT INTO bhg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Edo Iesu mi sisina, “Na imondemane iji tupo akuta sima ana, edo imo ainmi na piesiri guputena ainda yai mamana. ");
INSERT INTO bhg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Edo imomane na gain kakowa awa, ata imomane na tambae awa. Edo na yai nonda itana awa, imomane gumbari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Awatedo Jew embomaimi ge mina tara esitera, “Embo yai nonda mambari kaenane kakowa edo tambae ri? Guriki embomaida yai ounda kaenato orobe nenei ainda isima edo era awa isira. Embo ami yai ounda maundo Guriki embomai atopatainita? ");
INSERT INTO bhg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ami tesira, ‘Imomane na gain kakowa awa, ata imomane na tambae awa.’ Edo ami tesira, ‘Na yai nonda itani awa, imomane gumbari tao ae.’ Ge einda moka awa rori?” ");
INSERT INTO bhg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Edo bondoda deguta beaoda, deguta bajina ainde, Iesu mi erido petedo ge aorogateite sisina, “Embo da ainmi un udo eira gido, embo awa nato yaida gundo indarate. ");
INSERT INTO bhg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Embo ainmi ainda gebé ari nato yaida pipisite awa dá God da Ove Gaiarida ge sisina ango, un wasiride ainda doda edo visido beda edo dodedo wotaina.” ");
INSERT INTO bhg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Ata ge eiwa awa God da Asisi da ge Iesu mi sisina. Edo embo ainkainmi awamaneda gebé ari Iesu da yai pipitero awa, God mi ainda Asisi Kotopu awamaneda yai piain esisina. Awarata iji ainde Iesu mi ainda taogari utuda visido bae. Awatedo iji ainde God mi ainda Asisi awamaneda yai piae.) ");
INSERT INTO bhg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Awatedo iji angode embo jiwae jisi da (1) doda ge eiwa ingido, awamanemi tedo esitera, “Gebé, embo eiwa awa Peroveta.” ");
INSERT INTO bhg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Embo neneimi tedo esitera, “Embo eiwa awa Keriso.” Ata neneimi tedo esitera, “Nongo edo Keriso yai Galili da edo gumaini? ");
INSERT INTO bhg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","God da Ove Gaiari sisina awa, Keriso, David da orobe da edo gumaina, edo imo Beteliem nasida edo gumaina. Nasi ainda David isima edo esisina.” ");
INSERT INTO bhg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Edo embomaimi Iesu da daoda ge mina tara edo avigekavige esitera. ");
INSERT INTO bhg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Edo nenei imo kumain jipapa edo esitera, ata embo da ainmi ainda yai ipa piae. ");
INSERT INTO bhg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ango edo oro kotopu bajina sima ari embobo egenembedo pirisi babain ae Parasi mane deda yai maunsitera. Edo awamanemi sima ari embobode sitera, “Ro awatedo embo awa kundo gumbae etevi?” ");
INSERT INTO bhg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Edo sima ari embobomi mina sitera, “Embo da ainmi ge embo emi tesira ango awa gisi tae nakare gae!” ");
INSERT INTO bhg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Edo Parasi manemi awamanede mina sitera, “Imomane daedo udumbesirita? ");
INSERT INTO bhg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Gisijijiegari ko Parasi mane da ainmi ainda gebé ari ainda yai piesirita? Ango ae! ");
INSERT INTO bhg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ata embo jisi da (1) emi aodari awa gae. Awatedo God da begá awamaneda yai isira.” ");
INSERT INTO bhg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","(Nicodemus awa embo ainmi muyaede Iesu da yai gupusina. Imo daedo awa Parasi maneda da (1) awamane doregari doda.) Edo embo ami awamanede sisina, ");
INSERT INTO bhg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kaenato aodarida isira awa emboda ge awa gisi ingae edo ainda buro rori awa gae isite embo awa katainyae.” ");
INSERT INTO bhg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Edo awamanemi mina ainde sitera, “Imo daedo Galili embo ta? God da Ove Gaiari awa ajijigedo giyo. Peroveta da ji awa yai Galili da edo gumbae.” ");
INSERT INTO bhg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ango edo embo da da dodo ainda mando topoda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ata Iesu Olive de Peji ainda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Edo sipobéde imo tenda egenembedo oro kotopu bajinada yai toriri embomai berarimi ainda yai gundo esitera. Edo ine anumbedo awamane tuturo edo atopaposisina. ");
INSERT INTO bhg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ango edo Aodarida atopapasigari ae Parasi mane demi eutu da (1) ipuda eiri awa tamundo ainda yai kundo guputera. Edo awamanemi embomai doregetera awamaneda dombuda eutu awa pietero peposisina. ");
INSERT INTO bhg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Edo awamanemi Iesu de sitera, “Atopatari, eutu eiwa ipuda arida jimbobé eiri tambera. ");
INSERT INTO bhg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Edo Moses mi ge okain kaenato Aodari doda sisina awa, eutu ango awa ganumami daro betarate sisina. Ata imo ge ro tasi?” ");
INSERT INTO bhg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Edo awamanemi ge eiwa wao ango jigamo edo Iesu bekumba ain sitera. Ata Iesu atembedo ipa toromi butuda ove tuturo edo gagurisina. ");
INSERT INTO bhg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Edo awamanemi tedogari ainde dowae matawa tero imo pangedo awamanede sisina, “Imomane embo da ainmi jimbo beyae itae gido ine gisi ganuma budo augedo eutu eiwa dari betare.” ");
INSERT INTO bhg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ango edo imo tekago atembedo butuda ove gagureite isiri, ");
INSERT INTO bhg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","awamane ge awa ingido da da tuturo edo idegedo bodembesitera. Edo embo mamatu gisi idegedo maunsitera, edo embo teteka ambobéda idegesitera. Ango edo awamane Iesu akuta dodo, edo eutu awa daedo embomaida doregari doda petari isiri doturitera. ");
INSERT INTO bhg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Edo Iesu erido petedo eutu gido ainde sisina, “Eutu, embo imo bekumba etera, awamane yai nonda mamberi? Embo da ainmi imo bekumba ae ta?” ");
INSERT INTO bhg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Eutu ami sisina, “Badari, embo da ainmi na katae.” Edo Iesu mi ainde sisina, “Na imo daedo katainyae. Mambuyo, edo boroko einda edo tenda jimbo beyae ainyae.” ");
INSERT INTO bhg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Edo iji ainde Iesu mi tenda embomaide ge tedo sisina, “Na awa embomai butu dededa parara. Embo da ainmi na ambo ambo edo eira awa, mana muyaeda pepeta aina, ata wasiri piarida parara baina.” ");
INSERT INTO bhg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ango tesiri Parasi manemi ainde sitera, “Inemi ito daoda ge embomaide karigedo eta, awatedo ro awaembo nanekaremi ito karigari ge awa gebé ara awa itae.” ");
INSERT INTO bhg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Edo Iesu mina awamanede sisina, “Na yai nonda edo guputeni edo yai nonda maunteni awa na gari. Awatedo, edo nanemi nato daoda ge karigedo ena, nato karigari ge awa gebé. Ata imomane na yai nonda edo guputeni edo yai nonda maunteni awa gae. ");
INSERT INTO bhg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Edo itomane katarida tega awa dá embo enembomi jigamo edo era ango. Ata na embo da (1) ande katari piae de. ");
INSERT INTO bhg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Awarata, na awa akuta ae, ata na Mamo na piesiri guputena ainde daedo isima edo ena. Edo nane katana gido, nato piari petari awa gebé. ");
INSERT INTO bhg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Edo daedo itomane Aodarida gaiari isira awa, iji ainde karigari ge dá awa embo tote (2)mi tara gido, awa gebé. ");
INSERT INTO bhg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nanemi nato daoda ge karigedo ena. Edo Mamo ain na piesiri guputena awa nato daoda ge karigedo eira.” ");
INSERT INTO bhg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ango edo awamanemi embo ainde sitera, “Ito Mamo awa indari?” Iesu mina sisina, “Imomane na averi awa gae edo Mamo nato averi awa gae. Edo imomane na averi awa gari gido, imomane Mamo nato averi awa gari.” ");
INSERT INTO bhg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Oro kotopu bajinada yai arapada embomaimi awamaneda ategari ganu God de pisido esitera, ainda demonda Iesu mi atopaposite ge eiwa sisina. Ata ainda iji awa gumbae isira, awatedo iji angode embo da ji ainmi imo kumbae. ");
INSERT INTO bhg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Edo Iesu mi tekago awamanede ge tedo sisina, “Na mamain ena. Edo imomane na gain kakowa awa, edo imomane itomane jimbo beyaeda betawa. Yai nonda na mamain ena awa, imomane gumbari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ami ango tesiri Jew embomai akuta tedogido esitera, “Embo ami ‘Na yai nonda mamani ainda imomane gumbari tao ae,’ sira awa, imo akuta dedo betainita?” ");
INSERT INTO bhg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Edo Iesu mi awamanede sisina, “Imomane awa kambe embomai; na awa yai ikane embo. Imomane awa butu eiwa topo embomai; na awa butu eiwa topo ae. ");
INSERT INTO bhg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Aindabé imomane na averi tetena awa gebé ae gido, itomane jimbo bebegaeda betawa. Awatedo nane imondemane tetena awa, itomane jimbo bebegaeda betawa.” ");
INSERT INTO bhg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Edo awamanemi embo ainde sitera, “Imo averi?” Edo Iesu awamanede sisina, “Na averi awa tuturoda siwono gido esitewa. ");
INSERT INTO bhg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nanemi ge jiwae itomane daoda bureite imondemane tedo katae etena. Awarata, ge awa ainmi na piesiri guputena namonde tedo eira awa akuta tana. Imo awa gebé, edo ge ro ainda yai ingido ena awa, nane embomai butu dedede tedo ena.” ");
INSERT INTO bhg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Edo awamanemi gae arapa ae Mamo da daoda ge awamanede tedo esisina awa. ");
INSERT INTO bhg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Awatedo Iesu mi awamanede sisina, “Embo da Mai jiawo vitaina iji ainde, na gawa awa na awara. Edo nanemi akuta buro dabé ari tao ae, ata dá Mamo natomi na atopasido tanate sisina ango, ge eiwa tedo ena. ");
INSERT INTO bhg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Edo embo ainmi na piesiri guputena awa namonde daedo isima edo eira. Nane iji berari imo dubodave arate buro edo ena, awatedo Mamo mi na dowae akuta itae.” ");
INSERT INTO bhg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Edo iji angode imo ge eiwa siri embomai jiwae awamaneda gebé ari ainda yai pipisitera. ");
INSERT INTO bhg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Edo Iesu mi Jew embomai ainmi awamaneda gebé ari ainda yai pietera awamanede sisina, “Imomane nato ge matawa kera awa gido, imomane awa nato ambodanibé. ");
INSERT INTO bhg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Edo imomane gebé awa gawa, edo gebé ami imomane udegaina.” ");
INSERT INTO bhg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Edo awamanemi ainde mina sitera, “Nakare awa Abraham da apipiye, edo nakare iji gisi edo gundo gundo iji boroko einde, embo da (1) anda buro embobo ae. Ro embo inemi nakare udegari bara tesi?” ");
INSERT INTO bhg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu mi awamanede mina sisina, “Eiwa awa gebé bajina imondemane tena. Embo berari ainmi jimbo beyae edo eira, imo awa jimbo beyaeda buro embo. ");
INSERT INTO bhg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Edo buro emboda yai ainda badararida orobeda awa natopo itari ae, ata maida yai orobeda awa natopo itari. ");
INSERT INTO bhg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Awatedo, Mai mi imomane udegaina gido, imomane udegaribé bawa. ");
INSERT INTO bhg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Edo na gari imomane awa Abraham da apipiye. Ata nato geda itari yai itomane doda awa itae, awatedo na dawo betanate jipapa edo ewa. ");
INSERT INTO bhg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Edo rorae ro nato Mamo da yai gositena awa, nane tedo ena. Edo rorae ro itomane mamoda yai gositewa awa, inemane edo ewa.” ");
INSERT INTO bhg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Edo awamanemi ainde mina sitera, “Abraham awa natokare mamo.” Iesu mi awamanede sisina, “Edo imomane awa Abraham da mamai gido awa, imomane buro ro Abraham mi edo esisina awa edo ae etewa. ");
INSERT INTO bhg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Edo na gebé God da yai ingido awa imondemane tetena. Awarata, boroko imomane na dawo betanate jipapa ewa. Abraham mi buro ango ae! ");
INSERT INTO bhg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Inemane mamo itomaneda buro edo ewa.” Awatedo awamanemi ainde sitera, “Nakare awa toropu mamai ae. Mamo natokare akuta awa God.” ");
INSERT INTO bhg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Edo Iesu mi awamanede sisina, “Na God da yai edo guputena edo na awa einda. Daedo nato awara tari akutada awa gumbae, ata inemi na piesiri guputena. Awatedo, edo God awa itomane Mamo gido awa, imomane na dubobae edo etewa. ");
INSERT INTO bhg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ge nane imondemane tena awa ingain jipapa ae, awatedo imomane ge nato gari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Binei awa itomane mamo topo, edo itomane mamoda jipapa ain edo ewa. Embo ami tuturobéda embo deuri betedo esitera, edo gebé awa ainda yai itae. Awatedo gebé awa jido petae. Embo awa ge pitawa tari embo edo ge pitawa tarida mamo. Awatedo iji nonde imo ge pitawa taina, ainda ge topobé ami tedo eira. ");
INSERT INTO bhg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ata nane gebé tedo ena, awatedo imomane na gebé ae edo ewa. ");
INSERT INTO bhg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Imomane embo da ainmi nato jimbo beyae da ji awa karigeteiri? Edo na imondemane gebé tena gido awa, ro embo na gebé ae evi? ");
INSERT INTO bhg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Embo ave God da topo ami awa, God ge siuri ingido eira. Imomane God da topo ae, awaembo imomane ainda ge ingae edo ewa.” ");
INSERT INTO bhg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Edo Jew embomaimi ainde mina sitera, “Nanekare imo awa Samaria embo edo imo awa bineimi gisijido eira tetera. Imo ango awa gebé rita?” ");
INSERT INTO bhg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu mi mina sisina, “Na awa bineimi gisijiaede. Ata na Mamo nato tou edo ena, edo imomane mengari nato yai piedo ewa. ");
INSERT INTO bhg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Edo nato dao awa embomaimi jiaro erarate kakowa ae. Embo da (1) isira ami nato dao awa jiari erarate jipapa edo eira, edo imo embomai berari katedo eira. ");
INSERT INTO bhg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Eiwa awa gebé bajina imondemane tena. Embo da ainmi ge nato kera edo aina gido awa betari mana gaina.” ");
INSERT INTO bhg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ango tesiri Jew embomaimi ainde sitera, “Nakare boroko gari bera, bineimi imo gisijido eira! Abraham besisina, edo peroveta mane daedo besitera, edo ine teta, ‘Embo da ainmi ge nato kera edo aina gido awa betari manabé gaina.’ ");
INSERT INTO bhg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Imo bajina ta, ko mamo natokare Abraham awa bajina ri? Embo awa besisina, edo peroveta mane besitera. Imo awa embo ave kotembetesi?” ");
INSERT INTO bhg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu mi mina sisina, “Edo nane dao nato dasiga ana gido, nato dasiga ari awa itae. Mamo nato ande ‘natokare God’ tedo ewa, ami dao nato dasiga edo eira. ");
INSERT INTO bhg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Awarata imomane embo awa gae, ata embo awa na gari. Edo nane tana, ‘Embo awa na gae,’ na awa ge pitawa tari embo dá imomane ango ana. Ata na embo awa na gari edo ainda ge kera edo ena. ");
INSERT INTO bhg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Itomane mamo Abraham, nato gumbari iji gain eite do yawa bajinabé esisina. Edo imo gido yawa esisina.” ");
INSERT INTO bhg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Edo Jew embomaimi ainde sitera, “Imo awa duberi 50 awa bé bae! Nongo edo imo Abraham gositesi?” ");
INSERT INTO bhg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Edo Iesu mi awamanede sisina, “Eiwa awa gebé bajina imondemane tena. Abraham engae gisida na itena!” ");
INSERT INTO bhg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Edo ge ango tesiri awamane ganuma budo embo awa daro betarate sitera. Ata Iesu akuta onjigedo awamaneda doda maunsite oro kotopu bajinada yai idegesisina. Edo awamane ango daginegesisina. ");
INSERT INTO bhg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ango edo Iesu ainto edo maunteite embo da (1) jisiguba ari aida urida engari awa gosisina. ");
INSERT INTO bhg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Edo ainda ambodanimi embo ainde tedogositera, “Atopatari, anda jimbo beyaemi esiri embo eiwa jisiguba ari engisini? Awa ainda jimbo beyae akuta ta ko embo einda aimamoda jimbo ri?” ");
INSERT INTO bhg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Edo Iesu mi mina sisina, “Embo ainda jimbo beyae ae, o ainda aimamoda jimbo beyae ae, ata imo jisiguba ari isira awa God mi ainda goroba ari ainda yai arapa ari embomaimi gorote tedo. ");
INSERT INTO bhg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iji inono isiari ainde nane buro awawa embo na piesiri guputena ainda jipapa awa anate. Muyae iji gupeira ainde embo da ainmi buro ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Iji dá ainde na butuda isima edo ena, na awa embomai butu dededa parara.” ");
INSERT INTO bhg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iesu ge eiwa sisina, edo imo butuda kosiwa esisina. Ango edo ami butu tatapu ae beporo de daedo baige edo kundo embo jisiguba ari ainda jisida dasisina. ");
INSERT INTO bhg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Edo embo ainde sisina, “Mambuyo Siloam Un Tarari ainda, edo teieyo.” (Siloam da moka awa Piari Mambari.) Ango tesiri embo awa maundo teiedo yai goteite gupusina. ");
INSERT INTO bhg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Awatedo nembu mane ae embomai nenei demi embo jisiguba ari awa isiuri gisi gido esitera ami mina tara edo esitera, “Embo eiwa anumbedo isite embode rorae atega edo esira, awarita?” ");
INSERT INTO bhg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Edo embo neneimi sitera, “Embo eiwa dá awara.” Ata neneimi sitera, “Embo awa da kariwa awa ainda ango.” Edo embo ami akuta tedo esisina, “Na embo awara!” ");
INSERT INTO bhg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Awatedo awamanemi embo ainde sitera, “Nongo nongo edo ito jisi pirigesiri?” ");
INSERT INTO bhg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Edo embo ami mina sisina, “Embo, ainda dao Iesu tedo era, ami butu tatapu edo kundo nato jisida datedo namonde sisina, ‘Mambuyo Siloam Un Tarari ainda, edo teieyo.’ Ango tesiri na maundo teietena, edo na iji tuturoda yai gena.” ");
INSERT INTO bhg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Edo awamanemi embo ainde sitera, “Embo awawa indari?” Edo embo ami sisina, “Na gae.” ");
INSERT INTO bhg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Edo awamanemi embo ave gisi jisiguba ari isira awa Parasi maneda yai kundo guputera. ");
INSERT INTO bhg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Edo Oena Apari Degutade awa iji ainde Iesu butu tatapu edo emboda jisi pirigesisina. ");
INSERT INTO bhg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Edo tekago Parasi mane daedo embo ainde tedogido esitera, “Nongo nongo edo imo iji tuturoda yai gesi?” Edo ami awamanede sisina, “Embo awa butu tatapu nato jisida piesiri, na teiedo yai gotena.” ");
INSERT INTO bhg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ango edo Parasi mane neneimi tedo esitera, “Embo eiwa Oena Apari Degutadeda aodari awa kera ae edo eira, awatedo emi God da yai edo gumbae.” Edo neneimi tedo esitera, “Edo embo awa jimbo bebegae ari embo gido, nongo edo ami kariwa angogo ari tao edo eiri?” Ango tedo awamane avigekavige esitera. ");
INSERT INTO bhg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Edo awamanemi tenda embo jisiguba ari ainde ge sitera, “Embo ami ito jisi pirigesira, awatedo inemi ge ro ainda daoda tesi?” Edo embo ami sisina, “Embo awa peroveta.” ");
INSERT INTO bhg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Awarata Jew embobo awa gebé ae embo awa ainda aida urida edo jisiguba ari engisina edo iji tuturoda yai gira. Awatedo awamanemi embo iji tuturoda yai gira ainda aimamoda yai gumborote ge pietero mambiri awamane guputera. ");
INSERT INTO bhg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Edo awamanemi ainda aimamode tedogositera, “Mai eiwa itomane ta? Inemane mai eiwa awa jisiguba ari aida urida engari tevita? Edo boroko nongo nongo edo emi yai goteiri?” ");
INSERT INTO bhg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Edo ainda aimamomi awamanede mina sitera, “Nakare gari, embo eiwa natokare mai edo imo awa jisiguba ari aida urida engari. ");
INSERT INTO bhg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ata nongo edo boroko yai goteiri awa nakare gae, ko embo ainmi ainda jisi pirigesiri awa nakare gae. Ainda duberi awa inono; embo ainde tedogiwo. Embo ami ainda daoda ge taina.” ");
INSERT INTO bhg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ainda aimamomi Jew embobo adu edo esitera, awatedo ge ango sitera. Jew embobo matu awara esitera awa, embo da ainmi Iesu awa Keriso karigari gido awa, awamanemi imo benunu oroda kundo arapada piaro idegarate. ");
INSERT INTO bhg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Awatedo ainda aimamomi sitera, “Ainda duberi awa inono; embo ainde tedogiwo.” ");
INSERT INTO bhg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Edo awamanemi tenda embo jisiguba arida yai gumbarate ge pietero mambiri embo awa gupusina. Edo awamanemi embo ainde sitera, “God da yai taogari pieyoǃ Nakare gari, embo eiwa jimbo beyae ari embo.” ");
INSERT INTO bhg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Edo embo ami mina sisina, “Embo eiwa jimbo beyae ari embo ta awa na gae. Rorae da (1) na gari awa, na awa jisi guba ari ata boroko na yai gotena!” ");
INSERT INTO bhg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ango edo awamanemi embo ainde tekago sitera, “Embo ami imonde ro esiri? Ami nongo edo ito jisi pirigesiri?” ");
INSERT INTO bhg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Edo embo ami awamanede mina sisina, “Na imondemane matu tetena, edo imomane ingae. Ro awatedo tenda ingain jipapa evi? Imomane daedo ainda ambodani ain jipapa evita?” ");
INSERT INTO bhg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ango edo awamanemi ainda daoda ge bebegae tedo sitera, “Imo awa ainda ambodani, ata nakare awa Moses da ambodani. ");
INSERT INTO bhg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nakare gari, God mi Moses de ge sisina. Ata embo eiwa, yai nonda edo gupusini awa nakare gae.” ");
INSERT INTO bhg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Edo embo ami awamanede mina sisina, “Na korebé ena! Ine jisi nato pirigesira, awarata embo awa yai nonda edo gupusini awa imomane gae. ");
INSERT INTO bhg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kaena gari, God mi embo jimbo bebegaeda ge awa ingae edo eira. Ata embo da ainmi God tou eite, edo ainda jipapa edo eira awa, ainda ge awa ingido eira. ");
INSERT INTO bhg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ge jirari engo itae: embo jisiguba ari awa ainda aimi engesiri isiri embo da (1) gundo ami ainda jisi pirigesira. Kaena berarimi ge jirari dá engo, iji tuturobéda edo gundo gundo boroko iji einda isima edo era awa ingae. ");
INSERT INTO bhg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Edo embo eiwa God da yai edo gumbae gido awa, embo emi buro angogo ari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Edo awamanemi embo ainde mina sitera, “Ito engari awa jimbo beyaede berari edo imo nakare atopapotesita?” Edo awamanemi embo awa benunu oro doda awa kundo arapada pietero idegesisina. ");
INSERT INTO bhg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Edo Iesu mi ingisina awamanemi embo awa kundo pietero arapada idegesisina. Edo Iesu mi embo awa tamundo ainde sisina, “Ito gebé ari God da Mai da yai pipitesita?” ");
INSERT INTO bhg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Edo embo ami mina sisina, “Embo bajina, embo awa averi? Namonde teyo, ainda yai nato gebé ari piane.” ");
INSERT INTO bhg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Edo Iesu mi embo ainde sisina, “Imo embo awa gari; edo gebé, embo dá ami imonde daedo ge sira.” ");
INSERT INTO bhg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Edo embo ami sisina, “Badari, na gebé ena,” edo ine Iesu tumondebain esisina. ");
INSERT INTO bhg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Edo Iesu mi sisina, “Nane embomai katanate butu einda guputena. Ango ano embo ainkainmi yai gae edo era awa yai gara, edo embo ainkainmi yai gido era awa jisiguba ara.” ");
INSERT INTO bhg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Edo Parasi mane nenei embo ainde daedo isite ge eiwa ingido ainde sitera, “Nakare amo daedo jisiguba ari ta?” ");
INSERT INTO bhg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Edo Iesu mi awamanede sisina, “Imomane jisiguba ari gido, imomane awa jimbo beyae itae. Ata boroko imomane ge tewa, ‘Nakare yai gotera.’ Awatedo itomane jimbo beyae awa matawa isira.” ");
INSERT INTO bhg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Edo Iesu mi embomaide ge matawa tedo sisina, “Eiwa awa gebé bajina imondemane tena. Embo ainmi wo sipumaneda gangaru ari manguro beda torae, ata ainyedo begata neida torido eira awa beono embo edo jivere embo. ");
INSERT INTO bhg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ata embo ainmi manguro beda torido eira awa sipumane sima ari embo. ");
INSERT INTO bhg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Edo manguro simagari embomi ainda yai manguro pirigedo eira, edo sipumanemi ainda bepu ingido era. Edo embo ami sipumane ainda topo awamaneda dao da da gumborote tedo gisijido kundo arapada idegedo eira. ");
INSERT INTO bhg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Edo amboda sipumane ainda topo awa kundo idegedo eira, imo awamane kopuru edo maundo eira. Edo sipumane ainda bepu awa gari, awatedo awamanemi imo ambo ambo edo era. ");
INSERT INTO bhg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Awarata, awamane embo eve awa mana ambo ambo ara. Aindabé awamane embo eveda bepu awa gae, awamane embo awa dodo adu tumundo eve mambara.” ");
INSERT INTO bhg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu mi ge kariwa eiwa sisina, ata ge ro awamanede tedo esisina ainda moka awa awamanemi gae. ");
INSERT INTO bhg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Awatedo Iesu mi awamanede tekago sisina, “Eiwa awa gebé bajina imondemane tena. Na awa sipumaneda manguro be. ");
INSERT INTO bhg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Berari ainkainmi na gumbae gisida guputera awa beono embobo de jivere embobo de, ata sipumanemi awamaneda ge ingae. ");
INSERT INTO bhg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na awa manguro be. Embo da ainmi nato manguro beda toraina awa, God mi embo awa toregaina. Edo imo awa torido idegedo aina, edo itari yai dave tamaina. ");
INSERT INTO bhg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Beono emboda jipapa dabé ami kundo gundo eira awa beono ari, dari betari, edo kundo usibesi ari. Na guputena awa awamane wasiri borote, edo wasiri davebé dave daginegara. ");
INSERT INTO bhg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Na awa sipumane sima ari embo dave. Sipumane sima ari embo davemi ainda wasiri sipumane awaembo pipiteira. ");
INSERT INTO bhg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ata ganu piari bain buro ari embo awa sipumane sima ari embobé ae, edo imo awa sipumane tutu ae. Awatedo iji nonde embo ami abu sino gumburi gido, imo sipumane dodo adu tumundo eira. Edo abu sino ami gundo sipumane taimbedo buri sipumane nenei evekara edo era. ");
INSERT INTO bhg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Aindabé embo awa tepo ganu piari bain buro ari embo edo sipumane dubobae, imo adu edo yai eve tumundo maundo eira. ");
INSERT INTO bhg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Na awa sipumane sima ari embo dave. Edo na sipumane nato gido ena, edo sipumane natomi na gido era. ");
INSERT INTO bhg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Edo dá ango Mamo natomi na gido eira, daedo na Mamo nato awa gido ena. Edo nato sipumane awaembo wasiri nato pipitena. ");
INSERT INTO bhg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nato sipumane nenei itera, edo awamane gangaru einda doda itae. Awamane awa daedo kundo gumanate sisina. Edo awamanemi bepu nato ingara, edo awamane jisi da (1) ara ae sipumane sima ari embo da (1)de. ");
INSERT INTO bhg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Aindabé nane wasiri nato pipitena awa, nato wasiri tekago banate tedo, Mamo natomi na dubobudo eira. ");
INSERT INTO bhg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Embo da ainmi nato wasiri nato yaida awa kumbari tao ae, ata nanemi akuta wasiri nato pipitena. Na awara tari natomi wasiri nato piain ena, edo awara tari natomi wasiri nato tekago bain ena. Ge okain eiwa Mamo natomi namonde piesiri buritena.” ");
INSERT INTO bhg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Edo Iesu mi ge engogo tesiri ingitera, awatedo Jew embomai tenda avigekavige esitera. ");
INSERT INTO bhg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Edo awamane jiwaemi tedo esitera, “Embo awa bineimi gisijido eira, edo ainda jiro awa beyae. Ro awatedo ainda ge ingevi?” ");
INSERT INTO bhg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Neneimi tedo esitera, “Embo bineimi gisijido eira ami ge engogo awa tari tao ae. Bineimi embo jisiguba ari ainda jisi pirigari tao rita? Ango ainyae.” ");
INSERT INTO bhg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Edo iji ainde Jerusalem ainda Kotopu Ari Bondo da iji awa gupusina, edo awa dademo yoade. ");
INSERT INTO bhg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Edo Iesu awa oro kotopu bajinada yai arapada dao Solomon da Boriri dugada ainto edo esisina. ");
INSERT INTO bhg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Edo Jew embobo mi imo jinenembedo tedo esitera, “Onjigari ge matawa namondekare tedo eta awa doyo. Imo awa Keriso gido, ge te arapa ari nakare gore.” ");
INSERT INTO bhg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iesu mi awamanede mina sisina, “Na imondemane ge teiana, edo imomane gebé ae. Buro berari Mamo natoda daoda edo ena, ami na averi awa karigedo eira. ");
INSERT INTO bhg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ata dá imondemane ango siutana, imomane awa nato sipumane ae, awatedo imomane gebé ae. ");
INSERT INTO bhg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nato sipumane awa bepu nato ingido era, nane awamane averi gido ena, edo awamane na ambo ambo edo era. ");
INSERT INTO bhg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Edo nanemi awamanede wasiri natopo itari pipitena, edo awamane mana betara; edo embo da ainmi awamane ipa natoda awa mana taimbedo kumaina. ");
INSERT INTO bhg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mamo nato ainmi awamane namonde pipisisina, ainda goroba awa goroba berari daginegari; edo embo da ji ainmi awamane Mamo natoda ipada awa taimbedo kumbari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na ae Mamo de, nakare tote (2) awa da (1).” ");
INSERT INTO bhg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Edo Jew embobomi tenda ganuma kundo embo awa daro betarate esitera. ");
INSERT INTO bhg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ango edo Iesu mi awamanede sisina, “Buro dave jiwae awa Mamo natoda yai edo eteno gotawa. Buro indawa nane eutana ami imomane na ganumami dawo betanate jipapa evi?” ");
INSERT INTO bhg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Edo Jew embobomi ainde mina sitera, “Aindabé imo buro dave eiata daro betatate jipapa ae, ata ine ge bebegae God da daoda tedo eta, edo imo, embo enembo, awa God tedo eta.” ");
INSERT INTO bhg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Edo Iesu mi awamanede mina sisina, “Itomane Aodari da gaiari doda God da ge engo isira, ‘Nane tetena, “Imomane awa god mane.” ’ ");
INSERT INTO bhg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Iji gisi, ouwamane ainmi God da ge buritera awa, ine awamanede dao ‘god mane’ sisina. Edo God da Ove Gaiarida ge teugari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aindabé Mamo mi na ainda topobé ango tatajido butuda piesiri guputena, edo nanemi tetena, ‘Na awa God da Mai,’ ro awaembo inemanemi, ‘Ine ge bebegae God da daoda tedo eta,’ tevi? ");
INSERT INTO bhg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Edo nato Mamo da buro ae edo ena, na gebé eove. ");
INSERT INTO bhg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Awarata, edo na Mamo da buro edo ena, ata imomane nato ge gebé ae, awara, nato buro gebé ewo. Ango edo imomane gari edo gebé ari bave, Mamo namonde daedo isira, edo na Mamo de daedo itena.” ");
INSERT INTO bhg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Awatedo awamanemi tekago embo awa kumain jipapa edo esitera, ata imo awamaneda ipada dodo idegesisina. ");
INSERT INTO bhg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ango edo Iesu tekago un Jodani kupo neida temundo maunsisina. Edo yai nonda John iji gisi isite embomai tuturoda bapataito edo esisina ainda, Iesu maundo isima edo esisina. ");
INSERT INTO bhg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Edo embomai jiwae ainda yai gundo tedo esitera, “John mi kariwa da (1) ro ae, ata ge berari John mi embo einda daoda sisina awa gebé.” ");
INSERT INTO bhg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Edo yai ainda embomai jiwae awamaneda gebé ari Iesu da yai pipisitera. ");
INSERT INTO bhg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Iji angode embo da (1), ainda dao Lazarus, karu eite esisina. Edo embo awa nasi Betani embo. Edo nasi Betani dá ainda Mary ae ainda dao Martha de isima edo esitera. ");
INSERT INTO bhg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mary emi gama muno davedemi Badari da taida dasisina, edo ainda kopuru tumi ainda tai gaigesisina. Edo Mary dá eiwa, ainda ru Lazarus karu esisina.) ");
INSERT INTO bhg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Awatedo ru aimonomi Iesu garate ge pietero maunsisina engo, “Badari, giyoǃ Ito otawobé karu eira.” ");
INSERT INTO bhg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Edo Iesu ge awa ingido sisina, “Karu einda beao awa betari ae, ata God da taogari awaembo, edo God da Mai da taogari embomaida yai arapa ari gorote.” ");
INSERT INTO bhg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","(Iesu Martha ae ainda dao de Lazarus de dubobudo esisina.) ");
INSERT INTO bhg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Edo iji ainde Lazarus da karu ari ge ingisina, Iesu yai dá ainda imo isite awa deguta tote (2) nei sima esisina. ");
INSERT INTO bhg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Edo ainda amboda embo ami ambodanide sisina, “Kaende tekago yai Judea aimbore.” ");
INSERT INTO bhg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Edo ambodani mi ainde sitera, “Atopatari, iji ribori aebé Jew embobo mi imo ganumami daro betatate jipapa eiara, edo imo tekago yai ounda aimain esita?” ");
INSERT INTO bhg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu mi mina sisina, “Deguta da da ora 12 ainda parara isima edo eira. Embo da ainmi ijide ainto aina, aindabé ijida parara gido eira, ainda tai koingae edo eira. ");
INSERT INTO bhg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ata embo da ainmi muyaede ainto aina, aindabé parara ainda yai itae, ainda tai koingedo eira.” ");
INSERT INTO bhg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Edo ge eiwa tedo ainda amboda ami awamanede sisina, “Kaenato otawo Lazarus jitao aveite isira, ata na mauntena embo awa audano erarate.” ");
INSERT INTO bhg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Edo ainda ambodanimi sitera, “Badari, embo awa jitao aveite isira gido, awa kaviegaina.” ");
INSERT INTO bhg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Awarata, Iesu da geda moka awa Lazarus besitara. Ata ainda ambodanimi imo tepo jitao awarida ge sira awa kotembesitera. ");
INSERT INTO bhg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ango edo Iesu mi awamanede arapada sisina, “Lazarus besitara. ");
INSERT INTO bhg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ata aindabé itomane gebé ari nato yai badaina, awaembo dubodave ena yai ainda na itae. Awarata kaende ainda yai boroko aimbore.” ");
INSERT INTO bhg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Edo Thomas (Ainda dao nei awa Didymus.), ami Iesu da ambodani neneide sisina, “Kaende daedo maundo embo ainde daedo betore.” ");
INSERT INTO bhg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Edo Iesu gumbiri embomaimi tetero gosisina awa Lazarus goiari yai ude banga toda pietero deguta ipa ao pasido (4) matu sima eutara. ");
INSERT INTO bhg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani nasida edo aundo Jerusalem awa ribori tega kilometre tamonde (3) ango. ");
INSERT INTO bhg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jew embomai jiwae gundo, edo eutumai ainkain Martha ae Mary de matu jinenembetero awa, awamanede daedo doregesitera. Aindabé awamaneda ru betesira, eutu tote (2) dubo vevera esitera. Edo embomaimi awamaneda dubo vevera gido kondade ain guputera. ");
INSERT INTO bhg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Edo iji ainde Martha mi Iesu gupeira da ge awa ingido, imo idegedo embo awa tapusina, ata Mary mando doda anumbedo isite sima esisina. ");
INSERT INTO bhg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ango edo Martha mi Iesu de sisina, “Badari, imo einda itae eteta gido, nato ru awa betainyae. ");
INSERT INTO bhg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ata, boroko na daedo gari awa, imo ro God da yai benunu tata awa God mi ito yai piaina.” ");
INSERT INTO bhg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu mi eutu ainde sisina, “Ito ru awa tekago wasiri budo eraina.” ");
INSERT INTO bhg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha mi embo ainde sisina, “Na gari, embo awa tekago wasiri budo eraina, erari deguta beao arida.” ");
INSERT INTO bhg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu mi eutu ainde sisina, “Na awa erari edo wasiri. Embo ainmi ainda gebé ari nato yai pisido eira, edo imo amboda betaina gido awa, imo tekago wasiri baina. ");
INSERT INTO bhg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Edo berari ainmi nato yaida isite edo ainda gebé ari nato yaida pipisite awa, mana betaina. Imo ge eiwa gebé esita?” ");
INSERT INTO bhg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Eutu ami ainde sisina, “Gebé, Badari, na gebé esitena imo awa Keriso, God da Mai, butuda piari gumbata awa tarigarida sisina.” ");
INSERT INTO bhg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Edo eutu awa ge eiwa tedo amboda aundo ainda dao Mary dao tesiri gumbiri kundo iunte demonda edo eutu ainde sisina, “Atopatari gumbira isira, edo imo dao sira.” ");
INSERT INTO bhg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Edo iji ainde Mary ge awa ingido, imo burigibé erido ainda yai tuturo edo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Edo Iesu awa nasida torae, ata matawa yai Martha mi imo tapusina ainda isiri jijirisina. ");
INSERT INTO bhg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ango edo dubo vevera iji ainde Jew embomai Mary de daedo mando doda isite eutu awa kondade eite itera, ami eutu awa boraebé erido idegesiri gositera. Edo awamanemi sitera, “Eutu ami goiari yai ude banga toda ji tain aunteira.” Awatedo awamane eutu awa ambo ambo esitera. ");
INSERT INTO bhg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Edo iji angode Mary gundo yai ainda Iesu isiri embo awa gido, ainda taida durudo embo ainde sisina, “Badari, imo einda itae eteta gido, nato ru awa betainyae.” ");
INSERT INTO bhg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Awatedo iji ainde Iesu mi eutu awa ji siri gosisina, edo Jew embomai eutu ainde daedo guputera ami ji tero gido, imo do memesi bajinabé biri do buriya esisina. ");
INSERT INTO bhg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Edo ami sisina, “Embo awa yai nonda pipitavi?” Awamanemi embo ainde sitera, “Badari, gumbu gate.” ");
INSERT INTO bhg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Edo Iesu ji sisina. ");
INSERT INTO bhg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ango edo Jew embomaimi mina tara esitera, “Giwo, embo ami embo awa dubo bajinabé budo esira!” ");
INSERT INTO bhg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ata awamane neneimi sitera, “Embo emi embo jisiguba arida jisi pirigatara. Ro awaembo imo Lazarus kondade ari piae dosiri betesiri?” ");
INSERT INTO bhg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Edo Iesu tekago do memesi bajinabé bureite goiari yai udeda gupusina. (Awa banga to, edo ganuma bajinami ainda be awa engiregesisina.) ");
INSERT INTO bhg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu mi sisina, “Ganuma awa mitewo demonda iyareǃ” Martha, embo betarida ru, ami Iesu de sisina, “Badari, embo besitara edo gundo boroko emi deguta ipa ao pasido (4) eira, awatedo embo ainda tamo mata beyaebé eira.” ");
INSERT INTO bhg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Edo Iesu mi eutu ainde sisina, “Na imonde matu tetena, edo imo gebé ata, imo God da taogari gata. Ge awa ruvegetesita?” ");
INSERT INTO bhg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ango edo embo betari pietero isiri ainda yaida edo awamanemi ganuma awa mitedo demonda pipisitera. Edo Iesu pangedo jisi utuda edo sisina, “Mamo, na ingeta, awaembo imo ategetena. ");
INSERT INTO bhg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Edo na gari imo iji berari na ingido eta. Ata embomai einda jinenembedo petari itera awaembo ge eiwa tetena, awamanemi ine na pieteto guputena gebé orote.” ");
INSERT INTO bhg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Edo ge eiwa tedo itae edo amboda, ami aorogatedo ikanade sisina, “O Lazarus, idegeǃ” ");
INSERT INTO bhg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Edo embo betari awa idegesisina, ainda ipatai awa goiari gongomi bundari, edo ainda dombu awa gongo gisimi doiari. Edo Iesu mi awamanede sisina, “Embo awa udegedo dowo mambare.” ");
INSERT INTO bhg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Awatedo Mary da dubo vevera iji ainde, Jew embomai jiwae eutu awa kondade ain guputera. Edo awamanemi Iesu mi buro ro edo esira awa gido awamaneda gebé ari ainda yai pipisitera. ");
INSERT INTO bhg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ata awamaneda embo neneimi Parasi maneda yai aundo buro ro Iesu mi edo esira awamanede sitera. ");
INSERT INTO bhg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ango edo pirisi babain ae Parasi mane demi Sanhedrin da embobo dao tetero gundo doregetero awamanede tedo esitera, “Embo emi kariwa jiwae edo eira. Awatedo kaende nongo ani? ");
INSERT INTO bhg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Edo kaen dowano, embo eiwa buro engo matawa aina gido awa, embo berarimi awamane gebé ari ainda yai piara, edo Rome da embobomi gundo kaenato yai ae kaenato embomai de usibesi ara.” ");
INSERT INTO bhg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Edo awamaneda embo da (1), dao Caiaphas, awa pirisi maneda gisijiari bajina duberi ainde. Ami awamanede ge sisina, “Ge ro tevi awa imomane gae. ");
INSERT INTO bhg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Na kotembetena awa, imomane awa gari bae nongo edo kaena kondade ari tao avi. Kaenato dave awa embo da (1) daro betaina embomai awaembo, gae gae edo kaenato embomai berari betara.” ");
INSERT INTO bhg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Edo embo ami imo akuta ge eiwa kotembedo tae, ata embo awa pirisi maneda gisijiari bajina duberi ainde. Awatedo embo ami ge perovetada ango sisina, Iesu awa Jew embomai berari awaembo betaina. ");
INSERT INTO bhg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Edo Jew embomai akuta awaembo betainyae, ata embo awa daedo God da mamai yai berarida evekara esitera awaembo betaina, kundo gundo dada edo doregari da (1) arate sisina. ");
INSERT INTO bhg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ango edo deguta ainde awamanemi tuturo edo embo awa nongo edo daro betaini awa ge jijiritera. ");
INSERT INTO bhg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Awatedo Iesu arapada Jew embomaida jisida pepeta ae. Ata imo yai awa dodo nasi bajina dao Ephraim ainda aundo yai abu damodamoda demonda, ainda ambodani de daedo sima esisina. ");
INSERT INTO bhg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ango edo Jew embomaida Darutegari Bondo awa atutumbesisina. Edo Darutegari Bondoda gumbae gisida, embo jiwae awamaneda yai dodo Jerusalem vivisitera, awamane akutada dono teiarida sirigari awaembo. ");
INSERT INTO bhg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Edo awamanemi Iesu kakowa edo esitera. Edo awamane oro kotopu bajina ainda petedo isite akuta tedo mina gara edo esitera, “Imomane ro kotembetevi? Embo awa doregari einda gumainyae ta?” ");
INSERT INTO bhg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Edo pirisi babain ae Parasi mane demi ge okain sitera, “Imomane da ainmi Iesu yai nonda isiari tambata, teyo gido nakare maundo embo awa kumbore.” ");
INSERT INTO bhg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Edo deguta 6 Darutegari Bondo gisida, Iesu Betani nasida gupusina. Yai ainda Lazarus isinesina. Embo awa gisi betari ata Iesu mi betarida jiri erorisina. ");
INSERT INTO bhg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Edo yai ainda awamane turo indari Iesu awaembo siya esitera. Edo Martha indari jipusina, ata Lazarus ae embo neneide daedo Iesu de tenembada anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Edo Iji ainde Mary gama muno daveda sigi tega litre kupo da (1) ango kundo gupusina. Gama berari awawa nya dao ‘nard’ akutami siya ari edo awa mina bajinabé piedo bari rorae. Edo Mary gama ami Iesu da taida dasisina, edo ainda kopuru tumi Iesu da tai gaigesisina. Edo embomai berari mando doda isite ainda muno dave awa miputera. ");
INSERT INTO bhg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ata ainda ambodani da (1), Simon da mai Judas Iscariot (Amboda embo awa Iesu budo ainda gitopo emboboda ipada piaina.) ami sisina, ");
INSERT INTO bhg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ro awaembo gama muno dave eiwa embo neide piedo ganu 300 budo awa embomai rorae isisigaede piae dosiri?” ");
INSERT INTO bhg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Edo embo ami ge eiwa tesira, aindabé embomai rorae isisigae awa sima ain jipapa ae, ata aindabé embo awa beono embo. Embo awa ganu mauwada sima ari embo, edo ganu ro embomaimi pioro imo kundo beono evina. ");
INSERT INTO bhg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ata Iesu mi sisina, “Eutu awa do. Eutu ami nato goiari deguta awaembo muno rorae eiwa budo sima edo esira. ");
INSERT INTO bhg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Imomane iji matawa embomai rorae isisigae de daedo isima edo ewa, ata imomane iji matawa namonde daedo itari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Edo iji ainde Jew embomai jisi bajinami Iesu yai ainda isira ge awa ingido guputera. Awamanemi imo akuta gain gumbae, ata daedo Lazarus awa ami betarida jiri erorara awa gain. ");
INSERT INTO bhg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ata Jew embomai jiwaemi embo awa gido pirisi babain dodo maundo awamaneda gebé ari Iesu da yai pisido esitera, awatedo pirisi babainmi daedo Lazarus daro betarate ge jijiritera. ");
INSERT INTO bhg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Edo aveunte embo jisi bajina matu bondoda guputera, ami Iesu awa Jerusalem gupeira awa ingitera. ");
INSERT INTO bhg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Edo awamanemi mutari igi angogo budo idegedo embo awa tamain aunteite tenda tenda aorogatedo sitera, “Hosanna! ‘God da ao ari embo einda yai itare! Embo eiwa Badari da daoda gupeira!’ Israel embomaida Daotariǃ” ");
INSERT INTO bhg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Edo Iesu wo donki vete tamundo ainda gunda anumbesisina, dá Ove da Gaiarida isira engo, ");
INSERT INTO bhg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Adu eove, nasi Zion da gagara, Giwo, itomane Daotari awa wo donkida mai gunda anumbedo gupeira.” ");
INSERT INTO bhg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Edo iji gisi ainda ambodani God da ge eiwa kotembae arapa ae. Ata ainda amboda God mi Iesu utuda jiri visido ainda taogari burisina. Edo iji ainde, awamanemi Ove Gaiarida ge imo embo engo tari isira awa kotembesitera, edo awamanemi buro dá engo imo embo esitera. ");
INSERT INTO bhg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Edo iji ainde Iesu mi Lazarus dao tesiri ainda ude dodo betarida erorisina, embomai jisi da (1) Iesu de daedo itero ainda buro gositera. Edo awamanemi embomai neneida yai ge awa karigedo esitera. ");
INSERT INTO bhg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Edo embomaimi ingido awa, embo ami kariwa eiwa esisina, awatedo awamane daedo maundo embo awa taputera. ");
INSERT INTO bhg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ango edo Parasi manemi ge mina tara esitera, “Kaena embo awa engiregari tao ae. Giwo, embomai butu berarida ami imo ambo ambo eteraǃ” ");
INSERT INTO bhg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Edo iji ainde embomai tumondebain ain bondoda gupero Guriki embo nenei awamaneda toropuda daedo guputera. ");
INSERT INTO bhg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ango edo awamane Philip da yai guputera. (Embo awa yai Galili da, Besaida nasi embo.) Edo awamanemi ainde tedogosite sitera, “Embo bajina, nakare Iesu gain jipapa era.” ");
INSERT INTO bhg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Edo Philip gundo Andrew de awamaneda jipapa awa sisina. Edo Philip ae Andrew demi ge dá awa Iesu de sitera. ");
INSERT INTO bhg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ata Iesu mi awamanede mina sisina, “Ora awa gumbira awa God mi Embo da Mai da taogari awa arapa aina. ");
INSERT INTO bhg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Eiwa awa gebé bajina imondemane tena. Edo wheat vero da (1) butuda durudo betae aina awa, vero da (1) akuta itaina. Ata betaina gido awa, tenda erido vero jiwae ekaina. ");
INSERT INTO bhg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Embo ainmi ainda wasiri jiain jipapa aina gido awa dadoegaina, edo ainmi ainda wasiri butu einda jiain jipapa ae gido awa wasiri natopo itari baina. ");
INSERT INTO bhg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Embo ainmi na awaembo buro aina, embo awa na ambo ambo arate tena. Edo yai nonda na itena awa, nato buro embo daedo itaina. Embo da ainmi na awaembo buro aina awa, embo awa Mamo natomi tou aina. ");
INSERT INTO bhg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Boroko nato do buriya eira, edo nongo tani? Mamo na torege ora einde ta? Ango ae. Na eiwa embo ora einda guputena. ");
INSERT INTO bhg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mamo ito dao taogiyo!” Edo ge yavi utuda edo gupusina, “Na matu taogena, edo tekago taogana.” ");
INSERT INTO bhg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Awatedo embo jisi da (1) ainda petedo isite ge yavi awa ingitera. Edo awamanemi mina tara edo esitera, “Dudu jipeira.” Edo neneimi tedo esitera, “Anelami embo ainde ge sira.” ");
INSERT INTO bhg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Edo Iesu mi mina sisina, “Ge yavi eiwa na awaembo gumbae, ata imomane embo. ");
INSERT INTO bhg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Boroko awa embomai butu einda katari iji. Boroko butu einda gisijiari awa ondari idegaina. ");
INSERT INTO bhg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Edo iji ainde na awa awamanemi butuda edo jiaro vitana, nane embomai butu dededa do dumano nato yaida gumbara.” ");
INSERT INTO bhg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ge eiwa sisina ami imo betari ango betaina awa karigesisina. ");
INSERT INTO bhg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Edo embo jisi da (1)mi ainde mina sitera, “Nakare Aodarida edo ingitera, Keriso awa natopo itaina. Nongo nongoda edo Embo da Mai awa jiaro vitarate tesi? Embo da Mai eiwa averi?” ");
INSERT INTO bhg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Edo Iesu mi awamanede sisina, “Iji riboribé ae parara itomane yai itaina. Iji ainde parara itomane yai isiari pepeta ewo, muyae imomane apuregeurekae. Embo ain muyaeda pepeta edo eira awa, yai nonda aunteiri awa imo gae. ");
INSERT INTO bhg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dá parara itomane yaida isira angode awa, itomane gebé ari pararada yai piewo, imomane pararada mamai ave.” Ge eiwa Iesu mi tedo awa dodo awamanemi giworekae yai eve aundo onjigesisina. ");
INSERT INTO bhg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Edo Iesu mi kariwa jiwae awamaneda dombuda esisina, awarata awamaneda gebé ari ainda yai piae. ");
INSERT INTO bhg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ango edo ge eiwa peroveta Isaiah mi amboda gumaina sisina, awa gundo bé esira: “Badari, embo ainmi bino kaenato eiwa gebé esiri? Edo embo anda yaida Badari mi ainda goroba ari arapa esiri?” ");
INSERT INTO bhg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Awatedo awamanemi Iesu da ge ingido gebé ari tao ae, aindabé God mi Isaiah da toda ge nei daedo sisina: ");
INSERT INTO bhg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nanemi awamaneda jisi awa eteno akeimbesisina, edo awamaneda do eteno okain esisina. Awatedo awamaneda jisimi nato buro awa gae arapa ae esitera, edo awamaneda do pirigedo geda mokabé arapa gae esitera. Na ango esitena awa, awamaneda jimbo dodo nato yai wareregaro nanemi awamane gao ano kaviegeorekae.” ");
INSERT INTO bhg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah ge eiwa sisina iji ainde Iesu da taogari gosisina, edo ainda daoda ge sisina. ");
INSERT INTO bhg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Awarata, iji ainde Jew embomaida babadegari jiwae awamaneda gebé ari ainda yai pipisitera. Ata Parasi manemi embo ainkain awamaneda gebé ari Iesu da yai piara gido, awamane benunu oroda torari awa engiregara tedo esitera. Ango edo embo jiwae adu edo awamaneda gebé ari arapada karigae doturitera. ");
INSERT INTO bhg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Awamanemi dasiga ari embomaimi awamaneda yai piorote awa jipapa esitera, ata God da dasiga ari borote jipapa ae. ");
INSERT INTO bhg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Edo Iesu aorogatedo sisina, “Embo ainmi ainda gebé ari nato yai pipiteira awa, embo awa nato yai akuta ainda gebé ari piae, ata ainda gebé ari embo ainmi na piesiri guputena ainda yai pipiteira. ");
INSERT INTO bhg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Edo embo ainmi ainda jisimi na goteira awa, embo na piesiri guputena awa goteira. ");
INSERT INTO bhg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na parara ango embomai butu dededa yai guputena awa, berari ainmi gebé ari nato yai pipiteira awa muyaeda itainyae. ");
INSERT INTO bhg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Edo embo ainmi ge nato ingido gebé ae aina, nane embo awa katainyae. Na embomai butuda katain gumbae, ata embomai butuda toregain guputena. ");
INSERT INTO bhg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Embo da ainmi na ajiregeteite, edo ge nato awa bainyae, ainda katari embo isira. Ge nanemi tetena awa ainda katari embo, edo ami deguta beao arida embo awa kataina. ");
INSERT INTO bhg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Edo ge nane tetena awa ge nato akuta ae, ata Mamo na piesiri guputena, ami ge ro tani edo nongo nongo tani awa ge okain namonde sisina. ");
INSERT INTO bhg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Edo na gari, ge ro awa ami ge okain namonde sisina awa, embomaida yai wasiri natopo itari piedo eira. Awatedo ge ro awa nanemi tedo ena awa, dá ango Mamo mi namonde sisina awa tedo ena.” ");
INSERT INTO bhg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Edo Darutegari Bondo gumbae gisida, Iesu gari ainda ora awa gumbira, imo butu eiwa dodo Mamo da yai mamain esisina. Edo imo ainda ambodani butuda dubobudo esira, edo iji dá ainde ainda dubobari tega itaebé awa esiri awamaneda yai arapa esisina. ");
INSERT INTO bhg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Edo Iesu ae ainda ambodani de turo indari injido itae esitera. Edo iji angode Binei mi Simon da mai, Judas Iscariot, ainda kotembarida matu pipisisina awa, Iesu kundo ainda gitopo emboboda ipada piarate. ");
INSERT INTO bhg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ango edo Iesu gari, Mamo mi awara tari berari ainda ipada pipisisina, edo imo God da yai edo gupusina, edo tekago God da yai mamaina. ");
INSERT INTO bhg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Awatedo imo turo indari dodo erido ainda ombari ribori teugedo demonda pipisisina, edo tamo gaigari budo ainda ipuda bunjisina. ");
INSERT INTO bhg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ainda amboda, teo bokumbada un dodedo tuturo edo ambodanida tai teiedo, tamo gaigari ainda ipuda ami gaigedo esisina. ");
INSERT INTO bhg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Edo imo Simon Peter da yai gumbiri ami ainde sisina, “Badari, inemi nato tai teiain esita?” ");
INSERT INTO bhg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu mi embo ainde mina sisina, “Nane buro boroko ro ena imo gae, ata amboda imo gata.” ");
INSERT INTO bhg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter mi ainde sisina, “Ine nato tai mana bé mana teiata!” Iesu mi embo ainde mina sisina, “Na imo teiae gido, namonde daedo itari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Edo Simon Peter mi ainde sisina, “Badari, ango gido, nato tai akuta teiainyae, ata ipa de kopuru de daedoǃ” ");
INSERT INTO bhg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu mi ainde sisina, “Embo ave matu ungutari awa tenda ungutainyae; embo awa dono berari itae, ata ainda tai akuta awa teiaina. Edo imomane awa dono itae, awarata imomane berari awa dono itae ae.” ");
INSERT INTO bhg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Aindabé embo ainmi imo kundo gitopoda ipada piaina awa gari, ine sisina, “Imomane berari awa dono itae ae.” ");
INSERT INTO bhg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Edo amboda imo ambodanida tai teiedo, ainda ombari ribori omundo gundo tekago anumbedo awamanede sisina, “Ro nane itomane yai etena da moka gotevita? ");
INSERT INTO bhg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Inemane na dao Atopatari edo Badari tedo ewa. Na embo awa, awatedo awa ge dave. ");
INSERT INTO bhg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Edo na itomane Atopatari edo Badari ami tai itomane teietena, awatedo imomane daedo neida tai mina teiya awate. ");
INSERT INTO bhg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nane kariwa imondemane pietena. Awatedo ro itomane yai etena awa, inemane dá ango awa. ");
INSERT INTO bhg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Eiwa awa gebé bajina imondemane tena. Buro emboda dero awa ainda badarida dero daginegae. Edo embo buroda piesiri mambira awa embo ainmi imo buroda piesiri ainda ikane ae. ");
INSERT INTO bhg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Edo imomane atopatari eiwa gari, edo imomane ango edo awa gido, God mi ari imomane dubodave awa. ");
INSERT INTO bhg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Na ge tena awa itomane berarida ae. Na gari imomane avekave awa geritena. Ata eiwa idegesisina ami God da Ove Gaiarida ge awa bé aina, ‘Embo da (1) namonde teoda bread injido eira, ami nato gitopo esira.’ ");
INSERT INTO bhg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Nane ge eiwa boroko imondemane tena idegae gisida awa, iji nonde awa idegari gido na averi tetena awa inemane gebé awate. ");
INSERT INTO bhg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Eiwa awa gebé bajina imondemane tena. Imo ainmi da ave nanemi piono maundo eira awa budo eira gido awa, na budo eira. Edo imo ainmi na budo eira gido, embo ainmi na piesiri guputena awa budo eira.” ");
INSERT INTO bhg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesu ge eiwa sisina, edo ainda amboda ainda do buriya esiri karigesisina, “Eiwa awa gebé bajina imondemane tena. Itomane embo da (1)mi na gitopoda ipada piaina.” ");
INSERT INTO bhg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ango tesiri ambodani jisi mina gara esitera, edo imo ge ande siri awa gain daritera. ");
INSERT INTO bhg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Edo ainda ambodani Iesu mi dubobé budo eira awa Iesu da demobéda anumbari isira. ");
INSERT INTO bhg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Awatedo Simon Peter mi ambodani ainda yai iwata esisina, embo ande ge awa siri awa tedogarate. ");
INSERT INTO bhg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ango esiri gido ambodani awa aikae atutumbedo iunte Iesu da opopoda edo ami ainde tedogosisina, “Badari, embo amo averi?” ");
INSERT INTO bhg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu mi mina sisina, “Embo da (1) ande bread kupo saka teoda pasido piana.” Ango tedo, bread kupo saka teoda pasido Simon da mai, Judas Iscariot de, pipisisina. ");
INSERT INTO bhg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Edo iji ainde Iesu mi Judas de bread kupo saka piesiri bureiri, Satan ainda doda totorisina. Edo Iesu mi Judas de sisina, “Buro ro ain esi awa, burigi eyo.” ");
INSERT INTO bhg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ata nenei tenembada indari indeite itera, awamanemi ro embo Iesu mi embo ainde ge eiwa siri awa da ainmi gae. ");
INSERT INTO bhg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Aindabé Judas awa ganu sima ari embo, awatedo bondo rorae awamane jipapa era awa oriainita, o embomai rorae isisigaede rorae piarate, Iesu mi embo ainde tesirita kotembedo esitera. ");
INSERT INTO bhg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Edo Judas bread kupo saka awa budo boraebé idegesisina. Edo awa muyaede. ");
INSERT INTO bhg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Edo Judas idegedo mambiri amboda, Iesu mi sisina, “Boroko Embo da Mai da taogari awa arapa esira, edo God da taogari awa ainda yai arapa esira. ");
INSERT INTO bhg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ainda edo God da taogari Embo da Mai da yai arapa esira awa, God ami akuta daedo Mai da taogari awa arapa aina, edo burigibé Mai da taogari arapa aina. ");
INSERT INTO bhg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mamai nato, iji saka riborigo na imondemane itana. Edo na gain kakowa awa, edo nane Jew embomaide siutana ango, boroko imondemane tena, ‘Yai nonda na mauntena awa, imomane gumbari tao ae.’ ");
INSERT INTO bhg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ge okain teka nane imondemane pipitena: Dubo mina bara ewo. Dá nane imomane dubobudo etena ango, daedo imomane dubo mina bara awate. ");
INSERT INTO bhg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Edo gido imomane dubo mina bara awa, embomai berarimi imomane awa nato ambodani awa gara.” ");
INSERT INTO bhg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ango edo Simon Peter mi ainde sisina, “Badari, imo nonda mauntesi?” Iesu mi ainde mina sisina, “Yai nonda na mauntena ainda, boroko imo na ambo ambo ari tao ae, ata amboda imo na ambo ambo ata.” ");
INSERT INTO bhg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Edo Peter mi ainde sisina, “Badari, ro awaembo boroko na imo ambo ambo ari tao aeri? Na imo embo betana.” ");
INSERT INTO bhg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Edo Iesu mi embo ainde mina sisina, “Imo na embo betasita? Eiwa awa gebé bajina imonde tena. Kokora aoro tae gisida, imo akuta iji tamonde (3) toreite tata, imo na awa gae.” ");
INSERT INTO bhg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesu mi ainda ambodani de tedo sisina, “Do itomane buriya ainyae. Itomane gebé ari God da yai piedo ewa, daedo itomane gebé ari nato yai piewavi. ");
INSERT INTO bhg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mamo natoda mando doda awa itari yai jiwae itera. Edo awa gebé ae gido, na imondemane tae etena. Na imomane embo yai siya aintedo mauntena. ");
INSERT INTO bhg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Edo na maundo imomane embo yai siya ana gido, na tekago gundo imomane bana, yai nonda na itana ainda awa imomane daedo itawate. ");
INSERT INTO bhg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Edo na nonda maunteni imomane gari, edo ainda begata imomane gari.” ");
INSERT INTO bhg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas mi ainde sisina, “Badari, nakare imo nonda mauntesi awa gae, awatedo nongo edo begata awa gari tao ri?” ");
INSERT INTO bhg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu mi embo ainde sisina, “Na awa begata, na awa gebé, edo na awa wasiri. Embo da ainmi na daginegedo Mamo da yai gumbari tao ae. Begata nei itae. Ata da, na akuta. ");
INSERT INTO bhg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Edo imomane na matu gari gido awa, imomane daedo nato Mamo gari. Iji boroko einde edo amboda, imomane embo awa gido ewa, edo embo awa jisimi gari.” ");
INSERT INTO bhg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip mi ainde sisina, “Badari, nakare Mamo ewasi gore. Awa inono natokare yai.” ");
INSERT INTO bhg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ango tesiri Iesu mi ainde sisina, “Philip, na imondemane daedo iji riboribé isima edo ena, edo imo na gae arapa ae esita? Embo ainmi na gido esira, ami Mamo gido esira. Awatedo ro embo inemi tesi, ‘Nakare Mamo ewasi gore’? ");
INSERT INTO bhg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Na Mamo de daedo dada ari itena edo Mamo namonde daedo dada ari isira, imo gebé ae esita? Ge awa nane imondemane tedo ena awa nato awara tari akuta ami tae, ata Mamo namonde daedo dada ari isite ami buro edo eira. ");
INSERT INTO bhg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na gebé ewavi, na Mamo de daedo dada ari itena edo Mamo namonde daedo dada ari isira. Edo imomane nato ge awa gebé ae gido, buro berari nane edo etena awa udugedo gido na gebé ewavi. ");
INSERT INTO bhg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Eiwa awa gebé bajina imondemane tena. Embo ainmi ainda gebé ari nato yai pipiteite awa, buro neide kainde nane edo ena, ami daedo aina. Edo na Mamo natoda yai mauntena, awatedo buro eiwa nane edo etena awa, embo ami daginegaina. ");
INSERT INTO bhg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Edo rorae ro dao natoda tedogawa awa, nane awa ana, Mamo da taogari awa Mai mi ari embomaida yai arapa ari gorote. ");
INSERT INTO bhg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Edo rorae ro dao nato tedogawa awa, nanemi ana. ");
INSERT INTO bhg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Edo imomane na dubobureite gido, nato ge okain berari kera ewo. ");
INSERT INTO bhg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Edo nanemi Mamo de benunu tano, ami Kondade ari Embo nei imondemane piari imondemane daedo natopo itarate. ");
INSERT INTO bhg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Embo awa gebéda Asisi. Butu embomai mi embo awa jisimi gae edo embo awa averi gae, awatedo Asisi Kotopu awa bari tao ae. Ata embo ami imondemane daedo isima edo eira, edo itomane doda isima edo aina, awatedo imomane embo averi awa gido ewa. ");
INSERT INTO bhg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na imomane popoiwo ango dowainyae. Na itomane yai tekago gumana. ");
INSERT INTO bhg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","“Iji tupo itae edo butu embomaimi na tekago gae ara, ata inemanemi na gawa. Aindabé na wasiride itena, imomane daedo wasiride itawa. ");
INSERT INTO bhg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Edo deguta ainde imomane gawa, na Mamo nato de daedo itena, edo imomane namonde daedo itewa, edo na imondemane daedo itena. ");
INSERT INTO bhg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Embo ainmi ge okain nato budo kera edo eira, ami na dubobudo eira. Edo embo ainmi na dubobudo eira awa, Mamo natomi imo dubobudo aina. Edo na embo awa dubobana edo ainda yai na averi awa arapa ano gaina.” ");
INSERT INTO bhg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ango tesiri Judas mi (Imo awa Iscariot ae.) Iesu de sisina, “Badari, ro awa tedo imo embo averi awa natokare yai arapa ata, edo butu embomaida yai arapa ainyae ri?” ");
INSERT INTO bhg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu mi ainde mina sisina, “Embo da ainmi na dubobudo eira, ami nato ge awa kera aina. Edo Mamo natomi embo awa dubobaina, edo nakare ainda yai gundo embo ainde daedo itara. ");
INSERT INTO bhg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Embo ainmi na dubobae awa, nato ge kera ae edo eira. Edo ge awa imomane ingido ewa awa nato ae, ata Mamo ainmi na piesiri guputena, ainda ge. ");
INSERT INTO bhg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Iji ainde na imondemane daedo isite, rorae berari eiwa imondemane tedo etena. ");
INSERT INTO bhg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ata Asisi Kotopu, Kondade ari Embo awa, Mamo mi piari nato daoda gumaina. Embo ami rorae berari imomane atopataina, edo ami ro berari nane imondemane tedo etena awa, itomane kotembarida tekago kundo gumaina. ");
INSERT INTO bhg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na béga itomane yai doturena; nato béga imondemane pipitena. Butu embomaimi piari tao ae. Itomane do buriya ainyae edo adu ainyae. ");
INSERT INTO bhg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Ge eiwa nanemi imondemane teteno ingewa, ‘Na dodo mamain ena, edo itomane yai tekago gumana.’ Nane tetena awa, ‘Na Mamo da yai mamain ena,’ edo nato Mamo awa na daginegari. Awatedo, edo imomane na dubobudo ewa gido, imomane do yawa awa. ");
INSERT INTO bhg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Edo boroko ro amboda idegaina awa imondemane garedo tetena, iji nonde idegari gido imomane gebé awate. ");
INSERT INTO bhg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aindabé butu einda gisijiari gupeira, na imondemane ge borere jiwae tainyae. Edo embo ami na gisijiari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ata ge okain awa Mamo mi namonde tesira, na dá ango edo ena, embomai butu dededa ami na Mamo dubobudo ena awa gorote. “Eriwo kaende mambore. ");
INSERT INTO bhg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Na awa dongo gurepi da ipubé, edo nato Mamo awa gurepi buroda tutu. ");
INSERT INTO bhg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Papatu da da nomi nato yai isite be ekae edo eira awa kapedo eira. Edo papatu da da be ekedo eira awa, dende kapedo ari be jiwae ekedo arate. ");
INSERT INTO bhg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ge awa nane imondemane teteno buritewa, awatedo imomane awa matu dende kapari. ");
INSERT INTO bhg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Imomane namonde daedo dada ari isiwo, edo na imondemane daedo dada ari itana. Dá ango dongo patumi ipude daedo dada ari itae awa be ekari tao ae, imomane namonde daedo dada ari itae gido, be ekari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Na awa dongo ipu, edo imomane awa papatu. Imo ainmi namonde daedo dada ari isiuri, edo na ainde daedo dada ari isiwono, ami be jiwae ekedo eira. Awarata, edo imomane namonde daedo dada ari itae gido awa, buro da ro ari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Embo ainmi namonde daedo dada ari itae awa dongo patu ango buro tutumi demonda augari mumuya aina. Edo awamanemi papatu ango awa doregedo kundo niyaoda augaro avedo ara. ");
INSERT INTO bhg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Edo imomane namonde daedo dada ari itawa, edo nato ge imondemane daedo itaina gido, ro jipapa edo tedogawo God mi imondemane piaina. ");
INSERT INTO bhg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Iji ainde imomane be jiwae ekedo ewa, emi taogari Mamo natoda yai piaina edo imomane awa nato ambodani arapa aina. ");
INSERT INTO bhg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Dá Mamo mi na dubobudo esira ango awa, nane imomane dubobudo etena. Namonde daedo dada ari isiwo nato dubobari bave. ");
INSERT INTO bhg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Edo imomane nato ge okain kera edo awa gido, namonde daedo isite nato dubobari bawa dá ango na Mamo natoda ge okain kera edo etena edo na ainde daedo isite ainda dubobari budo ena. ");
INSERT INTO bhg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nane rorae berari eiwa imondemane tetena awa, nato yawa ari imondemane daedo itarate, edo itomane yawa ari beda arate. ");
INSERT INTO bhg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Edo nato ge okain awa eire, imomane dubo mina bara awate dá nane imomane dubobudo etena ango. ");
INSERT INTO bhg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Dubobari bajinabé embo berarida daginegari awa evire, embo ainmi ainda otatawo awaembo ainda wasiri piaina. ");
INSERT INTO bhg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Edo ge okain ro berari nane imondemane tedo ena awa kera awa gido, imomane awa nato otatawo. ");
INSERT INTO bhg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Buro embomi ro embo ainda badarimi buro edo eira awa gae, awatedo iji boroko einde edo amboda, nane imomane dao buro embobo tae. Ata Mamo natomi rorae berari awa teuri ingido teono gido etewa, awatedo imomane dao otatawo tetena. ");
INSERT INTO bhg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Inemane na gerae, ata nanemi imomane geritena. Edo na imomane avigesitena, idegedo maundo be ekawate edo be itomane matawa itarate. Edo rorae ro Mamo da yai dao natoda tedogawa awa ami imondemane piaina. ");
INSERT INTO bhg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Rorae berari eiwa nanemi imondemane ge okain tena, imomane dubo mina bara awate. ");
INSERT INTO bhg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Edo butu embomaimi imondemane sinigambari edo era, kotembewo, gisibé awamanemi namonde sinigambari edo esitera, edo ainda amboda imondemane edo era. ");
INSERT INTO bhg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Edo imomane awa butu embomai gido, butu embomaimi ainda topo dubobae etera. Awarata imomane awa butu embomai ae, ata nane butu embomaida toropuda ainda imomane geritena. Awatedo butu embomaimi imondemane sinigambari edo era. ");
INSERT INTO bhg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nane imondemane ge tedo etena awa kotembewo, ‘Buro emboda dero awa ainda badarida dero daginegae.’ Edo embomaimi nato yai memesi neide kainde piedo etera gido awa, daedo itomane yai memesi neide kainde piara. Edo awamane ge nato kera edo etera gido awa, daedo itomane ge kera ara. ");
INSERT INTO bhg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ata imomane awa nato ambodani, edo embo ainmi na piesiri guputeni awa awamane gae, awatedo awamanemi iwata berari eiwa imondemane ara. ");
INSERT INTO bhg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Edo na gundo awamanede ge tae gido, awamaneda jimbo beyaeda rirowa awa itae. Ata boroko, awamaneda jimbo beyaeda ge tedo daginegari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Embo ainmi namonde sinigambari edo eira awa, daedo Mamo nato de sinigambari edo eira. ");
INSERT INTO bhg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Edo nanemi awamaneda toropuda buro babain embo neimi gisi ae awa ae gido, awamaneda jimbo beyaeda rirowa awa itae. Ata boroko awamanemi buro babain eono gido etera, edo awamanemi daedo sinigambari na ae Mamo nato deda yai edo etera. ");
INSERT INTO bhg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ata iwata engo idegesira, ge awa awamaneda Aodari da gaiari isira awa bé arate, ‘Awamanemi namonde sinigambari etera, ata aindabé itae.’ ");
INSERT INTO bhg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ata iji amboda, nane Kondade ari Embo, Mamo da yai edo itomane yaida piano gumaina. Embo awa gebéda Asisi, edo ami Mamo da yai idegedo eira. Edo ami na averi awa embomaide karigaina. ");
INSERT INTO bhg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Edo imomane tuturoda namonde daedo isite, edo gundo iji boroko einda namonde itewa, awatedo imomane daedo na averi awa embomaide karigawa. ");
INSERT INTO bhg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nane rorae berari eiwa imondemane tetena awa, itomane gebé ari nato yaida awa dovekae. ");
INSERT INTO bhg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Awamanemi imomane benunu oroda kundo arapada piara, tenda torovekae engiregara. Gebé, iji gupeira ainde berari ainmi imomane dari betawa, ami buro dave God awaembo eira kotemaina. ");
INSERT INTO bhg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Edo awamane Mamo awa gae edo na awa gae, awatedo awamane iwata berari eiwa ara. ");
INSERT INTO bhg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ata nane rorae berari eiwa imondemane tetena, iji nonde awamanemi iwata berari eiwa ara, imondemane ge ro tetena awa kotembawate. Ata tuturoda na imondemane daedo isima edo esitena, awatedo rorae berari eiwa imondemane tae. ");
INSERT INTO bhg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ata boroko na embo ainmi piesiri guputena ainda yai mauntena, edo imomane da (1)mi namonde, ‘Yai nonda mauntesi?’ awa tedogae. ");
INSERT INTO bhg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ata nane rorae berari eiwa imondemane tetena, awatedo imomane dubo vevera bajina bé etewa. ");
INSERT INTO bhg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ata nane gebé eiwa imondemane tena, nato dodo mambari awa itomane dave. Aindabé, na mambae gido, Kondade ari Embo (Asisi Kotopu) itomane yai gumainyae. Ata na mamana gido, nanemi embo awa piano itomane yai gumaina. ");
INSERT INTO bhg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Edo iji ainde ami gundo, butu embomai da jimbo beyae awa arapa edo aina, edo awamaneda wasiri dambu darari itae awa arapa edo aina, edo God da katari awamaneda yai awa arapa ari berari gido ara. ");
INSERT INTO bhg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Awamaneda gebé ari nato yai piae, awatedo embo ami awamaneda jimbo awa arapa ari gido ara. ");
INSERT INTO bhg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Edo na Mamo da yai mauntena, edo imomane na tekago jijimbari tao ae, awatedo embo ami awamaneda wasiri dambu darari itae awa arapa ari gido ara. ");
INSERT INTO bhg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Edo butu einda gisijiari awa God mi matu kasisina, awatedo embo ami God da katari awamaneda yai arapa ari gido ara. ");
INSERT INTO bhg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nane rorae jiwae nenei daedo imondemane tain jipapa ena. Ata inemane boroko ge ango awa bari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Awarata, iji nonde gebéda Asisi gumaina, ami imomane gebé berarida yai gisijido aina. Edo ainda awara tari akuta ami ge tainyae, ata ro ami ingido awa tedo aina, edo daedo rorae ro amboda gumaina awa imondemane tari gido awa. ");
INSERT INTO bhg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Aindabé embo ami gebé nato awa kundo imondemane tedo aina, ami nato yaida taogari piedo aina. ");
INSERT INTO bhg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Rorae berari Mamo da yai isira awa nato. Awatedo nane tetena awa, Asisi Kotopu mi gebé nato awa kupeite imondemane tedo aina. ");
INSERT INTO bhg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Aindabé na dodo Mamo da yai mamain ena, iji tupo imomane na gari tao ae. Edo iji tupo ainda amboda, imomane na tekago gawa.” ");
INSERT INTO bhg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ango tesiri ainda ambodani neneimi awamane akuta mina tara esitera. “Ge eiwa sira, ainda moka awa rori? Embo ami sira, ‘Iji tupo imomane na gari tao ae. Edo iji tupo ainda amboda imomane na tekago gawa.’ Edo daedo ami kaenamonde ge sira, ‘Na dodo Mamo da yai mamain ena.’” ");
INSERT INTO bhg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Edo awamane mina tara edo esitera, “Ine ‘Iji tupo’ sira. Awa rori? Ami ro sira awa kaenato yai arapa ae.” ");
INSERT INTO bhg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ango edo Iesu mi sisina, “Na ge engo tetena, ‘Iji tupo imomane na gari tao ae. Edo iji tupo ainda amboda, imomane na tekago gawa.’ ” Edo imo gosisina, awamanemi ge eiwa imonde tedogain jipapa era. Awatedo awamanede sisina, “Ge nane imondemane tetena ainda moka rori awa kakowa eite mina tara evita? ");
INSERT INTO bhg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Eiwa awa gebé bajina imondemane tena. Imomane ji site do ari ji gatawa, ata butu embomaimi yawa ara. Imomane dubo vevera awa, ata itomane dubo vevera ari awa wareregedo yawa aina. ");
INSERT INTO bhg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Iji nonde eutumi mai bain edo eira, ainda mai bari iji awa aikae goteite kotembari jiwaemi dubo vevera edo eira. Ata iji nonde ainda mai engesira, aindabé mai awa butuda idegesira, imo memesi ruvegedo yawa edo eira. ");
INSERT INTO bhg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Edo boroko awa imomane dá ango dubo vevera ewa, ata imomane tekago gana; edo iji ainde do itomane yawa aina, edo embo da ainmi itomane yawa ari teugedo kumbari tao ae. ");
INSERT INTO bhg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Edo deguta ainde inemane nato yai rorae ro benunu tainyae. Eiwa awa gebé bajina imondemane tena, ro Mamo da yai nato daoda tedogido awa, ami imondemane piedo aina. ");
INSERT INTO bhg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Edo gundo iji boroko einde imomane nato daoda God da yai rorae tedogae. Atega edo buwo, itomane yawa ari beda arate. ");
INSERT INTO bhg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ge berari eiwa imondemane kariwa gemi tedo etena. Ata iji gumbari ainde, nane kariwa gemi imondemane tenda tainyae, ata nanemi Mamo da daoda ge arapa imondemane tedo ana. ");
INSERT INTO bhg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Edo deguta ainde inemane nato daoda Mamo da yai tedogido awa. Edo nanemi ro awa Mamo da yai imomane embo tedogana awa itae. ");
INSERT INTO bhg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aindabé imomane na duboburitewa, edo na God da yai edo guputena awa gebé esitewa, awatedo Mamo imo akuta ami imomane dubobudo eira. ");
INSERT INTO bhg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na Mamo da yai edo butu einda guputena. Ata tekago na butu eiwa doturena edo Mamo da yai mauntena.” ");
INSERT INTO bhg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Edo ainda ambodanimi ainde sitera, “Gi, boroko imo namondekare ge arapa teta, kariwa ge jigamo ae! ");
INSERT INTO bhg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Edo boroko nakare gari, imo rorae berari gari. Aindabé imo embomaida kotembari matu gari, awatedo awamanemi ro embo tedogari ito yai piari awa itae. Emi eiri nakare gebé era, imo God da yai edo guputeta.” ");
INSERT INTO bhg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Edo Iesu mi awamanede mina sisina, “Boroko imomane gebé evita? ");
INSERT INTO bhg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Giwoǃ Ora gupeira edo boroko gumbira, imomane evekara edo mando ika de ika deda maundo na akuta dowawa. Awarata, Mamo awa namondeda isira, awatedo na akuta itainyae. ");
INSERT INTO bhg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Nane rorae berari eiwa imondemane tetena, imomane namonde daedo dada ari isite béga itomane yai itarate. Iji angode imomane butu einda isite memesi ae bouga de budo ewa. Ata goroba buwo! Nane butuda goroba awa daginegesitena.” ");
INSERT INTO bhg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Edo Iesu rorae berari eiwa tedo, ainda jisi ikane utuda edo benunu sisina: “Mamo, ora awa gumbira. Ito Mai da taogari arapa eyo, Mai itomi ito taogari arapa are. ");
INSERT INTO bhg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Aindabé ine awara tari ainde pipisiteta embo enembo berari gisijiarate, ami embomai nandogo ainda yai ine pipisiteta, awamaneda yai wasiri natopo itari piaina. ");
INSERT INTO bhg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Edo wasiri natopo itari awa eiwa: embomaimi imo awa God bé akuta gara, edo Iesu Keriso, ine pieteto gupusina awa daedo gido dada ara. ");
INSERT INTO bhg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nane taogari ito arapa eteno embomai butu einda gera. Buro ro ine anate pipisiteta awa petugetena. ");
INSERT INTO bhg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Edo Mamo, boroko, na ito demonda isiano taogari nato yai pieyo bane. Taogari awawa butu itae gisida imonde daedo budo esitena. ");
INSERT INTO bhg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ine embobo eiwa embomai butu einda doda kundo namonde pipisiteta. Nane imo embo averi awa eono awamaneda yai arapa euri gido etera. Iji gisi awamane awa imo topo, edo ine namonde pipisiteta, edo awamanemi ito ge kera edo etera. ");
INSERT INTO bhg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Edo boroko awamane gido etera, rorae berari ine namonde piedo eteta awa, ito yai edo gundo eira. ");
INSERT INTO bhg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ge berari ine namonde pipisiteta awa, awamanede pieteno buritera. Edo awamane gebé gositera awa, na ito yai edo guputena, edo awamane gebé esitera, ine na pieteto guputena. ");
INSERT INTO bhg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na awamane embo benunu tena. Na embomai butu dededa awaembo benunu tae, ata awamane awa imo topo, awatedo awamane avekave inemi namonde pipisiteta awaembo benunu tena. ");
INSERT INTO bhg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Edo nato topo berari awa ito topo. Edo ito topo berari awa nato topo. Edo awamanemi nato taogari embomaida yai arapa eoro gido etera. ");
INSERT INTO bhg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Edo na ito yai gupena, awatedo na butuda itainyae. Ata eiwamane butuda isima edo era. Mamo, imo awa Embo Kotopu. Dao itoda goroba (Dao awa ine namonde pipisiteta.) ami awamane dedegeyo, awamane da (1) ore, dá ingena awa da (1) ango. ");
INSERT INTO bhg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Iji ainde na awamanede butuda isite, awamane dao itoda gorobami dedegedo etena. Awamane inemi namonde pipisiteta awa nane dedegetena. Edo ainda doda da (1) ave dadoegae, ata embo da (1)bé awa usibesi ari yaida mamaina, God da Ove Gaiarida isira awa bé arate. ");
INSERT INTO bhg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ata boroko na ito yai gupena, edo na butu einda isite ge berari eiwa tena awa, nato yawa ari awamaneda doda sirido beda arate. ");
INSERT INTO bhg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nane ito ge awamanede pipisitena, edo awamane awa butu embomai da topo ae, dá ango na awa butu embomaida topo ae, awatedo butu embomaimi awamanede sinigambari edo etera. ");
INSERT INTO bhg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Edo na awamane butu einda awa dodo batate benunu tae, ata ine embo beyaeda yai awamane dedegatate tena. ");
INSERT INTO bhg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Awamane awa butu embomaida topo ae, dá ango na awa butu embomaida topo ae. ");
INSERT INTO bhg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Awamane awa gebé itomi eyo embomai kotopu ore. Ito ge awa gebé. ");
INSERT INTO bhg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Edo ine na butuda pieteto guputena dá ango, nane awamane butuda pieteno maunsitera. ");
INSERT INTO bhg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Awamane embo nane nato wasiri imonde pipitena awa ine na tatajiato ito topobé anate. Awatedo ine gebé itomi awamane daedo tatajiato ito topobé ore. ");
INSERT INTO bhg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nane awamane akuta awaembo benunu tae, ata daedo nane ouwamane ainkainmi awamaneda ge ingido gebé ari nato yai piara, awamane embo benunu tena. ");
INSERT INTO bhg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nane awamane berari awa ato da (1) orote benunu tena, Mamo, dá imo namonde daedo dada ari iteta edo na imonde daedo dada ari itena ango. Daedo na benunu tena, awamane awa ato ingenamonde daedo da (1) orote, embomai butudami inemi na pieteto guputena awa gebé orote. ");
INSERT INTO bhg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Edo nane taogari ine namonde pipisiteta awa awamanede pipisitena, awamane ato da (1) orote dá ingena ango: ");
INSERT INTO bhg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","na awamanede daedo dada ari itena, edo imo namonde daedo dada ari iteta, awamane ato ingenamonde davebé dave da (1) orote, edo embomai butudami inemi na pieteto guputena awa gorote, edo ouwamanemi ine awamane duboburiteta dá ine na duboburiteta ango gorote. ");
INSERT INTO bhg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mamo, na jipapa ena awa, avekave inemi namonde pipisiteta awa daedo na nonda itena ainda namonde daedo itorote, edo nato taogari gorote. Aindabé imo na duboburiteta, inemi taogari awa namonde pipisiteta, butu gambae gisida. ");
INSERT INTO bhg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“O Mamo, imo awa wasiri dambu darari. Gebé, embomai butu dededa awa imo gae, ata na imo gositena, edo eiwamanemi ine na pieteto guputena awa gositera. ");
INSERT INTO bhg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Edo nane imo embo averi awa awamanede eteno arapa esiri gositera, edo ano arapa ari gido ara, awamane dubo mina bara orote dá ango ine na dubobudo eteta, edo na awamanede daedo dada ari itanate.” ");
INSERT INTO bhg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iji ainde Iesu benunu tedo itae edo imo ae ainda ambodani de yai awa dodo Kidron Poga ainda temundo maunsitera. Edo kupo neida buro isira ainda, imo ae ainda ambodani de totoritera. ");
INSERT INTO bhg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Edo Iesu iji jiwae ainda ambodani de yai ainda doregedo esisina, awatedo Judas (Embo ami Iesu gitopoda ipada piaina.) awa daedo yai awa gari. ");
INSERT INTO bhg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Edo pirisi babain ae Parasi mane demi Rome da itoro embobo ae sima ari embobo de awa Judas da yai pipisitera. Edo awamane giami de parara ae keimo de bero Judas mi gisijido yai ainda gupusina. ");
INSERT INTO bhg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Edo Iesu ro berari ainda yai idegaina awa gosisina, awatedo imo idegedo iunte awamanede sisina, “Imomane ave gain evi?” ");
INSERT INTO bhg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Awamanemi ainde mina sitera, “Iesu Nasaret Embo.” Edo Iesu mi awamanede sisina, “Na embo awa.” Edo Judas (Embo ami Iesu gitopoda ipada piaina.) daedo awamanede petedo isira. ");
INSERT INTO bhg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Edo iji ainde Iesu mi awamanede sisina, “Na embo awa,” awamane gun mi iunte butuda duduritera. ");
INSERT INTO bhg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Edo ami tekago awamanede tedogosisina, “Imomane ave gain evi?” Edo awamanemi sitera, “Iesu Nasaret Embo.” ");
INSERT INTO bhg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Edo Iesu mi sisina, “Nane imondemane tetena awa, na embo awara. Imomane na gain ewa gido, embobo eiwa dowo mambore.” ");
INSERT INTO bhg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iesu mi ge eiwa sisina, ge awa imo gisi sisina awa bé arate, “Awamane inemi namonde pipisiteta ainda embo da ji nane dadoegae.” ");
INSERT INTO bhg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Edo Simon Peter kasiwo de gundo worugedo pirisi maneda gisijiari bajinada buro emboda dengoro ipa beda awa dedo kautugesisina. Edo buro emboda dao awa Malchus. ");
INSERT INTO bhg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Awatedo Iesu mi Peter de sisina, “Ito kasiwo woruda pieyo! Nane memesida akou Mamo natomi pipisisina awa dodo mamana kotembetesita? Nane awa inana.” ");
INSERT INTO bhg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Edo itoro embobo ae itoroda badari de, Jew embomaida sima ari embobo demi Iesu kundo bunjitera. ");
INSERT INTO bhg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ango edo imo kundo Annas da yai gisi maunsitera. Edo duberi ainde Caiaphas awa pirisi maneda gisijiari bajina edo Annas awa Caiaphas da ato. ");
INSERT INTO bhg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Edo iji gisi Caiaphas mi Jew embobode ao darari ge sisina, dave awa embo da (1) embomai awaembo daro betaina. ");
INSERT INTO bhg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Edo Simon Peter ae ambodani nei da (1)demi Iesu ambo ambo esitera. Edo pirisi maneda gisijiari bajinami ambodani awa Peter de gumbira awa gari. Awatedo ambodani awa ae Iesu de daedo pirisi maneda gisijiari bajinada mando guwada torido maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ata Peter awa manguro be arapada petedo isira. Edo ambodani nei awa, (Pirisi maneda gisijiari bajinami imo gari.) ami idegedo maundo manguro sima ari gagarade tesiri giri Peter budo totorisina. ");
INSERT INTO bhg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Edo buro gagara manguro sima edo eira ami Peter de sisina, “Imo daedo awa embo ounda ambodani da (1), awa gebé rita?” Edo ami mina sisina, “Na awa ae.” ");
INSERT INTO bhg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Iji ainde awa damodamo edo buro embobo ae sima ari embobo de ni mundu veverada jiroro edo pepetegedo aveite itera. Edo Peter awamanede daedo petedo aveite isiri jijirisina. ");
INSERT INTO bhg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Iji dá ainde pirisi maneda gisijiari bajinami Iesu de tedogari ainda ambodanida edo ainda atopatarida awa pipisisina. ");
INSERT INTO bhg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Edo Iesu mi ainde mina sisina, “Na embo berarida yai arapada ge tedo etena. Na iji matawa benunu oroda edo oro kotopu bajinada, yai nonda Jew embomai dada eoro atopasido etena. Nane onjigedo ge da ji tae. ");
INSERT INTO bhg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ro embo namonde tedogotesi? Ouwamane ainkainmi ge ro awamanede teono ingido etera awa tedogiyo. Awa gebé, nane ge ro tedo etena awa awamane gari.” ");
INSERT INTO bhg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Edo Iesu ge eiwa tesiri, sima ari emboboda embo da (1) demonda petari isira ami ipa do bereya edo Iesu dombuda iji da (1) dedo sisina, “Ine pirisi maneda gisijiari bajina de ge ango tainyae!” ");
INSERT INTO bhg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu mi embo ainde mina sisina, “Na ge beyae tetena gido, ge beyae ro tetena awa arapada karigewasi; ata gebé tetena gido, nongain na doresi?” ");
INSERT INTO bhg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ango edo Annas mi imo bundari matawa piesiri pirisi maneda gisijiari bajina, Caiaphas da yai, maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Edo Simon Peter awa petedo ni aveite isiri awamanemi ainde sitera, “Imo embo ounda ambodani da (1) awa gebé rita?” Edo imo akuta toreite sisina, “Na awa ae!” ");
INSERT INTO bhg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Edo pirisi maneda gisijiari bajina ainda buro embo da (1) awa embo Peter mi dedo dengoro kautugesira ainda embotopo. Embo ami sisina, “Na imo ae embo ounde buro doda gena, awa gebé rita?” ");
INSERT INTO bhg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Edo tenda Peter imo akuta toreite ge sisina, edo boraebé kokora aoro sisina. ");
INSERT INTO bhg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ango edo sipobéde awamanemi Iesu Caiaphas da yai awa dodo gisijido kundo Rome gavanada mando bajinada maunsitera. Edo awamane Darutegari Bondoda rorae indorote jipapa esitera, awatedo awamane mando awa torae, awamane akuta God da jisida dono ari buorekae. ");
INSERT INTO bhg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Edo Rome gavana, Pilate, idegedo gundo awamanede sisina, “Embo einde bekumba ge tewa, ainda buriya rori?” ");
INSERT INTO bhg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Edo awamanemi mina ainde sitera, “Embo eiwa buriya embo ae gido, nanekare embo awa ito yai kundo gumainyae.” ");
INSERT INTO bhg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Edo Pilate mi awamanede sisina, “Imomane embo eiwa kundo itomane aodarida ro tari isira ainda katewo.” Awatedo Jew embomaimi ainde sitera, “Rome da aodarida tari isira awa nakare embo dari betari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Edo ge awamanemi sitera awa idegesisina, Iesu mi ainda betari nongo idegaini geda tedo esisina awa bé arate. ");
INSERT INTO bhg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Edo Pilate tekago ainda mando bajina doda torido Iesu dao tedo ainde sisina, “Imo Jew embomaida Daotari rita?” ");
INSERT INTO bhg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu mi mina ainde sisina, “Imo ge eiwa ito topo awa tesita o embo neimi nato daoda imonde tetero geta awa tesi?” ");
INSERT INTO bhg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Edo Pilate mi mina sisina, “Na awa Jew embo ta? Ito Jew embomai ae pirisi babain demi imo nato yaida pietera. Imo buriya ro etesi?” ");
INSERT INTO bhg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu mi mina sisina, “Nato gisijiari awa butu einda ae. Ko nato gisijiari awa butu einda gido, nato kondade ari embobomi erido na dedegae etera. Ango aro Jew embomaimi na kumbari tao ae. Ata boroko nato gisijiari awa butu einda ae.” ");
INSERT INTO bhg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Edo Pilate mi ainde sisina, “Awatedo imo daotari rita?” Iesu mi mina sisina, “Imo gebé teta. Na awa daotari. Edo na awaembo engisina, edo na awaembo butuda guputena, embomaida yai gebé awa rori kariganate. Embo berari ainmi gebé ambo ambo eite nato ge yavi ingido eira.” ");
INSERT INTO bhg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate mi ainde sisina, “Gebé awa rori?” Ango tedo imo tekago idegedo maundo Jew embomaida yai, awamanede sisina, “Na embo einda yai buriya da ro tambae ena. ");
INSERT INTO bhg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ata itomane piari petari isira, duberi da da Darutegari Bondo iji ainde nanemi bundari oroda embo da (1) awa itomane yai udegedo ena. Awatedo nane Jew embomaida Daotari awa itomane yai udeganate udo evita?” ");
INSERT INTO bhg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Edo awamane berari tekago aorogatedo sitera, “Embo awa ae, ata Barabbas!” Edo Barabbas awa jivere embo. ");
INSERT INTO bhg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ango edo Pilate mi Iesu kundo ainda itoro emboboda yai piesiri vejitera. ");
INSERT INTO bhg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Edo itoro embobomi dongo bebede awa kundo daotarida gobe ango engoegedo ainda kopuruda pipisitera. Edo awamanemi ombari ribori tokona awa ainda tamoda pipisitera. ");
INSERT INTO bhg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Edo ainda yai tekago, tekago sitera, “Oro! Oro! Jew embomaida Daotari!” Edo awamanemi imo awa tenda, tenda doritera. ");
INSERT INTO bhg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Edo tekago Pilate idegedo gundo embomaide sisina, “Giwo, na embo eiwa kundo itomane yai idegedo gupena. Ango ano imomane gawate na embo einda beyae da ji tambae.” ");
INSERT INTO bhg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Edo Iesu gobe bebede edo ombari ribori tokona awa tamoda piari idegesisina. Edo Pilate mi awamanede sisina, “Giwo! Embo awa eire!” ");
INSERT INTO bhg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Awatedo, iji angode pirisi babain ae oro kotopuda sima ari embobo demi Iesu gido, awamane aorogatedo sitera, “Oregada de! Oregada de!” Edo Pilate mi awamanede sisina, “Na embo einda beyae da ro tambae. Inemanemi embo eiwa kundo oregada dewo.” ");
INSERT INTO bhg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Edo Jew embomaimi ainde ge mina sitera, “Embo emi imo awa God da Mai ango tedo eira. Awatedo natokare aodari da (1) isira awa, embo ango awa daro betaina.” ");
INSERT INTO bhg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Edo iji ainde Pilate ge eiwa ingido ainda adu aribé babojisina. ");
INSERT INTO bhg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Edo imo tenda gavanada mando doda torido Iesu de sisina, “Imo yai nonda edo guputesi?” Ata Iesu mi ge mina da ro tae. ");
INSERT INTO bhg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Edo Pilate mi ainde sisina, “Imo namonde ge tari jipapa ae esita? Kotembeyo! Nato awara tari isira ami imo udegana ko imo oregada dano betata.” ");
INSERT INTO bhg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu mi mina sisina, “Edo God mi awara tari imonde piae gido awa, inemi nato yai nei ro ari tao. Awatedo embo ainmi na ito yaida piesira, ainda jimbo beyae awa ito jimbo beyae daginegesira.” ");
INSERT INTO bhg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Edo ge awa ingido ainda amboda, Pilate nongo edo Iesu udegari mamaini awa gain edo esisina, ata Jew embomaimi koko jimundo ge site sitera, “Imo embo eiwa dowato mamaina gido, imo awa Caesar da otawo ae. Embo berari ainmi imo akuta awa daotari tedo eira gido awa Caesar da gitopo edo eira.” ");
INSERT INTO bhg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Edo ge awa ingido Pilate mi Iesu kundo idegedo gupusina. Edo Pilate katari emboda anumbada anumbesisina. Katari yaida dao awa Begata Ganumami ari, ata Hiburu gemi awa Gabata. ");
INSERT INTO bhg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Edo Darutegari Bondo ainda siya ari deguta de ora 6 ango eiri, Pilate mi Jew embomaide sisina, “Giwo! Itomane Daotari awa eire!” ");
INSERT INTO bhg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ata awamanemi aorogatedo sitera, “Deyo betare! Deyo betare! Oregada deyo betare!” Pilate mi awamanede sisina, “Nanemi itomane Daotari awa oregada danita?” Edo pirisi babain mi mina sitera, “Nakare daotari itae ata da (1), Caesar akuta!” ");
INSERT INTO bhg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Edo Pilate mi embo awa oregada daro betarate awamaneda ipada pipisisina. Ango edo awamanemi Iesu budo gisijido maunsitera. ");
INSERT INTO bhg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Edo Iesu ainda orega awa budo idegedo maundo Yai Kopuru Akou ainda esisina. Yai einda dao nei Hiburu gemi awa Gologata. ");
INSERT INTO bhg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Edo yai ainda Iesu awa benomami oregada doritera. Edo embo tote (2) ainde daedo oregada doritera. Embo nei demo neida, edo embo nei demo neida, edo Iesu toropuda. ");
INSERT INTO bhg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Edo Pilate mi karigari ge gaiedo piesiri oregada doritera. Edo ainda ajigari awa: Iesu Nasaret Embo, Jew Embomaida Daotari. ");
INSERT INTO bhg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Edo ove gaiari eiwa, Hiburu ae Guriki de Latin deda gemi gagurisina. Edo yai nonda Iesu oregada doritera awa nasi bajina aikae, awatedo Jew embomai jiwaemi karigari ge eiwa ajijigesitera. ");
INSERT INTO bhg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Awatedo Jew embomaida pirisi babain mi Pilate de sitera, “‘Jew Embomaida Daotari’ gaiote, ata, ‘Ine tesira, “Na awa Jew embomaida Daotari,” ’ gaieyo.” ");
INSERT INTO bhg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Edo Pilate mina sisina, “Nane ro gaietena awa matawa itaina.” ");
INSERT INTO bhg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Edo itoro embobo Iesu oregada doritera. Edo ainda amboda, awamanemi ainda ombarijiari budo jisi ipa ao pasido (4) edo embo tegeri da da pipisitera. Edo daedo ainda ombari ribori buritera. Ombari awawa ainda ikane gaiedo wotedo tuda itae ari, ata ainda tatari itae. ");
INSERT INTO bhg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Awatedo itoro embobomi mina tara esitera, “Kaenane keredo evekara ainyae, ata kaen ganuma babaingae ove gaiaride awa augedo ango tetenya ara ami arapa ari ain baini awa gore.” Eiwa idegesisina, God da Ove Gaiarida ge awa bé arate, “Awamanemi nato ombarijiari kundo evekara edo da da buritera, edo nato ombari awa baintedo ganuma babaingae awa augedo tetenya esitera.” Awatedo itoro embobomi rorae berari eiwa esitera. ");
INSERT INTO bhg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Edo Iesu da oregada demonda, ainda ai ae, ainda aida dao de, Clopas da aro Mary de edo Mary nei de (Eutu awa nasi Magadala eutu.), awamane berari pepositera. ");
INSERT INTO bhg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Edo iji angode Iesu ainda ai gosisina, edo ambodani ine dubobé budo eira awa, ainda demonda daedo petedo isiri gosisina. Awatedo ainda aide sisina, “Eutu, ito mai eire!” ");
INSERT INTO bhg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Edo ambodanide sisina, “Ito ai eire!” Edo iji ainde edo ainda amboda, ambodani emi eutu awa ainda mandoda sima arate kundo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Einda amboda Iesu mi ainda buro berari awa matu petugari gosisina. Edo God da Ove Gaiari da ge awa bé arate jipapa esisina, awatedo ami sisina, “Na dubo gagara eira.” ");
INSERT INTO bhg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Edo waini jigagani sigi beda ari awa ainda isiri awamanemi pepeu da (1) pietero tatapu berari esiri kundo inguta hyssop da doiedo Iesu da beda indarate pipisitera. ");
INSERT INTO bhg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Edo waini jigagani awa injido Iesu mi sisina, “Awa petugesira!” Edo imo tumo gotugedo ainda asisi doturisina. ");
INSERT INTO bhg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Edo iji eiwa Siya Ari Deguta, edo sipo nei Darutegari Bondo tuturo aina, awatedo deguta nei awa Oena Apari Deguta deposi. Aindabé Jew emboboda gisijijiegarimi tamo dowari oregada Oena Apari Degutade itari awa jipapa ae esitera, awamanemi Pilate de tedogositera, “Ito itoro embobomi awamaneda tai daro eririgaro tamo kundo mambae eterita?” ");
INSERT INTO bhg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Awatedo itoro embobomi gundo embo tuturoda oregada Iesu de daedo matu doritera awa, ainda tai tote (2)da vetu awa detero erigesisina. Edo embo nei oregada doritera, ainda tai (2)da vetu daedo detero erigesisina. ");
INSERT INTO bhg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ata iji nonde awamanemi Iesu da yai gundo, imo matu betesira gido awa, ainda tai dae erigae doturitera. ");
INSERT INTO bhg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ata itoro embo da (1)mi Iesu awa dendegida gimi gagurisina. Esiri burigibé ororo de un de idegedo wowosisina. ");
INSERT INTO bhg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Edo embo ainmi awa gosisina, ge eiwa karigesisina, edo ainda karigari ge awa gebé. Edo embo awa gari imo gebé sira. Edo ami ge eiwa karigesira, imomane gebé awate. ");
INSERT INTO bhg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Edo rorae berari eiwa idegesisina ami ari God da Ove Gaiarida ge awa bé aina: “Awamanemi ainda vetu da ji daro erigainyae.” ");
INSERT INTO bhg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Edo Ove Gaiarida ge nei bé esisina awa “Awamanemi embo ave gaguritera awa jisimi gara.” ");
INSERT INTO bhg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Iji einda amboda Joseph (Imo awa nasi Eremateia embo.), ami Pilate de Iesu da tamo kundo aimain awa tedogosisina. Joseph awa Iesu da ambodani, ata Jew embomai adu esisina, awatedo Iesu da daoda arapada embode tae. Edo Pilate mi awara esiri Joseph gundo Iesu da tamo kundo yai eve maunsisina. ");
INSERT INTO bhg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Edo Nicodemus, (Imo iji gisibé muyaede Iesu da yai gupusina.) ami iji ainde daedo gupusina. Embo awa myrrh ae aloe de baige ari, bouga tega 34 kilogram ango kundo gupusina. ");
INSERT INTO bhg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Edo embo tote (2)mi Iesu da tamo budo gongo jibigi riribo virarae ami engoegesitera, rorae muno davede daedo. Eiwa awa Jew embomaida embo goiarida begata. ");
INSERT INTO bhg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Edo yai demonda Iesu oregada doritera ainda buro isinesina. Edo buro dá ainda goiari banga to teka siya ari ainda gisi embo da ji goiae isinesina. ");
INSERT INTO bhg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Aindabé iji awa Jew embomaida Oena Apari da Siya Ari Deguta, ainda edo goiari banga to awa aikae, Iesu da tamo yai ainda pipisitera. ");
INSERT INTO bhg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ango edo deguta pura tuturoda, sipo ataede muyae matawa isiri, Mary, nasi Magadala eutu awa banga toda maunsisina. Edo ami ganuma to beda awa kundo demonda piari gosisina. ");
INSERT INTO bhg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Edo eutu awa ainto tumundo maundo Simon Peter ae ambodani nei (Embo awa Iesu mi dubobé budo esisina.) aindeda yai gupusina. Edo Mary mi awamane tote (2)de sisina, “Awamanemi Badari da tamo goiari banga toda awa kundo eve mambera, edo yai nonda pieteri awa nakare gae.” ");
INSERT INTO bhg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Awatedo Peter ae ambodani nei de idegedo goiari banga toda tuturo edo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Edo awamane tote (2) ainto inono banono tuputera, edo ambodani nei ami tumundo Peter daginegedo goiari banga toda gisi gupusina. ");
INSERT INTO bhg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Edo embo awa petedo anega edo jisi banga to doda pipisite gongo jibigi riribo virarae awa durari isiri gosisina. Awarata imo torae. ");
INSERT INTO bhg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ango edo Simon Peter embo awa ambo ambo eite gundo banga toda torido gongo jibigi riribo virarae durari awa gosisina. ");
INSERT INTO bhg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Edo imo daedo gongo gisi dombu gaigari ami Iesu da kopuru doisina awa gosisina. Edo dombu gaigari awa gongo jibigi virarae de daedo itae, ata awa akuta bodedo yai eve demonda piari. ");
INSERT INTO bhg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Edo ambodani nei gisi banga toda gupusina awa daedo torido gido gebé esisina. ");
INSERT INTO bhg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Awarata awamanemi God da Ove Gaiarida ge, Iesu betarida erarate tari isira awa gae arapa ae. ");
INSERT INTO bhg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Edo ambodani tote (2) overegedo awamaneda mandoda tekago maunsitera. ");
INSERT INTO bhg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ata Mary banga to beda petedo ji site isiri jiriri banga to doda gain anega esisina. ");
INSERT INTO bhg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Edo eutu ami anela tote (2) ombarijiari pararade anumbedo itero gosisina. Anela nei awa kopuruda edo nei awa taida, yai Iesu da tamo pietero dudurisina ainda. ");
INSERT INTO bhg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ango edo awamanemi eutu ainde sitera, “Eutu, ro awaembo imo ji tesi?” Edo ami awamanede sisina, “Awamanemi Badari nato budo eve aimbera, edo yai nonda embo awa pieteri na gae.” ");
INSERT INTO bhg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Edo eutu awa ge engo tedo awa wareregedo Iesu ainda petedo isiri gosisina, ata ami Iesu gae arapa ae. ");
INSERT INTO bhg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu mi ainde sisina, “Eutu, ro awaembo ji tesi? Imo ave gain esi?” Eutu ami kotembesisina imo awa buro sima ari embo, edo ainde sisina, “Dave embo, inemi embo awa budo eve aimbeta gido, yai nonda aundo pieteta awa namonde te, nane aundo embo awa budo eve mamane.” ");
INSERT INTO bhg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu mi ainde sisina, “Mary!” Eutu awa wareregedo embo ainde sisina, “Rabboniǃ” (Ge ainda moka awa Atopatari.) ");
INSERT INTO bhg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu mi eutu ainde sisina, “Na Mamo natoda yai vitae matawa itena, awatedo imo na ikanade jiote. Ata nato nanonamejida yai maundo awamanede teyo, ‘Na Mamo natoda yai edo Mamo itomaneda yai vitain ena, edo God natoda yai edo God itomaneda yai.’” ");
INSERT INTO bhg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Edo Mary Magadala eutu ami gundo ambodanide karigesisina awa, imo Badari gosisina, edo embo ami ge eiwa ainde sisina. ");
INSERT INTO bhg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ango edo deguta dá ainda turode, deguta pura tuturoda, ambodanimi Jew embobo awa adu esitera. Awatedo mando do jiumbari ainda doregedo manguro berari doda awa jijitera. Edo Iesu gundo awamaneda doregari doda petedo sisina, “Béga itomane yai itare!” ");
INSERT INTO bhg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Edo embo ami ge eiwa sisina, edo ainda ipa de ainda dendegi de awamaneda yai esiri gositera. Edo iji ainde Badari gido ambodanimi do yawa esitera. ");
INSERT INTO bhg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Edo Iesu mi awamanede tekago sisina, “Béga itomane yai itareǃ Dá ango Mamo mi na piesiri guputena, daedo nane imomane pipitena.” ");
INSERT INTO bhg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Edo embo ami ge eiwa sisina, edo oena awamaneda yai putedo awamanede sisina, “Asisi Kotopu buwo. ");
INSERT INTO bhg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Embo neneida jimbo inemane kotembedo dodo ewa gido, God mi awamaneda jimbo kotembedo dodo eira. Edo inemane embo neneida jimbo kotembedo dowae gido, God mi awamaneda jimbo kotembedo dowae.” ");
INSERT INTO bhg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ata iji ainde Iesu awamaneda yai gupusina, embo da (1) ambodani 12 ainda doda awamanede itae. Edo embo awa Thomas. (Ainda dao nei awa Didymus.) ");
INSERT INTO bhg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Awatedo ambodani neneimi ainde sitera, “Nakare Badari geraǃ” Ata embo ami awamanede sisina, “Na ainda ipada benoma dero awa gae, edo nato ipa toro benoma deroda piae, edo nato ipa ainda dendegi gaiarida deroda piae, na mana gebé ana.” ");
INSERT INTO bhg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ango edo pura da (1) itae esiri, ainda ambodani tekago mando doda doregesitera, edo Thomas awamanede daedo dada esisina. Edo manguro berari doda awa jijitera, awarata Iesu gundo awamaneda toropuda petedo sisina, “Béga itomane yai itareǃ” ");
INSERT INTO bhg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Edo embo ami Thomas de sisina, “Ipa toro ito awa ududugedo einda pieyo, edo ipa nato gi. Edo ipa ito awa ududugeyo einda, edo nato dendegi gaiarida deroda pieyo. Gebé ae eote, ata gebé eyo.” ");
INSERT INTO bhg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Edo Thomas mi mina ainde sisina, “Imo awa nato Badari edo nato Godǃ” ");
INSERT INTO bhg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Edo Iesu mi embo ainde sisina, “Imo na geta, awaembo gebé eteta. Ata God mi euri ouwamane dubodave edo era ainkain na gae awarata gebé edo era.” ");
INSERT INTO bhg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Edo Iesu mi kariwa jiwae nenei ainda ambodanida doda daedo esisina, ove einda gaiae. ");
INSERT INTO bhg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ata ge eiwa gaietena awa, inemane gebé awate Iesu awa Keriso, God da Mai, edo itomane gebé ari ami wasiri ainda toda bawate. ");
INSERT INTO bhg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Einda amboda Iesu tenda ambodanida yai Taiberiasi ubutu da idegesisina. Edo imo engo awamaneda yai idegesisina: ");
INSERT INTO bhg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter de, Thomas (Ainda dao nei awa Didymus.) de, Nathanael (Imo awa nasi Keina, yai Galili embo.) de, Zebedee da mamai de, ainda ambodani nei tote (2) de, awamane dada esitera. ");
INSERT INTO bhg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Edo Simon Peter mi awamanede sisina, “Na maundo wo bain ena.” Edo awamanemi ainde sitera, “Nakare imonde daedo mauntera.” Ango edo awamane idegedo burigibé maundo ma doda wowositera, ata muyae ainde awamane wo da ji bae. ");
INSERT INTO bhg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Edo sipo matu atesiri, Iesu awa un kora popoda peposisina. Awarata ambodanimi embo awa Iesu gain daritera. ");
INSERT INTO bhg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Edo Iesu mi awamanede sisina, “Nato otatawo, imomane wo nei ro bae evita?” Awamanemi embo ainde mina sitera, “Bae.” ");
INSERT INTO bhg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Edo embo ami awamanede sisina, “Itomane monga awa ma demo ipa beda augewo wotari imomane wo bawa.” Ango edo awamane monga augetero wotesiri wo jiwae ekisina. Edo wo jiwaeda bougami esiri monga ma doda dumbari vitari tao ae esitera. ");
INSERT INTO bhg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Awatedo ambodani awa Iesu mi dubobé budo eira ami Peter de sisina, “Ouwa Badariǃ” (Iji einda gisida Peter mi ainda ombari kokumbesisina.) Edo Simon Peter mi ge awa ingido ainda ombari ribori ipuda bundedo unda kekapunya edo kora popoda davedo mamain esisina. ");
INSERT INTO bhg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ata ambodani nenei ma sakade ami monga wode awa dupeite kora popoda guputera. Awamane awa butubé aikamana ae, tepo ribori tega 100 metres ango. ");
INSERT INTO bhg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Edo iji ainde kora popoda denembedo visido awamanemi yai ainda ni mundu vevera eiri gositera, edo ainda tamonda un wo da (1) edo bread gositera. ");
INSERT INTO bhg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Edo Iesu mi awamanede sisina, “Wo nenei inemane teka kumbewa awa kundo gumbuwo.” ");
INSERT INTO bhg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Awatedo Simon Peter maundo mada visido monga wo babain jiwaede beda ari awa dumundo kundo visido kora popoda esisina. Edo wo da ajijigari berari awa 153. Edo wo awa jiwaebé, ata monga awa dendegae. ");
INSERT INTO bhg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Edo Iesu mi awamanede sisina, “Gumbuwo, sipo rorae indave.” Aindabé awamanemi gositera embo awa Badari, ambodani da ainmi goroba edo embo ainde tedogae, “Imo averi?” ");
INSERT INTO bhg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Edo Iesu gundo bread kundo awamanede pipisisina. Edo dá ango awamanede wo pipisisina. ");
INSERT INTO bhg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Edo amboda Iesu betedo tenda erorisina, eiwa iji tamonde (3) imo ainda ambodanida yai idegesisina. ");
INSERT INTO bhg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Iji ainde awamane sipo rorae injido itae edo, Iesu mi Simon Peter de sisina, “Simon, Jonah da mai, ito dubobari nato yai embobo einda dubobari awa daginegari rita?” Edo ami ainde sisina, “Een Badari, imo awa gari, na imo duboburena.” Edo Iesu mi ainde sisina, “Sipu mamai nato undeyo.” ");
INSERT INTO bhg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Edo Iesu mi iji nei tenda embo ainde sisina, “Simon, Jonah da mai, imo na duboburesita?” Embo ami ainde sisina, “Een Badari, imo awa gari, na imo duboburena.” Edo Iesu mi ainde sisina, “Sipumane nato sima dave eyo.” ");
INSERT INTO bhg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Edo iji neida gagani awa ami embo ainde sisina, “Simon, Jonah da mai, imo na duboburesita?” Aindabé Iesu mi embo ainde iji neida gagani sisina, “Imo na duboburesita?” Peter dubo vevera esisina. Edo embo ami ainde sisina, “Badari, imo rorae berari awa gari. Imo goteta na imo duboburena.” Edo Iesu mi embo ainde sisina, “Sipumane nato undeyo. ");
INSERT INTO bhg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Eiwa awa gebé bajina imonde tena. Iji ainde imo embo teka isite ito ombarijiari imo akuta bundedo esiteta, edo yai nonda imo aimain jipapa eite aundo esiteta. Ata iji ainde imo embo begogo isite ito ipa ududugato embo neimi imo bundedo yai nei nonda imo aimbari jipapa ae ainda imo gisijido kundo aimaina.” ");
INSERT INTO bhg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Edo ge eiwa Iesu mi sisina, Peter da betari nongo nongo ami taogari God da yai piaini awa arapa esisina. Edo ge eiwa tedo amboda Iesu mi embo ainde sisina, “Na ambo ambo eyoǃ” ");
INSERT INTO bhg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Edo Peter wareregedo ambodani Iesu mi dubobudo eira awa gosisina. Edo iji ainde ambodani awa Peter ae Iesu de ambo ambo esisina. (Embo awa daedo iji gisi angode awamane turo indarida itero Iesu da opopoda atutumbedo iunte ainde sisina, “Badari, embo ainmi imo gitopoda ipada piain eiri?”) ");
INSERT INTO bhg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Edo Peter embo awa gido Iesu de sisina, “Edo Badari, embo awa nongo nongo aini?” ");
INSERT INTO bhg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Edo Iesu mi embo ainde sisina, “Edo na embo awa jipapa ano matawa wasiride isirari na egenemana, awa ito bouga ae. Imo na ambo ambo eyo.” ");
INSERT INTO bhg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Awatedo ge eiwa gebé ari embomai da yai arapu esisina awa, ambodani eiwa betainyae. Awarata Iesu mi embo awa betainyae ango embo ainde site tae, ata, “Edo na embo awa jipapa ano matawa isirari na egenemana, awa ito bouga ae.” ");
INSERT INTO bhg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Eiwa ambodani emi ge eiwawa karigedo eira edo ge eiwawa gaiesira. Edo nakare awa gari ainda karigari ge awa gebé. ");
INSERT INTO bhg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Edo daedo Iesu mi rorae nenei jiwae esisina. Edo na kotembetena, edo embomaimi rorae berari awa da da oveda gaiae etera awa, ove gaiari berari awa butu dedemi inono bari tao ae. Awara. ");
INSERT INTO bhg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O arie Theophilus, ove gisi imo embo sirigesitena awa, nanemi iwata ari berari de atopatari de daedo awa Yesu mi tuturo edo ");
INSERT INTO bhg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ainda amboda deguta ainde utuda vivisisina, awawa gaguritena. Edo utuda vitae gisida Asisi Kotopu mi Yesu gisijiri ami ge okain ainda piari aimbari embobo matu avigari ainde tesiri gositera. ");
INSERT INTO bhg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ainda amboda, Yesu da betari edo erari, embo ami deguta 40 isite ainda piari aimbari emboboda yai imo akuta idegesiri ainda iwata jiwae arapada goteite Yesu awa wasiride gebé esitera. Daedo, iji dá angode, Yesu mi God da gisijiarida ge awamanede atopaposisina. ");
INSERT INTO bhg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Edo iji ainde Yesu awamanede indari indeite ami ge okain sisina, “Jerusalem dowainyae, atako isimango amboda kando ro nato Mamo mi imondemane piain tarigari sisina awa piari bawa, dá ango na imondemane matu teteno gotawa. ");
INSERT INTO bhg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Gebé, John embomai un mi bapataito esisina, ata deguta indewae einda amboda, God mi imomane ainda Asisi Kotopu mi bapataito aina.” ");
INSERT INTO bhg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ango edo awamanemi amboda gundo doregedo ainde benunu sitera, “Badari, ine iji boroko emi Israel embomainda daotarida deroda visido nakare kondade edo gisijijiegari yai neinda ami kaena gisijido era, awamane ondato aimbaro kaenato udegari tekago bae eterita?” ");
INSERT INTO bhg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ango tetero Yesu mina sisina, “Nato Mamo ainda awara tarimi iji neneinde edo yoa neneinde avigedo eira, edo iji nonde awamane idegari awa imomane gari tao ae. ");
INSERT INTO bhg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Atako imomane ge eiwa gari tao ewa. Iji nonde Asisi Kotopu mi itomane yaida gumbari awa, imomane God da goroba bawa. Ango edo inemanemi na awa embo averi awa embomainde karigawa, Jerusalem doda, edo daedo yai Judea berarida, edo yai Samaria da edo butu umbugo aikamanabéda.” ");
INSERT INTO bhg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ango tesiri awamanemi Yesu gotero, God mi embo awa jiri utuda vivisisina. Edo poragami Yesu apuregesiri awamane embo awa jisimi gae gae esitera. ");
INSERT INTO bhg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Edo iji dá ainde awamanemi pangedo utuda jijimbetero Yesu viviteiri, boraebé embo tote (2) ombarijiari pararade awamaneda demonda idegedo ");
INSERT INTO bhg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","edo awamande sitera, “Galili embobo, Yesu dá eiwa imomane dodo jiri utuda visira, tekago gumaina dá imomane embo awa utuda maunteiri jijimbetewa ango. Awatedo, utuda gain pangewa, awa dowo!” ");
INSERT INTO bhg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ango edo Yesu da piari aimbari embobo Ni Olive de Peji da dodo overegedo Jerusalem da maunsitera. Aindabé Jerusalem awa aikamana ae, iji tupo pepeta esitera. ");
INSERT INTO bhg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Edo iji nonde awamane nasida torido, yai engiregarida awamane isima edo esitera, ainda visido totoritera: Peter ae James de John de Andrew de, Philip ae Thomas de, Bartholomew ae Matthew de, James nei awa Alphaeus da mai ae Simon Zelot Embo de, edo Judas, James eveda mai. ");
INSERT INTO bhg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Eiwamane berari matawa kotembari da (1)mi benunuda edo ategada God da yai tedo esitera, eutumai ae Mary, Yesu da ai de edo ainda nanonameji de daedo. ");
INSERT INTO bhg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Edo deguta angode, Peter ambodanida doda erido peposisina (awamaneda doregarida ajijigari berari awa 120 ango). Edo ami sisina, ");
INSERT INTO bhg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nanonameji, God da katari eiwa ainda Ove Gaiarida Ge bé arate awa gisi Asisi Kotopu mi David da beda piesiri Judas awa embo sisina. Embo ami awamane gisijiri Yesu kundo maundo bunjitara. ");
INSERT INTO bhg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yesu mi Judas namondekare daedo avigesisina, awatedo, ainda dero God da buro awa embo burisina.” ");
INSERT INTO bhg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Awara, embo eiwa buro bebegae esisina ainda tau awa budo ami butu oriesisina. Ango edo ikane edo kopuru tuda edo durudo desiri osi bejisina. Edo ainda deoboge berari awa arapada idegesisina. ");
INSERT INTO bhg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ango esiri embomai berari Jerusalem doda isiretera ami bino eiwa ingitera. Awatedo, awamaneda gemi yai ainda dao Akel Dama tedo era. Ainda moka awa ‘Ororo Wotari Butu.’) ");
INSERT INTO bhg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Edo Peter mi tedo sisina, “Aindabé Psalm da Ove Gaiarida David mi ge engo gagurisina, ‘Embo awa ainda mando pororo parara jimaina, Edo embo da ji ainda itainyae,’ edo daedo, ‘Embo neimi ainda gisijiarida dero baina.’ ");
INSERT INTO bhg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Awatedo, embo neimi namondekare daedo Yesu da erari ge karigaina. Edo embo awa namondekare daedo imapuma edo esisina, Badari Yesu deda, iji angode John mi embomai bapataito esisina edo gundo deguta ainde Yesu utuda kundo vivitara, ango awa bara.” ");
INSERT INTO bhg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ango tesiri awamanemi embo tote (2) avigesitera. Edo embo tote (2)da dao awa Joseph Barsabas (ainda dao nei awa Justus), edo Matthias de. ");
INSERT INTO bhg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Edo awamane benunu engo sitera, “Badari, inemi embo berarida do bé gido eta. Judas mi ito piari aimbari emboboda buro ari dero gun jindedo dodo betedo yai beyae niyao matawa aveira ainda mauntara. Awatedo, natokare yai arapada pieyo goré, embo indawa embo tote (2)da doda imo matu avigeteta awa Judas da dero baini.” ");
INSERT INTO bhg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ainda amboda, awamanemi ewowoda ganuma jipedo dodegedo garida tari isira awa ambo ambo esitera. Ango edo Matthias avigesitera. Awatedo, embo awa Yesu da piari aimbari embobo 11 ainde dada esisina. ");
INSERT INTO bhg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Edo Yesu da betari wasiride erari pura berari 7 ainda amboda, Judah embomainda bondo deguta dao Pentekos awa gupusina. Iji dá ainde Yesu gebé ari embomai berari kotembari da (1)mi yai dá ainda doregesitera. ");
INSERT INTO bhg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Edo burigibé yavi utuda edo gupeiri gositera, dá bisibubura tumbari goroba ango. Edo yavimi yai berari mando doda awamane anumbesitera ainda arapu esisina. ");
INSERT INTO bhg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ainda edo awamanemi rorae gositera. Niyao beriberida kariwa iwawa ango idegesisina. Edo rorae ami evekara eite maundo embo da da tujijisina. ");
INSERT INTO bhg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ango edo God mi Asisi Kotopu awamane berarida yai piesiri ami awamane gisijijisina. Edo Asisi Kotopu mi ari tao ari awamaneda yai pipisiuri awamanemi tuturo edo ge teka yai neneinda ami tedo douri tedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Iji dá ainde, Judah embomai, awamane awa God tou ari embomai, ami yai evekara butu berarida edo gundo Jerusalem doda isiretera. ");
INSERT INTO bhg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Iji angode yavi eiwa ingido gundo dada doregesitera. Edo aindabé embo da da awamaneda ge topobé ami tero ingido, awamane anana esitera. ");
INSERT INTO bhg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Edo awamane berarimi bé korebakore edo gido daredo ge mina tara esitera, “Giu! Embomai owa Galili embomai berari, ata ge embo neneinda ami tera! ");
INSERT INTO bhg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nongo nongo edo owamane ge tero kaena da da mi ingena berari awa ge bé kaenato topobé kaena engitera ge ami? ");
INSERT INTO bhg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Kaena nenei awa Patia embo, Medea embo, Elam embo, Mesopotamia embo, Judea embo, Kapadosia embo, Pontusi embo, Asia embo, Perijia embo, Pampilia embo, Kerisi embo, Arabia embo, edo Egypt embo. Kaena nenei awa yai Libia edo gumbera (Yai Libia ainda nasi Sairin demo ounda isima edo era). Edo kaena neneimi Rome nasi dodo gundo Jerusalem etega era. Kaenato Rome embo kupo da (1) awa Judah embo, edo kupo nei awa Judah embo ae. (Ata awamaneda gebé ari matu dodo Judah emboda God ambo ambo edo era). Awarata, kaena berarimi God da wasiri babainbé awa owamanemi ge kaenatomi karigetero ingera!” ");
INSERT INTO bhg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ango edo awamane berari bé korebakore eite edo ananabé eite akuta tedogari mina tara edo esitera, “Ro awa embo wasiri eiwa idegeteiri?” ");
INSERT INTO bhg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ata embo nenei Yesu gebé ari embomai awa tedojijireite sitera, “Owamane waini jiwaebé indera!” ");
INSERT INTO bhg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Edo iji angode Peter erido peposisina ae embobo 11 de daedo. Edo ainda ge yavi jiri erido bajinabé esiri embomi gotero tuturo edo ge sisina, “Judah embomainde imomane berari Jerusalem doda itewa awa daedo, dengoro edo, ge tain ena. Eiwa dave edo ingiwo! ");
INSERT INTO bhg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Iji einde sipo teka 9:00 eira. Awatedo, embomai eiwawa waini jiwaebé injido dutera, ango awa inemanemi kotemainyae. ");
INSERT INTO bhg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ango ae, arata, wasiri nakare boroko era, eiwa amboda gumaina awa, God mi peroveta Joel de embomainda yai tarate sisina awa karigesisina: ");
INSERT INTO bhg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Edo deguta beao eiari na buro ro ani awa eire. Na God ami nato Asisi awa embo berarida yai dodegana. Ango ano itomane mamai ae maingagara de nato bino karigara. Edo itomane maisinga banga garago girago​ ​awamaneda yai pirigano gara. Edo itomane embo begogo bagogo ano aturo ara. ");
INSERT INTO bhg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Edo daedo nato buro ari embo de eutu de deguta dá angode Asisi nato awamaneda yai dodegano nato ge karigara. ");
INSERT INTO bhg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nane wasiri babainbé utu ikaneda ano idegari gara. Edo kariwa nenei butu tuda piano gara. Awa ororo ae niyao de gara. Edo imbosimi dongowo dongowo ari gara. ");
INSERT INTO bhg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Edo iji awa wareregedo muyae ango ari, kariga wareregedo ororo ango aina, BADARI da deguta bajinabé bajina de kore ari taogari de gumbae gisida. ");
INSERT INTO bhg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Edo iji angode, embo aimi BADARI da daoda gebé eite benunu taina awa, God mi embo awa tonemaina.’ ");
INSERT INTO bhg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel embomai, ge eiwa ingiwo! Iji ainde Yesu Nasaret Embo itomane doda isite, God mi goroba ainda yai piesiri buro babain, wasiri babain, edo kariwa nenei edo eutara. Ango edo God mi itomane yai arapa euri gido eutara awa ami embo awa piesiri gupusina. Edo inemane akuta gewa awa gebé. ");
INSERT INTO bhg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Edo embo eiwa, God mi matu ango arate sirigesisina awa, itomane yai piesiri inemane embo awa kundo embobo ainda aodari gaeda ipada pietewo awamanemi oregada detero besitara. ");
INSERT INTO bhg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ata God mi embo awa betarida jiri erorara edo betarida memesi awa udegatara, aindabé betarimi imo jiari tao ae, awatedo. ");
INSERT INTO bhg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Edo iji matu David mi embo ainda ge site sisina, ‘Na iji berari BADARI namonde isira awa gido etena. Aindabé embo awa nato demobéda isima edo eira, awatedo, na adu ainyae. ");
INSERT INTO bhg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Awatedo, nato do yawa esira, edo na God dasiga etena. Edo gebé, na betari tao ena, awarata, na oena apeite God da yai tumonda ana. ");
INSERT INTO bhg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Aindabé, imo asisi nato bebetegarida sima ari yaida dowainyae, edo ito Embo Kotopu da tamo mana dowato depeka aina. ");
INSERT INTO bhg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Inemi wasirida begata nenei nato yai awa eteto arapa esisina. Aindabé imo namonde daedo itata, inemi ato na yawa bajinabé ana.’ ");
INSERT INTO bhg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Peter mi site sisina, “Nanonameji, nane ge arapada tano gawate jipapa ena awa, ewowo Daotari David betesiri ainda tamo banga toda pipisitera. Edo ainda banga to kaenamonde einda boroko matawa isira. ");
INSERT INTO bhg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Awatedo, kaena gotena, David ge ikaito awa tae. Ata ami peroveta eite gosisina awa, God tarigari okain pipisisina awa, David da tamoda ve Keriso jiari erido ainda daotarida anumba baina. ");
INSERT INTO bhg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Edo David mi wasiri eiwa idegaina awa gosisina. Awatedo, Keriso da betedo erarida ge ango sisina, God mi ainda asisi bebetegarida sima ari yaida dowae, edo ainda tamo depeka ae. ");
INSERT INTO bhg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Edo Yesu eiwa God mi wasiride jiri eriri nakare berari jisimi gotara. ");
INSERT INTO bhg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Awatedo, God mi Yesu jiri ikanebé ainda ipabeda vivitara. Edo Mamo mi Asisi Kotopu piain tarigarida sisina awa Yesu de piesiri bira. Edo Yesu mi Asisi Kotopu eiwa dodegesiri wotesiri imomane boroko goteite ingewa. ");
INSERT INTO bhg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Aindabé David mi utuda vitae, ata ine akuta ge eiwa sisina, ‘BADARI mi nato Badari de sisina, “Ipabe natoda anumbedo namonde daedo embomai berari gisijiyo! ");
INSERT INTO bhg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ango eiato nane ito gitopo embo ito tai tuda piano imo tou ore.” ’ ");
INSERT INTO bhg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Awatedo, Israel embomai berari, bé gidogogo ewo! Yesu eiwa inemane oregada dorawa, God mi eutara awa Badari edo daedo Keriso.” ");
INSERT INTO bhg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Edo embomai ge eiwa ingido do memesi bajinabé budo Peter ae Yesu da piari aimbari embo neneinde tedogositera, “Nanonameji, nakare nongo nongo ari?” ");
INSERT INTO bhg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ango edo Peter mi awamanede ge mina tedo sisina, “Imomane da da, itomane jimbo bebegae dodo God da yai wareregewo, edo nanekare imomane Yesu Keriso da daoda bapataito aro God itomane jimbo kotembedo dowari itae aina. Daedo, God mi ainda kando, Asisi Kotopu, imondemane piari kumbawa. ");
INSERT INTO bhg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Badari kaenato God mi tarigari sisina, embomai berari awa ami dao tari ainda embomai orote, ainda Asisi Kotopu awamaneda yai piaina. Edo awamaneda doda awa imomane ae itomane mamai de edo owamane yai aikeda itari awa daedo.” ");
INSERT INTO bhg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Edo Peter mi awamanede dengoro baiari pipiteite dedegari ge okain tedo edo kondade ari ge tenda tenda tedo esisina, “Tonembari itomane akutada kumbuwo, aindabé, embo bebegae boroko einda itera awamaneda rirowa awa kumbovekae!” ");
INSERT INTO bhg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ango edo embomai owa ainkaimi Peter da ge dubodavede buritera awa, awamanemi bapataito esitera. Edo deguta dá ainde, embomai ajijigari tega 3,000 ango God mi ainda gebé ari embomainda yai dada esisina. ");
INSERT INTO bhg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Edo awamane iji matawa dada edo Yesu da piari aimbari emboboda atopatari ingido, umojido, bread engegegedo, God da yai benunu tedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ango edo Yesu da piari aimbari embobo God da gorobami wasiri babain edo kariwa jiwae edo ero gido embomai berari God tou edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Edo God da gebé ari embomai doregedo awamaneda roviravi berari mina piya mana piya edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Iji angode awamaneda butu edo roviravi nenei orieiworo ainda ganu mina budo beji itari embo berari da da awamaneda doregarida ainda inono piedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Edo deguta da (1) dowae awamane kotembari da (1)mi matawa Judah embomainda oro kotopu bajinada dada eite, edo bread engegeteite awamaneda mando da da ainda indari yawa ari de tataimbari demi injido, ");
INSERT INTO bhg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","God dasiga eiworo awamaneda dave ari embo berarida yai arapu edo esisina. Edo deguta da (1) dowae Badari embo nenei tonembedo awamane Yesu gebé ari embomainda doregarida awa pipisiuri bajido esisina. ");
INSERT INTO bhg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Deguta da (1)de Peter ae John de Judah embomainda oro kotopu bajinada, 3:00 turode benunu tari iji bureiri visido aunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Edo embo da (1) baoro bundari aida sinida wotari isinesina. Edo ainda embototopomi embo awa bundedo oro kotopu guwa be dao ‘Guwa Be Dariga’ ainda kundo aunsitera. Awamane deguta da (1) dowae embo awa yai ainda pioro isite embo oro kotopuda aundo totoreiworo ganu atega ain einesina. ");
INSERT INTO bhg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Iji ainde embo ami Peter ae John de oro kotopuda torain ero gido awamanede ganu atega edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ango esiri Peter ae John de embo awa jisi piedo gositera, edo Peter mi embo ainde, “Nakare gi!” sisina. ");
INSERT INTO bhg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Edo embo awa embo tote (2) awa gosite imo kotembesisina awa rorae da (1) ro piaro baina awa tumonda esisina. ");
INSERT INTO bhg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Edo Peter mi ainde sisina, “Ganu nato yai itae, ata nato yai ro isiri awa imonde piano bata. Yesu Keriso Nasaret Embo da daoda, erido pepeta eyo!” ");
INSERT INTO bhg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ango edo embo awa ipabeda jiri erorisina, edo burigibé ainda tai ae tai akoma deda goroba burisina. ");
INSERT INTO bhg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Edo embo awa kekapunya eite ainda taimi erido ainto edo imapuma eiri jiriri, awamanede daedo oro kotopuda torido pepeta eite edo kekapunya eite edo God dasiga eite aunsisina. ");
INSERT INTO bhg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Edo embomai berarimi embo awa ainto eite God dasiga eiri gido, ");
INSERT INTO bhg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","awamanemi embo awa kariwa gositera, awa embo da (1) dá awa Judah embomainda oro kotopu bajinada ‘Guwa Be Dariga’ da anumbedo atega edo esisina. Awa gido awamane korebakore edo ari bajina ainda yai bé ro idegesiri awa gain daritera. ");
INSERT INTO bhg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Edo baoro bundari embo matu kaviyegesira ami Peter ae John deda yai jido isiri embomai berari awa kore bajinabé edo awamaneda yai ainto tumundo yai dao ‘Solomon da Boriri’ da guputera. ");
INSERT INTO bhg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ango edo Peter eiwa gido ami awamanede sisina, “Israel embomai, ro awa embo ari bajina emi imomane eiri korebé evi? Edo ro awa embo jisi itomane natokare yai evi? Imomane kotembetewa natokare gorobami o wasiri kokopi arimi etero embo eiwa ainto eiri? Ango kotembeove! ");
INSERT INTO bhg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham ae Isaac de Jacob deda God, kaenato ewowo gawowoda God, ami ainda Buro Embo Yesu da taogari awa arapada esira. Inemane embo awa Pilate da ipada daro betarate pipitawa. Inemane Pilate da jisida embo awa ajiregatawa bé ami katedo dowari aimbarate tedo eiri. ");
INSERT INTO bhg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yesu ainda wasiri God da yai pipisisina edo God da jipapa ambo ambo evina. Ata inemanemi embo awa ajiregedo dari betari embo baintedo benunu siutawa. ");
INSERT INTO bhg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Inemanemi Wasiri Natopo Itarida Tutu awa detewo besitara, ata God mi betarida awa jiri wasiride erorara. Nakare tote (2)mi awa gotara edo eiwa karigetera. ");
INSERT INTO bhg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Edo natokare gebé ari Yesu da yai ami embo eiwa imomane goteite gido ewa awa esiri goroba ari bira. Yesu da goroba edo gebé ari awa Yesu da yai edo gumbira, ami esiri embo kaviyegaribé eiwa bira, imomane berarida dombuda. ");
INSERT INTO bhg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Awara, nato nanonameji, na gotena awa, imomane iwata eiwa awa gae arapa aeda awa eiawa, dá ango itomane gisijijiegari eiara. ");
INSERT INTO bhg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ata eiwawa ro aina, God ainda geda tari, awa bé eiara. Matubé ainda peroveta mane berari awamanede ge sisina ango, ainda Keriso awa memesi baina. ");
INSERT INTO bhg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Awatedo, jimbo bebegae dodo bé wareregewo God da yai. Ango awo itomane jimbo awa kotembedo dowari itae are. Edo ango awo Badari mi iji tegerida oena apari beyamanabé itomane asisida ainda piari bave, ");
INSERT INTO bhg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","edo iji nei ami Yesu Keriso piari butuda gumaina. Embo awa God mi imomane embo matu avigesisina. ");
INSERT INTO bhg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Edo embo awa matawa utuda edo gumbae isiari iji awa aundo God mi roviravi berari awa tekago ari teteka aina. Edo iji matubé God mi ge awa ainda peroveta kokotopude sisina. Ainda amboda awamane berarimi awa embomainde karigesitera. ");
INSERT INTO bhg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ge eiwa Moses mi kaenato ewowo gawowode sisina, ‘BADARI, itomane God mi, Peroveta dá na ango awa itomane nanonamejida yai edo imomane embo jiari eraina. Edo itomane yai ge berari ro tain eira awa dave edo ingiwo! ");
INSERT INTO bhg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Edo embo aimi Peroveta da ge kera ae awa, God mi embo awa ainda emboboda yaida awa kundo kautugedo usibesi aina.’ ");
INSERT INTO bhg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ge bé, eiwa ari ro peroveta berari Samuel da ijide ami gumaina sitera. Edo ainda amboda peroveta jiwae nenei edo gundo awamanemi daedo idegaina sitera. Edo ari eiwawa iji boroko bé esira. ");
INSERT INTO bhg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Peroveta maneda tarigari awa itomane, edo piari tembari okain God kaenato ewowo gawowode esisina awa itomane. God ge ango site iji ainde ami Abraham de sisina, ‘Edo ito veda ainda edo orobe berari butuda awa ao ari bara.’ ");
INSERT INTO bhg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Edo God mi ainda Buro Embo Yesu awa jiri eriri itomane yai gisi pipitara imomane ao arate. Awatedo, ainda jipapa awa imomane da da itomane ari bebegaeda awa ami kundo wareregaina.” ");
INSERT INTO bhg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Iji angode, Peter ae John de matawa embomainde ge site itero pirisi mane ae oro kotopuda sima ari emboboda gisijiari bajina de, Sadusi mane de awamaneda yai guputera. ");
INSERT INTO bhg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Aindabé, embo tote (2)mi Yesu betedo erorarada ge ango atopaposite karigesitera, awamanemi dumo bajina eite guputera. ");
INSERT INTO bhg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ango edo awamanemi embo tote (2) jido kundo maundo bundari oroda pipisitera. Aindabé muyae matu gumbira, awa embo audo ge katara. ");
INSERT INTO bhg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Awarata, embomai jiwae ge awa ingido awamaneda gebé ari Yesu da yai pipisitera. Edo embomai berarida ajijigari avekavemi Yesu gebé esitera, awa bajido 5,000 ango esisina. ");
INSERT INTO bhg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Sipo neinde, Judah embomainda gisijijiegari de, orobeda kopuru mamai de, Aodarida atopapasigari de Jerusalem da guputera. Edo Annas, pirisida gisijiari bajina de, Caiaphas de, John neinde, Alexander de, edo embo nenei pirisida gisijiari bajinada orobeda ami daedo gundo doregesitera. ");
INSERT INTO bhg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ainda amboda awamanemi Peter ae John de kundo gundo doregari doda pietero pepositera. Edo embo tote (2)de tedogositera, “Imomane goroba anda jigamo etevi, o daobé anda jigamo edo ari bajina eiwa etevi?” ");
INSERT INTO bhg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Edo Peter Asisi Kotopu mi gisijijisina, edo ami awamanede tedo sisina, “Embomainda gisijijiegari ae Israel orobeda kopuru mamai de! ");
INSERT INTO bhg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Deguta boroko emi inemanemi namondekare ge tedogotewa, aindabé, nanekaremi embo siwari kondade etera, edo nongo edo embo awa kaviyegesiri tedogewa. ");
INSERT INTO bhg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Awatedo, imomane berari giwo, edo Israel embomai berari nenei daedo gara! Embo petesira isira eiwa davebé esira, aindabé, Yesu Keriso Nasaret Embo da daoda gao etero kaviyegesira. Inemanemi Yesu oregada detewo besitara, ata God mi embo awa jiri erorara. ");
INSERT INTO bhg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu awa da bé awawa, ango God da Geda gaiedo tari isira, ‘Dasivi awa imomane oromando ari embomi ajiregesitewa, God mi esiri dasivi davebé dave esira.’ ");
INSERT INTO bhg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Imo akuta God mi butuda piesiri gupusina kaena tonembarate, awatedo, imo akuta ami kaena tonemaina.” ");
INSERT INTO bhg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ango edo awamanemi Peter ae John deda do jinenegari awa gositera. Edo embo tote (2) awa ginuma gae edo embo tepo, ango gero arapada esiri korebé esitera. Edo awamanemi embo tote (2) awa ae Yesu de imapuma eite gari buritera ango gositera. ");
INSERT INTO bhg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Edo iji angode awamane jisimi embo awa kaviyegedo Peter ae John de daedo petedo isiri gositera, awatedo, awamanemi embo tote (2)de bekumba ari tao ae esitera. ");
INSERT INTO bhg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ango etero gido gisijijiegarimi Peter ae John de embo kaviyegesira ainde ge tetero awamanemi Sanhedrin da yai dodo arapada idegedo sima saka esitera. Edo katari embobomi akuta ge mina tara edo gositera. ");
INSERT INTO bhg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Kaenanemi embo tote (2) einde rirowa da ji piari tao ae!” tedo sitera. “Embomai berari Jerusalem doda itari, awamanemi arapada gari, embo tote (2)mi awa burobé bajinabé eiwa etera. Awa embo, kaena ge eve mana tana! ");
INSERT INTO bhg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Awarata, bino eiwa embomai neneinda yai arapu mambae gisida, kaenanemi edo gido embo tote (2) tekago embo einda daoda embo neinde ge tara awa, awamane vedana tano gara.” ");
INSERT INTO bhg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ango edo embo tote (2) dao awa tetero gido katari yaida tekago totoritera. Ainda amboda awamanemi embo tote (2)de ge okain sitera, “Imomane Yesu da daoda ge tekago da ji teove edo ainda daoda atopatove!” ");
INSERT INTO bhg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Atako Peter ae John demi awamanede mina sitera, “Imomane akuta katewo! Dave God da jisida awa nanekaremi imomane tou arita ko God tou ari? ");
INSERT INTO bhg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ata natokare kotembari awa nanekare tote (2)mi Yesu da buro ro bé jisimi gositera awa edo ro dengoromi ingitera awa tari dowainyae.” ");
INSERT INTO bhg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ango edo ge babain katari embobomi tarigari ge okain tekago embo tote (2)de pisido awamane udegesitera. Aindabé, embomai berarimi ari bajina awa gido God dasiga edo esitera, nongo nongo edo embo tote (2)de rirowa piae eteri awa tambae tambae edo doturitera. ");
INSERT INTO bhg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Aindabé, embo matu baoro bundari ango isite duberi 40 daginegari, awatedo, embomai berari gositera awa, God mi akuta Peter ae John de kondade esiri gao etero embo eiwa kaviyegesisina. ");
INSERT INTO bhg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Edo awamaneda udegari budo Peter ae John de gebé ari embomainda yai maunsitera. Edo pirisi babain ae orobeda kopuru mamai demi ge ro berari awamanede siteri awa tetero ingitera. ");
INSERT INTO bhg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iji angode ge eiwa ingido awamane berari kotembari da (1) edo ge yavi bajina jiero eriri God da yai benunu sitera, “Badari, imo awa God. Inemi utu de butu de ewa de roviravi berari de awa esiteta. ");
INSERT INTO bhg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Inemi ito buro embo David gisijijieto ainda bemi ge engo sisina: ‘Embobo yai neneinda ami sinigambari tepo etero, edo Judah embomai daedo ge jirari moka itae God da yai etera. ");
INSERT INTO bhg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Daotegeregari butuda ami sinigambaride petetero, edo gisijijiegari nenei daedo dada doregetera, BADARI edo ainda Keriso jipapa ae orote.’ ");
INSERT INTO bhg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Awa gebé, Daotari Herod ae Pontius Pilate de awa, ae yai nei embomai de Israel embomai demi doregatara. Awamanemi kotembari bebegae sirigatara nongo nongo edo ito Buro Embo kotopu Yesu, ainde sinigambari orote. Edo embo awawa inemi bimbegedo avigesiteta. ");
INSERT INTO bhg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Aindabé imo awa goroba berari, buro ro awamanemi etero idegatara awa ito jipapa akuta ine matu sirigesiteta. ");
INSERT INTO bhg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Awatedo, Badari, borokobé owamaneda duduno ge natokare yai tera awa giwasi! Edo ito buro ari embobo awa kondade ewasi, nakare inono adu ainyae do jinenegedo ito ge karigore. ");
INSERT INTO bhg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iji dá einde, ito ipa goroba ududugedo embomai gao edo, kariwa jiwae edo wasiri babain ata, ito Buro Embo kotopu Yesu da dao ami.” ");
INSERT INTO bhg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Awamane benunu tedo itae etero, ainda amboda, yai awamane dada esitera awa jipisina. Edo awamane berari awa Asisi Kotopu mi gisijiri adu ari itae God da ge karigedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Edo embo jisi da God gebé esitera ami do da (1) eite kotembari da (1)de ango isima edo esitera. Embo da aimi ainda rorae topo tainyae, ata awamaneda yai ro isiri awa, berari mina piya mana piya edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Edo Yesu da piari aimbari embobomi Badari Yesu da erari ge awa goroba bajina ami karigedo esitera. Edo God da ao ari bajina awamaneda yai isima edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Edo butu tutu ko oromando tutu berari isima edo esitera ami awamaneda topobé ori eite ainda ganu mina budo kundo gundo Yesu da piari aimbari emboboda taida piedo esitera, rorae itae embomai awa embo. Ango eoro Yesu da piari aimbari embobomi rorae itae embo da da, da yai tega inono piedo esitera. Awatedo, embo da aimi rorae kakowa ae. ");
INSERT INTO bhg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iji dá ainde embo dao Joses isinesina. Yesu da piari aimbari embobomi dao nei, Barnabas, ainde pipisitera (Daoda mokabé awa imo awa Kondade Ari Emboda Mai). Edo embo awa Levi da ewowoda edo gumbari, edo ainda engari yai awa Saipurasi gategada. ");
INSERT INTO bhg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Edo embo ami ainda butu topo embo neinde pisido ainda ganu mina budo kundo gundo Yesu da piari aimbari emboboda taida pipisisina. ");
INSERT INTO bhg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ata embo da (1) dao Ananias, edo ainda aro Sapphira de, awamaneda butu awa embode piedo ganu buritera. ");
INSERT INTO bhg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ango edo ganu budo katambedo kupo nei awa jijieite edo kupo nei awa ainda aro daedo goteiri kundo gundo Yesu da piari aimbari emboboda taida pipisisina. ");
INSERT INTO bhg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ata Peter mi sisina, “Ananias, nongaintedo Satan mi ito doda torido gisijiri Asisi Kotopu de ge pitawa tedo butuda ganu kupo nei awa imo embo jiesi? ");
INSERT INTO bhg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Butu piae gisida, butu awawa ito topobé rita? Gebé, butu awawa ito topobé. Edo ainda amboda awa embode piedo ganu awa beta, ganu ikaito awawa sima ae etesita? Gebé, ganu ikaito sima ae eteta. Ro awa embo ito doda kotembari beyae eiwa sirigetesi? Inemi embo enemboda yai akuta ge pitawa tae, atako God da yai daedo teteta.” ");
INSERT INTO bhg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Edo Ananias ge awa ingite butuda durudo besisina. Edo singabangami ainda tamo gongomi doiedo kundo idegedo ainda goiari yaida pipisitera. Ango etero embomai ainkaimi bino awa ingero adu bajinabé esitera. ");
INSERT INTO bhg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ainda amboda, ora tamonde (3) itae esiri embo ainda aro totorisina. Edo iwata ro idegesiri, awa gae. ");
INSERT INTO bhg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Edo Peter mi ainde tedogosisina, “Teyo gane! Inemane itomane butu embode piedo ganu mina tega engo bevita?” “Gebé,” ami sisina, “ganu mina tega dá awara.” ");
INSERT INTO bhg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peter mi eutu ainde sisina, “Ro awa embo imomane kotembari dá angomi Badari da Asisi bavedogain ge katetevi? Giyo! Embobo ito iu awa matu goietera ami gupera. Awamaneda tai yavi manguro beda goteta, edo awamane imo daedo kundo idegedo mambara.” ");
INSERT INTO bhg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Edo burigibé eutu awa butuda durudo ainda taida besisina. Ango esiri singabanga torido gundo eutu betari awa gositera. Ango edo awamanemi eutu awa kundo idegedo maundo goitera, ainda iuda demonda. ");
INSERT INTO bhg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Awatedo, Yesu gebé ari embomainda doregari berarimi adu bajinabé esitera, edo embomai ainkain berarimi bino awa goteite daedo. ");
INSERT INTO bhg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Edo Yesu da piari aimbari embobomi kariwa ae wasiri babain de jiwae embomainda yai edo esitera. Daedo, gebé ari embomai berari kotembari da (1)mi Solomon da Boriri da dada edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Awarata, gebé ae ari embomaimi gebé ari embomainda doregari gido dobibi eite awamanede umojiae, ata awamane tou bajinabé edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ata embo de eutu de neneimi Badari gebé eite awamaneda yai jiwaebé gundo dada edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ango edo embomaimi awamaneda karu egeregari kundo gundo begata beda besida edo kakateda pisido esitera awa, Peter pepeta eiari tepoko ainda dugami awamane nenei tujiarate. ");
INSERT INTO bhg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dá ango embo jisijisi nasi demodamodami Jerusalem da dada eite awamaneda karu embo de embo asisi bebegaeda bundari de kundo gumboro berari kaviyegedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Edo pirisida gisijiari bajina erido ainda buro otatawo Sadusi mane daedo jitedo sinigambari bajinabé esitera. ");
INSERT INTO bhg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ango edo awamanemi Yesu da piari aimbari embobo jido nasida bundari oroda kundo maundo pipisitera ");
INSERT INTO bhg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ata muyae ainde, Badari da anelami bundari oroda manguro pipiregedo awamane kundo arapada idegedo awamanede ge sisina, ");
INSERT INTO bhg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mambuwo! Judah embomainda oro kotopu bajinada do arapada maundo petedo embomainde nongo nongo edo God mi awamaneda yai wasiri natopo itari piari borote ge berari eiwa tawo gore!” ");
INSERT INTO bhg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ango tesiri ingido, sipobéde, awamane oro kotopu bajinada torido embomainde atopatari tuturo esitera. Ata pirisida gisijiari bajina ae ainda buro otatawo de gundo dada esitera. Ango edo Sanhedrin edo Israel embomainda orobeda kopuru mamai berari daedo, gumborote dao sitera. Ainda amboda oro kotopuda sima ari embobo pietero bundari oroda maunsitera, piari aimbari embobo kundo gumborote site. ");
INSERT INTO bhg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ata iji angode sima ari embobo bundari oroda maundo awamane tambae esitera. Ango edo overegedo gundo tetero gositera. ");
INSERT INTO bhg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Imondemane gebé tera! Nanekare bundari oro awa bé engiregedogogo bé ari tambera. Edo bundari oro sima ari embobo awa manguro beraribéda petari itero gera. Ata nakare manguro pirigetera, edo embo doda da ji tambae!” ");
INSERT INTO bhg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ango edo iji angode ge eiwa ingido, pirisida gisijiari bajina ae oro kotopuda gisijiari bajina de pirisi babain de awamanemi anana eite kotembesitera, “Einda amboda ro gumaini?” ");
INSERT INTO bhg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Edo embo neimi gundo awamanede sisina, “Giwo! Embobo avekave inemane bundari oroda pipitawa, awamane oro kotopu bajinada doda petetera, edo embomai atopapotera.” ");
INSERT INTO bhg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ainda amboda, oro kotopuda gisijiari ae sima ari embobo de adu esitera, embomai demonda ami ganumami augedo deorekae. Awatedo, awamane aundo piari aimbari embobo kundo guputera, ikanade ikanade ae. ");
INSERT INTO bhg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Edo kundo gundo Sanhedrin da doda pietero pepositera. Etero gido pirisida gisijiari bajinami awamanede ge eiwa sisina. ");
INSERT INTO bhg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nanekare imondemane aodari okain pipitara awa, embo einda daoda atopatainyae!” ami sisina. “Awarata, inemane atopatari emimi embomai atopatewo Jerusalem da umbugo berarida arapu esira, edo embo einda betarida ororo ami nakare bekumba ain ewa!” ");
INSERT INTO bhg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ango edo Peter ae Yesu da piari aimbari embo nenei demi awamanede mina sitera, “Nakare God da aodari kera ara. Edo embomi ge evekara taro gido nakare awamane kera ainyae. ");
INSERT INTO bhg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mamono kaenatoda God mi Yesu, inemane detewo oregada besitara awa, jiri erorara. ");
INSERT INTO bhg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Aindabé, embo ami Israel embomainda do ainda yai jiari wareregara, edo awamaneda jimbo bebegae dowaro ainda kotembedo dowari awamaneda yai piarate, awatedo, God mi imo awa jiri ikanebé visido ainda ipabeda anumbada anumbatara, Daotari da Mai edo Toregari Embo arate. ");
INSERT INTO bhg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Edo nanekare iwata eiwa Yesu da yai edo idegatara awa embomainde karigedo era, edo God da Asisi Kotopu daedo ami ge eiwa gebé embomainde karigedo eira. God mi ainda Asisi awa, embomai imo kera edo era, awamaneda yai pipitara.” ");
INSERT INTO bhg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Iji angode Sanhedrin mi ge eiwa ingido sinigambari beyaebé esitera, edo awamane daro betorote jipapa esitera. ");
INSERT INTO bhg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ata doregari ainda doda, embo da (1), ainda dao Gamaliel, ami erido peposisina. Embo awa Parasi maneda embo da (1) edo Aodarida atopatari. Imo awa embomai berarimi tou eora. Edo ami ge okain tedo Yesu da piari aimbari embobo awa piaro idegedo aundo arapada sima saka orote sisina. ");
INSERT INTO bhg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ango edo katari emboboda yai ge sisina: “Israel embomai, gidogogo ewo, inemane embobo einde ro ain kotembetewa awa. ");
INSERT INTO bhg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Aindabé, duberi indewae gisida, embo da (1), ainda dao Theudas, erido sisina, ‘Na awa embo dariga!’ edo embobo ajijigari 400 ango embo ainde dada esitera. Ata embo awa detero besisina, edo embobo ainkain imo kera eiretera, awa bodembetero bé itae esisina. ");
INSERT INTO bhg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ainda amboda, Rome da dao ajijigari iji ainde, Judas yai Galili embo erido embomai jiwae gisijido kundo maunsisina. Ata embo awa daedo detero betesiri ainda kera ari embomai evekara esitera. ");
INSERT INTO bhg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Awatedo, nanemi imondemane tena, embobo eiwamaneda yai iove edo dowo aimbore! Aindabé, edo kotembari ko wasiri eiwa awa embo enemboda yai edo gupeira gido, awa wotedo itae aina. ");
INSERT INTO bhg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ata wasiri eiwa God da yai edo gupeira gido, inemane engiregari tao ae. Edo engiregain jipapa ewa, awa giwo! Imomane sinigambarimi God da yai duduno ae etewa, awa gawate.” ");
INSERT INTO bhg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Edo ainda ge ingido awara esitera. Edo Yesu da piari aimbari embobo tetero torero vededo ge okain awamanede sitera, “Yesu da daoda ge nei tekago tainyae!” Ango tedo awamane dotero maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aindabé, Yesu awa embo vedari edo mengari buritera, awamane gebé ero God mi ainda tou ari awamaneda yai pipisisina. Awatedo, awamane yawa eite Sanhedrin da yai dodo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Edo deguta da (1) dowae, awamanemi Judah embomainda oro kotopu bajinada edo mando da da, ainda bino dave atopasido karigedo esitera, “Yesu awa Keriso.” ");
INSERT INTO bhg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Edo deguta neneinda amboda, ambodanida ajigari visido babojisina. Edo ambodanida doregari bajina doda Guriki Judah embomai ae Hiburu Judah embomai de isiretera. Ango edo iji ainde, Guriki Judah embomaimi gositera, Hiburu Judah embomaimi kondade ari inono ae deguta tegerida awamaneda Guriki eutu rorida yai piedo esitera. Awatedo, awamanemi ge guguma gaguma Hiburu Judah embomainda yai sitera. ");
INSERT INTO bhg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ango etero embobo 12 ami ambodanida doregari bajina dao tetero gundo doregetero sitera, “Nakare God da ge tari dodo embomainda buro sima ari embo ara, awa natokare yai dave ae. ");
INSERT INTO bhg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Awatedo nanonameji, itomane yaida embobo ajigari 7 engo kakowa edo tambuwo! Embobo ango kaena gido era awa, Asisi Kotopu da gisijiarimi isima edo era, edo dubogari de. Nanekaremi awamaneda yai awara ari piaro buro eiwa gisijiara. ");
INSERT INTO bhg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Edo nanekare akuta iji matawa benunu tari buro edo God da ge tari buro sima edo ara.” ");
INSERT INTO bhg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ge engo eiwa embobo doregesitera berari ingido dubodave esitera. Awatedo awamanemi Stephen avigesitera (embo ainda gebé ari God da yai okain bé pieuri Asisi Kotopu mi awa gisijido esisina), edo Philip, Prochorus, Nicanor, Timon, Parmenas, edo Nicolas. Nicolas awa Enteoki embo ata Judah embo ae. Ami ainda gebé ari matu dodo Judah embomainda God ambo ambo edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ango edo awamane kundo gundo Yesu da piari aimbari emboboda yai pipisitera. Edo Yesu da piari aimbari embobomi awamane embo God de benunu tedo ipa tamonda pisido ao esitera. ");
INSERT INTO bhg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ango etero God da ge simundo arapu eiri ambodanida ajijigari Jerusalem doda ikanebé viviteiri edo pirisi mane jisijisi God da ge kera edo gebé edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Edo Stephen mi ainda gebé ari God da yai okain bé pieuri, God mi goroba bajinabé ainda yai pieuri ami wasiri babain edo kariwa babain embomainda doda edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Awarata, embo nenei Stephen da ge jinjitera. Awamane Judah embomainda benunu oro dao Udegari Embobo ainda edo guputera. Edo ainda embomai awa nasi Sairin edo Alexanderia, daedo yai Silisia edo Asia da edo gumbari. Edo awamanemi Stephen de tuturo edo ge baitera. ");
INSERT INTO bhg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ata Stephen da yai Asisi Kotopu mi dubogari piesiri embo awa ge tedo eiri awamane embo awa daginegari tao ae edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ainda edo awamanemi temada embo neneinda do budo ge torote sitera, “Nakare Stephen mi ge siri ingitara awa, sinigambari eite Moses ae God de ge bebegae siutara.” ");
INSERT INTO bhg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Edo awamanemi embomai ae orobeda kopuru mamai de, Aodarida atopapasigari de, ao gaietero erido Stephen da yai gundo, embo awa tanjido kundo Sanhedrin da yai aunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","14","Edo awamane daedo ge pitawa tari embobo pietero petedo awamanemi site sitera, “Nanekare embo ami ge siri ingitara awa, Yesu Nasaret embo emi oro kotopu bajina eiwa dedo sitaina, edo Moses da tari matu kaenamonde pipisisina ambo ambo edo era awa, kundo wareregaina. Awatedo, embo emi ge bebegae yai einde Moses da Aodari de awa dowae matawa tedo eira.” ");
INSERT INTO bhg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Edo tetero gido Sanhedrin anumbetera itera berari ami jisimi jijimbeteite embo ainda dombu awa anelada inge gositera. ");
INSERT INTO bhg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ango edo pirisida gisijiari bajinami Stephen de tedogosisina, “Ge eiwa gebé rita?” ");
INSERT INTO bhg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Edo Stephen mi mina sisina, “Nanonameji ae mamono de, ge eiwa ingiwo! God taogari de parara bajina de ami mamo kaenato Abraham da yai idegesisina, iji angode ami yai Mesopotamia isima edo esisina, edo nasi Haran ainda itae gisida. ");
INSERT INTO bhg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Edo God mi Abraham de ge engo sisina, ‘Butu ito de orobe ito de dodo idegeyo! Ango edo gumbato butuda nane piano gate.’ ");
INSERT INTO bhg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Ango tesiri imo Kelezia embomaida butu dodo gundo Haran ainda isinesina. Ainda amboda Abraham da mamo betesiri God mi Abraham esiri gigi tembedo gupusina, butu imomane boroko itewa einda. ");
INSERT INTO bhg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Edo iji angode, God mi ainde butu potarate piae, edo butu tano sakabé da ji piae. Ata iji ainde, Abraham mai itae tepo isiri, God mi ainde tarigari sisina, embo ainde edo ainda veda edo gumbari de, butu eiwa topobé piari borote. ");
INSERT INTO bhg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Awarata, God da ge awa engo: ainda veda edo gumbari ami yai evekarada itara. Edo yai eveda embobomi awamane bundedo duberi 400 ainda doda buro okain bé awamaneda yai tepotapo piara. ");
INSERT INTO bhg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ata God mi daedo sisina, ‘Ainda amboda, nanemi yai eve embobo aimi awamane bundara awamaneda yai rirowa piana. Ango edo ito mamai yai owa dodo gundo yai einda na tumondebain ara.’ ");
INSERT INTO bhg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ango edo God mi Abraham de tamo jiugari da piari tembari okain pipisisina. Awatedo, Isaac da engari ainda amboda, deguta 8 awa biri Abraham mi ainda tamo jiugesisina. Edo Isaac da mai awa Jacob, edo Jacob da mamai awa Israel embomainda ewowo 12. ");
INSERT INTO bhg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Edo Israel da ewowomi awamaneda nameji Joseph jitedo embo neinde piedo mina buritera. Ango etero awamanemi embo awa kundo Egypt maunsitera. Ata God awa embo ainde daedo isima edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Awatedo, embo awa ainda memesi babain berarida edo tonembesisina. Edo God mi dave ari de dubogari de embo ainde pipisisina, Pharaoh, Egypt da daotarida dombuda. Ango esiri Pharaoh mi imo Egypt embomainda gisijiari avigesisina, edo ainda mando topo berarida sima ari daedo. ");
INSERT INTO bhg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Edo ainda amboda, beji iji Egypt ae Kanan deda yai berari idegesisina, ami awa beji ambari bajinabé kundo gupusina. Edo ewowo kaenato indari kakowa edo tambae esitera. ");
INSERT INTO bhg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ata iji ainde Jacob Egypt ainda tambara itari bino ingisina, awa embo, ainda mamai, kaenato ewowo, piesiri aunsitera, awamaneda etega tuturoda. ");
INSERT INTO bhg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ango edo awamaneda etega tenda iji tote (2) ainde awa Joseph imo akuta ainda nanonamejida yai karigesisina. Edo iji ainde Joseph da orobe awa Pharaoh mi gosisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ainda amboda awa Joseph ge piesiri maunsisina, ainda mamo Jacob ae ainda orobe berari deda yai. Awamane berari 75 awa gumborote tesiri gositera. ");
INSERT INTO bhg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Awatedo, Jacob ae orobe de erido Egypt ainda maundo isiretera. Edo Jacob betesiri ainda amboda, kaenato ewowo gawowo daedo besitera. ");
INSERT INTO bhg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Edo awamaneda tamo awa kundo maundo Shechem nasida goiari yaida goitera. Yai awa Abraham mi Hamor da mamainda yai ganumi oriesisina. Edo Hamor awa Shechem da mamo. ");
INSERT INTO bhg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Awarata, iji awa atutumbesiri God da tarigari ami kaenato embomai toregain Abraham de matu sisina awa, kaenato embomai jiwaebé jiwae Egypt doda idegedo siputera. ");
INSERT INTO bhg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ainda edo Egypt da daotari teka erorisina. Embo awa Joseph da aribari gisi gae. ");
INSERT INTO bhg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Daotari emi apiye ewowo kaenato awa udumbedo memesi okain awamaneda yai piedo esisina. Daedo ami awamane jijinetedo awamaneda mamai teka engari awa arapada pisido dowaro betorote sisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Iji angode Moses awa engisina, mai awa duroka edo davebé God da yai. Edo mai awa kariga tamonde (3) awa ainda aimamoda mandoda isiri ai mi unjisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ata ainda amboda, awamane imo kundo maundo arapada pietero Pharaoh da gagarami tamundo kundo maundo ainda engari mainbé ango sima esiri babojisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Edo Moses awa Egypt da atopapasigarimi awamaneda jirogari berari atopapositera. Edo embo awa babojisina, ainda ge tari ae iwata ari de awa gorobabé edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ango edo, Moses duberi 40 esisina angode awa, Israel embomai, ainda nanonameji, etega ain kotembesisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Edo imo maundo Israel embo da (1) awa Egypt embomi kundo usibesi eiri gosisina. Ango edo awa Israel embo awa kondade edo Egypt embo awa desiri besisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses mi kotembesisina awa, ainda Israel nanonameji garo arapa aina awa, God embo awa jigamo edo embomai toregaina. Ata awamanemi awa gae arapa ae esitera. ");
INSERT INTO bhg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ango edo sipo neinde Moses gundo Israel embo tote (2) duduno ero tapusina. Edo embo tote (2) toregeteite béga borote sisina, ‘Imo aedade ane orobera, ro awatedo wasiri beyae engo evi?’ ");
INSERT INTO bhg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ata embo da (1)mi embo nei awa kundo usibesi esisina, ami Moses demonda miteite sisina, ‘Imo aimi piesiri natokare gisijiari edo natokare katari embo etesi? ");
INSERT INTO bhg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Imo na dato betanate jipapa eta, dá avera angode ine Egypt embo awa deteto betesira ango ain esita?’ ");
INSERT INTO bhg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ango tesiri ge eiwa ingido Moses adu edo erido dodo yai Midian ainda aunsisina. Edo yai ounda isite aro jimundo mai jianda tote (2) pipisisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ango edo, duberi 40 itae esiri deguta da (1)de Moses yai abu damodamoda, Peji Sainai aikae, maundo isiri ni danegayani ango awa niyao aveite benimbesiri ainda gosisina. Edo Badari da Anelami niyao doda Moses da yai idegesisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Edo Moses mi gido korebé eite aikae atutumbedo goteiri Badari da ge yavi ainda yai engo gupusina, ");
INSERT INTO bhg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Na awa ito apiye ewowoda God, Abraham da God, Isaac da God, edo Jacob da God.’ Ango siri ingido Moses adumi ipatai jipeisiri jisimi gari awa jipapa ae esisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Edo BADARI mi ainde sisina, ‘Butu imo peteteta iteta awa butu kotopura, awatedo, ito tai woru teuge! ");
INSERT INTO bhg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Na bé gotena. Egypt embomaimi memesi bajinabé nato embomainda yai pipitera. Edo awamaneda woworu ununu benunu de awa ingena. Na einda wotetena, awamane udegain tedo. Boroko eriyo, edo nane imo piano Egypt aimbate!’ God mi Moses de ango sisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Edo Moses dá eiwa Israel embomaimi ajiregedo sitera, ‘Imo aimi piesiri natokare gisijiari edo natokare katari embo ain esi?’ Awarata, God mi embo eiwa piesiri maunsisina, awamane gisijiarate edo daedo udegarate. God mi ainda Anela jigamo esiri ami ni danegayani ango ainda doda Moses da yai idegesisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses emi awamane Egypt awa dodo gisijido kundo idegesisina. Ami wasiri babain ae kariwa neindekainde Egypt doda edo Ewa Ororodeda, edo daedo yai abu damodamo ainda esisina, iji angode Israel embomai duberi 40 yai ainda isiretera. ");
INSERT INTO bhg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moses dá emi Israel embomainde sisina, ‘BADARI, itomane God mi, Peroveta dá na ango awa imomane embo itomane nanonamejida yai edo jiari eraina.’ ");
INSERT INTO bhg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Edo embo eiwa dá ami Israel ewowo kaenato doregaride daedo isima edo esisina, yai abu damodamo ainda. Iji ainde Sainai Peji da visido isiri Anelami ainde ge tesiri gosisina. Edo Moses mi ge babain wasiride awa kaenamonde piarate piesiri burisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Awarata, kaenato ewowo gawowomi embo awa kera ari jipapa ae edo ajiregesitera. Daedo awamaneda domi Egypt tekago overegedo mamain jipapa esitera. ");
INSERT INTO bhg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ango edo, awamanemi Aaron de sitera, ‘Moses emi kaena Egypt da edo gisijido kundo idegatara, awa nongo esiri nakaena gae! Awatedo, inemi god nenei kaena embo eyo, ami kaena gisijioré!’ ");
INSERT INTO bhg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Edo deguta ainde awamanemi ove kewari kariwa wo kao mai ango esitera. Ango edo awamanemi rorou ove kewarida yai pisido dubodave eite ya uritera, aindabé, awamaneda ipami god awa esitera awatedo. ");
INSERT INTO bhg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ango etero gido God awamane gun jindedo doturisina, awamanemi utuda dabori mane awa tumondebain orote sisina. Peroveta maneda Ove Gaiari doda God da geda tari engo isira: ‘Giwo! Israel embomai, duberi 40 iji angode imomane yai abu damodamoda isite, womane gaiowo betoro rorou pisido esitewa, awa nato yai piae! ");
INSERT INTO bhg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Imomane daedo god Moloch da bowa saka budo, ainda ove kewari siya edo kundo maunsitewa. Edo itomane god nei, Remphan, ainda kariwa dabori ango daedo siya edo tumondebain ain kundo maunsitewa. Awatedo, nanemi imomane kundo Babiloni nasida daginegedo yai aikamanabéda ounda piano mambawa.’ ");
INSERT INTO bhg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Iji matu God mi ge okain Moses de tesiri gido ami God da bowa awa esisina, kariwa dá ango arate God mi ainda yai piesiri gosisina. Edo iji ainde kaenato ewowo gawowomi yai abu damodamoda isite, God da bowada tumondebain eiworo, imo akuta gundo ainda itari awamaneda yai arapa eiuri gido esitera. ");
INSERT INTO bhg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Edo ainda amboda ewowo gawowo kaenatomi, God da bowa awa kaenato mamonoda yai pietero bero, Joshua mi awamane gisijiri bowa awa kundo yai einda totoritera. Iji angode, God mi gisi maundo embomai eve, yai einda isima edo esitera awa, ondesiri dodo maunsitera. Ango edo God da bowa einda isiri iji awa biri David gupusina. ");
INSERT INTO bhg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Edo God da dubodave awa David da yai. Edo David mi Jacob da God tedogosisina, ‘Nanemi itari yai dave imo embo ae etenita?’ ");
INSERT INTO bhg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ata Solomon mi God da oro esisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Awarata ko, God Ikanebé Ikane awa oro kokotopu embomainda ipami ari ainda itari tao ae. Peroveta da (1)mi engo sisina: ");
INSERT INTO bhg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Utu awa nato daotari anumba, edo butu awa nato tai piari. Oro kariwa bé inemane na awa embo nongo avi?​ ​BADARI mi sira, ko nato oena apari yai awa indari? ");
INSERT INTO bhg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Roviravi berari eiwa nato ipami akuta esitena!’ ");
INSERT INTO bhg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Embo imomane awa jiro okain de. Itomane do ae dengoro de pirigae dá etene embo ango. Iji berari Asisi Kotopu ajiregedo ewa. Itomane ewowo gawowoda jimbo matu eiretera dá ango awa inemanemi edo ewa! ");
INSERT INTO bhg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Peroveta da (1) indawa awa ewowo gawowo itomanemi memesi neindekainde ainda yai piae esiteri? Awamane peroveta mane berarida yai memesi pisido esitera. Edo awamanemi peroveta mane ainkaimi Embo Wasiri Dambu Darari da gumbari karigesitera awa detero besitera. Edo embo awa gumbiri inemanemi kundo ainda gitopo emboda ipada pietewo detero besisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Imomane God da aodari matu buritewa. God mi aodari awa anelamanede piesiri kundo gundo ewowo gawowo kaenatoda yai pipisitera. Awarata, imomane ainda aodari awa kera ae!” ");
INSERT INTO bhg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Iji ainde Sanhedrin embobomi Stephen da ge awa ingido awamane do sinigambari bajinabé eiri ji gambero kitorukatoru sisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ata Asisi Kotopu mi Stephen gisijijieiri ami pangedo utuda jijimbedo God da parara de taogari de gosisina, edo Yesu awa God da ipabeda daedo petedo isiri gosisina. ");
INSERT INTO bhg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Edo embo ami sisina, “Giwo! Utu pirigesiri na Embo da Mai awa God da ipabeda petedo isiri gotena.” ");
INSERT INTO bhg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ainda edo awamanemi aoro ikanade gatedo ipami dengoro dundedo kotembari dá angomi ainda yai boraebé tumundo aunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ango edo embo awa kundo nasi bajinada arapada idegedo tuturo edo ganumami augedo doritera. Edo Stephen bekumba esitera embobomi awamaneda dademo ombari kokumbedo maisinga dao Saul da taida pipisitera. ");
INSERT INTO bhg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Iji ainde awamanemi ganumami Stephen dorero ami dao sisina, “Badari Yesu, nato asisi kumbu!” ");
INSERT INTO bhg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ango tedo ainda baongo dadari edo aoro ikanade gatedo sisina, “Badari, awamaneda jimbo eiwa jiote, edo awamanede sinigambari eote!” Ge eiwa sisina, ainda amboda durudo besisina. ");
INSERT INTO bhg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Edo Saul mi awamane embo awa daro betarate era awa gido awara esisina. Iji angode embomaimi tuturo edo Yesu gebé ari embomainda doregarida yai nasi Jerusalem ainda memesi neindekainde pietero awamane berari idegedo yai Judea edo yai Samaria ainda bodembesitera. Awarata, Yesu da piari aimbari embobo 12 Jerusalem nasida isiretera. ");
INSERT INTO bhg_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Edo God tou ari embobomi Stephen da tamo kundo maundo goiedo ji ikanade bé embo awa embo sitera. ");
INSERT INTO bhg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ata Saul mi Yesu gebé ari embomainda doregari usibesi eite mando tegerida torido embo de eutu de jido dumundo bundari oroda kundo maundo piedo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Awatedo, Yesu gebé ari embomai evekara esitera, edo awamanemi bino dave karigeteite yai berarida aunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ango edo Philip yai Samaria da nasi bajinada wotedo “Yesu awa Keriso” awamanede karigedo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Iji ainde embomai jiwaemi Philip da ge ingido edo kariwa neindekainde embo ami eiri awa gido awamane berari ge ro awa Philip mi siri awa gaintedo watake esitera. ");
INSERT INTO bhg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Philip mi asisi bebegae embomai jiwaeda doda itari awa ge siuri aoro ikanadebé gasite dodo idegedo maundo esitera. Daedo embomai jiwae ipatai ambari edo baoro bundari awa embo ami gao esiri kaviyegesitera. ");
INSERT INTO bhg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ango esiri embomai jiwaebé nasi ainda awa yawa bajinabé esitera. ");
INSERT INTO bhg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ata embo da (1) dao Simon mi iji riboribé nasi ainda doda donewode eite isima edo esisina. Ango eiuri yai Samaria embomaimi gido bé korebakore eora. Edo embo awa iji matawa site tedo esisina awa, “Na awa Embo Bajina!” ");
INSERT INTO bhg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ango teuri babadegari ae buro embobo demi ainda ge gain eite mina tara esitera, “Embo eiwawa Embo Bajina, edo God da goroba ainda yai isira!” ");
INSERT INTO bhg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Embo ami ainda donewodemi matu euri awamane gido korebakore eora. Awatedo, ainda ge ambo ambo edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ata iji angode Philip mi God da gisijiari edo Yesu Keriso da bino dave embomainde karigesiri awamane ainda ge ingido gebé esitera. Ango etero Philip mi embo ae eutu de daedo bapataito edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Edo Simon mi akuta Philip da ge daedo gebé esiri bapataito esisina. Ango esiri Simon mi Philip de daedo imapuma edo eiri buro babain edo kariwa neindekainde eiuri goteite bé korebakore edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Edo iji nonde Yesu da piari aimbari embobo Jerusalem doda ami yai Samaria embomaimi God da ge burara awa ingido, awamanemi Peter ae John de awa Samaria embomainda yai pietero maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Awamane gumbae gisida, Philip mi gebé ari embomai teteka Yesu Keriso da daoda bapataito esisina, ata God mi ainda Asisi Kotopu awamaneda yai piae. Ango edo Peter ae John de yai Samaria da wotedo gundo awamane tote (2)mi gebé ari embomai teteka awa embo God da yai benunu sitera, ainda Asisi Kotopu awamaneda yai piari borote. ");
INSERT INTO bhg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Edo Peter ae John demi awamaneda ipa embo da da ainda tamonda pipiteiworo awamane Asisi Kotopu budo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Edo iji ainde Simon mi Yesu da piari aimbari emboboda ipami Asisi Kotopu embomainda yai pipitero gosisina, awatedo, ine ganu kundo gundo Peter ae John deda yai piain, ");
INSERT INTO bhg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","sisina, “Nato yai daedo goroba eiwa piewo! Ango awo embo nenei berari nanemi ipa tamonda piano Asisi Kotopu kumbore.” ");
INSERT INTO bhg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ata Peter mi ge mina sisina, “Aindabé God da kando ganumi ori ae eteta kotembeteta, awatedo, imo ae ito ganu de daedo yai beyae niyao matawa itari aveira ainda mambata! ");
INSERT INTO bhg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","God mi goteira awa, ito do awa dambu darae, awatedo, imo awa buro eiwa namondekare daedo eotekae. ");
INSERT INTO bhg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Aindabé awa, ito jimbo bebegaeda dodo wareregedo gumbuyo! Edo God da yai benunu teyo! Ango ato ito doda kotembari bebegae awa God mi kotembedo doware. ");
INSERT INTO bhg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na gotena, imo awa embo neneinda rorae bain jipapa edo jitari embo. Awatedo, Satan mi ito jimbo beyaeda toda imo bundesiri iteta. ");
INSERT INTO bhg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ango tesiri Simon mi ainde mina sisina, “Imomane na embo Badari da yai benunu tewo! Ango awo ro awa inemane tetewo gena, awa nato yai piari gumbure.” ");
INSERT INTO bhg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Awatedo, Peter ae John demi Yesu awa embo averi gositera awa arapada embomainde sitera edo Badari da ge embomainde jijiritera. Ainda amboda, embo tote (2)mi egenembedo Jerusalem da tuturo edo maunsite bino dave yai Samaria nasi jiwaebé da da ainda karigesimene, ango maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Edo Badari da anelami Philip de sisina, “Erido south kena mambuyo! Ango eite begata Jerusalem da edo nasi Gaza kena wotari ainda pepeta ate. Begata eiwa yai abu damodamoda isira.” ");
INSERT INTO bhg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ango tesiri gido Philip erido maunsisina. Maunsiunte, boite, yai Iteopia embo tapusina. Embo awa badarari bajina. Imo awa Iteopia da daotari eutu, dao Candace, da buro embo. Edo Candace da ganu berari awa ami sima edo esisina. Badarari ami God tumondebain aintedo Jerusalem da gupusina. ");
INSERT INTO bhg_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ainda maundo tumondebain itae edo ainda nasida tenda overegeteite embo awa ombo mada anumbedo isite ove gaiari matu peroveta Isaiah da awa ajijigesisina. ");
INSERT INTO bhg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Edo Asisi Kotopu mi Philip de sisina, “Imo maundo ombo ma ounda atutumbedo ainde daedo mambuyo!” ");
INSERT INTO bhg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ango tesiri Philip mi ombo mada ongo kena tumundo maundo atutumbesiri embo ami peroveta Isaiah da ove gaiari awa ajijigeteiri ingisina. Awa ingido Philip embo ainde tedogosisina, “Ge ine ajijigeteta awa ito yai arapa eirita?” ");
INSERT INTO bhg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Edo embo ami mina sisina, “Na ge eiwa nongo edo gano arapa aini da bé awa embo neimi udugedo tari nato yai arapa aina ami?” Ango edo Philip visido ainde daedo anumbarate sisina. ");
INSERT INTO bhg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","God da Ge Gaiari badararimi ajijigesisina awa engo: “Embo awa wo sipu ango embomaimi gisijido​ ​kundo maundo gaiaro betaina, edo dá ango, wo sipu mai iji angode embomaimi​ ​ainda tu kapedo era, ge da ji itae, embo awa ainda be pirigae. ");
INSERT INTO bhg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Awamane embo awa tedojijireite kundo maundo​ ​katari embode ge pitawa ainda daoda tara. Awamane ainda wasiri butuda awa kaparo itae aina. Awatedo, embo da ji aimi ainda mamainda ge​ ​jirari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Edo Badarari ami Philip de tedo sisina, “Na imonde tedogotena, peroveta ge eiwa embo bé ande sisini? Imo akuta awa embo sisinita ko embo nei awa embo sisini?” ");
INSERT INTO bhg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Edo Philip tuturo edo God da Ge Gaiari da ge eiwa edo embo ainde Yesu da bino dave awa karigesiri gosisina. ");
INSERT INTO bhg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ango edo awamane begatada auntero jiriri gundo unda esitera. Edo badararimi sisina, “Un isira eire. Gi! Na bapataito ae etesita?” ");
INSERT INTO bhg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Edo Philip ainde mina sisina, “Imo edo gido dogomo berarimi bino dave eiwa gebé ata gido, na imo bapataito ana.” Ango tesiri mina sisina, “Na gebé ena, Yesu Keriso awa God da Mai.” ");
INSERT INTO bhg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Awatedo, ombo ma petarate ainda ma jiari embode ge okain sisina. Tesiri petesiri gido Philip ae badarari de daedo wotedo unda aimbero Philip embo awa bapataito esisina. ");
INSERT INTO bhg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Edo awamane unda edo vitero Badari da Asisi mi burigibé Philip kundo yai neinda maunsisina. Edo badarari embo awa tekago gae esisina. Ata iji ainde, aindabé God imo tonembesisina, badarari doyawa bajinabé eite dodo aunsisina. ");
INSERT INTO bhg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Awarata, Philip Azotasi nasida idegesisina. Edo nasi ainda tuturo edo aundo nasi babain berarida torido idegedo eite bino dave awa simene maundo Seseria nasida gupusina. ");
INSERT INTO bhg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Edo iji angode Saul sinigambari bajinabé matawa eite ge okain bé site Badari da ambodani awa dari betorote tedo pirisida gisijiari bajinada yai aunsisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ango edo Saul mi tedogosisina pirisida gisijiari bajinami ove Judah embomainda benunu oroda babadegari Damasikas nasida itera ainde gaiari, Saul ami awamaneda yai ove piarate sisina. Edo ove emi Saul da yai awara tari piari embo o eutu ainkaimi Badari da Begata ambo ambo edo era gido awa ipami jido bundedo Jerusalem nasida kundo gumaina. ");
INSERT INTO bhg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Edo maunteiunte nasi Damasikas aikae eiri boraebé parara utuda edo gundo ainda yai datembesisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ango esiri embo awa butuda dudurisina, ami ge yavi ingisina, “Saul, Saul! Ro awa embo memesi neindekainde namonde pisido esi?” ");
INSERT INTO bhg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Imo averi Badari?” Saul mi sisina. “Na awa Yesu, ande inemi memesi neindekainde pisido eta,” Badari mi mina sisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Ata erido aundo nasi bajinada toriyo, inemi ro atate taina awa gate.” ");
INSERT INTO bhg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ango tesiri embobo Saul de daedo maunsitera awa petedo ge tae esitera. Awamane ge yavi ingitera, ata emboda dombu gain edo gae esitera. ");
INSERT INTO bhg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Edo Saul butuda edo erorisina, edo jisi pirigesisina, ata embo da (1) ave gae. Awatedo, awamanemi embo awa ipami jido kundo Damasikas totoritera. ");
INSERT INTO bhg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ango edo embo awa deguta tamonde (3) jisi akeimbeteiri indari indae edo un indae sima esisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Awara, iji ainde ambodani da (1) Damasikas nasida isinesina. Ainda dao awa Ananias. Edo Badari mi embo ainda yai garago giragoda ge sisina, “Ananias!” “Na evire, Badari,” embo ami sisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Edo Badari mi embo ainde sisina, “Siya edo erido nasi begata dao Dambu Darari ainda mambuyo. Edo Judas da mandoda maundo nasi Tasus embo dao Saul awa dao tedogate, aindabé giyo, embo awa nato yai benunu site isira, ");
INSERT INTO bhg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","edo embo ami garago giragoda embo dao Ananias mi ainda yai gundo ipa tamonda piesiri gira, ainda jisi tenda dave arate, awatedo.” ");
INSERT INTO bhg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Edo Ananias mi mina sisina, “Badari, embomai jiwaemi ge namonde embo einda daoda tetero ingena awa, emi ito embo kokotopu Jerusalem da itera ari bebegae jiwaebé awamaneda yai eutara. ");
INSERT INTO bhg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ango edo awa pirisi babainda awara tari einda kundo gupara awa, embomai berari ainkaimi ito daoda dasiga eiaro gido bunaina.” ");
INSERT INTO bhg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ata Badari mi embo ainde sisina, “Aimbuyo! Embo eiwa na kondade arate avigetena. Ami nato ge kundo yai nei embomai ae daotegeregari de Israel da mamai deda yai karigare. ");
INSERT INTO bhg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Edo nanemi ano embo awa gaina memesi nandogo baini nato daoda buro eite.” ");
INSERT INTO bhg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ango tesiri Ananias maundo mando doda totorisina. Edo ainda ipa Saul da tamonda pisido sisina, “Nameji Saul, iji ainde imo begatada gupeto Badari ito yaida idegesiri gotata. Embo ami na ito yai piesiri gumena awa ito jisi tenda dave edo Asisi Kotopu mi imo gisijiarate.” ");
INSERT INTO bhg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Edo boitebé rorae wo tata ango ainda jisida edo wotesiri ainda jisi boraebé dave esisina. Edo embo awa eriri bapataito esisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Edo ainda amboda, embo awa indari injido ainda goroba tenda burisina. Ango edo Saul deguta nenei Badari da ambodanide daedo Damasikas ainda sima esisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Edo iji dá ainde Saul dambu darido maundo Judah emboda benunu oro evekarada torido Keriso da ge karigedo esisina awa, Embo eiwa awa God da Mai. ");
INSERT INTO bhg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ango edo embomai berari ge awa ingido bé korebakore eite ge mina tara edo esitera, “Embo amo Jerusalem ainda embo owa ainkaimi Yesu da dao dasiga eiworo erido kundo usibesi edo eiara awarita? Edo embo ami embomai dá ango yai einda bundedo kundo pirisi babainda yai piain awa embo guparita?” ");
INSERT INTO bhg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ata Saul da ge tarida goroba awa bajido bajinabé esisina. Edo imo arapa esiri awamane gositera, Embo eiwa awa Keriso. Awatedo, Judah embomai Damasikas ainda isima edo esitera, awamane mina ro daginegedo tari tao ae esitera. ");
INSERT INTO bhg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Edo deguta jiwae itae esiri ainda amboda, Judah embobomi onjigedo ge kasitera, embo awa daro betarate. ");
INSERT INTO bhg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ata Saul mi awamaneda ge jirari awa ingisina. Edo awamane ijide muyaende nasi bajinada guwa be berarida awa simagedo esitera, embo awa tamundo daro betarate. ");
INSERT INTO bhg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ango edo Badari da ambodanimi muyaende Saul kundo maundo kambiyada penjido guwa gaiarida be jiumbarida pietero wotedo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Edo Saul Jerusalem da gundo Badari da ambodanide dada ain jipapa esisina. Ata embo awa Badari da ambodanibé awa awamanemi gebé ae esitera. Awatedo, awamane berari embo awa adu esitera. ");
INSERT INTO bhg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ata Barnabas mi Saul budo Yesu da piari aimbari emboboda yai kundo gupusina. Edo embo ami awamanede ge jijirisina awa, nongo edo Saul mi Badari begatada gosisina edo Badari mi ge ainde sisina, edo daedo nongo edo Saul mi do jinenegedo Damasikas ainda Yesu da daoda ge karigesisina awa. ");
INSERT INTO bhg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Awatedo, Saul awamanede daedo Jerusalem isite imapuma eite do jinenegedo Badari Yesu da daoda ge karigedo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Edo embo awa ae Guriki Judah embomai de ge site ge baisina. Ata awamane embo awa daro betarate jijimbedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ango edo nanonameji ge awa gidogogobé edo awamanemi embo awa Seseria nasida kundo wotedo pietero ainda nasi tutu, Tasus da, maunsisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ainda amboda, Yesu gebé ari embomainda doregari da da, yai Judea da, edo Galili da edo Samaria da, awamane berarida yaida béga gupusina, edo God mi esiri awamaneda gebé ari babojisina. Edo awamane Badari tou eite imapuma eiworo Asisi Kotopu mi kondade dave pipiteiuri embo nenei awamaneda yai gumboro Yesu gebé ari embomaida doregari jiwaebé idegedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ango edo iji ainde Peter mi yai neindekainde jiroro eite pepeta edo maunsisina. Edo ango eite imo wotedo maundo, embo kokotopu Laida nasida isima edo esitera, awamaneda yaida daedo etega gupusina. ");
INSERT INTO bhg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Iji dá angode nasi ainda gundo embo dao Aeneas tapusina. Embo awa ipatai ambari kakateda durari isite duberi 8 itae esisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Edo Peter mi ainde sisina, “Aeneas, Yesu Keriso mi imo gao eira. Erido ito besi ruveyo!” Ango tesiri imo burigibé erorisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Awatedo, embomai jiwaebé nasi Laida edo Saron yai vivitegarida, awamanemi embo awa gido awamaneda do Badari da yai wareregesitera. ");
INSERT INTO bhg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Edo ambodani da (1), watai eutu dao Tabitha, nasi Jopa ainda isinesina. Edo ainda dao Guriki da geda awa Dorcas. Eutu eiwa iji berari buro beyamana eite embomai rorae isisigae kondade edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Awarata, iji ainde eutu awa karu budo besisina. Ango esiri ainda otatawomi ainda tamo teiedo kundo visido mando do ikane jiumbari ainda pipisitera. ");
INSERT INTO bhg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nasi Laida awa aikae Jopa. Awatedo, ambodani nasi Jopa da ami Peter awa nasi Laida isira, ge awa ingitera. Ango edo embo tote (2) pietero maundo embo ainde tedogositera, “Aiyae, burigibé natokare yai gumbuyo!” ");
INSERT INTO bhg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ango edo Peter erido awamanede daedo maunsisina. Edo embo awa nasida idegesiri kundo visido yai ikane jiumbari ainda totoritera. Edo eutumai rori berarimi Peter da demonda petedo ji site ombarijiari Dorcas mi awamane daedo isite gagurisina awa Peter de jiero gosisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ata Peter embomai berari yai doda awa arapada piesiri idegistera. Ango etero baongo dadari edo benunu sisina. Edo benunu tari itae edo tamo kena wareregedo sisina, “Tabitha, eriyo!” Ango edo eutu awa jisi gunjisina. Edo iji ainde eutu awa Peter gido erido anumbesisina. ");
INSERT INTO bhg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Edo Peter mi eutuda ipa jiri erido peposisina. Ango esiri Peter mi embo kokotopu ae eutumai rori de dao tesiri gumbero awamaneda yai eutu awa wasiride piesiri gositera. ");
INSERT INTO bhg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ango edo bino awa arapu mambiri Jopa nasi embomai berari ingero embomai jiwaemi Badari da yai awamaneda gebé ari pipisitera. ");
INSERT INTO bhg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Awatedo, Peter Jopa ainda deguta jiwae sima esisina, wo aintoda buro ari embo dao Simon da mandoda. ");
INSERT INTO bhg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Edo iji ainde embo dao Cornelius awa Seseria nasida isinesina. Embo awa Rome da itoroda gisijiari edo imo ae itoro emboboda doregari bajina ainde yai Italy edo gupusina. Edo embo emi itoro emboboda doregari bajinada doda itoro embobo ajigari 100 gisijido esisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Embo eiwa God da jipapa ambo ambo ain edo esisina. Edo imo ae ainda orobe berari de awa Judah embomai ae, edo awamanemi God adu edo esitera. Edo ami embomai rorae isisigae kondade jiwaebé eite, edo daedo iji berari God da yai benunu tedo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Edo deguta da (1)de 3:00 turo angode garago girago ainda yai gupusina. Edo garago girago ainda imo arapabé gosisina, God da anela gupeite ainda mandoda torido embo ainde site sisina, “Cornelius!” ");
INSERT INTO bhg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ango edo Cornelius mi anela awa jijimbedo adu eite sisina, “Badarari, imo ro jipapa esi?” ango sisina. Edo anelami ge mina sisina, “God mi ito benunu tari ae kondade ari dave jiwaebé de awa gido dubodave esira. Ito iwata ari dave awa rorou ango God da yai. ");
INSERT INTO bhg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Awatedo, boroko embo nenei pisiyo nasi Jopa ainda mambore! Edo maundo embo dao Simon Peter awa kundo egenembedo gumbore. ");
INSERT INTO bhg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Embo awa ae Simon nei, wo aintoda buro ari embo, ainde daedo isima edo eira. Ainda mando awa ewa bengida.” ");
INSERT INTO bhg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ainda amboda anela ge tedo dodo mambiri, Cornelius mi ainda mandoda buro ari embo tote (2) dao tesiri guputera. Edo imo itoro embo da (1) daedo dao tesiri gupusina. Embo awa God da jipapa ambo ambo ain einesina, edo imo Cornelius matawa sima einesina. ");
INSERT INTO bhg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ango edo gumbero Cornelius mi ro berari idegesiri awa tesiri gero awamane piesiri nasi Jopa maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Edo avera angode, awamane maundo nasi bajina aikae gupero iji toropu bureiri Peter benunu tain mando tada vivisisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ango edo Peter beji eiri rorae indari jipapa esisina. Ata iji angode awamane ainda indari siya ero garago girago eiwa ainda yai gupusina: ");
INSERT INTO bhg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Utu pirigesiri Peter mi rorae gari dá gongo bereya ango, ainda umbugo ipa ao pasido (4) asimi kanjigedo, dotero ainda yai butuda wowoteiri gosisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Edo gongoda doda sinopu neindekainde ipatai ipa ao pasido (4) butuda isima edo era ae abu womane de jimbago mane de edo nimane ikane ima edo era, awamane daedo gosisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ango edo ge yavi embo ainda yai gupusina, “Peter, erido dedo injiyo!” ");
INSERT INTO bhg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ata Peter mi mina sisina, “Ango ae, Badari! Rorae dave ae ko donode God da jisida awa, na indaede.” ");
INSERT INTO bhg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Edo ge yavi tekago iji ainde ainda yai gupusina, “Roviravi God mi dave tesira awa, inemi dave ae tainyae!” ");
INSERT INTO bhg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ango edo iji tamonde (3) eiwa idegesisina. Ainda amboda rorae awa tenda jiero utuda vivisisina, ango gosisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Edo iji ainde Peter mi akuta garago girago imo gosisina ainda mokabé rori awa kotemain eite isiri, boraebé embobo Cornelius mi piesiri guputera. Awamanemi wo aintoda buro ari embo dao Simon ainda mando embo nenei ganega etero udugetero gundo ainda guwa beda pepositera. ");
INSERT INTO bhg_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Edo awamanemi embo doda itera awa dao tedo tedogositera, “Simon Peter einda isima edo eirita?” ");
INSERT INTO bhg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Edo iji angode, Peter mi garago girago ainda mokabé rori jiro buro eiri Asisi Kotopu mi ainde sisina, “Giyo! Embomai imo kakowa era. ");
INSERT INTO bhg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Awatedo, eriyo! Erido wotedo awamanede daedo mambate! Nanemi awamane ito yaida pieteno gumbera. Aindabé awa, kotembari jiwae dodo mambuyo.” ");
INSERT INTO bhg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ango edo Peter wotedo embobode sisina, “Een, embo imomane gain kakowa ewa, na evire. Nongaintedo imomane einda gumbevi?” ");
INSERT INTO bhg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Edo awamanemi ainde mina tedo sitera, “Cornelius, Rome da itoroda gisijiari, ami nakare piesiri gumbera. Embo awa wasiri dambu darari edo God adu ari embo. Edo Judah embomai berarimi embo awa tou edo era. Edo God da anela kotopumi embo ainde tesira awa, nakare imo kundo ainda mandoda aimbaro ito ge tato ingain tesira.” ");
INSERT INTO bhg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ango edo Peter mi awamane jimbiri gumbero kundo mandoda totorisina. Edo sipo neinde Peter erido awamanede maunsisina, edo Jopa da nanonameji neneinde daedo. ");
INSERT INTO bhg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Edo sipo neinde awamane Seseria totoritera. Cornelius iji ainde awamane gumbaro gain eite isinesina. Edo ainda embototopo ae otatawo atutumbaride daedo ainda mandoda dada orote matu sisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Edo Peter mando doda totoreiri Cornelius embo awa tamundo baongo dadari edo tumondebain esisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ata Peter mi embo awa jiri eroreiri sisina, “Erido pete! Na awa daedo embo enembo.” ");
INSERT INTO bhg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Edo Peter embo Cornelius de ge site mando doda torido embomai jiwae ainda dada edo itero tapusina. ");
INSERT INTO bhg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ango edo Peter mi awamanede sisina, “Imomane awa garibé, Judah embomainda aodari okain bé isira awa nanekaremi yai nei embomainde umojiorekae ko awamaneda yaida etega eorekae tari. Ata God mi na esiri gena awa, nane embo da ji ave awa dave ae ko donode God da jisida tainyae. ");
INSERT INTO bhg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Awatedo, iji nonde ito buro embobo na borote pieteto gupara awa, na gumainyae tae, ata dodo gumena. Awa embo, na imo tedogotena, nongaintedo na awa kundo gumbesi?” ");
INSERT INTO bhg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ango edo Cornelius mi ainde mina sisina, “Deguta ipa ao pasido (4) gisi ainde, indari dodo na veta eite benunu teno jiriri ora 3:00 turode bureiri gotana, dá ango iji einde. Edo nato mando doda burigibé embo da (1)mi ombarijiari parara datembaride nato dombuda idegedo pepotara. ");
INSERT INTO bhg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Edo ami sisina, ‘Cornelius, ito benunu tari awa God mi ingira, edo ito kondade ari dave jiwaebé embomai rorae isisigaeda yai awa God mi gido dubodave esira. ");
INSERT INTO bhg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Awa embo, embo nenei Jopa nasida pieyo mambore, edo Simon Peter taro gido einda gumbare. Embo awa ae Simon nei, wo aintoda buro ari embo, ainde daedo isima edo eira. Ainda mando awa ewa bengida. Embo awa gundo ito yai ge taina.’ ");
INSERT INTO bhg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Awatedo, burigibé ito yaida dodomo pipitana. Edo imo nato ge ingido gumbeto na dubodave ena. Awatedo, boroko nakare berari God de daedo einda dada edo itera rorae berari God mi ito yai ge okain siutara awa, ingaintedo.” ");
INSERT INTO bhg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Edo Peter tuturo edo ge sisina, “Boroko na arapabé gotena, God awa embo neinde dave eite embo neinde beyae ae de. ");
INSERT INTO bhg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ata butu berarida, embo ainkaimi God adu eite edo wasiri dambu darari edo era awa, God mi awamane budo eira. ");
INSERT INTO bhg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Imomane awa garibé ge eiwa God mi Israel mamainda yai karigesite pipisisina. Edo bino dave awa embomaimi God de béga bara, Yesu Keriso da toda. Embo awawa embomai berarida Badari. ");
INSERT INTO bhg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Imomane awa garibé, ainda amboda John mi embomainde ainda bapataito ari ge karigesisina, ge ro awa tuturo edo yai Galili idegedo maundo yai berari Judea doda ainda arapu esisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Imomane awa garibé nongo edo God mi Yesu Nasaret Embo awa Asisi Kotopu ae goroba demi bimbegesisina. God mi Yesu de daedo isinesina. Awatedo, imo imapuma eite embomai kondade evina. Edo Yesu mi embomai berari awa Binei mi eiuri memesi bajina bureiworo gao edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Edo nanekare jisimi buro ro berari ami Judah embomainda butuda edo Jerusalem ainda doda esiri gositera awa embomainde tedo era. Edo awamanemi embo awa oregada piedo detero besisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ata amboda imo besisina, deguta tamonde (3) ainde, God mi embo eiwawa betarida jiri erorisina. Edo God mi embo eiwa wasiride gorote esiri embomai nenei imo arapada jisimi gositera. ");
INSERT INTO bhg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","God mi embomai berarida yai embo awa arapa ae gae. Awarata, God mi gisibé ainda piari aimbari embobo avigesisina awa, nanekare Yesu jisimi gido imo awa embomai neneinda yai karigorote. Edo nakare Yesu da betedo erari ainda amboda, embo ainde daedo rorae ae un de injido esitera. ");
INSERT INTO bhg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Edo embo ami ge okain namondekare sisina awa, nanekaremi embomainde karigedo edo ge dugabé awa torote, God mi embo awa avigesisina, embomai wasiri de edo betari de, awamaneda Katari Embo. ");
INSERT INTO bhg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Peroveta berarimi ainda ge tedo era awa, embo ainkaimi embo awa gebé ara awa, God mi embo ainda daoda ami awamaneda jimbo bebegae kotembedo dowaina.” ");
INSERT INTO bhg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Edo Peter mi ge matawa site isiri Asisi Kotopu embomai berari ainkain ge ingitera, awamaneda yai wowosisina. ");
INSERT INTO bhg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Aindabé God mi ainda Asisi Kotopu da kando Judah embomai aeda yai daedo dodegesisina, awatedo, Judah gebé ari embomai Jopa edo ae Peter de daedo gundo bé korebakore esitera. ");
INSERT INTO bhg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Edo Judah embomai ae awa ge teka yai neneinda ami God da wasiri babain bé tero ingitera, awatedo, awamanemi Asisi Kotopu Judah embomai aeda yai gumbira awa gositera. Ango edo Peter mi sisina, ");
INSERT INTO bhg_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Embomai eiwa Asisi Kotopu bera dá ango nakaena buritera. Awatedo, embo da aimi eiwamaneda un mi bapataito ari awa engiregari tao ae.” ");
INSERT INTO bhg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Edo Peter mi embomai awa Badari da daoda bapataito orote ge okain sisina. Ainda amboda, Peter awamanede deguta indewae daedo itarate, tedogositera. ");
INSERT INTO bhg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Edo Yesu da piari aimbari embobo ae nanonameji neneinde yai Judea do ainda isima edo esitera ami Judah embomai aemi God da ge daedo ingido gebé eutara awa ingitera. ");
INSERT INTO bhg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ango edo iji ainde Peter Jerusalem maundo vivisisina. Edo iji dá ainde Judah embomainda jisi da ami gebé esitera awa, Judah embomaimi tamo jiugae embobode daedo mana umojiara. Awatedo, awamanemi tuturo edo Peter bekumba esitera, ");
INSERT INTO bhg_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Imo awa tamo jiugae emboboda mandoda etega edo awamanede daedo indari injitata!” ");
INSERT INTO bhg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ata Peter mi tuturo edo rorae berari nongo idegatari awa babaiango udugedo awamanede tesiri gositera: ");
INSERT INTO bhg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nanemi Jopa nasi bajina ainda isite benunu teno garago girago nato yai gumbiri gotana. Edo utuda edo rorae gari dá gongo bereya ango, ainda umbugo ipa ao pasido (4) asimi kanjigedo, dotero wowosite nato yaida gumbiri gotana. ");
INSERT INTO bhg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ango edo na ainda doda jijimbedo kotembeteite, sinopu neindekainde ipatai ao pasido (4) butuda isima edo era ae abu womane de jimbago mane de edo nimane ikane ima edo era, awamane daedo gotana. ");
INSERT INTO bhg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Edo ge yavi namonde siri ingitana, ‘Peter, erido dedo injiyo!’ ");
INSERT INTO bhg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ata na mina siutana, ‘Ango ae, Badari! Rorae dave ae ko dono de God da jisida awa iji da (1) nonde nato beda pipisiteni awa itae.’ ");
INSERT INTO bhg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ata ge yavi tekago utuda edo namonde mina siutara, ‘Roviravi God mi dave tesira awa, inemi dave ae tainyae!’ ");
INSERT INTO bhg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ango edo eiwa iji tamonde (3) idegatara. Ainda amboda, roviravi berari awa tenda jiero utuda vivitara. ");
INSERT INTO bhg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Edo iji dá ainde, embo tamonde (3) awa Cornelius mi Seseria edo nato yaida piesiri gundo mando na isima edo eutana ainda idegedo pepotara. ");
INSERT INTO bhg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ango edo Asisi Kotopu mi namonde siutara, ‘Kotembari jiwae dodo awamane daedo mambuyo!’ Ango tesiri na ae nanonameji, Judah embobo 6, eiwamanede daedo maundo Cornelius da mandoda totorara. ");
INSERT INTO bhg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Edo embo ami namondekare nongo edo anelami ainda mandoda petesiri gotara awa ainda ge awa jijirara. Edo anelami ainde teiara, ‘Embo nenei pisiyo nasi Jopa ainda mambore! Edo embo dao Simon Peter awa kundo egenembedo gumbore. ");
INSERT INTO bhg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Embo emi imonde ge taina ami imo ae embomai berari imo daedo isima edo era ainde awa tonembari kumbawa.’ ");
INSERT INTO bhg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Edo iji ainde na tuturo edo ge teno Asisi Kotopu awamaneda yai wowotara dá ango tuturobéda kaenato yaida wowosisina. ");
INSERT INTO bhg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Edo na Badari da ge eiwa kotembatana, ‘John embomai un mi bapataito esisina, ata God imomane Asisi Kotopu mi bapataito aina.’ ");
INSERT INTO bhg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Awatedo, edo God mi kando Judah embomai aeda yai pipitara dá awara kaenamonde pipisisina, iji ainde kaena Badari Yesu Keriso da yai gebé esitera, na, embo enembomi God engiregari tao ae!” ");
INSERT INTO bhg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ango edo awamane ge eiwa ingido bekumba ari doturitera. Edo awamanemi God dasiga eite sitera, “Awatedo, Judah embomai ae ainkaimi awamaneda jimbo beyae dodo God da yai wareregara, God mi awamaneda yai daedo wasiri natopo itari piaina.” ");
INSERT INTO bhg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Awara, iji amboda embomaimi Stephen detero betesiri, awamanemi Yesu gebé ari embomai nenei memesi neindekainde awamaneda yai pietero yai evekarada bodembesitera. Edo gebé ari embo nenei yai Poenisia da mambero, edo nenei Saipurasi gategada mambero, edo nenei Enteoki nasi bajinada maunsitera. Ata yai nonda awamane maundo God da ge Judah embomainde akuta karigetero ingitera. ");
INSERT INTO bhg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ata gebé ari embo nenei Saipurasi gategada edo Sairin nasida edo gumbari awamanemi maundo Enteoki nasi bajinada totoreite Guriki embomainda yai daedo ge site Badari Yesu da bino dave karigetero ingitera. ");
INSERT INTO bhg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Edo gebé ari embomi Badari da gorobami ge karigetero embomai jiwaebé gebé edo Badari da yai wareregesitera. ");
INSERT INTO bhg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ango edo bino eiwa arapu esiri Yesu gebé ari embomainda doregari Jerusalem da awamanemi ingitera. Awatedo, Barnabas pietero Enteoki da maunsisina. ");
INSERT INTO bhg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Edo iji angode embo awa idegedo gundo nongo edo God mi embomai ainda ao esiri gido yawa esisina. Edo embo emi awamane beraride kondade ari ge engo karigesisina, “Imomane do berarimi Badari tumonda eite ambo ambo awate.” ");
INSERT INTO bhg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas awa embo dave. Asisi Kotopu mi embo awa gisijido esisina, edo ainda gebé ari God da yai okain bé pisido esisina. Awatedo, embomai jisi da ainda ami Badari da yai wareregesitera. ");
INSERT INTO bhg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ango edo Barnabas nasi Tasus ainda Saul kakowa maunsisina. ");
INSERT INTO bhg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Edo iji ainde embo awa tamundo Barnabas mi imo kundo Enteoki gupusina. Awatedo, embo tote (2)mi duberi da (1) awa berari Yesu gebé ari embomainda doregaride dada edo embomai jiwaebé atopapositera. Edo Enteoki nasi ainda embomaimi tuturoda ambodani dao ‘Keriso da embomai’ tedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Edo iji engode, peroveta mane nenei Jerusalem da edo wotedo Enteoki da guputera. ");
INSERT INTO bhg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ango edo peroveta da (1) awamaneda doda dao Agabus eriri Asisi Kotopu mi embo awa gisijiri ami beji ambari bajina butu berarida gumain eira awa karigesisina. (Edo Claudius Caesar mi Rome da embomai gisijijisina iji ainde beji ambari bajina awa gupusina.) ");
INSERT INTO bhg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Awatedo, ambodani Enteoki da itera ami ge kasitera awa, kondade edo ganu piaro nanonameji yai Judea da itera ainda mambarate. Edo ganu tega nandogo awamane piari tao, embo da da akutami ge awa katedo piain esitera. ");
INSERT INTO bhg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ango edo ganu awa Barnabas ae Saul deda ipada pietero kundo maundo Judea gebé ari embomainda orobeda kopuru mamainda yai pipisitera. ");
INSERT INTO bhg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Awara, iji ainde Daotari Herod erido Yesu gebé ari embomainda doregarida embo neneinda yai tuturo edo memesi neindekainde pisido esisina. ");
INSERT INTO bhg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Edo embo ami itoro embobode tesiri John da nameji James awa kasiwomi detero besisina. ");
INSERT INTO bhg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ango esiri Judah embomai dubodave esitera. Awatedo, embo ami tesiri itoro embobo maundo Peter kuputera. Edo iji einde Judah embomaimi awamaneda Bread Badari Siwo Piaeda Bondo ero Herod buro awa esisina. ");
INSERT INTO bhg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ango edo awamane Peter kundo maundo bundari oroda pipisitera. Edo Herod mi sirigesisina awa, deguta da da itoro embobo 16 ami Peter sima orote. Deguta da da ainda doda embo ipa ao pasido (4) da doregari evekara ami Peter sima edo esitera, sipode, ijide, turode, muyaende ango. God da Darutegari Bondo itae ari gido Herod da jipapa awa Peter kundo gundo Judah embomainda dombuda katedo dari betaina. ");
INSERT INTO bhg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Awatedo, awamanemi Peter bundari oroda sima esitera, ata Yesu gebé ari embomainda doregari awa God da yai embo awa embo benunu matawa tedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Edo muyae gisida Herod mi embo awa kundo idegedo embomainda dombuda kataina, Peter awa itoro embo tote (2)da toropuda asi okain aurimi ari tote (2) ami awamanede daedo bundetero jitao ausina. Edo itoro embo nenei ami manguroda isite bundari oro sima edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Boraebé Badari da anelami ainda yai petesiri parara bundari oroda datembesisina. Edo anelami Peter da dendegida ipa pisido aujite sisina, “Burigibé erido pete!” Iji dá ainde asi okain aurimi ari tote (2) awa ainda ipada teugedo duduritera. ");
INSERT INTO bhg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ango edo anelami ainde sisina, “Ito bupuri jido ito tai woru pieyo!” Awatedo, Peter de ro sisini awa esisina. Edo anelami ainde sisina, “Ito dademo ombari omundo namonde daedo puyo!” ");
INSERT INTO bhg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ango edo Peter mi anela awa kera edo ambo ambo eite idegesisina. Atako buro ro anelami esiri gido awa, Peter kotembesisina awa gebé ae. Awa garago girago gari ango kotembesisina. ");
INSERT INTO bhg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Edo aedade bundari oro sima ari embo da (1) daginegedo maundo sima ari embo nei daginegedo maunsitera. Edo awamanemi guwa be aurimi ari awa bundari oroda edo nasi bajinada mambari ainda guputera. Edo guwa be awa akuta awamane embo pirigesisina. Ainda amboda, awamane tote (2) arapada idegedo begata da (1) ainda pepeta edo maunsite boraebé anelami embo awa dodo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ango edo Peter bé gidogogo esisina wasiri ro ainda yai idegesiri edo sisina, “Boroko na gotena, awa bé gebé. Badari mi ainda anela piesiri na Herod da gorobada edo Judah embomainda jipapada toregesira.” ");
INSERT INTO bhg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Edo iji ainde Peter awa gari, God imo toregesisina, embo ami Mary da mandoda aunsisina. Eutu awa John Mark da ai. Edo iji dá ainde embomai jiwae ainda mandoda dada edo benunu site itero Peter gupusina. ");
INSERT INTO bhg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Edo Peter guwa beda petedo tatain jivesina. Edo buro ari gagara dao Rhoda ami yavi ingido gain gupusina. ");
INSERT INTO bhg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ango edo gagara awa ainda ge yavi ingido awa Peter da dubo kariwabé gosisina. Edo gagara awa yawa eite guwa be pirigae, ata imo tenda egenembedo ainto tumundo embomai doda awamanede karigesisina awa, “Peter guwa beda petesira isira!” sisina. ");
INSERT INTO bhg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Imo duteta!” awamane ainde mina sitera. Ata gagara awa do jinenegedo, ge awa gebé tedo esisina. Ango edo awamanemi mina ainde sitera, “Awa ainda anela,” sitera. ");
INSERT INTO bhg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ata Peter tatain jiwari dowae matawa edo esisina. Ango esiri awamanemi maundo guwa be pirigedo embo awa gido bé korebakore esitera. ");
INSERT INTO bhg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Edo Peter mi awamane ge doworote kariwa ipami pipisisina. Ainda amboda, ami awamanede ge jijirisina nongo edo Badari mi imo gisijido kundo bundari oroda edo idegedo gumbiri. Edo awamanede sisina, “Mambuwo! Ge eiwa James ae Yesu da gebé ari embo neneinde tewo gore.” Ango tedo embo awa dodo yai neinda maunsisina. ");
INSERT INTO bhg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Edo sipo atesiri itoro embobo Peter tambari tao ae. Awatedo, awamane itadaita bajinabé eite mina tara esitera, “Nongo nongo edo embo eiwa udegesiri?” ");
INSERT INTO bhg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ango etero gido Herod mi ge okain tesiri itoro embo nenei maundo Peter kakowa edo tambae. Awatedo, Herod mi Peter da itoro sima ari embobo udugedo tedogosisina, “Peter nongo edo idegesiri?” Ata awamanemi Peter nongo edo idegesiri tari tao ae. Awa embo, Herod ge okain itoro embo neneinde tesiri awamane detero besitera. Ainda amboda, Herod yai Judea dodo wotedo nasi Seseria ainda isinesina. ");
INSERT INTO bhg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Awara, iji ainde Herod awa bé Taia nasi ae Saidoni nasi embomai de sinigambari bajinabé esisina. Iji gisi awa nasi tote (2)da embomai ami Herod da butuda indari budo esitera. Ata iji amboda, Herod mi nasi tote (2)da indari bari ango engiregesisina. Awarata, awamanemi indari awa tenda bain jipapa esitera. Awa embo, nasi tote (2)da embomai dada edo kotembari da (1) bureite béga bari embobo pietero Herod da yai guputera. Ango edo awamanemi Daotari Herod da buro embo dao Blastus otawo esitera. Edo awamane embo ainde tedogositera, béga bari deguta dave awamane embo sirigarate. ");
INSERT INTO bhg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Awatedo, deguta Herod avigesisina ainde, embo awa ainda daotarida ombarijiari dave omundo ainda daotarida anumbada anumbedo arapada embomai berarida jisida ge gorote tedo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Edo embomai aorogasite tedo esitera, “Embo emi ge sira awa embo enembo ae, ata god!” ");
INSERT INTO bhg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Edo boitebé Badari da anelami embo awa desiri dudurisina, aindabé Herod mi God dasiga ae, awatedo. Ango esiri kosisimami ainda deoboge indero besisina. ");
INSERT INTO bhg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ata gebé ari embomaimi God da bino dave embomai yai neneinda yai karigesiworo embomai nenei jiwaebé Yesu da yai gebé eiworo God da bino dave ango arapu edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Edo Barnabas ae Saul demi kondade ari buro itae edo John Mark budo ainde daedo Jerusalem dodo tenda overegedo Enteoki nasida guputera. ");
INSERT INTO bhg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Awara, Yesu gebé ari embomainda doregari Enteoki nasida isima edo esisina. Ainda doda peroveta mane de atopapasigari de eiwamane isiretera: Barnabas, Simeon (ainda dao nei awa Ingatapari), Lucius (imo awa nasi Sairin edo gumbari), Manaen (imo ae Daotari Herod Antipas de, awamane tote (2) otawo edo babojitera), edo Saul. ");
INSERT INTO bhg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Edo iji angode awamanemi Badari tumondebain eite indari dodo kakara ero Asisi Kotopu mi awamanede ge sisina, “Barnabas ae Saul de nato buro awa embo dao tetena. Awatedo, nato yaida katambedo pisiwo!” ");
INSERT INTO bhg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ango tesiri gido awamanemi indari dodo kakara eite benunu site embo tote (2)da tamonda ipa pisido ao edo pietero maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Awatedo Asisi Kotopu mi awamane tote (2) ango piesiri idegesitera. Edo awamane wotedo nasi Selusia da gundo un ma budo Saipurasi gategada maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ango edo awamane nasi Salamisi ainda denembedo visido Judah embomainda benunu oro evekarada aundo God da ge karigedo esitera. Edo John Mark awamanede daedo maunsite awamane kondade edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Edo awamane erido pepeta edo gatega ainda mendoda Papos nasida guputera. Edo nasi ainda awamanemi Judah embo dao Ba-Yesu taputera. Edo embo awa kae embo edo peroveta pitawa. ");
INSERT INTO bhg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Iji dá ainde embo Sergius Paulus awa gatega ainda gisijiari edo imo awa dubogari embo. Edo iji jiwae Ba-Yesu mi gisijiari ainde imapuma edo esisina. Ango edo gisijiari eiwa God da ge ingain, Barnabas ae Saul de ainda yai gumborote sisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ata kae ari embo dao Elymas (Ba-Yesu da dao Gurikida geda), ami awamane tote (2) engiregesisina. Embo awa gisijiarida kotembari bain eite God da ge awa gebé ainyae arate esisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ango edo Saul (ainda dao nei awa Paul) awa Asisi Kotopu mi gisijiri ainda jisi Elymas da yai pisido jijimbeteite sisina, ");
INSERT INTO bhg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Imo Binei da mai! Imo wasiri dambu darari berarida gitopo embo! Imo matawa ge pitawa embomainde site edo awamane tepotapo udumbedo eta. Imo iji da (1) dowae, Badari da gebé wareregato ge pitawa embomainda yai arate edo esita? ");
INSERT INTO bhg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Awatedo, boroko Badari da rirowa ito yai wotari ito jisi guba aina, edo iji tupo ijida parara mana gata.” Edo boitebé yopi ango ingataparimi ainda jisida wotedo apuregesisina. Ango esiri gido Elymas ipami dedo gain eite embo imo ipada jido kundo iarate kakowa esisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Iji ainde gisijiari awa buro bajina Elymas da yai idegesiri awa gido imo Badari Yesu da yai gebé esisina. Edo embo ami Badari da ge awa Paul ae Barnabas demi atopatero gido korebé esisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ainda amboda, Paul ae ainda buro otatawo demi Papos nasida dodo yai Pampilia da un made temundo Pega nasida denembesitera. Edo yai ainda John Mark awamane dodo overegedo Jerusalem da maunsisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ata Paul ae Barnabas demi Pega da dodo pepeta edo Enteoki nasida idegesitera, yai Pisijia ainda. Edo Oena Apari Degutade awamane maundo Judah embomainda benunu oroda torido anumbesitera. ");
INSERT INTO bhg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ango edo embo da (1)mi ge Moses mi gagurisinada kupo da (1) awa ajijigesisina, edo embo neimi ge peroveta manemi gaguriterada kupo awa ajijigesisina. Ajijigari itae etero gido benunu oroda babadegarimi ge engo awamaneda yai pietero maunsisina: “Nanonameji, edo gido imomane kondade ari ge nei embomainde tari jipapa ewa awa tewo ingore.” ");
INSERT INTO bhg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Awatedo, Paul erido petedo ainda ipa jiri eroreiri ge sisina, “Israel embomai edo imomane yai nei embomai ami God adu edo ewa daedo, nato ge ingiwo! ");
INSERT INTO bhg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","God eiwa, Israel embomaimi tumondebain edo era, ine natokare ewowo avigesisina. Edo iji angode awamane Egypt do ainda itero ami sima dave esiri awamaneda orobe bajido arapu esisina. Edo ainda gorobami imo awamane gisijido yai ainda dodo kundo arapada mambiri idegesitera. ");
INSERT INTO bhg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ango edo awamane idegedo maundo iji jiwaebé God da ge jindedo jimbo bebegae esitera. Awarata, God tataimbarimi awamane duberi 40 ango awa yai abu damodamoda sima dave edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Edo God mi Israel embomai kondade edo awamaneda gitopo emboboda orobeda doregari 7 Kanan butu ainda doda dedo sitedo itae esisina. Edo ainda amboda imo awamaneda butu natokare Israel embomainda topo arate kando pipisisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Ainda amboda awamanemi yai ainda itero God mi gisijijiegari pieuri awamane sima eoro duberi 450 ango itae esiri peroveta Samuel gupusina. ");
INSERT INTO bhg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ango esiri awamane Samuel da yai maundo daotari da (1) avigarate tedogositera. Awatedo, God mi Benjamin da ewowo ainda, Kish da mai, Saul, awa daotari barate sisina. Edo embo ami awamane duberi 40 gisijijisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ainda amboda, God mi Saul teugedo David awamaneda daotari arate avigesisina. Edo God David da yaida ge engo sisina, ‘Na David, Jesse da mai simagedo gena. Embo ainda dobé awa nato dobé ango. Embo awa buro berari na jipapa ena awa aina.’ ");
INSERT INTO bhg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Embo einda veda edo, God mi ainda tarigari ambo ambo eite Israel embomainda Toregari Embo kundo gupusina. ");
INSERT INTO bhg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu gumbae gisida, John mi Israel embomai beraride dengoro baiari pipisisina, awamaneda jimbo bebegae dodo God da yai wareregedo gundo bapataito ari borote. ");
INSERT INTO bhg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Edo iji ainde John ainda buro petugeteite ami sisina: ‘Na averi kotembetewa? Na Embo awa ae. Ata giwo! Embo amboda gumaina awa, nane atembedo ainda tai woru awa teugari tao ae.’ ");
INSERT INTO bhg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Nanonameji, Abraham da mamai edo imomane yai nei embomai ami God tou edo ewa daedo, God mi toregari ge eiwa imondemane piesiri gupusina. ");
INSERT INTO bhg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem da embomai ae awamaneda gisijijiegari demi Yesu gain daritera. Awamanemi peroveta maneda ge Oena Apari Deguta tegeride ajijigedo esitera. Awarata, awamane peroveta maneda ge Yesu da yaida gaegae esitera. Awatedo, iji angode embo awa betarida kasitera awa, peroveta maneda ge etero bé esisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Edo awamanemi ge bé nonda petedo embo awa daro betaini tambari tao ae. Ata awamane maundo Pilate de tedogositera embo awa ainda itoro emboboda yai piari daro betarate. ");
INSERT INTO bhg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Edo iji ainde, amboda awamanemi ro berari oveda gaiari embobomi ainda yaida gaguritera awa etero bé esisina, ainda tamo oregada awa kundo wotedo banga toda pipisitera. ");
INSERT INTO bhg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ata God mi embo awa betarida jiri erorisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Edo embomai imonde daedo yai Galili edo Jerusalem ainda pepeta edo guputera, awamanemi deguta jiwae embo awa gositera. Edo boroko awamanemi ainda daoda ge awa Judah embomainde karigedo era. ");
INSERT INTO bhg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Edo nanekaremi bino dave eiwa imondemane karigetera, God mi mamono kaenatode tarigari ro sisina awa. ");
INSERT INTO bhg_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","God tarigari awa esiri bé esisina awamaneda mamai kaena awa embo, Yesu jiri vivisisina. God da ge Psalm tote (2)da gaiarida awa dá ango: ‘Deguta boroko, nanemi embomai berarida yai arapa eteno gera awa, imo awa nato Mai bé edo na awa ito Mamo bé.’ ");
INSERT INTO bhg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Edo daedo, God mi embo awa betarida edo jiri erorisina, edo imo tekago betedo depeka ainyae. Awatedo, God mi kaenato ewowode ge engo sisina: ‘Na imomane ao ana dá ango David ao ana tarigari sitena.’ ");
INSERT INTO bhg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Awatedo, David mi Psalm neinda site sisina: ‘Ito Embo Kotopu da tamo mana dowato depeka aina.’ ");
INSERT INTO bhg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Edo David mi God da jipapada ainda embomai embo buro eite sima edo esisina. Edo ainda amboda embo awa betesiri dá ainda mamono goitera ango goietero tamo depeka esisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ata dabé eiwa God mi jiri vivisisina, ami depeka ae esisina. ");
INSERT INTO bhg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Awatedo, kaenato nanonameji, nakare ge eiwa imondemane karigesite bé gawate jipapa era. Embo einda toda itomane jimbo bebegaeda kotembari dowari bawa. ");
INSERT INTO bhg_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Edo ainda toda embomai berari ainkain gebé ara, awamaneda jimbo bebegae berari ainda bekumbada udegari bara. Ata Moses da Aodarimi itomane jimbo bebegaeda bekumbada udegari tao ae. ");
INSERT INTO bhg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Bé gidogogo ewo! Peroveta manemi ge ro sitera awa, itomane yai idegeure: ");
INSERT INTO bhg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Edo giwo tedojirari embomai! Korebé edo aimbuwo betave! Nanemi itomane ijide buro ena. Edo embo da (1)mi imondemane​ ​buro ro gumaina karigaina, imomane gebé ae!’” ");
INSERT INTO bhg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Edo Paul ae Barnabas de iji ainde Judah embomainda benunu oro dodo, idegetero yai nei embomai God adu edo era ami awamanede engega esitera, Oena Apari Deguta neinde gundo ge eiwa awamanede karigaro gain. ");
INSERT INTO bhg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Edo doregari awa itae edo evekara etero, Judah embomai jiwae ae embo nenei ami Judah embomainda God da yai matu wareregari de, awamane Paul ae Barnabas de ambo ambo esitera. Ango etero Paul ae Barnabas demi awamanede kondade ari ge tedo God da dave arida awa matawa gebé eite aimborote sitera. ");
INSERT INTO bhg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Edo Oena Apari Deguta neinde, aikaebé embo berari nasi bajinada gundo God da ge awa ingain guputera. ");
INSERT INTO bhg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Edo iji angode Judah embomaimi embo jisijisi gido awamane jitari bajinabé edo ge bebegae ae ajiregari de site Paul da ge ro siri awa patain esitera. ");
INSERT INTO bhg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ango edo Paul ae Barnabas demi bé do jinenegedo petedo ge sitera, “God da jipapa awa ainda ge gisibé imondemane karigorote sisina. Ata, imomane God da ge ajiregetewa, edo inemane akuta katedo imomane awa inono ae. Awatedo, wasiri natopo itari bari tao ae edo nakare dodo Judah embomai aeda yai wareregedo mambara. ");
INSERT INTO bhg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Aindabé, Badari mi ge okain eiwa namondekare pipisisina: ‘Nanemi imo awa parara ango piana, Judah embomai ae awamaneda yai. Edo imo butu umbugo berarida​ ​tonembari kundo mambato bara.’” ");
INSERT INTO bhg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Edo iji dá ainde Judah embomai aemi ge eiwa ingido do yawa eite Badari da ge dasiga edo esitera. Edo embomai avekave God mi wasiri natopo itari borote avigesiri, awamanemi gebé esitera. ");
INSERT INTO bhg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Edo gebé ari embo jiwaemi Badari da ge yai ainda umbugo berarida kundo aundo karigesiworo simundo arapu euri embomai nenei jiwaemi gebé edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ata Judah embomaimi eutu babain God tou edo esitera, awamane ae gisijijiegari embo de nasi bajina ainda isiretera awa ao gaietero Paul ae Barnabas de memesi neindekainde piaro yai awa dodo idegorote onjitera. ");
INSERT INTO bhg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ango edo Paul ae Barnabas demi konipo taida awamane kena denden edo dodo Ikonium nasida maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ata ambodani avekave Enteoki nasi ainda isite do yawa bajinabé edo esitera, edo Asisi Kotopu mi awamane gisijido esisina. ");
INSERT INTO bhg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Edo iji angode Paul ae Barnabas demi Ikonium nasida maundo idegedo, awamane Judah embomainda benunu oro ainda totoritera dá ango awamane tote (2) matawa edo esitera. Edo awamanemi God da ge bé dave edo tetero Judah embomai ae Guriki embomai de jiwaebé gebé esitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ata Judah embomai ainkain Yesu da yai gebé ae esitera, awamanemi yai nei embomai ao gaiedo kotembari beyae pietero wareregedo gebé ari embomainde sinigambari orote esitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ango edo Paul ae Barnabas de iji ribori ainda isite Badari da daoda do jinenegedo ge karigesitera. Edo Iji dá ainde, Badari da dave arida ge embomainda yai arapa eiuri awamane tote (2)da ipami kariwa neindekainde wasiri babainde ainda gorobami edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ata, embo jisi bajinabé nasi bajinada bededo kupo nei Judah embomainda yai mauntero, kupo nei Yesu da piari aimbari emboboda yai maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Edo yai nei embomai ae Judah embomai de, edo awamaneda gisijijiegari de daedo, ami Paul ae Barnabas de usibesi ain edo ganumami augedo dain esitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Edo ge ango tetero ingido boraebé erido dodo nasi babain Laisitara ae Debi de, yai Laikonia doda ainda maunsitera, edo yai nenei ainda demonda. ");
INSERT INTO bhg_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Edo yai ainda isite God da bino dave awa karigedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Edo nasi Laisitara ainda embo da (1) awa anumbedo isima esisina. Ainda tai awa ambari. Imo awa baoro bundari aida urida edo idegesisina. Edo ainto ae isima edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ango edo embo awa yai ainda anumbedo isite Paul ge siri ingisina. Edo Paul embo awa jijimbedo goteite, embo ainda gebé ari Yesu da yai ami God mi ari kaviyegaina, awa gosisina. ");
INSERT INTO bhg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Awatedo, Paul embo ainde ge yavi ikanade sisina, “Erido tai itomi darido dave edo peteyo!” Edo embo awa tuturo edo kekapunya kakapunya edo jiroro eite pepeta esisina. ");
INSERT INTO bhg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Iji angode embo jisijisimi Paul buro ro esiri awa gido aorogatedo Laikonia gemi tedo esitera, “Eiwamane awa god tote (2) ami embo enemboda kariwa budo kaenato yai wotedo gumbera!” ");
INSERT INTO bhg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Edo awamanemi kotembesitera, Barnabas awa god neneinda gisijiari bajina. Awatedo, ainda dao awa Zeus tedo esitera. Aindabé Paul ge jiwaebé tedo eiri awamanemi kotembesitera, Paul awa god neneinda bino piari embo. Awatedo, ainda dao awa Hermes tedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Edo awamaneda nasi bajinada dombu arapada god Zeus da dasiga oro ainda isinesina. Ango edo god Zeus da pirisi awa nasi guwa beda wo kao nenei edo giro rorae aroro ari igide kokode daedo kundo gupusina. Edo imo ae embo jisijisi demi wo daro betaro embo tote (2)de rorou ango piain jipapa esitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ata, Yesu da piari aimbari embobo, Barnabas ae Paul demi burobé roro eri ainda ge awa ingido awamaneda ombari tamoda jiero keresiri embo jisi da ainda toropuda aorogatedo tupeite awamanede sitera, ");
INSERT INTO bhg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“O gewa, embomai! Ro awa embo imomane buro engo awa evi? Nakare awa daedo embo enembo dá ango imomane dobé, edo bino dave imondemane karigain gumbera. Nanekaremi God béda ge itomane yaida karigaro gido ove kewari imomane kondade ari tao ae eiwa dodo God wasiri deda yai wareregawate. Embo ami utude, butude, ewade, edo rorae berari awamaneda doda itera ainde awa esisina. ");
INSERT INTO bhg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Edo iji matubé ainde God mi embomai berari awamaneda jipapa akuta ambo ambo orote doturisina. ");
INSERT INTO bhg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Awarata, embo ami akuta ainda dave ari kaenato yai arapa euri gotora. Embo ami wa utuda edo pipitevina, edo yoa tegerida pieuri gumburi indari rorae butuda erorevina. Edo embo awa indari rorae jiwaebé edo dubodave jiwae kaenato yai pisido eira.” ");
INSERT INTO bhg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ango edo embo jisijisi awamaneda ge ingitera, ata awamanemi matawa eite rorou Paul ae Barnabas deda yai siya edo piain esitera. Awarata, iji beao bé ainde, awamanemi kotembari eve budo rorou piari awa doturitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ango edo Judah embo nenei nasi Pisijia Enteoki ae Ikonium deda ami yai ainda guputera. Edo awamanemi embo jisijiside demonda ge jirido awamaneda do bero awamanemi Paul ganumami augedo doritera. Edo awamanemi embo awa bé betari kotembesite imo dumundo nasi bajina arapada kundo idegesitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ata, iji ainde ambodani dada edo Paul da yai jiroro edo petedo itero, imo erido nasi bajinada tekago aundo totorisina. Edo sipo neinde Paul ae Barnabas de dodo Debi nasida maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Edo awamanemi God da bino dave Debi da karigedo ambodani jiwae buritera. Ainda edo awamanemi tekago overegedo maundo Laisitara, edo Ikonium, edo Pisijia Enteoki nasida ainda maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Edo awamanemi ambodanide nasi da da ainda kondade ari ge tedo esitera, Yesu da yai gebé eite itorote. “Nakaena God da gisijiari yaida torae gisida memesi neindekaindeda toda mambara,” awamanemi sitera. Angomi ambodanida dobéda goroba ari bajido esisina. ");
INSERT INTO bhg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Edo Paul ae Barnabas demi Yesu gebé ari embomainda doregari berari da da, ainda orobeda kopuru mamai avigedo awamanede daedo indari dodo veta kakara eite benunu tedo esitera. Ainda amboda, Paul ae Barnabas demi awamane berari ainkaimi Badari da yai gebé esitera awa ainda sima ari daveda piedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ainda edo yai Pisijia pepeta edo temundo awamanemi yai Pampilia ainda guputera. ");
INSERT INTO bhg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Edo awamanemi God da ge Pega nasi embomainda yai karigedo dodo Attalia nasida wotedo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ango edo awamane nasi ainda awa dodo un made Enteoki nasida guputera. Edo Paul ae Barnabas deda pepeta ari mambae gisida awa gebé ari embomai nasi ainda ami God da sima ari dave awamane embo benunu sitera. Edo iji ainde embo tote (2)da pepeta ari buro itae esitera, awamane tekago Enteoki nasida guputera. ");
INSERT INTO bhg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Edo iji nonde awamane nasi ainda gundo Yesu gebé ari embomainda doregari dao tedo dada edo, God mi buro berari ro awamaneda toda esiri, edo God mi gebé arida manguro Judah embomai aeda yai pirigesiri, awa tetero gositera. ");
INSERT INTO bhg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Edo awamane iji ribori ainda isima edo esitera ae ambodani de daedo. ");
INSERT INTO bhg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Edo embo nenei Judea edo nasi bajina Enteoki ainda wotedo gundo nanonameji atopapositera, “Dabé awa imomane tamo jiugawate dá ango Moses mi aodarida sisina awa bawa. Ata awa ae gido, itomane tonembari mana bawa.” ");
INSERT INTO bhg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Awatedo, Paul ae Barnabas demi awamanede bemi duduno edo ge jiwae baitera. Ango edo gebé ari embomaimi Paul ae Barnabas de, edo embo nenei awamaneda doda daedo avigedo awamanemi tedogari eiwa kundo Yesu da piari aimbari embobo ae orobeda kopuru mamai de Jerusalem da itera awamaneda yai maundo vitorote sitera. ");
INSERT INTO bhg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Awa embo, Yesu gebé ari embomainda doregarimi awamane pietero maunsitera. Edo iji dá ainde yai Poenisia torido idegedo yai Samaria torido maunsite awamanemi nongo nongo edo God mi esiri yai eve embomai ainda yai wareregesiteri awa gebé ari nanonamejide tedo esitera. Edo nanonamejimi bino awa ingido awamane berari do yawa bajinabé edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Edo iji ainde Paul ae Barnabas de embo neneinde Jerusalem gumbero, Yesu gebé ari embomainda doregari ae piari aimbari embobo de orobeda kopuru mamai demi awamane ategesite buritera. Edo Paul ae Barnabas demi buro berari ro awamaneda toda God mi esiri awa tetero gositera. ");
INSERT INTO bhg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ata gebé ari embo nenei Parasi maneda doda awamanemi erido sitera, “Yai nei embobo tamo jiugedo Moses da Aodari awa jidogogo orote!” sitera. ");
INSERT INTO bhg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ango edo piari aimbari embobo ae orobeda kopuru mamai de gundo dada edo ge eiwa katain orote sitera. ");
INSERT INTO bhg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Edo iji amboda awamane ge iji riboribé baietero, Peter erido awamanede ge sisina: “Embobo ae nanonameji de, imomane gotewa iji matu God mi kaenato toropuda ainda na avigesisina, bino dave, be natoda awa, yai nei embomaimi ingido gebé orote. ");
INSERT INTO bhg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Edo God mi embomainda do gido eira. Awatedo, iji ainde ainda Asisi Kotopu awamaneda yaida pipisisina dá kaenamonde pipisisina ango, God mi awamaneda yai arapa esiri gositera, imo yai nei embomai daedo ategedo burisina. ");
INSERT INTO bhg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Edo God wasiri kaenamonde eve edo awamanede eve ae. Ata iji ainde awamanemi Yesu da yai gebé etero, God mi awamaneda do teiesiri dave esitera. ");
INSERT INTO bhg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Edo boroko, ro awa embo imomane God bavevi? Imomane bouga ambodanida duboda pipitewa. Bouga awa kaena ko mamono kaenatomi inono barita? ");
INSERT INTO bhg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ango ae! Ata kaena gebé era, God mi Badari Yesu da dave arimi kaena tonembedo eira dá ango ami awamane tonembedo eira.” ");
INSERT INTO bhg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Edo embo jisi bajina awamane berari ge tokain takain edo Barnabas ae Paul demi kariwa neindekainde wasiri babain jiwaede awa God mi awamaneda toda yai nei embomainda yaida esisina awa udugedo tero ingitera. ");
INSERT INTO bhg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Iji angode awamane ge tedo itae etero, James mi ge engo sisina: “God gebé ari embomai, ge nato ingiwo! ");
INSERT INTO bhg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon mi kaenamonde karigesira, God nongo nongo edo tuturoda yai nei embomainda yai etega edo awamaneda doda ainda embomai topobé bain esisina awa. ");
INSERT INTO bhg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Edo peroveta maneda ge berari ami awara eira, edo daedo ge engo matu gaiedo tari isira: ");
INSERT INTO bhg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Einda amboda, na tenda egenembedo, David da bowa dudurisina awa tekago gamana. Ainda durudo usibesibé arida awa ano dave ari, tekago jiano eraina. ");
INSERT INTO bhg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ango edo embo nenei berarimi na, BADARI awa,​ ​gain edo gara, yai nei embomai berari daedo, avekave nanemi nato topobé orote dao sitena. Na, BADARI ami, buro berari engo edo ena,​ ​awatedo ge eiwa tena.’” ");
INSERT INTO bhg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Edo James mi ge ango tedo sisina, “God mi ainda buro berari imo matu natopo itarida edo gundo esisina awa gari. ");
INSERT INTO bhg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Awatedo, kotembari nato awa kaenane mana ano yai nei embomai awamanemi God da yai wareregedo era awa awamaneda do buriya aina. ");
INSERT INTO bhg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ata davebé awa, kaenanemi awamaneda ove gaiedo taro gara, indari ove kewaride rorou pisido era awa donode God da jisida, awatedo inainyae. Daedo viro ko ipuda ari ainyae, edo wo asimi duboda kaingari betari awa inainyae, edo ororo inainyae. ");
INSERT INTO bhg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Aindabé, embomai iji matu edo gundo boroko awamanemi Moses da ge tari awa nasi babain berarida karigedo era. Edo Oena Apari Deguta beraride Judah embomainda benunu oroda ainda ge awa ajijigedo era, awatedo.” ");
INSERT INTO bhg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ango edo Yesu da piari aimbari embobo ae orobeda kopuru mamai de edo Yesu gebé ari embomainda doregari berari de daedo, awamanemi James da ge awara esitera. Edo awamaneda doda embo nenei avigedo Enteoki nasida piaro mamborote, Paul ae Barnabas de daedo sitera. Edo awamanemi Judas, ainda dao nei awa Barsabas, ae Silas de awa avigesitera. Embo tote (2) awa nanonamejida gisijijiegari. ");
INSERT INTO bhg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Edo ove eiwa awamanemi pietero kundo gebé ari embomainda yai Enteoki nasida ainda maunsitera: Nakare, Yesu da piari aimbari embobo ae orobeda kopuru mamai de nanonameji demi, Imomane yai nei embomainda nanonamejide, Enteoki nasida, edo Siria yaida edo Silisia yaida isima edo ewa awa: Ategedogogobé era. ");
INSERT INTO bhg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Edo nakare ingera awa, embomai nenei natokare yai edo idegatara, awamaneda gemi etero imomane anana eutawa edo do itomane awa buriya eutara. Awamanemi site siutara awa, ‘Imomane awa tamo jiugawate,’ edo ‘Aodari awa ambo ambo awate,’ siutara. Awarata, nakare awamanede ge ango awa imondemane torote tae. ");
INSERT INTO bhg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ango edo, nanekare berari kotembari da (1) edo doregedo awara edo embo nenei avigedo itomane yaida piaro mamborote etera, natokare dubobari otatawo Barnabas ae Paul de daedo. ");
INSERT INTO bhg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Awamane tote (2)mi Badari Yesu Keriso da daoda buro edo maundo betari tao edo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Edo daedo, nakare Judas ae Silas de avigedo itomane yaida pietero mambera. Awamanemi ge dá ango ove gaiarida awa taro gawa. ");
INSERT INTO bhg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Edo Asisi Kotopu ae namondekaremi awara tetera awa, nakare mana imondemane bouga bajinabé piara, ata bouga tega inono eiwawa akuta: ");
INSERT INTO bhg_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Imomane indari ove kewaride piedo era awa inainyae, edo ororo inainyae, edo wo asimi duboda kaingari betari awa inainyae, edo viro ko ipuda ari ainyae. Imomane roviravi eiwa daginegawa gido awa buro dave awa. Imomane dave edo isiwo! ");
INSERT INTO bhg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Awatedo, awamane pietero wotedo maundo Enteoki nasida idegesitera. Edo gebé ari embomai yai ainda awa kundo dada edo ove awa pipisitera. ");
INSERT INTO bhg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ango edo awamanemi ove awa ajijigedo gido kondade ari ge dave ami esiri dubo yawa bajinabé esitera. ");
INSERT INTO bhg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Edo Judas ae Silas de, awamane akuta awa daedo peroveta maneda buro edo esitera. Awatedo, awamanemi kondade ari ge dave jiwaemi nanonamejide tetero awamaneda gebé ari babojisina. ");
INSERT INTO bhg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Edo amboda awamane yai ainda sima ero jiriri nanonamejimi awamanede sitera, “Yesu da piari aimbari embobode tewo gore, ‘Badari da béga itomane yaida itare!’” Ango tedo awamane tekago Jerusalem da piaro mamborote pipisitera. ");
INSERT INTO bhg_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Awarata, Silas yai ainda itari jipapa esisina. ");
INSERT INTO bhg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Edo Paul ae Barnabas de matawa Enteoki ainda sima esitera. Edo aedade embo jiwae neneinde daedo ami Badari da ge embomai yai ainda awa atopasido karigedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Edo deguta nenei itae esiri ainda amboda, Paul mi Barnabas de sisina, “Puyo inge egenembedo nasi babain berarida ingena Badari da ge matu karigesitera ainda tekago mambore. Edo ingenato nanonameji yai ainda awa etega eite, awamane buro nongo eite iteri awa gore.” ");
INSERT INTO bhg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ango edo Barnabas mi John Mark awa kundo awamanede daedo mamain jipapa esisina. ");
INSERT INTO bhg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ata Paul mi arapada karigedo sisina, embo matu yai Pampilia ainda awamane dodo taigedo maunsisina, awa kundo daedo buroda mamainyae sisina. ");
INSERT INTO bhg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Edo embo tote (2) ge bajinabé baiedo buro dada ainyae tedo evekara esitera. Ango edo Barnabas un made Mark kundo dodo gatega Saipurasi da tepusina, ");
INSERT INTO bhg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ata Paul mi Silas geredo burisina. Edo nanonameji Enteoki ainda ami, God mi Paul awa sima ari dave arate benunu tetero idegedo maunsisina. ");
INSERT INTO bhg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Edo imo maundo yai Siria edo yai Silisia da torido idegedo eite ainda Yesu gebé ari embomainda doregari evekara awa kondade eiuri awamaneda gebé ari Badari da yaida awa bajido esisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ango edo Paul awa nasi Debi gundo aundo nasi Laisitara esisina. Edo ambodani da (1) dao Timothy, yai ainda isima edo esisina. Edo ainda ai awa Judah eutu ami Yesu gebé esisina. Ata ainda mamo awa Guriki embo. ");
INSERT INTO bhg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Edo nanonameji Laisitara edo Ikonium nasida ami ainda daoda ge davegave tedo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ango edo Paul embo awa kundo daedo pepeta ain jipapa esisina. Aindabé Judah embobo yai nenei ainda isima esitera, awamane berari garibé embo ainda mamo awa Guriki, awatedo, Paul mi embo ainda tamo jiugesisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ango edo awamane pepeta edo nasi babain ainda torido idegedo eite awamanemi aodari ro awa Yesu da piari aimbari embobo ae orobeda kopuru mamai demi Jerusalem ainda katedo Judah embomai ae awa kera orote teoro gido esitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Awatedo, God mi Yesu gebé ari embomainda doregari yai tegerida kondade euri awamaneda tumonda ari Badari da yai goroba bureite, edo deguta da (1) dowae awamaneda ajijigari bajido esisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ango edo Paul ae ainda buro ari otatawo de pepeta edo yai Perijia edo yai Galesia torido idegedo aimbero, Asisi Kotopu mi yai Asia ainda embomainde ge karigeorekae engiregesisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Edo awamane yai Maisia atutumbedo yai Baitenia torain tedo esitera. Ata Asisi Kotopu mi awamane tororekae dowae esisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Awatedo, awamane yai Maisia daginegedo dodo aundo Toroas nasida wowositera. ");
INSERT INTO bhg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Edo muyaende Paul mi garago giragoda Masedonia embo da (1) petedo embo ainda yai atega eiri gosisina, “Imo temundo gumbuyo Masedonia edo nakare kondade ate!” sisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ainda amboda Paul mi garago girago giri, nakare ge katedo God mi nakare dao sisina, ainda bino dave awamanede karigorote. Awatedo, nakare boraebé siya edo Masedonia mamain esitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Awatedo, Toroas ainda edo nakare ewada made gaigedo idegedo dambu darari Samoteras gategada maunsitera. Edo deguta neinde Niapolisi nasida gundo denembesitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Edo Niapolisi dodo nakare butuda pepeta edo Pilipai da guputera. Awa nasi bajina dariga yai Masedonia ainda da (1). Edo nasi bajina awa Rome da sima ari daveda isima edo esisina. Edo nakare deguta nenei ainda isima esitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ango edo Oena Apari Degutade nakare nasi bajina idegedo un bengida maundo yai nonda embomaimi matawa gundo benunu teora awa taputera. Edo nakare anumbedo eutumai matu gundo dada etero awamanede ge sitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Edo eutu da (1)mi natokare ge ingeite isima esisina, ainda dao awa Lydia. Edo eutu awa gongo ove tokona de oriedo esisina. Eutu awa Taiyataira nasi bajina eutu edo God tumondebain edo esisina. Edo Badari mi ainda do pirigesiri Paul da ge ingido gebé esisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ango edo eutu awa ae embomai berari ainde daedo isima edo esitera, awamane bapataito esitera. Edo eutu ami namondekare tedogosisina, “Inemanemi na awa Badari gebé ari eutu gido ewa gido, gumbuwo edo namonde daedo mando natoda kaen itane!” Edo eutu ami nakare atega edo dowae esiri ainda yai maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Edo iji angode, nakare benunu tari yaida auntero, buro gagara da (1)mi nakare tapusina. Edo gagara awa asisi beyaemi gisijijieiuri ima edo esisina, edo iji ambo awa tedo esisina. Edo gagara ami emboda iji ambo awa teuri ainda badararimi ganu jiwaebé budo esitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Gagara emi nakare ae Paul de ambo ambo eite aorogatedo tedo esisina, “Embomai eiwa God Ikanebé ikane ainda buro ari embobo! Amimi kaenamonde tonembarida begata awa ganate karigetera.” ");
INSERT INTO bhg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ango edo gagara awa ge engo deguta jiwae teuri gido esitera. Ata Paul do buriyabé esiri wareregedo asisi ainde sisina, “Yesu Keriso da daoda imonde ge okain tena. Gagara eiwa dodo idege!” Edo dá iji ainde asisi awa dodo idegesisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ata iji nonde, buro gagarada badararimi awamaneda ganu bari begata itae esiri gido gido, Paul ae Silas de kundo dumundo origarori ari yaida torido nasi bajinada gisijijiegarida yaida esitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Edo awamane kundo gundo sitera, “Embomai eiwa Judah embomai, edo awamanemi nasi bajina kaenato embomai awa ero do buriya bajinabé eira. ");
INSERT INTO bhg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kaena awa Rome embomai. Awatedo, kaenanemi kaenato Rome da ewowo gawowoda atopatari ae aodari de ambo ambo edo era. Edo embo eiwamanemi kaena Judah ewowo gawowoda atopatari ambo ambo orote jipapa era. Edo ango ara, kaenato aodari daro erigaina.” ");
INSERT INTO bhg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ango edo embo jisi da gundo dada edo Paul ae Silas de daedo bekumba esitera. Edo gisijijiegarimi tetero itoro embobomi Paul ae Silas deda ombari jiari jiero kokumbesiri awamane ikutami vedorote sitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Edo amboda awamane vedetero kambo jiwae etero bundari oroda pietero torero bundari oro sima ari embode ge okain tedo sima dave arate sitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ango edo bundari oro sima ari embo ge eiwa budo embo ami awamane awa bundari oroda dobéda piedo awamaneda tai awa ikuta dugada sinegesiri torero bunjisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ata muyae toropuda Paul ae Silas de God da yai benunu site ya site itero bundari embobo nenei awamane ingero jijirisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Edo boraebé jijira duga ami bundari oroda dasivi awa jipisina. Edo iji dá ainde bundari oro manguro berari jipesiri pirigesiri embo berarida asi okain aurimi ari awa udedegedo duduritera. ");
INSERT INTO bhg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ainda amboda, bundari oro sima ari embo jitao dodo erido oro manguro pirigari gido, bundari embomai awa erido idegari kotembesite, ainda kasiwo budo akuta gaiedo betain esisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ata Paul mi aoro ikanade gatedo sisina “Imo akuta kambo piote! Nakare berari itera evire!” ");
INSERT INTO bhg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Edo bundari oro sima ari embo parara atega edo tumundo gundo yai ainda toriri Paul ae Silas deda taida ipatai jipeiri baongo dadari esisina. ");
INSERT INTO bhg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Edo embo ami Paul ae Silas de kundo idegedo awamanede tedogosisina, “Dave embobo, na buro nongo edo tonembari bani?” ");
INSERT INTO bhg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Edo awamanemi mina sitera, “Badari Yesu Keriso da yai gebé eyo, edo imo tonembari bata. Imo ae embomai berari imo daedo isima edo era ainde, imomane berari awa begata dá awara ami tonembari bawa.” ");
INSERT INTO bhg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ango edo awamane Badari da ge embo ainda yai sitera edo embo berari ainda mandoda itero, awamanede daedo. ");
INSERT INTO bhg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Edo muyae dá ainde bundari oro sima ari embo Paul ae Silas de budo aundo, awamaneda kambo awa un mi teisina. Edo ainda amboda, embo awa ae ainda orobe berari de bapataito esitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ango edo bundari oro sima ari embo Paul ae Silas de kundo gundo ainda mandoda torido indari awamaneda yai piesiri injitera. Edo embo awa ae embomai berari imonde daedo isima edo esitera, awamane God da yai gebé esitera. Awatedo, awamane dubo yawa bajinabé esitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Edo sipo atesiri gisijijiegarimi itoro embobo pietero bundari oro sima ari emboda yai maunsitera, ge okain engo embo ainde torote sitera, “Embobo awawa udegeyo mambore!” ango sitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Edo bundari oro sima ari embomi ge eiwa Paul de sisina, “Gisijijiegarimi imo ae Silas de awa udegano idegawate tetera. Awatedo, imomane boroko idegedo aimbuwo bégade.” ");
INSERT INTO bhg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ata Paul mi itoro embobode sisina, “Awamanemi nakare, Rome embobo, katae dodo emboda jisida vededo bundari oroda pietera. Ango edo boroko onjigarida nakare dowain tera. Ata ango ainyae! Awamanemi akuta gundo nakare kundo idegore.” ");
INSERT INTO bhg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Edo itoro embobomi maundo gisijijiegaride ge eiwa pietero, awamanemi Paul ae Silas de awa Rome embobo awa gido adu esitera. ");
INSERT INTO bhg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Edo gisijijiegarimi gundo awamanede engega esitera. Edo awamanemi Paul ae Silas de bundari oroda kundo idegedo tedogido esitera, “Nasi bajina awa dodo aimbavi?” ");
INSERT INTO bhg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ango edo Paul ae Silas de bundari oroda awa dodo idegedo, Lydia da mandoda maundo nanonameji yai ainda etega edo, kondade ari ge awamanede tedo yai awa dodo maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ango edo Paul ae Silas de pepeta edo maundo nasi Ampipolisi edo nasi Apolonia torido idegedo maundo nasi Tesalonaika, ainda guputera. Edo yai ainda awa Judah embomainda benunu oro isima edo esisina. ");
INSERT INTO bhg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Edo Paul da wasiri matawa edo esisina, ami aundo Judah embomainda benunu oroda totorisina. Edo Oena Apari Degutade pura tamonde (3), inemi God da Ge Gaiari bureite awamanede ge mina tara esisina. ");
INSERT INTO bhg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Edo embo ami ge udugedo arapa eite atopaposisina awa, Keriso awa memesi budo betedo tekago eraina. Edo ami sisina, “Yesu eiwa nane imondemane karigeteno ingewa awa Keriso.” ");
INSERT INTO bhg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ango edo Judah embo nenei Paul da ge awa gebé edo gundo Paul ae Silas de dada esitera. Edo Guriki embo jisi bajina ami God tumondebain edo esitera, awamane ae eutumainda gisijijiegari jiwae demi daedo Paul ae Silas deda yai gundo dada esitera. ");
INSERT INTO bhg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ata Judah embomai neneimi God da ge awa gebé ae edo jitedo awamanemi embo bebegae origarori ari yaida tamundo kundo embo nenei daedo kundo dada eite nasi bajinada embomai berari ao gaietero yavi bajinabé esitera. Edo awamane tumundo Jason da mandoda Paul ae Silas de tamundo kundo idegedo embomainda arapada katain esitera. ");
INSERT INTO bhg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ango edo, ata awamanemi embo tote (2) awa tambae. Awatedo, Jason ae nanonameji neneinde dumundo nasi bajinada babadegarida yai kundo maunsite aorogasitera, “Embomai emi yai berarida buriya edo era. Boroko awamanemi nasi kaenato einda daedo gumbera. ");
INSERT INTO bhg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Edo Jason mi awamane ategedo ainda mandoda burara. Edo awamanemi Yesu awa daotari nei site, rare, Caesar da aodari babain deoro erigedo eira.” ");
INSERT INTO bhg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ango edo embo jisi bajina ae nasi bajinada babadegari demi ge eiwa ingido awamaneda do buriya esisina. ");
INSERT INTO bhg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Awatedo, nasi bajinada babadegarimi ge katedo, Jason ae ainda otatawo de awamaneda yai ganu pietero budo buriya nenei tekago eorekae sitera. Edo buriya nenei ae aro gido awa awamaneda ganu tekago piaro borote sitera. Ango tedo awamane dotero maunsitera. ");
INSERT INTO bhg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Edo boraebé muyae dá ainde nanonameji yai ainda ami Paul ae Silas de pipisitera, Beria nasida mamain. Edo iji ainde nasi ainda idegedo, awamane Judah embomainda benunu oroda maundo totoritera. ");
INSERT INTO bhg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Edo embomai yai ainda awa bé jiro pirigari Tesalonaika embomai ango ae. Edo awamanemi God da ge bé dubodave eite buritera. Edo deguta berari awamanemi God da Ge Gaiari ajijigedo dave edo gido esitera, ge ro Paul mi sira awa gebé rita ko gebé ae ri. ");
INSERT INTO bhg_vpl VALUES ("AC17_12