﻿USE sofia;
DROP TABLE IF EXISTS sofia.bhd_vpl;
CREATE TABLE bhd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bhd_vpl WRITE;
INSERT INTO bhd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","अब्राहमेरी औलादी मरां दाऊद राज़ो थियो, दाऊद राज़ेरे औलादी मरां यीशु मसीह थियो। यीशु मसीहेरे दादे-पड़दादां केरां नंव्वां इना आन। ");
INSERT INTO bhd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहमेरू मट्ठू इसहाक थियूं, इसहाकेरू याकूब, याकूबेरां मट्ठां यहूदा ते तैसेरे ढ्ला थिये। ");
INSERT INTO bhd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदा ते तामारेरां मट्ठां पेरेस ते जेरह थियां, पेरेसेरू मट्ठू हेस्रोन, हेस्रोनेरू एराम, ");
INSERT INTO bhd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ते एरामेरू अम्मीनादाब, अम्मीनादाबेरू नहशोन, नहशोनेरू सलमोन, ");
INSERT INTO bhd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ते सलमोन ते तैसेरी कुआन्श राहाबेरू मट्ठू बोआज थियूं, ते बोआज ते तैसेरी कुआन्श रूतरू ओबेद, ओबेदेरू यिशै, ");
INSERT INTO bhd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ते यिशैरू मट्ठू दाऊद राज़ो थियो, दाऊद राज़ेरू मट्ठू सुलैमान तैस कुआन्शी सेइं पैदा भोव, ज़ै पेइली ऊरिय्याहरी कुआन्श थी। ");
INSERT INTO bhd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सुलैमानेरू रहबाम, रहबामेरू अबिय्याह, अबिय्‍याहेरू आसा, ");
INSERT INTO bhd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ते आसारू यहोशाफात, यहोशाफातेरू योराम, ते योरामेरे खानदानेरे मरां उज्जियाह पैदा भोव। ");
INSERT INTO bhd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्जियाहरू योताम, योतामेरू आहाज, आहाजेरू हिजकिय्‍याह, ");
INSERT INTO bhd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ते हिजकिय्‍याहेरू मनश्शे, मनश्शेरू आमोन, आमोनेरू मट्ठू योशिय्याह थियूं ");
INSERT INTO bhd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ते योशिय्याहेरां पोट्लड़ां यकुन्याह ते तैसेरे ढ्ला थिये, ज़ैना गिरफ्तार भोइतां बाबेलेरी गुलैमी मां गानेरे वक्ते मां ज़र्मोरां थियां। ");
INSERT INTO bhd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","गिरफ्तार भोइतां बाबेलेरी गुलैमी मां गानेरे पत्ती यकुन्याहेरू शालतियेल ते शालतियेलेरू जरुब्बाबेल, ");
INSERT INTO bhd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ते जरुब्बाबेलेरू अबीहूद, अबीहूदेरू एलयाकीम, एलयाकीमेरू अजोर, ");
INSERT INTO bhd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ते अजोरेरू सादोक, सादोकेरू अखीम, अखीमेरू एलीहूद ");
INSERT INTO bhd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ते एलीहूदेरू एलीआजर, एलीआजारेरू मत्तान, मत्तानेरू याकूब, ");
INSERT INTO bhd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ते याकूबेरू यूसुफ, ते यूसुफ मरियमरो मुन्श थियो, ते मरियमरू मट्ठू यीशु आए, ज़ैस जो मसीह ज़ोतन। ");
INSERT INTO bhd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","एन्च़रे अब्राहमे करां दाऊद राज़े तगर च़ेवधे पीड़ी भोइ, ते दाऊद राज़े करां यहूदी केरे गिरफ्तार भोइतां बाबेलेरी गुलैमी मां गाने तगर च़ेवधे पीड़ी भोइ, ते गिरफ्तार भोइतां बाबेले मां गाने करां देइतां यीशु मसीह तगर च़ेवधे पीड़ी भोइ। ");
INSERT INTO bhd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","यीशु मसीहेरू ज़र्म एन्च़रे सेइं भोवं, कि ज़ैखन तैसेरी अम्मा मरियमरी कुड़माइ यूसुफ नंव्वे एक्की मैन्हु सेइं भोरी थी, त तैन केरे ड्ला भोने करां पेइले मरियम पवित्र आत्मारे शेक्ति सेइं दोज़ींती भोइ। ");
INSERT INTO bhd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","तैसारो मुन्श यूसुफ ज़ै धर्मी मैन्हु थियो, तै तैस बदनाम केरनि न थियो चातो। तैनी च़ुपच़ारे इन सोचू, कि मीं एस सेइं ड्ला नईं बनानो। ");
INSERT INTO bhd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","हेजू तै एन सोचने लोरो थियो, त प्रभुएरे एक्की स्वर्गदूते तैस सेइं सुपने मां एइतां ज़ोवं, “हे यूसुफ! तू ज़ै दाऊदेरे खानदाने मरां आस, तू मरियम अपनि कुआन्श बनाने करां न डर, किजोकि ज़ैन तैसारे पेटे मां आए तैन पवित्र आत्मारे तरफां आए। ");
INSERT INTO bhd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","तैस मट्ठू भोनूए, ते तू तैसेरू नवं ‘यीशु’ रेखां, किजोकि तैए अपने लोकन तैन केरे पापन करां मुक्ति देलो।” ");
INSERT INTO bhd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","एन सब किछ एल्हेरेलेइ भोवं, कि ज़ैना वचन प्रभुए यशायाह नेबेरे ज़िरिये ज़ोरे थिये पूरे भोए कि, ");
INSERT INTO bhd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“हेरा, अक अड्लाई कुई पेटे भारी भोली, ते तैस अक मट्ठू भोलू, ते लोक तैस जो इम्‍मानुएल ज़ोले” ज़ेसेरो मतलब ई आए, परमेशर असन सेइं साथी आए। ");
INSERT INTO bhd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","तैखन यूसुफ निड्लारां बींझ़ो त तैनी परमेशरेरे स्वर्गदूतेरू ज़ोनू मन्नू, ते मरियमी सेइं ड्ला बनाव ते अपने घरे आनी। ");
INSERT INTO bhd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","पन ज़ांतगर तैस मट्ठू न भोवं तांतगर तै तैस सेइं साथी न झ़ुल्लो ते ज़ैखन तैस मट्ठू भोवं त यूसुफे तैस मट्ठेरू नवं यीशु रख्खू। ");
INSERT INTO bhd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","हेरोदेस राज़ेरे ज़माने मां ज़ेइस यहूदिया इलाकेरे बैतलहम नगरे मां यीशु पैदा भोव, त पूर्बेरां किछ जोष्टी लोक यरूशलेम नगरे मां आए। ");
INSERT INTO bhd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ते तैना लोकन पुच्छ़ने लग्गे, “यहूदी लोकां केरो राज़ो ज़ै ज़र्मोरोए तै कोड़ि आए? किजोकि असेईं पूरबे मां तैसेरो तारो लोरोए, ते आस तैस कां मथ्थो टेकने ओरेम।” ");
INSERT INTO bhd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ज़ैखन हेरोदेस राज़े ए गल शुनी, त हेरोदेस राज़ो ते कने यरूशलेम नगरेरे सारे लोक घबराए। ");
INSERT INTO bhd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ते हेरोदेस, यहूदी लोकां केरे प्रधान याजक ते शास्त्री लोक अकोट्ठे केरतां तैन पुच्छ़ने लगो, “मसीह कोड़ि पैदा भोरो लोड़े?” ");
INSERT INTO bhd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","तैनेईं तैस सेइं ज़ोवं, “यहूदिया इलाकेरे बैतलहम नगरे मां,” किजोकि (बड़े पेइले) मीका नेबे एन्च़रे लिखोरूए, कि परमेशरे ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“हे बैतलहम नगर, तू ज़ैन यहूदिया इलाके मां आस, यहूदियारे इलाकन मां तू बड़ू खास नगर आस, किजोकि तीं मरां अक एरो हाकिम निसेलो ज़ै मेरे लोक इस्राएलेरी रखवाली केरेलो” ");
INSERT INTO bhd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ज़ैखन हेरोदेस राज़े एन शुनू, त तैनी जोष्टी च़ुपच़ारे कुजेइतां तैन करां तारो निसनेरे ठीक वक्तेरे बारे मां पतो कियो। ");
INSERT INTO bhd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ते तैनी जोष्टी एन ज़ोइतां बैतलहम नगरे जो भेज़े, कि “गाथ, ते तैस बच्चेरे बारे मां रोड़ेच़ारे पतो केरा ते ज़ैखन तुसन पतो लग्गे, त (वापस एइतां) मीं भी पतो देइयथ ताके अवं भी तैस कां गेइतां मथ्थो टेकी।” ");
INSERT INTO bhd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","तैना जोष्टी (हेरोदेस) राज़ेरी गल शुन्तां (यरूशलेम नगरेरां) च़ले जे। ते अकदम तै तारो, ज़ै तैनेईं पूरबे मां लोरो थियो, तैन अग्री-अग्री च़लो ते तैस घरेरे बा रुको ज़ैड़ी तैन मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ज़ैखन तैनेईं तै तारो लव, त तैना बड़े खुश भोए। ");
INSERT INTO bhd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","तैखन तैना घरे अन्तर जे ते तैन मट्ठू तैसेरी अम्मा मरियमी कां लाव ते तैस मट्ठे कां मथ्थो टेको। तैखन तैनेईं अपने-अपने खज़ानेरे झोले खोलतां सोन्नू, लोबान ते मुर्र तैस कां च़ाढ़ू। ");
INSERT INTO bhd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","जोष्टी केरे तैट्ठां निसनेरां पत्ती, तैन सुपने मां ए बिस्तार मैल्लो कि वापस हेरोदेसे कां न गेइयथ। एल्हेरेलेइ तैना वापस कोन्ची होरि बत्तां अपने मुलखे जो च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","जोष्टी केरे गानेरां पत्ती, अचानक प्रभुएरो अक स्वर्गदूत यूसुफे सुपने मां मैल्लो ते ज़ोने लगो, “उठ, बच्चो ते तैसेरी अम्मा नेइतां मिस्र मुलखे जो नश्श। ते मेरे ज़ोने तगर तैड़ी रेइयां, किजोकि हेरोदेस राज़ो बच्चे तोप्तां मारने चाते।” ");
INSERT INTO bhd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","यूसुफ निड्लारां उठो ते मट्ठू ते तैसेरी अम्मा साथी नेइतां रातो-रात मिस्र मुलखे जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","हेरोदेसेरे मरने तगर यूसुफ तैड़ी राव, ताके प्रभुएरू तैन वचन पूरू भोए, ज़ैन होशे नेबे लिखोरू थियूं, “मीं मिस्र मुलखे मरां अपनू मट्ठू कुजाव।” ");
INSERT INTO bhd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ज़ैखन हेरोदेसे जोष्टी केरे धोखे बैज़रो पतो लगो, त तैस बड़ी सरक आई। तैनी अपने मैन्हु भेज़तां, ज़ैन गल्लां केरो पतो तैस जोष्टन करां मैल्लोरो थियो, तैनी बैतलहम नगरे ते तैसेरे आसेपासेरे इलाकन मां सिपाही भेज़तां सारां मट्ठां, ज़ैना दूई सालां केरां या दूई सालन करां निकड़ां थियां मारां। ");
INSERT INTO bhd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ज़ैखन एन भोव, त तैखन तैन वचन पूरू भोवं, ज़ैन यिर्मयाह नेबे ज़ोरू थियूं। तैनी ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामाह नगर मां बेड़ि लेरां ते मातमेरि आवाज़ शुनोई, राहेल अपने बच्चां केरे लेइ लेरां देने लोरी, तैसारो दिल ठंडो न भोए, किजोकि तैसेरे बच्चे मेरि जोरन।” ");
INSERT INTO bhd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","हेरोदेसेरी मौतारां पत्ती, ज़ैखन यूसुफ मिस्र मुल्खे मां थियो, त अचानक प्रभुएरो स्वर्गदूत तैस सुपने मां लेइहोव ते तैस सेइं ज़ोने लगो, ");
INSERT INTO bhd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“उठ, बच्चो ते कने तैसेरी अम्मा साथी नेइतां इस्राएल मुलखे जो वापस च़लो गा, किजोकि ज़ैना लोक बच्चे मारने चाते थिये, तैना मेरि जोरेन।” ");
INSERT INTO bhd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","फिरी यूसुफ निड्लारां बींझ़ो, ते बच्चो ते तैसेरी अम्मा साथी एन्तां इस्राएल मुलखे जो वापस अव। ");
INSERT INTO bhd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","पन ज़ैखन यूसुफे एन शुनू कि अरखिलाउस अपने बाजी हेरोदेसेरी ठैरी यहूदिया इलाके पुड़ राज़ केरने लग्गोरो, त तै तैड़ी गाने करां डरो। एल्हेरेलेइ ज़ैखन यूसुफे सुपने मां परमेशरेरो बिस्तार मैल्लो, त तै गलील इलाके जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ते तैड़ी पुज़तां तै नासरत नंव्वेरे नगर मां राने लगो, ताके तैन वचन पूरू भोए, ज़ैन परमेशरे अपने नेबी केरे ज़िरिये ज़ोरो थियूं। तैनेईं ज़ोवं, “तैस जो नासरी ज़ोले।” ");
INSERT INTO bhd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","तैन दिहाड़न मां यूहन्ना नंव्वेरो मैन्हु, ज़ै बपतिस्मो देनेबालो थियो, यहूदिया इलाकेरे सुनसान ठैरी मां अव। तै लोकन ज़ैना तैस कां एइते थिये, तैन ई प्रचार केरतो थियो, ");
INSERT INTO bhd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“अपने पापन करां मनफिराथ, किजोकि स्वर्गेरू राज़ नेड़े ओरूए!” ");
INSERT INTO bhd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ई तैए ज़ेसेरे बारे मां यशायाह नेबे एन ज़ोरू थियूं, “कोई सुनसान ठैरी मां लोकन, ज़ैना तैस कां गातन, तैन उच्ची आवाज़ी सेइं ज़ोलो कि ‘तुसन कां प्रभु एजनेबालो आए, एल्हेरेलेइ तैसेरी बत तियार केरा ते कने तैसेरेलेइ सड़कां सिद्धी केरा।’ (यानी, प्रभुएरे लेइ तुस अपने दिल साफ केरा)” ");
INSERT INTO bhd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","यूहन्ना आम लिगड़ां लातो थियो ज़ैना लिगड़ां ऊँटेरे बालन सेइं बनोरां थियां। तै अपनि कमरी पुड़ चमड़ेरू मज़ बंधतो थियो। ते तै टिट्टां त कने जंगलेरू माछ़ी खातो थियो। ");
INSERT INTO bhd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","तैखन यरूशलेम नगरेरे बड़े लोक ते यहूदिया इलाकेरे बड़े लोक ते यरदन दरियारे आसे-पासेरे इलाकन मरां लोक यूहन्नारी गल्लां शुन्नेरे लेइ तैस कां एइते थिये। ");
INSERT INTO bhd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ते तैनेईं अपने पाप मेन्तां यूहन्ना करां यरदन दरियाए मां बपतिस्मो नीयो। ");
INSERT INTO bhd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","पन ज़ैखन तैनी हेरू कि बड़े फरीसी ते सदूकी लोक बपतिस्मो नेनेरे लेइ तैस कां एजने लोरेन, त तैनी तैन सेइं ज़ोवं, “तुस ज़ेहरीले सप्पेरे ज़ेरे बुरे आथ! तुसन केनि ज़ोवं कि, एजनेबाले परमेशरेरे कोपे करां नश्शा? ");
INSERT INTO bhd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","सज़ाई करां बच़नेरे लेइ तैना कम्मां केरा, ज़ैन सेइं पतो लग्गे तुसेईं सच़्च़े पापन करां मन फिरावरोए। ");
INSERT INTO bhd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ते अपने-अपने दिले मां एन न सोचा कि ‘अब्राहम इश्शो बाजी आए’ (परमेशर तुश्शे पाप सिर्फ एल्हेरेलेइ माफ़ न केरेलो कि तुस अब्राहमेरी औलाद आथ), किजोकि अवं तुसन सेइं ज़ोताईं कि परमेशर इन घोड़न मरां भी अब्राहमेरे लेइ औलाद पैदा केरि सकते! ");
INSERT INTO bhd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ते हुन्ना त बुट्टां केरे ज़ीलन पुड़ परमेशरेरो मैक्कु रख्खोरोए, एल्हेरेलेइ ज़ै कोई तैस बुट्टेरो ज़ेरो भोते, ज़ै रोड़ो फल न दे, तै कटनोए ते अग्गी मां छ़डनोए। ");
INSERT INTO bhd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","अवं त तुसन पैनी सेइं बपतिस्मो देताईं किजोकि तुसेईं मनफिरोरोए, पन मसीह ज़ै मेरे बाद एजनेबालोए, तै मीं केरां भी महान आए। अवं त तैसेरो गुलाम भोनेरे काबल भी नईं कि तैसेरे बूट छ़ुई। तै तुसन पवित्र आत्माई सेइं ते अग्गी सेइं बपतिस्मो देलो (ज़ैना मन फिरान, तैनन्)। ");
INSERT INTO bhd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","तैसेरू छज्ज तैसेरे हथ्थे मां आए ते तै खलाड़ रोड़ेच़ारे साफ केरेलो, तै गेहुं अपने कोठारे मां रखेलो, पन झ़ाझ़ी तैस अग्गी मां फुकेलो ज़ै कधे न हिश्शे। (एल्हेरेलेइ पापन करां मनफिराथ नईं त परमेशर तुसन सज़ा देलो)” ");
INSERT INTO bhd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","तैस मौके यीशु गलील इलाके मरां यरदन दरियारे बन्ने पुड़ यूहन्ना कां अव, ताके तैस करां बपतिस्मो ने। ");
INSERT INTO bhd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","पन यूहन्ना, यीशु जो इन ज़ोइतां रोकने लगो, “मीं तीं करां बपतिस्मो नीयोरो लोड़ते, फिरी किजो तू मीं करां बपतिस्मो नेने ओरोस?” ");
INSERT INTO bhd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","पन यीशुए तैस ई जुवाब दित्तो, “हुनी तू एन्च़रे भोने दे, किजोकि एन्च़रे केरतां अस तैन केरतम ज़ैन परमेशर चाते।” तैखन यूहन्ना तैसेरी गल मन्नी। ");
INSERT INTO bhd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ते यीशु ज़ैखन बपतिस्मो नेइतां पैनी मरां बेइर अव, त तैस मौके हेरा अम्बर खुल्ली ज़ोवं। ते तैनी पवित्र आत्मा कबूतरेरी शकली मां एप्पू पुड़ एइती लाई। ");
INSERT INTO bhd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ते तैखन हेरा अम्बरे मरां ए आवाज़ आई (त यीशुएरे बारे मां ज़ोवं), “एन मेरू ट्लारू मट्ठू, अवं एस पुड़ बड़ो खुश आईं।” ");
INSERT INTO bhd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","तैल्ला पत्ती, पवित्र आत्मा यीशु सुनसान ठैरी मां नीयो, ताके शैतान तैसेरी अज़मैइश केरे। ");
INSERT INTO bhd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","40 दिहाड़े ते 40 रातन किछ न खानेरां पत्ती तैस ढ्लुख लग्गी। ");
INSERT INTO bhd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","त तैखन शैताने ज़ैस जो अज़माने बालो भी ज़ोतन, तैस कां एइतां ज़ोवं, “अगर तू परमेशरेरू मट्ठू आस, त इन घोड़न जो हुक्म देइतां साबत केर, कि एना रोट्टी बनन् ताके तू खेइ सकस।” ");
INSERT INTO bhd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","यीशुए तैस जुवाब दित्तो, “अवं न केरेलो किजोकि परमेशरेरी किताबी मां लिखोरूए, ‘मैन्हु सिर्फ रोट्टेइं सेइं ज़ींतो न राए, बल्के तै हर गल मन्ने सेइं ज़ींतो राते, ज़ै परमेशर ज़ोते।’” ");
INSERT INTO bhd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","फिरी शैताने तै पवित्र नगर यरूशलेमे मां नीयो ते मन्दरेरी उच्ची छ़म्पी पुड़ नेइतां खड़ो कियो। ");
INSERT INTO bhd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","तैखन तैनी यीशु सेइं ज़ोवं, “अगर तू हकीक्ति मां परमेशरेरू मट्ठू आस त इट्ठां बिछ़ड़तां साबत केर, किजोकि पवित्रशास्त्रे मां लिखोरूए, ‘तै तेरे लेइ अपने स्वर्गदूतन हुक्म देलो, ते तैना तीं अपने हथ्थन मां ट्लाले, ताके तेरे पावन केन्ची घोड़न सेइं ठोकर न लग्गे।’” ");
INSERT INTO bhd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","यीशुए तैस सेइं ज़ोवं, “(नईं, अवं छाल न मारेलो, किजोकि) परमेशरेरी किताबी मां एन भी लिखोरूए, ‘तू प्रभु अपने परमेशरे अज़मेइतां इन साबत केरनेरी कोशिश न केर कि तै अपने वादे पूरे केरते या नईं।’” ");
INSERT INTO bhd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","तैखन शैताने, यीशु एक्की बड़े उच्चे पहाड़े पुड़ नीयो, ते तैड़ी दुनियारां सारां राज़्ज़ां ते तैन केरि धन दौलत तैस हिराई। ");
INSERT INTO bhd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","तैखन तैनी यीशु सेइं ज़ोवं, “अगर तू मीं कां मथ्थो टेकस ते मेरी आराधना केरस, त अवं इन सब किछ तीं देलो।” ");
INSERT INTO bhd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","यीशुए तैस जो ज़ोवं, “हे शैतान! दूर भो, किजोकि परमेशरेरी किताबी मां लिखोरूए, ‘तू सिर्फ प्रभु अपने परमेशरे कां मथ्थो टेक ते तैसेरी आराधना केर!’” ");
INSERT INTO bhd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","तैखन शैतान तैस करां च़लो जेव, ते अकदम किछ स्वर्गदूत यीशु कां एइतां तैसेरी सेवा केरने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","एक्सां केन्चे यीशु जो ज़ोवं, कि यूहन्ना ज़ै बपतिस्मो देनेबालो थियो, कैद कियोरोए त यीशु यहूदिया इलाकेरां, गलील इलाके मां वापस अव। ");
INSERT INTO bhd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ते नासरत नगर शैरतां कफरनहूम नगरे मां राने लगो, ज़ैन समुन्दरेरे बन्ने पुड़ आए, ज़ैड़ी जबूलून ते कने नप्ताली गोट्लेरे लोक राते थिये। ");
INSERT INTO bhd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ताके तैन वचन ज़ैन यशायाह नेबे ज़ोरू थियूं पूरू भोए, तैनी ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ज़ैना लोक जबूलून ते नप्ताली गोत्रां केरे इलाके मां आन, ज़ैना गलील समुन्दरेरे नेड़े यरदन दरियारे उस पार, गलील इलाके मां आन, ज़ैड़ी गैर यहूदी लोक भी रातन, ");
INSERT INTO bhd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","(तैना लोक) ज़ैना पापेरे आंधरे मां बिश्शोरेन, तैनेईं बड्डी लौ लई। तै लौ तैन पुड़ चमकी ज़ैना हमेशारे मौतारे आंधरेरे मुलखे मां बिश्शोरेन।” ");
INSERT INTO bhd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","तेइसेरू देंतू यीशुए परमेशरेरी खबर लोकन शुनानेरी सेवा शुरू की। तैनी लोकन ज़ोवं, “अपने पापन करां मनफिराथ, किजोकि स्वर्गेरू राज़ नेड़े ओरूए।” ");
INSERT INTO bhd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","एक्सां ज़ैखन यीशु गलील समुन्दरेरे बन्ने च़लोरो थियो, त तैनी दूई मैन्हु लाए ज़ैना मेछ़ली ट्लानेबाले थिये। तैना मेछ़ली ट्लानेरे लेइ समुन्दरे मां ज़ाल छ़ेड्डी राओरे थिये। तैन मरां एक्केरू नवं शमौन, ज़ैस जो पतरस भी ज़ोतन, ते तैसेरो ढ्ला ज़ेसेरू नवं अन्द्रियास थियूं। ");
INSERT INTO bhd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","यीशुए तैन सेइं ज़ोवं, “एज्जा मेरे चेले बना। अवं तुसन शिखालेलो कि केन्च़रां होरे मैन्हु मेरे चेले बनानेन।” ");
INSERT INTO bhd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","तैना अकदम अपना ज़ालां छ़ेडतां यीशु पत्ती च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ते तैना तैट्ठां थोड़े ज़ेरे अग्गर जे, त यीशुए होरे दूई ढ्ला, यानी याकूब त कने तैसेरो ढ्ला यूहन्ना अपने बाजी जब्दी सेइं साथी किश्ती मां लाए। तैना किश्ती मां ज़ालां ठीक केरने लग्गोरे थिये। यीशुए तैना भी कुजाए (कि तैना तैसेरे चेले बनन्)। ");
INSERT INTO bhd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ते तैना भी तैखने किश्ती ते अपने बाजी तैड़ी ज़ेरे छ़ेडतां यीशु सेइं साथी च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","तैल्ला पत्ती, यीशु सारे गलील इलाके मां हंठतो फिरतो राव। तै तैन केरे प्रार्थना घरन मां लोकन शिक्षा देतो राव ते परमेशरेरे राज़्ज़ेरी खुशखबरी शुनातो राव। ते तै लोकां केरि हर किसमेरी बिमैरी ते कमज़ोरी दूर केरतो राव। ");
INSERT INTO bhd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","यीशुएरे बारे मां ई खबर सारे सीरिया इलाके मां मुशूर भोइ जेई। एसेरे वजाई सेइं, ज़ैड़ी कोन्ची तै जेव, तैड़ी लोक सेब्भी बिमारन ज़ैना हर किसमेरी बिमैरी ते तकलीफन मां फसोरे थिये, ते ज़ैन लोकन पुड़ भूतां केरो सायो थियो, ते ज़ैना मिरगरे रोगी थिये, ते ज़ैना अधरंगेरे रोगी थिये, तैना यीशु कां आने ते यीशुए तैना सारे बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","एसेरे वजाई सेइं मैन्हु केरि बड़ी भीड़ यीशु पत्ती च़ली। तैना लोक गलील, दिकापुलिस इलाकां केरे, यरूशलेम नगरेरे, यहूदिया इलाकेरे, ते यरदन दरियारे पैरीं पारेरे इलाकां केरां ओरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","यीशु तैना हछे लोक लेइतां एक्की पहैड़ी पुड़ च़लो जेव, ते ज़ैखन तै शिखालनेरे लेइ बिश्शो त तैसेरे चेले तैस कां आए। ");
INSERT INTO bhd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","तैखन यीशु तैन लोकन शिक्षा देने लगो, ");
INSERT INTO bhd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“परमेशर तैन लोकन बरकत देते, ज़ैना ज़ानतन कि तैन परमेशरेरी ज़रूरते, किजोकि तै तैन पुड़ राज़ केरेलो। ");
INSERT INTO bhd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","परमेशर तैन लोकन बरकत देते, ज़ैना दुखी आन, किजोकि परमेशर तैन तस्सली देलो। ");
INSERT INTO bhd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","परमेशर तैन लोकन बरकत देते ज़ैना नम्र आन, किजोकि परमेशर तैन, तैना सैरी बरकतां देलो ज़ैन केरो तैनी वादो कियोरोए। ");
INSERT INTO bhd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","परमेशर तैन लोकन बरकत देते, ज़ैना परमेशरेरी नज़री मां रोड़ी गल्लां केरनेरी बड़ी इच्छा रखतन, (ज़ेन्च़रे कोई ढ्लुखोरो खाने पीनेरी इच्छा रखते) तैन परमेशर अपनि मेर्ज़ी पुड़ च़लनेरे लेइ शक्ति देते। ");
INSERT INTO bhd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","परमेशर तैन लोकन बरकत देते, ज़ैना दया केरतन, किजोकि परमेशर भी तैन पुड़ दया केरेलो। ");
INSERT INTO bhd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","परमेशर तैन लोकन बरकत देते, ज़ैन केरे मन साफ आन, किजोकि तैन परमेशर दर्शन देलो। ");
INSERT INTO bhd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","परमेशर तैन लोकन बरकत देते, ज़ैना शैनतरां कम्मां केरतन, किजोकि तैन जो परमेशरेरे बच्चे ज़ोले। ");
INSERT INTO bhd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","परमेशर तैन लोकन बरकत देते, ज़ैना परमेशरेरी नज़री मां रोड़ि गल्लां केरनेरे वजाई सेइं सताए गातन, किजोकि परमेशर तैन पुड़ राज़ केरते।” ");
INSERT INTO bhd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“परमेशर तुसन बरकत देलो, ज़ैखन लोक तुसन मेरे चेलो भोनेरे वाजाई सेइं तुश्शी तुहीन केरन ते स्तान ते झूठ ज़ोइतां हर किसमेरी बुरी गल्लां तुश्शे बारे मां ज़ोन। ");
INSERT INTO bhd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","तैखन तुस खुशी रेइयथ ते मघन भोइयथ, किजोकि परमेशरे ज़ैन इनाम स्वर्गे मां तुश्शे लेइ रख्खेरूए तैन बड़ू बड्डूए, किजोकि लोकेईं बड़े पेइले तैना नबी भी एन्च़रे सतोरे थिये।” ");
INSERT INTO bhd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“तुस इस दुनियारे लोकां केरे लेइ लूनेरे ज़ेरे आथ, पन अगर लूनेरो स्वाद च़ेलि गाए, त फिरी दुबारां केन्च़रे तैसेरो स्वाद वापस आनेले? फिरी तैन कोन्ची कम्मेरू न राए, सुवाए बेइरोवं शारनेरां ते लोकां केरे पांवेइं सेइं ढ्लेन्च़ोनेरां।” ");
INSERT INTO bhd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“तुस इस दुनियारे लोकां केरे लेइ लोअरे ज़ेरे आथ। ज़ैन नगर पहाड़े पुड़ बसते तैन कधे भी छ़ेप्पी न सके। ");
INSERT INTO bhd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","लोक बलतो दीयो हेटी मां न रखन, पन तैस उच्ची ठैरी रखतन ताके घरेरे सैरी मैनन् लौ पुज़्ज़े। ");
INSERT INTO bhd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ते एन्च़रे तुश्शी लौ मैन्हु केरे सामने एरी चमके, ताके तैना तुश्शां रोड़ां कम्मां हेरतां तुश्शे स्वर्गेरे बाजेरी तारीफ़ केरन।” ");
INSERT INTO bhd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“एन न बुझ़थ कि अवं मूसेरो कानून या नेबी केरे किताबन मां लिखोरी गल्लां रद केरने ओरोईं। अवं तैन रद केरने नईं बल्के पूरी केरने ओरोईं। ");
INSERT INTO bhd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","किजोकि अवं तुसन सेइं सच़ ज़ोताईं, कि ज़ां तगर धरती त अम्बर खतम न भोए, तांतगर परमेशरेरे कानूने मरां अक मात्रा या बिंदी भी न टलेली, ज़ां तगर सब किछ लिखोरू पूरू न भोए। ");
INSERT INTO bhd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","एल्हेरेलेइ ज़ै कोई इन निकड़े करां निकड़े हुक्मन मरां केन्ची एक्की ज़ेरे ट्लोड़ते ते होरन भी एन्ने केरनू शिखालते, तै स्वर्गेरे राज़्ज़े मां सेब्भन करां निकड़ो भोलो, पन ज़ै तैन हुक्मन पुड़ अमल केरते ते होरन भी एन हुक्मन पुड़ च़लनेरे बारे मां शिखालते त तै स्वर्गेरे राज़्ज़े मां बड्डो भोलो। ");
INSERT INTO bhd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","किजोकि अवं तुसन सेइं ज़ोताईं कि ज़ां तगर तुस शास्त्री ते फरीसी लोकन करां रोड़े च़ारे कानूने न मन्नेले, तांतगर तुस स्वर्गेरे राज़्ज़े मां दाखल न भोइ सकतथ।” ");
INSERT INTO bhd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“तुसेईं शुनेरू थियूं कि परमेशरे इश्शे दादे-पड़दादन सेइं ज़ोरू थियूं, ‘खून नईं केरनो, ते ज़ै खून केरेलो त तैस आदालत सज़ा देली।’ ");
INSERT INTO bhd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","पन मेरू ज़ोनू एने कि ज़ै कोई अपने ढ्लाए पुड़ क्रोध केरते, परमेशर तैसेरो इन्साफ केरेलो, ते ज़ै कोई अपने ढ्लाए जो निकम्मो ज़ोते त तैस भी महासभा मां जुवाब देनो पेनोए, ते ज़ै कोई अपने ढ्लाए जो ‘बेवकूफ’ ज़ोलो त परमेशर तैस नरकेरे अगारी सज़ा देलो। ");
INSERT INTO bhd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","एल्हेरेलेइ अगर तू अपनि च़ढ़तल मन्दरे मां आनस, ते तैड़ी तीं याद एज्जे कि मीं अपने ढ्लाए सेइं किछ गिलोए। ");
INSERT INTO bhd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","त तू अपनि च़ढ़तल बलिदान च़ाढ़नेरि ठैरी पुड़ छ़ेडतां पेइले अपने ढ्लाए सेइं मेल-मलाप केरां, फिरी अपनि च़ढ़तल च़ैढ़ां। ");
INSERT INTO bhd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","अगर कोई मैन्हु तीं पुड़ दाओ केरतां तीं आदालती मां नेनो चाते, त तू बत्तां तैस सेइं मेल-मिलाप केरां न त तैनी तू हाकिमे कां खड़ो केरनोस, ते तैनी तू सिपैहीएरे हवाले केरनोस ते सिपैहिए तू कैद केरतां छ़डनोस। ");
INSERT INTO bhd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","अवं तुसन सेइं सच़ ज़ोताईं कि ज़ां तगर तू पाई-पाई न देलो त तांतगर तैट्ठां छुट्टी न सकेलो।” ");
INSERT INTO bhd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“तुसेईं शुनेरू थियूं, कि ई हुक्म दित्तोरो थियो, ‘बदमाशी नईं केरनि।’ ");
INSERT INTO bhd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","पन अवं तुसन इन भी ज़ोताईं कि ज़ै कोई केन्ची कुआन्शी पुड़ गेन्दी नज़रां सेइं तकते, तैनी अपने दिले मां पेइली तैस सेइं बदमाशी केरि छ़ड्डी। ");
INSERT INTO bhd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","अगर तेरी देइनी अछ़ तीं पाप केरनेरे लेइ ठोकर खुवाए, त तैस केढतां शार, किजोकि तेरी पूरी जान नरके मां छ़ड्डे गाने करां तेरे लेइ एन्ने रोड़ूए कि तेरी जानी मरां अक अंग नाश भोए ");
INSERT INTO bhd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","अगर तेरो देइनो हथ तीं पाप केरनेरे लेइ ठोकर खुवाए त तैस केटतां शार, किजोकि तेरी पूरी जान नरकेरी अग्गी मां गाने करां तेरे लेइ एन्ने रोड़ूए कि तेरी जानी मरां अक अंग नाश भोए।” ");
INSERT INTO bhd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“एन भी ज़ोरू थियूं, ‘ज़ै कोई अपनि कुआन्श शारे त एन ज़रूरीए कि फारख्ती लिखतां हावाले केरे।’ ");
INSERT INTO bhd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","पन अवं तुसन सेइं ज़ोताईं, कि ज़ै कोई अपने कुआन्शी बदमैशरे अलावा होरि केन्ची गल्ली पुड़ फारख्ती दे, त तै तैस केरां बदमैशी केरवाते। ते ज़ै कोई तैस शैरोरी कुआन्शी सेइं ड्ला बनाते, त तै भी तैस सेइं बदमाशी केरते।” ");
INSERT INTO bhd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“तुसेईं शुनोरू, कि ई हुक्म दित्तोरो थियो, ‘झूठी कसम नईं केरनि, पन कसम प्रभुएरे लेइ पूरी केरथ।’ ");
INSERT INTO bhd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","पन अवं तुसन सेइं ज़ोताईं कि कधे कसम न केरथ, न स्वर्गेरी, किजोकि तै परमेशरेरो तखत आए। ");
INSERT INTO bhd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","न ज़मीनारी किजोकि परमेशर तैड़ी पाव रखते, ते न यरूशलेम नगरेरी किजोकि तैन महा राज़ां केरू नगर आए। ");
INSERT INTO bhd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ते न अपने दोग्गेरी कसम केरथ, किजोकि तुस अपनो अक बाल भी छ़ित्तो या कालो न केरि सकतथ। ");
INSERT INTO bhd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","पन हांएरी ठैरी हाँ ते नाएरी ठैरी न ज़ोथ, किजोकि ज़ैन किछ एस करां जादे तैन बुरैई यानी शैतानेरे पासेरां आए।” ");
INSERT INTO bhd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“तुसेईं शुनोरूए, कि मूसेरे कानूने मां लिखोरूए, कि अछ़्छ़रे बदले अछ़ ते दंतेरे बदले दंत। ");
INSERT INTO bhd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","पन अवं तुसन सेइं ज़ोताईं कि, बुरे मैन्हु करां बदलो न नेइयथ। अगर कोई तेरे देइनी खैखोड़ी पुड़ थप्पड़ बालो त तू बाएं पासो भी तैसेरे पासे रेख्खां। ");
INSERT INTO bhd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ते अगर कोई मुकदमो केरतां तेरी कमीज़ नेनी चाए त तू कोट भी तैसेरे हवाले केरां। ");
INSERT INTO bhd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ते अगर कोई सिपाई तीं भारो छ़ूने अक मील नेने चाए त तू दूई मील गेइयां। ");
INSERT INTO bhd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ज़ै कोई तीं करां किछ मग्गे, तैस दे। ते ज़ै कोई तीं करां ओधार मग्गे त तुत्तर न फिरेइयां।” ");
INSERT INTO bhd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“तुसेईं शुनोरूए, कि मूसेरे कानूने मां लिखोरूए, कि ‘अपने पड़ोसी सेइं अपनो ज़ेरो प्यार केरथ ते दुश्मने सेइं बैर रेखथ।’ ");
INSERT INTO bhd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","पन अवं तुसन सेइं ज़ोताईं, कि अपने दुश्मन सेइं प्यार केरा, ते ज़ैना तुसन सतातन तैन केरे लेइ प्रार्थना केरा। ");
INSERT INTO bhd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ज़ैस सेइं तुस अपने स्वर्गेरे बाजी केरे बच्चे बेनि सकतथ, ज़ै अपनो दिहाड़ो अपने रोड़े लोकन पुड़ चमकाते ते बुरे लोकन पुड़ भी, ते धेर्मी लोकन पुड़ झ़ड़ी देते ते बुरे लोकन पुड़ भी। ");
INSERT INTO bhd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","किजोकि अगर तुस तैन्ने लोकन सेइं प्यार केरथ ज़ैना तुसन सेइं प्यार केरतन त तुसन कुन इनाम मैलेलू? कुन चुंगी घिन्ने बाले भी एन्ने न केरन?” ");
INSERT INTO bhd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“ते अगर तुस सिर्फ अपने ढ्लान जो नमस्कार ज़ोथ, त तुस होरन करां जादे कुन केरतथ? कुन गैर कौमां केरे लोक ज़ैना परमेशरेरे कानूने न मनन् तैना भी एरू न केरन? ");
INSERT INTO bhd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","तुसन तैन लोकन सेइं प्यार केरनेरी ज़रूरत आए, ज़ैना तुसन सेइं प्यार न केरन, एन्च़रां तुस सिद्ध भोले ज़ेन्च़रे स्वर्गे मां रानेबालो तुश्शो बाजी सिद्ध आए।” ");
INSERT INTO bhd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“खबरदार, तुस अपने रोड़ां कम्मां सिर्फ लोकन हिरानेरे लेइ न केरा, नईं त तुश्शो स्वर्गेरो बाजी तुसन कोई इनाम न देलो। ");
INSERT INTO bhd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","एल्हेरेलेइ ज़ैखन तू गरीब मैन्हु दान देस, त तू ढुंढूरो न बज़ेइयां, ज़ेन्च़रे पाखंडी लोक प्रार्थना घरन मां ते गेल्लन मां केरतन, ताके लोक तैन केरि तारीफ़ केरन। अवं तुसन सेइं सच़ ज़ोताईं कि ज़ैन इनाम तैन मैलनू थियूं, तैन सिर्फ इन्ने, कि लोकेईं तैन केरि तारीफ़ की (परमेशरे करां तैनन् कोई इनाम न मैलेलो)। ");
INSERT INTO bhd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","पन ज़ैखन तू गरीब मैन्हु दान देस, त केन्ची पतो न लोड़े लग्गोरो कि तीं कुन दित्तू। ");
INSERT INTO bhd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ताके तेरू दान छ़प्पोरू भोए, तैखन तेरो बाजी ज़ै छ़ेपतां तकते, तीं इनाम देलो।” ");
INSERT INTO bhd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ज़ैखन तू प्रार्थना केरस त पाखंडी लोकां केरो ज़ेरो न बेना, ज़ैना प्रार्थना घरन मां ते सड़कां केरे मोड़न पुड़ खेड़ोइतां प्रार्थना केरनि सुखातन, ताके लोक तैन तक्कन ते तैन केरि तारीफ़ केरन। अवं तुसन सेइं ज़ोताईं कि ज़ैन इनाम तैनन् मैल्लोरू लोड़तू थियूं, तैन सिर्फ इन्ने, कि लोकेईं तैन केरि तारीफ़ की (परमेशरे करां तैनन् कोई इनाम न मैलेलू)। ");
INSERT INTO bhd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","पन ज़ैखन तू प्रार्थना केरस त अकैल्लो अपने कमरेरो अन्तर गा, ते दार बंद केरतां अपने परमेशरे कां ज़ै लेइहोए न तैस कां प्रार्थना केरा। तैखन तुश्शो बाजी परमेशर ज़ै लेइहोए न, ज़ै हर वक्त तीं तकतो राते तै तीं इनाम देलो। ");
INSERT INTO bhd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","प्रार्थना केरते बार, गैर कौमां केरू ज़ेरू बकबक न केरां, किजोकि तैना समझ़तन कि तैन केरे बकबक केरने सेइं तैन केरि प्रार्थना शुनी गाली। ");
INSERT INTO bhd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","तैन केरे ज़ेरे न बना, किजोकि तुश्शो बाजी तुश्शे मगने करां पेइले तुश्शी ज़रूरतां ज़ानते।” ");
INSERT INTO bhd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“एल्हेरेलेइ तुस एन्च़रे प्रार्थना केरा, हे इश्शे बाजी, तू ज़ै स्वर्गे मां आस, लोक तेरी आदर केरन किजोकि तू पवित्र परमेशर आस। ");
INSERT INTO bhd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","तू सेब्भी लोकन पुड़ ते चीज़न पुड़ राज़ केरस। तेरी मर्ज़ी ज़ेन्च़रे स्वर्गे मां पूरी भोचे, इस धेरती पुड़ भी भोए। ");
INSERT INTO bhd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","इश्शी रोज़ेरी रोट्टी अज़ असन दे। ");
INSERT INTO bhd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ते ज़ेन्च़रे अस ज़ैना इश्शे खलाफ बुराई केरतन, तैन माफ़ केरतम, तेन्च़रे तू भी इश्शी बुरैई माफ़ केर। ");
INSERT INTO bhd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","अज़मैइशरे ज़िरिये असन पाप केरने न दे, पन बुरैई यानी शैताने करां बच़ेइयां, (किजोकि राज़, शक्ति ते महिमा हमेशा तेरी भोती राए। आमीन।)” ");
INSERT INTO bhd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“एल्हेरेलेइ अगर तुस लोकां केरे पाप माफ़ केरेले, त तुश्शो स्वर्गेरो बाजी भी तुश्शे पाप माफ़ केरेलो। ");
INSERT INTO bhd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ते अगर तुस लोकां केरे पाप माफ़ न केरेले, त तुश्शो स्वर्गेरो बाजी भी तुश्शे पाप माफ़ न केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ज़ैखन तुस बरत रखत, त पाखंडी लोकां केरू ज़ेरू अपनू तुत्तर न बगैड़थ। तैना अपनू तुत्तर बिगाड़तन, ताके लोकन पतो लग्गे कि एनेईं अज़ बरत रख्खोरूए ते तैन केरि तारीफ़ केरन। अवं तुसन सेइं सच़ ज़ोताईं कि ज़ैन इनाम तैन मैलनू थियूं तैन मैल्ली जेव। ");
INSERT INTO bhd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","बल्के ज़ैखन तू बरत रखस त अपनू तुत्तर धोइयां ते दोग्गे तेल मेल्लां। ");
INSERT INTO bhd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ताके लोक नईं, पन तेरो स्वर्गेरो बाजी, ज़ै लेइहोतोए न तै लाए कि तीं बरत रख्खोरूए तै तीं इनाम देलो।” ");
INSERT INTO bhd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“एप्पू जेई धरती पुड़ दौलत अकोट्ठी न केरा, ज़ैड़ी कीड़े खातन ते मौरच़ो लेगतां नाश केरते, ते च़ोर तुश्शू घर ट्लोड़तां च़ोरी केरतन। ");
INSERT INTO bhd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","बल्के रोड़ू केरतां अपने लेइ स्वर्गे मां दौलत अकोट्ठी केरा ज़ैड़ी न कीड़ो लग्गे, ते न मोरच़ो लग्गे ते न च़ोर च़ोरी केरेले। ");
INSERT INTO bhd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","किजोकि ज़ैड़ी तेरी दौलत भोली, तैड़ी तेरो दिल भी लग्गेलो।” ");
INSERT INTO bhd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“अछ़ जानेरे लेइ दीयेरी ज़ेरि आए, एल्हेरेलेइ अगर तेरी अछ़ रोड़ी साफ आए, त तेरी सारी जान लौ भोली। ");
INSERT INTO bhd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","अगर तेरी अछ़ खराब आए, त सारी जानी मां आंधरू भोलू। बस अगर ज़ै लौ तीं मां आए तै आंधरू बेनि गाए, त तैन केत्रू आंधरू भोलू!” ");
INSERT INTO bhd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“कोई मैन्हु दूई मालिकां केरि सेवा एक्की वक्ते मां न केरि सके। न त एक्की सेइं दुश्मनी केरेलो ते होरि सेइं प्यार केरेलो, या एक्केरो बेनतां रालो त होरि न सुखालो। तुस परमेशरेरी ते दौलतरी, दुइयां केरि सेवा न केरि सकतथ। ");
INSERT INTO bhd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","एल्हेरेलेइ अवं तुसन सेइं ज़ोताईं, कि तुस अपने ज़िन्दगरी ज़रूरतां केरे लेइ फिक्र न केरा, कि तुस कुन खाले या कुन पीले, ते न अपने जानारी कि कुन लामेले। कुन प्राण रोट्टी करां ते जान लिगड़े करां बेधतां नईं!” ");
INSERT INTO bhd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“अम्बरेरे च़ुड़ोल्लन हेरा! तैना न किछ बेन, ते न किछ कट्टन, ते न अकोट्ठे केरतां रखन, फिरी भी तुश्शो स्वर्गेरो बाजी तैन खाने जो देते ते तैन केरि हेरगेश केरते। कुन तुश्शी कदर तैन करां जादे नईं? ");
INSERT INTO bhd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","तुसन मां एरो कौन आए, ज़ै फिक्र केरतां अपनि उमर अक घड़ी भी बधैई सकते?” ");
INSERT INTO bhd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“ते लिगड़ेरे लेइ किजो फिक्र केरतथ? जंगले मां सोसनेरां फूड़ू हेरा कि तैना केन्च़रे बेडोतन, न तैना मेहनत केरन, ते न तैना लिगड़ां बनान। ");
INSERT INTO bhd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","फिर भी अवं तुसन सेइं ज़ोताईं कि राज़ो सुलैमाने भी अपने सारे धन दौलतरे बावजूद भी तैन केरां ज़ेरां लिगड़ा न लां। ");
INSERT INTO bhd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","एल्हेरेलेइ ज़ैखन परमेशर मैइदानेरो घास, ज़ै अज़ आए ते कालां लौवंने मां फुकनोए, एरी खूबसूरती देते, त हे घट विश्वासे बाले लोकव, कुन तै तुसन लिगड़ न देलो? ");
INSERT INTO bhd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","एल्हेरेलेइ तुस फिक्र केरतां एन न ज़ोइयथ, कि ‘कुन खामेले, या कुन पीमेले, या कुन लामेले?’ ");
INSERT INTO bhd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","किजोकि गैर कौमां एन गल्लां केरि फिक्री मां रेइचन। ते तुश्शो स्वर्गेरो बाजी ज़ानते, कि तुसन कोनां-कोनां चीज़ां केरि ज़रूरत आए। एल्हेरेलेइ तुस कोन्ची चीज़री फिक्र न केरा। ");
INSERT INTO bhd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","पन पेइले तुस अपने आपे परमेशरेरे राज़्ज़ेरे लेइ अर्पण केरा, ते तैन कम केरा ज़ैन परमेशरेरी नज़री मां रोड़ू भोते, त इना सैरी चीज़ां भी तुसन मैल्ली गैली। ");
INSERT INTO bhd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","एल्हेरेलेइ कालेरे बारे मां फिक्र न केरथ, किजोकि कालेरी दिहाड़ी अपने लेइ एप्पू फिक्र आनेली। अज़्ज़ेरे लेइ अज़ेरो दुख सुद्धोए।” ");
INSERT INTO bhd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“केन्ची पुड़ दोष न लेइयथ, तुसन भी दोष न लग्गेलो। ");
INSERT INTO bhd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","किजोकि ज़ेन्च़रे तुस होरि पुड़ दोष लाएले, तेन्च़रे परमेशर भी तुश्शो इन्साफ केरेलो। ज़ेन्च़रे तुस होरि लोकन सेइं बर्ताव केरतथ, तेन्च़रे परमेशर तुसन सेइं बर्ताव केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“तू अपने ढ्लाएरी एछ़्छ़ी मां कूड़ो किजो तकतां, पन तेरी एछ़्छ़ी मां त नग आए, ते तैसेरो तू खियाल भी न केरस? ");
INSERT INTO bhd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ज़द तेरी एछ़्छ़ी मां नग आए, त तू कौस ऐशी सेइं अपने ढ्लाए जो ज़ोई सकतां कि, ‘एई, अवं तेरी एछ़्छ़ी मरां कूड़ो केड्डी!’ ");
INSERT INTO bhd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","हे पाखंडी! पेइले अपने एछ़्छ़ी मरां नग कढ, ते फिरी अपने ढ्लाएरी एछ़्छ़ी मरां रोड़े च़ारे तेकतां कूड़ो केड्डी सकतस।” ");
INSERT INTO bhd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“ज़ैना लोक परमेशरेरू वचन शन्नू न चान, तैन न शुनाथ। अगर तुस एन्च़रे केरेले, त पवित्र चीज़ कुतरन कां छ़डनेरे बराबर ते कने मोती सूरन कां छ़डनेरे बराबर भोले, कि तैना तैन पव्वन हैठ ड्लन्चन ते बेदलोइतां तुसन पुड़ हमलो केरले।” ");
INSERT INTO bhd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“परमेशरे करां मग्गा, त तुसन दित्तू गालू। ते तोप्पा, त तुसन मैल्ली गालू। ते दार गुड़काथ, त तुश्शे लेइ खोल्लू गालू। ");
INSERT INTO bhd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","किजोकि ज़ै कोई मगते तै हासिल केरते, ते ज़ै कोई तोपते तैस मैल्ली गाते, ते ज़ै कोई दार गुड़काते त तैसेरेलेइ खोल्लू गालू। ");
INSERT INTO bhd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","तुसन मां एरो कौन आए, कि अगर तैसेरू मट्ठू रोट्टी मग्गे, त तै तैस घोड़ दे? ");
INSERT INTO bhd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","या अगर मछ़ली मग्गे, त तैस सप दे? ");
INSERT INTO bhd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ते तुस बुरे भोनेरे बावजूद भी अपने मट्ठन रोड़ी चीज़ां देनी ज़ानतथ, त तुश्शो स्वर्गेरो बाजी तुसन रोड़ी चीज़ां कि न देलो, ज़ैना तैस करां मगतन? ");
INSERT INTO bhd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ज़ेरू तुस चातथ कि लोक तुसन सेइं केरन, तुस भी तैन सेइं तेरहु केरा, किजोकि मूसेरे कानूनेरी त कने नेबी केरि लिखोरी शिक्षा ईए आए।” ");
INSERT INTO bhd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“तुस परमेशरेरे राज़्ज़े मां सिर्फ सुन्कड़े दारेरां बत्तां गेइ सकतथ। किजोकि तैन दार चौड़ू, ते तै बत बड़ी खुल्ली आए ज़ै नाशेरे पासे गाचे, ते तैस बत्तां गानेबाले बड़े आन। ");
INSERT INTO bhd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","किजोकि तैन दार सोंकड़ू आए, ते तै बत असुखती आए, ज़ै हमेशारे ज़िन्दगरे पासे गाचे, ते तेरहां गानेबाले थोड़े आन।” ");
INSERT INTO bhd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“झूठे नेबन करां खबरदार रेइयथ, ज़ैना तुसन कां भैड्डां केरे रूपे मां एइतन पन असली मां तैना मारने बालां गिदां भोतन। ");
INSERT INTO bhd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","तुस तैन केरे कम्मन सेइं तैन पिशानेले, कुन लोक झ़ल्लन सैहींयेरां दाछ़ कढतन ते करेरी सैहींयेरां फैगू ट्लोड़तन? ");
INSERT INTO bhd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","एल्हेरेलेइ हर एक्की रोड़े बुट्टे रोड़ो फल लगते, ते हर एक्की बुरे बुट्टे बुरो फल लगते। ");
INSERT INTO bhd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","रोड़े बुट्टे बुरो फल न लग्गे, ते न बुरे बुट्टे रोड़ो फल लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ते ज़ैस बुट्टे रोड़ो फल न लग्गे तै केटतां अग्गी मां फुकतां छ़डतन, तेन्च़रे झूठे नेबन भी सज़ा मैलेली। ");
INSERT INTO bhd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","बस्सा, तुस तैन केरे कम्मन सेइं तैन पिशानेले।” ");
INSERT INTO bhd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“मींजो, ‘हे प्रभु, हे प्रभु,’ ज़ोनेबाले सारे मैन्हु स्वर्गेरे राज़्ज़े मां दाखल न भोले, पन ज़ै, मेरे स्वर्गेरे बाजी केरे मेर्ज़ी पुड़ च़लने बालोए तै ज़रूर दाखल भोले। ");
INSERT INTO bhd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","इन्साफेरे दिहाड़ी बड़े लोक मीं सेइं ज़ोले कि, ‘हे प्रभु, हे प्रभु,’ कुन असेईं तेरे नंव्वे सेइं भविष्यिवाणी नईं कियोरी? ते तेरे नंव्वे सेइं भूतां नईं कढोरां ते तेरे नंव्वे सेइं बड़े चमत्कार नईं हेरेवरे? ");
INSERT INTO bhd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तैखन अवं तैन जो साफ ज़ोलो, ‘अवं तुसन कधे न ज़ैंनी, ओ बुरां कम्मां केरने बालाव, मेरे तुत्तर अगरां दूर भोथ।’” ");
INSERT INTO bhd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“एल्हेरेलेइ ज़ै मेरी गल्लां शुनते ते तैन पुड़ अमल केरते त तै तैस अक्लमन्द मैनेरो ज़ेरो भोलो, ज़ैनी अपनू घर शफड़ी पुड़ बनेवरुए। ");
INSERT INTO bhd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","झ़ड़ी लग्गी ते हड़ाई आई ते अंधगुबारी भोइ ते तैस घरे पुड़ पुज़ी, पन तैन घर न डुल्लू, किजोकि तैसेरी मुनीयाद पेक्की शफ़ड़ी पुड़ कढोरी थी। ");
INSERT INTO bhd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","पन ज़ै मेरी गल्लां शुनते ते तैन पुड़ अमल न केरे, त तै तैस बेवकूफ मैनेरो ज़ेरोए भोलो, ज़ैनी अपनू घर रेती पुड़ बनेवरू थियूं। ");
INSERT INTO bhd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","झ़ड़ी लग्गी ते हड़ाई आईं अंधगुबारी भोइ ते तैस घरे कां पुज़ी ते तैन घर डुल्ली ज़ोवं ते बरबाद भोवं।” ");
INSERT INTO bhd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ज़ैखन यीशुए एना सैरी गल्लां शुनेइतां झ़ैड़ी, त सारे लोक तैसेरी शिक्षा शुन्तां हैरान भोए। ");
INSERT INTO bhd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","किजोकि यीशु तैन शास्त्री लोकां केरि ज़ेरि नईं, बल्के अधिकारे सेइं शिक्षा देतो थियो। ");
INSERT INTO bhd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ज़ैखन तै पहैड़ी पुड़ां उन्ढो अव, त बड़े लोक तैस पत्पती च़ले। ");
INSERT INTO bhd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","तैखन एक्की कोढ़े यीशु कां ज़ैन्धु केरे भारे बिश्तां तैस कां मिन्नत केरतां ज़ोवं, “हे प्रभु अगर तू चास त मेरू कोढ़ बज़्झ़ेई सकतस।” ");
INSERT INTO bhd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","यीशुए तैस पुड़ हथ रेखतां ज़ोवं, “अवं चाताईं, तू बज़्झ़ोस।” ते तै कोढ़ी तैखने साफ भोइ जेव। ");
INSERT INTO bhd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","यीशुए तैस सेइं ज़ोवं, “हेर, एस गल्लरे बारे मां केन्ची सेइं किछ न ज़ोइयां। बल्के अपनो आप याजक हिरा। तैल्ला पत्ती, तू अपने बेज़्झ़ोनेरे वजाई सेइं च़ढ़तल च़ाढ़, ज़ेसेरे बारे मां मूसा नेबे कानूने मां हुक्म दित्तोरोए, ताके लोकन पतो च़ले कि तू बेज्झ़ोरोस।” ");
INSERT INTO bhd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ज़ैखन यीशु कफरनहूम नगर मां अव त अक रोमी सूबेदार ज़ै 100 सिपेहिन केरो अफसर थियो, तैनी यीशु कां एइतां बिनती की। ");
INSERT INTO bhd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“हे प्रभु, मेरो नौकर अधरंगेरो मरीज़ घरे बिमार भोरोए, तै च़लनेरे काबल नईं, ते तै बेड़ि तकलीफी मां आए।” ");
INSERT INTO bhd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","तैनी तैस सेइं ज़ोवं, “अवं एज्जेलो ते तैस बज़्झ़ेइलो।” ");
INSERT INTO bhd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","सूबेदार ज़ोने लगो, हे प्रभु अवं एस काबल नईं कि तू मेरे घरे मां एज्जी सकस; पन तू अगर सिर्फ ज़बाना सेइं ज़ोस त मेरो नौकर बेज़्झ़ोलो। ");
INSERT INTO bhd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","किजोकि अवं भी केन्चेरे अधिकारे मां कम केरताईं, ते सिपाही मेरे अधीन आन, ते ज़ैखन एक्की जो ज़ोताईं कि गा, त तै गाते ते होरि जो ज़ोतां एई, त तै एइते, ते अपने सेवके जो ज़ोताईं इन कम केर त तै केरते। ");
INSERT INTO bhd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","यीशु एन शुन्तां हैरान रेइ जेव, ते एप्पू पत्ती च़लने बाले मैनन् सेइं ज़ोने लगो, “अवं तुसन सेइं सच़ ज़ोताईं, कि मीं इस्राएल मुलखे मां इस गैर यहूदी मैनेरो ज़ेरो मैन्हु नईं लोवरो ज़ै मीं पुड़ एत्रो विश्वास केरे।” ");
INSERT INTO bhd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","अवं तुसन सेइं ज़ोताईं कि बड़े गैर कौमां केरे लोक पूर्बेरां ते पछमेरां एइतां अब्राहमे, इसहाक ते याकूबे सेइं साथी परमेशरेरे राज़्ज़ेरी धामी मां शामिल भोले। ");
INSERT INTO bhd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","पन इस्राएली लोक बेइर आंधरे मां छ़ड्डे गाले ज़ैड़ी तैना लेरां देते ते दंत च़ापते राले। ");
INSERT INTO bhd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ते यीशुए तैस सूबेदारे सेइं ज़ोवं, “घरे जो गा, ज़ेरो तेरो विश्वासे तेरे लेइ तेरहु भोलू,” ते तैखने तैसेरो नौकर बेज़्झ़ोइ जेव। ");
INSERT INTO bhd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ज़ैखन यीशु पतरसेरे घरे जेव, त तैनी हेरू, कि पतरसेरी शिखी बड़ो भुखारे, ते तै लेटोरी थी। ");
INSERT INTO bhd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","तैनी तैसारो हथ ट्लातो ते अकदम तैसारो भुखार उतरी जेव, ते तै खड़ी उट्ठतां तैसेरी सेवा केरने लग्गी। ");
INSERT INTO bhd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ज़ैखन ड्लोझ़ भोइ त लोकेईं बड़े बिमार, ज़ैन पुड़ भूतां केरो सायो थियो तैस कां आने, ते तैनी तैना भूतां अपने वचने सेइं कढां, ते सारे बिमार बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ताके यशायाह नेबेरी ज़ोरी तै गल पूरी भोए कि, “तैनी एप्पू इश्शी कमज़ोरी हटेइ ते इश्शी बिमैरी भी मुकेइ।” ");
INSERT INTO bhd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","यीशुए अपने च़ेव्रे पासन मैन्हु केरि भीड़ लेइतां अपने चेलन, गलील समुन्दरे पार गानेरो हुक्म दित्तो। ");
INSERT INTO bhd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ज़ैखन तैना पार गानेरी तियारी केरने लग्गे, त तैखन अक शास्त्री मैन्हु तैस कां एइतां ज़ोने लगो, “गुरू, तू ज़ेरहां भी गालो त अवं तीं पत्ती च़लेलो।” ");
INSERT INTO bhd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","यीशुए तैस जो ज़ोवं, “लौई केरि कूढां, ते अम्बरेरे च़ुड़ोल्लू केरे आले भोतन, पन मैनेरे मट्ठे यानी मीं कां कोई ठार नईं ज़ैड़ी अवं झ़ुल्ली सेक्खी।” ");
INSERT INTO bhd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","चेलन मरां एक्के होरे तैस सेइं ज़ोवं, “हे प्रभु, मीं घरे गानेरी अज़ाज़त दे, मेरे बाजेरे मरनेरां बाद अवं तैस देबतां एज्जेलो ते फिरी तीं पत्ती च़लेलो।” ");
INSERT INTO bhd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","यीशुए तैस जो ज़ोवं, “तू मेरो चेलो बन ते मीं पत्ती च़ल, ते ज़ैना लोक आत्मिक तरीके सेइं मर्रेन तैन अपने मैन्हु मरने बलगने दे।” ");
INSERT INTO bhd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ज़ैखन यीशु किश्ती मां च़ढ़ो त तैसेरे चेले भी तैस सेइं साथी च़ले। ");
INSERT INTO bhd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ते अचानक समुन्दरे मां अक बड़ो तूफान अव ते किश्ती छ़ेलहेईं सेइं छ़पने लग्गी ते यीशु तैस मां झ़ुल्लोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","तैखन चेलेईं तै बींझ़ेइतां तैस सेइं ज़ोवं, “हे प्रभु, असन बच़ा! अस त डुबने लोरेम!” ");
INSERT INTO bhd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","तैनी तैन सेइं ज़ोवं, “हे घट विश्वासे बालाव, तुस किजो डरतथ?” तैखन तैनी खड़े उट्ठतां तूफान त समुन्दर डांटो, तैखने तूफान रुकी जेव त समुन्दर बड़े शांत भोव। ");
INSERT INTO bhd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","लोक हैरान भोइतां ज़ोने लग्गे, “ए मैन्हु कौन आए कि तूफान त समुन्दर भी एसेरो हुक्म मन्तन!” ");
INSERT INTO bhd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ज़ैखन तै गलील समुन्दरेरे पार, गिरासेनी इलाके मां पुज़ो, त दूई मैन्हु ज़ैन पुड़ भूतां केरो सैयो थियो कब्रन मांमेइं यीशु कां मिलने आए। तैना एत्रे निग्गर थिये, कि कोई भी तैस बत्तां निस्सी न थियो बटतो। ");
INSERT INTO bhd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","तैना ज़ोरे-ज़ोरे चिन्डां मारने लग्गे ते ज़ोने लग्गे, हे परमेशरेरा मट्ठां, तीं असन सेइं कुन कम्मे? कुन तू वक्ते करां पेइले असन नरके मां छ़डने ओरोस? ");
INSERT INTO bhd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","तैन केरां दूर सूरां केरो अक बड़ो घान च़रने लोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","भूतेईं यीशु कां मिनत केरतां ज़ोवं, “अगर तू असन कढने चातस त उन सूरां केरे घाने मांजो भेज़।” ");
INSERT INTO bhd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","तैखन यीशुए ज़ोवं, “गाथ,” तैना भूतां तैट्ठां निस्तां तैन सूरां केरे घाने मां जेआं, ते सूरां केरो सारो घान उछ़ड़तो-उछ़ड़तो डैल्ले मां गेइतां सारे सूर मेरि जे। ");
INSERT INTO bhd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","तैखन सूरां केरे च़ारनेबालेईं एन हेरू, त तैना डेरि जे, ते तैनेईं नगरेरे लोकन सेइं सारो बिस्तार दित्तो, ते ज़ैन पुड़ भूतां केरो सैयो थियो तैन केरो हाल भी शुनाव। ");
INSERT INTO bhd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","तैस नगरेरे सारे लोक यीशु सेइं मिलनेरे लेइ आए ते यीशु लेइतां लोक मिनत केरतां ज़ोने लग्गे, इश्शे इलाके मरां च़लो गा। ");
INSERT INTO bhd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","फिरी यीशु किश्ती मां च़ेढ़तां दरियाए पार जो जेव, ते अपने नगर मां अव। ");
INSERT INTO bhd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ते हेरा, किछ मैनेईं अक अधरंगी मैन्हु खट्टी पुड़ छ़ुइतां तैस कां आनो, ज़ैखन यीशुए तैन केरो विश्वास हेरो, त तैस अधरंगी मैन्हु जो ज़ोवं, “मट्ठा, गा हिम्मत रख, तेरे पाप माफ़ भोए।” ");
INSERT INTO bhd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","एस गल्ली पुड़ किछ शास्त्री एप्पू मांमेइं ज़ोने लग्गे, “ए त परमेशरेरी तुहीन केरते!” ");
INSERT INTO bhd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","यीशुए तैन केरि मनेरी गल्लां बुझ़तां तैन जो ज़ोवं, “तुस अपने-अपने मने मां एन्च़रां किजो सोचने लग्गोरेथ? ");
INSERT INTO bhd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","एन ज़ोनू कुन सुखतुए कि गा ‘तेरे पाप माफ़ भोए,’ या एन ज़ोनू कि ‘उठ, ते च़ल फिर?’ ");
INSERT INTO bhd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","पन अवं किछ केरनेबालोईं, ज़ैस सेइं तुसेईं बुज़्झ़नूए कि मैनेरे मट्ठे (यानी मीं) धेरती पुड़ लोकां केरे पाप माफ़ केरनेरो अधिकार आए।” तैखन तैनी तैस अधरेंगी मैन्हु जो ज़ोवं, “अपनि खट छ़ुइतां अपने घरजो च़लो गा।” ");
INSERT INTO bhd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","तै अधरंगी मैन्हु तैखने अपनि खट छ़ुइतां घरजो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","लोक एन हेरतां डेरि जे ते परमेशरेरी बड़याई केरने लग्गे, कि ज़ैनी मैन्हु एत्रो अधिकार दित्तोरोए। ");
INSERT INTO bhd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ज़ैखन यीशु तैट्ठां अग्रोवं च़लो त तैनी अक मत्ती नंव्वेरो मैन्हु, चुंगी नेनेबालो दफ़तरे मां बिश्शोरो लाव, ते यीशुए तैस जो ज़ोवं, “तू मीं पत्ती च़ल।” तै तैखने यीशु पत्ती च़लो। ");
INSERT INTO bhd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ते ज़ैखन यीशु अपने चेलेरे घरे गेइतां रोट्टी खाने बिश्शो ज़ेसेरू नवं मत्ती थियूं, त बड़े चुंगी नेनेबाले ते पापी मैन्हु भी आए ते यीशु त तैसेरे चेलन सेइं साथी रोट्टी खाने बिश्शे। ");
INSERT INTO bhd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ज़ैखन फरीसी लोकेईं एन हेरू, त तैनेईं तैसेरे चेलन पुच़्छ़ू, “तुश्शो गुरू चुंगी घिन्ने बाले ते पैपी लोकन सेइं साथी रोट्टी किजो खाते?” ");
INSERT INTO bhd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","एन शुन्तां यीशुए तैन मिसाल देइतां ज़ोवं, “सझ़र लोकन डाक्टरेरी ज़रूरत न भोए, पन बिमारन भोचे।” ");
INSERT INTO bhd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","फिर भी तुस गेइतां एस गल्लरो मतलब कढा, “अवं बलिदान नईं बल्के दया पसंद केरताईं, किजोकि अवं धर्मी लोकन नईं बल्के पापी लोकन कुजाने ओरोईं।” ");
INSERT INTO bhd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","तैखन यूहन्नारे चेले यीशु कां एइतां ज़ोने लग्गे कि कुन वजा आए, कि अस ते फरीसी लोक त बरत रखतम, पन तेरे चेले किजो बरत न रखन? ");
INSERT INTO bhd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","यीशुए तैनन् जुवाब दित्तो, “ड्लाएरे दिहाड़े, ज़ैखन लाड़ो जैनी सेइं साथी राते, कुन जन शौग बनेइं सकतन? पन तैना दिहाड़े एज्जले, ज़ेइस लाड़ो तैन केरां अलग कियो गालो (यानी मारो गालो), तैखन तैना (अपने दुख्खेरे वजाई सेइं) बरत रख्खेले। ");
INSERT INTO bhd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","अवं तुसन अक होरि मिसाल देताईं, नंव्वे लिगड़ेरी टलोई पुराने लिगड़े कोई न लाए। किजोकि नंव्वे लिगड़ेरी टलोई पुराने लिगड़े अपने पासे खिच्ची छ़ड्डेली। ते तैन पेइले केरां भी जादे छ़िन्दोलू। ");
INSERT INTO bhd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ते नंव्वो दाछ़ारो रस पुरैनी मसकन मां न भरन, किजोकि मसकां फैट्टी गाचिन ते दाछ़ारो रस ज़ैया भोइ गाते ते मसकां भी कोन्ची कम्मेरी न रान। एल्हेरेलेइ नंव्वो दाछ़ारो रस नेव्वीं मसकी मां छ़डतन ताके दुइये बरबाद न भोन।” ");
INSERT INTO bhd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","यीशु एन गल्लां हेजू मसां ज़ोने लोरो थियो, त प्रार्थना घरेरो अक प्रधान अव ते यीशु कां मथ्थो टेकतां ज़ोने लगो, मेरी कुई मेरि जोरीए, “पन तू अगर एइतां तैस पुड़ हथ रख्खस त तै हुन्ना ज़ींती भोइ गानीए।” ");
INSERT INTO bhd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","यीशु तैस सेइं साथी च़लो जेव, ते चेले भी तैस सेइं साथी जे। ");
INSERT INTO bhd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ते एरू भोवं कि अक कुआन्श भी थी, ज़ैस 12 सालां केरि खून च़लनेरी बिमारी थी। तैसां यीशु पत्पती एइतां तैसेरे चोगे सेइं हथ लाव। ");
INSERT INTO bhd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","किजोकि तै अपने दिले मां एन ज़ोती थी, कि अगर अवं यीशुएरे चोगे सेइं हथ लाएली त अवं बेज़्झ़ोइ गानीं। ");
INSERT INTO bhd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","यीशुए बेदलोइतां तैस कुआन्शरे पासे तक्कू ते ज़ोवं, “हे कुईए, विश्वास रख, तेरे विश्वासे सेइं तू बेज़्झ़ोरस” ते तै तैखने बेज़्झ़ोइ जेई। ");
INSERT INTO bhd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ज़ैखन यीशु तैस प्रधानेरे घरे पुज़ो, त लोक नगारो बज़ाते ते लेरां देंते लाए। ");
INSERT INTO bhd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","तैखन यीशुए तैन लोकन सेइं ज़ोवं, “दूर भोथ, किजोकि कुई मर्री नईं, बल्के झ़ुल्लोरीए।” एन शुन्तां तैना लोक हसने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","पन ज़ैखन लोक तैट्ठां दूर कढे, त यीशुए अन्तर गेइतां कुइयरो हथ ट्लाव, त तै ज़ींती भोइ। ");
INSERT INTO bhd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ते एस गल्लरी खबर सारे इलाके मां फैली जेई। ");
INSERT INTO bhd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ज़ैखन यीशु तैट्ठां अग्रोवं च़लो, त दूई काने तैस पत्ती चिन्डां मारते ज़ोने लग्गे, “हे दाऊदेरा मट्ठां असन पुड़ दया केर!” ");
INSERT INTO bhd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ज़ैखन तै घरे अन्तर जेव, त तैना काने तैस कां आए, ते यीशुए तैन सेइं ज़ोवं, “कुन तुसन विश्वासे, कि अवं तुसन बज़्झ़ेई सकताईं?” तैनेईं जुवाब दित्तो “हाँ प्रभु, अस विश्वास केरतम, तू असन बज़्झ़ेइं सकतस।” ");
INSERT INTO bhd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तैखन तैनी तैन केरि एछ़्छ़न सेइं हथ लाव ते ज़ोवं, “तुस विश्वास केरतथ कि अवं बज़्झ़ेई सकताईं, अवं तुसन बज़्झ़ेइलो।” ");
INSERT INTO bhd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ते तैना लहने लाए, ते यीशुए तैन रोड़ेच़ारे समझ़ेइतां ज़ोवं, “खबरदार ज़ैन मीं तुश्शे लेइ कियूं तैसेरे बारे मां कोन्ची सेइं न ज़ोइयथ!” ");
INSERT INTO bhd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","पन तैनेईं बेइर गेइतां सारे मुलखे मां एस चमत्कारेरे बारे मां ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ज़ैखन तैना बेइर च़लोरोरे थिये, त लोकेईं अक मैन्हु ज़ै गल्लां न थियो केरि बटतो, किजोकि तैस पुड़ भूतेरो सैयो थियो, तै तैनेईं यीशु कां आनो। ");
INSERT INTO bhd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ते ज़ैखन भूतेरो सैयो तैस मेरां कढो, त लट्टो गल्लां केरने लगो, लोक बड़े हैरान भोइजेइ ते ज़ोने लग्गे, असेईं एरो ज़ेरो माजरो इस्राएले मां पेइले कधे नईं लाहोरो। ");
INSERT INTO bhd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","पन फरीसी लोक ज़ोने लग्गे, “ए त भूतां केरे गुरेरी मद्दी सेइं भूतां कढते।” ");
INSERT INTO bhd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","यीशु त कने तैसेरे चेले गलील इलाकेरे ड्लोंव्वन ते नगरन मां ते प्रार्थना घरन मां जे। ते तै शिक्षा देतो राव, ते परमेशरेरे राज़्ज़ेरी खुशखबरी शुनातो राव, ते लोकां केरि हर किसमेरी बिमारी ते कमज़ोरी दूर केरतो राव। ");
INSERT INTO bhd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ज़ैखन तैनी बड़े लोक लाए त तैस तैन लोकन पुड़ बड़ो तरस अव, किजोकि तैना तैन भैड्डां केरे ज़ेरे थिये ज़ैन केरो कोई पुहाल न भोए, तैन केरो बड़ो बुरो हाल थियो ते तैना टेपलोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","तैखन यीशुए अपने चेलन सेइं ज़ोवं, “पकोरी फसलरे ज़ेरे बड़े लोक तियार आन ज़ैना परमेशरेरे वचने पुड़ विश्वास केरनू चातन, पन कम केरनेबाले थोड़े आन ज़ैना तैन परमेशरे राज़्ज़ेरे बारे मां ज़ोन। ");
INSERT INTO bhd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","एल्हेरेलेइ तुस फसलरे मालिके कां प्रार्थना केरा कि तै जादे कम केरनेबाले भेज़े, कि तैना लोकन परमेशरेरे राज़्ज़ेरे बारे मां ज़ोन।” ");
INSERT INTO bhd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","फिरी यीशुए अपने 12 चेले एप्पू कां कुजाए, ते तैन भूतां केरो सैयो कढनेरो ते हर बिमारी ते तकलीफ दूर केरनेरो अधिकार दित्तो। ");
INSERT INTO bhd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","12 प्रेरितां केरां नव्वां इना आन, शमौन ज़ैस जो पतरस ज़ोतन ते तैसेरो ढ्ला अन्द्रियास, जब्देरू मट्ठू याकूब ते कने तैसेरो ढ्ला यूहन्ना, ");
INSERT INTO bhd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिप्पुस, बरतुल्मै, थोमा, ते मत्ती चुंगी घिन्ने बालो, हलफईरू मट्ठू याकूब, ते तद्दै। ");
INSERT INTO bhd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","शमौन कनानी, ते यहूदा इस्करियोती ज़ैनी तै ट्लुवेवरो भी थियो। ");
INSERT INTO bhd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","एन 12 यीशुए एन ज़ोइतां भेज़े, “गैर कौमां केरे पासे न गेइयथ, ते कने सामरी लोकां केरे केन्ची नगर मां न गेइयथ। ");
INSERT INTO bhd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","बल्के इस्राएलेरे घरानेरी हेरोरि भैड्डन कां गेइयथ। ");
INSERT INTO bhd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ते च़लते-च़लते, एन ज़ोंते गेइयथ कि स्वर्गेरू राज़ नेड़े ओरूए। ");
INSERT INTO bhd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","बिमारन बज़्झ़ेइयथ, मुड़दन ज़ींते केरथ, कोढ़ी केरू कोढ़ साफ केरथ, ते भूतां केरो सैयो केढथ, तुसन एन सब किछ मुफ्त मैलोरूए ते मुफ्त देइयथ। ");
INSERT INTO bhd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ते साथी सोन्नू, चाँदी ते पेंइसे न रेखथ। ");
INSERT INTO bhd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ते न बत्तारे लेइ झोलो नेइयथ ते न दूई-दूई लिगड़ां, ते न बूट ते न सोटी, किजोकि मज़दूर अपनि मज़दूरारो हकदार भोते।” ");
INSERT INTO bhd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ज़ैखन तुस केन्ची नगर या ड्लोव्वें मां गाथ त तुस एरे मैनेरो पतो केरथ, कि कौन अतबारेरे काबल? तैट्ठां ज़ां तगर गानेरो वक्त न एज्जे त तांतगर तैड़ी तैस्से कां रेइयथ। ");
INSERT INTO bhd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ते घरे मां अन्तर गांते बार तैन जो शान्ति देइयथ।” ");
INSERT INTO bhd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","“अगर तैन घर तुश्शे काबल भोलू त शान्ति पुज़ेली, ते अगर तैन घर तुश्शे काबल न भोलू त तुश्शी शान्ति तुसन पुड़ वापस एज्जेली। ");
INSERT INTO bhd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ज़ै तुसन कबूल न केरे ते तुश्शी गल न मन्ने त तैस घरे या नगर मरां बेइरोवं गांते बार अपने पावां केरि धूड़ तैड़ी झ़ैड़थ।” ");
INSERT INTO bhd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","“अवं तुसन सेइं सच़ ज़ोताईं कि इन्साफेरे दिहाड़े तैस नगरेरो हाल सदोम ते अमोरा नगरां केरे हाले करां भी जादे बुरो भोलो।” ");
INSERT INTO bhd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“हेरा, अवं तुसन भैड्डां केरे गिदन मां भेज़ने लोरोईं, एल्हेरेलेइ तुस सप्पां केरे ज़ेरे हुशार ते कबूतरां केरे ज़ेरे सादे बेनथ। ");
INSERT INTO bhd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","मैनन् करां हुशार रेइयथ तैना तुसन ट्लेइतां सभान मां पैश केरेले ते प्रार्थना घरन मां तुसन कोड़ां केरि मार दुवाले। ");
INSERT INTO bhd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ते तुसन मेरी वजाई सेइं गवर्नरन ते कने राज़न कां हाज़र केरेले, ताके तुस तैन मां ते गैर कौमन मां मेरे गवाह बन्थ। ");
INSERT INTO bhd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","पन ज़ैखन तैना ट्लुवेइतां हावाले केरेले, त तुस फिक्र न केरथ, कि अस कुन ज़ोमेले ते केन्च़रे ज़ोमेले, किजोकि ज़ैन किछ ज़ोनू भोलू तैखने अवं तुसन ज़ोइलो। ");
INSERT INTO bhd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","किजोकि ज़ोने बाले तुस नईं, बल्के पवित्र आत्मा भोलो ज़ै तुश्शे स्वर्गेरे बाजी परमेशरेरे तरफां आए।” ");
INSERT INTO bhd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ढ्ला, ढ्लाए ते बाजी मट्ठे मारनेरे लेइ सोंफेले, ते मट्ठां अपने अम्मा बाजी केरे खलाफ भोइतां तैन माराले। ");
INSERT INTO bhd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","मेरे नंव्वेरो वजाई सेइं सब लोक तुसन सेइं बैर केरेले, पन ज़ै आखरी तगर बरदाशत केरेलो तैस्से मुक्ति मैलेली। ");
INSERT INTO bhd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ज़ैखन लोक तुसन एक्की नगर मां सताले, त होरि नगर मांजो नेश्शी गेइयथ, अवं तुसन सेइं सच़ ज़ोताईं कि एस करां पेइले तुस इस्राएलेरे सैरी नगरन मां तुश्शू सफर पूरू न भोलू, त अवं मैनेरू मट्ठू एज्जी गालू।” ");
INSERT INTO bhd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“चेलो अपने गुरू करां बड्डो न भोए, ते न नौकर अपने मालिके करां। ");
INSERT INTO bhd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","चेलेरे लेइ त एन्ने बड़ुए कि तै अपने गुरेरो ज़ेरो भोए, ते नौकरेरे लेइ एन्ने बड़ुए कि तै अपने मालिकेरे बराबर भोए, अगर तैनेईं मालिके जो शैतान ज़ोवं, त तैसेरे घरेबालन जो केत्रू ज़ोनूए!” ");
INSERT INTO bhd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“तुस तैन करां न डेरथ, किजोकि कोई चीज़ छ़प्पोरी नईं, ज़ै खोल्ली न गाली, ते कोई भेद छ़प्पोरो न रालो, बल्के सारो भेद बांदो भोलो। ");
INSERT INTO bhd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ज़ैन किछ अवं तुसन सेइं आंधरे मां ज़ोताईं, तुस तैन दीसां ज़ोइयथ, ते ज़ैन किछ तुश्शे कन्ने पत्र बल्हे सेइं शुनावं गाते, तुस लाए पुड़ गेइतां तैसेरो प्रचार केरथ। ");
INSERT INTO bhd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","तुस तैन करां न डेरथ ज़ैना जानी त मारतन, पन आत्मा न मैरी बटन, परमेशरे करां डरा, ज़ै आत्माई ते जानी दुइने नरके मां नाश केरि बटते। ");
INSERT INTO bhd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","कुन एक्की सिकेरी दूई च़ड़ोली न बिकन? फिरी भी तुश्शो बाजेरे मेरज़रे बगैर तैन मरां अक भी धेरती पुड़ न झ़ेड़ी बटन। ");
INSERT INTO bhd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","परमेशर तुश्शे हर गल्लरी फिक्र केरते इड़ी तगर तुश्शे दोग्गेरे बाल भी गन्नोरेन। ");
INSERT INTO bhd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","एल्हेरेलेइ डरा न, तुश्शी कदर बेड़ि च़ड़ोलन करां भी बड़ी जादे।” ");
INSERT INTO bhd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ज़ैना लोक, मैन्हु केरे सामने मेरो इकरार केरतन कि तैना मेरे चेलेन, त अवं भी अपने स्वर्गेरो बाजी केरे सामने तैन केरो इकरार केरेलो, कि तैना मेरे चेलेन। ");
INSERT INTO bhd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","पन ज़ैना लोक, मैन्हु केरे सामने इन ज़ोने करां डरेले, कि तैना मेरे चेलेन, त अवं भी तैन केरो अपने स्वर्गेरो बाजेरे सामने इन्कार केरेलो, कि एना मेरे चेले नईं।” ");
INSERT INTO bhd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“इन न सैमझ़थ कि अवं धेरती पुड़ एल्हेरेलेइ ओरोईं लोक मेल मिलापे सेइं रान, पन मेरू एजनू लोकन एप्पू मांमेइं लड़नेरी वजा भोइ, मेल मलाप नईं। ");
INSERT INTO bhd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","अवं एल्हेरेलेइ ओरोईं कि मट्ठे बाजी करां ते कुइये अम्मा करां ते नुशी शिखी करां अलग केरि। ");
INSERT INTO bhd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","मैनेरे दुश्मन त तैसेरे अपने घरेरे लोक भोनेन।” ");
INSERT INTO bhd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ज़ै कोई अम्मा या बाजी मीं करां जादे ट्लारे समझ़ते, तै मेरो चेलो बन्नेरे काबल नईं ते ज़ै कोई मट्ठे या कुइये मीं करां जादे समझ़ते, तै भी मेरो चेलो बन्नेरे काबल नईं। ");
INSERT INTO bhd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ज़ै कोई मेरो चेलो भोनेरी वजाई सेइं दुःख झ़ैल्लनेरे लेइ त कने मरनेरे लेइ तियार नईं, त तै भी मेरो चेलो बन्नेरे काबल नईं। ");
INSERT INTO bhd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ज़ै कोई मरने करां बच़नेरे लेइ मेरो इन्कार केरेलो, त तैन हमेशारी ज़िन्दगी न मैलेली। पन ज़ै मीं पुड़ विश्वास केरनेरे वजाई सेइं अपने जान देनेरे लेइ भी तियार भोलो, त तैस हमेशारी ज़िन्दगी मैलेली। ");
INSERT INTO bhd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ज़ैना तुसन कबूल केरतन, तैना मीं कबूल केरतन, ज़ैना मीं कबूल केरतन, तैना सिर्फ मीं नईं, पन तैना परमेशरे भी कबूल केरतन, ज़ैनी अवं इड़ी भेज़ोरोईं।” ");
INSERT INTO bhd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","“ज़ै नेबन, नबी सेमझ़तां कबूल केरेलो, परमेशर तैस नेबी केरे बराबर इनाम देलो, ते ज़ै धेर्मी मैन्हु धर्मी सेमझ़तां कबूल केरते, परमेशर तैस धेर्मी बराबर इनाम देलो। ");
INSERT INTO bhd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ज़ै कोई इन निकड़न मरां एक्की मेरो चेलो बुझ़तां सिर्फ अक कटोरो ठंढू पानी पियालो, अवं तुसन सेइं सच़ ज़ोताईं तैस पक्कू इनाम मैलनू आए।” ");
INSERT INTO bhd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ज़ैखन यीशुए अपने 12 चेलन हुक्म दित्तो, त तै तैट्ठां च़लो जेव, ताके चेलां केरे नगरन मां गेइतां शिक्षा दे ते प्रचार केरे। ");
INSERT INTO bhd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","यूहन्ना नेबे कैदखाने मां मसीहेरे कम्मां केरे बारे मां शुन्तां तैस कां अपने चेले इन पुच्छ़ने भेज़े। ");
INSERT INTO bhd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“तैनी तैन सेइं ज़ोवं, एजनेबालो मसीह तू आस, ज़ेसेरे बारे मां परमेशरे वादो कियोरोए, या आस केन्ची होरि बलगम?” ");
INSERT INTO bhd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","यीशुए तैन जुवाब दित्तो, “ज़ैन किछ तुस शुन्तन ते लातथ तैन गेइतां यूहन्ना सेइं ज़ोथ। ");
INSERT INTO bhd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","कि काने लातन, ते टोन्टे च़लतन, ते कोढ़ी केरू कोढ़ शुद्ध भोते, ते टोंऊने शुन्तन, ते मुड़दे ज़ींते भोतन, ते गरीबन खुशखबरी शुनाई गातीए ");
INSERT INTO bhd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","परमेशर तैस बरकत देते, ज़ै मीं पुड़ शक न केरे।” ");
INSERT INTO bhd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ज़ैखन यूहन्नारे चेले तैट्ठां च़ले जे, त यीशु लोकन सेइं यूहन्नारे बारे मां ज़ोने लगो, “तुस सुनसान ठैरी कुन हेरने जोरे थिये? कुन हवाई सेइं हिलते निरैठरे डाले? ");
INSERT INTO bhd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","त फिरी होरू कुन हेरने जोरे थिये? माघां लिगड़ां लेइतां कोई? हेरा ज़ैन माघां लिगड़ां लेइतां भोतन तैना महलन मां रातन। ");
INSERT INTO bhd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","फिरी तुस कुन हेरने जोरे थिये? कुन कोई नेबी? हाँ पन अवं तुसन सेइं ज़ोताईं कि नेबी करां भी बड्डे हेरने जोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ई तैए यूहन्ना आए ज़ेसेरे बारे मां परमेशर पवित्रशास्त्रे मां ज़ोते, कि हेरा, ‘अवं अपने बिस्तार देनेबालो तीं अग्री भेज़ताईं, ज़ै तेरे लेइ बत तियार केरेलो।’” ");
INSERT INTO bhd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","अवं तुसन सेइं सच़ ज़ोताईं, कि ज़ै कुआन्शन करां ज़रमोरोए तैन मां यूहन्ना बपतिस्मो देनेबाले करां कोई बड्डो नईं भोरो, पन ज़ै स्वर्गेरे राज़्ज़े मां निकड़े करां निकड़ोए तै तैस करां भी बड्डोए। ");
INSERT INTO bhd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","यूहन्ना बपतिस्मो देनेबालेरे दिहाड़न करां अज़ तगर प्रचार भोइ रावरोए, ते स्वर्गेरू राज़ जल्दी बधने लोरूए, पन बड़े निग्गर लोक तैस पुड़ हमलो केरतन। ");
INSERT INTO bhd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","सारे नेबी केरे लेख, ते मूसेरो कानून यूहन्ना तगर भविष्यिवाणी केरते राए। ");
INSERT INTO bhd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","अगर तुस चाथ ते मन्नथ, एलिय्याह ज़ेसेरे बारे मां नेबेईं ज़ोरू थियूं, कि तै एजनेबालो थियो तै ईए। ");
INSERT INTO bhd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ज़ै कोई समझ़नू चाते, तै ध्याने सेइं शुने ते समझ़े। ");
INSERT INTO bhd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“अवं इस ज़मानेरे लोकां केरि मिसाल केस सेइं देईं, इना तैन मट्ठां केरे ज़ेरेन ज़ैना बज़ारन मां बिश्तां अपने दोसन सेइं शिकैयत केरतन, ");
INSERT INTO bhd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","कि असेईं तुश्शे लेइ बाज़ो बज़ाव, ते तुस न नच़्च़े, ते असेईं शौग कियो ते तुसेईं छाती न पिट्टी। ");
INSERT INTO bhd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","किजोकि यूहन्ना बपतिस्मो देनेबालो जादे तर बरत रखतो थियो, ते शराब न थियो पीतो, ते तैना तैस जो ज़ोतन कि एस पुड़ भूतेरो सैयो आए। ");
INSERT INTO bhd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ते मैनेरू मट्ठू यानी अवं खातो पीतो अव, हेरा, ते तैना ज़ोतन पेटू ते शराबी मैन्हु ते चुंगी नेनेबाले ते पापी लोकां केरो दोस्त, पन अक्लमन्द कौने तैसेरे कम्मेईं सेइं पतो च़लते।” ");
INSERT INTO bhd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","तैखन यीशु फिरी तैन नगरन मां गेइतां तैट्ठेरे लोकन झ़िड़कतां ज़ोने लगो, ज़ैन मां तैनी चमत्कार कियोरे थी, पन तैनेईं अपने पापन करां मन न फिराव। ");
INSERT INTO bhd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“हे खुराजीन नगरेरे लोकव! तुसन पुड़ अफ़सोस, हे बैतसैदा नगरेरे लोकव तुसन पुड़ अफ़सोस, कि ज़ैना चमत्कार तुसन मां किये, अगर एना चमत्कार सूर ते सैदा नगरन मां कियोरे भोथे, त तैन लोकेईं केइसेरे देंतेरी टाट पलेटतां ते मांज़नी मां बिश्तां अपने पापन करां मनफिरावरो भोथो। ");
INSERT INTO bhd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","पन अवं तुसन सेइं ज़ोताईं, कि इन्साफेरे दिहाड़े परमेशर, ज़ै सज़ा सूर ते सैदा नगरां केरे लोकन देलो, तुश्शी सज़ा तैस करां भी जादे भोली। ");
INSERT INTO bhd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ते हे कफरनहूम नगरेरे लोकव, कुन तुस सोचतथ कि स्वर्गे मां तुश्शी आदर भोनीए! नईं तुस त नरके गाले ज़ैड़ी पापी लोकन सज़ा मैलेली! किजोकि ज़ैना चमत्कार तुसन मां किये, अगर मीं एना सदोम नगरे मां कियोरे भोथे त सदोम नगर अज़ तगर भी भोनू थियूं। ");
INSERT INTO bhd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","पन अवं तुसन ज़ोतां कि इन्साफेरे दिहाड़े परमेशर ज़ै सज़ा सदोम नगरेरे लोकन देलो, तुश्शी सज़ा तैस करां भी जादे भोली।” ");
INSERT INTO bhd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","तैखन यीशुए ज़ोवं, “हे बाजी, स्वर्ग ते धेरतरे प्रभु, अवं तेरू शुक्र केरतां कि तीं एना गल्लां अक्लमन्द ते समझ़दार लोकन करां छ़पेइतां रेख्खी ते तैन लोकन पुड़ बैंदी की, ज़ैना निक्के बच्चां केरे ज़ेरे आन। ");
INSERT INTO bhd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हाँ, हे बाजी तीं एन्ने रोड़ू लग्गू। ");
INSERT INTO bhd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“मेरे बाजेईं सब किछ मेरे सुपुर्द कियोरूए; कोई होरो मट्ठे न ज़ांने, सिर्फ बाजी ज़ानते; कोई बाजी न ज़ांने सिर्फ मट्ठू ज़ानते, या तै मैन्हु बाजी ज़ानते ज़ैस पुड़ मट्ठू बांदो केरने चाए। ");
INSERT INTO bhd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“हे मेहनत केरनेबाले लोकव, ते भारे सेइं थकोरे लोकव मीं कां एज्जा; अवं तुसन आराम देइलो। ");
INSERT INTO bhd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","मेरे अधीन एन्च़रे भोथ ज़ेन्च़रे दांत जूंए हैठ भोते, ते ज़ैन किछ अवं तुसन शिखालताईं तैस शिख्खा, किजोकि अवं शरीफ आईं ते दिलेरो नम्र आईं ते तुश्शी जानी आराम मैलेलो। ");
INSERT INTO bhd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ज़ै भार अवं तुसन देइलो तै पोल्लोए, तुस तैस आरामे सेइं छ़ुई सकतथ।” ");
INSERT INTO bhd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","यीशु आरामेरे दिहाड़े ऊडारन मांमेइं एक्की बत्तां च़लोरे थियो, ते तैसेरे चेलन ढ्लुख लग्गी, ते तैना शिल्लां ट्लोड़तां खाने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","फरीसी लोकेईं एन लेइतां यीशु सेइं ज़ोवं, “तक! तेरे चेले तैन कम केरने लोरेन ज़ैन आरामेरे दिहाड़े केरनू जेइज़ नईं।” ");
INSERT INTO bhd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","यीशुए तैन जुवाब दित्तो, “कुन तुसेईं पवित्रशास्त्रे मां कधे नईं पढ़ेरू कि ज़ेइस इश्शे पूर्वज दाऊद राज़ो त तैसेरे साथी ढ्लुखोरे थिये त तैनेईं कुन कियेरू थियूं? ");
INSERT INTO bhd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","तै केन्च़रे परमेशरेरे घरे मां जेव, ते ज़ैना च़ैढ़ोरी रोट्टी थी तैट्ठां एन्तां एप्पू भी खेइ, ते अपने सैथन भी दित्ती, ते तैनेईं भी खेइ हालांकी तैना रोट्टी खैनी तैन केरे लेइ ज़ेइज थी, तैना सिर्फ याजक खेइ सकते थिये। ");
INSERT INTO bhd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","या तुसेईं मूसेरो कानूने मां एन भी नईं पढ़ेरू, कि याजक मन्दरे मां आरामेरे दिहाड़ेरी विधि न मन्ने पुड़ भी बेकसूर भोतन। ");
INSERT INTO bhd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","पन अवं तुसन सेइं ज़ोताईं कि इड़ी तैए, ज़ै मन्दरे करां भी बड्डोए। ");
INSERT INTO bhd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","अगर तुस एल्हेरो मतलब ज़ांनेथे कि, अवं बलिदान नईं बल्के दया पसंद केरताईं, त तुस बेकसूर कुसुरवार न बनाथे। ");
INSERT INTO bhd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","किजोकि मैनेरू मट्ठू यानी अवं आरामेरे दिहाड़ेरो भी प्रभु आईं।” ");
INSERT INTO bhd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","यीशु तैट्ठां निस्तां तैन केरे प्रार्थना घरे मां जेव। ");
INSERT INTO bhd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","तैड़ी अक मैन्हु थियो, ज़ेसेरो हथ शुक्कोरो थियो, तैनेईं यीशु दोष लानेरे बहाने सेइं तैस पुच़्छ़ू, “कुन आरामेरे दिहाड़े कोई बझ़ानो जेइज़े?” ");
INSERT INTO bhd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","तैनी तैन जो ज़ोवं, “तुसन मरां कौने, ज़ेसेरी अक्के भैड भोए, ते तै आरामेरे दिहाड़े गत्ते मांजो बिछ़ड़े, त तुस कुन तैस तैट्ठां बेइर न कढेले? ");
INSERT INTO bhd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","मैनेरी कीमत त भैडी करां केत्री जादे! एल्हेरेलेइ आरामेरे दिहाड़े रोड़ू कम केरनू जेइज़े।” ");
INSERT INTO bhd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","तैखन यीशुए तैस मैन्हु जो ज़ोवं, “अपनो हथ अग्रोवं केर।” तैनी मैने अपनो हथ अग्रोवं कियो, ते अकदम तैसेरो हथ बेज्झ़ोव। ");
INSERT INTO bhd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","तैखन फरीसी लोक बेइर गेइतां तैसेरी खलाफ साज़िश केरने लग्गे, कि एस केन्च़रे मारम? ");
INSERT INTO bhd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","इन बुझ़तां यीशु तैट्ठां च़लो जेव। ते बड़े लोक तैस पत्ती च़ले, ते तैनी तैना सब बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ते तैनी तैना खबरदार किये, कि मेरे बारे मां केन्ची सेइं न ज़ोइयथ। ");
INSERT INTO bhd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ताके यशायाह नेबेरी ज़ोरी तै गल पूरी भोए: ");
INSERT INTO bhd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“हेरा ई मेरो सेवके ज़ै मीं च़ुनोरोए, ई मेरो ट्लारोए ज़ैस पुड़ मेरो दिल खुशे, अवं अपनि आत्मा तैस पुड़ छ़डेले, ते तै गैर कौमन मां गेइतां इन्साफेरी खबर शुनालो। ");
INSERT INTO bhd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","तै न लड़ाई केरेलो, ते न शौर, ते बज़ारन मां कोई तैसेरी आवाज़ न शुनेलो। ");
INSERT INTO bhd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ते ए ढ्लेन्च़ोरे निरैठरे डाले न ट्लोड़ेलो, ते न बलतो दीयो हिशाहो ज़ां तगर इन्साफ भारी न भोए। ");
INSERT INTO bhd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ते तैसेरे नंव्वे पुड़ गैर कौमां उमीद रेखेली।” ");
INSERT INTO bhd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","तैखन लोकेईं अक मैन्हु यीशु कां आनो ज़ै कानो ते लट्टो थियो ते तैस पुड़ भूतेरो सैयो थियो, तै तैनेईं तैस कां आनो, तैनी तै ठीक कियो, ते तै लहने लगो ते गल्लां भी केरने लगो। ");
INSERT INTO bhd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","एन हेरतां लोक हैरान भोइतां ज़ोने लग्गे, “कुन एन दाऊदेरू मट्ठूए?” ");
INSERT INTO bhd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","पन फरीसी लोकेईं एन शुन्तां ज़ोवं, “ए त भूतां केरे प्रधान शैतानेरी मद्दती सेइं भूतां केरो सैयो कढते।” ");
INSERT INTO bhd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","यीशुए तैन केरे मन्नां केरे खियाल ज़ैनतां तैन सेइं ज़ोवं, “ज़ैस राज़्ज़े मां फूट पेचे, तैन राज़ बनोरू न रेइ सके, ते केन्ची नगर या खानदाने मां फूट पेचे, तैन भी बनोरू न राए। ");
INSERT INTO bhd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","अगर शैतान एप्पू अपने भूतां कढे, त तै अपनो मुखालफ एप्पू भुओ, त फिरी तैसेरू राज़ केन्च़रे बनोरू रेइ सकते? ");
INSERT INTO bhd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","अगर अवं शैतानेरी मद्दती सेइं भूतां केरो सैयो कढताईं त तुश्शे अपने मैन्हु केसेरी मद्दती सेइं कढतन? तैन्ना तुश्शो हाकिम भोले। ");
INSERT INTO bhd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","पन अगर अवं परमेशरेरी आत्मारे मद्दती सेइं भूतां केरो सैयो कढताईं त परमेशरेरू राज़ तुश्शे नेड़े पुज़ोरूए। ");
INSERT INTO bhd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","या कोई मैन्हु केन्ची ज़ोरेबाले मैनेरे घरेरे मां गेइतां तैसेरो माल तांतगर लुट्टी न सके, ज़ांतगर कि तै पेइले तैस ज़ोरेबाले मैन्हु बेंधी न छ़ड्डे। तैखन तै तैस ज़ोरेबाले मैनेरो माल लुट्टी सकते। ");
INSERT INTO bhd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ज़ै मीं सेइं साथी नईं तै मेरे खलाफे, ते ज़ै मीं सेइं साथी नईं तै अकोट्ठू न केरे तै इरां उरां बिट्लते। ");
INSERT INTO bhd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","एल्हेरेलेइ अवं तुसन सेइं ज़ोताईं कि, मैन्हु केरे सारे पाप ते तुहीन माफ़ भोली, पन पवित्र आत्मारी तुहीन माफ़ न भोली। ");
INSERT INTO bhd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ज़ै कोई मैनेरे मट्ठेरे खलाफ किछ ज़ोलो, त तैसेरो ए पाप माफ़ कियो गालो, पन ज़ै पवित्र आत्मारी तुहीन केरे, त तैस मैन्हु न इस दुनियाई मां माफ़ भोलू ते न एजने बैली दुनियाई मां माफ़ भोलू।” ");
INSERT INTO bhd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“अगर बुट रोड़े, त तैसेरे फल भी रोड़ो भोलो, अगर बुट बुरोए त तैसेरे फल भी बुरो भोलो, किजोकि बुट अपने फले सेइं पिशैनोते। ");
INSERT INTO bhd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","तुस ज़हरीले सपेरे बच्चां केरे बुरे भोइतां रोड़ी गल केन्च़रे ज़ोई सकतथ? किजोकि ज़ैन दिले मां भोते तैन्ने ज़बानी पुड़ एइते। ");
INSERT INTO bhd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","रोड़ो मैन्हु दिलेरे रोड़े खज़ाने मरां रोड़ी गल्लां कढते, ते बुरो मैन्हु बुरे दिलेरे बुरे खज़ाने मरां बुरी गल्लां कढ़ते (दिल खज़ानेरो ज़ेरोए)। ");
INSERT INTO bhd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","अवं तुसन सेइं ज़ोतां, कि ज़ैना-ज़ैना निक्केमी गल्लां मैन्हु ज़ोले, इन्साफेरे दिहाड़े लोकन अपनि हर एक्की तैस गल्लरो हिसाब देनो भोलो। ");
INSERT INTO bhd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","किजोकि तू अपने गल्लेईं सेइं धर्मी ते अपने गल्लेईं सेइं दोषी भोलो।” ");
INSERT INTO bhd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","इस पुड़ किछ शास्त्री ते फरीसी लोकेईं तैस सेइं ज़ोवं, “हे गुरू अस तीं करां कोई निशान हेरनो चातम।” ");
INSERT INTO bhd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","तैनी तैन जुवाब दित्तो, “इस ज़मानेरे बुरे ते बदमाश लोक निशान हेरनो चातन, पन तैन योना नेबेरे निशानेरे अलावा होरो कोई निशान न दित्तो गालो। ");
INSERT INTO bhd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ज़ेन्च़रे योना नबी ट्लाई दिहाड़े ते ट्लाई रातन मेछ़लरे पेटे मां राव, तेन्च़रे मैनेरू मट्ठू यानी अवं भी ट्लाई दिहाड़े ते ट्लाई रातन ज़मीनी मां रालो। ");
INSERT INTO bhd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","नीनवेरे लोक इन्साफेरे दिहाड़े इस ज़मानेरे लोकन सेइं साथी खड़े भोइतां एन दोषी बनाले, एल्हेरेलेइ कि तैनेईं योनारो प्रचार शुन्तां पापन करां मन फिराव, ते हेरा इड़ी तैए, ज़ै योना करां भी बड्डोए, पन तुसेईं पापन करां मन फिरानो न चाव। ");
INSERT INTO bhd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","दक्षिणेरी रानी इन्साफेरे दिहाड़े इस ज़मानेरे लोकन सेइं साथी खड़ी भोइतां दोषी बनाली, किजोकि तै बड़े दूरेरां सुलैमान राज़ेरू ज्ञान शुन्नेरे लेइ ओरी थी, पन हेरा इड़ी तैए, ज़ै सुलैमाने करां भी बड्डोए।” ");
INSERT INTO bhd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ज़ैखन केन्ची मैन्हु मरां भूतां केरो सैयो निसते, त तै अपने आरामेरे लेइ बेरान ठारां हंठते, पन ज़ैखन तैस ठार न मैल्ले। ");
INSERT INTO bhd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","तैखन ज़ोते, कि अवं वापस अपने तैस्से घरे मां गाताईं ज़ैस मरां निसोरो आई, ते ज़ैखन तै वापस एइते, त तैस तैन घरे खाली, धोवेरु ते साफ सुथरु सज़्ज़ो-सज़ेवरु मैलते। ");
INSERT INTO bhd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","तैखन तैन गाते ते सत बुरां भूतां एप्पू सेइं साथी आनते, ते तैन सब तैस मां रहतन, ते तैस मैनेरो हाल पेइले हाले करां भी जादे बुरो केरतन, तेन्च़रे इस ज़मानेरे बुरे लोकां केरो हाल भी एरो भोनोए।” ");
INSERT INTO bhd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ज़ैखन तै मैनन् सेइं गल्लां केरने लोरो थियो, त तैसेरी अम्मा ते कने तैसेरे ढ्ला खड़े थी, तैना तैस सेइं गल्लां केरनि चाते थिये। ");
INSERT INTO bhd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","केन्चे गेइतां तैस सेइं ज़ोवं, “बेइर तेरी अम्मा ते ढ्ला खड़े आन, तैना तीं सेइं गल केरनि चातन।” ");
INSERT INTO bhd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","एन शुन्तां तैनी पतो देनेबाले जो ज़ोवं, “कौने मेरी अम्मा, ते कौन मेरे ढ्ला?” ");
INSERT INTO bhd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ते अपने चेलां केरे पासे हथ अग्रोवं केरतां ज़ोवं, “हेरा मेरी अम्मा, ते मेरे ढ्ला इना आन। ");
INSERT INTO bhd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","किजोकि ज़ै कोई मेरे स्वर्गेरे बाजेरी मेर्ज़ी पुड़ च़लते तैए मेरो ढ्ला ते मेरी बेइन्न, ते मेरी अम्मा आए।” ");
INSERT INTO bhd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","तैस दिहाड़े यीशु घरेरां निस्सो, ते गलील समुन्दरेरे बन्ने पुड़ गेइतां बिश्शो। ");
INSERT INTO bhd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","तैसेरे च़ेव्रे पासन लोकां केरि एत्री भीड़ अकोट्ठी भोइ, ते तै एक्की किश्ती मां च़ढ़ो ते बिश्शी जेव, ताके तै सेब्भी लोकन परमेशरेरी गल्लां केरि शिक्षा देइ सके, ते सारे लोक बन्ने पुड़ खड़े राए। ");
INSERT INTO bhd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","तैखन तैनी तैन सेइं कहैनी केरे तरीके सेइं बेड़ि गल्लां ज़ोई, “एक्सां अक बीज़ बेनेबालो बीज़ बेने जो जेव। ");
INSERT INTO bhd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","बीज़ बेते बार किछ बीज़ बत्तेरे ड्लेखी बिछ़ड़ू त च़ुड़ोल्लेईं एइतां तैन बीज़ च़ुनू। ");
INSERT INTO bhd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","किछ बीज़ घोड़नबाली ज़मीनी पुड़ बिछ़ड़ू, ज़ेड़ी तैस डुग्घी मित्ती न मेलनेरे वजाई सेइं तैन लूशी उग्गू ते बूटो लगो। ");
INSERT INTO bhd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","पन ज़ैखन दिहाड़ो निस्सो, त तै निकड़ो बूटो फुक्कोई जेव। ज़ील न छ़ड्डनेरे वजाई सेइं शुक्की जेव। ");
INSERT INTO bhd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ते किछ बीज़ कंटां केरे झ़ैल्लन मां बिछ़ड़ू। ज़ैखन तैड़ी बूटो लगो, त कंटां केरे झ़ैल्लेईं भी बेड़ोइतां तै बूटो दबेइ छ़ड्डो। ");
INSERT INTO bhd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","पन ज़ैन रोड़ी ज़मीनी मां बिछ़ड़ू, त तैस फल भी लगो केन्ची शौव गुणा केन्ची शठ गुणा, ते केन्ची ट्ली गुणा। ");
INSERT INTO bhd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ज़ै कोई समझ़नू चाते, तै ध्याने सेइं शुने ते समझ़े।” ");
INSERT INTO bhd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","चेलेईं यीशु कां एइतां पुच़्छ़ू, “तू लोकन सेइं कहैनी केरे तरीके सेइं गल्लां किजो केरतां?” ");
INSERT INTO bhd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","तैने जुवाब दित्तो, “तुसन त स्वर्गेरे राज़्ज़ेरे भेदां केरि समझ़ दित्तोरीए” पन होरि लोकन नईं। ");
INSERT INTO bhd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","किजोकि ज़ैस कां परमेशरेरी मर्ज़ी समझ़नेरी इच्छा आए, तैस परमेशर जादे समझ़ देलो। पन ज़ैस कां परमेशरेरी मर्ज़ी समझ़नेरी इच्छा नईं, तैस केरां, थोड़ी ज़ेरि समझ़, ज़ै तैस कां आए, तै भी नी गाली। ");
INSERT INTO bhd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","अवं तैन सेइं एल्हेरेलेइ कहैन्न मां गल्लां केरतां, कि तैन, तैना बार-बार शुनेले, पन मेरी गल न समझ़ेले। ");
INSERT INTO bhd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","तैन केरे बारे मां यशायाह नेबेरी भविष्यिवाणी पूरी भोतीए, “तुस कन्नेईं सेइं त शुनेले पन समझ़ेले न, तुस एछ़्छ़न सेइं त लाएले पन पिशैनी न सकेले।” ");
INSERT INTO bhd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","“किजोकि एना लोकां केरे दिलन पुड़ चरभी भेरोरीए, ते एना कन्न सेइं उकड़ु शुन्तन, ते एनेईं अपनि एछ़्छ़ी तुमोरिन, एरू न भोए कि तैना एछ़्छ़ेईं सेइं लहन, ते कन्नेईं सेइं शुन्न ते दिले सेइं समझ़न, ते मेरे पासे फिरन ते अवं तैन बज़्झ़ेइं।” ");
INSERT INTO bhd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“पन तुश्शी एछ़्छ़ी धन आन, कि तुस लातथ ते तुश्शे कन्न धन आन किजोकि तुस शुन्तन। ");
INSERT INTO bhd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","अवं तुसन सेइं सच़ ज़ोताईं, कि बड़े नेबी ते धेरमी लोकेईं चाव कि ज़ैन गल्लां तुस हेरतथ तैना हेरन, पन न हेरी बेटि, ते ज़ैना गल्लां तुस शुन्तन शुन्न, पन न शुनी बेटि।” ");
INSERT INTO bhd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“हुनी तुस बीज़ बेनेबालेरी कहैनरो मतलब शुना। ");
INSERT INTO bhd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","बीज़ बेनेबालो तै आए, ज़ै परमेशरेरी गल्लां लोकन शुनाते। ज़ैना मैन्हु परमेशरेरी गल्लां शुन्तन, तैन मरां किछ लोक तैस बत्तेरे ज़ेरे आन, ज़ेड़ी बीज़ बिछ़ड़ते। तैना त परमेशरेरी गल्लां शुन्तन, पन शैतान अकदम एइतां तैन मैन्हु केरे दिले मरां परमेशरेरी गल्लां केड्डी छ़ड्ते। ");
INSERT INTO bhd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ते ज़ैन घोड़नबाली ज़मीनी मां बेवं, एना तैना आन, ज़ैना खुशी सेइं वचन शुन्तन कबूल केरतन। ");
INSERT INTO bhd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","पन एप्पू मां ज़ील न रखनेरे वजाई सेइं तैन थोड़े दिहाड़ी केरूए, ते ज़ैखन वचनेरे वजाई सेइं तैन पुड़ मुसीबत या ज़ुलम भोते त तैखने ठोकर खातन। ");
INSERT INTO bhd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","होरे किछ लोक ज़ैना परमेशरेरी गल्लां शुन्तन, तैना तैस कंटां केरे झ़ैल्लां केरे ज़मीनेरे ज़ेरे आन। पन दुनियारो फिक्र ते दौलतरे वजाई सेइं धोखो खातन, ते तैना बेफल रेइ गाते। ");
INSERT INTO bhd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ज़ैन रोड़ि ज़मीनी मां बेवं, एन तैना लोकन ज़ैना वचन शुन्तन ते समझ़तन, ते तैस फल भी लगते कोन्ची शौव गुणा कोन्ची शठ गुणा, ते केन्ची ट्लही गुणा।” ");
INSERT INTO bhd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","यीशुए तैन अक होरि मिसाल देइतां ज़ोवं, “स्वर्गेरू राज़ तैस मैनेरू ज़ेरूए ज़ैनी अपने ऊडारे मां रोड़ू बीज़ बेवं। ");
INSERT INTO bhd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","पन ज़ैखन लोक झ़ुलोरो थिये, त तैसेरे दुश्मने एइतां तैसेरे ऊडारे मां गेहुं केरे बीज़े मांमेइं जंगली बीज़ बेवं। ");
INSERT INTO bhd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ज़ैखन पट्लां ते शिल्लां लगां लगने त तै जंगली डाल भी साथी लग्गो। ");
INSERT INTO bhd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","मालिकेरे नौकरेईं एइतां तैस सेइं ज़ोवं, ‘हे मालिक, कुन तीं अपने ऊडारे मां रोड़ू बीज़ न थियूं बेवरू, फिरी जंगली तैस मां कोट्ठां अव?’ ");
INSERT INTO bhd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","तैनी तैन सेइं ज़ोवं, एन केन्ची दुश्मनेरू कम्मे, नौकरेईं पुच़्छ़ू कुन तू चातस, कि अस गेइतां तैन पुट्टी छ़डम? ");
INSERT INTO bhd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","पन तैनी ज़ोवं नन्ना, एरू न भोए कि तैस सेइं साथी तुस गेहुं भी पुटथ। ");
INSERT INTO bhd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","फसल लुन्ने तगर दुइये साथी बेडोने देथ, ते लुनते बार अवं एप्पू लुन्ने बालन सेइं ज़ोइलो, कि पेइले जंगली बीज़ लुन्तां अग्गी मां फुकनेरे लेइ अकोट्ठू केरा, ते फिरी तुस गेहुं मेरे कोठारे मां जम्हां केरतां रख्खा।” ");
INSERT INTO bhd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","तैनी तैन अक होरि मिसाल देइतां ज़ोवं, “स्वर्गेरू राज़ शेरीएरे बीज़ेरू ज़ेरू आए, ज़ैन एक्के मैने आनू ते अपने ऊडारे मां बेवं। ");
INSERT INTO bhd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","एन बीज़ सेब्भी बीज़न करां निक्कु भोते, पन ज़ैखन तैन बीज़ बेव गाते, त तैन उगतां सारे निक्के-निक्के बुट्टन केरां बड्डू भोते। ते एरो बुट बनते इड़ी तगर कि अम्बरेरां च़ुड़ोल्लू भी तैस पुड़ बिशतन।” ");
INSERT INTO bhd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","तैनी तैन अक होरि मिसाल देइतां ज़ोवं, “स्वर्गेरू राज़ अम्लटेरू ज़ेरूए, ज़ैन केन्ची कुआन्शां आनू, ते हछे अट्टे मां मलाव ते सारू अट्टू खमीर बेनि ज़ोवं।” ");
INSERT INTO bhd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","एन सैरी गल्लां यीशुए तैन लोकन मिसाल देइतां शुनातो थियो, ते मिसाल देनेरे बगैर तै तैन किछ न थियो शुनातो। ");
INSERT INTO bhd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ताके तैन वचन ज़ैन नेबे ज़ोवरो थियूं पूरू भोए, “अवं कहैनी केरे लेइ अपनि ज़बान खोल्लेलो, ते तैना गल्लां ज़ोइलो ज़ैना दुनिया बन्ने करां पेइली छ़ेप्पोरी थी।” ");
INSERT INTO bhd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","तैखन यीशु लोकन करां अलग भोइतां घरजो अव, ते तैसेरे चेलेईं तैस कां एइतां ज़ोवं, “तू असन ऊडारेरे जंगली बीज़ेरी कहैनरो मतलब समझ़ा।” ");
INSERT INTO bhd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","तैनी तैन जुवाब दित्तो, “रोड़ू बीज़ बेनेबालो मैनेरू मट्ठूए। ");
INSERT INTO bhd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ऊडार ई दुनियाए, ते रोड़ू बीज़ राज़ हासिल केरनेबाले लोक, ते जंगली बीज़ शैतानेरे लोक आन। ");
INSERT INTO bhd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ते तै दुश्मन ज़ैनी तैन बेवरू थियूं तै शैताने, लुन्नेरो मतलब इस दुनियारो अन्त भोनोए, ते लुन्ने बाले स्वर्गदूतन। ");
INSERT INTO bhd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ज़ेन्च़रे जंगली बीज़ेरे ग्लेव अकोट्ठे केरतां अग्गी मां फुकतन, तेन्च़रे इस दुनियारो अन्त भोनोए। ");
INSERT INTO bhd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","मैनेरू मट्ठू अपने स्वर्गदूतन भेज़ेलू, ते तैन केरे राज़्ज़े मां ठोकरारी वजा ते बुरां कम्मां केरनेबालन अकोट्ठे केरेले। ");
INSERT INTO bhd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ते तैन अग्गारे कुण्डे मां छ़डेले, ज़ैड़ी तैना लोक लेरां देते ते दंत च़ापते राले। ");
INSERT INTO bhd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","तेइस धर्मी लोक अपने बाजी केरे राज़्ज़े मां दिहाड़ेरे ज़ेरे चमकेले। ज़ै कोई समझ़नू चाते, तै ध्याने सेइं शुने ते समझ़े।” ");
INSERT INTO bhd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“स्वर्गेरू राज़ तैस दौलतरू ज़ेरू ए, ज़ै एक्की ऊडारे मां दबोरी थी, ज़ै एक्की मैने तोप्पी, ते तैस मैल्ली भी, ते फिरी तैने छ़पेइतां छ़डी ते खुशी सेइं अपनू सब किछ बेच़तां तैन ऊडार घिंनु। ");
INSERT INTO bhd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“स्वर्गेरू राज़ तैस बुपैरेरू ज़ेरूए, ज़ै कीमती मोती तोपतो थियो। ");
INSERT INTO bhd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ज़ैखन तैस अक कीमती मोती मैल्लो, त तैनी अपनू सब किछ बेच़तां तै मोती घिंनो। ");
INSERT INTO bhd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“स्वर्गेरू राज़ तैस मेछ़ली ज़ालेरू ज़ेरूए, ज़ैन समुन्द्रे मां छ़डू ते तैस मां हर किसमेरी मेछ़ली लेग्गी। ");
INSERT INTO bhd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ते ज़ैखन ज़ाल भेरोई ज़ोवं त झिरेइं ज़ाल खिचतां कनारे पुड़ आनू, ते बिश्तां रोड़ी-रोड़ी मेछ़ली टोकरन मां रेख्खी ते बुरी-बुरी मेछ़ली शैरी छ़ैडी। ");
INSERT INTO bhd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","दुनियारे अन्ते मां भी एरू भोनूए, स्वर्गदूतेईं एइतां दुष्ट लोक, धेर्मी लोकन करां अलग केरनेन। ");
INSERT INTO bhd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ते तैना अगारी भेठी मां छ़डनेन तैड़ी लेरां ते दंत च़ापने भोले। ");
INSERT INTO bhd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“कुन तुसेईं एन सैरी गल्लां सेमझ़ी?” तैनेईं ज़ोवं, “हाँ” असेईं सेमझ़ी। ");
INSERT INTO bhd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","फिरी यीशुए तैन सेइं ज़ोवं, “हर अक शास्त्री ज़ै स्वर्गेरे राज़्ज़ेरो चेलो बनोरोए एक्की एरे मुकान मालिकेरो ज़ेरोहे, ज़ै अपने खज़ाने मरां नव्वीं ते पुरैनी चीज़ां कढते।” ");
INSERT INTO bhd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ज़ैखन यीशुए एना सब कहैनी शुनेई त तै तैट्ठां अग्रोवं च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ते अपने नगर मां एइतां तैट्ठेरे प्रार्थना घरे मां गेइतां शिक्षा देने लगो, ते लोक तैसेरी शिक्षा शुन्तां हैरान भोए ते ज़ोने लग्गे: “ए अक्ल बुधी ते एना चमत्कार एस कोट्ठां हासिल भोए। ");
INSERT INTO bhd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","एन त तैस ट्लखानेरू मट्ठू आए ते एसेरे अम्मारू नवं मरियम ते एसेरे ढ्लां केरू नवं याकूब, यूसुफ, शमौन ते कने यहूदा आन, ");
INSERT INTO bhd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ते एसेरी सब बेइनां इश्शे इड़ी रेइचन, फिरी एसमां ई काबलीत कोट्ठां आई?” ");
INSERT INTO bhd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","एन्च़रे तैन लोकेईं इन्कार कियो। पन यीशुए तैन सेइं ज़ोवं, “नबी अपने नगर मां ते अपने घरेरे अलावा होरि कोन्ची ठारी बेइज़त न भोए।” ");
INSERT INTO bhd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ते तैने तैड़ी तैन केरे विश्वास न केरनेरे वजाई सेइं जादे चमत्कार न हिराए। ");
INSERT INTO bhd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ज़ेइस हेरोदेस ज़ै मुलखेरे च़ेवरोवं हिस्से पुड़ हकोमत केरतो थियो, तैनी यीशुएरे बारे मां शुनू। ");
INSERT INTO bhd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","तैनी अपने नौकरन सेइं ज़ोवं, “ए यूहन्ना आए ज़ै बपतिस्मो देनेबालोए, ए मुड़दन मरां ज़ींतो भोरोए, एल्हेरेलेइ तै चमत्कार हिराते।” ");
INSERT INTO bhd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","किजोकि हेरोदेसे अपने ढ्लाए फिलिप्पुसेरी कुआन्श हेरोदियासेरी वजाई सेइं यूहन्ना ट्लेइतां बन्धोवरो ते कैदखाने मां छ़डोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","किजोकि यूहन्ना हेरोदेस सेइं ज़ोरू थियूं, कि ए रखनी तेरे लेइ जेइज़ नईं। ");
INSERT INTO bhd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ते हेरोदेस तैस कत्ल केरनो चातो थियो, पन लोकन करां डरतो थियो, किजोकि लोक तैस नबी मन्ते थिये। ");
INSERT INTO bhd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","पन ज़ैखन हेरोदेसेरी ज़र्म दिहैड़ी आई, त हेरोदियासेरे कुइयां मेहमाना केरे सामने नेच़तां हेरोदेस खुश कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","एल्हेरेलेइ तैनी वादो कियोरो थियो, “कि ज़ैन किछ तू मग्गेली, अवं तीं तैन्ने देलो।” ");
INSERT INTO bhd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","तैसां अपने अम्मारे शिखालने पुड़ ज़ोवं, “मींजेई यूहन्ना बपतिस्मो देनेबालेरी क्रोड़ी थाले मां मग।” ");
INSERT INTO bhd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","राज़े बड़ो अफ़सोस भोव, पन अपने मेहमाना केरे सामने ते कसम खानेरी वजाई सेइं हुक्म दित्तो कि देथ। ");
INSERT INTO bhd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ते तैनी कैदखाने मां लोक भेज़तां यूहन्नारी क्रोड़ी कटाई। ");
INSERT INTO bhd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ते तैसेरी क्रोड़ी थाले मां रेखतां कुइये कां दित्ती, ते तै अपनि अम्मा कां घिन्तां जेई। ");
INSERT INTO bhd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","तैखन तैसेरे चेले आए, ते तैनेईं तैसेरी लाश नेइतां देबतां छ़डी ते गेइतां यीशुए पतो दित्तो। ");
INSERT INTO bhd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ज़ैखन यीशुए एन शुनू, त तै किश्तरे ज़िरिये अकेन्ती ठारी जो च़लो जेव, ते लोक एन शुन्तां नगर नगरेरे पैदल तैस पत्ती च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ज़ैखन यीशु किश्ती मरां ओस्सो त तैनी बड़े लोक पतोरां एइते लाए, ते तैस तैन पुड़ बड़ो तरस अव, ते तैनी तैन केरे बिमार लोक बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ज़ैखन ड्लोझ़ भोइ, त यीशुएरे चेलेईं तैस कां एइतां ज़ोवं, “ई सुनसान ठार आए, त च़िर भी बड़ू भोरू आए। ते एन लोकन भेज़ी छ़ड ते कोस्कोई ड्लोंव्वन मां गेइतां किछ खाने जो घिन्न।” ");
INSERT INTO bhd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","यीशुए तैन सेइं ज़ोवं, “एना भेज़ने ज़रूरी नईं! तुस्से एन किछ खाने जो देथ।” ");
INSERT INTO bhd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","चेलेईं तैस सेइं ज़ोवं, “इड़ी असन कां पंच़ रोट्टी ते दूई मेछ़ली केरे अलावा होरू किछ नईं।” ");
INSERT INTO bhd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","तैनी ज़ोवं, “तैन इरां मीं कां आनां।” ");
INSERT INTO bhd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","तैखन यीशुए लोकन घासे पुड़ उन्ढे बिशनेरे लेइ ज़ोवं, ते पंच़ रोट्टी ते दूई मेछ़ली हथ्थे मां रेख्खी, ते अम्बरेरे पासे तेकतां शुक्र कियूं, ते रोट्टी ट्लोड़ी-ट्लोड़ी अपने चेलन कां दित्ती, ते चेलेईं तैन लोकन दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ते सारे मैन्हु खेइतां रेज़्ज़ी जे। तैल्ला पत्ती, यीशुएरे चेलेईं बच़ोरे टुक्ड़न सेइं 12 टोकरी भेरि। ");
INSERT INTO bhd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","रोट्टी खानेबाले लोकां केरि तैधात कुआन्शां ते बच्चां केरे अलावा कोई 5000 मड़द थिये। ");
INSERT INTO bhd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","तैल्ला पत्ती, यीशुए अपने चेलन हुक्म दित्तो कि, तुस किश्ती मां च़ेढ़तां मीं केरां पेइले समुन्दरेरे उस पार जो गाथ ते अवं एन लोकन वापस भेज़तां एइताईं। ");
INSERT INTO bhd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","लोकन भेज़नेरे पत्ती, यीशु तैट्ठां निस्तां नेड़े एक्की पहैड़ी पुड़ प्रार्थना केरनेरे लेइ जेव। ते ड्लोझ़ी तै अकैल्लो थियो। ");
INSERT INTO bhd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","तैखन किश्ती बन्ने करां दूर पुज़ोरी थी, किजोकि एग्रोवरां बड़ी तेज़ हवा च़लोरी थी। ");
INSERT INTO bhd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ते लगभग झ़ेज़्झ़ेरे च़ेव्रे बज़ेई ज़ैखन हेजू आंधरू थियूं, यीशु समुन्दरेरे पैनी पुड़ च़ेलतां अपने चेलन कां अव। ");
INSERT INTO bhd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ज़ैखन चेलेईं यीशु समुन्दरे पुड़ च़लतो लाव त तैना डेरि जे, तैनेईं बुझ़ू, “ए भूत ओरोए,” ते डेरतां चिन्डां लग्गे मारने। ");
INSERT INTO bhd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","यीशुए तैखने तैन सेइं रोड़ेच़ारे गल्लां की ते ज़ोवं, “हिम्मत रख्खा डरा नन्ना, अवं आईं।” ");
INSERT INTO bhd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पतरसे तैस जुवाब दित्तो, “हे प्रभु अगर तू आस, त मीं भी हुक्म दे ते अवं भी पैनी पुड़ च़लतो तीं कां एज्जी।” ");
INSERT INTO bhd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","तैनी ज़ोवं, “एई!” तैखन पतरस किश्ती मरां ओस्तां यीशु कां गानेरे लेइ पैनी पुड़ मेइं च़लने लगो। ");
INSERT INTO bhd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","पन तेज़ हावी सेइं छ़ेल्ली च़लने लेग्गी ते तै डेरि जेव, ते डुबने लगो तैखन तैनी चिन्डां मैरतां ज़ोवं, “हे प्रभु मीं बच़ा।” ");
INSERT INTO bhd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","यीशुए लूशी अपने हथ्थे सेइं झफ देइतां पतरस ट्लातो, ते तैस सेइं ज़ोवं, “हे घट भरोसे बाला तीं किजो शक की?” ");
INSERT INTO bhd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ज़ैखन तैना किश्ती मां बिश्शे ते हवां रुकी जेई। ");
INSERT INTO bhd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","तैखन ज़ैना किश्ती मां बिश्शोरे थिये, त तैनेईं तैस कां मथ्थो टेको ते ज़ोने लग्गे, “तू सच़्च़े परमेशरेरू मट्ठूस।” ");
INSERT INTO bhd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ज़ैखन तैना गलील समुन्दर पार केरतां गन्नेसरत नंव्वेरे जगाई पुड़ पुज़्ज़े। ");
INSERT INTO bhd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","त तैट्ठेरे लोकेईं यीशु पिशानो ते आसेपासेरे इलाके मां खबर दित्ती, ते सारे बिमार तैस कां आने। ");
INSERT INTO bhd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ते तैनेईं यीशु सेइं मिन्त केरते थिये कि, तैन तैसेरे लिगड़न सेइं हुरने दे। ते ज़ेत्रेइं तैसेरे लिगड़न सेइं हथ लाव तैना सब बेज़्झ़ोए। ");
INSERT INTO bhd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","तैखन किछ फरीसी ते किछ शास्त्री लोक यरूशलेम नगरे मरां यीशु कां आए ते ज़ोने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“तेरे चेले बुज़ुर्गां केरि रसमरे खलाफ किजो च़लतन, तैना रोट्टी खाने करां पेइले हथ न धोन?” ");
INSERT INTO bhd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","तैनी तैन जुवाब दित्तो, “तुस किजो अपने रसमन सेइं परमेशरेरो हुक्म ट्लोड़तथ? ");
INSERT INTO bhd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","किजोकि परमेशरे ज़ोरूए, कि अपने हाज बव्वेरी इज़्ज़त केरा, ते ज़ै कोई अपने हाज बव्वे जो बुरू ज़ोलो तै मारो गालो। ");
INSERT INTO bhd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","पन तुस ज़ोतथ, कि ज़ै कोई बाजी या अम्मा सेइं ज़ोए कि, मीं करां ज़ै किछ मद्दत तुसन मैल्ली सकती थी, तै पेइली बलिदान भोरीए, यानी परमेशरे जो च़ढ़तल च़ाढ़ोरीए ");
INSERT INTO bhd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","त तै अपने बाजी केरि इज़्ज़त न केरे, एन्च़रे तुस अपने रसमन सेइं परमेशरेरो हुक्म ट्लोड़तथ। ");
INSERT INTO bhd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","हे पाखंडी लोकव, यशायाह नेबे तुश्शे बारे मां ई भविष्यिवाणी ठीक कियोरीए, ");
INSERT INTO bhd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","एना लोक ऐशी सेइं त मेरी बड़ी तारीफ़ केरतन, पन एन केरे दिल मीं करां बड़े दूर आन। ");
INSERT INTO bhd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","एना लोक बेफैइदी मेरी आराधना केरतन, किजोकि एना मैन्हु केरे हुक्मां केरि शिक्षा देतन।” ");
INSERT INTO bhd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","फिरी मैन्हु एप्पू कां कुजेइतां ज़ोवं, “शुना, ते समझ़ा। ");
INSERT INTO bhd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ज़ै चीज़ ऐशी मां गाचे तैस सेइं मैन्हु ज़ुट्ठो न भोए, पन ज़ैन तैसेरे ऐशी मरां बेइरोवं निस्ते, तैन्ने तैस ज़ुट्ठो केरते।” ");
INSERT INTO bhd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","तैखन चेलेईं यीशु कां एइतां ज़ोवं, “कुन तू ज़ानतस कि फरीसी लोकेईं ए गल शुन्तां ठोकर खाइ?” ");
INSERT INTO bhd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","तैनी जुवाब दित्तो, “ज़ै बुट मेरे स्वर्गेरे बाजे नईं लोरो तै ज़ीलना पुटतां छ़डनोए। ");
INSERT INTO bhd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","तैन केरि परवाह न केरा, तैन काने बत हिराने बालेन, अगर अक कानो होरि काने बत हिराए, त तैना दुइये गढे मां बिछ़ड़ेले।” ");
INSERT INTO bhd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","एन शुन्तां पतरसे ज़ोवं, “ए मिसाल असन समझ़ा।” ");
INSERT INTO bhd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","यीशुए ज़ोवं, “कुन तुस हेजू भी बेसमझ़ाथ?” ");
INSERT INTO bhd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“कुन तुस न ज़ानथ, कि ज़ैन किछ ऐशी मां गाते तैन पेटे मां गाते, ते फिरी पेटे मरां बेइर निस्ते? ");
INSERT INTO bhd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","पन ज़ैन किछ मैनेरे अन्त्रेरां निस्ते, तैन दिले मरां निसते, तैन्ने मैन्हु ज़ुठो केरते? ");
INSERT INTO bhd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","किजोकि बुरे खियाल, कत्ल केरनो, अड्लाए देइने गलत कम केरनू, बदमाशी, च़ोरी, झूठी गवाही देनी, ते तुहीन दिले मरां निसचे। ");
INSERT INTO bhd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","एन एरी गल्लन ज़ैना मैन्हु ज़ुट्ठो केरचन, पन हथ धोने बगैर रोट्टी खाने सेइं मैन्हु ज़ुट्ठो न भोए।” ");
INSERT INTO bhd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","यीशु तैट्ठां च़लो जेव, ते सूर ते सैदारे आसेपासेरे इलाकेरे नेड़े अव। ");
INSERT INTO bhd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","तैस इलाकेरी अक कनानी कुआन्श यीशु कां आई, ते चिन्डां मैरतां ज़ोने लग्गी, “हे प्रभु दाऊदेरा मट्ठां, मीं पुड़ दया केर, मेरी कुइये पुड़ भूतेरो सैयोए, तैन भूत तैस बड़ू सताते।” ");
INSERT INTO bhd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","पन यीशुए कोई जुवाब न दित्तो, तैसेरे चेले नेड़े एइतां तैस कां मिनत केरने लग्गे, “एस भेज़, किजोकि ए चिन्डां मारचे ते इश्शो पीछो न छ़डे।” ");
INSERT INTO bhd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","तैनी जुवाब दित्तो, “अवं इस्राएलेरी हेरोरि भैड्डां केरे अलावा होरि कोन्ची कां नईं भेज़ोरो।” ");
INSERT INTO bhd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","पन तै कुआन्श आई, ते तैस कां मथ्थो टेकतां ज़ोने लग्गी, “हे प्रभु मेरी मद्दत केर।” ");
INSERT INTO bhd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","तैनी जुवाब दित्तो, “बच्चां केरि रोट्टी नेइतां कुतरन देनी ठीक नईं।” ");
INSERT INTO bhd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","तैसां ज़ोवं “सच़्च़े प्रभु, पन ज़ैन टुक्ड़े मालिकेरी मेज़े पुड़ेरां बिछ़ड़तन तैना कुतरां भी खातन।” ");
INSERT INTO bhd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","यीशुए तैस जुवाब दित्तो, “ए कुआन्श तेरो विश्वास बड़ोए, ज़ेरू तू चातिस तेरे लेइ तेरहु भोए” ते तैसारी कुई तैखने बेज़्झ़ोइ जेई। ");
INSERT INTO bhd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","यीशु तैट्ठां निस्तां गलील समुन्दरेरे बन्ने पुड़ अव, तैखन तै एक्की पहाड़े पुड़ गेइतां बिश्शी जेव। ");
INSERT INTO bhd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ते बड़े लोकां केरि भीड़ तैस कां आई, तैन लोकेईं एप्पू सेइं साथी टोंटे, काने, लट्टे, डोंडे ते होरे काई एरे ज़ेरे मैन्हु साथी आने, ते तैसेरे पावन कां छ़ड्डे, ते तैनी तैना सब बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ज़ैखन लोकेईं हेरू कि लट्टे गल्लां केरतन कमज़ोर तकड़े भोतन, टोंटे च़लतन ते काने लातन त तैना बड़े हैरान भोइ जे ते इस्राएलेरे परमेशरेरी तारीफ़ केरने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","यीशुए अपने चेले कुजेइतां तैन सेइं ज़ोवं, “मीं एन लोकन पुड़ बड़ो तरस एइते, एना मैन्हु ट्लेइ दिहैड़ी केरे देंते बराबर मीं सेइं साथिन, ते एन कां खाने जो किछ भी नईं। अवं एन नियन्ने भेज़ने न चैईं, कोस्कोई एरू न भोए कि एना बत्ती मां रेइ गान।” ");
INSERT INTO bhd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","तैसेरे चेलेईं तैस जुवाब दित्तो “अस इस सुनसान ठैरी मां एत्रे लोकां केरे लेइ रोट्टी कोट्ठां आनम, ज़ैना सेब्भी केरे लेइ पूरी भोन?” ");
INSERT INTO bhd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","यीशुए पुच़्छ़ू, “तुसन कां केत्री रोट्टी आन?” तैनेईं ज़ोवं, “सत रोट्टिन ते किछ निक्की मेछ़ली भी आन।” ");
INSERT INTO bhd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","तैखन तैनी लोकन ज़मीनी पुड़ बिशनेरे लेइ ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ते यीशुए तैना सत रोट्टी ते मेछ़ली ट्लेइ, ते परमेशरेरू शुक्र केरतां ट्लोड़ी, ते अपने चेलन कां दित्ती ते चेलेईं तैना मैनन् दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","सारे मैन्हु रोट्टी खेइतां रेज़्ज़ी जे। तैल्ला पत्ती, यीशुएरे चेलेईं मेछ़ली त कने रोट्टी केरे बच़्च़ोरे टुक्ड़न मरां सत टोकरे भेरतां सल्ले। ");
INSERT INTO bhd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","रोट्टी खाने बालां केरि तैधात कुआन्शां ते बच्चां केरे अलावा 4000 मड़द थिये। ");
INSERT INTO bhd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","तैखन तैने तैना सब लोक भेज़े ते एप्पू किश्ती मां च़ेढ़तां मगदन इलाके जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","किछ फरीसी ते किछ सदूकी लोक यीशु कां आए, “ते तैस अज़मानेरे लेइ तैस सेइं ज़ोवं, असन कोई अम्बरेरो निशान हिरा।” ");
INSERT INTO bhd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","तैनी तैन जुवाब दित्तो, “ज़ैखन ड्लोझ़ भोतीए त तुस ज़ोतथ कि मौसम रोड़ोए किजोकि अम्बर लाले। ");
INSERT INTO bhd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ते झ़ेझ़ां ज़ोतथ कि अज़ आँधी एजनीए किजोकि अम्बर लाले ते बिदलारे, तुस अम्बर हेरतां अंदाज़ो लेइता ज़ोतथ, पन ज़मानेरो निशान न पिशैनी सकतथ! ");
INSERT INTO bhd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","इस ज़मानेरे बुरे ते बदमाशी केरनेबाले लोक निशान मगतन, पन तैन योना नेबेरे अलावा होरो कोई निशान न दित्तो गालो।” यीशु तैन शैरतां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ते यीशुएरे चेले समुन्दरे पार पुज़ी जे, पन तैनेईं रोट्टी साथी नेनी बिसरोरी थी। ");
INSERT INTO bhd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","यीशुए तैन सेइं ज़ोवं, “खबरदार फरीसी ते कने सदूकी लोकां केरे खमीरे करां हुशार रेइयथ।” ");
INSERT INTO bhd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","तैना एप्पू मांमेइं गलबात केरने लग्गे, “असेईं रोट्टी नईं आनोरी, एल्हेरेलेइ तै एरू ज़ोने लोरोए।” ");
INSERT INTO bhd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","एन ज़ैनतां, यीशुए ज़ोवं, “हे घट विश्वैसव, तुस एप्पू मांमेइं किजो सोची राओरेथ, कि असन कां रोट्टी नईं? ");
INSERT INTO bhd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","कुन तुसन याद नईं? ज़ताली मीं 5000 मैन्हु केरे लेइ पंच़ रोट्टी ट्लोड़तां दित्तोरी थी, त तुसेईं बादे मां बच़्च़ोरी रोट्टी केरे केत्रे टोकरे भेरतां सल्लोरे थिये? ");
INSERT INTO bhd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ते तैन 4000 मैन्हु केरे लेइ सत रोट्टी ते टुकां केरि केत्री टोकरी सैल्लोरी थी? ");
INSERT INTO bhd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","तुस की न समझ़थ, कि मीं तुसन रोट्टी केरे लेइ न थियूं ज़ोरू? पन फरीसी ते कने सदूकी लोकां केरे खमीरे करां हुशार रेइयथ।” ");
INSERT INTO bhd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","तैखन तैन केरि समझ़ी मां अव, कि तैनी रोट्टी केरे लेइ नईं, बल्के फरीसी ते कने सदूकी लोकां केरे खमीर यानी शिक्षाई करां हुशार रानेरे लेइ ज़ोरू थियूं। ");
INSERT INTO bhd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ज़ैखन यीशु कैसरिया फिलिप्पी इलाके मां अव, त तैनी अपने चेलन पुच़्छ़ू: “मैनेरू मट्ठू कौने, लोक एस बारे मां कुन ज़ोतन?” ");
INSERT INTO bhd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","चेलेईं ज़ोवं, “किछ ज़ोतन यूहन्ना बपतिस्मो देनेबालोए, किछ ज़ोतन एलिय्याह, ते किछ ज़ोतन यिर्मयाह नबी ते किछ ज़ोतन नेबन मरां कोई अक आए।” ");
INSERT INTO bhd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","यीशुए तैन पुच़्छ़ू, “पन तुस मेरे बारे मां कुन सोचतथ कि अवं कौन आईं?” ");
INSERT INTO bhd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","शमौन पतरसे जुवाब दित्तो, “तू ज़ींते परमेशरेरू मट्ठू मसीह आस।” ");
INSERT INTO bhd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","यीशुए ज़ोवं, “ए शमौन योनारे मट्ठां तू धन आस, किजोकि ए गल मासे या खूने नईं बल्के मेरे स्वर्गेरे बाजे तीं पुड़ बांदी कियोरीए। ");
INSERT INTO bhd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ते अवं तीं सेइं ज़ोताईं, तू पतरस आस ते अवं इस पक्के घोड़े पुड़ अपनि कलीसिया बनेइलो ते पातालेरां दारां तैस पुड़ अस्सर न केरि बटेलां। ");
INSERT INTO bhd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","अवं अपने स्वर्गेरे राज़्ज़ेरी चैबी तीं देइलो, ते ज़ैन किछ तुस ज़मीनी पुड़ बंधेले तैन स्वर्गे मां बेंधोलू, ते ज़ैन किछ तू ज़मीनी पुड़ खोल्लेलो तैन सब किछ स्वर्गे मां खुल्लेलू।” ");
INSERT INTO bhd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तैखन यीशुए चेलन जो ज़ोवं, ए गल केन्ची सेइं न ज़ोइयथ कि अवं मसीह आई। ");
INSERT INTO bhd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","एसेरे बाद यीशुए अपने चेलन ज़ोने लगो कि, “तैसेरू यरूशलेम नगरे मां गानू ज़रूरीए ताके यहूदी लोकां केरे बुज़ुर्गन, प्रधान याजकन ते शास्त्री लोकां केरे हथेइं तै बड़ो दुःख झ़ैल्ले, ते मारो गाए ते तै ट्लेइयोवं दिहाड़े फिरी ज़ींतो भोलो।” ");
INSERT INTO bhd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","पतरस तैस अलग नेइतां झ़िड़कने लगो, “हे प्रभु, परमेशर न केरे, तीं सेइं एरू कधे न भोलू।” ");
INSERT INTO bhd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","यीशुए मुड़तां पतरसे सेइं ज़ोवं, “हे शैतान, मीं करां दूर भो, तू मीं करां पाप करानेरी कोशिश कराने लोरोस। किजोकि तू ज़ेन्च़रे परमेशर सोचते तेन्च़रे नईं बल्के ज़ेन्च़रे मैन्हु सोचन तेन्च़रे सोचतस।” ");
INSERT INTO bhd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","तैखन यीशुए अपने चेलन सेइं ज़ोवं, “अगर कोई मीं पत्ती एजनो चाते त तै अपने आपेरो इन्कार केरे, ते अपनू क्रूस छ़ुइतां मीं पत्ती च़ले।” ");
INSERT INTO bhd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“किजोकि ज़ै कोई अपनि जान बच़ानी चालो, त तै तैस गुवालो, ते ज़ै अपनि जान मेरे लेइ गुवालो, त तै तैस हासिल केरेलो। ");
INSERT INTO bhd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","अगर कोई सारी दुनिया हासिल केरे, ते अपने हमेशारे ज़िन्दगी गुवाए, त तैस कुन फैइदो भोलो? या मैन्हु हमेशारे ज़िन्दगरे बदले कुन देलो? ");
INSERT INTO bhd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","किजोकि ज़ैखन मैनेरू मट्ठू अपने बाजेरी महिमाई मां अपने स्वर्गदूतन सेइं साथी एज्जेलू, तैखन तै हर केन्ची तैन केरे कियोरे कम्मां केरो फल देलो। ");
INSERT INTO bhd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","अवं तुसन सेइं सच़ ज़ोतईं कि ज़ैना इड़ी खड़े आन, ज़ां तगर मैनेरे मट्ठे अपने राज़्ज़े मां एइते न लाएले, तांतगर न मरेले।” ");
INSERT INTO bhd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","शेइ दिहाड़ना बाद, यीशु अपने चेले पतरस, याकूब त तैसेरे ढ्ला यूहन्ना सेइं साथी एक्की पहाड़े पुड़ जेव, ज़ेड़ी कोई भी न थियो। ");
INSERT INTO bhd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","तैड़ी तैन केरे सामने तैसेरी शकल बेदलोई जेई, तैसेरू तुत्तर दिहाड़ेरू ज़ेरू चमकने लगू ते तैसेरां लिगड़ां लोअरां ज़ेरां छ़ित्तां भुआं। ");
INSERT INTO bhd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","तैखन तैनेईं मूसा ते एलिय्याह नबी यीशु सेइं गल्लां केरते लाए। ");
INSERT INTO bhd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","पतरसे यीशु सेइं ज़ोवं, “हे प्रभु इश्शू इड़ी रानू रोड़ूए, अगर तू चातस त आस ट्लाई डेरे बनाम, अक तेरे लेइ ते अक मूसेरे लेइ ते अक एलिय्याहरे लेइ।” ");
INSERT INTO bhd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","तै ए गल ज़ोई राहोरो थियो, अक बड़ी चमकती बिदलार तैन पुड़ एइतां रुकी, ते तैस बिदलारी मरां ई आवाज़ आई, “एन मेरू ट्लारू मट्ठूए, ज़ैस पुड़ अवं खुश आईं, एसेरी शुना।” ");
INSERT INTO bhd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","चेले एन शुन्तां तुत्तेरे भारे बिछ़ड़े ते बड़े डेरि जे। ");
INSERT INTO bhd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","पन यीशुए एइतां तैन सेइं हथ लाव, ते ज़ोवं, “उठा, डरा नन्ना।” ");
INSERT INTO bhd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ज़ैखन तैनेईं च़ेव्रे पासन तक्कू, त यीशुएरे अलावा होरो कोई न लाव। ");
INSERT INTO bhd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ज़ैखन तैना तैस पहाड़े पुड़ेरां उन्ढे ओरे थिये, त यीशुए तैन ई हुक्म दित्तो, ज़ैन किछ तुसेईं लाहेरूए, “ज़ां तगर मैनेरू मट्ठू मुड़दन मरां ज़ींतू न भोए तांतगर केन्ची सेइं न ज़ोइयथ।” ");
INSERT INTO bhd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","तैसेरे चेलेईं तैस पुच़्छ़ू, “शास्त्री किजो ज़ोतन कि मसीहेरे एजनेरां पेइले, एलिय्याह नेबेरू दुनियाई मां एजनू ज़रूरी आए?” ");
INSERT INTO bhd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","तैनी जुवाब दित्तो, “एलिय्याह ज़रूर एज्जेलो ते सब किछ बहाल केरेलो। ");
INSERT INTO bhd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","पन अवं तुसन सेइं ज़ोतईं कि ‘एलिय्याह’ त पेइले ओरोए, पन लोकेईं तै न पिशानो, पन ज़ैन चाऊ तैस सेइं तैन्ने कियूं, एन्च़रे मैनेरू मट्ठू भी तैन केरे हथ्थन सेइं दुःख भोगेलो।” ");
INSERT INTO bhd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","तैखन चेलेईं बुझ़ू कि असन सेइं यूहन्ना बपतिस्मो देनेबालेरे बारे मां ज़ोने लोरोए। ");
INSERT INTO bhd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ज़ैखन तैना हछे मैन्हु केरि बड़ी भीड़ी कां पुज़े, त अक मैन्हु तैस कां अव, ते ज़ैधू केरे भारे बिश्तां ज़ोने लगो। ");
INSERT INTO bhd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“हे प्रभु मेरे मट्ठे पुड़ दया केर, तैस मिरगरी वजाई सेइं दौवरे एइतन, ते तैस बड़ो दुखे, ते बार-बार अग्गी मां ते बार-बार पैनी मांजो खिरकते। ");
INSERT INTO bhd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","मीं तैन तेरे चेलन कां आनोरू थियूं, पन तैनेईं तैन ठीक न केरि बटु।” ");
INSERT INTO bhd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","यीशुए ज़ोवं, “हे घट विश्वावैसव ते ढीठ लोकव, अवं केइस तगर तुसन सेइं साथी भोनोईं, केइस तगर तुश्शी झ़ैलतो रेइलो? तै मीं कां आनां।” ");
INSERT INTO bhd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","तैखन यीशुए तैन भूत झ़िड़कू, ते तैस पुड़ां सैयो निस्सी जेव, ते तैन मट्ठू तैखने ठीक भोइ ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","तैखन चेलेईं अकैल्ले ज़ेरे यीशु कां गेइतां पुच़्छ़ू, “अस तैस मट्ठे मरां भूतेरो सायो की न केड्डी सके?” ");
INSERT INTO bhd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","तैनी तैन सेइं ज़ोवं, “अपने घट विश्वासेरे वजाई सेइं, अवं तुसन सेइं सच़ ज़ोताईं, अगर तुश्शो विश्वास शेरीएरे ग्लेवे ज़ेत्रो भी भोए, त तुस उस पहाड़े जो ज़ोले कि, ‘इट्ठां निस्तां उड़ी गा,’ त तैन गालू, ते तुश्शे लेइ कोई भी गल असुखती न भोली। ");
INSERT INTO bhd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","पन इस किसमेरां भूतां प्रार्थना ते बरते बगैर न निस्सन।” ");
INSERT INTO bhd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ज़ैखन तैना गलीले मां थी, त यीशुए तैन सेइं ज़ोवं, “मैनेरू मट्ठू भी मैन्हु केरे हवाले कियूं गालू। ");
INSERT INTO bhd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","तैना तैस मारेले, ते तैन ट्लेइयोवं दिहाड़े फिरी ज़ींतो भोलू।” चेले एन शुन्तां बड़े परेशान भोए। ");
INSERT INTO bhd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ज़ैखन तैना कफरनहूम नगर मां पुज़े, त प्रार्थना घरेरे लेइ चुंगी घिन्ने बाले पतरसे कां एइतां पुच़्छ़ू, “कुन तुश्शो गुरू प्रार्थना घरेरी चुंगी न दे?” ");
INSERT INTO bhd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","तैनी जुवाब दित्तो, “हाँ देते।” ज़ैखन पतरस घरे मां पुज़ो त यीशुए तैसेरे पुछ़नेरे पेइले तैस सेइं ज़ोवं, “हे शमौन तू कुन समझ़तस? दुनियारे राज़े कोन लोकन करां चुंगी घिन्तन अपने बच्चन करां या होरि लोकन करां?” ");
INSERT INTO bhd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पतरसे तैस सेइं ज़ोवं, “होरन करां।” यीशुए तैस सेइं ज़ोवं, “त मट्ठां बरी भोइ जेआं। ");
INSERT INTO bhd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","फिरी भी एल्हेरेलेइ कि अस तैन ठोकर न देम, तू समुन्दरे पुड़ गेइतां कंटो लेइतां मेछ़ली ट्लेइयां, ते ज़ै मछ़ली पेइली लग्गेली, तैसारू आशी खोल्लां, ते तीं अक सिक्को मैलनोए, ते तै सिक्को नेइतां मेरी ते अपनि चुंगी देइयां।” ");
INSERT INTO bhd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","तैखन चेले यीशु कां आए ते पुच्छ़ने लग्गे, “स्वर्गेरे राज़्ज़े मां सेब्भन करां बड्डो कौने?” ");
INSERT INTO bhd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","तैनी अक निकड़ो बच्चो एप्पू कां कुजाव, ते मझ़ाटे खड़ो कियो। ");
INSERT INTO bhd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ते ज़ोने लगो, “अवं तुसन सेइं सच़ ज़ोताईं, कि तुस अपनो आप बेदलतां निकड़े बच्चेरो ज़ेरे न बनथ, त तुस स्वर्गेरे राज़्ज़े मां कधी दाखल न भोले। ");
INSERT INTO bhd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ज़ै कोई अपनो आप इस बच्चेरो ज़ेरो निकड़ो बनालो, त तै स्वर्गेरे राज़्ज़े मां बड्डो भोलो। ");
INSERT INTO bhd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ते ज़ै कोई एरे ज़ेरे निकड़े बच्चे मेरे नंव्वे सेइं कबूल केरते, त तै मीं कबूल केरते।” ");
INSERT INTO bhd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ज़ै कोई इन निकड़न मरां ज़ैना मीं पुड़ विश्वास केरतन एक्केरे लेइ ठोकर बने, त तैसेरेलेइ एन्ने रोड़ू आए कि बडे ढ्लाटेरो ढ्लेइटोल तैसेरे गल्ले उन्ढो ढंढेइतां डुघे समुन्द्रे मां डोबतां छ़डोरो लोड़ते। ");
INSERT INTO bhd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ठोकरां केरि वजाई सेइं दुनियाई पुड़ अफ़सोस! ठोकरां लेग्गनी त ज़रुरन पन, अफ़सोस तैस मैन्हु पुड़ ज़ेसेरी वजाई सेइं ठोकर लग्गतीए। ");
INSERT INTO bhd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","अगर तेरो हथ या तेरो पाव तेरे लेइ ठोकरारो ज़िरयो बनते, त तू तैस केटतां छ़ड, किजोकि तेरू टोंटु या कानू बेनतां ज़िन्दगी मां दाखल भोनू रोड़ूए, ते तेरे दुइये हथ पाव सथे भोने सेइं अगर तू हमेशारी अग्गी मां गास त तैल्ला केरतां तू टोंटो या कानो बेनतां रोड़ोस। ");
INSERT INTO bhd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","अगर तेरी अछ़ तेरे लेइ ठोकर्री वजा बनती, त तू तैस केढतां शैरी छ़ड, कानू भोइतां ज़िन्दगी मां दाखल भोनू तेरे लेइ रोड़ूए, कि दुइये एछ़्छ़ी भोने सेइं तू नरकेरी अग्गी मां गास त तैल्ला रोड़ोस।” ");
INSERT INTO bhd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“हेरा इन निक्के चेलन मरां तुस केन्ची घटिया न बुझ़ा, अवं तुसन सेइं ज़ोताईं कि तैन केरे स्वर्गदूत हर वक्त स्वर्गे मां मेरे बाजी केरे हज़ूरी मां रातन। ");
INSERT INTO bhd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(किजोकि मैनेरू मट्ठू यानी अवं हेरोरे लोकन बच़ाने ओरोईं।) ");
INSERT INTO bhd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","तुश्शो खियाल कुने? कि केसकोई कां 100 भैड्डां भोन, ते तैस मरां अक हेरोए, त कुन तै नड़ेनुवें भैड्डां ज़ैड़ी खतरो न भोए तैड़ी छ़ेडतां, तैस हेरोरि न तोपेलो? ");
INSERT INTO bhd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ते अगर एरू भोए, तैस तै मैल्ले, त अवं तुसन सेइं सच्च़ ज़ोताईं कि तै तैना नड़ेनुवें केरे लेइ एत्री खुशी न मनालो, ते तैस एक्की भैडारे लेइ जादे खुशी बनालो। ");
INSERT INTO bhd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","एन्च़रे तुश्शो बाजी ज़ै स्वर्गे मांए, तै एन न चाए कि एन निकन मरां भी कोई नाश न भोए।” ");
INSERT INTO bhd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“अगर कोई मीं पुड़ विश्वास केरनेबालो ढ्ला तीं सेइं बुराई केरते, त तू अकैल्ले मां तैस समझ़ा, अगर तै तेरी गल शुने, त तीं तै वापस परमेशरे कां आनो। ");
INSERT INTO bhd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","अगर तै तेरी गल न शुने, त तू एप्पू सेइं साथी अक या दूई मैन्हु नेइयां, किजोकि मूसेरे कानूनेरे मुताबिक हर शिकैइतरी मां दूई या ट्लाई मैन्हु गवाह भोतन। ");
INSERT INTO bhd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","अगर तै तैन केरि भी न शुने, त तू कलीसियारे लोकन सेइं ज़ो, अगर तै कलीसियारे लोकां केरि भी न शुने, त तू तैस सेइं एरो बर्ताव केर ज़ेन्च़रां तै गैर कौमरो भोए या चुंगी घिन्ने बालो भोए।” ");
INSERT INTO bhd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“अवं तुसन सेइं सच़ ज़ोताईं, ज़ैन किछ तुस ज़मीनी पुड़ बंधेले त समझ़ा कि स्वर्गे पुड़ बंधोलू, ते ज़ैन किछ तुस ज़मीनी पुड़ खोल्लेले त तैन स्वर्गे मां खुल्लेलू। ");
INSERT INTO bhd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","फिरी अवं तुसन सेइं सच़ ज़ोताईं, कि अगर तुसन मरां दूई ज़ने धेरती पुड़ अक मन भोइतां कोन्ची मसलेरे हल कढनेरे लेइ परमेशरे करां ज़ै स्वर्गे मां आए मद्दत मगन, त तै तैन केरि मद्दत ज़रूर केरेलो। ");
INSERT INTO bhd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","किजोकि ज़ैड़ी दूई या ट्लाई मैन्हु, मेरे नव्वें सेइं परमेशरे करां मद्दत मगनेरे लेइ अकोट्ठे भोतन, अवं तैड़ी तैन केरि मद्दत केरनेरे लेइ तैन मां भोइताईं।” ");
INSERT INTO bhd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","तैखन पतरसे यीशु कां एइतां पुच़्छ़ू, “प्रभु अगर कोई तीं पुड़ विश्वास केरनेबालो, मीं सेइं बुराई केरतो राए, त अवं केत्रे बार तैस माफ़ केरि? कुन सत बार?” ");
INSERT INTO bhd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","यीशुए जुवाब दित्तो, “अवं तीं सेइं इन न ज़ोईं सत बार, बल्के सत्तेरे सत्तर बार माफ़ करां (यानी लगातार माफ़ केरतू रानू)। ");
INSERT INTO bhd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","बस्सा अवं तुसन सेइं इन ज़ोताईं, स्वर्गेरू राज़ तैस राज़्ज़ेरू ज़ेरू आए, ज़ैनी सोचू कि अवं अपने नौकरन करां हिसाब घिंनी। ");
INSERT INTO bhd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ज़ैखन तै हिसाब घिन्ने लगो, त अक मैन्हु तैस कां हाज़र कियो, ज़ै दश हज़ार सोन्नेरे सिक्कां केरे तोड़ां केरो कर्ज़दार थियो। ");
INSERT INTO bhd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","तैस कां कर्ज़ो मुकाने जो किछ न थियूं, राज़े हुक्म दित्तो, एसेरे बाल बच्चे ते कुआन्श ते ज़ैन किछ भी आए सब बेच़तां कर्ज़ो उसुल केरा। ");
INSERT INTO bhd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","पन तै नौकर ज़ोवले हथ केरतां मालिके कां मिनत केरतां ज़ोने लगो, ‘मीं किछ मौको दे, ते अवं तेरो सारो कर्ज़ो मुकालो।’ ");
INSERT INTO bhd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","मालिके तैस नौकरे पुड़ बड़ो तरस अव, ते तैनी तै छैडी दित्तो ते तैसेरो कर्ज़ो भी माफ़ कियो।” ");
INSERT INTO bhd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“पन ज़ैखन तै नौकर तैट्ठां च़लो जेव, त तैस अक एरो नौकर मैल्लो, ज़ै तैसेरो साथी थियो, ते तैस तैनी 100 दीनार दित्तोरे थिये, तैनी तै गलेरां ट्लाव ते ज़ोने लगो, ‘मेरो कर्ज़ो कढ।’ ");
INSERT INTO bhd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","तैसेरो साथी नौकर तैस्से कां मिनत केरने लगो, मीं किछ मौको दे ते अवं तेरो सारो कर्ज़ो मुकालो। ");
INSERT INTO bhd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","पन तैनी तैसेरी अक गल भी न शुनी, ते तैनी तै ढेपतां छ़ड्डो कि ज़ां तगर कर्ज़ो न देस तांतगर ढप्पोरो रा। ");
INSERT INTO bhd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ज़ैखन होरि नौकरेईं एन शुनू, त तैना बड़े परेशान भोए, ते मालिके कां गेइतां सारो हाल शुनाव। ");
INSERT INTO bhd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तैखन मालिके तै अपने नौकर कुजेइतां ज़ोवं, ‘ओ बेईमान नौकरा मीं तेरो सारो कर्ज़ो माफ़ कियो, किजोकि तीं मीं कां छंदे कियोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","कुन तेरे लेइ ज़रूरी न थियूं, कि ज़ेन्च़रे मीं तीं पुड़ दया केरतां तेरो कर्ज़ो माफ़ कियो, तेन्च़रे तू भी अपने सैथन पुड़ दया केरतां तैन केरो कर्ज़ो माफ़ केरेथो?’ ");
INSERT INTO bhd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","मालिके सरक आई, ते तैनी तै नौकर सज़ा देनेबालां केरे हवाले कियो, कि ज़ां तगर मेरो सारो कर्ज़ो न दे तांतगर ढप्पोरो भोए। ");
INSERT INTO bhd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“एन्च़रे अगर तुसन मरां हर कोई, तैस मैन्हु ज़ै मीं पुड़ विश्वास केरते दिले सेइं माफ़ न केरे त मेरो स्वर्गेरे बाजी यानी परमेशर भी तुसन सेइं एन्च़रे पैश एज्जेलो।” ");
INSERT INTO bhd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ज़ैखन यीशुए एन गल्लां ज़ोई छ़ैडी, त तै गलीले मरां गेइतां यरदन दरियारे पार यहूदिया इलाके मां च़लो अव। ");
INSERT INTO bhd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","बड़े लोक यीशु पत्ती च़ले जे, ते यीशुए तैना तैड़ी बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","तैखन फरीसी लोकेईं यीशु कां एइतां तैस अज़मानेरे लेइ पुच़्छ़ू, “कुन मैन्हु अपनि कुआन्श केन्ची भी वजाई सेइं फारख्ती देनी जेइज़े?” ");
INSERT INTO bhd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","तैनी जुवाब दित्तो, “कुन तुसेईं नईं पढ़ेरू कि ज़ैने तैना बनां तैनी शुरू करां मड़द ते कुआन्श बनेवरां थियां। ");
INSERT INTO bhd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘एल्हेरेलेइ मड़द अपने हाज बव्वे करां कनारे बिश्तां अपनि कुआन्शी सेइं साथी रालो, ते तैना दुइये अक जान भोलां।’ ");
INSERT INTO bhd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","एल्हेरेलेइ हुनी तैना परमेशरेरी नज़री मां दूई नईं, पन अक्के आन। एल्हेरेलेइ ज़ैना परमेशरे ज़ोड़ोरेन, तैनन् कोई मैन्हु अलग न केरे!” ");
INSERT INTO bhd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","तैनेईं तैस पुच़्छ़ू, “फिरी मूसे ए हुक्म किजो दित्तो कि फारख्ती लिखतां छैडी देथ?” ");
INSERT INTO bhd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","तैनी तैन सेइं ज़ोवं, “मूसे तुश्शे सखत दिलेरी वजाई सेइं अपनि कुआन्शन छ़डनेरो हुक्म दित्तोरो थियो, पन शुरू करां एन न थियूं। ");
INSERT INTO bhd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","अवं तुसन सेइं सच़ ज़ोताईं, कि ज़ै कोई अपनि कुआन्शी बदमैशरे अलावा कोन्ची होरि गल्ली पुड़ फारख्ती दे, ते तै केन्ची होरि सेइं ड्ला बनाते, त तै (एप्पू) बदमाशी केरते। ते ज़ै तैस शैरोरी कुआन्शी सेइं ड्ला बनाते, त तै भी बदमाशी केरते।” ");
INSERT INTO bhd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","चेलेईं यीशु सेइं ज़ोवं, “अगर मड़द ते कुआन्शारे रिशतेरो ई हाले त ड्ला न लोड़े बनोरो।” ");
INSERT INTO bhd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","यीशुए तैन सेइं ज़ोवं, “ए गल सब कबूल न केरि बटन, सिर्फ तैना ज़ैन परमेशर ई काबलीत दित्तोरीए। ");
INSERT INTO bhd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","किछ त ज़र्मनेरे हिजड़े भोतन ते किछन लोक बनातन, ते किछ एरे भी आन, कि ज़ैन स्वर्गेरे राज़्ज़ेरे लेइ ड्ला न बनान, ते ज़ैना इना गल्लां सेमझ़ी सकतन तैना समझ़न।” ");
INSERT INTO bhd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","तैखन लोकेईं बच्चे यीशु कां आने, कि तैन पुड़ हथ रेखतां प्रार्थना केरे, पन चेलेईं तैना लोक झ़िड़के। ");
INSERT INTO bhd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","यीशुए ज़ोवं, “बच्चे मीं कां एजने देथ, तैन न ठाका, किजोकि स्वर्गेरू राज़ एरां केरूए।” ");
INSERT INTO bhd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ते तै बच्चन पुड़ हथ रेखतां तैट्ठां अग्रोवं च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","हेरा, अक मैन्हु यीशु कां अव ते पुच्छ़ने लगो, “हे गुरू अवं कुन भलू कम केरि, कि हमेशारी ज़िन्दगी हासिल केरि?” ");
INSERT INTO bhd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","यीशुए तैस सेइं ज़ोवं, “तू मीं भलैइये बारे मां किजो पुछ़तस? परमेशरेरे अलावा होरो कोई भी रोड़ो नईं, पन अगर तू हमेशारी ज़िन्दगी हासिल केरनि चातस त हुक्म मनन्।” ");
INSERT INTO bhd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","तैनी ज़ोवं, “कोन हुक्मन पुड़?” यीशुए ज़ोवं, “खून नईं केरनो, बदमाशी नईं केरनि, च़ोरी नईं केरनि, झूठी गवाही नईं देनी, ");
INSERT INTO bhd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","अपने हाज बव्वां केरि सेवा केर, अपने पड़ोसी सेइं अपने बराबर प्यार केर।” ");
INSERT INTO bhd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","तैनी जवाने जुवाब दित्तो, “एना सब हुक्म अवं बचपनेरो मन्तो ओरोईं। हुनी मीं मां को कमीए?” ");
INSERT INTO bhd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","यीशुए तैस सेइं ज़ोवं, “अगर तू सिद्ध भोनू चातस, त गा ज़ैन किछ तीं कां आए तैन बेच़तां गरीब मैनन् दे, तैखन तीं स्वर्गे मां खज़ानो मैलेलो। ते एइतां मीं पत्ती च़ल।” ");
INSERT INTO bhd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","पन तैनी जवाने ए गल शुनी, त बड़ो उदास भोइतां च़लो जेव, किजोकि तै बड़ो अमीर थियो। ");
INSERT INTO bhd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","तैखन यीशुए अपने चेलन सेइं ज़ोवं, “अवं तुसन सेइं सच़ ज़ोताईं कि अमीर मैनेरू स्वर्गेरे राज़्ज़े मां दाखल भोनू मुशकले। ");
INSERT INTO bhd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","फिरी अवं तुसन सेइं ज़ोताईं, परमेशरेरे राज़्ज़े मां अमीर मैनेरू दाखल भोने केरां ऊँटेरू सांधनेरे पाऐ मरां निस्नू सुख्तू आए!” ");
INSERT INTO bhd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","एन शुन्तां चेलेईं हैरान भोइतां ज़ोवं, “फिरी कसेरी मुक्ति भोइ बटतीए।” ");
INSERT INTO bhd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","यीशुए तैन केरे पासे तेकतां ज़ोवं, “मैनन् करां त एन न भोइ सके पन परमेशरे करां सब किछ भोइ बटते।” ");
INSERT INTO bhd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","एस पुड़ पतरस ज़ोने लगो, “हेर अस सब किछ शैरतां तीं पत्ती च़लोरेम ते असन कुन मैलनूए?” ");
INSERT INTO bhd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","यीशुए तैन सेइं ज़ोवं, “अवं तुसन सेइं सच़ ज़ोताईं, कि नंव्वे दुनियाई मां ज़ैखन अवं मैनेरू मट्ठू अपने महिमारे तखते पुड़ बिशेलू, त तुस भी मीं पत्ती च़लने बाले 12 तखतन पुड़ बिश्तां इस्राएलेरे 12 गोत्रां केरो इन्साफ केरेले। ");
INSERT INTO bhd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ते ज़ैनी केन्चे अपना घरां ते ढ्ला या बेइन या हाज या बव या बच्चे या ऊडारां छ़ड्डोरेन, तैस 100 गुणा फल मैलेलो, ते हमेशारी ज़िन्दगरी विरासत मैलेली। ");
INSERT INTO bhd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","पन बड़े मैन्हु ज़ैना हुन्ना पेइले आन, तैना बादे मां पत्रोवं भोनेन। त ज़ैना हुन्ना पत्रोवं आन, तैना बादे मां पेइले भोनेन।” ");
INSERT INTO bhd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“स्वर्गेरू राज़ तैस ज़िमदारेरू ज़ेरूए ज़ै झ़ेझ़ां उट्ठतां ते अपने दाछ़री बागी मां मज़दूर कम्मे लाए। ");
INSERT INTO bhd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","तैनी अक दीनार रोज़ मुजुरी देनेरे लेइ तैना बागी मां भेज़े। ");
INSERT INTO bhd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","फिरी नौ बज़ेइं बेइर गेइतां तैनी बज़ारे मां काई लोक बेकार खड़े लाए। ");
INSERT INTO bhd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","तैनी तैन सेइं ज़ोवं, ‘तुस भी मेरी बागी मां गाथ, ते ज़ैन किछ जेइज़ भोलू अवं तुसन देलो।’ तैना कम्मे पुड़ जो जे। ");
INSERT INTO bhd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","फिरी तैनी दुपहरेईं ते ट्लेइ बज़न तगर एन्ने कियूं। ");
INSERT INTO bhd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","पंच़े बज़ेइं तैनी बेइर निस्तां किछ होरे लोक भी खड़खड़े लेइतां तैन पुच़्छ़ू, ‘तुस झ़ेझ़ेरे देंते किजो खेड़ोरेथ?’ तैनेईं जुवाब दित्तो, ‘अस केन्चे कम्मे नईं लोरे।’ ");
INSERT INTO bhd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","तैनी तैन सेइं ज़ोवं, ‘तुस भी मेरे बागी मां गाथ ते कम केरा।’” ");
INSERT INTO bhd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ड्लोझ़ी तैनी बागरे मालिके अपने मुन्शी सेइं ज़ोवं कि, ‘पेइले लग्गोरे मज़दूर ते पत्ती कम्मे लग्गोरे मज़दूर सेब्भन अक-अक दीनार दिहाड़ी दे।’ ");
INSERT INTO bhd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ज़ैना पंच़े बज़ेइं ओरे थिये, तैन भी अक दीनार पूरी दिहाड़ी मैल्ली। ");
INSERT INTO bhd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ज़ैना मज़दूर झ़ेझ़ां कम्मे लग्गोरे थिये तैन केरि बारी आई त तैनेईं सोचू कि असन जादे मैलनेन, पन तैन भी अक-अक दीनार मैल्लो। ");
INSERT INTO bhd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ज़ैखन दिहाड़ी मैल्ली, त तैस मालिकेरे बारे मां तैना एप्पू मांमेइं बुराई केरने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘पत्ती लोरे मज़दूरेईं सिर्फ अक घैन्टो कम कियोरूए, ते तीं तैन भी असन बराबर ज़ैनेईं सैरी दिहैड़ी कम कियां मुजुरी दित्ती।’ ");
INSERT INTO bhd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","तैनी तैन मरां एक्की जुवाब दित्तो, ‘दोस्त मीं तीं सेइं कोई बेइन्साफी नईं कियोरी, कुन मीं तीं सेइं अक दीनार दिहैड़री गल न थी कियोरी? ");
INSERT INTO bhd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","एल्हेरेलेइ ज़ै तेरी मज़दूरीए तै ट्ला ते च़लो गा, ए मेरी मर्ज़ीए कि बादे मां लग्गोरे मज़दूर भी एत्रे देईं। ");
INSERT INTO bhd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","कुन मीं ए अधिकार नईं कि अपने माले मरां ज़ैन चैईं तैन केरि? तू मीं पुड़ एल्हेरेलेइ ज़लतस कि अवं खुल्ले दिले सेइं देने बालोईं?’ ");
INSERT INTO bhd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","एल्हेरेलेइ बड़े मैन्हु ज़ैना हुन्ना पेइले आन, तैना बादे मां पत्रोवं भोनेन, ते ज़ैना हुन्ना पत्रोवं आन, तैना बादे मां पेइले भोनेन।” ");
INSERT INTO bhd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","यरूशलेम नगरे जो गांते बार यीशुए अपने 12 चेलन अलग नेइतां तैन सेइं ज़ोवं, कि तैस सेइं कुन भोने बालूए। ");
INSERT INTO bhd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“हेरा, अस यरूशलेम नगरे जो च़लोरेम, मैनेरू मट्ठू प्रधान याजकां ते शास्त्री लोकां केरे हवाले कियूं गालू, ते तैना तैस मारनेरे काबल ठैरेले। ");
INSERT INTO bhd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","तैस गैर कौमां केरे हवाले केरेले, तैना मैनेरे मट्ठेरी यानी मेरी हासी बनाले, ते तैस कोड़े बाहेले, ते फिरी तैस क्रूसे पुड़ च़ाढ़ेले, ते अवं ट्लेइयोवं दिहाड़े फिरी ज़ींतो भोलो।” ");
INSERT INTO bhd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","तैखन जब्दी नंव्वेरे मैनेरां मट्ठां केरि अम्मा अपने मट्ठन सेइं साथी यीशु कां आई, ते तैस कां मिनत केरने लाई ते तैस करां किछ मगने लग्गी। ");
INSERT INTO bhd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","तैने तैस पुच़्छ़ू, “तीं कुन लोड़ते?” तैसां ज़ोवं, “वचन दे, कि मेरां इन्ना मट्ठां तेरे राज़्ज़े मरां अक तेरे देइने पासे त होरू तेरे बाएं पासे बिश्शन।” ");
INSERT INTO bhd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","पन यीशुए तैन सेइं ज़ोवं, “तुस न ज़ानथ कि कुन मगने लग्गोरेथ! ज़ेन्च़रे दुख अवं झ़लने बालोईं, कुन तुस झ़ेल्ली सकतथ? तैनेईं जुवाब दित्तो, हाँ झ़ेल्ली सकतम।” ");
INSERT INTO bhd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","तैनी तैन सेइं ज़ोवं, “तुस मेरे ज़ेरो दुःख झ़ल्लेले, पन एन मेरू कम नईं कि एक्की देइने पासे ते होरि बांए पासे बिशैली, ए ठार ज़ेसेरे लेइ मेरे बाजेरे तरफां रखोरीए तै तैसेरे लेइए।” ");
INSERT INTO bhd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","एन शुन्तां होरि दश चेलेईं तैन दूई ढ्लान पुड़ नराज़ भोइ जे। ");
INSERT INTO bhd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","यीशुए अपने सारे चेले नेड़े कुजेइतां, तैन सेइं ज़ोवं, “होरि कौमां केरे प्रधान अपने लोकन पुड़ राज़ केरतन, ते तैन केरे मालिक तैन पुड़ अधिकार रखतन। ");
INSERT INTO bhd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","पन तुसन मां एरू न लोड़े भोरू, बल्के तुसन मां ज़ै बड्डो बन्नो चाते, तै सेब्भी केरो सेवक बने। ");
INSERT INTO bhd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ज़ै कोई तुसन मां प्रधान बन्नू चाए, तै सेब्भी केरो गुलाम बने, ");
INSERT INTO bhd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ज़ेन्च़रे कि मैनेरू मट्ठू एल्हेरेलेइ नईं ओरूए कि कोई तैसेरी सेवा केरे, बल्के एल्हेरेलेइ कि सेवा केरे, ते अपनि जान बड़े लोकां केरे छुटकारेरे लेइ दे।” ");
INSERT INTO bhd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ज़ैखन यीशु त तैसेरे चेले यरीहो नगरे मरां च़लोरे थिये, त बड़े लोक तैस पत्पती च़ले। ");
INSERT INTO bhd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","दूई काने बत्ती मां बिश्शोरे थिये, तैनेईं एन शुनू कि यीशु इस बत्तां च़लोरोए, त तैना चिन्डां मारने लग्गे, “हे प्रभु दाऊदेरा मट्ठां असन पुड़ दया केर।” ");
INSERT INTO bhd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","लोक तैन झ़िड़कने ते ज़ोने लग्गे कि च़ुप राथ, पन तैना मना चिन्डां मारने लग्गे, “हे प्रभु, दाऊदेरा मट्ठां असन पुड़ दया केर।” ");
INSERT INTO bhd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","तैखन यीशु खेड़ोव ते तैन कुजेइतां पुच्छ़ने लगो, “तुस कुन चातस अवं तुश्शे लेइ केरि?” ");
INSERT INTO bhd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","तैन कानेईं जुवाब दित्तो, “हे प्रभु अस चातम कि इश्शी एछ़्छ़न लौ एज्जे।” ");
INSERT INTO bhd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","यीशुए तैन पुड़ बड़ो तरस अव, ते तैनी तैन केरे एछ़्छ़न पुड़ हथ रख्खो ते तैना लहने लग्गे, ते दुइये काने यीशु पत्ती च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ज़ैखन यीशु ते कने तैसेरे चेले यरूशलेम नगरेरे नेड़े पुज़े, त यीशुए ज़ैतून पहाड़े पुड़ बैतफगे मरां अपने दूई चेले एन ज़ोइतां अग्रोवं भेज़े। ");
INSERT INTO bhd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“अपने सामने उस ड्लव्वें मां गाथ, ते तैड़ी पुज़ेले, त तुसन अक गधी बंधोरी मैलनिये, ते तैस साथी तैसेरो बच्चो भी भोनोए, तैस खोलतां इड़ी मीं कां आनां।” ");
INSERT INTO bhd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","अगर तुसन कोई पुच़्छ़े, त तुस ज़ोइयथ, कि प्रभुए एसेरी ज़रूरत आए, ते तै लूशी तैस वापस भेज़ेलो। ");
INSERT INTO bhd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","इन सब किछ एल्हेरेलेइ भोवं, कि नेबे ज़ैन वचन ज़ोरू थियूं, तैन पूरू भोवं, ");
INSERT INTO bhd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सिय्योनेरे कुइये सेइं ज़ोथ, कि तेरो राज़ो तीं कां ओरोए, ते तै बड़ो हलीमी ते तै गैधी पुड़ च़ेढ़तां ओरोए, बल्के गधेरे बच्चे पुड़।” ");
INSERT INTO bhd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","चेले च़ले जे ते ज़ेन्च़रे यीशुए ज़ोरू थियूं, तैनेईं तेन्च़रे कियूं। ");
INSERT INTO bhd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","तैनेईं तै गधी ते तैसारो बच्चो आनो, ते तैन पुड़ अपना लिगड़ां छ़डां, ते यीशु तैस पुड़ च़ेढ़तां च़लो। ");
INSERT INTO bhd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","बड़े लोकेईं अपना लिगड़ां बत्ती मां बिछ़ां, ते किछेईं बुट्टा केरे डाल केटतां बत्ती मांमेइं छ़डोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ते तैना लोक ज़ैना यीशु सेइं साथी अग्री-अग्री ते पत्ती-पत्ती च़लोरे थिये, तैना नहरे देते थिये, “दाऊदेरे मट्ठेरी होशाना (तारीफ़), धने तै, ज़ै प्रभुएरे नंव्वे सेइं एइते, स्वर्गे मां होशाना।” ");
INSERT INTO bhd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ज़ैखन यीशु यरूशलेम नगरे मां पुज़ो, त सारे नगर मां हलचल मेच़ि जेई, ते लोक ज़ोने लग्गे, “ए कौने?” ");
INSERT INTO bhd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","लोकेईं ज़ोवं, “ई गलीलेरे नासरत नगरेरो नबी यीशुए।” ");
INSERT INTO bhd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","यीशुए परमेशरेरे मन्दरेरे अंगने मां गेइतां, ज़ैना बुपारी बुपार केरते थिये सब तैट्ठां कढे, तैनी सुनारां केरि दुकान ते कबूतर बेच़ने बालां केरि ठारां ट्लोड़ी। ");
INSERT INTO bhd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ते तैनी ज़ोवं, “लिखोरूए कि मेरे मन्दरे जो प्रार्थना केरनेरू घर ज़ोले, पन तुसेईं त ए डैकू केरो अड्डो बनेवरोए।” ");
INSERT INTO bhd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","तैखन काने ते टोंटे मन्दरे मां यीशु कां आए, ते तैनी तैना सब बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","पन ज़ैखन मन्दरेरे प्रधान याजक ते शास्त्री लोक एना कम्मां ज़ैना तैनी कियां, ते मट्ठन मन्दरे मां दाऊदेरी औलादरी होशाना (तारीफ़) ज़ोते लाए, तैन बड्डी सरक आई। ");
INSERT INTO bhd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ते तैस सेइं ज़ोने लग्गे, “तू शुन्ने लोरोस कि एना कुन ज़ोने लोरेन?” यीशुए तैन सेइं ज़ोवं, “हाँ अवं शुन्ने लोरोईं, तुसेईं कधे नईं पढ़ेरू कि, ‘तीं मट्ठन ते दुद्ध पीते बच्चन करां भी तीं अपनि पूरी तारीफ़ कमाई?’” ");
INSERT INTO bhd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","तैखन तै तैन शैरतां नगरे बेइरोवं च़लो जेव, ते बैतनिय्याह नगरे मां जेव ते तैड़ी रात गुज़ारी। ");
INSERT INTO bhd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","झ़ेझ़ां ज़ैखन यीशु नगरे मांजो वापस ओरो थियो, त तैस ढ्लुख लग्गी। ");
INSERT INTO bhd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","बत्तारे ड्लेखी अक फ़ेगेरो बूट लाव ते तैस कां जेव, ते पट्लां केरे अलावा तैस पुड़ किछ न लाव, तैनेईं तैस जो ज़ोवं, “कधे भी तीं पुड़ फल न लग्गेलो ते तैखने तै बुट शुक्की जेव।” ");
INSERT INTO bhd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","एन हेरतां चेले हैरान भोइतां पुच्छ़ने लग्गे, “ई फ़ेगेरो बुट अकदम केन्च़रे शुक्की जोरोए?” ");
INSERT INTO bhd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","यीशुए जुवाब दित्तो, “अवं तुसन सेइं सच़ ज़ोताईं कि अगर तुस विश्वास रखथ, ते शक न केरथ, ज़ैन फ़ेगेरे बुटे सेइं भोवं तैन तुस भी केरि सकतथ, बल्के उस पहाड़े जो ज़ोले कि इट्ठां उखड़तां समुन्द्रे मां गा, त तैन्ने भोलू।” ");
INSERT INTO bhd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","अगर तुश्शो विश्वास पक्कोए त ज़ैन किछ तुस प्रार्थनाई मां मग्गेले, तैन तुसन मैल्ली गालू? ");
INSERT INTO bhd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","यीशु मन्दरे मां शिक्षा देने लोरो थियो, त प्रधान याजक, ते लोकां केरे बुज़ुर्गेईं तैस पुच़्छ़ू, तू एन कम कसेरे अधिकारे सेइं केरतस? ते तीं एन कम कैनी दित्तोरोए? ");
INSERT INTO bhd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","यीशुए तैन जुवाब दित्तो, “अवं भी तुसन अक गल पुछ़तईं, अगर तुस तैसेरो जुवाब देले, त अवं भी ज़ोइलो कि अवं एन कम कसेरे अधिकारे सेइं केरताईं। ");
INSERT INTO bhd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","यूहन्नारो बपतिस्मो कोट्ठां थियो? स्वर्गेरे तरफां थियो, या की इन्सानेरी तरफां थियो? तैना एप्पू मांमेइं गलबात केरने लग्गे, कि अगर अस ज़ोतम कि, स्वर्गेरे तरफां थियो, त फिरी तैनी ज़ोनूए कि फिरी तुसेईं तैसेरू याकीन की नईं कियेरू? ");
INSERT INTO bhd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","पन अगर अस ज़ोतम कि, ‘इन्सानेरी तरफां थियो,’ त लोकां केरो भी डरे किजोकि लोक यूहन्ना नबी मन्ते थिये।” ");
INSERT INTO bhd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","एल्हेरेलेइ, तैनेईं यीशुए जुवाब दित्तो, “अस किछ न ज़ानम।” तैनी भी तैन सेइं ज़ोवं, “अवं भी तुसन सेइं न ज़ोईं कि अवं इन कम्मां कसेरे अधिकारे सेइं केरताईं।” ");
INSERT INTO bhd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","पन तुस इस मिसालरे बारे मां कुन सोचतथ? केन्ची मैनेरां दूई मट्ठां थियां, तैनी बड्डे मट्ठे कां गेइतां ज़ोवं, “अज़ दाछ़री बागी मां गा ते कम केर।” ");
INSERT INTO bhd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","तैनी जुवाब दित्तो, “अवं न गेईं।” पन बादे मां पशतेइतां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","फिरी बाजे होरि मट्ठे कां भी गेइतां एन्ने ज़ोवं, तैनी जुवाब दित्तो, “अच्छा खरी गाताईं।” पन जेव नन्ना। ");
INSERT INTO bhd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“एन दुइने मरां केनि अपने बाजेरो हुक्म मन्नो?” तैनेईं जुवाब दित्तो बड्डे हुक्म मन्नो, यीशुए तैन सेइं ज़ोवं, कि अवं तुसन सेइं सच़ ज़ोताईं, कि चुंगी घिन्ने बाले ते बदचलन कुआन्शां तुसन करां पेइले परमेशरेरे राज़ मां दाखल भोली। ");
INSERT INTO bhd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","अवं इन ज़ोताईं, यूहन्ना बपतिस्मो देनेबाले तुसन ज़ोवं, कि धार्मिकतारी ज़िन्दगी केन्च़रां ज़ींनीए पन तुसेईं तैसेरू विश्वास न कियो, पन चुंगी घिन्ने बाले ते बदचलन कुआन्शेईं तैसेरू विश्वास कियूं, एन हेरतां भी तुसेईं पापन करां मन न फिराव ते तैस पुड़ विश्वास न कियो। ");
INSERT INTO bhd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","अक होरि मिसाल शुना, एक्की ज़मीनदारे अक दाछ़री बाग लाई ते तैसेरे च़ेव्रे पासन बाड़ दित्तो, ते दाछ़ारो रस कढनेरे लेइ अक हौवज़ बनावं, ते तैस बागरी हेरगेश केरनेरे लेइ अक उच्ची कूड़ी बनाई ते फिरी तै काशत केरनेबालन ठेके पुड़ देइतां कोन्च दूर प्रदेशे जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ज़ैखन दाछ़ ट्लोड़नेरो मौको अव त तैनी अपनो हिस्सो नेनेरे लेइ अपने नौकर तैन ठेकेदारन कां भेज़े। ");
INSERT INTO bhd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ते ठेकेदारेइं तैसेरे नौकर कोई झ़ूसो कुटो कोई मारो ते केन्ची जेई घोड़ेईं दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","फिरी तैनी होरे नौकर भेज़े ज़ैना पेइलन करां जादे थिये, पन ठेकेदारेइं तैन सेइं भी तेरहो ज़ेरो सलूख कियो। ");
INSERT INTO bhd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","आखर्कार तैनी अपनू मट्ठू तैन कां भेज़ू, ते सोचू कि मेरे मट्ठेरो त लिहाज़ केरेले। ");
INSERT INTO bhd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“पन ज़ैखन ठेकेदारेइं तैसेरू मट्ठू लाव, त तैना एप्पू मांमेइं मुशोरो केरने लग्गे, कि एज्जा एस सेवां मारम ते एसेरी बागी पुड़ कब्ज़ो केरम।” ");
INSERT INTO bhd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“तैखन तैनेईं तैन मट्ठू ट्लाव ते बागारे बेइर शेरी छ़ड्डू। ");
INSERT INTO bhd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","एल्हेरेलेइ ज़ैखन बागरो मालिक एप्पू एज्जेलो, त तैन ठेकेदारन सेइं केरो सलूख केरेलो?” ");
INSERT INTO bhd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","तैनेईं जुवाब दित्तो, तै तैन बुरन, बुरे तरीके सेइं मैरतां बागरो ठेको होरि ठेकेदारन देलो, ज़ैना मौके पुड़ तैसेरो हिस्सो तैस देन। ");
INSERT INTO bhd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","यीशुए तैन सेइं ज़ोवं, “तुसेईं पवित्रशास्त्रे मां कधे नईं पढ़ेरू, ज़ै घोड़ मिस्त्रेईं रद्दी कियोरो थियो, तैए कूनेरो घोड़ भोलो, एन कम परमेशरे कियोरूए, ते इश्शी नज़री मां एन आजीब आए?” ");
INSERT INTO bhd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","एल्हेरेलेइ अवं तुसन सेइं ज़ोताईं, कि परमेशरेरू राज़ तुसन करां निव गालू, ते एरी कौमी कां दित्तू गालू ज़ै वक्ते पुड़ तैस फल दे। ");
INSERT INTO bhd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ते ज़ै कोई इस घोड़े पुड़ बिछ़ड़ेलो त तैसेरे टुक्ड़े-टुक्ड़े भोइ गाले, पन ज़ै एस उन्ढो बिछ़ड़ेलो त तैस पइतां छ़डेले। ");
INSERT INTO bhd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","प्रधान याजक ते फरीसी लोकेईं यीशुएरी ए मसाल शुन्तां सेमझ़ी जे, कि यीशु एन गल्लां इश्शे बारे मां ज़ोने लोरोए। ");
INSERT INTO bhd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","तैनेईं यीशु ट्लानो चाव, पन लोकन करां डरते थिये किजोकि तैना यीशु नबी मन्ते थिये। ");
INSERT INTO bhd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","यीशु फिरी मसाल देइतां ज़ोने लगो। ");
INSERT INTO bhd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“स्वर्गेरू राज़ एक्की राज़ेरू ज़ेरूए, ज़ैनी अपने मट्ठेरे ड्ला बनाव। ");
INSERT INTO bhd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ते अपने नौकर भेज़े कि तैना लोकन ज़ैन जेई ड्लाएरी धाम बनोरी थी, तैन कुजान पन तैना न आए। ");
INSERT INTO bhd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","तैखन तैनी अपने नौकर एन ज़ोइतां भेज़े, कि ज़ैन जेई ड्लाएरी धाम बनेवरीए, तैन ज़ोथ, रोट्टी बनोरीए ते मीं बडे-बडे जानवर कट्टोरन, ते सब किछ तियार भोरूए, ते ड्लाएरी धामी मां शामल भोथ। ");
INSERT INTO bhd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","पन तैनेईं ध्यान न दित्तू ते कोई परवाह न की, कोई अपने ऊडारे मां च़लो जेव, ते कोई अपने कारोबारे मां लगो ते कोई कोरां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","किछेईं तैसेरे नौकर ट्लेइतां तैन तैना बेइज़त किये, ते जानां भी मैरी छ़ड्डे। ");
INSERT INTO bhd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ज़ैखन राज़े एन शुनू त राज़े बड़ी सरक आई, ते तैनी अपनि फौज भेज़तां तैना कातली मैरी छ़ड्डे ते तैन केरां नगरां फुके। ");
INSERT INTO bhd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","तैखन तैनी अपने नौकरन सेइं ज़ोवं, ड्लाएरी धाम तियार आए, पन ज़ैन कुजोरे थिये तैन एस काबल नईं। ");
INSERT INTO bhd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","एल्हेरेलेइ तुस हर पासे गाथ ते ज़ेत्रे तुसन मैलतन, तैना सब इरां कुजाथ। ");
INSERT INTO bhd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","तैखन तैना नौकर च़ले जे ते हर पासे गेइतां ज़ेत्रे खरे बुरे तैन मैल्ले, सब अकोट्ठे ड्लाए मां आने ते मेहमानेइं सेइं घर भेरतां भोवं। ");
INSERT INTO bhd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ते राज़ो मेहमान सेइं मिलने अन्तर अव, त तैसेरी नज़र एक्की मैन्हु पुड़ पेई ज़ै ड्लाए मां ड्लेरां लिगड़ां लेइतां न थियो ओरो।” ");
INSERT INTO bhd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","राज़े तैस पुच़्छ़ू, हे दोस्त, तू ड्लाएरे लिगड़न मां की नईं ओरो? पन तैने किछ न ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“एस गल्ली पुड़ राज़े अपने नौकरन सेइं ज़ोवं, ‘एसेरे हथ पाव बेंधतां बेइर आंधरे मां छ़ड्डा ज़ैड़ी ए लेरां देंतो राए, ते दंत च़ापतो राए।’ ");
INSERT INTO bhd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","किजोकि परमेशरे हमेशारे ज़िन्दगरे लेइ त बड़े कुजोरेन पन च़ुनोरे थोड़ेन।” ");
INSERT INTO bhd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","तैखन फरीसी लोक तैट्ठां च़ले जे, ते एप्पू मांमेइं मुशोरो केरने लग्गे एस केन्च़रे गल्लन मां फसाम। ");
INSERT INTO bhd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","एल्हेरेलेइ तैनेईं अपने किछ चेले हेरोदेस राज़ेरे लोकन सेइं साथी यीशु कां भेज़े, ते तैनेईं ज़ोवं, “हे गुरू अस ज़ानतम कि तू सच़्चोस, ते परमेशरेरी बत सच़्च़ैइं सेइं शिखालतस ते कोन्चेरी परवाह न केरस किजोकि तू मैन्हु केरू तुतर हेरतां गल्लां न केरस। ");
INSERT INTO bhd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","एल्हेरेलेइ असन ज़ो, तू कुन सोचतस? महाराज़े जो चुंगी देनी जेइज़े की नईं?” ");
INSERT INTO bhd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","यीशु तैन केरि चाल सेमझ़तां ज़ोवं, “हे पाखंडी लोकव मीं किजो अज़मातथ? ");
INSERT INTO bhd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ज़ै सिको चुंगरे लेइ देतथ तैस मीं हिराथ, तैनेईं अक दीनार तैस कां आनो। ");
INSERT INTO bhd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","यीशुए तैन पुच़्छ़ू, इस पुड़ कसेरी शकल ते कसेरू नवं लिखोरूए?” ");
INSERT INTO bhd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","तैनेईं जुवाब दित्तो महाज़ेरू, तैखन तैनी तैन सेइं ज़ोवं, “ज़ैन महाराज़ेरूए तैन महारज़े जो देथ, ते ज़ैन परमेशरेरू ए तैन परमेशरे जो देथ।” ");
INSERT INTO bhd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","तैना एन शुन्तां हैरान रेइजे, ते तैस तैड़ी छ़ेडतां च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","तैस्से दिहैड़ी किछ सदूकी लोक ज़ैना ज़ोते थिये कि मरनेरां बाद कोई ज़ींतो नईं भोनो, तैनेईं तैस पुच़्छ़ू, ");
INSERT INTO bhd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“हे गुरू मूसे ज़ोरूए कि, ‘अगर कोई मैन्हु बेऔलाद मेरि गाए, त तैसेरो ढ्ला तैसेरी कुआन्शी सेइं ड्ला बनाए ताके अपने ढ्लाएरे लेइ औलाद पैदा केरे।’ ");
INSERT INTO bhd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","इश्शे इड़ी सत ढ्ला थिये, पेइले ड्ला बनेइतां मेरि जेव, तैस औलाद न थी तैनी अपनि कुआन्श अपने ढ्लाएरे लेइ छ़ेड्डी दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ए वजा आए तैसेरे दुइयोवं ते ट्लेइयोवं भी एन्च़रे कियूं बल्के सत्ते ढ्लान सेइं एन्ने भोतू राऊं। ");
INSERT INTO bhd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","आखर्कार तै कुआन्श भी मेरि जेई। ");
INSERT INTO bhd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","हुनी ज़ो तै कुआन्श मुड़दन मरां ज़ींते भोनेरे दिहाड़े तैन सत्ते ढ्लान मरां कसेरी कुआन्श भोली? किजोकि तै सेब्भी केरि कुआन्श बनोरी थी।” ");
INSERT INTO bhd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","यीशुए तैन जुवाब दित्तो, “तुस न पवित्रशास्त्र ते न परमेशरेरी शक्ति ज़ानथ, ते एस्से वजाई सेइं तुस टेपलोरेथ। ");
INSERT INTO bhd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","किजोकि ज़ींते भोनेरां पत्ती तैना ड्ला न बनाले, पन तैना स्वर्गे मां परमेशरेरे स्वर्गदूतां केरे ज़ेरे भोनेन।” ");
INSERT INTO bhd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“पन मुड़दन मरां ज़ींते भोनेरे बारे मां कुन तुसेईं इन वचन नईं पढ़ेरू ज़ैन परमेशर तुसन सेइं ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘अवं अब्राहमेरो परमेशर, ते इसहाकेरो परमेशर ते याकूबेरो परमेशर आई?’ तै मुवोरां केरो नईं बल्के ज़ींतां केरो परमेशरे।” ");
INSERT INTO bhd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","लोक तैसेरी ए शिक्षा शुन्तां हैरान रेइजे। ");
INSERT INTO bhd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ज़ैखन फरीसी लोकेईं एन शुनू कि तैनी सदूकी केरू आशी बंद कियोरूए, त तैना तैस कां सब अकोट्ठे भोए। ");
INSERT INTO bhd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","तैन मरां अक शास्त्री तैस अज़मानेरे लेइ यीशुए पुच़्छ़ू। ");
INSERT INTO bhd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“हे गुरू, मूसेरे कानूने मां सेब्भन करां बड्डो हुक्म कौ आए?” ");
INSERT INTO bhd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","तैनी ज़ोवं, “तू परमेशरे अपने प्रभु सेइं अपने सारे दिले सेइं ते अपनि सैरी जानी सेइं ते अपनि सैरी अक्ली सेइं प्यार केरा। ");
INSERT INTO bhd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","सेब्भन करां बड्डो ते खास हुक्म ईए। ");
INSERT INTO bhd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","एसेरो ज़ेरो ईए, ‘अपने पड़ोसी सेइं अपने बराबर प्यार केर।’ ");
INSERT INTO bhd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","इन्ना दूई हुक्म मूसेरे कानून ते नेबी केरो आधारे।” ");
INSERT INTO bhd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ज़ैखन फरीसी लोक भी तैड़ी जम्हां भोइजेइ, त यीशुए तैन पुच़्छ़ू। ");
INSERT INTO bhd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“मसीहेरे बारे मां तुश्शो कुन खियाले, कि तैन केसेरू मट्ठूए?” तैनेईं जुवाब दित्तो, “दाऊदेरू मट्ठू।” ");
INSERT INTO bhd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","यीशुए तैन सेइं ज़ोवं, “फिरी दाऊद आत्माई मां तैस जो प्रभु किजो ज़ोते?” ");
INSERT INTO bhd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“प्रभुए मेरे प्रभु सेइं ज़ोवं, मेरे देइने पासे बिश ज़ां तगर अवं तेरे दुश्मन तेरे पावन हैठ न ढ्लेन्च़ेईं। ");
INSERT INTO bhd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","बस्सा, अगर दाऊद तैस जो प्रभु ज़ोते त तैन तैसेरू मट्ठू केन्च़रे सेइं भोइ सकते?” ");
INSERT INTO bhd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","तैन मरां केन्चे भी एक्की गल्लरो जुवाब न देइ बटो। पन तैस वक्तेरे बाद फिरी कोन्ची तैस पुच़्छ़नेरी हिम्मत न भोइ। ");
INSERT INTO bhd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","तैखन यीशुए बड़े लोकन सेइं ते अपने चेलन सेइं एन ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“शास्त्री ते फरीसी लोक मूसेरो कानून समझ़ाने बालेन। ");
INSERT INTO bhd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","एल्हेरेलेइ ज़ैन किछ तैना तुसन ज़ोतन तैन तुस केरा ते मेन्ना, पन तैन केरां ज़ेरां कम्मां न केरा, किजोकि तैना ज़ोने त ज़ोतन पन केरन नन्ना। ");
INSERT INTO bhd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","तैना अपने मेर्ज़ी सेइं कानून बनातन ज़ैना लोकां केरे लेइ मन्ने मुशकिल भोतन, पन एप्पू अपने कानूने मन्नेरी कोशिश भी न केरन। ");
INSERT INTO bhd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","तैना ज़ैन किछ केरतन सिर्फ मैनन् हिरानेरे लेइ केरतन, तैना अपने कुपाए ते पैखड़न पुड़ पवित्रशास्त्रेरे वचन लिखतां बड्डे-बड्डे जन्त्रां केरे ज़ेरे बन्धतन, ते अपने चोगन पुड़ लम्मो गुच्छा लातन (ताके लोक समझ़न तैना बड़े धर्मी आन)। ");
INSERT INTO bhd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","तैना धामन मां खास ठैरी बिशनू चातन, ते प्रार्थना घरे मां खास कुर्सन पुड़ बिशनू चातन। ");
INSERT INTO bhd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ते तैना चातन कि लोक तैनन् जो बज़ारन मां नमस्कार ज़ोन, ते तैनन् जो गुरू ज़ोन। ");
INSERT INTO bhd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","पन तुस अपने आपे जो गुरू न ज़ुवेइयथ, किजोकि तुश्शो अक्के गुरू आए, ते तुस सब ढ्लां केरे ज़ेरे बराबर आथ। ");
INSERT INTO bhd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ते दुनियाई मां केन्ची जो (आत्मिक) बाजी न ज़ोइयथ, किजोकि तुश्शो अक्के बाजी आए ज़ै स्वर्गे मां आए। ");
INSERT INTO bhd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ते न केन्ची जो मालिक ज़ोइयथ किजोकि तुश्शो अक्के मालिके ज़ै मसीह आए। ");
INSERT INTO bhd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","पन ज़ै तुसन मां बड्डो भोनू चाते, त तै तुश्शो सेवक बने। ");
INSERT INTO bhd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ते ज़ै कोई अपनो आप बड्डो बनानेरी कोशिश केरते, त तै निकड़ो बनाव गालो, ते ज़ै कोई अपनो आप निकड़ो बनाते त तै बड्डो बनाव गालो।” ");
INSERT INTO bhd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","तैखन यीशुए ज़ोवं, “हे पाखंडी शास्त्री ते फरीसी लोकव, तुसन पुड़ अफ़सोस, किजोकि तुस स्वर्गेरे राज़्ज़े मां लोकन दाखल भोने न देथ, किजोकि न तुस एप्पू दाखल भोथ, ते न होरन दाखल भोने देथ। ");
INSERT INTO bhd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","हे पाखंडी शास्त्री ते फरीसी लोकव तुसन पुड़ अफ़सोस, तुस विधवा कुआन्शां केरे घरन लुटतथ, ते लोकन हिरानेरे लेइ लेम्मी-लेम्मी प्रार्थना केरतथ, तुसन जादे सज़ा मैलेली।” ");
INSERT INTO bhd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“हे पाखंडी शास्त्री ते फरीसी लोकव, तुसन पुड़ अफ़सोस! तुस अक मैन्हु अपने धर्मे मां आन्नेरे लेइ बड़े दूर-दूर गातथ, ते ज़ैखन तै तुश्शी शिक्षा मन्ते त तैस एप्पू करां दुगनो नरके मां गानेरे काबल बनातथ।” ");
INSERT INTO bhd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“हे बत हिराने बाले कानाव, तुसन पुड़ अफ़सोस, कि तुस ज़ोतथ कि अगर कोई मन्दरेरी कसम केरे त कोई हर्ज़ नईं, पन अगर मन्दरेरे सोन्नेरी कसम केरे, त तैसेरी कसमारो पाबंद भोलो। ");
INSERT INTO bhd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","हे बेवकूफ ते कानाव, बड्डू कुन आए सोन्नू या मन्दर, ज़ेसेरी वजाई सेइं सोन्नू पवित्र समझ़ू गाते?” ");
INSERT INTO bhd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“तुस ज़ोतथ कि अगर कोई बलिदान च़ाढ़नेरे ठारारी कसम केरे, त कोई हर्ज़ नईं, पन च़ैढ़ोरी चीज़री कसम केरे त तैसेरो पाबंद भोलो। ");
INSERT INTO bhd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","हे कानाव! बड्डू कुन आए, च़ाढ़ोरी चीज़ या बलिदान च़ाढ़नेरे ठार ज़ेसेरी वजाई सेइं च़ाढ़ोरी चीज़ पवित्र समझ़ी गाचे? ");
INSERT INTO bhd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","अगर ज़ै कोई बलिदान च़ाढ़नेरे ठारारी कसम केरते, त तै सेब्भी च़ैढ़ोरी चीज़ां केरि कसम केरते। ");
INSERT INTO bhd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ज़ै कोई मन्दरेरी कसम केरते त तै मन्दरे मां रानेबाले परमेशरेरी कसम केरते। ");
INSERT INTO bhd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ते ज़ै कोई स्वर्गेरी कसम केरते, तै परमेशरेरे तखतेरी ते तैस पुड़ बिशने बालेरी कसम केरते।” ");
INSERT INTO bhd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“हे पाखंडी शास्त्री ते फरीसी लोकव, तुसन पुड़ अफ़सोस, तुस पुतनेरो ते सोंफ़ेरो ते ज़ीरेरो दशोवं हिस्सो त देतथ, पन मूसेरे कानूनेरी खास गल्लां ज़ेन्च़रे इन्साफ केरनो, दया केरनि ते ईमानदार भोनू शारोरूए, ज़रूरी थियूं तुस एन भी केरते राथे ते तैन भी न शारेथे। ");
INSERT INTO bhd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","हे बत हिराने बाले कानाव! तुस मश्शे त छ़ानतथ पन सथ्थो ऊँट निगलतथ।” ");
INSERT INTO bhd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“हे पाखंडी शास्त्री ते फरीसी लोकव, तुसन पुड़ अफ़सोस, तुस कटोरो ते कने थाली बेइरमेईं खूब मांज़तथ पन अन्त्रमेईं लालच़ ते बे सबरीए भेरतांए।” ");
INSERT INTO bhd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“हे काने फरीसाव पेइले कटोरो ते थाली अन्त्रमेईं मांज़ा, ते फिरी बेइरमेईं भी साफ भोए।” ");
INSERT INTO bhd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“हे पाखंडी शास्त्री ते फरीसी लोकव तुसन पुड़ अफ़सोस, तुस तैन कब्रां केरे ज़ेरेथ ज़ैन बेइरमेईं त सफैदीए ते बेड़ि रोड़ी लेहीयोचन, पन अन्त्रमेईं मुड़दां केरि हड्डी ते सब किसमेरी गेन्दगी सेइं भेरतन। ");
INSERT INTO bhd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","एन्च़रे तुस बेइरमेईं लोकन बड़े धर्मी लेइयोतथ, पन अन्त्रमेईं दुनियारे पाखंडे ते अधर्मे सेइं भेरतथ।” ");
INSERT INTO bhd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“हे पाखंडी शास्त्री ते फरीसी लोकव तुसन पुड़ अफ़सोस, किजोकि तुस नेबी केरे आसथान सजातथ ते धेर्मी लोकां केरि कब्रां बनातथ। ");
INSERT INTO bhd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ते ज़ोतथ कि, ‘अगर अस अपने दादे-पड़दादां केरे ज़माने मां भोथे त नेबन मारने मां तैन केरू साथ न देथे।’ ");
INSERT INTO bhd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","एन्च़रे तुस एप्पू मन्तथ कि तुस नेबी केरे कत्ल केरनेबालां केरि औलादी मरां आथ। ");
INSERT INTO bhd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","हुनी तुस अपने दादे-पड़दादां केरे पापेरे घड़ो भरते राथ।” ");
INSERT INTO bhd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“हे ज़हरीले सप्पां केरे ज़ेरे बच्चाव! तुस नरकेरी सज़ाई करां केन्च़रे बच़ेले? ");
INSERT INTO bhd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","एल्हेरेलेइ हेरा अवं नेबन ते अक्लमन्दन ते शास्त्री लोकन तुसन कां भेज़ताईं, तुस तैन मरां किछन कत्ल केरेले, ते किछन क्रूसे पुड़ च़ाढ़ेले, ते किछन अपने प्रार्थना घरे मां कोड़ेइं सेइं बाले, ते नगरे-नगरे मां तैन मारनेरे लेइ तैन पत्ती लग्गोरे राले। ");
INSERT INTO bhd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","एल्हेरेलेइ सारे धेर्मी केरो कत्ल ज़ै इस धेरती पुड़ भोरोए, तैन केरि सज़ा तुसन पुड़ एज्जे, धर्मी हाबिलेरे कत्ले करां लेइतां, ते बिरिक्याहरे मट्ठे जकर्याहरे कत्ले तगर ज़ै तुसेईं मन्दरेरे ते बलिदान केरनेरे ठारारे मझ़ाटे मन्दरेरे अंगने मां कत्ल कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","अवं तुसन सेइं सच़ ज़ोताईं कि इस ज़मानेरे लोकन एना सैरी गल्लां केरे सज़ा मैलनी।” ");
INSERT INTO bhd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","फिरी यीशुए ज़ोवं, “हे यरूशलेम नगरेरे लोकव, हे यरूशलेम नगरेरे लोकव, तुसेईं केत्रे नबी कत्ल किये ज़ैना बड़े पेइले तुसन कां आए, ते ज़ैना तुसन कां भेज़े तुसेईं तैन घोड़ेईं बेई, मीं बड़े बार सोचू कि तेरे बच्चन अकोट्ठे केरि ज़ेन्च़रे कुकड़ी अपने बच्चन अपने फंगन हैठ रखचे पन तुस राज़ी न भोए। ");
INSERT INTO bhd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","हेरा तुश्शू घर तुश्शे लेइ बेरान भोइ गाते। ");
INSERT INTO bhd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","किजोकि अवं तुसन सेइं सच़ ज़ोताईं, कि तुस मीं हुन्ना करां तैस दिहाड़े तगर कधे न लेई सकेले, ज़ांतगर मेरे बारे मां इन न ज़ोले, ‘तैसेरी तारीफ़ भोए ज़ै प्रभुएरे अधिकारे सेइं एइते।’” ");
INSERT INTO bhd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ज़ैखन यीशु मन्दरे मरां निस्तां च़लोरो थियो, ते तैसेरे चेले तैस कां आए, ताके तैस मन्दरेरे रोड़े-रोड़े भवन हिरान। ");
INSERT INTO bhd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","तैनी तैन सेइं ज़ोवं, “कुन तुस एन सब किछ हेरने लोरेथ? अवं तुसन सेइं सच़ ज़ोताईं कि इड़ी कोई घोड़े पुड़ घोड़ बाकी न रालो, ज़ै बछ़ोड़ो न गालो।” ");
INSERT INTO bhd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ज़ैखन तै ज़ैतून पहाड़े पुड़ बिशोरो थियो, त तैसेरे चेले अलग ज़ेरे तैस कां एइतां तैस सेइं ज़ोने लग्गे, “असन ज़ो कि एन गल्लां केइस भोनिन? ते तेरे एजनेरो ते दुनियारो अन्त भोनेरो कुन निशान भोनोए?” ");
INSERT INTO bhd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","यीशुए तैन जुवाब दित्तो, “खबरदार राथ, कोई तुसन न टपलाए! ");
INSERT INTO bhd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","किजोकि बड़े मेरे नंव्वे सेइं एजनेन ते तैनेईं ज़ोनूए कि, ‘अवं मसीह आईं,’ ते तैनेईं बड़े लोक टपलानेन। ");
INSERT INTO bhd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","तुस लड़ाई ते लड़ैई केरि अफवाह शुनेले, खबरदार डेरथ नन्ना, किजोकि एन गल्लां ज़रूरी भोनिन, पन तैस वक्ते खातमों नईं भोनो। ");
INSERT INTO bhd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","किजोकि कौमी पुड़ कौम, ते राज़्ज़े पुड़ राज़ चढ़हाई केरेलू, ते ठारी-ठारी काल पेलो, ते भुंज़ल एज्जेले। ");
INSERT INTO bhd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","मुसीबतां केरि शुरुआत भी एन्ने गल्लेईं सेइं भोनीए। ");
INSERT INTO bhd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","तैखन ज़ैना तुश्शे खलाफन तैना तुसन ट्लेइतां बड़ी सखत सज़ा देले, ते कत्ल केरेले, ते मीं पुड़ विश्वास केरनेरे वजाई सेइं, सैरी कौमां केरे लोक तुसन सेइं बैर रखेले। ");
INSERT INTO bhd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","तैखन बड़े लोक मीं पुड़ विश्वास केरनो शारेले, एक्की होरि ट्लुवाले, ते एप्पू मांमेइं भी बैर रखेले। ");
INSERT INTO bhd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ते बड़े झूठे नबी दुनियाई मां निसनेन ते बड़े लोक टपलानेन। ");
INSERT INTO bhd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","अधर्म बधने सेइं बड़े लोक एप्पू मांमेइं प्यार केरनो शारेले। ");
INSERT INTO bhd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","पन ज़ै कोई आखरी दम्में तगर मीं पुड़ विश्वास केरेलो, त तैस्से मुक्ति मैलनीए। ");
INSERT INTO bhd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ते परमेशरेरे राज़्ज़ेरी ई खुशखबरी दुनियारे हर पासे शुनाई गाली, ताके सैरी कौमां केरे लोकन मौको मैले कि तैना इस कबूल केरन, तैखन दुनियारो खातमों भोलो।” ");
INSERT INTO bhd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ज़ैखन तुस तैस उज़ड़ाने बाली भिट्टी चीज़ी, ज़ेसेरे बारे मां दानिय्येल नेबे ज़ोरू थियूं, पवित्र ठैरी खड़ी लाएले, (त पढ़नेबालो भी समझ़े)। ");
INSERT INTO bhd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","कि ज़ैना तैस मौके यहूदिया इलाके मां भोले तैना पहाड़न पुड़ जो नश्शन। ");
INSERT INTO bhd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ते ज़ैना लाए पुड़ भोन त तैना कोई चीज़ नेने अन्तर न एजन। ");
INSERT INTO bhd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ते ज़ै मैन्हु ऊडारे मां भोलो, त तै लिगड़ां नेने अन्तर न एज्जे।” ");
INSERT INTO bhd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","तैन दिहाड़न मां ज़ैना दोज़ींती त दुद्ध पियाती कुआन्श भोली, तैन केरे लेइ अफ़सोस! ");
INSERT INTO bhd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“ते प्रार्थना केरा कि तुसन हिंवतड़े या आरामेरी दिहाड़ी नश्शनू न पे। ");
INSERT INTO bhd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","किजोकि तेइस एत्री बड्डी मुसीबत भोली, ज़ेरि दुनियारे शुरू करां अज़ तगर नईं ओरी, ते न कधी एज्जेली। ");
INSERT INTO bhd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","अगर तैन दिहाड़ां केरि तैधात घटेवरी न भोथी, त कोई प्राणी न थियो बच़ानो, पन च़ुनोरां केरे लेइ तैना दिहाड़े घटेवरेन। ");
INSERT INTO bhd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","अगर कोई तुसन सेइं ज़ोए कि, ‘तक्का, मसीह इड़ी आए! या उड़ी आए!’ त तुस विश्वास न केरथ।” ");
INSERT INTO bhd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","“किजोकि झूठे मसीह ते झूठे नबी दुनियाई मां निसनेन, ते तैनेईं निशान ते बड्डे-बड्डे चमत्कार हिरानेन, ते भोइसखे त च़ुनोरे लोक भी टेपलोनेन। ");
INSERT INTO bhd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","हेरा, मीं तुसन सैरी गल्लां भोनेरे पेइले ज़ोरिन। ");
INSERT INTO bhd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","अगर कोई तुसन सेइं ज़ोए कि, ‘हेरा तै जंगले मांए,’ त तुस बेइर न गेइयथ; ‘हेरा, तै घरे मांए,’ त तुस विश्वास न केरथ।” ");
INSERT INTO bhd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","“किजोकि ज़ेन्च़रे बिजली पूर्बेरां, पछमें तगर चमकतीए एन्च़रे मैनेरू मट्ठू भी एज्जेलू।” ");
INSERT INTO bhd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“ज़ैड़ी ज़िग्ग भोते तैड़ी इल्लां जम्हां भोइचन।” ");
INSERT INTO bhd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“तैन दिहाड़ना बाद दिहाड़ो कालो भोइ गालो, त चाँदनी लौ न देली, त कने अम्बरेरां तारे बिछ़ड़ने लग्गेले, त अम्बरेरी सैरी शेक्ति हिलेइ गेली। ");
INSERT INTO bhd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","तैखन मैनेरे मट्ठेरो निशान अम्बरे मां लेइहोनोए, ते दुनियारी सैरी कौमां छाती पिट्टेली, ते मैनेरू मट्ठू अम्बरे मरां बिदलारी पुड़ बेड़ि शेक्ति ते महिमा सेइं एइते लाएले। ");
INSERT INTO bhd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ते तै अपने स्वर्गदूत ते नड़शिंगेरी बड़ी आवाज़ी सेइं साथी भेज़ेलो, ते तैसेरे च़ुनोरे लोकन च़ेव्रे पासन अम्बरेरे एक्की पासेरां होरि पासे तगर सेब्भन जम्हां केरेले।” ");
INSERT INTO bhd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“फ़ेगेरे बुटे करां ई सबक शिखा, ज़ेरे तैसेरे डाल नर्म भोतन ते पट्लां निसतन त तुस बुझ़तथ कि गेर्मेरो मौसम एजनेबालो आए। ");
INSERT INTO bhd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","एसेरो ज़ेरो, ज़ैखन तुस एना गल्लां, ज़ैना मीं ज़ोई, भोते हेरेले, त तुस बुज़्झ़ी छ़ड्डा कि मैनेरू मट्ठू, यानी अवं बड़े नेड़े पुज़्ज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","अवं तुसन सेइं सच़ ज़ोताईं, कि ज़ां तगर एन सब किछ पूरू न भोए, तांतगर एस पीड़रो खातमों न भोलो। ");
INSERT INTO bhd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","अम्बर ते धरती टेली गाली पन मेरी गल्लां कधे न टेलेली।” ");
INSERT INTO bhd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“मेरे वापस एजनेरे दिहाड़ेरे बारे मां, या तैस वक्तेरे बारे मां कोई भी न ज़ाने कि तै कताली भोलो, स्वर्गेरे स्वर्गदूते भी न ज़ानन् त कने परमेशरेरू मट्ठू यानी अवं भी न ज़ैनी, पन सिर्फ मेरो बाजी परमेशर ज़ानते। ");
INSERT INTO bhd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ज़ेन्च़रे नूहेरे ज़माने मां भोरू थियूं, तेन्च़रे मैनेरे मट्ठेरे एजनेरे वक्ते भोनूए। ");
INSERT INTO bhd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","किजोकि तूफान एजने करां पेइले भी लोक खाते पीते थिये, ते ड्ला भी बनाते थिये, ते नूहेरे किश्ती मां गाने तगर एन सब किछ भोतू राऊं। ");
INSERT INTO bhd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","तैन पतो भी न थियो कि कुन भोने बालूए, इड़ी तगर कि तूफान अव ते तैनी सब किछ रुड़ेइतां नेव, ते मैनेरे मट्ठेरू यानी मेरू एजनू भी एरू भोनूए। ");
INSERT INTO bhd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","तैखन ऊडारे मां दूई मैन्हु कम केरते भोले ते अक नीयो गालो, ते दुइयोवं तैड़ी रालो। ");
INSERT INTO bhd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ते दूई कुआन्शां ढ्लाट पिती भोली त अक नी गाली ते होरि तैड़ी राली। ");
INSERT INTO bhd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","तुस बींझ़े राथ किजोकि तुस न ज़ानथ कि तुश्शो प्रभु केइस एजनोए। ");
INSERT INTO bhd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","पन याद रखा, अगर घरेरे मालिके पतो भोए कि च़ोर कताली एजनो, त तै बींझ़े बिशेथो ते अपने घरे च़ोरी न भोने देथो। ");
INSERT INTO bhd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","एल्हेरेलेइ तुस भी तियार राथ, किजोकि ज़ैखन तुसन शक भी नईं भोनी त मैनेरू मट्ठू यानी अवं एज्जी गानोईं।” ");
INSERT INTO bhd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ईमानदार ते अक्लमन्द नौकर तैसेरो ज़ेरोए, ज़ेसेरो मालिक तैस अपने नौकरन पुड़ पुछ़नो गन्ने रखे ताके तै तैन मौके पुड़ रोट्टी दे, ते फिरी दूर सफरे पुड़ गाए।” ");
INSERT INTO bhd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","“तै नौकर धने ज़ेसेरो मालिक एइतां तैस करां एरू ज़ेरू केरतो लाए।” ");
INSERT INTO bhd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","अवं तुसन सेइं सच़ ज़ोताईं कि तै मालिक अपने घरेरो सारो अधिकार तैसेरे सुपुर्द केरेलो। ");
INSERT INTO bhd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“पन अगर तै बुरो नौकर अपने दिले मां एन ज़ोए कि मेरे मालिकेरे एजने हेजू बड़ू च़िरे। ");
INSERT INTO bhd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ते अपने सैथन मारने कुटने ते शरैपण सेइं खाए ते पीए। ");
INSERT INTO bhd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","त तैसेरो मालिक कोस्कोई एरी दिहैड़ी एज्जे ज़ेइस तैस नौकरे उमीदे न भोए, ते तैसेरो मालिक वापस एज्जी गाए। ");
INSERT INTO bhd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ते मालिक तैस पक्की सज़ा देलो, ते तैसेरो हिस्सो पाखंडी लोकन सेइं साथी भोलो, ज़ैड़ी लेरां देनी ते दंत च़ापने भोले।” ");
INSERT INTO bhd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","तैखन यीशुए अपने चेलन सेइं ज़ोवं, ज़ैखन मैनेरू मट्ठू यानी अवं वापस एज्जेलो तैस मौके स्वर्गेरू राज़ तैन दश अड्लैई कुइयां केरू ज़ेरू भोलू, ज़ैना अपनि मिसालां बैलतां लाड़े सेइं मिलनेरे लेइ निस्सी। ");
INSERT INTO bhd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","तैन मां पंच़ बेवकूफ थी, पन पंच़ अक्लमन्द थी। ");
INSERT INTO bhd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ज़ैना बेवकूफ थी तैनेईं मिसालां त नी, पन होरो तेल साथी न नीयो। ");
INSERT INTO bhd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","“पन ज़ैना अक्लमन्द थी तैनेईं मिसालां केरे अलावा कुप्पन मां होरो तेल भी साथी नीयो।” ");
INSERT INTO bhd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","लाड़ो एजने च़िर लग्गू, ते तैना सब बलगते-बलगते डिगरी लेइ देने, ते झ़ुल्ली जेई। ");
INSERT INTO bhd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“अध्धी रात भोइ त शौर मच़ी कि लाड़ो ओरोए, ते तैस सेइं मिलनेरे लेइ एज्जा। ");
INSERT INTO bhd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","तैखन सैरी अड्लैई कुइयां बींझ़ी, ते अपनि-अपनि मिसालां ठीक केरने लेगि। ");
INSERT INTO bhd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","बेवकूफ कुइयेईं अक्लमन्द अड्लैई कुइयन सेइं ज़ोवं, ‘अपने तेले मरां थोड़ो ज़ेरो तेल असन भी देथ, किजोकि इश्शी मिसालां हिश्शने लोरिन।’ ");
INSERT INTO bhd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","पन अक्लमन्देईं जुवाब दित्तो, ‘असन कां एत्रो तेल नईं, कि इश्शे लेइ ते तुश्शे लेइ पूरो भोए, तुस एरू केरा कि बेच़नेबालन करां आनां।’ ");
INSERT INTO bhd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ज़ैखन तैना तेल घिन्ने च़ेलोरि थी त तैत्रे मां लाड़ो पुज़ी जेव, ते ज़ैना तियार थी, तैना लाड़े सेइं साथी अन्तर ड्लाएरे घरे मां च़ेलि जेई, ते दार बंद केरतां छ़डू। ");
INSERT INTO bhd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","बादे मां तैना होरि अड्लैई कुइयां भी वापस पुज़ी ते लाड़े जो ज़ोने लेगि, ‘प्रभु! प्रभु!’ इश्शे लेइ दार खोल्ल। ");
INSERT INTO bhd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","पन तैनी जुवाब दित्तो, ‘अवं तुसन सेइं सच़ ज़ोताईं, अवं तुसन न ज़ैंनी।’ ");
INSERT INTO bhd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","एल्हेरेलेइ खबरदार राथ, किजोकि तुस मेरे वापस एजनेरे दिहाड़ेरे बारे मां न ज़ानथ।” ");
INSERT INTO bhd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ज़ैखन मैनेरू मट्ठू यानी अवं वापस एज्जेलो त स्वर्गेरू राज़ तैस मैनेरो ज़ेरू भोनूए, ज़ै दूर मुलखे जेव, तैनी अपने नौकर कुजाए ते सारी दौलत तैन दित्ती, ते तैन ज़ोवं एस दौलती सेइं होरि भी कमाई केरा। ");
INSERT INTO bhd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","“तैनी एक्की पंच़ तोड़े दित्ते होरि दूई तोड़े दित्ते, ते एक्की अक्के तोड़ो दित्तो, हर एक्की तैसेरे काबलीतरे मुताबिक दित्ते, ते एप्पू होरि मुलखे जो च़लो जेव।” ");
INSERT INTO bhd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ज़ैस नौकरे पंच़ तोड़े मैलोरे थिये, तैनी गेइतां कारोबार केरतां पंच़ तोड़े होरे कमाए। ");
INSERT INTO bhd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","एन्च़रे ज़ैस नौकरे दूई तोड़े मैल्लोरे, तैनी दूई होरे कमाए। ");
INSERT INTO bhd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","पन ज़ैस नौकरे अक तोड़ो मैल्लेरो थियो, तैनी मित्ती घेड़तां मालिकेरी रकम छ़पेइतां छ़डी। ");
INSERT INTO bhd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","बड़े च़िरेरां पत्ती तैसेरो मालिक वापस अव, ते नौकरन सेइं हिसाब केरने लगो कि तैनेईं तैन तोड़ां केरू कुन कियूं। ");
INSERT INTO bhd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“ज़ैस नौकरे पंच़ तोड़े मैल्लोरे थिये, तैनी गेइतां पंच़ होरे तोड़े हाज़र कमाए ते ज़ोने लगो, ‘हे मालिक तीं पंच़ तोड़े दित्तोरे, ते हेर मीं पंच़ तोड़े होरे कमाए।’ ");
INSERT INTO bhd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","मालिके तैस सेइं ज़ोवं, ‘शाबाश ईमानदार नौकरा तीं थोड़ी ज़ेरि रकमी पुड़ इमानदेरी सेइं कम कमाव, अवं तीं बेड़ि चीज़ां केरो मुख्तियार बनालो, ते अपने मालिकेरी खुशी मां शामिल भो।’” ");
INSERT INTO bhd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ते ज़ैस दूई तोड़े मैल्लोरे थिये, तै भी अव ते ज़ोने लगो, “हे मालिक तीं मीं दूई तोड़े दित्तोरे थिये, ते हेर मीं दूई तोड़े होरे कमाए।” ");
INSERT INTO bhd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","मालिके तैस सेइं ज़ोवं, “शाबाश ईमानदार नौकरा तीं थोड़ी ज़ेरि रकमी पुड़ इमानदेरी सेइं कम कमाव, अवं तीं बेड़ि चीज़ां केरो मुख्तियार बनालो, ते अपने मालिकेरी खुशी मां शामिल भो।” ");
INSERT INTO bhd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ते ज़ैस अक तोड़ो मैल्लेरो थियो, त तै भी हाज़र भोव ते ज़ोने लगो, “हे मालिक अवं ज़ानतो थियो तू बड़ो सखत मैन्हु आस, तू तैस मैनेरो ज़ेरोस ज़ैनी ऊडारे मां फसल नईं बेवरी ते तै तैट्ठां फसल कटते।” ");
INSERT INTO bhd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","एल्हेरेलेइ अवं डरो कि अगर अवं तेरी दौलत हिरेइलो त तू मीं सज़ा देलो, तांए तेरी दौलत मीं ज़मीनी मां देबतां छ़डी, हेर, “तेरी दौलत ई आए।” ");
INSERT INTO bhd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","तैसेरे मालिके जुवाब दित्तो, हे दुष्ट ते निकम्मे नौकरा अगर तीं पतो थियो, कि अवं तैस मैनेरो ज़ेरोईं ज़ैनी ज़ैस ऊडारे मां नईं बेवरू त तैट्ठां कटते। ");
INSERT INTO bhd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","त तीं एन लोड़तू थियूं कियोरू, कि मेरी दौलत शौकारां केरे हवाले केरस, तैखन अवं वापस एइतां अपनि दौलत सूते समेत उसुल केरेथो। ");
INSERT INTO bhd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","हुनी एन केरा कि एस करां तै तोड़ो नेइतां तैस देथ ज़ैस कां दश तोड़ेन। ");
INSERT INTO bhd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","एल्हेरेलेइ ज़ैस कां परमेशरेरी मर्ज़ी समझ़नेरी इच्छा आए, तैस परमेशर जादे समझ़ देलो। पन ज़ैस कां परमेशरेरी मर्ज़ी समझ़नेरी इच्छा नईं, तैस केरां, थोड़ी ज़ेरि समझ़ ज़ै तैस कां आए, तै भी नी गाली। ");
INSERT INTO bhd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ते एस निकम्मे नौकरे आंधरे मां छ़ड्डा, ज़ैड़ी ए लेरां देंतो ते दंत च़ापतो राए। ");
INSERT INTO bhd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ज़ैखन मैनेरू मट्ठू यानी अवं, अपने महिमा मां अपने स्वर्गदूतन सेइं साथी एज्जेलो त अपने महिमारे तखते पुड़ बिश्तां लोकन पुड़ राज़ केरेलो। ");
INSERT INTO bhd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","सैरी कौमां मीं कां अकोट्ठी भोली, ते धर्मी लोक बुरे लोकन करां अलग किये गानेन, ज़ेन्च़रे पुहाल भैड्डन, छ़ेल्लन मरां अलग केरते। ");
INSERT INTO bhd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ते अवं धर्मी लोकन सेइं ज़ैना मेरे देइने पासे भोले, ते बुरे लोकन ज़ैना मेरे बांए पासे भोले। ");
INSERT INTO bhd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","तैखन राज़ो यानी अवं अपने देइने पासेरे लोकन सेइं ज़ोलो, “एज्जा मेरे बाजेरे धन लोकव इन राज़, ज़ैन दुनियारे शुरू मां तुश्शे लेइ तियार कियोरूए। ");
INSERT INTO bhd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","किजोकि अवं नियन्नो थियो, ते तुसेईं मीं रोट्टी खुवाई, अवं ट्लिशोरो थियो, ते तुसेईं मीं पानी पियांव अवं परदेशी थियो, ते तुसेईं अवं अपने घरे मां कुजाव। ");
INSERT INTO bhd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","अवं नग्गो थियो, ते तुसेईं मीं लिगड़ां दित्तां, ते अवं बिमार थियो, ते तुसेईं मेरी हेरगेश की अवं कैद थियो, ते तुस मीं मिलने आए।” ");
INSERT INTO bhd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","तैखन तैना धर्मी मैनन् ज़ोलो, “हे प्रभु असेईं कैखन तू नियन्नो लाव, ते असेईं तीं रोट्टी खुवाई या तू ट्लिशोरो थियो, ते असेईं तीं पानी पियांव।” ");
INSERT INTO bhd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","असेईं कैखन परदेशी सेमझ़तां तू अपने घरे मां रख्खो, या तू नग्गो थियो, ते असेईं तीं लिगड़ां दित्तां? ");
INSERT INTO bhd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ते अस कताली तीं बिमार या कैद लेइतां तीं सेइं मिलने आए? ");
INSERT INTO bhd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","तैखन राज़ो यानी अवं जुवाब देलो, “कि अवं तुसन सेइं सच़ ज़ोताईं कि ज़ैखन तुसेईं इन लोकन सेइं ज़ैनेईं मीं पुड़ विश्वास कियो एक्की सेइं भी एरो बर्ताव कियो त एन बुझ़ा कि एन तुसेईं मीं सेइं कियूं।” ");
INSERT INTO bhd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","तैखन तै बांए पासे बालन सेइं ज़ोलो, “हे लानती लोकव मेरे तुत्तरे अगरां तैस हमेशारी बैलती अग्गी मांजो गाथ, ज़ै परमेशरे, शैतान त कने शैतानेरे दूतां केरे लेइ तियार कियोरीए। ");
INSERT INTO bhd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","एल्हेरेलेइ ज़ैखन अवं नियन्नो थियो, ते तुसेईं मीं रोट्टी न खुवाई अवं ट्लिशोरो थियो, ते तुसेईं मीं पानी न पियांव। ");
INSERT INTO bhd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","अवं परदेशी थियो, ते तुसेईं अवं अपने घरे मां न रख्खो, अवं नग्गो थियो, ते तुसेईं मीं लिगड़ां न दित्तां, ते अवं बिमार ते कैद थियो, ते तुस मीं सेइं मिलने न आए।” ");
INSERT INTO bhd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","तैखन तैना लोक भी ज़ोले, “हे प्रभु असेईं कताली तू नियन्नो या ते ट्लिशोरो या परदेशी ते नग्गो या बिमार या कैद लाव ते असेईं तेरी सेवा न की?” ");
INSERT INTO bhd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","तैखन अवं अपने बाएं पासेरे लोकन जुवाब देलो, “अवं तुसन सेइं सच़ ज़ोताईं कि ज़ैखन तुसेईं मेरे इन निकड़े करां निकड़े लोकन पुड़ ज़ैना मीं पुड़ विश्वास केरतन एक्की सेइं भी एरो ज़ेरो बर्ताव कियो त एन बुझ़ा कि एन मीएं सेइं कियूं। ");
INSERT INTO bhd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","एल्हेरेलेइ एन लोकन हमेशारे लेइ सज़ा भोली, पन धर्मी लोकन हमेशारी ज़िन्दगी मैलेली।” ");
INSERT INTO bhd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ज़ैखन यीशुए एन गल्लां की, त तै अपने चेलन सेइं ज़ोने लगो। ");
INSERT INTO bhd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“तुसन पत्तोए कि दूई दिहैड़ना बाद फ़सह तिहारे, ते मैनेरू मट्ठू क्रूसे पुड़ च़ाढ़नेरे लेइ ट्लुवाव गाए।” ");
INSERT INTO bhd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","तैखन प्रधान याजक ते कौमरे बुज़ुर्ग कैफा महायाजकेरे अंगने मां अकोट्ठे भोए। ");
INSERT INTO bhd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ते तैनेईं सल्लाह की, कि यीशु धोखे सेइं ट्लेइतां मैरी छ़डम। ");
INSERT INTO bhd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","पन तैना ज़ोते थी, कि फ़सह तिहारेरे मौके पुड़ नईं, एरू न भोए कि लोक हंगामो केरन। ");
INSERT INTO bhd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","तैस मौके यीशु बैतनिय्याह ड्लव्वें मां शमौन कोढ़ेरो घरे मां थियो। ");
INSERT INTO bhd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ते अक कुआन्श शंखमरमरी भांडे मां इत्र घिन्तां यीशु कां आई, तैखन तै रोट्टी खानेरे लेइ बिशोरो थियो, त तैसेरे दोग्गे पुड़ तै इत्र उलटाव। ");
INSERT INTO bhd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","चेले एन लेइतां बड़े नाराज़ भोए ते ज़ोने लग्गे, “कि ए किजो बराबर कियो?” ");
INSERT INTO bhd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","अगर ए बेच़ोरो भोथो, त बड़ी कीमत मैलनी थी, ज़ै गरीबन बेन्टतां देथे। ");
INSERT INTO bhd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","यीशुए एन शुन्तां तैन सेइं ज़ोवं, “तुस एस कुआन्शी किजो तंग केरने लोरेथ? एसां त मीं सेइं रोड़ू कियोरूए। ");
INSERT INTO bhd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","गरीब त हमेशा तुसन सेइं साथी भोनेन, पन अवं तुसन सेइं साथी हमेशा नईं भोनो। ");
INSERT INTO bhd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","तैसां मेरी जानी पुड़ ज़ै ई इत्र उलटावरोए, तैसां मेरे दबनेरे लेइ कियोरू। ");
INSERT INTO bhd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","अवं तुसन सेइं सच़ ज़ोताईं, कि सैरी दुनियाई मां ज़ैड़ी भी खुशखबरी शुनाई गाली, तैड़ी तैसेरी यादगैरी मां एस गल्लरे बारे मां भी ज़ोवं गालू।” ");
INSERT INTO bhd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","फिरी 12 चेलन मरां अक ज़ेसेरू नवं यहूदा इस्करियोती थियूं, प्रधान याजकन कां जेव ते ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“अगर अवं यीशु तुसन ट्लुवेइं, त तुस मीं कुन देले? तैनेईं तैस ट्लाही चैंदरे सिके दित्ते। ");
INSERT INTO bhd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ते तै तेइसेरो तै ठीक मौके बलगने लगो कि यीशु केन्च़रे सेइं ट्लुवाए।” ");
INSERT INTO bhd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","“अखमीरी रोट्टारे तिहारेरी पेइली दिहाड़ी चेले यीशु कां एइतां पुच्छ़ने लग्गे कि, तू फ़सह तिहारेरी रोट्टी कोड़ि खानी चातस, ताके अस गेइतां तियारी केरम?” ");
INSERT INTO bhd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","तैनी ज़ोवं, “नगर मां अक फलानो मैनूए, ते तुस तैस कां गाथ ते तैस ज़ोथ, कि गुरू ज़ोने लग्गोरोए, मेरो वक्त नेड़े पुज़ोरोए ते अवं अपने चेलन सेइं साथी फ़सह तेरे घरे मां मनेइलो।” ");
INSERT INTO bhd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","बस्सा ज़ेरो यीशुए अपने चेलन हुक्म दित्तोरो थियो, तैनेईं तेन्च़रे फ़सह तिहारेरी रोट्टी तियार की। ");
INSERT INTO bhd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ज़ैखन ड्लोझ़ भोइ त यीशु 12 चेलन सेइं साथी रोट्टी खाने बिश्शो। ");
INSERT INTO bhd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ते रोट्टी खांते बार यीशुए तैन सेइं ज़ोवं, “अवं तुसन सेइं सच़ ज़ोताईं कि तुसन मरां अक मीं ट्लुवालो।” ");
INSERT INTO bhd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","“एन शुन्तां तैना सारे चेले उदास भोए, तैना बैरी-बैरी सेइं तैस पुच्छ़ने लग्गे, हे प्रभु कुन अव्वें त नईं?” ");
INSERT INTO bhd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","तैनी जुवाब दित्तो, “ज़ैनी मीं सेइं साथी थैली मां हथ छ़डोरोए, तैए मीं ट्लुवालो। ");
INSERT INTO bhd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","मैनेरे मट्ठेरे लेइ त ज़ेरू तैसेरे बारे मां लिखोरूए तैस सेइं तेरहु कियूं गाते, पन अफ़सोस तैस मैन्हु पुड़ ज़ेसेरी वजाई सेइं तैन ट्लुवाव जेव, तैसेरेलेइ एन्ने रोड़ू थियूं कि तै ज़र्मोरो न भोथो। ");
INSERT INTO bhd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","तैखन ट्लुवानेबालो यहूदा ज़ोने लगो, हे गुरू अव्वें त नईं? तैनी तैस सेइं ज़ोवं, तीं एप्पू ज़ोवं।” ");
INSERT INTO bhd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","खांते बार यीशुए रोट्टी ट्लाती, ते बरकत मेगतां ट्लोड़ी, ते चेलन कां देइतां ज़ोवं यांथ खाथ ई मेरी जाने। ");
INSERT INTO bhd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","फिरी यीशुए दाछ़रे रसेरो कटोरो ट्लातो, ते परमेशरेरू शुक्र केरतां चेलन कां दित्तो ते ज़ोवं, “यांथ तुस सब इस मरां पीया। ");
INSERT INTO bhd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","किजोकि ई मेरे नंव्वे करारे मां मेरो तै खूने ज़ै बड़ां केरे पापां केरि मैफारे लेइ दित्तो गाते। ");
INSERT INTO bhd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","अवं तुसन सेइं ज़ोताईं, कि अवं दाछ़ारो ई रस फिरी कधे न पियेलो ज़ां तगर परमेशरेरे राज़्ज़े मां तुसन सेइं साथी नंव्वो न पीं।” ");
INSERT INTO bhd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","तैल्ला पत्ती, यीशु त कने तैसेरे चेले परमेशरेरू भजन ज़ोइतां, यरूशलेम नगरेरे बेइर ज़ैतून नंव्वेरे पहैड़ी पुड़ च़ली जे। ");
INSERT INTO bhd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","तैखन यीशुए तैन सेइं ज़ोवं, “तुस अज़े राती मेरी वजाई सेइं ठोकर खाले, किजोकि लिखोरूए, ‘अवं पुहाले मारेलो ते धनेरी भैड्डां तितर-बितर भोली।’ ");
INSERT INTO bhd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","पन अवं ज़ींतो भोइतां तुसन करां पेइले गलील इलाके मां गेइलो।” ");
INSERT INTO bhd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","पतरसे तैस सेइं ज़ोवं, “अगर सारे तेरी वजाई सेइं ठोकर खान त खान, पन अवं तेरे बारे मां कधी ठोकर न खेइलो।” ");
INSERT INTO bhd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","यीशुए तैस सेइं ज़ोवं, “अवं तुसन सेइं सच़ ज़ोताईं कि अज़ राती कुकड़ बांग देने करां पेइले तू मेरो ट्लाई बार इन्कार केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","पन पतरसे ज़ोवं, “अगर तीं साथी मीं मरनू भी पे, त तांभी अवं तेरो इन्कार न केरेलो ते सैरी चेलेईं भी एन्ने ज़ोवं।” ");
INSERT INTO bhd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","तैखन यीशु अपने चेलन सेइं साथी एक्की ठैरी पुज़ो, ज़ैस ठारारू नवं गतसमनी थियूं, ते तै अपने चेलन सेइं ज़ोने लगो, तुस इड़ी बिश्शा, ते तांतगर अवं उड़ी अगर गेइतां प्रार्थना केरताईं। ");
INSERT INTO bhd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","तैनी पतरस ते जेब्देरां दुइये मट्ठां साथी नियां, ते तैड़ी तै बड़े परेशान भोने त कने घबराने लगो। ");
INSERT INTO bhd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","फिरी यीशु तैन सेइं, इस दुखेरे वजाई सेइं मेरे प्राण निसने लोरेन इड़ी बिश्शोरे राथ ते बींझ़े राथ। ");
INSERT INTO bhd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","फिरी थोड़ो ज़ेरे अगर गेइतां तल्ले मां मथ्थो टेकतां खिरको ते प्रार्थना की, “हे बाजी अगर भोइसखे त ई कटोरो मीं करां टेली गाए, फिरी भी ज़ैन अवं चाताईं तैन नईं बल्के ज़ैन तू चातस तैन्ने भोए।” ");
INSERT INTO bhd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","फिरी तै चेलन कां वापस अव ते तैना झ़ुलोरे लाए, ते तैने पतरसे सेइं ज़ोवं, “कुन तुस अक घड़ी भी मीं सेइं साथी बींझ़े न बिश्शी सके?” ");
INSERT INTO bhd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","बींझ़े बिश्शा ते प्रार्थना केरते राथ ताके तुस अज़मैइशी मां न राथ, आत्मा त तियारे पन जान कमज़ोरे। ");
INSERT INTO bhd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","यीशुए फिरी जेव, ते ई प्रार्थना की, “हे मेरे बाजी ई दुख्खेरो कटोरो मेरे पीने बगैर टेली न सखे, त तेरी मर्ज़ी पूरी भोए।” ");
INSERT INTO bhd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","तैखन तै चेलन कां एइतां तैना फिरी झ़ुलोरे लाए, किजोकि तैन केरि एछ़्छ़ी ओंड्ले सेइं गिरकी भोरी थी। ");
INSERT INTO bhd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","तै तैन तैड़ी छ़ेडतां च़लो जेव, ते फिरी तैए प्रार्थना केरने लगो ज़ै पेइली कियोरी थी। ");
INSERT INTO bhd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","तैसेरां बाद तै चेलन कां वापस अव, ते तैन सेइं ज़ोने लगो, “हुनी झ़ुलोरे राथ ते आराम केरा, हेरा तै मौको नेड़े पुज़ोरोए, ते मैनेरू मट्ठू पापी लोकां केरे हवाले कियूं गाते। ");
INSERT INTO bhd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उठा, च़लम। हेरा! मीं ट्लुवानेबालो नेड़े पुज़्ज़ी जोरोए!” ");
INSERT INTO bhd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","तै एना गल्लां ज़ोने लोरो थियो, त यहूदा ज़ै 12 चेलन मरां थियो तैड़ी पुज़ो, तैस सेइं साथी बड़े मैन्हु थिये ज़ैना तलवारां ते लठ्ठां घिन्तां ओरे थिये तैना प्रधान याजकन ते कौमरे बुज़ुर्ग लोकेईं भेज़ोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","तैसेरे ट्लुवांने बाले तैन ई निशान दित्तोरो थियो, कि ज़ैस अवं फुम्मड़ी देइलो त तैए, ते तुस तैस ट्लेइयथ। ");
INSERT INTO bhd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ते तैखन यहूदा, यीशु कां एइतां ज़ोवं, हे गुरू नमस्कार, ते एइतां तैस फुम्मड़ी दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","यीशुए तैस सेइं ज़ोवं, हे मेरे दोस्ता ज़ैस कम्मेरे लेइ तू ओरोस तैन कम केर, तैखन लोकेईं एगरोइतां यीशु पुड़ हथ रखे ते ट्लाव। ");
INSERT INTO bhd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","यीशुएरे सैथन मरां एक्के अपनि तलवार कढी, ते महायाजकेरे नौकरे पुड़ बाई ते तैसेरो कन्न कटो। ");
INSERT INTO bhd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","तैखन यीशुए तैस जो ज़ोवं, तलवारी मियांने मां रख किजोकि ज़ैना तलवार च़लातन तैना तलवारी सेइं मारे गाले। ");
INSERT INTO bhd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","“कुन तू न ज़ानस अवं अपने बाजी करां मिनत केरि सकताईं तै हुन्ना स्वर्गदूतां केरि 12 फौवजां बल्के तैस करां भी जादे भेज़ते। ");
INSERT INTO bhd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","पन फिरी तैना पवित्रशास्त्रेरी गल्लां केन्च़रे पूरी भोनिन ज़ैन केरू पूरू भोनू ज़रूरीए?” ");
INSERT INTO bhd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","तैखन यीशुए तैन हछे लोकन सेइं ज़ोवं, “अवं कुन कोई डैकू आईं ते तुस मींजो डांग सोटे ते तलवारां ट्लेइतां मीं ट्लाने ओरेथ? अवं त रोज़ मन्दरे मां बिश्तां शिक्षा देतो थियो ते तैखन तुसेईं अवं नईं ट्लातोरो? ");
INSERT INTO bhd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","पन एन सब किछ एल्हेरेलेइ भोवं, कि पवित्र बचने मां नेबी केरि लिखोरी गल्लां पूरी भोन, तैखन सारे चेले तैस तैड़ी छ़ेडतां च़ले जे।” ");
INSERT INTO bhd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ते यीशु ट्लानेबाले तैस महायाजक कैफा कां घिन्तां जे, ज़ैड़ी तैना शास्त्री ते बुज़ुर्ग अकोट्ठे भोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ते पतरस भी दूरेरां देंतो पत्पती तैस महायाजकेरे अंगनेरे तगर जेव, ते तैड़ी पेरहेदारन सेइं साथी बिश्तां यीशुएरो अन्त लोरो थियो हेरने कि कुन केरतन। ");
INSERT INTO bhd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","प्रधान याजक ते कने सारी महासभा यीशुएरे खलाफ गवाही तोपनेरी कोशिश केरि राओरे थिये, कि ज़ैस सेइं यीशु कत्ल कियो गाए। ");
INSERT INTO bhd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","पन कोई गवाह न मैल्लो, हालांकी बड़े झूठे गवाह भी पैश भोए, आखर्कार दूई गवाह पैश भोए। ");
INSERT INTO bhd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ते ज़ोने लग्गे, एनी ज़ोरू कि “अवं परमेशरेरू घर डोलतां ट्लेइ दिहाड़न मां फिरी खड़ू केरि सकताईं।” ");
INSERT INTO bhd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","तैखन महायाजक खड़ो भोइतां यीशु पुच्छ़ने लगो, “कुन तू कोई जुवाब न देस, इना लोक तेरे खलाफ कुन गवाही देतन?” ");
INSERT INTO bhd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","पन यीशु च़ुप राव, “तैखन महायाजक फिरी पुच़्छ़ने लगो, तीं ज़ींते परमेशरेरी कसम भोए कि असन ज़ो, कि तू परमेशरेरू मट्ठू मसीह आस? ");
INSERT INTO bhd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","यीशुए जुवाब दित्तो, तीं एप्पू ज़ोई छ़डू ते हुनी अवं भी ज़ोताईं कि अज़्ज़ेरे बाद तुस मैनेरे मट्ठे परमेशरेरे देइने पासे बिश्शोरे लाएले, ते अम्बरे पुड़ बिदलारी मां एइते लाएले।” ");
INSERT INTO bhd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","तैखन महायाजके अपना लिगड़ां छ़िंदा, ते ज़ोने लगो, एनी परमेशरेरी तुहीन कियोरीए हुनी असन केन्ची गवाहेरी ज़रूरत नईं, तुसेईं हुन्ना एसेरू झूठ शुनेरूए। ");
INSERT INTO bhd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","तुश्शी कुन राईए? तैनेईं जुवाब दित्तो ए कतलेरे काबल आए? ");
INSERT INTO bhd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","तैखन तैनेईं तैसेरे तुत्तरे पुड़ थुकू ते तैस घुसेइं ते होरेईं थप्पड़ मैरतां ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“हे मसीह अगर तू नबी आस त भविष्यिवाणी केर ते ज़ो, तीं केनि बाहोरिए?” ");
INSERT INTO bhd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","पतरस बेइर अंगने मां बिशोरो थियो, ते अक नौकरानी तैस कां आई ते ज़ोने लग्गी कि तू भी यीशु गलीली सेइं साथी थियो। ");
INSERT INTO bhd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","तैनी सेब्भी केरे सामने इन्कार कियो ते ज़ोवं, “मीं नईं पतो तू कुन लोरिस ज़ोने? ");
INSERT INTO bhd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","तैखन पतरस बेइर फाटकेरे पासे जेव, त अक होरि नौकरानी तैस लेइतां तैन सेइं ज़ैन तैड़ी थी ज़ोने लाई, ई मैन्हु भी नासरतेरे यीशु सेइं साथी थियो।” ");
INSERT INTO bhd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","पन तैनी सेब्भी केरे सामने कसम केरतां इन्कार कियो, ते ज़ोवं, अवं एस मैन्हु सैइयां न ज़ैनी। ");
INSERT INTO bhd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","थोड़े च़िरेरां पत्ती तैना लोक ज़ैना तैड़ी खड़खड़े थिये, पतरसे कां आए ते ज़ोने लग्गे, सच्च़े तू भी तैन्ने मरां अक आस, किजोकि तेरी बोली सेइं बुझ़ोते कि तू तैसेरो साथिस। ");
INSERT INTO bhd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","तैखन तै तैस जो गैई देइतां ज़ोने लगो, ते कसम केरतां ज़ोने लगो, “अवं एस मैन्हु सैइयां न ज़ैनी।” तैखन कुकड़े बांग दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","पतरसे तैखन यीशुएरी तै गल याद आई, ज़ै तैनी ज़ोरी थी कि कुकड़ेरे बांग देने करां पेइले तू ट्लेइ बार मेरो इन्कार केरेलो, ते पतरस बेइर गेइतां हुस्बुकैइं-हुस्बुकैइं लेरां देने लगो। ");
INSERT INTO bhd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","झ़ेझ़ भोंते सारे लोक ते प्रधान याजक, ते कौमरे बुज़ुर्गेईं मुशोरो कियो कि यीशुएरे कत्ल केरनेरो फैसलो कियो। ");
INSERT INTO bhd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ते यीशु बेंधतां नीयो, ते रोमी गवर्नर पिलातुसे कां नीयो। ");
INSERT INTO bhd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ज़ैखन यहूदा ज़ैनी यीशु ट्लुवेवरो थियो तैस एसास भोव, कि यीशु मुर्ज़म बनोरोए त तैनी बड़ू पशतावं, ते तैना चैंदरे ट्लही सिक्के प्रधान याजक ते बुज़ुर्गन कां वापस आने। ");
INSERT INTO bhd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ते ज़ोने लगो, “मीं पाप कियो, कि अक बेकसूर मैन्हु, मारने लेइ ट्लुवाव,” ते तैना ज़ोने लग्गे, “असन कुने? तू ज़ान ते तेरू कम ज़ांने।” ");
INSERT INTO bhd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","तैखन यहूदा तैना सिक्के मन्दरेरे अंगने मां शैरतां छ़डे, ते तैट्ठां गेइतां अपने आपे फांसी दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","प्रधान याजकेईं तैना सिक्के सल्ले, ते ज़ोने लग्गे, “इन सिक्के इश्शे कानूनेरे मुताबिक मन्दरेरे खज़ाने मां रखने जेइज़ नईं, किजोकि ए कोन्ची मैन्हु मारनेरी कीमते।” ");
INSERT INTO bhd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","एल्हेरेलेइ तैनेईं मुशोरो केरतां तैस रकमी सेइं कुम्हारे करां अक ऊडार घिन्नू, ताके परदेशी केरे लेइ कब्रास्तान बनावं गाए। ");
INSERT INTO bhd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","तांए त अज़ तगर भी तैस ऊडारे जो खूनेरू ऊडार ज़ोतन। ");
INSERT INTO bhd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","तैखन तै गल पूरी भोइ ज़ै यिर्मयाह नेबे ज़ोरी थी, कि तैनेईं तैसेरी पूरी कीमत चैंदरे ट्लही सिक्के निये, ए कीमत इस्राएलेरे लोकेईं कियोरी थी। ");
INSERT INTO bhd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ते तैन चैंदरे ट्लही सिक्केइं सेइं कुम्हारेरू ऊडार घिन्ने जो दित्ते ज़ेन्च़रे प्रभुए मीं हुक्म दित्तोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ज़ैखन यीशु हाकिमेरे तुत्तरे अगर खड़ो थियो, ते हाकिम तैस पुच़्छ़ू, “तू यहूदी केरो राज़ोस?” यीशुए जुवाब दित्तो, “तू एप्पू ज़ोने लोरोस।” ");
INSERT INTO bhd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ते ज़ैखन प्रधान याजक ते बुज़ुर्ग तैस पुड़ इलज़ाम लाने लोरे थिये त यीशुए कोई जुवाब न दित्तो। ");
INSERT INTO bhd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","तैखन पिलातुसे यीशु सेइं ज़ोवं, “हेर एना तेरे खलाफ केत्री गवाहैई लोरेन देने तू शुन्तस की नईं।” ");
INSERT INTO bhd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","पन यीशुए तैस एक्की गल्लारो भी जुवाब न दित्तो; ते इड़ी तगर कि हाकिम बड़ो हैरान भोइ जेव। ");
INSERT INTO bhd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ते हाकिमेरो अक दस्तूर थियो, कि फ़सह तिहारेरे मौके पुड़ अक कैदी ज़ैस लोक चाते थिये तैस हथरां छ़डतो थियो। ");
INSERT INTO bhd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","तैस मौके तैन केरो अक बड़ो मुशूर कैदी थियो, ज़ेसेरू नवं बरअब्बा थियूं। ");
INSERT INTO bhd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ज़ैखन तैना लोक पिलातुसे कां जम्हां भोए, त पिलातुसे तैन पुच़्छ़ू, “तुस कुन चातथ, अवं केस हथरां छ़ेड्डी? बरअब्बा कि यीशु ज़ैस जो मसीह ज़ोतन?” ");
INSERT INTO bhd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","किजोकि तै ज़ानतो थियो, कि तैनेईं सिर्फ जलनी सेइं तै ट्लुवोरोए। ");
INSERT INTO bhd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ज़ैखन तै आदालतरी तखते पुड़ बिशोरो थियो, त तैसेरी कुआन्शां तैस जो समाद भेज़ोरो थियो, “कि तू एस रोड़े मैनेरे बारे मां किछ न करां, किजोकि मीं अज़ राती एसेरी वजाई सेइं सुपने मां बड़ो दुःख भोरोए।” ");
INSERT INTO bhd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","पन प्रधान याजकेईं ते बुज़ुर्ग लोकेईं लोक बमकाए, कि तैना पिलातुसे करां बरअब्बा हथरां छ़डन ते यीशु मारन। ");
INSERT INTO bhd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ज़ैखन हाकिमे तैन लोकन पुच़्छ़ू, “कि तुस एन दुईन मरां केस चातथ, अवं तैस हथरां छ़ेड्डी,” तैन लोकेईं ज़ोवं, “बरअब्बा।” ");
INSERT INTO bhd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","पिलातुसे तैन पुच़्छ़ू, “फिरी अवं यीशु ज़ैस जो मसीह ज़ोतन तैस सेइं कुन केरि?” सब लोक ज़ोने लग्गे “एस क्रूसे पुड़ च़ाढ़।” ");
INSERT INTO bhd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","हाकिमे ज़ोवं किजो? “एनी कुन बुराई कियोरीए? पन तैना मना ज़ोरे-ज़ोरे ज़ोने लग्गे कि एस क्रूसे पुड़ च़ाढ़।” ");
INSERT INTO bhd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ज़ैखन पिलातुसे हेरू कि किछ भी बन्ने बालू नईं बल्के उलटो फसाद भोने बालोए, त तैनी पानी मेगतां तैन मैन्हु केरे सामने हथ धोए ते ज़ोवं, “कि अवं एस एक्की धेर्मी मैनेरे खूने करां बरी भोइताईं, तुसे ज़ांना।” ");
INSERT INTO bhd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ते सारे लोकेईं जुवाब दित्तो, “एसेरो खून असन पुड़ ते इश्शी औलादी पुड़ भोए।” ");
INSERT INTO bhd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","तैखन पिलातुसे बरअब्बा हथरां छ़ड्डो, ते यीशुए कोड़े बावैहीतां तैन केरे हवाले कियो, ताके तैना तैस क्रूसे पुड़ च़ाढ़न। ");
INSERT INTO bhd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ते तैखन हाकिमेरे सिपैहीयेइं यीशु महलेरे अंगने मां नेइतां सारे फौजरे सिपाही यीशुएरे च़ुफुरतां जम्हां भोए। ");
INSERT INTO bhd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","तैनेईं तैसेरां लिगड़ां खोल्लां ते तैस अक लाल रंगेरो चोगो लुवाव। ");
INSERT INTO bhd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","फिरी कंटां केरू ताज तैसेरे दोग्गे पुड़ रख्खू, ते तैसेरे देइने हथ्थे मां अक निरैठरी लैठ दित्ती, ते तैस कां मथ्थो टेकतां तैसेरी हासी बनाने लग्गे, ते ज़ोने लग्गे, “हे यहूदी केरे राज़ा नमस्कार।” ");
INSERT INTO bhd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","तैना तैस पुड़ थुकते ते सोटी सेइं तैसेरे दोग्गे पुड़ बाते थिये। ");
INSERT INTO bhd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ज़ैखन तैनेईं तैसेरो मज़ाक बनाव, त तैसेरो चोगो खोल्लो, ते फिरी तैस तैसेरां लिगड़ां लुवां ते तैट्ठां च़ले, ताके तैस क्रूसे पुड़ च़ाढ़न। ");
INSERT INTO bhd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ज़ैखन तैना तैट्ठां च़लोरे थिये, त तैन शमौन कुरेनी नंव्वेरो अक मैन्हु मैल्लो, तैन लोकेईं तै ट्लातो ताके यीशुएरू क्रूस छ़ुइतां च़लाए। ");
INSERT INTO bhd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ते यीशु गुलगुता नंव्वेरी ठैरी पुज़े, ज़ेसेरो मतलबे खोपड़ारी ठार। ");
INSERT INTO bhd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","तैड़ी तैनेईं यीशु दाछ़ारो रस ते ट्लिठो रस मिलेइतां पीने जेई दित्तो, पन तैनी पीनी न चाव। ");
INSERT INTO bhd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ज़ैखन तैनेईं यीशु क्रूसे पुड़ च़ाढ़ो त शर्त रेखतां चिट्ठी छ़ेडतां तैसेरां लिगड़ां भी एप्पू मांमेइं बंटा। ");
INSERT INTO bhd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ते तैड़ी बिश्तां तैसेरो पैरहो केरने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ते तैनेईं तैसेरो जुर्म एक्की पेखड़ी पुड़ लिखतां तैसेरे दोग्गे करां बा लाई ज़ैस पुड़ एन लिखोरू थियूं, “ई यहूदी केरो राज़ो यीशु आए” ");
INSERT INTO bhd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","तैखन तैस सेइं साथी दूई डैकू भी क्रूसे पुड़ च़ाढ़े, अक यीशुएरे देइने पासे, ते होरो बांए पासे। ");
INSERT INTO bhd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","तैट्ठां गानेबाले सारे लोक दोग हिलेइतां गाते थिये ते तैसेरी तुहीन केरते थिये। ");
INSERT INTO bhd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ते ज़ोते थी इस मन्दरे डोलने बाला ते ट्लेइ दिहड़न मां बनाने बाला, अपनो आप त बच़ा, “अगर तू परमेशरेरू मट्ठू आस त एस क्रूसे पुड़रां उन्ढो ओस।” ");
INSERT INTO bhd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","एन्च़रे प्रधान याजक ते शास्त्री ते बुज़ुर्ग भी तैसेरी हासी बनाते थिये, ते ज़ोते थिये। ");
INSERT INTO bhd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“एनी होरे बच़ाए पन अपनो आप न बच़ेइ बटो, ‘ई त इस्राएलेरो राज़ो आए।’ अगर हुन्ना भी तू क्रूसे पुड़रां उन्ढो ओस्स, त अस तीं पुड़ विश्वास केरतम। ");
INSERT INTO bhd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","एसेरो भरोसो परमेशरे पुड़े, अगर तै एस चाते त एस बच़ाए, किजोकि एनी ज़ोरू थियूं, ‘अवं परमेशरेरू मट्ठू आईं।’” ");
INSERT INTO bhd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ते दूई डैकू भी ज़ैना तैस सेइं साथी क्रूसे पुड़ च़ाढ़ोरे थिये, तैना भी तैसेरी तुहीन केरते थिये। ");
INSERT INTO bhd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","दीसेरे 12 बज़ेई सारे मुल्खे मां आंधरू भोवं ते ट्लेइ बज़न तगर रावं। ");
INSERT INTO bhd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ते ट्लेइ बाज़ां केरे लगभग यीशुए बड़े ज़ोरे सेइं ज़ोवं, “एली, एली लमा शबक्तनी?” ज़ेसेरो मतलबे, “हे मेरे परमेशर, हे मेरे परमेशर, तीं अवं किजो शारो?” ");
INSERT INTO bhd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ज़ैना लोक तैड़ी खड़खड़े थिये, तैन मरां किछ शुन्तां एन ज़ोने लग्गे, कि ए त एलिय्याह फुकारने लोरोए। ");
INSERT INTO bhd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","तैखन अक मैन्हु देवड़तां जेव, ते अक गलास पैनी मां डोबतां ते निरैठरे सोटी पुड़ टकेइतां पीनेरे लेइ तैसेरे ऐशी सेइं हुरावं। ");
INSERT INTO bhd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","किछ ज़ोने लग्गे, “बलगा हुनी हेरतम, कि एलिय्याह एस बच़ाने एइते कि नईं।” ");
INSERT INTO bhd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ते यीशुए फिरी ज़ोरे सेइं चिन्ड मारी ते प्राण दित्ते। ");
INSERT INTO bhd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","तैखन मन्दरेरो पड़दो बां देंता बुन तगर फेटतां दूई टुक्ड़े भोइ जे, ते पहाड़ां ते सारी ज़मीन हीलने लग्गी। ");
INSERT INTO bhd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","कब्रां खुल्ली जेई, ते बड़े पवित्र लोक ज़ैना मौतरी निड्ला मां झ़ुलोरे थिये, ज़ींते भोइ जे। ");
INSERT INTO bhd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ते कब्रन मरां निस्तां ज़ींते भोनेरां पत्ती पवित्र नगर मां दाखल भोए, ते तैड़ी बड़े होरि लोकेईं भी लाए। ");
INSERT INTO bhd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","तैखन तैनी सूबेदारे ते तैसेरे सैथेईं ज़ैन यीशुएरी निगरानी केरने लोरे थिये, भुंज़ल गांतो हेरो, त तैना डेरि जे, ते ज़ोने लग्गे, “सच़्च़े एन परमेशरेरू मट्ठू थियूं!” ");
INSERT INTO bhd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","तैड़ी बेड़ि कुआन्शां ज़ैना गलील इलाके मरां यीशु सेइं साथी तैसेरी सेवा केरती तैस पत्ती ओरी थी, ते दूरेरां तकने लोरी थी। ");
INSERT INTO bhd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","तैन मां मरियम मगदलीनी ते याकूब त योसेसेरी अम्मा मरियम ते जब्देरे मट्ठां केरि अम्मा साथी थी। ");
INSERT INTO bhd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ज़ैखन ड्लोझ़ भोइ त अरिमतियाहरो अक अमीर यूसुफ नंव्वेरो मैन्हु ज़ै एप्पू भी यीशुएरो चेलो थियो अव। ");
INSERT INTO bhd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","तैनी पिलातुसे कां गेइतां यीशुएरी लाश मगी, ते पिलातुसे लाश देनेरो हुक्म दित्तो। ");
INSERT INTO bhd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","यूसुफे लाश नेइतां एक्की रोड़ि ज़ेरि च़ादरी मां पलैटी। ");
INSERT INTO bhd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ते तै लाश एक्की नव्वीं कब्री मां ज़ै शफ़ड़ी मां घड़ोरी थी रख्खी, ते तैस कब्री आग्रोरां अक बड्डो घोड़ तैस उबरो छ़ड्डो। ");
INSERT INTO bhd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ते मगदलीन ड्लव्वेरी मरियम ते होरि मरियम तैड़ी तैस कब्रारे सामने बिशोरी थी ज़ैस मां यीशुएरी लाश रखोरि थी। ");
INSERT INTO bhd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","होरसां तियैरारे दिहाड़ेरे बाद यहूदी केरे आरामेरे दिहाड़े प्रधान याजक ते फरीसी लोक मिलतां पिलातुसे कां पुज़े। ");
INSERT INTO bhd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ते ज़ोने लग्गे महाराज़ असन यादे कि तैनी धोखे बाज़े अपने ज़ींते सांसेइं ज़ोरू थियूं, “अवं मरनेरे ट्लेइ दिहाड़ां बाद फिरी ज़ींतो भोनोईं। ");
INSERT INTO bhd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","एल्हेरेलेइ हुक्म दे ताके ट्लाई दिहाड़न तगर कब्री पुड़ पेरहो दित्तो गाए, कि एरू न भोए कि तैसेरे चेले एइतां तैसेरी लाश च़ोरन, ते लोकन सेइं ज़ोन कि तै मुड़दन मरां ज़ींतो भोरोए, ए धोखो पेइले धोखे करां भी जादे बुरो भोलो।” ");
INSERT INTO bhd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पिलातुसे जुवाब दित्तो, “तुसन कां पेरहो देनेबाले आन, गाथ ज़ेत्रू भोइसखे पेरहो देथ।” ");
INSERT INTO bhd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","तैखन तैनेईं गेइतां घोड़े पुड़ मोहर लाई, ते कब्ररारे पेरहे लेइ पेरहेदार रख्खे। ");
INSERT INTO bhd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","आरामेरे दिहाड़ेरे बाद हफतेरे पेइले दिहाड़े ट्लेकड़ोंते-ट्लेकड़ोंते मगदलीन ड्लंव्वेरी मरियम ते होरि मरियम ज़ैड़ी यीशुएरी लाश कब्री मां रख्खोरी थी, हेरने एई। ");
INSERT INTO bhd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ते हेरा अक बड़ो भुंज़ल अव, किजोकि परमेशरेरो अक स्वर्गदूत स्वर्गेरां ओरो थियो, ते तैस कब्री अगरां घोड़ उन्ढो बिछ़ोड़तां तैस पुड़ बिश्शी जेव। ");
INSERT INTO bhd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","तैसेरी शकल सूरत दिहाड़ेरी ज़ेरि रोड़ी थी, ते तैसेरां लिगड़ां हींवेरां ज़ेरां छ़ित्तां सुफैद थियां। ");
INSERT INTO bhd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","पेरहेदार डेरतां थर-थर कम्बने लग्गे ते ज़ेरे मुड़दे भोए। ");
INSERT INTO bhd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","स्वर्गदूते कुआन्शन सेइं ज़ोवं, “डरा नन्ना, अवं ज़ानताईं कि तुस यीशुए तोपने लोरिथ, ज़ै क्रूसे पुड़ च़ाढ़ोरोए। ");
INSERT INTO bhd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","तै इड़ी नईं बल्के ज़ेन्च़रे तैनी ज़ोरू थियूं, तै ज़ींतो भोरोए, एज्जा तै ठार हेरा, ज़ैड़ी प्रभु थियो। ");
INSERT INTO bhd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ते जल्दी गेइतां तैसेरे चेलन पतो देथ, कि तै मुड़दन मरां ज़ींतो भोरोए, ते तुसन करां पेइलो गलीले मां गाते, ते तुसेईं तै लहनोए हेरा मीं तुसन एन ज़ोरूए।” ");
INSERT INTO bhd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","तैखन तैना कुआन्शां डेरतां भी ते खुशी सेइं भी कब्री मरां बेइर एई, ते दौवड़ती-दौवड़ती जेई ताके चेलन पतो देन। ");
INSERT INTO bhd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","तैखन यीशु तैन मैल्लो, ते तैनी ज़ोवं तुसन शान्ति मैल्ले, ते तैनेईं तैसेरे पाव बंते, ते तैस कां मथ्थो टेको। ");
INSERT INTO bhd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","तैखन यीशुए तैन ज़ोवं, डरा न ते गाथ ते मेरे चेलन सेइं ज़ोथ कि गलीले मांजो गान, तैना मीं तैड़ी लाएले। ");
INSERT INTO bhd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","हेजू तैना कुआन्शां बत्तां थी कि ज़ैना चेलन खबर देने च़लोरी थी, त पेरहेदारन मरां किछ नगर मां जे ते प्रधान याजकन सेइं सारो बिस्तार शुनाव। ");
INSERT INTO bhd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ज़ैखन महायाजकेईं बुज़ुर्गन सेइं मिलतां मुशोरो कियो, ते तैनेईं ई फैसलो कियो कि सिपेहिन बड़े पेइंसे देन, कि तैना ई गल केन्ची सेइं न ज़ोन, कि कब्र केन्च़रे खाली भोइ। ");
INSERT INTO bhd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","तैनेईं पेहरेदारन एन ज़ोवं, कि तुस एन ज़ोइयथ, कि ज़ैखन अस राती झ़ुल्लोरे थिये त तैसेरे चेले आए ते तैनेईं तैसेरी लाश नी। ");
INSERT INTO bhd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","अगर ए गल गुवर्नारे तगर पुज़ेली त अस तैस एप्पू समझ़ामेले त तुसन कोई परेशानी न भोली। ");
INSERT INTO bhd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ते सिपैहेईं पेइंसे नीए ते ज़ेन्च़रे तैनेईं ज़ोरू थियूं तेन्च़रे कमाव, ते अज़ तगर ए गल यहूदन मां मुशूरे। ");
INSERT INTO bhd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","11 चेले गलीले मां जे, ते तैस पहाड़े पुड़ अकोट्ठे भोए ज़ैड़ी गानेरे बारे मां यीशुए तैन ज़ोवरू थियूं। ");
INSERT INTO bhd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ज़ैखन तैनेईं यीशु लाव त तैस कां मथ्थो टेको, ते किछन हेजू भी शक थी, कि तै ज़ींतो वापस ओरोए। ");
INSERT INTO bhd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","तैखन यीशु तैन केरे नेड़े एइतां ज़ोवं, “धेरतरो ते स्वर्गेरो सारो अधिकार मीं दित्तोरोए। ");
INSERT INTO bhd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","एल्हेरेलेइ तुस गाथ ते सैरी कौमां केरे लोकन चेले बनाथ, ते तैन बाजी, ते मट्ठेरे, ते पवित्र आत्मारे नंव्वे सेइं बपतिस्मो देथ। ");
INSERT INTO bhd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ते तैन तैना सब हुक्म मन्ने शिखाला ज़ैना मीं तुसन दित्तोरेन, ते हेरा, अवं दुनियारे आखरी तगर हमेशा तुसन सेइं साथी आईं।”");
INSERT INTO bhd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ई यीशु मसीहेरे बारे मां खुशखेबरारी शुरुआत आए, ज़ैन परमेशरेरू मट्ठू आए। ");
INSERT INTO bhd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","(बड़े पेइले) यशायाह नेबे अपनि किताबी मां लिखोरू थियूं कि, (परमेशरे अपने मट्ठे सेइं ज़ोवं,) “शुन, अवं अपनो बिस्तार देनेबालो तीं केरां पेइले भेज़ेलो।” “तै तीं केरां पेइलो गेइतां तेरे लेइ बत तियार केरेलो। (यानी, लोकां केरे दिल परमेशरे लेइ तियार केरेलो)” ");
INSERT INTO bhd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“तै बिस्तार देनेबालो सुनसान ठैरी मां लोकन, ज़ैना तैस कां गाले, तैन हक देइतां ज़ोलो कि ‘तुसन कां प्रभु एजनेबालो आए, एल्हेरेलेइ तुस तैसेरेलेइ बत तियार केरा त कने तैसेरेलेइ सड़कां सिद्धी केरा।’ (यानी, प्रभुएरे लेइ तुस अपने दिल साफ केरा)” ");
INSERT INTO bhd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ज़ेन्च़रां लिखोरू थियूं, अक बिस्तार देनेबालो अव। तैस मैनेरू नवं यूहन्ना थियूं। लोक तैस जो बपतिस्मो देनेबालो भी ज़ोते थिये। तै यहूदिया इलाकेरे सुनसान ठैरी मां अव। तैड़ी तै लोकन परमेशरेरी गल्लां शुनातो थियो कि, “तुस अपने पापन करां मनफिराथ, त कने बपतिस्मो नेथ, ताके परमेशर तुश्शे पाप माफ़ केरे।” ");
INSERT INTO bhd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","यहूदिया इलाकेरे बड़े लोक त यरूशलेम नगरेरे रानेबालन मरां बड़े लोक यूहन्नारी गल्लां शुन्नेरे लेइ सुनसान ठैरी मां तैस कां आए। तैन लोकेईं अपने पाप मेन्तां यूहन्ना करां यरदन दरियाए मां बपतिस्मो नीयो। ");
INSERT INTO bhd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यूहन्ना आम लिगड़ां लातो थियो ज़ैना लिगड़ां ऊँटेरे बालन सेइं बनोरां थियां। तै अपनि कमरी पुड़ चमड़ेरू मज़ बंधतो थियो। ते तै टिट्टां त कने जंगलेरू माछ़ी खातो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","तै लोकन शुनातो थियो कि, “कोई अक, ज़ै मीं केरां भी महान आए, मेरे बाद एजनेबालोए। अवं त तैसेरो गुलाम भोनेरे काबल भी नईं कि लिकतां तैसेरे बूटेरे तसमे खोल्ली। ");
INSERT INTO bhd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","अवं त तुसन पैनी सेइं बपतिस्मो देताईं, पन तै तुसन पवित्र आत्मा सेइं बपतिस्मो देलो” ");
INSERT INTO bhd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","तैल्ला पत्ती, तैन दिहाड़न मां एरू भोवं कि यीशु गलील इलाकेरे नासरत नगरेरां यूहन्ना कां अव। तैनी यूहन्ना करां यरदन दरियाए मां बपतिस्मो नीयो। ");
INSERT INTO bhd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ज़ैखन यीशु बपतिस्मो नेइतां पैनी मरां बेइर अव, त तैनी अम्बर खुलतू त पवित्र आत्मा कबूतरेरी शकली मां तैस पुड़ एत्तो लाव। ");
INSERT INTO bhd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","तैखन परमेशरे स्वर्गेरां यीशु सेइं ज़ोवं, “तू मेरू ट्लारू मट्ठू आस, अवं तीं पुड़ बड़ो खुश आईं।” ");
INSERT INTO bhd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","तैल्ला पत्ती, अकदम पवित्र आत्मा यीशु सुनसान ठैरी जो भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","सुनसान ठैरी मां 40 दिहाड़न तगर शैताने यीशु अज़माव। त तैड़ी यीशु जंगली जानवरन साथी थियो। तैखन परमेशरेरे स्वर्गदूत यीशु कां एइतां तैसेरी सेवा केरने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","किछ वक्तेरां बाद, यूहन्ना नबी कैद कियो जेव। तैल्ला बाद, यीशु गलील इलाके मां जेव। तैड़ी तै लोकन परमेशरेरे राज़्ज़ेरे बारे मां खुशखबरी शुनाने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","तैनी ज़ोवं कि, “ठीक वक्त ओरोए त कने परमेशरेरू राज़ नेड़े ओरूए! एल्हेरेलेइ, तुस अपने पापन करां मनफिराथ ते इस खुशखेबरी पुड़ विश्वास केरा।” ");
INSERT INTO bhd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","एक्सां, ज़ैखन यीशु गलील नव्वेंरे समुन्दरेरे बन्ने च़लोरो थियो, तैखन तैनी दूई मैन्हु शमौन त तैसेरो ढ्ला अन्द्रियास लाए, ज़ैना मेछ़ली ट्लानेबाले थिये। तैना मेछ़ली ट्लानेरे लेइ समुन्दरे मां ज़ाल छ़ेड्डी राओरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","यीशुए तैन सेइं ज़ोवं, “एज्जा मेरे चेले बना। अवं तुसन शिखालेलो कि केन्च़रां होरे मैन्हु मेरे चेले बनानेन।” ");
INSERT INTO bhd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","अकदम तैना अपना जालां छ़ेडतां यीशु पत्ती च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ज़ैखन तैना थोड़े ज़ेरे अग्गर जे, त यीशुए याकूब त कने तैसेरो ढ्ला यूहन्ना लाए। तैना दुइये जेब्देरां मट्ठां थियां। तैना किश्ती मां जालां ठीक केरने लग्गोरे थिए। ");
INSERT INTO bhd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","अकदम यीशुए तैना अपने चेले बनानेरे लेइ कुजाए। तैना दुइये, अपने बाजी जब्दी किश्ती मां मज़दूरन सेइं साथी छ़ेडतां, यीशु सेइं साथी च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","तैल्ला पत्ती, यीशु त तैसेरे चेले तैट्ठां कफरनहूम नगरे मां जे। आरामेरे दिहाड़े, अकदम यीशु तैन केरे प्रार्थना घरे मां जेव। तैड़ी तै परमेशरेरी गल्लां तैन लोकन शुनाने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","तैना यीशुएरी शिक्षा शुन्तां हैरान भोए, किजोकि तैनी शास्त्री लोकां केरि ज़ेरि शिक्षा न दित्ती, पन तै अधिकारे सेइं शिक्षा देइ राओरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ज़ैखन यीशु तैड़ी थियो, त तैन केरे प्रार्थना घरे मां अक मैन्हु थियो, ज़ैस पुड़ भूतेरो सायो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","अचानक तैनी मैने चिन्डां मेरतां ज़ोवं, “हे नासरत नगरेरो यीशु! तीं सेइं असन कुन कम? कुन तू असन नाश केरनेरे लेइ ओरोस? अवं ज़ानताईं कि तू कौन आस, तू परमेशरेरू पवित्र मट्ठू आस!” ");
INSERT INTO bhd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","पन यीशुए तैस भूते झ़िड़कतां ज़ोवं, “च़ुप रा, एस मैन्हु मरां निस्सी गा!” ");
INSERT INTO bhd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","तैखन भूते तै मैन्हु ड्लेडेइतां त ज़ोरे सेइं चिन्डां मेरतां तैस मैन्हु मरां निस्सी जेव। ");
INSERT INTO bhd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","एन हेरतां सारे लोक बड़े हैरान भोए। तैना एप्पू मांमेइं गलबात केरतां एक्की होरि पुछ़ने लग्गे कि, “ए कुन गल आए! ए त अक नंव्वी शिक्षा आए ज़ैस मां अधिकार आए! तै त भूतन भी अधिकारे सेइं हुक्म देते ते तैना भी तैसेरो हुक्म मन्तन।” ");
INSERT INTO bhd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","अकदम यीशुएरे बारे मां ए गल गलील इलाकेरे आसेपासेरे सेब्भी ठैरन मां फैली जेई। ");
INSERT INTO bhd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","तैना अकदम प्रार्थना घरे मरां निस्तां, याकूब त कने यूहन्ना सेइं साथी शमौन त अन्द्रियासेरे घरे जे। ");
INSERT INTO bhd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","शमौनेरी शिखी भुखारे थियो ते तै लेटोरी थी। अकदम तैनेईं तैसारे बारे मां यीशु सेइं ज़ोवं कि ऊ बिमार आए। ");
INSERT INTO bhd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","यीशुए तैस कां गेइतां तैसारो हथ ट्लेइतां खड़ी की। अकदम तैसारो भुखार ठीक भोव। ते तै तैन केरि सेवा केरने लग्गी। ");
INSERT INTO bhd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ड्लोझ़ी ज़ैखन दिहाड़ो डुब्बो, त लोक सारे बिमार मैन्हु त कने ज़ैन मैनन् पुड़ भूतेरो सायो थियो तैना यीशु कां आन्ने लग्गे, ताके तै तैनन् बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","तैस नगरेरे बड़े लोक तैस घरेरे दारे पुड़ अकोट्ठे भोए। ");
INSERT INTO bhd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","यीशुए बड़े मैन्हु बज़्झ़ाए, ज़ैना बड़े किसमां केरि बिमैरन सेइं दुखी थिये। त तैनी बड़े मैनन् मरां भूतां केरो सायो कड्डो। पन यीशुए भूतन किछ ज़ोने न दित्तू, किजोकि तैना यीशु पिशानतां थियां (कि एन परमेशरेरू मट्ठू आए)। ");
INSERT INTO bhd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","एग्री दिहाड़ी, झ़ेज़्झ़ां-झ़ेज़्झ़ां दिहाड़ो निस्ने केरां बड़े पेइले, यीशु उठतां बेइर एक्की सुनसान ठैरी मां जेव। तैड़ी तै प्रार्थना केरने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","पन थोड़े च़िरेरां बाद, शमौन त तैसेरे साथी, यीशु तोपने जे। ");
INSERT INTO bhd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ज़ैखन तैनन् तै मैल्लो, त तैनेईं यीशुए सेइं ज़ोवं, “(वापस ड्लाव्वें मां एई,) सारे लोक तीं तोप्पी राओरेन!” ");
INSERT INTO bhd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","पन यीशुए तैन सेइं ज़ोवं, “एज्जा, अस होरि केन्ची आसेपासेरे ड्लोंव्वन मां गाम, ताके अवं तैन लोकन भी परमेशरेरी गल्लां शुनेई। किजोकि अवं एस्से कम्मेरे लेइ दुनियाई मां ओरोईं।” ");
INSERT INTO bhd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","तैल्हेरेलेइ यीशु गलील इलाकेरे सारे ड्लोंव्वन मां गेइतां, तैन केरे प्रार्थना घरन मां लोकन परमेशरेरी गल्लां शुनातो राव ते बड़े लोकन मरां भूतां केरो सायो कढतो राव। ");
INSERT INTO bhd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","तैल्ला पत्ती, एक्सां अक कोढ़ी मैन्हु यीशु कां अव। तैनी मैने यीशुएरे सामने ज़ैन्धु केरे भारे बिश्तां तैस कां मिन्नत केरतां तैस सेइं ज़ोवं, “अगर तू चास, त मीं बज़्झ़ेई सकतस। (महरबानी केरतां मीं बज़्झ़ा।)” ");
INSERT INTO bhd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","यीशुए तैस मैन्हु पुड़ तरस खाव। यीशुए अपनो हथ अग्रोवं कियो त तैस कोढ़ी मैन्हु सेइं हथ लेइतां ज़ोवं, “अवं चाताईं, तू बज़्झ़ोस।” ");
INSERT INTO bhd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","अकदम तै कोढ़ी बज़्झ़ोई जेव। ");
INSERT INTO bhd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","तैखन यीशुए तै मैन्हु समझ़ेइतां लूशी भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","त तैनी तैस सेइं ज़ोवं, “हेर, एस गल्लरे बारे मां केन्ची सेइं किछ न ज़ोइयां। (तू यरूशलेम नगरेरे मन्दरे मां गा), त कने अपने आपे याजके हिरा। तैल्ला पत्ती, तू अपने बेज़्झ़ोनेरे वजाई सेइं च़ढ़तल च़ाढ़, ज़ेसेरे बारे मां मूसा नेबे कानूने मां हुक्म दित्तोरोए, ताके लोकन पतो च़ले कि तू बेज्झ़ोरोस।” ");
INSERT INTO bhd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","पन तै मैन्हु बेइर गेइतां एस गल्लारे बारे मां लोकन बड़ू शुनाने लगो ते इड़ी तगर फैलाने लगो कि यीशु फिरी बांदे नगरे मां न गेइ सको, पन बेइर सुनसान ठैरन मां राव ते च़ेव्रे पासां केरे लोक तैस कां एइते राए। ");
INSERT INTO bhd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","किछ दिहाड़ना बाद, यीशु फिरी कफरनहूम नगरे मां जेव। तैट्ठेरे मैनेईं शुनू कि तै तैड़ी एक्की घरे मां आए। ");
INSERT INTO bhd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","अकदम बड़े मैन्हु तैस घरे मां अकोट्ठे भोए। तैड़ी ठार न राई, इड़ी तगर कि दारे केरां बेइर भी ठार न थी। यीशु तैन लोकन परमेशरेरी गल्लां शुनाने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","तैखन किछ मैन्हु एक्की अधरंगी मैन्हु छ़ुइतां यीशु कां आए। च़ेव्रे मैनेईं तै अधरंगी मैन्हु खट्टी पुड़ छ़ुइतां आनोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","मैन्हु केरि भीड़रे वजाई सेइं, तैना यीशुएरे नेड़े न पुज़्ज़ी सके। एल्हेरेलेइ तैनेईं तैस घरेरी छत ज़ैस मां यीशु थियो पुट्टी छ़ड्डी। तैल्ला बाद, तैनेईं तै खट ओसाली ज़ैस पुड़ अधरंगी मैन्हु थियो। ");
INSERT INTO bhd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","यीशुए तैन केरो विश्वास हेरतां अधरंगी मैन्हु सेइं ज़ोवं, “हे मट्ठा, तेरे पाप माफ़ भोए।” ");
INSERT INTO bhd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","तैखन शास्त्री लोकन मरां किछ मैन्हु ज़ैना तैड़ी थिये, अपने-अपने मने मां सोचने लग्गे कि, ");
INSERT INTO bhd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ए मैन्हु एन्च़रां किजो ज़ोते? ए त परमेशरेरी तुहीन केरते। परमेशरेरे अलावा कौन पाप माफ़ केरि सकते?” ");
INSERT INTO bhd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","अकदम यीशुए ज़ैनी छ़ड्डू कि तैना अपने-अपने मने मां कुन सोचने लग्गोरेन। एल्हेरेलेइ तैनी तैन सेइं ज़ोवं, “तुस अपने-अपने मने मां एन्च़रां किजो सोचने लग्गोरेथ? ");
INSERT INTO bhd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","एस अधरंगी मैन्हु सेइं कुन ज़ोनू सुख्तू आए? एन ज़ोनू कि ‘तेरे पाप माफ़ भोए,’ या एन ज़ोनू कि ‘उठ, अपनि खट छ़ुइतां च़ल फिर?’ ");
INSERT INTO bhd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","अवं किछ केरनेबालोईं, ज़ैस सेइं तुसेईं बुज़्झ़नूए कि मैनेरे मट्ठे (यानी मीं) धेरती पुड़ लोकां केरे पाप माफ़ केरनेरो अधिकार आए!” फिरी तैनी तैस अधरंगी मैनेरे पासे मुड़तां तैस सेइं ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“अवं तीं सेइं ज़ोतईं, उठ, अपनि खट छ़ुइतां अपने घरजो गा!” ");
INSERT INTO bhd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","अकदम तै खड़ो उठो ते अपनि खट छ़ुइतां सारे मैन्हु केरे सामने निस्तां च़लो जेव। एस वजाई सेइं सारे मैन्हु हैरान भोए, त परमेशरेरी बड़याई केरतां ज़ोने लग्गे, “असेईं एरू ज़ेरू कधी नईं लावरू!” ");
INSERT INTO bhd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","तैल्ला पत्ती, यीशु तैट्ठां निस्तां फिरी गलील समुन्दरेरे बन्ने जेव। तैखन मैन्हु केरि सारी भीड़ तैस कां आई। तै तैन लोकन परमेशरेरी गल्लां केरि शिक्षा देने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","समुन्दरेरे बन्ने गाते-गाते, यीशुए लेवी नंव्वेरे मैन्हु लाव, ज़ैन हलफईसेरू मट्ठू थियूं। तै मैन्हु चुंगी नेनेरे दफ़तरे मां कम केरतो थियो। तैखन यीशुए तैस सेइं ज़ोवं, “मीं पत्ती एई, ते मेरो चेलो बन।” अकदम लेवी उठो त यीशु पत्ती च़लो। ");
INSERT INTO bhd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","बादे मां, यीशु त तैसेरे चेले लेवेरे घरे मां रोट्टी खाने बिश्शे। तैखन बड़े चुंगी नेनेबाले त होरे पापी मैन्हु (लोक तैन केरे बारे मां सोचते थिये कि एना पापिन।) भी यीशु त तैसेरे चेलन सेइं साथी रोट्टी खाने बिश्शे, किजोकि एन केरे ज़ेरे बड़े लोक यीशु पत्ती च़लते थिये। ");
INSERT INTO bhd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ज़ैखन किछ शास्त्री लोकेईं त कने फरीसी लोकेईं हेरू कि यीशु पापी मैनन् त चुंगी नेनेबालन सेइं साथी रोट्टी खाने लग्गोरोए, तैखन तैनेईं यीशुएरे चेलन सेइं ज़ोवं, “तै चुंगी नेनेबालन त पैपन सेइं साथी किजो खाते पीते?” ");
INSERT INTO bhd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","यीशुए तैन केरि गल शुन्तां तैन मिसाल देइतां जुवाब दित्तो, “सझ़र लोकन डाक्टरेरी ज़रूरत न पे, पन बिमार मैनन् ज़रूरत पेचे। तेन्च़रां, अवं तैन मैन्हु केरे लेइ नईं ओरोईं ज़ैना अपने आपे धर्मी समझ़तन, पन पापी मैनन् कुजाने ओरोईं, ताके तैना अपने पापन केरां मन फिरान।” ");
INSERT INTO bhd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","यूहन्नारे चेले त कने फरीसी लोक बरत रखते थिये, पन यीशुएरे चेले बरत न थिये रखते। किछ लोकेईं यीशु कां एइतां तैस पुच़्छ़ू, “यूहन्नारे चेले ते फरीसी लोकां केरे चेले बरत रखतन, पन तेरे चेले बरत की न रखन?” ");
INSERT INTO bhd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","यीशुए तैनन् जुवाब दित्तो, “ड्लाएरे दिहाड़े, ज़ैखन लाड़ो जैनी सेइं साथी राते, कुन तैना बरत रेख्खी सकतन? (बिलकुल नईं) तैल्हेरेलेइ, ज़ांतगर लाड़ो तैन सेइं साथी राते, तांतगर तैना बरत न रेख्खी सकन। (किजोकि तैना खुशी आन।) ");
INSERT INTO bhd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","मेरे चेले भी तैन केरे ज़ेरे आन, किजोकि अवं तैन सेइं साथी आईं। पन तैना दिहाड़े एज्जले, ज़ैखन लाड़ो तैन केरां अलग कियो गालो (यानी मारो गालो), तैस मौके तैना (अपने दुख्खेरे वजाई सेइं) बरत रख्खेले।” ");
INSERT INTO bhd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“अवं तुसन अक होरि मिसाल देताईं, नंव्वे लिगड़ेरी टलोई पुराने लिगड़े कोई न लाए। अगर कोई एन्च़रां केरे, त धोनेरे पत्ती नंव्वे लिगड़ेरी टलोई पुराने लिगड़े अपने पासे खिच्ची छ़ड्डेली। त तैन पेइले केरां भी जादे छ़िन्दोलू। ");
INSERT INTO bhd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","तेन्च़रे कोई भी पुरैनी मसकन मां नंव्वे दाछ़ारो रस न रखे, किजोकि दाछ़ारो रस अम्लो भोइतां फुलते बार मसकन छ़िन्दी छ़ड्डेलो। दाछ़ारे रस त कने मसकां, एना दुइये बरबाद भोइ गाले। एल्हेरेलेइ नंव्वे दाछ़ारे रस हमेशा नंव्वे मसकन मां रख्खोरो लोड़े, ताके मसकन न छ़िन्दे।” ");
INSERT INTO bhd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","एक्की आरामेरे दिहाड़े, यीशु त कने तैसेरे चेले बत्ती मांमेइं च़लने लग्गोरे थिये, ज़ै गेंव्वां केरे ऊडारन मांमेइं थी। च़लते-च़लते तैसेरे चेले गेंव्वां केरे किछ शिल्लां ट्लोड़तां खाने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","पन किछ फरीसी लोकेईं तैन हेरतां यीशु सेइं ज़ोवं, “तक! एना आरामेरे दिहाड़े तैन कम किजो केरतन, ज़ैन मूसेरे कानूनेरे मुताबिक जेइज़ नईं?” ");
INSERT INTO bhd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","यीशुए तैन सेइं ज़ोवं, “कुन तुसेईं परमेशरेरी किताबी मां एन कधी नईं पढ़ोरूए कि (बड़े पेइले) दाऊद राज़े कुन कियूं, ज़ैखन तैस त तैसेरे सैथन ढ्लुख लग्गी त तैनन् रोट्टरी ज़रूरत थी? ");
INSERT INTO bhd_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","तुसन पतोए कि दाऊद राज़े परमेशरेरे घरे मां गेइतां, अबियातार नंव्वेरे महायाजक करां खाने जो रोट्टी मग्गी। दाऊदे तै रोट्टी खाइ, ज़ै परमेशरे जो च़ढ़ोरी थी। कानूनेरे मुताबिक याजक केरे अलावा होरि केन्ची तैना रोट्टी खानेरी अज़ाज़त नईं थी। पन दाऊदे अपने सैथन भी रोट्टी दित्ती त तैनेईं भी तैना रोट्टी खेइ? (पन फिरी भी परमेशरे दाऊदे पुड़ दोष न लाव।)” ");
INSERT INTO bhd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","तैखन यीशुए तैन फरीसी लोकन सेइं ज़ोवं, “परमेशरे आरामेरी दिहाड़ी लोकन मद्दत केरनेरे लेइ बनोरीए, न कि आरामेरे दिहाड़ेरे कानून मन्नेरे लेइ तैनी लोक रच़े। ");
INSERT INTO bhd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","एल्हेरेलेइ, मैनेरू मट्ठू यानी अवं आरामेरे दिहाड़ेरो भी प्रभु आईं।” ");
INSERT INTO bhd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","तैल्ला पत्ती, यीशु एक्की प्रार्थना घरे मां जेव। तैड़ी अक मैन्हु थियो, ज़ेसेरो हथ शुक्कोरे थियो। ");
INSERT INTO bhd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","तैड़ी किछ फरीसी लोक भी थिये, ज़ैना यीशु पुड़ इलज़ाम लानो चाते थिये। एल्हेरेलेइ तैना यीशु ध्याने सेइं हेरने लग्गोरे थिये कि आरामेरे दिहाड़े तै तैस मैन्हु बज़्झ़ाते की नईं। ");
INSERT INTO bhd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","तैखन यीशुए शुक्कोरे हथ्थेबाले मैन्हु सेइं ज़ोवं, “मझ़ाटे खड़े भो।” (ते तै मैन्हु खड़ो भोव।) ");
INSERT INTO bhd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","त यीशुए तैन लोकन पुच़्छ़ू, “आरामेरे दिहाड़े कुन केरनू जेइज़े, मैनेरू भलू केरनू या बुरू केरनू, मैनेरी जान बच़ानी या मारनी?” पन तैना च़ुप राए। ");
INSERT INTO bhd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","त तैनी सरकी सेइं तैन केरे च़ेव्रे पासन तक्कू, पन तैन केरे सखत दिलेरी वजाई सेइं उदास भोव। तैखन तैनी तैस मैन्हु सेइं ज़ोवं, “अपनो हथ अग्रोवं केर।” तैनी मैने अपनो हथ अग्रोवं कियो। त अकदम तैसेरो हथ बेज्झ़ोव। ");
INSERT INTO bhd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","तैखन फरीसी लोक प्रार्थना घरे मरां बेइर जे। अकदम तैना हेरोदेस राज़ेरे लोकन सेइं साथी यीशुएरे खलाफ साज़िश केरने लग्गे कि यीशुएरो कोस तरीके सेइं कत्ल केरम। ");
INSERT INTO bhd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","तैल्ला पत्ती, यीशु अपने चेलन सेइं साथी गलील समुन्दरेरे पासे जेव। मैन्हु केरि बड़ी भीड़ तैस पत्ती च़ली। गलील त यहूदिया इलाकां केरे लोक तैस कां आए। ");
INSERT INTO bhd_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","यरूशलेम नगरेरे लोक, इदूमिया इलाकेरे लोक ते यरदन दरियारे पारेरे लोक त कने सूर त सैदारे आसेपासेरे लोक भी तैस कां ओरे थिये। तैना सब यीशु कां आए, किजोकि तैनेईं यीशुएरे सारे चमत्कारेरे कम्मां केरे बारे मां शुनोरू थियूं, ज़ैना तै केरतो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","यीशुए बड़े लोक हथ लेइतां बज्झ़ावरे थिये, एल्हेरेलेइ होरे बड़े लोक ज़ैना बड़े बिमार थिये, तैना तैस सेइं हथ लानेरे लेइ तैस पुड़ बिछ़ड़ी गाते थिये, ताके तैना भी बेज्झ़ोन। मैन्हु केरि भीड़ बड़ी जादे थी। एल्हेरेलेइ यीशुए अपने चेलन सेइं ज़ोवं, “मेरे लेइ अक किश्ती तियार केरा, ताके एना लोक मीं ढ्लेन्च़ी न सकन।” ");
INSERT INTO bhd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","त ज़ैन लोकन पुड़ भूतां केरो सायो थियो, तैना भी यीशु लेइतां तैसेरे पावन पुड़ बिछ़ड़ी गाते थिए। तैना भी ज़ोरे-ज़ोरे सेइं ज़ोते थिए कि, “तू परमेशरेरू मट्ठू आस।” ");
INSERT INTO bhd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","यीशुए तैन भूतन सखत हुक्म दित्तो कि, “मेरे बारे मां लोकन न ज़ोथ कि अवं कौन आईं।” ");
INSERT INTO bhd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","तैल्ला पत्ती, यीशु एक्की पहाड़े पुड़ च़ढ़ो। ज़ैना मैनन् तै अपने चेले बनानो चातो थियो, तैना एप्पू कां कुजाए। तैना तैस कां आए। ");
INSERT INTO bhd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","यीशुए तैन मरां 12 मड़द च़ुने, ते तैन प्रेरित नवं दित्तू कि तैना तैस सेइं साथी-साथी रान, ताके तै तैन लोकन खुशखबरी शुनाने भेज़े। ");
INSERT INTO bhd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","यीशुए तैनन्, लोकां केरि बिमैरी बज्झ़ाने त कने मैनन् मरां भूतां केरो सायो कढनेरो अधिकार दित्तो। ");
INSERT INTO bhd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","तैना 12 मैन्हु केरां नंव्वां इना थियां: शमौन ज़ेसेरू नवं यीशुए पतरस रखू, ");
INSERT INTO bhd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","याकूब त तैसेरो ढ्ला यूहन्ना, एना दुइये जेब्देरां मट्ठां थियां, त यीशुए एन दुइयां केरू नंव बुअनरगिस रखू, मतलब कि, गुड़नेरां मट्ठां। ");
INSERT INTO bhd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","त अन्द्रियास, फिलिप्पुस, बरतुल्मै, मत्ती, थोमा, याकूब ज़ैन हलफईसेरू मट्ठू थियूं, त तद्दै, शमौन ज़ै पेइले रोमी सरकारारे खलाफ यहूदी लोकां केरि आज़ैदेरे लेइ लड़नेबालो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","त कने यहूदा इस्करियोती ज़ैनी बादे मां यीशु धोखे सेइं ट्लुवाव। ");
INSERT INTO bhd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","तैल्ला पत्ती यीशु कफरनहूम नगरेरे एक्की घरे मां जेव। फिरी मैन्हु केरि भीड़ तैस घरे मां अकोट्ठी भोइ, कि यीशु त तैसेरे चेलन रोट्टी खानेरे लेइ भी मौको न मैल्लो। ");
INSERT INTO bhd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ज़ैखन यीशुएरे रिश्तेदारेईं एन शुनू, त तैना तैस ट्लेइतां अपने घरे वापस आन्नेरे लेइ जे, किजोकि तैना ज़ोने लग्गोरे थिये कि तैसेरो दिमाग ठीकाने नईं। ");
INSERT INTO bhd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","किछ शास्त्री लोक, ज़ैना यरूशलेम नगरेरां ओरे थिये, तैना लोकन सेइं ज़ोई राओरे थिये कि, “यीशु मां शैतान आए।” त एन भी ज़ोई राओरे थिये कि, “ते भूतां केरे प्रधानेरी शेक्ति सेइं लोकन मरां भूतां केरो सायो कढते।” ");
INSERT INTO bhd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","एल्हेरेलेइ यीशुए तैना नेड़े कुजाए ते तैन मिसाल देइतां ज़ोने लगो, “शैतान केन्च़रां अपने भूतन लोकन मरां केड्डी सकते? ");
INSERT INTO bhd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","अगर एक्की राज़्ज़ेरे लोक अपने राज़्ज़ेरे खलाफ लड़ाई केरन, त तैन राज़ बनोरू न रेइ सके। ");
INSERT INTO bhd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","अगर केन्ची टब्बरेरे लोक अपने टब्बरेरे खलाफ लड़ाई केरन, त तैन टब्बर भी बनोरू न रेइ सके। ");
INSERT INTO bhd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","तेन्च़रे, शैतान भी अगर एप्पू अपने भूतां केरे खलाफ लड़ाई केरे, त तै केन्च़रां बनोरो रेइ सकते? तैसेरो त बिलकुल खातमों भोइ गालो। ");
INSERT INTO bhd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","अवं होरि मिसाल देताईं, कोई मैन्हु केन्ची ज़ोरेबाले मैनेरे घरेरे मां गेइतां तैसेरो माल तांतगर लुट्टी न सके, ज़ांतगर कि तै पेइले तैस ज़ोरेबाले मैन्हु बेंधी न छ़ड्डे। तैखन तै तैस ज़ोरेबाले मैनेरो माल लुट्टी सकते। अवं भी शैतानेरे भूतां केरो सायो लोकन मरां केड्डी सकतां। (शैतान तैस ज़ोरेबाले मैनेरो ज़ेरोए) ");
INSERT INTO bhd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","अवं तुसन सेइं सच़ ज़ोतईं कि मैन्हु केरे सारे किसमां केरे पाप त कने परमेशरेरी तुहीन, ज़ै तैना केरतन, अगर तैना मन फिरान त परमेशर तैन माफ़ केरेलो। ");
INSERT INTO bhd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","पन ज़ै कोई पवित्र आत्मारी तुहीन केरे, त तैस कधी भी परमेशर माफ़ न केरेलो। पन तै मैन्हु हमेशारे पापेरो दोषी बेनि गालो।” ");
INSERT INTO bhd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","यीशुए एन्च़रां ज़ोवं किजोकि तैना यीशुएरे बारे मां एन ज़ोते थिये कि तैस पुड़ भूतेरो सायो आए। ");
INSERT INTO bhd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","तैखन यीशुएरी अम्मा त कने तैसेरे ढ्ला तैड़ी आए। तैना घरेरे बेइर खड़े भोइतां तैस जो बिस्तार भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","तैना घरेरे अन्तर न गेइ सके किजोकि मैन्हु केरि भीड़ यीशुएरे च़ेव्रे पासन बिश्शोरी थी। एल्हेरेलेइ तैन लोकेईं यीशु सेइं ज़ोवं, “तक, तेरी अम्मा त तेरे ढ्ला बेइर खड़े आन। तैना तीं सेइं मिलनू चातन।” ");
INSERT INTO bhd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","पन यीशुए तैनन् जुवाब दित्तो, “अवं तुसन ज़ोताईं मेरी अम्मा त कने मेरे ढ्ला कौन आन!” ");
INSERT INTO bhd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","तैखन यीशुए तैन लोकां केरे पासे तेकतां ज़ोवं, ज़ैना तैसेरे च़ेव्रे पासन बिश्शोरे थिये, “तक्का, मेरी अम्मा त कने मेरे ढ्ला इना आन। ");
INSERT INTO bhd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","किजोकि ज़ै कोई परमेशरेरी मेर्ज़ी पुड़ च़लते, तैए मेरो ढ्ला, मेरी बेइन ते मेरी अम्मा आए।” ");
INSERT INTO bhd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","तैल्ला पत्ती, यीशु फिरी गलील समुन्दरेरे बन्ने लोकन शिक्षा देने लगो। मैन्हु केरि एत्री भीड़ तैस कां अकोट्ठी भोइ। यीशु समुन्दरे मां एक्की किश्ती मां च़ढ़ो ते बिश्शी जेव, ताके तै सेब्भी लोकन परमेशरेरी गल्लां केरि शिक्षा देइ सके। मैन्हु केरि सारी भीड़ तैसेरी गल्लां शुन्तां समुन्दरेरे बन्ने पुड़ खड़ी राई। ");
INSERT INTO bhd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","यीशुए तैनन् बेड़ि गल्लां मिसालन मां ज़ोई। तैनी शिक्षा देइतां तैन लोकन सेइं ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ई कहानी शुना! एक्सां अक बीज़ बेनेबालो बीज़ बेने जो जेव। ");
INSERT INTO bhd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","बीज़ बेते बार किछ बीज़ बत्तेरे ड्लेखी बिछ़ड़ू त च़ुड़ोल्लेईं एइतां तैन बीज़ च़ुनू। ");
INSERT INTO bhd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","किछ बीज़ घोड़नबाली ज़मीनी पुड़ बिछ़ड़ू, ज़ेड़ी तैस डुग्घी मित्ती न मेलनेरे वजाई सेइं तैन लूशी उग्गू त बूटो लगो। ");
INSERT INTO bhd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","पन ज़ैखन दिहाड़ो निस्सो, त तै निकड़ो बूटो फुक्कोई जेव। ते ज़ील न छ़ड्डनेरे वजाई सेइं शुक्की जेव। ");
INSERT INTO bhd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","होरू किछ बीज़ कंटां केरे झ़ैल्लन मां बिछ़ड़ू। ज़ैखन तैड़ी बूटो लगो, त कंटां केरे झ़ैल्लेईं बेड़ोइतां तै बूटो दबेइ छ़ड्डो, त तैनी बुटे फल न दित्तो। ");
INSERT INTO bhd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","पन किछ बीज़ रोड़ी ज़मीनी पुड़ बिछ़ड़ू, त तैन उग्गू त बेडोवं त फलदार भोवं। तैन मरां केन्ची बीज़े ट्लही गुणा फल दित्तो, त केन्ची बीज़े शठ गुणा, त केन्चे शौव गुणा।” ");
INSERT INTO bhd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ए मिसाल शुनानेरे बाद, यीशुए लोकन सेइं ज़ोवं, “ज़ै कोई समझ़नू चाते, तै ध्याने सेइं शुने त समझ़े।” ");
INSERT INTO bhd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","तैल्ला पत्ती, ज़ैखन यीशु मैन्हु केरि भीड़ी करां अलग थियो, त तैखन तैसेरे सैथेईं त कने तैसेरे 12 चेलेईं यीशु तैस मिसालेरे बारे मां पुच़्छ़ू। ");
INSERT INTO bhd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","यीशुए तैन सेइं ज़ोवं, “अवं तुसन परमेशरेरे राज़्ज़ेरो भेद समझ़ेईलो। पन होरि लोकां केरे लेइ मिसालन मां ज़ोवं गाते। ");
INSERT INTO bhd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ताके ज़ेन्च़रां परमेशरेरी किताबी मां लिखोरूए तेन्च़रां भोए कि, ‘ज़ैन अवं केरतईं, तैन तैना बार-बार हेरेले, पन तैना तैसेरो मतलब न बुज़्झ़ेले। ज़ैन अवं ज़ोतईं, तैन तैना बार-बार शुनेले, पन मेरी गल न समझ़ेले। एरू न भोए कि तैना अपने पापन करां मन फिरान त तैन केरे पाप माफ़ किये गान।’” ");
INSERT INTO bhd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","तैल्ला पत्ती, यीशुए तैन सेइं ज़ोवं, “कुन तुसेईं तै मिसाल न समझ़ी? अगर तुस तैस मिसाली न समझ़थ, त फिरी होरि सब मिसालां केन्च़रां समझ़ेले? ");
INSERT INTO bhd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","अवं तुसन तै मिसाल समझ़ताईं। बीज़ बेनेबालो तै आए, ज़ै परमेशरेरी गल्लां लोकन शुनाते। ");
INSERT INTO bhd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ज़ैना मैन्हु परमेशरेरी गल्लां शुन्तन, तैन मरां किछ लोक तैस बत्तेरे ज़ेरे आन, ज़ेड़ी बीज़ बिछ़ड़ते। तैना त परमेशरेरी गल्लां शुन्तन, पन शैतान अकदम एइतां तैन मैन्हु केरे दिले मरां परमेशरेरी गल्लां केड्डी छ़ड्ते। ");
INSERT INTO bhd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","किछ होरे लोक, ज़ैना परमेशरेरी गल्लां शुन्तन, तैना तैस घोड़नबैली ज़मीनेरे ज़ेरे आन। तैना परमेशरेरी गल्लां शुन्तन त खुशी सेइं तैन कबूल भी केरतन। ");
INSERT INTO bhd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","पन ज़ेन्च़रां निकड़ो बूटो घोड़नबैली ज़मीनी मां मित्ती घट भोनेरे वजाई सेइं लूशी लगते, तेन्च़रां एना मैन्हु भी भोतन। तैना मज़बूत विश्वास न रखन। एल्हेरेलेइ तैना थोड़े दिहाड़न तगर विश्वास रखतन। पन ज़ैखन परमेशरेरी गल्लां केरे मुताबिक च़लनेरे वजाई सेइं तैन पुड़ मुसीबतां एच्चन त कने ज़ैखन लोकन केरां सताए गातन, त तैखन तैना अकदम अपने विश्वास छ़ेडतां ठोकर खातन। ");
INSERT INTO bhd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","होरे किछ लोक, ज़ैना परमेशरेरी गल्लां शुन्तन, तैना तैस कंटां केरे झ़ैल्लां केरे ज़मीनेरे ज़ेरे आन। तैना परमेशरेरी गल्लां त शुन्तन, ");
INSERT INTO bhd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","पन तैना इस दुनियारी फिक्र केरतन, त कने दौलतरे वजाई सेइं धोखो खातन, त तैना बड़े चीज़ां केरू लालच़ केरतन। एसेरे वजाई सेइं तैना परमेशरेरी गल्लां बिसरी छ़ड्तन त तैन गल्लन पुड़ न च़लन। ");
INSERT INTO bhd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","पन किछ लोक, ज़ैना परमेशरेरी गल्लां शुन्तन त कने तैन पुड़ च़लतन, तैना तैस रोड़ी ज़मीनेरे ज़ेरे आन। तैना परमेशरेरी गल्लां शुन्तन त कबूल भी केरतन त फल देतन, मतलब की तैना परमेशरेरी गल्लां केरे मुताबिक ज़िन्दगी ज़ीतन। कोई ट्लही गुणा, कोई शठ गुणा त कोई शौव गुणा फल देतन।” ");
INSERT INTO bhd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","तैल्ला पत्ती, यीशुए मैन्हु केरि भीड़ी सेइं ज़ोवं, “कोई बलतो दीयो एन्तां हेटी मां या खट्टी हठ न रख्खे। पन केन्ची उच्ची ठैरी पुड़ रख्खो गाते। (ताके सारे घरे लौ भोए।) ");
INSERT INTO bhd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","कोई गल छ़प्पोरी न राली, पन सैरी गल्लां बेंदी भोली, ते न कोई भेद छ़प्पोरो रालो, पन सारो भेद बांदो भोलो। ");
INSERT INTO bhd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ज़ै कोई समझ़नू चाते, तै ध्याने सेइं शुने त समझ़े!” ");
INSERT INTO bhd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","तैल्ला पत्ती, यीशुए मैन्हु केरि भीड़ी सेइं ज़ोवं, “होशियार राथ कि अवं तुसन कुन शिक्षा देइ राओरोईं। मेरी शिक्षाई शुन्तां, ज़ेत्री तुस मेरी गल मन्नेले तेत्री परमेशर तुसन समझ़ देलो। हाँ, परमेशर तुश्शी समझ़ होरि भी बधालो। ");
INSERT INTO bhd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","किजोकि ज़ैस कां परमेशरेरी मर्ज़ी समझ़नेरी इच्छा आए, तैस परमेशर जादे समझ़ देलो। पन ज़ैस कां परमेशरेरी मर्ज़ी समझ़नेरी इच्छा नईं, तैस केरां, थोड़ी ज़ेरि समझ़, ज़ै तैस कां आए, तै भी नी गाली।” ");
INSERT INTO bhd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","तैल्ला पत्ती, यीशुए मैन्हु केरि भीड़ी सेइं ज़ोवं, “परमेशरेरू राज़ एरू ज़ेरू आए, कि अक मैन्हु ज़मीनी पुड़ बीज़ बेते। ");
INSERT INTO bhd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","तै मैन्हु हर राती झ़ुलते त दीसां बींझ़ते। तैन बीज़ उगने लग्गोरूए त बडोने लग्गोरूए, पन तैस पतो न च़ले कि तैन केन्च़रां भोते। ");
INSERT INTO bhd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","केन्चेरी मद्दतरे बगैर ज़मीन एप्पू फल आन्चे। पेइले मुन्केरे निस्तन, बादे मां शिल्लां निस्तन, तैल्ला पत्ती शिल्लन ग्लेव लगतन। ");
INSERT INTO bhd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","आखरी मां, ज़ैखन ग्लेव पेक्की गातन, तैखन अकदम तै मैन्हु कटाई केरनेरे लेइ मैन्हु भेज़ते, किजोकि कटाईरो वक्त ओरो भोते।” ");
INSERT INTO bhd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","तैल्ला पत्ती, यीशुए मैन्हु केरि भीड़ी सेइं ज़ोवं, “अस परमेशरेरू राज़्ज़ेरी मसाल कोस चीज़ी सेइं देइ सकतम? कोस मिसाली सेइं अस तैस समझ़ेइ सकतम? ");
INSERT INTO bhd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","परमेशरेरू राज़ शेरीएरे बीज़ेरू ज़ेरू आए (ज़ै शेरीयो इस्राएले मां भोते)। ज़ैखन तैन बीज़ ज़मीनी मां बेव गाते, तैन सारे बीज़न केरां निकड़ू भोते। ");
INSERT INTO bhd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","पन ज़ैखन तैन बीज़ बेव गाते, तै उगतां सारे निक्के-निक्के बुट्टन केरां बड्डो भोते। तैसेरी एत्री बेड्डी डेलड़ी निस्चन, कि अम्बरेरां च़ुड़ोल्ली तैसेरी छावी मां अपने आले बनेइ सकतन।” ");
INSERT INTO bhd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","एन्च़रां बेड़ि मिसालां ज़ोइतां, यीशु तैन लोकन परमेशरेरी गल्लां शुनातो थियो, ज़ेत्रू तैना शुनी सकते थिये। ");
INSERT INTO bhd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","तै हमेशा मिसाल देइतां परमेशरेरे राज़्ज़ेरे बारे मां तैन सेइं ज़ोतो थियो। पन ज़ैखन मैन्हु केरि भीड़ी मरां यीशु त तैसेरे चेले अलग बिश्ते थिये, तैखन यीशु अपने चेलन सेइं सैरी मिसालां केरो मतलब समझ़ोतो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","तैस दिहाड़ेरे बादे मां, ज़ैखन ड्लोझ़ भोइ, यीशुए अपने चेलन सेइं ज़ोवं, “एज्जा, अस गलील समुन्दरेरे पार च़लम।” ");
INSERT INTO bhd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","तैल्हेरेलेइ मैन्हु केरि भीड़ छ़ेडतां तैना तैस किश्ती मां च़ढ़े ज़ैस मां यीशु पेइलो थियो, त तैना तैट्ठां च़ले जे। होरि किछ किश्ती मां भी लोक तैन सेइं साथी जे। ");
INSERT INTO bhd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ज़ैखन तैना समुन्दर पार केरने लग्गोरे थिये, तैखन अक बड्डो तूफान च़लो, त छ़ेल्ली एड़ी तगर पुज़्ज़ी कि किश्ती पैनी सेइं भेरोई जेई। ");
INSERT INTO bhd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","पन यीशु किश्तेरी पेत्री पासे, शेराहने पुड़ क्रोड़ी रेखतां झ़ुल्लोरो थियो। तैखन तैसेरे चेलेईं तै बींझ़ेइतां तैस सेइं ज़ोवं, “हे गुरू, कुन तीं फिक्र नईं, अस त मरने बालेम!” ");
INSERT INTO bhd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","तैखन यीशुए उठतां तूफान डांटो, त समुन्दरे सेइं ज़ोवं, “शान्त रा, रुकी गा!” अकदम तूफान रुकी जेव त समुन्दर शान्त भोव। ");
INSERT INTO bhd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","तैखन यीशुए अपने चेलन सेइं ज़ोवं, “तुस किजो डरतथ? कुन तुसन हेजू भी मीं पुड़ विश्वास नईं?” ");
INSERT INTO bhd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","पन तैना बड़े डेरि जे त एप्पू मांमेइं ज़ोने लग्गे, “ए मैन्हु कौन आए कि तूफान त समुन्दर भी एसेरो हुक्म मन्तन!” ");
INSERT INTO bhd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","यीशु त तैसेरे चेले गलील समुन्दरेरे पार, गिरासेनी इलाके मां पुज़्ज़े। ");
INSERT INTO bhd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ज़ैखन यीशु किश्ती पुड़ेरां ओस्सो, त तैखन अक मैन्हु, ज़ैस पुड़ भूतां केरो सायो थियो, कब्रन मांमेइं यीशु कां मिलने अव। ");
INSERT INTO bhd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","तै मैन्हु कब्रस्ताने मां रातो थियो। (तै मैन्हु बड़ो खतरनाक थियो।) कोई तैस शंगली सेइं भी न बेंधी सकतो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","किजोकि (पेइले बड़े बार) लोकेईं तैसेरे हथ पाव शंगलन सेइं बंधोरे थिये। पन हर बार तै हथ्थां केरि शंगलां ट्लोड़तो थियो त पव्वां केरि शंगलां केरे टुक्ड़े-टुक्ड़े केरतो थियो। कोई तैस कैबू न केरि सकतो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","तै हमेशा रात-दिहाड़ी कब्रस्ताने मां त कने पहैड़न पुड़मेइं हन्ठतो थियो त चिन्डां मारतो थियो, त अपने आपे घोड़न सेइं ज़ख्मी केरतो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ज़ैखन तैनी मैने यीशु दूरेरां लाव, त तै दौड़तां यीशु कां अव ते तैस कां मथ्थो टेको। ");
INSERT INTO bhd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","यीशुए भूते सेइं ज़ोवं, “हे भूता, एस मैन्हु मरां निस्सी गा!” तैनी भूते ज़ोरे सेइं चिन्डां मेरतां ज़ोवं, “हे यीशु, परमप्रधान परमेशरेरा मट्ठा, मीं तीं सेइं कुन कम? अवं तीं परमेशरेरी कसम देताईं, मीं दुख न दे।” ");
INSERT INTO bhd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","एल्हेरेलेइ यीशुए तैस पुच़्छ़ू, “तेरू कुन नवं आए?” तैनी यीशु सेइं ज़ोवं, “मेरू नंव फौज आए, किजोकि अस बड़े आम।” ");
INSERT INTO bhd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","तैखन तैनी यीशु कां बड़ी मिन्नत की, “इस इलाके मरां असन बेइर न भेज़।” ");
INSERT INTO bhd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","तैड़ी पहैड़ी पुड़ सूरां केरो अक बड़ो घान च़ेरी राहोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","तैल्हेरेलेइ तैन भूतेईं यीशु कां मिन्नत की, “महरबानी केरतां असन उन सूरन मां भेज़ी दे ताके अस उन मां गाम!” ");
INSERT INTO bhd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","तैखन यीशुए तैनन्, सूरन मां गानेरी अज़ाज़त दित्ती, त तैना भूतां तैस मैन्हु मरां निस्तां सूरन मां जेआं। तैखन सूरां केरो घान, ज़ैस मां लगभग दूई हज़ार सूर थिये, टिब्बे पुड़ेरां बिछ़ड़तां अकदम समुन्दरे मां डुबतां मेरि जे। ");
INSERT INTO bhd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ज़ैखन सूरां केरे च़ारनेबालेईं एन हेरू, त तैना डेरि जे। तैनेईं तैट्ठां नेशतां नगरी मां त कने आसेपासेरे ड्लोंव्वन मां ए खबर शुनाई। तैल्हेरेलेइ लोक एप्पू हेरनेरे लेइ तैड़ी आए। ");
INSERT INTO bhd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ज़ैखन नगरेरे लोक यीशु कां पुज़्ज़े, त तैस मैन्हु, ज़ैस मां पेइले भूतां केरि फौजेरो सायो थियो, हुनी लिगड़ां लग्गोरे त कने होशी मां लेइतां डेरि जे। ");
INSERT INTO bhd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ज़ैनेईं तैना गल्लां पेइले लेवरी थी, तैनेईं तैस मैनेरे बारे मां ज़ैस पुड़ भूतेरो सायो थियो त कने तैन सूरां केरे बारे मां पूरो हाल लोकन शुनाव। ");
INSERT INTO bhd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","तैना यीशु कां मिन्नत केरतां ज़ोने लग्गे कि, “इश्शे इलाके मरां च़ेलि गा!” ");
INSERT INTO bhd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ज़ैखन यीशु वापस गानेरे लेइ किश्ती मां च़ढ़ने लगो, त तैनी मैने ज़ैस मां पेइले भूतां केरो सायो थियो, यीशु कां मिन्नत की कि, “मीं एप्पू सेइं साथी च़लने दे।” ");
INSERT INTO bhd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","पन यीशुए तै एप्पू सेइं साथी च़लने न दित्तो। पन तैनी तैस सेइं ज़ोवं, “अपने घरे जो गा त कने अपने लोकन सेइं ज़ो, कि प्रभु परमेशरे तीं पुड़ दया केरतां तेरे लेइ केत्रू बड्डू कम कियोरूए।” ");
INSERT INTO bhd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","एल्हेरेलेइ तै मैन्हु गेइतां दिकापुलिस इलाके मां लोकन शुनाने लगो कि यीशुए मेरे लेइ केत्रू बड्डू कम कियोरूए। सारे लोक ए गल शुन्तां हैरान भोइ जे। ");
INSERT INTO bhd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","तैल्ला पत्ती, यीशु फिरी किश्ती मां गलील समुन्दरेरे इस पासे वापस अव, त मैन्हु केरि बड़ी भीड़ तैस कां अकोट्ठी भोइ। यीशु समुन्दरेरे बन्ने पुड़ थियो। ");
INSERT INTO bhd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","तैखन याईर नंव्वेरो मैन्हु तैड़ी अव, ज़ै यहूदी लोकां केरे प्रार्थना घरेरे प्रधान्न मरां अक थियो। ज़ैखन तैनी यीशु लाव, त तैसेरे पावन पेव। ");
INSERT INTO bhd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","तैनी एन ज़ोइतां यीशुए सेइं बड़ी मिन्नत की, “मेरी निकड़ी कुई मरनेबाली आए। तू मीं सेइं साथी एइतां तैस पुड़ अपनो हथ रख, ताके तै बेज़्झ़ोए ते ज़ींती राए।” ");
INSERT INTO bhd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","एल्हेरेलेइ यीशु तैस सेइं साथी तैसेरे घरे जेव। मैन्हु केरि अक बड़ी भीड़ यीशु पत्ती च़ली, इड़ी तगर कि लोक यीशु पुड़ बिछ़ड़ते थिये। ");
INSERT INTO bhd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","तैस भीड़ी मां अक कुआन्श भी थी, ज़ैस 12 सालां केरि खून च़लनेरी बिमारी थी। ");
INSERT INTO bhd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","तैसां बड़े बेइदन केरां बड़ो दुख झ़ल्लो। बिमारी ठीक भोनेरे लेइ तैसां अपने सब पेंइसे खेर्च़ी दित्ते, पन तैस कोई फैइदो न भोव। पन तै होरि भी जादे बिमार भोइ जेई। ");
INSERT INTO bhd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","तै यीशुएरे बारे मां शुन्तां अपने दिले मां ज़ोती थी, “अगर अवं सिर्फ तैसेरे लिगड़े सेइं हथ लाएली, त अवं बेज़्झ़ोईं गाली।” एल्हेरेलेइ तै मैन्हु केरि भीड़ी मां यीशुएरे पत्रेवरां आई ते तैसेरे लिगड़े सेइं हथ लाव। ");
INSERT INTO bhd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ज़ैखन तैसां यीशुएरे लिगड़े सेइं हथ लाव, त अकदम तैसेरो खून च़लनेरी बिमारी बेज्झ़ोईं। तैसां अपनि जानी मां बुज़्झ़ू कि अवं तैस बिमारी केरां बेज्झ़ोरी आईं। ");
INSERT INTO bhd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","यीशुए अकदम बुज़्झ़ू कि मीं मरां शक्ति निस्सोरीए। एल्हेरेलेइ तैनी मैन्हु केरि भीड़ी मां च़ेव्रे पासन मुड़तां लोकन पुच़्छ़ू, “मेरे लिगड़े सेइं केनि हथ लाव?” ");
INSERT INTO bhd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","तैसेरे चेलेईं तैस सेइं ज़ोवं, “तू हेरतस कि मैन्हु केरि भीड़ तीं पुड़ बिछ़ड़ने लग्गोरी, फिर भी तू किजो पुछ़तस कि ‘केनि मीं सेइं हथ लाव’?” ");
INSERT INTO bhd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","पन यीशु तैस हेरनेरे लेइ, ज़ैनी एरू कियोरू थियूं, च़ेव्रे पासन तकने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","तैखन तै कुआन्श डरती ते थर्कती थी, किजोकि तै ज़ानती थी कि तेसां मूसेरो कानून ट्लोड़रोए। तै अग्गर आई ते यीशुएरे पावन पुड़ बिछ़ड़तां, तैस सेइं सैरी गल्लां सच़-सच़ ज़ोने लग्गी। ");
INSERT INTO bhd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","पन यीशुए तैस सेइं ज़ोवं, “हे कुईए, तेरे विश्वासे, ज़ै तीं मीं पुड़ रख्खोरो, तैनी तू बज्झ़ाई। खुशी सेइं घरजो गा, ते हुनी तू एस बिमारी केरां बेच़ी जेई।” ");
INSERT INTO bhd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ज़ताली यीशु ई गल मसां ज़ोई राओरो थियो, तैखन प्रार्थना घरेरे लीडरेरे घरेरां किछ मैनेईं एइतां तैस सेइं ज़ोवं, “तेरी कुई मेरि जोरीए, हुनी गुरू किजो तकलीफ देतस?” ");
INSERT INTO bhd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","पन यीशुए तैन केरि गल न शुन्तां प्रार्थना घरेरे लीडरे सेइं ज़ोवं, “न डर। सिर्फ मीं पुड़ विश्वास रख।” ");
INSERT INTO bhd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","यीशु ते याईर च़लने लग्गे, पन यीशुए पतरस, याकूब ते तैसेरो ढ्ला यूहन्नारे अलावा, होरो कोई एप्पू सेइं साथी एजने न दित्तो। ");
INSERT INTO bhd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","प्रार्थना घरेरे लीडरेरे घरे मां पुज़्तां यीशुए हल्लो मच़ोरो लाव ते कने लोक बड़े लेरां देते त शोग केरते लाए। ");
INSERT INTO bhd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","तैखन यीशुए घरे मां गेइतां तैन सेइं ज़ोवं, “तुस किजो रोलो मच़ातथ त लेरां देतथ? कुई मर्री नईं, पन झ़ुल्लोरीए।” ");
INSERT INTO bhd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ज़ैखन तैन लोकेईं एन शुनू, त तैना तैसेरो मज़ाक बनाने लग्गे, किजोकि तैना ज़ानते थिये कि कुई मेरि जोरीए। तैखन यीशुए सारे मैन्हु तैट्ठां केढतां, सिर्फ कुईअरे हाज-बव त कने अपने ट्लाई चेलन सेइं साथी कमरेरे अन्तर जेव, ज़ेड़ी कुई पेव्री थी। ");
INSERT INTO bhd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","तैखन यीशुए कुईएरो हथ ट्लेइतां तैस सेइं अपनि भाषाई मां ज़ोवं, “तलीता कूमी!” ज़ेसेरो मतलब कि, “हे निकड़ी कुईए, अवं तीं सेइं ज़ोतईं, खड़ी उठ!” ");
INSERT INTO bhd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","अकदम कुई उठतां च़लने फिरने लग्गी, किजोकि तै कुई 12 सालां केरि थी। एन हेरतां तैना बड़े हैरान भोए। ");
INSERT INTO bhd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","पन यीशुए तैन हुक्म देइतां ज़ोवं कि, “ए गल केन्ची सेइं न ज़ोइयथ। एस कुईए किछ खाने जो देथ।” ");
INSERT INTO bhd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","तैल्ला पत्ती, यीशु तैट्ठां निस्तां अपने नगर नासरते जो जेव। तैसेरे चेले तैस सेइं साथी च़ले। ");
INSERT INTO bhd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","आरामेरे दिहाड़े, यीशु तैन केरे प्रार्थना घरे मां गेइतां तैन लोकन परमेशरेरी गल्लां केरि शिक्षा देने लगो। तैसेरी शिक्षा शुन्तां बड़े लोक हैरान भोए ते एक्की होरि पुछ़ने लग्गे, “एनी मैने एना गल्लां कोट्ठां शिख्खी? एस एत्री अक्ल कोट्ठां आई? एस एत्रे चमत्कार केरनेरी शक्ति कोट्ठां मैल्ली! ");
INSERT INTO bhd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ए त ट्लखान आए, ज़ैन मरियमारू मट्ठू आए। ए त याकूब, योसेस, यहूदा, ते शमौनेरो ढ्ला आए! एसेरी बेइनां भी इश्शे इड़ी रेइचन!” एल्हेरेलेइ तैनेईं यीशुएरो इन्कार कियो। ");
INSERT INTO bhd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","तैखन यीशुए तैन लोकन अक कहावत ज़ोई, “नबी बेइरींए लोकन मां इज़्ज़तदार भोलो, पन अपने नगरेरे लोकन केरां ते कने अपने रिश्तेदारन केरां त कने अपने घरेबालन मां बेइज़्ज़त भोलो।” ");
INSERT INTO bhd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","तैन लोकेईं यीशु पुड़ विश्वास न केरनेरे वजाई सेइं, तैनी तैस नगरी मां सिर्फ थोड़े ज़ेरे बिमार मैनन् पुड़ हथ रेखतां तैना बज़्झ़ाए, तैन केरे अलावा होरो कोई चमत्कार न केरि सको। ");
INSERT INTO bhd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","यीशु नासरत नगरेरे लोकां केरो अविश्वास हेरतां हैरान भोव। तैल्ला पत्ती, तै अपने चेलन सेइं साथी च़ेव्रे पासन केरे ड्लोंव्वन मां परमेशरेरी गल्लां केरि शिक्षा देतो राव। ");
INSERT INTO bhd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","तैल्ला पत्ती, यीशुए अपने 12 चेले एप्पू कां कुजेइतां, तैन दूई-दूई केरतां भेज़ने लगो। भेज़ने केरां पेइले, तैनी अपने चेलन, लोकन मरां भूतां केरो सायो कढनेरो अधिकार दित्तो। ");
INSERT INTO bhd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ते तैनी तैन हुक्म दित्तो, “बत्तां च़लते-च़लते सोटेरे अलावा होरू किछ न नेइयथ। न रोट्टी न झोलो त कने बेटवे मां पेंइसे भी न नेइयथ। ");
INSERT INTO bhd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","पन बूट लेइयथ, पन दूई-दूई कुरते न लेइयथ। ");
INSERT INTO bhd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ज़ैखन तुस केन्ची ड्लोव्वें मां गाथ, अगर कोई अपने घरे बिश्नेरेलेइ तुसन कुजाए, त तैस्से घरे मां बिश्शथ, ज़ांतगर तैस ड्लोंव्वेरां न निस्सथ। ");
INSERT INTO bhd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","अगर केन्ची ड्लोंव्वेरे लोक तुसन कबूल न केरन त कने तुश्शी गल्लां न शुनन्, त तैट्ठां च़लते-च़लते तुस अपने पावां केरि धूड़ झ़ेड़ी छ़ेड्डथ ताके तैन केरे खलाफ गवाही भोए। (अवं तुसन सेइं सच़ ज़ोतईं कि परमेशरेरे आदालतरे दिहाड़े बुरे लोकन सज़ा देलो, ज़ैना सदोम त कने अमोरा नगरन मां रहते थिये। पन ज़ैना लोक तुश्शी गल्लां न शुनेले, तैस नगरेरे लोकन परमेशर बड़ी जादे सज़ा देलो)” ");
INSERT INTO bhd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","यीशुएरो हुक्म शुन्नेरे बाद, तैनेईं तैट्ठां निस्तां बड़े नगरन मां गेइतां लोकन परमेशरेरी गल्लां शुनेई कि, “तुस अपने पापन करां मनफिराथ।” ");
INSERT INTO bhd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ते तैनेईं बड़े लोकन मरां भूतां केरो सायो भी कड्डो, त कने बड़े बिमार मैनन् पुड़ तेल लेइतां बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","हेरोदेस राज़े भी यीशुएरे बारे मां शुनू, किजोकि यीशुएरू नंव मुशूर भोरू थियूं। तैनी यीशुएरे बारे मां ज़ोवं कि, “शायद, यूहन्ना, ज़ै बपतिस्मो देनेबालो थियो, मुड़दन मरां ज़ींतो भोरोए। एल्हेरेलेइ, तै एना चमत्कार केरि सकते।” ");
INSERT INTO bhd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","होरेईं मैनेईं यीशुएरे बारे मां ज़ोवं कि, “शायद, तै मैन्हु एलिय्याह नबी आए!” पन किछ होरेईं मैनेईं ज़ोवं कि, “तै त पराने ज़मानेरे परमेशरेरी गल्लां ज़ोनेबालां केरो ज़ेरो अक नबी आए!” ");
INSERT INTO bhd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","पन हेरोदेस राज़े लोकां केरि गल्लां शुन्तां ज़ोवं कि, “तै मैन्हु त यूहन्ना आए, ज़ेसेरी क्रोड़ी मीं कट्टेव्री थी। तै मुड़दन मरां ज़ींतो भोरो आए!” ");
INSERT INTO bhd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","हेरोदेस राज़े एन्च़रां सोचू, किजोकि थोड़े दिहाड़ना पेइले, तैनी एप्पू अपने सिपाही भेज़तां यूहन्ना कैद केरतां छ़ड्डोरो थियो। तैनी अपने ढ्ला फिलिप्पुसेरी लाड़ी हेरोदियासेरी वजाई सेइं एन्च़रां कियोरू थियूं, ज़ैस सेइं तैनी ड्ला बनोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","एल्हेरेलेइ, यूहन्ना हेरोदेस राज़े सेइं बार-बार ज़ोतो थियो कि, “तीं अपने ढ्लाएरी लाड़ी सेइं ड्ला बनानो जेइज़ नईं।” ");
INSERT INTO bhd_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","तैल्हेरेलेइ हेरोदियास रानी यूहन्ना सेइं दुश्मनी रखती थी ते तैस कत्ल केरनो चाती थी। पन तै तेन्च़रां न केरि सकती थी, ");
INSERT INTO bhd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","किजोकि हेरोदेस राज़े पतो थियो कि यूहन्ना अक धर्मी ते पवित्र मैन्हु थियो। तैल्हेरेलेइ, हेरोदेस राज़ो तैसेरी बड़ी इज़्ज़त केरतो थियो त कैदखाने मां हेरोदियास रैनी केरां बच़ेइतां रखतो थियो। त तै यूहन्नारी गल्लां शुन्तां बड़ो डरतो थियो, पन तैसेरी गल्लां खुशी सेइं शुन्तो भी थियो। ");
INSERT INTO bhd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","आखर्कार यूहन्ना मारनेरो ठीक मौको मैल्लो। हेरोदेस राज़े अपने ज़रमेरी दिहाड़ी मां अक धाम रख्खी। तैस धामी मां तैनी अपने बड़े खास अफसरन, त कने फौजी अफसरन, त कने गलील इलाकेरे बड्डे-बड्डे मैन्हु कुजाए। ");
INSERT INTO bhd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","तैखन हेरोदियास रैनेरी कुई तैस कमरे मां आई, ज़ेड़ी तैना बिश्शोरे थिये। त तैसां तैड़ी नेच़तां हेरोदेस राज़ो त कने तैसेरे मेहमान खुश किये। तैखन राज़े कुईए सेइं ज़ोवं, “ज़ैन तू चास मीं केरां मग, अवं तीं देलो।” ");
INSERT INTO bhd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","त राज़े तैस कुईए सेइं कसम भी खाइ कि, “ज़ैन किछ तू मीं केरां मग्गेली, अवं तीं देलो, इड़ी तगर कि अवं अपनू अध्धू राज़ भी देलो।” ");
INSERT INTO bhd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","तैल्हेरेलेइ तैस कुइयां बेइर गेइतां, अपनि अम्मा पुच़्छ़ू, “अवं हेरोदेस राज़े केरां कुन मेग्गी?” तैखन तैसेरी अम्मा ज़ोवं, “यूहन्ना बपतिस्मो देनेबालेरी क्रोड़ी मग।” ");
INSERT INTO bhd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","अकदम तै कुई अन्तर राज़े कां आई त तैस कां मिन्नत की, “अवं चाताईं कि, तू यूहन्ना बपतिस्मो देनेबालेरी क्रोड़ी केटतां एक्की थाले मां हुन्ना आन।” ");
INSERT INTO bhd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","तैसेरी गल शुन्तां राज़ो बड़ो दुखी भोव, पन अपनि कसमेरे वजाई सेइं त कने अपने मेहमानां केरे वजाई सेइं तैने इन्कार केरनो न चाव। ");
INSERT INTO bhd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","तैल्हेरेलेइ, तैनी अकदम एक्की सिपाही हुक्म दित्तो कि, “यूहन्नारी क्रोड़ी केटतां आन।” ");
INSERT INTO bhd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","सिपाही कैदखाने मां गेइतां यूहन्नारी क्रोड़ी कट्टाई, त एक्की थाले मां रेखतां आनी त कुईए कां दित्ती। त कुइयां गेइतां अपनि अम्मा कां दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ए गल शुन्तां यूहन्नारे चेले तैड़ी आए, त तैसेरी लाश नेइतां कब्री मां देब्बी छ़ड्डी। ");
INSERT INTO bhd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","परमेशरेरी गल्लां लोकन शुनानेरे पत्ती, यीशुएरे प्रेरित तैस कां वापस आए, ज़ैना तैनी भेज़ोरे थिये। ज़ैन किछ तैनेईं लोकन सेइं कियोरू ते शिक्षा दित्तोरी थी, तैन सारी गल्लां यीशु सेइं शुनाई। ");
INSERT INTO bhd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","बड़े लोक यीशु त कने तैसेरे चेलन कां एइते गाते थिये। एस वजाई सेइं, तैनन् रोट्टी खानेरे लेइ भी मौको न थियो मैल्लोरो। तैल्हेरेलेइ यीशुए अपने चेलन सेइं ज़ोवं, “मीं सेइं साथी केन्ची अकेन्ती ठैरी एज्जा, त थोड़ो ज़ेरो आराम केरा।” ");
INSERT INTO bhd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","एल्हेरेलेइ तैना किश्ती मां च़ेढ़तां, अकेन्ती ठैरी च़ेलि जे। ");
INSERT INTO bhd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","पन बड़े लोकेईं यीशु त तैसेरे चेले गाते लेइतां पिशानी छ़ड्डे कि तैना कोरां च़लोरेन। तैल्हेरेलेइ, सारे नगरेरे मैन्हु पैदल दौड़तां तैन केरां पेइले तैड़ी पुज़्तां अकोट्ठे भोए। ");
INSERT INTO bhd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ज़ैखन यीशु किश्ती पुड़ेरां ओस्सो, त तैनी मैन्हु केरि अक बड़ी भीड़ लेइतां तैन पुड़ तरस खाव, किजोकि तैना मैन्हु तैन भैड्डां केरे ज़ेरे थिये, ज़ैन केरो कोई पुहाल न भोए। तैखन यीशु तैन लोकन परमेशरेरे राज़्ज़ेरे बारे मां बेड़ि गल्लां केरि शिक्षा देने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ज़ैखन दिहाड़ी डुबने लग्गोरी थी, त यीशुएरे चेलेईं तैस कां एइतां ज़ोवं, “ई सुनसान ठार आए, ते च़िर भी बड़ू भोरू आए। ");
INSERT INTO bhd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","एन मैनन् भेज़, ताके एना च़ेव्रे पासां केरे बेस्तन त कने ड्लोंव्वन मां गेइतां अपने लेइ खाने जो रोट्टी घिन्न।” ");
INSERT INTO bhd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","पन यीशुए तैनन् जुवाब दित्तो कि, “तुस्से एन खाने जो रोट्टी देथ।” पन तैनेईं तैस सेइं ज़ोवं, “कुन अस दूई शौव दिहाड़ी केरि कमाई सेइं रोट्टी घिन्तां एन मैनन् खुवाम? एन न भोइ सके!” ");
INSERT INTO bhd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","एल्हेरेलेइ, यीशुए तैन सेइं ज़ोवं, “तुसन कां केत्री रोट्टी आन? गेइतां हेरा।” पतो केरनेरे पत्ती, तैनेईं यीशु सेइं ज़ोवं कि, “पंच़ रोट्टी त कने दूई मेछ़ली आन।” ");
INSERT INTO bhd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","तैखन यीशुए अपने चेलन हुक्म दित्तो कि, “सारे मैन्हु नीले घासे पुड़ बिशाला।” ");
INSERT INTO bhd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","एल्हेरेलेइ तैना मैन्हु शौव-शौव त कने पज़ां-पज़ां केरि हुन्डी मां बिश्शी जे। ");
INSERT INTO bhd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","तैखन यीशुए अपने हथ्थे मां पंच़ रोट्टी ते दूई मेछ़ली ट्लेइ, त अम्बरेरे पासे तेकतां शुक्र कियूं। तैल्ला पत्ती, यीशु तैना रोट्टी ट्लोड़तां चेलन कां देते जेव कि लोकन खाने जो देन। तेन्च़रां दूई मेछ़ली भी तैन सारे लोकन बेंटी दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ते सारे मैन्हु खेइतां रेज़्ज़ी जे। ");
INSERT INTO bhd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","तैल्ला पत्ती, यीशुएरे चेलेईं बेच़्च़ोरी रोट्टी त कने मेछ़ली केरे टुक्ड़न सेइं 12 टोकरी भेरि। ");
INSERT INTO bhd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ज़ैनेईं रोट्टी त मेछ़ली खेइ, तैन मां 5000 मड़द थिये। ");
INSERT INTO bhd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","तैल्ला पत्ती, यीशुए अपने चेलन हुक्म दित्तो कि, “तुस किश्ती मां च़ेढ़तां मीं केरां पेइले समुन्दरेरे उस पार बैतसैदा नगरे जो च़ली गाथ, ज़ांतगर अवं एन लोकन न भेज़ी।” त तैना तैट्ठां जे। ");
INSERT INTO bhd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","लोकन भेज़नेरे पत्ती, यीशु तैट्ठां निस्तां नेड़े एक्की पहैड़ी पुड़ प्रार्थना केरनेरे लेइ जेव। ");
INSERT INTO bhd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ज़ैखन ड्लोझ़ भोइ, त तै किश्ती, ज़ैस मां यीशुएरे चेले थिये, समुन्दरेरे मझ़ाटे थी, त यीशु अकैल्लो ज़मीनी पुड़ थियो। ");
INSERT INTO bhd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","तैनी हेरू कि तैसेरे चेले किश्ती मां च़ेप्पू देइ-देइ परेशान भोने लग्गोरेन, किजोकि एग्रोवरां बड़ी तेज़ हवा च़लोरी थी। लगभग झ़ेज़्झ़ेरे च़ेव्रे बज़ेई ज़ैखन हेजू आंधरू थियूं, यीशु समुन्दरेरे पैनी पुड़ च़ेलतां अपने चेलन कां अव। तै तैन केरां अग्रोवं निस्नू चातो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","पन ज़ैखन तैनेईं यीशु समुन्दरेरे पैनी पुड़ च़लतो लाव, त तैनेईं सोचो कि तै भूत आए। तैल्हेरेलेइ, तैनेईं चिन्डां मैरी, ");
INSERT INTO bhd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","किजोकि तैना सारे तैस हेरतां बड़े डेरि जोरे थिये। पन तैनी अकदम तैन सेइं गल्लां की ते ज़ोवं, “हिम्मत रखा! अवं आईं। डरा न!” ");
INSERT INTO bhd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","तैखन तै तैन केरि किश्ती मां च़ढ़ो, ते तूफान च़लनो बन्ध भोइ जेव। तैखन चेले बड़े हैरान भोए, ");
INSERT INTO bhd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","किजोकि तैनेईं न थियूं समझ़ोरू कि यीशु केन्च़रां रोट्टी त कने मेछ़ली बधोरी थी, पन तैन केरे मन बेसमझ़ भोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","तैल्ला पत्ती, यीशु त तैसेरे चेले गलील समुन्दर पार केरतां गन्नेसरत नंव्वेरे जगाई पुड़ पुज़्ज़े। तैड़ी तैनेईं किनारे पुड़ किश्ती बेंधतां रख्खी। ");
INSERT INTO bhd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ज़ैखन तैना किश्ती पुड़ेरां ओस्से, त तैट्ठेरे लोकेईं यीशु पिशैनी छ़ड्डो। ");
INSERT INTO bhd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","एल्हेरेलेइ, तैनेईं सारे इलाके मां गेइतां लोकन खबर शुनाई कि यीशु ओरोए। ज़ेड़ी-ज़ेड़ी लोकेईं शुनू कि यीशु ओरोए, तैड़ी लोकेईं बिमार मैन्हु खट्टी पुड़ छ़ुइतां यीशु कां आन्ने लग्गे, ताके तै तैनन् बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ज़ेड़ी कोन्ची ड्लोंव्वन मां, नगरन या बेस्तन मां यीशु गातो थियो, तैड़ी लोक बिमार मैनन् बज़ारन मां यीशु कां एन्तां रखते थिये। तैना यीशु सेइं मिन्त केरते थिये कि, तैन सिर्फ तैसेरे लिगड़े सेइं हुरने देन। ज़ेत्रे बिमार मैन्हु यीशु सेइं हथ लाते थिये, तैना सारे बेज़्झ़ोते थिये। ");
INSERT INTO bhd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","एक्की दिहाड़े किछ फरीसी लोक त कने शास्त्री लोकन मरां किछ लोक, ज़ैना यरूशलेम नगरेरां ओरे थिये यीशुए कां अकोट्ठे भोए। ");
INSERT INTO bhd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ते तैनेईं हेरू कि यीशुएरे किछ चेले रीति रुवाज़ेरे खलाफ अधोए हथ्थन सेइं रोट्टी खेइ राओरेन। ");
INSERT INTO bhd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","किजोकि फरीसी लोक त कने सारे यहूदी लोक, ज़ांतगर हथ न धोन तांतगर रोट्टी न खाते थिये। अपने बुज़ुर्गां केरि परमपरा च़लानेरे लेइ तैना एन्च़रां केरते थिये। ");
INSERT INTO bhd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ज़ैखन तैना बज़ारेरां घरे एइते थिये, ज़ांतगर तैना निहान न देन तांतगर रोट्टी न थिये खाते। होरे भी बड़े रीति रुवाज़ थिये, ज़ैना तैन केरे बुज़ुर्गन केरां ओरे थिये, ज़ेन्च़रां कटोरे, घड़े, ट्लामेरां भांडां रुवाज़ेरे मुताबिक धोना। ");
INSERT INTO bhd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","एल्हेरेलेइ फरीसी लोकेईं त कने शास्त्री लोकेईं यीशु पुच़्छ़ू, “तेरे चेले इश्शे बुज़ुर्गां केरि परमपरा पुड़ की न च़लन? पन तैना रुवाज़ेरे खलाफ अधोए हथ्थन सेइं रोट्टी खातन!” ");
INSERT INTO bhd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","तैखन यीशुए तैन सेइं ज़ोवं, “बड़े पेइले यशायाह नेबे तुश्शे ज़ेरे पाखंडी केरे बारे मां ठीक भविष्यिवाणी कियोरीए कि परमेशरे ज़ोवं, ‘एना लोक ऐशी सेइं त मेरी बड़ी तारीफ़ केरतन, पन एन केरे दिल मीं केरां बड़े दूर आन। ");
INSERT INTO bhd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","एना बेफाइदी मेरी आराधना (पूजा) केरतन, किजोकि एना त मैन्हु केरि बनोरी परमपरान, परमेशरेरे हुक्मां केरे ज़ेरे लोकन शिक्षा देतन।’” ");
INSERT INTO bhd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","तैखन यीशुए तैन सेइं ज़ोवं, “तुस भी तैन लोकां केरे ज़ेरे आथ, ज़ैना परमेशरेरे हुक्मन टेलतां मैन्हु केरि बनोरी परमपरान मन्तन, ज़ेन्च़रां घड़े त कने कटोरे रुवाज़ेरे मुताबिक धोने, त कने एसेरे ज़ेरे होरे भी बड़े रूवाज़न मन्तथ।” ");
INSERT INTO bhd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","फिरी तैनी तैन सेइं ज़ोवं, “तुस केत्रू गलत केरतथ, कि अपने रीति-रुवाज़ मन्नेरे लेइ परमेशरेरे हुक्म ट्लोड़तथ। ");
INSERT INTO bhd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","किजोकि मूसा नेबे ज़ोरूए कि, परमेशरे सारी मैनन् ई हुक्म दित्तो कि, ‘तू अपने हाज बव्वेरी केरि इज़्ज़त केर। त ज़ै कोई अपने हाज बव्वे जो बुरू ज़ोलो, तै ज़रूर मारो गालो।’ ");
INSERT INTO bhd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","पन तुस ज़ोतथ कि अगर कोई मैन्हु अपने हाज बव्वे सेइं सिर्फ एन ज़ोए, त तैन बड़ू आए कि, ‘मीं करां ज़ै किछ मद्दत तुसन मैल्ली सकती थी, तै पेइली बलिदान भोरीए, यानी परमेशरे जो च़ढ़तल च़ाढ़ोरीए। एल्हेरेलेइ, अवं तुसन किछ न देइ सकी।’ ");
INSERT INTO bhd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","एरी शिक्षा देइतां तुस लोकन तैन केरे हाज बव्वां केरि किछ मद्दत केरने न देथ। ");
INSERT INTO bhd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","एन्च़रां तुस अपनि परमपरा च़लानेरे लेइ, परमेशरेरी गल्लां टेली छ़ड्तथ। एरी ज़ेरि तुस होरि भी बेड़ि गलत परमपरा मन्ते ओरेथ।” ");
INSERT INTO bhd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","तैखन यीशुए फिरी सारे लोक एप्पू कां कुजेइतां तैन सेइं ज़ोवं, “तुस सारे लोक, मेरी गल ध्याने सेइं शुना ते समझ़ा। ");
INSERT INTO bhd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","एरी कोई चीज़ नईं ज़ै बेइरेरां मैनेरे अन्तर गेइतां तैस ज़ुट्ठो केरे। पन ज़ैना बुरी चीज़ां मैनेरे अन्त्रां, यानी तैसेरे दिले मरां बेइर निस्चन, तैन्नां तैस ज़ुट्ठो केरचन। ");
INSERT INTO bhd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","अगर कोई समझ़नो चाते, त तै ध्याने सेइं शुने!” ");
INSERT INTO bhd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","बादे मां, यीशु मैन्हु केरि भीड़ी मरां घरे जो जेव। तैखन तैसेरे चेलेईं तैस मिसालारे मतलबेरे बारे मां तैस पुच़्छ़ू। ");
INSERT INTO bhd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","तैनी तैन सेइं ज़ोवं, “होरि मैन्हु केरे ज़ेरे कुन तुस भी न समझ़थ? कुन तुस न समझ़थ कि ज़ै चीज़ बेइरां मैनेरे अन्तर गाचे, तै तैस ज़ुट्ठो न केरि सके? ");
INSERT INTO bhd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","किजोकि तै तैसेरे दिले मां नईं, पन तैसेरे पेटे मां गाचे ते बादे मां पेटे मरां निस्सी गाचे!” एन ज़ोइतां यीशुए समझ़ावं कि खानेरी चीज़ कोई भी असन ज़ुट्ठो न केरे। ");
INSERT INTO bhd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","तैखन तैनी अपने चेलन सेइं ज़ोवं, “ज़ैन मैनेरे अन्त्रेरां निस्ते, तैन्ने परमेशरेरी नज़री मां मैन्हु ज़ुट्ठो केरते, ");
INSERT INTO bhd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","किजोकि मैनेरे अन्त्रेरां, यानी मैनेरे दिले मरां बुरे खियाल, बदमाशी, च़ोरी, कत्ल केरनो, ");
INSERT INTO bhd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","अड्लाए देइने गलत कम केरनू, लालच़, दुष्ट कम केरनू, बेइमानी, बदचलन, जलन, तुहीन, घमण्ड, ते बेवकूफी एच्चन। ");
INSERT INTO bhd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","एना सैरी बुरी गल्लां मैनेरे अन्त्रेरां, यानी दिले मरां निस्तां मैन्हु ज़ुट्ठो केरचन।” ");
INSERT INTO bhd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","तैल्ला पत्ती, यीशु तैट्ठां निस्तां सूर त सैदा नगरेरे आसेपासेरे इलाकेरे नेड़े अव। ते तैड़ी तै एक्की घरे मां जेव। ते तै चातो थियो कि कोई न ज़ैनी सके कि अवं इड़ी आईं। पन तै छ़ेप्पी न सको। ");
INSERT INTO bhd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","तैड़ी अक कुआन्श थी, ज़ेसेरी निकड़ी कुईए पुड़ भूतेरो सायो थियो। तै यीशुएरे बारे मां शुन्तां अकदम तैड़ी आई ते तैसेरे पावन पुड़ पेई। ");
INSERT INTO bhd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","त तै कुआन्श गैर कौमरी थी ते सुरूफिनिकी इलाकेरी थी। तैसां यीशु सेइं मिन्नत की कि, “मेरी कुईए पुड़ेरां भूतेरो सायो केड्डी देथ।” ");
INSERT INTO bhd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","पन यीशुए तैस सेइं ज़ोवं, “पेइले बच्चन रज़ने दे, किजोकि बच्चां केरि रोट्टी नेइतां कुतरन जो देनी ठीक नईं!” ");
INSERT INTO bhd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","तैसां जुवाब दित्तो, “सच़्च़े, प्रभु! पन कुतरां भी मेज़े हेठोरां बच्चां केरि रोट्टन मरां बिछ़ड़ोरे टुक्ड़े खातन।” ");
INSERT INTO bhd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","तैखन यीशुए तैस सेइं ज़ोवं, “मीं पुड़ तीं एत्रो विश्वास रख्खोरोए, एल्हेरेलेइ तू आरामे सेइं घरे जो गा। तेरी कुईए मरां भूतेरो सायो निस्सी जोरोए।” ");
INSERT INTO bhd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","तैसां कुआन्शां तैट्ठां अपने घरे वापस एइतां हेरू कि कुई खट्टी पुड़ आरामे सेइं झ़ुल्लोरी थी, त भूतेरो सायो तैस मरां निस्सी जोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","यीशु फिरी अपने चेलन सेइं साथी सूर त सैदारे नगरेरे इलाकन मरां निस्तां, दिकापुलिस इलाके मांमेइं भोइतां गलील समुन्दरेरे नेड़े पुज़्ज़ो। ");
INSERT INTO bhd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","तैड़ी किछ लोकेईं अक टोव्नो मैन्हु, ज़ै खेख्खो भी थियो, यीशु कां एन्तां तैस सेइं मिन्नत की कि, “तू अपनो हथ एस पुड़ रख कि ए मैन्हु बेज़्झ़ोए।” ");
INSERT INTO bhd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","यीशुए मैन्हु केरि भीड़ी मरां तै मैन्हु अलग नीयो। तैखन तैनी अपनि एंगलोई तैस मैनेरे कन्न मां छ़ेड्डी, त अपनि एंगलोई सेइं थुक तैस मैनेरी ज़िभ्भी सेइं लावं। ");
INSERT INTO bhd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","तैल्ला पत्ती, यीशु अम्बरेरे पासे तेकतां ओशा छ़ड्डो, त तैस मैन्हु सेइं अपनि (इब्रानी) भाषाई मां ज़ोवं, “इप्‍फत्तह!” ज़ेसेरो मतलब “खुल्ली गा!” ");
INSERT INTO bhd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","अकदम तै रोड़ेच़ारे शुन्ने लगो ते तैसेरी ज़िभ भी ठीक भोइ जेई, ते तै साफ-साफ गल्लां केरने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","तैखन यीशुए तैन मैनन् हुक्म दित्तो कि, “ए गल केन्ची सेइं न ज़ोइयथ।” पन ज़ेत्रू जादे यीशुए तैनन् हुक्म दित्तोरो थियो, तेत्रू जादे तैना होरि लोकन ए गल शुनाने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","यीशुएरे चमत्कारेरां कम्मां केरे वजाई सेइं, तैना बड़े हैरान भोइतां ज़ोने लग्गे, “कमाल आए! यीशुए ज़ैन किछ भी कियूं सब किछ रोड़ू कियोरूए! तै टोव्नन शुन्नेरी ते लट्टन गल्लां केरनेरी शक्ति देते।” ");
INSERT INTO bhd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","तैन दिहाड़न मां एरू भोव कि, मैन्हु केरि बड़ी भीड़ यीशु कां फिरी अकोट्ठी भोइ। तैन कां किछ खाने जो न थियूं। तैखन यीशुए अपने चेले एप्पू कां कुजेइतां तैन सेइं ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“मीं एन मैन्हु केरि भीड़ी पुड़ तरस एइते, किजोकि एना ट्लेइ दिहाड़ां केरे देंते मीं सेइं साथी आन, ते एन कां खाने जो किछ नईं राओरू। ");
INSERT INTO bhd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","अगर अवं एन ढ्लुख्खोरे घरे जो भेज़ी, त च़लते-च़लते बत्ती मां थेकतां रेइ गानेन, किजोकि एन मरां कोई-कोई दूरेरां भी आन।” ");
INSERT INTO bhd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","तैसेरे चेलेईं तैस जुवाब दित्तो, “इड़ी सुनसान ठैरी एन मैनन् जो एत्री रोट्टी कोट्ठां आनम कि एन मैन्हु रेज़तां खान?” ");
INSERT INTO bhd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","तैखन यीशुए तैन पुच़्छ़ू, “तुसन कां केत्री रोट्टी आन?” तैनेईं जुवाब दित्तो, “सत रोट्टी आन।” ");
INSERT INTO bhd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","तैखन यीशुए मैन्हु केरि भीड़रे पासे मुड़तां तैन जो हुक्म दित्तो कि, “ज़मीनी पुड़ बिश्शी गाथ।” तैखन तैनी तैन सत रोट्टी ट्लेइतां परमेशरेरू शुक्र केरतां ट्लोड़ी, ते अपने चेलन कां देते जेव कि तैना लोकन खाने जो देन। ते चेलेईं मैनन् रोट्टी दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","तैन कां थोड़ी ज़ेरि निक्की मेछ़ली भी थी। यीशुए मेछ़ली केरे लेइ भी परमेशरेरू शुक्र केरतां अपने चेलन सेइं ज़ोवं, “इना भी लोकन खाने जो देथ।” तेन्च़रां तैसेरे चेलेईं कियूं। ");
INSERT INTO bhd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","तैना सारे मैन्हु रोट्टी खेइतां रेज़्ज़ी जे। तैल्ला पत्ती, यीशुएरे चेलेईं मेछ़ली त कने रोट्टी केरे बच़्च़ोरे टुक्ड़न मरां सत टोकरे भेरतां सल्ले। ");
INSERT INTO bhd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","तैड़ी लगभग 4000 मड़द थिये। लोकन रोट्टी खुवानेरे पत्ती यीशुए मैन्हु भेज़ी दित्ते। ");
INSERT INTO bhd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","तैखन तै अकदम अपने चेलन सेइं साथी किश्ती मां च़ेढ़तां दलमनूता इलाके जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","फिरी किछ फरीसी लोक यीशु कां एइतां तैस सेइं बेंस केरने लग्गे। तैना तैस अज़मानेरे लेइ तैस पुछ़ने लग्गे, “असन अम्बरेरां कोई निशान हिरा।” ");
INSERT INTO bhd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ज़ैखन यीशुए एन शुनू, त तैनी अक बड्डो ओशा छ़ेडतां ज़ोवं, “इस ज़मानेरे लोक मीं केरां किजो निशान मगतन! अवं तुसन सेइं सच़ ज़ोतईं कि इस ज़मानेरे लोकन, यानी तुसन अवं कोई भी निशान न हिरेईं।” ");
INSERT INTO bhd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","तैल्ला पत्ती, यीशु तैन लोकन छ़ेडतां, फिरी किश्ती मां च़ढ़ो ते गलील समुन्दरेरे पार च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ज़ैखन यीशुएरे चेले किश्ती मां च़ढ़े, त तैना एप्पू सेइं साथी रोट्टी नेनी बिसरी जे। किश्ती मां तैन कां अक्के रोट्टी थी। ");
INSERT INTO bhd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ज़ैखन तैना समुन्दरे पार केरि राओरे थिये, त यीशुए तैन समझ़ावं कि, “खबरदार! फरीसी लोकां केरे खमीरेरे बारे मां ते कने हेरोदेस राज़ेरे खमीरेरे बारे मां होशियार रेइयथ।” ");
INSERT INTO bhd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","चेले यीशुएरी गल गलत सेमझ़तां एप्पू मांमेइं गलबात केरने लग्गे कि, “असन कां त रोट्टी नईं, एल्हेरेलेइ यीशुए एन्च़रां ज़ोवं।” ");
INSERT INTO bhd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","तैखन यीशुए तैन केरि गल ज़ेनतां, तैन सेइं ज़ोवं, “तुस एप्पू मांमेइं एन्च़रां किजो सोची राओरेथ कि असन कां रोट्टी नईं? कुन तुस हेजू भी मेरी गल न समझ़ी ते कने न बुझ़ी? कुन तुश्शे मन बेसमझ़ भोइ जोरेन? ");
INSERT INTO bhd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","कुन तुसन एछ़्छ़ी भोइतां भी न लेइहोए? ते कन भोइतां भी न शुनोए? कुन तुसन याद नईं? ");
INSERT INTO bhd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ज़ताली 5000 मैन्हु केरे लेइ पंच़ रोट्टी ट्लोड़तां दित्तोरी थी, त तुसेईं बादे मां बच़्च़ोरी रोट्टी केरे केत्रे टोकरे भेरतां सल्लोरे थिये?” तैनेईं तैस जुवाब दित्तो, “बारहे टोकरे।” ");
INSERT INTO bhd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","तैखन तैनी तैन पुच़्छ़ू, “ज़ताली मीं 4000 मैन्हु केरे लेइ सत रोट्टी ट्लोड़तां दित्तोरी थी, त तुसेईं रोट्टी केरे केत्रे टोकरे भेरतां सल्लोरे थिये?” तैनेईं तैस जुवाब दित्तो, “सत टोकरे।” ");
INSERT INTO bhd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","तैखन तैनी तैन पुच़्छ़ू, “कुन तुसन हेजू भी समझ़ न आई?” ");
INSERT INTO bhd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","तैल्ला पत्ती, यीशु त तैसेरे चेले बैतसैदा नगरे मां आए। लोकेईं अक कानो मैन्हु यीशु कां आनो ते तैस कां मिन्नत की कि, “एस मैन्हु सेइं हथ लाथ ताके ए बेज़्झ़ोए।” ");
INSERT INTO bhd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","तैखन यीशुए तैस काने मैनेरो हथ ट्लेइतां ड्लोंव्वे केरां बेइर नीयो। तैखन तैनी तैस काने मैनेरी एछ़्छ़न पुड़ थुकतां, तैस पुड़ हथ रखे, ते तैस पुच़्छ़ू, “कुन तू किछ लातस?” ");
INSERT INTO bhd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","तैखन तैनी मैने उबरे तेकतां ज़ोवं, “हाँ, अवं मैनन् हेरी सकतईं, तैना मीं च़लते बुट्टां केरे ज़ेरे लेइहोतन।” ");
INSERT INTO bhd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","तैखन यीशुए दुइयोवं हटे तैसेरी एछ़्छ़न पुड़ हथ रखे। तै कानो ध्याने सेइं लाने लगो। तैसेरी एछ़्छ़ी ठीक भोइ जेई, त तै सब किछ साफ-साफ हेरने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","तैल्ला पत्ती, यीशुए तै मैन्हु एन ज़ोइतां घरे जो भेज़ो, “तू इस ड्लोंव्वे मां पाव भी न रेखां (ते कने ई गल केन्ची सेइं न ज़ोइयां।)” ");
INSERT INTO bhd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","तैल्ला पत्ती, यीशु ते तैसेरे चेले बैतसैदा नगरे मरां निस्तां कैसरिया-फिलिप्पी नंव्वेरे नगरेरे ड्लोंव्वन मां च़ेलि जे। बत्तां च़लते-च़लते यीशुए अपने चेलन पुच़्छ़ू, “ज़ैखन लोक मेरे बारे मां गल्लां केरतन, त तैना मेरे बारे मां कुन ज़ोतन कि अवं कौन आईं?” ");
INSERT INTO bhd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","तैसेरे चेलेईं जुवाब दित्तो, “किछ ज़ोतन कि तू यूहन्ना आस, ज़ै बपतिस्मो देनेबालो थियो, पन किछ होरे मैन्हु ज़ोतन कि तू एलिय्याह आस, ज़ै नबी थियो, पन किछ होरे मैन्हु एन भी ज़ोतन कि तू परमेशरेरी गल्लां ज़ोनेबालन मरां अक मैन्हु आस।” ");
INSERT INTO bhd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","तैखन यीशुए अपने चेलन पुच़्छ़ू, “पन तुस मेरे बारे मां कुन सोचतथ कि अवं कौन आईं?” पतरसे जुवाब दित्तो, “तू मसीह आस।” ");
INSERT INTO bhd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","त यीशुए तैनन् समझ़ावं कि, “मेरे बारे मां ई गल केन्ची सेइं न ज़ोइयथ।” ");
INSERT INTO bhd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","तैखन यीशु अपने चेलन शिक्षा देनो लगो कि, “मैनेरे मट्ठेरे लेइ, यानी मेरे लेइ एन ज़रूरी आए कि मीं बड़े दुख झ़ल्लनेन। यहूदी लोकां केरे बुज़ुर्गन, प्रधान याजकन, त कने शास्त्री लोकन केरां अवं निकम्मो समझ़ो गानोईं त मारो गानोईं। पन ट्लेइ दिहाड़ना पत्ती अवं फिरी ज़ींतो भोनोईं।” ");
INSERT INTO bhd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","यीशुए एना गल्लां तैन सेइं साफ-साफ ज़ोई। तैखन पतरस तैस अलग नेइतां डांटने लगो, “मसीह न मरे।” ");
INSERT INTO bhd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","पन यीशुए मुड़तां अपने बाकी चेलां केरे पासे तक्कू, ते पतरसे सेइं झ़िड़केइतां ज़ोवं, “हे शैतान, मीं करां दूर भो! (मतलब एन्च़रां न सोच! शैतान तीं करां एन्च़रां ज़ुवाते) मीं केरां दूर भोइ गा। तू परमेशरेरी गल्लन पुड़ नईं, पन मैन्हु केरि गल्लन पुड़ मन लातस।” ");
INSERT INTO bhd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","तैखन यीशुए अपने चेले त कने मैन्हु केरि भीड़ एप्पू कां कुजेइतां सेब्भन सेइं ज़ोवं, “तुस अगर मेरे चेलो बन्नू चातथ, त तुस अपने आपेरो इन्कार केरा त कने तुस अपनू क्रूस छ़ुइतां मीं पत्ती च़ला। ");
INSERT INTO bhd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","किजोकि ज़ै कोई अपनि ज़िन्दगी बच़ानी चाते, त तै हमेशारी ज़िन्दगी गुवालो। पन ज़ै कोई मेरे वजाई सेइं त कने मेरे बारे मां खुशखबरी होरि लोकन शुनानेरी वजाई सेइं अपनि ज़िन्दगी गुवाते, यानी बलिदान केरते, त तै तैस बच़ालो, यानी हमेशारी ज़िन्दगी हासिल केरेलो। ");
INSERT INTO bhd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","मैन्हु अगर सारी दुनियाई हासिल केरे त अपनि हमेशारी ज़िन्दगी गुवाए, त तैस फिरी कुन फैइदो भोलो? ");
INSERT INTO bhd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","मैन्हु अगर अपनि हमेशारी ज़िन्दगी गुवालो, त गुवानेरे पत्ती तै कुन देइतां तैस वापस घिन्नी सकते? ");
INSERT INTO bhd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","अज़्ज़ेरे ज़मानेरे लोक परमेशरे करां दूरन त कने पापी आन। एस ज़माने मां, अगर कोई मैन्हु मीं केरां त कने मेरी गल्लन केरां शरमाते, त मैनेरू मट्ठू भी, यानी अवं भी तैस केरां शरमालो। ज़ेइस अवं अपने बाजी केरि महिमा सेइं साथी त कने पवित्र स्वर्गदूतन सेइं साथी वापस एज्जलो, त तेइस अवं तैस केरां भी शरमालो।” ");
INSERT INTO bhd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","तैखन यीशुए तैन सेइं ज़ोवं, “अवं तुसन सेइं सच़ ज़ोतईं कि ज़ैना इड़ी खड़े आन, तैन मरां किछ मैन्हु एरे आन कि ज़ांतगर तैना परमेशरेरे राज़्ज़ेरी शक्ति न हेरेले, तांतगर तैना न मरेले।” ");
INSERT INTO bhd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","शेइ दिहाड़ना बाद, यीशु अपने चेले पतरस, याकूब त कने यूहन्ना सेइं साथी एक्की पहाड़े पुड़ च़ढ़ो, ज़ेड़ी कोई भी न थियो। तैड़ी तैन केरे सामने यीशुएरी शकल बेदलोई जेई। ");
INSERT INTO bhd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","तैसेरां लिगड़ां हियूंवेरां ज़ेरां बड़ां चमकने लग्गां कि एत्रे छ़ित्तां भुआं कि धेरती पुड़ कोई भी लिगड़ां धोनेबालो एरां ज़ेरां छ़ित्तां न केरि सके। ");
INSERT INTO bhd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","तैखन तैड़ी मूसा नबी त कने एलिय्याह भी यीशु सेइं साथी लेइहोए। ते तैना यीशु सेइं गल्लां केरने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ज़ैखन पतरसे एन हेरू, त तैनी यीशु सेइं ज़ोवं, “हे गुरू, इश्शू इड़ी रानू रोड़ू आए! एल्हेरेलेइ, अस ट्लाई डेरे बनाम, अक तेरे लेइ, अक मूसेरे लेइ, त कने अक एलिय्याहेरे लेइ।” ");
INSERT INTO bhd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","पतरसे एन्च़रां एल्हेरेलेइ ज़ोवं किजोकि तैस पतो न थियो कि कुन ज़ोईं, किजोकि तै त कने होरे दूई चेले भी बड़े डेरि जोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","तैखन तैड़ी तैन पुड़ बिदलार आई ते तैस बिदलारी मरां परमेशरेरी आवाज़ आई, “एन मेरू ट्लारू मट्ठू आए। ध्याने सेइं एसेरी गल शुना!” ");
INSERT INTO bhd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","अकदम, ज़ैखन यीशुएरे चेलेईं च़ेव्रे पासन तक्कू, त यीशुएरे अलावा तैड़ी तैन कोई भी न लेइहोव। ");
INSERT INTO bhd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","पहाड़े पुड़ेरां ओस्ते-ओस्ते यीशुए अपने चेलन हुक्म दित्तो कि, “ज़ांतगर मैनेरू मट्ठू, यानी अवं, मेरतां ज़ींतो न भोईं, तांतगर ज़ैन किछ तुसेईं पहाड़े पुड़ लावरूए, तैन केन्ची सेइं न ज़ोइयथ।” ");
INSERT INTO bhd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","तैनेईं तैन केन्ची सेइं न ज़ोवं, ते तैना एप्पू मांमेइं गलबात केरने लग्गे कि, “मेरतां ज़ींतो भोनेरो कुन मतलब भोइ सकते।” ");
INSERT INTO bhd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","तैखन तैनेईं यीशुए पुच़्छ़ू, “शास्त्री लोक किजो ज़ोतन कि मसीहेरे एजनेरां पेइले एलिय्याह नेबेरू दुनियाई मां एजनू ज़रूरी आए?” ");
INSERT INTO bhd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","यीशुए तैन जुवाब दित्तो, “ते तै सच़्च़ी गल आए कि मसीहेरे एजने केरां पेइले एलिय्याह एजतां सैरी गल्लां ठीक केरनिन। पन परमेशरेरी किताबी मां मैनेरे मट्ठेरे बारे मां, यानी मेरे बारे मां एन किजो लिखोरूए कि, ‘मीं बड़े दुख झ़ल्लनेन त लोक मीं निकम्मो समझ़ेले?’ ");
INSERT INTO bhd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","पन अवं तुसन सेइं ज़ोतईं कि ‘एलिय्याह’ त पेइले ओरोए, (यूहन्ना, एलिय्याहरे जगाई अव) त ज़ेन्च़रां तैसेरे बारे मां परमेशरेरी किताबी मां लिखोरू थियूं, तेन्च़रां तैनेईं तैस सेइं कियूं, यानी ज़ेन्च़रां तैना चाते थिये, तेन्च़रां तैनेईं तैस सेइं बुरू कियूं।” ");
INSERT INTO bhd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","तैल्ला पत्ती, यीशु त तैसेरे ट्लाई चेले पहाड़े पुड़ेरां ओस्तां, होरि चेलन कां पुज़्ज़े, ज़ैना बुन थिये। तैड़ी एजतां यीशुए तैन चेलन केरे च़ेव्रे पासन मैन्हु केरि बड़ी भीड़ लाई। शास्त्री तैन चेलन सेइं बेंस केरि राओरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","यीशु लेइतां सारे लोक बड़े हैरान भोए। तैना तैसेरे पासे दौड़तां आए ते तैस जो नमस्कार कियूं। ");
INSERT INTO bhd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","तैखन यीशुए तैन पुच़्छ़ू, “मेरे चेलन सेइं कुन बेंस केरि राओरेथ?” ");
INSERT INTO bhd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","मैन्हु केरि भीड़ी मरां एक्की मैने यीशु जुवाब दित्तो, “हे उस्ताद, मीं अपनू मट्ठू तीं कां आनेरू थियूं, ताके तैन ठीक भोए। किजोकि तैस पुड़ भूतेरो सायो आए, ते तैस गल केरने न दे। ");
INSERT INTO bhd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","कोन्ची भी ठैरी तैन भूत मेरे मट्ठे ट्लाते, ते ज़मीनी पुड़ बिछ़ोड़ते। तैखन तैसेरे ऐशी मरां शैम्फ़ एच्चे ते तैन दंत कटते ते ठठमुकर भोइ गाते। मीं तेरे चेलन सेइं ज़ोरू थियूं कि, ‘मेरे मट्ठे पुड़ेरां भूतेरो सायो केड्डी देथ।’ पन तैना केड्डी न सके!” ");
INSERT INTO bhd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","एन गल्लां शुन्तां यीशुए तैन जुवाब दित्तो, “हे गैर विश्वासी मैनाव! अवं केइस तगर तुसन सेइं साथी रालो? त केइस तगर अवं तुश्शो अविश्वास झ़ैल्ललो? तैस मट्ठे मीं कां आनां!” ");
INSERT INTO bhd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","तैखन तैनेईं तैन मट्ठू यीशु कां आनू। ज़ैखन तैनी भूते यीशु लाव, त तैनी अकदम तैन मट्ठू मरोड़ू, ते मट्ठू तल्ले बिछ़ड़ू। ते तैसेरी ऐशी मरां शैम्फ़ निस्ने लग्गी त तैन ड्लेडने लग्गू। ");
INSERT INTO bhd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","यीशुए तैसेरे बाजी पुच़्छ़ू, “एसेरी ए हालत केइसेरी देंती आए?” तैसेरे बाजे ज़ोवं, “बचपनेरी देंती। ");
INSERT INTO bhd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","एस मारनेरे लेइ एन भूत बड़े बार कधी अग्गी मां ते कधी पैनी मां बिछ़ोड़तू राते, पन अगर तू किछ केरि सकतस, त असन पुड़ तरस खेइतां इश्शी मद्दत केर!” ");
INSERT INTO bhd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","यीशुए तैस मट्ठेरे बाजी सेइं ज़ोवं, “तू ए को गल केरतस! अगर तू विश्वास केरस, त एन भोइ सकते। किजोकि मीं पुड़ विश्वास केरनेबालां केरे लेइ सब किछ भोइ सकते।” ");
INSERT INTO bhd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","तैस मट्ठेरे बाजे अकदम ज़ोरे सेइं लेरां देइतां ज़ोवं, “हे प्रभु, अवं विश्वास केरतईं, मेरी मद्दत केर कि अवं शक न केरि।” ");
INSERT INTO bhd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ज़ैखन यीशुए हेरू कि बड़े लोक दौड़तां अकोट्ठे भोने लग्गोरेन, त तैनी भूत एन ज़ोइतां डांटू, “हे भूता, ज़ै एस मट्ठे टोव्नू त लट्टू बनातस। अवं तीं हुक्म देताईं, एस मट्ठे मरां निस्सी गा, ते एसमां फिरी कधी भी न एज्जां!” ");
INSERT INTO bhd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","तैखन तैनी भूते चिन्डां मारी त तैन मट्ठू मरोड़ू, फिरी तैन तैस मट्ठे मरां निस्सी जेव। त मट्ठू मरू ज़ेरू भोइ ज़ोवं, इड़ी तगर कि बड़े लोक ज़ोने लग्गे कि मट्ठू मेरि ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","पन यीशुए मट्ठेरो हथ ट्लेइतां खड़ू कियूं। ते मट्ठू ठीक भोइतां खड़ू भोवं। ");
INSERT INTO bhd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","तैल्ला पत्ती, यीशु ते तैसेरे चेले घरे जो जे। ज़ैखन तै अकैल्लो थियो तैखन तैसेरे चेलेईं तैस पुच़्छ़ू, “अस तैस मट्ठे मरां भूतेरो सायो की न केड्डी सके?” ");
INSERT INTO bhd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","यीशुए तैन सेइं ज़ोवं, “बगैर प्रार्थनारे (त कने बगैर बरत रखनेरे) अलावा, होरि केन्ची तरीके सेइं, तुस एरे ज़ेरे भूतेरो सायो न केड्डी सकतथ।” ");
INSERT INTO bhd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","तैल्ला पत्ती, यीशु त तैसेरे चेले तैट्ठां निस्तां गलील इलाके मांमेइं च़ेलि राओरे थिये। यीशु न चातो थियो कि कोई तैसेरे बारे मां ज़ाने कि तै तैड़ी ओरोए, ");
INSERT INTO bhd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","किजोकि तैखन तै अपने चेलन शिक्षा देतो ते तैन सेइं ज़ोतो थियो कि, “मेरे दुश्मनेईं मैनेरू मट्ठू, यानी अवं कैद केरनोईं। त तैनेईं अवं मारनोईं, पन मारनेरां ट्लेइयोवं दिहाड़े अवं मुड़दन मरां फिरी ज़ींतो भोनोईं।” ");
INSERT INTO bhd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","पन यीशुएरी ए गल चेलां केरि समझ़ी मां न आई, ते तैना एस गल्लारो मतलब पुछ़ने केरां भी डरते थिये। ");
INSERT INTO bhd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","तैल्ला पत्ती, यीशु ते तैसेरे चेले कफरनहूम नगरे मां आए। तैना तैड़ी एक्की घरे मां जे। तैखन यीशुए अपने चेलन पुच़्छ़ू, “बत्तां च़लते-च़लते तुस एप्पू मांमेइं कोस गल्लारे बारे मां बेंस केरि राओरे थिये?” ");
INSERT INTO bhd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","तैना सब शरमेइतां च़ुप राए, किजोकि तैनेईं बत्तां एप्पू मांमेइं एसेरे बारे मां बेंस कियोरी थी कि असन मां बड्डो मैन्हु कौन आए। ");
INSERT INTO bhd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","तैखन यीशुए तल्ले बिश्तां अपने 12 चेले कुजाए ते तैन सेइं ज़ोवं, “अगर कोई परमेशरेरी नज़री मां बड्डो बन्नू चाते, त तै सेब्भन केरां निकड़ो बने, ते कने सेब्भी मैन्हु केरो सेवक बने।” ");
INSERT INTO bhd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","तैखन यीशुए अक निकड़ो बच्चो हथ्थन मां ट्लेइतां, तैन केरे मझ़ाटे खड़ो कियो। तैनी तै बच्चो अपने कुम्मे मां रेखतां अपने चेलन सेइं ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ज़ैना लोक मीं सेइं प्यार केरनेरे वजाई सेइं एरे ज़ेरे बच्चन मरां अक भी कबूल केरतन, तैना मीं कबूल केरतन। ज़ैना मीं कबूल केरतन, तैना सिर्फ मीं नईं, पन तैना परमेशरे भी कबूल केरतन, ज़ैनी अवं इड़ी भेज़ोरोईं।” ");
INSERT INTO bhd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","तैखन यूहन्ने यीशु सेइं ज़ोवं, “हे गुरू, असेईं अक मैन्हु लाव, ज़ै तेरू नंव घिन्तां लोकन मरां भूतेरो सायो केड्डी राओरो थियो। एल्हेरेलेइ, असेईं तै मैन्हु ठाको, किजोकि तै असन सेइं साथी तीं पत्ती नईं च़ले।” ");
INSERT INTO bhd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","पन यीशुए जुवाब दित्तो, “तैस न ठाका, किजोकि अगर कोई मेरे नंव घिन्तां चमत्कारेरां कम्मां केरे, त तै मेरे बारे मां लूशी बुरी गल्लां न ज़ोए। ");
INSERT INTO bhd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","किजोकि ज़ैना इश्शे खलाफ कम न केरन, तैना इश्शे पासेन। ");
INSERT INTO bhd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","अगर कोई मेरे नंव्वे सेइं तुश्शी मद्दत केरे, अक गिलास पानी भी तुसन पियाए, कि मसीहेरे आथ, त अवं तुसन सेइं सच़ ज़ोतां कि तै मैन्हु परमेशरे केरां अपनो फल ज़रूर हासिल केरेलो। ");
INSERT INTO bhd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“ज़ै कोई इन निकड़े बच्चन मरां ज़ैना मीं पुड़ विश्वास केरतन, केन्ची भी पाप करवाए, त तैस मैनेरे लेइ एन रोड़ू आए कि ढ्लाटेरो अक बड्डो ढ्लेइटोल तैसेरे गल्ले सेइं बेंधतां समुन्द्रे मां शारो गाए। ");
INSERT INTO bhd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","अगर तेरो हथ तीं पाप केरनेरे लेइ ठोकर खुवाए, त तैस केट्टी छ़ड। किजोकि तेरे लेइ दूई हथ भोंते सांते सज़ा मैलनेरे लेइ नरकेरी अग्गी मां गाने केरां एन रोड़ू आए, कि तू डोण्डो भोइतां हमेशारी ज़िन्दगी मां दाखल भोस। किजोकि नरकेरी अग कधी भी न हिश्शे। ");
INSERT INTO bhd_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","तैड़ी तैन केरे कीड़े, ज़ैना तैन खातन न मरन ते कने अग भी न हिश्शे। ");
INSERT INTO bhd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","त अगर तेरो पाव तीं पाप केरनेरे लेइ ठोकर खुवाए, त तैस केट्टी छ़ड। किजोकि तेरे लेइ दूई पाव भोंते सांते सज़ा मैलनेरे लेइ नरकेरी अग्गी मां गाने केरां एन रोड़ू आए, कि तू टोंटो भोइतां हमेशारी ज़िन्दगी मां दाखल भोस। किजोकि नरकेरी अग कधी भी न हिश्शे। ");
INSERT INTO bhd_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","तैड़ी तैन केरे कीड़े, यानी ज़ैना तैन खातन न मरन त अग भी न हिश्शे। ");
INSERT INTO bhd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","अगर तेरी अछ़ तीं पाप केरनेरे लेइ ठोकर खुवाए, त तैस केड्डी छ़ड। किजोकि तेरे लेइ दूई एछ़्छ़ी भोंते सांते नरकेरी अग्गी मां छ़ड्डे गाने केरां एन रोड़ू आए, कि एक्की अछ़्छ़ी सेइं तू परमेशरेरे राज़्ज़े मां दाखल भोस। ");
INSERT INTO bhd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","नरके मां तैन केरे कीड़े, ज़ैना तैन खातन न मरन त अग भी न हिश्शे। ");
INSERT INTO bhd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ज़ेन्च़रां हर बलिदाने मां लून छ़डनू ज़रूरी आए, तेन्च़रां परमेशर हर एक्की मैनेरी अज़मैइश घिन्नलो, ज़ै बड़ी दुखे बाली भोनी आए, ज़ेन्च़रां कि अग्गी मांमेइं निसनूए। ");
INSERT INTO bhd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","लून त रोड़ू आए, पन अगर लूनेरो स्वाद च़ेलि गाए, त फिरी दुबारां केन्च़रे तैसेरो स्वाद वापस आनेले? तेन्च़रां तुस भी एप्पू मां लून रखा, यानी परमेशरेरो हुक्म मन्ना, त एप्पू मांमेइं मेल मिलापे सेइं राथ।” ");
INSERT INTO bhd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","तैल्ला पत्ती, यीशु त तैसेरे चेले तैट्ठां उठतां यहूदिया इलाके मां आए, त फिरी यरदन दरियारे उस पार च़ले जे। तैड़ी मैन्हु केरि भीड़ फिरी तैस कां अकोट्ठी भोइ। त तै अपने रीतरे मुताबिक तैन फिरी शिक्षा देने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","तैखन फरीसी लोकेईं यीशु कां एइतां तैस अज़मानेरे लेइ तैस पुच़्छ़ू, “कुन एन जेइज़ आए कि मड़द अपनि कुआन्शी फारख्ती दे?” ");
INSERT INTO bhd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","पन यीशुए तैनन् पुच़्छ़ू, “बड़े पेइले मूसा नेबे तुसन कुन केरनेरो हुक्म दित्तोरो थियो?” ");
INSERT INTO bhd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","तैखन तैनेईं यीशुए जुवाब दित्तो, “मूसे मड़दे अज़ाज़त दित्तोरीए कि तै लिखतां फारख्ती दे।” ");
INSERT INTO bhd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","तैखन यीशुए तैनन् जुवाब दित्तो, “तुश्शे सखत दिलेरी वजाई सेइं, मूसे तुश्शे लेइ ए हुक्म दित्तोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","पन दुनियारी शुरुआती मां, ज़ैखन परमेशरे मैन्हु केरि रच़ना की, तैखन तैनी तैना मड़द ते कुआन्श बनोरेन। ");
INSERT INTO bhd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","एल्हेरेलेइ, ड्लाएरे पत्ती मड़द अपने हाज-बव्वे केरां अलग भोइतां अपनि कुआन्शी सेइं साथी रालो, ");
INSERT INTO bhd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ते तैना दुइये अक्के जान भोले।” तैल्ला पत्ती यीशुए ज़ोवं, “एल्हेरेलेइ तैना हुनी परमेशरेरी नज़री मां दूई नईं, पन तैना अक्के आन। ");
INSERT INTO bhd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","एल्हेरेलेइ ज़ैना परमेशरे ज़ोड़ोरेन, तैनन् कोई मैन्हु अलग न केरे!” ");
INSERT INTO bhd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","बादे मां, ज़ैखन यीशु ते तैसेरे चेले घरे मां थिये, तैखन तैसेरे चेलेईं फारख्ती देनेरे बारे मां तैस फिरी पुच़्छ़ू। ");
INSERT INTO bhd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","यीशुए तैन सेइं ज़ोवं, “ज़ै कोई अपनि कुआन्शी फारख्ती देइतां होरो ड्ला बनाए, त तै तैस पेइली कुआन्शारे खलाफ बदमाशी केरते। ");
INSERT INTO bhd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","त अगर कुआन्श अपने मड़दे छ़ेडतां होरो ड्ला बनाए, त तै अपने पेइले मड़देरे खलाफ बदमाशी केरचे।” ");
INSERT INTO bhd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","तैल्ला पत्ती, किछ लोक अपने निक्के बच्चन यीशु कां आन्ने लग्गे ताके तै तैन पुड़ हथ रेखतां आशिर्वाद दे, पन तैसेरे चेलेईं तैना लोक डांटे। ");
INSERT INTO bhd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","यीशुए एन हेरतां सेरकोइतां अपने चेलन सेइं ज़ोवं, “निक्के बच्चन मीं कां एजने देथ, तैनन् न ठाका, किजोकि परमेशरेरू राज़ एरे ज़ेरे लोकां केरे लेइ आए। ");
INSERT INTO bhd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","अवं तुसन सेइं सच़ ज़ोतईं कि ज़ै कोई परमेशरेरे राज़्ज़े निकड़े बच्चेरू ज़ेरू कबूल न केरे, त तै परमेशरेरे राज़्ज़े मां कधी भी दाखल न भोइ सके।” ");
INSERT INTO bhd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","तैखन यीशुए तैना बच्चे कुम्मे मां रेखां, तैन पुड़ हथ रेखतां तैनन् आशिर्वाद दित्तो। ");
INSERT INTO bhd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","तैल्ला पत्ती, ज़ैखन यीशु त तैसेरे चेले घरेरां बेइर निस्तां बत्तां च़ेलि राओरे थिये, ते अक मैन्हु यीशु कां दौड़तो अव। तैनी तैस कां मथ्थो टेकतां तैस पुच़्छ़ू, “हे रोड़े गुरू, हमेशारी ज़िन्दगी हासिल केरनेरे लेइ अवं कुन केरि?” ");
INSERT INTO bhd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","पन यीशुए तैस पुच़्छ़ू, “किजो तू मींजो रोड़ू ज़ोतस? परमेशरेरे अलावा होरो कोई भी रोड़ो नईं। ");
INSERT INTO bhd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","तू त परमेशरेरे हुक्मन ज़ानतस, यानी ‘खून न केरा, बदमाशी न केरा, च़ोरी न केरा, झूठी गवाही न देथ, धोखो न देथ, अपने हाज-बव्वां केरि इज़्ज़त केरा।’ ” ");
INSERT INTO bhd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","पन तैनी मैने यीशु जुवाब दित्तो, “हे गुरू, एना सब हुक्म अवं बचपनेरो मन्तो ओरोईं।” ");
INSERT INTO bhd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","तैखन यीशुए तैस तेकतां तैस सेइं प्यार कियो, त तैस सेइं ज़ोवं, “तीं मां एक्की गल्लारी कमी आए। गा, ज़ैन किछ तीं कां आए तैन बेच़तां गरीब मैनन् दे, तैखन तीं स्वर्गे मां खज़ानो मैलेलो। तैल्ला पत्ती, एइतां मेरो चेलो बना, त अपनू क्रूस छ़ुइतां मीं पत्ती च़ल।” ");
INSERT INTO bhd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","यीशुएरी ए गल शुन्तां तैस मैनेरू तुत्तर ट्लक्कू, त तै बड़ो दुखी भोइतां च़लो जेव, किजोकि तै बड़ो अमीर थियो त तै अपनो धन छ़डने न चातो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","तैखन यीशुए च़ेव्रे पासन अपने चेलन तेकतां तैन सेइं ज़ोवं, “अमीर मैन्हु केरू परमेशरेरे राज़्ज़े मां दाखल भोनू बड़ू मुश्किल आए।” ");
INSERT INTO bhd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","यीशुएरे चेले तैसेरी गल्लां शुन्तां हैरान भोए। पन यीशुए फिरी तैन सेइं ज़ोवं, “हे मट्ठाव, ज़ैना धने पुड़ भरोसो रखतन, तैन केरे लेइ परमेशरेरे राज़्ज़े मां दाखल भोनू बड़ू मुश्किल आए! ");
INSERT INTO bhd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","परमेशरेरे राज़्ज़े मां अमीर मैनेरू दाखल भोने केरां ऊँटेरू सांधनेरे पाऐ मरां निस्नू सुख्तू आए!” ");
INSERT INTO bhd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","तैखन तैना बड़े हैरान भोइतां एप्पू मांमेइं ज़ोने लग्गे, “अगर अमीर मैनेरे लेइ मुक्ति हासिल केरनि नमुमकिन आए, त फिरी केसेरी मुक्ति भोइ सकचे?” ");
INSERT INTO bhd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","यीशुए तैन केरे पासे तेकतां ज़ोवं, “मैन्हु अपने आपे न बच़ेइ सकन, यानी मुक्ति हासिल न केरि सकन, पन परमेशर एन केरि सकते, किजोकि परमेशर सब किछ केरि सकते।” ");
INSERT INTO bhd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","तैखन पतरस यीशु सेइं ज़ोने लगो, “तक, अस त सब किछ छ़ेडतां तीं पत्ती च़लोरेम! असन कुन इनाम मैलेलू?” ");
INSERT INTO bhd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","यीशुए अपने चेलन सेइं ज़ोवं, “अवं तुसन सेइं सच़ ज़ोतईं कि, ज़ैनेईं मेरे लेइ त कने मेरे बारे मां खुशखबरी होरे लोकन शुनानेरे लेइ अपने घर या ढ्ला या बेइन या हाज या बव या बच्चे या ऊडारां शारोरन, ");
INSERT INTO bhd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","तैनन् इस दुनियाई मां शौव गुणा मैलेलू। तैना घरन, ढ्लान, बेइनन, हेईयन, बच्चन त कने ऊडारां हासिल केरेले। लोक भी तैनन् सताले, पन एजनेबाली दुनियाई मां परमेशर तैनन् हमेशारी ज़िन्दगी देलो। ");
INSERT INTO bhd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","पन बड़े मैन्हु ज़ैना हुन्ना पेइले आन, तैना बादे मां पत्रोवं भोनेन। त ज़ैना हुन्ना पत्रोवं आन, तैना बादे मां पेइले भोनेन।” ");
INSERT INTO bhd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","तैल्ला पत्ती, यीशु त तैसेरे चेले ते किछ लोक यरूशलेम नगरे जो च़लते-च़लते, तैना हेजू बत्तां थिये। यीशु तैन केरे अग्री-अग्री पासे च़ेलि राओरो थियो। ते तैसेरे चेले हैरान भोए त होरे लोक डरते-डरते तैस पत्ती च़ली राओरे थिये। तैखन यीशु अपने 12 चेलन बत्ती मरां अलग नेइतां फिरी तैन सेइं तैना गल्लां ज़ोने लगो, ज़ैना तैस सेइं भोनेबैली थी। ");
INSERT INTO bhd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","तैनी ज़ोवं, “शुना, अस सारे यरूशलेम नगरे जो गेइ राओरेम। तैड़ी मैनेरू मट्ठू (यानी अवं) प्रधान याजकन त कने शास्त्री लोकन केरां कैद कियो गानोईं, त तैना मीं मारनेरो हुक्म देले त गैर यहूदी लोकां केरे हवाले केरले। ");
INSERT INTO bhd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","त होरि कौमां केरे लोक मेरो मज़ाक बनाले, त मीं पुड़ थुकेले, त मीं कोड़े मारेले, त तैना मीं मैरी छ़डेले, पन ट्लेइ दिहाड़ना पत्ती अवं मुड़दन मरां फिरी ज़ींतो भोलो।” ");
INSERT INTO bhd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","तैखन याकूब त यूहन्ना, ज़ैना जब्दी नंव्वेरे मैनेरां मट्ठां थियां, यीशुएरे नेड़े एइतां तैस सेइं ज़ोने लग्गे, “हे गुरू, अस चातम कि ज़ैन किछ अस तीं केरां मग्गम, तैन तू असन देइयथ।” ");
INSERT INTO bhd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","यीशुए तैन पुच़्छ़ू, “तुसन कुन लोड़ते, ज़ैन अवं तुसन देईं?” ");
INSERT INTO bhd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","तैनेईं तैस सेइं ज़ोवं, “असन एन दे कि ज़ैखन तू महिमा सेइं साथी राज़ केरेलो, तैखन तीं सेइं साथी राज़ केरनेरे लेइ असन मरां अक तेरे देइने पासे त होरो तेरे बाएं पासे राज़गेद्दी पुड़ बिश्शे।” ");
INSERT INTO bhd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","पन यीशुए तैन सेइं ज़ोवं, “तुस न ज़ानथ कि तुस कुन मगने लग्गोरेथ! ज़ेन्च़रे दुख अवं झ़लने बालोईं, कुन तुस झ़ेल्ली सकतथ? ज़ेन्च़रे अवं मारनोईं कुन तुस भी मारे गानेरे लेइ तियारथ?” ");
INSERT INTO bhd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","तैनेईं तैस जुवाब दित्तो, “हाँ, अस एन केरि सकतम।” एल्हेरेलेइ, यीशुए तैन सेइं ज़ोवं, “सच़्च़े, ज़ेन्च़रे अवं दुख झ़लने बालोईं, तेन्च़रे तुस झ़ल्लेले? ज़ेन्च़रे अवं मारनोईं तेन्च़रे तुस मारे गाले। ");
INSERT INTO bhd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","पन तै ठार ज़ैन केरे लेइ पेइले तियारी कियोरीए, तैन छ़ेडतां होरे केन्ची अपने देइने पासे त कने अपने बाएं पासे राज़गेद्दी पुड़ बिशालनू मेरू कम नईं।” ");
INSERT INTO bhd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","एन शुन्तां यीशुएरे बाकी दश चेले याकूब त कने यूहन्ना सेइं नराज़ भोइ जे। ");
INSERT INTO bhd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","तैखन यीशुए अपने सारे चेले नेड़े कुजेइतां, तैन सेइं ज़ोवं, “तुसन पतोए कि ज़ैना होरि कौमां केरे लोकां केरे राज़ केरनेबाले समझ़े गातन, तैना अपने लोकन पुड़ राज़ केरतन। तैन मरां ज़ैना बड्डे अफसर आन, तैना अपने लोकन पुड़ हकोमत च़लातन। ");
INSERT INTO bhd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","पन तुसन मां एरी ज़ेरि गल न लोड़े, पन ज़ै कोई तुसन मां बड्डो बन्नू चाए, त तै निकड़ो बेनतां तुश्शो सेवक बने। ");
INSERT INTO bhd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","त ज़ै कोई तुसन मां प्रधान मैन्हु बन्नू चाए, त तै सारे मैन्हु केरो सेवक बने। ");
INSERT INTO bhd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","किजोकि मैनेरू मट्ठू, यानी अवं एस दुनियाई मां एल्हेरेलेइ नईं ओरो कि कोई मेरी सेवा केरे, पन एल्हेरेलेइ ओरोईं कि अवं होरि लोकां केरि सेवा केरि त कने बड़े लोकां केरे लेइ अपनि जान बलिदान केरि, ताके तैन अपने पापां केरे सज़ाई केरां छुटकारो मैल्ले।” ");
INSERT INTO bhd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","तैल्ला पत्ती, यीशु त तैसेरे चेले यरीहो नगरे मां पुज़्ज़े। बादे मां, ज़ैखन तैना मैन्हु केरि बड़ी भीड़ी सेइं साथी यरीहो नगरी मरां निस्सी राओरे थिये, त तैखन बरतिमाई नंव्वेरो कानो भिखारी सड़केरे ड्लेखी बिश्तां भीख मेग्गी राओरो थियो। तैसेरे बाजी केरू नंव्व तिमाई थियूं। ");
INSERT INTO bhd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ज़ैखन तैनी शुनू कि नासरत नगरेरो यीशु इलमेइं निस्सी राओरोए, त तै भिखारी ज़ोरे सेइं ज़ोने लगो, “हे यीशु, दाऊद राज़ेरा मट्ठा! मीं पुड़ दया केर!” ");
INSERT INTO bhd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","त बड़े लोकेईं तै डांटो कि, “च़ुप रा।” पन तै पेइले केरां जादे चिन्डां मारने लगो, “हे दाऊद राज़ेरा मट्ठा, मीं पुड़ दया केर!” ");
INSERT INTO bhd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","तैखन यीशुए रुकतां लोकन सेइं ज़ोवं, “तुस तैस इरां कुजाथ।” लोकेईं तै कानो कुजेइतां तैस सेइं ज़ोवं, “हिम्मत रख! उठ! यीशु तीं एप्पू कां कुजाने लग्गोरेन।” ");
INSERT INTO bhd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","तै अपनि च़ादर शैरतां लूशी उठो, ते यीशु कां अव। ");
INSERT INTO bhd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","तैखन यीशुए तैस पुच़्छ़ू, “तीं कुन लोड़ते कि अवं तेरे लेइ केरि?” काने मैने जुवाब दित्तो, “हे गुरू, अवं लानू चाताईं।” ");
INSERT INTO bhd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","तैखन यीशुए तैस सेइं ज़ोवं, “तू गा। तीं मीं पुड़ विश्वास कियूं एल्हेरेलेइ अवं तीं बज़्झ़ाताईं।” अकदम तै लाने लगो त कने यीशु पत्ती च़लो। ");
INSERT INTO bhd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ज़ैखन यीशु त तैसेरे चेले यरूशलेम नगरेरे नेड़े आए, त तैखन ज़ैतून नंव्वेरे पहाड़ेरे नेड़े, बैतफगे त कने बैतनिय्याह ड्लोंव्वन कां पुज़्ज़े। तैखन यीशुए अपने चेलन मरां दुइयन सेइं एन ज़ोइतां पेइले भेज़े कि, ");
INSERT INTO bhd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“अपने सामनेबाले ड्लोंव्वे मां गाथ। तैड़ी पुज़ते तुसन अक गैधेरो बच्चो बंधोरो मैलेलो, ज़ैस पुड़ कधी कोई नईं च़ढ़ोरो। तैस खोलतां इड़ी मीं कां आनां। ");
INSERT INTO bhd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","अगर तुसन कोई पुच़्छ़े, ‘किजो एन केरने लग्गोरेथ?’ त तैस सेइं ज़ोइयथ, ‘प्रभुए एसेरी ज़रूरत आए।’ त तै अकदम गधेरे बच्चे तुसन सेइं साथी इड़ी भेज़ेलो।” ");
INSERT INTO bhd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","तैना दूई चेले तैस ड्लोंव्वे मां जे। तैड़ी गैधरो बच्चो एक्के घरेरे दारे बेइर बंधोरो लाव, त तैना तैस खोलने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ज़ैना तैड़ी खड़े थिये, तैन मरां किछ मैनेईं तैन पुच़्छ़ू, “एन कुन केरने लग्गोरेथ, गधेरे बच्चे किजो खोलने लग्गोरेथ?” ");
INSERT INTO bhd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ज़ेन्च़रां यीशुए अपने चेलन सेइं ज़ोरू थियूं, तेन्च़रां तैनेईं तैन मैनन् सेइं ज़ोवं। तैखन तैन मैनेईं चेले तैट्ठां गाने दित्ते। ");
INSERT INTO bhd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","यीशुएरे चेलेईं बच्चो यीशु कां एन्तां यीशुए तैस पुड़ बिशालनेरे लेइ, तैस पुड़ अपने लिगड़ां छ़ड्डो। त यीशु तैस पुड़ बिश्शो (त तैना यरूशलेम नगरेरे पासे जो च़लने लग्गे)। ");
INSERT INTO bhd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","तैखन बड़े लोकेईं (तैसेरी इज़्ज़त केरनेरे लेई) अपना लिगड़ां बत्ती मां बिछ़ां त कने किछ मैनेईं पट्लनबाली डैलड़ी एन्तां बत्ती मां बिछ़ेई। ");
INSERT INTO bhd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ज़ैना यीशुएरे अग्री-अग्री त कने पत्ती-पत्ती च़लने लग्गोरे थिये, तैना खुशी सेइं ज़ोरे सेइं ज़ोने लग्गे, “होशाना! (परमेशरेरी तारीफ़ भोए) परमेशर तैस बरकत दे, ज़ै प्रभु-परमेशरेरे अधिकारे सेइं साथी एज्जी राओरोए!” ");
INSERT INTO bhd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“परमेशर तीं आशिर्वाद दे, ज़ैखन तू इश्शे पड़दादे दाऊदेरू राज़ेरू ज़ेरू राज़ केरे! परमेशरेरी होशाना (तारीफ़) भोए, ज़ै उच्चे स्वर्गे मां आए!” ");
INSERT INTO bhd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","तैल्ला पत्ती, तैन लोकन सेइं साथी, यीशु यरूशलेम नगरी मां पुज़्तां मन्दरे मां जेव। यीशु मन्दरे मां च़ेव्रे पासन तक्कू कि ज़ैन तैड़ी भोइ राओरू थियूं। तै अपने 12 चेलन सेइं साथी नगरे मरां निस्तां, राती बिशनेरे लेइ बैतनिय्याह ड्लोंव्वे जो वापस च़लो जेव, किजोकि ड्लोझ़ भोइ जोरी थी। ");
INSERT INTO bhd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","त एग्री दिहाड़ी, ज़ैखन यीशु त तैसेरे चेले बैतनिय्याह ड्लोंव्वेरां निस्तां यरूशलेम नगरे जो वापस एज्जी राओरे थिये, तैखन यीशुए ढ्लुख लग्गी। ");
INSERT INTO bhd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","तै दूरेरां फ़ेगेरो अक नीलो बुट लेइतां तैसेरे नेड़े जेव कि खाने जो शायद तैस मां किछ मैल्ले। पन, ज़ैखन तै बुटे कां जेव, त तैड़ी पट्लां केरे अलावा तैस किछ न मैल्लू, किजोकि तै फल्लेरो मौसम न थियो। ");
INSERT INTO bhd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","तैखन यीशुए तैस बुटे फिटकार देइतां तैस सेइं ज़ोवं, “हुन्नेरे पत्ती, तीं मां कोई फल कधी न लग्गलो!” त तैसेरे चेले एन शुनी राओरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","तैल्ला पत्ती, तैना फिरी यरूशलेम नगरे मां पुज़्ज़े, त यीशु मन्दरेरे अंगने मां जेव। तैड़ी लोक जानवरां केरू त कने मन्दरे मां च़ाढ़नेरू सामान घिन्नेरू त कने बेच़नेरो कारोबार केरि राओरे थिये। यीशु तैनन् बेइर कढने लगो, ते तैनी तैड़ी पेंइसे बदलनेबालन केरे मेज़न त कने कबूतर बेच़नेबालन केरि कुर्सी उलटेइ दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","त मन्दरेरी ठैरी मां केन्ची बेच़नेरे लेइ कोई चीज़ एन्तां च़लने न दित्तू। ");
INSERT INTO bhd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","तैखन यीशुए तैन लोकन शिक्षा देइतां ज़ोवं, “परमेशरेरी किताबी मां एस मन्दरेरे बारे मां एन लिखोरूए कि परमेशरे ज़ोवं, मेरू मन्दर सैरी कौमां केरे लोकां केरे लेइ प्रार्थनारू घर भोलू! पन तुस लोकेईं इन मन्दर डैकू केरो अड्डो बनोरोए।” ");
INSERT INTO bhd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","एन शुन्तां प्रधान याजक त कने शास्त्री लोक यीशु कत्ल केरनेरो मौको तोपने लग्गे। पन तैना यीशु केरां डरते थिये, किजोकि सारे लोक तैसेरी शिक्षाई शुन्तां हैरान भोते थिये। ");
INSERT INTO bhd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ज़ैखन ड्लोझ़ भोइ, त यीशु त तैसेरे चेले (रात गुज़ारनेरे लेइ) नगरेरां बेइर च़ेलि जे। ");
INSERT INTO bhd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","एग्री दिहाड़ी, झ़ेज़्झ़ां यीशु त तैसेरे चेले तैट्ठां यरूशलेम नगरे जो च़ले त तैनेईं तै फ़ेगेरो बुट लाव, ज़ैस यीशुए पेइले फिटकार दित्तोरो थियो। तै बुट ज़ीलन तगर शुक्की जोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पतरसे तै गल याद आई कि यीशुए एस बुटे फिटकार दित्तोरो थियो, त तैनी यीशु सेइं ज़ोवं, “हे गुरू, तक! ए फ़ेगेरो बुट ज़ैस तीं फिटकार दित्तोरो थियो, शुक्की जोरोए! (एन केन्च़रां भोवं)” ");
INSERT INTO bhd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","यीशुए अपने चेलन जुवाब दित्तो, “तुस परमेशरे पुड़ विश्वास रखा। ");
INSERT INTO bhd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","अवं तुसन सेइं सच़ ज़ोताईं कि ज़ै कोई एस पहाड़े सेइं ज़ोए, ‘तू उखड़तां समुन्द्रे मां बिछ़ड़ी गा,’ त एन्च़रां ज़ोइतां अपने दिले मां शक न केरे, पन विश्वास केरे कि ‘ज़ैन अवं ज़ोतईं तैन भोइ गालू,’ त तैसेरेलेइ तैन्ने भोलू। ");
INSERT INTO bhd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","एल्हेरेलेइ अवं तुसन सेइं ज़ोतईं कि, ज़ैखन तुस प्रार्थना केरतां परमेशरे केरां ज़ैन भी मगेले, त विश्वास केरा कि तुसन तैन ज़रूर मैल्ली गालू, तैखन परमेशरे केरां तैन तुसन दित्तू गालू। ");
INSERT INTO bhd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ते ज़ैखन कधी तुस खड़े भोइतां परमेशरे कां प्रार्थना केरतथ, त अगर तुसन केन्ची सेइं गिलो भोए, त पेइले तुस तैस माफ़ केरा, ताके तुश्शो स्वर्गेरो बाजी भी तुश्शे पाप माफ़ केरे। ");
INSERT INTO bhd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","अगर तुस होरि लोकन माफ़ न केरथ, त तुश्शो बाजी परमेशर भी, ज़ै स्वर्गे मां आए, तुश्शे पाप माफ़ न केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","तैल्ला पत्ती, यीशु त तैसेरे चेले फिरी यरूशलेम नगरे मां आए। ज़ैखन यीशु मन्दरेरे अंगने मांमेइं हंठने लग्गोरो थियो, त तैखन प्रधान याजक त कने शास्त्री त कने यहूदी लोकां केरे बुज़ुर्ग तैस कां आए, त तैस सवाल पुछ़ने लग्गे, ");
INSERT INTO bhd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“तू एन कम्मां कोस अधिकारे सेइं केरतस, त कने एन कम्मां केरनेरो तीं केनि अधिकार दित्तोरोए?” ");
INSERT INTO bhd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","पन यीशुए तैन सेइं ज़ोवं, “अवं भी तुसन अक सवाल पुछ़तईं। मीं तैसेरो जुवाब देथ, तैखन अवं भी तुसन ज़ोलो कि अवं एन कम्मां कोस अधिकारे सेइं केरतईं। ");
INSERT INTO bhd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","मीं जुवाब देथ। यूहन्ना ज़ै बपतिस्मो देनेबालो थियो, तैस बपतिस्मो देनेरो अधिकार कोट्ठां मैल्लो, परमेशरेरी तरफां मैल्लो या मैन्हु केरि तरफां?” ");
INSERT INTO bhd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","तैखन तैना एप्पू मांमेइं गलबात केरने लग्गे कि, “अगर अस ज़ोम कि, ‘परमेशरेरी तरफां मैल्लो,’ त एनी पुछ़नूए कि, ‘फिरी तुसेईं तैसेरो विश्वास की न कियो?’ ");
INSERT INTO bhd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","पन अस एन भी नईं ज़ोई सकम कि, ‘यूहन्ना अधिकार, मैन्हु केरि तरफां मैल्लो,’ किजोकि असन लोकां केरो डर आए कि तैना असन पुड़ क्रोध केरले, किजोकि सारे लोक समझ़ते थिये कि सच़्चे यूहन्ना नबी आए।” ");
INSERT INTO bhd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","एल्हेरेलेइ तैनेईं यीशु एन जुवाब दित्तो कि, “असन नईं पतो।” यीशुए तैन सेइं ज़ोवं, “अवं भी तुसन सेइं न ज़ोईं कि अवं एन कम्मां कोस अधिकारे सेइं केरतईं।” ");
INSERT INTO bhd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","तैल्ला पत्ती, यीशु यहूदी लोकां केरे लीडरन सेइं मिसालन मां गल्लां केरने लगो, “एक्सां, एक्की मैने दाछ़री बाग लाई, ते बागारे च़ेव्रे पासन बाड़ दित्तो, त दाछ़ारो रस कढनेरे लेइ कुण्ड बनावं, ते तैनी तैस बागारी रखवाली केरनेरे लेइ अक उच्ची कूड़ी बनाई। तैल्ला पत्ती, तै मैन्हु तैस बागारो ठेको किछ ज़मीनदारन देइतां होरि मुल्खे जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ज़ैखन फल्लेरो मौसम अव, त तैनी ज़मीनदारन कां अक नौकर भेज़ो कि ज़मीनदारन केरां दाछ़ारे बागारे फल्लां केरो अपनो हिस्सो आने। ");
INSERT INTO bhd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","पन ज़ैखन तै नौकर बागी मां पुज़्ज़ो, त तैन किसानेईं तै ट्लेइतां मड्डो त खाली हथ्थेइं वापस भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ज़ैखन बागारे मालिके शुनू कि तैनेईं एन कुन कियूं, त तैनी होरो अक नौकर फिरी भेज़ो। पन तैनेईं तैसेरो भी दोग बन्नो ते तैसेरी बेज़ती केरतां भेज़ी दित्तो। ");
INSERT INTO bhd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","फिरी तैनी मालिके होरो अक नौकर तैन कां भेज़ो। तैनेईं तै भी मैरी छ़ड्डो। तैखन तैनी होरे जादे नौकर भेज़े। तैन मरां तैनेईं किछ मड्डे, ते किछ मारे। ");
INSERT INTO bhd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","तैस मालिके कां अक्के रेवरो थियो, ज़ैन तैसेरू ट्लारू मट्ठू थियूं। आखरी मां, तैनी तै भी तैन कां एन सोचतां भेज़ू कि तैना मेरे मट्ठेरी इज़्ज़त केरले। ");
INSERT INTO bhd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","पन ज़ैखन मालिकेरू मट्ठू तैन कां अव, त तैन किसानेईं एप्पू मांमेइं ज़ोवं, ‘ए त एस बागारो वारिस आए। एज्जा, अस एस भी मैरी छ़ड्डम, तैखन एसेरी जेइदात इश्शी भोनी।’ ");
INSERT INTO bhd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","एल्हेरेलेइ, तैनेईं तै ट्लेइतां मैरी छ़ड्डो, ते बागारे बेइर शेरी छ़ड्डो।” ");
INSERT INTO bhd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","तैखन यीशुए तैन मैनन् पुच़्छ़ू, “हुनी बागारो मालिक तैन ज़मीनदारन सेइं कुन केरेलो? अवं ज़ोतईं कि तैनी कुन केरनू, तै एइतां तैन किसानां केरो नाश केरेलो, ते बागारो ठेको होरि केन्ची ज़मीनदारन देलो!” ");
INSERT INTO bhd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“कुन तुसेईं पवित्रशास्त्रे मां मसीहेरे बारे मां ई गल नईं पढ़ोरी? तैस मां लिखोरूए कि, ‘ज़ै घोड़ राज़-मिस्त्रेईं निकम्मो ठहरेवरो थियो, तै मकानेरो खास घोड़ बेनि जेव। ");
INSERT INTO bhd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","एन प्रभु परमेशरेरी तरफां एन्च़रां भोव, ते कने इश्शी नज़री मां ए हैरान भोनेरी गल आए!’” ");
INSERT INTO bhd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ज़ैखन यहूदी लोकां केरे लीडरेईं एन शुनू, त तैनेईं सेमझ़ी छ़ड्डू कि यीशुए ई मिसाल इश्शे खलाफ ज़ोरीए। एल्हेरेलेइ, तैना सेरकोए। त तैनेईं यीशु कैद केरनू चाव। पन तैना लोकन केरां डरे, एल्हेरेलेइ तैस छ़ेडतां च़ेलि जे। ");
INSERT INTO bhd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","तैल्ला पत्ती, यहूदी लोकां केरे लीडरेईं यीशु कां किछ फरीसी लोक त कने हेरोदेस राज़ेरे लोक भेज़े, ताके तैना यीशुए अपनि गल्लन मां फसान। ");
INSERT INTO bhd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","तैनेईं यीशु कां एइतां तैस सेइं ज़ोवं, “हे गुरू, अस ज़ानतम कि तू सच़्च़ो आस, त केन्चेरी परवाह न केरस, किजोकि तू सारे मैनन् बराबर समझ़तस, त तू परमेशरेरी गल्लां लोकन सच़्च़ाई सेइं शुनातस। एल्हेरेलेइ असन ज़ो, कुन रोम-मुल्खेरे महाराज़े जो चुंगी देनी जेइज़ आए कि नईं? ");
INSERT INTO bhd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","अस देम या न देम?” यीशुए तैन केरू पाखंड ज़ेनतां तैन सेइं ज़ोवं, “मीं किजो अज़मातथ? अक सिक्को (दीनार) मीं कां आनां कि अवं तैस हेरी।” ");
INSERT INTO bhd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","तैनेईं आनो, तैखन यीशुए तैन पुच़्छ़ू, “इस सिक्के पुड़ केसेरी शकल त केसेरू नवं आए?” तैनेईं जुवाब दित्तो, “महाराज़ेरू आए।” ");
INSERT INTO bhd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","यीशुए तैन सेइं ज़ोवं, “ज़ैन महाराज़ेरू आए तैन बड्डे राज़े देथ, ते ज़ैन परमेशरेरू आए तैन परमेशरे देथ।” ज़ैखन फरीसी लोकेईं ते कने हेरोदेस राज़ेरे लोकेईं एन शुनू, त तैखन तैना बड़े हैरान भोए। ");
INSERT INTO bhd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","तैल्ला पत्ती, सदूकी लोक यीशु कां आए। तैना ज़ोतन मुड़दे ज़ींते न भोन। त तैनेईं यीशु पुच़्छ़ू, ");
INSERT INTO bhd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“हे गुरू, बड़े पेइले मूसे असन जो कानूने मां लिखोरू थियूं कि अगर कोई मैन्हु बेऔलाद मेरि गाए त तैसेरी कुआन्श रेइ गाए, त तैसेरो ढ्ला तैसेरी लैड़ी सेइं ड्ला बनाए, त अपने ढ्लाएरे लेइ औलाद पैदा केरे, ताके तैसेरी खानदानी राए। ");
INSERT INTO bhd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","सत ढ्ला थिये। पेइलो ढ्ला ड्ला बनेइतां बेऔलाद मेरि जेव। ");
INSERT INTO bhd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","तैखन दुइयोवं ढ्लाए तैस कुआन्शी सेइं ड्ला बनाव। तै भी बेऔलाद मेरि जेव। तेन्च़रां ट्लेइयोवं ढ्लाए भी कियूं। ");
INSERT INTO bhd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","त सते ढ्लाएईं तैस कुआन्शी सेइं एक्केरे पत्ती एक्के ड्ला कियो, पन औलाद न भोइ। सैरेन पत्ती तै कुआन्श भी मेरि जेई। ");
INSERT INTO bhd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","एल्हेरेलेइ, परमेशर लोक मुड़दन मरां ज़ींते केरनेरे पत्ती, यानी ज़ैखन लोक ज़ींते भोले, त तैखन तै कुआन्श तैन सत्तन मरां केसेरी लाड़ी भोली? किजोकि तै इड़ी धेरती पुड़ सत्तां केरि लाड़ी भोरी थी।” ");
INSERT INTO bhd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","यीशुए तैन सेइं ज़ोवं, “तुश्शी सोच केत्री गलत आए! कुन तुसन पतो किजो? किजोकि तुस पवित्रशास्त्रे मां लिखोरी गल्लन त कने परमेशरेरी शक्ति न ज़ानथ! ");
INSERT INTO bhd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","तुसेईं ज़ै कहानी ज़ोई, तैस मां तै कुआन्श तैन सत्तन मरां केन्चेरी लाड़ी नईं भोनी, किजोकि ज़ैखन लोक मुड़दन मरां ज़ींते भोले, त तैखन कोई केन्ची सेइं ड्ला न बनालो, पन तैना स्वर्गे मां परमेशरेरे स्वर्गदूतां केरे ज़ेरे भोले, ज़ैना ड्ला न बनान। ");
INSERT INTO bhd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","मुड़दां केरे ज़ींतो भोनेरे बारे मां, कुन तुसेईं मूसेरी किताबी मां एन नईं पढ़ोरू ज़ैखन मूसे बलतू झ़ैल्ल लाव, तैखन (यानी अब्राहम, इसहाक त याकूब मरनेरे बड़े सालना पत्ती) परमेशरे मूसा सेइं ज़ोवं, ‘अवं अब्राहमेरो परमेशर, ते इसहाकेरो परमेशर, ते याकूबेरो परमेशर आईं?’ ");
INSERT INTO bhd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","परमेशर मुड़दां केरो परमेशर नईं, पन ज़ींतां केरो परमेशर आए, एल्हेरेलेइ तुश्शी सोच बिलकुल गलत आए।” ");
INSERT INTO bhd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","तैखन शास्त्री लोकन मरां एक्की मैने एजतां यीशु ते सदूकी लोकां केरि गलबात शुनी। तैस पतो च़लो कि यीशुए तैनन् ठीक जुवाब दित्तो, ते तैनी यीशु कां एइतां तैस पुच़्छ़ू, “परमेशरेरे सारे हुक्मन मरां बड़ो खास हुक्म को आए?” ");
INSERT INTO bhd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","यीशुए तैस जुवाब दित्तो, “सारे हुक्मन मरां बड़ो खास हुक्म ई आए, ज़ेन्च़रां परमेशरेरी किताबी मां लिखोरूए कि, ‘हे इस्राएलेरे लोकव शुना, प्रभु इश्शो परमेशर, अक्के प्रभु आए, ");
INSERT INTO bhd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","एल्हेरेलेइ प्रभु अपने परमेशरे सेइं तुस अपने सारे दिले सेइं, त अपनि सैरी जानी सेइं, त अपनि सैरी अक्ली सेइं, त अपनि सैरी ताकती सेइं प्यार केरा।’ ए बड़ो खास हुक्म आए। ");
INSERT INTO bhd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","तैसेरो ज़ेरो दुइयोवं बड़ो खास हुक्म ई भी आए कि, ‘तू अपने पेड़ोसन सेइं अपने बराबर प्यार केर।’ एन दूई हुक्मन केरां होरो कोई भी बड्डो हुक्म नईं।” ");
INSERT INTO bhd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","तैखन शास्त्री मैन्हु यीशु सेइं ज़ोवं, “हे गुरू, तीं बड़ू ठीक ज़ोवं! त तीं सच़ ज़ोवं कि परमेशर अक्के आए, ते तैसेरे अलावा होरो कोई नईं। ");
INSERT INTO bhd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","त असेईं परमेशरे सेइं अपने सारे दिले सेइं, ते अपनि सैरी जानी सेइं, ते अपनि सैरी अक्ली सेइं, त अपनि सैरी ताकती सेइं प्यार कियोरो लोड़े। ते कने असेईं अपने पेड़ोसन सेइं अपने बराबर प्यार कियोरो लोड़े। जानवरां केरू बलिदान केरनू या होरि चीज़ां केरि च़ढ़तल च़ाढ़ने करां भी बेधतां, एना दुइये हुक्मन मन्ने परमेशरेरे लेइ बड़े खास आन!” ");
INSERT INTO bhd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ज़ैखन यीशुए हेरू कि तैनी अक्ली सेइं जुवाब दित्तो, त तैनी तैस सेइं ज़ोवं, “तू परमेशरेरे राज़्ज़े मां दाखल भोने करां दूर नईं।” ते तैल्ला पत्ती, केन्ची यीशु किछ पुछ़नेरी हिम्मत न भोइ। ");
INSERT INTO bhd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","मन्दरे मां शिक्षा देते बार यीशुए लोकन अक सवाल पुच़्छ़ो, “शास्त्री किजो ज़ोतन कि ज़ै मसीह आए, तै दाऊद-राज़ेरी औलादी मरां भोलो? ");
INSERT INTO bhd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","बड़े पेइले दाऊद राज़े एप्पू पवित्र आत्मारे शक्ति सेइं एन्च़रां ज़ोरू थियूं कि, प्रभु परमेशरे मेरे प्रभु मसीहे सेइं ज़ोवं, ‘तू मेरे देइने पासे बिश, ज़ांतगर कि अवं तेरे दुश्मन बिलकुल न हारेईं।’ ");
INSERT INTO bhd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","दाऊद राज़े त एप्पू मसीहेरे बारे मां एन ज़ोवं कि ‘तै मेरो प्रभु आए,’ फिरी मसीह तैसेरू मट्ठू केन्च़रां भोइ सकते?” त मैन्हु केरि भीड़ यीशुएरी गल्लां खुशी सेइं शुन्ती थी। ");
INSERT INTO bhd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","यीशुए शिक्षा देते बार लोकन सेइं ज़ोवं, “शास्त्री लोकन करां खबरदार राथ, ज़ैना लम्मे-लम्मे चोले लेइतां हन्ठनू चातन, ताके लोक समझ़न कि तैना बड़े धर्मी आन, त तैना चातन कि बज़ारन मां लोक असन बड़ी इज़्ज़ती सेइं नमस्कार केरन। ");
INSERT INTO bhd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","त कने प्रार्थना घरन मां बड़े खास मैन्हु केरे लेइ रख्खोरी कुर्सी पुड़ बिशनू चातन, त धामन मां भी गेइतां बड़े खास मैन्हु केरे लेइ रख्खोरी कुर्सी पुड़ बिशनू चातन। ");
INSERT INTO bhd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","तैना विधवां केरे घरन लुटतन त कने होरि मैनन् हिरानेरे लेइ लेम्मी-लेम्मी प्रार्थना केरतन, ताके लोक समझ़न कि तैना बड़े धर्मी आन। परमेशर तैनन् बड़ी जादे सज़ा देलो!” ");
INSERT INTO bhd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","लोकन शिक्षा देनेरे पत्ती, यीशु मन्दरेरे दान-पेट्टेरे सामने बिश्तां एन तकने लग्गोरो थियो कि, लोक दान-पेट्टी मां केन्च़रां पेंइसे छ़ड्तन। बड़े मैनेईं, ज़ैना अमीर थिये, तैड़ी एइतां तैस मां बड़े पेंइसे छ़डने लग्गोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","तैखन अक गरीब विधवां एइतां दूई सिक्के छ़ड्डे, ज़ैन केरि कीमत बड़ी घट थी। ");
INSERT INTO bhd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ज़ैखन यीशुए तैन हेरू, तैनी अपने चेले एप्पू कां कुजेइतां तैन सेइं ज़ोवं, “अवं तुसन सेइं सच़ ज़ोतईं कि मन्दरेरे दान-पेट्टी मां पेंइसे छ़डनेबालन मरां, एस गरीब विधवां तैन सारे मैनन् करां जादे छ़ड्डोरेन। ");
INSERT INTO bhd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","किजोकि तैन सैरेईं अपने जादे पेंइसन मरां थोड़े ज़ेरे छ़ड्डे, पन ए विधवा त बड़ी गरीबी आए, फिरी भी तैसां सब किछ ज़ैन तैस कां थियूं छ़ेड्डी दित्तू, यानी अपनि ज़रूरतरे लेइ रख्खोरे पेंइसे भी छ़ेड्डी दित्ते!” ");
INSERT INTO bhd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ज़ैखन यीशु त तैसेरे चेले मन्दरे मरां निस्सी राओरे थिये, तैखन तैसेरे चेलन मरां एक्के तैस सेइं ज़ोवं, “हे गुरू, इड़ी हेर! केत्रे बड्डे-बड्डे घोड़न सेइं बनोरी दिवारां कने केत्रू रोड़े भवन आए!” ");
INSERT INTO bhd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","यीशुए तैन सेइं ज़ोवं, “हुन्ना त तुस एना बड्डे-बड्डे घोड़न सेइं बनोरे भवनन लातथ, पन एक्की दिहाड़े इड़ी घोड़े पुड़ घोड़ भी न रालो, यानी सब नाश भोइ गालू!” ");
INSERT INTO bhd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","तैल्ला पत्ती, यीशु ज़ैतून नंव्वेरे पहैड़ी पुड़ च़ढ़ता पार मन्दरेरे सामने बिश्शो। तैखन पतरस, याकूब, यूहन्ना ते अन्द्रियास यीशु कां अलग गेइतां तैस केरां पुछ़ने लग्गे, ");
INSERT INTO bhd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“असन ज़ो कि एना गल्लां केइस भोनिन? तैन दिहाड़ी केरो कुन निशान आए, ज़ैखन एना सब गल्लां पूरी भोनिन?” ");
INSERT INTO bhd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","तैखन यीशु तैन सेइं ज़ोने लगो, “खबरदार राथ कि कोई तुसन धोखो न दे। ");
INSERT INTO bhd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","किजोकि बड़े मैन्हु मेरे नंव्वे सेइं एइतां ज़ोले कि, ‘अवं मसीह आईं।’ ते तैना बड़े मैन्हु धोखो देले। ");
INSERT INTO bhd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ज़ैखन तुस लड़ाई ते कने लड़ाइयां केरि अफवाह शुनेले, त तुस घबरेइयथ न, किजोकि लड़ाइयां केरू भोनू ज़रूरी आए, पन एस दुनियारो अन्त अकदम न भोलो। ");
INSERT INTO bhd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","किजोकि एक्की ज़ातारे लोक होरि कौमरे लोकां केरे खलाफ लड़ाई केरले, त अक मुलख होरि मुल्खेरे खलाफ लड़ाई केरेलो। हर ठैरी भुंज़ल एज्जले, त काल पेलो। एन सब त सिर्फ मुसीबतां केरि शुरुआत आए। ");
INSERT INTO bhd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“पन तुस अपने बारे मां खबरदार राथ, किजोकि लोक तुसन सभां केरे हवाले केरले, प्रार्थना घरन मां नेइतां मड्डले, त तुस मेरे वजाई सेइं गवर्नरन ते कने राज़न कां खड़े किये गाले, ताके तुस तैन केरे सामने मेरे गवाह भोथ। ");
INSERT INTO bhd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","पन इस युग्गेरो अन्त भोनेरे पेइले एरू भोनू ज़रूरी आए कि परमेशरेरे राज़्ज़ेरे बारे मां खुशखबरी सैरी कौमां केरे लोकन शुनेई गाए।” ");
INSERT INTO bhd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ज़ैखन लोक तुसन नेइतां आदालतां केरे हवाले केरले, त पेइले फिक्र न केरथ त न सोचथ कि अस कुन ज़ोमेले, पन ज़ैन किछ परमेशर तुसन तैस घड़ी ज़ोनेरे लेइ ज़ोवं गालू, तैन्ने ज़ोइयथ। किजोकि ज़ोनेबाले तुस नईं, पन पवित्र आत्मा तुश्शे ज़िरिये ज़ोलो। ");
INSERT INTO bhd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ढ्ला (ज़ै मीं पुड़ विश्वास न केरे, तै) अपने ढ्लाए मरानेरे लेई हवाले केरेलो। त बाजी भी अपने मट्ठे तेन्च़रां हवाले केरेलो, ते बच्चे अपने हाज-बव्वेरे खलाफ भोइतां तैनन् मैरी छ़डेले। ");
INSERT INTO bhd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","मीं पुड़ विश्वास केरनेरे वजाई सेइं सारे लोक तुसन सेइं नफरत केरले, पन ज़ै मरने तगर विश्वासे मां बनोरो रालो, तैस परमेशर मुक्ति देलो। ");
INSERT INTO bhd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","तैल्ला पत्ती, यीशुए तैन सेइं ज़ोवं, “बड़ी बुरी गंदी चीज़, ज़ै नाश केरचे, एजनेबाली आए। तै भिट्टी चीज़ तैस जगाई पुड़ खड़ी भोली, ज़ेड़ी तैसारू खड़ू भोनू जेइज़ नईं। बड़े पेइले दानिय्येल नेबे तैस चीज़ेरे बारे मां ज़ोरू थियूं। (ज़ै कोई एन पढ़े, तै ए गल समझ़े।) ज़ैखन तुस तै चीज़ी तैड़ी खड़ी लाएले, त तैखन ज़ैना लोक यहूदिया इलाके मां रातन, तैना बच़नेरे लेइ पहाड़न पुड़ नेश्शी गान। ");
INSERT INTO bhd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ते अगर कोई मैन्हु अपने घरेरे छते पुड़ भोलो, त तै अकदम तैट्ठां नेश्शी गाए, ते अपने घरेरां किछ नेने अन्तर न गाए (ताके वक्त बरबाद न भोए)। ");
INSERT INTO bhd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ते अगर कोई मैन्हु ऊडारे मां कम केरि राओरो भोलो, त तै भी अकदम तैट्ठां नेश्शी गाए। तै अपना लिगड़ां भी नेनेरे लेइ पत्रोवं न एज्जे। ");
INSERT INTO bhd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","तैन दिहाड़न मां ज़ैना दोज़ींती त दुद्ध पियाती कुआन्शां भोली, तैन केरे लेइ अफ़सोस! (किजोकि तैन केरे लेइ बड़ी मुश्किल भोली।) ");
INSERT INTO bhd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ते तुस प्रार्थना केरा कि एन हियूंतड़ेरे दिहाड़न मां न भोए। ");
INSERT INTO bhd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","किजोकि तैन दिहाड़न मां लोकन बड़ी मुसीबत भोली, कि दुनितयारी शुरुआती केरां देंती ज़ैन परमेशरे बनोरीए, अज़ तगर एरी मुसीबत नईं ओरी। ते एरी ज़ेरि मुसीबत फिरी कधी न भोली।” ");
INSERT INTO bhd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“अगर प्रभु परमेशर तैन मुसीबतेरी दिहाड़न न घटाए, त कोई मैन्हु भी न बच़लो। पन परमेशर अपने च़ुनोरे लोकां केरे वजाई सेइं तैन दिहाड़न घटालो। ");
INSERT INTO bhd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","तैस मुसीबतरे दिहाड़न मां, अगर कोई तुसन सेइं ज़ोए कि, ‘तक्का, मसीह इड़ी आए!’ या ‘तक्का, उड़ी आए!’ त विश्वास न केरथ। ");
INSERT INTO bhd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","किजोकि झूठे मसीह ते कने झूठे नबी एज्जले। तैना लोकन धोखो देनेरे लेइ निशान ते कने चमत्कारेरां कम्मां हिराले, कि अगर भोइ सके, त तैना परमेशरेरे च़ुनोरे लोकन भी धोखो देले। ");
INSERT INTO bhd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","एल्हेरेलेइ, तुस होशियार राथ! हेरा, मीं तुसन सैरी गल्लां भोनेरे पेइले ही ज़ोरिन।” ");
INSERT INTO bhd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","तैल्ला पत्ती, यीशुए तैन सेइं ज़ोवं, “तैन दिहाड़न मां, तैस मुसीबतरे वक्तेरे पत्ती, ‘दिहाड़ो कालो भोइ गालो, त चाँदनी लौ न देली, ");
INSERT INTO bhd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","त अम्बरेरां तारे बिछ़ड़ने लग्गेले, त अम्बरेरी सैरी शेक्ति हिल्लेली।’ ” ");
INSERT INTO bhd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“तैखन लोक मैनेरे मट्ठे (यानी मीं) बड़ी शेक्ति त कने बड़ी महिमा सेइं साथी धेरती पुड़ जो बिदलारी मां एजते हेरेले। ");
INSERT INTO bhd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","तैखन अवं अपने स्वर्गदूतन सारी दुनियाई मां भेज़तां धेरतारे हर पासेरां अपने च़ुनोरे लोकन अकोट्ठे केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","तैल्ला पत्ती, यीशुए तैन सेइं ज़ोवं, “फ़ेगेरे बुटेरे मिसाले केरां अक सबक शिख्खा! ज़ैखन तैसेरी डैलड़ी नरम भोइतां, त नंव्वां पट्लां निस्ने लगतन, ते तुस बुज़्झ़ी छ़ड्तथ कि गेर्मेरो मौसम एजनेबालो आए। ");
INSERT INTO bhd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","एसेरो ज़ेरो, ज़ैखन तुस एना गल्लां, ज़ैना मीं ज़ोई, भोते हेरेले, त तुस बुज़्झ़ी छ़ड्डा कि मैनेरू मट्ठू, यानी अवं बड़े नेड़े पुज़्ज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","अवं तुसन सेइं सच़ ज़ोतईं कि ज़ांतगर एना सैरी गल्लां न भोली, तांतगर एना लोक, ज़ैना हुन्ना ज़ीतेन, तैना न मरेले। ");
INSERT INTO bhd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","अम्बर त कने धरती टेली गाली, पन मेरी गल्लां कधी न टेलेली।” ");
INSERT INTO bhd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","तैल्ला पत्ती, यीशुए तैन सेइं ज़ोवं, “मेरे वापस एजनेरे दिहाड़ेरे बारे मां, या तैस वक्तेरे बारे मां कोई भी न ज़ाने कि तै कताली भोलो, स्वर्गेरे स्वर्गदूते भी न ज़ानन् त परमेशरेरू मट्ठू यानी अवं भी न ज़ैनी, पन सिर्फ मेरो बाजी परमेशर ज़ानते। ");
INSERT INTO bhd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","एल्हेरेलेइ, मेरे वापस एजनेरे लेइ हमेशा तियार राथ, ते प्रार्थना केरते राथ, किजोकि तुस न ज़ानथ कि तै वक्त कताली एज्जलो। ");
INSERT INTO bhd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","मैनेरे मट्ठेरू, यानी मेरू वापस एजनू तैस मैनेरू ज़ेरू आए, ज़ै अपनू घर छ़ेडतां होरे मुल्खे जो गाते। गाने केरां पेइले, तै अपने नौकरन कुजेइतां अपने घरेरी रखवाली केरनेरो अधिकार देते, ते हर एक्की अपनू-अपनू कम देते, त दारे पुड़ रखवाली केरनेरे लेइ संत्री बींझ़ो रानेरो हुक्म भी देते, किजोकि तै कधी भी वापस एज्जी सकते।” ");
INSERT INTO bhd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“एसेरे ज़ेरे, तुस भी हमेशा मेरे वापस एजनेरे लेइ तियार राथ, किजोकि तुस न ज़ानथ कि घरेरो मालिक यानी अवं कताली वापस एज्जेलो। शायद ड्लोझ़ी या एध्धी राती या कुकड़ेरे बांग देनेरे मौके या झ़ेज़्झ़ां। ");
INSERT INTO bhd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","एल्हेरेलेइ तियार राथ! एरू न भोए कि अवं अचानक एइतां लेईं कि तुस तियार नईं। ");
INSERT INTO bhd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ज़ैन अवं तुसन सेइं ज़ोतईं, तैन्ने सारे मैनन् सेइं भी ज़ोतईं कि, ‘हमेशा तियार राथ!’” ");
INSERT INTO bhd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","फ़सहेरू तिहार त कने अखमीरी रोट्टारू तिहार दूई दिहाड़न पत्ती एजनेबालां थियां। प्रधान याजक त कने शास्त्री मौको तोपने लग्गोरे थिये कि अस यीशु केन्च़रां च़ुपचारे ट्लाम ते तैस मैरी छ़ड्डम। ");
INSERT INTO bhd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","पन तैनेईं एप्पू मांमेइं ज़ोवं कि, “अस तिहारेरे दिहाड़न मां यीशुए कैद न केरम, किजोकि तैन दिहाड़न मां बड़े लोक च़ेव्रे पासन भोतन, ते एरू न भोए कि यीशुएरे कैद भोनेरे वजाई सेइं लोकन मां दंगोफसाद भोइ गाए।” ");
INSERT INTO bhd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","यीशु बैतनिय्याह ड्लोंव्वे मां शमौन नंव्वेरे मैनेरे घरे मां थियो, ज़ैस पेइले कोढ़ेरो रोग थियो। ज़ैखन यीशु तैड़ी रोट्टी खेइ राओरो थियो, त तैखन अक कुआन्श संगमरमरे सेइं बनोरे भांडे मां इत्र एन्तां यीशु कां आई, ज़ै बड़ो कीमती थियो त कने ज़ैस जो जटामासी ज़ोतन। तैसां तै इत्र बोतल ट्लोड़तां खोल्ली ते यीशुएरी इज़्ज़त केरनेरे लेइ तैसेरे दोग्गे पुड़ इत्र उलटव। ");
INSERT INTO bhd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","पन किछ मैन्हु, ज़ैना तैड़ी खड़े थिये, तैस कुआन्शी हेरतां अपने दिले मां सेरकोइतां एप्पू मांमेइं ज़ोने लग्गे, “ए कुआन्श किजो एस बड़ी कीमतारो इत्र ज़ाया केरचे? ");
INSERT INTO bhd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ए इत्र त एक्की सालेरी मज़दूरारे पेंइसन केरां भी जादे भाए मां बेच़तां, ते तैना पेंइसे गरीब मैनन् देइ सकती थी!” ते तैना सेरकोइतां तैस सेइं डांटने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","पन यीशुए तैन सेइं ज़ोवं, “एस छ़ेड्डी देथ! एस किजो तंग केरतथ? एसां त मीं सेइं भलाई कियोरीए। ");
INSERT INTO bhd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","गरीब मैन्हु त हमेशा तुसन सेइं साथी रातन। ज़ैखन भी तुस चाथ, तैखन तैन सेइं भलाई केरि सकतथ, पन अवं तुसन सेइं साथी हमेशा न रालो। ");
INSERT INTO bhd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ज़ैन किछ ए कुआन्श केरि सकती थी, तैन एसां कियूं। एसां मेरी जानी पुड़ खुशबूदार तेल लेइतां मेरे मरनेरां पेइली मेरी जान दबनेरे लेई तियार कियोरीए। ");
INSERT INTO bhd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","अवं तुसन सेइं सच़ ज़ोतईं कि सैरी दुनियाई मां ज़ेड़ी कोन्ची मेरे बारे मां खुशखबरी लोकन शुनाई गाली, तैड़ी ज़ैन कम एसां मीं सेइं कियोरूए तैन भी एसेरी यादी मां ज़ोवं गालू।” ");
INSERT INTO bhd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","तैल्ला पत्ती, यहूदा इस्करियोती, ज़ै 12 चेलन मरां अक थियो, प्रधान याजकन कां जेव कि तै यीशु ट्लुवानेरे लेइ तैन केरि मद्दत केरे। ");
INSERT INTO bhd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","एन शुन्तां तैना बड़े खुश भोए, ते तैसेरे मद्दतरे लेइ तैनेईं चैंदेरे रुपेइये देनेरो वादो कियो। एल्हेरेलेइ, तै ठीक मौके बलगने लगो कि यीशु केन्च़रां सेइं ट्लुवाए। ");
INSERT INTO bhd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","अखमीरी रोट्टारे तिहारेरी पेइली दिहाड़ी, ज़ैखन लोक फ़सहेरे तिहारेरे गबड़े बलिदान केरते थिये, तैखन यीशुएरे चेलेईं तैस पुच़्छ़ू, “तू कोड़ि चातस कि अस गेइतां तेरे लेइ फ़सह तिहारेरी रोट्टी तियार केरम?” ");
INSERT INTO bhd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","तैखन यीशुए अपने दूई चेले एन ज़ोइतां भेज़े, “यरूशलेम नगरे मां गाथ, ते अक मैन्हु तुसन पैनेरो घड़ो छ़ुवोरो मैलेलो, तैस पत्ती-पत्ती गेइयथ। ");
INSERT INTO bhd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ते तै ज़ैस घरे मां गालो, तैस घरेरे मालिके सेइं तुस एन ज़ोइयथ कि, इश्शे गुरे ज़ोवरूए कि, ‘मेरे लेइ तियार कियोरो मेहमान कमरो कोड़ि आए, ज़ेड़ी अवं अपने चेलन सेइं साथी फ़सह तिहारेरी रोट्टी खेइ?’ ");
INSERT INTO bhd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","तैखन घरेरो मालिक तुसन दुइयोवं छती पुड़, तियार कियोरो, अक बड्डो कमरो हिरालो। तैड़ी इश्शे लेइ रोट्टी तियार केरथ।” ");
INSERT INTO bhd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ते चेले तैट्ठां निस्तां नगरे मां आए, त ज़ेन्च़रां यीशुए तैन सेइं ज़ोरू थियूं, तेन्च़रां तैनेईं लावं। ते तैनेईं फ़सह तिहारेरी रोट्टी तियार की। ");
INSERT INTO bhd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ज़ैखन ड्लोझ़ भोइ, त यीशु अपने 12 चेलन सेइं साथी मेहमान कमरे मां अव। ");
INSERT INTO bhd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ज़ैखन तैना बिश्तां रोट्टी खेइ राओरे थिये, त यीशुए तैन सेइं ज़ोवं, “अवं तुसन सेइं सच़ ज़ोतईं कि तुसन मरां अक, ज़ै मीं सेइं साथी रोट्टी खेइ राओरोए, मीं धोखे सेइं ट्लुवालो।” ");
INSERT INTO bhd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","एन शुन्तां तैना सारे चेले उदास भोए, ते तैना अक-अक केरतां यीशु सेइं पुछ़ने लग्गे, “कुन अवं आईं? कुन अवं आईं?” ");
INSERT INTO bhd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","यीशुए तैन सेइं ज़ोवं, “तै तुसन बारहन मरां अक आए, ज़ै मीं सेइं साथी बिश्तां इश्शी एक्की थैली मां रोट्टी खेइ राओरोए। ");
INSERT INTO bhd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ज़ेन्च़रां मैनेरू मट्ठू यानी मेरे बारे मां परमेशरेरी किताबी मां लिखोरूए, तेन्च़रां अवं मारो गानोईं। अफ़सोस! (किजोकि तैस मैन्हु बड़ी सज़ा मैल्लनीए एजने बालीए) ज़ेसेरे वजाई सेइं मैनेरू मट्ठू यानी अवं ट्लुवाव गानोईं! अगर तै मैन्हु ज़रमोरो न भोथो, त तैसेरे लेई तैन भलू थियूं।” ");
INSERT INTO bhd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ज़ैखन यीशु त तैसेरे चेले फ़सहेरी रोट्टी खेइ राओरे थिये, यीशुए अक रोट्टी ट्लेइतां परमेशरेरू शुक्र केरतां ट्लोड़ी। तैल्ला पत्ती, तैनी तै अपने चेलन दित्ती, ते तैन सेइं ज़ोवं, “ट्लाथ ते खाथ। ई मेरो जिसम आए।” ");
INSERT INTO bhd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","फिरी यीशुए दाछ़ारे रस्सेरो कटोरो ट्लेइतां परमेशरेरू शुक्र कियूं। तैल्ला पत्ती, तैनी तै अपने चेलन दित्तो, ते तैनेईं सैरेईं पियो। ");
INSERT INTO bhd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","तैखन तैनी तैन सेइं ज़ोवं, “ए दाछ़ारे रस मेरो खून आए, ज़ै परमेशर त कने लोकां केरे मझ़ाटे नव्वों करार बनाते, ज़ै बड़े लोकां केरे मैफारे लेइ बगाव गालो। ");
INSERT INTO bhd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","अवं तुसन सेइं सच़ ज़ोतईं कि अवं दाछ़ारो रस तैस दिहाड़ी तगर फिरी कधी न पीलो, ज़ांतगर परमेशरेरे राज़्ज़े मां अवं नंव्वो दाछ़ारे रस पीं। ");
INSERT INTO bhd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","तैल्ला पत्ती, यीशु त कने तैसेरे चेले परमेशरेरू भजन ज़ोइतां, यरूशलेम नगरेरे बेइर ज़ैतून नंव्वेरे पहैड़ी पुड़ च़ले जे।” ");
INSERT INTO bhd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","तैखन यीशुए अपने चेलन सेइं ज़ोवं, “तुस सारे मीं छ़ेडतां नश्शेले, किजोकि परमेशरेरी किताबी मां लिखोरू कि, ‘अवं पुहाले मैरेलो ते तैसेरी भैड्डां इरां उरां नेश्शी गाली।’ ");
INSERT INTO bhd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","पन अवं मेरतां मुड़दन मरां फिरी ज़ींतो भोनोईं। तैल्ला पत्ती, अवं तुसन केरां पेइले गलील इलाके जो गालो त तैड़ी तुस मीं लाएले।” ");
INSERT INTO bhd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","तैखन पतरसे यीशु सेइं ज़ोवं, “अगर सारे तीं छ़ेडतां नश्शेले त नश्शन, पन अवं कधे न नेश्शेलो।” ");
INSERT INTO bhd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","यीशुए पतरसे सेइं ज़ोवं, “अवं तीं सेइं सच़ ज़ोतईं कि अज़्ज़ेरी राती कुकड़ेरे दूई बार बांग देने केरां पेइले, तू ट्लाई बार मेरो इन्कार केरेलो कि तू मीं न ज़ानस।” ");
INSERT INTO bhd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","पन पतरसे मना ज़ोरे सेइं यीशु सेइं ज़ोने लगो, “अगर मीं तीं सेइं साथी मरनू भी पे, त फिरी भी अवं तेरो इन्कार कधी न केरेलो।” एन्च़रां होरि चेलेईं भी ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","तैल्ला पत्ती, यीशु ते तैसेरे चेले गतसमनी नंव्वेरे एक्की बागी मां जे, ते तैड़ी यीशुए अपने किछ चेलन सेइं ज़ोवं, “इड़ी बिश्शोरे राथ, ज़ां तगर अवं प्रार्थना न केरि।” ");
INSERT INTO bhd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","फिरी यीशुए पतरस ते याकूब ते यूहन्ना एप्पू सेइं साथी बागी मां अग्गर निये, ते तैड़ी तै बड़े परेशान भोने ते कने घबराने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ते तैखन यीशुए तैन सेइं ज़ोवं, “मेरो दिल बड़ो उदास आए, इड़ी तगर कि अवं मरनेबालोईं। तुस इड़ी बलगा, ते बींझ़े राथ।” ");
INSERT INTO bhd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","फिरी तै बागी मां थोड़ो ज़ेरे अग्गर गेइतां, तल्ले मां ज़ैन्धु केरे भारे बिश्तां प्रार्थना केरने लगो कि अगर भोइ सके त ए दुख्खेरी घड़ी मीं पुड़ेरां टेली गाए। ");
INSERT INTO bhd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ते तैनी प्रार्थनाई मां एन ज़ोवं, “बैपू! हे मेरे बाजी, तुसन केरां सब किछ भोइ सकते। एस दुख्खेरो कटोरो मीं केरां दूर केरा। फिरी भी ज़ैन अवं चाताईं तैन नईं, पन ज़ैन तुस चातथ तैन्ने भोए।” ");
INSERT INTO bhd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","फिरी तै अपने ट्लाई चेलन कां वापस अव, त तैना झ़ुल्लोरे मैल्ले, ते तैनी तैना बींझ़ाए, त तैनी शमौन-पतरसे सेइं ज़ोवं, “हे शमौन, कुन तू झ़ुल्लोरोस? कुन तू अक घड़ी भी बींझ़ो न रेइ सकस?” ");
INSERT INTO bhd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","तैखन यीशुए तैन सैरेन सेइं ज़ोवं, “बींझ़े ते प्रार्थना केरते राथ ताके तुस अज़मैइशी मां न पेथ। तुस त अज़मैइश रोकनी चातथ, पन तुसन कां रोकनेरी ताकत नईं।” ");
INSERT INTO bhd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ते यीशु फिरी अपने चेलन केरां थोड़े दूर च़लो जेव, त ज़ैना गल्लां तैनी पेइले ज़ोइतां प्रार्थना कियोरी थी, तैन्नां गल्लां दुबारां ज़ोइतां प्रार्थना की। ");
INSERT INTO bhd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ते फिरी वापस एइतां हेरू कि तैना चेले झ़ुल्लोरेन, किजोकि तैन एत्री निड्ली थी, कि तैन केरि एछ़्छ़ी भी न थी लोरी खुलने। ज़ैखन यीशुए तैना बींझ़ाए, त तैना शरमाने लग्गे कि यीशुए कुन जुवाब देम! ");
INSERT INTO bhd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","फिरी ट्लेइयोवं बार गेइतां यीशुए प्रार्थना की ते वापस एइतां फिरी तैन सेइं ज़ोवं, “कुन तुस हेजू झ़ुल्लोरेथ! बड़ू आए! हुनी घड़ी एज्जी जोरी! हेरा, मैनेरू मट्ठू (यानी अवं) पापी मैन्हु केरे हथ्थन मां ट्लुवेइयोव गानोईं। ");
INSERT INTO bhd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","उठा, च़लम। हेरा! मीं ट्लुवानेबालो नेड़े पुज़्ज़ी जोरो!” ");
INSERT INTO bhd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","यीशु एन्ने ज़ोई राओरो थियो कि अकदम यहूदा ज़ै 12 चेलन मरां अक थियो, एप्पू सेइं साथी मैन्हु केरि अक बड्डी भीड़ एन्तां तैड़ी पुज़्ज़ी जेव, ज़ैन कां तलवारां ते डंडे थिये। तैना प्रधान याजक ते शास्त्री लोक ते कने यहूदी लोकां केरे बुज़ुर्गां केरि तरफां यीशु कैद केरनेरे लेइ भेज़ोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","यीशुएरो ट्लुवानेबालो यहूदा तैड़ी पुज़ने केरां पेइले, तैन मैनन् जो निशान दित्तोरो थियो कि ज़ैस अवं फुम्मड़ी देलो तैए यीशु आए, तैस ट्लेइतां ध्याने सेइं नेइयथ। ");
INSERT INTO bhd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ज़ैखन यहूदा ते मैन्हु केरि भीड़ बागी मां आई, त तैनी अकदम यीशु सेइं ज़ोवं, “हे रब्बी (गुरू)” ते तैस फुम्मड़ी दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","तैखन तैनेईं यीशु ट्लेइतां कैद कियो। ");
INSERT INTO bhd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","यीशुएरे चेलन मरां, ज़ैना तैसेरे नेड़े खड़े थिये, एक्के अपनि तलवारे सेइं महायाजकेरे एक्की नौकरे पुड़ च़लाई त तैसेरो अक कन केट्टी छ़ड्डो। ");
INSERT INTO bhd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","यीशुए तैन मैनन् सेइं ज़ोवं, “कुन तुस मीं डैकू समझ़तां ट्लानेरे लेइ तलवारां ते डंडे घिन्तां ओरेथ? ");
INSERT INTO bhd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","अवं त हर दिहाड़ी मन्दरे मां तुसन सेइं साथी रेइतां परमेशरेरे बारे मां लोकन शिक्षा देतो थियो, पन तैखन तुसेईं अवं न ट्लाव। पन एन एल्हेरेलेइ भोने लग्गेरू कि पवित्रशास्त्रे मां मेरे बारे मां ज़ैना गल्लां लिखोरिन तैना पूरी भोन।” ");
INSERT INTO bhd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","तैखन यीशुएरे सारे चेले तैस छ़ेडतां नेश्शी जे। ");
INSERT INTO bhd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ते अक जवान ज़ैनी अपनि नग्गी जानी पुड़ अक लिगड़ पलेट्टेरू थियूं, यीशु पत्ती च़लो। ते भीड़ी मरां किछ मैनेईं तै ट्लाव। ");
INSERT INTO bhd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","पन तै तैन केरे हथ्थन मां अपनू लिगड़ छ़ेडतां नग्गो नेश्शी जेव। ");
INSERT INTO bhd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","तैल्ला पत्ती, मैन्हु केरि भीड़ां यीशु महायाजकेरे घरे मां नीयो। ते सारे प्रधान याजक ते कने बुज़ुर्ग त कने शास्त्री यीशुएरू इमतिहान नेनेरे लेइ महायाजके सेइं साथी तैड़ी अकोट्ठे भोए। ");
INSERT INTO bhd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","यीशु त कने मैन्हु केरि भीड़ी केरा दूर-दूर रेइतां पतरस तैन पत्ती-पत्ती महायाजकेरे महलेरे अंगने तगर पुज़्ज़ी जेव। ते तैड़ी तै महायाजकेरे पैरदारे सेइं साथी बिश्तां अग तपने लगो। ");
INSERT INTO bhd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","मेहलेरे अन्तर, प्रधान याजक त कने सारी महासभा यीशुएरे खलाफ गवाही तोपनेरी कोशिश केरि राओरे थिये, ताके तैना तैस मैरी सकन, पन तैनन् किछ न मैल्लू। ");
INSERT INTO bhd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","किजोकि बड़े मैन्हु यीशु पुड़ झूठी गवाही देने लग्गोरे थिये, पन तैन केरि गवाही अक्कां ज़ेरि न थी। ");
INSERT INTO bhd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","आखरी मां किछ मैनेईं उठतां तैसेरे खलाफ ई झूठी गवाही दित्ती कि, ");
INSERT INTO bhd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“असेईं एस केरां एन ज़ोते शुनेरू कि, ‘अवं मैन्हु केरू बनोरू एस मन्दरे बिछ़ोड़तां ट्लेइ दिहाड़न मां होरू मन्दर बनालो, ज़ैन मैन्हु केरू बनोरू न भोलू।’ ” ");
INSERT INTO bhd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","पन एन ज़ोइतां भी तैन केरि गवाही अक्कां ज़ेरि न निस्सी। ");
INSERT INTO bhd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","तैखन महायाजके आदालतेरे मझ़ाटे खड़े भोइतां यीशु पुच़्छ़ू, “एना लोक तेरे खलाफ गवाही देतन, कुन तू कोई जुवाब नईं देस?” ");
INSERT INTO bhd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","पन यीशु च़ुप राव, ते किछ जुवाब न दित्तो। तैखन महायाजके तैस फिरी पुच़्छ़ू, “कुन तू परमेशरेरू मट्ठू मसीह आस?” ");
INSERT INTO bhd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","यीशुए ज़ोवं, “हाँ, अवं तै आईं। ते ज़ेन्च़रां परमेशरेरी किताबी मां लिखोरू कि ‘तुस सारे लोक, मैनेरू मट्ठू (यानी मीं) सर्वशक्तिमान परमेशरेरी देइने पासे बिश्शोरे त अम्बरे मरां बिदलारे सेइं साथी धेरती पुड़ एजते हेरेले।’” ");
INSERT INTO bhd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","तैखन महायाजके सेरकोइतां, अपना चोगो छ़िन्दतां आदालतेरे मैनन् सेइं ज़ोवं, “हुनी असन होरि केन्चेरी गवाहेरी ज़रूरत नईं! ");
INSERT INTO bhd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","तुसेईं एप्पू परमेशरेरी तुहीन शुनी! ते तुस एसेरो कुन फैसलो केरतथ?” तैखन तैनेईं सारे मैनेईं ज़ोवं कि, “ए मैन्हु दोषी आए किजोकि एनी परमेशरेरी तुहीन की, एल्हेरेलेइ, एस मौतरी सज़ा दे।” ");
INSERT INTO bhd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","तैखन तैन मरां किछ मैन्हु, तैसेरी बेज़ती केरनेरे लेइ, तैस पुड़ थुकने लग्गे। ते किछ मैन्हु तैसेरी एछ़्छ़ी लिगड़े सेइं ढेकतां तैस मुक्केईं बाने लग्गे ते तैस सेइं ज़ोने लग्गे, “भविष्यिवाणी केर कि केनि तीं बाई।” ते नौकरेईं भी तैस ट्लेइतां थप्पड़ बाए। ");
INSERT INTO bhd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ज़ैखन पतरस, महायाजकेरे महलेरे अंगने मां थियो, त महायाजकेरे नौकरेनन मरां अक कुआन्श तैड़ी आई। ");
INSERT INTO bhd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","तैसां पतरस अग तपतो लाव। ते तै कुआन्श पतरस तेकतां तैस सेइं ज़ोने लग्गी, “तू भी एस नासरत नगरेरो यीशु सेइं साथी थियो।” ");
INSERT INTO bhd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","पन पतरसे यीशुएरो इन्कार कियो ते ज़ोवं, “अवं न ज़ैनी ते न सेमझ़ी कि तू कुन लगोरिस ज़ोने।” फिरी तै तैट्ठां बेइर डेवढी मां जेव। तैखन कुकड़े बांग दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ज़ैखन तैसां नौकरेनां फिरी पतरस लव, त तै तैन सेइं, ज़ैना नेड़े खड़े थिये, ज़ोने लग्गी, “ए मैन्हु तैसेरे चेलन मरां अक आए!” ");
INSERT INTO bhd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","पन पतरसे फिरी यीशुएरो इन्कार कियो। थोड़े च़िरे बाद, ज़ैना पतरसेरे नेड़े खड़े थिये, तैनेईं तैस सेइं ज़ोवं, “पक्को तू भी तैसेरे चेलन मरां अक आस, किजोकि तू गलील इलाकेरो मैन्हु भी आस।” ");
INSERT INTO bhd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","तैखन पतरस कसम केरतां ज़ोने लगो, “मीं फिटकार लग्गे, अगर अवं झूठ ज़ोईं कि अवं एस मैन्हु ज़ानतो भोईं, ज़ेसेरे बारे मां तुस गल्लां केरने लग्गोरेथ!” ");
INSERT INTO bhd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","तैखन अकदम दुइयोवं बार कुकड़े बांग दित्ती। ज़ै गल यीशुए पतरसे सेइं पेइली ज़ोरी थी, तै गल तैस याद आई कि, “कुकड़ेरे दूई बार बांग देने केरां पेइले तू ट्लाई बार मेरो इन्कार केरेलो कि तू मीं न ज़ानस।” तैखन तैनी बड़ी लेरां दित्ती, किजोकि तैनी यीशुएरो इन्कार केरनेरे वजाई सेइं बड़ो दुखी भोव। ");
INSERT INTO bhd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","झ़ेज़्झ़ भोंते, अकदम प्रधान याजकेईं, ते यहूदी लोकां केरे बुज़ुर्गेईं, ते कने शास्त्री लोकेईं ते कने सारे महासभारे मैनेईं यीशुएरे खलाफ सलाह केरतां तै बन्धाव ते तैट्ठां नेइतां रोमी गवर्नर पिलातुसेरे हवाले कियो। ");
INSERT INTO bhd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पिलातुसे यीशु पुच़्छ़ू, “कुन तू यहूदी लोकां केरो राज़ो आस?” यीशुए तैस जुवाब दित्तो, “तू एप्पू ज़ोई राओरोस।” ");
INSERT INTO bhd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","तैखन प्रधान याजक तैस पुड़ बेड़ि गल्लां केरो झूठो इलज़ाम लेइ राओरे थिये। पन यीशुए किछ न ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पिलातुसे तैस फिरी पुच़्छ़ू, “तू किछ भी जुवाब की न देस? हेर, एना लोक तीं पुड़ केत्री गल्लां केरो इलज़ाम लेइ राओरेन!” ");
INSERT INTO bhd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","हांलाकि यीशुएरी किछ भी गलती न थी, तैनी किछ जुवाब न दित्तो, इड़ी तगर कि पिलातुस बड़ो हैरान भोव। ");
INSERT INTO bhd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","हर साल फ़सह तिहारेरे वक्ते पुड़ यहूदी लोकां केरे लेइ केन्ची एक्की कैदी, ज़ैस तैना लोक चाते थिये तैस पिलातुस छ़ेड्डी देतो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","तैन दिहाड़न बरअब्बा नंव्वेरो अक मैन्हु किछ दंगेफसाद केरनेबालन सेइं साथी कैदखाने मां थियो, ज़ैनेईं दंगेफसादे मां कत्ल कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","तैखन मैन्हु केरि भीड़ पिलातुसे कां गेइतां मिन्नत केरने लग्गी कि, “ज़ैन तू इश्शे लेइ हर साल केरतो ओरोस तैन्ने केर।” ");
INSERT INTO bhd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पन पिलातुसे तैनन् पुच़्छ़ू, “तुस कुन चातथ कि अवं तुश्शे लेइ यहूदी केरे राज़े यानी तुश्शे राज़े छ़ेड्डी देईं?” ");
INSERT INTO bhd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","पिलातुसे लोकन एन्च़रां पुच़्छ़ू, किजोकि तै ज़ानतो थियो कि प्रधान याजक यीशु पुड़ ज़लतन तांए तैनेईं तै ट्लुवोरोए। ");
INSERT INTO bhd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","पन प्रधान याजकेईं लोक बमकाए, ताके पिलातुस तैन केरे लेइ यीशुएरे बदले बरअब्बा छ़ेड्डी दे। ");
INSERT INTO bhd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","एन शुन्तां पिलातुसे लोकन फिरी पुच़्छ़ू, “अगर अवं बरब्बे छ़ेड्डी देईं, त ज़ैस तुस यहूदी लोकां केरो राज़ो ज़ोतथ, तैसेरू अवं कुन केरि?” ");
INSERT INTO bhd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","तैना पिलातुसे सेइं फिरी शोर केरतां ज़ोने लग्गे कि, “एस क्रूसे पुड़ च़ाढ़!” ");
INSERT INTO bhd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलातुसे तैनन् पुच़्छ़ू, “किजो ए क्रूसे पुड़ च़ाढ़नो, एनी कुन बुराई कियोरीए?” पन तैना लोक पेइले केरां जादे शोर केरने लग्गे कि, “एस क्रूसे पुड़ च़ाढ़!” ");
INSERT INTO bhd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","तैखन पिलातुसे लोक खुश केरनेरे इरादे सेइं, बरअब्बा तैन केरे लेइ छ़ड्डी दित्तो, ते यीशु कोड़े लुवेइतां सिपेही केरे हवाले कियो कि तैना यीशु क्रूसे पुड़ च़ाढ़न। ");
INSERT INTO bhd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","तैखन सिपाही यीशुए पिलातुसेरे महलेरे अंगने मां नेइ जे, ज़ैस जो प्रीटोरियम ज़ोतन। ते तैनेईं सारी रोमी पलटन कुजेइतां आनी। ");
INSERT INTO bhd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","तैखन तैनेईं यीशुएरो मज़ाक बनानेरे लेइ तैसेरां लिगड़ां खोल्लां, ते तैस लाल रंगेरो चोलो लुवाव ते कने कंटां केरू ताज बनेइतां तैसेरे दोग्गे पुड़ रख्खू। ");
INSERT INTO bhd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ते एन ज़ोने लग्गे कि, “हे यहूदी केरा राज़ा, नमस्कार!” ");
INSERT INTO bhd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","तैना यीशुएरे दोग्गे पुड़ अक्केरे पत्ती अक केरतां सोटी सेइं बाने लग्गे, ते तैसेरी बेज़ती केरनेरे लेइ तैस पुड़ थुकने लग्गे, ते मज़ाक बनानेरे लेइ तैसेरे अग्गर ज़ैन्धु केरे भारे बिश्तां तैस नमस्कार केरते राए। ");
INSERT INTO bhd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","तैसेरो मज़ाक बनानेरे पत्ती, तैनेईं तैस पुड़ेरां लाल रंगेरो चोगो खोलतां तैसेरां लिगड़ां लुवां। तैखन तैना यीशु क्रूसे पुड़ च़ाढ़नेरे लेइ यरूशलेमेरे नगरे केरां बेइर नीयो। ");
INSERT INTO bhd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ज़ताली तैना तैट्ठां च़ेलि राओरे थिये, त तैखन शमौन नंव्वेरो मैन्हु ड्लोंव्वेरां तैलमेइं एज्जी राओरो थियो। तै मैन्हु कुरेनी नंव्वेरे नगरेरां ओरो थियो ते तै सिकन्दर ते कने रूफुसेरो बाजी थियो। तैखन सिपाहेईं शमौन मजबूर कियो कि तै यीशुएरे लेइ तैसेरी क्रूसे छ़ुइतां च़ले। ");
INSERT INTO bhd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ते तैनेईं यीशु गुलगुता नंव्वेरी ठैरी पुड़ आनो, ज़ेसेरो मतलब “खोपड़ारी ठार” आए। ");
INSERT INTO bhd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","फिरी किछ लोकेईं मुर्र नंव्वेरी दवाई, दाछ़ारे रस्से मां मिलेइतां यीशु पीने जो दित्ती, पन तैनी तैसेरो इन्कार केरतां न पी। ");
INSERT INTO bhd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","तैखन तैनेईं यीशु क्रूसे पुड़ च़ाढ़ो ते तैसेरां लिगड़ां केरे लेइ पेरची छ़ड्डी कि तैसेरां लिगड़ां केस मैलतन। तैल्ला पत्ती, तैनेईं तैसेरां लिगड़ां बेन्टी छ़ड्डां। ");
INSERT INTO bhd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ज़ैखन तैनेईं तै क्रूसे पुड़ च़ाढ़ो, तैखन झ़ेज़्झ़ेरे नौ बज़्ज़ोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ते एक्की फेट्टी पुड़ तैसेरी सज़ारी वजा लिखतां तैसेरे क्रोड़ी केरां बां लेइ छ़ड्डी। तैस मां लिखोरू थियूं कि, “ए यहूदी लोकां केरो राज़ो आए।” ");
INSERT INTO bhd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","सिपाहेईं यीशु सेइं साथी होरे दूई डैकू भी, अक तैसेरे देइने पासे ते अक तैसेरे बाएं पासे अलग-अलग क्रूसन पुड़ च़ाढ़े। ");
INSERT INTO bhd_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","तैखन परमेशरेरी किताबी मां लिखोरी गल पूरी भोइ। तैस मां मसीहेरे बारे मां एरू लिखोरू थियूं कि, “ते पापी मैन्हु केरे साथी गनो गालो।” ");
INSERT INTO bhd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","तैखन बत्तां च़लनेबालन मरां किछ मैन्हु अपनि क्रोड़ी हिलेइ-हिलेइतां ते कने एन ज़ोइतां तैसेरी तुहीन केरते थिये कि, “वाह! वाह! मन्दर बिछ़ोड़नेबालो, त कने ट्लेइ दिहाड़न मां बनानेबालो! ");
INSERT INTO bhd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","अगर तू शक्तिशाली आस त क्रूसे पुड़ेरां ओस्तां अपने आपे बच़ा!” ");
INSERT INTO bhd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","एन्च़रां प्रधान याजक भी शास्त्री लोकन सेइं साथी तैसेरो मज़ाक बनेइ राओरे थिये, त तैना एप्पू मांमेइं ज़ोते थिये कि, “एनी होरे मैन्हु त बच़ाए, पन अपने आपे बच़ेइ न सको। ");
INSERT INTO bhd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ए ज़ोरो थियो कि ‘अवं इस्राएल लोकां केरो राज़ो आईं, यानी मसीह आईं,’ अगर ए गल सच़ आए त हुन्ना क्रूसे पुड़ेरां ओस्से, ताके अस हेरतां विश्वास केरम कि ए इश्शो राज़ो आए।” त दूई डैकू, ज़ैना तैस सेइं साथी क्रूसे पुड़ च़ाढ़ोरे थिये, तैनेईं भी तैसेरी बेज़ती की। ");
INSERT INTO bhd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","दीसारे बारे बज़ेई सारे मुल्खे मां आंधरू भोवं, ते ट्लेइ बज़न तगर रावं। ");
INSERT INTO bhd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ट्लेइ बज़ेई यीशुए बड़ी ज़ोरे सेइं अपनि बोली मां ज़ोवं कि, “इलोई, इलोई, लमा शबक्तनी!” ज़ेसेरू मतलब, “हे मेरे परमेशर, हे मेरे परमेशर, तीं किजो अवं छ़ेड्डी दित्तो!” ");
INSERT INTO bhd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","तैखन ज़ैना तैड़ी नेड़े खड़े थिये, तैन मरां किछ मैनेईं एन शुन्तां गलत सेमझ़तां एप्पू मांमेइं ज़ोवं, “हेरा, ए मैन्हु एलिय्याहे जो मद्दत केरनेरे लेइ कुजेई राओरोए।” ");
INSERT INTO bhd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","तैखन तैन मरां एक्की मैने दौड़तां स्पन्जे (ज़ै पेनेरी ज़ेरि चीज़ चूसी सकचे) खट्टे दाछ़ारे रस्से मां डुबेइतां डांगी पुड़ रेखतां यीशु जो चुसावं त ज़ोवं, “बलगा, हेरम, एलिय्याह एस क्रूसे पुड़ेरां उसालने एजते कि नईं।” ");
INSERT INTO bhd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","तैखन यीशुए बड़े ज़ोरे सेइं आवाज़ देइतां प्राण दित्ते। ");
INSERT INTO bhd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ते तैखन मोट्टो पर्दो, ज़ै मन्दरे मां लोरो थियो, बां देंता बुन तगर फेटतां दूई टुक्ड़े भोइ जे। ");
INSERT INTO bhd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ज़ैखन फौजी-अफसर, ज़ै यीशुएरे सामने खड़ो थियो, यीशु एन्च़रां ज़ोरे सेइं आवाज़ देइतां प्राण देंतो लाव, तैखन तैनी ज़ोवं, “सच़्च़े, ए मैन्हु परमेशरेरू मट्ठू थियूं!” ");
INSERT INTO bhd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","किछ कुआन्शां भी दूरेरां एन हेरी राओरी थी। तैन मां मगदलीन नगरेरी मरियम, निकड़ो याकूब ते योसेसेरी अम्मा मरियम, त कने सलोमी भी थी। ");
INSERT INTO bhd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ज़ैखन यीशु गलील इलाके मां थियो, त तैखन एना कुआन्शां तैस पत्ती-पत्ती च़ेलती थी त तैसेरी सेवा केरती थी। त तैड़ी होरि भी बड़ी कुआन्शां थी, ज़ैना तैस सेइं साथी गलील इलाके मरां यरूशलेम नगरे मां ओरी थी। ");
INSERT INTO bhd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ज़ैखन ड्लोझ़ भोइ, ते एल्हेरेलेइ कि तै तिहारेरी दिहाड़ी थी, यानी आरामेरे दिहाड़ेरे पेइली दिहाड़ी ज़ैखन लोक आरामेरी दिहाड़ेरे लेइ तियार भोते थिये, त तैखन ");
INSERT INTO bhd_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","अरिमतियाह नगरेरो रानेबालो यूसुफ नंव्वेरो मैन्हु तैड़ी अव, ज़ै यहूदी लोकां केरे बड्डे आदालतेरे खास मैनन् मरां अक थियो। तै एप्पू भी परमेशरेरे राज़्ज़े बलगने लोरो थियो। तै मैन्हु हिम्मत केरतां गवर्नर पिलातुसे कां जेव ते यीशुएरी लाश मग्गी, ताके तै तैस दबनेरे लेइ ने। ");
INSERT INTO bhd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","तैखन पिलातुस हैरान भोव कि केन्च़रां तै एत्री लूशी मेरि जेव। त तैनी फौजी-अफसर कुजेइतां पुच़्छ़ू, “कुन तै मेरि जोरोए?” ");
INSERT INTO bhd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ज़ैखन तैनी फौजी-अफसरे केरां हाल ज़ानो कि यीशु सच़्च़े मेरि जेव, त तैनी यूसुफे लाश नेनेरी अज़ाज़त दित्ती। ");
INSERT INTO bhd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","तैखन यूसुफे अक कीमती लिगड़ घिन्नू ते यीशुएरी लाश क्रूसे पुड़ेरां ओसैलतां यहूदी लोकां केरि रसमेरे मुताबिक तैस लिगड़े मां पलेटतां एक्की कब्री मां छ़ेड्डी, ज़ै पहैड़ी पुड़ एक्की घोड़े मां घड़ोरी थी। त तैस कब्रेरे बेइर दारे पुड़ अक बड्डो घोड़ घिसेइतां छ़ड्डो। ");
INSERT INTO bhd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मगदलीन ड्लव्वेरी मरियम, ते योसेसेरी अम्मा मरियम, एना दुइये हेरी राओरी थी कि यीशुएरी लाश कोड़ि रखतन। ");
INSERT INTO bhd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","होरसां ड्लोझ़ी, ज़ैखन आरामेरी दिहाड़ी खतम भोरी थी, त तैखन मगदलीन ड्लंव्वेरी मरियम, त कने याकूबेरी अम्मा मरियम, त कने सलोमी, एन सेब्भेईं रोड़ी मुशकी बालो तेल आनो, ताके यहूदी लोकां केरि रसमेरे मुताबिक यीशुएरी लाशी पुड़ तेल लान। ");
INSERT INTO bhd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","हफ्तेरे पेइले दिहाड़े झ़ेज़्झ़ां-झ़ेज़्झ़ां, ज़ैखन मसां दिहाड़ो निस्सी राओरो थियो, त तैना कब्री कां जेई ज़ैस मां यीशुएरी लाश रखोरि थी। ");
INSERT INTO bhd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","तैखन तैना एप्पू मांमेइं ज़ोती थी, “इश्शे लेइ कब्रेरे दारे पुड़ेरां घोड़ कौन गिसालो?” ");
INSERT INTO bhd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","किजोकि तै घोड़ बड़ो बड्डो थियो। पन तैड़ी पुज़नेरे बाद, तैनेईं कब्रेरे पासे उब्री तक्कू त हेरू कि घोड़ पेइलो कब्रेरे दारे पुड़ेरां गिस्सोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","तैनेईं कब्रेरे अन्तर गेइतां अक जवान लाव ते तैना बेड़ि हैरान भोइ जेई। तैस छ़ित्तां लिगड़ां लेग्गोरां थियां, ते तैड़ी तैन केरे सिध्धे पासे बिश्शोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","तैनी जवाने तैन सेइं ज़ोवं, “डरा न, अवं ज़ानताईं कि तुस नासरत नगरेरे यीशु तोप्पी राओरिथ, ज़ै क्रूसे पुड़ च़ाढ़रो थियो। तै मुड़दन मरां ज़ींतो भोरोए। तै इड़ी नईं। हेरा, ई तैए ठार आए, ज़ेड़ी तैसेरी लाश रख्खोरी थी। ");
INSERT INTO bhd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","पन तुस गेइतां तैसेरे चेलन सेइं त कने पतरसे सेइं भी ज़ोइयथ कि यीशु तुसन करां पेइलो गलील इलाके जो गालो। ज़ेन्च़रां तैनी पेइलू तुसन सेइं ज़ोरू थियूं, तेन्च़रां तुस तैस तैड़ी लाले।” ");
INSERT INTO bhd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","तैना कुआन्शां कब्री मरां बेइर निस्तां तैट्ठां नेश्शी जेई, किजोकि तैनन् थर्क लग्गोरी त घेबरोरी थी। बत्तां तैनेईं केन्ची सेइं किछ न ज़ोवं, किजोकि तैना डेर्री थी। ");
INSERT INTO bhd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","हफ्तेरे पेइले दिहाड़े झ़ेज़्झ़ भोते, यीशु मुड़दन मरां ज़ींतो भोइतां पेइले मगदलीन नगरेरी मरियमी लेइहोव, ज़ैस मरां तैनी पेइलां सत भूतां केरो सायो कड्डोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","मरियमां यीशु लानेरे पत्ती, गेइतां तैसेरे चेलन खबर दित्ती, ज़ैना यीशुएरे लेइ शोग केरने लग्गोरे ते कने लेरां देने लग्गोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","पन ज़ैखन तैनेईं तैसारी गल शुनी कि यीशु फिरी ज़ींतो भोरोए ते तैसां लेवरोए, त तैनेईं तैसारी गल्ली पुड़ याकीन न कियूं। ");
INSERT INTO bhd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","तैल्ला पत्ती, यीशु अपने चेलन मरां दूई चेलन होरि रूपे मां लेइहोव, ज़ैखन तैना (यरूशलेम) नगरेरां अपने ड्लोंव्वे जो च़लोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","तैखन तैनेईं भी नगरे वापस एजतां यीशुएरे होरे चेलन खबर दित्ती, पन तैनेईं तैन केरि गल्लारो भी विश्वास न कियो। ");
INSERT INTO bhd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","तैल्ला पत्ती, यीशु अपने 11 चेलन भी लेइहोव, ज़ैखन तैना रोट्टी खेइ राओरे थिये। त तैन केरे अविश्वास त कने सखत दिलेरे वजाई सेइं यीशुए तैना डांटे, किजोकि तैनेईं तैन केरो विश्वास न कियो, ज़ैनेईं यीशु ज़ींतो भोनेरे पत्ती तै लेवरो थियो। ");
INSERT INTO bhd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","यीशुए अपने चेलन ज़ोवं, “तुस सैरी दुनियाई मां गेइतां सारे लोकन मेरे बारे मां खुशखबरी शुनाथ। ");
INSERT INTO bhd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ज़ै कोई मीं पुड़ विश्वास केरे ते बपतिस्मो ने, तैस पापां केरि सज़ाई करां मुक्ति मैलेली। पन ज़ै कोई विश्वास न केरे, तैस अपने पापां केरि सज़ा मैलेली। ");
INSERT INTO bhd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ज़ैना मीं पुड़ विश्वास केरतन, तैना एरां चमत्कारेरां कम्मां (निशाना) केरले कि तैना मेरे नंव्वे सेइं लोकन मरां भूतां केरो सायो कढेले, ते नंव्वी-नंव्वी बोली केरले। ");
INSERT INTO bhd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ते अगर तैना ज़ेहरीले सप्पन ट्लाले त कने ज़ेहरीली चीज़ भी पीले, तांभी तैनन् किछ नुकसान न भोलो। ते ज़ैखन तैना बिमारन पुड़ हथ रख्खेले, ते तैना बेज़्झ़ोइ गाले।” ");
INSERT INTO bhd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","यीशु अपने चेलन सेइं गल्लां केरनेरां पत्ती, परमेशरे तै स्वर्गे जो नीयो। ते यीशु परमेशरेरे देइने पासे राज़गेद्दी पुड़ बिश्शी जेव। ");
INSERT INTO bhd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ते यीशुएरे चेलेईं बेइर हर जगाई गेइतां लोकन खुशखबरी शुनाने लग्गे। ते प्रभु तैन सेइं साथी कम केरतो राव। तैना चमत्कारेरां कम्मां (निशानन) केरे ज़िरिये, ज़ैना साथी-साथी भोतां थियां, प्रभु साबत केरतो राव कि तैन केरि गल्लां सच़ आन। आमीन।");
INSERT INTO bhd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","जनाब थियुफिलुस, बड़े लोकेईं तैना गल्लां हेरी ज़ैना प्रभु-यीशुए कियोरी थी, ज़ैखन तै असन सेइं साथी थियो, ज़ेइसेरां तैनी अपनू सेवारू कम शुरू कियोरू थियूं। तैन मैनेईं होरि मैनन् यीशुएरे बारे मां शिक्षा देइतां परमेशरेरी सेवा की। बड़े मैनेईं तैन केरि गल्लां शुन्तां यीशुएरे बारे मां इश्शे लेइ इतिहासेरी किताब लिखी। ");
INSERT INTO bhd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","मीं एप्पू तैन सैरी गल्लां केरि बड़े रोड़ेच़ारे छानबीन की। एल्हेरेलेइ, मीं एन रोड़ू लग्गू, कि अवं भी तुश्शे लेइ तैन गल्लां केरे बारे मां ठीक डंगे सेइं इतिहासेरी किताब लिखी। ");
INSERT INTO bhd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","अवं चाताईं कि तीं पतो लग्गे कि यीशुएरे बारे मां तैना गल्लां सच़्च़ी आन, ज़ैन केरे बारे मां तुसन शिक्षा मैल्लोरी थी। ");
INSERT INTO bhd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहूदिया इलाके मां, ज़ैखन हेरोदेस राज़ो राज़ केरतो थियो, त तैखन जकर्याह नंव्वेरो अक यहूदी याजक थियो। तै मैन्हु याजकां केरे टोली मां अबिय्याह नंव्वेरो टोली मरां थियो। तैसेरी कुआन्शारू नंव एलीशिबा थियूं। एलीशिबा हारूनेरे खानदेंनी मरां थी, (हारून इस्राएल लोकां केरो पेइलो याजक थियो)। ");
INSERT INTO bhd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","तैना दुइये प्रभु-परमेशरेरी नज़री मां धर्मी थियां ते कने परमेशरेरे सारे कानून ते सारे हुक्मन पुड़ बेइलज़ाम च़लनेबालां थियां। ");
INSERT INTO bhd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","पन तैन केरि कोई औलाद न थी, किजोकि एलीशिबा बाँझ थी, ते तैना दुइये बुढ़ां थियां। ");
INSERT INTO bhd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","एक्की फेरे, जकर्याहेरी टोली यरूशलेम नगरेरे मन्दरे मां सेवारू कम केरि राओरे थी, तैखन तै प्रभु परमेशरेरी हज़ूरी मां अपनू याजकेरू कम लोगोरो थियो केरने। ");
INSERT INTO bhd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","याजकां केरे रीतरे मुताबिक तैनेईं परची छ़ेडतां जकर्याह च़ुनो कि तै प्रभु-परमेशरेरे मन्दरे मां गेइतां गुग्गल बाले। ");
INSERT INTO bhd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ज़ैखन तै गुग्गल बालने लोरो थियो, त तैखन मैन्हु केरि सारी भीड़ मन्दरेरे बेइर प्रार्थना केरि राओरी थी। ");
INSERT INTO bhd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","तैखन अचानक प्रभु-परमेशरेरो अक स्वर्गदूत गुग्गल बालनेरी ठारारे देइने पासे खड़े भोइतां जकर्याह लेइहोव। ");
INSERT INTO bhd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ज़ैखन जकर्याहे स्वर्गदूत लाव, त तै घेमरोव ते बड़ो डेरि जेव। ");
INSERT INTO bhd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","पन स्वर्गदूते तैस सेइं ज़ोवं, “हे जकर्याह, न डर! ज़ैखन तीं प्रार्थना की, त परमेशरे तेरी प्रार्थना शुनी। एल्हेरेलेइ, तेरी कुआन्श एलीशिबाई मट्ठू भोनूए, ते तू तैसेरू नंव यूहन्ना रेख्खां। ");
INSERT INTO bhd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","तैसेरे ज़र्म भोने सेइं तू बड़ो खुश भोलो। त बड़े लोक भी खुश भोले। ");
INSERT INTO bhd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","तै प्रभु-परमेशरेरी नज़री मां महान भोलो, ते तैनी कोन्ची भी किसमेरी नश्शे बाले चीज़ त कने शराब कधे न लोड़े पियोरी, ते तै अपनि अम्मारे पेटे मां भोते वक्तेरां परमेशरेरी पवित्र आत्मारी शेक्ति सेइं भरपूर भोलो। ");
INSERT INTO bhd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","तै इस्राएली लोकन मरां बड़े लोक परमेशरेरे पासे ज़ै तैन केरो प्रभु परमेशरे वापस तैस कां आनेलो, ज़ैना अपने पापां केरि वजाई सेइं परमेशरे करां दूर भोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ते तै एरो मैन्हु भोलो ज़ैस पुड़ एलिय्याहरी आत्मा ते कने शक्ति भोली। तै परमेशरेरी बत तियार केरेलो, तैस अग्री-अग्री च़लेलो ताके हाज बव्वां केरो दिल औलादरे पासे ते परमेशर न मन्नेबाले लोकन धेर्मी लोकां केरे बत्तां केरे पासे बदलेलो, ताके ज़ैखन प्रभु एज्जे त लोक तियार भोन।” ");
INSERT INTO bhd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","जकर्याहे स्वर्गदूते पुच़्छ़ू, “अवं केन्च़रे मेन्नी एन असन सेइं भोनूए, अवं त बुढोइं ते मेरी कुआन्श भी बुढी भोरीए।” ");
INSERT INTO bhd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","स्वर्गदूते जुवाब दित्तो, “अवं जिब्राईल आईं अवं परमेशरे कां खड़ो भोताईं, अवं एल्हेरेलेइ भेज़ोरोईं, कि अवं तीं सेइं गल केरि ते तीं ए खुशखबरी शुनेई। ");
INSERT INTO bhd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ते हेर ज़ां तगर एना गल्लां पूरी न भोन तेरी ज़बान बंद भोली, ते तू गल न केरि सकेलो किजोकि तीं मेरी गल्लां केरू याकीन नईं कियेरू ज़ैना अपने वक्ते पुड़ पूरी भोनिन।” ");
INSERT INTO bhd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ते ज़ैखन जकर्याह ते स्वर्गदूत मन्दरे मां गल्लां लोरे थिये केरने त लोक मन्दरेरे बेइर अंगने मां जकर्याहे बलगने लोरे थिये, तैना बड़े हैरान भोइजेइ कि जकर्याहे मन्दरे मां एत्रू च़िर किजो लाव। ");
INSERT INTO bhd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ज़ैखन तै बेइर निस्सो, त तै कुजी न बटो ते तैन लोकेईं बुझ़ी छ़डू, कि एनी मन्दरे मां किछ दर्शन लाहेरूए किजोकि तै इशारो केरतो थियो, पन कुजी न थियो बटतो। ");
INSERT INTO bhd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ज़ेइस यरूशलेम नगरेरे मन्दरे मां जकर्याहरू एक्की हफतेरे याजकेरी सेवारू कम पूरू भोवं, त तै अपने घरे जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","किछ वक्तेरां बाद तैसेरी कुआन्श एलीशिबा दोज़ींतीए भोइ, ते तै पंच़ महीन्न तगर बेइर लोकन मां न जेई। तैसां ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“प्रभुए मीं पुड़ दया केरतां केत्रू महान कम कियूं, ते अवं दोज़ींती भोइ, ते ज़ैस गल्लरे वाजाई सेइं लोक मीं घटिया समझ़ते थिये, तै गल दूर की।” ");
INSERT INTO bhd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","एलीशिबारे दोज़ींती भोनेरे शेइयोवं महीने जिब्राईल स्वर्गदूत परमेशरेरी तरफां गलील इलाकेरे नासरत नगरे मां, ");
INSERT INTO bhd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","एक्की अड्लैई कुइये कां भेज़ो। तैसारी कुड़माइ दाऊदेरे खानदाने मरां एक्की मड़दे सेइं भोरी थी ज़ेसेरू नवं यूसुफ थियूं, ते तैस कुइयरू नवं मरियम थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","स्वर्गदूते तैस कां एइतां ज़ोवं, “आनन्द ते ज़ींत तेरी भोए, तीं पुड़ परमेशरेरी बड़ी दया भोरीए, प्रभु तीं सेइं साथिये!” ");
INSERT INTO bhd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","मरियम स्वर्गदूतेरी गल शुन्तां परेशान भोइतां सोचने लगी एन केरहु नमस्कारे? ");
INSERT INTO bhd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","स्वर्गदूते तैस सेइं ज़ोवं “हे मरियम, डर न, किजोकि परमेशरेरो तीं पुड़ बड़ो अनुग्रह भोरोए। ");
INSERT INTO bhd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","तू दोज़ींती भोली तीं अक मट्ठू भोलू, ते तू तैसेरू नवं यीशु रेखां। ");
INSERT INTO bhd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","तैन महान भोलू ते तैस जो परमप्रधान परमेशरेरू मट्ठू ज़ोले, ते परमेशर तैस तैसेरे पूर्वज दाऊद राज़ेरू ज़ेरो राज़ो बनालो। ");
INSERT INTO bhd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ते तै याकूबेरे खानदाने पुड़ हमेशा राज़ केरेलो, ते तैसेरू राज़ कधे खतम न भोलू।” ");
INSERT INTO bhd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरियमा स्वर्गदूते पुच़्छ़ू, “एन केन्च़रे भोइ सकते? अवं त अड्लाई आईं।” ");
INSERT INTO bhd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","स्वर्गदूते जुवाब दित्तो, “पवित्र आत्मा तीं पुड़ उतरेलो, ते परमप्रधान परमेशरेरी शक्ति तीं पुड़ सैयो केरेली एल्हेरेलेइ तै बच्चो ज़ै ज़र्मएलो तै पवित्र भोलो तैस जो परमेशरेरू मट्ठू ज़ोले। ");
INSERT INTO bhd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ते हेर तेरी रिशतेदार एलीशिबाई भी बुढ़े बारे मट्ठू भोने बालूए तैस जो लोक बाँझ ज़ोते थिये, तैस दोज़ींती शा महीने भोरेन। ");
INSERT INTO bhd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","किजोकि परमेशरेरे लेइ किछ भी नमुमकिन नईं।” ");
INSERT INTO bhd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियमा स्वर्गदूते जुवाब दित्तो, “अवं परमेशरेरी सेवा केरती ज़ैन तीं ज़ोरूए तैन भोए।” तैखन स्वर्गदूत तैस करां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","किछ दिहाड़न पत्ती मरियम तियार भोइतां यहूदियारे इलाकेरे एक्की पहाड़ी नगरे मां जेई। ");
INSERT INTO bhd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ते जकर्याहरे घरे मां गेइतां एलीशिबा जो नमस्कार कियूं। ");
INSERT INTO bhd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ज़ैखन एलीशिबा मरियमारू नमस्कार शुनू त बच्चो तैसारे पेटे मां उछ़ड़ने लगो ते एलीशिबा पवित्र आत्माई सेइं भेरोई जेई। ");
INSERT INTO bhd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ते बड़े ज़ोरे सेइं ज़ोने लगी, “तू कुआन्शन मां धन आस ते ज़ै बच्चो तीं ज़ांनोए तै भी धने! ");
INSERT INTO bhd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ते मेरे लेइ बड़ी इज़्ज़तरी गल आए कि, मेरे प्रभुएरी अम्मा मीं कां आई! ");
INSERT INTO bhd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","किजोकि हेर ज़ेरि तेरे नमस्कारेरी आवाज़ मीं शुनी त बच्चे खुशी सेइं मेरे पेटे मां छालां लगो मारने। ");
INSERT INTO bhd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","तू धन आस तीं तैन गल्लन पुड़ विश्वास कियो ज़ैना प्रभुए तीं सेइं ज़ोई कि, तैना पूरी भोली।” ");
INSERT INTO bhd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ते मरियमा ज़ोवं, “अवं प्रभुएरी तारीफ़ केरती। ");
INSERT INTO bhd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ते मेरी आत्मा मेरे मुक्ति देनेबाले परमेशरे सेइं खुशी भोइ। ");
INSERT INTO bhd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","किजोकि तैनी अपनि सेवा केरने बैलरी गिरोरी हालती पुड़ नज़र की, अज़ेरां देइतां हर ज़मानेरे लोक मींजो धन ज़ोले। ");
INSERT INTO bhd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","किजोकि परमेशरे मेरे लेइ बड़ां-बड़ां कम्मां कियोरन ते तैसेरू नवं पवित्र भोए। ");
INSERT INTO bhd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","तैसेरी दया तैस करां डरने बालन पुड़ पीड़ी-पीड़ी तगर राचे। ");
INSERT INTO bhd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","तैनी अपने शेक्ति सेइं बड्डां-बड्डां कम्मां कियोरन तैनी घमण्डी तितर-बितर किये। ");
INSERT INTO bhd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","तैनी राज़े राज़ केरने करां रोके, ते तैनी नम्र लोकन आदर दित्ती। ");
INSERT INTO bhd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","तैनी नियन्ने रोड़ी-रोड़ी चीज़ेइं सेइं रज़ांने ते धन दौलती बाले खाली हथेइं भेज़े। ");
INSERT INTO bhd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","तैनी अपने वादे ज़ैना तैनी इश्शे दादन-पड़दादन सेइं कियोरे थिये याद किये, तैनी अपनि सेवा केरनेबाले इस्राएली लोकां केरि मद्दत की, ");
INSERT INTO bhd_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","तैनी हमेशारे लेइ अब्राहमे पुड़ ते तैसेरी औलादी पुड़ दया केरनि याद रख्खी।” ");
INSERT INTO bhd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम कोई ट्लाई महीन्न तगर एलीशिबा सेइं साथी राई ते फिरी अपने घरजो आई। ");
INSERT INTO bhd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","एलीशिबारो गल्हे बिशनेरो वक्त एज्जी अव ते तैस मट्ठू भोवं। ");
INSERT INTO bhd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","तैसारे आसेपासेरे रिशतेदारेइं एन शुनू कि परमेशरे तैस पुड़ बड़ी दया कियोरिये ते तैस सेइं साथी खुशी मनाई। ");
INSERT INTO bhd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","अठोवं दिहाड़े तैना मट्ठेरो खतनो केरने आए, ते तैना तैसेरू नवं तैसेरे बाजी केरे नव्वें पुड़ जकर्याह रखनू चाते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","पन तैसेरी अम्मा ज़ोने लगी, “नईं एसेरू नवं यूहन्ना भोलू।” ");
INSERT INTO bhd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","किछ तैस जो ज़ोने लगे, “तुश्शी खानदेंनी मां कोई भी एस नव्वेंरो नईं।” ");
INSERT INTO bhd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","तैखन तैन लोकेईं जकर्याहरे पासे इशारे सेइं पुच़्छ़ू कि तू मट्ठेरू नवं कुन रखनू चातस? ");
INSERT INTO bhd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ते तैनी पटारी मगी ते तैस पुड़ लिखू, “एसेरू नवं यूहन्ना आए,” ते सब लोक हैरान रेइजे। ");
INSERT INTO bhd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","तैखने तैसेरी ज़िभ खुल्ली ते जकर्याह गल्लां लगो केरने ते परमेशरेरी तारीफ़ केरने लगो। ");
INSERT INTO bhd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ते आसे-पासेरे लोक एस तमाशे हेरतां हैरान रेइजे, ते यहूदियारे इलाकेरे एक्की पहाड़ी नगर मां एस गल्लरी चरचा भोने लगी। ");
INSERT INTO bhd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ते शुन्ने बाले अपने-अपने मन्न मां सोचते थिये, “एन मट्ठू बड्डू भोइतां केरहु भोनूए?” किजोकि परमेशरेरी शक्ति अज़्ज़ेरी देंतीं एस सेइं साथीए? ");
INSERT INTO bhd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","तैखन तैसेरो बाजी जकर्याह पवित्र आत्माई सेइं भेरोवं ते भविष्यिवाणी केरने लगो। ");
INSERT INTO bhd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“प्रभु इस्राएलेरो परमेशर धन भोए, किजोकि तैनी एइतां अपने लोकन मुक्ति दित्तोरिये। ");
INSERT INTO bhd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ते तैसेरे दास दाऊदेरे घराने मरां इश्शे लेइ अक मुक्ति देनेबालो भेज़ोरोए। ");
INSERT INTO bhd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(बड़े पेइले ज़ेन्च़रे पवित्र नेबी केरे ज़िरिये ज़ोरू थियूं, ज़ैन शुरू करां देंते ओरूए।) ");
INSERT INTO bhd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","असां अपने दुश्मन करां ते बैर रखने बालन करां मुक्ति हासिल केरम। ");
INSERT INTO bhd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ते तै इश्शे दादे पड़दादन पुड़ दया केरे ते अपनो पवित्र करार याद केर। ");
INSERT INTO bhd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","तै करार ज़ै तीं इश्शे पूर्वज अब्राहमे सेइं कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","कि तै असन हिम्मत देलो, कि असां अपने दुश्मन करां बगैर केन्ची भी डरे सेइं बेंच़ी सखम। ");
INSERT INTO bhd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ते अपनि ज़िन्दगी तैस सोंफम ते सारी ज़िन्दगी पवित्रेइ ते धार्मिकता ज़ींम। ");
INSERT INTO bhd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ते हे बच्चां तू नबी भोलो किजोकि तू परमेशरेरे अग्री-अग्री च़ेलतां लोकन तियार केरेलो कि परमेशर एजनोए। ");
INSERT INTO bhd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","तै अपने लोकन तैन केरे पाप माफ़ केरनेरे ज़िरिये मुक्तरे बारे मां ज्ञान देलो। ");
INSERT INTO bhd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ते इश्शे परमेशरेरी दया एरी भोली ज़ेन्च़रे दिहाड़ो लौ देते तेन्च़रे मसीह स्वर्गेरां एज्जेलो। ");
INSERT INTO bhd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ताके तैन केरे लेइ ज़ैना पापे मां ज़ीतन ते हमेशारे मौतरे खतरे मां रातन लौ दे, ते तै असन बत हिराए ताके अस सुखे सेइं ज़िन्दगी ज़ींम।” ");
INSERT INTO bhd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","तैन मट्ठू यानी यूहन्ना बेडोतो जेव ते आत्माई मां बद्धतो जेव ते इस्राएलेरे लोकन प्रचार केरने तगर सुनसान ठैरन मां राव। ");
INSERT INTO bhd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","तैन दिहैड़न मां रोम मुलखेरे महाराज़े औगुस्तुसे एलान कियूं कि, दुनियारे सारे मैन्हु केरि गिनती की गाए। ");
INSERT INTO bhd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ए पेइली मैन्हु केरि गिनती थी, ज़ै सीरिया इलाकेरे गवर्नर क्विरिनियुसेरे वक्ते मां भोइ। ");
INSERT INTO bhd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ते सारे लोक, मैन्हु केरि गिनतरे लेइ नवं लिखाने अपने-अपने पूर्वजां केरे नगर जो च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","यूसुफ भी गलील इलाकेरे नगर नासरते मरां यहूदिया इलाके मां दाऊदेरे नगर बैतलहम मांजो च़लो, किजोकि तै दाऊद राज़ेरे खानदाने मरां थियो। ");
INSERT INTO bhd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ताके तैड़ी मरियमी सेइं साथी ज़ैस सेइं तैसेरी कुड़माइ भोरी थी ते तै दोज़ींती थी नवं लिखाए। ");
INSERT INTO bhd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","तैन केरे तैड़ी रेइतां तैसारे गल्हे बिशनेरो वक्त अव। ");
INSERT INTO bhd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ते तैस पेइलू मट्ठू भोवं ते तैसां तैन फैल्हड़ी मां पलेटतां खुरली मां रख्खू किजोकि तैन धर्मशाली मां कोन्च ठार न थी मैल्लोरी। ");
INSERT INTO bhd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","किछ पुहाल राती एक्की ड्लबड़े मां गब्बां केरो पैरहो केरते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ते परमेशरेरो स्वर्गदूत तैन कां बांदो भोव ते परमेशरेरी महिमारी लौ तैन केरे च़ेव्रे पासन बलने लगी ते तैना बड़े डेरि जे। ");
INSERT INTO bhd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","तैखन स्वर्गदूते तैन जो ज़ोवं, “डरा नन्ना, किजोकि अवं तुसन अक बड़ी खुशखबरी शुनाने ओरोईं, ज़ै खुशी सैरी लोकां केरे लेइ भोली। ");
INSERT INTO bhd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","अज़ बैतलहमे मां ज़ैन दाऊद राज़ेरू नगर थियूं, तुश्शे लेइ अक मुक्ति देनेबालो ज़रमोरोए यानी यीशु मसीह प्रभु। ");
INSERT INTO bhd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","तैसेरो तुश्शे लेइ ए निशान भोलो कि तुसन अक मट्ठू फैल्हड़ी मां पलैट्टेरू गाल्हरे बेइर खुरली मां मैलेलू।” ");
INSERT INTO bhd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ते अकदम तैस स्वर्गदूते सेइं होरे भी स्वर्गदूत बांदे भोए ते तैना परमेशरेरी तारीफ़ केरने लगे ते एन ज़ोने लगे, ");
INSERT INTO bhd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“स्वर्गे मां परमेशरेरी महिमा भोए, ते ज़मीनी पुड़ तैन मैनन् शान्ति मैल्ले, ज़ैन पुड़ परमेशर खुशे।” ");
INSERT INTO bhd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ज़ैखन स्वर्गदूत पुहालां केरे सामने वापस स्वर्गे मांजो च़ले जे। पुहाल एप्पू मांमेइं ज़ोने लगे, “एज्जा अस बैतलहम नगरे मां गाम ज़ै बिस्तार प्रभुए असन दित्तोरोए तैस हेरम।” ");
INSERT INTO bhd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","एल्हेरेलेइ तैना लूशी तैट्ठां च़ले जे ते तैड़ी पुज़े ते सच़्च़े तैड़ी मरियम, यूसुफ ते निकड़ो बच्चो फैल्हड़ी मां पलेट्टोरो गोरू केरि गाल्हरे बेइर खुरली मां मैल्लो। ");
INSERT INTO bhd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ते पुहाल एन हेरतां ज़ै गल तैन एस बच्चेरे बारे मां ज़ोरी थी सेब्भन सेइं ज़ोने लगे। ");
INSERT INTO bhd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","पुहालां केरि गल्लां शुन्तां सारे लोक हैरान रेइजे। ");
INSERT INTO bhd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","पन मरियम सैरी गल्लां अपने दिले मां रेखतां सोचने लगी। ");
INSERT INTO bhd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ते पुहालन ज़ेन्च़रे तैनी स्वर्गदूते ज़ोरू थियूं, तैनेईं अपनि एछ़्छ़ेईं तैन सब किछ लेइतां परमेशरेरी तारीफ़ केरते वापस घरजो च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","अठोवं दिहाड़े ज़ेइस तैसेरो खतनो केरनेरो वक्त अव त तैसेरू नवं यीशु रख्खू। एन तैन नवं आए, ज़ैन स्वर्गदूते मरियमारे दोज़ींतीए भोने करां पेइले रख्खेरू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ज़ैखन मूसेरे कानूनेरे मुताबिक तैसेरे शुच्चे भोनेरे दिहाड़े पूरे भोए, त यूसुफे ते मरियमा यीशु यरूशलेम नगरे मांजो नीयो ताके तैस प्रभुए कां अर्पण केरन। ");
INSERT INTO bhd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ज़ेन्च़रे प्रभुएरे कानूने मां लिखोरूए, “सारां पेइलां मट्ठां परमेशरे लेइ पवित्र भोलां।” ");
INSERT INTO bhd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ज़ेन्च़रे प्रभुएरे कानूने मां लिखोरूए कि, “अक जोड़ी गुघू केरि या कबूतरेरे दूई बच्चे बलिदानेरे लेइ आन।” ");
INSERT INTO bhd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","तैस वक्ते यरूशलेम नगरे मां अक मैन्हु थियो, तैसेरू नवं शमौन थियूं, तै बड़ो धर्मी ते भक्त मैन्हु थियो, तै मसीह बलगने लोरो थियो, कि तै एज्जेलो ते इस्राएली लोकन शान्ति देलो, ते तैस पुड़ पवित्र आत्मा थियो। ");
INSERT INTO bhd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","पवित्र आत्मा तैस पुड़ बांदू कियूं, कि ज़ां तगर तू प्रभुएरे मसीह न लाएलो तांतगर न मरेलो। ");
INSERT INTO bhd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","तैस दिहाड़े शमौन पवित्र आत्मा च़लाव, तै आत्मिक शेक्ति सेइं मन्दरे मां अव तैखन यीशु भी तैसेरे अम्मा बाजेईं अन्तर आनोरो थियो, कि तैसेरेलेइ मूसेरे कानूनेरे मुताबिक कमाम। ");
INSERT INTO bhd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","त शमौने बच्चो कुम्मे मां ट्लातो ते परमेशरेरी तारीफ़ केरने लगो। ");
INSERT INTO bhd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“हे प्रभु तीं ज़ै अपनो वादो कियोरोए अपने दासे आनन्दे सेइं मरने दे। ");
INSERT INTO bhd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","किजोकि मीं अपने एछ़्छ़ेईं सेइं मुक्ति देनेबालो लाव, ज़ै तीं सैरी लोकां केरे लेइ भेज़ोरोए। ");
INSERT INTO bhd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ज़ै तीं सैरी कौमां केरे सामने तियार कियोरोए। ");
INSERT INTO bhd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","तै, परमेशर गैर कौमन पुड़ बांदो केरनेरे लेइ लौ आए, ते इस्राएली लोकां केरे लेइ अक बड़ी महिमा भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","यीशुएरे अम्मा बाजी शमौनेरी एना गल्लां शुन्तां हक्के-बक्के भोए। ");
INSERT INTO bhd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","तैखन शमौने तैन बरकत दित्ती, ते तैसेरी अम्मा मरियम सेइं ज़ोवं, “हेरा, इन मट्ठू एल्हेरेलेइ ठहरावरो, कि इस्राएले मां बड़े लोकां केरे लेइ नाश भोनेरी ते मुक्ति मैलनेरी वजा भोए, तै परमेशरेरी तरफां अक निशान आए पन बड़े लोक तैसेरे खलाफ भोले। ");
INSERT INTO bhd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ताके बड़े दिलां केरे खियाल खुल्ली गान ते तीं बड़ो दुःख भोनोए ज़ेन्च़रे तलवार कटतीए।” ");
INSERT INTO bhd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","तैड़ी अक कुआन्श थी ज़ै नबिन थी, तैसारू नवं हन्नाह थियूं, अशेरेरे खानदाने मरां अक मैन्हु ज़ेसेरू नवं फनूएल थियूं, हन्नाह तैसेरी कुई थी तै बड़ी बुढी थी तै अपने ड्लाहेरां बाद सत साल अपने मुन्शे सेइं साथी रहोरी थी। ");
INSERT INTO bhd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","तै विधवा थी तैसारी उमर चूरासी साल थी तै मन्दरे मरां न थी गाती ते रात दिहैड़ी प्रार्थना ते कने बरतां रखती ते परमेशरेरी आराधना केरती रहती थी। ");
INSERT INTO bhd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","तैखन तै भी तैड़ी एइतां परमेशरेरू शुक्र केरने लगी ते बच्चेरे बारे मां तैन सेब्भन सेइं गल्लां लाई केरने, ज़ैना बलगने लोरे थिये कि परमेशरे यरूशलेम नगरेरे लोकन छुटानेरे लेइ मसीह भेज़नोए। ");
INSERT INTO bhd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ज़ैखन मरियम ते यूसुफे मूसेरे कानूनेरे मुताबिक यीशुएरो खतनो कियो, त तैना गलील इलाके मरां अपने नगर नासरते मांजो जे। ");
INSERT INTO bhd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","तैन मट्ठू बडोतू जेवं ते अक्लमन्द भोतू जेवं किजोकि परमेशरेरो तैस पुड़ बड़ो अनुग्रह थियो। ");
INSERT INTO bhd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","यीशुएरे अम्मा बाजी हर साल फ़सह तिहारेरी दिहाड़ी बनाने यरूशलेम नगरे मां गाते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ज़ैखन यीशु 12 सालां केरो भोव त तैना रीतरे मुताबिक यरूशलेम नगरे मां जे। ");
INSERT INTO bhd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ज़ैखन तिहार बीतू त यीशुएरे अम्मा बाजी वापस घरजो आए त यीशु यरूशलेम नगरे मां रेइ जेव ते तैसेरे अम्मा बाजी कोई पतो न थियो। ");
INSERT INTO bhd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","तैनेईं बुझ़ू कि यीशु होरि मैनन् सेइं साथी अग्रोवं जोरोए, तैना अपने रिशतेदारन ते ज़ान पिशानी बालन मां तोपने लगे। ");
INSERT INTO bhd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ज़ैखन तैन यीशु न मैल्लो त तैना वापस तोपते-तोपते यरूशलेम नगरे मां पुज़े। ");
INSERT INTO bhd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ट्लेइयोवं दिहाड़े तैन यीशु मन्दरेरे अंगने मां बुज़ुर्ग लोकन सेइं गलबात केरतो ते तैन सेइं सवाल जुवाब केरतो मैल्लो। ");
INSERT INTO bhd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ज़ैना लोक तैसेरी गल्लां शुन्ने लोरे थिये तैना यीशुएरी गल्लां शुन्तां हैरान रेइजे। ");
INSERT INTO bhd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ज़ैखन तैसेरे हाज बव्वेईं यीशु लाव त तैना हैरान रेइजे ते ज़ोने लगे, “मट्ठां तीं असन सेइं एन कुन कमाव? तेरे हाज बव तीं तोपते-तोपते परेशान भोइ जे।” ");
INSERT INTO bhd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","यीशु तैन सेइं ज़ोवं तुस मीं किजो तोपने लग्गोरो थिये? “तुसन पतो नईं कि मीं अपने बाजेरे घरे मां रानू ज़रूरी थियूं?” ");
INSERT INTO bhd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","पन तैन तैना गल्लां केरि समझ़ न आई कि, एन केरो कुन मतलब आए। ");
INSERT INTO bhd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","तैखन तै अपने अम्मा बाजी सेइं साथी नासरत नगरे मां अव ते अपने अम्मा बाजी कां राव ते मरियमा एना सैरी गल्लां अपने दिले मां रेख्खी। ");
INSERT INTO bhd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","यीशु अक्ली मां भी ते कदे मां भी बेडोतो जेव ते परमेशरेरी ते इन्सानेरी कृपाई मां बद्धतो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","तिबिरियुस महाराज़ेरे हुकुमतरे परनोहूँ साले मां ज़ेइस पुन्तियुस पिलातुस यहूदिया इलाकेरो गवर्नर थियो, ते गलीलेरे इलाके मां हेरोदेस गवर्नर थियो, तैसेरो ढ्ला फिलिप्पुस इतूरैया ते त्रखोनीतिस इलाकां केरो गवर्नर थियो, लिसानियास, अबिलेन इलाकेरो गवर्नर थियो। ");
INSERT INTO bhd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","तैस वक्ते हन्ना ते कैफा महायाजक थिये, तेइस परमेशरे जकर्याहरे मट्ठे यूहन्ना सेइं गल्लां की। ज़ैन सुनसान ठैरी मां रातू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ते यूहन्ना यरदन दरियारे आसेपासेरे इलाकन मां गेइतां ई प्रचार केरने लगो, कि अपने पापन करां मनफिराथ, ते बपतिस्मो नेथ ताके परमेशर तुश्शे पाप माफ़ केरे। ");
INSERT INTO bhd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ज़ेन्च़रे यशायाह नेबेरी किताबी मां लिखोरूए, “सुनसान ठैरी मां फुकारने बालेरी आवाज़ एइचे कि, ‘प्रभुएरी बत बनाथ ते तैसेरी बत्तां पैठ्ठी केरा।’” ");
INSERT INTO bhd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“डुग्घी ठारां सैरी भेरोई गैनिन, हर अक पहाड़ ते च़ौढ़ु बछ़ोड़नोए ते ज़ैना ट्लेढी बत्तन तैना सिधी केरनिन ज़ैना उन्ढी उबरिन तैना पैठ्ठी केरनिन। ");
INSERT INTO bhd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ते सब लोक तैस हेरेले, ज़ै परमेशरे तैन मुक्ति देने भेज़ोरोए।” ");
INSERT INTO bhd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ते यूहन्ना तैन लोकन सेइं ज़ोवं, ज़ैना जथन मां तैस करां बपतिस्मो नेने ओरे थिये, “तुस ज़ेहरीले सप्पेरे ज़ेरे बुरे आथ! तुसन केनि ज़ोवं कि, एजनेबाले परमेशरेरे कोपे करां नश्शा? ");
INSERT INTO bhd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","बस्सा, सज़ाई करां बच़नेरे लेइ तैना कम्मां केरा, ज़ैन सेइं पतो लग्गे तुसेईं सच़्च़े पापन करां मन फिरावरोए। ते अपने-अपने मने मां एन न ज़ोथ कि, अब्राहम ज़ेन्च़रे इश्शो बाजीए, किजोकि अवं तुसन सेइं ज़ोताईं कि परमेशर इन घोड़न मरां अब्राहमेरे लेइ औलाद पैदा केरि सकते। ");
INSERT INTO bhd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ते हुन्ना त बुट्टां केरे ज़ीलन पुड़ परमेशरेरो मैक्कु रख्खोरोए, एल्हेरेलेइ ज़ै कोई तैस बुट्टेरो ज़ेरो भोते, ज़ै रोड़ो फल न दे, तै कटनोए ते अग्गी मां छ़डनोए।” ");
INSERT INTO bhd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","लोकेईं तैस पुच़्छ़ू, “फिरी असां परमेशरेरी सज़ाई करां केन्च़रे बच़म?” ");
INSERT INTO bhd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","यूहन्ना तैन सेइं ज़ोवं, “ज़ैस कां दूई कुरतेन त अक कुरतो तैस देथ ज़ैस कां अक भी नईं ते ज़ैस कां रोट्टी आए त तै भी रोट्टी बंटे ज़ैन कां नईं।” ");
INSERT INTO bhd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ते धड़त नेनेबाले भी बपतिस्मो नेने ओरे थिये तैनेईं तैस पुच़्छ़ू, “हे गुरू जी असां कुन केरम?” ");
INSERT INTO bhd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","तैनी तैन सेइं ज़ोवं, “ज़ैन तुश्शे लेइ सरकारी कानूनेरे हिसाबे सेइं रख्खोरूए तैस करां जादे धड़त न नेइयथ।” ");
INSERT INTO bhd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ते तैखन होरि सिपाहीएइं भी तैस पुच़्छ़ू, “असां कुन केरम?” यूहन्ना तैन सेइं ज़ोवं, “केन्ची पुड़ ज़ुलम केरतां बेहक न नेइयथ, ते न केन्ची पुड़ झूठो दोष लेइयथ, पन अपनि तनखुवाही पुड़ गुज़ारो केरथ।” ");
INSERT INTO bhd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","तैखन लोक इंतज़ारे मां थिये कि, मसीह जल्दी एजनोए, ते सब लोक अपने दिले मां यूहन्नारे बारे मां सोचते थिये कि ज़ै ओरोए तै मसीह आए या नईं? ");
INSERT INTO bhd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","त यूहन्ना तैन जुवाबे मां तैन सेइं ज़ोवं, “अवं त तुसन पैनी सेइं बपतिस्मो देताईं पन ज़ै मीं करां महाने तै एजनेबालो आए। अवं तैसेरो गुलाम बेनतां तैसेरी जुट्टी केरे तसमे भी खोलनेरे काबल नईं। तै तुसन पवित्र आत्माई ते अग्गी सेइं बपतिस्मो देलो। ");
INSERT INTO bhd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","तैसेरू छज्ज तैसेरे हथ्थे मां आए ते तै खलाड़ रोड़ेच़ारे साफ केरेलो, ते गेहुं अपने कोठारे मां रखेलो पन झ़ाझ़ी तैस अग्गी मां फुकेलो ज़ै कधी हिशनेरी न भोली।” ");
INSERT INTO bhd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","बस्सा तै बड़े रोड़ेच़ारे लोकन समझ़ेइतां परमेशरेरी खुशखबरी शुनातो राव। ");
INSERT INTO bhd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","हेरोदेस च़ेवरोवं मुलखे पुड़ राज़ केरतो थियो। यूहन्ना तै झ़िड़कावरो थियो, कि हेरोदेस अपने ढ्ला फिलिप्पुसेरी कुआन्श हेरोदियास ज़ै थी तैस सेइं ड्ला कियोरो थियो, ते होरां भी बड़ां बुरां कम्मां कियोरां थियां। ");
INSERT INTO bhd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","हेरोदेस एन सेब्भन करां जादे बुरू कम कियूं कि यूहन्ना कैद केरतां छ़ड्डो। ");
INSERT INTO bhd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ज़ैखन सब लोक बपतिस्मो नेने लोरे थिये त यीशुए भी बपतिस्मो नीयो, ते ज़ैखन तै प्रार्थना लोरो थियो केरने, त एरू भोवं कि स्वर्ग खुल्ली जेवं। ");
INSERT INTO bhd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ते पवित्र आत्मा कबूतरेरी शकली मां यीशु पुड़ उत्रो ते अम्बरे मरां ई आवाज़ अई, “तू मेरू ट्लारू मट्ठू आस, अवं तीं पुड़ बड़ो खुश आईं।” ");
INSERT INTO bhd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ज़ैखन यीशुए अपने सेवारू कम शुरू कियूं त तैसेरी उमर 30 साल थी (ज़ेन्च़रे समझ़ू गातू थियूं) एन यूसुफेरू मट्ठूए, ते तैन एलेरू ");
INSERT INTO bhd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","एली मत्तातेरू ते तैन लेवेरू ते तैन मलकेरो ते तैन यन्नेएरो ते तैन यूसुफेरू मट्ठू थियूं, ");
INSERT INTO bhd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ते तैन मत्तित्याहेरू ते तैन आमोसेरो ते तैन नहूमेरू ते तैन असल्याहेरू ते तैन नग्‍गईएरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ते तैन मत्तातेरो ते तै मत्तित्याहेरू ते तैन शिमीएरू ते तैन योसेखेरू ते तैन योदाहेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ते तैन यूहन्नारू ते तैन रेसारू ते तै जरुब्बाबेलेरू ते तैन शालतियेलेरू ते तैन नेरेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ते तैन मलकीएरू ते तैन अद्दीयेरू ते तैन कोसामेरू ते तैन एल्‍मदामेरू ते तैन एरेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ते तैन येशूएरू ते तैन एलीएजेरेरू ते तैन योरीमेरू ते तैन मत्तातेरू ते तैन लेवेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ते तैन शमौनेरू ते तैन यहूदेरू ते तैन यूसुफेरो ते तैन योननेरू ते तैन एलयाकीमेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ते तैन मलेआहेरू ते तैन मिन्नाहेरो ते तैन मत्ततेरो ते तैन नातानेरो ते तैन दाऊदेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ते तैन यिशैएरो ते तैन ओबेदेरो ते तैन बोआजेरो ते तैन सलमोनेरो ते तैन नहशोनेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ते तैन अम्मीनादाबेरू ते तैन अरनेरू ते तै हेस्रोनेरू ते तैन पेरेसेरू ते तैन यहूदेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ते तैन याकूबेरू ते तैन इसहाकेरो ते तैन अब्राहमेरू ते तैन तेरहेरो ते तैन नाहोरेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ते तैन सरूगेरो ते तैन रऊएरो ते तैन पेलेगेरो ते तैन एबेरेरू ते तैन शिलहेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ते तैन केनानेरू ते तैन अरफक्षदेरो ते तैन शेमेरो ते तैन नूहेरो ते तैन लेमेकेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ते तैन मथूशिलहेरू ते तैन हनोकेरो ते तैन यिरिदेरू ते तैन महललेलेरू ते तैन केनानेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ते तैन एनोशेरू ते तैन शेतेरू ते तैन आदमेरो ते तैन परमेशरेरू मट्ठू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","फिरी यीशु पवित्र आत्मा सेइं भरपूर भोइतां यरदन दरियाए मरां वापस अव त 40 दिहाड़े पवित्र आत्मारे च़लाने सेइं सुनसान ठैरी जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","तैन 40 दिहाड़न मां शैतान तैस अज़मातो राव, तैन दिहैड़न मां तैनी किछ न खाव पीवं ते ज़ैखन तैना दिहाड़े पूरे भोए त तैस ढ्लुख लग्गी। ");
INSERT INTO bhd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","शैताने तैस जो ज़ोवं, “अगर तू परमेशरेरू मट्ठू आस त इन घोड़न जो ज़ो कि एना रोट्टी बन्न।” ");
INSERT INTO bhd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","यीशु तैस जुवाब दित्तो, “पवित्रशास्त्रे मां लिखोरूए, ‘मैन्हु सिर्फ रोट्टेइं सेइं ज़ींतो न राए।’ ” ");
INSERT INTO bhd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","फिरी शैताने यीशु एक्की उच्चे पहाड़े पुड़ घिन्तां जेव ते तैट्ठां एक्की पले मां तैस तैड़ी दुनियारां सारां राज़्ज़ां हिरां। ");
INSERT INTO bhd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ते तैनी यीशु सेइं ज़ोवं, “एन सब किछ मेरे अधिकारे मां आए, ते एसेरी सारी धन दौलत अवं तीं देलो एन मेरे स्पुर्दे। अवं ज़ैस चाताईं तैस देइ सकताईं। ");
INSERT INTO bhd_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","बस अगर तू मीं कां मथ्थो टेकस त एन सब किछ तेरू भोलू।” ");
INSERT INTO bhd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","यीशुए तैस जुवाब दित्तो, “पवित्रशास्त्र मां लिखोरूए, ‘तू सिर्फ अपने प्रभु परमेशरे कां मथ्थो टेकतां ते सिर्फ तैसेरी भक्ति केरां।’ ” ");
INSERT INTO bhd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ते तैनी यीशु यरूशलेम नगरेरे मन्दरेरी उच्ची छ़म्पी पुड़ नेइतां खड़ो कियो ते तैस सेइं ज़ोवं, “अगर तू परमेशरेरू मट्ठू आस त अपनो आप इट्ठां उन्ढो बछ़ोड़। ");
INSERT INTO bhd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","किजोकि पवित्रशास्त्रे मां लिखोरूए, ‘तै तेरे लेइ अपने स्वर्गदूतन ज़ोलो ते तैना तेरी हफाज़त केरेले।’ ");
INSERT INTO bhd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ते ‘तैना तीं अपने हथ्थन पुड़ छ़ूले ताके एरू न भोए कि तेरे पावन घोड़न सेइं ठोकर लग्गे।’ ” ");
INSERT INTO bhd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","यीशु तैस जुवाब दित्तो, “पवित्रशास्त्रे मां इन भी लिखोरूए तू अपने प्रभु परमेशरेरी अज़मैइश न केरां।” ");
INSERT INTO bhd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ज़ैखन शैताने तैसेरी बड़े तरीकेईं अज़मैइश की, त किछ च़िरेरां बाद तैस करां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","फिरी यीशु पवित्र आत्मारी शेक्ति सेइं भरपूर भोइतां गलील इलाके मां वापस अव, ते सारे इलाके मां तैसेरी मुशूरी भोइजेइ। ");
INSERT INTO bhd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","यीशु तैन केरे प्रार्थना घरन मां शिक्षा देतो राव, ते सब लोक तैसेरी तारीफ़ केरते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","फिरी तै नासरत नगर मां वापस अव ज़ैड़ी तै पलोरो थियो। अपने रीतरे मुताबिक आरामेरे दिहाड़े तै प्रार्थना घरे मां जेव ते वचन पढ़नेरे लेइ खड़ो भोव। ");
INSERT INTO bhd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ते तैस यशायाह नेबेरी किताब दित्ती ते तैनी खोलतां तैन वचन कढू ज़ैड़ी लिखेरू थियूं, कि, ");
INSERT INTO bhd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“प्रभुएरी आत्मा मीं पुड़े, एल्हेरेलेइ कि तैनी गरीबन खुशखबरी शुनानेरे लेइ मेरू अभिषेक कियोरूए, तैनी अवं भेज़ोरोईं कि कैदन हथरां छ़ेड्डी (ज़ैना शैतानेरे कब्ज़े मां आन) ते कांना केरि एछ़्छ़न ठीक भोनेरी खबर शुनेई, ते ज़ैन पुड़ ज़ुलम भोते तैन लोकन आज़ाद केरि। ");
INSERT INTO bhd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ते तैस वक्तेरू एलान केरि ज़ेइस परमेशर लोकन पुड़ दया केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","फिरी तैनी तै किताब बंद केरतां सेवके कां वापस देइतां बिश्शी जेव। ज़ेत्रे प्रार्थना घरे मां थिये सब तैसेरां तकते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ते तै तैन सेइं ज़ोने लगो, “अज़ पवित्रशास्त्रेरू तैन वचन तुश्शे सामने पूरू भोवं।” ");
INSERT INTO bhd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ते सब तैसेरी तारीफ़ केरने लगे, ते तैसेरी गल्लन पुड़ बड़ो अनुग्रह थियो, ज़ैना गल्लां तैसेरे ऐशेरां निसती थी, ते लोक हैरान भोइतां ज़ोने लगे, “कुन एन यूसुफेरू मट्ठू नईं?” ");
INSERT INTO bhd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","यीशु तैन सेइं ज़ोने लगो, “ए कहावत तुस मीं पुड़ ज़ुरुर ज़ोले, ‘कि हे बेईद जी अपनो आप त ठीक केर, ज़ैन किछ असेईं कफरनहूम नगर मां केरतू शुनेरूए, तैन इड़ी अपने नगरे मां भी केर।’ ” ");
INSERT INTO bhd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ते तैनी इन भी ज़ोवं, “अवं तुसन सेइं सच़ ज़ोताईं, कि कोई नबी अपने मुलखे मां कबूल न कियो गाए। ");
INSERT INTO bhd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","अवं तुसन सेइं सच़ ज़ोताईं कि एलिय्याह नेबेरे वक्ते मां ज़ैखन साड़े ट्लाई साल अम्बर बंद भोवं (यानी झ़ड़ी न भोइ) ते इड़ी तगर कि सैरी मुलखे मां बड़ो काल पेई जेव ते तैस वक्ते बेड़ि विधवा कुआन्शां इस्राएले मुलखे मां थी। ");
INSERT INTO bhd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","पन एलिय्याह नबी, तैन मरां केन्ची कां नईं पन सैदा नगरेरे नेड़े सारफत नगर मां एक्की विधवा कां भेज़ो, ज़ै यहूदी न थी। ");
INSERT INTO bhd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ते एलीशा नेबेरे ज़माने मां इस्राएलेरे मुलखे मां बड़े कोढ़ी थिये पन तैन मरां कोई भी कोढ़े करां साफ न थियो भोरो, पन सिर्फ अक सीरियारो रानेबालो नामान कोढ़े करां साफ भोरो थियो, ज़ै गैर कौमी मरां थियो।” ");
INSERT INTO bhd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ज़ेत्रे लोक प्रार्थना घरे मां थिये एना गल्लां शुन्तां सरकी सेइं लाल-लाल भोइ जे। ");
INSERT INTO bhd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ते खड़े उट्ठतां तैस नगर करां बेइर निस्से ते तै तैस पहाड़ेरी च़ौटी पुड़ घिन्तां जे ज़ैस पुड़ तैन केरू नगर आबाद थियूं, ताके तैस तैट्ठां उन्ढे बछ़ोड़तां मारन। ");
INSERT INTO bhd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","पन यीशु तैन मरां निस्तां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","फिरी तै गलील इलाकेरे कफरनहूम नगरे मांजो जेव। ते आरामेरे दिहाड़े तैन शिक्षा देने लग्गोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ते लोक तैसेरी शिक्षा शुन्तां हैरान रहते थिये किजोकि तैसेरी शिक्षा बड़े अधिकारे सेइं थी। ");
INSERT INTO bhd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","प्रार्थना घरे मां अक मैन्हु थियो, ज़ैस पुड़ भूतेरो सायो थियो। तै बड़े ज़ोरे सेइं चिन्डां मारने लगो। ");
INSERT INTO bhd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“हे नासरत नगरेरे यीशु! असन तीं सेइं कुन कम? कुन तू असन नाश केरनेरे लेइ ओरोस? अवं ज़ानताईं कि तू कौन आस, तू परमेशरेरू पवित्र मट्ठू आस!” ");
INSERT INTO bhd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","यीशुए तैस झ़िड़क देइतां ज़ोवं, “च़ुप रा, एस मैन्हु मरां निस्सी गा!” तैखन भूते तै मैन्हु ज़मीनी पुड़ शैरी दित्तो, ते तैस मरां निस्सी जेव। ");
INSERT INTO bhd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","एन हेरतां सारे लोक बड़े हैरान भोए ते एप्पू मांमेइं ज़ोने लगे, “ए कुन गल आए! तै अधिकारे ते शेक्ति सेइं भूतन हुक्म देते ते तैना तैस मरां निस्सी गातन।” ");
INSERT INTO bhd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ते सारे मुलखेरे मां च़ेव्रे पासन तैसेरी खबर फैली जेई। ");
INSERT INTO bhd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","फिरी तै प्रार्थना घरे मरां उट्ठतां शमौनेरे घरे जेव ते शमौनेरी शिखी बड़ो भुखार थियो, ते लोकेईं तैसारे बारे मां यीशु सेइं ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","तै खड़ो भोइतां तैसारे पासे फिरो ते बिमारी झ़िड़की, ते तैसारो सारो भुखार उतरी जेव ते तै खड़ी भोइ, ते तैन केरि सेवा केरने लगी। ");
INSERT INTO bhd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ज़ैखन दिहाड़ी लाई डुबने त लोकेईं तैना सब लोक ज़ैन मां किसमां-किसमां केरि बिमैरी थी तैस कां आने, ते यीशुए तैन पुड़ हथ रेखतां तैना सब बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","भूतां भी चिन्डां मारतां थियां, ते ज़ोतां थियां, “तू परमेशरेरू मट्ठूस!” ते बड़े लोकन मरां भूतां केरो सैयो निस्सी जेव, ते तै तैन झ़िड़कतो थियो, ते तैन गल भी न थियो देतो केरने, किजोकि तैना भूतां ज़ानतां थियां कि ए मसीह आए। ");
INSERT INTO bhd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ज़ैखन झ़ेझ़ भोइ त यीशु उट्ठतां बेइर एक्की सुनसान ठैरी मां जेव, ते पतोरां सारे लोक तैस तोपते-तोपते तैस कां पुज़े ते रोकने लगे कि तू असन करां न गा। ");
INSERT INTO bhd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","पन यीशुए तैन सेइं ज़ोवं, “मीं होरि नगरन मां भी परमेशरेरे राज़्ज़ेरी खुशखबरी शुनानी ज़रूरीए किजोकि अवं एल्हेरेलेइ भेज़ोरोईं।” ");
INSERT INTO bhd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ते तै यहूदिया इलाकेरे प्रार्थना घरन मां प्रचार केरतो राव। ");
INSERT INTO bhd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","एक्की दिहाड़े यीशु गन्नेसरतेरे समुन्देरे बन्ने पुड़ खेड़ोरो थियो, ते बड़े लोक तैस कां करां परमेशरेरू वचन शुन्नेरे लेइ तै उन्ढे बिछ़ड़ी गाते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","तैनी दूई किश्ती बन्ने लेगोरी लेई, ते मेछ़ली ट्लानेबाले किश्ती ड्लेखी छ़ेडतां अपना ज़ालां धोने लग्गोरो थिये। ");
INSERT INTO bhd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","यीशु एक्की किश्ती मां च़ढ़ो ते किश्तरे मालिके शमौने सेइं ज़ोने लगो, तुस किश्ती इट्ठां बन्ने पुड़ेरां नेइतां थोड़ी दूर लाथ। फिरी यीशु किश्ती मां बिश्तां तैन लोकन उपदेश देने लगो। ");
INSERT INTO bhd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ज़ैखन तैनी लोकन शिक्षा दित्ती त तै शमौने सेइं ज़ोने लगो, “तुस किश्ती डुग्घी ठैरी च़लाथ ते मेछ़ली ट्लानेरे लेइ ज़ाल छ़डा।” ");
INSERT INTO bhd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","शमौने जुवाब दित्तो, “हे गुरू, असेईं सैरी राती तरले कियोरेन ते अक मछ़ली भी नईं ट्लेइयोरी, पन असां तेरे ज़ोने सेइं ज़ाल छ़डतम।” ");
INSERT INTO bhd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","आखर्कार पतरस ते तैसेरे सैथेईं ज़ालां छैडी दित्तां ते एत्री मेछ़ली लेगि, कि ज़ालां छ़िन्दोइतां मेछ़ली बेइरोवं निस्सने लेगि। ");
INSERT INTO bhd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","तैखन तैनेईं अपने सैथन जो ज़ैना होरि किश्ती पुड़ थिए, इशारो कियो कि एज्जा इश्शी मद्दत केरा, ते तैना भी आए ते किश्ती मेछ़लेईं सेइं एत्री भेरोई जेई कि किश्ती डुबने लगी। ");
INSERT INTO bhd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","शमौन पतरस एन हेरतां यीशुएरे पावन पुड़ पेइतां ज़ोने लगे, “हे प्रभु, अवं पापी मैन्हु आईं तू मीं करां दूर भो!” ");
INSERT INTO bhd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","गल ए थी कि तै त तैसेरे साथी एत्री मेछ़ली लेइतां हैरान भोइ जोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","तेरहो हाल जेब्देरे मट्ठां केरो यानी याकूब त कने यूहन्नारो भी थियो, ज़ैना शमौने सेइं साथी थिये, यीशुए शमौने सेइं ज़ोवं, “डर नन्ना अज़्ज़ेरे बाद तू मेछ़ली ट्लाने बालो नईं, बल्के मैनन् अकोट्ठे केरतां मेरे चेले बनानेबालो भोलो।” ");
INSERT INTO bhd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","तैनेईं किश्ती ड्लेखी एन्तां लेई, ते अपनू सब किछ छ़ेडतां यीशु पत्ती च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ज़ैखन यीशु एक्की नगर मां थियो, ते एरू भोवं कि तैड़ी अक मैन्हु थियो, ज़ेसेरे सैरी जानी कोढ़ थियूं, तैनी यीशु लाव, ते तै ज़ैन्धु केरे भारे बिश्तां तैस कां मिन्नत केरतां ज़ोने लगो, “हे प्रभु तू चास त मेरू कोढ़ बज़्झ़ेई सकतस।” ");
INSERT INTO bhd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","यीशुए अपनो हथ तैस पुड़ रख्खो ते ज़ोवं, “अवं चाताईं, तू बज़्झ़ोस।” ते तैखने तैसेरू कोढ़ साफ भोइ जेवं। ");
INSERT INTO bhd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","तैखन यीशुए तैस मैन्हु हुक्म दित्तो, “हेर, एसेरे बारे मां केन्ची सेइं किछ न ज़ोइयां। बल्के अपनो आपे याजके हिरा। तैल्ला पत्ती, तू अपने बेज़्झ़ोनेरे वजाई सेइं च़ढ़तल च़ाढ़, ज़ेसेरे बारे मां मूसा नेबे कानूने मां हुक्म दित्तोरोए। ताके लोकन पतो च़ले कि तू बेज्झ़ोरोस।” ");
INSERT INTO bhd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","पन यीशुएरे बारे मां सेब्भन पतो लगो ते लोक दूरेरां देंते एजने लगे ताके यीशुएरी गल्लां शुन्न कने अपनि बिमैरन करां बेझ़ोन। ");
INSERT INTO bhd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","पन यीशु जादे केरतां सुनसान ठैरी च़लो गातो थियो, ते प्रार्थना केरतो रातो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","एक्की दिहैड़ी एरू भोवं कि यीशु शिक्षा देने लग्गोरो थियो, ते तैखन किछ फरीसी ते शास्त्री लोक ज़ोते थिये, तैना गलील इलाके ते यहूदियारे सैरी इलाकन मरां यरूशलेम नगरे मां ओरे थिये; ते परमेशरेरी शक्ति यीशु सेइं साथी थी, ते बिमार बेज़्झ़ोइतां गाते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","किछ मैनेईं अक अधरंगी मैन्हु खट्टी पुड़ छ़ुइतां आनोरोए थियो, ते तैना कोशिश लगे केरने कि एस अन्तर नेइतां यीशु कां पुज़ाम। ");
INSERT INTO bhd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","पन अन्तर एत्री तंगी थी कि तैना अन्तर न गेइ सके फिरी तैनेईं तैस घरेरी छत पुट्टी ज़ैस घरे मां यीशु थियो, ते खट्टां सने तै अधरंगी मैन्हु अन्तर यीशुएरे तुतरे अगर ओसालो। ");
INSERT INTO bhd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","यीशु तैन केरो विश्वास हेरतां ज़ोवं, “हे दोस्त तेरे पाप माफ़ भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","शास्त्री ते फरीसी लोक सोचने लगे, “ए कौन मैन्हु आए, ज़ै परमेशरेरी तुहीन केरते, परमेशरेरे अलावा कौन पाप माफ़ केरि सकते?” ");
INSERT INTO bhd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","यीशुए तैन केरि गल्लां बुझ़ी ते तैन जुवाब दित्तो, “तुस अपने-अपने मने मां एन्च़रां किजो सोचने लग्गोरेथ? ");
INSERT INTO bhd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","कुन ज़ोनू सुखतुए, ‘तेरे पाप माफ़ भोए,’ या एन ज़ोनू ‘उठ, ते च़ल फिर?’ ");
INSERT INTO bhd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","पन तुसन पतो लग्गे, मैनेरे मट्ठे ज़मीनी पुड़ पाप माफ़ केरनेरो अधिकारे,” फिरी यीशुए तैस बिमारे जो ज़ोवं, “अपनि खट सल्ल ते घरजो च़लो गा।” ");
INSERT INTO bhd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","तै अधरंगी बिमार मैन्हु सेब्भी केरे सामने ते खड़े उठो ते ज़ैस खट्टी पुड़ तै झ़ुलतो थियो, अपने दोग्गे पुड़ छ़ुइतां परमेशरेरी बड़याई केरतो-केरतो घरजो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","तैना सारे लोक हैरान राए ते परमेशरेरी तारीफ़ केरने लगे ते कने ज़ोने लगे, “ए त असेईं अज़ नव्वीं गल लाई।” ");
INSERT INTO bhd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","एना गल्लां बीतनेरां बाद यीशु तैट्ठां निस्सो, ते एक्की चुंगी घिन्ने बाले कां च़ले जेव, तैसेरू नवं लेवी थियूं। ते तै चुंगी नेनेबाले दफ़तरे मां बिश्शोरो लाव, ते यीशुए तैस जो ज़ोवं, “तू मीं पत्ती च़ल ते मेरो चेलो बन।” ");
INSERT INTO bhd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","तै तैखने यीशु पत्ती च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ते फिरी लेवी यीशुएरे लेइ अपने घरे अक बड़ी धाम दित्ती। ते तैड़ी चुंगी नेनेबाले ते होरे भी बड़े लोक थिये ज़ैना तैस सेइं साथी रोट्टी खाने बिश्शे। ");
INSERT INTO bhd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","फरीसी लोक ते शास्त्री यीशुएरे चेलन सेइं ज़ोने लग्गे, “तुस चुंगी नेनेबालन ते पापी लोकन सेइं साथी किजो खातथ पीतथ?” ");
INSERT INTO bhd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","यीशुए तैन सेइं ज़ोवं, “बिमारन डाक्टरेरी ज़रूरत भोचे, न कि सझ़र लोकन। ");
INSERT INTO bhd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","अवं धर्मी लोकन नईं, पन पापी लोकन कुजाने ओरोईं कि, तैना अपने पापन करां मन फिरान।” ");
INSERT INTO bhd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","तैना लोक यीशु सेइं ज़ोने लगे, “यूहन्नारे चेले त बरत रखतन ते प्रार्थना भी केरतन ते एन्च़रे फरीसी लोक भी केरतन, पन तेरे चेले त खातन पीतन?” ");
INSERT INTO bhd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","यीशुए तैनन् जुवाब दित्तो, “ड्लाएरे दिहाड़े, कुन लाड़ो साथी भोंते सांते जन बरत रेखी सकतथ? ");
INSERT INTO bhd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","पन तैना दिहाड़े एज्जले, ज़ैखन लाड़ो तैन केरां अलग कियो गालो (यानी मारो गालो)। तैन दिहैड़न मां तैना (अपने दुख्खेरे वजाई सेइं) बरत रख्खेले।” ");
INSERT INTO bhd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","फिरी यीशु तैन अक होरि मसाल दित्ती, “पुराने लिगड़े पुड़ नंव्वे लिगड़ेरी टलोई कोई न लाए, नता तै टलोई तैस मरां होरू भी छ़िंदेली, ते कने पुराने सेइं तै मिले भी नन्ना। ");
INSERT INTO bhd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","नंव्वो दाछ़ारो रस पुरैनी मसकी मां कोई न छ़ड्डे, नन्ना त नंव्वे दाछ़ारो रस सेइं मसक भी फैट्टी गाचे, ते दाछ़ारो रस भी डुल्ली गाते, ते तै मसक भी बरबाद भोचे। ");
INSERT INTO bhd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","किजोकि नंव्वो दाछ़ारो रस नव्वीं मसकन मां भरोरो लोड़ते। ");
INSERT INTO bhd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","कोई मैन्हु पुरानो दाछ़ारो रस पीतां नव्वों न पीनो चाए, किजोकि तै ज़ोते कि पुरानो दाछ़ारो रस जादे रोड़ोए।” ");
INSERT INTO bhd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","एक्की फेरे यीशु त तैसेरे चेले आरामेरे दिहाड़े ऊडारन मांमेइं एक्की बत्तां च़लोरे थिये, ते तैसेरे चेले शिल्लां हथेइं सेइं प्रोड़तां खाने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","एन लेइतां किछ फरीसी लोकेईं तैन सेइं ज़ोवं, “तुस एन कम किजो लोरेथ केरने, ज़ैन आरामेरे दिहाड़े केरनू जेइज़ नईं?” ");
INSERT INTO bhd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","यीशुए तैन जुवाब दित्तो, “कुन तुसेईं पवित्रशास्त्रे मां कधे नईं पढ़ेरू कि ज़ेइस इश्शो पूर्वज दाऊद राज़ो त तैसेरे साथी ढ्लुखोरे थिये त तैनेईं कुन कियेरू थियूं? ");
INSERT INTO bhd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","तैनेईं केन्च़रे परमेशरेरे घरे मां गेइतां च़ैढ़ोरी रोट्टी खोरी थी, ते अपने सैथन भी दित्तोरी थी। तैना रोट्टी खैनी सिर्फ याजकां केरे लेइ जेइज़ थी।” ");
INSERT INTO bhd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","फिरी तैने तैन सेइं ज़ोवं, “मैनेरू मट्ठू, यानी अवं आरामेरे दिहाड़ेरो भी प्रभु आईं।” ");
INSERT INTO bhd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","एक्की बार यीशु प्रार्थना घरे मां गेइतां उपदेश शुनेई राहोरो थियो, ते तेइस भी आरामेरी दिहाड़ी थी तैड़ी अक मैन्हु थियो, ज़ेसेरो देइनो हथ शुक्कोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","शास्त्री त फरीसी लोक यीशुएरी ताके मां थिये कि अगर यीशु आरामेरे दिहाड़े केन्ची बझ़ालो त असन इलज़ाम लानेरो मौको मैलनोए। ");
INSERT INTO bhd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","पन यीशु तैन केरे बारे मां सेमझ़ी जेव, यीशुए तैस शुक्कोरे हथ्थेबाले मैन्हु सेइं ज़ोवं, “मझ़ाटे खड़े भो।” तै खड़ो भोव। ");
INSERT INTO bhd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","तैखन यीशु तैन सेइं ज़ोवं, “अवं तुसन पुछ़तां कि आरामेरे दिहाड़े भलाई केरनि रोड़ीए या बुराई केरनि रोड़ीए, मैनेरी जान बच़ानी या मारनी?” ");
INSERT INTO bhd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ते तैनी च़ेव्रे पासना तैन केरां तक्कू ते तैस मैन्हु जो ज़ोवं, “अपनो हथ हिरा।” तैनी मैने अपनो हथ अग्रोवं कियो। त अकदम तैसेरो हथ बेज्झ़ोव। ");
INSERT INTO bhd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","पन याजकन त फरीसन बड़ी सरक अई तैना एप्पू मांमेइं बेंस केरने लग्गे, कि असां यीशुए सेइं कुन केरम? ");
INSERT INTO bhd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","तेइस एरू भोवं कि यीशु प्रार्थना केरनेरे लेइ एक्की पहाड़े पुड़ च़ढ़ो, ते सैरी राती परमेशरे कां प्रार्थना केरतो राव। ");
INSERT INTO bhd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ज़ैखन ट्लेकड़ोने लगू त तैनी अपने चेले एप्पू कां कुजाए ते तैन मरां 12 प्रेरित च़ुने। ");
INSERT INTO bhd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","अक शमौन ज़ैस जो पतरस भी ज़ोते थिये तैसेरो ढ्ला अन्द्रियास, याकूब, यूहन्ना, फिलिप्पुस, बरतुल्मै, ");
INSERT INTO bhd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मत्ती, थोमा, हलफईरू मट्ठू याकूब, ते शमौन ज़ैस जो जेलोतेस ज़ोतन। ");
INSERT INTO bhd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ते याकूबेरू मट्ठू यहूदा ते यहूदा इस्करियोती ज़ै तैसेरो ट्लुवांने बालो बनो। ");
INSERT INTO bhd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","तैखन यीशु तैन सेइं साथी चौरस ठैरी मां खड़ो भोव, ते तैसेरे चेले भी तैड़ी अकोट्ठे भोए ते सारे यहूदिया ते यरूशलेम नगरन त कने सूर ते सैदारे आसेपासेरे लोक समुन्दरेरे बन्नेरे बड़े लोक ज़ैना तैड़ी थिये। ");
INSERT INTO bhd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","एन लोक यीशु करां ज्ञान शुन्ने ते अपनि-अपनि बिमैरी तैस कां बझ़ांने ओरे थिये, ते ज़ैन लोकन पुड़ भूतां केरे सैये सेइं दुखे मां थिये तैना भी बेज़्झ़ोइ जे। ");
INSERT INTO bhd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","सब लोक तैस सेइं हथ लांनेरी कोशिश केरते थिये किजोकि तैस मां शक्ति थी ज़ैस सेइं तैना बेज़्झ़ोते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","तैखन यीशु अपने चेलां केरे तकने लगो ते ज़ोने लगो, “परमेशर तुसन बरकत देलो ज़ैना नमरथ, किजोकि स्वर्गेरू राज़ तुश्शू आए। ");
INSERT INTO bhd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","परमेशर तुसन बरकत देलो ज़ैना ढ्लुखोरेथ, किजोकि तुस रज़नेथ, परमेशर तुसन बरकत देलो ज़ैना अज़ लेरां देतथ, किजोकि तुसेईं हसनुए।” ");
INSERT INTO bhd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“परमेशर तुसन बरकत देलो, ज़ैखन मैनेरे मट्ठे, यानी मेरे चेलो भोनेरे वाजाई सेइं लोक तुश्शी तुहीन केरन, ते तुसन भाईच़ारे करां कनारे छ़डेले, ते तुसन बेइज़त केरेले, ते तुश्शू नवं केट्टी छ़डेले।” ");
INSERT INTO bhd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“तैस दिहाड़े खुशी भोइतां उछ़ड़थ, किजोकि हेरा तुश्शे लेइ स्वर्गे मां बड़ू इनामे। तैन केरे दादे-पड़दादे नेबन सेइं भी एरो ज़ेरो बर्ताव केरते थिये।” ");
INSERT INTO bhd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“पन अफ़सोस! तुसन पुड़ ज़ैना दौलतमन्दथ, किजोकि तुसन सब किछ मैलेरूए। ");
INSERT INTO bhd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","अफ़सोस! तुसन पुड़, ज़ैन तुस चाते थिये, तुसन तैन मैल्लू, किजोकि तुस नियन्ने भोले, अफ़सोस! तुसन पुड़ ज़ैना अज़ हसतथ किजोकि तुस शोग केरेले ते लेरां देले। ");
INSERT INTO bhd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","पन अफ़सोस! तुसन पुड़ ज़ैखन लोक तुसन जो भलू ज़ोन, किजोकि तुश्शे दादे-पड़दादेईं भी झूठे नेबन सेइं एरो बर्ताव कियोरो थियो।” ");
INSERT INTO bhd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“अवं तुसन शुन्नेबालन सेइं ज़ोताईं कि अपने दुश्मन सेइं प्यार केरा। ज़ैना तुसन सेइं बैर रखतन तैन केरू भलू केरा। ");
INSERT INTO bhd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ज़ैना तुसन जो बुरू ज़ोतन तुस तैन केरे लेइ बरकत मग्गा, ज़ैन तुसन बेइज़त केरन तुस तैन केरे लेइ प्रार्थना केरा। ");
INSERT INTO bhd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","अगर कोई तुश्शे एक्की खैखोड़ी पुड़ थप्पड़ बाहे त होरो पासो भी तैसेरे पासे रखा, ते अगर कोई तुश्शू कोट नेते त कमीज़ भी तैस देथ। ");
INSERT INTO bhd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ज़ै कोई तीं करां किछ मग्गे त तैस देथ अगर कोई तेरो सबाब नेते ते तैस करां वापस न मग्गा। ");
INSERT INTO bhd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ते ज़ेन्च़रे तुस चातथ कि लोक तुसन सेइं केरन तेन्च़रे तुस भी तैन सेइं तेरहु केरा। ");
INSERT INTO bhd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","अगर तुस तैन्ने सेइं प्यार केरथ ज़ैना तुसन सेइं प्यार केरतन त तुश्शू कुन एवसाने? किजोकि पापी लोक भी अपने प्यार केरनेबालन सेइं प्यार केरतन। ");
INSERT INTO bhd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","अगर तुस तैन केरू भलू केरतथ ज़ैना तुश्शू भलू केरतन त तुश्शू कुन एवसाने? किजोकि पापी लोक भी अपने प्यार केरनेबालन सेइं प्यार केरतन। ");
INSERT INTO bhd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","अगर तुस तैन्ने ओधार देतथ ज़ैन करां तुसन वापस भी मैलनेरी उमीदे, त परमेशर तुश्शी बड़याई किजो केरे? किजोकि बुरे लोक भी अपने प्यार केरनेबालन पेंइसे देतन ताके तैन करां वापस मैलन। ");
INSERT INTO bhd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","पन तुस अपने दुश्मन सेइं प्यार केरा ते तैन केरू भलू केरा, ओधार देइयथ पन तैन करां वापस मैलनेरी उमीद न रेखथ, एल्हेरो स्वर्गे मां तुश्शे लेइ अक बड़ो फले, किजोकि तुस परमप्रधान परमेशरेरे बच्चे भोले, किजोकि तै परमेशर न मन्ने बालन पुड़ ते ज़ालमन पुड़ भी दया केरते। ");
INSERT INTO bhd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ज़ेरो दया दिल तुश्शो बाजी तेरहे दया दिल तुस भी भोथ।” ");
INSERT INTO bhd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“दोष न लाथ, तुसन पुड़ भी दोष न लव गालो, निन्दा न केरा, तुश्शी भी निन्दा न की गाली, तुस होरन माफ़ केरेले त तुसन भी माफ़ कियूं गालू। ");
INSERT INTO bhd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","तुस होरि किछ देले त तुसन भी किछ दित्तू गालू तुश्शू बरकतरू भांड ज़ेन्च़रे अन्नेरी हाटी हिलेइतां देतां तैन भी तेन्च़रे ज़ैस हैटी सेइं तुस होरि केरे लेइ मिनतथ तैस्से सेइं तुश्शे लेइ भी मिनेले।” ");
INSERT INTO bhd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","यीशुए तैन अक मिसाल शुनाई, “कुन कानो होरि काने बत हेरेई सकते? तैना त दुइये गढे मां बिछ़ड़ेले? ");
INSERT INTO bhd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","चेलो अपने गुरू करां बड्डो न भोए पन हर एक्की गल्ली मां ज़ैखन सब शिखेलो त अपने गुरेरो ज़ेरो भोलो। ");
INSERT INTO bhd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","तू अपने ढ्लाएरी एछ़्छ़ी मां कूड़ो किजो तकतस, पन तेरी एछ़्छ़ी मां त नग आए, ते तैसेरो तू खियाल भी न केरस? ");
INSERT INTO bhd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","तू अपने ढ्लाए केन्च़रे ज़ोई सकतस कि, ‘तेरी एछ़्छ़ी मरां कूड़ो केढी?’ हे पाखंडी पेइले अपनि एछ़्छ़ी मरां नग कढ फिरी अपने ढ्लाएरी एछ़्छ़ी मरां कूड़ो केढी सकतस।” ");
INSERT INTO bhd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“किजोकि केन्ची भी रोड़े बुटे बुरो फल न लग्गे ते न केन्ची बुरे बुटे रोड़ो फल लग्गे। ");
INSERT INTO bhd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","हर बुट अपने फले सेइं पिशैनोते। किजोकि न झ़लन सेइं फैगू लगन ते न झ़ल्लन सेइं दाछ़ लगे। ");
INSERT INTO bhd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","रोड़ो मैन्हु अपने दिलेरे रोड़े खज़ाने मरां रोड़ी चीज़ां कढ़ते ते बुरो मैन्हु अपने दिलेरे बुरे खज़ाने मरां बुरी चीज़ां कढ़ते किजोकि ज़ैन दिले मां भरेरू भोते तैन्ने ज़बानी पुड़ एइते।” ");
INSERT INTO bhd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ज़ैखन तुस मेरे ज़ोने पुड़ अमल न केरथ त मींजो, ‘हे प्रभु, हे प्रभु,’ किजो ज़ोतथ? ");
INSERT INTO bhd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ज़ै मीं कां एइते ते मेरी गल्लां शुन्तां तैन पुड़ अमल केरते त अवं तुसन सेइं ज़ोताईं कि तै केसेरो ज़ेरो भोलो? ");
INSERT INTO bhd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","तै तैस मैनेरो ज़ेरोए ज़ैनी अपनू घर डुग्घी खाइ केढतां पेक्की ठैरी घर बनावं ज़ैखन हड़ाई आई त तैस घरे किछ न भोवं, किजोकि तैसेरी मुनीयाद पेक्की ठैरी थी। ");
INSERT INTO bhd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","पन ज़ै मेरी गल्लां शुन्तां तैन पुड़ अमल न केरे त तै तैस मैनेरो ज़ेरोए, ज़ैनी अपनू घर रेती पुड़ बनाव ते ज़ैखन हड़ाई अई त तैन घर डुल्ली जेवं ते तब्बा भोइ जेवं।” ");
INSERT INTO bhd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ज़ैखन तैनी लोकन एपनी सब गल्लां शुनेई छ़ैडी, त तै कफरनहूम नगर मां अव। ");
INSERT INTO bhd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","तैड़ी केन्ची सूबेदारेरो अक ट्लारो सेवक बिमार थियो ते मरने बालो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","तैनी यीशुएरी मुशूरी शुन्तां यहूदी केरे किछ बुज़ुर्ग तैस कां मिनत केरनेरे लेइ भेज़े, कि तै एइतां मेरो सेवक बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","तैना यीशु कां आए ते तैस कां मिनत केरने लगे, “तै इस काबले, कि तू तैसेरेलेइ इन केरस। ");
INSERT INTO bhd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","किजोकि ते इश्शी कौमी सेइं बड़ी हमदरदी रखते, ते इश्शू प्रार्थना घर तैन्नी बनेवरुए।” ");
INSERT INTO bhd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","यीशु तैन सेइं साथी-साथी च़लो जेव, पन ज़ैखन तैस घरे नेड़े पुज़ो त सूबेदारे होरि दोस्तन सेइं समाद भेज़ो कि, “प्रभु तकलीफ न केर, किजोकि अवं एस काबल नईं कि तू मेरे घरे मां एज्जी सखत। ");
INSERT INTO bhd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","एस्से वजाई सेइं अवं भी अपनो आप तीं कां एजनेरे काबल न सेमझ़ी बल्के अपनि ज़बानी सेइं ज़ोस त मेरो नौकर बेज़्झ़ोइ सकते। ");
INSERT INTO bhd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","तै मैन्हु ज़ोने लगो कि अवं भी केन्चेरे अधिकारे मां कम केरताईं, ते सिपाही मेरे अधीन आन, ते ज़ैखन एक्की जो ज़ोतां कि ‘गा,’ त तै गाते, ते होरि जो ज़ोतां एई, त तै ‘एइते,’ ते अपने सेवके जो ज़ोताईं, ‘इन कम केर,’ त तै केरते।” ");
INSERT INTO bhd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","यीशु एन शुन्तां हैरान रेइ जेव, ते पत्रोवं लोकां केरे पासे लगो तकने ज़ैना तैस पत्पती ओरे थिये तैन जो ज़ोने लगो, “कि अवं तुसन सेइं सच़ ज़ोताईं कि मीं इस्राएल मुलखे मां इस गैर यहूदी मैनेरो ज़ेरो मैन्हु नईं लोवरो ज़ै मीं पुड़ एत्रो विश्वास केरे।” ");
INSERT INTO bhd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ते ज़ैना लोक यीशु कां भेज़ोरे थिये वापस ज़ैखन घरे आए त तै सेवक बेज़्झ़ोरो लव। ");
INSERT INTO bhd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","थोड़े च़िरेरां पत्ती एरू भोवं कि यीशु नाईन नव्वेंरे नगर मां च़लो जेव, ते तैसेरे चेले ते होरे भी बड़े लोक तैन सेइं साथी थिये। ");
INSERT INTO bhd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ज़ैखन तैना नगरेरे फाटके पुड़ नेड़े पुज़े, त हेरतन, कि अक मुड़दो बेइर जो च़लेवरोए, ते तैन अपनि अम्मारू अक्के मट्ठू थियूं, ते नगरेरे बड़े लोक तैस विधवा कुआन्शी सेइं साथी थिये। ");
INSERT INTO bhd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","एन लेइतां प्रभुए बड़ो तरस अव, ते तैस जो ज़ोवं, “लेरां न दे।” ");
INSERT INTO bhd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","फिरी यीशु नेड़े एइतां शिड़ी सेइं हथ लाव, ते छ़ूनेबाले रुके, ते यीशुए ज़ोवं, “ए जवान, अवं तीं सेइं ज़ोतां, खड़ो उठ!” ");
INSERT INTO bhd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","तैखन मुड़दो उठो, ते गल्लां लगो केरने, ते यीशुए तै तैसेरी अम्मा सोंफतां छ़डू। ");
INSERT INTO bhd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","इन हेरतां सब लोक डेरि जे, ते परमेशरेरी तारीफ़ केरने लगे, “अक महान नबी असन मां ओरोए, ते परमेशरे अपने लोकन पुड़ अपनि सिधी नज़र रखोरीए। ");
INSERT INTO bhd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","एस्से गल्लरी वजाई सेइं ए खबर यहूदियारे ते आसेपासेरे सेब्भी मुलखन मां फैली जेई।” ");
INSERT INTO bhd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ते यूहन्ना तैसेरे चेलेईं एन सैरी गल्लां केरि खबर दित्ती। ");
INSERT INTO bhd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","तैखन यूहन्ना एन शुन्तां दूई चेले कुजेइतां यीशु कां पुच्छ़ने भेज़े कि, “एजनेबालो तू आस, या असां होरि बलगम?” ");
INSERT INTO bhd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","तैनेईं यीशु कां एइतां पुच़्छ़ू, “असां यूहन्ना बपतिस्मो देनेबाले तीं कां पुच्छ़ने भेज़ोरेम, कि एजनेबालो तू आस, या असां होरि बलगम?” ");
INSERT INTO bhd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","तैखन यीशुए बड़े लोक बिमैरन ते तकलीफ, ते भूतन करां छुटाए, ते बड़े काने लोकन एछ़्छ़न लौ दित्ती। ");
INSERT INTO bhd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","यीशु तैन ज़ोवं, “ज़ैन किछ तुसेईं लाहेरूए ते शुनेरूए गेइतां यूहन्ना सेइं ज़ोथ, कि काने लातन, ते टोंटे च़लतन, ते कोढ़ी केरू कोढ़ साफ भोते, ते टोंऊने शुन्तन, ते मुड़दे ज़ींते भोतन, ते गरीबन खुशखबरी शुनाई गाचे। ");
INSERT INTO bhd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","परमेशर तैस बरकत देते, ज़ै मीं पुड़ शक न केरे।” ");
INSERT INTO bhd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ज़ैखन यूहन्नारे बिस्तार देनेबाले लोक वापस च़ले जे, त यीशु यूहन्नारे बारे मां गवाही देने लगो, “तुस जंगले मां कुन हेरने जोरे थिये? कुन हवाई सेइं हिलते निरैठरे डाल? ");
INSERT INTO bhd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","त फिरी तुस होरू कुन हेरने जोरे थिये? कुन रोड़ां लग्गोरां लिगड़न बालो मैन्हु? हेरा, ज़ैना मगां लिगड़ां लाने बाले मैन्हु, ते ज़ैना एश केरनेबाले लोक भोतन। तैना राज़ महलन मां रातन, ");
INSERT INTO bhd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","त फिरी तुस होरू कुन हेरने जोरे थिये? कुन कोई नबी? हाँ, अवं तुसन सेइं ज़ोताईं, नेबी करां बड्डे। ");
INSERT INTO bhd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ए तैए, ज़ेसेरे बारे मां लिखोरूए, ‘हेर, अवं अपनो बिस्तार देनेबालो तीं अग्री-अग्री भेज़ताईं, ज़ै तेरी बत अग्रोवं तियार केरेलो।’ ” ");
INSERT INTO bhd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","यीशुए ज़ोवं, “अवं तुसन सेइं सच़ ज़ोताईं, कि ज़ै कुआन्शन करां ज़रमोरोए, तैन मां यूहन्ना बपतिस्मो देनेबाले करां बड्डो कोई नईं। पन ज़ै परमेशरेरे राज़्ज़े मां निकड़ोए, तै यूहन्ना करां बड्डोए।” ");
INSERT INTO bhd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ज़ैखन तैन लोकेईं एन गल्लां शुनी त धड़त नेनेबालेईं भी यूहन्ना बपतिस्मो देनेबाले करां बपतिस्मो नेइतां परमेशर धर्मी मन्नो। ");
INSERT INTO bhd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","पन फरीसी लोकेईं ते शास्त्री लोकेईं तैस करां बपतिस्मो न नेइतां परमेशरेरी मर्ज़ी अपने बारे मां टाली। ");
INSERT INTO bhd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“बस्सा, अवं इस ज़मानेरे लोकां केरि मिसाल केस सेइं देईं, तैना केसेरे ज़ेरेन? ");
INSERT INTO bhd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","तैना तैन मट्ठां केरे ज़ेरेन ज़ैना बज़ारे मां बिशोरां एक्की होरि जो हक देइतां ज़ोतन, ‘असेईं तुश्शे लेइ बेंशोई बज़ाइ, ते तुस न नच़्च़े, असेईं शौग मनाव, पन तुसेईं लेरां न दित्ती!’ ");
INSERT INTO bhd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","किजोकि यूहन्ना बपतिस्मो देनेबालो न रोट्टी खांतो अव, न शराब पीतो अव, ते तुस ज़ोतथ, कि एस पुड़ भूतेरो सैयो आए। ");
INSERT INTO bhd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","मैनेरू मट्ठू खातू पीतू अव, ते तुस ज़ोतथ, ‘हेरा, तै पेटू ते शराबी मैन्हु, कने धड़त नेनेबाले ते पापी लोकां केरो दोस्त।’ ");
INSERT INTO bhd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","पन अक्ल अपने सेब्भी मट्ठन करां जादे सच़्च़ी साबत भोइ।” ");
INSERT INTO bhd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","फिरी केन्चे फरीसे यीशु कां मिनत की, कि मीं सेइं साथी रोट्टी खा, बस्सा, तै तैस सेइं साथी तैसेरे घरे जेव, ते तैस सेइं साथी रोट्टी खांने लगो। ");
INSERT INTO bhd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","त हेरा, अक बदचलन कुआन्श ज़ै तैस नगरेरी थी एन बुझ़तां कि यीशु फरीसेरे घरे रोट्टी खांने बिशोरोए, संगमरमरेरे एक्की भांडे मां इत्र आनो। ");
INSERT INTO bhd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ते यीशुएरे पावन कां नेड़े लेरां देंती खड़ी भोइ, ते तैसेरे पाव एंखेइं सेइं सेले ते अपने दोग्गेरे बालेईं सेइं पोंछ़ने लगी ते तैसेरे पावन फुम्मड़ी देने लगी कने पावन पुड़ इत्र लाव। ");
INSERT INTO bhd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ज़ैनी फरीसे यीशु कुजोरो थियो, तैनी एन लाव, त ज़ोने लगो, “अगर ए मैन्हु नबी भोथो त बुझ़ेथो कि ज़ै कुआन्श तैस कांए तै कौने ते ए केरि कुआन्शे? किजोकि ए बदचलने।” ");
INSERT INTO bhd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","यीशु तैसेरे इन खियाल ज़ैंनतां तैस सेइं ज़ोवं, “हे शमौन, मीं तीं सेइं किछ ज़ोनूए।” फरीसे ज़ोवं, “हे गुरू ज़ो।” ");
INSERT INTO bhd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","यीशुए तैस सेइं मिसाल देइतां ज़ोवं “केन्ची शोहुकारेरो केन्ची दूई ज़न्न कां कर्ज़ो थियो, एक्की कां 500 दीनार, ते होरि कां 50 दीनार थिये। ");
INSERT INTO bhd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ज़ैखन तैन कां देने जो किछ न राऊं, त तैनी शोहोकरे दुइने कर्ज़ो माफ़ कमाव। बस्सा, कौन तैन मरां जादे शोहुकारे सेइं प्यार केरेलो?” ");
INSERT INTO bhd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","शमौने जुवाब दित्तो, “मेरे समझ़ी सेइं त ज़ेसेरो जादे कर्ज़ो माफ़ कियो।” यीशुए ज़ोवं, “तीं ठीक फैसलो कियो।” ");
INSERT INTO bhd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","यीशु तैस कुआन्शरे पासे तेकतां शमौने ज़ोवं, “कुन तू इस कुआन्शरां तकतस? अवं तेरे घरे अव, तीं मीं (रीतरे मुताबिक) पव धोने जो पानी न दित्तू, पन इसां मेरे पाव एंखेइं सेइं पव धोए ते अपने दोग्गेरे बालेईं सेइं पौंछ़े।” ");
INSERT INTO bhd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","तीं मीं (रीतरे मुताबिक) फुम्मड़ी न दित्ती, पन एसां ज़ैखनेरो अवं इड़ी ओरोईं मेरे पव्वन फुमड़ी देनी न उडैई। ");
INSERT INTO bhd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","तीं मेरे दोग्गे पुड़ तेल न मल्लो, पन एसां मेरे पावन पुड़ इत्र मल्लो। ");
INSERT INTO bhd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“एल्हेरेलेइ अवं तीं सेइं ज़ोताईं कि, एसारे जादे पाप ज़ैना एसां कियोरे थिये, माफ़ भोए, किजोकि एसां जादे प्यार कियो, पन ज़ेसेरे थोड़े पाप माफ़ भोतन तै थोड़ो प्यार केरते।” ");
INSERT INTO bhd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","यीशुए तैस कुआन्शी जो ज़ोवं, “गा तेरे पाप माफ़ भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","एस गल्ली पुड़ ज़ैना तैस सेइं साथी रोट्टी खांने बिश्शोरे थिये, अपने-अपने मने मां सोचने लगे, “ए कौने ज़ै पाप भी माफ़ केरते, पाप त सिर्फ परमेशर माफ़ केरते?” ");
INSERT INTO bhd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","पन यीशुए तैस कुआन्शी सेइं ज़ोवं, “परमेशरे तू एल्हेरेलेइ बच़ाई कि तीं मीं पुड़ विश्वास कियो, हुनी तू खुशी सेइं गा।” ");
INSERT INTO bhd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","थोड़े च़िरेरां बाद एरू भोवं यीशु अपने तैन 12 चेलेन सेइं साथी नगर-नगर ते ड्लव्वें-ड्लव्वें हंठतो ते प्रचार केरतो राव, ते परमेशरेरे राज़्ज़ेरी खुशखबरी शुनातो राव। ");
INSERT INTO bhd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","किछ कुआन्शां भी तैन सेइं साथी थी, ज़ैन मरां भूतां केरो सैयो कढोरो थियो। ते ज़ैन केरि बिमैरी दूर भोरी थी, तैना केरां नंव्वां इना आन, मरियम ज़ै मगदलीन ड्लव्वेंरी राने बाली थी, ज़ैस पुड़ां सत भूतां केरो सैयो कढोरो थियो, ");
INSERT INTO bhd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","हेरोदेस राज़ेरे भण्ड़ारी खोज़ेरी कुआन्श योअन्ना ते सूसन्नाह ते होरि भी काई कुआन्शां थी ज़ैना अपनि जेइदात देइतां यीशु ते तैसेरे चेलां केरि सेवा केरती थी। ");
INSERT INTO bhd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","फिरी ज़ैखन बड़े लोक तैस कां अकोट्ठे भोए, ज़ैस मां नगरां-नगरां केरे लोक तैस कां एइते थिये। यीशुए तैन मिसाल देइतां ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“एक्सां अक बीज़ बेनेबालो बीज़ बेने जो जेव। बीज़ बेते बार किछ बीज़ बत्तेरे ड्लेखी बिछ़ड़ू ते अम्बरेरे च़ुड़ोल्लेईं एइतां तैन बीज़ च़ुनू। ");
INSERT INTO bhd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ते किछ बीज़ घोड़नबाली ज़मीनी पुड़ बिछ़ड़ू, ते लग्गू पन जल्दी शुक्की जेव, एल्हेरेलेइ कि तैस पानी न मैल्लू। ");
INSERT INTO bhd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","किछ बीज़ कंटां केरे झ़ैल्लन मां बिछ़ड़ू। ज़ैखन तैड़ी बूटो लगो, त कंटां केरे झ़ैल्लेईं भी बेड़ोइतां तै बूटो दबेइ छ़ड्डो। ");
INSERT INTO bhd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ते किछ बीज़ रोड़ी ज़मीनी मां बिछ़ड़ू, ते लगू ते शौव गुणा फल लगो,” एन शुनेइतां तैनी तैन सेइं उच्ची आवाज़ी मां ज़ोवं, “ज़ै कोई समझ़नू चाते, तै ध्याने सेइं शुने ते समझ़े।” ");
INSERT INTO bhd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","तैसेरे चेलेईं तैस पुच़्छ़ू, “एस मिसालरो कुन मतलबे?” ");
INSERT INTO bhd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","यीशुए तैन ज़ोवं, “तुसन परमेशरेरे राज़्ज़ेरे भेदां केरि समझ़ दित्तोरीए, पन अवं होरि लोकन मिसाल देइतां ज़ोताईं, ‘तैन तैना बार-बार शुनेले, पन मेरी गल न समझ़ेले।’ ");
INSERT INTO bhd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“एस मिसालरो ई मतलबे, कि बीज़ परमेशरेरू वचने। ");
INSERT INTO bhd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ज़ैना मैन्हु परमेशरेरी गल्लां शुन्तन, तैन मरां किछ लोक तैस बत्तेरे ज़ेरे आन, ज़ैड़ी बीज़ बिछ़ड़ते। तैना त परमेशरेरी गल्लां शुन्तन, पन शैतान अकदम एइतां तैन मैन्हु केरे दिले मरां तैन वचन घिंनी गाते, कि एरू न भोए कि तैना विश्वास केरन ते तैन मुक्ति मैल्ले। ");
INSERT INTO bhd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ते घोड़नबाले ज़मीनी मां बेवरू बीज़ तैने, ज़ैना वचन शुन्तां खुशी सेइं मन्तन पन ज़ील न छ़डने सेइं तैना थोड़े च़िरे तगर विश्वास रखतन ते अज़मैइशरे मौके मुड़ी गातन। ");
INSERT INTO bhd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ते ज़ैन झ़ल्लन मां बीज़ झ़ड़ू तैना इना आन, ज़ैना वचन शुन्तन, पन अग्रोवं च़ेलतां फिक्र ते दौलत ते ज़िन्दगरो एशो-अशरती मां फेसी गातन ते तैन केरो फल न पक्के। ");
INSERT INTO bhd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","पन रोड़ी ज़मीनी पुड़ेरूए बीज़ तैन्न, ज़ैना वचन शुन्तन ते अमल भी केरतन, ते रोड़ेच़ारे दिले मां बसातन ते सबरी सेइं फल भी लगते। ");
INSERT INTO bhd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“कोई दीयो बैलतां केन्ची भांडे हैठ ओड़कतां न रखे, ते न खट्टी हैठ रखे बल्के उच्ची ठैरी रखतन ताके दीयो अन्तर एजने बालन लौ दे। ");
INSERT INTO bhd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","किजोकि कोई एरी चीज़ छ़पोरी नईं, ज़ै बांदी नईं भोनी, ते कोई भेद छ़पोतो न रालो, पन सारो भेद बांदो भोलो। ");
INSERT INTO bhd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","बस्सा हुशार राथ, कि तुस केन्च़रे शुन्तथ? ज़ैस कां परमेशरेरी मर्ज़ी समझ़नेरी इच्छा आए, तैस परमेशर जादे समझ़ देलो। पन ज़ैस कां परमेशरेरी मर्ज़ी समझ़नेरी इच्छा नईं, तैस केरां थोड़ी ज़ेरि समझ़, ज़ै तैस कां आए, तै भी नी गाली।” ");
INSERT INTO bhd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","फिरी तैसेरी अम्मा ते तैसेरे ढ्ला तैस कां आए, पन हछे मैन्हु केरि वजाई सेइं तैस कां न पुज़ी सके। ");
INSERT INTO bhd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ते यीशुए पतो दित्तो, “तेरी अम्मा ते तेरे ढ्ला बेइर खड़े आन ते तैना तीं सेइं गल केरनि चातन।” ");
INSERT INTO bhd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","यीशुए तैन जुवाब दित्तो, “मेरी अम्मा ते मेरे ढ्ला इना आन ज़ैना परमेशरेरू वचन शुन्तन ते तैस पुड़ अमल भी केरतन।” ");
INSERT INTO bhd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","फिरी एक्की दिहाड़े एरू भोवं, कि यीशुए अपने चेलन सेइं ज़ोवं, “एज्जा, समुन्दरे पार गाम ते तैना किश्ती मां च़ेढ़तां समुन्दरे पार च़ले जे।” ");
INSERT INTO bhd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","पन ज़ैखन किश्ती च़लोरी थी, त यीशुए झ़ुली जेव ते समुन्दरे पुड़ बड़ो तूफान अव, ते किश्ती पैनी सेइं भेरोने लग्गी, ते तैन खतरो भोइ जेव। ");
INSERT INTO bhd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","चेलेईं तै बींझ़ेइतां तैस सेइं ज़ोवं, “हे गुरू, असां मेरि गातम यीशु खड़े उठो ते हवाई जो ते पैनी जो ज़ोवं, रुकी गाथ ते तूफान रुकी जेव।” ");
INSERT INTO bhd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","यीशुए अपने चेलन सेइं ज़ोवं, “तुश्शो विश्वास कोरां जेव?” तैना डेरि जे ते हैरान भोइतां एप्पू मांमेइं ज़ोने लगे, “ए कौने! ए हवाई त पैनी भी हुक्म देते ते तैना एसेरो हुक्म मन्तन।” ");
INSERT INTO bhd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","फिरी तैना गिरासेनी इलाके मां पुज़े, ज़ै गलील समुन्द्रे सामने पारे। ");
INSERT INTO bhd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ज़ैखन तै बन्ने पुड़ ओस्सो, त तैस नगरेरो अक मैन्हु मैल्लो ज़ैस पुड़ भूतां केरो सायो थियो, ते तै बड़े दिहाड़े केरो देंतो न लिगड़ां लातो ते न घरे रातो थियो, बल्के कब्रन मां रातो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","तैनी मैने यीशु लाव ते चिन्डां लगो मारने, ते तैसेरे सामने झुकतां ज़ोरे सेइं ज़ोने लगो, “हे यीशु परमप्रधान परमेशरेरा मट्ठां! तीं मीं सेइं कुन कम्मे? अवं तीं कां मिनत केरताईं मीं दुख न दे।” ");
INSERT INTO bhd_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","किजोकि यीशु तैस भूते तैस मैन्हु मरां निसनेरो हुक्म देने लोरो थियो, एल्हेरेलेइ तै बड़े बुरे तरीके सेइं ट्लेइतां रखोरो थियो, ते लोक तैस कैबू केरनेरे लेइ अग्री भी रसन ते शंगलन सेइं बेंधतां रखते थिये, ते तै तैन भी ट्लोड़तो थियो, ते भूत तैस मैन्हु जंगले मां नेतू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","यीशुए तैस पुच़्छ़ू, “तेरू कुन नवं आए?” तैनी ज़ोवं “मेरू नंव फौज आए,” किजोकि तैस मां बड़ां भूतां थियां। ");
INSERT INTO bhd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ते तैनेईं तैस कां मिन्नत की, “असन अथाह कुण्डे मां गानेरो हुक्म न दे।” ");
INSERT INTO bhd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","तैड़ी पहैड़ी पुड़ अक सूरां केरो बड़ो घान थियो, ते तैनेईं तैस कां मिनत की, “असन एन मां गाने दे ते यीशुए गाने दित्तां।” ");
INSERT INTO bhd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ते तैना भूतां तैस मैन्हु मरां निस्तां तैन सूरन मां च़ेलि जेआं, ते सूरां केरो सारो घान उत्रेई उन्ढे छालां मैरतां समुन्दरे मां डुबतां मेरि जेव। ");
INSERT INTO bhd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","सूरां केरे च़ारनेबाले एन हेरतां नेश्शी जे, ते नगर मां ते ड्लोंव्वन मां एस गल्लरी खबर शुनाई। ");
INSERT INTO bhd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","लोक तै तमाशो हेरने आए, ते यीशु कां ज़ैस मैन्हु मरां भूतां केरि फौजरो सैयो निसोरो थियो, तैनी लिगड़ां लां ते होशी मां एइतां यीशु कां बिश्शोरो लाव ते डेरि जे। ");
INSERT INTO bhd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ज़ैनेईं तैना गल्लां पेइले लेवरी थी, तैनेईं ज़ोवं, इस मैन्हु पुड़ भूतां केरो सैयो थियो ते ए केन्च़रे बेज़्झ़ोव। ");
INSERT INTO bhd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ते गिरासेनियों इलाके मां च़ेव्रे पासां केरे लोक यीशु कां मिनत केरने लग्गे, कि इट्ठां च़लो गा, किजोकि तैना बड़े डर्रे थिये, ते यीशु किश्ती मां बिश्तां वापस च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","पन ज़ैस मैन्हु मरां भूतां निस्सोरां थियां तै यीशु कां मिनत केरतां ज़ोने लगो, मीं एप्पू सेइं साथी रख पन यीशुए तै भेज़ो ते ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“अपने घरे च़लो गा ते लोकन सेइं ज़ो, कि प्रभु परमेशरे तीं पुड़ दया केरतां तेरे लेइ केत्रू बड्डू कम कियोरूए। तैखन तै च़लो जेव ते सारे नगर मां एस गल्लारो प्रचार केरने लगो, कि यीशुए मेरे लेइ केत्रू बड्डू कम कियोरूए।” ");
INSERT INTO bhd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ज़ैखन यीशु वापस एज्जी राहोरो थियो, ते लोक बड़े खुशी सेइं तैस सेइं मिले, किजोकि तैना सब तैस बलगते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ते हेरा याईर नव्वेंरो अक मैन्हु ज़ै प्रार्थना घरेरो अक प्रधान थियो, यीशु कां अव ते तैसेरे पावन पुड़ पेइतां मिनत केरने लगो, “तू मेरे घरे च़ल।” ");
INSERT INTO bhd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","किजोकि तैसेरी अक्के कुई ज़ै 12 सालां केरि थी, तै मरनेबाली थी। ते ज़ैखन यीशु च़लोरो थियो, त लोक तैस उन्ढे बिछ़ड़ते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ते अक कुआन्श भी थी, ज़ैस 12 सालां केरि खून च़लनेरी बिमारी थी। ते तैसां अपनो सारो ज़िन्दगरो पेंइसो हकीमन कां अल्लाज़ेरे लेइ खर्च़ कियोरो थियो, ते तै केन्चेरे हथ्थे ठीक न भोइ। ");
INSERT INTO bhd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","तै कुआन्श यीशु पतोरां एइतां तैसेरे चोगे सेइं हुरी, त अकदम तैसेरी खून च़लनेरी बिमारी बेज्झ़ोईं। ");
INSERT INTO bhd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","यीशुए ज़ोवं, “मेरे लिगड़े सेइं केनि हथ लाव?” ज़ैखन सब लोक इन्कार केरने लगे, त पतरसे ते तैसेरे सैथेईं ज़ोवं, “ए गुरू, लोक तीं ढ्लांच़ने ते तीं उन्ढे बिछ़ड़ने लोरेन।” ");
INSERT INTO bhd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","पन यीशु ज़ोवं, “केन्चे मीं सेइं हथ लोरोए किजोकि मीं पतो लगो कि मीं मरां शक्ति निसोरिए।” ");
INSERT INTO bhd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","तैखन तैस कुआन्शां हेरू, कि अवं छ़ेप्पी न बेटि, त तै डरती-डरती सामने अई ते यीशुएरे पावन पुड़ बिछ़ड़तां सैरी लोकां केरे सामने ज़ोने लगी, मीं तीं सेइं हथ लोरोए, ते ज़ेरो मीं हथ लोरोए अवं अकदम बेज़्झ़ोरी। ");
INSERT INTO bhd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","यीशुए तैस कुआन्शी ज़ोवं, “हे कुईए, तेरे विश्वासे तू बज़्झ़ाई ते खुशी सेइं च़ली गा।” ");
INSERT INTO bhd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","यीशु एन हेजू ज़ोंतो थियो, त प्रार्थना घरेरे प्रधानेरे तैट्ठां केन्चे मैने एइतां ज़ोवं, “तेरी कुई मेरि जेवरिए, हुनी गुरू तकलीफ न दे।” ");
INSERT INTO bhd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","पन यीशु एन शुन्तां जुवाब दित्तो, “न डर। सिर्फ मीं पुड़ विश्वास रख कुई बेंच़ी गानीए।” ");
INSERT INTO bhd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ज़ैखन तै तैस घरे मां जेव, त तैनी पतरस यूहन्ना ते याकूब ते कुइयरे हाज बव्वेरे अलावा होरो कोई अन्तर एजने न दित्तो। ");
INSERT INTO bhd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","सब लोक तैस कुइयरे लेइ लेरां देंते थिये, पन यीशुए ज़ोवं, “लेरां न देथ, ए कुई मूओरी नईं बल्के झ़़ुलोरोए।” ");
INSERT INTO bhd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","लोक एन शुन्तां हसने लगे, किजोकि तैना ज़ानते थिये कुई मेरि जेवरिए। ");
INSERT INTO bhd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","पन यीशुए तैस कुइयरो हथ ट्लाव ते ज़ोवं, “कुइये खड़ी उठ!” ");
INSERT INTO bhd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ते तैसारे प्राण वापस आए ते तै लूशी खड़ी भोइ, ते यीशुए तैन ज़ोवं, एस कुइये किछ खाने जो देथ। ");
INSERT INTO bhd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","तैस कुइयरे हाज बव हैरान रेइजे, पन तैनी तैन सेइं समझ़ेइतां ज़ोवं, ज़ैन किछ इड़ी भोवं एन केन्ची सेइं न ज़ोइयथ। ");
INSERT INTO bhd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","यीशुए अपने 12 चेले एप्पू कां कुजाए ते तैन शक्ति ते अधिकार दित्तो कि सैरी भूतन कढन ते बिमैरी दूर केरन। ");
INSERT INTO bhd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ते यीशुए तैना परमेशरेरे राज़्ज़ेरो प्रचार केरनेरे लेइ ते बिमार बज़्झ़ानेरे लेइ भेज़े। ");
INSERT INTO bhd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","तैनी तैन सेइं ज़ोवं, “बत्तां जो किछ न नेइयथ, न सोटी न झोलो न रोट्टी न पेंइसे ते न दुइयोवं लिगड़ां। ");
INSERT INTO bhd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ज़ैस घरे मां गाथ त तैड़ी बिश्शी रेइयथ ज़ां तगर तुस तैस नगरे मरां न गाथ। ");
INSERT INTO bhd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ते ज़ैस नगरेरे लोक तुसन कबूल न केरन त तैस नगर मरां गांते बार अपने पांवां केरि धूड़ ठुड़कथ, ताके तैन पुड़ गवाही भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","बस्सा, तैना च़ले जे, ते ड्लोव्वें-ड्लोव्वें गेइतां परमेशरेरी खुशखबरी शुनाते, ते लोकन बिमैरन करां बज़्झ़ाते च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","मुलखेरो च़ेवरोवं हिस्से पुड़ हेरोदेस राज़ो राज़ केरतो थियो, तै एन सब शुन्तां डेरि जेव। किजोकि किछ ज़ोते थिये यूहन्ना मुड़दन मरां ज़ींतो भोरोए। ");
INSERT INTO bhd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ते किछ ज़ोते थिये एलिय्याह लेइहोरोए, ते किछ ज़ोते थिये नेबन मरां कोई ज़ींतो भोरोए। ");
INSERT INTO bhd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","पन हेरोदेसे ज़ोवं, “यूहन्नारी क्रोड़ी त मीं कट्टेव्री थी, पन ए कौन आए, ज़ेसेरे बारे मां एरी ज़ेरि गल्लां शुन्ने मां एजने लोरिन?” ते हेरोदेस यीशु हेरनेरी इच्छा की। ");
INSERT INTO bhd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","फिरी प्रेरितेईं वापस एइतां ज़ैन किछ कियेरू थियूं, यीशु सेइं शुनावं, ते यीशु तैन अलग नेइतां बैतसैदा नव्वेंरे नगर मां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ते बड़े लोक तैस पत्ती च़ले, ते यीशु बड़े खुशी सेइं तैन सेइं मिलो। ते तैन सेइं परमेशरेरे राज़्ज़ेरी गल्लां केरने लगो, ते ज़ैना बिमार ठीक भोनू चाते थिये, तैनी तैना बज़्झ़ाए। ");
INSERT INTO bhd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ज़ैखन दिहाड़ी डुबने लगी त तैन 12 चेलेईं यीशु सेइं ज़ोवं, “एन लोकन भेज़ी छ़ड एना कोस्कोई ड्लोंव्वन मां गेइतां बिशन ते रोट्टारो इंतज़ाम केरन। किजोकि असां गैर आबाद ठैरी आम।” ");
INSERT INTO bhd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","तैनी तैन सेइं ज़ोवं, “तुस्से एन किछ खाने जो देथ।” तैनेईं ज़ोवं, “असन कां पंच़ रोट्टी ते दूई मेछ़लीन करां जादे किछ भी नईं, पन असां गेइतां एन जेई रोट्टी मुल्ले घिन्तां आनतम, त इन भोइ बटते।” ");
INSERT INTO bhd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(किजोकि तैन लगभग 5000 मड़द थिये।) यीशुए अपने चेलन सेइं ज़ोवं, “एन लोकन 50-50 मैन्हु केरि हुन्डी मां बिशाला।” ");
INSERT INTO bhd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ते चेलेईं तैन्ने कियूं ते तैना तेन्च़रे बिशाले। ");
INSERT INTO bhd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","तैखन तैनी तैना पंच़ रोट्टी ते दूई मेछ़ली नी, ते अम्बरेरां तेकतां शुक्र कियूं, फिरी तैनी तैना रोट्टी ट्लोड़ी ते चेलन कां दित्ती, कि तैन बिशालोरे लोकन खांने जो देन। ");
INSERT INTO bhd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","सारे मैन्हु खेइतां रेज़्ज़ी जे। तैल्ला पत्ती, यीशुएरे चेलेईं बच़ोरे टुक्ड़न सेइं 12 टोकरी भेरि। ");
INSERT INTO bhd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","एक्की बार यीशु अकैल्लो प्रार्थना केरने लोरे थियो, ते चेले भी तैस सेइं थिये। यीशुए तैन पुच़्छ़ू, “कि लोक मींजो कुन ज़ोतन?” ");
INSERT INTO bhd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","चेलेईं जुवाब दित्तो, “किछ ज़ोतन यूहन्ना बपतिस्मो देनेबालो, ते किछ ज़ोतन एलिय्याह, ते किछ ज़ोतन नेबन मरां कोई अक ज़ींतो भोरोए।” ");
INSERT INTO bhd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","तैखन यीशुए चेलन पुच़्छ़ू, “पन तुस मेरे बारे मां कुन सोचतथ कि अवं कौन आईं?” पतरसे जुवाब दित्तो, “तू परमेशरेरो मसीह आस।” ");
INSERT INTO bhd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","तैखन तैनी तैन खबरदार केरतां ज़ोवं, “कि ए गल केन्ची सेइं न ज़ोइयथ।” ");
INSERT INTO bhd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","यीशुए ज़ोवं, “मैनेरे मट्ठेरे लेइ ज़रूरी आए, कि तै बड़ो दुःख झ़ैल्ले, यहूदी लोकां केरे बुज़ुर्गन, प्रधान याजकन, ते शास्त्री तैस घटिया सेमझ़तां मारेले, ते तै ट्लेइयोवं दिहाड़े फिरी ज़ींतो भोलो।” ");
INSERT INTO bhd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","फिरी यीशुए तैन सेब्भन ज़ोवं, “अगर कोई मीं पत्ती एजनो चाए, त अपने आपेरो इन्कार केरे, ते रोज़ अपनू क्रूस छ़ूए ते मीं पत्ती च़ले। ");
INSERT INTO bhd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","किजोकि ज़ै कोई अपनि जान बच़ांनी चाते तै तैस गुवालो, पन ज़ै मेरे लेइ अपनि जान गुवालो त तै तैस बच़ालो। ");
INSERT INTO bhd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","मैन्हु अगर सारी दुनिया हासिल केरे, ते अपनि जानरो नुकसान केरे, या अपनो आप गुवाए, त तैस कुन फैइदो? ");
INSERT INTO bhd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","किजोकि अगर कोई मैन्हु मीं करां त कने मेरी गल्लन करां शरमाते, त मैनेरू मट्ठू यानी अवं भी तैस केरां शरमालो। ज़ेइस अवं अपने बाजी केरि महिमा सेइं साथी त कने पवित्र स्वर्गदूतन सेइं साथी वापस एज्जलो, त तेइस अवं तैस केरां भी शरमालो।” ");
INSERT INTO bhd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“अवं तुसन सेइं सच़ ज़ोतईं कि ज़ैना इड़ी खड़े आन, तैन मरां किछ मैन्हु एरे आन कि ज़ांतगर तैना परमेशरेरे राज़्ज़ेरी शक्ति न हेरेले, तांतगर तैना न मरेले।” ");
INSERT INTO bhd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","एन गल्लां केरे लगभग अठ दिहाड़ना बाद पतरस, ते यूहन्ना ते याकूब साथी नेइतां एक्की पहाड़े पुड़ प्रार्थना केरने च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ते ज़ैखन यीशु प्रार्थना लोरो थियो केरने, त तैसेरी शकल बेदलोई जेई, ते तैसेरां लिगड़ां लोअरां ज़ेरां चमकने लगो। ");
INSERT INTO bhd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ते हेरा, मूसा, ते एलिय्याह, इन्ना दूई मड़द तैस सेइं गल्लां केरने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","इन्ना महिमा सेइं साथी लेइहोए, ते तैसेरे मरनेरी गलबात केरने लोरे थिये, ज़ैन किछ यरूशलेम नगरे मां भोनेबालू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पन पतरस ते तैसेरे सैथी केरि एछ़्छ़ी निड्ली सेइं गिरकी भोरी थी, ज़ैखन तैना बींझ़े, त तैनेईं तैसेरी महिमा ते तैना दूई मड़द भी लाए, ज़ैना तैस सेइं साथी खड़े थिये। ");
INSERT INTO bhd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ज़ैखन तैना तैस करां च़ले, त पतरसे यीशु सेइं ज़ोवं, “हे गुरू, इश्शू इड़ी रानू रोड़ोए, कि असां ट्लाई डेरे बनाम, अक तेरे लेइ, ते अक मूसेरे लेइ, ते एलिय्याहरे लेइ।” तैस पतो न थियो, कि तै कुन लोरोए ज़ोने। ");
INSERT INTO bhd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","तै इन ज़ोई राओरो थियो, तैन पुड़ बिदलार घिरी जेई, ते ज़ैखन तैन केरे च़ेव्रे पासन बिदलारी घिरी त तैना डेरि जे। ");
INSERT INTO bhd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","तैखन तैस बिदलारी मरां अक आवाज़ अई, “एन मेरू ट्लारू मट्ठू आए। ध्याने सेइं एसेरी गल शुना!” ");
INSERT INTO bhd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ते तैस आवाज़ी सेइं साथी तैनेईं यीशु अकैल्लो लाव, ते तैना च़ुप राए ते ज़ैन किछ लाहेरू थियूं, तैन केन्ची सेइं न ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","होरसां एरू भोवं कि ज़ैखन तैना पहाड़े पुड़ेरां उन्ढे ओरे थिये, त बड़े मैन्हु केरि भीड़ तैन कां आई। ");
INSERT INTO bhd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ते हेरा, एक्की मैने तैन लोकन मरां बड़े ज़ोरे सेइं हक देइतां ज़ोवं, “ए गुरू अवं तीं कां ज़ोवले हथ केरतां कि मेरे मट्ठे पुड़ दया केर; तैन मेरू अक्के मट्ठूए। ");
INSERT INTO bhd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ते हेर, अक भूत तैस अपने कब्ज़े मां केरते, ते तैन अकदम चिन्डां मारते, ते कम्बने लगते, ते तैसेरे ऐशेरां शैमफ निसचे, ते भूत तैस बड़े बुरे तरीके सेइं ज़ख्मी केरतां शारते। ");
INSERT INTO bhd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ते मीं तेरे चेलन कां बिनती कियोरी थी, कि तैस कढन, पन तैना न केढी सके।” ");
INSERT INTO bhd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","यीशुए जुवाब दित्तो, “हे विश्वास न केरने बालाव ते ढीठ लोकव, अवं केइस तगर तुसन सेइं साथी रेइलो ते तुश्शी झ़ैल्लेलो? अपने मट्ठे इड़ी आन।” ");
INSERT INTO bhd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","तै मसां ओरो थियो, त भूते तैन मट्ठू मुरोड़तां शारू, पन यीशुए भूत झ़िड़कतां कढ़ू, ते तैन मट्ठू बज़्झ़ेइतां तैसेरे बाजेरे हवाले कियूं। ");
INSERT INTO bhd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ते सब लोक परमेशरेरी बेड़ि कुदरती हेरतां हैरान रेइजे, ते ज़ैखन सब लोक तैन कम्मां ज़ैन यीशु केरतो थियो हैरान रहते थिये। त तैनी अपने चेलन सेइं ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“मेरी इन गल्लां रोड़ेच़ारे शुना किजोकि मैनेरू मट्ठू मैन्हु केरे हवाले भोने बालूए।” ");
INSERT INTO bhd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","पन यीशुएरी ए गल चेलां केरि समझ़ी मां न आई, किजोकि तैन करां ए गल छ़पोरी थी। कि तैन न समझ़न, ते चेले एस बारे मां यीशु पुच्छ़ने करां डरते भी थिये। ");
INSERT INTO bhd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","फिरी चेलन एप्पू मांमेइं बड़ी बेंस भोइ, कि असन मां बड्डो कौन आए? ");
INSERT INTO bhd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","यीशु तैन केरि दिलेरी गल्लां बुझ़तां निकड़ो बच्चो आनो ते तै एप्पू कां खड़ू कियूं। ");
INSERT INTO bhd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ते अपने चेलन सेइं ज़ोवं, “ज़ै इस बच्चे मेरे नंव्वे सेइं कबूल केरते, तै मीं कबूल केरते, ते ज़ै मीं कबूल केरते, तै मेरे भेज़ने बाले कबूल केरते। किजोकि ज़ै तुसन मां निकड़े करां निकड़ोए तै सेब्भन करां बड्डोए।” ");
INSERT INTO bhd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","तैखन यूहन्ना यीशु सेइं ज़ोवं, “ए गुरू, असेईं अक मैन्हु तेरे नंव्वे सेइं भूतां केरो सैयो कढतो लाव, ते असेईं तैस ठाकू किजोकि तै असन सेइं साथी मिलतां तीं पत्ती न च़ले।” ");
INSERT INTO bhd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","पन यीशुए जुवाब दित्तो, “तैस न ठाका, किजोकि ज़ै तुश्शे खलाफ नईं तै तुश्शो पासे।” ");
INSERT INTO bhd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ज़ैखन यीशुएरे उबरे नेनेरे दिहाड़े पूरे भोने पुड़ थी त तैनी पक्के च़ारे यरूशलेम नगरेरे पासे गानेरो खियाल कियो। ");
INSERT INTO bhd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ते एप्पू करां अग्री-अग्री किछ बिस्तार देनेबाले लोक भेज़े। ते लोक सामरी लोकां केरे एक्की ड्लोव्वें मां जे ताके यीशुएरे एजनेरी ठार तियारी केरन। ");
INSERT INTO bhd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","पन लोकेईं तै एजने न दित्तो, किजोकि तै यरूशलेम नगरे जो च़लोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","एन हेरतां तैसेरे चेले याकूब ते यूहन्ना ज़ोने लगे, “हे प्रभु, कुन तू चातस, कि अस हुक्म देम, अम्बरेरां अग बखेनतां एन लोकन भस्म केरे?” ");
INSERT INTO bhd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","पन तैनी बेदलोइतां तक्कू, ते तैना झ़िड़के (ते ज़ोवं, “तुस न ज़ानथ कि तुस कौस आत्मारे आथ। ");
INSERT INTO bhd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","किजोकि मैनेरू मट्ठू लोकां केरे प्राणन नाश केरने लेइ नईं बल्के बच़ांने ओरोए)” तैखन तैना होरि ड्लोंव्वेरे पासे च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ज़ैखन तैना बत्तां च़लोरे थिये, त केन्चे तैस सेइं ज़ोवं, “तू ज़ैड़ी-ज़ैड़ी भी गालो, अवं तीं पत्ती च़लेलो।” ");
INSERT INTO bhd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","यीशुए तैस सेइं ज़ोवं, “लौई केरि कूढां ते अम्बरेरे च़ुड़ोल्लू केरे आले भोतन, पन मैनेरे मट्ठे यानी मीं कां कोई ठार नईं ज़ैड़ी अवं झ़ुल्ली सेक्खी।” ");
INSERT INTO bhd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","फिरी यीशु एक्की होरि जो ज़ोवं, “मीं पत्ती च़ल,” पन तैनी मैने ज़ोवं, “हे प्रभु मीं घरे गानेरी अज़ाज़त दे, मेरे बाजेरे मरनेरां बाद अवं तैस देबतां एज्जेलो ते फिरी तीं पत्ती च़लेलो।” ");
INSERT INTO bhd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","यीशुए तैस जो ज़ोवं, “ज़ैना लोक आत्मिक तरीके सेइं मर्रेन तैन अपने मैन्हु मरने बलगने दे, पन तू गा ते परमेशरेरे राज़्ज़ेरे बारे मां लोकन मां प्रचार केर।” ");
INSERT INTO bhd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","एक्के होरे भी ज़ोवं, “ए प्रभु अवं तीं पत्ती च़लेलो, पन पेइले मीं भेज़ कि अवं अपने घरेबालन ज़ोईं।” ");
INSERT INTO bhd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","यीशुए तैस सेइं ज़ोवं, “ज़ै कोई हल्ली पुड़ हथ रेखतां पत्रोवं फिरतां तकते, तै परमेशरेरे राज़्ज़ेरे काबल नईं।” ");
INSERT INTO bhd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ते इन गल्लां केरे बाद प्रभुए 70 होरे चेले ठहराए, कि तै ज़ैस-ज़ैस नगर ते ठैरी तैनी एप्पू गानेरे बारे मां सोचोरू थियूं, तैड़ी दूई-दूई मैन्हु एप्पू अग्री भेज़े। ");
INSERT INTO bhd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ते तैनी तैन सेइं ज़ोवं, “पकोरी फसलरे ज़ेरे बड़े लोक तियार आन ज़ैना परमेशरेरे वचने पुड़ विश्वास केरनू चातन, पन कम केरनेबाले थोड़े आन ज़ैना तैन परमेशरे राज़्ज़ेरे बारे मां ज़ोन। एल्हेरेलेइ तुस फसलरे मालिके कां प्रार्थना केरा कि तै जादे कम केरनेबाले भेज़े, कि तैना लोकन परमेशरेरे राज़्ज़ेरे बारे मां ज़ोन।” ");
INSERT INTO bhd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","गाथ, अवं तुसन भैड्डां केरे ज़ेरे गिदन मां भेज़ताईं। ");
INSERT INTO bhd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","एप्पू सेइं साथी न बेटवे, न झोलो, न बूट नेइयथ, ते न बत्तां केन्ची जो नमस्कार ज़ोइयथ। ");
INSERT INTO bhd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ज़ेसेरे घरे मां गाथ त पेइले ज़ोथ कि, “इस घरे मां शान्ति भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","अगर तैड़ी एरे लोक ज़ैना परमेशरेरी शान्ति चातन तैड़ी रहते भोलो, त तुश्शी शान्ति तैस पुड़ राली, नईं त तुश्शी शान्ति तुसन पुड़ एज्जेली। ");
INSERT INTO bhd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","तैस्से घरे मां राथ, ते ज़ैन किछ तैन करां मैल्ले, तैन्ने खाथ-पीथ किजोकि मज़दूर अपनि मज़दूरारो हकदार भोते, घरे-घरे न गेइयथ। ");
INSERT INTO bhd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ते ज़ैस नगर मां गाथ, ते तैट्ठेरे लोक तुसन अपने घरे मां नेन, त ज़ैन किछ तुश्शे सामने रख्खू गाए तैन्ने खाथ। ");
INSERT INTO bhd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","तैट्ठेरे बिमारन बज़्झ़ाथ, ते तैन सेइं ज़ोथ, “परमेशरेरू राज़ नेड़े ओरूए।” ");
INSERT INTO bhd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","पन ज़ैस नगर मां गाथ, ते तैट्ठेरे लोक तुसन कबूल न केरन, त तैट्ठेरे बज़ारन मां गेइतां ज़ोथ। ");
INSERT INTO bhd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“कि तुश्शे नगरेरी धूड़ भी इश्शे पावन सेइं ज़ै लगोरीए अस तुश्शे सामने ठुड़कतम ते फिरी भी बुझ़ा कि परमेशरेरू राज़ तुश्शे नेड़े पुज़ेरूए।” ");
INSERT INTO bhd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","अवं तुसन सेइं सच़ ज़ोताईं, तैस दिहाड़े तैस नगरेरी हालत सदोम नगरेरी हालत झ़ैल्लनेरे काबल भोली। ");
INSERT INTO bhd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“हे खुराजीन! तीं पुड़ अफ़सोस! हे बैतसैदा तीं पुड़ अफ़सोस! कि एना चमत्कार मीं तुसन इड़ी हिराए अगर मीं एना कम्मां सूर ते सैदा मां हरेवरां भोथां, त तैन लोकेईं केइसेरे देंते टाट पलेटतां ते दोग्गे पुड़ मांज़न छ़ेडतां पापन करां मनफिरावरो भोथो। ");
INSERT INTO bhd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","पन फिरी भी इन्साफेरे दिहाड़े तुश्शो हाल सूर ते सैदारे हाले करां जादे बुरो भोलो। ");
INSERT INTO bhd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ते हे कफरनहूम नगरेरे लोकव, कुन तुस सोचतथ कि स्वर्गे मां तुश्शी आदर भोनीए! ई तुस त नरके गाले ज़ैड़ी पैपी लोकन सज़ा मैलेली! ");
INSERT INTO bhd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ज़ै तुश्शी शुन्ते, तै मेरी शुन्ते ज़ै तुसन घटिया समझ़ते तै मीं घटिया समझ़ते, ते ज़ै मीं घटिया समझ़ते ते मेरे भेज़ने बाले घटिया समझ़ते।” ");
INSERT INTO bhd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","तैना सतर चेले खुशी सेइं वापस आए, ते ज़ोने लगे, “हे प्रभु तेरे नंव्वे सेइं भूतां भी इश्शो हुक्म मन्तन।” ");
INSERT INTO bhd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","तैनी तैन सेइं ज़ोवं, “मीं शैतान एन्च़रे बिछड़तो लाव ज़ेन्च़रे च़ड़क अम्बरेरां पेचे। ");
INSERT INTO bhd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","हेरा, मीं तुसन सप्पन ते बिच़न ड्लेंच़नेरो, ते दुश्मनेरी (शैतानेरी) सैरी शेक्ति पुड़ अधिकारे दित्तोरोए, ते केन्ची चीज़ी सेइं तुसन नुकसान न भोलो। ");
INSERT INTO bhd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","फिरी भी तुस इस गल्ली सेइं खुशी न भोइयथ कि भूतां तुश्शो हुक्म मेनचन, पन इस गल्ली सेइं खुश भोइयथ कि तुश्शू नवं स्वर्गे मां लिखोरूए।” ");
INSERT INTO bhd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","तैखन यीशु पवित्र आत्मा सेइं मघन भोवं, ते ज़ोने लगो, “हे बाजी, स्वर्गेरे त धेरतरे प्रभु, अवं तेरू शुक्र केरताईं, कि तीं इना गल्लां, अक्लमन्द ते समझ़दारन करां छ़पेइतां रेख्खी, ते बच्चन पुड़ बेंदी की, हाँ, हे बाजी, किजोकि तेरी खुशी एस्से मां थी। ");
INSERT INTO bhd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","सैरी चीज़ां मेरे बाजेरी तरफां मेरे सुपुर्द कियोरिन, कोई होरो मट्ठे न ज़ांने, सिर्फ बाजी ज़ानते; कोई बाजी न ज़ांने सिर्फ मट्ठू ज़ानते, या तै मैन्हु बाजी ज़ानते ज़ैस पुड़ मट्ठू बांदो केरने चाए।” ");
INSERT INTO bhd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","तैखन तैनी अपने चेलां केरे पासे फिरो अकैल्ले मां ज़ोवं, “धन आन तैना एछ़्छ़ी ज़ैना एना गल्लां हेरचन ज़ैना गल्लां तुस लातथ, ");
INSERT INTO bhd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","किजोकि अवं तुसन सेइं ज़ोतां, कि बड़े नेबन ते राज़ां केरि खुवैइश थी, कि एना गल्लां हेरन, ज़ैना तुसेईं लेई, पन न लेई सके, ते एना गल्लां शुन्न ज़ैना तुस शुन्तथ पन न शुनी बेटि।” ");
INSERT INTO bhd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","एक्सां यीशु लोकन शिक्षा देने लोरो थियो, ते हेरा, अक शास्त्री खड़ो भोव, ते इन ज़ोइतां तैस अज़माने लगो, “ए गुरू, हमेशारी ज़िन्दगी हासिल केरनेरे लेइ अवं कुन केरि?” ");
INSERT INTO bhd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","तैनी तैस जुवाब दित्तो, “मूसेरे कानूने मां कुन लिखोरूए? तू केन्च़रे समझ़तस?” ");
INSERT INTO bhd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","तैनी जुवाब दित्तो, “तू प्रभु अपने परमेशरे सेइं अपने सारे दिले, सैरी जानी सेइं, ते अपनि सैरी ताकती सेइं ते अपनि सैरी अक्ल सेइं प्यार रख, ते अपने पड़ोसी सेइं अपने बराबर प्यार केर।” ");
INSERT INTO bhd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","तैनी तैस सेइं ज़ोवं, “तीं ठीक जुवाब दित्तो एन्ने केर, फिरी तीं हमेशारी ज़िन्दगी मैलेली।” ");
INSERT INTO bhd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","पन तैनी अपनो आप धर्मी ठहरानेरे लेइ यीशु पुच़्छ़ू, “फिरी मेरो पड़ोसी कौने?” ");
INSERT INTO bhd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","यीशुए तैस मिसाल देइतां जुवाब दित्तो, “अक मैन्हु यरूशलेम नगरेरां यरीहो नगरे जो च़लोरो थियो, ते तै डैकेइं तैस पुड़ हमलो कियो, ते ज़ैन किछ तैस कां थियूं नेव। ते तैसेरां लिगड़ां खोल्लां, ते मारो कुट्टो ते ज़ख्मी केरतां अधमरो बनेइतां तैड़ी ज़ेरे छ़डतां च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ते एरू भोवं कि, अक याजक तैस बत्तां च़लोरो थियो, तैनी तै लव ते थरकतो तैसेरी मद्दत केरने बगैर ड्लखमेइं निस्सो। ");
INSERT INTO bhd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","एन्च़रे अक मन्दरे मां कम केरनेबालो लेवी भी निस्सो, ते तैस लेइतां तै भी ड्लखमेइं निस्सो। ");
INSERT INTO bhd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","फिरी अक सामरी मुसाफर भी तैस बत्तां निस्सो, ते तैस लेइतां तैस बड़ो तरस अव। ");
INSERT INTO bhd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ते तै तैस कां जेव, ते तैसेरे ज़खमन तेल मल्लो ते दाछ़ोरो रस लाव, ते तैसेरे ज़खमन पट्टी बंधी ते अपने गधे पुड़ च़ेढ़तां एक्की धर्मशाली मां तैसेरी सेवा की। ");
INSERT INTO bhd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","होरसां तैनी दूई दीनार केढतां धर्मशालरे मालिके कां दित्ते, ते ज़ोवं, ‘एसेरी हेरगेश करां अगर जादे लग्गेले त अवं वैपसी पुड़ देलो।’ ");
INSERT INTO bhd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","तेरे समझ़ी मां एन ट्लेइन मरां कौन तैसेरो पड़ोसीए ज़ै डैकेइं ट्लातोरो थियो?” ");
INSERT INTO bhd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","तैनी जुवाब दित्तो, “ज़ैनी तैस पुड़ दया की।” यीशुए तैस सेइं ज़ोवं, “गा, तू भी एरू केर।” ");
INSERT INTO bhd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","फिरी ज़ैखन यीशु त कने तैसेरे चेले गेइ रावरे थियो, त तैना एक्की ड्लव्वें मां जे, ते मार्था नव्वेंरी एक्की कुआन्शां यीशु अपने घरे नीयो। ");
INSERT INTO bhd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ते मरियम नव्वेंरी तैसेरी अक बेइन थी, तै यीशुएरे पावन कां बिश्तां तैसेरी गल्लां शुनती थी। ");
INSERT INTO bhd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","पन मार्था किछ खास चीज़ बनेइ रावरी थी, ते यीशु कां आई ते ज़ोने लगी, “हे प्रभु तुसन ज़रां भी खियाल नईं कि, मेरी बेइनां अवं कम केरनेरे लेइ अवं अकैल्ली छ़डोरी? ते एस ज़ोथ, तै मेरी मद्दत केरे।” ");
INSERT INTO bhd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","प्रभुए तैस जुवाब दित्तो, “मार्था, हे मार्था, तू बेड़ि गल्लां केरे फिक्र केरतिस, ");
INSERT INTO bhd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","पन अक गल ज़रूरीए, मरियमा तै रोड़ो हिस्सो च़ुनोरोए, ज़ै तैस करां कोई न नेइ सके।” ");
INSERT INTO bhd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","फिरी यीशु एक्की ठैरी प्रार्थना लोरे थियो केरने। ते ज़ैखन तैनी प्रार्थना की, त तैसेरे चेलन मरां एक्के ज़ोवं, “हे प्रभु, ज़ेन्च़रे यूहन्ना अपने चेलन प्रार्थना केरनि शिखालोरिये तेन्च़रे तू भी असन शिखाल।” ");
INSERT INTO bhd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","यीशुए तैन सेइं ज़ोवं, “ज़ैखन तुस प्रार्थना केरथ, त एन ज़ोइयथ, ‘हे बाजी, लोक तेरी आदर केरन किजोकि तू पवित्र परमेशर आस। ते तेरू राज़ एज्जे।’ ");
INSERT INTO bhd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","‘इश्शी रोज़ेरी रोट्टी असन दे। ");
INSERT INTO bhd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","इश्शे पाप माफ़ केर, किजोकि अस भी ज़ैना इश्शे खलाफ बुराई केरतन, तैन माफ़ केरतम। अज़मैइशेरे ज़िरिये असन पाप केरने न दे।’” ");
INSERT INTO bhd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","फिरी यीशुए तैन सेइं ज़ोवं, “फर्ज़ केरा तुसन मरां केन्चेरो अक दोस्त एध्धी राती अपने दोस्ते ज़ोए, ‘तू मीं ट्लाई रोट्टी दे। ");
INSERT INTO bhd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","किजोकि मेरो अक दोस्त बड़े दूरेरां हंठतो मेरे कां ओरोए, ते मेरे कां रोट्टी नईं, कि अवं तैस रोट्टी देइ सेखी।’ ");
INSERT INTO bhd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ते तै तैसेरो दोस्त अत्रां जुवाब दे, मीं दुःख ने दे, हुनी त दार बंदे, मीं कां मेरे बच्चे झ़ुलोरेन, ते अवं तीं रोट्टी न देइ सेखी। ");
INSERT INTO bhd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","अवं तुसन सेइं ज़ोताईं कि, अगर तै तैसेरो दोस्ते ते तैस रोट्टी न दे, त तैसेरो दोस्तेरे बार-बार मिनत केरने सेइं ज़रूर तैस रोट्टी देलो ते ज़ेत्री रोट्टी केरि तैस ज़रूरत भोली देलो। ");
INSERT INTO bhd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ते अवं तुसन सेइं ज़ोताईं, मग्गा त तुसन दित्तू गालू। ते तोप्पा, त तुसन मैल्ली गालू। ते दार गुड़काथ, त तुश्शे लेइ खोल्लू गालू। ");
INSERT INTO bhd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","किजोकि ज़ै कोई मगते तै हासिल केरते, ते ज़ै कोई तोपते तैस मैल्ली गाते, ते ज़ै कोई दार गुड़काते त तैसेरेलेइ खोल्लू गाते। ");
INSERT INTO bhd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","तुसन मरां कौन ज़ेरो बाजी एरो भोए, कि ज़ैखन तैसेरू मट्ठू रोट्टी मग्गे त तैस घोड़ दे? या मछ़ली मग्गे, ते तै सप दे? ");
INSERT INTO bhd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","या ठूल मग्गे त तैस बिच्च़ू दे? ");
INSERT INTO bhd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ते तुस बुरे भोनेरे बावजूद भी अपने मट्ठन रोड़ी चीज़ां देनी ज़ानतथ त तुश्शो स्वर्गेरो बाजी तैन, ज़ैना तैस करां मगतन पवित्र आत्मा किना देलो।” ");
INSERT INTO bhd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","फिरी तैनी एक्की लट्टे मरां भूतेरो सैयो कढो, ज़ैखन भूतेरो सैयो निस्सो, त तै लट्टो गल्लां लगो केरने, ते लोक हैरान रेइजे। ");
INSERT INTO bhd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","पन तैन मरां किछ मैनेईं ज़ोवं, “ए त भूतां केरे गुरू शैतानेरे मद्दती सेइं भूतां कढते।” ");
INSERT INTO bhd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ते किछेईं अज़मानेरे लेइ तैस करां कोई अक अम्बरेरो निशान मग्गो। ");
INSERT INTO bhd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","पन यीशुए तैन केरे मन्नां केरे खियाल ज़ैनतां तैन सेइं ज़ोवं, “ज़ैस-ज़ैस राज़्ज़े मां फूट पेचे, तैन राज़ बनोरू न राए, ते ज़ैस खानदाने मां फूट पेचे, तैन भी बनोरू न राए। ");
INSERT INTO bhd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","अगर शैतान अपनि खलाफत एप्पू केरे, त फिरी तैसेरू राज़ केन्च़रे रेइ सकते? फिरी तुस केन्च़रे ज़ोतथ कि अवं शैतानेरे मद्दती सेइं भूतां कढताईं। ");
INSERT INTO bhd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","अगर अवं शैतानेरी मद्दती सेइं भूतां कढताईं त तुश्शी औलाद कसेरे मद्दती सेइं कढती? तैन्ना तुश्शो फैसलो केरनेबाले हाकिम भोले। ");
INSERT INTO bhd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","पन अगर अवं परमेशरेरे शेक्ति सेइं भूतां कढताईं त परमेशरेरू राज़ तुश्शे नेड़े पुज़ोरूए। ");
INSERT INTO bhd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ज़ैखन कोई ज़ोरेबाले मैन्हु अपने घरेरो पैरहो केरते, त तैसेरू सब किछ बंच़ेरू रहते। ");
INSERT INTO bhd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","पन ज़ैखन तैस करां कोई निगर मैन्हु तैस पुड़ हमलो केरते त तैस अपने कब्ज़े मां केरतां तैसेरे सारे हथियार घिंनी गाते ज़ैस पुड़ तैसेरो भरोसो थियो, ते तैसेरी सारी जेइदाद लुटी गाते। ");
INSERT INTO bhd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ज़ै मीं सेइं साथी नईं तै मेरे मुखालफे, ते ज़ै मीं सेइं साथी अकोट्ठू न केरे ते तै खिलारते। ");
INSERT INTO bhd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ज़ैखन केन्ची मैन्हु मरां भूत निसते त तैन शुक्कोरो ठैरन मां आराम तोपते ते ज़ैखन तैस तै आराम न मैल्ले त ज़ोते कि अवं वापस तैस्से घरे मां गालो ज़ैट्ठां अवं निसोरोईं। ");
INSERT INTO bhd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ते तैखन तैन भूत वापस एइतां तैन घर साफ सुथरु रोड़ू लाते। ");
INSERT INTO bhd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","तैखन तै एप्पू सेइं साथी सत होरां भूतां साथी घिन्तां तैस मां अन्तर गेइतां बिश्शतन, ते तैस मैनेरो हाल पेइले हाले करां जादे बुरो भोते।” ");
INSERT INTO bhd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ज़ैखन यीशु इना गल्लां ज़ोने लग्गोरो थियो, त भीड़ी मरां अक कुआन्श जोरे सेइं ज़ोने लगी, “धने तै कुआन्श ज़ैसां तीं ज़र्म दित्तू ते तू पालो।” ");
INSERT INTO bhd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","पन यीशुए ज़ोवं, “हाँ, पन धन आन तैना लोक ज़ैना परमेशरेरू वचन शुन्तन ते तैस पुड़ अमल केरतन।” ");
INSERT INTO bhd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ज़ैखन हछे लोक भोने लगे त यीशु ज़ोवं, “इस ज़मानेरे लोक बुरेन, तैना निशान तोपतन, पन योनेरे निशानेरे अलावा एन होरो कोई निशान न दित्तो गालो। ");
INSERT INTO bhd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","किजोकि ज़ेन्च़रे योना नबी नीनवेरे लोकन जो निशान बनो तेन्च़रे मैनेरू मट्ठू भी इस ज़मानेरे लोकां केरे लेइ निशान बनेलू। ");
INSERT INTO bhd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","पन दक्षिणेरी रानी आदालतरे दिहाड़े इस ज़मानेरे लोकन दोषी बनाली, किजोकि तै बड़े दूरेरां सुलैमानेरे ज्ञानेरे बारे मां शुन्तां ओरी थी। ते इड़ी हेरा सुलैमाने करां भी बड्डोए। ");
INSERT INTO bhd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","नीनवेरे लोक आदालतरे दिहाड़े इस ज़मानेरे लोकन सेइं साथी खड़े भोइतां मुर्ज़म बनाले। किजोकि तैनेईं योनारे प्रचारे सेइं पापन करां मनफिरावरो थियो, पन इड़ी हेरा तै आए, ज़ै योना करां भी बड्डोए। ");
INSERT INTO bhd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“कोई मैन्हु दीयो बैलतां भांडे हैठ या ओड़कतां न छ़डे, बल्के उच्ची ठैरी रखतन ताके अन्तर एजने बालन लौ भोए। ");
INSERT INTO bhd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","अछ़ जानेरे लेइ दीयेरी ज़ेरि आए, अगर तेरी अछ़ रोड़ीए, त तेरी जानी मां भी लौए, ते अगर तेरी अछ़्छ़े बुरीए त तेरी जान भी आंधरीए। ");
INSERT INTO bhd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","एल्हेरेलेइ खबरदार रेइयां, कोस्कोई एरू न भोए कि ज़ै लौ तीं मां आए तै आंधरू न भोए। ");
INSERT INTO bhd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","अगर तेरी जानी मां लौए, त तैसेरो कोई भी हिस्सो आंधरो न भोए, त सब एरू भोलू, ज़ैखन दीयो चमकतां लौ देते।” ");
INSERT INTO bhd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ज़ैखन तै एना गल्लां ज़ोने लोरो थियो, त केन्चे फरीसे यीशु कां मिनत की, कि मीं सेइं साथी रोट्टी खा, ते यीशु तैसेरे घरे जेव ते तैसेरे कां गेइतां रोट्टी खाने बिश्शो। ");
INSERT INTO bhd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","फरीसी लोक एन हेरतां हैरान भोव, कि ए बगैर हथ-पाव धोने रोट्टी खांने बिश्शी जेव। ");
INSERT INTO bhd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","पन प्रभुए फरीसी सेइं ज़ोवं, “हे फरीसाव तुस कटोरो, ते थाली बेइरमेईं त बड़ी साफ केरतथ, पन तुश्शे अन्तर ज़ुलम ते लालच़ भेरतांए। ");
INSERT INTO bhd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","हे बेअक्लाव, ज़ैनी बेरीयोवं हिस्सो बनावरोए, तैनी आंट्लेइयों हिस्सो नईं बनेरो? ");
INSERT INTO bhd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","बस्सा एन्त्री चीज़ दान केरा, त हेरा, सब किछ तुश्शे लेइ साफ भोइ गालू। ");
INSERT INTO bhd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","पन हे फरीसाव, तुसन पुड़ अफ़सोस! तुस पुतनेरो ते ज़ीरेरो ते कने सेब्ज़ारो दशोवं हिस्सो देतथ, पन तुस इन्साफ केरने करां त परमेशरेरे प्यारे करां दूर रातथ, लोड़तू थियूं कि दशोवं हेसे सेइं साथी इन भी केरेथे। ");
INSERT INTO bhd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","हे फरीसाव, तुसन पुड़ अफ़सोस! तुस लोक चातथ कि प्रार्थना घरन मां तुसन एग्री कुर्सन पुड़ बिशालन ते बज़ारन मां लोक तुसन कां झुकतां नमस्कार केरन। ");
INSERT INTO bhd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","पन हे फरीसाव तुसन पुड़ अफ़सोस! तुस तैन छ़ेपोरी कब्रां केरे ज़ेरेथ, ज़ैन पुड़ लोक च़लतन, पन तैन पतो न भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","तैखन शास्त्री मरां एक्के तैस जुवाब दित्तो, “हे गुरू एना गल्लां ज़ोइतां तू इश्शी तुहीन लोरोस केरने।” ");
INSERT INTO bhd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","यीशुए ज़ोवं, “हे शास्त्री लोकव, तुसन पुड़ अफ़सोस! तुस मैनन् पुड़ त एत्रो भारो लदतथ ज़ै छ़ूनो असुखतो भोते ते पन एप्पू अपने कानूने मन्नेरी कोशिश भी न केरन। ");
INSERT INTO bhd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","तुसन पुड़ अफ़सोस! तुस नेबी केरि कब्रां बनतथ ते तुश्शे दादे-पड़दादेईं तैना मारोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","बस्सा, तुस शहातथ कि तुस अपने दादे-पड़दादां केरे कम्मां केरि पूरी तैइद केरतथ, किजोकि तैनेईं त नबी कत्ल कमाए ते तुस तैन नेबी केरि कब्रां बनातथ। ");
INSERT INTO bhd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","एल्हेरेलेइ प्रभु परमेशरेरी अक्लां ज़ोवं, नबी त प्रेरित तैन कां भेज़नेन तैना तैन मरां किछ कत्ल केरेले ते किछन सताले। ");
INSERT INTO bhd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","बस्सा ई कौम सारे नेबी केरे खूनेरे ज़ै दुनियारे शुरू करां देंतो बगेवरोए ज़िमेवार भोली। ");
INSERT INTO bhd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","हाबिलेरे खूने करां देंतो ते जकर्याहरे कत्ले तगर ज़ै तुसेईं मन्दरेरे ते बलिदान केरनेरे ठारारे मझ़ाटे मन्दरेरे अंगने मां कत्ल कियोरो थियो। अवं ज़ोताईं कि ए कौम तैन केरे खूनेरी ज़िमेवार भोली। ");
INSERT INTO bhd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","पन हे फरीसाव तुसन पुड़ अफ़सोस! तुसेईं शास्त्री लोकेईं चाबी त अपने कब्ज़े मां रख्खी, पन तुस एप्पू भी दाखल न भोए ते ज़ैना दाखल भोनू चाते थिये तैना भी रोके।” ");
INSERT INTO bhd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ज़ैखन यीशु तैट्ठां निस्सी जेव त शास्त्री ते फरीसी लोकेईं तै घेरो ते सरकरे मारे च़ेव्रे पासना बड़े असुखते सवाल पुच्छ़ने लगे। ");
INSERT INTO bhd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ताके यीशुएरे ज़बा एरी गल निस्से ज़ैस सेइं लोक तैस पुड़ गलती लांन। ");
INSERT INTO bhd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","एत्रे मां हज़ारेईं मैन्हु अकोट्ठे भोइ जे, ते एक्की होरि उन्ढे खिरकते थिये त यीशुए सेब्भन करां पेइले अपने चेलन खड़े भोइतां ज़ोवं, “फरीसी लोकां केरे पाखंडेरे खमीरे यानी तैन केरे रीति रूवाज़न करां हुशार रेइयथ। ");
INSERT INTO bhd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","कोई चीज़ ओड़कोरी नईं ज़ै बांदी न भोए, ते न कोई चीज़ छ़पोरीए ज़ै ज़ानी न गाए। ");
INSERT INTO bhd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","एल्हेरेलेइ ज़ैना गल्लां तुसेईं आंधरे मां ज़ोरिन तैना गल्लां लोई मां शुनोनिन, ते ज़ैना गल्लां तुसेईं अन्तर ज़ोरिन तैन केरू एलान लाए पुड़ भोनूए। ");
INSERT INTO bhd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“दोस्तव अवं तुसन सेइं सच़ ज़ोताईं कि तैन करां न डेरथ ज़ैना जानी नुकसान पुज़ातन तैसेरे बाद तैना किछ न केरि बटन। ");
INSERT INTO bhd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","पन अवं तुसन सेइं सच़ ज़ोताईं कि केस करां डर्रू लोड़ते, ज़ैस जानी मारनेरे बाद तैसेरी आत्माई नरके मां छ़डनेरो अधिकारे, हाँ अवं तुसन सेइं सच़ ज़ोताईं कि तैस करां डरा। ");
INSERT INTO bhd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","कुन दूई पेंइसन मां पंच़ च़ड़ोली न बिकन? पन परमेशर तैन मरां केन्ची भी न बिसरे। ");
INSERT INTO bhd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","बल्के तुश्शे दोग्गेरे सारे बाल गनोरेन डरा नन्ना तुस त काई च़ुड़ोलन करां भी जादे कीमती आथ। ");
INSERT INTO bhd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“अवं तुसन ज़ोताईं कि ज़ै कोई मैन्हु केरे सामने मेरो इकरार केरेलो, त अवं मैनेरू मट्ठू भी परमेशरेरे स्वर्गदूतां केरे सामने इकरार केरेलो ");
INSERT INTO bhd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","पन ज़ै मैन्हु केरे सामने मेरो इन्कार केरेलो त तैसेरो इन्कार परमेशरेरे स्वर्गदूतां केरे सामने कियो गालो। ");
INSERT INTO bhd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“ज़ैना लोक मैनेरे मट्ठेरे खलाफ किछ ज़ोले तै तैस माफ़ केरेलो पन ज़ै पवित्र आत्मारी तुहीन केरेलो तैस माफ़ न केरेलो। ");
INSERT INTO bhd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ज़ैखन तैना तुसन प्रार्थना घरन मां ते बड़े-बड़े ते अधिकैरन कां नेले त फिक्र न केरथ कि अस कुन ज़ोम ते केन्च़रे जुवाब देम। ");
INSERT INTO bhd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","किजोकि पवित्र आत्मा तुसन तैस वक्ते ज़ोलो कि तुसेईं कुन ज़ोनूए।” ");
INSERT INTO bhd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","फिरी भीड़ी मरां केन्चे एक्के यीशु सेइं ज़ोवं, “हे गुरू जी मेरे ढ्लाए जो ज़ो, कि इश्शे बाजी केरि जेइदाती मरां मेरो हिस्सो मेरे हवाले केरे।” ");
INSERT INTO bhd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","यीशुए तैस जुवाब दित्तो, “अवं केनि तुश्शो हाकिम या बंटने बालो बनेवरोइं?” ");
INSERT INTO bhd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ते यीशुए तैन सेइं ज़ोवं, “हर किसमेरे लालच़े करां दूर भोइयथ ते न केन्चेरी जेइदाद केन्चेरी जानी करां जादे भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","तैखन यीशुए तैन अक मिसाल शुनाई, “केन्ची अमीरेरे ज़मीनी मां बड़ी फसल बनी। ");
INSERT INTO bhd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","तै अपने दिले मां सोचतां ज़ोने लगो, कि अवं कुन केरि, मीं कां ठारे नईं कि ज़ैड़ी अवं अन्न रेख्खी सेखी? ");
INSERT INTO bhd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","तैखन तैनी ज़ोवं कि, ‘अवं अक कम केरताईं, अपने पुराने कोठार पुटतां होरे बड्डे कोठार बनेइ ते अपनू सारू अन्न तैस मां रखेलो। ");
INSERT INTO bhd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","फिरी मीं अपने आपे सेइं ज़ोनूए कि, मीं कां त बड़े सालन तगर अन्न जम्हां भोरूए, मेरी जान आरामे सेइं खा ते एश केर।’ ");
INSERT INTO bhd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","पन परमेशरे तैस मैन्हु जो ज़ोवं, ‘हे बेवकूफ अज़े राती तू मरेलो, ते ज़ैन किछ तीं अपने लेइ जम्हां केरतां रखेरुए तैन केसेरू भोलू?’ ");
INSERT INTO bhd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","एल्हेरेलेइ ज़ै अपने लेइ दौलत जम्हां केरते, पन परमेशरेरी नज़री मां तै अमीर न भोए एसेरो भी एरो हाल भोनोए।” ");
INSERT INTO bhd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","तैखन यीशुए अपने चेलन सेइं ज़ोवं, एल्हेरेलेइ तुस न अपने ज़िन्दगरी ज़रूरतरे लेइ फिक्र केरा, कि तुस कुन खाले, ते न अपने जानारी कि कुन लामेले। ");
INSERT INTO bhd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","किजोकि प्राण रोट्टी करां ते जान लिगड़े करां बेधतां भोते। ");
INSERT INTO bhd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कांवां केरां तक्का, तैना न बेन ते न कटन ते न तैन कां गुदाम या कोठार भोन, तांभी परमेशर तैन खाने जो देते ते तुस त च़ुड़ोलन करां भी जादे कीमती आथ। ");
INSERT INTO bhd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","तुसन मां एरो कौन आए, ज़ै फिक्र केरतां अपनि उमर अक घड़ी भी बधैई सकते? ");
INSERT INTO bhd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","बस्सा, ज़ैखन तुस ए अक निकड़ी ज़ेरि गल भी न केरि बटथ, त बाकी बेड्डी चीज़ां केरि फिक्र किजो केरतथ? ");
INSERT INTO bhd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","सोसनेरे फूड़ू केरे तक्का कि तैना केन्च़रे बेडोतन? तैना न मेहनत केरन ते न कत्तन, फिरी भी अवं तुसन सेइं ज़ोताईं कि राज़ो सुलैमाने भी अपने सारे धन दौलतरे बावजूद भी तैन केरां ज़ेरां लिगड़ा न लां। ");
INSERT INTO bhd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","बस्सा ज़ैखन परमेशरे मैइदानेरो घास, ज़ै अज़ आए ते कालां लौवंने मां फुकनोए, एरी खूबसूरती देते, त हे घट विश्वासे बाले लोकव, कुन तै तुसन लिगड़ न देलो? ");
INSERT INTO bhd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ते एस फिक्रे मां न रेइयथ, कुन खामेले, या कुन पीमेले, या कुन लामेले, ते न शक केरथ। ");
INSERT INTO bhd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","किजोकि दुनियारी सैरी कौमां एस्से फिक्रे मां लेगोरी रेइचन, पन तुश्शो बाजी ज़ानते, कि तुसन कोनां-कोनां चीज़ां केरि ज़रूरत आए। ");
INSERT INTO bhd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","पेइले परमेशरेरे राज़्ज़ेरे तलाश केरा, फिरी तुसन एना सैरी चीज़ां मैल्ली गैली। ");
INSERT INTO bhd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“तुस भैड्डां केरे निकड़े केन्नरे ज़ेरेथ, तुस कोन्ची गल्लरे लेइ न डरा, किजोकि तुश्शे बाजेरी खुशी एस्से मां आए, कि तै तुसन राज़ दे। ");
INSERT INTO bhd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","अपनू घरबार बेच़तां धर्मरथ देथ, ते एप्पू जो अक बेटुवो बनाथ, ज़ै पुरानो न भोए, स्वर्गे मां दौलत जम्हां केरा ज़ै कधे न मुक्के, ज़ैड़ी न च़ोर पुज़े ते न कीड़ो खाए। ");
INSERT INTO bhd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","किजोकि ज़ैड़ी तेरी दौलत भोली, तैड़ी तेरो दिल भी लग्गेलो। ");
INSERT INTO bhd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“सेवा केरनेरे लेइ रोड़ेच़ारे कमर बेंद्धतां तियार भोथ, ते तुश्शे दीये सैरी राती बलते रान। ");
INSERT INTO bhd_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","तुस मेरे एजनेरे लेइ एन्च़रे तियार राथ, ज़ेन्च़रे मैन्हु केरे अपने मालिके, ज़ै ड्लाएरे धामी मरां वापस एजने बलगतन, कि ज़ैखन तै एज्जे ते दार गुड़कान त अस दार खोल्लम। ");
INSERT INTO bhd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","तैना नौकर धन आन ज़ैना अपने मालिकेरे वापस एजने पुड़ बींझ़े मैलतन, अवं तुसन सेइं सच़ ज़ोताईं, कि तै एप्पू तैन रोड़ेच़ारे नौकरन लिगड़ां लेइतां तियार लाएलो, ते मालिक तैन सेइं खुश भोइतां एप्पू सेइं साथी रोट्टी खाने बिशालेलो ते तैन केरि सेवा केरेलो। ");
INSERT INTO bhd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","अगर मालिक एध्धी राती या झ़ेझ़ेरेपार एइतां अपने नौकरन बींझ़े लाए त तैन नौकरां केरे लेइ केत्री रोड़ी गल्ले। ");
INSERT INTO bhd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","पन याद रखा, अगर घरेरे मालिके, च़ोर एजनेरो पतो भोए त तै बींझ़ो राथो ते अपने घरे च़ोरी न देथो भोने। ");
INSERT INTO bhd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","बस्सा, तुस भी मेरे वापस एजनेरे लेइ तियार राथ, मैनेरू मट्ठू यानी अवं तैस वक्ते एज्जेलो ज़ेइस तुसन खियाल भी न भोलो।” ");
INSERT INTO bhd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","पतरसे पुच़्छ़ू, “हे प्रभु ज़ै मिसाल तीं शुनाई तै सिर्फ इश्शे लेइए या सेब्भी केरे लेइए?” ");
INSERT INTO bhd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","प्रभुए ज़ोवं, “कौने ईमानदार अक्लमन्द नौकर ज़ेसेरो मालिक तैस अपने नौकरन पुड़ मुन्शी रखे ताके तैन केरि खूराक ठीक मौके पुड़ रोड़ेच़ारे बंटतो राए? ");
INSERT INTO bhd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","तै नौकर धने कि ज़ेसेरो मालिक एज्जे ते मालिक तैस रोड़ेच़ारे कम केरतू लाए। ");
INSERT INTO bhd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","अवं तुसन सेइं सच़ ज़ोताईं कि तै अपने सारे घरबारेरी हेरगैशरो अधिकार तैसेरे सुपुर्द केरेलो। ");
INSERT INTO bhd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","पन अगर तै नौकर अपने दिले मां ज़ोए कि मेरे मालिके एजने हेजू बड़ू च़िरे ते होरि नौकरन ते नौकरेनन मार धाड़ केरनि शुरू केरे ते खेइ पीतां नशे मां मसत भोइ गाए। ");
INSERT INTO bhd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ते तैस नौकरेरो मालिक केन्ची एरे दिहाड़े एज्जे ज़ेइस तैस नौकरे एजनेरो पतो न भोए ते तै मालिक एज्जी गाए त तैस नौकरेरे टुक्ड़े-टुक्ड़े केरतां ते तैसेरी हालत बेइमाना केरि ज़ेरि भोली। ");
INSERT INTO bhd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","हर तै नौकर ज़ै ज़ानते कि तैसेरे मालिकेरी कुन मर्ज़ी आए, कि तै कुन केरे, मगर तै अपने आपे कम केरनेरे लेइ तियार न केरे ते अपने मालिकेरी मर्ज़ी पूरी न केरे तैस पक्की मार बज़नीए। ");
INSERT INTO bhd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","पन अगर कोई नौकरे ज़ैस नईं पतो कि मेरे मालिकेरी कुन मर्ज़ी, कि अवं कुन केरि, ते तैन केरे ज़ैस सेइं तैस सज़ा मैल्ले, त तैस घट सज़ा मैलेली।” ");
INSERT INTO bhd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","यीशुए ज़ोवं, “अवं धेरती पुड़ अग लांने ओरोईं ते अगर अग लग्गोरी भोथी त रोड़ू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","पन मीं बड़े जल्दी दुःख झ़ैल्लनोए, ते अवं बड़ो परेशानईं ज़ां तगर दुख न झ़ेल्ली। ");
INSERT INTO bhd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","कुन तुस एन सोचतथ कि अवं धेरती पुड़ मेल कराने लेइ ओरोईं? नईं! अवं तुसन सेइं ज़ोताईं, कि अलग केरने ओरोईं। ");
INSERT INTO bhd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","अज़्ज़ेरे बाद अगर एक्की घरे मां पंच़ मैन्हु भोले त तैना एप्पू मांमेइं बेंटोले, ट्लाई ज़ैना मीं पुड़ विश्वास न केरन तैना दुइयां केरे खलाफ भोले, ते दूई, ट्लेइयां केरे खलाफ भोले। ");
INSERT INTO bhd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","बाजी मट्ठेरे खलाफ भोलो ते मट्ठू बाजेरे खलाफ भोलू, हैई कुइयरे खलाफ ते कुई हैईयरे खलाफ ते शिख नुशारे ते नुश शिखारे खलाफ भोनीए।” ");
INSERT INTO bhd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","फिरी यीशुए बड़े मैनन् मां ज़ोवं, “कि ज़ैखन तुस बिदलार डुबते पासेरां च़लती लातथ त तुस ज़ोतथ कि झ़ड़ी एजने बालीए ते तैन्ने भोते। ");
INSERT INTO bhd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ते दक्षिणेरे पासेरां हवा च़ली त तुस ज़ोतथ गर्मी भोरीए ते तैन्ने भोते। ");
INSERT INTO bhd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","हे पाखंडी लोकव, तुस धरती ते अम्बरेरो हाल हेरतां मौसमेरो अंदाज़ो केरनो ज़ानतथ, पन इन न ज़ैनी बटथ कि, परमेशर कुन चाते? ");
INSERT INTO bhd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“तुस एप्पू फैसलो केरा कि, तुश्शे लेइ कुन रोड़ूए। ");
INSERT INTO bhd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ज़ैखन तू लीडरे सेइं साथी हाकिमे कां गाथ त बत्ते मां तैस सेइं फैसलो की न केरस, एरू न भोए तै तीं हाकिमे कां ने ते हाकिम सिपाहीएरे हवाले केरे, ते तू कैद भोइ गास। ");
INSERT INTO bhd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","अवं तुसन सेइं ज़ोताईं कि ज़ां तगर तू पाई-पाई न देले त तांतगर तैट्ठां छुट्टी न सकेलो।” ");
INSERT INTO bhd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","तैस मौके किछ लोक तैड़ी आए, तैना यीशु सेइं तैन गलील इलाकेरे लोकां केरे बारे मां ज़ोने लगे, ज़ैन केरो खून, रोमेरे गवर्नर पिलातुसे मन्दरे मां जानवरां केरे बलिदाने सेइं साथी मलेवरो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","यीशुए तैन जुवाब दित्तो, “कुन तुस एन समझ़तथ कि तैन गलीलेरे लोकां केरो एत्रो बुरो हाल एल्हेरेलेइ भोवं, कि तैना बाकी गलीलेरे लोकन करां जादे पापी थिये? ");
INSERT INTO bhd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","अवं तुसन सेइं ज़ोताईं कि, अगर तुस भी पापन करां मन न फिराले त सब एन्च़रे नाश भोनेथ। ");
INSERT INTO bhd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","या कुन तैना अठारे ज़न्हे ज़ैन उन्ढो शीलोहेरो गुम्मट बिछ़ड़ोरो थियो, ते तैना सब तैस हैठ मेरि जे, ते तैना यरूशलेम नगरेरे होरि लोकन करां पापी थिये? ");
INSERT INTO bhd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","अवं तुसन सेइं सच़ ज़ोताईं, कि नईं बल्के अगर तुस भी पापन करां मन न फिराले त तुस सब एन्च़रे नाश भोइ गानेथ।” ");
INSERT INTO bhd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","तैसरां बाद यीशुए तैन अक मिसाल देइतां ज़ोवं, “केन्चे मैने अपनि बागी मां अक फ़ेगेरो बुट लोरो थियो, ते तैस बुट्टे पुड़ हर साल फल तोपने अव पन तैस फल न मैल्लो। ");
INSERT INTO bhd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","तैखन तैनी बागबने सेइं ज़ोवं, ‘हेर अवं ट्लाई सालां केरो देंतो इस फ़ेगेरे बुट्टे पुड़ फल लोरोईं तोपने, पन अज़ तगर एस पुड़ फल न मैल्लो एस केट्टी छ़ड एनी किजो रोड़ी ठार च़िकतां रखोरीए?’ ");
INSERT INTO bhd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","पन तैनी तैस जुवाब देइतां ज़ोवं, मीं निदतां एसेरे च़ेव्रे पासन खाद छडनियें। ");
INSERT INTO bhd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","अगर फिरी भी फल न लगो त फिरी केट्टी देनोए।” ");
INSERT INTO bhd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","एक्की आरामेरे दिहाड़े यीशु प्रार्थना घरे मां शिक्षा देने लोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","हेरा, तैड़ी अक कुआन्श थी ज़ैस अठारे सालां केरि देंती भूतेरे सैइयेरे वजाई सेइं कुबड़ी भोरी थी। तै सिधी न थी भोइ बटती। ");
INSERT INTO bhd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","यीशुए तै कुबड़ी कुआन्श लाई त एप्पू कां कुजाई ते ज़ोवं, “हे कुआन्श, तू अपनि तकलीफी करां छुटी जेई।” ");
INSERT INTO bhd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ते यीशुए तैस कुआन्शी पुड़ हथ रखे ते तै लूशी बेज़्झ़ोइं ते परमेशरेरी तारीफ़ केरने लगी। ");
INSERT INTO bhd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","पन प्रार्थना घरेरो प्रधान यीशु पुड़ नराज़ भोव कि, एनी ए कुआन्श, आरामेरे दिहाड़े किजो बज्झ़ाई ते ज़ोने लगो, “हफते मां शा दिहाड़े कम काज़ केरनेरे लेइ आन, ते तैन्ने मां कोई बज्झ़ावरो भी लोड़चे, ते आरामेरी दिहैड़ी न।” ");
INSERT INTO bhd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","प्रभु यीशुए तैस जुवाब दित्तो, “ए पाखंडी लोकव कुन तुस आरामेरी दिहाड़ी अपने दांत या गधे खोलतां तैन पानी पियाने न नेथ? ");
INSERT INTO bhd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","त कुन एन रोड़ू न भोवं कि ज़ै कुआन्श बेज़्झ़ोइ तै अब्राहमेरे खानदाने मरां ए, ज़ै अठारे सालां केरि देंती शैताने गुलैमी मां रखोरि थी त आरामेरे दिहाड़े ए कुआन्श छुटानी न थी?” ");
INSERT INTO bhd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ज़ैखन यीशुए एना गल्लां ज़ोई त तैसेरे खलाफ ज़ोने बाले सेब्भी केरि बेइज़ती भोइ, ते सारे लोक यीशुए ज़ैना महिमारां कम्मां अपने हथेइं कियोरां थियां खुशी मनाने लगे। ");
INSERT INTO bhd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","तैखन यीशु तैन सेइं ज़ोने लगो, “परमेशरेरू राज़ कौस चीज़री ज़ेरूए अवं केस सेइं ज़ोईं? ");
INSERT INTO bhd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","तन शेरीएरे बीज़ेरू ज़ेरू आए, ज़ैन एक्की मैने एन्तां अपनि बागी मां बेवं, पन ज़ैखन तैन बीज़ बेव गाते, तै उगतां सारे निक्के-निक्के बुट्टन केरां बड्डो भोते। ते अम्बरेरां च़ुड़ोल्लू भी तैस पुड़ बिशने लगां।” ");
INSERT INTO bhd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","यीशुए फिरी ज़ोवं, “अवं परमेशरेरे राज़्ज़ेरी मसाल केस सेइं देईं? ");
INSERT INTO bhd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","तैन खमीरेरू ज़ेरूए, ज़ैन केन्ची कुआन्शां आनू, ते हछे अट्टे मां मलाव ते सारू अट्टू खमीर बेनि ज़ोवं।” ");
INSERT INTO bhd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","यीशु अपने चेलन सेइं साथी यरूशलेम नगरे मांमेइं गांते बार नगरन मां ते ड्लोंव्वन मां शिक्षा देंतो च़लोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","केन्चे यीशु पुच़्छ़ू, “हे प्रभु कुन थोड़े ज़ेरे लोक हमेशारी सज़ाई करां बच़ेले?” यीशु तैन सेइं ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“परमेशरेरे राज़्ज़े मां सुन्कड़े दारेरां बत्तां गानेरी कोशिश केरा, किजोकि अवं तुसन सेइं ज़ोताईं कि बड़े लोक अन्तर गानेरी कोशिश केरेले पन न गेइ सकेले। ");
INSERT INTO bhd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ज़ैखन घरेरो मालिक एक्की बार दार बंद केरि छ़डते, त तुस बेइर खड़ खड़े दार गुड़काते, ते बिनती केरते राथ कि, ‘हे प्रभु इश्शे लेइ दार खोल्ल,’ ते तै तुसन जुवाब देते कि अवं तुसन न ज़ैनी तुस कौन आथ ते कोट्ठां ओरेथ? ");
INSERT INTO bhd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","तैखन तुस ज़ोले कि, ‘असेईं तीं सेइं साथी खोरी पियोरी नईं, ते तीं इश्शे अंगने मां असन शिक्षा नईं दित्तोरी।’ ");
INSERT INTO bhd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","पन तै तुसन सेइं ज़ोलो, ‘अवं तुसन न ज़ैनी तुस कौन आथ, ते कोट्ठां ओरेथ हे बेइमानव मीं करां दूर भोथ।’ ");
INSERT INTO bhd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ज़ैखन तुस अब्राहम, इसहाक ते याकूब ते सब नेबन परमेशरेरे राज़्ज़े मां सामने लाएले ते अपनो आप बेइरोवं कढते लाएले, त लेरां देते ते दंत च़ापते राले। ");
INSERT INTO bhd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","लोक पूर्बेरां ते पछमेरां ते उत्तर ते दक्षिणेरे देंते यानी दुनियारे सारे लोकन मरां लोक परमेशरेरे राज़्ज़ेरी धामी मां एइते लाएले। ");
INSERT INTO bhd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ते हेरा किछ एरेन कि ज़ैना पेइले आन, तैना पत्रोवं भोनेन ते ज़ैना पत्रोवं आन, तैना पेइले भोनेन।” ");
INSERT INTO bhd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","तैखने किछ फरीसी लोक यीशु कां आए ते ज़ोने लगे, “इट्ठां निस ते च़लो गा, किजोकि हेरोदेस तीं मारने चाते।” ");
INSERT INTO bhd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","पन यीशुए तैन ज़ोवं, तैस मैन्हु सेइं ज़ै लोई अरो ज़ेरो आए, गेइतां तैस सेइं ज़ोथ कि, “अवं अज़ ते कालां भूतां केरो सैयो कढने ते बिमारन बज़्झ़ांनेरू कम केरने लोरोईं ते एन कम ट्लेइ दिहाड़न मां मीं पूरू केरनूए। ");
INSERT INTO bhd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","बस्सा मीं अज़ ते कालां ते ट्लेईदी मीं सफर केरनूए, किजोकि नबी सिर्फ यरूशलेम नगरे मां मारे गाले। ");
INSERT INTO bhd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“हे यरूशलेमे नगरेरे लोकव, हे यरूशलेमे नगरेरे लोकव, तुसेईं केत्रे नबी कत्ल किये, ज़ैना बड़े पेइले तुसन कां आए, ते ज़ैना तुसन कां भेज़े तैन घोड़ेईं बेई, मीं केही फेरेईं सोचू कि तेरे बच्चन अकोट्ठे केरि ज़ेन्च़रे कुकड़ी अपने बच्चन अपने फंगन हैठ रखचे, पन तुस राज़ी न भोए। ");
INSERT INTO bhd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","हेरा तुश्शू घर तुश्शे लेइ छ़ड्डू गाते, ते अवं तुसन सेइं ज़ोताईं कि तुस मीं केन्ची तरीके भी न लेई सकेले, ज़ांतगर तुसन एन ज़ोनेरो मौको न एज्जेलो, धने तै ज़ै प्रभुएरे नंव्वे सेइं एइते।” ");
INSERT INTO bhd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","यीशु फिरी आरामेरे दिहाड़े एक्की फरीसेरे घरे रोट्टी खाने जेव त बड़े फरीसी लोक ध्याने सेइं लोरे थिये तकने, ताके तैसेरी कोई गलती ट्लान। ");
INSERT INTO bhd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","तैड़ी अक बिमार मैन्हु थियो ज़ेसेरी ज़ंघां पैखड़ी शोजती थी ते पस-पाक च़लती थी, तै तैड़ी बिशोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","यीशुए शास्त्री ते फरीसी लोकन पुच़्छ़ू, “कि आरामेरे दिहाड़े कानूनेरे मुताबिक कोई बज्झ़ानो जेइज़े की नईं?” ");
INSERT INTO bhd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","तैना च़ुप राए, तैखन यीशुए तैस बिमारे पुड़ अपनो हथ रख्खो ते तै बज्झ़ाव, ते घरजो भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ते फरीसन सेइं ज़ोवं, “तुसन मरां एरो कौने, ज़ेसेरू मट्ठू या दांत खड्डे मां खिरके ते आरामेरी दिहाड़ी भोए, ते तैस तैट्ठां बेइर न कढे?” ");
INSERT INTO bhd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ते तैन लोकेईं यीशुएरी गल्लां केरो जुवाब न देइ बटो। ");
INSERT INTO bhd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ज़ैखन यीशुए हेरू कि, ज़ैना लोक धाम ज़ोइतां रोट्टी खाने कुजोरेन केन्च़रे खास लोकां केरि ठार च़ुनतन, तैनी तैन अक मिसाल दित्ती। ");
INSERT INTO bhd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ज़ैखन तुसन कोई ड्लाएरी धामी मां कुजाए। ज़ै तैनेईं खास मैन्हु केरे लेइ ठार रख्खोरी भोए, तुस तैड़ी न बिश्शथ, भोइ सकते कि होरो कोई तुसन करां जादे खास मैन्हु कुजेवरो भोए। ");
INSERT INTO bhd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ते तुसन दुइये ज़न्न कुजाने बालो तुसन कां एइतां ज़ोए, ए ठार होरि केरे लेइए ते तुसन शरमेइतां खड़े उठनू पे, ते सेब्भन करां पत्र बिशनू पे। ");
INSERT INTO bhd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ज़ैखन भी कोई तुसन धाम ज़ोइतां कुजाए त सेब्भन करां पत्र बिश्शा, ताके ज़ैखन तेरो कुजाने बालो एज्जे ते ज़ोए, ‘दोस्त, अगर एइतां खास ठैरी बिश,’ त तैन लोकां केरे सामने तेरी केत्री बड़याई भोनीए। ");
INSERT INTO bhd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","किजोकि ज़ै कोई अपनो आप बड्डो बनालो त तै निकड़ो बनाव गालो ते ज़ै कोई अपनो आप निकड़ो बनालो त तै बड्डो बनाव गालो।” ");
INSERT INTO bhd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","फिरी यीशुए, तैस फरीसी मैन्हु सेइं ज़ैनी तै कुजोरो थियो ज़ोवं, “ज़ैखन तुस दिसेरी या रातरी धामी मां मैनन् कुजाथ, त अपने दोस्तन या ढ्लान रिशतेदारन या अपने अमीर पड़ोसन न कुजेइयथ। किजोकि तैना भी तीं कुजेइतां तेरू एवसान मुकेइ छ़डेले। ");
INSERT INTO bhd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","बल्के ज़ैखन तुस धाम देथ त टोंटे, कानो, गरीब गुरबे, परदेशी कुजेइयथ। ");
INSERT INTO bhd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ते परमेशर तुसन बरकत देलो, किजोकि तैन कां किछ भी नईं ज़ैस सेइं तैना तुश्शू एवसान मुकेइ बटन, ते तेरे एस एवसानेरो फल धेर्मी लोकन ज़ींते भोने सेइं साथी फैसलेरी दिहैड़ी मैलेलो।” ");
INSERT INTO bhd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ट्लाहनन् मरां एक्के एन गल्लां शुन्तां यीशु सेइं ज़ोवं, “परमेशरेरे राज़्ज़ेरी धामी मां खाने बालो धन भोलो।” ");
INSERT INTO bhd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","यीशुए तैस जुवाब दित्तो, “केन्चे मैने अक बड़ी धाम दित्ती ते बड़े लोक कुजाए। ");
INSERT INTO bhd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ज़ैखन रोट्टी खानेरो वक्त अव त तैनी अपनो नौकर भेज़ो कि तैन लोकन ज़ैन जो ड्लाएरी धाम बनोरी थी, ‘एज्जा, रोट्टी बनोरोए।’ ");
INSERT INTO bhd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","पन धामी बालेईं सेब्भेईं मिलतां एतराज़ कियो ते पेइले मैने ज़ोवं, ‘मीं ऊडार घिन्नेरू आए, मीं तैस हेरने गानूए ते अवं तीं कां मिनत केरतां कि मीं राने दे।’ ");
INSERT INTO bhd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","त होरो ज़ोने लगो, ‘मीं पंच़ हल्लां दांत घिन्नोरेन ते अवं तैन लाने परखने च़लोरोईं। अवं तीं कां मिनत केरतां कि मीं राने दे।’ ");
INSERT INTO bhd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","अक होरो मैन्हु लगो ज़ोने, ‘मीं ड्ला बनावरोए, एल्हेरेलेइ अवं न एज्जी बेटि।’ ");
INSERT INTO bhd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","तैखन नौकरे वापस एइतां एन सैरी गल्लां अपने मालिके शुनेईं, त मालिके बड़ी सरक अई, तैनी अपने नौकरे जो ज़ोवं, ‘इस नगर मां गा ते लेंगे लुथे, गरीब गुरबे नग्गे, नियन्ने भत्ते, टोंटे, कानो इरां कुजा।’ ");
INSERT INTO bhd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","नौकरे ज़ोवं, ‘हे मालिक ज़ैन तीं ज़ोवं, मीं तैन्ने कमाव, पन फिरी भी ठार खाली आए।’ ");
INSERT INTO bhd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","मालिके नौकरे सेइं ज़ोवं, ‘बत्तारे आसे पासे ऊडारन मांमेइं गा ते लोक मजबूर केरतां आन, ताके मेरू घर भेरतां भोए। ");
INSERT INTO bhd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","किजोकि अवं तीं सेइं ज़ोताईं कि ज़ैन लोक पेइले कुजेवरे थिये, यानी खास ठैरारे लेइ कुजेवरे थिये, तैन मरां कोई भी मेरी धामी मां रोट्टी न खेइ सकेलो।’ ” ");
INSERT INTO bhd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","बड़े लोक यीशु पत्ती च़लोरे थिये, यीशुए पत्रोवं तक्कू ते ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“अगर कोई मीं कां एज्जे, ते अपने अम्मा बाजी, कुआन्श, बच्चन, ढ्लान ते बेइन्न ते अपने जानी करां जादे प्यार मीं सेइं न केरे त तै मेरो चेलो न भोइ सके। ");
INSERT INTO bhd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ते ज़ै कोई मेरो चेलो भोनेरी वजाई सेइं दुःख झ़ैल्लनेरे लेइ त कने मरनेरे लेइ तियार नईं, त तै मेरो चेलो न भोइसखे। ");
INSERT INTO bhd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","तुसन मरां एरो कोई भोए, ज़ै गुम्मट बनानू चाए, ते पेइले बिश्तां हिसाब न केरे, कि पूरो केरनेरे लेइ मीं कां खर्च़ो आए कि नईं। ");
INSERT INTO bhd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","कधे एरू न भोए कि खाइ कटनेरे बाद तैस बनेइ न सके ते तकने बाले हसते रान। ");
INSERT INTO bhd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘ते ज़ोन एनी मैने बनानू त शुरू कियूं, पन बनेइ न बटो।’ ");
INSERT INTO bhd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","या फर्ज़ केरा कि कोई राज़ो होरि राज़े सेइं लड़ाई केरनेरे लेइ सोची राहोरो भोए त कुन पेइले एन न सोचे कि 10000 फौजी जवानन् सेइं अवं 20000 फौजी जवावन सेइं तैसेरो मुकाबलो केरि सकतां कि नईं? ");
INSERT INTO bhd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","अगर तै मुकाबलो न केरि सखे त तैस फौजी सेइं ज़ै दूरे, मैन्हु भेज़तां तैस सेइं सल्लारी मिनत केरेलो। ");
INSERT INTO bhd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","एन्च़रे अगर ज़ै कोई तुसन मरां अपनू सब किछ न छ़डे त मेरो चेलो न भोइसखे। ");
INSERT INTO bhd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“लून रोड़ी चीज़े, पन अगर लूनेरो लूनार मुकी गाए त तैन कोस सेइं लूने बनाव गालू? ");
INSERT INTO bhd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","लोक तैस बेइरोवं शेरी देले, ज़ै कोई समझ़नू चाते, तै ध्याने सेइं शुने ते समझ़े।” ");
INSERT INTO bhd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","बड़े लोक धड़त घिन्ने बाले ते पापी लोक यीशु कां एइतां तैसेरी गल्लां शुन्ने लोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","फरीसी ते शास्त्री लोक शिकयत केरतां ज़ोने लगे, “कि ए मैन्हु पापी लोकन सेइं तालमेल रखते, ते तैन सेइं साथी खाते पीते।” ");
INSERT INTO bhd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","यीशुए तैन अक मिसाल देइतां ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“तुसन मां एरो कोई आए ज़ैस कां 100 भैड्डां भोन ते तैन मरां अक हेरोए ते 99 भैड्डां तैड़ी ज़ेरे जंगले मां छ़ेडतां तोपने न गाए, ज़ां तगर तैस मैल्लोरी नईं? ");
INSERT INTO bhd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ते ज़ैखन ते तैस मैल्ले त खुशी सेइं कंधे पुड़ छ़ुइतां आने। ");
INSERT INTO bhd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ते अपने घरे एइतां अपने दोस्तन ते भियालन कुजेइतां ज़ोए कि, ‘अज़ मीं सेइं साथी खुशी मनाथ, किजोकि अज़ मेरी हेरोरि भैड मैलोरीए।’ ");
INSERT INTO bhd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","अवं तुसन सेइं ज़ोताईं कि, एन्च़रे 99 धर्मी ज़ैनेईं पेइले अपने पापन करां मनफिरावरो तैन करां जादे ज़ैखन अक पापी, पापन करां मन फिराते स्वर्गे मां बड़ी खुशी बनाई गाचे। ");
INSERT INTO bhd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“कुन एरी भी कोई कुआन्श भोली ज़ैस कां चैंदरे दश सिके भोन ते अक हेरोए ते तै दीयो बैलतां घरे अन्तर धूनी न दे, ते ज़ां तगर मैल्ले न तांतगर तोप्ती न राए? ");
INSERT INTO bhd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ते तोपनेरे बाद अपने पड़ोसन ते अपनि सेहेलन कुजेइतां एन न ज़ोए कि, ‘एज्जा मीं सेइं साथी खुशी मनाथ किजोकि अज़ मेरो हेरोरो सिको मैलोरोए।’ ");
INSERT INTO bhd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","बस्सा, अवं तुसन सेइं ज़ोताईं कि एक्की पैपेरे, पापन करां मन फिराने सेइं परमेशरेरे स्वर्गदूतां केरे सामने बड़ी खुशी मनाई गाचे।” ");
INSERT INTO bhd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","यीशु फिरी होरि मिसाल दित्ती, “केन्ची मैनेरां दूई मट्ठां थियां। ");
INSERT INTO bhd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","तैन मरां निकड़े मट्ठे अपने बव्वे सेइं ज़ोवं, ‘हे बाजी जेइदाती मां ज़ै मेरो हिस्सो बनते तै मीं दे।’ तैनी दुइने हिस्सो बेंटतां दित्तो। ");
INSERT INTO bhd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","थोड़े दिहैड़ना पत्ती निकड़े मट्ठे अपनू सब किछ जेइदात होरि मुलखे जो नी, ते बुरे कम्मन मां लुट्टाई। ");
INSERT INTO bhd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ज़ैखन तैनी सब किछ मुकेइ छ़ड्डू त तैस मुलखे मां बड़ो काल पेव, ते तैस कां खाने जो किछ न राऊं। ");
INSERT INTO bhd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","तैखन तै तैस मुलखेरे एक्की रानेबाले कां कम तोपने पुज़ो। तैनी तै अपने ऊडारन मां सूर च़ारनेरे कम्मे लाव। ");
INSERT INTO bhd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","तैड़ी तै बड़ो ढ्लुखोरो थियो, तै तैन खाने मां राज़ी थियो ज़ैन सूर खाते थिये, किजोकि तैस केन्चे किछ खाने जो न दित्तू। ");
INSERT INTO bhd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","तैखन तैस समझ़ आई ते ज़ोने लगो, ‘मेरे बाजी केरे मज़दूर रेज़तां रोट्टी खातन, पन अवं इड़ी फाके लोरोईं मरने। ");
INSERT INTO bhd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","मीं खड़े उठतां अपने बाजी कां गानूए ते तैस सेइं ज़ोनूए हे बाजी अवं परमेशरेरी नज़री मां ते तुश्शी नज़री मां पापी आईं। ");
INSERT INTO bhd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","हुनी अवं एस काबल त नईं, कि तुश्शू मट्ठू भोइ, पन मीं भी अपने मज़दूर मां रखा।’” ");
INSERT INTO bhd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“बस्सा, तैनी तै मुलख शारो ते वापस अपने बाजी कां च़लो, ते हेजू तै बड़े दूरे थियो, ते तैसेरे बाजे तै लाव ते तैसेरे बाजी तैस पुड़ बड़ो तरस अव, ते तै दौवड़तो अपने मट्ठे कां जेव, ते तैन गले लाव ते बड़ो खुशी भोव। ");
INSERT INTO bhd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","मट्ठे अपने बाजी सेइं ज़ोवं, ‘ए बाजी अवं परमेशरेरी नज़री मां ते तुश्शी नज़री मां पापी आईं। हुनी अवं एस काबल त नईं कि, अपने आपे जो तुश्शू मट्ठू ज़ोई।’ ");
INSERT INTO bhd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","पन बाजे अपने नौकरन सेइं ज़ोवं, ‘लूश केरा ते सेब्भन करां पेइले रोड़ां लिगड़ां एस मट्ठे लुवाथ, ते एसेरे हथ्थे आंवठी ते पावन बूट लुवाथ। ");
INSERT INTO bhd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ते अक जानवर मारो ते बड़ी धाम बनेइतां बड़ी खुशी मनाई। ");
INSERT INTO bhd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","किजोकि मेरू मट्ठू ज़ैन ज़ेन्च़रे मेरि जोरू थियूं, अज़ ज़ींतू भोरूए, हेरोरू थियो, ते मैलोरूए।’ बस्सा तैना खुशी मनाने लगे।” ");
INSERT INTO bhd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“तेइस बड़ू मट्ठू ज़ैन ऊडारे मां कम केरतां घरजो ओरू थियूं ज़ैखन तै घरे नेड़े पुज़ो त तैनी गीतां केरि त नच़नेरी शौर शुनी। ");
INSERT INTO bhd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","तैनी अक नौकर कुजाव ते तैस पुच़्छ़ू, ‘ए शौर कीजेई लोरी भोने?’ ");
INSERT INTO bhd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","नौकरे तैस सेइं ज़ोवं, ‘तेरो निकड़ो ढ्ला वापस घरे ओरोए ते तेरे बाजे अक जानवर मैरतां धाम बनोरीए, किजोकि तै ठीक ठाक घरे पुज़ोरोए।’ ");
INSERT INTO bhd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","पन तैस मैनेरू बड़ू मट्ठू नाराज़ भोवं ते अन्तर घरे मां भी न लगो एजने, पन तैसेरो बाजी बेइर अव, ते तैस मिठांनेरी कोशिश की, कि घरे अन्तर एज्जे। ");
INSERT INTO bhd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","बडे मट्ठे अपने बाजी सेइं ज़ोवं, ‘हेरा अवं केत्रे सालां केरि देंती तुश्शी सेवा केरने लोरोईं, ते कधे तुश्शो हुक्म नईं मोड़ोरो ते तुसेईं कधे कोई छ़ेड़ू नईं दित्तोरोए कि अवं भी अपने दोस्तन सेइं खुशी मनेईं। ");
INSERT INTO bhd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","पन ज़ैखन तुश्शू निकड़ू मट्ठू अपनू सब किछ लुटेइतां वापस अव, त तैसेरेलेइ जानवर मारो ते अक बड़ी धाम बनाई।’ ");
INSERT INTO bhd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","तैसेरो बाजी ज़ोने लगो, ‘मेरा मट्ठां तू त मीं कां आस ते ज़ैन किछ मीं कांए तैन सब तेरूए। ");
INSERT INTO bhd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","पन असेईं खुशी मनानी ज़रूरी थी किजोकि तेरो ए निकड़ो ढ्ला ज़ै ज़ेन्च़रे मेरि जोरो थियो, अज़ ज़ींतो भोरोए, हेरोरो थियो ते अज़ मैलोरोए।’” ");
INSERT INTO bhd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","फिरी यीशुए अपने चेलन अक होरि मिसाल दित्ती कि, “केन्ची अमीरेरो अक मुन्शी थियो, लोकेईं तैसेरी शकैइत तैसेरे मालिके सेइं लाई कि, ए तेरो माल बरबाद केरने लोरोए। ");
INSERT INTO bhd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","मालिके तै कुजाव ते ज़ोवं, ‘एन कुने ज़ैन अवं तेरे बारे मां शुन्ने लोरोईं? सारो हिसाब-किताबे मां अज़ेरां बाद तू मेरो मुन्शी नईं रालो।’ ");
INSERT INTO bhd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","मुन्शे अपने दिले मां सोचू मेरो मालिक मेरे कम्मे करां मीं कढने लोरोए, मीं मज़दूरी भी न केरोए ते शर्मारेमारे भीख भी न मैग्गोए। ");
INSERT INTO bhd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","‘अवं ज़ानताईं कि, मीं कुन केरनूए इट्ठां कढनेरे बाद मीं लोक खुशी सेइं अपने घरे मां कबूल केरतन।’ ");
INSERT INTO bhd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","बस्सा तैनी अपने मालिकेरो अक कर्ज़दार तोपते, पेइले एक्की पुच़्छ़ू तीं कां मेरे मालिकेरे केत्रे रुपेइयेन? ");
INSERT INTO bhd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","तैनी जुवाब दित्तो, ज़ैतूनेरे तेलेरे 100 पींपां केरि कीमते, तैनी ज़ोवं इना रां तेरां काकलां, ते बिश्तां 50 पींपे बना। ");
INSERT INTO bhd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","फिरी तैनी मुन्शे होरि सेइं ज़ोवं, ‘तीं कां केत्रो कर्ज़ोए?’ तैनी ज़ोवं, ‘गेहुं केरि 100 बोरी,’ तैनी ज़ोवं, ‘यां काकलां ते बिश्तां 80 लिखी।’ ");
INSERT INTO bhd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","मालिके तैस बेईमान मुन्शेरी तारीफ़ की, एल्हेरेलेइ कि तैनी बेड़ि च़लैकी सेइं कम कियेरू थियूं। किजोकि इस दुनियारे लोक अपने लोकन सेइं सौदो केरनो परमेशरेरे लोकन करां बड़े हुशारी सेइं केरतन। ");
INSERT INTO bhd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","अवं तुसन सेइं ज़ोताईं कि दौलत खर्च़ केरतां इस दुनियारे लोकन दोस्त बनाथ, तुसन मरनेरां बाद हमेशारू घर मैलनूए। ");
INSERT INTO bhd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ज़ै थोड़े ज़ेरे मां इमानदेरी सेइं रहते ते हछे मां भी ईमानदार रहते। ज़ै थोड़े करां थोड़े मां भी बेइमाने तै हछ्छे मां भी बेइमाने। ");
INSERT INTO bhd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","बस्सा अगर तुस बेइमानेरे धन दौलती मां ईमानदार न भोए, त अपनि सच़्च़ी दौलत ज़ै स्वर्गे मां आए, कौन तुश्शे हवाले केरेलो? ");
INSERT INTO bhd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","अगर तुसेईं होरि केरे माले मां ईमानदार न भोए, त ज़ै तुश्शो अपनो माले कौन तुसन देलो? ");
INSERT INTO bhd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","कोई नौकर दूई मालिकां केरि सेवा एक्की वक्ते मां न केरि सके। न त एक्की सेइं दुश्मनी केरेलो ते होरि सेइं प्यार केरेलो, या एक्केरो बेनतां रालो त होरि न सुखालो। तुस परमेशरेरी ते दौलतरी, दुइयां केरि सेवा न केरि सकतथ।” ");
INSERT INTO bhd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","तैखन फरीसी लोक ज़ैना दौलतरे लालच़ी थिये, एन गल्लां शुन्तां यीशुएरी हासी बनाने लगे। ");
INSERT INTO bhd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","यीशु तैन जो ज़ोवं, “तुस तैना आथ ज़ैना लोकन मां अपनो आप बड़ो धर्मी हिरातन। पन परमेशर तुश्शे दिलेरी हालत ज़ानते किजोकि ज़ै चीज़ लोकां केरे लेइ बड़ी बड्डीए ते तै परमेशरेरी नज़री मां भिट्टी आए।” ");
INSERT INTO bhd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“मूसेरे कानून ते नेबी केरि गल्लां यूहन्ना बपतिस्मो देनेबाले तगर रेइ, ते फिरी परमेशरेरे राज़्ज़ेरी खुशखबरी शुनाने लगे ते हर कोई तैस मां दाखल भोनेरी बड़ी कोशिश केरने लगोरेन। ");
INSERT INTO bhd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","पन धरती अम्बर टेली गालू पन परमेशरेरे कानूने मरां अक बिंदी भी न मिटेली। ");
INSERT INTO bhd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ज़ै कोई अपनि कुआन्श शैरतां होरि सेइं ड्ला बनाते तै तैस सेइं बदमाशी केरते ते ज़ै शैरोरी कुआन्शी सेइं ड्ला बनाते तै भी बदमाशी केरते।” ");
INSERT INTO bhd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“अक मैन्हु बड़ो अमीर थियो, ते तै बैंगनी लिगड़ां लातो थियो, ते बड़ां माघो लिगड़ां लातो थियो। ते रोज़ एश अशरती मां मसत रातो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","अक बड़ो गरीब मैन्हु ज़ेसेरू नवं लाज़र थियूं, तैसेरे दारे कां एन्तां रखोरो थियो, तैसेरी सारी जान खेराड़ेइं सेइं भेरतां थी। ");
INSERT INTO bhd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","तै चातो थियो, कि अमीर मैनेरे टुकेइं सेइं अपनू पेट भेरि, पन तैड़ी कुतरां एइतां थियां ते तैना तैसरां खेरड़ां भी च़टतां थियां। ");
INSERT INTO bhd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","फिरी एरू भोवं कि तै गरीब लाज़र मेरि जेव स्वर्गदूतेईं तै छ़ुइतां अब्राहमे कां पुज़व, ते अमीर मैन्हु भी मेरि जेव ते तै दैब्बी छ़ड्डो। ");
INSERT INTO bhd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ज़ैखन तैनी पातालेरे दुखे मां अपनि एछ़्छ़ी घैड़ी? त दूरेरां तैनी अब्राहम ते तैस कां नेड़े लाज़र लाव। ");
INSERT INTO bhd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","तै चिन्डां मैरतां ज़ोने लगो, ‘ए बाजी अब्राहम मीं पुड़ दया केर, एस लाज़रे भेज़ ते ए अपनि अंग्लोई पैनी सेइं सेलतां मेरे ज़िभी पुड़ लाए, किजोकि अवं अग्गी मां तड़फने लोरोईं।’ ");
INSERT INTO bhd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","पन अब्राहमे ज़ोवं, ‘मट्ठां याद केर तीं त अपनि जवेंनी मां सब रोड़ी चीज़ां मैल्ली ते इस लाज़रे सिर्फ बुरी चीज़ां मैल्ली, पन ए हुन्ना इड़ी आरामे मांए ते तू तकलीफी मां आस। ");
INSERT INTO bhd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ते एन गल्लां केरे अलावा इश्शे ते तुश्शे मझ़ाटे अक बड्डी खाईए, ताके ज़ै कोई पार गानू चाए न गेइ सखे ते ज़ै वार एजनू चाए न एज्जी सखे।’ ");
INSERT INTO bhd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","तैनी मैने ज़ोवं, ए बाजी अब्राहम, अवं ज़ोवले हथ केरतां ज़ोताईं कि, तू लाज़रे दुनियाई मां मेरे बाजी केरे घरे भेज़। ");
INSERT INTO bhd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","तैड़ी मेरे पंच़ ढ्ला आन ते तै तैन हदायत दे कि, एरू न भोए ते तैना भी इस अग्गी मां एजन। ");
INSERT INTO bhd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","पन अब्राहमे तैस ज़ोवं, ‘तैन केरि हदायतरे लेइ तैन कां मूसेरो कानूने ते नेबी केरि किताबां त आन तैना तैन शुनन् ते मनन्।’ ");
INSERT INTO bhd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","तैनी मैने ज़ोवं, ‘नईं ए बाजी अब्राहम अगर कोई मुड़दन मरां ज़ींतो भोइतां गाए त तैना ज़रूर पापन करां मन फिराले।’ ");
INSERT INTO bhd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","पन अब्राहम तैस सेइं ज़ोवं, ‘अगर तैना मूसेरी ते नेबी केरि न शुनी ते अगर कोई मुड़दन मरां ज़ींतो भोइतां गाए त तैना तैसेरू भी याकीन न केरेले।’” ");
INSERT INTO bhd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","फिरी तैनी अपने चेलन सेइं ज़ोवं, “एन न भोइसखे कि लोकन ठोकर न लग्गे, पन अफ़सोस तैस मैन्हु पुड़ ज़ै होरि केरे लेइ ठोकर बनते। ");
INSERT INTO bhd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","तैसेरेलेइ त एन्ने रोड़ू थियूं, कि ढ्लाटेरो ढ्लेइटोल तैसेरे गल्ले उन्ढो छ़ेडतां ते समुन्द्रे मां शैरतां छ़ड्डो गाथो, ताके तै होरि जो ज़ैना विश्वासे मां कमज़ोरन ठोकर न बने। ");
INSERT INTO bhd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","बस्सा हुशार राथ तुस कुन केरतथ, अगर तुश्शो विश्वासी ढ्ला पाप केरते त तैस समझ़ाथ ते अगर तै पापन करां मन फिराए त तैस माफ़ केरा। ");
INSERT INTO bhd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","अगर तै एक्की दिहैड़ी मां तेरो सत्ते बार तेरो पाप केरे त अगर तै सत्ते फेरेईं तीं कां एइतां माफ़ी मग्गे त तू सत्ते फेरेईं तैस माफ़ केरां।” ");
INSERT INTO bhd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","प्रेरितेईं प्रभु सेइं ज़ोवं, “हे प्रभु, इश्शी मद्दत केर कि अस होरे भी मज़बूती सेइं विश्वास केरम।” ");
INSERT INTO bhd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","प्रभु यीशुए ज़ोवं, “अगर तुश्शो विश्वास सिवलारे गलेवे बराबर भी भोलो त तुस इस तूतेरे बुटे जो ज़ोई सकतथ इट्ठां उखड़ ते समुन्द्रे मां लग त तै तुश्शो हुक्म मनेलो। ");
INSERT INTO bhd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“तुसन मां एरो कौन आए, ज़ेसेरो नौकर ऊडारां बेंतो भोए या गोरू च़ारतो भोए ते ज़ैखन तै ऊडारे मरां घरे एज्जे त तैसेरो मालिक तैस ज़ोए कि, ‘लूशी बिश्श ते रोट्टी खा।’ ");
INSERT INTO bhd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","या एन न ज़ोए कि मेरी रोट्टी तियार केरथ ते ज़ां तगर अवं खेइ पीं नन्ना ते ज़ां तगर अवं रेज़्ज़ी नन्ना तू मेरी सेवा केरतो राए, तैल्ला पत्ती तू भी खा? ");
INSERT INTO bhd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","कुन तै एल्हेरेलेइ नौकरेरू अहसान केरेलो कि, तीं तैन कियूं ज़ैन तीं केरनेरे लेइ ज़ोवरू थियूं? ");
INSERT INTO bhd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","एन्च़रे ज़ैखन तुस एन सब केरेले ज़ैस केरनेरो तुसन हुक्म दित्तोरो थियो, त ज़ोथ कि, ‘असां निकम्मे नौकर आम? असेईं तैन्ने कियूं ज़ैन केरनू चाते थिये।’” ");
INSERT INTO bhd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","एक्की फेरे यीशु त कने तैसेरे चेले यरूशलेम नगरेरे पासे च़लोरे थिये। तैना सामरिया ते गलीले इलाके मांमेइं च़लोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ज़ैखन तैना एक्की ड्लव्वें मां पुज़ने बाले थिये त तैड़ी दश कोढ़ी मैल्ले ज़ैना दूर खेड़ोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","तैनेईं बड़े ज़ोरे सेइं ज़ोवं, “हे यीशु, हे प्रभु, असन पुड़ दया केर।” ");
INSERT INTO bhd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","यीशुए तैन लेइतां ज़ोवं, “यरूशलेम नगरेरे मन्दरे मां गाथ ते अपनो आप याजकन हिराथ, ते सच़्च़े एरू भोवं कि गाते बार बत्तां तैन केरू कोढ़ साफ भोइ जेवं।” ");
INSERT INTO bhd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","पन तैन मरां अक कोढ़ी अपनू कोढ़ हेरतां कि, तैसेरू कोढ़ साफ भोरोए खुशी भोइतां बड़े ज़ोरे सेइं परमेशरेरी तारीफ़ केरतो वापस यीशु कां अव ");
INSERT INTO bhd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ते यीशुएरे पावन पुड़ दोग्ग रेखतां शुक्र लगो केरने। ए मैन्हु सामरी थियो। ");
INSERT INTO bhd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","यीशुए तैस पुच़्छ़ू, “कुन तैन दश कोढ़ी केरू कोढ़ साफ नईं भोवरू? फिरी तैना कोरां जे? ");
INSERT INTO bhd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","कुन एस गैर यहूदी मैनेरे अलावा तैन होरन एत्री हिम्मत न अई, कि गेइतां परमेशरेरी महिमा केरम?” ");
INSERT INTO bhd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","तैखन यीशुए तैस ज़ोवं, “खड़ो उठ ते च़लो गा तीं मीं पुड़ विश्वास कियो तांए तू बेज़्झ़ोरोस।” ");
INSERT INTO bhd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","फरीसी लोक यीशु पुच्छ़ने लगे, “कि परमेशरेरू राज़ केइस एजनूए? यीशुए तैन जुवाब दित्तो कि परमेशरेरू राज़ एरू नईं कि कोई तैस लेई बटे। ");
INSERT INTO bhd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ते ज़ोन कि हेरा इड़ी या उड़ीए एन्च़रे नईं बल्के परमेशरेरू राज़ तुश्शे मझ़ाटे।” ");
INSERT INTO bhd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","यीशुए अपने चेलन सेइं ज़ोवं, “तै दिहाड़ी भी एजनीए कि, ज़ेइस तुस परमेशरेरी दिहैड़न मरां अक दिहाड़ी हेरनेरी इच्छा रखेले, ज़ेइस मैनेरू मट्ठे यानी अवं वापस एजनोईं, पन तुस न लेई बटेले। ");
INSERT INTO bhd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","लोक तुसन सेइं ज़ोले कि, ‘हेरा, मसीह इड़ीए,’ या ‘उड़ीए या हेरा तै इड़ीए!’ पन तुस तैरां न गेइयथ ते न तैन पत्ती न च़ेलथ। ");
INSERT INTO bhd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","किजोकि ज़ेन्च़रे बिजली अम्बरे मरां चेमकतां एक्की पासेरां होरि पासे च़ली गाचे, तेन्च़रे मैनेरू मट्ठू यानी अवं तैस दिहैड़ी बांदो भोलो। ");
INSERT INTO bhd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","पन ज़रूरीए कि तै पेइले दुःख झ़ैल्ले ते इस ज़मानेरे लोक तैस घटिया समझ़न। ");
INSERT INTO bhd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ते ज़ेरू इश्शे पूर्वज नूहेरे ज़माने मां भोरू थियूं, तेरहु मैनेरे मट्ठेरे ज़माने मां भी भोलू। ");
INSERT INTO bhd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","तेइस भी लोक खाते पीते थिये ते ड्ला भोंते रहते थिये। ते ज़ां तगर नूह किश्ती मां न थियो जोरो तांतगर सब किछ भोतू राव। ते फिरी तूफान अव ते सब किछ खतम भोइ जेवं। ");
INSERT INTO bhd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ते ज़ेरू इश्शे पूर्वज लूतेरे ज़माने मां भोरू थियूं, कि लोक खाते पीते थिये बुपार केरते, बागां लाते ते घरां बनाने मां मघन थिये। ");
INSERT INTO bhd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","पन ज़ैस दिहैड़ी लूत सदोम नगरे मरां बेइर निस्सो त पत्रोवं अम्बरेरां गंधकेरी अग बैखतां सब किछ खतम केरि छ़डू। ");
INSERT INTO bhd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ते मैनेरे मट्ठू यानी मेरू वापस एजनू भी अचानक भोलू। ");
INSERT INTO bhd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“तैस दिहैड़ी ज़ै लाए पुड़ भोलो त तैसेरो माल सबाब अगर घरे मां भोलो त तैस नेने तै अन्तर न एज्जे, ते ज़ै ऊडारे मां भोलो तै भी वापस न गाए। ");
INSERT INTO bhd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लूतेरी कुआन्शी सेइं कुन भोवं याद रख्खा। ");
INSERT INTO bhd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ज़ै अपनि जान बच़ांनेरी कोशिश केरेलो तै तैस गुवालो, ते ज़ै तैस गुवालो तै तैस बच़ालो। ");
INSERT INTO bhd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","अवं तुसन सेइं ज़ोताईं कि तैस राती दूई मैन्हु एक्की खट्टी पुड़ झ़ुल्लोरे भोले, ते अक नीयो गालो, ते दुइयोवं तैड़ी रालो। ");
INSERT INTO bhd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","दूई कुआन्शां हिट्लाट पइती भोली त अक नेनीए ते अक तैड़ी छ़डनियें। ");
INSERT INTO bhd_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","दूई मैन्हु ऊडारे मां भोले त अक नेनोए ते अक तैड़ी छ़डनोए।” ");
INSERT INTO bhd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","एन शुन्तां तैनेईं यीशुए पुच़्छ़ू, “हे प्रभु असन सेइं ज़ो, एन कोड़ि भोलू?” यीशुए तैन ज़ोवं, “ज़ैड़ी ज़िग्ग भोते तैड़ी इल्लां जम्हां भोइचन।” ");
INSERT INTO bhd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","यीशु अपने चेलन अक मिसाल देइतां ज़ोवं, कि हिम्मत हारनेरे बगैर प्रार्थना केरती रावरी लोड़े। ");
INSERT INTO bhd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“एक्की नगर मां अक हाकिम रातो थियो। तै न परमेशरे करां डरतो थियो, ते न कोन्ची मैनेरी परवाह केरतो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","तैस नगर मां अक विधवा कुआन्श रहती थी ज़ै तैस हाकिमे कां एइती रहती थी, ते तैस कां मिनत केरती रहती थी कि, मेरो इन्साफ केरतां मीं मेरे दुश्मने करां छुटा। ");
INSERT INTO bhd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","पेइले त तैनी एत्रो खियाल न कियो पन ज़ैखन ए हिसाब च़लतो राव, त तैनी अपने मने मां ज़ोवं, ‘अवं न परमेशरे करां डेरि ते न मैनेरी परवाह केरि। ");
INSERT INTO bhd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","पन ए विधवा कुआन्श मीं परेशान केरती राचे, एल्हेरेलेइ अवं एसारो इन्साफ केरेलो, नईं त एसां अवं बड़ो ज़लील केरनोईं।’” ");
INSERT INTO bhd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","तैखन प्रभु यीशुए ज़ोवं, “शुना ए बेईमान हाकिम कुन लोरोए ज़ोने। ");
INSERT INTO bhd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","बस कुन परमेशर अपने च़ुनोरे लोकां केरो फैसलो केरने मां च़िर लालो, ज़ैना रात दिहैड़ी फरयाद केरते रातन? ");
INSERT INTO bhd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","अवं ज़ोताईं, कि तै तैन केरो फैसलो केरेलो ते लूशी केरेलो। पन फिरी भी ज़ेइस मैनेरू मट्ठू यानी अवं एज्जेलो त कुन लोक मीं पुड़ हेजू तगर विश्वास केरते भोलो?” ");
INSERT INTO bhd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","यीशुए किछ एरे लोकन अक मिसाल दित्ती कि, ज़ैन अपनो आपे बड़ो धर्मी समझ़ते थिये ते होरन किछ न थिये बुझ़ते। ");
INSERT INTO bhd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“दूई मैन्हु प्रार्थना केरने मन्दरे मां जे अक फरीसी मैन्हु थियो, ते होरो धड़त (टेकस) घिन्ने बालो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","फरीसी मैन्हु खड़ो भोइतां प्रार्थना केरने ते अपने बारे मां सोचने लगो, कि हे परमेशर अवं तेरू शुक्र केरताईं, अवं होरि मैन्हु केरो ज़ेरो नईं ज़ैना डैकू, अधर्मी, बदमाशी केरनेबाले, ते इस धड़त नेने बालेरो ज़ेरोईं नईं, ");
INSERT INTO bhd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","अवं हफते मां दूई बार बरत रखताईं, ते अपनि कमैईयरो दशोवं हिस्सो तींजो देताईं। ");
INSERT INTO bhd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“पन तै धड़त नेनेबालो ज़ै दूर खड़खड़ो थियो, तैनी एत्रू भी न केरि बटु, कि अम्बरेरे पासे तक्के बल्के छाती पिट्टतां ज़ोने लगो, ‘हे परमेशर मीं पैपी पुड़ दया केरतां माफ़ केर!’ ");
INSERT INTO bhd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","अवं तुसन सेइं सच़ ज़ोताईं, ए धड़न नेनेबाले मैन्हु तैस फरीसी मैन्हु करां धर्मी निस्तां अपने घरजो जेव। किजोकि ज़ै कोई अपनो आप बड्डो बनालो तै निकड़ो बनाव गालो ते ज़ै अपनो आप निकड़ो बनालो तै बड्डो बनाव गालो।” ");
INSERT INTO bhd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","फिरी किछ लोक निक्के बच्चन यीशु कां आन्ने लगे ताके यीशु तैन पुड़ हथ रेखतां बरकत दे। चेलेईं तैन लाव त तैन धमकाए ते ठाकू। ");
INSERT INTO bhd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","पन यीशुए बच्चे एप्पू कां कुजाए ते चेलन सेइं ज़ोवं, “बच्चन मीं कां एजने देथ एन न ठाका, किजोकि परमेशरेरू राज़ एरां ज़ेरां केरूए। ");
INSERT INTO bhd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","अवं तुसन सेइं सच़ ज़ोताईं, ज़ै कोई परमेशरेरे राज़ मां गानेरे लेइ अपनो आप निक्के बच्चन बराबर न बनाए, तांतगर परमेशरेरे राज़्ज़े मां दाखल न भोइसखे।” ");
INSERT INTO bhd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","केन्ची यहूदी मैने यीशुए पुच़्छ़ू, “हे रोड़े गुरू हमेशारी ज़िन्दगी हासिल केरनेरे लेइ अवं कुन केरि?” ");
INSERT INTO bhd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","यीशु जुवाब दित्तो, “तू मींजो रोड़ू किजो ज़ोतस? परमेशरेरे अलावा होरो कोई भी रोड़ो नईं। ");
INSERT INTO bhd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","तू त परमेशरेरे हुक्मन ज़ानतस, यानी ‘खून न केरा, बदमाशी न केरा, च़ोरी न केरा, झूठी गवाही न देथ, धोखो न देथ, अपने हाज-बव्वां केरि इज़्ज़त केरा।’ ” ");
INSERT INTO bhd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","तैनी मैने ज़ोवं, “एना सब हुक्म अवं बचपनेरो मन्तो ओरोईं।” ");
INSERT INTO bhd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ज़ैखन यीशुए एन शुन्तां ज़ोवं, “तीं मां एक्की गल्लारी कमी आए, तू ज़ैन किछ तीं कां आए, तैन बेच़तां गरीब मैनन् दे, तैखन तीं स्वर्गे मां खज़ानो मैलेलो। ते एइतां मीं पत्ती च़ल।” ");
INSERT INTO bhd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ए गल शुन्तां तै बड़ो उदास भोइ जेव किजोकि तै बड़ो अमीर थियो। ");
INSERT INTO bhd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","यीशुए तैस हेरतां ज़ोवं, “अमीरां केरू परमेशरेरे राज़्ज़े मां दाखल भोनू केत्रू आसुखतुए। ");
INSERT INTO bhd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","परमेशरेरे राज़्ज़े मां अमीर मैनेरू दाखल भोने केरां ऊँटेरू सांधनेरे पाऐ मरां निस्नू सुख्तू आए!” ");
INSERT INTO bhd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ज़ैनेईं ए गल शुनी त तैना पुच्छ़ने लगे, “फिरी कसेरी मुक्ति भोइ सख्चे।” ");
INSERT INTO bhd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","यीशुए जुवाब दित्तो, “मैनन् करां त एन न भोइ सके पन परमेशरे करां सब किछ भोइ बटते।” ");
INSERT INTO bhd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","पतरसे यीशु सेइं ज़ोवं, “हेर असां त सब किछ छ़ेडतां तीं पत्ती च़लोरेम।” ");
INSERT INTO bhd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","यीशु तैन सेइं ज़ोवं, “अवं तुसन सच़ ज़ोताईं, कि एरो कोई नईं ज़ैनी परमेशरेरे राज़्ज़ेरे लेइ अपनू घर या कुआन्श ते हाज या बव, ढ्ला या बच्चे शारोरे भोन। ");
INSERT INTO bhd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","तैस इस दुनियाई मां बड़ू जादे, ते एजने बैली दुनियाई मां हमेशारी ज़िन्दगी मैलनीए।” ");
INSERT INTO bhd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","यीशुए अपने 12 चेले एप्पू सेइं साथी निये ते तैन ज़ोने लगो, हेरा, “अस यरूशलेम नगरे जो च़लोरेम ते नेबेईं ज़ैन किछ मैनेरे मट्ठेरे बारे मां लिखोरूए तैन पूरू भोलू। ");
INSERT INTO bhd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","तै गैर कौमां केरे हथ्थे देनोए, ते तैना तैसेरो मज़ाक बनाले ते तैस बे इज़्ज़त केरेले ते तैसेरे तुतरे पुड़ थुकनूए। ");
INSERT INTO bhd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","तैस कोड़े मारेले ते तैस मैरी छ़डेले पन तै ट्लेइयोवं दिहाड़े फिरी ज़ींतो भोलो।” ");
INSERT INTO bhd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","तैनेईं ए गल न सेमझ़ी बटी ते यीशुएरी एस गल्लरो मतलब तैन करां छ़प्पोरो राव। ");
INSERT INTO bhd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ते एरू भोवं कि ज़ैखन तैना यरीहो नगरेरे नेड़े पुज़्ज़े त अक कानो मैन्हु बत्तारे ड्लेखी बिशोरो भीख मगतो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ज़ैखन तैनी हछे मैन्हु केरि छ़ैड़ शुनी त तै पुच्छ़ने लगो, “ए कोलहेरी शौर लोरी भोने?” ");
INSERT INTO bhd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","लोकेईं तैस ज़ोवं, “यीशु नासरी कोस्कोई च़लरोए।” ");
INSERT INTO bhd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","तै चिन्डां मैरतां ज़ोने लगो, “हे यीशु नासरी दाऊदेरा मट्ठां मीं पुड़ दया केर।” ");
INSERT INTO bhd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","यीशुए सेइं साथी च़लने बाले लोक तैस काने मैन्हु झ़िड़कने ते ज़ोने लग्गे, च़ुप रा, पन तै मना जादे ज़ोरे-ज़ोरे चिन्डां मैरतां ज़ोने लगो, “हे यीशु नासरी दाऊदेरे मट्ठा मीं पुड़ दया केर।” ");
INSERT INTO bhd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","यीशु खेड़ोव ते हुक्म दित्तो, एस मीं कां आनां ज़ैखन तै तैस कां अव त यीशुए तैस पुच़्छ़ू। ");
INSERT INTO bhd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ज़ो, “अवं तेरे लेइ कुन केरि?” तैनी काने मैने ज़ोवं, “हे प्रभु अवं चाताईं कि अपनि एछ़्छ़ेईं सेइं लेई बेटि।” ");
INSERT INTO bhd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","यीशुए तैस सेइं ज़ोवं, “बेज्झ़ोईं गा तेरे विश्वासे तू बज़्झ़ावरिस।” ");
INSERT INTO bhd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","तै तैखने बेज़्झ़ोव ते लहने लगो ते परमेशरेरी तारीफ़ केरतो यीशु पत्ती च़लो जेव। एन हेरतां सब लोक परमेशरेरी तारीफ़ केरने लगे। ");
INSERT INTO bhd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","यीशु यरीहो नगरे मांमेइं निस्तां च़लोरे थियो। ");
INSERT INTO bhd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","तैड़ी अक मैन्हु थियो, ज़ेसेरू नवं जक्कई थियूं, तै धड़त घिन्ने बालां केरो अफसर थियो, तै बड़ो अमीर थियो। ");
INSERT INTO bhd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","तैस यीशु हेरनेरो चाऊ थियो, पन तैसेरू कद छोटू थियूं, तांए तै हछे मैनन् मरां लेई न थियो बटतो। ");
INSERT INTO bhd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","एल्हेरेलेइ तै देवड़तां अगर जेव ते फ़ेगेरे बुट्टे उबरो गुस्सो किजोकि ज़ैखन यीशु एज्जे त तै तैस रोड़ेच़ारे लेई सके। ");
INSERT INTO bhd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ज़ैखन यीशु तैस ठैरी पुज़ो त तैनी उबरू तेकतां ज़ोवं, “जक्कई लूशी उन्ढो ओस, किजोकि अज़ मीं तेरे घरे ट्लाहन च़ारेई एजनूए।” ");
INSERT INTO bhd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","जक्कई तैखने उन्ढो ओस्सो ते यीशु बेड़ि खुशी सेइं अपने घरे नीयो। ");
INSERT INTO bhd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","एन हेरतां सब लोक शकैइत केरतां ज़ोने लाए, “कि यीशु त एक्की पैपी मैनेरो मेहमान बनोरोए।” ");
INSERT INTO bhd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","जक्कई रोट्टी खांते बारे खड़ो भोइतां प्रभु सेइं ज़ोने लगो, “हे प्रभु यीशु तक अवं अपनि अध्धी जेइदात कंगालन देताईं, अगर केन्चेरू किछ खोरू भोलू त तैस च़ेव्रे हिस्से वापस देइलो।” ");
INSERT INTO bhd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","तैखन यीशुए तैस सेइं ज़ोवं, “अज़ इस घरे मां मुक्ति ओरिए, एल्हेरेलेइ इन भी पूर्वज अब्राहमेरू अक मट्ठूए। ");
INSERT INTO bhd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","किजोकि मैनेरू मट्ठू यानी अवं होरि लोकन हमेशारी सज़ाई करां मुक्ति देने एवरोईं।” ");
INSERT INTO bhd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ज़ैखन लोक यीशुएरी गल्लां शुन्ने लग्गोरो थिये त तैनी तैन अक मिसाल देइतां ज़ोवं, किजोकि तैना यरूशलेम नगरेरे नेड़े पुज़ोरे थिये ते लोकां केरो खियाल थियो परमेशरेरू राज़ लूशी एजनू आए। ");
INSERT INTO bhd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","तैनी तैन ज़ोवं, “अक बड़ो अमीर मैन्हु होरि मुलखे मां च़लो, ताके तैस मुलखेरो मेंत्रेरो ओदो घिन्तां वापस एज्जे। ");
INSERT INTO bhd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","तैनी अपने सेवादारन मरां दश ज़न्हे कुजाए, ते तैन दश मोहरां देइतां ज़ोवं, ‘मेरे वापस एजने तगर इस पेंइसे सेइं कारोबार केरथ।’ ");
INSERT INTO bhd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","पन तैस ठैरी लोक तैस सेइं नफरत केरते थिये, तैनेईं किछ लोक भेज़तां तैस जो बिस्तार भेज़ो, कि अस न चाम ए मैन्हु असन पुड़ राज़ केरे।” ");
INSERT INTO bhd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“ज़ैखन तै हुकुमतरो ओदो हासिल केरतां वापस अव त तैनी अपने सेवादारे जो समाद भेज़ो। ज़ैना तैनी कारोबारेरे लेइ पेंइसे दित्तोरे थिये ताके सेब्भी केरो पतो केरे कि केनि केत्रू कियेरू आए। ");
INSERT INTO bhd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","पेइले मैने एइतां ज़ोवं, ‘हे मालिक मीं तेरी दश अश्रेफेइं सेइं दश होरि कमैई।’ ");
INSERT INTO bhd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","तैनी तैस सेइं ज़ोवं, ‘तीं दश अश्रेफेइं सेइं इमानदेरी सेइं कम कियूं गा तीं दश नगरन पुड़ अधिकार दित्तो गाते।’ ");
INSERT INTO bhd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","दुइयोवं मैने एइतां ज़ोवं, ‘हे मालिक मीं तेरी पंच़ अश्रेफेइं सेइं पंच़ होरि कमैई।’ ");
INSERT INTO bhd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","तैनी तैस सेइं भी ज़ोवं, ‘तीं भी पंच़ नगरन पुड़ अधिकार दित्तो गाते।’ ");
INSERT INTO bhd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","तैखन एक्की मैने एइतां ज़ोवं, ‘हे मालिक इना रेइ तेरी अश्रेफी मीं एन रूमाले मां बेंधतां रखोरि थी।’ ");
INSERT INTO bhd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","किजोकि तू सखत मैनूस ते अवं तीं करां डरतो थियो। किजोकि तू तै चीज़ ज़ै तीं न भोए रखोरि तू तैस भी नेतस ते ज़ैन न भोए बेवरू तू तैन भी लुनतस। ");
INSERT INTO bhd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","तैनी तैस सेइं ज़ोवं, ‘हे दुष्ट नौकरा अवं तेरी गल्लेईं सेइं तींए मुर्ज़म बनताइं। ज़द तीं पतो थियो, कि अवं बड़ो सखत मैन्हु आईं, ते ज़ै चीज़ मीं नईं रखोरि अवं तैस भी सल्हतां ते ज़ैन नईं बेवरू अवं तैन भी लुनतां। ");
INSERT INTO bhd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","फिरी तीं मेरे रुपैइये केन्ची कां किजो नईं रखोरे ताके अवं वापस एइतां तैस करां सूते समेत उसुल केरेथो?’ ");
INSERT INTO bhd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","तैखन तैनी तैन सेइं ज़ोवं, ‘ज़ैन तैड़ी खड़खड़े थिये एस करां एन अश्रेफी एन्तां उस देथ ज़ैस कां दश अश्रेफीन।’ ");
INSERT INTO bhd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","तैना ज़ोने लगे हे मालिक एस कां पेइली दश अश्रेफीन! ");
INSERT INTO bhd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","तैनी तैन जुवाब दित्तो, अवं तुसन सेइं ज़ोताईं कि, ‘ज़ैस कां परमेशरेरी मर्ज़ी समझ़नेरी खुवाइश आए, तैस परमेशर जादे समझ़ देलो। पन ज़ैस कां परमेशरेरी मर्ज़ी समझ़नेरी खुवाइश नईं, तैस केरां, थोड़ी ज़ेरि समझ़ ज़ै तैस कां आए, तै भी नी गाली।’ ");
INSERT INTO bhd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","पन मेरे इन दुश्मन ज़ैन मीं न थिये सुखाते कि, ए असन पुड़ राज़ केरे एन इरां आनां ते मेरे सामने एन मैरी छ़ड्डा।” ");
INSERT INTO bhd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","एना गल्लां ज़ोइतां यीशु अपने चेलन सेइं साथी अग्रोवं जेव कि यरूशलेम नगरे मां गाए। ");
INSERT INTO bhd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ज़ैखन तैना ज़ैतूनेरे पहाड़े बैतफगे ते बैतनिय्याह मां पुज़े त यीशुए दूई चेले एन ज़ोइतां अग्रोवं भेज़े। ");
INSERT INTO bhd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“तुस सामने उस ड्लव्वें मां गाथ ते तैड़ी तुसन अक गधेरो बच्चो बन्धोरो मैलनोए। ज़ैस पुड़ अज़ तगर कोई नईं च़ढ़ोरो तैस खोलतां इड़ी मीं कां आनां। ");
INSERT INTO bhd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ते अगर तुसन कोई पुच़्छ़े, कि तुस एस किजो लोरेथ खोलने त तुस ज़ोइयथ, कि प्रभुए एसेरी ज़रूरत आए।” ");
INSERT INTO bhd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","अग्रोवं गानेबाले चेलेईं तैन्ने कियूं ज़ैन यीशुए ज़ोरू थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ज़ैखन तैना गधेरो बच्चे खोलने लग्गोरो थिये त तैसेरो मालिक तैन पुच्छ़ने लगो, “तुस एस बच्चे किजो लोरेथ खोलने?” ");
INSERT INTO bhd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","तैनेईं जुवाब दित्तो, “प्रभुए एसेरी ज़रूरते।” ");
INSERT INTO bhd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","तैनेईं तै बच्चो खोलतां यीशु कां आनो, ते यीशुए तैस पुड़ अपना लिगड़ां छ़ेडतां तैस पुड़ च़ेढ़तां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ज़ैखन तैना च़लोरे थिये त लोकेईं अपना लिगड़ां बत्ती मां बिछ़ां। ");
INSERT INTO bhd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ज़ैखन तैना यरूशलेम नगरे नेड़े पुज़े त ज़ैट्ठां बत ज़ैतून पहाड़े पुड़ेरां उन्ढी गातीए तैड़ी सारे चेलेईं एना चमत्कार हेरतां ते खुशी भोइतां परमेशरेरी तारीफ़ केरने लगे कि, ");
INSERT INTO bhd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“धने तै राज़ो ज़ै परमेशरे नव्वें सेइं एइते! ते स्वर्गे मां महिमा ते अम्बरे मां शान्ति भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","तैन मैनन् मां किछ फरीसी लोक भी थिये। तैना यीशु सेइं ज़ोने लगे, “हे गुरू अपने चेलन ज़ो कि च़ुप केरन।” ");
INSERT INTO bhd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","यीशुए तैन जुवाब दित्तो, “अवं तुसन ज़ोताईं, अगर एना लोक च़ुप केरन त इना घोड़ ज़ोरे सेइं परमेशरेरी तारीफ़ केरेले।” ");
INSERT INTO bhd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","यरूशलेम नगरे मां पुज़तां यीशु यरूशलेम नगरेरो हाल हेरतां तैस लेरां छुटी। ");
INSERT INTO bhd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ते ज़ोने लगो, “अगर तुस सिर्फ इस दिहैड़रे बारे मां ज़ानते भोथे, ज़ै तुसन शैन्तरे पासे नेती! पन ई गल हुना तुश्शे एछ़्छ़न करां छ़पोरीए। ");
INSERT INTO bhd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","तीं तैना दिहाड़े हेरने पेनेन ज़ेइस तेरे दुश्मन तेरे च़ेव्रे पासन मोरच़ो बेंधतां ते तीं घेरो देले, ते हर पासेरां तीं पुड़ हमलो केरेले। ");
INSERT INTO bhd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","तुश्शे दुश्मन तुसन नाश केरेले, ते सैरी लोकन मारेले, ते तीं पुड़ घोड़े पुड़ घोड़ बाकी न रालो। किजोकि ज़ेइस परमेशर तुसन बच़ानेरे लेइ ओरो थियो तुसेईं न पिशानो।” ");
INSERT INTO bhd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","तैखन तै मन्दरे मां जेव ते तैड़ी तैने बुपारी ते गाक बेइरोवं कढने शुरू किये। ");
INSERT INTO bhd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","तैनी तैन सेइं ज़ोवं, “पवित्रशास्त्रे मां लिखोरूए ‘मेरू मन्दर प्रार्थनारू घर भोलू,’ पन तुसेईं त डैकू केरो अड्डो बनेइतां रख्खोरोए।” ");
INSERT INTO bhd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ते तै तैस पवित्र दहैड़ी मन्दरे मां शिक्षा देतो थियो, पन प्रधान याजक ते शास्त्री लोकेईं यीशु मारनेरी कोशिश मां लग्गोरो थिये। ");
INSERT INTO bhd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","पन तैन एन केरनेरो मौको न थियो मैलतो, किजोकि सारे लोक यीशुएरी गल्लां शुन्नेरे लेइ च़ेव्रे पासन बिश्शोरे रहते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","एक्की दिहाड़े ज़ैखन यीशु मन्दरे मां शिक्षा लोरो थियो देने, ते तैन खुशखबरी लोरो थियो शुनाने त प्रधान याजक ते शास्त्री ते यहूदी बुज़ुर्ग यीशु कां पुज़े। ");
INSERT INTO bhd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ते तैना ज़ोने लगे, “तू एन सैरी गल्लां कसेरे अधिकारे सेइं केरतस या तीं ए अधिकारे केनि दित्तोरोए?” ");
INSERT INTO bhd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","यीशु तैन जुवाब दित्तो, “अवं भी तुसन अक गल पुछ़तईं, मीं ज़ोथ। ");
INSERT INTO bhd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","यूहन्नारो बपतिस्मो स्वर्गेरे तरफां थियो या मैन्हु केरे तरफां थियो?” ");
INSERT INTO bhd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","तैना एप्पू मांमेइं बेंस केरने लगे, “कि अगर अस ज़ोम, ‘स्वर्गेरे तरफां थियो,’ त तै पुछ़ेलो कि, ‘फिरी तुसेईं याकीन की नईं कियेरू?’ ");
INSERT INTO bhd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","पन अगर अस ज़ोम कि, ‘मैन्हु केरे तरफां थियो,’ त लोकेईं असन घोड़ेईं देनिन, किजोकि तैना यूहन्ना नबी मन्ते थिये।” ");
INSERT INTO bhd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","एल्हेरेलेइ तैनेईं जुवाब दित्तो, “कि अस न ज़ानम कि केसेरी तरफां थियो।” ");
INSERT INTO bhd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","यीशु तैन सेइं ज़ोवं, “त अवं भी तुसन सेइं न ज़ोईं कि एना कम्मां कसेरे अधिकारे सेइं केरताईं।” ");
INSERT INTO bhd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","फिरी यीशु तैन लोकन अक मिसाल देइतां ज़ोने लगो, “एक्की मैने दाछ़री बाग लाई ते तै ठेकेदारन ठेके पुड़ देइतां एप्पू खरे च़िरे कोस्कोई दूर मुलखे च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ज़ेइस दाछ़ पकनेरो मौसम अव त तैनी अपनो हिस्सो नेनेरे लेइ अक नौकर बागी मां भेज़ो। पन तैनेईं तै खूब कुटो ते खाली वापस भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ते फिरी तैनी अक होरो नौकर भेज़ो, पन तैनेईं तैसेरी भी बेइज़ती की, ते तै भी झ़ुस कुट केरतां खाली वापस भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","फिरी तैनी अक ट्लेइयोवं होरो नौकर भेज़ो, पन तैनेईं तैसेरी भी बेइज़ती की ते ज़ख्मी केरतां कढो। ");
INSERT INTO bhd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","तैखन बागारे मालिके ज़ोवं, ‘अवं अपनू ट्लारू मट्ठू भेज़ताईं शैइद तैना तैसेरो लिहाज़ केरेले।’ ");
INSERT INTO bhd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","पन ज़ैखन ठेकेदारेइं तै लाव त एप्पू मांमेइं मुशोरो केरने लगे, ए मालिके, एज्जा एस्से मारम ताके जेइदात इश्शी भोइ गाए। ");
INSERT INTO bhd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","तैनेईं तैन मट्ठू बागी मरां बेइर शैरी छ़ड्डू, ते मारू तुस सोचा कि फिरी बागारे मालिके तैन सेइं कुन केरेलो। ");
INSERT INTO bhd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ते मालिक एइतां तैन मैरी छ़डेलो ते बाग होरि केरे हवाले केरेलो।” तैनेईं एन शुन्तां ज़ोवं, “परमेशर न केरे एरू न भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","तैनी तैन केरे पासे तेकतां ज़ोवं, “फिरी इन कुने ज़ैन पवित्रशास्त्रे मां लिखोरूए कि, ‘ज़ै घोड़ मिस्त्रेईं रद्दी कियो, तैए घोड़ कूनेरो घोड़ भोलो।’ ");
INSERT INTO bhd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ज़ै मैन्हु इस घोड़े पुड़ बिछ़ड़ेलो त तैसेरे टुक्ड़े-टुक्ड़े भोइ गाले, ते ज़ैस उन्ढो ए घोड़ बिछ़ड़ेलो तैस ए पितां छ़डेलो।” ");
INSERT INTO bhd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","शास्त्री लोकेईं ते प्रधान याजकेईं यीशु ट्लानेरी कोशिश की। किजोकि तैना बुझ़ी जोरे थिये, कि तैनी ए मिसाल एन केरे बारे मां शुनेवरी थी, पन तैना लोकन करां डरते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","तैना लोक यीशुए ट्लानेरो मौको तोपने लोरे थिये, तैनेईं विशवैसी केरे रूपे मां जासूस भेज़े ताके तैसेरी कोई गल ट्लेइ सखन ते फिरी राज़ेरे अधिकारे मां देइ देन। ");
INSERT INTO bhd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","तैनेईं यीशु पुच़्छ़ू, “हे गुरू अस ज़ानतम कि तू सच़्च़ो आस ते सच़्च़ेरी शिक्षा देतस, ते केन्चेरी तरफदारी न केरस बल्के सच़्च़े सेइं परमेशरेरी बत्तरी शिक्षा देतस। ");
INSERT INTO bhd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","कुन असन महाराज़े जो धड़त देनी जेइज़े कि नेईं?” ");
INSERT INTO bhd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","यीशुए तैन केरि च़लाकी बुझ़तां तैन जो ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“मीं अक दीनार हिराथ ते एस पुड़ केसेरी शकल ते केसेरू नंव्वे?” तैनेईं ज़ोवं, “महाराज़ेरी।” ");
INSERT INTO bhd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","यीशु तैन सेइं ज़ोवं, “ज़ैन महाराज़ेरू तैन महाराज़े जो देथ, ते ज़ैन परमेशरेरू ए, तैन परमेशरे जो देथ।” ");
INSERT INTO bhd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ते तैना लोकां केरे सामने तैसेरी कोई गल न ट्लेइ सखे बल्के तैसेरे जुवाबे सेइं तैना हैरान भोइतां च़ुप रेइजे। ");
INSERT INTO bhd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","फिरी सदूकी ज़ैन ज़ोते थिये कि मुवोरे ज़ींते न भोन ते फिरी किछ यीशु कां एइतां पुच्छ़ने लगे। ");
INSERT INTO bhd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“हे गुरू असन जो मूसेरो हुक्मे कि अगर केन्चेरो ढ्ला अपनि कुआन्शारे भोंते संते ओईट्ल मेरि गाए त तैसेरो ढ्ला तैस कुआन्शी सेइं ड्ला बनाए, ताके तै अपने ढ्लाएरे लेइ औलाद पैदा केरे। ");
INSERT INTO bhd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","सत ढ्ला थिये पेइले ड्ला बनाव ते ओईट्ले मेरि जेव। ");
INSERT INTO bhd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","फिरी होरे तैस सेइं ड्ला बनाव। ");
INSERT INTO bhd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","फिरी तैल्ला पत्ती ट्लेइयोवं तै कुआन्श रख्खी फिरी एन्च़रे सेइं सत्तेईं ज़नेईं ड्ला बनाव, पन सब बेऔलाद मेरि जे। ");
INSERT INTO bhd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ते आखर्कार तै कुआन्श भी मेरि जेई। ");
INSERT INTO bhd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ते ज़ींते भोने पुड़ तै केसेरी कुआन्श भोली? किजोकि तै सत्ते ढ्लां केरि कुआन्श बनोरी थी।” ");
INSERT INTO bhd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","यीशुए तैन सेइं ज़ोवं, “इस दुनियारे लोकन मां त ड्ला बनानेरो दस्तूरे। ");
INSERT INTO bhd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","पन ज़ैना लोक एजने बैली दुनियारे काबल भोले, ते ज़ैना मुड़दन मरां ज़ींते भोले तैना ड्ला न बनाले। ");
INSERT INTO bhd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","तैना मरेले भी नन्ना एल्हेरेलेइ की तैना स्वर्गदूतां केरे ज़ेरे भोले ते तैन जो ज़ींते भोनेरां ते परमेशरेरां मट्ठां ज़ोले। ");
INSERT INTO bhd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ते ज़ैड़ी तगर मुड़दां केरो ज़ींते भोनेरी गल्ले, ज़ेन्च़रे मूसा नेबेरे ज़लते झ़ैल्लोवेरे बारे मां, तेन्च़रे इशारो कियो किजोकि तै परमेशर अब्राहमेरो परमेशर, इसहाकेरो परमेशर ते याकूबेरो परमेशर ज़ोइतां फुकारतो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","पन परमेशर मुड़दां केरो नईं बल्के ज़ींतां केरो परमेशरे। किजोकि तैसेरे नेड़े सब ज़ींतेन।” ");
INSERT INTO bhd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","शास्त्री लोकन मरां किछेईं जुवाब दित्तो, “हे गुरू तीं त बड़ू रोड़ू ज़ोवं।” ");
INSERT INTO bhd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","फिरी तैन मरां केन्ची हिम्मत न अई, कि एस होरू किछ पुछ़न। ");
INSERT INTO bhd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","फिरी यीशुए तैन सेइं ज़ोवं, “फिरी मसीह जो दाऊदेरू मट्ठू केन्च़रे सेइं ज़ोतन? ");
INSERT INTO bhd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","किजोकि दाऊद त एप्पू भजना केरे किताबी मां ज़ोते, परमेशरे मेरे प्रभु सेइं ज़ोवं, मेरे देइने पासे बिश। ");
INSERT INTO bhd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","कि ज़ां तगर अवं तेरे दुश्मन तेरे पावन हैठ न बिशैली। ");
INSERT INTO bhd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","दाऊद त तैस जो प्रभु ज़ोते, फिरी तैन तैसेरू मट्ठू केन्च़रे भोवं?” ");
INSERT INTO bhd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ज़ैखन सब लोक शुनी राहोरे थिये त यीशुए अपने चेलन सेइं ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“शास्त्री लोकन करां हुशार रेइयथ तैना लम्मे-लम्मे कुरते लांने पसंद केरतन, ते होरू एन चातन कि लोक बज़ारन मां तैन जो नमस्कार ज़ोन, ते तैना प्रार्थना घरे मां उच्ची कुर्सी तोपतन ते धामन मां बड़े खास बन्नू चातन। ");
INSERT INTO bhd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","तैना विधवां कुआन्शां केरां घरां लुटतन ते लोकन हिरानेरे लेइ बड़ी लम्मी प्रार्थना केरतन। तैन हछ्छी सज़ा मैलनीए।” ");
INSERT INTO bhd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","यीशु अमीर लोकां केरे पासे तकने लगो, ज़ैना-ज़ैना दान-पेट्टी मां दान लोरे थिये छ़डने। ");
INSERT INTO bhd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","तैनी अक बड़ी गरीब विधवा कुआन्श लाई ज़ैसां दूई पेंइसे यानी अक धेलो च़ाढ़ो। ");
INSERT INTO bhd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","तैखन यीशुए ज़ोवं, “अवं तुसन सेइं सच़ ज़ोताईं कि दान-पेट्टी मां दान देने बालन मरां सेब्भन करां जादे इस विधवा कुआन्शां दान दित्तू। ");
INSERT INTO bhd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","किजोकि तैनेईं त अपनि दौलती मरां सिर्फ धगसेरे पेंइसे परमेशरे घरे मां दित्तोरेन पन इस कुआन्शां अपनि गरीब हालती सेइं ज़ैन किछ एसारे पल्ले थियूं सब किछ देइ छ़डू।” ");
INSERT INTO bhd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","किछ लोक मन्दरे बारे मां ज़ोने लोरे थिये, कि बड़े माघे घोड़ेईं सेइं ते दान कियोरी चीज़न सेइं बनोरूए, त यीशुए ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“तैना दिहाड़े एजने बालेन कि इन चीज़ां ज़ैना तुस इड़ी लहने लोरेथ इड़ी घोड़े पुड़ घोड़ नईं रानो ज़ै बछ़ोड़ो न गालो।” ");
INSERT INTO bhd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","तैनेईं यीशुए पुच़्छ़ू, “हे गुरू जी एन गल्लां केइस भोनिन? ते तैन केरो दुनियाई मां एजनेरो कुन निशान भोनोए।” ");
INSERT INTO bhd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","यीशुए तैन ज़ोवं, “खबरदार टेपलोईयथ नन्ना, किजोकि काई लोक मेरे नंव्वे सेइं एजनेन ते तैनेईं ज़ोनूए कि अव्वें मसीह आईं, ते मौको भी नेड़े पुज़ोरोए तुस तैन पत्ती न गेइयथ। ");
INSERT INTO bhd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ते ज़ैखन तुस लड़ेइयरी त उलझनरी अफुवां शुनेले त डेरथ नन्ना, किजोकि एन गल्लां केरू पेइले भोनू ज़रूरीए, पन तेइसे खातमों नईं भोनो।” ");
INSERT INTO bhd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","तैखन यीशुए ज़ोवं, “किजोकि कौमी पुड़ कौम, ते राज़्ज़े पुड़ राज़ चढ़हाई केरेलू। ");
INSERT INTO bhd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ठारी-ठारी बडे-बडे भुंज़ल एजनेन ते काल पेनोए ते बिमारी फैलनिएं ते बुरी-बुरी गल्लां भोनिन ते अम्बरे मां आजीब निशान लेइहोनेन। ");
INSERT INTO bhd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","एन सब गल्लां भोने करां पेइले तुश्शे दुश्मन तुसन सिर्फ मेरे नव्वेंरे वजाई सेइं ढप्पेले ते तुसन सताले ते प्रार्थना घरेरी आदालती मां हाज़र केरेले ते कैद केरेले ते गवर्नरन ते कने राज़न कां पैश केरेले। ");
INSERT INTO bhd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","तैखन तुसन मेरी गवाही देनेरो रोड़ो मौको मैलेलो। ");
INSERT INTO bhd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","पन तुसन कोई ज़रूरत नईं, कि पेइले फिक्र केरने लगथ कि अस कुन ज़ोमेले। ");
INSERT INTO bhd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","किजोकि अवं तुसन एरी ज़बान ते अक्ल देइलो, कि कोई भी मुखालफ तुश्शे सामने खड़ो न भोइ सकेलो ते न लोक तुश्शे खलाफ किछ ज़ोई सकेलो। ");
INSERT INTO bhd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ते तुश्शे हाज बव ते ढ्ला ते रिशतेदार ते दोस्त तुसन सेइं बैर केरेले ते तुसन मरां किछन मारेले भी। ");
INSERT INTO bhd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ते मेरे नव्वेंरे वजाई सेइं सारे लोक तुसन सेइं नफरत केरेले। ");
INSERT INTO bhd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","पन तुश्शे दोग्गेरो कोई बाल बांको न भोलो। ");
INSERT INTO bhd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","सब किछ झ़ेलतां तुस अपनि जान बच़ेइ साखेलो।” ");
INSERT INTO bhd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ज़ेइस तुस यरूशलेम नगर च़ेव्रे पासन फौवजेइं सेइं घेरेरू लाले, त बुझ़थ कि एस नाश भोनेरे दिहाड़े नेड़े ओरेन। ");
INSERT INTO bhd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","तैस मौके ज़ैन यहूदिया मां भोले तैना पहाड़े पुड़ जो नेश्शी गान ते ज़ैना यरूशलेम नगरे मां भोले त तैन बेइरोवं निसन ते ज़ैना ड्लोंव्वन मां भोले त तैना नगर मांजो न गान। ");
INSERT INTO bhd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","किजोकि एना बदलेरे दिहाड़े भोले, एन मां तैन सब किछ ज़ैन पेइलू पवित्रशास्त्रे मां लिखोरूए तैन पूरू भोनूए। ");
INSERT INTO bhd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","तैन दिहाड़न मां ज़ैना दोज़ींती त दुद्ध पियाती कुआन्श भोली, तैन केरे लेइ अफ़सोस! किजोकि धेरती पुड़ बड़ी मुसीबत एजनीए ते एस कौमी पुड़ बड़ी आफत एजनीए। ");
INSERT INTO bhd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","तैना सब तलवारी सेइं मारे गाले ते गुलाम बेनतां सेब्भी कौमन मां पुज़ेले ते गैर कौमां केरो मौको पूरो भोने तगर यरूशलेम नगर गैर कौमेईं सेइं पस्त भोंतो रालू। ");
INSERT INTO bhd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“दिहाड़े चेंदनरी ते तारन मां निशान बांदे भोनेन ते धेरती पुड़ कौमन बड़ी तकलीफ पुज़नियें, किजोकि समुन्द्रेरी लैहेरां केरि शौरी सेइं तैना डेरि गानेन। ");
INSERT INTO bhd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","डर्रे मारे एजने बैली मुसीबतरे इंतज़ार केरते-केरते तैन केरे होश उड़ी गानेन, किजोकि अम्बरेरी सैरी शेक्ति हिल्लेली। ");
INSERT INTO bhd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","तैखन लोक मैनेरू मट्ठू बेड़ि शेक्ति ते महिमा सेइं बिदलारी मां एंइतू लाएले। ");
INSERT INTO bhd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ज़ैखन एन गल्लां भोनी शुरू भोली त सिधे खड़े भोइतां उबरू तेकथ, किजोकि तुश्शो छुटकारो भोने बालोए।” ");
INSERT INTO bhd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","फिरी यीशुए तैन अक मिसाल देइतां ज़ोवं, “तुस फ़ेगेरे बुट ते होरि बुट्टन भी हेरतथ। ");
INSERT INTO bhd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ज़ेरि तैस गुडी लेगनी शुरू भोइचन? त तुस हेरतां बुझ़तथ कि नेला ओरोए। ");
INSERT INTO bhd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","एसेरो ज़ेरो, ज़ैखन तुस एना गल्लां, ज़ैना मीं ज़ोई, भोते हेरेले, त तुस बुज़्झ़ी छ़ड्डा कि परमेशरेरू राज़ नेड़े ओरूए। ");
INSERT INTO bhd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","अवं तुसन सेइं सच़ ज़ोताईं, कि ज़ां तगर एन गल्लां पूरी न भोन, एस कौमरो खातमों न भोलो। ");
INSERT INTO bhd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","धरती अम्बर टेली गालू पन मेरी गल्लां कधे न टेलेली। ");
INSERT INTO bhd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“बस्सा खबरदार भोथ कोस्कोई एरू न भोए कि तुश्शो दिल नशे मां मसत भोइतां इस ज़िन्दगरे फिक्रे सेइं कमज़ोर भोए, ते तैस दिहाड़े तुश्शे लेइ अक मुसीबत बने। ");
INSERT INTO bhd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","किजोकि तै इस सैरी धेरती पुड़ ज़ेत्रे लोकन तैन सेब्भन पुड़ एन्च़रे एजनीए। ");
INSERT INTO bhd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","बस्सा, हर वक्त तियार राथ ते प्रार्थना केरते राथ, ताके तुस एन गल्लन करां ज़ैना भोने बैलिन बेंच़तां राथ, ते मैनेरे मट्ठे कां खड़े भोनेरे काबल भोथ।” ");
INSERT INTO bhd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","यीशु रोज़ मन्दरे मां शिक्षा देतो थियो, ते राती ज़ैतून पहाड़े पुड़ रातो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","झ़ेझ़ां सारे लोक यीशुएरी गल्लां शुन्नेरे लेइ मन्दरे मां तैस कां एइते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","अखमीरी तिहारेरी दिहाड़ी ज़ैस जो फ़सह ज़ोतन नेड़े ओरी थी। ");
INSERT INTO bhd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","प्रधान याजक ते शास्त्री मौको तोपने लोरे थिये कि यीशु केन्च़रे मारम। किजोकि तैना लोकन करां डरते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ते शैतान यहूदा मां बेस्सी जेव तैस जो इस्करियोती भी ज़ोते थिये, ते तै यीशुएरे 12 चेलन मां गनो गातो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","दे तै प्रधान याजकन ते प्रार्थना घरेरे किछ खास पुच्छ़ने गन्ने लोकन कां जेव ते तैन सेइं मुशोरो केरने लगो कि केन्च़रे सेइं यीशु तैन केरे हवाले केरी बटते। ");
INSERT INTO bhd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","तैना बड़े खुशी भोए ते तैस पेंइसे देनेरो वादो कियो। ");
INSERT INTO bhd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","तैनी तैन केरि गल मन्नी ते मौको तोपने लगो, कि यीशु केन्च़रे सेइं तैन केरे हावाले केरे ते केन्ची पतो न लग्गे। ");
INSERT INTO bhd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","अखमीरी रोट्टरू तिहार नेड़े ओरू थियूं, ज़ैस फ़सह तिहारे मां गबड़ेरू बलिदान देनू ज़रूरी थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","यीशुए पतरस ते यूहन्ना एन ज़ोइतां भेज़े, “कि गाथ ते इश्शे लेइ फ़सह तिहारेरी रोट्टी तियार केरा।” ");
INSERT INTO bhd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","चेलेईं पुच़्छ़ू, “कि तू कोड़ि चातस कि अस तींजो फ़सह तिहारेरी रोट्टी तियार केरम?” ");
INSERT INTO bhd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","यीशुए तैन जुवाब दित्तो, “नगर मां गाते तुसन अक मैन्हु मैलनोए ज़ै पैनेरो घड़ो घिन्तां च़लोरो भोनोए, तैस पत्ती गेइयथ ते ज़ैस घरे मां तै गालो तुस भी गेइयथ। ");
INSERT INTO bhd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","तैसेरे मालिके सेइं ज़ोइयथ कि गुरे ज़ोरूए कि ट्लाहना केरि ठार कोड़ि आए, ज़ैड़ी अवं अपने चेलन सेइं साथी फ़सह तिहारेरी रोट्टी खेइ सेखी? ");
INSERT INTO bhd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","तै तुसन दोपरे नेइतां अक बड्डो कमरो हिरालो ज़ै खूब रोड़ेच़ारे सज़ैवरो भोनोए तैड़ी इश्शे लेइ तियारी केरथ।” ");
INSERT INTO bhd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","तैनेईं तैड़ी गेइतां सब किछ तेरहु लाव ज़ेरू तैनी ज़ोरू थियूं, ते तैड़ी फ़सह तिहारेरी रोट्टी तियार की। ");
INSERT INTO bhd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ज़ैखन रोट्टी खानेरो मौको अव त यीशु अपने प्रेरितन सेइं साथी बिश्शोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ते यीशुए तैन सेइं ज़ोवं, “मेरी ए बड़ी इच्छा थी, कि अपनो दुःख झ़ल्लने (मरने) करां पेइले एक्की बार फ़सह तिहारेरी रोट्टी तुसन सेइं साथी खेइ। ");
INSERT INTO bhd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","किजोकि अवं तुसन सेइं ज़ोताईं, कि अज़ेरां पत्ती तांतगर न किछ खेइ सेखी, ज़ां तगर परमेशरेरे राज़्ज़ेरू कम पूरू न भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","फिरी यीशुए दाछ़रे रसेरो कटोरो ट्लातो ते परमेशरेरू शुक्र केरतां चेलन दित्तो ते ज़ोवं, “यांथ ते एप्पू मांमेइं बंटा। ");
INSERT INTO bhd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","किजोकि अवं तुसन सेइं ज़ोताईं कि अज़ेरां पत्ती दाछ़ारो ए रस फिरी तांतगर न पीलो ज़ां तगर परमेशरेरू राज़ न एज्जे।” ");
INSERT INTO bhd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","फिरी यीशुए रोट्टी ट्लाती ते परमेशरेरू शुक्र केरतां ट्लोड़ी ते तैसेरे टुक्ड़े बनेइतां अपने चेलन एन ज़ोइतां दित्ती, “कि ई मेरी जाने ज़ै तुश्शे लेइ अवं देताईं ते तुस भी मेरी यादगैरी मां एन्ने केरते रेइयथ।” ");
INSERT INTO bhd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","एन्च़रे रोट्टी खानेरे बाद तैनी कटोरो ट्लातो ते चेलन कां दित्तो ते ज़ोवं, “कि ई कटोरो मेरो तैस खूनेरो नंव्वो करारे ज़ै तुश्शे लेइ दित्तोरोए। ");
INSERT INTO bhd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","पन हेरा मीं ट्लुवांने बालो मीं सेइं साथी खाने लोरोए। ");
INSERT INTO bhd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","किजोकि मैनेरू मट्ठू त हुनी च़लोरोस ज़ेन्च़रे कि तैसेरेलेइ पेइले एन पक्कू भोरूए पन तैस मैन्हु पुड़ अफ़सोस ज़ेसेरे हथेइं तै गिरफ्तार भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","एन शुन्तां तैना एप्पू मांमेइं पुच्छ़ने लगे, “असन मां एरो ज़ेरो कौने ज़ै एन कम केरेलो?” ");
INSERT INTO bhd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","तैन एस गल्ली पुड़ एप्पू मांमेइं बेंस भोइ कि असन मां बड्डो कौने? ");
INSERT INTO bhd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","यीशु तैन सेइं ज़ोवं, “गैर कौमन पुड़ तैन केरे राज़े राज़ केरतन, ते ज़ैन केरो तैन पुड़ अधिकारे भोते तैन जो भलाई केरनेबाले ज़ोतन। ");
INSERT INTO bhd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","पन तुसन मां एरू लोड़े भोवरू, तुसन मां ज़ै बड्डोए तै निकड़ेरे बराबर बने ते ज़ै खास आए तै सेवकेरे बराबर बने। ");
INSERT INTO bhd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","किजोकि बड्डो कौने? ज़ै तैस कां साथी बिशोरोए या तै ज़ै तैसेरो चेलोए? कुन तै तैस कां नईं बिशोरो? पन अवं त तुसन मां अक सेवकेरे बराबर आईं। ");
INSERT INTO bhd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","पन तुस तैना आथ ज़ैना मेरी अज़मैइशरे मौके बराबर मीं सेइं साथी रातथ। ");
INSERT INTO bhd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ज़ेन्च़रे बाजी मीं अक राज़ दित्तोरूए अवं भी तुसन अक राज़ देताईं। ");
INSERT INTO bhd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ताके तुस मेरे राज़्ज़े मां मीं सेइं साथी बिश्तां खाथ पीथ, बल्के बडे-बडे शाही तखतन पुड़ बिश्तां इस्राएलेरे 12 गोत्रां केरो इन्साफ केरेले।” ");
INSERT INTO bhd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“शमौन, शमौन, खबरदार रा, शैताने परमेशरे करां अज़ाज़त मग्गोरीए कि तुसन सेब्भन परखे, कि रोड़े बुरे करां अलग केरे ज़ेन्च़रे ज़मीनदार गेहुंन करां झ़ाझ़ अलग केरते। ");
INSERT INTO bhd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","पन मीं तेरे लेइ प्रार्थना की, कि तू मीं पुड़ विश्वास केरनो न शारस, ज़ैखन तू मन फिरास त अपने विश्वासी ढ्लान मज़बूत केरां।” ");
INSERT INTO bhd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","पतरसे यीशु सेइं ज़ोवं, “हे परमेशर तीं सेइं अवं कैद भोने बल्के मरनेरे लेइ भी तियार आईं।” ");
INSERT INTO bhd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","पन यीशुए ज़ोवं, “हे पतरस अवं तीं सेइं ज़ोताईं कि अज़ कुकड़े बांग देने करां पेइले तू मेरो ट्लाई बार इन्कार केरेलो कि अवं एस न ज़ैनी।” ");
INSERT INTO bhd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","यीशुए तैन सेइं ज़ोवं, “कि ज़ेइस मीं तुस खुशखबरी शुनाने, बगैर बेटवे, बूटां ते झोलेरे बगैर भेज़ोरे थिये त तुस केन्ची चीज़ारे घटी भोइ?” तैनेईं ज़ोवं, “केन्ची चीज़री नईं।” ");
INSERT INTO bhd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","यीशु तैन सेइं ज़ोवं, “पन हुनी ज़ैस कां बेटवो भोए ते साथी रखे ते एन्च़रे झोलो भी ते ज़ैस कां तलवार न भोए तै अपनू कोट बेच़तां भी तलवार घिन्ने। ");
INSERT INTO bhd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","अवं तुसन सेइं ज़ोताईं कि ई गल्ले ज़ै पवित्रशास्त्रे मां लिखोरीए, कि तै पूरी भोए। तै बुरे लोकन सेइं साथी गनो जेव! एल्हेरेलेइ मेरे बारे मां लिखोरी गल्लां पूरी भोने लोरिन।” ");
INSERT INTO bhd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","तैनेईं ज़ोवं, “हे प्रभु हेर इड़ी दूई तलवारन।” तैनी तैन सेइं ज़ोवं “बेड़ि आन।” ");
INSERT INTO bhd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","फिरी तै बेइर निस्सो ते ज़ेन्च़रे तैसेरो दस्तूर थियो, तै ज़ैतून पहाड़े पुड़ जो च़लो जेव ते तैसेरे चेले भी तैस सेइं साथी च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","तैस ठैरी पुज़तां तैनी तैन सेइं ज़ोवं, “प्रार्थना केरा ताके तुस अज़मैइशी मां न पेथ।” ");
INSERT INTO bhd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","यीशुए तैन करां थोड़े ज़ेरे अग्गर गेइतां ज़ैधू केरे भारे बिश्तां प्रार्थना केरने लगो। ");
INSERT INTO bhd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“हे बाजी अगर तेरी मर्ज़ी भोए त ई दुखेरो कटोरो मीं करां दूर केर, पन फिरी भी मेरी मर्ज़ी पूरी न भोए बल्के तेरी मर्ज़ी पूरी भोए।” ");
INSERT INTO bhd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","तैखन तैनी अम्बरेरां अक स्वर्गदूत लाव ज़ै तैस शक्ति देतो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ते तै परेशान भोइतां होरि जादे दिले सेइं प्रार्थना केरने लगो ते तैसेरो पिसीनो बुझ़ा कि खूनेरे बडे-बडे तेप्पु तल्ले झ़ड़ते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","प्रार्थना केरनेरे बाद यीशु अपने चेलन कां वापस अव ते तैना गम्मेरे मारे झ़ुलोरे मैल्ले। ");
INSERT INTO bhd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","यीशुए तैन सेइं ज़ोवं, “तुस किजो झ़ुल्लोरेथ उठा ते प्रार्थना केरा ताके अज़मैइशी मां न राथ।” ");
INSERT INTO bhd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","हेजू यीशुए गल ज़ोने लोरो थियो, त मैन्हु केरो अक जथो तैड़ी पुज़ो ते बारहन मरां अक ज़ेसेरू नवं यहूदा थियूं, तैन सेइं अग्री-अग्री थियो, ते तै यीशु फुम्मड़ी देने अगर अव। ");
INSERT INTO bhd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","पन यीशुए तैस सेइं ज़ोवं, “यहूदा कुन तू एक्की फुम्मड़ी सेइं मीं मैनेरे मट्ठे ट्लुवातस?” ");
INSERT INTO bhd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ज़ैखन यीशुएरे सैथेईं एन सब हेरू त तैनेईं ज़ोवं, “हे प्रभु कुन अस तलवार च़लाम?” ");
INSERT INTO bhd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ते तैन मरां एक्के महायाजकेरे नौकरे पुड़ तलवारां च़लाई ते तैसेरो तैनी कन्न उड़ाव। ");
INSERT INTO bhd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","पन यीशुए जुवाब दित्तो, “बस्सा बड़ू भोइ जेवं।” ते यीशुए तैसेरो कन्न तैखने हथ लेइतां बझ़ाव। ");
INSERT INTO bhd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","तैखन यीशुए प्रधान याजकन ते मन्दरेरे सिपाही ते बुज़ुर्ग ज़ैन तैस गिरफ्तार केरने ओरे थिये तैन जो ज़ोवं, “तुस कुन तलवारां ते डंडे घिन्तां मीं डैकू बुझ़तां ट्लाने ओरेथ? ");
INSERT INTO bhd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ज़ेइस अवं तुसन सेइं साथी मन्दरे मां भोतो थियो, त तुसेईं मीं सेइं हथ न लाव, पन ई त तुश्शे आंधरेरे मौकेरो अधिकारे।” ");
INSERT INTO bhd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ज़ैखन तैनेईं यीशु ट्लातो तैस तैट्ठां नेइतां महायाजकेरे घरे नीयो, पतरस भी पत्तपति बल्हे-बल्हे तैरां जेव। ");
INSERT INTO bhd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","तैनेईं अंगने मां अग बालोरी थी ते सब बिश्तां अग तपने लोरे थिये ते पतरस भी तैन मां थियो। ");
INSERT INTO bhd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ते अक कुआन्श अग्गी कां बिशोरी तकने लोरी थी ते पतरसेरां तेकतां ज़ोने लगी, “कि ई मैन्हु भी तैस सेइं साथी थियो।” ");
INSERT INTO bhd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","पन पतरसे इन्कार केरतां ज़ोवं, “हे कुआन्शे अवं एस न ज़ैनी ए कौने।” ");
INSERT INTO bhd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","थोड़ी सैइत्रां पत्ती होरे एक्के पतरसेरां तेकतां ज़ोवं, “तू भी तैन्ना केरो साथिस।” पन पतरसे ज़ोवं, “नईं अवं नईं।” ");
INSERT INTO bhd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","कोई एक्की घेंटेरे बाद केन्चे होरे बड़े याकीने सेइं ज़ोवं, “ई मैन्हु पक्को तैस सेइं साथी थियो, किजोकि ए भी गलीली आए।” ");
INSERT INTO bhd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","पन पतरसे इन्कार केरतां ज़ोवं, “अवं एस न ज़ैनी तू कुन ज़ोतस?” हेजू पतरसे ए गल ज़ोने लोरो थियो, त कुकड़े बांग दित्ती। ");
INSERT INTO bhd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ते प्रभुए फिरतां पतरसेरे पासे तक्कू ते पतरसे परमेशरेरी तै गल याद आई, ज़ै तैनी पतरसे सेइं ज़ोरी थी, “कि अज़ कुकड़े बांग देने करां पेइले तू मेरो ट्लाई बार इन्कार केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ते पतरस बेइर गेइतां ज़ोरे-ज़ोरे लेरां देने लगो। ");
INSERT INTO bhd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ज़ैने मैनेईं यीशु अपने कब्ज़े मां कियोरो थियो, तैना तैसेरी हासी बनाते थिये ते कने तैस बाते थिये। ");
INSERT INTO bhd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","तैना यीशुएरी एछ़्छ़न पुड़ पट्टी बेन्धतां बाते थिये ते पुछ़ते थिये, “भविष्यिवाणी केर ते ज़ो केनि बाहोरिए?” ");
INSERT INTO bhd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ते तैनेईं एन्च़रे होरि भी बेड़ि गल्लां ज़ोई ते तैसेरी तुहीन की। ");
INSERT INTO bhd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","झ़ेझ़ां बुज़ुर्ग लोक ते प्रधान याजक ते शास्त्री लोकेईं यीशु अपने महासभाई मां आनो, ");
INSERT INTO bhd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ते ज़ोने लगे, “अगर तू मसीह आस त ज़ो!” यीशुए तैन सेइं ज़ोवं, “अगर अवं तुसन ज़ोईं भी त तुस मेरू याकीन न केरेले। ");
INSERT INTO bhd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ते अगर अवं तुसन पुछ़ी त तुस जुवाबे न देले। ");
INSERT INTO bhd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","पन अज़ेरां बाद मैनेरू मट्ठू परमेशरेरे देइने पासे बिशोरू लाएले।” ");
INSERT INTO bhd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","एस गल्ली पुड़ तैना सब ज़ोने लगे, “तू परमेशरेरू मट्ठू आस?” यीशुए जुवाब दित्तो, “तुस एप्पू मींजो ज़ोतथ कि तू आस?” ");
INSERT INTO bhd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","तैनेईं ज़ोवं, “हुनी असन होरि शाहादतां केरि कुन ज़रूरीए? किजोकि असेईं एसेरी ज़बान शुनेरूए।” ");
INSERT INTO bhd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","तैखन तैना सब तैट्ठां उठे ते यीशुए पिलातुसे कां घिन्तां जे। ");
INSERT INTO bhd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ते तैस जो एन ज़ोइतां ए इलज़ाम लांने लगे, “कि ए इश्शे लोकन भड़काते ते महाराज़े जो धड़त देनेरे लेइ ठाकते, ते अपने आपे जो मसीह राज़ो ज़ोते।” ");
INSERT INTO bhd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","तैखन पिलातुसे यीशुए पुच़्छ़ू, “तू यहूदी केरो राज़ोस?” यीशु तैस जुवाब दित्तो, “तू एप्पू ज़ोतस!” ");
INSERT INTO bhd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","पिलातुसे प्रधान याजकन ते लोकन सेइं ज़ोवं, “कि अवं एस मैन्हु मां कोई कसूर न लेई।” ");
INSERT INTO bhd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","पन तैना बड़े घमण्डे सेइं ज़ोने लगे, “ए यहूदियारे इलाके करां गलील इलाके तगर बल्के इड़ी तगर लोकन अपनि शिक्षाई सेइं भड़काते।” ");
INSERT INTO bhd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ज़ैखन पिलातुसे एन शुनू त तैनी पुच़्छ़ू, “कुन ए मैन्हु भी गलील इलाकेरो आए।” ");
INSERT INTO bhd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ते ज़ेरो तैस पतो लगो, कि ए हेरोदेसेरे इलाकेरो रानेबालोए, त पिलातुसे तै हेरोदेस कांजो भेज़ो। किजोकि तैस वक्ते मां तै एप्पू भी यरूशलेम नगरे मां थियो। ");
INSERT INTO bhd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ज़ैखन हेरोदेसे यीशु लाव त बड़ो खुशी भोव। किजोकि तैस च़रोक्नी देंती यीशु हेरनेरी इच्छा थी। तैनी तैसेरे बारे मां बेड़ि गल्लां शुनोरी थी, ते तैस बड़ी उमीद थी, कि यीशुएरो कोई चमत्कार हेरे। ");
INSERT INTO bhd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","तैनी यीशुए बड़ू किछ पुच़्छ़ू, पन यीशुए तैस कोई जुवाब न दित्तो। ");
INSERT INTO bhd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","पन याजक ते प्रधान याजक ते कने शास्त्री लोक बड़े ज़ोरे शोरे सेइं यीशु पुड़ इलज़ाम लांने लगे। ");
INSERT INTO bhd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","तैखन हेरोदेस भी अपने सैथन सेइं मिलतां यीशुएरी तुहीन की, ते तैसेरी हासी बनाई फिरी तैस अक चमकतो कुरतो लुवेइतां पिलातुसे कां वापस भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","पेइले पिलातुस त हेरोदेस दुश्मन थिये, तैस दिहाड़े तैना दोस्त बेनि जे। ");
INSERT INTO bhd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","तैखन पिलातुसे प्रधान याजक ते सरदार ते होरे लोक अकोट्ठे किये। ");
INSERT INTO bhd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“ते पिलातुसे तैन सेइं ज़ोवं तुसेईं ए मैन्हु मीं कां एन ज़ोंतो आनोरोए कि, ए लोकन भड़काते ते मिमी एसेरी पुछ़ गन की, पन ज़ैस जुर्मेरो दोष तुस एस पुड़ लातथ, अवं एल्हेरो एसमां कोई कसूर न लेईं। ");
INSERT INTO bhd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ते न हेरोदेस ज़ैनी ए असन कां भेज़ोरोए तैस भी कोई दोष न मैल्लो, ते असन कां एरू कोई सबूत बराँमद न भोवं, ज़ैस सेइं ए कत्ल कियो गाए। ");
INSERT INTO bhd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","तैल्हेरेलेइ अवं एस कोड़ेइं बाएतां छ़ैडी देताईं।” ");
INSERT INTO bhd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","पिलातुस यहूदी केरे फ़सह तिहारेरे मौके पुड़ अक कैदी हथरां छ़डतो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","तैना सारे लोक चिन्डां लगे मारने, “कि एस मैन्हु सज़ा देथ ते बरअब्बा इश्शे लेइ हथरां छ़ड्डा।” ");
INSERT INTO bhd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","बरअब्बा नगर मां गड़बड़ी केरनेरे ते कतलेरे बारे मां पाबंद भोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पिलातुसे यीशु हथरां छ़डनेरे इरादे सेइं लोकन दुबारू पुच़्छ़ू। ");
INSERT INTO bhd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","पन तैना लोक मना चिन्डां लगे मारने, “कि तू एस क्रूसे पुड़ च़ाढ़ एस क्रूस पुड़ च़ाढ़।” ");
INSERT INTO bhd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","तैखन पिलातुसे तैन ट्लेइयोवं फेरे फिरी ज़ोवं, “किजो आखर एनी कुन जुर्म कियोरोए? हेरा एसमां एरू कोई सबूत बराँमद न भोवं, कि ए मौतरे सज़ारो हकदार भोए, तैल्हेरेलेइ अवं एस कुटेइतां छ़ैडी देताईं।” ");
INSERT INTO bhd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","पन तैना चिन्डां मैरी-मैरी ज़ोने लगे, ए क्रूसे पुड़ च़ाढ़ोरो लोड़ते, ते तैन केरि चिन्डां मारनेरी उमीद पूरी भोइ। ");
INSERT INTO bhd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","बस्सा, पिलातुसे ज़ोवं कि तैन केरे मेरज़रे मुताबिक कियूं गाए। ");
INSERT INTO bhd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ते ज़ै मैन्हु हुकुमतरे खलाफ ते खूनेरे जुर्मे मां कैद थियो, ते ज़ैस हथरां छ़डनेरे लेइ तैनेईं दरखुवास कियोरी थी, तै हथरां छ़ड्डो पन यीशु तैन केरि मेर्ज़ी सेइं सिपाही केरे हवाले कियो। ");
INSERT INTO bhd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ज़ैखन तैना यीशु नेइतां च़लोरे थियो, त तैनेईं शमौन कुरेनी ज़ै एक्की ड्लोंवेरां ओरो थियो, ट्लातो ते क्रूस तैस कां छ़ूने जो दित्तू, कि तू ई क्रूसे छ़ुइतां यीशु पत्ती च़ला। ");
INSERT INTO bhd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ते बड़े लोक तैस पत्ती च़लोरे थिये ते किछ कुआन्शां भी थी ज़ैना यीशुएरे लेइ शौग बनैती थी। ");
INSERT INTO bhd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","यीशुए तैन केरे पासे मुड़तां ज़ोवं, “हे यरूशलेम नगरेरी कुइयाव मेरे लेइ लेरां न देथ, बल्के अपने बच्चां केरे लेइ लेरां देथ। ");
INSERT INTO bhd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","किजोकि तैना मुशकिल दिहाड़े एजने बालेन ज़ैखन लोक एन ज़ोले कि, ‘धन आन तैना कुआन्शां ज़ैना बेऔलादन ते बच्चे न पाले।’” ");
INSERT INTO bhd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“तैस वक्ते लोक पहाड़न सेइं ज़ोले, ‘असन उन्ढे बिछ़ड़ा ते उच्ची ठारन जो ज़ोले, कि असन छ़पाथ।’ ");
INSERT INTO bhd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","किजोकि ज़ैखन तैनेईं सब्ज़ बुट्टे सेइं एन केरू, त शुक्कोरे बुट्टे सेइं कुन न केरेले?” ");
INSERT INTO bhd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ते सिपाहेईं दूई होरे मुर्ज़म भी यीशु सेइं साथी च़लवरे थिये ताके तैन भी मारन। ");
INSERT INTO bhd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ज़ैखन तैना तैस ठैरी पुज़े ज़ैस जो “खोपड़ी” ज़ोतन त तैड़ी यीशु क्रूसे पुड़ च़ाढ़ो, ते तैना दूई मुर्ज़मन भी एक्की यीशुएरे देइने पासे ते होरि बांए पासे क्रूसे पुड़ च़ाढ़े। ");
INSERT INTO bhd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","यीशु ज़ोवं, “हे बाजी एन माफ़ करां एन न ज़ानन् कि एना कुन लोरेम केरने।” ते तैनेईं तैसेरे लिगड़ां केरे लेइ पेरची छ़ेडतां शर्त रख्खू ते एप्पू मांमेइं बंटां। ");
INSERT INTO bhd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","लोक खड़खड़े एन सब किछ हेरने लोरे थिये ते सरदार ज़ोरे-ज़ोरे सेइं ज़ोते थिये, “एनी होरे त बच़ाए ते अगर ए मसीहे ते परमेशरेरो च़ुनोरे त अपने आपे किजो न बच़ाए।” ");
INSERT INTO bhd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","सिपाही भी तैस कां एइतां तैसेरी हासी बनाने लगे (किजोकि तै अपनो आप राज़ो बनातो थियो), ते घटया दाछ़ारो रस पीनेरे लेइ तैस देने लगे। ");
INSERT INTO bhd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ते ज़ोते थिये तू अगर यहूदी केरो राज़ोस त अपनो आप बच़ा!” ");
INSERT INTO bhd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ते तैस क्रूसे पुड़ यानी यीशुएरे दोग्गे करां बहा अक पखड़ी लिखतां लेवरी थी, ते तैस पुड़ एन लिखेरू थियूं, “ए यहूदी केरो राज़ आए।” ");
INSERT INTO bhd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","तैन दूई डैकू ज़ैना मारे जे तैन मरां एक्के यीशु जो तुहीन केरतां ज़ोवं, “अगर तू मसीह आस त एप्पू भी बंच़ ते असन भी बच़ा।” ");
INSERT INTO bhd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","पन होरे दुइयोवं डैके तैस जो झ़िड़कतां ज़ोवं, “तीं परमेशरेरो भी डर नईं? ज़ै सज़ा तैस मैलने लावरी तीं भी त तैए सज़ा मैलने लोरीए। ");
INSERT INTO bhd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","असन त इन्साफेरे मुताबिक अपने बुरे कम्मां केरि सज़ा मैलने लोरी पन एनी त कोई गलत कम नईं कियेरू।” ");
INSERT INTO bhd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","तैखन तैनी ज़ोवं, “हे यीशु ज़ैखन तू अपने राज़्ज़े मां एज्जेलो त मीं भी याद केरां।” ");
INSERT INTO bhd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","यीशुए तैस जो ज़ोवं, “अवं तीं सेइं सच़ ज़ोताईं कि तू अज़े मीं सेइं साथी स्वर्गे मां भोलो।” ");
INSERT INTO bhd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","दीसारे 12 बज़ेई सारे मुलखे मां आंधरू भोवं, त ट्लेइ बज़न तगर रावं। ");
INSERT INTO bhd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","दिहाड़ो भी कालो भोव ते मन्दरेरो पड़दो बां देंता बुन तगर फेटतां दूई टुक्ड़े भोइ जे। ");
INSERT INTO bhd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","यीशुए बड़े ज़ोरे सेइं ज़ोवं, “हे बाजी अवं अपनि आत्मा तेरे हथ्थे मां सोंफताईं,” ते एन ज़ोइतां यीशुए प्राण दित्ते। ");
INSERT INTO bhd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ज़ैखन रोमी सूबेदारे एन सब हेरू त परमेशरेरी तारीफ़ केरते ज़ोवं, “ए मैन्हु सच़्च़े धर्मी थियो।” ");
INSERT INTO bhd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ते सारे लोक ज़ैना तैड़ी थिये ए अनर्थ हेरतां छाती पिट्टते च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","पन यीशुएरे सारे दोस्त ते तैना कुआन्शां ज़ैना गलील इलाके मरां यीशुए पत्पती ओरी थी दूर ज़ेरे खेड़ोइतां, ज़ैन किछ भोइ रावरू थियूं सब किछ हेरी रेवरी थी। ");
INSERT INTO bhd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","अक मैन्हु थियो, ज़ेसेरू नवं यूसुफ थियूं, तै यहूदी केरि आदालतरो अक मुलाज़म भी थियो, ते अक बड़ो नेक ते धर्मी मैन्हु थियो। ");
INSERT INTO bhd_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","तै बेड्डी आदालत अफसरां केरे फैसलेरे हके मां न थियो। तै यहूदी केरे नगर अरिमतियाह रानेबालो थियो, ते परमेशरेरे राज़्ज़ेरे तलाशी मां थियो। ");
INSERT INTO bhd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","तैनी पिलातुसे कां गेइतां यीशुएरी लाश मगी। ");
INSERT INTO bhd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ते लाश क्रूसे पुड़ेरां ओसैलतां मलमलेरे कपड़े मां पलेटतां ते एक्की कब्री मां रख्खी, ज़ै एक्की शफ़ड़ी मां बनेवरी थी, तैस कब्री मां पेइले कोई लाश न थी रखोरि। ");
INSERT INTO bhd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","तै तियेरारी दिहाड़ी थी ज़ै आरामेरी दिहाड़ी शुरू भोने बाली थी। ");
INSERT INTO bhd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ते तैना दूई कुआन्शां ज़ैना गलील इलाके मरां यीशुए पत्पती ओरी थी, यूसुफे पत्पती जेई ते तैनेईं तै कब्र हेरी, कि यीशुएरी लाश एसमां केन्च़रे सेइं रखोरीए। ");
INSERT INTO bhd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","तैखन तैना अपने घरे वापस आए, ते खुशबूदार चीज़ां ते इत्र तियार कियो ते आरामेरे दिहाड़े मूसेरे कानूनेरे मुताबिक आराम कियो। ");
INSERT INTO bhd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","हफतेरी पेइले दिहैड़ी झ़ेझां किछ कुआन्शां खुशबूदार चीज़ां नेइतां जेई, ज़ैना तैनेईं तियार कियोरी थी ते एन्तां कब्री कां पुज़ी। ");
INSERT INTO bhd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","पन तैनेईं तै घोड़ कब्री करां बिछ़ड़ोरो लाव। ");
INSERT INTO bhd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ज़ैखन तैना अन्तर जेई त तैन यीशुएरी लाश न मैल्ली। ");
INSERT INTO bhd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","तैखन तैना एन हेरतां परेशान भोइ त दूई मैन्हु ज़ैन छ़ित्तां लिगड़ां लेग्गोरां थियां, तैन कुआन्शन कां एइतां खेड़ोए। ");
INSERT INTO bhd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","तैना कुआन्शां डेरि जेई ते तैना ज़मीनरे पासे तकने लग्गी। तैन मैनेईं तैन जो ज़ोवं, “तुस ज़ींते, मुड़दन मां किजो लोरिथ तोपने। ");
INSERT INTO bhd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","तै इड़ी नईं बल्के ज़ींतो भोरोए तुसन याद नईं कि ज़ेइस तै गलीले मां थियो, त तैनी तुसन ज़ोरू थियूं कि, ");
INSERT INTO bhd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","मैनेरू मट्ठू यानी अवं पापी लोकां केरे हथ्थे देनोए ते क्रूसे पुड़ च़ाढ़नोईं ते फिरी ट्लेइ दिहाड़ां बाद फिरी ज़ींतो भोनोईं।” ");
INSERT INTO bhd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","तैखन तैना यीशुएरी गल्लां याद एई। ");
INSERT INTO bhd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","तैखन तैना कब्री करां च़ेलि जेई, त तैनेईं यीशुएरे 11 चेलन ते बाकी होरि चेलन भी एस गल्लरो पतो दित्तो। ");
INSERT INTO bhd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ज़ैनेईं प्रेरितन सेइं गल्लां की, मरियम मगदलीनी योअन्ना ते याकूबेरी अम्मा मरियम ते तैस सेइं साथी होरि भी काई कुआन्शां थी। ");
INSERT INTO bhd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","पन तैन, तैन केरि गल्लां कहानी लग्गी, ते तैनेईं तैन केरू याकीन न कियूं। ");
INSERT INTO bhd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","पन पतरस उठो ते तै कब्रेरे पासे दौवड़तो तैस ठैरी कां जेव, ते तैड़ी तैनी लिकतां अन्तर तक्कू ते सिर्फ कफन तैड़ी लाव, ते एस गल्ली पुड़ हैरान भोइतां तैट्ठां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","फिरी एरू भोवं कि तैन मरां दूई चेले तैस दिहैड़ी एक्की ड्लोंव्वेरे पासे च़लोरे थिये, तैस ड्लोंव्वेरू नवं इम्माऊस थियूं। तैन यरूशलेम नगरेरां 11 किलोमीटर दूर थियूं। ");
INSERT INTO bhd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","तैना एप्पू मांमेइं एस्से बारे मां गल्लां केरते च़लोरे थिये ज़ै बितना बीतोरी थी। ");
INSERT INTO bhd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ज़ैखन तैना गल्लन मां मसत थिये, ते एप्पू मांमेइं गलबात लोरे थिये केरने त यीशु एप्पू तैन कां नेड़े एइतां तैन सेइं साथी-साथी च़लने लगो। ");
INSERT INTO bhd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","पन तैनेईं यीशु न पिशानो किजोकि परमेशरे तैना पिशान्ने करां रोकोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","यीशुए तैन जो ज़ोवं, “तुस लोक एप्पू मांमेइं कुन गल्लां केरने लोरेथ?” तैना रुकी जे, ते तैन केरू तुतर उदास लेइहोने लग्गू। ");
INSERT INTO bhd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","तैखन तै ज़ेसेरू नवं क्लियुपास थियूं, तैस सेइं ज़ोने लगो, “यरूशलेम नगरे मां सिर्फ तू अक मैन्हु आस ज़ैस पतो नईं कि, आखरी दिहाड़न मां कुन-कुन भोने लोरूए।” ");
INSERT INTO bhd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","यीशुए ज़ोवं, “कुन लोरूए भोने?” तैनेईं तैस सेइं ज़ोवं, “नासरत नगरेरो यीशु, ज़ै नबी थियो, तै परमेशरेरे ते मैन्हु केरे सामने कम्मन मां ते शिक्षा देने मां बेड़ि शेक्ति बालो थियो। ");
INSERT INTO bhd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","तै प्रधान याजकेईं ते हाकिमेईं केन्च़रे सेइं रोमी गवर्नरे हवाले कियो ते तैस जो कतलेरे हुक्म देइतां तै क्रूस पुड़ च़ाढ़ो। ");
INSERT INTO bhd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","पन असन त उमीद थी कि ए मैनूए, ज़ै इस्राएली लोकन रोमेरे राज़्ज़े करां आज़ाद केरेलो, एन गल्लन अज़ ट्लेइयोवं दिहाड़ीए। ");
INSERT INTO bhd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","हुन्ना असन मरां किछ कुआन्शां अज़ झ़ेझां कब्री कां जोरी थी, तैन केरे ज़ोने सेइं असां हैरान भोए। ");
INSERT INTO bhd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ज़ैखन तैन लाश न मैल्ली त तैना एन ज़ोंती एई, असेईं स्वर्गदूत लाए ते तैनेईं ज़ोवं, कि यीशु ज़ींतो भोरोए। ");
INSERT INTO bhd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","तैखन किछ इश्शे साथी भी कब्री कां जे, ते ज़ेन्च़रे कुआन्शेईं ज़ोरू थियूं, तेरहु लाव पन यीशु न लाव।” ");
INSERT INTO bhd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","यीशु तैन दूई चेलन सेइं ज़ोवं, “हे बेअक्ल लोकव! तुश्शे लेइ पवित्रशास्त्र मां नेबी केरि ज़ोरी गल्लन पुड़ भी विश्वास केरनो केत्रो मुशकले। ");
INSERT INTO bhd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","कुन मसीहेरे लेइ ज़रूरी न थियूं, कि दुःख झ़ल्ल्ले ते फिरी अपनि महिमा मां दाखल भोए?” ");
INSERT INTO bhd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","यीशु अपने बारे मां तैना सैरी गल्लां समझ़ेइ, ज़ैना पवित्रशास्त्रे मां मूसा करां देंते सारे नेबेईं ज़ोरिन। ");
INSERT INTO bhd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","एत्रे मां तैना तैस ड्लव्वें नेड़े पुज़े ज़ैड़ी तैनेईं गानू थियूं, तैनेईं बुझ़ू कि यीशु अग्रोवं गानूए। ");
INSERT INTO bhd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","पन तैनेईं एन ज़ोइतां मजबूर कियो, “कि असन कां बिश किजोकि दिहाड़ी डुबोरीए आंधरू भोने बालूए।” बस्सा तै बिशनेरे लेइ तैन सेइं साथी अन्तर च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ज़ैखन तै तैन सेइं साथी रोट्टी खांने बिश्शो त तैनी रोट्टी ट्लाती ते बरकत देइतां ट्लोड़ी ते तैन देने लगो। ");
INSERT INTO bhd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","तैखन तैन केरि एछ़्छ़ी खुल्ली ते तैनेईं तै पिशानो, पन तै तैन करां आलोप भोइ जेव। ");
INSERT INTO bhd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","तैना एप्पू मांमेइं ज़ोने लगे, “ज़ैखन तै बत्तां असन सेइं साथी गल्लां लोरो थियो केरने, ते असन पवित्रशास्त्रेरो मतलब मसमझ़ातो थियो, त असन केरी उमीद भोरी थी।” ");
INSERT INTO bhd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","तैना तैखने तैट्ठां उठे ते यरूशलेम नगरे मां आए ज़ैड़ी तैना यारहे चेले ते होरे तैन केरे साथी एक्की ठैरी मैल्ले। ");
INSERT INTO bhd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","तैना ज़ोने लोरे थिये, “कि प्रभु सच़्च़े ज़ींतो भोरोए ते शमौन पतरसे लाहोरोए।” ");
INSERT INTO bhd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","तैनेईं बत्तरी सैरी गल्लां शुनेई ते फिरी केन्च़रे असेईं यीशु रोट्टी ट्लोड़ते बार पिशानो। ");
INSERT INTO bhd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","तैना गल्लां केरने लोरे थिये त यीशु तैन केरे मझ़ाटे खड़ो भोइतां ज़ोने लगो, “तुसन शान्ति मैल्ले।” ");
INSERT INTO bhd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","पन तैना एत्रे डेरि जे, कि तैना समझ़ने लगे कि असां आत्मा लहने लोरेम। ");
INSERT INTO bhd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","यीशुए तैन सेइं ज़ोवं, “तुस किजो डर्रेथ ते तुश्शे मने मां शक किजो भोतीए। ");
INSERT INTO bhd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","मेरे हथ पाव हेरा अवं तैए आईं, मीं हथ लेइतां हेरा, किजोकि आत्माई हड्डी त कने मास न भोए ज़ेरू तुस मीं मां लातथ।” ");
INSERT INTO bhd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","एन ज़ोंनेरे पत्ती तैनी अपने हथ पाव हिराए। ");
INSERT INTO bhd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","पन खुशी सेइं तैन याकीन न भोवं, कि यीशु ज़ींतोए, ते तैना हैरान भोए, यीशुए तैन सेइं ज़ोवं, “तुसन कां खाने जो किछ आए?” ");
INSERT INTO bhd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","तैनेईं तैस ट्लाड़ोरी मेछ़लरो अक टुकड़ो दित्तो। ");
INSERT INTO bhd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","तैनी ट्लाती ते तैन केरे सामने खाइ। ");
INSERT INTO bhd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","तैनी तैन सेइं ज़ोवं, “ज़ैखन अवं तुसन सेइं साथी थियो, त मीं तुसन एना गल्लां ज़ोरी थी, कि मूसेरे कानूने मां ते नेबी केरि किताबन मां ते भजना केरि किताबी मां मेरे बारे मां ज़ैन किछ लिखोरूए तैन पूरू भोनू ज़रूरीए।” ");
INSERT INTO bhd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","तैखन तैनी तैन केरि मद्दत की, ताके पवित्रशास्त्रे सेमझ़ी सखन। ");
INSERT INTO bhd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ते तैन सेइं ज़ोवं, “एन पवित्रशास्त्र मां लिखोरूए कि मसीह दुःख झ़ैल्लेलो ते ट्लेइयोवं दिहाड़े मुड़दन मरां ज़ींतो भोलो। ");
INSERT INTO bhd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ते तैसेरे नंव्वे सेइं यरूशलेम नगरेरां शुरू केरतां सैरी कौमन मां पापन करां मनफिरानेरे मैफारो प्रचार कियो गालो। ");
INSERT INTO bhd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","किजोकि तुस एना सैरी गल्लां केरे गवाहथ। ");
INSERT INTO bhd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","हेरा, अवं एप्पू तुसन पवित्र आत्मा देइलो, ज़ेसेरो वादो बाजी परमेशरे कियोरोए। पन ज़ां तगर स्वर्गेरां शक्ति न मैल्ले तांतगर इस नगर मां राथ।” ");
INSERT INTO bhd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","फिरी यीशुए तैना नगरेरे बेइर बैतनिय्याह ड्लोंव्वेरे नेड़े ने। ते अपनो हथ खड़ो केरतां तैन बरकत दित्ती। ");
INSERT INTO bhd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ज़ैखन तै तैन बरकत देने लोरो थियो, त तैन करां अलग भोइ जेव ते परमेशरे तै स्वर्गे जो नीयो। ");
INSERT INTO bhd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","चेलेईं तैसेरी आराधना की ते फिरी खुशी सेइं यरूशलेम नगरे जो वापस च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ते तैना हर वक्त मन्दरे मां एइतां परमेशरेरी तारीफ़ केरते थिये।");
INSERT INTO bhd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","(दुनियारे रच़नेरे पेइलो) शुरुआती मां वचन थियूं। तैन वचन परमेशरे सेइं साथी थियूं। तैन वचन परमेशर थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","शुरुआती मां परमेशरे सेइं साथी तैन वचने थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","सब किछ वचनेरे ज़िरिये बनाव जेव। त ज़ैन किछ बनाव ज़ोवं, तैस मरां कोई भी चीज़ तैसेरे बगैर न बनाई जेई। ");
INSERT INTO bhd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","तैस (वचने) मां ज़िन्दगी थी; ते तै ज़िन्दगी सारे मैनन् लौ देचे। ");
INSERT INTO bhd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","त तै लौ आंधरे मां (हमेशा) चमकचे, त आंधरू लोई कधी कैबू न केरि सके। ");
INSERT INTO bhd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","परमेशरेरी तरफां अक मैन्हु भेज़ो जेव, ज़ेसेरू नवं यूहन्ना थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","तै तैस लोअरे बारे मां ज़ोने ओरो थियो, ताके सब लोक तैसेरे ज़िरिये सेइं (तैस लोई पुड़) विश्वास केरन। ");
INSERT INTO bhd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","तै एप्पू लौ न थियो, पन लोअरे बारे मां लोकन गवाही देने ओरो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","सच़्च़ी लौ ज़ै हर एक्की मैन्हु (परमेशरेरे बारे मां ज़ान्नेरी) लौ देचे, तै दुनियाई मां एजनेबाली थी। ");
INSERT INTO bhd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","तैन वचन दुनियाई मां (ओरू) थियूं, त दुनिया तैसेरे ज़िरिये बनाई जेई, पन दुनियारे लोकेईं तैन न पिशानू (कि तै कौन आए)। ");
INSERT INTO bhd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","तै अपने लोकन कां अव, पन तैसेरे अपने लोकेईं तै कबूल न कियो। ");
INSERT INTO bhd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","पन ज़ेत्रे लोकेईं तै कबूल कियो, तैनी तैनन् परमेशरेरे बच्चे भोनेरू हक दित्तू; यानी सारे लोकन ज़ैना तैसेरे नंव्वे पुड़ विश्वास केरतन। ");
INSERT INTO bhd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","तैना न हाज-बव्वे सेइं, न मैन्हु केरे मेर्ज़ी सेइं, न तैस मैनेरे मेर्ज़ी सेइं ज़ै बच्चे पैदा केरनेरी इच्छा रखते, बल्के परमेशरेरे मेर्ज़ी सेइं पैदा भोरेन! ");
INSERT INTO bhd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","तैन वचन मैन्हु बेनतां किछ वक्त असन सेइं साथी रावं, ते (इस दुनियाई मां) डेरो कियो। तैनी असन पुड़ बड़ो अनुग्रह कियो ते परमेशरेरे बारे मां सारी सच़्च़ाई हिराई। (ज़ताली तै इड़ी थियो, तैखन) असेईं तैसेरी महिमा लाई। (ज़ेन्च़रां की) तै अपने बाजी परमेशरे करां अव, त तैसेरी ज़ेरि महिमा कोन्ची मां नईं थी। ");
INSERT INTO bhd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","यूहन्ने तैसेरे बारे मां गवाही दित्ती, ते ज़ोरे सेइं लोकन सेइं ज़ोवं, “ई तै आए, ज़ेसेरे बारे मां मीं ज़ोरू थियूं, कि ज़ै मेरे बाद एज्जी राओरोए, तै मीं करां बड़ो महान आए, किजोकि तै मीं करां पेइलो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","तैसेरी भरपूरी सेइं (यानी, तैसेरे सारे अनुग्रह ते सच़्च़ाई सेइं) असन सेब्भन आशिर्वाद पत्ती आशिर्वाद मैल्लू। ");
INSERT INTO bhd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","मूसा नेबेरे ज़िरिये असन कानून मैल्लो, पन यीशु मसीहेरे ज़िरिये असन कां (परमेशरे करां) अनुग्रह ते सच़्च़ाई पुज़्ज़ी। ");
INSERT INTO bhd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","परमेशर केन्चे कधी भी नईं लावरो, पन तैसेरू अक्के मट्ठू (यीशु) ज़ैन बाजी परमेशरेरे कुम्मे मां आए, तैन्ने असन परमेशर हिराव।” ");
INSERT INTO bhd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यूहन्ने यीशु मसीहेरे बारे मां ई गवाही दित्ती, (एक्सां) ज़ैखन यहूदी लोकां केरे लीडरेईं यरूशलेम नगरेरां यूहन्ना कां किछ याजक त लेवी भेज़े, त तैनेईं तैस पुच्छ़ू, “तू कौन आस?” ");
INSERT INTO bhd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","यूहन्ने तैन सेइं सच़ ज़ोवं ते किछ भी छ़पानेरी कोशिश न की, त तैनी तैन सेइं ज़ोवं, “अवं मसीह नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","तैखन तैनेईं तैस पुच्छ़ू, “फिरी तू कौन आस? कुन तू एलिय्याह नबी आस?” यूहन्ने तैनन् जुवाब दित्तो, “अवं तै नईं।” तैनेईं फिरी पुच्छ़ू, “कुन तू कोई नबी आस?” तैनी जुवाब दित्तो, “नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","तैखन तैनेईं तैस पुच्छ़ू, “फिरी तू कौन आस? (असन ज़ो) ताके अस तैनन् जुवाब देम ज़ैनेईं अस भेज़ोरेम। तू अपने बारे मां कुन ज़ोतस?” ");
INSERT INTO bhd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","तैनी जुवाब दित्तो, “ज़ेन्च़रे यशायाह नेबे (मेरे बारे मां) ज़ोरूए, तेन्च़रे अवं सुनसान ठैरी मां लोकन हक देइतां ज़ोताईं कि, ‘तुसन कां प्रभु एजनेबालो आए, तैसेरेलेइ बत तियार केरा।’ (यानी, प्रभुएरे लेइ तुस अपने दिल साफ केरा)” ");
INSERT INTO bhd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","फरीसी लोकां केरे तरफां किछ मैन्हु यूहन्ना कां भेज़ोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","तैनेईं यूहन्ना पुच्छ़ू, “अगर तू न मसीह आस, न एलिय्याह, त न नबी, त फिरी (तीं कुन अधिकार आए) लोकन बपतिस्मो किजो देतस?” ");
INSERT INTO bhd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","यूहन्ने जुवाब दित्तो, “अवं त (लोकन) पैनी सेइं बपतिस्मो देताईं, पन तुसन सेइं साथी रानेबालो अक एरो आए, ज़ैस तुस हकीक्ति मां न पिशानथ। ");
INSERT INTO bhd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ई तै आए, ज़ै मेरे बाद एजनेबालो आए, तै मीं करां महान आए। अवं त तैसेरो गुलाम भोनेरे काबल भी नईं कि तैसेरे बूटेरे तसमे खोल्ली।” ");
INSERT INTO bhd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","एना गल्लां, यरदन दरियारे पार बैतनिय्याह नगरे मां भोइ, ज़ैड़ी यूहन्ना लोकन बपतिस्मो देतो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","एग्री दिहाड़े यूहन्ने यीशु अपने पासे एइतो लाव, त तैनी यीशुएरे बारे मां लोकन सेइं ज़ोवं, “तक्का, परमेशरे तरफां भेज़ोरू (बलिदानेरू) गबड़ू, ज़ैन सैरी दुनियारे लोकां केरे पाप नेते! ");
INSERT INTO bhd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ई तै आए, ज़ेसेरे बारे मां मीं ज़ोरू थियूं कि, ‘अक मैन्हु मेरे बाद एजनेबालो आए, ज़ै मीं करां बड़ो महान आए, किजोकि तै मीं करां पेइलो थियो।’ ");
INSERT INTO bhd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","हुन्ना तगर अवं त एप्पू भी तैस पिशानतो न थियो। पन एल्हेरेलेइ अवं (इड़ी) एजतां लोकन पैनी सेइं बपतिस्मो देताईं, ताके तै मैन्हु इस्राएलेरे लोकन मां बांदो भोए।” ");
INSERT INTO bhd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","तैखन यूहन्ने लोकां केरे सामने गवाही दित्ती, “मीं पवित्र आत्मा कबूतरेरे शकली मां अम्बरेरां एइतो लाव, ते तै तैस पुड़ बिश्शो। ");
INSERT INTO bhd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","अवं त एप्पू पिशानतो न थियो कि यीशु हकीक्ति मां कौन थियो, पन परमेशरे ज़ैनी अवं लोकन पैनी सेइं बपतिस्मो देने भेज़ो, तैनी मीं सेइं ज़ोवं, ‘ज़ैस पुड़ तू पवित्र आत्मा एइतो त बिश्तो लाएलो, तैए लोकन पवित्र आत्मा सेइं बपतिस्मो देनेबालो आए।’ ");
INSERT INTO bhd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","तै मीं लाव, त अवं तुसन गवाही देताईं, कि ए मैन्हु परमेशरेरू मट्ठू आए!” ");
INSERT INTO bhd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","दुइयोवं दिहाड़े, फिरी यूहन्ना त तैसेरे चेलन मरां दूई तैड़ी खड़े भोरे थिये, ");
INSERT INTO bhd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","त यीशु तैलमेइं च़लोरो थियो। ज़ैखन यूहन्ने यीशु लाव, त तैनी यीशुएरे बारे मां अपने चेलन सेइं ज़ोवं, “तक्का, इन परमेशरे तरफां भेज़ोरू (बलिदानेरू) गबड़ू आए!” ");
INSERT INTO bhd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ज़ैखन यूहन्नारे दुइये चेलेईं एन शुनू, त तैना यीशु पत्ती च़ले। ");
INSERT INTO bhd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","यीशुए बेदलोइतां तैना एइते लाए ते तैन पुच्छ़ू, “तुस केस लगोरेथ तोपने?” तैनेईं ज़ोवं, “हे गुरू, तू कोड़ि रातस?” ");
INSERT INTO bhd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","तैनी तैन ज़ोवं, “च़ला तुस एप्पू हेरेले।” तैखन तैनेईं गेइतां तैसेरे रानेरी ठार हेरी, ते तैस दिहाड़े तैना तैस साथी राए। तै कोई ड्लोझ़ी च़ेव्रे बज़ां केरो मौको थियो। ");
INSERT INTO bhd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","तैन दूई चेलन मरां, ज़ैना यूहन्नेरी गल्लां शुन्तां यीशु पत्ती च़लोरे थिये, अक अन्द्रियास थियो, ज़ै शमौन-पतरसेरो ढ्ला थियो। ");
INSERT INTO bhd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","तैनी पेइलू एन कम कियूं कि अपने ढ्ला शमौन-पतरस तोप्तां तैस सेइं ज़ोवं, “असन मसीह मैलोरोए!” ");
INSERT INTO bhd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","तैखन अन्द्रियासे यीशु कां शमौन आनो। यीशुए तैसेरे पासे तक्कू ते ज़ोवं, “तू यूहन्नेरू मट्ठू शमौन आस। पन अज़्ज़ेरे बाद तेरू नवं कैफा भोलू।” यूनानी भाषाई मां कैफारो मतलब “पतरस” आए। (एसेरो मतलब घोड़।) ");
INSERT INTO bhd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","होरसां दुइयोवं दिहाड़े यीशुए गलील इलाके मां गानू चाव। तैनी फिलिप्पुस लेइतां तैस सेइं ज़ोवं, “मीं सेइं साथी च़ल (ते मेरो चेलो बन)।” (फिलिप्पुस यीशु सेइं साथी च़लो।) ");
INSERT INTO bhd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","फिलिप्पुस बैतसैदा नगरे मां रातो थियो, ज़ैड़ी अन्द्रियास त पतरस भी राते थिये। ");
INSERT INTO bhd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","तैल्ला पत्ती फिलिप्पुस गेइतां नतनएले सेइं मिलो त ज़ोने लगो, “असन मसीह मैलोरोए, ज़ेसेरे बारे मां (बड़े पेइले) मूसेरे कानूने मां लिखोरोए त कने नेबेईं भी अपनि किताबी मां लिखोरोए। तै यूसुफेरू मट्ठू नासरत नगरे बालो यीशु आए, ज़ै नासरत नगरेरो आए!” ");
INSERT INTO bhd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नतनएले तैस सेइं ज़ोवं, “कुन नासरते मरां कोई रोड़ी चीज़ निस्सी सकतीए?” फिलिप्पुसे ज़ोवं, “एइतां एप्पू हेर।” (त नतनएल फिलिप्पुसे सेइं साथी च़लो।) ");
INSERT INTO bhd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","यीशुए नतनएल अपने पासे एइतो लाव ते तैनी तैसेरे बारे मां एन ज़ोवं, “ई असली इस्राएली मैन्हु आए, एसमां कोई पाखंड नईं!” ");
INSERT INTO bhd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नतनएले यीशु पुच्छ़ू, “तू मीं केन्च़रे ज़ानतस?” यीशुए तैस जुवाब दित्तो, “फिलिप्पुस तीं कुजाने करां पेइले ज़ैखन तू फ़ेगेरे बुट्टे हैठ थियो, मीं तू तैड़ी लावरो थियो।” ");
INSERT INTO bhd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","तैखन नतनएले ज़ोवं, “हे गुरू, (हुन्ना अवं ज़ानतां कि) तू परमेशरेरू मट्ठू आस! तू इस्राएल लोकां केरो राज़ो आस!” ");
INSERT INTO bhd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","यीशुए तैस जुवाब दित्तो, “कुन तू मीं पुड़ एल्हेरेलेइ विश्वास केरतस कि मीं तीं सेइं एन ज़ोवं, कि मीं तू फ़ेगेरे बुट्टे हैठ लावरो थियो? तू इस करां भी बेड्डी-बेड्डी गल्लां लाएलो!” ");
INSERT INTO bhd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","फिरी तैल्ला पत्ती यीशुए ज़ोवं, “अवं तुसन सेइं सच़-सच़ ज़ोताईं कि, तुस स्वर्ग खुल्लू त कने परमेशरेरे स्वर्गदूतन उबरे गाते त मैनेरे मट्ठे पुड़, यानी मीं पुड़ उतरते लाएले।” ");
INSERT INTO bhd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","तैल्ला पत्ती, ट्लेइयोवं दिहाड़े गलील इलाकेरे काना नगरे मां केन्चेरो ड्ला थियो। यीशुएरी अम्मा भी तैड़ी थी। ");
INSERT INTO bhd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","यीशु ते तैसेरे चेलन भी धाम कियोरी थी। ");
INSERT INTO bhd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ज़ैखन दाछ़ेरो रस मुक्को, त यीशुएरी अम्मा तैस सेइं लगी ज़ोने, “एन कां दाछ़ेरो रस मुकोरोए।” ");
INSERT INTO bhd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","यीशु लगो ज़ोने, “अम्मा, मीं तीं सेइं कुन कम? हेजू मेरो वक्त नईं ओरो।” ");
INSERT INTO bhd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","तैसेरे अम्मा नौकरन सेइं ज़ोवं, “ज़ैन किछ यीशु तुसन सेइं ज़ोए, तैन्ने केरथ।” ");
INSERT INTO bhd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","तैड़ी नेड़े घोड़ां केरे शा (बड्डे) घड़े रखोरे थिये, ज़ैन मां दूई-दूई ट्लाई-ट्लाई मन (पानी) लगतू थियूं। यहूदी लोक अपने रुवाज़ेरे मुताबिक (अपने आपे त कने चीज़न) धोनेरे लेइ एन घड़े (मां पानी भेरतां) इस्तेमाल केरते थिये। ");
INSERT INTO bhd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","यीशुए नौकरन सेइं ज़ोवं, “घड़न मां पानी भरा।” तैनेईं पूरे घड़े भरे। ");
INSERT INTO bhd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","तैखन यीशुए तैन सेइं ज़ोवं, “हुन्ना, घड़े मरां किछ पानी केढतां धामारे प्रधाने कां (च़खनेरे लेइ) देथ। तैनेईं तैस कां नेव। ");
INSERT INTO bhd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ज़ैखन धामारे प्रधाने तैन पानी च़ख्खू, ज़ैन दाछ़ेरो रस बनोरू थियूं, तै न थियो ज़ानतो कि एन कोट्ठां ओरूए, पन नौकर ज़ानते थिये, ज़ैनेईं तैन केढतां आनेरू थियूं। एल्हेरेलेइ धामारे प्रधाने लाड़ो कुजाव, ते तैस सेइं ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","‘हर कोई मैन्हु (आम तौरे, धामी मां) पेइलो रोड़ो दाछ़ारो रस देते, त ज़ैखन लोक पीतां रज़्ज़तन, त बादे मां घट रोड़ो ज़ेरो दाछ़ारो रस देते, पन तीं रोड़ो हेजू पत्रोवं रखोरो थियो!’” ");
INSERT INTO bhd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","गलील इलाकेरे काना नगरे मां यीशुए पेइलो चमत्कार कियो। एन केरतां तैनी अपनि महिमा बांदी की, त तैसेरे चेलेईं तैस पुड़ (होरो भी जादे) विश्वास कियो कि तै मसीह आए। ");
INSERT INTO bhd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","तैल्ला पत्ती यीशु त तैरेरी अम्मा ते तैसेरे ढ्ला ते कने तैसेरे चेले कफरनहूम नगरे मां जे, ते किछ दिहाड़े तैड़ी राए। ");
INSERT INTO bhd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ज़ेइस यहूदी लोकां केरू फ़सह तिहार नेड़े अव, त यीशु यरूशलेम नगरे जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","त तैड़ी मन्दरेरे अंगने मां तैनी (बलिदानेरे लेइ) दांत, भैड्डां त कबूतर बेच़ने बाले लाए त कने पेंइसे बदलनेबाले भी अपने मेज़न पुड़ बिश्शोरे लाए। ");
INSERT INTO bhd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","तैखन तैनी रेस्सरो अक कोड़ो बनेइतां, तैनन् सेब्भन त भैड्डां त दांत मन्दरे मरां बेइर कढे, त बुपारी केरे पेंइसे (इरां उरां) शारे, त तैन केरे मेज़ उलटाए। ");
INSERT INTO bhd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","त कबूतर बेच़नेबालन सेइं ज़ोवं, “इना इट्ठां नेइ गाथ! मेरे बाजी केरे मन्दरे बुपारी लोकां केरू घर न बनाथ!” ");
INSERT INTO bhd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ज़ैखन तैसेरे चेलेईं एन शुनू, त तैनन् याद अव कि (परमेशरेरी किताबी मां) लिखोरूए कि (मसीहे परमेशरे सेइं ज़ोवं) “तेरे घरेरे लेइ मेरी भक्ति, (हे परमेशर) मेरे अन्तर अगारी ज़ेरि ज़लतीए!” ");
INSERT INTO bhd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","तैखन यहूदी लोकां केरे किछ लीडरेईं तैस सेइं ज़ोने लग्गे, “तू असन कोई निशान (चमत्कार) हिरा कि मन्दरेरे अंगने मरां लोकन कढनेरे लेइ तीं कां परमेशरेरे तरफां अधिकार आए?” ");
INSERT INTO bhd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","यीशुए तैन जुवाब दित्तो, “एस मन्दरे डोला, ते अवं ट्लेइ दिहैड़न मां एस (दुबारो) बनेइलो।” ");
INSERT INTO bhd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","यहूदी लोकेईं यीशु जुवाब दित्तो, “कुन इस मन्दरे बन्ने मां 46 साल लगोरेन, कुन तू एस ट्लेइ दिहैड़न मां (दुबारो) बनेइ सकतस?” ");
INSERT INTO bhd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","तैनेईं गलत समझ़ू यीशुए ज़ैस मन्दरेरी गल कियोरी थी, तै तैसेरी अपनि जान थी। ");
INSERT INTO bhd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","एल्हेरेलेइ (बादे मां) ज़ैखन यीशु (क्रूसे पुड़ मरो त) मुड़दन मरां ज़ींतो भोव, त तैखन तैसेरे चेलन याद अवं कि यीशुए (अपने मौत त कने ज़ींतो भोनेरे बारे मां) असन ई गल ज़ोरी थी। त (एसेरे वजाई सेइं) तैनेईं पवित्रशास्त्रे मां लिखोरी गल्लन पुड़ त कने यीशु मसीहेरी ज़ोरी गल्लन पुड़ होरो भी जादे विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ज़ताली यीशु फ़सह तिहारेरे मौके यरूशलेम नगरे मां थियो, त बड़े लोकेईं तैसेरे चमत्कार, ज़ैना तैनी किये, लेइतां तैस पुड़ विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","पन फिरी भी यीशुए तैन पुड़ अतबार न कियो, किजोकि तै सेब्भी केरो इन्सानी सोच ज़ानतो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","तैस ए ज़रूरत न थी कि कोई मैन्हु तैस केन्ची होरि मैनेरे बारे मां ज़ोए, किजोकि तै (पेइले) मैन्हु केरि सोच ज़ानतो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","फरीसी लोकन मां अक मैन्हु थियो ज़ेसेरू नवं नीकुदेमुस थियूं। तै यहूदी लोकां केरो अक लीडर थियो। ");
INSERT INTO bhd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","एक्की राती तै यीशु कां एइतां ज़ोने लगो, “हे गुरू, अस ज़ानतम कि तू परमेशरेरी तरफां गुरू भोइतां ओरोस; किजोकि ज़ैना चमत्कार तू हेरातस, होरो कोई न हेरेई सके, ज़ांतगर परमेशर तैस सेइं साथी न भोए।” ");
INSERT INTO bhd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","यीशुए जुवाब दित्तो, “अवं तुसन सेइं सच़-सच़ ज़ोतां कि ज़ांतगर कोई मैन्हु दुबारो ज़र्म न घिन्ने, त तै परमेशरेरू राज़ न लेई सके।” ");
INSERT INTO bhd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","नीकुदेमुस पुच्छ़ने लगो, “ज़ैखन मैन्हु बुढो भोते, त तै केन्च़रे सेइं दुबारो पैदा भोइ सकते? कुन तै अम्मारे पेटे मां गेइतां दुबारो ज़ेरमी सकते?” ");
INSERT INTO bhd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","यीशुए जुवाब दित्तो, “अवं तुसन सेइं सच़-सच़ ज़ोताईं कि ज़ांतगर कोई मैन्हु पैनी सेइं ते आत्माई सेइं पैदा न भोए, तै परमेशरेरे राज़्ज़े मां दाखल न भोइ सके। ");
INSERT INTO bhd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","किजोकि हाज-बव अपने बच्चन सिर्फ एस जानेरी ज़िन्दगी देइ सकतन, पन सिर्फ (पवित्र) आत्मा लोकन आत्मिक ज़िन्दगी देइ सकते। ");
INSERT INTO bhd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","हैरान न भो कि मीं तीं सेइं कुन ज़ोवं कि, ‘तीं दुबारो ज़र्म घिन्नू ज़रूरीए।’ ");
INSERT INTO bhd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","हवा ज़ेरां च़लनू चातीए तैरां च़लचे, त तू तैसारी आवाज़ त शुनतस, पन एन न ज़ानस कि तै कोट्ठां एइचे त कोरां गाचे। तेन्च़रे कोई भी न हेरी सके त न समझ़ी सके कि केन्च़रां पवित्र आत्मा लोकन (नव्वीं) ज़िन्दगी देते।” ");
INSERT INTO bhd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","तैखन नीकुदेमुसे पुच्छ़ू, “एना गल्लां केन्च़रे सेइं भोइ सेकतिन पवित्र आत्मा केन्च़रां लोकन नव्वीं आत्मिक ज़िन्दगी देते?” ");
INSERT INTO bhd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","यीशुए तैस सेइं ज़ोवं, “तू इस्राएली लोकां केरो (अक खास) गुरू भोइतां भी कुन इना गल्लां न समझ़स? ");
INSERT INTO bhd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","अवं तीं सेइं सच़-सच़ ज़ोताईं, ज़ैन अस ज़ानतम तैन्ने (लोकन) ज़ोतम, त ज़ैन असेईं लावरूए तैसेरे बारे मां (लोकन) गवाही देतम, पन फिर भी तुस लोक इश्शी गवाही न मन्नथ। ");
INSERT INTO bhd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","मीं त तुसन सेइं धेर्तारी गल्लां केरे बारे मां गल की, त तुसेईं (मीं पुड़) विश्वास न कियूं, त अगर अवं स्वर्गेरी गल्लां ज़ोईं त तुस केन्च़रे विश्वास केरेले? ");
INSERT INTO bhd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","(स्वर्गेरी गल्लां ज़ान्नेरे लेइ कधी) कोई मैन्हु स्वर्गे मां नईं जोरो, सिर्फ तैए ज़ै स्वर्गेरां ओरो, यानी अवं मैनेरू मट्ठू ज़ैन स्वर्गे मां आईं। ");
INSERT INTO bhd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ज़ेन्च़रे मूसा सुनसाने मां (परमेशरेरे लोकन बच़ानेरे लेइ पितल सेइं बनोरो) सप (खंभे पुड़) उच्चे पुड़ च़ढ़ाव, तेन्च़रे एन ज़रूरी आए कि (अवं) मैनेरू मट्ठू भी उच्चे पुड़ च़ाढ़ू गाए। ");
INSERT INTO bhd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ताके ज़ै कोई तैस पुड़ विश्वास केरे, तैस हमेशारी ज़िन्दगी मैल्ले।” ");
INSERT INTO bhd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“किजोकि परमेशरे दुनियारे लोकन सेइं एत्रो प्यार कियो कि तैनी अपनू अक्के मट्ठू दित्तू, ताके ज़ै कोई तैस पुड़ विश्वास केरे, तै नाश न भोए, बल्के हमेशारी ज़िन्दगी हासिल केरे। ");
INSERT INTO bhd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","किजोकि परमेशरे अपनू मट्ठू दुनियाई मां एल्हेरेलेइ नईं भेज़ोरू कि तै दुनियारे लोकन (तैन केरे पापां केरि) सज़ा दे, बल्के एल्हेरेलेइ कि दुनियारे लोक तैसेरे ज़िरिये सेइं (पापां केरि सज़ाई करां) मुक्ति हासिल केरन। ");
INSERT INTO bhd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ज़ै तैस पुड़ विश्वास केरते, तैस सज़ा न मैल्ले। पन ज़ै मट्ठे पुड़ विश्वास न केरे, तै पेइलोए दोषी भोइ जोरोए, किजोकि तैनी परमेशरेरे अकैल्ले मट्ठेरे नंव्वे पुड़ विश्वास नईं कियोरो। ");
INSERT INTO bhd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","परमेशर लोकन सज़ा देनेरी वजा ई आए कि ज़ैस जो लौ ज़ोतन तै दुनियाई मां ओरिए, परमेशरे अपनि लौ दुनियाई मां भेज़ी, पन लोक ते कने तैन केरां कम्मां बुरां थियां, एल्हेरेलेइ तैनेईं तैस लोई करां जादे पापेरू आंधरू पसंद कियूं। ");
INSERT INTO bhd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ज़ै कोई बुरू कम केरते, तै लोई सेइं नफरत केरते त लोअरे नेड़े न एज्जे, एरू न भोए कि तैसेरे कम्मन पुड़ दोष लाव गाए। ");
INSERT INTO bhd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","पन हर कोई ज़ै परमेशरेरी सच़्च़ाई पुड़ च़लते, तै लोई कां एइते, ताके लोई सेइं बांदो भोए कि तैसेरे सब कम्मां परमेशरेरी शक्ति सेइं साथी किये गातन।” ");
INSERT INTO bhd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","एना गल्लां केरे बाद यीशु त तैसेरे चेले यहूदिया इलाके मां आए, त तैड़ी रेइतां लोकन बपतिस्मो देने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","यूहन्ना भी शालेम नगरेरे नेड़े ऐनोन नंव्वेरे ठैरी लोकन बपतिस्मो देतो थियो। किजोकि तैड़ी हच्छु पानी थियूं त लोक बपतिस्मो नेनेरे लेइ तैस कां एइते राते थिये। ");
INSERT INTO bhd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","किजोकि यूहन्ना हेजू कैदखाने मां न थियो छ़ड्डोरो। ");
INSERT INTO bhd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","एक्सां यूहन्नारे चेलां केरि केन्ची यहूदी मैन्हु सेइं (रुवाज़ेरे मुताबिक) शुद्ध भोनेरे बारे मां बेंस भोइ। ");
INSERT INTO bhd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","एल्हेरेलेइ यूहन्नारे चेले तैस कां एइतां ज़ोने लग्गे, “हे गुरू, (तीं पतो आए) तै मैन्हु ज़ै यरदन दरियारे पार तीं सेइं साथी थियो त कने तीं तैसेरे बारे मां गवाही दित्तोरी थी, हेर, तै भी लोकन बपतिस्मो देते त सब लोक तैस कां गातन!” ");
INSERT INTO bhd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","यूहन्ना जुवाब दित्तो, “(तै रोड़ी गल आए, किजोकि) मैन्हु किछ न हासिल केरि सके, ज़ांतगर तैस स्वर्गेरां (यानी परमेशरे करां) न मैल्ले। ");
INSERT INTO bhd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","तुस एप्पू मेरे गवाह आथ, कि मीं तुसन सेइं ज़ोरू थियूं कि अवं मसीह नईं, पन अवं तैस करां पेइले (परमेशरेरां तरफां) भेज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ज़ेसेरी महरनीए त तै महरावे, पन महरावेरो दोस्त ज़ै खड़ोए महरावेरी हर गल खुशी सेइं शुनतो रहते; हुनी मेरी ई खुशी पूरी भोइ। (कि सब लोक तैस कां गातन)। ");
INSERT INTO bhd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","एन ज़रूरीए कि तै बधै ते अवं घैटी।” ");
INSERT INTO bhd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“(मसीह) ज़ै स्वर्गेरां एइते तै होरि सेब्भन करां महान भोते। त ज़ै मैन्हु धेरती पुड़ेरां भोते, तै धेर्तारोए त धेर्तारी गल्लां केरते। ज़ै स्वर्गेरां एइते तै सेब्भना उच्चो महान भोते। ");
INSERT INTO bhd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","तैनी (परमेशरे तरफां) ज़ैन किछ लाव ते शुनेरू, तैसेरे बारे मां लोकन शुनाते, पन तैसेरी गवाही कोई न शुने। ");
INSERT INTO bhd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ज़ै कोई तैसेरी गवाही पुड़ विश्वास केरते, तै तैसेरी तसदीक केरते कि परमेशर सच़्च़ो आए। ");
INSERT INTO bhd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","किजोकि (मसीह) ज़ै परमेशरे भेज़ोरोए, तै परमेशरेरी गल्लां ज़ोते, किजोकि परमेशर तैस पवित्र आत्मा नैपतां न दे। ");
INSERT INTO bhd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","(परमेशर) बाजी मट्ठे सेइं प्यार रखते, त तैनी सब किछ तैसेरे हावाले कियोरूए। ");
INSERT INTO bhd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ज़ै (परमेशरेरे) मट्ठे पुड़ विश्वास केरते तैस हमेशारी ज़िन्दगी मैलचे, पन ज़ै मट्ठे पुड़ विश्वास न केरे तै ज़िन्दगी करां दूर रालो, ते तैस पुड़ परमेशरेरो क्रोध (हुन्ना करां लेइतां हमेशा) राते।” ");
INSERT INTO bhd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","फिरी ज़ैखन प्रभु पतो लगो कि फरीसी लोकेईं शुनोरूए, यीशु, यूहन्ना करां जादे चेले बनाते ते बपतिस्मो देते। ");
INSERT INTO bhd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(हालांकी सच़ एन थियूं यीशु एप्पू नईं बल्के तैसेरे चेले बपतिस्मो देते थिये), ");
INSERT INTO bhd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","तैखन तैना यहूदिया इलाके शैरतां गलील इलाके जो च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ते तैसेरू सामरिया इलाके मांमेइं भोइतां गानू ज़रूरी थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","एल्हेरेलेइ तै सामरिया इलाकेरे सूखार नगर मां अव, तै ठार तैस ज़मीनरे नेड़े थी ज़ै याकूबे अपने मट्ठे यूसुफे दित्तोरी थी। ");
INSERT INTO bhd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","याकूबे ज़ैन खुह बनोरू थियूं तैन तैड़ी थियूं, ते यीशु सफर केरतां थकोरो थियो, ते तैस खुहे पुड़ बिश्शो। तैखन दुपाहरां केरो मौको थियो। ");
INSERT INTO bhd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","एत्रे मां अक सामरी कुआन्श तैड़ी पानी भरने आई। यीशुए तैस जो ज़ोवं, “मीं पानी पीया।” ");
INSERT INTO bhd_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","किजोकि तैसेरे चेले रोट्टी आन्नेरे लेइ नगर मां जोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","तैस सैमरी कुआन्शां तैस जो ज़ोवं, “तू यहूदिस ते अवं त सामरी, तू मीं पानी पीयानेरे लेइ किजो ज़ोतस?” किजोकि यहूदी सैमरन सेइं मिलनू जुलनु न थिये सुखाते। ");
INSERT INTO bhd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","यीशुए तैस जुवाब दित्तो, “अगर तू ज़ानेथी कि परमेशर तीं कुन देनू चाते, त एन भी ज़ानेथी कि, तीं करां कौन पानी मगने लोरोए, त तू तैस करां मगेथी, ते तै तीं ज़िन्दगरू पानी देथो।” ");
INSERT INTO bhd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","तैस कुआन्शां ज़ोवं, “हे प्रभु, तीं कां पानी भरनेरे लेइ कोई भांड नईं, ते खुह बड़ू डुघू आए, ते तीं ज़िन्दगरू पानी कोट्ठां मैल्लू? ");
INSERT INTO bhd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","कुन तू इश्शे पूर्वज याकूबे करां भी बड्डोस, ज़ैनी एन खुह असन दित्तेरूए, ते तैनी एप्पू भी ते तैसेरी औलादां ते तैसेरे गोरू गब्बेइं भी एस्से मरां पिव?” ");
INSERT INTO bhd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","यीशुए तैस जुवाब दित्तो, “ज़ै कोई एस खुहे मरां पियेलो तैस फिर भी ट्लिश रानीए। ");
INSERT INTO bhd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","पन ज़ै कोई तैन पानी पीते ज़ैन अवं देताईं तै हमेशारे लेइ ट्लिशोरो न रालो, बल्के ज़ैन पानी अवं तैस देलो तैन तैस मां अक नाग बनेलो ज़ै पानी देतो रालो, ज़ैस सेइं तैस हमेशारी ज़िन्दगी मैलेली।” ");
INSERT INTO bhd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","तैस कुआन्शां यीशु जो ज़ोवं, “हे प्रभु, मीं भी तैन पानी दे ताके मीं ट्लिश न लग्गे ते मीं बार-बार पानी भरने इस खुहे पुड़ न एजनू पे।” ");
INSERT INTO bhd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","यीशुए तैस जो ज़ोवं, “गा, अपनो मुन्श कुजा।” ");
INSERT INTO bhd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","तैसां कुआन्शां जुवाब दित्तो, “मेरो कोई मुन्श नईं।” यीशुए तैस जो ज़ोवं, “तीं सच़ ज़ोवं, ‘कि मेरो कोई मुन्श नईं।’ ");
INSERT INTO bhd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","किजोकि तीं पंच़ मुन्श बनोरेन ते ज़ैस सेइं साथी तू हुन्ना आस, तै तेरो मुन्श नईं, तीं ज़ैन किछ ज़ोवं तैन सच़्च़े ज़ोरूए।” ");
INSERT INTO bhd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","तैस कुआन्शा ज़ोवं, “हे प्रभु, मीं लग्गते तू कोई नबी आस। ");
INSERT INTO bhd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","इश्शे दादे-पड़दादेईं इस पहाड़े पुड़ आराधना की, पन तुस यहूदी लोक ज़ोतथ कि ज़ैड़ी आराधना कियोरी लोड़चे, तै ठार सिर्फ यरूशलेम आए।” ");
INSERT INTO bhd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","यीशुए तैस कुआन्शी जो ज़ोवं, “हे कुआन्श, मेरी गल्लरो विश्वास केर, कि तै मौको भी एज्जी राहोरोए, कि तुस लोक बाजी केरि आराधना न त इस पहाड़े पुड़ केरेले ते न यरूशलेमे मां केरेले। ");
INSERT INTO bhd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","तुस सामरी लोक ज़ेसेरी आराधना केरतथ तैस न ज़ानथ, पन अस यहूदी लोक ज़ेसेरी आराधना केरतम तैस ज़ानतम, किजोकि मुक्ति यहूदन मरां आए। ");
INSERT INTO bhd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","पन तै मौको एज्जी राहोरोए बल्के ओरोए, ज़ैखन सच़्च़े भक्त बाजेरी आराधना आत्मा ते सच़ैई सेइं केरेले, किजोकि बाजी एरे ज़ेरे सच़्च़े भक्त तोपते। ");
INSERT INTO bhd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","परमेशर आत्मा आए, एल्हेरेलेइ तैसेरे भक्त तैसेरी आराधना आत्मा ते सच़्च़ैई सेइं केरन।” ");
INSERT INTO bhd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","कुआन्शां तैस सेइं ज़ोवं, “अवं ज़ानती कि मसीह, ज़ैस जो ख्रिस्त ज़ोतन एजनेबालोए, ज़ैखन तै एज्जेलो तै सब किछ समझ़ालो।” ");
INSERT INTO bhd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","तैखन यीशुए ज़ोवं, “अवं ज़ै तीं सेइं गल्लां लगोरोइं केरने तैए मसीह आईं।” ");
INSERT INTO bhd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","एत्रे मां तैसेरे चेले आए ते तैनेईं तै एक्की कुआन्शी सेइं गल्लां केरतो लेइतां हैरान राए, पन केन्चे तैस एन न पुच़्छ़ू, “तू कुन चातस?” या “एस कुआन्शी सेइं किजो गल्लां लगोरोस केरने?” ");
INSERT INTO bhd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तै कुआन्श पैनेरो घड़ो तैड़ी छ़ेडतां वापस नगर मां जेई ते मैनन् सेइं ज़ोने लगी। ");
INSERT INTO bhd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“एज्जा, एक्की मैन्हु सेइं मिला तैनी मीं सेइं सब किछ ज़ोवं ज़ैन मीं अज़ तगर कियेरू थियूं, कुन ए तै मसीह त नईं?” ");
INSERT INTO bhd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","तैना मैन्हु नगर मरां निस्तां यीशु हेरनेरे लेइ तैसेरे पासे च़लने लगे। ");
INSERT INTO bhd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","यीशुएरे चेले तैस कां मिनत केरने लग्गे, “हे गुरू, रोट्टी खा।” ");
INSERT INTO bhd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","पन यीशुए तैन सेइं ज़ोवं, “मीं कां खानेरे लेइ अक एरी रोट्टी आए, पन तुसन तैसेरे बारे मां कोई पतो नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","तैखन चेले एप्पू मांमेइं ज़ोने लगे, “कुन केन्चे पेइलू एसेरे लेइ किछ खाने जो आनोरूए?” ");
INSERT INTO bhd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","यीशुए तैन सेइं ज़ोवं, “मेरी रोट्टी ईए कि, परमेशरेरी मर्ज़ी पूरी केरि ज़ैनी अवं भेज़ोरोईं ते तैन कम पूरू केरि ज़ैन तैनी दित्तोरूए। ");
INSERT INTO bhd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","कुन तुस न ज़ोथ कि, फसल पकने हेजू च़ेव्रे महीन्न बाकिन? अवं तुसन जो ज़ोताईं कि, अपनि एछ़्छ़ी घाड़ा! ते एजनेबाले मैनन् हेरा, ज़ैना पक्कोरे ऊडारां केरि फसलारे ज़ेरे आन। ");
INSERT INTO bhd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","फसल कटने बालन कम केरतां मज़दूरी मैल्ली राओरीए, यानी तैना लोकन अकोट्ठे केरि राओरेन ज़ैना लोकन हमेशारी ज़िन्दगी हासिल केरेले, ताके ज़ै बेते ते कटते साथी खुशी मनान। ");
INSERT INTO bhd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","एल्हेरेलेइ अक कहावते कि बेनेबालो कोईए ते कटने बालो होरो कोईए, तैन सच़्च़े। ");
INSERT INTO bhd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","मीं तुस भेज़े कि गाथ तैस फसली कट्टा ज़ै तुसेईं नईं बेवरी, होरेईं मेहनती सेइं कम कियूं ते तुसन तैन केरि मेहनतरो फल मैल्लो।” ");
INSERT INTO bhd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","नगरेरे बड़े लोकेईं तैस सैमरी कुआन्शरी गल शुन्तां यीशु पुड़ विश्वास कियो, किजोकि तैसां तैन लोकन सेइं ज़ोवं कि तैनी मीं सेइं सब किछ ज़ोवं, ज़ैन मीं कियेरू थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ज़ैस नगरेरे सामरी लोक यीशु कां ओरे थिये, मिनत केरतां ज़ोने लगे, असन कां बिश फिरी तै दूई दिहाड़े तैड़ी राव। ");
INSERT INTO bhd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","होरे भी बड़े लोक थिये ज़ैनेईं तैसेरी गल्लां शुन्तां तैस पुड़ विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","तैनेईं तैस कुआन्शी जो ज़ोवं, “असेईं तेरी गल्लां शुन्तां विश्वास नईं कियोरो, बल्के असेईं अपने कन्नेईं शुनेरूए ते असेईं एन हुनी बुझ़ू कि ए मैन्हु सच़्च़े दुनियाई मुक्ति देनेबालोए।” ");
INSERT INTO bhd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","दूई दिहैड़ना बाद यीशु फिरी गलीलेरे पासे च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ते यीशुए एप्पू ज़ोरू थियूं, कि कोई नबी अपने मुलखे मां इज़्ज़तरे काबल न समझ़ो गाए। ");
INSERT INTO bhd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ज़ैखन तै गलीले मां अव त गलीली लोक तैस सेइं खुशी सेइं मिले, एल्हेरेलेइ कि तैनेईं तैन सब किछ ज़ैन तैनी फ़सहरे मौके यरूशलेम नगरे मां कियेरू थियूं, तैनेईं अपनि एछ़्छ़ेईं सेइं लावरू थियूं तैखन तैना एप्पू भी तैड़ी थिये। ");
INSERT INTO bhd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","दुइयोवं बार ज़ैखन तै गलील इलाकेरे काना ड्लव्वें मां ओरो थियो ज़ैड़ी तैनी पानी दाछ़ारो रस बनोरो थियूं। तैड़ी अक बड़ो बड्डो राज़ेरो अफसर थियो तैसेरू मट्ठू कफरनहूम नगर मां बिमार भोरू थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ज़ैखन तैनी अफसरे शुनू कि यीशु यहूदिया इलाकेरां गलील इलाके मां ओरोए त तै यीशु कां पुज़ो ते मिनत केरतां ज़ोने लगो मेरू मट्ठू मरने बालूए तू च़ल ते तैस बज़्झ़ा, किजोकि तैन मरने बालू थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","यीशुए तैस सेइं ज़ोवं, “ज़ांतगर तुस लोक निशान ते चमत्कार न लाएले कधे विश्वास न केरेले कि, अवं मसीह आईं।” ");
INSERT INTO bhd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","तैनी बड्डे अफसरे ज़ोवं, “प्रभु लूश केर एरू न भोए कि मेरू मट्ठू मेरि गाए।” ");
INSERT INTO bhd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","यीशुए जुवाब दित्तो, “च़ल तेरू मट्ठू ज़ींतू भोनूए।” तैनी तैसेरी गल्लरो विश्वास कियो ते तैट्ठां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","तै हेजू बत्तां थियो त तैसेरे नौकर तैस मैल्ले ते ज़ोने लगे, “तेरू मट्ठू ज़ींतूए।” ");
INSERT INTO bhd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","तैखन तै पुच्छ़ने लगो, “मेरू मट्ठू कैखन ज़ेरे बेज़्झ़ोने लग्गोरू थियूं?” ते तैनेईं ज़ोवं “तैसेरो भुखार हीज दीसां एक्की बज़े उतरी जोरो थियो।” ");
INSERT INTO bhd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","तैखन तैसेरे बाजी याद अवं कि, तैए मौको थियो, ज़ैखन यीशुए ज़ोरू थियूं, “गा तेरू मट्ठू ज़ींतूए” तैखन तैनी भी ते तैसेरे पूरे टब्बरे यीशु पुड़ विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ई दुइयोवं चमत्कारेरो निशान थियो ज़ै यीशुए यहूदिया इलाकेरां वापस एजनेरां बाद गलील इलाके मां कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","एन गल्लन पत्ती यहूदी केरू अक तिहार भोवं, ते यीशु यरूशलेम नगरे जो जेव। ");
INSERT INTO bhd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरूशलेम नगरे मां भैड्डां केरे दारे कां अक हावदे, ज़ैस जो इब्रानी भाषाई मां बैतहसदा ज़ोतन, तैसेरां पंच़ अंगना थियां। ");
INSERT INTO bhd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","एन मां बड़े बिमार, काने, टोंटे, नीपाते (पानी हीलनेरे इंतज़ारे मां) भोते थिये। ");
INSERT INTO bhd_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(किजोकि वक्ते पुड़ परमेशरेरो स्वर्गदूत हावदे पुड़ एइतां पानी हिलातो थियो, ते पानी हिलनेरां पत्ती ज़ै कोई पेइलो हवदे मां गातो थियो तै ठीक भोतो थियो, चाए तैसेरी कोई भी बिमारी किना भोए)। ");
INSERT INTO bhd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","तैड़ी अक मैन्हु थू, ज़ै 38 सालां केरो बिमार थू। ");
INSERT INTO bhd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","यीशुए तै तैड़ी बिशोरो लाव ते एन ज़ेनतां कि ए बड़ो च़रोकनो इस हालती मांए, ते तैस पुच़्छ़ू, “कुन तू ठीक भोनू चातस?” ");
INSERT INTO bhd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","तैने बिमारे जुवाब दित्तो, “हे प्रभु, मीं कां कोई मैन्हु नईं, कि ज़ताली पानी हिलावं गाए त मीं कोई हावदे मां गाने लेइ मेरी मद्दत केरे, मेरे पुज़ते-पुज़ते तांतगर होरो कोई गाते।” ");
INSERT INTO bhd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","यीशुए तैस सेइं ज़ोवं, “उठ अपनि खट सल्ल ते च़ल फिर।” ");
INSERT INTO bhd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","तै मैन्हु तैखने ठीक भोव, ते अपनि खट छ़ुइतां च़लने फिरने लगो। ");
INSERT INTO bhd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","तै आरामेरी दिहाड़ी थी एल्हेरेलेइ यहूदी लीडर तैस सेइं ज़ै ठीक भोरो थियो, ज़ोने लग्गे, “अज़ त आरामेरी दिहाड़ी आए, तीं खट छ़ूनी जेइज़ नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","तैने तैन जुवाब दित्तो, “ज़ैने अव ठीक कियो, तैने मीं सेइं ज़ोवं, ‘अपनि खट छ़ू ते च़ल फिर।’” ");
INSERT INTO bhd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","तैनेईं तैस पुच़्छ़ू, “तै कौन मैनूए ज़ैने तीं सेइं ज़ोवं, ‘खट छ़ुइतां च़ल फिर’?” ");
INSERT INTO bhd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ज़ै ठीक भोरो थियो तै न थियो ज़ानतो कि तै कौन आए, किजोकि तैस ठैरी भीड़ भोनेरे वजाई सेइं यीशु तैस ठैरारां होरि पासे च़ुपच़ारे च़लो जोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","एन गल्लन पत्ती यीशु तै मन्दरेरे अंगने मां मैल्लो, यीशुए तैस सेइं ज़ोवं, “तक, तू ठीक भोरोस, फिरी पाप न करां, एरू न भोए कि, एस करां बड्डी आफत एज्जे।” ");
INSERT INTO bhd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","तैने मैने यहूदी लीडरन सेइं ज़ोवं, कि ज़ैने अवं ठीक कियोरोईं तै यीशुए। ");
INSERT INTO bhd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","एल्हेरेलेइ यहूदी लीडर यीशु सताने लाए, किजोकि तै एरां ज़ेरां कम्मां आरामेरे दिहाड़े केरतो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","एस पुड़ यीशुए तैन सेइं ज़ोवं, “मेरो बाजी यानी परमेशर हमेशा कम केरते, मीं भी कम कियोरू लोड़े।” ");
INSERT INTO bhd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","एस वजाई सेइं यहूदी लीडर मनां जादे तैस मारनेरी कोशिश केरने लाए, किजोकि तै न सिर्फ आरामेरे दिहाड़ेरो हुक्म न थियो ट्लोतो बल्के परमेशरे अपनो बाजी ज़ोतो थियो ते अपनो आप परमेशरेरे बराबर बनातो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","यीशुए तैन सेइं ज़ोवं, “अवं तुसन सेइं सच़-सच़ ज़ोताईं, मट्ठू यानी अवं एप्पू किछ न केरि बेटि, सिर्फ तैन ज़ैन बाजी परमेशरे करां केरतू लाताईं, किजोकि ज़ैना-ज़ैना कम्मां बाजी करां केरतो लाते तैन मट्ठू भी तैस्से तरीके सेइं केरते। ");
INSERT INTO bhd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","किजोकि बाजी, मट्ठे सेइं प्यार केरते, ते ज़ैना-ज़ैना कम्मां तै एप्पू केरते, तैना सब मट्ठे भी हिराते, ते तैन एस करां भी बड्डां कम्मां हिरालू, ताके तुस हैरान भोथ। ");
INSERT INTO bhd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","किजोकि ज़ेन्च़रे बाजी मुड़दन ज़ींतो केरते, तेन्च़रे मट्ठू भी ज़ैस चाते तैस ज़ींतो केरते। ");
INSERT INTO bhd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","बाजी केन्चेरी इन्साफ न केरे, पन तैने इन्साफ केरनेरू सारू कम मट्ठे दित्तेरूए। ");
INSERT INTO bhd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","कि सब लोक ज़ेन्च़रे बाजेरी आदर केरतन तेन्च़रे मट्ठेरी भी आदर केरन, ज़ै मट्ठेरी आदर न केरे, तै बाजी केरि ज़ैने तैन भेज़ोरूए तैसेरी आदर न केरे। ");
INSERT INTO bhd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","अवं तुसन सेइं सच़ ज़ोताईं ज़ै मेरू वचन शुन्तां मेरे भेज़ने बाले पुड़ विश्वास केरते, हमेशारी ज़िन्दगी तैसेरीए, ते तैस पुड़ सज़ारो हुक्म न भोए, बल्के तै मौतरां पार भोइतां हमेशारे ज़िन्दगी मां दाखल भोते।” ");
INSERT INTO bhd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“अवं तुसन सेइं सच़-सच़ ज़ोताईं, कि तै वक्त एजनेबालोए, बल्के हुन्नाए ज़ैस मां मुड़दे परमेशरेरे मट्ठेरी यानी मेरी आवाज़ शुनेले, ते ज़ैना शुनेले तैना हमेशा ज़ीएले। ");
INSERT INTO bhd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","किजोकि ज़ेन्च़रे बाजी अपने आपे मां ज़िन्दगी रखते तेन्च़रे तैने मट्ठे भी ए अधिकार दित्तोरोए, कि अपने आपे मां ज़िन्दगी रखे एल्हेरेलेइ तैन मैनेरू मट्ठूए। ");
INSERT INTO bhd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","बल्के बाजी परमेशरे तैस सैरी लोकां केरि आदालत केरनेरो भी अधिकार दित्तोरोए, एल्हेरेलेइ कि तैन यानी अवं मैनेरू मट्ठू आईं। ");
INSERT INTO bhd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","एसमां हैरान न भोथ, किजोकि तै वक्त एइते कि ज़ेत्रे कब्रन मां आन तैसेरी आवाज़ शुन्तां ज़ींते भोनेन। ");
INSERT INTO bhd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ज़ैनेईं भलाई कियोरीए हमेशारे ज़िन्दगरी लेइ ज़ींते भोनेन ज़ैनेईं बुरी ज़िन्दगी ज़ीयोरीए तैना सज़ारी लेइ ज़ींते भोनेन।” ");
INSERT INTO bhd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“अवं अपने आपे सेइं किछ न केरि बेटि, ज़ेन्च़रे मेरो बाजी मीं ज़ोते तेन्च़रे अवं लोकां केरि आदालत केरताईं, ते मेरी आदालत सच़्च़ीए, किजोकि अवं अपने मेर्ज़ी सेइं नईं पन अपने भेज़ने बालेरी मर्ज़ी सेइं चाताईं। ");
INSERT INTO bhd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","अगर अवं अपनि गवाही एप्पू देईं, त मेरी गवाही सच़्च़ी नईं। ");
INSERT INTO bhd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","अक होरो आए, यानी मेरो बाजी ज़ै मेरी गवाही देते, ते अवं ज़ानताईं ज़ै गवाही तै मेरे बारे मां देते तै सच़्च़ीए। ");
INSERT INTO bhd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","तुसेईं मैन्हु यूहन्ना कां मेरे बारे मां पुच्छ़ने भेज़े, ते तैनी सच़्च़ेरी गवाही दित्तोरीए। ");
INSERT INTO bhd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","पन अवं अपने लेइ मैनेरी गवाही न चैई, पन यूहन्ना ज़ै गवाही दित्ती तैसेरे बारे मां मीं एल्हेरेलेइ ज़ोवं ताके तुसन मुक्ति मैल्ले। ");
INSERT INTO bhd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","तै त बलतो ते चमकतो दीयेरो ज़ेरो थियो, पन तुसन थोड़े च़िरेरे लेइ तैसेरी लोई मां खुश भोनू रोड़ू लग्गू। ");
INSERT INTO bhd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","पन मीं कां ज़ै गवाहीए तै यूहन्नारी गवाही करां भी बड्डीए। किजोकि ज़ैन कम बाजे मीं केरनेरे लेइ दित्तेरू मतलब इन्ने कम्मां ज़ैना अवं केरताईं, तैना मेरी गवाही देतन कि बाजे अवं भेज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ते बाजी ज़ैने अवं भेज़ोरोईं तैने मेरी गवाही दित्तोरीए, तुसेईं न कधी तैसेरी आवाज़ शुनोरी, ते न तै आमने सामने लोरोए। ");
INSERT INTO bhd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","तुसेईं तैसेरी शिक्षा अपने मने मां नईं रख्खोरी, किजोकि तुसेईं मीं पुड़ विश्वास न कियो, कि अवं परमेशरे भेज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","तुस पवित्रशास्त्रे मां एन पढ़तथ, किजोकि तुस सोचतथ कि हमेशारी ज़िन्दगी तैस मां मैलतीए, तै ईए, ज़ै मेरे बारे मां गवाही देते। ");
INSERT INTO bhd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","फिरी भी तुस हमेशारे ज़िन्दगी हासिल केरनेरे लेइ मीं कां न एजनू चाथ। ");
INSERT INTO bhd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","अवं मैनन् करां तारीफ़ न चैई। ");
INSERT INTO bhd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","पन अवं तुसन ज़ानताईं तुश्शे दिले मां परमेशरेरे लेइ प्यार नईं। ");
INSERT INTO bhd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","अवं अपने बाजेरे अधिकारे सेइं ओरोईं, ते तुस मेरी गल न मन्नथ। अगर होरो कोई अपने अधिकारे सेइं एज्जे, त तैसेरी गल मन्नेले। ");
INSERT INTO bhd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","तुस मीं पुड़ विश्वास न केरि बटथ, किजोकि तुस एक्की होरि करां तारीफ़ चातथ, ते तुस तै तारीफ़ न चाथ ज़ै सिर्फ परमेशरेरे तरफांए। ");
INSERT INTO bhd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","इन न समझ़ा कि अवं बाजेरे सामने तुसन पुड़ दोष लेइएलो, तुसन पुड़ दोष लानेबालोए त मूसोए, ज़ैस पुड़ तुसेईं भरोसो रख्खोरोए। ");
INSERT INTO bhd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","किजोकि अगर तुसेईं मूसेरो विश्वास कियोरो भोथो, त मेरो भी विश्वास केरेथे, किजोकि तैने मेरे बारे मां लिखोरूए। ");
INSERT INTO bhd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","तुस त तैसेरे कानूनेरे गल्लन पुड़ विश्वास न केरथ, ते फिरी तुस किजो मेरी गल्लन पुड़ विश्वास केरेले?” ");
INSERT INTO bhd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","एन गल्लन पत्ती यीशु गलीलेरे समुन्दरेरे मतलब तिबिरियुसेरे समुन्दरेरे पार जेव। ");
INSERT INTO bhd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ते अक बड़ी भीड़ तैस पत्ती च़ली, किजोकि ज़ैना चमत्कार तै बिमारन पुड़ हीरतो थियो, ते तैना ठीक भोते थिए ते लोक एन हेरते थिए। ");
INSERT INTO bhd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","तैखना यीशु पहाड़े पुड़ च़ेढ़तां अपने चेलन साथी तैड़ी बिश्शो। ");
INSERT INTO bhd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ते यहूदी केरे फ़सहेरू तिहार नेड़ू थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ज़ैखन यीशुए अक बड़ी भीड़ अपने पासे एंइती लाई, त तैने फिलिप्पुसे सेइं ज़ोवं, “असां एना केरे लेइ रोट्टी कोट्ठां घिन्म?” ");
INSERT INTO bhd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","पन तैनी तै गल तैस अज़मानेरे लेइ ज़ोई, किजोकि तै एप्पू ज़ानतो थियो कि तै कुन केरेलो। ");
INSERT INTO bhd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिप्पुसे तैस जुवाब दित्तो, “एन केरे लेइ 200 दीनारां केरि रोट्टी भी पूरी न भोली कि तैन थोड़ी-थोड़ी मैली गैली।” ");
INSERT INTO bhd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","तैसेरे चेलन मरां शमौन पतरसेरे ढ्लाए अन्द्रियासे तैस सेइं ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“इड़ी अक मट्ठूए ज़ैस कां जोआं केरि पंच़ रोट्टिन, तै दूई मेछ़लीन, पन एत्रे लोकन जो कुन तैना पूरी भोनिन?” ");
INSERT INTO bhd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","यीशुए ज़ोवं, “लोकन बिशाला।” तैड़ी बड़ो घास थियो। तैखन लोक ज़ैना लगभग 5000 मड़द बिश्शोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तैखन यीशुए रोट्टी ट्लेइ ते शुक्र केरतां बिशने बलना दित्ती, ते तेन्च़रे मेछ़लीन मरां भी ज़ेत्री तैना चातो थियो बेन्टी। ");
INSERT INTO bhd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ज़ैखन तैना खेइतां रज़्ज़े त तैनी अपने चेलन सेइं ज़ोवं, “बच़ोरे टुक्ड़े अकोट्ठे केरा, ताके किछ शारू न गाए।” ");
INSERT INTO bhd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ते तैनेईं अकोट्ठे केरे, ते जोआं केरे पंच़ रोट्टी केरे टुक्ड़न मरां ज़ैना खाने बालन करां बंच़ोरे थिए 12 टोकरे थिए। ");
INSERT INTO bhd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","तैखन तै चमत्कार ज़ै तैनी कियोरो थियो लोक हेरतां ज़ोने लाए, “तै नबी ज़ै दुनियाई मां एजनेबालो थियो सच़्च़े ईए।” ");
INSERT INTO bhd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","यीशुए एना ज़ेनतां कि एना मीं राज़ो बनानेरे लेइ ट्लानो चातन, फिरी तै अकैल्लो पहाड़े पुड़ जेव। ");
INSERT INTO bhd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ज़ैखन ड्लोझ़ भोइ, त तैसेरे चेले समुन्दरेरे बन्ने जे। ");
INSERT INTO bhd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ते किश्ती मां च़ेढ़तां समुन्दरेरे पार कफरनहूम नगर जो च़ले, तैस वक्ते आंधरू भोरू थियूं, ते यीशु हेजू तगर तैन कां न थियूं ओरो। ");
INSERT INTO bhd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ते बड़ी तेज़ हवा च़लोरी थी ते समुन्दरे मां छ़ेल्ली उठने लेइ। ");
INSERT INTO bhd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ज़ैखन तै लगभग ट्लाई च़ेव्रे मील नेड़े अव, त तैनेईं यीशु समुन्दरे पुड़ च़लतो लाव ते किश्तरे नेड़े एइतो लाव ते डरे। ");
INSERT INTO bhd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","पन यीशुए तैन सेइं ज़ोवं, “अवं आईं डरा न।” ");
INSERT INTO bhd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ते तै तैस किश्ती मां च़ड़नेरे लेइ तियार भोव, ते तैखने किश्ती तैस ठैरी पुड़ पुज़ी ज़ैड़ी तैना च़लोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","दुइयोवं दिहाड़े तैस मैन्हु केरि भीड़ां ज़ै समुन्दरेरे पार खड़ी थी, इन हेरतां कि एक्की किश्तरे अलावा होरि कोई न थी, यीशु अपने चेलन साथी तैस किश्ती पुड़ न च़ढ़ोरो थियो, पन सिर्फ तैसेरे चेले थिये। ");
INSERT INTO bhd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(तैखन होरि किश्ती तिबिरियुस नगरेरां तैस ठैरी एई, ज़ैड़ी तैनेईं प्रभुएरू शुक्र केरतां रोट्टी खोरी थी) ");
INSERT INTO bhd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","एल्हेरेलेइ ज़ैखन लोकेईं हेरू कि इड़ी न यीशु ते न तैसेरे चेले, ते तैना फिरी तैना निक्की-निक्की किश्तन पुड़ च़ेढ़तां यीशु तोपते कफरनहूम नगर ए पुज़े। ");
INSERT INTO bhd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","समुन्दरेरे पार ज़ैखन तैना तैस मैल्ले त तैने ज़ोवं, “हे गुरू, तू इड़ी कताली अव?” ");
INSERT INTO bhd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","यीशुए तैन जुवाब दित्तो, “अवं तुसन सेइं सच़-सच़ ज़ोताईं, तुस मीं एल्हेरेलेइ न तोपथ कि तुसेईं चमत्कार लाव, बल्के एल्हेरेलेइ कि रोट्टी खेइतां रज़्ज़े। ");
INSERT INTO bhd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","नाश भोनेबैली रोट्टरे लेइ मेहनत न केरा। पन तैस रोट्टरे लेइ मेहनत केरा ज़ै हमेशारी ज़िन्दगी देतीए, ज़ै मैनेरू मट्ठू यानी अवं तुसन देइलो, किजोकि बाजी परमेशरे मीं एन्च़रां केरनेरो अधिकार दित्तोरोए।” ");
INSERT INTO bhd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","तैनेईं तैस्से सेइं ज़ोवं, “परमेशरेरू कम केरनेरे लेइ अस कुन केरम?” ");
INSERT INTO bhd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","यीशुए तैन जुवाब दित्तो, “परमेशर तुसन करां एन कम चाते कि तुस तैस पुड़ यानी मीं पुड़ विश्वास केरा ज़ैनी अवं भेज़ोरोईं।” ");
INSERT INTO bhd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","तैखन तैनेईं तैस सेइं ज़ोवं, “फिरी तू कुन निशान हीरातस कि अस तैस हेरतां तेरो विश्वास केरम? तू कोन ज़ेरू कम हीरातस? ");
INSERT INTO bhd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","इश्शे दादेईं-पड़दादेईं जंगले मां स्वर्गेरी रोट्टी खेइ, ज़ैस जो मन्नो ज़ोतन। ज़ेन्च़रे पवित्रशास्त्रे मां लिखोरूए, तैनी तैन खानेरे लेइ स्वर्गेरां रोट्टी दित्ती।” ");
INSERT INTO bhd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","यीशुए तैन सेइं ज़ोवं, “अवं तुसन सेइं सच़-सच़ ज़ोताईं कि मूसा तुसन तै रोट्टी स्वर्गेरां न दित्ती, पन मेरो बाजी तुसन सच़्च़ी रोट्टी स्वर्गेरां देते। ");
INSERT INTO bhd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","किजोकि ज़ै रोट्टी परमेशर देते, ते तै ईए ज़ै स्वर्गेरां एइतां दुनियारे लोकन ज़िन्दगी देतीए।” ");
INSERT INTO bhd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","तैखन तैनी तैस्से सेइं ज़ोवं, “हे प्रभु, ए रोट्टी असन स्वर्गेरां देतो रा।” ");
INSERT INTO bhd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","यीशुए तैन सेइं ज़ोवं, “ज़िन्दगरी रोट्टी (ज़ै ज़िन्दगी देनेबाली रोट्टी) अव्वें आईं, ज़ै मीं कां एजते तै कधी निअन्नो न भोलो, ते ज़ै मीं पुड़ विश्वास केरेलो तै कधी ट्लिशोरो न भोलो। ");
INSERT INTO bhd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","पन मीं तुसन सेइं पेइलू ज़ोरूए, कि तुसेईं अवं लोरोईं फिरी भी मीं पुड़ विश्वास न केरथ। ");
INSERT INTO bhd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ज़ैन किछ बाजी मीं देते तैन सब किछ मीं कां एजनूए, ते ज़ै कोई मीं कां एज्जेलो अवं तैस ज़रूर कबूल केरेलो। ");
INSERT INTO bhd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","किजोकि अवं अपनि मर्ज़ी नईं, बल्के परमेशरेरी मर्ज़ी पूरी केरनेरे लेइ स्वर्गेरां ओरोईं ज़ैनी अवं भेज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ईए मेरे बाजेरी मर्ज़ी आए ज़ैनी अवं भेज़ोरोईं कि ज़ैन किछ तैनी मीं दित्तोरोए तैस मरां अवं किछ न हिरेईं, पन आखरी दिहैड़ी फिरी तैस ज़ींतो केरेलो। ");
INSERT INTO bhd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","किजोकि मेरे बाजेरी मर्ज़ी ईए कि ज़ै कोई मट्ठे हेरे ते तैस पुड़ विश्वास केरे, तैस हमेशारी ज़िन्दगी मैल्ले, ते अवं तैस आखरी दिहैड़ी फिरी ज़ींतो केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","एल्हेरेलेइ यहूदी लोक तैस पुड़ कुड़कुड़ाने लग्गे, किजोकि तैनी ज़ोरू थियूं, “ज़ै रोट्टी स्वर्गेरां ओरिए तै अवं आई।” ");
INSERT INTO bhd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ते तैनेईं ज़ोवं, “कुन एन यूसुफेरू मट्ठू यीशु नईं, ज़ेसेरे अम्मा बाजी अस ज़ानतम? त तै केन्च़रे ज़ोते कि अवं स्वर्गेरां ओरोईं?” ");
INSERT INTO bhd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","यीशुए तैन जुवाब दित्तो, “एप्पू मांमेइं न कुड़कुड़ाथ। ");
INSERT INTO bhd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","कोई मीं कां न एज्जी बट्टे ज़ांतगर बाजी, ज़ैनी अवं भेज़ोरोईं, तैस मीं कां न आने, ते अवं तैस आखरी दिहैड़ी फिरी ज़ींतो केरेलो। ");
INSERT INTO bhd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","नेबी केरे पवित्रशास्त्रे मां एन लिखोरूए, ‘तैना सब परमेशरेरे तरफां शिख्खोरे भोनेन।’ ज़ैनी बाजी करां शुनोरूए त शिख्खोरोए तै मीं कां एइते। ");
INSERT INTO bhd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","एसेरो मतलब ई नईं कि केन्चे बाजी लोरोए, पन ज़ै परमेशरेरे तरफांए यानी मीं बाजी लोरोए। ");
INSERT INTO bhd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","अवं तुसन सेइं सच़-सच़ ज़ोताईं ज़ै कोई विश्वास केरते हमेशारी ज़िन्दगी तैसेरीए। ");
INSERT INTO bhd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ज़िन्दगरी रोट्टी (ज़िन्दगी देनेबाली रोट्टी) अव्वें आईं। ");
INSERT INTO bhd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","तुश्शे दादे-पड़दादेईं जंगले मां मन्नो खाऊ ते मरे। ");
INSERT INTO bhd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ई तै स्वर्गेरी रोट्टीए कि मैन्हु खान ते न मरन। ");
INSERT INTO bhd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ज़िन्दगरी रोट्टी ज़ै स्वर्गेरां ओरिए अव्वें आईं। अगर कोई इस रोट्टी मरां खाए, त हमेशा ज़ींतो रालो, ते ज़ैस रोट्टी सेइं दुनियारे लोकन हमेशारी ज़िन्दगी मैलचे, तैन मेरू मासे।” ");
INSERT INTO bhd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","एस पुड़ यहूदी लोक एप्पू मांमेइं बेंस केरने लाए, “ई मैन्हु असन अपनू मास केन्च़रे खाने जो देइ बटते?” ");
INSERT INTO bhd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","यीशुए तैन सेइं ज़ोवं, “अवं तुसन सेइं सच़-सच़ ज़ोताईं, कि ज़ांतगर तुस मैनेरे मट्ठेरू यानी मेरू मास न खाले, ते मेरो खून न पीले, तुसन हमेशारी ज़िन्दगी न मैलेली। ");
INSERT INTO bhd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ज़ै मेरू मास खाते ते मेरो खून पीते हमेशारी ज़िन्दगी तैसेरीए ते आखरी दिहैड़ी अवं फिरी तैस ज़ींतो केरेलो। ");
INSERT INTO bhd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","किजोकि हकीक्ति मां मेरू मास खानेरी चीज़े ते मेरो खून पीनेरी चीज़े। ");
INSERT INTO bhd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ज़ै मेरू मास खाते ते खून पीते तै मीं मां बनोरो राते, ते अवं तैस मां। ");
INSERT INTO bhd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ज़ेन्च़रे ज़ींते बाजी अवं भेज़ोरोईं, ते अवं बाजी केरे कारन ज़ोताईं, तेन्च़रे तै भी ज़ै मीं खालो मेरे कारन ज़ींतो रालो। ");
INSERT INTO bhd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ज़ै रोट्टी स्वर्गेरां ओरिए, तैस रोट्टी ज़ेरि नईं ज़ै तुश्शे दादे-पड़दादेईं खाइ ते बादे मां मरे, पन ज़ै कोई ई रोट्टी खालो तै हमेशा ज़ींतो रालो।” ");
INSERT INTO bhd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","इना गल्लां तैनी कफरनहूम नगरेरे एक्की प्रार्थना घरे मां ज़ोई। ");
INSERT INTO bhd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","एल्हेरेलेइ तैसेरे चेलन मरां बड़ेईं एन शुन्तां ज़ोवं, “ए शिक्षा सकते, एस कौन मेन्नी बटते?” ");
INSERT INTO bhd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","यीशु अपने मने मां एना बुझ़तां कि मेरे चेले एस गल्ली पुड़ एप्पू मांमेइं कुड़कुड़ाने लोरेन, तैन पुच़्छ़ू, “कुन इना गल्लां तुसन मीं पुड़ विश्वास केरने करां रोकतिन?” ");
INSERT INTO bhd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","अगर तुस मैनेरू मट्ठू यानी अवं ज़ैड़ी पेइलो थियो उबरे (स्वर्गे) गातो लाएले, त कुन भोलू? ");
INSERT INTO bhd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","परमेशरेरी आत्मा त ज़िन्दगी देने बालीए, मैन्हु केरि ताकती सेइं किछ न केरोए, ज़ैना गल्लां मीं तुसन सेइं ज़ोई तैना परमेशरेरी आत्मारे तरफां आन ते तैना ज़िन्दगी भी आन। ");
INSERT INTO bhd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","पन तुसन मां किछ एरे आन ज़ैना विश्वास न केरन। किजोकि यीशु पेइलो ज़ानतो थियो कि ज़ैना विश्वास न थी केरते तैना कौन आन, ते तैस कौन ट्लवालो। ");
INSERT INTO bhd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ते तैनी ज़ोवं, “एल्हेरेलेइ मीं तुसन सेइं ज़ोरू थियूं, ज़ांतगर बाजी केरे तरफां एन वरदान न मैल्ले तांतगर कोई मीं कां न एज्जी बट्टे।” ");
INSERT INTO bhd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","एस पुड़ तैसेरे चेलन मरां बड़े उलटे फिरे, ते तैल्ला पत्ती तैस साथी न च़ले। ");
INSERT INTO bhd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","तैखन यीशुए 12 चेलन सेइं ज़ोवं, “कुन तुस भी च़लू गानू चातथ?” ");
INSERT INTO bhd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","शमौन पतरस तैस जुवाब दित्तो, “हे प्रभु अस केस कां गाम? हमेशारी ज़िन्दगरी देने बैली गल्लां त तींए कां आन। ");
INSERT INTO bhd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ते असेईं तीं पुड़ विश्वास कियो ते ज़ानू कि तू परमेशरेरो पवित्र मैन्हु आस।” ");
INSERT INTO bhd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","यीशुए तैन जुवाब दित्तो, “कुन मीं तुस 12 न च़ुने। फिर भी तुसन मरां अक मैन्हु शैताने।” ");
INSERT INTO bhd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","तैने इन तैस शमौन इस्करियोतेरे मट्ठे यहूदा इस्करियोतेरे बारे मां ज़ोवं। हांलाकि तै तैन 12 चेलन मरां अक थियो, ज़ै यीशु ट्लुवांने बालो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","एना गल्लन पत्ती यीशु गलील इलाके मां फिरतो राव, किजोकि यहूदी लीडर तैस मारनेरी कोशिश केरि राओरे थिये, एल्हेरेलेइ तै यहूदिया इलाके मां फिरनू न चातो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","यहूदी केरू झोंफड़ी केरू तिहार (तेम्बु) नेड़ू थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","एल्हेरेलेइ तैसेरे ढ्लाएईं तैस ज़ोवं, “इड़ी न रा। यहूदिया इलाके मां गा ज़ैड़ी तिहार मनाने लोरेन, कि ज़ैना चमत्कार तू केरतस तैना तेरे तैना चेले भी हेरन, ज़ैना यहूदिया इलाके मां रातन। ");
INSERT INTO bhd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","किजोकि एरो कोई न भोलो कि ज़ै मशूर भोनू चाए, ते छ़ेपतां कम केरे। अगर तू कम केरतस, त अपनो आप हिरा।” ");
INSERT INTO bhd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","किजोकि तैसेरे ढ्ला भी तैसेरो विश्वास न थी केरते। ");
INSERT INTO bhd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तैखन यीशुए तैन सेइं ज़ोवं, “मेरो लेइ ठीक वक्त हेजू नईं ओरो, पन तुस केन्ची वक्त मां भी गेइ सकतथ। ");
INSERT INTO bhd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","इस दुनियारे लोक तुसन सेइं बैर न केरि सकन, पन मीं सेइं बैर रखतन किजोकि अवं तैन केरे खलाफ इन ज़ोताईं कि तैना बुरां कम्मां केरतन। ");
INSERT INTO bhd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","तुस तिहारे मां गाथ, मीं हुना एस तिहारे मां नईं एजनू, किजोकि मेरो हेजू ठीक वक्त नईं ओरो।” ");
INSERT INTO bhd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ते तै तैन सेइं एना गल्लां केरतां गलीले मां राव। ");
INSERT INTO bhd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","पन ज़ैखन तैसेरे ढ्ला तिहारे मां च़ले जे त तै बांदो न पन छ़ेपतां जेव। ");
INSERT INTO bhd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","यहूदी लीडर तिहारे मां यीशु तोपने लाए। तैना लोकन पुछ़्छ़ी राओरे थिये, “तै मैन्हु कोड़ि आए?” ");
INSERT INTO bhd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ते लोकन मां तैसेरे बारे मां बल्हे-बल्हे बेड़ि गल्लां भोइ, किछ ज़ोते थी, “तै रोड़ो मैनूए।” ते किछ ज़ोते थी, “नईं तै मैनन् गुमरा केरते।” ");
INSERT INTO bhd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","फिरी भी यहूदी लोकां केरे प्रधानां केरे डरे सेइं केन्ची भी मैन्हु तैसेरे बारे मां खुलतां तैसेरे बारे मां गल केरनेरी हिम्मत न भोइ। ");
INSERT INTO bhd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ज़ैखन तिहारेरे अध्धे दिहाड़े बीते, त यीशु मन्दरेरे अंगने मां गेइतां शिक्षा देने लगो। ");
INSERT INTO bhd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","तैखन यहूदी लीडरेईं हैरान भोइतां ज़ोवं, “एनी त पवित्रशास्त्रेरी शिक्षा केन्ची करां नईं पढ़ोरीए, फिरी एस केन्च़रे एना गल्लां एई?” ");
INSERT INTO bhd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","यीशुए तैन जुवाब दित्तो, “मेरी शिक्षा मेरी अपनि नईं, बल्के परमेशरेरे तरफां आए, ज़ैने अवं भेज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","अगर कोई तैसेरी मेर्ज़ी पुड़ च़लनू चाए, त तै इस शिक्षारे बार मां ज़ानेलो कि ए परमेशरेरे तरफांए या अवं अपने तरफां ज़ोताईं। ");
INSERT INTO bhd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ज़ै अपने तरफां किछ ज़ोते तै अपनि बड़याई चाते, पन ज़ै अपने भेज़ने बालेरी बड़याई चाते तै ईमानदार आए, ते तैस मां कोई बेइमानी नईं। ");
INSERT INTO bhd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","तुसन मूसे कानून दित्तो, पन तुसन मरां कोई भी तैस पुड़ न च़ले! पन तुस लोक मीं मारनेरी कोशिश केरतथ।” ");
INSERT INTO bhd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","लोकेईं जुवाब दित्तो, “तीं पुड़ भूतेरो सैयोए! कौन तीं मारनेरी कोशिश केरते?” ");
INSERT INTO bhd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","यीशुए जुवाब दित्तो, “मीं अक चमत्कार कियो, ते तुस हैरान भोए। ");
INSERT INTO bhd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","एल्हेरेलेइ मूसा तुसन खतनेरो हुक्म दित्तो (एना नईं कि मूसेरे तरफांए बल्के बाप दादां करां च़लतो ओरोए) ते तुस आरामेरे दिहाड़े मैनेरो खतनो केरतथ। ");
INSERT INTO bhd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","एल्हेरेलेइ आरामेरे दिहाड़े मैनेरो खतनो कियो गाते ताके मूसेरे कानूनेरो हुक्म न टले, त तुस मीं पुड़ किजो क्रोध केरतथ, कि मीं आरामेरे दिहाड़े अक मैन्हु रोड़ेच़ारे ठीक केरो। ");
INSERT INTO bhd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","तुतर हेरतां इन्साफ न केरा बल्के ठीक-ठीक आदालत केरा।” ");
INSERT INTO bhd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तैखन किछ यरूशलेम नगरेरे रानेबाले एप्पू मांमेइं एक्की होरि पुच्छ़ने लगे, “कुन ए तै नईं, ज़ैस मारनेरी कोशिश च़लोरिए? ");
INSERT INTO bhd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","पन तक्का, तै त खुले आम गल्लां केरते, ते कोई एस किछ न ज़ोए। कुन लीडरेईं सच़्च़े, सच़ ज़ानू कि ए मसीहे? ");
INSERT INTO bhd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","पन ए मैन्हु मसीह केन्च़रे भोइ सकते? एस त अस ज़ानतम कि ए कोट्ठां ओरोए, पन ज़ेइस मसीह एज्जेलो त कोई न ज़ानेलो कि तै कोट्ठां एज्जेलो।” ");
INSERT INTO bhd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","तैखन यीशुए मन्दरे अंगने मां शिक्षा देते बारे ज़ोरे सेइं ज़ोवं, “तुस मीं ज़ानतथ ते इन भी कि अवं कोट्ठां ओरोईं। अवं एप्पू नईं ओरो, पन मेरो भेज़ने बालो सच़्च़ोए, तैस तुस न ज़ानाथ। ");
INSERT INTO bhd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","पन अवं तैस ज़ानताईं, किजोकि अवं तैसेरे तरफां ओरोईं, ते तैनी अवं भेज़ोरोईं।” ");
INSERT INTO bhd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","एस पुड़ लीडरेईं तै ट्लानो चाव, फिरी भी केन्चे तैस सेइं हथ न लव, किजोकि तैसेरो मरनेरो वक्त हेजू न थियो ओरो। ");
INSERT INTO bhd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","फिरी भी भीड़ी मरां बड़े लोकेईं तैस पुड़ विश्वास कियो, ते ज़ोने लाए, “मसीह ज़ैखन एज्जेलो ते एट्ठां जादे चमत्कार हिरालो ज़ैना एने हीराहे?” ");
INSERT INTO bhd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","फरीसी लोकेईं, लोक तैसेरे बारे मां बल्हे-बल्हे एना गल्लां केरते शुने, ते प्रधान याजकेईं ते फरीसी लोकेईं तैस ट्लानेरे लेइ मन्दरेरे पहरदार भेज़े। ");
INSERT INTO bhd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","एस पुड़ यीशुए ज़ोवं, “अवं थोड़े च़िरे तगर हेजू तुसन साथी आईं, फिरी अवं अपने भेज़ने बाले कां वापस गानोईं। ");
INSERT INTO bhd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","तुस मीं तोप्पेले, पन अवं नईं मैलनो, ते ज़ैड़ी अवं आईं, तैड़ी तुस न एज्जी बटथ।” ");
INSERT INTO bhd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","एस पुड़ यहूदी लीडर एप्पू मांमेइं ज़ोने लगे, “ए कोरां च़लोरे, ज़ेरां अस न गेइ बटम? कुन ए तैन कां गालो ज़ैना यूनान नगरे मां तितर-बितर भोइतां रातन, ते यूनानेरे लोकन भी शिक्षा देलो?” ");
INSERT INTO bhd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","एस गल्लरो कुन मतलबे ज़ै एनी ज़ोई, कि तुस मीं तोप्पेले, पन अवं तुसन न मैलेलो, ते ज़ैड़ी अवं आईं तैड़ी तुस न एज्जी बटतथ? ");
INSERT INTO bhd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","तिहारेरे आखरी दिहाड़े, ज़ै खास दिहाड़ी भोतीए, तेइस यीशु खड़ो भोइतां ज़ोने लगो, “अगर कोई ट्लिश्शोरो भोए त मीं कां एज्जे ते पीये। ");
INSERT INTO bhd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ज़ै मीं पुड़ विश्वास केरे, ज़ेन्च़रे पवित्रशास्त्रे मां लिखेरूए, तैसेरे दिले मरां तै पैनेरे दरिया निस्सेले ज़ैना ज़िन्दगी देतन।” ");
INSERT INTO bhd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","यीशुए एना गल्लां पवित्र आत्मारे बारे मां ज़ोई, ज़ै विश्वास केरेने बालन पुड़ एजनेबाली थी, किजोकि पवित्र आत्मा हेजू तगर न थी दित्तोरी, किजोकि यीशु हेजू तगर अपनि महिमा मां वापस न थियो जोरोए। ");
INSERT INTO bhd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","तैखन भीड़ी मरां किछेईं एना गल्लां शुन्तां ज़ोवं, “सच़्च़े ई तै नबी आए, ज़ेसेरे एजनेरी अस उमीदी मां आम।” ");
INSERT INTO bhd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","किछ लोकेईं ज़ोवं, “ई मसीहे,” पन किछेईं ज़ोवं, “कुन मसीह गलील इलाकेरां एजनोए? ");
INSERT INTO bhd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","पवित्रशास्त्र मां लिखोरू कि मसीह दाऊदेरे खानदाने ते बैतलहम ड्लव्वें मरां एज्जेलो, ज़ैड़ी दाऊद राज़ो रातो थियो।” ");
INSERT INTO bhd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","यीशुएरे बारे मां लोकां केरो अलग-अलग खियाल थियो, एल्हेरेलेइ तैन एप्पू मांमेइं अनबन भोइ। ");
INSERT INTO bhd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","किछ तैन मरां तैस ट्लाने चाते थिये, पन केन्चे तैस सेइं हथ न लव। ");
INSERT INTO bhd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","तैखन मन्दरेरे पहरदार, प्रधान याजकन ते फरीसन कां एइतां तैन सेइं ज़ोवं, “तुसेईं तै किजो न आनो?” ");
INSERT INTO bhd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","पहरदारेईं जुवाब दित्तो, “केन्चे मैने कधी एत्री रोड़ो गल्लां न कियोरी, ज़ेरि गल्लां ए मैन्हु केरते।” ");
INSERT INTO bhd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","फरीसेईं तैन जुवाब दित्तो, “कुन तुस भी टेपलोरेथ? ");
INSERT INTO bhd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","कुन सरदारन ते फरीसन मरां केन्चे तैस पुड़ विश्वास कियोरोए? ");
INSERT INTO bhd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","पन एन लोक ज़ैना मूसेरे कानूने न ज़ानन् तैन पुड़ परमेशरेरो फिटकार भोते।” ");
INSERT INTO bhd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","नीकुदेमुसे ज़ै पेइलो तैस कां राती ओरो थियो, ते तैना मरां अक थियो, तैनी ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“कुन इश्शे कानून केन्ची मैन्हु सज़ा देनेरी अज़ाज़त देते, ज़ांतगर तैसेरी गल शुन्तां इन न ज़ानम कि तै कुन केरते?” ");
INSERT INTO bhd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","तैनेईं तैस जुवाब दित्तो, “कुन तू भी गलील इलाकेरो आस! पवित्रशास्त्रे मां तोप ते ज़ान, कि गलीलेरां कोई नबी त नईं निसने बालो!” ");
INSERT INTO bhd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","(तैखन सब अपने-अपने घरे च़ले जे)। ");
INSERT INTO bhd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","पन यीशु अपने चेलन सेइं साथी ज़ैतून पहाड़े पुड़ जेव। ");
INSERT INTO bhd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","होरसां तै झ़ेझ़ां-झ़ेझ़ां मन्दरेरे अंगने मां जेव, बड़े लोक तैस कां आए ते तै बिश्तां तैन शिक्षा देने लगो। ");
INSERT INTO bhd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","तैखन शास्त्री ते फरीसी लोक एक्की कुआन्शी ज़ै बदमैशी मां ट्लेइयोरी थी, तै मझ़ाटे खड़ी केरतां यीशु सेइं ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“हे गुरू, ई कुआन्श बदमाशी केरते वक्त ट्लोरीए। ");
INSERT INTO bhd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","मूसेरे कानूने मां मूसा असन हुक्म दित्तोरोए कि एरी ज़ेरि कुआन्शी घोड़ेईं बैइतां मारा, ते तू एस कुआन्शरे बारे मां कुन ज़ोतस, कि अस एस कुन केरम?” ");
INSERT INTO bhd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","तैनेईं यीशु परखनेरे लेइ ए गल ज़ोई, ताके तैस पुड़ दोष लाने जो गल मैल्ले। पन यीशु उन्ढे लिकतां एंगलोई सेइं ज़मीनी पुड़ लिखने लव। ");
INSERT INTO bhd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ज़ैखन तैना तैस पुछ़ते राए, त तैनी उबरे तेकतां तैन सेइं ज़ोवं, “तुसन मरां ज़ैनी पाप न भोए कियोरोए, तैए पेइलो घोड़े बाए।” ");
INSERT INTO bhd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ते फिरी उन्ढे लिकतां एंगलोई सेइं ज़मीनी पुड़ लिखने लव। ");
INSERT INTO bhd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","पन तैना एना शुन्तां बड्डन करां निकड़न तगर सारे एक्की पत्ती अक तैट्ठां च़ले जे, ते यीशु अकैल्लो राव, ते तै कुआन्श मझ़ाटे खड़ी राई। ");
INSERT INTO bhd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","यीशुए उबरे तेकतां तैस पुच़्छ़ू, “हे कुआन्श, तैना कोरां जे? कुन केन्चे तीं पुड़ सज़ारो हुक्म न दित्तो?” ");
INSERT INTO bhd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","तैसां ज़ोवं, “हे प्रभु केन्चे नईं।” यीशुए ज़ोवं, “अवं भी तीं सज़ारो हुक्म न देईं। अपने घरे जो गा ते फिरी पत्ती पापेरी न ज़िन्दगी ज़ीयां।” ");
INSERT INTO bhd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","यीशुए फिरी लोकन सेइं ज़ोवं, “दुनियारी लौ अव्वें आईं, ज़ै मीं पत्ती एज्जेलो त तै आंधरे मां न च़लेलो, पन तै लौ हासिल केरेलो ज़ै ज़िन्दगरी देचे।” ");
INSERT INTO bhd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","फरीसी लोकेईं तैस सेइं ज़ोवं, “तू अपनि गवाही एप्पू देतस, तेरी गवाही सच़्च़ी नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","यीशुए तैन जुवाब दित्तो, “भला अवं अपनि गवाही एप्पू देताईं फिरी भी मेरी गवाही सच़्च़ीए, किजोकि अवं ज़ानताईं कि अवं कोट्ठां ओरोईं ते कोरां गाताईं? पन तुस न ज़ानाथ कि अवं कोट्ठां ओरोईं ते कोरां गाताईं। ");
INSERT INTO bhd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","तुस इन्सानेरी सोचरे मुताबिक इन्साफ केरतथ, अवं केन्चेरी इन्साफ न केरि। ");
INSERT INTO bhd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ते अगर अवं इन्साफ केरि भी त मेरो इन्साफ सच़्च़ोए, किजोकि अवं अकैल्लो नईं, पन अवं ते मेरो बाजीए, ज़ैनी अवं भेज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","मूसेरे कानूने मां भी लिखोरोए कि दूई ज़नां केरि गवाही मिलतां सच़्च़ी भोतीए। ");
INSERT INTO bhd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","अक त अवं अपनि गवाही देताईं, ते दुइयोवं गवाही मेरो बाजी देते ज़ैनी अवं भेज़ोरोईं।” ");
INSERT INTO bhd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","तैनेईं तैस पुच़्छ़ू, “तेरो बाजी कोड़ि आए?” यीशुए जुवाब दित्तो, “न तुस मीं ज़ानतथ न मेरे बाजी, अगर मीं ज़ानते त मेरे बाजी भी ज़ानते।” ");
INSERT INTO bhd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","एना गल्लां तैनी मन्दरेरे अंगने मां शिक्षा देते भण्डार घरे मां ज़ोई, ते केन्चे तै न ट्लाव, किजोकि तैसेरो वक्त हेजू न थियो ओरो। ");
INSERT INTO bhd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","यीशुए फिरी तैन सेइं ज़ोवं, “अवं ज़ानताईं कि तुस मीं तोप्पेले ते पाप केरते-केरते मरेले, ज़ैड़ी अवं गाताईं तैड़ी तुस न एज्जी बटथ।” ");
INSERT INTO bhd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","एस पुड़ यहूदी लीडरेईं ज़ोवं, “कुन एने अपनो आप मारनोए, ज़ैन ज़ोते कि ज़ैड़ी अवं गाताईं तैड़ी तुस न एज्जी बटतथ?” ");
INSERT INTO bhd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","यीशुए तैन सेइं ज़ोवं, “तुस इस दुनियाई मां ज़र्मोरेथ, अवं स्वर्गेरां ओरोईं। तुस दुनियारेथ, अवं दुनियारो नईं। ");
INSERT INTO bhd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","एल्हेरेलेइ मीं तुसन सेइं ज़ोरू थियूं, कि तुस अपने पापन मां मरेले, किजोकि अगर तुस विश्वास न केरेले कि अवं तैए आईं त अपने पापन मां मरेले।” ");
INSERT INTO bhd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","यहूदी लीडरेईं तैस सेइं ज़ोवं, “तू कौन आस?” यीशुए तैन सेइं ज़ोवं, “ज़ैन शुरू करां ज़ोतो ओरोईं, अवं तैए आईं। ");
INSERT INTO bhd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","तुश्शे बारे मां मीं बड़ू किछ ज़ोनूए ते फैसलो केरनोए, पन मेरो भेज़ने बालो सच़्च़ोए, ते ज़ैन मीं तैस करां शुनोरूए तैन दुनियारे लोकन सेइं ज़ोताईं।” ");
INSERT INTO bhd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","तैनेईं एन न समझ़ू कि असन सेइं बाजी केरे बारे मां कुन ज़ोने लोरोए। ");
INSERT INTO bhd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","तैखन यीशुए ज़ोवं, “ज़ैखन तुस मैनेरे मट्ठे यानी मीं उच्चे पुड़ च़ाढ़ेले, त ज़ानेले कि अवं तैए आईं, अवं अपने आपे सेइं किछ न केरि, ज़ेन्च़रे मेरो बाजी मीं शिखालते तेन्च़रे तैना गल्लां केरताईं। ");
INSERT INTO bhd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","मेरो भेज़ने बालो मीं साथीए, तैनी अवं अकैल्लो नईं शारोरो किजोकि अवं हमेशा तैन कम केरताईं ज़ैस सेइं तै खुश भोते।” ");
INSERT INTO bhd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","बड़े लोकेईं यीशुएरी तैना गल्लां शुन्ते वक्त ज़ैना तै ज़ोईं राओरो थियो तैस पुड़ विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","तैखन यीशुए तैन यहूदन सेइं ज़ैनेईं तैस पुड़ विश्वास कियोरो थियो ज़ोवं, “अगर तुस मेरे वचने मां बनेरे राले, त सच़्च़े मेरे चेले भोले। ");
INSERT INTO bhd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","तुस सच़ ज़ानेले ते सच़ तुसन आज़ाद केरेलू।” ");
INSERT INTO bhd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","तैनेईं तैस जुवाब दित्तो, “अस त अब्राहमेरे औलादी मरां आम, ते कधी केन्चेरे गुलाम नईं भोरे, फिरी तू केन्च़रे ज़ोतस कि तुस आज़ाद भोले?” ");
INSERT INTO bhd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","यीशुए तैन जुवाब दित्तो, “अवं तुसन सेइं सच़-सच़ ज़ोताईं कि ज़ै कोई पाप केरते तै पापेरो गुलामे। ");
INSERT INTO bhd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","गुलाम हमेशा घरे न रेइ सके, मट्ठू हमेशा रहते। ");
INSERT INTO bhd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","एल्हेरेलेइ अगर मट्ठू तुसन आज़ाद केरे त सच़्च़े तुस आज़ाद भोले। ");
INSERT INTO bhd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","अवं ज़ानताईं कि तुसा अब्राहमेरे औलादी मरां आथ, फिरी भी मेरी शिक्षा तुस मन्नथ, एल्हेरेलेइ तुस मीं मारने चातथ। ");
INSERT INTO bhd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","अवं तैन्ने ज़ोताईं ज़ैन मीं लव, ज़ैखन अवं अपने बाजी सेइं साथी थियो, ते तुस तैन्ने केरतथ ज़ैन तुसेईं अपने बाजी केरां शुनोरूए।” ");
INSERT INTO bhd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","तैनेईं तैस जुवाब दित्तो, “इश्शो पूर्वज त अब्राहमे।” यीशुए तैन सेइं ज़ोवं, “अगर तुस अब्राहमेरे औलादी मरां भोथे त अब्राहमेरां ज़ेरां कम्मां केरेथ। ");
INSERT INTO bhd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","पन हुन्ना तुस मीं मारनो चातथ, किजोकि मीं तुसन तैना सच़्च़ी गल्लां ज़ोई ज़ैना मीं परमेशरे करां शुनी, एरू त अब्राहमे न थियूं कियोरू। ");
INSERT INTO bhd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","तुस अपने बाजेरां ज़ेरां कम्मां केरतथ।” तैनेईं तैस सेइं ज़ोवं, “अस बदमैशी सेइं नईं ज़र्मोरे, इश्शो अक्के बाजीए, ते तै परमेशरे।” ");
INSERT INTO bhd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","यीशुए तैन सेइं ज़ोवं, “अगर परमेशर तुश्शो बाजी भोथो, त तुस मीं सेइं प्यार केरेथ, किजोकि अवं परमेशरेरे करां ओरोईं, अवं अपने तरफां नईं ओरो, बल्के तैनी भेज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","तुस मेरी गल्लां किजो न समझ़थ? एल्हेरेलेइ कि तुस मेरी शिक्षा मन्नी न चाथ। ");
INSERT INTO bhd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","तुस अपने बाजी शैतानेरेथ, ते तैसेरी मर्ज़ी पूरी केरनि चातथ। तै त शुरू करां खूनी आए ते सच़्च़े पुड़ बनोरो न राव, किजोकि सच़ तैस मां अथ्थी नईं। ज़ैखन तै झूठ ज़ोते त अपने सुभावेरे मुताबिक ज़ोते, किजोकि तै झूठो बल्के झूठेरो बाजीए। ");
INSERT INTO bhd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","पन अवं सच़ ज़ोताईं तांए तुस मेरो विश्वास न केरथ। ");
INSERT INTO bhd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","तुसन मां मीं कौन पापेरो दोष लाते? अगर अवं सच़ ज़ोताईं त फिरी मेरो विश्वास की न केरथ? ");
INSERT INTO bhd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ज़ै परमेशरेरे तरफां भोते तै परमेशरेरी गल्लां केरते, ते तुस एल्हेरेलेइ न शुनथ किजोकि तुस परमेशरेरे तरफां नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","एना शुन्तां यहूदेईं तैस सेइं ज़ोवं, “कुन अस ठीक न थिये ज़ोते, कि तू सामरी मैन्हु आस, ते तीं मां भूते!” ");
INSERT INTO bhd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","यीशुए जुवाब दित्तो, “मीं मां भूत नईं, पन अवं अपने बाजेरी इज़्ज़त केरताईं, ते तुस मेरी निरादर केरतथ। ");
INSERT INTO bhd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","पन अवं अपनि बड़याई न चैई, हाँ अक्के ज़ै चाते कि लोक मेरी बड़याई केरन, ते तै आदालत केरनेबालो भी आए। ");
INSERT INTO bhd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","अवं तुसन सेइं सच़-सच़ ज़ोताईं कि ज़ै कोई मैन्हु मेरे वचने पुड़ च़ले तै कधे न मरेलो।” ");
INSERT INTO bhd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","यहूदेईं तैस सेइं ज़ोवं, “हुनी त असेईं बुझ़ू, कि तीं मां भूते, अब्राहम ते नबी भी मरे, ते तू ज़ोतस, अगर कोई मेरे वचने पुड़ च़ले त तै कधी न मरेलो। ");
INSERT INTO bhd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","इश्शो पूर्वज अब्राहम मरो, कुन तू तैस करां भी बड्डो आस? ते नबी भी मरे, तू अपने बारे मां कुन सोचतस कि तू कौन आस?” ");
INSERT INTO bhd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","यीशुए जुवाब दित्तो, “अगर अवं अपनि बड़याई केरि त मेरी बड़याई किछ भी नईं। पन मेरी बड़याई केरनेबालो मेरो बाजीए, ज़ैस तुस ज़ोतथ कि तै तुश्शो परमेशरे। ");
INSERT INTO bhd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","तुसेईं त तै न ज़ानो, पन अवं तैस ज़ानताईं, अगर अवं ज़ोईं कि तैस न ज़ैनी, त तुश्शो ज़ेरो झूठो भोइ। पन अवं तैस ज़ानताईं ते तैसेरे वचने पुड़ च़लताईं। ");
INSERT INTO bhd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","तुश्शो पूर्वज अब्राहम मेरी दिहाड़ी हेरनेरे उमीदी पुड़ बड़ी खुश थियो, ते तैनी हेरी, ते खुश भोव।” ");
INSERT INTO bhd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","यहूदेईं तैस्से सेइं ज़ोवं, “हेजू तू 50 साला केरो भी नईं भोरो फिरी भी तीं अब्राहम लोरोए?” ");
INSERT INTO bhd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","यीशुए तैन सेइं ज़ोवं, “अवं तुसन सेइं सच़-सच़ ज़ोताईं कि अब्राहम पैदा भोने करां पेइलो, अवं आईं।” ");
INSERT INTO bhd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","तैखन तैनेईं तैस मारनेरे लेइ घोड़ सल्ले, पन यीशु छ़ेपतां मन्दरे मरां निस्सी जेव। ");
INSERT INTO bhd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","फिरी यीशुए अपने चेलन सेइं साथी च़लोरो थियो, ते तैनेईं अक मैन्हु लाव, ज़ै ज़र्मनेरो कानो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","तैसेरे चेलेईं तैस पुच़्छ़ू, “हे गुरू, केने पाप कियो कि ए कानो ज़रमो, एने मैने या एसेरे अम्मा बाजे?” ");
INSERT INTO bhd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","यीशुए जुवाब दित्तो, “न एने पाप कियो, न एसेरे अम्मा-बाजेईं, पन तै एल्हेरेलेइ कानो ज़रमो ताके परमेशरेरे चमत्कार एसमां लेईहोन। ");
INSERT INTO bhd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ज़ैने अवं भेज़ोरोईं, असेईं तैसेरू कम लूशी केरनू ज़रूरीए, ज़ैन कम तैनी असन दित्तोरूए, तै रात एजने बालीए ज़ैस मां कोई भी कम न केरि सके। ");
INSERT INTO bhd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ज़ांतगर अवं दुनियाई मां आई, अवं दुनियारी लौ आई।” ");
INSERT INTO bhd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","एन ज़ोइतां तैनी ज़मीनी पुड़ थुकू, ते तैस थुके सेइं मित्ती सन्नी, ते तै मित्ती कानेरे एछ़्छ़न पुड़ लाई। ");
INSERT INTO bhd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ते तैस सेइं ज़ोवं, “गा शीलोह नंव्वेरे हावदे मां अपनू तुत्तर धो” (शीलोहेरे मतलब भेज़रो) तैनी गेइतां धोवं, ते लांतो वापस अव। ");
INSERT INTO bhd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","तैखन तैस मैनेरे पड़ोसेईं त ज़ैनेईं तै भीख मगतो लावरो थियो, एक्की होरि सेइं ज़ोने लग्गे, “कुन ई तैए मैन्हु नईं ज़ै पेइलो बिश्तां भीख मगतो थियो?” ");
INSERT INTO bhd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","किछ मैन्हु ज़ोने लाए, “ई तैए,” होरेईं ज़ोवं, “नईं तैसेरो ज़ेरो कोई होरो भोनोए,” तैनी ज़ोवं, “अवं तैए आईं।” ");
INSERT INTO bhd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","तैखन तैना तैस पुच्छ़ने लग्गे, “तेरी एछ़्छ़न केन्च़रां लौ आई?” ");
INSERT INTO bhd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","तैनी जुवाब दित्तो, “यीशु नंव्वेरे एक्की मैने मित्ती सन्नी, ते मेरी एछ़्छ़न पुड़ लेइतां मीं सेइं ज़ोवं, गा शीलोह हावदे मां गेइतां अपनू तुत्तर धो, ते अवं जेव ते मीं तुत्तर धोवं, ते लांने लाव।” ");
INSERT INTO bhd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","तैनेईं तैस पुच़्छ़ू, “तै मैन्हु कोड़ि आए?” तैनी ज़ोवं, “मीं नईं पतो।” ");
INSERT INTO bhd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","लोकेईं तै ज़ै पेइलो कानो थियो फरीसी लोकन कां नेव। ");
INSERT INTO bhd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ज़ैस दिहाड़े यीशुए मित्ती सैनतां तैसेरी एछ़्छ़ी लौ दित्तो थी, तै आरामेरी दिहाड़ी थी। ");
INSERT INTO bhd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","फिरी फरीसी लोकेईं भी तैस पुच़्छ़ू, “तैसेरी एछ़्छ़न लौ केन्च़रे आई?” तैनी तैन सेइं ज़ोवं, “तैनी मेरी एछ़्छ़न पुड़ मित्ती लाई, फिरी मीं तुत्तर धोवं, ते अवं हुनी लाताईं।” ");
INSERT INTO bhd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","एस पुड़ किछ फरीसी लोक ज़ोने लगे, “ए मैन्हु परमेशरेरे तरफां नईं, किजोकि ए आरामेरी दिहाड़ी न मन्ने।” होरेईं ज़ोवं, “एरो ज़ेरो पापी मैन्हु एरे चमत्कार केन्च़रे हिरेई बटते?” ते तैन एप्पू मांमेइं अनबन भोइ। ");
INSERT INTO bhd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","तैनेईं काने फिरी पुच़्छ़ू, “ज़ैने तेरी एछ़्छ़ी खोलोरेन, तू तैसेरे बारे मां कुन ज़ोतस?” तैनी ज़ोवं, “तै नबी आए।” ");
INSERT INTO bhd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","पन यहूदी लीडरन विश्वास न भोव, कि तै कानो थियो ते हुनी लाते, ज़ांतगर तैनेईं, तैसेरे अम्मा-बाजी न कुजाए। ");
INSERT INTO bhd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","तैन पुच़्छ़ू, कुन एन तुश्शू मट्ठूए, “ज़ैस तुस ज़ोतथ कि कानो ज़र्मोरू थियूं? फिरी हुना केन्च़रां लाते?” ");
INSERT INTO bhd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","तैसेरे अम्मा बाजीए जुवाब दित्तो, “असां त ज़ानतम कि एन इश्शू मट्ठूए, ते कानो ज़र्मोरू थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","पन अस इन न ज़ानतम कि अज़ केन्च़रे लाते, ते न इन ज़ानतम कि केने एसेरी एछ़्छ़न लौ दित्ती, एन हुनी बड्डूए एस पुछ़ा, ए अपने बारे मां एप्पू ज़ोलो।” ");
INSERT INTO bhd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","एना गल्लां तैसेरे अम्मा बाजे एल्हेरेलेइ ज़ोई तैना यहूदी लीडरन करां डरते थिये, किजोकि यहूदी लीडर सारे अक भोरे थी, कि अगर कोई जोए, कि ए मसीहे त तै प्रार्थना घरे मरां कड्डो गाए। ");
INSERT INTO bhd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","एल्हेरेलेइ तैसेरे अम्मा बाजे ज़ोवं, “एन बड्डूए, एस्से पुछ़ा।” ");
INSERT INTO bhd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","तैखन तैस मैन्हु ज़ै कानो थियो, दुइयोवं बार कुजेइतां ज़ोवं, “सच़ ज़ोइतां परमेशरेरी बड़याई केर, अस ज़ानतम तै मैन्हु पापीए।” ");
INSERT INTO bhd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","तैनी जुवाब दित्तो, “अवं न ज़ैनी कि ए पापी कि नईं, अवं अक गल ज़ानताईं, कि अवं कानो थियो हुनी लाताईं।” ");
INSERT INTO bhd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","तैनेईं तैस पुच़्छ़ू, “तैने तीं सेइं कुन कियूं? तैनी केन्च़रे तेरी एछ़्छ़न लौ दित्ती?” ");
INSERT INTO bhd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","तैनी तैन सेइं ज़ोवं, “मीं त तुसन सेइं ज़ोवरूए, ते तुसेईं न शुनू, हुनी दुइयोवं बार किजो शुनू चातथ? कुन तुस भी तैसेरे चेले बन्ने चातथ?” ");
INSERT INTO bhd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","तैखन तैना तैस बुरू भलू ज़ोने लाए, “तूए तैसेरो चेलोस, अस त मूसेरे चेलेम।” ");
INSERT INTO bhd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","अस ज़ानतम परमेशरे मूसा सेइं गल्लां की, पन एस न ज़ानम कि ए कोट्ठां ओरोए। ");
INSERT INTO bhd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","तैनी तैन जुवाब दित्तो, “ए त बड़ी बड्डी गल्ले कि तुस न ज़ानाथ कि ए कोट्ठां ओरोए, फिरी भी तैनी मेरी एछ़्छ़न लौ दित्ती। ");
INSERT INTO bhd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","अस ज़ानतम की परमेशर पापी केरि न शुने, पन कोई परमेशरेरो भक्त भोए त तैसेरे मेर्ज़ी पुड़ च़लतो भोए, त परमेशर तै तैसेरी शुनते। ");
INSERT INTO bhd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","दुनिया रच़नेरे वक्ते करां कधे शुन्ने मां नईं ओरोए कि केन्चे ज़र्मनेरे कानेरी एछ़्छ़न लौ दित्तोरी, ");
INSERT INTO bhd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","अगर ए मैन्हु परमेशरेरे तरफां न भोथो त किछ न केरि सकेथो।” ");
INSERT INTO bhd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","तैनेईं तैस ज़ोवं, “तू त बिलकुल पापन मां ज़र्मोरोस, तू असन शिखालतस?” ते तैनेईं तै प्रार्थना घरे मरां बेइरोवं कड्डो। ");
INSERT INTO bhd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","यीशुए शुनू कि तै बेइरोवं कड्डोरोए, ते ज़ैखन तैसेरी तैस सेइं मुलाकात भोइ, त तैस सेइं ज़ोवं, “कुन तू मैनेरे मट्ठे पुड़ विश्वास केरतस?” ");
INSERT INTO bhd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","तैनी तैस जुवाब दित्तो, “हे प्रभु, मीं सेइं ज़ो कि तै कौने, ताके अवं तैस पुड़ विश्वास केरि?” ");
INSERT INTO bhd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","यीशुए तैस सेइं ज़ोवं, “अव्वें आईं, तीं अवं पेइलो लोरोईं, ज़ै तीं सेइं गल्लां केरि राओरोए।” ");
INSERT INTO bhd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","तैनी ज़ोवं, “हे प्रभु, अवं तीं पुड़ विश्वास केरताईं।” ते तैस कां मथ्थो टेको। ");
INSERT INTO bhd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","तैखन यीशुए ज़ोवं, “अवं इस दुनियाई मां ई इन्साफ केरने ओरोईं, ज़ैना न लान तैना लान, ते ज़ैना लातन तैना काने भोन।” ");
INSERT INTO bhd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ज़ैना फरीसी लोक तैस सेइं साथी थिये तैनेईं ज़ोवं, “कुन तू असन जो भी काने ज़ोतस?” ");
INSERT INTO bhd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","यीशुए तैन सेइं ज़ोवं, “अगर तुस काने भोथे त पापी न भोथे, पन हुनी ज़ोतथ कि अस लातम, एल्हेरेलेइ तुश्शे पाप माफ़ न भोले।” ");
INSERT INTO bhd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“अवं तुसन सेइं सच़-सच़ ज़ोताईं, कि ज़ै कोई दारेरे बत्तां बाड़े मां न गाए, पन होरि बत्तां गाते, तै च़ोर ते डैकूए। ");
INSERT INTO bhd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","पन भैड्डां केरो पुहाल दारेरे बत्तां गाते। ");
INSERT INTO bhd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","तैसेरेलेइ दरबान दार खोलते, ते भैड्डां तैसेरी गल पिशैनतिन, ते तै अपनि भैड्डन नंव्वे सेइं कुजाते ते बेइर नेते। ");
INSERT INTO bhd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ते ज़ैखन तै अपनि सैरी भैड्डां बेइर कढते, त तैन केरे अग्री-अग्री च़लते, ते भैड्डां तैस पत्ती-पत्ती गैतिन, किजोकि तैना तैसेरी आवाज़ पिशैनचन। ");
INSERT INTO bhd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","तैना बखले पत्ती न गैली, पन तैस करां नश्शेली, किजोकि तैना बखलेरी आवाज़ न पिशानन्।” ");
INSERT INTO bhd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","यीशुए तैन सेइं मिसाल देइतां ज़ोवं, पन तैनेईं न समझ़ू कि एसेरी गल्लां केरो कुन मतलबे, ज़ैना तै असन सेइं ज़ोते। ");
INSERT INTO bhd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","तैखन यीशुए तैन सेइं फिरी ज़ोवं, “अवं तुसन सेइं सच़-सच़ ज़ोताईं, भैड्डां केरू दार अव्वें आईं। ");
INSERT INTO bhd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ज़ेत्रे मीं करां पेइले आए सब च़ोर ते डैकून, पन मेरी भैड्डेईं तैन केरि न शुनी। ");
INSERT INTO bhd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","दार अवं आईं, अगर कोई मेरे ज़िरिये अन्तर गालो, त परमेशर तैस मुक्ति देलो, ते तै अन्तर बेइर एइतो गालो ते खूराक पालो। ");
INSERT INTO bhd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","च़ोर होरि कोन्ची कम्मेरे लेइ न एज्जे, बल्के च़ोरी केरने ते मारने ते नाश केरने एइते, अवं एल्हेरेलेइ ओरोईं कि तैन भरपूर ज़िन्दगी ज़ीन। ");
INSERT INTO bhd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","रोड़ो पुहाल अव्वें आईं, रोड़ो पुहाल भैड्डां केरे लेइ अपनि जान देते। ");
INSERT INTO bhd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ज़ैखन नौकर गिद एंइतू लाते त तै भैड्डां शैरतां नेश्शी गालो। किजोकि तै तैन केरो न पुहाले न मालिके, ते गिद तैन पुड़ हमलो केरतां तितर-बितर केरते। ");
INSERT INTO bhd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","तै एल्हेरेलेइ नशते कि तै नौकर आए, ते तैस भैड्डां केरि फिक्र नईं। ");
INSERT INTO bhd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","रोड़ो पुहाल अवं आईं, अवं अपनि भैड्डां पिशानताईं, ते मेरी भैड्डां मीं पिशैनचन। ");
INSERT INTO bhd_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ज़ेन्च़रे बाजी मीं ज़ानाते, तेन्च़रे अवं भी तैस ज़ानताईं, ते अवं भैड्डां केरे लेइ अपनि जान देताईं। ");
INSERT INTO bhd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ते मेरी होरि भी भैड्डन, ज़ैना इस बाड़े मां नईं, मीं तैना भी ऐनिन ज़रूरिन, तैना मेरी आवाज़ पिशैनेली, फिरी अक्के डेरो ते अक्के पुहाल भोनोए। ");
INSERT INTO bhd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","अवं अपनि जान देताईं, एल्हेरेलेइ बाजी मीं सेइं प्यार केरते, कि अवं फिरी ज़ींतो भोईं। ");
INSERT INTO bhd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","कोई मेरी ज़िन्दगी मीं करां न थसोड़े, बल्के अवं एप्पू देताईं, मीं तैस देनेरू भी अधिकारे ते नेनेरो भी अधिकारे, ई हुक्म मीं मेरे बाजी करां मैलोरोए।” ");
INSERT INTO bhd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","एल्लां पत्ती, यहूदन मां फिरी अनबन भोइ। ");
INSERT INTO bhd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","तैन मरां बड़े ज़ोने लाए, “तैस मां भूते, ते तै पागले, तैसेरी किजो शुनातथ?” ");
INSERT INTO bhd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","होरे लोकेईं ज़ोवं, “एना गल्लां एरे मैनेरी नईं ज़ैस मां भूत भोए, कुन भूत कांना केरि एछ़्छ़ी खोल्ली बटते?” ");
INSERT INTO bhd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","यरूशलेम नगरे मां तिहार भोवं, ते हीवतड़ेरो मौसम थियो। ");
INSERT INTO bhd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","यीशु सुलैमानेरे मन्दरेरे अंगने मां हंठने फिरने लग्गोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","तैखन यहूदेईं तै घेरो ते पुच़्छ़ू, “तू केइस तगर इश्शे दिले डामाडोल केरतस? असन सेइं साफ-साफ ज़ो। कुन तू मसीह आस?” ");
INSERT INTO bhd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","यीशुए तैन जुवाब दित्तो, “मीं तुसन सेइं ज़ोवं पन तुस विश्वास न केरथ। ज़ैना कम्मां अवं अपने बाजी केरे अधिकारे सेइं केरताईं तैना मेरे गवाह आन। ");
INSERT INTO bhd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","पन तुस एल्हेरेलेइ विश्वास न केरथ कि मेरी भैड्डन मरां नईं। ");
INSERT INTO bhd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","मेरी भैड्डां मेरी आवाज़ पिशैनचन, अवं तैन ज़ानताईं, ते तैना मीं पत्ती-पत्ती च़ेलचन। ");
INSERT INTO bhd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ते अवं तैन हमेशारी ज़िन्दगी देताईं, तैना कधी नाश न भोले, ते कोई तैन मेरे हथ्थे मरां न थसोड़ी सके। ");
INSERT INTO bhd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","मेरो बाजी, ज़ैनी तैना मीं दित्तोरिन, सेब्भन करां महान आए, ते कोई तैन बाजी केरे हथ्थे मरां न नेइ बटे। ");
INSERT INTO bhd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","अवं त बाजी अक्के आम।” ");
INSERT INTO bhd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","दुबारां फिरी, यहूदेईं तैस घोड़ेव देनेरे लेइ फिरी घोड़ सल्ले। ");
INSERT INTO bhd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","एस पुड़ यीशुए तैन सेइं ज़ोवं, “मीं अपने बाजी केरे तरफां बड़ां रोड़ां कम्मां हिरां, तैन मरां कोस कम्मेरे लेइ घोड़ेव देतथ?” ");
INSERT INTO bhd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहूदेईं तैस जुवाब दित्तो, “रोड़ां कम्मां केरे लेइ अस तीं पुड़ घोड़ेव नईं केरने लेवरे, पन परमेशरेरी तुहीन केरनेरे लेइ, एल्हेरेलेइ कि मैन्हु भोइतां अपनो आप परमेशर बनातस।” ");
INSERT INTO bhd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","यीशुए तैन जुवाब दित्तो, “मूसेरे कानूने मां एन लिखोरू कि परमेशरे अपने लोकां केरे लीडरन सेइं ज़ोवं कि तैना ईश्वरन। ");
INSERT INTO bhd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","(तुसन पत्तोए पवित्रशास्त्रेरी गल कोई भी बेदली न बटे) अगर परमेशरे तैन लोकन जो ईश्वर ज़ोवं ज़ैन कां परमेशरेरू वचन पुज़्ज़ू, ");
INSERT INTO bhd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","फिरी तुस किजो ज़ोतथ कि तू तुहीन केरतस, ज़ैखन अवं ज़ोताईं कि अवं परमेशरेरू मट्ठू आईं? बाजी परमेशरे अवं पवित्र ठहरेइतां दुनियाई मां भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","अगर अवं अपने बाजेरू कम न केरि, त मेरो विश्वास न केरा। ");
INSERT INTO bhd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","पन अगर अवं अपने बाजेरू कम केरताईं, त चाए तुस मेरो विश्वास न भी केरा, पन तैन कम्मन पुड़ विश्वास केरा। तैखन तुस बुज़्झ़ेले ते समझ़ेले कि बाजी मीं मां आए, ते अवं बाजी मां आईं। ");
INSERT INTO bhd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","तैनेईं फिरी तैस ट्लानेरी कोशिश की, पन तै तैन करां च़लो जेव।” ");
INSERT INTO bhd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","फिरी यीशु यरदन दरियारे पार तैस ठैरी जेव, ज़ैड़ी यूहन्ना पेइले बपतिस्मो देतो थियो, ते तैड़ी राव। ");
INSERT INTO bhd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","बड़े लोक तैस कां एइतां ज़ोते थिये, “यूहन्ना त कोई चमत्कारी निशान न हिराव, पन ज़ैन किछ यूहन्ना एसेरे बारे मां ज़ोवं, तैन सब सच़ थियूं।” ");
INSERT INTO bhd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ते तैड़ी बड़ेईं यीशु पुड़ विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","मरियम ते तैसेरी बेइन मार्थारे ड्लव्वें बैतनिय्याह मां लाज़र नव्वेंरो अक मैन्हु थियो ");
INSERT INTO bhd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ई तैए मरियम थी ज़ैसां बादे मां प्रभु पुड़ इत्र छ़ेडतां अपने बालन सेइं तैसेरे पाव पूंछ़ोरे थी, एसेरो ढ्ला लाज़र बिमार थियो। ");
INSERT INTO bhd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","तैखन तैसेरी बेइने यीशु कां अक बिस्तार भेज़ो, “हे प्रभु, ज़ैस सेइं तू प्यार केरतस तै बिमारे।” ");
INSERT INTO bhd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ज़ैखन यीशुए एन शुनू त ज़ोवं, “ए बिमारी मरनेरे लेइ नईं बल्के परमेशरेरी महिमारे लेइ आए, ताके तैसेरे ज़िरिये परमेशरेरे मट्ठेरी महिमा भोए।” ");
INSERT INTO bhd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","यीशु मार्था ते तैसेरी बेइन मरियम ते लाज़रे सेइं प्यार केरतो थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ज़ैखन यीशुए शुनू कि, लाज़र बिमारे, पन फिर भी दूई दिहाड़े तैड़ी बिश्शो ज़ैड़ी तै थियो। ");
INSERT INTO bhd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","दूई दिहैड़ना बाद यीशुए अपने चेलन सेइं ज़ोवं, “एज्जा, अस फिरी यहूदिया इलाके मां गाम।” ");
INSERT INTO bhd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","चेले ज़ोने लगे, “हे गुरू, थोड़े च़िर पेइले यहूदी लीडर तीं घोड़ेईं बाते थिये, ते तू फिरी तैड़ी गानू चातस?” ");
INSERT INTO bhd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","यीशुए जुवाब दित्तो, “कुन दिहैड़ी मां 12 घंटे न भोन? ज़ै दीसां च़लते तैस ठोकर न लगे, एल्हेरेलेइ कि तै दुनियारी लोई मां च़ेलि सकते। ");
INSERT INTO bhd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","पन अगर तै राती च़लते त आंधरे मां तैस ठोकर लगचे, किजोकि तैस कां लौ नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","तैनी एना गल्लां ज़ोई, ते अपने चेलन सेइं ज़ोने लगो, “इश्शो दोस्त लाज़र झ़़ुलोरोए पन अवं तैस बीझांने च़लोरोईं।” ");
INSERT INTO bhd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","तैसेरे चेले ज़ोने लगे, “हे प्रभु अगर तै झ़़ुलोरोए त तै बीझ़ेलो।” ");
INSERT INTO bhd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","यीशुए लाज़रेरे मरनेरे बारे मां ज़ोरू थियूं, पन तैसेरे चेलेईं बुझ़ू कि तैसेरो मतलब निड्लारे बारे मां झ़़ुलोरोए, पन अवं तैस बीझ़ाने च़लोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तैखन यीशुए रोड़ेच़ारे ज़ोवं, “लाज़र मेरि जेवरोए। ");
INSERT INTO bhd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","अवं खुश आई कि तुश्शे लेइ फैइदोए, कि अवं तैड़ी न थियो ज़ैस सेइं विश्वास केरथ। हुनी एज्जा अस तैड़ी गाम।” ");
INSERT INTO bhd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तैखन थोमा ज़ैस जो दिदुमुस ज़ोतन, होरि चेलन सेइं ज़ोने लगो, “एज्जा, अस भी तैस सेइं साथी मरनेरे लेइ गाम।” ");
INSERT INTO bhd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ज़ैखन यीशुए बैतनिय्याह ड्लव्वें मां पुज़्ज़ो त तैस पतो लगो, कि लाज़र दब्बोरे च़ेव्रे दिहाड़े भोरेन ");
INSERT INTO bhd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बैतनिय्याह यरूशलेम नगरेरां कोई ट्लाई किलोमीटर दूर थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","बड़े यहूदी लोक मार्था ते मरियमी कां तैन केरे ढ्ला लाज़रेरे मरनेरां पत्ती तैना तसल्ली देने ओरे थिये। ");
INSERT INTO bhd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ज़ैखन मार्था शुनू कि यीशु ओरोए तै तैस सेइं मिलनेरे लेइ बेइर निस्सी, पन मरियम बेइर न निस्सी। ");
INSERT INTO bhd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मार्था यीशुए सेइं ज़ोने लगी, “हे प्रभु, अगर तू इड़ी भोथो त मेरो ढ्ला न थियो मरनो। ");
INSERT INTO bhd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","पन अवं ज़ानती, हुनी ज़ैन किछ तू परमेशरे करां मगेलो, ते परमेशर तीं देलो।” ");
INSERT INTO bhd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","यीशुए तैस ज़ोवं, “तेरो ढ्ला ज़ींतो भोइ गानोए।” ");
INSERT INTO bhd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मार्था तैस सेइं ज़ोवं, “अवं ज़ानती तै आदालतरे दिहाड़े ज़ेइस सारे लोक ज़ींते भोनेन, तेइस तै भी ज़ींतो भोइ गानोए।” ");
INSERT INTO bhd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","यीशुए तैस ज़ोवं, “मैनन् मुड़दन मरां ज़ींते केरनेबालो अव्वें आईं। ज़ै मीं पुड़ विश्वास केरते तै मरनेरां बाद भी ज़ींतो रालो। ");
INSERT INTO bhd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ते ज़ै कोई ज़ींतोए, ते मीं पुड़ विश्वास केरते, तै कधे न मरेलो, कुन तू इस पुड़ विश्वास केरचस?” ");
INSERT INTO bhd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","मार्था जुवाब दित्तो, “हाँ प्रभु, मेरो विश्वास तीं पुड़े, कि तू परमेशरेरू मट्ठू मसीह ज़ैन दुनियाई मां एजनेबालू थियूं।” ");
INSERT INTO bhd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ज़ैखन तैसां ए गल ज़ोई त तै वापस च़ली जेई, ते अपनि बेइन मरियम कनारे कुजेइतां ज़ोने लगी, “गुरू जी ओरेन ते तीं कुजाने लगोरेन।” ");
INSERT INTO bhd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","तै एन शुन्तां लूशी उट्ठतां यीशु सेइं मिलने च़ली आई। ");
INSERT INTO bhd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","यीशु हेजू ड्लव्वें मां न थियो पुज़ोरो, पन तै तैड़ी थियो ज़ैड़ी मार्था तैस सेइं मिलोरी थी। ");
INSERT INTO bhd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","तैखन तैना यहूदी लोक ज़ैना मरियमी तस्सली देने ओरे थिये मरियम लूशी खड़ी उट्ठतां बेइर जेई, त तैना भी तैस पत्ती बेइर जे, कि भोइ सकते ए लेरां देने कब्री पुड़ च़लोरिए। ");
INSERT INTO bhd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ज़ैखन मरियम तैस ठारी पुज़ी ज़ैड़ी यीशु थियो त तैस लेइतां तै तैसेरे पवन पुड़ बिछ़ड़ी जेई ते ज़ोने लगी, “हे प्रभु अगर तू इड़ी भोथो त मेरो ढ्ला न थियो मरनो।” ");
INSERT INTO bhd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ज़ैखन यीशुए तै ते तैस सेइं साथी एजनेबाले यहूदी लोक लेरां देते लाए, तै आत्माई मां उदास भोइतां बड़ो दुःखी भोव। ");
INSERT INTO bhd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ते पुच़्छ़ू, “तुसेईं लाज़र कोड़ि रख्खोरोए?” तैना ज़ोने लगे, “हे प्रभु, असन सेइं साथी एइते एप्पू हेर।” ");
INSERT INTO bhd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","यीशु लेरां देने लगो। ");
INSERT INTO bhd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","तैखन यहूदी लोक ज़ोने लगे, “हेरा, ए लाज़रे सेइं केत्रो प्यार केरतो थियो।” ");
INSERT INTO bhd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","पन तैन मरां किछ ज़ोने लगे, “कुन ज़ैनी कानेरी एछ़्छ़न लौ दित्ती, इन भी न केरि बट्टू, कि ए मैन्हु न मरेथो?” ");
INSERT INTO bhd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","यीशु दुखी दिले सेइं कब्री कां अव, तै अक कुढ थी, ज़ैस पुड़ अक घोड़ छ़डोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","यीशु ज़ोने लगो, “घोड़ खड़ो केरा।” मार्था ज़ै लाज़री बेइन थी तै ज़ोने लगी, “हे प्रभु एस मरां त मुशक लोरीए एजने, किजोकि एस च़ेव्रे दिहाड़े मर्रे भोरेन।” ");
INSERT INTO bhd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","यीशुए तैस सेइं ज़ोवं, किजोकि, “मीं तुसन न थियूं ज़ोरू कि अगर तेरो विश्वास भोलो, त तू परमेशरेरी महिमा हेरेली।” ");
INSERT INTO bhd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तैखन तैनेईं तै घोड़ घिसाव, ते यीशुए उबरे तेकतां ज़ोने लगो, “हे बाजी, अवं तेरू शुक्र केरतां कि तीं मेरी शुनी। ");
INSERT INTO bhd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","अवं ज़ानतो थियो, कि तू मेरी प्रार्थना शुन्तस पन अवं एन लोकां केरे लेइ ज़ैना च़ेव्रे पासन खेड़ोरेन एन ज़ोरू थियूं कि एना भी विश्वास केरन, कि तीं अवं भेज़ोरोईं।” ");
INSERT INTO bhd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","एन ज़ोनेरां पत्ती यीशुए ज़ोरे सेइं ज़ोवं, “लाज़र बेइर निस!” ");
INSERT INTO bhd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ते तै मुओरो लाज़र बेइर निस्सो ज़ेसेरे हथ पाव कफने सेइं बंधोरे थिये ते दोग्गे अक कपड़ो बंधोरो थियो। यीशुए तैन सेइं ज़ोवं, “एस खोल्ला ते एस गाने देथ।” ");
INSERT INTO bhd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","बड़े यहूदी लोक ज़ैना मरियम सेइं मिलने ओरे थिये। ते तैसेरां इन्ना कम्मां हेरतां तैस पुड़ विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","पन तैन मरां किछेईं फरीसन कां गेइतां सब शुनावं ज़ैना यीशुए कियेरू थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","एस पुड़ प्रधान याजकन ते फरीसी लोक महासभारे लोक अकोट्ठे किये ते ज़ोने लगे, “अस कुन केरम? ए मैन्हु त इड़ी बड़े चमत्कार लोरोए केरने। ");
INSERT INTO bhd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","अगर अस एस हुन्ना न रोकमेले त सारे लोक तैस पुड़ विश्वास केरेले, कि ए मसीह आए, ते फिरी रोमेइं इड़ी एइतां इश्शे मन्दरे ते इश्शी कौमी दुइने नाश केरेले।” ");
INSERT INTO bhd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","तैखन तैन केरे टोली मरां अक ज़ेसेरू नवं कैफा थियूं, ज़ै तैस साल मन्दरेरो महायाजक थियो ज़ोने लगो, “तुस लोक किछ न ज़ांनाथ, ");
INSERT INTO bhd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","तुसन इन न समझ़थ कि, तुश्शे लेइ रोड़ूए, इश्शे लोकां केरे लेइ अक मैन्हु मरे, न कि इश्शे सारे लोक।” ");
INSERT INTO bhd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ए गल तैनी अपने आपे सेइं न थी ज़ोरी, पन तैस साल महायाजक भोइतां भविष्‍यद्वाणी, कि यीशु इस्रएलेरे सारे लोकां केरे लेइ अपनि जान देलो। ");
INSERT INTO bhd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","तै सिर्फ इस्रएलेरे लोकां केरे लेइ नईं, पन एल्हेरेलेइ भी कि ज़ैना परमेशरे बच्चे तितर-बितर भोरेन तैन अकोट्ठे केरतां अक बनाए। ");
INSERT INTO bhd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","बस्सा, यहूदी लीडरेईं तैस दिहाड़ेरे बाद यीशु मारेरो इरादो कियो। ");
INSERT INTO bhd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","एल्हेरेलेइ यीशुए तैस वक्ते करां यहूदन मां बांदे मां न फिरो, पन जंगलेरे नेड़े एप्रैम नगरे मां जेव, ते अपने चेलन सेइं साथी तैड़ी राने लगो। ");
INSERT INTO bhd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","तेइस यहूदी केरू फ़सह तिहार नेड़े अव, ते बड़े लोक आसेपासेरे इलाकन मरां यरूशलेम नगरे मांजो च़ले जे, ताके अपनो आप शुद्ध केरन। ");
INSERT INTO bhd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","तैना यीशु तोपते थिये तेइस तैना मन्दरे मां अकोट्ठे भोए, ते एक्की होरि सेइं ज़ोने लगे, “तुस कुन समझ़तथ? कोई पत्तोए कुन तै इड़ी फ़सह तिहारे मां एज्जेलो कि नईं?” ");
INSERT INTO bhd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ते प्रधान याजकेईं ते फरीसी लोकेईं हुक्म दित्तोरो थियो कि अगर केन्ची पतो लगे कि यीशु कोड़ि आए त ज़ोथ दे ताके असां तैस गिरफ्तार केरम। ");
INSERT INTO bhd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","फ़सह तिहारे करां शा दिहाड़े पेइले यीशु बैतनिय्याह ड्लव्वें मांजो च़लो अव, ज़ैड़ी लाज़र रातो थियो, ज़ै यीशुए मुड़दन मरां ज़ींतो कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","तैड़ी तैनेईं यीशुएरी खातरदारी केरनेरे लेइ धाम बनाई। ते मार्था सेवा लोरी थी केरने, लाज़र भी तैन मरां अक थियो ज़ैना यीशु सेइं साथी रोट्टी खाने बिश्शोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","तैखन मरियमा जटामासी सेइं बनोरो अध्धो लीटर खुशबूदार इत्र ज़ै बड़ो कीमती थियो, यीशुएरे पावन मल्लो, ते अपने दोग्गेरे बालन सेइं पोंछ़ने लगी, ते सारू घर रोड़ी मुशकी सेइं भेरोई जेव। ");
INSERT INTO bhd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","पन तैसेरे चेलन मरां अक यहूदा इस्करियोती नव्वेंरो अक चेलो, ज़ैनी यीशु ट्लुवेवरो थियो ज़ोने लगो, ");
INSERT INTO bhd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ई इत्र 300 दीनारन मां बेच़तां गरीबन किजो न दित्तो?” ");
INSERT INTO bhd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","तैनी एना गल्लां एल्हेरेलेइ न थी ज़ोरी, कि तैस गरीबां केरो खियाल थियो, पन एल्हेरेलेइ ज़ोवं कि तै च़ोर थियो, तैस कां पेइंसां केरि झोली भोती थी, ते ज़ैन किछ तैस मां रखते थी तै कढतो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","यीशुए ज़ोवं, “एस तंग न केरा, एसां वक्तेरे पेइले मेरी जान दब्बनेरी तियारी कियोरीए। ");
INSERT INTO bhd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","किजोकि गरीब लोक त तुसन सेइं साथी सदा रातन, पन अवं तुसन सेइं साथी सदा नईं रानो।” ");
INSERT INTO bhd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","मैन्हु केरि बड़ी भीड़ी तैड़ी आई ज़ैखन तैनेईं शुनू कि यीशु तैड़ी अव। तैना सिर्फ यीशु नईं बल्के लाज़रे भी हेरने ओरे थिये, ज़ै तैनी मुड़दन मरां ज़ींतो कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","तैखन प्रधान याजके लाज़र भी मारनेरी सलाह की। ");
INSERT INTO bhd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","किजोकि बड़े लोक यहूदी लीडरन करां च़ले जे, ते तैनेईं यीशु पुड़ विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","होरसां मैन्हु केरि बड़ी भीड़ तिहारे मां आई। ज़ैखन तैनेईं शुनू कि यीशु भी यरूशलेम नगरे मां एजनेबालोए, ");
INSERT INTO bhd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","त तैनेईं खजूरां केरि डेलड़ी हथ्थन मां रेखतां नहरे देते तैस सेइं मिलनेरे लेइ निस्से ते ज़ोने लगे, “होशाना (तारीफ़) धने इस्राएलेरो राज़ो, ज़ै प्रभुएरे नंव्वे सेइं एइते।” ");
INSERT INTO bhd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ज़ैखन यीशु अक गधरो बच्चो मैल्लो, ते तै तैस पुड़ बिश्तां यरूशलेम नगरे मांजो अव, ज़ेन्च़रे पवित्रशास्त्रे मां लिखोरूए तेन्च़रे एन भोवं, ");
INSERT INTO bhd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“हे सिय्योनेरी कुई (यरूशलेमेरे लोक), तू न डर, हेर, तेरो राज़ो एज्जी राओरोए, ते तै गधेरे बच्चे पुड़ च़ेढ़तां एज्जी राओरोए।” ");
INSERT INTO bhd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","पेइलू त यीशुएरे चेलेईं किछ न समझ़ू, पन ज़ैखन यीशुएरी महिमा बांदी भोइ, तैनेईं तैना सैरी गल्लां याद की, एन सब गल्लां तैसेरे बारे मां लिखोरी थी, ते लोकेईं एरो ज़ेरो सलूख कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","तैखन भीड़रे लोकेईं ज़ैना तैस सेइं थी, ई गवाही दित्ती, कि तैनी लाज़र कब्री मरां कुजाव, ते मुड़न मरां ज़ींतो कियो। ");
INSERT INTO bhd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","एल्हेरेलेइ लोक तैस सेइं मिलनेरे लेइ आए, किजोकि तैनेईं शुनोरू थियूं, तैनी ई चमत्कार कियोरे। ");
INSERT INTO bhd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","फरीसी लोक एन हेरतां एक्की होरि सेइं ज़ोने लगे, “सोचा, तुस लोक किछ नईं केरि लोरे बटने, हेरा सारी दुनिया एस पत्ती च़ली।” ");
INSERT INTO bhd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ज़ैना लोक फ़सह तिहारे मां यरूशलेम नगरे मां आराधना केरने ओरे थिये, तैन मां किछ यूनानी थिये। ");
INSERT INTO bhd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","तैना फिलिप्पुसे कां जे ज़ै गलीलेरे नगर बैतसैदा मां रातो थियो, तै ज़ोवले हथ केरतां ज़ोने लगे, “जनाब अस यीशु सेइं मिलनू चातम।” ");
INSERT INTO bhd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","फिलिप्पुसे अन्द्रियासे सेइं ज़ोवं, ते अन्द्रियास फिलिप्पुसे सेइं साथी जेव ते यीशु सेइं ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","यीशुए तैन जुवाब दित्तो, “कि मैनेरे मट्ठेरी यानी मेरी महिमा बांदी भोनेरो वक्त ओरोए। ");
INSERT INTO bhd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","अवं तुसन सेइं सच़-सच़ ज़ोताईं, कि ज़ांतगर गेहुं केरो ग्लेव मित्ती मां न मर्रे, तै अक्के रहते, पन ज़ैखन मरते त बड़ो फल आनते, (तेन्च़रे मीं सेइं साथी भोनूए)। ");
INSERT INTO bhd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ज़ै अपनि जान ट्लारी रखते ते अपनि जान गुवाते, पन ज़ै अपनि जानी सेइं बैर रखते ते अक हमेशारी ज़िन्दगी बच़ालो। ");
INSERT INTO bhd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ज़ै कोई मेरी सेवा केरनि चाते त तैसेरेलेइ ज़रूरीए तै मेरो चेलो बने, ताके ज़ैड़ी अवं आईं तैड़ी मेरो सेवक भी भोए, ज़ै मेरी सेवा केरते मेरो परमेशर तैस इज़्ज़त देलो।” ");
INSERT INTO bhd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“हुना मेरो दिल बड़ो उदास भोरोए। एल्हेरेलेइ अवं कुन ज़ोईं? ‘हे बाजी इस दुखेरी घेड़ी करां मीं बच़ा,’ पन अवं इस दुनियाई मां एल्हेरेलेइ ओरोईं कि दुःख झ़ेल्ली। ");
INSERT INTO bhd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","हे बाजी तू केत्रो महिमा बालोस इन बांदू केर।” तैखन स्वर्गेरां अक आवाज़ अई, “मीं तेरी केत्री महिमा बांदी कियोरीए ते फिरी भी केरेलो। ");
INSERT INTO bhd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","तैखन तैड़ी ज़ैना मैन्हु खड़े भोइतां शुनी रावरे थिये, तैनेईं ज़ोवं, गुड़ने लोरूए,” ते होरेईं ज़ोवं, “केन्चे स्वर्गदूते तैस सेइं गल की।” ");
INSERT INTO bhd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","यीशुए ज़ोवं, “ई आवाज़ मेरे फैइदेरे लेइ नईं बल्के तुश्शे लेइ आए। ");
INSERT INTO bhd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","इस वक्त परमेशर दुनियारे लोकां केरो इन्साफ केरेलो, ते अवं इस शैतानेरी शक्ति नाश केरेलो ज़ै इस दुनियाई पुड़ राज़ केरते। ");
INSERT INTO bhd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ते ज़ैखन अवं ज़मीनी पुड़ां उच्चे च़ाढ़ो गालो, तैखन अवं सैरी लोकन एप्पू कांजो आनेलो।” ");
INSERT INTO bhd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","एन ज़ोइतां तैनी साफ च़ारे बांदू कियूं, ते तै केन्च़रां मरने बालो। ");
INSERT INTO bhd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","एस पुड़ लोकेईं ज़ोवं, “असेईं मूसेरे कानूने मां ई गल शुनोरीए, कि मसीह हमेशा रानोए, फिरी तू केन्च़रे ज़ोतस कि मैनेरू मट्ठू उच्चे पुड़ च़ढ़नू ज़रूरीए? एन मैनेरे मट्ठे कौने?” ");
INSERT INTO bhd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","यीशुए तैन सेइं ज़ोवं, “लौ तुसन कां थोड़े च़िरे तगरे आए, ज़ां तगर लौ तुसन साथीए, तांतगर च़लते राथ, एरू न भोए आंधरू तुसन घेरे, ज़ै आंधरे मां च़लते तै न ज़ाने तै कोरां च़लरोए। ");
INSERT INTO bhd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ज़ांतगर लौ तुसन सेइं साथीए, त लोई पुड़ विश्वास केरा ताके तुस लोअरे बच्चे बनथ।” इना गल्लां ज़ोइतां यीशु छ़ेप्पी जेव। ");
INSERT INTO bhd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","तैनी तैन केरे सामने बड़े चमत्कार हिराए, फिरी भी तैनेईं विश्वास न कियो। ");
INSERT INTO bhd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ताके यशायाह नेबेरू ज़ोरू वचन पूरू भोए, “हे प्रभु, केन्चे इश्शे खुशखेबरी पुड़ विश्वास न कियो, ते बड़े लोकेईं परमेशरेरी शक्ति हेरतां भी कबूल न की।” ");
INSERT INTO bhd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","एल्हेरेलेइ तैना विश्वास न केरि सके यशायाह एक्की होरि ठैरी ज़ोते: ");
INSERT INTO bhd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“तैनी तैन केरि एछ़्छ़ी केनि की, ते मन सखत कियोरोए, एरू न भोए कि तैना एछ़्छ़न सेइं लान ते मने सेइं बुझ़न, ते माफ़ी मगन ते अवं तैन बज़्झ़ेई।” ");
INSERT INTO bhd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यशायाह नबी एल्हेरेलेइ ज़ोतो थियो, कि तैनी यीशुएरी एजनेबाली महिमा लवरी थी, ते तैसेरे बारे मां गल भी की। ");
INSERT INTO bhd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","फिरी भी लीडरन मरां बड़ेईं यीशु पुड़ विश्वास कियो, पन फरीसी लोकां केरे वजाई सेइं बांदे मां न थिये मन्ते, एरू न भोए कि असन प्रार्थना घरे मरां कढन। ");
INSERT INTO bhd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","किजोकि मैन्हु केरि बड़याई तैन परमेशरेरी बड़याई करां जादे रोड़ी लगती थी। ");
INSERT INTO bhd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","तैखन यीशुए ज़ोरे सेइं ज़ोवं, “ज़ै कोई मीं पुड़ विश्वास केरते तै मीं पुड़ नईं पन मेरे भेज़ने बाले परमेशरे पुड़ विश्वास केरते। ");
INSERT INTO bhd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ते ज़ै मीं हेरते तै मेरे भेज़ने बाले हेरते। ");
INSERT INTO bhd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","अवं दुनियाई मां अक लौ बेनतां ओरोईं, ताके ज़ै मीं पुड़ विश्वास केरे तै आंधरे मां न रालो। ");
INSERT INTO bhd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","अगर कोई मेरी गल्लां शुन्तां तैन पुड़ अमल केरे, त अवं तैस दोष न लेइलो, अवं दुनियारे लोकन पुड़ दोष लाने नईं पन मुक्ति देने ओरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ज़ै मेरो इन्कार केरते ते मेरी गल्लां कबूल न केरे, तैस पुड़ दोष लानेबालो अक्के, मतलब ज़ैन वचन मीं ज़ोरूए, तैन आखरी दिहाड़े तैस दोषी ठैरालू। ");
INSERT INTO bhd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","किजोकि मीं अपने अधिकारे सेइं किछ नईं ज़ोरू, पन बाजी ज़ैने अवं भेज़ोरोईं तैनी मीं हुक्म दित्तोरोए, कि कुन-कुन ज़ोईं ते कुन-कुन शुनेईं? ");
INSERT INTO bhd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ते अवं ज़ानताईं कि तैसेरो हुक्म मन्ने सेइं हमेशारी ज़िन्दगीए मैलतीए, एल्हेरेलेइ अवं तुसन सेइं तैन्ने ज़ोताईं ज़ैन ज़ोनेरो हुक्म मेरे बाजे मीं दित्तोरोए।” ");
INSERT INTO bhd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","फ़सह तिहारेरे पेइले दिहाड़े यीशुए ज़ैनीं छ़ड्डू, कि मेरो दुनियाई मरां बाजी कां वापस गानेरो वक्त ओरोए। तै अपने लोकन सेइं ज़ैना दुनियाई मां थिये ज़ेरो प्यार केरतो थियो, तेरहो प्यार आखरी तगर केरतो राव। ");
INSERT INTO bhd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","शैताने शमौनेरे मट्ठे यहूदा इस्करियोतेरे दिले मां पेइले यीशु ट्लुवानेरो खियाल छ़डोरो थियो। यीशु त कने तैसेरे चेले ड्लाई खानेरो लोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","यीशु पतो थियो कि बाजे सैरी चीज़ां तैसेरे हथ्थे मां दित्तोरिन, ते कने तै परमेशरेरी तरफां ओरोए ते परमेशरे कांजो वापस च़लरोए। ");
INSERT INTO bhd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","एल्हेरेलेइ तै रोट्टी छ़ेडतां खड़ो उठो ते अपनू कोट खोल्लू, ते अक तोलियो अपने लखे सेइं पलैटो। ");
INSERT INTO bhd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तैखन तैनी अक भांड ट्लावं ते तैस मां पानी छ़ाडु ते अपने चेलां केरे पाव धोइतां लखे बन्धोरे तोलिये सेइं पोंछ़े। ");
INSERT INTO bhd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ज़ैखन तै शमौन पतरस कां अव त पतरसे ज़ोवं, “हे प्रभु, कुन तू मेरे पाव धोने लोरस?” ");
INSERT INTO bhd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","यीशुए जुवाब दित्तो, “ज़ैन अवं केरने लोरोईं तू हुन्ना न बुझ़स, पन पत्ती तू बुझ़ेलो।” ");
INSERT INTO bhd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पतरसे तैस सेइं ज़ोवं, “तू मेरे पाव कधे न धोई सकस!” यीशुए तैस सेइं ज़ोवं, “अगर अवं तेरे पव न धोई, त तू मेरो चेलो नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","शमौन पतरस यीशु सेइं ज़ोने लगो, “हे प्रभु, तू मेरे पाव नईं बल्के हथ ते दोग भी धो।” ");
INSERT INTO bhd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","यीशुए तैस सेइं ज़ोवं, “ज़ैनी निहावरूए, तैस पावां केरे अलावा होरू धोनेरू किछ ज़रूरत नईं। तै बिलकुल शुद्धे, ते तुस शुद्धथ, पन सारे नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","तै त ट्लुवांने बाले ज़ानतो थियो एल्हेरेलेइ तैनी ज़ोवं, “तुस सब शुद्ध नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ज़ैखन यीशुए सेब्भी केरे पाव धोए त अपनू कोट लेइतां अपनि ठैरी बिश्शो तैखन तैनी तैन पुच़्छ़ू, “कुन तुस समझ़तथ कि मीं तुसन सेइं कुन कियूं? ");
INSERT INTO bhd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","तुस मींजो गुरू, ते प्रभु ज़ोतथ, तुश्शू ज़ोनू ठीके, किजोकि अवं आईं। ");
INSERT INTO bhd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","अगर मीं तुश्शो गुरू त कने प्रभु भोइतां तुश्शे पाव धोए, त तुश्शो भी फर्ज़े कि एक्की होरेरे पाव धोथ। ");
INSERT INTO bhd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","किजोकि मीं तुसन अक नमूनो हिराव, कि ज़ेन्च़रे मीं पाव धोए तुस भी एरू केरथ। ");
INSERT INTO bhd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","अवं तुसन सेइं सच़-सच़ ज़ोताईं, कि नौकर अपने मालिके करां बड्डो न भोए, ते न भेज़ोरो भेज़ने बाले करां। ");
INSERT INTO bhd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","तुस त एना गल्लां ज़ानतथ, ते अगर तैन पुड़ अमल केरतथ त तुस धन आथ। ");
INSERT INTO bhd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","अवं तुसन सेब्भी केरे बारे मां न ज़ोईं, ज़ैना मीं च़ुनोरेन अवं तैन ज़ानताईं, पन इन एल्हेरेलेइ आए, कि पवित्रशास्त्रेरू एन वचन पूरू भोए, ज़ैने मेरी रोट्टी खाइ, तैए मेरे खलाफ भोव। ");
INSERT INTO bhd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","अवं तैन भोने करां पेइले तुसन ज़ोताईं कि ज़ैखन भोए त विश्वास केरथ कि अवं तैए आईं। ");
INSERT INTO bhd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","अवं तुसन सेइं सच़-सच़ ज़ोताईं कि, ज़ै मेरे भेज़ोरे कबूल केरते तै मीं कबूल केरते, ते ज़ै मीं कबूल केरते तै मेरे भेज़नेबाले बाले कबूल केरते।” ");
INSERT INTO bhd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","एना गल्लां ज़ोइतां यीशु आत्माई मां उदास भोइतां बड़ो दुःखी भोव, ते अपने चेलन सेइं ज़ोने लगो, “अवं तुसन सेइं सच़-सच़ ज़ोतां, कि तुसन मरां एक्के अवं ट्लुवानोईं।” ");
INSERT INTO bhd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","चेले एक्की होरेरे पासे तकने लगे, किजोकि तैन पतो न थियो कि ए केसेरे बारे मां ज़ोने लोरोए। ");
INSERT INTO bhd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","तैसेरे चेलन मरां अक चेलो ज़ैस सेइं यीशु प्यार केरतो थियो, यीशुएरे नेड़े बिशोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","तैखन शमौन पतरसे तैसेरे पासे इशारे सेइं पुच़्छ़ू, “ज़ो कसेरे बारे मां ज़ोने लोरोए?” ");
INSERT INTO bhd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","तैखन तेन्च़रे यीशुएरे छैतरे पासे लिकतां पुच़्छ़ू, “हे प्रभु, तै कौने?” ");
INSERT INTO bhd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","यीशुए जुवाब दित्तो, “ज़ैस अवं ई रोट्टरो टुकड़ो डोबतां देइलो तैए।” ते यीशुए टुकड़ो डोबतां शमौनेरे मट्ठे यहूदा इस्करियोती दित्तो। ");
INSERT INTO bhd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ते टुकड़ो नेनेरे पत्ती तै शैतानेरे बस्से मां भोइ जेव, तैखन यीशुए तैस ज़ोवं, “तीं ज़ैन किछ केरनूए, लूशी केर।” ");
INSERT INTO bhd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","पन होरि केन्ची ए पतो न लगो कि ए गल यीशुए केसेरे बारे मां की। ");
INSERT INTO bhd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","यहूदा कां पेइंसां केरी थेलड़ी भोती थी, ते किछेईं समझ़ू, कि यीशु तैस सेइं ज़ोते, कि ज़ैन किछ असन तिहारेरे लेइ लोड़ते तैन घिन्ने, या गरीबन किछ दे। ");
INSERT INTO bhd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","तैखन यहूदा टुकड़ो खेइतां बेइर च़लो जेव, तै रातरो वक्त थियो। ");
INSERT INTO bhd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ज़ैखन तै बेइर जेव त यीशु ज़ोने लगो, “हुनी मैनेरे मट्ठे यानी मेरी महिमा भोइ, ते मेरे ज़िरिये परमेशरेरी महिमा भोइ, ");
INSERT INTO bhd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ते परमेशर भी मीं एप्पू महिमा बालो केरेलो, बल्के जल्दी केरेलो। ");
INSERT INTO bhd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","हे मेरे दोस्तव, अवं किछ च़िरेरे लेइ हेजू तुसन सेइं साथी आई, फिरी तुस मीं तोप्पेले, ते ज़ेन्च़रे मीं यहूदन भी ज़ोवं, ज़ैड़ी अवं गाताईं तैड़ी तुस न एज्जी बटथ, तेन्च़रे अवं तुसन सेइं भी ज़ोताईं। ");
INSERT INTO bhd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","अवं तुसन अक नंव्वो हुक्म देताईं कि, एक्की होरि सेइं प्यार केरा, ज़ेन्च़रे मीं तुसन सेइं प्यार कियो तुस भी एक्के होरि सेइं प्यार केरा। ");
INSERT INTO bhd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","अगर तुस एक्के होरि सेइं प्यार केरेले त सेब्भी लोकन पतो लग्गेलो, कि तुस मेरे चेलेथ।” ");
INSERT INTO bhd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","शमौन पतरसे तैस पुच़्छ़ू, “हे प्रभु तू कोरां च़लोरोस?” यीशुए जुवाब दित्तो, “ज़ेरां अवं च़लोरोईं तू हुना मीं सेइं साथी न एज्जी सकस, पन बादे मां एज्जी सकतस।” ");
INSERT INTO bhd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पतरसे ज़ोवं, “हे प्रभु अवं हुना तीं सेइं साथी किना एज्जी सेखी? अवं त तेरे लेइ अपनि जान भी देनेरे लेइ तियार आई।” ");
INSERT INTO bhd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","यीशुए जुवाब दित्तो, “कुन तू मेरे लेइ अपनि जान देलो, अवं तीं सेइं सच़-सच़ ज़ोताईं कि कुकड़ बांग देने करां पेइले तू मेरो ट्लेइ बार इन्कार केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“तुश्शो दिल उदास न भोए, तुस परमेशरे पुड़ विश्वास केरतथ, मीं पुड़ भी विश्वास केरा। ");
INSERT INTO bhd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","मेरे बाजेरे घरे मां बड़े कमरेन, अगर न भोथी त अवं तुसन सेइं ज़ोथो, किजोकि अवं तुश्शे लेइ ठार तियार केरने च़लोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","अगर गेइतां तुश्शे लेइ ठार तियार केरि त वापस एइतां तुसन एप्पू सेइं साथी नेलो, ताके ज़ैड़ी अवं भोलो तुस भी तैड़ी भोथ। ");
INSERT INTO bhd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ते ज़ेरां अवं च़लोरोईं तुस तैठेरी बत ज़ानतथ।” ");
INSERT INTO bhd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमा तैस ज़ोवं, “हे प्रभु, असन नईं पतो तू कोरां च़लोरोस, ते फिरी बत केन्च़रे ज़ानम?” ");
INSERT INTO bhd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","यीशुए तैस सेइं ज़ोवं, “बत, सच़्च़ी ते हमेशारी ज़िन्दगी अव्वें आईं, कोई मेरे ज़िरियेरे बगैर बाजी कां न एज्जी सके। ");
INSERT INTO bhd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","अगर तुसेईं अवं पिशानोरो भोथो त मेरे बाजी भी पिशानेथे, पन हुनी तुस तैस ज़ानतथ ते कने लाव भी।” ");
INSERT INTO bhd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिप्पुसे तैस सेइं ज़ोवं, “हे प्रभु असन बाजी हिरा, तैन्ने इश्शे लेइ बड़ू आए।” ");
INSERT INTO bhd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","यीशुए तैस सेइं ज़ोवं, “फिलिप्पुस, एत्रे च़िरे अवं तुसन सेइं साथी राव कुन तू मीं न ज़ानस ज़ैनी अवं लाव तैनी बाजी भी लाव तू किजो ज़ोतस असन बाजी हिरा? ");
INSERT INTO bhd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","कुन तू विश्वास न केरस, कि अवं बाजी मां आईं ते बाजी मीं मां आए? अवं ज़ैना गल्लां तुसन सेइं ज़ोताईं तैना गल्लां अवं अधिकारे सेइं न ज़ोईं, बल्के बाजी मीं मां रेइतां अपनू कम केरते। ");
INSERT INTO bhd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","मेरो विश्वास केरा, कि अवं बाजी मां आईं ते बाजी मीं मां आए, नईं त ज़ैना कम्मां केरताईं तैन हेरतां मीं पुड़ विश्वास केरा।” ");
INSERT INTO bhd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","अवं तुसन सेइं सच़-सच़ ज़ोताईं, “कि ज़ै मीं पुड़ विश्वास केरते, एना कम्मां ज़ैना अवं केरताईं तै भी केरेलो, बल्के मीं करां भी बडां कम्मां केरेलो, किजोकि अवं बाजी कां च़लोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ज़ैन किछ तुस मेरे नंव्वे सेइं मगेले अवं तुसन देलो कि बाजी केरि महिमा मट्ठेरे वजाई सेइं बांदी भोए। ");
INSERT INTO bhd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","अगर तुस मेरू नंव्वे सेइं किछ भी मग्गेले त अवं तैन केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“अगर तुस मीं सेइं प्यार केरतथ त मेरे हुक्मन मन्नेले। ");
INSERT INTO bhd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ते अवं बाजी कां प्रार्थना केरेलो ते तै तुसन अक मद्दतगार देलो कि हमेशा तुसन सेइं साथी रालो। ");
INSERT INTO bhd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","मतलब तै आत्मा ज़ै परमेशरेरे बारे मां सच़ बांदू केरेली, ज़ै दुनिया कबूल न केरि सके, किजोकि न तैस लेइहोए न ज़ाने, तुस तैस ज़ातथ किजोकि तै तुसन साथी रहती, ते तै तुसन मां भोली। ");
INSERT INTO bhd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","अवं तुसन अकैल्लो न शेरेलो बल्के अवं तुसन कां एज्जेलो। ");
INSERT INTO bhd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ई दुनिया किछ च़िरेरां बाद मीं न लाएली, पन तुस मीं लांते राले, किजोकि अवं ज़ींतोईं ते तुस भी ज़ींते राले। ");
INSERT INTO bhd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ज़ैखन अवं ज़ींतो भोलो तेइस तुसन पतो लग्गेलो, कि अवं अपने बाजी मां आईं ते तुस मीं मां आथ ते अवं तुसन मां आई। ");
INSERT INTO bhd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ज़ैस कां मेरे हुक्म आन ते तैन मन्ते, त तैए मीं सेइं प्यार केरते ते मेरो बाजी तैस सेइं प्यार केरेलो, ते अवं तैस सेइं प्यार केरेलो, ते अपनो आप तैस पुड़ बांदो केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","तैखन यहूदा (तै यहूदा इस्करियोती न थियो बल्के होरो चेलो थियो) तैस सेइं ज़ोवं, “हे प्रभु कुन भोव कि तू अपनो आप असन पुड़ बांदो केरनो चातस ते दुनियारे लोकन पुड़ नईं?” ");
INSERT INTO bhd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","यीशुए जुवाब दित्तो, अगर कोई मीं सेइं प्यार केरते त तै मेरी शिक्षाई मन्ते, ते मेरो बाजी भी तैस सेइं प्यार केरेलो, ते अस तैस कां एजमेले ते तैस सेइं साथी रामेले। ");
INSERT INTO bhd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ज़ै मीं सेइं प्यार न केरे, तै मेरे शिक्षाई न मन्ने, ज़ै शिक्षा तुस शुन्ने लोरेथ, मेरी नईं पन मेरे बाजी केरि ज़ैने अवं भेज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“एना सैरी गल्लां मीं तुसन साथी रेइतां ज़ोई। ");
INSERT INTO bhd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","पन तै मद्दतगार यानी पवित्र आत्मा ज़ैस बाजी मेरे ठैरी भेज़ेलो, तुसन सैरी गल्लां शिखालेलो, ते हर गल ज़ै मीं तुसन सेइं ज़ोरी याद करालो।” ");
INSERT INTO bhd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","अवं तुसन शान्ति देइतां ज़ै मीं कां आए, ज़ेन्च़रे दुनिया देचे तेन्च़रे नईं, तुश्शो दिल उदास न भोए ते न डेरथ। ");
INSERT INTO bhd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","तुसेईं शुनू, मीं तुसन सेइं ज़ोवं, अवं गाताईं तुसन कां फिरी एज्जेलो अगर तुस मीं सेइं प्यार केरते भोते त खुशी भोने थिये, कि अवं बाजी कां च़लोरोईं किजोकि बाजी मीं करां बड्डोए। ");
INSERT INTO bhd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","मीं सैरी गल्लां पेइले तुसन ज़ोरिन कि ज़ैखन तैना पूरी भोन त तुस विश्वास केरेले। ");
INSERT INTO bhd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","हुनी अवं तुसन सेइं जादे गल्लां न केरेलो, किजोकि शैतान एइते, ज़ै इस दुनियाई पुड़ राज़ केरनेबालोए। मीं पुड़ तैसेरो किछ अधिकार नईं। ");
INSERT INTO bhd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ज़ेन्च़रे बाजीए मीं हुक्म दित्तो, अवं तेन्च़रे केरताईं। पन एन एल्हेरेलेइ भोते कि दुनिया ज़ांने, कि अवं बाजी सेइं प्यार केरताईं। ते उठा इट्ठां च़लम। ");
INSERT INTO bhd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","यीशुए ज़ोवं “अवं दाछ़ारू सच़्च़ू बड़ह अव्वें आईं, ते मेरो बाजी बागबाने। ");
INSERT INTO bhd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ज़ै डालड़ी मीं मां आए, ते तैस फल न लगे, तै कट्टी गानीए, ते ज़ैस फल लगते तैस छांटते कि जादे फल लगे। ");
INSERT INTO bhd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","तुस तैस शिक्षाई सेइं ज़ै मीं तुसन दित्तोरीए शुद्ध आथ। ");
INSERT INTO bhd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","तुस मीं मां बनोरे राथ, ते अवं तुसन मां, ज़ेन्च़रे डालड़ी अगर बड़हे सेइं बनोरी न राए, त अपने आप सेइं तैस फल न लगे। तेन्च़रे तुसन भी अगर मीं मां बनोरे न राले त तुस फलदार न भोइ सकेले। ");
INSERT INTO bhd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","अवं दाछ़ारू बड़ह आईं, तुस डेलड़ी आथ, ज़ै मीं मां बनोरो रहते तैस खूब फल लगते, किजोकि मीं करां अलग भोइतां तुस किछ न केरि सखत। ");
INSERT INTO bhd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","अगर कोई मीं मां बनोरो न राए, त तैस डेलड़ारो ज़ेरोए ज़ैस केटतां शारतन, ते शुक्की गाचे, ते लोक घेरतां अग्गी मां फुकी छ़डतन। ");
INSERT INTO bhd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","अगर तुस मीं मां बनोरे रातथ ते मेरी गल्लां तुसन मां बेनोरी रैतिन त ज़ैन चाहेले ते मगेले तुसन दित्तू गालू। ");
INSERT INTO bhd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","मेरे बाजेरी महिमा एसमां आए कि तुस हछो फल आनां, फिरी तुस मेरे चेले भोले। ");
INSERT INTO bhd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ज़ेन्च़रे बाजे मीं सेइं प्यार कियो, तेन्च़रे मीं भी तुसन सेइं प्यार कियो। मेरे प्यारे मां बनोरे राथ। ");
INSERT INTO bhd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","अगर तुस मेरे हुक्मन मन्नेले, त मेरे प्यारे मां बनोरे राले, ज़ेन्च़रे मीं अपने बाजेरे हुक्म मन्ने, ते तैसेरे प्यारे मां बनोरो राव। ");
INSERT INTO bhd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","मीं एना गल्लां एल्हेरेलेइ तुसन ज़ोरिन, कि मेरी खुशी तुसन मां बनोरी राए।” ");
INSERT INTO bhd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“मेरो हुक्मे ई आए ज़ेन्च़रे मीं तुसन सेइं प्यार कियो, तुस भी एक्की होरि सेइं प्यार केरा ");
INSERT INTO bhd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","एस करां जादे प्यार केन्चे नईं कियोरो, कि कोई अपने दोस्तां केरे लेइ अपनि जान दे। ");
INSERT INTO bhd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ज़ै हुक्म अवं देताईं, अगर तुस तैस मन्नथ, त मेरे दोस्त आथ। ");
INSERT INTO bhd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","अज़्ज़ेरे बाद अवं तुसन जो नौकर न ज़ोइलो, किजोकि नौकर न ज़ांने कि तैसेरो मालिक कुन केरते। मीं तुसन जो दोस्त ज़ोरूए, किजोकि ज़ैन किछ मीं बाजी करां शुनोरूए तुसन भी शुनावरू आए। ");
INSERT INTO bhd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","तुसेईं अवं नईं च़ुनोरो पन मीं तुस च़ुनोरेथ ते ठहरावरे भी आथ, ताके तुस गेइतां फल आनथ, ते तुश्शो फल बनोरो राए, कि तुस मेरे नंव्वे सेइं बाजी करां ज़ैन किछ मगथ, तै तुसन देलो किजो तुस मेरे चेलेथ। ");
INSERT INTO bhd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","अवं इन गल्लां केरो हुक्म एल्हेरेलेइ देताईं, कि तुस एक्की होरि सेइं प्यार केरा।” ");
INSERT INTO bhd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“अगर दुनियारे लोक तुसन सेइं दुश्मनी रखतन, त याद रखा कि तैनेईं पेइले मीं सेइं दुश्मनी रख्खोरी। ");
INSERT INTO bhd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","अगर तुस दुनियारे भोथे, त दुनिया अपने लोकन सेइं प्यार केरती, पन हुनी तुस दुनियारे लोक नईं किजोकि मीं तुस दुनियाई मरां च़ुनोरेथ तांए दुनियारे लोक तुसन सेइं दुश्मनी रखतन। ");
INSERT INTO bhd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","तै गल ज़ै मीं तुसन सेइं ज़ोरी थी याद रख्खा, नौकर अपने मालिके करां बड्डो न भोए, अगर दुनियां अवं सतेवरोइं त तैना तुसन भी सताले, अगर तैनेईं मेरी गल्ली पुड़ अमल कियूं त तुश्शी गल्ली पुड़ भी अमल केरेले। ");
INSERT INTO bhd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","पन तैना लोक तुसन सेइं एरो ज़ेरो बर्ताव केरेले, किजोकि तुस मेरे चेलेथ। तैना मेरे भेज़ने बाले परमेशरे न ज़ानन्। ");
INSERT INTO bhd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","अगर मीं एइतां तैन सेइं गल्लां न भोथी कियोरी त तैना पापी न थिये भोने, पन हुनी तैन केरे पापेरो तैन कां कोई बहानो नईं। ");
INSERT INTO bhd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ज़ै मीं सेइं दुश्मनी रखते, ते तै मेरे बाजी सेइं भी दुश्मनी रखते। ");
INSERT INTO bhd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","अगर मीं तैन केरे सामने तैना चमत्कार न भोथे कियोरे, ज़ैना कधी होरे केन्चे नईं कियोरे त तैना पापी न थिये भोने, पन हुनी तैनेईं सब किछ लाव, ते मीं भी ते बाजी सेइं दुश्मनी रख्खी। ");
INSERT INTO bhd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","पन एन एल्हेरेलेइ भोवं कि तैन केरे कानूने मां लिखोरी तै गल पूरी भोए, तैनेईं मीं सेइं खामखा दुश्मनी रख्खी। ");
INSERT INTO bhd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","पन ज़ैखन तै मद्दतगार एज्जेलो ज़ैस अवं अपने बाजेरे तरफां भेज़ेलो, मतलब सच़्च़ेरी आत्मा, ज़ै बाजी केरि तरफां एइतीए, तै मेरी गवाही देली। ");
INSERT INTO bhd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ते तुस भी गवाह आथ किजोकि तुस भी शुरू करां मीं सेइं साथी थिये।” ");
INSERT INTO bhd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“मीं तुसन एना सैरी गल्लां एल्हेरेलेइ ज़ोई कि तुश्शो विश्वास न ट्लुटे। ");
INSERT INTO bhd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","तैनेईं तुस प्रार्थना घरन मरां कढनेथ, खास केरतां एरो ज़ेरो वक्त एज्जी राहोरोए, ज़ै तुसन मारेलो तै इन समझ़ेलो कि तै परमेशरेरी सेवा केरने लोरोए। ");
INSERT INTO bhd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","तैन एन सब एल्हेरेलेइ केरेले कि न तैनेईं कधी मेरो बाजी ज़ांनो ते न कधी अवं। ");
INSERT INTO bhd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","पन मीं एना सैरी गल्लां एल्हेरेलेइ तुसन सेइं ज़ोई, कि ज़ैखन तैना पूरी भोनेरो वक्त एज्जेलो, त तुसन याद एज्जे, कि मीं तुसन एन पेइलू ज़ोरू थियूं, ज़ेइस तुस मेरे चेले बनोरे थिये। मीं एना गल्लां केरे बारे मां पेइलू एल्हेरेलेइ न ज़ोवं, कि अवं एप्पू तुसन सेइं साथी थियो।” ");
INSERT INTO bhd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“पन हुन्ना अवं अपने भेज़ने बाले कां च़लोरोईं, पन तुसेईं केन्चे भी न पुच़्छ़ू कि तू कोरां च़लोरोस? ");
INSERT INTO bhd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","पन मीं तुसन सेइं ज़ोई छ़डेरूए एल्हेरेलेइ तुश्शो मन उदास आए। ");
INSERT INTO bhd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","फिरी भी अवं तुसन सेइं सच़ ज़ोताईं कि मेरू इट्ठां गानू तुश्शे लेइ फैइदोए, अगर अवं न गेइलो त तै मद्दतगार तुसन कां नईं एजनो, पन अवं च़लो जेव त तैस अवं तुसन कां भेज़ी देलो। ");
INSERT INTO bhd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ते ज़ैखन तै एज्जेलो त दुनियाई पाप ते धार्मिकता ते इन्साफेरे बारे मां सब किछ बांदू केरेलो। ");
INSERT INTO bhd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","पापेरे बारे मां एल्हेरेलेइ कि दुनियां मीं पुड़ विश्वास न कियो, ");
INSERT INTO bhd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","धार्मिकतारे बारे मां एल्हेरेलेइ कि अवं वापस बाजी कां च़लोरोईं ते तुसेईं अवं फिरी नईं लहनो, ");
INSERT INTO bhd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","इन्साफेरे बारे मां एल्हेरेलेइ कि, शैतान ज़ै दुनियाई पुड़ राज़ केरनेबालो मुर्ज़म बनोरोए।” ");
INSERT INTO bhd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“अवं तुसन सेइं होरू भी बड़ू किछ ज़ोनू चाताईं, पन हुन्ना तुसेईं तैन झ़ैली नईं बटनू। ");
INSERT INTO bhd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","पन ज़ैखन तै मतलब सच़्च़ेरी आत्मा एज्जेली त तै सच़्च़ेरी बत हिराली, किजोकि तै अपने तरफां न ज़ोली, पन ज़ैखन किछ परमेशरे करां शुनेली तैन्ने ज़ोली, ते एजने बैली गल्लां ज़ोली। ");
INSERT INTO bhd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ते मेरी महिमा केरेली किजोकि तै मेरी गल्लां ज़ोली, किजोकि तै मेरी गल्लन मरां तुसन सेइं ज़ोली। ");
INSERT INTO bhd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ज़ैन किछ बाजी केरूए, तैन सब मेरूए, एल्हेरेलेइ मीं ज़ोवं, कि तै मेरी गल्लन मरां शुनालो।” ");
INSERT INTO bhd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“थोड़े च़िरेरां पत्ती तुसेईं अवं फिरी नईं लहनों, ते तैसेरे थोड़े च़िरेरां पत्ती तुसेईं अवं फिरी लांनोईं।” ");
INSERT INTO bhd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","तैखन तैसेरे किछ चेलेईं एप्पू मांमेइं ज़ोवं, इन कुने, “ए कुन ज़ोते, थोड़े च़िरेरां पत्ती तुस मीं न लाएले, ते फिरी थोड़े च़िरेरां पत्ती तुस मीं लाएले? कि अवं बाजी कां गाताईं?” ");
INSERT INTO bhd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","तैखन तैनेईं ज़ोवं, “थोड़े ज़ेरे च़िरेरां बाद, एन ज़ै ए ज़ोते, कुन आए? अस न ज़ानम कि कुन?” ");
INSERT INTO bhd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","यीशुए एन ज़ैनतां, कि एना मीं पुछ़नू चातन, “कुन तुस मेरी इस गल्लरे बारे मां एप्पू मांमेइं गलबात केरने लोरेथ, कि एस गल्लारो कुन मतलबे, थोड़े च़िरेरां पत्ती मीं न लाएले, ते फिरी थोड़े च़िरेरां पत्ती लाएले? ");
INSERT INTO bhd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","अवं तुसन सेइं सच़-सच़ ज़ोताईं, कि तुस लेरां देले ते शोग बनाले, पन दुनियारे लोक खुशी भोले, पन ज़ैखन तुस मीं दुबारां लाएले त तुश्शो दुःख, खुशी मां बेदलोई गानोए। ");
INSERT INTO bhd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ज़ैखन कुआन्श ज़ातीए त तैस बड़ी तकलीफ भोतीए, किजोकि तैसेरे दुःखेरी घड़ी नेड़े पुज़ोरीए, पन ज़ैखन बच्चो ज़र्मते त एस खुशी मां कि दुनियाई मां अक मैन्हु पैदा भोरोए अपनि तकलीफ बिस्सरी गाचे। ");
INSERT INTO bhd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ते तुसन भी हुन्ना तेरही तकलीफे, पन अवं तुसन सेइं फिरी मिलेलो, ते फिरी तुश्शे मने मां खुशी भोली, ते खुशी तुसन करां कोई न नेही सकेलो। ");
INSERT INTO bhd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","तैस वक्ते तुस मीं कोई किछ न पुछ़ेलो, अवं तुसन सेइं सच़-सच़ ज़ोताईं, तुस मेरे नंव्वे सेइं बाजी करां ज़ैन किछ मगथ, तै तुसन देलो किजो तुस मेरे चेलेथ। ");
INSERT INTO bhd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","तुसेईं मेरू नवं घिन्तां हुना तगर बाजी करां किछ नईं मगेरू, मगेले त तुसन मैल्ली गालू, ते तुश्शी खुशी पूरी भोली।” ");
INSERT INTO bhd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“अवं तुसन एना गल्लां मिसाल देइतां ज़ोताईं, पन तै वक्त ओरोए कि अवं कहैन्न मां फिरी न ज़ोइलो, पन रोड़े च़ारे बाजेरे बारे मां तुसन सेइं गल्लां केरेलो। ");
INSERT INTO bhd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","तैस वक्ते तुस मेरू नवं घिन्तां प्रार्थना केरेले, अवं इन न ज़ोईं, कि तुश्शे लेइ बाजी सेइं बिनती केरि। ");
INSERT INTO bhd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","किजोकि बाजी परमेशर तुसन सेइं एप्पू प्यार केरते, एल्हेरेलेइ कि तुसेईं मीं सेइं प्यार कियो, ते तुसेईं विश्वास कियोरोए कि अवं परमेशरेरी तरफां ओरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","अवं बाजी करां दुनियाई मां ओरोईं, हुनी दुनियाई मरां भोइतां वापस बाजी कां च़लोरोईं।” ");
INSERT INTO bhd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","तैसेरे चेलेईं ज़ोवं, “हुन्ना तू साफ-साफ गल लोरस केरने, ते कोई मिसाल देइतां न ज़ोस। ");
INSERT INTO bhd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","हुन्ना असेईं बुझ़ू कि तीं सब किछ पत्तोए, ते ज़रूरत नईं कि कोई तीं पुछ़े, असां विश्वास केरतम कि तू परमेशरे करां ओरोस।” ");
INSERT INTO bhd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","यीशुए तैन सेइं ज़ोवं, “हुनी तुस विश्वास केरतथ! ");
INSERT INTO bhd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","हेरा, तै वक्त एज्जी राओरोए बल्के पुज़ोरोए, कि तुस सब नेशतां अपने-अपने बत्तां गानेथ, ते अवं अकैल्लो शारनोईं पन फिरी भी अवं अकैल्लो नईं, किजोकि मेरो बाजी मीं सेइं साथीए। ");
INSERT INTO bhd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","मीं तुसन एना गल्लां एल्हेरेलेइ ज़ोई, ताके तुसन शान्ति मैल्ले, किजो तुस मेरे चेलेथ, तुस दुनियाई मां मुसीबत त उठाताथ, पन हिम्मत रखा, मीं शैताने पुड़ ज़ींत हासिल कियोरीए, ज़ै इस दुनियाई पुड़ राज़ केरते।” ");
INSERT INTO bhd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ज़ैखन यीशुए अपने चेलन सेइं एना सब गल्लां ज़ोई, त तैनी उबरू स्वर्गेरां तेकतां ज़ोवं, “हे बाजी हुन्ना तै वक्त ओरोए कि तू अपने मट्ठेरी महिमा केर, कि मट्ठू भी तेरी महिमा केरे। ");
INSERT INTO bhd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","किजोकि तीं तैस सेब्भी मैनन् पुड़ अधिकार दित्तोरोए, ज़ैना तीं तैस दित्तोरेन हमेशारी ज़िन्दगी दे। ");
INSERT INTO bhd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ते हमेशारी ज़िन्दगी तै आए, कि तैना सिर्फ तीं एक्की सच़्च़े परमेशरे ज़ानन् ते यीशु मसीहे भी ज़ानन् ज़ै तीं भेज़ोरोए। ");
INSERT INTO bhd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","मीं तैन कम ज़ैन तीं मीं दित्तेरू थियूं मुकेइतां धेरतली पुड़ तेरी महिमा की। ");
INSERT INTO bhd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ते हुनी हे बाजी मीं एप्पू सेइं साथी मेरी तै महिमा केर ज़ै दुनियारे पेइली मेरी तीं साथी थी।” ");
INSERT INTO bhd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“मीं तेरू नवं तैन कां बांदू कियूं, ज़ैना तीं दुनियाई मरां च़ुनतां मीं दित्तोरेन तैना तेरे थिये, पन तीं मींजो दित्तोरेन ते तैनेईं तेरे बचने पुड़ अमल भी कियोरूए। ");
INSERT INTO bhd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","हुनी तैना ज़ानतन, कि ज़ैन किछ तीं मीं दित्तेरू तैन सब तेरी तरफांए। ");
INSERT INTO bhd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","एल्हेरेलेइ मीं तैना गल्लां ज़ैना तीं मीं दित्तोरी थी, मीं तैन पुज़ेई ते तैनेईं तैन पुड़ विश्वास कियो, ते सच़ पिशानू, कि अवं तेरी तरफां ओरोईं, ते ई भी विश्वास कियो कि तीं अवं भेज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","अवं तैन केरे लेइ प्रार्थना केरताईं, दुनियारे लोकां केरे लेइ न केरि, पन तैन केरे लेइ ज़ैना तीं मीं दित्तोरेन, किजोकि तैना सब तेरे आन। ");
INSERT INTO bhd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ते ज़ैन किछ मेरू आए, तैन सब किछ तेरूए, ते ज़ैन तेरू तैन मेरूए, ते इन सेइं मेरी महिमा बांदी भोईं। ");
INSERT INTO bhd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","मीं हुनी इस दुनियाई मां नईं रानू, पन तैना हेजू इस दुनियाई मां आन, ते अवं तीं कां एजताईं, हे पवित्र बाजी, अपने तैस नंव्वे सेइं ज़ैन तीं मीं दित्तोरूए, तैन केरि हफाज़त केर, कि तैना असन बराबर भोन। ");
INSERT INTO bhd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ज़ैखन अवं तैन सेइं साथी थियो, मीं तेरे तैस नंव्वे सेइं, ज़ैन तीं मीं दित्तोरूए, तैन केरि हफाज़त की, मीं तैन केरि देख भाल की, नाश भोनेबाले मैनेरे अलावा कोई नाश न भोव, एल्हेरेलेइ पवित्रशास्त्रेरी गल पूरी भोइ। ");
INSERT INTO bhd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","पन हुन्ना अवं तीं कां एजताईं, ते इना गल्लां अवं दुनिया मां ज़ोताईं, कि तैना मेरी खुशी एप्पू मां पूरी केरन। ");
INSERT INTO bhd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","मीं तैन तेरू वचन तैन कां पुज़ेवरुए, ते दुनियारे लोकेईं तैन सेइं दुश्मनी रख्खी, किजोकि ज़ेन्च़रे अवं दुनियारो नईं, तैना भी नईं। ");
INSERT INTO bhd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","मेरी प्रार्थना ई नईं कि तू तैन दुनियाई मरां ने, पन तू तैन शैताने करां बच़ेइतां रख। ");
INSERT INTO bhd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ज़ेन्च़रे अवं दुनियारो नईं तैन भी इस दुनियारे नईं। ");
INSERT INTO bhd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","तेरू वचन सच़्च़े। सच़्च़ेरे ज़िरिये सेइं तैन पवित्र केर। ");
INSERT INTO bhd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ज़ेन्च़रे तीं अवं दुनियाई मां भेज़ोरोईं तेन्च़रे मीं भी तैना दुनियाई मां भेज़ोरेन। ");
INSERT INTO bhd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","अवं अपनो आप तैन केरे लेइ पवित्र केरताईं, ताके तैना भी सच़्च़ेरे ज़िरिये सेइं पवित्र भोन।” ");
INSERT INTO bhd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“मेरी प्रार्थना सिर्फ चेले केरे लेइ नईं, पन तैन केरे लेइ भी ज़ैना तैन वचनेरे ज़िरिये मीं पुड़ विश्वास केरेले। ");
INSERT INTO bhd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","कि तैना सब अक भोन, ज़ेन्च़रे तू बाजी मीं मां आस, ते अवं तीं मां आई तेन्च़रे तैना असन मां भोन, एल्हेरेलेइ दुनियारे लोक विश्वास केरन, कि तींए अवं भेज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ते तै महिमा ज़ै तीं मीं दित्तोरीए, कि ज़ेन्च़रे अस अक आम तैन भी अक भोन। ");
INSERT INTO bhd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","अवं तैन मां भोइलो, ते तू मीं मां भोलो, ताके तैन पूरो अकीजो भोए, ते दुनिया ज़ांने कि तीं अवं भेज़ोरोईं। ज़ेन्च़रे तीं मीं सेइं प्यार कियो, तेन्च़रे तीं तैन सेइं भी प्यार कियो। ");
INSERT INTO bhd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","हे बाजी अवं चाताईं कि ज़ैना तीं मीं दित्तोरेन, ज़ैड़ी अवं आईं तैड़ी तैना भी मीं सेइं साथी भोन, कि तैना भी मेरी महिमा हेरन, ज़ै तीं मीं दित्तोरीए। दुनियारे रच़ने करां भी पेइले तीं, मीं सेइं प्यार कियोरोए। ");
INSERT INTO bhd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","हे धर्मी बाजी, दुनियां तू न पिशानो, पन मीं तू पिशानो, ते तैन चेलेईं भी अवं पिशानो कि तीं अवं भेज़ोरोईं। ");
INSERT INTO bhd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","मीं तैन पुड़ बांदू कियूं, कि तू कौन आस, ते बांदू केरतो रालो, ज़ैस प्यारे सेइं तीं मीं प्यार कियो, तै तैन मां भोए, ते अवं तैन मां बनोरो रेईं।” ");
INSERT INTO bhd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","यीशुए ए प्रार्थना केरतां झ़ाड़ी, त अपने चेलन सेइं साथी किद्रोन वैदरे पार जेव। तैड़ी अक बाग थी तै ते तैसेरे चेले तैड़ी जे। ");
INSERT INTO bhd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","तैस ट्लुवांने बालो यहूदा तैस ठारारो बाकम थियो, किजोकि यीशु अपने चेलन सेइं साथी तैड़ी केही फेरेईं जोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","तैखन यहूदे, रोमी सिपाही ते किछ प्रधान याजक ते फरीसी केरे तरफां भेज़ोरे लोकन सेइं साथी एन्तां दीये ते मिसालां ते हथियार घिन्तां तैड़ी पुज़ाए। ");
INSERT INTO bhd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","तैखन यीशु सब गल्लां ज़ैना तैस सेइं भोनेबैली थी, बुझ़तां तैन सेइं ज़ोने लगो, “तुस केस लोरेथ तोपने?” ");
INSERT INTO bhd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","तैनेईं तैस जुवाब दित्तो, “यीशु नासरी।” यीशुए तैन सेइं ज़ोवं, “अवं तैए आईं।” तैस ट्लुवांने बालो यहूदा भी तैन सेइं साथी खड़खड़ो थियो। ");
INSERT INTO bhd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ज़ैखन यीशुए ज़ोवं, “अवं तैए आईं,” तैना पत्रोवं ज़मीनी पुड़ झ़ड़े। ");
INSERT INTO bhd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","एल्हेरेलेइ तैनी फिरी पुच़्छ़ू, “तुस केस लोरेथ तोपने?” तैनेईं जुवाब दित्तो, “यीशु नासरी।” ");
INSERT INTO bhd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","यीशुए जुवाब दित्तो, “मीं त ज़ोवं कि अवं तैए आईं, अगर तुस मीं तोप्पतथ, त एन लोकन गाने देथ।” ");
INSERT INTO bhd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","एन एल्हेरेलेइ भोवं, कि तैन वचन पूरू भोए, “ज़ैना तीं मीं दित्ते, तैन मरां मीं अक भी न हिरव।” ");
INSERT INTO bhd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","शमौन पतरसे कां अक तलवार थी, तैनी तलवार केढतां महायाजकेरे नौकरे बाई ते तैसेरो देइने कन्न केटव। तैस नौकरे नवं मलखुस थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","तैखन यीशुए पतरसे ज़ोवं, “अपनि तलवार मियांने मां रख, कुन अवं तै दुखेरो कटोरो न पीं ज़ै मेरे बाजे मीं पीनेरे लेइ दितोए?” ");
INSERT INTO bhd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","तैखन रोमी फौवजी ते तैन केरे सूबेदार ते यहूदी केरे लीडरेईं यीशु ट्लाव तै बंधे। ");
INSERT INTO bhd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ते पेइलो हन्ना कां नीयो किजोकि तै कैफारो शेरहो थियो ज़ै तैस सालेरो महायाजक थियो। ");
INSERT INTO bhd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ई तैए कैफाए ज़ैनी यहूदन सलाह दित्तोरी थी, कि इश्शे लोकां केरे लेइ एक्की मैनेरू मरनू रोड़ू आए। ");
INSERT INTO bhd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","शमौन पतरस ते अक होरो चेलो यीशु पत्ती जे। तै चेलो महायाजकेरो बाकम थियो, तै यीशु सेइं साथी महायाजकेरे अंगने मां जेव। ");
INSERT INTO bhd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","पन पतरस बेइर दारे पुड़ खड़ो थियो, तै होरो चेलो ज़ै महायाजकेरो बाकम थियो वापस अव, ते तैस नौकरैनी सेइं ज़ै दारे पुड़ थी गल केरतां पतरस अन्तर नीयो। ");
INSERT INTO bhd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","तैस नौकरेनां ज़ै दारे पुड़ थी पतरसे पुच़्छ़ू, “कुन तू भी तैसेरे चेलन मरां आस?” पतरस ज़ोवं, “नईं अवं नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ठंडारे वजाई सेइं नौकरेईं ते मन्दरेरे पहरदारेईं अग बालोरी थी, ते पतरस भी तैन सेइं साथी अग लोरो थियो तपने। ");
INSERT INTO bhd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","तैखन महायाजक यीशुएरे चेलां त कने तैसेरी शिक्षारे बारे मां पुच्छ़ने लगो। ");
INSERT INTO bhd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","यीशुए जुवाब दित्तो, “मीं त सेब्भी केरे सामने सैरी गल्लां कियोरिन, मीं त रोज़ तुश्शे प्रार्थना घरन ते मन्दरे मां, ते ज़ैड़ी यहूदी अकोट्ठे भोतन तैड़ी शिक्षा दित्ती, ते छ़ेपतां किछ भी न ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","तू मीं ए सवाल किजो पुछ़तस? शुन्नेबालन पुच़्छ़ू, कि मीं तैन सेइं कुन ज़ोवरूए? हेर तैन पतोए, कि मीं कुन ज़ोवरूए।” ");
INSERT INTO bhd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ज़ैखन तैनी ज़ोवं, त मन्दरेरे पहरदारन मरां अक ज़ै तैड़ी खड़ो थियो, तैनी यीशुए थप्पड़ बैइतां ज़ोवं, “कुन तू महायाजक एन्च़रे जुवाब देतस?” ");
INSERT INTO bhd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","यीशुए तैस जुवाब दित्तो, “अगर मीं किछ बुरू ज़ोरूए त साबत केर, पन अगर रोड़ू ज़ोरूए त थप्पड़ किजो बातस?” ");
INSERT INTO bhd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","तैसेरां बाद हन्ना यीशुएरे हेजू बन्धोरो थियो तेन्च़रे महायाजक कैफा कां भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","शमौन पतरस खड़खड़ो अग लोरो थियो तपने। तैखन केन्चे तैस पुच़्छ़ू, “कुन तू भी तैसेरे चेलन मरां आस?” पतरस इन्कार केरतां ज़ोवं, “नईं अवं नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","महायाजकेरे नौकरन मरां अक ज़ै तैसेरो रिशतेदार थियो, ज़ेसेरो कन्न पतरसे तलवारी सेइं कटोरो थियो, ज़ोने लगो, “कुन मीं तू बागी मां यीशु साथी नईं लाहोरो?” ");
INSERT INTO bhd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पतरसे फिरी इन्कार कियो, ते तैखन कुकड़े भी बांग दित्ती। ");
INSERT INTO bhd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","तैनेईं यीशु झ़ेझ़ां कैफा करां रोमी गवर्नर पिलातुसेरे महले मां नीयो, पन तैना एप्पू अन्तर न जे, ताके भिटे न भोन, ते फ़सह तिहारेरी रोट्टी खेइ बटन। ");
INSERT INTO bhd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","तैखन पिलातुस तैन कां बेइर अव ते ज़ोने लगो, “तुस इस मैन्हु पुड़ कुन इलज़ाम लातथ?” ");
INSERT INTO bhd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","तैनेईं तैस जुवाब दित्तो, “ए मैन्हु मुर्ज़म न भोथो त असेईं ए तीं कां न थियो आन्नो।” ");
INSERT INTO bhd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पिलातुसे तैन सेइं ज़ोने लगो, “तुस एस नेथ ते अपने कानूनेरे हिसाबे सेइं फैसलो केरा।” यहूदी लीडर ज़ोने लगे, “असन त केन्ची भी मारनेरी अज़ाज़त नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","एन एल्हेरेलेइ भोवं कि ज़ैन गल्लां यीशुए ज़ोरी थी, कि तै केरही मौतां मरेलो पूरी भोन। ");
INSERT INTO bhd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","तैखन पिलातुस फिरी महले मां जेव ते तैनी यीशु कुजेइतां तैस पुच़्छ़ू, “कुन तू यहूदी केरो राज़ोस?” ");
INSERT INTO bhd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","यीशुए जुवाब दित्तो, “तू ए गल अपनि भोती ज़ोने लोरोस कि होरेईं मेरे बारे मां तीं सेइं ज़ेवरीए?” ");
INSERT INTO bhd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातुसे जुवाब दित्तो, “कुन अवं यहूदी आईं? तेरी कौमरे ते प्रधान याजकेईं तू मेरे हवाले कियोरोस, तू ज़ो तीं कुन कियोरूए?” ");
INSERT INTO bhd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","यीशुए जुवाब दित्तो, “मेरू राज़ इस दुनियारू नईं, अगर दुनियारू भोथू त मेरे चेले जंग केरेथे, ते मीं यहूदी लोकां केरे प्रधानां केरे हथ्थे ट्लेयोने न देथे, पन हुन्ना मेरू राज़ इट्ठेरू नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","पिलातुसे ज़ोवं, “त कुन तू राज़ोस?” यीशुए जुवाब दित्तो, “तू ज़ोतस कि, अवं राज़ोईं, अवं एल्हेरेलेइ ज़रमोरोंई, ते एल्हेरेलेइ दुनियाई मां ओरोईं कि सच़्च़ेरे बारे मां शिक्षा देईं। ज़ैना सच़्च़े मन्तन तैना मेरी गल शुन्तन।” ");
INSERT INTO bhd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातुसे पुच़्छ़ू, “सच़ कुने?” एन ज़ोइतां तै यहूदी लीडरन कां जेव ते ज़ोने लगो, “अवं त एस मैन्हु मुरज़म न सेमझ़ी।” ");
INSERT INTO bhd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","पन तुश्शे रीतरे मुताबिक अवं फ़सह तिहारेरे मौके पुड़ अक कैदी हथरां छ़डताईं। कुन तुस चातथ कि अवं तुश्शे लेइ यहूदी केरे राज़े हथरां छ़ेड्डी? ");
INSERT INTO bhd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","तैना फिरी ज़ोरे-ज़ोरे सेइं ज़ोने लगे, ए नन्ना इश्शे लेइ बरअब्बा हथरां छ़ड। बरअब्बा अक डैकू थियो। ");
INSERT INTO bhd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","पिलातुसे सिपेहिन हुक्म दित्तो, कि यीशु नेइतां कोड़े बान। ");
INSERT INTO bhd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ते सिपाहीयेइं कंटां केरू ताज बनेइतां यीशुएरे दोग्गे पुड़ रख्खू, ते तैस बैंजनी रंगेरां लिगड़ां लुवां। ");
INSERT INTO bhd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ते तैन केरे सामने तैन कां एइतां ज़ोने लगो, “हे यहूदी केरे राज़ा, नमस्कार!” ते तैस थप्पड़ बाहे। ");
INSERT INTO bhd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","तैखन पिलातुसे फिरी बेइर गेइतां लोकन सेइं ज़ोवं, हेरा, “अवं तैस तुसन कां फिरी बेइर आनताईं, तुसन पतो लगे कि मीं एसमां कोई जुरम न लेइहोव।” ");
INSERT INTO bhd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ज़ैखन यीशु कंटां केरू ताज दोग्गे पुड़ रेखतां ते बैंजनी लिगड़ां लेइतां बेइर आनो त पिलातुसे तैन सेइं ज़ोवं, “हेरा ई मैन्हु।” ");
INSERT INTO bhd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ज़ैखन प्रधान याजक ते मन्दरेरे पहरदारेईं यीशु लाव त ज़ोरे-ज़ोरे चिन्डां मैरतां ज़ोने लगे, “एस क्रूसे पुड़ च़ाढ़ा, एस क्रूसे पुड़ च़ाढ़ा!” पिलातुसे तैन सेइं ज़ोवं, “तुसे एस नेथ ते क्रूसे पुड़ च़ाढ़ा, किजोकि अवं एसमां कोई दोष न लेहीं।” ");
INSERT INTO bhd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदी लीडर ज़ोने लगे, “इश्शो भी कानूने, ते तैसेरे कानूनेरे मुताबिक ए मौतरे सज़ारे काबले। किजोकि ए अपने आपे जो परमेशरेरू मट्ठू ज़ोते।” ");
INSERT INTO bhd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ज़ैखन पिलातुसे एन शुनू त तै मन्ना डरो। ");
INSERT INTO bhd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ते फिरी अपने महले मां जेव ते यीशु सेइं फिरी ज़ोवं, “तू कोट्ठां ओरोस?” पन यीशुए तैस किछ जुवाब न दित्तो। ");
INSERT INTO bhd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","पिलातुसे तैस सेइं ज़ोवं, “तू मीं सेइं गल कि न केरस? कुन तीं पतो नईं कि मीं अधिकार कि अवं तीं हथरां छ़ैडी या क्रूसे पुड़ च़ैढ़ेईं।” ");
INSERT INTO bhd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","यीशुए जुवाब दित्तो, “अगर ए अधिकार तीं परमेशरे करां न भोथो मैलोरो त तेरो कोई अधिकार मीं पुड़ न थियो भोनो, पन ज़ैनी अवं तेरे हवाले कियोरोईं ते हछे पापेरो हकदार भोरोए।” ");
INSERT INTO bhd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","तैसेरां बाद पिलातुसे यीशु हथरां छ़डनो चाव, पन यहूदी लोक चिन्डां मेरतां ज़ोने लगे, “अगर तू एस मैन्हु हथरां छ़ाडेलो त तू महाराज़ेरे पासे नईं, ज़ै कोई अपनो आप राज़ो बनाते तै महाराज़ेरे खलाफ भोते।” ");
INSERT INTO bhd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ज़ैखन पिलातुसे एन शुनू त तैनी यीशु बेइर कुजेइतां अपने आदालतरे तखते पुड़ बिश्शो ज़ैस जो इब्रानी भाषाई मां, गब्बता, ज़ोतन। ");
INSERT INTO bhd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","तै फ़सह तिहारेरी तियैरारी दिहाड़ी थी ते दुपाहरां केरे करीब थियो, तैखन पिलातुसे यहूदी लोकन जो ज़ोवं, “हेरा, ई तुश्शो राज़ो!” ");
INSERT INTO bhd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","पन तैना ज़ोरे-ज़ोरे सेइं ज़ोने लगे, “एस इट्ठां दूर ने! इट्ठां दूर ने! ते एस क्रूसे पुड़ च़ाढ़!” पिलातुसे ज़ोवं, “कुन अवं तैस ज़ै तुश्शो राज़ो क्रूसे पुड़ च़ैढ़ी?” प्रधान याजकेईं ज़ोवं, “महाराज़ेरे अलावा इश्शो कोई राज़ो नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","एसेरां बाद पिलातुसे यीशु तैन केरे हवाले कियो, ताके तैना तैस क्रूसे पुड़ च़ाढ़न। ");
INSERT INTO bhd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","यीशु अपनू क्रूस छ़ुइतां खोपड़ी जो च़लो ज़ैस जो इब्रानी मां गुलगुता ज़ोतन। ");
INSERT INTO bhd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","तैड़ी तैनेईं यीशु ते तैस सेइं साथी दूई डैकू भी क्रूसे पुड़ च़ाढ़ो, अक तैसेरे देइने पासे होरो बांए पासे ते यीशु मझ़ाटे। ");
INSERT INTO bhd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पिलातुसे एक्की पेखड़ी पुड़ तैसेरो दोष लिखतां क्रूसे पुड़ लाई तैस पुड़ लिखोरू थियूं, “यीशु नासरी यहूदी केरो राज़ो।” ");
INSERT INTO bhd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","काई यहूदेईं तैन पढ़ू, किजोकि ज़ैस जगाई यीशु क्रूसे पुड़ च़ढ़ोरो थियो ते जगा यरूशलेम नगरेरे नेड़े थी, ते पेखड़ी पुड़ इब्रानी, लातीनी ते यूनानी भाषाई मां लिखोरू थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","यहूदी केरे प्रधान याजकेईं पिलातुसे कां दरखुवास की, “यहूदी केरो राज़ो न लिखा पन एन लिखा कि ए ज़ोते, ‘अवं यहूदी केरो राज़ोईं।’” ");
INSERT INTO bhd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातुसे जुवाब दित्तो, “मीं ज़ैन लिखी छ़ाडु, तैन लिखू।” ");
INSERT INTO bhd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ज़ैखन स्पेहियेई यीशु क्रूसे पुड़ च़ाढ़ो त तैनेईं यीशुएरे लिगड़ा बंटां ते तैन केरे च़ेव्रे हिस्से किये, ताके सेब्भन अक-अक हिस्सो मैल्ले सिर्फ तैसेरू कोट बाकी राऊं, ज़ैन बा ते बुना तगर अक्के थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","तैना एप्पू मांमेइं ज़ोने लगे, “एसेरे टोटे केरनेरे बजाए शर्त रखम ज़ेसेरे नंव्वे पुड़ परची निसेली लिगड़ां तैस भोलां।” एन एल्हेरेलेइ भोवं कि ज़ैन पवित्रशास्त्रे मां लिखोरू थियूं तैन पूरू भोए कि, “तैनेईं मेरां लिगड़ां बंटा ते मेरे कोटेरे लेइ शर्त रख्खू ते सिपैहीयेइं एन कियूं।” ");
INSERT INTO bhd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","यीशुएरे क्रूसे कां तैसेरी अम्मा ते तैसेरी अम्मारी बेइन मरियम ज़ै क्लोपासेरी कुआन्श थी, मरियम मगदलीनी खड़खड़ी थी। ");
INSERT INTO bhd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","यीशुए अपनि अम्मा ते अक अपनो चेलो ज़ैस सेइं तै प्यार केरतो थियो, तैस कां नेड़े खड़खड़ो लाव त तैनी अपने अम्मा सेइं ज़ोवं, “हे कुआन्श, हेर, तेरू मट्ठूए।” ");
INSERT INTO bhd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ते चेले जो ज़ोवं, “अज़ेरां बाद, ई तेरी अम्मा आए, तैनी चेले तैखने तै अपने घरे नेइ।” ");
INSERT INTO bhd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ज़ैखन यीशुए ज़ांनू कि हुनी सैरी गल्लां पूरी भोइजेइ, एल्हेरेलेइ ज़ेन्च़रे पवित्रशास्त्रेरे मां लिखोरू थियूं तैन पूरू भोवं त तैनी ज़ोवं, “मीं ट्लिश लग्गोरीए।” ");
INSERT INTO bhd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","तैड़ी अक भांड सिरके सेइं भेरतां रखोरू थियूं, केन्चे जूफेरी डालड़ी तैस मां डोबतां यीशुएरे ऐशी सेइं हुराई। ");
INSERT INTO bhd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ज़ैखन यीशुए च़ख्खू त तैनी ज़ोवं, “पूरू भोवं” ते क्रोड़ी ट्लोड़तां अपने प्राण दित्ते। ");
INSERT INTO bhd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ते एल्हेरेलेइ कि तै तियेरारी दिहाड़ी थी, होरसां आरामेरी दिहाड़ी ते कने फ़सह तिहार थियूं। ई यहूदी केरे लेइ खास दिहाड़ी थी, यहूदी न थिये चाते कि आरामेरे दिहाड़े लाशां क्रूसन पुड़ टंगोरी रान, एल्हेरेलेइ तैनेईं पिलातुसे कां गेइतां ज़ोवं, कि मुर्ज़मां केरि ज़न्घां ट्लोड़तां तैन केरि लाशां उन्ढी उसालम। ");
INSERT INTO bhd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","सिपाही आए तैनेईं पेइले मैनेरी ज़न्घां ट्लोड़ी, फिरी होरेरी भी, ज़ैना यीशु सेइं साथी क्रूसे पुड़ च़ाढ़ोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","पन ज़ैखन यीशुएरी बारी अई त तैनेईं हेरू कि ते पेइले मेरि जेवरोए, ते तैनेईं तैसेरी ज़न्घां न ट्लोड़ी। ");
INSERT INTO bhd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","पन सिपेहिन मरां एक्के अपनि बलम एन्तां यीशुएरे देल्लोड़ी मां बाई ते तैखने खून त पानी बगने लगू। ");
INSERT INTO bhd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ज़ैनी मैने एन हेरू, तैनी गवाही दित्ती, ते तैसेरी गवाही सच़्च़ीए, ते तै ज़ानते, कि सच़ ज़ोते कि तुस भी विश्वास केरा। ");
INSERT INTO bhd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","एना सैरी गल्लां एल्हेरेलेइ भोइ कि पवित्रशास्त्रे मां लिखोरू पूरू भोए, “तैसेरी कोई हडी न ट्लोड़ी गाए।” ");
INSERT INTO bhd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","पवित्रशास्त्रेरे एक्की होरि वचने मां लिखोरूए, “तैस ज़ैनेईं बलमी सेइं बाई तैना तैस हेरेले।” ");
INSERT INTO bhd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","एना गल्लां केरे पत्ती अक मैन्हु यूसुफ नंव्वेरो ज़ै अरिमतियाह ड्लोंव्वेरो रानेबालो थियो, पिलातुसे कां बिनती केरने लगो, कि यीशुएरी लाश दे, ए मैन्हु यहूदी लोकां केरे प्रधानां केरे डरे सेइं छ़ेपतां यीशुएरो चेलो थियूं, तै पिलातुसे तैस अज़ाज़त दित्ती, ते तैनी यीशुएरी लाश नेही। ");
INSERT INTO bhd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","नीकुदेमुस भी अव, ज़ैनी एक्की बार राती यीशु सेइं मुलाकात कियोरी थी, तैनी गन्धरस ते एलवा आनोरे थिये, एन तेत्ती किल्लो थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","तैखन तैनेईं यीशुएरी लाश नेइतां यहूदी केरे दबनेरे रसमरे मुताबिक तैस खुशबूदार चीज़ां लेइतां कफने मां पलेटतां रख्खी। ");
INSERT INTO bhd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ज़ैड़ी यीशु क्रूसे पुड़ च़ाढ़ोरो थियो तैड़ी बागी मां अक नंव्वी कब्र थी, ज़ैस मां पेइली कोई लाश न थी। ");
INSERT INTO bhd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ते ए यहूदी केरि आरामेरी तियेरारी दिहाड़ी थी ते कब्र भी नेड़े थी तैनेईं यीशुएरी लाश तैड़ी रख्खी। ");
INSERT INTO bhd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","हफतेरी पेइली दिहैड़ी झ़ेझ़ां हेजू आंधरू थियूं मगदलीन ड्लंव्वेरी मरियम कब्री पुड़ आई, तैसां हेरू कि कब्री करां घोड़ भी खड़ो कियोरोए। ");
INSERT INTO bhd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ते दौवड़ती शमौन पतरस ते होरि चेले कां पुज़ी ज़ै यीशु सेइं प्यार केरतो थियो, ज़ोने लगी, “तैनेईं प्रभुएरी लाश कब्री मरां केढतां नीयोरो, ते असन नईं पतो तै कोड़ि रख्खोरोए।” ");
INSERT INTO bhd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","एना शुन्तां पतरस त अक होरो चेलो कब्रारे पासे च़ले। ");
INSERT INTO bhd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ते दुइये साथी-साथी दौवड़तां च़लोरे थिये, पन तै होरो दुइयोवं चेलो पतरस करां अग्रोवं निस्सी जेव, ते तैस करां पेइलो कब्री पुड़ पुज़ो। ");
INSERT INTO bhd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","तैनी लिकतां तक्कू ते कफन लाव ते अन्तर न जेव। ");
INSERT INTO bhd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","तैखन शमौन पतरस भी पत्ती-पत्ती तैड़ी पुज़ो ते सिधो कब्री मां जेव तैनी हेरू कि तैड़ी लिगड़ां थियां। ");
INSERT INTO bhd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ते कफनेरो तै रुमाल भी ज़ै यीशुएरे दोग्गे सेइं पलेटोरो थियो, लिगड़न मां नईं पन अलग ठैरी थियो। ");
INSERT INTO bhd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","तैखन तै होरो चेलो भी ज़ै कब्री पुड़ पेइलो पुज़ोरो थियूं अन्तर जेव तैस भी लेइतां याकीन भोवं। ");
INSERT INTO bhd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","किजोकि तैनेईं पवित्रशास्त्रेरी ए गल न थी समझ़ोरी ज़ेसेरे बारे मां यीशुएरू मुड़दन मरां ज़ींतू भोनू ज़रूरी थियूं। ");
INSERT INTO bhd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","तैखन एना चेले वापस घरजो च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","पन मरियम कब्री करां बेइर लेरां देंती थी। लेरां देंती-देंती तैसां लिकतां कब्री मांजो तक्कू। ");
INSERT INTO bhd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","त तैड़ी तैसां दूई स्वर्गदूत लाए ज़ैन छ़ित्तां लिगड़ां लग्गोरां थियां, ज़ैड़ी यीशुएरी लाश रखोरि थी तैड़ी अक शरेइंते ते होरो परेइंते बिश्शोरे लाए। ");
INSERT INTO bhd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","तैनेईं तैस पुच़्छ़ू, “हे कुआन्शे तू किजो लोरिस लेरां देने?” मरियमा ज़ोवं, “तैनेईं मेरे प्रभुएरी लाश नेवरीए ते पतो नईं कोड़ि रख्खोरोए।” ");
INSERT INTO bhd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","एना ज़ोंते तै पत्रोवं बेदलोई त तैड़ी यीशु खड़खड़ो लाव, पन तैस पिशान न आई कि ए यीशुए। ");
INSERT INTO bhd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","यीशुए ज़ोवं, “हे कुआन्शे तू किजो लेरां देने लोरिस? तू केस तोपने लोरिस?” तैसां समझ़ू कि कोई बागबाने, तैसां ज़ोवं, “हे जनाब अगर तीं तै नीयोरोए त ज़ो कि तीं कोड़ि रख्खोरोए ते अवं तैस नेइ।” ");
INSERT INTO bhd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","यीशुए तैस सेइं ज़ोवं, “मरियम!” तैसां तैसेरे पासे फिरतां इब्रानी मां ज़ोवं, “रब्बूनी!” ज़ेसेरो मतलबे हे गुरू। ");
INSERT INTO bhd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","यीशुए ज़ोवं, “मीं सेइं न हुरा किजोकि अवं बाजी कां बाह हेजू नईं जोरो, पन मेरे ढ्लान गेइतां ज़ो कि अवं अपने बाजी ते तुश्शे बाजी ते अपने परमेशर ते तुश्शे परमेशरे कां बा च़लोरोईं।” ");
INSERT INTO bhd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरियम मगदलीनी तैट्ठां च़ली जेई ते चेलन कां गेइतां तैन पतो दित्तो, “मीं प्रभु लाहोरोए ते तैनी मीं सेइं एना गल्लां की।” ");
INSERT INTO bhd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","तैस्से दिहैड़ी ज़ै हफतेरी पेइली दिहाड़ी थी ड्लोझ़रे मौके सारे चेले एक्की ठैरी थिये, ते यहूदी लोकां केरे प्रधानां केरे डरे सेइं दार बन्द केरतां बिश्शोरे थिये, तैखन यीशु अव ते मझ़ाटे खड़ो भोइतां ज़ोने लगो, “तुसन शान्ति मैलती राए।” ");
INSERT INTO bhd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","एन ज़ोइतां तैनी अपने हथ ते अपनि देल्लोड़ी तैन हिराई, चेले तैस हेरतां खुशी भोए। ");
INSERT INTO bhd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","यीशुए फिरी ज़ोवं, “तुसन शान्ति मैलती राए, ज़ेन्च़रे बाजी अवं भेज़ोरोईं, तेन्च़रे अवं भी तुसन भी इस दुनियाई मां भेज़ताईं।” ");
INSERT INTO bhd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","एन ज़ोइतां तैनी तैन जो फुक दित्ती ते ज़ोवं, “पवित्र आत्मा नेथ। ");
INSERT INTO bhd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ज़ैन केरे पाप तुस माफ़ केरेले त तैन केरे पाप माफ़ भोले, ज़ैन केरे तुस रखेले तैना राले।” ");
INSERT INTO bhd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","पन बादे मां 12 चेलन मरां अक मैन्हु मतलब थोमा ज़ैस दिदुमुस ज़ोतन, ज़ैखन यीशु अव त तै तैन साथी न थियो। ");
INSERT INTO bhd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ज़ैखन होरि चेले तैस सेइं ज़ोवं, “कि असेईं प्रभु लाव,” तैखन तैनेईं ज़ोवं, “ज़ां तगर अवं तैसेरे हथ्थन मां कीलां करां गत्तन मां एंगलोई न छ़ेड्डी, तांतगर विश्वास न केरि।” ");
INSERT INTO bhd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","अठ दिहैड़ना बाद यीशुएरे चेले एक्की बार फिरी तैस्से ठैरी बिश्शोरे थिये, ते थोमा भी तैड़ी थियो ते दार भी बंद थियूं, ते यीशु एइतां तैन मझ़ाटे खड़ो भोव, ते तैन जो ज़ोने लगो, “तुसन शान्ति मैल्ले।” ");
INSERT INTO bhd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","फिरी तैनी थोमा जो ज़ोवं, “अपनि अंग्लोई आन ते मेरो हथ हेर ते अपने हथ्थे सेइं मेरी दल्लोड़ी हेर, शक न केर बल्के मीं पुड़ विश्वास केर।” ");
INSERT INTO bhd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","थोमा तैस जो ज़ोवं, “हे मेरे प्रभु हे मेरे परमेशर!” ");
INSERT INTO bhd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","यीशुए तैस जो ज़ोवं, “तीं लेइतां तीं मीं पुड़ विश्वास कियो, धन तैना ज़ैना बगैर लाहने मीं पुड़ विश्वास केरन।” ");
INSERT INTO bhd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","यीशुए अपने चेलां केरे सामने होरे भी बड़े चमत्कार कियोरे थिये, ज़ैना इस किताबी मां नईं लिखोरे। ");
INSERT INTO bhd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","पन ज़ैना लिखोरन, एल्हेरेलेइ लिखोरेन, कि तुस विश्वास केरथ, कि यीशु परमेशरेरू मट्ठू, मसीहे आए, ते विश्वास केरतां तैसेरे नंव्वे सेइं हमेशारी ज़िन्दगी हासिल केरथ। ");
INSERT INTO bhd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","बादे मां यीशुए एप्पू एक्की फेरे फिरी अपने चेलन पुड़ तिबिरियुस समुन्द्रेरो बन्ने एन्च़रे बांदो भोव। ");
INSERT INTO bhd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","शमौन पतरस, थोमा ज़ैस जो दिदुमुस ज़ोतन, नतनएल ज़ै गलीलेरे काना नगर मां रातो थियूं, ते जेब्देरू मट्ठू ते होरे चेले भी तैड़ी थिये। ");
INSERT INTO bhd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","शमौन पतरसे तैन सेइं ज़ोवं, “अवं मेछ़ली ट्लाने गाताईं।” तैनेईं ज़ोवं, “अस भी तीं साथी च़लतम।” तैना तैट्ठां निस्से ते किश्ती मां च़ेढ़तां जे, पन तैस राती तैन किछ न मैल्लू। ");
INSERT INTO bhd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","झ़ेझ़ां सुबेलो यीशु बन्ने पुड़ एइतां खड़ो भोव, पन चेलेईं न पिशानो कि ए यीशुए। ");
INSERT INTO bhd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","तैखन यीशुए तैन ज़ोवं, “हे बच्चव, कुन तुसन कां किछ खाने जो आए?” तैनेईं जुवाब दित्तो, “नईं।” ");
INSERT INTO bhd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","यीशुए ज़ोवं, “ज़ाल किश्तरे देइने पासे छ़डथ त तुसन किछ मेछ़ली मैलनिन।” तैनेईं ज़ाल छ़ाडु ते मेछ़ली एत्री ज़ाले मां लेगि कि ज़ाल खिचोने न लगू। ");
INSERT INTO bhd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","तैखन यीशु ज़ैस चेले सेइं प्यार केरतो थियो तैनी पतरस सेइं ज़ोवं, “ए त प्रभुए।” ज़ेरू शमौन पतरसे शुन्नू कि प्रभुए, तैनी अपनो चोगो, ज़ै कम केरनेरे लेइ खोल्लोरो थियो लाव ते पैनी मांजो छाल मारी। ");
INSERT INTO bhd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","होरे चेले ज़ैना किश्ती मां थिये ज़ाल ज़ैना मेछ़लेईं सेइं भेरतां थियूं तैनेईं खिचतां आनू, किजोकि तैना 100 मीटर दूर थिये। ");
INSERT INTO bhd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ज़ैखन तैना बन्ने पुड़ ओस्से, त तैनेईं मूरन पुड़ मेछ़ली रेखोरिन ते ड्लेखी रोट्टी भी लेई। ");
INSERT INTO bhd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","यीशुए तैन सेइं ज़ोवं, “ज़ैना मेछ़ली तुसेईं ट्लेतोरिन तैन मरां किछ इरां आनां।” ");
INSERT INTO bhd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","शमौन पतरस किश्ती मां च़ढ़ो ते ज़ाल ड्लेखी पुड़ खिचतां आनू ज़ैस मां 153 मेछ़ली लेगोरी थी, ते फिरी भी ज़ाल नईं छ़ींदोरू। ");
INSERT INTO bhd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","यीशुए तैन सेइं ज़ोवं, “एज्जा केलोव खाथ।” पन चेलन मरां केन्ची हिम्मत न अई कि पुछ़न, “कि तू कौन आस?” तैना ज़ानते थिये कि ए प्रभुए। ");
INSERT INTO bhd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","यीशुए रोट्टी ट्लाती ते तैना भी दित्ती ते मेछ़ली भी दित्ती। ");
INSERT INTO bhd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","यीशु मुड़दन मरां ज़ींतो भोनेरां पत्ती ट्लेइयोवं फेरे अपने चेलन पुड़ बांदो भोइ जेव। ");
INSERT INTO bhd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ज़ैखन तैनेईं केलोव खाव, त यीशुए शमौन पतरसे सेइं ज़ोवं, “शमौन,” यूहन्नेरे मट्ठा, “कुन तू होरि चेलन करां जादे मीं सेइं प्यार केरतस?” तैनी ज़ोवं, “हाँ प्रभु तू त मीं ज़ानतस कि अवं तीं सेइं प्यार केरताईं।” यीशुए ज़ोवं, “मेरां गबड़ां च़ार।” ");
INSERT INTO bhd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","यीशुए फिरी तैन सेइं ज़ोवं, “शमौन, यूहन्नेरे मट्ठा, कुन तू मीं सेइं प्यार केरतस?” तैनी ज़ोवं, “हाँ प्रभु, अवं तीं सेइं प्यार केरताईं।” यीशुए तैस सेइं ज़ोवं, “मेरी भैड्डां सम्भाल।” ");
INSERT INTO bhd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","तैनी ट्लेइयोवं फेरे फिरी पुच़्छ़ू, “शमौन यूहन्नेरे मट्ठा, कुन तू मीं सेइं प्यार केरतस?” पतरस दुःखी भोइतां ज़ोवं, “प्रभु तू एप्पू सैरी गल्लां ज़ानतस, तू ज़ानतस, कि अवं तीं सेइं प्यार केरताईं,” यीशुए, ज़ोवं, “मेरी भैड्डां च़ार।” ");
INSERT INTO bhd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","अवं तीं सेइं सच़ ज़ोताईं, ज़ैखन तू नौजवान थियो त अपनू मज़ एप्पू बंधतो थियो, ते ज़ैड़ी चातो थियो, एप्पू गातो थियो, पन ज़ैखन तू बुढो भोलो, त अपने हथ अग्रोवं केरेलो, ते होरो तेरू मज़ बंधेलो ज़ैड़ी तू न चालो तैड़ी तीं नेले। ");
INSERT INTO bhd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","यीशुए ए गल ज़ोइतां इशारो कियो कि पतरस कोस मौतां मेरतां परमेशरेरी महिमा बांदी केरेलो। तैखन यीशुए ज़ोवं, “मीं पत्ती च़ल!” ");
INSERT INTO bhd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पतरसे फिरतां तक्कू, कि यीशु सेइं प्यार केरनेबालो चेलो तैस पत्ती च़लोरोए थियो, ए तै चेलो थियो ज़ैनी रोट्टी खाते यीशुएरे पासे लिकतां पुछ़ेरू थियूं, “हे प्रभु तै कौने, ज़ै तीं ट्लुवालो?” ");
INSERT INTO bhd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","पतरसे तैसेरे पासे तेकतां यीशुए पुच़्छ़ू, “हे प्रभु एस चेले सेइं कुन भोलू।” ");
INSERT INTO bhd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","यीशुए जुवाब दित्तो, अगर अवं चैई कि, “अगर मेरे वापस एजने तगर ज़ींतो राव त एसमां तीं कुन? तू मीं पत्ती च़ल।” ");
INSERT INTO bhd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","एन्च़रे ढ्लान मां ए गल सेभीए फैली जेई, कि ए चेलो न मरेलो, पन यीशुए एन न थियूं ज़ोरू, कि तै न मरेलो अगर अवं चैई कि, “अगर मेरे वापस एजने तगर ज़ींतो राव, त एसमां तीं कुन?” ");
INSERT INTO bhd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ई तै चेलोए, ज़ै इना गल्लां केरि गवाही देते, ते ज़ैनी एना गल्लां लिखोरिन, असां ज़ानतम कि तैसेरी गवाही सच़्चीए। ");
INSERT INTO bhd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","यीशुए होरां भी बड़ां कम्मां कियोरां थियां, अगर सेब्भी केरे बारे मां लिखनू भोए त अवं समझ़ताईं, कि तैना किताबां अज़ भोथी त तैन केरे लेइ इस दुनियाई मां ठार न थी भोनी।");
INSERT INTO bhd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","जनाब थियुफिलुस, मीं अपनि पेइली किताब मां तैना सैरी गल्लां लिखोरिन, ज़ैना यीशु शुरू मां केरतो ते शिखालतो राव, ");
INSERT INTO bhd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","तैस दिहैड़ी तगर ज़ेइस तै स्वर्गे मांजो नीयो जेव। तैस करां पेइले तैनी अपने च़ुनोरे प्रेरितन पवित्र आत्मारे शेक्तरे ज़िरिये सेइं किछ हुक्म भी दित्तोरे थी। ");
INSERT INTO bhd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","यीशुए दुःख झ़ैलनेरां ते मौतरे बाद तैनी अपने ज़ींते भोनेरां काई पक्कां सबूतां तैन हिरां, ते 40 दिहाड़न तगर तैन लेइहोतो राव, ते परमेशरेरे राज़्ज़ेरे गल्लां शुनातो राव। ");
INSERT INTO bhd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","एक्की फेरे ज़ैखन यीशुए अपने चेलन सेइं साथी थियो तैनी तैन ठाकू, “कि तुस यरूशलेम नगरे मरां बेइर न गेइयथ ते मेरे बाजी परमेशरेरो तै वादो पूरो भोनेरो इंतज़ार केरथ, ज़ेसेरे बारे मां तुसेईं मीं करां शुनोरू भी आए। ");
INSERT INTO bhd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","किजोकि यूहन्ना त लोकन पैनी सेइं बपतिस्मो दित्तो, पन तुसन थोड़े दिहैड़ना पत्ती पवित्र आत्मा सेइं बपतिस्मो दित्तो गालो (यानी परमेशर पवित्र आत्मा भेज़ेलो ज़ै तुसन सेइं साथी रालो)” ");
INSERT INTO bhd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ज़ताली प्रेरित दुबारा यीशु सेइं मिले, त तैनेईं तैस पुच़्छ़ू, “हे प्रभु, कुन तू इस वक्ते फिरी इस्राएले तैसेरू राज़ देने बालोस?” ");
INSERT INTO bhd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","तैनी तैन सेइं ज़ोवं, “तैस वक्तेरो या ज़ेइस तैना गल्लां भोली, तैन केरे बारे मां तुसन ज़ान्नेरी कोई ज़रूरत नईं, ज़ैना बाजी परमेशरे अपने अधिकार मां रेखोरिन। ");
INSERT INTO bhd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","पन पवित्र आत्मा ज़ैखन तुसन पुड़ उतरेली त तुसन शक्ति मैलेली, ते तुस यरूशलेम नगर ते सारे यहूदिया ते सामरिया इलाकन मां बल्के धेरतारे हर पासे मेरे गवाह भोले।” ");
INSERT INTO bhd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","एना गल्लां ज़ोनेरां पत्ती यीशु तैन केरे सामने हेरते-हेरते परमेशरे तै स्वर्गे जो नीयो, ते बिदलारां तै तैन केरे एछ़्छ़न करां छ़ुपाव। ");
INSERT INTO bhd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ज़ैखन तैना यीशुए अम्बरे मांजो गांतो तकने लोरे थिये, त अचानक, दूई मड़द ज़ैन छ़ित्तां लिगड़ां लग्गोरां थियां तैन कां एइतां खड़े भोए। ");
INSERT INTO bhd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ते ज़ोने लगे, “हे गलीली मड़दाव तुस खड़खड़े अम्बरेरे पासे कुन तकने लोरेथ? एहे यीशु ज़ेन्च़रे तुश्शे सामने परमेशरे, स्वर्गे मांजो नीयो, ज़ेन्च़रे तुसेईं स्वर्गे मांजो गांतो लाहोरोए तेन्च़रे फिरी एइतो लाएले।” ");
INSERT INTO bhd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ज़ैखन चेले ज़ैतून पहाड़े पुड़ेरां ज़ैन यरूशलेम नगरेरे नेड़े एक्की किलोमीटर दूरे, यरूशलेम नगरे मांजो वापस आए। ");
INSERT INTO bhd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","नगरे मां एइतां तैना तैस कमरे मां जे ज़ैड़ी तैना रहते थिये, तै कमरो दुइयोवं छते थियो। तैना प्रेरित इना थिये, पतरस, यूहन्ना, याकूब, अन्द्रियास, फिलिप्पुस थोमा, बरतुल्मै, मत्ती ते हलफईरू मट्ठू याकूब ते शमौन जेलोतेस ते याकूबेरू मट्ठू यहूदा रहते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","एना सब मड़द ते किछ होरि कुआन्शां ज़ैनेईं यीशुएरी मद्दत कियोरी थी, ते यीशुएरी अम्मा मरियम ते यीशुएरे ढ्लान सेइं साथी अक मन भोइतां लगातार प्रार्थनाई मां लग्गोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ते तैन्ने दिहाड़न मां पतरस तैन ढ्लां केरि टोली मां ज़ैन केरि तैधात कोई 120 थिये, पतरस खड़ो भोइतां ज़ोने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“हे मेरे ढ्लाव, पवित्रशास्त्रेरी तै गल ज़ै पवित्र आत्मा दाऊद राज़ेरी ज़िरिये पेइले ज़ोरी थी, पूरी भोनी ज़रूरी थी, तै गल यहूदारे बारे मां ज़ोरी थी, ज़ैनी यीशुएरे ट्लुवांने बालां केरि मद्दत कियोरी थी। ");
INSERT INTO bhd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","तै असन सेइं साथी सेवा केरनेबालो थियो, ते असन साथी तै गनो गातो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","तैनी नीच़ कमैयरे लेइ यीशु ट्लुवाव, ते फिरी तैनी तैना पेइंसे यहूदी लीडरन वापस दित्ते, ते तैनेईं तैन पेइंसां केरू अक ऊडार घिन्नू, ज़ैड़ी तै दोग्गेरे भारे खिरकोरो थियो, ते तैसेरू पेट फेटतां तैसेरी एंट्लोड़ी बेइर निस्सी।” ");
INSERT INTO bhd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","यरूशलेम नगरेरे सारे लोकन ए पतो लग्गोरो थियो, तैनेईं अपने भाषाई मां तैस उडारेरू नवं हकलदमा रख्खू, ज़ेसेरो मतलबे, “खूनेरू ऊडार।” ");
INSERT INTO bhd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","किजोकि दाऊदे भजना केरि किताबी मां लिखोरूए कि, “तैसेरू घर उज़ड़े, ते तैस मां कोई बसने बालो न भोए, ते इन भी लिखोरूए, तैसेरी पदवी कोई होरो ने।” ");
INSERT INTO bhd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","एल्हेरेलेइ एन ज़रूरीए कि अक एरो मैन्हु च़ुनो गाए, ज़ै प्रभु यीशुएरे सारे कम्मां केरे गवाह भोए, यानी यीशुएरो यूहन्ना करां बपतिस्मो नेने करां लेइतां असन करां यीशुएरे स्वर्गे गाने तगर ");
INSERT INTO bhd_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","तैन मरां अक मैन्हु च़ुनो गाए, ज़ै असन सेइं साथी यीशुएरे ज़ींते भोनेरो गवाह भोए। ");
INSERT INTO bhd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","तैखन तैनेईं दुइये ज़ने नामज़द किये, अक यूसुफ ज़ैस जो बरसब्बास ज़ोते थिये, ज़ेसेरो खताब यूस्तुस थियो, ते दुइयोवं मत्तियाह थियो। ");
INSERT INTO bhd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ते एन ज़ोइतां प्रार्थना की, “हे प्रभु, तू सेब्भी केरे दिले ज़ानतस ते असन पुड़ बांदू केर, कि इन दुईन मां तीं कौन ज़ेरो च़ुनोरोए। ");
INSERT INTO bhd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","कि तै इस सेवकाई ते प्रेरिताइयोरो पद ने, ज़ै यहूदा शैरतां अपने ठैरी जेवरोए।” ");
INSERT INTO bhd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","तैनेईं तैसेरे बारे मां शर्त रखेरू थियूं, ज़ैन मत्तियाह नंव्वे पुड़ निस्सू, एल्हेरेलेइ तै 12 प्रेरितन सेइं साथी गनो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ज़ेइस यहूदी केरे पिन्तेकुस्त तिहारेरी दिहाड़ी अई, त तैना सब एक्की ठैरी अकोट्ठे थिये। ");
INSERT INTO bhd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","अचानक अम्बरेरां आवाज़ आई, ज़ेन्च़रे बड़ो बात च़लने लोगोरो थियो, ते तैस सेइं सारू घर घुमने लगू ज़ैड़ी तैना बिश्शोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ते तैनेईं अगारी लप्परी ज़ेरि ज़िभां लेई, ज़ैना अलग-अलग भोइतां तैन सेब्भन पुड़ एइतां टिकी। ");
INSERT INTO bhd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ते तैना सब पवित्र आत्माई सेइं भरपूर भोए, ते आत्मारे वरदाने सेइं तैना अलग-अलग भाषा केरने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","तैस वक्ते मां, बड़े यहूदी भक्त ज़ैना तिहारे मां दुनियारी सैरी मुलखन मरां ओरे थिये, तैना यरूशलेम नगरे मां राने लोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ज़ैखन तैनेईं ए बातेरी ज़ेरि आवाज़ शुनी त बड़े लोक जम्हां भोए, ते सब लोक बड़े हैरान रेइजे, किजोकि हर कोई चेलन अपने-अपने भाषाई मां गल्लां केरते शुन्ने लोरे थियो। ");
INSERT INTO bhd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ते सब बड़े हैरान भोइतां ज़ोने लगे, हेरा, “कुन एना ज़ोनेबाले सारे गलील इलाकेरे रानेबाले नईं? ");
INSERT INTO bhd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","फिरी एन कुन भोइ रावरूए कि, असन मरां हर कोई अपनि-अपनि भाषा शुन्ने लोरोए। ");
INSERT INTO bhd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","असन मरां किछ इन इलाकन मरां आन, पारथी, मेदी, एलामी ते मेसोपोटामिया, यहूदिया, कप्पदूकिया, पुन्तुस ते आसिया, ");
INSERT INTO bhd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फ्रूगिया, पंफूलिया, मिस्र मुलख, ते लीबिया मुलखे ज़ै कुरेन नगरेरे नेड़े, इन सब मुलखां केरे रानेबाले ते रोमी मुसाफर, ");
INSERT INTO bhd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","कुन यहूदी, ते कुन यहूदी पंथ धारण केरनेबाले, क्रेती ते अरब मुल्खेरे लोक भी आन, पन अस अपनि-अपनि भाषाई मां तैन करां परमेशरेरां बड्डां-बड्डां कम्मां केरि चर्चा शुन्ने लोरेम।” ");
INSERT INTO bhd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","तैना सब बड़े हैरान भोइ जे ते घबरेइतां एक्की होरि पुच्छ़ने लगे, “कि एन कुन भोइ रावरूए?” ");
INSERT INTO bhd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","पन किछ तैन केरि हासी बनेइतां ज़ोने लगे, “कि एनेईं सज़री शराप पियोरीए।” ");
INSERT INTO bhd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","तैखन पतरस 11 प्रेरितन सेइं साथी खड़ो भोव, ते बड़े ज़ोरे सेइं ज़ोने लगो, “हे लोकव हे यहूदियारे रानेबालव ते हे यरूशलेम नगरेरे राने बालाव, मेरी गल ध्याने सेइं शुना, अवं तुसन ज़ोताईं इड़ी एन कुन भोने लोरूए। ");
INSERT INTO bhd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ज़ैन तुस बुझ़ने लोरेथ तैन नईं, एना मैन्हु नशे मां नईं, किजोकि हुन्ना त झ़ेझ़ेरे नौ बज़ोरेन, ");
INSERT INTO bhd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","बल्के ए तै गल्ले, ज़ै परमेशरे योएल नेबेरे ज़िरिये ज़ोरी थी, ");
INSERT INTO bhd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","परमेशर ज़ोते कि, आखरी दिहैड़न मां एरू भोलू, अवं अपनि आत्मा सेब्भी लोकन देइलो, ते तुश्शां मट्ठां कुइयां भविष्यिवाणी केरेलां, ते तुश्शे नौजवान दर्शन हेरेले, ते बुढ़े सुपना हेरेले। ");
INSERT INTO bhd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","बल्के अवं तैन दिहैड़न मां अपने सेवादार मड़दन ते सेवादार कुआन्शन पुड़ अपनि आत्मा उतरेलो, ते तैना भविष्यिवाणी केरेले। ");
INSERT INTO bhd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","अवं अम्बरे मां आजीब-आजीब कम्मां ते ज़मीनी पुड़ निशान, यानी अग, खून ते कालो तूएरी बिदलार हिरेयेलो। ");
INSERT INTO bhd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","प्रभुएरी दिहाड़ी एजने करां पेइले, दिहाड़ो आंधरो भोइ गानोए, ते चाँदनी खूनेरी ज़ेरि भोनीए, तै अक महान ते खास दिहाड़ी भोनीए। ");
INSERT INTO bhd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ते ज़ै कोई परमेशरेरू नवं घिन्नेलो तैस मुक्ति मैलेली।” ");
INSERT INTO bhd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“हे इस्राएलेरे लोकव, इना गल्लां शुना, यीशु नासरत नगरेरो अक मैन्हु थियो, ज़ै परमेशर तुश्शे लेइ भेज़ोरो थियो, ते एस गल्लारी तसदीक तैसेरे खास चमत्कारां केरे सबूतेईं सेइं भोचे, ज़ैना परमेशरे तैसेरे ज़िरिये सेइं इश्शे सामने हिरां, ज़ेन्च़रे कि तुस एप्पू भी ज़ानतथ। ");
INSERT INTO bhd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ज़ैखन तै परमेशरेरे इंतज़ामेरे पूरे मौके पुड़ ज्ञानेरे हिसाबे सेइं ट्लुवाव, ते तुसेईं तै अधर्मी लोकां केरे हथ्थे क्रूसे पुड़ टंगेइतां माराव। ");
INSERT INTO bhd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","पन परमेशरे तै मौतरे सकेंजे मरां छुटेइतां ज़ींतो कियो, किजोकि एन भोइ न थियूं सकतु, कि तै मौतरे कब्ज़े मां राए। ");
INSERT INTO bhd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","किजोकि दाऊद मसीहेरे बारे मां एन ज़ोते, हेरा, प्रभु हर वक्त मेरे सामने, अवं तैन लोकन करां न डरेलो ज़ैना मेरो नुकसान चातन। ");
INSERT INTO bhd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","तांए मेरो दिल बड़ो खुश भोव, ते अवं खुशी सेइं ज़ोइलो, बल्के मेरी जान उमीदी सेइं ज़ीएली। ");
INSERT INTO bhd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","किजोकि तू मेरे प्राणन पाताले मां राने न देलो, ते न अपने पवित्र मैन्हु शड़ने देलो! ");
INSERT INTO bhd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","तीं मीं ज़िन्दगरी बत हेरेवरिए, तू अपने हज़ूरी सेइं मीं भरपूर केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“हे मेरे ढ्लाव, अवं कौमारे बुज़ुर्ग दाऊदेरे बारे मां तुसन सेइं साफ-साफ ज़ोई सकताईं, कि तै मेरि भी जेव, ते दब्बो भी ते तैसेरी कब्र अज़ तगर इश्शे सामने मौजूद। ");
INSERT INTO bhd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","तै नबी थियो, ते तै ज़ानतो थियो, कि परमेशरे तैस सेइं वादो कियोरो थियो, ‘अवं तेरी खानदेंनी मरां अक मैन्हु तैसेरे तखते पुड़ बिशैलेलो।’ ");
INSERT INTO bhd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","तैनी पेइले भोनेबैली गल्लां ते मसीहेरे मुड़दन मरां ज़ींते भोनेरे बारे मां बियांन कियेरू थियूं, कि न तै पाताले मां राने देलो, ते न अपने पवित्र मैन्हु शड़ने देलो! ");
INSERT INTO bhd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“एहे यीशु परमेशरे ज़ींतो कियो ज़ेसेरे अस सब गवाह आम। ");
INSERT INTO bhd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ते हुना तै स्वर्गे मां खास ठैरी यानी परमेशरेरे देइने पासे आए। ते तैने बाजी परमेशरे करां पवित्र आत्मा हासिल की, ज़ेसेरो तैने वादो कियोरो थियो, यीशुए असन पवित्र आत्मा भरपूरी सेइं दित्तोरीए, ज़ैन तुस लातथ ते शुन्तथ। ");
INSERT INTO bhd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","किजोकि दाऊद त एप्पू स्वर्गे मां नईं जोरो, पन फिर भी तै एप्पू ज़ोते, प्रभु परमेशरे मेरे प्रभु सेइं ज़ोवं, मीं सेइं साथी राज़ केर। ");
INSERT INTO bhd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ज़ांतगर अवं तेरे दुश्मन तेरे अधीन न केरि। ");
INSERT INTO bhd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","एल्हेरेलेइ, इस्राएलेरे सारे लोकन पतो लग्गे, कि परमेशरे, यीशु ज़ै तुसेईं क्रूसे पुड़ च़ाढ़ो तै प्रभु भी कियो ते मसीह भी कियो।” ");
INSERT INTO bhd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","एना गल्लां शुन्तां तैन बड़ो एसास भोव कि तैना पापिन, तैखन तैनेईं पतरसे ते होरि प्रेरितन सेइं ज़ोवं, “हे ढ्लाव अस कुन केरम?” ");
INSERT INTO bhd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पतरसे तैन सेइं ज़ोवं, “पापन करां मनफिराथ ते तुसन मरां सारे यीशु मसीहेरे नंव्वे सेइं बपतिस्मो घिन्ना, त परमेशर तुसन माफ़ केरेलो ते पवित्र आत्मा तुसन इनामे मां मैलेली। ");
INSERT INTO bhd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","एल्हेरेलेइ कि ए वादो तुसन त तुश्शी औलादी सेइं आए ते तैन सेब्भन सेइं ज़ैना दूर-दूर रातन, ते ज़ैन इश्शो प्रभु परमेशरे एप्पू कां कुजाते।” ");
INSERT INTO bhd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पतरसे होरि भी बेड़ि गल्लां केरि गवाही दित्ती, ते तैन बार-बार ज़ोवं, कि अपनो आप एस टैरी कौमी करां बच़ाथ। ");
INSERT INTO bhd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ते तैनेईं तैसेरी गल्लां कबूल की, तैनी तैन बपतिस्मो दित्तो, तैस दिहैड़ी लगभग कोई 3000 मैन्हु तैन मां शामिल भोए। ");
INSERT INTO bhd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","एना लोक प्रेरितन करां शिक्षा हासिल केरते थिये, ते संगती रखते थिये, ते साथी रोट्टी खाते थिये, ते प्रभु भोज मनाते थिये ते प्रार्थना केरने मां मघन रहते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","प्रेरितां केरे ज़िरिये सेइं बड़े चमत्कार ते निशान भोते थिये, ते यरूशलेमेरे सारे लोक डेरि जे। ");
INSERT INTO bhd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","यीशु मसीह पुड़ विश्वास केरनेबाले सारे अकोट्ठे रहते थिये, ते सैरी चीज़न मां एक्की होरि बराबर हिस्सेदार रखते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ते तैना अपनि जेइदात ते माल सबाब बेच़तां एक्की होरेरी ज़ुरूरतरे मुताबिक रकम बेंटतां सेब्भी केरि ज़रूरत पूरी केरते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","तैना रोज़ अक मन भोइतां मन्दरे मां अकोट्ठे भोते थिये, ते घरन मां साथी रोट्टी खाते थिये ते प्रभु भोज मनाते थिये, ते अकोट्ठे भोइतां खुशी सेइं खाते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","तैना परमेशरेरी तारीफ़ केरते थिये, तैना सैरी केरि नज़री मां रोड़े थिये। ज़ैन पापन करां मुक्ति मैलती थी, परमेशर तैन लोकन तैन केरि टोली मां शामिल केरतो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","एक्की दिहाड़े पतरस ते यूहन्ना प्रार्थना केरने दीसेरे ट्लेइ बज़ेइं मन्दरे मांजो च़लोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ते मैनेईं अक ज़र्मनेरो टोंटो छ़ुइतां आनोरोए थियो, ते तैस मन्दरेरे दारे पुड़ छ़डते थिये, ज़ैस दारेरु नवं “रोड़ू” थियूं, ताके अन्तर गाने बालन करां भीख मग्गे। ");
INSERT INTO bhd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ज़ैखन तैनी पतरस ते यूहन्ना मन्दरे मांजो गांते लाए त तैन करां भीख मगने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","पतरस ते यूहन्ना तैसेरे पासे खेड़ोइतां ज़ोने लगे, “इश्शे पासे तक।” ");
INSERT INTO bhd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ते तैस उमीद भोइजेइ कि एन करां किछ मैलेलू, तै तैन केरे पासे तकने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","पतरसे ज़ोवं, “सोन्नू चाँदी त असन कां अथ्थी नईं, पन ज़ैन मीं कां आए तैन अवं तीं देताईं, तू यीशु मसीह नैसरेरे नंव्वे सेइं खड़ो उठ ते च़ल फिर।” ");
INSERT INTO bhd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","पतरसे ज़ेरो तैसेरो देइनो हथ ट्लेइतां खड़ो कियो, त तैसेरे पावन मां ते गुडन मां ताकत आई। ");
INSERT INTO bhd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ते तै तैखने खड़ो भोव, ते च़लने फिरने लगो, ते फिरी छालां मारतो ते परमेशरेरी तारीफ़ केरतो तैन सेइं साथी मन्दरेरे अंगने मां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ते सेब्भी लोकेईं तै च़लतो फिरतो ते परमेशरेरी तारीफ़ केरतो लाव। ");
INSERT INTO bhd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ते पिशानो ई त तैए, ज़ै मन्दरेरे रोड़े दारे पुड़ बिश्तां भीख मगतो थियो, ते ज़ै चमत्कार एन लोकां केरे सामने भोव, त तैना लोक बड़े हैरान राए। ");
INSERT INTO bhd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ज़ैखन तै मैन्हु पतरस ते यूहन्ना ट्लेइतां खड़खड़ो थियो, त सब लोक ज़ैना तैड़ी खड़खड़े थिये, बड़े हैरान भोइतां सुलैमानी अंगने मां देवड़तां तैन कां आए। ");
INSERT INTO bhd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","पतरसे एन हेरू त तै लोकन कां एन्च़रे खड़ो भोव, ते ज़ोने लगो, “हे इस्राएली लोकव तुस एस गल्ली पुड़ किजो हैरान भोरेथ, ते असन एन्च़रे किजो तकने लोरेथ, असेईं अपने शक्ति या भक्ति सेइं ए टोंटो मैन्हु च़लने फिरनेरे काबल नईं बनेवरोए। ");
INSERT INTO bhd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहम ते इसहाक ते याकूबेरे परमेशरे ते इश्शे पूर्वजां केरे परमेशर अपने दासे यीशु महिमा दित्ती, पन तुसेईं तै यहूदी लीडरन कां दित्तो कि तैना तैस मारन। पिलातुसे तै हथरां छ़डनेरो इरादो कियो, पन तुसेईं यीशुएरो इन्कार कियो। ");
INSERT INTO bhd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","तुसेईं यीशु अक एरो पवित्र ते धर्मी मैन्हु रद कियो, ते पिलातुसे कां दरखुवास की, कि तै तुश्शे लेइ अक कातली हथरां छ़डे। ");
INSERT INTO bhd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","तुसेईं त ज़िन्दगी देनेबालो मारो, पन अस गवाह आम, कि परमेशरे तै मुड़दन मरां ज़ींतो कियो। ");
INSERT INTO bhd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","तैसेरे नव्वेंरी शक्ति एस टोंटे, ज़ै तुश्शे सामने ते ज़ैस तुस ज़ानतथ शिफा दित्तोरिये ते ए मैन्हु यीशुएरे नंव्वे सेइं ते यीशु पुड़ विश्वास केरने सेइं बिलकुल ठीक भोव, ते ए एप्पू तुश्शे सामने। ");
INSERT INTO bhd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“हे मेरे ढ्लाव अवं ज़ानताईं कि ज़ैन किछ तुसेईं ते तुश्शे लीडरेईं यीशु सेइं कियूं, तैन तुसेईं अनज़ान भोइतां कियूं। किजोकि तुसन न थियो पतो कि तै मसीह आए। ");
INSERT INTO bhd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","पन परमेशरे एना सैरी गल्लां ज़ैना तैनी अपने नेबी केरे ज़िरिये ज़ोरी थी, कि मसीह दुःख ऊठालो ते मरेलो ते तैनी तैना एन्च़रे पूरी की। ");
INSERT INTO bhd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","बस्सा पापन करां मनफिराथ ते परमेशरेरे पासे फिरा ते तै तुश्शे पाप माफ़ केरेलो, ते परमेशरेरी तरफां तुश्शे लेइ परमेशरे तरफां रोड़े दिहाड़े एज्जेले। ");
INSERT INTO bhd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ते तै मसीह यानी यीशु ज़ै तैनी ठहरावरो आए, तुश्शे लेइ भेज़े। ");
INSERT INTO bhd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","पन ज़ांतगर तैना सैरी चीज़ां बहाल न केरे, ज़ैन केरे बारे मां परमेशरे बड़े पेइले अपने पवित्र नेबी केरि ज़बानी ज़ोरूए, तांतगर यीशुएरू स्वर्गे मां रानू ज़रूरीए। ");
INSERT INTO bhd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ज़ेन्च़रे मूसा एस बारे मां ज़ोरू थियूं, प्रभु परमेशर तुश्शे ढ्लान मरां तुश्शे लेइ मेरो ज़ेरो अक नबी भेज़ेलो, ज़ैन किछ तै तुसन सेइं ज़ोए, तुस तैसेरी गल शुनथ। ");
INSERT INTO bhd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","पन ज़ै तैस नेबेरी गल न शुनेलो, तै लोकन मरां नाश कियो गालो। ");
INSERT INTO bhd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ते शमूएल परमेशरेरी गल्लां ज़ोनेबाले करां देइतां पेइले तमाम नेबेईं इन दिहाड़ां केरे बारे मां शुनावरू। ");
INSERT INTO bhd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","तुस नेबी केरि खानदेंनी ते ज़ै करार परमेशरे इश्शे पूर्वजन सेइं कियोरो थियो, तैस मां तुस सब शामलथ, परमेशरे अब्राहमे सेइं ज़ोरू थियूं, कि तेरे मट्ठेरे ज़िरिये सेइं दुनियारी तमाम कौमन बरकत मैलेली। ");
INSERT INTO bhd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","परमेशरे अपनो सेवक मुड़दन मरां ज़ींतो कियो ते पेइलो तुसन कां भेज़ो, ताके तुसन तै बरकत दे, कि तुसन मरां हर कोई पापेरी ज़िन्दगी शैरतां परमेशरेरे पासे फिरे।” ");
INSERT INTO bhd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","हेजू पतरस ते यूहन्ना लोकन सेइं गल्लां केरते थिये, त किछ याजक ते मन्दरेरे पेरहेदार ते किछ सदूकी लोक तैड़ी पुज़े। ");
INSERT INTO bhd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","तैना बड़े सेरकोए, कि पतरस ते यूहन्ना लोकन एरी शिक्षा देते कि परमेशरे मर्रे लोकन ज़ींतो केरेलो, ज़ेन्च़रे तैनी यीशु मुड़दन मरां ज़ींतो कियोरोए। ");
INSERT INTO bhd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","तैनेईं तैना दुइयोवं दिहैड़ी तगर गिरफ्तार रख्खे, किजोकि तै ड्लोझ़ारो मौको थियो। ");
INSERT INTO bhd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","पन केही लोकेईं वचन शुन्तां यीशु पुड़ विश्वास कियो, ते तैन केरि तैधात 5000 मड़द भोइ। ");
INSERT INTO bhd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","होरसां एरू भोवं कि तैन केरे लीडर ते बुज़ुर्ग ते शास्त्री यरूशलेम नगरे मां जम्हां भोए। ");
INSERT INTO bhd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","हन्ना महायाजक तैड़ी थियो, ते कैफा ते यूहन्ना महायाजक ते सिकन्दर ते खानदेंनरे होरे लोक भी तैड़ी थिये। ");
INSERT INTO bhd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","तैनेईं पतरस ते यूहन्ना मझ़ाटे खड़े किये ते तैन पुच़्छ़ू, “तुसेईं केसेरे शेक्ति या केसेरे अधिकारे सेइं एन कम कियोरूए?” ");
INSERT INTO bhd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","तैखन पतरस पवित्र आत्माई सेइं भरपूर भोइतां तैन एन्च़रे सेइं ज़ोने लगो, “हे कौमरे लीडराव ते बुज़ुर्गव। ");
INSERT INTO bhd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","अगर अज़ असन एल्हेरेलेइ पूछ ताछ की गातीए, कि असां एक्की रोड़े कम्मेरो जुवाब देम, ज़ैन असेईं एक्की टोंटे मैनेरे लेइ कमाव ते तैस शिफ़ा दित्ती। ");
INSERT INTO bhd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ते तुसन ते सारे इस्राएलिन ए पतो लग्गे, कि ए मैन्हु यीशु मसीह नैसरेरे नव्वेंरी शक्ति सेइं बेज़्झ़ोइतां तुश्शे सामने खड़ोए, ज़ै यीशु तुसेईं क्रूसे पुड़ च़ाढ़ोरो थियो, पन परमेशरे तै मुड़दन मरां ज़ींतो कियोरोए। ");
INSERT INTO bhd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ए तैए घोड़े, ज़ै तुसेईं मिस्त्रेईं रद्दी कियोरो थियो, पन तैए घोड़ कूनेरो खास घोड़ भोइ जेव। ");
INSERT INTO bhd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ते पापां केरि माफ़ी केन्ची होरेरे ज़िरिये सेइं नईं, किजोकि अम्बरेरां बुन मैनन् मां कोई होरू दुइयोवं नवं नईं दित्तेरू, ज़ेसेरे ज़िरिये सेइं मुक्ति मैल्ले, सिर्फ यीशुएरे नंव्वे सेइं मुक्ति आए।” ");
INSERT INTO bhd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ज़ैखन तैनेईं पतरस ते यूहन्नारी दिलेरी हेरी, त तैखन तैन पतो लगो, कि एना त अनपड़ ते मामुली मैन्हु आन ते तैना बड़े हैरान भोए, तैखन तैनेईं बुझ़ू कि एना लोक यीशु सेइं साथी राहोरेन। ");
INSERT INTO bhd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","तैनेईं पतरस ते यूहन्नारे खलाफ किछ न ज़ोई बटु, एल्हेरेलेइ कि ज़ै मैन्हु बेज़्झ़ोरो थियो, तै मैन्हु तैन सेइं साथी खड़खड़ो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","तैखन तैनेईं पतरस ते यूहन्ना महासभा करां बेइर नेनेरे लेइ ज़ोवं, ते एप्पू मांमेइं मुशोरो केरने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“असां एन लोकन सेइं कुन केरम? यरूशलेम नगरेरे सब लोक ज़ानतन कि एन लोकेईं अक बड़ो चमत्कार कियोरोए, ज़ेसेरो अस इन्कार न केरि बटम। ");
INSERT INTO bhd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","पन एल्हेरेलेइ अस एन न चाम कि ए गल लोकन मां जादे मुशूर न भोए, रोड़ू त एन्ने कि अस एन धमकेइतां ज़ोम कि अज़ेरे बाद एन नवं घिन्तां केन्ची सेइं गल न केरन।” ");
INSERT INTO bhd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","तैखन तैनेईं पतरस ते यूहन्ना अन्तर कुजेइतां हदैयत दित्ती, “यीशुएरू नवं घिन्तां केन्ची सेइं गल न केरथ, ते न शिक्षा देइयथ।” ");
INSERT INTO bhd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","पन पतरस ते यूहन्ना तैन जुवाब दित्तो, “तुस एप्पू ए फैसलो केरा, कि कुन ए गल परमेशरेरी नज़री मां ठीके, फिरी अस तुश्शी गल मन्नम कि परमेशरेरी? ");
INSERT INTO bhd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","किजोकि एन नईं कि ज़ैन किछ असेईं शुनू ते लाहू, ते तैसेरे बारे मां ज़ोतम।” ");
INSERT INTO bhd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","तैखन तैनेईं पतरस ते यूहन्ना धमकेइतां हथरां छ़डे, द्रासले मां तैना फैसलो न केरि सके, कि एन सज़ा त देम पन केन्च़रे देम, किजोकि तमाम लोक ए चमत्कार हेरतां परमेशरेरी महिमा केरते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","किजोकि ज़ैस मैन्हु पुड़ शिफ़ा देनेरो चमत्कार हिरावरो थियो, तै 40 सालन करां जादे उमरारो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","पतरस ते यूहन्ना तैट्ठां छुट्नेरां बाद अपने लोकन कां च़ले जे, ते ज़ैन किछ प्रधान याजक ते बुज़ुर्गेईं तैन ज़ोरू थियूं, तैन सेइं शुनावं। ");
INSERT INTO bhd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ज़ैखन तैनेईं एना गल्लां शुनी त अक भोइतां बड़े ज़ोरे सेइं परमेशरे कां प्रार्थना केरने लगे, तीं धरती त कने अम्बर ते समुन्द्रे ते ज़ैन किछ एसमां आए बनोरूए। ");
INSERT INTO bhd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","तीं पवित्र आत्मारे ज़िरिये सेइं अपने सेवक इश्शे पूर्वज दाऊदेरी ज़िरिये ज़ोरू थियूं, “‘कि कौमेईं किजो हैल्लो मच़ाव? ते मुलखां-मुलखां केरे लोक किजो बेफैइदे खियाल केरतन? ");
INSERT INTO bhd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ज़मीनरे राज़े, प्रभु ते तैसेरे मसीहेरे खलाफ खड़े भोए ते हाकिम साथी खड़े भोए।’ ");
INSERT INTO bhd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“एन सच़्च़े कि हेरोदेस पुन्तियुस ते पिलातुस भी गैर यहूदी ते सब इस्राएली लोकन सेइं साथी तेरे पवित्र सेवक यीशुएरे खलाफ नगर-नगरे मां खड़े भोए, ज़ै तीं मसीह ठहरावरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","तैना एल्हेरेलेइ अकोट्ठे भोरे थिये कि ज़ैन किछ तू अपनि कुदरतारो इरादेरे मुताबिक पेइले तैनी ठहरावरू थियूं, तैस पुड़ अमल केरम। ");
INSERT INTO bhd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","हुनी हे प्रभु, तैन केरि धेमकी शुन, ते अपने दासन इन वरदान दे, कि तेरू बच्चन बेड़ि दिलेरी सेइं लोकन शुनेई बटम। ");
INSERT INTO bhd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","अपनो हथ अग्रोवं रख, ते अपने पवित्र सेवक यीशुएरे नंव्वे सेइं शिफ़ा दे, ते चमत्कार ते निशान हिरा।” ");
INSERT INTO bhd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ते ज़ैखन तैनेईं प्रार्थना की, त ज़ैस ठैरी तैना अकोट्ठे जम्हां थिये, त तै ठार हिल्ली, ते तैना सब पवित्र आत्माई सेइं भेरोए, ते परमेशरेरू बच्चन बेड़ि दिलेरी सेइं शुनाने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","विश्वास केरनेबालां केरि मण्डली अक मन ते अक जान थी, कोई भी एरो न थियो ज़ै अपनो माल अपनो समझ़तो भोए, बल्के होरन भी सैरी चीज़न मां शामल रखते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ते प्रेरित बेड़ि शेक्ति सेइं प्रभु यीशुएरे मुड़दन मरां ज़ींते भोनेरी गवाही देते थिये, ते तैन पुड़ परमेशरेरो बड़ो अनुग्रह थियो। ");
INSERT INTO bhd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","तैन मरां कोई भी गरीब न थियो, किजोकि ज़मीना केरे त घरां केरे मालिक तैन बेच़तां तैन केरि कीमत प्रेरितन कां आनते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ते तैना तै रकम प्रेरितन देते थिये, ते हर केन्ची तैसेरी ज़ुरुरतारे मुताबिक बेंटतां देते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","यूसुफ नंव्वेरो अक लेवी थियो, ज़ै साइप्रसेरो रानेबालो थियो, ते प्रेरितेईं तैसेरू नवं बरनबास रखेरू थियूं, (ज़ेसेरो मतलबे शैनतरु मट्ठू)। ");
INSERT INTO bhd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","तैनी अपनू ऊडार बेच़ू, ते कीमत एन्तां प्रेरितन दित्ती। ");
INSERT INTO bhd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हनन्याह नव्वेंरो अक मैन्हु थियो, ते तैसेरी कुआन्शरू नवं सफीरा थियूं ते तैनेईं अपनि जेईदातरो किछ हिस्सो बेच़ी छ़ड्डो। ");
INSERT INTO bhd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ते कीमती मरां किछ पेंइसे एप्पू कां रखे, ज़ेसेरो तैसेरी कुआन्शी भी पतो थियो, ते बाकी होरे पेंइसे एन्तां प्रेरितन दित्ते। ");
INSERT INTO bhd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","पन पतरसे तैस सेइं ज़ोवं, “हे हनन्याह! शैताने तेरे मने मां ए गल केन्च़रे छ़डी, कि तू पवित्र आत्माई सेइं झूठ ज़ोस, ते ज़मीनारे पेंइसन मरां किछ रेख्खी छ़डस? ");
INSERT INTO bhd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","कुन बेच़ने करां पेइले ज़मीन तेरी न थी, पन बेच़नेरां बाद कुन पेंइसो तेरो न भोव? तीं अपने मने मां किजो सोचू? तीं मैन्हु सेइं नईं बल्के परमेशरे सेइं झूठ ज़ोरूए।” ");
INSERT INTO bhd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","हनन्याह एन शुनते खिरकी जेव, ते तैसेरे प्राण निस्से, ते ज़ैन लोकेईं एन शुनू त तैना बड़े डेरि जे। ");
INSERT INTO bhd_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","तैखन किछ नौजवान आए ते तैनेईं तैसेरी लाश कफने मां पलेटतां ते बेइरोवं नेइतां देबतां छ़डी। ");
INSERT INTO bhd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ट्लेइ घैन्टना पत्ती तैसेरी कुआन्श आई, ते तैस एस बारे मां कोई पतो न थियो। ");
INSERT INTO bhd_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","पतरसे तैस पुच़्छ़ू, “मीं ज़ो, कुन तुसेईं दुइयेईं ज़मीन एत्रे मां बेच़ोरी थी?” तैसां ज़ोवं, “हाँ कुल कीमत एत्री मैल्लोरी थी।” ");
INSERT INTO bhd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","पतरसे तैस सेइं ज़ोवं, “प्रभुएरी आत्मा अज़मानेरे लेइ तुस केन्च़रे सेइं राज़ी भोए, ते ज़ैन लोकेईं तेरो मुन्श दबोरोए, तैन केरे पाव हेर दारे पुड़ आन, ते तैना तीं भी बेइरोवं घिंनी गाले।” ");
INSERT INTO bhd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","तै कुआन्श तैखने तल्ले बिछ़ड़ी, ते तैसारे भी प्राण निस्से, ते ज़ैखन नौजवान अन्तर आए त तै कुआन्श मर्री लेइतां तै भी छ़ुइतां तैसारे मुन्शे ड्लाखोरां देबतां छ़डी। ");
INSERT INTO bhd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","सैरी यरूशलेमेरी कलीसिया ते एन गल्लां केरे शुन्ने बाले बड़े डेरि जे। ");
INSERT INTO bhd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","प्रेरितां केरे ज़िरिये बड़े चमत्कार ते निशान बांदे भोए, ते सारे विश्वासी अक भोइतां सुलैमानी अंगने मां जम्हां भोते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","हालांकी होरे लोक तैन केरि बड़ी इज़्ज़त केरते थिये, पन केन्ची हिम्मत न आई कि तैन मां शामिल भोन। ");
INSERT INTO bhd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","बड़े मड़देइं ते कुआन्शेईं विश्वास कियो ते तैन लोकां केरि मेनडली मां शामिल भोए, ते परमेशर मन्ने बालां केरि तैधात बद्धती च़ली। ");
INSERT INTO bhd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ज़ैन प्रेरितेईं कियूं तैसेरो नितीजो ई भोव, कि लोक बिमारन खट्टन पुड़ ते पिट्ठी पुड़ छ़ुइतां सड़की मां रखते थिये, कि पतरस ज़ैखन तैस बत्तां एज्जे त तैसेरी छाव त तैन पुड़ पे। ");
INSERT INTO bhd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","यरूशलेम नगरेरे च़ेव्रे पासना ड्लोंवां केरे बड़े लोक बिमारन ते ज़ैन पुड़ भूतां केरो सैयो, एप्पू सेइं साथी आनते थिये, ते तैना सब बेज़्झ़ोते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","तैखन महायाजक ते तैसेरे साथी ज़ैना सदूकी केरे फिरके मरां थिये, तैन बड़ी जलन भोने लगी ते तैना प्रेरितां केरे खलाफ खड़े भोए। ");
INSERT INTO bhd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ते तैनेईं प्रेरित ट्लुवेइतां कैद मां छ़ेड्डी दित्ते। ");
INSERT INTO bhd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","पन प्रभुएरो राती स्वर्गदूत कैदखाने मां दार खोलतां प्रेरितन कां जेव, ते तैना बेइर केढतां तैन सेइं ज़ोने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“गाथ ते मन्दरेरे अंगने मां खड़े भोइतां हमेशारे ज़िन्दगरे बारे मां लोकन बिस्तार देथ।” ");
INSERT INTO bhd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","तैना एन शुन्तां झ़ेझ़ां मन्दरेरे अंगने मां पुज़े ते ज़ेन्च़रे तैन स्वर्गदूते हुक्म दित्तोरो थियो, तेन्च़रे लोकन शिक्षा देने लगे, ते ज़ैखन इस्राएली महायाजक ते तैसेरे साथी तैड़ी आए, त तैनेईं महासभा ते सब यहूदी केरे सारे बुज़ुर्ग कुजाए, ते तैनेईं यीशुएरे प्रेरित कैदखाने मरां कुजाए। ");
INSERT INTO bhd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ज़ैखन मन्दरेरे पेरहेदार कैदखाने मां पुज़े त तैन प्रेरित तैड़ी न मैल्ले, ते वापस एइतां तैन खबर दित्ती। ");
INSERT INTO bhd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“असेईं कैदखानो रोड़ेच़ारे बंद कियोरी थियो, ते पेरहेदार भी असन दारे मां खड़खड़े मैल्ले, पन ज़ैखन असेईं कैदखानो खोल्लो त अन्तर कोई न मैल्लो।” ");
INSERT INTO bhd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","एना गल्लां शुन्तां मन्दरेरे पहरेदारां केरो प्रधान, प्रधान याजक ते सारे लोक हैरान रेइजे, ते तैन केरि फिक्री मां पे कि हुनी कुन भोनूए! ");
INSERT INTO bhd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","तैखन केन्चे एइतां ज़ोवं, “तैना मैन्हु ज़ैना तुसेईं कैदे मां छ़डोरे थिये, तैना मन्दरे मां खड़े भोइतां शिक्षा देने लगोरेन।” ");
INSERT INTO bhd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","तैखन मन्दरेरे पहरेदारां केरे प्रधान अपने सिपाही साथी घिन्तां जे, ते प्रेरित कुजेइतां आने पन ज़बरदस्ती नईं, किजोकि तैना लोकन करां डरते थिये, कि एरू न भोए एना असन घोड़ेईं बान। ");
INSERT INTO bhd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","तैनेईं प्रेरित एन्तां महासभा मां पैश किये, ते महायाजके तैन पुच़्छ़ू। ");
INSERT INTO bhd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“असेईं तुसन ठाकेरू थियूं, कि यीशुएरू नवं घिन्तां शिक्षा न देइयथ? फिरी भी हेरा, तुसेईं सारे यरूशलेम नगरे मां अपनि शिक्षा फैलाई, ते तैस मैनेरो खूनेरो दोष असन पुड़ लानो चातथ।” ");
INSERT INTO bhd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","पतरस ते होरि प्रेरितेईं जुवाब दित्तो, “असन मैन्हु केरो हुक्म मन्नेरे बजाहे परमेशरेरो हुक्म मन्नो जादे ज़रूरीए। ");
INSERT INTO bhd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","इश्शे दादे-पड़दादां केरे परमेशरे ए यीशु मुड़दन मरां ज़ींतो कियो, ज़ै तुसेईं क्रूसे पुड़ च़ेढ़तां मारो। ");
INSERT INTO bhd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","तैए परमेशरे, प्रभु ते मुक्ति देनेबालो बनेइतां अपने देइने पासे बिशालो, ताके तै इस्राएलिन मन फिराने ते पापां केरि मैफारो मौको दे। ");
INSERT INTO bhd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","असां एन गल्लां केरे गवाह आम, ते पवित्र आत्मा भी, ज़ै परमेशरे तैनी अपनो हुक्म मन्ने बालन दित्तोरीए।” ");
INSERT INTO bhd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ज़ैखन तैनेईं एन शुनू त फुकोई जे, ते तैन केरि मर्ज़ी लगी ज़ोने कि एन मैरी छ़डम। ");
INSERT INTO bhd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","पन अक फरीसी मैन्हु ज़ेसेरू नवं गमलीएल थियूं, ते ज़ै शास्त्री भी थियो, ते ज़ै सेब्भी लोकन मां इज़्ज़तदार थियो, तैनी महासभा मां खड़े भोइतां हुक्म दित्तो कि एना मैन्हु थोड़े च़िरे बेइर भेज़ा। ");
INSERT INTO bhd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","तै एन ज़ोने लगो, “हे इस्राएली लोकव तुस ज़ैन किछ एन मैनन् सेइं केरनू चातथ तैन रोड़ेच़ारे सोचा। ");
INSERT INTO bhd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","किजोकि थोड़े च़िरे पेइले थियूदास इन ज़ोइतां खड़ो भोरो थियो, ते ज़ोतो थियो, अवं भी किछ आई, ते लगभग 400 मैन्हु तैस सेइं मिले, पन तै मारो जेव, ते तैसेरे मन्नेबाले सारे तितर-बितर भोइ जे, ते तैन केरो नामो निशान मिटी जेव। ");
INSERT INTO bhd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","तैसेरां पत्ती मैन्हु केरे गिनतरे वक्ते गलील इलाकेरो यहूदा निसोरो थियो, ते तैनी काई लोक अपने पासे खिचोरे थिये, तै भी मारो जेव, ते तैसेरे ज़ेत्रे साथी थिये, सब तितर-बितर भोइ जे। ");
INSERT INTO bhd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","हुनी अवं तुसन एन्ने ज़ोताईं कि एन मैनन् करां दूर भोथ, ते एन गाने देथ, किजोकि अगर एना चमत्कार, मैन्हु केरि तरफां भोले त एप्पू खतम भोइ गानेन। ");
INSERT INTO bhd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","पन अगर एना कम्मां परमेशरेरी तरफां भोलां, त तुस एन मैन्हु केरू किछ न बिगैड़ी सकत, ते तुस परमेशरेरे खलाफ लड़नेबाले भोले, तैनेईं तैसेरी सल्लाह मन्नी।” ");
INSERT INTO bhd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ते प्रेरित अन्तर कुजेइतां तैन डंडेइं बावैहीतां तैन ज़ोवं, कि अज़ेरां बाद यीशुएरे नंव्वे सेइं कोई गल न केरथ, ते तैना हथरां छ़डे। ");
INSERT INTO bhd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","प्रेरित महासभा मरां च़ले जे, तैना एस गल्ली पुड़ खुशी थिये, कि असां यीशुएरे नंव्वे सेइं बेइज़त भोनेरे काबल त भोए। ");
INSERT INTO bhd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","तैनेईं शिक्षा देनी बंद न की, बल्के रोज़ मन्दरे मां गेइतां ते घर-घर गेइतां लगातार खुशखबरी शुनाते राए कि यीशु ही मसीह आए। ");
INSERT INTO bhd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ई गल तेइसेरीए ज़ेइस चेले केरि गिनती बधने लगोरी थी, यूनानी भाषा ज़ोनेबालो यहूदी चेलेईं इब्रानी भाषा ज़ोनेबाले यहूदी चेलां केरि शकैइत केरने लगे, कि हर दिहैड़रे सेवाई मां विधवां केरि खबर न की गाए। ");
INSERT INTO bhd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","एन शुन्तां 12 प्रेरितेईं सारे यरूशलेमेरे सारे विश्वासी लोक (चेले) अकोट्ठे किये, ते ज़ोवं, “इश्शे लेइ एन मुनासब नईं कि अस परमेशरेरी वचनेरू प्रचार केरनो छ़ेडतां खाने पीनेरी सेवाई मां लग्गम ");
INSERT INTO bhd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","एल्हेरेलेइ हे मेरे ढ्लाव, अपने लोकन मरां सत भलमानस मैन्हु च़ुना, ज़ैना पवित्र आत्माई सेइं भरपूर ते अक्लमन्द भोन, ताके आस तैन एस कम्मेरी ज़िमेबारी सोंफम।” ");
INSERT INTO bhd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","पन अस त प्रार्थना केरने ते बच्चन शुनानेरी ते शिक्षा देनेरी सेवाई मां लग्गोरो रानेम। ");
INSERT INTO bhd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ए गल सारे लोकन पसंद आई, ते तैनेईं अक स्तिफनुस ज़ै विश्वास ते पवित्र आत्माई सेइं भरपूर थियो च़ुनो, ते होरे ज़ैना च़ुने तैन केरां नव्वां इना आन, फिलिप्पुस प्रुखुरुस, नीकानोर, तीमोन, परमिनास ते नीकुलाउस ज़ै अन्ताकिया नगरेरो रानेबालो थियो, ते यहूदी फिरके मां ओरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ते तैना प्रेरितन कां हाज़र किये, ते तैन केरे लेइ तैनेईं प्रार्थना की, ते तैन पुड़ हथ रख्खे। ");
INSERT INTO bhd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","एन्च़रे सेइं परमेशरेरू बच्चन फैलतु जेवं, ते यरूशलेम नगरे मां चेलां केरि गिनती बद्धती जेई, ते याजकां केरि अक टोली विश्वासे मां आई ते मसीही भोइजेइ। ");
INSERT INTO bhd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तिफनुस अनुग्रह ते शेक्ति सेइं भरपूर भोइतां लोकन चमत्कार ते निशान हिरातो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","आज़ाद भोरे यहूदी लोकां केरू अक प्रार्थना घर थियूं, कुरेनी ते सिकन्दरिया ते किलिकियारे ते आसियारे किछ लोकन मरां किछ स्तिफनुसे सेइं बेंस केरने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","तैना तैन गल्लां केरो जुवाब न देइ बटे, ज़ैना पवित्र आत्मा तैस ज़ोनेरी समझ़ दित्ती। ");
INSERT INTO bhd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","तैखन तैनेईं किछ लोक शिखाले, कि तुस झूठ ज़ोइयथ कि, “असेईं स्तिफनुस मूसेरे त कने परमेशरेरे खलाफ तुहीन केरते शुनोरोए।” ");
INSERT INTO bhd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","तैखन तैनेईं किछ लोक, बुज़ुर्ग ते शास्त्री स्तिफनुसेरां खलाफ बमकाए ते तै ट्लेइतां महासभा मां पैश कियो। ");
INSERT INTO bhd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","तैनेईं बड़े झूठे गवाह पैश किये, “ते तैनेईं गवाही दित्ती कि ए मैन्हु पवित्र ठारारे ते मूसेरे कानूनेरे खलाफ तुहीन केरने करां बाज़ न एज्जे। ");
INSERT INTO bhd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ते असेईं एस मैन्हु करां एन भी ज़ोतू शुनू, कि यीशु नासरी इस मन्दरे डोलेलो, ते तैना रसमां ज़ैना मूसा नेबे दित्तोरिन बदलेलो।” ");
INSERT INTO bhd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","तैखन लोक ज़ैना महासभा मां बिश्शोरे थी, तैसेरे पासे तक्कू कि तैसेरू तुतर स्वर्गदूतेरे ज़ेरू लेइहोतू थियूं। ");
INSERT INTO bhd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","तैखन महायाजके स्तिफनुसे सवाल पुछ़ो, “कुन एना इलज़ाम सच़्च़े आन?” ");
INSERT INTO bhd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","तैनी ज़ोवं, “हे ढ्लाव ते मेरे बुज़ुर्गाव, मेरी गल शुना, इश्शो पूर्वज अब्राहमे हारान नगरे मां बसने करां पेइलो मेसोपोटामिया इलाके मां थियो, ते महिमा बाले परमेशरे तैस दर्शन दित्तू ");
INSERT INTO bhd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ते परमेशरे तैस सेइं ज़ोवं, अपनो देश त अपने रिशतेदारन शैरतां तैस मुलखे मां गा, ज़ै अवं तीं हरेइलो। ");
INSERT INTO bhd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","तांए तै कसिदी केरे मुलखे शैरतां हाराने मां बसोरो थियो, तैसेरे बाजेरे मरनेरां पत्ती परमेशरे तै तैस मुलखे मां आनो ज़ैस मां अज़ तुस बसोरेथ। ");
INSERT INTO bhd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","पन परमेशरे तैस इड़ी किछ भी जेइदात न दित्ती, बल्के पाव रखने जो भी ज़मीन न दित्ती, पन वादो ज़रूर कियो कि ई ज़मीन अवं तीं ते तेरी औलादी कब्ज़े मां देलो हालांकी तेइस अब्राहमे कोई औलाद न थी। ");
INSERT INTO bhd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","परमेशरे इन भी ज़ोवं, तेरी औलाद एक्की बखले देशे मां परदेशी भोली, तैना तैन गुलाम बनाले, ते 400 सालन तगर तैन दुख देले। ");
INSERT INTO bhd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","फिरी परमेशरे ज़ोवं, ज़ै कौम तैन गुलाम बनाली तैन अवं सज़ा देइलो, ते तैसेरां बाद तैना तैस मुलखे मरां निस्सतां इड़ी एज्जेले ते मेरी आराधना केरेले। ");
INSERT INTO bhd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ते परमेशरे अब्राहमे सेइं करार कियो ते तैस सेइं ज़ोवं, कि निशानेरे रूपे मां सेब्भी घरानेरे नर मैन्हु केरो खतनो केर। ज़ैखन इसहाक ज़रमो ते अठे दिहैड़ी केरो भोव, त अब्राहमे तैसेरो खतनो कियो, ते एन्च़रे इसहाके अपने मट्ठे याकूबेरो खतनो कियो, ते याकूबेरे अपने 12 मट्ठां केरो खतनो कियो। ");
INSERT INTO bhd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","याकूबेरे मट्ठेईं जलनी सेइं अपनो ढ्ला यूसुफ मिस्र मुलखे जो गाने बालन जो बेच़ो, ते तैनेईं यूसुफ मिस्रे मां नेइतां गुलाम बनाव? पन परमेशर यूसुफे सेइं साथी थियो। ");
INSERT INTO bhd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","परमेशरे तै सैरी मुसीबतन करां छुटेइतां, ते तैस बड़ी अक्ल दित्ती, ते मिस्रेरे फ़िरौन राज़ेरे सामने बड़ी काबलीत दित्ती, ते फ़िरौन राज़े, यूसुफ मिस्र मुलखेरो ते अपने महलेरो गवर्नर बनावं। ");
INSERT INTO bhd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ज़ैस वक्ते यूसुफ थियो त मिस्र मुलख ते कनानारे सारे मुलखे मां काल पेव, ते बड़ी मुसीबत आई, ते इश्शे दादे-पड़दादन खाने जो अन न मैल्लू। ");
INSERT INTO bhd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ज़ैखन याकूबे शुनू कि मिस्रे मां अन्न आए, त तैनी इश्शे पूर्वज मिस्र मुलखे मां पेइली बार भेज़े, तैना यूसुफ सेइं मिले ते अन आनू पन तैनेईं तै न पिशानो। ");
INSERT INTO bhd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ज़ैखन तैना दुइयोवं फेरे मिस्र मुलखे मां अन्न आन्ने जे, त यूसुफे अपनो आप तैन पिशानाव, ते फ़िरौने भी यूसुफेरी कौमरो पतो लगो कि ए इब्रानी आए। ");
INSERT INTO bhd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","तैसेरां बाद यूसुफे अपनो बाजी याकूब ते तैसेरे 75 मैन्हु केरू टब्बर मिस्र मुलखां मांजो एजनेरो बिस्तार भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","किछ वक्तेरां बाद याकूब मिस्र मुलखे मां जेव, ते तै त इश्शे दादे-पड़दादे तैड़ी मेरि जे। ");
INSERT INTO bhd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","तैन केरि लाशां तैट्ठां इश्शे मुलख कनाने मां वापस एन्ही, ते तैनेईं याकूब, तैस ठैरी दफन कियो, ज़ै ठार अब्राहमे चाँदी देइतां घिन्नोरी थी, ते याकूबेरां मट्ठां शेकेम नगरेरे तैस ठैरी दफन कियां, ज़ै याकूबे हामोरेरी औलादी करां घिन्नोरी थी।” ");
INSERT INTO bhd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“परमेशरे अब्राहमे सेइं अक वादो कियोरो थियो, तैस वादेरो पूरो भोनेरो मौको अव त मिस्रे मां इश्शे लोकां केरि गिनती भी बड़ी बेद्धी जेई। ");
INSERT INTO bhd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","तैस मौके अक होरो राज़ो मिस्र देशे मां राज़ केरने लगो, ज़ै यूसुफे न थियो ज़ानतो। ");
INSERT INTO bhd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","तैनी इश्शी कौमी सेइं एरी च़लाकी कि ते इश्शे दादन-पड़दादन सेइं एरी बदसलूकी की, तैना एत्रे मजबूर किये कि तैना अपने ज़र्मते बच्चे बेइरोवं शारन ताके तैना मेरि गान। ");
INSERT INTO bhd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","तैन्ने दिहैड़न मां मूसा पैदा भोव, तै परमेशरेरी नज़री मां बड़ो रोड़ो थियो, ते तै ट्लाई महीन्न तगर अपने बाजेरे घरे मां छेपतां पलतो राव। ");
INSERT INTO bhd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","पन ज़ैखन जादे च़िरे तगर छ़ुपेई न बटे, तै दरियाए मां शारो त फ़िरौनेरे कुइयां तै नेव ते अपने मट्ठेरो ज़ेरो पालो। ");
INSERT INTO bhd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","मूसा नबी मिस्री केरि सैरी शिक्षारो ते तैन केरि सैरी गल्लां केरि वाकफित भोइजेइ, ते गलबाती ते कम्मे मां मज़बूत थियो।” ");
INSERT INTO bhd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“ज़ैखन मूसा नबी 40 सालां केरो भोव, त तैसेरे मने मां ए गल आई, कि अवं अपने इस्राएली ढ्लां केरो हाल पतो केरि। ");
INSERT INTO bhd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","मूसा एक्की इस्राएली मैन्हु पुड़ ज़ुलम भोंतो लाहू त तैनी तै बच़ाव, ते तै ज़ालम मिस्री मैरतां ज़ैस पुड़ ज़ुलम भोरो थियो बदलो घिंनो। ");
INSERT INTO bhd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","तैनी सोचू, कि तैसेरे ढ्लां समझ़ेले, कि परमेशरे तैसेरे ज़िरिये सेइं तैन मिस्री केरि गुलैमी करां तैन मुक्ति देलो, पन तैनेईं न समझ़ू। ");
INSERT INTO bhd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","मूसा होरसां दूई इस्राएली एप्पू मांमेइं लड़ते लाए, ते तैन समझ़ानेरी कोशिश की, ते मूसा तैन ज़ोवं, हे जवानव तुस त एप्पू मांमेइं ढ्ला भोतथ, ते तुस किजो एक्की होरि पुड़ ज़ुलम केरतथ? ");
INSERT INTO bhd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","पन ज़ै मैन्हु अपने पड़ोसी पुड़ ज़ुलम केरने लोरो थियो, त तैनी मैने मूसा जो धमकेइतां ज़ोवं, तू केनि असन पुड़ हुकूमत केरनेबालो या हाकिम बनेवरोस? ");
INSERT INTO bhd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ज़ेन्च़रे तीं तै मिस्रेरो रानेबालो हीज मारोरो थियो, तेन्च़रे तू अज़ मीं मारने चातस? ");
INSERT INTO bhd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ए गल शुनते मूसा तैट्ठां नश्शो, ते मिद्यान मुलखे मां परदेशी भोइतां राने लगो, ते तैड़ी तैसेरां दूई मट्ठां पैदा भुआं। ");
INSERT INTO bhd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","40 साल मिद्यान मुलखे मां रानेरे बाद तैस सीनै पहाड़ेरे सुनसान ठारी मां एक्की झ़ल्लेरी अग्गी स्वर्गदूत लाव, ते परमेशरे स्वर्गदूतेरे ज़िरिये तैस सेइं गल की। ");
INSERT INTO bhd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","मूसा झ़ल्लेरी अग्गी लेइतां कि झ़ल फुकोने नईं लोरू त तै हैरान रेइ जेव, ते ज़ैखन तै हेरनेरे लेइ नेड़े जेव त तैनी प्रभुएरी आवाज़ शुनी। ");
INSERT INTO bhd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘अवं तेरे दादे-पड़दादां केरो यानी अब्राहम, इसहाक ते याकूबेरो परमेशर आईं,’” तैखन मूसा डेरतां कम्बने लगो, इन तगर कि तैस हेरनेरी हिम्मत न भोइ। ");
INSERT INTO bhd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","तैखन प्रभुए तैस जो ज़ोवं, अपने पांवां केरी जुट्टी खोल्ल, किजोकि ज़ैस ठैरी तू खड़ोस तै पवित्र ठारे। ");
INSERT INTO bhd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मीं मिस्र मुलखे मां अपने लोकां केरि बुरी हालत हेरी, मीं तैन केरू कर लानू ते लेरां शुनोरिन, एल्हेरेलेइ अवं तैन छुटानेरे लेइ उन्ढो ओरोईं, हुनी एई अवं तीं फिरी वापस मिस्र मुलखे जो भेज़ताईं। ");
INSERT INTO bhd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“एहे तै मूसो आए ज़ेसेरो इस्राएली लोकेईं पेइलो इन्कार कियोरो थियो, कि तू केनि असन पुड़ हुकूमत केरनेबालो या हाकिम बनेवरोस, ते एहे तै मूसा परमेशरे अपने स्वर्गदूतेरे ज़िरिये सेइं ज़ै तैनी बलते झ़ैल्लोए मां लाहोरो थियो, ते छुटानेबालो बनेइतां भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","एनी मैने मिस्र मुलखे ते लाल समुन्द्रे मां 40 सालन तगर सुनसान ठैरी मां चमत्कार ते निशान हिराए। ");
INSERT INTO bhd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","एनी मूसा इस्राएली लोकन सेइं ज़ोरू थियूं, परमेशर तुश्शे ढ्लान मरां तुश्शे लेइ अक मेरो ज़ेरो नबी खड़ो केरेलो। ");
INSERT INTO bhd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","एहे मूसा, इश्शे दादा पड़दादां केरो नबी राव ज़ैखन तैन सुनसान ठारी मां अकोट्ठे भोरोए, परमेशरे एक्की स्वर्गदूत सीनै पहाड़े पुड़ मूसे कानून दित्तो ते तैनी इश्शे दादे पड़दादन तैन कानून दित्तो, मूसे ज़िन्दगी देनेबाले वचन मैल्ले, तैनी तैना असन तगर पुज़ाए। ");
INSERT INTO bhd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","पन इश्शे दादे-पड़दादेईं तैसेरो हुक्म न मन्नो चाव, बल्के इकरार कियो, ते तैना मिस्र मुलखेरे जो वापस गानू चाते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","तैनेईं मूसेरे ढ्लाए हारूने सेइं ज़ोवं, तू इश्शे लेइ अक देबतो बना, ज़ै असन अग्री-अग्री मिस्र मुलखे जो च़ले, किजोकि अस न ज़ानम कि मूसा ज़ैनी असां मिस्र मुलखे मरां केढतां आनोरेम, तैस कुन भोवं? ");
INSERT INTO bhd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","तैस वक्ते तैनेईं बछ़ड़ेरी अक मूरत बनाई, ते तैस कां बलिदान च़ाढ़ू, ते अपने हथ्थां केरे बनेवरी मूरती कां बड़ी खुशी मनाने लाए। ");
INSERT INTO bhd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","एल्हेरेलेइ परमेशरे तैन करां अपनू तुतर फिराव, ते तैना दिहाड़ेरी ते च़ैंदनरे ते अम्बरेरे तारां केरि ईश्वरेरे रूपे मां तैन केरि आराधना केरनेरे लेइ शारे, ज़ेन्च़रे नेबी केरि किताबी मां लिखोरूए, हे इस्राएली लोकव, कुन तुस 40 सालन तगर सुनसान ठैरी मां जानवरां केरू बलिदान ते होरू बलिदान मेरे लेइ केरते राए? ");
INSERT INTO bhd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","बल्के तुसेईं एप्पू सेइं साथी मोलेक देबतेरी मूरती ते रिफान देबतेरे तारे छ़ुइतां च़लते थिये, एना तैना मूरतिन ज़ैन कां तुस मथ्थो टेकते थिये, एल्हेरेलेइ अवं तुसन बाबेले करां भी दूर बसेइलो।” ");
INSERT INTO bhd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“सुनसान ठारी मां इश्शे दादन पड़दादन कां गवाहेरो तेम्बु थियो, परमेशरे तै ठहराव ते तैनी मूसा सेइं ज़ोवं, ज़ेन्च़रे तीं लोरूए तैसेरे मुताबिक बना। ");
INSERT INTO bhd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","बड़े सालना बाद तैए तेम्बु इश्शे दादे-पड़दादेईं यहोशू सेइं साथी इड़ी आनो, ज़ैस वक्ते तैनेईं गैर कौमन पुड़ अधिकार हासिल कियो, ज़ैना परमेशरे इश्शे दादे-पड़दादां केरे सामने कढे, ते तै तेम्बु दाऊद राज़ेरे वक्ते तगर राव। ");
INSERT INTO bhd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दाऊदे पुड़ परमेशरे अनुग्रह कियो, ते तैनी मिनत की, कि अवं याकूबेरे परमेशरेरे लेइ अक घर बनेइं। ");
INSERT INTO bhd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","पन तैसेरे मट्ठे सुलैमाने तैसेरेलेइ मन्दर बनाव। ");
INSERT INTO bhd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","पन परमप्रधान परमेशर हथ्थां केरे बनेवरे मन्दरन मां न राए, ज़ेन्च़रे यशायाह नेबेरे किताबी मां लिखोरूए, ");
INSERT INTO bhd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","प्रभु ज़ोते, स्वर्ग मेरो तखते, ते ज़मीन मेरे पांवां केरि चौकीए, तुस फिरी मेरे लेइ केरू ज़ेरू मन्दर बनाले? ते मेरे आराम केरनेरी ठार केरही ज़ेरि भोली? ");
INSERT INTO bhd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","कुन मीं एप्पू सैरी चीज़ां नईं बनेवरी? ");
INSERT INTO bhd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“हे ढीठ लोकव, तुस तैसेरी शुन्नी ते मन्नी न चाथ, तुस पवित्र आत्मारी हमेशा खलाफत केरतथ। ज़ेन्च़रे तुश्शे दादे-पड़दादे केरते थिये, तुस भी तेन्च़रे केरतथ। ");
INSERT INTO bhd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","नेबन मरां को तुश्शे दादे-पड़दादेईं नईं स्तेवरो? ज़ैनेईं तैस एजनेबाले मसीहेरे बारे मां ज़ोवं ज़ै धर्मी आए, ते ज़ैखन मसीह अव ते तुसेईं धोखे सेइं तै ट्लुवेइतां मारो। ");
INSERT INTO bhd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","तुसन स्वर्गदूतन करां मूसेरे कानून त मैल्लो, पन तैस पुड़ अमल न कियूं।” ");
INSERT INTO bhd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ज़ैखन तैनेईं एना गल्लां शुनी त यहूदी लीडर फुकोई जे, ते स्तिफनुसे जो दंत लगे च़ापने। ");
INSERT INTO bhd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","पन तैनी पवित्र आत्माई सेइं भेरोइतां अम्बरेरे पासे तक्कू, ते तैनी परमेशरेरी महिमा ते यीशु परमेशरेरे देइने पासे खड़खड़ो लाव। ");
INSERT INTO bhd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","तैनी ज़ोवं, “हेरा, अवं स्वर्ग खुल्लू लाताईं, ते मैनेरे मट्ठे परमेशरेरे देइने पासे खड़खड़ो लाताईं।” ");
INSERT INTO bhd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","एन शुन्तां तैना ज़ोरे सेइं चिन्डां मारने लगे, ते अक भोइतां सेब्भेईं तैस पुड़ हमलो कियो। ");
INSERT INTO bhd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ते तै दीलतां यरूशलेम नगर करां बेइर नीयो ते तैस जो घोड़ेईं बाने लगे ते तै मारो, तैखन तैस पुड़ दोष लाने बालेईं अपने चोगे खोलतां शाऊल नव्वेंरे एक्की मैन्हु कां रेखतां छ़ड्डे। ");
INSERT INTO bhd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ते ज़ैखन तैना स्तिफनुसे जो घोड़ेईं बाने लग्गोरो थिये, ते तै स्तिफनुस इन ज़ोइतां प्रार्थना केरने लगो, “हे प्रभु यीशु, मेरी आत्मा कबूल केर। ");
INSERT INTO bhd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","फिरी तैनी ज़ैंधू केरे भारे बिश्तां ज़ोरे सेइं ज़ोवं, ‘हे प्रभु एन इस पापेरो दोषी न बनेइयां।’” एन ज़ोनेरां पत्ती तैनी प्राण दित्ते। ");
INSERT INTO bhd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","शाऊल तैसेरी मौती सेइं राज़ी थियो। तैस्से दिहाड़े यरूशलेम नगरेरे कलीसियाई पुड़ ज़ुलम भोने लाव ते प्रेरितां केरे अलावा सारे लोक यहूदिया ते सामरियारे इलाकन मांजो तितर-बितर भोए। ");
INSERT INTO bhd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","किछ परमेशरेरे भक्त मैनेईं स्तिफनुस नेइतां देबतां छ़ड्डो, ते तैसेरे मरने पुड़ बड़ो शोग कियो। ");
INSERT INTO bhd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","पन शाऊल कलीसियाई सताने लोरो थियो, ते तै घर-घर गातो थियो, ते विश्वासी मड़दन ते कुआन्शन बेइरोवं घसीटतो थियो, ते कैद केरतां छ़डतो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","पन ज़ैना विश्वासी तितर-बितर भोते थिये तैना खुशखबरी शुनाते च़ले। ");
INSERT INTO bhd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ते फिलिप्पुस सामरियारे एक्की नगर मां गेइतां मसीहेरो प्रचार केरने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ज़ैना गल्लां तैन लोकेईं फिलिप्पुसेरी करां शुनी, ते ज़ैना निशान तै हिरातो थियो, तैन हेरी-हेरी, तैनेईं अक भोइतां मन लाव। ");
INSERT INTO bhd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ज़ैखन फिलपुसे हुक्म दित्तो, त बड़े लोकन मरां भूतां चिन्डां मैरतां निस्सी जेआं, ते बड़े लोक अधरंगी ते टोंटे बेज़्झ़ोइ जे। ");
INSERT INTO bhd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ते तैन केरे वजाई सेइं नगरेरे बड़े लोक खुश भोइजेइ। ");
INSERT INTO bhd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","शमौन नव्वेंरे एक्की मैने सामरियारे नगर मां सारे लोक अपने जैदेइं सेइं हैरान कियोरे थिये, ते अपने आपे बड्डो खास मैन्हु बनातो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","निक्के बडे सब तैसेरे पासे भोइतां ज़ोने लगे, “ए मैन्हु परमेशरेरी तै शक्ति ज़ैस ज़ो महान ज़ोतन।” ");
INSERT INTO bhd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","तैनी अपने जैदू सेइं बड़े च़िरेरां देंते सब हैरान कियोरे थिये, एल्हेरेलेइ तैना लोक तैसेरी बड़ी इज़्ज़त केरते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","पन ज़ैखन फिलिप्पुसे परमेशरेरे राज़्ज़ेरे ते यीशु मसीहेरी खुशखबरी प्रचार की त लोकेईं विश्वास कियो, ते मड़देइं कुआन्शेईं बपतिस्मो नेव। ");
INSERT INTO bhd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","तैखन शमौने भी फिलिप्पुसेरे प्रचारे पुड़ विश्वास कियो, ते बपतिस्मो नेइतां फिलिप्पुसे सेइं साथी राने लगो ते तै बड़े चमत्कार ते निशान हेरतां हैरान रेइ जेव। ");
INSERT INTO bhd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ज़ैखन यरूशलेम नगरे मां प्रेरितेईं शुनू कि सामरियारे लोकेईं परमेशरेरू बच्चन कबूल कियोरूए ते तैनेईं पतरस त यूहन्ना तैन कां भेज़े। ");
INSERT INTO bhd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ज़ैखन तैना तैड़ी पुज़े त तैनेईं तैन लोकां केरे लेइ प्रार्थना की, कि एन पुड़ पवित्र आत्मा उतरे। ");
INSERT INTO bhd_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","एल्हेरेलेइ कि तैन पुड़ पवित्र आत्मा हेजू न थी उतरोरी, तैनेईं सिर्फ प्रभु यीशु मसीहेरे नंव्वे सेइं बपतिस्मो निहीयोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","तैखन यूहन्ना ते पतरसे तैन पुड़ हथ रेखतां प्रार्थना की, ते तैन भी पवित्र आत्मा उतरी। ");
INSERT INTO bhd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ज़ैखन शमौने हेरू कि प्रेरितां केरे हथ रखने सेइं पवित्र आत्मा उतरते, त शमौने पेंइसे एन्तां प्रेरितन कां पैश किये। ");
INSERT INTO bhd_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ते शमौन ज़ोने लगो, “मीं भी शक्ति देथ, कि अवं भी ज़ैस पुड़ हथ रेख्खी त तैस पुड़ पवित्र आत्मा उतरे।” ");
INSERT INTO bhd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","पतरसे तैस सेइं ज़ोवं, “तेरे पेइंसे तीं सेइं साथी गर्क भोन, किजोकि तू पेंइसन सेइं परमेशरेरू दान घिन्नू चातस। ");
INSERT INTO bhd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","एस सेवाई मां तेरो कोई भी हिस्सो नईं किजोकि तेरो मन परमेशरे कां साफ नईं। ");
INSERT INTO bhd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","तू अपनि इस बुरैई करां मनफिरा, ते प्रभु कां प्रार्थना केर, शैइद प्रभु तेरी इस बुरे खियाले माफ़ केरे। ");
INSERT INTO bhd_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","मनफिरा अवं हेरताईं कि तू बड़े जलनी ते पापेरी गुलैमी मां आस।” ");
INSERT INTO bhd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","तैखन शमौने जुवाब दित्तो, “मेरे लेइ प्रभु कां प्रार्थना केरा, कि ज़ैन किछ तुसेईं ज़ोरूए, तैन मीं पुड़ न एज्जे।” ");
INSERT INTO bhd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ते पतरस ते यूहन्ना गवाही देइतां ते प्रभु यीशुएरू वचन शुनेइतां यरूशलेम नगरे मां वापस आए, ते एइते बारे सामरी लोकां केरे बड़े ड्लोंव्वन मां खुशखबरी शुनाई। ");
INSERT INTO bhd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","फिरी एरू भोवं कि परमेशरे एक्की स्वर्गदूते फिलिप्पुसे सेइं ज़ोवं, “उठ ते दक्षिणेरे बत्तां गा, ज़ै यरूशलेम नगरेरां गाज़ा नगरे जो गातीए। ई रेगिस्तानी बत आए।” ");
INSERT INTO bhd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","तै उठो ते च़लो जेव, ते बत्ती मां तैस अक कूश मुलखेरो खोजो मैल्लो, ज़ै कूशी केरि रानी कन्दाकारो खज़ानची थियो, तै आराधना केरने यरूशलेम नगरे मां ओरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","तै अपने रथे पुड़ च़ेढ़तां अपने मुलखे जो वापस ओरो थियो, ते यशायाह नेबेरी किताब ज़ोरे-ज़ोरे सेइं पढ़ने लग्गोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","पवित्र आत्मा फिलिप्पुसे सेइं ज़ोवं, “नेड़े गेइतां रथे सेइं साथी च़ल।” ");
INSERT INTO bhd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिप्पुस देवड़तां रथे कां नेड़े पुज़ो, त तैस करां यशायाह नेबेरी किताब पढ़ती शुनी, ते तैस पुच़्छ़ू, “तू ज़ैन पढ़ने लोरोस कुन तैन समझ़तस?” ");
INSERT INTO bhd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","तैनी ज़ोवं, “ज़ां तगर कोई मीं न समझ़ाए त अवं केन्च़रे सेमझ़ी?” ते तैनी फिलिप्पुसे कां मिनत की, कि एई रथे पुड़ बिश। ");
INSERT INTO bhd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","पवित्रशास्त्रे मरां ज़ैन तै पढ़ने लग्गोरो थियो, त तैन इन थियूं, “तैनेईं तै भैडारो ज़ेरो मारने जो नीयो, ज़ेन्च़रे गबड़ू अपनि उन्ना बरधांने बालां केरे सामने च़ुप राते, तेन्च़रे तैनी भी अपनू आशी न खोल्लू।” ");
INSERT INTO bhd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","तै घटया समझ़ो जेव ते तैस कोई इन्साफ न मैल्लो, ते कोई भी तैसेरे वंशेरे बारे मां न ज़ोई सके, किजोकि धेरती पुड़ तैसेरे वंश भोने करां तैस मारतन। ");
INSERT INTO bhd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","खोजे फिलिप्पुसे पुच़्छ़ू, “अवं तीं कां मिनत केरतां, मीं सेइं ज़ो कि ए नबी कसेरे बारे मां ज़ोते, अपने या होरि केन्चेरे बारे मां ज़ोते?” ");
INSERT INTO bhd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","तैखन फिलिप्पुसे ज़ोनू शुरू कियूं, तैनी पवित्रशास्त्रे करां शुरू केरतां यीशुएरो खुशखबरी शुनाई। खोजे तैना गल्लां शुनी ते विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","बत्तां च़लते-च़लते तैना एक्की तालाबे कां पुज़े, तैखन खोजे ज़ोवं, “इड़ी तालाब आए, हुनी मीं बपतिस्मो नेने करां कौन रोकी सकते?” ");
INSERT INTO bhd_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिप्पुसे ज़ोवं, “अगर तू पूरे दिले सेइं विश्वास केरतस त बपतिस्मो नेही सकतस,” तैनी जुवाब दित्तो, “अवं विश्वास केरताईं कि यीशु ही परमेशरेरू मट्ठूए।” ");
INSERT INTO bhd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","फिरी तैनी रथ रोकनेरे लेइ हुक्म दित्तो, ते खोजो ते फिलिप्पुस दुइये तालाबे मां जे, ते फिलिप्पुसे तैस बपतिस्मो दित्तो। ");
INSERT INTO bhd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ज़ैखन तैना पैनी मरां बेइर निस्से त प्रभुएरी पवित्र आत्मा फिलिप्पुस तैट्ठां नेव, ते खोजे तै फिरी न लाव, परमेशरे तै बच़ाव ते तै बड़ी खुशी सेइं वापस अपने मुलखे जो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ते फिलिप्पुस अश्दोदे मांमेइं निसतो च़लतो सारे ड्लोंव्वन मां खुशखबरी शुनातो कैसरिया मां पुज़ो। ");
INSERT INTO bhd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","शाऊल प्रभुएरे चेलन धमकाने ते मारने मां मघन थियो, ते तै महायाजके कां जेव। ");
INSERT INTO bhd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ते तैस करां दमिश्क नगरेरे प्रार्थना घरां केरे लेइ चिट्ठी मेग्गी, कि चाए कोई मड़द भोए या कुआन्श ज़ै यीशु पत्ती च़लने बालो भोए, तैस ट्लेइतां यरूशलेम नगरे मां आने। ");
INSERT INTO bhd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ज़ैखन तै च़लतो-च़लतो दमिश्क नगरेरे नेड़े पुज़ो, त अचानक अम्बरेरां लौ आई ते तैसेरे च़ेव्रे पासन चमकने लगी। ");
INSERT INTO bhd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ते शाऊल ज़मीनी पुड़ खिरको, ते तैस प्रभुएरी आवाज़ आई, “हे शाऊल, हे शाऊल तू मीं किजो स्तातस?” ");
INSERT INTO bhd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","शाऊले एन पुच़्छ़ू, “हे प्रभु, तू कौन आस?” तैनी ज़ोवं, “अवं यीशु आईं, ज़ैस तू सतातस। ");
INSERT INTO bhd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","हुनी उठ ते नगरे मां गा, तैड़ी तीं सेइं ज़ोवं गालू, कि तीं कुन केरनूए।” ");
INSERT INTO bhd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ज़ैना लोक तैस सेइं साथी थिये, तैना च़ुपच़ारे रेइजे, तैन आवाज़ त शुनोती थी, पन लेइहोतू किछ भी न थियूं। ");
INSERT INTO bhd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","तैखन शाऊल ज़मीनी पुड़ां खड़े उठो, त तैनी अपनि एछ़्छ़ी घैड़ी त तैस किछ भी न लगू लेइहोने, ते तै तैसेरे सैथेईं हथेरां ट्लेइतां दमिश्क नगरे मां पुज़ाव। ");
INSERT INTO bhd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ते तैनी ट्लाई दिहाड़न तगर न लेई बटु, ते न तैनी किछ खाव ते पिव। ");
INSERT INTO bhd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमिश्क नगरे मां यीशुएरो अक चेलो रातो थियो, प्रभु यीशुए तैस दर्शन देइतां ज़ोवं, “हे हनन्याह!” तैनी ज़ोवं, “हाँ प्रभु ज़ो।” ");
INSERT INTO bhd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","तैखन प्रभुए तैस जो ज़ोवं, “उस गेली मां गा ज़ैस जो ‘सिद्धी’ ज़ोतन, ते यहूदारे घरे गा तैड़ी शाऊल नव्वेंरो अक मैनूए, ज़ै तरसुस नगरेरो रानेबालोए, तू तैसेरे बारे मां पुछ़ां, किजोकि हेरा तै प्रार्थना केरने लोरोए। ");
INSERT INTO bhd_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","तैनी हनन्याह नव्वेंरो अक मैन्हु अन्तर एइतो लाव, ते एप्पू पुड़ हथ रखतो लाहोरोए कि तै अपनि एछ़्छ़ेईं सेइं फिरी लाए।” ");
INSERT INTO bhd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हनन्याहे जुवाब दित्तो, “हे प्रभु, मीं एस मैनेरे बारे मां लोकन करां बेड़ि गल्लां केरती शुनोरिन, ते एन भी कि एनी तेरे लोकन सेइं यरूशलेम नगरे मां कुन-कुन बुरू कियोरूए। ");
INSERT INTO bhd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","एस प्रधान याजकन करां अधिकार मैलोरोए, कि इड़ी भी ज़ैना लोक तीं पुड़ विश्वास केरतन, तैन गिरफ्तार केरतां यरूशलेम नगरे जो ने।” ");
INSERT INTO bhd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","पन प्रभुए तैस सेइं ज़ोवं, “तू गा किजोकि मीं तै मैन्हु च़ुनोरोए, कि तै गैर कौमन, राज़न, ते इस्राएलेरे लोकन मेरे बारे मां प्रचार केरे, ते तै मीं च़ुनोरोए कि तै मेरी सेवा केरे। ");
INSERT INTO bhd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ते अवं तैस ज़ोइलो, लोकन मेरे बारे मां ज़ोनेरे वजाई तैस केत्रे-केत्रे दुःख झ़ैलनो पेनोए।” ");
INSERT INTO bhd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","तैखन हनन्याह तैस घरे मां जेव, ज़ैड़ी शाऊल थियो, ते तैस पुड़ हथ रेखतां ज़ोवं, “हे ढ्ला शाऊल, प्रभु, मतलब यीशु, ज़ैस बत्तां तू ओरोस ते तीं लेइहोरो थियो, तैनी अवं भेज़ोरोईं, कि तू फिरी लास ते पवित्र आत्माई सेइं भेरोस।” ");
INSERT INTO bhd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ते तैखन तैसेरे एछ़्छ़न मरां ज़ेरां शेकड़ां झ़ड़ां ते तै लहने लगो, ते खड़े उठतां बपतिस्मो नीयो। ");
INSERT INTO bhd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ते किछ रोट्टी खेइतां तैस हिम्मत आई, ते किछ दिहाड़े तै चेलन सेइं साथी दमिश्क नगरे मां राव। ");
INSERT INTO bhd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","तैसेरां बाद अकदम तै दिमश्क नगरेरे प्रार्थना घरन मां प्रचार केरने लगो, कि यीशु परमेशरेरू मट्ठूए। ");
INSERT INTO bhd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","सब शुन्ने बाले हैरान भोइतां ज़ोने लग्गे, “कुन ई तैए मैन्हु नईं, ज़ै यरूशलेम नगरे मां ज़ैना यीशु मसीह पुड़ विश्वास केरते थिये मारतो थियो? ते इड़ी भी एल्हेरेलेइ ओरो थियो, कि एन लोकन ट्लेइतां प्रधान याजकां केरे हवाले केरे?” ");
INSERT INTO bhd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","पन एसेरां बाद शाऊल होरो भी शेक्ति सेइं प्रचार केरतो राव, ते एस गल्लरू सबूत देइ-देइ कि यीशु ही मसीहे, दमिश्क नगरेरे रानेबालां यहूदी केरू आशी बंद केरतो राव। ");
INSERT INTO bhd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ज़ैखन शाऊले दश्मिके मां बड़ो वक्त बीतो त यहूदेईं मिलतां तैस मारनेरो मुशोरो कियो। ");
INSERT INTO bhd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","पन शाऊले एस गल्लरो पतो लगो, तैना त तैस मारनेरे लेइ रात दिहैड़ी दारन पुड़ रहते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","पन राती तैसेरे चेलेईं तै टोकरे मां रख्खो, ते नगरेरे दुवारी पुड़ां रस्से सेइं टोकरी मां ओसैलतां बुन पुज़ाव। ");
INSERT INTO bhd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ज़ैखन शाऊल यरूशलेम नगरे मां पुज़ो त तैनी चेलन सेइं मिलनेरो इंतज़ाम कियो, पन सब तैस करां डरते थी कि तै भी चेलोए। ");
INSERT INTO bhd_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","पन बरनबासे शाऊल एप्पू सेइं साथी प्रेरितन कां आनो ते तैन ज़ोवं, कि केन्च़रे दमिश्क नगरेरे बत्तां च़लते-च़लते एस प्रभु यीशु लेइहोरोए, ते प्रभुए एस सेइं गल्लां कियोरिन, ते एनी केत्रे दिलेरी सेइं दमिश्क नगरे मां यीशुएरे नव्वेंरो प्रचार कियोरोए। ");
INSERT INTO bhd_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","प्रेरितेईं बरनबासेरी गल्लां केरो विश्वास कियो, ते शाऊल तैन सेइं साथी राव, ते यरूशलेम नगरे मां गातो राव। ");
INSERT INTO bhd_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ते यूनानी भाषा केरनेबाले यहूदन सेइं भी गलबात केरतो थियो, दिलेर भोइतां प्रभुएरो प्रचार केरतो थियो, पन तैना तैस मारनेरी कोशिश मां रहते थी। ");
INSERT INTO bhd_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","एल्हेरेलेइ विश्वासी ढ्लाएईं तै कैसरिया नगरे मांजो नीयो, ते तैट्ठां तरसुसे नगरे जो भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","त सारे यहूदिया इलाके मां ते गलील इलाके ते सामरिया इलाकेरी कलीसियान मां चैन भोव, ते तरक्की भोती जेई, ते तै प्रभुएरे डरे मां ते पवित्र आत्मारे शैन्ति मां च़लती ते बड़े लोकेईं यीशु मसीह पुड़ विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","फिरी एरू भोवं कि पतरस सारे इलाके मां हंठतो फिरो, ते तैन पवित्र लोकन साथी भी पुज़ो, ज़ैना लुद्दा नगरे मां रहते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","त तैस तैड़ी ऐनियास नव्वेंरो अक मैन्हु मैल्लो, तैस अधरंग थियो, ते अठे सालां केरो देंतो खट्टी पुड़ राहोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पतरसे तैस जो ज़ोवं, “हे ऐनियास! यीशु मसीह तीं बझ़ाते, उठ अपनू बछ़ान खड़ू केर,” तैखने तै बेज़्झ़ोइतां खड़ो भोव। ");
INSERT INTO bhd_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","तैखन लुद्दा नगरेरे ते शारोनेरे राने बालेईं एन हेरतां प्रभु यीशु पुड़ विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","याफा नगरे मां अक कुआन्श थी, ज़ेसारू नवं तबीता थियूं (यूनानी भाषाई तैसेरू दोरकास थियूं, ज़ेसेरो मतलब हिरनी) तै विश्वासी थी, ते रोड़ां-रोड़ां कम्मां केरती ते गरीबां केरि मद्दत केरती थी। ");
INSERT INTO bhd_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","तैने दिहाड़न मां ज़ेइस पतरस लुद्दा मां थियो, तै बिमार भोइतां मेरि जेई, ते तैसारी लाश नेइतां दोपरेरे कमरे मां रखोरि थी। ");
INSERT INTO bhd_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लुद्दा याफारे नेड़े थियूं, ते ज़ैखन चेलेईं शुनू कि पतरस लुद्दा मां आए, त दूई मैन्हु भेज़तां मिनत की, “कि असन कां एजने मां ठढ न ला।” ");
INSERT INTO bhd_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","तैखन पतरस तैन सेइं साथी च़लो जेव, ते ज़ैखन तैड़ी पुज़ो त तै बा तैस कमरे मां नीयो, सैरी विधवां कुआन्शां लेरां देती थी, ते तैस ड्लखमेइं खेड़ि थी, ते तैना लिगड़ां ज़ैना दोरकास सियोरां थियां हिराने लेगि। ");
INSERT INTO bhd_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","पतरसे तैना सब बेइरोवं कढे, ते एप्पू ज़ैधू केरे भारे प्रार्थना केरने लगो, फिरी तैनी लाशारे पासे तुत्तर फरेइतां ज़ोवं, “हे तबीता, उठ।” तैखन तैसां अपनि एछ़्छ़ी खोल्ली, ते पतरसे तेकतां खड़ी भोइ। ");
INSERT INTO bhd_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","पतरसे हथेरां ट्लेइतां खड़ी की, ते विश्वासी ते विधवां कुआन्शां कुजेइतां ज़ींती ते होशी मां तैन केरे सुपुर्द की। ");
INSERT INTO bhd_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","एस गल्लरी खबर सारे याफा नगरे मां फैली जेई, ते बड़े लोकेईं प्रभु यीशु पुड़ विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","पतरस किछ च़िरे तगर याफा नगरे मां शमौन नव्वेंरो एक्की मैनेरे कां राव, ज़ै चमड़ेरू कम केरतो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया नगरे मां अक मैन्हु थियो, तैसेरू नवं कुरनेलियुस थियूं, ते तै अक इतालियानी फौवजरो सूबेदार थियो। ");
INSERT INTO bhd_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","कुरनेलियुस त तैसेरे घरे सारे लोक परमेशरे करां डरने बाले थिये, कुरनेलियुस यहूदी लोकन बड़ू दान देतो थियो, ते परमेशरे कां लगातार प्रार्थना केरतो रातो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","एक्की दिहाड़े कुरनेलियुस दीसां अक रोड़े च़ारे दर्शन हेरू, परमेशरेरो अक स्वर्गदूत तैस कां अव, ते ज़ोने लगो, “हे कुरनेलियुस।” ");
INSERT INTO bhd_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","तैनी तै रोड़े-च़ारे लाव ते डेरतां ज़ोवं, “हे मालिक कुने?” तैनी तैस सेइं ज़ोवं, “तेरी प्रार्थना ते तेरू दान यादगैरेयर लेइ परमेशरे कां पुज़ेरू आए। ");
INSERT INTO bhd_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","हुनी तू मैन्हु याफा नगरे मां भेज़तां तैस मैन्हु ज़ेसेरू नवं शमौन पतरसे अपने घरे कुजा। ");
INSERT INTO bhd_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","तै शमौनेरे घरे बिशोरो थियो, ज़ै चमड़ेरू कम केरनेबालो थियो, ज़ेसेरू घर समुद्रेरे बन्ने।” ");
INSERT INTO bhd_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ज़ैखन स्वर्गदूत एना गल्लां केरतां च़लो जेव, त कुरनेलियुस अपने दूई सेवकन ते अपने सिपेहिन मरां अक भक्त सिपाही कुजाव। ");
INSERT INTO bhd_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ते तैन सारो बिस्तार ज़ोइतां याफा नगरे जो भेज़े, कि पतरसे कुजान। ");
INSERT INTO bhd_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","होरसां ज़ैखन तैना भेज़ोरे लोक च़लते-च़लते नगर नेड़े पुज़े। तै दुपारहरां केरो वक्त थियो, तैस वक्ते पतरस बा छती पुड़ प्रार्थना केरने लावरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","तैस ढ्लुख लग्गी ते तै किछ खानू चातो थियो, पन ज़ैखन मैन्हु रोट्टी बनाने लगे त तैस बेहोशी ज़ेरि भोइजेइ। ");
INSERT INTO bhd_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ते तैनी हेरू कि अम्बर खुल्लूए, ते अक च़ादर लाई ज़ै च़ेव्रे कूना टेंगोरी अम्बरेरे पासेरां उन्ढी ज़मीनरे पासे ओरी। ");
INSERT INTO bhd_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ज़ैस मां ज़मीनरे सारे जानवर ते पेटेरे भारे च़लने बाले जन्तू ते अम्बरेरां च़ुड़ोलू तैस च़ादरी मां थियां। ");
INSERT INTO bhd_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","तैखन अक आवाज़ आई, “हे पतरस, उठ ते मार ते खा।” ");
INSERT INTO bhd_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","पन पतरसे जुवाब दित्तो, “नईं प्रभु, कधे नईं, किजोकि मीं अज़ तगर कोई अपवित्र ते भिट्टी चीज़ नईं खोरी।” ");
INSERT INTO bhd_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","फिरी दुइयोवं बार तैनी आवाज़ शुनी, “ज़ैन किछ परमेशरे शुद्ध कियोरूए, तू तैस जो भिटू न ज़ो।” ");
INSERT INTO bhd_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ट्लेइ बार ए आवाज़ आई, ते फिरी तै च़ादर अम्बरेरे पासे च़ली जेई। ");
INSERT INTO bhd_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","पतरस दिले मां सोचने लग्गोरो थियो, कि एस दर्शनेरो कुन मतलब भोइ सकते, ज़ैन अज़ मीं लाव, एत्रे मां कुरनेलियुसेरे भेज़ोरे मैन्हु शमौनेरू घर तोपते-तोपते दारे मां पुज़े। ");
INSERT INTO bhd_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","तैनेईं हक देइतां पुच़्छ़ू, “शमौन ज़ैस जो पतरस ज़ोतन इड़ी तुश्शे कां आए?” ");
INSERT INTO bhd_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","हेजू पतरस दर्शनेरे बारे मां सोचने लग्गोरो थियो, त पवित्र आत्मा तैस जो ज़ोवं, “शमौन, हेर ट्लाई मैन्हु तीं पुच्छ़ने लगोरेन। ");
INSERT INTO bhd_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","खड़ो उठ ते बुन गा, तैन सेइं साथी गाने करां न डेरां, किजोकि तैना मीं भेज़ोरेन।” ");
INSERT INTO bhd_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","पतरस बुन अव, ते तैन मैनन् सेइं ज़ोने लगो, “ज़ैस मैन्हु तुस तोपने लगोरेथ तै अवं आईं, ते तुस किजो ओरेथ?” ");
INSERT INTO bhd_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","तैनेईं जुवाब दित्तो, “असां कुरनेलियुस सूबेदारे ज़ै धर्मी ते परमेशरे करां डरने बालोए, ते सारे यहूदी तैसेरी तारीफ़ केरतन, एक्के पवित्र स्वर्गदूते तैस जो ज़ोरूए, तू शमौन पतरसे अपने घरे कुजेइतां तैसेरी गल्लां शुन।” ");
INSERT INTO bhd_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","तैखन पतरसे तैना अन्तर कुजाए, ते तैन केरि खातरदारी की। होरसां पतरस तैन सेइं साथी च़लो जेव, ते याफा नगरेरे काई ढ्लान मरां किछ तैस सेइं साथी च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","एग्री दिहाड़े तैना कैसरिया नगरे मां पुज़े, कुरनेलियुस अपने रिशतेदारन ते अपने दोस्तन अकोट्ठे केरतां तैन बलगने लाव। ");
INSERT INTO bhd_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","पतरस ज़ैखन कुरनेलियुसेरे घरे पुज़ो, त कुरनेलियुसे तैसेरी बड़ी आदर खातरी सेइं इज़्ज़त की, ते क्रोड़ी पव्वन कां रेखतां तैस कां मथ्थो टेको। ");
INSERT INTO bhd_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","पन पतरसे तै खड़ो कियो ते ज़ोवं, “खड़ो भो किजोकि अवं भी त अक मैन्हु आईं।” ");
INSERT INTO bhd_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","फिरी तै कुरनेलियुसे सेइं गल्लां केरतो अन्तर जेव, तैड़ी बड़े लोक अकोट्ठे बिश्शोरे लेइतां, ");
INSERT INTO bhd_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","तैस सेइं ज़ोवं, “तुसन पत्तोए इश्शे यहूदी केरे लेइ गैर कौमी सेइं मिलनू जुलनु कानूनेरे खलाफे, पन परमेशरे मीं सेइं ज़ोरूए कि अवं केन्ची मैन्हु जो अपवित्र या भिट्टो ज़ोईं। ");
INSERT INTO bhd_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","एल्हेरेलेइ तुसेईं अवं कुजाव त अवं च़ुपच़ारे च़लो अव। हुनी अवं तुसन पुछ़ताई कि तुसेईं अवं किजो कुजेवरोईं?” ");
INSERT INTO bhd_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","कुरनेलियुसे ज़ोवं, “अवं च़ेव्रे दिहाड़ना पेइले अपने घरे मां इस मौके कोई ट्लेइ बज़ेइं प्रार्थना लोरो थियो केरने, त अचानक अक मैन्हु चमकतां लिगड़ां लग्गोरो मेरे तुत्तरे अगर खड़ो भोव। ");
INSERT INTO bhd_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ते ज़ोने लगो, हे कुरनेलियुस, तेरी प्रार्थना परमेशरे शुनोरीए ते तेरू दान भी कबूल कियोरूए। ");
INSERT INTO bhd_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","एल्हेरेलेइ कोन्ची याफा नगरे मां भेज़तां शमौन ज़ैस जो पतरस ज़ोतन, कुजा। तै शमौनेरे कांए ज़ै चमड़ेरू कम केरनेबालो, ते समुद्रेरे बन्ने रहते। (ज़ैखन तै एज्जेलो त तै परमेशरे बारे मां ज़ोलो) ");
INSERT INTO bhd_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","तैखन मीं मैन्हु भेज़े, ते तीं बड़ू रोड़ू कियूं कि तू अव। हुनी अस परमेशरेरे सामनेम, ताके ज़ैन किछ परमेशरे ज़ोरू तैन शुनम।” ");
INSERT INTO bhd_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","तैखन पतरस ज़ोने लगो, हुनी मीं याकीन भोव, कि परमेशर केन्चेरो तरफदार नईं। ");
INSERT INTO bhd_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","बल्के हर कौमी मरां ज़ै परमेशरे करां डरते ते रोड़ां कम्मां केरते परमेशर तैस कबूल केरते। ");
INSERT INTO bhd_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","इस्राएली लोकां केरे लेइ परमेशरेरे भेज़ोरे सन्देशेरे बारे मां तुसन पतो आए। परमेशरे यीशु मसीहेरे ज़िरिये सेइं ज़ै सेब्भी केरो प्रभुए शैनतरी खुशखबरी शुनाई। ");
INSERT INTO bhd_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","यूहन्नारे बपतिस्मेरो प्रचार केरने करां लेइतां गलील इलाके करां शुरू भोइतां सारे यहूदिया इलाके मां कुन-कुन भोवं, तुस भी ज़ानतथ। ");
INSERT INTO bhd_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","केन्च़रे प्रभु यीशु नासरी पवित्र आत्माई सेइं ते शक्ति सेइं अभिषेक कियूं, ते तै लोकां केरू भलू केरतो राव, तैनी सब ज़ैना शैतानेरे ज़ाले मां फासोरे थिये, तैना छुटाए, किजोकि परमेशर तैस सेइं साथी थियो। ");
INSERT INTO bhd_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","तैनी ज़ैन किछ यहूदी केरे मुलखे मां ते यरूशलेम नगरे मां कमाव, असां तैसेरे गवाह आम, ते तैए यहूदी लीडरेईं यरूशलेमे मां क्रूसे पुड़ टेंगेइतां माराव। ");
INSERT INTO bhd_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","परमेशरे तैए ट्लेइयोवं दिहाड़े फिरी ज़ींतो केरतां हिराव। ");
INSERT INTO bhd_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","तै सैरी लोकेईं नईं बल्के गवाहैई लाव, ज़ैना परमेशरे पेइले च़ुनतां रखोरे थिये, यानी असां ज़ैनेईं तैसेरे मुड़दन मरां ज़ींते भोनेरां बाद तैस सेइं साथी रोट्टी खोरीए। ");
INSERT INTO bhd_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ते तैनी असन हुक्म दित्तो कि लोकन मां प्रचार केरम ते गवाही देम, कि ई तैए ज़ै परमेशरे ज़ींते ते फटरां केरो हाकिम भोए। ");
INSERT INTO bhd_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","सारे नबी तैसेरे बारे मां गवाही देतन, कि ज़ै कोई तैस पुड़ विश्वास केरेलो त तैस तैसेरे नंव्वे सेइं पापां केरि माफ़ी मैले। ");
INSERT INTO bhd_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पतरस हेजू एन ज़ोंतो थियो, त पवित्र आत्मा तैन पुड़ उतरी, ज़ैना बच्चन शुन्ने लोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ते ज़ेत्रे यहूदी विश्वासी पतरसे सेइं साथी ओरे थी, तैना सब हैरान भोए कि गैर कौमन पुड़ भी पवित्र आत्मा उतरोरीए। ");
INSERT INTO bhd_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","किजोकि तैनेईं तैना किसमे-किसमेरी भाषां केरते, ते परमेशरेरी तारीफ़ केरते शुनोरी थिये, तैखन पतरसे ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ज़ेन्च़रे परमेशरे असन पवित्र आत्मा दित्तोरीए तेन्च़रे तैन भी दित्तोरीए, कुन कोई एन मैनन् पैनेरो बपतिस्मो नेने करां रोकी सकते?” ");
INSERT INTO bhd_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","एल्हेरेलेइ पतरसे हुक्म दित्तो, कि एन लोकन यीशु मसीहेरे नंव्वे सेइं बपतिस्मो देथ, तैखन तैनेईं पतरसे कां मिनत की, कि किछ दिहाड़े असन कां हेजू बिश। ");
INSERT INTO bhd_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","यहूदिया मां रानेबाले प्रेरितेईं ते विश्वासी ढ्लाएईं ए खबर शुनी, कि गैर यहूदेईं भी परमेशरेरू बच्चन कबूल कियूं। ");
INSERT INTO bhd_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ते ज़ैखन पतरस वापस यरूशलेम नगरे मां अव, त यहूदी विश्वासी लोक तैस सेइं बेंस केरने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“तू गैर कौमां केरे घरे जेव, ते तैन सेइं साथी बिश्तां रोट्टी भी खाइ।” ");
INSERT INTO bhd_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","पतरसे तैन सेइं सारो बिस्तार पत्रां देंतो ते आखरी तगर एन्च़रे शुनाव, कि कुरनियुसेरे घरे कुन भोवं। ");
INSERT INTO bhd_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“अवं याफा नगर मां प्रार्थना केरने मां मघन थियो, त मीं किछ बेहोशी ज़ेरि भोइजेइ, ते मीं अक दर्शन लाव, ते अक च़ादर ज़ेरि च़ेव्रे कूना टेंगोइतां अम्बरेरे पासेरां उन्ढी एइतां मीं तगर पुज़ी। ");
INSERT INTO bhd_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","अवं तैस मां तकने लगो त कुन हेरताईं कि, तैस मां ज़मीनरे सारे च़ेव्रे ज़ंघेइं च़लने बाले जानवर ते पेटेरे भारे च़लने बाले जीप ते अम्बरे मां उडरने बालां च़ुड़ोलू थियां। ");
INSERT INTO bhd_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","तैखन मींजेई अक आवाज़ आई, ज़ै ज़ोने लगी, ‘हे पतरस खड़ो उठ ते इन मार ते खा।’ ");
INSERT INTO bhd_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","मीं जुवाब दित्तो, प्रभु नईं, किजोकि मीं अज़ तगर कोई भी अपवित्र या भिट्टी चीज़ नईं खोरी। ");
INSERT INTO bhd_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","एसेरे जुवाबे मां अम्बरेरां होरि आवाज़ आई, ‘ज़ैन किछ परमेशरे पवित्र बनेवरीए, तू तैस जो भिटू न ज़ो।’ ");
INSERT INTO bhd_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ए आवाज़ ट्लेइ बार आई, ते फिरी तै च़ादर अम्बरेरे पासे खिचोइतां च़ली जेई। ");
INSERT INTO bhd_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ठीक तैस्से मौके ट्लाई मैन्हु ज़ैना कैसरिया नगरे मरां कुरनुलियुसे मीं कां भेज़ोरे थिये, तैस घरे कां सामने खड़े भोए, ज़ैड़ी अवं थियो। ");
INSERT INTO bhd_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","तैखन पवित्र आत्मा मीं सेइं ज़ोवं, बेधड़क च़ारे एन सेइं साथी गा, एना 6 ढ्ला भी मीं सेइं साथी आए, ते असां तैस मैनेरे घरे जे। ");
INSERT INTO bhd_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","तैनी असन सेइं ज़ोवं, कि केन्च़रे सेइं तैनी अक स्वर्गदूत घरे लाव ते ज़ोने लगो, याफा मां केन्ची मैन्हु भेज़तां शमौन ज़ैस जो पतरस ज़ोतन, तैस अपने घरे कुजा। ");
INSERT INTO bhd_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","तै एइतां तीं अक एरो बिस्तार देलो, ज़ेसेरे ज़ोने सेइं तेरी खानदानेरे सारे मैनन् परमेशर मुक्ति देलो। ");
INSERT INTO bhd_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ज़ैखन मीं तैड़ी गेइतां तैन सेइं गल्लां शुरू की, त पवित्र आत्मा तैन पुड़ उतरी, ज़ेन्च़रे पेइले असन पुड़ उतरोरी थी। ");
INSERT INTO bhd_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तैखन मीं प्रभुएरू तैन वचन याद आऊं, ज़ैन तैने ज़ोवरो थियूं, कि यूहन्ना त पैनी सेइं बपतिस्मो दित्तो, पन तुसन पवित्र आत्माई सेइं बपतिस्मो मैलेलो। ");
INSERT INTO bhd_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","बस्सा अगर परमेशरे तैन भी तैए तोफो दित्तो, ज़ै असन प्रभु यीशु मसीह पुड़ विश्वास केरने सेइं मैल्लो, त अवं कौन भोताईं कि परमेशरे रोकी?” ");
INSERT INTO bhd_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ज़ैखन यहूदी विश्वासी लोकेईं एन शुनू त च़ुप रेइजे, “ते परमेशरेरी तारीफ़ केरने लगे, तां त सच़्च़े कि परमेशरे गैर कौमन भी पापन करां मन फिरेइतां यीशु पुड़ विश्वास केरतां हमेशारी ज़िन्दगी हासिल केरनेरो तोफो दित्तोरोए।” ");
INSERT INTO bhd_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","त तैना लोक ज़ैना तैस दुखेरे मारे ज़ै स्तिफनुसेरे मौतरे वक्ते शुरू भोरो थियो, तितर-बितर भोइजेइ, ते च़लते-च़लते फीनीके इलाके ते साइप्रस ते अन्ताकिया नगरे तगर पुज़े, पन तैना यहूदी केरे अलावा होरन परमेशरेरू वचन न थिये शुनाते। ");
INSERT INTO bhd_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","पन तैन मरां किछ साइप्रसेरे रानेबाले ते किछ कुरेनेरे रानेबाले थिये, ज़ैना अन्ताकिया नगरे मां एइतां यूनानी लोकन भी प्रभु यीशु मसीहेरी खुशखबरी शुनाने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ते प्रभुएरी शक्ति तैन पुड़ थी, ते बड़े गैर कौमरे लोकेईं तैन केरे सनदेशे पुड़ विश्वास कियो, ते प्रभु यीशु पुड़ भरोसो केरनो शुरू कियो। ");
INSERT INTO bhd_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","तैखन तैन केरि खबर यरूशलेम नगरेरे कलीसियारे लोकन तगर पुज़ी, ते तैनेईं बरनबास अन्ताकिया नगरे जो भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","तै तैड़ी पुज़तां, ते परमेशरेरो अनुग्रह हेरतां बड़ो खुशी भोव, ते तैन ए गल ज़ोई कि अपने तने मने सेइं प्रभु सेइं लिपटोरे रान। ");
INSERT INTO bhd_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","बरनबास अक रोड़ो मैन्हु थियो, तै पवित्र आत्माई ते विश्वासे सेइं भरपूर थियो, ते बड़े लोक प्रभु मां आए। ");
INSERT INTO bhd_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","तैखन बरनबास अन्ताकिया नगर शैरतां शाऊले तोपने तरसुस नगरे जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","तैनी शाऊल तोप्तां अन्ताकिया नगरे मां आनो, तैड़ी तैना एक्की साले तगर दुइये ज़न्हे कलीसियाई मां लोकन प्रभु यीशुएरी शिक्षा देते राए, ते लोक चेलन जो सेब्भन करां पेइले अन्ताकिया नगरे मां मसीही ज़ोने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","तैन्ने दिहाड़न मां किछ विश्वासी ज़ैना नबी थिये, यरूशलेम नगरेरां अन्ताकिया नगरे मां आए। ");
INSERT INTO bhd_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","तैन मरां अक नबी ज़ेसेरू नवं अगबुस थियूं खड़े भोइतां ते पवित्र आत्मारे ज़ोने सेइं एन ज़ोने लगो, कि सैरी दुनियाई मां अक बड़ो काल पेनोए। ए काल क्लौदियुस हाकिमेरे वक्ते पेव। ");
INSERT INTO bhd_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","तैल्हेरेलेइ चेलेईं फैसलो कियो कि, असन मरां हर कोई अपनि-अपनि हैसयतरे मुताबिक किछ दान देथ, ताके यहूदिया इलाके मां रानेबाले मसीही ढ्लां केरि मद्दत भोइसखे। ");
INSERT INTO bhd_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","बस्सा तैनेईं किछ रकम अकोट्ठी की ते बरनबास ते शाऊलेरे हथ्थे यरूशलेम नगरेरे बुज़ुर्गन कांजो भेज़ी। ");
INSERT INTO bhd_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","तैस्से वक्ते मां हेरोदेस राज़ो कलीसियारे किछ मैनन् दुःख देनेरे लेइ तैना ट्लाने शुरू कीए। ");
INSERT INTO bhd_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ते यूहन्ना प्रेरितेरो ढ्ला याकूब तलवारी सेइं मराव। ");
INSERT INTO bhd_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ज़ैखन तैनी हेरू कि यहूदन ए गल बड़ी खुशी अई, त तैन दिहाड़न मां पतरस भी ट्लाव। तैना दिहैड़ी अखमीरी रोट्टरी तिहारेरी थी। ");
INSERT INTO bhd_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ते तैस ट्लानेरां बाद हेरोदेस तै कैदखाने मां छ़ड्डो, ते तैसेरी निगरेंनारे लेइ च़ेव्रे टोली बनाई, हर टोली च़ेव्र-च़ेव्र सिपाही केरि थी, हेरोदेसेरो खियाल थियो कि फ़सह तिहारेरे बाद तै कैदे मरां केढतां लोकां केरे सामने पैश केरे। ");
INSERT INTO bhd_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","कैदखाने मां पतरस बड़े दिहाड़न तगर पेरहे मां थियो, पन सारी कलीसिया तैसेरेलेइ परमेशरे कां प्रार्थना केरने लगोरी थी। ");
INSERT INTO bhd_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","हेरोदेसे, पतरस लोकां केरे सामने आने करां पेइले अक रात ज़ैखन पतरस दूई पहरेदारां केरे मझ़ाटे बंधोरो झ़ुलोरो थियो, ते सिपाही कैदखानेरे डेवढी पुड़ पैरहो देंते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","त अचानक परमेशरेरो स्वर्गदूत कैदखाने मां अव, ते सारो कैदखानो ट्लकड़ो भोइ जेव, स्वर्गदूते पतरसे खित्ती देइतां बींझ़ाव ते ज़ोवं, “उठ, ते लूश केर।” ते शंगलां पतरसेरे हथ्थन सैहींयेरां खुल्ली जेई। ");
INSERT INTO bhd_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","स्वर्गदूते पतरसे सेइं ज़ोवं, “अपनू मज़ बन्ध ते बूट ला।” पतरसे तैन्ने कियूं, ते फिरी ज़ोवं, “अपनो चोगो ला ते मीं पत्पती एई।” ");
INSERT INTO bhd_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","पतरस स्वर्गदूत पत्पती कैदखाने मरां बेइर अव, पन तैस ए पतो न थियो, कि स्वर्गदूते ज़ैन केरने लगोरोए एन सच़्च़े या कोई दर्शन हेरने लगोरोइं। ");
INSERT INTO bhd_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","तै दुइयोवं पेरहेदारे करां बेइर निस्तां अव, ते लोंहेरे फाटके कां पुज़ो, ज़ै नगरेरे पासे खुलतो थियो, तै फाटक तैन केरे लेइ अपने आप खुल्लो, ते तैना तैट्ठां निस्तां दूर पुज़े, स्वर्गदूत पतरसे तैड़ी पुज़ेइतां गैइब भोइ जेव। ");
INSERT INTO bhd_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","तैखन पतरस होशी मां अव, ते ज़ोने लगो, “हुनी मीं पूरू याकीन भोवं, कि परमेशरे अपनो स्वर्गदूत भेज़तां अवं हेरोदेसेरे हथ्थे मरां छुटाव, ते यहूदी लीडरेईं ज़ैन सोचेरू थियूं, तैन बन्ने न दित्तू।” ");
INSERT INTO bhd_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ज़ैखन तै एस बारे मां सोचने लग्गोरो थियो, त मरियमेरे घरे पुज़ो, ज़ै यूहन्ना ज़ैस जो मरकुस ज़ोते थिये तैसेरी अम्मा थी। तैड़ी बड़े विश्वासी लोक अकोट्ठे भोइतां प्रार्थना केरने लग्गोरो थिये। ");
INSERT INTO bhd_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","पतरसे बेइरू दार गुड़कावं त अक नौकरानी ज़ेसारू नवं रूदे थियूं, तै दार खोलने आई। ");
INSERT INTO bhd_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","तैसां पतरसेरी गल शुनी ते तैसां गल पिशानी ते बगैर दार खोलनेरां दौवड़ती खुशी भोइतां आई, ते ज़ोने लगी, पतरस बेइर दारे मां ओरोए। ");
INSERT INTO bhd_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","तैना मैन्हु ज़ोने लगे, “तू कुन पागल भोरिस।” पन ज़ैखन तैसां रोड़ेच़ारे ज़ोवं, कि तै पतरसे, त तैना ज़ोने लगे “पतरस त नईं पन पतरसेरो स्वर्गदूत भोलो।” ");
INSERT INTO bhd_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ते पतरस बेइर दार गुड़कातो राव, ते ज़ैखन तैनेईं दार खोल्लू त पतरस लेइतां हैरान रेइजे। ");
INSERT INTO bhd_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","पतरसे तैन जो हथ्थे सेइं इशारो कियो, कि च़ुप राथ, ते फिरी अन्तर एइतां सारो बिस्तार शुनाव, कि अवं केन्च़रे परमेशरे कैदखाने मरां बेइर कढो, ते फिरी ज़ोवं, “याकूबे त तैसेरे होरि मसीह ढ्लान भी पतो देइयथ।” ते एप्पू केन्ची होरि जगाई जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ज़ैखन झ़ेझ़ भोइ त सिपेहिन एप्पू मांमेइं खलबली मेच़ि जेई, कि पतरस कोरां जेव। ");
INSERT INTO bhd_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ज़ैखन हेरोदेसे तैस तोप्पनेरो हुक्म दित्तो त तैनी सिपेही केरू बियांन घिन्नेरां पत्ती तैन जो कतलेरो हुक्म दित्तो, ते पतरस यहूदिया इलाके मरां कैसरिया नगरे जो च़लो जेव, ते किछ च़िरे तगर तैड़ी राने लाव। ");
INSERT INTO bhd_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हेरोदेस सूर ते सैदारे नगरेरे लोकन पुड़ बड़ो नाराज़ थियो, तैखन तैना लोक मिलतां तैस कां आए, ते बलास्तुसे ज़ै राज़ेरो खास मैन्हु थियो, मनेइतां मेल केरनो चाव, किजोकि राज़ो एरे मुलखेरां तैन केरे मुलखे खर्च़ो मैलतो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","तैखन तैनी अक दिहाड़ी ठुवहलाई ते हेरोदेस राज़ो अपना राज़ेरां लिगड़ां लेइतां आदालतरे तखते पुड़ बिश्तां लोकन सेइं ज़ोने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","तैनेईं ज़ैखन शुनू त ज़ोने लगे, “ए मैन्हु केरि आवाज़ नईं बल्के परमेशरेरी आवाज़े।” ");
INSERT INTO bhd_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","किजोकि हेरोदेसे परमेशरेरी तारीफ़ न की, तैल्हेरेलेइ तैस परमेशरे स्वर्गदूतेरी एरी मार पेई कि तैसेरी सैरी जानी कीड़े लग्गे, ते तै मेरि जेव। ");
INSERT INTO bhd_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","पन परमेशरेरू बच्चन अग्रोवं बद्धतू जेवं, ते विश्वासी लोकां केरि गिनती बद्धती जेई। ");
INSERT INTO bhd_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ज़ैखन बरनबास ते शाऊल अपनि सेवा ज़ै तैन केरे सुपुर्द कियोरी थी, तैनेईं पूरी की त अन्ताकिया नगरेरां यरूशलेम नगरे जो वापस आए, ते यूहन्ना ज़ैस जो मरकुस ज़ोते थिये, एप्पू सेइं साथी आनो। ");
INSERT INTO bhd_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अन्ताकिया नगरेरे कलीसियाई मां काई नबी ते गुरू थिये, मतलब बरनबास, शमौन ज़ैस जो नीगर भी ज़ोतन, लूकियुस कुरेनी, ते मनाहेम ज़ै मुलखेरे च़ेवरोवं हिसे पुड़ हाकिम थियो ज़ै हेरोदेसेरो दुद्ध ढ्ला थियो, ते शाऊल थियो। ");
INSERT INTO bhd_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ज़ैखन तैना बरत रेखतां प्रभुएरी आराधना केरने लग्गोरो थिये, त पवित्र आत्मा तैन सेइं ज़ोवं, “ज़ैस सेवारे लेइ बरनबास ते शाऊल मीं कुजोरेन, तैसेरेलेइ तैन अलग केरा।” ");
INSERT INTO bhd_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","तैखन तैनेईं बरत रेखतां प्रार्थना की, ते तैन पुड़ हथ रेखतां तैना परमेशरेरे कम्मेरे लेइ भेज़े। ");
INSERT INTO bhd_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","शाऊल ते बरनबास पवित्र आत्मारी तरफां भेज़ोरे सिलूकिया नगरे जो जे, ते तैट्ठां तैना ज़िहाज़े पुड़ च़ेढ़तां साइप्रस टैपू जो च़ले। ");
INSERT INTO bhd_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ज़ैखन तैना सलमीसे मां पुज़े, त तैड़ी तैना यहूदी केरे प्रार्थना घरे मां परमेशरेरू वचन शुनाव, ते यूहन्ना मरकुस भी तैन केरि मद्दत केरनेरे लेइ तैड़ी थियो। ");
INSERT INTO bhd_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ज़ैखन तैनेईं सारे जज़ीरे ते नगरन-नगरन मां हंठु फिरू, त तैना पाफुसे नगरे मां पुज़े, त तैन केरि मुलाकात एक्की डैइंनोड़े यहूदी ते झूठे नेबी सेइं भोइ, ज़ेसेरू नवं बार-यीशु थियूं। ");
INSERT INTO bhd_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","तै तैट्ठेरे हाकिम सिरगियुस, पौलुस सेइं साथी थियो, ज़ै अक अक्लमन्द मैन्हु थियो, ते तैनी बरनबास ते शाऊल कुजाए ते परमेशरेरू वचन शुन्नू चाऊ। ");
INSERT INTO bhd_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","पन एलीमास डैइंनोड़ो (किजोकि तैसेरे नंव्वेरो मतलब डैइंनोड़ो ए) तैन केरि खलाफत केरने लगो, तैने हाकिम यीशु पुड़ विश्वास केरने करां रोकनो चाव। ");
INSERT INTO bhd_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","तैखन शाऊल ज़ेसेरू नवं पौलुस भी आए, पवित्र आत्माई सेइं भेरोइतां ध्याने सेइं एलीमास डैइंनोड़ेरे पासे तकने लगो, ते तैस सेइं ज़ोवं, ");
INSERT INTO bhd_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“हे शैतानेरे कोआ, तू हर किसमेरी पाखंडे सेइं ते च़लैकी सेइं भेरतस, ते नेकारो दुश्मन, कुन तू परमेशरेरी बत बगाड़ने करां बाज़ न एजस? ");
INSERT INTO bhd_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","हुनी प्रभु तेरे खलाफे, तू कानो भोइगानोस, ते किछ च़िरे तगर तू दिहाड़ो न लाएलो।” तैखने तैस आंधरू लेइयोने लगू, ते तै इरां-उरां तोपने लगो, ताके कोई तैस हथेरां ट्लेइतां च़लाए। ");
INSERT INTO bhd_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","तैखन हाकिमे एन हेरतां, ते प्रभुएरी शिक्षा शुन्तां हैरान राव, ते प्रभु यीशु पुड़ विश्वास कमाव। ");
INSERT INTO bhd_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पौलुस ते तैसेरो साथी पाफुस नगरेरां ज़िहाज़े मां पंफूलिया इलाकेरे पिरगा नगरे मां आए, ते यूहन्ना तैन शैरतां वापस यरूशलेम नगरे जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ते तैना पिरगा नगरेरां निस्तां पिसिदिया इलाकेरे अन्ताकिया नगरे मां पुज़े ज़ै गलतिया इलाके मां आए। ते आरामेरे दिहाड़े प्रार्थना घरे मां गेइतां बिश्शी जे। ");
INSERT INTO bhd_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","मूसेरो कानून ते नेबी केरि किताबी मां पढ़नेरे बाद तैट्ठेरे प्रार्थना घरेरे प्रधाने तैन ज़ोवं, “अगर मैन्हु केरि भलैइयरे लेइ तुस भी किछ ज़ोनू चातथ त ज़ोथ।” ");
INSERT INTO bhd_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","तैखन पौलुस खड़ो उठो ते हथ्थे सेइं इशारो केरो कि च़ुप रान ते ज़ोने लगो, “हे इस्राएली लोकव ते परमेशरेरो डर मन्नेबाले गैर कौमां केरे लोकव मेरी गल शुना। ");
INSERT INTO bhd_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इन इस्राएली लोकां केरे परमेशरे इश्शे दादे-पड़दादे च़ुने, ज़ैखन तैना मिस्र मुलखे मां परदेशी भोइतां रहते थिये, तैन परमेशरे तरक्की दित्ती, ते बड़े शेक्ति सेइं तैट्ठां कढे। ");
INSERT INTO bhd_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ते तै सुनसान ठैरी मां लगभग 40 सालन तगर तैन केरि झ़ैल्लतो राव, तैना बार-बार हुक्म ट्लोड़ते राए। ");
INSERT INTO bhd_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","कनान मुलखे मां परमेशरे सत कौमां नाश केरतां तैन केरि ज़मीन अपने इस्राएली लोकन विरासती मां दित्ती। ");
INSERT INTO bhd_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","एना गल्लां पूरी भोने लगभग 450 साल लगे, तैसेरां बाद परमेशरे तैन केरे लेइ शमूएल नेबेरे वक्ते तगर हाकिम रखे। ");
INSERT INTO bhd_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ज़ैखन हेजू शमूएल तैन केरो हाकिम थियो त तैन लोकेईं राज़ो बनानेरे लेइ दरखुवास की, ते परमेशरे बिन्यामीनेरे गोत्रे मरां कीशेरू मट्ठू शाऊल राज़ो बनावं ते तैनी 40 साल यरूशलेम नगरे मां राज़ कियूं। ");
INSERT INTO bhd_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","फिरी तैनी शाऊल हटेइतां दाऊद तैसेरी ठैरी तैन केरो राज़ो बनाव, ज़ेसेरे बारे मां तैनी गवाही दित्ती, मीं यिशैरू मट्ठू दाऊद मेरे मनेरे मुताबिक मैलोरूए, तैस पुड़ अवं खुश आईं, ते तैए मेरी मर्ज़ी पूरी केरेलो। ");
INSERT INTO bhd_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","परमेशरे अपने वादेरे मुताबिक तैसेरे वंशेरे मरां पापन करां मुक्ति देनेरे लेइ इस्राएले कां यीशु मसीह भेज़ो। ");
INSERT INTO bhd_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ज़ेसेरे एजने करां पेइले यूहन्ना इस्राएलेरे सारे लोकन प्रचार कियो, कि पापन करां मनफिराथ ते बपतिस्मो नेथ।” ");
INSERT INTO bhd_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ज़ैखन यूहन्नारू कम पूरू भोनेबालू थियूं, त तैनी ज़ोवं, “तुस मीं कुन समझ़तथ? ‘अवं मसीह नईं!’ बल्के हेरा, तै मेरे बाद एजनेबालोए, किजोकि अवं त एस काबल नईं कि तैसेरे बूटां केरे तसमे भी खोल्ली सेखी।” ");
INSERT INTO bhd_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“हे मेरे ढ्लाव, तुस ज़ैना अब्राहमेरे औलादारे लोकव, ते परमेशरेरो डर मन्नेबाले गैर कौमां केरे लोकव, इस मुक्तरो बिस्तार तुसन कां भेज़ेरोए। ");
INSERT INTO bhd_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","यरूशलेम नगरेरे रानेबाले लोकेईं ते तैन केरे प्रधानेईं यीशु मसीह न पिशानो, ते न नेबी केरि गल्लां सेमझ़ी, ज़ैना हर आरामेरे दिहाड़े पेढ़तां शुनेई गैती थी। ");
INSERT INTO bhd_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","हालांकी तैन मौतरी सज़ारे काबल सबूत न मैल्लू, पन फिरी भी तैनेईं पिलातुस गवर्नरे कां दरखुवास की, कि ए मारो गाए। ");
INSERT INTO bhd_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ते तैनेईं सब किछ ज़ैन तैसेरे बारे मां पवित्रशास्त्रे मां लिखोरू थियूं, पूरू कियूं, त तै क्रूसे पुड़ कील देइतां मारो, ते ओसैलतां एक्की कब्री मां छ़ड्डो। ");
INSERT INTO bhd_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","पन परमेशरे तै मुड़दन मरां भी ज़ींतो कियो। ");
INSERT INTO bhd_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ते ज़ैना लोक गलील इलाके मरां तैस सेइं साथी यरूशलेम नगरे मां ओरे थिये, तैन चेलन काई दिहाड़न तगर यीशु लेइयोतो राव, ते हुनी तैना लोक ज़ैनेईं तै लाहोरोए गवाही देतन। ");
INSERT INTO bhd_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","असां तुसन खुशखबरी शुनातम, कि ज़ै वादो परमेशरे इश्शे दादे-पड़दादन सेइं कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","कि परमेशरे यीशु मसीह मुड़दन मरां ज़ींतो केरतां तै वादो पूरू कियो, ते भजना केरि किताबी मां परमेशर मसीहेरे बारे मां ज़ोते, तू मेरू मट्ठूस ते अवं तेरो बाजी भोव। ");
INSERT INTO bhd_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","एन सच़्च़े, कि परमेशरे तै मुड़दन मरां भी ज़ींतो कियो, ताके तै न शड़े, परमेशरे बचने मां एन्ने बियांन कियोरूए, कि अवं तीं पवित्र ते सच़्च़ी बरकत देलो, ज़ैन केरो वादो परमेशरे दाऊदे सेइं कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ते होरि भजने मां दाऊद ज़ोते, तू अपने पवित्र मैन्हु शड़ने न देलो। ");
INSERT INTO bhd_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","किजोकि दाऊद त अपने वक्ते मां परमेशरेरी मर्ज़ी पूरी केरनेरां पत्ती मेरि जेव, ते अपने दादन-पड़दादन सेइं साथी दफन भोव, ते तैसेरी जान शैड़ी जेई। ");
INSERT INTO bhd_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","पन ज़ै (यीशु मसीह) परमेशरे मुड़दन मरां ज़ींतो कियो, त तैसेरे शड़नेरी नौबत न आई। ");
INSERT INTO bhd_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“एल्हेरेलेइ, हे ढ्लाव, बुझ़ा कि यीशुएरे ज़िरिये सेइं तुसन पापां केरि मैफारी खबर शुनाई गाचे। ");
INSERT INTO bhd_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","तुस मूसा नेबेरे कानूने मुताबिक धर्मी न थी भोने, पन ज़ै कोई यीशु पुड़ विश्वास केरे तै धर्मी भोए। ");
INSERT INTO bhd_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","“एल्हेरेलेइ खबरदार राथ, कोस्कोई एरू न भोए कि नेबी केरि ए गल तुसन पुड़ सच़्च़े बीते, ");
INSERT INTO bhd_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","तुस ज़ैना होरि केरि तुहीन केरतथ, हेरा, ते हैरान भोथ, ते बरबाद भोथ, किजोकि अवं तुश्शे ज़ींते ज़ागते एरू कम केरनेबालोईं, कि अगर कोई तुसन सेइं तैसेरे बारे मां गलबात भी केरे, त तुस कधे विश्वास न केरेले।” ");
INSERT INTO bhd_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ज़ैखन पौलुस ते बरनबास प्रार्थना घरे मरां च़ले, त लोक तैन कां मिनत केरतां ज़ोने लगे, कि होरि आरामेरी दिहाड़ी भी एन्ने गल्लां केरे बारे मां ज़ोवं गाए। ");
INSERT INTO bhd_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ज़ैखन लोक आराधनारे बाद बेइर निस्से, त बड़े लोक पौलुस ते बरनबासे पत्ती च़ले, ते तैन मां किछ यहूदी थिये, ते किछ नंव्वे यहूदी पंथ धारण कियोरे थिये, ते तैनेईं तैन सेइं गलबात केरतां तैन समझ़ाव, कि परमेशरे अनुग्रहे मां बनोरे राथ। ");
INSERT INTO bhd_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","होरि आरामेरे दिहाड़े लगभग सारू नगर परमेशरेरू वचन शुन्नेरे लेइ अकोट्ठू भोवं। ");
INSERT INTO bhd_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ज़ैखन यहूदी लीडरेईं एत्रे हछे लोक लाए त तैन जलन भोइ, ते पौलुसेरे खलाफ गल्लां लग्गे केरने। ");
INSERT INTO bhd_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","तैखन पौलुस ते बरनबासे दिलेर भोइतां तैन ज़ोवं, “ज़रूरी एन थियूं, कि असां पेइले तुसन परमेशरेरू बच्चन शुनाम, पन तुस त इन्कार केरने लोरेथ, ते अपनो आप हमेशारी ज़िन्दगरे काबल न समझ़थ, त हेरा हुनी असां गैर कौमां केरे पासे गातम। ");
INSERT INTO bhd_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","किजोकि प्रभुए असन ई हुक्म दित्तोरोए, मीं तू मीं तू गैर कौमां केरे लेइ लौ बनोरस, ताके तुश्शे ज़िरिये सारे ज़मीनी पुड़ मुक्ति आनी गाए, ते तू ज़मीनरे हर पासे मुक्तरू दार भोस।” ");
INSERT INTO bhd_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","इन शुन्तां गैर कौमां केरे लोक बड़े खुशी भोए, ते परमेशरेरी तारीफ़ केरने लगे, ते ज़ैना परमेशरे हमेशारी ज़िन्दगरे लेइ ठहरावरे थिये, तैनेईं विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ते प्रभुएरू बच्चन सारे मुलखे मां फैली जेवं। ");
INSERT INTO bhd_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","पन यहूदी लीडरेईं बड़े भक्त ते इज़्ज़तदार कुआन्शां ते नगरेरे काई खास मैन्हु भड़काए, तैनेईं पौलुस ते बरनबासे सितेइतां तैना तैस इलाके मरां भी केढी छ़डे। ");
INSERT INTO bhd_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","तैखन पौलुस ते बरनबासे तैन केरे सामने अपने पावां केरि धूड़ ठुड़कतां तैना इकुनियुम नगरे जो च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ते चेले इकुनियुम नगरे मां खुशी ते पवित्र आत्माई सेइं भरपूर भोते राए। ");
INSERT INTO bhd_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","इकुनियुम नगरे मां पौलुस ते बरनबास दुइये ज़ने प्रार्थना घरे मां जे, ते एरू भाषण केरने लगे ते बड़े यहूदी लोकेईं ते यूनानी लोकेईं विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","पन विश्वास न केरनेबाले यहूदेईं, गैर यहूदी लोक भड़काए ते तैनेईं विश्वासी मैन्हु विश्वासे करां दूर किये, ते तैन केरे खलाफ क्रोध पैदा कियो। ");
INSERT INTO bhd_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ते पौलुस ते बरनबास काई दिहाड़े तैड़ी राए, ते प्रभुएरी भरोसे पुड़ दिलेरी सेइं गल्लां केरते थिये, ते प्रभु तैन केरे ज़िरिये चमत्कार ते निशान करेइतां अपने अनुग्रहेरे वचने सच़्च़ो साबत केरतो राव। ");
INSERT INTO bhd_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","पन नगरेरे लोकन एप्पू मांमेइं फूट भोइजेइ, किछ लोक यहूदी केरे पासे भोए, ते किछ प्रेरितां केरे पासे भोए। ");
INSERT INTO bhd_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","यहूदी ते गैर यहूदी अपने प्रधान्न सेइं मिलतां तैन बेइज़त केरने ते तै घोड़ेईं बाने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","त तैन एस गल्लरो पतो लगो, तैना तैट्ठां नेश्शी जे, ते लुकाउनिया इलाकेरे नगरन लुस्त्रा ते दिरबे मां ते तैसेरे आसे-पासेरे इलाके मां च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ते तैड़ी तैना खुशखबरी शुनाने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्त्रा नगरे मां अक मैन्हु बिशोरो थियो, ज़ै पांवां केरो कमज़ोर थियो, तै ज़र्मनेरो टोन्टो थियो, ते तै कधी न थियो च़लोरो। ");
INSERT INTO bhd_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","तै पौलुसेरी गल्लां ध्याने सेइं शुन्ने लग्गोरो थियो, पौलुसे तैसेरे पासे ध्याने सेइं तक्कू त ज़ांनू, कि एसमां एत्रो विश्वासे कि ए बेज़्झ़ोइ सकते। ");
INSERT INTO bhd_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ते पौलुसे तैस मैन्हु ज़ोरे सेइं ज़ोवं, “अपने पावन पुड़ खड़ो भो।” ते तै तैखने खड़ो भोव, ते च़लने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ज़ैखन लोकेईं पौलुसेरू एन कम हेरू त लुकाउनिया भाषाई मां ज़ोरे सेइं ज़ोने लगे, “कि देबतो असन कां मैनेरो शकली मां ओरोए।” ");
INSERT INTO bhd_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ते तैन लोकेईं बरनबासेरू नवं ज्यूस रख्खू, (ज़ैन यूनानी देबतेरू नवं थियूं), ते पौलुसेरू हिर्मेस नवं रख्खू, (ज़ै होरि देबतां केरो बिस्तार देने बालन मरां प्रधान थियो) किजोकि तै गल्लां केरने मां जादे माहिर थियो। ");
INSERT INTO bhd_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ते ज्यूस देबतेरू मन्दर नगरेरे सामने थियूं, तैसेरो पुजारी दांत ते फूड़ू केरे हार एन्तां नगरेरे फाटके पुड़ पुज़ो, किजोकि तैना लोक चाते थिये कि असां प्रेरितां केरे लेइ बलिदान केरन। ");
INSERT INTO bhd_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ज़ैखन बरनबास ते पौलुस प्रेरितेईं एन शुनू, त तैना दुखी भोए, ते तैनेईं अपना लिगड़ां छ़िन्दां ते मैनन् मां जे ते ज़ोरे-ज़ोरे ज़ोने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“लोकव तुस एन कुन केरने लगोरेथ? असां भी तुश्शे ज़ेरे दुःख सुख झ़ैल्लने बाले मैन्हु आम, ते तुसन खुशखबरी शुनातम, ताके तुस एना फुज़ूल चीज़ां शैरतां ज़ींते परमेशरेरे पासे एज्जथ, ज़ैनी धरती त कने अम्बर ते समुन्द्रे ते ज़ैन किछ भी एसमां आए तैनी बनोरूए। ");
INSERT INTO bhd_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","तैनी बीतोरे वक्ते मां सैरी कौमन अपनि-अपनि बत्तां च़लने दित्तू। ");
INSERT INTO bhd_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","फिरी भी तैनी अपनो आप बेगवाह न बनाव, पन अपनि भलाई हेरानेरे लेइ तैनी अम्बरेरां झ़ड़ी दित्ती, ते फसलां केरे लेइ मौसम बनाए, ताके तुसन हछु अन भोए ते तुश्शे दिल खुशी सेइं भरे।” ");
INSERT INTO bhd_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","एना गल्लां ज़ोइतां तैनेईं लोक बेड़ि मुशकली सेइं रोके, कि एना इश्शे लेइ बलिदान न देन। ");
INSERT INTO bhd_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","तैखन किछ यहूदी अन्ताकिया नगरे ते इकुनियुम नगरे मरां आए, ते तैनेईं लोक अपने पासे केरतां पौलुसे पुड़ पथराव केरने लगे, ते तै मुओरो बुझ़तां नगर करां बेइरोवं घसीटतां नीयो। ");
INSERT INTO bhd_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ज़ैखन चेले तैड़ी पुज़े त तैनेईं पौलुस घरे मां आनो ते तै खड़ो उठो ते वापस नगर मां अव, ते होरसां बरनबासे सेइं साथी दिरबे नगरे जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","पौलुस ते बरनबासे तैस नगर मां खुशखबरी शुनाई ते बड़े चेले बनाए, ते तैसेरां बाद तैना लुस्त्रा ते इकुनियुम नगरे ते अन्ताकिया नगरे मां वापस आए। ");
INSERT INTO bhd_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","तैना हर एक्की नगरेरे चेलां केरे मन मज़बूत केरते ते ई शिक्षा देते थिये कि विश्वासे मां बनोरे राथ, ते इन ज़ोते थी, “ते असेईं बड़ो दुःख झ़ैल्लतां परमेशरेरे राज़्ज़े मां दाखल भोनूए।” ");
INSERT INTO bhd_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ते तैनेईं हर कलीसियाई मां तैन केरे बुज़ुर्ग ठहराए, ते बरतां रेखतां प्रार्थना की, ते तैना प्रभुएरे सुपुर्द किये, ज़ैस पुड़ तैनेईं विश्वास कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","फिरी तैना पिसिदिया इलाके मरां निस्तां पंफूलिया इलाके मां पुज़े। ");
INSERT INTO bhd_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ते पिरगा नगरे मां वचन शुनेइतां त अत्तलिया नगरे मां आए। ");
INSERT INTO bhd_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","तैट्ठां ज़िहाज़े मां च़ेढ़तां वापस अन्ताकिया नगरे मां आए, ते तैड़ी तैनेईं तैस सेवारे लेइ ज़ै तैनेईं पूरी कियोरी थी, परमेशरेरे अनुग्रहेरे सुपुर्द कियोरी थी। ");
INSERT INTO bhd_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","अन्ताकिया नगरे मां पुज़तां तैनेईं कलीसियारे लोक अकोट्ठे किये, कि परमेशरे असन सेइं साथी भोइतां केरहां-केरहां बडां कम्मां कियां! ते गैर कौमां केरे लेइ बत खोल्ली, कि तैना भी यीशु पुड़ विश्वास केरन। ");
INSERT INTO bhd_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ते तैना चेलन सेइं साथी बड़े दिहाड़न तगर राए। ");
INSERT INTO bhd_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","फिरी किछ लोक यहूदिया इलाके मरां आए, ते विश्वासी ढ्लान ए शिक्षा देने लगे, “अगर मूसेरे रसमरे मुताबिक तुश्शो खतनो नईं भोरो त तुसन मुक्ति न मैल्ली बटे।” ");
INSERT INTO bhd_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","एस गल्ली पुड़ पौलुस ते बरनबासेरो तैन लोकन सेइं बड़ो मतभेद ते बड़ी बेंस भोइ, ते कलीसियारे लोकेईं पौलुस ते बरनबास ते किछ होरे मैन्हु च़ुने कि तैना यरूशलेम नगरे मां गेइतां तैड़ी एस मसले पुड़ प्रेरितन ते बुज़ुर्गन सेइं गलबात केरतां हल कढन। ");
INSERT INTO bhd_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","तैखन कलीसियारे लोकेईं तैना खर्च़ो देइतां भेज़े, ते ज़ैखन तैना फीनीके ते सामरियारे इलाकन मांमेइं च़लोरे थिये, तैनेईं ज़ोवं, कि केन्च़रे गैर कौमां केरे लोक खुशखबरी शुन्तां मसीह पुड़ विश्वास कियो, ते कलीसियाई मां शामल भोए, एन शुन्तां सारे मसीह ढ्ला बड़े खुश किये। ");
INSERT INTO bhd_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ज़ैखन तैना यरूशलेम नगरे मां पुज़े, त तैठेरी कलीसियारे लोक ते प्रेरित ते बुज़ुर्ग तैन सेइं बेड़ि खुशी सेइं मिले, ते तैखन पौलुस ते बरनबासे सब किछ बिस्तार दित्तो, कि परमेशरे तैन केरे ज़िरिये सेइं केत्रा-केत्रा कम्मां कियां। ");
INSERT INTO bhd_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","पन फरीसी पंथेरे किछ लोकेईं ज़ैनेईं विश्वास कियोरो थियो, तैन मरां किछ ज़ोने लगे, “गैर कौमन मरां विश्वास केरनेबालां केरो खतनो कियोरो लोड़े, ते एन मूसा नेबेरे कानूने पुड़ अमल केरनेरो हुक्म दित्तोरो लोड़ते।” ");
INSERT INTO bhd_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","तैखन प्रेरित ते बुज़ुर्ग ए गलबात केरनेरे लेइ अकोट्ठे भोए। ");
INSERT INTO bhd_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","बड़ी बेंस भोनेरे बाद पतरसे तैन खड़े भोइतां ज़ोवं, “हे मेरे ढ्लाव, तुस ज़ानतथ कि बड़े च़िरे पेइले परमेशरे अवं तुसन लोकन मरां च़ुनो, ताके गैर कौमन मेरे ज़िरिये खुशखबरी शुनाई गाए ते तैना विश्वास केरन। ");
INSERT INTO bhd_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","परमेशर ज़ै दिलेरो हाल ज़ानते, तैनी तैन भी इश्शी ज़ेरि पवित्र आत्मा देइतां इन हिराव, कि परमेशरे तैना अपने लोकां केरे ज़ेरे कबूल किये। ");
INSERT INTO bhd_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ते विश्वास केरनेरे ज़िरिये सेइं तैन केरे मन पवित्र केरतां असन मां ते तैन मां कोई फर्क न रख्खो। ");
INSERT INTO bhd_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","त हुनी तुस परमेशरेरी अज़मैइश किजो केरतथ? कि गैर कौमन मरां ओरे चेलन (यानी विश्वासी लोकन) पुड़ एत्रो बोझ किजो रखतथ, ज़ै न असेईं छ़ुइयोए ते न इश्शे दादे-पड़दादे छ़ुइयोए। ");
INSERT INTO bhd_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","एरू केरनू ठीक नईं, किजोकि इश्शू याकीन त इने कि प्रभु यीशु मसीहेरे अनुग्रह सेइं तैन केरे पापां केरि मुक्ति भोली, तेन्च़रे इश्शी मुक्ति भोली, न कि मूसेरे कानूने सेइं।” ");
INSERT INTO bhd_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","तैखन सारे लोक च़ुपच़ाप बरनबास ते पौलुसेरी गल्लां शुन्ने लग्गे, कि परमेशरे केन्च़रे गैर कौमन मां तैन केरे ज़िरिये केरहे-केरहे निशान ते चमत्कार किये। ");
INSERT INTO bhd_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ज़ैखन तैना च़ुप भोए त याकूब ज़ोने लगो, “मेरे ढ्लाव मेरी गल शुना।” ");
INSERT INTO bhd_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","शमौन पतरसे रोड़ेच़ारे ज़ोवं, कि परमेशरे पेइले केन्च़रे गैर कौमन पुड़ सिद्धी नज़र की, ताके तैन मरां मैन्हु च़ुनतां अपने लोक बनाए। ");
INSERT INTO bhd_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","नेबी केरू बच्चन भी एसेरू ज़ेरूए ज़ेन्च़रे लिखोरूए कि। ");
INSERT INTO bhd_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","एसेरां बाद अवं फिरी एइतां दाऊदेरू राज़ बनेइलो, ज़ैन तैसेरे दुश्मनेईं नाश कियोरू थियूं। ");
INSERT INTO bhd_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ताके बाकी सारे लोक ते गैर कौमन समेत ज़ैना मीं कुजोरेन मेरे लोक भोन, ते मीं तोप्पन। ");
INSERT INTO bhd_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ए तैए प्रभु ज़ोते ज़ै दुनियारे शुरुआती करां इन गल्लां केरि खबर देतो अव। ");
INSERT INTO bhd_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“एल्हेरेलेइ मेरो खियाल ईए, गैर कौमन मरां ज़ैना लोक परमेशरे कां एइतन, तैन अस यहूदी केरो कानून मन्नेरे लेइ मजबूर न केरम। ");
INSERT INTO bhd_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","बल्के तैन चिट्ठी लिखतां एन ज़ोम कि मूरतन कां च़ैढ़ोरी चीज़ां करां दूर रान, ते बदमैशी ते गलचैटी देइतां मारोरे जानवरां केरू मास न खान ते खून न खान। ");
INSERT INTO bhd_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","किजोकि बड़े पेइले नगर-नगरे मां मूसेरे कानूनेरो प्रचार केरनेबाले भोते आए, ते तैना हर आरामेरे दिहाड़े प्रार्थना घरे मां पेढ़ी गाती थी।” ");
INSERT INTO bhd_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","तैखन प्रेरित ते बुज़ुर्ग ते सारी यरूशलेमेरे सारे कलीसिया मिलतां एन रोड़ू समझ़ू, कि असन मरां किछ मैन्हु च़ुने गान, मतलब यहूदा, ज़ैस जो बरसब्बास ज़ोतन ते सीलास ज़ैना ढ्लान मां खास आन, ते तैन पौलुस ते बरनबासे सेइं साथी अन्ताकिया नगरेरे कलीसियाई मां भेज़म। ");
INSERT INTO bhd_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ते तैनेईं तैन केरे हथ्थे इन लिखतां भेज़ू, “अन्ताकिया नगरे ते सीरिया ते किलिकिया इलाकां केरे रानेबाले विश्वासी ढ्लान ज़ैना गैर कौमन मरां आन, प्रेरितां ते बुज़ुर्ग ढ्लां केरू नमस्कार! ");
INSERT INTO bhd_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","असेईं शुनेरूए, कि किछ मैन्हु बगैर अजाज़तां तुश्शे इड़ी आए, ते तैनेईं अपनि गल्लेईं सेइं तुश्शो दिल परेशान कियो। ");
INSERT INTO bhd_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","एल्हेरेलेइ असेईं एन ठीक समझ़ू, कि इट्ठां दूई मैन्हु अपने ट्लारे बरनबास ते पौलुस सेइं साथी तुसन कां भेज़म। ");
INSERT INTO bhd_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","एना एरे मैन्हु आन कि ज़ैन इश्शे प्रभु यीशु मसीहेरे लेइ अपनि जानरी भी परवाह नईं। ");
INSERT INTO bhd_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","एल्हेरेलेइ असेईं यहूदा ते सीलास भेज़ोरेन, ते तैना एप्पू भी एना गल्लां शुनाले। ");
INSERT INTO bhd_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","पवित्र आत्मा, ते असेईं एन ठीक समझ़ू, कि इना ज़रूरी गल्लां केरे अलावा तुसन पुड़ होरो बोझ न देम। ");
INSERT INTO bhd_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","बस्सा तुस मूरतन कां च़ाढ़ोरे बलिदाने ते खून करां ते गल दुबेइतां मारोरे जानवरे करां ते बदमाशी केरने करां दूर राथ एन तुश्शे लेइ रोड़ू भोलू। अग्रोवं जो शुभकामना” ");
INSERT INTO bhd_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","बस्सा तैना मैन्हु च़लते-च़लते अन्ताकिया नगरे मां पुज़े, तैड़ी तैनेईं कलीसियारे लोक अकोट्ठे केरतां ए चिट्ठी तैन केरे हवाले की। ");
INSERT INTO bhd_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","तैना चिट्ठी मां लिखोरी गल्लां पेढ़तां बड़े खुशी भोए। ");
INSERT INTO bhd_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहूदा ते सीलास एप्पू भी नबी थिये, तैनेईं तैट्ठेरे विश्वासी ढ्लान शिक्षा दित्ती ते तैना विश्वासे मां पक्के बनाए। ");
INSERT INTO bhd_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","किछ दिहाड़ना बाद तैट्ठेरे विश्वासी ढ्लाएईं आनन्दे सेइं ते प्रार्थना केरतां वापस भेज़े, ताके अपने भेज़ने बालन कां वापस गान। ");
INSERT INTO bhd_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","सीलासे अन्ताकिया नगरे मां रानेरो फैसलो कियो ते यहूदा अकैल्लो वापस यरूशलेमे जो अव। ");
INSERT INTO bhd_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ते पौलुस ते बरनबास अन्ताकिया नगरे मां रुकी जे, तैड़ी तैना काई होरि लोकन सेइं मिलतां लोकन प्रभु यीशुएरे वचनेरी शिक्षा देंते राए ते खुशखबरी शुनाते राए। ");
INSERT INTO bhd_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","किछ च़िरेरां बाद पौलुसे बरनबास सेइं ज़ोवं, “च़ल असां तैन सारे नगरन मां गाम, ज़ैड़ी असेईं खुशखबरी शुनावरी थी, ते तैन विश्वासी ढ्लान सेइं मुलाकात केरम, ते हेरम कि तैन केरो कुन हाले।” ");
INSERT INTO bhd_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","तैखन बरनबासे यूहन्ना ज़ैस जो मरकुस ज़ोतन, साथी नेनो चाव। ");
INSERT INTO bhd_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","पन पौलुसे ठीक न समझ़ू, कि यूहन्ना तैन सेइं साथी गाए, किजोकि तै पंफूलिया इलाके मां कम शैरतां अलग भोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","पौलुस त बरनबासे एप्पू मांमेइं बड़ी अनबन भोइ, ते तैना अलग भोए, बरनबास ते मरकुस ज़िहाज़े मां साइप्रस जो च़लो जे। ");
INSERT INTO bhd_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पन पौलुसे सीलास एप्पू साथी नीयो, ते विश्वासी ढ्लाएईं तैन केरे लेइ प्रार्थना की, ते तैना परमेशरेरे अनुग्रहेरे सुपुर्द किये ते तैना तैट्ठां च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","पौलुस सीरिया ते किलिकिया इलाकन मांमेइं निस्सो च़लतो ते कलीसियां केरे विश्वासी लोकन मज़बूत केरतो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","तैना फिरी दिरबे नगरे ते लुस्त्रा नगरे मां आए, तैड़ी अक चेलो तीमुथियुस नव्वेंरो रातो थियो, तैसेरी अम्मा यहूदी थी, ते तै मसीह पुड़ विश्वास केरती थी, पन तैसेरो बाजी यूनान मुलखेरो रानेबालो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","तीमुथियुस लुस्त्रा नगरे मां ते इकुनियुम नगरेरे विश्वासी ढ्लान मां बड़ो रोड़ो मैन्हु थियो। ");
INSERT INTO bhd_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पौलुसेरी इच्छा ई थी, कि तै तैस साथी ने, तैन यहूदी केरि वजाई ज़ैना तैड़ी रहते तैसेरो खतनो कियो, किजोकि तैना सब ज़ानते थी कि तैसेरो बाजी यूनान मुलखेरो रानेबालो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","पौलुस ते तैसेरे साथी नगर-नगरे मांमेइं च़लते जे, तैट्ठेरे विश्वासी लोकन तैना हुक्मां केरे बारे मां ज़ोंते जे, ज़ैना यरूशलेम नगरे मां प्रेरितेईं ते बुज़ुर्गेईं मिलतां ठहरावरे थिये, ताके लोक तैन पुड़ अमल केरन। ");
INSERT INTO bhd_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","बस्सा कलीसियां विश्वासे मां पेक्की भोती जेई, ते तैन केरि कलीसियां केरि तैधात बद्धती जेई। ");
INSERT INTO bhd_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","पौलुस ते तैसेरे साथी फ्रूगिया ते गलातिया इलाकन मांमेइं निस्तां जे, किजोकि पवित्र आत्मा तैना आसिया इलाके मां बच्चन शुनाने करां रोकोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ते तैना मूसिया इलाकेरे नेड़े पुज़तां, बितूनिया इलाके मां गानू चाते थिये, पन यीशुएरे आत्मा गाने न दित्ते। ");
INSERT INTO bhd_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","एल्हेरेलेइ तैना मूसिया इलाकेरे नेड़ेरां त्रोआस नगरे मांजो च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","राती पौलुसे अक मैन्हु दर्शने मां लाव, “तै मकिदुनी इलाकेरो थियो, तै खड़ो भोइतां पौलुसे कां मिनत केरने लोरो थियो, कि पार समुन्दरेरे मकिदुनिया इलाके मां एइते इश्शी मद्दत केर।” ");
INSERT INTO bhd_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","तैसेरे इस दर्शन हेरनेरां पत्ती लूशी अस पार मकिदुनिया इलाके मां गानेरे लेइ तियार भोइ जे, किजोकि असेईं बुझ़ू कि परमेशरेरी असां तैड़ी खुशखबरी शुनानेरे लेइ कुजवरेम। ");
INSERT INTO bhd_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","असां त्रोआस नगरेरां ज़िहाज़े मां जे, ते पैनेरू सफर केरतां सुमात्राके टैपू पुड़ आए, ते तैट्ठां होरसां नियापुलिस नगरे मां आए। ");
INSERT INTO bhd_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","तैट्ठां असां फिलिप्पी नगरे मां पुज़े, ज़ैन मकिदुनिया इलाके मां खास नगरे, ते रोमी केरि बेसती मांए, ते अस तैस नगरे मां किछ दिहाड़े राए। ");
INSERT INTO bhd_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","आरामेरे दिहाड़े असां नगरेरे फाटके मरां निस्तां दरियाए पुड़ पुज़े, किजोकि असन उमीद थी कि तैड़ी यहूदी केरि प्रार्थना केरनेरी कोई ठार भोनीए, असां तैड़ी गेइतां बिश्शी जे, तैड़ी किछ कुआन्शां थी, असां तैन सेइं गल्लां केरने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","इश्शी गल्लां शुन्ने बैली कुआन्शन मां अक परमेशरेरी भक्त लुदिया नव्वेंरी थी, तै थुआतीरा नगरेरी राने बाली थी, ते बैंगनी लिगड़ां बेच़ने बाली थी, ते प्रभुए तैसेरो मन खोल्लो, कि तै पौलुसेरे गल्लन पुड़ ध्यान केरे। ");
INSERT INTO bhd_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ज़ैखन तैसां ते तैसारे पूरे टब्बरे बपतिस्मो नीयो त तै बिनती केरतां ज़ोने लगी, “अगर तुस लोक मीं प्रभुएरी ईमानदार दासी समझ़तथ, त मेरे घरे च़ला ते बिश्शी राथ,” ते तैसारी मिनत शुन्तां असां खुशी भोए। ");
INSERT INTO bhd_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","एक्की फेरे असां प्रार्थना केरनेरी ठारी जो च़लोरे थिये त असन अक दासी मैल्ली ज़ै भूतां केरे मद्दती सेइं एजनेबाले वक्तेरे बारे मां ज़ोती थी। ते अपने मालिकां केरे लेइ बड़े पेंइसे कमाती थी। ");
INSERT INTO bhd_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","तै पौलुसे पत्ती ते असन पत्ती च़ली ते ज़ोने लगी, “ए मैन्हु परमप्रधान परमेशरेरो दासे, ते एना असन पापां केरि मुक्तरी बत हिरातन।” ");
INSERT INTO bhd_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","तै काई दिहाड़े एन्ने केरती राई, पन पौलुसे जिच भोव, ते मुड़तां तैस भूते जो ज़ोवं, “अवं तीं यीशु मसीहेरे नंव्वे सेइं हुक्म देताईं निस्सी गा, ते तै तैखने तैस मरां निस्सी जेई।” ");
INSERT INTO bhd_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ज़ैखन तैसेरे मालिकेइं हेरू कि इश्शी कमैइयरी उमीद ट्लुटी जेई, त तैनेईं पौलुस ते सीलास ट्लेइतां चौके मां प्रधानां केरे हवाले किये। ");
INSERT INTO bhd_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","तैनेईं पौलुस ते सीलास हाकिमन कां पैश किये, ते ज़ोने लगे, “एना यहूदीन ते इश्शे नगर मां बड़ी खलबली मच़ाने लगोरेंन। ");
INSERT INTO bhd_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ते एरे रुवाज़ेरी शिक्षा देतन, ज़ैन केरू केरनू ते मन्नू असन रोमे मां रानेबालान केरे इश्शे लेइ बिलकुल भी ठीक नईं।” ");
INSERT INTO bhd_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","एन शुन्तां सारे लोक पौलुस ते सीलासेरे खलाफ अकोट्ठे भोए, ते हाकिमेईं तैन केरां लिगड़ां खोलतां छ़िन्दां ते सोटेईं बानेरो हुक्म दित्तो। ");
INSERT INTO bhd_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","सिपैहीयेइं तैन खूब बेंतेइं बैही ते कैदखाने मां छ़डे, ते कैदखानेरे प्रधाने हुक्म दित्तो, कि रोड़ेच़ारे पेरहो दित्तो गाए। ");
INSERT INTO bhd_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","तै हुक्म शुन्तां तैना आँधरी कोठी मां छ़डे, ते तैन केरे पावन लेकड़री बेड़ि लेइ। ");
INSERT INTO bhd_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","एध्धी राती पौलुस ते सीलास प्रार्थना केरने मां मघन थिये, ते परमेशरेरां भजना लोरे थी ज़ोने, ते होरे कैदी भी शुन्ने लोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","अचानक अक भुंज़ल अव, ते कैदखानेरे बुनीयाद हिल्ली ते सारां दारां खुल्ली जेआं, ते सैरी कैदी केरि बेड़ि भी खुल्ली जेई। ");
INSERT INTO bhd_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","कैदखानेरो प्रधान बींझ़ो ते खड़ो उठो, ते तकने लगो, ते हेरते कि कैदखानेरां दारां खुल्ली जोरेन, त तैनी समझ़ू कि सारे कैदी नश्शोरेन, ते तैनी अपनि तलवार खिच्ची कि अवं अपनो आप मैरी छ़ेड्डी। ");
INSERT INTO bhd_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","पन पौलुसे ज़ोरे सेइं ज़ोवं, “अपनो आप न मार किजोकि असां सब इड़ी आम।” ");
INSERT INTO bhd_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","तैखन तै दीयो बैलतां अन्तर जेव, ते पौलुसे ते सीलासेरे पावन पुड़ पेव, ");
INSERT INTO bhd_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","फिरी तैनी तैना बेइर आने ते ज़ोने लगो, “जनाब अवं कुन केरि, कि मेरी मुक्ति भोए?” ");
INSERT INTO bhd_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","तैनेईं ज़ोवं, “प्रभु यीशु मसीह पुड़ विश्वास केर, त तीं ते तेरे टब्बरे पापन करां मुक्ति मैल्लनीए।” ");
INSERT INTO bhd_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ते तैनेईं तैस त तैसेरे टब्बरे प्रभुएरू वचन शुनाव। ");
INSERT INTO bhd_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","तैखने तैने राती पौलुस ते सीलास नेइतां तैन केरे ज़खम धोए, ते तैनी तैसेरे सारे टब्बरे बपतिस्मो नीयो। ");
INSERT INTO bhd_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","फिरी तैनी तैना अपने घरे ने, ते तैन खाने जो रोट्टी दित्ती, ते सारे टब्बरे परमेशरे पुड़ विश्वास केरतां बड़े खुश थिये। ");
INSERT INTO bhd_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","होरसां झ़ेझ़ हाकिमेईं सिपाही भेज़तां बिस्तार भेज़ो, कि तैन मैनन् हथरां छ़ैडी देथ। ");
INSERT INTO bhd_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","दरोगा पौलुसे जो ज़ोवं, “हाकिमे हुक्म दित्तोरोए कि पौलुस ते सीलास कैदखाने मरां हथरां छ़डा, एल्हेरेलेइ तुस खुशी सेइं च़ले गाथ।” ");
INSERT INTO bhd_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","पन पौलुसे तैन सेइं ज़ोवं, “तैनेईं अस ज़ैना रोम मुलखेरे राने बालेम, बगैर कसूरे सेब्भी केरे सामने मारे कुटे ते कैदखाने मां छ़डे, ते हुनी च़ुपच़ारे हथरां छ़डने चाते? पन एन न भोइसखे, तै एप्पू एज्जे ते असन बेइर कढे।” ");
INSERT INTO bhd_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","सिपैहीयेइं गेइतां हाकिमन बिस्तार दित्तो, कि पौलुस ते सीलास रोम मुलखेरे राने बालेन, ते तैना डेरि जे। ");
INSERT INTO bhd_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","तैनेईं तैड़ी एइतां तैन करां माफ़ी मग्गी, ते फिरी तैना कैदखाने मरां बेइर आने ते मिनत की, कि नगर मरां च़ले गाथ। ");
INSERT INTO bhd_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","बस्सा पौलुस ते सीलास कैदखाने मरां बेइर निस्से ते लुदियारे घरे जे, ते तैड़ी विश्वासी ढ्लान सेइं मिले ते तैन शान्ति देइतां च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","पौलुस ते सीलास तैसेरां बाद अम्फिपुलिस ते अपुल्लोनिया नगरन मांमेइं गेइतां थिस्सलुनीके नगरे मां आए, तैड़ी यहूदी केरू अक प्रार्थना घर थियूं। ");
INSERT INTO bhd_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","पौलुस अपने रीतरे मुताबिक प्रार्थना घरे मां ट्लाई आरामेरे दिहाड़न तगर पवित्रशास्त्रेरी किताबी मरां तैन सेइं बेंस केरतो राव। ");
INSERT INTO bhd_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","पौलुस तैन केरो मतलब खोल्ली-खोल्ली समझ़ातो थियो, “कि यीशु मसीहेरो दुःख झ़ैल्लनो ते मुड़दन मरां ज़ींतू भोनू ज़रूरी थियूं, कि ज़ैस यीशुएरे बारे मां अवं प्रचार केरतम, तैए मसीह आए।” ");
INSERT INTO bhd_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","तैन मरां किछ यहूदी ते गैर कौमां केरे लोक ज़ैनेईं विश्वास कियोरो थियो, ते होरि भी बेड़ि भक्त कुआन्शां ज़ैनेईं विश्वास कियोरो थियो पौलुसे ते सीलासे सेइं मिली जेई। ");
INSERT INTO bhd_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","पन यहूदेईं जलनी सेइं काई नगरन मां बुरे लोक अकोट्ठे केरतां हंगामो केरनो शुरू कियो। तैनेईं यासोनेरे घरे पुड़ हमलो कियो ताके पौलुसे ते सीलासे लोकां केरे सामने आनन। ");
INSERT INTO bhd_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","पन ज़ैखन तैना न मैल्ले त यासोन त काई होरे विश्वासी ढ्ला घसीटतां नगरेरे हाकिमन कां आने, ते ज़ोरे-ज़ोरे सेइं ज़ोने लगे, “एन मैनेईं हर ठैरी परेशानी फैलावरी, ते अज़ इड़ी भी पुज़ोरेन। ");
INSERT INTO bhd_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ते एना यासोने अपने घरे मां रखोरेन, ते एना लोक महाराज़ेरे हुक्मेरी खलाफत केरतन, ते ज़ोतन कि राज़ो त यीशु आए।” ");
INSERT INTO bhd_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ए गल शुन्तां नगरेरे हाकिम ते सारे लोक परेशान भोए। ");
INSERT INTO bhd_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ते तैनेईं यासोन ते बाकी लोक ज़मानती पुड़ हथरां छ़डे। ");
INSERT INTO bhd_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ड्लोझ़ां विश्वासी ढ्लाएईं पौलुस ते सीलास तैट्ठां बिरीया नगरे जो भेज़े, ज़ैखन तैना तैड़ी पुज़े त तैना यहूदी केरे प्रार्थना घरे मां जे। ");
INSERT INTO bhd_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","बिरीया नगरेरे लोक थिस्सलुनीके नगरेरे यहूदन करां भले थिये, तांए तैनेईं खुशखबरी बेड़ि खुशी सेइं कबूल की, तैना रोज़ एना गल्लां केरे बारे मां गलबात केरते थिये, कि पौलुसेरी गल्लां सेच़्च़ी आन कि नईं। ");
INSERT INTO bhd_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","एल्हेरेलेइ काई यहूदेईं ते काई होरि यूनानी इज़्ज़तदार कुआन्शेईं भी यीशु पुड़ विश्वास कियो। ");
INSERT INTO bhd_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ज़ैखन थिस्सलुनीके नगरेरे यहूदन पतो लगो कि पौलुस बिरीया नगरे मां परमेशरेरू वचन शुनाते, ते तैना लोकन भटकाने ते हलचल मच़ाने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","तैखन विश्वासी ढ्लाएईं पौलुस समुन्दरेरे बन्ने भेज़ो, पन सीलास त तीमुथियुस तैड़ी राए। ");
INSERT INTO bhd_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ते पौलुसेरी मद्दत केरनेबाले एथेंस नगरे तगर जे, ते सीलास ते तीमुथियुसेरे लेइ बिस्तार नेइतां च़ले जे, कि मीं कां जल्दी एज्जे। ");
INSERT INTO bhd_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ज़ैखन पौलुस एथेंस नगरे मां तैन बलगने लग्गोरो थियो, त एन तकते कि सारू नगर मूरती सेइं भेरतांए त तैसेरो दिल बड़ो उदास भोव। ");
INSERT INTO bhd_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","एल्हेरेलेइ तै प्रार्थना घरे मां यहूदन ते तैन सेइं ज़ैना परमेशरेरो डर मन्नेबाले (भक्त) गैर कौमन मरां यहूदन मां ओरे थिये चौके मां गेइतां मिलतो थियो, ते तैन सेइं रोज़ बेंस केरतो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","किछ इपिकूरी ते किछ स्तोईकी उस्ताद तैस सेइं बेंस केरने लगे, ते तैन मरां किछ ज़ोने लगे, “बकवादी कुन ज़ोनू चाते?” ते किछ ज़ोने लगे, “ए त होरि देबतां केरो पतो देनेबालो भोइ सकते, किजोकि पौलुस यीशुएरो ते कने ज़ींते भोनेरी खुशखबरी शुनातो थियो।” ");
INSERT INTO bhd_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","तैखन तैनेईं तै एप्पू सेइं साथी अरियुपगुस नव्वेंरे मन्दरे मां नेव, ते तैस पुच़्छ़ू, “कुन अस ज़ैनी सकतम कि ज़ैस नव्वें पंथेरी तू शिक्षा देतस, तै कुने? ");
INSERT INTO bhd_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","असां तेरे ऐशेरां बेड़ि आजीब गल्लां शुन्ने लोरेंम, ते असां एन ज़ाननू चातम कि एन केरो कुन मतलबे?” ");
INSERT INTO bhd_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(द्रासले मां एथेंसेरे लोक कुन देशी कुन परदेशी अपनि फुरस्तरो सारो मौको होरि कम्मां केरे बजाहे सिर्फ नव्वीं-नव्वीं गल्लां ज़ोने ते शुन्ने मां गुज़ारते थिये।) ");
INSERT INTO bhd_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","तैखन पौलुस अरियुपगुसे नव्वेंरे मन्दरे मझ़ाटे खड़ो भोइतां ज़ोने लगो, “हे एथेंसेरे लोकव, अवं हेरताईं कि तुस हर गल्ली मां देबतन बड़ो उच्चो द्रजो देतथ। ");
INSERT INTO bhd_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ज़ैखन अवं तुश्शे नगर मां हंठतो फिरतो थियो, त मेरी नज़र तुश्शे पूज़नेरी चीज़न पुड़ ते बलिदानेरी ठारी पुड़ पेई, ज़ैस पुड़ लिखोरू थियूं, अनज़ान परमेशरेरे लेइ, बस्सा तुस ज़ैस ज़ानथ नन्ना ते तैसेरी पूज़ा केरतथ, अवं तुसन तैसेरे बारे मां ज़ोताईं। ");
INSERT INTO bhd_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ज़ैनी परमेशरे दुनिया ते सैरी चीज़ां बनेवरिन, तै धेरतरो ते अम्बरेरो मालिके, तै हथ्थां केरे बनेवरे मन्दरन मां न राए। ");
INSERT INTO bhd_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","तैस मैनेरे मद्दतरी ज़रूरत नईं, किजोकि तै केन्ची चीज़री ज़रूरत नईं, तै सैरन ज़िन्दगी ते सांस ते सब किछ देते। ");
INSERT INTO bhd_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","तैनी एक्की मैन्हु सेइं हर कौमारे लोक पैदा किये, ताके सारे ज़मीनी पुड़ आबाद भोन, तैनी तैन केरि ज़िन्दगरे दिहाड़े बनाए ते रानेरे लेइ ठार बनाई। ");
INSERT INTO bhd_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","परमेशरे एन कियूं ताके लोक तैस तोप्पन ते शैइद तोपते-तोपते तैन मैल्ली गाए, हालांकी तै असन केन्ची करां दूर नईं। ");
INSERT INTO bhd_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","किजोकि तै असन सेइं साथी आए ते ज़ींते रातम ते च़लतम फिरतम, ज़ेन्च़रे कि तुश्शे लिखने बालेईं भी ज़ोरूए, ‘असां त तैसेरे बच्चेम।’ ");
INSERT INTO bhd_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ते परमेशरेरे बच्चे भोइतां सोचेरू लोड़े, कि ईश्वरत्व सोन्ने, चैंदरी, या घोड़ेरी मूरतरीए ते ज़ै केन्ची मैनेरे हाथां केरि कारीगिरीए ते खियाले सेइं आए। ");
INSERT INTO bhd_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","एल्हेरेलेइ परमेशरे लोकां अज्ञानतारे वक्ते पुड़ ध्यान न दित्तू, ते हुनी तै मैनन् सेब्भी ठैरन हुक्म देते कि मन फिरान। ");
INSERT INTO bhd_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","किजोकि तैनी अक दिहाड़ी ठुवालेवरीए ज़ैखन तै सच़्च़े सेइं दुनियारो इन्साफ एक्की एरे मैनेरे ज़िरिये सेइं केरेलो, ज़ै तैनी रख्खोरोए, ते तै तैनी मुड़दन मरां ज़ींतो केरतां ए गल सैरी मैनन् साबत कियोरीए।” ");
INSERT INTO bhd_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ज़ैखन तैनेईं मुड़दां केरि आदालतरे बारे मां शुनू त तैन मरां किछ एस गल्लरी मज़ाक बनाने लगे, ते किछेईं ज़ोवं, “अस एस बारे मां फिरी कोस्कोई शुन्मेले।” ");
INSERT INTO bhd_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","एन हेरतां पौलुस तैट्ठां निस्तां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","पन किछ लोक तैस सेइं मिली जे, ते तैनेईं प्रभु पुड़ विश्वास कियो, तैन मरां अक दियुनुसियुस ज़ै अरियुपगुसेरो प्रधान थियो, ते अक कुआन्श थी, तैसारू नवं दमरिस थियूं, ते तैन केरे अलावा होरे भी बड़े मैन्हु थिये। ");
INSERT INTO bhd_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","तैसेरां बाद पौलुस एथेंस नगरे मरां निस्तां कुरिन्थुस नगरे मां अव। ");
INSERT INTO bhd_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","तैड़ी तैस अक यहूदी मैल्लो, तैसेरू नवं अक्विला थियूं, ते तै पुन्तुस इलाकेरो रानेबालो थियो, ते तैसेरी कुआन्शरू नवं प्रिस्किल्ला थियूं, ते दुइये साथी इतालिया इलाकेरां ओरां थियां, किजोकि क्लौदियुस हाकिमे हुक्म दित्तोरो थियो, कि सारे यहूदी रोमे मरां च़ले गान ते पौलुस तैन कां जेव। ");
INSERT INTO bhd_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","किजोकि पौलुसेरो ते अक्विलारो तेम्बु बनानेरो बुपार थियो, तांए पौलुस तैस सेइं साथी राव, तैना कम केरने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ते पौलुस हर आरामेरे दिहाड़े तैन केरे प्रार्थना घरे मां गातो थियो, ते यहूदी लोकन ते यूनानी लोकन समझ़ाने लगो कि, यीशु पुड़ विश्वास केरा। ");
INSERT INTO bhd_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ज़ैखन सीलास ते तीमुथियुस मकिदुनिया इलाके मां आए, त पौलुस वचन शुनाने मां मघन थियो, ते लगातार यहूदन सेइं एन ज़ोतो थियो कि यीशु ही मसीह आए। ");
INSERT INTO bhd_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","पन ज़ैखन यहूदी खलाफत त कने तुहीन केरने लगे, त पौलुसे अपना लिगड़ां ठुड़कां ते ज़ोने लगो, “तुश्शो खून तुश्शे दोग्गे पुड़ भोए! अवं बेइलज़ाम आईं, अज़्ज़ेरे बाद अवं गैर कौमन कां गेइलो।” ");
INSERT INTO bhd_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","तैखन प्रार्थना घरे मरां निस्तां तीतुस यूस्तुस नंव्वेरे एक्की परमेशरेरे भक्त मैनेरे घरे जेव, ज़ै गैर कौमी मरां थियो, ज़ेसेरू घर प्रार्थना घरे सेइं साथी थियूं। ");
INSERT INTO bhd_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","एस प्रार्थना घरेरो प्रधान क्रिस्पुसे ते तैसेरे सारे टब्बरे प्रभु पुड़ विश्वास कियो, ते बड़े कुरिन्थिसेरे लोकेईं शुन्तां विश्वास कियो ते बपतिस्मो नीयो। ");
INSERT INTO bhd_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","एक्की राती प्रभुए पौलुसे सेइं दर्शने मां गल की, ते ज़ोवं, “डर नन्ना ते तू ज़ो ते च़ुप न रा, ");
INSERT INTO bhd_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","किजोकि अवं तीं सेइं साथी आईं, ते कोई तीं पुड़ हमलो केरतां नुकसान न पुज़ेई सकेलो, किजोकि इस नगर मां बड़े लोकन ज़ैना मीं पुड़ भरोसो रख्खेले।” ");
INSERT INTO bhd_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","पौलुस तैड़ी डैढ साल राव, ते तैन परमेशरेरी खुशखबरी शिखालतो राव। ");
INSERT INTO bhd_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ज़ैखन गल्लियो, अखाया इलाकेरो हाकिम थियो, त यहूदेईं मिलतां पौलुसे पुड़ हमलो कमाव, ते पौलुस ट्लेइतां आदालतरे तखते कां नीयो, ते ज़ोने लग्गे। ");
INSERT INTO bhd_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“एन लोकन समझ़ाते, कि परमेशरेरी आराधना एन्च़रे केरा, ज़ै मूसेरे कानूनेरे बिलकुल बरखलाफे।” ");
INSERT INTO bhd_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","पौलुस ज़ैखन किछ ज़ोने बालो थियो, त गल्लियोए यहूदन सेइं ज़ोवं, “हे यहूदी लोकव, अगर केन्ची जुर्मेरी या कोई बड़ी बुरी गल भोथी त अवं तुश्शी शुनेथो। ");
INSERT INTO bhd_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","पन तुश्शो इलज़ाम त सिर्फ खाली गल्लां केरो ते नंव्वां केरो ते तुश्शे कानूनेरे बारे मां आए, ते अवं न ज़ैंनी, किजोकि अवं एन गल्लां केरो हाकिम बन्नो न चैई।” ");
INSERT INTO bhd_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ते गल्लियो हुक्म दित्तो कि एन तखते करां बेइरोवं कढे। ");
INSERT INTO bhd_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","तैखन तैनेईं सेब्भेईं प्रार्थना घरेरो प्रधान सोस्थिनेस इन्साफेरे तखतेरे सामने कुटो, पन गल्लियोए एन गल्लां केरि किछ भी परवाह न कमाई। ");
INSERT INTO bhd_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पौलुस काई दिहाड़े कुरिन्थुस नगरे मां राव, ते फिरी तै विश्वासी ढ्लान करां च़लो जेव ते किंख्रिया मां अपनि मिनत पूरी केरनेरे लेइ अपने दोगेरी टिंड बनाई। ते बादे मां समुन्दरी ज़िहाज़े मां सीरिया इलाके जो च़लो जेव, ते प्रिस्किल्ला ते अक्विला भी तैस सेइं साथी थियां। ");
INSERT INTO bhd_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ज़ैखन तैना इफिसुस नगरे मां पुज़े त पौलुसे प्रिस्किल्ला ते अक्विला तैड़ी छ़डां, ते पौलुस एक्की प्रार्थना घरे मां जेव ते यहूदन सेइं बेंस केरने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ज़ैखन तैन लोकेईं तैस कां मिनत की, “कि तू हेजू किछ दिहाड़े असन कां बिश।” त पौलुसे तैन सेइं मन्नू, ");
INSERT INTO bhd_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","पन ज़ैखन पौलुस तैट्ठां च़लो त तैनी तैन सेइं वादो कियो, “अगर परमेशरेरी मर्ज़ी भोइ त अवं फिरी तुसन कां एज्जेलो।” ते फिरी पौलुस ज़िहाज़े मां च़ेढ़तां इफिसुसे जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ते कैसरिया नगरे मां ज़िहाज़े मरां ओस्सो त तैनी यरूशलेम नगरे मां गेइतां तैन केरि कलीसियारे लोकन सेइं मिलने जेव, ते फिरी तै अन्ताकिया नगरे मां अव। ");
INSERT INTO bhd_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","अन्ताकिया नगरे मां किछ च़िर बितनेरे बाद तै तैट्ठां च़लो जेव, ते गलातिया ते फ्रूगिया इलाकां केरे सब चेलन मज़बूत केरतो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","अपुल्लोस नंव्वेरे अक यहूदी थियो, तैसेरू ज़र्म सिकन्दरिया नगरे मां भोरू थियूं, तै बड़ो ज्ञानी मैन्हु थियो, ते पवित्रशास्त्रेरे बारे मां बड़ो ज़ानकार थियो, तै इफिसुस मां अव। ");
INSERT INTO bhd_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","तैनी प्रभुएरे बत्तरी शिक्षा शिखोरी थी, ते लगातार यीशुएरे बारे मां ठीक-ठीक शुनातो ते शिखालतो थियो, पन तै सिर्फ यूहन्नारे बपतिस्मे तगर ज़ानतो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","तै प्रार्थना घरे मां बेधड़क च़ारे ज़ोने लगो, पन प्रिस्किल्ला ते अक्विला तैसेरी गल्लां शुन्तां, तैनेईं तै अपने घरे नीयो, ते परमेशरेरी बत्तारे बारे तैस होरू भी रोड़े च़ारे ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ज़ैखन तैनी थापू कि पार ओस्तां अखाया इलाके जो गाए ते विश्वासी ढ्लाएईं तैस हिम्मत दित्ती, ते तैट्ठेरे चेलन जो चिट्ठी लिखी, कि एस सेइं रोड़ेच़ारे मिलाथ, ते तैनी तैड़ी पुज़तां तैन केरि बड़ी मद्दत की, ज़ैनेईं अनुग्रहेरे वजाई सेइं विश्वास कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","किजोकि तै बड़े ज़ोरे शोरे सेइं यहूदन सेइं बेंस केरतां खुल्ले आम पवित्रशास्त्रे सेइं साबत केरतो थियो, कि यीशु ही मसीहे। ");
INSERT INTO bhd_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ज़ैखन अपुल्लोस कुरिन्थुस नगरे मां थियो, त पौलुस बेइएं सारे इलाकन मेइं इफिसुस नगरे मां अव, तैसेरी तैड़ी होरे भी काई चेलन सेइं मुलाकत भोइ। ");
INSERT INTO bhd_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","तैनी तैन पुच़्छ़ू, “कुन विश्वास केरते बार तुसन पुड़ पवित्र आत्मा उतरोरी थी?” तैनेईं जुवाब दित्तो, “असेईं त पवित्र आत्मारे बारे मां शुनेरू भी नईं।” ");
INSERT INTO bhd_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","तैखन पौलुसे ज़ोवं, “फिरी तुसेईं कोस किसमेरो बपतिस्मो नीयो?” तैनेईं जुवाब दित्तो, “यूहन्नारो।” ");
INSERT INTO bhd_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","पौलुसे ज़ोवं, “यूहन्ना त तैन लोकन बपतिस्मो दित्तो ज़ैनेईं पापन करां मनफिराथ, ते यूहन्ना इस्राएली लोकन ज़ोवं, ज़ै मेरे बाद एजनेबालोए, तैस पुड़ विश्वास केरा, ज़ै मसीह आए।” ");
INSERT INTO bhd_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","एन शुन्तां तैनेईं प्रभु यीशु मसीहेरे नंव्वे सेइं बपतिस्मो नीयो। ");
INSERT INTO bhd_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ते ज़ैखन पौलुसे तैन पुड़ हथ रखे त पवित्र आत्मा तैन पुड़ उतरी, त तैना अलग-अलग भाषा केरने लगे, ते भविष्यिवाणी केरने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","एना सब लगभग 12 मैन्हु थिये। ");
INSERT INTO bhd_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","फिरी पौलुसे प्रार्थना घरे मां गेइतां ट्लेइ महीन्न तगर बड़े निडर भोइतां परमेशरेरे राज़्ज़ेरे बारे मां लोकन सेइं बेंस केरने समझ़ाने लाव। ");
INSERT INTO bhd_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","पन तैन मरां किछ सकत दिलेरे भोइ जे, ते तैनेईं विश्वास केरनेरे बजाहे इन्कार कमाव, ते एस पंथेरे बारे मां बुरू ज़ोने लगे, एल्हेरेलेइ पौलुस तैन करां कनारे भोइ जेव, ते चेले भी कनारे किये ते तुरन्नुसेरे सुकुले मां बेंस केरतो ते तैन शिखालतो राव। ");
INSERT INTO bhd_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","दूई सालन तगर एरू भोतू राव, एड़ी तगर कि आसिया इलाकेरे रानेबाले कुन यहूदी ते कुन यूनानी सेब्भेईं प्रभुएरू बच्चन शुनू। ");
INSERT INTO bhd_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ते परमेशर पौलुसेरे ज़िरिये सेइं बडां-बडां कम्मां ते चमत्कार हिरातो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","एड़ी तगर कि पौलुस ज़ैस रूमाले सेइं या फटके सेइं हथ लातो थियो, त तैना बिमारन पुड़ छ़डते थिये, त तैना बिमार बेज़्झ़ोते थिये, ते अगर तैन पुड़ भूतां केरो सैयो भोतो थियो, त तैना लोक ठीक भोते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","पन किछ यहूदी मड़द ज़ैना फुक-फक केरते थी, ते एन केरने लगे कि, ज़ैन पुड़ भूतां केरो सैयो भी भोए तैन पुड़ यीशुएरे नंव्वे इन ज़ोइतां फुक फक देने लाए, “ज़ैस यीशुएरो प्रचार पौलुस केरते, अवं तैसेरी कसम देताईं।” ");
INSERT INTO bhd_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","यहूदी प्रधान याजक ज़ेसेरू नवं स्क्किवा थियूं, तैसेरां सत मट्ठां थियां, तैना एन्ने कम्मां केरतां थियां। ");
INSERT INTO bhd_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ते भूते जुवाब दित्तो ते ज़ोवं, “अवं यीशु मसीह भी ज़ानताईं ते पौलुसे भी ज़ानताईं, पन तुस कौन आथ?” ");
INSERT INTO bhd_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","तैखन तै मैन्हु ज़ैस पुड़ भूतेरो सैयो थियो, तैन्न यीशुएरे नंव्वे सेइं फुक-फक देने बालन जो पेव, ते तैना अपने कब्ज़े मां केरतां एत्रे कुट्टे कि तैना ज़ख्मी भोइतां नगनगे तैट्ठां नश्शे। ");
INSERT INTO bhd_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ज़ैखन इफिसुस नगरेरे रानेबाले यहूदन ते यूनानी लोकन एस गल्लरो पतो लगो, त तैना डेरि जे, ते प्रभु यीशु मसीहेरी बड़याई की। ");
INSERT INTO bhd_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ते ज़ैनेईं विश्वास कियोरो थियो, तैनेईं एइतां अपने-अपने बुरे कम्मां केरो इकरार सेब्भी केरे सामने कियो। ");
INSERT INTO bhd_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ते केही लोकेईं ज़ैना जैदू केरते थिये, तैना किताबां सैरेईं एन्तां सेब्भी केरे सामने फुकी, ते ज़ैखन तैन किताबां केरि कीमतारो हिसाब लाव त कोई 50000 चैंदरे सिकन करां जादे थी। ");
INSERT INTO bhd_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","एन्च़रे प्रभुएरो वचन बड़े तकड़े च़ारे फैलतो जेव ते भारी राव। ");
INSERT INTO bhd_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","एन गल्लां केरे बाद पौलुसे फैसलो कियो, कि अवं मकिदुनिया ते अखाया इलाकां केरे विश्वासी लोकन सेइं मिलतां यरूशलेम नगरे जो गेइ, ते तै ज़ोवं, “यरूशलेम नगर मां गेइतां रोम नगर भी मां गानू भी ज़रूरीए।” ");
INSERT INTO bhd_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","एल्हेरेलेइ अपने सैथन मरां तीमुथियुस ते इरास्तुस दूई मैन्हु मकिदुनिया इलाके जो एप्पू करां पेइले भेज़े, ते एप्पू भी किछ च़िरे आसिया इलाके मां राव। ");
INSERT INTO bhd_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","तैस वक्ते तैस पंथेरे बारे मां हंगामो भोव। ");
INSERT INTO bhd_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","किजोकि अक चैंदरो करीगिर थियो, तैसेरू नवं दिमेत्रियुस थियूं, ते अरतिमिस देबारे मन्दरेरी मूरती बनेइतां, कारीगिरन बड़ू कम दुवेरु थियूं, ज़ैस सेइं तैन केरो बड़ो बुपार च़लोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","तैनी एन कम ज़ांन्ने बाले सारे कारीगिर अकोट्ठे कमाए ते ज़ोने लगो, “हे मेरे ढ्लाव असां इन कम केरतां बड़े पेंइसे कमातम। ");
INSERT INTO bhd_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","पन तुस हेरतथ ते शुन्तन कि एना दूई मैन्हु पौलुसेरे ज़ेरे केन्च़रे इफिसुस नगरे ते लगभग सारे आसिया इलाकेरे नगरन मां लोकन टपलाने लोरेन ते ज़ोतन कि ज़ै हथ्थेरां केरि कारीगिरीए, तै ईश्वर नईं। ");
INSERT INTO bhd_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","डर एस गल्लरो नईं, सिर्फ कि इश्शे पैशेरी बदनामी भोली, बल्के पुरानी देबी अरतिमिस, ज़ै आए तैसारू मन्दर भी घटया समझ़ू गालू, ज़ेसेरी पूज़ा सारे आसिया इलाके मां ते सारे दुनियाई मां केरतन, तैसेरी इज़्ज़त भी खतम भोइगानिये।” ");
INSERT INTO bhd_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ज़ैखन तैन लोकेईं शुनू त तैना सरकी सेइं भेरोई जे, ते ज़ोरे-ज़ोरे नहरे देने लगे, “इफिसी केरि देबी अरतिमिस, महान आए!” ");
INSERT INTO bhd_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","हेरते-हेरते सारे नगर मां हलचल मेच़ि जेई, लोकेईं गयुस ते अरिस्तर्खुस, मकिदुनी इलाके ज़ैना पौलुसे सेइं साथी ओरे थिये, तैना ट्लेइतां घसीटते तमाशो हेरनेरी ठैरी जो दौवड़ते ने। ");
INSERT INTO bhd_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","पौलुस भी सभाई मां गानू चातो थियो पन चेलेईं तै रोको। ");
INSERT INTO bhd_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ते आसिया इलाकेरे हाकिमन मरां भी तैसेरे काई दोस्तेईं तैस जो बिस्तार भेज़तां ते मिनत केरतां ज़ोवं, कि तमाशो हेरने न गेइयां किजोकि तैड़ी बड़ो खतरोए। ");
INSERT INTO bhd_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","तैड़ी पैन्चयती मां खलबली मच़ौरी थी, किजोकि किछ लोक नहरे देते थिये, ते बड़े लोकन पतो न थियो कि तैना तैड़ी किजो अकोट्ठे भोरेन। ");
INSERT INTO bhd_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","तैखन तैनेईं सिकन्दर, ज़ै यहूदी लोकेईं खड़ो कियोरो थियो, भीड़ी मरां किछ लोकेईं तै अग्रोवं कियो, ते सिकन्दर हथ्थे सेइं इशारो केरतां लोकां केरे सामने जुवाब देनो चातो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","पन ज़ेरो लोकन पतो लगो कि ए यहूदी आए, त सब ज़ोरे-ज़ोरे लगभग दूई घंटन तगर चिन्डां मारने लग्गे, “इफिसुस नगरेरे देबी अरतिमिस, महान आए।” ");
INSERT INTO bhd_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","तैखन एक्की मंत्री नगरेरे लोकन च़ुप करेइतां ज़ोने लगो, “कि इफिसुस नगरेरे रानेबालो कौन न ज़ांने कि इफिसुस नगर लोक अरतिमिस देबारू मन्दरे, ते एसेरे मूरतरो बड्डो रखवालेन, ज़ैन अम्बरेरां बिछ़ड़ोरो थी। ");
INSERT INTO bhd_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ज़ैखन एना गल्लां केरे खलाफ केन्चे किछ न ज़ोवं त ठीक थियूं कि तुस च़ुप राथ ते बगैर सोच सेमझ़तां किछ न केरेथ। ");
INSERT INTO bhd_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","तुसेईं ज़ैना मैन्हु इड़ी आनोरेन तैनेईं न मन्दरे लुटेरूए न इश्शी देबारे खलाफ तुहीन कियोरीए। ");
INSERT INTO bhd_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","अगर दिमेत्रियुस ते एसेरे कारीगिरन केन्ची पुड़ दाओ केरनोए त आदालतरू दार खुल्लूए, ते हाकिम भी आन, ज़ैड़ी तुस एक्की होरि पुड़ दाओ केरि सकतथ। ");
INSERT INTO bhd_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","पन अगर तुस होरि कोन्ची चीज़रे बारे मां पुछ़नू चातथ त तैसेरो फैसलो भी पंचैइती मां कियो गालो।” ");
INSERT INTO bhd_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","मीं इस गल्लरो डरे कि अगर हाकिम इस हंगामेरे बारे मां शुनेलो त ज़ोलो कि अस रोमी सराकारारी खलाफव्रज़ी केनेरी कोशिश केरने लोरेम, ते अस एत्रे लोकां केरे अकोट्ठे भोनेरो कुन जुवाब देमेले। ");
INSERT INTO bhd_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","एन ज़ोनेरां बाद तैनी पैन्चैयत खतम कमाई। ");
INSERT INTO bhd_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ज़ैखन हंगामो मुक्को त पौलुसे चेले कुजाए ते तैन केरो होसलो बधव, ते तैन बिश्शा ज़ोइतां मकिदुनिया इलाके जो च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","तैस सारे मुलखे मांमेइं चेलन होसलो देइतां यूनान इलाके मां (ज़ैस जो अखाया इलाको भी ज़ोतन) अव। ");
INSERT INTO bhd_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","तैड़ी तै ट्लाई महीने राव, ते ज़ैखन तै समुन्दरी ज़िहाज़े मां सीरिया इलाकेरे पासे गानेबालो थियो, त यहूदी केरे लीडरेईं तैस बत्तां मारनेरी साज़िश बनाई, तैस पतो लगो त एल्हेरेलेइ तैनी एन रोड़ू समझ़ू कि मकिदुनिया इलाके मांमेइं जो सीरिया इलाके जो गाए। ");
INSERT INTO bhd_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","बिरीया नगरेरे रानेबाले पुरूर्सेरू मट्ठू सोपत्रुस, ते थिस्सलुनीकि मांमेइं अरिस्तर्खुस ते सिकुन्दुस ते दिरबे नगरेरो गयुस, ते तीमुथियुस ते आसियारो तुखिकुस ते त्रुफिमुस आसिया इलाके तगर असन सेइं साथी च़ले जे (लूका भी तैन सेइं साथी थियो)। ");
INSERT INTO bhd_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","पन तैना अग्रोवं गेइतां त्रोआस नगरे मां असन बलगते राए। ");
INSERT INTO bhd_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ते अस अखमीरी रोट्टी केरे तिहारे बाद फिलिप्पी नगरे मरां सफर केरतां पंच़ दिहैड़ी मां त्रोआस नगरे मां तैन कां पुज़े, ते रात दिहैड़ी तैड़ी राए। ");
INSERT INTO bhd_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","हफतेरे पेइले दिहाड़े असां प्रभु भोजेरे लेइ अकोट्ठे भोए, ते पौलुसे होरसां तैट्ठां अग्रोवं गानू थियूं, त एल्हेरेलेइ तै तैन सेइं गल्लां केरने लाव ते एध्धी राती तगर तैन शिक्षा देने लाव। ");
INSERT INTO bhd_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","दोपरे ज़ैड़ी असां सब अकोट्ठे बिश्शोरे थिये, त तैड़ी काई दीये बलते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","त अक नौजवान दैरी मां बिशोरो थियो, ते तैसेरू नवं यूतुखुस थियूं, तै पौलुसेरो प्रचार ठड्डी तगर शुन्तां तैस निड्ल आई, ते ट्लेइयोवं छतरां उन्ढो खिरको, ते तै मेरि जेव। ");
INSERT INTO bhd_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पौलुस बुन अव ते तै नौजवान ट्लेइतां तैस सेइं लिपटो ते ज़ोने लगो, “कि डरा नन्ना ए ज़ींतोए।” ");
INSERT INTO bhd_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","फिरी तैनेईं बा गेइतां सेब्भेईं मिलतां रोट्टी खाइ, ते फिरी ट्लेकड़ोने तगर बच्चन शुनाने लगो, तैखन तै तैट्ठां च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","लोकेईं तै नौजवान ज़ींतो घरजो नीयो, ते तैन बड़ी खुशी भोइ। ");
INSERT INTO bhd_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","असां अग्गर गेइतां ज़िहाज़े मां सुवार भोइ जे, ते अस्सुस नगरे जो च़ले जे, ताके तैड़ी पौलुसे भी ज़िहाज़े मां च़ाढ़म, किजोकि पौलुसे पेइले पैदल गानेरो बिस्तार कियोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ज़ैखन तै असन अस्सुस नगरे मां मैल्लो त तै असेईं ज़िहाज़े मां च़ाढ़ो ते असां मितुलेन नगरे मां आए। ");
INSERT INTO bhd_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","तैट्ठां असां ज़िहाज़े मां सुवार भोइ जे ते अस खियुस जज़ीरेरे सामने पुज़े, ते अग्री दिहाड़े असां सामुसे मां पुज़े, ते होरसां अस मीलेतुस नगरे मां आए। ");
INSERT INTO bhd_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","पौलुसे थापेरू थियूं, कि अवं इफिसुस नगरे मां उतरेलो, किजोकि तै आसिया इलाके मां जादे वक्त बीतानो न थियो चातो, किजोकि तै जल्दी मां थियो, कि अगर भोइसखे, त तै पिन्तेकुस्त तिहारेरे दिहाड़े यरूशलेम नगरे मां राए। ");
INSERT INTO bhd_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ज़ैखन अस मीलेतुस नगरे मां ओस्से, त पौलुसे इफिसुस नगरेरे कलीसियारे बुज़ुर्गन जो बिस्तार भेज़ो कि तैना एज्जन। ");
INSERT INTO bhd_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ज़ैखन तैना तैस कां आए, त तैनी तैन सेइं ज़ोवं, तुस ज़ानतथ कि पेइले दिहाड़ेरां ज़ैखन अवं आसिया इलाके मां पुज़ो, अवं तेइसेरो देंतो अज़ तगर हर वक्त तुसन सेइं साथी केन्च़रां राव। ");
INSERT INTO bhd_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","मतलब बड़े नेरमी सेइं, ते ऐंखरू बछ़ोड़ी-बछ़ोड़ी, ते तैन अज़मैइश मां ज़ैना यहूदी केरि च़लैकी सेइं मीं पुड़ एई, अवं प्रभुएरी सेवा केरतो राव। ");
INSERT INTO bhd_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ते ज़ैना-ज़ैना गल्लां तुश्शे लेइ फैइदेरी थी, तैना मीं तुसन सेइं बगैर केन्चेरे डरे तुसन सेइं ज़ोई छ़ेड्डी, ते बल्के ज़ैन किछ भी शिखालू दिले सेइं ते घर-घर गेइतां शिखालू। ");
INSERT INTO bhd_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","बल्के अवं यहूदी लोकां ते यूनानी लोकां केरे दुइयां केरे सामने गवाही देताईं कि तैना परमेशरेरे सामने पापन करां मन फिरान, ते इश्शे प्रभु यीशु मसीह पुड़ विश्वास केरन। ");
INSERT INTO bhd_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","हेरा हुनी अवं पवित्र आत्मारी गल मेन्तां यरूशलेम नगरे जो गाताईं, ते मीं पतो नईं कि तैड़ी मीं पुड़ केरि-केरि गुज़रेली। ");
INSERT INTO bhd_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","अवं सिर्फ एत्रू ज़ानताईं कि पवित्र आत्मा मीं हर नगर मां एन ज़ोती राई, कि बन्धना ते मुसीबत मेरे लेइ तियारन। ");
INSERT INTO bhd_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","पन मेरी जान, मेरे लेइ कोई कदर कीमत न रख्खे, त बस्सा अवं एन चाताईं कि मेरी दौड़ पूरी भोए ते तैस सेवाई पूरी केरि, ज़ै मीं परमेशरेरे अनुग्रहेरे खुशखबरी पुड़ गवाही देनेरे लेइ प्रभु यीशु करां मैल्ली। ");
INSERT INTO bhd_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ते हुनी अवं ज़ानताईं, कि तुसेईं अवं ज़ैन मां परमेशरेरे अनुग्रहेरी खुशखबरी हर पासे शुनातो राव, त मीं फिरी न लाएले। ");
INSERT INTO bhd_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","एल्हेरेलेइ अवं तुसन साफ-साफ ज़ोई छ़डताईं, कि ज़ैना लोक यीशु पुड़ विश्वास केरने बगैर मरेले, त अवं तैन केरे ज़िमेवार नईं। ");
INSERT INTO bhd_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","किजोकि अवं बगैर केन्ची डरेरां तुसन शिखालतो राव, कि परमेशरेरी मर्ज़ी तुश्शे लेइ कुने। ");
INSERT INTO bhd_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","बस्सा अपनो ते सारे विश्वासी लोकां केरो खियाल रखा, ज़ेसेरे लेइ तुस पवित्र आत्मारे तरफां च़ुनोरेथ, कि परमेशरेरी कलीसियारी रखवाली केरा, ज़ै लोक तैनी अपने खूने सेइं घिन्नोरेन। ");
INSERT INTO bhd_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","अवं ज़ानताईं कि मेरे गानेरां बाद झूठे उस्ताद मारने बालां गिदां केरे ज़ेरे तुसन मां एज्जेले, ते ज़ेन्च़रे तैना भैड्डन मारतन तेन्च़रे तैना झूठे उस्ताद तुसन नुकसान पुज़ाले। ");
INSERT INTO bhd_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","बल्के तुसन मरां भी एरे लोक खड़े भोले ज़ैना सच़ ट्लोड़ मरोड़ केरतां छ़डेले, ताके चेलन अपने पासे केरन। ");
INSERT INTO bhd_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","एल्हेरेलेइ बींझ़े राथ ते याद रखा, कि अवं ट्लाई साल लेरां देंतो रात दिहैड़ी हर एक्की तैन खबरदार केरतो राव। ");
INSERT INTO bhd_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","हुनी अवं तुसन परमेशरे, ते तैसेरे अनुग्रहेरे वचनेरे सुपुर्द केरताईं, कि ज़ै तुसन विश्वासे मां मज़बूत केरि सकते, ते तुसन तैस जागिरारो हकदार बनेइ सकते, ज़ेसेरो वादो तैनी कियोरोए ज़ैनी तुस पवित्र कियोरेथ। ");
INSERT INTO bhd_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","मीं केन्चेरे सोन्ने चेंदारू या लिगड़ां केरू लालच़ नईं कियेरू। ");
INSERT INTO bhd_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","तुस एप्पू ज़ानतथ कि मीं अपने हथेइं सेइं अपने ते अपने सैथी केरि हर अक ज़रूरत पूरी कियोरीए। ");
INSERT INTO bhd_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","मीं तुसन सब किछ केरतां हिराव, कि एन्च़रे सेइं कमज़ोरन समैली सकतम, कि प्रभु यीशु मसीहेरी गल्लां याद रखम, “कि देनू नेने करां जादे धने।” ");
INSERT INTO bhd_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","एन गल्लां केरे बाद पौलुसे ज़ैधू केरे भारे बिश्तां तैन सेब्भन सेइं साथी प्रार्थना की। ");
INSERT INTO bhd_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तैना सब गले मिलतां लेरां देने लगे, ते पौलुसे फुम्मड़ी देने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","खास केरतां तैना इस गल्ली सेइं दुखी थी, ज़ैना तैनी ज़ोरी थी, कि तुस मीं फिरी कधी न लाएले, ते तैनेईं तै ज़िहाज़े तगर पज़ाव। ");
INSERT INTO bhd_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ज़ैखन असां तैन करां च़ले जे त समुन्दरेरे सफर शुरू कियूं, त सिधे बत्तां कोस जज़ीरे मां आए, ते होरसां अस रूदुस मां पुज़े, ते फिरी तैट्ठां पतरा जज़ीरे मां च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ते अक ज़िहाज़ फीनीके इलाके जो गांतू मैल्लू, त असां तैस पुड़ च़ेढ़तां सफर शुरू कियूं। ");
INSERT INTO bhd_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ज़ैखन इश्शी नज़र साइप्रस जज़ीरे पुड़ पेई, त अस तैस बांए हथ्थे ओसैलतां सीरिया इलाके जो च़ले जे, सूर नगरे मां ओस्से, किजोकि इश्शे ज़िहाज़े तैड़ी किछ बोझ उसालनो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","तैड़ी असन चेले मैल्ले ते तैन कां असां सत दिहाड़े राए। तैनेईं पवित्र आत्मारे ज़ोने मुताबिक पौलुसे यरूशलेम नगरे मां गानेरे लेइ ठाको। ");
INSERT INTO bhd_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","सत दिहैड़ना बाद कुआन्शां मट्ठन समेत नगरेरे बेइर तगर साथी आए, ते समुन्दरेरे बन्ने पुज़तां असेईं ज़ैधू केरे भारे बिश्तां प्रार्थना की। ");
INSERT INTO bhd_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","फिरी असां तैन करां अलग भोए त ज़िहाज़े मां च़ेढ़तां च़ले जे, ते तैना भी अपने-अपने घरजो च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ज़ैखन असां सूर नगरे मरां सफर पूरू केरतां पतुलिमयिस मां पुज़े, ते विश्वासी ढ्लान जो नमस्कार केरतां तैन सेइं साथी अक दिहाड़ी राए। ");
INSERT INTO bhd_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ते होरसां असां तैट्ठां च़ेलतां कैसरिया नगरे मां आए, ते फिलिप्पुस खुशखबरी प्रचार केरनेबालेरे घरे जे ते तैड़ी राए, ज़ै सत्तन मरां अक थियो। ");
INSERT INTO bhd_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","तैसेरी च़ेव्रे कुवैरी कुइयां थी, ते तैना भविष्यिवाणी केरती थी। ");
INSERT INTO bhd_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ज़ैखन अस तैड़ी काई दिहाड़े राए, त तैड़ी अक नबी थियो, ज़ेसेरू नवं अगबुस थियूं, तै यहूदिया इलाकेरां ओरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","तैनी असन कां एइतां पौलुसेरे मज़े सेइं अपने हथ पाव बंधे ते ज़ोने लगो, “पवित्र आत्मा इन ज़ोतीए कि ज़ैस मैनेरू इन मज़ आए, तैस यरूशलेम नगरेरे यहूदी इसेरे ज़ेरे बंधेले, ते गैर कौमां केरे लोकां केरे हवाले केरेले।” ");
INSERT INTO bhd_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ज़ैखन असेईं एना गल्लां शुनी, त असेईं ते होरि लोकेईं पौलुसे कां मिनत की, कि यरूशलेम नगरे मां न गेइयां। ");
INSERT INTO bhd_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","पन पौलुसे जुवाब दित्तो, “तुस एन कुन केरने लोरेथ? तुस किजो लेरां देइ-देइ मेरो दिल ट्लोड़ने लोरेथ? अवं यरूशलेम नगरे मां प्रभु यीशु मसीहेरे नंव्वे सेइं सिर्फ बेंधोनेरे लेइ नईं बल्के मरनेरे लेइ भी तियार आईं।” ");
INSERT INTO bhd_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ज़ैखन तैनी न मन्नू त असां च़ुप राए, “कि प्रभुएरी मर्ज़ी पूरी भोए।” ");
INSERT INTO bhd_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","किछ दिहाड़ना बाद असां सफरेरी तियारी केरने लगे, ते फिरी असां यरूशलेम नगरे जो च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरिया नगरेरे किछ चेले असन सेइं साथी च़ले, ते असेईं मनासोन नंव्वेरो साइप्रसेरो अक पुरानो चेलो साथी आनो कि अस तैसेरे घरे रहम। ");
INSERT INTO bhd_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ते ज़ैखन असां यरूशलेम नगरे मां पुज़े, त इश्शे विश्वासी ढ्ला बड़े खुशी सेइं असन सेइं मिलने आए। ");
INSERT INTO bhd_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","होरसां असां पौलुसे साथी नेइतां याकूबे सेइं मिलने जे, तैड़ी सब बुज़ुर्ग अकोट्ठे भोरे थिये। ");
INSERT INTO bhd_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","तैखन तैनी नमस्कार केरतां, ज़ैना-ज़ैना कम्मां परमेशरे तैसेरी सेवारे ज़िरिये सेइं गैर कौमन मां कियोरां थी, अक-अक केरतां सब ज़ोआं। ");
INSERT INTO bhd_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","तैनेईं इन शुन्तां परमेशरेरी तारीफ़ की, ते फिरी पौलुसे सेइं ज़ोने लगे, “हे ढ्ला तू ज़ानतस, कि यहूदन मरां हज़ारेईं लोकेईं विश्वास कियोरोए, ते तैना सब मूसेरे कानूने पुड़ अमल केरने मां मघनन्। ");
INSERT INTO bhd_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ते तैन तेरे बारे शिखालेरू कि तू गैर कौमन मां रानेबाले सारे यहूदन ए शिक्षा देंतो ओरोस, कि मूसा नेबेरे कानूनेरे शारने, ते अपने मट्ठां केरो खतनो न केरा, ते न यहूदी केरे रीतन पुड़ न च़ला। ");
INSERT INTO bhd_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","त फिरी कुन कियूं गाए? लोकेईं ज़रूर शुनेले कि इड़ी ओरोस। ");
INSERT INTO bhd_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","एल्हेरेलेइ ज़ैन अस तीं सेइं ज़ोतम, तैन केर। इश्शे इड़ी च़ेव्रे मैन्हु आन ज़ैनेईं मिनत मगोरीए। ");
INSERT INTO bhd_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","तू तैन एप्पू सेइं साथी ने ते तैन सेइं मिलतां अपनो आप शुद्ध केर, ते तैन केरो खर्च़ो भी दे, ताके तैना अपनो दोग्गेरी टिंड बनान। तैखन सेब्भन पतो लगनोए कि ज़ैना गल्लां तेरे खलाफ फैलेवरिन, तैन केरि कोई बुनीयाद नईं, ते तू एप्पू भी सच़्च़े दिले सेइं मूसेरे कानूने पुड़ अमल केरतस। ");
INSERT INTO bhd_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ते ज़ैड़ी तगर तैन गैर कौमां केरो सवाले, कि ज़ैनेईं विश्वास कियोरोए, तैन केरे बारे मां असेईं पेइले फैसलो केरतां लिखतां भेज़ू, कि तैना मूरतन कां बलिदान कियेरू मास ते खूने करां ते गलचैटी देइतां मारोरे जानवरां केरे मासे करां परहेज़ केरन, ते बदमाशी न केरन। ");
INSERT INTO bhd_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","होरसां पौलुसे तैना मैन्हु साथी ने, ते तैन सेइं साथी अपने आपे शुद्ध केरतां मन्दरे मां जेव, ते खबर दित्ती कि तैन केरे शुद्ध भोनेरे बाद च़ढ़तल च़ाढ़नेरे दिहाड़े केइस पूरे भोनेन।” ");
INSERT INTO bhd_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ज़ैखन शुद्ध भोनेरे सत दिहाड़े पूरे भोनेबाले थिये, त आसिया इलाकेरे यहूदेईं पौलुस मन्दरे मां लाव त लोक भड़काए, ते तैस ट्लेइतां चिन्डां मारने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“हे इस्राएली लोकव इश्शी मद्दत केरा, ईए तै मैनूए, ज़ै हर ठैरी लोकन इश्शे कानूनेरे खलाफ ते मन्दरेरे खलाफ शिक्षा देंतो रहते, ते एनी एसेरां अलावा गैर कौमां केरे लोक इश्शे मन्दरे मां एन्तां तै पवित्र ठार अपवित्र कराते।” ");
INSERT INTO bhd_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","तैनेईं एन एल्हेरेलेइ ज़ोवं कि तैनेईं पौलुस इफिसुस नगरेरे रानेबाले त्रुफिमुस सेइं साथी लाहोरो थियो, ते समझ़ते थिये कि पौलुसे तै ज़रूरी मन्दरे मां नीयोरो भोनोए। ");
INSERT INTO bhd_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","तैखन सारे नगर मां हलचल मेच़ि जेई, ते मैन्हु देवड़तां जम्हां भोए, ते पौलुस ट्लेइतां मन्दरे मरां घसीटतां बेइर आनो, ते लूशी दारां बंद कियां। ");
INSERT INTO bhd_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ज़ैखन तैना तैस मारनेरी कोशिश केरने लवरे थिये, त फौजी टोलरे सरदारे कां खबर पुज़ी, कि बड़े लोकेईं यरूशलेम नगरे मां खलबली मच़ोरीए। ");
INSERT INTO bhd_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","तैखन तैना सिपेहिन ते सूबेदारन एन्तां तैन कांजो दौड़ो, ते तैनेईं फौजी टोलरे सरदारे ते सिपाही लेइतां पौलुस मारनो कुटनो बंद कियो। ");
INSERT INTO bhd_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","फौजी टोलरे सरदारे नेड़े गेइतां पौलुस अपने कब्ज़े मां कियो, ते तैस दूई शांगलेइं सेइं बंधनेरो हुक्म दित्तो, ते फिरी तैनी पुच़्छ़ू, “ए मैन्हु कौने ते एनी कुन कियेरू आए?” ");
INSERT INTO bhd_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","तैस भीड़ी मां किछ लोक चिन्डां मारते थिये, ते एत्री शौर मच़ौरी थी, कि तैस पूरो पतो न लगो ते तैनी हुक्म दित्तो, कि पौलुसे किल्लै मां पुज़ाथ। ");
INSERT INTO bhd_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ज़ैखन पौलुस सिपाहीयेइं पेवड़न उबरो च़लेवरो थियो, त लोकां केरे वजाई सेइं सिपाहीयेइं पौलुस उबरो छ़ुइतां नेव। ");
INSERT INTO bhd_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","सारे लोक ज़ैना पौलुसे पत्ती पेवरे थिये, तैना चिन्डां मारते थिये, “एस मार।” ");
INSERT INTO bhd_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","पौलुसे सिपाही किल्लै मां पुज़ाने बाले थिये, त तैनी फौजी टोलरे सरदारे सेइं ज़ोवं, “कुन मीं अज़ाज़ते कि अवं तीं सेइं किछ ज़ोईं?” ते तैनी पुच़्छ़ू, “तू यूनानी भाषा ज़ानतस?” ");
INSERT INTO bhd_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","कुन तू तै मिस्र मुलखेरो रानेबालो नईं, ज़ैनी किछ च़िरे पेइले सरकारारी खलाफत कियोरी थी, ते 4000 मैनन् ज़ैन कां हथियार थिये तैना जंगले मां नीयोरे थिये? ");
INSERT INTO bhd_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पौलुसे ज़ोवं, “अवं त यहूदी आईं, ते तरसुस नगरेरो राने बालोईं, ज़ैन किलिकिया इलाकेरू मुशूर नगर, अवं तीं कां मिनत केरताईं मीं लोकन सेइं गल केरने दे।” ");
INSERT INTO bhd_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ज़ैखन तैनी अज़ाज़त दित्ती, त पौलुस पेवड़न पुड़ खड़ो भोइतां लोकन जो हथ्थे सेइं इशारो कमाव कि च़ुप रान। ते ज़ैखन तैनेईं च़ुप कमाई त पौलुसे इब्रानी भाषाई मां ज़ोनू शुरू कमाव: ");
INSERT INTO bhd_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“मेरे ढ्लाव ते बुज़ुर्गाव, मेरी गल शुना, ज़ै अवं अपनि सफैई मां पैश लोरोईं केरने।” ");
INSERT INTO bhd_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ज़ैखन लोकेईं तैस करां इब्रानी भाषा ज़ोती शुनी त तैना च़ुप रेइजे, तैखन पौलुसे ज़ोवं: ");
INSERT INTO bhd_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“अवं त यहूदी आईं, ते अवं किलिकिया इलाकेरे तरसुस नगरे मां ज़रमो, पन इस नगर मां गमलीएल करां शिक्षा हासिल की, ते अपने दादां-पड़दादां केरे कानूने ठीक तरीके सेइं शिखोरीए, ते अवं भी परमेशरेरे लेइ एरो मघन थियो, ज़ेरे अज़ तुस आथ। ");
INSERT INTO bhd_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","मीं मड़दन ते कुआन्शन बेंधतां, ते कैद केरतां, ई पंथ इड़ी तगर सताए, ते तैना माराए भी। ");
INSERT INTO bhd_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","एप्पू महायाजक ते सब बुज़ुर्ग एस गल्लरे गवाह आन, कि मीं दमिश्क नगरे मां रानेबाले यहूदी ढ्लां केरे लेइ चिट्ठी एन्होरी थी, ते अवं तैड़ी एस नीती सेइं जोरो थियो, ते ज़ैना तैड़ी भोन तैन सज़ा देनेरे लेइ बेन्धतां यरूशलेम नगरे जो नेही।” ");
INSERT INTO bhd_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“अवं ज़ैखन सफर केरते-केरते दमिश्क नगरेरे नेड़े पुज़ो, त तै दुपाहरां केरो मौको थियो। ते अम्बरेरां अक बड़ी लौ आई ते मेरे च़ेव्रे पासन बलने लगी। ");
INSERT INTO bhd_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ते अवं तल्ले बिछ़ड़ी जेव, ते मीं अक आवाज़ शुनी, ज़ै मींजो ज़ोने लोरी थी, हे शाऊल, हे शाऊल तू मीं किजो स्तातस? ");
INSERT INTO bhd_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","त मीं पुच़्छ़ू, हे प्रभु तू कौन आस? त तैनी मींजो जुवाब दित्तो, अवं यीशु नासरी आईं, ज़ैस तू सतातस। ");
INSERT INTO bhd_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","मेरे सैथेईं लौ त लाई पन तैन कोई गल न समझ़ी, कि तै आवाज़ मीं सेइं कुन लोरीए ज़ोने? ");
INSERT INTO bhd_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","त मीं पुच़्छ़ू, हे प्रभु अवं कुन कम्मेईं, प्रभुए ज़ोवं, उठ दमिश्क नगरे मां गा तैड़ी तीं ज़ैन तेरे केरनेरे लेइ रखेरुए तैड़ी तीं सेइं ज़ोवं गालू। ");
INSERT INTO bhd_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","मेरे सैथेईं अवं हथ्थेरां ट्लेइतां दमिश्क नगर मां पुज़ाव। किजोकि तैस बड़े महिमारे वजाई सेइं मीं किछ न लेइयोवं।” ");
INSERT INTO bhd_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“तैड़ी अक मैन्हु हनन्याह नव्वेंरो कानूनेरे मुताबिक भक्त मैन्हु अव, ते तैट्ठेरे यहूदन मां बड़ो इज़्ज़तदार थियो। ");
INSERT INTO bhd_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","तै मीं कां खड़ो भोइतां ज़ोने लगो, हे ढ्ला, शाऊल, अपनि एछ़्छ़ी खोल्ल, ते मेरी एछ़्छ़ी तैखने खुल्ली जेई, ते अवं तैस लहने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","तैखन तैनी ज़ोवं, इश्शे बुज़ुरगां केरे परमेशरे तू च़ुनोरोस, ताके तू तैसेरी मर्ज़ी पूरी केरस ते मसीह लास ते तैसेरी गल्लां शुनस। ");
INSERT INTO bhd_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","किजोकि तू सैरी लोकन मां तैसेरो गवाह भोलो, ते तैन ज़ोलो कि तीं कुन लाहेरूए ते कुन शुनेरूए। ");
INSERT INTO bhd_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","हुनी च़िर किजो लातस? उठ, ते बपतिस्मो ने ते तेरे पाप माफ़ भोन।” ");
INSERT INTO bhd_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ते ज़ैखन अवं यरूशलेम नगरे मां वापस अव, ते अवं मन्दरे मां प्रार्थना केरने लोरो थियो, त मीं दर्शन लावं। ");
INSERT INTO bhd_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ते तै लाव ते एन ज़ोतू शुनू कि लूश केर, ते यरूशलेम नगरे मरां लूशी निस, किजोकि एना लोक मेरे बारे मां तेरी गवाही कबूल न केरेले। ");
INSERT INTO bhd_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","मीं ज़ोवं, हे प्रभु एना लोक ज़ानतन कि अवं हर प्रार्थना घरे मां गातो थियो, ते केन्च़रे अवं तेरे मन्ने बालन कैद केरतो ते कुटतो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ते ज़ैखन तेरे गवाह स्तिफनुस मारने लोरे थिये, त अवं भी तैड़ी थियो, ते तैसेरे मारने मां खुशी थियो। ते अवं मारने बालां केरां लिगड़ां पहरतो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ते प्रभुए मीं सेइं ज़ोवं, ‘गा अवं तीं गैर कौमन कां दूर-दूर भेज़ेलो।’” ");
INSERT INTO bhd_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","सारे लोक तैसेरी गल्लां शुन्ने लोरे थिये, पन ज़ैखन तै इड़ी तगर पुज़ो त सारे लोक ज़ोरे-ज़ोरे चिन्डां मारने लगे, “ए ज़ींतो रखनेरे काबल नईं!” एस मार। ");
INSERT INTO bhd_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ज़ैखन लोकां केरि शौर ते चिन्डां च़ेलती रेइ, त तैना चोगे शैरतां धूड़ आसमाने उडारने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","त फौजी पलटनरे सरदारे पौलुस किल्लै मां नेनेरो हुक्म दित्तो, “एस कोड़ेइं सेइं बाथ ते एसेरू बियांन घिन्ना ताके पतो लगे, कि लोक किजो चिन्डां मारने लोरेन।” ");
INSERT INTO bhd_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ज़ैखन तैना कोड़ेइं सेइं बानेरे लेइ पौलुस रेसी सेइं बंधो, त तैनी एक्की सूबेदारे सेइं ज़ोवं ज़ै तैड़ी नेड़े थियो। “कुन अक रोमी नगरेरे मैन्हु बगैर कसूरे झ़ुसनो जेइज़े?” ");
INSERT INTO bhd_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ज़ैखन तैनी सूबेदारे एन शुनू त तै फौजी पलटनरे सरदारे कां जेव, “तू कुन ज़ोतस? ए त अक रोमी मैनूए।” ");
INSERT INTO bhd_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","फौजी पलटनरे सरदारे पौलुसे कां एइतां पुच़्छ़ू, “कुन तू रोमीस?” तैनी ज़ोवं, “हाँ।” ");
INSERT INTO bhd_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","इन शुन्तां फौजी पलटनरे सरदारे ज़ोवं, “कि मीं रोमी भोनेरी पदवी बड़े पेंइसे देइतां हासिल कियोरीए।” ते पौलुसे ज़ोवं, “पन अवं त ज़र्मनेरो रोमी।” ");
INSERT INTO bhd_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ज़ैना लोक पौलुसेरू बियांन घिन्ने बाले थिये, तैना नेश्शी जे, फौजी पलटनरे सरदारे भी इन बुझ़तां कि ई रोमीए, ते तैनी तै बंधो, ते डेरि जेव। ");
INSERT INTO bhd_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","होरसां तै ठीक-ठीक ज़ान्नेरी इच्छा सेइं कि यहूदी तैस पुड़ किजो दोष लातन, एल्हेरेलेइ तैनी तै खोल्लो, ते प्रधान याजक ते सारी महासभा अकोट्ठी केरनेरो हुक्म दित्तो, ते पौलुस बुन गेइतां तैन केरे सामने खड़ो कियो। ");
INSERT INTO bhd_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पौलुसे महासभारे लोकां केरे पासे रोड़ेच़ारे तेकतां ज़ोवं, “हे ढ्लाव अवं बेड़ि नेक नीती सेइं परमेशरेरे हुक्मां केरे मुताबिक ज़िन्दगी गुज़ारतो ओरोईं।” ");
INSERT INTO bhd_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","महायाजक हनन्याह पौलुसेरी एना गल्लां शुन्तां पौलुसे कां खड़े भोरे लोकन हुक्म दित्तो, कि एसेरे तुत्तरे पुड़ थप्पड़ बाथ। ");
INSERT INTO bhd_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","पौलुसे तैस सेइं ज़ोवं, “हे पाखंडी, परमेशर तीं बाए। तू इड़ी बिशोरोस कि मूसेरे कानूनेरे मुताबिक मेरो इन्साफ केरस, ते कुन तू मूसेरे कानूनेरे खलाफ बानेरो हुक्म देतस?” ");
INSERT INTO bhd_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ज़ैना तैड़ी खड़खड़े थिये, त तैना ज़ोने लगे, “कुन तू परमेशरेरे महायाजकेरी तुहीन केरतस?” ");
INSERT INTO bhd_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पौलुसे तैन सेइं ज़ोवं, “ढ्लाव मीं पतो न थियो, कि ए महायाजक, किजोकि लिखोरूए, तू अपने लोकां केरे प्रधाने जो बुरू न ज़ो।” ");
INSERT INTO bhd_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","पौलुस ज़ानतो थियो, कि तैन मां किछ सदूकी भी आन, ते किछ फरीसी लोक भी आन ते तै महासभाई मां ज़ोरे सेइं ज़ोने लगो, “हे ढ्लाव अवं त फरीसी लोकां केरे खानदेंनी मरां आईं, ते मीं पुड़ एनेईं एल्हेरेलेइ मुकदमो च़लेवरोए, कि अवं उमीद रखताईं कि मुड़दे फिरी ज़ींते भोले।” ");
INSERT INTO bhd_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","पौलुसेरू एन ज़ोंते फरीसी ते सदूकी लोकन एप्पू मांमेइं लड़ाई शुरू भोइजेइ, ते सेब्भन एप्पू मांमेइं खल बनो। ");
INSERT INTO bhd_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","किजोकि सदूकी ज़ोतन कि मुड़दे ज़ींते नईं भोने, ते न स्वर्गदूतन ते न कोई आत्मा आए, पन फरीसी लोक एन दुइये गल्लन पुड़ विश्वास केरतन। ");
INSERT INTO bhd_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","तैखन तैना बेंस केरने लग्गे, शास्त्री लोकन मरां ज़ैना फरीसी लोकन मां थिये, तैना खड़े भोइतां लड़ाई केरतां ज़ोने लगे, “असां इस मैन्हु मां कोई कसूर न लहम, अगर केन्ची आत्मा या स्वर्गदूते एस सेइं कोई गल कियोरीए त फिरी कुन भोवं?” ");
INSERT INTO bhd_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","गल एत्री बेद्धी जेई, कि फौजी पलटनरे सरदारे बुझ़ू, कि एरू न भोए कि पौलुसेरे टोटे-टोटे बनान, त तैनी हुक्म दित्तो कि बुन गाथ ते पौलुसे ज़बरदस्ती तैट्ठां कढा ते किल्लै मांजो आनां। ");
INSERT INTO bhd_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","तैस्से राती प्रभु यीशुए पौलुसे कां एइतां ज़ोवं, “हे पौलुस हिम्मत रख ज़ेन्च़रे तीं यरूशलेम नगरे मां मेरी गवाही दित्तोरीए, तेन्च़रे तीं रोमे मां भी गवाही देनी भोली।” ");
INSERT INTO bhd_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","होरसां झ़ेझ़ां किछ यहूदी मैनेईं मिलतां फैसलो कियो, ते कसम कमाई कि ज़ांतगर असां पौलुसे कत्ल न केरम, तांतगर किछ न खाम ते न पींम। ");
INSERT INTO bhd_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","एस साज़िशी मां 40 मैनन् करां जादे थिये। ");
INSERT INTO bhd_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","तैना प्रधान याजकन ते बुज़ुर्गन कां जे, ते ज़ोने लगे, “असन पुड़ लानत भोए, अगर असां पौलुसे मारनेरे बगैर किछ खाम या पींम, असेईं त तैस खतम केरनेरी कसम कमेवरीए। ");
INSERT INTO bhd_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","एल्हेरेलेइ तुस सब महासभा मां मिलतां फौजी पलटनारे सरदारे कां दरखुवास देथ, कि तै पौलुसे लोकां केरे सामने आने, ताके एस मुकदमेरी सारी हकिकत फिरी पतो च़ले, एस करां पेइले पौलुस इड़ी पैश कियो गाए, असां तियार आम, कि तैस मारम।” ");
INSERT INTO bhd_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","पन ज़ैखन पौलुसेरे बेइनारे मट्ठे एस साजशरो पतो लगो, त तैनी किल्लै मां गेइतां पौलुसे पतो दित्तो, कि तैना लोक तैस मारनो चातन। ");
INSERT INTO bhd_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","तैखन पौलुसे सूबेदारन मरां अक कुजाव, ते तैस सेइं ज़ोवं, “कि इस जवाने फौजी पलटनरे सरदारे कां नेथ, किजोकि ए किछ ज़ोंनेरे लेइ ओरोए।” ");
INSERT INTO bhd_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","बस्सा, तैनी तै फौजी पलटनरे सरदारे कां साथी नीयो, ते ज़ोने लगो, “अवं पौलुसे ज़ै कैदी आए, तैनी अवं कुजाव, ते तैनी मीं कां दरखुवास कियोरीए, कि इस जवाने अवं तीं कां एन्ही, किजोकि ए किछ तीं सेइं ज़ोनू चाते।” ");
INSERT INTO bhd_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","फौजी पलटनरे सरदारे तैस जवानेरो हथ ट्लेइतां तै कनारे ज़ेरे नीयो ते तैस पुच्छ़ने लगो, “तू मीं सेइं कुन ज़ोनू चातस?” ");
INSERT INTO bhd_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","तैनी जवाने ज़ोवं, “यहूदी लीडरेईं अकोट्ठे भोइतां तीं कां दरखुवास देनेरो फैसलो कियोरोए। कि तू पौलुसेरी पुछ़ गन केरनेरे बहाने तैस महासभा मां आनस। ");
INSERT INTO bhd_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","तू तैन केरि गल न मेन्ना, किजोकि कोई 40 मैनन् करां जादे यहूदी तैस पुड़ हमलो केरनेरी कोशिशी मां आन, तैनेईं कसम कमेवरी कि ज़ांतगर असां पौलुसे न मारम तांतगर असां किछ खाम या पींम, त असन लानत भोए, हुनी तैना तियारन, सिर्फ तेरे वादेरो इंतज़ारे।” ");
INSERT INTO bhd_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","फौजी पलटनरे सरदारे तै जवान वापस भेज़ो, ते तैस ज़ोवं कि गा, “एना गल्लां केरो ज़ैना तीं मीं सेइं ज़ोई, होरि केन्ची पतो न लोड़ी लग्गोरो।” ");
INSERT INTO bhd_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","तैखन तैनी दूई सूबेदार कुजाए, ते तैन सेइं ज़ोवं, “तुस 200 सिपाही ते 70 सुवार ते 200 भाले च़लानेबाले तियार रख्खा, तैनेईं राती 9 बज़ेई कैसरिया नगरे मां गानूए। ");
INSERT INTO bhd_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ते पौलुसेरे लेइ घोड़े तियार रखा, ताके तै गवर्नर फेलिक्स कां हफाज़ती सेइं पुज़ाव गाए।” ");
INSERT INTO bhd_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ते फौजरे प्रधाने अक चिट्ठी एस तरिकेरी लिखी। ");
INSERT INTO bhd_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“श्रीमान फेलिक्स गवर्नर क्लौदियुस लूसियासे जो नमस्कार। ");
INSERT INTO bhd_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ए तै मैनूए, ज़ै यहूदेईं ट्लातोरो थियो, ते एस तैना मारनेबाले थिये, त अवं सिपाही नेइतां साथी जेव, ते तै छुटाव, किजोकि मीं पतो थियो, कि तै अक रोमेरो रानेबालोए, त फौजी पलटन नेइतां छुटाव। ");
INSERT INTO bhd_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","लिहाज़ा एन ज़ान्नेरी केरनेरे लेइ कि तैना तैस पुड़ कुन इलज़ाम लातन, मीं तै तैन केरि महासभा मां पैश कियो। ");
INSERT INTO bhd_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ते पतो लगो, कि तैन केरो इलज़ाम तैन केरे कानूनेरे मुताबिक एसेरे खलाफ कोई एरो इलज़ाम नईं, कि ज़ेसेरे ज़िरिये सेइं असां तैस कैद केरम या मौतरी सज़ा देइ सखम। ");
INSERT INTO bhd_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","मीं पतो लग्गोरोए कि एसेरे खलाफ कोई साज़िश भोइ राहोरीए, ते मीं ए जल्दी तीं कांजो भेज़ोरोए, ते मीं तैस पुड़ दाओ केरनेबालन भी ज़ोरूए, कि तैना भी तीं कां अपनो मुकदमो पैश केरन।” ");
INSERT INTO bhd_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","सिपाही, फौजी पलटनरे सरदारेरे हुक्मेरे मुताबिक पौलुसे एप्पू सेइं साथी नेइतां रातो रात अन्तिपत्रिस नगरे मां पुज़ाव। ");
INSERT INTO bhd_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","होरसां दीसां घोड़ सुवारन तैस सेइं साथी अग्री-अग्री गानेरो हुक्म दित्तो, ते तै एप्पू किल्लै मांजो वापस च़लो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ज़ैखन घोड़ सुवार कैसरिया नगरे मां पुज़े त तैनेईं गवर्नरे कां चिट्ठी देइतां पौलुस तैस कां पैश कियो। ");
INSERT INTO bhd_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","गवर्नरे चिट्ठी पेढ़तां पुच़्छ़ू, “ए कौस इलाकेरो रानेबालोए?” ज़ैखन तैस पतो लगो कि ए किलिकिया इलाकेरो रानेबालोए। ");
INSERT INTO bhd_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","त तैनी ज़ोवं, कि अवं तेरो मुकदमो तैखन शुनेलो, “ज़ैखन तीं पुड़ दोष लाने बाले भी इड़ी हाज़र भोले।” तैखन तैनी हुक्म दित्तो कि पौलुसे हेरोदेसेरे पहेरे मां रख्खा। ");
INSERT INTO bhd_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पंच़े दिहैड़ना बाद हनन्याह महायाजके किछ बुज़ुर्ग ते तिरतुल्लुस नंव्वेरो वकील साथी कैसरिया नगरे मां पुज़े, ते गवर्नरे कां पैश भोइतां पौलुसेरां खलाफ फरयाद कमाई। ");
INSERT INTO bhd_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ज़ैखन पौलुस पैश कियो त तिरतुल्लुस इलज़ाम लेइतां ज़ोने लाव, “हे महान फेलिक्स, तेरे वजाई सेइं अस बड़े खुशी सेइं रातम, ते तेरे ज़िरिये सेइं इस कौमरी केत्री बुरैई सुधैरी गैतिन। ");
INSERT INTO bhd_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","एन अस हर ठैरी हर किसमे सेइं मन्तम। ");
INSERT INTO bhd_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","पन हुनी अवं तेरो जादे वक्त नेनो न चैईं, अवं तेरी मिनत केरताईं कि इश्शी अक दूई गल शुन। ");
INSERT INTO bhd_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","असेईं लाहेरूए कि ई मैन्हु बड़ो फसाद केरनेबालोए, ई दुनियारे सारे यहूदन मां फितनाबाज़े, ते नासरी कुपंथेरो प्रधान आए। ");
INSERT INTO bhd_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","एनी त मन्दरे भी अशुद्ध केरनेरी कोशिश की, ते एल्हेरेलेइ असेईं ए ट्लेइतां एस पुड़ अस अपने कानूनेरे मुताबिक मुकदमो च़लानो चाते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","पन फौजी पलटनरो सरदार लूसियास असन करां ज़बरदस्ती नेही जेव। ");
INSERT INTO bhd_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ते इस पुड़ दोष लाने बाले तीं कां हाज़र भोनेरो हुक्म दे। इन सेब्भी गल्लां केरे बारे मां अस एस पुड़ दोष लातम, तू एप्पू सच़ ज़ान।” ");
INSERT INTO bhd_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","यहूदी लोकेईं भी तैस सेइं साथी भोइतां ज़ोवं, कि एना गल्लां केन्च़ां भोइ सेकतिन। ");
INSERT INTO bhd_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ज़ैखन गवर्नरे पौलुसे बियांन देनेरे लेइ इशारो कियो, त पौलुसे जुवाब दित्तो, “अवं ज़ानताईं कि तू केही सालां केरो देंतो इस कौमरो इन्साफ केरनेबालो आस, एल्हेरेलेइ अवं अपनि सफाई तीं कां पैश केरताईं। ");
INSERT INTO bhd_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","तू एप्पू पतो केरि सखत्स कि अवं 12 दिहाड़े पेइले यरूशलेम नगरेरे मन्दरे मां आराधना केरनेरे लेइ जोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","मेरे मुदेइयेइं अवं मन्दरे मां केन्ची सेइं भी बेंस केरतो नईं लाहोरो, ते प्रार्थना घरे मां ते नगर मां इरां उरां लड़ाई केरतो भी नईं लाहोरो। ");
INSERT INTO bhd_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","हुनी एना इलज़ाम ज़ैना मीं पुड़ लांने लोरेन, ते तेरे सामने साबत न केरि सखे। ");
INSERT INTO bhd_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","हाँ अवं इकरार ज़रूर केरताईं कि ज़ैस पंथे एना कुपंथ ज़ोतन, अवं तैसेरे मुताबिक अपने दादे-पड़दादां केरे परमेशरेरी आराधना केरताईं, ते ज़ैन किछ मूसेरे कानूने ते नेबी केरि किताबी मां लिखोरूए, तैन सेब्भन पुड़ मेरो विश्वास आए। ");
INSERT INTO bhd_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","अवं परमेशरे पुड़ तैए भरोसो रखताईं, ज़ै तैना रखतन कि धर्मी लोकन ते पापी लोकन परमेशर मुड़दन मरां ज़ींतो केरेलो। ");
INSERT INTO bhd_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ते एल्हेरेलेइ मेरो ज़मीर परमेशरे कां भी ते इन्साने कां भी बेइलज़ाम राए। ");
INSERT INTO bhd_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","केही सालां केरे बाद अवं अपने गरीब लोकन दान पुज़ाने, ते च़ढ़तल च़ाढ़ने ओरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","तैखन एनेईं अवं मन्दरे मां लाव, त अवं शुद्ध भोनेरी रीत पूरी केरने लोरो थियो, बगैर लोक अकोट्ठे केरतां ते बगैर कोन्ची हंगामे इन कम केरतो लाव। पन तैना आसिया इलाकेरे किछ यहूदी थी, ते तैन जाईज थियूं। ");
INSERT INTO bhd_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","अगर मीं किछ गलत कियोरू भोथू त तैनेईं इड़ी तेरे सामने मीं पुड़ दोष लोरो लोड़तो थियो, किजोकि तैनेईं एप्पू लावरूए कि मीं मन्दरे मां कुन कियूं। ");
INSERT INTO bhd_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","इना लोक ज़ैना इड़ी ओरेन, एना ज़ोन कि ज़ैखन अवं महासभा मां पैश भोरो थियो, त एनेईं मीं मां कुन कसूर लाहोरो थियो? ");
INSERT INTO bhd_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","सुवाए इस गल्लरे कि ज़ै मीं बड़े ज़ोरे सेइं आवाज़ देइतां ज़ोरी थी, कि अवं ई विश्वास केरताईं परमेशरे मुड़दन ज़ींते केरते, एल्हेरेलेइ मीं पुड़ मुकदमो च़लाने लगोरेंन।” ");
INSERT INTO bhd_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","फेलिक्स ज़ै इस पंथेरे बारे मां ठीक-ठीक ज़ानतो थियो, एन ज़ोइतां मुकदमो बंद कियो, “ज़ैखन फौजी पलटनरो सरदारे लूसियास इड़ी एज्जेलो त अवं तुश्शे सामने इस मुकदमेरो फैसलो केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","तैनी सूबेदारे हुक्म दित्तो, कि पौलुसे पेरहे मां रख्खा, ते तैसेरे दोस्तन मरां केन्ची भी तैसेरी सेवा केरनेरे लेइ न रोकथ। ");
INSERT INTO bhd_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","केही दिहैड़ना बाद गवर्नर फेलिक्स अपनि कुआन्श द्रुसिल्ला ज़ै यहूदी थी, तै तैस सेइं साथी कैसरिया मां अव, तैनी पौलुसे जो समाद भेज़ो ते यीशु मसीह पुड़ विश्वास केरनेरे बारे मां गल्लां शुनाए। ");
INSERT INTO bhd_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ज़ैखन पौलुस एन ज़ोवं, कि परमेशरेरी नज़री मां कुन रोड़ूए ते अपने इच्छा कैबू केरनेरे बारे मां ते एजनेबाले परमेशरेरे इन्साफेरे बारे मां भी ज़ोवं, त फेलिक्स डेरि जेव, ते ज़ोने लगो, “हुनी तू गा, अगर फुर्सत मैलेली त अवं तीं फिरी तीं कुजेइलो।” ");
INSERT INTO bhd_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","तैस पौलुसे करां किछ मैलनेरी उमीद थी, एल्हेरेलेइ तै तैस बार-बार कुजातो थियो, ते तैस सेइं गल्लां केरतो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","पूरे दूई सालना बाद पुरकियुस फेस्तुस, फेलिक्सेरे ठैरी गवर्नर बनो, ते फेलिक्से यहूदी खुश केरनेरे लेइ पौलुस कैदखाने मां रख्खो। ");
INSERT INTO bhd_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","फेस्तुस तैस इलाके मां पुज़तां ट्लेइ दिहैड़ना बाद कैसरिया नगरेरां यरूशलेम नगरे मांजो जेव। ");
INSERT INTO bhd_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ज़ैड़ी प्रधान याजकेईं ते यहूदी लीडर तैस कां एइतां पौलुसेरे खलाफ दोष लाने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","तैना तैस कां मिनत केरने लगे, कि लूशी पौलुसे यरूशलेम नगरे मां हाज़र भोनेरो हुक्म दे, द्रासले मां तैनेईं तैस बत्तां मारनेरी साज़िश कियोरी थी। ");
INSERT INTO bhd_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","फेस्तुसे जुवाब दित्तो, “पौलुस कैसरिया नगरे मां कैदे, ते अवं भी तैड़ी लूशी गाने बालोईं।” ");
INSERT INTO bhd_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","फिरी ज़ोवं कि तुसन मरां किछ खास अधिकार रखनेबाले मीं सेइं साथी च़लन, “अगर सच़्च़े तैनी कोई गलत कम कियेरू भोए त तैस पुड़ दोष लान।” ");
INSERT INTO bhd_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ते फेस्तुस अठ दश दिहाड़े यरूशलेम नगरे मां राव, ते फिरी कैसरिया नगरे जो च़लो जेव, तैड़ी तै दुइयोवं दिहाड़े आदालतरी तखते पुड़ बिश्शो, ते हुक्म दित्तो कि पौलुसे हाजर केरा। ");
INSERT INTO bhd_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ज़ैखन पौलुस हाज़र भोव, त यरूशलेम नगरेरे यहूदी लीडरेईं तैस च़ुफुरतां घेरो देइतां बड़े झूठे इलज़ाम लांने शुरू किये। पन कोई पक्कू सबूत न मैल्लू। ");
INSERT INTO bhd_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","पौलुसे अपनि सफाई देंते बार यहूदी केरे झूठे इलज़ामा केरे लेइ इन्कार कियो, ते ज़ोवं, “मीं त यहूदी केरे कानूनेरे खलाफ कोई कसूर नईं कियोरो, ते न मन्दरेरे खलाफ ते न महाराज़ेरे खलाफ कोई कसूर कियोरोए।” ");
INSERT INTO bhd_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","पन फेस्तुस एप्पू यहूदी लीडरन खुश केरनेरे लेइ पौलुसे पुच़्छ़ू, “तीं यरूशलेम नगरे जो गानू मन्ज़ुरे, ताके अवं एस मुकदमेरो फैसलो तैड़ी केरि?” ");
INSERT INTO bhd_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","पौलुसे ज़ोवं, “अवं इड़ी महाराज़ेरे इन्साफेरे तखतेरे सामने खड़ो आईं, ते मेरे मुकदमेरो फैसलो इस्से ठैरी भोरो लोड़ते, ज़ैड़ी रोमी मैनेरो इन्साफ भोरो लोड़े, तू एप्पू भी रोड़ेच़ारे ज़ानतस कि मीं यहूदी केरो कोई कसूर नईं कियोरो। ");
INSERT INTO bhd_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","अगर अवं कुसुरवार आईं त मौतरी सज़ारे काबल आईं त मेरो मरनेरो इन्कार नईं, पन अगर ज़ैना झूठे इलज़ाम यहूदी मीं पुड़ लांने लगोरेंन ते अगर तैना झूठेन त केन्ची हक नईं कि मीं तैन केरे हवाले केरे। ते अवं इड़ी महाराज़े कां बिनती केरताईं, कि मेरो इन्साफ इड़ी कियो गाए।” ");
INSERT INTO bhd_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","तैखन फेस्तुस सल्लाकारन करां मुशोरो केरतां जुवाब दित्तो, “तीं महाराज़े कां बिनती कियोरीए त तू महाराज़े कां गालो।” ");
INSERT INTO bhd_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","किछ दिहैड़ना बाद अग्रिप्पा राज़ो ते तैसेरी निकड़ी बेइन बिरनीके कैसरिया नगरे मां एइतां फेस्तुसे सेइं मुलाकात की। ");
INSERT INTO bhd_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","तैन केरे बड़े दिहाड़े तैड़ी रानेरे बाद फेस्तुसे पौलुसेरे बारे मां राज़े ज़ोवं, “अक मैन्हु आए, ज़ै फेलिक्से कैद कियोरोए। ");
INSERT INTO bhd_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ज़ैखन अवं यरूशलेम नगरे मां थियो, त प्रधान याजक ते यहूदी बुज़ुर्ग तैस पुड़ दोष लगे लाने, कि एस सज़ा दित्ती गाए। ");
INSERT INTO bhd_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","पन मीं तैन ज़ोरू थियूं, कि रोमी केरे दस्तूरेरे मुताबिक कोई मैन्हु सज़ा देनेरे लेइ हवाले न कियो गाए, ज़ांतगर तैस अपने मुदेइ केरे सामने तैन इलज़ामा केरे बारे मां अपनि सफाई पैश केरनेरो मौको न दित्तो गाए। ");
INSERT INTO bhd_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","एल्हेरेलेइ ज़ैखन यहूदी लीडर इड़ी आए, त मीं ठढ न लाई, पन होरसां इन्साफेरे तखते पुड़ बिश्तां हुक्म दित्तो, कि पौलुस आदालती मां आनो गाए। ");
INSERT INTO bhd_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ज़ैखन तैसेरे मुदेइ अपनो दाओ पैश केरनेरे लेइ खड़े भोए त, तैनेईं कोई एरो इलज़ाम तैस पुड़ न लाव, ज़ेसेरी बारे मां अवं समझ़तो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","पन अपने फिरकेरे बल्के तैन केरि लड़ाई तैन केरे अपने धर्मेरे केन्ची यीशु नव्वेंरे मैनेरे बारे मां थी। तै मेरि जेवरोए, पन पौलुस तैस जो ज़ींतो ज़ोते। ");
INSERT INTO bhd_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","अवं बेड़ि उलझनी मां राहोरोइं कि केन्च़रे एन गल्लां केरो पतो केरि, एल्हेरेलेइ मीं पौलुसे पुच़्छ़ू, कि तीं यरूशलेम नगरे मां गानू मन्ज़ुरे, ताके एन गल्लां केरो फैसलो तैड़ी भोए? ");
INSERT INTO bhd_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","पन पौलुसे बिनती कमाई कि इस मुकदमेरो फैसलो महाराज़े कां लोड़ते भोरो, एल्हेरेलेइ मीं हुक्म दित्तो कि तै महाराज़े कां गाने तगर इड़ी पाबंद राए।” ");
INSERT INTO bhd_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","अग्रिप्पा राज़े फेस्तुसे सेइं ज़ोवं, “अवं भी एस मैनेरी गल्लां शुननी चाताईं।” तैनी जुवाब दित्तो, “तू तैसेरी गल्लां कालां शुनी सखत्स।” ");
INSERT INTO bhd_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","होरसां अग्रिप्पा राज़ो ते कने बिरनीके बेड़ि शांनी सेइं आए, ते फौजी पलटनरे सरदारेइं ते नगरेरे खास लोक सभा मां दाखल भोए, फेस्तुसे हुक्म दित्तो कि पौलुसे हाज़र केरा। ");
INSERT INTO bhd_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","फिरी फेस्तुस ज़ोवं, “हे अग्रिप्पा राज़ा ते बाकी लोकव तुस इस मैन्हु हेरतथ एसेरे खलाफ सैरी यहूदी कौमां मीं कां यरूशलेम नगरे मां भी ते इड़ी भी चिन्डां मैरतां दरखुवास कियोरी थी, कि ए मैन्हु ज़ींतो रखनो ठीक नईं। ");
INSERT INTO bhd_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","पन मीं पतो लगो कि एनी कोई एरू गलत कम नईं कियेरू, कि ए कत्ल कियो गाए, एल्हेरेलेइ एनी इड़ी बिनती कियोरीए, त अवं ठीक समझ़तां कि एस रोम नगरे मां भेज़ी। ");
INSERT INTO bhd_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","पन मीं तैसेरे बारे मां कोई ठीक गल न मैल्ली, कि महाराज़े जो लिखी, एल्हेरेलेइ मीं तै तुश्शे सामने ते खास केरतां अग्रिप्पा राज़ा, तेरे सामने पैश कियोरोए, ताके पुछ़ गन केरनेरे बाद अगर कोई खास गल भोए त अवं लिखी। ");
INSERT INTO bhd_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","किजोकि केन्ची कैदी भेज़ते बार तैसेरे इलज़ाम अगर अवं केन्ची न शुनेई त मेरी लेइ ठीक नईं।” ");
INSERT INTO bhd_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","अग्रिप्पा राज़े पौलुसे जो ज़ोवं, “तीं अपने बारे मां ज़ोनेरी अज़ाज़ते।” तैखन पौलुस अपनो हथ्थे सेइं इशारो केरतां अपनि सफाई पैश केरने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“हे अग्रिप्पा राज़ा, अवं अपनो आप खुश किस्मत समझ़ताईं, कि तेरे सामने खड़ो भोइतां यहूदी लोकां केरे प्रधानां केरे इलज़ामा केरे खलाफ अपनि सफ़ाई पैश केरने लगोरोइं। ");
INSERT INTO bhd_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","खास केरतां तू सारे यहूदी केरि रीति रुवाज़ेरे बारे मां ज़ानतस, ते एल्हेरेलेइ अवं तीं कां मिनत केरताईं, कि तू सबरी सेइं मेरी गल शुन। ");
INSERT INTO bhd_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","यहूदी मीं रोड़ेच़ारे ज़ानतन कि पेइले अवं अपने लोकन मां ते यरूशलेम नगरे मां ते मेरी जवेंनरो चालचलन केरहो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","तैना पेइले देंते मीं ज़ानतन ते अगर चान त मेरे हके मां गवाही देइ सकतन, कि अवं अपने पंथेरे मुताबिक फरीसी भोइतां अपने धर्मेरे सच़्च़े पंथे सेइं ज़िन्दगी गुज़रतो ओरोईं। ");
INSERT INTO bhd_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","परमेशरे इश्शे दादे-पड़दादन सेइं अक वादो कियोरो थियो, मीं उमीदे कि तै पूरो भोलो, तैस उमीदारी वजाई सेइं मीं पुड़ मुकदमो च़लेवरोए। ");
INSERT INTO bhd_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","एस वादेरे पूरे भोनेरी उमीद इश्शे 12 केरे 12 गोत्रने, एल्हेरेलेइ तैना दिले सेइं रात दिहाड़ी परमेशरेरी सेवा केरते रातन। हे अग्रिप्पा राज़ा मेरी इस उमीदरे लेइ यहूदी मीं पुड़ दोष लातन। ");
INSERT INTO bhd_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ज़ां कि परमेशर मुड़दन फिरी ज़ींते केरते, तुस इस गल्ली पुड़ विश्वास कि न केरथ? ");
INSERT INTO bhd_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“पेइले अवं भी समझ़तो थियो, कि यीशु नैसरेरे नव्वेंरी हर तरीके मुखालफत केरनि मेरो फरज़े। ");
INSERT INTO bhd_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","एल्हेरेलेइ अवं यरूशलेम नगरे मां एन्ने केरतो राव, मीं प्रधान याजकन करां अज़ाज़त एन्तां बड़े परमेशरेरे सेवक कैद केरतां छ़डे, ते ज़ैखन तैना मारे गाते थिये, त अवं भी तैड़ी खलाफत केरतो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","अवं प्रार्थना घरन मां गातो थियो, ते तैन केरि तुहीन केरतो थियो। ते लोकन यीशुएरे खलाफ तुहीन केरनेरे लेइ मजबूर केरतो थियो। ते मसीही लोकां केरि मुखालफत केरने सेइं मीं एत्री खुशी भोती थी, कि अवं दूर-दूर नगरन मां गेइतां तैन सतातो थियो।” ");
INSERT INTO bhd_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“एक्की बार प्रधान याजकन करां अधिकार एन्तां एस्से कम्मेरे लेइ दमिश्क नगरेरे सफर केरने लग्गोरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","त हे राज़ा अवं हेजू बत्तां थियो, त मीं दुपहरां केरे मौके अम्बरेरां अक लौ एंइती लाई, ज़ै दिहाड़ेरी लौई करां भी जादे थी, ते तै इश्शे च़ेव्रे पासन चमकने लगी। ");
INSERT INTO bhd_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","असां सब ज़मीनी पुड़ बिछ़ड़ी जे, ते मीं अक आवाज़ शुनी, ज़ै मीं सेइं इब्रानी भाषाई मां एन ज़ोने लगोरी थी। कि हे शाऊल हे शाऊल तू मीं किजो स्तातस? मीं सेइं लड़ाई केरनि तेरे लेइ बेकारे। ");
INSERT INTO bhd_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“त मीं जुवाब दित्तो, हे प्रभु तू कौन आस, त प्रभुए मीं जुवाब दित्तो अवं यीशु आईं ज़ैस तू सतातस? ");
INSERT INTO bhd_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","पन उठ ते अपने पवन पुड़ खड़ो भो, किजोकि मीं तीं एल्हेरेलेइ दर्शन दित्तोरूए, कि तीं अवं अपनो सेवक बनेइं, ते ज़ैन किछ तीं लाहेरूए तू तैसेरो गवाह बनस। ");
INSERT INTO bhd_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","अवं तीं तेरे लोकन करां ते गैर कौमन करां बच़ांतो रेइलो अवं तीं तैन मां भेज़ताईं। ");
INSERT INTO bhd_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ताके तू तैन केरि एछ़्छ़ी खोल्लस ते तैन आंधरे मरां लौई मां आनस ते कने शैताने करां छुटेइतां परमेशरेरे पासे आनस, ताके तैना मीं पुड़ विश्वास केरन ते परमेशर तैन केरे पाप माफ़ केरे, ते तैन लोकन मां शामिल भोन ज़ैना पवित्र कियोरेन, तैना विरासत हासिल केरन।” ");
INSERT INTO bhd_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ते एल्हेरेलेइ, “हे अग्रिप्पा राज़ा मीं एस स्वर्गेरे दर्शनेरो इन्कार नईं कमेवरो। ");
INSERT INTO bhd_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ते पेइले मीं दमिश्क नगरेरे लोकन मां ते फिरी यरूशलेम नगरेरे ते सारे यहूदिया इलाकेरे रानेबालो ते गैर कौमन भी प्रचार केरतो कियो। कि पापन करां मनफिराथ, ते परमेशरेरे पासे फिरा ते अपने स्भावे सेइं साबत केरा कि तुसेईं पापन करां मन फिरावरोए। ");
INSERT INTO bhd_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","एन्ने गल्लां केरे लेइ यहूदेईं अवं मन्दरे मां ट्लातो ते मारनेरी कोशिश की। ");
INSERT INTO bhd_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","“पन अवं परमेशरेरी किर्पाई सेइं अज़ तगर ज़ींतोईं, ते सेब्भी निक्के बड्डन कां अवं गवाही देताईं, कि ज़ैना गल्लां अवं ज़ोताईं कि ज़ैना नेबेईं ज़ोरी थी, ते मूसा नेबे भी ज़ोरी थी। ");
INSERT INTO bhd_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","कि मसीह बड़ो दुख भोगेलो, ते सेब्भन करां पेइलो मुड़दन मरां ज़ींतो भोइतां यहूदी कौमी त गैर कौमां केरे लोकन बच़ालो ज़ै लौअरो ज़ेरो आए।” ");
INSERT INTO bhd_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ज़ैखन पौलुस एन ज़ोने लग्गोरो थियो, त फेस्तुस ज़ोरे सेइं ज़ोवं, “तू पागल भोइ जेव। जादे ज्ञाने सेइं तू पागल भोइजेवरोस।” ");
INSERT INTO bhd_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","पौलुसे जुवाब दित्तो, “जनाब फेस्तुस साहब अवं पागल नईं भोरो, अवं ज़ैन किछ ज़ोने लगोरोइं तैन सच़्च़े ते ज्ञाने सेइं आए। ");
INSERT INTO bhd_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","राज़ो भी ज़ेसेरे सामने अवं निडर भोइतां एन गल्लां ज़ानते, ते मीं याकीने कि एन मरां कोई भी गल तैस करां छ़पोरी नईं, किजोकि ए चमत्कार कोई एरो नईं भोरो। ");
INSERT INTO bhd_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","हे अग्रिप्पा राज़ा कुन तू नेबी केरो, अवं ज़ानताईं कि तू मनतस?” ");
INSERT INTO bhd_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","अग्रिप्पा राज़े पौलुसे सेइं ज़ोवं, “कुन तू थोड़ी ज़ेरि गल्लेईं सेइं मीं तू मसीही बनानो चातस?” ");
INSERT INTO bhd_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पौलुसे जुवाब दित्तो, चाए थोड़ी ज़ेरि या जादे गल्लेईं सेइं, “पन अवं त परमेशरे कां प्रार्थना केरताईं कि, न सिर्फ तू बल्के ज़ेत्रे भी अज़ मेरी गल्लां शुनी रावरेन सब मेरे ज़ेरे मसीही भोन, पन इन शंगलां केरे बगैर।” ");
INSERT INTO bhd_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","तैखन अग्रिप्पा राज़ो ते गवर्नर ते बिरनीके ते तैस सेइं साथी होरे भी खड़े भोए ते च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ते बेइर निस्तां एक्की होरि सेइं ज़ोने लगे, “कि ए मैन्हु कोई एरू कम त नईं लोरो केरने, कि एस मौतरी सज़ा दित्ती गाए, या कैदखाने मां रख्खो गाए। ");
INSERT INTO bhd_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","अग्रिप्पा राज़े फेस्तुस सेइं ज़ोवं, अगर एनी मैने महाराज़े कां फरयाद न भोथी कियोरी त ए छुटी सकतो थियो।” ");
INSERT INTO bhd_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ज़ैखन फिस्तुस हाकिमेरे ज़िरिये ए बिस्तार बनों कि असां लोक ज़िहाज़े मां इतालिया जो गाम, त पौलुस त होरे कैदी यूलियुस नंव्वे औगुस्तुस फौजी पलटनरे सरदारेरे एक्की सूबेदारेरे सुपुर्द किये। ");
INSERT INTO bhd_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","असां अद्रमुत्तियुम नगरेरां एक्की समुन्दरी ज़िहाज़े मां च़ेढ़तां आसिया इलाकेरे नेड़ेरे ठैरी गानेबाले थिये, त अरिस्तर्खुस नंव्वे थिस्सलुनीके नगरेरो अक मकिदुनी असन सेइं साथी थियो। ");
INSERT INTO bhd_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","होरसां ज़ैखन ज़िहाज़ सैदा मां रुकी जेवं, त यूलियुसे पौलुसे पुड़ महरबानी केरतां तैस अपने दोस्तन सेइं मुलाकात केरनेरी अज़ाज़त दित्ती, ताके तैसेरे ज़िरिये सेइं पतो लग्गे। ");
INSERT INTO bhd_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","तैट्ठां फिरी असां ज़िहाज़े मां च़ेढ़तां च़ले जे, ते साइप्रसेरे आड़ी मांमेइं निस्से, किजोकि हवा बड़ी ज़बरदस्त थी। ");
INSERT INTO bhd_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","फिरी किलिकिया नगरे ते पंफूलिया नगरेरे नेड़े समुन्द्रेरी बत्तां निस्तां अग्रोवं च़ले जे, त लूसिया इलाकेरे मूरा नगर मां ओस्से। ");
INSERT INTO bhd_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","तैड़ी सूबेदारे सिकन्दरिया नगरेरू अक ज़िहाज़ इतालिया इलाके जो च़लेरू मैल्लू, तैनी असां तैस मां च़ाढ़े। ");
INSERT INTO bhd_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","असां बड़े दिहाड़न तगर बल्हे-बल्हे अग्रोवं च़लते राए, ते कनिदुस नगरेरे सामने पुज़े। पन तेज़ हवा च़लने सेइं असन अग्रोवं गानेरी मुशकिल भोइजेइ, ते एल्हेरेलेइ असां सलमोनेरे सामने निस्तां क्रेतेरी आड़ी मां निस्से। ");
INSERT INTO bhd_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ते बेड़ि मुशकली सेइं समुद्रेरे बन्ने-बन्ने अग्रोवं च़लते शुभलंगरबारी नंव्वेरी एक्की ठैरी पुज़े, ज़ैट्ठां लसया नगर नेड़ू थियूं। ");
INSERT INTO bhd_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","तैड़ी असन केही दिहाड़े बीते, पैनेरे सफरे मां मुशकिल एल्हेरेलेइ भोती थी, कि छुटकारेरी दिहाड़ी तिहारेरे बरतेरे दिहाड़ो बीतोरे थी, ते पौलुसे तैन एन ज़ोइतां खबरदारी दित्ती, ");
INSERT INTO bhd_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“जनाब मीं एरू लग्गते कि इश्शू सफर बड़ू खतरनाक भोलू, कि न सिर्फ इश्शे माल सबाब ते ज़िहाज़े बल्के इश्शी जानी भी खतरोए।” ");
INSERT INTO bhd_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","पन सूबेदारे कपताने ते ज़िहाज़ेरे मालिकेरी गल पौलुसेरी गल करां जादे मन्नी। ");
INSERT INTO bhd_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","किजोकि तै बंदरगह ठंढारो मौसम कटनेरे लेइ रोड़ी न थी, एल्हेरेलेइ इश्शो फैसलो ए थियो, कि असां केन्ची तरीके अग्रोवं निस्सम ते असन उमीद थी, कि फीनिक्स मां पुज़तां हीवतड़ेरो मौसम तैड़ी गुज़ैरी गामेले। ए क्रेते अक बंदरगह थी, ज़ैसेरां दारां क्षिण-पश्चिम ते उत्तर-पश्चिम पासे खुलतां थियां। ");
INSERT INTO bhd_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ज़ैखन दक्षिणी पासेरां हवा च़लने लगी, त तैनेईं सोचू कि तैन केरि मर्ज़ी पूरी केरनेरे लेइ रोड़ो वक्ते, ते तैनेईं ज़िहाज़ेरू लैंगर तैट्ठां खड़ू कियूं, ते समुन्दरेरे बन्ने अग्रोवं च़लते जे। ");
INSERT INTO bhd_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","पन लूशी अक बड़ी तूफानी हवा च़ली ज़ैस जो यूरकुलीन ज़ोतन। ");
INSERT INTO bhd_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ज़ैखन तैने ज़िहाज़ अपने पलैट्टे मां कियूं, ते ज़िहाज़ ढ्लैक्कां खाने लगू, ते असेईं ज़िहाज़ हावारे बहावे पुड़ छ़डू। ");
INSERT INTO bhd_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","तैखन कौदा नंव्वेरो अक निकड़ो टैपू अव, त असेईं भी रुड़ते-रुड़ते तै डुंगी ज़ै ज़िहाज़ेरे पत्तोरां बंधोरी थी, त बेड़ि मुशकली सेइं कैबू मां की। ");
INSERT INTO bhd_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ते ज़िहाज़ेरे टोलरे मैनेईं तै उब्री च़ेढ़तां ज़िहाज़ ट्लुटने करां बच़ानेरे लेइ रेस्सेइं सेइं बेंधतां छ़डू। किजोकि तैन डर थियो, कि एरू न भोए, कि ज़िहाज़ सुरतिसेरे रेती मां डुबी गाए, एल्हेरेलेइ तैनेईं भारी सामान ओसालू ते ज़िहाज़े मां रुड़ते-रुड़ते च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ज़ैखन तूफानी हवाई सेइं ज़िहाज़ जादे ढ्लैक्कां खाने लगू, त होरसां असेईं ज़िहाज़ेरो माल समुन्द्रे मांजो शारनो शुरू कियो, ");
INSERT INTO bhd_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ट्लेइयोवं दिहाड़े तैनेईं ज़िहाज़ेरू सामान भी समुन्द्रे मांजो शैरी छ़डू। ");
INSERT INTO bhd_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","त काई दिहाड़े न असेईं दिहाड़ो लाव ते न तारे ते तूफान भी मन्ना जादे ज़ोर केरने लग्गोरो थियो, ते असन बच़नेरी हुनी कोई उमीद न राई। ");
INSERT INTO bhd_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","रोट्टी खाने काई दिहाड़े भोरे थिये, एल्हेरेलेइ पौलुसे तैन मां खड़े भोइतां ज़ोवं, “ढ्लाव अगर तुसेईं मेरू ज़ोनू मन्नोरू भोथू, ते क्रेते मरां अग्रोवं न ओरे भोथे, त ई नुकसान ते ई तकलीफ किजो भोनी थी? ");
INSERT INTO bhd_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","“पन अवं तुसन कां मिनत केरताईं कि, हिम्मत न हारा तुसन मरां कोई भी न मरेलो, चाए ज़िहाज़ डुबी किना गाए। ");
INSERT INTO bhd_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","किजोकि ज़ैस परमेशरेरी अवं आराधना केरताईं, तैसेरो स्वर्गदूत हीज राती मीं कां ओरो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ते तै ज़ोने लगो, हे पौलुस डर नन्ना तू महाराज़े कां ज़रूर पैश भोलो ते परमेशर तेरी वजाई सेइं एन सेब्भी केरि जान बच़ालो, ज़ैना ज़िहाज़े मां तीं सेइं साथी आन। ");
INSERT INTO bhd_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","एल्हेरेलेइ हे जनाब तुस हिम्मत रखा कि मेरे परमेशरे ज़ैन किछ मीं सेइं ज़ोरूए तैन्ने भोलू। ");
INSERT INTO bhd_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","असां ज़रूर केन्ची टेपू पुड़ पुज़ी गामेले।” ");
INSERT INTO bhd_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","च़ेवधोवं राती ज़ैखन असां अद्रिया समुन्द्रे मां इरां उरां फिरते थिये, त ज़िहाज़े बाले मैनेईं अंदाज़ो लाव कि असां बन्नेरे नेड़े पुज़ी जोरेम। ");
INSERT INTO bhd_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","तैनेईं पानी रेसी सेइं नापू त 37 मीटर निससू ते थोड़े अग्गर गेइतां नापू त 27 मीटर निससू। ");
INSERT INTO bhd_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","एस डरे सेइं कि कोस्कोई शफ़ड़ी सेइं न बज़्म, ते तैनेईं ज़िहाज़ेरे पैतरीं पासे च़ेव्रे लैंग्रां समुन्द्रे मां छ़डां ते झ़ेझ़ेरे लौअरे लेइ प्रार्थना केरने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ज़िहाज़ च़लानेबाले मुझ़ाटेरां बेइरोवं निसनेरे लेइ डोंगी उन्ढी ओसाली। पन तैना ज़िहाज़ेरे एग्री पासेरां लैंग्र पैनी मां छ़डनू चाते थिये। ");
INSERT INTO bhd_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","तैखन पौलुसे सूबेदारे ते सिपेहिन सेइं ज़ोवं, “अगर इना लोक ज़िहाज़े मां न भोले त तुश्शू लोकां केरू बच़नू मुशकले।” ");
INSERT INTO bhd_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","एल्हेरेलेइ सिपैहीयेइं डूंगारी रेस्सी केटतां समुन्द्रे मांजो शैरी दित्ती। ");
INSERT INTO bhd_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","झ़ेझ़ भोने करां पेइले पौलुसे सेब्भन कां मिनत कमाई, कि तुस किछ रोट्टी खाथ। तैनी ज़ोवं, “तुस च़ेवधे दिहैड़ी केरे देंते बंच़नेरे खियाले मां पेवरेथ, ते तुस रोट्टी सेइं हुरोरे भी नईं। ");
INSERT INTO bhd_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","अवं तुसन कां मिनत केरताईं कि तुस रोट्टी खाथ, किजोकि तुश्शे लेइ रोड़ू एन्ने कि याकीन केरा कि तुश्शो बाल बिंगो न भोलो।” ");
INSERT INTO bhd_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ज़ैखन तैनी एन ज़ोवं, त तैनी रोट्टी ट्लाई ते सेब्भी केरे सामने परमेशरेरू शुक्र केरतां ट्लोड़ी ते खाने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","तैस करां लेइतां होरन भी हिम्मत आई, ते तैना भी रोट्टी खाने लगे। ");
INSERT INTO bhd_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","असां सब मिलतां कोई 276 मैन्हु थिये, ज़ैना इस ज़िहाज़े मां सुवार थिये। ");
INSERT INTO bhd_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ज़ैखन तैनेईं रेज़तां रोट्टी खाइ त तैनेईं सारे गेहुं समुन्द्रे मांजो शारने शुरू किये, ताके ज़िहाज़ पोल्लु भोए। ");
INSERT INTO bhd_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ज़ैखन दिहाड़ो निस्सो त तैनेईं तै ठार न पिशानी, पन अक ठार लाई ते तै पासो साफ थियो, तैनेईं बिस्तार कमाव कि अगर भोइसखे त असां ज़िहाज़ एस पुड़ च़ाढ़म। ");
INSERT INTO bhd_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","बस्सा लैंगर खोलतां समुन्द्रे मां छ़ैडी दित्तू, ते पत्रवारां केरि रेसी भी ढिल्ली छ़ैडी, एग्रीयों बादबांन भी बा च़ैढ़ी छ़ड्डो, ते एप्पू बन्नेरे पासे जो च़ले। ");
INSERT INTO bhd_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","पन ज़िहाज़ खुशकी पुड़ गेइतां रेती पुड़ टिकी जेवं, ते ज़िहाज़ेरो एग्रीयों पासो रेती मां डुबी जेवं ते पैत्रीयों पासो छ़ेल्लेईं सेइं बज़कने लगो। ");
INSERT INTO bhd_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","सिपेही केरि सल्लाह थी कि कैदन मारम ताके तैन मरां कोई तारी देइतां नेशी न गान। ");
INSERT INTO bhd_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","पन सूबेदारे पौलुसेरी जान बच़ांनेरे लेइ एन न दित्तू केरने, ते हुक्म दित्तो कि ज़ै तारी ज़ानते त तै पेइलो छाल मारे, ते खुशकी पुड़ पुज़तां अपनि जान बच़ाए। ");
INSERT INTO bhd_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ते बाकी होरे लेकड़ारे तखतन पुड़ ते ज़िहाज़ेरी होरि चीज़ां केरि मद्दती सेइं अपनि जान बच़ाथ, ते बस्सा सब एस तरीके सेइं खुशकी पुड़ ठीक ठाक पुज़ी जे। ");
INSERT INTO bhd_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ज़ैखन असां ठीक ठाक बन्ने पुड़ पुज़े, त असन पतो च़लो कि इस टैपू जो माल्टा ज़ोतन। ");
INSERT INTO bhd_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","तैट्ठेरे राने बालेईं असन सेइं बड़ो रोड़ो बर्ताव कियो, झ़ड़ी लग्गोरी थी, ते ठंढ भी बड़ी थी, तैनेईं अग बाली ते इश्शी बड़ी आदर कमाई। ");
INSERT INTO bhd_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","पौलुसे कैड़ु केरो अक लेग्गु बनावं, ते ज़ैखन तै तैना कैड़ु अग्गी मां छ़डने लगो त अगारे सेके सेइं तैन कैड़न मरां अक सप निस्सो, ते पौलुसेरे हथ्थे सेइं पलेटोव। ");
INSERT INTO bhd_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ज़ैखन तैन लोकेईं सप पौलुसेरे हथ्थे सेइं पलेटोरो लव, त एप्पू मांमेइं ज़ोने लगे, “ए मैन्हु ज़रूर कोई खूनी आए, ए समुन्द्रे मां गर्क भोने करां त बच़ोरोए, पन इन्साफे ए ज़ींतो न राने न दित्तो।” ");
INSERT INTO bhd_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","पन तैनी तैस सप्पे अग्गी मांजो घिल देइतां ट्लट्टो, ते तैस किछ नुकसान न भोव। ");
INSERT INTO bhd_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","तैना लोक बलगने लग्गोरो थिये, कि एसेरी सारी जान एफरी गानीए ते ए मेरि गानोए, ते बड़े च़िरे तगर बलगनेरे बाद पौलुसे किछ न भोवं, त तैना लोक सोचने लगे, “ए ज़रूर कोई देबतोए।” ");
INSERT INTO bhd_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","तैस ठैरारे आसे-पासेरे टैपेरी प्रधान पुबलियुसेरी ज़मीन थी, तैनी असां अपने घरे ने ते ट्लाई दिहाड़े इश्शी आदर खातर की। ");
INSERT INTO bhd_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","पुबलियुसेरे बाजी भुखार ते पैचसी सेइं बड़ो बिमार भोरो थियो, ते पौलुसे तैस कां गेइतां तैसेरेलेइ प्रार्थना की, ते तैस पुड़ हथ रेखतां तै बझ़ाव। ");
INSERT INTO bhd_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","फिरी तैस टैपेरे बाकी बिमार लोक आए ते तैना ठीक भोइ जे। ");
INSERT INTO bhd_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","तैन लोकेईं इश्शी बड़ी इज़्ज़त की, ते असां तैट्ठां अग्रोवं गानेरे लेइ तियार भोए, त तैनेईं इश्शी ज़ुरुरतरी सैरी चीज़ां ज़िहाज़े मां छ़ैडी दित्ती। ");
INSERT INTO bhd_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","इश्शू ज़िहाज़ बिगड़नेरे ट्लेइ महिना बाद असां सिकन्दरियारे एक्की ज़िहाज़े मां च़ले जे, ज़ैन ठंढ मुकने तगर तैस टैपू मां रुकेरु थियूं, तैस मां यूनैनी केरि दूई अकोट्ठी देबतेरी मूरतां बनोरी थी। ");
INSERT INTO bhd_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","पेइले असां सुरकूसा नगरे मां पुज़े, ते ट्लाई दिहाड़े तैड़ी राए। ");
INSERT INTO bhd_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","तैट्ठां असां च़लते-च़लते रेगियुम नगरे मां पुज़े, ते होरसां दक्षिणी हवा च़लने लगी ते असां होरसां पुतियुली नगरे मां पुज़े। ");
INSERT INTO bhd_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","तैड़ी असन किछ ढ्ला भी मैल्ले, तैनेईं असां कुजाए ते असां तैड़ी सत दिहाड़े राए, ते तैसेरां बाद असां रोमे मां पुज़े। ");
INSERT INTO bhd_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","तैट्ठेरे मसीही ढ्लान पतो लगो, कि असां ओरेम त तैना असन अगराने अप्पियुसेरे चौके ते ट्लेइ धर्मशालन तगर आए, पौलुसे तैना लेइतां परमेशरेरू शुक्र कियूं ते तैस बड़ी हिम्मत भोइ। ");
INSERT INTO bhd_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ज़ैखन अस रोम नगरे मां पुज़े ते पौलुसे अज़ाज़त मैल्ली, कि तै एक्की पैरहेदारी निगरेंनी मां ज़ैड़ी चाए गेइ सकते। ");
INSERT INTO bhd_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ज़ैखन ट्लाई दिहाड़े बीते त पौलुसे यहूदी केरे प्रधान कुजाए, ते ज़ैखन तैना अकोट्ठे भोए त पौलुसे तैन सेइं ज़ोवं, “ढ्लाव मीं अपनि कौमरे ते अपने दादे-पड़दादां केरि रसमरे खलाफ कोई कम नईं कियेरू त फिर भी अवं पाबंद केरतां यरूशलेम नगरे मां रोमी सरकारारे हवाले कियो। ");
INSERT INTO bhd_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","तैनेईं पुछ़ गन केरनेरे बाद अवं हथरां छ़डनो थियो। किजोकि मीं कोई एरू कम न थियूं कियेरू कि ज़ैस सेइं मीं मौतरी सज़ा देथे। ");
INSERT INTO bhd_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","पन ज़ैखन यहूदेईं मुखालफत की, त मीं महाराज़े कां बिनती की। पन एल्हेरेलेइ नईं कि अवं अपनि कौमी पुड़ कोई इलज़ाम लांनो चातो थियो। ");
INSERT INTO bhd_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","एल्हेरेलेइ मीं एन रोड़ू समझ़ू, कि तुसन सेइं मिलतां गल केरि, अवं इस्राएलेरी एक्की उमीदी ज़ै मसीह आए शांगलन सेइं बंधोरोइं।” ");
INSERT INTO bhd_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","तैनेईं तैस सेइं ज़ोवं, “असन यहूदन करां न कोई चिट्ठी मैल्ली ते न तैट्ठां एजनेबाले इश्शे लोकेईं तेरे बारे मां कोई खबर दित्ती, ते न तेरे खलाफ किछ ज़ोवं। ");
INSERT INTO bhd_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","पन असां तेरे बारे मां ज़ाननू चातम, ए त असन पत्तोए, कि लोक सेब्भी ठैरन एस पंथेरे खलाफ गल्लां केरतन।” ");
INSERT INTO bhd_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","तैखन यहूदी लोकेईं पौलुसेरी गल्लां शुन्नेरे लेइ अक दिहाड़ी ठुवहलाई, ज़ैखन तै दिहाड़ी आई, त लोक पेइले लोकन करां भी जादे अकोट्ठे भोए। पौलुसे तैन परमेशरेरे राज़्ज़ेरे बारे मां समझ़ाव, ते साथी यीशुएरे बारे मां मूसेरे कानूने ते नेबी केरे किताबन मरां तैन रोड़ेच़ारे समझ़ेइतां झ़ेझ़ां करां ड्लोझ़ी तगर गल्लां शुनातो राव। ");
INSERT INTO bhd_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","किछ तैसेरी गल्लां शुन्तां मघन भोइ जे ते मन्नू ते किछेईं विश्वास भी कियो। ");
INSERT INTO bhd_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ज़ैखन तैना एप्पू मांमेइं अक न भोए, त पौलुसे तैन गाने करां पेइले अक गल ज़ोई, “पवित्र आत्मारे ज़िरिये यशायाह नबी तुश्शे दादे-पड़दादां केरे बारे मां ठीके ज़ोरू थियूं।” ");
INSERT INTO bhd_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","एन लोकन कां गा, ते एन ज़ो कि, “तुस शुन्ते त राले, पन समझ़ेले न, ते तकते त राले पन पिशानेले न। ");
INSERT INTO bhd_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","किजोकि एन लोकां केरे दिले मोट्टे भोरोरेन, ते एना टोव्ने भोरोरेन, ते एनेईं अपनि एछ़्छ़ी निकोल कियोरिन। किजोकि एरू न भोए, कि एना लहन ते कन्न सेइं शुन्न ते दिले सेइं समझ़न, ते एना मेरे पासे फिरन ते अवं एन शिफ़ा देईं। ");
INSERT INTO bhd_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“एल्हेरेलेइ अवं चाताईं कि तुस ज़ानथ कि परमेशरेरी मुक्ति गैर कौमन कां भी भेज़ोरोए ते तैना तैस शुनेले।” ");
INSERT INTO bhd_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ज़ैखन पौलुसे एन ज़ोवं, त यहूदी एप्पू मांमेइं बेंस केरते तैट्ठां च़ले जे। ");
INSERT INTO bhd_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","पौलुस पूरे दूई सालन तगर क्रैइयेरे मुकाने मां राव, ");
INSERT INTO bhd_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ते ज़ै भी तैस सेइं मिलने एइतो थियो, पौलुस तैस सेइं मिलतो थियो, ते बेधड़क भोइतां परमेशरेरे राज़्ज़ेरी खुशखबरी शुनातो थियो, ते प्रभु यीशु मसीहेरे बारे मां शिक्षा देंतो राव।");
INSERT INTO bhd_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","अवं पौलुस यीशु मसीहेरो दास आईं, ते प्रेरित भोनेरे लेइ परमेशरे च़ुनोरोईं, ते परमेशरेरी खुशखबरी प्रचार केरनेरे लेइ ठहरावरो आईं। ");
INSERT INTO bhd_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ज़ेसेरी तैने पेइले अपने नेबी केरे ज़िरिये पवित्रशास्त्रे मां, ");
INSERT INTO bhd_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","अपने मट्ठे इश्शे प्रभु यीशुएरे बारे मां वादो कियोरो थियो, ज़ै जिसमेरे मुताबिक त दाऊदेरे खानदाने मरां पैदा भोव। ");
INSERT INTO bhd_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ते पवित्र आत्मारे ज़िरिये सेइं मुड़दन मरां ज़ींतो भोनेरे वजाई सेइं तै शेक्ति सेइं परमेशरेरू मट्ठू भोव। ");
INSERT INTO bhd_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ज़ेसेरे ज़िरिये असन अनुग्रह ते प्रेरिताई मैल्ली; कि तैसेरे नंव्वे सेइं सब कौमां केरे लोक विश्वास केरतां तैसेरी मन्न। ");
INSERT INTO bhd_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ज़ैन मरां तुस भी यीशु मसीहेरे भोनेरे लेइ कुजोरेथ। ");
INSERT INTO bhd_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","अवं ई चिट्ठी तुश्शे सेब्भी केरे नंव्वे लिखताईं, ज़ैना तुस रोम नगरे मां रातथ, ते परमेशरेरे ट्लारेथ, ते पवित्र भोनेरे लेइ च़ुनोरेथ। इश्शे बाजी परमेशर ते प्रभु यीशु मसीहेरे तरफां तुसन शान्ति ते अनुग्रह मैलतो राए। ");
INSERT INTO bhd_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","पेइलो अवं तुश्शे सेब्भी केरे लेइ यीशु मसीहेरे ज़िरिये परमेशरेरू शुक्र केरताईं, किजोकि तुश्शो विश्वास ज़ै यीशु मसीह पुड़ आए, तैसेरी चर्चा हर पासे भोने लोरी। ");
INSERT INTO bhd_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","परमेशर ज़ेसेरी सेवा अवं अपने पूरे दिले सेइं तैसेरे मट्ठेरी खुशखबरी प्रचार केरतां केरताईं, तै मेरो गवाहे; कि अवं तुसन कोस तरीके सेइं लगातर प्रार्थनाई मां याद केरताईं। ");
INSERT INTO bhd_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ते लगातार अपने प्रार्थनान मां बिनती केरतो राताईं, कि केन्च़रे हेजू भी तुसन कां एजनेरे लेइ मेरू सफर परमेशरेरे तरफां कामयाब भोए। ");
INSERT INTO bhd_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","किजोकि अवं तुसन सेइं मिलनेरे लेइ कोशिश केरताईं, कि अवं तुसन कोई आत्मिक वरदान देईं, ज़ैस सेइं तुस विश्वासे मां मज़बूत भोथ। ");
INSERT INTO bhd_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","मतलब इन, कि अवं तुसन कां एइतां तुसन सेइं साथी तैस विश्वासेरे ज़िरिये, ज़ै मीं मां ते तुसन मांए, तैसेरे ज़िरिये अस हिम्मत हासिल केरम। ");
INSERT INTO bhd_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ते ढ्लाव ते बेइनव, अवं चाताईं तुस ज़ानथ, कि मीं तुसन कां बार-बार एजनू चाव। ज़ेन्च़रे मीं गैर कौमरे लोकन विश्वास केरनेरे लेइ बद्धनेरी मद्दत की, तेन्च़रे तुश्शी भी मद्दत केरि, पन हुना तगर रुकोरो राव। ");
INSERT INTO bhd_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","अवं संस्कारी लोकन ते असंस्कारी लोकन, पढ़ोरे लोकन या अनपड़ लोकन सेब्भन खुशखबरी शुनेइलो। ");
INSERT INTO bhd_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ते अवं तुसन भी ज़ैना रोम नगरे मां रातथ, खुशखबरी शुनानेरे लेइ हर वक्त तियार आईं। ");
INSERT INTO bhd_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","किजोकि अवं यीशु मसीहेरी खुशखबरी प्रचार केरने करां न शरमेई, एल्हेरेलेइ परमेशर अपने शक्ति सेइं तैन लोकन मुक्ति देते, ज़ैना खुशखेबरी पुड़ विश्वास केरतन, पेइले यहूदन फिरी गैर यहूदन। ");
INSERT INTO bhd_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","किजोकि खुशखेबरारे ज़िरिये परमेशर असन अपने नज़री मां धर्मी बनाते, ज़ैन शुरू करां आखरी तगर विश्वासे सेइं भोते। ज़ेन्च़रे पवित्रशास्त्रे मां लिखोरूए, “ज़ै मैन्हु विश्वासेरे ज़िरिये सेइं परमेशरेरे सामने धर्मी बनाव गाते तैए ज़ींतो रालो।” ");
INSERT INTO bhd_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","परमेशरेरो क्रोध तैन लोकन पुड़ स्वर्गेरां एइते, ज़ैना बुरां ते दुष्टेरां कम्मां केरतन, ते ज़ैना सच़्च़े अधर्मे सेइं दबेइतां रखतन। ");
INSERT INTO bhd_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","किजोकि परमेशरेरे बारे मां ज्ञान तैन मैन्हु केरे मन्न मां बांदूए, एल्हेरेलेइ कि परमेशरे तैन पुड़ बांदू कियोरूए। ");
INSERT INTO bhd_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","किजोकि तैसेरे आहेरे गुण, मतलब तैसेरी सदारी शक्ति, ते परमेशरेरो सुभाव दुनियाई बनानेरे वक्तेरे देंतो तैसेरे कम्मन सेइं हेरने मां एइते, इड़ी तगर कि तैन लोकन कां कोई बहानो नईं। ");
INSERT INTO bhd_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","हांलाकि तैनेईं परमेशर त पिशानो, पन परमेशरेरी तैस काबल बड़याई न की, ते न शुक्र कियूं, पन बेकार सोचने लाए, इड़ी तगर कि तैन केरो बेअक्ल मन आंधरो भोव (मतलब तैना गलत सोचने लगे)। ");
INSERT INTO bhd_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","तैना अपने आपे अक्लमन्द सेमझ़तां बेवकूफ बने। ");
INSERT INTO bhd_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ते न मरने बाले परमेशरेरी महिमा मरने बाले मैन्हु, ते च़ुड़ोलू ते जानवरां, ते पेटेरे भारे च़लने बाले जीपां केरे मूरतन मां बदली। ");
INSERT INTO bhd_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","एल्हेरेलेइ परमेशरे तैना तैन केरे मनेरे खुवैइशां केरे मुताबिक अशुद्ध भोनेरे लेइ शारे कि, एप्पू मांमेइं अपने जानां केरी अनादर केरन। ");
INSERT INTO bhd_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","किजोकि तैनेईं परमेशरेरी सच़्च़ाई बेदलतां झूठ बनाई, ते सृष्टारी पूज़ा ते आराधना केरि, न कि तैस बनाने बालेरी, ज़ै हर वक्त धन ते रोड़ोए। आमीन। ");
INSERT INTO bhd_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","एल्हेरेलेइ परमेशरे तैना नीच़ खुवाइशन मां शारे, इड़ी तगर कि तैन केरि कुआन्शेईं भी स्भाविक कम्मां बेदलतां तैन केरे ज़ैना स्भाविक आन तैन केरे खलाफ बदला। ");
INSERT INTO bhd_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","तेन्च़रे तैन केरे मड़द भी कुआन्शन सेइं सुभाविक कम्मां शैरतां एप्पू मांमेइं गंदे कम्मन मां मसत भोए, मतलब कि मड़देइं, मड़दन सेइं रिश्तो रेखतां प्रभु करां ठीक बदलो नेव। ");
INSERT INTO bhd_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ते तैनेईं इन जेइज़ न समझ़ू कि परमेशरे कबूल केरन, एल्हेरेलेइ परमेशरे भी तैना तैन केरे मनेरे हालती पुड़ शारे; कि बुरां कम्मां केरन। ");
INSERT INTO bhd_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ते तैना हर किसमेरे अधर्मे, दुष्टे, लालच़े, बैरे सेइं भेरोई जे; ते कपट, ते खून केरनो, ते लड़ाई केरनि, ते धोखो देनो, ते जलनी सेइं भेरोए, ते चोगलखोर, ");
INSERT INTO bhd_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","बदनाम केरनेबाले, परमेशरे सेइं नफरत केरनेबाले, ज़ैन केरि इज़्ज़त केर्री लोड़े तैन केरि इज़्ज़त न केरनेबाले, घमण्डी, बड़कां मारनेबाले, बुरी-बुरी गल्लां बनाने बाले, अम्मा बैपू केरो हुक्म न मन्नेबाले। ");
INSERT INTO bhd_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","बेवकूफ, धोखो देनेबाले, सच़्च़े प्यारे करां खाली, दया न केरनेबाले भोइजेइ। ");
INSERT INTO bhd_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","हालांकी तैना परमेशरेरो ई हुक्म ज़ातन, कि एरां ज़ेरां कम्मां केरनेबाले मौतरे सज़ारे लाइकन, फिरी भी न सिर्फ एप्पू एरां कम्मां केरतन बल्के एरां कम्मां केरनेबालन सेइं भी खुश भोतन। ");
INSERT INTO bhd_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","एल्हेरेलेइ हे दोष लाने बाला, तू कोई की न भोस; तीं कां कोई बहानो नईं, किजोकि ज़ैस गल्लरो तू होरन पुड़ दोष लातस, तैस्से गल्ली पुड़ तू अपनो आप भी दोषी बनातस, एल्हेरेलेइ तू एप्पू भी तैन्ने कम केरतस। ");
INSERT INTO bhd_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ते अस ज़ानतम कि, ज़ैना एरां कम्मां केरतन परमेशर तैन केरो इन्साफे केरतां तैन सज़ा देते। ");
INSERT INTO bhd_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ते हे मैन्हु, तू ज़ै बुरां-बुरां कम्मां केरनेबालन पुड़ दोष लातस, ते एप्पू भी तैन्ने कम केरतस; कुन तू समझ़तस, कि तू परमेशरेरे सज़ाई करां बच़ेलो? ");
INSERT INTO bhd_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","कुन तू परमेशरेरी कृपा, ते बरदाश केरनू, ते सबरारू धन घटया समझ़तस, ते कुन इन न समझ़स, कि परमेशरेरी कृपा तीं पापन करां मन फिरानो शिखालतीए? ");
INSERT INTO bhd_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","पन तू ज़िद्दी आस ते अपने पापन करां मन फिरानेरो इन्कार केरतस, ज़ैस दिहाड़े परमेशर अपनो क्रोध हिरालो, तैस मां परमेशरेरो सच़्च़ो इन्साफ बांदो भोलो, त परमेशर तेरो रोड़ेच़ारे इन्साफ केरेलो। ");
INSERT INTO bhd_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","परमेशर हर एक्की तैसेरे कम्मां केरे मुताबिक बदलो देलो। ");
INSERT INTO bhd_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ज़ैना लोक रोड़ां कम्मां केरतां परमेशरेरी तरफां मैलने बैली महिमा, ते आदर, ते कधे न खतम भोने बाली ज़िन्दगरे तोपी मां रातन, परमेशरे तैन हमेशारी ज़िन्दगी देलो। ");
INSERT INTO bhd_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","पन ज़ैना खुदगरज़न, ते सच़्च़े न मन्नेबालेन, बल्के बुराई केरनि चातन, तैन पुड़ परमेशरेरो क्रोध, ते कोप एज्जेलो। ");
INSERT INTO bhd_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ते मुसीबत ते दुःख हर एक्की मैन्हु पुड़ एज्जेलो ज़ै बुराई केरते। परमेशर पेइलो यहूदी लोकां केरो इन्साफ केरेलो फिरी गैर यहूदी लोकां केरो इन्साफ केरेलो। ");
INSERT INTO bhd_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","हर अक मैन्हु ज़ै रोड़ां कम्मां केरते तैस महिमा, आदर, ते शान्ति मैलेली, पन परमेशर इना सैरी चीज़ां पेइले यहूदी लोकन देलो फिरी गैर यहूदी लोकन। ");
INSERT INTO bhd_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","किजोकि परमेशर केन्चेरी तरफदारी न केरे। ");
INSERT INTO bhd_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","एल्हेरेलेइ कि ज़ैन गैर कौमारे लोकेईं बगैर मूसेरो कानून मेलतां पाप कियो, परमेशर तैन बगैर मूसेरो कानूने सज़ा देलो, ते ज़ैनेईं मूसेरो कानून मेलतां पाप कियो, परमेशर तैन सज़ा भी मूसेरे कानूनेरे मुताबिक देलो। ");
INSERT INTO bhd_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","किजोकि परमेशरेरे नज़री मां मूसेरो कानून शुनेने बाले धर्मी नईं, बल्के मूसेरे कानूने पुड़ च़लने बाले धर्मी ठहराए गानेन। ");
INSERT INTO bhd_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","फिरी ज़ैखन होरि कौमां केरे लोक ज़ैन कां मूसेरो कानून नईं, सुभावे सेइं किछ मूसेरे कानूनेरे गल्लन पुड़ च़लतन, ते मूसेरो कानून तैन कां न भोनेरे बावजूद भी अपने लेइ एप्पू कानून आन। ");
INSERT INTO bhd_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","तैना इन हिरातन कि परमेशरेरो कानून तैन केरे दिलन मां लिखोरोए, ते तैन केरे ज़मीर भी इस गल्ली पुड़ गवाही देतन, किजोकि तैन केरे अपने खियाल भी तैन पुड़ दोष लातन या बेइलज़ाम ठहरातन। ");
INSERT INTO bhd_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","एरू तेइस भोलू ज़ेइस परमेशर ज़ै खुशखबरी मीं शुनावरीए तैसेरे मुताबिक यीशु मसीहेरे ज़िरिये मैन्हु केरि छ़ेपोरी गल्लां केरो इन्साफ केरेलो। ");
INSERT INTO bhd_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","तू एप्पू जो यहूदी ज़ोतस, ते मूसेरे कानूने पुड़ तेरो विश्वासे, ते तू अपने आपे पुड़ घमण्ड केरतथ, कि तू परमेशरेरो खास मैन्हु आस। ");
INSERT INTO bhd_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ते तू परमेशरेरी मर्ज़ी ज़ानतस, ते तू इन भी ज़ानतस कि कोनां गल्लां रोड़ी आन, किजोकि तीं इना गल्लां केरू ज्ञान मूसेरे कानूने करां मैलोरिन। ");
INSERT INTO bhd_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ते तू भरोसो रखतस, कि तू कान्न परमेशरेरी बत हिरानेबालोस, ते ज़ैना आंधरे मां आन तैन केरे लेइ लोअरो ज़ेरे आस। ");
INSERT INTO bhd_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ते बेअक्लन शिखालने बालोस, ते बच्चां केरो उस्तादातस, ते तीं पक्को पतो कि परमेशरेरो कानून तीं पूरू ज्ञान ते सच़्च़ाई शिखालते। ");
INSERT INTO bhd_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ते ज़ैन तू होरन शिखालतस, अपने आपे की न शिखालस? तू होरन शिक्षा देतस कि च़ोरी नईं केरनि, कुन तू च़ोरी केतस? ");
INSERT INTO bhd_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","तू ज़ै ज़ोतस, “बदमाशी नईं केरनि,” कुन तू बदमाशी केरतस? तू ज़ै मूरतन सेइं नफरत केरतस, कुन तू मन्दरन लुटतस? ");
INSERT INTO bhd_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","तू ज़ै घमण्ड केरतस कि तू परमेशरेरे कानूने ज़ानतस, एप्पू किजो कानून न मेन्तां, परमेशरेरी तुहीन केरतस? ");
INSERT INTO bhd_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“किजोकि तुश्शे यहूदी लोकां केरे वजाई सेइं गैर कौमन मां परमेशरेरे नंव्वेरी तुहीन भोतीए,” एल्हेरेलेइ पवित्रशास्त्रे मां एरू लिखोरूए। ");
INSERT INTO bhd_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","अगर तू मूसेरे कानूने पुड़ च़लस, त खतनो कराने सेइं तीं फैइदो त आए, पन अगर तू मूसेरो कानून न मन्नस त तीं मां ते तैस मां, ज़ेसेरो खतनो नईं भोरो कोई फर्क नईं। ");
INSERT INTO bhd_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ते अगर कोई मैन्हु ज़ेसेरो खतनो न भोए भोरो, त तै मूसेरे कानूने पुड़ च़ले, त परमेशरेरे लेइ तै मैन्हु ते ज़ेसेरो खतनो भोरोए दुइये बराबर आन। ");
INSERT INTO bhd_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ते ज़ैस मैनेरो खतनो नईं भोरो, अगर तै मूसेरे कानूने पूरू केरे, त तै तीं दोषी ठहरालो। किजोकि तीं कां मूसेरो कानूने ते तेरो खतनो भी भोरोए, पन फिरी भी तू कानूने पुड़ न च़लस। ");
INSERT INTO bhd_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","किजोकि सच़्च़ो यहूदी तै नईं ज़ेसेरू ज़र्म यहूदन मां भोरू या ज़ेसेरो खतनो भोरोए। ");
INSERT INTO bhd_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","बलके सच़्च़ो यहूदी तैए, ज़ेसेरो मन परमेशरे कां सच़्च़ोए, ते सच़्च़ो खतनो तैए ज़ै पवित्र आत्मारे कम्मां केरे ज़िरिये दिलेरो भोरोए, न की मूसेरो कानून मन्ने सेइं भोरोए। एरे लोकां केरि बड़याई लोक नईं बल्के परमेशर एप्पू केरते। ");
INSERT INTO bhd_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","(किछ लोक पुछ़तन) यहूदी केरि कुन बड़याई, या खतनेरो कुन फैइदो? ");
INSERT INTO bhd_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","हर किसमे सेइं बड़ू किछ। पेइलू त इन कि सारू परमेशरेरू वचन तैन सोंफू। ");
INSERT INTO bhd_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","अगर किछ यहूदी परमेशरे कां ईमानदार न निस्से त कुन भोवं? कुन तैन केरे ईमानदार न राने सेइं परमेशर तैन केरे लेइ अपने वादे पूरे केरने मां झूठो भोव? ");
INSERT INTO bhd_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","नईं, कधे नईं! बल्के परमेशर हमेशा सच़ ज़ोते, ते हर अक मैन्हु झूठो भोव, ज़ेन्च़रे पवित्रशास्त्रे मां परमेशरेरे बारे मां लिखोरूए, “ज़ैस सेइं तू एपनी गल्लन मां धर्मी भोस, ते इन्साफेरे वक्ते तीं ज़ींत मैल्ले।” ");
INSERT INTO bhd_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","अगर इश्शां बुरां कम्मां परमेशरेरी धार्मिकता ठहराते, त अस कुन ज़ोम? कुन इन कि परमेशर क्रोध केरते ते असन सज़ा देते। (इन अवं इन्सानेरी रीति पुड़ ज़ोताईं)। ");
INSERT INTO bhd_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","नईं, कधे नईं! अगर परमेशर इश्शो यहूदी केरो इन्साफ रोड़े च़ारे न केरेलो, त तै किजो दुनियारो इन्साफ केरेलो? ");
INSERT INTO bhd_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","किछ ज़ोतन, अगर मेरे झूठेरे वजाई सेइं परमेशरेरी सच़्च़ाई बांदी भोतीए ते तैसेरी महिमा भोतीए, त फिरी किजो पैपी केरो ज़ेरो मीं पुड़ हुक्म दित्तो गाते? ");
INSERT INTO bhd_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","“एज्जा, अस बुराई केरम, कि इस सेइं भलाई पैदा भोए?” पन असन पुड़ दोष भी लव गाते, ते केत्रे ज़ोतन, कि एन केरू भी एने ज़ोनू आए। पन एरे ज़ेरेन पुड़ दोष लानो ठीक आए। ");
INSERT INTO bhd_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","त फिरी अस कुन ज़ोम? कुन अस यहूदी होरन करां रोड़ेम? नईं, कधी नईं; किजोकि असेईं यहूदी लोकन पुड़ ते गैर यहूदी लोकन पुड़ ई दोष लोरोए, कि तैना सारे पापेरे कब्ज़े मां आन। ");
INSERT INTO bhd_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ज़ेन्च़रे पवित्रशास्त्रे मां लिखोरूए, “कोई परमेशरेरे सामने धर्मी नईं, अक भी नईं। ");
INSERT INTO bhd_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","कोई सच़्च़े समझ़दार नईं, कोई परमेशरे तोपने बालो नईं। ");
INSERT INTO bhd_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","सारे परमेशरे करां दूर भोरेन, सारे निकम्मे बनोरेन, कोई भलाई केरनेबालो नईं, अक भी नईं। ");
INSERT INTO bhd_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","तैन केरू गल खुल्ली कब्रे, तैनेईं अपने ऐशी सेइं धोखो दित्तो, तैन केरे ओठन पुड़ सप्पां केरू ज़ेरे। ");
INSERT INTO bhd_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ते तैन केरू भाषण लानती, ते ट्लिठे सेइं भेरतांए। ");
INSERT INTO bhd_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","तैन केरे पव खून केरने लेइ तेज़न। ");
INSERT INTO bhd_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","तैना ज़ेरां भी गातन तुबाही ते कलेश तैन पत्ती गाते। ");
INSERT INTO bhd_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","तैन न ज़ानन् शैन्ति सेइं केन्च़रां ज़ीतन। ");
INSERT INTO bhd_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","तैन मां परमेशरेरो डर बिलकुल भी नईं।” ");
INSERT INTO bhd_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","अस ज़ानतम, कि मूसेरो कानून ज़ैन किछ ज़ोते, तैन्ने सेइं ज़ोते, ज़ैना तैस मन्तन, एल्हेरेलेइ कि केन्ची कां कोई बहानो न भोए, ते सारी दुनिया परमेशरेरे सज़ारे लायिक भोए। ");
INSERT INTO bhd_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","किजोकि मूसेरे कानूनेरे मुताबिक कम्मां केरने सेइं कोई मैन्हु परमेशरेरे सामने धर्मी नईं भोनो, एल्हेरेलेइ कि मूसेरे कानूने सेइं पिशान भोतीए कि अस पापी आम। ");
INSERT INTO bhd_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","पन हुनी बगैर मूसेरो कानून मन्ने सेइं तै धार्मिकता बांदी भोरीए ज़ै परमेशरेरे तरफां एइतीए, ज़ेसेरे बारे मां मूसेरे कानूने ते नेबी केरि किबातन मां लिखोरूए। ");
INSERT INTO bhd_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","मतलब परमेशरेरी तै धार्मिकता ज़ै यीशु मसीह पुड़ विश्वास केरनेबालां केरे लेइए; किजोकि तैन मां किछ भेद भाव नईं। ");
INSERT INTO bhd_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","एल्हेरेलेइ कि सेब्भेईं पाप कियो, ते तैस महिमा करां दूर आन ज़ै परमेशर देते। ");
INSERT INTO bhd_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","पन परमेशरे अपने अनुग्रहे सेइं अस पापां केरि सज़ाई करां यीशु मसीहेरे ज़िरिये छुटाए ते मुफ्ते मां धर्मी ठहराए। ");
INSERT INTO bhd_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","परमेशरे मसीहेरे खूनेरे वजाई सेइं अक एरो छुटकारो ठहराव, ज़ै विश्वास केरने सेइं फैइदामंद भोते, कि ज़ैना पाप पेइले केरे, ते ज़ैना परमेशरे अपने बर्दाशती सेइं टाले; तैन केरे बारे मां तै अपनि धार्मिकता बांदी केरते। ");
INSERT INTO bhd_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","बल्के इस्से वक्ते तैसेरी धार्मिकता बांदी भोए; कि ज़ैस सेइं तै एप्पू धर्मी ठहरे, ते ज़ै यीशु पुड़ विश्वास केरे, तैसेरो धर्मी ठहराने बालो भोए। ");
INSERT INTO bhd_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ते घमण्ड केरनू कोड़ि राव? तैसेरी त ठारे नईं। कोस कानूनेरे वजाई सेइं? कुन मूसेरो कानून मन्ने सेइं? नईं, बल्के विश्वासेरे वजाई सेइं। ");
INSERT INTO bhd_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","एल्हेरेलेइ अस ज़ानतम, कि मैन्हु मूसेरो कानूनेरे मुताबिक कम्मां केरनेरे बगैर यीशु मसीह पुड़ विश्वास केरने सेइं धर्मी भोते। ");
INSERT INTO bhd_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","कुन परमेशर सिर्फ यहूदी केरोए? कुन गैर कौमां केरो नईं? हाँ गैर कौमां केरो भी आए। ");
INSERT INTO bhd_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","किजोकि अक्के परमेशरे, ज़ै खतने बालन भी विश्वासे सेइं, ते ज़ैन केरो खतनो नईं भोरो तैन भी विश्वासे सेइं धर्मी ठहरालो। ");
INSERT INTO bhd_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ते कुन अस विश्वासे सेइं मूसेरे कानूने रद केरतम? नईं, कधे नईं; बल्के मूसेरे कानूने बनोरू रखतम। ");
INSERT INTO bhd_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","त अस कुन ज़ोम, कि इश्शे पूर्वज अब्राहमे कुन मैल्लू? ");
INSERT INTO bhd_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","किजोकि अगर अब्राहम रोड़े कम्मन सेइं धर्मी ठहरावरो भोथो, त तैस घमण्ड केरनेरी ठार भोथी, पन रोड़ां कम्मां केरू घमण्ड परमेशरेरे सामने नईं। ");
INSERT INTO bhd_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","पवित्रशास्त्र कुन ज़ोते, इन कि “अब्राहमे परमेशरेरे वादन पुड़ विश्वास कियो, ते तै तैसेरेलेइ धार्मिकता गनो जेव।” ");
INSERT INTO bhd_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","कम केरनेबालेरी मज़दूरी देनी दान नईं, पन हक समझ़ू गाते। ");
INSERT INTO bhd_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","पन ज़ै (पुन्नेरू) कम न केरे बल्के पापी मैन्हु धर्मी ठहराने बाले पुड़ विश्वास केरते, तैसेरो विश्वास तैसेरेलेइ धार्मिकता गनो गाते। ");
INSERT INTO bhd_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ज़ैस परमेशर बगैर (पुन्नेरे) कम्मां केरे धर्मी ठहराते, तैस दाऊद भी धन ज़ोते। ");
INSERT INTO bhd_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“धने तै ज़ेसेरे अधर्म माफ़ भोए, ते ज़ैन केरे पाप ढके जे। ");
INSERT INTO bhd_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","धने तै मैन्हु ज़ैस परमेशर पापी न ठहराए।” ");
INSERT INTO bhd_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ते इन धन ज़ोनू, कुन खतने बालां केरे लेइ आए, या ज़ैन केरो खतनो नईं भोरो तैन केरे लेइ भी आए? अस पवित्रशास्त्रे मरां ज़ोतम, “अब्राहमे परमेशरेरे वादन पुड़ विश्वास कियो ते तै तैसेरेलेइ धार्मिकता गनो जेव।” ");
INSERT INTO bhd_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","इन तैसेरो खतनो भोने करां पेइलू भोव न कि खतनो भोनेरे बाद। ");
INSERT INTO bhd_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","परमेशरे तै पेइलो कबूल कियो ते धर्मी ठहराव, ज़ेइस हेजू तैसेरो खतनो न थियो भोरो, ते तैस खतनेरो निशान मैलो, कि तैस धार्मिकता पुड़ छाप भोए, किजोकि तै तैन सेब्भी केरो (आत्मिक) बाजी ठहरे ज़ैना विश्वास त केरतन पन तैन केरो खतनो नईं भोरो। तैना भी तैन केरे विश्वासेरे वजाई सेइं धर्मी भोन। ");
INSERT INTO bhd_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ते ज़ैन केरो खतनो भोरोए तैन केरो पूर्वज भोए, ज़ैन केरो न सिर्फ खतनो कियोरोए, पन ज़ैन इश्शे पूर्वज अब्राहमेरो ज़ेरो विश्वास आए, ज़ै तैनी बगैर खतनेरी हालती मां कियोरी थियो। ");
INSERT INTO bhd_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","परमेशरे अब्राहमे ते तैसेरे वंश सेइं वादो कियोरो थियो कि तैना दुनियारे बारस भोले। ई वादे एल्हेरेलेइ नईं दित्तोरो कि अब्राहमे मूसेरो कानून मन्नो, बल्के तैसेरो विश्वास ज़ै परमेशरे पुड़ थियो तैसेरे वजाई सेइं तै धर्मी ठहराव जेव। ");
INSERT INTO bhd_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ज़ै वादो परमेशरे दित्तोरो थियो कि तैना दुनियारे बारस भोले अगर मूसेरो कानून मन्ने सेइं आए, त फिरी विश्वास बेमतलब, ते वादो बेकार भोव। ");
INSERT INTO bhd_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","परमेशर तैस पुड़ क्रोध केरते ज़ै कानूने रोड़े च़ारे न मन्ने, ते ज़ैड़ी कानून नईं, तैड़ी तैसेरू ट्लोड़नू भी नईं। ");
INSERT INTO bhd_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","एल्हेरेलेइ परमेशरेरे वादे विश्वासेरे ज़िरिये हासिल भोतन, ताके तैना वादे अनुग्रहेरे ज़िरिये पक्के भोन, ते सारे वादे अब्राहमेरे वंशेरे लेइ आन, न सिर्फ यहूदी केरे लेइ, ज़ैना मूसेरू कानून मन्तन बल्के तैन सेब्भी केरे लेइ भी आन, ज़ैना अब्राहमेरो ज़ेरो विश्वास केरनेबालन, तैए इश्शो सेब्भी केरो पूर्वजे। ");
INSERT INTO bhd_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ज़ेन्च़रे पवित्रशास्त्रे मां लिखोरूए, “मीं तू बेड़ि कौमां केरो पूर्वज बनेवरोस” परमेशरे पुड़ तैने विश्वास कियो, ते ज़ै मुड़दन ज़ींतो केरते ते ज़ैना चीज़ां वाजूद नईं, तैन भी हाज़र केरते। ");
INSERT INTO bhd_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","परमेशरेरे वचनेरे मुताबिक कि “तेरू खानदान एरू भोलू” तैना बेड़ि कौमां केरे पूर्वज भोन। तैनी न उमीदी मां भी उमीदी रेखतां विश्वास कियो, ");
INSERT INTO bhd_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ते अब्राहम ज़ै लगभग 100 सालेरो थियो, अपने मर्रे जानी, ते सारारे मर्रे पेटेरे हालीती पुड़ भी विश्वासे मां कमज़ोर न भोव। ");
INSERT INTO bhd_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ते गैर विश्वासी भोइतां परमेशरेरे वादे पुड़ शक न की, पन विश्वासे मां मज़बूत भोइतां परमेशरेरी बड़याई की। ");
INSERT INTO bhd_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ते तैस पूरो भरोसो भोव, कि ज़ैस गल्लरो वादो परमेशरे कियोरोए, तै तैस पूरो केरनेरी शक्ति भी रखते। ");
INSERT INTO bhd_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","अब्राहमेरो विश्वास तैसेरेलेइ धार्मिकता गनो जेव। ");
INSERT INTO bhd_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ते ई वचन, “विश्वास तैसेरेलेइ धार्मिकता गनो जेव,” न सिर्फ तैसेरेलेइ लिखो जेव। ");
INSERT INTO bhd_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","बल्के इश्शे लेइ भी ज़ैन केरे लेइ विश्वास धार्मिकता गनो जेव, मतलब इश्शे लेइ ज़ैना अस परमेशरे पुड़ विश्वास केरतम, ज़ैने इश्शो प्रभु यीशु मसीह मुड़दन मरां ज़ींतो कियो। ");
INSERT INTO bhd_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","यीशु इश्शे पापां केरे लेइ मारनेरे लेइ ट्लुवाव जेव, ते असन धर्मी ठहरानेरे लेइ परमेशरे ज़ींतो भी कियो। ");
INSERT INTO bhd_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","एल्हेरेलेइ असां विश्वासे सेइं धर्मी भोए, ते ज़ैन किछ इश्शे प्रभु यीशु मसीहे इश्शे लेइ कियोरू तैसेरे ज़िरिये इश्शो मेल मलाप परमेशरे सेइं भोरोए। ");
INSERT INTO bhd_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ते इश्शे विश्वासेरे वजाई सेइं मसीहे अस इस अनुग्रहे तगर पुज़ाए, ज़ैड़ी अज़ अस खड़े भी आम, ते असां पूरे याकीने ते आनन्दे सेइं परमेशरेरी महिमा बंटनेरे लेइ उमीदी मां रातम। ");
INSERT INTO bhd_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","सिर्फ एन्ने नईं, बल्के मुसीबतन मां भी अस आनन्द केरम, किजोकि अस ज़ानतम कि मुसीबतन सेइं सबर बद्धती। ");
INSERT INTO bhd_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","परमेशर असन रोड़े समझ़ते किजोकि केन्च़रे सबर केरनि असेईं शिखोरीए, ते तै असन रोड़े समझ़ते तांए असन उमीदे। ");
INSERT INTO bhd_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ई उमीदी असन शरमिन्दा न केरे, किजोकि पवित्र आत्मा ज़ै परमेशरे असन दित्तोरोए तैसेरे ज़िरिये सेइं तैसेरो प्यार इश्शे दिलन मां भरोरोए। ");
INSERT INTO bhd_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","किजोकि ज़ैखन अस अपनो आप बच़ानेरे लेइ कमज़ोर थिये, त मसीह परमेशरेरे ठहरावरे वक्ते पुड़ इश्शे पैपी केरे लेइ मरो। ");
INSERT INTO bhd_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","केन्ची धर्मी मैनेरे लेइ भी कोई मरे, इन बड़ू मुशकले, पन शैइद केन्ची धर्मी मैनेरे लेइ कोई अपनि जान देनेरी जुरत केरे। ");
INSERT INTO bhd_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","पन परमेशरे अपनो महान प्यार एन्च़रे बांदो कियो, कि ज़ैखन असां पापी थिये तैखन मसीह इश्शे लेइ मरो। ");
INSERT INTO bhd_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ते अस तैसेरे खूने सेइं धर्मी ठहरे, त मसीहेरे ज़िरिये सेइं परमेशरेरे हमेशारी सज़ाई करां ज़रूर बच़मेले ");
INSERT INTO bhd_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","किजोकि ज़ैखन अस परमेशरेरे दुश्मन थिये त तैसेरे मट्ठरे मौती सेइं इश्शो मेल तैस सेइं भोव, ते फिरी मेल मलाप भोरोए त तैसेरे ज़िन्दगी सेइं असन पक्की मुक्ति मैलेली। ");
INSERT INTO bhd_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ते सिर्फ इन्ने नईं, पन हुनी प्रभु यीशु मसीहेरे ज़िरिये सेइं इश्शो मेल परमेशरे सेइं भोरोए, एल्हेरेलेइ अस परमेशरे मां आनन्द केरतम। ");
INSERT INTO bhd_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","एल्हेरेलेइ ज़ेन्च़रे एक्की मैनेरे ज़िरिये यानी आदमेरे ज़िरिये पाप दुनियाई मां अव, ते पापे सेइं मौत आई, ते एन्च़रे मौत सेब्भी मैनन् मां फैली। किजोकि सेब्भेईं पाप केरो। ");
INSERT INTO bhd_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","मूसेरो कानून देने करां पेइले पाप दुनियाई मां त थियो, पन ज़ैड़ी कानून नईं, तैड़ी पाप गनो न गाए। ");
INSERT INTO bhd_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","फिरी भी आदमे करां मूसा तगर सेब्भी लोकेईं पाप कियो ते सब लोक मरे, ज़ैन लोकेईं तैस आदमेरो ज़ेरो पाप न कियो तैना भी मरे, आदम मसीहेरो ज़ेरो थियो, ज़ै मसीह एजनेबालो थियो। ");
INSERT INTO bhd_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","पन परमेशरेरू वरदान आदमेरे पापेरू ज़ेरू नईं, इन सच़्च़े कि एक्की मैन्हु यानी आदमेरे पापेरे वजाई सेइं बड़े लोक मरे। पन परमेशरेरे अनुग्रह त कने तैसेरू वरदान बड़े लोकां केरे लेइ महान आए ज़ैन एक्की मैन्हु यानी यीशु मसीहेरे अनुग्रहे सेइं एइते। ");
INSERT INTO bhd_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ज़ैन वरदान परमेशरे असन दित्तू तैन आदमेरे पापेरू ज़ेरू नईं, किजोकि एक्की मैनेरो पाप सज़ा घिन्तां अव। पन हालांकी असेईं भी बड़े पाप कियोरेन फिरी भी परमेशरे असन एरू वरदान दित्तोरूए ज़ैन असन परमेशरेरी नज़री मां धर्मी ठहराते। ");
INSERT INTO bhd_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","किजोकि एक्की मैनेरे पापेरे वजाई सेइं सब लोक मरे, त ज़ैन लोकन अनुग्रहेरू ते धार्मिकतारू बड़ू वरदान एक्की मैनेरे ज़िरिये मैलते, तैना लोक ज़ीते राले ते एक्की मैन्हु यानी यीशु मसीहेरे ज़िरिये राज़ केरेले। ");
INSERT INTO bhd_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","एल्हेरेलेइ ज़ेन्च़रे एक्की मैनेरो पाप सेब्भी मैनेरू केरे लेइ सज़ा आनते, तेन्च़रे मसीहेरे धार्मिकतारू कम सेब्भी मैनेरू केरे लेइ धर्मी ठहराने लेइ वजा बनू, ज़ैस सेइं ज़िन्दगी मैलतीए। ");
INSERT INTO bhd_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","किजोकि ज़ेन्च़रे एक्की मैनेरे हुक्म न मन्ने सेइं बड़े लोक पापी भोए, तेन्च़रे एक्की मैनेरे हुक्म मन्ने सेइं बड़े लोक धर्मी भोले। ");
INSERT INTO bhd_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","मूसेरो कानून एल्हेरेलेइ दित्तोरो थियो कि सारे लोकन पतो लग्गे कि तैना केत्रे पापिन। पन ज़ेन्च़रे लोकेईं ज़ेत्रे जादे पाप किये तेन्च़रे परमेशरेरो अनुग्रह तैस करां भी बड़ो जादे भोवं, ");
INSERT INTO bhd_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","कि ज़ेन्च़रे सेब्भी लोकेईं पाप किये ते मरे, तेन्च़रे परमेशरेरो अनुग्रह राज़ केरते ते परमेशरे अस इश्शे प्रभु यीशु मसीहेरे वजाई सेइं धर्मी ठहरावरेम। मतलब असन हमेशारी ज़िन्दगी मैलेली। ");
INSERT INTO bhd_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","त अस कुन ज़ोम? कुन अस पाप केरते रहम, कि परमेशरेरो अनुग्रह बद्धतो गाए? ");
INSERT INTO bhd_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","नईं, कधी नईं! अस ज़ैखन पापेरे लेइ मरे ते फिरी किजो अग्रोवं जो पापे मां ज़िन्दगी बीताम? ");
INSERT INTO bhd_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","तुस ज़ानतम कि ज़ैखन असेईं सेब्भी लोकेईं यीशु मसीहे सेइं साथी अक भोनेरे लेइ बपतिस्मो नीयोरो थियो, तैखन अस तैस सेइं साथी मर्रे थिये। ");
INSERT INTO bhd_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ज़ैखन असेईं बपतिस्मो नीयोरो थियो तैखन अस मसीह सेइं साथी मरे ते दबे जे, ताके अस भी नव्वीं ज़िन्दगी ज़ींम, ज़ेन्च़रे मसीह बाजी परमेशरेरी महिमा सेइं मुड़दन मरां ज़ींतो कियो। ");
INSERT INTO bhd_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","किजोकि अगर अस बपतिस्मेरे ज़िरिये मसीहेरी मौती मां शामिल भोरेम, त अस भी पक्के तैसेरे ज़ेरे ज़ींते भोमेले। ");
INSERT INTO bhd_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","अस ज़ानतम कि इश्शी पुरानी इन्सानयत यीशु मसीह सेइं साथी क्रूसे पुड़ च़ाढ़ोरीए, ताके पापेरो जिसम बेफाइदो भोए, ते अस अग्रोवं जो पापेरे गुलैमी मां न रहम। ");
INSERT INTO bhd_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ज़ैखन मैन्हु मरते त तैखन तै पापेरी शेक्ति करां आज़ाद भोते। ");
INSERT INTO bhd_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","एल्हेरेलेइ अगर अस मसीह सेइं साथी मरे, ते इश्शो विश्वास ईए कि तैस सेइं साथी ज़ींते भी भोमेले। ");
INSERT INTO bhd_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","किजोकि अस एन ज़ानतम, कि मसीह मुड़दन मरां ज़ींतो भोरोए ते तै फिरी न मरेलो, ते तैस पुड़ फिरी मौतरू राज़ नईं भोनू। ");
INSERT INTO bhd_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ज़ैखन मसीह मरो त तै एक्की बार सेब्भी केरे पापेरे लेइ मरो; पन हुनी तै ज़ींतोए, ते सिर्फ परमेशरेरे लेइ ज़ींतोए। ");
INSERT INTO bhd_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","एन्च़रे तुस अपने बारे मां भी सोचा कि तुस पापेरे लेइ त मरोरेथ, पन यीशु मसीहे तुसन ज़िन्दगी दित्तोरीए ते तुस परमेशरेरे लेइ ज़ींते आथ। ");
INSERT INTO bhd_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","एल्हेरेलेइ तुस अपने जानी मां पापेरी इच्छान राज़ केरने न देथ, ते तुस तैन केरे मुताबिक न च़ला। ");
INSERT INTO bhd_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ते अपने जिसमेरे अंगन बुरे कम्मां केरे लेइ पापे न सोंफा, पन अपने आपे मुड़दन मरां ज़ींते सेमझ़तां परमेशरे सोंफा। ते अपने जिसमेरे अंगन धार्मिकतारे कम्मां केरे लेइ परमेशरे सोंफा। ");
INSERT INTO bhd_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ते तुसन पुड़ पापेरू राज़ न भोलू, किजोकि तुस मूसेरे कानूनेरे अधीन नईं बल्के अनुग्रहेरे अधीन आथ। ");
INSERT INTO bhd_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","त कुन भोव कि अस एल्हेरेलेइ पाप केरम, कि असां मूसेरे कानूनेरे अधीन नईं बल्के अनुग्रहेरे? नईं, कधे नईं। ");
INSERT INTO bhd_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","तुस ज़ानथ, कि ज़ैखन तुस ज़ेसेरो हुक्म मन्नेरे लेइ अपनो आप गुलामां केरे ज़ेरे सोफतथ त तुस तैसेरे गुलाम आथ। चाए पापेरी ज़ेसेरो अन्त मौते, चाए हुक्म मन्नेरे ज़ेसेरो अन्त धार्मिकताए। ");
INSERT INTO bhd_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","तुस त पेइले पापेरे गुलाम थिये पन हुनी तुसन ज़ै शिक्षा मैलोरी थी तैस पूरे दिले सेइं मन्नेबाले भोए, एल्हेरेलेइ अवं परमेशरेरू शुक्र केरताईं। ");
INSERT INTO bhd_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ते हुनी परमेशरे तुस पापेरी शेक्ति करां छुटेइतां आज़ाद किये, ते तुस परमेशरेरे गुलाम बने ताके तुस ज़ैन रोड़ू तैन केरि बटथ। ");
INSERT INTO bhd_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","अवं ई मिसाल एल्हेरेलेइ इस्तेमाल केरने लोरोईं, किजोकि तुश्शे लेइ इन समझ़नू मुश्किले। ज़ेन्च़रे तुसेईं पेइले अपनो आप गुलामेरे ज़ेरो बुरां कम्मां केरे लेइ अधर्मे ते बुरैइारे लेइ सोंफोरे थियो, तेन्च़रे हुनी तुस अपने आपे परमेशरेरी सेवारे लेइ सोंफा ताके तुस पूरे तरीके सेइं तैसेरे भोथ। ");
INSERT INTO bhd_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ज़ेइस तुस पापेरे गुलाम थिये, त तुसन परमेशर खुश केरनेरी कोई ज़रूरत न थी। ");
INSERT INTO bhd_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","तुसन पुरैनी ज़िन्दगी सेइं कुन फैइदो मैलो? सिर्फ तुस शरमातथ, किजोकि ज़ैन तुसेईं कियूं तैसेरो नितीजो सिर्फ मौते। ");
INSERT INTO bhd_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","पन हुनी तुस पापे करां आज़ाद भोरेथ ते तुस परमेशरेरे दास बनोरेथ। किजोकि इना गल्लां तुसन पवित्र बनैली ते तुसन हमेशारी ज़िन्दगी मैलेली। ");
INSERT INTO bhd_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","किजोकि पापेरी मज़दूरी त मौते, पन परमेशरेरू वरदान इश्शे प्रभु यीशु मसीह मां हमेशारी ज़िन्दगी आए। ");
INSERT INTO bhd_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","हे ढ्लाव ते बेइनव, कुन तुस न ज़ानथ अवं मूसेरो कानून ज़ान्ने बालन सेइं ज़ोताईं, कि ज़ांतगर मैन्हु ज़ींतो रहते, तांतगर तैस पुड़ मूसेरे कानूनेरो अधिकार भोते? ");
INSERT INTO bhd_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","मिसालरे तोरे पुड़, ड्लावरी कुआन्श कानूनेरे मुताबिक ज़ांतगर तैसेरो मुन्श ज़ींतोए तांतगर तैसेरी पाबंदे। पन अगर मुन्श मेरि गाए, त तै मुन्शेरे कानूने करां छुटी जेई। ");
INSERT INTO bhd_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ते अगर मुन्श हेजू ज़ींतो ते होरि मड़देरी भोए त तै बदमाश भोतीए, पन मुन्श मेरि गाए, त तैसेरे कानूने करां छुटी, इड़ी तगर कि होरि मड़देरी भोए, फिरी भी बदमाश न ठहरेली। ");
INSERT INTO bhd_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","हे ढ्लाव ते बेइनव, ज़ैखन तुस मसीह सेइं साथी मरे, त तुस कानूनेरे लेइ मर्रे। हुनी तुस मसीहेरे आथ ज़ै मुड़दन मरां ज़ींतो कियोरोए, ताके तुस परमेशरेरे लेइ फलदार ज़िन्दगी ज़ीथ। ");
INSERT INTO bhd_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","किजोकि ज़ेइस अस अपने सुभावेरे मुताबिक च़लते थिये, त पापी सुभाव असन मां कम केरतो थियो, ते कानूने तैना पापी इच्छां उकसेइं, ते ज़ैन किछ असेईं कियूं तैसेरो फल मौत थियो। ");
INSERT INTO bhd_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","पन ज़ेसेरे बंधने मां अस थिये, तैसेरेलेइ मेरतां, हुनी कानूने करां एरे छुटोरेम, पन आत्मारे नव्वें तरीके पुड़ सेवा केरतम, न कि लफसन सेइं। ");
INSERT INTO bhd_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","त अस कुन ज़ोम? कुन मूसेरो कानून पापे? नईं, कधी नईं! बल्के बगैर मूसेरे कानूने अवं पापे न पिशैनी, अगर मूसेरो कानून न ज़ोथो कि “लालच़ न केर” त अवं लालच़े न ज़ैनेथो। ");
INSERT INTO bhd_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","पन पापे मौको लेइतां हुक्मे सेइं मीं मां हर किसमेरू लालच़ पैदा कियूं, किजोकि बगैर मूसेरे कानूने पाप मर्रो आए। ");
INSERT INTO bhd_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","अवं त मूसेरे कानूने बगैर पेइलो ज़ींतो थियो, पन ज़ैखन हुक्म अव, त पाप ज़ींतो भोव ते अवं मरो। ");
INSERT INTO bhd_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ते तैए हुक्म ज़ै ज़िन्दगरे लेइ थियो, मेरे लेइ मौतरी वजा बनो। ");
INSERT INTO bhd_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","किजोकि पापे मौको मेलतां हुक्मे सेइं मीं धोखो दित्तो, ते तैस सेइं अवं आत्मिक तोरे पुड़ मरो। ");
INSERT INTO bhd_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","एल्हेरेलेइ मूसेरो कानून पवित्र आए, ते हुक्म भी पवित्र, ठीक ते रोड़ोए। ");
INSERT INTO bhd_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ते कुन ज़ै चीज़ रोड़ी थी मेरे लेइ मौत बनी? नईं, कधे नईं! पन पापे तैस रोड़ी चीज़ी सेइं मेरे लेइ मौत पैदा केरतां अवं मारो, कि तैसेरो पाप भोनो बांदो भोए, ते हुक्मे सेइं पाप बड़ो जादे बुझ़ोए। ");
INSERT INTO bhd_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","किजोकि अस ज़ानतम कि मूसेरो कानून त आत्मिके, पन अवं जिसमानी ते पापेरो गुलाम भोनेरे लेइ बिकोरोईं। ");
INSERT INTO bhd_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ते ज़ैन अवं केरताईं, तैस न ज़ैनी, किजोकि ज़ैन अवं चाताईं, तैन न केरि, पन ज़ैस सेइं मीं नफरते, तैन्ने केरताईं। ");
INSERT INTO bhd_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ते अगर, ज़ैन अवं न चैई तैने केरताईं, त अवं मनताईं, कि मूसेरो कानून रोड़ो आए। ");
INSERT INTO bhd_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ते एस हालती मां बुरी चीज़ां केरनेबालो अवं नईं, बल्के पापे, ज़ै मीं मांए। ");
INSERT INTO bhd_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","किजोकि अवं ज़ानताईं, कि मीं मां मतलब मेरे जिसमे मां कोई रोड़ी चीज़ नईं, रोड़ू केरनेरी इच्छा त मीं मां आए, पन मीं करां न केरोए। ");
INSERT INTO bhd_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","किजोकि ज़ैस रोड़े कम्मेरी इच्छा अवं केरताईं, तैन मीं करां न बने, पन ज़ैस बुरैइयरी इच्छा भी न केरि तैस केरताईं। ");
INSERT INTO bhd_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","पन अगर अवं तैन्ने केरताईं, ज़ेसेरी इच्छा न केरि, ते तैन केरनेबालो अवं नईं, बल्के पापे ज़ै मीं मांए। ");
INSERT INTO bhd_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ते मीं ई कानून मैलते, कि ज़ैखन रोड़े कम्मेरी इच्छा केरताईं, त अवं बुराई केरताईं। ");
INSERT INTO bhd_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","किजोकि अवं ज़मीरे सेइं त परमेशरेरे कानूने सेइं बड़ो खुश भोताईं। ");
INSERT INTO bhd_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","पन मीं अपने जिसमेरे अंगन मां होरि ज़ेरो कानून लेइहोते, ज़ै मेरी अक्लरे कानूने सेइं लड़ते, ते मीं पापेरे गुलैमरे कानूने मां छ़डते ज़ै मेरे जिसमेरे अंगन मांए। ");
INSERT INTO bhd_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","अवं केरो नुभाघ मैन्हु आईं, मीं इस जिसमे करां ज़ै मौतरे पासे नेते कौन छुटालो? ");
INSERT INTO bhd_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","अवं परमेशरेरू शुक्र केरताईं ज़ैने यीशु मसीहेरे ज़िरिये अवं बच़ाव, ते अवं अपनि अक्ली सेइं त परमेशरेरे कानूनेरो इस्तेमाल केरताईं, पन अपने जिसमे सेइं पापेरी कानूनेरो इस्तेमाल केरताईं। ");
INSERT INTO bhd_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","एल्हेरेलेइ हुनी ज़ैना मसीह यीशु मां आन, तैन पुड़ सज़ारो हुक्म नईं। ");
INSERT INTO bhd_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","किजोकि पवित्र आत्मा तुसन ज़िन्दगी देलो, ज़ै यीशु मसीह करां एइती ते तै तुसन पाप ते मौती करां आज़ाद केरेलो। ");
INSERT INTO bhd_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","किजोकि ज़ैन कम कानूने इश्शे पापी सुभावेरे वजाई सेइं कमज़ोर भोइतां न केरि बटु, तैन परमेशरे कियूं, मतलब अपने मट्ठे इश्शे पैपी केरो ज़ेरो भोनेरे लेइ, ते पापेरे बलिदानेरे लेइ भेज़ू, परमेशरे मसीहेरे जिसमे मां पापेरी सज़ा दित्ती। ");
INSERT INTO bhd_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","परमेशरे एन एल्हेरेलेइ कियूं ताके अस अपने पापी सुभावेरे मुताबिक नईं, पन पवित्र आत्मारे मुताबिक च़ेलतां ज़ै हुक्म कानून देते तैस केरि बटम। ");
INSERT INTO bhd_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","किजोकि ज़ैना लोक पापी सुभावेरे मुताबिक ज़िन्दगी बीतातन, तैना पापेरे बारे मां सोचतन, पन ज़ैना लोक पवित्र आत्मारे मुताबिक ज़िन्दगी बीतातन, तैना आत्मिक गल्लां केरे बारे मां सोचतन। ");
INSERT INTO bhd_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","अगर इश्शो मन इश्शे पापी सुभावेरे मुताबिक च़लते त अस मरमेले, पन अगर इश्शो मन आत्मारे मुताबिक च़लते त असन कां ज़िन्दगी ते शान्ति मैलेली। ");
INSERT INTO bhd_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","किजोकि पापी सुभावेरे मुताबिक च़लनू परमेशरे सेइं बैर रखनोए, किजोकि न त पापी सुभाव परमेशरेरे कानूनेरे अधीने, ते न कानूनेरे मुताबिक च़ेलि बटते। ");
INSERT INTO bhd_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ते ज़ैना पापी सुभावेरे मुताबिक च़लतन तैना परमेशरे खुश न केरि बटन। ");
INSERT INTO bhd_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","पन ज़ैखन परमेशरेरो आत्मा तुसन मां बस्सते, ते तुस पापी सुभावेरे मुताबिक न च़लथ बल्के पवित्र आत्मारे मुताबिक च़लतथ, अगर कोन्ची मां पवित्र आत्मा नईं त तै मसीहेरो मैन्हु नईं। ");
INSERT INTO bhd_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ते अगर मसीह तुसन मांए, त जिसम पापेरे वजाई सेइं मरेलो, पन आत्मा धार्मिकतारे वजाई सेइं ज़ींतीए। ");
INSERT INTO bhd_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ते अगर तैसेरी आत्मा ज़ैने यीशु मुड़दन मरां ज़ींतो कियो तुसन मांए। ते ज़ै मसीह तैने मुड़दन मरां ज़ींतो कियो, तैए तुश्शे भी नाश भोनेबाले जिसमे अपनि आत्मा सेइं ज़ींतो केरेलो, ज़ै तुसन मांए। ");
INSERT INTO bhd_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","हे ढ्लाव ते बेइनव, असेईं एन्च़रे न लोड़े ज़ीयेरू ज़ेन्च़रे अस अपने पापी सुभावेरे मुताबिक ज़ीनू चातम, पन असेईं एन्च़रे ज़ीयोरू लोड़े ज़ेन्च़रे परमेशरेरो आत्मा चाते। ");
INSERT INTO bhd_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","किजोकि अगर तुस अपने पापी सुभावेरे मुताबिक ज़ीले त तुस मरेले, पन अगर तुस पवित्र आत्मारे मुताबिक च़लेले त तुस अपने पापी सुभावेरां कम्मां केरनां बंद केरेले ते फिरी तुस ज़ींते राले। ");
INSERT INTO bhd_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","किजोकि ज़ेत्रे परमेशरेरे आत्मारे च़लाने सेइं च़लतन तैन्ना परमेशरेरे बच्चेन। ");
INSERT INTO bhd_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","किजोकि ज़ै आत्मा तुसन मैलोरोए तुसन फिरी गुलाम बेनतां रानेरे लेइ नईं, बल्के तै तुसन परमेशरेरे बच्चे बनाते। तैसेरे ज़िरिये अस परमेशरे जो हे अब्बा, हे बाजी ज़ोतम। ");
INSERT INTO bhd_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","पवित्र आत्मा एप्पू इश्शी आत्मा सेइं मिलतां गवाही देते, कि अस परमेशरेरे बच्चेम। ");
INSERT INTO bhd_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","किजोकि अस परमेशरेरे बच्चेम ते असां तैना बरकतां हासिल केरमेले ज़ैना परमेशर अपने लोकां केरे लेइ रेखोरिन, ते मसीहेरे लेइ भी ज़ैन परमेशरे रखोरूए, तैन भी अस मसीह सेइं साथी हासिल केरमेले; किजोकि अगर अस मसीहेरे ज़ेरे दुःख झ़ैलमेले त अस भी मसीहे साथी महिमा हासिल केरमेले। ");
INSERT INTO bhd_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","मीं पूरू याकीने, कि ज़ैना दुःख अस झ़ैल्लने लोरेम, तैस महिमारे सामने, ज़ै परमेशर असन देनेबालोए, किछ भी नईं। ");
INSERT INTO bhd_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","किजोकि सैरी रच़नारी चीज़ां बड़े बे सबरी सेइं तैस वक्तेरो इंतज़ार केरने लोरिन, कि ज़ेइस परमेशरे इन बांदो केरनू तैसेरे सच़्चे बच्चे कौन आन। ");
INSERT INTO bhd_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","किजोकि ज़ैन किछ परमेशरे बनाव, तैन सैरी चीज़ेइं अपनि कीमत गवाइ, एल्हेरेलेइ नईं कि तैना अपने आप चैती थी, पन परमेशरे एन भोने दित्तू। पन फिरी भी उमीदे। ");
INSERT INTO bhd_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","कि सृष्टि एप्पू भी खुश आए कि विनाशे करां छुटकारो हासिल केरतां, परमेशरेरे बच्चां केरे महिमारी अज़ैदी मां खुशी मनाली। ");
INSERT INTO bhd_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","किजोकि अस ज़ानतम कि सारी सृष्टि मिलतां हुना तगर कर लातीए ते तकलीफी मां तड़फतीए, ज़ेन्च़रे दोज़ींती गल्हे बिशनेरी तकलीफ भोतीए। ");
INSERT INTO bhd_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","सिर्फ तैन्ना नईं पन अस भी ज़ैन एजने बैली महिमारो पेइले फलेरो स्वाद च़खनेरे लेइ पवित्र आत्मा दित्तो, पन अस हेजू भी परमेशरेरे वक्ते बलगने लोरेम ज़ैखन परमेशर अपने बच्चे केरे रूपे मां कबूल केरेलो, ते असन जिसमेरे बुरैई करां छुटकारो देलो। ");
INSERT INTO bhd_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","हुनी परमेशरे असन मुक्ति दित्तोरीए, असन ई उमीदे। पन अगर तुस कोन्ची चीज़ी हासिल केरनेरे लेइ उमीद केरथ ज़ै तुसन कां पेइली आए, त फिरी तै उमीद नईं। किजोकि ज़ैस चीज़ी कोई हेरने लोरोए तैसेरी उमीद कुन केरे? ");
INSERT INTO bhd_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","पन ज़ैस चीज़ी अस न लहम, अगर तैसेरी उमीद रखतम, त सबरी सेइं तैस बलगते भी रातम। ");
INSERT INTO bhd_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","एन्च़रे पवित्र आत्मा इश्शी मद्दत केरते ज़ैखन अस परमेशरे पुड़ भरोसो रखने मां कमज़ोर भोतम, किजोकि अस न ज़ानम, कि प्रार्थना केन्च़रे केरतन; पन पवित्र आत्मा एप्पू कर लेइतां ज़ै बयानेरे बेइरे, इश्शे लेइ बिनती केरतीए। ");
INSERT INTO bhd_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ते परमेशर ज़ै मनां केरो ज़ान्ने बालोए ज़ानते, कि पवित्र आत्मा कुन लोरो ज़ोने। किजोकि तै पवित्र लोकां केरे लेइ परमेशरेरे मेर्ज़ी सेइं बिनती केरते। ");
INSERT INTO bhd_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ते अस ज़ानतम, कि ज़ैना लोक परमेशरे सेइं प्यार केरतन, परमेशर तैन केरे लेइ सब गल्लां केरे ज़िरिये भलाई पैदा केरते; मतलब तैन केरे लेइ ज़ैना तैनी अपने मेरज़ारे मुताबिक च़ुनोरेन। ");
INSERT INTO bhd_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","किजोकि तैने ज़ैना पेइले च़ुने, ते पेइले ठहराए भी कि तैसेरे मट्ठरे रूपे मां भोन, ताके तै बड़े ढ्लान मां ज़ेठो भोए। ");
INSERT INTO bhd_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","फिरी ज़ैना तैने पेइले ठहराए, तैना च़ुने भी, ते ज़ैना च़ुने, तैना धर्मी भी ठहराए, ते ज़ैना धर्मी ठहराए तैन महिमा भी दित्तोरीए। ");
INSERT INTO bhd_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ते अस एन गल्लां केरे बारे मां कुन ज़ोम? अगर परमेशर इश्शे पासे, ते इश्शो खलाफ कौन भोइ बटते? ");
INSERT INTO bhd_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","परमेशरे अपनू मट्ठू भी अपने लेइ न रख्खू, बल्के तैन इश्शे सेब्भी केरे लेइ तैसेरे दुश्मना केरे हवाले दित्तू, ते तै मसीह सेइं असन तैन सब किछ देलो ज़ेसेरो वादो तैने असन सेइं कियोरोए। ");
INSERT INTO bhd_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","अस परमेशरेरे च़ुनोरम, कोई असन पुड़ परमेशरेरे सामने दोष न लेई बटे, किजोकि तैए ज़ैने अस धर्मी ठहरावरेम। ");
INSERT INTO bhd_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","फिरी कौने ज़ै सज़ारो हुक्म देलो? कोई नईं, यीशु मसीह तैए ज़ै मरो, बल्के मुड़दन मरां ज़ींतो भोव, ते परमेशरेरे देइने पासे, ते इश्शे लेइ बिनती भी केरते। ");
INSERT INTO bhd_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","कौन असन मसीहेरे प्यारे करां अलग केरि बटते? मुसीबत या तंगी, या ज़ुलम, या काल, या नगूपन, या खतरो, या तलवार? इन मरां कोई भी चीज़ असन मसीहेरे प्यारे करां अलग न केरि बटे। ");
INSERT INTO bhd_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ज़ेन्च़रे पवित्रशास्त्रे मां लिखोरूए, “तेरे लेइ अस हर वक्त मौतरे खतरे मां रातम; अस मैरोने बैली भैड्डां केरे ज़ेरे गने जोरेम।” ");
INSERT INTO bhd_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","पन ज़ैने असन सेइं प्यार कियोरोए, तैसेरे ज़िरिये असन पूरे तरीके सेइं एन सैरी बुरी गल्लां पुड़ ज़ीत हासिल आए। ");
INSERT INTO bhd_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","किजोकि मीं पूरू याकीने, कि न मौत, न ज़िन्दगी, न स्वर्गदूत, न हकोमतां, न ज़ै वक्त च़लोरोए, न एजनेबालो वक्त, न शेक्ति, न उचार, ");
INSERT INTO bhd_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","न डुघार ते न कोई होरि सृष्टि, असन परमेशरेरे प्यारे करां ज़ै इश्शे प्रभु यीशु मसीह मांए अलग केरि सकेली। ");
INSERT INTO bhd_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","अवं मसीह मां सच़ ज़ोताईं, झूठ न ज़ोईं, ते मेरो ज़मीर भी पवित्र आत्माई मां गवाही देते। ");
INSERT INTO bhd_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","कि मीं बड़ो दुःखे, ते मेरो दिल लगातार मेरे लोकां केरे लेइ उदास भोते। ");
INSERT INTO bhd_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","किजोकि मेरे यहूदी ढ्ला ते बेइनां केरे लेइ, अवं हमेशारे लेइ श्रापित भोथो ते मसीह करां अलग भोथो अगर तैन इस वजाई सेइं तैन मुक्ति मैलती। ");
INSERT INTO bhd_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","तैना इस्राएलिन; ते तैना परमेशरेरे लेपलक बच्चे भोनेरे लेइ च़ुनोरेन, ते परमेशरेरे अपनि महिमा तैन पुड़ बांदी की। ते तैनी तैस सेइं करार कियो, ते तैन मूसेरो कानून दित्तो। ते तैनी तैन अपनि आराधना ते अपने खूबसूत वादे पूरे केरनेरे लेइ हासिल केरनेरो मौको दित्तो। ");
INSERT INTO bhd_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","अब्राहम, इसहाक ते याकूब तैन केरे दादे पड़दादे थिये, ते मसीह भी जिसमेरे लिहाज़े सेइं तैने मरां अव, तै परमेशरे ते सेब्भन करां बाए ज़ै सेब्भन पुड़ राज़ केरते, तैसेरी महिमा हमेशा भोती राए। आमीन। ");
INSERT INTO bhd_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","पन इन नईं, कि परमेशरेरू वचन टलू कि, सारे ज़ैना इस्राएलेरे वंशन, तैना सब सच़्च़े इस्राएली नईं। ");
INSERT INTO bhd_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ते न अब्राहमेरे वंश मां ज़र्म भोने सेइं सब परमेशरेरे बच्चे भोन। पन पवित्रशास्त्रे मां परमेशर अब्राहमे सेइं ज़ोते, “ज़ैना इसहाकेरे वंशे मरां पैदा भोले तैन्ने तेरू वंश मन्नू गालू।” ");
INSERT INTO bhd_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","मतलब ज़ैना कुदुरती तरीके सेइं ज़र्म घिन्तन तैना परमेशरेरे बच्चे नईं, पन सिर्फ वादेरे बच्चे अब्राहमेरे बच्चे गने गातन। ");
INSERT INTO bhd_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","किजोकि वादेरू वचन इने, “अवं एग्री साल इस वक्ते फिरी एज्जेलो, ते सारारू अक मट्ठू भोनूए।” ");
INSERT INTO bhd_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ते सिर्फ एन नईं, पन ज़ेइस रिबका भी एक्की सेइं मतलब इसहाके सेइं दोज़ींती थी ते तैसेरे पेटे मां दूई बच्चे थिये। ");
INSERT INTO bhd_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","ते हेजू तगर तैना बच्चे न थिये ज़र्मोरो, ते न तैनेईं रोड़ू या बुरू कियेरू थियूं, कि परमेशरे रिबका सेइं ज़ोवं, तेरू बड्डू मट्ठू निकड़ेरी सेवा केरेलू। परमेशरे एन एल्हेरेलेइ ज़ोवं कि एन हिराए, कि तै अपनि मेर्ज़ी सेइं फैसले केरते ते इन तैन मट्ठां केरे रोड़ां या बुरे कम्मां केरे वजाई सेइं न थियूं। ");
INSERT INTO bhd_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ज़ेन्च़रे पवित्रशास्त्रे मां लिखोरूए, “मीं याकूबे सेइं प्यार कियो, पन एसावेरो इन्कार कियो।” ");
INSERT INTO bhd_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ते अस कुन ज़ोम, कि परमेशर बेइन्साफे कि तै ज़ैस चाते च़ुनते? नईं, कधे नईं! ");
INSERT INTO bhd_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","किजोकि परमेशर मूसे सेइं ज़ोते, “अवं ज़ैस केन्ची पुड़ दया केरनि चैई, तैस पुड़ दया केरेलो ते ज़ैस पुड़ तरस केरनो चैई तैस पुड़ तरस केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","एल्हेरेलेइ परमेशर तैस च़ुनेलो ज़ैस पुड़ तै दया हिरानी चाते; तैसेरी इच्छा लोक ज़ैन चातन या केरनेरी कोशिश केरतन तैस पुड़ निर्भर नईं। ");
INSERT INTO bhd_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","किजोकि पवित्रशास्त्रे मां परमेशरे मिस्रेरे राज़े फ़िरौन सेइं ज़ोवं, “मीं तू एल्हेरेलेइ राज़ो बनोरोस, कि तीं मां अपनि शक्ति हिरेईं, ते मेरे नंव्वेरो प्रचार सैरी ज़मीनी पुड़ भोए।” ");
INSERT INTO bhd_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ते ज़ैस पुड़ तै चाते, तैस पुड़ दया केरते; ते ज़ैस चाते ढीठ केरते। ");
INSERT INTO bhd_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ते किछ लोक मीं सेइं ज़ोले, “अगर एन्च़रे, त फिरी परमेशर केन्च़रे फैसलो केरि बटते कि अस गलत आम? एल्हेरेलेइ कोई भी तैस ज़ैन तै चाते केरने करां न रोकी बटे।” ");
INSERT INTO bhd_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","हे मैन्हु, तू कौन आस, ज़ै तू परमेशरे सेइं बेंस केरतस? कुन बानोरी चीज़ बनाने बाले सेइं ज़ोई बटतीए, “तीं अवं एरी किजो बनाई?” ");
INSERT INTO bhd_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","कुन कुम्हारे मित्ती पुड़ अधिकार नईं, कि एक्की लुनदे मरां, अक भांड आदरारे लेइ बनाए, ते होरू नरादराए लेइ बनाए? ");
INSERT INTO bhd_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","(परमेशरे अपने बनावरो लोकन सेइं ज़ैन तै चाए तैन केरनेरो अधिकारे) ज़ैना नाश भोनेरे काबल थिये, तैन केरे खलाफ परमेशर अपनो क्रोध हिरानो ते अपनि सामर्थ बांदी केरनेरी चातो थियो, पन तैसेरे बदले मां तैनी सबर की। ");
INSERT INTO bhd_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","(तैनी एन कियूं) किजोकि तै हिरानू चातो थियो (मसीहेरे मौतरे बलिदानेरे ज़िरिये) तै केत्रो महान आए, ज़ैखन तै तैन लोकन पुड़ दया केरते ज़ैना तैनी अपनि महिमा मां शामिल भोने लेइ च़ुनोरेन। ");
INSERT INTO bhd_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","मतलब असन पुड़ ज़ैना तैने न सिर्फ यहूदन मरां बल्के गैर कौमन मरां भी च़ुने। ");
INSERT INTO bhd_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ज़ेन्च़रे तै होशे नेबेरे किताबी मां ज़ोते, “ज़ैना मेरे लोक न थी, तैन अवं अपने लोक ज़ोलो। ते ज़ैना लोक मेरे ट्लारे न थिये, तैन जो ट्लारे ज़ोइलो। ");
INSERT INTO bhd_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ते तैस्से ठैरी ज़ैड़ी परमेशरे ज़ोरू थियूं, तुस मेरे लोक नईं, तैस्से ठैरी ज़ींतो परमेशर तैन ज़ोलो तुस मेरे बच्चे।” ");
INSERT INTO bhd_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ते यशायाह नबी इस्राएली लोकां केरे बारे मां ज़ोते, “चाए इस्राएलेरी कुटमेरी गिनती समुद्रेरे किनारे रेतरी ज़ेरि बड़ी जादे भोली फिर भी तैन मरां थोड़े बच़ेले। ");
INSERT INTO bhd_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","किजोकि प्रभु जल्दी दुनियारे सेब्भी लोकां केरो सेखती सेइं इन्साफ केरेलो।” ");
INSERT INTO bhd_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ज़ेन्च़रे यशायाह नेबे पेइलू भी ज़ोरू थियूं, “कि सर्वशक्तिमान परमेशरे इश्शे लेइ इश्शू वंश न बाच़ाथो, त अस सदोम ते अमोरा नगरां केरे ज़ेरे भोने थिये, ज़ैना परमेशरे पूरे तरीके सेइं बरबाद कियां।” ");
INSERT INTO bhd_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ते अस कुन ज़ोम? इन कि ज़ैना गैर कौमां केरे लोक ज़ैना धार्मिकता न थी तोपते, तैनेईं धार्मिकता हासिल की, मतलब तै धार्मिकता ज़ै विश्वासे सेइं आए। ");
INSERT INTO bhd_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","पन इस्राएली लोक मूसेरो कानून मेन्तां परमेशरेरे करां धर्मी ज़ुवानू चाते थिये, पन तैन न भोइ बटु। ");
INSERT INTO bhd_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","किजो नईं? एल्हेरेलेइ कि तैना विश्वासे सेइं नईं, पन मूसेरो कानून मेन्तां धर्मी भोनेरी कोशिश केरते थिये, तैनेईं तैस ठोकर खानेबाले घोड़े सेइं ठोकर खाइ। ");
INSERT INTO bhd_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ज़ेन्च़रे पवित्रशास्त्रे मां लिखोरूए; “तका अवं सिय्योने मां अक ठेस लानेबालो घोड़, ते ठोकर खाने बाली चट्टान रखताईं; ते ज़ै तैस पुड़ विश्वास केरेलो, तै शरमिन्दा न भोलो।” ");
INSERT INTO bhd_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","हे ढ्लाव ते बेइनव मेरे मनेरी इच्छा ते इस्राएली लोकां केरे लेइ परमेशरे कां मेरी ई प्रार्थनाए, कि तैन मुक्ति मैल्ले। ");
INSERT INTO bhd_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","अवं ज़ानताईं कि तैना परमेशरेरे लेइ जोशे मां रहतन, पन सच़्च़े ज्ञाने सेइं नईं। ");
INSERT INTO bhd_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","किजोकि तैना तैस धार्मिकताई करां अनज़ान राए ज़ै परमेशरे तरफां मैलतीए, ते तैनेईं अपनि धार्मिकता बनानेरी कोशिश की, एल्हेरेलेइ तैनेईं अपनो आप परमेशरेरी धार्मिकतारे अधीन न कियो। ");
INSERT INTO bhd_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","किजोकि मसीहे तै मकसद पूरो कियोरोए ज़ेसेरे लेइ मूसेरो कानून दित्तोरो थियो, ताके ज़ै कोई मसीह पुड़ विश्वास केरे तै परमेशरेरी नज़री मां धर्मी भोए। ");
INSERT INTO bhd_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","किजोकि मूसे इन लिखोरूए, “ज़ै मैन्हु तैस धार्मिकता मुताबिक च़लते ज़ै कानूनेरे ज़िरिये आए, तै तैसेरे ज़िरिये सेइं ज़ींतो रालो।” ");
INSERT INTO bhd_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","पन ज़ै धार्मिकता विश्वासे सेइं आए, तैसेरे बारे मां पवित्रशास्त्र इन ज़ोते, “तू अपने मने मां इन न ज़ोइयां कि स्वर्गे पुड़ कौन च़ढ़ेलो?” (मतलब मसीह आन्ने) ");
INSERT INTO bhd_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","या इन न ज़ोइयां “पाताले मां कौन गालो?” (मतलब मसीह मुड़दन मरां ज़ींतो केरतां बा आने) ");
INSERT INTO bhd_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","पन पवित्रशास्त्र इन ज़ोते “परमेशरेरू वचन तेरे नेड़े, ते तेरे ऐशी मां ते मने मां आए,” इन तैन वचने ज़ैन असन परमेशरे पुड़ विश्वास केरनेरे बारे मां ज़ोते, ज़ेसेरो अस प्रचार केरतम। ");
INSERT INTO bhd_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","अगर तू अपने ज़बाना यीशुए, प्रभु ज़ेनतां मन्नस ते अपने दिल सेइं विश्वास केरस, कि परमेशरे तै मुड़दन मरां ज़ींतो कियो, त तीं परमेशर पक्की मुक्ति देलो। ");
INSERT INTO bhd_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","किजोकि इश्शे विश्वासेरे ज़िरिये सेइं अस परमेशरेरी नज़री मां धर्मी भोतम, ते इश्शे इकरार केरने सेइं मुक्ति मैलोरीए। ");
INSERT INTO bhd_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","किजोकि पवित्रशास्त्र इन ज़ोते, “ज़ै कोई तैस पुड़ विश्वास केरे, तै शरमिन्दो न भोलो।” ");
INSERT INTO bhd_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","इन एल्हेरेलेइ आए कि यहूदन ते गैर कौमन मां कोई फर्क नईं, किजोकि परमेशर सेब्भी केरो प्रभुए; ते ज़ैना तैसेरू नवं घिन्तन तै तैन बरकत देते। ");
INSERT INTO bhd_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ज़ेन्च़रे पवित्रशास्त्र ज़ोते, “ज़ै कोई प्रभुएरू नवं घिन्नेलो, तैस मुक्ति मैलेली।” ");
INSERT INTO bhd_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","पन प्रभु पुड़ लोकेईं विश्वास न कियो त तैना तैसेरू नवं किजो घिन्न? ते ज़ेसेरे बारे मां तैनेईं शुनोरू नईं तैस पुड़ केन्च़रां विश्वास केरेले? ते अगर तैसेरे बारे मां कोई प्रचार न केरे त तैना केन्च़रां शुनी बटतन? ");
INSERT INTO bhd_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ते अगर कोई प्रचार केरनेरे भेज़ो न गाए त तैना केन्च़रे शुनेई बटतन? ज़ेन्च़रे पवित्रशास्त्र ज़ोते, “तैन केरे पव केत्रे रोड़ेन, ज़ैना खुशखबरी शुनातन!” ");
INSERT INTO bhd_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","पन सेब्भेईं तै खुशखबरी कबूल न की। यशायाह नबी ज़ोते, “हे प्रभु कोई इश्शे सन्देशे पुड़ विश्वास न केरे।” ");
INSERT INTO bhd_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","एल्हेरेलेइ मसीहेरे बारे मां सन्देश शुन्नेरे बगैर कोई भी तैस पुड़ विश्वास न केरि बटे। ");
INSERT INTO bhd_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","पन अवं पुछ़तईं, “कुन इस्राएली लोकेईं न शुनू?” हाँ तैनेईं ज़रूर शुनू, पन पवित्रशास्त्रे मां लिखोरूए “तैन केरू वचन सैरी ज़मीनी पुड़, ते तैन केरि गल्लां दुनियारे हर पासे पुज़ोरिन।” ");
INSERT INTO bhd_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","अवं फिरी पुछ़तईं, कुन इस्राएली लोकेईं तैन वचन न समझ़ू? पेइलो त प्रभुए मूसेरे ज़िरिये ई जुवाब देते, “अवं तैन केरे ज़िरिये ज़ै कौम नईं, इस्राएली लोकन जलन करालो, अवं बेवकूफ गैर कौमां केरे लोकां केरे ज़िरिये तुसन सरकालो।” ");
INSERT INTO bhd_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","फिरी यशायाह बड़े दिलेरी सेइं परमेशरेरे लेइ ज़ोते, “ज़ैना मीं न थी तोपते, तैन अवं मैलो, ते ज़ैना मीं पुछ़ते भी न थी, तैन पुड़ अवं बांदो भोव।” ");
INSERT INTO bhd_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","पन इस्राएलेरे बारे मां परमेशर इन ज़ोते, “अवं हुक्म न मन्नेबाले ते बेंस केरनेबाले लोकन सैरी दिहैड़ी कुजातो राव।” ");
INSERT INTO bhd_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","एल्हेरेलेइ अवं पुछ़तईं, कुन परमेशरे अपने लोक शारे? नईं, कधे नईं! अवं भी त इस्राएली आईं, अब्राहमेरे खानदाने ते बिन्यामीनेरे गोत्रे मरां आईं। ");
INSERT INTO bhd_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","परमेशरे अपने तैना लोक न शारोरे, ज़ैना तैने पेइले च़ुने, कुन तुस न ज़ानथ, कि पवित्रशास्त्र एलिय्याहेरे बारे मां कुन ज़ोते, कि एलिय्याह नेबे इस्राएली लोकां केरे खलाफ परमेशरे कां बिनती केरते? ");
INSERT INTO bhd_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","तैने ज़ोवं “हे प्रभु, तैनेईं तेरे नबी मारे, ते तेरी बलिदान केरनेरी ठारां बरबाद की, ते सिर्फ अवं ए ऐकैलो बच़ोरोई ज़ै तीं मन्ने बालोईं, हुनी तैना मीं भी मारने चातन।” ");
INSERT INTO bhd_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","पन परमेशरे एलिय्याहे जुवाब दित्तो, “मीं अपने लेइ 7000 मड़द रखोरेन, ज़ैनेईं बाल देबतेरे मूरती कां मथ्थो नईं टेकोरो।” ");
INSERT INTO bhd_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","एन्च़रे इस वक्ते भी थोड़े ज़ेरे लोक बज़ोरेन, ज़ैना परमेशरे अपने अनुग्रह वजाई सेइं च़ुनोरेन। ");
INSERT INTO bhd_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","अगर इन परमेशरेरे अनुग्रहे सेइं भोरूए, ते फिरी मूसेरे कानूनेरे मुताबिक कम्मन केरने सेइं नईं, नईं त फिरी अनुग्रह, अनुग्रह न राव। ");
INSERT INTO bhd_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ते फिरी नितीजो कुन भोव? कि इस्राएली ज़ेसेरी तोपी मां आन, तै तैन न मैलो; पन च़ुनोरेन मैलो, ते होरे बाकी लोक सखत कियोरेन। ");
INSERT INTO bhd_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ज़ेन्च़रे पवित्रशास्त्रे मां लिखोरूए, “परमेशरे अज़्ज़ेरे दिहाड़ी तगर तैन केरो मन ते दिल सुस्त कियो, ते एरी एछ़्छ़े दित्ती कि ताके तैना लेई न बटन, ते एरे कन ताके तैना शुनी न बटन।” ");
INSERT INTO bhd_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ते राज़ो दाऊद ज़ोते, “अवं परमेशरे कां प्रार्थना केरताईं कि तै तैन केरे तिहारन मां ट्लेइ बटे ते फसाए, ते परमेशर तैन झुकाए ते तैन सज़ा देइ बटे। ");
INSERT INTO bhd_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ते तैन केरि एछ़्छ़न पुड़ आंधरू भोए, ताके तैना लेई न बटन, ते परमेशर तैन, तैन केरि परेशैनी केरे वजाई सेइं दुखी केरि बटे।” ");
INSERT INTO bhd_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","त अवं पुछ़तईं, कुन यहूदी लोक ठोकर लगनेरे वजाई सेइं हमेशारे लेइ बिछ़ड़े? नईं, कधे नईं! पन तैन केरे विश्वास न केरनेरे वजाई सेइं गैर कौमन मुक्ति मैल्ली ताके तैन जलन भोए। ");
INSERT INTO bhd_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ते अगर तैन केरे विश्वास न केरनेरे वजाई सेइं गैर कौमरे लोकां केरू भलू भोवं, हकीक्ति मां गैर कौमां केरे लेइ बड़ू रोड़ू भोलू ज़ेइस यहूदी लोक परमेशरे कां वापस एज्जेले। ");
INSERT INTO bhd_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","अवं तुसन गैर कौमरे लोकन सेइं एन ज़ोताईं। कि अवं गैर कौमरे लोकां केरो प्रेरित आईं, ते अपने सेवारे बारे मां घमण्ड केरि। ");
INSERT INTO bhd_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ताके अवं कोन्ची तरीके सेइं अपने लोकन जलन करेइतां तैन मरां किछन मुक्ति दूवेईं। ");
INSERT INTO bhd_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","किजोकि इस्राएली लोकां केरू शारू गानू दुनियारे लोकां केरे लेइ मेल मिलापेरी वजा बनी, ते तैन केरू यीशु कबूल केरनू कि तै मसीह आए, एन एरू भोलू ज़ेन्च़रे मुड़देरू ज़ींतू भोनू! ");
INSERT INTO bhd_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ते किजोकि पूर्वज अब्राहम ते दादे पड़दादे पवित्र थिये ते तैन केरि खानदानी भी पवित्र भोली, ज़ैखन चड़तलरो पेइलो पेइड़ो परमेशरेरे लेइ च़ाढ़नेरे वजाई सेइं पवित्र भोरोए, त पूरू सन्नोरू अट्टू भी पवित्र भोरूए, ते ज़ैखन ज़ील पवित्र भोवं, त ड