﻿USE sofia;
DROP TABLE IF EXISTS sofia.bgt_vpl;
CREATE TABLE bgt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bgt_vpl WRITE;
INSERT INTO bgt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iaani na titionodia ara hutugna a Jisas Krais. Imanea na vinahuhugna a King Deved, ma na vinahuhugna a Ebraham. ");
INSERT INTO bgt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Na titiono iaani ke turughu mai tagna Ebraham me jufu tagna a Deved: Ebraham ke tamagna a Aisak. Aisak ke tamagna a Jekob. Jekob ke tamadia Jiuda mara tahigna. ");
INSERT INTO bgt_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jiuda ke tamadia a Peres ma Jera (a idodia romara, a Tama). Peres ke tamagna a Hesron. Hesron ke tamagna a Ram. ");
INSERT INTO bgt_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","A Ram ke tamagna a Aminadab. Aminadab ke tamagna a Nason. Nason ke tamagna a Salmon. ");
INSERT INTO bgt_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ke tamagna a Boas (a idogna a Boas, a Rehab). Boas ke tamagna a Obed (a idogna a Obed, a Rut). Obed ke tamagna a Jesi. ");
INSERT INTO bgt_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ke tamagna a king Deved. Deved ke tamagna a Solomon (a idogna Solomon a Batsiba, na vaivine thehe sasani ke kidi taulaghi tagna a Uria). ");
INSERT INTO bgt_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","A Solomon ke tamagna Rehoboam. Rehoboam ke tamagna Abia Abia ke tamagna a Asa. ");
INSERT INTO bgt_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ke tamagna a Jehosafat. Jehosafat ke tamagna a Joram. Joram ke tamagna Usia. ");
INSERT INTO bgt_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ke tamagna a Jotam. Jotam ke tamagna a Ahas. Ahas ke tamagna a Hesekia. ");
INSERT INTO bgt_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia ke tamagna a Manase. Manase ke tamagna a Amon. Amon ke tamagna a Josaia. ");
INSERT INTO bgt_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia ke tamadia a Jehoiakin mara tahigna (Mara iraani ena havi ghohi gi ena mai mara nidia na thevuioka mara Israel mena sekara mena hatira vano i Babilon). ");
INSERT INTO bgt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Leghudia mara Israel kena mono seka i Babilon, Jehoiakin ke tamagna a Sealtiel. Sealtiel ke tamagna a Jerubabel. ");
INSERT INTO bgt_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jerubabel ke tamagna a Abiud. Abiud ke tamagna a Eliakim. Eliakim ke tamagna a Aso. ");
INSERT INTO bgt_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso ke tamagna a Jadok. Jadok ke tamagna a Akim. Akim ke tamagna a Eliud. ");
INSERT INTO bgt_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ke tamagna a Eleasa. Eleasa ke tamagna a Matan. Matan ke tamagna a Jekob. ");
INSERT INTO bgt_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekob ke tamagna a Josep, imanea hiri a taugna a Meri. Meri a idogna a Jisas kena kiloagna a Vahavi. ");
INSERT INTO bgt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Turughu tagna Ebraham me jufu tagna a King Deved, e salaghe vati na pagusu. Turughu tagna a Deved me jufu kori vido mara nidia na thevuioka mara Israel kena hatira vano i Babilon, e salaghe vati na pagusu. Turughu kori vido mara Israel kena mono i Babilon me jufu kori havigna mai a Vahavi, e salaghe vati na pagusu. ");
INSERT INTO bgt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iaani na titiono eigna na havigna mai a Jisas Krais. A Meri, a idogna a Jisas, kena parua ghohi bali taulaghi tagna a Josep. Roira koro boi mono haidu mua, kari a Meri ke boebote kori mana nigna na Tarunga ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A Josep na mane jino me bosi magnahaghinia keda vamamoa a Meri naghodia na mavitu. Na vunegna iangeni, imanea ke haga agutu poloa na vateoagna rodia na paru. ");
INSERT INTO bgt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kori vido a Josep ke talu toatogha na eiagna na puhi iangeni, sina enjel nigna a God ke tate vania kori maumaturungita me veleagna, “Josep, vinahuhugna a King Deved, o saghoi mataghu na taulaghi tagna a Meri, eigna iia ke boebote ghohi kori mana nigna na Tarunga ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iia keda vahua a dathegna mane, mokoda tughuniagna a Jisas, eigna imanea keda vahavira nigna na mavitu eigna na komi paluhadia.” ");
INSERT INTO bgt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na komi fata iraani e mono mai eigna keda tutuni na hava a God ke vele aua i hau ma na nigna na profet Aisaia ke risoa. A God ke velea, ");
INSERT INTO bgt_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Na vaivine ke boi nere duagna sa mane keda boebote mekeda vahua a dathegna mane, ma na komi tinoni kedana kiloagna Emanuel.” Na ghaghana koragna na aha iangeni, “A God ke mono duada.” ");
INSERT INTO bgt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kori vido ke rarai, a Josep ke leghua na haghoregna na enjel nigna a Lod. Imanea ke taulaghi tagna a Meri, ");
INSERT INTO bgt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","keana e boi nere haidu duagna me ghieghilei havi mai na gari. Ma a Josep ke tughuniagna na ahagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jisas ke havi mai i Betlehem kori provins i Jiudea, kori vido a Herod ke king i Jiudea. Leghugna ke havi mai a Jisas, kekeha mara Maghoi eidia sina meleha i eta vavaho kena taveti mai mena jufu i Jerusalem. ");
INSERT INTO bgt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Imarea kena huahuati kilili vaghagna iaani, “Ivei ke havi mai na gari keda vunaghi pungusira mara Jiu? Ighami kiti reghia na vaitughu kori vido ke hadi mai i eta ma na vaitughu iangeni ke tatelia vanighami imanea ke havi ghohi. Na vunegna iangeni, ighami kiti mai eigna kitida maimanihihia nimami imanea.” ");
INSERT INTO bgt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kori vido a King Herod ke rongovia na rorongo iaani, imanea ke boi toke na ghaghanagna, me vaghagna ghua na mavitu gougovu i Jerusalem. ");
INSERT INTO bgt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Imanea ke kilo haidura mara na naghoi pris, mi mara na velepuhigna na vetula nigna a Moses me huatira, “Na komi profet kena velea ivei keda havi mai a Vahavi na?” ");
INSERT INTO bgt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Imarea kena haghore tughua, “A Vahavi keda havi mai i Betlehem, na meleha kori provins i Jiudea. Vaghagna a profet Maika ke risoa, ");
INSERT INTO bgt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem, ighoe sina meleha ke nagho puala kori provins i Jiudea, eigna sina king keda au mai itamua mi manea keda batura me reireghira nigua na mavitu Israel.’” ");
INSERT INTO bgt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","King Herod ke kilora mai mara Maghoi eigna kedana haidu ghehedia duagna. Gi e huatira eigna ingiha kena kidi reghia na vaitughu. ");
INSERT INTO bgt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Imanea ke velera, “Oti vano i Betlehem moti hiro toetoke maia na gari iangeni. Kori vido kotida reghipada imanea, oti ghoi tabiru mai itagua moti varorongou eigna inau huju u magnahaghinia mua kuda vano mu maimanihihia nigua.” ");
INSERT INTO bgt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Leghugna iaani, mara Maghoi kena taveti au mena ghoi reghia na vaitughu kena reghia ghohi i hau. Imarea kena totogo hutu puala na reghiagna. Na vaitughu ke batura me ghieghilei soto popogna na vathe ke mono na gari. ");
INSERT INTO bgt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mara Maghoi kena haghe kori vathe mena reghia na gari duagna a idogna Meri. Imarea kena pogho horu mena maimanihihia na gari. Gi ena hati aura nidia na komi dotho mena dotho vania: na gol, na ghaighubagha ma na mur. ");
INSERT INTO bgt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Leghugna na dotho kena eia, imarea kena tabiru kori melehadia kori hangana ke tavogha eigna a God ke velera kori maumaturungita eigna kedana boi ghoi tabiru vano tagna a Herod. ");
INSERT INTO bgt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Leghugna mara Maghoi kena taveti vano, sina enjel nigna a Lod God ke tate vania a Josep kori maumaturungita me ania, “Josep, o sokara hadi mo talangira na gari ma idogna moti ghogho vano i Ijip, eigna boi hauhaugna a Herod keda hiroa na gari iaani bali vathehea. Otolu mono ngengeni mu ghieghilei veleghamu na maghavu kotida ghoi tabiru mai.” ");
INSERT INTO bgt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A Josep ke sokara hadi me talangira na gari ma idogna kori bongi iangeni mena ghogho vano i Ijip. ");
INSERT INTO bgt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tolira kotolu mono i Ijip me ghieghilei thehe a Herod. Me tutuni na hava a a Lod God ke velea i hau ma na profet Hosea ke risoa, “Inau ku kilo aua a dathegu i Ijip.” ");
INSERT INTO bgt_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kori vido a King Herod ke adoa mara Maghoi kena pilaunia, imanea ke dikatagna puala. Imanea ke vetulara vano nigna na komi soldia i Betlehem ma na komi meleha ghaghireigna, mena vathehera na komi gari mane kena boi jufungia mua e rua na vinoghadia. Herod ke eia iangeni eigna mara Maghoi kena velea e rua na vinogha ke haliu atu ghohi leghugna na tategna na vaitughu. ");
INSERT INTO bgt_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kori dani iangeni na hava a Lod ke velea aua i hau ma na profet a Jeremaia ke risoa ke tutuni. Imanea ke risoa, ");
INSERT INTO bgt_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Imarea kena rongovia na tangi mate kori meleha i Rama. A Resel ke tangi eidia ara dathegna, me teo ahai ke tangomana na vasulagna eigna ara dathegna kena thehe ghohi.” ");
INSERT INTO bgt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Leghugna ke thehe a Herod, sina enjel nigna a Lod God ke tate vania a Josep kori maumaturungita i Ijip. ");
INSERT INTO bgt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Na enjel ke velea, “O sokara hadi mo talangira na gari ma idogna moti ghoi tabiru i Israel. Eigna arahai kena haga vathehea na gari kena thehe ghohi.” ");
INSERT INTO bgt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","A Josep ke sokara hadi me talangira na gari ma idogna, mena tabiru vano i Israel. ");
INSERT INTO bgt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Keana a Josep ke rongovia a Akelaos ke king i Jiudea eigna ke tughua a tamagna a Herod, mi manea ke mataghu nigna puala keda mono ngengeni. Mi kori maumaturungita sina enjel nigna a God ke veleagna a Josep eigna keda vano kori provins i Galili. ");
INSERT INTO bgt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na vunegna iangeni, tolira kotolu vano kori provins i Galili mena mono kori meleha i Nasaret. Kori vido kena mono i Nasaret na haghoredia mara na profet eigna a Vahavi ke tutuni, “Imarea kedana kiloagna imanea, na manegna i Nasaret.” ");
INSERT INTO bgt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Leghugna kekeha vinogha, a Jon Siuvitabu ke turughua nigna na agutu kori meleha ke gou i Jiudea. Imanea ke titioni vanira na komi tinoni ");
INSERT INTO bgt_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","me velera, “Oti tughua na havimiu ke koakoa eigna na maghavu a God keda vunaghi pungusira nigna na komi tinoni ke gharani mai ghohi!” ");
INSERT INTO bgt_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A Jon hiri, a profet Aisaia ke titionoa i hau vaghagna iaani, “Sina mane keda haohaghore heta kori meleha ke gou, ‘Oti kaikalitia na hangana vania a Lod moti vajinoa na bali taetavetigna.’” ");
INSERT INTO bgt_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A Jon ke pipisia na pohe ke agutua kori sesehugna na kamel ma na nigna na vovogho ke agutua kori ghuighuligna na kau. Ma na ghagna na vanga na cheche ma na kothogna na mijua. ");
INSERT INTO bgt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Sethe na tinoni i Jerusalem mi kori provins i Jiudea mi tadia na komi meleha ghaghireigna na bea hutu i Jodan kena haidu mai tagna a Jon. ");
INSERT INTO bgt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Imarea kena mai mena tuturi aua na komi paluhadia tagna a Jon me siuvitabura kori bea hutu i Jodan. ");
INSERT INTO bgt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kori vido a Jon ke reghira mara na Farise mi mara na Sadiusi kena mai mena haga siuvitabu nidia itagna, imanea ke velera, “Ighamu koti dika vaghagna na komi poli! Ehava? Ighamu koti ghaghana gi kotida siuvitabu vamua, ighamu tangomana kotida polo tagna na fate a God keda eia? Boi tangomana nimiu! ");
INSERT INTO bgt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Oti kidi eia na komi fata ke jino bali tateli aua ighamu koti tughua ghohi na havimiu ke koakoa, gi oti mai moti siuvitabu itagua. ");
INSERT INTO bgt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Oti saghoi ghaghana a God keda boi fateghamu eigna koti havi mai kori vikegna a hutuda a Ebraham. Eigna inau ku veleghamu, a God tangomana keda eia na komi ghahira iraani gi kedana ara vinahuhugna a Ebraham. ");
INSERT INTO bgt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ikeagaieni a God ke kaikaliti ghohi bali fatera na komi tinoni kena boi tughua na havidia, vaghagna ahai ke kaikaliti na toka horuagna na komi ghai. Na komi ghai ke boi toke na sagharodia, imanea keda toka horura me keda soni vanoa kori joto. ");
INSERT INTO bgt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Na siuvitabu inau ku eia kori bea ke tateli aua ighamu koti tughua ghohi na havimiu ke koakoa. Keana ahai keda mai leghugu keda siuvitabughamu kori Tarunga ke Tabu ma na joto. Imanea ke thaba vano itagua. Inau boi naba kuda hati aua nigna na sadol. ");
INSERT INTO bgt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Imanea vaghagna sina mane ke kaikaliti bali hati aua na ghuighuligna na wit kori ghanogna. Imanea keda hatia na komi ghanogna me boa kori vathegna, keana imanea keda pughulira na komi ghuighuligna kori joto ke teo na thehegna.” ");
INSERT INTO bgt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jisas ke turughu mai i Galili me vano jufu kori bea hutu i Jodan eigna keda siuvitabu tagna a Jon. ");
INSERT INTO bgt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Keana a Jon ke bosi magnahaghinia keda eia iangeni me veleagna, “Ehava gi o mai itagua eigna kuda siuvitabugho? Ighoe ghua koda siuvitabuu ri.” ");
INSERT INTO bgt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A Jisas ke haghore tughua, “Ikeagaieni e toke gi koda ei vaniu na hava ku kaegho. Roghita koroda leghua vamua na vanohehe nigna a God.” Gi a Jon ke hiia a Jisas me siuvitabua. ");
INSERT INTO bgt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kori vido a Jisas ke vulahadi kori bea, na maaloa ke hangavi mi manea ke reghia na Tarunga ke Tabu nigna a God ke horu mai vaghagna na bora me togha itagna. ");
INSERT INTO bgt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma na ohai haghore ke haghore mai i popo me ania, “Iaani a pukuni dathegu. Inau ku dothovia mu totogo puala eigna.” ");
INSERT INTO bgt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ma na Tarunga ke Tabu ke batu vanoa a Jisas kori meleha ke gou eigna a Satan keda auaua. ");
INSERT INTO bgt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jisas ke boi vanga e rua tutughu na dani ma na bongi me rofo nigna puala. ");
INSERT INTO bgt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kori vido iangeni a Satan ke mai tagna a Jisas me auaua, “Gi keda tutuni ighoe pukuni Dathegna a God, o haghore vanira na komi ghahira iraani eigna kedana vuhai bred.” ");
INSERT INTO bgt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A Jisas ke haghore tughua, “Na komi Rioriso ke Tabu kena velea na komi tinoni kena boi havi kori bred vamua, keana tagna mua na komi haghoregna a God.” ");
INSERT INTO bgt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","A Satan ke talangia Jisas me vano i Jerusalem, na meleha kena kiloagna na meleha ke tabu. Imanea ke veleagna a Jisas eigna keda sokara kori vido ke hadi puala popogna na Vathe ke Tabu nigna a God. ");
INSERT INTO bgt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Gi a Satan ke veleagna, “Gi ighoe a Dathegna a God, o sogala horu. Eigna na komi Rioriso ke Tabu kena velea, ‘God keda velera nigna na komi enjel eigna kedana reireghigho. Imarea kedana lakugho me teo keda kathea sa ghahira na naemu.’” ");
INSERT INTO bgt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","A Jisas ke haghore tughua, “Na komi Rioriso ke Tabu kena velea mua, ‘Saghoi eia sa fata bali huruagna a Lod na nimiu God eigna keda eia vanighamu na hava ke taluhaghorea.’” ");
INSERT INTO bgt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Gi a Satan ke talangi vanoa a Jisas kori suasupa ke hadi puala me tuhua vania na komi meleha hutu koragna na maramagna ma na komi fata ke toke ikoradia. ");
INSERT INTO bgt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Imanea ke veleagna a Jisas, “Na komi fata gougovu ko reghia irangeni kuda hegho atu gi koda pogho horu itagua mo maimanihihiu.” ");
INSERT INTO bgt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","A Jisas ke haghore tughua, “O taveti saniu Satan! Eigna na komi Rioriso ke Tabu kena velea, ‘A Lod na nimiu a God vamua kotida maimanihihia moti agutu vania.’” ");
INSERT INTO bgt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Leghugna iangeni, a Satan ke taveti sania a Jisas. Ma na komi enjel kena mai mena hathea. ");
INSERT INTO bgt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kori vido a Jisas ke rongovia na rorongogna a Jon Siuvitabu kena boa haghea kori vathe tatari, imanea ke tabiru vano kori provins i Galili. ");
INSERT INTO bgt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Imanea ke boi mono i Nasaret, kari e vano me mono i Kapaneam, na meleha kori ghaghireigna na kolo i Galili, kori vido thepa ke mono na vikedia a Jebulun ma Naftali. ");
INSERT INTO bgt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","A Jisas ke eia iaani eigna keda tutuni na haghoregna a profet Aisaia, ");
INSERT INTO bgt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sethe na tinoni kena boi Jiu kena mono i Galili, tagna na vido thepa kena kiloagna rodia na thepa a Jebulun ma Naftali, ghaghireigna na kolo hutu i Galili sethevugna na bea hutu i Jodan. ");
INSERT INTO bgt_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Na komi tinoni iraani kena mono kori puni, imarea kedana reghia na laema ke raraha puala. Na laema keda raraha itadia arahai kena mono saragna na managna na thehe.” ");
INSERT INTO bgt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kori vido iangeni a Jisas ke turughua na velepuhiragna na komi tinoni. Imanea ke velera, “Oti tughua na havimiu ke koakoa, eigna na maghavu a God keda vunaghi pungusia nigna na mavitu ke gharani mai ghohi!” ");
INSERT INTO bgt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sina dani a Jisas ke taetaveti kori ghaghireigna na kolo i Galili me reghira romara tamatahi a Saimon, kati kiloagna a Pita, ma Andru. Romara koro ugura kori rodia na jau eigna romara na mane ugura. ");
INSERT INTO bgt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas ke velera, “Romara, oro mai leghuu. Ikeagaieni roghamu koro ugura fei, kari inau kuda velepuhighamu na hatiagna mai na komi tinoni tagna God.” ");
INSERT INTO bgt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Romara koro saisami talu horua rodia na komi jau, gi oro leghua imanea. ");
INSERT INTO bgt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jisas ke ghoi taveti vano me reghira romara tamatahi, a Jemes ma Jon, e rua dathegna a Jebedi. Romara koro mono kori boti duagna a tamadia mena ghaura nidia na komi jau. A Jisas ke kilora eigna koroda leghua. ");
INSERT INTO bgt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Romara koro saisami taveti sania na boti ma tamadia a Jebedi, moro leghua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","A Jisas ke vano itadia na komi meleha kori provins i Galili me velepuhi tadia na komi vathe haidu nidia mara Jiu. Imanea ke titionoa na Rorongo ke Toke eigna na puhi a God ke vunaghi pungusira nigna na komi tinoni, me vatoke tabirura na komi tinoni tadia na komi thagi vahaghi ke padara. ");
INSERT INTO bgt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na rorongogna a Jisas ke rongoragha ivei mi vei me jufu kori provins i Siria. Na vunegna iangeni, na komi tinoni kena hatira mai tagna a Jisas arahai kena vahaghi. Sethe na thagi vahaghi ke padara mena papara. Kekeha, na komi tidatho ke haghevira, kekeha kena sikili hahali eigna ke kakai na tonodia, mi kekeha ke thehe na naedia ba na limadia. Ma Jisas ke vatoke tabirura gougovu. ");
INSERT INTO bgt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na mavitu ke sethe kena leghua a Jisas. Kekeha itadia kena mai kori provins i Galili, kekeha kena mai i Jerusalem ma na komi meleha kori provins i Jiudea, kekeha kena mai kori nohigna i Dekapolis mi kekeha meleha sethevugna na bea hutu i Jodan. ");
INSERT INTO bgt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","A Jisas ke reghira na mavitu ke sethe kena leghua me vano hadi kori suasupa me nohe horu. Nigna na komi vaovarongo kena hathatano mai itagna, ");
INSERT INTO bgt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma Jisas ke turughu na velepuhiragna me anira, ");
INSERT INTO bgt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“A God keda vatokera arahai kena kuma kena vaututunia imanea vamua keda hathera hahali. Imarea kedana mono kori hughuta i popo. ");
INSERT INTO bgt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","A God keda vatokera arahai kena dikahehe. Imanea keda sulara. ");
INSERT INTO bgt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","A God keda vatokera arahai kena mono taluleghu. Imanea keda hera na komi fata ke taluhaghorea vanira ghohi. ");
INSERT INTO bgt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","A God keda vatokera arahai kena pukuni magnahaghinia na leghuagna nigna na vanohehe. Imanea keda hathera eigna kedana eia iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","A God keda vatokera arahai kena rarovira na komi tinoni. Imanea keda rarovira. ");
INSERT INTO bgt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","A God keda vatokera arahai kena pukuni jino kori havidia. Imarea kedana reghia a God. ");
INSERT INTO bgt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","A God keda vatokera arahai kena hathera na komi tinoni eigna kedana mono kori soleana. Imanea keda kilora ara dathegna. ");
INSERT INTO bgt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","A God keda vatokera arahai kena papara eigna kena eia na hava ke jino kori matagna a God. Imarea kedana mono kori hughuta i popo. ");
INSERT INTO bgt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“A God keda vatokeghamu kori vido na komi tinoni kena haghore diadikalaghamu mena vaparaghamu mena velea na komi piapilau eimiu ghamu eigna koti leghuu inau. ");
INSERT INTO bgt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Oti totogo moti lealea kori vido kena eia na komi fata iraani itamiu, eigna a God keda heghamu na taba hutu puala kori vido kotida hadi i popo. Oti saghoi havaghinia na komi tinoni kena eia mua na komi fata ke dika irangeni tadia na komi profet i hau. ");
INSERT INTO bgt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Sol na fata ke toke puala. Ighamu hiri na sol eidia na mavitu kori maramagna. Keana gi keda beabeagha na sol, boi tangomana nidia kedana ghoi vaaha. Na sol iangeni kedana soni aua vamua kori hangana ma na komi tinoni kedana tapalia. ");
INSERT INTO bgt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ighamu hiri vaghagna na lui vanira na komi tinoni kori maramagna. Na komi tinoni kena boi tangomana kedana poloa na meleha kena agutua kori suasupa. ");
INSERT INTO bgt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Me teo ahai keda totha na lui me boa saragna na nahu! Keana imanea keda savera hadia tagna na bali sasaveragna eigna kedana dodoro toetoke na komi tinoni koragna na vathe. ");
INSERT INTO bgt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Vaghagna iangeni mua, oti saghoi polora tadia na komi tinoni na komi tango ke toke koti eia. Keana kotida tatelira au eigna kedana reghira mena kilothaba a Tamamiu i popo. ");
INSERT INTO bgt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Oti saghoi toatogha inau ku mai bali sonira au na komi vetula nigna a Moses ba na komi velepuhi nidia mara na profet. U boi mai eigna kuda sonira au, keana eigna kuda tateli aua na pukuni ghaghana ikoradia. ");
INSERT INTO bgt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Inau ku veleghamu, na komi fata gougovu tadia na komi vetula nigna a Moses keda talu mono me ghieghilei govu na maaloa ma na thepa. Na komi fata gougovu a God ke velea keda mono mai tutuni. ");
INSERT INTO bgt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ahai keda boi leghua sa vetula tadia na komi vetula, me velepuhira arahai tavogha eigna kedana eia iangeni, imanea keda boi nagho tadia na komi tinoni a God ke vunaghi pungusira. Keana ahai keda leghua na komi vetula me velepuhira arahai tavogha eigna kedana leghura, imanea keda haluhadi vano tadia na komi tinoni a God ke vunaghi pungusira. ");
INSERT INTO bgt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Inau ku veleghamu, gi na puhimiu keda boi toke vano tagna na puhidia mara na Farise mi mara na velepuhigna na vetula nigna a Moses, teo kotida mono duadia na komi tinoni a God ke vunaghi pungusira. ");
INSERT INTO bgt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ighamu koti rongovia ghohi na vetula nigna a Moses ke velea, ‘Saghoi vathehea na tinoni. Ahai keda vathehea na tinoni, imarea kedana fatea.’ ");
INSERT INTO bgt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Keana inau ku veleghamu, ahai keda dikatagna tagna sa tinoni, a God keda fatea. Ahai keda vele houhorua sa tinoni, imarea kedana hati vanoa tadia mara na Kansol eigna kedana fatea. Ma ahai keda haghore leghua sa tinoni, e naba a God keda vapara imanea tagna na joto kori meleha papara. ");
INSERT INTO bgt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Na vunegna iangeni, gi koda hati maia nimua na sosoni bali hea a God, keana o togha sina tinoni ke dikatagna itamua, ");
INSERT INTO bgt_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","o talu horua nimua na sosoni hilighagna na olta. Mo vano tagna na tinoni iangeni mo vajinoa na fata ke hahi varihotaghimiu. Gi o ghoi tabiru mai mo hea a God nimua na sosoni. ");
INSERT INTO bgt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Gi nimua na thevuioka ke magnahaghinia keda hatigho kori vido bali fate, o saisami vano itagna mo vajinoa eigna koroda mono kori soleana gi oro vano kori vido bali fate. Gi koda boi eia iangeni, imanea keda lubatigho vano tagna na mane bali fate. Ma na mane bali fate keda lubatigho vano tadia mara na pulis eigna kedana sonigho haghe kori vathe tatari. ");
INSERT INTO bgt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na hava ku velegho ikeagaieni e tutuni, teo koda mamaluha mo ghieghilei voli huia engiha na rongo kena velegho koda volia. ");
INSERT INTO bgt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ighamu koti rongovia ghohi na vetula nigna a Moses ke velea, ‘Saghoi ghoho.’ ");
INSERT INTO bgt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Keana inau ku veleghamu, ahai ke reghia na vaivine me mamagna, imanea ke ghoho ghohi kori ghaghanagna. ");
INSERT INTO bgt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na vunegna iangeni, gi na mata madothomu ke batugho kori koakoa, o sipa aua mo sonia. Na soniagna sina vidoi tonomu e toke vano tagna na tonomu doudolu keda vano kori meleha papara. ");
INSERT INTO bgt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Gi na lima madothomu ke batugho kori koakoa, o utuhia aua mo sonia. Na soniagna sina vidoi tonomu e toke vano tagna na tonomu doudolu keda vano kori meleha papara. ");
INSERT INTO bgt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ighamu koti rongovia ghohi na vetula nigna na Moses ke velea, ‘Ahai keda sonia a taugna, imanea keda hea iia na pepa veisonighi.’ ");
INSERT INTO bgt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Keana inau ku veleghamu, ahai keda sonia a taugna, kari iia ke boi ghohoa, imanea ke batua iia eigna keda ghoho kori vido iia keda ghoi taulaghi tagna na mane tavogha. Ma na mane keda taulaghi tagna na vaivine iangeni, imanea hiri ke ghoho mua kori matagna a God. ");
INSERT INTO bgt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mi ghamu koti rongovia ghohi na vetula nigna a Moses ke velea, ‘O saghoi havaghinia na eiagna na hava ko taluhaghorea, mo eia vamua na hava ko taluhaghorea tagna a Lod.’ ");
INSERT INTO bgt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Keana inau ku veleghamu, kori vido koti eia na taluhaghore, saghoi jijighi tagna sa fata. Saghoi jijighi tagna na hughuta i popo, eigna a God ke mono kori hughuta i popo. ");
INSERT INTO bgt_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Saghoi jijighi tagna na thepa, eigna a God ke vunaghi pungusira na komi fata gougovu i thepa. Saghoi jijighi tagna i Jerusalem, eigna na meleha iangeni na meleha nigna a God, na king ke haluhadi puala. ");
INSERT INTO bgt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Moti saghoi jijighi vaghagna iaani, ‘Gi kuda boi eia na hava ku taluhaghorea, na sesehugu keda ufa.’ Eigna boi tangomana nimiu kotida vapura ba vajongoa sikei sesehumiu. ");
INSERT INTO bgt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Gi kotida taluhaghorea sa fata, oti velea hii ba teo vamua kari govu. Gi koti jijighi tagna sa fata, iangeni ke mai tagna a Satan. ");
INSERT INTO bgt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ighamu koti rongovia ghohi na vetula nigna a Moses ke velea, ‘Gi ahai keda vangesoa na matagna sa tinoni, oti vangesoa na matagna na tinoni iangeni. Ahai keda tupi kavuvua na keigna sa tinoni, oti tupi kavuvua na keigna na tinoni iangeni.’ ");
INSERT INTO bgt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Keana inau ku veleghamu, saghoi tughu tabirua vania ahai ke eia vanighamu na dika. Gi ahai keda tapoa na bako madothomu, o lubati vania na bako toimu eigna keda tapoa mua. ");
INSERT INTO bgt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Gi ahai keda hatigho tagna na mane bali fate me kaea nimua na poko tono bali tughua na hava ko eia, o hea vano mua nimua na oopo. ");
INSERT INTO bgt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Gi sina soldia keda vele huhurugho eigna koda hulungia nigna na ngoi sina kilomita, o hulunia vania mua e rua na kilomita. ");
INSERT INTO bgt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kori vido sa tinoni keda kaea sa fata itamua, o hea vamua. Gi ahai keda kaea sa nimua na fata me velea keda mai boa tabirua, o lubati vania. ");
INSERT INTO bgt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ighamu koti rongovia ghohi na vetula nigna a Moses ke velea, ‘O dothovira ara kulamu, mo siriuhaghinira nimua na thevuioka.’ ");
INSERT INTO bgt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Keana inau ku veleghamu, oti dothovira nimiu na thevuioka, moti tarai eidia arahai kena vaparaghamu. ");
INSERT INTO bgt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Gi kotida eia iangeni, ighamu kotida pukuni ara dathegna a Tamamiu ke mono i popo. Eigna imanea ke valaema na aho popodia na komi tinoni kena dika mi popodia na komi tinoni kena toke. Vaghagna mua, imanea ke vetula na uha tadia na komi tinoni koakoa mi tadia na komi tinoni kena jino. ");
INSERT INTO bgt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Gi kotida dothovira vamua arahai kena dothovighamu, a God teo keda heghamu na taba. Eigna, toke mara bali oho takis kena dika, imarea kena dothovira arahai kena dothovira. ");
INSERT INTO bgt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Gi kotida haghore toke tadia ara kulamiu vamua, ighamu koti boi tavogha tadia arahai tavogha. Eigna, toke na komi tinoni bongihehe kena boi leghua a God, imarea kena haghore toke tadia ara kuladia. ");
INSERT INTO bgt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Oti ei hahalia na komi fata ke jino vaghagna vamua a Tamamiu i popo ke ei hahalia na komi fata ke jino.” ");
INSERT INTO bgt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","A Jisas ke ghoi velea, “Oti reireghi toke ghamu. Kori vido koti eia na komi tango ke toke, oti saghoi eia eigna kedana reghighamu mena veletokeghamu na komi tinoni. Gi kotida eia vaghagna iangeni, a Tamamiu i popo keda boi heghamu na taba. ");
INSERT INTO bgt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Na vunegna iangeni, kori vido ko hea sa fata tagna na tinoni kuma, o saghoi titionoa tadia na mavitu. Iangeni na puhi kena eia arahai kena eia vaghagna kena jino kari ena boi jino. Imarea kena eia na puhi ke dika iangeni tadia na komi vathe haidu mi tadia na komi hangana eigna na mavitu kedana haghore tokera. Inau ku veleghamu, a God keda boi hera sa fata. Na tabadia, na haghore veletokeragna vamua. ");
INSERT INTO bgt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kori vido ko hea sa fata tagna na tinoni kuma, o saghoi titionoa. ");
INSERT INTO bgt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","E toke keda boi adoa sa tinoni na hava ko eia. Gi koda eia iangeni, a Tamamu i popo ke reghia na hava ko ei poloa, imanea keda hegho na taba. ");
INSERT INTO bgt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Saghoi tarai vaghadia arahai kena eia vaghagna kena jino kari ena boi jino. Kori vido kena tarai, imarea kena magnahaghinia kedana sokara kori vathe haidu ba kori na hangana hutu eigna na mavitu kedana reghira mena haghore veletokera. Inau ku veleghamu, a God keda boi hera sa fata. Na tabadia na haghore veletokeragna vamua. ");
INSERT INTO bgt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kori vido ko tarai, o vano haghe kori nimua na chogho mo bilakia na hagetha mo tarai tagna a Tamamu. Imanea, teo ahai ke tangomana na reghiagna. Gi koda eia iangeni, a Tamamu i popo ke reghia na hava ko ei poloa, imanea keda hegho na taba. ");
INSERT INTO bgt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Saghoi tarai vaghadia na komi tinoni bongihehe. Imarea kena ei hahalia na komi tarai ke nanaba vamua mena boi togha na hava kena velea. Imarea kena ghaghana nidia na komi ghod kedana rongovira eigna na komi haghore ke sethe kena eira. ");
INSERT INTO bgt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Saghoi tarai vaghadia imarea, eigna a Tamamiu ke adoa ghohi na hava koti magnahaghinia gi oto kaea itagna. ");
INSERT INTO bgt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kori vido koti tarai, oti tarai vaghagna iaani: ‘A Tamamami i popo, o hatheghami eigna kitida ghaghana bohea na ahamu. ");
INSERT INTO bgt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","O mai mo vunaghi pungusira na komi tinoni gougovu eigna kedana leghua nimua na vanohehe kori maramagna vaghagna arahai kena mono i popo kena leghua nimua na vanohehe. ");
INSERT INTO bgt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Heghami mai ghamami na vanga ke nabamami leuleghu maghavu. ");
INSERT INTO bgt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Talutavogha na komi paluhamami vaghagna ighami kiti talutavogha na komi paluhadia arahai kena eia na dika itamami. ");
INSERT INTO bgt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Saghoi lubatia na auau keda mai itamami. Kari sokara pungusighami kori mana nigna a Satan.’ ");
INSERT INTO bgt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Gi kotida talutavogha na paluhadia na komi tinoni kena eia na dika itamiu, a Tamamiu i popo keda talutavogha na komi paluhamiu. ");
INSERT INTO bgt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Keana gi kotida boi talutavogha na paluhadia na komi tinoni kena eia na dika itamiu, a Tamamiu keda boi talutavogha na komi paluhamiu. ");
INSERT INTO bgt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kori vido koti sota kori vanga, oti saghoi eia vaghagna koti dikahehe vaghadia kena eia arahai kena eia vaghagna kena jino kari ena boi jino. Imarea kena vadiadikala na dodorodia eigna na komi tinoni kedana adoa kena sota mena haghore veletokera. Inau ku veleghamu, a God keda boi hera sa fata. Na tabadia, na haghore veletokeragna vamua. ");
INSERT INTO bgt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kori vido ko sota, o siusiu toetoke mo katha na sesehumu ");
INSERT INTO bgt_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","eigna keda boi adoa sa tinoni ighoe ko sota. Keana a Tamamu keda adoa ighoe ko sota. Imanea, teo ahai ke tangomana na reghiagna. Ma Tamamu ke reghia na hava ko ei poloa, imanea keda hegho na taba. ");
INSERT INTO bgt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Oti saghoi togha vamua na kalitiragna na komi fata ke toke kori maramagna. Eigna na komi kokorosi ma na vevegha keda vadiadikalara, mi mara na bilau kedana haghe kori vathe bali bilaura. ");
INSERT INTO bgt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Keana oti eia na hava ke magnahaghinia a God, eigna iangeni ke vaghaghagna koti kalitira na komi fata ke toke i popo. Mi manea keda heghamu na taba i popo. Ingengeni na komi kokorosi ma na vevegha keda boi vadiadikalara, mi mara bilau kedana boi haghe kori vathe bali bilaura. ");
INSERT INTO bgt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Oti eia vaghagna iaani eigna na hehemiu keda leghua na hava ke nagho vano itamiu. ");
INSERT INTO bgt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Na matamu ke vaghagna na lui bali batugho. Gi keda toke na matamu, ighoe keda vonungigho na raraha. ");
INSERT INTO bgt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kari gi keda dika na matamu, ighoe keda vonungigho na puni. Gi ighoe ko ghaghana ko mono kori raraha, kari o mono kori puni, ighoe ko pukuni mono kori puni.” ");
INSERT INTO bgt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Boi tangomana ahai keda agutu vanira e rua na vunaghi. Eigna imanea keda thevuioka tagna sikei me dothovia sikei. Ba imanea keda ghaghana bohea sikei me boi ghaghana bohea na varuagna. Vaghagna iangeni, boi tangomana kotida dothovia a God ma na rongo.” ");
INSERT INTO bgt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Gi kotida magnahaghinia na leghuagna vamua a God, e boi toke keda horuhaihadi na ghaghanamiu eigna na hava kotida ghania ba kouvia ba na hava kotida pokoagna na tonomiu. Eigna na havimiu ke nagho vano tagna na vanga ma na poko. ");
INSERT INTO bgt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Oti reghira vano na komi manu. Ena boi joua mena boi ghelia sa vanga. E teo sa nidia na vathe bali boa sa vanga, kari a Tamamiu ke mono i popo ke hera ghadia. Tagna a God ighamu koti nagho vano tadia na komi manu. ");
INSERT INTO bgt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Toke keda horuhaihadi na ghaghanamiu eigna na komi fata kori havimiu, ighamu boi tangomana nimiu na vateveagna na havimiu. ");
INSERT INTO bgt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ehava gi e horuhaihadi na ghaghanamiu eigna na komi pohe bali pipisimiu? Oti reghira vano na komi falaoa. Imarea kena boi agutu mena boi sukia sa pohedia. ");
INSERT INTO bgt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kari inau ku veleghamu, toke a King Solomon ke padarongo, e teo sa nigna na pohe ke ulaghagna vano tadia na komi falaoa. ");
INSERT INTO bgt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God ke vatokea na dodorodia na komi falaoa kena mono vamua sina ghathi vido iso, gi ena sonira vano kori joto. Gi keda eia iangeni, ighita kati adoa imanea keda heghita na poheda. Nimiu na vaututuni ke lae puala! ");
INSERT INTO bgt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Saghoi lubatia na ghaghanamiu keda horuhaihadi eigna na hava kotida ghania ba na hava kotida kouvia ba na hava kotida pokoagna na tonomiu. Saghoi toatogha hahalia na komi fata iraani. ");
INSERT INTO bgt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Arahai kena boi adoa a God, na ghaghanadia ke horuhaihadi eigna na komi fata iraani. Oti saghoi eia vaghagna iaani, eigna a Tamamiu ke adoa ghohi na komi fata koti magnahaghinia. ");
INSERT INTO bgt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Gi kotida pukuni magnahaghinia a God keda vunaghi pungusighamu moti mono kori puhi ke jino, a God keda heghamu na komi fata iraani ke nabamiu. ");
INSERT INTO bgt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Boi toke keda horuhaihadi na ghaghanamiu eigna ivughei. Eigna ivughei a God keda heghamu na hava ke nabamiu. Leuleghu dani oti togha vamua na komi fata vathotha ke padaghamu kori dani iangeni.” ");
INSERT INTO bgt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","A Jisas ke ghoi velea, “Saghoi fatera hahali arahai tavogha eigna keda boi fategho a God. ");
INSERT INTO bgt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","God keda fategho leghuagna na puhi ko fatea na tinoni tavogha. Gi koda rarovia ahai kori vido ko fatea, a God keda rarovigho kori vido ke fategho. Keana gi koda boi rarovia, a God keda boi rarovigho mua. ");
INSERT INTO bgt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ehava gi o haga hati aua na saosaghoma ke iso teoteoa kori matagna a kulamu, keana ighoe ko boi hati aua na tabala kori matamu? ");
INSERT INTO bgt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","E boi toke gi koda veleagna a kulamu, ‘O mai eigna kuda hati aua na saosaghoma kori matamu,’ kori vido ke mono mua na tabala kori matamu. ");
INSERT INTO bgt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ighoe na tinoni piapilau. O kidi hati aua na tabala kori matamu eigna koda dodoro toetoke, gi o hati aua na saosaghoma kori matagna a kulamu. ");
INSERT INTO bgt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Saghoi hea na hava ke tabu tadia na komi aku, eigna kenughua ena rihugho vamua. Mo saghoi hea na komi kidorugna na sie ke vathotha puala na volidia tadia na komi botho, eigna kenughua ena tapalira vamua. ");
INSERT INTO bgt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Oti kaea a God eidia na komi fata koti magnahaghinia, ma God keda heghamu na komi fata irangeni. Oti hiroa na komi fata koti magnahaghinia, ma God keda hatheghamu eigna kotida pada. Oti jaejathe kori hagetha ma a God keda hangavia vanighamu. ");
INSERT INTO bgt_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Eigna ahai keda kaea na hava tagna a God, imanea keda hea. Ma ahai keda mai hiroa sa fata tagna a God, imanea keda pada. Ma ahai keda jaejathe, a God keda hangavia vania na hagetha. ");
INSERT INTO bgt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ahai itamiu ghamu keda hea na ghahira a dathegna kori vido ke kaea na bred na? ");
INSERT INTO bgt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ba imanea keda hea na poli kori vido a dathegna ke kaea na igha? Teo! ");
INSERT INTO bgt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ighamu na komi tinoni koakoa, keana ighamu koti adoa na hava ke toke kotida hera ara dathemiu. Na vunegna a Tamamiu i popo ke pukuni toke, ighamu koti adoa imanea keda hera na fata sethe ke toke tadia arahai kedana kaea. ");
INSERT INTO bgt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Na komi fata koti magnahaghinira na komi tinoni kedana eia vanighamu, iangeni hiri ighamu kotida eia vanira. Eigna iaani na ghaghana ikoragna na komi vetula nigna a Moses ma na komi velepuhi nidia mara na profet. ");
INSERT INTO bgt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Oti haghe kori hughuta nigna a God kori hagetha ke kapocho. Eigna na hagethagna na meleha papara ke aba ma na hangana ke vano ngengeni ke malumu na leghuagna. Me sethe na tinoni kena leghua na hangana iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Keana na hagethagna na havi ke teo na govugna ke kapocho ma na hangana ke vano itagna ke vahotha na leghuagna. Me boi rae sethe na tinoni kena leghua na hangana iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Reireghi toke ghamu tadia mara na velepuhi piapilau. Kori vido kena mai itamiu, na dodorodia ke vaghadia na komi sip ke dotho. Keana kori ghaghanadia imarea kena vaghadia na komi aku ke asi mena magnahaghinia na diadikalaghamugna. ");
INSERT INTO bgt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ighamu kotida reghi vaughithathara tagna na puhidia vaghagna vamua ighamu koti reghi ghithathara na komi ghai tagna na sagharodia. Teo ahai keda hatia na sagharo ke toke kori ghai ke lulumu. ");
INSERT INTO bgt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eigna na sagharogna na ghai ke toke keda toke, ma na sagharogna na ghai ke dika keda dika. ");
INSERT INTO bgt_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Na ghai ke toke boi tangomana keda sagharoa na sagharo ke dika, ma na ghai ke dika boi tangomana keda sagharoa na sagharo ke toke. ");
INSERT INTO bgt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na komi ghai kena boi sagharoa na saghora ke toke, na mane ke tonogna keda tokara horu me sonira kori joto. ");
INSERT INTO bgt_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Vaghagna iangeni, ighamu kotida reghi vaughithathara mara na velepuhi piapilau tadia na komi puhidia ke dika. ");
INSERT INTO bgt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Boi na komi tinoni gougovu kena kilou, ‘Lod’ kedana mono kori hughuta i popo. Eigna arahai vamua kena leghua na vanohehe nigna a Tamagu i popo kedana haghe itagna. ");
INSERT INTO bgt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kori maghavui fate, sethe na tinoni kedana mai itagua mena veleu, ‘Lod, Lod, ighami kiti titiono aua na haghoregna God kori ahamu, miti gigi aura na komi tidatho kori veleagna na ahamu, miti eira na reghithehe ke sethe.’ ");
INSERT INTO bgt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mi inau kuda velera vamua, ‘Inau ku boi adoghamu. Oti taveti saniu ighamu koti ei hahalia na komi fata ke dika!’ ");
INSERT INTO bgt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ahai ke rongovia nigua na komi velepuhi me leghua, imanea ke vaghagna na mane ke thaothadogha ke vasokaraghinia na vathegna kori thepa ke ngasi. ");
INSERT INTO bgt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na uha hutu ke horu mai me biringita ma na ghuri hutu ke kathea na vathe iangeni. Keana na vathe ke boi reo eigna na mane ke agutua kori thepa ke ngasi. ");
INSERT INTO bgt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Keana ahai ke rongovia nigua na komi velepuhi me boi leghua, imanea ke vaghagna na mane ke boi thaothadogha ke vasokaraghinia na vathegna kori nahigha. ");
INSERT INTO bgt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na uha hutu ke horu mai me biringita ma na ghuri hutu ke kathea na vathe iangeni. Ma na vathe ke sikili horu me reo.” ");
INSERT INTO bgt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kori vido a Jisas ke vagovua na komi titiono iraani, na mavitu kena vere nidia puala tagna nigna na komi velepuhi. ");
INSERT INTO bgt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Imarea kena vere nidia puala eigna Jisas ke velepuhi kori mana nigna a God. Nigna na velepuhi ke boi vaghagna nidia na velepuhi mara na velepuhigna na vetula nigna a Moses. ");
INSERT INTO bgt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kori horugna mai a Jisas kori suasupa, na mavitu ke sethe kena leghua. ");
INSERT INTO bgt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Sina mane ke lepa ke mai me torongaghi tuturu horu tagna a Jisas me ania, “Lod, gi koda magnahaghinia, tangomana koda vatoke tabiruu!” ");
INSERT INTO bgt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","A Jisas ke tangolia na mane iangeni me veleagna, “Hii, inau ku magnahaghinia. O toke tabiru!” Ma na komi tubu kori tonogna ke mavo saisami. ");
INSERT INTO bgt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Leghugna iangeni a Jisas ke veleagna, “O saghoi veleagna sa tinoni na hava ku eia vanigho. Kari o vano reghia na pris eigna keda reghia na tonomu ke toke tabiru. Gi o hea na pris na fata bali havughaghi ke velea na vetula nigna a Moses eigna kedana adoa na mavitu ighoe ko toke tabiru.” ");
INSERT INTO bgt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kori jufugna mai a Jisas i Kapaneam, na vunaghigna sina boo i soldia kori ami gna i Rom ke mai itagna me kae huhurua eigna keda hathea. ");
INSERT INTO bgt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Imanea ke velea, “Lod, nigua na mane agutu ke vahaghi hutu puala. Imanea ke nere kori mathagna kori vathegu eigna ke lae na tonogna doudolu me papara puala.” ");
INSERT INTO bgt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","A Jisas ke ania, “Inau kuda mai kori vathemu mu vatoke tabirua.” ");
INSERT INTO bgt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Na vunaghi kori ami ke veleagna, “Lod, inau ku bosi naba gi koda mai haghe kori vathegu. Keana inau ku adoa, gi koda haghore vamua, nigua na mane agutu keda toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Inau ku adoa iaani eigna ke mono na vunaghigu mu leghua na hava ke veleu. Vaghagna iangeni, inau ku vunaghi pungusira nigua na komi soldia. Gi kuda velea sikei itadia, ‘Vano,’ imanea keda vano. Gi kuda velea sikei itadia, ‘Mai,’ imanea keda mai. Ma gi kuda velea nigua na mane agutu, ‘O eia na agutu iaani,’ imanea keda eia.” ");
INSERT INTO bgt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","A Jisas ke rongovia na haghore iaani me vere nigna puala. Me velera na mavitu kena leghua, “Inau ku veleghamu, inau ku boi reghia na vaututuni ke hutu vaghagna iaani tadia mara Israel gougovu. ");
INSERT INTO bgt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Sethe na tinoni kena boi Jiu tadia na komi meleha ivei mi vei kori maramagna kedana nohe mena vangahaidu duadia ara hutuda, a Ebraham, Aisak, ma Jekob kori hughuta i popo. ");
INSERT INTO bgt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","God ke kaikalitia nigna na hughuta eidia na komi tinonidia i Israel, kari sethe itadia imanea keda sonira au kori meleha ke puni. Ingengeni na komi tinoni kedana dikahehe mena tangi mena gigiri kei.” ");
INSERT INTO bgt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Gi a Jisas ke veleagna na vunaghi kori ami, “O tabiru vano kori vathemu. Nimua na mane agutu keda toke tabiru vaghagna vamua ko vaututunia.” Mi kori vido iangeni vamua, nigna na mane agutu ke ghoi toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas ke vano haghe kori vathegna a Pita, me reghipada a vungaogna vaivine ke koli kori mathagna eigna ke vahaghi me vuvughu puala na tonogna. ");
INSERT INTO bgt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Imanea ke tangolia na limagna ma na vahaghi ke govu itagna. Gi iia ke sokara hadi me kaikaliti vanga ghagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kori lavigna na dani iangeni, na mavitudia i Kapaneam kena hatira mai tagna Jisas na komi tinoni sethe ke haghevira na komi tidatho. A Jisas ke haghore vanira na komi tidatho mena taveti au itadia. Mi manea ke vatoke tabirura na komi tinoni gougovu kena vahaghi. ");
INSERT INTO bgt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Imanea ke eia na komi fata iraani eigna keda tutuni na hava a profet Aisaia ke velea i hau, “Imanea ke vamamaluhaghita tadia na komi vahaghi ke padaghita.” ");
INSERT INTO bgt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kori vido a Jisas ke reghira na mavitu ke sethe kena haidu kililivia, imanea ke velera nigna na komi vaovarongo, “Atu mati hathavu sethevugna na kolo.” ");
INSERT INTO bgt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kori vido iangeni sina mane velepuhigna na vetula nigna a Moses ke mai itagna Jisas me ania, “Velepuhi, kenughua inau kuda leghugho tadia na komi meleha gougovu koda vano.” ");
INSERT INTO bgt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","A Jisas ke haghore tughua, “Na komi aku asi, e mono na vido bali eghodia ma na komi manu na gneku bali monodia. Kari inau, na Dathei Tinoni, e teo sa nigua na vathe bali nere nigua.” ");
INSERT INTO bgt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sikei tadia na komi tinoni kena leghua a Jisas ke velea, “Lod, o kidi lubatiu eigna kuda vano gilua a tamagu.” ");
INSERT INTO bgt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A Jisas ke ania, “O lubatira arahai kena thehe eigna kedana gilura arahai itadia kena thehe. O mai mo leghuu!” ");
INSERT INTO bgt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Leghugna iangeni, a Jisas ke saki haghe kori boti mi mara nigna na komi vaovarongo kena vano duagna. Imarea kena turughu na hathavu vano sethevugna na kolo. ");
INSERT INTO bgt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma na ghuri hutu ke padara me maghavu puala. Ma na geo ke turughu haghe kori boti. Keana a Jisas ke nere. ");
INSERT INTO bgt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mara nigna na komi vaovarongo kena vano raraia mena veleagna, “Lod, o vahavighita! Ighita katida luvu mati bilomo!” ");
INSERT INTO bgt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ma Jisas ke veleragna, “Nimiu na vaututuni ke lae puala! Eigna na hava koti mataghu na?” Gi imanea ke sokara hadi me haghore heta vanira na ghuri ma na geo. Kori vido iangeni, na ghuri ke soto ma na kolo ke sola. ");
INSERT INTO bgt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nigna na komi vaovarongo kena vere nidia puala mena veihuahuatighi, “Na tinoni hava hina iaani? Imanea ke haghore vanira na ghuri ma na geo mena leghua na haghoregna!” ");
INSERT INTO bgt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","A Jisas duagna nigna na komi vaovarongo kena torongaghi sethevugna na kolo kori meleha kena kiloagna Gadara. E rua na mane ke haghevira na komi tidatho koro mai tagna a Jisas. Romara koro au mai tadia na komi luma ke mono na komi beku koradia. Teo sikei tinoni keda halu vano kori hangana iangeni eigna romara koro mee moro magnahaghinia na rihuragna na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Romara koro reghia a Jisa moro ghuu vano vaghagna iaani, “Jisas, Dathegna a God, na hava koda eia vanighami? O mai eeni eigna koda vaparaghami gi e jufu mai na dani a God ke boa bali fateghami?” ");
INSERT INTO bgt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gharania na vido imarea kena mono, sethe na botho kena huehume. ");
INSERT INTO bgt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na komi tidatho irangeni kena kae huhurua a Jisas, “Gi koda gigi aughami, o lubatighami eigna kitida vano haghe nimami tadia na komi botho.” ");
INSERT INTO bgt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma Jisas ke velera, “Oti vano itadia!” Ma na komi tidatho kena taveti au mena vano haghe tadia na komi botho. Gi na komi botho kena raghe horu leghua na suasupa mena raghe sapa kori kolo mena bilomo gougovu. ");
INSERT INTO bgt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mara kena reireghi botho kena ghogho gougovu mena vula kori melehadia, mena titionoa na hava ke padara na komi botho me rua na mane ke haghevira na komi tidatho. ");
INSERT INTO bgt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Na mavitudia na meleha iangeni kena vano tagna a Jisas mena kae huhurua eigna keda taveti sania na melehadia. ");
INSERT INTO bgt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","A Jisas duagna nigna na komi vaovarongo kena hahaghe kori boti mena hathavu sethevugna na kolo. Imarea kena torongaghi thonga i Kapaneam, na meleha ke mono a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kori torongaghidia vano ngengeni, kekeha tinoni kena hulungi maia kori matha tagna a Jisas sina tinoni ke lae na tonogna. Jisas ke adoa nidia na vaututuni ke hutu me haghore vania na mane ke lae na tonogna, “Kulagu, o saghoi mataghu. Inau ku talutavogha ghohi na komi paluhamu.” ");
INSERT INTO bgt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kekeha mara na velepuhigna na vetula nigna a Moses kena rongovia iaani mena ghaghana, “E boi toke na haghore ke velea. Imanea ke vananaba ghehegna duagna a God!” ");
INSERT INTO bgt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","A Jisas ke adoa na ghaghanadia me anira, “Eigna na hava gi oti toatogha na fata ke dika iangeni kori ghaghanamiu? ");
INSERT INTO bgt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gi kuda haghore vania na mane ke lae na tonogna vaghagna iaani, ‘Inau ku talutavogha na paluhamu,’ ighamu kotida boi adoa na paluhagna ke talutavogha ba teo. Kari gi kuda haghore vania vaghagna iaani, ‘Sokara hadi mo taveti,’ ighamu kotida reghia inau ke mono nigua na mana bali vatokeagna imanea ba teo. ");
INSERT INTO bgt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kori vido kuda vatokea na mane iaani, ighamu kotida adoa, inau, na Dathei Tinoni, ke mono nigua na mana bali talutavogha na komi paluha.” Govu, gi e veleagna na mane ke lae na tonogna, “O sokara hadi mo hatia na mathamu mo tabiru kori vathemu!” ");
INSERT INTO bgt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ma na mane iangeni ke sokara hadi me tabiru kori vathegna. ");
INSERT INTO bgt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Na mavitu kena reghia iaani mena vere nidia puala. Imarea kena veletokea God eigna ke hea na mana ke hutu iangeni tagna na tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kori vido a Jisas ke taveti sania na vido iangeni, imanea ke reghia sina mane bali oho takis, na ahagna a Matiu. Imanea ke nohe kori vido bali voli takis. A Jisas ke veleagna, “O mai mo leghuu inau.” A Matiu ke sokara hadi me leghua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Leghugna iaani, a Jisas duagna nigna na komi vaovarongo kena vano vanga kori vathegna a Matiu. Imanea ke hulaghinira mua sethe na tinoni koakoa. Kekeha mara bali oho takis kena mono duadia. ");
INSERT INTO bgt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mara na Farise kena reghia iaani mena huatira nigna na komi vaovarongo a Jisas, “Ehava gi nimiu na mane velepuhi ke vanga duadia mara bali oho takis ma arahai tavogha kena dika?” ");
INSERT INTO bgt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","A Jisas ke rongovia na haghore iangeni me velea, “Arahai kena boi vahaghi kena boi magnahaghinia kedana vano reghia na dokta, kari arahai vamua kena vahaghi. ");
INSERT INTO bgt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Vaghagna iaani, inau ku bosi mai bali kilora arahai kena jino kori ghaghanadia ghehedia bali leghuu inau, kari arahai vamua kena adoa kena koakoa. Oti hiro au toetoke na ghaghanagna na rioriso ke mono tadia na komi Rioriso ke Tabu kena velea, ‘Gi ighamu kotida boi havughaghi itagua, e toke vamua. Na fata ku pukuni magnahaghinighamu kotida eia, na raroviragna arahai tavogha.’” ");
INSERT INTO bgt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kekeha nigna na vaovarong a Jon Siuvitabu kena mai tagna a Jisas mena huatia, “Ighami, mi mara na Farise kiti ado sota kori vanga, keana ehava gi ena boi sota nimua na komi vaovarongo eni?” ");
INSERT INTO bgt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A Jisas ke haghore tughura, “Ehava? Ighamu koti ghaghana na mavitu kena mono kori vangahaidugna na taulaghi kedana dikahehedia kori vido na mane taulaghi ke mono duadia? Teo. Keana kori vido kekeha tinoni kedana mai hati aua na mane taulaghi itadia ara kulagna, imarea kedana sota eigna kena dikahehe. Vaghagna iangeni mua, boi tangomana kedana sota nigua na komi vaovarongo eigna inau ku mono mua duadia. ");
INSERT INTO bgt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ghita ati adoa ghohi, teo ahai itada keda hatia na vidoi pohe mathangani me suki ponotia kori pohe haulaghi ke resu ghohi. Gi katida eia vaghagna iangeni, kori vido kati vano wasia kori bea, kenughua na vidoi pohe mathangani iangeni e kakai me varesua na vidoi pohe haulaghi. Ma na resu iangeni kenughua e hutu vano tagna na resugna i hau. ");
INSERT INTO bgt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Sina fata mua iaani, ighita boi tangomana katida toia na waen mathangani kori ghuighuligna na got ke haulaghi. Eigna kori vido na waen mathangani ke vano me haulaghi, kenughua na ghuighuli haulaghi iangeni e nana me poha eigna e nana ghohi. Ma na waen keda rote au ma na ghuighuli keda dika. Mati toia na waen mathangani kori ghuighuli ke mathangani eigna na waen ma na ghuighuli koroda mono toke.” ");
INSERT INTO bgt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kori vido a Jisas ke talu titiono duadia nigna na komi vaovarongo a Jon, sina mane ke baubatu kori vathe haidu nidia mara Jiu ke mai tagna Jisas me torongaghi tuturu horu itagna me ania, “A dathegu vaivine ke eu thehe vamua. Keana o mai mo tangolia eigna keda ghoi havi tabiru.” ");
INSERT INTO bgt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","A Jisas ma na komi nigna na vaovarongo kena sokara hadi mena vano duagna. ");
INSERT INTO bgt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kori vido kena taveti vano, sina vaivine puhi ke mai leghugna Jisas. Iia ke pada na vahaghi ghaughabua kekeha vidoi maghavu koragna salaghe rua na vinogha. Iia ke tugelia na kujukugna nigna na poko, ");
INSERT INTO bgt_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","eigna iia ke ghaghana, “Gi kuda tugelia vamua na kujukugna nigna na poko, inau kuda ghoi toke tabiru.” ");
INSERT INTO bgt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisas ke vajangia me rei tabiru me reghipada na vaivine iangeni me ania, “Vaivine, o saghoi dikahehemu. Ighoe ko toke tabiru eigna nimua na vaututuni.” Kori vido vamua iangeni na vaivine ke ghoi toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kori vido a Jisas ke haghe vano kori vathegna na mane ke baubatu kori vathe haidu, imanea ke reghira na mavitu kena tangi heta mi kekeha tinoni kena ifua na sale thehe. ");
INSERT INTO bgt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","A Jisas ke velera, “Oti taveti au kori vathe. Na gari vaivine iaani e boi thehe, keana e nere nigna vamua.” Ma na mavitu kena kihaghinia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Leghugna ke vetulara au na komi tinoni i kosi, a Jisas ke haghe vano kori chogho ke mono na gari vaivine. Imanea ke tangolia na limagna mi iia ke sokara hadi. ");
INSERT INTO bgt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na rorongogna na reghithehe iaani ke rorongoragha tadia na komi meleha gharania na meleha iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Leghugna a Jisas ke taveti au ingengeni, e rua na mane koro doa koro leghua a Jisas. Romara koro ghuu heta vaghagna iaani, “Dathegna Deved, o rarovighami!” ");
INSERT INTO bgt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisas ke haghe vano tagna sina vathe mi romara koro leghua imanea. Ma Jisas ke huatira, “Ehava? Oro vaututuniu inau ku tangomana na vatoke tabiruagna na matamiu?” Romara koro velea, “Hii, Lod.” ");
INSERT INTO bgt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Gi a Jisas ke taboa na matadia me anira, “Na vunegna iroghamu koro vaututuniu, roghamu koroda toke tabiru.” ");
INSERT INTO bgt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma na matadia romara ke ghoi toke tabiru. Gi a Jisas ke haghore heta vanira, “Oro saghoi titionoa vania ahai na hava ku eia vanighamu.” ");
INSERT INTO bgt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Keana romara koro taveti au moro titionoa na rorongo eigna a Jisas vanira na komi tinoni tadia na komi meleha ke gharania na meleha iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kori vido e rua na mane koro doa koro au sania a Jisas, kekeha tinoni kena hati maia tagna Jisas sina mane ke mui eigna ke haghevia na tidatho. ");
INSERT INTO bgt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","A Jisas ke gigi aua na tidatho itagna, ma na mane iangeni ke ghoi haohaghore tabiru. Na mavitu kena mono duagna Jisas ngengeni kena vere nidia puala. Mena velea, “Ati boi reghia i hau meke mai sa fata vaghagna iaani i Israel.” ");
INSERT INTO bgt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Keana mara na Farise kena velea, “Satan, na vunaghidia na komi tidatho ke hea na mana gi e tangomana na gigi auragna na komi tidatho.” ");
INSERT INTO bgt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","A Jisas ke vano tadia na komi meleha ke iso meke hutu me velepuhira na mavitu tadia na komi vathe haidu nidia mara Jiu. Imanea ke titionoa na Rorongo ke Toke eigna na puhi a God ke vunaghi pungusira nigna na komi tinoni me vatoke tabirura na komi tinoni tadia na komi thagi vahaghi ke padara. ");
INSERT INTO bgt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kori vido a Jisas ke reghira na mavitu ke sethe kena mai itagna, imanea ke rarovira eigna kena papara kori havidia mena boi tangomana na hatheragna ghehedia. Imarea kena vaghadia na komi sip ke teo ahai ke reireghira. ");
INSERT INTO bgt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma Jisas ke velera nigna na komi vaovarongo, “Sethe na tinoni kena mono kaikaliti bali lubatia a God eigna keda vunaghi pungusira. Iangeni ke vaghagna na gnatha ke ghano mena haga ghelia. Kari e boi sethe arahai kedana ghegheli. ");
INSERT INTO bgt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Moti tarai kaea a God eigna keda vetula atua na komi tinoni sethe bali hatheghamu na hatiragna mai na komi tinoni itagna.” ");
INSERT INTO bgt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","A Jisas ke kilora mai itagna e salaghe rua nigna na vaovarongo me hera na mana eigna kedana gigi aura na komi tidatho me vatokera na komi tinoni tadia na komi thagi vahaghi ke padara. ");
INSERT INTO bgt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iraani na ahadia e salaghe rua na mane vetula: Saimon (kena kiloagna a Pita), Andru (a tahigna a Pita), Jemes (a dathegna Jebedi), Jon (a tahigna a Jemes), ");
INSERT INTO bgt_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Batolomiu, Tomas, Matiu (na mane bali oho takis), Jemes (a dathegna Alfius), Tadius, ");
INSERT INTO bgt_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon (sina mane ke magnahaghinia na gigi auragna mara i Rom eigna kedana boi vunaghi pungusira mara Jiu), ma Jiudas Iskariot (na mane ke peroa a Jisas). ");
INSERT INTO bgt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Gi e vetulara au e salaghe rua na mane iraani, Jisas ke veleragna, “Oti saghoi vano tadia na komi tinoni kena boi Jiu moti saghoi vano tadia mara i Samaria. ");
INSERT INTO bgt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Keana oti vano vamua itadia mara Israel kena vaghadia na komi sip kena taveti sania ahai ke reireghira. ");
INSERT INTO bgt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ma na rorongo kotida titionoa tadia na komi tinoni, iaani, ‘Na maghavu a God keda vanaghi pungusira nigna na komi tinoni ke gharani mai ghohi.’ ");
INSERT INTO bgt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Oti vatokera arahai kena vahaghi ma arahai kena lepa, moti vasokaraghini tabirura arahai kena thehe, moti gigi aura na komi tidatho. Na vunegna inau ku heghamu na mana eigna kotida eia na komi fata iraani, oti saghoi kaea sa rongo itadia na komi tinoni kotida hathera. ");
INSERT INTO bgt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kori vido koti taveti vano, oti saghoi hatia duamiu sa rongo, ");
INSERT INTO bgt_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ba na ngoi, ba na varuai pohe, ba na varuai sadol ba na supa. Saghoi hatia duamiu na komi fata iraani eigna e toke na tinoni agutu keda hatia nigna na komi fata tadia arahai ke hathera. ");
INSERT INTO bgt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kori vido ighamu kotida jufu tagna sina meleha, oti hiroa ahai keda sasaa na kalitighamugna. Oti mono kori vathegna moti ghieghilei taveti au kori meleha iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kori vido koti haghe vano kori vathe, oti titiono vaghagna iaani, ‘Na soleana nigna a God keda mono itamiu.’ ");
INSERT INTO bgt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Gi kedana sasaa na kalitighamugna kori vathe iangeni, a God keda hera na soleana. Keana, gi kedana boi sasaa na kalitighamugna, a God keda boi hera na soleana. ");
INSERT INTO bgt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Gi na komi tinoni tagna sina vathe ba sina meleha kedana bosi magnahaghinia na kalitighamugna ba rongovia nimiu na velepuhi, taveti sania na meleha iangeni. Kari oti rasua na thepa ke thangu kori naemiu. Iaani na vaughithatha kotida eia bali tuhu vanira a God keda vaparara. ");
INSERT INTO bgt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Inau ku veleghamu, kori maghavui fate, na hava a God keda eia vanira na komi tinonidia na meleha iangeni keda tahu vano tagna na hava keda eia vanira na komi tinoni dika eidia e rua na meleha i Sodom mi Gomora.” ");
INSERT INTO bgt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","A Jisas ke ghoi velera, “Oti reireghi toke ghamu! Eigna inau ku vetulaghamu au tadia na komi tinoni sethe kena dika. Ighamu kotida vaghadia na komi sip tadia na komi aku asi. Na vunegna iangeni, oti mono thaothadogha vaghadia na komi poli moti mono dotho itadia vaghadia na komi bora. ");
INSERT INTO bgt_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Reireghi toke ghamu eigna kekeha tinoni kedana thotighamu mena hatighamu vano kori vido bali fate. Mi marea kedana thabuhighamu kori nidia na vathe haidu. ");
INSERT INTO bgt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na vunegna ighamu koti leghuu inau, imarea kedana fateghamu naghodia na komi primia ma na komi king. Kori vido koti sokara naghodia, ighamu kotida tuturi aua na Rorongo ke Toke itadia imarea mi tadia na komi tinoni kena boi Jiu. ");
INSERT INTO bgt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kori vido kedana thotighamu bali fateghamu, saghoi lubatia na ghaghanamiu keda horuhaihadi eigna na hava kotida velea. A God keda heghamu na haghore kotida eia kori maghavu iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Na komi fata kotida velea boi na ghaghanamiu ghehemiu, keana na ghaghanagna na Tarunga nigna a Tamamiu i popo. ");
INSERT INTO bgt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sethe na tinoni kedana perora ara toghadia ba ara tahidia ba ara dathedia kori limadia mara na thevuioka bali vathehera. Vaghagna mua na komi gari kedana siriuhaghinira ara idodia mara tamadia mena perora kori limadia mara na thevuioka bali vathehera. ");
INSERT INTO bgt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na komi tinoni kedana siriuhaghinighamu eigna ighamu koti leghuu inau. Keana gi kotida sokara ngasi kori nimiu na vaututuni me jufu kori vido kotida thehe, ighamu kotida hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Gi na komi tinoni tagna sina meleha kedana vaparaghamu, oti ghogho vano tagna na meleha tavogha. Inau ku veleghamu ighamu boi tangomana kotida vagovua nimiu na komi tango tadia na komi meleha i Israel gi u tabiru mai inau, na Dathei Tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Na mane vaovarongo ke boi thaothadogha vano tagna na mane ke velepuhia, ma na mane agutu ke boi nagho vano tagna na vunaghigna. ");
INSERT INTO bgt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Na mane vaovarongo keda totogo gi keda vaghagna na mane velepuhigna, ma na mane agutu keda totogo keda vaghagna na vunaghigna. Inau ku vaghagna na vunaghigna na vathe, mi ghamu vaghadia arahai kena mono korai vathegu. Na vunegna imarea kena kilougna a Satan, imarea kedana titionoa na komi fata eimiu ghamu ke dika tuu vano tagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Oti saghoi mataghunira na komi tinoni kena thevuioka itamiu. Eigna na komi fata gougovu ke mono polo ikeagaieni keda tate au tadia na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na komi fata ku veleghamu kori vido kati mono gheheda, inau ku magnahaghinighamu kotida titiono aua tadia na komi tinoni ivei mi vei. ");
INSERT INTO bgt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Oti saghoi mataghunira arahai kena tangomana na vatheheagna na tonomiu, kari ena boi tangomana nidia na vatheheagna na tarungamiu. Oti mataghunia vamua a God, eigna imanea ke tangomana na vaparagna na tonomiu ma na tarungamiu kori meleha papara. ");
INSERT INTO bgt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ighamu koti adoa ghohi, na volidia e rua na manu iso e sikei na siliva vamua. Toke keda boi vahotha na volidia, teo sikei itadia keda sikili me thehe gi a Tamamiu i popo ke bosi magnahaghinia keda vaghagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Moti saghoi mataghu, eigna kori ghaghanagna a God ighamu koti nagho vano tadia na komi manu iso. Ma na komi sesehugna na ulumiu a God ke ijumira gougovu. ");
INSERT INTO bgt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Gi ahai keda vele aua tadia na komi tinoni imanea nigua na vaovarongo, inau kuda vele aua tagna a Tamagu i popo imanea nigua na vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kari ahai keda vele aua tadia na komi tinoni imanea boi nigua na vaovarongo, inau ghua kuda vele aua tagna a Tamagu i popo imanea boi nigua na vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Oti saghoi ghaghana inau ku mai bali hathera na komi tinoni kori maramagna eigna kedana mono haidu toke. Teo! Inau ku boi mai bali hati maia na soleana, kari u mai bali vathevuruara na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Inau ku mai bali thevuruara na mama ma a dathegna mane, ma na ido ma a dathegna vaivine, ma na vaivine ma na vungaogna vaivine. ");
INSERT INTO bgt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nigna na komi thevuioka na tinoni, arahai vamua ke mono kori nigna na tamadathe ghehegna. ");
INSERT INTO bgt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ahai ke dothovira vano a tamagna ba idogna tagua inau, imanea ke boi nabagna keda nigua na vaovarongo. Ahai ke dothovira vano a dathegna mane ba a dathegna vaivine tagua inau, imanea ke boi nabagna keda nigua na vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ahai ke boi sasaa keda papara me thehe eigna ke leghuu inau, imanea hiri ke boi nabagna keda nigua na vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ahai keda boi leghuu inau eigna ke magnahaghinia keda tatango ngasi tagna na havigna kori maramagna, imanea keda boi hatia na havi ke teo na govugna. Keana ahai ke sasaa keda papara me thehe eigna ke leghuu inau, imanea keda hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ahai keda kalitighamu, imanea ke kalitiu ghua. Ma ahai ke kalitiu, imanea ke kalitia a God ke vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ahai keda kalitia na profet eigna ke adoa na profet ke titionoa na komi haghoregna a God, a God keda hea na taba ke nanaba vamua tagna na taba keda hera mara na profet. Ahai keda kalitia na tinoni jino eigna ke adoa imanea na tinoni jino, a God keda hea na taba ke nanaba tagna na taba keda hera na komi tinoni kena jino. ");
INSERT INTO bgt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Inau ku veleghamu, gi ahai keda hea na bea ghaula tagna sina tinoni ke boi nagho tadia nigua na komi vaovarongo eigna imanea ke leghuu inau, a God keda hea na taba.” ");
INSERT INTO bgt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Leghugna ke titiono vanira nigna na komi vaovarongo, a Jisas ke taveti au ngengeni me vano tadia kekeha meleha kori provins i Galili eigna keda titionoa na Rorongo ke Toke me velepuhira na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kori vido iangeni, a Jon Siuvitabu ke mono ghohi kori vathe tatari me rongovia na rorongogna na komi fata ke eia a Vahavi. Gi e vetulara vano kekeha nigna na vaovarongo tagna a Jisas, ");
INSERT INTO bgt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","mena huatia, “Ighoe hiri a Vahavi kena velea keda mai, ba iti pitua sina mane tavogha?” ");
INSERT INTO bgt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A Jisas ke haghore tughura, “Oti vano tabiru tagna a Jon moti veleagna na hava koti rongovia moti reghia ikeagaieni. ");
INSERT INTO bgt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Arahai kena doa kena ghoi reirei, arahai kena thehe na naedia kena ghoi taetaveti, arahai kena lepa kena ghoi salu tabiru, arahai kena pui kena ghoi rorongo, arahai kena thehe kena havi tabiru, ma arahai kena kuma kena rongovia na Rorongo ke Toke. ");
INSERT INTO bgt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","A God keda vatokera arahai kena reghia na komi fata ku eia, kari ena boi jefe kori nidia na vaututuni.” ");
INSERT INTO bgt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kori vido nigna na komi vaovarongo a Jon kena taveti au, a Jisas ke titiono vanira na mavitu eigna a Jon. Imanea ke velera, “Kori vido ighamu koti taveti vano kori meleha ke gou, na hava koti vano bali reghia ngengeni na? Na tinoni ke boi heta nigna na vaututuni vaghagna na seo ke bebeleo kori ghuri? Teo! ");
INSERT INTO bgt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ba na hava koti haga vano reghia na? Na mane ke pipisia na komi pohe ke toetokelaghagna? Teo! Na komi tinoni vaghagna iangeni kena mono tadia na komi vathedia mara na king. ");
INSERT INTO bgt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na hava koti haga vano reghia na? Na profet? Hee! Jon na profet, kari boi na profet vamua. ");
INSERT INTO bgt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","A Jon iaani, a God ke kidi titionoa kori Rioriso ke Tabu vaghagna iaani, ‘Kenughua inau kuda kidi vetula nagho atua itamua nigua na mane titiono. Imanea keda kidi vajinoa na hangana vanigho.’ ");
INSERT INTO bgt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Inau ku veleghamu, a Jon ke nagho vano tadia na komi tinoni gougovu kena havi mai kori maramagna. Keana ahai ke boi nagho tadia arahai a God ke vunaghi pungusira, imanea ke nagho vano tagna a Jon. ");
INSERT INTO bgt_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Turughu kori maghavu a Jon ke turughu nigna na agutu me ghieghilei jufu mai ikeagaieni, na komi tinoni dika kena bosi magnahaghinia a God keda vunaghi pungusira mena rihu pungusia imanea. ");
INSERT INTO bgt_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gi mai a Jon, na komi rioriso kena risora mara na profet ma na komi vetula nigna a Moses kena velea a Vahavi keda mai. ");
INSERT INTO bgt_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Gi kotida vaututunia na hava ku veleghamu, a Jon hiri a Elaija kena velea mara na profet i hau keda mai. ");
INSERT INTO bgt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Gi ahai ke magnahaghinia keda thaothadoghagna iaani, imanea keda vaovarongo toetoke. ");
INSERT INTO bgt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Vaghagna na hava na komi tinoni kena mono ikeagaieni? Imarea vaghadia vamua na boo i gari kena nohe kori makete. Sina boo i gari tavogha kena ghuu vano tadia, ");
INSERT INTO bgt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ighami kiti ifu vanighamu moti boi nimiu na ragi. Ighami kiti sale dikahehe moti boi nimiu na tangi.’ ");
INSERT INTO bgt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Inau ku velea iaani eigna kori vido a Jon Siuvitabu ke mai, imanea ke sota me boi kouvia na waen. Mi ghamu koti velea na tidatho ke haghevia. ");
INSERT INTO bgt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Keana, kori vido inau, na Dathei Tinoni, ku mai mu vanga mu kou duadia na komi tinoni, ighamu koti velea, ‘Imanea ke thauthavu na vangagna me kou memee, ma ara kulagna mara bali oho takis mi mara na koakoa.’ Keana, na komi tango ke toke ke au mai kori leghuagna nigna na thaothadogha a God ke tatelia nigna na thaothadogha ke tutuni.” ");
INSERT INTO bgt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisas ke eia na komi reghithehe ke sethe tadia kekeha meleha, kari na komi tinoni tadia na komi meleha irangeni kena boi tughua na havidia ke koakoa. Na vunegna iangeni a Jisas ke dikatagna me velea, ");
INSERT INTO bgt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“A God keda vaparaghamu ighamu koti mono i Korasin! A God keda vaparaghamu ighamu koti mono i Betsaida! Inau ku boi eia na komi reghithehe i Taia mi Saidon vaghagna ku eia kori melehamiu. Kari gi kuda eia na komi reghithehe tadia na komi tinoni ngengeni, imarea kedana tughua ghohi na havidia ke koakoa. Imarea kedana pipisia na pohe jongo ke vaghagna na duku mena havula na pidaravu tagna na tonodia bali tateli aua imarea kena dikahehe. ");
INSERT INTO bgt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kori vido a God keda fatera na komi tinoni gougovu, na papara keda eia itamiu keda dika tuu vano tagna na papara keda eia itadia na mavitudia i Taia mi Saidon. ");
INSERT INTO bgt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ighamu na mavitudia i Kapaneam, oti toatogha a God keda abeghamu hadi i popo. Teo! Imanea keda soni horughamu kori meleha papara. Gi na komi tinoni kena mono i Sodom i hau kedana reghia na komi reghithehe ku eia kori melehamiu, na melehadia keda talu mono ikeagaieni. ");
INSERT INTO bgt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Inau ku veleghamu, na hava a God keda eia itamiu kori na maghavui fate keda dika tuu vano tagna na hava imanea keda ei vania na komi tinonidia i Sodom.” ");
INSERT INTO bgt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kori vido iangeni a Jisas ke tarai vaghagna iaani, “Mama, ighoe ko vunaghi pungusira na komi fata gougovu i popo mi thepa. Inau ku veletokegho eigna ighoe ko tatelira tadia arahai kena vaghadia na komi gari na komi fata ko poloa tadia arahai kena ghaghana kena thaothadogha. ");
INSERT INTO bgt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hii, Mama, ighoe ko magnahaghinia keda ai.” ");
INSERT INTO bgt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jisas ke govu na veletokeagna a God me velera na komi tinoni, “A Tamagu ke heu na komi fata gougovu. Sikei vamua a Tamagu ke pukuni adou inau. Mi inau vamua ku pukuni adoa a Tamagu ma arahai vamua inau ku vahira eigna kedana adoa imanea. ");
INSERT INTO bgt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ighamu koti mause kori hulungiagna na komi fata ke tahu, oti mai itagua mu kuda hatheghamu eigna kotida mamatho. ");
INSERT INTO bgt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Oti lubatiu eigna kuda batughamu mu velepuhighamu, eigna inau ku mono taluleghu mu sasaa na hatheghamugna. Ighamu kotida tangomana na mamatho ");
INSERT INTO bgt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","eigna na leghuuagna ke boi vahotha, ma na hava kuda kaeghamu keda boi tahuvighamu.” ");
INSERT INTO bgt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Boi hau leghugna iangeni, tagna sina Sabat, a Jisas mi mara nigna na komi vaovarongo kena halu vano hotaghidia na komi gnatha i wit. Nigna na komi vaovarongo kena rofo mena vihukira kekeha sagharogna na wit mena ghania. ");
INSERT INTO bgt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mara na Farise kena reghia mena dikatadia mena haghore vania Jisas, “Nighe! O reghia! Nimua na komi vaovarongo kena eia na agutu ke boi lubatia nida na komi vetula katida eia kori Sabat.” ");
INSERT INTO bgt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A Jisas ke veleragna, “Ehava? Oti boi ijumia na hava ke eia a King Deved ma na komi nigna na mane kori vido kena rofo? ");
INSERT INTO bgt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Imanea ke vano haghe kori vathegna a God me hatia na bred ke tabu. Gi manea ma na komi nigna na mane kena ghania. Toke na vetula ke lutira na ghaniagna na bred iangeni me lubatira vamua mara na pris kedana ghania, a God ke boi dikatagna tagna a Deved. ");
INSERT INTO bgt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ehava? Oti boi ijumia tadia na komi vetula nigna a Moses eigna na hava kena eia mara na pris? Kori na Sabat imarea kena boi leghua na vetula eigna kena agutu kori Vathe ke Tabu. Kari a God ke boi velea imarea kena ei hahia. ");
INSERT INTO bgt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Inau ku veleghamu, sina tinoni ke nagho vano tagna na Vathe ke Tabu nigna a God ke mono eeni. ");
INSERT INTO bgt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","A God ke velea iaani tadia na komi Rioriso ke Tabu, ‘E toke vamua ighamu kotida boi havughaghi itagua, eigna na fata ku pukuni magnahaghinighamu kotida eia, na raroviragna arahai tavogha vamua.’ Gi kotida thaothadoghagna na komi haghore iraani, teo kotida fatera arahai kena boi ei hahia sa fata. ");
INSERT INTO bgt_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Eigna inau, na Dathei Tinoni, ke mono nigua na mana bali velera na komi tinoni na hava kedana tangomana na eiagna kori Sabat.” ");
INSERT INTO bgt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","A Jisas ke au sania na gnatha i wit me vano haghe kori vathe haidu. ");
INSERT INTO bgt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ingengeni ke mono sina mane ke thehe na limagna. Na vunegna mara na Farise kena magnahaghinia kedana toroagna a Jisas, imarea kena huatia, “E lubatighita mua na nida na komi vetula eigna katida vatoke tabirua na tinoni kori Sabat?” ");
INSERT INTO bgt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma Jisas ke huatira, “Na hava koda eia gi keda sikili horu kori lodu sikei nimua sip kori Sabat na? Ighoe koda vano mo kiaria aua! ");
INSERT INTO bgt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na tinoni ke pukuni nagho vano tagna na sip. Na vunegna iangeni, nida na komi vetula ke lubatighita eigna katida eia na tango ke toke kori Sabat.” ");
INSERT INTO bgt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Gi a Jisas ke haghore vania na mane ke thehe na limagna, “O vajinoa na limamu.” Imanea ke vajinoa na limagna, me ghoi toke tabiru me vaghagna vamua na limagna ke boi thehe. ");
INSERT INTO bgt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mara na Farise kena taveti au mena turughu vapuipuhi haidu bali vathehea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","A Jisas ke adoa mara na Farise kena haga vathehea me taveti sania na meleha iangeni. Na mavitu ke sethe kena leghua, mi manea ke vatoke tabirura na komi tinoni kena vahaghi itadia. ");
INSERT INTO bgt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kari a Jisas ke haghore heta vanira eigna kedana saghoi titiono eigna imanea ghehegna tadia na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A Jisa ke eia na komi reghithehe irangeni eigna keda tutuni na haghoregna a God ke risoa a profet Aisaia i hau, ");
INSERT INTO bgt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Iaani nigua na mane agutu ku vahia, Inau ku dothovia muku totogo eigna. Inau kuda hea nigua na Tarunga ke Tabu, mi manea keda titiono tadia na komi tinoni gougovu eigna na puhi ku eia bali vajinora kori matagu. ");
INSERT INTO bgt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Imanea keda boi rihu haohaghore ba ghuvira na komi tinoni, Imanea keda boi haohaghore tadia na komi hangana. ");
INSERT INTO bgt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Imanea keda rarovira arahai kena boi heta nidia na vaututuni, Me keda hathera arahai kena boi tangomana na hatheragna ghehedia. Imanea keda talu eia vaghagna iangeni me ghieghilei jufu na maghavu imanea ke eira na komi tinoni eigna kedana leghua na puhi ke jino. ");
INSERT INTO bgt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ma na komi tinoni kori maramagna kedana vaututunia imanea keda vahavira.” ");
INSERT INTO bgt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kekeha tinoni kena talangi maia tagna Jisas sina mane ke doa me mui eigna na tidatho ke haghevia. Jisas ke vatoke tabirua, mi manea ke ghoi tangomana na reirei ma na haohaghore. ");
INSERT INTO bgt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na mavitu kena vere nidia puala mena velea, “Ehava? Iaani hiri a Vahavi keda havi mai kori vikegna a King Deved?” ");
INSERT INTO bgt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Keana kori vido mara na Farise kena rongovia na hava ke eia a Jisas, imarea kena velea, “Imanea ke gigi aura na komi tidatho kori nigna na mana a Satan, na vunaghidia na komi tidatho.” ");
INSERT INTO bgt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas ke adoa na ghaghanadia me veleragna, “Gi na mavitu tagna sina moumolu kedana rihu ghadia ghehedia, na moumolu iangeni keda govu. Me gi na komi tinonidia sina meleha ba sina tamadathe kedana riurihu ghadia ghehedia, na meleha iangeni ba na tamadathe iangeni keda thevurua. ");
INSERT INTO bgt_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Gi a Satan keda gigi aura nigna na komi tidatho, imanea ke rihua ghehegna ma nigna na mana keda govu saisami. ");
INSERT INTO bgt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Gi keda tutuni inau ku gigi aura na komi tidatho kori mana nigna a Satan, kori mana nigna ahai nimiu na komi vaovarongo kena gigi aura na komi tidatho na? Na mana nigna a Satan? Teo! Imarea kedana fateghamu ighamu mara na Farise eigna na hava koti velea, eigna ighamu koti hahi. ");
INSERT INTO bgt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Keda tutuni inau ku gigi aura na komi tidatho kori nigna na mana na Tarunga ke Tabu nigna a God, iaani ke tatelia a God ke turughu ghohi na vunaghi pungusiragna na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Gi ahai keda magnahaghinia na gigi auragna na komi tidatho, imanea keda heta vano tagna a Satan. Vaghagna sina mane ke magnahaghinia keda vano haghe koragna na vathegna sina mane ke heta me bilaura nigna na komi fata. Imanea keda heta vano tagna na mane ke heta iangeni. Gi e malumu na tariagna na mane ke heta bali bilaura nigna na komi fata. ");
INSERT INTO bgt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ahai ke boi thevu itagua, imanea nigua na thevuioka. Ma ahai ke boi hatheu na hatiragna mai na komi tinoni tagna a God, imanea ke vajefera tagna a God. ");
INSERT INTO bgt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Inau ku veleghamu, a God ke tangomana na talutavoghagna na komi thagi paluha ma na komi thagi haghore ke dika gougovu kena eia na komi tinoni vania a God. Keana, ahai keda velehouhorua na Tarunga ke Tabu, a God keda bosi talutavogha na paluhagna. ");
INSERT INTO bgt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ahai keda haghore diadikala na Dathei Tinoni, a God ke tangomana na talutavoghagna na paluhagna. Kari ahai keda haghore diadikala na Tarunga ke Tabu, a God keda boi talutavogha na paluhagna ikeagaieni ba vugei valiha.” ");
INSERT INTO bgt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","A Jisas ke ghoi titiono tadia mara na Farise, “Ighamu koti adoa na ghai tagna na sagharogna. Gi na sagharogna na ghai keda toke, ighamu koti adoa na ghai iangeni ke toke. Gi na sagharogna na ghai keda dika, ighamu koti adoa na ghai iangeni ke dika. ");
INSERT INTO bgt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ighamu koti dika puala vaghadia na komi poli! Na vunegna koti dika, oti boi tangomana na veleagna sa fata ke toke. Eigna na hava ke vele aua na tinoni, leghua vamua na hava ke mono kori ghaghanagna. ");
INSERT INTO bgt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Na tinoni ke toke keda vele aua na komi fata ke toke ke au mai kori ghaghanagna ke toke. Ma na tinoni ke dika keda vele aua na komi fata ke dika ke au mai kori ghaghanagna ke dika. ");
INSERT INTO bgt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Inau ku veleghamu, kori maghavui fate, a God keda fatera na komi tinoni eigna na komi haghore gougovu kena velea, haluhadi na komi haghore ke dika. ");
INSERT INTO bgt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gi koda eia na komi haghore ke toke, a God keda velea ighoe na tinoni jino. Kari gi koda eia na komi haghore ke dika, imanea keda velea ighoe na tinoni dika.” ");
INSERT INTO bgt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kekeha mara na Farise mi mara na velepuhigna na komi vetula nigna a Moses kena veleagna a Jisas, “Velepuhi, ighami kiti magnahaghinigho koda eia na reghithehe bali tateli aua ighoe ko mai tagna a God.” ");
INSERT INTO bgt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jisas ke haghore tughura, “Ighamu koti havi ikeagaieni, oti dika puala moti boi leghua a God. Ighamu koti magnahaghinia puala na reghiagna na reghithehe. Kari ighamu kotida reghia sikei vamua na reghithehe ke vaghagna na reghithehe a God ke ei vania a profet Jona. ");
INSERT INTO bgt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Vaghagna imanea ke mono kori kutugna na igha hutu e tolu na dani me tolu na bongi, inau, na Dathei Tinoni kuda mono kori na beku e tolu na dani me tolu na bongi. ");
INSERT INTO bgt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kori maghavui fate, na mavitugna i Ninive kedana sokara hadi duamiu ighamu koti havi ikeagaieni mena velea ighamu koti eia na hahi. Eigna imarea kena tughua na havidia ke koakoa kori vido a Jona ke titiono vanira na hava a God ke veleagna. Ikeagaieni na tinoni ke nagho vano tagna a Jona ke mai ghohi itamiu. Kari ighamu koti bosi magnahaghinia na tughuagna na havimiu ke koakoa. ");
INSERT INTO bgt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kori maghavui fate, na Queen gna i Siba keda sokara hadi duamiu ighamu koti havi ikeagaieni me velea ighamu koti eia na hahi. Eigna iia ke turughu mai kori kujukugna na maramagna me mai vaovarongo tagna a King Solomon ke thaothadogha. Ikeagaieni na tinoni ke thaothadogha vano tagna a Solomon ke mai ghohi itamiu, kari ighamu koti bosi magnahaghinia na rongoviagna.” ");
INSERT INTO bgt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","A Jisas ke ghoi velea, “Kori vido na tidatho ke taveti au tagna na tinoni, na tidatho ke vano me mai kori meleha ke gou na hiroagna na vido bali monoagna. Gi keda boi pada sa vido bali monogna, ");
INSERT INTO bgt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","imanea keda velea, ‘Da u ghoi tabiru vamua tagna na vathe ku au mai tagna i hau.’ Kori vido na tidatho ke ghoi tabiru mai, imanea ke reghia na vathe kena jaojaro me raraha ghohi kari e korogha. ");
INSERT INTO bgt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Gi e ghoi taveti au me vano hatira e vitu na tidatho ke dika vano itagna, mena mai mena mono ngengeni. Ma na havigna na tinoni iangeni keda dika vano tagna na havigna i hau. Iaani keda padaghamu ighamu na komi tinoni koti dika koti havi ikeagaieni.” ");
INSERT INTO bgt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kori vido a Jisas ke talu titiono tadia na mavitu kori vathe, a idogna mara tahigna kena mai mena sokara i kosi eigna kena magnahaghinia kedana titiono duagna. ");
INSERT INTO bgt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Gi sina tinoni ke veleagna a Jisas, “A idomu mara tahimu kena sokara i kosi mena magnahaghinia kedana titiono duamu.” ");
INSERT INTO bgt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ma Jisas ke haghore tughua, “Ahai a idogu na? Ma arahai ara tahigu na?” ");
INSERT INTO bgt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Gi imanea ke tuhu vano tadia na komi tinoni kena leghua me velea, “Mara iraani hiri a idogu mara tahigu. ");
INSERT INTO bgt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Eigna ahai vamua ke eia na hava a Tamagu i popo ke magnahaghinia, imanea ke vaghagna a tahigu ma vaivinegu ma idogu.” ");
INSERT INTO bgt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kori dani iangeni, a Jisas ke au sania na vathe me vano kori ghaghirei kolo i Galili. Imanea ke nohe eigna keda velepuhira na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na vunegna na mavitu ke sethe kena haidu mai itagna, imanea ke vano saki haghe kori boti me nohe ikoragna, ma na mavitu kena sokara i longa. ");
INSERT INTO bgt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Gi imanea ke eia kekeha titiono velepuhi bali velepuhiragna na komi fata sethe. Imanea ke velea, “Sina mane ke sonira kilili na katura kori nigna na gnatha. ");
INSERT INTO bgt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kori vido imanea ke sonira kilili na komi katura, kekeha kena sikili horu kori hangana ma na komi manu kena mai mena ghani govura. ");
INSERT INTO bgt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kekeha katura kena sikili horu popogna na thepa ke mono na ghahira saragna. Kori vido kena kotu hadi, ena ghathi havi toke sina vido vamua. ");
INSERT INTO bgt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kori vido na aho ke vuvughu, na komi katura kena kotu kena gho’e mena thehe eigna na oghadia ke boi pukuni horu i thepa. ");
INSERT INTO bgt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kekeha katura kena sikili horu kori vido ke sethe na atho kaekathe. Kori vido na komi katura kena kotu hadi me hutu, na atho kaekathe irangeni ke virighira mena boi sagharo. ");
INSERT INTO bgt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Keana kekeha katura kena sikili horu kori thepa ke toke mena havi mena sagharo toke. Kekeha, tolu hangavulu na sagharodia, kekeha tolu tutughu, mi kekeha ghua sina hathangatu. ");
INSERT INTO bgt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gi ahai ke magnahaghinia na thaothadoghagna iaani, imanea keda vaovarongo toetoke.” ");
INSERT INTO bgt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mara nigna na komi vaovarongo a Jisas kena mai itagna mena huatia, “Ehava gi o velepuhiragna na mavitu tadia na komi titiono velepuhi?” ");
INSERT INTO bgt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A Jisas ke haghore tughura, “I hau, a God ke boi lubatia ahai eigna keda adoa na puhi keda eia kori vunaghi pungusiragna nigna na komi tinoni. Keana ikeagaieni imanea ke lubatighamu gi kotida adoa. Kari tadia arahai kena boi leghuu inau, imanea ke boi lubatira kedana adoa. ");
INSERT INTO bgt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ahai ke magnahaghinia keda thaothadoghagna a God, a God keda vasethea nigna na thaothadogha eigna keda pukuni thaothadoghagna. Keana ahai ke bosi magnahaghinia na thaothadoghagna a God, a God keda hati aua itagna na nigna na ghathi thaothadogha. ");
INSERT INTO bgt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Inau ku eia na komi titiono velepuhi vanira na mavitu eigna, toke imarea kena reghia na hava ku eia, teo kedana thaothadoghagna na hava kena reghia. Toke imarea kena rongovia na hava ku velera, teo kedana thaothadoghagna nigua na komi velepuhi. ");
INSERT INTO bgt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Inau ku eia iangeni, mi keagaieni na fata ke risoa a profet Aisaia ke tutuni, “Na komi tinoni iraani kedana vaovarongo mena vaovarongo kori haghoregu, kari imarea kedana boi thathadoghagna. Imarea kedana reghia mena dorovia na hava ku eia, kari imarea kedana boi adoa na ghaghanagna. ");
INSERT INTO bgt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Eigna na komi tinoni iraani e pono puala na uludia. Imarea kena boi vaovarongo kori kulidia, mena bilakia na matadia. Gi kedana boi eia iangeni, imarea kedana dodoro kori matadia, me kedana rorongo kori kulidia. Imarea kedana thaothadoghagna kori hehedia na komi fata ku eia mu velea me kedana tabiru mai itagua eigna kuda vahavira.’ ");
INSERT INTO bgt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Gi a Jisas ke velera nigna na komi vaovarongo, “God ke vatokeghamu eigna ighamu koti thaothadoghagna na hava koti reghia kori matamiu, moti thaothadoghagna na hava koti rongovia kori kulimiu. ");
INSERT INTO bgt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Inau ku veleghamu, sethe na profet me sethe na komi tinoni kena jino kena thehe ghohi kena magnahaghinia puala kedana reghia na komi fata koti reghia, keana ena boi reghia. Mena magnahaghinia kedana rongovia na komi fata koti rongovia, keana ena boi rongovia. ");
INSERT INTO bgt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Oti rorongo mai itagua eigna kuda veleghamu na ghaghana koragna na titiono velepuhi eigna na mane ke sonira kilili na komi katura. ");
INSERT INTO bgt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Na komi tinoni kena rongovia na rorongogna na hughuta i popo, keana imarea kena boi thaothadoghagna, mara iraani kena vaghagna na komi katura kena sikili kori hangana. A Satan ke saisami mai me hati aua kori ghaghanadia na rorongo iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na komi katura ke sikili popogna na thepa ke mono na ghahira saragna ke vaghadia na komi tinoni kena rongovia na haghoregna a God mena saisami hatia mena totogo. ");
INSERT INTO bgt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kari ena kalitia sina ghathi vido iso vamua, eigna na haghore ke boi mono kori havidia vaghagna na komi katura kena boi pukuni horu i thepa na oghadia. Kori vido ke padara na vahotha ba na papara eigna kena leghua na haghoregna a God, imarea kena saisami havaghinia nidia na vaututuni. ");
INSERT INTO bgt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na komi katura kena sikili horu tagna ke mono na atho kaekathe ke vaghadia na komi tinoni kena rongovia na haghoregna a God, keana imarea kena toatogha puala eigna na komi fata kori havidia leuleghu dani. Mena magnahaghinia puala kedana pada rongo. Na vunegna iangeni, imarea kena boi leghua na haghoregna a God. Teo sa fata ke toke keda au mai kori havidia. ");
INSERT INTO bgt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na komi katura ke sikili horu kori thepa ke toke ke vaghadia na komi tinoni kena rongovia na haghoregna a God mena thaothadoghagna. Na komi tinoni irangeni, sethe na fata ke toke keda au mai kori havidia, vaghagna na komi katura kena havi toke me sethe na sagharodia. Kekeha tolu hangavulu na sagharodia, kekeha tolu tutughu, mi kekeha ghua sina hathangatu.” ");
INSERT INTO bgt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas ke ghoi velepuhira na mavitu kori titiono velepuhi iaani, “Na hughuta i popo ke vaghagna na mane ke sonira kilili na komi katura wit ke toke kori nigna na gnatha. ");
INSERT INTO bgt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sina bongi, kori vido na komi tinoni gougovu kena nere, nigna na thevuioka ke mai me sonira kilili na komi katuragna na buburu dika kori gnatha gi e taveti au. ");
INSERT INTO bgt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Leghugna iangeni, kori vido na komi katura i wit kena kotu hadi mena rugu, na buburu dika ghua ke kotu hadi. ");
INSERT INTO bgt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mara kena agutu vania na mane ke tonogna na gnatha kena mai itagna mena veleagna, ‘Vunaghi, ighoe ko sonira kilili kori ghamua na gnatha na komi katura wit vamua. Ehava gi na komi buburu kena kotu hadi mua ngengeni?’ ");
INSERT INTO bgt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Imanea ke velera, ‘Nigua na thevuioka ke eia.’ “Nigna na komi mane agutu kena huatia, ‘Ehava? O magnahaghinia kitida vano miti vutira au na komi buburu ngeni?’ ");
INSERT INTO bgt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Imanea ke velera, ‘Teo! Gi kotida vuti sonira na komi buburu, kenughua oti vuti sonira mua na komi wit duadia. ");
INSERT INTO bgt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Talura eigna kedana sakai kotu hadi me ghieghilei ghano na wit. Kori vido iangeni, inau kuda veleragna mara bali hathatonora na wit eigna kedana kidi hathatanora na komi buburu mena tari haidura bali pughulira. Gi u velera eigna kedana hathatanora na wit mena boa kori nigua na vathe bali mono komi ghagua na vanga.’” ");
INSERT INTO bgt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas ke ghoi eia mua na titiono velepuhi iaani, “Na hughuta i popo ke vaghagna na katuragna na ghai mastad na tinoni ke joua kori nigna na gnatha. ");
INSERT INTO bgt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Na katuragna na ghai iaani e iso teoteoa vano tadia na komi katura gougovu. Keana kori vido ke kotu hadi, na ghai mastad ke hutu vano tadia na komi fata gougovu ke joua kori nigna na gnatha. Me nabadia na komi manu kedana mai mena ei gnekudia tadia na komi ototogna.” ");
INSERT INTO bgt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Gi a Jisas ke ghoi eia mua na titiono velepuhi iaani, “Na hughuta i popo ke vaghagna sina ghathi vido isi sina vaivine ke ngignoa duagna sina duku flaoa. Leghugna na ngignoagna, na isi ke vapotea na flaoa me hutu.” ");
INSERT INTO bgt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas ke velepuhira na komi tinoni na komi fata iraani kori titiono velepuhi. Na komi fata gougovu ke velepuhira, imanea ke eia kori titiono velepuhi vamua. ");
INSERT INTO bgt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jisas ke eia iangeni eigna keda tutuni na hava a God ke veleagna sina nigna na profet i hau, “Inau kuda titionoa itamiu kori titiono velepuhi mu kuda vele aua na komi fata ku boi tatelia tagna sa tinoni turughu kori vido ku vavuha na maramagna.” ");
INSERT INTO bgt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas ke au sanira na mavitu me vano haghe kori vathe ke mono itagna. Nigna na komi vaovarongo kena mai itagna mena huatia, “O unuhia vanighami na ghaghana koragna na titiono velepuhi eigna na komi buburu dika ke kotu kori gnatha.” ");
INSERT INTO bgt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ma Jisas ke velera, “Na mane ke sonira kilili na komi katura ke toke ke vaghagu inau, na Dathei Tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na gnatha ke vaghagna na maramagna ma na komi katura ke toke kena vaghadia na komi tinoni kena lubatia a God eigna keda vunaghi pungusira. Na komi buburu dika ke vaghagna na komi tinoni a Satan ke vunaghi pungusira. ");
INSERT INTO bgt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na thevuioka ke sonira kilili na komi katuragna na buburu dika ke vaghagna a Satan. Na dani bali hathatanora na wit ke vaghagna na vagovui danigna na maramagna, ma na komi tinoni bali hathatanora ke vaghagna na komi enjel. ");
INSERT INTO bgt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Na hathatanoragna ma na pughuliragna kori joto na komi buburu dika, ke vaghagna na hava keda tate mai kori vagovui danigna na maramagna. ");
INSERT INTO bgt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Inau, na Dathei Tinoni, kuda vetulara au nigua na komi enjel me kedana sonira au kori nigua na hughuta na komi tinoni koakoa ma na komi tinoni kena vajefera arahai tavogha kori koakoa. ");
INSERT INTO bgt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mi marea kedana sonira kori joto ke hutu. Ingengeni na komi tinoni kedana tangi mena gigiri kei. ");
INSERT INTO bgt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ma na komi tinoni kena jino kedana siasilada vaghagna na aho kori nigna na hughuta a Tamadia. Gi ahai ke magnahaghinia na thaothadoghagna iaani, imanea keda vaovarongo toetoke. ");
INSERT INTO bgt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Na hughuta i popo ke vaghagna na rongo kena gilu poloa kori gnatha. Kori vido sina tinoni ke pada, imanea ke totogo puala me gilu tabirua. Imanea ke vano me salemua komi nigna na fata gougovu me volia na gnatha iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Na hughuta i popo ke vaghagna na tinoni ke tonogna na sitoa ke hiroa na komi kidorugna na sie ke ulaghagna eigna keda volira. ");
INSERT INTO bgt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kori vido imanea ke pada sikei ke toke ke vahotha puala, imanea ke vano me salemua komi nigna na fata gougovu me volia. ");
INSERT INTO bgt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Na hughuta i popo ke vaghagna na jau mara ugura kena tathahia kori kolo me hogho na komi soasopa thagi fei itagna. ");
INSERT INTO bgt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Na jau ke vonu fei mi marea kena thaghia thonga kori lilihi. Gi ena nohe mena hoghonira kori arao na komi fei ke toke mena sonira au na komi fei ke dika. ");
INSERT INTO bgt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Vaghagna iangeni keda tate mai kori vagovui danigna na maramagna. Na komi enjel kedana mai mena vahira au na komi tinoni kena dika itadia na komi tinoni kena jino. Mi marea kedana sonira na komi tinoni dika kori joto ke hutu. ");
INSERT INTO bgt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ingengeni na komi tinoni kedana tangi mena gigiri kei.” ");
INSERT INTO bgt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","A Jisas ke huatira nigna na komi vaovarongo, “Oti thaothadoghagna mua na ghaghanagna na komi titiono velepuhi iraani?” Mi marea kena haghore tughua, “Hii, ighami kiti thaothadoghagna ghohi.” ");
INSERT INTO bgt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Gi imanea ke velera, “Ahai ke thaothadoghagna na komi vetula nigna a Moses me thaothadoghagna mua na komi velepuhi mathangani eigna na puhi a God ke vunaghi pungusira na komi tinoni, imanea ke vaghagna na tinoni ke mono nigna na komi fata ke toke ke mathangani me haulaghi kori vathegna.” ");
INSERT INTO bgt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Leghugna a Jisas ke vagovua na komi titiono velepuhi iraani, imanea ke au sania na meleha iangeni, ");
INSERT INTO bgt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","me vano kori melehagna i Nasaret. Imanea ke vano haghe kori vathe haidu me velepuhira na mavitu. Imarea kena vere nidia puala tagna nigna na velepuhi mena velea, “Ehava gi e thaothadogha puala na mane iaani? Ahai ke hea na mana gi e eia na komi reghithehe? ");
INSERT INTO bgt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ighita ati adoa na mane iaani a dathegna na mane agutu vathe vamua. A idogna imanea a Meri kari ara tahigna; Jemes, Josep, Saimon ma Jiudas. Ara vaivinegna huju ena mono mua eeri. ");
INSERT INTO bgt_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ehava gi e thaothadogha puala me tangomana na eiagna na komi reghithehe na mane iaani?” ");
INSERT INTO bgt_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma na komi tinonidia i Nasaret kena boi magnahaghinia na vaututuniagna. Ma Jisas ke velera, “Ahai ke profet, na mavitu tadia na komi meleha ena ghaghana bohea. Kari na mavitu kori melehagna ma nigna na tamadathe ena boi ghaghana bohea.” ");
INSERT INTO bgt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A Jisas ke boi eia sa reghithehe ke sethe kori melehagna eigna imarea kena boi vaututunia. ");
INSERT INTO bgt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kori vido iangeni a Herod Antipas ke primia kori provins i Galili me rongovia na rorongogna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Imanea ke velera nigna na komi mane agutu, “Na mane iaani a Jon Siuvitabu ke ghoi havi tabiru kori thehe! Iangeni na vunegna gi e mono nigna na mana bali eia na komi reghithehe.” ");
INSERT INTO bgt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","A Herod ke toatogha vaghagna iangeni eigna i hau imanea ke vetula mara nigna na soldia mena thotia mena taria a Jon Siuvitabu mena boa haghea kori vathe tatari. Imanea ke eia iangeni bali vatotogoa a Herodias, a taugna. I hau a Herodias ke taulaghi tagna a Filip, a toghagna a Herod. Ma Herod ke hatia me taulaghi itagna. ");
INSERT INTO bgt_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jon ke veleagna hahalia a Herod, “E boi jino kori vetula nigna a God ko hatia a taugna tahimu.” ");
INSERT INTO bgt_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","A Herod ke magnahaghinia keda vathehea a Jon, kari e mataghunira na mavitu eigna imarea kena vaututunia a Jon na profet. ");
INSERT INTO bgt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tagna sina dani a Herod ke eia na vangahaidu bali togha tabirua na dani havigna. Kori vido iangeni a dathegna vaivine a Herodias ke ragi vanira arahai kena mai kori vangahaidu. A Herod ke reghia me totogo puala itagna, ");
INSERT INTO bgt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","me jijighi vania eigna keda hea sa fata keda kaea. ");
INSERT INTO bgt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Leghugna a idogna ke veleagna na hava keda kaea, iia ke veleagna a Herod, “Inau ku magnahaghinia koda heu mai na ulugna a Jon Siuvitabu kori tapera.” ");
INSERT INTO bgt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herod ke dikahehegna puala, kari e maomamogna keda vateoa eigna ke jijighi vania ghohi, ma ara kulagna kena rongovia. Na vunegna iangeni, imanea ke velera nigna na komi soldia eigna kedana eia na hava iia ke kaea. ");
INSERT INTO bgt_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Imarea kena vano kori vathe tatari mena utuhia na luagna a Jon Siuvitabu. ");
INSERT INTO bgt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Imarea kena boa na ulugna kori tapera gi ena hatia mena vano hea a dathegna vaivine a Herodias. Gi iia ke hati vanoa tagna a idogna. ");
INSERT INTO bgt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na rorongogna ke jufungira nigna na komi vaovarongo a Jon, gi ena mai hatia na tonogna mena gilua. Leghugna iangeni imarea kena vano mena titiono vania a Jisas eigna na rorongogna na theheagna a Jon Siuvitabu. ");
INSERT INTO bgt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kori vido a Jisas ke rongovia a Jon Siuvitabu ke thehe, imanea duagna nigna na komi vaovarongo kena hahaghe kori boti mena vano ghehedia tagna na vido ke korogha. Kari na komi tinoni kena rongovia tagna kena vano. Imarea kena au mai kori melehadia mena leghua Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kori vido a Jisas ke thonga i longa me reghia na mavitu ke sethe, imanea ke rarovira me vatoke tabirura arahai kena vahaghi itadia. ");
INSERT INTO bgt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kori vido ke haga huu ghohi na aho, nigna na komi vaovarongo a Jisas kena mai itagna mena ania, “E lavi ghohi me teo sa vanga kori meleha iaani. O vetulara au na mavitu eigna kedana vano tadia na komi meleha ke gharanighita bali voli ghadia vanga.” ");
INSERT INTO bgt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kari a Jisas ke velera, “E teo sa vunegna kedana vano. Oti hera ghadia.” ");
INSERT INTO bgt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Imarea kena haghore tughua, “Boi tangomana nimami. E lima na bred me rua vamua na fei ke mono itamami.” ");
INSERT INTO bgt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ma Jisas ke velera, “Oti hatira mai itagua.” ");
INSERT INTO bgt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Imanea ke velera na mavitu eigna kedana nohe kori buburu, gi e tangolia e lima na bred me rua na fei me tada hadi i popo me veletokea a God eidia. Gi e vidoa na bred ma na fei me hera nigna na komi vaovarongo eigna kedana kemulia tadia na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na mavitu kena vanga mena mahu. Ma na nigna na komi vaovarongo kena hathatanora na komi viovidoi vanga ke tomagha, mena hoghoni vavonua e salaghe rua na arao. ");
INSERT INTO bgt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na haidudia mara na mane kena vanga, e lima na togha. Na koi vaivine ma na komi gari, imarea kena boi ijumira. ");
INSERT INTO bgt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Leghugna a Jisas ke hera ghadia na mavitu, imanea ke velera nigna na komi vaovarongo eigna kedana hahaghe kori boti mena kidi hathavu sethevugna na kolo. Jisas ke mono horu duadia na mavitu eigna keda vetulara tabiru kori melehadia. ");
INSERT INTO bgt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Leghugna ke eia iangeni, a Jisas ke vano hadi tagna sina suasupa me tarai. Kori huugna na aho a Jisas ke mono ghehegna ngengeni. ");
INSERT INTO bgt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kori vido iangeni nigna na komi vaovarongo kena haunia ghohi i longa. Na boti ke saosaporaghi eigna na ghuri ke heta ke mai naghodia. ");
INSERT INTO bgt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kori vuevughei puni, a Jisas ke vano itadia nigna na komi vaovarongo. Imanea ke taetaveti popogna na bea. ");
INSERT INTO bgt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kori vido kena reghia, imarea kena toatogha kena reghia na tidatho. Imarea kena mataghu nidia puala mena ghuu heta. ");
INSERT INTO bgt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kari a Jisas ke velera, “Oti saghoi mataghu! Iaani inau vamua.” ");
INSERT INTO bgt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A Pita ke velea, “Lod, keda pukuni ighoe tutuni, o veleu eigna kuda taveti mai itamua popogna na bea.” ");
INSERT INTO bgt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma Jisas ke ania, “O taveti mai.” A Pita ke saki au kori boti me turughu taetaveti vano tagna a Jisas popogna na bea. ");
INSERT INTO bgt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Keana kori vido ke reghia na maghavu ke hutu, a Pita ke mataghu nigna puala me turughu tororo. Imanea ke ghuu vano tagna a Jisas, “Lod, o vahaviu!” ");
INSERT INTO bgt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jisas ke saisami me lakua na limagna a Pita me ania, “Nimua na vaututuni ke lae. Ehava gi o ghaghana ruarua?” ");
INSERT INTO bgt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Romara koro vano saki haghe kori boti mi kori vido vamua iangeni, na ghuri ke soto. ");
INSERT INTO bgt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Gi mara na komi vaovarongo kena maimanihihia a Jisas mena veleagna, “Ighoe pukuni Dathegna a God tutuni!” ");
INSERT INTO bgt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jisas duagna nigna na komi vaovarongo kena hathavu sethevugna na kolo mena thonga kori meleha i Genesaret. ");
INSERT INTO bgt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kori vido na komi tinoni ngengeni kena ghithatha a Jisas, imarea kena vetula vanoa na haghore tadia na komi meleha ghaghireidia. Ma na komi tinoni kena hatira mai tagna a Jisas arahai kena vahaghi eigna keda vatoke tabirura. ");
INSERT INTO bgt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Imarea kena kae huhurua a Jisas eigna keda lubatira arahai kena vahaghi gi kedana tugelia na kujukugna nigna na pohe. Ma na komi tinoni gougovu kena tugelia kena toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sina dani kekeha mara na Farise duadia kekeha mara velepuhigna na vetula nigna Moses kena kalasu mai i Jerusalem mena mai tagna a Jisas mena huatia, ");
INSERT INTO bgt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ehava gi nimua na komi vaovarongo kena boi leghua na komi vetula kena agutua ghehedia ara hutuda mena talu horua vanighita? Imarea kena boi leghua na puhi bali sikame gi ena vanga.” ");
INSERT INTO bgt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma Jisas ke haghore tughura, “Ehava gi oti huhughua na komi vetula nigna a God moti leghura vamua nimiu na komi vetula ghehemiu? ");
INSERT INTO bgt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ighamu koti adoa a God ke velea ghohi, ‘Ghaghana bohea a tamamiu ma idomiu,’ ma ‘Ahai keda velehouhorua a tamagna ba a idogna, na tinoni iangeni kedana vathehea.’ ");
INSERT INTO bgt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kari ighamu koti velea e toke vamua ahai keda veleagna idogna ma tamagna, ‘Tangomana kuda hatheghamu tagna na komi fata ku tonogna, kari boi tangomana nigua ikeagaieni. Eigna inau ku taluhaghore ghohi kuda hea a God.’ ");
INSERT INTO bgt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ighamu koti velepuhia na tinoni iangeni eigna keda boi ghaghana bohea a tamagna ma idogna. Ighamu koti huhughua na vetula nigna a God eigna koti magnahaghinia na leghuagna nimiu na velepuhi ghehemiu vamua. ");
INSERT INTO bgt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Oti piapilau puala eigna na puhi bali leghua a God! Na hava a God ke veleagna a profet Aisaia i hau eimiu ghamu e tutuni. A God ke velea, ");
INSERT INTO bgt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Na komi tinoni iraani kena maimanihihiu kori haghoredia vamua, kari kori havidia ena hauniu inau. ");
INSERT INTO bgt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Imarea kena hai maimanihihiu vamua eigna kena tughua nigua na komi vetula mena leghua vamua nidia na komi vetula kena eia ghehedia.’” ");
INSERT INTO bgt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas ke kilo haidura na mavitu me veleragna, “Oti vaovarongo toetoke eigna kotida thaothadoghagna na hava kuda veleghamu. ");
INSERT INTO bgt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Na vanga kena ghania na komi tinoni e boi tangomana keda vagarura kori matagna a God. Kari na komi fata dika kena velea na komi tinoni ke vagarura kori matagna a God.” ");
INSERT INTO bgt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Komi nigna na vaovarongo a Jisas kena mai itagna mena veleagna, “O adoa mua mara na Farise kena dikatadia eigna na haghore ko eia iangeni?” ");
INSERT INTO bgt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma Jisas ke velera, “Na komi ghai ke boi joua a Tamagu, imanea keda vuti aura. ");
INSERT INTO bgt_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Oti saghoi mono duadia mara na Farise. Imarea kena vaghagna na mane ke doa ke batua sina mane ke doa mua. Iromara koroda sakai sikili kori lodu.” ");
INSERT INTO bgt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Gi a Pita ke veleagna Jisas, “O unuhia vanighami na ghaghana koragna na titiono ko eia eigna na hava ke vagarura na komi tinoni kori matagna a God.” ");
INSERT INTO bgt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A Jisas ke velera, “Ehava? Oti boi thaothadoghagna mua? ");
INSERT INTO bgt_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Na komi fata ke ghania na tinoni ke horu kori kutugna gi e leghua na hanganagna me au kori tonogna. ");
INSERT INTO bgt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Keana na komi fata ke dika ke velea na tinoni ke au mai kori ghaghanagna, me iangeni na hava ke vagarua kori matagna a God. ");
INSERT INTO bgt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Na komi fata ke dika vaghagna iraani kena au mai kori ghaghanagna na tinoni: na komi ghaghana ke dika, na vathehe tinoni, na nere duagna ahai ke boi taugna, na biabilau, na piapilau, ma na haghore diadikalagna na tinoni tavogha. ");
INSERT INTO bgt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Irangeni na komi fata ke vagarura na komi tinoni kori matagna a God. Keana na ghaniagna na vanga kori vido ke boi sikame na tinoni, iangeni ke boi tangomana na vagaruagna kori matagna a God.” ");
INSERT INTO bgt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas duagna nigna na komi vaovarongo kena taveti au kori meleha iangeni mena vano kori nohi ke gharania e rua na meleha i Taia mi Saidon. ");
INSERT INTO bgt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sina vaivinegna i Kenan ke boi Jiu ke mono ngengeni. Iia ke mai tagna a Jisas me ghuu heta vaghagna iaani, “Lod, a dathegna a Deved, o raroviu! Na tidatho ke haghevia a dathegu vaivine mi iia ke papara puala.” ");
INSERT INTO bgt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Keana a Jisas ke boi haghore tughua. Mara na vaovarongo kena mai tagna a Jisas mena veleagna, “O veleagna na vaivine iangeni eigna keda taveti sanighita. Eigna iia ke talu leghughita me ghuvighita hahali.” ");
INSERT INTO bgt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Gi a Jisas ke veleagna na vaivine iangeni, “A God ke vetulau mai bali hathera vamua na komi tinoni Jiu kena vaghadia na komi sip kena taveti sania ahai ke reireghira.” ");
INSERT INTO bgt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Na vaivine ke mai me torongaghi tuturu naghogna a Jisas me veleagna, “Lod, o hatheu!” ");
INSERT INTO bgt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma Jisas ke ania, “Boi toke katida hatia ghadia na vanga na komi gari mati soni vanoa tadia na komi aku.” ");
INSERT INTO bgt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Iia ke haghore tughua, “Tutuni puala! Keana na komi aku ena ado mai mena ghania na pupurumai vanga kena sikili horu saragna na tevo nidia mara kena tonodia.” ");
INSERT INTO bgt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ma Jisas ke ania, “Vaivine, nimua na vaututuni ke heta puala! Na hava ko kaeu, inau kuda eia vanigho.” Kori vido vamua iangeni, a dathegna na vaivine iangeni ke ghoi toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas ke taveti au ingengeni me ghoi tabiru vano kori kolo i Galili. Imanea ke vano hadi tagna sina suasupa me nohe. ");
INSERT INTO bgt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na mavitu sethe kena haidu mai itagna mena hatira mai duadia na komi tinoni kena thehe na naedia, na komi tinoni kena doa, na komi tinoni ke thoki na naedia ba na limadia, na komi tinoni kena mui, mi sethe mua na tinoni kena vahaghi. Imarea kena vaegora kori naegna a Jisas mi manea ke vatoke tabirura gougovu. ");
INSERT INTO bgt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na mavitu kena reghia na hava ke eia a Jisas mena vere nidia puala. Arahai kena mui kena haohaghore, arahai kena thoki na naedia ba na limadia kena ghoi toke tabiru, arahai kena thehe na naedia kena taetaveti, ma arahai kena doa kena ghoi reirei tabiru. Mi marea gougovu kena veletokea nidia God mara Israel. ");
INSERT INTO bgt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas ke kilora mai nigna na komi vaovarongo me velera, “Inau ku rarovira nigua puala na mavitu iraani eigna imarea kena mono duagu tolu ghohi na dani me teo sa ghadia na vanga. Boi tangomana kuda vetulara tabiru kori melehadia kori vido kena rofo. Kenughua ena lae mena sikili kori hangana.” ");
INSERT INTO bgt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nigna na komi vaovarongo kena velea, “Ivei hina katida pada sa vanga kori meleha ke gou eni keda nabadia na mavitu ke sethe iraani?” ");
INSERT INTO bgt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Gi a Jisas ke huatira, “Engiha na bred ke mono itamiu?” Imarea kena haghore tughua, “E vitu na bred me kekeha fei iso vamua.” ");
INSERT INTO bgt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jisas ke velera na mavitu eigna kedana nohe horu kori thepa, ");
INSERT INTO bgt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","gi e hatia na bred ma na fei. Govu, gi e veletokea a God me vidoa, me hera nigna na komi vaovarongo eigna kedana kemulira tadia na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Imarea gougovu kena vanga mena mahu. Gi ena hathatanora na komi viovidoi vanga ke tomagha mena hoghoni vonua e vitu na arao. ");
INSERT INTO bgt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na haidudia mara na mane koragna na mavitu, e vati na togha. Imarea kena boi ijumira na koi vaivine ma na komi gari. ");
INSERT INTO bgt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisas ke vetulara tabiru na mavitu kori melehadia gi e hahaghe kori boti duagna nigna na komi vaovarongo mena vano kori nohi i Magadan. ");
INSERT INTO bgt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sina dani kekeha mara na Farise mi mara na Sadiusi kena mai tagna a Jisas eigna kena magnahaghinia na pipiliagna. Imarea kena kaea eigna keda eia vanira na reghithehe bali adoa a God ke vetula maia. ");
INSERT INTO bgt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jisas ke veleragna, “Kori vido ke huu na aho me mela na maaloa, ighamu koti velea ivughei keda sola. ");
INSERT INTO bgt_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Keana kori vido ke sogala hadi na aho me mela na maaloa, ighamu koti velea kenughua keda uha. Kori vido koti reghia na maaloa, ighamu koti adoa na hava keda tate mai, kari ighamu koti boi adoa na ghaghana ikoragna na komi fata ku eia. ");
INSERT INTO bgt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ighamu na komi tinoni koti havi ikeagaieni, oti dika puala. Ighamu koti magnahaghinia puala na reghiagna na reghithehe. Kari ighamu kotida reghia sina reghithehe vamua ke vaghagna na reghithehe a God ke ei vania a profet Jona.” Govu, gi a Jisas ke taveti au itadia. ");
INSERT INTO bgt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas duagna nigna na komi vaovarongo kena hathavu vano sethevugna na kolo i Galili, kari mara na vaovarongo kena havaghinia na ohoagna ghadia na bred. ");
INSERT INTO bgt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisas ke velera, “Oti reireghi toke ghamu kori isi nidia mara na Farise mi mara na Sadiusi.” ");
INSERT INTO bgt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mara na vaovarongo kena haohaghore ghehedia mena velea, “Imanea ke velea iaani eigna ke teo sa bred itada.” ");
INSERT INTO bgt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas ke adoa na hava kena titionoa me velera, “Nimiu na vaututuni ke boi heta! Ehava gi oti haohaghore varihotaghimiu eigna na havaghiniagna na bred? ");
INSERT INTO bgt_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Oti boi thaothadoghagna mua? Ehava? Oti madoa nimiu ghohi e lima na togha mane ku heraghadia tagna e lima na bred vamua, ma na komi arao koti hoghoni vonua tagna na komi viovidoi vanga ke tomagha? ");
INSERT INTO bgt_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Moti madoa nimiu ghohi e vati na togha mane ku heraghadia tagna e vitu na bred, ma na komi arao koti hoghini vonua tagna na komi viovidoi vanga ke tomagha? ");
INSERT INTO bgt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ehava gi oti boi adoa inau ku boi titiono vanighamu eigna na bred? Oti reireghi toke ghamu kori isi nidia mara na Farise mi mara na Sadiusi.” ");
INSERT INTO bgt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kori vido vamua iangeni imarea kena adoa a Jisas ke boi titionoa eigna na isi bali agutu bred, keana imanea ke magnahaghinira eigna kedana boi leghua na velepuhi nidia mara na Farise mi mara na Sadiusi. ");
INSERT INTO bgt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas ma nigna na komi vaovarongo kena taveti vano kori meleha i Sisaria Filipai. Kori vido kena mai gharania, a Jisas ke huatira, “Kori ghaghanadia na komi tinoni, ahai na Dathei Tinoni na?” ");
INSERT INTO bgt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Imarea kena ania, “Kekeha tinoni kena velea ighoe a Jon Siuvitabu ke havi tabiru. Kekeha kena velea ighoe a profet Elaija, mi kekeha kena velea ighoe a profet Jeremaia ba sina profet tavogha ke mono i hau.” ");
INSERT INTO bgt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jisas ke ghoi huatira, “Ighamu na ba? Ahai oti aniu?” ");
INSERT INTO bgt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita ke veleagna, “Ighoe a Vahavi, a Dathegna God ke havi.” ");
INSERT INTO bgt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Gi a Jisas ke ania, “Saimon, dathegna a Jona, a God ke vatokegho, eigna na hava ko vele aua, a Tamagu i popo ke tateli vanigho, boi na tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Inau kuda kilogho a Pita, ma na ghaghana koragna na aha iangeni, ‘na ghahira.’ Mi popogna na ghahira iaani inau kuda sokaraghinia nigua na kiloau. Ma na mana nigna na thehe keda boi heta pungusia. ");
INSERT INTO bgt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Inau kuda hegho na komi kiigna na hughuta i popo. Na hava koda lutia kori maramagna, God i popo keda lutia. Ma na hava koda lubatia kori maramagna, a God i popo keda lubatia.” ");
INSERT INTO bgt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Gi a Jisas ke haghore heta vanira nigna na komi vaovarongo eigna kedana saghoi veleagna sa tinoni imanea hiri a Vahavi. ");
INSERT INTO bgt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Turugu kori vido iangeni me vano, a Jisas ke titionoa tadia nigna na komi vaovarongo imanea keda vano i Jerusalem me titiono mua na hava keda kathea ngengeni. Imanea ke velea mara na naghoi pris mi mara na velepuhigna na vetula nigna a Moses duadia kekeha mara puhi kedana vapara mena vathehea, kari kori vatolugna na dani imanea keda sokara tabiru kori thehe. ");
INSERT INTO bgt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Keana a Pita ke hatia a Jisas moro vano tagna ke korogha me haghore peoa. Pita ke veleagna, “Lod, teo keda kathegho na hava ko titionoa!” ");
INSERT INTO bgt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma Jisas ke rei vano tagna a Pita me veleagna, “Satan, o taveti saniu! Ighoe ko magnahaghinia kuda jefe tagna na vanohehe nigna a God. Na komi fata ko velea ke boi mai tagna a God, kari na ghaghanadia vamua na komi tinoni.” ");
INSERT INTO bgt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Gi a Jisas ke velera nigna na komi vaovarongo, “Gi ahai ke magnahaghinia keda nigua na vaovarongo, imanea keda saghoi eia na komi fata ke magnahaghinia ghehegna. Imanea keda leghuu hahali me mono kaikaliti bali papara me thehe kori ghaibabala. ");
INSERT INTO bgt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Arahai kena boi leghuu inau eigna kena magnahaghinia na eiagna vamua na hava kena magnahaghinia, imarea kedana boi hatia na havi ke teo na govugna. Kari arahai kena sasaa na papara ma na thehe eigna kena leghuu inau, imarea kedana hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Gi ahai ke tonogna na komi fata ke sethe kori maramagna, kari e boi tonogna na havi ke teo na govugna, kenughua na komi fata irangeni e hathea mua? Teo! Eigna imanea boi tangomana keda volia na havi ke teo na govugna kori nigna na komi fata ke tonogna. ");
INSERT INTO bgt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Inau, na Dathei Tinoni, kuda ghoi tabiru mai duadia nigua na komi enjel kori mana ma na silada nigna a Tamagu. Kori vido iangeni inau kuda hera na taba tadia arahai kena eia na komi fata ke toke, mu vaparara arahai kena eia na komi fata ke dika. ");
INSERT INTO bgt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kekeha itamiu koti mono duagu ikeagaieni, ighamu kotida boi thehe moti ghieghilei reghiu inau, na Dathei Tinoni, kuda ghoi tabiru mai mu vunagi pungusira nigua na komi tinoni.” ");
INSERT INTO bgt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Leghugna e ono na dani, a Jisas ke hatia a Pita duadia romara tamatahi Jemes ma Jon, mena vano ghehedia kori suasupa ke hadi. ");
INSERT INTO bgt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tolu na mane vaovarongo kena rei vano mena reghia na dodorogna a Jisas ke tughu. Turughu kori langegna me horu kori luagna ke siasilada vaghagna na aho. Ma nigna na pohe ke pura me siasilada puala. ");
INSERT INTO bgt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Gi a Moses ma Elaija koro tate mai moro urungu duagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma Pita ke veleagna a Jisas, “Lod, toke puala kiti mono duamiu eeni! Koda magnahaghinia, inau kuda agutua e tolu na aava, sikei nimua ighoe, sikei nigna a Moses me sikei nigna a Elaija.” ");
INSERT INTO bgt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kori vido a Pita ke haohaghore mua, na parako ke siasilada ke mai popodia me ungahira, ma na haghore ke au mai kori parako, “Iaani a pukuni dathegu ku dothovia puala. Oti vaovarongo itagna.” ");
INSERT INTO bgt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tolu na mane vaovarongo kotolu mataghu puala motolu nere ulu horu kori thepa. ");
INSERT INTO bgt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","A Jisas ke mai itadia me tangolira me velera, “Oti sokara hadi moti saghoi mataghu.” ");
INSERT INTO bgt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tolumara kotolu tada hadi mena reghia a Jisas vamua ke mono duadia. ");
INSERT INTO bgt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kori vido Jisas duagna tolu nigna na mane vaovarongo kena horu mai kori suasupa, a Jisas ke haghore heta vanira, “Otolu saghoi veleagna ahai na hava kotolu reghia me ghieghilei jufu mai na dani inau, na Dathei Tinoni, kuda havi tabiru kori thehe.” ");
INSERT INTO bgt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Gi tolu na mane vaovarongo kotolu huatiagna a Jisas, “Ehava gi mara na velepuhigna na vetula nigna a Moses kena velea a profet Elaija keda kidi mai gi e mai a Vahavi? Kari ighoe o kidi mai nimua ghohi.” ");
INSERT INTO bgt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A Jisas ke haghore tughura, “Tutuni puala a Elaija keda kidi mai me kaikalitira na mavitu eigna na maigna a Vahavi. ");
INSERT INTO bgt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kari inau ku veleghamu a Elaija e mai nigna ghohi kari na mavitu kena boi ghithatha imanea. Imarea kena leghua vamua na ghaghanadia ghehedia mena vapara mena vathehea. Mi nau, na Dathei Tinoni, imarea kedana eia vaghagna mua iangeni itagua.” ");
INSERT INTO bgt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kori vido iangeni e tolu nigna na vaovarongo kotolu adoa a Jisas ke titiono vanira eigna a Jon Siuvitabu. ");
INSERT INTO bgt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kori vido a Jisas duagna tolu nigna na vaovarongo kena horu mai kori suasupa, na mavitu ke sethe kena pitura. Sina mane tadia na mavitu ke mai tagna a Jisas me torongaghi tuturu horu itagna me veleagna, ");
INSERT INTO bgt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Lod, o rarovia a dathegu mane. Na tonogna ke ado kakai me aiariri. Imanea ke pukuni papara puala. Sethe na maghavu imanea ke sikili kori joto ba na bea. ");
INSERT INTO bgt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inau ku hati vanoa ghohi tadia nimua na komi vaovarongo, keana imarea kena boi tangomana nidia na vatokeagna.” ");
INSERT INTO bgt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A Jisas ke ania, “Ighamu na komi tinoni dika. Oti boi vaututuniu! Sethe na maghavu ghohi ku mono duamiu. Ingiha gi kotida vaututuniu? Oti hati maia na gari itagua!” ");
INSERT INTO bgt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma Jisas ke haghore heta vania na tidatho ke haghevia me taveti au itagna. Kori vido vamua iangeni na gari ke ghoi toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Leghugna iangeni, na komi vaovarongo kena mai ghehedia tagna a Jisas mena huatia, “Ehava gi iti boi tangomana na gigi auagna na tidatho iangeni?” ");
INSERT INTO bgt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ma Jisas ke haghore tughura, “Nimiu na vaututuni ke boi nabagna na gigi auagna. Inau ku veleghamu, toke nimiu na vaututuni keda iso puala vaghagna na katuragna na ghai mastad, ighamu tangomana kotida veleagna na suasupa iangeni, ‘O riu vano kori vido iangeni,’ ma na suasupa keda riu vano. Teo sa fata keda vahothahaghinighamu gi kotida vaututuni.” ");
INSERT INTO bgt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sina dani, leghugna kena tabiru vano i Galili, a Jisas ke velera nigna na komi vaovarongo, “Inau, na Dathei Tinoni, sina mane keda perou kori limadia mara nigua na thevuioka. ");
INSERT INTO bgt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Imarea kedana vatheheu, kari kori vatolugna na dani inau kuda havi tabiru kori thehe.” Kori rongoviagna na haghore iangeni, nigna na komi vaovarongo kena dikahehedia hutu puala. ");
INSERT INTO bgt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","A Jisas duagna nigna na komi vaovarongo kena jufu mai i Kapaneam. Gi mara bali ohoa na takisigna na Vathe ke Tabu kena mai tagna a Pita mena huatia, “Ehava? Nimua na mane velepuhi ke ado volia na takisigna na Vathe ke Tabu ba teo?” ");
INSERT INTO bgt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A Pita ke haghore tughura, “Hii, imanea ke volia.” Leghugna iangeni a Pita ke haghe vano kori vathe ma Jisas ke kidi huati maia vaghagna iaani, “Saimon Pita, ehava na ghaghanamu na? Na komi king kori maramagna kena hatia nidia na takis tadia ara dathedia ba tadia na komi tinoni tavogha?” ");
INSERT INTO bgt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","A Pita ke veleagna, “Tadia na komi tinoni tavogha.” Ma Jisas ke ania, “Tutuni. Ma na vunegna iroghita ara dathegna a God na king, e toke vamua iroghita koroda boi volia na takisi iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Keana na vunegna kati bosi magnahaghinia mara bali oho takis kedana dikatadia, o vano kori kolo mo tatagho. Na fei koda kidi saraka, o hangavia na livogna mo koda reghipada sikei na siliva. O hatia mo vano volia roda na takisigna na Vathe ke Tabu.” ");
INSERT INTO bgt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kori vido iangeni, nigna na komi vaovarongo a Jisas kena mai itagna mena huatia, “Ahai ke pukuni nagho tadia na komi tinoni a God ke vunaghi pungusira?” ");
INSERT INTO bgt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A Jisas ke kilo maia na gari iso me vasokaraghinia itadia. ");
INSERT INTO bgt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Gi e veleragna, “Inau ku veleghamu, gi kotida boi tughua na havimiu ke koakoa moti boi mono taluleghu vaghadia na komi gari, teo kotida mono duadia na komi tinoni a God ke vunaghi pungusira. ");
INSERT INTO bgt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Keana ahai ke mono taluleghu vaghagna na gari iaani, imanea ke pukuni nagho vano tadia na komi tinoni gougovu a God ke vunaghi pungusira. ");
INSERT INTO bgt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ahai ke kalitia sa tinoni ke vaghagna na gari iaani eigna ke leghuu inau, imanea ke kalitiu inau. ");
INSERT INTO bgt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ahai keda vajefea nigna na vaututuni sa tinoni vaghagna na gari iaani, imanea ke dika puala. E toke gi kedana taria na ghahira hutu kori luagna mena vabilomoa kori tahi, eigna na hava a God keda eia itagna keda tahu vano tagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Rarovira puala na komi tinonigna na maramagna iaani. Eigna sethe na fata ke tangomana na vajefeagna nidia na vaututuni. Na komi fata ke ado vajefera na komi tinoni kedana mono thovohaliu, kari ahai keda vajefea sa tinoni, a God keda pukuni vapara. ");
INSERT INTO bgt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Gi na limamu ba na naemu keda vajefea nimua na vaututuni, o utuhi aua mo sonia. E toke keda mono sikei na limamu ba sikei na naemu vamua, kari o hatia na havi ke teo na govugna. E boi toke keda mono rua na limamu ba rua na naemu, kari a God ke sonigho vano kori joto ke ghatha thovohaliu. ");
INSERT INTO bgt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Gi sikei na matamu keda vajefea nimua na vaututuni, o sipa aua mo sonia. E toke keda mono sikei na matamu vamua kari o hatia na havi ke teo na govugna. E boi toke keda mono e rua na matamu kari a God keda sonigho vano kori joto kori meleha papara.” ");
INSERT INTO bgt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","A Jisas ke ghoi velea, “Oti reireghi toke ghamu eigna e boi toke gi kotida toatogha sikei tinoni tadia arahai kena leghuu inau ke boi nagho. Inau ku veleghamu, nidia na komi enjel kena mono hahali duagna a Tamagu i popo. ");
INSERT INTO bgt_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ehava? Gi sina mane keda tonogna sina hathangatui sip me hahi sikei itadia, na hava keda eia na mane iangeni? Imanea keda talu horura e hia hangavulu me hia na sip kori suasupa kena vanga itagna me vano hiroa sikei ke hahi. ");
INSERT INTO bgt_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","E tutuni na hava ku veleghamu, kori vido ke reghipada, nigna na totogo eigna na sip iangeni keda hutu vano tagna nigna na totogo eidia e hia hangavulu me hia na sip kena boi hahi. ");
INSERT INTO bgt_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","A Tamamiu i popo ke vaghagna iangeni ghua. Imanea ke bosi magnahaghinia sikei tadia nigna na komi tinoni keda jefe itagna. ");
INSERT INTO bgt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Gi sa tinoni ke vaututuni ghua keda eia na fata ke dika itamua, o vano ghehemu itagna mo veleagna na hava ke ei hahia. Gi keda rongovigho me tughuhehe, ighoe ko hati tabiru tagna a God a kulamu kori vaututuni. ");
INSERT INTO bgt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Keana gi keda boi rongovigho, o ghoi tabiru itagna mo hatia duamu sikei be rua na tinoni. Eigna na komi Rioriso ke Tabu kena velea, ‘Gi koda toroagna sa tinoni, e rua be tolu na tinoni keda mono bali velea na hava ko titionoa e tutuni.’ ");
INSERT INTO bgt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Gi keda talu boi rongovigho, o vano mo titonoa tadia na komi tinoni kiloau. Leghugna iangeni, gi keda boi rongovia na hava kena velea na komi tinoni kiloau, o saghoi mono haidu duagna vaghagna ighoe ko boi mono haidu duadia mara bongihehe mi mara na oho takis kena dika. ");
INSERT INTO bgt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Inau ku veleghamu, na hava koti lutia kori maramagna, God i popo keda lutia. Ma na hava koti lubatia kori maramagna, a God i popo keda lubatia. ");
INSERT INTO bgt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Inau ku ghoi veleghamu, gi e rua na tinoni koro vaututuni koroda magnahaghinia sina fata moro tarai kaea, a Tamagu i popo keda eia vanira. ");
INSERT INTO bgt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Imanea keda hera, eigna ivei kedana haidu bali tarai e rua be tolu na tinoni kena leghuu inau, inau kuda mono duadia.” ");
INSERT INTO bgt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","A Pita ke mai tagna a Jisas me huatia, “Lod, gi sina tinoni ke vaututuni keda ei vaniu na fata ke dika, engiha horui talutavoghagna na paluhagna kuda eia? E vitu?” ");
INSERT INTO bgt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","A Jisas ke haghore tughua, “Boi e vitu, kari e vitu hangavulu me vitu. ");
INSERT INTO bgt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Inau ku haghore vaghagna iaani eigna na hughuta i popo ke vaghagna na titiono eigna sina king ke magnahaghinia na hatiagna na rongo kena koania itagna kekeha nigna na mane agutu. ");
INSERT INTO bgt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kori vido na king ke turughu hati tabirua nigna na rongo, nigna na komi soldia kena hati maia itagna sina nigna na mane agutu ke kaonia e salaghe na togha i gol. ");
INSERT INTO bgt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na vunegna ke hutu puala na rongo iangeni, imanea ke boi tangomana na tughu tabiruagna. Ma na king ke velera nigna na komi soldia eigna kedana hatia imanea duagna a taugna mara dathegna ma na nigna na komi fata gougovu. Imanea ke velera eigna kedana salemura bali tughua nigna na rongo. ");
INSERT INTO bgt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Na mane iangeni ke torongaghi tuturu horu itagna na king me kae huhurua vaghagna iaani, ‘O raroviu mo pitu sina vido. Inau kuda tughu tabirua nimua na komi rongo gougovu.’ ");
INSERT INTO bgt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na king ke rarovia imanea me veleagna e toke vamua keda boi tughu tabirua na rongo ke kaonia itagna. Gi e lubatia mamaluha. ");
INSERT INTO bgt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Leghugna ke taveti au, na mane iangeni ke pada sina mane agutu mua ke kaonia sina hathangatu i siliva itagna. Imanea ke thotia me pognoia na luagna me ania, ‘O tughu tabirua na rongo ko koania itagua!’ ");
INSERT INTO bgt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ma na mane agutu iangeni ke torongaghi tuturu horu itagna me kae huhurua vaghagna iaani, ‘O raroviu mo pitu sina vido. Inau kuda tughu tabirua na rongo ku koania itamua.’ ");
INSERT INTO bgt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Keana imanea ke bosi sasaa na pituagna me vano velera mara puhi eigna kedana boa na mane iangeni kori vathe tatari me ghieghilei tughu tabirua nigna na koani. ");
INSERT INTO bgt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Kekeha nigna na mane agutu na king kena rongovia na hava ke eia na mane iangeni mena dikahehedia. Imarea kena vano tagna na king mena veleagna na hava ke eia imanea. ");
INSERT INTO bgt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Na king ke kilo tabiru maia nigna na mane agutu me veleagna, ‘Ighoe na mane agutu ko dika puala! Inau ku rarovigho gi u vathehea govua nimua na kaoni eigna ko kaeu. ");
INSERT INTO bgt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eigna na hava gi o boi rarovia na mane ke kaonia itamua vaghagna inau ku rarovigho na?’ ");
INSERT INTO bgt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na king ke dikatagna puala me velera nigna na komi soldia eigna kedana boa haghea imanea kori vathe tatari mena vapara me ghieghilei tughu tabirua nigna na kaoni.” ");
INSERT INTO bgt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Gi a Jisas ke velera, “Vaghagna iangeni a Tamagu i popo keda eia vanighamu kotida boi talutavogha kori hehemiu doudolu na paluhagna sa tinoni ke vaututuni mua.” ");
INSERT INTO bgt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Leghugna a Jisas ke vagovua nigna na titiono iangeni, imanea ke au sania na provins i Galili me taveti vano kori provins i Jiudea sethevugna na bea hutu i Jodan. ");
INSERT INTO bgt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na mavitu ke sethe kena leghua, mi manea ke vatoke tabirura arahai kena vahaghi itadia. ");
INSERT INTO bgt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kekeha mara na Farise kena mai tagna a Jisas eigna kena magnahaghinia na pilauniagna. Imarea kena huatia, “Ehava? Na komi vetula nigna a Moses ke lubatia na mane keda sonia a taugna eigna ke magnahaghinia vamua?” ");
INSERT INTO bgt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A Jisas ke haghore tughura, “Inau ku adoa ighamu koti ijumia ghohi tadia na komi Rioriso ke Tabu, kori turughugna na maramagna a God ke vavuha na mane ma na vaivine. ");
INSERT INTO bgt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma God ke velea, ‘Na vunegna iaani na mane keda taveti sania a tamagna ma idogna me mono haidu duagna a taugna. Mi roira koroda sikei vamua na tinoni.’ ");
INSERT INTO bgt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iroira koro boi e rua na tinoni, kari oro sikei vamua. Na vunegna iangeni, e boi toke na tinoni keda sonia a taugna. Saghoi thevurua na hava a God ke tari haidura ghohi.” ");
INSERT INTO bgt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Gi mara na Farise kena huatia a Jisas, “Gi keda ai na, ehava gi a Moses ke lubatia na mane keda sonia a taugna gi keda risoa ghohi na pepagna na veisonighi?” ");
INSERT INTO bgt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma Jisas ke velera, “A Moses ke lubatia na veisonighi eigna ke pono puala na ulumiu. Keana kori turughugna, a God ke bosi magnahaghinia keda ai. ");
INSERT INTO bgt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Inau ku veleghamu, na mane keda sonia a taugna me taulaghi tagna sina vaivine tavogha, imanea ke ghoho. Keana gi a taugna keda ghohoa, imanea keda tangomana na soniagna.” ");
INSERT INTO bgt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Gi nigna na komi vaovarongo a Jisas kena velea, “Gi iangeni vamua na vunegna na mane keda sonia a taugna, e toke na komi tinoni kedana boi taulaghi.” ");
INSERT INTO bgt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A Jisas ke anira, “Boi na komi tinoni gougovu kedana tangomana na leghuagna na velepuhi iaani, kari arahai vamua a God ke hathera eigna kedana leghua. ");
INSERT INTO bgt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kekeha mane kena boi taulaghi eigna kena kara, mi kekeha eigna imarea kena sogira eigna kedana boi mono gari. Mi kekeha tinoni kena boi taulaghi eigna kena magnahaghinia vamua kedana agutu vania a God. Arahai kena tangomana na leghuagna na velepuhi iaani, e toke imarea kedana leghua.” ");
INSERT INTO bgt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kekeha tinoni kena talangira mai na komi gari tagna a Jisas eigna keda taboa na uludia me tarai eidia. Keana mara na vaovarongo kena ngarara mena lutira arahai kena hatira mai. ");
INSERT INTO bgt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kari a Jisas ke velera, “Oti lubatira mai na komi gari itagua moti saghoi lutira eigna na komi tinoni a God ke vunaghi pungusira, imarea vaghadia na komi gari iraani.” ");
INSERT INTO bgt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Gi e taboa na uludia me vatabura. Leghugna iangeni a Jisas ke taveti au tagna na meleha iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sina mane pada rongo ke mai tagna a Jisas me huatia, “Velepuhi, na hava na fata ke toke kuda eia bali hatia na havi ke teo na govugna na?” ");
INSERT INTO bgt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A Jisas ke haghore tughua, “Ehava gi o huatiu eigna na hava ke toke? Ighoe ko adoa ghohi a God vamua ke toke. Keana gi koda magnahaghinia na hatiagna na havi ke teo na govugna, o leghura nigna na komi vetula a God.” ");
INSERT INTO bgt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Gi na mane iangeni ke ghoi huatia, “Na hava nigna na komi vetula kuda leghura na?” Ma Jisas ke veleagna, “Saghoi vathehea na tinoni, saghoi ghoho, saghoi bilau, saghoi vuha haghoregna ahai, ");
INSERT INTO bgt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ghaghana bohea a tamamu ma idomu, mo dothovira arahai tavogha vaghagna vamua ighoe ko dothovigho ghehemu.” ");
INSERT INTO bgt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ma na mane mathangani iangeni ke veleagna a Jisas, “Na komi vetula irangeni, inau ku leghura gougovu ghohi. E mono mua sa fata kuda eia?” ");
INSERT INTO bgt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","A Jisas ke ania, “Gi koda magnahaghinia na mono jino kori matagna a God, o vano mo salemua na komi fata gougovu ko tonogna, kari o hatia na rongodia mo kemulia itadia mara kena kuma. Gi koda eia iangeni, ighoe koda tonogna na komi fata ke toke i popo. O vano eia iangeni, gi o mai leghuu inau.” ");
INSERT INTO bgt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kori vido na mane mathangani ke rongovia iaani, imanea ke dikahehegna puala eigna ke sethe puala na komi fata ke tonogna. Me taveti sania a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Gi a Jisas ke velera nigna na komi vaovarongo, “Inau ku veleghamu, e vahothahaghinira puala na komi tinoni kena pada rongo kedana haghe kori hughuta i popo. ");
INSERT INTO bgt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ehava? Tangomana mua na kamel keda haghe vano kori katogna na nili? Vahotha puala! Keana e vahotha vano mua tagna ahai ke padarongo keda haghe vano kori hughuta nigna a God.” ");
INSERT INTO bgt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kori rongoviagna na haghore iaani, mara na vaovarongo kena vere nidia puala mena velea, “Keda vahotha puala na hatiagna na havi ke teo na govugna tagna na tinoni ke pada rongo, ahai keda tangomana na?” ");
INSERT INTO bgt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A Jisas ke rei vano itadia me velera, “Tadia na komi tinoni e vahotha puala, keana a God ke tangomana na eiagna vanira na komi tinoni na komi fata kena boi tangomana na eiagna ghehedia.” ");
INSERT INTO bgt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Gi a Pita ke veleagna, “Ighami kiti taveti sania nimami na komi fata miti leghugho. Na hava na taba a God keda heghami na?” ");
INSERT INTO bgt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma Jisas ke anira, “Inau ku veleghamu, kori vido inau, na Dathei Tinoni, kuda nohe kori nigua na sapei vunaghi mu vunagi pungusira na komi tinoni kori maramagna mathangani, ighamu nigua na komi vaovarongo kotida nohe tadia salaghe rua na sapei vunaghi moti vunaghi pungusira e salaghe rua na vikegna i Israel. ");
INSERT INTO bgt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ahai keda taveti sania na vathegna ba ara tahigna ba ara vaivinegna ba a tamagna ba a idogna ba a taugna ba ara dathegna ba nigna na thepa eigna ke leghuu inau, a God keda hea sethe mua na komi fata iraani ke taveti sania. Mi manea keda hatia mua na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kari sethe na tinoni kena nagho ikeagaieni kedana leghu, me sethe kena leghu ikeagaieni kedana nagho.” ");
INSERT INTO bgt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","A Jisas ke velera nigna na komi vaovarongo, “Na hughuta i popo ke vaghagna sina mane ke tonogna na gnatha. Kori vuevughei puni, imanea ke taveti au eigna keda hirora kekeha tinoni bali agutu kori nigna na gnatha. ");
INSERT INTO bgt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Imanea ke padara kekeha me velera keda volira na rongo nabagna na agutu sina dani. Gi imanea ke vetulura vano kori nigna na gnatha mena agutu. ");
INSERT INTO bgt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Nabagna tangi hia kori vuevughei, imanea ke ghoi taveti au me reghira kekeha tinoni kena hai mono kori vido bali makete. ");
INSERT INTO bgt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Imanea ke velera, ‘Gi kotida vano moti agutu kori nigua na gnatha, inau kuda volighamu na hava ke nabagna na agutu kotida eia.’ ");
INSERT INTO bgt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mi marea kena vano mena agutu. “Kori tangi salaghe rua mi kori tangi tolu kori hinaota lavi, imanea ke ghoi taveti au me padara kekeha tinoni bali agutu. ");
INSERT INTO bgt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kori tangi lima kori lavi, imanea ke ghoi taveti au me reghira kekeha tinoni kena hai mono me huatira, ‘Ehava gi oti hai mono eeni moti boi eia sa agutu na dani doudolu?’ ");
INSERT INTO bgt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Imarea kena ania, ‘Eigna teo ahai ke kaeghami eigna kitida agutu vania.’ “Mi manea ke velera, ‘Oti vano moti agutu duadia arahai kena agutu ghohi kori nigua na gnatha.’ ");
INSERT INTO bgt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kori lavigna na dani iangeni, na mane ke tonogna na gnatha ke veleagna na mane ke reireghira na komi tinoni agutu, ‘O kilora mai na komi tinoni agutu eigna koda volira. Kari o kidi volira arahai kena turughu agutu kori lavi me jufu tadia arahai kena kidi agutu.’ ");
INSERT INTO bgt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kori vido na komi tinoni kena turughu na agutu kori tangi lima kori lavi kena mai, imarea kena hatia na rongo nabagna na agutu sina dani. ");
INSERT INTO bgt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na vunegna iangeni, kori vido na komi tinoni kena kidi agutu kena mai, imarea kena toatogha kedana hatia na rongo ke hutu vano tagna iangeni. Keana imarea kena hatia na rongo ke nanaba vamua. ");
INSERT INTO bgt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Leghugna kena hatia nidia na rongo, imarea kena dikatadia tagna na mane ke tonogna na gnatha mena veleagna, ");
INSERT INTO bgt_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Na komi tinoni irangeni kena agutu koragna sina aoa vamua, kari ighami kiti agutu miti papara kori aho na dani doudolu. Keana ighoe ko volira nanaba vamua tagna na hava ko volighami!’ ");
INSERT INTO bgt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Imanea ke veleagna sikei tadia, ‘Kulagu, inau ku boi pilaunigho. Gi o agutu vaniu, ighoe ko hiia na hava ku velegho kuda voligho. ");
INSERT INTO bgt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","O hatia nimua na rongo mo vano. Inau ku magnahaghinia kuda volia na tinoni ke turughu na agutu kori lavi nanaba vamua tagna na hava ku voligho. ");
INSERT INTO bgt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ehava? E boi jino kuda hea nigua na rongo leghuagna na ghaghanagu na? Ighoe ko tahotha eigna ku eia na fata ke toke vanira arahai kena boi agutu dani doudolu?’” ");
INSERT INTO bgt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Gi a Jisas ke velea, “Vaghagna iangeni, arahai kena leghu ikeagaieni, imarea kedana nagho. Ma arahai kena nagho ikeagaieni, imarea kedana leghu.” ");
INSERT INTO bgt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kori vido a Jisas duagna salaghe rua nigna na komi vaovarongo kena taetaveti vano i Jerusalem, imanea ke talangira au kori hangana eigna kedana mono ghehedia me velera, ");
INSERT INTO bgt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Oti vaovarongo toetoke. Ighita katida atu hadi i Jerusalem, gi sina tinoni keda perou inau, na Dathei Tinoni, kori limadia mara na naghoi pris mi mara na velepuhigna na vetula nigna a Moses. Imarea kedana fateu bali vatheheu, ");
INSERT INTO bgt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","gi ena ghoi lubatiu vano tadia mara kena boi Jiu eigna kedana kihaghiniu mena thabuhiu mena tupipuhiu kori ghaibabala. Kari, kori vatolugna na dani inau kuda ghoi havi tabiru kori thehe.” ");
INSERT INTO bgt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","A taugna a Jebedi duagna e rua dathegna, Jemes ma Jon, kena mai tagna a Jisas. Iia ke torongaghi tuturu horu itagna a Jisas eigna keda kaea sina fata. ");
INSERT INTO bgt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisas ke huatia, “Na hava ko magnahaghinia?” Iia ke haghore tughua, “Kori maghavu koda vunaghi pungusira na komi tinoni, inau ku magnahaghinia koda lubatira e rua a dathegu eigna koroda vunaghi pungusira duamu. Sikei keda nohe kori madothomu mi sikei kori toimu.” ");
INSERT INTO bgt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ma Jisas ke veleragna, “Otolu boi adoa na hava koti kaeu. Ehava romara? Tangomana koroda papara vaghagna kuda eia inau?” Romara koro veleagna, “Hii! Tangomana mua kuruda eia!” Ma Jisas ke velera, “Tutuni puala! Roghamu koroda papara vaghagna kuda eia inau, ");
INSERT INTO bgt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","kari inau boi tangomana kuda vahira arahai kedana nohe kori madothogu ma na toigu kori vido kuda vunaghi pungusira na komi tinoni. A God ghehegna vamua keda velera arahai kedana nohe duagu eigna imanea ke vahira ghohi.” ");
INSERT INTO bgt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kori vido mara salaghe na vaovarongo kena rongovia na hava koro kaea, imarea kena dikatadia tadia a Jemes ma Jon. ");
INSERT INTO bgt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","A Jisas ke kilora mai mara nigna na vaovarongo gougovu itagna me velera, “Ighamu oti adoa ghohi na koi vunaghidia mara kena boi Jiu kena magnahaghinia na hururagna nidia na mavitu bali eia na hava kena magnahaghinia. ");
INSERT INTO bgt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kari oti saghoi eia vaghagna iangeni. Ahai ke magnahaghinia keda baubatu itamiu, imanea keda agutu vanighamu. ");
INSERT INTO bgt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma ahai ke magnahaghinia keda nagho itamiu, imanea keda agutu vanighamu vaghagna na tinoni seka. ");
INSERT INTO bgt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Oti leghua na puhigu, eigna inau, na Dathei Tinoni, u bosi mai kori maramagna eigna kedana agutu vaniu na mavitu. Keana inau ku mai bali agutu vanira, mu kuda thehe bali vamamaluhara na komi tinoni tagna na komi paluhadia.” ");
INSERT INTO bgt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na mavitu ke sethe ke leghua a Jisas kori vido imanea duagna nigna na komi vaovarongo kena au sania i Jeriko. ");
INSERT INTO bgt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","E rua na mane koro doa koro nohe ghaghireigna na hangana. Romara koro rongovia na rorongogna a Jisas ke halu atu moro ghuu heta, “Lod, dathegna Deved, o rarovighami!” ");
INSERT INTO bgt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Sethe na tinoni kena veleragna eigna koroda bughoro, kari romara koro ghoi ghuu heta vano mua, “Lod, dathegna Deved, o rarovighami!” ");
INSERT INTO bgt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","A Jisas ke sokara soto me kilora mai, gi e huatira, “Na hava koro magnahaghinia kuda eia vanighamu?” ");
INSERT INTO bgt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mi romara koro veleagna, “Lod, roghami kuru magnahaghinia kuruda ghoi reirei tabiru.” ");
INSERT INTO bgt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ma Jisas ke rarovira me tabora vano na matadia. Kori vido vamua iangeni, romara koro ghoi reirei tabiru moro leghua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kori vido a Jisas ma na nigna na komi vaovarongo kena taveti vano i Jerusalem, imarea kena kidi mai kori meleha i Betpej tagna na Suasupa i Ghai Olev. A Jisas ke vetulara vano tagna na meleha iangeni e rua nigna na mane vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Gi e vetulara, imanea ke anira, “Roghamu oro vano kori meleha iangeni mo koroda reghia sina dongki ke piniti ma a dathegna ke sokara hilighagna. Oro unuhira moro hatira mai itagua. ");
INSERT INTO bgt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Gi ahai keda huatighamu eigna na fata koro eia, oro veleagna, ‘A Lod ke magnahaghinira.’ Mi manea keda lubatira vanighamu eigna koroda hatira mai.” ");
INSERT INTO bgt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iaani ke tate mai eigna keda tutuni na hava a God ke velea sina profet i hau, ");
INSERT INTO bgt_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Iaani na hava koda velera na komi tinonidia i Jerusalem kori suasupa i Saion. ‘Oti reghia, nimiu na king ke mai itamiu ikeagaieni. Imanea ke mono taluleghu me taetaveti popogna na dongki, Tutuni, imanea ke taetaveti popogna na dathei dongki.’” ");
INSERT INTO bgt_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Gi e rua nigna na vaovarongo koro vano eia vaghagna a Jisas ke kidi velera ghohi. ");
INSERT INTO bgt_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Romara koro hatira mai e rua na dongki moro valiagna rodia na oopo itagna na dathei dongki ma Jisas ke hahaghe itagna. ");
INSERT INTO bgt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sethe na tinoni kena valia nidia na oopo kori hangana tagna keda halu atu a Jisas, me kekeha kena toka na komi tubo mena tutua kori hangana. ");
INSERT INTO bgt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na komi tinoni kena taveti naghogna mi leghugna a Jisas kena ngingili, “Hosana, veletokea a Dathegna a Deved! God, o vathaba imanea ke mai duagna nimua na mana! Veletokea a God i popo!” ");
INSERT INTO bgt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kori haghegna vano a Jisas i Jerusalem, na mavitu gougovu tagna na meleha iangeni kena totogo mena lealea mi kekeha itadia kena huahuati vaghagna iaani, “Ahai hina ke mai iaani?” ");
INSERT INTO bgt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma na mavitu kena velera, “Iaani a Jisas, na profetgna i Nasaret kori provins i Galili.” ");
INSERT INTO bgt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas ke vano haghe kori Vathe ke Tabu nigna a God me gigi aura arahai kena voivoli ma arahai kena salemua na komi fata ikoragna. Imanea ke koli poghora na komi tevo nidia mara kena tughu rongo bali volia na takisigna na Vathe ke Tabu, ma na komi sape kena nohe mara kena salemua na komi bora bali havughaghi. ");
INSERT INTO bgt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma Jisas ke haghore vanira, “Na komi Rioriso ke Tabu kena velea, ‘Nigua na Vathe ke Tabu na vathe bali tarai.’ Kari ighamu koti eia vaghagna na vido bali monodia mara kena biabilau.” ");
INSERT INTO bgt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Gi kekeha tinoni kena doa mi kekeha kena thehe na naedia kena mai tagna a Jisas kori Vathe ke Tabu, mi manea ke vatoke tabirura gougovu. ");
INSERT INTO bgt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mara kena nagho tadia mara pris mi mara na velepuhigna na vetula nigna a Moses kena dikatadia kori vido kena reghia na komi reghithehe ke eia a Jisas mena rongovira na komi gari kena ngingili koragna na Vathe ke Tabu, “Veletokea a Dathegna a Deved!” ");
INSERT INTO bgt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mena huatia a Jisas, “Ehava? O rongovia na hava kena velea na komi gari irangeni? E boi jino!” Ma Jisas ke anira, “Hii, inau ku rongovira. Keana ehava? Oti boi ijumia na rioriso ke mono tadia na komi Rioriso ke Tabu kena velea a God keda hathera na komi gari ma na komi meomeo eigna kedana veletokea?” ");
INSERT INTO bgt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Leghugna iangeni a Jisas ke taveti au kori meleha i Jerusalem me tabiru vano i Betani me nere ngengeni. ");
INSERT INTO bgt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kori vuevugheigna, a Jisas duagna nigna na komi vaovarongo kena ghoi taveti vano i Jerusalem ma Jisas ke rofo. ");
INSERT INTO bgt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Imanea ke reghia na ghai fig ke sokara kori ghaghirei hangana me vano itagna bali hatia na sagharogna. Kari e teo sa sagharogna ke mono, na eloelogna vavaha vamua. Ma Jisas ke haghore leghua, “Teo koda ghoi sagharo mua!” Kori vido vamua iangeni na ghai fig ke gho'e horu. ");
INSERT INTO bgt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mara na vaovarongo kena vere nidia mena velea, “Ehava gi e gho'e saisami na ghai fig iaani?” ");
INSERT INTO bgt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma Jisas ke velera, “Inau ku veleghamu, gi kotida vaututuni moti boi ghaghana ruarua, ighamu tangomana kotida eia vaghagna ku ei vania na ghai fig, me boi iangeni vamua. Ighamu tangomana kotida veleagna na suasupa iangeni, ‘O sokara mo vano mono kori tahi.’ Ma na suasupa iangeni keda leghua na haghoremiu. ");
INSERT INTO bgt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gi kotida vaututuni kori vido koti tarai kaea sa fata tagna a God, imanea keda eia vanighamu na hava koti kaea.” ");
INSERT INTO bgt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kori vido kena jufu vano i Jerusalem, a Jisas ke vano haghe kori Vathe ke Tabu me velepuhira na mavitu. Mara na naghoi pris mi kekeha mara puhidia mara Jiu kena mai mena huatiagna, “Ahai ke velegho na gigi auragna na komi tinoni kori Vathe ke Tabu? Ahai ke hegho na mana gi o eia na komi fata iraani?” ");
INSERT INTO bgt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","A Jisas ke haghore tughura, “Inau kuda kidi huatighamu sina huahuati. Gi kotida haghore tughuu, inau kuda veleghamu ahai ke heu na mana gi u eia na komi fata iraani. ");
INSERT INTO bgt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ahai ke hea na mana a Jon Siuvitabu bali siuvitabura na mavitu? A God ba na tinoni vamua?” Imarea kena haohaghore ghehedia vaghagna iaani, “Gi ighita katida veleagna a God ke hea na mana, imanea keda veleghita, ‘Ehava gi oti boi vaututunia na komi velepuhi nigna a Jon na?’ ");
INSERT INTO bgt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Keana gi katida velea na tinoni ke hea na mana, da na mavitu kedana dikatadia me rihughita, eigna imarea kena vaututunia a Jon sina pukuni nigna profet a God.” ");
INSERT INTO bgt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Na vunegna iangeni, imarea kena haghore tughua, “Ighami kiti boi adoa.” Ma a Jisas ke anira, “Na vunegna koti boi haghore tughuu, inau kuda boi veleghamu ahai ke heu na mana gi u eia na komi fata iraani.” ");
INSERT INTO bgt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Gi a Jisas ke velera mara puhidia mara Jiu, “Oti kidi rorongo mai tagna na titiono velepuhi iaani, gi oti veleu na ghaghanamiu. Sina mane ke mono e rua dathegna mane. Imanea ke titiono vania a dathegna ke havi nagho vaghagna iaani, ‘Dathegu, dani iaani o vano mo agutu kori gnatha.’ ");
INSERT INTO bgt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A dathegna ke veleagna, ‘Teo, bosi nigua.’ Keana leghugna ke velea iangeni, imanea ke tughua na hehegna me vano me agutu kori gnatha. ");
INSERT INTO bgt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Gi a tamadia ke vano tagna a dathegna ke havi leghu me veleagna eigna keda vano me agutu kori gnatha. Imanea ke velea, ‘Hii, inau kuda vano agutu.’ Keana leghugna iangeni, imanea ke boi vano.” ");
INSERT INTO bgt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Gi a Jisas ke huatira, “Ahai tadia romara tamatahi ke leghua na haghoregna a tamadia na?” Imarea kena haghore tughua, “A dathegna ke havi nagho.” Ma Jisas ke velera, “Inau ku veleghamu, mara na oho takis kena dika ma na koi vaivine kikirase kedana kidi haghe nagho itamiu kori hughuta nigna a God. ");
INSERT INTO bgt_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Eigna kori vido a Jon Siuvitabu ke mai bali tateli vanighamu na puhi havi ke jino kotida leghua, mara na oho takis ma na koi vaivine kikirase kena vaututunia, kari ighamu koti boi vaututunia. Toke koti reghia imarea kena vaututunia, ighamu koti boi tughua na havimiu ke koakoa moti boi vaututunia a Jon.” ");
INSERT INTO bgt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas ke ghoi anira, “Oti vaovarongo tagna na titiono velepuhi iaani. Sina mane tono thepa ke joua na komi ghai grep kori nigna na gnatha. Govu, gi e agutua na peo ma na vido bali pojiagna na komi grep bali agutu waen. Gi e sokaraghinia na vathe bali kaekale. Govu, gi e hirora kekeha tinoni bali agutu me reireghia nigna na gnatha. Imanea ke velera eigna kedana hatia kekeha sagharogna na ghai grep vaghagna na volidia. Leghugna iaani, imanea ke taveti au me vano mono tagna sina meleha ke hau. ");
INSERT INTO bgt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Kori vido ke jufungia na maghavu ke ghano na komi grep, imanea ke vetula kekeha nigna na mane agutu eigna kedana hati maia itagna na thevugna na komi sagharo ke nigna. ");
INSERT INTO bgt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Keana mara kena reireghia na gnatha kena thotira mena tupia sikei, vathehea sikei, mena piria sikei. ");
INSERT INTO bgt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Leghugna iangeni na mane ke tonogna na gnatha ke ghoi vetulara kekeha nigna na mane agutu. Mara iraani ke sethe vano tadia mara kena kidi vano. Keana mara kena reireghia na gnatha kena eia vanira vaghagna vamua kena eia ghohi tadia mara kena kidi vano. ");
INSERT INTO bgt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Vagovugna, imanea ke vetula a pukuni dathegna eigna imanea ke ghaghana imarea kedana ghaghana bohea. ");
INSERT INTO bgt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Keana, kori vido imarea kena reireghia na gnatha kena reghia a dathegna, imarea kena velea varihotaghidia, ‘Iaani na mane keda tonogna na gnatha leghugna keda thehe a tamagna. Gi katida vathehea, ighita katida tonogna na gnatha.’ ");
INSERT INTO bgt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Gi ena thotia mena hati aua kosigna na gnatha mena vathehea.” ");
INSERT INTO bgt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Gi a Jisas ke huatira mara na naghoi pris mi mara puhidia mara Jiu, “Kori vido ke tabiru na mane ke tonogna na gnatha, na hava keda eia tadia mara kena reireghi vania na?” ");
INSERT INTO bgt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Imarea kena velea, “Imanea keda vathehera na komi tinoni ke dika iangeni me lubatira mara tavogha eigna kedana reireghia nigna na gnatha. Imarea irangeni kedana hea na mane ke tonogna na gnatha kekeha sagharogna na ghai grep kori vido kena vihukira.” ");
INSERT INTO bgt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Gi a Jisas ke velera, “Ehava? Oti boi ijumia mua na hava kena risoa tagna na komi Rioriso ke Tabu? ‘Na ghahira kena boi magnahaghinia mara kena agutu vathe, ikeagaieni na ghahira iaani na naghoi ghahira tadia na komi ghahira kori hidigna na vathe. A God ke eia na fata iaani me toke puala itamami.’ ");
INSERT INTO bgt_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Inau ku veleghamu, i hau a God ke vahighamu ighamu na komi tinoni Jiu eigna keda vunagi pungusighamu. Keana imanea keda tughughamu me keda vunagi pungusira na komi tinoni kedana eia na hava ke magnahaghinia. ");
INSERT INTO bgt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ahai keda pejuraghi tagna na ghahira iangeni, imanea keda purungongojo, ma ahai na ghahira iangeni keda sikili popogna, imanea keda baka.” ");
INSERT INTO bgt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kori vido mara na naghoi pris mi mara na Farise kena rongovira na komi titiono velepuhi iraani, imarea kena adoa a Jisas ke titionora mena dikatadia. ");
INSERT INTO bgt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Imarea kena magnahaghinia na thotiagna a Jisas, keana imarea kena mataghunira na mavitu eigna na mavitu kena vaututunia a Jisas sina profet nigna a God. ");
INSERT INTO bgt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","A Jisas ke ghoi titiono vanira mara puhidia mara Jiu me velera sina titiono velepuhi mua. ");
INSERT INTO bgt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Imanea ke velera, “Na hughuta i popo ke vaghagna na king ke eia na vangahaidu hutu kori vido ke sonihaidua a dathegna mane. ");
INSERT INTO bgt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kori vido ke kaikaliti ghohi na komi fata, imanea ke vetulara nigna na komi mane agutu eigna kedana velera na komi tinoni ke hulaghinira ghohi eigna kedana mai. Keana imarea kena boi nidia na mai kori vangahaidu. ");
INSERT INTO bgt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Gi na king ke vetulara kekeha mua nigna na mane agutu me velera, ‘Oti vano moti velera na komi tinoni ku hulaghinira ghohi eigna kedana mai saisami. Kekeha nigua na kau kena vathehera ghohi ma na komi vanga ke mono kaikaliti ghohi!’ ");
INSERT INTO bgt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Keana kori vido kena vano, na komi tinoni kena hulaghinira kena boi rongovira mena eia vamua nidia na fata kena magnahaghinia ghehedia. Kekeha kena vano kori ghadia na gnatha, kekeha kena vano tadia na komi vido kena agutu, ");
INSERT INTO bgt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","mi kekeha kena thotira nigna na komi mane agutu na king. Imarea kena thabuhira mena vathehera. ");
INSERT INTO bgt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Na king ke dikatagna puala me vetulara nigna na komi soldia mena vathehera gougovu arahai kena vathehera nigna na komi mane agutu. Gi ena pughulira na komi vathe kori melehadia. ");
INSERT INTO bgt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ma na king ke velera kekeha mua nigna na komi mane agutu, ‘Na vangahaidu ke kaikaliti ghohi, keana na komi tinoni ku hulaghinira ghohi kena boi naba kedana mai. ");
INSERT INTO bgt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Moti vano au tadia na komi hangana hutu moti kilora mai kori vangahaidu arahai koti padara ngengeni.’ ");
INSERT INTO bgt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Nigna na komi mane agutu na king kena taveti au mena hatira mai na komi tinoni dika ma na komi tinoni toke kena padara. Na vathe kena vangahaidu itagna ke vonu. ");
INSERT INTO bgt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kori vido ke mai na king bali reghira arahai kena mai, imanea ke reghia sina mane ke pipisia na pohe ke boi nabagna na vangahaidugna na sonihaidu. ");
INSERT INTO bgt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma na king ke veleagna, ‘Kulagu, ehava gi o haghe mai eeni? Eigna ighoe ko pipisia na pohe ke boi nabagna na vangahaidugna na sonihaidu.’ Ma na mane iangeni ke mono bughoro vamua. ");
INSERT INTO bgt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Na king ke velera nigna na komi mane agutu, ‘Oti thotia moti taria na naegna ma na limagna moti soni vanoa kori meleha ke puni. Ingengeni na komi tinoni kedana dikahehe mena tangi mena gigiri kei.’” ");
INSERT INTO bgt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Gi a Jisas ke velea, “Sethe na tinoni a God ke hulaghinira, keana boi sethe a God ke vahira.” ");
INSERT INTO bgt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Leghugna iangeni mara na Farise kena haidu mena vapuhia eigna kedana pilaunia a Jisas. Imarea kena magnahaghinia a Jisas keda velea sa fata ke boi jino eigna kedana fatea. ");
INSERT INTO bgt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Imarea kena vetulara vano tagna a Jisas kekeha nidia na mane vaovarongo duadia kekeha tinoni Jiu kena leghua a King Herod. Imarea kena veleagna, “Velepuhi, ighami kiti adoa na komi fata ko velea ke jino meke tutuni. Kari o velepuhira na mavitu na komi fata a God ke magnahaghinia kedana eia. O boi mataghunia na hava kena ghaghana na mavitu eimu ighoe. Toke kedana boi magnahaghinia nimua na velepuhi, ighoe ko velepuhi vamua na hava ke tutuni eigna a God. ");
INSERT INTO bgt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Na vunegna iangeni, ighami kiti magnahaghinia na rongoviagna na ghaghanamu. Ehava? E jino kori nida na vetula katida volia na takis tagna na King gna i Rom ba teo?” ");
INSERT INTO bgt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","A Jisas ke adoa imarea kena haga pilaunia me velera, “Ighamu na komi tinoni piapilau! Ehava gi oti magnahaghina na pilauniugna eigna kuda velea sa fata ke boi jino? ");
INSERT INTO bgt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Oti tateli vaniu mai sikei na sileni bali voli takis.” Imarea kena hea vano sikei itagna, ");
INSERT INTO bgt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ma Jisas ke huatira, “Oti veleu, ahai na totoghalegna ma na ahagna ke mono itagna?” ");
INSERT INTO bgt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Imarea kena haghore tughua, “Na King gna i Rom.” Jisas ke velera, “Hea na King gna i Rom na hava ke tonogna, moti hea a God na hava ke tonogna.” ");
INSERT INTO bgt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kori vido kena rongovia nigna na haghore tughu, imarea kena vere nidia puala mena taveti sania. ");
INSERT INTO bgt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kori dani iangeni kekeha mara na Sadiusi kena mai tagna a Jisas. Imarea kena boi vaututunia na komi tinoni kedana havi tabiru leghugna na thehe. Imarea kena ania, ");
INSERT INTO bgt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Velepuhi, a Moses ke risoa gi na mane keda thehe sania a taugna me teo mua sa dathegna, a tahigna keda taulaghi itagna na vaivine ke thehe a taugna eigna keda boa na gari itagna bali vavusua na pagusugna a toghagna ke thehe. ");
INSERT INTO bgt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","I hau, mara vitu tamatahi kena mono tamami ghami eeni. Na mane ke havi nagho ke taulaghi me thehe, kari e teo sa dathegna. Na vunegna iangeni, a tahigna imanea ke ghoi taulaghi tagna na vaivine ke thehe sania a taugna. ");
INSERT INTO bgt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Imanea huju ke thehe me teo sa dathegna. Ma na vatolugna tadia mara tamatahi ke taulaghi tagna me nanaba vamua. Vano me mara vitu tamatahi gougovu kena taulaghi tagna na vaivine iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Vagovugna, na vaivine ke thehe. ");
INSERT INTO bgt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","O veleghami, kori vido a God keda vasokaraghini tabirura arahai kena thehe, ahai itadia mara tamatahi irangeni keda taugna na vaivine iangeni? Eigna mara vitu tamatahi gougovu kena taulagi tagna.” ");
INSERT INTO bgt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","A Jisas ke velera, “Oti pukuni hahi tutuni! Ighamu koti boi talu adoa na komi Rioriso ke Tabu moti bosi thaothadoghagna a God ke mana puala. ");
INSERT INTO bgt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Leghugna a God keda vasokaraghini tabirura na komi tinoni kena thehe, imarea kedana boi taulaghi, vaghadia na komi enjel kena mono i popo. ");
INSERT INTO bgt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ikeagaieni inau kuda velepuhighamu eigna na sokara tabiru kori thehe. Ehava? Oti boi ijumia na hava a God ke veleghamu tadia na komi Rioriso ke Tabu eigna na havi tabiru kori thehe? Imanea ke velea, ");
INSERT INTO bgt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Inau na nidia na God a Ebraham, a Aisak ma Jekob.’ Tolumara kotolu thehe ghohi i hau, kari tagna a God tolumara kotolu havi mua. A God, boi na God nidia arahai kena thehe ghohi, kari nidia na God arahai kena havi.” ");
INSERT INTO bgt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kori vido na mavitu kena rongovia iaani, imarea kena vere nidia puala tagna nigna na velepuhi. ");
INSERT INTO bgt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kori vido kena rongovia a Jisas ke vamaomamora mara na Sadiusi, mara na Farise kena haidu bali vapuipuhi eigna na hava kedana eia. ");
INSERT INTO bgt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sikei itadia ke adoa puala na komi vetula nigna a Moses. Imanea ke vano tagna a Jisas eigna keda pilaunia me huatia, ");
INSERT INTO bgt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Na hava na vetula nigna a Moses ke nagho vano tadia na komi vetula gougovu?” ");
INSERT INTO bgt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma Jisas ke velea, “‘Oti dothovia a Lod na nimiu a God kori havimiu gougovu, kori tarungamiu gougovu, mi kori ghaghanamiu gougovu.’ ");
INSERT INTO bgt_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iangeni na vetula ke nagho vano tadia na komi vetula gougovu. ");
INSERT INTO bgt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na varuagna na vetula ke nagho iaani: ‘Dothovira na komi tinoni vaghagna ko dothovigho ghehemu.’ ");
INSERT INTO bgt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","E rua na vetula iraani ke kuikuvira na komi vetula gougovu nigna a Moses ma na komi rioriso nidia mara na profet.” ");
INSERT INTO bgt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kori vido mara na Farise kena talu mono mua ngengeni, a Jisas ke huatira, ");
INSERT INTO bgt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Na hava ke mono kori ghaghanamiu eigna a Vahavi na? Imanea a vinahuhugna ahai?” Imarea kena ania, “Na vinahuhugna a King Deved.” ");
INSERT INTO bgt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Gi a Jisas ke velea, “Gi keda tutuni iangeni, ehava gi a Deved ke velea iaani kori vido na Tarunga ke Tabu ke batua na ghaghanagna, ");
INSERT INTO bgt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘A God ke veleagna na vunaghigu, O nohe kori thevu madothogu me jufu kori maghavu kuda talu horua nimua na komi thevuioka i thepa eigna koda vunaghi pungusira.’ ");
INSERT INTO bgt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Deved ke kiloagna a Vahavi na vunaghigna. Gi imanea na vunaghigna a Deved, ehava gi imanea na vinahuhugna a Deved mua?” ");
INSERT INTO bgt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kori vido iangeni, teo sikei tadia mara na Farise ke haghore tughua. Turughu kori dani iangeni teo sa tinoni ke mathaghai na huatiagna a Jisas eigna sa fata mua. ");
INSERT INTO bgt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jisas ke titiono tadia na mavitu ma na nigna na komi vaovarongo. Imanea ke velera, ");
INSERT INTO bgt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nidia agutu mara na velepuhigna na vetula nigna a Moses mi mara na Farise, na unuhiagna na ghaghana koragna na komi vetula nigna a Moses. ");
INSERT INTO bgt_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Na vunegna iangeni, ighamu kotida leghua na komi fata kena velepuhighamu. Keana oti saghoi leghua na puhidia. Eigna imarea ghehedia kena boi leghua na hava kena velepuhighamu. ");
INSERT INTO bgt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Imarea kena velepuhira na komi tinoni na komi vetula ke sethe ke vahotha puala na leghuragna. Kari imarea kena boi eia sa fata bali hathera eigna kedana leghura. ");
INSERT INTO bgt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Na komi fata kena eia mara na velepuhigna na vetula nigna a Moses mi mara na Farise, imarea kena eia vamua eigna na mavitu kedana reghira mena veletokera. Imarea kena vahutura na fata bali boa na komi Rioriso ke Tabu ikoradia mena taria kori limadia mi kori langedia. Mena vatevea na komi piru kena taria kori kujukugna nidia na pohe. ");
INSERT INTO bgt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tadia na komi vangahaidu mi tadia na komi vathe haidu, imarea kena magnahaghinia puala kedana nohe tadia na komi naghoi sape. ");
INSERT INTO bgt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kori vido kena vano kori makete, imarea kena magnahaghinia na komi tinoni kedana veletokera mena kilora ‘Velepuhi.’ ");
INSERT INTO bgt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Keana oti saghoi magnahaghinia ahai keda kiloghamu ‘Velepuhi,’ eigna inau vamua nimiu na velepuhi. Mi ghamu gougovu koti mono nanaba vaghagna na komi tamatahi kena mono nanaba. ");
INSERT INTO bgt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Moti saghoi ghaghana bohea sa mane velepuhi kori maramagna kori kiloagna, ‘Mama.’ Eigna ighamu kotida ghaghana bohea vamua a Tamamiu ke mono i popo. ");
INSERT INTO bgt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Oti saghoi lubatia ahai keda kiloghamu ‘Vunaghi,’ eigna inau vamua, a Vahavi, nimiu na vunaghi. ");
INSERT INTO bgt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ahai ke magnahaghinia keda nagho itamiu, imanea keda mono taluleghu me agutu vanira arahai tavogha. ");
INSERT INTO bgt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ahai keda vahaihadia ghehegna, a God keda vahorua. Ma ahai keda vahouhorua ghehegna, a God keda vahaihadia. ");
INSERT INTO bgt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“A God keda vaparaghamu ighamu mara na velepuhigna na vetula nigna a Moses mi ghamu mara na Farise! Ighamu koti eia vaghagna koti jino, kari oti boi jino! Kori nimiu na velepuhi, ighamu koti vajefera na komi tinoni eigna kedana boi lubatia a God keda vunaghi pungusira. Ighamu koti boi lubatia a God eigna keda vunaghi pungusighamu moti vajefera arahai kena magnahaghinia a God keda vunagi pungusira! ");
INSERT INTO bgt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Tutuni, a God keda pukuni vaparaghamu ighamu mara na velepuhigna na vetula nigna a Moses mi ghamu mara na Farise! Ighamu koti eia vaghagna koti jino, kari oti boi jino! Ighamu koti taveti ivei mi vei kori maramagna eigna kotida pada sikei na tinoni ke boi Jiu ke magnahaghinia na leghuagna nimiu na velepuhi. Mi kori vido imanea ke leghua nimiu na velepuhi, na puhigna ke dika vano tagna na puhimiu. Imanea ke nabagna keda vano kori meleha papara. ");
INSERT INTO bgt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ighamu koti vaghagna na mane ke doa ke batura na komi tinoni. A God keda vaparaghamu eigna ighamu koti velera na komi tinoni, ‘Gi ahai keda jijighi kori ahagna na Vathe ke Tabu kari e boi eia na hava ke jijighia, e toke vamua. Keana gi ahai keda jijighi tagna na gol ke mono kori Vathe ke Tabu, imanea keda eia na hava ke jijighia.’ ");
INSERT INTO bgt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ighamu oti doa moti hahi puala! Na Vathe ke Tabu nigna a God ke nagho vano tagna na gol ke mono ikoragna, eigna na Vathe ke Tabu na hava ke vatabua na gol. ");
INSERT INTO bgt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Moti velea mua, ‘Gi ahai keda jijighi kori olta, kari e boi eia na hava ke jijighia, e toke vamua. Keana gi ahai keda jijighi tagna na fata bali havughaghi ke mono popogna na olta, imanea keda eia na hava ke jijighia.’ ");
INSERT INTO bgt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ighamu koti doa! Na olta ke nagho vano tagna na fata bali havughaghi eigna na olta na hava ke vatabua na fata bali havughaghi. ");
INSERT INTO bgt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na vunegna iangeni, ahai ke jijighi tagna na olta, imanea ke jijighi mua tagna na hava ke mono popogna. ");
INSERT INTO bgt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma ahai ke jijighi tagna na ahagna na Vathe ke Tabu, imanea ke jijighi mua tagna na ahagna a God, eigna a God ke mono ikoragna. ");
INSERT INTO bgt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ahai ke jijighi vano i popo, imanea ke jijighi mua tagna na sapei vunaghi nigna a God me jijighi mua tagna na ahagna a God, eigna God ke nohe popogna na sape iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Tutuni, a God keda pukuni vaparaghamu ighamu mara na velepuhigna na vetula nigna a Moses mi ghamu mara na Farise! Ighamu koti eia vaghagna koti jino, kari oti boi jino! Ighamu koti hea a God na vasalaghegna nimiu na komi fata gougovu, toke keda hutu ba iso. Keana ighamu koti boi leghua na komi fata ke nagho tadia na komi vetula nigna a Moses. Ighamu koti boi eia na hava ke jino vanira na komi tinoni, moti boi hathera arahai kena papara, moti boi sokara ngasi tagna a God. Na heagna a God na vasalaghegna nimiu na komi fata, na fata ke toke. Keana inau ku magnahaghinighamu kotida eia na komi fata ke nagho vano tagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ighamu koti vaghagna na mane ke doa ke batura na komi tinoni. Ighamu koti agutu heta bali leghua na komi vetula ke iso kari oti havaghinia na komi vetula ke nagho. Ighamu koti vaghagna na tinoni ke agutu heta bali hati aua na thothovo ke iso kori kap bea, kari imanea ke kouvia na tonogna na kamel. ");
INSERT INTO bgt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Tutuni, a God keda pukuni vaparaghamu ighamu mara na velepuhigna na vetula nigna a Moses mi ghamu mara na Farise! Ighamu koti eia vaghagna koti jino, kari oti boi jino! Ighamu koti vaghagna na tinoni ke lumi toetokea vamua kosigna na kapu ma na tapera. Eigna na dodorogna kosigna na havimiu ke toke, kari koragna na havimiu ke vonungia na gumao ma na ghaghana bali eia na hava keda vatotogoghamu ghehemiu. ");
INSERT INTO bgt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ighamu mara na Farise koti vaghagna na tinoni ke doa. Oti kidi lumi toetokea koragna na kapu ma na tapera gi na kosigna keda raraha mua. ");
INSERT INTO bgt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Tutuni, a God keda pukuni vaparaghamu ighamu mara na velepuhigna na vetula nigna a Moses mi ghamu mara na Farise! Ighamu koti eia vaghagna koti jino, kari oti boi jino! Ighamu koti vaghagna na komi beku kena peda pura. Na dodordia i kosi ke toke, kari ikoradia na komi beku ke vonungia na hulidia na komi tinoni ma na komi fata ke boto. ");
INSERT INTO bgt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ighamu koti vaghagna vamua iangeni, eigna na dodoromiu ke toke puala kori matadia na komi tinoni, kari na havimiu ke vonungia na piapilau ma na koakoa. ");
INSERT INTO bgt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Tutuni, a God keda pukuni vaparaghamu ighamu mara na velepuhigna na vetula nigna a Moses mi ghamu mara na Farise! Ighamu koti eia vaghagna koti jino, kari oti boi jino! Na vunegna ighamu koti magnahaghinia na komi tinoni kedana toatogha na puhimiu ke jino, ighamu koti agutu toetokera na bekudia mara na profet kena vathehera ara hutumiu i hau. Moti gnilaura na bekudia na komi tinoni jino kena vathehera mua. ");
INSERT INTO bgt_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Moti velea gi kotida havi kori vido ara hutumiu kena havi, ighamu kotida boi hathera kori vido kena vathehera mara na profet. ");
INSERT INTO bgt_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kori vido koti velea iangeni, ighamu koti tateli aua na puhimiu ke dika vaghagna na puhidia ara hutumiu kena vathehera mara na profet. ");
INSERT INTO bgt_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na vunegna iangeni, oti vano moti vagovua na fata ke dika kena turughua i hau ara hutumiu. ");
INSERT INTO bgt_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ighamu koti dika vaghagna na komi poli! E vahothahaghinighamu kotida ghogho sania na papara a God ke boa eimiu ighamu kori meleha papara. ");
INSERT INTO bgt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Oti rorongo toetoke! Inau kuda vetulara atu itamiu mara na profet mi mara kena thaothadogha mi mara na velepuhi. Ighamu kotida vathehera kekeha, tupipuhira kekeha kori ghaibabala, thabuhira kekeha tadia na komi vathe haidu moti pajira kekeha tadia na komi meleha bali vadiadikalara. ");
INSERT INTO bgt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na vunegna kotida eia vaghagna iangeni, a God keda vaparaghamu eigna na vatheheragna nigna na komi tinoni jino, turughu tagna na tinoni jino a Ebol me jufu tagna Sakaria, a dathegna a Barakia. Ighamu mara Jiu koti vathehea na mane iangeni hotaghigna na olta ma na Vathe ke Tabu nigna a God. ");
INSERT INTO bgt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","E tutuni na hava ku veleghamu. A God keda vaparaghamu ighamu koti havi ikeagaieni eidia na komi fata ke dika irangeni.” ");
INSERT INTO bgt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Gi a Jisas ke velea, “Jerusalem, Jerusalem! Ighoe ko pirira na komi profet mo vathehera arahai a God ke vetulara atu itamua. Sethe na maghavu inau ku magnahaghinia kuda hathegho, vaghagna na kokorako vaivine ke hathatanora ara dathegna sarai baghigna me reireghira. Kari ighoe ko boi lubatiu gi kuda hathegho. ");
INSERT INTO bgt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ikeagaieni a God ke taveti sanigho me au sania nigna na Vathe ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Inau ku velegho, ighoe koda boi reghiu me ghieghilei jufu kori dani ighoe koda velea, ‘God, o vatokea imanea ke mai duai nimua na mana.’” ");
INSERT INTO bgt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kori vido a Jisas ke au sania na Vathe ke Tabu, nigna na komi vaovarongo kena mai mena veleagna eigna keda reghia na Vathe ke Tabu ma na komi vathe hilighagna kena toetokelaghadia puala. ");
INSERT INTO bgt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma Jisas ke veleragna, “Oti reghia mua na komi vathe irangeni? Inau ku veleghamu, tagna na dani keda mai, teo sikei ghahira keda mono kori mathagna vaghagna kena mono ikeagaieni. Imarea kedana reo horura na komi hidi gougovu.” ");
INSERT INTO bgt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Leghugna iangeni, kori vido a Jisas ke nohe kori Suasupa i Ghai Olev, nigna na komi vaovarongo kena mai ghehedia itagna mena velea, “O veleghami, ingiha kedana reo horua na Vathe ke Tabu nigna a God iangeni? Na hava na vaughithatha kitida reghia bali adoa ighoe koda ghoi tabiru mai ma na vagovugna na maramagna ke gharani mai ghohi?” ");
INSERT INTO bgt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ma a Jisas ke anira, “Oti reireghi toke ghamu, kenughua e pilaunighamu sa tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Eigna sethe na tinoni kedana mai mena velea, ‘Inau a Vahavi,’ me sethe na tinoni kedana vaututunira. ");
INSERT INTO bgt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ighamu kotida rongovia na rorongogna na komi rihu hutu, kari oti saghoi mataghu. Toke keda tutuni na komi fata iraani, boi na vagovugna na maramagna mua. ");
INSERT INTO bgt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Sethe na meleha kori maramagna kedana riurihu varihotaghidia me sethe na tinoni kedana thehe eigna ke teo sa ghadia vanga, ma na komi agnu keda agnu tadia na komi meleha. ");
INSERT INTO bgt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Na komi fata iraani na turughugna vamua na papara keda mai. ");
INSERT INTO bgt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kori vido iangeni, na komi tinoni ivei mi vei kori maramagna kedana thevuioka itamiu eigna koti leghu inau. Imarea kedana thotighamu mena vaparaghamu mena vatheheghamu. ");
INSERT INTO bgt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sethe na tinoni keda luvu nidia na vaututuni. Imarea kedana boi veimagnahaghinighi me kedana veilubatighi tadia nidia na komi thevuioka. ");
INSERT INTO bgt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Sethe mara velepuhi piapilau kedana mai me kedana batu hahira na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na vunegna sethe na tinoni kedana ei hahalia na komi fata ke dika, imarea kedana boi dothovira arahai tavogha. ");
INSERT INTO bgt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Keana ahai keda sokara ngasi kori nigna na vaututuni me ghieghilei jufu kori vagovugna, imanea keda hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma na Rorongo ke Toke eigna nigna na hughuta a God, imarea kedana titionoa ivei mi vei kori maramagna ma na komi tinoni gougovu kedana rongovia. Leghugna iangeni, na vagovugna na maramagna keda mai.” ");
INSERT INTO bgt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Gi a Jisas ke velea, “Kori dani keda mai, ighamu kotida reghia na fata ke dika vano a profet Daniel ke titionoa i hau. Na fata iangeni keda sokara kori Vathe ke Tabu nigna a God tagna bali boi monogna. Na vunegna iangeni, a God keda korogha sania nigna na Vathe ke Tabu. (Arahai kena ijumia na haghore iaani, oti hiohiro toetokea na pukuni ghaghanagna.) ");
INSERT INTO bgt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kori dani iangeni, gi kotida mono kori provins i Jiudea, oti ghogho hadi tadia na komi suasupa. ");
INSERT INTO bgt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Gi kotida mono kosigna na vathe, saghoi raghe haghe bali hatia kekeha nimiu na fata. ");
INSERT INTO bgt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gi kotida agutu kori gnatha, saghoi tabiru bali hatia nimiu oopo. ");
INSERT INTO bgt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kori vido iangeni, na mataghu keda padara na koi vaivine kena boebote ma arahai kena susuua mua a dathedia eigna kenughua vahotha puala na ghoghodia. ");
INSERT INTO bgt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Oti tarai kaea a God eigna keda boi mono mai na komi fata irangeni kori vido ke mai na koburu ba kori Sabat. ");
INSERT INTO bgt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Eigna na papara kori vido iangeni keda dika vano tadia na komi papara ke mono mai ghohi kori maramagna. Leghugna iangeni, teo mua sa fata vaghagna iangeni keda ghoi mono mai. ");
INSERT INTO bgt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na vunegna a God ke dothovira nigna na mavitu, imanea keda hati aua kekeha dani papara. Gi keda boi hati aua imanea kekeha dani papara, teo sa tinoni keda havi. ");
INSERT INTO bgt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Gi ahai keda veleghamu, ‘Na mane iaani a Vahavi!’ ba ‘Na mane iangeni a Vahavi!’ oti saghoi vaututunia. ");
INSERT INTO bgt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sethe na tinoni piapilau kedana velea, ‘Inau a Vahavi,’ me sethe mara na profet piapilau kedana mai mua. Imarea kedana eia na komi reghithehe bali pilaura me vajefera arahai a God ke vahira ghohi, kari boi tangomana nidia. ");
INSERT INTO bgt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Oti reireghi toke ghamu! Inau ku veleghamu na komi fata iraani gi ena jufu mai. ");
INSERT INTO bgt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Gi ahai keda veleghamu, ‘Oti rorongo itagua! A Vahavi ke mono kori meleha ke gou,’ oti saghoi vano. Gi ahai keda veleghamu, ‘Imanea ke polo eeni,’ oti saghoi vaututunia. ");
INSERT INTO bgt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Eigna na komi tinoni gougovu kedana adoa kori vido inau, na Dathei Tinoni kuda ghoi tabiru mai. Na tabirugu mai keda tate aua toetoke vaghagna na onga ke palaku ke tate au kori manga turughu i eta me jufu i paka. ");
INSERT INTO bgt_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mati adoa, tagna ke mono na fata ke thehe, na komi manu hutu kena haidu ngengeni. ");
INSERT INTO bgt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Gi a Jisas ke velera, “Leghugna na komi papara iraani, ‘Na aho keda boi raraha, ma na vula keda puni, ma na komi vaitughu kedana sikili horu mai i popo. Ma na komi fata gougovu kori maaloa kedana ghaighali.’ ");
INSERT INTO bgt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Leghugna iangeni, na komi tinoni gougovu kori maramagna kedana reghia na vaughithatha kori maaloa keda tateli aua inau, na Dathei Tinoni kuda tabiru mai. Kori vido iangeni, imarea gougovu kedana tangi. Imarea kedana reghiu inau kuda tabiru mai kori parako duai mana ke heta ma na silada. ");
INSERT INTO bgt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mi kori tangigna na tavuli, inau kuda vetulara au komi nigua na enjel itadia na komi meleha gougovu kori maramagna eigna kedana hathatanora mai na komi tinoni a God ke kidi vahira ghohi.” ");
INSERT INTO bgt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","A Jisas ke ghoi velera, “Oti reghia na ghai fig eigna keda velepuhighamu. Gi kotida reghia na ghai fig ke dudu me turughu vusu, ighamu koti adoa ke haga sagharo ghohi. ");
INSERT INTO bgt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Vaghagna mua iangeni, kori vido na komi papara keda jufu mai, ighamu kotida adoa inau ku gharani mai ghohi. ");
INSERT INTO bgt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Inau ku veleghamu, na komi fata iraani keda kidi jufu mai gi na komi tinoni kena mono ikeagaieni kedana thehe. ");
INSERT INTO bgt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Na thepa ma na maaloa keda govu, kari nigua na komi haghore keda boi govu. ");
INSERT INTO bgt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Teo ahai ke adoa na dani ba na aoa keda jufu mai na komi fata irangeni. Mara na enjel ena boi adoa. Inau u boi adoa. Sikei vamua a Tamagu ke adoa. ");
INSERT INTO bgt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kori vido inau, na Dathei Tinoni kuda tabiru mai, na havidia na komi tinoni keda vaghagna vamua na havidia na komi tinoni kori vido ke mono a Noa. ");
INSERT INTO bgt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tadia na komi dani irangeni na komi tinoni kena vanga mena kou mena taulaghi. Imarea kena eia na komi fata iraani me ghieghilei jufu kori dani a Noa ke hahaghe kori vaka. ");
INSERT INTO bgt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Imarea kena boi toatogha sa fata keda kathera, gi na biringita ke mai me vathehera gougovu. Vaghagna iangeni ghua na hava keda tate mai kori vido inau, na Dathei Tinoni kuda tabiru mai. ");
INSERT INTO bgt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Kori vido iangeni e rua na mane koroda agutu kori gnatha. A God keda hati au sikei me talua sikei. ");
INSERT INTO bgt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","E rua na vaivine koroda kaikaliti vanga. Ma a God keda hati aua sikei me talua sikei. ");
INSERT INTO bgt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Na vunegna iaani, oti reireghi toke ghamu moti mono kaikaliti eigna ighamu oti boi adoa ingiha inau, nimua na vunaghi, kuda ghoi tabiru mai. ");
INSERT INTO bgt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Oti ghaghana toke iaani: Na tinoni ke tonogna na vathe ke boi adoa na maghavu keda mai na mane bilau. Gi keda adoa, imanea keda rarai thovohaliu me boi lubatia na mane bilau keda haghe kori vathegna. ");
INSERT INTO bgt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Vaghagna iangeni, oti mono kaikaliti hahali eigna inau, na Dathei Tinoni, kuda tabiru mai kori vido ighamu koti boi adoa.” ");
INSERT INTO bgt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jisas ke ghoi velera, “Ahai na mane agutu ke toke me ke thaothadogha? Imanea na mane agutu na vunaghi keda lubatia vania na reireghiagna kekeha mara nigna na mane agutu eigna keda heraghadia kori vido kedana vanga. ");
INSERT INTO bgt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ma na mane agutu iangeni keda totogo kori vido na vunaghigna keda tabiru mai me reghia imanea ke ei tokea nigna na agutu. ");
INSERT INTO bgt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Inau ku veleghamu, kenughua na vunaghigna keda lubatia vania na reireghiagna komi nigna na fata gougovu. ");
INSERT INTO bgt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Gi keda dika na mane agutu iangeni, da imanea keda toatogha vaghagna iaani, ‘Na vunaghigu keda boi tabiru mai saisami.’ ");
INSERT INTO bgt_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mi imanea ke turughu thabuhira na komi tinoni agutu ke reireghira, me vanga me kou memee duadia arahai kena thauthavu na koudia. ");
INSERT INTO bgt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na vunaghigna keda tabiru mai kori maghavu na mane agutu iangeni ke boi pitua me boi kaikaliti eigna. ");
INSERT INTO bgt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ma na vunaghigna keda pukuni diadikala na mane agutu iangeni, me vetula vano bali papara duadia arahai kena eia vaghagna kena jino kari ena boi jino. Imarea kedana dikahehe mena tangi mena gigiri kei ingengeni.” ");
INSERT INTO bgt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","A Jisas ke velera nigna na komi vaovarongo, “Kori vido inau kuda ghoi tabiru mai, na hughuta i popo keda vaghagna salaghe na vaivine mathangani kena hatia nidia na juta mena vano kori vathegna sina vaivine ke pitua na mane keda taulaghi itagna. ");
INSERT INTO bgt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E salaghe na vaivine irangeni, e lima kena boi thaothadogha me lima kena thaothadogha. ");
INSERT INTO bgt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","E lima na vaivine kena boi thaothadogha kena hatia nidia na juta, kari ena boi hatia na botolo oela duadia. ");
INSERT INTO bgt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kari e lima na vaivine kena thaothadogha kena hatia nidia na juta ma na botolo oela. ");
INSERT INTO bgt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na mane keda taulaghi ke boi saisami mai, ma na koi vaivine kena pitu mena paghana mena nere sania. ");
INSERT INTO bgt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kori hotaghi bongi iira kena rongovia na komi tinoni kena haghore heta, ‘Na mane keda taulaghi ke gharani mai ghohi! Oti mai eigna kotida reghia!’ ");
INSERT INTO bgt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“E salaghe na vaivine irangeni kena rarai hadi gougovu mena kalitira nidia na juta. ");
INSERT INTO bgt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Me lima na vaivine kena boi oha duadia na botolo oela kena veleragna e lima na vaivine kena hatia na botolo oel, ‘Oti heghami mai na oela eigna nimami na juta ke haga thehe ghohi.’ ");
INSERT INTO bgt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Me lima na vaivine kena thaothadogha kena haghore tughura, ‘Teo. Nimami na oela e boi nabada ighita gougovu. Oti vano tagna ahai ke salemua na oela moti volia nimiu ghehemiu.’ ");
INSERT INTO bgt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Kori vido kena vano bali volia na oela, na mane keda taulaghi kena pitua ke jufu mai. E lima na vaivine kena kaikaliti ghohi kena haghe vano duagna kori vathe bali eia na vangahaidugna na sonihaidu. Leghugna kena haghe ikora, imarea kena bilakia na hagetha. ");
INSERT INTO bgt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Leghugna iangeni, e lima na vaivine kena hiroa na oela kena ghoi tabiru mai. Mena sokara kosi mena jathea, ‘Mane puhi, o hangavia na hagetha vanighami!’ ");
INSERT INTO bgt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma na mane keda taulaghi ke velera, ‘Na hava ku veleghamu ikeagaieni e tutuni. Inau ku boi adoghamu!’” ");
INSERT INTO bgt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Gi a Jisas ke velea, “Oti reireghi toke ghamu moti mono kaikaliti hahali eigna ighamu oti boi adoa ingiha inau kuda ghoi tabiru mai.” ");
INSERT INTO bgt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","A Jisas ke ghoi velera nigna na komi vaovarongo, “Kori vido inau kuda ghoi tabiru mai, na hughuta nigna a God i popo keda vaghagna sina mane puhi ke au sania na melehagna me taveti vano tagna sina meleha tavogha. Gi e taveti au, imanea ke kilora mai nigna na komi mane agutu me hera nigna na rongo eigna kedana reireghi vania. ");
INSERT INTO bgt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Imanea ke hera na rongo leghuagna nidia na thaothadogha. Imanea ke hea sina mane e lima na togha, sina mane e rua na togha, me sina mane sikei na togha. Govu, gi imanea ke au sanira. ");
INSERT INTO bgt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Na mane agutu ke hatia e lima na togha ke vano me agutu tagna na rongo iangeni me hatia lima mua na togha. ");
INSERT INTO bgt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na mane agutu ke hatia e rua na togha ke eia vaghagna iangeni me hatia e rua mua na togha. ");
INSERT INTO bgt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma na mane agutu ke hatia sikei na togha ke vano me ghelia na lodu me gilua na rongo ke hea na vunaghigna. ");
INSERT INTO bgt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Sethe na dani ke haliu atu, gi na mane puhi ke ghoi tabiru mai me kilora mai nigna na komi mane agutu eigna keda adoa na hava kena eia kori nigna na rongo. ");
INSERT INTO bgt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na mane agutu ke hatia e lima na togha ke hati maia nigna na rongo me veleagna na vunaghigna, ‘Vunaghi, ighoe ko heu e lima na togha. O reghia! Inau ku hatia e lima mua na togha!’ ");
INSERT INTO bgt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Na vunaghigna ke ania, ‘Toke puala! Ighoe na mane agutu ke toke ko ei tokea tagna na hava ku hegho. Na vunegna na puhimu ke toke kori reireghiagna na komi fata ke iso, ikeagaieni inau ku lubatia vanigho gi koda reireghia na komi fata ke nagho. O mai mo mono totogo duagu.’ ");
INSERT INTO bgt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ma na na mane agutu ke hatia e rua na togha ke mai me velea, ‘Vunaghi, ighoe ko heu e rua na togha. O reghia! Inau ku hatia e rua mua na togha!’ ");
INSERT INTO bgt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Na vunaghigna ke ania, ‘Toke puala! Ighoe na mane agutu ke toke ko ei tokea tagna na hava ku hegho. Na vunegna na puhimu ke toke kori reireghiagna na komi fata ke iso, ikeagaieni inau ku lubatia vanigho gi koda reireghia na komi fata ke nagho. O mai mo mono totogo duagu.’ ");
INSERT INTO bgt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Gi na mane agutu ke hatia sikei na togha ke mai me velea, ‘Vunaghi, inau ku adoa ighoe sina mane e vahotha puala na vatotogoghogna. Toke ighoe ko boi agutu kori nimua na komi gnatha, inau ku adoa ighoe koda hatia na rongo ke mai tagna na vanga nimua na komi mane agutu kena joua. ");
INSERT INTO bgt_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Inau ku mataghu mu vano mu gilua nimua na rongo kori thepa. O reghia! Iaani nimua na rongo.’ ");
INSERT INTO bgt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Na vunaghigna ke haghore heta vania, ‘Nighe! Ighoe na mane agutu ko toali mo dika! Ighoe ko adoa ghohi inau ku hatia na rongo ke mai tagna na vanga nigua na komi mane agutu kena joua. ");
INSERT INTO bgt_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ehava gi o boi boa haghea na rongo kori vathe bali bobo rongo eigna keda vusu mu ghieghilei tabiru mai mu hatia?’ ");
INSERT INTO bgt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Gi na vunaghigna ke velera nigna na komi mane agutu, ‘Oti hati aua na rongo iangeni itagna, moti hea imanea ke tonogna e salaghe na togha. ");
INSERT INTO bgt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ahai ke ei tokea tagna na hava ku hea, inau kuda hea sethe mua na komi fata. Kari ahai ke boi ei tokea tagna na hava ku hea, toke ke boi sethe nigna na komi fata, inau kuda hati aua itagna. ");
INSERT INTO bgt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Oti thotia moti taria na naegna ma na limagna moti soni aua kori meleha ke puni. Na komi tinoni kedana dikahehe me tangi me gigiri kei ingengeni.’” ");
INSERT INTO bgt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","A Jisas ke ghoi velera, “Kori vido inau, na Dathei Tinoni, kuda ghoi tabiru mai duai silada ma na nigua na komi enjel, inau kuda nohe kori nigua na sapei vunaghi. ");
INSERT INTO bgt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na komi enjel kedana hathatanora mai itagua na komi tinoni gougovu kori maramagna. Inau kuda thevuruara vaghagna na mane ke reireghia na sip ke thevuruara na komi sip ma na komi got. ");
INSERT INTO bgt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Inau kuda hathatanora mai na komi tinoni kena jino kori madothogu ma na komi tinoni kena boi jino kori toigu. ");
INSERT INTO bgt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Gi, inau na king kuda velera na komi tinoni kori madothogu, ‘Ighamu ke vatokeghamu a Tamagu, oti haghe mai kori hughuta nigna a God moti hatia na komi fata ke toke imanea ke kaikalitia vanighamu ghohi kori turughugna na maramagna. ");
INSERT INTO bgt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Eigna kori vido ku mono rofo, ighamu koti heu ghagua. Kori vido ku langasa, ighamu koti vakouu. Kori vido koti boi adou, ighamu koti kalitiu kori vathemiu. ");
INSERT INTO bgt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kori vido ke teo sa nigua na pohe, ighamu koti vapipisiu. Kori vido ku vahaghi, ighamu koti reireghiu. Kori vido ku mono kori vathe tatari, ighamu koti mai sighou.’ ");
INSERT INTO bgt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ma na komi tinoni kena jino kedana huatiu, ‘Lod, ingiha kiti reghigho ko mono rofo miti hegho ghamua? Ingiha ko langasa miti vakougho? ");
INSERT INTO bgt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ingiha kiti boi adogho, miti kalitigho kori vathemami? Ingiha ke teo sa nimua na pohe miti vapipisigho? ");
INSERT INTO bgt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ingiha ko vahaghi ba o mono kori vathe tatari miti mai sighogho? ");
INSERT INTO bgt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Gi inau na king kuda velera, ‘Na hava ku veleghamu e tutuni. Kori vido koti hathera sa tinoni ke leghuu inau ke boi nagho kori maramagna iaani, ighamu koti hatheu inau.’ ");
INSERT INTO bgt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Leghugna iangeni, inau na king kuda velera na komi tinoni kena mono kori toigu, ‘Ighamu a God keda vaparaghamu, oti rughu au itagua. Moti vano mono kori joto ke ghatha thovohaliu a God ke kalitia ghohi vanira a Satan ma na nigna na komi enjel. ");
INSERT INTO bgt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Eigna kori vido ku mono rofo, ighamu koti boi heu ghagua. Kori vido ku langasa, ighamu koti boi vakouu. ");
INSERT INTO bgt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kori vido ke teo sa vido bali monogu, ighamu koti boi kalitiu kori vathemiu. Kori vido ke teo sa nigua na pohe, ighamu koti boi vapipisiu. Kori vido ku vahaghi mu mono kori vathe tatari, ighamu koti boi mai sighou.’ ");
INSERT INTO bgt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Imarea kedana huatiu, ‘Lod, ingiha kiti reghigho ko mono rofo, ba ko langasa, ba e teo sa vido bali monogu, ba teo sa nimua na pohe, ba ko vahaghi, ba ko mono kori vathe tatari, miti boi hathegho?’ ");
INSERT INTO bgt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Inau kuda haghore tughura, ‘Na hava ku veleghamu e tutuni. Kori vido koti boi hathera sa tinoni ke leghuu inau ke boi nagho kori maramagna iaani, ighamu koti boi hatheu inau.’ ");
INSERT INTO bgt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Na komi tinoni iraani kena boi jino, a God keda vaparara thovohaliu. Keana na komi tinoni jino kedana hatia na havi ke teo na govugna.” ");
INSERT INTO bgt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Leghugna a Jisas ke titionoa na komi fata irangeni, imanea ke velera nigna na komi vaovarongo, ");
INSERT INTO bgt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ighamu koti adoa na Laulahugna na Thovoliungi keda turughu ivaliha. Kori vido iangeni, imarea kedana lubatiu vano inau, na Dathei Tinoni, tadia nigua na thevuioka eigna kedana tupipuhiu kori ghaibabala.” ");
INSERT INTO bgt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kori vido iangeni, mara na naghoi pris mi mara puhidia mara Jiu kena haidu kori vathegna a Kaiafas. Imanea na pukuni naghoi pris. ");
INSERT INTO bgt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Imarea kena hiohiro puhi eigna kedana thotia me vathehea a Jisas kori puhi kedana boi adoa na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Keana imarea kena velea, “Ati saghoi eia tadia na komi dani kati eia na laulahu, kenughua ena adoa na mavitu mena eia na rihu hutu.” ");
INSERT INTO bgt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","A Jisas ke mono i Betani kori vathegna a Saimon, sina mane ke toke tabiru kori lepa. ");
INSERT INTO bgt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kori vido kena nohe mena vanga, sina vaivine ke haghe mai duai botolo ke ulaghagna ke mono na oela i koragna. Na oela iangeni e ghuba tokegna puala me vahotha puala na voligna. Iia ke hangavia me rotea kori ulugna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nigna na komi vaovarongo a Jisas kena reghia mena dikatadia itagna mena vele aua, “Ehava gi e hai rote diadikala na oela iangeni? ");
INSERT INTO bgt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Na botolo oela iangeni vaghagna keda salemua, da e hatia na rongo ke sethe. Kari hatia me kemulia vanira mara na kuma.” ");
INSERT INTO bgt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","A Jisas ke adoa na hava kena velea me haghore vanira, “Saghoi velehouhorua! Iia ke eia itagua na fata ke toke puala. ");
INSERT INTO bgt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mara kena kuma kena mono duamiu hahali. Keana inau eni, teo kuda mono duamiu hahali. ");
INSERT INTO bgt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kori vido ke rotea na oela itagua, iia ke kaikalitia na tonogu gi jufu mai na maghavu kuda thehe mena giluu. ");
INSERT INTO bgt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Inau ku veleghamu, ivei mi vei, tadia na komi meleha koragna na maramagna kedana titionoa na Rorongo ke Toke, imarea kedana titiono na hava ke eia na vaivine iaani mena togha tabirua.” ");
INSERT INTO bgt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","A Jiudas Iskariot, imanea sikei tadia nigna na komi vaovarongo a Jisas, ke vano tadia mara na naghoi pris. ");
INSERT INTO bgt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Imanea ke huatira, “Na hava kotida voliu gi kuda lubatia a Jisas vanighamu na?” Mi marea kena hea tolu hangavulu na seleni ke silva. ");
INSERT INTO bgt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kori vido iangeni, a Jiudas ke turughu na hiroagna na maghavu ke toke keda lubatia a Jisas vanira. ");
INSERT INTO bgt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tagna na dani ke nagho mai kori Laulahugna na Bred ke Teo na Isi Koragna, nigna na komi vaovarongo a Jisas kena mai itagna mena huatia, “Ivei ko magnahaghinighami kitida vano kaikalitia na vanga katida ghania kori Thovoliungi?” ");
INSERT INTO bgt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma a Jisas ke velera, “Oti vano i Jerusalem tagna na mane ku titionoa vanighamu ghohi. Moti veleagna, ‘Nimami na mane velepuhi ke velea nigna na maghavu ke gharani mai ghohi. Imanea keda vanga duadia nigna na komi vaovarongo kori vathemu bali togha tabirua na Thovoliungi.’” ");
INSERT INTO bgt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mi mara na vaovarongo kena vano mena eia vaghagna vamua a Jisas ke velera. Imarea kena kaikalitia na vanga bali togha tabirua na Thovoliungi kori vathe iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kori lavi, a Jisas duagna nigna na komi vaovarongo kena nohe bali vanga. ");
INSERT INTO bgt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kori vido kena sakai vanga, a Jisas ke velera, “Na hava ku veleghamu e tutuni. Sina mane itamiu keda perou.” ");
INSERT INTO bgt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kori rongoviagna na haghore iangeni, nigna na komi vaovarongo kena dikahehe mena sopa veleagna a Jisas, “Lod, boi inau na?” ");
INSERT INTO bgt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ma Jisas ke velea, “Sikei itamiu ghamu koti sakai vanga duagu tagna sina disi keda perou. ");
INSERT INTO bgt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Inau, na Dathei Tinoni, kuda papara mu thehe vaghagna na komi Rioriso ke Tabu kena velea. Keana kenughua e dika vano tagna ahai ke lubatiu vano tadia nigua na komi thevuioka. Na tinoni iangeni e toke vamua keda boi havi mai kori maramagna eigna imanea keda pada na papara ke hutu puala.” ");
INSERT INTO bgt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ma Jiudas, imanea ke taluhaghore eigna keda peroa a Jisas, ke velea, “Velepuhi, boi inau na?” Ma Jisas ke veleagna, “Ighoe ghehemu ko velea iangeni.” ");
INSERT INTO bgt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kori vido kena vanga, a Jisas ke hatia na bred me veletokea a God. Gi e vidoa me kemulia itadia nigna na komi vaovarongo me velera, “Oti hatia moti ghania. Iaani na tonogu.” ");
INSERT INTO bgt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Gi e hatia na hinao ke mono na waen ikoragna. Imanea ke veletokea a God me hera me velera, “Oti kouvia iaani, ighamu gougovu.” ");
INSERT INTO bgt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iaani na ghaughabuagu keda lulu eidia na komi tinoni eigna a God keda talutavogha na komi paluhadia. Na ghaughabuagu keda kaputi ngasia na taluhaghore haehathe ke mathangani ke eia a God vanira nigna na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Inau ku veleghamu, inau kuda boi ghoi kouvia na waen me ghieghilei jufungia na maghavu inau kuda kouvia na waen mathangani duamiu kori nigna na hughuta a Tamagu.” ");
INSERT INTO bgt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Gi ena salea na hymn mena taveti vano kori Suasupa i Ghai Olev. ");
INSERT INTO bgt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","A Jisas ke velera nigna na komi vaovarongo, “Kori bongi iaani ighamu gougovu kotida ghogho moti korogha saniu vaghagna na komi Rioriso ke Tabu kena velea, ‘A God keda vathehea na mane ke reireghira na komi sip, ma na komi sip kedana ghogho kilili.’ ");
INSERT INTO bgt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Keana, kori vido kuda sokara tabiru kori thehe, inau kuda kidi nagho atu itamiu kori provins i Galili.” ");
INSERT INTO bgt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma a Pita ke veleagna, “Toke kedana ghogho sanigho mara na vaovarongo gougovu, inau teo kuda ghogho sanigho!” ");
INSERT INTO bgt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","A Jisas ke haghore vania a Pita, “Inau ku velegho, kenughua bongi, gi e tangi na kokorako, ighoe koda tolu horui veleagna ko boi adou.” ");
INSERT INTO bgt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Keana a Pita ke veleagna, “Toke kuda thehe duamu, teo kuda velea inau ku boi adogho!” Mara na vaovarongo gougovu kena taluhaghore vaghagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","A Jisas duagna nigna na komi vaovarongo kena vano kori vido kena kiloagna i Getsemani. Jisas ke velera, “Oti nohe eeni. Inau kuda taveti vano sina ghathi vido iso mu tarai.” ");
INSERT INTO bgt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Imanea ke talangira duagna a Pita me rua dathegna a Jebedi, Jemes ma Jon. Kori vido iangeni a Jisas ke dikahehegna puala eigna na komi fata keda kathea. ");
INSERT INTO bgt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Imanea ke velera e tolu nigna na mane vaovarongo, “Na dikahehe ke hutu puala itagua me haga vatheheu. Oti mono eeni moti rarai.” ");
INSERT INTO bgt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Imanea ke taveti vano sina vido gi e nere kolipogho horu kori thepa me tarai, “Mama, gi keda mono sa puhi keda tavogha, o saghoi lubatiu gi kuda papara mu thehe. Keana o saghoi leghua nigua na vanohehe, kari nimua na vanohehe vamua.” ");
INSERT INTO bgt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Gi a Jisas ke tabiru mai tadia tolu nigna na mane vaovarongo me reghira kena nere. Imanea ke veleagna a Pita, “Ehava? Boi tangomana kotida rarai duagu sikei na ghathi aoa vamua? ");
INSERT INTO bgt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Otolu rarai motolu tarai eigna keda boi mai na auau itamiu. Tolughamu kotolu magnahaghinia na eiagna na hava ke jino, kari boi tangomana nimiu eigna na tonomiu ke lae.” ");
INSERT INTO bgt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Gi a Jisas ke ghoi taveti vano me tarai vaghagna iaani, “Mama, gi keda boi mono sa puhi ke tavogha tagna na papara ma na thehe kuda eia, inau kuda leghua vamua nimua na vanohehe.” ");
INSERT INTO bgt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kori vido ke ghoi tabiru mai itadia tolu na mane vaovarongo, imanea ke reghira kena ghoi nere mua eigna kena magoli nidia puala. ");
INSERT INTO bgt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A Jisas ke vatolui tabirugna vano me tarai vaghagna ke eia ghohi. ");
INSERT INTO bgt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Gi imanea ke ghoi tabiru mai me velera, “Oti talu nere nimiu mua? Otolu rorongo mai itagua. Na maghavu ke jufu mai ghohi. Inau na Dathei Tinoni, sina mane keda lubatiu vano kori limadia mara na koakoa. ");
INSERT INTO bgt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Imanea keda perou ke mai ghohi iangeni. Sokara hadi mati atu itagna!” ");
INSERT INTO bgt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kori vido a Jisas ke talu haohaghore mua, a Jiudas, sikei itadia mara salaghe rua, ke jufu mai itadia. Sethe na tinoni kena mai duagna kena tangolia na ghau ma na ghai bali rihu. Mara na naghoi pris, mi kekeha mara puhidia mara Jiu kena vetulara mai. ");
INSERT INTO bgt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A Jiudas ke kidi velera ghohi na mavitu, “Ahai inau kuda kisia, iangeni imanea. Oti thotia.” ");
INSERT INTO bgt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A Jiudas ke mai tagna a Jisas me velea, “Velepuhi! Na soleana keda mono duamu.” Gi e kisia. ");
INSERT INTO bgt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","A Jisas ke veleagna a Jiudas, “Kulagu, o eia na hava ko mai bali eia.” Gi imarea kena mai mena thotia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sina mane vaovarongo nigna a Jisas ke sipa aua nigna na ghau me toka vurukusua sina kuligna nigna na mane agutu na pukuni naghoi pris. ");
INSERT INTO bgt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma Jisas ke haghore vania, “O sulupaghini tabirua nimua na ghau kori mathagna. Ahai ke rihu kori ghau, imanea keda thehe kori ghau. ");
INSERT INTO bgt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ehava? O boi adoa gi kuda kaea a Tamagu, imanea keda vetulara mai itagua sethe na toghai enjel? ");
INSERT INTO bgt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Keana gi kuda eia iangeni, kenughua e boi tutuni na komi Rioriso ke Tabu kena velea iaani keda padau.” ");
INSERT INTO bgt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Gi a Jisas ke haghore vanira na komi tinoni ngengeni, “Ehava? Inau na mane geogeno gi oti tangolia mai duamiu na ghau ma na ghai bali rihu? Leuleghu dani inau ku nohe kori Vathe ke Tabu nigna a God mu velepuhira na komi tinoni. Ehava gi oti boi thotiu ingengeni? ");
INSERT INTO bgt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Keana ighamu koti eia na komi fata iraani eigna keda tutuni na hava kena risoa i hau mara na profet itadia na komi Rioriso ke Tabu.” Kori vido iangeni mara vaovarongo gougovu kena ghogho sania a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mara kena thotia a Jisas kena hatia mena vano kori vathegna a Kaiafas, na pukuni naghoi pris. Kori vathe iangeni mara velepuhigna na komi vetula a Moses mi mara puhidia mara Jiu kena kidi haidu ghohi. ");
INSERT INTO bgt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","A Pita ke leghura kari boi taveti gharanira eigna ke mataghu. Imanea ke haghe vano kori lalabagna na vathe iangeni, me nohe duadia na komi soldia kena Jiu kena kaekalea na Vathe ke Tabu. Imanea ke magnahaghinia keda adoa na hava keda pada a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na vunegna kena magnahaghinia na vatheheagna a Jisas, mara na naghoi pris mi mara puhi kena mono kori Kansol kena hirora kekeha tinoni kedana piapilau eigna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sethe na tinoni kena mai mena titiono piapilau, keana boi tangomana nidia na padagna sikei titiono ke nabagna kedana vathehea. Gi e rua na mane koro mai ");
INSERT INTO bgt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","moro velea, “Na mane iaani ke velea ke tangomana na reo horuagna na Vathe ke Tabu nigna a God me ghoi vasokaraghinia koragna tolu na dani.” ");
INSERT INTO bgt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Na pukuni naghoi pris ke sokara hadi me huatia a Jisas, “Ehava gi o boi velea sa fata tadia na komi tinoni kena titionogho?” ");
INSERT INTO bgt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Keana a Jisas ke mono bughoro vamua. Ma na pukuni naghoi pris ke velea, “O jijighi kori ahagna a God ke havi mo veleghami, ighoe a Vahavi, a Dathegna a God?” ");
INSERT INTO bgt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","A Jisas ke haghore tughua, “Ighoe ghehemu ko velea iangeni. Mi nau ku veleghamu, ighamu kotida reghiu inau, na Dathei Tinoni, kuda nohe kori madothogna a God ke mana puala. Ighamu kotida reghiu inau kuda tabiru mai kori parako.” ");
INSERT INTO bgt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kori rongoviagna na haghore iaani, na pukuni naghoi pris ke dikatagna puala. Imanea ke resua nigna na poko ghehegna me velea, “Imanea ke vananaba ghehegna duagna a God. Teo sa vunegna katida hiroa mua sa tinoni keda toroagna imanea. Ighamu gougovu koti rongovia na hava ke velea imanea. ");
INSERT INTO bgt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ehava kori ghaghanamiu na?” Imarea gougovu kena veleagna, “Imanea ke nabagna keda thehe.” ");
INSERT INTO bgt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Gi imarea kena angusua na matagna mena tupia kori limadia. Kekeha kena tapoa ");
INSERT INTO bgt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","mena veleagna, “Gi ighoe a Vahavi, o veleghami, ahai ke tapogho?” ");
INSERT INTO bgt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kori vido kena talu fatea a Jisas, Pita ke nohe kori lalabagna na vathegna na pukuni naghoi pris. Sina vaivine ke agutu kori vathe iangeni ke mai itagna a Pita me veleagna, “Ighoe sikei tadia mara kena mono duagna a Jisas gna i Galili.” ");
INSERT INTO bgt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma Pita ke veleagna, “Teo! U boi adoa na hava ko velea.” ");
INSERT INTO bgt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Gi e riu vano kori hagethagna na peo. Sina vaivine agutu ke tavogha ke reghia me velera arahai kena mono ngengeni, “Na mane iaani ke mono duagna a Jisas gna i Nasaret.” ");
INSERT INTO bgt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma Pita ke jijighi me velea, “Teo! Inau ku boi adoa na mane iangeni!” ");
INSERT INTO bgt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Boi hauhaugna leghugna iangeni kekeha tinoni kena sokara ingengeni kena vano tagna a Pita mena veleagna, “Tutuni, ighoe sikei itadia, eigna na haghoremu vaghagna na haghoredia mara i Galili.” ");
INSERT INTO bgt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Imanea ke velera, “Inau ku jijighi ku boi adoa na mane iangeni. Gi kuda piapilau, e toke a God keda vaparau.” A Pita ke eu govu horu na haghore iaani ma na kokorako ke tangi. ");
INSERT INTO bgt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Gi a Pita ke togha tabirua na haghore a Jisas ke kidi veleagna, “Inau ku velegho, kenughua bongi, gi e tangi na kokorako, ighoe koda tolu horui veleagna o boi adou.” A Pita ke dikahehegna puala me taveti au kori lalabagna na vathe me tangi heta. ");
INSERT INTO bgt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kori vuevugheigna hadi, mara na naghoi pris mi mara puhidia mara Jiu kena sakai haidu mena vapuhia na hava kedana velera mara puhi kori gaumanegna Rom eigna kedana hiia na vatheheagna a Jisas. Kori vido kena vagovua nidia na haidu, ");
INSERT INTO bgt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","imarea kena taria na limagna a Jisas mena hati vanoa tagna a Pailat. Imanea na manegna Rom ke primia kori provins i Jiudea. ");
INSERT INTO bgt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kori vido a Jiudas, na mane ke peroa a Jisas, ke adoa imarea kena fatea a Jisas bali vathehea, imanea ke dikahehegna puala. Imanea ke hatia e tolu hangavulu na seleni ke silva me ohoa vano tadia mara na naghoi pris mi mara puhidia mara Jiu. ");
INSERT INTO bgt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Imanea ke velera, “Inau ku eia na koakoa. Eigna na mane ku peroa e boi eia sa fata ke dika.” Keana imarea kena veleagna, “Ighami teo sa nimami vunegna iangeni! Nimua na thevu ighoe ghehemu.” ");
INSERT INTO bgt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jiudas ke soni horura na seleni kori Vathe ke Tabu me taveti au. Imanea ke vano me oha na piru me taria kori luagna me vathehea ghehegna. ");
INSERT INTO bgt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mara na naghoi pris kena hathatanoa na seleni iangeni mena velea, “E boi jino kori nida na vetula katida boa haidua na rongo iaani tagna na rongogna na Vathe ke Tabu. Eigna iaani na rongo kena volia bali vathehea na tinoni.” ");
INSERT INTO bgt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Imarea kena vajiojino mena toatogha kedana volia na vidoi thepa nigna sina mane ke agutura na komi disi tagna na thepa. Ma na vidoi thepa iangeni, imarea kena volia bali gilura na komi tinonidia i Jerusalem kena havi tadia na komi meleha tavogha. ");
INSERT INTO bgt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mi iangeni na vunegna imarea kena kiloagna na vidoi thepa iangeni, ‘Na Thepa Ghaughabua.’ ");
INSERT INTO bgt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kori vido kena eia iaani, na hava ke risoa a profet Jeremaia i hau e tutuni, “Mara Israel kena hatia e tolu hangavulu na seleni ke silva, na rongo kena hiia kedana sonia bali vathehea na tinoni. ");
INSERT INTO bgt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma na rongo iangeni kena hatia bali volia na vidoi thepa tagna na mane ke agutua na komi disi tagna na thepa, vaghagna vamua a Lod God ke veleu.” ");
INSERT INTO bgt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas ke sokara naghogna a Pailat, mi manea ke huatia, “Ighoe na king nidia mara Jiu?” Ma Jisas ke haghore tughua, “Ighoe ko velea inau imanea.” ");
INSERT INTO bgt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mara na naghoi pris mi mara puhidia mara Jiu kena toroagna a Jisas, kari imanea ke boi haghore tughura. ");
INSERT INTO bgt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ma Pailat ke veleagna, “Ehava? O rongovia ghohi na komi fata imarea kena toroghogna?” ");
INSERT INTO bgt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Keana a Jisas ke boi haghore eigna sa fata kena toroagna, ma Pailat ke vere nigna puala. ");
INSERT INTO bgt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Leuleghu vinogha, kori Laulahugna na Thovoliungi, a Pailat ke ado lubati aua kori vathe tatari sina mane kena kaea na komi tinoni Jiu. ");
INSERT INTO bgt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kori vido iangeni, sina mane kena pukuni adoa na mavitu ke mono kori vathe tatari. Na ahagna imanea a Barabas. ");
INSERT INTO bgt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","A Pailat ke huatira na mavitu kena haidu kosigna na vathegna, “Ahai koti magnahaghinia kuda vamamaluha? Barabas ba Jisas kena kiloagna a Vahavi?” ");
INSERT INTO bgt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","A Pailat ke velea iangeni eigna imanea ke adoa ghohi imarea kena hatia maia a Jisas itagna eigna kena tahotha itagna. ");
INSERT INTO bgt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kori vido a Pailat ke talu nohe mua kori sape bali fate, a taugna ke vetula mai itagna sina nigna rorongo. Iia ke velea, “O saghoi ei vania sa fata na mane jino iangeni. Eigna ibongi inau ku maumaturungita eigna imanea me boi toke na ghaghanagu.” ");
INSERT INTO bgt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Keana mara na naghoi pris mi mara puhidia mara Jiu kena velehuhurura na mavitu eigna kedana kaea a Pailat meke vamamaluha a Barabas kari e vathehea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gi a Pailat ke ghoi huatira na mavitu, “Ahai itadia koti magnahaghinia kuda vamamaluha na?” Mi marea kena haghore tughua, “A Barabas!” ");
INSERT INTO bgt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma Pailat ke huatira, “Gi kuda vamamaluha a Barabas, na hava kuda eia itagna Jisas kena kiloagna a Vahavi?” Mi marea gougovu kena ghuu heta, “Tupipuhia!” ");
INSERT INTO bgt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A Pailat ke velera, “Eigna na hava? Na hava imanea ke ei hahia?” Kari imarea kena ghoi ghuu heta vano mua, “Tupipuhia!” ");
INSERT INTO bgt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","A Pailat ke adoa e vahotha keda tughua na ghaghanadia na mavitu me reghia imarea kena turughu rihu. Na vunegna iangeni, imanea ke hatia na bea me wasia na limagna naghodia na mavitu. Imanea ke velera, “Na vatheheagna na mane iaani boi na paluhagu inau! Na paluhamiu ghehemiu!” ");
INSERT INTO bgt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ma na mavitu gougovu kena velea, “Keda boi jino na vatheheagna imanea, e toke vamua a God keda vaparaghami ma ara vikemami.” ");
INSERT INTO bgt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ma Pailat ke vamamaluha a Barabas, kari e velera mara na soldia eigna kedana thabuhia a Jisas mena tupipuhia. ");
INSERT INTO bgt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nigna na komi soldia a Pailat kena hati vanoa a Jisas kori vathe hutu nigna a Pailat mena kilora mai na komi soldia gougovu kena mono kori nidia na boo. ");
INSERT INTO bgt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Imarea kena hati aua nigna na pohe a Jisas mena vapokoa kori poko mela ke teve. ");
INSERT INTO bgt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mena vakepiagna na kepi kena agutua kori kuji mena boa na supa kori lima madothogna. Imarea kena eia na komi fata iraani eigna keda vaghagna na dodorogna na king. Gi ena torongaghi tuturu itagna mena leuleua. Imarea kena velea, “Ighami kiti kilothabagho, ighoe na king nidia mara Jiu!” ");
INSERT INTO bgt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Imarea kena angusua mena hatia na supa gi ena thabuhia na ulugna. ");
INSERT INTO bgt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Govu na leuleuagna, gi ena hati aua na poko mela ke vahaghea. Imarea kena ghoi vapokoagna komi nigna na poko mena hati vanoa bali tupipuhia. ");
INSERT INTO bgt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kori vido mara na soldia kena hati vanoa a Jisas kosigna i Jerusalem, imarea kena pada sina manegna Sairini, na ahagna a Saimon. Mara na soldia kena huruagna eigna keda hulungia nigna na ghaibabala a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Imarea kena mai jufungia na vido kena kiloagna Golgota, na ghaghana koragna, “Suasupa Ulu.” ");
INSERT INTO bgt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Imarea kena hea Jisas na waen kena ngignoa duagna sina fata ke aha kena kiloagna “gal.” Imanea ke gnamia kari e boi nigna na kouviagna. ");
INSERT INTO bgt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mara na soldia kena tupipuhia a Jisas kori ghaibabala. Gi ena hatia nigna na komi poko mena laulahu vavahi bali adoa ahai keda hatia sikei na vidogna. ");
INSERT INTO bgt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Leghugna iangeni, imarea kena nohe mena kaekalea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mena risoa sina rioriso kori pava mena boa popogna a Jisas. Imarea kena risoa, “IAANI A JISAS, NIDIA NA KINGh MARA JIU.” ");
INSERT INTO bgt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Imarea kena tupipuhia e rua na mane geogeno duagna a Jisas, sikei kori madothogna ma sikei kori toigna. ");
INSERT INTO bgt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na komi tinoni kena halu vano kori hangana ngengeni kena velehouhorua a Jisas mena lilighia na uludia ");
INSERT INTO bgt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","mena veleagna, “Ighoe ko velea i hau ighoe koda reo horua na Vathe ke Tabu nigna a God mo vasokaraghini tabirua koragna e tolu na dani. Gi ighoe a pukuni Dathegna a God, o vahavigho ghehemu mo horu mai kori ghaibabala!” ");
INSERT INTO bgt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mara na naghoi pris mi mara na velepuhigna na vetula nigna a Moses, mi kekeha mara puhi kena leuleua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Imarea kena velea, “Imanea ke vahavira kekeha tinoni tavogha, kari boi tangomana nigna keda vahavia ghehegna! Vaghagna ivei? Imanea hina na king nidia mara Jiu? Gi keda horu mai kori ghaibabala, ighita katida vaututunia. ");
INSERT INTO bgt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Imanea ke velea hahali imanea ke vaututunia a God me velea mua imanea hiri a Dathegna a God. Na vunegna iangeni, ati dodoro gi a God keda magnahaghinia na vahaviagna imanea ikeagaieni ba teo.” ");
INSERT INTO bgt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Vaghagna iangeni mua, rua na mane bilau kena tupipuhira duagna a Jisas koro velehouhorua mua. ");
INSERT INTO bgt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tangi salaghe rua kori dani iangeni, na meleha i Israel doudolu ke puni me jufu kori tangi tolu kori hinaota lavi. ");
INSERT INTO bgt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kori vido iangeni a Jisas ke ghuu me velea iaani kori haghoregna, “Eli! Eli! Lama Sabakatani?” Na ghaghana koragna, “Nigua God! Nigua God! Eigna na hava ko korogha saniu?” ");
INSERT INTO bgt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kekeha tinoni kena mono gharania kena boi rongovia tokea mena velea, “Imanea ke kiloa a Elaija.” ");
INSERT INTO bgt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Gi sikei itadia ke raghe vano me vavonua na pocho kori waen ke aha me jongia kori ghai. Govu, gi e tuhu hadi vano kori livogna a Jisas eigna keda kouvia. ");
INSERT INTO bgt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Keana kekeha tinoni kena mono ngengeni kena veleagna, “Talua. Ighami kiti magnahaghinia kitida reghia a Elaija keda mai vahavia imanea ba teo.” ");
INSERT INTO bgt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Gi a Jisas ke ghoi ghuu heta me thehe. ");
INSERT INTO bgt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kori vido iaani, na pohe ke sasavera koragna na Vathe ke Tabu nigna a God ke resu, turughu i popo me jufu kori kokotogna. Na agnu ke ghaighalia na thepa me fotalira na komi ghahira. ");
INSERT INTO bgt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Na komi luma kena gilua na komi tinoni koragna kena hangavi, me sethe na tinoni kena jino kori matagna a God kena thehe ghohi kena ghoi havi tabiru, ");
INSERT INTO bgt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","mena taveti au tadia na komi luma. Leghugna ke sokara tabiru kori thehe a Jisas, imarea kena vano kori meleha ke tabu i Jerusalem. Me sethe na tinoni kena reghira ngengeni. ");
INSERT INTO bgt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na mane ke nagho tadia mara na soldia ma na nigna na komi soldia kena kaekalea a Jisas kena mataghu nidia puala kori vido kena vajangia na agnu mena reghia na komi fata ke tate mai ngengeni. Imarea kena velea, “Tutuni, iaani pukuni Dathegna a God!” ");
INSERT INTO bgt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kekeha vaivine kena mono ngengeni. Iira kena leghua a Jisas mena hathea kori nigna na taetaveti turughu i Galili me jufu i Jerusalem. Iira kena dodoro mai tagna ke hau. ");
INSERT INTO bgt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kekeha itadia; a Meri gna i Magdala, Meri a idodia a Jemes ma a Josep, ma a idodia a Jemes ma Jon. ");
INSERT INTO bgt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sina mane pada rongo ke mono i Jerusalem. Imanea na manegna i Arimatea ma na ahagna a Josep. Imanea sina mane ke leghua a Jisas. Kori lavigna na dani iangeni, ");
INSERT INTO bgt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","imanea ke vano tagna a Pailat me kaea na tonogna a Jisas. Ma Pailat ke velera nigna na komi soldia eigna kedana hea. ");
INSERT INTO bgt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Gi a Josep ke hatia na tonogna a Jisas me filehiagna kori pohe mathangani ke pura, ");
INSERT INTO bgt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","gi e vano boa koragna nigna na luma kena jouua kori ghahira. Na luma iangeni, e teo mua sa tinoni kena boa ikoragna. ");
INSERT INTO bgt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri gna i Magdala, ma sina Meri tavogha koro nohe ghaghireigna na luma kori vido iangeni. ");
INSERT INTO bgt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sina dani leghugna iangeni, kori Sabat, mara na naghoi pris mi mara na Farise kena vano tagna a Pailat. ");
INSERT INTO bgt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Imarea kena veleagna, “Vunaghi, ighami kiti togha tabirua na hava ke velea na mane piapilau iangeni. Kori vido ke havi mua, imanea ke velea, ‘Leghugna tolu na dani inau kuda ghoi havi tabiru.’ ");
INSERT INTO bgt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Na vunegna iangeni, ighami kiti magnahaghinia koda vetulara kekeha nimua na soldia eigna kedana kaekalea na luma me ghieghilei jufu kori vatolugna na dani leghugna imanea ke thehe. Gi koda boi eia iangeni, kenughua da mai nigna na komi vaovarongo mena bilaua na tonogna. Mi marea kedana piapilau mena velera na komi tinoni imanea ke sokara tabiru kori thehe. Na piapilau iaani keda dika vano tagna na piapilau ke eia a Jisas kori vido ke velea imanea a Vahavi.” ");
INSERT INTO bgt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat ke velera, “Oti hatira vano kekeha nigua na soldia bali kaekale kori luma leghuagna na puhi koti toatogha ke toke.” ");
INSERT INTO bgt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mi marea kena vano mena boa na bali vavangasigna kori ghahira ke ponotia na hagethagna na luma eigna kedana adoa gi sa tinoni kedana pilia na kokopili auagna. Mena boa na komi soldia bali kaekalea. ");
INSERT INTO bgt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Leghugna na dani Sabat kori pohagna na thabota kori Sade, Meri gna i Magdala duagna sina Meri tavogha koro vano bali reghia na luma. ");
INSERT INTO bgt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gi sina agnu hutu ke kahia na thepa eigna sina enjel nigna a God ke horu mai i popo me kokopili aua na ghahira kori hagethagna na luma me nohe popogna. ");
INSERT INTO bgt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na enjel ke siasilada vaghagna na onga, ma nigna na poko ke pura puala vaghagna na kovesa. ");
INSERT INTO bgt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mara na soldia kena kaekale kori luma kena mataghunia puala na enjel mena aiariri. Gi ena sikili horu kori thepa mena boi ghaighali vaghagna na tinoni ke thehe. ");
INSERT INTO bgt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na enjel ke velera e rua na vaivine iangeni, “Oro saghoi mataghu! Inau ku adoa iroghamu koro hiroa a Jisas gna i Nasaret kena tupipuhia. ");
INSERT INTO bgt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Imanea e teo eeni! Imanea ke sokara tabiru ghohi vaghagna vamua ke veleghamu i hau. Oro mai moro reghia na vido kena boa na tonogna.” ");
INSERT INTO bgt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Roira koro vano haghe moro reghia. Gi na enjel ke ghoi velera, “Ikeagaieni oro vano saisami moro velera nigna na komi vaovarongo, ‘A Jisas ke sokara tabiru ghohi kori thehe. Imanea keda kidi nagho atu itamiu i Galili. Ighamu kotida reghia imanea ngengeni.’ Iaani na hava ku mai bali veleghamu roghamu.” ");
INSERT INTO bgt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Roira koro saisami au mai kori luma moro raghe vano bali velera mara na vaovarongo na rorongo iangeni. Roira koro mataghu, kari oro totogo puala mua. ");
INSERT INTO bgt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kori vido koro raghe vano, a Jisas ke mai itadia me velera, “Vuevughei toke roira!” Gi iroira koro vano itagna moro torongaghi tuturu moro tangolia na naegna. Gi oro maimanihihia imanea. ");
INSERT INTO bgt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma Jisas ke anira, “Saghoi mataghu. Oro vano velera mara kena leghuu inau eigna kedana atu i Galili. Imarea kedana reghiu ngengeni.” ");
INSERT INTO bgt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kori vido e rua na vaivine iraani koro taetaveti vano, kekeha mara soldia kena kaekalea na luma kena vano i Jerusalem mena velera mara na naghoi pris na komi fata ke tate mai kori luma. ");
INSERT INTO bgt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Gi mara na naghoi pris kena vapuipuhi haidu duadia kekeha mara puhi mena volira kori rongo hutu na komi soldia kena kaekalea na luma. ");
INSERT INTO bgt_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Mena velera, “Ighamu kotida velea vaghagna iaani, ‘Nigna na komi vaovarongo a Jisas kena mai kori bongi mena bilaua na tonogna kori vido ighami kiti nere.’ ");
INSERT INTO bgt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gi keda rongovia a Pailat ighamu koti nere, ighami kitida vajinoa itagna eigna keda boi eia sa fata dika itamiu.” ");
INSERT INTO bgt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mara na soldia kena hatia na rongo iangeni mena ei leghua na komi fata kena veleragna. Ma na titiono piapilau kena velea ke rongoragha ivei mi vei tadia mara Jiu. Mi mara Jiu kena talu velea me jufu ikeagaieni. ");
INSERT INTO bgt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Salaghe sikei na vaovarongo kena vano i Galili mena vano hadi kori suasupa a Jisas ke kidi velera ghohi kedana vano itagna. ");
INSERT INTO bgt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kori vido kena jufu ngengeni, imarea kena reghia a Jisas mena maimanihihia. Keana kekeha itadia kena ghaghana ruarua eigna imanea. ");
INSERT INTO bgt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Gi a Jisas ke mai itadia me velera, “A God ke heu na mana eigna kuda vunaghi pungusira na komi fata gougovu i popo mi thepa. ");
INSERT INTO bgt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Oti vano tadia na komi tinoni gougovu kori maramagna, moti titiono vanira eigna kedana nigua na komi vaovarongo. Oti siuvitabura kori ahagna na Mama, ma na Dathe ma na Tarunga ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Oti velepuhira eigna kedana leghua na komi fata gougovu ku veleghamu. Moti saghoi havaghinia, inau kuda mono duamiu hahali me ghieghilei govu na maramagna iaani.” ");
INSERT INTO bgt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iaani na turughugna na Rorongo ke Toke eigna a Jisas Krais a dathegna God. ");
INSERT INTO bgt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","I hau, a profet Aisaia ke risoa na hava a God ke velea eigna a Dathegna vaghagna iaani, “Inau kuda kidi vetula nagho atua itamua nigua na mane titiono. Imanea keda vajinoa na hangana vanigho. ");
INSERT INTO bgt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Me keda haohaghore heta kori meleha ke gou, ‘Oti kaikalitia na hangana vania a Lod, moti vajinoa na bali taetavetigna.’” ");
INSERT INTO bgt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Gi a Jon ke mai me taveti au kori meleha ke gou me turughu siuvitabura na mavitu me titiono aua vaghagna iaani, “Oti tughua na havimiu ke koakoa moti siuvitabu, ma a God keda talutavogha na komi paluhamiu.” ");
INSERT INTO bgt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kori vido iangeni, sethe na tinonidia Jerusalem ma na komi meleha kori provins i Jiudea, imarea kena haidu mai tagna a Jon mena vaovarongo. Imarea kena mai mena tuturi aua na komi paluhadia tagna a Jon me siuvitabura kori bea hutu i Jodan. ");
INSERT INTO bgt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","A Jon ke pipisia na pohe ke agutua kori sesehugna na kamel ma na nigna na vovogho ke agutua kori ghuighuligna na kau. Ma na ghagna na vanga na cheche ma na kothogna na mijua. ");
INSERT INTO bgt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Me velera na mavitu vaghagna iaani, “Sina mane ke thaba vano itagua keda mai leghugu. Inau boi naba kuda pogho horu mu hati aua nigna na sadol. ");
INSERT INTO bgt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Inau ku siuvitabughamu kori bea vamua, kari imanea keda siuvitabughamu kori Tarunga ke Tabu.” ");
INSERT INTO bgt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Leghugna iaani, a Jisas ke turughu mai i Nasaret kori provins i Galili me vano siuvitabu tagna a Jon kori bea hutu i Jodan. ");
INSERT INTO bgt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Leghugna na siuvitabuagna, imanea ke vulahadi kori bea me reghia na maaloa ke hangavi ma na Tarunga ke Tabu ke horu mai i popogna vaghagna na bora. ");
INSERT INTO bgt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma na ohai haghore ke haghore mai i popo me ania, “Ighoe a pukuni dathegu. Inau ku totogo puala eimu ighoe mu ku dothovigho.” ");
INSERT INTO bgt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Boi hau leghugna iaani, na Tarunga ke Tabu ke batua a Jisas me vano kori meleha ke gou. ");
INSERT INTO bgt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ingengeni na komi fata asi ke kaukagu kena mono. Jisas ke mono ngengeni e rua tutughu na dani. Ma a Satan ke mai me auaua a Jisas ma na komi enjel kena mai mena hathea imanea. ");
INSERT INTO bgt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Leghugna a Herod ke boa haghea a Jon Siuvitabu kori vathe tatari, a Jisas ke vano kori provins i Galili me tuturia vanira na Rorongo ke Toke ke mai tagna a God. ");
INSERT INTO bgt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Imanea ke velera, “Na maghavu a God keda vunaghi pungusia nigna na mavitu ke gharani mai ghohi. Oti tughua na havimiu ke koakoa moti vaututunia na Rorongo ke Toke!” ");
INSERT INTO bgt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sina dani a Jisas ke taetaveti kori ghaghireigna na kolo i Galili me reghira romara tamatahi a Saimon ma Andru. Romara koro ugura kori rodia na jau eigna romara na mane ugura. ");
INSERT INTO bgt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas ke velera, “Romara, oro mai leghuu. Ikeagaieni roghamu koro ugura fei, kari inau kuda velepuhighamu na hatiagna mai na komi tinoni tagna God.” ");
INSERT INTO bgt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Romara koro saisami talu horua rodia na komi jau, gi oro leghua imanea. ");
INSERT INTO bgt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jisas ke ghoi taveti vano sina ghathi vido iso me reghira a Jemes ma Jon e rua dathegna a Jebedi. Romara koro nohe korai boti moro ghaura rodia na komi jau. ");
INSERT INTO bgt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kori vido iangeni, a Jisas ke kilora romara tamatahi eigna koroda leghua. Romara koro saisami taveti sania a tamadia a Jebedi duadia mara rodia na mane agutu kori boti, moro leghua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisas duagna nigna na komi vaovarongo kena mai jufu kori meleha i Kapaneam. Kori Sabat imanea ke vano haghe kori vathe haidu me velepuhira na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Imarea kena rongovia mena vere nidia puala tagna nigna na komi velepuhi, eigna ke velepuhi kori mana nigna a God. Nigna na velepuhi ke boi vaghagna nidia na velepuhi mara na velepuhigna na vetula nigna a Moses. ");
INSERT INTO bgt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kori vido iangeni, sina mane ke haghevia na tidatho ke mai korai vathe haidu me tangi heta, ");
INSERT INTO bgt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas, ighoe na manemu i Nasaret, na hava ko haga mai eia itamami? Da ighoe o mai bali diadikalaghami! Inau ku adogho ghohi. Ighoe na pukuni mane tabu a God ke vetulagho mai!” ");
INSERT INTO bgt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisas ke haghore heta vania na tidatho, “O bughoro mo taveti au itagna!” ");
INSERT INTO bgt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na tidatho ke vaaiariria puala na tonogna na tinoni iangeni me tangi heta me taveti sania. ");
INSERT INTO bgt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Imarea gougovu kena vere nidia puala mena turughu haohaghore varihotaghidia vaghagna iaani, “Tolumara! Na hava fata hina iaani? Iaani na velepuhi mathangani. Mane iaani ke haghore heta vaghagna na mane ke mono nigna na mana. Kori vido ke haghore heta tadia na komi tidatho, imarea kena leghua!” ");
INSERT INTO bgt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ma na rorongogna a Jisas ke rongoragha kori provins i Galili. ");
INSERT INTO bgt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas ma na komi nigna vaovarongo kena taveti au mai kori vathe haidu mena vano duadia Jemes ma Jon kori vathedia a Saimon ma Andru. ");
INSERT INTO bgt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kori vido kena jufu kori vathe, kekeha tinoni kena veleagna a Jisas a vungaogna vaivine a Saimon ke koli kori mathagna eigna ke vahaghi me vuvughu puala na tonogna. ");
INSERT INTO bgt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jisas ke vano tangolia na limagna me hathea gi e vanohea hadia ma na vahaghi ke govu itagna. Iia ke sokara hadi me kaikalitia vanira ghadia na vanga. ");
INSERT INTO bgt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kori lavi iangeni, leghugna ke huu ghohi na aho, na mavitu kena hatira mai tagna a Jisas na komi tinoni ke padara na komi thagi vahaghi, ma arahai ke haghevira na tidatho. ");
INSERT INTO bgt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na mavitugna na meleha iangeni kena haidu mai kori naghogna na vathe ke mono a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma a Jisas ke vatoke tabirura na komi tinoni sethe ke padara na komi thagi vahaghi me gigi aura na komi tidatho ke sethe. A Jisas ke boi lubatira na komi tidatho gi kedana velea sa fata eigna kena adoa imanea a Vahavi. ");
INSERT INTO bgt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jisas ke rarai hadi kori vuevughei puni me au mai kori vathe. Imanea ke vano tagna sina vido ke korogha me tarai. ");
INSERT INTO bgt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon duagna kekeha ara kulagna kena vano hiroa a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kori vido kena pada imanea, imarea kena veleagna, “Vunaghi, na mavitu gougovu kena hirogho.” ");
INSERT INTO bgt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kari a Jisas ke haghore tughura, “Ati atu tadia kekeha meleha ke gharanighita eigna kuda titionoa na Rorongo ke Toke itadia. A God ke vetulau mai eigna kuda eia na agutu iaani!” ");
INSERT INTO bgt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma a Jisas ke vano tadia na komi vathe haidu nidia mara Jiu kori provins i Galili me titionoa na Rorongo ke Toke me gigi aura na komi tidatho tadia na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sina mane ke lepa ke mai tagna a Jisas me torongaghi tuturu horu itagna. Imanea ke kaea huhurua eigna keda vatokea me velea, “Gi koda magnahaghinia, tangomana koda vatoke tabiruu!” ");
INSERT INTO bgt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisas ke rarovia me tangolia me ania, “Hii, inau ku magnahaghinia. O toke tabiru!” ");
INSERT INTO bgt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma na komi tubu kori tonogna ke saisami mavo. ");
INSERT INTO bgt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jisas ke haghore heta vania, “Saghoi titiono vania ahai na hava ku eia vanigho. Kari o vano dorovia na pris eigna keda reghia na tonomu ke toke tabiru. Leghugna iangeni, o vano mo havughaghi vania a God vaghagna na vetula nigna a Moses ke velea ghohi, eigna kedana adoa na mavitu ighoe ko toke tabiru.” ");
INSERT INTO bgt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kari na mane iangeni ke vano me turughu titionoa tadia na komi tinoni. Na vunegna iaani, sethe na tinoni kena mai tagna a Jisas me boi tangomana nigna keda vano tadia na komi meleha. Mi imanea ke vano kori vido ke korogha, kari na mavitu tadia na komi meleha kena talu mai nidia vamua itagna. ");
INSERT INTO bgt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Leghugna kekeha dani a Jisas ke ghoi tabiru vano i Kapaneam. Kori vido iangeni, na komi tinonidia ngengeni kena rongovia a Jisas ke mono kori vathe ke ado mono hahali itagna. ");
INSERT INTO bgt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Me sethe na tinoni kena haidu mai kori vathe iangeni me teo sa vido ke manga i kora me jufu au i kosi. Kori vido a Jisas ke titiono vanira na haghoregna a God, ");
INSERT INTO bgt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","e vati na mane kena hulungi maia sina mane ke lae na tonogna. ");
INSERT INTO bgt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kari imarea kena boi tangomana nidia na hatiagna mai tagna a Jisas eigna na mavitu ke vonu kori vathe. Mena hulu leghu hadia na rangana mena jufu popogna na vathe. Gi ena vabiloa na vathe mena uli horua duai mathagna tagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas ke adoa nidia na vaututuni ke hutu me haghore vania na mane ke lae na tonogna, “Kulagu, inau ku talutavogha ghohi na komi paluhamu.” ");
INSERT INTO bgt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kori vido iangeni, kekeha mara na velepuhigna na vetula nigna a Moses kena mono ingengeni kena ghaghana vaghagna iaani, ");
INSERT INTO bgt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Na haghore ke velea e boi toke. A God vamua ke tangomana na talutavoghagna na komi paluha. Kori vido imanea ke haghore vaghagna iaani, imanea ke vananaba ghehegna duagna a God.” ");
INSERT INTO bgt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisas ke adoa na ghaghanadia me velera vaghagna iaani, “Ehava gi oti ghaghana na hava ku velea ngengi e boi toke? ");
INSERT INTO bgt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gi kuda haghore vania na mane ke lae na tonogna vaghagna iaani, ‘Inau ku talutavogha na paluhamu,’ ighamu kotida boi tangomana na adoagna na paluhagna ke talutavogha ba teo. Kari gi kuda haghore vania vaghagna iaani, ‘Sokara hadi mo hatia na mathamu mo taveti,’ ighamu kotida reghia inau ku mono nigua na mana bali vatokeagna imanea ba teo. ");
INSERT INTO bgt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kori vido kuda vatokea na mane iaani, ighamu kotida adoa, inau, na Dathei Tinoni, ke mono nigua na mana bali talutavogha na komi paluha.” Me govu, gi a Jisas ke velea na mane ke lae na tonogna, ");
INSERT INTO bgt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“O sokara hadi mo hatia na mathamu mo tabiru kori vathemu!” ");
INSERT INTO bgt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Imanea ke sokara hadi saisami me hatia na mathagna me taveti au kori vathe. Na mavitu kena reghia iaani mena vere nidia puala. Mi marea kena veletokea a God mena velea vaghagna iaani, “I hau meke jufu ikeagaieni ighita kati bosi reghia sa fata ke vaghagna iaani!” ");
INSERT INTO bgt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas ke ghoi tabiru vano kori ghaghireigna na kolo i Galili. Ma na mavitu ke sethe kena haidu mai itagna, gi e velepuhira na haghoregna a God. ");
INSERT INTO bgt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kori vido ke taveti vano, imanea ke reghia sina mane bali oho takis, na ahagna a Livai, dathegna Alafias. Livai ke nohe kori vido bali voli takis. Jisas ke ania, “O mai mo leghuu inau eigna koda nigua na mane vaovarongo.” Livai ke sokara hadi me leghua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Leghugna iaani, a Jisas duagna nigna na komi vaovarongo kena vano vanga kori vathegna a Livai. Sethe na tinoni koakoa a Livai ke hulaghinira mua. Kekeha mara na oho takis kena mono duadia (Sethe na tinoni vaghagna iaani kena mono duadia na mavitu kena leghua a Jisas). ");
INSERT INTO bgt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kekeha mara velepuhigna na vetula, kena kiloragna mara na Farise, kena reghia a Jisas ke vanga duadia mara bali oho takis mi mara na koakoa. Imarea kena huatira nigna na komi vaovarongo a Jisas, “Ehava gi na mane iaani ke vanga duadia mara kena dika?” ");
INSERT INTO bgt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","A Jisas ke rongovia iaani, me haghore tughura, “Arahai kena boi vahaghi kena boi magnahaghinia vano reghiagna na dokta, kari arahai vamua kena vahaghi. Vaghagna iaani, inau ku bosi mai bali kilora arahai kena jino kori ghaghanadia ghehedia bali leghuu inau, kari arahai vamua kena adoa kena koakoa.” ");
INSERT INTO bgt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sina dani mara nigna na komi vaovarongo a Jon Siuvitabu mi mara na Farise kena sota kori vanga. Kekeha tinoni kena mai tagna a Jisas mena huatia, “Mara nigna na komi vaovarongo a Jon Siuvitabu ma na nidia mane vaovarongo mara na Farise, imarea kena sota. Kari, e hava gi mara nimua na komi vaovarongo kena boi eia iaani?” ");
INSERT INTO bgt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisas ke haghore tughura, “Vaghagna ivei, e toke vanira mua na mavitu kena mono kori vangahaidugna na taulaghi kedana sota? Teo! Kori vido na mane taulaghi ke mono duadia ara kulagna imarea boi tangomana kedana sota. ");
INSERT INTO bgt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Keana kori vido kekeha tinoni kedana mai hati aua na mane taulaghi itadia ara kulagna gi ena tangomana kedana sota eigna imarea kena dikahehe. Vaghagna iangeni mua, boi tangomana kedana sota nigua na komi vaovarongo eigna inau ku mono duadia mua. ");
INSERT INTO bgt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ghita ati adoa ghohi, teo ahai itada keda hatia na vidoi pohe mathangani me suki ponotia kori pohe haulaghi ke resu ghohi. Gi katida eia vaghagna iangeni, kori vido kati vano wasia kori bea, kenughua na vidoi pohe mathangani iangeni e kakai me varesua na vidoi pohe haulaghi. Ma na resu iangeni kenughua e hutu vano tagna na resugna i hau. ");
INSERT INTO bgt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sina fata mua iaani, ighita boi tangomana katida toia na waen mathangani kori ghuighuligna na got ke haulaghi. Eigna kori vido na waen mathangani ke vano me haulaghi, kenughua na ghuighuli haulaghi iangeni e nana me poha eigna e nana ghohi. Ma na waen ma na ghuighuli koroda dika govu. Mati toia na waen mathangani kori ghuighuli ke mathangani eigna ke tangomana na nana.” ");
INSERT INTO bgt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sina Sabat, Jisas duagna nigna na komi vaovarongo kena taveti vano kori hangana hotaghidia na komi gnatha i wit. Ma na nigna na komi vaovarongo kena vihukira kekeha sagharo i wit. ");
INSERT INTO bgt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kekeha tadia mara na Farise kena reghia iaani, mena huatia a Jisas, “Nighe! O reghia! Ehava gi nimua na komi vaovarongo kena eia na agutu ke lutia nida na vetula kori Sabat?” ");
INSERT INTO bgt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Jisas ke haghore tughura, “Ehava? Oti boi ijumia na hava ke eia a King Deved sina maghavu kori vido Abiata na pukuni naghoi pris i hau? Deved ma na komi nigna na mane ke teo sa ghadia na vanga mena rofo puala. A Deved ke vano haghe kori vathegna a God me ghania na bred ke tabu, me hera mara nigna na mane. Kori na vetula, na pris vamua ke tangomana na ghaniagna na bred iangeni, kari na komi Rioriso ke Tabu ena boi velea a God ke dikatagna tagna a Deved.” ");
INSERT INTO bgt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ma a Jisas ke velera, “Na Sabat eni, a God ke turughua bali hathera na komi tinoni. Me boi turughua bali vapara na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ma na vunegna iaani, inau, na Dathei Tinoni, ke mono nigua na mana bali velera na komi tinoni na hava kedana tangomana na eiagna kori Sabat.” ");
INSERT INTO bgt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sina Sabat mua, a Jisas ke ghoi tabiru vano kori vathe haidu. Sina mane ke thehe na limagna ke mono ngengeni. ");
INSERT INTO bgt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kori vido iangeni, kekeha mara na Farise kena kaekalea a Jisas eigna kedana reghia imanea keda vatokea na mane iangeni kori Sabat. Gi imanea keda eia vaghagna iangeni, imarea kedana fatea eigna ke boi leghua na vetula. ");
INSERT INTO bgt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisas ke veleagna na mane ke thehe na limagna, “Sokara hadi mo mai nagho eeni.” ");
INSERT INTO bgt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Gi a Jisas ke huatira na mavitu, “Ehava? E lubatia mua na nida na vetula katida eia na hava ke toke kori Sabat? E lubatighita katida hathea na tinoni ba katida eia na fata ke dika itagna? Bali vahavia na tinoni ba bali vathehea?” Kari imarea kena boi haghore tughua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas ke rei kilili tadia na mavitu me dikatagna itadia. Me dikahehegna mua eigna kena boi rarovia na mane ke thehe na limagna. Gi imanea ke haghore vania na mane iaani, “O vajinoa na limamu.” Imanea ke vajinoa na limagna ma na limagna ke pukuni toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kori vido iangeni, mara na Farise kena au mai kori vathe haidu mena haidu duadia kekeha mara kena leghua a Herod. Imarea kena turughu vapuipuhi haidu eigna na bali vatheheagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Govu, gi a Jisas duagna nigna na komi vaovarongo kena taveti au kori vido iangeni mena tabiru vano kori kolo i Galili. Ma na mavitu ke sethe kena leghura. Na mavitu kena mai tadia na komi meleha koragna e tolu na provins; Galili, Jiudea mi Idumea. Kekeha kena mai tagna na meleha hutu i Jerusalem, mi kekeha kena mai tadia na komi meleha thevu etagna na bea hutu i Jodan, mi tadia kekeha meleha mua hilighagna e rua na meleha Taia mi Saidon. Na mavitu iraani ena mai tagna Jisas eigna kena rongovia na komi fata ke eia. ");
INSERT INTO bgt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na vunegna na mavitu ke sethe puala, a Jisas ke velera nigna na komi vaovarongo gi kedana kaikalitia vania na boti eigna kedana boi huhujua na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sethe na tinoni kena vahaghi, imanea ke vatokera. Na vunegna iaani, mara na vahaghi gougovu kena huhuru mena mai itagna eigna kedana taboa. ");
INSERT INTO bgt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kori vido na komi tinoni ke haghevira na tidatho kena reghia a Jisas, imarea kena mai torongaghi tuturu itagna mena tangi heta, “Ighoe a pukuni Dathegna a God.” ");
INSERT INTO bgt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma a Jisas ke haghore heta vanira na komi tidatho me lutira gi kedana boi velera na mavitu imanea Dathegna a God. ");
INSERT INTO bgt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Leghugna iaani, a Jisas ke vano hadi tagna sina suasupa duadia arahai kena vaututunia me kilora mai itagna arahai ke magnahaghinia kedana agutu duagna. ");
INSERT INTO bgt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mi manea ke vahira au salaghe rua na mane me kiloragna Mara na vetula. Imanea ke vahira mara iaani eigna kedana mono duagna. Imanea ke vetulara au eigna kedana titionoa na Rorongo ke Toke, ");
INSERT INTO bgt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","me hera na mana eigna kedana gigi aura na komi tidatho. ");
INSERT INTO bgt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iraani na ahadia e salaghe rua na mane ke vahira; Saimon (a Jisas ke kiloagna a Pita), ");
INSERT INTO bgt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jemes ma Jon e rua dathegna Jebedi (Jisas ke kilora romara iaani Boaneges, na ghaghanagna “dathegna na gumu” eigna romara koro saisami na dikatadia),” ");
INSERT INTO bgt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Filip, Batolomiu, Matiu, Tomas, Jemes dathegna Alofias, Tadius, Saimon (sina mane ke magnahaghinia na gigi auragna mara i Rom eigna kedana boi vunaghi pungusira mara Jiu), ");
INSERT INTO bgt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma a Jiudas Iskariot, na mane ke peroa a Jisas kori limadia mara nigna na thevuioka. ");
INSERT INTO bgt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ma a Jisas ke ghoi tabiru vano kori vathe ke mono itagna ma na mavitu kena ghoi mai mena haidu kililivia. Na vunegna iaani, a Jisas ma na nigna na komi vaovarongo kena rugusi puala mena boi tangomana na vanga ghadia. ");
INSERT INTO bgt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kori vido ara tahigna ma idogna kena rongovia a Jisas ke boi vanga, imarea kena velea, “Imanea ke pukuni mee ghohi.” Gi ena turughu taveti au bali talangi tabirua kori vathedia. ");
INSERT INTO bgt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kekeha mara na velepuhigna na vetula nigna a Moses kena mai i Jerusalem kena velea, “Oti reghia! A Satan, na vunaghidia na komi tidatho ke mono itagna a Jisas. A Satan ke hea na mana a Jisas bali gigi aura na komi tidatho.” ");
INSERT INTO bgt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Gi a Jisas ke kilo haidura mai na mavitu i hilighagna eigna keda velepuhira kori titiono velepuhi. Imanea ke velera, “A Satan bosi tangomana keda gigi aura nigna na komi tidatho. ");
INSERT INTO bgt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gi na mavitugna sina meleha kedana riurihu ghehedia, na meleha iangeni teo keda mono hau. ");
INSERT INTO bgt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ba gi sina tamadathe kedana riurihu ghehedia, na tamadathe iangeni kenughua teo kedana mono haidu. ");
INSERT INTO bgt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Vaghagna iaani mua, gi a Satan ma na nigna na komi tidatho kedana riurihu varihotaghidia, teo kedana mono hau. Iangeni vamua na vagovugna na mana nigna a Satan.” ");
INSERT INTO bgt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jisas ke velea sina titiono velepuhi mua. “Gi ahai keda magnahaghinia na gigi auragna na komi tidatho, imanea keda heta vano tagna a Satan. Vaghagna sina mane keda magnahaghinia na vano haghe koragna na vathegna sina mane ke heta me bilaura nigna na komi fata, imanea keda heta vano tagna mane ke heta iangeni. Gi e malumu na tariagna na mane ke heta iangeni bali bilaura nigna na komi fata. ");
INSERT INTO bgt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“E tutuni inau ku haghorea vanighamu, a God ke tangomana na talutavoghagna na komi thagi paluha ma na komi thagi haghore ke dika gougovu na komi tinoni kena ei vania a God. ");
INSERT INTO bgt_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Keana, gi ahai ke velehouhorua na Tarunga ke Tabu, a God keda bosi talutavogha na paluhagna, kari na paluha iangeni keda talu mono itagna hahali.” ");
INSERT INTO bgt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas ke velea iaani eigna kekeha mara velepuhigna na vetula kena velea, “Imanea ke tangomana na gigi auragna na komi tidatho eigna na tidatho ke mono ikoragna.” Kari ke tutuni ri, a Jisas ke gigi aura na komi tidatho kori mana nigna na Tarunga ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kori vido a idogna mara tahigna a Jisas kena jufu mai kori vathe ke mono a Jisas, imarea kena mono kosi. Gi ena vetula sina tinoni bali veleagna eigna keda mai au itadia. ");
INSERT INTO bgt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na mavitu kena nohe kililivia a Jisas kena veleagna, “A idomu mara tahimu kena pitugho i kosi.” ");
INSERT INTO bgt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kari a Jisas ke huatira, “Ahai a idogu na? Ma arahai ara tahigu na?” ");
INSERT INTO bgt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jisas ke rei kilili tadia na mavitu kena nohe kililivia me velera, “Oti reghia, ighamu a idogu mara tahigu! ");
INSERT INTO bgt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Eigna arahai vamua kena eia na hava a God ke magnahaghinia, irangeni hiri ara tahigu mara vaivinegu ma a idogu.” ");
INSERT INTO bgt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas ke ghoi velepuhira na mavitu ghaghireigna na kolo i Galili. Sethe puala na mavitu kena mai haidu kililivia imanea me hahaghe tagna sina boti ke mono kori kolo me nohe. Ma na mavitu kena sokara i longa. ");
INSERT INTO bgt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A Jisas ke velepuhira tadia na komi titiono velepuhi ke sethe. Imanea ke velera, ");
INSERT INTO bgt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Oti vaovarongo toetoke! Sina mane ke sonira kilili na katura kori nigna na gnatha. ");
INSERT INTO bgt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kori vido imanea ke sonira kilili na komi katura, kekeha kena sikili horu kori hangana ma na komi manu kena mai mena ghani govura. ");
INSERT INTO bgt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kekeha katura kena sikili horu popogna na thepa ke mono na ghahira saragna. Kori vido kena kotu hadi ena ghathi havi toke sina vido vamua. ");
INSERT INTO bgt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kori vido na aho ke vuvughu, na komi katura kena kotu kena gho'e mena thehe eigna na oghadia ke boi pukuni horu i thepa. ");
INSERT INTO bgt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kekeha katura kena sikili horu kori vido ke sethe na atho kaekathe. Kori vido na komi katura kena kotu hadi me hutu, na atho kaekathe irangeni ke virighira mena boi sagharo. ");
INSERT INTO bgt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Keana kekeha katura kena sikili horu kori thepa ke toke mena havi mena sagharo toke. Kekeha, tolu hangavulu na sagharodia, kekeha tolu tutughu, kekeha sina hathangatu.” ");
INSERT INTO bgt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Govu, gi a Jisas ke velera, “Gi ahai ke magnahaghinia na thaothadoghagna iaani, imanea keda vaovarongo toetoke.” ");
INSERT INTO bgt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kori vido a Jisas ke mono ghehegna, kekeha tinoni kena mai duadia mara salaghe rua na vaovarongo, mena mai huatia na ghaghana koragna na komi titiono velepuhi iraani. ");
INSERT INTO bgt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A Jisas ke velera, “I hau a God ke boi lubatia ahai eigna keda adoa na puhi keda eia kori vunaghi pungusiragna nigna na komi tinoni. Keana ikeagaieni imanea ke lubatighamu gi kotida adoa. Keana tadia arahai kena boi leghuu inau, inau kuda velepuhira kori titiono velepuhi vamua. ");
INSERT INTO bgt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Inau ku boi velera na ghaghana koragna na komi titiono velepuhi eigna, ‘Imarea kena reghia na hava ku eia, kari imarea kena boi adoa na ghaghanagna. Imarea kena rongovia na haghoregu, kari ena boi thaothadoghagna. Gi kedana thaothadoghagna, imarea kedana tughua na havidia ke koakoa, ma a God keda talutavogha na komi paluhadia.’” ");
INSERT INTO bgt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ma a Jisas ke velera, “Gi kotida boi thaothadoghagna na ghaghana koragna na titiono velepuhi iaani, e havania gi kotida thaothadoghagna kekeha titiono velepuhi mua na? ");
INSERT INTO bgt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na mane ke sonira kilili na komi katura vaghagna na mane ke tuturi aua na haghoregna a God. ");
INSERT INTO bgt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kekeha tinoni kena vaghadia na komi katura kena sikili horu kori hangana ma na komi manu kena ghanira. Leghugna kena rongovia na haghoregna a God, a Satan ke saisami mai me hatia aua itadia na haghore ke mono kori havidia. ");
INSERT INTO bgt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kekeha tinoni kena vaghadia na komi katura kena sikili popogna na thepa ke mono na ghahira saragna. Imarea kena rongovia na haghoregna a God mena saisami hatia mena totogo. ");
INSERT INTO bgt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kari ena kalitia sina ghathi vido iso vamua, eigna na haghore ke boi mono kori havidia vaghagna na komi katura kena boi pukuni horu i thepa na oghagna. Kori vido ke padara na vahotha ba na papara eigna kena leghua na haghoregna a God, imarea kena saisami havaghinia nidia na vaututuni. ");
INSERT INTO bgt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kekeha tinoni kena vaghadia na komi katura kena sikili horu tagna ke mono na atho kaekathe. Imarea kena rongovia na haghoregna a God, ");
INSERT INTO bgt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","keana imarea kena toatogha puala na komi fata kori havidia leuleghu dani. Mena magnahaghinia puala kedana pada rongo ma na fata ke sethe. Na vunegna iaani, imarea kena boi leghua na haghoregna a God. Teo sa fata ke toke keda au mai kori havidia. ");
INSERT INTO bgt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kari kekeha tinoni kena vaghadia na komi katura kena sikili horu kori thepa ke toke. Imarea kena rongovia na haghoregna a God mena pukuni vaututunia. Na komi tinoni irangeni, sethe na fata ke toke keda au mai kori havidia, vaghagna na komi katura kena havi toke me sethe na sagharodia. Kekeha tolu hangavulu na sagharodia, kekeha tolu tutughu, mi kekeha ghua sina hathangatu.” ");
INSERT INTO bgt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","A Jisas ke huatira na mavitu, “Tangomana mua ahai keda totha na lui me boa saragna na nahu ba saragna na matha saesape? ");
INSERT INTO bgt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bosi tangomana! Imanea keda savera hadia tagna na bali sasaveragna. Na hava ke mono kori vido ke puni, kenughua e tate au kori raraha. Vaghagna mua iangeni, na komi fata kena boi thaothadoghagna na komi tinoni kori nigua na velepuhi ikeagaieni, imarea kedana thaothadoghagna. ");
INSERT INTO bgt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ahai ke magnahaghinia na adoagna iaani, imanea keda vaovarongo toetoke. ");
INSERT INTO bgt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Oti ghaghana toetokera na komi fata ku veleghamu. Eigna a God keda heghamu na thaothadogha leghuagna vamua na puhimiu kori leghuagna nigua na velepuhi. ");
INSERT INTO bgt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ahai keda ghathi thaothadoghagna me leghua nigua na velepuhi, God keda hea mua na thaothadogha, kari ahai ke bosi magnahaghinia na leghuagna nigua na velepuhi, God keda hati aua itagna na ghathi nigna thaothadogha.” ");
INSERT INTO bgt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Gi a Jisas ke velera, “Na hughuta nigna a God ke vaghagna na tinoni ke joua na komi katura kori nigna na gnatha. ");
INSERT INTO bgt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Leuleghu maghavu imanea ke nere kori bongi, me rarai kori dani, ma na komi katura kena turughu kotu mena havi. Imanea ke boi adoa e hava gi ena kotu na komi katura irangeni. ");
INSERT INTO bgt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na thepa vamua ke vatokera me vasagharora. Na fata ke nagho mai na havidia, leghugna iaani na rugudia, ma na vagovugna na sagharodia. ");
INSERT INTO bgt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kori vido ke ghano na sagharodia, imanea ke hatia nigna na ghau me utuhira eigna ke jufungia ghohi na maghavu bali haugera.” ");
INSERT INTO bgt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A Jisas ke ghoi huatira, “Na hughuta nigna a God, vaghagna ivei kori ghaghanamiu na? Inau kuda ghoi veleghamu sina titiono velepuhi eigna kotida pukuni thaothadoghagna. ");
INSERT INTO bgt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hii, vaghagna vamua na ghai mastad na tinoni ke joua kori nigna na gnatha. Na ghai iaani, na katuragna e iso teoteoa vano tadia na komi katura gougovu. ");
INSERT INTO bgt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Keana kori vido ke kotu hadi, na ghai mastad ke hutu vano tadia na komi fata gougovu ke joua kori nigna na gnatha. Na komi ototogna e hutu puala, nabagna na komi manu kedana mai mena gneku itagna.” ");
INSERT INTO bgt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas ke velepuhira na mavitu tagna na komi titiono velepuhi ke sethe. Imanea ke velepuhira na komi fata leghuagna nidia na thaothadogha. ");
INSERT INTO bgt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Imanea ke velepuhira kori titiono velepuhi vamua. Kari kori vido ke mono ghehegna duadia nigna na komi vaovarongo, Jisas ke unuhia na ghaghana koradia na komi titiono velepuhi. ");
INSERT INTO bgt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kori lavigna na dani iangeni, a Jisas ke velera nigna na komi vaovarongo, “Atu mati hathavu sethevugna na kolo.” ");
INSERT INTO bgt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mara nigna na komi vaovarongo kena taveti sanira na mavitu mena vano hahaghe kori boti ke kidi nohe ghohi a Jisas ikoragna mena vano duagna. Kekeha boti mua kena vano duadia. ");
INSERT INTO bgt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kori vido imarea kena vano hotaghigna na kolo, na ghuri hutu ke padara me maghavu puala. Ma na geo ke turughu haghe kori boti mena haga luvu. ");
INSERT INTO bgt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kari a Jisas ke nere leghugna na boti me vaegoa na ulugna kori ulunga. Nigna na komi vaovarongo kena vano raraia. Imarea kena ania, “Nighe, velepuhi! Ehava konia nere kori vido kati haga luvu mati bilomo?” ");
INSERT INTO bgt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Gi a Jisas ke sokara hadi me haghore heta vanira na ghuri ma na geo, “Soto! Sola!” Ma na ghuri ke soto ma na kolo ke sola. ");
INSERT INTO bgt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma a Jisas ke huatira nigna na komi vaovarongo, “Tolumara! Eigna na hava kotinia mataghu? Oti boi vaututuniu mua?” ");
INSERT INTO bgt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Imarea kena mataghu puala mena velea varihotaghidia, “Na tinoni hava hina iaani? Na ghuri ma na geo huju kena leghua na haghoregna eni!” ");
INSERT INTO bgt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas duagna nigna na komi vaovarongo kena vano jufu sethevugna na kolo i Galili ghaghireigna na meleha i Gerasa. ");
INSERT INTO bgt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kori vido a Jisas ke thonga vano i longa, sina mane ke haghevia na tidatho ke mai itagna. Na mane iaani ke au mai ");
INSERT INTO bgt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","kori vido ke mono hahali, tadia na komi luma ke mono na komi beku koradia. Imanea ke heta puala me teo ahai keda taria. ");
INSERT INTO bgt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sethe na maghavu imarea kena pilia na tariagna na naegna ma na limagna kori sen kari imanea ke tautua vamua. Teo ahai keda pukuni heta keda vasotoa. ");
INSERT INTO bgt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dani ma na bongi imanea ke hilivira na komi luma ma na suasupa me ghuu heta me tuitupia ghehegna kori ghahira. ");
INSERT INTO bgt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Imanea ke hau mua me reghia a Jisas me raghe vano tagna me torongaghi tuturu itagna. ");
INSERT INTO bgt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","A Jisas ke velea, “Tidatho, O au sania!” Ma na tidatho ke ghuu heta, “Jisas, dathegna God, pukuni mana! Na hava koda eiugna? Kori ahagna a God, inau ku kaegho, saghoi vaparau!” ");
INSERT INTO bgt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ma a Jisas ke huatia, “Ahai na ahamu?” Ma na tidatho ke haghore tughua, “Na ahagu, Gnaghu, eigna ighami sethe kiti mono koragna na mane iaani!” ");
INSERT INTO bgt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Gi na komi tidatho kena kaea mena kaea Jisas eigna keda boi vetulara au kori meleha iangeni. ");
INSERT INTO bgt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kori vido ngengeni e rua na togha botho kena vanga ghaghireigna na suasupa hilighadia. ");
INSERT INTO bgt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Na komi tidatho kena kaea Jisas mena ania, “O vetulaghami tadia na komi botho eigna kitida mono nimami koradia.” ");
INSERT INTO bgt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Gi a Jisas ke lubatira mena taveti au tagna na tinoni iangeni mena vano haghe koradia na komi botho. Ma na komi botho kena raghe horu leghua na suasupa mena sogala sapa kori kolo mena bilomo gougovu. ");
INSERT INTO bgt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kori vido mara mane kena reireghira na komi botho kena reghia iangeni, imarea kena raghe vano bali titionoa na rorongo iaani tadia na komi tinoni kori melehadia, ma arahai kena mono gharania na melehadia. Me sethe na tinoni kena mai bali reghia nidia na hava ke eia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kori vido imarea kena mai tagna Jisas, imarea kena reghia na mane ke haghevia na komi tidatho i hau. Imanea ke toke ma na ghaghanagna ke jino me pipisi me nohe bughoro. Ma na komi tinoni kena mataghunia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kekeha tinoni kena mono ngengeni kena reghia na hava ke eia a Jisas. Imarea kena titiono vanira na komi tinoni kena eu mai na hava ke padara na komi botho ma na mane ke haghevia na komi tidatho. ");
INSERT INTO bgt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ma na mavitu kena kaea a Jisas eigna keda taveti au kori melehadia, mi imanea ke hiira me taveti au. ");
INSERT INTO bgt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","A Jisas ke ghoi tabiru vano kori boti ma na mane ke haghevia na komi tidatho ke mai me kaea bali leghua. ");
INSERT INTO bgt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","A Jisas ke boi lubatia me ania, “O tabiru vano kori melehamu tadia ara kulamu mo tuturia vanira na fata ke toke a God ke eia vanigho eigna ke rarovigho.” ");
INSERT INTO bgt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mi imanea ke taveti au me vano tadia na komi meleha kori nohi i Dekapolis me titionoa na hava ke ei vania a Jisas. Ma na mavitu kena vere nidia puala. ");
INSERT INTO bgt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","A Jisas duagna nigna na komi vaovarongo kena ghoi tabiru vano sethevugna na kolo i Galili. Kori vido a Jisas ke tatapa thonga vano, na mavitu kena mai haidu kililivia. ");
INSERT INTO bgt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sina mane ke baubatu kori vathe haidu ke mono kori meleha iangeni, na ahagna a Jairus. Imanea ke mai me torongaghi tuturu horu tagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Imanea ke dikahehegna puala me kaea, “Vunaghi, a dathegu vaivine ke haga thehe ghohi. Tangomana koda mai taboa eigna keda ghoi toke tabiru?” ");
INSERT INTO bgt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ma a Jisas ke vano duagna a Jairus. Ma na mavitu ke sethe kena leghura. Imarea kena veihuhujughi eigna kena magnahaghinia na mai tagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Koragna na mavitu iangeni sina vaivine puhi ke pada na vahaghi ghaughabua kekeha vidoi maghavu koragna salaghe rua na vinogha. ");
INSERT INTO bgt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iia ke papara puala ma na komi dokta kena pipilia na vatokeagna, keana e boi talu toke me huhuru vamua. Ma nigna na rongo ke govu eigna ke volira na komi dokta. ");
INSERT INTO bgt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Iia ke rongovia na rorongogna a Jisas me mai leghugna me tugelia nigna na poko. ");
INSERT INTO bgt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Iia ke ghaghana, “Gi kuda tangolia vamua nigna na poko, kenughua inau kuda ghoi toke tabiru.” ");
INSERT INTO bgt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mi kori vido vamua iangeni, na ghaughabua ke soto me vajangia iia ke ghoi toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma a Jisas ke adoa na mana ke au itagna me rei tabiru me huatira na mavitu, “Ahai tamiu ke tangolia nigua na poko?” ");
INSERT INTO bgt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nigna na komi vaovarongo kena veleagna, “Nighe! Ehava go huatira eigna ahai ke tangolia nimua na poko? Boi tangomana koda adoa ahai ke tangoligho eigna na mavitu kena haiduvigho.” ");
INSERT INTO bgt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Keana a Jisas ke talu hiroa mua ahai ke tangolia nigna na poko. ");
INSERT INTO bgt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na vaivine puhi iangeni ke adoa na hava ke pada. Iia ke aiariri eigna ke mataghugna puala me vano me torongaghi tuturu horu tagna a Jisas. Gi e titiono vania na hava ke eia. ");
INSERT INTO bgt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","A Jisas ke veleagna, “Vaivine, Ighoe ko toke tabiru eigna ko vaututuni. O taveti kori soleana. Teo keda ghoi padagho ghohi na vahaghi iaani.” ");
INSERT INTO bgt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kori vido Jisas ke talu titiono duagna na vaivine iangeni, kekeha tinoni kena turughu mai kori vathegna a Jairus, na mane ke baubatu kori vathe haidu. Imarea kena veleagna a Jairus, “A dathemu vaivine ke thehe ghohi. Saghoi kaea mua na mane velepuhi keda mai.” ");
INSERT INTO bgt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisas ke rongovia na gari vaivine ke thehe ghohi, keana imanea ke veleagna a Jairus, “Saghoi mataghu, O vaututuni vamua.” ");
INSERT INTO bgt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A Jisas ke boi lubatira na mavitu kedana leghua mua, kari e hatira vamua a Pita ma Jemes ma Jon, a tahigna Jemes. ");
INSERT INTO bgt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Imarea kena vano jufu kori vathegna a Jairus ma a Jisas ke rongovia na komi tinoni kena tangi heta eigna kena dikahehedia. ");
INSERT INTO bgt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jisas ke vano haghe kora me velera, “Vunegna na hava kotinia tangi? Na gari iaani e boi thehe kari e nere vamua.” ");
INSERT INTO bgt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma na komi tinoni kena kihaghinia. Gi a Jisas ke velera, “Oti vano au i kosi.” Gi e hatia duagna a tamagna ma a idogna na gari duadia e tolu na nigna na mane vaovarongo mena vano kori chogho ke mono na gari. ");
INSERT INTO bgt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gi e tangolia na limagna na gari me veleagna kori haghore Arameik, “Talita Kum!” (na ghaghana koragna, “Gari vaivine, “O sokara hadi!”) ");
INSERT INTO bgt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Iia ke sokara hadi kori vido iangeni me taveti kilili. Ma idogna ma tamagna koro reghia moro vere rodia puala. Ma a Jisas ke haghore heta vanira roira, “Oro saghoi titionoa tadia sa tinoni na hava koro reghia ghohi.” Govu, gi e velera mua, “Oro hea ghagna vanga.” Na vaivine iaani e salaghe rua ghohi na vinoghagna. ");
INSERT INTO bgt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas duagna nigna na komi vaovarongo kena au sania na meleha iangeni mena tabiru vano i Nasaret, na meleha ke hutu hadi a Jisas itagna. ");
INSERT INTO bgt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kori Sabat imanea ke vano haghe kori vathe haidu me velepuhi. Sethe na tinoni kena mai mena vaovarongo itagna, mena vere nidia puala. Keana imarea kena velehouhorua vaghagna iaani, “Ehava gi e adoa na komi fata iraani na mane iaani? Ehava gi e thaothadogha puala? Ivei ke hatia na mana bali eia na komi reghithehe iraani? ");
INSERT INTO bgt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ghita ati adoa na mane iaani, imanea na mane agutu vathe vamua. Imanea a dathegna Meri kari ara tahigna; Jemes, Josep, Jiudas ma Saimon. Ara vaivinegna huju mono mua eeri.” Ma na komi tinonidia i Nasaret kena dikatadia itagna mena boi sasaa na vaututuniagna. ");
INSERT INTO bgt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma Jisas ke velera, “Ahai ke profet, na mavitu tadia na komi meleha ena ghaghana bohea. Kari na mavitu kori melehagna, ma ara vikegna, ena boi ghaghana bohea.” ");
INSERT INTO bgt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A Jisas ke boi tangomana na eiagna na reghithehe ke sethe kori meleha iangeni eigna imarea kena boi vaututunia. Keana imanea ke tabora e rua tolu tinoni vamua kena vahaghi mena toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Imanea ke vere nigna puala eigna na mavitu kori melehagna kena boi vaututunia. Leghugna iaani, a Jisas ke ghoi taetaveti vano tadia na komi meleha me velepuhira na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sina maghavu imanea ke kilora mara salaghe rua nigna na vaovarongo me veleragna, “Inau kuda vetulaghamu au rua na mane tagna sina meleha. Inau kuda heghamu na mana eigna kotida gigi aura na komi tidatho.” ");
INSERT INTO bgt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gi e haghore heta vanira, “Kori vido koti taveti au kori nimiu na taetaveti, saghoi hatia sa fata kari na supa vamua. Saghoi hatia na vanga ma na ngoi ma na rongo. ");
INSERT INTO bgt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Oti vahaghea nimiu na sadol kari saghoi ohoa sa varua pohe. ");
INSERT INTO bgt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kori vido koti jufu tagna sina meleha, mono kori sina vathe ke kalitighamu vamua moti ghieghilei taveti au kori meleha iangeni. ");
INSERT INTO bgt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Keana gi oti jufu tagna sina meleha mena boi kalitighamu mena boi magnahaghinia na rongoviagna nimiu na velepuhi, taveti sania na meleha iangeni. Kari oti rasua na thepa ke thangu kori naemiu. Iaani na vaughithatha kotida eia bali tuhua vanira a God keda vaparara.” ");
INSERT INTO bgt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gi nigna na komi vaovarongo kena taveti au mena tuturi aua vanira na mavitu na haghoregna a God mena velera, “Oti tughua na havimiu ke koakoa.” ");
INSERT INTO bgt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Imarea kena gigi aura na komi tidatho tadia na komi tinoni mena havularagna na oela tadia arahai kena vahaghi mena toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","A Herod Antipas ke king kori provins i Galili ke rongovia eigna a Jisas eigna na rorongogna na komi fata ke eia ke rongoragha ivei mi vei. Kekeha tinoni kena velea, “Imanea a Jon Siuvitabu ke ghoi havi tabiru. Ma na vunegna iangeni, imanea ke mono nigna na mana bali eia na komi reghithehe.” ");
INSERT INTO bgt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kekeha tinoni kena velea, “Imanea a profet Elaija ba sina profetgna i hau.” ");
INSERT INTO bgt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kori vido a Herod ke rongovia eigna a Jisas, imanea ke velea, “A Jon Siuvitabu, ku vihukia ghohi na luagna, ke ghoi havi tabiru!” ");
INSERT INTO bgt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","I hau a Herod ke vetulara mara nigna na soldia mena thotia mena tari a Jon Siuvitabu kori sen mena boa haghea kori vathe tatari. Imanea ke eia iaani bali vatotogoa a taugna, Herodias. I hau a Herodias ke taulaghi tagna a Filip, a toghagna a Herod. Gi a Herod ke hatia me taulaghi tagna. ");
INSERT INTO bgt_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon ke veleagna hahali a Herod, “E boi jino kori vetula nigna a God ko hatia taugna a toghamu.” ");
INSERT INTO bgt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na vunegna iaani, a Herodias ke dikatagna puala tagna a Jon me magnahaghinia keda vathehea. Keana iia ke boi tangomana nigna keda eia eigna a Herod ke boi magnahaghinia na vatheheagna. ");
INSERT INTO bgt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","A Herod ke mataghunia na vatheheagna a Jon eigna ke adoa a Jon na mane tabu ma na mane jino. Kekeha maghavu a Herod ke titiono duagna a Jon. Kori vido ke rongovia nigna na velepuhi, a Herod ke hahi hehegna puala, keana imanea ke magnahaghinia puala na rongoviagna nigna na titiono a Jon. ");
INSERT INTO bgt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tagna sikei na dani, a Herod ke eia na vangahaidu hutu bali togha tabiruagna na maghavu i havigna. Imanea ke hulaghinira arahai kena nagho kori nigna na gaumane, arahai kena nagho kori ami ma na komi mane puhi kori provins i Galili. Kori dani iangeni a Herodias ke hiropada na puhi keda vathehea a Jon. ");
INSERT INTO bgt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kori vido kena nohe mena vanga, dathegna vaivine a Herodias ke haghe vano me ragi vanira. A Herod ma na komi mane ngengeni kena magnahaghinia puala na reghiagna mena totogo puala. Gi a Herod ke veleagna na vaivine mathangani, “Na hava ko magnahaghinia inau kuda hegho. ");
INSERT INTO bgt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Toke koda magnahaghinia na thevugna na vido ku vunaghi pungusia, inau ku taluhaghore kuda hegho.” ");
INSERT INTO bgt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na vaivine ke taveti au vano tagna a idogna me huatia, “Na hava kuda kaea.” A idogna ke veleagna, “O kaea na ulugna a Jon Siuvitabu.” ");
INSERT INTO bgt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma na vaivine ke sokara hadi me tabiru vano saisami tagna Herod me veleagna, “Inau ku magnahaghinia koda heu mai na ulugna a Jon Siuvitabu kori tapera-ikeagaieni vamua!” ");
INSERT INTO bgt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A Herod ke rongovia me dikahehegna puala, kari e maomamogna keda vateoa eigna ke taluhaghorea vania, ma ara kulagna kena rongovia. ");
INSERT INTO bgt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Na vunegna iaani, imanea ke vetula vanoa kori vathe tatari sina soldia mi manea ke utuhia na luagna a Jon Siuvitabu. ");
INSERT INTO bgt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Na soldia ke boa na ulugna kori tapera me hea na vaivine. Iia ke hati vanoa me hea a idogna. ");
INSERT INTO bgt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na rorongo ke jufungira nigna na komi vaovarongo a Jon mena mai hatia na tonogna mena gilua kori luma. ");
INSERT INTO bgt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kori vido mara na vetula kena tabiru mai kori nidia na taetaveti, imarea kena titiono vania a Jisas na komi fata kena eia ma na komi velepuhi kena velepuhira na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Gi na mavitu ke sethe kena mai tadia mena varugusira puala mi marea kena boi tangomana na vanga ghadia. Na vunegna iangeni, a Jisas ke velera, “Ati atu tagna sa vido ke korogha eigna katida mamathoda.” ");
INSERT INTO bgt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mena hahaghe kori boti mena valuha vano kori vido ke korogha. ");
INSERT INTO bgt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kari sethe na tinoni kena reghira na audia, mena ghithathara. Imarea kena taveti sania na komi melehadia mena raghe me kidi jufu kori vido kedana vano a Jisas ma nigna na komi vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kori vido a Jisas ke saki au kori boti, imanea ke reghia na mavitu ke sethe me raroviragna puala eigna imarea kena vaghadia na komi sip ke teo ahai keda reireghira. Gi e velepuhira tagna na komi fata ke sethe. ");
INSERT INTO bgt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kori lavi iangeni nigna na komi vaovarongo kena mai itagna mena veleagna, “E lavi ghohi me teo sa vanga kori meleha iaani. ");
INSERT INTO bgt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ehava konia boi vetulara au na mavitu eigna kedana vano tadia na komi meleha ke gharanighita mena voli ghadia vanga ghehedia?” ");
INSERT INTO bgt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kari a Jisas ke veleragna, “Oti heraghadia.” Imarea kena haghore tughua, “Ighoe ko magnahaghinighami kitida vano miti sonia na rongo ke sethe bali voli vanga eigna kitida heraghadia na mavitu? E vahotha puala!” ");
INSERT INTO bgt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Gi a Jisas ke velera, “Oti vano hiro aua engiha na bred ke mono tadia na mavitu.” Imarea kena vano hiro aua mena mai veleagna, “E lima na bred me rua na fei.” ");
INSERT INTO bgt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jisas ke velera nigna na komi vaovarongo gi kedana vano tutura na mavitu mena nohe kori buburu. ");
INSERT INTO bgt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma na mavitu kena nohe leghua na boo, koragna kekeha boo lima hangavulu tinoni, kekeha sina hathangatu. ");
INSERT INTO bgt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Govu, gi a Jisas ke tangolia e lima na bred ma na fei me tada hadi me veletokea a God. Gi e vidoa na bred ma na fei me hera nigna na komi vaovarongo mena kemulia tadia na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na mavitu kena vanga mena mahu. ");
INSERT INTO bgt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Gi mara na vaovarongo kena hathatanora na komi viovidoi bred ma fei ke tomagha mena hoghoni vonua salaghe rua na arao. ");
INSERT INTO bgt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na haidudia, mara na mane koragna na mavitu, e lima na togha. ");
INSERT INTO bgt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Govu, gi a Jisas ke velera nigna na komi vaovarongo eigna kedana vano kori boti mena kidi taveti vano sethevugna na kolo kori meleha Betsaida. Jisas ke mono horu duadia na mavitu eigna keda vetulara tabiru kori melehadia. ");
INSERT INTO bgt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Leghugna ke vetulara kori melehadia, Jisas ke vano hadi tagna sina suasupa me tarai. ");
INSERT INTO bgt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kori vido ke bongi ghohi, a Jisas ke talu mono mua kori suasupa ma na nigna na komi vaovarongo kena jufu ghohi hotaghigna na kolo. ");
INSERT INTO bgt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A Jisas ke reghira nigna na komi vaovarongo kena babao ghohi na valuha eigna na ghuri ke heta ke mai naghodia. Gi e vano tadia kori vuevughei puni. Imanea ke taetaveti popogna na bea me haga thovohaliungira. ");
INSERT INTO bgt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kori vido imarea kena reghia, imarea kena toatogha kena reghia na tidatho mena ghuu heta. ");
INSERT INTO bgt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mena mataghu nidia puala. Ma a Jisas ke velera, “Teo! Saghoi mataghu! Inau vamua iaani.” ");
INSERT INTO bgt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mi imanea ke saki haghe kori boti tadia ma na ghuri ke soto. Mara na vaovarongo kena vere nidia puala ");
INSERT INTO bgt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","eigna kena boi pukuni thaothadoghagna mua a Jisas ke mono nigna na mana bali eiagna na komi reghithehe, vaghagna kori vido ke heraghadia e lima na togha mane kori lima na bred. Imarea kena poru puala na thaothadoghagna na hava kena reghia. ");
INSERT INTO bgt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","A Jisas duagna nigna na komi vaovarongo kena valuha hathavu sethevu i kolo kori meleha i Genesaret mena pinitia na boti. ");
INSERT INTO bgt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Imarea kena saki au kori boti ma na mavitu kena ghithatha a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Gi ena raghe vano tadia na komi meleha mena velera a Jisas ke mai. Imarea kena hulungira mai kori mathadia arahai kena vahaghi. ");
INSERT INTO bgt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tadia na komi meleha ke vano a Jisas, imarea kena hatira mai na komi tinoni kena vahaghi mena bora tadia na komi vido bali makete. Mena kaea a Jisas eigna keda na lubatira na tangoliagna vamua nigna na pohe me kedana ghoi toke tabiru. Ma arahai kena tangolia kena toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sina dani, kekeha mara na Farise duadia kekeha mara velepuhigna na vetula nigna Moses kena kalasu mai i Jerusalem, imarea kena hathatano mai tagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Gi ena reghira kekeha nigna na komi vaovarongo a Jisas kena vanga kari ena boi kidi sikame kori puhi ke jino tadia mara na Farise. ");
INSERT INTO bgt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mara Jiu, haluhadi mara na Farise, kena talu leghua mua na komi vetula nidia ara hutudia vaghagna na puhi kena sikame gi ena vanga. ");
INSERT INTO bgt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Imarea boi tangomana kedana ghania na vanga kena volia kori makete mena ghieghilei sikamea na limadia. Me sethe mua nidia na vetula kena leghua, vaghagna na puhi bali lumiagna na kap ma na kuro ma na tapera. ");
INSERT INTO bgt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mara na Farise duadia mara na velepuhigna na vetula nigna a Moses kena huatia a Jisas, “Ehava gi nimua na komi vaovarongo kena boi leghua na vetula kati leghua maia i hau me jufu ikeagaieni? Imarea kena boi leghua na puhi bali sikamea na limadia gi ena vanga.” ");
INSERT INTO bgt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma a Jisas ke haghore tughura vaghagna iaani, “Oti piapilau puala eigna na puhi bali leghua a God! Na hava a God ke veleagna a profet Aisaia i hau eimiu ghamu e tutuni. A God ke velea, ‘Na komi tinoni iraani, kori haghoredia vamua kena maimanihihiu, kari kori havidia ena hauniu inau. ");
INSERT INTO bgt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Imarea kena hai maimanihihiu vamua eigna kena tughua nigua na vetula mena leghuagna vamua nidia na komi vetula kena eia ghehedia.’ ");
INSERT INTO bgt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ighamu koti boi leghua ghohi na komi vetula nigna God, kari na komi vetula nidia na komi tinoni vamua.” ");
INSERT INTO bgt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A Jisas ke ghoi velera mua, “Ighamu koti boi ghaghana bohea nigna na vetula a God, eigna ighamu koti leghua vamua na nimiu na vetula ghehemiu. ");
INSERT INTO bgt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Oti adoa ghohi a Moses ke velea iaani, ‘Ghaghana bohea a tamamiu ma idomiu,’ ma ‘Ahai keda velehouhorua a tamagna ba a idogna na tinoni iangeni kedana vathehea.’ ");
INSERT INTO bgt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kari ighamu koti velea e toke vamua ahai keda velea idogna ma tamagna, ‘Tangomana kuda hatheghamu tagna na komi fata iraani ku tonogna, kari boi tangomana nigua ikeagaieni. Eigna inau ku taluhaghore kuda hea a God na komi fata iraani ku tonogna.’ ");
INSERT INTO bgt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kori ghaghanamiu e jino vamua kotida boi hathera ara idomiu ma ara tamamiu. ");
INSERT INTO bgt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kori vido koti velepuhira na mavitu vaghagna iangeni, ighamu koti boi leghua na vetula nigna a God. Me sethe mua na fata vaghagna iangeni koti eia hahalia.” ");
INSERT INTO bgt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas ke kilo haidura na mavitu me velera, “Oti vaovarongo toetoke eigna kotida thaothadoghagna na hava kuda veleghamu. ");
INSERT INTO bgt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Na vanga kena ghania na komi tinoni e boi tangomana keda vagarura kori matagna a God. Kari na komi fata kena eia na komi tinoni ke vagarura kori matagna a God.” ");
INSERT INTO bgt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas duagna nigna na komi vaovarongo kena taveti sania na mavitu mena vano haghe korai vathe. Mara na vaovarongo kena huatia a Jisas eigna keda titiono vanira na ghaghana koragna na titiono velepuhi iaani. ");
INSERT INTO bgt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jisas ke velera, “Tolumara! Oti boi adoa mua? Na vanga kena ghania na komi tinoni e boi tangomana keda vagarura kori matagna a God, ");
INSERT INTO bgt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","eigna e boi vano haghe kori ghaghanadia, kari e haghe kori livodia, horu kori kutudia, me au kori tonodia.” (Jisas ke velea iangeni itadia eigna kedana adoa na komi vanga gougovu e toke vamua na bali vanga.) ");
INSERT INTO bgt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Imanea ke ghoi velera, “Na hava ke au mai kori ghaghanadia na komi tinoni ke vagarura kori matagna a God. ");
INSERT INTO bgt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Eigna na komi fata ke dika vaghagna iraani kena au mai kori ghaghanadia na komi tinoni: na komi ghaghana ke dika, na nere duagna ahai ke boi a taugna, na bilau, na vathehe tinoni, ");
INSERT INTO bgt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","na gumao, na eiagna na komi fata ke dika tagna ahai, na piapilau, na tahotha, na velehouhoruagna na tinoni, na talunagho ma na puhi memee. ");
INSERT INTO bgt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Irangeni na komi fata ke dika ke au mai kori ghaghanadia na komi tinoni ke vagarura kori matagna a God.” ");
INSERT INTO bgt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas ma na nigna na komi vaovarongo kena taveti au kori meleha iangeni mena vano tadia na komi meleha ke gharania na meleha i Taia. Imarea kena vano tagna sina meleha mena vano haghe tagna sina vathe eigna kena boi magnahaghinia na komi tinoni keda adora ivei kena mono. Keana na mavitu kena adora vamua kena mono ngengeni. ");
INSERT INTO bgt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Sina vaivine puhi ke rongovia a Jisas ke mono ngengeni. Na vaivine iaani boi na Jiu. Iia ke havi mai i Fonisia, sina vidogna na provins i Siria. Iia ke mai tagna a Jisas eigna na tidatho ke haghevia a dathegna vaivine. Iia ke torangaghi tuturu horu itagna a Jisas me kaea eigna keda gigi aua na tidatho tagna dathegna. ");
INSERT INTO bgt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jisas ke veleagna, “Inau ku mai bali kidi hathera nigua na mavitu, mara Jiu. Boi toke katida hatia ghadia na vanga na komi gari mati sonia vanoa tadia na komi aku.” ");
INSERT INTO bgt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na vaivine ke veleagna, “Vunaghi, tutuni puala. Kari na komi tinoni kena lubatira na komi aku eigna kedana ghania ghadia na vanga na komi gari ke tomagha.” ");
INSERT INTO bgt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma a Jisas ke veleagna, “Toke puala! Na vunegna ighoe ko haghore tughu thaothadogha, na tidatho ke au sania ghohi a dathemu. Vano mo tabiru kori vathemu.” ");
INSERT INTO bgt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na vaivine ke tabiru kori vathegna me reghia a dathegna ke toke tabiru me nere kori mathagna eigna na tidatho ke taveti au ghohi itagna. ");
INSERT INTO bgt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas ma na nigna na komi vaovarongo kena taveti sania na meleha i Taia mena vano kori meleha i Saidon. Gi ena taveti vano kori nohi i Dekapolis mena vano kori kolo i Galili. ");
INSERT INTO bgt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kekeha tinoni kena hatia maia tagna a Jisas sina mane ke pui me boi haghore toke. Imarea kena kaea a Jisas eigna keda tangolia meke toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","A Jisas ke hati aua na mane iangeni tadia na mavitu moro mono ghehedia. Jisas ke kidi jongia na kaukaugna kori kuligna. Gi e angusu kori kaukaugna me tugelia na thapigna na mane iangeni. ");
INSERT INTO bgt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Govu, gi e tada hadi i popo me soni aheahe me velea, “Efata!” Na ghaghanagna na haghore iaani, “Hangavi!” ");
INSERT INTO bgt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kori vido iangeni, na kuligna ke hangavi me tangomana na rorongo me haghore toetoke. ");
INSERT INTO bgt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","A Jisas ke velera na mavitu eigna kedana saghoi titionoa na fata ke ei vania na mane iangeni. Toke a Jisas ke velera iangeni, imarea kena titionoa nidia vamua na fata iaani tadia na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mara gougovu kena vere nidia puala mena velea, “Tolumara! Na komi fata gougovu ke eia e toke puala. Imanea ke vatoke tabirura arahai kena pui mena boi haohaghore toetoke!” ");
INSERT INTO bgt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Leghugna kekeha dani, sethe na tinoni kena ghoi mai tagna a Jisas. Imarea kena mono duagna tolu na dani ghohi me teo ghohi sa vanga itadia. Jisas ke kilora mai nigna na komi vaovarongo me velera, “Inau ku rarovira nigua puala na mavitu iraani eigna ke teo ghohi sa ghadia vanga. ");
INSERT INTO bgt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Boi tangomana kuda vetulara tabiru kori melehadia kori vido kena rofo. Kenughua ena lae mena sikili kori hangana eigna kekeha itadia kena mai tagna ke hau.” ");
INSERT INTO bgt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nigna na komi vaovarongo kena huatia, “Ivei hina katida pada sa vanga kori meleha ke gou eni keda nabadia na mavitu ke sethe iaani?” ");
INSERT INTO bgt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Gi a Jisas ke huatira, “Engiha na bred ke mono itamiu?” Imarea kena haghore tughua, “E vitu vamua.” ");
INSERT INTO bgt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jisas ke velera na mavitu eigna kedana nohe kori thepa. Gi e hatia na bred me veletokea a God. Govu, gi a Jisas ke vidoa me hera nigna na komi vaovarongo eigna kedana kemulia tadia na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kekeha fei iso mua ke mono itadia ma Jisas ke hatia me veletokea a God. Gi e hera mara na vaovarongo eigna kedana kemulira mua tadia na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Imarea kena vanga mena mahu. Gi ena hathatanora na komi viovidoi vanga ke tomagha mena vavonua e vitu na arao. Govu, gi a Jisas ke vetulara tabiru kori melehadia. Na mavitu iangeni, haga vati na togha na haidudia. ");
INSERT INTO bgt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Gi a Jisas duagna nigna na komi vaovarongo kena hahaghe kori boti mena valuha vano kori nohi i Dalmanuta. ");
INSERT INTO bgt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kori vido kekeha mara na Farise kena rongovia a Jisas ke mai, imarea kena vano itagna. Gi ena rihu haohaghore duagna eigna kena magnahaghinia na pipiliagna. Imarea kena kaea na reghithehe eigna kedana adoa a God hiri ke vetula maia. ");
INSERT INTO bgt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisas ke soni aheahe me velera, “Ehava ighamu koti magnahaghinia kuda tatelia vanighamu na reghithehe? Inau ku veleghamu, teo kuda eia sa reghithehe vanighamu!” ");
INSERT INTO bgt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Govu, gi ena hahaghe kori boti mena turughu hathavu sethevugna na kolo i Galili. ");
INSERT INTO bgt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kori vido imarea kena talu valuha vano sethevugna na kolo, mara na vaovarongo kena adoa kena havaghinia na ohoagna ghadia na vanga. Sina bred vamua kena hatia duadia. ");
INSERT INTO bgt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","A Jisas ke velera, “Oti reireghi toke ghamu kori na isi nidia mara na Farise ma a Herod.” ");
INSERT INTO bgt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mara na vaovarongo kena haohaghore ghehedia mena velea, “Imanea ke velea iaani eigna ke teo sa bred i tada. ");
INSERT INTO bgt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","A Jisas ke adoa na hava kena titionoa me huatiragna, “Eigna na hava kotinia haohaghore koti boi ohoa sa vanga ke nabamiu? Oti talu boi thaothadoagha mua eigu inau? Ighamu koti poru puala na vaututuniugna! ");
INSERT INTO bgt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ighamu e mono na matamiu, kari ehava gi oti boi reghia moti boi adoa? Ighamu e mono mua na kulimiu, kari ehava gi oti boi rorongo? Ehava? Oti madoa nimiu ghohi ");
INSERT INTO bgt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","inau ku vidoa e lima na bred vanira e lima na togha mane? Engiha na arao koti hoghoni vavonua tagna na komi viovidoi vanga ke tomagha?” Imarea kena veleagna, “Salaghe rua.” ");
INSERT INTO bgt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Gi e ghoi huatira mua, “Kori vido inau ku vidoa e vitu na bred vanira e vati na togha tinoni, engiha na arao koti hoghoni vavonua kori viovidoi vanga ke tomagha?” Imarea kena veleagna, “E vitu.” ");
INSERT INTO bgt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Gi a Jisas ke velera, “Na vunegna na hava ighamu oti boi talu thaothadogha mua eigu inau?” ");
INSERT INTO bgt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kori vido imarea kena jufu i Betsaida, kekeha tinoni kena hatia maia sina mane ke doa. Mena kaea a Jisas eigna keda tangolia meke toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisas ke tangolia na limagna me batua au kori meleha iangeni. Gi e angusua na matagna me taboa me huatia, “Ehava? O reghia mua sa fata?” ");
INSERT INTO bgt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Imanea ke rei kilili me velea, “Inau ku reghia na komi tinoni, kari na dodorodia vaghagna na komi ghai kena taetaveti kilili.” ");
INSERT INTO bgt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisas ke ghoi taboa mua na matagna. Govu gi na mane iangeni ke rarabuabuta. Kori vido iangeni imanea ke turughu dodoro toetoke me ghithathara na komi fata gougovu. ");
INSERT INTO bgt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma a Jisas ke haghore heta vania, “O tabiru vano kori vathemu mo saghoi tabiru kori meleha ikeaghaieni.” ");
INSERT INTO bgt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas ma na nigna na komi vaovarongo kena taveti au i Galili mena vano tagna kekeha meleha hilighagna na meleha hutu i Sisaria Filipai. Kori taetavetidia vano kori hangana, a Jisas ke huatira, “Na komi tinoni kena velea ahai inau na?” ");
INSERT INTO bgt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Imarea kena veleagna, “Kekeha tinoni kena velea ighoe a Jon Siuvitabu ke havi tabiru. Kekeha tinoni kena velea ighoe a profet Elaija. Mi kekeha tinoni kena velea ighoe sina profetgna mua i hau.” ");
INSERT INTO bgt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jisas ke ghoi huatira mua, “Ghamu na ba? Ahai otianiu?” A Pita ke veleagna, “Ighoe a Vahavi, na mane a God ke vahia bali hathera nigna na mavitu.” ");
INSERT INTO bgt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jisas ke haghore heta vanira, “Saghoi veleagna sa tinoni ahai inau na.” ");
INSERT INTO bgt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kori vido iangeni, a Jisas ke velepuhira nigna na komi vaovarongo. Imanea ke velera, “Inau, na Dathei Tinoni, imarea kedana vaparau. Mara na naghoi pris ma na mara na velepuhigna na vetula nigna a Moses duadia kekeha mara puhi mua kedana siriuhaghiniu. Imarea kedana vaparau mena vatheheu, kari kori vatolugna na dani inau kuda havi tabiru.” ");
INSERT INTO bgt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A Jisas ke boi poloa sa fata itadia. A Pita ke hati vanoa a Jisas eigna koroda mono ghehedia, gi e veleagna eigna keda saghoi velea na komi fata irangeni. ");
INSERT INTO bgt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kari a Jisas ke rei vano tadia nigna na komi vaovarongo, me veleagna a Pita, “Satan, O taveti saniu, na komi fata ko velea e boi mai tagna a God, kari na ghaghanadia na tinoni vamua.” ");
INSERT INTO bgt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jisas ke kilora mai na mavitu ma na nigna na komi vaovarongo me velera, “Ahai itamiu ke magnahaghinia keda nigua na mane vaovarongo, imanea keda saghoi eia na komi fata ke magnahaghinia vamua. Imanea keda leghuu thovohaliu me sasaa na papara ma na thehe kori ghaibabala. ");
INSERT INTO bgt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Arahai kena boi leghuu inau eigna imarea kena magnahaghinia na eiagna vamua na hava kena magnahaghinia, imarea kedana boi hatia na havi ke teo na govugna. Kari arahai kena sasaa na papara ma na thehe eigna kena leghuu inau ma na Rorongo ke Toke, imarea kedana hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gi ahai ke tonogna na komi fata ke sethe kori maramagna, kari e boi tonogna na havi ke teo na govugna, kenughua na komi fata irangeni e hathea mua? Teo! ");
INSERT INTO bgt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Eigna imanea boi tangomana keda volia na havi ke teo na govugna kori nigna na komi fata ke tonogna. ");
INSERT INTO bgt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ikeagaieni, sethe na tinoni kena boi leghua a God mena eia na komi fata ke dika. Gi kotida maomamohaghiniu moti maomamohaghinia nigua na velepuhi kori matadia na komi tinoni irangeni, inau na Dathei Tinoni kuda siriuhaghinighamu. Inau kuda eia iangeni kori vido kuda ghoi tabiru mai duadia na komi enjel ke tabu duai silada ma na mana nigna a tamagu.” ");
INSERT INTO bgt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A Jisas ke ghoi velera, “Na hava ku veleghamu ke tutuni, kekeha itamiu koti mono duagu ikeagaieni, ighamu kotida boi thehe moti ghieghilei reghia a God keda vunaghi pungusira nigna na mavitu kori nigna na mana ke hutu.” ");
INSERT INTO bgt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Leghugna ono na dani, a Jisas ke hatia a Pita, Jemes ma Jon mena vano ghehedia kori suasupa ke hadi. Tolu na mane vaovarongo kena rei vano mena reghia na dodorogna a Jisas ke tughu. ");
INSERT INTO bgt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nigna na komi pohe ke pura puala me siasilada. Teo ahai keda wasia sa pohe keda pura vaghagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kori vido iangeni tolumara kotolu reghia a Moses ma Elaija koro urungu duagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","A Pita ke veleagna a Jisas, “Velepuhi, toke puala kitida mono nimami eeni duamiu! Tolughami kutoluda agutua e tolu na aava, sikei nimua ighoe, sikei nigna a Moses me sikei nigna a Elaija.” ");
INSERT INTO bgt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","A Pita ke hai velea nigna vamua iaani eigna kena mataghu puala. ");
INSERT INTO bgt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma na parako ke mai popodia me ungahira, ma na haghore ke au mai kori parako, “Iaani pukuni dathegu ku dothovia puala. Oti rorongo toetoke itagna.” ");
INSERT INTO bgt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kori vido iangeni tolumara kotolu rei kilili kari a Jisas vamua ke mono. A Moses ma Elaija koro teo ghohi. ");
INSERT INTO bgt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kori vido Jisas duagna tolu nigna na mane vaovarongo kena horu mai kori suasupa, a Jisas ke haghore heta vanira, “Otolu saghoi veleagna ahai na hava kotolu reghia me ghieghilei jufu na dani, inau, na Dathei Tinoni, kuda havi tabiru kori thehe.” ");
INSERT INTO bgt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tolumara kotolu leghua na hava a Jisas ke veleragna, kari tolumara kotolu veihuahuatighi varihotaghidia eigna na ghaghana koragna “na havi tabiru kori thehe.” ");
INSERT INTO bgt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Gi otolu huatia a Jisas, “Ehava gi mara na velepuhigna na vetula nigna a Moses kena velea a profet Elaija keda kidi mai gi e mai a Vahavi?” ");
INSERT INTO bgt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","A Jisas ke velera, “Tutuni puala a Elaija keda kidi mai bali kaikalitira na komi fata eigna na maigna a Vahavi. Kari inau ku veleghamu a Elaija e mai nigna ghohi. Imarea kena vapapara mena vathehea vaghagna na komi Rioriso ke Tabu kena velea eigna imanea. Na vunegna na komi Rioriso ke Tabu kena velea iaani, tolughamu otolu toatogha puala eigna na hava kuda veleghamu ikeagaieni. Na komi Rioriso ke Tabu kena velea mua na Dathei Tinoni keda pukuni papara mi marea kedana siriuhaghinia.” ");
INSERT INTO bgt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kori vido a Jisas duagna tolu nigna na mane vaovarongo kena horu mai kori suasupa, imarea kena reghia na mavitu kena haidu kililivira mara na mane vaovarongo. Kekeha mara na velepuhigna na vetula nigna a Moses kena rihu haohaghore duadia. ");
INSERT INTO bgt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na mavitu kena reghia a Jisas mena vere nidia puala mena raghe saisami mai itagna. ");
INSERT INTO bgt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma a Jisas ke huatira, “Eigna na hava kotinia rihu haohaghore na?” ");
INSERT INTO bgt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sina mane tadia na mavitu ke haghore tughua, “Velepuhi, inau ku hatia maia a dathegu itamua eigna na tidatho ke haghevia me boi lubatia gi keda haohaghore. ");
INSERT INTO bgt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kori vido na tidatho ke mai heta itagna, na tidatho ke vasikili horua kori thepa. Na pachaghuaghura ke au kori livogna me ghathati ngasia na keigna ma na tonogna ke kakai. Inau ku kaera nimua na komi vaovarongo eigna kedana gigi aua na tidatho itagna, kari imarea kena boi tangomana nidia na eiagna.” ");
INSERT INTO bgt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma a Jisas ke velera na mavitu, “Tolumara! Ighamu eni oti boi talu vaututuniu! Ingiha gi kotida vaututuniu? Oti hatia maia na gari iangeni!” ");
INSERT INTO bgt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mi marea kena hatia mai itagna. Kori vido na tidatho ke reghia a Jisas, na tidatho ke kahia na gari iangeni. Imanea ke sikili horu kori thepa me kokopili kilili me au na pachaghuaghura kori livogna. ");
INSERT INTO bgt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma a Jisas ke huatia a tamagna na gari iangeni, “Ingiha ghohi na hagheviagna na tidatho?” Ma a tamagna ke veleagna, “Turughu kori isogna. ");
INSERT INTO bgt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sethe na maghavu na tidatho ke haga vathehea. Na tidatho ke vasikili horua kori joto ba kori bea. Gi koda tangomana, o rarovighami mo hatheghami.” ");
INSERT INTO bgt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma a Jisas ke veleagna, “Ighoe ko huatiu, ‘Gi kuda tangomana?’ Nau ku tangomana na eiagna na komi fata gougovu vanira arahai kena vaututuniu.” ");
INSERT INTO bgt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma a tamagna ke ania, “Inau ku vaututuni kari e boi rae heta. Hatheu eigna keda heta nigua na vaututuni.” ");
INSERT INTO bgt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisas ke reghia sethe mua na tinoni kena turughu mai haidu kililivia me haghore vania na tidatho, “Ighoe na tidatho ko vapuia mo boi lubatia keda haohaghore na gari iaani, o taveti au itagna mo saghoi tabiru mai mua itagna!” ");
INSERT INTO bgt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma na tidatho ke ghuu heta me kahia na tonogna na gari iangeni me vasikili horua kori thepa. Gi e taveti au itagna. Na gari ke boi ghaighali ma na mavitu kena velea, “Na gari ke thehe ghohi.” ");
INSERT INTO bgt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kari a Jisas ke tangolia na limagna me saraki hadia. Ma na gari iangeni ke sokara eigna ke ghoi toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Leghugna iaani, a Jisas ma nigna na komi vaovarongo kena tabiru kori vathe. Kori vido kena mono ghehedia, imarea kena huatia, “Ehava kiti boi tangomana na gigi auagna na tidatho?” ");
INSERT INTO bgt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A Jisas ke veleragna, “Na tarai vamua ke tangomana na gigi auragna na komi tidatho vaghagna iangeni.” ");
INSERT INTO bgt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisas duagna nigna na komi vaovarongo kena taveti sania na meleha iangeni mena taveti thovohaliungira na komi meleha kori provins i Galili. Jisas ke boi magnahaghinia sa tinoni keda adora ivei kena mono, ");
INSERT INTO bgt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","eigna imanea ke magnahaghinia na titiono vanira nigna na komi vaovarongo eigna na komi fata keda kathea. Imanea ke velera, “Inau, na Dathei Tinoni, sina tinoni keda perou vano tadia mara nigua na thevuioka. Imarea kedana vatheheu, kari kori vatolugna na dani inau kuda havi tabiru kori thehe.” ");
INSERT INTO bgt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nigna na komi vaovarongo ena boi thaothadoghagna na hava ke veleragna, kari ena mataghu na huatiagna. ");
INSERT INTO bgt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jisas ma na nigna na komi mane vaovarongo kena jufu i Kapaneam mena vano haghe tagna sina vathe. Jisas ke huatira, “Eigna na hava koti rihu haohaghore kori vido kati taetaveti mai kori hangana?” ");
INSERT INTO bgt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Imarea kena boi haghore tughua eigna kena rihu haohaghore varihotaghidia eigna ahai keda nagho itadia. ");
INSERT INTO bgt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A Jisas ke nohe me kilora mai nigna na komi vaovarongo hilighagna me velera, “Ahai ke magnahaghinia keda nagho itamiu, imanea keda sasaa na hatheagna ahai itamiu.” ");
INSERT INTO bgt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Govu, gi e pala maia na gari i naghodia me velera, ");
INSERT INTO bgt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ahai ke hathea sa gari ke vaghagna iaani eigna ke dothoviu inau, imanea ke hatheu inau. Ma ahai ke hatheu inau, imanea ke hathea a God ke vetulau mai.” ");
INSERT INTO bgt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ma a Jon ke veleagna, “Velepuhi, ighami kiti reghia sina mane ke gigi aura na komi tidatho itadia na komi tinoni kori kiloagna na ahamu. Na vunegna imanea ke boi mono kori nida na boo, ighami kiti veleagna eigna keda saghoi eia.” ");
INSERT INTO bgt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kari a Jisas ke velera, “Saghoi vasotoa. Arahai kena eia na reghithehe kori kiloagna na ahagu, vahotha puala imarea kedana velea sa fata ke dika eigu inau. ");
INSERT INTO bgt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Arahai ke boi eia sa fata ke dika itada, imarea kena thevu itada. ");
INSERT INTO bgt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","E tutuni, gi ahai ke hatheghamu kori fata ke iso vaghagna na kap bea vamua eigna ke adoa ighamu koti dothoviu inau, sethe na fata ke toke a God keda kemulia vania.” ");
INSERT INTO bgt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","A Jisas ke ghoi velera ghua, “Ahai keda vajefea nigna na vaututuni sa gari vaghagna iaani, imanea ke dika puala. E toke gi kedana taria na ghahira hutu kori luagna mena vabilomoa kori tahi eigna na hava a God keda eia itagna e tahu vano tagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Gi na lima madothomu ke batugho kori koakoa, o utuhia aua. E toke keda mono sikei na limamu vamua kari o hatia na havi ke teo na govugna. E boi toke keda mono rua na limamu kari o vano kori meleha papara. Kori meleha iangeni na joto ke ghatha thovohaliu. ");
INSERT INTO bgt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Gi na naemu ke batugho kori koakoa, o utuhia aua. E toke keda mono sikei na naemu vamua kari o hatia na havi ke teo na govugna. E boi toke keda mono e rua na naemu kari o vano kori meleha papara. Kori meleha iangeni na joto ke ghatha thovohaliu. ");
INSERT INTO bgt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Gi na matamu ke batugho kori koakoa, o sipa aua. E toke keda mono sikei na matamu vamua kari o hatia na havi ke teo na govugna. E boi toke keda mono e rua na matamu kari o vano kori meleha papara. ");
INSERT INTO bgt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kori meleha iangeni na poipoli teo keda thehe ma na joto ke ghatha thovohaliu. ");
INSERT INTO bgt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Na komi papara keda padara na komi tinoni nigna a God iangeni keda hathera na leghuagna a God. ");
INSERT INTO bgt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Na sol sina fata ke toke, keana gi keda beabeagha, boi tangomana nidia kedana ghoi vaaha. Gi kotida boi mono haidu toetoke, ighamu vaghagna na sol ke dika ghohi. Na vunegna iangeni, oti vaghagna na sol ke toke moti mono haidu kori soleana.” ");
INSERT INTO bgt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","A Jisas duagna nigna na komi vaovarongo kena taveti sania i Kapaneam. Imarea kena vano kori provins i Jiudea mena hathavu sethevugna na bea hutu i Jodan tadia na komi meleha ngengeni. Sethe na tinoni kena ghoi haidu mai itagna gi e ghoi velepuhira vaghagna ke ado eia hahalia. ");
INSERT INTO bgt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kekeha mara na Farise kena mai itagna mena pipilia a Jisas eigna kena magnahaghinia na rongoviagna nigna na haghore tughu ke leghua nigna na vetula a Moses ba teo. Imarea kena huatia, “O veleghami, e lubatia mua na mane keda sonia a taugna kori vetula ba teo?” ");
INSERT INTO bgt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A Jisas ke haghore tughura, “Na hava ke velea kori vetula nigna a Moses na?” ");
INSERT INTO bgt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Imarea kena veleagna, “A Moses ke lubatia vamua na mane keda sonia a taugna gi keda risoa na pepa ke velea ke magnahaghinia na soniagna.” ");
INSERT INTO bgt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","A Jisas ke velera, “A Moses ke heghamu na vetula iangeni eigna ke pono puala na ulumiu. ");
INSERT INTO bgt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Na komi Rioriso ke Tabu kena velea, “Kori turughugna mai na maramagna, ‘a God ke vavuha na mane ma na vaivine.’ ");
INSERT INTO bgt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Na vunegna iaani na mane keda taveti sania a tamagna ma idogna me mono haidu duagna a taugna.’ ");
INSERT INTO bgt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kori ghaghanagna a God roira vaghagna sikei vamua na tinoni. ");
INSERT INTO bgt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na vunegna iaani e boi toke sa tinoni keda sonia a taugna. Saghoi thevurua na hava a God ke tari haidua ghohi.” ");
INSERT INTO bgt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","A Jisas duagna nigna na komi vaovarongo kena tabiru kori vathe. Mi marea kena huatia na ghaghana koragna na komi fata iraani. ");
INSERT INTO bgt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jisas ke velera, “Gi na mane keda sonia a taugna me taulaghi tagna sina vaivine tavogha, imanea ke ghoho. ");
INSERT INTO bgt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Vaghagna mua, na vaivine keda sonia a taugna me taulaghi tagna sina mane tavogha, iia ke ghoho.” ");
INSERT INTO bgt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kekeha tinoni kena talangira mai na komi gari tagna a Jisas eigna keda tangolira me vatabura, kari nigna na komi vaovarongo kena haghore peora arahai kena hatira mai. ");
INSERT INTO bgt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kori vido a Jisas ke reghia iaani, imanea ke dikatagna tadia nigna na komi vaovarongo me velera, “Oti lubatira mai na komi gari itagua moti saghoi lutira eigna na komi tinoni a God ke vunaghi pungusira, imarea vaghadia na komi gari iraani. ");
INSERT INTO bgt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","E tutuni na hava ku veleghamu, arahai kena boi vaututunia a God vaghagna na gari, imarea kedana boi mono hahali duadia na komi tinoni a God ke vunaghi pungusira.” ");
INSERT INTO bgt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Govu, gi a Jisas ke palara mai na komi gari me vatabura. ");
INSERT INTO bgt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kori vido a Jisas ma na nigna na komi vaovarongo kena ghoi turughu taveti mua, sina mane ke raghe mai itagna me torongaghi tuturu horu. Gi e huatia a Jisas, “Velepuhi, ighoe ko toke! Na hava kuda eia gi kuda hatia na havi ke teo na govugna?” ");
INSERT INTO bgt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisas ke veleagna, “Ehava gi o kilou inau ku toke? a God vamua ke toke. ");
INSERT INTO bgt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ighoe ko adoa ghohi na komi vetula: ‘Saghoi vathehea na tinoni. Saghoi ghoho. Saghoi bilau. Saghoi vuha haghoregna ahai. Saghoi pilaunia sa tinoni bali hatia nigna na fata. Ghaghana bohea a tamamu ma idomu.’” ");
INSERT INTO bgt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na mane iangeni ke veleagna, “Velepuhi, na komi vetula iraani inau ku leghura turughu kori garigu.” ");
INSERT INTO bgt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A Jisas ke rei vano itagna me dothovia puala gi e veleagna, “Sikei fata vamua ko boi eia. O vano salemua na komi fata gougovu ko tonogna, kari o hatia na rongodia mo kemulia itadia mara kena kuma. O vano eia iaani, gi o mai leghuu inau. Gi koda eia iaani, ighoe koda tonogna na komi fata ke toke i popo.” ");
INSERT INTO bgt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kori vido ke rongovia iaani, imanea ke dikahehegna puala eigna ke sethe puala na komi fata ke tonogna. Me taveti sania a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","A Jisas ke rei vano tadia nigna na komi vaovarongo me veleragna, “E vahotha puala tadia arahai kena pada rongo kedana haghe kori hughuta nigna a God.” ");
INSERT INTO bgt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nigna na komi vaovarongo kena vere nidia puala na rongoviagna nigna na komi haghore. Gi a Jisas ke velera mua, “Ara dathegu, e vahotha puala na haghe kori hughuta nigna a God! ");
INSERT INTO bgt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tangomana mua na kamel keda haghe vano kori bilogna na nili? Vahotha puala! Keana e vahotha vano mua tagna ahai ke pada rongo, na haghe vano kori hughuta nigna a God!” ");
INSERT INTO bgt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kori vido nigna na komi vaovarongo kena rongovia iangeni, imarea kena vere nidia vano mua, mena haghore vaghagna iaani, “Keda vahotha puala na hatiagna na havi ke teo na govugna tagna na tinoni ke pada rongo, bule ahai keda tangomana na?” ");
INSERT INTO bgt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A Jisas ke rei vano itadia me velera, “Tadia na komi tinoni e vahotha puala, keana tagna God e boi vahotha. A God ke tangomana na eiagna vanira na komi tinoni na komi fata kena boi tangomana na eiagna ghehedia.” ");
INSERT INTO bgt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Gi a Pita ke veleagna, “Reghia! Ighami kiti taveti sania nimami na komi fata miti leghugho!” ");
INSERT INTO bgt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","A Jisas ke haghore tughua, “Na hava inau ku veleghamu e tutuni puala, ahai ke taveti sania nigna na komi fata eigna ke leghuu inau ma na Rorongo ke Toke, kenughua imanea keda tonogna sethe na fata vano mua itagna na komi fata ke taveti sania. Gi keda taveti sania na melehagna ba ara tahigna, ara vaivinegna, a tamagna, a idogna, ara dathegna ba nigna na thepa, kenughua a God keda pukuni vatokea. Kori maramagna iaani a God keda vasethea vanoa mua itagna na komi fata ke taveti sania irangeni. Keana na mavitu kedana vapara mua. Kari kori vido ke mai na maramagna mathangani nigna a God, imanea keda hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Na vunegna iangeni, arahai kena nagho ikeagaieni kedana ghoi leghu kori maramagna mathangani. Arahai kena leghu ikeagaieni kedana ghoi nagho.” ");
INSERT INTO bgt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kori vido imarea kena leghua na hangana ke vano hadi i Jerusalem, a Jisas ke kidi taveti nagho itadia nigna na komi vaovarongo. Imarea kena vere nidia puala itagna a Jisas ma na mavitu ke leghura kena mataghu nidia puala. Imanea ke hatira tavogha nigna na komi vaovarongo tadia na mavitu eigna keda titiono vanira na hava keda kathea. ");
INSERT INTO bgt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A Jisas ke velera, “Oti vaovarongo toetoke. Ikeagaieni ighita kati taveti atu i Jerusalem. Ingengeni sina tinoni keda perou me lubatiu vano kori limadia mara na naghoi pris mi mara na velepuhigna na vetula nigna a Moses. Imarea kedana fateu bali vatheheu me kedana lubatiu vano tadia mara kena boi Jiu. ");
INSERT INTO bgt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Imarea kedana kihaghiniu mena angusuu mena thabuhiu mena vatheheu. Keana, kori vatolugna na dani inau kuda havi tabiru kori thehe.” ");
INSERT INTO bgt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Leghugna iaani, Jemes ma Jon, e rua dathegna a Jebedi koro mai tagna a Jisas moro veleagna, “Velepuhi, roghami kuru magnahaghinigho koda eia vanighami sikei na fata.” ");
INSERT INTO bgt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A Jisas ke huatira, “Na hava fata koro magnahaghinia kuda eia vanighamu na?” ");
INSERT INTO bgt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Romara koro veleagna, “Kori vido koda vunaghi pungusira na komi tinoni, iroghami kuru magnahaghinia kuruda vunaghi pungusira duamu. Sikei tamami i roghami keda nohe kori madothomu, sikei kori toimu.” ");
INSERT INTO bgt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A Jisas ke velera, “Na hava koro kaea, roghamu oro boi adoa. Oro tangomana romiu mua koroda papara vaghagna kuda eia inau? Oro tangomana mua koroda thehe vaghagna na thehe keda katheu inau?” ");
INSERT INTO bgt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Romara koro veleagna, “Hii! Tangomana mua kuruda eia.” Ma a Jisas ke velera, “Tutuni puala! Roghamu koroda papara vaghagna kuda eia inau moro thehe vaghagna na thehe keda katheu inau. ");
INSERT INTO bgt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kari inau bosi tangomana kuda vahira arahai kedana nohe kori madothogu ma na toigu kori vido kuda vunaghi pungusira na komi tinoni. Eigna a God ke vahira ghohi arahai kedana nohe duagu.” ");
INSERT INTO bgt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kori vido mara salaghe na vaovarongo kena rongovia na hava koro kaea, imarea kena dikatadia tadia a Jemes ma Jon. ");
INSERT INTO bgt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","A Jisas ke kilora mai mara nigna na vaovarongo gougovu itagna me velera, “Ighamu oti adoa ghohi na komi king mi mara kena baubatu tadia mara kena boi Jiu, imarea kena magnahaghinia na hururagna nidia na mavitu bali eia na hava kena magnahaghinia. ");
INSERT INTO bgt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kari oti saghoi eia vaghagna iangeni. Ahai ke magnahaghinia keda baubatu itamiu, imanea keda agutu vanighamu. ");
INSERT INTO bgt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma ahai ke magnahaghinia keda nagho itamiu, imanea keda agutu vanighamu vaghagna na tinoni seka. ");
INSERT INTO bgt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Inau, na Dathei Tinoni, u bosi mai kori maramagna eigna kedana agutu vaniu na mavitu. Keana u mai bali agutu vanira mu kuda thehe bali vamamaluhara na komi tinoni tadia na komi paluhadia.” ");
INSERT INTO bgt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas duagna nigna na komi vaovarongo kena jufu kori meleha i Jeriko. Kori vido kena taveti au kori meleha iangeni, na mavitu ke sethe kena leghura. Sina mane ke doa, na ahagna a Batimeus, ke nohe kori ghaghireigna na hangana. Imanea a dathegna Timeus. Imanea ke nohe ngengeni me kaekae nigna rongo itadia arahai kedana halu atu kori hangana. ");
INSERT INTO bgt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kori vido imanea ke adoa a Jisas gna i Nasaret ke mai kori hangana, imanea ke ghuu heta, “Jisas, Dathegna Deved, O raroviu!” ");
INSERT INTO bgt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sethe na tinoni kena veleagna eigna keda bughoro kari imanea ke ghoi ghuu heta vano mua, “Jisas, Dathegna Deved, O raroviu!” ");
INSERT INTO bgt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","A Jisas ke sokara soto me velera, “Oti vano velea maia.” Imarea ke vano mena veleagna, “Batimeus, saghoi dikahehemu, sokara hadi, a Jisas ke kilogho!” ");
INSERT INTO bgt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A Batimeus ke hati aua nigna na oopo me sokara hadi me vano itagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","A Jisas ke huatia, “Na hava ko magnahaghinia kuda eia vanigho?” Imanea ke veleagna a Jisas, “Velepuhi, inau ku magnahaghinia kuda ghoi reirei.” ");
INSERT INTO bgt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisas ke veleagna, “Nimua na vaututuni ke vatokegho. Tangomana koda taveti.” Kori vido vamua iangeni, na matagna ke ghoi toke tabiru me taveti duagna a Jisas kori hangana. ");
INSERT INTO bgt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","A Jisas duagna nigna na komi vaovarongo kena vano gharania i Jerusalem mena reghi vanoa e rua na meleha i Betfage mi Betani gharania na Suasupa i Ghai Olev. A Jisas ke kilora mai itagna rua nigna na mane vaovarongo ");
INSERT INTO bgt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","me velera, “Oro vano kori meleha kati reghi vanoa iangeni. Kori vido koroda jufu ngengeni roghamu koroda reghia na dongki mathangani ke piniti. Na dongki iangeni, teo ahai ke taetaveti mua itagna. Oro unuhia moro hatia maia itagua. ");
INSERT INTO bgt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Gi ahai keda huatighamu ahai ke veleghamu na hatiagna, oro veleagna, “A Lod ke magnahaghinia, kari kenughua e saisami me ghoi vetula tabirua.” ");
INSERT INTO bgt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Romara koro vano moro reghia na dongki mathangani ke piniti ghaghireigna na hangana naghogna sina vathe. Romara koro turughu unuhia. ");
INSERT INTO bgt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Kekeha tinoni kena sokara ngengeni kena huatira, “Bali hava koro na unuhiagna?” ");
INSERT INTO bgt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Leghugna romara koro velera na hava ke kidi velera ghohi a Jisas, imarea kena lubatia vanira. ");
INSERT INTO bgt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Romara koro hatia moro vano tagna a Jisas. Gi oro valiagna rodia na oopo ma a Jisas ke nohe popogna na dongki. ");
INSERT INTO bgt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sethe na tinoni kena valia nidia na oopo kori hangana me sethe mua kena toka na komi ototo ghai ke iso mena tutua kori hangana. ");
INSERT INTO bgt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na komi tinoni kena taveti naghogna a Jisas ma arahai kena leghu, kena ngingili, “Hosana, veletokea a God! God, ko vathaba imanea ke mai duagna nimua na mana! ");
INSERT INTO bgt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","God, ko vathaba imanea ke mai bali nimami na vunaghi vaghagna a hutumami a King Deved. Veletokea a God i popo!” ");
INSERT INTO bgt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","A Jisas ke jufu i Jerusalem me vano haghe kori Vathe ke Tabu nigna a God, me reghira na komi fata ke mono ikoragna. Imanea ke boi mono hau eigna ke lavi ghohi me vano duadia nigna na komi vaovarongo i Betani. ");
INSERT INTO bgt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Me ghoi dani hadi, gi ena au sania i Betani bali vano i Jerusalem. Ma Jisas ke rofo. ");
INSERT INTO bgt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Imanea ke reghi vanoa tagna ke hau na ghai fig ke sethe na eloelogna, gi e taveti vano itagna. Kari imanea ke boi reghia sa sagharogna, na eloelogna vavaha vamua, eigna ke boi jufungia mua na vido bali sagharogna. ");
INSERT INTO bgt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jisas ke haghore leghua na ghai fig, “Teo koda ghoi sagharo mua.” Nigna na komi vaovarongo kena rongovia na haghore iaani. ");
INSERT INTO bgt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kori vido imarea kena jufu i Jerusalem, a Jisas ke vano haghe koragna na Vathe ke Tabu nigna a God. Imanea ke reghira na komi tinoni kena voivoli mena salemua na komi fata ke sethe ngengeni. Imarea kena vahadia na volidia na komi fata me boi nabadia na komi tinoni kedana volia. Gi e gigi aura arahai kena voivoli mena salemua na komi fata. Imanea ke koli poghora na komi tevo nidia mara Jiu kena tughu rongo bali volia na takisigna na Vathe ke Tabu, ma na komi sape kena nohe mara kena salemua na komi bora bali havughaghi. ");
INSERT INTO bgt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mi manea ke boi lubatira sa tinoni kedana hatia maia sa fata mua korai na Vathe ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Govu, gi e velepuhira na mavitu me velera, “Na komi Rioriso ke Tabu kena velea iaani, “Nigua na Vathe ke Tabu, na vathe bali tarai nidia na mavitu kori maramagna. Kari ighamu koti eia vaghagna na vido bali monodia mara kena biabilau.” ");
INSERT INTO bgt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mara na naghoi pris ma na mara na velepuhigna na vetula nigna a Moses kena rongovia iaani, mena hiohiroa na puhi bali vathehea a Jisas eigna imarea kena mataghunia. Imarea kena mataghu eigna na mavitu kena magnahaghinia puala nigna na velepuhi a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kori lavi a Jisas duagna nigna na komi vaovarongo kena taveti au i Jerusalem. ");
INSERT INTO bgt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kori vuevugheigna, imarea kena ghoi taetaveti vano kori hangana mena reghia na ghai fig ke haghore leghua a Jisas ke thehe. ");
INSERT INTO bgt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","A Pita ke togha tabirua na haghore ke velea a Jisas, gi e veleagna, “Velepuhi, reghia! Na ghai fig ko haghore leghua ke thehe ghohi.” ");
INSERT INTO bgt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","A Jisas ke velera nigna na komi vaovarongo, “Oti vaututunia a God. ");
INSERT INTO bgt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Inau ku veleghamu, gi ahai keda vaututuni me boi ghaghana ruarua, imanea tangomana keda veleagna na suasupa iangeni, ‘O sokara mo vano mono kori tahi.’ Ma na suasupa iangeni keda leghua na haghoregna. ");
INSERT INTO bgt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Na vunegna iaani, inau ku veleghamu, Gi kotida kaea sa fata kori tarai moti pukuni vaututunia a God keda eia na hava koti kaea, imanea keda eia. ");
INSERT INTO bgt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Kari kori vido koti tarai, gi kotida dikatamiu tagna sa tinoni, oti kidi talutavogha na paluhagna gi a tamamiu i popo keda talutavogha mua na paluhamiu.” ");
INSERT INTO bgt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Imarea kena ghoi tabiru i Jerusalem mena vano haghe kori Vathe ke Tabu nigna a God. Mara na naghoi pris ma na mara na velepuhigna na vetula nigna a Moses duadia kekeha mara puhidia mara Jiu kena mai tagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Imarea kena huatia, “Ahai ke velegho na gigi auragna na komi tinoni kori na Vathe ke Tabu? Ahai ke hegho na mana gi o eia na komi fata iraani?” ");
INSERT INTO bgt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","A Jisas ke haghore tughura, “Inau kuda kidi huatighamu sina huahuati. Gi kotida haghore tughuu, inau kuda veleghamu ahai ke heu na mana gi u eia na komi fata iraani. ");
INSERT INTO bgt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Oti veleu, ahai ke hea na mana a Jon Siuvitabu bali siuvitabura na mavitu? A God ba na tinoni vamua?” ");
INSERT INTO bgt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Imarea kena rihu haohaghore ghehedia vaghagna iaani, “Gi ighita katida veleagna a God ke hea na mana, imanea keda veleghita, ‘Ehava gi oti boi vaututunia na komi velepuhi nigna a Jon na?’ ");
INSERT INTO bgt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Keana gi katida velea na tinoni ke hea na mana, kenughua na mavitu keda dikatadia itada.” Imarea kena mataghunira na mavitu eigna na mavitu kena vaututunia a Jon sina pukuni nigna profet a God. ");
INSERT INTO bgt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Na vunegna iaani, imarea kena haghore tughua vaghagna iaani, “Iti boi adoa.” Ma a Jisas ke velera, “Na vunegna koti velea iangeni, inau kuda boi veleghamu ahai ke heu na mana gi u eia na komi fata iraani.” ");
INSERT INTO bgt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","A Jisas ke velera na titiono velepuhi iaani tadia mara kena nagho tadia mara Jiu: “Sina mane ke joua na komi ghai grep kori nigna na gnatha. Govu, gi e agutua na peo me agutua na vido bali pojiagna na komi grep bali agutu waen. Gi e sokaraghinia na vathe bali kaekale. Govu, gi e hirora kekeha tinoni bali agutu me reireghia nigna na gnatha. Imanea ke velera eigna kedana hatia kekeha sagharogna na ghai grep vaghagna na volidia. Leghugna iaani, imanea ke taveti au me vano mono tagna sina meleha ke hau. ");
INSERT INTO bgt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kori vido ke jufungia na maghavu ke ghano na komi grep, imanea ke vetula nigna na mane agutu eigna keda ohoa maia itagna kekeha ghagna na sagharogna kena vihukira. ");
INSERT INTO bgt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kori vido imanea ke jufu tadia mara kena reireghia na agutu, imarea kena thotia mena tupia mena vetula tabirua vavaha vamua tagna na vunaghigna. ");
INSERT INTO bgt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Leghugna iaani, na mane ke tonogna na gnatha ke ghoi vetula vanoa mua sina nigna na mane agutu. Imarea kena pukuni diadikala puala. Imarea kena tupia mena vangesoa na ulugna. ");
INSERT INTO bgt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Gi e ghoi vetula mua sina nigna na mane agutu mena vathehea. Imanea ke ghoi vetulara vano mua kekeha mara nigna na agutu me nanaba vamua na hava kena eiragna. Imarea kena tupira kekeha mena vathehera kekeha. ");
INSERT INTO bgt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Sina mane ke ghathi mono keda vetula vanoa, a pukuni dathegna ke dothovia puala. Imanea ke toatogha keda vetula vano ba teo. Gi e vetula vanoa eigna ke ghaghana imarea kedana ghaghana bohea a dathegna. ");
INSERT INTO bgt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Kori vido imarea kena reghia, imarea kena velea varihotaghidia, ‘Iaani na pukuni dathegna na mane ke tonogna na gnatha. Gi katida vathehea, ighita katida tonogna nigna na gnatha.’ ");
INSERT INTO bgt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Gi ena thotia mena vathehea mena soni aua na tonogna kosigna na gnatha.” ");
INSERT INTO bgt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Govu, gi a Jisas ke huatira, “Na hava keda eia na mane ke tonogna na gnatha iangeni tadia mara kena reireghia vania na? Imanea keda vano me vathehera na komi tinoni ke dika irangeni me hera vano mara tavogha nigna na gnatha eigna kedana reireghia vania. ");
INSERT INTO bgt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ighamu koti adoa ghohi na fata iaani kena risoa tadia na komi Rioriso ke Tabu: ‘Na ghahira kena boi magnahaghinia mara kena agutu vathe, ikeagaieni na ghahira iaani na naghoi ghahira tadia na komi ghahira kori hidigna na vathe. ");
INSERT INTO bgt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A God ke eia na fata iaani me e toke puala itamami.’” ");
INSERT INTO bgt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mara kena nagho tadia mara Jiu, kena magnahaghinia na thotiagna a Jisas eigna kena adoa na titiono velepuhi iaani eidia imarea ghehedia - imarea na komi tinoni ke dika kena reireghia na gnatha. Keana imarea kena boi thotia eigna imarea kena mataghunira na mavitu kena totogo kori nigna na velepuhi. Imarea kena taveti sania vamua. ");
INSERT INTO bgt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Leghugna iaani, mara na Farise duadia mara kena leghua a King Herod kena vetulara vano kekeha tinoni tagna a Jisas eigna kedana huatia. Imarea kena magnahaghinia a Jisas keda velehouhorua na King gna i Rom eigna kedana thotia mena fatea. ");
INSERT INTO bgt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Imarea kena mai tagna a Jisas mena veleagna, “Velepuhi, ighami kiti adoa na komi fata ko velea ke jino meke tutuni. Kari o velepuhira mua na mavitu na komi fata a God ke magnahaghinia kedana eia. O boi mataghunia na hava kena ghaghana na mavitu eimu ighoe. Toke kedana boi magnahaghinia nimua na velepuhi, ighoe o velepuhi vamua na hava ke tutuni eigna a God. O veleghami, kori nida na vetula e toke vamua katida volia na takis tagna na King gna i Rom ba teo?” ");
INSERT INTO bgt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","A Jisas ke adoa imarea kena haga pilaunia me velera, “Ehava kotinia haga pilauniu? Oti hatia maia sikei na sileni itagua.” ");
INSERT INTO bgt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Imarea kena hatia maia itagna, gi e reghia me huatira, “Ahai na totoghalegna ma na ahagna ke mono itagna?” Imarea kena veleagna, “Na King gna i Rom.” ");
INSERT INTO bgt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma a Jisas ke velera, “Hea na King gna i Rom na hava ke kaeghamu moti hea a God na hava ke kaeghamu.” Imarea kena vere nidia puala eigna imanea ke thaothadogha puala kori nigna na haghore tughu. ");
INSERT INTO bgt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Leghugna iaani, kekeha mara na Sadiusi kena mai tagna a Jisas. Imarea kena boi vaututunia na havi tabiru leghugna na thehe. Imarea kena huatia, ");
INSERT INTO bgt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Velepuhi, a Moses ke risoa gi na mane keda thehe sania a taugna me teo mua sa dathegna, a tahigna keda taulaghi itagna na vaivine ke thehe a taugna eigna keda boa na gari itagna bali vavusua na pagusugna a toghagna ke thehe. ");
INSERT INTO bgt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Vaghagna iaani, “Mara vitu tamatahi ke mono ma na mane ke havi nagho ke taulaghi tagna sina vaivine kari e teo mua sa dathegna me thehe. ");
INSERT INTO bgt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Gi a tahigna ke taulaghi tagna na vaivine iangeni, me teo mua sa dathegna me thehe. Ma na vatolugna tadia mara tamatahi ke taulaghi tagna me nanaba vamua. ");
INSERT INTO bgt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Vano me mara vitu tamatahi gougovu kena taulaghi tagna na vaivine iangeni. Me teo sikei mane itadia ke boa sa gari tagna na vaivine iangeni mena thehe gougovu. Vagovugna, na vaivine ke thehe. ");
INSERT INTO bgt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Gi keda ai na, kori vido a God keda vasokara tabirura arahai kena thehe, ahai tadia mara tamatahi irangeni keda taugna na vaivine iangeni?” ");
INSERT INTO bgt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","A Jisas ke velera, “Oti pukuni hahi tutuni! Ighamu koti boi talu adoa na komi Rioriso ke Tabu, moti bosi thaothadoghagna a God ke mana puala. ");
INSERT INTO bgt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kori vido a God keda vasokara tabirura na komi tinoni kena thehe imarea kedana boi taulaghi, vaghadia na komi enjel kena mono i popo kena boi taulaghi. ");
INSERT INTO bgt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ikeagaieni inau kuda velepuhighamu eigna na havi tabiru kori thehe. Oti adoa mua, kori na titionogna a Moses ma na ghai iso ke beubethu na eloelogna, a God ke veleagna a Moses, ‘Inau na God nigna Ebraham, a Aisak ma a Jekob.’ Toke tolumara kotolu thehe ghohi i hau, tagna a God tolumara talu havi mua. ");
INSERT INTO bgt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A God, boi na God nidia arahai kena thehe ghohi, kari nidia na God arahai kena havi. Kori vido ighamu koti velea ighita katida boi sokara tabiru kori thehe, ighamu oti pukuni hahi tutuni!” ");
INSERT INTO bgt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sina mane velepuhigna na vetula nigna a Moses ke mono ngengeni me rongovia na hava ke velea a Jisas tadia mara na Sadiusi. Imanea ke adoa nigna na haghore tughu e toke puala me huatia a Jisas, “Na hava na vetula nigna a Moses ke nagho tadia na komi vetula gougovu?” ");
INSERT INTO bgt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Gi a Jisas ke veleagna, “A Moses ke velea iaani: ‘Ighamu na mavitugna Israel, oti vaovarongo toetoke! A God na nida na vunaghi, imanea sikei vamua a God. ");
INSERT INTO bgt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Oti dothovia kori havimiu gougovu, kori tarungamiu gougovu, kori ghaghanamiu gougovu ma na hetamiu gougovu.’ Iaani na vetula ke nagho vano tadia na komi vetula gougovu. ");
INSERT INTO bgt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na varuagna na vetula ke nagho iaani mua: ‘Dothovira na komi tinoni vaghagna ko dothovigho ghehemu.’ Teo sa vetula mua ke nagho vano tadia e rua na vetula iaani.” ");
INSERT INTO bgt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Imanea ke veleagna a Jisas, “Toke puala velepuhi! E tutuni puala na hava ko velea, sikei vamua a God, teo mua sa God tavogha. ");
INSERT INTO bgt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","E toke katida dothovia a God kori havida gougovu, kori tarungada gougovu kori ghaghanada gougovu ma na hetada gougovu. Ma katida dothovira na komi tinoni vaghagna kati dothovighita gheheda. E rua na vetula iraani ke nagho vano tadia na komi vetula kati leghua vaghagna na komi vetula eidia na komi havughaghi kati eia kori Vathe ke Tabu nigna a God.” ");
INSERT INTO bgt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","A Jisas ke adoa nigna na haghore tughu ke jino me veleagna, “Inau ku velegho, ighoe ko gharani ghohi na lubatiagna a God eigna keda vunaghi pungusia na havimu.” Leghugna iaani teo mua sa tinoni keda mathaghai na huatiagna. ");
INSERT INTO bgt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Leghugna iaani, a Jisas ke velepuhira na mavitu kori Vathe ke Tabu nigna a God. Imanea ke veleragna, “Ehava gi mara na velepuhigna na vetula nigna a Moses kena velea a Vahavi na vinahuhugna vamua a King Deved? ");
INSERT INTO bgt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Eigna sina maghavu na Tarunga ke Tabu ke batua na ghaghanagna a Deved mi manea ke velea, ‘A God ke velea tagna a vunaghigu, O nohe kori thevu madothogu me jufu kori maghavu kuda talu horua nimua na komi thevuioka i thepa eigna koda vunaghi pungusira.’ ");
INSERT INTO bgt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deved ke kiloagna a Vahavi na vunaghigna. Gi imanea na vunaghigna a Deved, ehava gi imanea na vinahuhugna a Deved mua?” Na mavitu kena rongovia na hava ke velea a Jisas mena totogo nidia puala. ");
INSERT INTO bgt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kori vido a Jisas ke velepuhira na mavitu, imanea ke velera mua iaani, “Oti saghoi leghua na puhidia mara na velepuhigna na vetula nigna a Moses! Imarea kena vahaghea nidia na poko ke tabu mena vano kori makete eigna kena magnahaghinia vamua na mavitu kedana ghithathara mena ghaghana bohera. ");
INSERT INTO bgt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kori vido imarea kena vano haghe tadia na komi vathe haidu ba kori vido kena vano kori vangahaidu, imarea kena vahia na komi nagho i sape. ");
INSERT INTO bgt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Imarea kena pilaunira na koi vaivine thehe sasani eigna kedana hera nidia na komi fata ma na vathedia. Imarea kena tarai teve eigna kena magnahaghinia vamua na mavitu kedana ghaghana imarea kena tabu puala. Mara iraani, a God keda pukuni vaparara puala!” ");
INSERT INTO bgt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","A Jisas ke nohe koragna na Vathe ke Tabu nigna a God me reghi vano tagna na vido bali sosoni rongo. Imanea ke reghira na komi tinoni kena haghe mai mena sonia nidia na rongo. Sethe mara pada rongo kena mai mena sonia haghea na rongo ke sethe. ");
INSERT INTO bgt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Gi e reghia sina vaivine thehe sasani ke kuma ke haghe mai me soni haghea e rua na siliva keda talu haidura e jufungia vamua sina seleni. ");
INSERT INTO bgt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","A Jisas ke kilora mai nigna na komi vaovarongo me velera, “E tutuni na hava ku veleghamu, na vaivine iaani e sethe vano na rongo ke sonia tadia na komi tinoni gougovu kena mai sosoni. ");
INSERT INTO bgt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Eigna na komi tinoni kena pukuni pada rongo kena sonia vamua na rongo ke tomagha tadia. Keana na vaivine iaani ke soni govua na ghathi rongo ke tonogna me teo sa nigna rongo ke tomagha bali volia ghagna vanga.” ");
INSERT INTO bgt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kori vido a Jisas ke au mai kori Vathe ke Tabu nigna a God, sina nigna na mane vaovarongo ke veleagna, “Velepuhi, na Vathe ke Tabu iaani, e ulaghagna puala! Na komi ghahira tadia na komi hidi iraani e hutu puala!” ");
INSERT INTO bgt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","A Jisas ke veleagna, “Na Vathe ke Tabu iaani, imarea kedana reo horua na komi hidigna. Teo sikei ghahira keda mono kori mathagna vaghagna kena mono ikeagaieni.” ");
INSERT INTO bgt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","A Jisas duagna nigna na komi vaovarongo kena taveti vano kori Suasupa i Ghai Olev mena reghi vanoa na Vathe ke Tabu nigna a God. A Pita, Jemes, Jon ma Andru kena mai ghehedia itagna a Jisas mena huatia, ");
INSERT INTO bgt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“O veleghami, ingiha kedana reo horua na Vathe ke Tabu nigna a God iangeni? Na hava na vaughithatha kitida reghia giti adoa ke jufu mai na maghavu iangeni?” ");
INSERT INTO bgt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","A Jisas ke velera, “Oti reireghi toke ghamu, kenughua e pilaunighamu sa tinoni. ");
INSERT INTO bgt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Eigna sethe na tinoni kedana mai mena velea, ‘Inau a Vahavi,’ me sethe na tinoni kedana vaututunira. ");
INSERT INTO bgt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kori vido kotida rongovia na rorongogna na komi rihu hutu, oti saghoi mataghu. Toke keda tutuni, boi na vagovugna na maramagna mua. ");
INSERT INTO bgt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sethe na meleha kori maramagna kedana riurihu varihotaghidia ma na agnu keda agnu tadia na komi meleha ke sethe. Me sethe na tinoni kori maramagna kedana thehe eigna na ngengere. Na komi fata iraani na turughugna vamua na papara keda mai. ");
INSERT INTO bgt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Oti reireghi toke ghamu! Eigna imarea kedana fateghamu mena thabuhighamu tadia na komi vathe haidu nidia mara Jiu. Imarea kedana hatighamu vano tadia na koi vunaghi ma na komi king mena fateghamu eigna ighamu koti leghuu inau. Kori vido koti sokara naghodia, ighamu kotida tuturia aua na Rorongo ke Toke itadia. ");
INSERT INTO bgt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na Rorongo ke Toke kedana rongovia na komi tinoni gougovu kori maramagna gi e jufu mai na vagovugna na maramagna. ");
INSERT INTO bgt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kori vido kena fateghamu, oti saghoi toatogha na hava kotida velea. Oti velea vamua na hava na Tarunga ke Tabu ke heghamu kori vido iangeni. Na komi fata kotida velea boi na ghaghanamiu ghehemiu keana na ghaghanagna na Tarunga ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Na komi tinoni kedana perora ara tahidia mara dathedia kori limadia mara na thevuioka bali vathehera. Vaghagna mua na komi gari kedana siriuhaghinira ara idodia mara tamadia mena perora vano kori limadia mara na thevuioka bali vathehera. ");
INSERT INTO bgt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na komi tinoni kedana siriuhaghinighamu eigna ighamu koti leghuu inau. Keana gi kotida sokara ngasi kori nimiu na vaututuni me jufu kori vido kotida thehe, ighamu kotida hatia na havi ke teo na govugna.” ");
INSERT INTO bgt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","A Jisas ke ghoi velera, “Kori dani keda mai, ighamu kotida reghia na fata ke dika vano a God ke siriuhaghinia. Na fata iangeni keda sokara kori Vathe ke Tabu nigna a God tagna bali boi monoagna. Na vunegna iaani, a God keda korogha sania nigna na Vathe ke Tabu.” (Arahai kena ijumia na haghore iaani, oti hiohiro toetokea na pukuni ghaghanagna.) “Kori dani iangeni, gi kotida mono kori provins i Jiudea, oti ghogho hadi tadia na komi suasupa. ");
INSERT INTO bgt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Gi kotida mono kosigna na vathe, saghoi raghe haghe bali hatia kekeha nimiu na fata. ");
INSERT INTO bgt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Gi kotida agutu kori gnatha, saghoi tabiru bali hatia nimiu oopo. ");
INSERT INTO bgt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kori vido iangeni, na mataghu keda padara na koi vaivine kena gharani vahua a dathedia ma arahai kena talu susuua mua a dathedia eigna kenughua e vahotha puala na ghoghodia. ");
INSERT INTO bgt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Oti tarai kaea a God eigna keda boi mono mai na komi fata iangeni kori vido ke mai na koburu ");
INSERT INTO bgt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","eigna na papara kori vido iangeni keda dika vano tadia na komi papara ke mono mai kori maramagna. Leghugna iangeni, teo mua sa fata vaghagna iangeni keda ghoi mono mai. ");
INSERT INTO bgt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Keana, na vunegna a God ke dothovira nigna na mavitu ke vahira ghohi, imanea keda hati aua kekeha dani papara. Gi keda boi hati aua imanea kekeha dani papara, teo sa tinoni keda havi. ");
INSERT INTO bgt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Gi ahai tinoni keda veleghamu, ‘Na mane iaani a Vahavi!’ ba ‘Na mane iangeni a Vahavi!’ Oti saghoi vaututunia. ");
INSERT INTO bgt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sethe na tinoni piapilau kedana velea, ‘Inau a Vahavi,’ me sethe mara na profet piapilau kedana mai mua. Imarea kedana eia na komi reghithehe bali pilaura me vajefera arahai a God ke vahira ghohi, kari boi tangomana nidia. ");
INSERT INTO bgt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Oti reireghi toke ghamu! Inau ku veleghamu na fata iraani gi ena jufu mai.” ");
INSERT INTO bgt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Gi a Jisas ke velera, “Leghugna na komi papara iraani, ‘Na aho keda boi raraha, ma na vula keda puni, ");
INSERT INTO bgt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ma na komi vaitughu kedana sikili horu mai i popo. Ma na komi fata gougovu kori maaloa kedana ghaighali.’ ");
INSERT INTO bgt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ma na komi tinoni gougovu kedana reghiu, inau, na Dathei Tinoni, kuda tabiru mai kori parako duagu na mana ke heta ma na silada. ");
INSERT INTO bgt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Govu, gi inau kuda vetulara au komi nigua na enjel itadia na komi meleha gougovu kori maramagna eigna kedana hathatanora mai na komi tinoni a God ke kidi vahira ghohi.” ");
INSERT INTO bgt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","A Jisas ke ghoi velera, “Oti reghia na ghai fig eigna keda velepuhighamu. Gi kotida reghia na ghai fig ke dudu me turughu vusu ighamu koti adoa ke haga sagharo ghohi. ");
INSERT INTO bgt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Vaghagna mua iangeni, kori vido na komi papara keda jufu mai, ighamu kotida adoa inau ku gharani mai ghohi. ");
INSERT INTO bgt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Inau ku veleghamu, na komi fata iraani keda kidi jufu mai gi na komi tinoni kena mono ikeagaieni kedana thehe gougovu. ");
INSERT INTO bgt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Na thepa ma na maaloa kedana govu, kari nigua na komi haghore keda boi govu. ");
INSERT INTO bgt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Teo ahai ke adoa na dani ma na maghavu inau kuda tabiru mai. Mara na enjel boi adoa. Inau boi adoa. Sikei vamua a Tamagu ke adoa. ");
INSERT INTO bgt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Na vunegna iaani, oti reireghi toke ghamu moti kaikaliti toetoke eigna ighamu oti boi adoa ingiha inau kuda ghoi tabiru mai. ");
INSERT INTO bgt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na tabiru mai kuda eia ke vaghagna vamua na tinoni ke kaikaliti bali taveti nigna. Imanea ke vaututunia nigna na komi mane agutu keda reireghia nigna na vathe. Imanea ke velera nidia na agutu kedana eia, gi e boa sina mane kori hagetha bali kavena me reghia na tabirugna mai. ");
INSERT INTO bgt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Vaghagna vamua iangeni, oti sokara moti dodoro toetoke! Eigna ighamu koti boi adoa ingiha kuda ghoi tabiru mai, vaghagna vamua imarea kena boi adoa ingiha na mane ke tonogna na vathe keda ghoi tabiru mai. E boi toke gi kotida nere moti peperiki kori vido kuda ghoi tabiru mai. Da kori lavi ba kori hotaghi bongi ba kori gharani dani inau kuda ghoi tabiru mai. ");
INSERT INTO bgt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na hava ku veleghamu, inau ghua ku velera na komi tinoni gougovu: Oti mono kaikaliti eigna na tabirugu mai!” ");
INSERT INTO bgt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Rua mua na dani ke mono gi e jufungia na Laulahugna na Thovoliungi ma na Laulahugna na Bred ke Teo na Isi Koragna. Mara na naghoi pris mi mara na velepuhigna na vetula nigna a Moses kena hiohiro puhi eigna kedana thotia mena vathehea a Jisas kori puhi kedana boi adoa na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Imarea kena velea, “Ati saghoi eia tadia na komi dani kati eia na laulahu, kenughua ena adoa na mavitu mena eia na rihu hutu.” ");
INSERT INTO bgt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","A Jisas ke vano kori vathegna a Saimon i Betani, na mane ke toke tabiru kori lepa. Kori vido kena nohe mena vanga, sina vaivine ke haghe mai duai botolo ke ulaghagna ke mono na oela i koragna. Na oela iangeni e ghuba tokegna puala me vahotha puala na voligna. Iia ke hangavia me rotea kori ulugna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kekeha tinoni kena mono ngengeni kena reghia mena dikatadia tagna na vaivine iangeni mena haohaghore ghehedia, “Ehava gi e hai rote diadikala na oela iangeni? ");
INSERT INTO bgt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Na botolo oela iangeni vaghagna keda salemua, da e hatia tolu hathangatu tomagha na siliva. Kari hatia me kemulia vanira mara na kuma.” Mi marea kena velehouhorua. ");
INSERT INTO bgt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma a Jisas ke velera, “Oti talua! Saghoi velehouhorua! Iia ke eia vaniu na fata ke toke puala. ");
INSERT INTO bgt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ighamu tangomana kotida hathera mara na kuma kori vido koti magnahaghinia eigna kena mono duamiu hahali. Keana inau kuda boi mono duamiu hahali. ");
INSERT INTO bgt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iia ke rotea na oela kori tonogu bali kaikalitia gi e jufu mai na maghavu imarea kedana giluu. Na fata ke eia na vaivine iaani e toke puala. ");
INSERT INTO bgt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na hava ku veleghamu ke tutuni, ivei kedana titionoa na Rorongo ke Toke koragna na maramagna, imarea kedana titiono na hava ke eia na vaivine iaani mena togha tabirua iia.” ");
INSERT INTO bgt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","A Jiudas Iskariot, imanea sikei tadia nigna na komi vaovarongo a Jisas, ke vano tadia mara na naghoi pris me velera imanea keda peroa a Jisas eigna kedana vathehea. ");
INSERT INTO bgt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kori vido imarea kena rongovia iaani, imarea kena totogo puala. Gi ena taluhaghore vania kedana hea na rongo. Leghugna iangeni, a Jiudas ke pitua na maghavu ke toke keda lubatia a Jisas vanira. ");
INSERT INTO bgt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kori vido ke jufu mai na dani ke nagho kori Laulahugna na Bred ke Teo na Isi Koragna, mara Jiu kena vathehea na komi sip mathangani bali vanga kori Laulahugna na Thovoliungi. Kori vido iangeni nigna na komi vaovarongo kena huatia a Jisas, “Ivei ko magnahaghinighami kitida vano bali kaikalitia na Laulahugna na Thovoliungi?” ");
INSERT INTO bgt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ma a Jisas ke velera e rua nigna na mane vaovarongo, “Oro vano kori meleha hutu i Jerusalem. Kori vido koroda jufu ngengeni, roghamu koroda pada sina mane ke toitoi bea. Oro leghua moro vano kori vido keda vano. ");
INSERT INTO bgt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Imanea keda vano haghe kori vathe. Ingengeni roghamu koroda pada na mane ke tonogna na vathe moro kaea eigna na chogho katida vanga na Laulahugna na Thovoliungi. ");
INSERT INTO bgt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Imanea keda hatighamu hadi bali reghia na chogho ke kaikalitira govu ghohi na komi fata. Ngengeni koroda kaikalitia na vanga.” ");
INSERT INTO bgt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Romara koro vano moro reghia na komi fata gougovu vaghagna vamua a Jisas ke kidi veleragna ghohi. Gi oro kaikalitia na vanga ngengeni. ");
INSERT INTO bgt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kori lavi a Jisas duagna nigna na komi vaovarongo kena vano mena jufu kori vathe iangeni. ");
INSERT INTO bgt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kori vido kena nohe mena vanga, a Jisas ke velera, “Sina mane itamiu ke vanga duagu ikeagaieni, imanea keda perou.” ");
INSERT INTO bgt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kori vido a Jisas ke velea iangeni, nigna na komi vaovarongo kena dikahehedia, mi imarea gougovu kena huatiagna a Jisas, “Boi inau, na?” ");
INSERT INTO bgt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A Jisas ke haghore tughura, “Sina mane itamiu, ighamu koti sakai vanga duagu tagna sina disi.” ");
INSERT INTO bgt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mi manea ke velera, “Inau, na Dathei Tinoni, kuda papara mu thehe vaghagna na komi Rioriso ke Tabu kena velea. Keana kenughua e dika vano tagna ahai ke perou vano tagna nigua na thevuioka. Na tinoni iangeni e toke vamua keda boi havi mai kori maramagna eigna imanea keda pada na papara ke hutu puala.” ");
INSERT INTO bgt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kori vido kena vanga, a Jisas ke hatia na bred me veletokea a God. Gi e vidoa me kemulia itadia nigna na komi vaovarongo me velera, “Oti hatia moti ghania. Iaani na tonogu.” ");
INSERT INTO bgt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Gi e hatia na hinao ke mono na waen ikoragna me veletokea a God me hera nigna na komi vaovarongo. Gi ena kouvia. ");
INSERT INTO bgt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma a Jisas ke velera, “Iaani na ghaughabuagu keda lulu bali vahavira na komi tinoni ke sethe. Na ghaughabuagu keda kaputi ngasia na taluhaghore haehathe mathangani nigna a God. ");
INSERT INTO bgt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Inau ku veleghamu: Inau kuda boi ghoi kouvia na waen me ghieghilei jufungia na maghavu inau kuda kouvia na waen mathangani kori hughuta nigna a God i popo.” ");
INSERT INTO bgt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Gi ena salea na hymn mena taveti vano kori Suasupa i Ghai Olev. ");
INSERT INTO bgt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Gi a Jisas ke velera, “Ighamu gougovu kotida ghogho moti korogha saniu vaghagna na komi Rioriso ke Tabu kena velea, ‘A God keda vathehea na mane ke reireghia na komi sip, ma na komi sip kedana ghogho kilili.’ ");
INSERT INTO bgt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Keana, kori vido kuda sokara tabiru kori thehe, inau kuda kidi taveti nagho atu itamiu kori provins i Galili.” ");
INSERT INTO bgt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma a Pita ke veleagna, “Toke kedana ghogho sanigho mara na vaovarongo gougovu, inau teo kuda ghogho sanigho!” ");
INSERT INTO bgt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","A Jisas ke veleagna a Pita, “Inau ku velegho, kenughua bongi, gi na kokorako keda rua horui tangigna, ighoe koda tolu horui veleagna o boi adou.” ");
INSERT INTO bgt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","A Pita ke haghore heta vania, “Toke kuda thehe duamu, teo kuda velea inau ku boi adogho.” Mara na vaovarongo gougovu kena taluhaghore vaghagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","A Jisas duagna nigna na komi vaovarongo kena vano jufu kori vido kena kiloagna i Getsemani, gi e velera, “Oti nohe eeni, inau kuda vano mu tarai.” ");
INSERT INTO bgt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Me hatira aua itadia a Pita, Jemes ma Jon mena taveti vano sina vido. A Jisas ke dikahehegna puala eigna na komi fata keda kathea, ");
INSERT INTO bgt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","me velera e tolu nigna na mane vaovarongo, “Na dikahehe hutu puala ke padau me haga vatheheu. Otolu rarai moti mono eeni.” ");
INSERT INTO bgt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Imanea ke taveti vano sina vido gi e torongaghi tuturu me tarai, “Mama, gi koda tangomana, o saghoi lubatiu gi kuda papara mu thehe. ");
INSERT INTO bgt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","E teo sa fata keda vahotha itamua. Saghoi lubatiu gi kuda papara vaghagna iaani. Keana o saghoi leghua nigua na vanohehe kari nimua na vanohehe vamua.” ");
INSERT INTO bgt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Gi a Jisas ke tabiru mai tadia tolu nigna mane vaovarongo me reghira kena nere. Gi e veleagna a Pita, “Saimon, o nere nimua vamua? Boi tangomana koda rarai duagu sikei na ghathi aoa vamua? ");
INSERT INTO bgt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Otolu rarai motolu tarai eigna keda boi mai na auau itamiu. Tolughamu kotolu magnahaghinia na eiagna na hava ke jino, kari boi tangomana nimiu eigna na tonomiu ke lae.” ");
INSERT INTO bgt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A Jisas ke ghoi tabiru vano me tarai vaghagna na tarai ke kidi eia vamua. ");
INSERT INTO bgt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Gi e ghoi tabiru mai itadia me reghira tolumara kotolu ghoi nere mua eigna kotolu magoli nidia puala. Kori vido imanea ke raraira, tolumara boi adoa sa fata kotoluda veleagna. ");
INSERT INTO bgt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Gi a Jisas ke ghoi vano tarai. Kori vido ke ghoi tabiru mai itadia na vatolugna, imanea ke velera, “Ehava? Otolu talu nere nimiu mua? E naba ghohi! Na maghavu ke jufu mai ghohi. Sina tinoni keda perou inau, na Dathei Tinoni, kori limadia mara na koakoa. ");
INSERT INTO bgt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ahai keda perou ke mai ghohi iangeni. Sokara hadi mati atu itagna!” ");
INSERT INTO bgt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kori vido a Jisas ke talu haohaghore mua, a Jiudas, sikei itadia mara salaghe rua, ke jufu mai itadia. Sethe na tinoni kena mai duagna kena tangolira na komi ghau ma na komi ghai bali rihu. Mara na naghoi pris, mi mara na velepuhigna na vetula nigna a Moses, me kekeha mara puhi mua kena vetulara mai. ");
INSERT INTO bgt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A Jiudas ke kidi velera ghohi na mavitu, “Ahai inau kuda kisia, iangeni imanea. Oti thotia moti hatia.” ");
INSERT INTO bgt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","A Jiudas ke mai tagna a Jisas me velea, “Velepuhi!” Me kisia. ");
INSERT INTO bgt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Gi imarea kena mai mena thotia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kori vido iangeni sina nigna na vaovarongo a Jisas ke sokara hilighagna ke sipa aua nigna na ghau me toka vurukusua sina kuligna nigna na mane agutu na pukuni naghoi pris. ");
INSERT INTO bgt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A Jisas ke velera, “Ehava? Inau na mane geogeno gi oti tangolia maia duamiu na komi ghau ma na komi ghai bali rihu? ");
INSERT INTO bgt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Leuleghu dani ighamu koti mono kori Vathe ke Tabu nigna a God kori vido ku velepuhira na komi tinoni. Ehava gi oti boi thotiu ingengeni? Keana ighamu koti eia na komi fata iraani eigna keda tutuni na hava ke velea na komi Rioriso ke Tabu eigu inau.” ");
INSERT INTO bgt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mara nigna na komi vaovarongo kena mataghu mena ghogho sania a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sina mane mathangani, ke pipisia na pohe vavaha vamua, ke leghua a Jisas. Imarea kena thotia ");
INSERT INTO bgt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","me pepete me suru na pohegna me ghogho soesole. ");
INSERT INTO bgt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Imarea kena hati vanoa a Jisas kori vathegna na pukuni naghoi pris. Mara na naghoi pris, mara na velepuhigna na vetula nigna a Moses, mi kekeha mara puhi kena mai haidu ingengeni. Mara iraani, mara na Kansol. ");
INSERT INTO bgt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","A Pita ke leghura kari e boi taveti gharanira eigna ke mataghu. Imanea ke jufu kori lalabagna na vathe iangeni, me mangiru duadia mara kena reireghia na Vathe ke Tabu nigna a God. ");
INSERT INTO bgt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mara na Kansol kena hiohiroa na titionogna sa fata ke eia a Jisas ke nabagna na vatheheagna. Kari ena boi tangomana kedana pada sikei. ");
INSERT INTO bgt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sethe na komi tinoni kena mai titiono piapilau eigna a Jisas kari nidia na komi titiono e boi nanaba. ");
INSERT INTO bgt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kekeha tinoni mua kena sokara hadi ngengeni kena titiono piapilau eigna imanea mena velea, ");
INSERT INTO bgt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ighami kiti rongovia imanea ke velea, ‘Inau kuda reoa horua na Vathe ke Tabu nigna a God kena agutua na komi tinoni mi koragna e tolu na dani inau kuda vasokaraghinia na Vathe ke Tabu ke mathangani kena boi agutua na komi tinoni.’” ");
INSERT INTO bgt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kari na komi titiono gougovu iraani, e boi nanaba. ");
INSERT INTO bgt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Me sokara hadi na pukuni naghoi pris kori naghodia mara na Kansol me huatia a Jisas, “Ehava konia boi velea sa fata tadia na komi tinoni kena titionogho?” ");
INSERT INTO bgt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","A Jisas ke bughoro me boi velea sa fata. Ma na pukuni naghoi pris ke ghoi huatia, “Ehava? Ighoe a Vahavi, a Dathegna a God ke haluhadi puala?” ");
INSERT INTO bgt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","A Jisas ke haghore tughua, “Hii, inau imanea! Ighamu kotida reghiu inau, na Dathei Tinoni, kuda nohe kori madothogna a God ke mana puala. Ighamu kotida reghiu inau kuda tabiru mai kori parako.” ");
INSERT INTO bgt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ma na pukuni naghoi pris ke rongovia iaani me dikatagna puala me resua nigna na oopo. Gi e velea, “Ati saghoi hiroa mua sa titiono itadia sa tinoni ");
INSERT INTO bgt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","eigna ighamu oti rongovia ghehemiu ghohi imanea ke vananaba ghehegna duagna a God kori vido ke velea, ‘Inau a Vahavi, a Dathegna a God.’ Ehava kori ghaghanamiu na?” Imarea gougovu kena velea a Jisas ke nabagna keda thehe. ");
INSERT INTO bgt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Gi kekeha itadia kena angusua mena tari ponotia na matagna kori pohe. Govu, gi ena tupia mena velea, “Gi koda pukuni Dathegna a God, o veleghami, ahai ke tupigho?” Leghugna iaani, mara na soldia kena hatia mena tupia mua. ");
INSERT INTO bgt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kori vido imarea kena fatea a Jisas, a Pita ke talu mono mua kori lalabagna na vathegna na pukuni naghoi pris. Sina nigna na vaivine agutu na naghoi pris ke mai ngengeni. ");
INSERT INTO bgt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Iia ke reghia a Pita ke mangiru me veleagna, “Ighoe sikei tadia mara kena mono duagna a Jisas gna i Nasaret.” ");
INSERT INTO bgt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma a Pita ke veleagna, “Teo! U boi adoa na hava ko velea.” Gi e sokara hadi me riu vano kori hagethagna na peo. Kori vido iangeni, na kokorako ke taitangi. ");
INSERT INTO bgt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma na vaivine iangeni ke ghoi reghia a Pita me velera na komi tinoni kena mono ngengeni, “Inau ku adoa iaani sina mane itadia.” ");
INSERT INTO bgt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","A Pita ke ghoi velea, “Teo! U boi adoa na mane iangeni.” Boi hauhaugna kekeha tinoni kena sokara ingengeni kena veleagna, “Hii, ighoe sikei itadia, eigna ighoe huju na manemu i Galili.” ");
INSERT INTO bgt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","A Pita ke jijighi kori ahagna a God me velea, “Inau u boi adoa na mane koti titionoa.” ");
INSERT INTO bgt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","A Pita ke eu govu horu na veleagna iaani ma na kokorako ke varuai taitangigna. Ma a Pita ke togha tabirua na haghore a Jisas ke kidi veleagna, “Inau ku velegho, kenughua bongi, gi na kokorako keda rua horui tangigna, ighoe koda tolu horui veleagna o boi adou.” Ma a Pita ke dikahehegna puala me tangi me tangi. ");
INSERT INTO bgt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kori vuevugheigna, mara na Kansol kena ghoi haidu mena talu haidua na ghaghanadia gougovu eigna na hava kedana eiagna a Jisas. Govu, gi imarea kena velera mara na soldia eigna kedana taria na limagna mena hati vanoa tagna Pailat, na Primia kori provins i Jiudea. ");
INSERT INTO bgt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kori vido imarea kena jufu kori vathegna a Pailat, imanea ke huatia a Jisas, “Ighoe na king nidia mara Jiu?” A Jisas ke veleagna, “Ighoe ko velea ghohi inau imanea.” ");
INSERT INTO bgt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mara na naghoi pris kena toroagna a Jisas na komi fata ke sethe. ");
INSERT INTO bgt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Gi a Pailat ke huatia a Jisas, “O rongovia mua na komi fata imarea kena toroghogna? O boi tangomana koda velea sa fata itadia?” ");
INSERT INTO bgt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Keana a Jisas ke boi velea sa fata, ma Pailat ke vere nigna puala. ");
INSERT INTO bgt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Leuleghu vinogha kori Laulahugna na Thovoliungi, a Pailat ke ado lubati aua kori vathe tatari sina tinoni kena kaea na mavitu. ");
INSERT INTO bgt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sina mane na ahagna a Barabas ke mono kori vathe tatari duagna kekeha mara kena thabu vathehera kekeha tinoni kori vido imarea kena rihu pungusia na gaumanegna i Rom. ");
INSERT INTO bgt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na mavitu kena mai itagna a Pailat mena kaea eigna keda lubati mamaluha vanira sina mane tatari vaghagna ke ado eia. ");
INSERT INTO bgt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","A Pailat ke huatira, “Ehava? Oti magnahaghinia kuda lubati mamaluha a Jisas, nimiu na king ghamu mara Jiu?” ");
INSERT INTO bgt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","A Pailat ke velea iangeni eigna imanea ke adoa ghohi mara na naghoi pris kena thotia a Jisas eigna kena tahotha tagna. ");
INSERT INTO bgt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Keana mara na naghoi pris kena velehuhurura na mavitu eigna kedana kaea a Pailat meke lubati aua a Barabas, boi a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat ke ghoi huatira na mavitu, “Gi kuda lubati aua a Barabas, na hava kuda eiagna na mane ighamu koti kiloagna na king nidia mara Jiu?” ");
INSERT INTO bgt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Imarea kena ghuu heta, “Tupipuhia!” ");
INSERT INTO bgt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","A Pailat ke velera, “Eigna na hava? Na hava ke ei hahia?” Kari imarea kena ghoi ghuu heta vano mua, “Tupipuhia!” ");
INSERT INTO bgt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","A Pailat ke magnahaghinia na mavitu kedana totogo me lubati aua a Barabas vanira. Gi e velera mara na soldia eigna kedana thabuhia a Jisas mena tupipuhia. ");
INSERT INTO bgt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mara na soldia kena hatia a Jisas mena vano kori lalaba ghaghireigna na vathegna a Pailat. Gi ena kilora mai sethe mua na soldia kena mono ngengeni. ");
INSERT INTO bgt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Imarea kena vapokoagna a Jisas vaghagna na king kori poko mela ke teve. Mena vakepiagna na kepi kena agutua kori kuji. ");
INSERT INTO bgt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Imarea kena vahaihadia mena ghuu, “Ighami kiti kilothabagho, ighoe na king nidia mara Jiu!” ");
INSERT INTO bgt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Gi ena thabuhia na ulugna kori ghai, mena angusua mena torongaghi tuturu vania vaghagna imarea kena maimanihihia. ");
INSERT INTO bgt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Govu na leuleuagna, gi ena hati aua na poko ke mela ke vahaghea. Gi ena ghoi vapokoagna komi nigna na poko mena hati vanoa bali tupipuhia. ");
INSERT INTO bgt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kori vido kena taetaveti kori hangana, imarea kena pada sina manegna Sairini ke kalasu mai kosigna i Jerusalem. Na ahagna a Saimon, a tamadia Aleksanda ma Rufus. Mara na soldia kena huruagna eigna keda hulungia nigna na ghaibabala a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Imarea kena hati vanoa a Jisas kori vido kena kiloagna Golgota, na ghaghana koragna, “Suasupa ulu.” ");
INSERT INTO bgt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ingengeni imarea kena hea na waen kena ngignoa duagna na meresen kena kiloagna “mur” bali vagovua na vavahaghiti. Kari a Jisas ke boi kouvia. ");
INSERT INTO bgt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mara na soldia kena tupipuhia a Jisas kori ghaibabala. Gi ena hatia nigna na komi poko mena laulahu vavahi bali adoa ahai keda hatia sikei na vidogna. ");
INSERT INTO bgt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nabagna tangi hia kori vuevughei, imarea kena tupipuhia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Gi ena risoa kori pava na hava kena toroagna a Jisas, “NA KINGh NIDIA MARA JIU,” mena tupia popogna a Jisas kori ghaibabala. ");
INSERT INTO bgt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Imarea kena tupipuhira e rua na mane bilau duagna a Jisas; sikei kori madothogna mi sikei kori toigna. ");
INSERT INTO bgt_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Vaghagna vamua iaani hiri na komi Rioriso ke Tabu kena vela ghohi, “Na komi tinoni kena velea imanea ke jotha duadia arahai kena eia na komi fata ke dika.” ");
INSERT INTO bgt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na komi tinoni kena halu vano kori hangana ngengeni kena velehouhorua mena lilighia na uludia mena veleagna, “E ai ghuari! Ighoe ko velea i hau koda reo horua na Vathe ke Tabu nigna a God mo vasokaraghini tabirua koragna e tolu na dani. ");
INSERT INTO bgt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Gi koda mono nimua na mana bali eia iangeni, o vahavigho ghehemu mo horu mai kori ghaibabala!” ");
INSERT INTO bgt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mara na naghoi pris mi mara na velepuhigna na vetula nigna a Moses kena velehouhorua a Jisas mena haohaghore ghehedia, “Imanea ke vahavira kekeha tinoni tavogha kari boi tangomana nigna keda vahavia ghehegna! ");
INSERT INTO bgt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Vaghagna ivei? Imanea hina a Vahavi, na king nidia mara Jiu? Gi ighita katida reghia keda horu mai kori ghaibabala, ighita katida vaututunia.” Rua na mane kena tupipuhira duagna a Jisas huju, oro velehouhorua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tangi salaghe rua kori dani iangeni, na meleha i Israel doudolu ke puni me jufu kori tangi tolu kori hinaota lavi. ");
INSERT INTO bgt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kori vido iangeni a Jisas ke ghuu heta vaghagna iaani, “Eloi, Eloi, lama sabaktani?” Na ghaghana koragna, “Nigua God, nigua God, eigna na hava konia korogha saniu?” ");
INSERT INTO bgt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kekeha tinoni kena mono gharania ngengeni kena boi rongovia tokea mena velea, “Imanea ke kiloa a Elaija.” ");
INSERT INTO bgt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sina mane ke raghe vano me vavonua na pocho kori waen ke aha me jongia kori ghai. Govu, gi e tuhu hadi vano kori livogna a Jisas eigna keda kouvia, gi e velea iaani, “Ati talua. Ati pitu mati reghia gi a Elaija keda mai hati horua kori ghaibabala.” ");
INSERT INTO bgt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Gi a Jisas ke ghuu heta me thehe. ");
INSERT INTO bgt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kori vido iaani, na pohe ke sasavera koragna na Vathe ke Tabu nigna a God ke resu turughu i popo me jufu kori kokotogna. ");
INSERT INTO bgt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sina mane ke nagho tadia mara na soldia ke sokara naghogna na ghaibabala ke mono a Jisas. Imanea ke reghia na puhi thehe ke eia a Jisas me velea, “Tutuni, iaani pukuni Dathegna a God!” ");
INSERT INTO bgt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Kekeha vaivine kena leghua a Jisas i Jerusalem kena mono ngengeni. Ira kena dodoro mai tagna ke hau. Kekeha tadia; a Meri gna i Magdala, Salome, ma Meri idodia a Jemes iso ma a Joses. Kori vido a Jisas ke taetaveti i Galili, tolu na vaivine iraani kena leghua mena hathea imanea kori rongo ma na vanga. ");
INSERT INTO bgt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Meke haga lavi ghohi kori dani iangeni, na dani bali kaikaliti eigna na Sabat. Sina mane, na ahagna a Josep, ke mai tagna Pailat. Imanea na manegna i Arimatea. Imanea ke mono kori Kansol ke fatea a Jisas, ma na mavitu kena ghaghana bohea. Imanea sina mane ke mono pitua na reghiagna na maghavu a God keda vunaghi pungusia nigna na mavitu. A Josep ke hatia na hetagna me vano tagna a Pailat me kaea eigna keda hatia na tonogna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","A Pailat ke vere nigna puala na rongoviagna a Jisas ke thehe ghohi. Gi e kiloa mai itagna na mane ke nagho tadia mara na soldia me huatia, “Ehava? A Jisas ke thehe ghohi?” ");
INSERT INTO bgt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Imanea ke veleagna, “Hii, e thehe ghohi.” Gi a Pailat ke lubati vania a Josep eigna keda hatia na tonogna. ");
INSERT INTO bgt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ma Josep ke vano me volia na pohe pura ke teve me hati horua na tonogna a Jisas me filehiagna me vano boa korai luma kena jouua kori ghahira. Govu, gi imanea ke kokopilia na ghahira hutu me ponotia na hagethagna na luma. ");
INSERT INTO bgt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kori vido iangeni, Meri gna i Magdala, ma Meri a idogna a Joses, iroira koro mono ngengeni moro reghia na vido kena boa na tonogna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kori lavigna na Sarere, kori vido ke govu ghohi na Sabat, a Meri gna i Magdala ma Meri, a idogna Jemes tolira a Salome kena kidi volia ghohi na sedi bali kaikalitia na tonogna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kori vuevugheigna na Sade ke eu sogala hadi na aho, tolira kotolu vano kori luma ke mono na tonogna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kori vido kena taetaveti vano kori hangana, tolira kotolu haohaghore ghehedia, “Ahai keda hatheghita na kokopili auagna na ghahira hutu kori hagethagna na luma?” ");
INSERT INTO bgt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tolira kotolu jufu ngengeni, mena reghia na ghahira ke kokopili au ghohi. ");
INSERT INTO bgt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tolira kotolu taveti haghe vano kori luma mena reghia sina mane mathangani ke nohe kori thevu madotho. Na mane iangeni ke vahaghea na poko ke pura. Kori vido kotolu reghia imanea, tolira kotolu mataghu puala. ");
INSERT INTO bgt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na mane iangeni ke velera, “O tolu saghoi mataghu! Inau ku adoa tolughamu kotolu hiroa a Jisas gna i Nasaret kena tupipuhia. Imanea ke teo ieeni! Imanea ke sokara tabiru ghohi kori thehe! Reghia! Iaani na vido kena talua na tonogna. ");
INSERT INTO bgt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Otolu vano tabiru motolu titiono vaghagna iaani vanira mara na vaovarongo, haluhadia a Pita, ‘A Jisas keda kidi atu i Galili. Ingengeni ighamu kotida reghia vaghagna ke veleghamu ghohi gi e thehe.’” ");
INSERT INTO bgt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tolira kotolu rughu au kori luma motolu hahi hehedia motolu aiariri. Gi kotolu ghogho motolu boi veleagna ahai na hava kena reghia eigna kotolu mataghu puala. ");
INSERT INTO bgt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kori vuevughei punigna na Sade iangeni, a Jisas ke sokara tabiru kori thehe. Gi e kidi tate vania Meri gna i Magdala. I hau, a Jisas ke gigi aura e vitu na tidatho itagna. ");
INSERT INTO bgt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Iia ke vano tadia mara kena leghua a Jisas. Imarea kena dikahehedia puala mena tangi. ");
INSERT INTO bgt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kori vido iia ke titiono vanira ke reghia a Jisas ke havi tabiru, imarea kena boi vaututunia. ");
INSERT INTO bgt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Leghugna iaani a Jisas ke tate vanira e rua nigna na mane vaovarongo kori vido koro taetaveti vano kori hangana kosigna i Jerusalem. Kori vido koro kidi reghia a Jisas, romara koro boi ghithatha eigna ke tavogha na dodorogna. ");
INSERT INTO bgt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kori vido koro adoa imanea a Jisas, romara koro tabiru i Jerusalem moro titionoa tadia mara na vaovarongo kari ena boi vaututunira. ");
INSERT INTO bgt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Vagovugna, a Jisas ke tate vanira mara salaghe sikei nigna na vaovarongo kori vido kena vangahaidu. Imanea ke haghore heta vanira eigna nidia na vaututuni ke boi heta. Imarea kena boi vaututunira arahai kena reghia imanea leghugna ke sokara tabiru kori thehe. ");
INSERT INTO bgt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Gi imanea ke velera, “Oti taveti au tadia na komi meleha kori maramagna moti titionoa na Rorongo ke Toke tadia na komi tinoni gougovu. ");
INSERT INTO bgt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Arahai kena vaututunia na Rorongo ke Toke mena siuvitabu, imarea kedana hatia tagna a God na havi ke teo na govugna. Kari arahai kena boi vaututunia, a God keda fatera me boi lubatira gi kedana mono duagna hahali. ");
INSERT INTO bgt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na komi tinoni kena vaututuni, a God keda hera na mana bali eia na komi reghithehe. Imarea kedana gigi aura na komi tidatho kori kiloagna na ahagu mena haohaghore tadia na komi haghore tavogha kena boi pipilia. ");
INSERT INTO bgt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Gi kedana tangolira na komi poli ba kedana kouvira na komi fata ke lulumu, teo kedana thehe. Imarea kedana tabora mara kena vahaghi me kedana toke tabiru.” ");
INSERT INTO bgt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Leghugna a Lod Jisas ke govua na titiono vaniragna, a God ke hati hadia duagna i popo ma a Jisas ke nohe kori madothogna. ");
INSERT INTO bgt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Leghugna iaani, nigna na komi vaovarongo kena taveti au tadia na komi meleha mena titionoa na Rorongo ke Toke eigna a Jisas. A Lod ke mono duadia me hathera mena eia na komi reghithehe kori nigna na mana. Na komi reghithehe kena eia bali adora na mavitu na hava kena titiono e tutuni. ");
INSERT INTO bgt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Toke nighe Tiofilus, Sethe na tinoni kena risoa ghohi eigna na komi fata ke eia a Jisas kori vido ke mono duamami. ");
INSERT INTO bgt_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Imarea kena risoa eidia na komi fata ighami kiti rongovia tadia arahai kena reghia kori matadia. Arahai kena reghia na komi fata irangeni kena agutu vania a God kori titionoagna na rorongogna imanea tadia na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mane puhi Tiofilus, inau ku pukuni hiohiro toetokea mu pukuni adoa na titionogna a Jisas kori turughugna, mu magnahaghinia kuda risoa vanigho, ");
INSERT INTO bgt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","eigna koda adoa na komi fata kena velepuhigho eigna a Jisas ke tutuni. ");
INSERT INTO bgt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kori vido a Herod ke king kori provins i Jiudea, sina pris ke mono, na ahagna a Sakaria. Imanea sikei kori boo pris kena kiloagna Abia. A taugna Sakaria, a Elisabet, ke havi mai kori vinahuhugna a Aron, na mane ke kidi batura mara pris i hau. ");
INSERT INTO bgt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iroira koro mono jino kori matagna a God eigna iroira koro leghua nigna na komi vetula gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Keana iroira ke teo sa dathedia eigna a Elisabet ke kara. Iroira koro kuekue moro kaekave ghohi. ");
INSERT INTO bgt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sina maghavu, nigna na boo pris a Sakaria kena agutu kori Vathe ke Tabu nigna a God, eigna ke jufu mai ghohi na wik bali agutu nigna na boo pris imanea. ");
INSERT INTO bgt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Leghuagna na vetula nidia mara na pris, imarea kena laulahu vavahi eigna kedana adoa ahai keda haghe pughulia na ghaighubagha kori Vathe ke Tabu. Ma a Sakaria kena vahipada me vano haghe. ");
INSERT INTO bgt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kori vido a Sakaria ke pughulia na ghaighubagha, na mavitu sethe kena haidu kosigna na Vathe ke Tabu mena tarai. ");
INSERT INTO bgt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sina enjel nigna God ke tate vania a Sakaria. Na enjel ke mai sokara kori madothogna na olta kena ado pughulia na ghaighubagha itagna. ");
INSERT INTO bgt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","A Sakaria ke reghia me peperiki me mataghu nigna puala. ");
INSERT INTO bgt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma na enjel ke velea, “Sakaria, o saghoi mataghu! A God ke rongovia ghohi nimua na tarai, ma Elisabet a taumu keda vahua a dathemu mane. Mi ghoe koda tughuniagna a Jon. ");
INSERT INTO bgt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Roghamu koroda totogo puala eigna imanea, me sethe na tinoni kedana totogo eigna na havigna mai ");
INSERT INTO bgt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","eigna a God ke vathaba. Imanea keda boi kouvia na waen ma na komi kou keda vameea. Na Tarunga ke Tabu keda mono duagna turughu kori vido ke mono kori kutugna idogna. ");
INSERT INTO bgt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Sethe na tinonidia Israel imanea keda hati tabirura tagna a Lod na nidia a God. ");
INSERT INTO bgt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Imanea keda mono nigna na mana ke heta vaghagna a profet Elaija. Imanea keda kidi nagho mai tagna a Lod eigna keda kaikalitira na komi tinoni eigna na maiagna. Imanea keda hathera tamadia na komi gari eigna kedana ghoi mono kori soleana duadia ara dathedia. Mi manea keda tughua na ghaghanadia arahai kena boi leghua a God eigna kedana leghua na puhidia arahai kena jino.” ");
INSERT INTO bgt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ma a Sakaria ke huatia na enjel, “Ehava gi kuda adoa iaani ke tutuni? Eigna inau ku kuekue ghohi ma a taugu ke kaekave ghohi.” ");
INSERT INTO bgt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma na enjel ke haghore tughua, “Inau a enjel Gabriel ku mono hahali duagna a God. Imanea ke vetulau mai itamua gi kuda tuturia vanigho na rorongo ke toke iaani. ");
INSERT INTO bgt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kari eigna ighoe ko boi vaututunia na hava ku velegho, ighoe koda boi haohaghore me ghieghilei jufungia na dani a dathemu keda havi mai. Na komi haghoregu keda tutuni kori pukuni maghavugna. ");
INSERT INTO bgt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kori vido iangeni na mavitu kena tarai kosi kena pitua a Sakaria keda au mai. Imarea kena ghaghana ruarua eigna na vunegna imanea ke mono hau puala koragna na Vathe ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kori vido ke au mai i kosi, imanea ke bosi tangomana na haohaghore itadia na mavitu me haghore kori limagna vamua. Mi marea kena adoa sina fata ke tate vania koragna na Vathe ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kori vido ke govu nigna na wik bali agutu, Sakaria ke tabiru kori vathegna. ");
INSERT INTO bgt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Boi hauhaugna leghugna iaani, a Elisabet ke boebote me mono bughoro kori vathedia e lima na vula. Iia ke haghore vaghagna iaani, ");
INSERT INTO bgt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ikeagaieni a Lod God ke rongovia nigua na tarai. Imanea ke dothoviu me vagovua nigua na maomamo.” ");
INSERT INTO bgt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kori vido a Elisabet ke ono ghohi na vulagna na boebote, a God ke vetula a enjel Gabriel kori meleha i Nasaret kori provins i Galili. ");
INSERT INTO bgt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Imanea ke mai tagna sina vaivine mathangani ke boi nere mua duagna sa mane. Na ahagna na vaivine iangeni a Meri. Iia ke parua ghohi bali taulaghi tagna na mane na ahagna a Josep. A Josep ke havi kori vikegna a King Deved. ");
INSERT INTO bgt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A enjel Gabriel ke vano itagna me veleagna, “Na soleana keda mono itamua a Meri. A God ke mono duamu me vatokegho.” ");
INSERT INTO bgt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meri ke hahi hehegna me hiohirogna puala na ghaghanagna na komi haghore iraani. ");
INSERT INTO bgt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ma na enjel ke velea, “O saghoi mataghu Meri, eigna a God ke magnahaghinia na vatokeghogna. ");
INSERT INTO bgt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ighoe koda boebote mo koda vahua a dathemu mane mo koda kiloagna na ahagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Imanea keda nagho mi marea kedana kiloagna a Dathegna a God ke thaba haluhadi puala. Ma a Lod God keda vasopoua kori sapei vunaghi vaghagna a hutugna King Deved. ");
INSERT INTO bgt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Imanea keda vunaghi pungusira hahali mara Israel ma na nigna na vunaghi pungusiragna teo keda govu.” ");
INSERT INTO bgt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","A Meri ke haghore tughu vania na enjel, “Ehava gi keda tutuni iaani? Eigna inau ku boi nere mua duagna sa mane?” ");
INSERT INTO bgt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma na enjel ke velea, “Na Tarunga ke Tabu keda horu mai itamua ma na mana nigna a God ke thaba haluhadi puala keda ungahigho. Na vunegna iaani na meomeo keda havi mai itamua, na meomeo ke tabu. Imarea kedana kiloagna a Dathegna God. ");
INSERT INTO bgt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ma a Elisabet, a toghamu ke kaekave ghohi, keda vahua na gari. Na komi tinoni kena velea e teo ghohi keda vahua sa gari, kari ikeagaieni iia ke boebote me ono ghohi na vulagna. ");
INSERT INTO bgt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Teo sa fata ke vahothahaghinia a God na eiagna.” ");
INSERT INTO bgt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma Meri ke ania, “Inau na tinoni tango nigna a Lod God. E toke gi keda tutuni na komi fata ko veleu.” Ma na enjel ke taveti sania. ");
INSERT INTO bgt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Boi hau leghugna iangeni, a Meri ke kaikaliti me taveti saisami vano kori sina meleha iso tadia na komi suasupa kori provins i Jiudea. ");
INSERT INTO bgt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A Meri ke jufu ngengeni me vano haghe kori vathegna a Sakaria me haghore totogo vania a Elisabet. ");
INSERT INTO bgt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kori vido a Elisabet ke rongovia nigna na haghore totogo a Meri, na gari korai kutugna ke bubutu ma Elisabet ke vonungia na Tarunga ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Me haghore heta vaghagna iaani, “A God ke vatokegho ighoe tuu vano tadia na koi vaivine gougovu, me keda vatokea na gari ighoe koda vahua. ");
INSERT INTO bgt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","God ke vatokeu, eigna ighoe, a idogna nigua a Lod, ke mai sighou. ");
INSERT INTO bgt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Inau ku adoa ighoe a idogna nigua a Lod, eigna kori vido inau ku rongovia nimua na haghore totogo, na meomeo korai kutugu ke bubutu eigna ke totogo puala. ");
INSERT INTO bgt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A God keda vatokegho eigna ko vaututunia na hava ke taluhaghorea vanigho keda pukuni tate mai!” ");
INSERT INTO bgt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A Meri ke velea, “Na hehegu gougovu ke kilothaba a Lod God. ");
INSERT INTO bgt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ma na tarungagu ke lealea eigna a God, nigua a Vahavi. ");
INSERT INTO bgt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Toke inau ku boi nagho, imanea ke toghau inau, nigna na tinoni tango. Turughugna ikeagaieni me vano, na komi tinoni gougovu kedana velea a God ke vatokeu ");
INSERT INTO bgt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","eigna ke eia vaniu na komi naghoi fata kori nigna na mana. Na ahagna ke tabu. ");
INSERT INTO bgt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Imanea ke rarovira arahai kena ghaghana bohea tagna na komi pagusu gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kori nigna na mana imanea ke eia na komi naghoi fata ke sethe. Me gigi aura mara kena tautalunagho kori ghaghanadia ghehedia. ");
INSERT INTO bgt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Imanea ke hati aua nidia na mana na komi king, me vathabara arahai kena mono taluleghu. ");
INSERT INTO bgt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Imanea ke hera ghadia arahai kena rofo itagna na komi fata ke toke, me vetulara au vavaha arahai kena padarongo. ");
INSERT INTO bgt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","God ke hathera mara Israel, nigna na komi tinoni tango, me rarovira Ebraham ma na komi vinahuhugna hahali, vaghagna ke taluhaghorea vanira ara hutuda. ");
INSERT INTO bgt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ma a Meri ke mono duagna Elisabet nabagna e tolu na vula gi e tabiru kori melehagna i Nasaret. ");
INSERT INTO bgt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","A Elisabet ke jufungia ghohi na vulagna keda vahuhu, gi e vahua a dathegna mane. ");
INSERT INTO bgt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ara vikegna ma arahai kena mono gharania kena rongovia na fata ke toke a Lod ke ei vania, mena totogo duagna. ");
INSERT INTO bgt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kori vido na meomeo ke alu ghohi na danigna, imarea kena haidu mai bali sogivaughithatha na meomeo leghuagna na vetula nidia mara Jiu. Imarea kena magnahaghinia na kiloagna a Sakaria, na ahagna a tamagna. ");
INSERT INTO bgt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kari a idogna ke haghore heta vanira, “Teo! Na ahagna a Jon!” ");
INSERT INTO bgt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma na komi tinoni kena velea, “Teo sikei tinoni tadia ara vikemu kena tughunira na aha iangeni.” ");
INSERT INTO bgt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mena haghore kori limadia vania a Sakaria, tamagna na gari, bali adoa na aha imanea keda tughunia. ");
INSERT INTO bgt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma a Sakaria ke haghore kori limagna eigna kedana hea na fata bali rioriso itagna. Gi e risoa, “Na ahagna na meomeo a Jon.” Ma na mavitu kena vere nidia puala. ");
INSERT INTO bgt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kori vido vamua iangeni, a Sakaria ke tangomana na haohaghore me kilothaba a God. ");
INSERT INTO bgt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na komi tinoni kena haidu ingengeni kena vere nidia puala, ma na rorongogna na komi fata iraani ke jufu tadia na komi tinoni kena mono tadia na komi suasupa kori provins i Jiudea. ");
INSERT INTO bgt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma na mavitu kena rongovira na komi fata irangeni, imarea kena toatogha puala mena velea, “Na gari iaani sina naghoi tinoni ivughei valiha.” Imarea kena velea iaani eigna kena adoa na mana nigna God ke mono itagna. ");
INSERT INTO bgt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A Sakaria tamagna a Jon ke vonungia na Tarunga ke Tabu, me tuturi aua na hava a God ke velea: ");
INSERT INTO bgt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ighita kati kilothaba a Lod, nida a God ighita mara Israel, eigna imanea ke mai me vamamaluhara nigna na mavitu. ");
INSERT INTO bgt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Imanea ke heghita a Vahavi ke heta tagna na vinahuhugna a King Deved, nigna na mane agutu. ");
INSERT INTO bgt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","A God ke kidi taluhaghore vanighita iaani kori haghoredia nigna na komi profet i hau. ");
INSERT INTO bgt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Imanea ke taluhaghorea gi keda vahavighita tagna nida na thevuioka, mi tagna na limadia na komi tinoni kena siriuhaghinighita. ");
INSERT INTO bgt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Imanea ke rarovira ara hutuda, eigna ke talu ghaghana bohea nigna na taluhaghore ke tabu, ");
INSERT INTO bgt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Na taluhaghore iangeni, imanea ke jijighi vania a tamada Ebraham, ");
INSERT INTO bgt_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","na bali vahavighita tagna nida na thevuioka, eigna katida boi mataghunira kori vido ighita kati tango vania a God ");
INSERT INTO bgt_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kori puhi ke tabu meke jino tagna na matagna kori havida gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ighoe a dathegu, imarea kedana kiloghogna na profet nigna a God ke thaba puala eigna ighoe koda kidi taveti nagho atu tagna a Lod bali kalitia nigna na hangana. ");
INSERT INTO bgt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ighoe koda titiono vanira nigna na mavitu a God, imanea tangomana keda vahavira kori vido ke talutavogha na paluhadia. ");
INSERT INTO bgt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nida a God keda eia iangeni eigna ke rarovighita. Vaghagna na aho ke sogala hadi, a Vahavida keda mai i popo ");
INSERT INTO bgt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","bali silada tadia arahai kena mono kori puni mena mono saragna na mana nigna na thehe. Imanea keda batughita eigna katida mono kori soleana.” ");
INSERT INTO bgt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jon ke hutu hadi ma na Tarunga ke Tabu ke vaheta na ghaghanagna. Imanea ke vano me mono kori meleha ke gou me ghieghilei jufungia na maghavu ke turughu na tuturiagna vanira mara Israel. ");
INSERT INTO bgt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kori vido a Jon ke iso mua, na King gna i Rom, na ahagna Ogastas, ke risoa me vetula aua sina vetula bali risoa na ahadia na komi tinoni gougovu tadia na komi meleha ke vunaghi pungusira. ");
INSERT INTO bgt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Iaani na rioriso aha ke nagho kena eia kori vido a Kuirinius ke primia kori provins i Siria.) ");
INSERT INTO bgt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na komi tinoni gougovu kena vano tadia na komi pukuni melehadia eigna na gaumane keda mai risoa na ahadia. ");
INSERT INTO bgt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","A Josep ke turughu mai kori meleha i Nasaret kori provins i Galili me taveti hadi i Betlehem, na melehagna King Deved kori provins i Jiudea. Josep ke vano i Betlehem eigna imanea sikei kori vinahuhugna a King Deved. ");
INSERT INTO bgt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A Josep ke vano bali riso horua na ahagna duagna a Meri, na vaivine ke parua ghohi bali taugna. Kori vido iangeni a Meri ke boebote ghohi. ");
INSERT INTO bgt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kori vido monodia i Betlehem, a Meri ke jufungia ghohi na maghavu keda vahua na gari. ");
INSERT INTO bgt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A Meri ke vahua dathegna mane me filehiagna kori pohe me vakolia tagna na bali vangadia na komi fata kaukagu. Iia ke eia iaani eigna ke vonu ghohi na vathe binaboli. ");
INSERT INTO bgt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kekeha mara kena mono kosigna na meleha kori bongi iangeni, mena reireghira nidia na komi sip. ");
INSERT INTO bgt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sina enjel nigna a God ke horu mai itadia ma na silada ke mai tagna a Lod God ke silada kililivira, mena mataghu puala. ");
INSERT INTO bgt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma na enjel ke haghore vanira, “Oti saghoi mataghu! Inau ku hatia mai na rorongo ke toke keda vatotogora na komi tinoni gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kori dani iaani, ahai keda vahavighamu ke havi mai kori melehagna a King Deved. Imanea a Krais a Lod. ");
INSERT INTO bgt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iaani nimiu na vaughithatha: Ighamu kotida reghia na meomeo kena filehia kori pohe mena vakolia tagna na bali vangadia na komi fata kaukagu.” ");
INSERT INTO bgt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kori vido iangeni vamua na komi enjel i popo kena mai duagna na enjel iangeni mena kilothaba a God vaghagna iaani, ");
INSERT INTO bgt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kilothaba a God i popo, na soleana keda mono duadia arahai kori maramagna ke totogo eidia a God.” ");
INSERT INTO bgt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na komi enjel kena tabiru hadi i popo, mi mara na reireghi sip kena vapuipuhi mena titiono varihotaghidia, “Ati atu i Betlehem eigna katida atu mati reghia na hava a God ke tuturia vanighita.” ");
INSERT INTO bgt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Imarea kena saisami taveti vano mena pada a Meri ma a Josep ma na meomeo ke koli tagna na bali vangadia na komi fata kaukagu. ");
INSERT INTO bgt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kori vido kena reghia na meomeo, imarea kena titionoa na komi fata na enjel ke tuturia vanira eigna na meomeo. ");
INSERT INTO bgt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na mavitu kena rongovia na rorongo kena hati maia mara na reireghi sip mena vere nidia puala. ");
INSERT INTO bgt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma a Meri ke boi madoa na komi fata iraani me toatoghara hahali. ");
INSERT INTO bgt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mara na reireghi sip kena tabiru mena kilothaba a God eigna na komi fata kena rongovia mena reghia. Na komi fata iraani vaghagna vamua na enjel ke velea vanira. ");
INSERT INTO bgt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na meomeo ke jufungia e alu ghohi na danigna, gi ena sogivaughithatha mena tughuni ahagna a Jisas. Iangeni na aha na enjel ke veleagna a Meri kori vido ke boi boebote mua. ");
INSERT INTO bgt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Me jufu mai ghohi na dani a Josep ma a Meri koroda eia na hava ke velea na vetula nigna a Moses bali vararahara ghehedia kori matagna a God leghugna na havigna na gari. Iroira koro hati vanoa na gari kori Vathe ke Tabu nigna a God i Jerusalem eigna koroda hea vanoa a Lod God. ");
INSERT INTO bgt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Eigna na vetula nigna a Moses ke velea, “Na gari mane ke havi nagho imarea kedana hea a Lod God.” ");
INSERT INTO bgt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Iroira koro eia mua na havughaghi leghuagna na vetula nigna a Lod God ke velea imarea kedana havughaghi e rua na bora ba e rua na dathe babahulu. ");
INSERT INTO bgt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kori vido iangeni sina mane ke mono i Jerusalem, na ahagna a Simeon. Imanea na mane jino me leghua a God hahali. Imanea ke pitua na maghavu a God keda vahavira mara Israel ma na Tarunga ke Tabu ke mono itagna. ");
INSERT INTO bgt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na Tarunga ke Tabu ke velea ghohi gi imanea keda boi thehe me ghieghilei reghia a Vahavi, na mane a God ke taluhaghorea keda vetula mai. ");
INSERT INTO bgt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na Tarunga ke Tabu ke batu vanoa a Simeon kori Vathe ke Tabu nigna a God. Kori vido a Simeon ke mono ngengeni, a Josep ma Meri koro hatia maia a Jisas bali hea vanoa a God vaghagna ke velea na vetula nigna a Moses. ");
INSERT INTO bgt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Gi a Simeon ke pala hadia na gari me kilothaba a God. Imanea ke velea, ");
INSERT INTO bgt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Lod God, ikeagaieni tangomana inau kuda thehe kori soleana. Vaghagna ko kidi taluhaghore vaniu, ");
INSERT INTO bgt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","inau ku reghia ghohi a Vahavi ");
INSERT INTO bgt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ighoe ko hera na komi tinoni gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Imanea keda vaghagna na lui keda laema na hangana ke tutuni tadia arahai kena boi Jiu me keda abeghami hadi, nimua na mavitu i Israel.” ");
INSERT INTO bgt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","A tamagna ma idogna koro vere rodia puala na rongoviagna na hava ke velea a Simeon eigna a dathedia. ");
INSERT INTO bgt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon ke vatokera gi e veleagna a Meri a idogna a Jisas, “Na meomeo iaani, a God ke vahia ghohi i hau eigna sethe na tinonigna i Israel imanea keda vahavira. Me sethe mua na tinonigna i Israel, imanea keda boi vahavira eigna imarea kedana boi vaututunia. Imanea keda vaghagna na vaughithatha keda vavotura na komi tinoni. Keana sethe na tinoni kedana siriuhaghinia, ");
INSERT INTO bgt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ma na komi fata ke mono polo kori ghaghanadia keda tateli aua. Ma na dikahehe hutu puala keda vahaghitigho, vaghagna kena sogigho kori ghau.” ");
INSERT INTO bgt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Sina kaekave ke profet, na ahagna a Ana, ke mono mua ngengeni. Iia a dathegna a Fanuel ke havi mai kori vinahuhugna a Aser. Kori vido mathanganigna, iia ke taulaghi koragna e vitu na vinogha vamua me thehe sania a taugna. ");
INSERT INTO bgt_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Iia ke talu havi me jufu vati tutughu vati na vinoghagna. Leuleghu dani ma na bongi iia ke vano kori Vathe ke Tabu nigna a God me sota me tarai hahali ngengeni. ");
INSERT INTO bgt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kori vido a Simeon ke talu titiono duadia Josep ma Meri, Ana ke vano tadia me veletokea a God eigna a dathedia. Gi e titionoa eigna a Jisas tadia na komi tinoni kena pitua na maghavu a God keda vahavira mara i Israel. ");
INSERT INTO bgt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","A Josep ma a Meri koro ei govua na komi fata ke velea kori vetula nigna a Lod God, gi oro tabiru vano kori melehadia i Nasaret kori provins i Galili. ");
INSERT INTO bgt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma na gari ke hutu hadi na tonogna me heta me pukuni thaothadogha, ma a God ke vatokea. ");
INSERT INTO bgt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Leuleghu vinogha a idogna ma a tamagna a Jisas koro hadi i Jerusalem eigna na Laulahugna na Thovoliungi. ");
INSERT INTO bgt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kori vido a Jisas ke jufungia e salaghe rua na vinoghagna, a idogna ma tamagna koro ghoi vano tagna na laulahu iangeni vaghagna koro ado ei hahalia, moro hatia a Jisas duadia. ");
INSERT INTO bgt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Leghugna ke govu ghohi na laulahu, a idogna ma tamagna a Jisas koro turughu tabiru kori melehadia ma a Jisas ke mono horu i Jerusalem. Kari iroira koro boi adoa. ");
INSERT INTO bgt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kori ghaghanadia imanea da e tabiru duadia kekeha tinoni ke adoa tadia na mavitu moro taveti na dani doudolu. Gi oro turughu na hiroagna tadia ara vikedia mara kuladia. ");
INSERT INTO bgt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kari iroira koro boi reghipada gi oro tabiru i Jerusalem moro hiroa ngengeni. ");
INSERT INTO bgt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kori vatolugna na dani, iroira koro vano reghipada kori Vathe ke Tabu nigna a God. Imanea ke nohe duadia mara na velepuhigna na vetula nigna a Moses me vaovarongo me huahuatira. ");
INSERT INTO bgt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma na komi tinoni kena rongovia kena vere nidia puala nigna na thaothadogha ma nigna na komi haghore tughu. ");
INSERT INTO bgt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kori vido a Josep ma Meri koro reghipada, iroira koro vere rodia puala. Ma a idogna ke ania, “Dathegu, ehava kona eia vanighami iaani? Iroghami a tamamu kuru hirogho muru mataghu eigna da sa fata ke dika ke padagho.” ");
INSERT INTO bgt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma a Jisas ke velera, “Eigna na hava korona hirou ivei mi vei? Iroghamu tangomana koroda adoa inau kuda mono kori vathegna a tamagu. ");
INSERT INTO bgt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Keana iroira koro boi adoa na ghaghana ikoragna na komi haghore iraani. ");
INSERT INTO bgt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ma Jisas ke tabiru duadia i Nasaret me leghu hahalia na komi fata koro veleagna. A idogna ke togha hahalia na komi fata iraani kori ghaghanagna. ");
INSERT INTO bgt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma a Jisas ke hutu hadi me vonungia na thaothadogha. A God ma na komi tinoni kena totogo puala eigna imanea. ");
INSERT INTO bgt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kori salaghe limagna na vinogha a Tiberias ke King gna i Rom, a Pontius Pailat ke primia i Jiudea, ma a Herod Antipas ke vunaghi pungusia na provins i Galili. Filip, a tahigna Herod, ke vunaghi pungusira e rua na provins i Iturea mi Trakonitis, ma Lisanias ke vunaghi pungusia na provins i Abilene. ");
INSERT INTO bgt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ma Anas ma Kaiafas, romara koro vunaghidia mara na pris. Kori vido iangeni a Jon, dathegna a Sakaria, ke mono kori meleha ke gou, ma a God ke hea nigna na komi haghore. ");
INSERT INTO bgt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","A Jon ke taetaveti tadia na komi meleha ghaghireigna na bea hutu i Jodan me titiono vanira na komi tinoni. Imanea ke velera, “Oti tughua na havimiu ke koakoa moti siuvitabu, ma a God keda talutavogha na komi paluhamiu.” ");
INSERT INTO bgt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","A profet Aisaia ke risoa i hau eigna na maiagna a Jon. Imanea ke velea, “Sina mane keda haohaghore heta kori meleha ke gou, ‘Oti kaikalitia na hangana vania a Lod moti vajinoa na bali taetavetigna. ");
INSERT INTO bgt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Oti kuvurira na komi logu moti vanatara na komi suasupa ma na mathaghughu. Na komi hangana ke thoithoki, oti vajinora. Ma na komi hangana ke sethe na lodu itadia, oti kuvuri toetokera. ");
INSERT INTO bgt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma na komi tinoni gougovu kedana reghia a God keda vahavira.’” ");
INSERT INTO bgt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","E sethe na tinoni kena mai tagna Jon eigna keda siuvitabura. A Jon ke velera kekeha itadia, “Ighamu koti dika vaghagna na komi poli! Ehava? Ighamu koti ghaghana gi kotida siuvitabu vamua, ighamu tangomana kotida polo tagna na fate a God keda eia? Boi tangomana nimiu! ");
INSERT INTO bgt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Oti kidi eia na komi fata ke jino bali tateli aua ighamu koti tughua na havimiu ke koakoa, gi oti mai moti siuvitabu itagua. Oti saghoi ghaghana a God keda boi fateghamu eigna koti havi mai kori vikegna a hutuda a Ebraham. Eigna inau ku veleghamu, a God ke tangomana keda eia na komi ghahira iraani gi kedana ara vinahuhugna a Ebraham. ");
INSERT INTO bgt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ikeagaieni a God ke kaikaliti ghohi bali fatera na komi tinoni kena boi tughua na havidia, vaghagna ahai ke kaikaliti na toka horuagna na komi ghai. Na komi ghai ke boi toke na sagharodia, imanea keda toka horura me keda soni vanoa kori joto.” ");
INSERT INTO bgt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ma na mavitu kena huatia a Jon, “Na hava kitida eia bali tateli aua ighami kiti tughua na havimami ke koakoa.” ");
INSERT INTO bgt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A Jon ke haghore tughura, “Ahai itamiu ke tonogna e rua na oopo, imanea keda hea sikei ahai ke teo nigna. Gi ahai ke mono ghagna vanga, imanea keda kemulia vanira arahai ke teo sa ghadia vanga.” ");
INSERT INTO bgt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kekeha mara na oho takis kena mai eigna kedana siuvitabu. Imarea kena huatia, “Velepuhi, Na hava kitida eia bali tateli aua ighami kiti tughua na komi puhimami ke dika?” ");
INSERT INTO bgt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A Jon ke anira, “Oti kaea vamua tadia na komi tinoni engiha ke velea na vetula moti saghoi kaea na rongo ke sethe vano tagna iangeni.” ");
INSERT INTO bgt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kekeha soldia kena huatia, “Ighami eni ba? Na hava kitida eia?” Imanea ke anira, “Oti saghoi hurura na komi tinoni eigna kedana heghamu na rongo. Moti saghoi vuha haghore eigna sa tinoni eigna kotida hatia nigna na rongo. Oti totogo vamua engiha na volimiu kena heghamu.” ");
INSERT INTO bgt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na komi tinoni kena ghaghana na maigna a Vahavi e gharani mai ghohi, mena ghaghana da a Jon imanea a God ke vahia. ");
INSERT INTO bgt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ma Jon ke velera, “Inau ku siuvitabughamu kori bea, keana ahai keda mai leghugu, imanea ke thaba vano itagua. Inau boi naba kuda hati aua nigna na sadol. Imanea keda siuvitabughamu kori Tarunga ke Tabu ma na joto. ");
INSERT INTO bgt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Imanea ke kaikaliti na fateragna na komi tinoni, vaghagna na tinoni ke vugnua na wit. Imanea ke hatia na komi ghanogna me boa kori vathegna, keana imanea keda pughulira na komi ghuighuligna kori joto ke teo na thehegna.” ");
INSERT INTO bgt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sethe na titiono a Jon ke eia vaghagna iangeni kori vido ke tuturi aua na Rorongo ke Toke tadia na komi tinoni me velera eigna kedana leghua. ");
INSERT INTO bgt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Leghugna iangeni, a Jon ke haghore heta vania a Herod Antipas na king, eigna ke hatia me taulaghi tagna a Herodias, a taugna a tahigna. Mi manea ke eira kekeha fata mua ke dika puala. ");
INSERT INTO bgt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Me sina fata ke eia ke dika vano, imanea ke thotia a Jon me boa haghea kori vathe tatari. ");
INSERT INTO bgt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kori vido kena boi boa haghea mua a Jon kori vathe tatari, imanea ke siuvitabura na komi tinoni gi e siuvitabua mua a Jisas. Kori vido iangeni a Jisas ke tarai ma na maaloa ke hangavi, ");
INSERT INTO bgt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma na Tarunga ke Tabu ke horu mai popogna ma na dodorogna ke vaghagna na bora. Ma na ohai haghore ke haghore mai i popo me ania, “Ighoe a pukuni dathegu. Inau ku totogo puala eimu ighoe mu ku dothovigho.” ");
INSERT INTO bgt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kori vido a Jisas ke jufungia e tolu hangavulu na vinoghagna, imanea ke turughua nigna na komi agutu. Kori ghaghanadia na komi tinoni, a Jisas a dathegna a Josep. Ma a Josep a dathegna a Heli ");
INSERT INTO bgt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli dathegna Matat Matat dathegna Livai Livai dathegna Melki Melki dathegna Janai Janai dathegna Josep ");
INSERT INTO bgt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep dathegna Matatias Matatias dathegna Amos Amos dathegna Nahum Nahum dathegna Esli Esli dathegna Nagai ");
INSERT INTO bgt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai dathegna Meata Meata dathegna Matatias Matatias dathegna Semein Semein dathegna Josek Josek dathegna Joda ");
INSERT INTO bgt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda dathegna Joanan Joanan dathegna Resa Resa dathegna Serababel Serababel dathegna Sealtiel Sealtiel dathegna Neri ");
INSERT INTO bgt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri dathegna Melki Melki dathegna Adi Adi dathegna Kosam Kosam dathegna Elmadam Elmadam dathegna Ere ");
INSERT INTO bgt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere dathegna Josua Josua dathegna Eliesa Eliesa dathegna Jorim Jorim dathegna Matat Matat dathegna Livai ");
INSERT INTO bgt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai dathegna Simeon Simeon dathegna Jiuda Jiuda dathegna Josep Josep dathegna Jonam Jonam dathegna Eliakim ");
INSERT INTO bgt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim dathegna Melea Melea dathegna Mena Mena dathegna Matata Matata dathegna Natan Natan dathegna Deved ");
INSERT INTO bgt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deved dathegna Jesi Jesi dathegna Obed Obed dathegna Boas Boas dathegna Salmon Salmon dathegna Nason ");
INSERT INTO bgt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason dathegna Aminadab Aminadab dathegna Admin Admin dathegna Ani Ani dathegna Hesron Hesron dathegna Pires Pires dathegna Jiuda ");
INSERT INTO bgt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jiuda dathegna Jekob Jekob dathegna Aisak Aisak dathegna Ebraham Ebraham dathegna Tera Tera dathegna Naho ");
INSERT INTO bgt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho dathegna Serug Serug dathegna Reu Reu dathegna Felek Felek dathegna Eba Eba dathegna Sela ");
INSERT INTO bgt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela dathegna Kainan Kainan dathegna Afaksad Afaksad dathegna Siem Siem dathegna Noa Noa dathegna Lamek ");
INSERT INTO bgt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek dathegna Metusala Metusala dathegna Inok Inok dathegna Jared Jared dathegna Mahalalel Mahalalel dathegna Kenan ");
INSERT INTO bgt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan dathegna Enos Enos dathegna Set Set dathegna Adam Adam dathegna God. ");
INSERT INTO bgt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kori vido a Jisas ke taveti sania na bea hutu i Jodan, na Tarunga ke Tabu ke vonungia. Me batu vanoa a Jisas kori meleha ke gou. ");
INSERT INTO bgt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A Satan ke auaua a Jisas ngengeni koragna e rua tutughu na dani. Kori vido iangeni a Jisas ke boi vanga me rofo nigna puala kori vagovugna na komi dani irangeni. ");
INSERT INTO bgt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A Satan ke ania, “Gi keda tutuni ighoe pukuni Dathegna a God, o haghore vania na ghahira iaani meke vuhai bred.” ");
INSERT INTO bgt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisas ke haghore tughua, “Na komi Rioriso ke Tabu kena velea na komi tinoni kena boi havi kori bred vamua.” ");
INSERT INTO bgt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Gi a Satan ke batu vanoa a Jisas tagna sina vido ke hadi puala, me saisami tuhua vania na komi meleha hutu koragna na maramagna. ");
INSERT INTO bgt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Ma a Satan ke ania, “Gi koda torongaghi tuturu horu mo maimanihihiu, ighoe koda vunaghi pungusira na komi meleha iraani mu kuda hegho atu nidia na komi fata ke toke. Eigna na komi fata iraani na nigua, mu tangomana kuda hea ahai ku vahia.” ");
INSERT INTO bgt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma a Jisas ke haghore tughua, “Na komi Rioriso ke Tabu kena velea, ‘A Lod na nimiu a God vamua kotida maimanihihia moti agutu vania.’” ");
INSERT INTO bgt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Leghugna iangeni a Satan ke ghoi batu vanoa a Jisas i Jerusalem me veleagna eigna keda sokara kori vido ke hadi puala popogna na Vathe ke Tabu nigna a God. Gi a Satan ke veleagna a Jisas, “Gi ighoe a Dathegna a God, o sogala horu. ");
INSERT INTO bgt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Eigna na komi Rioriso ke Tabu kena velea, ‘God keda velera nigna na komi enjel eigna kedana reireghigho. ");
INSERT INTO bgt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Imarea kedana lakugho me teo keda kathea sa ghahira na naemu.’” ");
INSERT INTO bgt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A Jisas ke haghore tughua, “Na komi Rioriso ke Tabu kena velea, ‘Saghoi eia sa fata bali huruagna a Lod na nimiu God eigna keda eia vanighamu na hava ke taluhaghorea.’” ");
INSERT INTO bgt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kori vido a Satan ke govua na auaugna a Jisas tagna na komi fata iraani, imanea ke taveti sania a Jisas me pitua sa maghavu ke toke keda ghoi auaua. ");
INSERT INTO bgt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Leghugna iangeni a Jisas ke ghoi tabiru vano kori provins i Galili, ma na mana nigna na Tarunga ke Tabu ke mono duagna. Na rorongogna imanea ke jufu tadia na komi meleha kori provins iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A Jisas ke velepuhira na mavitu tadia na komi vathe haidu nidia mara Jiu, ma na komi tinoni gougovu kena kilothaba imanea. ");
INSERT INTO bgt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","A Jisas ke tabiru i Nasaret, na meleha ke hutu hadi itagna. Kori Sabat imanea ke vano kori vathe haidu vaghagna ke ado eia hahalia. Imanea ke sokara hadi eigna keda ijumia na Rioriso ke Tabu vanira na mavitu. ");
INSERT INTO bgt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Imarea kena hea na pepa viviloho kena risoa itagna nigna na rioriso a profet Aisaia. A Jisas ke vurehea me reghipada na vido ke velea iaani: ");
INSERT INTO bgt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Na Tarunga ke Tabu nigna a God ke mono duagu, eigna imanea ke vahiu ghohi eigna kuda tuturia na Rorongo ke Toke tadia arahai kena kuma. Imanea ke vetulau mai eigna kuda tuturi aua, imarea kedana vamamaluhara arahai kena mono kori vathe tatari ma arahai kena doa kedana ghoi reirei, ma arahai kena mono papara kori limadia arahai tavogha, imarea kedana mono mamaluha. ");
INSERT INTO bgt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Inau kuda tuturia aua na maghavu a God keda vahavira nigna na komi tinoni e gharani mai ghohi.” ");
INSERT INTO bgt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Govu gi e lopoa na rioriso me hea tabirua na mane ke batua na tarai me nohe eigna keda velepuhira. Na mavitu gougovu kena mono koragna na vathe haidu kena buta vano itagna. ");
INSERT INTO bgt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma a Jisas ke anira, “Na hava ku ijumia vanighamu atu e tutuni ikeagaieni.” ");
INSERT INTO bgt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma na komi tinoni ngengeni kena titionoa na komi fata ke toke eigna a Jisas mena vere nidia puala nigna na haghore ke toke ke velea. Keana, gi ena velea, “Ehava gi ai? Eigna imanea a dathegna a Josep vamua.” ");
INSERT INTO bgt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma a Jisas ke anira, “Inau ku adoa ghohi ighamu koti magnahaghinia na veleugna sina titiono kudo ke adoa na komi tinoni, ‘Dokta, o kidi vatoke tabirugho ghehemu,’ Na ghaghana koragna, gi koda a Vahavi, o eira kori melehamu eeni na komi reghithehe kiti rongovia ko eira kori meleha i Kapaneam.” ");
INSERT INTO bgt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma a Jisas ke ghoi velera, “E tutuni na hava ku veleghamu ikeagaieni. Teo sa profet imarea kedana ghaghana bohea kori meleha ke hutu hadi. ");
INSERT INTO bgt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kori vido ke mono a profet Elaija, sethe na vaivine thehe sasani kena mono i Israel kena papara. Kori vido iangeni teo sa uha koragna e tolu na vinogha me ono na vula, ma na ngengere ke padara na komi meleha. ");
INSERT INTO bgt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Keana a God ke boi vetula vanoa a Elaija eigna keda hathea sina vaivine ngengeni. Teo. Imanea ke vetula vanoa a Elaija tagna sina thehe sasani ke boi Jiu ke mono kori meleha i Jarefat kori provins i Saidon. ");
INSERT INTO bgt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mi kori vido ke mono a profet a Elisa, sethe na tinoni Jiu kena mono i Israel kena lepa. Keana a God ke boi vatoke tabirua sikei tadia. Sikei vamua a Naman na manegna i Siria a God ke vatoke tabirua. ");
INSERT INTO bgt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na komi tinoni kena mono kori vathe haidu kena rongovia na komi fata iraani mena dikatadia puala. ");
INSERT INTO bgt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Imarea kena sokara hadi mena thotia a Jisas mena gigi aua kori melehadia. Na meleha iangeni ke mono tagna sina suasupa. Imarea kena hatia a Jisas mena vano tagna ke vahotha mena haga soni horua. ");
INSERT INTO bgt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Keana imanea ke taetaveti varihotaghidia na mavitu me taveti sanira. ");
INSERT INTO bgt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Leghugna iaani a Jisas ke ghoi vano i Kapaneam, sina meleha kori provins i Galili. Kori Sabat a Jisas ke velepuhira na komi tinoni kori vathe haidu. ");
INSERT INTO bgt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma na komi tinoni kena vere nidia puala tagna nigna na velepuhi, eigna na pukuni thaothadogha bali velepuhi ke mono itagna. ");
INSERT INTO bgt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kori vido iangeni, sina mane ke haghevia na tidatho ke mono korai vathe haidu. Imanea ke ghuu heta, ");
INSERT INTO bgt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jisas, ighoe na manemu i Nasaret! Na hava ko haga mai eia itamami? Da ighoe o mai bali diadikalaghami. Inau ku adogho ghohi. Ighoe na mane tabu a God ke vetulagho mai!” ");
INSERT INTO bgt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisas ke haghore heta vania na tidatho, “O bughoro mo taveti au itagna!” Ma na tidatho ke vasikili horua na mane iangeni naghodia na mavitu, gi e taveti sania kari e boi vangesoa. ");
INSERT INTO bgt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Imarea gougovu kena vere nidia puala mena turughu haohaghore varihotaghidia, “Tolumara! Na haghore hava hina iaani? Imanea ke haohaghore kori mana ke hutu vanira na komi tidatho mena taveti au.” ");
INSERT INTO bgt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma na rorongogna a Jisas ke rongoragha tadia na komi meleha gougovu ghaghireigna i Kapaneam. ");
INSERT INTO bgt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","A Jisas ke taveti au kori vathe haidu me vano kori vathegna Saimon. Kori vathe iangeni a vungaogna vaivine a Saimon ke vahaghi me vuvughu puala na tonogna. Imarea kena kaea a Jisas eigna keda hathea. ");
INSERT INTO bgt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ma a Jisas ke vano me sokara ghaghireigna na mathagna me haghore heta vania na vahaghi. Ma na vahaghi ke govu itagna. Kori vido vamua iangeni, iia ke sokara hadi me kaikalitia vanira ghadia na vanga. ");
INSERT INTO bgt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kori vido ke haga huu horu na aho, na mavitu kena hatira mai na komi tinoni ke padara na komi thagi vahaghi. Ma a Jisas ke tangolira mena toke tabiru gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma a Jisas ke gigi aura na komi tidatho tadia na komi tinoni. Na komi tidatho kena ghuu heta vaghagna iaani, “Ighoe a Dathegna a God.” Keana a Jisas ke haghore heta vanira me boi lubatira gi kedana velea sa fata, eigna imarea kena adoa a Jisas a Vahavi. ");
INSERT INTO bgt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kori vuevughei puni a Jisas ke taveti sania na meleha i Kapaneam me vano kori vido ke korogha. Ma na mavitu i Kapaneam kena hiroa mena vano pada, mena veleagna eigna keda boi taveti sanira. ");
INSERT INTO bgt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Keana a Jisas ke velera, “Inau kuda tuturia tadia kekeha meleha tavogha na Rorongo ke Toke eigna na hughuta nigna a God, eigna iangeni na vunegna a God ke vetulau mai.” ");
INSERT INTO bgt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma a Jisas ke titionoa na Rorongo ke Toke tadia na komi vathe haidu nidia mara Jiu kori provins i Jiudea. ");
INSERT INTO bgt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sina dani a Jisas ke sokara ghaghireigna na kolo i Galili. Sethe na tinoni kena huhuju mena mai gharania imanea eigna kedana tangomana na rongoviagna na haghoregna a God. ");
INSERT INTO bgt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A Jisas ke reghia e rua na boti ke piniti ghaghireigna na lilihi. Kekeha mara ugura kena pinitira mena lumira nidia na komi jau. ");
INSERT INTO bgt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A Jisas ke hahaghe kori boti nigna sina mane, na ahagna a Saimon, me kaea eigna keda huju sapa sina vido. Gi e nohe me velepuhira na komi tinoni kena mono i longa. ");
INSERT INTO bgt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kori govugna na titiono vaniragna na mavitu, imanea ke veleagna a Saimon, “Oti huju sapa kori maha moti sonia horua nimiu na komi jau eigna keda hogho sa igha moti hatia.” ");
INSERT INTO bgt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","A Saimon ke veleagna, “Vunaghi, ighami kiti ugura na bongi doudolu miti boi vathehea sa igha. Keana ighami kitida ghoi soni horura na komi jau eigna ko veleghami.” ");
INSERT INTO bgt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kori vido imarea kena eia na hava ke velera a Jisas, sethe puala na igha ke hogho me haga resu na komi jau. ");
INSERT INTO bgt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Imarea kena kilora vano ara kuladia kena mono tagna sina boti eigna kedana mai hathera. Imarea kena mai mena lujaghinia na komi igha tagna e rua na boti mena haga luvu. ");
INSERT INTO bgt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","A Pita ke reghia na reghithehe iaani me torongaghi tuturu horu itagna a Jisas me ania, “Lod, o taveti saniu eigna inau na tinoni koakoa!” ");
INSERT INTO bgt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A Pita ke velea iangeni eigna imarea kena reghia na komi igha kena vathehera mena vere nidia puala. ");
INSERT INTO bgt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","E rua dathegna Jebedi, Jemes ma Jon, koro agutu duagna a Saimon. Romara huju, oro vere rodia puala. Jisas ke veleagna a Saimon, “O saghoi mataghu. Turughu ikeagaieni ighoe koda ugura tinoni mo hatira mai tagna a God.” ");
INSERT INTO bgt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kori vido kena thonga i longa mena hulu sarara hadi e rua na boti, imarea kena talu horua komi nidia na fata gougovu mena leghua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","A Jisas ke vano tagna sina meleha ke mono sina mane ke lepa. Imanea ke reghia a Jisas me mai itagna me torongaghi tuturu me pogho horu kori thepa. Imanea ke kaea huhurua eigna keda vatokea me velea, “Lod, gi koda magnahaghinia, tangomana koda vatokeu!” ");
INSERT INTO bgt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","A Jisas ke tangolia me ania, “Hii, inau ku magnahaghinia. O toke tabiru!” Ma na komi tubu kori tonogna ke mavo saisami. ");
INSERT INTO bgt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ma a Jisas ke haghore heta vania, “O saghoi veleagna sa tinoni na hava ku eia vanigho. Kari o vano reghia na pris eigna keda reghia na tonomu ke toke tabiru. Gi o hea na pris na fata bali havughaghi ke velea na vetula nigna a Moses eigna kedana adoa na mavitu ighoe ko toke tabiru.” ");
INSERT INTO bgt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Toke a Jisas ke lutia na mane iangeni na titionoagna, na rorongogna a Jisas ke rongoragha tadia na komi meleha ke sethe. Ma na mavitu ke sethe kena mai mena rorongo kori nigna na velepuhi, mena magnahaghinia a Jisas keda vatokera tadia na komi vahaghi ke padara. ");
INSERT INTO bgt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sethe na maghavu a Jisas ke taveti sanira na mavitu me vano tagna na meleha ke korogha me tarai. ");
INSERT INTO bgt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sina maghavu, kori vido a Jisas ke velepuhira na mavitu, kekeha mara na Farise mi mara velepuhigna na vetula nigna Moses kena mono ngengeni. Imarea kena mai tadia na komi meleha kori provins i Galili mi kori provins i Jiudea mi kori na meleha hutu i Jerusalem. Ma na mana nigna a Lod God ke mono tagna a Jisas bali vatokera arahai kena vahaghi. ");
INSERT INTO bgt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kori vido iangeni, kekeha mara kena hulungia maia kori mathagna sina mane ke lae na tonogna. Imarea kena haga hatia mai korai vathe tagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Keana imarea kena boi tangomana eigna na mavitu ke vonu kori vathe. Mena hulu leghua hadia na rangana mena jufu popogna na vathe. Gi ena vabiloa na vathe mena uli horua imanea ke vahaghi kori mathagna naghogna a Jisas hotaghidia na mavitu. ");
INSERT INTO bgt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisas ke adoa nidia na vaututuni ke hutu me haghore vania, “Kulagu, na komi paluhamu ke talutavogha ghohi.” ");
INSERT INTO bgt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mara velepuhigna na vetula nigna a Moses duadia mara na Farise kena ghaghana vaghagna iaani, “Na mane hava hina ke velea iaani? A God vamua ke tangomana na talutavoghagna na komi paluha. Kori vido imanea ke haghore vaghagna iaani, imanea ke vananaba ghehegna duagna a God.” ");
INSERT INTO bgt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","A Jisas ke adoa na ghaghanadia me velera, “Ehava gi oti ghaghana na hava ku velea iangeni ke boi toke? ");
INSERT INTO bgt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gi kuda haghore vania na mane ke lae na tonogna vaghagna iaani, ‘Inau ku talutavogha na paluhamu,’ ighamu kotida boi tangomana na adoagna na paluhagna ke talutavogha ba teo. Kari gi kuda haghore vania vaghagna iaani, ‘O sokara hadi mo taveti,’ gi ighamu kotida reghia inau ku mono nigua na mana kuda vatokea imanea ba teo. ");
INSERT INTO bgt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kori vido kuda vatokea na mane iaani, ighamu kotida adoa, inau, na Dathei Tinoni, ku mono nigua mana bali talutavogha na komi paluha.” Me govu, gi a Jisas ke velea na mane ke lae na tonogna, “O sokara hadi mo hatia na mathamu mo tabiru kori vathemu!” ");
INSERT INTO bgt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Imanea ke sokara hadi saisami i naghodia na mavitu me hatia na mathagna me tabiru kori vathegna me veletokea a God. ");
INSERT INTO bgt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na mavitu kena vere nidia puala mena veletokea God. Imarea kena mataghunia na mana nigna a God mena velea, “Ikeagaieni gi ati reghia sina fata ke hutu puala!” ");
INSERT INTO bgt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Leghugna iaani, a Jisas ke taveti au kori meleha iangeni me reghia sina mane bali oho takis, na ahagna a Livai. Imanea ke nohe kori vido bali voli takis. A Jisas ke ania, “O mai mo leghuu inau eigna koda nigua na mane vaovarongo.” ");
INSERT INTO bgt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A Livai ke sokara hadi me taveti sanira nigna na komi fata gougovu me leghua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Gi a Livai ke eia na vangahaidu hutu vania a Jisas kori vathegna. Sethe na tinoni bali oho takis duadia kekeha tinoni tavogha kena mai kori vangahaidu iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kekeha mara na Farise duadia mara na velepuhigna na vetula nigna a Moses kena haghore diadikala nigna na komi vaovarongo a Jisas vaghagna iaani, “Ehava gi oti vanga moti kou duadia mara na bali oho takis ma na komi tinoni dika vaghagna iangeni.” ");
INSERT INTO bgt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A Jisas ke anira, “Arahai kena boi vahaghi kena boi magnahaghinia na vano reghiagna na dokta, keana arahai vamua kena vahaghi. ");
INSERT INTO bgt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Vaghagna iaani, inau ku bosi mai bali velera arahai kena jino kori ghaghanadia ghehedia eigna kedana tughua na havidia ke koakoa, keana arahai kena adoa ghehedia kena koakoa.” ");
INSERT INTO bgt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kekeha tinoni kena veleagna a Jisas, “Sethe na maghavu nigna na komi vaovarongo a Jon ma na nidia na komi vaovarongo mara na Farise kena sota kori vanga mena tarai. Kari ehava gi mara nimua na komi vaovarongo kena boi eia iangeni kari ena vanga mena kou ghadia vamua leuleghu dani?” ");
INSERT INTO bgt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisas ke haghore tughura, “Vaghagna ivei, e toke vanira mua na mavitu kena mono kori vangahaidugna na taulaghi kedana sota kori vido na mane taulaghi ke mono duadia? Teo! ");
INSERT INTO bgt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Keana kori vido kekeha tinoni kedana mai hati aua na mane taulaghi itadia ara kulagna gi ena tangomana kedana sota eigna kena dikahehe. Vaghagna iangeni ghua, boi tangomana kedana sota nigua na komi vaovarongo eigna inau ku mono duadia mua.” ");
INSERT INTO bgt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Gi a Jisas ke ghoi velera na titiono velepuhi iaani, “Ghita ati adoa ghohi, teo ahai itada keda utuhia na vidoi pohe kori poko mathangani me suki ponoti vanoa kori resugna na poko ke haulaghi. Gi katida eia iangeni na poko mathangani keda dika ma na vidoi pohe mathangani keda boi toke na dodorogna duagna na poko haulaghi. ");
INSERT INTO bgt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Sina fata mua iaani, ighita kati boi toia na waen mathangani kori ghuighuligna na got ke haulaghi. Eigna kori vido na waen mathangani ke vano me haulaghi, kenughua na ghuighuli haulaghi iangeni e nana me poha eigna e nana ghohi. Ma na waen keda rote ma na ghuighuli keda dika. ");
INSERT INTO bgt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mati toia na waen mathangani kori ghuighuli ke mathangani eigna ke tangomana na nana.” ");
INSERT INTO bgt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ahai ke kidi kouvia na waen haulaghi e boi magnahaghinia keda kouvia na waen mathangani, eigna ke ghaghana na waen haulaghi ke toke vano.” ");
INSERT INTO bgt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sina Sabat, Jisas duagna nigna na komi vaovarongo kena taveti vano kori hangana hotaghidia na komi gnatha i wit. Mara na vaovarongo kena vihukira kekeha sagharogna na wit mena vugnua mena vanga. ");
INSERT INTO bgt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kekeha mara na Farise kena reghia mena huatira, “Ehava kotina eiagna na agutu ke boi lubatia na vetula kori Sabat? ");
INSERT INTO bgt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisas ke haghore tughura, “Ehava? Oti boi ijumia vamua na hava ke eia a King Deved kori vido imanea ma na komi nigna na mane kena rofo? ");
INSERT INTO bgt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A Deved ke vano haghe kori na vathe tapole nigna a God me ghania na bred ke tabu me hera mara nigna na mane. Kori na vetula, mara pris vamua kena tangomana na ghaniagna na bred iangeni. Kari a God ke boi dikatagna tagna a Deved.” ");
INSERT INTO bgt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Gi a Jisas ke anira, “Inau, na Dathei Tinoni, ke mono nigua na mana bali velera na komi tinoni na hava kedana tangomana na eiagna kori Sabat.” ");
INSERT INTO bgt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tagna sina Sabat mua, a Jisas ke haghe vano kori vathe haidu me velepuhira na komi tinoni. Sina mane ke thehe na tataba lima madothogna ke mono ngengeni. ");
INSERT INTO bgt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mara na Farise mi mara na velepuhigna na vetula nigna a Moses kena kaekalea a Jisas. Gi keda vatokea na mane iangeni kori Sabat, imarea kedana fatea eigna ke boi leghua na vetula. ");
INSERT INTO bgt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jisas ke adoa na ghaghanadia, me veleagna na mane ke thehe na limagna, “O sokara hadi mo mai nagho eeni.” Imanea ke sokara hadi me vano sokara naghodia na mavitu. ");
INSERT INTO bgt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","A Jisas ke huatira, “Ehava? E lubatia mua nida na vetula katida eia na hava ke toke kori Sabat? E lubatighita katida hathea na tinoni ba katida eia na fata ke dika itagna? Katida vahavia na tinoni ba vathehea?” ");
INSERT INTO bgt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Govu gi a Jisas ke rei vano tadia na komi tinoni gougovu me veleagna na mane ke thehe na limagna, “O vajinoa na limamu.” Imanea ke vajinoa ma na limagna ke ghoi toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mara na Farise mi mara na velepuhigna na vetula nigna a Moses kena reghia iangeni mena dikatadia puala mena vapuipuhi haidu eigna na hava kedana eiagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Boi hau leghugna iangeni a Jisas ke vano hadi kori suasupa bali tarai. Sina bongi doudolu imanea ke tarai tagna God. ");
INSERT INTO bgt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kori vuevugheigna hadi imanea ke kilora mai nigna na komi vaovarongo, me vahira e salaghe rua na mane itadia me kilora mara na vetula. ");
INSERT INTO bgt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Iaani na ahadia na: Saimon (a Jisas ke kiloagna a Pita), ma a Andru (a tahigna a Pita), a Jemes, a Jon, a Filip, a Batolomiu, ");
INSERT INTO bgt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","a Matiu, a Tomas, a Jemes (a dathegna a Alfius), a Saimon (sina mane ke magnahaghinia na gigi auragna mara i Rom eigna kedana boi vunaghi pungusira mara Jiu), ");
INSERT INTO bgt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","A Jiudas (a dathegna a Jemes), ma a Jiudas Iskariot (na mane ke peroa a Jisas kori limadia mara nigna na thevuioka). ");
INSERT INTO bgt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","A Jisas duagna mara nigna na vetula kena taveti horu mai kori suasupa mena sokara tagna sina nata ke hutu. Ingengeni kena hathatano haidu sethe nigna na komi vaovarongo a Jisas me sethe na komi tinoni tavogha kena mai i Jerusalem ma na komi meleha kori provins i Jiudea. Kekeha mua kena mai tadia e rua na meleha hutu i Taia mi Saidon koro mono ghaghireigna na tahi. ");
INSERT INTO bgt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Imarea kena mai eigna kena magnahaghinia na rongoviagna nigna na velepuhi a Jisas, mena magnahaghinia mua keda vatoke tabirura arahai kena vahaghi. Ma na komi tinoni kena haghevira na komi tidatho, a Jisas ke gigi aura itadia. ");
INSERT INTO bgt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na komi tinoni gougovu kena magnahaghinia na tugeliagna a Jisas eigna na mana nigna a God ke taveti au itagna me vatoke tabirura arahai kena tugelia. ");
INSERT INTO bgt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","A Jisas ke rei vano tadia nigna na komi vaovarongo me veleragna, “A God keda vatokeghamu ighamu koti kuma. Ighamu kotida mono kori hughuta nigna a God. ");
INSERT INTO bgt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","A God keda vatokeghamu, ighamu koti rofo ikeagaieni. Ighamu kotida vanga moti mahu. A God keda vatokeghamu, ighamu koti tangi ikeagaieni. Ighamu kotida kia moti totogo. ");
INSERT INTO bgt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","A God keda vatokeghamu kori vido imarea kena thevuioka itamiu mena siriuhaghinighamu mena hiraghamu, mena haghore diadikalaghamu eigna ighamu koti leghuu inau, na Dathei Tinoni. ");
INSERT INTO bgt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Oti ragi moti lealea kori vido kena eia na komi fata iraani itamiu, eigna a God keda heghamu na taba ke hutu puala kori hadimiu i popo. Moti saghoi havaghinia ara hutumiu kena eia na komi fata ke dika vaghagna irangeni vanira na komi profet nigna a God. ");
INSERT INTO bgt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Keana ighamu koti pada rongo ikeagaieni, na komi fata ke dika keda katheghamu, eigna ighamu koti hatia ghohi nimiu na totogo. ");
INSERT INTO bgt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ighamu koti vanga toetoke ikeagaieni, na komi fata ke dika keda katheghamu, eigna ighamu kotida rofo. Ighamu koti kia ikeagaieni, na komi fata ke dika keda katheghamu, eigna ighamu kotida dikahehe moti tangi. ");
INSERT INTO bgt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ighamu, na mavitu kena veletokeghamu, na komi fata ke dika keda katheghamu, eigna ara hutumiu huju kena veletokera na komi profet piapilau, keana a God ke vaparara.” ");
INSERT INTO bgt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","A Jisas ke talu velepuhira mua me anira, “Inau ku veleghamu ighamu koti rorongo mai itagua, oti dothovira nimiu na thevuioka, moti eia na komi fata ke toke vanira arahai kena boi magnahaghinighamu. ");
INSERT INTO bgt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Arahai kena haghore leghughamu, oti tarai kaea a God eigna keda vatokera. Moti tarai eidia arahai kena eia na komi fata ke dika itamiu. ");
INSERT INTO bgt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Gi ahai keda tapoa na bakomu, o ghoi lubatia vania sethevui bakomu. Gi ahai keda hatia nimua na oopo, o lubatia vania nimua na poko. ");
INSERT INTO bgt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Arahai kena kaeghamu sa fata, oti hera. Gi ahai keda hatia nimua na fata o saghoi kae tabirua. ");
INSERT INTO bgt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Oti eia vanira arahai tavogha na komi fata koti magnahaghinira kedana eia vanighamu. ");
INSERT INTO bgt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Gi kotida dothovira vamua arahai kena dothovighamu, a God keda boi veletokeghamu, eigna na komi tinoni dika ena dothovira mua arahai kena dothovira. ");
INSERT INTO bgt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Vaghagna iaani, gi kotida eia vamua na komi fata ke toke vanira arahai kena eia vanighamu na komi fata ke toke, a God keda boi veletokeghamu. Na komi tinoni dika huju, ena eia mua vaghagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Gi kotida hera sa fata arahai vamua kena tangomana na tughu tabirughamugna, a God keda boi veletokeghamu. Na komi tinoni dika huju ena eia vaghagna iangeni, eigna kena adoa imarea kedana tughu tabirura. ");
INSERT INTO bgt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Oti dothovira nimiu na thevuioka moti eia vanira na komi fata ke toke. Oti hera na fata kena kaea itamiu moti saghoi toatogha kedana tughu tabirua. Gi kotida eia na komi fata iraani, ighamu kotida hatia na taba hutu puala, ma na puhimiu keda vaghagna na puhigna a tamamiu, a God ke thaba haluhadi puala. Eigna a God ke toke vanira arahai kena dika ma arahai kena boi veletokea eigna na komi fata ke hera. ");
INSERT INTO bgt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Oti rarovira na komi tinoni vaghagna a God a Tamamiu ke rarovighamu.” ");
INSERT INTO bgt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jisas ke ghoi velera, “Saghoi fatea sa tinoni ma a God keda boi fategho. Saghoi velea arahai tavogha kena eia na hahi, ma a God keda boi velea ighoe ko eia na hahi. O talutavogha na paluhadia na komi tinoni ma a God keda talutavogha na paluhamu. ");
INSERT INTO bgt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","O keukemu tadia na komi tinoni, gi a God keda keukemu itamua. Gi koda keukemu, na haehathe a God keda eia vanigho keda hutu puala vaghagna na tinoni ke hoghoni vavonua na ngoi me roerote. Leghuagna na puhimu koti keukemu, a God keda hegho nimua na fata.” ");
INSERT INTO bgt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","A Jisas ke ghoi velera kekeha titiono velepuhi. Imanea ke velera, “Ehava? Sina mane ke doa tangomana keda batua sina mane mua ke doa? Teo. Gi keda eia iangeni iromara koroda sakai sikili kori lodu. ");
INSERT INTO bgt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Na mane vaovarongo ke boi thaothadogha vano tagna ahai ke velepuhia. Keana, gi keda pipili toetokea na komi velepuhi, imanea keda vaghagna ahai ke velepuhia. ");
INSERT INTO bgt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ehava gi o haga hati aua na saosaghoma ke iso teoteoa kori matagna a kulamu, keana ighoe ko boi hati aua na tabala kori matamu? ");
INSERT INTO bgt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","E boi toke gi koda veleagna a kulamu, ‘O mai eigna kuda hati aua na saosaghoma kori matamu,’ kari ighoe ko boi reghia na tabala kori matamu. Ighoe na tinoni piapilau. O kidi hati aua na tabala kori matamu eigna koda dodoro toetoke, gi o hati aua na saosaghoma kori matagna a kulamu.” ");
INSERT INTO bgt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","A Jisas ke ghoi velera, “Na ghai ke toke boi tangomana keda sagharoa na sagharo ke dika, ma na ghai ke dika boi tangomana keda sagharoa na sagharo ke toke. ");
INSERT INTO bgt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ighita kati adoa ghohi na komi ghai ke toke ma na komi ghai ke dika tagna na komi sagharodia. Teo ahai keda hatia na sagharo ke toke tagna na atho ke kaekathe. ");
INSERT INTO bgt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Vaghagna iaani ghua, na tinoni ke toke keda vele aua na komi fata ke toke ke au mai kori ghaghanagna ke toke. Ma na tinoni ke dika keda vele aua na komi fata ke dika ke au mai kori ghaghanagna ke dika, eigna na hava keda vele aua na tinoni, e leghua vamua na hava ke mono kori ghaghanagna. ");
INSERT INTO bgt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ehava gi oti kilou Lod, kari oti boi leghua na hava ku veleghamu? ");
INSERT INTO bgt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ahai ke mai itagua me rongovia na haghoregu me ei leghua, ");
INSERT INTO bgt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","imanea ke vaghagna na tinoni ke agutua na vathe. Imanea ke ghegheli me horu i thepa eigna keda sokaraghinia na vathe kori thepa ke ngasi. Kori vido ke uha me biringita, na bea ke mai jufungia na vathe, kari na vathe ke boi reo eigna ke sokara kori thepa ke ngasi. ");
INSERT INTO bgt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Na tinoni ke rongovia na haghoregu me boi leghua, imanea ke vaghagna na tinoni ke agutua na vathe kori thepa kari e boi kidi ghegheli horu i thepa. Imanea ke vasokaraghinia vamua. Kori vido ke uha me biringita, na bea ke mai jufungia na vathe me hovu horua me diadikala eigna ke boi ngasi.” ");
INSERT INTO bgt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","A Jisas ke vagovua na velepuhiragna na mavitu na komi fata iraani, gi e tabiru i Kapaneam. ");
INSERT INTO bgt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Sina mane ngengeni ke vahaghi me haga thehe. Imanea nigna na mane agutu na vunaghigna sina boo i soldia kori ami gna i Rom. Imanea ke dothovia puala nigna na mane agutu. ");
INSERT INTO bgt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na vunaghi iaani ke rongovia na rorongogna a Jisas me vetulara kekeha mara kena nagho tadia mara Jiu bali kaea Jisas eigna keda mai me vatoke tabirua nigna na mane agutu. ");
INSERT INTO bgt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Imarea kena jufu tagna Jisas mena kaea huhurua eigna keda mai hathea na mane ke nagho iaani. Imarea kena veleagna, “Na mane ke nagho iaani, e naba gi koda hathea, eigna imanea na mane toke. ");
INSERT INTO bgt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Imanea ke dothovighita ighita mara Jiu me agutua vanighami nimami na vathe haidu.” ");
INSERT INTO bgt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ma a Jisas ke vano duadia. Kori vido imarea kena mai gharania na vathegna na vunaghi kori ami, imanea ke vetulara kekeha kulagna, mena vano itagna a Jisas eigna kedana velea vaghagna iaani, “Vunaghi, saghoi babaogho na mai, eigna inau ku bosi naba gi koda mai haghe kori vathegu. ");
INSERT INTO bgt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mu boi naba kuda mai tamua ighoe. Keana inau ku adoa, gi koda haghore vamua, nigua na mane agutu keda toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Inau ku adoa iaani eigna ke mono na vunaghigu mu leghua na hava ke veleu. Vaghagna iangeni, inau ku vunaghi pungusira nigua na komi soldia. Gi kuda velea sikei itadia, ‘Vano,’ imanea keda vano. Gi kuda velea sikei itadia, ‘Mai,’ imanea keda mai. Ma gi kuda velea nigua na mane agutu, ‘O eia na agutu iaani,’ imanea keda eia.” ");
INSERT INTO bgt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","A Jisas ke rongovia iaani me vere nigna puala. Gi e rei vano tadia arahai kena leghua me anira, “Inau ku veleghamu, inau ku boi reghia na vaututuni ke hutu vaghagna iaani tadia mara Israel gougovu.” ");
INSERT INTO bgt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kori vido ara kulagna na vunaghi kori ami kena tabiru vano kori vathe, imarea kena reghia na mane ke vahaghi ke ghoi toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Boi hauhaugna leghugna iaani, a Jisas duagna nigna na komi vaovarongo kena vano kori meleha i Nein. Ma na mavitu ke sethe kena leghura. ");
INSERT INTO bgt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kori vido kena mai gharania na hagethagna na peogna na meleha, imarea kena reghira kekeha tinoni kena hulungia na sape ke mono na tinoni ke thehe popogna. Imarea kena au mai bali vano gilua. Na tinoni ke thehe iaani, sikei vamua a dathegna mane sina vaivine thehe sasani. Me sethe na tinoni kori meleha iangeni kena duagna na vaivine iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","A Lod ke reghia na vaivine iangeni me pukuni rarovia me ania, “O saghoi tangi.” ");
INSERT INTO bgt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Gi e taveti vano me tangolia na sape ma arahai kena hulu kena soto. A Jisas ke ania, “Mane mathangani, inau ku velegho, o bughae hadi!” ");
INSERT INTO bgt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na mane mathangani ke nohe hadi me turughu i haohaghore. Gi a Jisas ke hea vanoa a idogna. ");
INSERT INTO bgt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na mavitu kena mataghu mena ghaghana bohea a God mena kilothaba. Imarea kena velea, “Sina naghoi profet ke mono mai itada. A God ke mai bali hathera nigna na mavitu.” ");
INSERT INTO bgt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma na rorongogna eigna na hava ke eia a Jisas ke jufu tadia na komi meleha i Jiudea mi tadia kekeha meleha i kosi. ");
INSERT INTO bgt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Komi nigna na mane vaovarongo a Jon kena veleagna eigna na komi fata ke eia a Jisas. Ma a Jon ke kilora mai rua nigna na mane vaovarongo, ");
INSERT INTO bgt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","me vetulara vano tagna a Lod Jisas eigna koroda huatiagna vaghagna iaani, “Ighoe hiri a Vahavi kena velea keda mai, ba iti pitua sina mane tavogha?” ");
INSERT INTO bgt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Romara koro jufu tagna Jisas moro veleagna, “A Jon Siuvitabu ke vetulaghami mai bali huatigho, ‘Ehava? Ighoe hiri a Vahavi kena velea koda mai, ba iti pitua sina mane tavogha?’” ");
INSERT INTO bgt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kori vido iangeni, sethe na tinoni a Jisas ke vatoke tabirura tagna na komi vahaghi ke padara me gigi aura na komi tidatho tadia kekeha, me vareireira arahai kena doa. ");
INSERT INTO bgt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ma a Jisas ke veleragna rua na nigna vaovarongo a Jon, “Oro vano tabiru tagna a Jon moro veleagna na hava koro reghia moro rongovia ikeagaieni. Arahai kena doa kena ghoi reirei tabiru, arahai kena thehe na naedia kena ghoi taetaveti, arahai kena lepa kena ghoi mavo tabiru, arahai kena pui kena ghoi rorongo, arahai kena thehe kena havi tabiru, ma arahai kena kuma kena rongovia na Rorongo ke Toke. ");
INSERT INTO bgt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","A God keda vatokera arahai kena boi siriuhaghiniu eigna na agutu ku eia.” ");
INSERT INTO bgt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Leghugna e rua nigna na mane vaovarongo a Jon koro tabiru vano, a Jisas ke titionoa a Jon tadia na mavitu kena haidu ngengeni. Imanea ke anira, “Kori vido ighamu koti taveti vano kori meleha ke gou na hava koti vano bali reghia ngengeni? Na tinoni ke boi heta nigna na vaututuni vaghagna na seo ke bebeleo kori ghuri? Teo! ");
INSERT INTO bgt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na hava koti haga vano reghia na? Na mane ke pipisia na komi pohe ke toetokelaghagna? Teo! Na komi tinoni vaghagna iangeni ma na komi tinoni kena padarongo, imarea kena mono koradia na komi vathedia na komi king. ");
INSERT INTO bgt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Na hava koti haga vano reghia na? Na profet? Hee! Ma a Jon na profet, kari boi na profet vamua. ");
INSERT INTO bgt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","A Jon eni a God ke titionoa kori na Rioriso ke Tabu vaghagna iaani, ‘Inau kuda kidi vetula naghoa atua itamua nigua na mane titiono. Imanea keda kidi vajinoa vanigho na hangana.’ ");
INSERT INTO bgt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Inau ku veleghamu, a Jon ke nagho vano tadia na komi tinoni gougovu kena havi mai kori maramagna. Keana ahai ke boi nagho tadia arahai a God ke vunaghi pungusira, imanea ke nagho vano tagna a Jon.” ");
INSERT INTO bgt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kori vido na komi tinoni duadia mara bali oho takis kena rongovia na haghoregna a Jisas, imarea kena vaututunia na puhi a God ke magnahaghinia kedana leghua na komi tinoni ke jino. Ighita kati adoa iaani eigna imarea kena vano mena siuvitabu tagna a Jon. ");
INSERT INTO bgt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Keana mara na Farise ma na mara velepuhigna na vetula nigna Moses kena boi leghua na hava a God ke magnahaghinia gi kedana eia, eigna imarea kena boi magnahaghinia na tughuhehe mena boi siuvitabu tagna a Jon. ");
INSERT INTO bgt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","A Jisas ke ghoi velera iaani, “Vaghagna na hava na komi tinoni ikeagaieni? ");
INSERT INTO bgt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Imarea vaghadia vamua sina booi gari kena nohe kori makete. Sina booi gari tavogha kena ghuu vano tadia, ‘Ighami kiti ifu vanighamu moti boi nimiu na ragi. Ighami kiti salea na komi sale dikahehe moti boi nimiu na tangi.’ ");
INSERT INTO bgt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Inau ku velea iaani eigna kori vido a Jon Siuvitabu ke mai, imanea ke sota me boi kouvia na waen. Moti velea na tidatho ke haghevia. ");
INSERT INTO bgt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Keana, kori vido inau, na Dathei Tinoni, ku mai mu vanga mu kou duadia na komi tinoni, ighamu koti velea, ‘Imanea ke thauthavu na vangagna ma na kou memee, mi manea a kuladia mara bali oho takis mi mara na koakoa.’ ");
INSERT INTO bgt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Keana na komi tinoni kena leghua nigna na thaothadogha a God kena tateli aua nigna na thaothadogha ke tutuni.” ");
INSERT INTO bgt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sina mane Farise, na ahagna a Saimon, ke hulaghinia a Jisas eigna keda vanga duagna. A Jisas ke vano kori vathegna me nohe duagna me vanga. ");
INSERT INTO bgt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sina vaivine ke dika na puhigna ke rongovia a Jisas ke vanga kori vathegna a Saimon me hatia na botolo sedi ke vahotha. ");
INSERT INTO bgt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Iia ke haghe kori vathegna a Saimon me torongaghi tuturu leghugna a Jisas hilighagna na naegna me tangi me lulu horu na kothobui matagna kori naegna a Jisas. Gi e vamumuja kori sesehui ulugna me kisia na naegna, me rotea na sedi kori na naegna. ");
INSERT INTO bgt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","A Saimon ke reghia iaani me toatogha vaghagna iaani, “Keda imanea na profet, imanea keda adoa na vaivine ke tangolia, na vaivine dika.” ");
INSERT INTO bgt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","A Jisas ke adoa na ghaghanagna me veleagna, “Saimon, sina fata iaani ku magnahaghinia kuda velegho.” A Saimon ke ania, “Velepuhi, o veleu mai.” ");
INSERT INTO bgt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Gi a Jisas ke ania, “Rua na mane koro kaonia na rongo tagna sina mane ke lubatia ahai keda kaoni tagna. Sina mane ke kaonia lima na hathangatu, sina mane lima hangavulu. ");
INSERT INTO bgt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Romara ke teo sa rodia rongo moro boi vathehea rodia na kaoni, ma na mane padarongo ke rarovira me velera eigna koroda boi vathehea rodia na kaoni. Ahai itadia romara iaani keda dothovia vano na mane koro kaoni itagna iangeni?” ");
INSERT INTO bgt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","A Saimon ke haghore tughua, “Kori ghaghanagu, da imanea ke hutu nigna na kaoni.” A Jisas ke velea, “E tutuni nimua na haghore tughu.” ");
INSERT INTO bgt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Gi a Jisas ke rei vano tagna na vaivine me veleagna a Saimon, “O reghia na vaivine iaani. Kori vido ku mai kori vathemu, ighoe ko boi heu na bea eigna kuda lumia na naegu. Kari na vaivine iaani ke lumia na naegu kori kothobui matagna me vamumuja kori sesehui na ulugna. ");
INSERT INTO bgt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ighoe o boi kisiu, keana na vaivine iaani ke turughu kisia na naegu turughu kori haghegna mai me jufu ikeagaieni. ");
INSERT INTO bgt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","O boi rotea na sedi kori ulugu kari na vaivine iaani ke rotea na sedi kori naegu. ");
INSERT INTO bgt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Inau ku velegho, na komi paluhagna na vaivine iaani, inau ku talutavogha ghohi. Ma na vunegna iangeni nigna na dotho vaniu ke hutu puala. Keana ahai a God ke talutavogha rua tolu paluhagna vamua, nigna na dotho imanea keda iso.” ");
INSERT INTO bgt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Govu, gi a Jisas ke veleagna na vaivine iangeni, “Na komi paluhamu ke talutavogha ghohi.” ");
INSERT INTO bgt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kekeha tinoni kena mono ngengeni kena dikatadia tagna a Jisas mena haohaghore ghehedia, “Ahai hina na mane iaani ke talutavogha na komi paluha?” ");
INSERT INTO bgt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Gi a Jisas ke veleagna na vaivine iangeni, “A God ke vahavigho eigna nimua na vaututuni. Taveti kori soleana.” ");
INSERT INTO bgt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Leghugna iaani, a Jisas ke vano tadia na komi meleha hutu ma na komi meleha iso i Galili eigna kena titionoa na Rorongo ke Toke eigna na puhi a God ke vunaghi pungusira na komi tinoni. Mara e salaghe rua nigna na komi vaovarongo kena duagna. ");
INSERT INTO bgt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kekeha koi vaivine a Jisas ke gigi aura na komi tidatho itadia, mi kekeha ke vatoke tabirura tadia na komi vahaghi kena vano duagna. Kekeha itadia, a Meri Magdala, a Jisas ke gigi aura e vitu na tidatho itagna; ");
INSERT INTO bgt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, a taugna Kusa ke reireghia nigna na komi fata a King Herod; Susana; me sethe mua ke tavogha. Na koi vaivine iraani kena hathera a Jisas ma nigna na komi vaovarongo kori nidia na rongo. ");
INSERT INTO bgt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sina dani, sethe na komi tinoni tadia na komi meleha kena mai tagna a Jisas. Kori vido iangeni imanea ke titiono vanira na titiono velepuhi iaani. ");
INSERT INTO bgt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Sina mane ke vano soni kililira na komi katura kori nigna na gnatha. Kori vido imanea ke soni kililira na komi katura, kekeha kena sikili horu kori hangana ma na komi tinoni kena tapali bakaira ma na komi manu kena mai ghanira. ");
INSERT INTO bgt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kekeha katura kena sikili horu kori thepa ke mono na ghahira saragna. Kori kotudia hadi, na aho ke rangera mena thehe eigna ke mumuja na thepa. ");
INSERT INTO bgt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kekeha katura kena sikili horu tagna ke mono na atho ke kaekathe. Kori vido na komi katura kena kotu hadi na atho ke virighira mena thehe. ");
INSERT INTO bgt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mi kekeha katura kena sikili horu kori thepa ke toke kena havi toke mena mono na sagharodia. Ma na komi sagharodia ke sethe vano tadia na komi katura imanea ke soni kililira.” Kori vido a Jisas ke govua na titiono velepuhi, imanea ke haghore heta vanira, “Gi ahai ke magnahaghinia na thaothadoghagna na haghoregu, imanea keda vaovarongo toetoke.” ");
INSERT INTO bgt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nigna na komi vaovarongo a Jisas kena huatia na ghaghana ikoragna na titiono velepuhi iaani. ");
INSERT INTO bgt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ma a Jisas ke anira, “I hau a God ke boi lubatia ahai eigna keda adoa na puhi keda eia kori na vunaghi pungusiragna nigna na komi tinoni. Keana ikeagaieni imanea ke lubatighamu gi kotida adoa. Keana, tadia arahai kena boi leghuu inau, inau kuda velepuhira tadia na komi titiono velepuhi vamua, eigna, toke imarea kena reghia na hava ku eia, imarea kedana boi adoa na ghaghanagna. Toke imarea kena rongovia na hava ku velera, imarea kedana boi thaothadoghagna.” ");
INSERT INTO bgt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Iaani na ghaghana ikoragna na titiono velepuhi eigna na mane ke sonira kilili na komi katura. Na komi katura, na haghoregna a God. ");
INSERT INTO bgt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kekeha tinoni kena vaghagna na komi katura kena sikili kori hangana. Imarea kena rongovia na haghoregna a God kari a Satan ke mai me hati aua kori havidia eigna kedana boi vaututuni ma a God keda boi vahavira. ");
INSERT INTO bgt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kekeha tinoni kena vaghagna na komi katura kena sikili kori thepa ke mono na ghahira saragna. Imarea kena rongovia na haghoregna mena hatia kori totogo. Keana imarea kena kalitia sina ghathi vido vamua eigna na haghore ke boi mono kori havidia, vaghagna na komi katura kena boi horu i thepa na oghadia. Kori vido kena pada na vahothagna kori havidia, imarea kena saisami havaghinia nidia na vaututuni. ");
INSERT INTO bgt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kekeha tinoni kena vaghagna na komi katura kena sikili kori thepa ke mono na atho ke kaekathe tagna. Imarea kena rongovia na haghoregna a God, kari e boi hau gi ena toatogha puala na komi fata kori havidia leuleghu dani, na rongo ma na komi fata keda vatotogora ghehedia. Na vunegna iaani, e teo sa fata ke toke ke au mai kori havidia. ");
INSERT INTO bgt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Keana kekeha tinoni kena vaghagna na komi katura kena sikili kori thepa ke toke. Imarea kena toke mena jino. Imarea kena rongovia na haghoregna a God mena leghu hahalia. Ma na vunegna imarea kena sokara ngasi, sethe na fata ke toke ke au mai kori havidia.” ");
INSERT INTO bgt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A Jisas ke ghoi velera, “Teo ahai keda totha na lui me boa saragna na nahu ba saragna na matha saesape. Kari e savera hadia tagna na bali sasaveragna eigna kedana dodoro toetoke na komi tinoni kena haghe mai kori vathe. ");
INSERT INTO bgt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Vaghagna mua iangeni, na komi fata kena boi thaothadoghagna na komi tinoni kori nigua na velepuhi, imarea kedana thaothadoghagna. ");
INSERT INTO bgt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Na vunegna iaani, oti vaovarongo toetoke tagna na hava koti rongovia. Ahai ke ghathi thaothadoghagna me leghua nigua na velepuhi, God keda hea mua na thaothadogha. Kari ahai ke bosi magnahaghinia na leghuagna nigua na velepuhi, God keda hati aua itagna na ghathi nigna thaothadogha.” ");
INSERT INTO bgt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","A idogna mara tahigna a Jisas kena mai eigna kedana reghia a Jisas. Kari ena boi tangomana nidia eigna ke sethe puala na tinoni kori vathe ke mono a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sina tinoni ke veleagna a Jisas, “A idomu mara tahimu kena sokara i kosi mena magnahaghinia na reghighogna.” ");
INSERT INTO bgt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A Jisas ke velera na mavitu, “Arahai kena rongovia na haghoregna a God mena leghua, imarea hiri kena vaghagna a idogu mara tahigu.” ");
INSERT INTO bgt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sina dani a Jisas ke velera nigna na komi vaovarongo, “Atu mati hathavu sethevugna na kolo.” Gi ena hahaghe kori boti mena turughu au vano. ");
INSERT INTO bgt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kori vido kena taveti vano a Jisas ke nere. Na ghuighuri hutu ke padara me maghavu puala. Ma na geo ke turughu haghe kori boti mena haga luvu. ");
INSERT INTO bgt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nigna na komi vaovarongo kena vano raraia mena ania, “Vunaghi, Vunaghi, ighita katida bilomo!” Jisas ke sokara hadi me haghore heta vanira na ghuri ma na geo. Kori vido iangeni, na ghuri ke soto ma na kolo ke sola. ");
INSERT INTO bgt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Gi e velera nigna na komi vaovarongo, “Ehava gi oti boi vaututuniu?” Imarea kena vere nidia puala mena mataghu. Gi ena veihuahuatighi, “Na tinoni hava hina iaani? Imanea ke haghore vanira na ghuri ma na geo mena leghua na haghoregna.” ");
INSERT INTO bgt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","A Jisas duagna nigna na komi vaovarongo kena vano jufu kori melehadia mara Gerasa sethevugna na kolo i Galili. ");
INSERT INTO bgt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kori vido a Jisas ke thonga i longa, sina manegna na meleha iangeni ke mai tagna. Na komi tidatho kena haghevia imanea i hau me soesole me boi mono kori vathe. Imanea ke mono tadia na komi luma ke mono na komi beku koradia. ");
INSERT INTO bgt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Sethe na maghavu na komi tidatho kena vameea imanea. Kori vido imarea kena taria na limagna ma na naegna tagna na sen mena boa na mane bali reireghiagna, imanea ke thagi tautua na sen, ma na komi tidatho kena hurua vano kori meleha ke gou. Kori vido ke reghia a Jisas, imanea ke mai me torongaghi tuturu itagna. A Jisas ke velea, “Tidatho, o au sania!” Ma na tidatho ke ghuu heta, “Jisas, Dathegna God, pukuni mana! Na hava koda eiugna? Inau ku kaegho, saghoi vaparau!” ");
INSERT INTO bgt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","A Jisas ke huatia, “Ahai na ahamu?” Ma na tidatho ke haghore tughua, “Na ahagu ‘A Gnaghu.’” Imanea ke velea iaani eigna e sethe na tidatho kena haghevia. ");
INSERT INTO bgt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na komi tidatho kena kaea mena kaea a Jisas eigna keda boi vetulara vano kori meleha papara. ");
INSERT INTO bgt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Sethe na botho kena vanga kori ghaghireigna na suasupa hilighadia. Ma na komi tidatho kena kaea mena kaea Jisas eigna keda lubatira vano tadia na komi botho. A Jisas ke lubatira, ");
INSERT INTO bgt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","mena au mai tagna na mane iangeni mena vano haghe tadia na komi botho. Ma na komi botho kena raghe horu leghua na suasupa mena sogala sapa kori kolo mena bilomo gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mara kena reireghi botho kena reghia iangeni mena raghe vano mena titionoa na rorongo iaani tadia na komi tinoni kori melehadia ma arahai kena mono kosigna. ");
INSERT INTO bgt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Me sethe na tinoni kena vano eigna kedana reghia na hava ke eia a Jisas. Kori vido kena mai tagna a Jisas, imarea kena reghia na mane ke haghevia na komi tidatho ke nohe hilighagna a Jisas. Imanea ke pipisi ma na ghaghanagna ke jino. Ma na komi tinoni kena mataghu nidia puala. ");
INSERT INTO bgt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Arahai kena reghia a Jisas ke vetulara aua na komi tidatho tagna na mane iangeni, imarea kena titionoa tadia na komi tinoni kena eu mai. ");
INSERT INTO bgt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ma na komi tinonidia i Gerasa kena kaea a Jisas eigna keda taveti au itadia eigna kena mataghu nidia puala. Jisas ke hahaghe kori boti bali taveti au tadia, ");
INSERT INTO bgt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ma na mane a Jisas ke gigi aua na komi tidatho itagna ke kaea bali leghuagna. Keana a Jisas ke boi lubatia me veleagna, ");
INSERT INTO bgt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“O tabiru kori melehamu mo titionoa na hava a God ke eia vanigho.” Imanea ke tabiru kori melehagna me titionoa tadia na komi tinoni na hava ke ei vania a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas ke tabiru vano sethevu i kolo, ma na mavitu kena pitua mena totogo puala na reghiagna. ");
INSERT INTO bgt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sina mane ke baubatu kori vathe haidu nidia mara Jiu ke mono ngengeni, na ahagna a Jairus. Imanea ke mai me torongaghi tuturu horu itagna a Jisas me kaea eigna keda vano duagna kori vathegna. ");
INSERT INTO bgt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Imanea ke kaea a Jisas eigna sikei vamua iaani na ghathi dathegna vaivine ke vahaghi me haga thehe. Iia e salaghe rua ghohi na vinoghagna. Kori vido a Jisas ke vano duagna, sethe na tinoni kena haidu kililia mena huhujua. ");
INSERT INTO bgt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Koragna na mavitu iangeni, e mono sina vaivine puhi ke pada na vahaghi ghaughabua kekeha vidoi maghavu koragna salaghe rua na vinogha. Ma na nigna na komi rongo ke govu eigna ke volira na komi dokta, kari ena boi tangomana na vatoke tabiruagna. ");
INSERT INTO bgt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iia ke mai leghugna a Jisas me tugelia na kujukugna nigna na poko, ma na ghaughabua ke soto. ");
INSERT INTO bgt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","A Jisas ke huatira na mavitu, “Ahai ke tugeliu?” Ma na komi tinoni kena veleagna ena boi tugelia. Ma Pita ke veleagna, “Vunaghi, na mavitu ke sethe kena huhujugho. ");
INSERT INTO bgt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A Jisas ke haghore tughua, “Sina tinoni ke tugeliu eigna inau ku adoa na mana ke au itagua.” ");
INSERT INTO bgt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kori vido na vaivine iangeni ke adoa ke boi tangomana na poloagna, iia ke mataghu me aiariri. Gi e mai torongaghi tuturu horu tagna a Jisas. Kori naghodia na mavitu, iia ke titionoa na vunegna ke tugelia a Jisas, me titiono vanira na vahaghi ke govu itagna kori vido vamua iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma a Jisas ke ania, “Vaivine, ighoe ko toke tabiru eigna ighoe ko vaututuni. O taveti kori soleana.” ");
INSERT INTO bgt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kori vido a Jisas ke talu titiono mua, sina mane ke mai kori vathegna a Jairus me titiono vania a Jairus, “A dathemu vaivine e thehe ghohi. O saghoi kaea mua na mane velepuhi keda mai.” ");
INSERT INTO bgt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","A Jisas ke rongovia iaani me veleagna a Jairus, “Saghoi mataghu, o vaututuni vamua ma a dathemu keda toke tabiru.” ");
INSERT INTO bgt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kori jufudia kori vathe, a Jisas ke boi magnahaghinia na komi tinoni kedana haghe kori vathe duagna. Me hatira vamua a Pita, Jon ma a Jemes duadia a tamagna ma a idogna na gari. ");
INSERT INTO bgt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na mavitu kena dikahehe mena tangi tagna na gari ke thehe. A Jisas ke velera, “Oti saghoi tangi eigna na gari iaani e boi thehe. E nere nigna vamua.” ");
INSERT INTO bgt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Imarea kena kihaghinia eigna kena adoa na gari ke pukuni thehe ghohi. ");
INSERT INTO bgt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gi a Jisas ke vano me tangolia na limagna na gari me haghore vania, “Dathegu, o sokara hadi!” ");
INSERT INTO bgt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kori vido iangeni, iia ke ghoi havi tabiru me sokara hadi. A Jisas ke velera eigna koroda hea ghagna. ");
INSERT INTO bgt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A idogna ma a tamagna na gari koro vere rodia puala na fata iaani. Ma a Jisas ke haghore heta vanira eigna koroda saghoi titionoa tagna sa tinoni na hava ke eia. ");
INSERT INTO bgt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A Jisas ke kilo haidura e salaghe rua nigna na mane vetula me hera na mana bali vatoke tabirura arahai kena vahaghi ma na bali gigi aura na komi tidatho. ");
INSERT INTO bgt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","A Jisas ke vetulara au eigna kedana titiono vanira na komi tinoni eigna na hughuta nigna a God, ma na bali vatoke tabirura arahai kena vahaghi. ");
INSERT INTO bgt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Imanea ke anira, “Kori nimiu na taetaveti, oti saghoi hatia sa fata. Saghoi hatia na supa ba na ngoi ba na vanga ba na rongo ba na varua pohe. ");
INSERT INTO bgt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kori vido kotida jufu tagna sina meleha, oti mono vamua tagna sina vathe moti ghieghilei taveti au. ");
INSERT INTO bgt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Keana, gi kotida jufu tagna sina meleha mena boi magnahaghinia na rongoviagna nimiu na velepuhi, oti taveti au sania na meleha iangeni. Oti tapori aua na thepa ke thangu kori naemiu. Iaani na vaughithatha kotida eia eigna kedana adoa a God keda vaparara.” ");
INSERT INTO bgt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ma nigna na komi mane vetula kena taveti au tadia na komi meleha mena titionoa na Rorongo ke Toke mena vatoke tabirura arahai kena vahaghi. ");
INSERT INTO bgt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","A Herod Antipas ke rongovia na rorongogna na komi fata ke eia a Jisas. Imanea ke hahi hehegna puala eigna kekeha tinoni kena velea imanea a Jon Siuvitabu ke ghoi havi tabiru. ");
INSERT INTO bgt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kekeha tinoni kena velea imanea a profet Elaija. Kekeha ghua kena velea imanea sina profet tavogha ke ghoi havi tabiru. ");
INSERT INTO bgt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A Herod ke velea, “Inau ku utuhia ghohi na luagna a Jon Siuvitabu. Kari ahai hina na mane iaani kena veleu ke eia na komi fata ke hutu?” Ma a Herod ke magnahaghinia puala na reghiagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kori vido e salaghe rua na mane vetula kena tabiru mai tagna a Jisas, imarea kena veleagna na komi fata kena eia. Gi a Jisas ke hatira duagna mena vano ghehedia tagna sina meleha ghaghireigna i Betsaida. ");
INSERT INTO bgt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Keana na komi tinoni kena rongovia ivei tagna kena vano mena leghura. A Jisas ke totogo na reghiragna me titiono vanira eigna na hughuta nigna a God. Me vatoke tabirura mua arahai kena vahaghi. ");
INSERT INTO bgt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kori vido ke haga huu ghohi na aho, nigna na komi vaovarongo a Jisas kena mai tagna mena ania, “O vetulara na mavitu eigna kedana vano tadia na komi meleha ke gharanighita bali hiroa ghadia vanga ma na vathe bali neredia. Eigna eeni e teo sa vanga ba sa vathe kedana nere.” ");
INSERT INTO bgt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Keana a Jisas ke veleragna “Oti hera ghadia.” Ma nigna na komi vaovarongo kena haghore tughua, “E vahotha puala! E lima vamua na bred me rua vamua na fei ke mono itamami. Ehava? O magnahaghinighami kitida vano voli vanga ke nabadia na mavitu iaani?” ");
INSERT INTO bgt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Koragna na mavitu iangeni, da e lima na toghai mane. A Jisas ke anira, “Oti velera na mavitu eigna kedana nohe leghua na boo, lima hangavulu na tinoni sina boo.” ");
INSERT INTO bgt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mara nigna na komi vaovarongo a Jisas kena eia vaghagna imanea ke velera. Na mavitu kena nohe, ");
INSERT INTO bgt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ma Jisas ke hatia e lima na bred me rua na fei me tada hadi i popo me veletokea a God. Gi e vidoa na bred ma na fei me hera nigna na komi vaovarongo eigna kedana kemulia tadia na mavitu. ");
INSERT INTO bgt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na mavitu kena vanga mena mahu. Ma na nigna na komi vaovarongo kena hathatanora na komi viovidoi vanga ke tomagha mena hoghoni vavonua e salaghe rua na arao. ");
INSERT INTO bgt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sina maghavu a Jisas ke mono ghehegna me tarai ma na nigna na komi vaovarongo kena mai itagna. Imanea ke huatira, “Kori ghaghanadia na komi tinoni, ahai inau ena niu?” ");
INSERT INTO bgt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Imarea kena ania, “Kekeha tinoni kena velea ighoe a Jon Siuvitabu ke havi tabiru. Kekeha tinoni kena velea ighoe a profet Elaija, mi kekeha mua kena velea ighoe sina profet tavogha ke ghoi havi tabiru.” ");
INSERT INTO bgt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jisas ke ghoi huatira mua, “Ghamu na ba? Ahai oti aniu?” A Pita ke veleagna, “Ighoe a Vahavi, na mane a God ke vahia bali hathera nigna na mavitu.” ");
INSERT INTO bgt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jisas ke haghore heta vanira eigna kedana boi veleagna sa tinoni iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma a Jisas ke ghoi velera, “Inau, na Dathei Tinoni, imarea kedana vaparau. Mara na naghoi pris ma na mara na velepuhigna na vetula nigna a Moses duadia kekeha mara puhi mua kedana siriuhaghiniu. Imarea kedana vaparau mena vatheheu, kari kori vatolugna na dani inau kuda sokara tabiru kori thehe.” ");
INSERT INTO bgt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Gi a Jisas ke velera na mavitu gougovu, “Ahai itamiu ke magnahaghinia keda nigua na mane vaovarongo, imanea keda saghoi eia na komi fata ke magnahaghinia vamua. Imanea keda leghuu thovohaliu me keda kaikaliti eigna na papara ma na thehe kori ghaibabala. ");
INSERT INTO bgt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Arahai kena boi leghuu inau eigna kena magnahaghinia na eiagna vamua na hava kena magnahaghinia, imarea kedana boi hatia na havi ke teo na govugna. Kari arahai kena sasaa na papara ma na thehe eigna kena leghuu inau, imarea kedana hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ahai ke tonogna na komi fata ke sethe kori maramagna, kari imanea ke vano kori meleha papara leghugna ke thehe, kenughua e hathea mua na komi fata ke tonogna iangeni? Teo! ");
INSERT INTO bgt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Gi ahai ke maomamohaghiniu me maomamohaghinia nigua na velepuhi ikeagaieni, inau, na Dathei Tinoni, kuda siriuhaghinia kori vido kuda ghoi tabiru mai duadia na komi enjel ke tabu duai silada ma na mana nigna a tamagu. ");
INSERT INTO bgt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Inau ku veleghamu, kekeha itamiu koti mono duagu ikeagaieni, kotida boi thehe moti ghieghilei reghia a God ke vunaghi pungusia nigna na mavitu.” ");
INSERT INTO bgt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Leghugna e alu na dani kori veleagna na komi fata iraani, a Jisas ke hatira a Pita ma Jon ma Jemes, mena hadi kori suasupa bali tarai. ");
INSERT INTO bgt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kori vido a Jisas ke tarai, na dodorogna ke tughu. Ma na pohegna ke pura me siasilada puala. ");
INSERT INTO bgt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Gi e rua na mane koro tate mai moro haohaghore duagna a Jisas. Iromara a Moses ma Elaija. ");
INSERT INTO bgt_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Iromara huju oro silada mua, moro haohaghore duagna a Jisas eigna na thehe keda eia i Jerusalem eigna keda vatatapa na hava a God ke magnahaghinia keda eia. ");
INSERT INTO bgt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","A Pita duagna rua na mane kotolu nere. Tolumara kotolu rarai hadi mena reghia na siladagna a Jisas me rua na mane koro sokara duagna. ");
INSERT INTO bgt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","A Moses ma Elaija koro turughu taveti sania a Jisas, ma Pita ke ania a Jisas, “Vunaghi, e toke puala kotoluda mono nimami eeni duamiu! Tolughami kotoluda agutua e tolu na aava, sikei nimua ghoe, sikei nigna a Moses, me sikei nigna a Elaija.” A Pita ke boi toatogha toetoke gi e velea iaani. ");
INSERT INTO bgt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kori vido a Pita ke talu haohaghore mua, sina parako ke mai me tafura. Tolu na mane vaovarongo kotolu mataghu puala kori vido ke tafura na parako. ");
INSERT INTO bgt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma na ohai haghore ke au mai kori parako, “Iaani a pukuni dathegu ku vahia. Oti vaovarongo itagna.” ");
INSERT INTO bgt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Leghugna na ohai haghore, tolumara kotolu reghia a Jisas vamua ke talu mono. Tolumara kotolu mono bughoro eigna na fata kena reghia mena boi velea sa tinoni me ghieghilei haliu atu na komi dani ke sethe. ");
INSERT INTO bgt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sina dani leghugna iangeni, kori vido kena horu mai kori suasupa, na mavitu ke sethe kena mai tagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sina mane ke ghuu hadi tadia na mavitu, “Velepuhi, inau ku kaegho eigna koda hathea a dathegu mane, imanea sikei vamua a dathegu. ");
INSERT INTO bgt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Na tidatho ke haghevia mi kori vido na tidatho ke mai heta itagna, a dathegu ke ghuu heta, ma na tonogna ke aiariri. Imanea ke sikili horu kori thepa ma na oko ke au kori livogna. Boi sethe na maghavu na tidatho ke taveti sania a dathegu me pukuni diadikala na tonogna. ");
INSERT INTO bgt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Inau ku kaera nimua na komi vaovarongo eigna kedana gigi aua itagna, kari ena boi tangomana nidia.” ");
INSERT INTO bgt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A Jisas ke velera na mavitu, “Ighamu na komi tinoni dika. Oti boi vaututuniu! Sethe na maghavu ghohi ku mono duamiu. Ingiha gi kotida vaututuniu?” Gi e veleagna tamagna na gari, “O hati maia a dathemu eeni.” ");
INSERT INTO bgt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Keana, gi e jufu mai a dathegna tagna a Jisas, na tidatho ke vasikili horua kori thepa ma na tonogna na gari ke aiariri puala. A Jisas ke haghore heta vania na tidatho, me taveti au itagna ma na gari ke toke tabiru. Gi a Jisas ke hea vanoa na gari tagna a tamagna. ");
INSERT INTO bgt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na mavitu kena haidu ngengeni kena vere nidia puala na reghiagna na mana ke hutu nigna a God. Kori vido na komi tinoni kena talu vere nidia mua tagna na komi fata ke eia a Jisas, a Jisas ke velera nigna na komi vaovarongo, ");
INSERT INTO bgt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Oti vaovarongo toetoke tagna na hava kuda veleghamu ikeagaieni. Sina tinoni keda lubati vanoa na Dathei Tinoni kori limadia mara nigna na thevuioka.” ");
INSERT INTO bgt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kari nigna na komi vaovarongo kena boi adoa na ghaghanagna na hava ke velea. A God ke poloa vanira na ghaghanagna na haghore iaani eigna kedana boi thaothadoghagna, mena mataghu nidia na huatiagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nigna na komi vaovarongo a Jisas kena riurihu haohaghore varihotaghidia eigna ahai keda nagho itadia. ");
INSERT INTO bgt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","A Jisas ke adoa na ghaghanadia me hati maia sina gari iso me vasokaraghinia ghaghireigna. ");
INSERT INTO bgt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Gi e velera, “Ahai ke hati dothovia sa gari vaghagna iaani eigna ke leghuu inau, imanea ke hati dothoviu inau. Ma ahai ke hati dothoviu inau, imanea ke hati dothovia a God ke vetulau mai. Ahai itamiu ke vahouhorua ghehegna, imanea iangeni ke nagho itamiu.” ");
INSERT INTO bgt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","A Jon ke veleagna a Jisas, “Vunaghi, ighami kiti reghia sina mane ke gigi aura na komi tidatho tadia na komi tinoni kori veleagna na ahamu. Na vunegna imanea ke boi mono kori nida na boo, ighami kiti veleagna eigna keda soto vamua.” ");
INSERT INTO bgt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A Jisas ke anira, “Saghoi vasotoa eigna gi ahai ke boi eia sa fata ke dika itamiu, imanea ke thevu itamiu.” ");
INSERT INTO bgt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na maghavu a God keda hati tabirua a Jisas i popo ke gharani mai ghohi ma a Jisas ke magnahaghinia puala keda vano hadi i Jerusalem. ");
INSERT INTO bgt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Imanea ke kidi vetulara hadi kekeha tinoni tagna sina melehadia na komi tinonidia i Samaria. A Jisas ke vetulara eigna kedana kaikalitia na maigna. ");
INSERT INTO bgt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kari na komi tinoni ingengeni kena boi magnahaghinia a Jisas keda mai kori melehadia eigna kena adoa imanea ke magnahaghinia keda vano i Jerusalem bali tarai, boi i Samaria. ");
INSERT INTO bgt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kori vido e rua na nigna vaovarongo a Jemes ma a Jon koro rongovia iaani, iromara koro ania, “Lod, ehava? O magnahaghinighami koroda kaea na joto eigna keda horu mai i popo me vathehera?” ");
INSERT INTO bgt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kari a Jisas ke rei vano itadia romara me haghore heta vanira. ");
INSERT INTO bgt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Govu, gi ena taveti vano tagna sina meleha tavogha. ");
INSERT INTO bgt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kori vido imarea kena taveti vano kori hangana, sina mane ke ania a Jisas, “Kenughua inau kuda leghugho tadia na komi meleha gougovu koda vano.” ");
INSERT INTO bgt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A Jisas ke haghore tughua, “Na komi aku asi, e mono na vido bali eghodia ma na komi manu na gneku bali monodia. Keana inau, na Dathei Tinoni, e teo sa nigua vathe bali nere nigua.” ");
INSERT INTO bgt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jisas ke veleagna sina mane tavogha, “O mai mo leghuu inau.” Imanea ke haghore tughua, “Lod, o kidi lubatiu eigna kuda vano gilua a tamagu.” ");
INSERT INTO bgt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","A Jisas ke ania, “O lubatira arahai kena thehe eigna kedana gilura arahai itadia kena thehe. Kari ighoe, o vano mo titiono eigna na puhi a God ke vunaghi pungusira na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Sina mane mua ke ania a Jisas, “Lod, inau kuda leghugho, kari o kidi lubatiu eigna kuda vano mu kubaera ara vikegu.” ");
INSERT INTO bgt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A Jisas ke haghore tughua, “Ahai ke turughu na leghuugna, keana leghugna iangeni imanea ke toatogha puala na komi fata ke taveti sania, imanea ke boi nabagna keda tango kori na hughuta nigna a God.” ");
INSERT INTO bgt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Leghugna na komi fata iraani, a Lod Jisas ke vahira e vitu hangavulu rua nigna na vaovarongo eigna kedana vano tadia na komi meleha imanea keda vano. Imanea ke vetulara e rua na tinoni tagna sina meleha. ");
INSERT INTO bgt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Gi e vetulara au, imanea ke anira, “Sethe na tinoni kena kaikaliti na vaututuniagna a God ke vaghagna na gnatha ke ghano mena haga ghelia. Kari e boi sethe arahai kedana ghegheli. Moti tarai kaea a God eigna keda vetula atua na komi tinoni sethe bali hatheghamu na hatiragna mai na komi tinoni itagna. ");
INSERT INTO bgt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Oti vano ikeagaieni. Inau ku vetulaghamu au tadia na komi tinoni kena thevuioka itagua inau. Ighamu kotida vaghadia na komi dathe sip tadia na komi aku asi. ");
INSERT INTO bgt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Oti saghoi ohoa sa rongo ba na ngoi ba varuai na sadol. Oti saghoi hai urungu duadia arahai koti padara kori hangana. ");
INSERT INTO bgt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kori vido kotida haghe vano tagna sina vathe, oti kidi velea, ‘Na soleana nigna a God keda mono duamiu.’ ");
INSERT INTO bgt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Gi arahai ngengeni kena magnahaghinia kedana mono kori soleana, a God keda hera na soleana. Gi kedana bosi magnahaghinia na mono kori soleana, a God keda boi hera na soleana. ");
INSERT INTO bgt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tadia na komi meleha kotida vano, oti mono vamua kori na vathe imarea kena kidi kalitighamu. Saghoi mai moti vano tadia na komi vathe tagna sina meleha. Oti vanga moti kou vamua tadia na komi fata kena heghamu. Eigna e naba na mane tango keda hatia nigna na taba eigna na agutu ke eia. ");
INSERT INTO bgt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Gi kotida vano jufu tagna sina meleha ma na komi tinoni ngengeni kena kalitighamu, oti ghania na komi vanga kena kaliti vanighamu. ");
INSERT INTO bgt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Oti vatoke tabirura arahai kena vahaghi ngengeni moti velera iaani, ‘Na maghavu a God keda vunaghi pungusia nigna na mavitu ke gharani mai ghohi.’ ");
INSERT INTO bgt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gi kotida vano tagna sina meleha keana na mavitu ngengeni ena boi kalitighamu, oti taveti au tagna na komi hangana kori meleha iangeni, moti velera, ");
INSERT INTO bgt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Na thepagna na melehamiu ke thangu kori naemami, ighami kiti tapori aua. Iaani na vaughithatha vanighamu a God keda fateghamu. Moti saghoi havaghinia na maghavu a God keda vunaghi pungusia nigna na mavitu ke gharani mai ghohi.’ ");
INSERT INTO bgt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Inau ku veleghamu, na hava a God keda eia vanira na komi tinonidia na meleha iangeni kori na dani fate keda dika vano tagna na hava imanea keda eia vanira na mavitugna na meleha i Sodom.” ");
INSERT INTO bgt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Gi a Jisas ke velea vaghagna iaani, “A God keda vaparaghamu ighamu koti mono i Korasin! A God keda vaparaghamu ighamu koti mono i Betsaida! Inau ku boi eia na komi reghithehe i Taia mi Saidon ku eia kori melehamiu. Kari gi ku eia na komi reghithehe tadia na komi tinoni ngengeni kena boi Jiu, imarea kedana tughua ghohi na havidia ke koakoa. Imarea kedana pipisia na pohe jongo ke vaghagna na duku mena havula na pidaravu kori tonodia bali tateli aua imarea kena tughua na havidia ke koakoa. ");
INSERT INTO bgt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kori vido a God keda fatera na komi tinoni gougovu, na papara keda eia vanighamu e dika vano tagna na papara keda eia vanira na mavitugna i Taia mi Saidon. ");
INSERT INTO bgt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ighamu na mavitugna i Kapaneam, oti toatogha a God keda abeghamu hadi i popo. Teo! Imanea keda sonighamu horu kori meleha papara.” ");
INSERT INTO bgt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Gi a Jisas ke velera nigna na komi vaovarongo, “Ahai ke rongovighamu, imanea ke rongoviu inau. Ma ahai ke siriuhaghinighamu, imanea ke siriuhaghiniu inau me siriuhaghinia a God ke vetulau mai.” ");
INSERT INTO bgt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kori vido e vitu hangavulu rua mane vaovarongo kena tabiru mai tagna a Jisas, imarea kena totogo puala mena velea, “Lod, na komi tidatho kena leghua na haghoremami kori vido kiti gigi aura kori veleagna na ahamu.” ");
INSERT INTO bgt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A Jisas ke anira, “E tutuni. Inau ku reghia a Satan ke sikili horu mai i popo vaghagna na onga. ");
INSERT INTO bgt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Inau ku heghamu na mana eigna kotida sokara pungusia a Satan. Toke ighamu kotida tapalira na komi poli ma na komi liva, teo keda ghathatighamu. Teo sa fata keda vadikalaghamu. ");
INSERT INTO bgt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Moti saghoi totogo vamua eigna na komi tidatho kena leghua na haghoremiu, keana oti totogo mua eigna na ahamiu ke riso horura ghohi i popo.” ");
INSERT INTO bgt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kori vido iangeni na Tarunga ke Tabu ke vatotogoa a Jisas, gi e velea, “Mama, ighoe ko vunaghi pungusira na komi fata gougovu i popo mi thepa. Inau ku veletokegho eigna ko poloa na komi fata iraani tadia arahai kena ghaghana imarea kena thaothadogha, mo tatelira tadia arahai kena vaghadia na komi gari. Hii, Mama, ighoe ko magnahaghinia keda vaghagna iangeni.” ");
INSERT INTO bgt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Leghugna ke veletokea a God, a Jisas ke velera na komi tinoni, “A Tamagu ke heu mai na komi fata gougovu. Sikei vamua a Tamagu ke pukuni adou inau a Dathegna, mi inau vamua a Dathegna ku pukuni adoa a Tamagu ma arahai vamua inau a Dathegna ku vahira eigna kedana adoa imanea.” ");
INSERT INTO bgt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kori vido kena mono ghehedia, a Jisas ke rei vano tadia nigna na komi vaovarongo me velera, “A God ke vatokeghamu eigna ke lubatighamu na reghiragna na komi fata ke toke. ");
INSERT INTO bgt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Inau ku veleghamu, sethe mara na profet ma na komi king kena thehe ghohi kena haga reghia na komi fata koti reghia, keana ena boi tangomana nidia na reghiagna. Mena magnahaghinia na rongoviagna na komi fata koti rongovia, keana ena boi tangomana nidia na rongoviagna.” ");
INSERT INTO bgt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sina maghavu sina mane velepuhigna na vetula nigna a Moses ke sokara hadi bali pipilia a Jisas. Imanea ke velea, “Velepuhi, na hava kuda eia gi kuda hatia na havi ke teo na govugna?” ");
INSERT INTO bgt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A Jisas ke haghore tughua, “Na hava ke velea na vetula nigna a Moses na? Na hava ko ijumia itagna na?” ");
INSERT INTO bgt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Imanea ke ania, “Oti dothovia a Lod, na nimua a God kori havimiu gougovu, kori tarungamiu gougovu, kori hetamiu gougovu mi kori ghaghanamiu gougovu. Moti dothovira na komi tinoni vaghagna koti dothovighamu ghehemiu.” ");
INSERT INTO bgt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","A Jisas ke velea, “E jino puala nimua na haghore tughu. Gi koda eia vaghagna ko velea, ighoe koda hatia na havi ke teo na govugna.” ");
INSERT INTO bgt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kari na mane velepuhigna na vetula iangeni ke magnahaghinia na komi tinoni kedana ghaghana imanea ke jino me velea, “Arahai ara kulagu? ");
INSERT INTO bgt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A Jisas ke haghore tughua kori titiono iaani: “Sina mane Jiu ke turughu mai i Jerusalem me horu vano i Jeriko. Kori tavetigna horu vano kori hangana, mara na bilau kena thotia mena hatia nigna na komi rongo ma na pohe. Imarea kena thabuhia me thehehaihavi mena taveti sania. ");
INSERT INTO bgt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Leghugna iangeni sina pris ke horu vano kori hangana iangeni. Imanea ke reghia na mane iangeni, me taveti thovohaliu vano sethevui hangana. ");
INSERT INTO bgt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Gi sina mane agutu kori Vathe ke Tabu nigna a God ke horu vano mua kori hangana iangeni. Kori vido ke jufungia na vido ke mono na mane ke thehehaihavi, imanea ke reghia me thovohaliu vano sethevui hangana. ");
INSERT INTO bgt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Leghudia romara, sina manegna Samaria (Mara Jiu mi mara i Samaria kena boi mono veidothovighi) ke taveti me vano horu kori hangana iangeni. Imanea ke reghia na mane kena vangesoa me rarovia nigna. ");
INSERT INTO bgt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Me taveti vano itagna me lumi vararaha na komi ngesogna kori oela ma na waen me tari ponotia na komi ngesogna. Leghugna iangeni gi e pala hadia me lujaghinia kori nigna na dongki, me hati vanoa tagna sina vathe binaboli me reireghia ngengeni. ");
INSERT INTO bgt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kori varuai dani imanea ke hatia aua e rua na seleni ke nabagna na voligna e rua na dani me hea na mane ke reireghia na vathe binaboli me ania, ‘O reireghi tokea na mane iaani. Inau kuda ghoi tabiru mai eeni mu kuda voli tabirua engiha na nimua na rongo ko hatheagna.’” ");
INSERT INTO bgt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Gi a Jisas ke huatia na mane velepuhi iangeni, “Kori ghaghanamu na, ahai itadia tolu na mane irangeni ke eia vaghagna imanea a kulagna na mane kena thabuhia mara na bilau na?” ");
INSERT INTO bgt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Imanea ke velea, “Na mane ke rarovia.” Ma a Jisas ke ania, “O vano mo eia vaghagna iangeni.” ");
INSERT INTO bgt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kori vido a Jisas duagna nigna na komi vaovarongo kena talu taetaveti vano mua i Jerusalem, imarea kena mai tagna sina meleha ke mono sina vaivine, na ahagna a Mata. Iia ke mai tagna a Jisas me kaea eigna keda vano kori vathegna. ");
INSERT INTO bgt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Meri, a vaivinegna a Mata, ke mono kori vathe iangeni me nohe hilighagna a Jisas me vaovarongo kori nigna na velepuhi. ");
INSERT INTO bgt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kari a Mata ke toatogha puala eigna nigna na komi rugusi eigna iia ke kaikalitira na vanga. Me mai tagna a Jisas me ania, “Vunaghi! Ehava? O boi raroviu inau eigna a vaivinegu ke boi hatheu kori kaikaliti vanga? O veleagna a Meri eigna keda mai hatheu!” ");
INSERT INTO bgt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A Jisas ke haghore tughua, “Mata, ighoe ke horuhaihadi na ghaghanamu eigna na komi fata ke sethe. ");
INSERT INTO bgt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Keana, sikei vamua na fata ke nagho. A Meri ke vahia na fata iangeni me teo kuda hati aua itagna.” ");
INSERT INTO bgt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sina dani a Jisas ke tarai. Leghugna ke vagovua na tarai, sina mane tadia nigna na komi vaovarongo ke mai me veleagna, “Lod, o velepuhighami na puhi tarai vaghagna a Jon ke velepuhira nigna na komi vaovarongo.” ");
INSERT INTO bgt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A Jisas ke velera, “Kori tarai kotida velea vaghagnai iaani: Mama, na ahamu ke tabu. O mai mo vunaghi pungusira na komi tinoni gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Heghamami mai ghamami na vanga ke nabamami leuleghu maghavu. ");
INSERT INTO bgt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Talutavogha na komi paluhamami eigna ighami kiti talutavogha na komi paluhadia arahai kena eia na dika itamami. Saghoi lubatia na auau keda mai itamami. ");
INSERT INTO bgt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Gi a Jisas ke velera nigna na komi vaovarongo na titiono velepuhi iaani: “Vaghagna sina mane itamiu keda vano kori vathegna a kulagna kori hotaghi bongi me veleagna, ‘Kulagu, o heu e tolu na bred, ");
INSERT INTO bgt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","eigna sina kulagu ke taveti mai tagna ke hau me jufu ghohi kori vathegu. Kari e teo sa vanga kuda hea.’ ");
INSERT INTO bgt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Gi a kulagna kori vathe keda velea, ‘Saghoi vababaou, na hagetha e bilaki ghohi, ighami ara dathegu iti nere nimami ghohi mu boi tangomana kuda sokara hadi mu hegho sa fata.’ ");
INSERT INTO bgt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Inau ku veleghamu iaani, toke imanea a kulagna, imanea keda bosi magnahaghinia na rarai hadi me hea na bred. Keana gi keda kaea me kaea, imanea keda rarai hadi me hea na hava ke magnahaghinia. ");
INSERT INTO bgt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Na vunegna iaani inau ku veleghamu, oti kaea a God eidia na komi fata koti magnahaghinia, ma a God keda heghamu na komi fata irangeni. Oti hiroa na komi fata koti magnahaghinia, ma a God keda hatheghamu eigna kotida pada. Oti jaejathe kori hagetha ma a God keda hangavia vanighamu. ");
INSERT INTO bgt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Eigna ahai keda kaea na hava tagna a God, imanea keda hea. Ma ahai keda mai hiroa sa fata tagna a God, imanea keda pada. Ma ahai keda jaejathe, a God keda hangavia vania na hagetha. ");
INSERT INTO bgt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ighamu ara tamadia na komi gari, gi keda kaeghamu na igha ara dathemiu, kenughua oti hera na poli? ");
INSERT INTO bgt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ba keda kaeghamu na kidoru, kenughua oti hera na idogna na liva na? ");
INSERT INTO bgt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Toke ighamu na komi tinoni koakoa, ighamu koti adoa na hava ke toke kotida hera ara dathemiu. Keana na vunegna a tamamiu i popo ke pukuni toke, ighamu koti adoa imanea keda hera na Tarunga ke Tabu arahai kedana kaea itagna.” ");
INSERT INTO bgt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sina maghavu a Jisas ke gigi aua na tidatho tagna sina mane ke boi tangomana na haohaghore. Kori vido na tidatho ke taveti sania, imanea ke turughu haohaghore tabiru. Ma na mavitu kena vere nidia puala. ");
INSERT INTO bgt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Keana kekeha tinoni kena velea, “A Satan, na vunaghidia na komi tidatho, ke hea na mana a Jisas bali gigi aura na komi tidatho.” ");
INSERT INTO bgt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kekeha tinoni kena haga pipilia a Jisas. Imarea kena kaea eigna keda eia sikei reghithehe eigna kedana adoa imanea ke pukuni mai tagna a God ba teo. ");
INSERT INTO bgt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Keana a Jisas ke adoa na ghaghanadia me anira, “Gi na mavitu tagna sina meleha hutu kedana riurihu ghadia ghehedia, na meleha iangeni keda govu. Ba gi sina tamadathe kedana riurihu ghadia ghehedia, na tamadathe iangeni keda thevurua. ");
INSERT INTO bgt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ighamu koti velea inau ku gigi aura na komi tidatho kori mana nigna a Satan. Keana, gi a Satan ke heu na mana eigna kuda eia iangeni, imanea ke rihua ghehegna ma nigna na mana keda govu saisami. ");
INSERT INTO bgt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Gi keda tutuni inau ku gigi aura na komi tidatho kori mana nigna a Satan, kori mana nigna ahai nimiu na komi vaovarongo kena gigi aura na komi tidatho na? Na mana nigna a Satan? Teo! Imarea kedana fateghamu eigna na hava koti velea, eigna ighamu koti hahi. ");
INSERT INTO bgt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Keda tutuni inau ku gigi aura na komi tidatho kori mana nigna a God, iaani ke tateli aua na hughuta nigna a God ke mai ghohi itamiu.” ");
INSERT INTO bgt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","A Jisas ke velera na titiono velepuhi iaani: “A Satan ke vaghagna sina mane ke heta ke kaikalitia komi nigna na fata rihu me reireghi toetokea nigna na vathe. Imanea ke ghaghana teo ahai ke tangomana keda bilaua nigna na komi fata. ");
INSERT INTO bgt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Keana kori vido na mane ke heta vano itagna keda mai me rihua, imanea keda hati aua nigna na komi fata bali rihu. Mi manea keda kemulia komi nigna na fata na mane ke rihua tadia ara kulagna. ");
INSERT INTO bgt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ahai ke boi thevu itagua, imanea hiri nigua na thevuioka. Ma ahai ke boi hatheu na hatiragna maia na komi tinoni tagna a God, imanea ke vasoparaka na komi tinoni tagna a God.” ");
INSERT INTO bgt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","A Jisas ke ghoi velea, “Kori vido na tidatho ke taveti au tagna na tinoni, na tidatho ke vano me mai kori meleha ke gou me hiroa na vido bali monogna. Gi keda boi reghipada sa vido bali monogna, imanea keda velea, ‘Da u ghoi tabiru vamua tagna na vathe ku au mai tagna i hau.’ ");
INSERT INTO bgt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kori vido na tidatho ke ghoi tabiru mai, imanea ke reghia na vathe kena jaojaro me raraha ghohi kari e korogha. ");
INSERT INTO bgt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Gi e ghoi taveti au me vano hatira mai duagna e vitu na tidatho ke dika vano itagna, mena mai mono koragna na tinoni iangeni. Ma na havigna na tinoni iangeni ke dika vano tagna na havigna i hau.” ");
INSERT INTO bgt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kori vido a Jisas ke velera na komi fata iraani, sina vaivine tadia na mavitu ke haghore heta hadi, “A God ke vatokea na vaivine ke vahugho me vasusugho!” ");
INSERT INTO bgt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A Jisas ke ania, “Tutuni, kari a God ke pukuni vatokera arahai kena rongovia na haghoregna mena ei leghua. ");
INSERT INTO bgt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sethe mua na tinoni kena haidu mai, ma a Jisas ke velera, “Ighamu na komi tinoni koti havi ikeagaieni, oti dika puala. Ighamu koti magnahaghinia puala na reghiagna na reghithehe. Keana ighamu kotida reghia sikei vamua na reghithehe ke vaghagna na reghithehe a God ke ei vania a profet Jona. ");
INSERT INTO bgt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Na hava a God ke ei vania a Jona, na vaughithatha vanira na mavitu i Ninive eigna kedana adoa a God ke vetula imanea. Vaghagna vamua iangeni, na hava keda padau inau, na Dathei Tinoni, na vaughithatha vanighamu ighamu koti mono ikeagaieni eigna kotida adoa inau ku mai tagna a God. ");
INSERT INTO bgt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kori dani a God keda fatera na komi tinoni, na Queen gna i Siba keda sokara hadi duamiu ighamu koti havi ikeagaieni me velea ighamu koti hahi. Eigna iia ke turughu mai kori kujukugna na maramagna me mai vaovarongo kori nigna na thaothadogha a King Solomon. Ikeagaieni na tinoni ke thaothadogha vano tagna a Solomon ke mai ghohi itamiu, kari ighamu koti bosi magnahaghinia na rongoviagna. ");
INSERT INTO bgt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kori dani a God keda fatera na komi tinoni, na mavitu gna i Ninive kedana sokara hadi duamiu ighamu koti havi ikeagaieni mena velea ighamu koti hahi. Eigna imarea kena tughua na havidia ke koakoa kori vido a Jona ke titiono vanira na hava a God ke veleagna. Ikeagaieni na tinoni ke nagho vano tagna a Jona ke mai ghohi itamiu. Kari ighamu koti bosi magnahaghinia na tughuagna na komi puhimiu ke dika. ");
INSERT INTO bgt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","A Jisas ke ghoi velera iaani, “Teo ahai keda totha na lui me poloa ba boa saragna na nahu. Gi keda totha, imanea keda boa hadia tagna na bali sasaveragna eigna kedana dodoro toetoke na komi tinoni kena haghe mai kori vathe. ");
INSERT INTO bgt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Na matamu ke vaghagna na lui bali batugho. Gi keda toke na matamu, ighoe keda vonungigho na raraha. Kari gi keda dika na matamu, na tonomu keda vonungia na puni. ");
INSERT INTO bgt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Reireghi toke ghamu, e boi toke gi koti ghaghana na raraha ke mono itamiu kari na hava ke tutuni, na puni ke mono itamiu. ");
INSERT INTO bgt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Gi na havimiu keda vonungia na raraha me teo sa puni itamiu, ighamu vaghagna vamua ahai ke mono hahali kori rarahagna na lui.” ");
INSERT INTO bgt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Leghugna ke govu na titiono ke eia a Jisas, sina mane Farise ke kaea eigna keda vano vanga kori vathegna. A Jisas ke vano duagna me haghe kori vathegna me nohe bali vanga. ");
INSERT INTO bgt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na mane Farise iaani ke vere nigna puala na reghiagna a Jisas ke boi sikamea na limagna leghuagna na puhidia mara na Farise. ");
INSERT INTO bgt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A Jisas ke ania, “Ighamu mara na Farise, oti vaghagna na tinoni ke lumi toetokea vamua kosigna na kapu ma na tapera. Eigna na dodorogna na kosigna na havimiu ke toke, keana koragna na havimiu e vonungia na komi fata ke dika ma na gumao. ");
INSERT INTO bgt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Oti mee puala tutuni! A God ke boi agutua na tonoda vamua, kari e agutua mua na heheda. ");
INSERT INTO bgt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gi kotida magnahaghinia na mono raraha kori matagna a God, oti saghoi toatogha vamua na leghuagna nimiu na komi vetula, keana oti toatogha kori hehemiu na hatheragna mara kena kuma.” ");
INSERT INTO bgt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“A God keda vaparaghamu ighamu mara na Farise! Eigna toke ighamu koti hea a God na vasalaghegna na komi ghamiu na vanga koti joua kori ghamiu na gnatha, ighamu koti boi dothovia a God moti boi eia na puhi ke jino vanira na komi tinoni. E toke koti hea a God na komi fata irangeni, kari oti dothovia a God moti eia na puhi ke jino vanira na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“A God keda vaparaghamu ighamu mara na Farise! Eigna kori vido koti vano haghe tadia na komi vathe haidu, ighamu koti magnahaghinia na nohe tadia na komi naghoi sape. Kori vanomiu kori makete, ighamu koti magnahaghinia na mavitu kedana ghithathaghamu mena ghaghana boheghamu. ");
INSERT INTO bgt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","A God keda vaparaghamu! Ighamu oti vaghadia na komi beku kena boi simedia mua. Na komi tinoni kena boi reghira mena boi adoa ena tatapa popodia na komi beku ke mono na komi fata ke dika koradia.” ");
INSERT INTO bgt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sina mane velepuhigna na vetula nigna a Moses ke ania, “Velepuhi, ighoe ko haghore diadikalaghami mua kori vido ko velea na komi fata iraani tadia mara na Farise.” ");
INSERT INTO bgt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","A Jisas ke haghore tughua, “A God keda vaparaghamu ighamu mara na velepuhigna na vetula nigna a Moses! Eigna ighamu koti velepuhira na komi tinoni sethe na vetula ke vahotha puala itadia na leghuragna. Kari ighamu koti boi eia sa fata bali hathera eigna kedana leghura. ");
INSERT INTO bgt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","A God keda vaparaghamu! Eigna ighamu koti agutu toetokera na bekudia mara na profet kena vathehera ara hutumiu i hau. ");
INSERT INTO bgt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Na puhi koti eia iaani ke tateli aua ighamu koti magnahaghinia na hava kena eia ara hutumiu. Eigna gi kotida ghaghana e boi toke na hava kena eia ara hutumiu, ighamu teo kotida agutu toetokera na bekudia mara na profet. ");
INSERT INTO bgt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ma na vunegna iaani, a God ke thaothadogha puala, imanea ke velea iaani, ‘Inau kuda vetula atua tadia na mavitu i Israel na komi profet mi mara na vetula. Imarea kedana vathehera kekeha mena vaparara kekeha.’ ");
INSERT INTO bgt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ighamu na komi tinoni ikeagaieni, a God keda vaparaghamu eigna na thehedia na komi profet kena vathehera ara hutumiu turughu mai kori vuhagna na maramagna, ");
INSERT INTO bgt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","turughu kori vido a Kein ke vathehea a Ebol, me mai jufu kori vido kena vathehea a Sakaria hilighagna na olta kori Vathe ke Tabu nigna a God. Tutuni! Inau ku veleghamu, kenughua a God keda vaparaghamu ighamu koti havi ikeagaieni eigna na thehedia na komi profet irangeni. ");
INSERT INTO bgt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“A God keda vaparaghamu mara na velepuhigna na vetula nigna a Moses! Eigna ighamu koti poloa itadia na komi tinoni na hangana bali adoa a God. Ighamu ghehemiu oti boi adoa a God moti vasotora arahai kena magnahaghinia gi kedana adoa a God.” ");
INSERT INTO bgt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Gi a Jisas ke taveti au kori meleha iangeni. Turughu kori dani iangeni, mara na velepuhigna na vetula nigna a Moses mi mara na Farise kena turughu sokara pungusia a Jisas. Imarea kena huatia na huahuati ke sethe me ke vahotha. ");
INSERT INTO bgt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Imarea kena eia iaani eigna kena magnahaghinia a Jisas keda velea sa fata ke boi jino eigna kedana fatea. ");
INSERT INTO bgt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kori maghavu iangeni, sethe na toghai tinoni kena haidu mai tagna a Jisas mena veitatapalighi. A Jisas ke kidi velera nigna na komi vaovarongo, “Reireghi toke ghamu tagna na komi puhidia mara na Farise. Imarea kena boi leghua na hava kena velepuhiragna na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Na komi fata gougovu na komi tinoni kena poloa kori havidia a God keda tateli au. ");
INSERT INTO bgt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Na hava koti velea kori puni, na komi tinoni kedana rongovia kori raraha, ma na hava koti ngungu eigna korai chogho, imarea kedana ghuu aua tadia na komi tinoni.” ");
INSERT INTO bgt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","A Jisas ke velera mua, “Ara kulagu, oti saghoi mataghunira arahai kedana tangomana na vatheheagna na tonomiu, kari ena boi tangomana nidia na vatheheagna na tarungamiu. ");
INSERT INTO bgt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Keana inau ku veleghamu ahai kotida mataghunia. Oti mataghunia vamua a God, eigna imanea ke tangomana na vatheheagna na tonomiu me mono mua nigna na mana bali soni vanoa na tarungamiu kori meleha papara. Inau ku ghoi veleghamu, oti mataghunia vamua a God. ");
INSERT INTO bgt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ighamu koti adoa ghohi, e lima na manu iso e rua na seleni vamua na volidia. Keana a God ke boi togha sanira sikei itadia. ");
INSERT INTO bgt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na vunegna iaani oti saghoi mataghu, eigna kori ghaghanagna a God ighamu koti nagho vano tadia na komi manu iso. Ma na komi sesehugna na ulumiu a God ke ijumira gougovu.” ");
INSERT INTO bgt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","A Jisas ke ghoi velera, “Gi ahai ke vele aua tadia na komi tinoni imanea nigua na vaovarongo, inau, na Dathei Tinoni, kuda vele aua imanea nigua na vaovarongo tadia na komi enjel nigna a God. ");
INSERT INTO bgt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kari ahai keda vele aua tadia na komi tinoni imanea boi nigua na vaovarongo, inau ghua kuda vele aua tadia na komi enjel nigna a God, imanea boi nigua na vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ahai keda haghore diadikala na Dathei Tinoni, a God ke tangomana na talutavoghagna na paluhagna. Keana ahai keda haghore diadikala na Tarunga ke Tabu, a God keda boi talutavogha na paluhagna imanea. ");
INSERT INTO bgt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Sa maghavu imarea kedana hatighamu kori nidia na komi vathe haidu bali fateghamu. Kori vido ighamu kotida sokara naghodia arahai kena baubatu, oti saghoi toatogha puala na hava kotida velea bali adoa imarea ighamu koti boi ei hahia sa fata. ");
INSERT INTO bgt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Eigna na Tarunga ke Tabu keda veleghamu na hava kotida velea kori maghavu koti sokara naghodia.” ");
INSERT INTO bgt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sina tinoni tadia na mavitu ke veleagna a Jisas, “Velepuhi, o veleagna a toghagu eigna keda kemulia romami na komi fata ke thehe sania a tamamami.” ");
INSERT INTO bgt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A Jisas ke ania, “Nighe, boi nigua na agutu inau kuda vajinoa na fata iaani varihotaghimiu roghamu tamatahi.” ");
INSERT INTO bgt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gi e veleragna arahai kena mono ngengeni, “Reireghi toke ghamu! Saghoi magnahaghinia na komi fata ke sethe kotida tonogna. Eigna na pukuni havimiu e boi mono tagna na komi fata koti tonogna.” ");
INSERT INTO bgt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Gi e titionoa vanira na titiono velepuhi iaani: “Sina mane padarongo ke tonogna na thepa ke toke. Na komi fata ke joura ke kotu toke me sethe na sagharodia. ");
INSERT INTO bgt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Imanea ke toatogha ghehegna vaghagna iaani, ‘Na hava hiri kuda eia ikeagaieni? Eigna nigua na komi vathe bali boa na komi sagharo eri ena iso ghohi.’ ");
INSERT INTO bgt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Gi imanea ke velea, ‘Inau ku adoa na hava kuda eia. Inau kuda reo horua na komi vathe ke iso eigna kuda agutua na komi vathe mathangani ke hutu vano ke naba kuda boa haghea nigua na komi fata gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Gi kuda velea itagua, Toke puala, inau ku boa haghea ghohi na komi fata gougovu ku magnahaghinia tagna na komi vinogha keda mai. Mi ikeagaieni inau kuda mamatho kori nigua na agutu. Inau kuda vanga mu kou mu eia na komi fata keda vatotogou.’ ");
INSERT INTO bgt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Keana a God ke veleagna, ‘O mee! Kori bongi iaani ighoe koda thehe, mo boi adoa ahai keda tonogna na komi fata gougovu ko kalitira ghehemu.’” ");
INSERT INTO bgt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Gi a Jisas ke velera na mavitu, “E tutuni, arahai kena kalitira komi nidia na fata ke sethe, kari ena boi eia na komi fata ke nagho tagna a God, imarea kena mee.” ");
INSERT INTO bgt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisas ke velera nigna na komi vaovarongo, “Na vunegna iangeni, inau ku veleghamu e boi toke keda horuhaihadi na ghaghanamiu eigna na hava kotida ghania ba na hava kotida pokoagna na tonomiu. ");
INSERT INTO bgt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Eigna na havimiu ke nagho vano tagna na vanga ma na poko. ");
INSERT INTO bgt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Oti reghira vano na komi manu. Ena boi joua mena boi ghelia sa vanga. E teo sa nidia na vathe bali boa sa vanga, keana a God ke hera ghadia. Tagna a God ighamu koti nagho vano tadia na komi manu. ");
INSERT INTO bgt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Toke keda horuhaidi na ghaghanamiu eigna na komi fata kori havimiu, ighamu boi tangomana nimiu na vateveagna na havimiu. ");
INSERT INTO bgt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na vunegna ighamu koti boi tangomana nimiu na vateveagna na havimiu, ehava gi e horuhaihadi na ghaghanamiu eigna na komi fata ke sethe? ");
INSERT INTO bgt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Oti reghira vano na komi falaoa. Ena boi agutu mena boi sukia sa pohedia. Kari inau ku veleghamu, toke a King Solomon ke padarongo, e teo sa nigna na pohe ke ulaghagna vano tadia na komi falaoa. ");
INSERT INTO bgt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","God ke vatokea na dodorodia na komi falaoa kena mono vamua sina ghathi vido iso, gi ena sonira vano kori joto. Gi keda eia iangeni, ighita kati adoa imanea keda heghita na poheda. Nimiu na vaututuni ke lae puala! ");
INSERT INTO bgt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Oti saghoi toatogha puala na hava kotida ghania ma na hava kotida kouvia. Saghoi lubatia na ghaghanamiu keda horuhaihadi eidia na komi fata irangeni. ");
INSERT INTO bgt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Arahai kena boi adoa a God, na ghaghanadia ke horuhaihadi eigna na komi fata irangeni. Oti saghoi eia vaghagna iaani, eigna a Tamamiu ke adoa ghohi na komi fata koti magnahaghinia. ");
INSERT INTO bgt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Gi kotida pukuni magnahaghinia a God keda vunaghi pungusighamu, moti eia na hava ke vatotogoa, a God keda heghamu na komi fata iraani ke nabamiu. ");
INSERT INTO bgt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Toke kotida boi sethe, oti saghoi mataghu. Eigna a Tamamiu ke magnahaghinia keda heghamu na komi fata ke kalitira vanira arahai kena lubatia na vunaghi pungusiragna. ");
INSERT INTO bgt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Oti vano moti salemua na komi fata koti tonogna moti hera na rongodia mara kena kuma. Gi kotida eia iaani, ighamu vaghagna koti boa nimiu na rongo i popo kori ngoi keda boi dika. Ma nimiu na rongo teo keda govu eigna ke mono i popo. Mara na biabilau kena boi tangomana nidia na bilauagna ma na komi kokorosi kena boi tangomana na diadikalagna. ");
INSERT INTO bgt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Oti eia vaghagna iaani eigna na hehemiu keda leghua na hava ke nagho vano itamiu. ");
INSERT INTO bgt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Oti mono kaikaliti hahali vaghadia mara na agutu kena mono pitua na vunaghidia keda tabiru mai kori vangahaidu taulaghi. Imarea kena pipisia na pohedia mena totha nidia na lui. Kori vido ke tabiru mai, imanea ke jaejathe kori hagetha mena saisami hangavia vania. ");
INSERT INTO bgt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Na vunaghidia keda eia na fata ke toke vanira eigna imanea ke reghira kena kaikaliti eigna na tabiruagna mai. Inau ku veleghamu, na vunaghidia keda pipisi kori pohe bali agutu me velera eigna kedana nohe me heraghadia. ");
INSERT INTO bgt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tutuni, gi mara na agutu kedana kaikaliti eigna na tabirugna mai, na vunaghidia keda eia na fata ke toke vanira. Toke imanea keda mai kori hotaghi bongi ba kori vuevughei puni, na mane agutu ke toke keda mono kaikaliti. ");
INSERT INTO bgt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Oti toatogha iaani, na tinoni ke tonogna na vathe ke boi adoa na maghavu keda mai na mane bilau. Gi keda adoa, imanea keda boi lubatia na mane bilau keda haghe kori vathegna. ");
INSERT INTO bgt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Vaghagna iangeni, ighamu oti mono kaikaliti hahali eigna na Dathei Tinoni keda tabiru mai kori vido ighamu koti boi adoa.” ");
INSERT INTO bgt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","A Pita ke huatia a Jisas, “Ehava? Lod ighoe ko velea na titiono velepuhi iaani eimami ighami vamua, ba eidia na mavitu gougovu?” ");
INSERT INTO bgt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A Lod ke haghore tughua, “Ahai na mane agutu ke toke me ke thaothadogha? Imanea na mane agutu na vunaghi keda lubatia vania na reireghiagna kekeha mara nigna na mane agutu eigna keda heraghadia na vanga kori vido kedana vanga. ");
INSERT INTO bgt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ma na mane agutu iangeni keda totogo kori vido na vunaghigna keda tabiru mai kori vathegna me reghia imanea ke ei tokea nigna na agutu. ");
INSERT INTO bgt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Inau ku veleghamu, “Kenughua na vunaghigna keda lubati vania na reireghiagna komi nigna na fata gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Keana e boi toke gi na mane agutu keda toatogha na vunaghigna keda boi tabiru mai saisami me turughu thabuhira na komi tinoni kena agutu. Gi e vanga me kou memee hahali. ");
INSERT INTO bgt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na vunaghi keda tabiru mai kori na maghavu na mane agutu iangeni ke boi pitua me boi kaikaliti eigna. Na vunaghi keda pukuni vapara na mane agutu iangeni, me keda vetula vanoa bali papara duadia arahai kena boi vaututuni. ");
INSERT INTO bgt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Na mane agutu ke adoa na agutu na vunaghigna ke magnahaghinia imanea keda ei vania, kari e boi kaikaliti me boi eia, na vunaghigna keda pukuni vapara imanea. ");
INSERT INTO bgt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kari na mane agutu ke boi adoa na agutu na vunaghigna ke magnahaghinia keda ei vania me eia na fata ke hahi, na vunaghigna keda boi rae vapara imanea. Vaghagna iaani, gi a God keda hea na tinoni na fata ke sethe, a God ke magnahaghinia keda eia na komi fata ke toke ke sethe. Gi a God keda hea na tinoni na fata ke sethe vano, a God ke magnahaghinia keda eia na komi fata ke toke ke sethe vano.” ");
INSERT INTO bgt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","A Jisas ke ghoi velera, “Inau ku mai bali ifua na joto kori maramagna keda thevurua na komi tinoni, mu magnahaghinia na joto iangeni ke kidi ghathagna ghohi. ");
INSERT INTO bgt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","“Kari inau kuda kidi papara. Ma na ghaghanagu keda boi toke me ghieghilei govu na papara iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ehava? Ighamu koti ghaghana inau ku mai bali hatia mai na soleana kori maramagna? Teo! Inau ku mai bali thevurua na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Turughu ikeagaieni me vano, na komi tinoni kena mono koragna sina vathe kedana thevurua. Gi keda mono e lima na tinoni koragna sina vathe, e tolu na tinoni kedana dothoviu me rua koroda boi dothoviu. Ba e rua koroda dothoviu me tolu kedana boi dothoviu. ");
INSERT INTO bgt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","A tamagna ma a dathegna mane koroda veiriurihughi. A idogna ma a dathegna vaivine koroda veiriurihughi. Me rua na vungaogna vaivine koroda eia vaghagna iangeni mua.” ");
INSERT INTO bgt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A Jisas ke velera na mavitu, “Gi kotida reghia na puni ke hadi mai i paka, ighamu koti adoa kenughua e uha. Ma na uha ke pukuni mai hiri. ");
INSERT INTO bgt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Gi keda mai na ghuighuri sokara lau, ighamu koti adoa kenughua e vuvughu, moti vajangia hiri na vuvughu. ");
INSERT INTO bgt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ighamu koti adoa na hava keda tate mai tagna sina dani eigna oti adoa puala na komi vaughithatha kori na maaloa ma na thepa. Keana ighamu koti boi adoa na ghaghana ikoragna na komi fata ku eia. Ighamu koti eia vaghagna koti jino kari oti boi jino! ");
INSERT INTO bgt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ehava gi oti boi vahia ghehemiu na fata ke jino kotida eia na? ");
INSERT INTO bgt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gi nimua na thevuioka ke magnahaghinia keda hatigho kori vido bali fate, o kidi pipilia na vajinoagna na hava ke hahi varihotaghimiu kori vido koro boi jufu mua kori vido bali fate. Gi koroda boi vajinoa, imanea keda hatigho vano tagna na mane bali fate, mi manea keda lubatigho vano tadia mara na pulis eigna kedana sonigho haghe kori vathe tatari. ");
INSERT INTO bgt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Inau ku veleghamu, teo koda mamaluha mo ghieghilei voli huia engiha na rongo kena velegho koda volia.” ");
INSERT INTO bgt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kori vido iangeni kekeha tinoni kena mono ngengeni kena veleagna a Jisas eidia kekeha maradia i Galili ke vathehera a Pailat kori vido kena havughaghi vania a God. ");
INSERT INTO bgt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A Jisas ke velera, “Ehava? Ighamu koti ghaghana na thehe ke dika ke padara ke tateli aua imarea kena dika vano tadia na komi tinonidia i Galili? ");
INSERT INTO bgt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Teo! Gi kotida boi tughua na havimiu ke koakoa, ighamu huju kotida thehe vaghadia imarea. ");
INSERT INTO bgt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ba vaghagna ivei kori ghaghanamiu eidia salaghe alu na tinoni kena thehe kori vido ke horuvira na vathe ke hutu i Siloam? Ighamu koti ghaghana na fata ke padara ke tateli aua imarea kena dika vano tadia na komi tinonidia i Jerusalem? ");
INSERT INTO bgt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Teo! Inau ku ghoi veleghamu ghua, gi kotida boi tughua na havimiu ke koakoa, ighamu huju kotida thehe vaghadia imarea.” ");
INSERT INTO bgt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Gi a Jisas ke titiono vanira na titiono velepuhi iaani: “Sina mane ke joua na ghai fig kori nigna na gnatha. Sethe na maghavu imanea ke vano me hiroa na sagharo itagna me boi pada. ");
INSERT INTO bgt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Me veleagna na mane agutu ke agutu kori nigna na gnatha, ‘Reghia, e tolu ghohi na vinogha inau ku mai hiro sagharogna mu boi reghia sikei. O toka horua, eigna ke hai mono kori thepa bali agutu vanga.’ ");
INSERT INTO bgt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kari na mane agutu ke ania, ‘Vunaghi, o talua vanoa ghua sikei na vinogha. Inau kuda ghelia kililia mu boa na thepa ke toke kori vunegna. ");
INSERT INTO bgt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Gi keda sagharo kori vinogha ke mai, bule e toke. Keana gi keda teo ri, bule tangomana koda toka horua.’” ");
INSERT INTO bgt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tagna sina Sabat a Jisas ke velepuhira na mavitu kori vathe haidu. ");
INSERT INTO bgt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Sina vaivine puhi ke mono ngengeni, na tidatho ke vathokia na poghurugna me boi tangomana keda sokara jino koragna salaghe alu na vinogha. ");
INSERT INTO bgt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","A Jisas ke reghia me kiloa maia itagna me velea, “Ighoe ko mamaluha tagna na vahaghi ke padagho.” ");
INSERT INTO bgt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Imanea ke tangolia mi kori vido iangeni vamua iia ke sokara jino me veletokea a God. ");
INSERT INTO bgt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Na mane ke baubatu kori vathe haidu iangeni ke dikatagna tagna a Jisas eigna imanea ke vatoke tabirua kori Sabat. Imanea ke velera na mavitu, “E ono na dani koragna na wik bali eiagna na agutu. Oti mai tadia na komi dani irangeni eigna kedana vatokeghamu kori nimiu na komi vahaghi. Boi kori Sabat.” ");
INSERT INTO bgt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A Lod ke veleragna, “Ighamu koti eia vaghagna koti jino, kari oti boi jino! Ehava? Kori Sabat ighamu koti unuhira nimiu na kau ma na dongki kori vido koti pinitira moti hatira vano kori bea moti vakoura? Hii, ighamu koti eia iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na vunegna iangeni e toke vamua inau ku vamamaluha kori Sabat na vaivine iaani tagna na vahaghi ke pada. Iia ke havi kori vinahuhugna a hutuda Ebraham, ma a Satan ke taria koragna e salaghe alu na vinogha.” ");
INSERT INTO bgt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kori vido a Jisas ke velea iaani, arahai kena thevuioka itagna kena maomamo nidia puala. Keana na mavitu kena totogo nidia puala tadia na komi fata ke toke ke eia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","A Jisas ke huatira na mavitu, “Na hughuta nigna a God, vaghagna ivei kori ghaghanamiu na? Na hava kuda titionoa gi kotida thaothadoghagna? ");
INSERT INTO bgt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","E vaghagna sina katuragna na ghai mastad na tinoni ke joua kori nigna na gnatha. Na katura ke kotu hadi me hutu ma na komi manu kena mai mena agutu gnekudia itadia na komi ototogna.” ");
INSERT INTO bgt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","A Jisas ke ghoi huatira, “Na hava kuda titionoa gi kotida thaothadoghagna na havi a God ke vunaghi pungusia? ");
INSERT INTO bgt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Vaghagna sina ghathi vido isi sina vaivine ke ngignoa duagna sina duku flaoa. Leghugna na ngignoagna, na isi ke vapotea na flaoa me hutu.” ");
INSERT INTO bgt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kori vido a Jisas ke talu taveti me vano i Jerusalem, imanea ke velepuhira na mavitu tadia na komi meleha ke vano jufu itadia. ");
INSERT INTO bgt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sina tinoni ke huatia, “Vunaghi, rua tolu tinoni vamua kedana hatia na havi ke teo na govugna na?” A Jisas ke ania, ");
INSERT INTO bgt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Oti agutu heta eigna kotida haghe kori hughuta nigna a God eigna na hagetha ke kapocho. Inau ku veleghamu, sethe na tinoni kedana pipilia na haghe vano kari imarea kedana boi tangomana. ");
INSERT INTO bgt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kori vido na mane ke tono vathe keda sokara hadi me bilakia na hagetha, ighamu kotida sokara kosi moti kiokido kori hagetha moti velea, ‘Lod o hangavia vanighami na hagetha.’ Keana imanea keda veleghamu, ‘Inau ku bosi adoghamu, mu bosi adoa ivei itagna koti mai.’ ");
INSERT INTO bgt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Gi ighamu kotida velea, ‘Ighami kiti vanga miti kou duamu mo velepuhighami tadia na komi melehamami.’ ");
INSERT INTO bgt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Keana imanea keda veleghamu, ‘Inau ku bosi adoghamu mu bosi adoa ivei koti mai. Oti taveti saniu ighamu koti ei hahalia na komi fata ke dika.’ ");
INSERT INTO bgt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ighamu kotida reghia a Ebraham, Aisak ma a Jekob duadia na komi profet kori hughuta nigna a God. Keana a God keda sonighamu au i kosi. Kori vido iangeni, ighamu kotida dikahehe moti tangi moti gigiri kei. ");
INSERT INTO bgt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Sethe na tinoni kedana mai tadia na komi meleha ivei mi vei kori maramagna. Imarea kedana nohe kori vangahaidu kori hughuta nigna a God. ");
INSERT INTO bgt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Inau ku veleghamu, arahai kena leghu ikeagaieni kedana nagho. Ma arahai kena nagho ikeagaieni kedana leghu.” ");
INSERT INTO bgt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kori vido iangeni kekeha Farise kena mai tagna a Jisas mena veleagna, “Gi koda magnahaghinia koda talu havi, o taveti au tagna na meleha iaani, eigna a Herod Antipas ke magnahaghinia keda vathehegho.” ");
INSERT INTO bgt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A Jisas ke haghore tughura, “A Herod ke dika vaghagna na aku ke asi. Oti vano moti veleagna inau kuda talu gigi aura na komi tidatho, mu vatoke tabirura arahai kena vahaghi. Me boi hau, inau kuda vagovua nigua na agutu. ");
INSERT INTO bgt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ikeagaieni mivughei mi kekeha dani mua, inau kuda talu eia nigua na taetaveti me ghieghilei jufungia i Jerusalem. Eigna Jerusalem vamua na meleha imarea kena vathehera na komi profet.” ");
INSERT INTO bgt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Gi a Jisas ke velea, “Jerusalem, Jerusalem! Ighoe ko pirira mo vathehera na komi profet a God ke vetulara atu itamua. Sethe na maghavu inau ku magnahaghinia kuda hathegho, vaghagna na kokorako vaivine ke hathatanora ara dathegna sarai baghigna me reireghira. Keana ighoe ko boi lubatiu gi kuda hathegho. ");
INSERT INTO bgt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ikeagaieni a God ke au sanigho me au sania nigna na Vathe ke Tabu. Inau ku velegho, ighoe koda boi reghiu me ghieghilei jufu kori dani ighoe koda velea, ‘God, o vatokea imanea ke mai duagna nimua na mana.’” ");
INSERT INTO bgt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tagna sina Sabat a Jisas ke vano eigna keda vanga kori vathegna sina mane ke nagho tadia mara na Farise. Kori vido iangeni imarea kena kaekalea a Jisas, ");
INSERT INTO bgt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","eigna sina mane ke mono ngengeni ke pada na vouvonu me pote na naegna ma na limagna. Gi a Jisas keda vatoke tabirua imanea kori Sabat, imarea kedana fatea. ");
INSERT INTO bgt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","A Jisas ke huatira mara na Farise mi mara na velepuhigna na vetula nigna a Moses, “E lubatia mua nida na vetula keda vatoke tabirua ahai ke vahaghi kori Sabat ba teo?” ");
INSERT INTO bgt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kari imarea kena boi haghore tughua. Ma a Jisas ke tangolia na mane ke vahaghi me vatoke tabirua me vetula aua. ");
INSERT INTO bgt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A Jisas ke ghoi huatira, “Ehava? Gi a dathemu ba nimua na kau keda sikili horu kori lodu kori Sabat, ighoe koda vano saisami mo hatia aua ba teo?” ");
INSERT INTO bgt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Me teo sikei tinoni ke haghore tughua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas ke reghira na komi tinoni kena mai bali vanga kena magnahaghinia kedana nohe tadia na komi sape nidia mara kena nagho. Imanea ke velera na komi haghore iraani: ");
INSERT INTO bgt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Gi sina tinoni keda hulaghinigho kori vangahaidugna na taulaghi, o saghoi vano nohe kori nidia na sape mara kena nagho, eigna da kenughua mai sina tinoni ke nagho vano itamua. ");
INSERT INTO bgt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Gi na mane ke hulaghinigho keda velegho, ‘O sokara hadi, eigna keda atu nohe ngengeni na mane iaani ke eu mai.’ Gi keda ai, ighoe koda maomamo nimua, eigna kedana hatigho mena vanohegho kori nidia na sape mara kena boi nagho. ");
INSERT INTO bgt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Kori vido kena hulaghinigho kori na vangahaidu, o vano mo nohe kori vagovui sape. Kori vido keda reghigho na mane ke eia na vangahaidu, imanea keda velegho, ‘Kulagu, o vano mo nohe kori sape ke toke vano iangeni.’ Kori vido iangeni na komi tinoni kedana reghia imanea ke ghaghana bohegho. ");
INSERT INTO bgt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Inau ku veleghamu iaani eigna kotida thaothadoghagna a God keda vahorua ahai ke tautalunagho me keda ghaghana bohea ahai ke taluleghu.” ");
INSERT INTO bgt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Govu gi a Jisas ke haghore vania na mane Farise ke eia na vangahaidu, “Kori vido ko eia na vangahaidu, o saghoi hulaghinira vamua ara kulamu, ara tahimu, ara vikemu, ma arahai kena padarongo kena mono gharanigho. Eigna imarea tangomana kedana hulaghinigho kori nidia na vangahaidu eigna kedana tughu tabirua na hava ko eia vanira. ");
INSERT INTO bgt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Keana gi koda eia na vangahaidu, o hulaghinira arahai kena kuma, ma arahai kena thehe na naedia ba na limadia, ma arahai kena doa. ");
INSERT INTO bgt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Gi koda eia iangeni, a God keda vatokegho. Imarea kedana boi tangomana nidia na tughu tabiruagna na hava ko eia vanira. Kari a God keda tughu tabirua vanigho kori vido arahai kena jino kedana sokara tabiru kori thehe. ");
INSERT INTO bgt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sina mane ke nohe duadia ke rongovia na hava ke velea a Jisas me ania, “Ahai keda mono kori na vangahaidu kori hughutagna a God keda totogo puala.” ");
INSERT INTO bgt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","A Jisas ke velea, “Sina mane ke eia sina vangahaidu hutu me hulaghinira na komi tinoni ke sethe. ");
INSERT INTO bgt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kori vagovuagna na kaikaliti, imanea ke vetula nigna na mane agutu eigna keda vano velera arahai ke hulaghinira, ‘Oti mai! Na komi fata ke kaikaliti govua ghohi.’ ");
INSERT INTO bgt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Keana imarea gougovu kena velea kena rugusi nidia. Sina mane ke velea, ‘Inau ku volia sina vido thepa mu magnahaghinia kuda vano reghia. O veleagna e vahothahaghiniu na atu.’ ");
INSERT INTO bgt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Sina mane ke velea, ‘Inau ku eu volia vamua e salaghe na kau mu haga vano vaagutura eigna kuda adoa ena agutu toke ba teo. O veleagna e vahothahaghiniu na atu.’ ");
INSERT INTO bgt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Sina mane mua ke velea, ‘Na vunegna ku eu taulaghi nigua vamua, inau ku boi tangomana nigua na atu.’ ");
INSERT INTO bgt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Na mane agutu ke tabiru me veleagna na vunaghigna na komi fata iraani. Na vunaghigna ke dikatagna me velea nigna na mane agutu, ‘O vano saisami tadia na komi hangana hutu ma na komi hangana iso mo hatira mai arahai kena kuma, ma arahai kena thehe na naedia, ma arahai kena doa.’ ");
INSERT INTO bgt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kori vido na mane agutu ke eia iaani, imanea ke tabiru tagna me veleagna, ‘Inau ku eia ghohi na hava ko veleugna, kari sethe mua na komi sape ke manga.’ ");
INSERT INTO bgt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ma na vunaghigna ke veleagna, ‘O vano mo kilora mai arahai kena mono kosigna na melehada mo vano tadia na komi hangana kori leleghai mo kilora mai na komi tinoni eigna keda vonu nigua na vathe. ");
INSERT INTO bgt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Teo sikei itadia arahai ku kidi hulaghinira kedana mai gnamia na vanga ku kalitia vanira.’” ");
INSERT INTO bgt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sina maghavu na mavitu ke sethe kena leghua a Jisas. Imanea ke rei tabiru me anira, ");
INSERT INTO bgt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ahai ke magnahaghinia keda nigua na vaovarongo, imanea keda dothoviu inau vano tagna a tamagna ma a idogna, a taugna mara dathegna, mara tahigna mara vaivinegna, vaghagna mua na havigna ghehegna. ");
INSERT INTO bgt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ahai ke boi sasaa na papara ma na thehe eigna ke leghuu inau, imanea ke boi nabagna keda nigua na vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Gi sikei itamiu keda haga agutua na vathe ke hutu, na hava keda eia? Imanea keda kidi nohe me toatogha engiha na rongo keda nabagna na agutuagna. Imanea keda ijumia nigna na rongo eigna keda adoa e naba ba teo. ");
INSERT INTO bgt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Gi keda boi eia iangeni, me turughu sokaraghinia vamua, imanea keda boi tangomana na agutu govuagna na vathe eigna na rongo ke boi nabagna. Ma arahai kena reghia na vathe ke boi govu, imarea kedana kihaghinia mena velea, ");
INSERT INTO bgt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Reghia, na mane iangeni ke turughu agutua nigna na vathe me boi tangomana nigna na vagovuagna!’ ");
INSERT INTO bgt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Gi na king keda kaikaliti bali taveti au duagna e salaghe na toghai soldia eigna keda rihua sina king tavogha ke mai duagna e tutughu na toghai soldia. Gi e taveti au, imanea keda kidi nohe horu me toatogha gi nigna na komi soldia kedana tangomana na rihuragna na komi soldia nigna na king tavogha ba teo. ");
INSERT INTO bgt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Gi keda adoa ke vahothahaghinia, imanea keda vetulara vano kekeha tinoni tagna na king tavogha iangeni kori vido ke hau eigna kedana kaea, ‘Na hava ko magnahaghinia kitida eia eigna katida boi rihu?’ ");
INSERT INTO bgt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Vaghagna iangeni hiri, oti kidi toatogha nimiu toetoke gi kotida nigua na komi vaovarongo. Eigna ahai keda boi taveti sania nigna na komi fata gougovu, imanea boi tangomana keda nigua vaovarongo.” ");
INSERT INTO bgt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Na sol na fata ke toke bali vamugna na vanga. Keana gi keda beabeagha, boi tangomana nidia kedana ghoi vaaha. ");
INSERT INTO bgt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma na sol iangeni ke boi tangomana na vatokeagna na thepa me boi toke bali eiagna sa fata. E nabagna da sonia vamua. Ahai ke magnahaghinia na thaothadoghagna iaani, imanea keda vaovarongo toetoke.” ");
INSERT INTO bgt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sina maghavu sethe mara na oho takis duadia kekeha mara koakoa kena hathatano mai eigna kedana vaovarongo tagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mara na Farise mi mara na velepuhigna na vetula nigna a Moses kena titiono popoloa a Jisas vaghagna iaani, “Na mane iaani ke magnahaghinira puala mara na koakoa me vanga mua duadia.” ");
INSERT INTO bgt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ma a Jisas ke velera na titiono velepuhi iaani: ");
INSERT INTO bgt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Gi sina mane itamiu keda tonogna sina hathangatui sip me hahi sikei itadia, na hava keda eia na mane iangeni? Imanea keda talu horura e hia hangavulu me hia na sip kori vido kena vanga me vano hiroa sikei ke hahi me ghieghilei pada. ");
INSERT INTO bgt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kori vido ke pada, imanea keda totogo me ghalalua, ");
INSERT INTO bgt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","me hatia vula. Imanea keda kilora mai ara kulagna ma arahai kena mono gharania me veleragna, ‘Inau ku totogo puala eigna ku pada ghohi na nigua na sip ke hahi. Oti mai moti totogo duagu!’” ");
INSERT INTO bgt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Gi a Jisas ke velera, “Vaghagna vamua iangeni kori vido na tinoni koakoa ke tughua na havigna ke koakoa. Arahai kena mono i popo kedana totogo hutu puala. Nidia na totogo eigna na tinoni iaani keda hutu vano tagna nidia na totogo eidia e hia hangavulu me hia na tinoni kena jino ghohi. ");
INSERT INTO bgt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Gi sina vaivine keda tonogna e salaghe na sileni me sosoni sikei, na hava keda eia iia na? Iia keda totha na lui me jaroa na vathe me hiroa ivei mi vei me ghieghilei reghipada. ");
INSERT INTO bgt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kori vido ke pada, iia keda kilora mai ara kulagna ma arahai kena mono gharania me veleragna, ‘Inau ku totogo nigua hutu puala eigna ku pada nigua na sileni ke sosoni. Oti mai moti totogo duagu! ");
INSERT INTO bgt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Gi a Jisas ke velera, “Inau ku veleghamu, e vaghagna iangeni kori vido na tinoni koakoa ke tughua na havigna ke koakoa. A God ma na komi nigna na enjel kena totogo hutu puala kori vido sina tinoni ke koakoa ke tughua na havigna ke koakoa.” ");
INSERT INTO bgt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","A Jisas ke ghoi anira, “Sina mane ke mono e rua na dathegna mane. ");
INSERT INTO bgt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na mane ke havi leghu ke veleagna a tamagna, ‘Mama, o heu mai nigua na komi fata kuda hatia kori vido koda thehe.’ Ma a tamagna ke kemulia vanira nigna na komi fata koroda hatia. ");
INSERT INTO bgt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Boi hauhaugna leghugna iaani, na mane ke havi leghu ke salemua komi nigna na fata me hatia na rongo me taveti vano tagna sina meleha ke hau. Kori vido ke mono ngengeni, imanea ke sonia govu nigna na rongo tagna na puhi havi ke mee. ");
INSERT INTO bgt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Leghugna na soni govuagna nigna na rongo, na rofo ke hutu ke pada na meleha iangeni mi imanea ke turughu papara. ");
INSERT INTO bgt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Imanea ke vano tagna sina mane kori meleha iangeni me kaea eigna keda hea sa agutu. Na mane iangeni ke vetula vanoa eigna keda reireghira nigna na komi botho. ");
INSERT INTO bgt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na mane mathangani ke rofo puala me haga ghania na vanga ke hera ghadia na komi botho, eigna e teo sa tinoni ke hea ghagna. ");
INSERT INTO bgt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Leghugna kekeha dani, na ghaghana ke jino ke ghoi tabiru mai itagna me toatogha vaghagna iaani, ‘Komi nigna na mane agutu a tamagu kena vanga mena mahu, kari inau u rofo mu haga thehe. ");
INSERT INTO bgt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Inau kuda ghoi tabiru vamua tagna a tamagu mu kuda veleagna, ‘Mama, inau ku koakoa pungusia a God mu koakoa pungusigho ighoe. ");
INSERT INTO bgt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ikeagaieni inau u boi nabagu gi koda kilou a dathemu. O lubatiu eigna kuda sikei tadia nimua na komi mane agutu.’” ");
INSERT INTO bgt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Gi imanea ke sokara hadi me tabiru tagna a tamagna. Kori vido imanea ke taveti mai mua tagna ke hau, a tamagna ke reghia me rarovia. Imanea ke raghe vano tagna a dathegna me tangolia me kisia. ");
INSERT INTO bgt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma a dathegna ke ania, ‘Mama inau ku koakoa pungusia a God mu koakoa pungusigho ighoe. Ikeagaieni inau u boi nabagu gi koda kilou a dathemu.’ ");
INSERT INTO bgt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Keana a tamagna ke kilora mai mara nigna na mane agutu me anira, ‘Oti hati maia na poko ke toke vano moti vapokoagna. Oti vahaghea na ringi kori kaukaugna ma na sadol kori naegna. Oti eia saisami! ");
INSERT INTO bgt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Oti vano moti vathehea na kau ke hutu bali eia na vangahaidu. Ighita katida totogo duagna a dathegu, ");
INSERT INTO bgt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","eigna ke vaghagna ke thehe ghohi keana e ghoi havi tabiru. Imanea ke hahi, keana ikeagaieni inau ku pada ghohi.’ Kori vido na komi fata ke kaikaliti ghohi, imarea kena turughu na vangahaidu. ");
INSERT INTO bgt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kori vido iangeni na mane ke havi nagho ke talu agutu mua kori gnatha. Imanea ke vula me mai gharania na vathe me rongovia na komi tinoni kena ifu mena ragi. ");
INSERT INTO bgt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Imanea ke kiloa mai sina mane agutu me huatia eigna na hava kena eia na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma na mane agutu ke veleagna, ‘A tahimu ke tabiru mai ma a tamamu ke vathehea na kau ke hutu me eia na vangahaidu eigna a tahimu ke havi me ghoi tabiru mai.’ ");
INSERT INTO bgt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Na mane ke havi nagho ke rongovia iaani me dikatagna me boi haghe kori vathe. A tamagna ke au mai itagna me kaea eigna keda vano haghe kori vathe. ");
INSERT INTO bgt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Keana imanea ke haghore tughu vania a tamagna, ‘O reghia! Sethe na vinogha ghohi, inau ku agutu hutu vanigho mu eia hahali na hava ko veleu. Kari ighoe o boi heu sikei got ke iso gi kuda vangahaidu duadia ara kulagu. ");
INSERT INTO bgt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Keana kori vido a dathemu iaani ke soni govua nimua na rongo tadia na koi vaivine kikirase ke tabiru mai, ighoe ko vathehea vania na kau ke hutu!’ ");
INSERT INTO bgt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ma a tamagna ke velea, ‘Dathegu, leuleghu maghavu ighoe ko mono duagu ma na komi fata ku tonogna na nimua. ");
INSERT INTO bgt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Keana e toke katida totogo mati eia na vangahaidu, eigna a tahimu vaghagna ke thehe ghohi kari e ghoi havi tabiru. Imanea ke hahi, kari ikeagaieni inau ku pada ghohi.’” ");
INSERT INTO bgt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A Jisas ke eia na titiono velepuhi iaani tadia nigna na komi vaovarongo: “Kekeha tinoni kena velea sina mane padarongo vaghagna iaani, “Nimua na mane bali reireghia nimua na komi fata ke diadikala nimua na rongo.” ");
INSERT INTO bgt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Na mane padarongo ke kiloa mai imanea me veleagna, ‘Inau ku rongovia ghohi ighoe ko eia na fata ke dika. O riso horua na hava ko eia tagna nigua na komi fata, eigna inau ku vagovugho kori nimua na agutu.’ ");
INSERT INTO bgt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Leghugna iaani na mane agutu ke ghaghana vaghagna iaani, ‘A vunaghigu ke vagovuu ghohi inau kori nigua na agutu. Na hava kuda eia ikeagaieni? Inau ku boi heta ghohi kuda ghegheli direni, mu maomamo nigua kuda kaekae rongo. ");
INSERT INTO bgt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Inau ku adoa na hava kuda eia. Toke kuda govu ghohi kori nigua na agutu, na komi tinoni kedana kaliti tokeu kori vathedia.’ ");
INSERT INTO bgt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Imanea ke kilora mai mara kena kaoni tagna na vunaghigna. Gi e veleagna na mane ke kidi mai, ‘Engiha ko kaonia tagna na vunaghigu?’ ");
INSERT INTO bgt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Imanea ke veleagna, ‘Alu na hathangatui galon oela.’ Ma na mane agutu ke veleagna, ‘Iaani na pepagna nimua na kaoni, o reoa saisami mo risoa e vati hathangatu na galon oela vamua.’ ");
INSERT INTO bgt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kori vido na varuagna na mane ke mai, na mane agutu ke huatia, ‘Ighoe na ba? Engiha ko kaonia tagna na vunaghigu?’ Imanea ke veleagna, ‘Sina hathangatu dukui wit.’ Ma na mane agutu ke veleagna, ‘Iaani na pepagna nimua na kaoni, o reo saisamia mo risoa e vati tutughu vamua.’ ");
INSERT INTO bgt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Na vunaghi ke adoa na fata ke dika ke eia nigna na mane agutu, kari e kilothaba imanea eigna imanea ke thaothaghoda kori na fata ke eia. E tutuni na komi tinoni bongihehe kena thaothadogha vano tadia na komi tinoni kena mono kori raraha kori reireghiragna nidia na komi agutu.” ");
INSERT INTO bgt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Gi a Jisas ke velera nigna na komi vaovarongo, “Oti hathera arahai tavogha tagna nimiu na komi fata koti tonogna kori maramagna iaani. Kori vido ke govu nimiu na komi fata moti vano i popo, a God keda kaliti tokeghamu ngengeni. ");
INSERT INTO bgt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ahai ke tango jino kori reireghiragna na komi fata ke iso, imanea keda tango jino hiri kori reireghiragna na komi fata ke hutu. Keana ahai ke boi tango jino kori reireghiragna na komi fata ke iso, imanea keda boi tango jino kori reireghiragna na komi fata ke hutu. ");
INSERT INTO bgt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Vaghagna iangeni, gi koda boi tango jino kori reireghiragna na komi fata kori maramagna, a God keda boi vaututunigho kori reireghiragna nigna na pukuni fata ke toke. ");
INSERT INTO bgt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Gi koda boi tango jino kori reireghiragna nidia na rongo arahai tavogha kori maramagna iaani, a God keda boi hegho nigna na komi fata i popo. ");
INSERT INTO bgt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Teo sikei mane agutu ke tangomana na agutu vania e rua na vunaghi. Gi keda eia iangeni, imanea keda thevuioka tagna sikei me dothovia sikei. Ba imanea keda ghaghana bohea sikei me boi ghaghana bohea na varuagna. Vaghagna iangeni, boi tangomana kotida dothovia a God ma na rongo.” ");
INSERT INTO bgt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mara na Farise kena rongovia a Jisas ke velea iaani mena leuleua eigna kena pukuni dothovia na rongo. ");
INSERT INTO bgt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A Jisas ke anira, “Ighamu koti eia na komi fata ke sethe eigna na mavitu kedana velea ighamu na komi tinoni jino. Kari a God ke adoa na hava ke mono kori havimiu. Sethe na fata kena ghaghana bohea na komi tinoni kori maramagna, kori matagna a God na komi fata irangeni ke dika puala.” ");
INSERT INTO bgt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","A Jisas ke ghoi velea iaani, “I hau ighita kati leghua na komi vetula nigna a Moses ma na komi fata kena risoa mara na profet. Turughu tagna a Jon Siuvitabu, imarea kena tuturia na Rorongo ke Toke eigna na hughuta nigna a God, me sethe na tinoni kena magnahaghinia a God keda vunaghi pungusira na havidia. ");
INSERT INTO bgt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kari e teo sa fata ke iso keda govu tadia na komi vetula nigna a Moses. Na maaloa ma na thepa keda govu, keana na komi vetula irangeni keda boi govu. ");
INSERT INTO bgt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Gi ahai keda sonia a taugna me taulaghi tagna sina vaivine tavogha, imanea ke ghoho. Ma gi ahai ke taulaghi tagna na vaivine ke sonia a taugna, imanea ke ghoho hiri.” ");
INSERT INTO bgt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","A Jisas ke ghoi velea iaani, “Sina mane padarongo ke mono ke pokoa na komi poko ke vahotha me vanga na komi vanga ke toke leuleghu maghavu. ");
INSERT INTO bgt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Me mono mua sina mane ke vonu na tubu kori tonogna, na ahagna a Lasarus. Ara kulagna kena ado hati vanoa kori hagethai vathegna na mane ke padarongo eigna keda kaekae nigna rongo. ");
INSERT INTO bgt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A Lasarus ke magnahaghinia puala keda ghania na komi viovidoa vanga ke tomagha tagna na mane padarongo. Imanea ke nohe ngengeni ma na komi aku kena mai mena gnaignapia na komi tubugna. ");
INSERT INTO bgt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kori vido a Lasarus ke thehe, na komi enjel kena hatia eigna keda mono duagna a Ebraham i popo. Ma na mane padarongo ghua ke thehe mena gilua. ");
INSERT INTO bgt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Imanea ke vano kori meleha papara me mono papara puala ngengeni. Imanea ke tada hadi me reghia a Ebraham tagna ke hau ma a Lasarus ke mono duagna. ");
INSERT INTO bgt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Na mane padarongo ke ghuuvia a Ebraham me ania, ‘Mama Ebraham, o raroviu! O vetula maia a Lasarus itagua eigna keda vagnubua na kaukaugna kori bea, me vaghaula na thapigu. Eigna inau ku papara puala kori joto iaani.’ ");
INSERT INTO bgt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Keana a Ebraham ke haghore tughua, ‘Dathegu, ighoe ko adoa, kori havimu ko tonogna na komi fata ko magnahaghinia, kari a Lasarus eni, na komi fata ke dika vamua ke pada imanea. Keana, ikeagaieni imanea ke totogo hutu puala, mi ighoe ko papara puala. ");
INSERT INTO bgt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Sina fata mua koda toatogha, na lodu hutu ke mono varihotaghida, me teo ahai keda hathavu atu itamua me teo ahai keda hathavu mai itamami.’ ");
INSERT INTO bgt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ma na mane padarongo ke veleagna a Ebraham, “Mama Ebraham, inau ku kaegho, o vetula vanoa a Lasarus kori vathegna a tamagu. ");
INSERT INTO bgt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","O velea eigna keda vano vavotura e lima ara tahigu eigna kedana boi mai kori meleha papara iaani.’ ");
INSERT INTO bgt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Keana a Ebraham ke veleagna, ‘Na komi rioriso nigna a Moses ma na komi profet e mono ghohi bali vavotura. Imarea tangomana kedana rongovia mena leghua.’ ");
INSERT INTO bgt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ma na mane padarongo ke haghore tughua, ‘Teo, Mama Ebraham! Imarea kedana boi rongovia. Kari, gi keda vano itadia ahai vamua ke havi tabiru kori thehe, gi imarea kedana tughua na havidia ke koakoa.’ ");
INSERT INTO bgt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“A Ebraham ke velea, ‘Gi kedana boi leghua na komi rioriso nigna a Moses ma na komi profet, toke ahai keda havi tabiru kori thehe keda vano itadia, imarea kedana boi tughua na havidia ke koakoa.’” ");
INSERT INTO bgt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","A Jisas ke velera nigna na komi vaovarongo, “Na komi fata ke auaura na komi tinoni keda mono hahali. Kari ahai ke vasikilia na tinoni kori koakoa keda papara puala. ");
INSERT INTO bgt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ahai ke magnahaghinia keda vajefea sa tinoni ke vaututuniu, e toke gi kedana taria na ghahira hutu kori luagna mena soni horua kori tahi, eigna na hava a God keda eia itagna sa tinoni ke vajefea sa tinoni e tahu vano tagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Moti reireghi toke ghamu tagna na komi fata koti eia! “Gi sina tinoni ke leghuu inau keda koakoa pungusigho, o veleagna imanea ke ei hahia. Gi imanea ke dikahehegna, o talutavogha na paluhagna. ");
INSERT INTO bgt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Gi keda vitu horu eiagna na fata ke dika itamua koragna sina dani, kari e vitu horu maigna itamua me velegho, ‘Inau ku dikahehe hutu puala eigna na hava ku eia,’ o talutavogha na paluhagna imanea.” ");
INSERT INTO bgt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sina dani mara na vetula kena veleagna a Lod Jisas, “O vaheta nimami na vaututuni.” ");
INSERT INTO bgt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma a Jisas ke haghore tughura, “Toke nimiu na vaututuni keda iso puala vaghagna na katuragna na ghai mastad, ighamu tangomana kotida veleagna na ghai hutu iangeni ‘O vutigho hadi ghehemu mo vano jougho ghehemu kori tahi,’ ma na ghai iangeni keda leghua na haghoremiu. ");
INSERT INTO bgt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ehava? Gi ighoe ko mono nimua na mane agutu ke agutu kori ghamua na gnatha be reireghia nimua na komi sip, mi manea ke tabiru mai kori vathe, ighoe koda veleagna, ‘O nohe mo vanga ghamua’ oania? ");
INSERT INTO bgt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Teo! Ighoe koda veleagna, ‘O vano mo kalitia ghagua na vanga mo pipisi toetoke gi o hatia mai ghagua na vanga. Kori vido inau ku govu na vanga, ighoe tangomana koda vanga.’ ");
INSERT INTO bgt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ehava? Ighoe koda veletokea nimua na mane agutu iangeni eigna ke leghua na haghoremu vamua? Teo! ");
INSERT INTO bgt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Vaghagna iangeni itamiu. Kori vido koti vagovua na komi fata a God ke veleghamu na eiragna, ighamu kotida velea, ‘Ighami na mara agutu vamua, miti eia vamua nimami na agutu.’” ");
INSERT INTO bgt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","A Jisas ke talu taveti vano i Jerusalem me halu vano varihotaghidia e rua na provins i Samaria mi Galili. ");
INSERT INTO bgt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kori vido a Jisas ke jufu tagna sina meleha, salaghe na mane kena lepa kena mai itagna. Imarea kena sokara tagna ke hau, ");
INSERT INTO bgt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","mena ghuuvia, “Jisas, Vunaghi, o rarovighami.” ");
INSERT INTO bgt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","A Jisas ke reghira me anira, “Oti vano tadia na komi pris eigna kedana adoa na tonomiu ke toke ghohi.” Kori vido imarea kena taveti vano na tonodia ke pukuni toke tabiru. ");
INSERT INTO bgt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kori vido sina mane itadia ke reghia na tonogna ke toke tabiru, imanea ke ghoi tabiru tagna a Jisas. Imanea ke ghuu heta, “Kilothaba a God, inau ku ghoi toke tabiru!” ");
INSERT INTO bgt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Gi e torongaghi tuturu horu itagna a Jisas me veletokea eigna na hava ke ei vania. Imanea, na manegna i Samaria. ");
INSERT INTO bgt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma a Jisas ke velea, “Nighe! E salaghe na mane ghua ku vatoke tabirura. Ivei e hia na mane na? ");
INSERT INTO bgt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ehava na mane ke boi Jiu vamua ke tabiru mai bali kilothaba a God?” ");
INSERT INTO bgt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Gi a Jisas ke veleagna, “O sokara hadi mo taveti, nimua na vaututuni ke vatoke tabirugho.” ");
INSERT INTO bgt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sina dani, kekeha mara na Farise kena huatia a Jisas ingiha a God keda turughu vunaghi pungusira nigna na mavitu. Jisas ke haghore tughura, “Ighamu kotida boi reghia sa vaughithatha eigna kotida adoa a God ke turughu na vunaghi pungusiragna nigna na mavitu. ");
INSERT INTO bgt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Teo ahai keda velea, ‘Reghia, a God ke vunaghi eeni,’ ba ‘Reghia, imanea ke vunaghi ngengeni.’ Eigna a God ke vunaghi kori havidia na komi tinoni.” ");
INSERT INTO bgt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ma a Jisas ke velera nigna na komi vaovarongo, “Sa maghavu keda mai ighamu kotida magnahaghinia puala na reghiagna na dani na Dathei Tinoni keda mai itagna. Keana imanea keda boi mai kori vido iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kekeha tinoni kedana veleghamu, ‘Reghia, imanea ke mai ghohi me mono ngengeni,’ ba ‘Imanea ke mono eeni.’ Oti saghoi vaututunira moti saghoi vano hiroa. ");
INSERT INTO bgt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Eigna kori vido na Dathei Tinoni keda tabiru mai, na komi tinoni gougovu kedana tangomana na reghiagna vaghagna kena tangomana na reghiagna na onga ke ongavia ma na rarahagna ke vararaha na maaloa gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Keana gi e tabiru mai na Dathei Tinoni, imanea keda papara puala ma na komi tinoni kena mono ikeagaieni kedana siriuhaghinia. ");
INSERT INTO bgt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kori tabirugna mai na Dathei Tinoni, na havidia na komi tinoni keda vaghagna vamua na havidia na komi tinoni kori monogna a Noa. ");
INSERT INTO bgt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tadia na komi dani irangeni na komi tinoni kena vanga mena kou mena taulaghi. Imarea kena eia na komi fata iraani me ghieghilei jufu kori dani a Noa ke hahaghe hadi kori vaka. Gi na uha hutu ke horu mai, ma na biringita ke vathehera gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ma na havidia na komi tinoni keda vaghagna mua na havidia na komi tinoni kori monogna a Lot. Na komi tinoni kena vanga mena kou, mena saisabiri mena voivoli, mena jou vanga mena agutu vathe. ");
INSERT INTO bgt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Keana, kori dani a Lot ke taveti au i Sodom, na joto ma na ghahira inge ke sikili horu mai i popo me vathehera gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Vaghagna iangeni, na komi tinoni kedana boi kaikaliti mena peperiki kori dani na Dathei Tinoni keda tabiru mai. ");
INSERT INTO bgt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Kori dani iangeni, ahai ke mono kosigna na vathe, imanea keda saghoi tabiru haghe bali hatia nigna na komi fata. Ahai ke agutu kori gnatha, imanea keda boi tabiru haghe kori vathe bali hatia sa fata. ");
INSERT INTO bgt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Oti saghoi havaghinia na hava ke pada a taugna Lot. Iia ke rei tabiru tagna na meleha i Sodom ma a God ke vathehea. ");
INSERT INTO bgt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ahai ke magnahaghinia na tatango ngasi kori havigna kori maramagna, imanea keda boi hatia na havi ke teo na govugna. Kari ahai ke boi tatango ngasi kori havigna kori maramagna me leghuu inau, imanea keda hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Inau ku veleghamu, kori vido inau kuda tabiru, e rua na tinoni koroda nere tagna sikei na matha. A God keda hati aua sikei me talua sikei. ");
INSERT INTO bgt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","E rua na vaivine koroda kaikaliti vanga. Ma a God keda hati aua sikei me talua sikei. ");
INSERT INTO bgt_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","E rua na mane koroda agutu kori gnatha. A God keda hati aua sikei me talua sikei.” ");
INSERT INTO bgt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nigna na komi vaovarongo kena huatia, “Lod, ivei keda jufu mai na komi fata iraani ko veleghami?” A Jisas ke haghore tughura, “Ivei ke mono na fata ke thehe, na komi manu hutu kena haidu vano ingengeni.” ");
INSERT INTO bgt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","A Jisas ke titiono vanira nigna na komi mane vaovarongo sina titiono velepuhi eigna kedana tarai hahali mena saghoi toali. ");
INSERT INTO bgt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Imanea ke velera, “Tagna sina meleha sina mane fate ke mono. Imanea ke boi maimanihihia a God me boi ghaghana bohera na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sina vaivine thehe sasani kori meleha iangeni ke mai hahali itagna me kaea eigna keda vajinoa na hava ke ei hahia itagna sina tinoni. ");
INSERT INTO bgt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Haga sethe na maghavu na mane fate ke boi sasaa na hatheagna. Vano me vano gi imanea ke toatogha ghehegna, ‘Toke kuda boi maimanihihia a God mu boi ghaghana bohera na komi tinoni, ");
INSERT INTO bgt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","inau kuda eia na hava na vaivine iaani ke magnahaghinia, eigna gi kuda boi hathea, kenughua iia keda vabuebuleu eigna ke mai hahali itagua me kaeu eigna kuda hathea.’” ");
INSERT INTO bgt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma a Lod ke velea iaani, “Oti toatogha toetoke eigna na hava ke eia na mane fate iaani. ");
INSERT INTO bgt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Toke imanea ke dika, imanea ke hathea na vaivine thehe sasani kori vagovugna. Na vunegna iangeni, ighamu koti adoa a God ke jino keda hathera na komi tinoni ke vahira ghohi kena kaea na haehathe hahali itagna. Ehava? A God keda poru na hatheragna? ");
INSERT INTO bgt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Teo! A God keda saisami na hatheragna. Keana, kori vido inau, na Dathei Tinoni kuda tabiru mai, inau kuda pada sa tinoni kori maramagna ke vaututuniu ba teo? ");
INSERT INTO bgt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kekeha tinoni kena vaovarongo tagna a Jisas ngengeni kena ghaghana imarea ghehedia kena jino mena ghaghana mua imarea kena nagho vano tadia na komi tinoni kori matagna a God. A Jisas ke velera na titiono velepuhi iaani: ");
INSERT INTO bgt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Rua na mane koro vano kori Vathe ke Tabu nigna a God bali tarai, sina mane na mane Farise, me sina mane, na mane bali oho takis. ");
INSERT INTO bgt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na Farise ke sokara ghehegna me tarai vaghagna iaani, ‘God inau ku veletokegho eigna inau ku boi koakoa vaghadia kekeha tinoni. Inau ku boi bilau, ghoho, ba eia na komi puhi ke dika. Mu veletokegho eigna ku boi vaghagna na mane bali oho takis iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Inau ku sota kori vanga e rua na dani leuleghu wik mu hegho atu na vasalaghegna na rongo kena voliu.’ ");
INSERT INTO bgt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Keana na mane bali oho takis ke sokara haunia na mane Farise iangeni me boi tada hadi i popo. Imanea ke dikahehegna eigna na komi koakoa ke eia me tupia na raghagna me velea iaani, ‘God o raroviu, inau na mane koakoa.’” ");
INSERT INTO bgt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Gi a Jisas ke velea, “Kori vido e rua na mane koro taveti au moro tabiru kori vathedia, na mane bali oho takis ke pukuni jino kori matagna a God, boi na mane Farise. Eigna ahai keda vahaihadia ghehegna a God keda vahorua. Keana ahai keda vahouhorua ghehegna, a God keda vahaihadia.” ");
INSERT INTO bgt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kekeha tinoni kena hatira mai na komi gari iso tagna a Jisas eigna keda vatabura. Mara na vaovarongo kena reghira mena haghore peora arahai kena hatira mai. ");
INSERT INTO bgt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kari a Jisas ke kilora mai na komi gari itagna me velera nigna na komi vaovarongo, “Oti lubatira mai na komi gari itagua moti saghoi lutira eigna na komi tinoni a God ke vunaghi pungusira, imarea vaghadia na komi gari iraani. ");
INSERT INTO bgt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","E tutuni na hava ku veleghamu, arahai kena boi vaututunia a God vaghagna na gari ke vaututunia, imarea kedana boi mono duadia na komi tinoni a God ke vunaghi pungusira.” ");
INSERT INTO bgt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sina vunaghidia mara Jiu ke mai me huatia a Jisas, “Velepuhi, ighoe ko toke. Na hava kuda eia gi kuda hatia na havi ke teo na govugna?” ");
INSERT INTO bgt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisas ke veleagna, “Ehava gi o kilou inau ku toke? A God vamua ke toke. ");
INSERT INTO bgt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ighoe ko adoa ghohi na komi vetula: Saghoi ghoho, saghoi vathehea na tinoni, saghoi bilau, saghoi vuha haghoregna ahai, mo ghaghana bohera a tamamu ma idomu.” ");
INSERT INTO bgt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Imanea ke haghore tughua a Jisas, “Velepuhi, na komi vetula iraani inau ku leghura turughu mai kori garigu.” ");
INSERT INTO bgt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","A Jisas ke rongovia iaani me ania, “Sina fata vamua ko boi eia. O vano salemua na komi fata gougovu ko tonogna, gi o hatia na rongodia mo kemulia itadia mara kena kuma. Gi koda eia iaani, ighoe koda tonogna na komi fata ke toke i popo. O vano eia iaani gi o mai leghuu inau.” ");
INSERT INTO bgt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kori vido ke rongovia iaani, imanea ke dikahehegna puala, eigna imanea na mane ke padarongo puala. ");
INSERT INTO bgt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","A Jisas ke rei vano tagna imanea me velea, “E vahotha puala tadia arahai kena pada rongo kedana haghe kori havi a God ke vunaghi pungusia. ");
INSERT INTO bgt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tangomana mua na kamel keda haghe vano kori bilogna na nili? Vahotha puala! Keana e vahotha vano mua tagna ahai ke padarongo, na haghe vano kori hughuta nigna a God!” ");
INSERT INTO bgt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Arahai kena rongovia iaani kena velea, “Keda vahotha puala na hatiagna na havi ke teo na govugna tagna na tinoni ke padarongo na bule, ahai keda tangomana na?” ");
INSERT INTO bgt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A Jisas ke haghore tughura, “Na hava ke boi tangomana na eiagna na komi tinoni, a God ke tangomana.” ");
INSERT INTO bgt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","A Pita ke veleagna a Jisas, “Reghia! Ighami kiti taveti sania nimami na komi fata miti leghugho!” ");
INSERT INTO bgt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Gi a Jisas ke velera, “Inau ku veleghamu, ahai ke taveti sania na vathegna, ba a taugna, ba ara tahigna, ba a idogna ma tamagna, ba ara dathegna eigna ke lubatia a God gi keda vunaghi pungusia na havigna, ");
INSERT INTO bgt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","imanea keda hatia sethe vano na fata kori maramagna iaani tagna na komi fata ke taveti sania. Kari kori vido ke mai na maramagna mathangani nigna a God, imanea keda hatia na havi ke teo na govugna.” ");
INSERT INTO bgt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A Jisas ke hatira salaghe rua nigna na komi vaovarongo ghehedia me velera, “Ighamu koti adoa, ikeagaieni ighita kati atu hadi i Jerusalem. Kori vido kati jufu ngengeni, na komi fata kena risoa mara na profet eigna na Dathei Tinoni, keda kathea. ");
INSERT INTO bgt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Imarea kena lubati vanoa kori limadia mara kena boi Jiu. Imarea kedana kihaghinia mena hira mena angusua. ");
INSERT INTO bgt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Imarea kedana thabuhia mena vathehea. Keana, kori vatolugna na dani imanea keda havi tabiru kori thehe.” ");
INSERT INTO bgt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nigna na komi vaovarongo kena boi thaothadoghagna na hava ke velea a Jisas. Na pukuni ghaghana ikoragna ke mono polo itadia mena hahi hehedia. ");
INSERT INTO bgt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kori vido a Jisas ke mai gharania na meleha i Jeriko, sina mane ke doa ke nohe ghaghireigna na hangana me kaekae rongo tadia arahai kena mai mena vano. ");
INSERT INTO bgt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Imanea ke rongovia na mavitu ke sethe kena halu atu kori hangana me huatira, “Na hava koti eia?” ");
INSERT INTO bgt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mi marea kena veleagna, “Jisas gna i Nasaret ke halu atu.” ");
INSERT INTO bgt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Gi imanea ke ghuu heta, “Jisas, dathegna Deved, o raroviu! ");
INSERT INTO bgt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Arahai kena taveti naghogna a Jisas kena veleagna eigna keda bughoro, keana imanea ke ghoi ghuu heta vano mua, “Jisas, dathegna Deved, o raroviu!” ");
INSERT INTO bgt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","A Jisas ke sokara soto me velera eigna kedana hatia mai itagna. Kori vido na mane ke doa ke mai gharania, a Jisas ke veleagna, ");
INSERT INTO bgt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Na hava ko magnahaghinia kuda eia vanigho?” Imanea ke ania, “Lod inau ku magnahaghinia kuda tangomana na reirei.” ");
INSERT INTO bgt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","A Jisas ke velea, “O reirei! Nimua na vaututuni ke vatokegho.” ");
INSERT INTO bgt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kori vido iangeni vamua imanea ke reirei. Imanea ke leghua a Jisas me kilothaba a God. Ma na mavitu kena reghia na hava ke eia a Jisas, imarea huju ena kilothaba a God. ");
INSERT INTO bgt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","A Jisas ke jufu kori meleha i Jeriko me taveti thovohaliu vano hotaghigna. ");
INSERT INTO bgt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Sina mane ke nagho tadia mara na oho takis ke mono ngengeni, na ahagna a Sakius. Imanea na mane padarongo. ");
INSERT INTO bgt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Imanea ke magnahaghinia puala keda reghia nigna a Jisas, kari e boi tangomana keda reghia eigna imanea ke kudo puala ma na mavitu kena sokara peotia. ");
INSERT INTO bgt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gi e raghe nagho vano tadia na mavitu me habira hadi kori sina ghai sikamo eigna keda reghia a Jisas keda taveti mai kori hangana. ");
INSERT INTO bgt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","A Jisas ke mai jufu saragna na ghai me tada hadi me reghia a Sakius me ania, “Sakius o horu mai saisami eigna inau kuda atu kori vathemu ikeagaieni.” ");
INSERT INTO bgt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A Sakius ke horu saisami me hati vanoa kori vathegna me totogo puala. ");
INSERT INTO bgt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na mavitu kena reghia iaani mena dikatadia mena velea, “Reghia! Imanea ke vano me mono kori vathegna na mane koakoa.” ");
INSERT INTO bgt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A Sakius ke sokara hadi me veleagna a Jisas, “Lod, inau kuda hera mara kena kuma na thevugna komi nigua na fata. Ma arahai ku pilaunira bali hatia nidia na rongo, inau kuda vati horui tughu tabiruagna.” ");
INSERT INTO bgt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma a Jisas ke velea, “Ikeagaieni a God ke vahavigho ma arahai kena mono kori vathemu, eigna ighoe ko vaututuni vaghagna a Ebraham ke vaututuni. ");
INSERT INTO bgt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Inau, na Dathei Tinoni, ku mai bali hirora arahai kena jefe eigna kuda vahavira.” ");
INSERT INTO bgt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na mavitu kena rongovia na komi titiono ke titionoa a Jisas. Imarea kena toatogha kori vido a Jisas keda jufungia i Jerusalem, a God keda turughu vunaghi pungusia nigna na mavitu. Na vunegna imarea kena mono gharania ghohi i Jerusalem, a Jisas ke eia sina titiono velepuhi eigna keda vajinoa na ghaghanadia. ");
INSERT INTO bgt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mi manea velera, “Sina mane puhi ke kaikaliti bali vano tagna sina meleha ke hau eigna na king ngengeni keda hea na mana eigna keda vunaghi pungusia na melehagna ghehegna. Gi imanea keda tabiru mai. ");
INSERT INTO bgt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Gi e taveti au, imanea ke kilora salaghe nigna na mane agutu me hera soasopa na rongo me velera, “Oti nia agutu na komi rongo iaani eigna keda sethe kori vido ku ghoi tabiru mai.” Mi imanea ke taveti au. ");
INSERT INTO bgt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kari na mavitu kori melehagna kena boi magnahaghinia keda vunaghi pungusira, mena vetula vanoa kekeha tinoni tagna na king eigna kedana vano veleagna, ‘Ighami kiti bosi magnahaghinia na mane iaani keda vunaghi pungusighami.’ ");
INSERT INTO bgt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Keda ai huju, na king ke hea na mana eigna keda vunaghi pungusira. Gi imanea ke tabiru mai kori melehagna. Kori tabirugna mai, imanea ke kilora mai itagna mara nigna na mane agutu ke hera na rongo, eigna keda adoa engiha na rongo ke vusu tagna na rongo ke hera. ");
INSERT INTO bgt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Na mane ke kidi mai ke velea, ‘Vunaghi, inau ku hatia salaghe na rongo mua tagna na rongo ko heu.’ ");
INSERT INTO bgt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ma na vunaghi iangeni ke ania, Toke puala, ighoe na mane agutu toke. Na vunegna na puhimu ke toke kori reireghiagna na komi fata ke iso, ikeagaieni inau ku lubatia vanigho eigna koda reireghia e salaghe na meleha.’ ");
INSERT INTO bgt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ma na varuai mane agutu ke mai me ania, ‘Vunaghi, inau ku hatia e lima na rongo mua tagna na rongo ko heu.’ ");
INSERT INTO bgt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ma na vunaghi ke ania, ‘Toke puala, ighoe koda reireghia e lima na meleha.’ ");
INSERT INTO bgt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Leghugna iaani na vatolugna na mane agutu ke mai me ania, “Vunaghi, iaani na nimua na rongo ko heu mai. Inau ku filehia kori pohe mu poloa. ");
INSERT INTO bgt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Inau ku mataghunigho eigna ighoe sina mane e vahotha puala na vatotogoghogna. Ighoe ko ado ohoa na rongo ke mai tagna na agutu kena eia nimua na komi mane agutu. Mo eia mua vaghagna iangeni kori na hava kena joua.’ ");
INSERT INTO bgt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Na vunaghigna ke velea, ‘Ighoe na mane agutu dika! Inau kuda fategho leghuagna na komi haghore ko eia. Gi ighoe ko adoa inau sina mane ke vahotha na vatotogou mu ado ohoa na rongo ke mai tagna na agutu kena eia nigua na komi mane agutu, ");
INSERT INTO bgt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ehava gi o boi boa nigua na rongo kori vathe bali bobo rongo eigna keda vusu gi u tabiru mai mu hatia?’ ");
INSERT INTO bgt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ma na vunaghi ke velera arahai kena sokara ngengeni, ‘Oti hati aua na rongo ke mono itagna moti hea vanoa tagna na mane ke hatia e salaghe na rongo.’ ");
INSERT INTO bgt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Mi marea kena haghore tughua, ‘Vunaghi, imanea ke hatia ghohi e salaghe na rongo!’ ");
INSERT INTO bgt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ma na vunaghi ke velera, ‘Gi ahai ke agutu tokea tagna na hava ku hea, inau kuda hea sethe mua na komi fata. Kari ahai ke boi agutu tokea tagna na hava ku hea, toke ke boi sethe nigna na komi fata, inau kuda hatia au itagna. ");
INSERT INTO bgt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mi ikeagaieni, oti hatira mai nigua na komi thevuioka kena boi magnahaghiniu kuda vunaghi pungusira, moti thabuhe vathehera gougovu i naghogu.’” ");
INSERT INTO bgt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kori vido a Jisas ke govu na titionoagna iangeni, imanea ke talu taveti hadi vano i Jerusalem duagna nigna na komi vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Imarea kena mai gharania e rua na meleha i Betfage mi Betani tagna na Suasupa i Ghai Olev. Gi imanea ke vetulara vano e rua nigna na mane vaovarongo me anira, ");
INSERT INTO bgt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Oro vano kori meleha kati reghi vanoa iangeni. Kori vido koroda jufu vano ngengeni, roghamu koroda reghia sina dongki mathangani kena pinitia. Na dongki iangeni, teo ahai ke taetaveti mua itagna. Oro unuhia moro hati maia itagua. ");
INSERT INTO bgt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Gi ahai keda huatighamu na vunegna koro unuhiagna, oro veleagna, “A Lod ke magnahaghinia.” ");
INSERT INTO bgt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Romara koro vano moro reghia na dongki mathangani vaghagna vamua ke veleragna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kori vido romara koro unuhia na dongki, na komi tinoni kena tonogna kena anira, “Romara, bali hava romiu koro unuhiagna?” ");
INSERT INTO bgt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Romara koro velera, “A Lod ke magnahaghinia.” ");
INSERT INTO bgt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Gi romara koro hatia moro vano tagna a Jisas moro valiagna rodia na oopo moro vasopoua a Jisas popogna na dongki. ");
INSERT INTO bgt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ma a Jisas ke taveti vano i Jerusalem ma na komi tinoni kena valia nidia na komi oopo kori hangana. ");
INSERT INTO bgt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kori vido kena gharania i Jerusalem, tagna ke horu vano na hangana kori Suasupa i Ghai Olev, sethe nigna na komi vaovarongo kena turughu ngingili mena kilothaba a God duai totogo eidia na komi reghithehe kena reghia. ");
INSERT INTO bgt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Imarea kena velea, “God ko vathaba na king ke mai duagna nimua na mana! Na soleana keda mono i popo. Ighita kati kilothaba a God ke thaba haluhadi puala!” ");
INSERT INTO bgt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kekeha mara na Farise kena mono ingengeni kena veleagna a Jisas, “Velepuhi, o velera nimua na komi vaovarongo eigna kedana mono bughoro!” ");
INSERT INTO bgt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A Jisas ke haghore tughura, “Inau ku veleghamu, gi kedana mono bughoro imarea iraani, na komi ghahira kedana kilothaba a God!” ");
INSERT INTO bgt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","A Jisas ke mai gharania i Jerusalem me reghi vanoa me tangi, eigna ke dikahehegna puala eidia na komi tinoni kena mono ngengeni. ");
INSERT INTO bgt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Gi e velea iaani, “E toke puala kotida adoa na hava keda hatheghamu kori mono haidu duagna a God. Kari ikeagaieni a God ke poloa itamiu. ");
INSERT INTO bgt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kori maghavu keda mai, nimiu na thevuioka kedana mai rihughamu. Imarea kedana bokua na thepa ma na ghahira me hadi kori hidigna na melehamiu eigna kedana haghe koragna. Mi marea kedana mono kilivia na melehamiu eigna kotida boi tangomana na ghogho. ");
INSERT INTO bgt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Imarea kedana vatheheghamu mena diadikala na komi fata kori melehamiu. Teo sikei ghahira keda mono tagna ke mono ikeagaieni kori vathemiu. Iaani keda padaghamu eigna ighamu koti boi ghithatha na maghavu a God ke mai bali vahavighamu.” ");
INSERT INTO bgt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas ke jufungia i Jerusalem me vano haghe kori Vathe ke Tabu nigna a God. Imanea ke gigi aura na komi tinoni kena salemua na komi fata ikoragna. ");
INSERT INTO bgt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Imanea ke velera, “Tadia na komi Rioriso ke Tabu, a God ke velea, ‘Nigua na Vathe ke Tabu na vathe bali tarai.’ Keana ighamu koti eia vaghagna na vido bali monodia mara kena biabilau.” ");
INSERT INTO bgt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Leuleghu dani a Jisas ke velepuhira na mavitu koragna na Vathe ke Tabu. Mara na naghoi pris mi mara na velepuhigna na vetula nigna a Moses, mi kekeha mara puhidia mara Jiu, kena hiohiroa na puhi kedana vathehea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kari imarea kena boi tangomana nidia na toghagna sa puhi, eigna sethe na tinoni kena magnahaghinia puala na vaovarongo itagna mena mono duagna leuleghu dani. ");
INSERT INTO bgt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sina dani a Jisas ke velepuhira na mavitu kori Vathe ke Tabu nigna a God me tuturi aua itadia na Rorongo ke Toke. Mara na naghoi pris mi mara na velepuhigna na vetula nigna a Moses mi kekeha mara puhi kena mai tagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Imarea kena huatia vaghagna iaani, “O veleghami, ahai ke velegho na gigi auragna na komi tinoni kori na Vathe ke Tabu? Ahai ke hegho na mana gi o eia na komi fata iraani?” ");
INSERT INTO bgt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ma a Jisas ke anira, “Inau kuda kidi huatighamu sina huahuati. Oti veleugna, ");
INSERT INTO bgt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ahai ke hea na mana a Jon Siuvitabu eigna keda siuvitabura na mavitu? A God ba na tinoni vamua?” ");
INSERT INTO bgt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Imarea kena titiono varihotaghidia vaghagna iaani, “Gi ighita katida velea a God ke hea na mana, imanea keda veleghita, ‘Ehava koti boi vaututunia na komi velepuhi nigna a Jon na?’ ");
INSERT INTO bgt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Keana, gi katida veleagna na tinoni ke hea na mana, kenughua na komi tinoni kedana piri vatheheghita kori ghahira, eigna imarea kena vaututuni a Jon sina nigna profet a God.” ");
INSERT INTO bgt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Na vunegna iangeni, imarea kena veleagna, “Ighami iti boi adoa ahai ke hea na mana.” ");
INSERT INTO bgt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma a Jisas ke anira, “Na vunegna koti boi haghore tughuu, inau kuda boi veleghamu ahai ke heu na mana gi u eia na komi fata iraani.” ");
INSERT INTO bgt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Gi a Jisas ke velera na titiono velepuhi iaani: “Sina mane ke joua na komi ghai grep kori nigna na gnatha, me hirora kekeha tinoni eigna kedana agutu mena reireghia nigna na gnatha. Imanea ke velera eigna kedana hatia kekeha sagharogna na ghai grep eigna na volidia. Leghugna iaani, imanea ke taveti au me vano mono hau tagna sina meleha tavogha. ");
INSERT INTO bgt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kori vido ke jufungia na maghavu ke ghano na komi grep, imanea ke vetula nigna na mane agutu eigna keda ohoa maia itagna kekeha ghagna na sagharogna kena vihukira. Kori vido imanea ke jufu itadia mara kena reireghia na gnatha, imarea kena tupia mena vetula tabirua vavaha vamua tagna na vunaghigna. ");
INSERT INTO bgt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Leghugna iaani, na mane ke tonogna na gnatha ke ghoi vetula sina nigna na mane agutu. Imarea kena tupia mena pukuni diadikala mena vetula tabirua vavaha. ");
INSERT INTO bgt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mi manea ke vetula na vatolugna na nigna na mane agutu mena vangesoa me soni aua kosigna na gnatha. ");
INSERT INTO bgt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Gi na mane ke tonogna na gnatha ke toatogha vaghagna iaani, ‘Na hava kuda eia? Inau kuda vetula vanoa vamua a pukuni dathegu ku dothovia puala. Da imarea kedana ghaghana bohea a dathegu.’ ");
INSERT INTO bgt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Keana, kori vido kena reireghia na gnatha kena reghia a dathegna, imarea kena velea varihotaghidia, ‘Iaani na mane keda tonogna na gnatha leghugna ke thehe a tamagna. Gi katida vathehea, ighita katida tonogna na gnatha.’ ");
INSERT INTO bgt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mi marea kena thotia mena hati aua kosigna na gnatha mena thabu vathehea.” Ma a Jisas ke velera na komi tinoni, “Na hava keda eia na mane ke tonogna na gnatha tadia mara kena reireghia vania na? ");
INSERT INTO bgt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Imanea keda vano me vathehera na komi tinoni ke dika iangeni me hera vano mara tavogha nigna na gnatha eigna kedana reireghia vania.” Kori vido imarea kena rongovia iaani, imarea kena velea, “Teo! Boi tangomana keda ai!” ");
INSERT INTO bgt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ma a Jisas ke buta vano itadia me anira, “Gi keda boi ai na, na hava na ghaghana ikoragna na komi Rioriso ke Tabu kena velea, ‘Na ghahira kena boi magnahaghinia mara kena agutu vathe, ikeagaieni na ghahira iaani na naghoi ghahira tadia na komi ghahira kori hidigna na vathe.’ ");
INSERT INTO bgt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ahai keda pejuraghi tagna na ghahira iangeni, imanea keda purungongojo, ma ahai na ghahira iangeni keda sikili popogna, imanea keda baka.” ");
INSERT INTO bgt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kori vido iangeni mara na velepuhigna na vetula nigna a Moses mi mara na naghoi pris kena magnahaghinia kedana thotia a Jisas. Eigna kena adoa na titiono velepuhi iaani eidia imarea (imarea na komi tinoni dika kena reireghia na gnatha). Keana imarea kena boi thotia eigna kena mataghunira na mavitu. ");
INSERT INTO bgt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mara kena nagho tadia mara Jiu kena kaekalea a Jisas eigna kedana reghipada sa puhi bali thotia. Imarea kena vetula vanoa tagna a Jisas kekeha tinoni kena eia vaghagna imarea kena mono jino, keana imarea kena dika. Imarea kena magnahaghinia a Jisas keda velea sa fata ke boi jino eigna kedana hati vanoa tagna na vunaghigna na provins bali fatea. ");
INSERT INTO bgt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Imarea kena huatia, “Velepuhi, ighami kiti adoa ighoe ko velepuhi na hava ke tutuni. Ighoe ko boi tughua na hava ko velepuhi leghuagna arahai kena vaovarongo itamua. Teo, ighoe ko velepuhi vamua na hava ke tutuni eigna na puhi a God ke magnahaghinia na komi tinoni kedana leghua. ");
INSERT INTO bgt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","O veleghami, kori nida na vetula e toke vamua katida volia na takis tagna na King gna i Rom ba teo?” ");
INSERT INTO bgt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","A Jisas ke adoa imarea kena haga pilaunia me velera, ");
INSERT INTO bgt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Oti tateli vaniu mai sikei na sileni. Oti veleu, ahai na totoghalegna ma na ahagna ke mono itagna?” Imarea kena haghore tughua, “Na King gna i Rom.” ");
INSERT INTO bgt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma a Jisas ke velera, “Oti hea na King gna i Rom na hava ke tonogna, moti hea a God na hava ke tonogna.” ");
INSERT INTO bgt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mi marea kena mono bughoro eigna kena vere nidia puala kori nigna na haghore tughu. Imarea kena boi tangomana nidia na pilauniagna eigna keda velea sa fata ke boi jino kori matadia na mavitu. ");
INSERT INTO bgt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Leghugna iaani, kekeha mara na Sadiusi kena mai tagna a Jisas. Imarea kena boi vaututunia na komi tinoni kedana havi tabiru leghugna na thehe. ");
INSERT INTO bgt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Imarea kena velea, “Velepuhi, a Moses ke risoa gi na mane keda thehe sania a taugna me teo mua sa dathegna, a tahigna keda taulaghi itagna na vaivine ke thehe a taugna eigna keda boa na gari itagna bali vavusua na pagusugna a toghagna ke thehe. ");
INSERT INTO bgt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Vaghagna iaani, “Mara e vitu tamatahi kena mono, ma na mane ke havi nagho ke taulaghi tagna sina vaivine, kari e teo mua sa dathegna me thehe. ");
INSERT INTO bgt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A tahigna imanea ke taulaghi tagna na vaivine iangeni, me teo mua sa dathegna me thehe. ");
INSERT INTO bgt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ma na vatolugna tadia mara tamatahi ke taulaghi tagna me nanaba vamua. Vano me mara e vitu tamatahi gougovu kena taulaghi tagna na vaivine iangeni. Me teo sikei mane itadia ke boa sa gari tagna na vaivine iangeni mena thehe gougovu. ");
INSERT INTO bgt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Vagovugna, na vaivine ke thehe. ");
INSERT INTO bgt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","O veleghami, kori vido a God keda vasokara tabirura arahai kena thehe, ahai tadia mara tamatahi irangeni keda taugna na vaivine iangeni, eigna mara vitu tamatahi gougovu kena taulagi tagna?” ");
INSERT INTO bgt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma a Jisas ke haghore tughura, “Kori maramagna iaani, mara mane ma na koi vaivine kena taulaghi. ");
INSERT INTO bgt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kari arahai a God ke velera kena nabadia gi kedana havi tabiru kori thehe mena mono kori na maramagna mathangani, imarea kedana boi taulaghi, ");
INSERT INTO bgt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","me kedana boi thehe eigna imarea kedana vaghadia na komi enjel. Imarea ara dathegna a God, eigna imanea ke vasokara tabirura kori thehe. ");
INSERT INTO bgt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses ke tatelia vanighita arahai kena thehe kedana ghoi havi tabiru. Kori titionogna a Moses ma na ghai iso ke beubethu na eloelogna, a Moses ke kiloagna a Lod God ‘a God na nidia a Ebraham, a Aisak ma a Jekob.’ ");
INSERT INTO bgt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A God iangeni, boi a God nidia arahai kena thehe ghohi, kari a God nidia arahai kena havi. Toke tolumara kotolu thehe ghohi i hau, tagna a God tolumara kotolu talu havi mua. Eigna tagna a God, na komi tinoni gougovu kena havi.” ");
INSERT INTO bgt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kekeha mara na velepuhigna na vetula nigna a Moses ke velea, “Vunaghi, nimua na haghore tughu e toke puala.” ");
INSERT INTO bgt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Leghugna iaani, teo mua sa tinoni ke mathaghai na huatiagna. ");
INSERT INTO bgt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ma a Jisas ke huatira, “Ehava gi ena velea a Vahavi na vinahuhugna vamua a King Deved? ");
INSERT INTO bgt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kori na buka Psalm a Deved ke velea, ‘A God ke velea tagna a vunaghigu, O nohe mai kori thevu madothogu ");
INSERT INTO bgt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","me jufu kori maghavu kuda talu horua nimua na thevuioka i thepa eigna koda vunaghi pungusira.’ ");
INSERT INTO bgt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Deved ke kiloagna a Vahavi na vunaghigna. Gi imanea na vunaghigna a Deved, ehava gi imanea na vinahuhugna a Deved mua?” ");
INSERT INTO bgt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kori vido na mavitu kena rorongo mai, a Jisas ke velera nigna na komi vaovarongo, ");
INSERT INTO bgt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Oti saghoi leghua na puhidia mara na velepuhigna na vetula nigna a Moses! Imarea kena magnahaghinia na vahagheagna nidia na poko ke tabu mena vano kori makete eigna kena magnahaghinia vamua na mavitu kedana ghithathara mena ghaghana bohera. Kori vido kena vano haghe tadia na komi vathe haidu ba kena vano kori vangahaidu, imarea kena magnahaghinia kedana nohe tadia na komi nagho i sape. ");
INSERT INTO bgt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Imarea kena pilaunira mena hatia nidia na komi fata na koi vaivine thehe sasani. Imarea kena tarai teve eigna kena magnahaghinia vamua na mavitu kedana ghaghana imarea kena tabu puala. Mara iraani, a God keda pukuni vaparara puala!” ");
INSERT INTO bgt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kori vido a Jisas ke talu mono mua kori na Vathe ke Tabu, imanea ke dodoro vano me reghira kekeha mara kena padarongo kena sosoni tagna na bali sosoni rongo. ");
INSERT INTO bgt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Gi imanea ke reghia sina vaivine thehe sasani ke kuma ke mai me soni haghea e rua na sileni vamua. ");
INSERT INTO bgt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma a Jisas ke velea, “E tutuni na hava ku veleghamu, na vaivine kuma iaani e sethe vano na rongo ke sonia tadia mara kena padarongo. ");
INSERT INTO bgt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Eigna imarea kena sonia vamua na rongo ke tomagha tadia. Keana na vaivine iaani e soni govua na ghathi rongo ke tonogna me teo sa nigna rongo ke tomagha keda voli ghagna vanga.” ");
INSERT INTO bgt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kekeha nigna na vaovarongo a Jisas kena titiono eigna na komi ghahira ke ulaghagna tadia na komi hidigna na Vathe ke Tabu. Mena titiono mua eigna na komi fata na komi tinoni kena hea vania a God bali gnilauagna. Ma a Jisas ke velera, ");
INSERT INTO bgt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Na komi fata koti reghia iaani, tagna na dani keda mai, teo sikei ghahira keda mono kori mathagna vaghagna kena mono ikeagaieni. Imarea kedana reo horua na komi hidigna gougovu.” ");
INSERT INTO bgt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nigna na komi vaovarongo a Jisas kena huatia, “Velepuhi, ingiha kedana reo horua na Vathe ke Tabu nigna a God iangeni? Na hava na vaughithatha kitida reghia gi iti adoa na maghavu iangeni ke jufu mai ghohi?” ");
INSERT INTO bgt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma a Jisas ke anira, “Oti reireghi toke ghamu, kenughua e pilaunighamu sa tinoni. Eigna sethe na tinoni kedana mai mena velea, ‘Inau a Vahavi.’ Imarea kedana velea ghua, ‘Na vagovugna na maramagna ke gharani mai ghohi.’ Oti saghoi vaututunira. ");
INSERT INTO bgt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kori vido kotida rongovia na rorongogna na komi rihu hutu, oti saghoi mataghu. Na komi rihu iraani kedana mai, kari e boi na vagovugna na maramagna mua.” ");
INSERT INTO bgt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","A Jisas ke ghoi anira, “Sethe na meleha kori maramagna kedana veiriurihughi. ");
INSERT INTO bgt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Sethe na meleha kori maramagna na agnu keda agnu ma na komi vahaghi hutu keda padara na komi tinoni me sethe na tinoni kedana thehe eigna ke teo sa ghadia vanga. Sethe na vaughithatha ke hutu keda tate mai kori maaloa ma na komi tinoni kedana mono mamataghu. ");
INSERT INTO bgt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Gi e jufu mai na komi fata iraani, na komi tinoni kedana thotighamu mena vaparaghamu. Imarea kedana hatighamu vano tadia na komi vathe haidu me kedana fateghamu mena sonighamu haghe kori vathe tatari. Imarea kedana hatighamu vano tadia na komi king ma na koi vunaghi me kedana fateghamu eigna ighamu koti leghuu inau. ");
INSERT INTO bgt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kori vido iangeni, ighamu tangomana kotida tuturia vanira eigu inau. ");
INSERT INTO bgt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gi ena fateghamu, oti saghoi toatogha puala eigna na hava kotida veleragna eigna kedana adoa ighamu koti boi ei hahia sa fata. ");
INSERT INTO bgt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Eigna inau kuda heghamu na haghore thaothadogha, me teo ahai ke thevuioka itamiu keda tangomana na haghore tughughamugna. ");
INSERT INTO bgt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kenughua ara tamamiu, ma ara idomiu, ma ara tahimiu, ma ara vikemiu, ma ara kulamiu kedana lubatighamu vano kori limadia mara nimiu na thevuioka. Me kedana vathehera kekeha itamiu. ");
INSERT INTO bgt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na komi tinoni gougovu kedana siriuhaghinighamu na vunegna ighamu koti leghuu inau. ");
INSERT INTO bgt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Keana, teo sikei sesehugna na ulumiu keda dika thovohaliu. ");
INSERT INTO bgt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","“Gi kotida sokara ngasi kori nimiu na vaututuni, ighamu kotida hatia na havi ke teo na govugna.” ");
INSERT INTO bgt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ma a Jisas ke ghoi velera, “Kori vido koti reghira na komi soldia kedana mai sokara kililia i Jerusalem, ighamu kotida adoa na maghavu imarea kedana reoa na meleha iangeni e jufu mai ghohi. ");
INSERT INTO bgt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Gi kotida mono kori provins i Jiudea, oti ghogho hadi tadia na komi suasupa. Gi kotida mono i Jerusalem, oti ghogho sania. Gi kotida mono kosigna, oti saghoi tabiru itagna. ");
INSERT INTO bgt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Eigna iangeni na maghavu a God keda vaparara na komi tinoni kori meleha iangeni, ma na komi fata kena riso horua na komi profet keda jufu mai. ");
INSERT INTO bgt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Na maghavu iangeni keda dika eidia na koi vaivine kena gharani vahua a dathedia ma arahai kena susuua mua a dathedia eigna kenughua e vahotha puala na ghoghodia. Na papara hutu keda kathea na meleha i Israel eigna a God keda dikatagna itadia mara Jiu. ");
INSERT INTO bgt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kekeha kedana thabu vathehera kori ghau, kekeha kedana thotira mena hatira vano tadia na komi meleha tavogha bali agutu vanira. Arahai kena boi Jiu kedana diadikala na meleha i Jerusalem me ghieghilei govu nidia na maghavu.” ");
INSERT INTO bgt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Gi a Jisas ke velera, “Sethe na fata tavogha keda tate mai kori maaloa-na komi vaughithatha kori na aho, na vula, ma na komi vaitughu. Na komi tinoni kena mono tadia na komi meleha kori maramagna kedana mataghu na rongoviagna na gnoro hutu kori tahi. Imarea kedana boi adoa na hava kedana eia. ");
INSERT INTO bgt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sethe na tinoni kedana thehehaihavi eigna kena mataghunia na komi fata keda mai bali diadikala na maramagna, eigna na komi fata kori maaloa kedana ghaighali. ");
INSERT INTO bgt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Gi na komi tinoni kedana reghia na Dathei Tinoni keda tabiru mai kori parako duagna na mana ma na silada ke hutu. ");
INSERT INTO bgt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kori vido na komi fata iraani kena turughu tate mai, oti sokara ngasi moti tada hadi, eigna na maghavu a God keda vahavighamu ke gharani mai ghohi.” ");
INSERT INTO bgt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","A Jisas ke titionoa na titiono velepuhi iaani, “Oti toatogha vanoa na ghai fig ba kekeha ghai tavogha. ");
INSERT INTO bgt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kori vido ighamu koti reghia na komi elolodia ke turughu vusu, ighamu koti adoa e boi hau gi mono na sagharodia. ");
INSERT INTO bgt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Vaghagna mua iangeni, kori vido na komi papara iraani keda jufu mai, ighamu kotida adoa na maghavu a God keda vunaghi pungusia na maramagna ke gharani mai ghohi. ");
INSERT INTO bgt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Inau ku veleghamu na fata ke tutuni: Na komi fata iraani keda kidi jufu mai gi na komi tinoni gougovu kena mono ikeagaieni kedana thehe. ");
INSERT INTO bgt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Na maaloa ma na thepa keda govu, keana nigua na komi haghore keda boi govu. ");
INSERT INTO bgt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Oti reireghi toke ghamu! E boi toke gi na ghaghanamiu keda rugusi tagna na komi fata kori maramagna. Saghoi kou memee ba eia na komi fata ke dika kena ado eia mara kena kou, moti saghoi toatogha hahalia na komi fata koti magnahaghinia kori havimiu leuleghu dani. Gi kotida eia iangeni, ighamu kotida peperiki kori dani inau kuda tabiru mai vaghagna na fata kaukagu ke peperiki kori vido ke hogho kori piti. ");
INSERT INTO bgt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Oti mono kaikaliti eigna na dani iangeni keda jufu mai tadia na komi tinoni ivei mi vei kori maramagna. ");
INSERT INTO bgt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Oti mono kaikaliti moti tarai eigna kotida talu havi me ghieghilei govu na komi papara kedana jufu mai. Moti tarai mua eigna kotida boi maomamo kori vido ighamu koti sokara naghogna na Dathei Tinoni.” ");
INSERT INTO bgt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Leuleghu dani a Jisas ke velepuhira na komi tinoni kori Vathe ke Tabu nigna a God mi kori lavi imanea ke taveti vano kori Suasupa i Ghai Olev me nere ngengeni. ");
INSERT INTO bgt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Leuleghu vueveghi puni na komi tinoni kena haidu mai kori Vathe ke Tabu mena vaovarongo kori nigna na velepuhi a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na Laulahugna na Bred ke Teo na Isi Koragna, kena kiloagna mua na Laulahugna na Thovoliungi ke gharani ghohi. ");
INSERT INTO bgt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mara na naghoi pris mi mara na velepuhigna na vetula nigna a Moses kena hiohiroa puhi eigna kedana vathehea a Jisas kori puhi kedana boi adoa na mavitu. Imarea kena mataghunira na mavitu kedana rihura gi kedana thotia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","A Satan ke agutu kori ghaghanagna a Jiudas Iskariot, imanea sikei tadia e salaghe rua nigna na komi vaovarongo a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ma a Jiudas ke vano tadia mara na naghoi pris ma arahai kena nagho tadia na komi soldia kena kaekalea na Vathe ke Tabu nigna a God me titiono duadia eigna na puhi imanea keda peroa a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Imarea kena totogo puala na rongoviagna a Jiudas keda hathera, mena veleagna gi kedana hea na rongo. ");
INSERT INTO bgt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","A Jiudas ke hiira me pitua na maghavu ke toke keda lubatia a Jisas vanira. Imanea ke magnahaghinia na eiagna kori vido na mavitu kena boi mono duagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na Laulahugna na Bred ke Teo na Isi Koragna ke jufu mai ghohi. Kori dani iangeni imarea kedana vathehea na komi sip mathangani bali vanga kori na Laulahugna na Thovoliungi. ");
INSERT INTO bgt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","A Jisas ke kilora mai a Pita ma Jon me anira, “Oro vano moro kaikalitia ghada na vanga bali vanga kori Laulahugna na Thovoliungi.” ");
INSERT INTO bgt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Romara koro velea, “Ivei ko magnahaghinia kuruda vano muru kaikalitia na?” ");
INSERT INTO bgt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A Jisas ke velera, “Kori vido koroda jufu i Jerusalem, roghamu koroda pada sina mane ke hulungia na botolo bea. Oro leghua moro vano kori vathe keda vano haghe. ");
INSERT INTO bgt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Moro veleagna na mane ke tonogna na vathe, ‘Na Velepuhi ke magnahaghinia na adoagna ivei na chogho keda vanga na Laulahugna na Thovoliungi duagna nigna na komi vaovarongo?’ ");
INSERT INTO bgt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Imanea keda hatighamu hadi eigna kotida reghia na chogho hutu ke kaikaliti govu ghohi na komi fata. Ngengeni koroda kaikalitia na vanga.” ");
INSERT INTO bgt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Romara koro vano moro reghia na komi fata ke vaghagna vamua ke kidi veleragna ghohi a Jisas. Moro kaikalitia na vanga ngengeni. ");
INSERT INTO bgt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kori vido ke jufu mai na bali vanga, a Jisas ma na nigna na komi vaovarongo kena nohe tagna na vido bali vanga. ");
INSERT INTO bgt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A Jisas ke velera, “Inau ku magnahaghinia puala kuda vanga duamiu na vangagna na Thovoliungi iaani gi u papara. ");
INSERT INTO bgt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Eigna inau ku veleghamu, inau kuda boi ghoi vanga duamiu na vangagna na Thovoliungi me ghieghilei jufu mai na maghavu a God keda vahavira nigna na mavitu kori vido ke vunaghi pungusia na maramagna. Tagna na maghavu iangeni na pukuni ghaghanagna na Thovoliungi keda tate mai.” ");
INSERT INTO bgt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Gi e hatia na hinao me veletokea a God me anira, “Oti hatia moti kouvi gougovua iaani varihotaghimiu. ");
INSERT INTO bgt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Inau ku veleghamu, inau kuda boi ghoi kouvia na waen me ghieghilei jufungia na maghavu a God ke vunaghi pungusira nigna na mavitu.” ");
INSERT INTO bgt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Gi e tangolia na bred me veletokea a God. Govu, gi e vidoa me hera nigna na komi vaovarongo me anira, “Iaani na tonogu bali eimiu ghamu. Oti eia iaani bali togha tabiru inau.” ");
INSERT INTO bgt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Leghugna kena govu na vanga, a Jisas ke ghoi hatia na hinao me anira, “Na waen iaani, na taluhaghore haehathe ke mathangani a God ke hera na komi tinoni. Na ghaughabuagu iaani keda kaputi ngasia na taluhaghore iangeni kori vido keda lulu bali vahavighamu. ");
INSERT INTO bgt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Reghia! Na mane keda lubatiu vano tadia mara nigua na thevuioka ke nohe duada ikeagaieni. ");
INSERT INTO bgt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Na Dathei Tinoni keda thehe leghuagna na vanohehegna a God. Keana a God keda pukuni vapara na mane keda peroa.” ");
INSERT INTO bgt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mara na vaovarongo kena huahuati varihotaghidia ahai itadia keda eia iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mara na vaovarongo kena riurihu varihotaghidia eigna ahai ke pukuni nagho itadia. ");
INSERT INTO bgt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma a Jisas ke anira, “Na komi king kori maramagna iaani kena hurura na mavitu eigna kedana eia na hava kena magnahaghinia. Toke na komi tinoni kena papara, mara kena vunaghi pungusira iraani, imarea kena velea kena hathera. ");
INSERT INTO bgt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Keana oti saghoi eia vaghagna iangeni. Gi ahai ke nagho itamiu, imanea keda mono taluleghu vaghagna na mane mathangani itadia mara puhi. Ma ahai ke baubatu itamiu, imanea keda vaghagna na mane agutu. ");
INSERT INTO bgt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kori ghaghanamiu, ahai ke nagho na? Ahai ke nohe kori tevo me vanga ba ahai ke agutu vania? Kori ghaghanamiu, imanea ke nohe kori tevo ke nagho, keana inau ku mono duamiu vaghagna nimiu na mane agutu. ");
INSERT INTO bgt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ighamu koti sokara ngasi duagu ghohi kori vido kekeha tinoni kena sokara pungusiu. ");
INSERT INTO bgt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Vaghagna a Tamagu ke heu na mana bali vunaghi pungusira na komi tinoni, inau kuda heghamu mua ");
INSERT INTO bgt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","eigna kotida vanga moti kou duagu kori nigua na hughuta. Ighamu kotida nohe tadia na komi sapei vunaghi mo kotida vunaghi pungusira e salaghe rua na vikegna i Israel.” ");
INSERT INTO bgt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas ke veleagna a Saimon Pita, “Saimon, Saimon, a Satan ke kaea a God eigna keda lubatia na pipilighamugna bali adoa nimiu na vaututuni ke heta ba teo. ");
INSERT INTO bgt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Keana inau ku tarai eimu ighoe, a Saimon, eigna nimua na vaututuni keda boi luvu. Kori vido koda ghoi piliu mai itagua, o hathera nigua na komi vaovarongo eigna keda heta nidia na vaututuni.” ");
INSERT INTO bgt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","A Pita ke haghore tughua, “Lod, inau ku kaikaliti bali vano kori vathe tatari duamu, ma na bali thehe duamu.” ");
INSERT INTO bgt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma a Jisas ke velea, “Inau ku velegho Pita, ighoe koda tolu horui veleagna ko boi adou gi e tangi na kokorako kori vuevughei puni.” ");
INSERT INTO bgt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Gi a Jisas ke huatira nigna na komi vaovarongo, “Kori vido ku vetulaghamu au i hau mu veleghamu eigna kotida saghoi ohoa sa rongo ba sa ngoi ba varuai na sadol, ehava? E kudo vanighamu sa fata?” Imarea kena ania, “Teo.” ");
INSERT INTO bgt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Imanea ke velera, “Keana ikeagaieni oti ohoa nimiu na rongo ma nimiu na ngoi. Gi ahai itamiu ke teo sa ghau bali rihu, imanea keda salemua nigna na oopo me volia sikei nigna ghau. ");
INSERT INTO bgt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Oti eia iaani eigna na komi Rioriso ke Tabu kena velea eigu inau, ‘Na komi tinoni kena velea imanea ke jotha duadia mara kena geogeno.’ Na komi fata mara na profet i hau kena riso horua eigu inau keda pukuni tate mai.” ");
INSERT INTO bgt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma na nigna na komi vaovarongo kena velea, “Reghia, Lod, e rua na ghau bali rihu ke mono ghohi itada!” Imanea ke haghore tughura, “E naba ghohi na haghore iaani!” ");
INSERT INTO bgt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A Jisas ke taveti au kori vathe me vano kori Suasupa i Ghai Olev vaghagna ke ado ei hahalia. Nigna na komi vaovarongo kena vano duagna. ");
INSERT INTO bgt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kori vido kena jufu ngengeni, a Jisas ke anira, “Oti tarai eigna kotida boi sikili kori vido na auau keda mai itamiu.” ");
INSERT INTO bgt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Gi e taveti sanira vano sina vido. Imanea ke torongaghi tuturu horu me tarai vaghagna iaani, ");
INSERT INTO bgt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mama, gi keda leghua nimua na vanohehe, o saghoi lubatiu gi kuda papara vaghagna iaani. Keana o saghoi leghua nigua na vanohehe kari nimua na vanohehe vamua.” ");
INSERT INTO bgt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Gi na enjel ke horu mai i popo me vaheta a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na vunegna ke papara puala kori na ghaghanagna, a Jisas ke tarai heta vano mua. Ma na susugulagna na tonogna ke vaghagna na ghaughabua ke lulu horu kori thepa. ");
INSERT INTO bgt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kori vido ke vagovua nigna na tarai, a Jisas ke sokara me tabiru tadia nigna na komi vaovarongo. Imanea ke reghira kena nere eigna kena magoli kori dikahehe. ");
INSERT INTO bgt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma a Jisas ke anira, “Ehava gi oti nere? Oti rarai moti tarai eigna kotida boi sikili kori vido na auau keda mai itamiu.” ");
INSERT INTO bgt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kori vido a Jisas ke talu haohaghore mua, mara sethe kena mai jufungia. A Jiudas, sikei itadia mara salaghe rua, ke batura mai. Imanea ke mai tagna a Jisas eigna keda kisia. ");
INSERT INTO bgt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ma a Jisas ke ania, “Jiudas, ehava kona lubatiu inau, na Dathei Tinoni, tadia mara nigua na thevuioka kori kisiugna?” ");
INSERT INTO bgt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kori vido mara vaovarongo kena adoa imarea kedana thotia a Jisas, imarea kena velea, “Ehava Lod? Tangomana mua kitida rihura tagna nimami na komi ghau?” ");
INSERT INTO bgt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sina mane itadia ke toka vurukusua na kuli madothogna nigna na mane agutu na pukuni naghoi pris. ");
INSERT INTO bgt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma a Jisas ke velera, “Soto! Saghoi rihura!” Gi e tangolia na kuligna na mane agutu iangeni me vatoke tabirua. ");
INSERT INTO bgt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ma a Jisas ke velera mara na naghoi pris, mi marea kena reireghia na Vathe ke Tabu, mi kekeha mara puhi kena mai bali thotia, “Ehava? Inau na mane geogeno gi kotida tangolia mai duamiu na komi ghau ma na komi ghai bali rihu? ");
INSERT INTO bgt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Leuleghu dani ighamu koti mono kori Vathe ke Tabu nigna a God kori vido ku velepuhira na komi tinoni. Ehava gi oti boi thotiu ingengeni? Keana ikeagaieni na nimiu na maghavu, na maghavu a God ke lubatia a Satan eigna keda eia na hava ke magnahaghinia.” ");
INSERT INTO bgt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mara na soldia kena thotia a Jisas mena hati vanoa kori vathegna na pukuni naghoi pris. A Pita ke leghura kari e boi taveti gharanira. ");
INSERT INTO bgt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Imarea kena ifua na joto kori lalabagna na vathe iangeni, ma a Pita ke nohe duadia mara kena mangiru ngengeni. ");
INSERT INTO bgt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sina vaivine mathangani ke agutu kori vathe iangeni ke reghia a Pita ke nohe ghaghireigna na joto. Iia ke buta vano itagna me velera, “Iaani sina mane ke mono duagna a Jisas.” ");
INSERT INTO bgt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kari a Pita ke piapilau me ania, “Vaivine, inau ku boi adoa na mane iangeni!” ");
INSERT INTO bgt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Boi hauhaugna sina mane ke reghia a Pita me veleagna, “E tutuni, ighoe sikei tadia nigna na komi vaovarongo!” Kari a Pita ke veleagna, “Teo! Inau u boi sikei itadia!” ");
INSERT INTO bgt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Vaghagna sina aoa leghugna iaani, sina mane mua ke haghore heta vaghagna iaani, “E tutuni, iaani sina mane ke mono duagna a Jisas, eigna imanea na manegna i Galili.” ");
INSERT INTO bgt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","A Pita ke haghore tughua, “Nighe, inau ku boi adoa na hava ko velea.” Kori vido a Pita ke talu haohaghore mua, na kokorako ke taitangi. ");
INSERT INTO bgt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma a Lod Jisas ke rei vano tagna a Pita ma a Pita ke togha tabirua na haghore ke veleagna a Lod, “Ighoe koda tolu na veleagna ko boi adou gi e tangi na kokorako kori vuevughei puni.” ");
INSERT INTO bgt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","A Pita ke dikahehegna puala me taveti au kori na lalabagna na vathe me tangi heta. ");
INSERT INTO bgt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mara kena reireghia a Jisas kena leuleua mena thabuhia. ");
INSERT INTO bgt_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Gi ena tari ponotia na matagna kori pohe mena ania, “Gi ighoe na profet, o veleghami, ahai ke thabuhigho?” ");
INSERT INTO bgt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Me sethe mua na komi fata kena veleagna bali vahouhorua. ");
INSERT INTO bgt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kori sogalagna hadi na aho, mara na Kansol kena haidu. Mara puhidia mara Jiu mi mara na naghoi pris mi mara na velepuhigna na vetula nigna a Moses kena mono ngengeni. Mara na soldia kena hati vanoa a Jisas itadia. ");
INSERT INTO bgt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Imarea kena huatia, “O veleghami, ighoe a Vahavi?” Ma a Jisas ke haghore tughura, “Gi inau kuda veleghamu, teo kotida vaututuniu. ");
INSERT INTO bgt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Gi kuda huatighamu na huahuati, teo kotida haghore tughuu. ");
INSERT INTO bgt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kari turughu ikeagaieni, inau, na Dathei Tinoni kuda nohe kori madothogna a God ke mana puala.” ");
INSERT INTO bgt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Gi imarea kena ghoi huatia, “Ehava? Ighoe a Dathegna a God na?” A Jisas ke velera, “Ighamu koti velea ghohi inau imanea.” ");
INSERT INTO bgt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Gi ena velea varihotaghidia vaghagna iaani, “Boi tangomana mua katida hiroa sa titiono tagna sa tinoni bali toroagna imanea. Eigna imanea ghehegna ke velea imanea a Dathegna a God!” ");
INSERT INTO bgt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mara na Kansol gougovu kena sokara hadi mena hati vanoa a Jisas tagna a Pailat, imanea ke primia kori provins i Jiudea, eigna keda fatea. ");
INSERT INTO bgt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Imarea kena turughu na toroagna mena velea, “Na mane iaani ke velera na komi tinoni eigna kedana sokara pungusia na gaumane gna i Rom. Imanea ke velera mua eigna kedana boi volia nidia na takis tagna na King gna i Rom. Me velera imanea a Vahavi, nida na king.” ");
INSERT INTO bgt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","A Pailat ke huatia a Jisas, “Ighoe na king nidia mara Jiu?” A Jisas ke haghore tughua, “Ighoe ko velea ghohi inau imanea.” ");
INSERT INTO bgt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Gi a Pailat ke velera mara na naghoi pris ma na mavitu, “Inau ku boi pada sa fata imanea ke ei hahia.” ");
INSERT INTO bgt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kari imarea kena haghore heta vaghagna iaani, “Tadia na komi meleha i Jiudea ke velepuhi imanea, na komi tinoni kena magnahaghinia kedana rihu. Imanea ke turughu kori provins i Galili mi ikeagaieni ke mai jufu ghohi eeni.” ");
INSERT INTO bgt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","A Pailat ke rongovia iaani me huatira, “Imanea na manegna i Galili na?” ");
INSERT INTO bgt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Imarea kena veleagna a Jisas na manegna Galili. Kori vido ke adoa a Jisas ke mai kori provins ke vunaghi pungusia a Herod, a Pailat ke vetula vanoa tagna a Herod eigna imanea ke mono i Jerusalem kori vido iangeni. ");
INSERT INTO bgt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","A Herod ke reghia a Jisas me totogo puala eigna imanea ke rongovia ghohi i hau na rorongogna a Jisas, me magnahaghinia puala keda reghia. Imanea ke magnahaghinia a Jisas keda eia sikei reghithehe. ");
INSERT INTO bgt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sethe na huahuati a Herod ke huatia a Jisas kari imanea ke boi haghore tughua. ");
INSERT INTO bgt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mara na naghoi pris mi mara na velepuhigna na vetula nigna a Moses kena sokara mua ngengeni. Imarea kena haghore heta mena toroagna a Jisas tagna na komi fata ke sethe. ");
INSERT INTO bgt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Gi a Herod ma na nigna na komi soldia kena haghore diadikala mena leuleua a Jisas. Imarea kena vapokoagna a Jisas vaghagna na king kori poko ke teve me ulaghagna mena vetula tabirua tagna a Pailat. ");
INSERT INTO bgt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","I hau, a Herod ma a Pailat koro thevuioka. Kari, turughu kori dani iangeni romara koro veidothovighi puala. ");
INSERT INTO bgt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","A Pailat ke kilora mai mara na naghoi pris mi mara kena baubatu tadia mara Jiu ma na mavitu, ");
INSERT INTO bgt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","me velera, “Ighamu koti hatia mai na mane iaani itagua moti velea imanea ke velera na komi tinoni eigna kedana sokara pungusia na gaumane gna i Rom. Keana kori vido koti mono mua eeni, inau ku huati toetokea mu boi pada sa fata koti toroagna ke tutuni. ");
INSERT INTO bgt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Vaghagna ghua, a Herod ke boi pada sa fata dika ke eia, me vetula tabiru mai itada. E teo sa fata imanea ke eia ke nabagna kuda fatea bali vathehea. ");
INSERT INTO bgt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Na vunegna iaani inau kuda velera nigua na komi soldia eigna kedana thabuhia. Leghugna iangeni, inau kuda lubati mamaluha vamua.” ");
INSERT INTO bgt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kari imarea kena ghuu heta, “Vathehea na mane iaani! Mo lubati aua a Barabas kori vathe tatari!” ");
INSERT INTO bgt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(A Barabas sina mane kena boa haghea kori vathe tatari eigna imanea ke mono koragna sina rihu hutu i Jerusalem me vathehea na tinoni.) ");
INSERT INTO bgt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","A Pailat ke ghoi velera na mavitu imanea ke magnahaghinia keda lubati mamaluha a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kari imarea kena ghuu heta, “Tupipuhia! Tupipuhia!” ");
INSERT INTO bgt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A Pailat ke ghoi vatolui haghore vaniragna na mavitu, “Ehava ko magnahaghinia kuda vathehea? Na hava ke ei hahia imanea na? Inau ku boi pada sa fata ke nabagna kuda fatea bali vathehea. Inau kuda velera nigua na komi soldia eigna kedana thabuhia. Leghugna iangeni inau kuda lubati mamaluha vamua.” ");
INSERT INTO bgt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Keana imarea kena ghuu heta vano mua eigna kedana tupipuhia a Jisas. Imarea kena ghuu mena ghuu ma a Pailat ke tughua na ghaghanagna. ");
INSERT INTO bgt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Me hiia na hava kena magnahaghinia keda ei vania a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Vaghagna na mavitu kena kaea, a Pailat ke lubati mamaluha Barabas, na mane kena boa haghea kori vathe tatari eigna ke mono koragna na rihu hutu me vathehea na tinoni. Gi a Pailat ke lubatia a Jisas vanira eigna kedana eia itagna na hava kena magnahaghinia. ");
INSERT INTO bgt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kori vido mara na soldia kena hati vanoa a Jisas, imarea kena pada kori hangana sina manegna i Sairini, na ahagna a Saimon. Imanea ke kalasu mai kosigna i Jerusalem. Mara na soldia kena huruagna eigna keda hulungia nigna na ghaibabala a Jisas me leghua. ");
INSERT INTO bgt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na mavitu ke sethe kena leghua a Jisas. Duadia na mavitu kekeha vaivine kena dikahehe mena tangi. ");
INSERT INTO bgt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","A Jisas ke rei vano itadia me anira, “Ighamu na koi vaivine eimiu i Jerusalem, oti saghoi tangi eigu inau, kari oti tangi eimiu ghehemiu ma ara dathemiu. ");
INSERT INTO bgt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Eigna na dani keda mai na komi tinoni kedana velea, ‘Totogo nidia na koi vaivine kena kara, iira ke teo sa dathedia mena boi vasusuua sa gari.’ ");
INSERT INTO bgt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kori vido iangeni na komi tinoni kedana ghuu vano tadia na komi suasupa eigna kedana sikili horu popodia me kedana velera na komi mathaghughu eigna kedana kuvurira. ");
INSERT INTO bgt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gi kedana eia na komi fata iraani tagua inau, na mane ku jino, na hava keda padara arahai kena boi jino na?” ");
INSERT INTO bgt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Imarea kena hatia mua e rua na mane koro geogeno, eigna kedana vathehera duagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kori vido kena jufu tagna na vido kena kiloagna, “Na Ghahira Ulu,” imarea kena tupipuhia a Jisas kori ghaibabala. Imarea kena tupipuhia mua e rua na mane koro geogeno, sikei kori madothogna a Jisas, sikei kori toigna. ");
INSERT INTO bgt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma a Jisas ke velea, “Mama, o talutavogha na paluhadia, eigna kena boi adoa na hava kena eia.” Gi mara na soldia kena laulahu vavahi bali adoa ahai keda hatia sikei na vidogna nigna na komi poko. ");
INSERT INTO bgt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na mavitu kena sokara ngengeni mena dodoro vano, mi mara kena baubatu tadia mara Jiu kena leuleua a Jisas. Imarea kena velea, “Imanea ke vahavira kekeha tinoni. Gi e tutuni imanea a Vahavi, na mane a God ke vahia, tangomana keda vahavia ghehegna.” ");
INSERT INTO bgt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mara na soldia huju kena leuleua mena hea na waen ke aha. ");
INSERT INTO bgt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Gi imarea kena velea, “Gi e tutuni ighoe na king nidia mara Jiu, o vahavigho ghehemu!” ");
INSERT INTO bgt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mena risoa sina rioriso kori pava mena tupia popogna a Jisas kori ghaibabala. Imarea kena risoa, “IAANI NA KINGh NIDIA MARA JIU.” ");
INSERT INTO bgt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sikei tadia romara koro bilau kena tupipuhia hilighagna a Jisas ke velehouhorua vaghagna iaani, “Gi ighoe a Vahavi, o vahavigho ghehemu mo vahavighami iroghami ghua!” ");
INSERT INTO bgt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kari na varuai mane bilau ke haghore heta vania imanea, “O mataghunia God, eigna ighoe koda thehe kori ghaibabala vaghagna vamua imanea. ");
INSERT INTO bgt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Iroghita eri e naba vamua koroda thehe, eigna na komi fata ke dika koro eia. Kari na mane iaani e teo sa fata ke dika ke eia.” ");
INSERT INTO bgt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Gi e velea, “Jisas, o saghoi havaghiniu kori vido ighoe koda turughu na vunaghi pungusiragna nimua na mavitu.” ");
INSERT INTO bgt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma a Jisas ke ania, “Inau ku taluhaghore vanigho, kenughua vamua, ighoe koda mono duagu i Paradaes.” ");
INSERT INTO bgt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Turughu kori hotaghi dani me jufu kori tangi tolu, na meleha i Israel doudolu ke puni, ");
INSERT INTO bgt_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","eigna na aho ke boi raraha. Na pohe ke sasavera peoa na vido ke tabu kori Vathe ke Tabu nigna a God ke resu me thevurua. ");
INSERT INTO bgt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ma a Jisas ke ghuu heta, “Mama, inau ku lubatia na tarungagu itamua!” Imanea ke velea iaani gi e thehe. ");
INSERT INTO bgt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kori vido na mane ke nagho tadia mara na soldia ke reghia na komi fata irangeni, imanea ke veletokea a God vaghagna iaani, “E tutuni, na mane iaani e teo sa paluhagna!” ");
INSERT INTO bgt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kori vido na komi tinoni kena hathatano mai ngengeni bali reghia na tupipuhigna a Jisas kena reghia na komi fata iraani, imarea kena tupia na raghadia eigna kena dikahehedia mena tabiru kori vathedia. ");
INSERT INTO bgt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na komi tinoni kena pukuni adoa a Jisas, duadia na koi vaivine kena leghua turughu mai i Galili, kena sokara tagna ke hau mena reghi vanoa na komi fata iraani. ");
INSERT INTO bgt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Sina mane, na ahagna a Josep, ke mono ngengeni. Imanea na manegna i Arimatea, sina meleha i Jiudea. Imanea na mane jino me mono pitua na reghiagna na maghavu a God keda vunaghi pungusia nigna na mavitu. Imanea sikei tadia mara na Kansol nidia mara Jiu, kari e boi hiia nidia na fate me boi magnahaghinia na hava kena eia tagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Imanea ke vano tagna a Pailat me kaea na tonogna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Gi e hatia horua me filehiagna kori pohe ke pura me vano boa korai luma kena jouua kori ghahira. Na luma iangeni, e teo sa tinoni kena boa mua ikoragna. ");
INSERT INTO bgt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na dani iangeni, na dani bali kaikaliti eigna na Sabat. Na Sabat keda turughu kori vido ke huu na aho. ");
INSERT INTO bgt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kori vido kena hati vanoa na tonogna a Jisas, na koi vaivine kena leghua turughu mai i Galili kena leghua vanoa a Josep. Iira kena reghia na luma ma na puhi imarea kena boa na tonogna a Jisas ikoragna. ");
INSERT INTO bgt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Govu gi ena tabiru kori melehadia mena kaikalitia na oela ma na sedi bali havula kori tonogna a Jisas. Kori vido kena govua na kaikaliti, na Sabat ke jufu mai ghohi, mena mamatho vaghagna na vetula ke velea ghohi. ");
INSERT INTO bgt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Vuevughei puni kori dani Sade, na koi vaivine kena hatia na komi fata ke ghuba toetokegna kena kaikalitia mena vano kori luma. ");
INSERT INTO bgt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ira kena reghia na ghahira hutu kena kokopili bali bilakiagna na luma ke au ghohi, ");
INSERT INTO bgt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","mena vano haghe, kari ena boi reghia na tonogna a Lod Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kori vido kena talu toatogha iaani, e rua na mane na pohedia ke siasilada koro tate mai moro sokara hilighadia. ");
INSERT INTO bgt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na koi vaivine kena mataghu puala mena pogho horu kori thepa. Gi e rua na mane iangeni koro huatira, “Ehava gi oti hiroa ahai ke havi kori vido kena mono mara kena thehe? ");
INSERT INTO bgt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Imanea ke teo eeni! Imanea ke sokara tabiru ghohi kori thehe! Oti togha tabirua na hava ke veleghamu kori vido ke mono duamiu i Galili. Imanea ke velea, ");
INSERT INTO bgt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Imarea kedana lubatia na Dathei Tinoni kori limadia mara na koakoa, gi kedana tupipuhia, kari imanea keda sokara tabiru kori vatolugna na dani.’” ");
INSERT INTO bgt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ma na koi vaivine kena togha tabirua na komi haghore iraani ke velea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kori vido kena tabiru kori meleha, iira kena titionoa na hava kena reghia tadia salaghe sikei mara na vetula ma arahai ghua kena mono duadia. ");
INSERT INTO bgt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na koi vaivine kena titionoa vanira mara na vetula, a Merigna i Magdala, Joana, Meri a idogna a Jemes, mi kekeha vaivine ghua. ");
INSERT INTO bgt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kori vido mara na vetula kena vaovarongo itadia, imarea kena boi vaututunira eigna kena ghaghana iira kena hai titiono vamua. ");
INSERT INTO bgt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Keana, a Pita ke sokara hadi me raghe vano kori luma. Imanea ke pogho horu me sigho haghe me reghia vamua na pohe pura kena filehiagna na tonogna a Jisas. Gi e tabiru kori meleha me toatogha puala eigna na hava ke reghia. ");
INSERT INTO bgt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kori dani vamua iangeni, e rua nigna na vaovarongo a Jisas koro taveti vano kori meleha Emeas, na haugna i Jerusalem vaghagna e salaghe sikei na kilomita. ");
INSERT INTO bgt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Romara koro titionoa varihotaghidia eigna na komi fata ke kathea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kori vido romara koro talu uurungu mua, a Jisas ke mai gharanira me taetaveti duadia. ");
INSERT INTO bgt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Keana a God ke boi lubatira gi koroda ghithatha ahai imanea. ");
INSERT INTO bgt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma a Jisas ke huatira, “Na hava koro titionoa varihotaghimiu kori vido koro taetaveti?” Romara koro sokara soto moro dikahehedia puala. ");
INSERT INTO bgt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sina mane itadia, na ahagna a Kleopas, ke veleagna, “Da ighoe vamua itadia na komi tinoni kena mai i Jerusalem, ko boi adoa na komi fata ke tate mai tadia na komi dani iraani.” ");
INSERT INTO bgt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jisas ke huatira, “Na hava fata?” Romara koro haghore tughua, “Na komi fata kena eia tagna a Jisas, na manegna i Nasaret. Imanea na profet, ma nigna na komi haghore ma na komi fata ke eia ke mana puala. A God ma na komi tinoni gougovu kena ghaghana bohea imanea. ");
INSERT INTO bgt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Keana mara na naghoi pris mi mara kena batughita kena thotia mena lubati vanoa tadia mara i Rom. Imarea kena fatea eigna kedana vathehea, gi ena tupipuhia kori ghaibabala. ");
INSERT INTO bgt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ighami kiti toatogha imanea keda vamamaluhaghita ighita mara i Israel tadia nida na komi thevuioka. Kari na fata ke dika puala, ikeagaieni na vatolugna na dani leghugna na komi fata iraani, kari e teo sa fata ke tate mai mua. ");
INSERT INTO bgt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Sina fata mua, ighami kiti vere nimami puala eigna na hava ke veleghami kekeha koi vaivine kena mono duamami. Iira kena vano kori luma i geni kori vuevughei ");
INSERT INTO bgt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mena veleghami kena boi reghia na tonogna ngengeni. Mena veleghami mua kena reghia kekeha enjel kena velera a Jisas ke ghoi havi tabiru. ");
INSERT INTO bgt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kekeha tinoni kena mono duamami kena vano kori luma mena reghia na tonogna a Jisas ke boi mono ngengeni, vaghagna vamua na koi vaivine kena velea.” ");
INSERT INTO bgt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Gi a Jisas ke anira, “Oro mee! Roghamu koro poru puala na vaututuniagna na komi fata kena velea mara na profet i hau. ");
INSERT INTO bgt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Imarea kena velea a Vahavi keda kidi papara, gi a God keda vathaba imanea i popo. ");
INSERT INTO bgt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Govu, gi e unuhia vanira na ghaghana ikoragna na komi fata eigna a Vahavi tadia na komi rioriso nigna a Moses ma na komi profet. ");
INSERT INTO bgt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Imarea kena mai gharania na meleha koro haga vano itagna, ma a Jisas ke haga taveti thovohaliu. ");
INSERT INTO bgt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kari romara koro kae huhurua vaghagna iaani, “O mono ghua duamami eigna ke lavi ghohi me haga puni.” Ma a Jisas ke vano duadia. ");
INSERT INTO bgt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kori vido kena nohe bali vanga, a Jisas ke tangolia na bred me veletokea a God. Gi e vidoa me hera. ");
INSERT INTO bgt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ma a God ke lubatia gi koroda adoa imanea a Jisas. Kori vido koro ghithatha, imanea ke teo ghohi itadia. ");
INSERT INTO bgt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gi oro titiono varihotaghidia ghehedia vaghagna iaani, “Kori vido imanea ke titiono duada kori hangana me unuhia vanighita na komi Rioriso ke Tabu, roghita koro vajangia na totogo kori havida.” ");
INSERT INTO bgt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Iromara koro sokara hadi moro tabiru vano i Jerusalem. Romara koro padara mara salaghe sikei na vaovarongo kena haidu duadia kekeha tinoni. ");
INSERT INTO bgt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Arahai kena haidu ngengeni kena velera, “E tutuni! A Lod ke sokara tabiru me tate vania a Saimon Pita!” ");
INSERT INTO bgt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Govu gi iromara koro velera a Jisas ke tate vanira kori vido koro taetaveti kori hangana. Moro titionoa mua koro ghithatha imanea kori vidoagna na bred. ");
INSERT INTO bgt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kori vido romara koro talu titionoa mua itadia, a Jisas ke tate mai me sokara itadia me anira, “Na soleana itamiu.” ");
INSERT INTO bgt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Imarea kena peperiki mena mataghu puala eigna kena ghaghana kena reghia na tarunga. ");
INSERT INTO bgt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kari a Jisas ke anira, “Ehava gi oti mataghu moti ghaghana ruarua? ");
INSERT INTO bgt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Inau vamua iaani! Oti reghia maia e rua na limagu ma na naegu. Oti mai tangolia na tonogu eigna kotida adoa inau boi na tarunga, eigna na tarunga ke teo sa huli ma sa vinahi vaghagu inau.” ");
INSERT INTO bgt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Leghugna na veleragna iaani, imanea ke tatelia itadia na limagna ma na naegna. ");
INSERT INTO bgt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Imarea kena totogo puala mena vere nidia, kari ena talu ghaghana ruarua mua. A Jisas ke adoa iaani, me velera, “E mono mua sa vanga itamiu?” ");
INSERT INTO bgt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Imarea kena hea sina vidoi igha, ");
INSERT INTO bgt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","mi manea ke hatia me ghania kori matadia. ");
INSERT INTO bgt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mi manea ke velera, “Kori vido inau ku mono duamiu i hau, inau ku veleghamu ghohi na komi fata kena risoa eigu inau tagna na komi rioriso nigna a Moses mi mara na komi profet ma na komi Psalm kedana tate au mai tutuni. ");
INSERT INTO bgt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Gi e unuhia na ghaghanagna na komi Rioriso ke Tabu eigna kedana thaothadoghagna. ");
INSERT INTO bgt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Imanea ke velera, “Na komi Rioriso ke Tabu kena velea iaani: A Vahavi keda papara me thehe. Keana, imanea keda ghoi havi tabiru kori vatolugna na dani. ");
INSERT INTO bgt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kori ahagna, imarea kedana titiono aua a God keda talutavogha na komi paluhadia arahai kena tughua na havidia ke koakoa. Imarea kedana turughu i Jerusalem me jufu tadia na komi meleha kori maramagna. ");
INSERT INTO bgt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na vunegna ighamu koti reghia na komi fata iraani kena katheu, inau ku magnahaghinighamu kotida titiono aua tadia na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Inau kuda vetula maia itamiu na Tarunga ke Tabu a tamagu ke taluhaghorea vanighamu ghohi. Moti saghoi taveti sania i Jerusalem me ghieghilei jufungia na maghavu kotida hatia na mana tagna a God.” ");
INSERT INTO bgt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Leghugna iaani a Jisas ke batura au i Jerusalem nigna na komi vaovarongo mena vano kori meleha i Betani. Gi e tuhu hadi na limagna me vatokera. ");
INSERT INTO bgt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kori vido imanea ke talu vatokera mua, a God ke hati aua itadia me hati hadia duagna i popo. ");
INSERT INTO bgt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Imarea kena maimanihihia, gi ena tabiru i Jerusalem mena totogo puala. ");
INSERT INTO bgt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Leuleghu maghavu imarea kena mono kori Vathe ke Tabu mena veletokea a God. ");
INSERT INTO bgt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kori turughugna na komi fata gougovu, na Haghore ke mono ghohi. Na Haghore ke mono duagna a God, ma na Haghore a God. ");
INSERT INTO bgt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Imanea ke mono ghohi duagna a God kori turughugna. ");
INSERT INTO bgt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","A God ke vavuhara na komi fata gougovu duagna imanea. Tutuni, na komi fata gougovu ke vavuhara a God, imanea ke vavuhara duagna na Haghore. ");
INSERT INTO bgt_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na havidia na komi fata gougovu ke au mai tagna na Haghore, mi manea na raraha bali laema tadia na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na raraha iangeni ke laema kori puni, ma na puni teo keda vathehea. ");
INSERT INTO bgt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","A God ke vetula maia sina mane na ahagna a Jon Siuvitabu. ");
INSERT INTO bgt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Imanea ke mai bali titionoa na raraha tadia na komi tinoni. Jon ke titiono itadia eigna kedana vaovarongo eigna na raraha mena vaututunia. ");
INSERT INTO bgt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A Jon boi na raraha iangeni, keana imanea hiri ke mai bali titionoa na raraha. ");
INSERT INTO bgt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na pukuni raraha, imanea ke mai kori maramagna me laema itadia na komi tinoni gougovu. ");
INSERT INTO bgt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Na Haghore ke mono kori maramagna. Keana na komi tinoni kori maramagna kena boi adoa imanea, toke a God ke vavuha na maramagna duagna imanea. ");
INSERT INTO bgt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Imanea ke mai kori melehagna, kari nigna na komi tinoni kena Jiu kena boi hatia imanea duai totogo. ");
INSERT INTO bgt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Keana tadia arahai kena hatia duai totogo mena vaututunia, imanea ke lubatira eigna kedana ara dathegna God. ");
INSERT INTO bgt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Imarea boi ara dathegna a God eigna kena havi mai leghuagna na ghaghanagna ba na vanohehegna na tinoni. Teo. Imarea kena ara dathegna eigna a God ke hera na havi mathangani. ");
INSERT INTO bgt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na Haghore ke vuhai tinoni me mono duada kori maramagna iaani. Ighami kiti reghia imanea ke thaba vano eigna imanea sikei vamua na ghathi Dathegna God na Mama. Ighami kiti reghia imanea ke vonungia na dotho ma na tutuni. ");
INSERT INTO bgt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","A Jon ke titiono eigna imanea tadia na komi tinoni. Imanea ke haghore heta vanira, “Iaani na mane ku titionoa kori vido ku veleghamu, ‘Imanea keda mai leghugu ke nagho vano itagua, eigna imanea ke kidi mono ghohi gi u havi mai inau.’” ");
INSERT INTO bgt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na vunegna imanea ke vonungia na dotho ma na tutuni, imanea ke vatokeghita kori heghitagna na komi fata ke sethe ke toke. ");
INSERT INTO bgt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","A Moses ke hatia maia na komi vetula nigna God tadia na komi tinoni, keana na dotho ma na tutuni ke mai tagna Jisas Krais. ");
INSERT INTO bgt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Teo sikei tinoni ke reghia God. Keana sikei vamua na ghathi Dathegna ke mono duagna mi manea ghehegna a God. Imanea ke tatelia vanighita na puhigna God. ");
INSERT INTO bgt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Sina maghavu mara puhidia mara Jiu i Jerusalem kena vetulara vano tagna a Jon kekeha mara na pris mi kekeha mara kena hathera na komi pris. Imarea kena huatia, “Ahai ighoe na?” ");
INSERT INTO bgt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ma Jon ke titiono jino vanira, “Inau bosi a Vahavi.” ");
INSERT INTO bgt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Gi imarea kena veleagna, “Gi ighoe koda boi a Vahavi, ahai ighoe na? A profet Elaija ke mono i hau?” Imanea ke haghore tughura, “Teo.” Mena ghoi huatia mua, “Ehava? Ighoe na Profet a God ke taluhaghorea keda vetula maia?” Mi imanea ke velera, “Teo.” ");
INSERT INTO bgt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Gi imarea kena veleagna, “Gi keda ai na, ahai ighoe na? O veleghami eigna kitida tangomana na veleragna arahai kena vetulaghami mai. O titiono vanighami eimu ghehemu.” ");
INSERT INTO bgt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A Jon ke haghore tughura tagna na komi haghore iraani ke velea a profet Aisaia, “Inau na tinoni ku haohaghore heta kori meleha ke gou, ‘Oti vajinoa na hangana vania a Lod!’” ");
INSERT INTO bgt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tadia arahai kena mai tagna a Jon e mono kekeha mara na Farise. ");
INSERT INTO bgt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Imarea kena huatia a Jon vaghagna iaani, “Gi ighoe boi a Vahavi ba Elaija, ba na Profet, ehava gi o siuvitabura na komi tinoni na?” ");
INSERT INTO bgt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","A Jon ke haghore tughura, “Inau ku siuvitabura na komi tinoni kori bea, kari ikeagaieni sina tinoni koti boi adoa ke mono duada eeni. ");
INSERT INTO bgt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Imanea na tinoni ku velea keda mai leghugu. Inau boi naba kuda pogho horu mu hati aua nigna na sadol.” ");
INSERT INTO bgt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na komi fata irangeni kena eia kori meleha i Betani, etagna na bea i Jodan. Kori bea hutu iangeni, a Jon ke siuvitabura na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sina dani leghugna iangeni a Jon ke reghia a Jisas ke taveti mai itagna me velera na komi tinoni ngengeni, “Reghia! Iangeni na Dathei Sip nigna God ke hati aua na paluhagna na maramagna. ");
INSERT INTO bgt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Imanea hiri na tinoni ku titionoa ghohi kori vido ku velea, ‘Na mane keda mai i leghugu, imanea ke nagho vano tagua, eigna imanea ke kidi mono ghohi gi u havi mai inau.’ ");
INSERT INTO bgt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","I hau, toke inau ku boi adoa ahai imanea bali mai leghugu, inau ku mai eeni mu siuvitabura na komi tinoni kori bea eigna kuda tateli aua imanea tadia na komi tinonidia i Israel.” ");
INSERT INTO bgt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Gi a Jon ke ghoi velea mua, “Kori vido ku boi adoa mua ahai imanea bali mai iangeni, a God ke vetulau bali siuvitabura na komi tinoni kori bea, imanea ke veleu, ‘Na mane koda reghia na Tarunga ke Tabu keda horu mai me togha itagna, imanea hiri ahai keda siuvitabura na komi tinoni kori Tarunga ke Tabu.’ Mu pukuni reghia na Tarunga ke Tabu ke horu mai i popo vaghagna na bora, me togha itagna imanea. ");
INSERT INTO bgt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma na vunegna ku reghia iangeni, inau ku veleghamu a Jisas a Dathegna a God.” ");
INSERT INTO bgt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sina dani leghugna iangeni, a Jon Siuvitabu ke ghoi sokara ngengeni duadia e rua nigna na mane vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kori vido imanea ke reghia a Jisas ke halu atu, a Jon ke velea, “Reghia, iangeni na Dathei Sip nigna God!” ");
INSERT INTO bgt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","E rua nigna na vaovarongo koro rongovia na haghore iangeni, moro leghua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","A Jisas ke rei tabiru me reghira koro leghua me huatira, “Na hava koro magnahaghinia?” Iromara koro ania, “Rabai, ivei ko mono ighoe na? (Na ghaghana koragna Rabai, Velepuhi). ");
INSERT INTO bgt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Imanea ke velera, “Oro mai moro reghia ghehemiu.” Kori vido iangeni nabagna tangi vati kori lavi. Romara koro vano duagna moro reghia na vido ke mono imanea, moro mono duagna kori dani iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Sina mane itadia romara iangeni ke rongovia a Jon me leghua Jisas, a Andru, a tahigna a Saimon Pita. ");
INSERT INTO bgt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ma na hava ke kidi eia a Andru, imanea ke hiroa a Saimon, a toghagna me veleagna, “Ighami kiti reghia ghohi a Vahavi!” (Na aha “Vahavi” nanaba vamua kori aha “Krais”). ");
INSERT INTO bgt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Gi Andru ke hati vanoa a Saimon tagna a Jisas. A Jisas ke rei vano tagna a Saimon me veleagna, “Ighoe na ahamu a Saimon, a dathegna Jon. Keana ikeagaieni na ahamu kedana kiloghogna a Kefas.” (Na aha iaani vaghagna vamua na aha Pita ma na ghaghana koragna, “na ghahira”). ");
INSERT INTO bgt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sina dani leghugna iangeni a Jisas ke toatogha gi keda vano kori provins i Galili. Imanea ke reghia a Filip me ania, “O mai leghuu.” ");
INSERT INTO bgt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip na manegna i Betsaida, na melehadia Andru ma Pita. ");
INSERT INTO bgt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kori vido iangeni a Filip ke vano me pada a Nataniel me ania, “Ighami kiti reghia ghohi na mane a Moses mi mara na profet kena risoa eigna tadia na komi Rioriso ke Tabu. Na ahagna imanea a Jisas, a dathegna Josep gna i Nasaret.” ");
INSERT INTO bgt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","A Nataniel ke velea, “I Nasaret! Tangomana keda au mai kori meleha iangeni sa fata ke toke?” Ma Filip ke ania, “O mai mo reghia imanea.” ");
INSERT INTO bgt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kori vido a Jisas ke reghia a Nataniel ke taveti mai, imanea ke velea, “Iangeni na pukuni manegna i Israel ke boi piapilau.” ");
INSERT INTO bgt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","A Nataniel ke huatia a Jisas, “Ehava gi o adou?” A Jisas ke ania, “Gi e kilogho a Filip, inau ku reghigho ghohi saragna na ghai fig.” ");
INSERT INTO bgt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","A Nataniel ke veleagna, “Velepuhi, ighoe a Dathegna a God ma na King gna i Israel.” ");
INSERT INTO bgt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisas ke veleagna, “Ehava? O vaututuniu eigna inau ku velegho ku reghigho saragna na ghai fig? Sethe na fata ke hutu vano tagna iangeni ighoe koda reghira.” ");
INSERT INTO bgt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gi e veleragna mara gougovu, “E tutuni na hava ku veleghamu, ighamu kotida reghia na hughuta i popo keda hangavi, ma na komi enjel nigna a God kedana hadi mena horu itagua inau, na Dathei Tinoni.” ");
INSERT INTO bgt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","E rua na dani leghugna a Jisas ke kilora a Filip ma Nataniel, a idogna a Jisas ke mono tagna sina sonihaidu taulaghi kori meleha i Kena kori provins i Galili. ");
INSERT INTO bgt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Imarea kena hulaghinira mua a Jisas duagna nigna na komi vaovarongo tagna na sonihaidu iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kori vido ke boi govu mua na vangahaidu, na waen ke govu ghohi. A idogna a Jisas ke veleagna, “Na waen ke govu.” ");
INSERT INTO bgt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","A Jisas ke haghore tughua, “Vaivine, ehava gi o mai itagua eigna iaani? Nigua na maghavu ke boi jufu mai mua.” ");
INSERT INTO bgt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Gi a idogna a Jisas ke velera na komi tinoni agutu, “Oti eia na hava keda veleghamu.” ");
INSERT INTO bgt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ingengeni ono na botolo hutu kena agutu kori ghahira ke mono. Sikei na botolo haga nabagna sina hathangatu na lita i bea koragna. Na komi botolo iraani bali toitoi bea eigna mara Jiu kedana sikame mena wasia nidia na disi leghuagna na puhi ke jino kori nidia na vetula. ");
INSERT INTO bgt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Gi a Jisas ke velera na komi tinoni agutu, “Oti vano ohora mai na bea moti hurira na komi botolo iraani.” Kori vido kena hurira me vonu, ");
INSERT INTO bgt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","a Jisas ke velera, “Oti thaupia sina vidogna na bea moti hati vanoa tagna na mane ke reireghia na vangahaidu iaani.” Gi imarea kena eia vaghagna ke veleragna. ");
INSERT INTO bgt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kori vido na mane ke reireghia na vangahaidu ke gnamia na bea, na bea ke vuhai waen. Imanea ke boi adoa ivei ke mai na waen iangeni, kari imarea kena hati vanoa itagna kena adoa. Gi e kilo maia na mane ke eu taulaghi me veleagna, ");
INSERT INTO bgt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Tadia na komi vangahaidu, imarea kena kidi hera na komi tinoni na waen ke toke puala. Gi leghugna kena kou mena kou na komi tinoni, imarea kena hera na waen ke boi rae toke. Keana ikeagaieni ighoe ko hatia maia na waen ke pukuni toke, leghugna kena kou ghohi na komi tinoni!” ");
INSERT INTO bgt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iaani na reghithehe a Jisas ke kidi eia. Imanea ke eia kori meleha i Kena kori provins i Galili me tateli aua nigna na mana ke hutu. Ma na nigna na komi vaovarongo kena vaututunia. ");
INSERT INTO bgt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Leghugna ke govu na sonihaidu, a Jisas ma a idogna mara tahigna ma na nigna na komi vaovarongo kena taveti vano kori meleha i Kapaneam mena mono kekeha dani ngengeni. ");
INSERT INTO bgt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na Laulahugna na Thovoliungi ke gharani mai ghohi ma Jisas ke taveti vano i Jerusalem. ");
INSERT INTO bgt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Imanea ke vano kori lalabagna na Vathe ke Tabu nigna a God me reghia na komi tinoni kena salemura na komi kau, ma na komi sip, ma na komi bora bali havughaghi. Me reghia mua kekeha tinoni kena nohe tadia na komi tevo mena tutughu rongo bali volia na takisigna na Vathe ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ma Jisas ke hatia kekeha piru me agutua na bali thabu. Gi e paji aura na komi kau ma na sip tagna na vido ianeni. Imanea ke koli poghora na komi tevo nidia mara kena tutughu rongo ma nidia na siliva ke rote kilili. ");
INSERT INTO bgt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Gi e haghore heta tadia arahai kena salemura na komi bora. Imanea ke velera, “Oti hati aura i kosi! Oti saghoi eia kori vathegna a Tamagu na vido bali makete!” ");
INSERT INTO bgt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Gi nigna na komi vaovarongo kena togha tabirua na vido rioriso ke mono tadia na komi Rioriso ke Tabu ke velea, “Nigua na dotho eigna na vathemu ke hutu puala.” ");
INSERT INTO bgt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mara puhidia mara Jiu kena huatia a Jisas, “O eia na reghithehe eigna kitida adoa a God ke velegho gi o eia iaani!” ");
INSERT INTO bgt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","A Jisas ke anira, “Oti reo horua na Vathe ke Tabu iaani, mi koragna tolu na dani inau kuda ghoi vasokaraghinia.” ");
INSERT INTO bgt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mi marea kena ania, “Ighoe o toatogha ko tangomana na vasokaraghiniagna koragna tolu na dani? E vahotha puala! Eigna e rua tutughu me ono na vinogha imarea kena agutu gi e govu na Vathe ke Tabu iaani.” ");
INSERT INTO bgt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Imarea kena boi adoa na Vathe ke Tabu ke titionoa a Jisas, na tonogna ghehegna. ");
INSERT INTO bgt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Leghugna ke sokara tabiru a Jisas kori thehe, nigna na komi vaovarongo kena togha tabirua na hava ke velea a Jisas. Kori vido iangeni, imarea kena vaututunia na komi Rioriso ke Tabu ma na komi fata ke velea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kori vido a Jisas ke mono i Jerusalem tadia na komi dani kena eia na Laulahugna na Thovoliungi, sethe na tinoni kena vaututunia eigna kena reghia na komi reghithehe ke eia. ");
INSERT INTO bgt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kari a Jisas ke boi pukuni vaututunira eigna imanea ke adoa na havidia na komi tinoni gougovu. ");
INSERT INTO bgt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Toke keda teo ahai ke titiono vania a Jisas eigna na havidia na komi tinoni, imanea ke adoa ghohi. ");
INSERT INTO bgt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Tagna sina bongi, sina mane ke baubatu tadia mara Jiu ke mai tagna a Jisas. Na ahagna a Nikodimas, imanea na mane Farise. Kori vido ke mai tagna a Jisas, a Nikodimas ke veleagna, “Velepuhi, ighami kiti adoa a God ke vetulagho mai bali velepuhighami. Ighami kiti adoa iaani eigna teo ahai keda tangomana na eiagna na komi reghithehe ko eia ghohi gi a God keda boi mono duagna.” ");
INSERT INTO bgt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","A Jisas ke veleagna, “O vaovarongo toetoke tagna na fata ke tutuni iaani. Teo ahai keda haghe kori hughuta nigna a God gi imanea keda boi ghoi havi mai.” ");
INSERT INTO bgt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas ke haghore tughua a Jisas vaghagna iaani, “E vahotha puala na tinoni ke puhi ghohi keda ghoi tabiru haghe kori kutugna a idogna bali ghoi havi mai.” ");
INSERT INTO bgt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Gi a Jisas ke veleagna, “O vaovarongo toetoke tagna na fata ke tutuni iaani. Teo ahai keda haghe kori hughuta nigna a God gi imanea keda boi havi mai kori bea ma na Taruna ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Na tinoni ke hatia na havi kori maramagna iaani eigna imanea ke havi mai tagna a idogna ma tamagna. Keana na tinoni ke hatia na havi mathangani eigna imanea ke havi mai kori na Taruna ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","O saghoi nia vere eigna inau ku velegho ighamu gougovu kotida ghoi havi mai. ");
INSERT INTO bgt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kori vido na ghuri ke ghuighuri vano kori vido ke magnahaghinia, ighoe ko rongovia na tagumugna. Kari ighoe ko boi adoa tagna ke turughu mai mi vei keda vano. Vaghagna vamua iangeni, teo ahai ke tangomana na thaothadoghagna na puhi na Tarunga ke Tabu ke hera na komi tinoni na havi mathangani.” ");
INSERT INTO bgt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","A Nikodimas ke veleagna, “Ehava gi na Tarunga ke Tabu ke tangomana na eiagna iangeni?” ");
INSERT INTO bgt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","A Jisas ke veleagna, “Ighoe sina naghoi mane velepuhi i Israel. Ehava gi o boi thaothadoghagna na komi fata iraani? ");
INSERT INTO bgt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Vaovarongo toetoke tagna na fata ke tutuni iaani. Ighami kiti titiono eigna na komi fata kiti thaothadoghagna miti reghia, kari ighamu koti bosi magnahaghinia na vaututuniagna na hava kiti veleghamu. ");
INSERT INTO bgt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ighamu koti boi vaututuniu kori vido inau ku titionoa na komi fata kori maramagna, me teo kotida vaututuniu kuda titionoa na komi fata i popo. ");
INSERT INTO bgt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Inau vamua ku thaothadoghagna na komi fata i popo, eigna inau, na Dathei Tinoni, ku horu mai i popo. Teo ahai mua ke horu mai i popo. ");
INSERT INTO bgt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Kori vido a Moses ma na komi tinoni Jiu kena mono kori meleha ke gou, Moses ke sokaraghinia hadia na ghai ke mono na poli itagna kena agutua kori aian. Vaghagna mua iangeni inau, na Dathei Tinoni, imarea kedana bou hadi kori ghai, ");
INSERT INTO bgt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","eigna arahai kena vaututuniu kedana hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Na vunegna a God ke dothovira puala na komi tinoni kori maramagna, imanea ke lubatia maia sikei vamua ghathi Dathegna eigna arahai kena vaututunia kedana boi thehe, kari imarea kedana hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","A God ke bosi vetula maia a Dathegna kori maramagna eigna keda fatera na komi tinoni kori maramagna, kari imanea ke vetula maia eigna keda vahavira. ");
INSERT INTO bgt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Arahai kena vaututunia a Dathegna God, a God keda boi fatera. Kari arahai kena boi vaututunia, a God ke fatera ghohi eigna kena boi vaututunia sikei vamua na ghathi Dathegna. ");
INSERT INTO bgt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","God keda fatera eigna iaani: Na raraha ke mai kori maramagna, kari imarea kena dothovia na puni mena boi dothovia na raraha eigna na puhidia ke dika. ");
INSERT INTO bgt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Arahai kena eia na komi fata ke dika kena boi magnahaghinia na raraha. Imarea kena boi mai gharania na raraha eigna kena boi magnahaghinia na raraha keda tateli aua na komi fata dika kena eia. ");
INSERT INTO bgt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kari arahai kena eia na komi fata ke jino, imarea kena mai gharania na raraha, eigna kena magnahaghinia na komi tinoni kedana adoa a God ke hathera na eiagna na komi tango ke toke.” ");
INSERT INTO bgt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Leghugna iangeni, Jisas ma na nigna na komi vaovarongo kena taveti au i Jerusalem mena vano tagna ke mono kekeha bea kori provins i Jiudea. Imarea kena mono ngengeni kekeha dani mena siuvitabura kekeha tinoni. ");
INSERT INTO bgt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kori vido iangeni a Jon Siuvitabu ke siuvitabura kekeha tinoni i Ainon ke mono gharania na meleha i Salim, eigna ngengeni ke sethe na bea. Me sethe na tinoni kena mai itagna eigna imanea keda siuvitabura. ");
INSERT INTO bgt_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Leghugna iaani, a Herod ke boa haghea a Jon kori vathe tatari. ");
INSERT INTO bgt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sina maghavu, nigna na komi mane vaovarongo a Jon kena rihu haohaghore duagna sina mane Jiu. Imarea kena rihu haohaghore eidia na komi vetula nidia mara Jiu bali vararahara ghehedia kori koakoa tagna na bea. ");
INSERT INTO bgt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nigna na komi vaovarongo a Jon kena vano itagna a Jon mena veleagna, “Velepuhi, o togha tabirua na mane ke mono duamu sethevugna na bea hutu i Jodan, na mane ko titionoa tadia na komi tinoni? Ikeagaieni imanea ke eia na siuvitabu, ma na komi tinoni gougovu kena vano itagna.” ");
INSERT INTO bgt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A Jon ke haghore tughura, “Na tinoni ke tangomana na eiagna vamua na agutu a God ke lubatia vania. ");
INSERT INTO bgt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ighamu koti rongovia ghohi inau ku veleghamu inau boi a Vahavi. A God ke vetulau mai bali kaikalitira na komi tinoni eigna na maigna imanea. ");
INSERT INTO bgt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kori sonihaidu, na vaivine keda taulaghi, iia nigna na mane keda taulaghi itagna. Kari a kulagna na mane keda taulaghi, imanea ke totogo vamua eigna ke mono duagna me rongovia nigna na haghore na mane keda taulaghi. Vaghagna vamua iangeni, inau ku totogo puala na rongoviagna na komi tinoni kena vano tagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A God ke magnahaghinia imanea keda huju hadi vano mi inau kuda huju horu.” ");
INSERT INTO bgt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Na komi tinoni kena havi mai kori maramagna, imarea na komi tinonigna na maramagna mena titiono eigna na komi fata kori maramagna. Kari a Vahavi ke horu mai i popo, mi manea ke thaba vano tadia na komi tinoni gougovu. ");
INSERT INTO bgt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Imanea ke titionoa na hava ke rongovia me reghia, kari boi sethe na tinoni kena vaututunia na hava ke velea. ");
INSERT INTO bgt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Keana arahai kena vaututunia, imarea kena tateli aua na hava a God ke velea ke tutuni ");
INSERT INTO bgt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","eigna a Vahavi a God ke vetula maia, imanea ke titiono aua na komi haghoregna a God. Imanea ke eia iangeni eigna a God ke vetula na Taruna ke Tabu eigna keda pukuni vonungia me mono duagna hahali. ");
INSERT INTO bgt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","A Mama ke dothovia a Dathegna me hea na mana eigna keda vunaghi pungisira na komi fata gougovu. ");
INSERT INTO bgt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Arahai kena vaututunia a Dathegna God, imarea kena hatia ghohi na havi ke teo na govugna. Kari arahai kena boi vaututunia, imarea teo kedana hatia na havi iangeni. Ma na papara a God keda eia itadia teo keda govu. ");
INSERT INTO bgt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mara na Farise kena rongovia arahai kena leghua a Jisas me siuvitabura, imarea irangeni ke sethe vano tadia arahai kena leghua a Jon Siuvitabu. ");
INSERT INTO bgt_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Kari na hava ke tutuni, na komi nigna vaovarongo a Jisas kena siuvitabura na komi tinoni, boi a Jisas). ");
INSERT INTO bgt_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Na vunegna a Jisas ke adoa mara na Farise kena rongovia iangeni, imanea duagna nigna na komi vaovarongo kena taveti au i Jiudea mena turughu vano kori provins i Galili. ");
INSERT INTO bgt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kori taetavetidia vano i Galili, imarea kena kidi taetaveti vano kori provins i Samaria. ");
INSERT INTO bgt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Imarea kena jufu tagna na meleha Sika i Samaria, gharania na vido i thepa sina hutudia mara Jiu ke nagho, a Jekob, ke hea a dathegna a Josep. ");
INSERT INTO bgt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Ingengeni ke mono na seu nigna a Jekob. Jisas ke vano me nohe ghaghireigna na seu eigna imanea ke babao ghohi na taetaveti. Kori vido iangeni nabagna tangi salaghe rua kori hotaghi dani. Leghugna mara nigna na vaovarongo a Jisas kena taveti vano kori meleha bali volia ghadia vanga, sina vaivinegna i Samaria ke mai kori seu bali toitoi bea. Ma Jisas ke kaea, “Tanomana koda heu mai na bea bali kou ghagua?” ");
INSERT INTO bgt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Na vaivine iangeni ke veregna puala eigna mara Jiu kena bosi magnahaghinia na mono haidu duadia mara Samaria. Iia ke veleagna a Jisas, “Ighoe na mane Jiu mi nau na vaivinegu i Samaria. Ehava gi o kaeu eigna kuda hegho ghamua kou?” ");
INSERT INTO bgt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","A Jisas ke veleagna, “Ighoe ko boi adoa na hava a God ke magnahaghinia keda hegho, mo boi adoa mua ahai ke kaegho na bea. Gi koda adoa, ighoe koda kaeu eigna kuda hegho na bea i havi.” ");
INSERT INTO bgt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na vaivine iangeni ke veleagna a Jisas, “Mane puhi, na seu ke horu puala kari teo sa nimua na seuseu. Ivei koda hatia na bea i havi iangeni? ");
INSERT INTO bgt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iaani na seu a hutuda Jekob ke heghami mi manea ma ara dathegna ma nigna na komi fata kaukagu kena kou hahali kori bea iaani. Ehava? Ighoe ko toatogha ko nagho vano tagna a Jekob?” ");
INSERT INTO bgt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma Jisas ke veleagna, “Arahai kedana kouvia na bea iaani, imarea kedana ghoi langasa. ");
INSERT INTO bgt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kari arahai kedana kouvia na bea inau kuda hera, imarea teo kedana ghoi langasa. Eigna na bea inau kuda hera keda vaghagna na bea ke fufutu kori havidia, ma na bea iangeni keda hera na havi ke teo na govugna.” ");
INSERT INTO bgt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma na vaivine ke ania, “Mane puhi, o heu mai na bea iangeni eigna kuda boi ghoi langasa mu kuda boi ghoi tabiru mai eeni bali toitoi bea.” ");
INSERT INTO bgt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ma Jisas ke ania, “O vano mo kilo maia a taumu.” ");
INSERT INTO bgt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Iia ke haghore tughua, “Inau e teo sa taugu.” Gi a Jisas ke veleagna, “E tutuni e teo sa taumu. ");
INSERT INTO bgt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Eigna ighoe ko taulaghi ghohi tadia e lima na mane, ma na mane ko mono duagna ikeagaieni bosi a taumu. Hee, na hava ko veleu e tutuni.” ");
INSERT INTO bgt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Gi na vaivine ke ania, “Mane puhi, ikeagaieni inau ku adoa ighoe sina profet. ");
INSERT INTO bgt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ighami mara i Samaria kiti maimanihihia a God kori suasupa iaani i Gerisim vaghagna kena eia ara hutumami. Keana ighamu mara Jiu koti velea Jerusalem na pukuni meleha bali maimanihihia a God na komi tinoni gougovu. O veleu, ivei ke jino?” ");
INSERT INTO bgt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ma a Jisas ke ania, “O vaututunia na hava kuda velegho ikeagaieni. Tagna na maghavu keda mai, ighamu i Samaria kotida boi maimanihihia a God kori suasupa iaani ba i Jerusalem. ");
INSERT INTO bgt_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ghamu i Samaria oti maimanihihia a God kari oti boi pukuni adoa imanea. Ighami mara Jiu huju kiti maimanihihia a God mua, kari iti pukuni adoa, eigna nigna na puhi a God bali vahavira na komi tinoni ke turughu itamami ighami mara Jiu. ");
INSERT INTO bgt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tagna na maghavu keda mai, nigna na komi pukuni tinoni a God kedana maimanihihia kori haehathe nigna na Tarunga ke Tabu ma na leghuagna na hava ke tutuni eigna a God. Ma na maghavu iangeni ke jufu mai ghohi. A Mama ke hirora arahai kena maimanihihia vaghagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Na vunegna a God na tarunga, imanea ke magnahaghinira arahai kena maimanihihia kedana maimanihihia kori haehathe nigna na Tarunga ke Tabu mi kori leghuagna na hava ke tutuni eigna imanea.” ");
INSERT INTO bgt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na vaivine ke velea, “Inau ku adoa a Vahavi keda mai, imanea kena kiloagna a Krais. Kori vido imanea keda mai, imanea keda unuhia na ghaghanadia na komi fata iraani itamami.” ");
INSERT INTO bgt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma Jisas ke ania, “Inau ku haohaghore duamu ikeagaieni, inau a Vahavi.” ");
INSERT INTO bgt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kori vido vamua iangeni mara na vaovarongo kena tabiru mai mena vere nidia puala a Jisas ke titiono duagna sina vaivine. Kari e teo sikei mane itadia kena huatia vaghagna iaani, “Na hava ko magnahaghinia na?” ba “Ehava gi o titiono duagna?” ");
INSERT INTO bgt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Na vaivine ke boa horua nigna na botolo bali toitoi bea me tabiru vano kori meleha. Me velera na komi tinoni ngengeni, ");
INSERT INTO bgt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Oti mai moti reghia na mane ke vele aua na komi fata gougovu inau ku eia. Da imanea a Vahavi!” ");
INSERT INTO bgt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kori vido iangeni na komi tinoni kena taveti au kori meleha, mena vano bali reghia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Gi ena jufu mai na komi tinoni tagna a Jisas, nigna na komi vaovarongo kena veleagna, “Velepuhi, o vanga.” ");
INSERT INTO bgt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","A Jisas ke anira, “E mono mua ghagua na vanga ighamu koti boi adoa.” ");
INSERT INTO bgt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Gi mara nigna na vaovarongo kena veihuahuatighi, “Ehava? Sa tinoni ke hea ghohi na vanga?” ");
INSERT INTO bgt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A Jisas ke anira, “Na ghagua na vanga hiri, na leghuagna nigna na vanohehe a God, ma na vagovuagna na agutu ke heu mai na bali eia. ");
INSERT INTO bgt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ighamu oti adoa ghohi na haghore iaani kena velea na komi tinoni, ‘E vati mua na vula gi na komi sagharo keda ghano bali hathatanora.’ Keana inau ku veleghamu, oti dodoro toetoke tadia na komi gnatha. Eigna na komi sagharo ke ghano ghohi bali hathatanora. ");
INSERT INTO bgt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Arahai kena agutu bali hathatanora na komi sagharo kena hatia na volidia. Ma na komi sagharo kena hathatanora, iangeni na komi tinoni kena hatia na havi ke teo na govugna. Arahai kena joua na gnatha ma arahai kena hathatanora na komi sagharo, imarea kedana sakai totogo. ");
INSERT INTO bgt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Na haghore iaani ke tutuni ikeagaieni, ‘Sina mane ke joua me sina mane tavogha ke hathatanora na komi sagharo kori vido kena ghano.’ ");
INSERT INTO bgt_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Inau ku vetulaghamu bali hathatanora na komi sagharo kori gnatha koti boi joua. Arahai tavogha kena eia ghohi na agutu ke hutu, kari ighamu kotida hathatanora na komi sagharodia.” ");
INSERT INTO bgt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sethe na komi tinonidia Samaria kori meleha iangeni kena vaututunia Jisas eigna na vaivine iangeni ke velera, “Na mane iangeni ke vele aua na komi fata gougovu inau ku eia.” ");
INSERT INTO bgt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Na vunegna iangeni, kori vido kena mai tagna a Jisas, imarea kena kaea eigna keda talu mono duadia kori melehadia. Ma Jisas ke mono duadia e rua na dani. ");
INSERT INTO bgt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Me sethe mua na tinoni ingengeni kena vaututunia eigna na komi fata ke velera a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Gi ena veleagna na vaivine iangeni, “Ikeagaieni, ighami kiti vaututunia Jisas eigna ighami kiti rongovia ghehemami, boi eigna vamua na komi fata ko veleghami. E tutuni, imanea hiri a Vahavi ke mai bali vahavira na komi tinoni kori maramagna.” ");
INSERT INTO bgt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Leghugna ke mono e rua na dani duadia mara i Samaria, a Jisas ke taveti au itadia me vano i Galili. ");
INSERT INTO bgt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","A Jisas ke velea ghohi, “Na komi tinoni kori pukuni melehagna na profet, imarea teo kedana ghaghana bohea.” ");
INSERT INTO bgt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mi kori vido a Jisas ke jufu kori provins i Galili, na komi tinoni ngengeni kena totogo puala na reghiagna. Kari imarea kena totogo eigna vamua kena reghia na komi fata ke eia a Jisas i Jerusalem kori vido kena vano ingengeni kori Laulahugna na Thovoliungi. ");
INSERT INTO bgt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kori vido a Jisas ke mono kori provins i Galili, imanea ke ghoi tabiru kori meleha i Kena, na meleha imanea ke eia na bea gi e vuhai waen. Kori meleha i Kapaneam, sina mane puhi kori gaumanegna i Rom ke mono ingengeni ma a dathegna mane ke vahaghi. ");
INSERT INTO bgt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Imanea ke rongovia a Jisas ke taveti au i Jiudea me mai jufu ghohi i Galili, me vano itagna i Kena. Imanea ke kae huhurua a Jisas eigna keda vano duagna i Kapaneam bali vatoke tabirua a dathegna ke haga thehe ghohi. ");
INSERT INTO bgt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","A Jisas ke velea, “Ehava? Ighamu kotida boi vaututuniu kuda boi eia na komi reghithehe?” ");
INSERT INTO bgt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Na mane puhi iangeni ke veleagna, “Mane puhi, o saisami mo mai gi e thehe a dathegu!” ");
INSERT INTO bgt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ma Jisas ke ania, “O vano tabiru kori vathemu. A dathemu keda havi!” Ma na mane iangeni ke vaututunia a Jisas me turughu tabiru vano kori vathegna. ");
INSERT INTO bgt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kori vido imanea ke taetaveti vano kori hangana, kekeha nigna na mane agutu kena mai pada mena veleagna a dathegna ke toke tabiru ghohi. ");
INSERT INTO bgt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Imanea ke huatira ingiha a dathegna ke toke tabiru, mi marea kena ania, “Na vahaghi ke govu itagna nabagna tangi sikei kori hinaota i gnotha.” ");
INSERT INTO bgt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Gi a tamagna na gari iangeni ke adoa iangeni na vidoi dani a Jisas ke veleagna, “A dathemu keda havi.” Ma na mane puhi iangeni ma na komi tinoni kena mono kori vathegna kena vaututunia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iangeni na varuagna na reghithehe ke eia a Jisas i Galili leghugna ke au mai kori provins i Jiudea. ");
INSERT INTO bgt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Leghugna iangeni, a Jisas ke vano i Jerusalem eigna sina nidia na laulahu mara Jiu. ");
INSERT INTO bgt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Koragna i Jerusalem sina maha i bea ke mono kena kiloagna Betsata kori haghoredia mara Jiu. Na maha i bea iangeni ke mono gharania na hagetha kena kiloagna, “Na Hagethagna na Sip.” Hilighagna na maha iangeni e lima na varada teve bali mamatho ke mono. ");
INSERT INTO bgt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Sethe na tinoni kena vahaghi kena nere tadia na komi varada irangeni. Kekeha ena doa, kekeha thehe na naedia, mi kekeha lae na tonodia. ");
INSERT INTO bgt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Sina mane tadia na komi tinoni kena mono ngengeni, imanea ke vahaghi e tolu hangavulu me alu na vinogha ghohi. ");
INSERT INTO bgt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kori vido a Jisas ke reghia me adoa imanea ke hau ghohi na vahaghigna, imanea ke huatiagna, “Ighoe ko magnahaghinia na tonomu keda toke tabiru?” ");
INSERT INTO bgt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Imanea ke haghore tughua a Jisas, “Mane puhi, e vahotha puala eigna e teo sa tinoni bali hatiu horu kori maha bea kori vido ke gneognebo. Leuleghu maghavu ku pipilia na vano horu kori bea, na tinoni tavogha ke kidi horu nigna ghohi.” ");
INSERT INTO bgt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Gi a Jisas ke ania, “Sokara hadi mo hatia na mathamu mo taveti!” ");
INSERT INTO bgt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kori vido vamua iangeni, imanea ke toke tabiru. Me hatia na mathagna me taveti. Na dani a Jisas ke eia na reghithehe iaani, na Sabat. ");
INSERT INTO bgt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Na vunegna iangeni mara puhidia mara Jiu kena veleagna na mane ke toke tabiru, “Iaani na Sabat! Nida na komi vetula kena lutigho na hulu matha.” ");
INSERT INTO bgt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kari imanea ke haghore tughura, “Na mane ke vatoke tabiruu ke veleu, ‘O hatia na mathamu mo taveti!’” ");
INSERT INTO bgt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mi marea kena huatiagna, “Ahai ke velegho eigna koda hatia na mathamu mo taveti?” ");
INSERT INTO bgt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kari na mane iangeni ke boi adoa na ahagna imanea ke vatoke tabirua, eigna na mavitu ke sethe ke mono ngengeni ma Jisas ke taveti nigna ghohi. ");
INSERT INTO bgt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Leghugna iaani a Jisas ke pada imanea kori Vathe ke Tabu nigna God me veleagna, “Ikeagaieni ighoe ko toke tabiru. O saghoi eia mua na koakoa eigna keda boi padagho sa fata ke dika vano tagna na vahaghi ke padagho i hau.” ");
INSERT INTO bgt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Gi na mane iangeni ke vano me velera mara puhidia mara Jiu a Jisas na mane ke vatoke tabirua. ");
INSERT INTO bgt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Turughu kori dani iangeni, mara puhidia mara Jiu kena haghore diadikala a Jisas eigna ke eia na komi fata vaghagna iangeni kori Sabat. ");
INSERT INTO bgt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kari a Jisas ke velera, “A Tamagu ke agutu tadia na komi dani gougovu mi nau ku eia vaghagna vamua ke eia imanea.” ");
INSERT INTO bgt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kori vido kena rongovia iangeni, imarea kena heta vano mua na hiroagna na puhi bali vatheheagna. Boi eigna vamua imanea ke boi leghua na vetulagna na Sabat. Kari eigna mua ke velea a God a Tamagna. Kori vido ke velea iangeni, imanea ke vananaba ghehegna duagna God. ");
INSERT INTO bgt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A Jisas ke velera mara puhidia mara Jiu, “Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Na Dathe ke boi tangomana na eiagna sa fata leghuagna na ghaghanagna ghehegna. Kari imanea ke eia vamua na hava ke reghia ke eia a Tamagna. Na hava ke eia na Mama, na Dathe keda eia mua. ");
INSERT INTO bgt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Na Mama ke dothovia na Dathe me tatelia vania na komi fata gougovu ke eia. Ma na Mama keda tateli vania na Dathe kekeha fata keda eia ke nagho vano tagna na vatoke tabiruagna na mane iaani. Mi ghamu kotida vere nimiu tadia na komi fata keda eia na Dathe. ");
INSERT INTO bgt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Vaghagna na Mama ke vasokaraghinira arahai kena thehe me hera na havi, na Dathe keda hera na havi tadia arahai ke vahira. ");
INSERT INTO bgt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na Mama ke boi fatea sa tinoni eigna imanea ke hea na mana na Dathe bali fatera na komi tinoni gougovu. ");
INSERT INTO bgt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Na Mama ke eia iangeni eigna ke magnahaghinia na komi tinoni kedana ghaghana bohea na Dathe vaghagna imarea kena ghaghana bohea imanea. Ahai ke boi ghaghana bohea na Dathe, imanea ke boi ghaghana bohea na Mama ke vetula maia. ");
INSERT INTO bgt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Oti vaovarongo toetoke tagna na fata ke tutuni iaani! Arahai kena rongovia na haghoregu mena vaututunia ahai ke vetulau mai, imarea kedana hatia na havi ke teo na govugna. Mi nau kuda boi fatera eigna na komi paluhadia. Imarea kena taveti sania ghohi na thehe mena vano kori havi. ");
INSERT INTO bgt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Moti vaovarongo mua tagna na fata ke tutuni iaani. Tagna na maghavu keda mai arahai kena leghua na hangana ke vano kori thehe ke teo na govugna, imarea kedana rongovia na haghoregna a Dathegna God. Ma arahai itadia kedana vaututunia, imarea kedana hatia na havi ke teo na govugna. Ma na maghavu iangeni ke jufu mai ghohi. ");
INSERT INTO bgt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Na Mama ke mono nigna na mana bali hera na komi tinoni na havi ke teo na govugna. Mi manea ke hea na Dathe na mana eigna keda hera mua na komi tinoni na havi iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Imanea ke hea mua na mana bali fatera na komi tinoni, eigna imanea na Dathei Tinoni ke mai tagna a God. ");
INSERT INTO bgt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Oti saghoi vere nimiu tagna iangeni. Eigna tagna na maghavu keda mai, arahai kena thehe ghohi kedana rongovia na haghoregna a Dathegna God. ");
INSERT INTO bgt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Kori vido iangeni imarea kedana au mai tadia na komi beku. Ma arahai kena eia na komi fata ke jino kedana ghoi havi tabiru me kedana havi hahali duagna a God. Keana arahai kena eia na komi fata ke dika kedana ghoi havi tabiru, ma na Dathe keda fatera me vetulara vano kori meleha papara. ");
INSERT INTO bgt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Inau boi tangomana kuda eia sa fata leghuagna na ghaghanagu ghehegu. Inau ku fatera na komi tinoni leghuagna na hava ke veleu a God. Ma na fate inau ku eia e jino eigna inau u boi eia vamua na hava ku magnahaghinia, kari inau ku fatera na komi tinoni leghuagna na hava ke magnahaghinia a God ke vetulau mai.” ");
INSERT INTO bgt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Gi a Jisas ke velera mara puhidia mara Jiu, “Gi inau vamua kuda titionou eigu ghehegu, e teo sa vunegna kotida vaututunia na hava ku titionoa. ");
INSERT INTO bgt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kari a Tamagu ke titiono mua eigu inau, mi nau ku adoa na komi fata imanea ke titionoa e tutuni. ");
INSERT INTO bgt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Ighamu koti vetulara ghohi kekeha tinoni bali vano vaovarongo tagna a Jon Siuvitabu. Ma na komi fata imanea ke titiono eigu inau e tutuni. ");
INSERT INTO bgt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Na komi titiono eigu inau kena eia na komi tinoni, boi na fata ke nagho itagua. Kari inau ku veleghamu na hava ke velea a Jon eigna kotida adoa na puhi bali hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","A Jon ke vaghagna na lui ke raraha puala ke tateli aua na hava ke tutuni eigu inau. Mi ighamu koti totogo na mono kori raraha iangeni sina ghathi vido iso. ");
INSERT INTO bgt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Kari e mono mua na fata ke tavogha ke nagho vano tagna na titiono ke eia a Jon. Irangeni na komi agutu na Mama ke heu mai eigna kuda eira, mi ikeagaieni inau ku eira. Na komi agutu irangeni ke tateli aua na Mama ke vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma na Mama ke vetulau mai, imanea ke titiono ghohi eigu inau. Kari ighamu oti boi rongovia na haghoregna moti boi reghia imanea kori matamiu. ");
INSERT INTO bgt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ighamu koti boi kalitia na haghoregna kori havimiu, eigna ighamu koti boi vaututunia ahai imanea ke vetula maia. ");
INSERT INTO bgt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ighamu koti ijumi toetokea na komi Rioriso ke Tabu eigna ighamu koti ghaghana gi kotida eia iangeni, ighamu kotida pada na hangana bali hatia na havi ke teo na govugna. Na komi Rioriso ke Tabu kena titionoa eigu inau, ");
INSERT INTO bgt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","kari ighamu koti bosi magnahaghinia kotida mai itagua bali hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Inau ku bosi hiroa tadia na komi tinoni na kilothabaugna, ");
INSERT INTO bgt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","eigna inau ku adoa ighamu koti boi dothovia a God kori havimiu. ");
INSERT INTO bgt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Inau ku mai duagna na mana nigna a Tamagu, kari ighamu koti bosi magnahaghina kotida vaovarongo itagua. Keana gi na tinoni tavogha keda mai duagna nigna na mana ghehegna vamua, ighamu kotida sasaa na vaovarongo itagna. ");
INSERT INTO bgt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ighamu koti magnahaghinia vamua na komi tinoni kedana kilothabaghamu. Keana, gi keda boi kilothabaghamu a God, e toke vamua itamiu. Na vunegna iangeni e vahotha puala kotida vaututuniu. ");
INSERT INTO bgt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Oti saghoi toatogha inau kuda toroghamu kori matagna na Mama. Teo! A Moses, ighamu koti vaututunia keda hatheghamu, imanea keda toroghamu. ");
INSERT INTO bgt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Gi ighamu kotida pukuni vaututunia a Moses, ighamu kotida vaututuniu mua inau, eigna imanea ke risoa eigu inau. ");
INSERT INTO bgt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Keana na vunegna ighamu kotida boi vaututunia na komi fata ke risoa, teo kotida vaututunia na komi fata inau ku titionoa.” ");
INSERT INTO bgt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Leghugna a Jisas ke tabiru kori provins i Galili, imanea duagna nigna na komi vaovarongo kena hathavu sethevugna na kolo i Galili kena kiloagna mua na kolo i Tiberias. ");
INSERT INTO bgt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Na mavitu ke sethe kena lilihi mena vano jufu tagna ke vano a Jisas eigna imarea kena reghia na komi reghithehe ke eira bali vatoke tabirura arahai kena vahaghi. ");
INSERT INTO bgt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kori vido kena jufu sethevugna na kolo, a Jisas ma na nigna na komi vaovarongo kena vano hadi tagna sina suasupa mena nohe. ");
INSERT INTO bgt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kori vido iangeni na Laulahugna na Thovoliungi ke gharani mai ghohi. ");
INSERT INTO bgt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","A Jisas ke rei vano me reghia na mavitu ke sethe kena haidu mai itagna me ania a Filip, “Ivei katida volia na bred keda nabadia na komi tinoni iraani?” ");
INSERT INTO bgt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jisas ke velea iaani bali pipilia nigna na vaututuni a Filip, eigna imanea ke adoa ghohi na hava keda eia. ");
INSERT INTO bgt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","A Filip ke ania, “Toke katida tonogna na rongo ke sethe, boi nabagna na bred ke nabadia na mavitu iaani!” ");
INSERT INTO bgt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gi na mane vaovarongo a Andru, a tahigna a Saimon Pita, ke veleagna a Jisas, ");
INSERT INTO bgt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Sina gari mane iaani e lima ghagna na bred me rua ghagna na fei ke mono itagna. Kari teo keda nabadia na komi tinoni ke sethe iraani.” ");
INSERT INTO bgt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Gi a Jisas ke velera nigna na komi vaovarongo, “Oti velera na komi tinoni eigna kedana nohe.” Sethe na buburu ngengeni ma na komi tinoni kena nohe itagna. Koragna na mavitu iangeni, da e lima na togha i mane. ");
INSERT INTO bgt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Gi a Jisas ke hatia e lima na bred me veletokea a God me kemulia tadia na mavitu. Me eia mua vaghagna iangeni tagna e rua na igha. Ma na komi tinoni kena vanga mena mahu. ");
INSERT INTO bgt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Gi a Jisas ke velera nigna na komi vaovarongo, “Oti hathatanora na komi viovidoi vanga ke tomagha moti saghoi sonira.” ");
INSERT INTO bgt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Imarea kena hathatanora na komi viovidoi bred ke tomagha tagna e lima na bred mena vavonua salaghe rua na arao. ");
INSERT INTO bgt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Leghugna kena reghia na reghithehe iaani ke eia a Jisas, na komi tinoni kena velea, “E tutuni, na mane iaani na Profet a God ke taluhaghorea keda vetula maia kori maramagna.” ");
INSERT INTO bgt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","A Jisas ke adoa imarea kena magnahaghinia na huruagna eigna keda nidia na king. Na vunegna iangeni, imanea ke taveti sanira me vano hadi kori suasupa me mono ghehegna. ");
INSERT INTO bgt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kori lavigna, nigna na komi vaovarongo kena vano horu kori kolo mena pitua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kori vido ke puni ghohi, a Jisas ke boi jufu mua itadia. Mi marea kena hahaghe kori boti mena turughu vano kori meleha i Kapaneam sethevugna na kolo. ");
INSERT INTO bgt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kori vido iangeni na ghuri hutu ke padara me maghavu puala na kolo. ");
INSERT INTO bgt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kori vido mara na vaovarongo kena valuha au vano ghohi vaghagna e lima ba ono na kilomita, imarea kena reghia a Jisas ke taetaveti popogna na bea. Imanea ke mai gharania na boti mi marea kena mataghu nidia puala. ");
INSERT INTO bgt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Keana a Jisas ke haghore vanira, “Inau vamua iaani! Oti saghoi mataghu.” ");
INSERT INTO bgt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Gi ena sasaa na hatiagna imanea duadia kori boti. Kori vido vamua iangeni, imarea kena laba tagna na vido kena vano. ");
INSERT INTO bgt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kori vuevughei, na mavitu kena mono sethevugna na kolo kena toatogha a Jisas ke talu mono mua ngengeni. Eigna imarea kena adoa sikei vamua na boti ke mono ngengeni, kari a Jisas ke boi hahaghe duadia nigna na komi vaovarongo kori vido kena au sapa vano. ");
INSERT INTO bgt_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kekeha botigna i Tiberias kena eu torongaghi mai gharania na vido kena ghania na bred leghugna a Lod ke veletokea a God. ");
INSERT INTO bgt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kori vido na mavitu kena adoa a Jisas ma na nigna na komi vaovarongo kena teo ingengeni, imarea kena hahaghe tadia na komi boti kena eu mai, mena vano bali hiroa a Jisas i Kapaneam. ");
INSERT INTO bgt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kori vido kena torongaghi sethevugna na kolo, imarea kena pada a Jisas mena huatia, “Velepuhi, ingiha ghohi na maimu eeni?” ");
INSERT INTO bgt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma Jisas ke anira, “Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Ighamu koti hirou eigna vamua inau ku heghamiu moti mahu, boi eigna koti reghia na komi reghithehe ku eia. ");
INSERT INTO bgt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Oti saghoi agutu heta bali hatia na vanga ke boi hauhaugna me dika. Keana oti agutu heta eigna kotida hatia na vanga ke tangomana na heghamugna na havi ke teo na govugna. Na Dathei Tinoni keda heghamu na vanga iangeni eigna God na Mama ke hea na mana eigna keda eia iangeni.” ");
INSERT INTO bgt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Imarea kena ania, “Na hava a God ke magnahaghinighami kitida eia na?” ");
INSERT INTO bgt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","A Jisas ke haghore tughura, “A God ke magnahaghighamu kotida vaututunia ahai ke vetula maia.” ");
INSERT INTO bgt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mi marea kena ania, “Gi koda magnahaghinighami kitida vaututunigho, o eia sikei reghithehe. Na reghithehe hava ighoe koda eia vanighami na? ");
INSERT INTO bgt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","A Moses ke eia na reghithehe vanira ara hutuda i hau. Kori vido kena mono kori meleha ke gou, imanea ke hera ghadia na vanga ke horu mai i popo kena kiloagna “mana.” Iangeni ke vaghagna vamua kena risoa tadia na komi Rioriso ke Tabu, ‘Imanea ke hera ghadia na vanga ke horu mai i popo.’” ");
INSERT INTO bgt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","A Jisas ke anira, “Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Moses ke boi hera na vanga ke horu mai i popo kari a Tamagu ke hera. Mi ikeagaieni imanea ke heghamu na bred ke tutuni ke horu mai i popo. ");
INSERT INTO bgt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na bred ke tutuni nigna a God, imanea ke horu mai i popo me hera na havi ke teo na govugna na komi tinoni kori maramagna. ");
INSERT INTO bgt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Imarea kena veleagna a Jisas, “Mane puhi, o heghami hahali na bred iangeni.” ");
INSERT INTO bgt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ma Jisas ke anira, “Inau na bred i havi. Ahai ke mai itagua, imanea keda boi ghoi rofo. Ahai ke vaututuniu, imanea keda boi ghoi langasa. ");
INSERT INTO bgt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Keana, vaghagna ku veleghamu ghohi, toke ighamu koti reghiu ghohi, ighamu oti talu boi vaututuniu mua. ");
INSERT INTO bgt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kari arahai gougovu ke heu mai a Tamagu eigna kedana nigua na komi tinoni, imarea kedana mai itagua me teo kuda siriuhaghinira. ");
INSERT INTO bgt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Eigna inau ku horu mai i popo bali leghua nigna na vanohehe a Tamagu ke vetulau mai. Inau ku boi horu mai bali leghua na ghaghanagu ghehegu. ");
INSERT INTO bgt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma na nigna na vanohehe a Tamagu hiri iaani, inau kuda kaliti toetokera na komi tinoni imanea ke heu mai. Mi kori vagougovui dani inau kuda vasokara tabirura imarea irangeni kori thehe. ");
INSERT INTO bgt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Arahai kena ghithatha na Dathe mena vaututunia, a Tamagu ke magnahaghinira kedana hatia na havi ke teo na govugna. Mi kori vagougovui dani, inau kuda vasokaraghini tabirura kori thehe.” ");
INSERT INTO bgt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na komi tinoni kena turughu na haghore diadikalagna a Jisas eigna imanea ke velea, “Inau na bred ke horu mai i popo.” ");
INSERT INTO bgt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Imarea kena velea, “Imanea a Jisas vamua, a dathegna a Josep! Ighita kati adoa a tamagna ma idogna. Ehava gi e velea ke horu mai i popo?” ");
INSERT INTO bgt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","A Jisas ke anira, “Oti saghoi titiono vaghagna iangeni varihotaghimiu! ");
INSERT INTO bgt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Teo ahai ke tangomana na mai itagua gi keda boi batua maia itagua na Mama ke vetulau mai. Ma arahai kena mai itagua, inau kuda vasokaraghini tabirura kori thehe kori vagougovui dani. ");
INSERT INTO bgt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tadia na komi Rioriso ke Tabu kena risora mara na profet, imarea kena velea, ‘A God keda velepuhira mara gougovu.’ Arahai kena rongovia mena leghua na hava na Mama ke velepuhira, imarea kena mai itagua. ");
INSERT INTO bgt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ahai na Mama ke vetula maia, imanea vamua ke reghia na Mama. Teo ahai mua ke reghia. ");
INSERT INTO bgt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Ahai ke vaututuniu inau, imanea ke hatia ghohi na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Inau na bred i havi! ");
INSERT INTO bgt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Toke ara hutumiu i hau kena ghania na vanga kena kiloagna “mana” kori meleha ke gou, imarea kena thehe vamua. ");
INSERT INTO bgt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kari arahai kedana ghania na bred iaani ke horu mai i popo, imarea kedana boi thehe. ");
INSERT INTO bgt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Inau na bred i havi ke horu mai i popo. Arahai kedana ghania na bred iaani, imarea kedana havi thovohaliu. Ma na bred iaani na tonogu kuda lubatia vaghagna na havughaghi eigna kedana hatia na havi ke teo na govugna na komi tinoni kori maramagna.” ");
INSERT INTO bgt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma na komi tinoni kena rihu haohaghore varihotaghidia mena velea, “Ehava gi na mane iaani keda heghita na tonogna bali ghania na?” ");
INSERT INTO bgt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Gi a Jisas ke anira, “Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Gi ighamu kotida boi ghania na tonogna na Dathei Tinoni moti boi kouvia na ghaughabuagna, na havi ke teo na govugna teo keda mono itamiu. ");
INSERT INTO bgt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Arahai kena ghania na tonogu mena kouvia na ghaughabuagu, imarea kena hatia ghohi na havi ke teo na govugna. Mi inau kuda vasokaraghini tabirura kori vagougovui dani. ");
INSERT INTO bgt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Eigna na tonogu na pukuni vanga ma na ghaughabuagu na pukuni kou. ");
INSERT INTO bgt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Arahai kena ghania na tonogu mena kouvia na ghaughabuagu, imarea kena sikei duagu mi inau ku sikei duadia. ");
INSERT INTO bgt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na havi ke turughu mai tagna na Mama, mi imanea ke vetulau mai eeni. Inau ku havi eigna imanea, me vaghagna iangeni, arahai kena ghania na tonogu, imarea kedana hatia na havi eigna inau kuda hera. ");
INSERT INTO bgt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Inau ku boi vaghagna na bred kena ghania ara hutuda. Imarea kena ghania na bred iangeni kari ena thehe. Inau na bred ke horu mai i popo ma arahai kena ghania na bred iaani, imarea kedana havi thovohaliu.” ");
INSERT INTO bgt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Na komi fata iraani a Jisas ke titionoa kori vido ke velepuhira na komi tinoni kori nidia na vathe haidu mara Jiu i Kapaneam. ");
INSERT INTO bgt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kori vido kena rongovia na hava ke velea a Jisas, sethe na tinoni kena leghua a Jisas kena velea varihotaghidia, “Nigna na velepuhi iaani e boi jino. Teo ahai keda sasaa na leghuagna!” ");
INSERT INTO bgt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","A Jisas ke adoa imarea kena boi totogo eigna nigna na velepuhi mena titionoa varihotaghidia. Na vunegna iangeni, imanea ke anira, “Ehava gi oti boi nimiu na haga leghuugna eigna na velepuhi iaani? ");
INSERT INTO bgt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Gi keda ai na, na hava keda mono kori ghaghanamiu kori vido kotida reghia na Dathei Tinoni ke tabiru hadi i popo tagna ke mono i hau na? ");
INSERT INTO bgt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na Tarunga ke Tabu vamua ke tangomana na heragna na komi tinoni na havi ke teo na govugna. Na mana nigna na tinoni boi tangomana keda eia iangeni. Na komi fata ku titionoa vanighamu ke mai tagna na Tarunga ke Tabu. Ma na komi haghoregu ke tangomana na heghamugna na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Keana, kekeha itamiu kena boi vaututuniu.” (Kori turughugna nigna na agutu, a Jisas ke kidi adoa ghohi arahai kedana boi vaututunia, me adoa mua ahai keda peroa.) ");
INSERT INTO bgt_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma Jisas ke velea, “I hau inau ku veleghamu na vunegna kekeha itamiu kena boi vaututuniu. Imarea kena boi vaututuniu eigna teo ahai ke tangomana na mai itagua gi na Mama keda boi hati maia itagua.” ");
INSERT INTO bgt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Leghugna a Jisas ke velea iaani, sethe na tinoni kena leghua kena taveti sania mena boi magnahaghinia kedana leghua mua. ");
INSERT INTO bgt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Gi a Jisas ke huatira mara salaghe rua nigna na vaovarongo, “Ehava? Ighamu koti magnahaghinia kotida taveti saniu mua?” ");
INSERT INTO bgt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","A Saimon Pita ke haghore tughua, “Lod, ahai mua kitida leghua, eigna na komi haghoremu vamua ke heghami na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ighami kiti vaututunigho miti adoa ighoe na Mane Tabu ko mai tagna God.” ");
INSERT INTO bgt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Gi a Jisas ke anira, “Toke inau ku vahighamu ighamu salaghe rua nigua na vaovarongo, sikei itamiu na tidatho.” ");
INSERT INTO bgt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Imanea ke velea iaani eigna a Jiudas, a dathegna Saimon Iskariot. Toke imanea sikei tadia mara e salaghe rua na vaovarongo, imanea keda peroa a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Leghugna iangeni a Jisas ke taveti tadia na komi meleha kori provins i Galili. Imanea ke boi magnahaghinia keda vano i Jerusalem kori provins i Jiudea eigna mara puhidia mara Jiu ngengeni kena magnahaghinia kedana vathehea. ");
INSERT INTO bgt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na laulahu bali togha tabirua na maghavu ara hutudia mara Jiu kena mono kori baebale kori meleha ke gou ke gharani ghohi. ");
INSERT INTO bgt_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ara tahigna a Jisas kena mai itagna mena veleagna, “O taveti vano i Jerusalem kori provins i Jiudea tagna na laulahu, mo eia kekeha reghithehe eigna kedana reghia na komi tinoni kena leghugho. ");
INSERT INTO bgt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ahai ke magnahaghinia na ahagna keda rongoragha ivei mi vei, imanea keda saghoi poloa na hava ke eia. Gi koda tangomana na eiagna na komi reghithehe, o eia mekena reghia na komi tinoni gougovu.” ");
INSERT INTO bgt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Imarea kena velea iangeni eigna, toke imarea ara pukuni tahigna a Jisas, imarea kena boi vaututunia. ");
INSERT INTO bgt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ma Jisas ke anira, “Na nigua na maghavu kuda vano e boi jufu mai mua, kari ighamu tangomana kotida vano tagna sa maghavu koti magnahaghinia. ");
INSERT INTO bgt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Na komi tinoni kori maramagna, e teo sa vunegna kedana thevuioka itamiu, kari imarea kena thevuioka itagua eigna inau ku velera na komi puhidia ke dika. ");
INSERT INTO bgt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Oti vano tagna na laulahu iangeni. Inau teo kuda atu ikeagaieni, eigna e boi jufu mai mua nigua na maghavu.” ");
INSERT INTO bgt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Leghugna ke velea iaani, a Jisas ke talu mono mua i Galili. ");
INSERT INTO bgt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Leghudia ara tahigna ke vano kori laulahu, a Jisas huju e vano mua, kari e vano ghehegna eigna kedana boi reghia na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mara puhidia mara Jiu kena hiroa a Jisas kori laulahu mena huatia tadia na komi tinoni mena velea, “Ivei na mane iangeni?” ");
INSERT INTO bgt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Sethe na tinoni tadia na mavitu kena titiono varihotaghidia eigna a Jisas. Kekeha itadia kena velea, “Imanea na mane toke.” Kekeha kena haghore tughura, “Teo! Imanea ke pilaunira na komi tinoni.” ");
INSERT INTO bgt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kari teo ahai ke titiono eigna a Jisas naghodia na mavitu eigna kena mataghunira mara puhidia mara Jiu. ");
INSERT INTO bgt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Leghugna kekeha dani, kori vido imarea kena haga jufu ghohi hotaghigna na laulahu, a Jisas ke vano kori Vathe ke Tabu nigna God me velepuhira na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mara puhidia mara Jiu kena vere nidia puala tagna nigna na velepuhi mena velea, “Imanea ke boi pukuni sikolu toetoke eidia na komi fata koragna na komi Rioriso ke Tabu. Ehava gi e adoa puala na komi fata iraani?” ");
INSERT INTO bgt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","A Jisas ke anira, “Nigua na velepuhi boi na ghaghanagu ghehegu, kari e mai tagna a God ke vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ahai ke magnahaghinia na leghuagna nigna na vanohehe a God, imanea keda adoa nigua na velepuhi ke mai tagna a God ba e mai kori ghaghanagu ghehegu. ");
INSERT INTO bgt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ahai ke titionoa na ghaghanagna ghehegna, imanea ke magnahaghinia vamua na komi tinoni kedana veletokea. Kari ahai ke agutu heta eigna na komi tinoni kedana veletokea ahai ke vetula maia, nigna na haghore ke tutuni me teo sa piapilau itagna. ");
INSERT INTO bgt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ighamu koti adoa a Moses ke heghamu na komi vetula, kari teo sikei itamiu ke pukuni leghura. Ma na hava ke tutuni, ighamu koti vapuipuhi bali vatheheu!” ");
INSERT INTO bgt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Na mavitu kena ania, “Na tidatho ke mono ikoramu! Teo ahai ke vapuipuhi bali vathehegho.” ");
INSERT INTO bgt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A Jisas ke anira, “Sikei vamua na reghithehe koti reghia inau ku eia, moti vere nimiu puala eigna ku eia iangeni kori Sabat. ");
INSERT INTO bgt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kari ighamu huju oti eia mua na agutu kori Sabat kori vido koti leghua na vetulagna na sogivaughithatha a Moses ke heghamu. (Na vetula iangeni e boi turughu mai tagna a Moses, kari e turughu mai tadia ara hutumiu kena kidi mono gi e mono mai a Moses.) ");
INSERT INTO bgt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Gi na dani bali eia na sogivaughithatha keda mai kori Sabat, ighamu koti eia vamua bali leghua na vetula iangeni nigna a Moses. Gi kotida eia iangeni, ehava gi oti dikatamiu itagua eigna inau ku pukuni vatoke tabirua sina mane kori Sabat na? ");
INSERT INTO bgt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Oti saghoi fatea sa tinoni leghuagna na hava koti reghia vamua, kari oti fatea leghuagna na hava ke jino kori matagna a God.” ");
INSERT INTO bgt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kekeha tinonigna i Jerusalem kena titiono varihotaghidia eigna a Jisas vaghagna iaani, “Ehava? Iaani na mane mara puhida kena vapuipuhi bali vathehea? ");
INSERT INTO bgt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Reghia! Imanea ke titiono naghodia na mavitu, kari mara puhi kena boi velea sa fata itagna. Ehava? Oti ghaghana imarea kena toatogha imanea a Vahavi? ");
INSERT INTO bgt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kari imanea teo keda a Vahavi eigna ighita kati adoa na meleha imanea ke mai itagna. Kori vido a Vahavi keda mai, teo ahai keda adoa ivei tagna ke mai.” ");
INSERT INTO bgt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kori vido a Jisas ke talu velepuhira na komi tinoni kori Vathe ke Tabu, imanea ke haghore heta vanira, “Ighamu koti adou moti adoa mua na meleha ku mai itagna. Inau u boi mai leghuagna na ghaghanagu ghehegu, kari ahai ke vetulau mai, imanea ke tutuni. Ighamu koti boi adoa imanea, ");
INSERT INTO bgt_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","keana inau ku adoa eigna inau ku mai itagna, mi manea ke vetulau mai itamiu.” ");
INSERT INTO bgt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kori vido mara puhidia mara Jiu kena rongovia iangeni, imarea kena magnahaghinia kedana thotia, keana boi tangomana nidia eigna ke boi jufu mua nigna na maghavu. ");
INSERT INTO bgt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sethe na tinoni tadia na mavitu kena mono ngengeni kena vaututunia a Jisas kori vido iangeni mena velea, “Da imanea a Vahavi. Eigna teo ahai keda mai keda eia na komi reghithehe ke sethe vano tagna na komi reghithehe ke eia na mane iaani.” ");
INSERT INTO bgt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kori vido mara na Farise kena rongovia na komi fata irangeni kena titionoa na mavitu eigna a Jisas, imarea duadia mara na naghoi pris kena vetulara kekeha mara soldia kena kaekalea na Vathe ke Tabu eigna kedana thotia. ");
INSERT INTO bgt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Gi a Jisas ke velera na komi tinoni, “Inau kuda mono duamiu sina vido iso vamua, gi u ghoi tabiru vano tagna ahai ke vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Leghugna iangeni ighamu kotida hirou kari ighamu kotida boi padau. Na meleha kuda mono itagna ighamu boi tangomana kotida vano ngengeni.” ");
INSERT INTO bgt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mara puhidia mara Jiu kena veihuahuatighi, “Ivei keda vano na mane iaani gi keda vahothahaghinighita na padagna? Ehava? Imanea keda vano tadia na komi tinoni Jiu kena mono tadia na komi melehadia mara kena boi Jiu eigna keda velepuhira duadia mara kena boi Jiu? ");
INSERT INTO bgt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Na hava na ghaghana koragna na komi haghore iraani ke velea imanea: ‘Ighamu kotida hirou kari ighamu kotida boi padau,’ ma ‘Na meleha kuda mono itagna, ighamu boi tangomana kotida vano ngengeni’?” ");
INSERT INTO bgt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na vagovui danigna na laulahu bali togha tabiru na maghavu ara hutudia mara Jiu kena mono kori baebale, iangeni na dani ke nagho vano. Ma Jisas ke sokara hadi me haghore heta tadia na mavitu, “Gi kotida langasa, oti mai itagua eigna kuda vakoughamu! ");
INSERT INTO bgt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Eigna na komi Rioriso ke Tabu kena velea, “Ahai keda vaututuniu inau, na bea i havi keda fufutu au mai itagna.” ");
INSERT INTO bgt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Kori vido a Jisas ke titiono eigna na bea i havi, imanea ke titiono eigna na Tarunga ke Tabu keda hera arahai kena vaututunia. Keana kori vido iangeni imarea kena boi hatia mua na Tarunga ke Tabu, eigna a God ke boi tateli aua mua a Jisas ke thaba vano.) ");
INSERT INTO bgt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kori vido na komi tinoni kena rongovia na hava ke velea Jisas, kekeha itadia kena velea, “Tutuni, imanea na Profet a God ke taluhaghorea keda vetula maia!” ");
INSERT INTO bgt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kekeha kena velea, “Imanea a Vahavi.” Keana kekeha itadia kena velea, “A Vahavi teo keda au mai i Galili! ");
INSERT INTO bgt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Eigna na komi Rioriso ke Tabu kena velea a Vahavi keda havi mai kori vikegna a King Deved. Mi manea keda havi mai i Betlehem, kori melehagna a King Deved.” ");
INSERT INTO bgt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ma na ghaghanadia na komi tinoni e taotavogha eigna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kekeha kena magnahaghinia na thotiagna, kari boi tangomana nidia. ");
INSERT INTO bgt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mara na soldia kena kaekalea na Vathe Tabu kena tabiru vano tadia mara na naghoi pris mi mara na Farise. Mi marea kena huatira na komi soldia, “Ehava koti nia boi thotia a Jisas moti hatia maia eeni?” ");
INSERT INTO bgt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Imarea kena anira, “Ighita ati boi rongovia sa tinoni ke titiono vaghagna na tinoni iangeni!” ");
INSERT INTO bgt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Gi mara na Farise kena velera mara na soldia, “Ehava? A Jisas ke pilaunighamu mua? ");
INSERT INTO bgt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Teo sikei mane itamami ghami mara na Farise ba mara na naghoi pris ke vaututunia na mane iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Na mavitu ke mee vamua! Imarea kena leghua eigna ena boi pukuni thaothadoghagna na komi vetula nigna Moses. A God keda vaparara!” ");
INSERT INTO bgt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas, na mane Farise ke mai ghehegna tagna a Jisas i hau, imanea ke mono ngengeni me velera, ");
INSERT INTO bgt_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Na nida vetula ke velea ighita boi tangomana katida fatea sa tinoni kori vido kati boi rongovi tokea mua nigna na titiono bali adoa na hava ke ei hahia imanea.” ");
INSERT INTO bgt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Gi imarea kena veleagna, “Ighoe ko titiono vaghagna ighoe huju eimu i Galili! Gi ighoe koda ijumi toetokea na komi Rioriso ke Tabu, ighoe koda adoa e teo sa profet keda au mai i Galili.” ");
INSERT INTO bgt_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Govu, gi imarea kena tabiru tadia na komi vathedia. ");
INSERT INTO bgt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","A Jisas ke taveti au kori Vathe ke Tabu me vano kori Suasupa i Ghai Olev. ");
INSERT INTO bgt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kori vuevugheigna hadi, a Jisas ke ghoi tabiru vano kori Vathe ke Tabu. Na mavitu ke sethe kena haidu mai itagna, ma Jisas ke nohe me velepuhira. ");
INSERT INTO bgt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Gi kekeha mara na velepuhigna na vetula nigna Moses mi kekeha mara na Farise kena hati maia sina vaivine taulaghi kena reghia ke nere duagna sina mane ke boi a taugna. Mi marea kena vasokaraghinia naghodia na mavitu. ");
INSERT INTO bgt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Gi imarea kena veleagna a Jisas, “Velepuhi, na vaivine iaani, imarea kena reghia iia ke nere duagna na mane ke boi a taugna. ");
INSERT INTO bgt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na komi vetula nigna Moses kena velea ighita katida piri vathehea na vaivine keda eia iangeni. Ehava kori ghaghanamu ighoe na?” ");
INSERT INTO bgt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Imarea kena eia na huahuati iangeni eigna kena magnahaghinia a Jisas keda velea sa fata ke boi jino. Gi keda eia iangeni, imarea kedana fatea. Jisas ke boi haghore tughura, kari imanea ke pogho horu me rioriso kori thepa tagna na kaukaugna. ");
INSERT INTO bgt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Imarea kena huatia mena huatia, gi a Jisas ke sokara hadi me anira, “Ahai itamiu ke boi eia sa koakoa, imanea keda kidi piria vanoa na vaivine iangeni.” ");
INSERT INTO bgt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Gi a Jisas ke ghoi pogho horu me rioriso kori thepa. ");
INSERT INTO bgt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Leghugna kena rongovia iaani, imarea gougovu kena sopa taveti au tagna na vido iangeni, turughu tadia mara kena kuekue. Gi a Jisas ma na vaivine vamua koro talu mono ngengeni. ");
INSERT INTO bgt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","A Jisas ke ghoi sokara hadi me huatia na vaivine iangeni, “Ivei imarea kena torogho? Ehava? Teo sikei itadia ke fategho bali vathehegho?” ");
INSERT INTO bgt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Na vaivine iangeni ke velea, “Mane puhi, Teo sikei.” Ma Jisas ke veleagna, “Inau huju boi fategho bali vathehegho. O vano mo saghoi eia mua na koakoa.” ");
INSERT INTO bgt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Gi a Jisas ke ghoi titiono tadia na komi tinoni me velera, “Inau na raraha tadia na komi tinoni kori maramagna. Gi ighamu kotida leghuu inau, e teo kotida mono kori puni, eigna na raraha ke heghamu na havi keda mono itamiu.” ");
INSERT INTO bgt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mara na Farise kena haghore vaghagna iaani, “Na komi fata ko velea eimu ghehemu, e vahothahaghinighami na vaututuniagna eigna teo ahai mua ke velea ke tutuni.” ");
INSERT INTO bgt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A Jisas ke anira, “Toke inau ku velea eigu ghehegu, na komi fata ku velea e tutuni. Eigna inau ku adoa ivei ku mai mi ivei kuda vano. Keana ighamu koti boi adoa ivei ku mai mi ivei kuda vano. ");
INSERT INTO bgt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ighamu koti fateu leghuagna na ghaghanagna na tinoni vamua, kari inau ku boi fatea sa tinoni. ");
INSERT INTO bgt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Gi kuda fatea sa tinoni, na fate ku eia keda tutuni, eigna inau ku boi fatea ghehegu na tinoni, kari na Mama ke vetulau mai, imanea ke mono duagu. ");
INSERT INTO bgt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na nimiu na vetula ke velea gi rua na mane koroda velea na titiono ke nanaba, e tutuni na hava koro velea. ");
INSERT INTO bgt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Inau hiri sikei ku titiono eigu ghehegu. Varuagna, na Mama ke vetulau mai.” ");
INSERT INTO bgt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Gi imarea kena huatia, “Ivei a Tamamu na?” A Jisas ke anira, “Ighamu koti boi adou moti boi adoa mua a Tamagu. Gi kotida adou, ighamu kotida adoa mua a Tamagu.” ");
INSERT INTO bgt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","A Jisas ke velera na komi fata iraani kori vido ke velepuhira na komi tinoni kori Vathe ke Tabu nigna God, hilighagna na vido bali sosoni rongo. Me teo ahai ke thotia a Jisas, eigna e boi jufu mua nigna na maghavu. ");
INSERT INTO bgt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas ke velera mua mara puhidia mara Jiu, “Kenughua inau kuda taveti sanighamu. Ighamu kotida hirou kari ighamu kotida boi padau. Ighamu kotida thehe kari a God keda boi talutavogha na komi paluhamiu. Na meleha kuda vano itagna, ighamu teo kotida jufungia.” ");
INSERT INTO bgt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mara puhidia mara Jiu kena haohaghore ghehedia vaghagna iaani, “Ehava? Imanea keda vathehea ghehegna? Da iangeni na vunegna imanea ke veleghita, ‘Ighamu kotida hirou kari na meleha kuda vano itagna, ighamu teo kotida jufungia.’” ");
INSERT INTO bgt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","A Jisas ke anira, “Ighamu eimiu i thepa eeni mi inau eigu i popo. Ighamu eimiu kori maramagna iaani, kari inau boi eigu kori maramagna. ");
INSERT INTO bgt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iangeni na vunegna inau ku veleghamu ighamu kotida thehe kari a God keda boi talutavogha na komi paluhamiu. Gi kotida boi vaututuniu inau ahai ku veleghamu, ighamu kotida thehe kari a God keda boi talutavogha na komi paluhamiu.” ");
INSERT INTO bgt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Imarea kena huatia, “Ahai ighoe na?” Ma Jisas ke haghore tughura, “Inau ahai ku veleghamu hahali, turughu kori vido ku turughua nigua na agutu. ");
INSERT INTO bgt_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","E sethe na fata inau tangomana kuda velea bali fateghamu. Keana inau ku velera na komi tinoni na komi fata vamua ku rongovia tagna ahai ke vetulau mai. Mi manea ke velea na hava ke tutuni.” ");
INSERT INTO bgt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Imarea kena boi thaothadoghagna a Jisas ke titiono vanira eigna a Tamagna. ");
INSERT INTO bgt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Na vunegna iangeni a Jisas ke anira, “Kori maghavu ighamu kotida boa hadia na Dathei Tinoni kori ghai, ighamu kotida adoa inau ahai ku veleghamu. Mo kotida adoa mua inau ku boi eia sa fata leghuagna na ghaghanagu ghehegu, kari inau ku velea vamua na hava a Tamagu ke velepuhiu. ");
INSERT INTO bgt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ahai ke vetulau mai ke mono duagu hahali. Imanea ke boi taveti saniu eigna ku eia hahali na hava ke vatotogoa.” ");
INSERT INTO bgt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kori vido kena rongovia na komi fata iraani ke titionoa a Jisas, sethe na tinoni kena vaututunia. ");
INSERT INTO bgt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","A Jisas ke velera na komi tinoni Jiu kena velea kena vaututunia, “Gi ighamu kotida leghua hahalia nigua na velepuhi, ighamu kotida pukuni nigua na komi vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ighamu kotida adoa na hava ke tutuni eigna a God, ma na hava ke tutuni keda vamamaluhaghamu.” ");
INSERT INTO bgt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mi marea kena ania a Jisas, “Ighami ara vikegna a Ebraham. Turughu i hau me jufu ikeagaieni ighami kiti boi nigna na komi tinoni seka ahai kori maramagna. Ehava gi o velea ighami kitida mamaluha na?” ");
INSERT INTO bgt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","A Jisas ke haghore tughura, “Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Ahai ke eia na koakoa hahali, imanea na tinoni seka nigna na koakoa. ");
INSERT INTO bgt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Imarea kena boi velea na tinoni seka a dathegna na vunaghigna. Kari a dathegna na vunaghi iangeni, imarea kena velea imanea a pukuni dathegna hahali. ");
INSERT INTO bgt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Gi a Dathegna God keda vamamaluhaghamu kori koakoa, ighamu kotida pukuni mamaluha moti pukuni ara dathegna a God. ");
INSERT INTO bgt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Inau ku adoa ighamu na vikegna a hutuda Ebraham, keana kekeha itamiu ighamu koti magnahaghinia kotida vatheheu eigna ighamu koti boi hatia nigua na velepuhi kori havimiu. ");
INSERT INTO bgt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Inau ku titionoa itamiu na komi fata a Tamagu ke tatelia vaniu, kari ighamu koti leghua vamua na hava ke veleghamu a tamamiu.” ");
INSERT INTO bgt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Imarea kena veleagna, “A Ebraham a tamamami.” Gi a Jisas ke velera, “Teo. Gi ighamu kotida pukuni ara dathegna a Ebraham, ighamu kotida leghua nigna na puhi ke toke. ");
INSERT INTO bgt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Inau ku veleghamu na komi fata ke tutuni ku rongovia tagna a God, kari ighamu koti magnahaghinia kotida vatheheu. A Ebraham boi eia sa fata vaghagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Teo. Ighamu koti leghua nigna na puhi a pukuni tamamiu.” Mi marea kena ania, “A God vamua a pukuni Tamami, mi ghami ara pukuni dathegna.” ");
INSERT INTO bgt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","A Jisas ke anira, “Gi a God a pukuni Tamamiu, ighamu kotida dothoviu, eigna inau ku mai tagna a God eigna kuda mono eeni. Inau ku bosi mai leghua na ghaghanagu ghehegu, keana a God ke vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ighamu koti boi thaothadoghagna na komi fata ku titionoa eigna koti boi magnahaghinia na rongoviagna nigua na velepuhi. ");
INSERT INTO bgt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","A tamamiu a Satan. Mi ghamu koti magnahaghinia na eiagna na komi fata ke dika imanea ke magnahaghinia. Turughu kori turughugna a Satan ke ado vathehea na tinoni me boi magnahaghinia na hava ke tutuni eigna imanea ke vonungia na piapialu. Kori vido imanea ke piapilau, na pukuni puhigna ke tate au eigna imanea na mane piapilau, mi imanea a tamadia na komi piapilau gougovu. ");
INSERT INTO bgt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kori vido inau ku titionoa na hava ke tutuni, ighamu koti boi vaututuniu eigna ighamu ara dathegna! ");
INSERT INTO bgt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ahai itamiu ke tangomana na tateli auagna inau ku eia na koakoa? Gi inau ku velea na hava ke tutuni, ehava gi oti boi vaututuniu? ");
INSERT INTO bgt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Na komi tinoni nigna a God kena rongovia na komi haghoregna God. Keana ighamu koti boi rongovia eigna ighamu koti boi na komi tinoni nigna a God.” ");
INSERT INTO bgt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Gi na komi tinoni kena veleagna a Jisas, “E tutuni na hava kiti velea eimu ighoe. Ighoe na manemu i Samaria ma na tidatho ke mono ikoramu!” ");
INSERT INTO bgt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","A Jisas ke anira, “E teo sa tidatho ke mono ikoragu. Inau ku ghaghana bohea a Tamagu, kari ighamu oti boi ghaghana boheu. ");
INSERT INTO bgt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Inau ku boi magnahaghinia kuda vahaihadiu ghehegu, kari ahai tavogha ke magnahaghinia na vahaihadiugna. Mi manea keda fatera na komi tinoni gougovu. ");
INSERT INTO bgt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Vaovarongo toetoke tagna na fata ke tutuni iaani. Arahai kena leghua nigua na velepuhi, imarea kedana boi thehe.” ");
INSERT INTO bgt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Na komi tinoni kena veleagna, “Ikeagaieni ighami kiti pukuni adoa na tidatho ke mono ikoramu! A Ebraham mi mara na profet kena thehe ghohi, kari ighoe ko velea arahai kena leghua nimua na velepuhi, imarea teo kedana thehe! ");
INSERT INTO bgt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ehava? Kori ghaghanamu, ighoe ko nagho vano tagna a hutuda a Ebraham ma na komi profet kena thehe ghohi? Kori ghaghanamu, ahai ighoe na?” ");
INSERT INTO bgt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","A Jisas ke haghore tughura, “Gi inau kuda vahaihadiu ghehegu, na vahaihadiugna iangeni teo sa vunegna. Keana a Tamagu ahai ke vahaihadiu, mi ghamu koti velea imanea nimiu a God. ");
INSERT INTO bgt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ighamu koti boi adoa imanea, kari inau ku pukuni adoa imanea. Gi inau kuda velea ku boi adoa imanea, inau ku piapalau vaghagna ighamu koti piapilau. Kari inau ku adoa imanea mu leghua nigna na komi haghore. ");
INSERT INTO bgt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","A tamamiu a Ebraham ke totogo puala kenughua imanea keda reghia na maigu kori maramagna. Mi manea ke reghia me totogogna.” ");
INSERT INTO bgt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mi imarea kena velea, “Boi tutuni ighoe ko reghia a Ebraham! Eigna ighoe ko boi jufungia mua e lima hangavulu na vinoghamu.” ");
INSERT INTO bgt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","A Jisas ke haghore tughura, “Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Inau ku kidi mono ghohi, gi e havi mai a Ebraham!” ");
INSERT INTO bgt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kori vido a Jisas ke velea iangeni, na komi tinoni kena hatira na komi ghahira mena haga piria. Kari a Jisas ke boi lubatira kedana reghia me taveti au kori Vathe ke Tabu nigna God. ");
INSERT INTO bgt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas ke taveti vano kori hangana me reghia sina mane ke havi doa mai. ");
INSERT INTO bgt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nigna na komi vaovarongo a Jisas kena huatiagna, “Velepuhi, ehava? Na mane iaani ke doa eigna na komi paluhagna ghehegna ba na komi paluhadia a tamagna ma idogna?” ");
INSERT INTO bgt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ma Jisas ke velera, “Imanea ke doa, boi eigna na komi paluhagna ghehegna ba na komi paluhadia a tamagna ma idogna. Imanea ke doa eigna a God keda tateli au nigna na mana kori vido keda hathea imanea. ");
INSERT INTO bgt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kori vido ke dani mua, ati eia na agutu nigna ahai ke vetulau mai. Kari na bongi ke gharani mai ghohi ke boi tangomana sa tinoni keda eia sa agutu. ");
INSERT INTO bgt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kori vido inau ku mono mua kori maramagna, inau na raraha tadia na komi tinoni kori maramagna.” ");
INSERT INTO bgt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Leghugna ke velea iangeni, a Jisas ke angusu horu kori thepa me ngignoa na angusugna duagna na thepa me pila. Gi e havula kori matagna na mane ke doa. ");
INSERT INTO bgt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Gi e veleagna, “O vano mo daudanu kori maha i bea kena kiloagna Siloam.” (Na ghaghana koragna Siloam, ‘vetula vanoa’). Imanea ke vano me daudanu kori bea iangeni, mi kori vido ke tabiru kori vathegna, na matagna ke toke. ");
INSERT INTO bgt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na komi tinoni kena mono kori melehagna, ma arahai kena reghia kori vido ke kaekae rongo, imarea kena veihuahuatighi vaghagna iaani, “Ehava? Iaani na mane ke doa ke nohe me kakae rongo i hau?” ");
INSERT INTO bgt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kekeha kena velea, “Hii, imanea hiri.” Kekeha kena velea, “Teo, kari na dodorogna imanea ke haga nanaba tagna na dodorogna na mane iangeni.” Ma na mane ke kaekae rongo i hau ke velea, “Inau hiri na mane iangeni!” ");
INSERT INTO bgt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Imarea kena huatiagna, “Na hava ke padagho gi o dodoro ikeagaieni?” ");
INSERT INTO bgt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Imanea ke anira, “Na mane kena kiloagna Jisas ke hatia na thepa me havula kori matagu. Gi e veleu eigna kuda vano daudanu kori maha i bea i Siloam. Inau ku vano mu daudanu kori bea iangeni, gi e toke na matagu!” ");
INSERT INTO bgt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Gi ena huatia mua, “Ivei na mane iangeni?” Imanea ke velera, “U bosi adoa.” ");
INSERT INTO bgt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Gi kekeha tinoni kena hati vanoa na mane iangeni tadia mara na Farise. ");
INSERT INTO bgt_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na dani a Jisas ke havula na thepa kori matagna na mane iangeni me vatokea, na Sabat. ");
INSERT INTO bgt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kori vido mara na Farise kena adoa iangeni, imarea kena huatia na hava ke pada gi e tangomana na dodoro. Imanea ke anira, “Imanea ke havula na thepa kori matagu. Gi u vano mu daudanu, mi keagaieni inau ku tangomana na dodoro.” ");
INSERT INTO bgt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kekeha mara na Farise kena velea, “Na mane iangeni ke boi mai tagna God, eigna imanea ke agutu kori Sabat.” Keana kekeha kena velea, “Gi keda imanea na tinoni koakoa, teo keda eia na komi reghithehe vaghagna iangeni.” Mara na Farise kena boi sina ghaghanadia eigna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mena ghoi huatia mua na mane ke doa i hau, “Na vunegna imanea ke votokea na matamu, na hava ko ghaghana eigna imanea?” Imanea ke velera, “Imanea sina profet nigna a God.” ");
INSERT INTO bgt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mara puhidia mara Jiu kena boi vaututunia na mane iangeni ke doa i hau. Na vunegna iangeni, imarea kena kilora mai a idogna ma tamagna. ");
INSERT INTO bgt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Gi ena huatira roira, “E tutuni iaani a dathemiu? Ehava, imanea ke havi doa mai? Gi keda tutuni iangeni, ehava gi e tangomana na dodoro na?” ");
INSERT INTO bgt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A idogna ma tamagna koro velea, “Iroghami kuru adoa imanea a dathemami, muru adoa mua imanea ke havi doa mai. ");
INSERT INTO bgt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kari iroghami kuru boi adoa ehava gi e tangomana na dodoro ikeagaieni, muru boi adoa ahai ke vatokea. Oti huatia ghehemiu eigna imanea ke hutu ghohi me tangomana na titiono ghehegna.” ");
INSERT INTO bgt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Roira koro velea iangeni eigna koro mataghunira mara puhidia mara Jiu, eigna imarea kena kidi velea ghohi ahai keda velea a Jisas a Vahavi, imarea kedana boi lubatia na tinoni iangeni keda haghe kori vathe haidu bali maimanihihia a God. ");
INSERT INTO bgt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iangeni na vunegna iroira koro velea, “Oti kaea imanea eigna ke hutu ghohi me tangomana na titiono ghehegna.” ");
INSERT INTO bgt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Imarea kena ghoi kiloa maia mua na mane ke doa i hau mena ania, “O taluhaghore tagna a God na hava koda veleghami keda tutuni. Ighami kiti adoa na mane iangeni na mane koakoa.” ");
INSERT INTO bgt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Imanea ke haghore tughura, “Inau ku boi adoa imanea na mane koakoa ba teo. Sina fata vamua inau ku adoa, inau ku havi doa mai, kari ikeagaieni inau ku dodoro!” ");
INSERT INTO bgt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mi marea kena ania, “Na hava ke eia itamua na? Ehava nia na vatokeghogna na?” ");
INSERT INTO bgt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Imanea ke anira, “Inau ku veleghamu ghohi kari oti bosi vaututuniu. Ehava gi oti magnahaghinia kuda ghoi veleghamu na hava ke padau? Ehava? Ighamu huju oti magnahaghinia kotida nigna na mane vaovarongo?” ");
INSERT INTO bgt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Gi imarea kena pukuni haghore diadikala na mane iangeni mena veleagna, “Ighoe na nigna na mane vaovarongo, kari ighami nigna na mane vaovarongo a Moses! ");
INSERT INTO bgt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ighami kiti adoa a God ke haohaghore itagna a Moses, kari na mane iangeni, ighami iti boi adoa sa fata eigna imanea. Toke na meleha imanea ke havi mai itagna, ighami kiti boi adoa.” ");
INSERT INTO bgt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma na mane iangeni ke haghore tughura, “Inau ku vere nigua puala! Toke imanea ke vatokea na matagu, ighamu koti boi adoa na meleha ke au mai itagna! ");
INSERT INTO bgt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ighita kati adoa a God ke boi rongovia na komi tarai nidia mara kena dika, kari imanea ke rongovia nidia na komi tarai arahai kena ghaghana bohea mena leghua. ");
INSERT INTO bgt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kori turughugna na maramagna me jufu ikeagaieni, teo sa tinoni ke vatokea na tinoni ke havi doa mai. ");
INSERT INTO bgt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ma na mane iangeni teo keda eia iangeni gi keda boi mai tagna God.” ");
INSERT INTO bgt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Imarea kena veleagna, “Turughu kori vido ko havi mai, ighoe na tinoni koakoa! Me boi tangomana koda velepuhighami sa fata!” Gi ena gigi aua imanea kori vathe haidu. ");
INSERT INTO bgt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kori vido a Jisas ke rongovia imarea kena gigi aua na mane ke doa i hau, imanea ke vano me reghipada na mane iangeni. Gi e huatia, “Ehava? O vaututunia ghohi na Dathei Tinoni?” ");
INSERT INTO bgt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Na mane iangeni ke ania, “Mane puhi, o veleu ahai imanea eigna kuda vaututunia.” ");
INSERT INTO bgt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","A Jisas ke ania, “Ighoe ko reghia ghohi imanea. Ikeagaieni imanea hiri ke haohaghore duamu.” ");
INSERT INTO bgt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Imanea ke veleagna, “Lod, inau ku vaututunigho.” Gi imanea ke maimanihihia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ma Jisas ke ania, “Inau ku mai kori maramagna eigna na pukuni havidia na komi tinoni keda tate au. Inau ku mai eigna arahai kena doa kedana reghivaughithatha na hava ke tutuni eigna a God, ma arahai kena velea kena tangomana na dodoro, imarea kedana adoa kena pukuni doa.” ");
INSERT INTO bgt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kekeha mara na Farise kena sokara ngengeni kena rongovia na hava ke velea a Jisas mena huatiagna, “Ehava? Ighoe ko velea ighami kiti doa?” ");
INSERT INTO bgt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma Jisas ke anira, “Gi kotida adoa ighamu koti doa, a God keda talutavogha na komi paluhamiu. Kari na vunegna ighamu koti velea oti tangomana na dodoro, a God keda boi talutavogha na komi paluhamiu.” ");
INSERT INTO bgt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","A Jisas ke velea, “Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Ahai ke habira hadi kori peo me haghe tagna ke mono na komi sip kori bongi, me boi vano haghe kori hagetha, imanea na mane bilau. ");
INSERT INTO bgt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ighita kati adoa iangeni ke tutuni eigna na mane ke reireghia na komi sip ke vano haghe kori hagetha. ");
INSERT INTO bgt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ahai ke reireghia na hagetha kori bongi ke hangavia vania kori vido ke ghithatha. Na komi sip kena rongovia na haghoregna imanea ke reireghira mena leghua. Imanea ke kilora na ahadia nigna na komi sip me batura au kosigna na peo. ");
INSERT INTO bgt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kori vido imanea ke batura au nigna na komi sip gougovu, imanea ke taveti naghodia, ma na nigna na komi sip kena leghua eigna kena adoa na haghoregna. ");
INSERT INTO bgt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kari nigna na komi sip teo kedana leghua na tinoni tavogha gi imanea keda kilora. Na komi sip kedana ghogho sania eigna kena boi adoa na haghoregna.” ");
INSERT INTO bgt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","A Jisas ke velera na komi tinoni na titiono velepuhi iaani, kari imarea kena boi thaothadoghagna na ghaghanagna. ");
INSERT INTO bgt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Na vunegna iangeni a Jisas ke velera, “Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Inau na hagetha bali haghedia na komi sip. ");
INSERT INTO bgt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Arahai kena kidi mai nagho itagua, imarea kena magnahaghinia vamua na bilauragna na komi sip. Kari nigua na komi sip kena boi leghura. ");
INSERT INTO bgt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Inau na hagetha. Arahai kedana haghe mai itagua, inau kuda vahavira. Mi marea kedana vaghagna na komi sip kena boi mataghu na vano ma na mai ma na hiroagna ghadia na vanga. ");
INSERT INTO bgt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na mane bilau ke mai vamua eigna keda bilaura me vathehera me diadikalara na komi sip. Keana inau ku mai bali hera na komi tinoni na havi ke tutuni, iangeni na havi ke vonu tagna na komi fata ke toke. ");
INSERT INTO bgt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Inau na mane ku reireghi toetokera na komi sip. Na mane ke reireghi toetokera na komi sip ke sasaa na lubatiagna na havigna eidia nigna na komi sip. ");
INSERT INTO bgt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Na mane kena volia bali reireghia na komi sip, kori vido ke reghia na aku asi ke mai, imanea ke ghogho vamua. Imanea ke ghogho sanira na komi sip, eigna imanea ke boi tonogna na komi sip, mi manea boi na pukuni mane bali reireghia na komi sip. Kori vido imanea ke ghogho, na aku asi ke rihura na komi sip, ma na komi sip kena ghogho kilili. ");
INSERT INTO bgt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na mane kena volia bali reireghia na komi sip ke ghogho eigna imanea ke boi tonogna na komi sip, me boi na fata hutu itagna keda thehe na komi sip. ");
INSERT INTO bgt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Keana inau na mane ku reireghi toetokera na komi sip. Inau ku adoa nigua na komi sip vaghagna na Mama ke adou inau. Ma na nigua na komi sip kena pukuni adou inau vaghagna inau ku adoa na Mama. Inau ku lubatia na havigu eidia nigua na komi sip. ");
INSERT INTO bgt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kekeha nigua na komi sip kena boi mono mua koragna na peo iaani. Inau kuda hatira haghe mua. Imarea kedana leghua mua na haghoregu. Nigua na komi sip gougovu kedana sikei na boo i sip vamua me sikei na mane vamua keda reireghira gougovu. ");
INSERT INTO bgt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Na Mama ke pukuni dothoviu eigna inau ku lubatia na havigu. Inau ku eia iangeni eigna kuda ghoi havi tabiru. ");
INSERT INTO bgt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Teo ahai ke tangomana na hati auagna na havigu, gi kuda boi lubatia. Keana inau ku sasaa na lubatiagna na havigu. Inau ke mono nigua na mana bali lubatia na havigu mu mono nigua na mana bali ghoi havi tabiru, eigna iangeni na hava a Tamagu ke veleu kuda eia.” ");
INSERT INTO bgt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kori vido na komi tinoni kena rongovia na hava a Jisas ke velera, imarea kena boi sikei na ghaghanadia eigna imanea. ");
INSERT INTO bgt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kekeha itadia kena velea, “Na tidatho ke haghevia imanea me vameea. Oti saghoi rorongo itagna!” ");
INSERT INTO bgt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Keana kekeha itadia kena velea, “Na tinoni ke haghevia na tidatho teo keda velea na komi fata vaghagna iaani. Na tidatho teo keda vatokea na matagna na tinoni ke doa!” ");
INSERT INTO bgt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jisas ke mono i Jerusalem kori vido kena eia na laulahu bali togha tabirua na maghavu kena hangavia na Vathe ke Tabu nigna God. Na maghavugna na laulahu iangeni ke mono tadia na komi vula ke ghaula. ");
INSERT INTO bgt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mi koragna na Vathe ke Tabu, a Jisas ke taveti vano kori vido kena kiloagna na Varada nigna King Solomon. ");
INSERT INTO bgt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Na komi tinoni kena haidu kililivia mena ania, “E hau puala ghohi kari ighoe ko boi veleghami mua ahai ighoe. Gi ighoe a Vahavi, o veleghami mai vamua!” ");
INSERT INTO bgt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Gi a Jisas ke anira, “Inau ku veleghamu ghohi kari ighamu koti boi vaututuniu. Inau ku eia na komi reghithehe kori mana nigna a Tamagu. Ma na komi reghithehe irangeni kena tateli aua itamiu ahai inau. ");
INSERT INTO bgt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Keana ighamu koti boi vaututuniu eigna ighamu koti boi nigua na komi sip. ");
INSERT INTO bgt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nigua na komi sip kena rongovia na haghoregu. Inau ku adora mi marea kena leghuu inau. ");
INSERT INTO bgt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Inau ku hera na havi ke teo na govugna, me teo kedana vano kori thehe ke teo na govugna. Teo ahai ke tangomana keda hatira au itagua. ");
INSERT INTO bgt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","A Tamagu ke heu mai nigua na komi sip, imanea ke mana vano tadia arahai tavogha. Me teo ahai ke tangomana keda hatira au kori limagna a Tamagu. ");
INSERT INTO bgt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Inau ma a Tamagu, iroghami sikei vamua.” ");
INSERT INTO bgt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kori vido iangeni na komi tinoni kena ghoi hatia na komi ghahira eigna kedana piri vathehea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kari a Jisas ke anira, “Ighamu koti reghia inau ku eia na komi fata sethe ke toke a Tamagu ke veleu kuda eia. Ivei itadia na komi fata ke toke irangeni koti magnahaghinia na vatheheugna?” ");
INSERT INTO bgt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Imarea kena ania, “Ighami boi haga piri vathehegho eigna na komi fata ke toke ko eia, kari eigna vamua ighoe ko vahouhorua a God. Eigna ighoe na tinoni vamua, kari ighoe ko velea ighoe a God!” ");
INSERT INTO bgt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Gi a Jisas ke anira, “Tadia nimiu na komi Rioriso ke Tabu, imarea kena risoa horua a God ke velera mara kena batura nigna na komi tinoni, ‘Inau ku velea, ighamu na komi ghod.’ ");
INSERT INTO bgt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ighita kati adoa na komi fata gougovu ke mono tadia na komi Rioriso ke Tabu kena tutuni, ma God ke kilora na komi tinoni irangeni na komi ghod. ");
INSERT INTO bgt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Na vunegna iangeni, ehava gi oti velea ku vahouhorua a God kori vido ku velea inau a Dathegna a God na? Eigna inau hiri ahai a God ke vahiu me vetulau mai kori maramagna. ");
INSERT INTO bgt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Gi inau kuda boi eia na komi fata ke eia a Tamagu, oti saghoi vaututuniu. ");
INSERT INTO bgt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kari gi kuda eia na komi fata ke eia a Tamagu, toke kotida boi vaututunia na haghoregu, oti vaututunia na hava ku eia eigna kotida pukuni adoa a Tamagu ke mono duagu, mi inau ku mono duagna imanea.” ");
INSERT INTO bgt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Imarea kena ghoi magnahaghinia na thotiagna a Jisas, kari imanea ke taveti sanira. ");
INSERT INTO bgt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Gi a Jisas ke tabiru vano sethevugna na bea hutu i Jodan me mono tagna na vido a Jon ke siuvitabura na komi tinoni i hau. ");
INSERT INTO bgt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Me sethe na tinoni kena mai itagna. Imarea kena titiono varihotaghidia vaghagna iaani, “A Jon Siuvitabu ke boi eia sa reghithehe, kari na komi fata ke velea eigna na mane iaani e tutuni.” ");
INSERT INTO bgt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Sethe na tinoni kena mono ngengeni kena vaututunia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Sina mane na ahagna a Lasarus ke vahaghi. Lasarus ke mono i Betani duadia a Meri ma Mata, rua vaivinegna. A Meri iangeni, a Meri ke rotea na botolo oela ke ghuba toetokegna kori naegna a Jisas me vamumuja kori sesehui ulugna. ");
INSERT INTO bgt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","A Meri ma Mata koro vetula vanoa na haghore tagna a Jisas vaghagna iaani, “Lod, na mane ko dothovia puala ke vahaghi.” ");
INSERT INTO bgt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kori vido a Jisas ke rongovia iaani, imanea ke velea, “Na vahaghi ke pada a Lasarus, imanea teo keda thehe itagna. Imanea ke vahaghi eigna na komi tinoni kedana veletokea God ma a Dathegna.” ");
INSERT INTO bgt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas ke dothovia puala a Mata ma Meri ma Lasarus, ");
INSERT INTO bgt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","keana kori vido ke rongovia a Lasarus ke vahaghi, imanea ke mono e rua na dani mua tagna na vido ke mono. ");
INSERT INTO bgt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Gi e velera mara nigna na vaovarongo, “Ati atu mati tabiru i Jiudea.” ");
INSERT INTO bgt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mara nigna na vaovarongo kena ania, “Velepuhi, boi talu hau mua leghugna mara puhidia mara Jiu kori provins i Jiudea kena magnahaghinia kedana piri vathehegho. Ehava gi o magnahaghinia koda ghoi tabiru vano ingengeni?” ");
INSERT INTO bgt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisas ke haghore tughura, “Koragna sina dani, salaghe rua na aoa ke raraha. Ahai keda taetaveti kori dani, imanea keda boi pejuraghi eigna na aho ke raraha itagna. ");
INSERT INTO bgt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kari gi keda taetaveti kori bongi, imanea keda pejuraghi eigna e teo sa raraha bali hathea.” ");
INSERT INTO bgt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gi e velera mua, “A kulada a Lasarus ke nere, kari ikeagaieni inau ku vano itagna eigna kuda raraia.” ");
INSERT INTO bgt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mara nigna na vaovarongo kena ania, “Lod, gi keda nere, imanea keda toke vamua.” ");
INSERT INTO bgt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Imarea kena velea iangeni eigna kena ghaghana a Lasarus ke pukuni nere, kari a Jisas ke adoa ghohi a Lasarus ke thehe. ");
INSERT INTO bgt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ma Jisas ke vele jino vanira, “A Lasarus ke thehe ghohi. ");
INSERT INTO bgt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kari inau ku totogo ku boi mono ingengeni gi e thehe imanea, eigna na hava kotida reghia keda hatheghamu eigna kotida vaututuniu. Ati atu itagna.” ");
INSERT INTO bgt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","A Tomas, kena kiloagna mua Baso, ke velera mara na vaovarongo, “Ati atu, eigna katida thehe mua duagna Jisas.” ");
INSERT INTO bgt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kori vido a Jisas ke jufu i Betani, imarea kena veleagna e vati ghohi na dani ke haliu leghugna kena boa na tonogna a Lasarus kori luma. ");
INSERT INTO bgt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani e tolu na kilomita vamua na haugna i Jerusalem. ");
INSERT INTO bgt_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Me sethe na tinonigna i Jerusalem kena mai itadia a Mata ma Meri bali sulara eigna a toghadia Lasarus ke thehe. ");
INSERT INTO bgt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kori vido a Mata ke rongovia a Jisas ke mai gharani ghohi, iia ke vano tafoa. Keana a Meri ke talu mono kori vathe. ");
INSERT INTO bgt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","A Mata ke veleagna a Jisas, “Lod, gi ighoe koda mono ghohi eeni, a toghagu a Lasarus teo keda thehe. ");
INSERT INTO bgt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kari, toke ighoe ko boi mai gi e thehe imanea, inau ku adoa a God keda hegho na hava koda kaea.” ");
INSERT INTO bgt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","A Jisas ke veleagna, “A toghamu keda ghoi havi tabiru.” ");
INSERT INTO bgt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","A Mata ke ania, “Hii, inau ku adoa imanea keda ghoi havi tabiru kori vagougovui dani, kori vido a God keda vasokara tabirura na komi tinoni gougovu.” ");
INSERT INTO bgt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","A Jisas ke ania, “Inau ahai ku vasokara tabirura na komi tinoni mu hera na havi ke teo na govugna. Arahai kena vaututuniu, toke imarea kedana thehe, imarea kedana havi thovohaliu. ");
INSERT INTO bgt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na komi tinoni kena hatia na havi ke teo na govugna mena vaututuniu inau, imarea kedana boi pukuni thehe. Ehava? O vaututunia iaani?” ");
INSERT INTO bgt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","A Mata ke veleagna, “Hii Lod, inau ku vaututunigho ighoe a Vahavi, a Dathegna God. Ighoe ahai a God ke taluhaghorea keda vetula maia kori maramagna.” ");
INSERT INTO bgt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Leghugna a Mata ke velea iangeni, iia ke taveti sania a Jisas me tabiru vano kori vathegna. Iia ke kilo maia a Meri eigna koroda mono ghehedia me veleagna, “Na mane velepuhi ke jufu mai ghohi me magnahaghinia keda reghigho.” ");
INSERT INTO bgt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","A Meri ke sokara hadi saisami me turughu taveti vano tagna Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Kori vido iangeni a Jisas ke talu mono mua kosigna na meleha tagna ke titiono duagna a Mata. ");
INSERT INTO bgt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kori vido na komi tinoni kena mono duagna a Meri bali vasula kena reghia iia ke sokara hadi saisami me taveti au kori vathe, imarea kena leghua. Imarea kena ghaghana a Meri keda vano kori luma bali tangi. ");
INSERT INTO bgt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Keana a Meri ke jino vano tagna ke mono a Jisas. Kori vido ke reghia, iia ke torongaghi tuturu itagna me ania, “Lod, gi ighoe koda mono ghohi eeni, a toghagu a Lasarus teo keda thehe.” ");
INSERT INTO bgt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kori vido a Jisas ke reghia a Meri ke tangi ma na komi tinoni kena leghua kena tangi mua, imanea ke dikahehegna puala me boi toke na ghaghanagna. ");
INSERT INTO bgt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Imanea ke huatira, “Ivei koti talua na tonogna na?” Imarea kena ania, “Lod, o mai eigna koda atu reghia.” ");
INSERT INTO bgt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Gi a Jisas ke tangi. ");
INSERT INTO bgt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Arahai kena mono ngengeni kena velea varihotaghidia, “Reghia, imanea ke dothovia puala a Lasarus.” ");
INSERT INTO bgt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Keana kekeha itadia kena velea, “Iaani na mane ke vatoke tabirua sina mane ke doa. Ehava gi e boi mai me vatokea a Lasarus eigna keda boi thehe?” ");
INSERT INTO bgt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kori vido ke jufu kori luma kena boa na tonogna a Lasarus ikoragna, a Jisas ke ghoi dikahehegna puala. Na ghahira hutu ke bilakiagna na hagethagna na luma iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","A Jisas ke velea, “Oti kokopili aua na ghahira.” A Mata, na vaivinegna na mane ke thehe, ke veleagna a Jisas, “Lod, na tonogna imanea da e sibi dika puala ghohi, eigna e vati ghohi na dani leghugna ke thehe.” ");
INSERT INTO bgt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma Jisas ke veleagna a Mata, “Inau ku velegho ghohi ighoe koda reghia na mana nigna God gi koda vaututuniu.” ");
INSERT INTO bgt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Imarea kena kokopili aua na ghahira kori hagethagna na luma. A Jisas ke tada hadi i popo me velea, “Mama, inau ku veletokegho eigna ighoe ko rongovia nigua na tarai. ");
INSERT INTO bgt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Inau ku adoa ighoe ko rongoviu hahali, kari inau ku velea iaani eidia na komi tinoni kena mono eeni. Inau ku magnahaghinira kedana vaututunia ighoe ko vetulau mai.” ");
INSERT INTO bgt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Govu, gi a Jisas ke haghore heta, “Lasarus, o au mai!” ");
INSERT INTO bgt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ma a Lasarus ke au mai. Na pohe kena fifiriagna na limagna ma na naegna ma na pohe kena filehiagna na ulugna kena talu mono mua itagna. A Jisas ke velera na komi tinoni, “Oti hati aua itagna na komi pohe eigna keda taveti mamaluha.” ");
INSERT INTO bgt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sethe na tinoni kena mai bali sula a Meri, imarea kena reghia na fata ke eia a Jisas mena vaututunia. ");
INSERT INTO bgt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Keana kekeha kena boi vaututunia mena vano tadia mara na Farise. Imarea kena titionoa itadia na hava ke eia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mara na naghoi pris mi mara na Farise kena kilo haidura mai mara gougovu kena mono kori Kansol. Gi ena velera, “Na hava katida eia? Na mane iangeni e sethe ghohi na reghithehe ke eia. ");
INSERT INTO bgt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Gi ighita katida boi eia sa fata bali vasotoa, na komi tinoni gougovu kedana vaututunia. Gi keda ai, mara puhidia na gaumanegna i Rom kedana vetula maia nidia na komi soldia eigna kedana diadikala na Vathe ke Tabu nigna God ma na nida na komi tinoni.” ");
INSERT INTO bgt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sikei itadia, a Kaiafas, imanea na pukuni naghoi pris kori vinogha iangeni, imanea ke velera, “Oti hahi! ");
INSERT INTO bgt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ehava? Oti boi thaothadoghagna e toke sina mane vamua keda thehe tughura na komi tinoni? Gi keda thehe na mane iangeni, mara i Rom teo kedana vathehera nida na komi tinoni.” ");
INSERT INTO bgt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na fata iaani a Kaiafas ke vele aua ke boi au mai kori ghaghanagna ghehegna. Toke imanea ke boi vaututunia a Jisas a Vahavi, na vunegna imanea na pukuni naghoi pris kori vinogha iangeni, a God ke batua na ghaghanagna eigna keda vele aua a Jisas keda thehe eidia na komi tinoni Jiu. ");
INSERT INTO bgt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Keana a Jisas keda boi thehe eidia vamua na komi tinoni Jiu. Imanea keda thehe eigna keda hathatanora tagna sikei vamua na boo ara dathegna a God gougovu kena mono ivei mi vei kori maramagna. ");
INSERT INTO bgt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Turughu kori dani iangeni, mara puhidia mara Jiu kena vapuipuhi bali vathehea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Na vunegna iangeni a Jisas ke boi taveti vano mua kori matadia na komi tinoni i Jiudea. Keana imanea ke taveti au i Jerusalem duadia mara nigna na vaovarongo mena vano mono kori meleha i Efraim gharania na meleha ke gou. ");
INSERT INTO bgt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na Laulahugna na Thovoliungi ke gharani mai ghohi kori vido iangeni. Me sethe na tinoni tadia na komi meleha tavogha kena vano i Jerusalem gi e jufu mai na laulahu iangeni bali eia na puhi bali vararahara ghehedia kori koakoa ke velea kedana eia na komi vetula nigna a Moses. ");
INSERT INTO bgt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na komi tinoni kena hiroa a Jisas mi kori vido kena mono kori Vathe ke Tabu, imarea kena veihuahuatighi vaghagna iaani, “Ehava na ghaghanamiu na? Imanea keda mai kori Laulahugna na Thovoliungi ba teo?” ");
INSERT INTO bgt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Imarea kena velea iangeni eigna mara na naghoi pris mi mara na Farise kena velea ghohi gi ahai keda reghia a Jisas, imanea keda saisami velera eigna kedana thotia. ");
INSERT INTO bgt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","E ono na dani gi e jufu mai na Laulahugna na Thovoliungi, a Jisas ke tabiru vano i Betani, na melehagna a Lasarus, na mane a Jisas ke vahavi tabirua kori thehe. ");
INSERT INTO bgt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ingengeni imarea kena kalitia na vanga vania a Jisas bali ghaghana bohea. Mata ke hathera na keukemu vanga, ma Lasarus sikei itadia arahai kena nohe tagna na vido bali vanga duagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Gi Meri ke haghe mai duagna na botolo oela ke ghuba toetokegna me vahotha puala na voligna. Iia ke rotea tagna na naegna a Jisas gi e vamumuja tagna na sesehugna. Ma na komi tinoni gougovu kori vathe kena sibingia na oela iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","A Jiudas Iskariot, sikei itadia mara vaovarongo, ke mono ngengeni. Jiudas na mane keda peroa a Jisas. A Jiudas ke velea, ");
INSERT INTO bgt_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Keda salemua na botolo oela iangeni, iia keda hatia e tolu na hathangatu siliva. Kari hatia me kemulia vanira mara kena kuma.” ");
INSERT INTO bgt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A Jiudas ke velea iangeni boi eigna ke pukuni magnahaghinia na hatheragna mara na kuma, kari eigna imanea na mane bilau. Imanea na mane ke reireghia nidia na rongo mara na vaovarongo, me kekeha maghavu imanea ke bilaua kekeha. ");
INSERT INTO bgt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","A Jisas ke veleagna Jiudas, “Talua! A Meri ke kalitia na oela iaani bali kaikalitia na tonogu tagna na maghavu kedana giluu. ");
INSERT INTO bgt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mara na kuma kedana mono duamiu hahali. Keana inau, teo kuda mono duamiu hahali.” ");
INSERT INTO bgt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Sethe na tinoni kena rongovia a Jisas ke mono i Betani. Imarea kena vano ngengeni eigna kedana reghia Jisas ma Lasarus, na mane a Jisas ke vahavi tabirua kori thehe. ");
INSERT INTO bgt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mi mara na naghoi pris kena hiohiro puhi bali vathehea mua a Lasarus, ");
INSERT INTO bgt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","eigna kori vido kena reghia a Lasarus ke ghoi havi tabiru, sethe na tinoni kena vaututunia a Jisas mena bosi magnahaghinia kedana leghura mua mara na naghoi na pris. ");
INSERT INTO bgt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sina dani leghugna iangeni, na mavitu ke sethe kena mai i Jerusalem eigna na Laulahugna na Thovoliungi. Imarea kena rongovia a Jisas ke haga jufu mai ghohi ngengeni. ");
INSERT INTO bgt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mi marea kena vano ohoa na komi ghabagna na tubo mena taveti au kosigna Jerusalem eigna kedana vano tafoa a Jisas kori hangana. Imarea kena ghuu heta, “Hosana! God, o vathaba imanea ke mai duagna nimua na mana! Vatokea nimami na king gna i Israel!” ");
INSERT INTO bgt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","A Jisas ke hatia na dongki mathangani me nohe popogna, vaghagna vamua na komi Rioriso ke Tabu kena velea, ");
INSERT INTO bgt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saghoi mataghu ighamu na komi tinonidia i Jerusalem. Nimiu na king ke mai itamiu, imanea ke nohe popogna na dongki mathangani.” ");
INSERT INTO bgt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kori vido iangeni nigna na komi vaovarongo a Jisas kena boi thaothadoghagna na komi fata iraani. Kari leghugna ke sokara tabiru a Jisas ma God ke tatelia imanea ke thaba vano, imarea kena thaothadoghagna na komi fata iraani kena tate mai vaghagna vamua kena risoa tadia na komi Rioriso ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Sethe na tinoni kena vano tagna Jisas eigna imarea kena rongovia ghohi eigna na reghithehe ke eia a Jisas. Kori dani a Jisas ke vahavi tabirua a Lasarus kori thehe me kiloa au kori luma, sethe na tinoni kena reghia mena vano titionoa na rorongo iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mara na Farise kena titiono varihotaghidia, “Boi tangomana nida na eiagna sa fata! Reghia, na komi tinoni gougovu kena leghua imanea!” ");
INSERT INTO bgt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kekeha tinoni kena boi Jiu kena mono duadia na komi tinoni Jiu kena mai i Jerusalem bali maimanihihia a God kori vido kena eia na Laulahugna na Thovoliungi. ");
INSERT INTO bgt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Imarea kena vano tagna na mane vaovarongo a Filip, na melehagna i Betsaida kori provins i Galili. Imarea kena veleagna, “Mane puhi, ighami kiti magnahaghinia kitida reghia a Jisas.” ");
INSERT INTO bgt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip ke veleagna a Andru gi oro vano velea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ma Jisas ke velera, “Ikeagaieni e jufu mai ghohi na maghavu a God keda tateli aua tadia na komi tinoni na Dathei Tinoni ke thaba vano. ");
INSERT INTO bgt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Gi na katura keda boi sikili horu kori thepa me thehe, na katura iangeni teo keda sethe. Keana, gi keda thehe, na katura iangeni keda kotu me sagharo sethe. ");
INSERT INTO bgt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ahai ke dothovia puala na havigna ghehegna kori maramagna iaani, imanea teo keda hatia na havi ke teo na govugna. Kari ahai ke dothoviu vano inau tagna na havigna kori maramagna iaani, imanea keda hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ahai ke magnahaghinia keda agutu vaniu, imanea keda mai leghuu inau eigna keda mono duagu ivei tagna kuda mono. Ahai keda agutu vaniu, a Tamagu keda ghaghana bohea. ");
INSERT INTO bgt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ikeagaieni, na ghaghanagu ke papara puala. Na hava kuda tarai kaea a God na? Inau tangomana kuda velea, ‘Mama, o saghoi lubatiu gi kuda papara.’ Kari inau kuda boi eia iangeni eigna inau ku mai bali papara. ");
INSERT INTO bgt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Na vunegna iangeni Mama, o tateli aua tadia na komi tinoni ighoe ko thaba vano.” Gi na ohai haghore ke horu mai i popo me velea, “Inau ku tateli aua ghohi inau ku thaba vano mi nau kuda ghoi eia iangeni mua.” ");
INSERT INTO bgt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kori vido na komi tinoni kena rongovia iangeni, kekeha itadia kena velea kena rongovia na gumu, mi kekeha kena velea na enjel ke haohaghore itagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ma Jisas ke anira, “Na ohai haghore boi bali hatheu inau, kari bali hatheghamu ighamu. ");
INSERT INTO bgt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ikeagaieni na maghavu na pukuni havidia na komi tinoni keda tate au ke jufu mai ghohi. Mi ikeagaieni a God keda heta pungusia a Satan ke vunaghi pungusia na maramagna. ");
INSERT INTO bgt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kori vido imarea kedana bou hadi kori ghai popogna na thepa, inau kuda hathatanora mai na komi tinoni gougovu itagua.” ");
INSERT INTO bgt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Imanea ke velera iangeni eigna kedana thaothadoghagna na puhi imanea keda thehe. ");
INSERT INTO bgt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Na mavitu kena veleagna, “Ighami kiti adoa na komi Rioriso ke Tabu kena velea a Vahavi keda havi thovohaliu. Ehava gi o velea imarea kedana boa hadia na Dathei Tinoni? Ahai na Dathei Tinoni ko titionoa na?” ");
INSERT INTO bgt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","A Jisas ke anira, “Sina ghathi vido iso mua, na raraha keda mono duamiu. Na vunegna iangeni, oti taetaveti kori raraha kori vido ke mono mua na raraha duamiu eigna keda boi mai itamiu na puni. Eigna ahai ke taveti kori puni, imanea ke boi adoa ivei keda vano. ");
INSERT INTO bgt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Oti vaututunia na raraha kori vido ke mono mua duamiu eigna kotida ara dathegna na raraha.” Leghugna a Jisas ke velera iangeni, imanea ke taveti au tadia na mavitu me bosi lubatira kedana reghia. ");
INSERT INTO bgt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Toke a Jisas ke eia na komi reghithehe ke sethe naghodia na komi tinoni, sethe itadia kena boi vaututunia. ");
INSERT INTO bgt_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Iangeni ke tate au eigna keda tutuni na hava ke velea a profet Aisaia i hau. Imanea ke velea, “Lod God, boi sethe na tinoni kena vaututunia na rorongo kiti titionoa me boi sethe kena ghithatha nimua na mana ko tateli aua!” ");
INSERT INTO bgt_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Keana imarea kena boi tangomana kedana vaututuni, eigna a Aisaia ke velea vaghagna iaani, ");
INSERT INTO bgt_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“A Lod God ke vadoa na matadia eigna kedana boi reirei, me ponotia na ghaghanadia eigna kedana boi thaothadogha, mi marea kena boi tangomana nidia na tabiru mai itagna eigna keda vahavira.” ");
INSERT INTO bgt_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kori vido Aisaia ke velea iangeni i hau, imanea ke titionoa a Jisas, eigna a God ke tatelia vania imanea a Jisas keda thaba vano. ");
INSERT INTO bgt_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Toke sethe na tinoni kena boi vaututunia a Jisas, sethe mua kena vaututunia. Kekeha mara puhidia mara Jiu huju ena vaututunia mua, kari ena boi vele aua eigna imarea kena mataghunira mara na Farise. Imarea kena toatogha mara na Farise kenughua ena lutira na vano maimanihihiagna a God tadia na komi vathe haidu. ");
INSERT INTO bgt_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mara puhidia mara Jiu iraani kena magnahaghinia puala na komi tinoni kedana veletokera. Kari ena boi rae magnahaghinia a God keda veletokera. ");
INSERT INTO bgt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","A Jisas ke haghore heta vanira na komi tinoni, “Ahai ke vaututuniu inau, imanea ke boi vaututuniu inau vamua, kari imanea ke vaututunia mua a God ke vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ahai ke reghiu inau, imanea ke reghia mua ahai ke vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Inau ku mai vaghagna na lui ke raraha kori maramagna iaani eigna ahai ke vaututuniu inau keda boi mono hahali kori puni. ");
INSERT INTO bgt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ahai ke rongovia na haghoregu kari e boi leghua, inau kuda boi fatea. Eigna inau boi mai bali fatera na komi tinoni kori maramagna kari u mai bali vahavira. ");
INSERT INTO bgt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Keana ahai ke siriuhaghiniu inau ma na haghoregu, na komi haghoregu ku titionora kedana fatea imanea kori vagougovui dani. ");
INSERT INTO bgt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Eigna na komi fata ku titionoa, boi na ghaghanagu ghehegu. Keana na Mama ke vetulau mai ke veleu na hava kuda titionoa. ");
INSERT INTO bgt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mi nau ku adoa na havi ke teo na govugna ke au mai tagna na hava ke veleu kuda titionoa. Na vunegna iangeni, inau ku titionoa vamua na komi fata na Mama ke veleu kuda titionoa.” ");
INSERT INTO bgt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gi e jufu mai na Laulahugna na Thovoliungi, a Jisas ke adoa ghohi nigna na maghavu ke gharani mai ghohi bali taveti sania na maramagna iaani me tabiru vano tagna na Mama. Imanea ke dothovira hahali arahai kena leghua kori maramagna iaani, mi manea ke dothovira me ghieghilei thehe. ");
INSERT INTO bgt_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kori vido a Jisas ma na nigna na komi vaovarongo kena vanga kori lavi, a Satan ke agutu ghohi kori ghaghanagna a Jiudas, a dathegna Saimon Iskariot, eigna keda peroa a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","A Jisas ke adoa na Mama ke hea na mana bali vunaghi pungusira na komi fata gougovu, me adoa mua imanea ke mai tagna a God me keda ghoi tabiru vano itagna. ");
INSERT INTO bgt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Na vunegna iangeni, a Jisas ke sokara hadi me hati aua nigna na oopo. Gi e hatia na mamango me taria tagna na hotaghigna. ");
INSERT INTO bgt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Imanea ke rotea na bea kori disi me turughu lumia na naedia mara nigna na vaovarongo. Me vamumuja tagna na mamango ke taria tagna na hotaghigna. ");
INSERT INTO bgt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kori vido a Jisas ke mai tagna a Saimon Pita, a Pita ke ania, “Lod! Ehava? Ighoe koda lumia na naegu?” ");
INSERT INTO bgt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","A Jisas ke ania, “Ikeagaieni ighoe ko boi thaothadoghagna mua na hava ku eia, kari kenughua ighoe koda thaothadoghagna.” ");
INSERT INTO bgt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Gi a Pita ke veleagna, “Teo koda lumia na naegu!” Ma Jisas ke ania, “Gi inau kuda boi lumi vararahagho, ighoe teo koda nigua na tinoni.” ");
INSERT INTO bgt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","A Pita ke haghore tughua, “Lod, gi keda ai, o saghoi lumia na naegu vamua, kari o lumia mua na limagu ma na ulugu.” ");
INSERT INTO bgt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Gi a Jisas ke ania, “Gi keda garu na naegna ahai ke siusiu ghohi, imanea teo keda ghoi siusiu mua. Teo. Imanea keda lumia vamua na naegna. Ighamu koti raraha ghohi, kari boi ighamu gougovu.” ");
INSERT INTO bgt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","A Jisas ke adoa ghohi ahai itadia nigna na komi vaovarongo keda peroa. Iangeni na vunegna gi e velea boi imarea gougovu kena raraha. ");
INSERT INTO bgt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Leghugna ke govua na lumiagna na naedia, a Jisas ke vahaghea nigna na oopo me nohe. Gi e huatira, “Oti thaothadoghagna na hava ku eu eia itamiu? ");
INSERT INTO bgt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ighamu koti kilou ‘Velepuhi’ ma ‘Vunaghi,’ me tutuni na hava koti velea eigna inau nimiu a Lod, ma nimiu na Velepuhi. ");
INSERT INTO bgt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na vunegna inau, nimiu a Lod, ma na nimiu na Velepuhi, ku lumia na naemiu, ighamu ghua kotida veilumira na naemiu. ");
INSERT INTO bgt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Inau ku tatelia vanighamu na hava kotida leghua. Oti eia vaghagna ku eia itamiu. ");
INSERT INTO bgt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na hava ku veleghamu ikeagaieni e tutuni, teo sikei mane agutu ke nagho vano tagna na vunaghigna, me teo sikei mane bali titiono ke nagho vano tagna ahai ke vetula aua. ");
INSERT INTO bgt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ikeagaieni ighamu oti thaothadoghagna ghohi na hava ku velepuhighamu. Ma gi kotida ei leghua, a God keda vatokeghamu.” ");
INSERT INTO bgt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Inau ku boi titionoa na komi fata irangeni eimiu ighamu gougovu. Inau ku pukuni adoa na puhimiu ighamu gougovu ku vahighamu. Mi nau ku vahighamu eigna na vido rioriso iaani ke mono tadia na komi Rioriso ke Tabu keda tutuni, ‘Na mane ke vanga duagu, ikeagaieni imanea nigua na thevuioka.’ ");
INSERT INTO bgt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Inau ku velea iaani itamiu gi e tate mai, eigna ighamu kotida vaututuniu inau a Vahavi kori vido keda tate mai. ");
INSERT INTO bgt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Ahai keda kalitia sa tinoni inau ku vetula, imanea ke kalitiu. Ma ahai ke kalitiu inau, imanea ke kalitia ahai ke vetulau mai.” ");
INSERT INTO bgt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Leghugna a Jisas ke velea iangeni, na ghaghanagna ke boi toke me velera nigna na komi vaovarongo, “Inau ku titiono tutuni, sikei itamiu keda lubatiu vano tadia mara nigua na thevuioka.” ");
INSERT INTO bgt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mara na vaovarongo kena veidodorovighi varihotaghidia eigna kena boi adoa ahai a Jisas ke titionoa. ");
INSERT INTO bgt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na mane vaovarongo a Jisas ke dothovia puala ke nohe hilighagna a Jisas tagna kena vanga. ");
INSERT INTO bgt_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ma Saimon Pita ke haghore lima tagna na mane vaovarongo iangeni eigna keda huatia a Jisas ahai keda eia na puhi iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ma na mane vaovarongo iangeni ke ravi vano tagna Jisas me huatia, “Lod, ahai keda eia iangeni na?” ");
INSERT INTO bgt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A Jisas ke haghore tughua, “Leghugna inau kuda vagnubua na vidoi bred iaani kori disi, inau kuda hea vanoa tagna ahai keda lubatiu vano tadia mara nigua na thevuioka.” Gi a Jisas ke vagnubua na bred kori disi me hea vanoa a Jiudas, a dathegna Saimon Iskariot. ");
INSERT INTO bgt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kori vido a Jiudas ke hatia na bred iangeni, a Satan ke haghe koragna imanea. Ma Jisas ke veleagna a Jiudas, “Na hava koda eia, o saisami mo eia.” ");
INSERT INTO bgt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Teo sikei itadia mara kena mono ngengeni ke adoa ehava gi a Jisas ke haghore vaghagna iangeni tagna a Jiudas. ");
INSERT INTO bgt_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kekeha itadia kena ghaghana a Jisas ke veleagna a Jiudas eigna keda vano volia kekeha vanga kedana ghania kori laulahu, ba vano me hera na rongo mara kena kuma. Imarea kena ghaghana iangeni eigna a Jiudas ke reireghia nidia na rongo. ");
INSERT INTO bgt_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Leghugna a Jiudas ke ghania na bred iangeni, imanea ke taveti au itadia. Me bongi ghohi. ");
INSERT INTO bgt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Leghugna a Jiudas ke taveti au itadia, a Jisas ke anira, “Ikeagaieni a God keda tateli aua na Dathei Tinoni ke thaba, mi nau kuda tateli aua tadia na komi tinoni a God ke thaba mua. ");
INSERT INTO bgt_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na vunegna na Dathei Tinoni keda tateli aua tadia na komi tinoni a God ke thaba puala, a God keda tateli aua na Dathei Tinoni ke thaba puala mua. Mi manea keda boi poru na eiagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ara dathegu, sina ghathi vido iso mua inau kuda mono duamiu. Ighamu kotida hirou, kari ighamu kotida bosi padau. Vaghagna ku velera ghohi mara puhidia mara Jiu, ikeagaieni inau ku veleghamu mua, ‘Na meleha kuda vano inau itagna, ighamu boi tangomana kotida vano ngengeni.’ ");
INSERT INTO bgt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Inau ku heghamu na vetula mathangani. Oti veidothovighi. Vaghagna inau ku dothovighamu, oti veidothovighi mua vaghagna iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Gi ighamu kotida veidothovighi, na komi tinoni gougovu kedana adoa ighamu nigua na komi vaovarongo.” ");
INSERT INTO bgt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","A Saimon Pita ke huatia a Jisas vaghagna iaani, “Lod, ivei koda vano ighoe na?” A Jisas ke veleagna, “Ikeagaieni ighoe teo koda mai leghuu tagna na meleha kuda vano, kari ighoe koda leghuu ivughei valiha.” ");
INSERT INTO bgt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ma Pita ke ania, “Ehava gi o velea inau boi tangomana kuda leghugho ikeagaieni? Inau ku sasaa bali thehe eimu ighoe.” ");
INSERT INTO bgt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","A Jisas ke haghore tughua, “Ehava? E tutuni ighoe ko sasaa bali thehe eigu inau? Na hava ku velegho ikeagaieni e tutuni, teo keda taitangi mua na kokorako, mi ghoe koda tolu horui veleagna ighoe ko boi adou.” ");
INSERT INTO bgt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","A Jisas ke velera nigna na komi vaovarongo, “Oti saghoi lubatia na ghaghanamiu keda dika eigna na komi fata ku veleghamu irangeni. Kari oti vaututunia a God moti vaututuniu inau ghua. ");
INSERT INTO bgt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kori vathegna a Tamagu sethe na chogho koragna, mi nau kuda vano bali kalitira na komi chogho vanighamu. Gi keda boi tutuni, inau teo kuda veleghamu iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kori vido na komi chogho ke kaikaliti ghohi, inau kuda ghoi tabiru mai mu talangighamu eigna kotida mono duagu hahali ngengeni. ");
INSERT INTO bgt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ma na hangana ke vano tagna na vido kuda vano itagna, ighamu koti adoa ghohi na hangana iangeni.” ");
INSERT INTO bgt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ma a Tomas ke velea, “Lod, ighami kiti bosi adoa ivei koda vano. Me teo kitida adoa na hangana ke vano ngengeni!” ");
INSERT INTO bgt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","A Jisas ke haghore tughua, “Inau na hangana, ma na tutuni, ma na havi. Teo ahai keda jufu tagna na Mama gi imanea keda boi vaututuniu. ");
INSERT INTO bgt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Gi kotida pukuni adou inau, ighamu kotida adoa mua a Tamagu. Kari turughu ikeagaieni me vano, ighamu koti adoa imanea moti reghia ghohi.” ");
INSERT INTO bgt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","A Filip ke ania, “Lod, sina fata vamua kiti magnahaghinia. O tateli vanighami na Mama.” ");
INSERT INTO bgt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","A Jisas ke haghore tughua, “Filip, hau puala ghohi inau ku mono duamiu. Ehava gi o boi adou mua? Ahai ke reghiu inau, imanea ke reghia na Mama. Na vunegna iangeni, ehava gi o kaeu eigna kuda tatelia vanighamu na Mama? ");
INSERT INTO bgt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ehava Filip? O boi vaututunia roghami a Tamagu sikei vamua? Na komi haghore ku titionoa itamiu boi na ghaghanagu ghehegu, kari na komi fata ku titionoa ma na komi fata ku eia, irangeni nigna na agutu a Tamagu ke mono duagu. ");
INSERT INTO bgt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Oti vaututuniu kori vido ku veleghamu iroghami a Tamagu kuru sikei vamua. Gi kotida boi vaututunia na hava ku velea, oti vaututuniu vamua eigna na komi fata koti reghia ku eia. ");
INSERT INTO bgt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Vaovarongo toetoke tagna na fata ke tutuni iaani. Ahai ke vaututuniu inau, imanea keda eia na komi fata ku eia. Mi manea mua keda eia na komi fata ke hutu vano tadia na komi fata ku eia, eigna inau kuda vano mono duagna na Mama. ");
INSERT INTO bgt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na hava kotida kaea kori ahagu inau kuda eia, eigna na agutu nigna na Dathe bali tateli aua tadia na komi tinoni na Mama ke thaba vano. ");
INSERT INTO bgt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","E tutuni, ighamu tangomana kotida kaeu sa fata kori ahagu, mi nau kuda eia vanighamu.” ");
INSERT INTO bgt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Gi kotida dothoviu, oti leghua na komi fata ku veleghamu kotida eira. ");
INSERT INTO bgt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Inau kuda kaea na Mama mi manea keda heghamu ahai keda mono duamiu hahali bali hatheghamu. ");
INSERT INTO bgt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Imanea na Tarunga ke Tabu, ke tateli aua na hava ke tutuni. Na komi tinoni kori maramagna kena boi leghuu, imarea teo kedana hatia na Tarunga ke Tabu eigna kena boi reghia mena boi adoa imanea. Keana ighamu koti adoa imanea eigna ke mono duamiu, mi manea keda mono ikoramiu hahali. ");
INSERT INTO bgt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Inau teo kuda taveti sanighamu. Eigna inau ku bosi magnahaghinighamu kotida mono ghehemiu vaghagna na gari ke thehe a idogna ma tamagna. Teo. Inau kuda ghoi tabiru mai itamiu. ");
INSERT INTO bgt_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","E boi hau ma na komi tinoni kena boi leghuu kedana boi reghiu, kari ighamu kotida reghiu, eigna inau kuda ghoi havi tabiru. Mi ghamu huju kotida ghoi havi tabiru mua. ");
INSERT INTO bgt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kori dani inau kuda havi tabiru kori thehe, ighamu kotida adoa inau sikei duagna na Mama. Ighamu kotida adoa mua inau sikei duamiu mi ighamu sikei duagu inau. ");
INSERT INTO bgt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Arahai kena adoa nigua na komi vetula mena leghua, imarea arahai kena dothoviu. Ma arahai kena dothoviu, a Tamagu keda dothovira, mi nau huju kuda dothovira mua. Mu kuda tatelia vanira na komi fata eigu inau.” ");
INSERT INTO bgt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ma Jiudas (boi Jiudas Iskariot) ke velea, “Lod, ehava gi koda tatelia vanighami vamua na komi fata eimu ighoe, kari ighoe koda boi eia iangeni vanira na komi tinoni gougovu kori maramagna?” ");
INSERT INTO bgt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","A Jisas ke haghore tughua, “Arahai kena dothoviu, imarea kedana leghua nigua na komi haghore. Ma a Tamagu keda dothovira mi iroghami kuruda mai mono duadia. ");
INSERT INTO bgt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Keana arahai kena boi dothoviu, imarea kedana boi leghua nigua na komi haghore. Na komi fata ku titiono itamiu, boi na ghaghanagu ghehegu, kari na komi fata ke mai tagna a Tamagu ke vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Inau ku veleghamu na komi fata iraani kori vido ku mono mua duamiu. ");
INSERT INTO bgt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kari leghugna kuda taveti sanighamu, ahai bali hatheghamu keda mai me velepuhighamu na komi fata gougovu. Mi manea keda hatheghamu eigna kotida togha tabirua na komi fata ku veleghamu ghohi. Ma ahai keda hatheghamu, na Tarunga ke Tabu a Tamagu keda vetula maia kori ahagu. ");
INSERT INTO bgt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Inau ku heghamu na soleana, ma na soleana iangeni inau vamua ku tangomana na heghamugna. Na soleana iangeni boi vaghagna na soleana kori maramagna iaani ke boi hau me govu. Na vunegna inau ku heghamu na soleana iangeni, oti saghoi lubatia na ghaghanamiu keda dika moti saghoi mataghu. ");
INSERT INTO bgt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ighamu koti rongoviu ghohi kori vido ku veleghamu kuda taveti sanighamu, kari inau kuda ghoi tabiru mai itamiu. Gi kotida pukuni dothoviu, ighamu kotida totogo eigna na vano kuda eia tagna na Mama eigna imanea ke thaba vano itagua. ");
INSERT INTO bgt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Inau ku veleghamu na komi fata iraani gi u taveti sanighamu eigna kotida vaututuniu kori vido kedana tate mai. ");
INSERT INTO bgt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Inau boi tangomana kuda titiono hau mua duamiu, eigna a Satan, ahai ke vunaghi pungusia na maramagna iaani, imanea ke gharani mai ghohi. Imanea ke teo sa nigna mana keda vunaghi pungusiu. ");
INSERT INTO bgt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Keana inau kuda eia vamua na hava a Tamagu ke veleu eigna na komi tinoni kori maramagna kedana adoa inau ku dothovia a Tamagu. Atu, mati taveti au eeni.” ");
INSERT INTO bgt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","A Jisas ke velera nigna na komi vaovarongo, “Inau na pukuni tonogna na ghai, ma Tamagu na mane agutu gnatha. ");
INSERT INTO bgt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Imanea ke toka aua na komi ototo itagua ke boi sagharo, me toka kudoa na komi ototo ke sagharo eigna kedana sagharo vano mua. ");
INSERT INTO bgt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Vaghagna vamua na komi ototo irangeni, ighamu koti raraha ghohi kori matagna a God eigna koti vaututunia na komi haghoregu. ");
INSERT INTO bgt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Oti mono totho itagua hahali, mi inau kuda mono totho itamiu hahali. Na ototogna na ghai teo keda sagharo ghehegna keda boi totho kori tonogna na ghai. Vaghagna vamua iangeni, ighamu huju teo kotida sagharo kotida boi totho itagua. ");
INSERT INTO bgt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Inau na tonogna na ghai, ighamu na komi ototogna. Gi kotida totho thovohaliu itagua mi nau kuda totho thovohaliu itamiu, ighamu kotida sethe na sagharomiu. Keana gi kotida boi mono totho itagua, teo kotida eia sa fata ke toke vania a God. ");
INSERT INTO bgt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Arahai kena boi totho itagua, imarea kena vaghagna na komi ototo na mane agutu gnatha ke toka aua me sonira mena thehe. Na komi ototo irangeni, na komi tinoni agutu kena sonira kori boku mena pughulira. ");
INSERT INTO bgt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Gi kotida totho itagua thovohaliu moti leghua na komi haghoregu, ighamu tangomana kotida tarai kaea sa fata koti magnahaghinia, ma God keda heghamu. ");
INSERT INTO bgt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Arahai kena pukuni nigua na komi vaovarongo, imarea kena sagharoa na komi sagharo ke sethe. Kori vido kena eia iangeni, imarea kena tatelia tadia na komi tinoni a Tamagu ke thaba vano. ");
INSERT INTO bgt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Inau ku dothovighamu vaghagna a Tamagu ke dothoviu inau. Oti totho itagua hahali eigna kotida mono kori nigua na dotho. ");
INSERT INTO bgt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na vunegna inau ku leghua na komi vetula nigna a Tamagu, inau ku mono hahali koragna nigna na dotho. Vaghagna vamua iangeni, gi kotida leghua nigua na komi vetula, ighamu kotida mono hahali koragna nigua na dotho. ");
INSERT INTO bgt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Inau ku veleghamu na komi fata iraani eigna nimiu na totogo keda nanaba tagna nigua na totogo. Hee, inau ku magnahaghinia nimiu na totogo keda hutu puala. ");
INSERT INTO bgt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iaani nigua na vetula vanighamu: Oti veidothovighi vaghagna inau ku dothovighamu. ");
INSERT INTO bgt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Na tinoni ke thehe eidia ara kulagna, teo mua sa puhi ke toke vano tagna iangeni bali tatelia nigna na dotho itadia. ");
INSERT INTO bgt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kori vido ighamu koti leghura nigua na komi vetula, ighamu koti tateli aua ighamu ara kulagu. ");
INSERT INTO bgt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Turughu ikeagaieni inau ku bosi kiloghamu nigua na komi mane agutu, eigna na komi mane agutu teo kedana adoa nigna na toatogha na vunaghidia. Kari inau ku kiloghamu ara kulagu, eigna inau ku veleghamu na komi fata gougovu a Tamagu ke veleu. ");
INSERT INTO bgt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ighamu oti boi vahiu, kari inau ku vahighamu. Mi nau ku heghamu na agutu eigna kotida vano sagharoa na sagharo keda mono hahali. Kori vido koti eia iangeni, a Tamagu keda heghamu na hava koti kaea itagna kori ahagu. ");
INSERT INTO bgt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iaani nigua na vetula vanighamu: Oti veidothovighi. ");
INSERT INTO bgt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kori vido na komi tinoni kori maramagna kedana thevuioka itamiu, oti saghoi havaghinia imarea kena kidi thevuioka itagua. ");
INSERT INTO bgt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Gi na puhimiu keda dika vaghagna na puhidia na komi tinoni kori maramagna kena boi vaututuniu, imarea kedana dothovighamu. Kari ighamu koti boi mono vaghadia. Inau ku vahighamu au tadia na komi tinoni kori maramagna ma na vunegna iangeni imarea kena thevuioka itamiu ghamu. ");
INSERT INTO bgt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Oti saghoi havaghinia na hava ku kidi veleghamu ghohi: Teo sikei mane agutu ke nagho vano tagna na vunaghigna. Gi kedana vaparau, imarea kedana vaparaghamu mua. Gi kedana leghua nigua na velepuhi, imarea kedana leghua mua nimiu na velepuhi. ");
INSERT INTO bgt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Na komi tinoni kori maramagna kedana vaparaghamu eigna ighamu nigua na komi tinoni, mi marea kena boi adoa a God ke vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Gi inau kuda boi mai mu titiono itadia, imarea teo kedana reghia nidia na hahi. Kari na vunegna inau ku titiono itadia, e vahothahaghinira na veleagna imarea kena boi ei hahia. ");
INSERT INTO bgt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ahai ke thevuioka itagua, imanea ke thevuioka mua tagna a Tamagu. ");
INSERT INTO bgt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Inau ku eia na komi reghithehe ke boi tangomana nidia na eiagna sa tinoni tavogha. Gi inau kuda boi eia kori matadia na komi tinoni, imarea teo kedana reghia nidia na hahi. Kari imarea kena ei hahia eigna, toke kena reghia na komi reghithehe ku eia, imarea kena talu thevuioka vamua tamami roghami Tamagu. ");
INSERT INTO bgt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kari e ai eigna keda tutuni na rioriso iaani ke mono tadia na komi Rioriso ke Tabu, ‘Teo sa vunegna kedana thevuioka itagua, keana imarea kena talu thevuioka vamua itagua.’ ");
INSERT INTO bgt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Roghami a Tamagu kuruda vetula maia itamiu ahai keda hatheghamu. Imanea na Tarunga ke Tabu ke au mai tagna a Tamagu me tateli aua na hava ke tutuni. Kori vido ke mai, imanea keda titionoa vanighamu na komi fata gougovu eigu inau. ");
INSERT INTO bgt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mi ghamu huju kotida titiono mua eigu inau. Eigna ighamu koti mono duagu turughu kori turughugna nigua na agutu me jufu ikeagaieni. ");
INSERT INTO bgt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Inau ku veleghamu na komi fata iraani eigna keda boi luvu nimiu na vaututuni kori vido imarea kedana vaparaghamu. ");
INSERT INTO bgt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Imarea kedana gigighamu au tadia na komi vathe haidu nida ighita mara Jiu. Mi tagna na maghavu keda mai, ahai keda vathehea sa tinoni itamiu, imanea keda toatogha na hava ke eia keda vatotogoa a God. ");
INSERT INTO bgt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Imarea kedana eia vaghagna iangeni eigna kena boi adoa na Mama mena boi adou inau. ");
INSERT INTO bgt_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Inau ku veleghamu na komi fata iraani eigna kori maghavu imarea kedana vaparaghamu, ighamu kotida adoa inau ku kidi veleghamu ghohi. I hau, inau ku boi titionoa vanighamu iangeni, eigna kori vido iangeni inau ku adoa kuda mono hau mua duamiu. ");
INSERT INTO bgt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ikeagaieni inau kuda tabiru vano tagna ahai ke vetulau mai. Kari teo sikei itamiu ke huatiu, ‘Ivei koda vano na?’ ");
INSERT INTO bgt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Na vunegna inau ku veleghamu e boi hau gi inau kuda taveti sanighamu, ighamu koti dikahehemiu puala. ");
INSERT INTO bgt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kari na hava ku veleghamu ikeagaieni e tutuni, e toke inau kuda taveti sanighamu, eigna gi kuda boi taveti sanighamu, na Tarunga ke Tabu teo keda mai bali hatheghamu. Kari gi kuda taveti sanighamu, inau kuda vetula maia itamiu. ");
INSERT INTO bgt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kori vido na Tarunga ke Tabu keda mai, imanea keda tateli aua tadia na komi tinoni kori maramagna imarea na komi tinoni koakoa, ma na puhigu inau ke jino kori matagna a God, ma a God keda fatera. ");
INSERT INTO bgt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Imanea keda tateli aua itadia imarea kena koakoa eigna kena boi vaututuniu inau. ");
INSERT INTO bgt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Imanea keda tateli aua itadia na puhigu ke jino tagna na taveti vano kuda eia tagna na Mama. Mi ghamu kotida boi tangomana na reghiugna ngengeni. ");
INSERT INTO bgt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mi manea keda tateli aua itadia a God keda fatera eigna a God ke fatea ghohi a Satan ke vunaghi pungusia na maramagna. ");
INSERT INTO bgt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Sethe mua na komi fata inau ku magnahaghinia na titionoagna itamiu, kari ikeagaieni ighamu boi tangomana na rongoviagna. ");
INSERT INTO bgt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Na Tarunga ke Tabu ke tateli aua na komi fata ke tutuni eigna a God. Kori vido keda mai itamiu, imanea keda vathaothadoghaghamu eigna na komi fata ke tutuni irangeni. Imanea keda boi titiono leghua na ghaghanagna ghehegna, kari imanea keda titionoa na hava ke rongovia itagua. Ma na Tarunga ke Tabu keda titionoa itamiu na hava keda tate mai ivughei valiha. ");
INSERT INTO bgt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Imanea keda tateli aua itamiu inau ku thaba vano eigna imanea keda titionoa itamiu na hava ku titionoa itagna. ");
INSERT INTO bgt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Na komi fata gougovu nigna a Tamagu, na nigua. Iangeni na vunegna inau ku velea na Tarunga ke Tabu keda titionoa itamiu na komi fata inau ku titionoa itagna.” ");
INSERT INTO bgt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Gi a Jisas ke velera mara nigna na vaovarongo, “Sina ghathi vido iso mua, ighamu kotida boi reghiu. Kari boi hau leghugna iangeni ighamu kotida ghoi reghiu.” ");
INSERT INTO bgt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kekeha nigna na mane vaovarongo kena veihuahuatighi varihotaghidia vaghagna iaani, “Na hava ke mono kori ghaghanagna imanea kori vido ke velea sina ghathi vido iso mua mi ghita katida boi reghia, kari boi hau leghugna iangeni mi ghita katida ghoi reghia? Ma na hava ke mono kori ghaghanagna kori vido ke velea imanea keda vano tagna na Mama? ");
INSERT INTO bgt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ma na hava na ghaghanagna ‘sina ghathi vido iso mua.’ Ighita kati boi thaothadoghagna na hava ke mono kori ghaghanagna.” ");
INSERT INTO bgt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","A Jisas ke adoa imarea kena magnahaghinia na huatiagna me velea iaani, “Ehava? E tutuni ighamu koti veihuahuatighi varihotaghimiu eigna na hava ke mono kori ghaghanagu kori vido ku velea, ‘Sina ghathi vido iso mua mi ghamu kotida boi reghiu. Kari boi hau leghugna iangeni mi ghamu kotida ghoi reghiu’? ");
INSERT INTO bgt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Oti vaovarongo toetoke tagna na fata ke tutuni iaani. Ighamu kotida tangi moti dikahehe, kari na komi tinoni kori maramagna kena boi leghuu inau, imarea kedana totogo puala. Ighamu kotida dikahehe, kari leghugna iangeni ighamu kotida totogo nimiu puala. ");
INSERT INTO bgt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kori vido na vaivine ke haga vahua na gari, iia ke vahaghitia puala na hotaghigna. Kari leghugna ke vahua a dathegna, iia ke toghasania na vavahaghiti iangeni eigna ke totogo puala na gari ke havi mai kori maramagna. ");
INSERT INTO bgt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Vaghagna vamua iangeni itamiu ghamu. Ikeagaieni ighamu koti dikahehe, kari inau kuda ghoi reghighamu mi ghamu kotida totogo hutu puala. Me teo ahai keda hati aua na totogo iangeni itamiu. ");
INSERT INTO bgt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kori vido iangeni e teo sa vunegna ighamu kotida kaea sa fata itagua. Na hava ke tutuni, na Mama keda heghamu na hava koti kaea kori ahagu. ");
INSERT INTO bgt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Turughu i hau me jufu ikeagaieni, ighamu koti boi kaea sa fata kori ahagu. Oti kaea sa fata tagna na Mama mi manea keda heghamu eigna keda vonungighamu na totogo. ");
INSERT INTO bgt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Inau ku titionoa na komi fata iraani itamiu tagna na komi titiono ke vahotha na thaothadoghagna. Kari tagna na maghavu keda mai, inau kuda boi titiono itamiu tadia na komi titiono vaghagna iaani, kari inau kuda titiono jino vamua itamiu eigna na Mama. ");
INSERT INTO bgt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kori maghavu iangeni, ighamu tangomana kotida kaea na Mama kori ahagu. E teo sa vunegna inau kuda kaea imanea eimiu ghamu, ");
INSERT INTO bgt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","eigna na Mama ke dothovighamu. Imanea ke dothovighamu eigna koti dothoviu inau moti vaututuniu inau ku mai tagna God. ");
INSERT INTO bgt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Inau ku mai tagna na Mama mu mai kori maramagna. Ikeagaieni inau kuda taveti sania na maramagna mu kuda tabiru vano tagna na Mama.” ");
INSERT INTO bgt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mara nigna na vaovarongo kena ania, “Ikeagaieni ighoe ko titiono jino itamami, mo boi titiono kori titiono ke vahotha na thaothadoghagna. ");
INSERT INTO bgt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ighami kiti adoa ikeagaieni, ighoe ko adoa na komi fata gougovu. Toke ighami kiti boi huatigho, ighoe ko adoa vamua na ghaghanamami! Iangeni na vunegna ighami kiti vaututunia ighoe ko mai tagna God.” ");
INSERT INTO bgt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","A Jisas ke huatira vaghagna iaani, “Ehava? Ighamu koti pukuni vaututuniu ikeagaieni? ");
INSERT INTO bgt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Reireghi toke ghamu! Tagna na maghavu keda mai ighamu gougovu kotida ghogho vano tadia na komi soasopa vathemiu. Ma na maghavu iangeni ke jufu mai ghohi. Ighamu kotida taveti saniu mi nau kuda mono ghehegu. Kari inau kuda boi mono ghehegu eigna na Mama ke mono duagu. ");
INSERT INTO bgt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Inau ku veleghamu na komi fata iraani eigna ighamu kotida mono kori soleana eigna ighamu koti mono totho thovohaliu itagua. Kori maramagna iaani sethe na komi fata ke vahotha keda padaghamu. Kari oti sokara ngasi! Eigna inau ku heta pungusia ghohi na mana ke dika ke mono kori maramagna.” ");
INSERT INTO bgt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kori vido a Jisas ke govu na titionoagna na komi fata irangeni, imanea ke tada hadi i popo me tarai vaghagna iaani, “Mama, na maghavu ke jufu mai ghohi. O tatelia vanira na komi tinoni gougovu a Dathemu ke thaba vano eigna a Dathemu keda tatelia vanira ighoe huju o thaba vano mua. ");
INSERT INTO bgt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ighoe ko lubatiu gi kuda vunaghi pungusira na komi tinoni eigna kuda hera na havi ke teo na govugna tadia arahai ko heu mai. ");
INSERT INTO bgt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ma na havi ke teo na govugna iaani: Na adoghogna ighoe, sikei vamua a God ko tutuni, ma na adougna inau, a Jisas Christ, ko vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Na vunegna inau ku vagovua ghohi na agutu ko heu mai kuda eia, inau ku tatelia tadia na komi tinoni ighoe ko thaba vano. ");
INSERT INTO bgt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mama, kori vido inau kuda ghoi mono duamu, inau ku magnahaghinigho koda vahaihadiu vaghagna vamua ko vahaihadiu inau kori vido ku mono duamu gi o vavuha na maramagna.” ");
INSERT INTO bgt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Jisas ke talu tarai mua vaghagna iaani, “Inau ku velepuhira arahai ko heu mai kori na maramagna iaani na komi fata eimu ighoe. Imarea nimua na komi tinoni kari ighoe ko heu mai imarea itagua, mi marea kena leghua na haghoremu. ");
INSERT INTO bgt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ikeagaieni, imarea kena adoa na komi fata gougovu ighoe ko heu mai ke pukuni mai itamua ighoe. ");
INSERT INTO bgt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Imarea kena adoa iangeni eigna inau ku hera na komi velepuhi ighoe ko heu mai, mi marea kena vaututunira. Imarea kena pukuni adoa inau ku mai itamua, mi marea kena vaututunigho ighoe ko vetulau mai eeni. ");
INSERT INTO bgt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Inau ku tarai eidia imarea. Ikeagaieni inau ku boi tarai eidia na komi tinoni gougovu kori maramagna, kari eidia arahai ko heu mai, eigna imarea nimua na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na nigua na komi tinoni, imarea na nimua. Ma na nimua na komi tinoni, imarea na nigua. Ma na havidia ke tateli aua tadia na komi tinoni inau ku thaba vano. ");
INSERT INTO bgt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ikeagaieni inau ku taveti sania na maramagna. Inau kuda atu tabiru itamua, kari arahai kena leghuu inau, imarea kedana talu mono vamua kori maramagna. Mama ko tabu, o kalitira mo reireghira kori nimua na mana ko heu mai. O eia iangeni eigna imarea kedana sikei vamua vaghagna iroghita koro sikei vamua. ");
INSERT INTO bgt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kori vido inau ku mono duadia, inau ku reireghira kori nimua na mana. Inau ku reireghi toetokera, mi sikei vamua itadia ke jefe. Na mane iangeni ke leghua na hangana ke vano kori meleha papara eigna keda tutuni na hava ke mono tadia na komi Rioriso ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ikeagaieni inau kuda atu itamua. Sethe na fata inau ku velera ghohi arahai kena leghuu inau kori vido ku talu mono mua kori maramagna. Inau ku velera eigna kedana pukuni totogo vaghagu inau. ");
INSERT INTO bgt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Inau ku velepuhira ghohi nimua na komi velepuhi. Ma na komi tinoni kori maramagna kena thevuioka itadia arahai kena leghuu inau eigna kena boi leghua na komi puhidia ke dika, vaghagna vamua inau ku boi leghua mua. ");
INSERT INTO bgt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Inau ku boi kaegho eigna koda hatira au kori maramagna, kari eigna koda sokara pungusira tagna a Satan, ahai ke pukuni dika puala. ");
INSERT INTO bgt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Vaghagna vamua ku velea ghohi, imarea kena boi leghua na puhidia na komi tinoni kori maramagna, vaghagna vamua inau ku boi leghua. ");
INSERT INTO bgt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Na haghoremu ke tateli aua na hava ke tutuni eimu ighoe. Kori haghoremu iangeni, o vatabura eigna kedana eia nimua na agutu. ");
INSERT INTO bgt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Vaghagna ighoe ko vetulau mai kori maramagna, inau ku vetulara au kori maramagna. ");
INSERT INTO bgt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Inau ku hegho atu na havigu gougovu bali hathera eigna kedana pukuni hegho atu na havidia bali eia nimua na agutu. ");
INSERT INTO bgt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ma Jisas ke talu tarai mua vaghagna iaani, “Inau ku boi tarai eidia mara na komi vaovarongo iraani vamua, kari eidia mua arahai kedana vaututuniu kori vido nigua na komi vaovarongo kedana titionoa na rorongogu itadia. ");
INSERT INTO bgt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Inau ku tarai gi imarea gougovu kedana sikei vamua. Mama, vaghagna inau mi ighoe koro sikei vamua, inau ku tarai gi imarea kedana sikei vamua duada iroghita, eigna na komi tinoni kori maramagna kedana vaututunia ighoe ko vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Vaghagna ighoe ko vahaihadiu, inau ku vahaihadira. Inau ku eia iangeni eigna kedana sikei, vaghagna iroghita koro sikei vamua. ");
INSERT INTO bgt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Inau kuda sikei duadia mi ighoe koda sikei duagu inau eigna imarea kedana pukuni sikei duada iroghita. Ma na vunegna iangeni, na komi tinoni kori maramagna kedana adoa ighoe ko vetulau mai mo dothovira arahai kena leghuu inau vaghagna vamua ighoe ko dothoviu. ");
INSERT INTO bgt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mama, inau ku magnahaghinira arahai ko heu mai bali mono duagu thovohaliu eigna kedana reghia inau ku thaba vano. Ighoe ko vahaihadiu eigna ko dothoviu gi o vavuha na maramagna. ");
INSERT INTO bgt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mama, ighoe ko jino. Ighoe ko adoa na komi tinoni kori maramagna kena boi adogho. Kari inau ku adogho ma arahai kena leghuu inau kena adoa ighoe ko vetulau mai. ");
INSERT INTO bgt_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Inau ku velepuhira eimu ighoe, mi nau kuda talu eia iangeni eigna keda mono itadia nimua na dotho ko dothoviugna, mi inau kuda sikei duadia.” ");
INSERT INTO bgt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kori vido a Jisas ke govu na tarai, imanea ke hatira mara nigna na vaovarongo mena vano sethevugna na jaijari bea i Kidron. Imarea kena vano tagna sina gnathagna na ghai olev. ");
INSERT INTO bgt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","A Jiudas, na mane ke vano bali peroa a Jisas, imanea ke adoa na vido iangeni, eigna sethe na maghavu a Jisas ke vano ngengeni duagna nigna na komi vaovarongo. ");
INSERT INTO bgt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mara na naghoi pris mi mara na Farise kena veleagna a Jiudas eigna keda hatira duagna na boo soldia gna i Rom mi kekeha soldia kena kaekalea na Vathe ke Tabu. Imarea kena hatia na komi jekolo ma na komi lui ma na komi fata bali rihu, mena vano jufu kori gnathagna na ghai olev. ");
INSERT INTO bgt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Na vunegna a Jisas ke kidi adoa ghohi na hava imarea kedana eia itagna, imanea ke taveti vano itadia me huatira, “Ahai koti hiroa?” ");
INSERT INTO bgt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Imarea kena velea, “A Jisas gna i Nasaret.” A Jisas ke velera, “Inau imanea.” Kori vido iangeni, a Jiudas, na mane ke lubati vanoa a Jisas itadia, imanea ke sokara ngengeni duadia mara na soldia. ");
INSERT INTO bgt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kori vido a Jisas ke velera, “Inau imanea,” imarea gougovu kena suaraghi tabiru mena kutu horu kori thepa. ");
INSERT INTO bgt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Gi imanea ke ghoi huatira mua, “Ahai koti hiroa?” Mi marea kena veleagna, “A Jisas gna i Nasaret.” ");
INSERT INTO bgt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Gi a Jisas ke velera, “Inau ku veleghamu ghohi, inau imanea. Gi kotida hirou inau vamua, oti lubatira nigua na komi vaovarongo iraani eigna kedana taveti au.” ");
INSERT INTO bgt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Imanea ke velea iangeni eigna keda tutuni na hava ke kidi velea ghohi, “Teo sikei itadia arahai ko heu mai kedana jefe.” ");
INSERT INTO bgt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Gi a Saimon Pita ke sipa aua nigna na ghau bali rihu me toka vurukusua na kuli madothogna nigna na mane agutu na pukuni naghoi pris. Na ahagna imanea a Malkus. ");
INSERT INTO bgt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ma Jisas ke veleagna a Pita, “O boa tabirua nimua na ghau tagna bali monogna! Inau kuda papara leghuagna na hava a Tamagu ke magnahaghiniu inau kuda eia.” ");
INSERT INTO bgt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Gi na boo soldia gna i Rom ma na vunaghidia, duadia mara soldia kena kaekalea na Vathe ke Tabu, imarea kena thotia a Jisas mena tari haidua e rua na limagna. ");
INSERT INTO bgt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Imarea kena kidi hati vanoa tagna Anas, a vungaogna a Kaiafas. A Kaiafas na pukuni naghoi pris kori vinogha iangeni. ");
INSERT INTO bgt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","A Kaiafas na mane ke velera ghohi mara puhidia mara Jiu e toke gi sikei mane keda thehe tughura na komi tinoni gougovu. ");
INSERT INTO bgt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","A Pita duagna sina mane vaovarongo mua koro leghua a Jisas. Na vunegna na mane vaovarongo iangeni ke adoa na pukuni naghoi pris, imarea kena lubatia eigna keda leghua a Jisas kori vido kena hati vanoa kori lalaba ke mono kosigna na vathegna na pukuni naghoi pris. ");
INSERT INTO bgt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Keana a Pita ke sokara i kosi kori hagethagna na peo. Gi na mane vaovarongo ke vano haghe ghohi ke au mai me titiono duagna na vaivine ke reireghia na hagethagna na peo. Gi na mane vaovarongo iangeni ke hati haghea a Pita. ");
INSERT INTO bgt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kori vido iromara koro haghe vano, na vaivine iangeni ke reghia a Pita me ania, “Ehava? Ighoe sina nigna na mane vaovarongo a Jisas?” A Pita ke haghore tughua, “Teo, boi inau.” ");
INSERT INTO bgt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kori bongi iangeni e ghaula puala. Na vunegna iangeni na komi tinoni kena agutu kori vathe iangeni, mi mara soldia kena kaekalea na Vathe ke Tabu, imarea kena ifua na joto mena sokara kililivia mena mangiru. Ma Pita ke sokara duadia me mangiru. ");
INSERT INTO bgt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Gi a Anas, na pukuni naghoi pris, ke huatia a Jisas eigna nigna na komi vaovarongo ma na nigna na komi velepuhi. ");
INSERT INTO bgt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","A Jisas ke haghore tughua vaghagna iaani, “Na komi fata ku titionoa, inau ku titiono aua naghodia na komi tinoni gougovu. Inau ku velepuhira na komi tinoni hahali tadia na komi nida na vathe haidu ma na Vathe ke Tabu nigna a God. Inau ku boi poloa sa fata. ");
INSERT INTO bgt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ehava gi o huatiu na komi huahuati iraani? O huatira arahai kena rongovia na hava ku titionoa. Imarea kena adoa na komi fata ku titionoa.” ");
INSERT INTO bgt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kori vido a Jisas ke velea iangeni, sina soldia ke kaekalea na Vathe ke Tabu ke tapoa me veleagna, “E boi jino gi o velea vaghagna iangeni tagna na pukuni naghoi pris!” ");
INSERT INTO bgt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ma Jisas ke veleagna, “Gi keda boi jino sa fata ku velea, o titiono aua tada ighita gougovu. Keana gi keda jino na komi fata ku velea, na vunegna na hava gi o tapou?” ");
INSERT INTO bgt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Gi Anas ke vetula vanoa a Jisas tagna a Kaiafas, na pukuni naghoi pris. Na limagna a Jisas ke talu tatari mua. ");
INSERT INTO bgt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kori vido a Pita ke talu sokara mua hilighagna na joto me mangiru, kekeha tinoni kena mono ngengeni kena huatia, “Ehava? Ighoe sina nigna na mane vaovarongo a Jisas?” A Pita ke velea, “Teo, boi inau.” ");
INSERT INTO bgt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sina nigna na mane agutu na pukuni naghoi pris ke mono ngengeni. Imanea ke tamatahi tagna na mane a Pita ke toka vurukusua na kuligna. Imanea ke huatiagna a Pita, “Ehava? Inau ku reghigho duagna na mane iangeni tagna na gnathagna na ghai olev?” ");
INSERT INTO bgt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","A Pita ke ghoi velea mua ke boi adoa a Jisas. Kori vido vamua iangeni na kokorako ke tangi. ");
INSERT INTO bgt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kori vuevugheigna hadi, mara puhidia mara Jiu kena hati aua a Jisas kori vathegna a Kaiafas mena hati vanoa kori vathe hutu nigna na manegna i Rom ke Primia kori provins iangeni. Kari imarea kena boi vano haghe kora, eigna gi kedana vano haghe kori vathegna na tinoni ke boi Jiu, nidia na komi vetula ke velea imarea kedana boi raraha kori matagna a God. Mena boi tangomana nidia kedana vanga kori Laulahugna na Thovoliungi. ");
INSERT INTO bgt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ma na Primia, a Pailat, imanea ke taveti au i kosi me huatira, “Na hava koti toroagna na mane iaani?” ");
INSERT INTO bgt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Imarea kena veleagna, “Gi imanea keda boi ei hahia sa fata, teo kitida hati maia itamua!” ");
INSERT INTO bgt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ma Pailat ke anira, “Oti hatia imanea moti fatea leghuagna nimiu na komi vetula.” Mara puhidia mara Jiu kena haghore tughua, “Ighamu mara i Rom, oti boi lubatighami kitida vathehea na tinoni.” ");
INSERT INTO bgt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Imarea kena velea iangeni eigna keda tutuni na hava ke velea a Jisas eigna na puhi thehe keda eia imanea. ");
INSERT INTO bgt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","A Pailat ke tabiru haghe kori vathe me velera nigna na komi soldia eigna kedana hati maia a Jisas itagna. Gi e huatiagna, “Ehava? Ighoe na king nidia mara Jiu?” ");
INSERT INTO bgt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","A Jisas ke haghore tughua, “Ehava? Na huahuati iaani na ghaghanamu ghehemu, ba arahai tavogha kena velegho eigu inau?” ");
INSERT INTO bgt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","A Pailat ke ania, “Inau boi na mane Jiu! Nimua na komi tinoni mi mara na naghoi pris kena hatigho mai itagua. Na hava ko ei hahia?” ");
INSERT INTO bgt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","A Jisas ke ania, “Inau ku boi vaghagna na komi king kori maramagna iaani. Gi inau kuda vaghadia imarea, nigua na komi tinoni kedana rihu kori vido mara Jiu kena mai mena thotiu. Teo, inau ku boi vaghadia na komi king kena mono kori maramagna iaani.” ");
INSERT INTO bgt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Gi a Pailat ke veleagna a Jisas, “Ighoe na king?” Ma Jisas ke haghore tughua, “Ighoe ghehemu ko velea inau na king. Inau ku havi mai kori maramagna eigna kuda titiono aua na hava ke tutuni. Ma arahai kena dothovia na hava ke tutuni, imarea kena leghuu inau.” ");
INSERT INTO bgt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ma Pailat ke huatia, “Ehava gi ati adoa na hava ke tutuni na?” Gi e ghoi taveti au ikosi tadia mara Jiu me anira, “E teo sa fata ku pada ke ei hahia imanea. ");
INSERT INTO bgt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Leuleghu vinogha kori Laulahugna na Thovoliungi inau ku lubati mamaluha sina tinoni kori vathe tatari koti kaeu. Ehava? Oti magnahaghinia kuda lubati mamaluha na king nimiu ghamu mara Jiu?” ");
INSERT INTO bgt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Imarea kena ghuu tabiru itagna vaghagna iaani, “Teo! Boi na mane iaani! Kari o lubati aua a Barabas! A Barabas sina mane ke mono kori vathe tatari eigna ke rihu pungusia na gaumane gna i Rom. ");
INSERT INTO bgt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","A Pailat ke ghoi tabiru haghe kori vathe me velera nigna na komi soldia eigna kedana thabuhia a Jisas kori piru. ");
INSERT INTO bgt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Leghugna iangeni imarea kena agutua na kepi kori kuji mena vakepiagna. Mena vapokoagna vaghagna na king kori poko ke mela ke teve. ");
INSERT INTO bgt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Gi mara na soldia kena mai gharania mena leuleua mena velea, “Ighami kiti kilothabagho, ighoe na king nidia mara Jiu!” Gi ena tapoa na bakogna. ");
INSERT INTO bgt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Gi a Pailat ke ghoi taveti au ikosi me velera na mavitu, “Inau kuda hati aua imanea itamiu eigna kotida adoa inau ku boi pada sa fata ke ei hahia.” ");
INSERT INTO bgt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kori vido kena hati aua a Jisas i kosi, imanea ke talu kepia mua na kepi kena agutua kori kuji me talu vahaghea na poko ke mela ke teve. Ma Pailat ke velea, “Iaani na mane iangeni!” ");
INSERT INTO bgt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kori vido mara na naghoi pris mi mara soldia kena kaekalea na Vathe ke Tabu kena reghia a Jisas, imarea kena ghuu heta, “Tupipuhia! Tupipuhia!” Keana a Pailat ke velera, “Oti hatia ghehemiu moti tupipuhia kori ghaibabala, eigna inau ku bosi pada sa fata ke ei hahia.” ");
INSERT INTO bgt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mara puhidia mara Jiu kena haghore tughua, “Kori nimami na vetula, imanea e naba keda thehe, eigna imanea ke velea imanea a Dathegna God.” ");
INSERT INTO bgt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat ke rongovia iangeni me mataghu nigna vano mua na fateagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Imanea ke ghoi hati haghea a Jisas kori vathe me huatia, “Ighoe na manemu ivei?” Kari a Jisas ke boi haghore tughuagna. ");
INSERT INTO bgt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","A Pailat ke ghoi huatia, “Ehava gi o boi haghore tughuu? O saghoi havaghinia inau ke mono nigua na mana bali lubati mamaluhagho ba tupipuhigho.” ");
INSERT INTO bgt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ma Jisas ke ania, “Ighoe ke mono nimua na mana bali eia sa fata itagua eigna a God ke hegho vamua. Iangeni na vunegna na paluhagna ahai ke lubatiu vanigho ke hutu vano tagna na paluhamu ighoe.” ");
INSERT INTO bgt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Leghugna a Pailat ke rongovia iangeni, imanea ke hiohiroa puala na puhi bali lubati mamaluha a Jisas. Keana mara puhidia mara Jiu kena ghuu heta, “Gi ighoe koda lubati mamaluha na mane iaani, ighoe boi a kulagna na King gna i Rom. Eigna ahai ke vele aua imanea ghehegna na king, imanea ke thevuioka tagna na King gna i Rom.” ");
INSERT INTO bgt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kori vido a Pailat ke rongovia na hava kena velea, imanea ke velera nigna na komi soldia eigna kedana hati aua a Jisas. Gi a Pailat ke nohe tagna na sape bali fate tagna na vido kena kiloagna “Na Lalaba Ghahira.” (Kori haghoredia mara Jiu na ahagna na vido iangeni, “Gabata.”). ");
INSERT INTO bgt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kori vido iangeni haga jufungia ghohi na hotaghi dani bali kaikaliti eigna na Laulahugna na Thovoliungi. Ma Pailat ke velera na komi tinoni Jiu, “Iaani nimiu na king!” ");
INSERT INTO bgt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Imarea kena ghuu tabiru vano vaghagna iaani, “Vathehea! Vathehea! Tupipuhia imanea!” Gi a Pailat ke huatira, “Ehava? Oti magnahaghiniu kuda tupipuhia nimiu na king?” Mara na naghoi pris kena veleagna, “Na King gna i Rom vamua nimami na king. Teo sa nimami na king ke tavogha.” ");
INSERT INTO bgt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Gi a Pailat ke hiira me lubati vanoa a Jisas itadia na komi soldia eigna kedana tupipuhia. Mara na soldia kena hati vanoa a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","A Jisas ke hulungia ghehegna nigna na ghaibabala mena ghieghilei jufu kori vido kena kiloagna, “Suasupu Ulu.” (Kori haghoredia mara Jiu na ahagna na vido iangeni, “Golgota.”) ");
INSERT INTO bgt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ingengeni imarea kena tupipuhia a Jisas duagna e rua na mane mua. Rodia na ghaibabala ke mono rua thevugna na ghaibabala nigna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","A Pailat ke velera mara na soldia eigna kedana risoa na rioriso kori pava mena boa popogna na ghaibabala nigna a Jisas. Imarea kena risoa, “JISAS GhNA I NASARET, NIDIA KINGh MARA JIU.” ");
INSERT INTO bgt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Na rioriso iangeni, imarea kena risoa kori haghoredia mara Jiu, kori haghoredia mara i Rom, mi kori haghoredia mara i Grik. Sethe na tinoni Jiu kena ijumia na rioriso iangeni eigna na vido kena tupipuhia a Jisas ke gharania i Jerusalem. ");
INSERT INTO bgt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kori vido mara na naghoi pris kena reghia na rioriso iangeni, imarea kena veleagna a Pailat, “O saghoi risoa, ‘Nidia King mara Jiu.’ Kari o tughua mo risoa, ‘Imanea ke velea imanea nidia King mara Jiu.’” ");
INSERT INTO bgt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kari a Pailat ke velera, “Na hava ku risoa, inau ku risoa ghohi.” ");
INSERT INTO bgt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","E vati na soldia kena tupipuhia a Jisas kori ghaibabala. Leghugna kena tupipuhia, imarea kena kemulia nigna na komi pohe varihotaghidia. Gi imarea kena hatia mua nigna na poko kena tihighi doudolua mena boi sukia. ");
INSERT INTO bgt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Imarea kena velea, “Ati saghoi resua. Kari ati laulahu vavahi eigna katida reghia ahai keda hatia.” Me tutuni na rioriso iaani ke mono tadia na komi Rioriso ke Tabu, “Imarea kena kemulia nigua na komi pohe mena laulahu vavahi eigna kedana reghia ahai keda hatia nigua na pohe teve.” Iangeni na hava kena eia mara na soldia. ");
INSERT INTO bgt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","A idogna a Jisas, ma a vaivinegna idogna, ma Meri taugna Klopas, ma a Meri gna i Magdala, iira kena sokara gharania nigna na ghaibabala a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kori vido a Jisas ke reghia a idogna ma na nigna na vaovarongo ke dothovia puala ke sokara hilighagna, imanea ke veleagna a idogna, “Imanea a dathemu.” ");
INSERT INTO bgt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Gi e veleagna na mane vaovarongo iangeni, “Iia a idomu.” Turughu kori vido iangeni, na mane vaovarongo iangeni ke kalitia a idogna a Jisas kori vathegna. ");
INSERT INTO bgt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","A Jisas ke adoa ghohi ke pukuni vagovua nigna na komi agutu. Eigna keda tutuni na hava ke mono tadia na komi Rioriso ke Tabu, a Jisas ke velea, “Inau ku langasa.” ");
INSERT INTO bgt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Sina disi ke mono na waen ke aha itagna ke mono ngengeni. Mi marea kena hatia na pocho mena vagnubua kori waen ke aha. Gi ena jongia kori ghai kena kiloagna na hisop mena tuhu hadia vanoa kori livogna a Jisas eigna keda kouvia. ");
INSERT INTO bgt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Leghugna ke kouvia na waen, imanea ke velea, “Govu ghohi!” Kori vido ke govu na veleagna iangeni, imanea ke uluhoru me thehe. ");
INSERT INTO bgt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iangeni na dani bali kaikaliti eigna na Sabat. Ma na Sabat iangeni sina Sabat ke nagho vano tadia na komi tinoni Jiu eigna ke mono kori Laulahugna na Thovoliungi. Na vunegna mara puhidia mara Jiu kena boi magnahaghinia na tonodia e tolu na mane iangeni kedana mono kori ghaibabala kori Sabat, imarea kena kaea a Pailat eigna keda tagotia na naedia me hati horua na tonodia kori ghaibabala. ");
INSERT INTO bgt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mara na soldia kena vano mena tagotia na naedia e rua na mane kena tupipuhia duagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Keana, kori vido kena mai tagna a Jisas, imarea kena reghia imanea ke thehe ghohi mena boi tagotia na naegna. ");
INSERT INTO bgt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kari sina soldia ke vano me jaia na sokugna kori garatu me au mai na ghaughabua ma na bea. ");
INSERT INTO bgt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ahai ke titionora na komi fata iraani itamiu, imanea ke reghia ghehegna me adoa na komi fata iraani ke tutuni. Imanea ke titionora eigna kotida vaututunia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Na komi fata iraani, imarea kena eia eigna keda tutuni e rua na rioriso ke mono tadia na komi Rioriso ke Tabu, “Imarea kedana boi tagotia sikei huli kori tonogna,” ");
INSERT INTO bgt_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","mi “Imarea kedana rei vano tagna na mane kena jaia na sokugna kori garatu.” ");
INSERT INTO bgt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Leghugna iaani, a Josep gna i Arimatea ke vano tagna Pailat me kaea na tonogna a Jisas. A Josep sina mane ke leghua a Jisas, kari e boi magnahaghinia kedana adoa na komi tinoni, eigna imanea ke mataghunira mara puhidia mara Jiu. A Pailat ke lubatia, ma a Josep ke vano me hati horua na tonogna a Jisas kori ghaibabala. ");
INSERT INTO bgt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","A Nikodimas, na mane ke vano tagna a Jisas sina bongi i hau, imanea ke vano duagna a Josep. Imanea ke hatia duagna kekeha fata ke ghuba toetokegna kena kiloagna “mur” ma “alos.” Na tahugna e rua na fata irangeni nabagna tolu hangavulu na kilo. ");
INSERT INTO bgt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Gi romara koro hatia kekeha pohe ke pura moro fifiriagna na tonogna a Jisas duagna e rua na fata ke ghuba toetokegna iaani. Iangeni na puhi kena eia mara Jiu bali kaikalitia na tono gi ena boa kori luma. ");
INSERT INTO bgt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ghaghireigna na vido kena tupipuhia a Jisas, sina gnatha i ghai ke mono ngengeni. Tagna na gnatha iangeni sina luma ke mono ke teo mua sa tinoni ke thehe kena boa ikoragna. ");
INSERT INTO bgt_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na vunegna na dani iangeni na dani bali kaikaliti eigna na Sabat, ma na vunegna na luma iangeni ke mono gharinira, imarea kena vano boa na tonogna a Jisas ikoragna. ");
INSERT INTO bgt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kori vuevugheigna na Sade, kori vido ke talu puni mua, Meri gna i Magdala ke vano kori luma me reghia na ghahira kena bilakiagna na luma ke kokopili au ghohi. ");
INSERT INTO bgt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Gi iia ke raghe tabiru me pada a Saimon Pita ma na mane vaovarongo a Jisas ke dothovia. Iia ke velera, “Na tonogna a Lod, imarea kena hati aua ghohi kori luma mi ghami kiti boi adoa ivei kena vano boa!” ");
INSERT INTO bgt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pita duagna sina mane vaovarongo koro vano kori luma. ");
INSERT INTO bgt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Iromara koro sakai raghe vano kori luma, kari na mane vaovarongo ke duagna a Pita ke raghe saisami vano me kidi jufu kori luma. ");
INSERT INTO bgt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Imanea ke pogho horu me sigho haghe kori luma. Imanea ke reghia na komi pohe kena fifiriagna na tonogna, kari e boi vano haghe ikora. ");
INSERT INTO bgt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Gi a Saimon Pita ke jufu ingengeni me vano haghe kora i luma me reghia na komi pohe ke mono ngengeni. ");
INSERT INTO bgt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Imanea ke reghia mua na pohe kena filehiagna na ulugna. Na pohe iangeni ke lopo tokea me mono ghehegna. ");
INSERT INTO bgt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Gi na mane vaovarongo ke kidi jufu ngengeni ke vano haghe. Imanea ke reghia me vaututunia a Jisas ke sokara tabiru. ");
INSERT INTO bgt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Kori vido iangeni, imarea kena talu boi thaothadoghagna mua na komi Rioriso ke Tabu kena velea a Jisas keda sokara tabiru kori thehe.) ");
INSERT INTO bgt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Gi oro tabiru kori vathe. ");
INSERT INTO bgt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","A Meri gna i Magdala ke sokara kosigna na luma me tangi. Kori vido ke talu tangi mua, iia ke pogho horu me sigho haghe kori luma. ");
INSERT INTO bgt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Me reghia e rua na enjel na pohedia ke pura koro nohe tagna kena boa na tonogna a Jisas. Sikei ke nohe tagna ke mono na ulugna, sikei tagna ke mono na naegna. ");
INSERT INTO bgt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","E rua na enjel iangeni koro huatia a Meri, “Ehava gi o tangi?” Meri ke velea, “Imarea kena hati aua na tonogna nigua a Lod, mu boi adoa ivei kena vano boa.” ");
INSERT INTO bgt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Leghugna ke velea iangeni, a Meri ke rei tabiru me reghia a Jisas ke sokara leghugna. Keana iia ke boi ghithatha imanea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","A Jisas ke huatia, “Vaivine, ehava gi o tangi? Ahai ko hiroa?” A Meri ke ghaghana imanea na mane ke reireghia na gnatha i ghai, me velea, “Mane puhi, gi koda hatia na tonogna, o veleu ivei ko vano boa eigna kuda vano hatia.” ");
INSERT INTO bgt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Gi a Jisas ke ania, “Meri!” Meri ke rei vano itagna me velea kori haghoredia mara Jiu, “Raboni!” (Na ghaghanagna na haghore iaani, “Velepuhi.”) ");
INSERT INTO bgt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Gi a Jisas ke ania, “O saghoi tangoliu, eigna inau ku boi vano hadi mua tagna a Tamagu. Kari o vano tadia nigua na komi vaovarongo mo velera inau kuda vano hadi tagna a Tamagu ma a Tamamiu, tagna nigua a God, ma nimiu a God.” ");
INSERT INTO bgt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","A Meri gna i Magdala ke tabiru vano tadia mara na vaovarongo me velera, “Inau ku reghia a Lod!” Gi e titiono itadia na komi fata a Jisas ke veleagna. ");
INSERT INTO bgt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kori lavigna na dani Sade iangeni, mara na vaovarongo kena mono haidu koragna sina vathe. Mena bilaki ngasira na komi hagetha eigna kena mataghunira mara puhidia mara Jiu. Sina fata vano keari a Jisas ke sokara duadia me velera, “Na soleana itamiu.” ");
INSERT INTO bgt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Leghugna ke velea iangeni, imanea ke tatelia itadia na limagna ma na sokugna. Gi mara na vaovarongo kena ghithatha imanea a Lod mena totogo hutu puala. ");
INSERT INTO bgt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Gi a Jisas ke ghoi velera mua, “Na soleana itamiu. Vaghagna a Tamagu ke vetulau, inau ku vetulaghamu mua.” ");
INSERT INTO bgt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Gi e aheahe itadia me velera, “Oti hatia na Tarunga ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Gi ighamu kotida talutavogha na paluhagna ahai, a God keda talutavogha mua na paluhagna. Keana gi ighamu kotida boi talutavogha na paluhagna ahai, a God keda boi talutavogha mua na paluhagna.” ");
INSERT INTO bgt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Sikei itadia mara na vaovarongo, a Tomas (kena kiloagna mua Baso), imanea ke boi mono duadia kori vido a Jisas ke tate vanira. ");
INSERT INTO bgt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kori vido imanea ke tabiru mai, mara na vaovarongo kena veleagna, “Ighami kiti reghia a Lod!” Keana a Tomas ke anira, “Gi kuda boi reghia mu tangolia na ngeso kori limagna mu ghehuvia na ngeso kori sokugna, teo kuda vaututunighamu!” ");
INSERT INTO bgt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sina wik leghugna iangeni nigna na komi vaovarongo a Jisas kena ghoi haidu mua kori vathe iangeni ma Tomas duadia. Toke na komi hagetha ke bilaki ngasi, a Jisas ke haghe mai itadia me sokara duadia me velera, “Na soleana itamiu.” ");
INSERT INTO bgt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Gi e veleagna a Tomas, “O tangolia mo reghia na limagu. O tuhu mai na limamu mo ghehuvia na ngeso kori sokugu. O vaututuni mo saghoi ghaghana ruarua!” ");
INSERT INTO bgt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ma Tomas ke ania, “Ighoe na nigua na Vunagi ma na nigua a God!” ");
INSERT INTO bgt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Gi a Jisas ke ania, “Ighoe ko vaututuni eigna ko reghiu. Kari a God keda pukuni vatokera arahai kena boi reghiu kari ena vaututuniu.” ");
INSERT INTO bgt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Sethe na komi regithehe ke eia a Jisas kena reghia mara na vaovarongo, kari inau ku boi risora horu gougovu kori buka iaani. ");
INSERT INTO bgt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kari na komi reghithehe ke mono kori na buka iaani, eigna kotida vaututunia a Jisas a Vahavi, a Dathegna God. Gi kotida vaututunia iangeni, ighamu kotida hatia na havi ke teo na govugna. ");
INSERT INTO bgt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Leghugna iangeni, a Jisas ke ghoi tate tadia nigna na komi vaovarongo kori ghaghireigna na kolo i Galili. Imanea ke tate itadia vaghagna iaani: ");
INSERT INTO bgt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (kena kiloagna mua Baso), Nataniel gna i Kena kori provins i Galili, e rua dathegna Jebedi, me rua na mane vaovarongo mua, mara iraani kena mono kori kolo. ");
INSERT INTO bgt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","A Saimon Pita ke anira, “Inau kuda vano ugura.” Imarea kena ania, “Ighami kitida atu duamu.” Gi ena hahaghe kori boti mena taveti sapa vano. Na bongi doudolu iangeni imarea kena boi talu vathehea sa igha. ");
INSERT INTO bgt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kori vido ke gharani dani, imarea kena reghia a Jisas ke sokara kori lilihi, kari ena boi ghithatha imanea a Jisas. ");
INSERT INTO bgt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Gi a Jisas ke huatira, “Ara kulagu, ehava? Oti vathehea mua sa igha?” Mi marea kena ania, “Teo.” ");
INSERT INTO bgt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Gi imanea ke anira, “Sonia horua nimiu na jau kori madothogna na boti. Gi ighamu kotida hatia na igha.” Kori vido kena eia vaghagna ke veleragna, imarea kena boi tangomana na thaghi tabiruagna na jau eigna ke sethe puala na igha ke hogho itagna. ");
INSERT INTO bgt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Gi na mane vaovarongo a Jisas ke dothovia ke veleagna a Pita, “Iangeni a Lod!” Kori vido a Pita ke rongovia iangeni, imanea ke ghoi vaheghea nigna na oopo (eigna ke hati aua bali agutu) me sogala au kori boti me thonga i longa. ");
INSERT INTO bgt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Mara na vaovarongo kena mono kori boti kena gharania ghohi i longa, vaghagna sikei na hathangatu mita vamua. Na vunegna iangeni, imarea kena thaghia na jau leghugna na boti kori vido kena thonga. ");
INSERT INTO bgt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Leghugna kena jufu ilonga imarea kena reghia na igha kori kokovuru i joto. Mena reghia mua kekeha bred. ");
INSERT INTO bgt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma Jisas ke anira, “Hatia maia kekeha igha koti eu vathehera.” ");
INSERT INTO bgt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","A Saimon Pita ke saki hadi kori boti me thaghia thonga na jau i longa. Sina hathangatu lima hangavulu me tolu na igha hutu ke hogho kori jau, keana na jau ke boi resu. ");
INSERT INTO bgt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisas ke anira, “Oti mai moti vanga.” Me teo sikei itadia mara na vaovarongo ke huatia, “Ahai ighoe na?” eigna imarea kena adoa ghohi imanea a Lod. ");
INSERT INTO bgt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Gi a Jisas ke vano me hatia na bred me kemulia itadia. Govu, gi e hatia mua na igha me kemulia mua itadia. ");
INSERT INTO bgt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iangeni na vatolugna na maghavu a Jisas ke tate itadia nigna na komi vaovarongo leghugna imanea ke sokara tabiru kori thehe. ");
INSERT INTO bgt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kori vido imarea kena govu na vanga, a Jisas ke huatia a Saimon Pita, “Saimon dathegna Jon. Ehava? Ighoe ko dothoviu vano tadia mara iraani kena dothoviu?” A Pita ke ania, “Hii Lod, ighoe ko adoa inau ku dothovigho.” A Jisas ke ania, “O hera ghadia nigua na komi dathei sip.” ");
INSERT INTO bgt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","A Jisas ke ghoi huatia mua a Pita, “Saimon dathegna Jon. Ehava? Ighoe ko dothoviu?” Ma Pita ke ania, “Hii Lod, ighoe ko adoa inau ku dothovigho.” A Jisas ke ania, “O reireghi toetokera nigua na komi sip.” ");
INSERT INTO bgt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Gi a Jisas ke ghoi huatia mua a Pita, “Saimon dathegna Jon. Ehava? Ighoe ko dothoviu?” Ma Pita ke dikahehegna eigna a Jisas ke tolui horu huatiagna, “Ehava? Ighoe ko dothoviu?” A Pita ke ania, “Lod, ighoe ko adoa na komi fata gougovu. Ighoe ko adoa inau ku dothovigho!” Ma Jisas ke ania, “O hera ghadia nigua na komi sip. ");
INSERT INTO bgt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Na hava ku velegho ikeagaieni e tutuni, kori vido ighoe ko mathangani, ighoe ko pipisi ghehemu mo vano tagna sa vido ko magnahaghinia na vano. Kari kori vido koda kuekue, ighoe koda tuhu aua na limamu ma arahai tavogha keda tarigho mena hatigho vano tagna na vido ko boi magnahaghinia koda vano.” ");
INSERT INTO bgt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","A Jisas ke titionoa iaani tagna a Pita eigna keda adoa na puhi keda thehe. Na theheagna keda tateli aua a God ke thaba vano. Gi a Jisas ke veleagna a Pita, “O leghuu inau!” ");
INSERT INTO bgt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","A Pita ke rei tabiru me reghia na mane vaovarongo a Jisas ke dothovia puala ke leghura. (Iangeni na mane vaovarongo ke ravi vano tagna Jisas kori vido kena vanga me huatia eigna ahai keda lubati vanoa a Jisas tadia mara nigna na thevuioka.) ");
INSERT INTO bgt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ma Pita ke ania a Jisas, “Lod, na hava keda kathea imanea na?” ");
INSERT INTO bgt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","A Jisas ke haghore tughua, “Gi kuda magnahaghinia imanea keda talu havi me ghieghilei jufu na maghavu inau kuda tabiru mai, iangeni boi na fata bali togha ighoe. O leghuu inau vamua.” ");
INSERT INTO bgt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Na vunegna a Jisas ke velea iangeni, sethe na tinoni kena vaututuni kena ghaghana na mane vaovarongo iangeni keda boi thehe. Kari a Jisas ke boi velea iangeni. Imanea ke velea vamua, “Gi kuda magnahaghinia imanea keda talu havi me ghieghilei jufu na maghavu inau kuda tabiru mai, iangeni boi na fata bali togha ighoe.” ");
INSERT INTO bgt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na mane vaovarongo iangeni, imanea ke titionoa na komi fata iraani me risora horu kori buka iaani. Ighami gougovu kiti adoa na komi fata gougovu ke risoa ke tutuni. ");
INSERT INTO bgt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Sethe na komi fata a Jisas ke eia kena boi risora horu kori buka. Gi imarea kedana risora gougovu, inau ku ghaghana na maramagna doudolu da e boi nabagna na boagna na komi buka kedana risora. ");
INSERT INTO bgt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Toke Tiofilus, Koragna nigua na buka ku kidi risoa, inau ku risoa atua itamua eigna na komi fata gougovu a Jisas ke eia me velepuhi kori vido ke turughua nigna na agutu ");
INSERT INTO bgt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","me ghieghilei jufu mai na dani a God ke hati hadia i popo. Gi e hadi i popo, a Jisas ke haghore vanira nigna na komi mane vetula ke vahira kori mana nigna na Tarunga ke Tabu. Imanea ke velera na hava kedana eia. ");
INSERT INTO bgt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kekeha dani koragna e rua tutughu na dani leghugna kena tupipuhia, a Jisas ke tate vanira me eia sethe na fata eigna kedana pukuni adoa imanea ke havi tabiru. Kori vido ke tate vanira, imanea ke titiono vanira eigna na puhi a God ke vunaghi pungusira nigna na mavitu. ");
INSERT INTO bgt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tagna sina dani, kori vido a Jisas ke vanga duadia, imanea ke velera, “Saghoi taveti au i Jerusalem me ghieghilei vetula maia a Tamagu na hava ke taluhaghorea itamiu. I hau, inau ku veleghamu ghohi eigna iaani. ");
INSERT INTO bgt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","A Jon ke siuvitabughamu kori bea, kari leghugna kekeha dani, a God keda siuvitabughamu kori Tarunga ke Tabu.” ");
INSERT INTO bgt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kori vido mara na vetula kena mono duagna a Jisas kori Suasupa i Olev, imarea kena huatia, “Lod, ehava? Ikeagaieni ighoe koda vamamaluhaghita ighita mara Israel tadia nida na komi thevuioka mo vunaghi pungusighita vaghagna na king?” ");
INSERT INTO bgt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma Jisas ke velera, “A Tamagu vamua tangomana keda boa na maghavugna keda jufu mai na komi fata irangeni. Ighamu boi bali adoa. ");
INSERT INTO bgt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Keana, kori vido na Tarunga ke Tabu keda horu mai itamiu, ighamu kotida hatia na mana. Mi ighamu kotida titiono eigu inau i Jerusalem, mi tadia na komi meleha i Jiudea, kori provins i Samaria, mi vei mi vei kori maramagna.” ");
INSERT INTO bgt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Leghugna a Jisas ke vagovua na titiono iangeni, a God ke hati hadia kori maaloa kori vido mara na vetula kena dodoro. Gi e vano hadi kori na parako mi marea kena boi tangomana na reghiagna. ");
INSERT INTO bgt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Keana imarea kena talu tada hadi kori vido a Jisas ke hadi vano kori maaloa. Gi e rua na mane koro vahaghea na pohe pura koro sokara duadia. ");
INSERT INTO bgt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Iromara koro velera, “Maradia i Galili, ehava gi oti sokara eeni moti dodoro hadi kori maaloa na? God ke hati aua a Jisas itamiu me hati hadia i popo, kari imanea keda ghoi tabiru mai. Kori puhi imanea ke hadi vano i popo, imanea keda ghoi tabiru mai vaghagna iangeni.” ");
INSERT INTO bgt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mara na vetula kena taveti au tagna na Suasupa i Ghai Olev mena tabiru i Jerusalem. Na haugna da haga sikei na kilomita. ");
INSERT INTO bgt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kori vido kena tabiru, imarea kena vano hadi kori choghogna na vathe kena mono itagna. Na ahadia mara kena mono ngengeni: Pita, Jon, Jemes, Andru, Filip, Tomas, Batolomiu, Matiu, Jemes (dathegna Alfius), Saimon (sina mane ke magnahaghinia na gigi auragna mara i Rom eigna kedana boi vunaghi pungusira mara Jiu), ma Jiudas (dathegna Jemes). ");
INSERT INTO bgt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mara na vetula iraani kena haidu hahali mena tarai duadia Meri a idogna a Jisas, me kekeha vaivine puhi mua, mara tahigna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sina dani, haga sina hathangatu me tutughu na tinoni kena vaututuni kena haidu. Ma Pita ke sokara hadi me velera, ");
INSERT INTO bgt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Ara kulagu, i hau a King Deved ke titiono kori mana nigna na Tarunga ke Tabu me velea sina fata eigna a Jiudas, ma na fata iangeni ke tate mai ghohi ikeagaieni. A Jiudas sina mane itamami ke agutu duamami, kari imanea ke batura mara kena thotia a Jisas.” ");
INSERT INTO bgt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Jiudas ke volia sina vido thepa kori na rongo ke hatia tagna na fata dika ke eia. Kori thepa iangeni, imanea ke sogala horu ma na kutugna ke poha ma na komi fata korai kutugna ke rote au me thehe. ");
INSERT INTO bgt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Na komi tinonidia i Jerusalem kena rongovia na rorongo iaani, mena kiloagna na vido thepa iangeni ‘Akeldama’ na ghaghanagna, ‘Na Thepa Ghaughabua.’) ");
INSERT INTO bgt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ma a Pita ke velea mua, “Kori na buka Psalm, Deved ke velea, ‘Na vathegna keda korogha moti saghoi lubatia sa tinoni keda mono ikoragna.’ Me risoa mua vaghagna iaani, ‘Sina mane tavogha keda hatia nigna na agutu.’ ");
INSERT INTO bgt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Mi ghita katida vahia sikei mane bali tughua Jiudas. Imanea keda hatheghita kori titionoagna a Jisas ke sokara tabiru kori thehe. Ighita katida vahia sikei mane ke mono duada, tadia na komi dani ighita kati mono duagna a Lod Jisas, turughu kori vido a Jon ke siuvitabura na komi tinoni me ghieghilei jufu na dani a God ke hati hadia a Jisas i popo.” ");
INSERT INTO bgt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Imarea kena vaututuni kena vahira e rua na mane, a Matias ma Josep Basabas (kena kiloagna mua a Justus). ");
INSERT INTO bgt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Gi ena tarai vaghagna iaani, “Lod, ighoe ko adoa na ghaghanadia na komi tinoni gougovu. Na vunegna iangeni, o tatelia itamami ahai itadia iromara iaani ko vahia ");
INSERT INTO bgt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","eigna keda na mane vetula bali tughua a Jiudas. Eigna a Jiudas ke taveti sanighita me vano kori meleha papara ke nabagna keda mono.” ");
INSERT INTO bgt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Gi imarea kena laulahu vavahi, mi kori na puhi iaani imarea kena vahia a Matias. Mi manea na vasalaghe ruadia na mane vetula. ");
INSERT INTO bgt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kori dani Pentekos, na komi tinoni kena vaututuni kena mono haidu tagna sina vathe. ");
INSERT INTO bgt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sina fata vano keari imarea kena rongovia na oha ke mai i popo ke vaghagna na ghuri ke ifu heta me haghe tagna na komi chogho gougovu kori vathe kena mono. ");
INSERT INTO bgt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Gi imarea kena reghia na komi fata ke vaghagna na beubethu i joto kena tate mai mena vano mono popodia imarea gougovu. ");
INSERT INTO bgt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ma na Tarunga ke Tabu ke haghevira gougovu, gi ena turughu haohaghore tadia na komi haghoredia arahai tavogha kori na mana ke hera na Tarunga ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kori vido iangeni, sethe mara Jiu kena kalasu mai tadia sethe na meleha kori maramagna kena mai mena mono i Jerusalem. Imarea kena boi vaututunia a Jisas, kari ena maimanihihia a God mena pukuni leghua na komi vetula nigna a Moses. Kori vido kena rongovia na fata ke vaghagna na ghuighuri hutu, ");
INSERT INTO bgt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","imarea kena vano mena hathatano itadia na komi tinoni kena vaututuni. Mena vere nidia puala eigna imarea kena haohaghore tadia na komi haghoredia gougovu. ");
INSERT INTO bgt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Imarea kena peperiki mena vere nidia puala gi ena velea, “Ehava gi e ai? Na komi tinoni iraani eidia i Galili vamua. ");
INSERT INTO bgt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Keana ighita kati rongovira kena haohaghore tagna na komi haghoreda. ");
INSERT INTO bgt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kekeha itada eidia i Patia, Midia, mi Elam, Mesopotamia, Jiudea, Kapadosia, Pontus, Esia, ");
INSERT INTO bgt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frijia, Pamfilia, Ijip, ma na komi meleha i Libia kena mono hilighagna na meleha i Sairin. Kekeha mua itada kena eu mai i Rom ");
INSERT INTO bgt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(kekeha pukuni mara Jiu mi kekeha kena boi Jiu kari ena leghua na komi puhidia mara Jiu). Mi kekeha itada eidia i Krit mi Arabia. Keda ai huju, ighita gougovu kati rongovira imarea kena haohaghore kori na haghoreda eigna na komi fata toke ke eia a God.” ");
INSERT INTO bgt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na vunegna kena vere nidia puala mena hahi hehedia, imarea kena turughu veihuahuatighi vaghagna iaani, “Na hava na ghaghanagna iaani?” ");
INSERT INTO bgt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Keana, kekeha tinoni ngengeni kena leuleura mena velea, “Imarea da ena kou waen puala mena mee.” ");
INSERT INTO bgt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Gi a Pita ke sokara hadi duadia e salaghe sikei na mane vetula me ghuu vano tadia na mavitu vaghagna iaani, “Ighamu mara Jiu mi ighamu gougovu koti mono i Jerusalem, oti vaovarongo toetoke tagna na hava kuda veleghamu ikeagaieni. ");
INSERT INTO bgt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mara iraani ena boi mee kori waen vaghagna koti ghaghana. Teo! Na komi tinoni kori bongi vamua kena ado kou mena mee, kari ikeagaieni tangi hia vamua kori vuevughei. ");
INSERT INTO bgt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Keana na fata koti reghia ikeagaieni, a God ke velea ghohi i hau tagna a profet Joel eigna keda titiono aua. Imanea ke velea, ");
INSERT INTO bgt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Tadia na komi vagougovui dani kori maramagna, inau kuda hera na komi tinoni gougovu nigua na Tarunga ke Tabu. Ara dathemiu kedana titionoa na hava ku velera. Inau kuda tateli aua kekeha fata vanira mara mathangani tadia na komi salingau mi tadia na komi kuekue kori maumaturungita. ");
INSERT INTO bgt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Koragna na komi dani irangeni, inau kuda hera nigua na Tarunga ke Tabu tadia nigua na komi mane agutu ma na nigua na koi vaivine agutu, me kedana titionoa na hava ku velera. ");
INSERT INTO bgt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Inau kuda eia na komi reghithehe kori maaloa mi kori thepa: Ighamu kotida reghia na ghaughabua, ma na joto, ma na ahu ke hutu. ");
INSERT INTO bgt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na aho keda boi raraha ma na vula keda mela vaghagna na ghaughabua, gi e jufu mai na dani nigna a God ke nagho me siasilada. ");
INSERT INTO bgt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Gi ahai keda vautunia a Lod eigna keda vahavia, a Lod keda vahavia.’ ");
INSERT INTO bgt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ighamu na komi tinonidia Israel, oti vaovarongo toetoke mai itagua! Ighamu koti adoa ghohi a Jisas gna i Nasaret ke eia sethe na reghithehe ke hutu kori vido ke mono duamiu. A God ke hea a Jisas na mana bali eia na komi reghithehe eigna kotida adoa imanea ke vetula mai. ");
INSERT INTO bgt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kari leghuagna nigna na vanohehe ke mono tagna i hau, a God ke lubatighamu gi oti thotia a Jisas. Moti vathehea kori vido koti lubati vanoa tadia mara kena dika bali tupipuhia kori ghaibabala. ");
INSERT INTO bgt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Keana a God ke vamamaluha a Jisas tagna na paparagna na thehe me vasokara tabirua. Eigna na thehe ke boi tangomana na tangoliagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","King Deved ke risoa na hava ke velea a Vahavi: ‘Inau ku adoa a Lod ke mono duagu hahali, Inau kuda boi mataghu eigna imanea ke mono ghaghireigu. ");
INSERT INTO bgt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Na vunegna iangeni, na hehegu ke vonungia na totogo, ma na livogu keda kilothabagho! Inau ku vaututunigho ");
INSERT INTO bgt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ighoe koda boi lubatiu gi kuda talu mono kori thehe, ba boi lubatiu, nimua na mane tabu, kuda boto korai beku. ");
INSERT INTO bgt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ighoe ko tuhu vaniu na hangana bali hatia na havi, mi ighoe koda vatotogou eigna ighoe koda mono duagu hahali.’” ");
INSERT INTO bgt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Gi a Pita ke velera mua, “Ara kulagu, inau tangomana kuda veleghamu eigna a hutuda King Deved. I hau imanea ke thehe mena gilua ma na bekugna ke talu mono mua eeri. ");
INSERT INTO bgt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Na vunegna iangeni, ighita kati adoa imanea ke boi titionoa ghehegna. Kari a Deved na mane profet me adoa a God ke taluhaghorea vania ghohi gi sina mane kori vikegna keda nohe kori sapei vunaghi vaghagna imanea. ");
INSERT INTO bgt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Deved ke reghi vanoa ghohi na hava a God keda eia ivughei valiha, me velea a Vahavi keda sokara tabiru. Imanea ke velea a God keda boi lubatia a Vahavi keda talu thehe ma na tonogna a Vahavi keda boi boto korai beku. ");
INSERT INTO bgt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","A Deved ke titionoa a Jisas, ma God ke vasokara tabirua imanea kori thehe. Mi ighami gougovu kiti reghia imanea kori matamami. ");
INSERT INTO bgt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God ke hati hadia duagna i popo me vasopoua imanea kori na lima madothogna. Me hea na Tarunga ke Tabu vaghagna ke taluhaghorea. Gi a Jisas ke heghami na Tarunga ke Tabu me tatelia iangeni tagna na hava koti reghia moti rongovia ikeagaieni. ");
INSERT INTO bgt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","A Deved ke boi hadi i popo. Na vunegna iangeni, ighami kiti adoa a Deved ke boi titionoa ghehegna kori vido ke velea iaani, ‘A God ke velea tagna a vunaghigu, O nohe kori thevu madothogu ");
INSERT INTO bgt_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","me jufu kori maghavu kuda talu horua nimua na komi thevuioka i thepa eigna koda vunaghi pungusira.’ ");
INSERT INTO bgt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Mi ghamu gougovu na komi tinonidia i Israel, inau ku magnahaghinia kotida adoa iaani ke tutuni: a Jisas, na mane koti tupipuhia kori ghaibabala, a God ke vahia eigna keda a Lod ma a Vahavi. ");
INSERT INTO bgt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na komi haghore a Pita ke velea iraani ke pukuni haghevira. Gi ena huatira a Pita mi mara na vetula, “Na hava kitida eia?” ");
INSERT INTO bgt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ma Pita ke haghore tughura, “Oti talua na havimiu ke koakoa moti siuvitabu kori ahagna a Jisas Krais eigna a God keda talutavogha na paluhamiu. Leghugna iangeni a God keda heghamu na Tarunga ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nida a Lod God ke taluhaghorea gi keda hera na Tarunga ke Tabu tadia arahai ke vahira eigna kedana nigna na komi tinoni. Na taluhaghore iaani eimiu ighamu, ma ara dathemiu, ma arahai kena mono tagna na komi meleha ke hau. ");
INSERT INTO bgt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Gi a Pita ke titiono vanira sethe na fata mua. Imanea ke haghore heta tadia arahai kena rorongo itagna, “Oti lubatia a God eigna keda vahavighamu tagna na fate imanea keda eia tadia na komi tinoni dika kena mono kori maramagna iaani.” ");
INSERT INTO bgt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Na komi tinoni kena vaututunia na hava ke velea Pita, imarea kena siuvitabu. Kori dani iangeni vaghagna e tolu na toghai tinoni kena vaututunia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Imarea kena vaovarongo hahali kori nidia na velepuhi mara na vetula mena haidu duadia arahai kena vaututuni ghohi. Sethe na maghavu imarea kena vangahaidu mena eia na Vanga Tabu mena tarai haidu. ");
INSERT INTO bgt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na komi tinoni gougovu i Jerusalem kena ghaghana bohea a God eigna imanea ke hera mara na vetula na mana bali eia na komi reghithehe ke sethe. ");
INSERT INTO bgt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Na komi tinoni kena vaututuni kena haidu hahali mena kemulia nidia na komi fata varihotaghidia. ");
INSERT INTO bgt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Imarea kena salemura na komi fata kena tonogna mena hera na rongo arahai ke kudo vanira na rongo. ");
INSERT INTO bgt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Leuleghu dani imarea kena sakai mai mena tarai kori Vathe ke Tabu nigna a God. Imarea kena haidu tagna na komi vathedia mena eia na Vanga Tabu mena sakai vanga haidu. Imarea kena totogo nidia puala na kemuliagna ghadia na vanga. ");
INSERT INTO bgt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Imarea kena veletokea a God hahali ma na komi tinonidia i Jerusalem kena magnahaghinira. Leuleghu dani a Lod ke vahavira kekeha tinoni me vasethera arahai kena vaututuni. ");
INSERT INTO bgt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sina dani, nabagna tangi tolu kori hinaota, kori vido mara Jiu kena ado tarai, a Pita ma Jon koro vano haghe kori Vathe ke Tabu nigna a God bali tarai. ");
INSERT INTO bgt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kori vido iangeni, imarea kena hulungia maia sina mane ke thehe na naegna turughu kori havigna mai. Leuleghu dani imarea kena mai vanohea imanea kori hagethagna na Vathe ke Tabu kena kiloagna na “Hagetha Ulaghagna.” Imanea ke nohe ngengeni bali kakae nigna rongo tadia arahai kena vano haghe kori na Vathe ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Imanea ke reghira a Pita ma Jon koro haghe vano kori na Vathe ke Tabu, me kaera eigna koroda hea sa rongo. ");
INSERT INTO bgt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Iromara koro rei vano itagna, gi a Pita ke veleagna, “O rei mai itamami!” ");
INSERT INTO bgt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Na mane iangeni ke rei vano itadia, eigna imanea ke toatogha iromara koroda hea sa rongo. ");
INSERT INTO bgt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kari a Pita ke veleagna, “Teo sa nigua silva ba na gol, kari inau ke mono nigua na fata ke tavogha, ma na fata iangeni inau kuda hegho. Kori ahagna a Jisas Krais gna i Nasaret, o sokara hadi mo taveti!” ");
INSERT INTO bgt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Gi a Pita ke tangolia na lima madothogna me vasokaraghinia. Kori vido vamua iangeni, na naegna ke heta tabiru. ");
INSERT INTO bgt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Imanea ke sokara hadi saisami me turughu taetaveti kilili. Gi e vano haghe duadia a Pita ma Jon kori Vathe ke Tabu me taetaveti me soasogala me veletokea God. ");
INSERT INTO bgt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na komi tinoni ngengeni kena reghia imanea ke taetaveti kilili me veletokea God. ");
INSERT INTO bgt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Imarea kena ghithatha imanea na mane ke nohe hahali kori “Hagetha Ulaghagna” me kaekae rongo. Imarea kena vere nidia puala eigna na hava ke pada imanea. ");
INSERT INTO bgt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na komi tinoni gougovu kena vere nidia puala mena raghe vano itadia tagna na vido kena kiloagna, “Na Varada nigna a Solomon” ke mono koragna na Vathe ke Tabu. Ma na mane iangeni ke tatango vano tadia a Pita ma Jon. ");
INSERT INTO bgt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kori vido a Pita ke reghia sethe na tinoni kena haidu mai, imanea ke velera, “Ighamu na komi tinonidia Israel, ehava gi oti vere nimiu? Ehava gi oti buta puala itamami? Da oti toatogha iroghami kuru vataetavetia na mane iaani eigna romami na mana ke hutu ba eigna na havimami ke jino. Teo! ");
INSERT INTO bgt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nidia a God a Ebraham, a Aisak, ma Jekob, ma ara hutuda, imanea ke vahaihadia a Jisas, nigna na mane agutu, kori vido ke vahavi tabirua. Imanea na mane ighamu koti lubati vanoa tadia mara puhidia i Rom eigna kedana vathehea. Toke a Pailat ke magnahaghinia na vamamaluhagna imanea, ighamu koti veleagna a Pailat koti boi magnahaghinia a Jisas keda nimiu na king. ");
INSERT INTO bgt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ighamu koti siriuhaghinia na mane ke tabu meke jino iangeni, moti kaea a Pailat eigna keda lubati mamaluha kori vathe tatari na mane ke vathehea na tinoni. ");
INSERT INTO bgt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ighamu koti vathehea na mane ke batura na komi tinoni tagna na havi ke tutuni. Keana a God ke vasokara tabirua kori thehe. Mi ghami kiti reghia a Jisas kori matamami leghugna ke ghoi havi tabiru. ");
INSERT INTO bgt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ighamu koti reghia moti adoa na mane iaani ke thehe na naegna i hau. Na vunegna ighami kiti vaututunia a Jisas, imanea ke vaheta na naegna. Hee, na mane iaani ke pukuni toke tabiru eigna nigna na vaututuni tagna a Jisas. Mi ghamu koti reghia ghohi na fata iaani! ");
INSERT INTO bgt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ara kulagu, ighamu mara Jiu ma arahai kena batughamu, inau ku adoa ighamu koti eia na fata ke dika tagna Jisas eigna koti boi adoa imanea a Vahavi. ");
INSERT INTO bgt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Keana a God ke kidi velera ghohi mara na komi profet a Vahavi keda papara me thehe, mi ikeagaieni na komi fata a God ke velera i hau ke jufu mai ghohi. ");
INSERT INTO bgt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Na vunegna iangeni, ighamu kotida tughua na havimiu ke koakoa moti leghua a God eigna imanea keda vararahaghamu tadia na komi paluhamiu. ");
INSERT INTO bgt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Gi ighamu kotida eia iangeni, a Lod God keda vatokeghamu kori vahetagna na ghaghanamiu. Mi manea keda ghoi vetula tabirua a Jisas Krais itamiu, na mane a God ke vahia bali a Vahavimiu. ");
INSERT INTO bgt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Keana a Jisas keda talu mono i popo me ghieghilei jufu mai na maghavu a God keda vamathangani tabirura na komi fata gougovu ke vavuha. A God ke taluhaghorea iaani i hau me vahira nigna na komi profet bali tuturia aua. ");
INSERT INTO bgt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Eigna i hau a Moses ke velera ara hutuda, ‘A Lod na nimiu a God keda heghamu sikei mua na profet ke vagaghu inau mi manea keda au mai itamiu ghamu na komi tinonidia Israel. Oti vaovarongo toetoke tadia na komi fata gougovu keda veleghamu imanea. ");
INSERT INTO bgt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ahai keda bosi magnahaghinia na rongoviagna na hava ke velea na profet iangeni, a God keda hati aua na mane iangeni tadia nigna na komi tinoni me vapara thovohaliua.’ ");
INSERT INTO bgt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Samuel ma na komi profet kena mono mai leghugna a Moses kena titionoa na komi fata ke tate mai ikeagaieni. ");
INSERT INTO bgt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Na vunegna ighamu ara dathedia na komi profet irangeni, na taluhaghore ke eia a God tadia ara hutuda, na taluhaghore vanighamu mua ighamu. Eigna God ke taluhaghorea tagna Ebraham me veleagna, ‘Inau kuda vatokera na komi tinoni gougovu kori maramagna eigna sina tinoni kori vikemu.’” ");
INSERT INTO bgt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Gi a Pita ke velea mua, “Kori vido a God ke vetula maia a Jisas, nigna na mane agutu, imanea ke kidi vetula atua itamiu ighamu mara i Israel. A God ke eia iaani eigna ke magnahaghinia keda vatokeghamu me hatheghamu eigna kotida tughua na havimiu ke koakoa.” ");
INSERT INTO bgt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kori vido a Pita ma Jon koro talu titiono mua tadia na komi tinoni, kekeha mara na pris duadia na vunaghigna na booi soldia kena kaekalea na Vathe ke Tabu nigna a God, mi kekeha mara na Sadiusi kena mai itadia. ");
INSERT INTO bgt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Imarea kena dikatadia eigna a Pita ma Jon koro titionoa na sokara tabirugna Jisas ke tateli aua a God keda vasokara tabirura na komi tinoni gougovu kori thehe. ");
INSERT INTO bgt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Gi ena thotira. Na vunegna ke lavi ghohi, imarea kena bora haghe kori vathe tatari me ghieghilei vuevughei. ");
INSERT INTO bgt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Me sethe na tinoni kena rorongo itadia kena vaututunia a Jisas. Mara mane kena kidi vaututuni ghohi duadia mara mane kena eu vaututuni, vaghagna e lima na togha. ");
INSERT INTO bgt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na dani leghugna iangeni mara puhidia mara Jiu duadia mara velepuhigna na vetula nigna Moses kena haidu i Jerusalem. Mara iraani Mara na Kansol. ");
INSERT INTO bgt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas, na pukuni naghoi pris duagna Kaiafas, Jon, Aleksanda, mi mara kori na vikegna na pukuni naghoi pris kena mono mua duadia. ");
INSERT INTO bgt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Imarea kena velera mara na soldia eigna kedana hatira mai a Pita ma Jon i naghodia. Gi ena huatira, “Ahai ke heghamu na mana gi oro vatoke tabirua na mane ke thehe na naegna iangeni?” ");
INSERT INTO bgt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na Tarunga ke Tabu ke batua na ghaghanagna a Pita gi e velera, “Ighamu koti batughita ighita mara Jiu mi ghamu mara puhi, ");
INSERT INTO bgt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ikeagaieni oti huatighami eigna na fata ke toke kuru ei vania na mane ke thehe na naegna. Moti huatighami mua eigna na puhi kuru eia bali vatoke tabirua. ");
INSERT INTO bgt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Inau ku veleghamu ghamu gougovu ma na komi tinonidia i Israel, na mana nigna a Jisas Krais gna Nasaret ke vatokea na mane iaani ke sokara naghomiu ikeagaieni. Ighamu koti tupipuhia a Jisas, kari a God ke vasokara tabirua. ");
INSERT INTO bgt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na komi Rioriso ke Tabu kena titiono eigna a Jisas vaghagna iaani, ‘Na ghahira kena boi magnahaghinia mara kena agutu vathe, ikeagaieni na ghahira iaani na naghoi ghahira tadia na komi ghahira kori hidigna na vathe.’ ");
INSERT INTO bgt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","A Jisas vamua ke tangomana na vahavighitagna. Eigna e teo mua ahai kori maramagna a God ke vetula maia bali vahavighita.” ");
INSERT INTO bgt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mara kori Kansol kena vere nidia puala kori vido koro boi mataghunira. Eigna imarea kena adora iromara koro hai tinoni vamua moro boi sikolu toetoke. Gi imarea kena togha tabirua iromara koro mono duagna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Me vahothahaghinira na veleagna sa fata mua eigna na mane ke toke tabiru ke sokara duadia a Pita ma Jon. ");
INSERT INTO bgt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Gi mara na Kansol kena vetulara au itadia mena turughu titiono varihotaghidia. ");
INSERT INTO bgt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Imarea kena velea, “Na hava katida eia tadia e rua na mane iaani? Na komi tinoni gougovu i Jerusalem kena adoa iromara koro eia na reghithehe ke hutu, mati boi tangomana na veleragna iromara koro boi eia. ");
INSERT INTO bgt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Keana e toke gi katida lutira iromara na titionoagna a Jisas tagna ahai eigna katida vasotoa na rongoraghagna na titiono eigna a Jisas tadia na komi tinoni.” ");
INSERT INTO bgt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Imarea kena kilora tabiru mai a Pita ma Jon mena haghore heta vanira eigna koroda boi titiono ba velepuhi eigna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Keana a Pita ma Jon koro haghore tughura vaghagna iaani, “Ehava na ghaghanamiu? A God ke magnahaghinighami iroghami kuruda leghughamu ba leghua imanea? ");
INSERT INTO bgt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Iroghami boi tangomana kuruda soto na titionoagna na komi fata kuru reghia a Jisas ke eia ma na komi nigna na velepuhi kuru rongovia.” ");
INSERT INTO bgt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Gi Mara na Kansol kena ghoi haghore heta tadia mena vetulara au. Imarea kena eia iangeni eigna kena boi tangomana nidia na padagna sa vunegna eigna kedana fatera bali vaparara. Gi kedana vaparara iromara, imarea kena adoa na mavitu kedana dikatadia eigna imarea kena veletokea a God eigna na hava ke pada na mane ke thehe na naegna. ");
INSERT INTO bgt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Na mavitu gougovu kena adoa na vatokeagna na mane iangeni, sina reghithehe, eigna imanea ke boi tangomana na taetaveti koragna e rua tutughu tomagha na vinogha. ");
INSERT INTO bgt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kori vido imarea kena vamamaluhara, Pita ma Jon koro tabiru vano tadia na komi tinoni kena vaututuni moro titionoa na hava kena veleragna mara na naghoi pris mi kekeha mara puhi. ");
INSERT INTO bgt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kori vido kena rongovia na hava koro titionoa, imarea kena sakai tarai tagna God mena velea, “Lod, ighoe ko vavuha na maaloa, na thepa, na tahi ma na komi hava gougovu koradia. ");
INSERT INTO bgt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ighoe ko veleagna nimua na Tarunga ke Tabu eigna keda batua nimua na mane agutu a Deved, a hutumami, kori vido ke velea iaani: ‘Ehava kena dikatadia mara kena boi Jiu? Ehava gi na komi tinoni kena vapuipuhi na komi fata ke mee? ");
INSERT INTO bgt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Na komi king kori maramagna iaani ena kaikaliti bali rihu, ma na koi vunaghi kena haidu bali sokara pungusira a Lod God ma ahai a God ke vahia eigna keda a Vahavi.’ ");
INSERT INTO bgt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Na fata ke velea Deved iaani ke tate mai ghohi kori meleha iaani! A Herod Antipas ma Pontius Pailat duadia arahai kena boi Jiu ma na komi tinonidia i Israel kena hathatano mai mena vapuipuhi bali vathehea a Jisas. Imanea nimua na mane agutu ke tabu ko vahia eigna keda a Vahavi. ");
INSERT INTO bgt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Na komi puhi kena eia ke pukuni leghua vamua nimua na vanohehe ko ghaghana i hau. ");
INSERT INTO bgt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","God, o dodoro toetoke tagna na haghore heta kena eia mara puhi itamami, mo hatheghami ighami nimua na komi tinoni agutu eigna kitida boi mataghu na titionoagna na haghoremu. ");
INSERT INTO bgt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","O tatelia nimua na mana eigna kitida vatoke tabirura arahai kena vahaghi miti eia na komi reghithehe kori na ahagna a Jisas, nimua na mane agutu ke tabu. Amen.” ");
INSERT INTO bgt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kori vido kena vagovua na tarai, na vathe kena mono itagna ke turughu ghaighali. Mi marea gougovu ke vonungira na Tarunga ke Tabu. Leghugna iangeni imarea kena boi mataghu na titionoagna na haghoregna a God eigna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na komi tinoni kena vaututuni kena sikei vamua na ghaghanadia. Teo sikei itadia ke ghaghana keda tonogna sa fata keda nigna ghehegna. Na komi fata gougovu kena tonogna, na nidia mara gougovu. ");
INSERT INTO bgt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mara na vetula kena heta puala na titionoagna na sokara tabiruagna a Lod Jisas kori thehe. Ma a God ke pukuni vatokera na havidia na komi tinoni gougovu kena vaututuni. ");
INSERT INTO bgt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Imarea gougovu kena mono nidia na komi fata ke nabadia. Eigna arahai kena tonogna kekeha vidoi thepa ba tonogna kekeha vathe kena salemura mena hatia mai na rongogna ");
INSERT INTO bgt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tadia mara na vetula. Mi marea kena kemulia tadia arahai ke teo kekeha nidia fata. ");
INSERT INTO bgt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sina mane ke eia iangeni a Josep. Josep na manegna na moumolu i Saiprus me havi mai kori vikegna a Livai. Mara na vetula kena kiloagna Banabas, na ghaghana koragna, “na mane ke vaheta na ghaghanadia na komi tinoni.” ");
INSERT INTO bgt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Imanea ke salemua sina vidoi thepa ke tonogna me hatia maia na rongogna tadia mara na vetula. ");
INSERT INTO bgt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sina mane, na ahagna a Ananaias, duagna a Safaira, a taugna, koro salemua sina vidoi thepa koro tonogna. ");
INSERT INTO bgt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananaias ke hati maia sina thevugna na rongo tadia mara na vetula, keana ke velera ke hera na rongo gougovu. A Safaira ke adoa na fata ke dika iaani ke eia imanea mi iia ke hiia. ");
INSERT INTO bgt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pita ke veleagna, “Ananaias, ehava gi o lubatia a Satan eigna keda batua na ghaghanamu? Ighoe ko pilaunia na Tarunga ke Tabu mo tangolia na thevugna na rongo bali nimua. ");
INSERT INTO bgt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Na vidoi thepa ko salemua iangeni, na nimua thepa ghehemu gi o salemua. Kari leghugna ighoe ko salemua, na rongo ko hatia na nimua rongo gougovu bali eia sa fata ko magnahaghinia itagna. Ehava kona eia na fata ke dika iaani? Ighoe ko boi pilaunighami vamua, keana o pilaunia mua a God!” ");
INSERT INTO bgt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kori vido a Ananaias ke rongovia na komi haghore ke eia a Pita, imanea ke sikili horu me thehe. Ma arahai kena rongovia na rorongogna na hava ke pada imanea kena mataghu nidia puala. ");
INSERT INTO bgt_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kekeha mane mathangani kena mai mena filehia na tonogna kori pohe. Gi ena hulungia vanoa mena gilua. ");
INSERT INTO bgt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Leghugna tolu na aoa, a taugna Ananaias ke haghe mai kori vathe iangeni. Kari iia ke boi adoa na hava ke pada a taugna. ");
INSERT INTO bgt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita ke huatiagna, “Ehava? Iraani vamua na rongo koro hatia kori vidoi thepa koro salemua na?” Iia ke haghore tughua, “Hii, iangeni vamua na rongo koro hatia.” ");
INSERT INTO bgt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Gi a Pita ke veleagna, “Ehava gi oro vapuhia na piipiliagna na Tarunga ke Tabu nigna a God na? Reghia, mara mane mathangani kena gilua a taumu kena haga jufu mai kori hagetha. Imarea kedana hulungia aua mua na tonomu!” ");
INSERT INTO bgt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kori vido vamua iangeni, iia ke sikili horu naghogna a Pita me thehe. Kori vido mara mane mathangani kena haghe mai mena reghia iia ke thehe ghohi, imarea kena hulungia aua mena vano gilua ghaghireigna a taugna. ");
INSERT INTO bgt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ma na komi tinoni gougovu kena vaututuni ma arahai kena rongovia na hava ke padara roira, imarea kena mataghu nidia puala. ");
INSERT INTO bgt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sethe na komi reghithehe kena eia mara na vetula kori matadia na mavitu. Sethe na maghavu na komi tinoni kena vaututuni kena haidu koragna na Vathe ke Tabu, kori vido kena kiloagna, “Na Varada nigna Solomon.” ");
INSERT INTO bgt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Arahai kena boi vaututuni kena mataghu na mono haidu duadia, keana imarea kena titiono vahaihadira. ");
INSERT INTO bgt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Me sethe puala na mane ma na vaivine kena vaututunia a Lod mena turughu haidu duadia arahai kena vaututuni ghohi. ");
INSERT INTO bgt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na vunegna sethe na reghithehe kena eia mara na vetula, na komi tinoni kena hatira mai arahai kena vahaghi mena va'egora horu tadia na komi mathadia kori hangana. Imarea kena toatogha arahai kena vahaghi kedana toke tabiru kori vido na ungangagna a Pita keda ungahira kori vido imanea keda taveti atu. ");
INSERT INTO bgt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Sethe na tinoni itadia na komi meleha ke gharania i Jerusalem kena hathatano mai. Imarea kena hatira mai tadia mara na vetula arahai kena vahaghi ma arahai ke haghevira na komi tidatho. Ma God ke vatoke tabirura gougovu. ");
INSERT INTO bgt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na pukuni naghoi pris ma arahai kena agutu duagna kena mono kori boo nidia mara na Sadiusi. Imarea kena tahotha puala tadia mara na vetula. ");
INSERT INTO bgt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Imarea kena thotira mena bora haghe kori vathe tatari. ");
INSERT INTO bgt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Keana sina enjel nigna a Lod ke mai kori bongi me hangavia na hagethagna na vathe tatari me hatira au mara na vetula. Gi e velera, ");
INSERT INTO bgt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Oti vano kori Vathe ke Tabu nigna a God moti titionoa na komi fata gougovu eigna na havi mathangani iaani tadia na komi tinoni.” ");
INSERT INTO bgt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mara na vetula kena leghua na hava ke velea na enjel. Kori vuevugheigna hadi, imarea kena vano kori Vathe ke Tabu mena velepuhira na komi tinoni. Ma na pukuni naghoi pris ma arahai kena agutu duagna kena kilora mai mara puhidia mara Jiu kena mono kori Kansol. Gi ena vetulara vano kekeha soldia kori vathe tatari eigna kedana hatira mai mara na vetula. ");
INSERT INTO bgt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Keana kori vido mara na soldia kena jufungia na vathe tatari, imarea kena boi reghipadara. Gi ena tabiru mai tadia mara na Kansol mena velera, ");
INSERT INTO bgt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kori vido kiti jufungia na vathe tatari, na hagethagna ke bilaki ngasi mi mara na soldia kena sokara ghaghireigna na hagetha. Kari kori vido kiti hangavia na hagethagna miti vano haghe, e teo sa tinoni ke mono ikoragna.” ");
INSERT INTO bgt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na vunaghidia mara kena reireghia na Vathe ke Tabu nigna a God mi mara na naghoi pris kena rongovia iaani, mena hahi hehedia puala eigna na hava ke padara mara na vetula. ");
INSERT INTO bgt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Gi sina tinoni ke mai me velera, “Mara koti bora haghe kori vathe tatari, ikeagaieni imarea kena velepuhira na mavitu kori Vathe ke Tabu nigna a God!” ");
INSERT INTO bgt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Na vunaghidia mara kena reireghia na Vathe ke Tabu duagna nigna na komi mane agutu kena vano mena hatira mai mara na vetula. Kari imarea kena boi vangesora eigna kena mataghunira na mavitu. Eigna imarea kena ghaghana gi kedana vangesora, na mavitu kedana piri vathehera. ");
INSERT INTO bgt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Gi imarea kena hatira mai mara na vetula naghodia mara na Kansol. Na pukuni naghoi pris ke velera, ");
INSERT INTO bgt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ighami kiti veleghamu ghohi, oti saghoi velepuhira na mavitu eigna na mane iangeni. Kari ighamu koti velepuhira sethe na tinoni i Jerusalem eigna a Jisas, moti magnahaghinia na toroghamigna eigna na theheagna imanea.” ");
INSERT INTO bgt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita mi mara na vetula kena haghore tughu vaghagna iaani, “Ighami kitida leghua a God vamua, boi na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ighamu koti tupipuhia a Jisas kori ghaibabala moti vathehea. Keana nidia na God ara hutuda ke vasokara tabirua kori thehe. ");
INSERT INTO bgt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","A God ke vahaihadia me vasopoua kori madothogna eigna keda vunaghi pungusighita me vamamaluhaghita. Imanea ke eia iaani bali hathera mara Israel eigna kedana tughua na havidia ke koakoa. Gi kedana tughua na puhidia, a God keda talutavogha na komi paluhadia. ");
INSERT INTO bgt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ighami kiti titionoa na komi fata iraani tadia na komi tinoni ma na Tarunga ke Tabu ke tateli vanira na komi fata iraani ke tutuni. A God ke hea na Tarunga ke Tabu itadia arahai kena leghua.” ");
INSERT INTO bgt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kori vido Mara na Kansol kena rongovia iaani, imarea kena dikatadia puala mena magnahaghinia kedana vathehera mara na vetula. ");
INSERT INTO bgt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kari sikei itadia Mara na Kansol, na ahagna a Gamaliel, ke sokara hadi me velera eigna kedana hatira au i kosi mara na vetula bali pitu sina vido. Imanea na Farise ma na mane velepuhigna na vetula. Na komi tinoni gougovu kena ghaghana bohea imanea. ");
INSERT INTO bgt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gamaliel ke velera mara na Kansol vaghagna iaani, “Mara i Israel, oti toatogha toetoke eigna na hava koti magnahaghinia na eiagna vanira mara iraani. ");
INSERT INTO bgt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ighamu koti adoa ghohi, tagna kekeha vinogha ke atu, sina mane na ahagna a Teudas ke velea imanea ghehegna sina mane nagho. Me vaghagna vati na hathangatu mane kena leghua. Kari leghugna mara i Rom kena vathehea imanea, vati na hathangatu mane kena leghua kena soparaka kilili ma na nigna na boo ke govu. ");
INSERT INTO bgt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Leghugna iangeni, kori maghavugna na gaumane i Rom kena risoa na ahadia na komi tinoni gougovu, a Jiudas, sina manegna i Galili ke mai. Sethe na tinoni kena leghua imanea kari mara i Rom kena vathehea mua. Ma na komi tinoni kena leghua kena soparaka kilili. ");
INSERT INTO bgt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na hava ku veleghamu ikeagaieni ke vaghagna iaani: Oti saghoi eia sa fata itadia mara iraani moti lubatira me kena mamaluha. Gi na komi fata kena eia keda leghua vamua na ghaghanadia, nidia na boo keda boi haugna me govu! ");
INSERT INTO bgt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kari gi na komi fata iraani ke leghua nigna na vanohehe a God, e vahotha puala ighamu kotida vasotora. Toatogha toetoke gi kotida eia sa fata itadia, eigna e boi toke gi ighamu kotida rihu pungusia a God.” ");
INSERT INTO bgt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mara na Kansol kena ghaghana na komi fata ke velea a Gamaliel ke jino. Imarea kena kilora mai mara na vetula mena velera mara na soldia bali thabuhira. Gi Mara na Kansol kena haghore heta vanira eigna kedana boi titionoa mua eigna a Jisas. Govu, gi ena lubati mamaluhara. ");
INSERT INTO bgt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Imarea kena taveti au tadia Mara na Kansol mena totogo puala eigna a God ke lubatira eigna kedana papara eigna kena leghua a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Leuleghu dani imarea kena talu velepuhira na komi tinoni kori Vathe ke Tabu nigna a God mi kori vathedia na komi tinoni. Imarea kena titionoa a Jisas a Vahavi. ");
INSERT INTO bgt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tagna na komi dani irangeni, kori vido sethe na tinoni kena turughu leghua a Jisas, na komi tinoni Jiu kena vaututuni kena haghore kori haghore Grik kena dikatadia tadia na komi tinoni Jiu kena vaututuni kena haghore kori haghore Arameik. Imarea kena velea mara kena haghore Arameik kena boi hathe toetokera nidia na vaivine thehe sasani kori vido kena kemulira na komi vanga leuleghu dani. ");
INSERT INTO bgt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mi mara salaghe rua na mane vetula kena kilora haidu na komi tinoni kena vaututuni gougovu mena velera, “E boi jino gi kitida soto na titionoagna na haghoregna a God miti rugusi eigna na keukemu vanga. ");
INSERT INTO bgt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ara kulamami, oti vahira au itamiu e vitu na mane kena ghaghana bohera na komi tinoni. Imarea iraani kedana lubatia na Tarunga ke Tabu eigna keda batura me kedana thaothadogha. Ighami kitida hera na agutu iaani ");
INSERT INTO bgt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","eigna kitida tarai miti talu titionoa na haghoregna a God eigna a Jisas.” ");
INSERT INTO bgt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Na komi tinoni gougovu kena ghaghana na komi fata iraani kena velea mara na vetula ke toke. Gi ena vahira Stiven (nigna na vaututuni ke heta puala me lubatia na Tarunga ke Tabu eigna keda batua), Filip, Prokorus, Nikano, Timon, Pamenas, ma Nikolas (sina manegna i Antiok ke boi Jiu kari e leghua na komi puhidia mara Jiu). ");
INSERT INTO bgt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Imarea kena hatira vano e vitu na mane tadia mara na vetula, gi ena taboa na uludia mena tarai eidia. ");
INSERT INTO bgt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Na haghoregna a God eigna a Jisas ke rongoragha tadia sethe na meleha. Ma na komi tinoni kena vaututuni i Jerusalem kena ghoi sethe vano. Me sethe na pris kena vaututunia mua na velepuhi eigna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God ke vatokea a Stiven me hea na mana bali eia sethe na reghithehe itadia na komi tinoni. ");
INSERT INTO bgt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kari kekeha tinoni Jiu kori vathe haidu kena kiloagna “Na Vathe Haidu nidia mara Seka kena Mamaluha ghohi” kena turughu sokara pungusia a Stiven. Mara iraani eidia e rua na meleha i Sairin mi Aleksandria, me rua na provins i Kilikia mi Esia. Imarea kena rihu haohaghore duagna a Stiven. ");
INSERT INTO bgt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kari ena boi tangomana na haghore tughuagna, eigna na Tarunga ke Tabu ke hathea imanea ma nigna na komi haghore ke thaothadogha puala. ");
INSERT INTO bgt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Gi imarea kena volira kekeha mane eigna kedana piapilau eigna a Stiven. Imarea kena velea, “Ighami kiti rongovia na mane iaani ke haghore diadikala Moses ma God.” ");
INSERT INTO bgt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na vunegna imarea kena velea iaani, na mavitu gougovu duadia mara puhidia mara Jiu mi mara Velepuhigna na Vetula nigna a Moses kena dikatadia tagna a Stiven. Imarea kena thotia mena hati vanoa tadia Mara na Kansol. ");
INSERT INTO bgt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Gi marea kena hatira mai kekeha tinoni bali piapilau eigna imanea. Imarea kena velea, “Na mane iaani ke haghore diadikala hahalia na Vathe ke Tabu nigna a God ma na komi vetula nigna a Moses. ");
INSERT INTO bgt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ighami iti rongovia imanea ke velera na komi tinoni a Jisas gna i Nasaret keda reo horua na Vathe ke Tabu me tughura nida na komi puhi ke heghita a Moses.” ");
INSERT INTO bgt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Gi mara gougovu kori Kansol kena buta heta vano tagna Stiven mena reghia na dodorogna imanea, turughu kori langegna me horu kori luagna, ke vaghana na dodorogna na enjel. ");
INSERT INTO bgt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na pukuni naghoi pris ke huatia a Stiven, “Ehava? E tutuni ighoe ko haghore diadikala a God ma Moses ma na Vathe ke Tabu nigna a God?” ");
INSERT INTO bgt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Gi a Stiven ke velea, “Mara puhi ma ara kulagu, rorongo mai itagua. A God ke thaba haluhadi ke tate vania a hutuda Ebraham kori vido imanea ke mono i Mesopotamia, gi e vano mono i Haran. ");
INSERT INTO bgt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","A God ke veleagna, ‘Taveti au kori melehamu mi tadia ara vikemu mo vano kori na meleha inau kuda tuhu vanigho.’ ");
INSERT INTO bgt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ma Ebraham ke taveti au i Kaldea me vano mono i Haran me ghieghilei thehe a tamagna. Gi a God ke hatia maia a Ebraham eeri, kori meleha ighita kati mono itagna ikeagaieni. ");
INSERT INTO bgt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kori vido iangeni, a God ke boi hea a Ebraham sa vidoi thepa eeni, teo sikei ghathi vidogna. Keana a God ke taluhaghorea gi keda hea na meleha iaani vania Ebraham ma arahai kedana havi mai kori vikegna. Toke a Ebraham ke boi mono sa dathegna kori vido iangeni, a God ke taluhaghorea iaani vania imanea. ");
INSERT INTO bgt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kari a God ke velea mua iaani, ‘Arahai kedana havi mai kori vikemu kedana mono tagna sina meleha hutu nidia na komi tinoni tavogha. Na komi tinoni ngengeni kedana vasekara me kedana vaparara koragna e vati na hathangatu vinogha. ");
INSERT INTO bgt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kari na komi tinoni kedana vasekara ara vikemu, inau kuda vaparara. Leghugna iangeni imarea kedana taveti au kori meleha hutu iangeni mena mai maimanihihiu eeri.’ ");
INSERT INTO bgt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Gi a God ke velea Ebraham eigna keda sogivaughithathara na komi gari mane, iaani na vaughithathagna na taluhaghore a God ke hea Ebraham. Na vunegna iangeni, a Ebraham ke sogivaughithatha a Aisak e alu na dani leghugna ke havi mai. Ma Aisak ke sogivaughithatha Jekob, a dathegna. Ma Jekob ke sogivaughithathara e salaghe rua na dathegna mane. Imarea iraani e salaghe rua ara hutuda. ");
INSERT INTO bgt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ara dathegna mane a Jekob kena tahotha puala tagna a Josep, a tahidia. Mena salemua vanoa itadia kekeha tinoni mi marea kena hati vanoa i Ijip eigna keda nigna na tinoni seka sina mane ngengeni. Keana a God ke mono duagna, ");
INSERT INTO bgt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","me hati mamaluha tagna na komi vahotha ke pada. Na king gna i Ijip, ke ghaghana bohea a Josep eigna na thaothadogha ke hea a God ke hutu puala. Ma na king ke hea na mana a Josep eigna keda vunaghi pungusira na komi tinonidia i Ijip me reireghira nigna na komi fata gougovu. ");
INSERT INTO bgt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Kori vido iangeni na maghavu ke teo vanga ke kathera na komi meleha gougovu i Ijip mi Kenan. Na komi tinoni gougovu kena papara puala ma ara dathegna a Jekob, ara hutuda, kena boi tangomana na padagna sa vanga. ");
INSERT INTO bgt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kori vido Jekob ke rongovia na vanga ke mono i Ijip, imanea ke vetulara ara hutuda ngengeni. Iangeni na turughugna na vanodia i Ijip. ");
INSERT INTO bgt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kori varuai vanodia, a Josep ke velera ara toghagna imanea a pukuni tahidia. Kori vido iangeni na komi tinoni kena titiono vania na king gna i Ijip eigna na vikegna a Josep. ");
INSERT INTO bgt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Gi a Josep ke vetula vanoa na haghore tagna a Jekob, a tamagna, mara vikegna gougovu eigna kedana mai i Ijip. Ma na haidudia, e vitu hangavulu lima na tinoni. ");
INSERT INTO bgt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Gi a Jekob ke vano mono i Ijip. Mi imanea duagna ara dathegna mane gougovu kena thehe ngengeni. ");
INSERT INTO bgt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Sethe na vinogha leghugna iangeni, kori vido mara i Israel kena taveti au i Ijip, imarea kena hatira na huludia mena vano gilura i Sekem, kori na luma ke volia a Ebraham tadia ara dathegna mane a Hemo. ");
INSERT INTO bgt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kori vido na maghavu a God keda eia na hava ke taluhaghorea vania Ebraham ke gharani mai ghohi, na nida na komi tinoni ighita mara Israel kena mono i Ijip ke sethe puala. ");
INSERT INTO bgt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Gi sina king tavogha ke vunaghi pungusia Ijip. Imanea ke boi adoa a Josep ma na komi fata ke eia i hau. ");
INSERT INTO bgt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Imanea ke pilaunira ara hutuda me vaparara puala. Imanea ke hurura eigna kedana sonira kori bea na komi meomeo mane. ");
INSERT INTO bgt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Kori vido iangeni a Moses ke havi mai. Imanea na gari meomeo ke ulaghagna puala. A idogna ma tamagna koro reireghia kori vathedia nabagna e tolu na vula. ");
INSERT INTO bgt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kori vido koro boi tangomana rodia na poloagna, iroira koro boa aua i kosi, ma a dathegna vaivine na king ke pada me kalitia vaghagna a pukuni dathegna. ");
INSERT INTO bgt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mara i Ijip kena velepuhia imanea na komi fata kena thaothadoghagna. Imanea na mane thaothadogha kori haghore ma na komi fata ke eia ke toke puala. ");
INSERT INTO bgt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Sina dani, kori vido a Moses ke rua tutughu kasa na vinoghagna, imanea ke magnahaghinia keda reghira nigna na komi tinoni, mara i Israel. ");
INSERT INTO bgt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kori vido ke vano, imanea ke reghia sina manegna Ijip ke tupi diadikala sina manegna Israel. Gi a Moses ke hathea na manegna Israel me tughu tabirua na hahi ke eia na manegna Ijip me vathehea. ");
INSERT INTO bgt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A Moses ke toatogha nigna na komi tinoni kedana adoa a God ke vahia imanea eigna keda vamamaluhara, keana imarea kena boi thaothadoghagna. ");
INSERT INTO bgt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Sina dani leghugna iangeni a Moses ke reghira e rua na manegna Israel koro rihu. Imanea ke hatia na hetagna eigna keda vasotora me velera, ‘Romara! Roghamu eimiu i Israel vamua. Ehava gi oro rihu?’ ");
INSERT INTO bgt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Keana na mane ke turughua na rihu ke hovu aua a Moses me veleagna, ‘Ahai ke velegho ighoe vaghagna na vunaghi bali fateghami na? ");
INSERT INTO bgt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ehava? O haga vatheheu vaghagna ko vathehea sina manegna i Ijip ignotha?’ ");
INSERT INTO bgt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Leghugna ke rongovia na haghore iaani, a Moses ke ghogho au i Ijip me vano mono i Midian. Kori vido ke mono ngengeni a Moses ke taulaghi me havi e rua na dathegna mane. ");
INSERT INTO bgt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Leghugna e rua tutughu na vinogha, sina enjel ke tate vania a Moses kori vido ke mono kori meleha ke gou hilighagna na suasupa i Sinai. Na enjel ke tate mai kori na ghai iso ke beubethu. ");
INSERT INTO bgt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses ke reghia na ghai ke beubethu me vere nigna puala. Me huju vano itagna eigna keda reghi tokea. Gi a Lod God ke velea, ");
INSERT INTO bgt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Inau nidia a God ara hutumu, a God nidia Ebraham, Aisak, ma Jekob.’ Moses ke mataghugna puala me aiariri. Imanea ke mataghu nigna na doroviagna na ghai iso ke beubethu. ");
INSERT INTO bgt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Gi a God ke veleagna, ‘O hatia aua nimua na sadol kori naemu, eigna ighoe ko sokara kori thepa ke tabu. ");
INSERT INTO bgt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Inau ku reghia ghohi mara Ijip kena vaparara puala nigua na komi tinoni mu rongovia nidia na tangi. Na vunegna iangeni, inau ku horu mai bali vamamaluhara. Ikeagaieni inau kuda vetulagho tabiru i Ijip.’” ");
INSERT INTO bgt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Gi a Stiven ke velea mua, “A God ke vetula tabirua i Ijip a Moses, iangeni na mane na komi tinonidia i Israel kena siriuhaghinia i hau, kori vido kena velea, ‘Ahai ke velegho ighoe vaghagna na vunaghi bali fateghami na?’ Kari a God ke vetula imanea eigna keda vunaghi pungusira me vamamaluhara. Ma na enjel ke tate vania a Moses kori na ghai iso, imanea ke hathea a Moses kori eiagna. ");
INSERT INTO bgt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ma Moses ke batura au mara Israel i Ijip. Imanea ke eia na komi reghithehe ke sethe i Ijip, kori Tahi ke Mela, mi kori meleha ke gou koragna e rua tutughu na vinogha. ");
INSERT INTO bgt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Iaani a Moses, na mane ke velera mara Israel, ‘A God keda vahi aua sikei profet vaghagu inau itadia nimiu na komi tinoni.’ ");
INSERT INTO bgt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ma Moses ke mono duadia ara hutuda kori vido kena mono kori meleha ke gou. Imanea ke titionoa tadia ara hutuda na komi fata ke titiono vania na enjel kori suasupa Sainai. A God ke kidi titionoa tagna a Moses na komi haghore i havi. Gi a Moses ke heghita ighita. ");
INSERT INTO bgt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Keana ara hutuda kena bosi sasaa na leghuagna a Moses mena magnahaghinia kedana tabiru i Ijip. ");
INSERT INTO bgt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kori vido a Moses ke talu mono mua kori suasupa, imarea kena veleagna a Eron, ‘O agutu vanighami kekeha ngunguju bali batughita! Moses ke batughita au i Ijip, kari iti boi adoa na hava ke pada imanea.’ ");
INSERT INTO bgt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kori vido iangeni imarea kena agutua na ngunguju ke vaghagna na kau mena havughaghi itagna. Mi marea kena eia na vangahaidu hutu bali totogo tagna na ngunguju kena agutua ghehedia. ");
INSERT INTO bgt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Na vunegna iangeni a God ke taveti sanira me lubatira eigna kedana maimanihihia na aho, na vula ma na komi vaitughu. Iaani ke mono tagna na komi Rioriso ke Tabu kena risoa mara na profet: ‘Ighamu na komi tinonidia Israel, koragna e rua tutughu na vinogha ighamu koti mono kori meleha ke gou, ighamu koti boi havughaghi tagua inau. ");
INSERT INTO bgt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Teo. Ighamu koti oha duamiu na vathe tapole ke tabu ke mono na ghod Molek ikoragna, moti hatia mua na ngungujugna na ghod vaitughu, Refan. Ighamu koti agutua na komi ngunguju iraani eigna kotida maimanihihira. Na vunegna iangeni, inau kuda vetulaghamu vano tagna ke hau sethevugna vano i Babilon.’” ");
INSERT INTO bgt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stiven ke velea mua, “Kori vido ara hutuda kena mono kori na meleha ke gou, imarea kena hulungia na vathe tapole ke tabu kena maimanihihia a God ikoragna. A God ke veleagna a Moses eigna keda agutua na vathe tapole iangeni, mi marea kena agutua leghuagna na totoghalegna a God ke tatelia vania a Moses. ");
INSERT INTO bgt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Leghugna iangeni, kori vido a Josua ke batura, ara hutuda kena hatia na vidoi thepa a God ke gigi aura na komi tinoni itagna. Kori vido kena vano kori meleha iangeni, imarea kena talu hatia duadia mua na vathe tapole ke hera ara hutudia. Kori na vathe tapole iangeni ara hutuda kena maimanihihia a God me ghieghilei jufu mai na maghavugna a King Deved. ");
INSERT INTO bgt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Deved ke vatotogoa a God me kaea eigna keda agutua na Vathe ke Tabu vania imanea, na God nigna a Jekob. ");
INSERT INTO bgt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kari a Solomon, a dathegna a Deved, ke agutua na Vathe ke Tabu vania a God. ");
INSERT INTO bgt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Keana a God ke haluhadi puala me boi mono koragna na komi vathe kena agutua na komi tinoni. Sina profet ke risoa na komi haghore iraani a God ke velea, ");
INSERT INTO bgt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘I popo na pukuni sapegu, mi thepa na bali tatapagna na naegu. Na thagi vathe ke hava kotida agutu vaniu na? E vahothahaghinighamu na agutuagna sa vido bali mamatho nigua itagna. ");
INSERT INTO bgt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Eigna inau ku agutua na komi fata gougovu.’ ");
INSERT INTO bgt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stiven ke talu titiono mua me velera, “Pono puala na ulumiu! Na hehemiu ke vaghagna na komi tinoni bongihehe moti boi magnahaghinia na leghuagna na haghoregna God. Ighamu koti sokara pungusia hahali na Tarunga ke Tabu vaghagna vamua kena eia ara hutumiu i hau. ");
INSERT INTO bgt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ehava? E mono sikei profet i hau ara hutumiu kena boi vapara? Imarea kena vathehera na komi profet kena titiono eigna na maigna sina tinoni ke pukuni jino kori matagna a God. Imanea a Vahavi koti peroa moti vathehea. ");
INSERT INTO bgt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Toke ighamu kotida hatia ghohi na komi vetula nigna God tadia na komi enjel, ighamu koti boi leghua vamua!” ");
INSERT INTO bgt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kori vido mara kena nagho tadia mara Jiu kena rongovia nigna na titiono a Stiven, imarea kena dikatadia puala mena gigiria na keidia. ");
INSERT INTO bgt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Keana na Tarunga ke Tabu ke vonungia a Stiven. Imanea ke tada hadi i popo me reghia na siladagna God, me reghia mua a Jisas ke sokara kori madothogna. ");
INSERT INTO bgt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stiven ke veleragna, “Inau ku reghia na hughuta i popo ke hangavi ma na Dathei Tinoni ke sokara kori madothogna a God!” ");
INSERT INTO bgt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kori vido iangeni imarea kena ponotia na kulidia kori limadia mena ghuu heta. Gi ena raghe vano tagna a Stiven mena thotia. ");
INSERT INTO bgt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Imarea kena sarakia aua kosigna na meleha i Jerusalem mena turughu piri vathehea. Mara kena piapilau eigna a Stiven kena aua nidia na oopo mena bora kori naegna sina mane mathangani, na ahagna a Sol. ");
INSERT INTO bgt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kori vido kena piria, a Stiven ke tarai vaghagna iaani, “Lod Jisas, ko hati atua na tarungagu itamua.” ");
INSERT INTO bgt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Gi e torongaghi tuturu horu kori thepa me ghuu heta, “Lod, o talutavogha na fata ke dika iaani kena eia!” Imanea ke velea iaani gi e thehe. ");
INSERT INTO bgt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Kori ghaghanagna a Sol, na vatheheagna a Stiven, imarea kena eia na fata ke toke. Leghugna kena vathehea a Stiven, kekeha mane kena maimanihihia a God kena hatia na tonogna mena vano gilua. Imarea kena tangi heta eigna imanea. Turughu kori dani ke thehe a Stiven, mara puhidia mara Jiu kena turughu vaparara puala na komi tinoni kiloau i Jerusalem. Imarea gougovu kena ghogho vano tadia na komi meleha tadia e rua na provins i Jiudea mi Samaria. Mara na vetula vamua kena talu mono i Jerusalem. ");
INSERT INTO bgt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ma Sol ke turughu vadiadikalara na komi tinoni kiloau. Imanea ke haghe tadia na komi vathe me sarakira au na komi mane ma na vaivine kena vaututuni me bora haghe kori vathe tatari. ");
INSERT INTO bgt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na komi tinoni kena vaututuni kena ghogho sania i Jerusalem kena titionoa na Rorongo ke Toke eigna a Jisas tadia na komi meleha kena vano. ");
INSERT INTO bgt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip ke vano tagna sina meleha koragna na provins i Samaria me titiono vanira na komi tinoni eigna a Vahavi. ");
INSERT INTO bgt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kori vido kena reghia na komi reghithehe ke eia a Filip, imarea kena vaovarongo toetoke tagna na hava ke titiono imanea. ");
INSERT INTO bgt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filip ke gigi aura na komi tidatho itadia na komi tinoni ke sethe, ma na komi tidatho kena ghuu heta kori vido kena taveti au itadia. Ma Filip ke vatoke tabirura na komi tinoni ke lae na tonodia ba thehe na naedia. ");
INSERT INTO bgt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Na komi tinoni gougovu kori meleha iangeni kena totogo puala eigna na komi fata iraani. ");
INSERT INTO bgt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kori meleha iangeni sina mane ke mono, na ahagna a Saimon. Kori vido ke boi vano mua a Filip ngengeni, a Saimon ke eia na komi thagi tiatidatho ma na komi tinonidia i Samaria kene vere nidia puala itagna. Mi manea ke velera na komi tinoni imanea sina mane ke nagho. ");
INSERT INTO bgt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ma na komi tinoni gougovu kori meleha iangeni, turughu tadia mara kena kuma me jufu tadia mara kena padarongo, kena vaovarongo itagna mena velea na mana nigna a God ke mono itagna. Imarea kena kiloagna “Na Mana Hutu.” ");
INSERT INTO bgt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Na komi tinoni kena vaovarongo itagna na vunegna e hau puala ghohi imanea ke eia na komi thagi tiatidatho irangeni. ");
INSERT INTO bgt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kori vido a Filip ke titionoa na Rorongo ke Toke eigna a Lod Jisas Krais ma na havi ke vunaghi pungusia a God, sethe na mane ma na vaivine kena vaututuni mena siuvitabu. ");
INSERT INTO bgt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Gi a Saimon ke vaututuni mua me siuvitabu. Leghugna iangeni imanea ke mono duagna Filip hahali me vere nigna puala tagna na komi reghithehe ke eia imanea. ");
INSERT INTO bgt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kori vido kena rongovia sethe na tinoni i Samaria kena vaututunia na rorongogna a Lod, mara na vetula kena mono i Jerusalem kena vetulara vano a Pita ma Jon itadia. ");
INSERT INTO bgt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kori vido koro jufu vano ngengeni, iromara koro tarai eigna kedana hatia na Tarunga ke Tabu, ");
INSERT INTO bgt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","eigna na Tarunga ke Tabu ke boi horu mai mua itadia. Imarea kena siuvitabu vamua kori ahagna a Lod Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Gi a Pita ma Jon koro tabora na uludia na komi tinoni kena vaututuni iraani, mena hatia na Tarunga ke Tabu. ");
INSERT INTO bgt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon ke reghia na Tarunga ke Tabu ke mai itadia na komi tinoni kori vido mara na vetula kena tabora na uludia. Mi manea ke hati maia na rongo tadia iromara Pita ma Jon ");
INSERT INTO bgt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","me velera, “Oro heu mai na mana iaani eigna kori vido inau kuda tabora na uludia na komi tinoni, imarea kedana hatia na Tarunga ke Tabu.” ");
INSERT INTO bgt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kari a Pita ke veleagna, “Na vunegna ighoe ko ghaghana ko tangomana na voliagna na hava a God ke hai hera vamua na komi tinoni, e toke gi a God keda diadikalagho duagna nimua na rongo! ");
INSERT INTO bgt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ighoe boi tangomana koda mono duamami kori nimami na agutu kiti ei vania a God, eigna na ghaghanamu ke boi jino kori matagna God. ");
INSERT INTO bgt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","O tughua na komi nimua toatogha ke dika, mo tarai kaea a God eigna keda talutavogha na komi nimua toatogha ke dika. ");
INSERT INTO bgt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Inau ku adoa ighoe ko pukuni tahotha puala ma na komi koakoa ke vunaghi pungusia na havimu.” ");
INSERT INTO bgt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon ke haghore tughua, “Oro tarai tagna a Lod eigu inau, eigna keda boi katheu na komi fata koro titionoa.” ");
INSERT INTO bgt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Leghugna a Pita ma Jon koro titionoa na rorongogna a Lod ngengeni, iromara koro turughu taveti tabiru i Jerusalem. Kori vido koro taveti vano, iromara koro vano tadia sethe na meleha i Samaria moro titionoa na Rorongo ke Toke. ");
INSERT INTO bgt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Sina maghavu, na enjel nigna a Lod ke veleagna Filip, “O vano mo leghua na hangana ke turughu i Jerusalem me vano horu i Gasa. Na hangana iangeni ke vano hotaghigna na meleha ke gou.” ");
INSERT INTO bgt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ma Filip ke kaikaliti me taveti au. Kori hangana iangeni imanea ke pada sina manegna Itiopif Na mane iangeni, sina mane puhi ke reireghia nigna na rongo a Kandake, na Queen gna i Itiopia. Imanea ke vano ghohi i Jerusalem me maimanihihia a God, ");
INSERT INTO bgt_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","mi kori vido iangeni imanea ke taveti tabiru kori melehagna. Imanea ke nohe popogna na sape ke kiaria na hos me ijumia na rioriso ke risoa a profet Aisaia. ");
INSERT INTO bgt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ma na Tarunga ke Tabu ke veleagna Filip, “O vano tagna na mane iangeni mo taetaveti ghaghireigna.” ");
INSERT INTO bgt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","A Filip ke raghe vano hilighagna me rongovia imanea ke ijumia na Rioriso ke Tabu ke risoa a profet Aisaia. Gi e huatia, “O thaothadoghagna mua na hava ko ijumia geri?” ");
INSERT INTO bgt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mi manea ke haghore tughua, “Ehava mu thaothadoghagna keda boi unuhia vaniu sa tinoni na ghaghanagna na?” Gi manea ke kaea a Filip eigna keda hahaghe duagna. ");
INSERT INTO bgt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na thevugna na Rioriso ke Tabu ke ijumia imanea iaani: “Imarea kena hati vanoa imanea vaghagna kena hati vanoa na sip bali vathehea. Vaghagna vamua na dathei sip ke boi tangi kori vido kena utuhia na sesehugna, imanea ke boi velea sa haghore. ");
INSERT INTO bgt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Imarea kena vamaomamoa ma na komi fata kena eia itagna ke boi jino. Teo ahai ke tangomana na titionoa ara kukuagna, eigna imanea ke teo sa dathegna kori vido kena vathehea.” ");
INSERT INTO bgt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Na mane puhi iangeni ke huatia a Filip, “O veleu, a Aisaia ke titionoa imanea ghehegna ba sa tinoni tavogha?” ");
INSERT INTO bgt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filip ke kidi unuhia vania na thevugna na Rioriso ke Tabu iaani, gi e titionoa na Rorongo ke Toke eigna a Jisas vania imanea. ");
INSERT INTO bgt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Iromara koro talu taveti vano kori hangana moro mai laba tagna sina bea. Ma na mane puhi iangeni ke velea, “O reghia! Na bea iaani. Na hava ke vasotou gi kuda boi siuvitabu ikeagaieni?” ");
INSERT INTO bgt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mi manea ke veleagna nigna na mane agutu eigna keda vasotoa na hos. Gi oro vano horu kori bea ma a Filip ke siuvitabua. ");
INSERT INTO bgt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kori vido koro au sania na bea, na Tarunga ke Tabu nigna a Lod ke hati aua a Filip, ma na mane puhi iangeni ke boi ghoi reghia mua a Filip. Keana imanea ke talu taveti vano kori melehagna me totogo puala. ");
INSERT INTO bgt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Sa fata vano keari a Filip ke jufu kori meleha i Asotus. Mi manea ke titionoa na Rorongo ke Toke ngengeni, mi tadia na komi meleha gougovu ke labangira me ghieghilei jufu i Sisaria. ");
INSERT INTO bgt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kori vido iangeni a Sol ke talu haghore heta eigna keda vathehera na komi tinoni kena leghua a Lod. Imanea ke vano tagna na pukuni naghoi pris ");
INSERT INTO bgt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","me kaea eigna keda risoa kekeha letasi vanira mara kena baubatu tadia na komi vathe haidu nidia mara Jiu kori meleha i Damaskus. Sol ke eia iaani eigna ke magnahaghina keda thotira me hatira vano i Jerusalem na komi mane ma na koi vaivine kena leghua na Hangana ke Tutuni kori meleha iangeni. ");
INSERT INTO bgt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","A Sol duadia kekeha mane kena taetaveti vano mi kori vido ke mai gharania i Damaskus, na raraha ke siasilada puala ke silada horu mai i popo me laema kililivia a Sol. ");
INSERT INTO bgt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Imanea ke sikili horu kori thepa me rongovia na ohai haghore ke veleagna, “Sol, Sol, Ehava gi o vaparau na?” ");
INSERT INTO bgt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ma Sol ke huatia, “Lod, ahai ighoe na?” Mi manea ke velea, “Inau a Jisas ko vaparau. ");
INSERT INTO bgt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","O sokara hadi mo vano kori na meleha. Sina tinoni ngengeni keda velegho na hava koda eia.” ");
INSERT INTO bgt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mara gougovu kena taveti duagna a Sol kena vere nidia mena mono bughoro. Imarea kena rongovia na ohai haghore kari ena boi dorovia sa tinoni! ");
INSERT INTO bgt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","A Sol ke sokara hadi gi e buta na matagna, kari e boi tangomana na reghiagna sa fata. Imarea kena tangolia na limagna mena batua vanoa i Damaskus. ");
INSERT INTO bgt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Koragna e tolu na dani imanea ke doa me boi vanga me boi kou. ");
INSERT INTO bgt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Sina mane ke vaututuni, na ahagna Ananaias, ke mono i Damaskus. A Lod ke tate vania me velea, “Ananaias!” Imanea ke haghore tughua, “Hee, Lod.” ");
INSERT INTO bgt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Gi a Lod ke veleagna, “O kaikaliti mo vano kori vathegna Jiudas ke mono kori hangana kena kiloagna ‘na Hangana Jino.’ Mo huatia eigna sina manegna i Tasus, na ahagna Sol. Ikeagaieni imanea ke tarai. ");
INSERT INTO bgt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Me dorovia ghohi sina mane kori salingau, na ahagna a Ananaias, ke mai me tangolia eigna keda ghoi reirei.” ");
INSERT INTO bgt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Keana a Ananaias ke veleagna, “Lod, sethe na tinoni kena titiono vaniu eigna na mane iaani ma na komi fata ke dika ke eia itadia nimua na komi tinonidia i Jerusalem. ");
INSERT INTO bgt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ikeagaieni imanea ke mai eeni, ma na mara na naghoi pris kena lubatia eigna keda thotira na komi tinoni gougovu kena vaututunigho i Damaskus.” ");
INSERT INTO bgt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kari a Lod ke veleagna, “O vano! Eigna inau ku vahia a Sol eigna keda agutu vaniu. Imanea keda titiono eigu inau tadia na komi tinoni kena boi Jiu mi tadia na komi king mi tadia na komi tinonidia Israel. ");
INSERT INTO bgt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi nau kuda vathaothadogha imanea eigna na komi papara hutu keda kathea kori vido imanea keda titiono eigu inau.” ");
INSERT INTO bgt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ma Ananaias ke taveti vano kori vathe ke mono a Sol me haghe. Me tangolia me veleagna, “Tahigu Sol, a Lod Jisas ke vetulau mai itamua. Imanea na mane ke tate vanigho kori hangana. Imanea ke vetulau mai eigna koda ghoi reirei tabiru ma na Tarunga ke Tabu keda haghevigho.” ");
INSERT INTO bgt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kori vido iangeni na fata ke vaghagna na vurugna na igha ke sikili horu kori matagna a Sol gi e ghoi reirei. Imanea ke sokara hadi me siuvitabu. ");
INSERT INTO bgt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Govu, gi e vanga ma na tonogna ke ghoi heta tabiru. Sol ke mono kekeha dani i Damaskus duadia na komi tinoni kena vaututuni. ");
INSERT INTO bgt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kori vido iangeni, imanea ke turughu titiono eigna Jisas tadia na komi vathe haidu nidia mara Jiu. A Sol ke velera a Jisas a pukuni Dathegna God. ");
INSERT INTO bgt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Arahai kena rorongo itagna kena vere nidia puala mena velea, “Na mane iaani na mane ke vaparara na komi tinoni kena vaututunia a Jisas i Jerusalem! Ighami kiti toatogha imanea ke mai eeni bali thotira arahai kena vaututuni me hatira vano tadia mara na naghoi pris.” ");
INSERT INTO bgt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kari nigna na titiono a Sol eigna a Jisas ke heta vano mua. Kori vido imanea ke tatelia vanira na komi tinoni Jiu i Damaskus a Jisas a Vahavi, imarea kena boi tangomana na veleagna sa fata bali haghore peoa. ");
INSERT INTO bgt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Sethe na dani ke haliu atu, gi mara puhidia mara Jiu kena haidu mena vapuipuhi bali vathehea a Sol. ");
INSERT INTO bgt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kori dani ma na bongi imarea kena kaekalera na komi hagetha kori peogna na meleha iangeni. Gi kedana reghia a Sol, imarea kedana vathehea. Keana a Sol ke rongovia na hava kena haga eia itagna. ");
INSERT INTO bgt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Na vunegna iangeni, tagna sina bongi mara nigna na vaovarongo a Sol kena hatia vano tagna sina wida kori peogna na meleha, mena uli horua i thepa kori na lapa hutu. ");
INSERT INTO bgt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kori vido a Sol ke laba i Jerusalem, imanea ke magnahaghinia keda mono duadia na komi tinoni kena vaututuni. Kari imarea kena mataghunia eigna kena ghaghana imanea ke boi pukuni vaututunia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kari a Banabas ke talangia vanoa tadia mara na vetula me velera a Sol ke reghia a Lod kori na hangana i Damaskus ma a Lod ke haghore vania. Ma Banabas ke velera mua a Sol ke boi mataghu na titionoagna a Jisas i Damaskus. ");
INSERT INTO bgt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Gi mara na vetula kena vaututunia, ma Sol ke mono duadia hahali. Imanea ke vano ivei mi vei i Jerusalem me boi mataghu na titionoagna a Lod. ");
INSERT INTO bgt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A Sol ke titiono me rihu haohaghore duadia mara Jiu kena haghorea na haghore Grik, kari imarea kena hiroa na puhi bali vathehea. ");
INSERT INTO bgt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kori vido na komi tinoni kena vaututuni kena rongovia iaani, imarea kena talangi vanoa a Sol i Sisaria gi ena vetula vanoa kori melehagna i Tasus. ");
INSERT INTO bgt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Leghugna iangeni, na komi tinoni kiloau tadia e tolu na provins i Jiudea mi Galili mi Samaria kena mono kori soleana. A God ke vaheta nidia na vaututuni me sethe na tinoni mua kena vaututuni. Imarea kena ghaghana bohea a God kori havidia ma na Tarunga ke Tabu ke vaheta na ghaghanadia. ");
INSERT INTO bgt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ke taveti vano tadia na komi meleha ke sethe eigna keda reghira na komi tinoni kena vaututuni. Me vano jufu tadia na komi tinoni nigna a Lod kena mono i Lida. ");
INSERT INTO bgt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Imanea ke pada sina mane ke lae na tonogna ingengeni, na ahagna a Ainias. E alu na vinogha ghohi, imanea ke nere vamua kori mathagna. ");
INSERT INTO bgt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","A Pita ke veleagna, “Ainias, a Jisas Krais ke vatoke tabirugho! O sokara hadi mo lopoa na mathamu.” Kori vido iangeni vamua a Ainias ke sokara hadi. ");
INSERT INTO bgt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Na komi tinoni kena mono i Lida mi Saron kena reghia Ainias, me sethe itadia kena vaututunia a Lod. ");
INSERT INTO bgt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kori meleha i Jopa ke mono sina vaivine ke vaututuni, na ahagna a Tabita. Na ahagna kori haghore Grik, a Dokas. Iia ke eia hahali na komi fata ke toke me hathera arahai kena kuma. ");
INSERT INTO bgt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kori vido a Pita ke mono i Lida, iia ke pada na vahaghi me thehe. Imarea kena kalitia na tonogna bali gilua gi ena hati hadia tagna sina chogho kori vathegna. ");
INSERT INTO bgt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na komi tinoni kena vaututuni ngengeni kena rongovia a Pita ke mono i Lida ke gharania i Jopa. Mena vetulara vano e rua na mane bali vano kae huhurua a Pita eigna keda mai saisami. ");
INSERT INTO bgt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ma Pita ke vano duadia. Kori vido kena torongaghi mai, imarea kena hatia hadi kori chogho ke mono na tonogna a Dokas. Sethe na vaivine ke thehe ghohi ara taudia kena sokara kililivia Pita mena tangi. Iira kena tatelia itagna na komi oopo ma na komi pohe ke suki vanira a Dokas kori vido ke havi mua. ");
INSERT INTO bgt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita ke velera eigna kedana au gougovu kori na chogho iangeni, gi e torongaghi tuturu horu me tarai. Me rei vano kori na tonogna me velea, “Tabita, o sokara hadi!” Iia ke buta hadi me reghia a Pita me nohe hadi. ");
INSERT INTO bgt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita ke tangolia na limagna me vasokaraghinia gi e kilora mai na komi vaivine ke thehe ghohi ara taudia ma na komi tinoni kena vaututuni. Imanea ke tatelia vanira a Tabita ke havi tabiru ghohi. ");
INSERT INTO bgt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na komi tinoni gougovu i Jopa kena rongovia na rorongogna na reghithehe iaani, me sethe na tinoni kena vaututunia a Lod. ");
INSERT INTO bgt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ma Pita ke mono hau sina vido i Jopa kori vathegna a Saimon, na mane ke agutua kekeha fata kori ghuighuligna na kau. ");
INSERT INTO bgt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sina manegna Rom, na ahagna a Konilius, ke mono i Sisaria. Imanea sina vunaghi koragna na boo i soldia kena kiloagna “Na boo gna i Itali.” ");
INSERT INTO bgt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Imanea duadia na komi tinoni kena mono kori vathegna kena boi Jiu, kari ena ghaghana bohea a God. Imanea ke keukemu puala tadia na komi tinoni Jiu kena kuma, me tarai hahali tagna God. ");
INSERT INTO bgt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sina dani, nabagna tangi tolu kori hinaota, sina enjel nigna God ke tate vania me veleagna, “Konilius!” ");
INSERT INTO bgt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Imanea ke mataghu me buta vano tagna me velea, “Mane puhi, na hava ko magnahaghinia?” Ma na Enjel ke veleagna, “A God ke totogo eimu ighoe eigna ighoe ko tarai hahali mo hera na rongo tadia na komi tinoni kena kuma. ");
INSERT INTO bgt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","O vetulara vano kekeha mane i Jopa eigna kedana talangia mai sina mane na ahagna a Saimon Pita. ");
INSERT INTO bgt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Imanea ke mono duagna sina mane, ke ahagna mua a Saimon, na mane ke ado agutua kekeha fata kori ghuighuligna na kau. Vathegna imanea ke mono ghaghireigna na tahi.” ");
INSERT INTO bgt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kori vido ke taveti au na enjel, a Konilius ke kilora mai itagna e rua nigna na mane agutu me sina nigna soldia. Na soldia iaani ke ghaghana bohea a God. ");
INSERT INTO bgt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","A Konilius ke titiono vanira na komi fata na enjel ke veleagna, gi e vetulara vano i Jopa. ");
INSERT INTO bgt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na dani leghugna iangeni, nabagna hotaghi dani, tolu na mane iangeni kena taetaveti kori hangana mena mai gharania i Jopa. Kori vido iangeni, a Pita ke hadi popo i vathe bali tarai. ");
INSERT INTO bgt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Imanea ke rofo me haga vanga ghagna. Keana, kori vido kena kalitia na vanga, imanea ke reghia na salingau. ");
INSERT INTO bgt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Imanea ke reghia na maaloa ke hangavi, me reghia na fata ke vaghagna na pohe hutu kena uli horua kori thepa tagna e vati na kujukugna. ");
INSERT INTO bgt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Koragna na pohe hutu iangeni, sethe na thagi fata kaukagu ke mono, ma na komi poli, ma na komi doko, ma na komi thagi manu. ");
INSERT INTO bgt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Gi na ohai haghore ke veleagna, “Pita, o sokara hadi. Vathehera mo ghanira.” ");
INSERT INTO bgt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Keana a Pita ke velea, “Teo, Lod! Kori havigu doudolu, inau ku boi ghania sa fata ke lutia nimami na komi vetula ighami mara Jiu.” ");
INSERT INTO bgt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ma na ohai haghore ke ghoi velea, “Na vunegna a God ke velea na komi fata iraani e toke vamua bali vanga, o saghoi velea na komi fata iraani e boi toke.” ");
INSERT INTO bgt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Na titiono iaani ke tolu horu maigna tagna a Pita, gi na pohe hutu ke ghoi tabiru hadi kori maaloa. ");
INSERT INTO bgt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kori vido a Pita ke toatogha eigna na ghaghanagna na salingau ke tate mai itagna, tolu na mane ke vetulara vano a Konilius kena pada ghohi na vathegna a Saimon. Imarea kena sokara kosigna na hagetha kori peogna na vathe. ");
INSERT INTO bgt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Gi ena huatia sina tinoni kori vathe, “A Saimon Pita ke mono eeni ba teo?” ");
INSERT INTO bgt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kori vido a Pita ke talu hiohiroa mua na ghaghanagna na salingau, na Tarunga ke Tabu ke veleagna, “Tolu na mane kena mai hirogho. ");
INSERT INTO bgt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","O vano horu itadia mo saghoi ghaghana ruarua na vano duadia, eigna inau ku vetulara mai eeni.” ");
INSERT INTO bgt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Gi a Pita ke horu vano itadia me velera, “Inau na mane koti hirou. Ehava gi oti mai?” ");
INSERT INTO bgt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mi tolu mara kotolu veleagna, “A Konilius, na vunaghigna sina boo i soldia, ke vetulaghami mai. Imanea na mane jino me maimanihihia God. Ma na komi tinoni Jiu kena ghaghana bohea puala imanea. Sina enjel nigna a God ke veleagna gi keda kaegho ighoe bali atu kori vathegna eigna keda rongovia na hava koda velea ighoe.” ");
INSERT INTO bgt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ma Pita ke velera eigna kedana haghe mai kori vathe bali nere kori bongi iangeni. Kori vuevugheigna, imanea mi kekeha tinonigna i Jopa kena vaututuni kena taveti duadia tolu na mane irangeni. ");
INSERT INTO bgt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Sina dani leghugna iangeni, imarea kena jufu i Sisaria. A Konilius ke kilora mai ghohi kori vathegna ara vikegna mara kulagna, mena pitua a Pita. ");
INSERT INTO bgt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kori vido a Pita ke jufu vano, a Konilius ke torongaghi tuturu itagna me maimanihihia. ");
INSERT INTO bgt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Keana a Pita ke vasokaraghinia me veleagna, “O sokara hadi. Inau na tinoni vaghamu ighoe vamua.” ");
INSERT INTO bgt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita ma Konilius koro titiono kori vido koro haghe vano korai vathe tadia na komi tinoni ke kilora mai a Konilius. ");
INSERT INTO bgt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Gi a Pita ke velera, “Ighamu oti adoa ghohi, e boi jino kori nimami na komi vetula ighami mara Jiu kitida sighora ba mono duadia arahai kena boi Jiu. Keana a God ke tatelia vaniu ghohi e boi toke kuda toatogha kekeha tinoni kena boi naba kuda mono duadia. ");
INSERT INTO bgt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Iangeni na vunegna inau ku sasaa kuda mai kori vido imarea kena mai mena kaeu. Ikeagaieni inau ku magnahaghinia kuda adoa na vunegna ko kaeu bali mai.” ");
INSERT INTO bgt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ma Konilius ke haghore tughua, “Iaani na vatolugna na dani leghugna na dani inau ku tarai kori vathegu kori tangi tolu. Sa fata vano keari, sina mane ke siasilada nigna na poko ke sokara mai i naghogu. ");
INSERT INTO bgt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Me veleu, ‘God ke rongovia nimua na tarai me reghia na haehathe ko eia tadia na komi tinoni kena kuma. ");
INSERT INTO bgt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mo vetulara vano kekeha mane i Jopa eigna kedana talangia mai sina mane na ahagna a Saimon Pita. Imanea ke mono duagna sina mane, ke ahagna mua a Saimon, ke agutua kekeha fata kori ghuighuligna na kau. Vathegna imanea ke mono ghaghireigna na tahi.’ ");
INSERT INTO bgt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Iangeni na vunegna inau ku vetulara atu saisami e tolu na nigua mane agutu, me toke puala ighoe ko mai. Ikeagaieni, ighami gougovu kiti haidu eeni kori matagna a God bali rongovia na komi fata a Lod ke velegho eigna koda titionoa itamami.” ");
INSERT INTO bgt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Gi Pita ke titiono vanira vaghagna iaani, “Ikeagaieni inau ku thaothadoghagna ghohi, na komi tinoni gougovu ke nanaba vamua kori matagna God. ");
INSERT INTO bgt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","A God ke totogo eidia na komi tinoni gougovu kori maramagna kena ghaghana bohea mena eia na komi fata ke jino. ");
INSERT INTO bgt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ighamu koti adoa ghohi na rorongogna a God ke vetula tadia mara i Israel. Iangeni na Rorongo ke Toke ke velea na komi tinoni kedana tangomana na mono kori soleana duagna a God eigna na hava ke eia a Jisas. Ma Jisas ke vunaghi pungusira na komi tinoni gougovu. ");
INSERT INTO bgt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Moti adoa mua na hava ke tate mai kori provins i Jiudea, turughu kori meleha i Galili leghugna a Jon ke velera na komi tinoni eigna kedana siuvitabu. ");
INSERT INTO bgt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Na hava ke tate mai ke vaghagna iaani. A God ke hea Jisas gna Nasaret na Tarunga ke Tabu ma na mana. Govu, gi imanea ke taveti vano tadia sethe na meleha bali eia na komi fata ke toke me vatoke tabirura arahai kena papara saragna na mana nigna a Satan. A Jisas ke tangomana na eiagna iaani eigna a God ke mono duagna. ");
INSERT INTO bgt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ighami mara na vetula gougovu kiti reghia na komi fata gougovu ke eia imanea i Jerusalem mi tadia na komi meleha i Israel. Imarea kena vathehea kori ghaibabala, ");
INSERT INTO bgt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","keana kori vatolugna na dani a God ke vasokara tabirua me lubatira kekeha tinoni eigna kedana reghia. ");
INSERT INTO bgt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Boi na komi tinoni gougovu kena vaututuni kena reghia, keana ighami mara na vetula vamua ke kidi vahighami a God bali titiono vanira na komi tinoni eigna imanea. Ighami na komi tinoni kiti vanga miti kou duagna a Jisas leghugna ke sokara tabiru kori thehe. ");
INSERT INTO bgt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma Jisas ke veleghami eigna kitida titionoa na Rorongo ke Toke tadia na komi tinoni gougovu miti velera imanea na mane ke vahia a God eigna keda fatera arahai kena havi mua ma arahai kena thehe ghohi. ");
INSERT INTO bgt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ma na komi profet gougovu kena risoa eigna imanea tadia na komi Rioriso ke Tabu. Imarea kena risoa gi arahai kena vaututunia a Vahavi, a God keda talutavogha na komi paluhadia eigna na hava keda eia a Vahavi.” ");
INSERT INTO bgt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kori vido a Pita ke talu haohaghore mua, na Tarunga ke Tabu ke haghevira na komi tinoni kena rorongo itagna. ");
INSERT INTO bgt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Na komi tinoni Jiu kena vaututuni kena mai duagna Pita kena vere nidia puala eigna God ke hera ghua na Tarunga ke Tabu tadia arahai kena boi Jiu. ");
INSERT INTO bgt_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mara Jiu kena mono ngengeni kena adoa a God ke hera na Tarunga ke Tabu eigna kena rongovira imarea kena haohaghore tadia na komi haghore nidia arahai tavogha mena veletokea God. Ma Pita ke velera mara Jiu, ");
INSERT INTO bgt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Na komi tinoni iraani, a God ke hera na Tarunga ke Tabu vaghagna vamua ke heghita ighita. Teo ahai keda velea e boi jino katida siuvitabura.” ");
INSERT INTO bgt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Gi a Pita ke velera eigna kedana siuvitabu kori ahagna Jisas Krais. Leghugna kena siuvitabu, imarea kena kaea Pita eigna keda mono duadia kekeha dani mua. ");
INSERT INTO bgt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mara na vetula ma na komi tinoni kena vaututuni kena mono kori provins i Jiudea kena rongovia mara kena boi Jiu kena vaututunia na rorongogna a God eigna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pita ke vano i Jerusalem mi kori vido imanea ke jufu vano, kekeha mara Jiu kena vaututuni kena haghore diadikala imanea. ");
INSERT INTO bgt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Imarea kena veleagna, “E boi jino ighoe ko vano haghe kori vathedia arahai kena boi sogivaughithatha mo vanga duadia!” ");
INSERT INTO bgt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ma Pita ke titiono vanira na komi fata gougovu ke pada imanea. ");
INSERT INTO bgt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Imanea ke velea, “Inau ku mono kori meleha i Jopa, mi kori vido ku tarai sina dani, inau ku reghia na salingau. Inau ku reghia na maaloa ke hangavi mu reghia na fata ke vaghagna na pohe hutu kena uli horua kori thepa tagna e vati na kujukugna. Na fata iangeni ke horu mai itagua. ");
INSERT INTO bgt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kori vido ku dodoro koragna na pohe hutu iangeni, inau ku reghia sethe na thagi fata ke kaukagu, ma na komi poli, ma na komi doko, ma na komi thagi manu. ");
INSERT INTO bgt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Gi u rongovia na ohai haghore ke veleu, ‘Sokara hadi Pita. O vathehera mo ghanira!’ ");
INSERT INTO bgt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Keana, inau ku haghore tughua, ‘Teo Lod! Kori havigu doudolu, inau u boi ghania sa fata ke boi lubatighami kori nimami na komi vetula ighami mara Jiu.’ ");
INSERT INTO bgt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Keana na ohai haghore ke velea mua, ‘Na vunegna a God ke velea na komi fata iraani e toke vamua bali vanga, o saghoi velea na komi fata iraani e boi toke.’ ");
INSERT INTO bgt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Na titiono iaani ke tolu horu maigna itagua, gi na pohe hutu ma na komi fata ikoragna ke ghoi tabiru hadi kori maaloa. ");
INSERT INTO bgt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Kori vido vamua iangeni, e tolu na mane kena vetulara mai kalasu i Sisaria kena jufu mai kori na vathe ku mono itagna. ");
INSERT INTO bgt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ma na Tarunga ke Tabu ke veleu eigna kuda boi ghaghana ruarua na vano duadia. Ono na mane iraani kena vaututuni kena taetaveti duagu, miti vano duadia tolumara kori vathegna a Konilius i Sisaria. ");
INSERT INTO bgt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ma Konilius ke titiono vanighami sina enjel ke tate vania me veleagna, ‘O vetulara vano kekeha mane i Jopa eigna kedana talangia mai sina mane na ahagna Saimon Pita. ");
INSERT INTO bgt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Imanea keda titiono vanigho na rorongo keda vahavigho ighoe duamu na komi tinoni kena mono kori vathemu.’ ");
INSERT INTO bgt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Boi hau leghugna ku turughu titiono vanira, na Tarunga ke Tabu ke haghevira vaghagna vamua ke haghevighita i hau. ");
INSERT INTO bgt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Gi u togha tabirua na hava ke veleghita nida a Lod Jisas, ‘A Jon ke siuvitabura na komi tinoni kori bea, keana ighamu kotida siuvitabu kori Tarunga ke Tabu.’ ");
INSERT INTO bgt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na vunegna a God ke hera na Tarunga ke Tabu vaghagna vamua ke heghita kori vido kati vaututunia a Lod Jisas Krais, e boi jino gi kuda sokara pungusia nigna na vanohehe a God.” ");
INSERT INTO bgt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kori vido mara Jiu kena vaututuni kena rongovia na titiono ke eia a Pita, imarea kena boi haghore diadikala mua, kari ena veletoke vamua a God. Imarea kena velea, “Ikeagaieni, a God ke lubatira arahai kena boi Jiu eigna kedana tughua na havidia ke koakoa bali hatia na havi ke teo na govugna.” ");
INSERT INTO bgt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sethe na tinoni kena vaututuni kena ghogho sania i Jerusalem kori vido na komi tinoni ngengeni kena vaparara leghugna na theheagna a Stiven. Kekeha itadia kena vano jufu kori provins i Fonisia, na moumolu i Saiprus, ma na meleha Antiok kori provins i Siria. Imarea kena titionoa na Rorongo ke Toke, kari tadia arahai kena Jiu vamua. ");
INSERT INTO bgt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Keana kekeha mara kena vaututuni kori moumolu i Saiprus ma na meleha i Sairin kena vano kori meleha i Antiok mena titionoa na Rorongo ke Toke eigna a Lod Jisas tadia arahai kena boi Jiu. ");
INSERT INTO bgt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na mana nigna God ke mono itadia, me sethe na tinoni kena vaututuni mena turughu leghua a Lod. ");
INSERT INTO bgt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na komi tinoni kiloau i Jerusalem kena rongovia na rorongo iaani, mena vetula vano a Banabas i Antiok. ");
INSERT INTO bgt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Imanea ke totogogna puala kori vido ke torongaghi vano i Antiok me reghia na hava a God ke ei vanira na komi tinoni kena vaututuni ngengeni eigna ke dothovira. Imanea ke vaheta na ghaghanadia eigna kedana leghua a Lod kori hetadia gougovu. ");
INSERT INTO bgt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Me sethe na tinoni i Antiok kena vautunia a God eigna Banabas na mane toke, ma nigna na vaututuni ke heta, ma na Tarunga ke Tabu ke vonungia. ");
INSERT INTO bgt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Gi a Banabas ke taveti au i Antiok me vano hiroa a Pol i Tasas. ");
INSERT INTO bgt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kori vido ke vano pada, imanea ke hati tabirua maia i Antiok, moro mono duadia na komi tinoni kiloau ngengeni. Sina vinogha doudolu koro mono ngengeni me sethe na tinoni koro velepuhira. Antiok na meleha na komi tinoni kena kidi kiloragna arahai kena vaututuni, “Na komi tinoni nigna a Krais.” ");
INSERT INTO bgt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kori vido iangeni kekeha profet kena vaututuni kena turughu mai i Jerusalem mena vano i Antiok. ");
INSERT INTO bgt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Sikei itadia, na ahagna Agabus. Kori nigna mana na Tarunga ke Tabu, imanea ke titiono au na maghavugna na teo vanga keda padara na komi meleha gougovu ke vunaghi pungusira mara i Rom. (Iaani ke tate mai kori vido a Klodius na King gna i Rom.) ");
INSERT INTO bgt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ma na komi tinoni kena vaututuni i Antiok kena toatogha kedana eia sa haehathe tadia mara kena vaututuni i Jiudea. Imarea gougovu kena kalitia na rongo leghuagna e ngiha na rongo kena tonogna. ");
INSERT INTO bgt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Gi ena hera Banabas ma Sol nidia na dotho eigna koroda hatia vano itadia mara kena baubatu kori kiloau i Jerusalem. ");
INSERT INTO bgt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kori vido iangeni, a King Herod Agripa ke vaparara kekeha tinoni kiloau. ");
INSERT INTO bgt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Imanea ke velera mara na soldia eigna kedana vihukia na luagna a Jemes, a tahigna a Jon. ");
INSERT INTO bgt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kori vido a Herod ke reghira mara puhidia mara Jiu kena magnahaghinia na hava ke eia, imanea ke thotia a Pita. Imanea ke eia iaani kori vido mara Jiu kena eia na Laulahugna na Bred ke Teo sa Isi Ikoragna. ");
INSERT INTO bgt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Imarea kena boa kori vathe tatari me vati na boo i soldia kena kaekalea. E vati na soldia kena mono itagna sina boo. Herod ke toatogha keda fatea a Pita naghodia mara Jiu leghugna na Laulahugna na Thovoliungi. ");
INSERT INTO bgt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kori vido ke mono a Pita korai vathe tatari, na komi tinoni kiloau kena tarai heta tagna God eigna imanea. ");
INSERT INTO bgt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kori bongi gi e jufu mai na dani a Herod keda fatea imanea, a Pita ke nere hotaghidia e rua na soldia. Rua na sen koro taria kori limagna a Pita gi oro taria kori limadia. Kekeha soldia mua kena kaekalea na hagethagna na vathe tatari. ");
INSERT INTO bgt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sa fata vano keari, sina enjel nigna a Lod ke tate mai ma na laema ke raraha kori vido ke mono a Pita. Na enjel ke chokua kori sokugna me raraia. Imanea ke veleagna, “O saisami mo sokara hadi!” Kori vido vamua iangeni, e rua na sen ke sikili horu kori limagna a Pita. ");
INSERT INTO bgt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Gi na enjel ke veleagna, “O vahaghea nimua na poko ma na sadol.” Pita ke eia iangeni gi na enjel ke velea mua, “O vahaghea nimua na oopo mo leghuu inau.” ");
INSERT INTO bgt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita ke leghua na enjel, keana a Pita ke toatogha ke maumaturungita vamua me boi adoa na komi fata ke eia na enjel ke pukuni tutuni. ");
INSERT INTO bgt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Iromara koro taetaveti liungia ghohi e rua na boo i soldia moro mai kori hagetha ke aian kori naghogna na peogna na vathe tatari. Ma na hagetha iangeni ke hangavi ghehegna moro taveti au i kosi. Iromara koro taetaveti vano sina ghathi vido iso kori hangana, gi na enjel ke saisami taveti sania. ");
INSERT INTO bgt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kori vido iangeni a Pita ke thaothadoghagna na hava ke tate mai me velea, “Ikeagaieni inau ku pukuni adoa a Lod ke vetula nigna na enjel bali vahaviu tagna Herod ma na komi fata kena haga eia itagua mara puhidia mara Jiu.” ");
INSERT INTO bgt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kori vido a Pita ke thaothadoghagna a God ke vamaumaluha, imanea ke vano kori vathegna a Meri, idogna a Jon Mak. Sethe na tinoni kena vaututuni kena haidu ngengeni mena tarai. ");
INSERT INTO bgt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","A Pita ke kiokido kori hagethagna na peogna na vathe, ma na vaivine mathangani ke agutu kori vathe iangeni, na ahagna a Roda, ke mai bali hangavia na hagetha. ");
INSERT INTO bgt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Keana kori vido ke rongovia na haghoregna a Pita, iia ke totogo nigna puala me havaghinia na hangaviagna na hagetha. Iia ke ghoi raghe tabiru korai vathe me velea, “Pita ke sokara kori hagethagna na peo!” ");
INSERT INTO bgt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Keana imarea kena boi vaututunia mena veleagna, “O mee!” Keana na vunegna iia ke talu hetaghagna, imarea kena velea, “Da na enjel bali reireghia a Pita ke mai.” ");
INSERT INTO bgt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pita ke talu kiokido mua mena ghieghilei hangavia na hagetha vania. Kori vido kena reghia, imarea kena vere nidia puala. ");
INSERT INTO bgt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Gi Pita ke tuhu hadia na limagna eigna kedana bughoro, me velera na hava ke eia a Lod kori hati auagna kori vathe tatari. Imanea ke velera eigna kedana titionoa na fata iaani tagna Jemes ma na komi tinoni kena vaututuni. Gi a Pita ke taveti au me vano tagna na meleha ke tavogha. ");
INSERT INTO bgt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kori vuevugheigna hadi, mara na soldia kori vathe tatari kena hahi hehedia puala eigna na hava ke pada a Pita. ");
INSERT INTO bgt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod ke velera komi nigna na soldia eigna kedana hiroa a Pita kari ena boi pada. Imanea ke huatira na komi soldia kena kaekalea a Pita, gi e velera kekeha soldia tavogha eigna kedana hatira vano bali vathehera. Leghugna iangeni a Herod ke taveti au i Jiudea me vano i Sisaria me mono ngengeni sina vido. ");
INSERT INTO bgt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod ke dikatagna puala tadia na komi tinonidia i Taia mi Saidon. Na vunegna ghadia na vanga na komi tinoni iraani ke mai kori meleha a Herod ke vunaghi pungusia, imarea kena vetulara vano kekeha mane puhi tagna a Herod eigna kedana vajinoa na ririhu varihotaghidia. Keana imarea kena kidi vano tagna Blastus, sina mane puhi ke agutu vania a Herod. Imarea kena kaea imanea eigna keda hathera, mi manea ke hiira. ");
INSERT INTO bgt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kori dani imanea ke talua bali eia na haidu duadia mara puhidia i Taia mi Saidon, a Herod ke vahaghea nigna na naghoi poko me nohe kori sapegna na king. Gi imanea ke eia na titiono itadia. ");
INSERT INTO bgt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Na komi tinoni kena rorongo itagna kena ghuu hadi vaghagna iaani, “Na mane iaani sina ghod, boi na tinoni!” ");
INSERT INTO bgt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kori vido vamua iangeni, sina enjel nigna God ke vavahaghia Herod eigna imanea ke boi velera na komi tinoni eigna kedana maimanihihia a God vamua. Boi hau leghugna iangeni na komi poipoli kena ghania me thehe. ");
INSERT INTO bgt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Na haghoregna a God eigna a Jisas ke rongoragha tadia na komi meleha me sethe na tinoni kena vaututuni. ");
INSERT INTO bgt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Leghugna a Banabas ma Sol koro hera na komi tinoni kiloau i Jerusalem nidia na rongo dotho mara i Antiok, romara koro tabiru vano i Antiok. Moro hatia a Jon Mak duadia. ");
INSERT INTO bgt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kekeha profet mi kekeha tinoni velepuhi kena mono tadia na komi tinoni kiloau i Antiok. Kekeha itadia a Banabas, Saimon, (kena kiloagna na mane jongo), Lusius (eigna Sairin), Sol, ma Manain (imanea ke hutu hadi duagna a King Herod Antipas kori vathegna). ");
INSERT INTO bgt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sina dani, kori vido mara iraani kena tarai mena sota kori vanga, na Tarunga ke Tabu ke velera, “Oti vahira a Banabas ma Sol bali eia na agutu ku vahira koroda eia.” ");
INSERT INTO bgt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kori vido kena vagovua na tarai ma na sota, imarea kena taofira a Banabas ma Sol, gi ena vetulara au. ");
INSERT INTO bgt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Leghugna na Tarunga ke Tabu ke vetulara au Banabas ma Sol, iromara koro taveti vano kori meleha i Selusia. Gi oro hahaghe kori vaka moro vano kori moumolu i Saiprus. ");
INSERT INTO bgt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kori vido koro torongaghi vano kori meleha i Salamis, iromara koro vano kori vathe haidu nidia mara Jiu moro titionoa na haghoregna a God eigna a Jisas. A Jon Mak ke taveti duadia bali hathera kori agutu. ");
INSERT INTO bgt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Imarea kena taveti vano sethevu i moumolu mena jufungia na meleha i Pafos. Ingengeni iromara koro pada sina mane Jiu, na ahagna a Bajisas. Imanea sina mane ke eia na komi thagi tiatidatho mi manea na profet piapilau. ");
INSERT INTO bgt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Imanea a kulagna a Segius Paolus, sina mane ke thaothadogha puala ke Primia kori moumolu iangeni. Na Primia ke kilora mai a Banabas ma Sol eigna ke magnahaghinia na rongoviagna na haghoregna God eigna a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kari Bajisas (kena kiloagna Elimas kori haghore Grik) ke sokara pungusira a Banabas ma Sol eigna ke bosi magnahaghinia a Segius Polas keda vaututunia a Jisas. ");
INSERT INTO bgt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kori vido iangeni, a Sol, kena kiloagna mua Pol, ke vonungia na Tarunga ke Tabu. Imanea ke rei vano tagna Elimas ");
INSERT INTO bgt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","me veleagna, “Ighoe a dathegna a Satan! Ighoe ke vonungigho na komi thagi piapilau ma na komi puhimu ke dika mo thevuioka tagna na komi fata ke toke. Ighoe teo koda soto na pilungiagna kililia na komi velepuhi ke tutuni eigna a Lod. ");
INSERT INTO bg